﻿USE sofia;
DROP TABLE IF EXISTS sofia.aia_vpl;
CREATE TABLE aia_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aia_vpl WRITE;
INSERT INTO aia_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Naani mamaani 'iniai burungana Jisas Kraest na huta mai baaniai burungana Deved mea Ebraham. ");
INSERT INTO aia_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","'Ia Ebraham naasi amana Aisak, 'ia Aisak amana Jekop, 'ia Jekop amana Jiuda miraaui do'orana'i, ");
INSERT INTO aia_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","'ia Jiuda amana Peres mia Sira (inadarua 'ia Tama). 'Ia Peres amana Hesron, 'ia Hesron amana Ram, ");
INSERT INTO aia_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","'ia Ram amana Aminadab, 'ia Aminadab amana Nason, 'ia Nason amana Salmon, ");
INSERT INTO aia_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","'ia Salmon amana Boas ('ia Rehab naasi inana). 'Ia Boas amana Obed (inana 'ia Rut), 'ia Obed amana Jesi, ");
INSERT INTO aia_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","'ia Jesi amana Mwaeraha Deved. 'Ia Deved amana Solomon (inana 'ia Batsiba, nararu ha'iwai ga'u a Uraea). ");
INSERT INTO aia_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","'Ia Solomon amana Rehobom, 'ia Rehobom amana Abaeja, 'ia Abaeja amana 'Asa, ");
INSERT INTO aia_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","'ia 'Asa amana Jehosofat, 'ia Jehosofat amana Joram, 'ia Joram amana Usaea, ");
INSERT INTO aia_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","'ia Usaea amana Jotam, 'ia Jotam amana Ehas, 'ia Ehas amana Hesikaea, ");
INSERT INTO aia_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","'ia Hesikaea amana Manase, 'ia Manase amana Amon, 'ia Amon amana Josaea, ");
INSERT INTO aia_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","'ia Josaea amana Jekonaea miraaui do'orana'i. Rau huta gaarangiai madoraa ra wairaaui Israel 'ari na'i Babilon 'anai ha'i slev 'iniraau. ");
INSERT INTO aia_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Na'i murinai wairaau ada i Israel 'ari Babilon 'ia Jekonaea amana Saltiel, 'ia Saltiel amana Serababel, ");
INSERT INTO aia_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","'ia Serababel amana Abiud, 'ia Abiud amana Elaeakim, 'ia Elaeakim amana Aso, ");
INSERT INTO aia_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","'ia Aso amana Sadok, 'ia Sadok amana Akim, 'ia Akim amana Eliud, ");
INSERT INTO aia_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","'ia Eliud amana Eleasa, 'ia Eleasa amana Matan, 'ia Matan amana Jekop, ");
INSERT INTO aia_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","'ia Jekop amana Josep, mwane ana Meri. 'Ia Meri inana Jisas nara 'unua 'iniai Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","'E ta'i tangahuru mana hai ugui inoni tahamora beia Ebraham tari beia Deved, ma'e ta'i tangahuru mana hai ro'u tahamora beia Deved tari madoraa ra wairaaui Israel 'ari Babilon. Mana tahamora na'i 'ohasi tari 'oha na huta i Ha'atahi 'e ta'i tangahuru mana hai ugui inoni ro'u. ");
INSERT INTO aia_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Naani mamaani 'iniai huta ana mai a Jisas Kraest. 'Ia Meri inana Jisas, ra durua tanaa i mwane na atana 'ia Josep. Na'i na'o ma rarugu ha'iwai, ra sadoia do'a to'ora 'iniai mena anai Hi'ona Maea. ");
INSERT INTO aia_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","'Ia Josep nara duruduru tanaa 'anai waina Meri, 'e sae odo-odo. 'A 'adoma'inia do'ai horosiai duruduru ana ma ai'a raba haua beiai rongo raha, 'inia 'a ai'a raba ha'animaia Meri na'i maadaaui noni. ");
INSERT INTO aia_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Na'i 'oha na wai'ado'ado mau suriai mahosi, 'e enjel ana God 'a ha'ata'i tanaa na'i mauru'aa. 'A o'ani 'inia, “Josep baaniai burungana Deved, 'oi abui ha'ata'aiai 'adoma'imu 'anai waina Meri. 'Inia ni rurua na haua 'iniai gare, 'a to'o 'iniai mena anai Hi'ona Maea. ");
INSERT INTO aia_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mana'i 'oha nai huta mai garesi, 'oi ha'a-atana 'inia Jisas, 'inia 'iia 'ai ruhasiraaui sae ana'i baani'i ora-ora'a adaa'i.” ");
INSERT INTO aia_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Naasi duruduru ana God 'a to'o ha'a-momori'a 'onaai taha na ha'ateenga'inia Araha God na'i ngoonai rarabea o'ani, ");
INSERT INTO aia_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“'E gere urao na ai'a mauru goni mau beia ta mwane nai rurua, ma'ai ha'ahutaa ta gare mwane marai 'unua 'inia Imanuel. Ni 'ado'ado 'anai ata naasi, 'ia God 'a awa beigia.” ");
INSERT INTO aia_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","'Oha 'ia Josep 'a rarai baaniai mauru, 'a haua 'onaai 'unua anai enjel ana Araha God. 'A waina Meri, ");
INSERT INTO aia_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ma'ata 'a ai'a mauru goni beia tari 'oha na ha'ahutaa i gare mwane ana. Mia Josep 'a ha'a-atana 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","'Ia Jisas 'a huta na'i Betlehem, 'e 'omaa na'i Provensi Jiudea 'oha na mwaeraha Herod. Ai'a orea mau ma ra'i sae madoma ra boi baaniai dora na ara'a iei sina ra ada na'i Jerusalem ");
INSERT INTO aia_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","mara heisonga'i o'ani, “Na'i hei na huta iei mwaeraha adaaui Jiu? Meu re'iai hee'u na'i dora na ara'a iei sina na ha'ata'iniai huta ana, mameu boi 'anai ha'arahesia.” ");
INSERT INTO aia_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na'i 'oha 'ia Herod 'a rongoa o'asi, 'a ta'aa di'u i 'adoma'ina, beiraau ro'u hakoi sae na'i Jerusalem. ");
INSERT INTO aia_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma 'unu goniraau mai Na'ohadaa'i Piriisi mana Ha'ausuri 'anai Ringe ana'ia Moses maagu songa'iniraau o'ani, “Na'i hei nai huta iei Ha'atahi?” ");
INSERT INTO aia_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Miraau o'ani, “Na'i Betlehem na'i Provensi Jiudea. 'Inia naasi maho na 'ia God na 'unua na'i ngoonai Rarabea o'ani, ");
INSERT INTO aia_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem, 'o ororiu di'u na'i Jiudea, 'inia baani'o nai hura'a mai mwaeraha nai marungiraaui noni agu'i, 'iraau Israel.’” ");
INSERT INTO aia_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mia Herod 'a 'unuraau girugiru moi sae madoma magu songa'iniraau 'iniai 'oha he'ua narau tahamora re'iai hee'u. ");
INSERT INTO aia_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","'A o'ani 'iniraau maagu ha'a-taariraau wou, “Moi 'ari Betlehem mamoi sibaniai garesi. 'Oha moi sadoia, moi aho'i mai 'ini 'anai ha'arangasia tanaau mawaigu 'ari ro'u wou 'anai ha'arahesia.” ");
INSERT INTO aia_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Marau 'ari, rau re'ia ro'u mau ta'i hee'u narau re'ia ga'u ani, 'a na'otaradaau. 'Agu papaku na'i ahoranai dora na awa iei gare. ");
INSERT INTO aia_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Rau wa'ewa'e raha di'u 'oha rau re'iai hee'u. ");
INSERT INTO aia_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Rau siri ruma marau re'iai gare beia inana 'ia Meri. Rau topira'i ruru marau ha'arahesia. Rau rahi'i hura'a i bane adaa'i marau banea tanaa i gol mana rua mareho si'ini goro nara 'unua 'inia franginsens mana myrrh. ");
INSERT INTO aia_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na'i muri, 'ia God 'a ha'abasuraau na'i mauru do rai abu aho'i 'ari beia Herod. Miraau aho'i wou na'i 'omaa adaau na'i tara he'ete'i. ");
INSERT INTO aia_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Murinai aho'i adaaui sae madoma, 'e enjel ana Araha God 'a ha'amaranga tanaa Josep na'i mauru. 'A o'ani 'inia, “Josep, 'oi rarai ma'oi waiai gare mia inana mamoi hora 'ari Ijip, 'inia Herod 'ai sibaniai gare 'anai ha'amaesia. Moi awa 'isi tari 'oha wai 'unua tana'o do moi aho'i mai 'ini.” ");
INSERT INTO aia_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mia Josep 'a rarai ma waiai gare mia inana na'i rodosi marau hano 'anai Ijip. ");
INSERT INTO aia_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Rau awa 'isi tari 'oha na mae a Herod. Rau haua o'asi 'anai ha'ato'oa ha'a-momori taha na 'unua Araha God na'i ngoonai Rarabea o'ani, “'Au 'unua hura'a i gare agua baaniai Ijip.” ");
INSERT INTO aia_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","'Oha 'ia Herod 'a sadoia do 'iraaui sae madoma rau pwari'ia'a, 'a taesu'a di'u i ahuna, ma atenga'inia dorai ngahu ha'amaesi'i hako mwane garemwane na'i Betlehem, taraawa'a na'i rua harisi ma dio, mana garemwane suri'i ro'u i 'omaa gaarangiai Betlehem. 'Ia Herod 'a haua o'asi suria 'iraaui sae madoma rau 'unua do 'e rua harisi na bwane hako murinai ha'ata'i na haa i hee'usi. ");
INSERT INTO aia_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na'i 'oha na haua o'asi a Herod, 'a to'o ha'a-momori'a i taha na 'unua Rarabea Jeremaea na o'ani, ");
INSERT INTO aia_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“'E angi uru-uru ra rongoa na'i 'omaai Ramaa. 'Ia Resel 'a angisiraaui gare ana'i ma ai'a 'irisia dorai ha'a-aroahuna, 'inia 'iraaui gare ana'i ra mae'a.” ");
INSERT INTO aia_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Murinai mae ana Herod, 'e enjel ana Araha God 'a ha'ata'i tanaa Josep na'i mauru na'i Ijip. ");
INSERT INTO aia_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","'A o'ani 'inia, “'Oi rarai ma'oi waiai gare mia inana mamoi aho'i 'ari Israel. 'Inia 'iraaui nei ra sibania 'anai ha'amaesia ra mae'a.” ");
INSERT INTO aia_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mia Josep 'a rarai ma waiai gare mia inana marau aho'i 'ari Israel. ");
INSERT INTO aia_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Na'i 'oha na 'ia Josep 'a rongoa do 'ia Akeleas 'a mwaeraha orisia amana 'ia Herod na'i Provensi Jiudea, 'a mamaa'uta'i aho'i 'ari Jiudea. Mana nata maho na 'omesia ro'u na'i nata mauru, ra 'unua wetewete tanaa do'ai 'ari Provensi Galili. ");
INSERT INTO aia_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Naasi rau 'ari marau awa na'i Nasaret ma ha'a-momori'a i taha nara 'unua i Rarabea o'ani, “Rai 'unua 'iniai ai Nasaret.” ");
INSERT INTO aia_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Muridi tara'i harisi ra hako, 'ia Jon Bwareomaea 'a taraawa'a taroha'inia hura'ai ha'atee ana God na'i dora mangasara na'i Provensi Jiudea. ");
INSERT INTO aia_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","'A o'ani, “Moi rihosi baani'i ora-ora'a amoo'i, 'inia ni madoraa na 'ia God 'ai marungiraaui noni ana'i 'a gaarangi'a.” ");
INSERT INTO aia_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","'Ia Jon naasia mo'o na 'ia rarabea Aisaea 'a ha'ateenga'inia mau mai o'ani na'i 'oha bwani, “'E nei nai totoro hura'a na'i dora mangasara. 'Ai ha'atee o'ani, ‘Moi ha'aagau! 'Ia Araha 'a gaarangi boi'a. Moi ha'a-odoodoai tara tanaa.’” ");
INSERT INTO aia_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","'Ia Jon 'a awa 'onaai huunai rarabea. 'A ho'owa'a 'ini'i bwana ra tau'arodi 'ini'i warihui kamel, ma rorowa'a 'iniai rorowa'a nara tau'arona 'iniai uri-uri mwamwaa mana mahoingau ana'i naasi ngabo mana modi'o ni hasimou. ");
INSERT INTO aia_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","'Iraau saenai Jerusalem, ma ra'i sae baaniai Provensi Jiudea mana 'omaa gaarangiai wai rahai Jodan rau boi beia Jon ");
INSERT INTO aia_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","'anai ha'arangasi'i ora-ora'a adaa'i ma bwareomaearaau na'i wai Jodan. ");
INSERT INTO aia_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Na'i 'oha 'ia Jon 'a re'iraaui Farisei miraaui Sadiusi rau boi beia 'anai bwareomaearaau, 'a o'ani 'iniraau, “'I'amou mwane mwaa ta'a'i! 'A 'ua? Mou 'adoma'inia doni bwareomaea moi nai 'a'auhi'amou 'anai bainihu baaniai ha'a-mama'ai na 'ia God 'ai ha'ataaria mai? ");
INSERT INTO aia_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","'Onaa namou raba bwareomaea mamoi nugasi'i barongamoo'i nara ta'a'i, mamoi hau'i mareho goro nai ha'ata'inia domou rihosi baani'i ora-ora'a amoo'i. ");
INSERT INTO aia_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mou gasigu 'adoma'inia do'ia God 'a bwa'i ha'a-mama'ai'amou do 'iniai huta amoou mai 'onaai warowarona'i a Ebraham. 'Inau wai 'unua tana'amou, 'ia God 'a matai ha'a-aho'ita'ini'i hau 'ini, marai ha'i warowarona'i a Ebraham. ");
INSERT INTO aia_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","'Ia God 'a ha'aagau'a 'anai ha'a-mama'airaaui nei nara ai'a 'adoma'i orisi. 'A 'onaai nei na ha'aagau 'anai arai'i dioi mwane hasi'ei. 'Onaa nara bwa'i hungu 'ini'i hua goro, 'ai ara dio suri'i raridi mai gaasi'i ara'ai 'eu 'anai suu gata'ini'i. ");
INSERT INTO aia_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“'Inau 'au bwareomaea'amou 'inia moi wai 'anai ha'ata'inia domou orisi. 'Ia mo'o nai boi murigu 'ai bwareomaea'amou 'iniai Hi'ona Maea mana 'eu. 'Iia 'a ororiu di'uau. 'Inau ai'a arari 'anai daa'i tanaa i sandol ana'i 'onaai sae tatau'aro ana. ");
INSERT INTO aia_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","'Iia 'a ha'aagau 'anai hoairaaui noni goro baaniraaui nei ta'a'i, 'onaai nei na hoai'i koradi wiit ana'i baani'i kahokahodi. 'Iia 'ai nugaraaui noni goro na'i dora goro, ma'ai ha'a-mama'airaaui noni ta'a'i, 'onaai nei na nuga ha'agorohi'i koradi wiit ana'i na'i dora 'ada'i mana kahokahodi 'a suu gata'ini'i na'i 'eu na bwarai kuru.” ");
INSERT INTO aia_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mia Jisas 'a hano baaniai Galili ma 'ari wai Jodan do'ia Jon 'ai bwareomaeaa na'iei. ");
INSERT INTO aia_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","'Ia Jon 'a ai'a 'irisia o'asi ma o'ani, “Ni 'uaana na'ogu boi beiau 'inia 'anai bwareomaea? I'oe na'o ga'i bwareomaeau!” ");
INSERT INTO aia_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mia Jisas 'a o'ani 'inia, “Nugaa mai 'onaai 'unua agua. 'Igaraa garai haua ma'ata i hei'irisina God.” Naasi mia Jon 'agu bwareomaeaa Jisas. ");
INSERT INTO aia_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Na'i 'oha na 'ia Jisas 'a ara'a baaniai wai, i aro 'a heihoa ma 'omesiai Hi'ona Maea ana God 'a dio na'i hungana 'onaai waibora. ");
INSERT INTO aia_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma'e ringe na ao mai baaniai aro 'a o'ani, “Naani gare agua nau ta'ahia ororiu mau ahugoro 'inia.” ");
INSERT INTO aia_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mana Hi'ona Maea 'a waia Jisas 'ari dora mangasara do'ia Saetan 'ai ohongia. ");
INSERT INTO aia_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","'Ia Jisas 'a ai'a ngau suriai hai tangahurui dangi mana hai tangahurui rodo magu hioro. ");
INSERT INTO aia_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mia Saetan 'a boi beia ma o'ani 'inia, “'Onaa i'oe garena God, 'oi ha'atee tana'i hau 'ini marai aho'ita'i bredi.” ");
INSERT INTO aia_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mia Jisas 'a o'ani 'inia, “Na'i Usu-usu Maea ra usu o'ani, ‘I sae 'a bwa'i tahi moi 'iniai huai bredi, ma'ata 'inia ro'u i ha'atee ana God.’” ");
INSERT INTO aia_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mia Saetan 'a waia Jisas 'ari Jerusalem, 'i 'omaa nara 'unua ro'u 'iniai 'omaa maea. 'A ha'a-urasia na'i dora ahaaha na'i hunganai Ruma Maea ana God ");
INSERT INTO aia_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ma o'ani 'inia, “'Onaa i'oe garena God 'oi rege auru, 'inia ra usua na'i Usu-usu Maea o'ani, ‘'Ia God 'ai ha'a-taariraaui enjel ana'i 'anai 'a'auhi'o. Rai dau bwarasi'o 'ini'i rimadaa'i mana uwamu'i ra bwa'i maara 'ini'i hau.’” ");
INSERT INTO aia_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mia Jisas 'a aramia o'ani, “Mana Usu-usu Maea 'a 'unua ro'u o'ani, ‘Moi abui ha'imaania Araha God amoou.’” ");
INSERT INTO aia_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mia Saetan 'a waia Jisas ara'a na'i hunganai hungahunga ahaaha ma ha'ata'ini'i tanaai mwani kantri hako na'i marewana mana toto'ora adaa'i, ");
INSERT INTO aia_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ma o'ani 'inia, “Wai haa'i hako tana'o i mwane mareho 'ini 'onaa 'oi topira'i ruru tanaau ma'oi ha'arahesiau.” ");
INSERT INTO aia_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mia Jisas 'a o'ani, “'Ariwou baaniau Saetan! Ra usua na'i Usu-usu Maea o'ani, ‘Moi ha'arahesia moi Araha God amoou, me 'iia moi namoi tau'aro tanaa.’” ");
INSERT INTO aia_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mia Saetan 'a 'arita'inia Jisas miraaui enjel rau boi marau 'a'auhia. ");
INSERT INTO aia_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na'i 'oha na 'ia Jisas 'a rongoa do'ia Jon 'a awa na'i rumaniho'o, 'a aho'i 'ari Provensi Galili. ");
INSERT INTO aia_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ma'ata 'a ai'a awa na'i Nasaret, 'a 'ari na awa na'i Kapaniam na'i bobonai kae bwera i Galili, na'i dorai ano anai burungana Sebiulan mea Naftali. ");
INSERT INTO aia_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","'A haua o'asi ma to'o ha'a-momori'a i taha na 'unua Rarabea Aisaea o'ani, ");
INSERT INTO aia_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“'A ragoi nei nara ai'a Jiu narau awa na'i Galili, na'i dora nara 'unua ro'u 'iniai ano ana Sebiulan mea Naftali na'i gaarangiai kae bwera i Galili mana'i nata batarau 'iniai wai Jodan. ");
INSERT INTO aia_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","'Iraaui sae 'isi rau awa na'i kuhi, ma'ata ra re'ia'a i bewaa. Rau awa na'i mamaru ni mae, ma'ata i bewaa 'ai bewaasiraau.” ");
INSERT INTO aia_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mia Jisas 'a taraawa'a ha'ausuriraaui sae. 'A o'ani, “Moi rihosi, na heimarungi ana God na awa na'i aro, 'a gaarangi'a!” ");
INSERT INTO aia_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na'i 'oha 'ia Jisas 'a hahano na'i bobonai kae bwera i Galili, 'a 'omesiai rua ha'ido'orada, 'ia Saemon, nata ata 'ia Pita, mia Andru. Na'i 'ohasi, raru ahuasi 'iniai hu'o, suria 'iraruasi ra'i sae ahu-ahuasi. ");
INSERT INTO aia_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mia Jisas 'a o'ani, “Murui suriau! 'Onaai rau'i amuru'i ii'a na'i wai, 'a o'asi ro'u, wai ha'ausuri'amurua 'anai wai'i mai sae beiau.” ");
INSERT INTO aia_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na'i mau 'ohasi, raru nugasi'i hu'o adaru'i ma raru suria. ");
INSERT INTO aia_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mia Jisas 'a 'ariwou ma re'ia Jems mia Jon na'i ora beia amadarua 'ia Sebedi. Rau orima'ini'i hu'o adaa'i ma o'ani 'inirarua, “Murui suriau.” ");
INSERT INTO aia_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mararu 'arita'iniai amadarua beiai ora mararu hano beia Jisas. ");
INSERT INTO aia_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","'Ia Jisas 'a 'ari suri'i 'omaa na'i Galili ma ha'ausurirai sae suri'i rumani ha'arahesi adaa'i Jiu. 'A taroha'inia tanaraaui taroha goro 'iniai heimarungi ana God na awa na'i aro, ma ha'agorohiraau aho'i nei na to'iraau i mwane daoha he'ete'i hairiu. ");
INSERT INTO aia_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","I tarohana 'a 'adarara 'ari suriai mwane dora na'i Galili, tari 'ari na'i Provensi Siria. 'Iraaui sae na to'iraau i mwane daoha he'ete'i hairiu ma'ua ra rongomaata'i di'u, ra wairaau mai tanaa. Tara'i sae ra bwaunira i adaro, ma tara'i sae ra manumanu'a, ma tara'i sae ra mae hakoi uwadi. Ma'ata 'ia Jisas 'a ha'agorohiraau hako aho'i. ");
INSERT INTO aia_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","'E kae ruruha narau hano suria Jisas baani'i mwane dora he'ete'i hairiu. Tara'i nei baaniai Galili, mana'i Dekapolis, na'i Jerusalem mei Jiudea mana'i nata bataraui wai rahai Jodan. ");
INSERT INTO aia_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","'Oha 'ia Jisas 'a re'iai rago di'u adaaui sae nara hano suria, 'a hane ara'a na'i gere hungahunga ma heinagu auru. 'Iraaui rongoiusuri ana'i rau heinagu garigaria ");
INSERT INTO aia_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma ha'ausuriraau o'ani, ");
INSERT INTO aia_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“'Ia God 'ai ha'agorohiraaui nei ra 'u'uria suri'i mwani maho 'onaai sae na pohara. 'Iraau rai awa na'i bahainai heimarungi ana God na awa na'i aro. ");
INSERT INTO aia_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","'Ia God 'ai ha'agorohiraaui nei ra ahutotou. 'Ia God 'ai ha'a-aro'i ahudaa'i. ");
INSERT INTO aia_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","'Ia God 'ai ha'agorohiraaui nei ra awa manego. Rai daa'i mwani mareho goro na duruduru 'inia God. ");
INSERT INTO aia_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","'Ia God 'ai ha'agorohiraaui nei nara huunai raba awa odo-odo na'i maana, 'inia 'ia God 'ai haua tanaraau i taha nara 'irisiasi. ");
INSERT INTO aia_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","'Ia God 'ai ha'agorohiraaui nei rau ahu ta'ahira i nei nara awa ha-ha'aroha'a, 'inia 'ia God 'ai ahu ta'ahiraau ro'u. ");
INSERT INTO aia_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","'Ia God 'ai ha'agorohiraaui nei na tahingadaa'i ra odo-odo, 'inia rai re'ia God. ");
INSERT INTO aia_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","'Ia God 'ai ha'agorohiraaui nei nara ha'a-hagugoniraau goro i noni. 'Ia God 'ai 'unuraau 'ini'i gare ana'i. ");
INSERT INTO aia_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","'Ia God 'ai ha'agorohiraaui nei ra nora ta'airaau 'iniai haua adaaui taha na 'irisia God. 'Iraau rai awa na'i bahainai heimarungi ana God na awa na'i aro. ");
INSERT INTO aia_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“'Ia God 'ai ha'agorohi'amou na'i 'oha ra ha'atee ha'a-ta'ai'amou, mara nora ta'ai'amou mara 'unu'i mwane maho pwari'i 'ini'amou, suria 'i'amou ra'i rongoiusuri agu'i. ");
INSERT INTO aia_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","'Oha na o'asi, moi abui ahutotou, ma'ata moi wa'ewa'e, 'inia 'e heitahari na raha na 'ia God 'a ha'aagau mamasi'amou 'inia na'i aro. Mamoi abui kaku'aa do ra bwane nora ta'airaau o'asi'a ro'u i rarabea na'i 'ohabwani.” ");
INSERT INTO aia_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“'I'amou mou 'onaai solt tanaraaui inoni nai marewana. 'Onaa i solt 'agu bwa'i ngau asi'a'a, 'agu bwa'i here'a ro'u naraigui haua 'anai ha'a-asi'aa aho'i ro'u! 'A goro dorai rasaha'inia hura'a i 'omaa marai buu hunia. ");
INSERT INTO aia_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“'I'amou mou 'onaai raita na bewaasiraaui inoni nai marewana na 'iraau hako i sae ra re'ia 'onaai 'omaa nara tau'arona na'i hunganai hungahunga. ");
INSERT INTO aia_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bwa'i sae nai suungiai raita maigui nugaa na'i bahainai rabo'o. 'Ai nugaa ma'ata na'i dora 'ana mai marewasiraau hakoi sae na'i raronai ruma. ");
INSERT INTO aia_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","'A o'asi ro'u, moi abui giru'i baaniraaui noni here goro namou haa'i. Ma'ata moi ha'ata'ini'i hura'a 'onaai marewa marai re'i'i marai ha'a-aneanea Amamoou ara'ai aro 'inia.” ");
INSERT INTO aia_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Moi abui 'adoma'inia do 'inau 'au boi 'anai ha'a-ai'a'i Ringe ana'ia Moses mana ha'ausuringa'i adaa'i Rarabea. 'Au boi 'anai ha'ato'o'i huunai 'ado'ado 'ada'i. ");
INSERT INTO aia_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Aro mana ano 'ai anoro ma bwa'i ta gere dora na'i Ringe ana'ia Moses nai ai'aa. Mwane maho nara usu'i na'iei rai to'o hako. ");
INSERT INTO aia_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","'Onaa 'oi raesia ta gere dora na'i Ringe ana'ia Moses ma'oi ha'ausuriraau ro'u tara'i nei 'anai haua 'onaai haua amua, 'o bwa'i ororiu moe'a na'i hourana ni aro. Ma 'onaa 'oi ha'isuri'i hako ma'oi ha'ausuriraaui sae 'anai haua 'onaai haua amua, 'ia God 'ai ha'a-ororiu'o na'i hourana ni aro. ");
INSERT INTO aia_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","'Iraaui Farisei miraaui Ha'ausuri 'anai Ringe rau 'adoma'inia dorau odo-odo na'i maana God 'iniai suri'i adaa'i Ringe ana'ia Moses. Me 'onaa mou bwa'i odo-odo di'u baaniraau, mou bwa'i siri mwada'u na'i hourana ni aro.” ");
INSERT INTO aia_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mia Jisas 'a o'ani ro'u, “'I'amou mou bwane 'iraraai Ringe ana Moses na o'ani, ‘Abui heingahu, 'inia 'ia mo'o nai heingahu 'ai siri na'i hihiiri.’ ");
INSERT INTO aia_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma'ata, 'inau wai 'unua tana'amou, 'iatei nai taesu'a 'ana ta sae 'ai siri na'i hihiiri. Ma 'onaa 'iatei nai 'unu bweu 'inia ta sae, rai waia na'i Kansol 'anai 'i'ia. Ma 'iatei nai 'unu bwau kuhi 'inia ta sae 'a ta'isada dorai gaasia siri na'i 'eu na'i dora ni rongomaata'i. ");
INSERT INTO aia_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Naasi 'onaa 'o waai bane amua 'anai nugaa na'i hunganai dorani ho'asi na'i Ruma Maea ana God ma'ogu aidangisia do'e sae na taesu'a mumua, ");
INSERT INTO aia_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'oi nugaa ga'u i bane amua, ma'oi aho'i 'anai hagu aho'i beia mo'o na taesu'a mumua ma'oigui aho'i ro'u 'anai hauai bane amua tanaa God. ");
INSERT INTO aia_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ma 'onaa na sae na taesu'a mumua 'a raba wai'o na'i kooti, 'oi bonasia ha'a-arataraa raurau beia. 'A gasi taranga'ini'o tanaai sae hihiiri, mana sae hihiiri 'ai taranga'ini'o tanaai sae hehei'oi mai gaasi'o na'i rumaniho'o. ");
INSERT INTO aia_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Wai 'unua ha'a-momori tana'o, 'oi awa 'isi tari 'oha 'oi horia hakoi siha ha'a narai 'unua tana'o do'oi horia.” ");
INSERT INTO aia_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mia Jisas 'a o'ani ro'u, “'I'amou mou bwane 'iraraa i Ringe ana Moses na o'ani, ‘'Oi abui taritari'a baaniai urao amua ma'ua mwane amua.’ ");
INSERT INTO aia_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma'ata 'inau wai 'unua tana'amou, 'iatei na re'iai urao ma 'adoma'i sisiwa 'inia, 'iia 'a bwane taritari'a beia na'i 'adoma'ina. ");
INSERT INTO aia_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Naasi 'onaa na maa odomu nai haai maho na'o ora-ora'a 'inia, 'oi suki gaasia hura'a moi. 'A goro do'oi ha'a-ai'aa ta ta'i dorai abe moi, baaniai abemu hako nai siri na'i 'eu na'i dora ni rongomaata'i. ");
INSERT INTO aia_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma 'onaa na rima odomu nai haai maho na'o ora-ora'a 'inia, 'oi horosia ma'oi gaasia. 'A goro do'oi ha'a-ai'aa ta ta'i dorai abe moi, baaniai abemu hako nai siri na'i 'eu na'i dora ni rongomaata'i.” ");
INSERT INTO aia_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mia Jisas 'a o'ani ro'u, “'I'amou bwane 'iraraai Ringe ana Moses na o'ani, ‘'Iatei nai gaasiai urao ana 'ai haua moi ta usu-usu ni haigaasi tanaa ma nugasia'a.’ ");
INSERT INTO aia_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma'ata 'inau wai 'unua tana'amou, 'oi abui gaasiai urao amua 'onaa na ai'a taritari'a baani'o. 'Onaa 'oi gaasia ma'ai waina ta saemwane he'ete'i, naia na gaasia amua nagu taritari'a 'inia beiai sae nagu waina ro'u. I sae nagu waina ro'u 'a taritari'a beiai urao anai sae he'ete'i.” ");
INSERT INTO aia_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mia Jisas 'a o'ani ro'u, “'I'amou mou 'iraraa do ra ha'a-aburaaui wauwa agaa'i 'anai horosi'i duruduru narau haa'i tanaa Araha God narau tohe 'ini'i na'i atana 'anai haa'i. Ra 'unua tanaraau do 'oha rai duruduru, rai araisuri'i ma'ata! ");
INSERT INTO aia_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mawai 'unua tana'amou, 'oha moi hauai duruduru, moi abui tohe 'inia ta maho. Moi abui tohe 'iniai aro, 'inia naasi dora ni heimarungi ana God, ");
INSERT INTO aia_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ma'ua tohe 'iniai marewana, 'inia marewana 'iia ana God, ma'ua tohe 'iniai Jerusalem 'inia naasi 'omaa ana God, i mwaeraha hauasa. ");
INSERT INTO aia_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Abu tohe o'ani ro'u, ‘'Onaa wai horosiai duruduru agua, ni warihugu 'ai mamaahui.’ 'Inia i'oe ai'a to'o mena 'anai ha'amamahuia ma'ua ha'a-buruburu'aai warihumu. ");
INSERT INTO aia_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Naasi 'onaa 'oi hauai duruduru, 'oi 'unua odo-odo moi 'io ma'ua bwa'i ma hako'a. 'Onaa 'oigui tohe 'inia ta maho ro'u, ma naasi neisi 'a boi'a baania Saetan.” ");
INSERT INTO aia_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mia Jisas 'a o'ani ro'u, “'I'amou mou bwane 'iraraai Ringe ana Moses na o'ani, ‘'Iatei nai kaaniai maana ta sae, rai kaania ro'u i maana. Mia tei nai rubu husiai rihona ta sae, rai rubu husia ro'u i rihona.’ ");
INSERT INTO aia_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma'ata, 'inau wai 'unua tana'amou, moi abui heisu'usu'u 'iniai ta'aa. 'Onaa ta sae na hidariai baba odomu, 'oi rihota'i mai hida ro'u na'i nata baba. ");
INSERT INTO aia_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","'Onaa ta sae nai raba wai'o na'i kooti 'anai rahia i to'oni abe amua 'anai su'uai mareho na'o ha'atari'aa tanaa, 'oi haua ro'u wou tanaa i to'oni tewa amua. ");
INSERT INTO aia_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","'Onaa ta sae hehei'oi nai ha'a-'usu'usu'o 'anai suru'ia tanaa i anga ana suria ta ta'i kilomita, 'oi waia suria ta rua kilomita. ");
INSERT INTO aia_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na'i 'oha na sae ra ha'angoni mareho, 'oi hisu. 'Oha ra raba waia ga'u ta mareho amua suria moi ta gere madoraa, 'oi abui ruia.” ");
INSERT INTO aia_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mia Jisas 'a o'ani ro'u, “'I'amou mou bwane 'iraraai Ringe ana Moses na o'ani, ‘Moi ta'ahirai sae amoo'i, mamoi 'utairaaui maerongamoo'i.’ ");
INSERT INTO aia_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma'ata, 'inau wai 'unua tana'amou, moi ta'ahiraaui maerongamoo'i mamoi ha'arahesi taradaaui nei ra nora ta'ai'amou. ");
INSERT INTO aia_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","'Onaa moi haua o'asi, naasi 'a ha'ata'inia do 'i'amou ra'i gare ana'ia Amamoou ara'ai aro. 'Inia 'iia 'a hauai sina tanaraau hakoi sae goro mana sae ta'a'i, ma haa'i rangi tanaraau hakoi sae odo-odo mana sae ora-ora'a. ");
INSERT INTO aia_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","'A 'ua? 'Onaa mou ta'ahiraau moi nei ra ta'ahi'amou, mou 'adoma'inia do'ia God 'ai tahari'amou goro 'inia? Rei'uaa 'iraau sae ha-ha'atakisi namou wana bodio 'iniraausi, marau haa moi ro'u o'asi. ");
INSERT INTO aia_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma 'onaa mou goro moi 'iniraaui nei ra goro 'ini'amou, naa 'i'amou mou ai'a he'ete'ita baania namoiwou ta sae. 'Inia 'iraaui sae ahurodo ra goro moi ro'u 'iniraaui nei ra goro 'iniraau. ");
INSERT INTO aia_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Naasi 'i'amou moi goro tatarasi 'onaaia Amamoou na goro tatarasi.” ");
INSERT INTO aia_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mia Jisas 'a o'ani ro'u, “Moi wai'ado'ado goro na'i 'oha moi haa'i here goro. Mou gasi haa'i beiai ha'a-ta'eta'e na'i maadi noni rago. 'Onaa moi haua o'asi, mamou bwa'i dau heitahari beia Amamoou ara'ai aro. ");
INSERT INTO aia_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","'Oha 'oi hisungiraaui pohara 'oi abu haua beiai rongoo raha, 'inia naasi here rau haa'i sae pwapwaari'i suri'i rumani ha'arahesi mei suri'i tara raha, 'inia rau 'irisia do rai ha'atee ha'a-ta'eta'eraau. Wai 'unua ha'a-momori tana'amou, na'i 'oha nara ha'atee ha'a-ta'eta'eraau, naasi'a i heitahari adaau. ");
INSERT INTO aia_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","'Oha 'oi hisungiraaui sae pohara 'oi abui ha'ata'inia hura'a tanaraaui sae taha na'o haa, ");
INSERT INTO aia_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ma'ata 'oi haua na'i dora bainihu. Taha na'o haua na'i dora bainihu, 'ia Amamu ara'ai aro 'a 'iraraa. 'Iia naigui tahari'o 'iniai taha na'o haua.” ");
INSERT INTO aia_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“'Oha moi ha'arahesi moi abui 'onaairaaui sae nara here 'onaa dora odo-odo narau raba ura na'i rumani ha'arahesi mana'i tara raha 'anai ha'arahesi dorai re'iraau. Wai 'unua ha'a-momori tana'amou, na'i 'oha nara ha'atee ha'a-ta'eta'eraau, naasi'a i heitahari adaau. ");
INSERT INTO aia_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Naasi 'oha 'oi ha'arahesi 'oi siri ahii amua ma'oi honosiai maraaruma ma'oigui ha'arahesi tanaa Amamu na'o bwa'i re'ia. 'Iia na 'iraraai taha na'o haua na'i dora bainihu, 'iia naigu tahari'o. ");
INSERT INTO aia_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Mana'i 'oha moi ha'arahesi, moi abui 'onaairaaui sae ahurodo nara 'unu ori-ori'i ha'atee nara ai'a rongo ha'amadomaahu. Ra 'adoma'inia doni hi'ona adaau 'ai arami'i ha'arahesi adaa'i 'ini'i mwane ha'atee nara haa'i. ");
INSERT INTO aia_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","'I'amou moi abui 'onaairaaui sae o'asi. 'Ia Amamoou 'a bwani 'iraraai taha mou 'irisia mamougu ha'angoni. ");
INSERT INTO aia_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Naasi 'oha moi ha'arahesi, moi ha'arahesi o'ani: Amameeu na'i aro, na atamu 'ai maea. ");
INSERT INTO aia_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na houramu 'ai boi. Na hei'irisimu rai haua na'i anoi bahai 'onaai haua ada na'i aro. ");
INSERT INTO aia_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Haua tana'ameu i mahoingau 'anai dangini. ");
INSERT INTO aia_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","'Oi 'adoma'i nugasi'ameu 'ini'i ora-ora'a amee'i 'onaai 'adoma'i nugasi'i amee'i nei ra haa'i 'ino bwarasi'ameu. ");
INSERT INTO aia_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma'oi 'a'auhi'ameu 'anai ura bwarasi'i heiohongi ma'oi taatahi bwarasi'ameu baania Saetan. ");
INSERT INTO aia_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“'Onaa moi 'adoma'i nugasi'i ora-ora'a adaa'i nei ra haa'i here ra ai'a goro tana'amou, 'ia Amamoou ara'ai aro 'ai 'adoma'i nugasi'i ora-ora'a amoo'i ro'u. ");
INSERT INTO aia_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma 'onaa mou bwa'i, 'ia Amamoou 'a bwa'i 'adoma'i nugasi'i ro'u i ora-ora'a amoo'i.” ");
INSERT INTO aia_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“'Oha moi ha'aririta'i ngau, moi abui 'ome ahutotou beia 'onaai haua adaaui sae ra here 'onaa dora odo-odo. Rau 'ome ha'ata'ata'ahi beia do nei narai re'iraau. Wai 'unua ha'a-momori tana'amou, na'i 'oha nara ha'atee ha'a-ta'eta'eraau, naasi'a i heitahari adaau. ");
INSERT INTO aia_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Naasi 'oha 'oi ha'ariri, 'oi aromaa ma'oi 'aha'aha goro ");
INSERT INTO aia_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","neina bwa'i sae nai 'ome 'iraraa do'o ha'ariri. Ma'ata 'ia Amamu na 'iraraai taha na'o haua na'i dora bainihu, 'iia naigui tahari'o.” ");
INSERT INTO aia_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Moi abui boribori'i toto'ora 'anai marewanani, 'inia he'a mana 'adi ra mata'i ha'ata'ai'i, mana sae beriberi ra matai siri na'i ruma 'anai beri'i. ");
INSERT INTO aia_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma'ata moi haa'i mwani mareho goro neina 'a 'onaa domou nuga'i toto'ora amoo'i na'i aro, dora i he'a mana 'adi ra bwa'i matai ha'ata'ai'i na'iei mana sae beriberi ra bwa'i matai beri'i. ");
INSERT INTO aia_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Moi haua o'asi, 'inia na 'adoma'imu 'ai awa tarau na'i dora na toto'ora amu'i ra awa na'iei.” ");
INSERT INTO aia_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“I maa 'a 'onaai raita anai abemu. Na'i 'oha na maamu'i ra goro hako, na abemu 'a honura'i marewa. ");
INSERT INTO aia_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma 'onaa na maamu'i ra ta'a'i, na abemu hako 'a honura'i kuhi. 'Onaa 'o 'adoma'inia do 'o awa na'i marewa ma'ogu awa na'i kuhi, i'oe 'o huunai awa na'i kuhi.” ");
INSERT INTO aia_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“'A bwa'i sae nai tau'aro goro tanaai rua bwauodo. 'Onaa nai o'asi, me 'iia 'ai 'itaa ta nei mai ta'ahiai nata nei. Ma'ua 'ai 'adoma'i ha'ahoua tanei mana nata nei 'a bwa'i. Naasi 'a bwara 'anai tau'aro tanaa God ma do'oigui ta'ahia ro'u i ha'a. ");
INSERT INTO aia_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Naasi, wai 'unua tana'amou, 'ai abui ta'aabemu 'iniai tahingamu 'ado dangi, 'iniai taha 'anai ngaua mana gono mana bwana na'oi ho'osia. 'Inia na tahingamu, ai'a moi 'anai ngaa'i mahoingau, mana abemu ai'a moi 'anai ho'osiai bwana. ");
INSERT INTO aia_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Moisui 'omesiraaui manu na'i ahoasara, rau ai'a hasi mahoingau mana 'e'eri ma'ua nuga taguma'ini'i mahoingau na'i hare. Mia Amamoou ara'ai aro 'a hanganiraaui manu 'isi. Mi'amou tanaa God, mou ororiu di'u baani'i manu 'isi. ");
INSERT INTO aia_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ma rei'uaa na towa'i ta'aabemoou, me mareho nara ta'aabemoou 'ini'isi, ra bwa'i 'a'auhi'amou 'anai ha'atewaa 'ari tahi namou haa na'i marewana. ");
INSERT INTO aia_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“'A 'ua na ta'aabemoou 'iniai bwana 'anai abemoo'i? Moisu 'adoma'i suri'i tagai raraaua ni hasimou. Rau ai'a haua ta tau'aro ma'ua tata nadaau bwana. ");
INSERT INTO aia_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mawai 'unua tana'amou, rei'uaa 'ia Mwaeraha Solomon 'a toto'ora, ma'ata ai'a ta ta'i bwana ana nai 'ome goro ta'isada beia ta ta'i tagai raraaua. ");
INSERT INTO aia_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hinihinimoou 'a kekerei di'u! 'Onaa 'ia God na ha'a-'omegoro'i tagai raraaua nara ahurara moi gere madoraa maraigui suungi'i, ni 'ua ana na bwa'i haa'i bwana 'inia tana'amou? ");
INSERT INTO aia_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Naasi, moi abui o'ani, ‘'E taha gaigui ngaua, ma'ua 'e taha gaigu gonohia, ma'ua ho'osia?’ ");
INSERT INTO aia_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Na'isi mareho na 'iraaui sae narau ai'a aidangisia God rau 'adoma'i raha 'ini'i. Naasi 'ai abui ta'aabemoou, 'inia 'ia Amamoou ara'ai aro 'a 'iraraa domou 'irisi'i mareho 'isi. ");
INSERT INTO aia_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Maho na ororiu di'u domoi haua, naasi 'anai awa tarau na'i bahainai heimarungi ana God mana awa suriai hei'irisina. 'Onaa moi haua o'asi, mia God 'ai haua tana'amoui mwani mareho 'isi. ");
INSERT INTO aia_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Naasi 'ai abui ta'aabemu 'iniai ho'oa. Dangini 'a to'oraai mareho 'ana haaria 'anai ta'aabemu 'inia.” ");
INSERT INTO aia_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“'Oi abui hiiriai nata sae, ma naasi nara bwa'i hiiri'o ro'u. ");
INSERT INTO aia_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","'Inia rai hiiri'o 'iniai ta'i hihiiri na'o haua tanaai nata sae. Mana ta'i herehere na'o haua 'anai hiiriai nata sae, naia ro'u narai haua tana'o. ");
INSERT INTO aia_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ni 'uaana na'o bonasiai rahia 'inia i gere mamamo na'i maanai nata sae, ma'ogu ai'a aidangisiai kae mamamo na'i maamu haari'o? ");
INSERT INTO aia_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","'A he'ua na'ogu matai 'unua 'inia tanaai nata sae do'oi 'a'auhia 'anai rahiai gere mamamo baaniai maana, mi'oe 'e kae mamamo na awa na'i maamu! ");
INSERT INTO aia_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Pwari'i ta'aa! Na'i na'o 'oi rahia ga'u i kae mamamo baaniai maamu haari'o neina 'oi matai wana goro 'anai rahiai mamamo baaniai maanai nata sae.” ");
INSERT INTO aia_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mia Jisas 'a hauai heiha'auu 'iniraaui nei nara 'itaai ha'atee ana God. 'A o'ani, “Moi abui haua tanaai misu i maho na maea, 'inia 'ai rihota'i aho'i mumua 'anai here ha'ata'ai'o. 'A o'asi ro'u, moi abui gaasi'i maho ra ororiu tanaai boo, 'inia 'ai buu huni'i moi mai rihota'i mumua 'anai here ha'ata'ai'o.” ");
INSERT INTO aia_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Naasi, wai 'unua tana'amou, moi abui agoheta'i ha'angoni. Ma naasi na mareho namoi ha'angonia, 'ia God 'aigui watea tana'amou. Moi abui agoheta'i siba. Ma naasi na mareho namou sibania, moigui sadoia. Moi abui agoheta'i pwepwee. Ma naasi 'ia God 'aigui tahangiai maraaruma tana'amou. ");
INSERT INTO aia_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","'Inia 'iatei nai ha'angonia God 'ini'i taha na 'irisi'i, 'ai hau'i tanaa. Mia tei nai siba, 'ia God 'ai haua tanaai taha na sibania. Mia tei nai pwepwee, 'ia God 'ai tahangia tanaai maraaruma. ");
INSERT INTO aia_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“'Iatei 'ini'amou nai matai haua tanaai gare ana ta hau 'onaa 'ai ha'angoni bredi? ");
INSERT INTO aia_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma'ua 'ai haua tanaa ta mwaa 'onaa 'ai ha'angoni ii'a? ");
INSERT INTO aia_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Rei'uaa na'o ta'aa he'ua, ma'ata 'o 'irara'i maho goro 'anai haa'i tana'i gare amu'i. 'Onaa na o'asi, mamoi 'iraraa ha'agorohia doni Amamoou ara'ai aro 'ai haa'i mwani mareho goro tanaraaui nei narau ha'angonia. ");
INSERT INTO aia_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ni here na'oi haua tanaai nata nei, 'ai suriai here na'o 'irisia dorai haua tana'o. Naasi 'ado'ado 'anai Ringe ana'ia Moses mana ha'ausuringa'i adaa'i Rarabea.” ");
INSERT INTO aia_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Na maraaruma anai dora ni mae 'a bwabwahora mana tara 'ana 'a mwada'u 'anai suria. Ma ragoi nei ra suriai tarasi. Na maraaruma anai tahi tarau 'a 'ogo mana tara 'ana 'a bwara 'anai suria, magu ai'a ragoi nei ra suria. Naasi, moi siri na'i maraaruma na 'ogo.” ");
INSERT INTO aia_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Moi 'ome'ome goro 'iniraaui rarabea pwapwaari'i. Ra 'ome mamahu 'onaai siip mana'i raromada ra 'onaai misu hahaingau. ");
INSERT INTO aia_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Moi 'ome 'irara'i moi na'i herengada 'onaai 'ome 'irara'i amoo'i hasi'ei suri'i huadi. 'O bwa'i matai husia ta huai memeapu ma'ua ta huai 'aai baaniai waroraraki. ");
INSERT INTO aia_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Hasi'ei goro ra hungu 'ini'i hua goro, mana hasi'ei ta'a'i ra hungu 'ini'i hua ta'aa. ");
INSERT INTO aia_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Hasi'ei goro 'a bwa'i haa'i hua ta'aa mana hasi'ei ta'aa 'a bwa'i haa'i hua goro. ");
INSERT INTO aia_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","'Adonai hasi'ei nara hungu 'ini'i hua ta'a'i, 'ia mo'o na to'ora'i 'ai ara gata'ini'i marai gaasi'i ara'a na'i 'eu. ");
INSERT INTO aia_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Naasi, moi matai 'ome 'irara'i rarabea pwapwaari'i na'i taha na ha'ata'inia hura'a na'i barongana. ");
INSERT INTO aia_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ai'a do 'iraau hakoi nei rau 'unuau 'iniai Araha adaau narai siri na'i heimarungi ana God ara'ai aro. 'Iraau moi nei rau ha'isuri'i hei'irisina Amagu na'i aro narai siri na'iei. ");
INSERT INTO aia_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na'i dangi ni hihiiri 'ai ragoi nei narai o'ani, ‘Araha, 'i'ameu meu taroha'ini'i ha'atee amu'i, ma 'iniai atamu meu taari'i adaro mameu hau'i 'ini'i mwane ha'abu'oahu.’ ");
INSERT INTO aia_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Minau wai o'ani 'iniraau, ‘Arai sae ora-ora'a, moi 'ariwou! 'Inau ai'a matai'amou.’” ");
INSERT INTO aia_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Mia Jisas 'agu o'ani ro'u, “Hoita naasi, 'iatei na rongo'i ha'ausuringa'i agu'i ma ha'isuri'i 'a 'onaai sae madoma na tau'aronai ruma na'i hunganai hau. ");
INSERT INTO aia_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","'A dio i rangi raha mana wai ra ahe. I ro'a 'a uuhira'i wetewete mana ruma 'a ai'a arobo 'inia 'a ura baabau na'i hunganai hau. ");
INSERT INTO aia_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","'Iatei na rongo'i ha'ausuringa'i agu'i ma ai'a ha'isuri'i 'a 'onaai sae bweu na tau'aronai ruma na'i hunganai nu'unu'u. ");
INSERT INTO aia_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","'Oha na dio i rangi raha mana wai ra ahe, i ro'a 'a uuhira'i wetewete mana ruma 'a arobo auru na maguru na'i ano.” ");
INSERT INTO aia_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Na'i 'oha 'ia Jisas 'a haa'i hako i mamaani 'ini, 'iraaui sae rago rau heimwaota'i di'u 'ini'i ha'ausuringa'i ana'i. ");
INSERT INTO aia_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","'Inia 'a huunai 'irara'i mareho na maani'i, 'a ai'a 'onaairaaui Ha'ausuri 'anai Ringe ana'ia Moses. ");
INSERT INTO aia_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","'Oha na 'ia Jisas 'a dio aho'i baaniai hungahunga, 'iraaui sae rago rau suria. ");
INSERT INTO aia_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Raugu 'ome ma'e sae lepa na boi ma topira'i ruru auru tanaa Jisas ma o'ani, “Araha, 'onaa 'o mwa'emwa'e, ma'o ga'i ha'agorohiau aho'i baaniai daoha na to'iauni.” ");
INSERT INTO aia_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","'Ia Jisas 'a taranga'inia hura'ai rimana, 'a dau wou beia ma o'ani, “'Io, 'au mwa'emwa'e moi, 'oi goro'a aho'i.” Na'i mau 'ohasi mana abena 'agu goro aho'i. ");
INSERT INTO aia_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mia Jisas 'a o'ani 'inia, “'Oi abu maania ga'u tanaa ta sae i maho na to'o bei'o. 'Oi 'ari odo-odo beiai Piriisi mai 'iraraa haaria do i'oe 'o goro aho'i. Naasi ma'oi hauai bane amua tanaai Piriisi mai ho'asi 'inia 'onaai 'unua ana Moses, 'anai ha'ata'inia tanaraaui noni do'o goro'a.” ");
INSERT INTO aia_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Na'i 'oha 'ia Jisas 'a ada na'i 'omaai Kapaniam, 'e ai Rom, 'e na'ohadaaui hehei'oi, 'a boi beia ma o'ani 'inia, ");
INSERT INTO aia_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Araha, i sae tatau'aro agua 'a daoha raha. 'Iia 'ari ruma agua. 'A rongomaata'i di'u maagu ai'a ririhota'i'a.” ");
INSERT INTO aia_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mia Jisas 'a o'ani, “'Io. Wai 'ari ha'agorohia aho'i baaniai daohasi.” ");
INSERT INTO aia_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mana saemauasi 'a o'ani, “Araha, 'oi abui 'ari, 'inia 'inau 'au ai'a arari do'oi boi na'i ruma agua. 'Oi ha'atee moi mana sae tatau'aro agua 'ai goro'a aho'i. ");
INSERT INTO aia_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","'Au 'iraraa o'asi, suria 'inau 'au to'oraai nei na marungiau nawai ha'isuri'i heiatenga'i ana'i, minau ro'u 'au to'ora'i sae hehei'oi na 'iraau rai ha'isuri'i ro'u i heiatenga'i agu'i. Na'i 'oha nawai o'ani 'inia ta ta'i 'iniraau, ‘'Oi 'ariwou 'isi,’ 'iia 'ai ha'isuria'a ma'ata. Ma 'onaa nawai o'ani 'inia ta nei 'iniraau, ‘'Oi boi 'ini,’ 'iia 'ai boi'a ro'u ma'ata. Ma 'onaa wai o'ani 'iniai sae tatau'aro agua, ‘'Oi hauai tau'aroni,’ 'iia 'ai haua'a ma'ata.” ");
INSERT INTO aia_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Na'i 'oha na 'ia Jisas 'a rongoai ha'atee o'asi anai saemauasi, 'a heimwaota'i di'u, ma o'ani 'iniraaui nei rau hano suria, “Nau wai 'unua ha'a-momori tana'amou, ai'a ta ta'i saeni Israel nawai 'omesia do'ai hinihini tari 'onaaia mo'oni. ");
INSERT INTO aia_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Wai 'unua tana'amou, 'ai ragoi nei ra ai'a Jiu rai boi baaniai mwane dora hako na'i marewana 'anai ngaugoni beia Ebraham, Aisak, mia Jekop na'i hourana ana God ara'ai aro. ");
INSERT INTO aia_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma'ai ragoi saeni Israel nara ga'i awa na'i hourana God na'i aro naragu bwa'i'a! Rai gaasiraau hura'ai dora kuhi, dora rai angi marai 'ara ha'angingita'i rihodaa'i na'iei.” ");
INSERT INTO aia_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mia Jisas 'a o'ani 'iniai na'ohadaaui hehei'oi, “'Oi aho'i 'ari ruma amua, i sae tatau'aro amua 'ai goro'a 'onaai hinihinia amua.” Mau na'i 'ohasi, mana sae tatau'aro anasi 'a goro'a aho'i. ");
INSERT INTO aia_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","'Ia Jisas 'a 'ari ruma ana Pita ma re'ia do na hungona Pita 'a awa moi na'i be'ana, 'inia 'a mata'i ma raorao i abena. ");
INSERT INTO aia_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","'A dau wou na'i rimanai uraosi mana mata'i 'a rigisia. Ma suruta'e ma ha'aagau mahoingau 'ana Jisas. ");
INSERT INTO aia_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na'i moi su'urahi mara wairaau'a mai tanaa Jisas nei ra bwaunira i adaro. 'Agu ha'atee moia Jisas mana adaro ra hura'a baaniraau, ma ha'agorohiraau hako aho'i nei ra daoha. ");
INSERT INTO aia_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ni haua ana o'asi 'a to'o ha'a-momori'a i taha na 'unua Rarabea Aisaea o'ani, “'A ha'a-ai'a'i daoha ra to'igia.” ");
INSERT INTO aia_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mia Jisas 'a re'iraaui sae rago i ruru adaau mai ma 'unua tanaraaui rongoiusuri ana'i do rai ta'e 'ari nata batarau 'iniai kae bwera i Galili. ");
INSERT INTO aia_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma'e Ha'ausuri 'anai Ringe ana'ia Moses 'a boi beia Jisas ma o'ani 'inia, “Ha'ausuri, 'inau wai suri'o rei'uaa ta dora na'oi 'ari iei.” ");
INSERT INTO aia_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mia Jisas 'a o'ani 'inia, “Na mwane mwamwaa wasi ra to'o dora ni mauru, mana manu ra to'ora'i nu'i. Minau na Garei Inoni, 'au ai'a to'o dora ni mono.” ");
INSERT INTO aia_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma'e ta'i nei 'iniraaui nei rau suria Jisas 'a o'ani, “Araha, wai 'ari ga'u mawai toringia amagu.” ");
INSERT INTO aia_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mia Jisas 'a o'ani 'inia, “'Oi suriau'a! 'Oi nugasiraaui nei ra suriai tara 'anai mae tarau marai toringiraaui nei nara mae.” ");
INSERT INTO aia_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mia Jisas 'a ta'e ara'a na'i ora beiraaui rongoiusuri ana'i marau 'ari nata batarau 'iniai kae bwera i Galili. ");
INSERT INTO aia_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Raugu 'asu'a na'i 'oha rau 'a'ari mau ma'e kae ro'a na to'iraau'a. I tabaosi ra abwao ta'eha na'i raronai ora. 'Ia Jisas 'a mauru na'i 'ohasi. ");
INSERT INTO aia_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Miraaui rongoiusuri rau 'ariwou ha'araia Jisas, marau ha'atee o'ani, “Araha, 'oi ha'atahigaau! Gai dodo'a naani!” ");
INSERT INTO aia_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mia Jisas 'a o'ani, “'A 'ua mou mamaa'u 'inia? Hinihinimoou 'a kekerei di'u!” 'Ia Jisas 'a ura ara'a ma ha'atee wetewete tanaai ro'a mana tabaosi do rarui papaku. Mau na'i 'ohasi ma biowaa'a. ");
INSERT INTO aia_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","'Iraau rongoiusuri rau heimwaota'i, rau o'ani, “'E sae he'ua naani? Rei'uaa ro'a mana tabaosi ra araisuria.” ");
INSERT INTO aia_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Na'i 'oha 'ia Jisas mana rongoiusuri ana'i rau tarau 'ari nata batarau na'i kae bwera i Galili, rau 'oto na'i dora ra 'unua 'iniai Gadara. Rau 'ari wou marau haisuara'i beiai rua saemwane na bwaunirarua i adaro. Raru hura'a mai baani'i wabwa ra toringi'i ei sae mae. 'A ha'amagugu abe do ta sae nai taha wou na'i dorasi 'inia raru here 'onaai adaro wawauru. ");
INSERT INTO aia_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","'Oha raru re'ia Jisas raru awara o'ani, “Jisas, garena God, 'o raba 'uamiria? 'A 'ua? Ai'a madoraa mau 'anai hihiiri, ma'o bwane boi'a 'anai ha'a-mama'ai'amiria?” ");
INSERT INTO aia_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gere ha'atau wou baaniai dorasi 'e kae wareai boo nara suasua 'isi. ");
INSERT INTO aia_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mana adaro ra bonga'inia wetewete Jisas o'ani, “'Onaa 'oi taari'ameu hura'a ma'o watea mei siri suri'i boo.” ");
INSERT INTO aia_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mia Jisas 'a o'ani, “Moi 'ari!” Mana adaro ra hura'a baaniraruai rua saesi mara siri suri'i boo. Mana mwani boo 'isi ra 'eba dio suriai ahana mara rege dio na'i wai mara mae hako. ");
INSERT INTO aia_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","'Iraaui nei ra 'omesuri'i boo 'isi rau 'eba 'ari 'omaa narau maaniai taha na to'o beiraaui boo mana rua sae na bwauniraruai adaro. ");
INSERT INTO aia_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mana sae na'i 'omaasi rau hura'a mai 'anai heisadoi beia Jisas marau bonga'inia do'ai hano daara'i baaniai dora adaau. ");
INSERT INTO aia_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","'Ia Jisas mana rongoiusuri ana'i rau ta'e ara'a na'i ora marau aho'i 'ari na'i 'omaa na awa-awa iei. ");
INSERT INTO aia_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","'Oha rau ada, ra'i sae rau suru'ia mai sae na abena 'a nugu tanaa Jisas na'i be'ana. 'Oha 'ia Jisas 'a 'ome 'iraraai hinihinidaau, 'a o'ani 'iniai saesi, “Garegu, 'ai abui ta'aabemu. Na ora-ora'a amu'i 'au 'adoma'i nugasi'i hako.” ");
INSERT INTO aia_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tara'i nei 'iniraaui Ha'ausuri 'anai Ringe ana'ia Moses ra 'ado'ado o'ani, “'Ia mo'oni 'a 'adoma'inia gasi do 'a ta'isada beia God. 'Iia 'a ha'atee ha'ata'aia God!” ");
INSERT INTO aia_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma'ata 'ia Jisas 'a 'iraraai 'adoma'idaau ma o'ani 'iniraau, “'A 'ua namou to'oraa 'iniai 'ado'ado ta'aasi? ");
INSERT INTO aia_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Taha na mwada'u? 'Anai 'unua tanaai saesi do'au 'adoma'i nugasi'i ora-ora'a ana'i, ma'ua 'anai 'unua tanaa do'ai ura maai hahano? 'Anai 'unua tanaa mo'osi do'au 'adoma'i nugasi'i ora-ora'a ana'i 'a mwada'u, 'inia 'a bwarai 'iraraa 'onaa ra 'adoma'i nugasi'i ora-ora'a ana'i ma'ua ai'a. ");
INSERT INTO aia_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Naasi, 'inau i Garei Inoni, wai hauai maho namou 'adoma'i ha'abwaraa ma moigu'i 'iraraa do 'au to'oraa ro'u i mena 'anai 'adoma'i nugasi'i ora-ora'a na'i marewanani.” Naasi maagu o'ani 'iniai sae na abe nugusi, “'Oi ura ara'a ma'oi suru'iai be'amu ma'oi 'ari ruma amua!” ");
INSERT INTO aia_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mana saesi 'a ura ara'a ma 'ari ruma ana. ");
INSERT INTO aia_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","'Oha 'iraaui inoni hunga rau re'iai maho na to'osi rau mamaa'u marau ha'a-aneanea God 'iniai haua ana i mena o'asi tanaai noni. ");
INSERT INTO aia_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na'i 'oha 'ia Jisas 'a hano baaniai 'omaasi 'a re'iai sae ha-ha'atakisi, atana 'ia Matiu, 'a heinagu na'i dorani tatau'aro ana. Mia Jisas 'a o'ani 'inia, “'Oi boi suriau 'onaai rongoiusuri agua.” 'Ia Matiu 'a ura ara'a ma suria'a. ");
INSERT INTO aia_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mia Jisas mana rongoiusuri ana'i rau ngau na'i ruma ana Matiu. 'A ragoi sae ha'atakisi mana sae ta'a'i narau ngau beiraau. ");
INSERT INTO aia_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma tara'i Farisei rau re'iai haua o'asi ana Jisas marau songa'iniraau'a i rongoiusuri ana'ia Jisas o'ani, “Ni 'uaana na Ha'ausuri amoou 'a ngau 'inia beiraaui sae ha-ha'atakisi mana sae ta'a'isi?” ");
INSERT INTO aia_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mia Jisas 'a rongoa ma o'ani 'iniraau, “Na sae nara goro moi abedi ra bwa'i rabasiai hei'a'auhi baaniai sae na matai ha'agorohi'i daoha, me 'iraau moi nei nara daoha nara rabasiai hei'a'auhi. ");
INSERT INTO aia_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","'A o'asi ro'u, 'inau boi na'i marewana, ai'a do 'anai 'a'auhiraaui noni odo-odo, ma'ata 'au boi 'anai 'a'auhiraaui noni ora-ora'a. Moi 'ari mamoi sibaniai 'ado'ado anai usu-usu na'i Usu-usu Maea na o'ani, ‘'E ta'i maho na ororiu domoi haua, naasi goro 'iniraaui nata sae. Ni mahosi 'a ororiu di'u'i ho'asi namou haa'i tanaau.’” ");
INSERT INTO aia_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","'Iraaui rongoiusuri ana'ia Jon Bwareomaea rau boi beia Jisas marau songa'inia o'ani, “'I'ameu miraaui Farisei meu matai ha'aririta'i ngau. Ni 'uaana na rongoiusuri amu'i rau ai'a haua o'asi 'inia?” ");
INSERT INTO aia_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mia Jisas 'a aramiraau o'ani, “'A 'ua? Mou 'adoma'inia do 'iraaui nei ra awa na'i rongo-ni-ha'iwai rai ahutotou na'i 'oha na awa beiraau a mo'o ra ha'aha'iwaia? 'Abwa'i! Ma'ata na'i 'oha rai waiai nei nara ha'aha'iwaia baaniraau, ma raigui matai nuga ngau aho'ita. ");
INSERT INTO aia_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“'Abwa'i nei nai haa ta maakari bwana haoru 'anai tai bwarasiai dora na maakari na'i bwana bwani. 'Onaa 'ai haua o'asi, na'i 'oha raigui wasiai bwanasi, na maakari bwana haorusi 'ai niniro, mai haua'a ta kae maakari nai raha di'u ro'u wou na'i bwana bwanisi. 'Inia na maakari bwana haoru ai'a ta'isada beiai bwana bwani. ");
INSERT INTO aia_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Nata mareho ro'u, 'abwa'i nei nai matai nuga waen haoru suri'i bei uri-uri mwamwaa bwani, 'inia na bei bwani ra bwane 'a'asi. Na'i 'oha na waen haoru 'ai su'u, na bei bwani rai pusu. Naasi mana waen rai ahe gata'ini'i, mana bei rai maakari ta'a'i. Na waen haoru rai niga'i ma'ata na'i bei haoru mararui awa goro hako.” ");
INSERT INTO aia_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Na'i 'oha 'ia Jisas 'a mamaani mau, 'e saemaua adaaui Jiu na boi ma topira'i ruru bwarasia Jisas ma o'ani 'inia, “Gare urao agua 'a bura'i mae moi. 'Oi boi karohia maai tahi aho'i.” ");
INSERT INTO aia_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mia Jisas mana rongoiusuri ana'i rau ura ara'a marau suriai saesi. ");
INSERT INTO aia_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma'e urao na to'iai 'abu raha suriai ta'i tangahurui harisi mana rua na awa ro'u na'i 'ohasi. 'A 'ariwou na'i murina Jisas ma karohia wou na'i gaonai to'oni tewa ana Jisas. ");
INSERT INTO aia_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","'A 'iraraa haaria do 'onaa 'ai karohia moi na'i to'oni ana Jisas ma 'a ga'i goro aho'i baaniai daoha na to'iasi. ");
INSERT INTO aia_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mia Jisas 'a rihota'i ma o'ani 'inia, “Ina, 'oi wa'ewa'e. Na hinihinimu na ha'agorohi'o aho'i.” Na'i mau i 'ohasi mana uraosi 'a goro'a. ");
INSERT INTO aia_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na'i 'oha nagu siri a Jisas na'i ruma anai saemaua adaaui Jiu ani, 'a re'iraaui sae ra ada'imae ra ago-ago mara rongo raha ma ra'i nei nara uuhi'i gana suri'i 'au 'ini ahutotou. ");
INSERT INTO aia_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma o'ani 'iniraau, “Moi hura'a baaniai ruma! I gare uraosi 'a ai'a mae, 'iia 'a mauru moi.” Miraau da'ata'inia. ");
INSERT INTO aia_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","'Oha rau ha'a-taariraau hako hura'a, 'ia Jisas 'a siri wou na'i ahii anai garesi ma dau na'i rimana ma ha'a-urata'ea ara'a. ");
INSERT INTO aia_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na'i muri na taroha 'a 'adarara 'ari suriai dorasi. ");
INSERT INTO aia_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na'i 'oha 'ia Jisas 'a hano baaniai dorasi 'e rua sae kuru raru suria, raru awaawara o'ani, “Pwirana Deved, 'oi arunga ta'ahimiria ma'oi 'a'auhimiria.” ");
INSERT INTO aia_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na'i 'oha na siri ruma, raru siri suria ma songa'inirarua o'ani, “'A 'ua? Muru hinihini do 'inau 'au matai ha'a-wanawana'amurua?” Ma raru ha'atee o'ani, “Araha, miri hinihini.” ");
INSERT INTO aia_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma dau wou suri'i maadaru'i ma o'ani, “Suriai hinihini amurua, murui goro'a.” ");
INSERT INTO aia_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma raru taraawa'a wanawana'a. Mia Jisas 'a ha'abasurarua wetewete o'ani, “Murui abui maaniai mahosi tanaa ta sae.” ");
INSERT INTO aia_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Me raru 'ari nararu taroha'inia Jisas 'ari suria hakoi dorasi. ");
INSERT INTO aia_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ai'a orea mau hura'a adarua i rua sae kurusi mara waia ro'u mai tanaa Jisas sae na baanguu, 'inia 'a sirihia i adaro. ");
INSERT INTO aia_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mia Jisas 'a taaria i adaro hura'a baania mana saesi 'a taraawa'a ha-hadahada aho'i ro'u. 'Iraaui noni hunga rau heimwaota'i marau o'ani, “Taraawa'a mau mai, ai'a ta maho o'ani nai to'o na'i Israel.” ");
INSERT INTO aia_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Miraaui Farisei rau o'ani, “I mwaeraha adaaui adaro na haua tanaa i mena 'anai taariraau hura'ai adaro.” ");
INSERT INTO aia_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","'Ia Jisas 'a 'ari suri'i 'omaa raha mana gere 'omaa na'i dorasi 'anai ha'ausuriraaui sae suri'i rumani ha'arahesi, ma taroha'inia tanaraaui Taroha Goro 'iniai heimarungi ana God, mana ha'agorohi'i aho'i sae nara to'iraaui mwani taraani daoha mana riunga he'ete'i hairiu. ");
INSERT INTO aia_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","'Oha na re'iraaui inoni hunga 'a ahu ta'ahiraau, 'inia rau awa ha'aroha'a marau 'ome ha'ata'ata'ahi 'onaai siip nara ai'a to'o sae 'anai 'omesuri'i. ");
INSERT INTO aia_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mia Jisas 'a o'ani 'iniraaui rongoiusuri ana'i, “Na nei nara ha'aagau 'anai hinihiniau ra rago di'u'a 'onaai mwane hua nara maua'a suri'i hasi'ei. Mara ai'a rago i nei 'anai husi'i. ");
INSERT INTO aia_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Naasi, moi ha'arahesi tanaa God maai ha'ataari'i hura'a tara'i mwane sae tatau'aro 'anai 'a'au na'i mou hasi'eisi.” ");
INSERT INTO aia_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","'Ia Jisas 'a soi goniraaui ta'i tangahuru mana rua rongoiusuri ma haua tanaraaui mena 'anai taari adaro mana ha'agorohi'i aho'i nei na sadoira i mwani daoha mana riunga he'ete'i hairiu. ");
INSERT INTO aia_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nara 'ini atadaa'i ta'i tangahuru mana rua ha'ataari: 'Ia Saemon, nata atana 'ia Pita, mea do'orana 'ia Andru, 'ia Jems mea Jon, rua gare ana'ia Sebedi. ");
INSERT INTO aia_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","'Ia Pilip, 'ia Batolomiu, 'ia Tomas, 'ia Matiu i sae na ha-ha'atakisi, 'ia Jems garena Alfias, 'ia Tadias, ");
INSERT INTO aia_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","'ia Saemon baaniai ruruha narau raba taaria hura'ai heimarungi adaaui Rom, mea Jiudas Iskariot, 'ia mo'o na usuha'inia Jisas tanaraaui maerongana'i. ");
INSERT INTO aia_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na'i 'oha 'ia Jisas 'a ha'aagau 'anai ha'a-taariraau hura'ai ta'i tangahuru mana rua ha'ataari, 'a heiatenga'i o'ani tanaraau, “'Oha moi hura'a 'anai 'ari 'anai tau'aro, moi abui taha suri'i 'omaa adaa'i Samaria mei beiraaui nei ra ai'a Jiu. ");
INSERT INTO aia_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Moi 'ari moi beiraaui saenai Israel narau 'onaai siip ra teha baaniai 'omesuri siip. ");
INSERT INTO aia_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","'Oha moi hura'a, moi maania doni heimarungi ana God na awa na'i aro 'a gaarangi'a. ");
INSERT INTO aia_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Moi ha'agorohi'i aho'i nei ra daoha ma'ua nei ra lepa. Moi taari adaro baanirai sae mamoi ha'atahi'i aho'i nei ra mae. 'Inau 'au hisu dadara'a tana'amou 'ini'i mareho 'isi, naasi moi hisu aho'i dadara'a ro'u tanaraaui noni. ");
INSERT INTO aia_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“I sae ra tau'aro 'a arari dorai taguma'iniraau 'iniai tau'aro adaau. Naasi 'oha moi hano, moi abu waiwai ha'a ma'ua anga ni 'aariha ma'ua sandol ma'ua 'a'abi ma'ua do ta bwana ro'u. ");
INSERT INTO aia_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","'Oha moi ada ta 'omaa moi siba 'inia ta sae goro nai ha'a-awahi'amou na'i ruma ana. Moi awa beia tari 'oha moi hano baaniai 'omaasi. ");
INSERT INTO aia_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","'Oha moi 'ari ta ruma, moi ha'atee o'ani, ‘Gooroha ana God 'ai awa bei'amou.’ ");
INSERT INTO aia_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","'Onaa 'iraaui rumasi rai ha'amaoto'amou, 'ia God 'ai ha'agorohiraau, ma 'onaa rai 'itamou ma bwa'i ha'agorohiraau'a. ");
INSERT INTO aia_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","'Onaa 'e 'omaa na ai'a raba ha'amaoto'amou, ma'ua ai'a raba rongo'i heitaroha'i amoou, moi tarohi'i kahua baani'i uwamoo'i mamoi hano baaniai 'omaasi. Naasi 'e ha'abasu tanaraau do'ia God 'ai ha'a-mama'airaau. ");
INSERT INTO aia_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Wai 'unua ha'a-momori tana'amou, na'i madoraa ni hihiiri, ha'a-mama'ai nai haua God tanaai 'omaasi 'ai ta'aa di'u baaniai ha'a-mama'ai nai haua tanaraaui Sodom mana Gomora.” ");
INSERT INTO aia_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mia Jisas 'a ha'atee o'ani, “Moi 'ome'ome goro, suria 'i'amou mou 'onaai'i siip nau ha'ataari'i hura'a na'i 'uruhadi misu hahairete. Naasi moi hihinano'a 'onaai mwaa mamoi manego 'onaai waibora. ");
INSERT INTO aia_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Moi 'ome'ome goro, 'inia tara'i nei rai wai'amou 'anai 'i'i'amou marai rohoroho'amou suri'i rumani ha'arahesi adaa'i. ");
INSERT INTO aia_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Suria 'i'amou ra'i rongoiusuri agu'i, rai wai'amou tanaraaui Primia mana Mwaeraha 'anai hiiri'amou. Naasi 'oha goro amoou 'anai taroha'inia hura'a i Taroha Goro tanaraau mei tanarai nei ra ai'a Jiu. ");
INSERT INTO aia_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Na'i 'oha rai wai'amou 'anai hiiri'amou, moi abui 'adoma'i raha 'iniai taha moi maani'i, 'inia moi 'iraraai taha moi maani'i na'i madoraasi. ");
INSERT INTO aia_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Na maho na moi maani'i, ai'a 'ado'adomoo'i haarimoou mei baaniai Hi'ona Maea nai ha'ataaria mai a Amamoou. ");
INSERT INTO aia_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Na'i 'ohasi, sae rai usuha'ini'i do'oradaa'i mana gare adaa'i nara hinihiniau tanaraaui nei nara raba ha'amaesiraau. Mana gare rai ha'imae bei'i amadaa'i mana inadaa'i marai usuha'iniraau ro'u tanaraaui nei rai ha'amaesiraau. ");
INSERT INTO aia_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","'Iraaui noni rai 'utai'amou, suria 'i'amou ra'i rongoiusuri agu'i. Ma 'onaa moi ura baabau tari ha'ahakonai madoraa ta'aasi, moigu daua namooui tahi tarau. ");
INSERT INTO aia_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","'Onaa rai nora ta'ai'amou ta 'omaa, moi 'eba 'ari na'i nata 'omaa. Wai 'unua ha'a-momori tana'amou, mou bwa'i ada hako mau suri'i 'omaani Israel minau Garei Inoni wai aho'i'a mai. ");
INSERT INTO aia_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ni rongoiusuri 'a bwa'i ahaaha di'uai ha'ausuri ana, mana sae tatau'aro 'abwa'i ahaaha di'uai bwauodo ana. ");
INSERT INTO aia_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","'A arari do ni rongoiusuri 'ai awa 'onaaia moi ha'ausuri ana, mana sae tatau'aro 'ai awa 'onaaia moia mo'o na bwauodo 'inia. 'Inau 'au 'onaai bwauodonai ruma mi'amou moi 'onaai nei nara awa na'i ruma agua. Naasi 'onaa rai 'unuau 'iniai Mwaeraha adaaui adaro, rai matai 'unu'i maho nara ta'aa di'u ro'u wou 'ini'amou.” ");
INSERT INTO aia_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Moi abui mamaa'usiraaui nei narau raba ha'a-mama'ai'amou. 'Inia mwane maho hako narau awa bainihu suri'i tahingadaa'i mana taha narau giru'i, rai ha'ata'ini'i hura'a. ");
INSERT INTO aia_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na tarana naasi, maho nau maani'i tana'amou haari'amou, moi maani'i hura'a tanaraau hakoi mwani sae. ");
INSERT INTO aia_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Moi abui mamaa'usiraaui sae, 'inia 'iraaui sae ra matai ha'amaesia moi abemu, mara bwa'i matai ha'amaesiai aungamu. Moi mamaa'usia moia God na matai ha'a-mama'aiai abemu mana aungamu na'i dora ni ha'a-mama'ai. ");
INSERT INTO aia_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","'A 'ua? Mou 'iraraai rua gere manu nara raonga'i ta'i sereni moi 'ini'i na'i maketi? Rei'uaa nara hori mwada'u o'asi, ma 'abwa'i ta nei 'ai mae 'onaa Amamoou 'a bwa'i 'irisia o'asi. ");
INSERT INTO aia_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Naasi moi abui mamaa'u, 'inia 'i'amou namou ororiu di'u'i mwani manu rago. Na rei'uaa warihu suri'i bwaumoo'i, 'ia God 'a uduma'ini'i hako.” ");
INSERT INTO aia_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“'Ia tei nai ha'arangasia tanaraaui sae do 'iia 'e rongoiusuri agua, 'inau ro'u wai ha'arangasia tanaa Amagu ara'ai aro do'iia 'e rongoiusuri agua. ");
INSERT INTO aia_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma 'onaa 'iatei nai gagata'iniau, 'inau wai gagata'inia o'asi ro'u na'i maana Amagu na'i aro.” ");
INSERT INTO aia_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Moi abui 'adoma'inia do 'inau 'au boi 'anai ha'a-awagorohiraau goni inoni na'i marewana. Ai'a! Nau waa mai heihoa. ");
INSERT INTO aia_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","'Au boi 'anai ha'ahaihoai gare mwane beia amana, mana gare urao beia inana, mana urao ha'iwai beiai hungona. ");
INSERT INTO aia_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ha'amomori, huunai maerongamu 'e sae moi na'i ruma amua. ");
INSERT INTO aia_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","'Onaa 'o ta'ahia amamu ma'ua inamu, ma'ua gare mwane amua ma'ua gare urao amua di'uau, 'o ai'a arari 'anai ha'i rongoiusuri agua. ");
INSERT INTO aia_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","'Onaa 'o bwa'i suru'iai dadaahoro amua, ma'oi suriau, 'o ai'a arari 'anai ha'i rongoiusuri agua. ");
INSERT INTO aia_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","'Onaa 'o raba dau baabau na'i tahingamu na'i marewanani, 'o bwa'i dauai huunai tahi. Ma 'onaa 'oi mwa'emwa'e 'anai ha'a-ai'aai tahingamu 'iniau, 'oi sadoiai huunai tahi.” ");
INSERT INTO aia_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“'Iatei na ha'amaoto'amou, 'a 'onaa do'a ha'amaotoau ro'u. Mia tei na ha'amaotoau, 'a 'onaa do'a ha'amaotoa ro'u a mo'o na ha'ataariau mai. ");
INSERT INTO aia_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","'Iatei na ha'amaotoai rarabea 'inia 'a 'iraraa do'e rarabea, 'ai daua nana i ta'i heitahari na 'ia God 'ai haua tanarai rarabea. Mia tei na ha'amaotoai sae odo-odo 'inia 'a 'iraraa do'e sae odo-odo, 'ai daua nana i ta'i heitahari na 'ia God 'ai haua tanarai sae odo-odo. ");
INSERT INTO aia_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'Ia tei nai haua moi ta panikeni wai wauni tanaa ta nei 'iniraaui nei narau suriau nara 'adoma'i heiheiraau, 'ia God 'ai taharia.” ");
INSERT INTO aia_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","'Oha 'ia Jisas 'a heiatenga'i hako tanaraaui ta'i tangahuru mana rua rongoiusuri ana, 'a hano ma ha'ausuri ma heitaroha'i suri'i 'omaa gaarangiai dorasi. ");
INSERT INTO aia_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na'i 'ohasi, 'ia Jon Bwareomaea 'a awa na'i rumaniho'o ma rongo tarohanai Ha'atahi. Ma ha'a-taariraau 'ari tara'i rongoiusuri ana'i beia Jisas ");
INSERT INTO aia_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","marau songa'inia Jisas o'ani, “I'oe naasi nei nara 'unua do'ai boi 'anai ha'atahi'ameu, ma'uasi 'e nei he'ete'i namei mamasia ro'u mau?” ");
INSERT INTO aia_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mia Jisas 'a o'ani, “Moi aho'i 'ari mamoi 'unu'i tanaa Jon i mareho namou rongo'i mana mareho namou 'omesi'i nau haa'i. ");
INSERT INTO aia_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nei ra kuru ra wanawana'a, nei ra pwaki ra hahano'a, nei nara lepa ra goro aho'i, nei ra pwarongo ra rongorongo'a, na nei ra mae ra suruta'e aho'i baaniai mae, miraaui pohara ra bahurongoai Taroha Goro. ");
INSERT INTO aia_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","'Ia God 'ai ha'agorohiai nei na 'omesi'i mareho nau haa'i, ma ai'a 'adoma'i heiruarua'a 'iniau.” ");
INSERT INTO aia_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","'Oha 'iraaui rongoiusuri ana'ia Jon rau hano'a, 'ia Jisas 'a taraawa'ai maania Jon tanaraaui sae rago. 'A o'ani, “'A 'ua? Na'i 'oha namou 'ari na'i dora mangasara 'anai bahurongoa Jon, 'e taha namou 'adoma'inia domoi 'omesia? 'E sae na orisia tarau i 'adoma'ina 'onaai ade na gegewao? ");
INSERT INTO aia_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","'A 'ua? 'E sae he'ua namou hura'a 'anai re'ia? 'E sae na siri suri'i bwana 'ome goro? Na sae ra siri suri'i bwana o'asi, ra awa suri'i ruma adaa'i mwaeraha, ai'a suri'i dora mangasara. ");
INSERT INTO aia_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ma'e tahata namou hura'a 'anai 'omesia na'i dora mangasara? 'E rarabea? Ha'amomori, 'e rarabea, ma'ata 'iia ai'a do'e rarabea moi. ");
INSERT INTO aia_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","'Ia Jon naasi nei na 'ia God na taroha'i 'abaia o'ani na'i Usu-usu Maea, ‘Nau wai ha'ataaria wou i noni heitaroha'i agua na'i na'o 'ini'o, 'iia nai ha'aagauraaui noni 'anai boi amua.’ ");
INSERT INTO aia_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Wai 'unua ha'a-momori tana'amou, 'ia Jon naasi na ororiu di'u'i hakoi mwane inoni nara huta mai na'i marewanani. Ma'ata, namoiwou ta sae na ai'a taraa ororiu na awa na'i heimarungi ana God ara'ai aro, 'a ororiu di'ua Jon Bwareomaea. ");
INSERT INTO aia_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Taraawa'a na'i madoraa na heitaroha'i a Jon tari 'ohani ra rago i nei ra bonasia di'u dorai siri na'i heimarungi ana God. ");
INSERT INTO aia_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","I buka ra usu'i Rarabea mana Ringe ana'ia Moses ra mamaani nga'iniai taha ra to'o tari na'i madoraa ana Jon. ");
INSERT INTO aia_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma 'onaa mou hinihini'i mamaani 'isi, 'ia Jon naasia Elaija, i rarabea namou mamasia 'anai boi aho'i ta'oha. ");
INSERT INTO aia_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tei na to'o karinga 'anai rongo, 'ai bahurongoa mai aidangi tarihana. ");
INSERT INTO aia_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“'E taha nawai heiha'auu 'inia nai ta'isada beiraaui noni nai 'ohani? 'Iraau rau 'onaai'i gare haha'ariaria nara hainonora na'i dorani maketi. 'E ta'i ruruha nara awara o'ani 'ari tanaai nata ruruha, ");
INSERT INTO aia_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘'Ei, meu uuhi'i gana ni hainonora mamou ai'a raba mao, mameu ganari'i gana ni heitori mamou ai'a raba angi.’ ");
INSERT INTO aia_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","'I'amou mou ha-ha'ariaria o'asi ro'u! 'Oha na boia Jon 'a ai'a gonohi'i waen ma matai ha'aririta'i ngau mamou 'unua do 'e adaro na bwaunia. ");
INSERT INTO aia_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ma na'i 'oha nau boi, Garei Inoni, mou re'ia do 'au matai gono waen mau matai ngaungau, mamou 'unua do'au ngangaura'a mau bweu 'ini gonohiai waen, ma do 'inau 'e saegoro adaaui inoni ha-ha'atakisi miraaui inoni ta'a'i. Ma'ata, na awaha odo-odo adaa'i nei narau hinihini'i ha'ausuringa'i amiria Jon 'ai ha'ata'inia hura'ai madoma nara haa'i ha'ausuringa'i 'isi.” ");
INSERT INTO aia_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Suri'i 'omaa na 'ia Jisas 'a haa'i ei mwani ha'abu'oahu rago, 'iraaui sae ra ai'a rihosi baani'i herengadaa'i nara ai'a goro. 'Oha 'ia Jisas 'a aidangisia o'asi, 'a taesu'a i ahuna ma ha'atee o'ani, ");
INSERT INTO aia_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“'I'amoui Koresin mi'amoui Betsaeda, 'ai ta'aa di'u tana'amou! 'Onaa ha'abu'oahu nau haa'i tana'amou ra ga'i haa'i tanaraaui sae ta'a'i na'i 'omaai Taea mei Saedon, rau ga'i bwane rihosi orea mau tanaa God. Ra ga'i bwane ho'osi'i bwana do'odo'o'a mana nuga dohu 'ada'i bwaudaa'i 'anai ha'ata'inia do rau ahutotou 'ini'i ora-ora'a adaa'i. ");
INSERT INTO aia_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wai 'unua tana'amou, na'i 'oha na 'ia God 'ai hiiriraaui noni hako, na ha'a-mama'ai nai haua tana'amou 'ai di'ua ro'u wou i ha'a-mama'ai nai haua tanaraaui Taea mei Saedon. ");
INSERT INTO aia_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Mi'amoui Kapaniam, mou 'adoma'inia do'ia God 'ai wai'amou ara'ai aro 'anai ha'a-ahaaha'amou? 'A bwa'i! 'Iia 'ai gaasi'amou auru na'i 'eu na'i dora ni rongomaata'i. 'Onaa ha'abu'oahu nau haa'i tana'amou ra ga'i haa'i tanaraaui sae ta'a'i na'i Sodom, i 'omaasi 'a ga'i ura mau tari na'i dangini. ");
INSERT INTO aia_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Naasi wai 'unua tana'amou, na'i dangi ni hihiiri, 'i ha'a-mama'ai God nai haua tana'amou 'ai di'ua ro'u wou i ha'a-mama'ai nai haua tanaraaui saenai Sodom.” ");
INSERT INTO aia_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na'i 'ohasi 'ia Jisas 'a ha'atee o'ani, “Ama, i'oe na'o marungiai aro mana ano. 'Au ha'atee ha'agorohi'o suria 'o giru'i mareho 'isi ta'iniraaui nei nara madoma mara aidangi, ma'o ha'ata'ini'i tanaraaui nei 'ini nara 'onaai gare. ");
INSERT INTO aia_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","'Io Ama, 'a o'asi 'inia naasi huunai hei'irisimu.” ");
INSERT INTO aia_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ma o'ani ro'u, “Na mwane mareho hako 'ia amagu 'a hau'i hako tanaau. Ai'a tanei nai huunai aidangisiai garena God, me 'iia moia Amagu. Ma ai'a tanei nai huunai aidangisiai Ama, ma'ata 'iia moi garena, miraaui nei na 'inau 'au sigihiraau 'anai ha'a-aidangisiraau 'inia. ");
INSERT INTO aia_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“'I'amoui nei namou wai'ate'a mamou magare 'iniai suri'i amoo'i mareho nara ha'ahihi'amou 'ini'i, moi boi beiau mawai ha'a-mamaro'amou. ");
INSERT INTO aia_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Moi araisuri'i Ha'atora agu'i minau wai ha'ausuri'amou, 'inia 'inau 'au manego mawai 'abenga'i bei'amou. Moi matai mamaro, ");
INSERT INTO aia_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","'inia ni Ha'atora agu'i rai 'a'auhi'amou mara ai'a hihi'a.” ");
INSERT INTO aia_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na'i dangi ni mamaro 'ia Jisas mana rongoiusuri ana'i rau tahahoro na'i 'ubutadi mou wiit. 'Iraaui rongoiusuri rau rahi'i tara'i kora marau ngaa'i 'inia rau hioro. ");
INSERT INTO aia_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tara'i nei 'iniraaui Farisei rau re'iraau marau o'ani 'inia Jisas, “'Ei! 'Iraau rongoiusuri amu'i rau ga'i bwa'i husi'i wiit 'isi. Na Ringe ana'ia Moses 'a ha'aabuai tau'aro na'i dangi ni mamaro!” ");
INSERT INTO aia_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mia Jisas 'a ha'atee o'ani, “'A 'ua? Mou ai'a 'oha'iniai mamaani 'inia Mwaeraha Deved mana nei rau ta'i hano na'i 'oha narau hioro? ");
INSERT INTO aia_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","'Ia Deved 'a siri na'i Ruma Maea Saira ana God marau ngaai bredi nara ha'amaeaa. Na bredi 'isi 'iraau moi Piriisi narau ga'i matai ngaa'i. Naasi rau horosia ro'u i Ringe mia God 'a ai'a taesu'a 'adaau. ");
INSERT INTO aia_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","'A 'ua? 'I'amou mou ai'a 'oha'inia na'i Ringe ana'ia Moses do 'iraaui Piriisi ra matai tau'aro moi na'i dangi ni mamaro? Rei'uaa narau haua o'asi, ma ai'a ta sae nai 'unua dorau taritari'a. ");
INSERT INTO aia_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mawai 'unua tana'amou, 'e ta'i maho na ororiu di'uai Ruma Maea na awa'a. ");
INSERT INTO aia_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","'I'amou mou ai'a 'iraraai huunai 'ado'ado 'anai maho ra maaniai na'i Usu-usu Maea 'oha ra o'ani, ‘Rei'uaa namou bwa'i suu ho'asi tanaau ma goro moi. Maho moi nau rabasia domoi haua, naasi goro 'iniraaui sae.’ 'Onaa moi 'iraraai 'ado'ado 'anai mahosi, mou ga'i bwa'i ha'ahuniraaui rongoiusuri agu'i 'iniai maho narau haua na ai'a taritari'a. ");
INSERT INTO aia_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Hoita naasi, 'inau na Garei Inoni, nau matai 'unu'i maho 'iraaui sae ra matai haa'i na'i dangi ni mamaro, 'inia 'inau naasi Araha 'anai dangi ni mamaro.” ");
INSERT INTO aia_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","'Ia Jisas 'a hano baaniai dorasi ma siri na'i rumani ha'arahesi adaaui Jiu. ");
INSERT INTO aia_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","'A sadoia ei sae na rima mae. Tara'i Farisei rau raba sadoia ta maho 'anai subunia Jisas 'inia. Naasi rau songa'inia o'ani, “'A 'ua? 'A odo-odo moi na'i Ringe ana'ia Moses 'anai ha'agorohi'i aho'i sae daoha na'i dangi ni mamaro?” ");
INSERT INTO aia_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mia Jisas 'a aramiraau o'ani, “'Onaa 'oi to'oraa ta ta'i siip, mana siipisi 'ai ahoda na'i waumu na'i dangi ni mamaro. 'A 'ua? 'O bwa'i rahia ta'eha? ");
INSERT INTO aia_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","I sae 'a ororiu di'uai siip. Naasi 'a ha'ata'inia doni Ringe ana'ia Moses 'a ha'awategaau 'anai hauai maho na goro tanaai sae na'i dangi ni mamaro.” ");
INSERT INTO aia_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mia Jisas 'a o'ani 'iniai sae na rima mae, “'Oi taranga'inia hura'ai rimamu.” Ma taranga'inia hura'a mana rimana 'a goro aho'i 'onaai nata rima. ");
INSERT INTO aia_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Miraaui Farisei rau hura'a marau haai ha'aradorado 'anai ngahu ha'amaesia Jisas. ");
INSERT INTO aia_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na'i 'oha na 'ia Jisas 'agu 'iraraai taha na 'iraaui Farisei rau 'adoma'inia 'inia, ma hano'a baaniai dorasi. 'Iraaui sae rago rau hano suria, ma ha'agorohiraau hako aho'i nei ra daoha. ");
INSERT INTO aia_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma'ata 'a ha'a-aburaau dorai abui maania tanaa ta sae do 'iia 'iatei. ");
INSERT INTO aia_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","'A haua o'asi ma ha'a-momori'a i taha na 'unua Rarabea Aisaea o'ani, ");
INSERT INTO aia_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Naani sae tatau'aro agua nau 'ome sigihia, 'au ta'ahia mau wa'ewa'e 'inia. Wai haua tanaai Hi'ona Maea agua, ma'ai taroha'inia tanaraaui sae suri'i 'ado marau i hihiiri odo-odo nawai haua. ");
INSERT INTO aia_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","'Iia 'a bwa'i heitohetohe ma bwa'i awaawara, ma bwa'i ha'atee raha suri'i tara. ");
INSERT INTO aia_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","'A bwa'i raesiai ade na mwa'o'o ma bwa'i kuruiai raita na gaarangi kuru. 'Ai haua o'asi tari 'oha 'ai ha'ahehoa hako i ta'aa. ");
INSERT INTO aia_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","'Iraau hakoi saenai marewana rai wana tanaa 'anai ha'atahiraau.” ");
INSERT INTO aia_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tara'i sae ra waa mai tanaa Jisas sae na kuru ma baanguu 'inia 'e adaro na bwaunia. 'Ia Jisas 'a ha'agorohia aho'i saesi mana saesi 'a taraawa'a ha-ha'atee ma 'ome'ome aho'i ro'u. ");
INSERT INTO aia_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","'Iraaui sae rago rau heimwaota'i 'inia, marau heisosonga'i o'ani, “Romwane, 'iia'a gasi naani Ha'atahi nai hura'a mai baaniai burungana Mwaeraha Deved?” ");
INSERT INTO aia_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","'Oha 'iraaui Farisei rau rongoa, rau ha'atee o'ani, “'Iia 'a taari'i hura'ai adaro 'iniai mena ana Saetan, i mwaeraha adaaui adaro.” ");
INSERT INTO aia_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","'Ia Jisas 'a 'iraraai 'adoma'idaau ma o'ani 'iniraau, “'Onaa 'e kantri na 'iraaui inoni rai hei'oi hairiu, na kantrisi 'ai ai'aa. Ma 'onaa 'e 'omaa ma'ua 'e ruruha na'i ruma narai awa heheihoa'a moi, i 'omaasi ma'ua ruruhasi 'a bwa'i ura. ");
INSERT INTO aia_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Naasi 'onaa 'ia Saetan na haua tanaaui mena 'anai taari adaro ma 'anai ha'ata'aiai ruruha ana haaria, ni ruruha ana 'ai hako raurau moi. ");
INSERT INTO aia_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hoita, ma 'onaa na ga'i ha'a-momori do 'inau taari adaro hura'a 'iniai mena ana Saetan, mana mena ana tei na 'iraaui rongoiusuri amoo'i narau taari adaro 'inia? Ni mena ro'u ana Saetan? Ai'a! 'Iraaui rongoiusuri amoo'i rau haua 'onaai haua agua, ma ha'ata'inia do 'i'amou mou taritari'a. ");
INSERT INTO aia_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma 'onaa nau taari adaro 'iniai mena ana Hi'ona Maea na boi baania God 'a ha'ata'inia doni heimarungi ana God 'a taha'a bei'amou.” ");
INSERT INTO aia_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mia Jisas 'a haua ro'u i ha'atee heiha'auu. 'A ha'atee o'ani, “'Onaa 'e nei na raba taari'i hura'ai adaro, i mena ana 'ai wetewete ma'ata'a di'ua Saetan. 'A 'onaai sae na raba sirihiai ruma anai sae wetewete 'anai haa'i mareho ana'i, 'ai wetewete ma'ata'a di'ua ro'u i sae wetewetesi. Naasi 'aigu mwada'u tanaa 'anai siri tosiai saesi, maigui haa'i bori ana'i. ");
INSERT INTO aia_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“'Iatei na ai'a aba beiau, 'a ha'imae beiau. Mia tei na ai'a 'a'auhiau 'anai wai'i inoni tanaa God, 'a adara'iniraau inoni baania God. ");
INSERT INTO aia_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","“Mawai 'unua tana'amou, mwane maho ta'a'i na'o haa'i ma'ua 'unu'i 'ia God 'a matai 'adoma'i nugasi'o moi 'ini'i. Rei'uaa na 'oi ha'atee ha'ata'aiau i Garei Inoni 'a matai 'adoma'i nugasi'o ro'u. Ma'ata 'onaa 'oi ha'atee ha'ata'aiai Hi'ona Maea, 'a bwa'i matai 'adoma'i nugasi'o mwada'u, na'i 'ohani mana'i ta 'oha ro'u.” ");
INSERT INTO aia_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mou ga'i 'iraraa doni hasi'ei goro 'a ha'i hua goro, mana hasi'ei ta'aa 'a ha'i hua ta'aa. 'O matai 'ome 'iraraai hasi'ei 'iniai huana. ");
INSERT INTO aia_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","'I'amoui mwane mwaa ta'a'i! 'Iniai ta'aa di'u amoou, 'a bwara he'ete'i domoi 'unu'i tara'i maho goro. Ni ngoo naasi na ha'arangasia hura'ai taha na honu 'inia i raromanai noni. ");
INSERT INTO aia_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ni sae goro ra hura'a mai mareho goro baaniai ngoona, suria ni raromana 'a honu 'iniai goro. Mana sae ta'aa, ra hura'a mai mareho ta'a'i baaniai ngoona, suria ni raromana 'a honu 'iniai ta'aa. ");
INSERT INTO aia_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Wai 'unua tana'amou, na'i dangi ni hihiiri 'ia God 'ai hiiriraau hakoi sae 'ini'i hadahadangadaa'i nara ai'a goro narau ai'a 'adoma'inia do 'ai matai ha'a arungata'aiai nata sae. ");
INSERT INTO aia_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","'Onaa ni hadahadangamu 'a goro, 'ia God 'ai 'unua do i'oe 'e sae odo-odo. Ma 'onaa na ta'aa, 'iia 'ai 'unua do i'oe 'e sae ta'aa.” ");
INSERT INTO aia_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tara'i Farisei mana Ha'ausuri 'anai Ringe ana'ia Moses rau o'ani 'inia Jisas, “Ha'ausuri, 'i'ameu meu rabasia do'oi haua tana'ameu ta ha'abu'oahu.” ");
INSERT INTO aia_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mia Jisas 'a o'ani 'iniraau, “'Iraaui inoni na'i 'ohani rau ta'aa di'u marau ai'a bonasia suria tarau a God. Rau raba 'omesiai ha'abu'oahu magu 'a bwa'i nei nawai haua tanaraau. 'E ta'i ha'abu'oahu moi narai re'ia, naasi ha'abu'oahu 'onaaiai nei na to'o tanaa Rarabea Jona. ");
INSERT INTO aia_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","'Iia 'a awa na'i ahunai kae ii'a suriai oru dangi mana oru rodo. 'Inau, i Garei Inoni, wai o'asi ro'u. Wai awa na'i hera suria ta oru dangi ma ta oru rodo ro'u. ");
INSERT INTO aia_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na'i dangi ni hihiiri, 'iraaui saeni Ninive rai ura ara'a 'anai 'unua hura'a do 'i'amoui inoni 'ohani mou taritari'a mora. 'Inia na'i 'oha na 'ia Jona 'a heitaroha'i tanaraau, 'iraau rau rihosi baani'i ora-ora'a adaa'i. Mawai 'unua tana'amou, 'e nei na ororiu di'ua ro'ua Jona na ataha'a bei'amou, mi'amou ai'a raba rihosi baani'i ora-ora'a amoo'i. ");
INSERT INTO aia_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na'i dangi ni hihiiri, ni urao mwaeraha baaniai Shiba 'ai ura ara'a mai 'unua do 'i'amoui inoni 'ohani mou taritari'a mora. 'Inia rei'uaa na awa ha'atau 'ari nata aba 'iniai marewana, me 'iia 'a boi 'anai bahurongo'i mwane ha'ausuringa'i ana'ia Mwaeraha Solomon. Minau wai 'unua tana'amou, 'e nei na ororiu di'ua ro'ua Solomon na ataha'a bei'amou mamou ai'a raba bahurongoa.” ");
INSERT INTO aia_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Mia Jisas 'a o'ani ro'u, “Na'i 'oha na adaro 'a hura'a baaniai noni, 'iia 'a hano 'ari suriai dora mangasara 'anai siba dorani mono. Ma 'onaa na bwa'i sadoia ta dora, ");
INSERT INTO aia_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","'iia 'aigui o'ani 'inia haaria, ‘Wai aho'i 'ari mawai siri aho'i na'i sae nau hano baania ani.’ Na'i 'oha na aho'i wou 'a re'ia dona tahinganai saesi 'a 'onaai ruma na bwaranga nara tatara 'orima'inia goro mara nuga ha'a-odoodo'i goroi mwane mareho na'i rarona. ");
INSERT INTO aia_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Na'i 'oha na 'omesia o'asi, 'agu 'ari 'anai waia ro'u mai beia i biu adaro narau ta'aa di'u ro'u wou baania. Na'i 'oha narau siri 'anai mono na'i raronai saesi, ni saesi 'a ta'aa di'u ro'u wou baaniai na'o. 'I'amou moi o'asi ro'u, 'i'amoui sae ta'aa na'i madoraani.” ");
INSERT INTO aia_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","'Oha 'ia Jisas 'a mamaani mau tanaraaui sae rago, 'ia inana miraaui do'orana'i rau boi marau ura na'i abau 'omaa, 'inia rau raba hadahada beia Jisas. ");
INSERT INTO aia_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma'e ta'i sae na o'ani 'inia Jisas, “'Ia inamu miraaui do'oramu'i neiraau hura'asi, rau raba hadahada bei'o.” ");
INSERT INTO aia_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mia Jisas 'a o'ani, “'Iatei inagu miraaua tei do'oragu'i?” ");
INSERT INTO aia_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ma usuraaui rongoiusuri ana'i ma o'ani, “Niraauni inagu mana do'oragu'i. ");
INSERT INTO aia_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","'Iatei na hauai taha Amagu na'i aro na 'irisia do 'ai haa, naasi huunai do'oragu mana asigu mana inagu.” ");
INSERT INTO aia_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mana'i maui dangisi 'ia Jisas 'a hura'a baaniai ruma ma hura'ai bobonai bwera i Galili. 'A heinagu auru 'anai ha'ausuriraaui noni. ");
INSERT INTO aia_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Miraaui sae rago rau ruru mai garigaria. Ma ta'e ara'a na'i ora ma heinagu na'iei miraau sae rago rau ura na'i one 'anai bahurongoa. ");
INSERT INTO aia_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ma haa'i ha'atee heiha'auu 'anai ha'ausuriraau. 'A o'ani, “'E 'oha na 'e ta'i sae na hura'a 'anai hasi korai wiit na'i mou ana. ");
INSERT INTO aia_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma na'i 'oha na rarasanga'ini'i kora, ra'i nei nara to'o na'i tara mana gere manu ra dio mara ngaa'i. ");
INSERT INTO aia_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tara'i nei ra to'o na'i dora hauhau'a, dora na ano 'a ai'a raha mara tahi. Mana 'oha ra tahi, ra tahi goro ga'u moi. ");
INSERT INTO aia_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mana 'oha na sina 'a raorao di'u, ra nugu mara mae aho'i moi, 'inia raridi ra ai'a ganu dio. ");
INSERT INTO aia_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma tara'i kora ra to'o na'i dora ra tahi bei'i waroraraki. Ma na'i 'oha ra tahi ara'a, na waroraraki 'a agu ha'amaesi'i. ");
INSERT INTO aia_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mana kora ra to'o na'i ano goro, ra tahi goro mara hungu. Tara'i nei ra'i 'arangi hua, tara'i nei ra'i ono tangahuru, ma tara'i nei ra'i oru tangahuru.” ");
INSERT INTO aia_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Maagu o'ani ro'u, “Tei na to'o karinga 'anai rongo 'ai bahurongoa mai aidangi tarihana.” ");
INSERT INTO aia_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","'Iraaui rongoiusuri ana'ia Jisas rau boi beia marau o'ani, “Ni 'uaana na'ogu haa'i 'ini'i ha'atee heiha'auu na'i 'oha na'o ha'ausuriraaui sae?” ");
INSERT INTO aia_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mia Jisas 'a aramiraau o'ani, “Na'i na'o, 'ia God ara'ai aro ai'a ha'arangasia he'uai marungiraau nai haa i noni ana'i. Me na'i 'ohani 'a ha'ata'inia tana'amou. Mei tanaraaui nei nara ai'a hinihinia God, 'a ai'a haua o'asi tanaraau. ");
INSERT INTO aia_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","'Iatei na raba aidangisia God, 'ia God 'ai a'oia tanaai aidangi na bwane to'oraa mai aidangisia goro. Mia mo'o na ai'a raba aidangisia God, na gere aidangi na to'oraa, 'ia God 'ai rahia baania. ");
INSERT INTO aia_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'Inau 'au haa'i ha'atee heiha'auu tanaraaui sae 'isi neina rei'uaa narai towa'i 'ome'ome, marau bwa'i matai 'ome 'iraraa, ma'uasi rai towa'i bahurongo, marau bwa'i rongo 'iraraa ma'ua aidangisia. ");
INSERT INTO aia_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","'Au haua o'asi ma ha'a-momori'a i maho na 'unua Rarabea Aisaea o'ani, ‘'Iraaui sae rai bahurongo marai bahurongo marau bwa'i aidangisia ta maho, rai 'ome marai 'ome marau bwa'i 'ome 'iraraa ta maho. ");
INSERT INTO aia_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Rau ha'ababau'i 'adoma'idaa'i, marau ai'a rongorongo goro 'ini'i karingadaa'i, marau kuruha'ini'i maadaa'i. 'Onaa 'a ga'i bwa'i o'asi, rau ga'i 'ome 'irara'i mareho 'ini'i maadaa'i, marau ga'i rongo 'irara'i mareho 'ini'i karingadaa'i, marau ga'i aidangisi'i mareho 'ini'i 'adoma'idaa'i, marau ga'i rihota'i tanaau, mawai ha'agorohiraau baaniai taha na sadoiraau.’” ");
INSERT INTO aia_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mia Jisas 'agu o'ani 'iniraaui rongoiusuri ana'i, “'Ia God 'a ha'agorohi'amou 'inia mou aidangisi'i taha namou re'i'i 'ini'i maamoo'i mamou aidangisi'i taha mou rongo'i 'ini'i karingamoo'i. ");
INSERT INTO aia_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ha'amomori! Wai 'unua tana'amou, 'a ragoi rarabea mana sae odo-odo nara mae hako'a narau raba 'omesi'i taha namou re'i'i, maraugu ai'a 'omesi'i. Marau raba rongo'i mareho namou rongo'i, maraugu ai'a rongo'i.” ");
INSERT INTO aia_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“'Ohani moi bahurongo mamoi rongoai taha naasi 'ado'ado 'anai mamaani 'iniai sae na rarasanga'ini'i kora. ");
INSERT INTO aia_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","I kora ra to'o na'i tara ra ura 'iniraaui nei ra rongoai taroha 'abaiai heimarungi ana God maraugu ai'a aidangisia. 'Agu boi moia Saetan ma ha'a-ai'aa'a baani'i 'adoma'idaa'i. ");
INSERT INTO aia_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","I kora ra to'o na'i ano na hauhau'a 'a ura 'iniraaui nei ra rongoai ha'atee ana God marau daua raurau ha'i wa'ewa'e. ");
INSERT INTO aia_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Marau ai'a daua orea 'inia na ha'atee 'a ai'a ganu dio na'i tahingadaa'i 'onaai hasi'ei nara ai'a ganu auru i raridi. 'Oha na mwani maho ra bwara mara ha'a-mama'airaau 'iniai suria adaau i ha'atee ana God, raugu rihota'i aho'i. ");
INSERT INTO aia_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","I kora ra to'o na'i 'uruhanai waroraraki 'a ura 'iniraaui nei ra rongoai ha'atee ana God maagu tahingadaau 'a ta'aabedaau 'ini'i maho rai tahi 'ini'i na'i marewanani, marau bweu suriai toto'ora ni marewana. Tarana naasi, ni ha'atee ana God 'a ai'a tahi na'i tahingada ma ai'a ha'i hua. ");
INSERT INTO aia_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","I kora ra to'o na'i ano goro 'a ura 'iniraaui nei ra rongoai ha'atee ana God marau aidangisia goro. Mana mwane maho goro ra hura'a baani'i tahingadaa'i 'onaai hungu goro ra hahaa'i hasi'ei. Tara'i nei ra'i 'arangi hua, tara'i nei ra'i ono tangahuru, ma tara'i nei ra'i oru tangahuru.” ");
INSERT INTO aia_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mia Jisas 'a haua ro'u i mamaani heiha'auu o'ani, “Ni heimarungi ana God na awa na'i aro 'a 'onaai taha na to'o tanaai sae na rarasanga'ini'i kora goro na'i mou. ");
INSERT INTO aia_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Na'i rodo, 'oha ra mauru hakoi sae, 'e maeronga na boi ma rarasanga'ini'i ro'u i korai hahaarisi ta'aa ma hano'a. ");
INSERT INTO aia_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na'i 'oha na korai wiit ra tahi ara'a mara hungu, ra'i hahaarisi ta'a'i ra tahi ro'u ara'a bei'i. ");
INSERT INTO aia_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","'Iraaui sae tatau'aro ana'i rau boi marau o'ani, ‘Saemaua, i'oe 'o rarasanga'ini'i moi korai wiit na'i mou amua. Na'i hei naragu boi ro'u ei hahaarisi he'ete'i 'isi?’ ");
INSERT INTO aia_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Mia aramiraau o'ani, ‘'E maeronga nagu boi rarasanga'ini'i ro'u i hahaarisi ta'aa 'isi.’ “Miraau o'ani 'inia, ‘'O 'irisia domei rangu gata'ini'i hahaarisi ta'a'i 'isi?’ ");
INSERT INTO aia_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Mia o'ani 'iniraau, ‘Moi abu, mou gasi rangu goni'i wiit. ");
INSERT INTO aia_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nugaa moi marai tahi goni. Na'i 'oha 'anai ha'igoni'i nawaigui 'unua tanaraaui sae tatau'aro agu'i marai rangu'i'i ga'u i hahaarisi ta'a'i. Rai ha'abobo'i marai suungi'i maraigui ha'igoni'i ro'u i wiit 'anai nuga taguma'ini'i na'i ruma.’” ");
INSERT INTO aia_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mia Jisas 'a haua ro'u i nata ha'atee heiha'auu. 'A o'ani, “Na heimarungi ana God na awa na'i aro 'a 'onaai koranai hasi'ei nara 'unua 'iniai mastad nara hasia na'i mou. ");
INSERT INTO aia_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Rei'uaa na kekerei baani'i hakoi mwani taraani kora, 'oha na tahi ara'a 'a kae raha di'u'i hakoi mwane mareho nara hasi'i na'i mou. 'A aho'ita'i hasi'ei mana raraana ra raha 'ohadi manu 'anai nu'i suri'i.” ");
INSERT INTO aia_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","'Ia Jisas 'a haua ro'u i ha'atee heiha'auuni, “Na heimarungi ana God na awa na'i aro 'a 'onaai urao na dorariai gere dorai draebam beiai ta'i baegi flaoa bubu. Na'i muri, na gere dorai draebamusi 'a ha'asu'uai flaoa ma ha'arahaa'a.” ");
INSERT INTO aia_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","'Ado mamaani na haa'ia Jisas tanaraaui noni hunga, 'a hau'i 'ini'i ha'atee heiha'auu. Ai'a ta mamaani nai haua do'a bwa'i haua 'iniai ha'atee heiha'auu. ");
INSERT INTO aia_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Naasi ma to'o'a i ha'atee rarabea na o'ani, “Wai mamaani tana'amou 'iniai ha'atee heiha'auu mawai maani ruhasi'i taha ra awa bainihu mau mai taraawa'anai ha'apwa'araa adai marewana.” ");
INSERT INTO aia_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mia Jisas 'a hano baaniraaui noni hunga ma siri ruma. Miraaui rongoiusuri ana'i rau boi beia marau o'ani 'inia, “'Oi mamaani ha'a-aidangisi'ameu 'iniai 'ado'ado 'anai hahaarisi ta'aa nara tahi na'i moui wiit.” ");
INSERT INTO aia_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","'Ia Jisas 'a o'ani 'iniraau, “'Ia mo'o na rarasanga'ini'i kora goro, naasi 'inau na Garei Inoni. ");
INSERT INTO aia_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","I mou naasi marewana. Kora goro naasi 'iraaui nei narau awa bahainai heimarungi ana God. Hahaarisi ta'aa neiraausi nei ana'ia Saetan. ");
INSERT INTO aia_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","I maeronga na rarasanga'ini'i korai hahaarisi ta'a'i na'i moui wiit, naasia Saetan. Madoraa ni ha'igoni naasi ha'ahakonai dangi. 'Iraaui nei 'anai ha'igoni neiraausi enjel. ");
INSERT INTO aia_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“'Onaai rahi'i adaa'i hahaarisi ta'a'i mara suu gata'ini'i, 'ai o'asi ro'u na'i ha'ahakonai dangi. ");
INSERT INTO aia_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","'Inau na Garei Inoni, wai ha'ataari'i hura'ai enjel agu'i marai rahi'i hura'a baaniai heimarungi agua 'i sae ora-ora'a mana nei narau ha'atehaai nata nei. ");
INSERT INTO aia_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Marai gaasiraau siri na'i 'eu ngarungaru na raorao. Na'isi naraigu angiangi na'i ei marai 'ara-ngingita'i rihodaa'i 'iniai maata'i. ");
INSERT INTO aia_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Miraaui sae odo-odo rai rara 'onaai sina na'i hourana ana Amadaau. 'Ia tei na'o to'o karinga 'oi bahurongo ma'oi aidangi tarihana.” ");
INSERT INTO aia_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","'Ia Jisas 'a o'ani, “I heimarungi ana God na awa na'i aro 'a 'onaai mareho ororiu na awa na'i ano. I sae na sadoia, 'a wa'ewa'e di'u ma ahunia aho'i ma 'ari raonga'ini'i hakoi mwane mareho ana'i do'ai to'ora ha'a arari, ma'ai horiai dorai ano na awai mareho ororiusi ma do'ai to'oraa nana. ");
INSERT INTO aia_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“I heimarungi ana God 'a 'onaa ro'u i sae raoraonga'i buri magu sibasiba 'ini'i nei goro 'anai hori'i. ");
INSERT INTO aia_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","'Oha na sadoiai nei na goro di'u na bwara di'ui horihorina, 'a aho'i ma raonga'ini'i hakoi bori ana'i ma 'ari 'anai horiai burisi. ");
INSERT INTO aia_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ma ro'u i heimarungi ana God 'a 'onaai hu'o na 'iraaui sae ahu-ahuasi rau arasia na'i asi, na namoiwou ta taraani ii'a he'ete'i hairiu nara to'o na'i ei. ");
INSERT INTO aia_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mana 'oha na honu, ra ogea tarau na'i one, mara heinagu 'anai hoai'i nei goro baani'i nei ta'a'i. Na nei goro ra nuga taguma'ini'i suri'i abira, mana nei ta'a'i ra gaasi'i. ");
INSERT INTO aia_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'Ai o'asi ro'u i here rai hauai enjel na'i ha'ahakonai dangi. Rai hoairaaui sae odo-odo baani'i sae ta'a'i. ");
INSERT INTO aia_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","'Iraaui sae ta'a'i rai gaasiraau siri na'i 'eu ngarungaru na raorao. Na'i 'isi rai angiangi marai 'ara ngingita'i rihodaa'i 'iniai maata'i.” ");
INSERT INTO aia_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","'Ia Jisas 'agu songa'iniraaui rongoiusuri ana'i o'ani, “Mou 'irara'i 'ado'ado 'ada'i ha'atee heiha'auu 'ini?” Miraau o'ani, “Meu 'irara'i.” ");
INSERT INTO aia_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Maagu o'ani 'iniraau, “Hoita, 'iatei sae na aidangisi'i Ringe ana'ia Moses ma aidangisia ro'u i ha'ausuringa'i haoru 'iniai heimarungi ana God na awa na'i aro, 'a 'onaai sae na matai rahi'i hura'a baaniai ruma ana i mwane mareho goro he'ete'i hairiu. I mareho haoru mana nei bwani.” ");
INSERT INTO aia_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Na'i 'oha 'ia Jisas 'a haa'i hakoi mwani ha'atee heiha'auu 'ini, 'a hano baaniai dorasi ");
INSERT INTO aia_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ma aho'i 'ari 'omaa ana na'i Nasaret. 'A siri na'i rumani ha'arahesi 'anai ha'ausuriraaui noni hunga, mana 'oha rau rongoai ha'ausuringa'i ana rau heimwaota'i di'u. Miraau o'ani, “'A 'ua na madoma di'u 'inia mo'oni? 'Iatei na haua tanaa i mena na haa'i 'ini'i mwani ha'abu'oahu 'isi? ");
INSERT INTO aia_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Gau 'iraraa do'ia mo'osi 'e gare ana moi kapentaa. 'Ia Meri naasi inana, mana do'orana'i 'iraaua Jems, Josep, Saemon mia Jiudas. ");
INSERT INTO aia_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mana asina'i ra awa ro'u na'i 'omaani. 'A he'ua na 'irara'i 'ini'i maho 'isi a mo'osi?” ");
INSERT INTO aia_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Naasi rau 'itaa Jisas marau ai'a raba hinihinia. Mia Jisas 'a o'ani 'iniraau, “I rarabea ra ha'ahoua suri'i mwani 'omaa hako. Ta'i moi, na'i 'omaa ana miraau huudi sae ana'i naraugu ai'a.” ");
INSERT INTO aia_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na'i 'omaa anasi ai'a ha'abu'oahu rago naigui haua, 'inia rau ai'a hinihinia. ");
INSERT INTO aia_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na'i 'oha 'ia Herod Antipas, 'i Mwaeraha 'anai Galili, 'a rongo tarohana Jisas, ");
INSERT INTO aia_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","'a o'ani 'iniraaui sae tatau'aro ana'i, “'Iia gasi a Jon Bwareomaea na tahi aho'isi baaniai mae. Naia na haa'i 'ini'i mwane ha'abu'oahu rago 'isi.” ");
INSERT INTO aia_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Na'i na'o wou, 'oha na tahi mau a Jon, 'ia Herod 'a waina Herodias, urao ana ga'u a Pilip, mia Pilip 'e do'orana Herod. 'Oha 'ia Jon 'a 'unua tanaa Herod do 'a ai'a odo-odo do'ai wainai urao na waina ga'u i do'orana, 'ia Herod 'a taesu'a ma 'unua tanaraaui sae hehei'oi dorai daua Jon. Rau ho'osia 'iniai arihau marau nugaa na'i rumaniho'o. ");
INSERT INTO aia_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","'Ia Herod 'a raba ha'amaesia Jon magu magugu 'iniraaui noni hunga, rau gasi ha'ato'oa ta ha'agogoru 'inia rau aidangisia do 'ia Jon 'e rarabea. ");
INSERT INTO aia_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hoita, na'i dangi ra ngaugoni 'anai 'adoma'i aho'isiai dangi na huta Herod, 'e gare urao ana Herodias 'a siri mai mao 'anai ha'a-reirei'araau, mia Herod 'a wa'ewa'e di'u 'anai reireia. ");
INSERT INTO aia_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","'A hauai duruduru na wetewete tanaa do'ai haua tanaa namoiwou ta mareho nai 'irisia. ");
INSERT INTO aia_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Me suriai hei'irisinai inana, i gare uraosi 'a o'ani, “'Au 'irisia dorai haua tanaau i bwauna Jon Bwareomaea na'i ta rabo'o papaheta'a.” ");
INSERT INTO aia_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","'Ia Herod 'a ahutotou ma 'adoma'i aho'i, ma bwara'a 'inia 'a bwane haua'a i duruduru ma bwara'a ro'u do'aigui horosia na'i maadaaui sae na ari'ahuraausi. Mia Herod 'a ha'atoraraaui sae hehei'oi dorai ha'a-'osia'a. ");
INSERT INTO aia_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Naasi rau 'ari rumaniho'o marau o'iai 'u'una Jon Bwareomaea. ");
INSERT INTO aia_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Rau waia mai bwauna na'i rabo'o tanaai gare urao ana Herodias maagu waia 'ari tanaa inana. ");
INSERT INTO aia_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","'I abena Jon 'iraaui rongoiusuri ana'i naraugu boi waia narau 'ari toringia. Na'i muri naraugu taroha'inia tanaa Jisas 'i mareho na to'osi. ");
INSERT INTO aia_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na'i 'oha na 'ia Jisas 'a rongoai mae ana Jon Bwareomaea, 'a ta'e haaria na'i ora ma 'ari na'i dora bwaranga na ai'a ta sae nai awa iei. 'Oha na 'iraaui sae rago raugu 'iraraai dora na 'ari iei a Jisas, rau hano baani'i 'omaa adaa'i marau hatare haisuri. ");
INSERT INTO aia_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","'Oha nagu 'oto wou na'i one ma re'iraaui sae rago rau heimamasi, 'a ta'ahiraau ma ha'agorohiraau aho'i nei ra daoha. ");
INSERT INTO aia_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","'Oha na gaarangi suu'a i sina, 'iraaui rongoiusuri rau boi beia Jisas marau o'ani 'inia, “'A gaarangi rodo'a naani! 'Oi ha'ahanoriraau aho'i sae 'ini marai 'ari suri'i 'omaa 'anai hori 'adaau mahoingau. 'Inia dorani 'a ai'a ruma'a.” ");
INSERT INTO aia_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mia Jisas 'a o'ani, “'A ai'a goro dowai ha'ahanoriraau, 'i'amou namoi ha'i 'adaau mahoingau.” ");
INSERT INTO aia_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Miraaui rongoiusuri rau o'ani, “'E rima gere huai bredi mana rua ii'a moi na bei'ameuni.” ");
INSERT INTO aia_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mia Jisas 'a o'ani, “Moi haa'i mai tanaau.” ");
INSERT INTO aia_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","'A ha'a-heinagusiraaui sae 'isi na'i mwane hahaarisi maagu dauai rima huai bredi mana rua ii'a. 'A wana ara'ai aro ma ha'atee ha'agorohia God 'inia. Ma uubi'i bredi 'isi maagu haa'i tanaraaui rongoiusuri naraugu ha'atora'ini'i tanaraaui sae rago. ");
INSERT INTO aia_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","'Iraau hako rau ngau masu mana mahoingau narau ngau tahi'i rau si'o ha'ahonua 'iniai ta'i tangahuru mana rua abira. ");
INSERT INTO aia_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","'A 'onaai rima merui saemwane narau ngau masu hako ha'atai na'i dangisi. Ni urao mana gare ra ai'a uduma'iniraau. ");
INSERT INTO aia_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Na'i muri 'ia Jisas 'a o'ani 'iniraaui rongoiusuri ana'i, “Moi ta'e na'i ora ma moi gagaau 'ari nata batarau. 'Inau wai awa ga'u.” Naasi mia Jisas 'a awa moi beiraaui kae ruruhai saesi tari 'oha na ha'ahanoriraau aho'i 'ari suri'i 'omaa adaa'i. ");
INSERT INTO aia_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","'Oha na ha'ahanoriraau hakoi sae, 'a ta'eha haaria na'i hungahunga 'anai ha'arahesi. Ma su'urahi'a. Mia Jisas 'a awa mau haaria na'isi. ");
INSERT INTO aia_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na'i 'ohasi 'iraaui rongoiusuri rau hano ha'atau'a na'i ora baaniai one. Na tabaosi ra raha di'u mara abwao ta'eha huniraau na'i ora 'inia rau hano suaai ro'a raha. ");
INSERT INTO aia_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na'i wa'aria 'ia Jisas 'a boi beiraaui rongoiusuri ana'i, 'a hahano na'i hunganai wai. ");
INSERT INTO aia_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","'Oha rau 'omesia rau 'adoma'inia do'e anoa. Rau mamaa'u di'u marau awaawara. ");
INSERT INTO aia_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mia Jisas 'a o'ani 'iniraau, “'Ai abui ta'aabemoou! 'Inau moia Jisas na! Moi abui mamaa'u.” ");
INSERT INTO aia_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mia Pita 'a o'ani, “Araha, 'onaa i'oe ha'a-momori ma'oi 'unuau mawai 'ariwou bei'o na'i hunganai wai.” ");
INSERT INTO aia_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Mia Jisas 'a o'ani, “'Oi boi.” Mia Pita 'a dio baaniai ora ma hahano 'ari beia Jisas na'i hunganai wai. ");
INSERT INTO aia_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","'Oha 'ia Pita 'agu 'omesi'i tabaosi, naasi ma mamaa'u ma taraawa'a dodo'a. Mia Pita 'a awara, “Araha, 'oi 'a'auhiau!” ");
INSERT INTO aia_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na'i mau 'ohasi mia Jisas 'a ta'ara wou ma daua ara'a Pita, 'a o'ani 'inia, “Hinihinimu 'a kekerei! 'A 'ua na'o 'adoma'i heiruarua'a 'inia?” ");
INSERT INTO aia_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na'i 'oha 'ia Pita mia Jisas rarugu ta'e ara'a na'i ora, mana ro'a 'a papaku'a. ");
INSERT INTO aia_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","'Iraaui rongoiusuri narau awa na'i ora raugu re'ia o'asi marau ha'arahesia Jisas, rau o'ani, “Ha'amomori, i'oe garena God.” ");
INSERT INTO aia_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jisas mana rongoiusuri ana'i rau haruta 'ari nata batarau ma rau 'oto na'i dora ra 'unua 'iniai Genesaret. ");
INSERT INTO aia_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na'i 'oha na 'iraaui sae rau 'ome 'iraraa Jisas, 'a ai'a orea mana taroha 'iniai ada rau haa 'a 'adarara'a 'ari suriai dorasi. Miraaui sae ra wairaau'a mai sae daoha tanaa Jisas 'anai ha'agorohi'i aho'i. ");
INSERT INTO aia_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","'Iraaui sae daoha rau bonga'inia Jisas dorai karohia moi gaonai to'oni tewa ana. 'Iraaui nei rau haua o'asi rau goro aho'i baani'i daoha nara to'iraau. ");
INSERT INTO aia_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tara'i Farisei mana Ha'ausuri 'anai Ringe ana'ia Moses rau boi baaniai Jerusalem 'anai songa'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Rau o'ani 'inia, “Ni 'uaana na 'iraaui rongoiusuri amu'i rau horosia 'inia i ha'ausuringa'i narau ha'adiohi'i mai tanagaau i wauwa agaa'i na'i 'ohai na'o? Rau ai'a suriai huunai herehere 'anai dorima maraigu ngau.” ");
INSERT INTO aia_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mia Jisas 'a aramiraau o'ani, “Mi'amou, ni 'uaana namou horosia 'iniai Ha'atora ana'ia God mamougu suri'i moi 'inia i ha'ausuringa'i amoo'i haari'amou? ");
INSERT INTO aia_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mou 'iraraa do 'ia God 'a bwane 'unua o'ani, ‘'Oi ha'ahoua amamu mea inamu’ ma o'ani ro'u, ‘Tei na 'unu ha'ata'aia amana mea inana rai ha'amaesia.’ ");
INSERT INTO aia_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Me'imoou mou 'unua dona 'a odo-odo moi 'onaa tanei 'ai o'ani 'inia inana mia amana, ‘Ha'a-arohai'amurua, 'au ga'i 'a'auhimurua 'ini'i maho nau to'ora'i. Me 'au bwa'i 'a'auhimurua'a. Suria maho nau to'ora'i ra maea'a. 'Inia 'au bwane wate'i tanaa God.’ Ma naasi mou here 'onaa do ha'ausuringa'i amoo'i ra ororiu di'uai Ha'atee ana God. ");
INSERT INTO aia_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Mou here 'onaa domou goro, ma'ata ai'a! Maho na 'ia Aisaea 'a ha'atee rarabeanga'inia, 'a to'i'amou ha'a-momori'a. ");
INSERT INTO aia_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'A 'unua o'ani, ‘'Iraau sae 'ini rau ha'ahouau 'ini'i ngoodaa'i, magu 'adoma'idaa'i ra awa ha'atau di'u baaniau. ");
INSERT INTO aia_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","I ha'arahesi adaa'i ra 'ari pwaranga, 'inia rau orisi'i Ha'atora ana'ia God 'ini'i ha'ausuringa'i adaa'i haraariraau na inoni moi na haa'i.’” ");
INSERT INTO aia_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mia Jisas 'a 'unuraaui noni hunga magu o'ani 'iniraau, “Moi bahurongo goro mamoi aidangisiai taha nawai 'unua tana'amou. ");
INSERT INTO aia_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","I mahoingau na'oi ngaua 'a bwa'i matai ha'ado'o'a'o na'i maana God. Naia na maho na'o 'unu'i nara hura'a baaniai ngoomu na matai ha'ado'o'a'o.” ");
INSERT INTO aia_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","'Iraaui rongoiusuri ana'ia Jisas rau boi beia marau o'ani, “'Iraaui Farisei rau arunga ta'aa 'iniai maho na'o 'unua ani.” ");
INSERT INTO aia_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mia aramiraau o'ani, “'Adonai hasi'ei na ai'a hasi'i a Amagu, 'ia Amagu 'ai rangu gata'ini'i. ");
INSERT INTO aia_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Naasi 'ai abui ta'aabemoou 'iniraaui Farisei. 'Iraausi rau 'onaai sae kuru na uruai nata sae kuru, 'irarua hako rarui ahoda dio na'i giru.” ");
INSERT INTO aia_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","'Ia Pita 'a 'unua tanaa Jisas o'ani, “'Oi maania tana'ameui 'ado'ado 'anai maho na'o 'unua ani, do sae 'a bwa'i matai do'o'a na'i maana God 'inia moi mahoingau na ngaua.” ");
INSERT INTO aia_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mia Jisas 'a o'ani 'inia Pita, “'A 'ua? 'O ai'a aidangisia mau? ");
INSERT INTO aia_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","'O ai'a 'iraraa do maho na'o ngaua 'a dio na'i bwahurimu ma hura'a aho'i baaniai abemu? ");
INSERT INTO aia_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","'I maho ta'aa na 'unua i sae 'a hura'a baaniai raromana, ma naia na matai ha'ado'o'aa na'i maana God. ");
INSERT INTO aia_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Baaniai raromana na hura'a mai ei 'ado'ado ta'aa, 'onaai heingahu, taritari'a baaniai urao amua ma'ua mwane amua, wawaasua'a, beri, pwapwaari'i, mana 'unu ha'ata'aiai nata sae. ");
INSERT INTO aia_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nara 'isi mareho na matai ha'ado'o'aai sae na'i maana God, ai'a do 'iniai ngau ha'i ai'a dorima.” ");
INSERT INTO aia_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","'Ia Jisas 'a hano baaniai dorasi, 'a 'ari suriai dora gaarangiai kae 'omaai Taea mana Saedon. ");
INSERT INTO aia_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma 'e urao na ai'a Jiu na awa 'isi. 'Iia baaniai burungana Kenan. 'A boi beia Jisas ma o'ani, “Araha, pwirana Deved. 'Oi arunga ta'ahiau ma'oi 'a'auhiau! Gare urao agua, 'i adaro 'a bwaunia. 'A here ha'ata'aia di'u ma rongomaata'i raha.” ");
INSERT INTO aia_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","'Ia Jisas 'a ai'a aramia 'inia ta ta'i ha'atee. Miraaui rongoiusuri rau ha'ata'u'ua Jisas o'ani, “'Oi ha'ataaria aho'i mai hano'a wou. 'Inia 'iia 'a surigaau moe'a magu wamoi ta'i awara.” ");
INSERT INTO aia_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mia Jisas 'a o'ani 'iniai uraosi, “'Ia God 'a ha'ataariau mai 'anai 'a'auhiraau moi Jiu narau 'onaai siip nara tari baaniai 'omesuri siip. 'Au ai'a boi 'iniraaui nei narau ai'a ha'i saeni Jiu.” ");
INSERT INTO aia_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mana uraosi 'a boi ma topira'i ruru na'i maana Jisas ma o'ani 'inia, “'Oi boi ma'oi 'a'auhiau Araha.” ");
INSERT INTO aia_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mia Jisas 'a o'ani 'inia, “'A ai'a arari dorai haa'i mahoingau adaa'i gare ma do raigui gaasi'i 'ada'i misu.” ");
INSERT INTO aia_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mana uraosi 'a ha'atee o'ani, “'O ha'atee ha'a-momori. Ma'ata 'iraaui misu rau matai ngaa'i ro'u moi mamamo i mahoingau nara ahoda baaniai hunganai dora ngaungau adaa'i sae nara to'oraraau.” ");
INSERT INTO aia_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mia Jisas 'a o'ani 'inia, “Urao, 'i hinihinimu 'a wetewete di'u! 'I mareho na'o 'irisiasi wai haua tana'o.” Na'i mau na'i 'ohasi mana gare anai uraosi 'a goro'a aho'i. ");
INSERT INTO aia_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","'Ia Jisas 'a hano baaniai dorasi ma aho'i 'ari suriai bobonai kae bwera i Galili. 'A ta'eha na'i hungahunga ma heinagu na'iei. ");
INSERT INTO aia_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kae ruruhai sae rau boi beia, rau waa'i mai tanaa i sae pwaki, 'iraaui sae kuru, 'iraaui sae ta'ata'a'i, 'iraaui sae baanguu mana nei haru daoha hehe'ete'i ro'u na to'iraau. Rau ha'adaohiraau na'i gaarangiai uwana'i a Jisas mia Jisas 'a ha'agorohiraau aho'i hako. ");
INSERT INTO aia_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","'Iraaui sae rago rau 'omesiai haua ana o'asi a Jisas marau heimwaota'i di'u. 'Iraaui nei ra baanguu ga'u rau ha-hadahada'a, 'iraaui sae ta'ata'a'i ra goro'a, 'iraaui nei ra pwaki ra hahano hairiu, miraaui nei ra kuru ga'u rau wanawana'a. 'Iraaui sae rago rau ha'a-aneanea God adaau Israel. ");
INSERT INTO aia_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","'Ia Jisas 'a 'unuraaui rongoiusuri ana'i ma o'ani 'iniraau, “'Au ta'ahiraaui sae 'ini, 'inia 'e oru dangi narau awa'a 'ini beigaau ma na'i 'ohanisi raugu ai'a to'o mahoingau'a 'anai ngau. Maugu ai'a raba ha'a-taariraau ha'i hioro 'ari suri'i 'omaa adaa'i. Rau gasi dionga'i suri tara.” ");
INSERT INTO aia_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","'Iraaui rongoiusuri rau o'ani 'inia Jisas, “Na'i hei na'i dora mangasarani nagau ga'i ha'i mahoingau arari 'ada'i mwane sae 'ini?” ");
INSERT INTO aia_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mia Jisas 'a songa'iniraau o'ani, “'E siha huai bredi na bei'amou?” Ma rau aramia o'ani, “'E biu hua moi ma ra'i gere ii'a.” ");
INSERT INTO aia_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","'Ia Jisas 'agu 'unua tanaraaui sae 'anai heinagu dio na'i ano ");
INSERT INTO aia_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ma dauai biu hua bredi mana ii'a 'isi. Mana 'oha na ha'atee ha'agorohia hako a God 'ini'i, 'a uubi'i ma haa'i tanaraaui rongoiusuri ana'i naraugu ha'atora'ini'i tanaraaui sae. ");
INSERT INTO aia_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","'Iraau hako rau ngau masu. Rau si'ohi'i dora i mahoingau narau ngau tahi'i, rau ha'ahonuai biu abira. ");
INSERT INTO aia_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","'Iraaui sae narau ngau na'i 'ohasi 'e hai merui saemwane. Ra ai'a uduma'ini'i urao mana gare. ");
INSERT INTO aia_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","'Ia Jisas 'a ha'ahanoriraau aho'i sae 'isi, maagu ta'e na'i ora beiraaui rongoiusuri ana'i. Rau 'ari na'i dora ra 'unua 'iniai Magadan. ");
INSERT INTO aia_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tara'i Farisei mana Sadiusi rau boi beia Jisas do rai ha'imaania. Rau ha'angonia do 'ai haua ta ha'abu'oahu ma'uasi ta ha'ara ma dorai 'iraraa do'ia God na ha'ataaria mai. ");
INSERT INTO aia_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mia Jisas 'a o'ani 'iniraau, “'I'amou mou 'iraraai ha'ara na'i aro. Na'i su'urahi 'oha na aro 'a wangawanga, mou ha'arangasia do ho'oa 'ai dangi goro. ");
INSERT INTO aia_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mana'i haho'oa, 'oha na aro 'a wangawanga ma waikuhi'a, mamou ha'arangasia do'ai dangi ta'aa. Mou aidangisi'i moi ha'ara ni aro mamougu ai'a aidangisiai 'ado'ado 'ada'i mareho nau haa'i na'i madoraa 'ini! ");
INSERT INTO aia_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","'Iraaui inoni na'i 'ohani rau ta'aa di'u marau ai'a bonasia suria tarau a God. Rau raba 'omesiai ha'abu'oahu magu 'a bwa'i nei nawai haua tanaraau. 'E ta'i ha'abu'oahu moi narai re'ia, naasi ha'abu'oahu 'onaaiai nei na to'o tanaa Jona.” 'Ia Jisas 'agu 'unua o'asi moi tanaraau ma hano'a baaniraau. ");
INSERT INTO aia_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","'Oha narau 'a'ari mau 'anai nata bataraui kae bwera i Galili miraau rongoiusuri raugu aidangisia dorau kaku'aai waa'i tadaa'i bredi. ");
INSERT INTO aia_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","'Ia Jisas 'a ha'atee ha'abasuraau o'ani, “Moi 'ome'ome goro mamoi 'omesuri'amou baaniai draebam adaaui Farisei mana Sadiusi.” ");
INSERT INTO aia_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","'Iraaui rongoiusuri rau hasi hadanga'i haraariraau, rau o'ani, “Gau ai'a to'o bredi na 'unua o'asi 'iniasi.” ");
INSERT INTO aia_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","'Ia Jisas 'a 'iraraai taha rau maania ma o'ani 'iniraau, “Hinihinimoo'i ra kekerei di'u. 'A 'ua namou hadanga'inia 'inia i ai'a to'o bredi amoou? ");
INSERT INTO aia_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mou ai'a aidangisia mau? 'A 'ua? Mou kaku'aai rima merui sae nau ha'angaua 'inia moi rima huai bredi, mana abira namou ha'ahonu'i 'ini'i mahoingau nara ngau tahi'i? ");
INSERT INTO aia_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mamou kaku'aa ro'u i hai merui sae nau ha'angaua 'inia moi biu huai bredi mana siha abira namou ha'ahonu'i 'ini'i mahoingau nara ngau tahi'i? ");
INSERT INTO aia_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'A 'ua namou 'adoma'inia 'inia do'au hadanga'iniai ai'a to'o bredi amoou? Wai 'unua aho'i ro'u tana'amou. Moi 'omesuri'amou baaniai draebam adaaui Farisei mana Sadiusi.” ");
INSERT INTO aia_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na'i 'ohasi raugu aidangisia do'ia Jisas 'a ai'a hadanga'iniai draebam anai bredi, ma'ata 'a rabasia dorai 'omesuriraau baaniai ha'ausuringa'i adaaui Farisei mana Sadiusi. ");
INSERT INTO aia_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","'Oha 'ia Jisas mana rongoiusuri ana'i rau ada wou gaarangiai 'omaai Sisaria Pilipae, 'ia Jisas 'a songa'iniraaui rongoiusuri ana'i o'ani, “'Iraaui sae rau 'unuau i Garei Inoni 'inia tei?” ");
INSERT INTO aia_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Miraau o'ani, “Tara'i sae ra 'unua do i'oe a Jon Bwareomaea, tara'i nei ra 'unua do i'oe a Elaija, ma tara'i nei do i'oe a Jeremaea, ma tara'i nei ro'u do i'oe 'e ta'i 'iniraaui haru rarabea ni 'oha bwani.” ");
INSERT INTO aia_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mia Jisas 'a o'ani 'iniraau, “Mi'amou, mou 'adoma'inia do 'inau atei?” ");
INSERT INTO aia_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Mia Saemon Pita 'a o'ani 'inia, “I'oe naasi Ha'atahi na 'ia God na duruduru 'inia 'anai ha'ataaria mai. I'oe garena God tahitahi.” ");
INSERT INTO aia_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","'Ia Jisas 'a o'ani 'inia Pita, “Ha'amwani'o Saemon garena Jona, 'iniai taha na'o ha'arangasiani, 'ia Amagu ara'ai aro na ha'ata'inia tana'o, ai'a inoni. ");
INSERT INTO aia_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ni 'ado'ado 'anai atamusi 'e hau, mana'i hunganai hauni wai tau'aronai heisoi agua. I mena anai mae 'a bwa'i ha'ahehoa mwada'u i heisoi. ");
INSERT INTO aia_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma wai haua tana'o i kii anai hourana ana God na'i aro. Taha na'oi ha'aabua na'i ano, 'ia God 'ai 'adoma'i aratara bei'o 'inia na'i aro. Mana taha na'oi ha'awatea na'i ano, 'ai 'adoma'i aratara ro'u bei'o 'inia na'i aro.” ");
INSERT INTO aia_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ma ha'atee ha'abasuraaui rongoiusuri dorai abu taraa to'o maania do'iia naasi Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Taraawa'a na'i 'ohasi ma 'ari'a, 'ia Jisas 'a taraawa'a maani ha'arangasia tanaraaui rongoiusuri ana'i 'ari nai haua na'i Jerusalem mana taha nai to'o tanaa na'i 'isi. 'A 'unua tanaraau do 'iraaui Na'ohadaa'i Piriisi miraaui Ha'ausuri 'anai Ringe ana'ia Moses ma tara'i na'otara ro'u rai ha'a-rongomaata'ia marai ha'amaesia. Ma'ata 'e rua dangi nai hako mana'i oruna 'aigui suruta'e aho'i. ");
INSERT INTO aia_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mia Pita 'a waia beira'i a Jisas 'anai ha'atee ha'abwarasia magu o'ani 'inia, “Araha, 'abwa'i! 'Ia God 'a bwa'i ha'awatea do'ai to'o tana'o i maho na'o maaniasi.” ");
INSERT INTO aia_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mia Jisas 'a rihota'i tanaa Pita ma o'ani 'inia, “Saetan, hora wou baaniau! 'O bonasiai ha'atehaau baaniai hei'irisina God. Na maho na 'o 'unu'i 'isi ai'a 'ado'adona God, ma'ata ra'i 'ado'ado ni noni moi!” ");
INSERT INTO aia_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","'Ia Jisas 'a o'ani 'iniraaui rongoiusuri ana'i, “'Iatei na raba ha'i rongoiusuri agua, 'ai nugasiai hei'irisina haaria, 'ai mwa'emwa'e 'anai suru'iai dadaahoro ana, maai suriau. ");
INSERT INTO aia_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","'Iatei na raba dau baabau na'i tahingana na'i marewanani, 'a bwa'i to'oraai huunai tahi. Me 'iatei na mwa'emwa'e 'anai ha'a-ai'aai tahingana 'iniai suriau ana, 'ai sadoia nana i tahi. ");
INSERT INTO aia_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","'A 'ua? 'Onaa tanei 'ai daa'i hako nana i marehoni marewana, ma ai'a daua nana i huunai tahi, mareho 'isi rai 'a'auhia? 'A bwa'i! 'Onaa 'ai mae, 'a bwa'i maho naigu haa 'anai horia aho'i tahingana. ");
INSERT INTO aia_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","'Inaui Garei Inoni wai aho'i ro'u mau mai bei'i enjel ana'i Amagu ma beiai mena mana raraha na ta'isada beia 'anai tahariai 'adonai nei suriai taha na haua. ");
INSERT INTO aia_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tara'i nei 'ini'amoui sae 'ini mou bwa'i mae mau minau i Garei Inoni wai aho'i'a mai 'anai marungiraau hako i mwani noni.” ");
INSERT INTO aia_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","'E ono dangi na hako, 'ia Jisas 'a waia Pita, Jems mea Jon, i rua ha'ido'orada, 'anai ta'eha haariraau na'i hunganai hungahunga ahaaha. ");
INSERT INTO aia_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Raugu 'ome mana 'omehana Jisas 'a orisi'a. I hauraena tari auru na'i 'u'una 'a wadora'i 'onaai sina mana bwana ana'i ra mamaahui 'onaai marewa. ");
INSERT INTO aia_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Raugu 'asu'a mia Moses mia Elaija raru ha'amaranga mararu mamaani beia Jisas. ");
INSERT INTO aia_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mia Pita 'a o'ani 'inia Jisas, “Araha, 'a goro nagau awa 'ini. 'Onaa 'o 'irisia, 'inau wai tau'arona ta oru hare, tanei tana'o, tanei tanaa Moses, ma tanei tanaa Elaija.” ");
INSERT INTO aia_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Na'i 'oha na ha'atee o'asi mau a Pita, 'e rorodo na wadora'i na dio huniraau ma marumarusiraau. Ma'e ringe na ao mai baaniai rorodosi, 'a o'ani, “Naani gare agua nau ta'ahia mau huunai wa'ewa'e 'inia. Moi rongosuria.” ");
INSERT INTO aia_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","'Oha 'iraau oru rongoiusurisi rau rongoa o'asi, rau kae mamaa'u di'u marau abwa dioi ano. ");
INSERT INTO aia_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mia Jisas 'a boi ma dau wou beiraau ma o'ani, “Moi abui mamaa'u, moi ura ara'a.” ");
INSERT INTO aia_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Raugu wana wou mia moi haaria Jisas nagu awa beiraau. ");
INSERT INTO aia_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","'Oha 'ia Jisas mana oru rongoiusuri ana rau didio mau na'i hungahunga, 'ia Jisas 'a ha'atoraraau o'ani, “Moi abui maania tanaa ta sae i taha namou re'ia, tari 'oha 'inau i Garei Inoni wai suruta'e aho'i baaniai mae.” ");
INSERT INTO aia_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","'Iraaui rongoiusuri rau songa'inia o'ani a Jisas, “'A 'ua na 'iraaui Ha'ausuri 'anai Ringe ana'ia Moses rau 'unua 'inia do'ia Elaija 'ai boi ga'u na'i na'o maigu boi Ha'atahi?” ");
INSERT INTO aia_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mia aramiraau o'ani, “'A ha'a-momori. 'Ia Elaija 'ai boi na'i na'o 'anai ha'a-agauhiraaui mwani noni 'anai boi anai Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma'ata wai 'unua tana'amou, 'ia Elaija 'a bwane ada'a magu 'iraaui sae rau ai'a 'ome 'iraraa. Rau haa'i moi mwane here nara ai'a goro tanaa suriai 'adoma'ida. 'Inaui Garei Inoni rai haua o'asi ro'u tanaau.” ");
INSERT INTO aia_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na'i 'ohasi 'iraaui rongoiusuri raugu aidangisia do'ia Jisas 'a hadanga'inia Jon Bwareomaea. ");
INSERT INTO aia_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","'Oha 'ia Jisas mana oru rongoiusuri ana rau ataha dioi gaonai hungahunga, 'iraaui sae rago rau bwane mamasi 'isi. 'E sae na boi ma topira'i ruru auru tanaa Jisas ma o'ani 'inia, ");
INSERT INTO aia_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Araha, 'oi ta'ahiai gare mwane agua ma'oi 'a'auhia. 'A manumanu'a, daohasi 'a here ha'ata'aia di'u. 'A rago'a i 'oha na ahuge'a ara'ai 'eu mana'i wai ro'u. ");
INSERT INTO aia_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","'Au waia tanaraaui rongoiusuri amu'i dorai ha'agorohia aho'i magu bwara tanaraau.” ");
INSERT INTO aia_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mia Jisas 'a o'ani, “'I'amou inoni na'i 'ohani mou ha'i sae ta'a'i mamou bwarai hinihini! 'Ai orea he'uai maratanoa nawai haua bei'amou, ma'ua wai awa orea tari he'ua bei'amou mamoigu hinihini? Waia mai garesi.” ");
INSERT INTO aia_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mia Jisas 'a taaria hura'ai adaro mana garesi 'a goro aho'i mau na'i 'ohasi. ");
INSERT INTO aia_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na'i muri 'iraaui rongoiusuri raugu boi haariraau beia Jisas marau o'ani 'inia, “'A 'ua na bwara 'inia tana'ameu 'anai taaria hura'ai adaro ani?” ");
INSERT INTO aia_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mia Jisas 'a o'ani, “Hinihinimoo'i ra ai'a wetewete arari. Wai 'unua ha'a-momori tana'amou: 'Onaa namoi to'oraai gere hinihini na kekerei moi 'onaai korai mastad, mou ga'i ha'atee o'ani moi 'iniai hungahunga wouni, ‘'Oi sara wou,’ mai matai sara ha'atau moi. 'A bwa'i maho nai bwara tana'amou 'onaa namoi hinihini. ");
INSERT INTO aia_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ma'ata adaro 'onaai neini 'a bwarai hura'a, naia moi ha'ariri mana ha'arahesi na matai hura'a 'inia.” ");
INSERT INTO aia_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","'E ta'i dangi, 'oha rau awa na'i Galili, 'iraau rongoiusuri ana'ia Jisas rau rurugoni mai beia. Mia Jisas 'a o'ani 'iniraau, “'E nei nai usuha'iniau i Garei Inoni tanaraaui nei narau ha'imae beiau ");
INSERT INTO aia_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","marai ha'amaesiau. Ma'ata 'e rua dangi nai hako mana'i oruna, wai suruta'e aho'i baaniai mae.” Miraaui rongoiusuri rau arunga ta'aa di'u 'iniai mareho na maaniasi. ");
INSERT INTO aia_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","'Oha 'ia Jisas mana rongoiusuri ana'i rau ada na'i Kapaniam, 'iraaui sae ha'atakisi 'anai Ruma Maea rau boi beia Pita marau songa'inia 'inia, “'I ha'ausuri amoou 'a matai hori takisi ro'u tanaai Ruma Maea, ma'ua ai'a?” ");
INSERT INTO aia_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Mia Pita 'a o'ani, “'Io, 'a matai hori takisi ro'u.” Mia Pita 'a siri ruma narau awa iei. Ai'a ta maho mau nai 'unua Pita mia Jisas 'a o'ani'a 'inia, “Saemon Pita, 'e taha na'o 'adoma'inia? 'O 'adoma'inia do 'iraaui mwaeraha nai marewanani rau matai ha'atakisi'i ro'u i gare adaa'i ma'ua 'iraau moi sae he'ete'i?” ");
INSERT INTO aia_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mia Pita 'a o'ani, “'Iraau moi sae he'ete'i.” Mia Jisas 'a o'ani 'inia, “'A o'asi'a. 'Iraaui gare adaa'i mwaeraha rau ga'i bwa'i hori takisi. ");
INSERT INTO aia_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma'ata rei'uaa na o'asi, gai abu ha'a-taesu'araaui sae ha-ha'atakisi. Naasi 'oi hura'ai one ma'oi gaasia hura'ai 'aro amua. Ii'a tahamora na'oi raua, 'oi tetesiri na'i ngoona ma'oi rahia hura'ai sereni na awa na'iei ma'oi 'ari hori takisi taragaraa.” ");
INSERT INTO aia_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na'i maui 'ohasi 'iraaui rongoiusuri rau boi beia Jisas marau o'ani, “'Iatei nai ororiu di'u na'i hourana ni aro?” ");
INSERT INTO aia_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Mia Jisas 'a 'unua mai gare kekerei ma ha'a-urasia na'i maadaau magu o'ani, ");
INSERT INTO aia_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“'Onaa 'o bwa'i orisi ma'oi ha'a-anoano'o 'onaai gare, 'o ai'a arari 'anai siri na'i hourana ni aro. ");
INSERT INTO aia_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ma'ata 'onaa na'oi ha'a-anoano'o 'onaai gareni, 'oi ororiu di'u na'i hourana ni aro. ");
INSERT INTO aia_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'Onaa 'o ha'amaotoa ta nei 'onaai gareni suria 'o ta'ahiau, 'o ha'amaotoau ro'u.” ");
INSERT INTO aia_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“'Onaa 'ia tei sae nai raba ha'atehaa tanei 'iniraaui nei kekerei 'ini narau hinihiniau, 'a goro do ra ga'i ho'osia ta kae hau na'i 'u'una. Ma rai waia hura'ai asi su'u ma rai ha'adodohia dio. 'Inia na ha'a-mama'ai na 'ia God nai haua tanaai nei nai ha'atehaa tanei 'iniraau, 'ai ta'aa di'u ro'u wou. ");
INSERT INTO aia_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ha'arohairaau di'u i noni nai marewanani. 'Inia ra rago i mareho nara matai ha'ateharaau 'anai hauai ora-ora'a. Ha'amomori, i mareho narai hauai ora-ora'a tanaai inoni rai to'o. Ma'ata 'ai ta'aa di'u ro'u wou tanaa mo'o nai ha'atehaai nata sae 'anai hauai ora-ora'a. ");
INSERT INTO aia_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“'Onaa na rimamu ma'ua uwamu nai haai maho na'o ora-ora'a 'inia, 'oi horo gaasinga'inia moi. 'A goro do'oi dauai tahi tarau beia moi ta'i rima mana ta'i uwa, baaniai siri na'i 'eu na bwarai kuru beiai rua uwamu mana rua rimamu hako. ");
INSERT INTO aia_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma 'onaa ta maamu nai haai maho na'o ora-ora'a 'inia, 'oi kaania ma'oi gaasia. Ai'a goro dorarui awa hakoi rua maamu maraigui gaasi'o na'i 'eu na'i dorani rongomaata'i. 'A goro baania do'oi dauai tahi tarau beia moi ta'i maa.” ");
INSERT INTO aia_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mia Jisas 'a o'ani ro'u, “Moi 'ome'ome goro. Mou gasi 'adoma'i ha'a-auruhia moi ta nei 'ini'i gare kekerei 'ini. Wai 'unua tana'amou, ni enjel adaa'i ra awa tarau beia Amagu na'i aro. ");
INSERT INTO aia_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","'Inaui Garei Inoni, 'au boi 'anai ha'atahiraaui nei nara teha.” ");
INSERT INTO aia_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“'A 'ua? 'Onaa ta sae nai to'oraa ta ta'i 'arangi siip ma ta nei 'ini'i 'ai teha baaniai tara ma ai'aa'a, 'e taha nai haua? 'Ai nugasiraaui siwa tangahuru mana siwa na'i hungahunga nara ngaungau iei ma'ai sibaniai nei na ai'aasi. ");
INSERT INTO aia_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wai 'unua ha'a-momori tana'amou, na'i 'oha nai sadoia 'ai wa'ewa'e di'u 'inia. Mana wa'ewa'e ana 'ai di'uai wa'ewa'e nai haua 'iniraaui siwa tangahuru mana siwa na ai'a ai'araau. ");
INSERT INTO aia_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","'A o'asi ro'ua Amamoou ara'ai aro. 'A ai'a 'irisia do ta ta'i nei 'iniraaui gare kekerei 'ini nai teha mai ai'aa.” ");
INSERT INTO aia_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mia Jisas 'a o'ani ro'u, “'Onaa ta do'oramu 'ai haua ta hereta'aa tana'o, 'oi 'ari haari'o beia ma'oi ha'a-aidangisia 'iniai taritari'a ana. 'Onaa 'a 'adoma'i aratara bei'o 'iniai maho na'o 'unua tanaa, ma kae goro 'inia naasi mamurui awa goro'a aho'i. ");
INSERT INTO aia_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma 'onaa 'a ai'a 'adoma'i aratara bei'o, 'oi aho'i 'ari beia ro'u ta 'oha he'ete'i, ma'ata 'oi 'unua ta ta'i ma'ua rua sae hinihini ma rarui hano bei'o. 'Inia ni Usu-usu Maea 'a 'unua o'ani, ‘'Onaa 'oi rangasia ta abe, ta rua ma'ua oru sae narai awa 'anai bahurongoai taha na'oi maania. 'O gasi pwari'i.’ ");
INSERT INTO aia_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hoita, 'onaa mo'osi 'a ai'a 'adoma'i aratara ro'u mau bei'amou 'ini'i taha mou maani'i, naasi 'oigui ha'arongoraaui sae maua na'i heisoi na'i 'omaa amua. Ma 'onaa 'a bwa'i 'adoma'i aratara ro'u mau beiraau, ma 'oi here mara sae ahurodo 'inia ma'ua 'onaai sae ta'a'i nara ha-ha'atakisi. ");
INSERT INTO aia_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Mawai 'unua ha'a-momori tana'amou, 'e taha namoi ha'aabua na'i ano, 'ia God 'ai 'adoma'i aratara bei'amou 'inia na'i aro. Mana taha namoi ha'awatea na'i ano, 'ai 'adoma'i aratara ro'u bei'amou 'inia na'i aro. ");
INSERT INTO aia_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Wai 'unua tana'amou ro'u, 'onaa ta rua sae hinihini na'i marewanani rarui 'adoma'i aratara 'anai ha'angonia Amagu 'anai haua ta maho, 'ia Amagu ara'ai aro 'ai hauai taha nararui ha'angonia. ");
INSERT INTO aia_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","'Ai haua, 'inia namoiwou ta dora ta rua ma'ua ta oru sae rai awagoni na'iei suria 'iraau ra'i sae agu'i, 'inau wai awa beiraau.” ");
INSERT INTO aia_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mia Pita 'a boi beia Jisas ma o'ani 'inia, “Araha, wai 'adoma'i nugasia ha'asiha i do'oragu na awa moi 'anai here ha'ata'aiau? Ha'abiu?” ");
INSERT INTO aia_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mia Jisas 'a o'ani, “'A bwa'i ha'abiu, 'ai biu tangahuru ha'abiu. ");
INSERT INTO aia_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","'Au ha'atee o'asi suria na heimarungi ana God na awa na'i aro 'a 'onaai mwaeraha na siba suri'i kaoni nara haa'i sae tatau'aro ana'i beia. ");
INSERT INTO aia_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na'i 'oha na taraawa'a siba suri'i kaoni, ra waia mai ta'i sae tatau'aro ana na kaoni beia 'ini'i tara'i milion ");
INSERT INTO aia_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","na bwara'a tanaa 'anai su'ua. Naasi mwaeraha 'a 'unua dorai waia beiai urao ana mana gare ana'i marai raonga'iniraau bei'i ro'u i bori adaa'i 'anai su'ua aho'i kaoni ana. ");
INSERT INTO aia_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Mana saesi 'a topira'i ruru auru tanaai mwaeraha ma ha'angonia wetewete o'ani, ‘'Oi nugaa ta gere madoraa tanaau mawai su'u'i hako aho'i tana'o i ha'a nau kaoni 'ini'i.’ ");
INSERT INTO aia_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mana mwaeraha 'a ta'ahia ma 'adoma'i nugasia tanaai kaoni ana ma ha'ahura'ahia dadara'a. ");
INSERT INTO aia_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“'Oha na saesi 'agu hura'a, ma heisadoi beiai sae na kaoni beia 'ini'i tara'i 'arangi. 'A 'ariwou ma here baabau na'i konokonona ma 'unua tanaa do'ai su'ua'a i kaoni ana. ");
INSERT INTO aia_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mia mo'osi 'a topira'i ruru auru tanaa ma ha'angonia wetewete do'ai nugaa tanaa ta gere madoraa 'anai su'ua aho'i tanaa i kaoni ana. ");
INSERT INTO aia_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mia 'a ai'a 'irisia o'asi ma 'unua dorai gaasia siri na'i rumaniho'o. 'Ai awa 'isi tari 'oha nai su'ua aho'i kaoni ana. ");
INSERT INTO aia_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Na'i 'oha na 'iraau tara'i sae tatau'aro ro'u rau re'iai here na haua mo'osi, rau arunga ta'aa 'iniai here na haua mo'osi marau rangasia'a tanaai mwaeraha. ");
INSERT INTO aia_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mana mwaeraha 'a 'unua mai saesi ma o'ani 'inia, ‘I'oe 'o ha'i sae tatau'aro ta'aa! 'Iniai ha'angoniau wetewete na'o haua, 'inau 'au 'adoma'i nugasia tana'o i kae kaoni na'o haa beiau. ");
INSERT INTO aia_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","'A 'ua na'o ai'a ta'ahia ro'ua mo'o na kaoni bei'o 'onaai haua agua tana'o?’ ");
INSERT INTO aia_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","I mwaeraha 'a taesu'a raha 'ana mo'osi, ma 'unua dorai gaasia siri na'i rumaniho'o marai ha'a-rongomaata'ia. 'Ai awa 'isi tari 'oha nai su'ua hako aho'i ha'a na kaoni 'inia.” ");
INSERT INTO aia_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mia Jisas 'agu 'unua o'ani, “'Ai o'asi ro'u i here nai haua Amagu na'i aro tana'o 'onaa 'o bwa'i huunai 'adoma'i nugasiai do'oramu beiai tahingamu hako.” ");
INSERT INTO aia_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Na'i murinai mamaani hako ana Jisas, 'a hano baaniai Provensi Galili ma tarau 'ari nata bataraui wai rahai Jodan ma ada na'i Provensi Jiudea. ");
INSERT INTO aia_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","'A rago i sae narau hano suria ma ha'agorohiraau aho'i nei ra daoha. ");
INSERT INTO aia_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tara'i Farisei rau boi beia Jisas 'inia rau raba ha'imaania 'onaa na heiarami ana 'ai odo-odo beiai Ringe ana'ia Moses. Ma rau songa'inia o'ani, “'A 'ua? Na Ringe ana'ia Moses ra wateai sae 'ai matai gaasia moi urao ana 'inia namoiwou ta maho?” ");
INSERT INTO aia_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mia Jisas 'a o'ani 'iniraau, “Mou ai'a 'oha'inia gasi taha na 'unua i Usu-usu Maea. 'A 'unua do mau mai taraawa'anai marewana, 'ia God 'a ha'apwa'araa i saemwane mana urao. ");
INSERT INTO aia_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma o'ani ro'u, ‘Na tarana naasi, na saemwane 'ai nugasia amana mea inana maai hasi beiai urao ana mararui ha'i ta'i abe.’ ");
INSERT INTO aia_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Naasi, 'irarua rarugu ai'a 'onaaia'a i rua abe, ma'ata 'e ta'i abe moi. Tarana naasi, na noni 'ai abui hoaiai taha na 'ia God na ho'ogonia.” ");
INSERT INTO aia_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Miraau Farisei raugu songa'inia Jisas o'ani, “'Onaa na o'asi, ma 'ua na 'ia Moses 'agu 'unua 'inia do 'ia tei sae nai raba gaasiai urao ana 'ai haua ga'u ta usu-usuni haigaasi tanaai urao ana maigu gaasia?” ");
INSERT INTO aia_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mia Jisas 'a aramiraau o'ani, “'Ia Moses 'a ha'awateai haigaasi suria 'imoou saemwane mou rongoasa mamou ai'a raba araisuriai Ha'atora ana God, me na'i taraawa'a ai'a o'asi hei'irisina God. ");
INSERT INTO aia_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma wai 'unua tana'amou, 'iatei nai gaasiai urao ana ma'ai waina ro'u ta urao he'ete'i, 'a taritari'a baaniai urao ana. Ma'ata 'onaa ni urao ana 'a bwane taritari'a baania, naasi 'a matai gaasia moi uraosi.” ");
INSERT INTO aia_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Miraaui rongoiusuri rau o'ani, “'Onaa namoisi ta'i maho nara matai haigaasi 'inia, ma 'a goro do ra ga'i bwa'i ha'iwai.” ");
INSERT INTO aia_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mia Jisas 'a o'ani 'iniraau, “Ai'a do 'iraau hakoi mwane sae rai wa'ewa'e 'anai suriai mareho namou 'unuasi. 'Iraau moi nei na 'ia God na 'irisia dorai awa o'asi narai wa'ewa'e 'anai suria. ");
INSERT INTO aia_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tara'i mwane ra ai'a ha'iwai suria ra 'amara, ma tara'i mwane ra ai'a ha'iwai ro'u 'iniai here na tara'i sae nara haa tanaraau 'ada'i abedaa'i. Ma tara'i sae ra ai'a ha'iwai suria ra 'adoma'i ororiu 'iniai heimarungi ana God. 'Ia tei nai matai suriai ha'ausuringa'isi, ma'ai suria.” ");
INSERT INTO aia_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tara'i sae ra waa'i mai gare tanaa Jisas mia Jisas 'ai dau hungadi bwaudaa'i mai ha'arahesi huniraau. Maagu 'iraaui rongoiusuri raugu ha'a-aburaau. ");
INSERT INTO aia_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Naasi mia Jisas 'a o'ani, “Moi abui ha'a-bwarasiraau. Moi wateraaui gare marai boi beiau. 'Inia 'iraaui nei ra 'onaairaausi, naasi nei nara arari 'anai awa bahainai heimarungi ana God na awa na'i aro.” ");
INSERT INTO aia_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ma dau na'i bwaudaa'i ma ha'agorohiraau. Na'i muri 'agu hano baaniai dorasi. ");
INSERT INTO aia_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","'E sae na boi beia Jisas ma songa'inia o'ani, “Ha'ausuri, 'e mareho goro taha nawai haua mawaigui daua 'inia i tahi tarau?” ");
INSERT INTO aia_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mia Jisas 'a aramia o'ani, “'Iniai 'uaana na'o songa'iniau 'iniai mareho na goro? I'oe 'o bwane 'iraraa, 'ia moia God na goro. Ma'ata 'onaa 'o raba dauai tahi tarau ma'oi araisuri'i Ha'atora.” ");
INSERT INTO aia_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mana saesi 'a songa'inia ro'ua Jisas o'ani, “Ra'i Ha'atora he'ua na'o 'unu'isi?” Mia Jisas 'a o'ani 'inia, “Abui heingahu, abui taritari'a baaniai urao amua ma'ua mwane amua, abu beri, abui pwari'i na'i kooti, ");
INSERT INTO aia_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ha'ahoua amamu mia inamu, ma'oi ta'ahiai sae 'etea 'onaai ta'ahi'o amua haari'o.” ");
INSERT INTO aia_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mana saesi 'agu o'ani 'inia Jisas, “'Au ha'isuri'i hako'a i Ha'atora 'isi, 'e taha ro'u nawai haa mau?” ");
INSERT INTO aia_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Mia Jisas 'a o'ani, “'Onaa 'o raba odo-odo na'i maana God, 'oi 'ari ma'oi raonga'ini'i hakoi toto'ora amu'i ma'oi hauai ha'a tanaraaui pohara. 'Onaa 'oi haua o'asi, 'oi toto'ora na'i aro. Na'i muri 'oigui boi suriau.” ");
INSERT INTO aia_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","'Oha nagu rongoa o'asi, ma hano'a ha'i ahutotou 'inia 'iia 'e sae na toto'ora di'u. ");
INSERT INTO aia_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Naasi mia Jisas 'agu o'ani 'iniraaui rongoiusuri ana'i, “Wai 'unua ha'a-momori tana'amou. 'A 'ome bwara do sae toto'ora 'ai siri na'i heimarungi ana God na awa na'i aro. ");
INSERT INTO aia_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Wai 'unua ro'u o'ani. 'A 'ua? I mwamwaa nara 'unua 'iniai kamel 'a matai siri daara'i na'i maanai nila? 'A bwara! Ma bwara di'u ro'u wou tanaai nei na toto'ora 'anai siri na'i heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","'Oha 'iraau rongoiusuri rau rongoai ha'atee o'asi ana Jisas, rau heimwaota'i di'u marau o'ani, “Romwane! 'Onaa na o'asi, ma 'ome 'onaa do 'a bwa'i ta sae nai dauai tahi tarau!” ");
INSERT INTO aia_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mia Jisas 'a wanasiraau ma o'ani, “Beiai noni 'a bwarai daua haariraaui tahi tarau, mei tanaa God mwane maho ra mwada'u moi.” ");
INSERT INTO aia_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Naasi mia Pita 'a o'ani 'inia Jisas, “'Ome! 'I'ameu meu nugasi'i hakoi mwane mareho amee'i mameu suri'o. 'E heitahari he'ua na 'ia God 'ai haua tana'ameu?” ");
INSERT INTO aia_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mia Jisas 'a o'ani, “'Oha 'inau i Garei Inoni wai heinagu na'i dorani mwaeraha agua 'anai heimarungi beiai mena mana raraha na'i marewana haoru, 'i'amoui rongoiusuri agu'i moi heinagu ro'u na'i ta'i tangahuru mana rua dorani mwaeraha 'anai marungiraaui ta'i tangahuru mana rua burungai noni nai Israel. ");
INSERT INTO aia_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","'Iatei na nugasiai ruma ana, ma'ua do'orana'i, ma'ua asina'i, ma'ua amana mea inana, ma'ua gare ana'i, ma'ua dorai ano ana 'inia 'a suriau, 'ia God 'ai ha'arago'i tanaai mareho na nugasi'i 'isi. Ma'ai daua ro'u i tahi tarau. ");
INSERT INTO aia_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Na'i madoraasi, 'a ragoi nei nara ororiu na'i 'ohani, rai ha'i sae haari'i moi. Ma ragoi nei nara ai'a ororiu na'i 'ohani, 'ia God 'ai ha'a-ororiuraau.” ");
INSERT INTO aia_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Naasi 'ia Jisas 'agu o'ani ro'u, “Ni heimarungi ana God na awa na'i aro 'a 'onaai sae na hura'a na'i haho'oa ta'aa ma siba sae 'anai tau'aro na'i moui grep ana. ");
INSERT INTO aia_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","'Oha na sadoi'i tara'i nei, rau 'adoma'i aratara beia 'anai dauai ta'i korai ha'a 'anai ta'i dangi, ma ha'a-taariraau hura'a 'anai tau'aro. ");
INSERT INTO aia_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Na'i angi siwa haho'oa 'a hura'a ma re'iraau ro'u i sae ra awa pwaranga moi na'i dorani maketi. ");
INSERT INTO aia_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma o'ani 'iniraau, ‘'Onaa moi 'ari mamoi tau'aro na'i moui grep agua, wai hori'amou 'iniai taha na arariai tau'aro namoi haua.’ ");
INSERT INTO aia_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Marau 'ari narau tagora. “Na'i atoaa mana'i angi oru na'i abai dangi 'a hura'a ro'u 'anai siba sae. ");
INSERT INTO aia_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na'i angi rima su'urahi 'a hura'a ma re'i'i ro'u tara'i sae ra poru agohe ro'u moi ma o'ani 'iniraau, ‘'A 'ua namou poru agohe moi 'inia na'i dangi bubuni?’ ");
INSERT INTO aia_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Miraau o'ani 'inia, ‘Ai'a ta sae nai ha'atagoraameu.’ “Mia o'ani 'iniraau, ‘Moi 'ari mamoi tagora beiraaui sae rau tagora na'i mou agua.’ ");
INSERT INTO aia_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Na'i ha'ahakonai dangisi 'a 'unua tanaa mo'o na 'omesuriraaui sae ra tagora do'ai 'unuraau mai, mai horiraau. 'Ai taraawa'a beiraaui ruruha rau tagora ha'ahako maigui hako beiraaui ruruha rau tagora tahamora. ");
INSERT INTO aia_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“'Oha ra horiraaui ruruha ra taraawa'a tagora moi na'i angi rima su'urahi ra ha'a 'ado ta'i korai ha'araau. ");
INSERT INTO aia_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mana 'oha ra horiraaui ruruha rau taraawa'a tau'aro na'i haho'oa ta'aa, rau 'adoma'inia do 'iraau rai dau ha'a raha magu ai'a, 'iraau ro'u rau 'ado ta'i korai ha'a moi. ");
INSERT INTO aia_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","'Agu haa marau taesu'a'a, rau o'ani, ");
INSERT INTO aia_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘'Iraaui ruruha narau tagora ta'i 'aoa moi 'o horiraau 'iniai ta'i korai ha'a. Mi'ameu i ruruha nameu tagora raha tanaai sina suriai dangi bubu, 'o hori ha'a-ta'isada'ameu ro'u moi 'onaairaau.’ ");
INSERT INTO aia_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“'Ia mo'o na to'oraai mou 'a o'ani 'iniai ta'i abe 'iniraau, ‘Gere sae agua, 'inau ai'a ha'a-bweubweu'a'o. I'oe na'o 'adoma'i aratara 'anai tau'aro maenai ta'i korai ha'a ta'i dangi. ");
INSERT INTO aia_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","'Oi dauai horihorimu ma'oi hano. Na'i 'adoma'igu haariau, 'au 'adoma'inia do 'inau wai hori ha'a-ta'isada'amou hako. ");
INSERT INTO aia_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","'A 'ua? 'A taritari'a 'onaa wai raba hisu 'ini'i ha'a agu'i suriai 'adoma'igu? 'O ga'i bwa'i taesu'a 'iniai haua aguai mareho na goro 'oha nau here ha'agorohiraau.’” ");
INSERT INTO aia_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mia Jisas 'agu 'unua o'ani ro'u, “Naasi, na'i heimarungi ana God 'iraaui nei ra muri na'i 'ohani, rai na'o. Miraaui nei ra na'o na'i 'ohani, rai muri.” ");
INSERT INTO aia_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","'Oha 'ia Jisas 'a hano 'anai Jerusalem, 'a wairaau beira'i ta'i tangahuru mana rua rongoiusuri ana maagu mamaani tanaraau. 'A o'ani, ");
INSERT INTO aia_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Moi bahurongo goro. Na'i 'ohanisi gau hahano'a 'anai Jerusalem. Maagu na'i 'isi 'e nei nai usuha'iniau i Garei Inoni tanaraaui Na'ohadaa'i Piriisi mana Ha'ausuri 'anai Ringe ana'ia Moses marai hiiriau 'anai ha'amaesiau. ");
INSERT INTO aia_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Rai usuha'iniau ro'u tanaraaui nei ra ai'a Jiu. Rai haikou 'iniau, rai rorohoau marai rabuau na'i dadaahoro 'anai ha'amaesiau. Ma'ata 'e rua dangi nai hako mana'i oruna wai suruta'e aho'i baaniai mae.” ");
INSERT INTO aia_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na'i muri, urao ana Sebedi mana rua gare ana, 'ia Jems mia Jon, rau boi beia Jisas. Mana urao ana Sebedi 'a topira'i ruru tanaa Jisas 'anai ha'angoni beia 'iniai ta'i maho. ");
INSERT INTO aia_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mia Jisas 'a o'ani, “'E taha na'o rabasia?” Mia o'ani, “'Oha 'oi heimarungi na'i hourana amua, 'au 'irisia do 'oi ha'awaterarua i rua gare aguani 'anai heimarungi bei'o. Tanei nai heinagu na'i dora ni mwaeraha na'i aba odomu ma tanei na'i maha.” ");
INSERT INTO aia_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mia Jisas 'a o'ani, “'I'amurua muru ai'a aidangisiai maho na muru ha'angoniasi! 'A 'ua? Muru ga'i siri moi na'i rongomaata'i na 'inau wai siri iei?” Miraru aramia o'ani, “Miri ga'i haa moi!” Mia Jisas 'a o'ani, “Ha'amomori di'u. Murui rongomaata'i ha'a-momori 'onaai rongomaata'i na 'inau wai haa. ");
INSERT INTO aia_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ma'ata 'inau 'au bwa'i sigihia 'iatei nai heinagu na'i odogu ma'ua na'i mahagu. 'Iia moi Amagu nai 'unua 'iatei nai heinagu beiau. 'Inia 'iia 'a bwani 'ome sigihiraau.” ");
INSERT INTO aia_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","'Oha 'iraaui ta'i tangahurui rongoiusuri rau rongoai taha nararu ha'angonia Jems mea Jon, rau taesu'a 'adarua. ");
INSERT INTO aia_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","'Ia Jisas 'a 'unu goniraau mai rongoiusuri ana'i ma o'ani 'iniraau, “'I'amou bwani 'iraraa do 'iraaui mwaeraha mana na'otara adaa'i sae ra ai'a Jiu, rau ha'aba'o 'iniai heimarungi narau haua ma goro adaau i haa'i mwani heiatenga'i tanaraaui noni. ");
INSERT INTO aia_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ma'ata 'i'amou moi abui haua o'asi tana'amou hairiu. 'Iatei nai raba na'otara tana'amou 'ai ha'i sae tatau'aro tana'amou. ");
INSERT INTO aia_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mia tei na raba bwauodo, 'ai ha'i slev tana'amou. ");
INSERT INTO aia_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Moi ha'isuriai herehere agua. 'Inaui Garei Inoni 'au ai'a boi do 'irai sae rai tau'aro tanaau. Me 'inau 'au boi do 'inau wai tau'aro tanaraau, ma 'anai wateai tahingagu 'anai ha'atahiraau baaniai ora-ora'a.” ");
INSERT INTO aia_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","'Oha 'ia Jisas mana rongoiusuri ana'i rau hano baaniai 'omaai Jeriko, ragoi sae rau haisuri. ");
INSERT INTO aia_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","'E rua sae kuru raru heinagu na'i bobonai tara, raru rongoa do'ia Jisas 'a boi suriai tara. Raru awara o'ani, “Araha, pwirana Deved, 'oi arunga ta'ahimiria ma'oi 'a'auhimiria!” ");
INSERT INTO aia_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'Iraau sae rago rau 'unua do rarui papaku. Mirarua rarugu awaawara raha baaniai na'o. Raru o'ani, “Araha, pwirana Deved, 'oi arunga ta'ahimiria ma'oi 'a'auhimiria!” ");
INSERT INTO aia_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas 'a ura papaku ma 'unurarua mai ma songa'inirarua, “'E taha na muru 'irisia dowai haua tana'amurua?” ");
INSERT INTO aia_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Miraru o'ani, “Araha, miri raba wanawana.” ");
INSERT INTO aia_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mia Jisas 'a ta'ahirarua, ma dau wou suri'i maadaru'i. Na'i maui 'ohasi mararu wanawana'a mararu hano'a suria Jisas. ");
INSERT INTO aia_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","'Oha 'ia Jisas mana rongoiusuri ana'i rau gaarangia wou i Jerusalem, rau 'omesia 'ari 'omaai Betfeis gaarangiai hungahungai 'Oliv. Mia Jisas 'a ha'a-taarirarua i rua rongoiusuri 'anai 'ari na'o na'i 'omaasi. ");
INSERT INTO aia_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","'A o'ani, “Murui hano mamurui 'ari nai 'omaa 'ariani ma murui re'iai dongki nara ho'osia na'i 'isi beiai gare ana. Murui wagasirarua mamurui wairarua mai. ");
INSERT INTO aia_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","'Onaa ta sae nai songa'inimurua ma murui o'ani, ‘'Ia Araha na rabasirarua.’ Maagu bwa'i maho'a ro'u nai 'unua.” ");
INSERT INTO aia_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Marehonisi 'a to'o o'asi ma to'o ha'a-momori'a taha na 'ia God 'a ha'atee rarabeanga'inia beiai Rarabea. 'A 'unua o'ani, ");
INSERT INTO aia_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Naani mareho na'oi 'unua tanaraaui noni nai Jerusalem na awa na'i hungahungai Saeon. 'Ome, na mai mwaeraha amoou. 'Iia 'a manego, 'a ta'e mai na'i hunganai dongki. Ha'amomori, 'a ta'e na'i hunganai gare dongki.” ");
INSERT INTO aia_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hoita, mana rua rongoiusuri raru haua 'onaai 'unua ana Jisas. ");
INSERT INTO aia_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Raru waa mai dongki mana gare ana mararu haari'i to'oni bo hura'a adaru'i na'i hungana mia Jisas 'a heinagu ara'a na'i iei. ");
INSERT INTO aia_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma ragoi sae rau 'ari na'o marau haari'i bwana adaa'i suriai tara, ma tara'i sae ra tabari'i hasi'ei nara hahaa'a mara haari'i hahaadi na'i tara. ");
INSERT INTO aia_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mana sae ra na'o mana nei na'i murina Jisas rau awaawara. Rau o'ani, “Ha'a-aneaneai pwirana Deved. Araha God, 'oi ha'agorohia mo'o na'o ha'ataaria mai! Ha'a-aneanea God na'i aro.” ");
INSERT INTO aia_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","'Oha na siri a Jisas na'i Jerusalem, 'iraaui saenai 'omaa rau wa'ewa'e di'u ma tara'i nei rau o'ani, “'Ia tei naasi!” ");
INSERT INTO aia_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Miraau sae rago rau o'ani, “'Ia Jisas, i rarabea baaniai Nasaret na'i Provensi Galili.” ");
INSERT INTO aia_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mia Jisas 'a siriwou na'i dora a'ora na'i maanai Ruma Maea ana God ma taraawa'a taariraau hura'ai sae ra horihori mara raoraonga'i na'iei. Ma rihota'ini'i tebol 'anai ori-orisi ha'a mana baba heheinagu adaa'i nei ra raoraonga'i waibora. ");
INSERT INTO aia_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma o'ani 'iniraau, “I Usu-usu Maea 'a 'unua o'ani, ‘Na ruma agua 'e ruma 'anai ha'arahesi.’ Mi'amou mou ha'i dorani bainihu 'inia nadaaui sae beriberi.” ");
INSERT INTO aia_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na'i muri tara'i sae kuru mana sae pwaki ra boi beia na'i 'isi ma ha'agorohiraau aho'i. ");
INSERT INTO aia_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","'Iraaui na'ohadaaui Piriisi miraaui Ha'ausuri 'anai Ringe ana'ia Moses rau taesu'a 'oha rau re'i'i ha'abu'oahu na haa'i marau rongoraaui gare rago narau totoro o'ani, “Ha'a-aneaneai pwirana Deved!” ");
INSERT INTO aia_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Marau o'ani 'inia Jisas, “'O rongoai taha narau 'unua i gare 'isi? 'O ga'i ha'atee ha'a-bwarasiraau!” Mia Jisas 'a o'ani, “'Au rongoa. Ma 'ua? Mou ai'a 'oha'iniai dorai Usu-usu Maea na 'unua do 'ia God 'ai 'a'auhiraaui gare kekerei miraaui gare ra bura'i huta marai huunai ha'a-aneanea?” ");
INSERT INTO aia_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mia Jisas 'a hura'a baaniai Jerusalem ma 'ari na'i Betani nagu mauru na'iei. ");
INSERT INTO aia_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na'i haho'oa, 'oha 'ia Jisas 'a aho'i mai 'anai Jerusalem, 'a hioro. ");
INSERT INTO aia_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma re'iai hasi'ei nara 'unua 'iniai fig na ura na'i bobonai tara ma 'ariwou do'ai re'ia 'onaa 'a hungu. Magu ai'a, nai'i moi na rawa nara awa. Mia Jisas 'a ha'atee o'ani, “'A bwa'i ta 'oha'a ro'u na'oigui hungu.” Mau 'ohasi mana hasi'eisi 'a nugu'a. ");
INSERT INTO aia_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","'Iraau rongoiusuri rau heimwaota'i di'u, rau o'ani, “'A he'ua na nugu raurau moi 'inia i hasi'eini.” ");
INSERT INTO aia_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mia Jisas 'a o'ani 'iniraau, “Wai 'unua ha'a-momori tana'amou. 'Onaa moi hinihini mamou bwa'i 'adoma'i heiruarua'a, mou ga'i matai ha'atee murisia ro'u i hasi'eisi. Mamou ga'i matai haa'i tara'i ha'abu'oahu ro'u nara raha baaniai nei nau hauasi. 'O ga'i 'unua moi tanaai hungahungani o'ani, ‘'Oi sara baaniai dorani ma'oi hura'ai asi!’ Ma'ai matai 'onaaia moi 'unua amua. ");
INSERT INTO aia_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","'Oha 'oi ha'arahesi tanaa God 'anai ha'angonia ta maho, 'ai matai haua moi tana'o, 'onaa 'oi hinihini.” ");
INSERT INTO aia_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na'i 'oha 'ia Jisas 'a ada na'i Jerusalem, 'a siri na'i Ruma Maea ana God ma ha'ausuriraaui sae. 'Iraaui Na'ohadaa'i Piriisi ma tara'i saemaua adaa'i Jiu rau boi beia marau o'ani, “'Oi 'unua tana'ameu, 'iatei na 'unua tana'o do'oi matai haa'i mareho 'isi?” ");
INSERT INTO aia_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mia Jisas 'a 'unua o'ani, “Wai matai aramiai heisonga'i amoou 'onaa moi aramia ro'u i heisonga'i nawai haua tana'amou. ");
INSERT INTO aia_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","'Iatei na 'unua tanaa Jon 'anai bwareomaearaaui noni? 'Ia God ma'ua inoni?” Rau hadahada haariraau hairiu o'ani, “'Onaa nagai 'unua do 'ia God, me 'iia 'ai o'ani, ‘Ma 'ua namou ai'a hinihinia 'inia Jon?’ ");
INSERT INTO aia_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma 'onaa nagai 'unua do 'iraau moi inoni nara 'unua tanaa, miraaui sae rago rai taesu'a marai haua ta here gagaau. 'Inia rau hinihinia do'ia Jon 'e rarabea.” ");
INSERT INTO aia_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ma rau o'ani 'inia Jisas, “Meu ai'a 'iraraa.” Mia Jisas 'agu o'ani 'iniraau, “Nau bwa'i rangasia ro'u tana'amou 'iatei na 'unua tanaau do wai matai haa'i mareho 'isi.” ");
INSERT INTO aia_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mia Jisas 'a o'ani ro'u 'iniraau, “Moisu rongoa ga'u i heiha'auu nawai hauani mawaigui rongoai 'adoma'imoo'i 'inia. 'E ta'i sae na to'oraai rua gare mwane, ma o'ani 'iniai gare na hutai na'o, ‘Mama, na'i dangini 'oi 'ari ma'oi tagora na'i moui grep.’ ");
INSERT INTO aia_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mia o'ani, ‘'Inau 'au 'age.’ Na'i muri 'a orisiai 'adoma'ina ma hano na tagora. ");
INSERT INTO aia_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mia amadarua 'a 'ariwou beiai nata abe na hutai muri ma 'unua ro'u tanaa. Mia o'ani, ‘'Io, 'a goro moi.’ Ma'ata na'i muri magu ai'a hano'a.” ");
INSERT INTO aia_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mia Jisas 'agu songa'iniraau o'ani, “Mou 'adoma'inia do'ia tei 'iniraruai rua garesi na araisuriai amadarua?” Miraau o'ani, “I gare tahamora.” Mia Jisas 'agu o'ani 'iniraau, “Wai 'unua ha'a-momori tana'amou. 'Iraaui sae ha-ha'atakisi nara beriraaui noni miraaui urao horihori raai siri na'i na'o 'ini'amou na'i heimarungi ana God. ");
INSERT INTO aia_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","'Inia 'oha na 'ia Jon Bwareomaea 'a boi 'anai ha'ata'inia tana'amoui awaha odo-odo namou ga'i awasuria, 'iraau narau hinihinia, 'i'amou mou ai'a. Rei'uaa namou 'omesia dorau rihosi, me 'a bwara mau ro'u tana'amou i rihosi ma'ua 'anai hinihinia Jon.” ");
INSERT INTO aia_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mia Jisas 'a o'ani ro'u, “Moi rongoa ro'u i nata ha'atee heiha'auuni. 'E ta'i sae na hasiai moui grep. 'A bara garia ma tagoraai dora 'anai rosirosi grep na'iei 'anai tagora waen. Ma ha'a-urasia ro'u i ruma ahaaha 'anai 'ome'ome 'ini'i maeronga. Na'i muri 'agu sadoi'i sae 'anai tau'aro maedi hua 'anai 'omesuriai mou ma hano na awa na'i kantri he'ete'i. ");
INSERT INTO aia_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na'i madoraa 'anai husi'i grep 'a ha'ataari'i wou sae tatau'aro ana'i 'anai waa aho'i tanaai wadui grep ana. ");
INSERT INTO aia_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Miraaui sae narau 'omesuriai mousi, rau dauraau marau ngahu ngahuai ta'i abe, rau ngahu ha'amaesiai nata nei marau buta ha'amaesiai nata abe ro'u 'iniai hau. ");
INSERT INTO aia_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Na'i muri 'agu ha'ataari'i ro'u tara'i sae tatau'aro ana'i. Na'i 'ohani rau rago di'uai ruruha na'i na'o. Miraau sae narau 'omesuriai mou, rau haua ro'u mau i ta'i herehere nara haua 'adaaui ruruha na'i na'o. ");
INSERT INTO aia_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ha'ahakona 'a ha'ataaria 'ari huunai gare ana. 'Iia 'a 'adoma'inia dorai ha'ahoua. ");
INSERT INTO aia_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Na'i 'oha rau re'ia rau o'ani, ‘Naasia mo'o naigu to'oraai mousi na'i 'oha nai mae amana. Gau magai ngahu ha'amaesia magai to'oraa nagaau i mou.’ ");
INSERT INTO aia_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Rau 'ariwou marau daua. Rau waia hura'a na'i murinai mou naraugu ngahu ha'amaesia na'iei.” ");
INSERT INTO aia_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mia Jisas 'agu o'ani 'iniraaui Na'ohadaaui Piriisi miraaui saemaua adaa'i Jiu, “Mou 'adoma'inia do'e taha nai haua mo'o na to'oraai moui grep naasi 'adaaui sae 'isi na'i 'oha 'ai aho'i mai?” ");
INSERT INTO aia_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Miraau o'ani, “'Ai ngahu ha'amaesiraaui sae ta'a'i 'isi, mai nuga'i tara'i sae he'ete'i ro'u 'anai 'omesuriai mou nei narai matai haa'i tanaai hua na ga'i to'ora'i na'i 'oha narai mauai grep.” ");
INSERT INTO aia_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Naasi mia Jisas 'agu o'ani ro'u 'iniraau, “Mou ai'a 'oha'inia gasi taha na 'unuai Usu-usu Maea na o'ani, ‘Na hau na 'iraaui sae tatau'aro ruma rau 'itaa, naia naagu ha'i hau na ororiu di'u na'i bani anai ruma. 'Ia Araha God na haua do'ai o'asi, magau wa'ewa'e di'u 'inia.’ ");
INSERT INTO aia_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Na tarana naasi nawai 'unua tana'amou. Na'i na'o 'ia God 'a 'ome sigihi'amoui ai Jiu 'anai awa bahainai heimarungi ana. Ma na'i 'ohani 'ai orisi'amou mai ha'awateraaui noni he'ete'i narai matai hungu 'ini'i huudi hua goro 'anai awa na'i bahainai heimarungi ana. ");
INSERT INTO aia_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","'Ia tei nai agusu na'i hausi, 'ai maara ta'aa. Mia tei na hausi 'ai ahoda hunia, 'ai meme'a.” ");
INSERT INTO aia_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na'i 'oha 'iraau Na'ohadaa'i Piriisi miraau saemaua adaa'i Jiu rau bahurongoa Jisas, rau aidangisia do ni ha'atee heiha'auu na haa'i ra to'iraau. ");
INSERT INTO aia_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Marau raba daua'a Jisas dorai ha'a-mama'aia, maraugu magugu do ra gasigu ha'agogoru i sae rago. 'Inia ra hinihinia do 'ia Jisas 'e rarabea. ");
INSERT INTO aia_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","'Ia Jisas 'a haa'i ro'u tara'i mamaani heiha'auu tanaraaui sae rago. ");
INSERT INTO aia_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","'A o'ani, “I heimarungi ana God na awa na'i aro 'a 'onaai mwaeraha na hauai ngaugoni 'oha na ha'iwai gare mwane ana. ");
INSERT INTO aia_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","'A ragoi sae na ari'ahuraau. Ma na'i 'oha na agau hakoi mwane maho, 'a ha'a-taariraau hura'a hakoi sae tatau'aro ana'i 'anai 'unuraau mai sae na ari'ahuraau, maagu 'iraaui sae 'isi, ra kakawata'i boi 'anai ngaugonisi. ");
INSERT INTO aia_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Na'i muri 'a ha'ahanori'i tara'i sae tatau'aro he'ete'i ro'u ma o'ani 'iniraau, ‘Moi 'ari mamoi 'unuraau mai sae nagau ari'ahuraau marai boi raurau. 'Inia na mwani maho ra agau'a, na mwani kau pwapwanato'a agu'i nara ngahui'i ra ha'amatota'i hako'a!’ ");
INSERT INTO aia_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Mana'i 'oha narau 'ariwou, ni sae ra ari'ahuraausi raugu da'ata'inia moi mwaeraha marau poru agohe moi 'ini'i taha rau haa'i. Tara'i abe rau 'ari moi suri'i mou adaa'i, ma tara'i abe rau 'ari dora narau tau'aro suri'i. ");
INSERT INTO aia_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma tara'i abe rau dau'i sae tatau'aro ana'i mwaerahasi marau here ha'ata'airaau mara ngahu ha'amaesiraau. ");
INSERT INTO aia_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Mana mwaeraha 'a taesu'a di'u ma ha'ataariai ruruha hehei'oi ana narau ngahu gata'iniraaui sae hahaingahu 'isi mara suungiai 'omaa adaau. ");
INSERT INTO aia_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Naasi mwaeraha 'agu o'ani 'iniraau tara'i sae tatau'aro ana'i ro'u, ‘I sae nau ari'ahuraau, rau ai'a arari 'anai boi, maagu mwane maho 'anai ngaugoni ra agau hako'a. ");
INSERT INTO aia_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Naasi moi 'ari suri'i tara raha suriai 'omaa mamoi ari'ahua namoiwou ta sae namoi sadoia marai boi 'anai ngaungauni.’ ");
INSERT INTO aia_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Miraau sae tatau'aro ana'i mwaeraha rau 'ari marau waa'i mai mwane sae. Tara'i nei ra'i sae hehere ta'aa ma tara'i nei ra'i sae goro. I ruma 'anai ngaungau na'iei 'a honu ha'atai 'iniai sae. ");
INSERT INTO aia_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","'Oha na mwaeraha 'a boi 'anai re'iraaui sae narau boi, 'a re'ia'a i ta'i sae na ho'osiai bwana he'ete'i na ai'a arari 'anai ho'osia na'i ha'aha'iwai. ");
INSERT INTO aia_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma o'ani'a 'inia, ‘Gere sae agua, 'a he'uai siri mai amua na'i 'ini? 'Inia i'oe 'o ai'a ho'osiai bwana na 'ome marasinai ha'aha'iwai.’ Mia mo'osi 'a ai'a aramia 'inia ta mareho. ");
INSERT INTO aia_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mana mwaeraha 'a o'ani 'iniraaui sae tatau'aro ana'i, ‘Moi daua mamoi ho'osi'i uwana'i mana rimana'i mamoi gaasia hura'ai dora kuhi. Na'i 'isi rai angi marai 'ara ha'angingita'i rihodaa'i na'iei.’” ");
INSERT INTO aia_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mia Jisas 'agu o'ani, “'A ragoi nei na 'ia God 'a ari'ahuraau ma'e taringai nei moi na 'ome sigihiraau.” ");
INSERT INTO aia_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","'Iraau Farisei narau awa 'isi rau hano baaniai dorasi marau ha'aradorado 'anai sadoia ta here narai ha'a-bweubweu'aa Jisas 'inia, neina 'ai 'unua ta maho taritari'a narai ha'a-mama'aia 'inia. ");
INSERT INTO aia_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Na'i muri, rau soigoniraau mai tara'i rongoiusuri adaa'i bei'i tara'i ai Jiu nara wa'ewa'e 'iniai heimarungi ana Herod. Rau ha'a-taariraau 'anai taha beia Jisas marau songa'inia o'ani, “Ha'ausuri, meu 'iraraa dona mwane maho na'o 'unu'i ra ha'a-momori hako ma'o ha'ausuriraaui noni 'ini'i taha 'ia God na 'irisiai noni 'anai haa. Ma na'i 'oha na'o ha'ausuriraau, rei'uaa na 'e sae he'ua na bahurongo'o, mana ha'ausuringa'i amu'i ra ta'isada moi. ");
INSERT INTO aia_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Naasi, meu raba rongoai 'ado'adomu. 'A 'ua? Na'i ringeringe agaau, 'a odo-odo dogai hori takisi tanaai mwaeraha raha na'i Rom ma'ua ai'a?” ");
INSERT INTO aia_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","'Ia Jisas 'a bwani 'iraraai 'ado'ado ta'aa na awa na'i 'adoma'idaau na'i 'oha narau hauai heisonga'isi ma o'ani 'iniraau, “'I'amou ra'i sae pwapwapwaari'i! 'A 'ua namou raba ha'a-bweubweu'aau 'anai 'unuai maho na taritari'a? ");
INSERT INTO aia_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Moisu waa mai ta korai ha'a nara matai haa 'anai hori takisi.” Miraau haua tanaa. ");
INSERT INTO aia_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mia o'ani 'iniraau, “Na atana tei mana nununa tei na awa na'i korai ha'ani?” ");
INSERT INTO aia_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Miraau o'ani, “Na atana Mwaeraha adaaui Rom mana nununa.” Maagu o'ani 'iniraau, “'Onaa na o'asi, mamoi haua tanaai Mwaeraha i taha 'iia na to'oraa, mamoi haua tanaa God taha 'ia God na to'oraa.” ");
INSERT INTO aia_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","'Oha rau rongoai ha'atee ana o'asi, rau heimwaota'i di'u marau hano'a baania. ");
INSERT INTO aia_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na'i maui dangisi tara'i Sadiusi ra boi beia Jisas. 'Iraausi rau ai'a hinihinia do 'irai noni rai suruta'e aho'i baaniai mae, miraau songa'inia Jisas o'ani, ");
INSERT INTO aia_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ha'ausuri, 'Ia Moses 'a 'unua do 'onaa ta sae nai waina ta urao maigu mae baania ha'i ai'a to'o gare, 'i do'orana mo'osi 'ai waina ro'u i uraosi. Mana gare na rarui to'ora'i, rai 'unu'i 'ini'i gare ana'i do'orana na maesi, neina burungana 'a bwa'i hako. ");
INSERT INTO aia_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Hoita, na'i na'o, 'e biu ha'ido'orada nara awa na'i 'omaa ameeuni. Nei tahamora 'a ha'iwai ma mae ha'i ai'a to'o gare, mana do'orana na hutai muri 'a waina ro'u i urao na mae baania do'orana na hutai na'o. ");
INSERT INTO aia_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ma mae ro'u ha'i ai'a to'oraa ta gare, mana uraosi 'a waina ro'u i nata do'oradarua i rua ha'ido'orada nararu maesi. Ma o'asi moe'a tari 'oha na biu ha'ido'oradasi raugu buna waina hako i ta'i uraosi. ");
INSERT INTO aia_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ha'ahakona mana uraosi 'a mae ro'u. ");
INSERT INTO aia_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Hoita, na'i 'oha ni suruta'e aho'i, 'iatei 'iniraaui ha'ido'orada 'isi naigui to'oraai uraosi? 'Inia 'iia 'a waidaau hako i biu ha'ido'oradasi.” ");
INSERT INTO aia_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mia Jisas 'a aramiraau o'ani, “Mou taritari'a ha'atai! 'I'amou ai'a aidangisiai Usu-usu Maea mamou ai'a aidangisia ro'u i taha na mena ana God 'ai matai haua. Naia namou to'oraa 'inia 'ado'ado bweubweu'asi. ");
INSERT INTO aia_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Na'i 'oha 'iraaui sae rai suruta'e aho'i, 'a bwa'i sae nai ha'iwai. 'Iraau rai 'onaairaaui enjel na'i aro nara ai'a ha'iwai. ");
INSERT INTO aia_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","'Io, ma wai ha'a-aidangisi'amou ro'u 'iniai suruta'e aho'i. 'A 'ua? Mou ai'a 'oha'iniai taha na 'ia God 'a 'unua tana'amou na'i Usu-usu Maea 'abaiai suruta'e aho'i? 'A 'unua o'ani, ");
INSERT INTO aia_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘'Inau naasi God ana Ebraham, mia Aisak mia Jekop.’ Mana God naasi, ai'a God adaaui nei ra mae, me 'e God adaaui nei ra tahi. Naasi 'a ha'ata'inia doni waira orusi rau tahi mau, rei'uaa narau bwane mae.” ");
INSERT INTO aia_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","'Oha na mwani sae rago 'isi ra rongoai taha na 'unua Jisas, rau heimwaota'i di'u 'ini'i ha'ausuringa'i ana'i. ");
INSERT INTO aia_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","'Oha 'iraau Farisei rau rongoa do'ia Jisas 'a ha'a-papakuraau Sadiusi, rau ruru goni 'anai ha'aradorado maraugu 'ariwou beia Jisas. ");
INSERT INTO aia_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'E ta'i 'iniraau 'e Ha'ausuri 'anai Ringe ana'ia Moses, 'a hauai ta'i heisonga'i 'anai ha'imaania Jisas. ");
INSERT INTO aia_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","'A o'ani, “Ha'ausuri. I Ha'atora he'ua na ororiu di'u baani'i hako i mwane Ha'atora.” ");
INSERT INTO aia_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Mia Jisas 'a o'ani, “'Oi ta'ahiai Araha God amua 'iniai tahingamu hako mana ahumu hako mana 'adoma'imu hako. ");
INSERT INTO aia_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Naasi Ha'atora na ororiu baani'i hakoi mwane Ha'atora. ");
INSERT INTO aia_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nata nei na ororiu ro'u, ‘'Oi ta'ahiai nata sae 'onaai ta'ahi'o amua haari'o.’ ");
INSERT INTO aia_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","I Ringe hako ana'ia Moses mana ha'ausuringa'i adaa'i Rarabea ra awa hako na'i bahainai rua Ha'atorasi.” ");
INSERT INTO aia_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na'i 'oha na 'iraaui Farisei rau awa mau beia Jisas, 'ia Jisas 'a songa'iniraau o'ani, ");
INSERT INTO aia_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mou 'adoma'inia do Ha'atahi 'e pwirana tei?” Miraau o'ani, “'E pwirana Mwaeraha Deved.” ");
INSERT INTO aia_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mia Jisas 'a o'ani ro'u, “Ma 'ua na Hi'ona Maea 'agu haua 'inia tanaa Deved i 'ado'ado nagu 'unua 'inia do 'i Ha'atahi naasi 'ia Araha ana? 'Ia Deved 'a 'unua o'ani, ");
INSERT INTO aia_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘'Ia Araha God 'a ha'atee o'ani 'inia Araha agua, 'Oi heinagu na'i aba odogu 'anai heimarungi beiau, tari 'oha wai nugaraau i maerongamu na'i bahainai heimarungi amua.’ ");
INSERT INTO aia_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na'i 'oha na 'ia Deved 'a 'unua do 'ia Ha'atahi 'e Araha ana, 'a ha'ata'inia do 'ia Araha ai'a do'e pwirana moi, ma'ata 'iia Araha ro'u ana.” ");
INSERT INTO aia_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na'i 'ohasi ai'a ta ta'i nei 'iniraau Farisei nai aramia. Taraawa'a mau na'i 'ohasi ai'a ta ta'i nei 'iniraau'a ro'u naigui raba haua ro'u ta ta'i heisonga'i. ");
INSERT INTO aia_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mia Jisas 'a o'ani 'iniraaui noni hunga mana rongoiusuri ana'i, ");
INSERT INTO aia_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“I tau'aro adaaui Ha'ausuri 'anai Ringe miraau Farisei naasi 'anai mamaani ruhasi'i 'ado'ado 'ada'i taha ra awa na'i Ringe ana'ia Moses. ");
INSERT INTO aia_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mareho rai maani'i, moi araisuri'i mamoi ha'isuri'i. Ma'ata moi abu 'onaairaau. 'Inia rau ai'a ha'isuri'i taha narau ha'ausuri'amou 'ini'i! ");
INSERT INTO aia_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rau ha'ahihi'amou 'ini'i mwani ringeringe nara bwara 'anai ha'isuri'i maraugu ai'a gere 'a'auhi'amou 'anai araisuri'i. ");
INSERT INTO aia_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Mwani maho rau haa'i rau haa'i do 'iraaui sae rai wanasiraau marai ha'a-ta'eta'eraau 'ini'i. Rau ha'araha'i gere anga narau ho'osi'i na'i rimadaa'i ma na'i hauraedaa'i nara awaiei tara'i tatara i Usu-usu Maea. Mana'i gaodi to'oni tewa adaa'i rau ha'atewa'i ro'u aurui gere hasiwaro nara kurukuru suri'i. ");
INSERT INTO aia_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Na'i suri'i ngaugoni mei suri'i rumani ha'arahesi rau raba heinagu moe'a suri'i dora ororiu. ");
INSERT INTO aia_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","'Oha rau 'ari suri'i dorani maketi, rau 'irisia di'u dorai ha'a-ta'eta'eraau mana 'unuraau 'inia ha'ausuri. ");
INSERT INTO aia_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“'I'amou moi abui 'irisia dorai 'unu ha'ausuri 'ini'amou, 'inia 'e ta'i sae moi na ha'ausuri'amou, 'inau. 'I'amou hako ra'i ha'ido'orada. ");
INSERT INTO aia_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Moi abui 'unu Ama ro'u 'inia ta sae ni marewanani. 'Ia moia God naasi Amamoou na awa na'i aro. ");
INSERT INTO aia_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Moi abui 'irisia dorai 'unu bwauodo 'ini'amou 'inia 'e ta'i bwauodo moi, 'iia naasi Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","'Iatei nai bwauodo 'ini'amou, 'iia naasi nai ha'i sae tatau'aro namoou. ");
INSERT INTO aia_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","'Iatei nai ha'a-ara'ahia haaria, 'ia God 'ai ha'a-auruhia. Mia tei nai ha'a-auruhia haaria, 'ia God 'ai ha'a-ara'ahia. ");
INSERT INTO aia_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“'Ai ta'aa di'u tana'amoui Ha'ausuri 'anai Ringe ana'ia Moses mi'amou Farisei! Mou here 'onaa domou goro, ma'ata ai'a! Mou ai'a raba siri na'i heimarungi ana God mamougu ha'a-bwarasiraau ro'u i nei nara bonasiai siri na'iei. ");
INSERT INTO aia_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“'Ai ta'aa di'u tana'amoui Ha'ausuri 'anai Ringe mi'amou Farisei! Mou here 'onaa domou goro, ma'ata ai'a! Mou ha'a-bweubweu'araaui nao 'ini'i ruma adaa'i mana mareho narau to'ora'i. Mana 'oha mou ha'arahesi, mou pwari'i ha'amaesiraaui noni 'anai haa'i rihunga'i tewa. Moi aidangisia do na ha'a-mama'ai, 'ia God 'ai ha'arahaa ro'u wou tana'amou. ");
INSERT INTO aia_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“'Ai ta'aa di'u tana'amoui Ha'ausuri 'anai Ringe mi'amou Farisei! Mou here 'onaa domou goro, ma'ata ai'a! Mou tau'aro raha 'iniai 'ari suriai mwane dora, na'i asi mana'i toro 'anai sadoia ta sae 'anai rihosia ma do'ai awasuri'i ha'ausuringa'i amoo'i. 'Oha nagu suri'amou, na barongana'i ra ta'aa di'u ro'u wou mana ha'a-mama'ai na 'ia God 'ai haua tanaa na'i dora ni rongomaata'i, 'ai raha di'ua i ha'a-mama'ai nai haua tana'amou. ");
INSERT INTO aia_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“'Ai ta'aa di'u tana'amou, 'inia mou 'onaai sae kuru na na'otaradaaui noni. Mou ha'ausuriraaui sae do 'onaa rai tohe na'i atanai Ruma Maea ana God beiai duruduru nara haua, 'a ai'a 'ua 'anai horoosiai durudurusi. Me 'onaa rai tohe na'i gol na awa na'i Ruma Maea, 'a ororiu di'u dorai abu horosia. ");
INSERT INTO aia_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“'I'amou kuru mora mamou bweu! Ni Ruma Maea ana God 'a ororiu di'u baani'i gol, suria naasi maho na ha'amaea'i gol 'isi ");
INSERT INTO aia_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mou 'unua ro'u do 'onaa rai tohe na'i dora ni suu ho'asi beiai duruduru nara haua, ai'a 'ua 'anai horoosiai durudurusi. Me 'onaa rai tohe na'i ho'asi na awa na'i hunganai dora ni suu ho'asi, 'a ororiu di'u dorai abu horosia. ");
INSERT INTO aia_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mou kuru! Ni dora ni suu ho'asi 'a ororiu di'u baaniai ho'asi, suria naasi maho na ha'amaeaa i ho'asi. ");
INSERT INTO aia_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Naasi, 'iatei na tohe na'i dora ni suu ho'asi beiai duruduru na haua, 'a tohe ro'u na'i ho'asi na awa na'i hungana. ");
INSERT INTO aia_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mia tei na tohe na'i atanai Ruma Maea beiai duruduru na haua, 'a tohe'a ro'u na'i atana God, 'inia 'iia 'a awa na'i Ruma Maea. ");
INSERT INTO aia_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","'Iatei na tohe na'i aro beiai duruduru na haua, 'a tohe ro'u na'i dora ni mwaeraha ana God ma tohe ro'u na'i atana God, 'inia 'ia God 'a heinagu na'i dora ni mwaerahasi. ");
INSERT INTO aia_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“'Ai ta'aa di'u tana'amoui Ha'ausuri 'anai Ringe mi'amou Farisei. Mou here 'onaa domou goro, ma'ata ai'a! 'Inia rei'uaa namou wate'i tanaa God tangahurudi gere mareho rawa kekerei ta'a'i nara ha'angaugoro i mahoingau, ma'ua tara'i mareho ro'u suri'i mou amoo'i, mi'amou mou ai'a araisuri'i mareho raha nara awa na'i ha'ausuringa'i anai Ringe ana Moses. Mareho 'onaai haa'i here ra odo-odo tanaraaui sae, 'a'auhiraaui sae ha-ha'aroha'a ma 'anai ha'a-momori suri'i mwani maho namou haa'i. 'A goro i wate'i moi mareho kekerei o'asi tanaa God, ma'ata 'a ta'i kaeni goro di'u 'onaa mou ga'i haa'i ro'u i mareho raha. ");
INSERT INTO aia_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","'I'amou naasi sae 'anai na'otara mamougu 'onaai sae kuru. 'Oha mou bonasiai suri'i mwani gere ringe nara ai'a taraa ororiu, mamougu kaku'a'i mwani nei nara ororiu, mou here 'onaai sae na tau'aro raha 'anai rahiai gere abei nono baaniai panikeni wai, magu ai'a aidangisia do 'a gonohiai abei kamel. ");
INSERT INTO aia_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“'Ai ta'aa di'u tana'amoui Ha'ausuri 'anai Ringe mi'amou Farisei. Mou here 'onaa domou goro, ma'ata ai'a! Mou 'onaai sae na wasi ha'a-wadiwadi'i abedi panikeni mana abedi rabo'o, mana rarodi ra do'o'a moi. 'Inia 'omehamoou 'a kae goro na'i maadaaui sae, ma na'i raromamoo'i, naia haariai hairaurau mana 'ado'ado 'anai ha'a-wa'ewa'e'amou haarimoou. ");
INSERT INTO aia_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","'I'amou Farisei mou 'onaai sae kuru. Moi wasi ha'a-wadiwadia ga'u i raronai panikeni mana raronai rabo'o, maigu wadiwadi ro'u i abena. ");
INSERT INTO aia_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“'Ai ta'aa di'u tana'amoui Ha'ausuri 'anai Ringe mi'amou Farisei. Mou here 'onaa domou goro, ma'ata ai'a! Mou 'onaai hera nara here ha'a-'omegoroa. 'A 'ome goro moi na'i abau 'omaa, mana'i rarona 'a honu 'ini'i surisuri mana sae mae ra ngabo. ");
INSERT INTO aia_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Marehosi 'a to'i'amou, 'inia 'omehamoou 'a kae goro na'i maadaaui sae, ma na'i raromamoo'i, 'a honu 'iniai pwari'i mana ora-ora'a. ");
INSERT INTO aia_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“'Ai ta'aa di'u tana'amoui Ha'ausuri 'anai Ringe mi'amou Farisei. Mou here 'onaa domou goro, ma'ata ai'a! Mou tau'aro ha'agorohi'i barabaradaa'i rarabea na 'iraaui wauwa amoo'i rau ngahu ha'amaesi'i 'oha bwani mamou here ha'a-'omegoro'i barabaradaa'i sae odo-odo na 'iraau ro'u narau ha'amaesi'i. ");
INSERT INTO aia_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mamou 'unua do 'onaa moi awa na'i madoraasi mou ga'i bwa'i 'a'auhiraaui wauwa amoo'i 'anai ngahu ha'amaesiraaui rarabea 'isi. ");
INSERT INTO aia_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","'Oha namou 'unua do 'iraau ra'i wauwa amoo'i, mou rangasia ha'a-momori'a do 'i'amou ra'i pwiradaa'i sae narau ngahu ha'amaesiraaui rarabea. ");
INSERT INTO aia_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Naasi, moi ha'a-arosia wou i here ta'aa rau hauai wauwa amoo'i 'oha bwani. ");
INSERT INTO aia_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","'I'amou mwani mwaa ta'a'i! 'Ai he'ua namoigu hora 'inia baaniai ha'a-mama'ai na 'ia God 'a nuga mamasi'amou 'inia na'i dora ni rongomaata'i? ");
INSERT INTO aia_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Naasi, wai 'unua tana'amou. Wai ha'ataari'i rarabea mana sae madoma mana ha'ausuri tana'amou. Moi taritariraau suri'i mwani 'omaa 'anai here ha'ata'airaau. Tara'i nei 'iniraau moi ngahu ha'amaesi'i, tara'i nei moi rabu ahita'ini'i na'i dadaahoro, ma tara'i nei moi rorohoraau suri'i ruma ni ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Suriai haua amoou o'asi, 'i'amou namoigui dau ha'a-mama'ai 'ini'i sae odo-odo ana'ia God nara bwani ngahu ha'amaesiraau mau mai, taraawa'a mau na'i 'oha 'ia Kein 'a ngahu ha'amaesia Ebol tari beia Sakaraea, gare ana Barakaea na 'i'amou ai Jiu mou ngahu ha'amaesia na'i ahoaanai dora ni ho'asi mana Ruma Maea ana God. ");
INSERT INTO aia_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Wai 'unua ha'a-momori tana'amou, 'i'amou inoni na'i 'ohani naigu auru hunimoou i ha'a-mama'ai nai haua God 'ini'i mae nara haa'i sae 'isi.” ");
INSERT INTO aia_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Mia Jisas 'a ha'atee o'ani, “'Ei Jerusalem, Jerusalem. 'I'amou namou ngahu ha'amaesi'i rarabea mamou buta ha'amaesi'i sae heitaroha'i ana'ia God 'ini'i hau. 'A rago i 'oha nau rabasia domoi boi beiau 'anai 'omesuri'amou 'onaai bi'a i kua na abwa bwarasi'i gare ana'i. Mi'amou ai'a rabasia. ");
INSERT INTO aia_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Naasi moi rongoa! 'Ia God 'a hano'a baaniai 'omaa mana Ruma Maea amoou. ");
INSERT INTO aia_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mawai 'unua tana'amou, 'a bwa'i ta 'oha namoigu 'omesiau tari 'oha namoi ha'atee o'ani, ‘Araha God, 'oi ha'agorohia mo'o na'o ha'ataaria mai.’” ");
INSERT INTO aia_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","'Oha 'ia Jisas 'a hano baaniai Ruma Maea ana God, 'iraau rongoiusuri ana'i rau 'ariwou beia marau maania tanaa i 'ome goro na haa i Ruma Maea mana mwani gere ruma garigaria. ");
INSERT INTO aia_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mia Jisas 'a o'ani 'iniraau, “Mou re'i'i mwani ruma 'isi? 'E 'oha nai boi mau na bwa'i ta ta'i hau 'ini'i hau 'isi naraigui awa suri'i dora nara heinagu suri'isi. Na mwane hau 'isi rai gaasi'i dio. 'E mareho ha'a-momori nau maania tana'amounisi.” ");
INSERT INTO aia_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na'i muri 'ia Jisas 'a heinagu na'i hungahungai 'Oliv. Miraaui rongoiusuri ana'i rau boi haariraau beia marau o'ani 'inia, “'Oi maania tana'ameu i 'oha he'ua nai to'o i mareho na'o maania ani? Ma 'e ha'ara he'ua na mei re'ia na meigu 'iraraa 'inia do 'a gaarangi'a i ha'ahakonai dangi mana madoraa na'oi aho'i mai?” ");
INSERT INTO aia_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mia Jisas 'a aramiraau o'ani, “Moi 'ome'ome goro. Ra gasi ha'ateha'amou tara'i sae. ");
INSERT INTO aia_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","'Inia 'ai ragoi nei narai boi heitaroha'i na'i atagu narai o'ani, ‘'Inau naasi Ha'atahi.’ Ma'ai ragoi nei narai ha'ateharaau 'ini'i ha'ausuringa'i adaa'i nara ai'a ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Moi rongo'i rongo raha suri'i hei'oi nara to'o gaarangi mana taroha 'ini'i nei ra to'o ha'atau. Ma'ai abui ta'aabemoou. 'Inia mareho 'isi rai to'o o'asi'a, ma ai'a do naasi'a i ha'ahakona dangi. ");
INSERT INTO aia_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","'Iraaui sae na'i ta'i kantri rai 'ari marai heingahui beiraaui sae na'i nata kantri. I hioro raha 'ai to'iraaui sae suri'i tara'i dora mana nunu raha rai 'ihara'ini'i tara'i dora na'i marewana. ");
INSERT INTO aia_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Maho 'isi 'e taraawa'adi moi rongomaata'i, 'onaai urao nagu taraawa'a maesi ahu 'anai ha'ahutaai gare. ");
INSERT INTO aia_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Na'i madoraasi, sae suri'i mwani dora hako na'i marewana rai 'utai'amou suria 'i'amou ra'i rongoiusuri agu'i. Rai dau'amou 'anai nora ta'ai'amou marai ngahu ha'amaesi'amou. ");
INSERT INTO aia_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","'Ai ragoi sae hinihini naraugu bwa'i raba hinihiniau'a. 'Iraau rai 'itaraau hairiu marai usuha'iniraau tanaraaui maerongadaa'i. ");
INSERT INTO aia_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na'i 'ohasi 'ai ragoi rarabea pwapwaari'i rai ta'eha mai, ma'ai ragoi sae narai ha'ateharaau 'ini'i ha'ausuringa'i adaa'i nara ai'a ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Suriai haa'i moe'a adaa'i here ra ta'a'i, gaarangi 'iraau hakoi sae ra bwa'i to'oraa'a i heita'ahi. ");
INSERT INTO aia_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma 'onaa moi ura baabau tari ha'ahakonai madoraa ta'aasi, moigu daua namooui tahi tarau. ");
INSERT INTO aia_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mana Taroha Goro 'abaiai heimarungi ana God rai taroha'inia hura'a 'ari suriai marewana hako neina mwani noni hako rai rongoa, maigui boi ha'ahakonai dangi.” ");
INSERT INTO aia_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Mia Jisas 'agu o'ani ro'u, “Ta 'oha, 'i'amou moi re'iai mareho na ta'aa di'u na 'ia God na 'itaa. Naia naasi mareho na 'ia Rarabea Daniel 'a ha'atee rarabeanga'inia na'i 'oha bwani. 'Ai ura na'i Ruma Maea mai ha'ata'aiai dorasi na'i maana God. 'Iatei na'oi 'oha'iniai ha'ateeni, 'oi ha'imaania aidangisia ma'ata'a i 'ado'ado 'ana. ");
INSERT INTO aia_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Hoita, 'onaa 'oi awa na'i Provensi Jiudea na'i madoraasi, 'oi hora ta'eha suri'i hungahunga 'anai bainihu. ");
INSERT INTO aia_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","'Onaa 'oi awa hura'a i buriinai ruma amua, 'oi hora'a! 'Oi abui siri aho'i na'i ruma 'anai rahi'i tara'i mareho amu'i. ");
INSERT INTO aia_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","'Onaa 'oi awa na'i mou amua, 'oi abu aho'i 'ari ruma 'anai hauai bwana amua. ");
INSERT INTO aia_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ha'a-arohai'araau di'u i urao ra pote mana hasuuri'i, 'inia 'ai bwara tanaraaui hora. ");
INSERT INTO aia_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Moi ha'arahesi mana madoraasi 'ai abui to'o na'i 'oha na rangi ro'aro'a ma'ua na'i dangi ni mamaro. ");
INSERT INTO aia_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","'Inia ni rongomaata'i na'i madoraasi, 'ai ta'aa di'u baani'i mwane rongomaata'i nara taraawa'a mau na'i madoraa na ha'apwa'araa God i marewana tari dangini. Ma na'i muri, 'a bwa'i ta madoraa ta'aa o'asi'a ro'u naigu to'o. ");
INSERT INTO aia_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","'Onaa 'ia God 'ai abui ha'apwakuai madoraasi, 'a bwa'i sae nai tahi. Me suriai ta'ahiraau ana i sae na bwani 'ome sigihiraau, naia naigui ha'apwakua 'inia i madoraasi. ");
INSERT INTO aia_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Na'i 'ohasi 'onaa ta sae nai o'ani, ‘Moisu wana mai. Naani Ha'atahi,’ ma'uasi 'ai o'ani, ‘Na 'ariani.’ Moi abui hinihinia. ");
INSERT INTO aia_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ra'i sae pwapwaari'i rai boi ma rai o'ani, ‘'Inau naasi huunai Ha'atahi,’ ma'uasi rai o'ani, ‘'Inau naasi huunai Rarabea ana God.’ Rai haa'i ha'ara raha mana ha'abu'oahu 'anai ha'ateharaaui sae. Rau raba ha'ateharaau ro'u i nei na 'ia God 'a bwani 'ome sigihiraau maagu bwara. ");
INSERT INTO aia_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Naasi moi mamataihere goro 'iniraau. Naia nau ha'abasu'amou 'inia na'i na'o 'ini'i mareho 'ini. ");
INSERT INTO aia_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“'Onaa ta sae 'ai o'ani, ‘Moi bahurongoau! 'I Ha'atahi na 'ari dora mangasarasi,’ moi abui 'ari. Ma 'onaa 'ai o'ani, ‘'Iia na moi siriwou rumani,’ mamoi abu hinihiniai taha na 'unuasi. ");
INSERT INTO aia_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","'Inia na'i 'oha na 'inau i Gare i Noni wai aho'i mai, wai ha'ata'i goro hura'a 'onaai mararea na marewa raha na'i ahoaa na marewasiai rua aba hairiu. ");
INSERT INTO aia_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ma gau 'iraraa, na'i dora na awaiei maho na mae, rai ruru wou iei manu nara matai ngaa'i maho mae.” ");
INSERT INTO aia_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mia Jisas 'a o'ani ro'u, “Na'i moi murinai madoraa ta'aasi, ‘I sina 'a bwa'i marewa, mana hura 'ai o'asi ro'u. I hee'u rai ahoda mana taraani maho na'i ahoasara rai 'iha'iha.’ ");
INSERT INTO aia_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Na'i muri 'iraau hakoi saenai marewanani rai re'ia na'i ahoasara i ha'ara na ha'ata'iniai aho'i mai agua, i Garei Inoni. Na'i 'ohasi rai awara tau ta'aa 'iniai mamaa'u. Maraigui 'omesiai boi aho'i agua suri'i rorodo beiai mena mana raraha na wetewete. ");
INSERT INTO aia_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","'E enjel nai uuhia wetewete i ahuri mawai ha'a-taariraau hura'ai enjel agu'i suriai mwani dora na'i marewana 'anai wairaau goni mai nei nau bwani 'ome sigihi'i. Rai taraawa'a na'i nata aba i marewana marai tari 'ari na'i nata aba.” ");
INSERT INTO aia_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mia Jisas 'agu o'ani ro'u, “Moisu 'adoma'iniai fig mai ha'ausuri'amou. Na'i 'oha na'o re'iai raraanai fig ra taraawa'ai asuru mana rawa ra pwira, ma'o 'iraraa do madoraa raorao 'a gaarangi'a. ");
INSERT INTO aia_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","'A o'asi ro'u. 'Oha na maho ta'a'i 'isi rai to'o, mamou 'iraraa do 'inau gaarangi aho'i mai'a. ");
INSERT INTO aia_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mawai 'unua ha'a-momori tana'amou, mareho 'isi rai to'o, miraaui sae nara awa na'i madoraani ra bwa'i mae mau. ");
INSERT INTO aia_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","I ahoasara mana ano rarui anoro mana ha'atee agu'i rai awa tarau.” ");
INSERT INTO aia_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mia Jisas 'a o'ani, “Na dangi mana madoraa he'ua nawai aho'i mai, ai'a ta sae nai 'iraraa. Rei'uaa 'inau i Garei Inoni miraaui enjel na'i aro mameu ai'a 'iraraa ro'u. 'Ia moia Amagu na 'iraraa. ");
INSERT INTO aia_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ni mareho na 'iraaui sae ra hahaa'i na'i madoraa ana Noa rai to'o ro'u na'i 'oha 'inau i Gare Inoni wai aho'i maisi. ");
INSERT INTO aia_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","'Oha na ai'a boi mau i ruarua, 'iraaui sae rau poru moi 'iniai ngaungau mana gonogono mana ha'aha'iwai tari na'i 'oha na 'ia Noa 'agu buna siri na'i haka. ");
INSERT INTO aia_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Rau ai'a 'adoma'inia do ta maho nai to'o. Raugu 'asu'a mana ruarua 'a to'o'a ma taresiraau'a. 'Ai o'asi taha nai to'o na'i madoraa na 'inau i Garei Inoni wai aho'i mai. ");
INSERT INTO aia_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Na'i 'ohasi ta rua sae rarui tau'aro goni na'i mou. 'Iraau enjel agu'i rai waia ta nei mana nata nei 'ai awa mau. ");
INSERT INTO aia_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","'E rua urao rarui tagora mahoingau goni, 'e ta'i rai waia mana nata nei 'ai awa mau. ");
INSERT INTO aia_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Naasi moi 'ome'ome goro, 'inia mou ai'a 'iraraai madoraa he'ua 'inau Araha amoou wai aho'i mai. ");
INSERT INTO aia_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Moisu 'adoma'iniai taha nau maaniani. 'Onaa sae na to'oraai ruma 'ai 'iraraai 'oha na sae beriberi 'ai siri na'i ruma ana, 'a bwa'i mauru. 'Ai 'ome'ome goro ma bwa'i ha'awatea doni saesi 'ai siri 'anai beri na'i ruma ana. ");
INSERT INTO aia_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Naasi 'i'amou ro'u moi ha'aagau tarau, 'inia 'inau i Garei Inoni wai aho'i mai na'i madoraa namou bwa'i 'iraraa ro'u.” ");
INSERT INTO aia_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Naasi mia Jisas 'agu o'ani ro'u, “Sae tatau'aro he'ua ni saemaua 'ai ha'a-'omesuria 'ini'i mwane mareho na'i ruma ana, ma 'anai ha'atora'ini'i hura'ai mahoingau tanaraaui sae tatau'aro na'i madoraa 'ana? Naia i sae tatau'aro na madoma ma here goro suri'i mwane mareho nara ha'a-'u'uria 'ini'i. ");
INSERT INTO aia_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ha'amwaniai sae tatau'arosi na'i 'oha na saemaua ana 'ai boi sadoia do 'iia 'a here ha'agorohiai tatau'aro ana. ");
INSERT INTO aia_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ma wai 'unua ha'a-momori tana'amou, 'i saemauasi 'ai ha'a-'u'uria mo'osi 'ini'i mwane mareho na to'ora'i. ");
INSERT INTO aia_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Ma 'onaa 'ia mo'osi 'e sae tatau'aro ta'aa, 'iia 'ai matai haua moi 'ado'ado o'ani, ‘I saemaua agua 'a bwa'i aho'i raurau.’ ");
INSERT INTO aia_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Naasi ma taraawa'a ngahu ngahuraaui sae tatau'aro na 'omesuri'i, ma awa moi 'anai ngau mana gonogono raha 'ini waini bweu beiraaui sae nara gono raha. ");
INSERT INTO aia_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","'Aigu 'asu'a mana saemaua ana 'ai ataha na'i madoraa na saesi 'a bwa'i 'adoma'inia do 'a ga'i ataha. ");
INSERT INTO aia_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na'i 'oha nai ataha, 'ai ha'a-mama'aia di'u i sae tatau'arosi, mai nugaa 'anai mamaa'a beiraaui sae narau here 'onaa dorau goro maraugu ai'a. Na'i 'isi naraigui angiangi na'i ei marai 'ara ngingita'i rihodaa'i 'iniai rongomaata'i.” ");
INSERT INTO aia_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mia Jisas 'agu o'ani ro'u, “Ni heimarungi ana God na awa na'i aro 'a 'onaai mamaani 'inia tangahuru gere urao narau waa'i raita adaa'i 'anai 'ari ruma anai gere urao na ha'aagau 'anai heisadoi beiai sae na dorarui ha'iwai. ");
INSERT INTO aia_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mana ta'i tangahurui uraosi, 'e waira rima 'iniraau narau madoma mana nata waira rima rau ai'a. ");
INSERT INTO aia_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","'Iraau waira rima narau ai'a madomasi, raugu ha'ahonu'i moi raita adaa'i 'iniai rumu maraugu ai'a waiwai rumu ha'araroa'a ro'u. ");
INSERT INTO aia_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Miraau waira rima narau madoma rau ha'ahonu'i raita adaa'i 'iniai rumu marau waiwai rumu ha'araroa. ");
INSERT INTO aia_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","'Ohasi na mwane na dorarui ha'iwai uraosi 'a gere boi poruporu'a. Rau mamasi wou miraaui ta'i tangahurui gere uraosi rau mamauru'a marau mauru'a. ");
INSERT INTO aia_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Raugu 'asu'a na'i 'ubutanai rodo marau rongo'i'a i sae ra awaawara. Ra o'ani, ‘'Ia mo'o nai ha'iwai 'a gaarangi ada'a. Moi hura'a mai 'anai ha'amaotoa.’ ");
INSERT INTO aia_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“'Iraaui ta'i tangahurui uraosi rau rarai marau ha'aagau'i raita adaa'i. ");
INSERT INTO aia_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mana rima urao narau ai'a waiwai rumu rau ha'angoni rumu beiraaui nata rima urao, 'inia raita adaa'i ra gaarangi mamata'a. ");
INSERT INTO aia_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mana rima urao narau madoma rau o'ani 'iniraau, ‘Rumu nameu to'oraa 'a araria moi raita amee'i. Moi 'ari dora 'anai hori rumu mamoi hori namoou rumu.’ ");
INSERT INTO aia_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“'Oha raugu hano 'anai hori rumu, mana sae narau mamasia 'a ada'a. Mana rima urao narau ha'aagau rau hano'a beia. 'Oha naraugu siri na'i dora ni ngaugoni mara honosia'a i maraaruma. ");
INSERT INTO aia_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Na'i muri, 'oha naraugu boi nata rima urao, mana maraaruma 'a bwani honohono'a. Miraau awara o'ani, ‘Saemaua, 'oi tahangiai maraaruma tana'ameu mamei siriwou.’ ");
INSERT INTO aia_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mia mo'o nara ha'aha'iwaia 'agu o'ani moi, ‘Wai 'unua tana'amou ha'a-momori. 'Inau ai'a 'irara'amou.’” ");
INSERT INTO aia_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Na'i ha'ahakonai mamaani ana Jisas 'agu o'ani ro'u, “Moi awa ha'aagau tarau, 'inia mou ai'a 'iraraai dangi mana madoraa nawai aho'i mai.” ");
INSERT INTO aia_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mia Jisas 'a o'ani ro'u, “Wai haua ta heiha'auu ro'u 'iniai madoraa naigui boi i heimarungi ana God. 'Io, 'e ta'i 'oha 'e saemaua na ha'aagau 'anai hano ha'atau. 'A 'unuraau mai sae tatau'aro ana'i ma ha'a-'u'uriraau 'ini'i toto'ora ana'i. ");
INSERT INTO aia_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","'A haa'i ha'a tanaraau, mana ha'i ha'a na haua 'a suriai mataihere narau ha'ata'inia hura'a suri'i tatau'aro adaa'i. 'E ta'i abe na haua tanaai rima meru, nata abe 'e rua meru, mana nata abe 'e ta'i meru. Na'i muri maagu hano. ");
INSERT INTO aia_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“'Ia mo'o nara haua tanaai rima meru 'a hano ma ha'atau'aroai ha'a ma sadoia ro'u i nata rima meru 'anai a'oia ara'a i ha'asi. ");
INSERT INTO aia_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","'Ia mo'o ra haua tanaai rua meru 'a haua o'asi ro'u. 'A sadoiai nata rua meru ma nuga a'oia ara'a ro'u 'inia. ");
INSERT INTO aia_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mia mo'o nara haua tanaai ta'i meru, 'a hano ma dehiai giru ma ahunia'a na'iei. ");
INSERT INTO aia_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“'A orea'a magu aho'i mai saemaua adaau ma 'unuraau mai 'anai re'i'i ha'a na haa'i tanaraau. ");
INSERT INTO aia_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na sae tatau'aro nara haua tanaai rima meru 'a waa mai ha'a ana ma o'ani 'iniai saemaua ana, ‘Saemaua, 'inau 'o haua tanaaui rima meru, ma naani ro'u i nata rima meru nau to'oana 'inia.’ ");
INSERT INTO aia_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Mia mo'osi 'a o'ani 'inia, ‘Goro di'u! I'oe 'e sae tatau'aro goro na 'o here goro suri'i mwani mareho nau ha'a-'u'uri'o 'ini'i. Suriai here goro amua na'i gere tagora nau haua tana'o, naasi na'i 'ohani wai ha'a-'u'uri'o 'ini'i mareho raha. 'Oi boi ma'oi wa'ewa'e tarau beiau.’ ");
INSERT INTO aia_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Mia mo'o nara haua tanaai rua meru 'a boi ma o'ani 'inia, ‘Saemaua, 'e rua meru na'o haua tanaau. Ma naani ro'u i nata rua meru nau to'oana 'inia.’ ");
INSERT INTO aia_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mana saemauasi 'a o'ani, ‘Goro di'u! I'oe 'e sae tatau'aro goro na 'o here goro suri'i mwani mareho nau ha'a-'u'uri'o 'ini'i. Suriai here ha'agorohia amua i gere tagora nau haua tana'o, na'i 'ohani wai ha'a-'u'uri'o 'ini'i mareho raha. Naasi 'oi boi ma'oi wa'ewa'e tarau beiau.’ ");
INSERT INTO aia_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Na'i muri, na sae tatau'aro nara haua tanaai ta'i meru 'a boi ma o'ani 'inia, ‘Saemaua, nau 'iraraa do i'oe 'e sae here bwara. 'Au 'iraraa do rei'uaa na i'oe 'o ai'a tau'aro suri'i mou amu'i, ma'o 'adoma'iniai dau ha'a 'ini'i mahoingau na 'iraau sae tatau'aro amu'i ra hasi'i. ");
INSERT INTO aia_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Suriai o'asi ana, 'inau mamaa'usi'o mau giru'i'a i ha'a amu'i na'i ano. 'Ome! Nara mau 'ini ha'a amu'i.’ ");
INSERT INTO aia_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mana saemauasi 'a o'ani 'inia mo'osi, ‘I'oe 'e sae tatau'aro ta'aa! 'O 'age'age! 'O bwane 'iraraa do 'inau 'au 'adoma'iniai dau ha'a 'ini'i mahoingau na 'iraau sae tatau'aro agu'i ra hasi'i. ");
INSERT INTO aia_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Naasi, 'o ga'i ha'atagoraai ha'a agua na'i rumani niga ha'a! Neina na'i 'oha nawai aho'i mai, wai matai daa goni beia ta gere ha'a narai a'oia ara'a ro'u na'i hungana.’ ");
INSERT INTO aia_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Mana saemauasi 'a o'ani 'iniraaui sae tatau'aro ana'i, ‘Moi rahia baania mo'osi ha'asi mamoi haua tanaa mo'o na to'oraai tangahurui meru. ");
INSERT INTO aia_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","'Ia mo'o na here ha'agorohiai taha nau haua tanaa, 'inau wai ha'arago'a ro'u wou tanaa mai to'o nei rago. Mia tei na ai'a here ha'agorohiai mareho nau haua tanaa, rei'uaa gere mareho na to'oraa, wai rahia aho'i baania. ");
INSERT INTO aia_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hoita, moi daua mo'osi mamoi gaasia siri na'i dora kuhi. Na'i 'isi naigui angiangi na'iei mai 'ara ngingitai rihona.’” ");
INSERT INTO aia_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mia Jisas 'a o'ani ro'u, “Na'i 'oha 'inau i Garei Inoni wai aho'i mai 'onaai mwaeraha, wai boi beiai raraha ma beiraaui enjel agu'i mawai heinagu na'i dorani mwaeraha agua. ");
INSERT INTO aia_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","'Iraau hakoi sae na'i mwane marau rai goni mai na'i maagu mawai hoairaau 'onaai sae 'omesuri siip na hoai'i siip baaniraaui gout. ");
INSERT INTO aia_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wai nugaraaui siip na'i aba odo, miraaui gout na'i aba maha. ");
INSERT INTO aia_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Minau mwaeraha waigu o'ani 'iniraaui nei na'i aba odo, ‘Moi boi, 'i'amoui nei na ha'agorohi'amou a Amagu. Moi boi 'anai awa wa'ewa'e na'i heimarungi ana God na bwani ha'aagaua tana'amou mau mai na'i taraawa'anai marewana. ");
INSERT INTO aia_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mou matai siri, 'inia na'i 'oha nau hioro mou hanganiau. 'Oha nau raba gono mou ha'agonoau. 'Au mahuara mamou ha'amaotoau suri'i ruma amoo'i. ");
INSERT INTO aia_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na'i 'oha nau ai'a to'o bwana, mou ha'aho'owa'aau. 'Oha nau daoha mou 'omesuriau. 'Oha nau awa na'i rumaniho'o mou garihiau.’ ");
INSERT INTO aia_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Miraaui sae nara odo-odo na'i maana God rai o'ani, ‘Araha, na'i 'oha he'ua na'o hioro mameu hangani'o, ma'ua 'oha he'ua na'o raba gono mameu ha'agono'o? ");
INSERT INTO aia_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","'Oha he'ua na'o mahuara mameu ha'amaoto'o, ma'ua 'oha he'ua 'o ai'a ho'owa'a mameu ha'aho'owa'a'o? ");
INSERT INTO aia_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","'Oha he'ua na'o daoha ma'ua awa na'i rumaniho'o mameu garihi'o?’ ");
INSERT INTO aia_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Minau mwaeraha waigu o'ani, ‘Wai 'unua ha'a-momori tana'amou. Na'i 'oha 'o 'a'auhia tanei 'iniraaui do'oragu'i ma'ua asigu'i nara ai'a ororiu na'i marewanani, 'a 'onaa do'o 'a'auhiau ro'u.’ ");
INSERT INTO aia_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Na'i muri waigu rihota'i tanaraaui nei na'i aba maha, mawai o'ani 'iniraau, ‘'I'amou nei nai ha'a-mama'ai'amou a God, moi 'ariwou baaniau. Dora amoou na'i 'ari 'eu na bwa'i kuru'a ro'u ta'oha na 'ia God 'a bwani ha'aagaua tanaa Saetan mana enjel ana'i. ");
INSERT INTO aia_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","'Inia 'inau 'au hioro mamou ai'a hanganiau. 'Au maesiai gono mamou ai'a ha'agonoau. ");
INSERT INTO aia_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","'Au mahuara mamou ai'a 'unuau siri suri'i ruma amoo'i, 'au ai'a to'o bwana mamou ai'a ha'aho'owa'aau. 'Au daoha mau awa na'i rumaniho'o mamou ai'a garihiau.’ ");
INSERT INTO aia_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ma rai o'ani, ‘Araha, na'i 'oha he'ua nameu re'i'o na'o hioro, ma'ua 'o raba gono, ma'ua 'o mahuara, ma'ua 'o ai'a to'o bwana, ma'ua 'o daoha, ma'ua 'o awa na'i rumaniho'o mameu ai'a 'a'auhi'o?’ ");
INSERT INTO aia_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Mawai o'ani, ‘Wai 'unua ha'a-momori tana'amou, na'i 'oha na'o ai'a raba 'a'auhia tanei 'iniraaui do'oragu'i ma'ua asigu'i nara ai'a ororiu na'i marewanani, 'a 'onaa do'o ai'a raba 'a'auhiau ro'u.’ ");
INSERT INTO aia_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“'Iraaui sae 'isi rai siri na'i ha'a-mama'ai na bwa'i hako'a ta 'oha. Miraaui nei ra odo-odo na'i maana God rai dauai tahi tarau.” ");
INSERT INTO aia_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Na'i murinai mamaani hako ana Jisas tanaraaui rongoiusuri, 'a o'ani 'iniraau, ");
INSERT INTO aia_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mou 'iraraa do na'i ho'oa wou 'ai taraawa'a i rongo 'anai 'adoma'i aho'isiai Roho Aharau. 'Inau i Garei Inoni, 'e nei nai usuha'iniau tanaraaui nei rai ha'amaesiau na'i hunganai dadaahoro.” ");
INSERT INTO aia_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hoita, na'i maui 'ohasi 'iraaui Na'ohadaaui Piriisi ma 'iraau tara'i saemaua adaa'i Jiu ro'u rau rurugoni na'i ruma ana Kaeafas. 'Iia naasi bwauodo nadaaui Piriisi na'i madoraasi. ");
INSERT INTO aia_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rau hadanga'iniai here narai haua narau bwa'i rongo raha 'inia na'i 'oha rai daua Jisas 'anai ha'amaesia. ");
INSERT INTO aia_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Rau 'adoma'i aratara dorai abui daua suri'i dangi narau haa i rongo, 'a gasi to'o ta ha'agogoru. ");
INSERT INTO aia_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","'Ia Jisas 'a awa na'i Betani na'i ruma ana Saemon, 'e sae na lepa ga'u. ");
INSERT INTO aia_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na'i 'oha 'ia Jisas 'a ngau, 'e urao na sirimai beiai gere bei 'ome goro na awa iei rumu na hori bwara ma si'ini goro. 'A boi ma ringisia na'i bwauna Jisas. ");
INSERT INTO aia_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na'i 'oha 'iraaui rongoiusuri rau re'iai haua o'asi anai uraosi, rau taesu'a 'ana marau o'ani, “'A 'ua na ha'agata'inia 'iniai rumu na hori bwarasi? ");
INSERT INTO aia_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","'Onaa 'a ga'i raonga'inia, 'e kae ha'a nara ga'i horia 'inia, mana ha'a 'a ga'i hisungiraau 'ini'i sae pohara.” ");
INSERT INTO aia_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","'Ia Jisas 'a 'iraraa moi taha rau 'unua ma o'ani 'iniraau, “'A 'ua namou ha'atee ha'ata'aia 'inia? 'Iia 'a haua tanaau i here na goro. ");
INSERT INTO aia_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","'Iraaui sae pohara rai awa tarau bei'amou. 'Inau na bwa'i. ");
INSERT INTO aia_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ni mareho na haua tanaausi 'a ha'aagauai abegu 'anai 'oha rai toringiau. ");
INSERT INTO aia_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mawai 'unua ha'a-momori tana'amou. Suri'i mwane dora na'i marewana narai taroha'inia ei Taroha Goro, rai maaniai taha na haua i uraosi, marai 'adoma'i aho'isia 'inia.” ");
INSERT INTO aia_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mia Jiudas Iskariot, 'e ta'i 'iniraau i ta'i tangahuru mana rua rongoiusuri, 'a 'ari beiraaui Na'ohadaa'i Piriisi. ");
INSERT INTO aia_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma o'ani, “'E siha ha'a namoi haua tanaau 'onaa nawai haua tana'amou ta ha'a-aratara namoi matai daua 'inia Jisas?” Miraau haua tanaa i oru tangahuru korai silva. ");
INSERT INTO aia_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na'i 'ohasi 'a taraawa'a sibasiba madoraa goro 'anai usuha'inia Jisas tanaraau. ");
INSERT INTO aia_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na'i dangi tahamora 'ini'i dangi nara ha'ato'oai Rongo 'ini Bredi nara ai'a dorari'i beiai draebam, 'iraaui rongoiusuri rau boi beia Jisas marau songa'inia o'ani, “Na'i hei na'o 'irisia domei ha'aagaua iei ngaugoni 'anai 'adoma'i aho'isiai Roho Aharau?” ");
INSERT INTO aia_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mia Jisas 'a o'ani, “Moi siri na'i 'omaai Jerusalem mamoi taha beiai sae nau 'unua tana'amou ani. Moi o'ani 'inia, ‘I ha'ausuri ameeu 'a 'unua doni madoraa ana 'a gaarangi'a. 'Ai ngau beiraaui rongoiusuri ana'i na'i ruma amua 'anai 'adoma'i aho'isiai Roho Aharau.’” ");
INSERT INTO aia_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na'i 'ohasi 'iraaui rongoiusuri rau haa 'onaai 'unua ana Jisas tanaraau marau ha'aagauai ngaugoni 'anai 'adoma'i aho'isiai Roho Aharau na'i rumasi. ");
INSERT INTO aia_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na'i su'urahi, 'ia Jisas mana rongoiusuri ana'i rau heinagu 'anai ngau. ");
INSERT INTO aia_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na'i 'oha rau ngau, 'ia Jisas 'a o'ani 'iniraau, “Wai 'unua ha'a-momori tana'amou. 'E ta'i abe 'ini'amou nai usuha'iniau tanaraaui maerongagu.” ");
INSERT INTO aia_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na'i 'oha rau rongoa o'asi, 'iraaui rongoiusuri rau arunga ta'aa di'u. 'E nei ma o'ani 'inia Jisas, “'A 'ua Araha? 'O 'adoma'inia do 'inau gasi?” ");
INSERT INTO aia_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mia o'ani, “'Ia mo'o miri ta'i toha'iniai dorai bredi na'i ta'i rabo'oni nai usuha'iniau tanaraaui maerongagu. ");
INSERT INTO aia_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","'Inau i Garei Inoni wai mae 'onaai ha'arangasia ada na'i Usu-usu Maea. Ma'ata ha'arohaia di'u a mo'o nai usuha'iniau tanaraaui maerongagu. 'A ga'i goro tanaa 'onaa 'a ga'i bwa'i huta.” ");
INSERT INTO aia_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Na'i 'ohasi 'ia Jiudas, sae na duruduru 'inia do'ai usuha'inia Jisas tanaraaui maerongana 'a o'ani, “Ha'ausuri, 'o 'adoma'inia do 'inau gasi?” Mia Jisas 'a o'ani 'inia, “I'oe haari'o na'o 'unua o'asi.” ");
INSERT INTO aia_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na'i 'oha rau ngau, 'ia Jisas 'a dauai huai bredi. 'A ha'atee ha'agorohia God 'inia ma uubia. 'A haua tanaraaui rongoiusuri ma o'ani, “Naani abegu. Moi daua mamoi ngaua.” ");
INSERT INTO aia_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ma dauai panikeni waen. 'A ha'atee ha'agorohia God 'inia ma haua tanaraau ma o'ani, “'I'amou hako moi gonohia. ");
INSERT INTO aia_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Naani 'abugu 'anai ha'a-'o'oriai duruduru haoru ana God. 'Ai ahe 'iniraaui mwani noni rago neina 'ia God 'ai 'adoma'i nugasi'i 'inodaa'i. ");
INSERT INTO aia_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Wai 'unua tana'amou. 'Augu bwa'i gonohia'a ro'u ta waen tari 'oha wai gonohiai waen haoru bei'amou na'i dora ni heimarungi ana Amagu.” ");
INSERT INTO aia_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Rau suru'iai gana marau hura'a 'anai hungahungai 'Oliv. ");
INSERT INTO aia_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mia Jisas 'a o'ani 'iniraaui rongoiusuri ana'i, “Na'i rodoni, 'e mareho nai to'o tanaau. Mi'amou hako moi nugasiau mamoi hora hako baaniau 'iniai marehosi. 'Ai 'onaai 'unua ada na'i Usu-usu Maea o'ani, ‘'Ia God 'ai ha'amaesiai 'omesuri siip miraaui siip ana'i rai 'adarara.’ ");
INSERT INTO aia_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma'ata na'i 'oha wai suruta'e aho'i, wai 'ari na'i na'o 'ini'amou na'i Galili. Na'i 'isi nagaigui heito'oi ei.” ");
INSERT INTO aia_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Na'i 'ohasi 'ia Pita 'a o'ani 'inia Jisas, “Rei'uaa na 'iraau rongoiusuri amu'isi rai nugasi'o, minau 'au bwa'i moe'a!” ");
INSERT INTO aia_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mia Jisas 'a o'ani 'inia, “Pita, wai 'unua tana'o ha'a-momori. Na'i de'eni rodo, i kua 'a bwa'i tataraoke mau mi'oe 'oi bwani tohe ha'a-oru do i'oe 'o ai'a mataiau.” ");
INSERT INTO aia_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mia Pita 'a o'ani, “Rei'uaa nawai mae bei'o, mau bwa'i 'unua moe'a do 'au ai'a matai'o!” Miraau hakoi rongoiusuri rau ha'atee o'asi ro'u. ");
INSERT INTO aia_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mia Jisas 'a wairaaui rongoiusuri 'ari na'i dora ra 'unua 'iniai Getsemanii. Ma o'ani 'iniraau, “Moi heinagu mamasi 'ini. 'Inau wai 'ari 'ani 'anai ha'arahesi.” ");
INSERT INTO aia_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma waia Pita mana rua gare ana Sebedi, 'ia Jems mia Jon. Na'i 'ohasi 'ia Jisas 'a ahutotou di'u mana 'adoma'ina 'a kuhi. ");
INSERT INTO aia_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma o'ani 'iniraau i waira orusi, “Na ahutotou nau haa 'a raha di'u, mau gaarangi maesia. Moi awa na'i 'ini mamoi rarai beiau.” ");
INSERT INTO aia_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ma gere sara 'ari wou baaniraau. 'A topira'i ruru ma abwa auru dioi ano ma ha'arahesi o'ani, “Amagu, 'onaa 'ai mwada'u 'oi abu ha'awateau 'anai siri na'i rongomaata'ini. Ma'ata 'ai abu suriai hei'irisigu, ma 'ai suriai hei'irisimu.” ");
INSERT INTO aia_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","'A aho'i mai ma re'iraaui waira oru, rau poru mauru moi. Mia Jisas 'a o'ani 'inia Pita, “'A 'ua namou mauru moi 'inia? Mou bwa'i matai rarai beiau suria moi ta ta'i 'aoa? ");
INSERT INTO aia_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Moi rarai mamoi ha'arahesi neina moi abui ahoda na'i 'oha moi siri na'i heiohongi. Ra wetewete i 'adoma'imoo'i 'anai ha'isuri'i maho ra odo-odo, mana abemoo'i naragu maemae'a.” ");
INSERT INTO aia_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","'A aho'i ma ha'arahesi ro'u. Naasi ruanai 'oha. 'A o'ani, “Ama, 'onaa 'a bwara do'oi ha'abwarasiau baaniai rongomaata'ini, ma 'ai o'asi'a 'onaai 'irisia amua.” ");
INSERT INTO aia_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","'Oha na aho'i ro'u ma re'iraaui waira oru rau poru mauru moi. Ni maadaa'i ra hihi'a di'u 'iniai mamauru'a. ");
INSERT INTO aia_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma aho'i 'anai ha'arahesi ro'u. Naasi orunai 'oha. 'A 'unua ro'u mau ta'i mareho ani. ");
INSERT INTO aia_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","'Oha nagu aho'i ro'u mai ma o'ani'a 'iniraau, “'A 'ua? Mou mauru mamou mamaro mau? 'A tari'a i madoraa narai usuha'iniau i Garei Inoni tanaraaui noni ta'a'i. ");
INSERT INTO aia_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","'Ome, 'ia mo'o nai usuha'iniau tanaraaui maerongagu 'a boi'a. Moi ura ara'a magai 'ari beiraau.” ");
INSERT INTO aia_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Na'i madoraa na hadahada mau a Jisas, mia Jiudas 'e ta'i 'iniraaui rongoiusuri, 'a ada'a beiai ruruha raha narau ha'ataaria 'i Na'ohadaa'i Piriisi mana saemaua adaa'i Jiu. Rau boi bei'i naihi mana hasi'ei 'anai heingahu. ");
INSERT INTO aia_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","'Ia Jiudas 'a bwani hauai ha'a-aratara tanaraau o'ani, “'Ia mo'o nawai ngoonia, naasi na moi daua.” ");
INSERT INTO aia_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ma 'ari odo-odo beia Jisas ma o'ani 'inia, “Maia Ha'ausuri” ma ngoonia. ");
INSERT INTO aia_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mia Jisas 'a o'ani 'inia, “Gere sae agua, 'oi hauai mareho na'o boi 'ana.” Na'i mau 'ohasi mara daua'a Jisas 'anai waia. ");
INSERT INTO aia_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma'e ta'i 'iniraaui rongoiusuri ana'ia Jisas 'a dau wou na'i naihi ana. 'A rahia ma taba taahiai karinganai sae tatau'aro anai Na'ohadaaui Piriisi. ");
INSERT INTO aia_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mia Jisas 'a o'ani 'inia, “'Oi nugaa aho'i naihi amua na'i dora 'ana. 'Iatei nai heingahui 'iniai naihi, 'ai mae ro'u 'iniai naihi. ");
INSERT INTO aia_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","'A 'ua? 'O ai'a 'iraraa do 'onaa wai ha'angonia Amagu 'anai 'a'auhiau, 'a ga'i bwa'i hasi ha'ataari'i mai ta taringai merui enjel 'anai boi taatahi bwarasigaau? ");
INSERT INTO aia_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Me 'onaa nawai haua o'asi, me 'agu bwa'i to'o'a i taha na Usu-usu Maea na 'unua 'iniai mareho naagu to'o na'i 'ohanisi.” ");
INSERT INTO aia_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ma o'ani 'iniraaui mwani sae 'isi, “'A 'ua? Mou 'adoma'inia do 'inau 'e sae hehere ta'aa namou boi 'inia bei'i naihi mana hasi'ei 'anai heingahu 'anai dauau? 'A 'ua namou ai'a bwani dauau 'inia na'i Ruma Maea ana God? 'Ado dangi na'i 'isi'a nau ha'ausuri na'iei. ");
INSERT INTO aia_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma'ata mareho namougu hauanisi, 'e ha'ato'oa moi mareho narau bwani usua 'i rarabea na'i Usu-usu Maea.” Na'i 'ohasi miraaui rongoiusuri rau nugasia Jisas marau hora hako baania. ");
INSERT INTO aia_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","'Iraaui Ha'ausuri 'anai Ringe ana'ia Moses miraau tara'i saemaua ro'u rau bwane goni mai hako na'i ruma ana Kaeafas, i Na'ohadaaui Piriisi. Miraaui nei rau daua Jisas rau waia 'ari na'i dorasi. ");
INSERT INTO aia_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mia Pita 'a haisuri ha'atau moi. 'A siri na'i raronai dora a'ora na'i maanai ruma anai Na'ohadaaui Piriisi. Ma heinagu beiraaui sae hehei'oi ra 'omesuriai Ruma Maea ana God 'anai re'iai taha nai to'o tanaa Jisas. ");
INSERT INTO aia_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hoita, na'i raronai ruma, 'iraau Na'ohadaa'i Piriisi miraaui haru saemaua narau awa ro'u na'i Kansol rau bonasia do rai sadoia ta mamaani pwari'i 'anai subunia 'inia Jisas marai hiiri ha'amaesia 'inia. ");
INSERT INTO aia_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","'A rago i sae ra ura ara'a mara haa'i mamaani pwari'i 'ana Jisas. Ma rei'uaa na o'asi, rau ai'a sadoia ta maho 'anai ha'ahunia 'inia. 'Ari wou ma 'e rua sae ro'u nararugu boi ");
INSERT INTO aia_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","mararu o'ani, “'Ia mo'oni 'a 'unua do 'ai kaiai Ruma Maea ana God ma 'ai matai ha'a-urasia aho'i ro'u moi na'i raronai oru dangi.” ");
INSERT INTO aia_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","'I Na'ohadaaui Piriisi 'a ura ara'a ma o'ani 'inia Jisas, “'A 'ua? 'O bwa'i haua ta heiarami 'ini'i mareho ra ha'ahuni'o 'ini'isi?” ");
INSERT INTO aia_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mia Jisas 'a ai'a aramia. Mana Na'ohadaaui Piriisi 'a o'ani ro'u, “'Oi tohe na'i atana God tahitahi ma'oi ha'arangasia tana'ameu, i'oe naasi Ha'atahi, i garena God?” ");
INSERT INTO aia_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mia Jisas 'a o'ani, “'A 'onaai 'unua amuasi. Mawai 'unua tana'amou. Na'i 'oha nai boi mau, moi re'iaui Garei Inoni, wai heinagu na'i dora ororiu na'i aba odona God huunai mena. Wai aho'i mai hungadi rorodo na'i aro.” ");
INSERT INTO aia_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","'Oha naagu rongo o'asi Na'ohadaaui Piriisi, 'a karia haaria i to'oni tewa ana 'anai ha'ata'iniai 'ado'adona doni mareho na haua Jisas 'a ta'aa di'u. Ma o'ani, “'Iia 'a ha'atee ha'ata'aia God! Gaugu bwa'i sibania'a ro'u ta sae 'anai ha'ahunia 'inia ta maho ro'u. Naia mou rongoa'a haarimoousi, 'a ha'atee ha'ata'aia God! ");
INSERT INTO aia_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Naasi 'e taha namou 'adoma'inia?” Miraau o'ani, “'A arari 'anai mae.” ");
INSERT INTO aia_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Naasi raugu ngisuhiai bwauna marau hidaria ma tara'i nei ra rubu'ia 'ini'i rimadaa'i. ");
INSERT INTO aia_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Rau o'ani, “'Onaa i'oe naasi Ha'atahi, ma 'oi 'unua 'ia tei na ngahui'o. 'Inia i'oe 'e rarabea, nita?” ");
INSERT INTO aia_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na'i mau 'oha ra hiiria Jisas, 'ia Pita 'a heinagu na'i dora a'ora na'i maanai ruma anai Na'ohadaaui Piriisi. Ma'e gere urao na tau'aro na'i rumasi 'a boi ma o'ani 'inia, “I'oe ro'u 'o awa beia Jisas, 'i ai Galilisi.” ");
INSERT INTO aia_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mia Pita 'a tohe na'i maadaau hako, 'a o'ani, “'Inau ai'a 'iraraai taha na'o 'unuasi.” ");
INSERT INTO aia_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ma hura'a na heinagu na'i maanai bara. Mana nata gere urao ro'u 'a boi ma o'ani 'iniraaui sae narau awa na'i 'isi, “'Ia mo'oni 'a awa ro'u beia Jisas ni Nasaret.” ");
INSERT INTO aia_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mia Pita 'a tohe ro'u o'ani, “Ha'amomori ara'ai aro, 'inau ai'a 'iraraa mo'osi.” ");
INSERT INTO aia_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","'A ai'a orea miraaui sae rau ura na'isi rau boi marau o'ani 'inia Pita, “Ha'amori, i'oe 'e ta'i ro'u 'iniraau. Meu rongo 'iraraai hadahadangamu do i'oe 'e sae ni Galili.” ");
INSERT INTO aia_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mia o'ani, “Ha'amori beia God, 'inau ai'a 'iraraa mo'osi. 'Onaa wai pwari'i 'ia God 'ai ha'a-mama'aiau.” Na'i mau madoraasi mana kua 'a tataraoke'a. ");
INSERT INTO aia_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mia Pita 'agu 'adoma'i aho'isiai taha na 'unua Jisas. Na o'ani, “I kua 'a bwa'i tataraoke mau mi'oe 'oi bwane tohe ha'a-oru do'o ai'a 'iraraau.” Maagu hura'a na'i maanai bara 'anai rumasi ma ru'uhiai angi. ");
INSERT INTO aia_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na'i mau haho'oa ta'aa, 'iraau Na'ohadaa'i Piriisi miraaui saemaua adaa'i Jiu rau ruru goni aho'i 'anai ha'aradorado 'iniai mamaani he'ua narai haua tanaai Primia neina 'ai mwa'emwa'e 'anai ha'amaesia tanaraau a Jisas. 'Oha narau mamaani hako ");
INSERT INTO aia_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","rau ho'osi'i rimana marau waia 'ari tanaa Paelat. 'Iia naasi ai Rom na Primia na'i 'ohasi. ");
INSERT INTO aia_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","'Oha na'ia Jiudas, mo'o ma ha'awatea Jisas tanaraaui maerongana'i, 'a rongoa do rau hiiria Jisas 'anai mae, 'a ahutotou di'u. Ma 'ari ma ha'a-aho'isia aho'i oru tangahurui korai silva ani tanaraaui Na'ohadaa'i Piriisi miraaui saemaua adaa'i Jiu. ");
INSERT INTO aia_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","'A o'ani, “'Ia mo'o nau usuha'inia tana'amou ani, 'a ai'a haua ta maho taritari'a. Mareho nau haua ani, naasi na taritari'a na'i maana God.” Miraau o'ani 'inia, “'I'ameu 'a ai'a ta'aabemeeu 'iniai mareho na'o 'unuasi. Aba amua na.” ");
INSERT INTO aia_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mia Jiudas 'a rasaha'ini'i moi wou ha'a na'i Ruma Maea ana God ma hura'a na 'ari ri'o haaria. ");
INSERT INTO aia_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","'Iraaui Na'ohadaa'i Piriisi rau si'ohi'i ha'a 'isi marau o'ani, “Ha'ani 'a ai'a arari dorai nugaa goni beiai ha'a anai Ruma Maea, 'inia 'e ha'a ra horia 'anai ha'amaesiai sae. 'Onaa gai nugaa goni beiai ha'a anai Ruma Maea magai horosiai ringe.” ");
INSERT INTO aia_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Rau hadanga'inia wou maraugu 'adoma'i aratara 'anai hauai ha'asi 'anai horiai dorai ano baaniai sae na tatagora rabo'o 'iniai mwago. Mana anosi rai haua 'inia ta hera nadaaui sae boboi. ");
INSERT INTO aia_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tari dangini, anosi ra 'unua mau 'iniai ano ni 'abu. ");
INSERT INTO aia_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ma to'o'a i taha na 'unua Rarabea Jeremaea na'i 'oha bwani na o'ani, “'Iraaui saeni Israel rau dauai oru tangahurui korai silva. Naasi horihori nara nugaa 'anai ta'i sae. ");
INSERT INTO aia_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mana ha'asi rau horia 'iniai dorai ano baaniai sae tatagora rabo'o, 'onaai 'unua ana Araha God tanaau.” ");
INSERT INTO aia_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hoita, 'ia Jisas 'a ura na'i maanai Primia, 'ia Paelat, mia Paelat 'a songa'inia o'ani, “'A 'ua? I'oe naasi mwaeraha adaaui Jiu?” Mia Jisas 'a aramia o'ani, “Naia na'o 'unuasi.” ");
INSERT INTO aia_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","'Iraaui Na'ohadaa'i Piriisi miraaui saemaua rau taraawa'ai subunia Jisas, mia Jisas 'a ai'a 'unua ta maho. ");
INSERT INTO aia_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mia Paelat 'a o'ani 'inia, “'A 'ua? 'O rongo'i mwani maho rau ha'ahuni'o 'ini'isi?” ");
INSERT INTO aia_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mia Jisas 'a ai'a haua ta ta'i heiarami. 'Ia Paelat 'a heimwaota'i 'iniai haua o'asi ana Jisas. ");
INSERT INTO aia_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","'Ado harisi, 'oha 'iraaui Jiu rai ha'ato'oai rongo 'anai 'adoma'i aho'isiai Roho Aharau, 'ia Paelat 'a matai ha'awatea tanaraau ta ta'i nei 'iniraaui sae na'i rumaniho'o narau rabasia 'anai ha'ahura'ahia baaniai rumaniho'o. ");
INSERT INTO aia_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mana'i 'ohasi, 'e sae na atana 'ia Barabas 'a awa ro'u na'i rumaniho'o na 'iraaui sae rau 'iraraa goro. ");
INSERT INTO aia_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Na'i 'oha 'iraau sae rago rau ruru wou na'i maanai ruma ana Paelat, 'a songa'iniraau o'ani, “'Iatei namou 'irisia dowai ruhasia tana'amou mai hano dadara'a? 'Ia Barabas ma'ua Jisas ra 'unua 'iniai Ha'atahi?” ");
INSERT INTO aia_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","'Ia Paelat 'a ha'atee o'asi suria 'a bwane 'iraraa do 'iraaui saemaua adaa'i Jiu rau waia maia Jisas suria rau kakawa 'omesia 'iniai rago anai sae nara ta'ahia. ");
INSERT INTO aia_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na'i 'oha 'ia Paelat 'a heinagu mau na'i dorani hihiiri 'anai hiiria Jisas, mana urao ana 'a ha'ataari hadahada'a mai. 'A o'ani, “'Oi abu haua ta here tanaai sae odoodosi. 'Inia nabongi 'au mauru'aa i mareho 'abaia nau arunga ta'aa di'u 'inia.” ");
INSERT INTO aia_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Miraaui Na'ohadaa'i Piriisi beiraaui saemaua adaa'i Jiu rau bonasiraaui sae rago. Miraau 'adoma'i aratara beiraau dorai ha'abonga'inia Paelat mai ruhasia Barabas tanaraau mai ha'amaesia Jisas. ");
INSERT INTO aia_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mia Paelat 'a songa'iniraau o'ani, “'Iatei 'inirarua i rua mwaneni namou 'irisia dowai ruhasia tana'amou?” Miraau awara o'ani, “'Ia Barabas!” ");
INSERT INTO aia_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mia Paelat 'a o'ani ro'u, “'Onaa wai ruhasia Barabas tana'amou, ma wai ha'ahe'uaa Jisas nara 'unua 'iniai Ha'atahi?” Miraau awara o'ani, “Rabua na'i dadaahoro!” ");
INSERT INTO aia_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mia Paelat 'a o'ani, “'Ini 'uaana? 'E 'ino he'ua na haua?” Miraau awara raha ro'u o'ani, “Rabu ahita'inia na'i dadaahoro!” ");
INSERT INTO aia_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Na'i 'ohasi 'ia Paelat 'a 'omesia do 'ai bwarai ha'a-auruhi'i 'ado'adodaa'i ma 'omesia do 'a ga'i bwa'i orea mai to'o'a i ha'agogoru. Naasi ma 'unua dorai waa mai rabo'oi wai ma dorima na'i maadaau. 'A o'ani, “I mae nai haua mo'oni, 'a auru na'i hungamoou. 'Inau 'au dadara'a.” ");
INSERT INTO aia_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Miraau o'ani, “'A goro moi. Nugaa mai auru na'i hungameeu mana'i hungadi pwira amee'i.” ");
INSERT INTO aia_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mia Paelat 'a ruhasia Barabas, ma 'unua tanaraaui sae hehei'oi ana'i dorai rohoa Jisas 'iniai hasiwaro baabau marai waia hura'a 'anai rabua na'i dadaahoro. ");
INSERT INTO aia_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","'Iraaui sae hehei'oi ana'ia Paelat rau waia Jisas siri na'i kae ruma ana Paelat. Miraaui mwani sae hehei'oi hako na'i ruruha adaau rau goni wou beiraau marau ura garigaria Jisas. ");
INSERT INTO aia_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Rau rahi'i bwana ana'i marau ha'ato'onia 'onaai mwaeraha 'iniai to'oni tewa wangawanga. ");
INSERT INTO aia_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Rau tagoraai hihiiri bwau waroraraki marau nugaa na'i bwauna. Rau ha'adaua 'iniai 'a'abi ni mwaeraha na'i rima odona. Rau topira'i ruru tanaa, rau ha'ada'ada'a 'inia marau o'ani, “Ha'aasaai mwaeraha adaaui Jiu.” ");
INSERT INTO aia_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Rau ngisuhia marau rahiai 'a'abi baania marau ruburubuai bwauna 'inia. ");
INSERT INTO aia_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Na'i 'oha rau ha'ada'ada'a hako 'inia rau rahia aho'i to'oni wangawanga narau ha'ato'onia 'inia marau ha'ato'onia aho'i 'iniai to'oni ana maraugu waia 'ari 'anai rabua na'i dadaahoro. ");
INSERT INTO aia_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na'i 'oha 'iraau hehei'oi rau waia Jisas hura'a, rau 'ariwou marau heisadoi beiai sae ni Saerin na atana 'ia Saemon. Miraaui sae hehei'oi rau ha'a-'usu'usua do 'ai suru'iai dadaahoro ana Jisas. ");
INSERT INTO aia_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Rau 'ariwou ro'u marau ada na'i dora ra 'unua 'iniai Golgota. 'Ado'ado 'ana naasi “Dora ni Korai Bwau Sae.” ");
INSERT INTO aia_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mara haua tanaa Jisas i waen ra doraria 'iniai maho mahai. 'Oha na gono maania 'a 'ageta'i gonohia. ");
INSERT INTO aia_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","'Iraau sae hehei'oi rau rabua'a Jisas na'i dadaahoro. Na'i muri, rau gaasi ha'ara 'anai sadoia tei nai to'ora'i to'oni ana'i. ");
INSERT INTO aia_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na'i muri rau heinagu marau boresuria Jisas, ra gasi 'a'auhia tara'i sae. ");
INSERT INTO aia_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Marau usuai usu-usu na'i baba marau rabua na'i bwaunai dadaahoro 'anai ha'ata'iniai taha na ta'aa narau 'adoma'inia do 'a haua. Rau usua o'ani, ");
INSERT INTO aia_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mara rabua ro'u i rua sae beriberi beia Jisas. 'E ta'i na'i aba odo mana nata nei na'i aba maha. ");
INSERT INTO aia_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Miraaui sae ra taha horo 'isi rau ha'atee ha'ata'aia Jisas. Rau arabwau 'ini ha'atotooa. ");
INSERT INTO aia_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Rau o'ani, “Mmm naasi, i'oe na'o 'unua ani do'oi kaiai Ruma Maea ana God ma'oi matai ha'a-urasia aho'i ro'u moi na'i raronai oru dangi? 'Onaa i'oe garena God ha'a-momori, 'oi ha'atahi'o haari'o ma'oi dio mai baaniai dadaahoro.” ");
INSERT INTO aia_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","'Iraau Na'ohadaa'i Piriisi mana Ha'ausuri 'anai Ringe ana'ia Moses miraau tara'i saemaua ro'u rau ha'ada'ada'a ro'u 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Rau o'ani, “'Ome, sae he'ete'i 'a matai ha'atahi'i ma bwa'i ha'atahia haaria. 'A 'ua? 'Iia naasi mwaeraha adaau Israel? 'Onaa 'ai dio baaniai dadaahoro, naasi gai hinihinia. ");
INSERT INTO aia_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","'A 'unua tarau do'a 'u'uria God ma 'unua do 'iia 'e Garena. Naasi, 'onaa 'ia God 'a 'adoma'inia magai re'ia God 'ai ha'atahia na'i 'ohani.” ");
INSERT INTO aia_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mana rua sae beriberi nara rabua beia Jisas raru ha'atee ha'ata'aia ro'u o'asi. ");
INSERT INTO aia_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ma na'i angi ta'i tangahuru mana rua na'i dangisi, 'a kuhi bwarasiai kantri hako tari na'i angi oru. ");
INSERT INTO aia_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mana'i angi oru abaidangi 'ia Jisas 'a totoro o'ani, “'Elai, 'Elai, lama sabaktani.” 'Ado'ado 'ana, “God agua, God agua, 'ini 'uaana na'o gagata'iniau 'inia?” ");
INSERT INTO aia_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tara'i sae narau ura gaarangi rau rongoai awara o'asi ana marau o'ani, “'Ei, 'a kukua Elaija.” ");
INSERT INTO aia_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'E ta'i abe 'iniraau na 'eba wou ma rahiai mareho na matai omi'i wai. 'A ha'abunia 'iniai waen mahai ma nugaa na'i hasi'ei ma taranga'inia ara'a na'i ngoona Jisas do 'ai gono. ");
INSERT INTO aia_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma tara'i sae rau o'ani, “Gai 'ome'ome ga'u magai re'ia 'onaa 'ia Elaija 'ai boi 'anai ha'atahia.” ");
INSERT INTO aia_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mia Jisas 'a totoro raha ro'u maagu nuga manawa. ");
INSERT INTO aia_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mana bwana ubu-ubu'a ra rohe bwarasia 'iniai dora maea na'i Ruma Maea ana God, 'a maakari heihoa taraawa'a bo ta'eha ma dio. Mana nunu 'a 'ihara'iniai ano. I hau ra makasa ");
INSERT INTO aia_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mana wabwa suri'i hera ra wawaa'a. Ragoi sae nara odo-odo na'i maana God nara bwani mae ra suruta'e aho'i. ");
INSERT INTO aia_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","'Oha na suruta'e a Jisas baaniai mae, rau hura'a baani'i hera marau 'ari na'i 'omaa maea i Jerusalem. 'A rago i sae narau re'iraau. ");
INSERT INTO aia_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hoita, na na'otara adaaui hehei'oi mana sae hehei'oi narau 'omesuriai abena Jisas, rau mamaa'u di'u 'oha rau arunganai nunu raha marau re'i'i mwani mareho nara to'o 'isi. Rau o'ani, “Ha'amomori. 'Ia mo'oni huunai garena God.” ");
INSERT INTO aia_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","'A ragoi urao narau ta'i boi a Jisas baaniai Galili narau 'a'auhia na'i 'aariha na haasi. 'Iraausi rau gere ura ha'atau moi maraugu wanawana 'ari 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tara'i nei 'iniraau naasia Meri ni Magdala, Meri inana Jems mia Josep, mana inana Jems mia Jon, gare ana'ia Sebedi. ");
INSERT INTO aia_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","'E sae toto'ora ni 'Arimatea na awa na'i Jerusalem, atana 'ia Josep. 'Iia 'e ta'i sae na suria ro'u a Jisas. Na'i 'oha na gaarangi suu'a i sina ");
INSERT INTO aia_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","'a 'ari beia Paelat ma ha'angoniai abena Jisas. 'Ia Paelat 'a ha'awatea dorai rahia dio i abena Jisas tanaa Josep. ");
INSERT INTO aia_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mia Josep 'a 'ari ma hauai abena. 'A ho'ua 'iniai bwana mamaahui haoru ");
INSERT INTO aia_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ma aoraa na'i wabwa ana haaria nara 'eria na'i abenai kae hau. Ai'a ta sae ga'u narai toringia na'i wabwasi. Ma hugesiai kae hau 'anai honosiai maanai wabwa ma hano'a. ");
INSERT INTO aia_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","'Ia Meri ni Magdala mia nata Meri raru heinagu gaarangiai maanai wabwa na'i 'ohasi. ");
INSERT INTO aia_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Dangi ahora naasi dangi ni mamaro adaaui Jiu. 'Iraau Na'ohadaa'i Piriisi miraau Ha'ausuri 'anai Ringe ana'ia Moses rau 'ari beia Paelat ");
INSERT INTO aia_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","marau o'ani, “Saemaua, meu 'adoma'i aho'isiai mareho na 'unua i sae pwapwaari'isi. Na'i 'oha na tahi mau 'a 'unua do 'e rua dangi nai hako mana'i oruna 'ai tahi aho'i. ");
INSERT INTO aia_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Naasi meu rabasia do'oi 'unua tanaraaui sae hehei'oi amu'i marai 'omesuri na'i wabwa tari oru dangi. 'Iraaui rongoiusuri ana'i rau gasi beriai abena maraigu pwari'iraaui noni do 'a tahi aho'i. 'Onaa rai haua o'asi, mai ta'aa di'u baaniai pwari'i na haua ga'u na'i na'o.” ");
INSERT INTO aia_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mia Paelat 'a o'ani 'iniraau, “Moi waa'i tara'i sae hehei'oi agu'i mamoi 'ari 'omesuri na'i wabwa suriai here namou 'adoma'inia do 'a ga'i goro.” ");
INSERT INTO aia_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Marau 'ari narau pono ha'ababauai maanai wabwa marau nuga'i sae hehei'oi 'anai 'omesuria. Marau nugaai maho na'iei 'anai 'iraraa do 'onaa ta sae nai raba tahangia. ");
INSERT INTO aia_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Murinai dangi ni mamaro, na'i wa'aria i dangi sade, 'ia Meri ni Magdala mia nata Meri, raru 'ari 'anai 'omesiai wabwa. ");
INSERT INTO aia_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Rarugu 'asu'a ma to'o'a i kae nunu raha, 'inia 'e enjel ana Araha God 'a dio mai baaniai aro ma hugesiai hau baaniai maanai wabwa ma heinagu na'i hungana. ");
INSERT INTO aia_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ni hauraena tari auru na'i 'u'una 'a wadora'i 'onaai mararea mana bwana ana 'a mamaahui di'u 'onaai tagai 'abe. ");
INSERT INTO aia_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","'Iraau sae hehei'oi narau 'omesuri na'i wabwa rau mamaa'u marau 'idi'idi marau dionga'i narau dadao 'onaai sae na mae. ");
INSERT INTO aia_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mana enjel 'a o'ani 'inirarua rua urao, “Murui abu mamaa'u. 'Au 'iraraa muru boi siba 'inia Jisas nara rabua na'i dadaahoro. ");
INSERT INTO aia_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","'Iia 'a ai'a awa 'ini, 'a bwani suruta'e aho'i 'onaai 'unua ana mau na'i na'o. Murui boi mamurui re'iai dora na dadao ga'u iei. ");
INSERT INTO aia_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hoita, murui aho'i raurau mamurui maania tanaraaui rongoiusuri ana'i o'ani, ‘'Ia Jisas 'a tahi'a aho'i. 'Iia 'ai na'o 'ari Galili 'ini'amou. Na'i 'isi namoigu sadoia na'iei.’ Naasi maho nau boi 'inia 'anai 'unua tana'amurua.” ");
INSERT INTO aia_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mararu 'eba aho'i raurau ha'i mamaa'u. Ma'ata raru wa'ewa'e di'u ro'u. Raru 'eba 'ari 'anai maaniai tarohasi tanaraaui rongoiusuri. ");
INSERT INTO aia_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Rarugu 'asu'a mararu heito'oi beia Jisas mia o'ani 'inirarua, “Maia.” Raru 'ari wou mararu topira'i ruru auru mararu dau na'i uwana mararu ha'arahesia. ");
INSERT INTO aia_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mia Jisas 'a o'ani, “Murui abu mamaa'u. Murui 'ari mamurui maania tanaraaui do'oragu'i, rai 'ari Galili. Na'i 'isi naraigu sadoiau na'iei.” ");
INSERT INTO aia_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na'i 'oha na rua uraosi raru 'ari 'anai 'omaa, tara'i nei 'iniraaui sae hehei'oi narau 'omesuri na'i wabwa rau 'ari beiraaui Na'ohadaa'i Piriisi marau maania tanaraau i taha na to'o. ");
INSERT INTO aia_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Miraau Na'ohadaa'i Piriisi ma tara'i saemaua ro'u, rau rurugoni. Rau 'adoma'i aratara 'anai ha'a-karekareraaui sae hehei'oi narau 'omesuriai wabwa 'iniai kae ha'a. ");
INSERT INTO aia_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Rau 'unuraau mai sae hehei'oi 'isi 'anai horiraau marau o'ani, “Moi ha'arangasia do 'iraau rongoiusuri ana'ia Jisas rau boi waa i abena na'i rodo 'oha mou mauru. ");
INSERT INTO aia_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","'Ai abui ta'aabemoou. 'Onaa 'ia Paelat 'ai rongoa domou mauru na'i 'ohasi, 'i'ameu nameigu mamaani ha'a-odoodoa tanaa neina bwa'i taesu'a momoou.” ");
INSERT INTO aia_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Miraaui sae hehei'oi rau daa i ha'a marau 'ari narau maaniai mamaanisi 'onaai 'unua ada tanaraau. I mamaanisi 'a 'adarara 'ari beiraaui Jiu. Tari dangini ra mamaania mau. ");
INSERT INTO aia_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","'Iraaui ta'i tangahuru mana ta'i rongoiusuri rau hano 'anai Galili. Rau 'ari na'i hungahunga na 'ia Jisas 'a 'unua dorai 'ari na'iei. ");
INSERT INTO aia_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na'i 'oha rau re'ia Jisas, rau ha'arahesia. Ma'ata tara'i nei 'iniraau rau ai'a taraa hinihini do 'ia Jisas naasi. ");
INSERT INTO aia_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mia Jisas 'a boi beiraau ma o'ani, “'Ia God 'a 'unua do 'inau wai marungi'i mwani mareho hako na'i aro mana ano. ");
INSERT INTO aia_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Naasi moi hura'a suria hako i marewana mamoi taroha'iniau tanaraaui sae marai ha'i rongoiusuri agu'i. Moi bwareomaearaau na'i atana Ama mana Gare mana Hi'ona Maea. ");
INSERT INTO aia_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Moi ha'ausuriraau marai araisuri'i hako i Ha'atora nau haa'i tana'amou. Mamoi 'iraraa do 'inau wai awa tarau bei'amou tari 'oha nai hakoi marewana.” ");
INSERT INTO aia_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Naani Taroha Goro 'inia Jisas Kraest, Garena God. ");
INSERT INTO aia_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Na'i buka ana Rarabea Aisaea, 'ia God 'a o'ani, “'Inau wai ha'ataariai sae heitaroha'i agua na'i na'o 'ini'o, 'iia nai ha'aagauraaui noni 'anai boi amua. ");
INSERT INTO aia_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","'Ai totoro hura'a na'i dora mangasara. 'Ai ha'atee o'ani, ‘Moi ha'aagau! 'Ia Araha 'a gaarangi boi'a. Moi ha'a-odoodoai tara tanaa.’” ");
INSERT INTO aia_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Hoita, 'ia Jon Bwareomaea naasi sae heitaroha'isi. 'A boi ma awa na'i dora mangasara. Bwana ana ra tau'arona 'iniai warihui kamel mana rorowa'a ana, 'e uri-uri mwamwaa. Na mahoingau ana, naasi ngabo mana modi'o ni hasimou. 'A bwareomaearai sae ma 'unua tanaraau o'ani, “Moi rihosi baani'i mwani baronga ta'a'i amoo'i mamoi bwareomaea, mia God 'ai 'adoma'i nugasi'i 'inomoo'i.” Ma na'i 'ohasi, ragoi sae na'i Jerusalem mana tara'i 'omaa na'i Provensi Jiudea nara boi 'anai bahurongoa Jon. Marau ha'arangasi'i ora-ora'a-daa'i ma bwareomaearaau na'i wai Jodan. ");
INSERT INTO aia_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma naani maho na maania tanaraaui sae, “Na nei nai boi na'i murigu, 'a ororiu di'uau. 'Inau ai'a arari 'anai mwaoro auru 'anai wagasi'i sandol ana'i. ");
INSERT INTO aia_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","'Inau 'au bwareomaea'amou 'inia moi wai, me 'iia 'ai bwareomaea'amou 'iniai Hi'ona Maea.” ");
INSERT INTO aia_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na'i muri 'ia Jisas 'a hano baaniai Nasaret, 'e 'omaa ni Provensi Galili, ma 'ari na 'ia Jon 'agu bwareomaeaa Jisas na'i wai Jodan. ");
INSERT INTO aia_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma na'i 'oha 'ia Jisas 'a ara'a baaniai wai, 'a 'omesiai aro 'a heihoa mana Hi'ona Maea 'a dio na'i hungana 'onaai waibora. ");
INSERT INTO aia_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mana aohanai ringe na ao dio mai baaniai aro 'a o'ani, “I'oe na garegu nau ta'ahi'o ororiu, mau ahugoro 'ini'o.” ");
INSERT INTO aia_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na'i mau 'ohasi, mana Hi'ona Maea 'a ha'ataaria Jisas 'ari na'i dora mangasara. ");
INSERT INTO aia_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma na'i ro'u 'isi, 'iraaui mwamwaa wasi rau awa na'iei. 'A awa 'isi suriai hai tangahurui dangi, mia Saetan 'a ohongia iei a Jisas. 'Iraaui enjel rau boi marau taguma'inia. ");
INSERT INTO aia_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","'Ia Jisas 'a 'ari na'i Provensi Galili na'i 'oha 'ia Herod 'a bwane nugaa'a Jon Bwareomaea na'i rumaniho'o. 'A 'ari 'anai taroha'iniai Taroha Goro na boi baania God. ");
INSERT INTO aia_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","'A ha'atee o'ani, “Na heimarungi ana God 'a gaarangi'a. Moi rihosi baani'i ora-ora'a amoo'i mamoi hinihiniai Taroha Goro!” ");
INSERT INTO aia_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ma na'i 'oha 'ia Jisas 'a hatare na'i one i Galili, 'a re'ia Saemon mana do'orana 'ia Andru. Na'i 'ohasi, raru ahuasi 'iniai hu'o, 'inia 'iraruasi ra'i sae ahu-ahuasi. ");
INSERT INTO aia_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mia Jisas 'a o'ani 'ini'ararua, “Murui suriau! 'Onaai rau'i amuru'i ii'a na'i wai, 'a o'asi ro'u, wai ha'ausuri'amurua 'anai wairaau mai sae beiau.” ");
INSERT INTO aia_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na'i mau 'ohasi, raru nugasi'i hu'o adaru'i ma raru suria. ");
INSERT INTO aia_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma gere 'ari ro'u wou baaniai dorasi ma re'irarua Jems mea Jon, rua garena Sebedi. Raru awa na'i ora adaau, rau orima'ini'i hu'o adaa'i. ");
INSERT INTO aia_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma na'i 'oha 'ia Jisas 'a re'irarua, 'a soirarua. Me'irarua raru hano baania amadarua miraaui sae tatau'aro narau awa na'i ora. Ma raru hano beia Jisas. ");
INSERT INTO aia_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mia Jisas mana rongoiusuri ana'i rau taha na'i 'omaai Kapaniam. Ma na'i dangi ni mamaro adaaui Jiu, 'ia Jisas 'a siri na'i ruma ni ha'arahesi ma ha'ausuriraaui sae. ");
INSERT INTO aia_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Miraaui nei narau rongo'i mareho na maani'i rau heimwaota'i di'u 'ini'i ha'ausuringa'i ana'i, 'inia rau 'iraraa do 'a aidangisi'i goro i mareho na maani'i. 'Iia 'a ai'a 'onaairaaui Ha'ausuri 'anai Ringe ana'ia Moses. ");
INSERT INTO aia_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma na'i 'ohasi 'e sae na adaro 'a bwaunia 'a awara raha o'ani, ");
INSERT INTO aia_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas, saeni Nasaret, 'o raba 'uaameuni? 'O boi 'anai ha'a-ta'ai'ameu? 'Inau 'au 'iraraa ha'agorohi'o! I'oe nei na maea na'o boi baania God.” ");
INSERT INTO aia_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mia Jisas 'a ha'atee hurasi o'ani, “'Oi papaku, ma'oi hura'a mai baania mo'osi!” ");
INSERT INTO aia_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mana adarosi 'a 'ihara'iniai saesi ma awara raha ro'u maagu hura'a baania. ");
INSERT INTO aia_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Miraau mwane sae rau heimwaota'i ro'u marau ha'atee hairiu o'ani, “Romwane! 'E tahasi? 'E ha'ausuringa'i haoru naasi, 'inia na ha'atee ana'i ra wetewete 'onaai sae na to'o mena! Rei'uaa adaro ma ra araisuria ro'u.” ");
INSERT INTO aia_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mana taroha 'inia Jisas 'a 'adarara 'ari suri'i 'omaa hako na'i Galili. ");
INSERT INTO aia_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ma na'i 'ohasi 'ia Jisas beia Jems mea Jon, rau hano baaniai ruma ni ha'arahesi marau 'ari na'i ruma ana Saemon mea Andru. ");
INSERT INTO aia_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ma na'i 'oha rau siri wou i ruma, 'ia Jisas 'a rongoa do na hungona Saemon 'a awa moi na'i be'ana, 'inia 'a mata'i ma raorao i abena. ");
INSERT INTO aia_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mia Jisas 'a 'ari wou beia, 'a dau na'i rimana ma ha'a-suruta'ea ara'a. Na'i 'ohasi mana mata'i 'a rigisia'a. Naasi mana uraosi 'a ha'aagau mahoingau 'adaau. ");
INSERT INTO aia_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mana'i su'urahisi 'oha na sina 'a bura'i suu, mana dangi ni mamaro 'a hako'a, ra waa'i mai inoni nara daoha tanaa Jisas mana nei na ra bwaunira i adaro. ");
INSERT INTO aia_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Miraau hakoi inoni na'i 'omaasi narau rurugoni mai na'i rumasi. ");
INSERT INTO aia_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mia Jisas 'a ha'agorohi'i mwane daoha he'ete'i hairiu, ma taari'i hura'ai mwane adaro baani'i sae. Ma'ata 'a ai'a waterai adaro do rai 'unua hura'a do 'iia naasi garena God, 'inia 'a ai'a rabasia do rai taroha'inia tanaraaui inoni. ");
INSERT INTO aia_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ma na'i mau i wa'aria, 'ia Jisas 'a rarai mai ma 'ari dora 'etea 'anai ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma na'i 'oha na rarai a Saemon miraaui nei narau ta'i awa, maraugu ai'a re'ia'a Jisas, raugu sibania. ");
INSERT INTO aia_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma na'i 'oha rau sadoia, rau o'ani 'inia, “'Iraau hakoi sae rau sibani'o!” ");
INSERT INTO aia_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mia Jisas 'a ha'atee tanaraau o'ani, “'Au 'iraraa. Ma'ata 'au raba taroha'iniai Taroha Goro tanaraaui sae suri'i ro'u i 'omaa 'isi. 'Inia naasi taranai taha nau boi 'inia.” ");
INSERT INTO aia_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mia Jisas 'a 'ari suri'i ruma ni ha'arahesi suri'i mwani 'omaa na'i Galili ma taroha'iniai Taroha Goro ma taari'i hura'ai adaro baaniraaui sae. ");
INSERT INTO aia_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Hoita, 'e sae lepa 'a boi ma topira'i ruru dio tanaa Jisas ma ha'angonia o'ani, “'Onaa 'o mwa'emwa'e, ma'o ga'i ha'agorohiau baaniai daoha na to'iauni.” ");
INSERT INTO aia_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","'Ia Jisas 'a ta'ahia. 'A taranga'inia hura'ai rimana, 'a dau wou beia ma o'ani, “'Io, 'au mwa'emwa'e moi, 'oi goro'a aho'i!” ");
INSERT INTO aia_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na'i mau 'ohasi mana abena 'agu goro aho'i. ");
INSERT INTO aia_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Na'i 'ohasi 'ia Jisas 'a ha'aabua wetewete a mo'osi, 'a o'ani 'inia, “'Oi abu maania ga'u tanaa ta sae i maho na to'o bei'o. 'Oi 'ari odo-odo beiai Piriisi mai 'iraraa haaria do i'oe 'o goro aho'i. Naasi ma'oi hauai bane amua tanaai Piriisi mai ho'asi 'inia 'onaai 'unua ana Moses, 'anai ha'ata'inia tanaraaui noni do'o goro'a.” Na'i 'ohasi 'ia Jisas 'a ha'ataaria 'ari. ");
INSERT INTO aia_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mia mo'osi 'a ai'a araisuria Jisas ma taroha'inia moe'a 'ari tanarai mwani sae, tarana naia na 'ia Jisas 'a ai'a 'ari ha'ata'i 'inia suri'i 'omaa. Ma awa moi hura'a suri'i dora na ai'a ta sae nai awa iei. Rei'uaa na o'asi, sae suri'i 'omaa rago rau sadoia marau rurugoni mai beia. ");
INSERT INTO aia_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ma hako i taringai dangi, 'ia Jisas 'a aho'i 'ari na'i Kapaniam. Miraaui inoni rau 'iraraa do'a awa na'i ruma na bwani awa-awa iei ga'u ani. ");
INSERT INTO aia_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ma ragoi nei ra boi beia Jisas ma ai'a dora taradaau na'i ruma ma'ua na'i abau 'omaa. Mia Jisas 'a ha-ha'ausuri 'ini'i ha'atee ana'ia God. ");
INSERT INTO aia_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma'e waira hai rau suru'ia mai sae na nugui abena mana saesi 'a dadao na'i be'ana. ");
INSERT INTO aia_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Me 'iniai rago di'u anai sae, 'a bwara tanaraaui suru'ia siri saesi tanaa Jisas. Naasi marau suru'ia ta'eha suriai tara hanehane 'anai ta'eha na'i hunganai rumasi. Na hunganai rumasi 'a sada moi. 'Oha narau taha ta'eha, rau tahangiai dora na'i goroi odohana Jisas, marau toto'oa dio a mo'osi na'i 'ubutadaa'i sae nara awa na'i rumasi. ");
INSERT INTO aia_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mia Jisas 'a 'ome 'iraraai hinihinidaau magu ha'atee o'ani 'inia mo'o narau toto'oa diosi, “Gare agua, na ora-ora'a amu'i 'au 'adoma'i nugasi'i hako.” ");
INSERT INTO aia_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na'i 'ohasi ra'i Ha'ausuri 'anai Ringe ana'ia Moses rau awa ro'u 'isi. Miraau 'ado'ado o'ani, ");
INSERT INTO aia_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ni 'uaana nagu 'unua 'iniai marehosi? 'A ga'i bwa'i o'asi! 'A 'adoma'inia do 'iia naasia God? 'Ia moia God na matai 'adoma'i nugasi'i ora-ora'a! 'Iia 'a ha'atee ha'ata'aia God!” ");
INSERT INTO aia_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","'Ia Jisas 'a 'iraraai 'adoma'idaau ma ha'atee o'ani 'iniraau, “'A 'ua namou to'oraa 'iniai 'adoma'isi bei'amou? ");
INSERT INTO aia_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Taha na mwada'u? 'Anai 'unua tanaai saesi do'au 'adoma'i nugasi'i ora-ora'a ana'i, ma'ua 'anai 'unua tanaa do'ai ura maai suru'iai be'ana maai hahano? 'Anai 'unua tanaa mo'osi do'au 'adoma'i nugasi'i ora-ora'a ana'i 'a mwada'u, 'inia 'a bwarai 'iraraa 'onaa ra 'adoma'i nugasi'i ora-ora'a ana'i ma'ua ai'a. ");
INSERT INTO aia_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Naasi, 'inau i Garei Inoni, wai hauai maho namou 'adoma'i ha'abwaraa mamoigu'i 'iraraa do 'au to'oraa ro'u i mena 'anai 'adoma'i nugasi'i ora-ora'a na'i marewanani.” Naasi magu o'ani 'iniai sae na abe nugusi, ");
INSERT INTO aia_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nau wai 'unua tana'o, 'oi ura ara'a, 'oi suru'iai be'amu, ma'oi 'ari ruma amua!” ");
INSERT INTO aia_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na saesi 'a ura odo-odo ara'a, 'a suru'iai be'ana ma hura'a. Miraaui inoni hako rau wanasia marau heimwaota'i di'u. Rau ha'aasaa God 'inia marau ha'atee o'ani, “'I'ameu meu ai'a 'omesia ga'u ta mareho o'ani!” ");
INSERT INTO aia_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","'E ta'i 'oha ro'u, 'ia Jisas 'a 'ari bobonai kae bwera i Galili. Mana ruruhai sae rago rau rurugoni mai beia magu ha'ausuriraau. ");
INSERT INTO aia_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma na'i 'oha na gere hahano sara wou, 'a re'ia Livae, 'e sae ha-ha'atakisi. 'Iia 'e garena Alfias. 'A heinagu na'i dora-ni-horihori takisi mia Jisas 'a ha'atee o'ani 'inia, “'Oi boi suriau 'onaai rongoiusuri agua!” 'Ia Livae 'a ura ara'a ma suria'a. ");
INSERT INTO aia_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","'Ari wou mia Jisas mana rongoiusuri ana'i rau ngau na'i ruma ana Livae. 'A ragoi sae ha'atakisi ta'aa mana sae ta'aa rau suria Jisas marau ngau beiraau. ");
INSERT INTO aia_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tara'i Ha'ausuri 'anai Ringe ana'ia Moses nara aba beiraaui Farisei rau re'i'i sae 'isi 'oha rau ngau beia Jisas. Marau songa'iniraaui rongoiusuri ana'i o'ani, “Ni 'uaana na ngau 'inia beiraaui sae ha-ha'atakisi miraaui sae ta'a'isi?” ");
INSERT INTO aia_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","'Ia Jisas 'a rongoraau ma aramiraau o'ani, “Na sae nara goro moi abedi ra bwa'i rabasiai 'a'au baaniai sae na matai ha'agorohi'i daoha, me 'iraau moi nei nara daoha nara rabasiai 'a'au. 'A o'asi ro'u, 'inau boi na'i marewanani, ai'a do 'anai 'a'auhiraau inoni odo-odo, ma'ata 'au boi 'anai 'a'auhiraaui inoni ora-ora'a.” ");
INSERT INTO aia_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ma tara'i 'oha na rongoiusuri ana'ia Jon Bwareomaea miraau na Farisei rau ha'ariri 'ini ngau 'anai ha'arahesi. Ma'e ta'i 'oha ra'i sae ra boi beia Jisas 'anai songa'inia, rau ha'atee o'ani, “'Iraaui rongoiusuri ana'ia Jon Bwareomaea miraaui rongoiusuri adaa'i Farisei ra suriai ringe 'ini nuga ngau. Ni 'uaana na 'iraaui rongoiusuri amu'i rau ai'a?” ");
INSERT INTO aia_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mia Jisas 'a aramiraau, 'a ha'atee o'ani, “'A 'ua? 'I'amou mou 'adoma'inia do 'iraaui nei ra awa na'i rongo-ni-ha'iwai rai ha'aririta'i ngau 'oha na awa beiraau a mo'o ra ha'aha'iwaia? 'Abwa'i! 'Oha na nei na ha'iwai 'a awa beiraaui sae 'isi, raugu bwa'i 'asu'ani awa ha'i hioro moi. ");
INSERT INTO aia_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma'ata tari 'oha na nei na ha'iwai rai waia baaniraau, ma raigui matai ha'aririta'i ngau 'iniai ahutotou adaau. ");
INSERT INTO aia_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mana nata maho ro'u, 'a bwa'i nei nai haa ta maakari bwana haoru 'anai tai bwarasiai dora na maakari na'i bwana bwani. 'Onaa nai haua o'asi, na'i 'oha raigui wasiai bwanasi, na maakari bwana haorusi 'ai niniro. Mai haa ta kae maakari nai raha di'u ro'u na'i bwana bwanisi. 'Inia na maakari bwana haoru ai'a ta'isada beiai bwana bwani. ");
INSERT INTO aia_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Nata mareho ro'u, 'abwa'i nei nai matai nuga waen haoru suri'i bei bwani nara tagora'i 'ini'i uri-uri mwamwaa, 'inia na bei bwani ra bwane 'a'asi. Na'i 'oha na waen haoru 'ai su'u, na bei bwani rai pusu. Naasi mana waen rai ahe gata'ini'i, mana bei rai maakari ta'a'i. Na waen haoru rai niga'i ma'ata na'i bei haoru ro'u. 'Inia ni waen haoru ai'a ta'isada beiai bei bwani.” ");
INSERT INTO aia_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ma'e ta'i dangi ni mamaro adaaui Jiu, 'ia Jisas miraaui rongoiusuri ana'i rau tahahoro na'i 'ubutadi mou wiit. Me 'iraaui rongoiusuri raugu rahi'i tara'i kora. ");
INSERT INTO aia_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","'Oha 'iraau na Farisei rau re'iraau, raugu ha'atee o'ani 'inia Jisas, “'Ei! Rau ga'i bwa'i husi'i wiit 'isi. Na Ringe ana'ia Moses 'a ha'aabuai tau'aro na'i dangi ni mamaro!” ");
INSERT INTO aia_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Mia Jisas 'a ha'atee o'ani, “'A 'ua? Mou ai'a 'oha'iniai mamaani 'inia Mwaeraha Deved mana nei rau ta'i hano na'i 'oha narau hioro? 'A to'o na'i madoraa ana 'Abaeata, i Na'ohadaaui Piriisi. 'Ia Deved 'a siri na'i Ruma Maea Saira ana God ma ngaai bredi maea ra haa tanaa God, ma ha'angauraau ro'u 'ini'i sae ana'i. Na'i Ringe ana'ia Moses 'a 'unua do'iraau moi na Piriisi na rau matai ngaai bredisi. 'Omena, 'ia Deved 'a horosia ro'u i ringeringe!” ");
INSERT INTO aia_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mia Jisas 'a 'unua tanaraau o'ani, “Na dangi ni mamaro, 'ia God 'a haua 'anai 'a'auhiraau moi sae, ma ai'a 'anai ha'abwara'i maho tanaraau. ");
INSERT INTO aia_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Me 'inau, na Garei Inoni, 'inau 'au matai 'unu'i maho 'iraaui sae ra matai haa'i na'i dangi ni mamaro. 'Inia 'inau naasi Araha 'anai dangi ni mamaro.” ");
INSERT INTO aia_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","'E ta'i 'oha ro'u, 'ia Jisas 'a siri na'i ruma ni ha'arahesi. Ma'e sae na mae i rimana, 'a awa na'isi. ");
INSERT INTO aia_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Miraau na Farisei rau 'ome'ome 'onaa 'ia Jisas 'ai ha'agorohia aho'i sae na mae i rimanasi, do nei narai subunia do'a hauai tau'aro na'i dangi ni mamaro. ");
INSERT INTO aia_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","'Ia Jisas 'a 'unua tanaai saesi do 'ai ara'a urai na'o. ");
INSERT INTO aia_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma songa'iniraau o'ani, “'A 'ua? 'E taha na Ringe ana'ia Moses 'a ha'awategaau 'anai haua na'i dangi ni mamaro? 'Anai haa'i mareho goro, ma'uasi 'anai haa'i mareho ta'a'i? 'Anai ha'atahiai noni ma'ua 'anai ha'amaesia?” Ai'a ta ta'i 'iniraau nai aramia 'inia ta ta'i ha'atee. ");
INSERT INTO aia_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","'Ia Jisas 'a wanasiraau ma taesu'a di'u 'adaau suria rau ai'a ta'ahiai mwaeta'aasi. Rei'uaa na o'asi, 'a ahutotou ro'u suria na tahingadaau 'a baabau. Ma 'unua tanaai saesi, “'Oi taranga'inia hura'ai rimamu.” Mana 'oha na taranga'inia hura'a, na rimanai saesi 'agu goro aho'i. ");
INSERT INTO aia_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ma na'i 'ohasi 'iraau na Farisei raugu hura'a baaniai ruma ni ha'arahesi, rau 'ari beiraaui sae ana'ia Herod marau 'adoma'i sibasiba 'iniai here he'ua na rai ngahuia 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","'Ia Jisas miraaui rongoiusuri ana'i rau dioi bobonai kae bwera i Galili. 'A ragoi sae ra suriraau baani'i 'omaa na'i Provensi Galili mana Jiudea mana 'Idumea, ");
INSERT INTO aia_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","mana kae 'omaai Jerusalem ma tara'i 'omaa na'i aba bo ara'a 'iniai wai Jodan ma ra'i 'omaa gaarangiai 'omaai Taea mana Saedon. 'Iraau mwani sae 'isi ra boi beia Jisas 'iniai rongo'i adaa'i taha 'iia na haa'i. ");
INSERT INTO aia_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ma 'iniai rago di'u anai sae, 'ia Jisas 'a o'ani 'iniraaui rongoiusuri ana'i, “Moi ha'aagau 'inia ta ora tanaau. 'A gasi 'idi marai ragoi sae maragu haisu'isu'i di'u.” ");
INSERT INTO aia_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","'A ragoi nei ra daoha nara heisu'usu'u 'ari wou beia Jisas 'anai hatariai abena, 'inia ra re'i'i mwani sae na 'ia Jisas 'a bwane ha'agorohi'i'a aho'i. ");
INSERT INTO aia_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma ra'i nei na adaro 'a bwaunira ra boi beia Jisas. Ra topira'i ruru dioi ano tanaa Jisas ma ra awara, “I'oe na garena God!” ");
INSERT INTO aia_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mia Jisas 'a ha'atee wetewete, 'a ha'abasuraaui adaro 'isi ma o'ani, “'Abu ha'a-'irararaaui sae do 'inau atei!” ");
INSERT INTO aia_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mia Jisas 'a ta'eha na'i hungahunga ma 'unuraaui nei na 'irisiraau 'anai tau'aro beia. Mana 'oha rau boi beia, ");
INSERT INTO aia_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","'a sigihiai waira ta'i tangahuru mana rua ma ha'a-atadaau 'iniai Ha'ataari. Mia Jisas 'a ha'atee tanaraau o'ani, “'Au 'ome sigihi'amou 'anai awa beiau ma wai ha'ataari'amou hura'a 'anai hadanga'ini'i ha'atee ana'ia God, ");
INSERT INTO aia_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ma moigui to'oraai mena 'anai taari'i adaro.” ");
INSERT INTO aia_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nara 'ini atadaa'i waira ta'i tangahuru mana rua 'ia Jisas na 'ome sigihiraau: Saemon, mo'o na 'ia Jisas 'a ha'a-atania ro'u 'inia Pita; ");
INSERT INTO aia_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","mea Jems mea Jon rua garena Sebedi, waira rua na 'ia Jisas 'a 'unurarua 'iniai Boanejis ma'ua Sae ni Hita, 'inia raru matai taesu'a mwada'u; ");
INSERT INTO aia_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","mea Andru, Pilip, Batolomiu, Matiu, Tomas, mea Jems garena Alfias, mea Tadias, mea Saemon, baaniai ruruha ra raba taaria hura'ai gaumani ni Rom, ");
INSERT INTO aia_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mea Jiudas Iskariot, 'ia mo'o na usuha'inia Jisas tanaraaui maerongana'i. ");
INSERT INTO aia_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mia Jisas 'a aho'i 'ari ruma ana. Ma na'i ro'u i 'ohasi, 'a ragoi sae ra rurugoni mai beia. Mana rago di'u 'anai sae, 'ia Jisas mana rongoiusuri ana'i rau bwarabwara'a di'u marau ai'a to'o madoraa 'anai ngau ma'ua haa'i tara'i maho he'ete'i ro'u. ");
INSERT INTO aia_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","'Oha 'iraaui do'orana'i mana inana Jisas rau rongo'i maho 'isi, rau 'ari wou 'anai waia 'ari ruma adaau. 'Inia tara'i sae rau 'unua do ai'a odo-odo i 'adoma'ina. ");
INSERT INTO aia_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Hoita, ma tara'i Ha'ausuri 'anai Ringe ana'ia Moses narau boi baaniai Jerusalem, rau awa ro'u marau ha'atee o'ani, “Na mwaeraha adaaui adaro, 'ia Saetan, 'a bwaunia Jisas. 'Iia na haa tanaai mena 'anai taari'i hura'ai adaro baaniraaui sae.” ");
INSERT INTO aia_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mia Jisas 'a soiraau mai sae 'anai boi gaarangia, ma haa'i ha'atee heiha'auu 'anai ha'ausuriraau, 'a o'ani, “'A 'ua? Mou 'adoma'inia do'ia Saetan 'ai matai taaria hura'a haaria? 'A bwara! ");
INSERT INTO aia_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","'Onaa 'e kantri na 'iraaui sae ra hei'oi hairiu, na kantrisi 'a bwa'i ura. ");
INSERT INTO aia_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma 'onaa 'e ta'i ruruha na'i ruma ra awa heheihoa'a moi, na ruruhasi 'a bwa'i ura ro'u. ");
INSERT INTO aia_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hoita, 'onaa ruruha ana Saetan rai awa heheihoa'a, 'a o'asi ro'u. 'A bwa'i ura mwada'u, ma'ai ahoda mai ai'aa.” ");
INSERT INTO aia_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mia Jisas 'a haa ro'u i ha'atee heiha'auu. 'A ha'atee o'ani, “'Onaa 'e nei na raba taari'i hura'ai adaro, 'ai wetewete ma'ata di'ua Saetan. 'A 'onaai sae na raba sirihiai ruma anai sae wetewete 'anai haa'i maho ana'i, 'ai wetewete ma'ata di'ua ro'u i sae wetewetesi. Naasi 'aigu mwada'u tanaa 'anai siri tosiai saesi, maigui haa'i bori ana'i. ");
INSERT INTO aia_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“'Inau wai 'unua ha'a-momori tana'amou. 'Ia God 'a matai 'adoma'i nugasi'i moi mwane ora-ora'a na sae 'a haa'i mana mwane maho ta'a'i na 'unu'i 'inia God. ");
INSERT INTO aia_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma'ata 'ia tei nai ha'atee ha'ata'aiai Hi'ona Maea, 'ia God 'a bwa'i 'adoma'i nugasia 'inia. Ni ora-ora'asi 'ai awa tarau beia.” ");
INSERT INTO aia_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","'Ia Jisas 'a 'unua o'asi tanaraau 'inia tara'i nei 'iniraaui Ha'ausuri 'anai Ringe ana'ia Moses ra 'unua do'e adaro na bwaunia, naia na to'o mena 'inia 'anai taari'i hura'ai adaro. Ai'a do 'iniai mena ana Hi'ona Maea. ");
INSERT INTO aia_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mana inana Jisas miraau do'orana'i rau ataha mai na'i ruma na 'ia Jisas 'a awa iei. Marau ura moi hura'ai abau 'omaa. Maraugu ha'ataaria siri taroha tanaa Jisas do'ai hura'a. ");
INSERT INTO aia_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Me na'i 'ohasi, 'a ragoi sae na rau heinagu garigaria Jisas marau o'ani 'inia, “'Ei, 'ia inamu miraaui do'oramu'i, neiraau hura'asi. Rau raba re'i'o.” ");
INSERT INTO aia_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","'Ia Jisas 'a ha'atee o'ani 'iniraau, “'Iatei inagu miraaua tei do'oragu'i?” ");
INSERT INTO aia_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mia Jisas 'a wanasiraau hairiui sae ra heinagu garigaria. Maagu ha'atee o'ani, “'Ome! Neiraauni inagu mana do'oragu'i! ");
INSERT INTO aia_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","'Ia tei na hauai taha God na 'irisia do 'ai haa, naasi huunai do'oragu mana asigu mana inagu.” ");
INSERT INTO aia_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mia Jisas 'a taraawa'a ha'ausuriraau ro'u i sae na'i bobonai kae bwera i Galili. Me suriai rago 'anai sae nara goni na'i dorasi, 'ia Jisas 'a heinagu ara'a na'i ora ma ta'e hura'a baaniai one. Me 'iraaui sae ra ura moi one 'anai bahurongoa. ");
INSERT INTO aia_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma haa'i ha'atee heiha'auu 'anai ha'ausuriraau. 'Agu ha'atee o'ani 'iniraau, ");
INSERT INTO aia_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Moi bahurongo goro. 'E 'oha na 'e ta'i sae na hura'a 'anai hasi korai wiit na'i mou ana. ");
INSERT INTO aia_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma na'i 'oha na rarasanga'ini'i kora, ra'i nei nara to'o na'i tara mana gere manu ra dio mara ngaa'i. ");
INSERT INTO aia_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tara'i nei ra to'o na'i dora hauhau'a, dora na ano 'a ai'a raha mara tahi'a. Mana 'oha ra tahi, ra tahi goro ga'u moi. ");
INSERT INTO aia_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mana 'oha na sina 'a raorao di'u, ra nugu mara mae aho'i moi, 'inia raridi ra ai'a ganu dio. ");
INSERT INTO aia_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma tara'i kora ra to'o na'i dora ra tahi bei'i waroraraki. Ma na'i 'oha ra tahi ara'a, na waroraraki 'a agu ha'amaesi'i maragu ai'a hungu'a. ");
INSERT INTO aia_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mana kora ra to'o na'i ano goro, ra tahi goro mara hungu. Tara'i nei ra'i ta'i oru tangahuru hua, tara'i nei ra'i ono tangahuru, ma tara'i nei ra'i 'arangi. ");
INSERT INTO aia_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tei na to'o karinga 'anai rongo 'ai bahurongoa mai aidangi tarihana.” ");
INSERT INTO aia_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","'Oha na awa haaria Jisas, 'iraau na ta'i tangahuru mana rua rongoiusuri ana ma tara'i sae ro'u beiraau, rau boi marau songa'inia 'ini'i 'ado'ado 'ada'i mamaani 'isi. ");
INSERT INTO aia_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mia Jisas 'a ha'atee o'ani 'iniraau, “Na'i na'o, 'ia God ai'a ha'arangasia he'uai marungiraau nai haa i noni ana'i. Me na'i 'ohani 'a ha'ata'inia tana'amou. Mei tanaraaui nei nara ai'a hinihinia God, wai ha'ausuriraau moi suri'i ha'atee heiha'auu. ");
INSERT INTO aia_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","'Au haua o'asi do, ‘Rei'uaa rai 'ome marai 'ome marau bwa'i 'ome 'iraraa ta maho, ma'ua rai bahurongo marai bahurongo marau bwa'i aidangisia ta maho. Ma 'onaa rai 'ome 'iraraa marai aidangisia, rau ga'i rihosi, mea God 'ai 'adoma'i nugasi'araau.’” ");
INSERT INTO aia_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mia Jisas 'a songa'iniraau ro'u o'ani, “'A 'ua? Mou ai'a aidangisiai ha'atee heiha'auusi? 'Onaa mou ai'a, 'ai he'ua namoigu aidangisi'i ro'u 'ini'i tara'i heiha'auu na wai maani'i ro'u? ");
INSERT INTO aia_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Hoita, 'i nei na rarasa kora 'a 'onaai sae na taroha'ini'i ha'atee ana'ia God tanaraaui sae. ");
INSERT INTO aia_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Na kora ra to'o suriai tara nara ngaa'i manu, 'a ura 'iniraaui sae ra rongo'i moi ha'atee. Mia Saetan 'a boi ma ha'akaku'araau aho'i 'ini'i. ");
INSERT INTO aia_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na kora ra to'o na'i ano hauhau'a 'a ura 'iniraaui sae ra rongo'i mara daa'i raurau i ha'atee ha'i wa'ewa'e. ");
INSERT INTO aia_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mara ai'a daa'i orea 'inia na ha'atee ra ai'a ganu dio na'i tahingadaa'i 'onaai hasi'ei ra ai'a ganu i raridi. 'Oha na mwani maho ra bwara mara ha'a-mama'airaau 'ini suri'i adaa'i ha'atee ana'ia God, raugu rihota'i aho'i. ");
INSERT INTO aia_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na kora ra to'o na'i dora ra awa iei waro raraki 'a ura 'iniraaui sae ra rongo'i ha'atee ana'ia God. ");
INSERT INTO aia_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ma 'ari wou maraugu 'adoma'i raha moi 'ini'i taraani maho. Mara ta'ahi'i ro'u i toto'ora ni marewana, mana taraani maho ni marewana moi. Tarana naasi, na ha'atee 'a bwa'i matai tahi ma ai'a ha'i hua. ");
INSERT INTO aia_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mana kora ra to'o na'i ano goro, 'a ura 'iniraaui sae ra rongo'i ha'atee ana'ia God marau huunai hinihini'i. Mana mwane maho goro ra hura'a baani'i tahingadaa'i 'onaai hungu goro ra hahaa'i hasi'ei. Tara'i nei ra'i oru tangahuru hua, tara'i nei ra'i ono tangahuru, ma tara'i nei ra'i ta'i 'arangi.” ");
INSERT INTO aia_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","'Ia Jisas 'a ha'atee o'ani ro'u 'iniraau, “'A 'ua? Ta sae 'a ga'i suungia ta raita 'anai nugaa moi na'i bahainai rabo'o ma'ua na'i bahainai bwea? 'A bwa'i! 'Iia 'ai tokia ma'ata'a na'i dora 'ana. ");
INSERT INTO aia_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Taha na awa bainihu 'ai ha'ata'i hura'a. ");
INSERT INTO aia_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tei na to'o karinga 'anai rongo 'ai bahurongoa mai aidangi tarihana.” ");
INSERT INTO aia_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mia Jisas 'a ha'atee o'ani ro'u 'iniraau, “Moi wai'ado'ado goro suri'i maho nau maani'i tana'amou. 'Ia God 'ai haua tana'amoui aidangi suriai araisuri'i amoo'i taha nau 'unu'i. ");
INSERT INTO aia_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","'Ia tei na raba aidangisia God, 'ia God 'ai a'oia tanaai aidangi na to'oraa. Mia mo'o na ai'a raba aidangisia God, na gere aidangi na to'oraa, 'ia God 'ai rahia baania.” ");
INSERT INTO aia_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mia Jisas 'a haa ro'u i ha'atee heiha'auu, “Na heimarungi ana God 'a 'onaai kora na sae 'a rarasa-nga'ini'i na'i moou ana nara tahi haari'i. ");
INSERT INTO aia_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Saesi 'a mauru na'i rodo, 'a rarai na'i dangi ma poru haa'i tagora ana'i. 'Ado dangi 'a haua o'asi moe'a. Ma na'i 'ohasi, na kora ra raboa mara tahi ara'a. Mia mo'osi 'a ai'a 'iraraai taha na ha'atahi'i kora 'isi. ");
INSERT INTO aia_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hoita, naia na ano na ha'atahi'i 'isi na ragu hungu 'ini'isi. Na maho tahamora na re'ia, naasi rawadi, ruana tagadi mana oruna nai'i huadi. ");
INSERT INTO aia_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mana 'oha na hua ra maua, 'a hauai naihi ana ma tabari'i, 'inia 'a tari'ai madoraa 'anai haa'i.” ");
INSERT INTO aia_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mia Jisas 'a songa'iniraau ro'u o'ani, “'A he'uai 'adoma'imoou 'iniai heimarungi ana God? 'E taha wai heiha'auu 'inia na moi aidangisia 'inia? ");
INSERT INTO aia_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","'Io, 'a 'onaai koranai hasi'ei ra 'unua 'iniai mastad nara hasia na'i mou. Na koranai hasi'eisi 'a kekerei di'u'i koradi mwane hasi'ei. ");
INSERT INTO aia_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma na'i 'oha na tahi ara'a, 'e kae hasi'ei na raha di'u'i hakoi maho ra hasi'i na'i mousi, mana raraana ra raha 'ohadi manu 'anai nu'i suri'i.” ");
INSERT INTO aia_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","'Ia Jisas 'a haa'i tanaraaui inoni ha'ausuringa'i na rau matai aidangisi'i. ");
INSERT INTO aia_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","'A haa'i moi suri'i ha'atee heiha'auu. Ma na'i 'oha nai awa haaria beiraaui rongoiusuri ana'i 'aigui ha'atee wagasi'i tanaraau. ");
INSERT INTO aia_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na'i dangisi, 'oha na gaarangi su'urahi, 'ia Jisas 'a ha'atee o'ani 'iniraaui rongoiusuri ana'i, “Gau magai 'ari nata batarau i bwera.” ");
INSERT INTO aia_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Miraaui rongoiusuri ana'i rau hano baaniraaui inoni 'isi. Rau ta'e ara'a na'i ora na 'ia Jisas na heinagu iei marau ta'i 'ari nata batarau. Ma tara'i ora ro'u narau ta'i 'ari goni. ");
INSERT INTO aia_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Raugu 'asu'a marau hano suaai kae ro'a beiai tabaosi. Mana ora narau ta'e iei 'a gaarangi mai dodo 'inia ni tabaosi ra abwao aharau siri na'i raronai ora. ");
INSERT INTO aia_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Na'i 'ohasi 'ia Jisas 'a borunga na'i pilo auru na'i muri, 'a poru mauru. Miraaui rongoiusuri ana'i rau ha'araia marau o'ani 'inia, “Ha'ausuri, 'a ai'a ta'aabemu 'iniai gaarangi dodo'a agaauni?” ");
INSERT INTO aia_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","'Ia Jisas 'a ura ara'a ma ha'atee wetewete o'ani tanaai ro'a mana wai, “Papaku!” Ma na'i mau 'ohasi na ro'a 'a papaku mana wai 'agu biowaa. ");
INSERT INTO aia_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","'Ia Jisas 'agu songa'iniraaui rongoiusuri ana'i, “Ni 'uaana mou mamaa'u 'inia? 'A 'ua? Mou ai'a hinihiniau mau?” ");
INSERT INTO aia_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na'i 'ohasi rau mamaa'u ro'u wou baaniai na'o marau ha'atee hairiu o'ani, “'E sae he'ua naani? Rei'uaa ro'a mana tabaosi mara araisuria moi!” ");
INSERT INTO aia_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","'Ia Jisas miraaui rongoiusuri ana'i rau taha wou na'i nata bataraui bwera i Galili marau 'oto na'i dora ra 'unua 'iniai Gerasa. ");
INSERT INTO aia_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Ma na'i 'oha rau dio baaniai ora, 'e sae na adaro 'a bwaunia 'a boi 'anai heisadoi beia Jisas. Saesi 'agu hura'a mai baaniai dora na awa iei, suri'i wabwa nara toringi'i ei sae mae. Me 'iniai wetewete di'u ana, rei'uaa ra ho'osia 'ini'i arihau mara ai'a bwara tanaai mosi'i. ");
INSERT INTO aia_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","'A ragoi 'oha ra ho'osiai uwana mana rimana 'ini'i arihau ma momosi'i moi. Ma ai'a ta sae ro'u 'ai wetewete 'anai ha'amanataa. ");
INSERT INTO aia_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dangi mana rodo 'a hano hairiu suri'i wabwa mana hungahunga. 'A awaawara ma ha'amaaraai abena 'ini'i hau. ");
INSERT INTO aia_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hoita, saesi 'a bwane re'ia mau hura'a Jisas sisiri mai adaau ma bwane 'eba 'anai heisadoi beia. 'A taha wou beia ma topira'i ruru tanaa. ");
INSERT INTO aia_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Mia Jisas 'a ha'atee o'ani, “Adaro, 'oi hura'a baaniai saeni!” Mana saesi 'agu awara raha o'ani, “'Ei Jisas, garena God ororiu ara'a! 'O raba 'uaauni? Na'i atana God 'au ha'angoni'o, 'oi abui ha'a-mama'aiau!” ");
INSERT INTO aia_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mia Jisas 'a songa'iniai saesi, “'Iatei atamu?” Mia aramia, 'a o'ani, “Atagu 'ia Kae Ruruha, 'inia meu rago di'u.” ");
INSERT INTO aia_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mia ha'angonia wetewete a Jisas do 'ai abui taariraau hura'a baaniai dorasi. ");
INSERT INTO aia_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma na'i bobonai abaaba gaarangiraau, ra'i mwane boo nara suasua 'isi. ");
INSERT INTO aia_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Miraaui adaro 'isi ra bonga'inia Jisas o'ani, “'Oi ha'ataari'ameu siri suri'i boo 'isi 'anai awa suri'i.” ");
INSERT INTO aia_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mia Jisas 'a ha'awateraau mana adaro 'isi ra hura'a baaniai saesi mara siri'a suri'i mwani boo 'isi. Mana boo 'isi ra 'eba dio suriai ahana mara rege dio na'i wai mara dodo hako. ");
INSERT INTO aia_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Miraaui nei ra 'omesuri'i boo 'isi rau 'eba 'ari na'i 'omaa ma na'i suri'i mwani dora ro'u 'anai taroha'iniai tarohasi. Mana mwani sae hako ra boi 'anai 'omesiai maho na to'o. ");
INSERT INTO aia_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mana 'oha ra boi beia Jisas, ra re'iai sae na adaro ra bwaunia ga'u. 'A goro'a mana aidangina 'a odo-odo aho'i ma ho'o bwana'a, 'a heinagu papaku moi. Miraaui sae ra mamaa'u hako. ");
INSERT INTO aia_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Miraaui nei rau re'i'i maho 'isi, rau maania 'ari taha na to'o tanaai saesi mana boo 'isi. ");
INSERT INTO aia_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Miraaui saenai dorasi rau bonga'inia Jisas do'ai hura'a baaniai dora adaau. ");
INSERT INTO aia_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","'Oha 'ia Jisas 'a ta'e aho'i na'i ora, na sae na adaro ra bwaunia ga'u ani 'a ha'angonia wetewete do rarui ta'i hano. ");
INSERT INTO aia_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mia Jisas 'a ha'atee o'ani 'iniai saesi, “'Au ai'a rabasia do'oi hano beiau, ma'ata 'oi 'ari 'omaa amua beiraaui sae amu'i. Ma'oi 'unua tanaraau taha 'ia Araha God na haua tana'o mana heita'ahi ana tana'o.” ");
INSERT INTO aia_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Naasi mana saesi 'a hura'a ma 'ari na'i Provensi Dekapolis. 'A maania tanaraau hakoi mwani sae taha na 'ia Jisas 'a haua tanaa mana mwani sae 'isi ra heimwaota'i di'u 'inia. ");
INSERT INTO aia_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","'Ia Jisas miraaui rongoiusuri ana'i rau ta'e aho'i 'ari nata aba 'iniai bwera i Galili. 'Oha na siri wou na'i one, 'a ragoi sae ra rurugoni mai beia. ");
INSERT INTO aia_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma'e sae na boi 'anai re'ia Jisas na atana 'ia Jaeras. 'Iiasi 'e na'otara na'i ruma ni ha'arahesi 'anai 'omaasi. 'A boi ma topiruru auru tanaa Jisas. ");
INSERT INTO aia_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'A ha'angonia wetewete, 'a ha'atee o'ani, “Jisas, ni gare urao agua 'a gaarangi mae'a. 'Oi boi karohia maai goro aho'i.” ");
INSERT INTO aia_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mia Jisas 'agu hano beia Jaeras 'anai 'ari ruma ana. Ma'e kae ruruhai sae ra hano haisuri mara ha'asu'isu'ia. ");
INSERT INTO aia_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma na'i ruruhasi, 'e urao na awa iei na adoiai 'abu raha, ma'e ta'i tangahuru mana rua harisi na hako'a. ");
INSERT INTO aia_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","'A rongomaata'i di'u suri'i 'oha 'iraaui dokita ra bonasiai ha'ahakoa baania i daohasi. Mana uraosi ai'a gere goro moe'a, 'agu daoha raha di'u wou. Mana gere ha'a ana'i ra hako mamata 'iniai tahariraau. ");
INSERT INTO aia_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Na uraosi 'a bwane rongoai taroha 'inia Jisas. Naasi ma 'ariwou na'i murina na'i 'uruhanai kae ruruhasi ma karohiai to'oni ana. ");
INSERT INTO aia_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","'A 'iraraa haaria do 'onaa 'ai karohia moi to'oni ana Jisas ma 'a ga'i goro aho'i baaniai daoha na adoiasi. ");
INSERT INTO aia_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma na'i 'oha na karohia na 'abu 'a papaku ma arunga 'iraraa do 'iia 'a goro'a. ");
INSERT INTO aia_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma na'i ro'u 'ohasi, 'ia Jisas 'a 'iraraa do ni mena ni ha'atahi 'a hura'a baania. Ma rihota'i ma songa'iniraaui mwane sae 'isi o'ani, “'Ia tei 'ini'amou na karohiai to'oni agua?” ");
INSERT INTO aia_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Miraaui rongoiusuri ana'i rau ha'atee o'ani 'inia, “'A 'ua na'o songa'inia 'inia mo'o na karohiai to'oni amuasi? 'A bwarai 'iraraa tei na karohi'o! 'O ai'a 'iraraai rago anai sae na ra ha'a-su'isu'i'osi?” ");
INSERT INTO aia_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mia Jisas 'a wanawana hairiu 'anai re'ia tei na karohiai to'oni ana. ");
INSERT INTO aia_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mana uraosi 'a 'iraraai maho na to'o tanaa. 'A boi ha'i-'idi'idi 'inia 'a mamaa'u, 'a topira'i ruru auru tanaa Jisas ma maania hako tanaai daoha na sadoia ma 'inia ro'u i karohia anai to'oni ana. ");
INSERT INTO aia_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mia Jisas 'a ha'atee o'ani 'iniai uraosi, “Ina, i hinihinimu na ha'agorohi'o aho'i! 'O bwa'i rongomaata'i'a. 'Oi 'ariwou dadara'a!” ");
INSERT INTO aia_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na'i 'oha na 'ia Jisas 'a ha-hadahada mau, ra'i sae ra boi baaniai ruma ana Jaeras marau o'ani 'inia Jaeras, “Ni gare amua 'a hako'a. 'Oigu abu 'unua'ai ha'ausurisi 'anai 'ari!” ");
INSERT INTO aia_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","'Ia Jisas 'a rongo'i mareho narau maani'isi ma o'ani 'inia Jaeras, “'Oi abui mamaa'u, 'oi hinihini moi!” ");
INSERT INTO aia_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","'Ia Jisas 'a ai'a rabasia do tanei ro'u 'anai hano beia, ma'ata 'ia moia Pita, 'ia Jems, mea Jon do'orana Jems. ");
INSERT INTO aia_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Rau 'ari wou ruma ana Jaeras marau rongoraaui sae nara boi 'anai ada'imae 'iniai garesi. ");
INSERT INTO aia_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na'i 'oha 'ia Jisas 'a siriwou na'i ruma 'a ha'atee o'ani 'iniraau, “Ni 'uaana namou angi 'inia? Na garesi ai'a mae, 'iia 'a mauru moi.” ");
INSERT INTO aia_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mana mwane sae hako ra da'ata'inia Jisas. 'Ia Jisas 'a 'unua tanaraaui mwane sae 'isi do rai hura'a baaniai ruma. Maagu wairaruai amana mana inanai garesi, beiraaui oru rongoiusuri anasi marau 'ari na'i ahii na awa iei garesi. ");
INSERT INTO aia_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","42","Mia Jisas 'a dau na'i rimanai garesi ma ha'atee o'ani na'i ha'atee ana, “Talitha, koum!” I 'ado'ado 'anai ha'ateesi 'a o'ani, “Gere urao, suruta'e!” Ma na'i moi 'ohasi, na garesi 'a suruta'e magu hahano. Miraau hako rau heimwaota'i di'u. ");
INSERT INTO aia_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","'Ia Jisas 'a ha'atee wetewete tanaraau do rai abui taroha'inia ro'u tanaa ta nei 'iniai mahosi. Ma ha'atee o'ani, “Moi haua tanaa ta mahoingau.” Mana gare uraosi, ni harisina 'e ta'i tangahuru mana rua. ");
INSERT INTO aia_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","'Ia Jisas 'a hura'a baaniai 'omaasi bei'i rongoiusuri ana'i marau 'ari Nasaret, 'omaa na raha ara'a iei. ");
INSERT INTO aia_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ma na'i dangi ni mamaro 'a siri na'i ruma ni ha'arahesi ma ha'ausurirai noni. Ma ragoi noni ra goni mai 'anai bahurongoa. Ma na'i 'oha ra rongo'i ha'ausuringa'i ana'i, rau heimwaota'i di'u maraugu ha'atee heiheia o'ani, “Romwane! 'A he'ua na 'irara'i 'ini'i maho 'inia mo'osi? 'E sae haaria moi na'i 'omaani naasi, ma 'a he'ua na aidangi di'u 'iniasi? Ma to'oraa he'uai mena na haa'i 'ini'i ha'abu'oahu 'isi? ");
INSERT INTO aia_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","'Iia 'e kapentaa moi, gare ana Meri, do'oradaau a Jems, Josep, Jiudas mea Saemon. Me 'iraaui asina'i rau awa ro'u moi 'ini.” Naasi rau 'itaa Jisas marau ai'a raba hinihinia. ");
INSERT INTO aia_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mia Jisas 'a ha'atee o'ani 'iniraau, “I rarabea ra ha'ahoua suri'i mwani dora hako. Na'i moi 'omaa ana miraaui sae ana'i naraugu ai'a.” ");
INSERT INTO aia_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma 'ini ai'a hinihinia adaau a Jisas, ai'a ragoi ha'abu'oahu na haa'i na'i 'omaasi. Mia nugaai rimana moi hungadaau taringai nei ra daoha mara goro aho'i baani'i daoha nara sadoira. ");
INSERT INTO aia_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","'Ia Jisas 'agu heimwaota'i di'u 'iniraaui sae na'i 'omaa ana, 'inia rau ai'a hinihinia. Ma na'i muri, 'ia Jisas 'a hano hairiu suri'i 'omaa 'anai ha'ausurirai noni. ");
INSERT INTO aia_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ma'e ta'i 'oha, 'a soiraau goni ta'i tangahuru mana rua rongoiusuri ana. Ma ha'atee o'ani 'iniraau, “'E waira rua ma wai ha'ataaria hura'a 'ari suri'i 'omaa. Ma wai haa tana'amoui mena 'anai taari'i hura'ai adaro baanirai sae. ");
INSERT INTO aia_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na'i 'oha moi hura'a, abu tanei 'ini'amou 'ai waa ta huai bredi ma'ua anga ni 'aariha, ma'ua ha'a. Moi matai waa'i 'a'abi amoo'i ");
INSERT INTO aia_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","mamoi siri suri'i sandol amoo'i. Ma'ata mou abui waa'a ro'u ta to'oni. ");
INSERT INTO aia_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","'Oha moi siri wou na'i ruma nara ha'a-maoto'amou na'iei, moi awa hatara'i na'iei tari 'oha moi hura'a baaniai dorasi. ");
INSERT INTO aia_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mana 'oha moi taha wou ta dora na rau bwa'i raba ha'amaoto'amou mana rongo'i taha mou hadanga'ini'i, moi hura'a baaniai 'omaasi. Ma moi tarohi'i kahua baani'i uwamoo'i, 'e ha'abasu tanaraau do'ia God 'ai ha'a-mama'airaau.” ");
INSERT INTO aia_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Me 'iraaui rongoiusuri rau hura'a marau taroha'iniai ha'atee ana God tanaraaui mwane sae, rau o'ani, “Mou rihosi baani'i ora-ora'amoo'i.” ");
INSERT INTO aia_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Marau taari'i hura'a mwani adaro marau tarohiraau mwani nei ra daoha 'iniai rumu mara goro aho'i baani'i daoha nara sadoira. ");
INSERT INTO aia_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na'i 'ohasi, 'ia Herod Antipas na Mwaeraha na'i Galili, 'a rongo'i mwani taroha 'ini'i taha 'ia Jisas mana rongoiusuri ana'i rau haa'i. 'Inia na taroha 'a 'adarara hako 'ari suriai mwane dora. Tara'i sae ra 'unua do 'ia Jisas naasi 'ia Jon Bwareomaea na tahi aho'i baaniai mae. 'Inia do naia na to'o mena 'inia 'anai haa'i ha'abu'oahu. ");
INSERT INTO aia_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma tara'i nei ro'u ra 'adoma'inia do 'ia Elaija ma'ua 'e ta'i 'iniraaui Rarabea ni 'ohaani mau. ");
INSERT INTO aia_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ma na'i 'oha 'ia Herod 'a rongo'i maho ra 'unu'i 'inia Jisas, 'a o'ani, “'Ia Jon Bwareomaea nara horosia'ai 'u'una ani, na suruta'e aho'i baaniai maesi.” ");
INSERT INTO aia_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","'Inia na'i na'o, 'ia Herodias raru ha'iwai a Pilip, do'orana Herod. 'A 'ari wou mia Herod 'agu asihura moi ma waina'a Herodias. Naasi 'ia Jon Bwareomaea 'a taringai 'unua tanaa Herod do 'a ai'a odo-odo do'ai wainai urao ana do'orana! Hoita, mia Herodias 'a taesu'a di'u 'ana Jon ma raba ngahuia maagu bwara tanaa. 'Inia 'ia Herod 'a maguguta'i ngahuia 'inia 'a 'iraraa do 'ia Jon 'e sae na maea ma odo-odo na'i maana God. Naasi 'ia Herod 'a 'unua tanaraaui sae hehei'oi do rai waia Jon marai nugaa na'i rumaniho'o, 'inia 'a raba ha'atahia baania Herodias. 'Ia Herod 'a wa'ewa'e 'oha na bahurongo'i mamaani na haa'i a Jon, rei'uaa na ha'a-heingahui'i maho 'isi na'i 'adoma'ina. ");
INSERT INTO aia_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","'E ta'i 'oha, 'ia Herod 'a hauai kae ngaungau 'anai 'adoma'i aho'isiai 'oha na huta. Ma ari'ahuraau hako mai saemaua ana'i, 'iraaui na'otara na'i ruruhai hehei'oi, miraau hakoi na'otara na'i Galili. Na'i 'ohasi, 'ia Herodias 'agu sadoiai 'oha goro 'anai ngahuia Jon. ");
INSERT INTO aia_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Na'i 'oha na to'o i ngaungau, 'e gere urao, garena Herodias, 'a siri mai mao 'anai ha'a-reirei'araau. Mia Herod miraau hakoi sae na'i rumasi rau wa'ewa'e 'anai reireia. Mia Herod 'agu o'ani 'iniai gere uraosi, “Wai haua tana'o namoiwou ta mareho 'oi 'irisia. ");
INSERT INTO aia_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wai duruduru tana'o 'inia ta aba 'iniai dora nau marungia 'onaa 'o 'irisia.” ");
INSERT INTO aia_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mana gere uraosi 'a hura'a, ma 'ari songa'inia inana, 'a o'ani, “Nanae, 'e taha wai ha'angonia?” Mana inana 'a o'ani, “Ni bwauna Jon Bwareomaea!” ");
INSERT INTO aia_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mana gere urao 'a hasi hura'a ma 'ari aho'i beia Herod ma ha'atee o'ani, “'Inau 'au rabasia do'oi haua'a mai tanaaui bwauna Jon Bwareomaea na'i ta rabo'o papaheta'a.” ");
INSERT INTO aia_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na Mwaeraha 'a ahutotou di'u. Ma ha'a-heingahuia na'i 'ado'adona, 'inia 'a ai'a raba horosiai 'u'una Jon. Ma bwara'a ro'u tanaai ura bwarasiai taha na gere uraosi 'a ha'angonia na'i maadi sae rago. ");
INSERT INTO aia_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Naasi 'ia Herod 'a ha'ataariai sae hehei'oi moi 'ohasi 'ari rumaniho'o 'anai horosiai 'u'una Jon. ");
INSERT INTO aia_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mana sae hehei'oi 'a horosiai 'u'una, 'a nugaai bwauna na'i rabo'o papaheta'a ma haua tanaai gere urao, mana gere uraosi 'a waa 'ari tanaa inana. ");
INSERT INTO aia_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","'Oha 'iraaui rongoiusuri ana'ia Jon ra rongoa, raugu boi waai abena marau nugaa na'i wabwa. ");
INSERT INTO aia_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","'Oha 'iraaui Ha'ataari rau aho'i mai baaniai 'aariha adaau, rau maani'i tanaa Jisas mwani maho rau haa'i mana mwani maho rau ha'ausuriraaui sae 'ini'i. ");
INSERT INTO aia_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Me 'iniai rago anai sae nara boi beia Jisas ma ra aho'i, 'ia Jisas mana ha'ataari ana'i rau bwarabwara'a di'u marau ai'a to'o madoraa 'anai ngau mana haa'i tara'i maho he'ete'i ro'u. Mia Jisas 'a ha'atee o'ani 'iniraau, “Gau ma gai 'ari ta dora na bwa'i ta sae nai awa na'iei ma gai gere mamaro ga'u.” ");
INSERT INTO aia_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Naasi, marau ta'e na'i ora, rau 'ari na'i dora na ai'a sae awa iei. ");
INSERT INTO aia_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Miraaui sae rau 'irararaau'ai hano adaausi, marau hano baani'i 'omaa adaa'i. Rau 'eba hatare 'anai dora na 'ia Jisas mana rongoiusuri ana'i narau hano 'ana, marau ataha na'i na'o 'iniraau. ");
INSERT INTO aia_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","'Oha 'ia Jisas 'a dio baaniai ora, 'a re'iai kae ruruhai saesi ma ta'ahiraau di'u, 'inia rau 'ome ha'a-ta'ata'ahi 'onaai'i siip nara ai'a to'o sae 'anai 'omesuri'i. Ma ragoi maho na ha'ausuriraau 'ini'i. ");
INSERT INTO aia_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma su'urahi'a 'iraaui rongoiusuri ana'i rau boi beia marau o'ani 'inia, “'A orea di'u'a naani, mana dorani, 'a ai'a ruma'a. ");
INSERT INTO aia_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ni 'uaana na'o ai'a ha'a-taariraaui sae 'ini marai hura'a suri'i 'omaa 'isi 'anai hori 'adaau mahoingau?” ");
INSERT INTO aia_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mia Jisas 'a aramiraau o'ani, “'I'amou namoi ha'i 'adaau mahoingau!” Marau o'ani 'inia, “'E taha na mei hanganiraau 'inia? Horihorinai ta'i sae na'i ta'i harisi maigui arari 'anai hori bredi 'ada'i mwani sae 'ini!” ");
INSERT INTO aia_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","'Ia Jisas 'a ha'atee o'ani 'iniraau, “Moi sadoiai siha huai bredi na beiraaui sae 'isi.” Mana 'oha rau 'iraraa, rau 'unua tanaa o'ani, “'E rima gere huai bredi ma'e rua ii'a.” ");
INSERT INTO aia_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mia Jisas 'a 'unua tanaraaui rongoiusuri 'anai ha'a-heinaguraaui sae na'i mwani hahaarisi marai hoairaau suri'i ruruha. ");
INSERT INTO aia_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Miraaui sae ra heinagu suri'i ruruha, tara'i ruruha ra'i ta'i 'arangi sae, ma tara'i nei rima tangahuru. ");
INSERT INTO aia_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mia Jisas 'a dauai rima huai bredi mana rua ii'asi. 'A wana ara'ai aro ma ha'atee ha'agorohia God 'inia. Ma uubi'i bredi 'isi mana ii'a ma haa'i tanaraaui rongoiusuri ana'i 'anai ha'atora'ini'i tanaraaui sae. ");
INSERT INTO aia_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","'Iraau hako rau ngau masu ");
INSERT INTO aia_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","mana mahoingau narau ngau tahi'i rau si'o ha'ahonua 'iniai ta'i tangahuru mana rua abira. ");
INSERT INTO aia_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","'A 'onaai rima merui saemwane narau ngau masu hako na'i dangisi. ");
INSERT INTO aia_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Na'i moi muri 'ia Jisas 'a o'ani 'iniraaui rongoiusuri ana'i, “Moi ta'e na'i ora mamoi gaau na'i na'o 'ari nata batarau, mamoi siri na'i 'omaai Betsaeda. 'Inau wai awa ga'u.” Naasi mia Jisas 'a awa moi beiraaui sae 'isi tari 'oha na ha'ahanoriraau aho'i hako 'ari suri'i 'omaa adaa'i. ");
INSERT INTO aia_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","'Oha na ha'a-taariraau hakoi sae, 'a ta'eha na'i hungahunga 'anai ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma su'urahi'a mia Jisas 'a awa mau na'i hungahunga mana rongoiusuri ana'i rau 'ari wou taha na'i 'ubutanai wai. ");
INSERT INTO aia_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","'Ia Jisas 'a re'iraaui rongoiusuri ana'i do rau tau'aro raha di'u 'anai haruta suaai ro'a raha. 'Ari wou me 'iia 'a 'ari beiraau na'i wa'aria, 'a hahano na'i hunganai wai ma gaarangi hano di'uraau'a. ");
INSERT INTO aia_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma na'i 'oha 'iraaui rongoiusuri ana'i rau re'iai hahano ana Jisas na'i hunganai wai rau 'adoma'inia do 'e anoa marau awaawara. ");
INSERT INTO aia_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Rau kae mamaa'u di'u 'oha rau re'ia, mia Jisas 'a o'ani 'iniraau, “'Ai abui ta'aabemoou! 'Inau moia Jisas na! Moi abui mamaa'u.” ");
INSERT INTO aia_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ma ta'e ara'a beiraau na'i ora mana ro'a 'a papaku'a. Miraau na rongoiusuri ra kakuta'aai ahudaa'i. ");
INSERT INTO aia_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ra pwapwakui 'adoma'idaa'i 'inia rau ai'a raroma-tarihana do'a to'o mena 'anai haa'i ha'abu'oahu, 'onaai 'oha na hanganiraau ani rima merui mwane. ");
INSERT INTO aia_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","'Ia Jisas mana rongoiusuri ana'i rau haruta 'ari nata batarau marau 'oto na'i dora ra 'unua 'iniai Genesaret marau ha'ahunaai ora adaau na'i 'isi. ");
INSERT INTO aia_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","'Oha rau dio baaniai ora, 'iraaui sae ra 'ome 'iraraa Jisas. ");
INSERT INTO aia_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Naasi, marau 'eba 'ari suri'i mwani 'omaa na'i dorasi marau taroha'iniai boi ana Jisas. Marau suru'i'i sae ra daoha suri'i bwea marau waa'i 'ari na'i dora na 'ia Jisas 'ai taha suri'i. ");
INSERT INTO aia_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ta 'omaa he'ua nai 'ari ei, 'iraaui sae ra waa'i mai moe'a i sae adaa'i nara daoha mara nuga goni'i na'i ta'i dora a'ora. 'Iraaui sae daoha rau bonga'inia Jisas dorai karohia moi gaonai to'oni tewa ana. 'Iraaui nei rau haua o'asi rau goro aho'i baani'i daoha ra to'iraau. ");
INSERT INTO aia_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tara'i Farisei mana Ha'ausuri 'anai Ringe ana'ia Moses nara boi baaniai Jerusalem, ra goni mai beia Jisas. ");
INSERT INTO aia_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Rau re'ia do tara'i rongoiusuri ana'ia Jisas rau ngau maraugu ai'a dorima suriai herehere 'iraaui Farisei rau 'unua. ");
INSERT INTO aia_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","'Iraaui Jiu, ororiu 'iraaui Farisei, ra suri'i mau i ringe adaa'i na'i 'oha bwani, 'onaai herehere 'anai dori ha'agorohi'i rimadaa'i maraigu ngau. ");
INSERT INTO aia_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma na'i 'oha rai 'ari suri'i dora-ni-horihori mahoingau, ra bwa'i ngaa'i mahoingau rai hori'i tari 'oha rai hauai herehere 'anai dori ha'agorohi'i rimadaa'i. Marau suri'i ro'u tara'i ringe adaa'i, 'onaai here 'anai dori panikeni mana kuki mana rabo'o. ");
INSERT INTO aia_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hoita, miraaui Farisei mana Ha'ausuri rau songa'inia o'ani a Jisas, “Ni 'uaana na'iraaui rongoiusuri amu'i ra ai'a ha'isuri'i 'ini'i ha'ausuringa'i narau ha'adiohi'i mai tanagaau i wauwa agaa'i na'i 'oha bwani? 'I'ameu meu re'ia do rau ai'a suriai huunai herehere 'anai dorima, marau ngau moi!” ");
INSERT INTO aia_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mia Jisas 'a ha'atee o'ani 'iniraau, “Mou pwapwaari'i! Maho na 'unu'ia God tanaa Aisaea 'anai usu'i 'iniraaui wauwa amoo'i ra to'i'amou ro'u. 'Ia Aisaea 'a usu 'oniaa, ‘'Iraaui noni 'ini ra ha'ahouau moi 'ini'i ngoodaa'i, magu tahingadaa'i ra awa ha'atau di'u baaniau. ");
INSERT INTO aia_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","I ha'arahesi adaa'i ra 'ari pwaranga, 'inia rau orisi'i Ha'atora ana'ia God 'ini'i ha'ausuringa'i adaa'i haariraau na inoni moi na haa'i.’” ");
INSERT INTO aia_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mia Jisas 'a o'ani ro'u, “'I'amou mou gagata'ini'i Ha'atora ana God, ma mou suri'i moi ha'ausuringa'i adaa'i noni. ");
INSERT INTO aia_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mou mataihere di'u 'anai gagata'iniai Ha'atora ana God 'anai suri'i moi ha'ausuringa'i amoo'i haarimoou. ");
INSERT INTO aia_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mou 'iraraa do 'ia Moses 'a bwane 'unua o'ani, ‘'Oi ha'ahoua amamu mea inamu’ ma o'ani ro'u, ‘'Iatei na 'unu ha'ata'aia amana mea inana rai ha'amaesia.’ ");
INSERT INTO aia_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Me'imoou mou 'unua dona 'a odo-odo moi 'onaa ta sae 'ai o'ani 'inia inana mea amana, ‘Ha'a-arohai'amurua, 'au ga'i 'a'auhimurua 'ini'i maho nau to'ora'i. Me 'au bwa'i 'a'auhimurua'a. Suria maho nau to'ora'i ra maea'a. 'Inia 'au bwane wate'i tanaa God.’ ");
INSERT INTO aia_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","'I'amou mou 'adoma'i ha'agorohia moi heresi! ");
INSERT INTO aia_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na'i 'oha mou ha'ausurirai noni 'anai haua o'asi, mou here 'onaa do ha'ausuringa'i amoo'i ra ororiu di'uai Ha'atee ana God. Mara rago ro'u i maho na mou here hiosi'i o'asi.” ");
INSERT INTO aia_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","'Ia Jisas 'a soi goniraau ro'u mai kae ruruhai sae ma o'ani 'iniraau, “Moi bahurongo goro mamoi aidangisiai taha na wai 'unu'i. ");
INSERT INTO aia_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Maho na siri na'i ngoonai sae, 'a ai'a ha'ado'o'aai sae na'i maana God. Naia na taha na hura'a baaniai ngoona na ha'ado'o'aa. ");
INSERT INTO aia_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tei na to'o karinga 'anai rongo 'ai bahurongoa mai aidangi tarihana.” ");
INSERT INTO aia_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","'Ia Jisas miraaui rongoiusuri ana'i rau hano baaniraaui sae marau siri na'i ruma. Miraaui rongoiusuri rau ha'angonia 'anai ha'a-aidangisiraau 'iniai ha'atee heiha'auusi. ");
INSERT INTO aia_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mia Jisas 'a o'ani 'iniraau, “Mwane! Mou ai'a aidangisia mau? Na 'adoma'imoo'i ra kuhi 'inia? Mou ai'a 'iraraa dona mahoingau na siri na'i ngoonai sae 'a ai'a ha'ado'o'aai sae na'i maana God? ");
INSERT INTO aia_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Suria na mareho naasi 'a ai'a siri na'i raromana, 'a siri moi na'i ngoona, ma dio na'i ahuna ma hura'a aho'i moi baaniai abena.” 'Ia Jisas 'a ha'atee o'asi 'iniraau ma dorai 'iraraa dona mwane mahoingau ra goro na'i maana God. ");
INSERT INTO aia_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma ha'atee o'ani ro'u 'iniraau, “Ni taha na hura'a baaniai raromanai sae, naasi na ha'ado'o'aa na'i maana God. ");
INSERT INTO aia_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","'Inia na'i raromanai sae nara hura'a i 'adoma'i ta'a'i, 'onaai wawaasua'a, taritari'a beiai nata nei, heingahu mana beri, ");
INSERT INTO aia_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","hairaurau, haa'i maho ta'a'i mana pwapwaari'i, 'adoma'i sisiwa 'iniai nata nei, hai'ubwani, 'unu ha'ata'aia nata nei, ha'a-ta'eta'e mana here to'o bweubweu'a. ");
INSERT INTO aia_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nara 'isi mareho nara ha'ado'o'aai noni na'i maana God. 'Inia ni mareho 'isi ra hura'a mai baaniai raromanai inoni.” ");
INSERT INTO aia_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mia Jisas 'a hano baaniai dorasi, 'a 'ari suri'i 'omaa gaarangiai kae 'omaai Taea. Ma 'ari wou na'i 'omaa ma siri na'i ruma 'inia 'a ai'a rabasia do 'iraaui sae rai 'iraraa. Ma rei'uaa na o'asi, 'iraaui sae rau 'iraraa moi do'a awa 'isi. ");
INSERT INTO aia_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ma'e urao na rongoai dora na awa iei a Jisas. Uraosi ai'a urao ni Israel, 'iia 'a huta na'i Ponisia, 'e aba 'iniai kantri ra 'unua 'iniai Siria. 'A 'ari beia Jisas 'inia na adaro 'a bwauniai gare urao ana. 'A 'ari wou beia ma topiruru ma mwaoro dio na'i ano. Ma ha'angonia wetewetea Jisas 'anai taaria hura'ai adaro baaniai gare ana. ");
INSERT INTO aia_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mia Jisas 'a ha'atee heiha'auu o'ani, “Ni gare narai hangani'i na'i na'o. 'A ai'a goro dorai hau'i mahoingau adaa'i gare ma do raigui gaasi'i 'ada'i misu.” ");
INSERT INTO aia_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mana uraosi 'a o'ani 'inia, “Ha'amomori di'u Araha! Ma'ata na misu ra matai ngaa'i ro'u moi mamamo i mahoingau adaa'i gare na rau ahoda baaniai dora ngaungau.” ");
INSERT INTO aia_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mia Jisas 'a o'ani 'inia, “'Iniai heiarami odo-odo amua, na adaro 'a nugasia'ai gare amua. 'Oi aho'i 'ari 'omaa.” ");
INSERT INTO aia_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mana 'oha na uraosi 'a aho'i 'ari ruma ana, 'a re'ia dona gare ana 'a goro'a aho'i ma dadao hatara'i moi na'i be'a. 'Inia na adaro 'a nugasia'a. ");
INSERT INTO aia_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","'Ia Jisas miraaui rongoiusuri ana'i rau hano baani'i 'omaa gaarangiai 'omaai Taea. Rau 'ari wou rau riutaha na'i 'omaai Saedon mana Provensi Dekapolis maraugu taha aho'i mai na'i kae bwera i Galili. ");
INSERT INTO aia_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma ra'i sae rau waa mai sae na pwarongo ma ai'a hadahada goro. Marau ha'angonia wetewete a Jisas do 'ai karohia maai goro aho'i. ");
INSERT INTO aia_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mia Jisas 'a waia beira'i saesi baaniraaui mwani sae maagu siwi siri suri'i karingana'i saesi. Ma ngisuhiai kaka'una maagu karohiai meameanai saesi 'iniai kaka'una. ");
INSERT INTO aia_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","'A wana ara'ai aro ma osimaro ma o'ani, “Efata!” Mana 'ana 'ado'ado i ha'ateesi, “Ai'a pono'a!” ");
INSERT INTO aia_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na'i 'ohasi saesi 'a rongorongo ma ha-ha'atee goro'a aho'i. ");
INSERT INTO aia_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","'Ia Jisas 'a ha'a-aburaau wetewetei sae do rai abui maaniai ha'agorohia anai saesi. Rei'uaa na towa'i ha'a-aburaau, miraugu here raorao 'anai taroha'inia hura'a. ");
INSERT INTO aia_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","'Ira hakoi nei rau rongoa, rau heimwaota'i di'u marau o'ani, “Romwane, maho na haa'i a mo'osi ra goro di'u! 'A ha'agorohiraau aho'i ro'u i pwarongo mana baanguu.” ");
INSERT INTO aia_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tara'i dangi ahora, ra ragoi sae narau goni ro'u mai beia Jisas. 'Ari wou ma na'i 'oha na rau ai'a to'o mahoingau'a, 'ia Jisas 'agu soiraau mai rongoiusuri ana'i ma o'ani 'iniraau, ");
INSERT INTO aia_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“'Au ta'ahiraaui sae 'ini, 'inia 'e oru dangi'a narau awa be'inigaau ma na'i 'ohanisi raugu ai'a to'o mahoingau 'anai ngau. ");
INSERT INTO aia_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma'au gasi ha'a-taariraau 'ari suri'i 'omaa adaa'i ha'i hioro, maraugu dionga'i moi suri tara. 'Inia tara'i nei 'iniraau rau boi ha'atau di'u.” ");
INSERT INTO aia_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Me 'iraaui rongoiusuri ana'i rau o'ani, “'Igaau gau awa na'i dora mangasara. 'A bwa'i dora na gaigui sadoia ta mahoingau nai arariraaui mwane sae 'ini.” ");
INSERT INTO aia_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","'Ia Jisas 'a songa'iniraau o'ani, “'E siha huai bredi na bei'amou?” Marau aramia o'ani, “'E biu.” ");
INSERT INTO aia_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","'Ia Jisas 'agu 'unua tanaraaui sae 'anai heinagu dio na'i ano ma dauai biu hua bredisi. Mana 'oha na ha'atee ha'agorohia hako a God 'ini'i, 'a uubi'i ma haa'i tanaraaui rongoiusuri ana'i 'anai hatora'ini'i tanaraaui sae. ");
INSERT INTO aia_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma ra'i gere ii'a ro'u narau to'ora'i. Mia Jisas 'a ha'atee ha'agorohia God 'ini'i ma haa'i tanaraaui rongoiusuri 'anai hatora'ini'i ro'u tanaraaui sae. ");
INSERT INTO aia_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Mana nei ra ngau 'a 'onaai hai merui sae. Rau ngau marau masu goro. Na'i muri raugu ha'ahonuai biu abira raha 'ini'i dorai mahoingau ra ngau tahi'i. Naasi mia Jisas 'agu ha'a-taariraau aho'i sae. ");
INSERT INTO aia_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ma ta'e ara'a na'i ora beiraaui rongoiusuri ana'i marau 'ari na'i distrik ra 'unua 'iniai Dalmanuta. ");
INSERT INTO aia_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ra'i Farisei ra boi beia Jisas marau taraawa'a heiraeraesi beia 'inia rau raba ha'imaania. Rau 'unua tanaa Jisas 'anai haa ta ha'abu'oahu 'anai ha'ata'inia tanaraau 'onaa 'ia God ha'a-momori na haa tanaai mena. ");
INSERT INTO aia_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","'Ia Jisas 'a osimaro ma o'ani, “'Ini 'uaana na 'imoou mou raba re'ia ta ha'abu'oahu 'anai ha'ata'inia do'inau 'au boi baania God? Wai 'unua ha'a-momori tana'amou, 'a bwa'i ha'abu'oahu na wai haa tana'amou!” ");
INSERT INTO aia_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ma hano baaniraau, 'a ta'e ara'a aho'i na'i ora marau tahamora aho'i 'ari nata bataraui kae bwera i Galili. ");
INSERT INTO aia_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","'Oha rau 'ari wou mau suriai wai, 'iraaui rongoiusuri raugu 'iraraa do rau kaku'aai waa'i tadaa'i bredi. 'E ta'i huai bredi moi na rau to'oraa. ");
INSERT INTO aia_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","'Ia Jisas 'a ha'abasuraau o'ani, “Moi 'ome'ome goro mamoi 'omesuri'amou baaniai draebam adaaui Farisei mea Mwaeraha Herod.” ");
INSERT INTO aia_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","'Iraaui rongoiusuri rau maania haariraaui mahosi marau o'ani, “Gau ai'a to'o bredi na 'unua o'asi 'iniasi.” ");
INSERT INTO aia_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","'Ia Jisas 'a 'iraraai taha na rau maania ma ha'atee o'ani 'iniraau, “'A 'ua mou hadanga'inia 'iniai ai'a to'o bredi amoou? Mou ai'a aidangisia mau? Mou ai'a aidangisia 'inia ra baabaui tahingamoo'i! ");
INSERT INTO aia_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Mou to'o maa, ma 'ua namou ai'a 'ome 'iraraa 'inia? Ma mou to'o karinga, ma 'ua namou ai'a rongo 'iraraa 'inia? 'A 'ua? Mou kaku'aa'a i 'oha nau uubiai rima huai bredi tanaai rima merui sae ani? 'E siha abira na mou ha'ahonua 'ini'i dora na rau ngau tahi'i?” Marau aramia o'ani, “'E ta'i tangahuru mana rua.” ");
INSERT INTO aia_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Maagu songa'iniraau ro'u o'ani, “Ma na'i 'oha nau uubiai biu huai bredi tanaai hai merui sae ani, 'e siha abira na mou ha'ahonua 'ini'i dora na rau ngau tahi'i?” Marau aramia o'ani, “'E biu abira.” ");
INSERT INTO aia_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma o'ani 'iniraau, “'A 'ua? Mou ai'a aidangisia ro'u mau? Hoita, moi wai'ado'ado goro 'ini'i maho nau 'unu'i 'isi!” ");
INSERT INTO aia_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Rau ataha mai na'i Betsaeda, ma ra'i sae rau waia mai sae na kuru. Marau bonga'inia Jisas do'ai karohiai saesi mai 'ome'ome aho'i. ");
INSERT INTO aia_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","'Ia Jisas 'a dau na'i rimana ma urua hura'a baaniai 'omaasi. Ma ngisuhi'i maanai saesi, 'a karohi'i ma o'ani 'inia, “'A 'ua? Ra'i maho na'o re'i'i?” ");
INSERT INTO aia_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mana saesi 'a wana ara'a ma o'ani, “'Au re'i'i sae maragu 'ome 'onaai'i hasi'ei nara hahano hairiu.” ");
INSERT INTO aia_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","'Ia Jisas 'a karohi'i ro'u i maanai saesi. Mana saesi 'a wanawana wetewete. Ma na'i 'ohasi, 'agu 'ome'ome aho'i ma matai 'ome 'irara'i goro hako aho'i mwani maho. ");
INSERT INTO aia_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mia Jisas 'a ha'atee wetewete tanaa o'ani, “'Oi 'ari odo-odo aho'i ruma amua. 'Oigu abui siri aho'i'a i 'omaa 'anai to'o taroha'inia 'ari taha na to'o tana'o.” ");
INSERT INTO aia_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mia Jisas mana rongoiusuri ana'i rau 'ari suri'i gere 'omaa gaarangiai 'omaa raha i Sisaria Pilipae. 'Oha rau 'ari wou mau suriai tara, 'ia Jisas 'agu songa'iniraau o'ani, “'A 'ua? 'Iraaui sae, rau 'unua do 'inau 'iatei?” ");
INSERT INTO aia_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Marau ha'atee o'ani, “Rau 'unua do i'oe 'e nei na mae na suruta'e aho'i. Tara'i nei ra 'unua do i'oe a Jon Bwareomaea. Ma tara'i nei ra 'unua do i'oe naasi a Rarabea Elaija ma tara'i nei ro'u ra 'unua do i'oe 'e Rarabea mau mai na'i na'o.” ");
INSERT INTO aia_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mia Jisas 'a o'ani 'iniraau, “Mi'amou mou 'adoma'inia do 'inau 'iatei?” Mia Pita 'a o'ani, “I'oe naasi Ha'atahi na 'ia God na duruduru 'inia 'anai ha'ataaria mai.” ");
INSERT INTO aia_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mia Jisas 'a o'ani, “Moi abui 'unua'a ro'u tanaa ta sae do 'inau a tei!” ");
INSERT INTO aia_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na'i 'ohasi 'ia Jisas 'a taraawa'a ha'ausuriraau ro'u i rongoiusuri ana'i. 'A o'ani, “'Inau, i Garei Inoni, rai ha'a-rongomaata'iau di'u. 'Iraaui Na'ohadaa'i Piriisi miraaui Ha'ausuri 'anai Ringe ana'ia Moses ma tara'i saemaua ro'u rai 'utaiau marai ha'amaesiau. Ma 'e rua dangi nai hako mana'i oruna, waigu suruta'e aho'i.” ");
INSERT INTO aia_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","'Oha 'ia Jisas 'a mamaani tanaraau, ai'a girua ta ta'i maho baaniraau. Mia Pita 'a waia beira'i a Jisas ma ha'atee ha'abwarasia. ");
INSERT INTO aia_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mia Jisas 'a rihota'i ma wanasiraaui rongoiusuri ana'i magu ha'atee wetewete o'ani tanaa Pita, “Saetan, hora wou baaniau! Maho na'o 'unu'i 'isi, ai'a 'ado'adona God, ma'ata ra'i 'ado'ado ni noni moi!” ");
INSERT INTO aia_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","'Ia Jisas 'a 'unuraau mai sae rago miraaui rongoiusuri ana'i ma ha'atee o'ani 'iniraau, “'Iatei na raba ha'i rongoiusuri agua, 'ai nugasiai hei'irisina haaria, 'ai mwa'emwa'e 'anai suru'iai dadaahoro ana, maai suriau. ");
INSERT INTO aia_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","'Ia tei na raba dau baabau na'i tahingana na'i marewanani, 'a bwa'i to'oraai huunai tahi. Me 'ia tei na mwa'emwa'e 'anai ha'a-ai'aai tahingana 'iniai suriau ana mana Taroha Goro, 'ai to'oraa nana i tahi. ");
INSERT INTO aia_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","'A 'ua? 'Onaa tanei 'ai to'ora'i hako nana i mwani maho na'i marewana, ma bwa'i daua nana i huunai tahi, mareho 'isi rai 'a'auhia? 'A bwa'i! ");
INSERT INTO aia_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","'Onaa 'ai mae, 'a bwa'i maho 'isi naigu haua 'anai horia aho'i tahingana. ");
INSERT INTO aia_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“'Inau na Garei Inoni, wai boi aho'i mau ta 'oha beiraaui enjel ana'ia God beiai mena mana raraha na ta'isada beia amagu. Mana 'oha wai boi, waigui 'utairaaui nei ra ora-ora'a nara ninimata'iniau na'i 'ohani. Ma wai 'utairaau ro'u i nei ra ninimata'i taroha'ini'i ha'atee agu'i.” ");
INSERT INTO aia_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mia Jisas 'a ha'atee o'ani ro'u 'iniraau, “Wai 'unua ha'a-momori tana'amou: Tara'i nei 'ini'amou 'ini moi awa tari mau 'anai 'omesia God 'oha nai marungiraaui noni beiai mena.” ");
INSERT INTO aia_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","'E ono dangi na hako, 'ia Jisas 'a waia Pita, Jems, mea Jon, 'anai ta'eha haariraau na'i hunganai hungahunga ahaaha. 'Oha narau awa 'isi, raugu 'asu'a i waira orusi mana 'omehana Jisas 'a orisi'a, ");
INSERT INTO aia_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","mana to'oni ana 'a mamaahui wadowado. ");
INSERT INTO aia_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na'i 'ohasi, rau 'omesiai ha'amaranga ana Moses mea Elaija, mararu mamaani beia Jisas. ");
INSERT INTO aia_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mia Pita 'a ha'atee o'ani 'inia Jisas, “Saemaua, 'a goro nagau awa 'ini! Mei ha'a-urasia ta oru hare, 'e ta'i tana'o, 'e ta'i tanaa Moses, ma ta ta'i tanaa Elaija.” ");
INSERT INTO aia_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","'Ia Pita 'agu to'o ha'atee o'asi moi, suria rau kae mamaa'u di'u. ");
INSERT INTO aia_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Raugu 'ome ma'e rorodo na dio huniraau ma marumarusiraau. Na'i 'ohasi rau rongoai ringe na ao mai baaniai rorodosi, 'a o'ani, “Naani garegu nau ta'ahia. Moi rongosuria!” ");
INSERT INTO aia_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Raugu 'ome'ome hairiu, mia Moses mea Elaija raugu ai'a 'omesirarua'a, 'iia moia Jisas naraugu re'ia. ");
INSERT INTO aia_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","'Oha 'ia Jisas mana oru rongoiusuri ana rau dio mau na'i hungahunga, 'ia Jisas 'a ha'atee wetewete tanaraau. 'A o'ani, “Moi abu maani'i tanaa ta sae i mareho na mou re'i'i, tari 'oha 'inau, na Garei Inoni, wai suruta'e aho'i baaniai mae.” ");
INSERT INTO aia_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Miraau araisuriai taha na 'unu'i tanaraau. Ma'ata ra kakui ahudaa'i 'iniai 'ado'ado 'anai suruta'e aho'i. Maraugu taraawa'a heisonga'i hairiu 'inia. ");
INSERT INTO aia_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Rau songa'inia o'ani a Jisas, “'A 'ua na 'iraaui Ha'ausuri 'anai Ringe ana'ia Moses rau 'unua 'inia do'ia Elaija 'ai boi na'i na'o, maigui boi Ha'atahi?” ");
INSERT INTO aia_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ma aramiraau o'ani, “'A ha'a-momori. 'Ia Elaija 'ai boi na'i na'o 'anai ha'aagauraaui mwani noni 'anai boi anai Ha'atahi. Ma'ata 'inau wai 'unua tana'amou. 'Ia Elaija 'a bwane boi'a, miraaui sae rau haa'i here nara ai'a goro tanaa 'onaai 'unua ada na'i Usu-usu Maea. 'Onaa na Usu-usu Maea 'a 'unua o'asi, moi wai'ado'ado goro 'ini'i maho na wai 'unu'ini. 'A 'unua ro'u do 'inau, na Garei Inoni, wai rongomaata'i di'u marai 'utaiau.” ");
INSERT INTO aia_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","'Oha 'ia Jisas mana oru rongoiusuri rau taha dio mai baaniai hungahunga, rau 'omesiai kae ruruhai noni ra garigariraaui rongoiusuri. Ma tara'i nei 'iniraaui Ha'ausuri 'anai Ringe ana'ia Moses ra heitohetohe be'iniraaui rongoiusuri. ");
INSERT INTO aia_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","'Oha 'iraaui sae 'isi rau re'ia Jisas, rau heimwaota'i di'u marau 'eba 'anai heito'oi beia. ");
INSERT INTO aia_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","'Ia Jisas 'agu songa'iniraaui rongoiusuri ana'i o'ani, “'E taha mou heitohetohe-nga'inia?” ");
INSERT INTO aia_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma'e ta'i nei 'iniraau na'i ruruhasi 'a aramia o'ani, “Ha'ausuri, 'au waia mai tana'o i garemwane agua na adaro 'a bwaunia maagu ai'a ha-ha'atee'a. ");
INSERT INTO aia_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","'Oha na adaro 'a bwaunia, 'a 'onaai sae na manumanu'a. 'A ha'a-ngadingadi'i rihona ma ngadia hakoi abena. 'Au 'unua tanaraaui rongoiusuri amu'i dorai taariai adaro baania maraugu bwarai taaria hura'a.” ");
INSERT INTO aia_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Naasi mia Jisas 'a o'ani 'iniraau, “'I'amou inoni 'ohani, mou bwarai hinihini! 'Ai orea he'uai maratanoa nawai haua bei'amou, ma'ua wai awa orea tari he'ua bei'amou mamoigu hinihini? Mou waia mai garesi!” ");
INSERT INTO aia_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Marau waia 'ari tanaa Jisas. Ma na'i 'oha na adaro 'a re'ia Jisas 'a 'idira'iniai garesi, ma ahoda dioi ano. Ma buriburi 'ari na'i ano mana hutohuto ra hura'a na'i ngoona. ");
INSERT INTO aia_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mia Jisas 'a songa'iniai amanai garesi, “'A orea he'ua'a i bwaunia na haua i adaro?” Mia amanai garesi 'a aramia o'ani, “Taraawa'a mau mai 'oha na kekerei'a. ");
INSERT INTO aia_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Rago'a i 'oha na adarosi 'a gaasia ara'a na'i 'eu mana ha'adodohia na'i wai 'anai ha'amaesia. 'Onaa 'ai mwada'u, Araha, 'oi 'a'auhi'ameu.” ");
INSERT INTO aia_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Mia Jisas 'a o'ani 'inia, “Ni 'uaana na'o 'unua 'inia dona ‘'Onaa 'ai mwada'u?’ Mwane maho rai mwada'u tanaai nei na hinihinia God!” ");
INSERT INTO aia_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma na'i mau 'ohasi, na amanai garesi 'a ha'atee raha ma o'ani, “'Inau 'au hinihini moi, maagu ai'a raha i hinihinigu. 'Oi 'a'auhiau mai wetewete i hinihinigu!” ");
INSERT INTO aia_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","'Ia Jisas 'a 'ome 'irararaaui sae ra taraawa'a ruru mai beia, maagu ha'atee hurasi o'ani tanaai adaro, “Adaro na'o ha'apwarongo'i mo'o ha'abanguu'i sae, 'oi hura'a baaniai gareni ma'oi abui siri'a ro'u beia ta'oha!” ");
INSERT INTO aia_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mana adaro 'a awara raha ma 'idira'inia ha'atai garesi maagu hura'a baania. 'Iraaui sae ra 'unua'a dona garesi 'a mae'a 'inia 'a dadao hatara'i moi. ");
INSERT INTO aia_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mia Jisas 'a dau wou na'i rimana ma ha'a-suruta'ea maagu ura ara'a. ");
INSERT INTO aia_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na'i murina, 'ia Jisas mana rongoiusuri ana'i rau 'ari aho'i ruma. Ma na'i 'oha rau awa haariraau raugu songa'inia Jisas o'ani, “'A 'ua na bwara 'inia tana'ameu 'anai taaria hura'a i adaro ani?” ");
INSERT INTO aia_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mia Jisas 'a o'ani 'iniraau, “Ha'arahesi moi na matai taari'i hura'a i adaro ta'a'i o'asi.” ");
INSERT INTO aia_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","'Ia Jisas miraaui rongoiusuri ana'i rau hano baaniai dorasi marau 'ari daara'i suri'i 'omaa na'i Galili. 'Ia Jisas 'a ai'a rabasia tanei nai 'iraraai dora na awa iei, ");
INSERT INTO aia_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","'inia 'a ha'ausuriraaui rongoiusuri ana'i 'iniai taha na rai to'o tanaa. 'A ha'ausuriraau o'ani, “'E nei nai usuha'iniau i Garei Inoni tanaraaui nei narau ha'imae beiau marai ha'amaesiau. Ma 'e rua dangi nai hako mana'i oruna, wai suruta'e aho'i baaniai mae.” ");
INSERT INTO aia_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Miraau ai'a 'adoma'i tarihanai 'ado'ado 'anai mamaani ana, marau maguguta'i songa'inia ro'u 'anai ha'a-aidangisiraau 'inia. ");
INSERT INTO aia_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Rau taha mai 'omaai Kapaniam ma na'i 'oha rau siri na'i ruma, 'ia Jisas 'a songa'iniraaui rongoiusuri ana'i o'ani, “'E taha mou hadanga'inia ani, 'oha gau boi suriai tara?” ");
INSERT INTO aia_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Miraau ai'a aramia, 'inia na'i 'oha rau boi suriai tara, rau hadanga'inia tei 'iniraau na ororiu di'u. ");
INSERT INTO aia_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","'Ia Jisas 'a heinagu auru ma 'unuraau mai gaarangi rongoiusuri ana'i ma ha'atee o'ani 'iniraau, “'Ia tei na raba ha'i sae ororiu 'ini'amou, 'ai ha'a-anoanoa mai mwa'emwa'e 'anai 'a'auhia namoiwou tanei 'ini'amou.” ");
INSERT INTO aia_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mia Jisas 'a waia mai gare kekerei, 'a ha'a-urasia na'i maadaau hako ma abea maagu ha'atee o'ani, ");
INSERT INTO aia_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“'Onaa 'o ha'amaotoa ta nei 'onaai gareni suria 'o ta'ahiau, i'oe 'o ha'amaotoau ro'u. Ma 'onaa 'o ha'amaotoau, 'o ai'a ha'amaotoau moi, mia ro'ua God na ha'ataariau mai.” ");
INSERT INTO aia_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Mia Jon 'a ha'atee o'ani 'inia, “Ha'ausuri. Meu re'iai sae na taari'i adaro hura'a baani'i sae 'iniai atamu mameu ha'aabua, 'inia 'iia ai'a ta'i 'iniai ruruha agaau.” ");
INSERT INTO aia_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mia Jisas 'a o'ani 'iniraau, “Moi abui ha'aabua. 'Onaa 'e nei nai haa'i ha'abu'oahu 'iniai atagu, 'agu bwa'i 'asu'ani ha'atee ha'ata'aiau moi. ");
INSERT INTO aia_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","'Inia 'ia tei na ai'a ura bwarasigaau, 'iiasi 'e aba 'iniai ruruha agaau. ");
INSERT INTO aia_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ha'amomori! Wai 'unua tana'amou: 'Ia tei na 'a'auhi'amou 'inia ta gere maho, 'onaai ha'a-gonohi'amou, 'inia 'a 'iraraa do 'imoou mou ta'ahiau, 'ai daua nana i heitahari.” ");
INSERT INTO aia_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mia Jisas 'a ha'atee o'ani ro'u, “'Onaa 'ia tei sae nai raba ha'atehaa ta nei 'iniraaui nei kekerei 'ini narau hinihiniau, 'a goro do ra ga'i ho'osia ta kae hau na'i 'u'una marai hura'a ha'adodohia na'i asi rodo. 'Inia na ha'a-mama'ai na 'ia God nai haua tanaai nei nai ha'atehaa tanei 'iniraau, 'ai ta'aa di'u ro'u wou. ");
INSERT INTO aia_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Hoita, 'onaa na rimamu nai haai maho na'o ora-ora'a 'inia, 'oi horo gaasinga'inia. 'O gasi to'oraai rua rimamu ma'ogui siri na'i dora-ni-rongomaata'i. Na'i dorasi na uro ra bwarai mae mana 'eu 'a bwarai kuru. 'A goro baania do'oi dauai tahi tarau beia moi ta'i rima. ");
INSERT INTO aia_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma 'onaa na uwamu nai haai maho na'o ora-ora'a 'inia, 'oi horo gaasinga'inia. 'O gasi to'oraai rua uwamu maraigui gaasi'o na'i dora-ni-rongomaata'i. Na'i dorasi na uro ra bwarai mae mana 'eu 'a bwarai kuru. 'A goro baania do'oi dauai tahi tarau beia moi ta'i uwa. ");
INSERT INTO aia_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Ma 'onaa na maamu nai haai maho na'o ora-ora'a 'inia, 'oi suki gaasia hura'a. 'O gasi to'oraai rua maamu ma ragui gaasi'o na'i dora-ni-rongomaata'i. Na'i dorasi na uro ra bwarai mae mana 'eu 'a bwarai kuru. 'A goro i awa tarau na'i heimarungi ana God beia moi ta'i maa baaniai siri na'i dora-ni-rongomaata'i beiai rua maa hako. ");
INSERT INTO aia_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Naasi, 'ia God 'ai ha'ausuriraaui sae ana'i 'ini'i rongomaata'i nara siri suri'i na'i marewana. Mia God 'ai ha'a-mama'airaaui nei nara ai'a suria na'i 'eu na bwa'i kuru'a ro'u ta 'oha. ");
INSERT INTO aia_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“'Io, solt 'a goro 'anai ha'angaugoroai mahoingau. Me 'onaa 'aigu ai'aa i asi'ahana, ma naasi 'agu bwa'i here'a ro'u naraigui haua 'anai ha'a-asi'aa ro'u. 'A o'asi ro'u, 'onaa mou awa heihoa na'i tahingamoo'i 'a 'onaai solt na ai'aai gorohana. Naasi moi awa hagu goni goro!” ");
INSERT INTO aia_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mia Jisas mana rongoiusuri ana'i rau hano baaniai Kapaniam. Rau ataha wou na'i Provensi Jiudea marau 'ari 'anai nata bataraui wai Jodan. Ma ra rago ro'u i sae nara boi beia Jisas, maagu ha'ausuriraau ro'u 'onaai bwane hahaua ana. ");
INSERT INTO aia_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tara'i Farisei ra boi beia Jisas, 'inia rau raba ha'imaania 'onaa na heiarami ana 'a ta'isada beiai Ringe ana'ia Moses. Marau songa'inia o'ani, “'Oi 'unua tana'ameu. 'A 'ua? Na Ringe ana'ia Moses ra ha'awatea moi dona sae 'ai matai gaasiai urao ana?” ");
INSERT INTO aia_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mia Jisas 'a aramiraau ro'u 'iniai heisonga'i. 'A o'ani, “'E taha na ringeringe ana Moses 'a 'unua 'iniai haigaasi?” ");
INSERT INTO aia_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Miraau o'ani 'inia, “'Ia Moses 'a ha'awatea moi sae ha'iwai 'anai gaasiai urao ana, 'onaa 'ai haua ga'u na'i na'o ta usu-usu ni haigaasi.” ");
INSERT INTO aia_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mia Jisas 'a o'ani, “'Ia Moses 'a haua tana'amoui ringeringesi suria mou rongoasa mamou ai'a raba araisuriai Ha'atora ana God. ");
INSERT INTO aia_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Na Usu-usu Maea 'a o'ani, ‘'Oha 'ia God 'a ha'apwa'araai marewana, 'a ha'apwa'araai mwane mana urao. ");
INSERT INTO aia_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Na tarana naasi, na mwane 'ai nugasia amana mea inana maai hasi beiai urao ana, ");
INSERT INTO aia_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mararui ha'i ta'i abe. Naasi, 'irarua rarugu ai'a 'onaaia'a i rua abe, ma'ata 'e ta'i abe moi.’ ");
INSERT INTO aia_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na tarana naasi, na noni 'ai abui hoaiai taha na 'ia God na ho'ogonia.” ");
INSERT INTO aia_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","'Ia Jisas mana rongoiusuri ana'i rau aho'i 'ari ruma. Miraaui rongoiusuri rau songa'inia ro'ua Jisas 'ini'i 'ado'ado 'ada'i maho 'isi. ");
INSERT INTO aia_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mia o'ani 'iniraau, “'Onaa ta mwane nai gaasiai urao ana ma waina ro'u i urao he'ete'i, 'iia 'a taritari'a baaniai urao ana. ");
INSERT INTO aia_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma ro'u, 'onaa 'e urao na gaasiai mwane ana ma waina ro'u i mwane he'ete'i, 'iia 'a taritari'a ro'u baaniai mwane ana.” ");
INSERT INTO aia_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ra'i sae ra waa'i mai gare tanaa Jisas do'ai karohiraau maai ha'atee ha'agorohiraau. Me 'iraaui rongoiusuri ana'i rau ha'a-aburaaui sae 'isi. ");
INSERT INTO aia_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","'Oha 'ia Jisas 'a 'iraraa o'asi, 'a taesu'a 'adaaui rongoiusuri ana'i ma o'ani 'iniraau, “Moi abui ha'a-bwarasiraau. Moi wateraaui gare marai boi beiau. 'Inia 'iraaui nei ra 'onaairaausi, naasi nei nara arari 'anai siri na'i heimarungi ana God. ");
INSERT INTO aia_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","'Inau wai 'unua ha'a-momori tana'amou: 'Ia tei na bwa'i 'u'uria God 'onaai gare, 'a bwa'i awa bahainai heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mia Jisas 'a wairaau mai gare beia ma aberaau. 'A nugaai rimana na'i hungadaau ma ha'atee ha'agorohiraau. ");
INSERT INTO aia_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","'Oha na taraawa'a hano ro'ua Jisas mana rongoiusuri ana'i, 'e sae na 'eba mai ma topira'i ruru tanaa Jisas ma o'ani, “Ha'ausuri! I'oe 'e sae goro! 'E taha nawai haua nawai daua 'inia i tahi tarau?” ");
INSERT INTO aia_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","'Ia Jisas 'a aramia o'ani, “Ni 'uaana na'o 'unua 'inia do 'inau 'au goro? Ai'a tanei do 'ai goro, me 'iia moi a God. ");
INSERT INTO aia_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","I'oe 'o bwane aidangisi'i'a i Ha'atora: Abui ngahu ha'amaesiai sae; abui taritari'a baaniai urao amua ma'ua mwane amua; abui beri; abui pwari'i na'i kooti; abui ha'a-bweubweu'aai sae 'iniai maho na to'oraa; ma'oi ha'ahoua amamu mea inamu.” ");
INSERT INTO aia_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mana saesi 'a o'ani, “Ha'ausuri, na mwane mareho 'isi 'au bwane ha'isuri'i mau mai na'i 'oha nau kekerei.” ");
INSERT INTO aia_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mia Jisas 'a wana to'obuu 'inia ma ta'ahia maagu o'ani, “'E ta'i mareho na i'oe 'o ai'a haua mau. 'Oi 'ari ma'oi raonga'ini'i hakoi mareho na'o to'ora'i ma'oi hauai ha'a tanaraaui sae pohara. 'Onaa 'oi haua o'asi, 'oi toto'ora na'i aro. Na'i muri 'oigui boi suriau.” ");
INSERT INTO aia_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","'Oha na rongoa, maagu 'ome ahutotou'a. Ma hano'a ha'i ahutotou, 'inia 'iia 'e sae na toto'ora di'u. ");
INSERT INTO aia_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","'Ia Jisas 'a wanasiraau hairiu i sae ma o'ani 'iniraaui rongoiusuri ana'i, “'Ai bwara di'u tanaraaui sae ra toto'ora 'anai siri na'i heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","'Iraaui rongoiusuri ana'i rau heimwaota'i di'u 'ini'i maho na 'unu'isi. Mia Jisas 'a o'ani ro'u 'iniraau, “Mwani sae agu'i, 'a bwara di'u 'anai siri na'i heimarungi ana God! ");
INSERT INTO aia_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","'A 'ua? I mwamwaa nara 'unua 'iniai kamel 'a matai siri daara'i na'i maanai nira? 'A bwara! Ma bwara di'u ro'u wou tanaai nei na toto'ora 'anai siri na'i heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na'i 'oha rau rongoa o'asi rongoiusuri, raugu heimwaota'i di'u marau ha'atee o'ani, “Romwane, 'onaa na o'asi, 'a 'ome 'onaa do 'a bwa'i ta sae nai dauai tahi tarau!” ");
INSERT INTO aia_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mia Jisas 'a wanasiraau ma o'ani, “Beiai noni 'a bwarai daua haariraaui tahi tarau, mei beia God 'a ai'a maho i bwara tanaa, 'inia tanaa God mwane maho ra mwada'u moi.” ");
INSERT INTO aia_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mia Pita 'a o'ani 'inia, “'Ome! 'I'ameu meu nugasi'i hakoi mwane maho amee'i mameu suri'o!” ");
INSERT INTO aia_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Mia Jisas 'a o'ani 'iniraau, “'Au 'iraraana. 'Inau wai 'unua ha'a-momori tana'amou: 'Ia tei na nugasi'i mwane mareho ana'i 'inia 'a suriau mana Taroha Goro, 'iia 'ai dau'i mwani mareho di'u'i mareho na nugasi'i 'isi. 'Onaa 'ai nugasiai ruma ana ma'ua do'orana'i, asina'i, amana, inana, gare ana'i ma'uai dorai ano ana, 'ia God 'ai huunai ha'agorohia. Ma na'i marewana 'ai ha'arago'i tanaai mwani maho 'isi. Me 'iraaui sae rai ha'a-mama'aia ro'u! Ma'ata na'i madoraa nai boi mau, 'aigui daua nana i tahi tarau. ");
INSERT INTO aia_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma naasi, 'a ragoi nei nara ororiu na'i 'ohani, rai ha'i sae haari'i moi. Ma ragoi nei ra ai'a ororiu na'i 'ohani, 'ia God 'ai ha'a-ororiu'araau.” ");
INSERT INTO aia_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","'Oha rau suriai tara na ta'eha 'anai Jerusalem, 'ia Jisas 'a hano na'i na'o 'iniraaui rongoiusuri ana'i. 'Iraaui rongoiusuri ana'i rau heimwaota'i di'u 'inia, miraaui sae ra haisuri ra mamaa'u. Jisas 'a wairaau haariraau ro'u i rongoiusuri ana'i ma maani'i tanaraaui taha na rai to'o mau tanaa. ");
INSERT INTO aia_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","'A o'ani 'iniraau, “Moi bahurongo goro. Na'i 'ohanisi gau hahano'a 'anai Jerusalem. Maagu na'i 'isi, 'e nei nai usuha'iniau i Garei Inoni tanaraaui Na'ohadaa'i Piriisi mana Ha'ausuri 'anai Ringe ana'ia Moses. Rai hiiriau 'anai ha'amaesiau marai usuha'iniau ro'u tanaraaui nei ra ai'a Jiu. ");
INSERT INTO aia_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Rai haikou 'iniau marai ngisuai abegu marai rorohoau maraigu ngahu ha'amaesiau. Ma'ata 'e rua dangi nai hako mana'i oruna, wai suruta'e aho'i baaniai mae.” ");
INSERT INTO aia_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","'Ia Jems mea Jon rua garena Sebedi, raru boi beia Jisas ma raru ha'atee o'ani 'inia, “Ha'ausuri, 'e ta'i maho na miri 'irisia do'oi haua tana'amiria.” ");
INSERT INTO aia_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mia Jisas 'a songa'inirarua o'ani, “'E taha muru rabasia?” ");
INSERT INTO aia_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma rarugu aramia o'ani, “Na'i madoraa na'oi mwaeraha ma'oi marungiraaui noni, miri raba heimarungi bei'o. Tanei nai heinagu na'i dora ni mwaeraha na'i aba odomu ma tanei na'i maha.” ");
INSERT INTO aia_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mia Jisas 'a o'ani 'ini'ararua, “'I'amurua muru ai'a aidangisiai maho na muru ha'angoniasi. 'A 'ua? Muru ga'i siri moi na'i rongomaata'i na 'inau wai siri iei? Ma muru ga'i matai mae moi 'onaai mae na wai haua?” ");
INSERT INTO aia_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Miraru aramia Jisas o'ani, “Miri ga'i haa moi!” Mia Jisas 'a o'ani ro'u, “Ha'amomori di'u. Murui rongomaata'i ha'a-momori 'onaai rongomaata'i na 'inau wai haa ma murui mae moi 'onaai mae na wai haua. ");
INSERT INTO aia_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma'ata 'inau 'au bwa'i sigihia 'iatei nai heinagu na'i odogu ma'ua na'i mahagu. 'Iia moi a God nai 'unua 'iatei nai heinagu beiau. 'Inia 'iia 'a bwane 'ome sigihiraau.” ");
INSERT INTO aia_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","'Oha 'iraaui nata tangahurui rongoiusuri ana'ia Jisas rau rongoai mahosi, rau taesu'a di'u 'ana Jems mea Jon. ");
INSERT INTO aia_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mia Jisas 'a 'unuraau hako mai beia, ma o'ani 'iniraau, “Mou bwani 'iraraa doni mwaeraha mana na'otara adaa'i sae ra ai'a Jiu, rau ha'aba'o 'iniai heimarungi narau haua ma goro adaau i haa'i mwani heiatenga'i tanaraaui noni. ");
INSERT INTO aia_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma'ata 'ai abui o'asi bei'amou. 'Ia tei nai raba na'otara tana'amou, 'iia 'ai ha'i sae tatau'aro tana'amou. ");
INSERT INTO aia_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mia tei na raba bwauodo, 'ai ha'i slev tana'amou hako. ");
INSERT INTO aia_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Moi ha'isuriai herehere agua. 'Inaui Garei Inoni 'au ai'a boi do 'irai sae rai tau'aro tanaau. Me 'inau 'au boi do 'inau wai tau'aro tanaraau, ma 'anai wateai tahingagu 'anai ha'atahiraau baaniai ora-ora'a.” ");
INSERT INTO aia_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas mana rongoiusuri ana'i rau tahai 'omaai Jeriko. Ma na'i muri, 'oha rau hura'a baaniai 'omaasi, 'a ragoi sae ra suriraau. Ma'e sae na kuru na atana 'ia Batimeas 'a heheinagu na'i bobonai tara, 'iiasi 'e garena Timias. 'Iia 'a heinagu 'isi'a 'anai ha'angoni ha'a beiraaui noni rau tatahahoro na'i tarasi. ");
INSERT INTO aia_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na'i 'oha na 'iraraa do 'ia Jisas, 'e sae ni Nasaret na boi na'i tarasi, 'agu taraawa'a awara raha o'ani, “Jisas, warowarona Deved. 'Oi arunga ta'ahiau ma'oi 'a'auhiau!” ");
INSERT INTO aia_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ragoi sae ra 'unua do 'ai papaku, mia awara raha ro'u baaniai na'o, “Jisas, warowarona Deved, 'oi arunga ta'ahiau ma'oi 'a'auhiau!” ");
INSERT INTO aia_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisas 'a ura papaku ma o'ani 'iniraau, “Moi 'unua mai.” Maraugu o'ani 'inia Batimeas, “'Ai abui ta'aabemu. 'Ia Jisas 'a 'unu'o, 'oi ura ara'a!” ");
INSERT INTO aia_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","'Ia Batimeas 'a rege ara'a ma gaasiai to'oni bo-hura'a ana, ma 'ari beia Jisas. ");
INSERT INTO aia_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisas 'a songa'inia o'ani, “'E taha na'o 'irisia do wai haua tana'o?” Mia aramia Jisas o'ani, “Ha'ausuri, 'au raba wanawana aho'i!” ");
INSERT INTO aia_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mia Jisas 'a ha'atee o'ani tanaa, “'Io, na hinihinimu na ha'agorohi'o. 'Oi 'ari'a.” Na'i mau 'ohasi na sae kurusi 'agu wana. Ma hano beia Jisas suriai tara. ");
INSERT INTO aia_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","'Oha 'ia Jisas mana rongoiusuri ana'i rau gaarangia wou i Jerusalem, rau 'omesia 'ari 'omaai Betfeis mana Betani gaarangiai hungahungai 'Oliv. Mia Jisas 'a ha'a-taarirarua i rua rongoiusuri 'anai 'ari na'o. ");
INSERT INTO aia_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","'A o'ani 'inirarua, “Murui hano mamurui 'ari nai 'omaa 'ariani. Ma na'i 'oha murui taha siri wou, murui re'iai garei dongki nara ho'osia. Na garei dongkisi ai'a ta sae mau nai ta'e na'i hungana. Naasi murui wagasia ma murui waia mai tanaau. ");
INSERT INTO aia_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma 'onaa ta sae nai songa'ini'amurua 'inia tei na 'unua tana'amurua do murui waiai mwamwaasi, murui o'ani 'inia, ‘'Ia Araha na rabasia ma'ai ha'ataaria aho'i raurau moi mai.’” ");
INSERT INTO aia_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","'Oha raru ataha wou, raru re'iai dongki ra ho'osia na'i bobonai maraaruma. Raru 'ariwou ma raru tahamora wagasia, ");
INSERT INTO aia_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ma ra'i sae nara ura 'isi ra o'ani 'ini'ararua, “Eei! 'A 'ua na muru wagasia 'inia i mwamwaasi?” ");
INSERT INTO aia_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mararu 'unu'i maho 'ia Jisas 'a 'unu'i tanararua, maraugu watea tanararuai dongki ma raru hano beia. ");
INSERT INTO aia_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","'Oha raru ataha aho'i beia Jisas, raru rahi'i tara'i to'oni bo hura'a adaru'i ma raru nuga'i na'i hunganai mwamwaasi. Mia Jisas 'a heinagu ara'a na'i hungana. ");
INSERT INTO aia_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ragoi sae ra haa'i bwana bo hura'a adaa'i mara haari'i 'ari suriai tara. Ma tara'i sae ra 'ari mara tabari'i hasi'ei nara hahaa'a mara haari'i hahaadi na'i tara. ");
INSERT INTO aia_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mana sae ra na'o mana nei na'i murina Jisas raugu awaawara, rau o'ani, “Ha'a-aneanea God! Araha God, 'oi ha'agorohia mo'o na'o ha'ataaria mai! ");
INSERT INTO aia_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","God 'oi ha'agorohia mo'oni na boi 'anai mwaeraha agaau 'onaai wauwa ameeu a Deved! Ha'a-aneanea God na'i aro!” ");
INSERT INTO aia_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","'Ia Jisas 'a taha wou i Jerusalem ma siri na'i Ruma Maea ana God ma wanasi'i hako 'ari mwane maho na'i rarona. 'Iia ai'a awa orea, ma 'ari'a i Betani beiraaui rongoiusuri ana'i, 'inia 'a su'urahi'a. ");
INSERT INTO aia_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","'Oha rau aho'i mai baaniai Betani na'i nata dangi, 'ia Jisas 'a hioro. ");
INSERT INTO aia_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma re'ia 'ari urunai hasi'ei ra 'unua 'iniai fig. Rei'uaa na 'iraraa do'a ai'a tari mau i madoraa 'adaaui fig 'anai hungu, 'a 'ariwou 'anai 'ome'ome hua na'iei. 'Inia 'a 'iraraa do na fig 'ai hungu ma'ata'a 'onaa na to'o rawa. Ma na'i 'oha na 'ariwou gaarangi, 'a 'omesia do nai'i moi rawa na re'i'i. ");
INSERT INTO aia_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Naasi mia Jisas 'a ha'atee orohuniai hasi'eisi, 'a o'ani, “'Ogu bwa'i hungu'a ro'u ta 'oha!” Miraaui rongoiusuri ana'i rau rongo'i hakoi maho na 'unu'isi. ");
INSERT INTO aia_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","'Oha rau ataha wou i Jerusalem, 'ia Jisas 'a siriwou na'i dora a'ora na'i maanai Ruma Maea ma taraawa'a taariraau hura'a i sae ra horihori mara raoraonga'i na'iei. 'A rihota'ini'i tebol 'anai ori-orisi ha'a mana baba ni heheinagu adaa'i nei ra raoraonga'i waibora. ");
INSERT INTO aia_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mia Jisas 'a ha'a-abu'i sae nara raba tahahoro bei'i maho na'i kae dora a'ora na'i maanai Ruma Maea. ");
INSERT INTO aia_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Maagu ha'ausuriraaui sae o'ani, “Ra usua o'ani na'i Usu-usu Maea, 'ia God 'a o'ani, ‘Na ruma agua 'e ruma ni ha'arahesi adaau hakoi mwane noni suriai marewana.’ Mi'amou mou ha'i dorani bainihu 'inia nadaaui sae beriberi!” ");
INSERT INTO aia_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Miraau na Na'ohadaaui Piriisi mana Ha'ausuri 'anai Ringe ana'ia Moses, rau rongo to'oana marau taraawa'a siba herehere 'anai ngahuia Jisas. Ma'ata rau magugu ro'u, 'inia ra ragoi sae ra heimwaota'i di'u 'iniai ha'ausuringa'i ana'i. ");
INSERT INTO aia_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ma na'i su'urahi, 'ia Jisas miraaui rongoiusuri ana'i raugu hura'a aho'i baaniai Jerusalem. ");
INSERT INTO aia_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","'Oha rau 'ari wou suriai tara na'i haho'oanai nata dangi, rau re'iai hasi'ei na ha'atee orohunia ania Jisas 'a nugu'a. ");
INSERT INTO aia_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mia Pita 'a hasi 'adoma'i aho'isia ma o'ani 'inia Jisas, “Ha'ausuri, 'ome! Na hasi'ei na'o ha'atee orohunia 'ani 'a nugu'a!” ");
INSERT INTO aia_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mia Jisas 'a o'ani, “Moi hinihinia God! ");
INSERT INTO aia_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","'Inau wai 'unua ha'a-momori tana'amou: 'Ia tei nai hinihini ma bwa'i 'adoma'i heiruarua'a, 'ai matai o'ani 'iniai hungahungani, ‘'Oi sara baaniai dorani ma'oi hura'ai asi!’ Na maho nai 'unuasi 'ai to'o'a 'onaai 'irisia anasi. ");
INSERT INTO aia_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tarana naasi nau 'unua 'inia tana'amou, do 'oha moi ha'angonia ta maho na'i ha'arahesi, moi hinihini do 'ia God 'a bwane haua'a tana'amou. Maigu haua tana'amoui taha mou 'irisia. ");
INSERT INTO aia_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ma na'i 'oha moi ha'arahesi, 'onaa mou taesu'a 'ana tanei, moi 'adoma'i nugasia ga'u, neina Amamoou na'i aro 'ai 'adoma'i nugasi'amou ro'u 'ini'i maho ta'a'i na mou haa'i. ");
INSERT INTO aia_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ma 'onaa mou bwa'i 'adoma'i nugasia, 'ia God na awai aro 'a bwa'i 'adoma'i nugasi'i ro'u i ora-ora'a amoo'i.” ");
INSERT INTO aia_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mana 'oha rau ataha ro'u mai na'i Jerusalem, 'ia Jisas 'a taha ro'u siri na'i Ruma Maea ana God. 'Iraaui Na'ohadaa'i Piriisi miraau Ha'ausuri 'anai Ringe ana'ia Moses ma tara'i saemaua ro'u rau boi beia, ");
INSERT INTO aia_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","marau songa'inia, “'Oi 'unua tana'ameu, 'iatei na 'unua tana'o do'oi matai haa'i mareho 'isi?” ");
INSERT INTO aia_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mia Jisas 'a aramiraau o'ani, “Wai matai aramiai heisonga'i amoou 'onaa moi aramia ro'u i heisonga'i nawai haua tana'amou. ");
INSERT INTO aia_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","'Ia tei na 'unua tanaa Jon 'anai bwareomaearaaui noni? 'Ia God ma'ua inoni?” ");
INSERT INTO aia_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Miraau hadahada haariraau hairiu o'ani, “'E taha nagai 'unua? 'Inia 'onaa nagai 'unua do'ia God, 'iia 'ai 'unua o'ani, ‘Ma 'ua namou ai'a hinihinia 'inia Jon?’ ");
INSERT INTO aia_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma 'onaa nagai 'unua do 'iraau moi inoni nara 'unua tanaa, ra gasi taesu'a inoni.” Rau 'unua o'asi, 'inia rau mamaa'usiraaui sae na rau hinihinia do'ia Jon 'e huunai rarabea. ");
INSERT INTO aia_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Miraau aramia o'ani, “Meu ai'a 'iraraa.” Mia Jisas 'a o'ani 'iniraau, “Nau bwa'i rangasia ro'u tana'amou 'iatei na 'unua tanaau do wai matai haa'i mareho 'isi.” ");
INSERT INTO aia_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na'i 'ohasi, 'ia Jisas 'a maania ro'u tanaraaui saemaua adaa'i Jiu i ha'atee heiha'auuni. 'A o'ani 'iniraau, “'E sae na hasiai moui grep. 'A bara garia ma tagoraai dora 'anai rosirosi grep na'iei 'anai tagora waen. Ma ha'a-urasia ro'u i ruma ahaaha 'anai 'ome'ome 'ini'i maeronga. Na'i muri 'agu sadoi'i sae 'anai tau'aro maedi hua 'anai 'omesuriai mou ma hano na awa na'i kantri he'ete'i. ");
INSERT INTO aia_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Ma na'i 'oha na tari madoraa 'anai husi'i hua, na saesi 'agu ha'ataaria 'ari noni tatau'aro ana 'anai waa mai hua narau ga'i haa'i tanaa baaniai moui grep anasi. ");
INSERT INTO aia_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Na'i 'oha na ataha wou, 'iraaui mwane narau 'omesuriai mousi rau daua marau ngahu ngahua moi, marau ha'ataaria aho'i 'ari ha'i pwaranga. ");
INSERT INTO aia_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","'Ari wou mana nei na to'oraai mou 'a ha'ataaria ro'u i ta'i sae tatau'aro ana 'anai waa mai tanaai hua ana'i. Miraaui sae 'isi rau ngahuia ro'u. Rau ha'amaaraai bwauna mara here ha'ata'aia di'u ro'u. ");
INSERT INTO aia_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","'Ari wou mana nei na to'oraai mou, 'a ha'ataaria ro'u 'ari ta'i sae tatau'aro ana. Miraau sae 'isi rau ngahu ha'amaesia moi. Mwane sae tatau'aro ana'i na ha'ataari'i ra here osia'i hako. Ra'i nei ra ngahu ha'ata'ai'i ma ra'i nei ra ngahu ha'amaesi'i. ");
INSERT INTO aia_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Na nei nagu awa mau 'anai ha'ataaria, naasi huunai gare ana'a na ta'ahia di'u. Naasi'a i sae ha'ahako 'anai ha'ataaria 'ari. Ma 'adoma'inia do 'iia rai ha'ahoua. Naasi, maagu ha'ataaria 'ari. ");
INSERT INTO aia_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“'Oha narau re'ia, rau ha'atee hairiu o'ani, ‘Naasia mo'o naigu to'oraai mousi na'i 'oha nai mae amana. Gau magai ngahu ha'amaesia magai to'oraa nagaau i moui grepisi.’ ");
INSERT INTO aia_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Marau daua, rau ngahu ha'amaesia marau gaasia hura'a baaniai mou.” ");
INSERT INTO aia_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","'Ia Jisas 'agu songa'iniraau o'ani, “Mou 'adoma'inia do'e taha naigu haa i sae na to'oraai mousi. 'Iia 'ai boi, mai ngahu ha'amaesiraau hakoi sae 'isi mai wateai mousi tanaraau tara'i nei ro'u. ");
INSERT INTO aia_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mou ai'a 'oha'inia gasi taha nara usua na'i Usu-usu Maea na o'ani, ‘Na hau na 'iraaui sae tatau'aro ruma rau 'itaa, naia naagu ha'i hau na ororiu di'u na'i bani anai ruma. ");
INSERT INTO aia_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","'Ia Araha God na haua do 'ai o'asi, magau wa'ewa'e di'u 'inia!’” ");
INSERT INTO aia_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na ha'atee heiha'auu ana Jisas 'a to'iraaui saemaua adaa'i Jiu. Rau raba daua Jisas dorai ha'a-mama'aia. Maraugu ai'a haua, suria rau magugu do ra gasigu ha'agogoru i noni. Naasi raugu hano'a baania. ");
INSERT INTO aia_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na'i muri, 'iraaui Farisei mana sae ana'ia Herod ra ha'a-taariraau wou tara'i sae 'anai songa'inia Jisas do neina 'ai ha'atee ha'ata'aiai mwaeraha raha adaaui Rom. ");
INSERT INTO aia_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Rau 'ari wou beia marau o'ani 'inia, “Ha'ausuri, meu 'iraraa dona mwane maho na'o 'unu'i ra odo-odo mara ha'a-momori hako. Ma'o ha'ausuriraaui noni 'ini'i taha 'ia God na 'irisiai noni 'anai haa. Ma na'i 'oha na'o ha'ausuriraau, rei'uaa na 'e sae he'ua nara bahurongo'o, mana ha'ausuringa'i amu'i ra ta'isada moi. Hoita, 'oi 'unua tana'ameu, 'A 'ua? Na'i ringeringe agaau, 'a odo-odo dogai hori takisi tanaai mwaeraha raha na'i Rom ma'ua ai'a?” ");
INSERT INTO aia_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","'Ia Jisas 'a bwane 'iraraa do rau raba ha'imaania, maagu o'ani, “Ni 'uaana na mou raba ha'a-bweubweu'aau 'anai 'unuai maho na taritari'a? Moisu waa mai ta korai ha'a ma wai re'ia!” ");
INSERT INTO aia_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Marau waa wou tanaai korai ha'a, maagu songa'iniraau o'ani, “I atana tei mana nununa tei na awa na'i korai ha'ani?” Miraau aramia o'ani, “Na atanai Mwaeraha adaaui Rom mana nununa.” ");
INSERT INTO aia_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mia Jisas 'a o'ani 'iniraau, “'Onaa na o'asi mamoi haua tanaai Mwaeraha i taha 'iia na to'oraa, mamoi haua tanaa God taha 'ia God na to'oraa.” Miraaugu heimwaota'i di'u 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma na'i muri, ra'i Sadiusi ra boi beia Jisas. 'Iraausi rau ai'a hinihinia do 'iraaui noni rai suruta'e aho'i baaniai mae, miraau songa'inia Jisas o'ani, ");
INSERT INTO aia_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ha'ausuri, 'ia Moses 'a nugaai Ha'atora tanagaau do 'onaa 'e sae ha'iwai nai mae baaniai urao ana mararu ai'a to'o gare, na do'orana 'ai orisia, maai waina ro'u i uraosi. Mana gare na rarui to'ora'i, rai 'unu'i 'ini'i gare ana'i do'orana na maesi, neina burungana 'a bwa'i matai hako.” ");
INSERT INTO aia_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“'E heiha'auu naani. 'E ta'i 'oha 'e biu ha'ido'orada narau awa wou, mana gare na hutai na'o 'a ha'iwai. Raru ai'a to'o gare mau i urao anasi ma mae'a baania. ");
INSERT INTO aia_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na'i muri, do'orana na huta haisuri, 'a waina ro'u i naosi. Ma raru ai'a to'o gare mau ro'u, ma mae'a ro'u i saesi. Mana ta'i maho mausi, 'a to'o ro'u tanaai orunai do'oradaau. ");
INSERT INTO aia_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","'Ari wou, 'iraaui biu ha'ido'oradasi, rau waina hakoi uraosi. Ma ai'a ta ta'i 'iniraau naigu to'oraa ta gare beia, marau mae hako'a. Na'i muri mana uraosi 'a mae ro'u. ");
INSERT INTO aia_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hoita, na'i 'oha na 'iraaui biu ha'ido'oradasi rau waina hako o'asi uraosi, 'iatei 'iniraau nararugui ha'iwai uraosi na'i 'oha na 'ia God 'aigui ha'a-suruta'eraau aho'i baaniai mae?” ");
INSERT INTO aia_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mia Jisas 'a aramiraau o'ani, “Mou taritari'a ha'atai! 'I'amou ai'a aidangisiai Usu-usu Maea mamou ai'a aidangisia ro'u i taha na mena ana God 'ai matai haua. Naia namou to'oraa 'inia 'ado'ado bweubweu'asi. ");
INSERT INTO aia_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","'Oha 'ia God 'ai ha'a-suruta'erai noni baaniai mae, 'a bwa'i sae nai ha'iwai. 'Iraau rai 'onaairaaui enjel na'i aro nara ai'a ha'iwai. ");
INSERT INTO aia_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","'Io, ma wai ha'a-aidangisi'amou ro'u 'iniai suruta'e aho'i. Mou bwani 'iraraa do na'i mamaani 'inia Moses mana gere hasi'ei na noroi uruna ani, 'ia God 'a ha'atee o'ani 'inia Moses, ‘'Inau God ana Ebraham, mia Aisak, mia Jekop.’ ");
INSERT INTO aia_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mana God naasi, ai'a God adaaui nei ra mae, me 'e God adaaui nei ra tahi. Naasi 'a ha'ata'inia doni waira orusi rau tahi mau, rei'uaa narau bwane mae. 'I'amoui Sadiusi mou taritari'a di'u 'oha mou 'unua do gau bwa'i suruta'e aho'i.” ");
INSERT INTO aia_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","'Oha 'iraaui Sadiusi rau heitohetohe mau beia Jisas, 'e nei 'iniraaui Ha'ausuri 'anai Ringe ana'ia Moses, 'a boi ma rongoa dona heiarami ana Jisas 'a odo-odo. Maagu songa'inia ro'u o'ani, “Ha'atora he'ua na ororiu di'u?” ");
INSERT INTO aia_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mia Jisas 'agu aramia o'ani, “'Ia Moses 'a 'unua o'ani, ‘'I'amou sae ni Israel, moi bahu-bahurongo goro! 'Ia God naasi Araha agaau, me 'iia moi naasi ta'i God. ");
INSERT INTO aia_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Moi ta'ahiai Araha God amoou 'ini'i tahingamoo'i hako mana ahumoo'i hako me 'ini'i 'adoma'imoo'i hako mana wetewete amoo'i hako.’ Naasi nei na ororiu di'u. ");
INSERT INTO aia_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mana ruanai Ha'atora na ororiu 'a o'ani, ‘'Oi ta'ahiai nata sae 'onaai ta'ahi'o amua haari'o.’ 'Agu ai'a Ha'atora'a ro'u naigu ororiu di'uai rua Ha'atorasi.” ");
INSERT INTO aia_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mana saesi 'a o'ani, “Ha'ausuri, 'O ha'a-momori di'u 'oha na i'oe 'o 'unua do'e ta'i God moi. ");
INSERT INTO aia_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma'o ha'a-momori ro'u do gai ta'ahia God 'ini'i tahingagaa'i hako mana ahugaa'i hako me 'ini'i 'adoma'igaa'i hako mana wetewete agaa'i hako. Ma mei ta'ahiraau ro'u i mwane sae hako 'onaai ta'ahigaau haarigaau nagau haua. Na rua Ha'atorasi, raru ororiu di'u'i tara'i Ha'atora nagau suri'i, 'onaai'i ho'asi nagau hahaa'i na'i Ruma Maea ana God.” ");
INSERT INTO aia_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","'Oha 'ia Jisas 'a rongoa dona saesi 'a heiarami odo-odo, 'agu o'ani 'inia, “Wai 'unua tana'o: I'oe 'o gaarangi ha'awatea God 'anai marungiai tahingamu.” Na'i muri, 'agu ai'a ta sae'a ro'u naigu raba haa ta heisonga'i. ");
INSERT INTO aia_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na'i muri, 'oha 'ia Jisas 'a ha'ausuriraaui noni na'i Ruma Maea ana God, 'a o'ani 'iniraau, “'A he'ua na 'iraaui Ha'ausuri 'anai Ringe ana'ia Moses rau 'unua dona Ha'atahi 'e warowarona Mwaeraha Deved? ");
INSERT INTO aia_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","'Inia 'e ta'i 'oha, na Hi'ona Maea 'a haua tanaa Deved i 'ado'ado, mia Deved 'a o'ani, ‘'Ia Araha God 'a ha'atee tanaai Araha agua o'ani: 'Oi heinagu na'i aba odogu 'anai heimarungi beiau, tari 'oha wai nugaraaui maerongamu na'i bahainai heimarungi amua.’ ");
INSERT INTO aia_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na'i 'oha na 'ia Deved 'a 'unua do 'ia Ha'atahi 'e Araha ana, 'a ha'ata'inia do 'ia Araha ai'a do'e warowarona moi, ma'ata 'iia Araha ro'u ana.” Miraaui nei na ha'ausuriraau, rau wa'ewa'e di'u 'anai bahurongo'i maho na maani'i. ");
INSERT INTO aia_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mana 'oha na ha'ausuriraaui noni 'a o'ani, “Moi 'ome'ome goro 'iniraaui Ha'ausuri 'anai Ringe ana'ia Moses! 'A goro adaau hano hairiu na'i maketi bei'i to'oni ororiu adaa'i do neina 'iraaui inoni rai 'ome 'irararaau marai ha'ahouraau. ");
INSERT INTO aia_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Na'i 'oha narau siri suri'i ruma ni ha'arahesi, mei suri'i ngau goni nara haa'i, rau 'irisia dorai heinagu moe'a suri'i dora ororiu. ");
INSERT INTO aia_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Marau matai ha'a-bweubweu'araaui nao 'ini'i ruma adaa'i mana maho na rau to'ora'i. Mana 'oha rai rihunga'i, rau pwari'iraaui sae 'anai haa'i rihunga'i tewa. Moi 'iraraa dona ha'a-mama'ai 'ia God 'ai ha'arahaa ro'u wou tanaraau.” ");
INSERT INTO aia_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mia Jisas 'a heinagu gaarangiai bakosi 'anai wawate na'i Ruma Maea ana God. 'A wana suriraaui sae nara sisiri mai 'anai nuga'i bane adaa'i. 'A 'omesia do'a ragoi sae toto'ora na rau nuga'i mwane ha'a. ");
INSERT INTO aia_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","'Agu 'ome, ma 'e ta'i nao pohara na boi ma nugaa dioi rua gere korai ha'a. 'Onaa rai ha'igoni'i 'a ga'i arariai ta'i sereni. ");
INSERT INTO aia_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mia Jisas 'agu 'unuraau mai rongoiusuri ana'i ma o'ani, “'Inau wai 'unua ha'a-momori tana'amou: Na naosi 'a nuga ha'a di'uraau hako i mwane sae 'isi. ");
INSERT INTO aia_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","'Inia 'iraaui mwane sae 'isi rau hisu 'ini'i taha nara madara suri'i toto'ora adaa'i. Mana uraosi, 'oha na wateai ha'a na to'oraa, 'agu ai'a to'oraa'a ro'u tanei.” ");
INSERT INTO aia_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","'Oha Jisas 'a hura'a baaniai Ruma Maea ana God, 'e ta'i 'iniraaui rongoiusuri ana'i 'a boi beia ma o'ani 'inia, “Ha'ausuri, 'osui re'i'i kae hau suri'i bani 'anai kae Ruma Maea 'omegorosi.” ");
INSERT INTO aia_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mia Jisas 'a o'ani 'inia, “'O 'iraraa? 'E 'oha nai boi mau na bwa'i ta ta'i hau 'ini'i hau 'isi naraigui awa suri'i dora nara heinagu suri'isi. Na mwane hau 'isi rai gaasi'i dio.” ");
INSERT INTO aia_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na'i muri, 'ia Jisas 'a heinagu na'i hungahungai 'Oliv. Na'i dorasi ra matai wanasia moi 'ari Ruma Maea ana God. Mia Pita, Jems, Jon, mea Andru rau boi haariraau beia, marau songa'inia o'ani, ");
INSERT INTO aia_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Na'i 'oha he'ua na rai kaiai Ruma Maeasi? 'E ha'ara he'ua na mei re'ia na meigu 'iraraa 'inia do 'a tari'a i madoraa 'ana?” ");
INSERT INTO aia_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mia Jisas 'a aramiraau o'ani, “Moi 'ome'ome goro, ra gasigu ha'ateha'amou tara'i sae! ");
INSERT INTO aia_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","'Inia 'ai ragoi sae rai boi heitaroha'i na'i atagu narai o'ani, ‘'Iia'a ninauni,’ ma 'ai ragoi nei narai ha'ateharaau 'ini'i ha'ausuringa'i adaa'i nara ai'a ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Moi rongo'i rongo raha suri'i hei'oi nara to'o gaarangi mana taroha 'ini'i nei ra to'o ha'atau. Ma 'ai abui ta'aabemoou. 'Inia mareho 'isi rai to'o o'asi'a, ma ai'a do naasi'a i ha'ahakona dangi. ");
INSERT INTO aia_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","'Iraaui sae na'i ta'i kantri rai 'ari marai heingahui beiraaui sae na'i nata kantri. Ra'i nunu rai to'o suri'i tara'i dora, ma tara'i dora na inoni rai mae 'iniai hioro. Maho 'isi 'e taraawa'adi moi rongomaata'i, 'onaai urao naagu taraawa'a maesi ahu 'anai ha'ahutaai gare. ");
INSERT INTO aia_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Moi 'ome'ome goro! 'Inia rai boi wai'amou 'anai 'i'i'amou marai rohoroho'amou suri'i ruma ni ha'arahesi adaa'i. Suria 'i'amou ra'i rongoiusuri agu'i, rai wai'amou 'anai ha'a-urasi'amou na'i maadi Primia mana Mwaeraha. Naasi madoraa amoou 'anai taroha'inia hura'a i Taroha Goro tanaraau. ");
INSERT INTO aia_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na Taroha Goro rai 'adara'inia hako 'ari suriai marewana, maigu tari ha'ahakonai dangi. ");
INSERT INTO aia_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hoita, 'oha rai wai'amou 'anai 'i'i'amou, moi abui 'adoma'i raha 'ini'i taha na moi maani'i. 'Inia na maho namoi 'unu'i rai ha'ata'ini'i tana'amou suri'i 'adoma'imoo'i na'i madoraa na moi ha'atee. Na maho na moi maani'i, ai'a 'ado'adomoo'i haarimoou mei baaniai Hi'ona Maea. ");
INSERT INTO aia_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Na'i 'ohasi, sae rai usuha'ini'i do'oradaa'i mana gare adaa'i nara hinihiniau tanaraaui nei nara raba ha'amaesiraau. Mana gare rai ha'imae bei'i amadaa'i mana inadaa'i marai usuha'iniraau ro'u tanaraaui nei rai ha'amaesiraau. ");
INSERT INTO aia_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","'Iraaui noni rai 'utai'amou, suria 'i'amou ra'i rongoiusuri agu'i. Ma 'onaa moi ura baabau tari ha'ahakonai madoraa ta'aasi, moigu daua namooui tahi tarau.” ");
INSERT INTO aia_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mia Jisas 'a o'ani ro'u 'iniraau, “'I'amou moi re'iai maho ta'aa di'u na 'ia God 'a 'itaa. 'Ai ha'ata'aiai Ruma Maea ana God, 'inia 'a ga'i bwa'i awa iei. 'Ia tei na'oi 'oha'iniai ha'ateeni, 'oi ha'imaania aidangisia ma'ata'a i 'ado'ado 'ana! Hoita, 'onaa 'oi awa na'i Provensi Jiudea na'i madoraasi, 'oi hora ta'eha suri'i hungahunga 'anai bainihu. ");
INSERT INTO aia_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","'Onaa 'oi awa hura'ai buriinai ruma amua, 'oi hora'a. 'Ogui abu siri ro'u i ruma 'anai waa'i tara'i maho amu'i. ");
INSERT INTO aia_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","'Onaa 'oi awa na'i mou amua, 'oi abui aho'i 'ari ruma 'anai hauai bwana amua. ");
INSERT INTO aia_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ha'a-arohai'araau di'u i urao ra pote mana hasuuri'i, 'inia 'ai bwara tanaraaui hora. ");
INSERT INTO aia_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Moi ha'arahesi mana mahosi 'ai abui to'o na'i 'oha na rangi ro'aro'a. ");
INSERT INTO aia_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","'Inia ni rongomaata'i na'i madoraasi, 'ai ta'aa di'u baani'i mwane rongomaata'i nara taraawa'a mau na'i madoraa na ha'apwa'araa God i marewana tari dangini. Ma na'i muri, 'a bwa'i ta madoraa ta'aa o'asi'a ro'u naigu to'o. ");
INSERT INTO aia_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","'Onaa 'ia Araha God 'ai abui ha'apwapwakuai madoraa 'anai rongomaata'i 'isi, 'a bwa'i nei 'aigu tahi. Me 'iniai ta'ahiraau ana 'i sae ana'i na bwane 'ome sigihiraau, naia naigui ha'apwakua 'inia i madoraasi. ");
INSERT INTO aia_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","'Onaa ta sae nai o'ani, ‘Moisu wana mai. Naani Ha'atahi!’ Ma'uasi 'ai o'ani, ‘Na 'ariani!’ Moi abui hinihinia. ");
INSERT INTO aia_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ra'i sae pwapwaari'i rai boi marai o'ani, ‘'Inau naasi huunai Ha'atahi,’ ma'uasi rai o'ani, ‘'Inau naasi huunai Rarabea.’ Rai haa'i mwani ha'abu'oahu 'anai ha'ateharaaui sae. Rau raba ha'ateharaau ro'u i nei na 'ia God 'a bwane 'ome sigihira maagu bwara. ");
INSERT INTO aia_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Moi 'ome'ome goro 'iniraau! Naia nau 'unu'i'a 'ini'i maho 'isi tana'amousi.” ");
INSERT INTO aia_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","'Ia Jisas 'a ha'atee o'ani ro'u, “Na'i murinai madoraa ta'aasi, ‘I sina 'a bwa'i marewa, mana hura 'ai o'asi ro'u. ");
INSERT INTO aia_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","I hee'u rai ahoda, mana taraani maho na'i ahoasara rai 'iha'iha.’ ");
INSERT INTO aia_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Miraaui noni raigu re'iau i Garei Inoni. Wai boi aho'i suri'i rorodo beiai raraha mana mena na wetewete. ");
INSERT INTO aia_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Me 'inau waigu ha'a-taariraaui enjel agu'i 'ari suri'i mwani dora hako na'i marewana 'anai taragoniraau mai nei na 'ia God 'a bwane 'ome sigihiraau.” ");
INSERT INTO aia_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mia Jisas 'a o'ani ro'u, “Moisu 'adoma'iniai fig mai ha'ausuri'amou. Na'i 'oha na'o re'iai raraanai fig ra taraawa'ai asuru mana rawa ra pwira, ma'o 'iraraa do madoraa raorao 'a gaarangi'a. ");
INSERT INTO aia_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","'A o'asi ro'u. 'Oha na maho ta'a'i 'isi rai to'o, mamou 'iraraa do 'inau gaarangi aho'i mai'a. ");
INSERT INTO aia_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","'Inau wai 'unua ha'a-momori tana'amou, mareho 'isi rai to'o, miraaui sae nara awa na'i madoraani ra bwa'i mae mau. ");
INSERT INTO aia_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","I ahoasara mana ano rarui anoro mana ha'atee agu'i rai awa tarau. ");
INSERT INTO aia_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Na dangi mana madoraa he'ua nawai aho'i mai ai'a ta sae nai 'iraraa. Rei'uaa 'inau i Garei Inoni miraaui enjel na'i aro mameu ai'a 'iraraa ro'u. 'Ia moia Amagu na 'iraraa. ");
INSERT INTO aia_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Naasi, moi 'ome'ome mamoi ha'aagau goro, 'inia mou ai'a 'iraraai madoraa na wai aho'i mai. ");
INSERT INTO aia_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na boi aho'i na wai haua, 'a 'onaai sae na ha'aagau 'anai 'aariha ana. Na saesi 'a ha'a-'u'uriraaui sae tatau'aro ana'i 'ini 'omesuriai ruma ana. 'A 'unu'i tanaraaui tau'aro narai haa'i ma nugaai sae na'i maraaruma 'anai 'ome'ome goro 'iniai madoraa nai aho'i mai. ");
INSERT INTO aia_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Naasi moi 'ome'ome goro! 'Inia mou ai'a 'iraraai madoraa wai boi aho'i 'onaai ai'a 'iraraa adaaui 'oha nai boi aho'i anai sae na to'oraai ruma. Mou gasi mauru ma moigu 'asu'a 'oha wai boi aho'i. Na'i gasi su'urahi, ma'ua na'i 'ubutanai rodo, ma'ua na'i gasi wa'aria ma'ua haho'oa. ");
INSERT INTO aia_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Taha nau 'unua tana'amou 'au 'unua ro'u tanaraau hakoi mwani noni. Moi 'ome'ome goro!” ");
INSERT INTO aia_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ma'e rua dangi na mau maraigu ha'ato'oa 'e rua rongo. 'Etana 'anai 'adoma'i aho'isiai Roho Aharau mana ruanai rongo ra 'unua 'iniai Rongo 'ini Bredi nara ai'a dorari'i beiai draebam. Hoita, 'iraau na Na'ohadaa'i Piriisi miraaui Ha'ausuri 'anai Ringe ana'ia Moses, rau siba herehere do neina 'iraaui sae rai abui 'iraraai madoraa rai daua Jisas 'anai ha'amaesia. ");
INSERT INTO aia_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Rau o'ani, “Gai abui daua suri'i dangi nagau haai rongo, 'inia 'iraau sae ra gasi ha'ato'oa ta ha'agogoru.” ");
INSERT INTO aia_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","'Ia Jisas 'a awa na'i 'omaai Betani na'i ruma ana Saemon. 'Ia Saemon 'e sae na adoia ga'ui daoha ra 'unua 'iniai lepa. Na'i 'oha rau ngau, 'e urao na siri mai beiai gere huai wai 'ome goro na honu 'ini rumu na hori bwara ma si'ini goro. 'A tahangia ma ringisia na'i bwauna Jisas. ");
INSERT INTO aia_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mana haru tara'i sae na'i rumasi rau taesu'a 'anai uraosi marau ha'atee hairiu o'ani, “'Ei, 'a 'ua na ha'agata'inia 'inia i rumusi? ");
INSERT INTO aia_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","'A ga'i raonga'inia, mana ha'a 'ana 'a ga'i 'a'auhiraau 'inia i pohara. Na rumusi ra ga'i horia 'iniai oru 'arangi korai ha'a madara!” Maraugu taraawa'a ha'atee ha'ata'aiai uraosi. ");
INSERT INTO aia_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mia Jisas 'agu o'ani 'iniraau, “Nigaa! 'A 'ua na mou ha'atee ha'ata'aia 'inia? 'Iia 'a haua tanaau i here na goro. ");
INSERT INTO aia_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","'Iraaui pohara rai awa tarau moi bei'amou, mamoi matai 'a'auhiraau na moi wou ta madoraa. Me 'inau 'au bwa'i awa tarau bei'amou. ");
INSERT INTO aia_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Na uraoni 'a hauai here na goro tanaau. 'A ha'aagauai abegu 'anai 'oha rai toringiau. ");
INSERT INTO aia_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Wai 'unua ha'a-momori tana'amou: Suri'i mwane dora na'i marewana narai taroha'inia ei Taroha Goro, rai maaniai taha na haua i uraoni, marai 'adoma'inia aho'i.” ");
INSERT INTO aia_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mia Jiudas Iskariot, 'e ta'i 'iniraaui rongoiusuri ana'ia Jisas, 'a 'ari beiraaui Na'ohadaa'i Piriisi ma 'unua do 'iia 'ai 'a'auhiraau 'anai sadoia ta here narai matai daua 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na'i 'oha narau rongoa do'ai 'a'auhiraau, rau wa'ewa'e di'u. Marau duruduru tanaa dorai taharia. Ma na'i 'ohasi, 'ia Jiudas 'a taraawa'a sibasiba madoraa goro 'anai usuha'inia Jisas tanaraau. ");
INSERT INTO aia_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na'i dangi tahamora 'ini'i dangi nara ha'ato'oai Rongo 'ini Bredi nara ai'a dorari'i beiai draebam, ra ngahui'i tara'i garei siip 'anai 'adoma'i aho'isiai Roho Aharau. Ma na'i dangisi, 'iraaui rongoiusuri ana'ia Jisas rau boi songa'inia o'ani, “Na'i hei na'o rabasia do mei ha'aagaua iei ngaugoni 'anai 'adoma'i aho'isiai Roho Aharau?” ");
INSERT INTO aia_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mia Jisas 'agu o'ani 'iniai waira rua 'ini'i rongoiusuri ana'i, “Murui hano ma murui 'ari na'i kae 'omaai Jerusalem. Ma na'i 'oha na murui ataha wou, murugui heisadoi beia ta sae nai suru'iai bei wai. Ma na'i 'oha murui re'ia, murui suria na'i dora nai 'ari iei. ");
INSERT INTO aia_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Na'i 'oha nai siri na'i ruma, murui songa'iniai sae na to'oraai rumasi. Murui o'ani, ‘I Ha'ausuri ameeu 'a raba 'iraraa, na hei ahii nai matai ngau iei beiraaui rongoiusuri ana'i 'anai 'adoma'i aho'isiai Roho Aharau?’ ");
INSERT INTO aia_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na sae na to'oraai rumasi, 'aigu wai'amurua ta'eha 'anai 'omesiai ahii nara bwane ha'a-arataraa mana mwani maho ra bwane agau. Na'isi na murui ha'aagauhi'i ei mwane mareho.” ");
INSERT INTO aia_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Miraruai rua rongoiusuri raru 'ari ma raru 'omesia dona mwani maho ra to'o 'onaai bwane 'unua ana Jisas tanararua. Mararu ha'aagauai ngaugoni 'anai 'adoma'i aho'isiai Roho Aharau na'i rumasi. ");
INSERT INTO aia_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","18","'Oha 'ia Jisas miraaui rongoiusuri ana'i rau ngau goni na'i su'urahisi, 'ia Jisas 'a o'ani 'iniraau, “'Inau wai 'unua ha'a-momori tana'amou: 'E ta'i abe 'ini'amou namou ngau beiau 'ini, nai usuha'iniau tanaraaui maerongagu.” ");
INSERT INTO aia_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","'Oha na 'ia Jisas 'a 'unua o'asi, 'iraaui rongoiusuri rau arunga ta'aa. 'E nei ma o'ani 'inia Jisas, “'A 'ua? 'O 'adoma'inia do 'inau gasi?” ");
INSERT INTO aia_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mia Jisas 'a aramiraau o'ani, “'E abe 'ini'amou moi, 'ia mo'o miri ta'i toha'iniai dorai bredi na'i ta'i rabo'oni. ");
INSERT INTO aia_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ha'amomori. 'Inau i Garei Inoni, wai mae 'onaai ha'arangasia ada na'i Usu-usu Maea. Ma'ata, ha'arohaia di'u a mo'o nai usuha'iniau tanaraaui maerongagu! 'A ga'i goro tanaa 'onaa 'a ga'i bwa'i huta!” ");
INSERT INTO aia_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na'i 'oha na rau ngau, 'ia Jisas 'a dauai huai bredi. 'A ha'atee ha'agorohia God 'inia ma uubia. 'A haua tanaraaui rongoiusuri ana'i ma o'ani, “Naani abegu. Moi daua mamoi ngaua.” ");
INSERT INTO aia_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mia Jisas 'a dauai panikeni waen. 'A ha'atee ha'agorohia God 'inia ma haua tanaraaui rongoiusuri ana'i ma o'ani, “Moi gonohia.” Miraau hako rau gono. ");
INSERT INTO aia_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Maagu o'ani ro'u 'iniraau, “Naani 'abugu 'anai ha'a-'o'oriai duruduru haoru ana God. 'Ai ahe 'iniraaui mwani noni rago. ");
INSERT INTO aia_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nau wai 'unua ha'a-momori tana'amou: 'Augu bwa'i gonohia'a ro'u ta waen tari 'oha wai gonohiai waen haoru na'i dora ni heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Miraau suru'iai gana marau hura'a 'anai hungahungai 'Oliv. ");
INSERT INTO aia_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mia Jisas 'a o'ani 'iniraaui rongoiusuri ana'i, “'I'amou hako moi nugasiau mamoi hora baaniau. 'Ai 'onaai 'unua ada na'i Usu-usu Maea o'ani, ‘'Ia God 'ai ha'amaesiai 'omesuri siip, miraaui siip rai 'adarara!’ ");
INSERT INTO aia_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma'ata na'i 'oha wai suruta'e aho'i, wai 'ari na'i na'o 'ini'amou na'i Galili. Na'i 'isi nagaigui heito'oi ei.” ");
INSERT INTO aia_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","'Ia Pita 'agu ha'atee raha o'ani, “Rei'uaa na 'iraau rongoiusuri amu'isi rai nugasi'o, me 'inau 'au bwa'i moe'a!” ");
INSERT INTO aia_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mia Jisas 'a aramia o'ani, “Pita, wai 'unua tana'o ha'a-momori: De'eni rodo i kua 'a bwa'i tataraoke ha'arua mau, mi'oe 'oi bwani tohe ha'a-oru do'o ai'a mataiau.” ");
INSERT INTO aia_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mia Pita 'a tohe baabau ma o'ani, “'Inau, rei'uaa nawai mae bei'o, mau bwa'i 'unua moe'a do'au ai'a matai'o!” Miraau hakoi rongoiusuri rau ha'atee o'asi ro'u. ");
INSERT INTO aia_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","'Ia Jisas mana rongoiusuri ana'i rau taha na'i dora nara 'unua 'iniai Getsemanii, maagu o'ani 'iniraau, “Moi heinagu mamasi 'ini 'oha wai ha'arahesi.” ");
INSERT INTO aia_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ma waia Pita, Jems mea Jon. Na'i 'ohasi 'ia Jisas 'a arunga ta'aa mana 'adoma'ina 'a kuhi, ");
INSERT INTO aia_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","maagu o'ani 'iniraaui waira orusi, “Na ahutotou nau haa 'a raha di'u, mau gaarangi maesia. Moi awa na'i 'ini mamoi rarai beiau.” ");
INSERT INTO aia_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ma gere sara wou baaniraau ma topira'i ruru aurui ano ma ha'arahesi, “Ama, 'onaa 'ai mwada'u, ma'ai abui to'o o'asi tanaau! Mama, bei'o ai'a maho nai bwara tana'o, 'oi abui wateau 'anai siri na'i rongomaata'ini. Ma'ata 'ai abui suriai hei'irisigu, me 'ai suriai hei'irisimu.” ");
INSERT INTO aia_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","'A aho'i mai ma re'iraaui waira oru, rau poru mauru moi. Mia Jisas 'a o'ani 'inia Pita, “Saemon, i'oe 'o mauru moi? 'O bwa'i gere matai rarai beiau suria ta ta'i 'aoa moi? ");
INSERT INTO aia_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Moi rarai mamoi ha'arahesi neina moi abui ahoda na'i 'oha moi siri na'i heiohongi. Ra wetewete i 'adoma'imoo'i 'anai ha'isuri'i maho ra odo-odo, mana abemoo'i naragu maemae'a.” ");
INSERT INTO aia_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mia Jisas 'a aho'i 'ari ma haa ro'u mau i ta'i ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","'Oha na aho'i ro'u ma re'iraaui waira oru rau poru mauru moi. Ni maadaa'i ra hihi'a di'u 'iniai mamauru'a. 'A ha'arairaau ma kakui ahudaau 'iniai taha rai 'unua tanaa. ");
INSERT INTO aia_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","'Ia Jisas 'a aho'i 'ari ro'u 'ini ha'arahesi ma na'i 'oha na boi aho'i beiraau, 'a o'ani 'iniraau, “Mou mauru mamou mamaro mau? 'A goro'a ga'u! Na madoraa na rai usuha'iniau i Garei Inoni tanaraaui noni ta'a'i, naani'a! ");
INSERT INTO aia_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","'Ome, 'ia mo'o nai usuha'iniau tanaraaui maerongagu 'a boi'a. Moi ura ara'a magai 'ari beiraau.” ");
INSERT INTO aia_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","'Oha na 'ia Jisas 'a ha-hadahada mau, 'ia Jiudas, 'e ta'i 'iniraaui rongoiusuri ana'ia Jisas, 'a taha mai beiai ruruhai sae. Ra waa'i mai naihi mana hasi'ei 'anai heingahu. 'Iraaui Na'ohadaa'i Piriisi mana Ha'ausuri 'anai Ringe ana'ia Moses ma tara'i saemaua ro'u ra ha'a-taariraau mai. ");
INSERT INTO aia_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mia Jiudas 'a bwane hauai ha'a-aratara tanaraau o'ani, “'Ia mo'o nawai ngoonia, naasi na moi dau ha'agorohia mamoi waia.” ");
INSERT INTO aia_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Naasi, mia Jiudas 'a 'ari odo-odo beia Jisas ma ha'atee o'ani tanaa, “Ha'ausuri” ma ngoonia. ");
INSERT INTO aia_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Miraaugu daua 'anai waia. ");
INSERT INTO aia_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma na'i 'ohasi, 'e ta'i 'iniraaui rongoiusuri na awa gaarangiraau, 'a rahiai naihi ana ma taba taahiai karinganai sae tatau'aro anai Na'ohadaaui Piriisi. ");
INSERT INTO aia_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mia Jisas 'a ha'atee o'ani tanaraau, “'A 'ua? Mou 'adoma'inia do 'inau 'e sae hehere ta'aa na mou boi 'inia bei'i naihi mana hasi'ei 'anai heingahu 'anai dauau? ");
INSERT INTO aia_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","'A 'ua namou ai'a bwani dauau 'inia na'i Ruma Maea ana God? 'Ado dangi na'i 'isi'a nau ha'ausuri na'iei. Ma'ata, mareho namougu hauanisi, 'e ha'ato'oa moi mareho nara bwane usua 'iniau na'i Usu-usu Maea! Naia na mou boi dauau o'ani 'iniani.” ");
INSERT INTO aia_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Miraaui rongoiusuri rau nugasia'a Jisas marau hora hako baania. ");
INSERT INTO aia_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma'e sae haoru, na suria Jisas. 'Iia 'a ho'owa'a 'iniai tahangai bwana mamae. Mana 'oha rau bonasiai daua, ");
INSERT INTO aia_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","'a ahodai bwana ana ma hora ha'i wa'aroko. ");
INSERT INTO aia_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Marau waia Jisas 'ari na'i ruma anai Na'ohadaaui Piriisi. Miraaui Na'ohadaa'i Piriisi miraaui Ha'ausuri 'anai Ringe ana'ia Moses ma tara'i saemaua ro'u na rau awa na'i Kansol, rau goni mai hako na'i dorasi. ");
INSERT INTO aia_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mia Pita 'a haisuri ha'atau moi. 'A siri na'i raronai dora a'ora na'i maanai rumasi ma heinagu na'i bobonai 'eu. 'A waari'u beiraaui sae hehei'oi nara 'omesuriai Ruma Maea ana God. ");
INSERT INTO aia_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hoita, na'i raronai ruma, 'iraaui Na'ohadaa'i Piriisi miraaui haru saemaua narau awa ro'u na'i Kansol ra bonasia do rai sadoia ta mamaani 'anai subunia 'inia Jisas marai hiiri ha'amaesia 'inia. Miraau ai'a sadoia ta maho 'anai ha'ahunia 'inia. ");
INSERT INTO aia_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","'Inia, rei'uaa nara ragoi nei ra haa'i mamaani pwari'i 'ana Jisas, me ni mamaani adaa'i ra ai'a ta'isada. ");
INSERT INTO aia_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ra ura ara'a ro'u tara'i nei ma ra haua ro'u i pwari'i. Rau o'ani, ");
INSERT INTO aia_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“'I'ameu meu rongoa do 'ai kaiai Ruma Maea ana God 'iraaui sae rau tau'aronasi. Ma 'unua do 'ai ha'a-urasia aho'i ta nei haoru na'i moi oru dangi, 'e nei na bwa'i sae nai matai tau'arona!” ");
INSERT INTO aia_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma'ata na mamaani adaa'i ra he'ete'i hairiu mau. ");
INSERT INTO aia_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mana Na'ohadaaui Piriisi 'a ura ara'a na'i maadaaui sae 'isi, ma ha'atee o'ani tanaa Jisas, “'A 'ua? 'O bwa'i haua ta heiarami 'ini'i mareho ra ha'ahuni'o 'ini'isi?” ");
INSERT INTO aia_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","'Ia Jisas 'a papaku ma ai'a 'unua ta ta'i ha'atee. Mana Na'ohadaa'i Piriisi 'a songa'inia o'ani ro'u, “'A 'ua? I'oe naasi Ha'atahi, garena God?” ");
INSERT INTO aia_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisas 'a aramia o'ani, “'Io. 'Inau! 'Inau, na Garei Inoni, moi re'iau mau, 'oha wai heinagu na'i dora ororiu na'i aba odona God huunai mena. Wai aho'i mai hungadi rorodo na'i aro!” ");
INSERT INTO aia_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mana Na'ohadaaui Piriisi 'a karia i to'oni ana haaria 'anai ha'ata'iniai 'ado'adona doni mareho na haua Jisas 'a ta'aa di'u. Ma o'ani, “Gaugu bwa'i sibania'a ro'u ta sae 'anai ha'ahunia 'inia ta maho ro'u. ");
INSERT INTO aia_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Naia mou rongoa'a haarimoousi, 'a ha'atee ha'ata'aia God! Mou 'adoma'i he'ua?” Marau aramia o'ani, “'A arari do rai ha'amaesia!” ");
INSERT INTO aia_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Maraugu ngisuai abena, ma tara'i nei rau bibii bwarasiai maana marau rubu'ia 'ini'i rimadaa'i marau ha'atee o'ani, “'Oi 'unua tana'ameu mo'o na rubu'i'osi! 'Inia i'oe 'e rarabea, nita?” Ma na'i 'ohasi na sae hehei'oi nara 'omesuriai Ruma Maea ana God rau waia marau hidaria ro'u. ");
INSERT INTO aia_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na'i mau 'oha ra hiiria Jisas, 'ia Pita 'a heinagu mau na'i dora a'ora na'i maanai ruma. Na'i 'ohasi 'e gere urao na tau'aro tanaai Na'ohadaaui Piriisi 'a boi. ");
INSERT INTO aia_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","'Oha na 'omesiai wawaari'u ana Pita na'i 'eu, 'a wana wetewete 'inia ma o'ani, “I'oe ro'usi beia Jisas ni Nasaret!” ");
INSERT INTO aia_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Me 'iia 'a o'ani 'inia, “'O pwari'i na! Nau ai'a 'iraraai maho na'o 'unuasi!” Mia Pita 'a suruta'e ma gere hura'a wou na'i maanai bara, mana kua 'a tataraoke. ");
INSERT INTO aia_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mana gere uraosi 'a 'omesia ro'ua Pita, ma ha'atee o'ani tanaraaui sae rau awa 'isi, 'a o'ani, “'E ta'i abe 'iniraau ro'u naasi!” ");
INSERT INTO aia_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mia Pita 'a o'ani ro'u, “Ai'a, 'inau ai'a!” 'A ai'a orea miraaui sae rau ura na'isi rau o'ani ro'u 'inia Pita, “Ha'amomori, i'oe 'e ta'i ro'u 'iniraau. Meu 'iraraa do i'oe 'e sae ni Galili ro'u.” ");
INSERT INTO aia_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","'Ia Pita 'a tohe baabau 'a o'ani, “Ha'amomori beia God! 'Inau ai'a 'iraraa mora a mo'o namou 'unuasi! 'Onaa wai pwari'i 'ia God 'ai ha'a-mama'aiau!” ");
INSERT INTO aia_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na'i mau madoraasi mana kua 'a ruana'ai tataraoke. Mia Pita 'agu 'adoma'i aho'isi'i ha'atee na 'unu'i a Jisas tanaa, 'a o'ani, “Na kua 'a bwa'i tataraoke ha'arua mau, ma'oi 'unua ha'a-oru'a do 'o ai'a 'iraraau.” 'A 'adoma'i aho'isia magu angi. ");
INSERT INTO aia_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na'i mau haho'oa ta'aa, 'iraaui saemaua na'i Kansol rau goni aho'i hako marau hauai ta'i 'ado'ado 'iniai here rai haa 'ana Jisas. Naasi marau ho'osi'i rimana Jisas marau waia 'ari tanaa Paelat, na Primia 'anai Provens. ");
INSERT INTO aia_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mia Paelat 'a songa'inia Jisas o'ani, “'A 'ua? I'oe naasi mwaeraha adaaui Jiu?” Jisas 'a aramia o'ani, “Naia na'o 'unuasi.” ");
INSERT INTO aia_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Miraaui Na'ohadaa'i Piriisi rau subunia 'ini'i mwani maho ta'a'i. ");
INSERT INTO aia_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Naasi mia Paelat 'a songa'inia aho'i ro'ua Jisas, 'a o'ani “'O rongo'i maho rau subuni'o 'ini'isi? 'A 'ua? 'A bwa'i maho na'oi 'unua?” ");
INSERT INTO aia_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mia Jisas 'agu ai'a 'unua'a ta ta'i ha'atee mia Paelat 'a heimwaota'i di'u. ");
INSERT INTO aia_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","'Ado harisi, 'oha 'iraaui Jiu ra ha'ato'oai rongo 'anai 'adoma'i aho'isiai Roho Aharau, 'ia Paelat 'a matai ha'awatea tanaraau ta sae narai 'irisia ma'ai ha'ahura'ahia baaniai rumaniho'o. ");
INSERT INTO aia_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hoita, na'i madoraa narau hiiria Jisas, ra'i sae nara awa na'i rumaniho'o, 'inia rau ngahu ha'amaesi'i sae na'i madoraa na rau bonasia ha'ahakoai heimarungi adaaui Rom. Ma'e ta'i 'iniraau naasia Barabas. ");
INSERT INTO aia_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Miraaui Jiu rau boi 'anai ha'angonia Paelat do'ai ruhasia ta sae 'onaai bwane hahaua ana. ");
INSERT INTO aia_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mia Paelat 'a o'ani 'iniraau, “'A 'ua? Mou 'irisia dowai ruhasiai mwaeraha amooui Jiu?” ");
INSERT INTO aia_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","'Ia Paelat 'a ha'atee o'asi suria 'a bwane 'iraraa do 'iraaui Na'ohadaa'i Piriisi rau waia maia Jisas suria rau kakawa 'omesia 'iniai rago anai sae nara ta'ahia. ");
INSERT INTO aia_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Miraaui Na'ohadaa'i Piriisi rau ha'angoniraau wetewete inoni dorai 'unua tanaa Paelat 'anai ruhasia Barabas, 'ia Jisas 'ai abu. ");
INSERT INTO aia_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mia Paelat 'a songa'iniraau hakoi noni o'ani, “Mawai ha'ahe'uaa mo'o na mou 'unuasi do 'iia 'e mwaeraha amooui Jiu?” ");
INSERT INTO aia_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Marau awara o'ani, “Rabu ahita'inia na'i dadaahoro!” ");
INSERT INTO aia_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mia Paelat 'a songa'iniraau o'ani, “'Iniai 'uaana? 'E 'ino he'ua na haa?” Marau awara raha ro'u o'ani, “Rabu ahita'inia na'i dadaahoro!” ");
INSERT INTO aia_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mia Paelat 'a ruhasia Barabas, suria 'a rabasia do 'ai aroi ahudaa'i. Ma 'unua tanaraaui sae hehei'oi ana'i dorai rohoa Jisas 'iniai hasiwaro baabau marai waia hura'a 'anai rabua na'i dadaahoro. ");
INSERT INTO aia_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Miraaui hehei'oi rau waia Jisas siri na'i kae ruma raha ana Paelat. Marau 'unuraau ro'u hako mai sae hehei'oi na'i ruruha adaau. ");
INSERT INTO aia_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Marau ha'ato'onia Jisas 'onaai mwaeraha 'iniai to'oni tewa wangawanga. Marau nugaa na'i bwauna i hihiiri bwau nara haa 'iniai waroraraki. ");
INSERT INTO aia_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Marau ha'atotooa, rau o'ani, “Ha'aasaai mwaeraha adaaui Jiu!” ");
INSERT INTO aia_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Rau rubu'iai bwauna 'iniai hasi'ei, rau ngisuai abena marau topira'i ruru tanaa do rau ha'ahoua. ");
INSERT INTO aia_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Na'i 'oha rau ha'ada'ada'a hako 'inia rau rahia aho'i to'oni wangawanga narau ha'ato'onia 'inia marau ha'ato'onia aho'i 'iniai to'oni ana maraugu waia 'ari 'anai rabua na'i dadaahoro. ");
INSERT INTO aia_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","'Oha rau 'ari wou suriai tara na'i Jerusalem, rau heisadoi beiai sae na atana 'ia Saemon. 'Iia 'e sae ni 'omaai Saerin me 'iiasi 'e amana Aleksanda mea Rufas. 'Agu boi baaniai dora na gere ha'atau baaniai 'omaasi ma riutaha mai ro'u na'i tarasi. 'Iraau hehei'oi rau ha'a-'usu'usua do 'ai suru'iai dadaahoro baania Jisas. ");
INSERT INTO aia_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Rau waia Jisas 'ari na'i dora ra 'unua 'iniai Golgota mana 'ado'ado 'ana, “'E Dora ni Korai Bwau Sae.” ");
INSERT INTO aia_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Marau haua tanaai waen ra doraria 'iniai merisini na ra 'unua 'inia “myrrh” 'anai ha'amaadidi'i dora ra maata'i. Mia Jisas 'a ai'a raba gonohia. ");
INSERT INTO aia_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Miraaui sae hehei'oi rau rabu ahita'inia Jisas na'i dadaahoro. Rau gaasi ha'ara 'anai sadoia tei 'iniraau nai to'ora'i to'oni ana'i. ");
INSERT INTO aia_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mana'i madoraa 'onaai angi siwa na'i haho'oa na rau rabu ahita'inia Jisas na'i dadaahoro. ");
INSERT INTO aia_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mara usuai usu-usu na'i baba mara nugaa na'i bwaunai dadaahoro 'anai ha'ata'iniai taha na ha'atari'aa. Rau usua o'ani, ");
INSERT INTO aia_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ma'e waira rua sae beriberi narau rabu ahita'inirarua ro'u suri'i dadaahoro. Ta nei na'i aba odo 'inia Jisas ma ta nei na'i aba maha. ");
INSERT INTO aia_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","'A to'o o'asi do 'ai to'o ha'a-momori taha na ra usua na'i Usu-usu Maea, “'Iraaui sae ra 'unua do 'iia 'e ta'i abe 'iniraaui sae hehere ta'aa.” ");
INSERT INTO aia_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Miraaui sae ra taha horo 'isi rau ha'atee ha'ata'aia, rau arabwau 'ini ha'atotooa marau o'ani, “Mmm naasi, i'oe na'o 'unua ani do'oi kaiai Ruma Maea ana God ma'oi matai ha'a-urasia aho'i na'i raronai oru dangi. ");
INSERT INTO aia_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","'Onaa 'o to'o mena o'asi, 'o ga'i ha'atahi'o haari'o ma 'oi dio mai baaniai dadaahorosi.” ");
INSERT INTO aia_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","'Iraau ro'u na Ha'ausuri 'anai Ringe ana'ia Moses miraau Na'ohadaa'i Piriisi rau haikou 'inia. Rau ha'atee hairiu o'ani, “Sae he'ete'i 'a matai ha'atahi'i, me 'iia 'a bwa'i matai ha'atahia haaria. ");
INSERT INTO aia_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","'A 'ua? Naia naasi Ha'atahi, mwaeraha adaaui Jiu? 'Onaa gai 'omesiai dio mai ana baaniai dadaahoro ma gaigu hinihini'i ha'atee ana'i.” Mana waira rua ra rabu ahita'ini'ararua beia Jisas, raru ha'atee ha'ata'aia ro'u. ");
INSERT INTO aia_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ma na'i angi ta'i tangahuru mana rua na'i dangisi, 'a kuhi bwarasiai kantri hako tari na'i angi oru. ");
INSERT INTO aia_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na'i angi oru abaidangi 'ia Jisas 'a totoro o'ani na'i ha'atee ana, “'Elai, 'Elai, lama sabaktani?” Na 'ado'ado 'anai ha'ateesi, 'a o'ani, “God agua! God agua! 'Ini 'uaana na'o gagata'iniau 'inia?” ");
INSERT INTO aia_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma tara'i nei nara ura gaarangi, rau rongoai awara o'asi ana marau o'ani, “'Ei, 'a kukua Elaija.” ");
INSERT INTO aia_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma 'eba i ta'i sae ma dauai mareho na matai omi'i wai, ma ha'ahonua 'iniai waen mahai. 'A nugaa na'i hasi'ei ma taranga'inia ara'a tanaa Jisas do 'ai gonohia. Mana saesi 'a o'ani, “Gai 'ome'ome ga'u 'onaa na 'ia Elaija 'ai boi 'anai ha'adiohia baaniai dadaahoro.” ");
INSERT INTO aia_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mia Jisas 'a totoro magu mae. ");
INSERT INTO aia_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mana bwana ubu-ubu'a nara rohe bwarasia 'iniai dora maea na'i Ruma Maea ana God, 'a maakari heihoa, taraawa'a bo ta'eha ma dio. ");
INSERT INTO aia_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na'i 'ohasi 'e na'otara adaaui sae hehei'oi na ura na'i maanai dadaahoro ana Jisas. Mana 'oha na re'iai mae na haua, 'agu ha'atee o'ani, “Ha'amomori, 'ia mo'oni huunai garena God!” ");
INSERT INTO aia_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ma tara'i urao ra suria Jisas ara'a mai na'i Jerusalem. Rau awa gere ha'atau moi baaniai dadaahoro maraugu wanawana 'ari. Tara'i nei beiraau, 'ira a Meri ni Magdala, 'ia Salome, mea Meri inana gere Jems mea Joses. Waira orusi rau bwane suria mau mai a Jisas 'anai 'a'auhia na'i madoraa na tatariori na'i Galili. ");
INSERT INTO aia_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ma 'ari wou 'anai su'urahi'a mana dangi ni mamaro 'a gaarangi. Miraau na Jiu rau ha'aagau 'anai dangi hauasa adaausi. ");
INSERT INTO aia_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Naasi ma'e sae na atana 'ia Josep ni 'Arimatea, 'a taha beia Paelat. 'Iiasi 'e ta'i sae na'i Kansol na rau hiiriasi a Jisas. Me 'iia 'e sae nara ha'ahoua. 'Iia 'a to'oraai 'adoma'i heitotori 'iniai madoraa na 'ia God 'ai marungiraaui inoni ana'i. Ma rei'uaa na mamaa'u, me 'iia 'a taha beia Paelat ma o'ani 'inia, “Mwaeraha, 'inau 'au raba rahia dioi abena Jisas baaniai dadaahoro. 'A 'ua? 'A goro moi?” ");
INSERT INTO aia_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mia Paelat 'a o'ani, “'A 'ua? 'Ia Jisas 'a mae'a?” Ma soiai bwauodo adaaui sae hehei'oi na re'iai mae ana Jisas ma songa'inia. ");
INSERT INTO aia_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Na'i 'oha na sae hehei'oisi 'a 'unua tanaa do'ia Jisas 'a mae'a, 'ia Paelat 'agu ha'awatea Josep 'anai rahia dioi abena Jisas baaniai dadaahoro. ");
INSERT INTO aia_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mia Josep 'a horiai bwana mamaahui, ma rahia dioi abena Jisas. Naasi 'a ho'ua 'iniai bwana, magu aoraa na'i wabwa ra 'eria na'i abenai kae hau. Naasi mara hugesia ro'u wou i kae hau bwarasiai maanai wabwasi. ");
INSERT INTO aia_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma na'i 'ohasi, 'ia Meri ni Magdala mea Meri inana Joses raru awa ro'u 'isi ma raru re'iai dora na ra aoraa na'iei abena Jisas. ");
INSERT INTO aia_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Murinai dangi ni mamarosi, 'ia Meri ni Magdala, 'ia Salome mea Meri inana Jems rau 'ari hori'i waiwai nara dorari'i 'iniai hasi'ei sisi'ini 'anai nuga'i na'i abena Jisas. ");
INSERT INTO aia_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mana'i wa'aria na'i dangi sade, na'i 'oha na sina 'agu taraawa'a ara'a, rau 'ari na'i wabwa nara aoraa ieia Jisas. ");
INSERT INTO aia_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na'i 'oha narau 'a'ari wou mau, rau heisosonga'i hairiu o'ani, “'Ia tei nai 'a'auhigaau 'anai hugesiai hau baaniai maanai wabwa?” ");
INSERT INTO aia_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Na'i 'oha naraugu ataha wou na'i dorasi, rau 'omesia doni kae hau raha di'usi ra bwane hugesia'a. ");
INSERT INTO aia_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na'i 'oha naraugu siri wou na'i wabwa, rau re'iai sae na heinagu na'i aba odo. Mana saesi 'e sae haoru na to'oni 'iniai to'oni mamaahui. Miraau kae mamaa'u di'u. ");
INSERT INTO aia_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mana saesi 'a o'ani 'iniraau, “Moi abu mamaa'u! 'Au 'iraraa mou 'ome 'inia Jisas ni Nasaret nara rabua na'i dadaahoro. 'Agu ai'a awa'a 'ini, 'inia 'ia God 'a ha'a-suruta'ea aho'i baaniai mae. 'Ome! Naani dora ra aoraa iei abena. ");
INSERT INTO aia_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Moi aho'i 'ari mamoi maania tanaa Pita miraaui haru tara'i rongoiusuri ro'u o'ani, ‘'Ia Jisas 'ai na'o 'ari Galili 'ini'amou ma moigui sadoia na'iei 'onaai bwane 'unua ana tana'amou.’” ");
INSERT INTO aia_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","'Oha rau hura'a baaniai wabwa, rau hora ha'i 'idi'idi 'iniai mamaa'u. Rau ai'a maania ro'u tanaa ta nei, 'inia rau mamaa'u di'u. ");
INSERT INTO aia_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na'i haho'oa na'i dangi sadesi, 'oha 'ia Jisas 'a suruta'e aho'i baaniai mae, 'a ha'ata'i tanaa Meri ni Magdala na'i na'o, i urao na 'ia Jisas 'a taariai biu adaro baania ani. ");
INSERT INTO aia_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","'Ia Meri 'a 'ari beiraaui sae haguhagu goro ana'ia Jisas, na rau ahutotou marau angi. 'A maania tanaraaui ha'ata'i ana Jisas tanaa. ");
INSERT INTO aia_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma na'i 'oha rau rongoa do 'ia Meri 'a re'ia Jisas, do 'a suruta'e aho'i baaniai mae, rau ai'a hinihinia. ");
INSERT INTO aia_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","'E ta'i 'oha ro'u 'ia Jisas 'a ha'ata'i tanaai rua rongoiusuri 'oha raru bwabwahe ha'atau baaniai 'omaa. Na'i 'ohasi raru ai'a 'ome 'iraraa Jisas 'inia na 'omehana 'a orisi. ");
INSERT INTO aia_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","'Oha raru aho'i mai, raru maania tanaraaui tara'i rongoiusuri ro'u, me 'iraau ai'a hinihinirarua ro'u. ");
INSERT INTO aia_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma ha'ata'i ha'ahako tanaraaui ta'i tangahuru mana waira ta'i rongoiusuri ana na'i 'oha rau ngau goni. Ma ha'atee wetewete tanaraau 'inia ra baabaui tahingadaa'i. 'Inia rau ai'a hinihini'i mamaani adaa'i sae na ra re'ia Jisas do 'a tahi aho'i. ");
INSERT INTO aia_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Miagu o'ani ro'u 'iniraau, “Moi hura'a suri'i mwane dora na'i marewana, mamoi taroha'inia hura'ai Taroha Goro tanarai mwani noni hako. ");
INSERT INTO aia_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","'Iatei nai hinihiniai Taroha Goro maai bwareomaea, 'ai to'oraai tahi tarau beia God. Mana nei na bwa'i hinihini, 'ia God 'ai hiiri ha'a-mama'aia marai gaasia na'i dora ni rongomaata'i. ");
INSERT INTO aia_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","'Irai sae ra hinihini, 'ia God 'ai haua tanaraaui mena 'anai hau'i mwani ha'abu'oahu. Ma rai taari'i adaro 'iniai atagu, marai matai ha'atee 'ini'i mwani ha'atee he'ete'i hairiu na ra ai'a 'irara'i mau. ");
INSERT INTO aia_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Rei'uaa rai daa'i mwaa ta'a'i ma'ua gonohi'i maho mamaesi'i ma ra bwa'i maesi'i. Ma rai nuga'i rimadaa'i na'i hungadi sae daoha marai goro aho'i.” ");
INSERT INTO aia_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","'Oha 'ia Jisas 'a maani'i hako tanaraaui rongoiusuri mareho 'isi, mia God 'a waia'a ara'ai aro ma heinagu na'i aba odona God. ");
INSERT INTO aia_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Miraaui rongoiusuri ana'i rau hura'a suri'i mwani 'omaa 'anai taroha'iniai Taroha Goro. Mia Araha 'a awa beiraau 'anai 'a'auhiraau. Rau hau'i mwani ha'abu'oahu 'iniai mena ana, ma naasi 'a ha'ata'inia doni mareho narau taroha'ini'i ra ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tana'o Tiofilas: 'A ragoi nei ra bwane usu'i mamaani 'ini'i mwane maho na hau'ia Jisas na'i madoraa na awa bei'ameu. ");
INSERT INTO aia_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mana mareho narau usu-usu 'abai'i, ra'i mareho nameu bwane rongo'i beiraaui nei narau wanara'i maa 'ini'i. 'Iraau naasi inoni tatau'aro ana'ia God narau maania hura'a i tarohasi tanaraaui inoni. ");
INSERT INTO aia_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hoita, suria 'inau ro'u naasi ta'i abe nau bonasiai siba ha'agorohia ro'u i mamaani 'inia Jisas mau mai na'i taraawa'ana, 'inau nau raba usua ro'u ta buka tana'o. Mwanemaua Tiofilas, 'au haua o'asi ");
INSERT INTO aia_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","do neina 'oi 'irara ha'agorohia doni mareho nara ha'ausuri'o 'ini'i ra'i mareho ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na'i 'oha 'ia Herod 'a mwaeraha na'i Jiudea, 'e Piriisi na atana 'ia Sakaraea na awa ro'u na'i madoraasi. 'Iia 'e ta'i 'iniraaui ruruhai Piriisi nara 'unuraau 'iniai Abaeja. Mana urao ana Sakaraea 'ia Elisabet. 'Ia Elisabet 'e urao baaniai burungana Eron. Mia Eron 'e 'etanai Na'ohadaaui Piriisi na'i 'oha bwani. ");
INSERT INTO aia_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","'Ia Sakaraea mea Elisabet ra'i inoni odo-odo na'i maana God nararu awa suri'i tarau i Ha'atora mana heiatenga'i ana'ia God. ");
INSERT INTO aia_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma'ata, raru ai'a to'o gare, suria 'ia Elisabet 'a 'amara, mirarua raru wari hako'a ro'u. ");
INSERT INTO aia_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Hoita, ta'i 'oha, 'ia Sakaraea 'a tau'aro na'i Ruma Maea ana God, 'inia 'a tari mai 'oha anai ruruha ana 'anai hauai tatau'aro adaau. ");
INSERT INTO aia_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ma suriai ringeringe adaaui Piriisi na'i 'ohasi. 'Iraau rau gaasi ha'ara 'anai sadoia tei naasi nai siri na'i Ruma Maea 'anai suungiai insens. Naasi ni ha'ara 'a auru hunia Sakaraea magu siri 'anai suungiai insens. ");
INSERT INTO aia_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na'i madoraasi, 'a ragoi noni nara goni mai na'i maanai Ruma Maeasi 'anai ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma na'i 'oha na 'ia Sakaraea 'a suungiai insens, 'e enjel ana Araha God 'a ha'amaranga tanaa. 'A ura na'i aba odo 'iniai dora maea nara susuungiai insens. ");
INSERT INTO aia_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Na'i 'oha na 'ia Sakaraea 'a 'omesia, 'a kaku ta'aa i ahuna, ma mamaa'u di'u. ");
INSERT INTO aia_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mana enjel 'a ha'atee o'ani 'inia, “'Oi abui mamaa'u Sakaraea! 'Ia God 'a rongoai ha'arahesi amua mana urao amua 'ai ha'ahutaai gare mwane ma'oi ha'a-atana 'inia Jon. ");
INSERT INTO aia_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","'I'amurua murui wa'ewa'e di'u 'inia, mai rago ro'u i nei narai wa'ewa'e 'iniai huta ana, ");
INSERT INTO aia_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","suria 'iia 'ai ha'i inoni hauasa na'i 'ado'adona Araha God. 'Iia 'ai abui gonohia ta waen, ma'ua gonohia ta wai ni bweu he'ete'i ro'u moi wou. Na Hi'ona Maea 'ai awa beia taraawa'a mau na'i ahuna inana. ");
INSERT INTO aia_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","'Ai rago inoni ni Israel nai wairaau aho'i mai 'anai aho'isia Araha God adaau. ");
INSERT INTO aia_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","'Iia 'ai to'o mena nai wetewete 'onaaia rarabea Elaija. 'Ai boi na'i na'o 'inia Araha 'anai ha'aagauraaui inoni 'anai boi ana. 'Ai ha'ahaguraau aho'i ama bei'i gare adaa'i ma'ai rihosi'i 'adoma'idi nei ra hairaesi beia God marai awa 'onaai nei nara awa odo-odo.” ");
INSERT INTO aia_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mia Sakaraea 'agu songa'i o'ani, “'Ai he'uai 'iraraa agua doni marehosi 'a ha'a-momori? 'Inia 'inau 'au wari'a, mana urao agua 'a wari'a ro'u.” ");
INSERT INTO aia_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mana enjel 'a aramia o'ani, “'Inaua Gebrel, minau 'au ura na'i maana God 'ado dangi. 'Ia God na ha'ataariau mai 'anai ha'atee bei'o 'anai maania tana'o i taroha gorosi. ");
INSERT INTO aia_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma'ata suriai ai'a hinihini'i amu'i ha'atee agu'i, i'oe 'oi baanguu tari dangi nai huta i gare amua. Ni ha'atee agu'i rai to'o ha'a-momori na'i huunai madoraa 'ana.” ");
INSERT INTO aia_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na'i 'ohasi 'iraaui mwane inoni ani narau awa 'anai ha'arahesi na'i abau 'omaa rau mamasia Sakaraea do'ai hura'a mai. Rau wai'ado'ado 'iniai orea na haa siri raronai Ruma Maea. ");
INSERT INTO aia_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ma na'i 'oha nagu hura'a mai, 'a ai'a ha'atee tarairaau ma haa'i moi ha'ara tanaraau 'iniai rimana'i. Na'i 'ohasi rau 'iraraa do'e mareho na ha'amaranga tanaa na'i Ruma Maea. ");
INSERT INTO aia_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ma na'i 'oha na hako i sade ana 'anai tagora, 'ia Sakaraea 'agu aho'i 'ari ruma ana. ");
INSERT INTO aia_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na'i gere muri moi mai, 'ia Elisabet 'a to'ora 'iniai gare, ma'e rima hura na awa hatara'i moi na'i ruma. ");
INSERT INTO aia_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Mia Elisabet 'a ha'atee o'ani, “Naasi 'ia Araha God 'agu goro 'iniau ma rahia baaniaui ninima na awa beiau 'iniai ai'a to'ora gare.” ");
INSERT INTO aia_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Na'i ononai hura ana Elisabet na to'ora 'iniai gare, 'ia God 'a ha'ataaria enjel Gebrel 'ari na'i 'omaai Nasaret na'i Provensi Galili. ");
INSERT INTO aia_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","I enjel 'a taha beiai gere urao haoru ta'aa na ai'a 'ari mau beia ta mwane. Na atanai gere uraosi 'ia Meri. Mia Meri 'a haguhagu beiai sae na atana 'ia Josep. 'Ia Josep 'a huta mai baaniai burungana Deved i mwaeraha. ");
INSERT INTO aia_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mana enjel 'a 'ariwou ma ha'atee o'ani, “Wa'ewa'e raha di'u tana'o Meri! 'Ia God 'a awa bei'o ma ha'agorohi'o.” ");
INSERT INTO aia_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","'Ia Meri 'a torakoke i 'adoma'ina ma kakui ahuna 'ini'i 'ado'ado 'ada'i ha'atee 'isi. ");
INSERT INTO aia_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mana enjel 'a ha'atee o'ani, “Abui mamaa'u Meri! 'Ia God 'a 'ome taeni'o. ");
INSERT INTO aia_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","I'oe 'oi to'ora 'inia ta gare mwane, ma na'i 'oha nai huta 'oi ha'a-atana 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","'Iia 'ai ha'i inoni hauasa marai 'unua 'iniai garena God na ororiu ara'a. 'Ia Araha God 'ai ha'amwaerahaa 'onaai wauwa ana, 'ia Deved. ");
INSERT INTO aia_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mana garesi 'ai marungiraau tarau i saeni Israel mana heimarungi ana 'a bwa'i 'oha nai hako.” ");
INSERT INTO aia_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mia Meri 'a ha'atee o'ani, “Ma'ai to'o he'ua i marehosi, na'i 'oha nau ai'a awa mau beia ta mwane?” ");
INSERT INTO aia_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mana enjel 'a aramia o'ani, “Na Hi'ona Maea 'ai boi na'i hungamu, mana mena ana God na ororiu ara'a 'ai awa bei'o. Tarana naasi na garesi 'ai maea, marai 'unua 'iniai garena God. ");
INSERT INTO aia_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","'O 'iraraai gere inamu a Elisabet? Ra 'adoma'inia do'iia 'agu bwa'i to'o gare'a. Ma na'i 'ohani 'iia 'a to'ora 'iniai gare, rei'uaa na wari, me naani'a i ononai hura ana. ");
INSERT INTO aia_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","'Ia God 'a bwa'i mareho nai bwara tanaa.” ");
INSERT INTO aia_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mia Meri 'a o'ani, “'Inau 'e inoni tatau'aro ana Araha God. 'A goro do'ai to'o o'asi tanaau 'onaai 'unua amua.” Naasi mana enjel 'agu hano baania. ");
INSERT INTO aia_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na'i murina moi 'ohasi, 'ia Meri 'a ha'ataura'i ma raurau 'ari 'anai 'omaa na'i toroi Jiudea. ");
INSERT INTO aia_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Na'i 'oha na ataha wou na'i 'omaasi, 'a siri na'i ruma ana Sakaraea ma ha'atee wa'ewa'e tanaa Elisabet. ");
INSERT INTO aia_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na'i 'oha 'ia Elisabet 'a rongoai ha'atee wa'ewa'e na haua Meri tanaa, na gare na'i ahuna Elisabet 'a 'ihara'i, mia Elisabet 'a rabe beiai Hi'ona Maea. ");
INSERT INTO aia_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ma na'i ringe raha 'a ha'atee hurasi o'ani, “'Ia God 'a ha'agorohi'o di'u'i mwane urao hako, mai ha'agorohiai kakae na'oi ha'ahutaa. ");
INSERT INTO aia_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","'A 'ua gasi na 'ia God 'a ha'agorohiau o'asi 'inia, 'oha i'oe, inana Araha agua 'o boi 'anai garihiau? ");
INSERT INTO aia_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","I'oe 'e inana Araha, 'au 'iraraa o'asi, 'inia na'i moi 'oha nau rongoai ha'atee wa'ewa'e amua tanaau, na gare na'i raronai ahuguni 'a 'ihara'i 'iniai wa'ewa'e. ");
INSERT INTO aia_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","'Ia God 'ai ha'agorohi'o 'iniai hinihinia amua do'ai to'o ha'a-momori tana'o i taha na duruduru 'inia.” ");
INSERT INTO aia_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mia Meri 'a o'ani, “Ni tahingagu 'a ha'aasaa Araha God. ");
INSERT INTO aia_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mau wa'ewa'e, 'inia 'iia na ha'atahiau. ");
INSERT INTO aia_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","'Iia 'a 'adoma'iniau i inoni tatau'aro ana, rei'uaa nau ai'a ororiu. Na'i 'ohani ma 'ari'a, na mwane ugui inoni rai ha'arangasia hura'a i ha'agorohiau na haua God, ");
INSERT INTO aia_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","'iniai mareho hauasa na haua tanaau 'iniai mena ana. Na atana na maea. ");
INSERT INTO aia_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","'Iia 'a ahu ta'ahirai nei nara ginagina 'inia, suri'i mwane ugui inoni he'ete'i hairiu. ");
INSERT INTO aia_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","'Iia 'a hau'i mwane tatau'aro hauasa 'iniai mena ana. 'Iia 'a taari 'adara'iniraaui nei nara 'adoma'i ha'ata'eraau haariraau. ");
INSERT INTO aia_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","'A ha'a-hura'ahiraaui mwaeraha baani'i dora ni heimarungi adaa'i, ma ha'a-ororiuraaui nei rau heiheiraau aho'i. ");
INSERT INTO aia_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","'Iia 'a hanganiraau 'ini'i mwane mareho goro 'i nei ra hioro, ma ha'a-taariraau beira'i kongari nei ra toto'ora. ");
INSERT INTO aia_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","'Iia 'a 'a'auhigaaui Israel, i inoni tatau'aro ana'i, ma ahu ta'ahia tarau a Ebraham mana warowarona'i, 'onaai durua ana tanaraaui wauwa agaa'i.” ");
INSERT INTO aia_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mia Meri 'a ga'i 'onaai oru hura na awa beia Elisabet, maagu aho'i 'ari 'omaa ana na'i Nasaret. ");
INSERT INTO aia_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na'i 'oha nagu tari mai madoraa ana Elisabet 'anai ha'ahuta, 'a ha'ahutaai gare mwane. ");
INSERT INTO aia_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","'Iraaui noni ana'ia Elisabet, miraaui nei narau mono goni ta'i 'omaa rau rongoai heita'ahi 'ia Araha God na haua tanaa, marau wa'ewa'e beia 'inia. ");
INSERT INTO aia_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ma na'i warunai dangi, rau goni mai 'anai hauai ringei aha ha'ara tanaai kakae, ma 'anai ha'a-atana 'inia Sakaraea, 'e ha'amarahu suriai amana. ");
INSERT INTO aia_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mana inanai garesi 'a ha'atee wetewete tanaraau o'ani, “Ai'a. Na atana 'ia Jon!” ");
INSERT INTO aia_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Miraau inoni rau o'ani 'inia, “Mi'oe ai'a tanei na'i burungamu nai to'oraai atasi.” ");
INSERT INTO aia_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Naasi marau haai ha'ara tanaai amanai garesi 'anai 'unua ta ata nai 'irisia nana. ");
INSERT INTO aia_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mia Sakaraea 'a hauai ha'ara tanaraau dorai haua tanaa ta mareho 'anai usu-usu na'iei. Ma na'i 'oha narau haua tanaa, 'a usua o'ani, “Na atana 'ia Jon.” Na'i 'ohasi na mwane inoni hako ra heimwaota'i di'u. ");
INSERT INTO aia_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma na'i mau 'ohasi 'a matai hadahada aho'i ma taraawa'a ha'aasaa God. ");
INSERT INTO aia_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na mwane inoni na'i 'omaasi 'a kakui ahudaau hako, mana marehosi ra hadanga'inia suri'i mwani 'omaa na'i toroi Jiudea. ");
INSERT INTO aia_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Miraau hakoi nei rau rongoa rau wai'ado'ado surisuria, rau o'ani, “Romwane, 'ai ha'i sae he'ua na'i 'oha nai raha ara'a?” Rau ha'atee o'asi, suria rau aidangisia doni mena ana God 'a awa beiai garesi. ");
INSERT INTO aia_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mia Sakaraea, amana Jon, 'a rabe beiai Hi'ona Maea ma ha'atee rarabeanga'ini'i taha 'ia God na 'unu'i tanaa. ");
INSERT INTO aia_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Gau magai ha'atee ha'agorohia Arahaga, i God agaaui Israel, 'inia 'iia 'a boi 'anai ruhasiraaui inoni ana'i. ");
INSERT INTO aia_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","'A haua tanagiai Ha'atahi na wetewete na hura'a baaniai burunganai inoni tatau'aro ana, 'ia Mwaeraha Deved. ");
INSERT INTO aia_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Naasi taha na duruduru 'inia na'i ngoodaa'i rarabea ana'i 'oha bwani. ");
INSERT INTO aia_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","'A durua do 'ai ha'atahigia baani'i maerongaga, mei baani'i hakoi mena adaa'i nei ra 'utaigia. ");
INSERT INTO aia_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","'Iia 'a ha'ata'iniai ahu heita'ahi ana tanaraaui wauwa agaa'i, suria 'a ai'a kaku'aai duruduru ana tanaraau na wetewete ma maea. ");
INSERT INTO aia_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Na durudurusi 'a haua tanaa Ebraham, i wauwa agaau. ");
INSERT INTO aia_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","'A 'unua do 'ai ha'atahigia baaniraaui maerongaga, magai abui mamaa'u na'i 'oha gai tau'aro tanaa God, ");
INSERT INTO aia_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","beiai awaha na maea mana odo-odo na'i maana suri'i mwane dangiga. ");
INSERT INTO aia_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mi'oe gare agua, rai 'unu'o 'e rarabea ana God ororiu ara'a, suria i'oe 'oi na'otara tanaai Araha 'anai ha'aagauraaui noni 'anai boi ana. ");
INSERT INTO aia_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","'Oi taroha'inia tanaraaui inoni i tahi tarau na 'ia God 'ai matai haua tanaraau 'oha nai 'adoma'i nugasi'i ora-ora'a adaa'i. ");
INSERT INTO aia_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ma'ai o'asi 'iniai ahu heita'ahi ana God tanagaau. 'Onaai sina na ara'a, i Ha'atahi aga 'ai boi baaniai aro ");
INSERT INTO aia_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","'anai bewaasiraaui nei narau awa na'i kuhi, mara awa na'i bahainai heimarungi anai mae. 'Iia 'ai na'otaragia 'anai hagu goro aho'i beia God.” ");
INSERT INTO aia_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mia Jon 'a raha ara'a ma ha'i sae raroma goro. 'A 'ari ma awa na'i dora mangasara, tari 'oha na taraawa'a heitaroha'i tanaraaui inoni nai Israel. ");
INSERT INTO aia_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na'i madoraa na kekerei maua Jon, 'ia Ogastas na mwaeraha adaaui Rom, 'a ha'a-urasiai ringe 'anai usu ata tanaraau hakoi mwane inoni suri'i 'ado dora narau awa na'i bahainai heimarungi ana. ");
INSERT INTO aia_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Naasi 'etanai usu ata naigui to'o na'i madoraa na 'ia Kuirinias na Primia 'anai Provensi Siria.) ");
INSERT INTO aia_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na mwane inoni hako ra hano baani'i 'omaa nara awa suri'i mara 'ari 'anai usu ata suri'i huudi 'omaa adaa'i. ");
INSERT INTO aia_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Naasi 'ia Josep 'a hano baaniai 'omaai Nasaret na'i Provensi Galili, ma 'ari na'i Betlehem, 'omaa ana Deved, na'i Provensi Jiudea. 'Ia Josep 'a 'ari Betlehem, suria 'iiasi 'e burungana Deved. ");
INSERT INTO aia_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mia Meri nara durua tanaa Josep 'anai waina, raru ta'i hano ro'u 'anai usu ata. Mia Meri 'a bwane to'ora 'iniai gare. ");
INSERT INTO aia_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma na'i 'oha narau awa na'i Betlehem, 'a tari mai madoraa anai gare 'anai huta. ");
INSERT INTO aia_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mia Meri 'a ha'ahutaai 'etanai gare ana, 'e gare mwane. 'A ho'ua 'ini'i bwana, ma ha'adadaoa na'i dora ni hangani mwamwaa, suria na'i ruma ni mahuara 'a ai'a taradarua. ");
INSERT INTO aia_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma na'i rodosi, ra'i sae nara awa hura'a baaniai 'omaasi narau 'omesuri'i siip adaa'i. ");
INSERT INTO aia_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Raugu 'asu'a mana enjel ana Araha God 'a ha'ata'i tanaraau, mana rarahana Araha God 'a bewaasiraau. Miraau mamaa'u di'u. ");
INSERT INTO aia_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mana enjel 'a ha'atee o'ani tanaraau, “Mou abui mamaa'u! 'Inau 'au boi beiai taroha na goro tana'amou 'anai ha'a-wa'ewa'eraaui mwane inoni hako. ");
INSERT INTO aia_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na de'eni, i nei 'anai ha'atahi'amou na huta mai na'i 'omaa ana Deved. 'Iia naasi Kraest i Araha. ");
INSERT INTO aia_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma naani ha'ara 'inia tana'amou. Moi 'omesiai gare nara ho'ua 'ini bwana nara ha'adadaoa na'i dora ni hangani mwamwaa.” ");
INSERT INTO aia_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Raugu 'asu'a ma'e kae ruruhai enjel rau rurugoni mai beiai nata enjel ani marau ha'atee ha'agorohia God o'ani, ");
INSERT INTO aia_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ha'ahauasaa God na'i aro, mana gooroha ana 'ai awa beiraaui nei na'i marewana na 'ia God 'a ahugoro 'iniraau.” ");
INSERT INTO aia_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","'Iraaui enjel rau aho'i ara'ai aro, miraaui 'omesuri siip raugu o'ani 'iniraau hairiu, “Gaau magai 'ari 'omesiai taha na to'o na'i Betlehem, na 'ia Araha God na ha'arangasia tanagaau.” ");
INSERT INTO aia_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Marau raurau 'ari Betlehem, rau sadoia Josep mea Meri mana kakae na dadao na'i raronai dora ni hangani mwamwaa. ");
INSERT INTO aia_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na'i 'oha narau 'omesiai kakae, rau maani'i mwane mareho na enjel 'a maani'i tanaraau 'iniai kakaesi. ");
INSERT INTO aia_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Miraaui nei narau rongo'i, rau heimwaota'i di'u 'ini'i mareho narau maani'i. ");
INSERT INTO aia_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mia Meri 'a nuga'i mareho 'isi na'i 'adoma'ina ma wai'ado'ado suri'i tarau. ");
INSERT INTO aia_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Miraau na 'omesuri siip rau aho'i. Rau ha'aasaa marau ha'atee ha'agorohia God 'ini'i mwane mareho narau rongo'i marau 'omesi'i. Ra to'o 'onaaiai taha i enjel na maani'i tanaraau. ");
INSERT INTO aia_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na'i 'oha na gare 'a tari warunai dangi, ra haua tanaai ringei aha ha'ara marau ha'a-atana 'inia Jisas. Naasi ata na enjel 'a bwane 'unua mau na'i 'oha na ai'a toto mau na'i ahuna inana. ");
INSERT INTO aia_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","'Agu tari mai madoraa ana Josep mea Meri 'anai ha'a-wariwarirarua aho'i na'i maana God 'onaai Ringe ana'ia Moses na 'unua 'anai haua murinai huta anai gare. Raru waiai kakae 'ari Ruma Maea ana God na'i Jerusalem 'anai wateai gare tanaa Araha God, ");
INSERT INTO aia_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","'inia na Ringe ana'ia Moses 'a o'ani, “Na 'adodi 'etadi gare mwane rai wate'i tanaa Araha God.” ");
INSERT INTO aia_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Miraru haua ro'u i ho'asi tanaa God suriai ringe na 'ia Moses na 'unua dorai ho'asi 'inia ta rua abei 'ao ma'ua ta rua garei waibora. ");
INSERT INTO aia_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na'i 'ohasi 'e sae atana 'ia Simion 'a awa na'i Jerusalem. 'Iia 'e sae odo-odo na awa suriai hei'irisina God. 'Ia Simion 'a mamasiai 'oha na 'ia God 'ai ha'ataaria mai ta nei 'anai ruhasiraaui inoni nai Israel. Mana Hi'ona Maea 'a rabe beia, ");
INSERT INTO aia_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ma bwane 'unua tanaa do 'iia 'a bwa'i mae tari 'oha 'ai 'omesiai Ha'atahi na 'ia Araha God 'a duruduru 'inia 'anai ha'ataaria mai. ");
INSERT INTO aia_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mana Hi'ona Maea 'a tau'aro na'i raromana Simion, ma 'ari na'i Ruma Maea. Ma na'i muri, 'ia Josep mea Meri raru ataha mai 'anai watea Jisas tanaa Araha God 'onaai Ringe ana'ia Moses na 'unua. ");
INSERT INTO aia_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Mia Simion 'a suru'iai kakae ma ha'atee ha'agorohia 'inia God. 'A o'ani, ");
INSERT INTO aia_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Araha God, na duruduru amua 'a to'o ha'a-momori'a. Naasi, 'au wa'ewa'e'a mau ha'aagau 'anai mamaro baaniai marewanani. ");
INSERT INTO aia_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","'Inia 'inau wanara'i maa 'iniai nei na'o ha'aagaua 'anai ha'atahiraaui mwane inoni hako. ");
INSERT INTO aia_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Na kakaeni 'ai 'onaai raita nai ha'ata'iniai huunai tara tanaraaui nei narau ai'a Jiu, ma'ai ha'a-ororiu'ameu inoni amu'i nai Israel.” ");
INSERT INTO aia_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mia Josep mea Meri raru heimwaota'i 'ini'i mareho na 'ia Simion na 'unu'i 'iniai gare adarua. ");
INSERT INTO aia_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ma na'i 'oha 'ia Simion 'a ha'agorohiraau hako, magu ha'atee o'ani 'inia Meri, “Ni gareni, 'ai ragoi noni nai Israel nai ha'a-auruhiraau, ma'ata 'ai rago ro'u i nei nai ha'a-ara'ahiraau. 'Inia naasi maho na 'ia God 'a 'ome sigihia 'anai haua. 'Iia 'e ha'ara 'anai ha'ata'inia God tanaraaui noni. Ma'ata 'ai ragoi nei narai ura bwarasia, ");
INSERT INTO aia_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","mana mwane mareho nara bainihu suri'i 'adoma'idaa'i rai ha'ata'i hura'a. Mei tana'o Meri, na ahutotou 'ai maata'i 'onaai naihi na ganu tahuraga na'i to'ohunumu.” ");
INSERT INTO aia_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na'i ro'u i 'ohasi 'e urao rarabea nara 'unua 'inia 'Aana na awa beiraau na'i Ruma Maea ana God. 'Iia 'e gare ana Panuel baaniai burungana 'Asa. 'Ia 'Aana 'a wari di'u'a, me 'iia 'e nao. 'E biu harisi nararu ha'iwai mwane ana, mana mwane ana 'a mae baania. ");
INSERT INTO aia_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","'Iia 'a awa 'ari, mana harisina 'agu buna tari na'i waru tangahuru mana hai. 'Ado dangi mana rodo 'a siri Ruma Maea ana God 'anai ririhunga'i. 'A ha'aririta'i ngau ma awa moi 'anai ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na'i 'oha na hadahada maua Simion beia Josep mea Meri, 'ia 'Aana 'a 'ariwou beiraau ma ha'atee ha'agorohia God 'iniai gare adarua. Ma na'i muri, 'a maania Jisas tanaraaui nei narau mamasiai boi anai Ha'atahi 'anai ha'atahiraaui inoni nai Israel. ");
INSERT INTO aia_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na'i 'oha 'ia Josep mea Meri raru hau'i hako i taha na Ringeringe ana God na 'irisia, rarugu aho'i 'ari 'omaa adarua i Nasaret na'i Provensi Galili. ");
INSERT INTO aia_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mia Jisas 'a raha ara'a beiai wetewete mana madoma, mia God 'a ha'agorohia di'u. ");
INSERT INTO aia_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ha'atai na'i 'ado harisi i amana mana inana Jisas raru 'ari Jerusalem 'anai ha'ato'oai rongo 'anai 'adoma'i aho'isiai Roho Aharau. ");
INSERT INTO aia_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma'e ta'i 'oha, na taha mai madoraa 'anai 'ari ro'u 'anai rongosi, 'ia Jisas harisina 'a tari ta'i tangahuru mana rua. 'Ia amana mia inana raru waia ro'u 'ari 'anai dangi hauasa naasi. ");
INSERT INTO aia_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na'i 'oha na ngaugoni 'a hako, 'ia amana mia inana Jisas raru hano 'anai aho'i 'ari 'omaa adaau, mia Jisas 'a awa mau na'i Jerusalem. Mirarua raru ai'a 'iraraa o'asi, ");
INSERT INTO aia_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","'inia raru 'adoma'inia do'a ga'i awa ta dora beiraau na'i kae ruruha narau ta'i hanosi. Ma naasi raru hano'a suriai dangi bubu. Ma na'i su'urahi, rarugu taraawa'a siba suria beiraaui nei ana'i, mei beiraaui sae narau hei'irara'i. ");
INSERT INTO aia_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Na'i 'oha nararu ai'a sadoia, rarugu aho'i 'ari Jerusalem 'anai 'ome 'inia. ");
INSERT INTO aia_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","'E rua dangi na hako'a ma rarugu to'oanai heinagu ana beiraaui Ha'ausuri adaa'i Jiu na'i dora a'ora na'i maanai Ruma Maea ana God. 'A bahurongo suri'i taha narau maani'i ma sosonga'iniraau. ");
INSERT INTO aia_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Miraaui nei narau rongoa rau heimwaota'i di'u 'iniai aidangi ana mana heiarami ana'i. ");
INSERT INTO aia_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na'i 'oha 'ia inana mia amana raru 'omesia, raru kae heimwaota'i di'u ro'u 'inia. Mia inana 'a ha'atee o'ani 'inia, “Garegu, ni 'uaana na'o haua o'asi 'inia tana'amiria? 'I'amiria amamu 'a kae ta'aabemiria di'u 'ini'o, 'ini bonasiai sadoi'o.” ");
INSERT INTO aia_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mia Jisas 'a o'ani 'inirarua, “Ni 'uaana muru sibaniau 'inia suri'i mwani dora? Muru ga'i 'iraraa do 'inau wai awa na'i ruma ana Amagu!” ");
INSERT INTO aia_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mia Josep mea Meri raru ai'a aidangisiai taha 'ia Jisas na 'unua tanararua. ");
INSERT INTO aia_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Naasi 'ia Jisas 'a aho'i beirarua 'ari Nasaret ma awa bahainai heimarungi adarua. Mia inana 'a nuga'i mareho nara to'o 'isi na'i 'adoma'ina ma wai'ado'ado tarau suri'i. ");
INSERT INTO aia_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Naasi mia Jisas 'a raha ara'a beiai madoma mia God miraaui inoni rau wa'ewa'e 'inia. ");
INSERT INTO aia_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Na'i ta'i tangahuru mana rimanai harisi na 'ia Taebirias na mwaeraha 'anai Rom, 'ia Pontias Paelat naasi na Primia 'anai Provensi Jiudea, mia Herod Antipas naasi na heimarungi na'i Provensi Galili. 'Ia Pilip, do'orana Herod naasi na heimarungi na'i Provensi 'Ituria mana'i Trakonaetis mia Lisanias na heimarungi na'i Abilin. ");
INSERT INTO aia_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ma na'i ro'u i 'ohasi, 'ia 'Anas mea Kaeafas nararu Na'ohadaaui Piriisi adaa'i Jiu. Hoita, na'i 'ohasi 'ia God 'a haa'i ha'atee ana'i tanaa Jon, garena Sakaraea, na'i 'oha na 'ia Jon 'a awa na'i 'omaa mangasara. ");
INSERT INTO aia_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mia Jon 'a 'ari suri'i 'omaa gaarangiai wai Jodan 'anai taroha'ini'i ha'atee ana'ia God tanaraaui inoni. 'A o'ani 'iniraau, “Moi rihosi baani'i mwane baronga ta'a'i amoo'i mamoi bwareomaea, mia God 'ai 'adoma'i nugasi'i 'inomoo'i.” ");
INSERT INTO aia_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Na'i 'oha bwani 'ia rarabea Aisaea 'a usu taroha'iniai boi ana Jon. 'A o'ani, “'E nei nai totoro hura'a na'i dora mangasara. 'Ai ha'atee o'ani, ‘Moi ha'aagau! 'Ia Araha 'a gaarangi boi'a. Moi ha'a-odoodoai tara tanaa. ");
INSERT INTO aia_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Moi anoi'i mwane marawai, mana mwane bo'obo'o, mana hungahunga moi ha'a-auruhi'i. Na tara mwakirukiru'a moi ha'a-odoodo'i, mana tara nara kokekoke'a moi ha'a-aratara'i. ");
INSERT INTO aia_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mana mwane inoni hako raigui 'omesia do 'ia God 'ai ha'atahiraau.’” ");
INSERT INTO aia_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hoita, 'a ragoi inoni nara boi do'ia Jon 'ai bwareomaearaau. Me tara'i nei 'iniraau ra ai'a boi beiai huunai 'ado'ado 'anai rihosi. Mia Jon 'a ha'atee o'ani 'iniraau, “'I'amou mwane mwaa ta'a'i! 'A 'ua? Mou 'adoma'inia doni bwareomaea moi nai 'a'auhi'amou 'anai bainihu baaniai ha'a-mama'ai na 'ia God 'ai ha'ataaria mai? ");
INSERT INTO aia_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","'Onaa namou 'irisiai bwareomaea mamoi nugasi'i barongamoo'i nara ta'a'i, mamoi hau'i mareho goro nai ha'ata'inia domou rihosi baani'i ora-ora'a amoo'i. Mou gasigu 'adoma'inia do'ia God 'a bwa'i ha'a-mama'ai'amou do 'iniai huta amoou mai 'onaai warowarona'i a Ebraham. 'Inau wai 'unua tana'amou, 'ia God 'a matai ha'a-aho'ita'ini'i hau 'ini, marai ha'i warowarona'i a Ebraham. ");
INSERT INTO aia_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","'Ia God 'a ha'aagau'a 'anai ha'a-mama'airaaui nei nara ai'a 'adoma'i orisi. 'A 'onaai nei na ha'aagau 'anai arai'i dioi mwane hasi'ei. 'Onaa nara bwa'i hungu 'ini'i hua goro, 'ai ara dio suri'i raridi mai gaasi'i ara'ai 'eu 'anai suu gata'ini'i.” ");
INSERT INTO aia_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Miraau inoni rau songa'inia Jon o'ani, “'Onaa na o'asi, ma'e taha namei haua 'anai ha'ata'inia domeu rihosi baani'i ora-ora'a amee'i?” ");
INSERT INTO aia_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mia aramiraau o'ani, “'Iatei 'ini'amou na to'o rua to'oni abe, 'ai hisungia mo'o na pohara 'inia ta ta'i nei, mia mo'o na to'o mahoingau 'ai hisungia mo'o na ai'a to'ora mahoingau.” ");
INSERT INTO aia_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma ra'i sae haha'a takisi nara boi do'ai bwareomaearaau, rau o'ani 'inia, “Ha'ausuri, me 'imeeu 'e taha namei haa?” ");
INSERT INTO aia_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mia Jon 'a aramiraau o'ani, “Moi abui ha'angoni di'uai siha ha'a na gaumani na soia baaniraaui inoni 'anai takisi 'inia.” ");
INSERT INTO aia_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma tara'i hehei'oi ra boi beia mara o'ani 'inia, “Me 'imeeu 'a 'ua? 'E taha namei haa?” Mia aramiraau o'ani, “Moi abui ha'a-mamaa'usiraaui inoni 'anai ha'i ha'a tana'amou, ma'ua to'o haisubuni 'anai rahi ha'a baaniraau. Moi wa'ewa'e 'iniai siha ra horimou 'inia.” ");
INSERT INTO aia_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na 'ado'adodaaui inoni hako ra wetewete 'anai 'omesiai Ha'atahi, marau 'adoma'inia do 'ia Jon naasi gasi na 'ia God na 'ome sigihia. ");
INSERT INTO aia_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mia Jon 'a aramiraau o'ani, “'Inau 'au bwareomaea'amou 'iniai wai, mia mo'o nai boi na'i murigu, 'ai bwareomaea'amou 'iniai Hi'ona Maea mana 'eu. 'Iia 'a ororiu di'uau minau ai'a arari 'anai mwaoro auru 'anai wagasi'i sandol ana'i. ");
INSERT INTO aia_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","'Iia 'a ha'aagau 'anai hoairaaui noni goro baaniraaui nei ta'a'i, 'onaai nei na hoai'i koradi wiit ana'i baani'i kahokahodi. 'Iia 'ai nugaraaui noni goro na'i dora goro, ma'ai ha'a-mama'airaaui noni ta'a'i, 'onaai nei na nuga ha'agorohi'i koradi wiit na'i dora 'ana mana kahokahodi 'a suu gata'ini'i na'i 'eu na bwarai kuru.” ");
INSERT INTO aia_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma ra'i mwane mamaani he'ete'i hairiu o'asi na 'ia Jon na hau'i 'anai taroha'iniai Taroha Goro tanaraaui inoni. Ma ha'ata'u'uraau wetewete 'anai orisi'i barongadaa'i nara ta'a'i. ");
INSERT INTO aia_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma'e ta'i 'oha, 'ia Jon 'a raongia Herod Antipas 'iniai waina ana Herodias, 'e urao ana ga'u a do'orana, ma 'ini'i ro'u i mwane mareho ta'a'i na haa'i. ");
INSERT INTO aia_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mana ta'i mareho na ta'aa di'u ro'u wou na haua, naasi i 'unua ana tanaraaui sae hehei'oi 'anai gaasia Jon Bwareomaea na'i rumaniho'o. ");
INSERT INTO aia_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na'i 'oha na 'ia Jon 'a bwareomaearaaui inoni, 'oha narau ai'a nugaa mau na'i rumaniho'o, 'iia 'a bwareomaeaa ro'ua Jisas. Ma na'i 'oha 'ia Jisas 'a ha'arahesi, na aro 'a heihoa, ");
INSERT INTO aia_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","mana Hi'ona Maea 'a dio na'i hungana na'i 'omehanai waibora. Ma'e ringe na ao diomai baaniai aro 'a o'ani, “I'oe naasi garegu nau ta'ahi'o ororiu, mau ahugoro 'ini'o.” ");
INSERT INTO aia_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","'Oha na 'ia Jisas 'a tari oru tangahurui harisi, nagu taraawa'a hura'a 'anai hauai tatau'aro ana 'anai ha'ausuriraaui inoni. Na'i 'ado'adodaaui inoni, rau 'adoma'inia do'ia Jisas 'e gare ana Josep. Mia Josep 'e garena Hilae, ");
INSERT INTO aia_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mia Hilae 'e garena Matat, 'ia Matat 'e garena Livae, mia Livae 'e garena Melkae. 'Ia Melkae 'e garena Janai, mia Janai 'e garena Josep. ");
INSERT INTO aia_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","'Ia Josep 'e garena Matataeas, 'ia Matataeas 'e garena 'Emos. 'Ia 'Emos 'e garena Neham, mia Neham 'e garena 'Eslae. 'Ia 'Eslae 'e garena Nagai, ");
INSERT INTO aia_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mia Nagai 'e garena Maat. 'Ia Maat 'e garena Matataeas, mia Matataeas 'e garena Semein. 'Ia Semein 'e garena Josek, mia Josek 'e garena Joda. ");
INSERT INTO aia_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","'Ia Joda 'e garena Joanan, mia Joanan 'e garena Risa. 'Ia Risa 'e garena Serababel, mia Serababel 'e garena Saltiel. 'Ia Saltiel 'e garena Nerae, ");
INSERT INTO aia_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mia Nerae 'e garena Melkae. 'Ia Melkae 'e garena Adae, mia Adae 'e garena Kosam. 'Ia Kosam 'e garena Elmadam, mia Elmadam 'e garena 'Eri. ");
INSERT INTO aia_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","'Ia 'Eri 'e garena Josua, mia Josua 'e garena 'Eliesa. 'Ia 'Eliesa 'e garena Jorim, mia Jorim 'e garena Matat. 'Ia Matat 'e garena Livae, ");
INSERT INTO aia_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mia Livae 'e garena Simion. 'Ia Simion 'e garena Jiuda, mia Jiuda 'e garena Josep. 'Ia Josep 'e garena Jonam, mia Jonam 'e garena Elaeakim. ");
INSERT INTO aia_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","'Ia Elaeakim 'e garena Milia, mia Milia 'e garena Mena. 'Ia Mena 'e garena Matata, mia Matata 'e garena Netan. 'Ia Netan 'e garena Deved, ");
INSERT INTO aia_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mia Deved 'e garena Jesi. 'Ia Jesi 'e garena Obed, mia Obed 'e garena Boas. 'Ia Boas 'e garena Salmon, mia Salmon 'e garena Nason. ");
INSERT INTO aia_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","'Ia Nason 'e garena Aminadab, mia Aminadab 'e garena Admin. 'Ia Admin 'e garena Anae, mia Anae 'e garena Hesron. 'Ia Hesron 'e garena Peres, mia Peres 'e garena Jiuda. ");
INSERT INTO aia_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","'Ia Jiuda 'e garena Jekop, mia Jekop 'e garena Aisak. 'Ia Aisak 'e garena Ebraham, mia Ebraham 'e garena Tera. 'Ia Tera 'e garena Neho, ");
INSERT INTO aia_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mia Neho 'e garena Sirag. 'Ia Sirag 'e garena Riu, mia Riu 'e garena Peleg. 'Ia Peleg 'e garena Eba, mia Eba 'e garena Sila. ");
INSERT INTO aia_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","'Ia Sila 'e garena Keinan, mia Keinan 'e garena Afaksad. 'Ia Afaksad 'e garena Siem, mia Siem 'e garena Noa. 'Ia Noa 'e garena Lamek, ");
INSERT INTO aia_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mia Lamek 'e garena Metusala. 'Ia Metusala 'e garena Inok, mia Inok 'e garena Jered. 'Ia Jered 'e garena Mahelalel, mia Mahelalel 'e garena Kenan. ");
INSERT INTO aia_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","'Ia Kenan 'e garena Enos, mia Enos 'e garena Set. 'Ia Set 'e garena Adam, mia Adam 'e garena God. ");
INSERT INTO aia_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","'Ia Jisas 'a bwareomaea hako, magu hano baaniai wai Jodan. Na'i 'ohasi na Hi'ona Maea 'a rabe beia. Mana Hi'ona Maea 'a waia 'ari na'i dora mangasara. ");
INSERT INTO aia_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ma'e hai tangahurui dangi na awa na'i dorasi na 'ia Saetan 'a ohongia na'iei. Na'i madoraasi 'a ai'a ngau, ma na'i ha'ahakona 'ia Jisas 'agu hioro. ");
INSERT INTO aia_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mia Saetan 'a ha'atee o'ani 'inia, “'Onaa i'oe garena God, 'oi ha'atee tanaai hauni mai aho'ita'i bredi.” ");
INSERT INTO aia_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mia Jisas 'agu ha'atee o'ani 'inia, “Na'i Usu-usu Maea ra usu o'ani, ‘I sae 'a bwa'i tahi moi 'iniai huai bredi.’” ");
INSERT INTO aia_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mia Saetan 'agu waia ara'a na'i dora ahaaha. Ma na'i moi gere madoraa, 'a ha'ata'ini'i hako tanaai mwane kantri na'i marewana hako, ");
INSERT INTO aia_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","magu ha'atee o'ani 'inia, “'Onaa na'oi topira'i ruru ma'oi ha'arahesiau, 'oi marungi'i mwane kantri 'isi mana toto'ora adaa'i wai hau'i hako tana'o. 'Inia na mwane mareho 'isi ra hau'i hako tanaau, ma 'inau wai matai hau'i tanaa mo'o nawai raba hau'i tanaa.” ");
INSERT INTO aia_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mia Jisas 'agu aramia o'ani, “Ra usua na'i Usu-usu Maea o'ani, ‘Moi ha'arahesia moi Araha God amoou, me 'iia moi namoi tau'aro tanaa.’” ");
INSERT INTO aia_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mia Saetan 'a waia 'ari Jerusalem ma ha'a-urasia na'i dora ahaaha na'i hunganai Ruma Maea ana God, magu o'ani 'inia, “'Onaa i'oe garena God, 'oi rege auru. ");
INSERT INTO aia_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","'Inia ra usua na'i Usu-usu Maea o'ani, ‘'Ia God 'ai ha'a-taariraaui enjel ana'i 'anai 'a'auhi'o. ");
INSERT INTO aia_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Rai dau bwarasi'o 'ini'i rimadaa'i mana uwamu'i ra bwa'i maara 'ini'i hau.’” ");
INSERT INTO aia_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mia Jisas 'a aramia o'ani, “Na Usu-usu Maea 'a o'ani, ‘Moi abui ha'imaania Araha God amoou.’” ");
INSERT INTO aia_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","'Oha 'ia Saetan 'a ohongia hakoa Jisas 'ini'i heiohongi 'isi, 'iia 'agu nugasia 'ana ta 'oha goro naigui sadoia 'anai ohongia ro'u. ");
INSERT INTO aia_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mia Jisas 'a aho'i 'ari Provensi Galili, mana mena ana Hi'ona Maea 'a awa beia. Na tarohana 'a 'adarara hako 'ari suriai mwane 'omaa na'i Provens naasi, mei suri'i tara'i dora he'ete'i ro'u wou. ");
INSERT INTO aia_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma na'i 'oha na ha'ausuri suri'i ruma ni ha'arahesi adaa'i Jiu, na mwane inoni hako ra ha'a-aneanea. ");
INSERT INTO aia_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Mia Jisas 'a aho'i 'ari Nasaret, i 'omaa na raha ara'a iei. Ma na'i dangi ni mamaro adaaui Jiu 'a siri na'i ruma ni ha'arahesi 'onaai bwane hahaua ana. Mia Jisas 'a ura ara'a ma 'oha'i baaniai Usu-usu Maea. ");
INSERT INTO aia_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mana usu-usu nara haua tanaa 'anai 'oha'iniasi, 'e dorai usu-usu na 'ia rarabea Aisaea na usua. 'A kehasiai bukasi, ma sadoiai dora 'anai 'oha'i ma 'oha'inia hura'a o'ani, ");
INSERT INTO aia_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Na Hi'ona Maea ana Araha God 'a awa beiau, suria 'iia na 'ome sigihiau 'anai taroha'iniai Taroha Goro tanaraaui pohara. 'Iia 'a ha'ataariau 'anai taroha'inia hura'a do 'iraaui nei nara hunasiraau na'i rumaniho'o rai ha'a-hura'ahiraau dadara'a, mana nei ra kuru rai 'ome'ome aho'i, mana nei nara awa ha'ata'airaau rai dadara'a. ");
INSERT INTO aia_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mia Araha God 'a ha'ataariau mai 'anai taroha'inia hura'a do 'a bwa'i orea mai ha'ata'iniai heita'ahi ana tanaraaui inoni ana'i.” ");
INSERT INTO aia_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mia Jisas 'a honosiai buka ma haua aho'i tanaai nei na na'otaranai rihunga'i ma heinagu auru 'anai ha'ausuriraaui inoni. Na mwane inoni na'i rumasi rau wana to'obuu 'inia. ");
INSERT INTO aia_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mia Jisas 'agu ha'atee o'ani 'iniraau, “Na dorai Usu-usu Maea namou rongoa nau 'oha'inia ani, 'a to'o ha'a-momori na'i 'ohani.” ");
INSERT INTO aia_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Miraau hakoi nei narau awa 'isi, ra ha'atee wa'ewa'e 'inia Jisas marau heimwaota'i 'ini'i mwane mareho rongo goro na maani'i. Miraaugu ha'atee o'ani, “'E gare moi ana Josep naasi.” ");
INSERT INTO aia_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jisas 'a o'ani 'iniraau, “'Au 'iraraa domou raba 'unuai dora i ha'atee na o'ani 'iniau, ‘Na nei na matai ha'agorohi'i inoni baani'i daoha, 'ai ha'agorohia ga'u haaria 'anai ha'ata'iniai mena ana.’ 'Ado'ado 'ana, ‘'Onaa i'oe naasi Ha'atahi, 'oi haa'i na'i 'omaa amua haari'o i ha'abu'oahu nameu rongoa na'o hau'i na'i Kapaniam.’” ");
INSERT INTO aia_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mia Jisas 'a o'ani ro'u, “Wai 'unua ha'a-momori tana'amou, ai'a rarabea'a do 'iraaui inoni na'i 'omaa ana rai ha'ahoua. ");
INSERT INTO aia_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na'i madoraa ana rarabea Elaija na'i 'oha bwani, 'a ragoi nao na'i Israel narau rongomaata'i. Na'i madoraasi, 'e oru harisi mana aba na ai'a rangi ma 'e hioro raha na to'o 'ari hako suri'i 'omaa hako na'i dorasi. ");
INSERT INTO aia_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Rei'uaa na towa'i o'asi, 'ia God 'a ai'a ha'ataaria Elaija 'anai 'a'auhia ta ta'i nao na'i kantri ana haaria, ma'ata 'e nao na'i 'omaai Sarefat na'i dora ra 'unua 'iniai Saedon na 'ia God na ha'ataaria Elaija do'ai 'a'auhia. ");
INSERT INTO aia_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma na'i madoraa ana rarabea Elaesa, 'a ragoi inoni na'i Israel na sadoiraau i daoha nara 'unua 'iniai lepa. Ma ai'a ta ta'i nei 'iniraau 'ia God 'ai ha'agorohia, ma'ata 'e inoni ni Siria moi na atana 'ia Neman, na 'ia God nagu ha'agorohia.” ");
INSERT INTO aia_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na'i 'oha na 'iraaui inoni na'i ruma ni ha'arahesi rau rongo'i mareho 'isi, rau taesu'a di'u 'ana Jisas. ");
INSERT INTO aia_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Naasi rau suruta'e 'anai tariha'inia hura'a Jisas baaniai 'omaasi. Ni 'omaasi 'a awa ta'eha na'i hungahunga. Naasi rau waia 'ari na'i bwaunai rihua na awa gaarangiai 'omaa dorai gaasia dio. ");
INSERT INTO aia_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mia Jisas 'a siri hokahoka na'i 'uruhadaau ma hano baaniraau. ");
INSERT INTO aia_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mia Jisas 'a 'ari Kapaniam, 'e 'omaa na'i Provensi Galili. Ma na'i dangi ni mamaro adaaui Jiu, 'a ha-ha'ausuriraaui inoni na'i ruma ni ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mana inoni hako rau heimwaota'i di'u 'ini'i ha'ausuringa'i ana'i, 'inia rau 'ome 'iraraa do'iia 'a huunai 'irara'i mareho na maani'i. ");
INSERT INTO aia_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma na'i ruma ni ha'arahesi na'i madoraasi, 'e sae na bwauniai adaro na awa 'isi, mana saesi 'a awara raha ara'a o'ani, ");
INSERT INTO aia_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“'Eii! Jisas, saeni Nasaret! 'O raba 'uaameuni? 'O boi 'anai ha'a-ta'ai'ameu? 'Inau 'au 'iraraa ha'agorohi'o! I'oe nei na maea na'o boi baania God.” ");
INSERT INTO aia_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mia Jisas 'a ha'atee hurasi tanaai adarosi. 'A o'ani, “'Oi papaku, ma'oi hura'a mai baania mo'osi!” Mana adarosi 'a 'idira'inia mo'osi dio na'i ano huniraau, magu hura'a baania, ma'ata 'a ai'a ha'amaaraai saesi. ");
INSERT INTO aia_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na mwane inoni hako ra heimwaota'i di'u mara heisosonga'i hairiu o'ani, “Romwane! 'E tahasi? Ni ha'atee ana'i ra to'o mena mara wetewete di'u! 'A ha'atee moi tanaraaui adaro 'anai hura'a mara hura'a'a.” ");
INSERT INTO aia_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mana tarohana Jisas 'a 'adarara hako 'ari suri'i mwane 'omaa he'ete'i ro'u wou gariai Kapaniam. ");
INSERT INTO aia_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mia Jisas 'a hura'a baaniai ruma ni ha'arahesi ma 'ari ruma ana Saemon. Ma na'i rumasi 'e urao na mata'i raha di'u na awa iei ma raorao di'u i abena. Mana uraosi 'e hungona Saemon. Miraaugu ha'angonia Jisas 'anai 'a'auhia. ");
INSERT INTO aia_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jisas 'a 'ariwou na'i bobonai be'anai uraosi, ma ha'atee wetewete tanaai mata'isi do'ai hura'a baania. Na'i mau 'ohasi, mana mata'i 'a rigisia'a, ma suruta'e ma ha'aagau mahoingau 'adaau. ");
INSERT INTO aia_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na'i 'oha na aurui sina, ra ragoi nei nara waa'i mai inoni nara sadoi'i mwane daoha he'ete'i hairiu. Mia Jisas 'a dau wou na'i hungadi, mara goro aho'i. ");
INSERT INTO aia_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mia Jisas 'a taari'i hura'a i adaro baaniraau tara'i sae, mana adaro ra ha'atee hurasi o'ani, “I'oesi garena God.” Mia Jisas 'a ha'a-aburaau wetewete dorai abui ha'atee'a ro'u, suria 'a 'iraraa dorau aidangisia do'iia naasi Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ma na'i mau i haho'oa ta'aa na'i nata dangi, 'ia Jisas 'a 'ari haaria na'i dora bwaranga. Miraaui inoni rau siba suria naraugu buna sadoia. Na'i 'oha narau sadoia, raugu ha'atee ha'abwarasia, marau 'unua tanaa do'ai awa ga'u beiraau na'i Kapaniam. ");
INSERT INTO aia_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mia Jisas 'a o'ani 'iniraau, “Nau wai taroha'inia ma'ata i Taroha Goro 'iniai heimarungi ana God 'ari suri'i tara'i 'omaa ro'u wou, 'inia naasi tarana na 'ia God 'a ha'ataariau mai 'inia.” ");
INSERT INTO aia_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naasi, mia Jisas 'a 'aariha hairiu 'anai taroha'iniai Taroha Goro suri'i ruma ni ha'arahesi na'i Provensi Jiudea. ");
INSERT INTO aia_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","'E ta'i 'oha 'ia Jisas 'a ura na'i one na'i bobonai kae bwera i Galili, mana inoni rau goni mai hunia 'anai bahurongo'i ha'atee ana'ia God, rau ha'asu'isu'ia di'u. ");
INSERT INTO aia_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma 'omesiai rua ora na'i wai, gaarangiai one. Miraaui sae ahu-ahuasi narau nuga'i ora 'isi, rau poru wasi orima'ini'i hu'o adaa'i. ");
INSERT INTO aia_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Miagu ta'e ara'a na'i ora ana Saemon, ma 'unua tanaa do'ai gere usuha'inia hura'a baaniai bobonai one, mia Jisas 'agu heinagu na'i ora 'anai ha'ausuriraaui inoni narau goni wou beia. ");
INSERT INTO aia_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma na'i 'oha na mamaani hako tanaraaui inoni, 'agu o'ani 'inia Saemon, “'Oi saraa hura'a i ora amua na'i dora su'u mamoi gaasia dioi hu'o, mamoi to'oi'i tara'i mwane ii'a.” ");
INSERT INTO aia_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mia Saemon 'a o'ani 'inia, “Saemaua, meu bona matoo suriai rodo bubu nabongi ani, ma ai'a ta ta'i ii'a namei to'oia. Ma'ata mei haua ro'u suriai 'unua amua.” ");
INSERT INTO aia_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","'Oha naraugu haua 'onaai 'unua ana Jisas tanaraau, mana hu'o 'a honu'a 'iniai ii'a, 'a gaarangi moi maai ohogao. ");
INSERT INTO aia_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Miraau booriraau tara'i abe adaa'i na'i nata ora 'anai boi 'a'au. 'Oha narau ataha mai beiraau, raugu buna ha'ahonua ro'u i rua ora 'ini'i ii'a, mana ora ra gaarangi marai dodo. ");
INSERT INTO aia_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Na'i 'oha 'ia Pita 'a 'omesia o'asi, 'a topiruru auru tanaa Jisas ma o'ani, “'Oi 'ari wou baaniau Araha, 'inau 'e inoni ora-ora'a!” ");
INSERT INTO aia_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","'Ia Pita 'a ha'atee o'asi suria 'a bu'o i ahudaa'i 'ini'i mwane ii'a narau ngahui'i. ");
INSERT INTO aia_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mirarua rua garena Sebedi, 'ia Jems mea Jon nararu 'a'auhia Pita, raru heimwaota'i di'u ro'u. Mia Jisas 'a o'ani 'inia Pita, “'Oi abui mamaa'u! Taraawa'a na'i 'ohani ma 'ari'a, 'oi wairaau mai sae beiau 'onaai rau'i amu'i ii'a na'i wai.” ");
INSERT INTO aia_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Miraaugu usu'i ora ara'ai dora mamata. Rau nugasi'i mwane mareho marau suria Jisas. ");
INSERT INTO aia_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mia Jisas 'a 'ariwou ma taha na'i 'omaa na awa iei sae na to'ia i daoha nara 'unua 'iniai lepa. Ni abena 'a 'ome ta'aa hako 'iniai lepa. Mana 'oha na saesi 'a 'omesia Jisas, 'a boi beia ma topiruru ma mwaoro auru na'i ano. Ma ha'angonia wetewetea Jisas o'ani, “Araha, 'onaa 'o mwa'emwa'e, ma'o ga'i ha'agorohiau aho'i baaniai daoha na to'iauni.” ");
INSERT INTO aia_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mia Jisas 'a taranga'inia hura'a i rimana, 'a dau wou beia ma o'ani, “'Io, 'au mwa'emwa'e moi, 'oi goro'a aho'i!” Na'i mau 'ohasi, na abena 'agu goro aho'i. ");
INSERT INTO aia_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mia Jisas 'a ha'aabua wetewete o'ani, “'Oi abu maania ga'u tanaa ta sae i maho na to'o bei'o. 'Oi 'ari odo-odo beiai Piriisi mai 'iraraa haaria do i'oe 'o goro aho'i. Naasi ma'oi hauai bane amua tanaai Piriisi maai ho'asi 'inia 'onaai 'unua ana Moses, 'anai ha'ata'inia tanaraaui noni do'o goro'a.” ");
INSERT INTO aia_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma rei'uaa na ha'aabua mo'osi, na taroha 'inia Jisas 'agu 'adarara ro'u wou baaniai na'o. Ma ragoi nei ra boi 'anai bahurongo'i ha'ausuringa'i ana'i, ma 'anai ha'agorohiraau baani'i daoha adaa'i. ");
INSERT INTO aia_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma'ata 'a ragoi 'oha 'ia Jisas 'a nugasiraaui inoni 'anai 'ari haaria na'i dora bwaranga 'anai ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ma'e ta'i dangi na 'ia Jisas 'a ha-ha'ausuri, ra'i Farisei ma tara'i Ha'ausuri ro'u 'anai Ringe ana'ia Moses narau heinagu na'i dorasi. Rau boi baani'i 'omaa na'i Provensi Galili mei Jiudea mei baaniai 'omaa raha i Jerusalem. Mana mena ana Araha God 'a awa beia Jisas 'anai ha'agorohirai nei ra daoha. ");
INSERT INTO aia_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ma na'i 'ohasi, ra'i inoni ra suru'ia mai sae na sadoiai abe nugu mana saesi 'a dadao na'i be'ana. Rau ha'imaania dorai waia siri tanaa Jisas, ");
INSERT INTO aia_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","magu bwara 'iniai rago di'u anai inoni. Mei suriai bwara ana tanaraau, rau suru'ia ta'eha suriai tara hanehane 'anai ta'ehai hunganai rumasi. Hunganai rumasi 'a sada moi. Rau tahangiai dora na'i hunganai ruma, marau toto'oa dioi saesi na'i 'uruhadaaui inoni na'i gaarangiai dora na 'ia Jisas na ura iei. ");
INSERT INTO aia_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","'Oha 'ia Jisas 'a 'ome 'iraraai hinihinidaau, 'agu o'ani 'inia, “Geresae agua, na ora-ora'a amu'i 'au 'adoma'i nugasi'i hako tana'o.” ");
INSERT INTO aia_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Miraau na Farisei mana Ha'ausuri 'anai Ringe ana'ia Moses narau awa 'isi raugu 'adoma'i o'ani haariraau, “I sae he'ua naasi? 'A 'adoma'inia do 'iia naasia God? 'Ia moia God nagau 'iraraa na matai 'adoma'i nugasi'i ora-ora'a! 'Iia 'a ha'atee ha'ata'aia God!” ");
INSERT INTO aia_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisas 'a aidangisiai taha na awa suri'i 'adoma'idaa'i, magu o'ani 'iniraau, “'A 'ua namou to'oraa 'iniai 'adoma'isi? ");
INSERT INTO aia_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Taha na mwada'u? 'Anai 'unua tanaai saesi do'au 'adoma'i nugasi'i ora-ora'a ana'i, ma'ua 'anai 'unua tanaa do'ai ura maai hahano? 'Anai 'unua tanaa mo'osi do'au 'adoma'i nugasi'i ora-ora'a ana'i 'a mwada'u, 'inia 'a bwarai 'iraraa 'onaa ra 'adoma'i nugasi'i ora-ora'a ana'i ma'ua ai'a. ");
INSERT INTO aia_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Naasi, 'inau i Garei Inoni wai hauai maho namou 'adoma'i ha'abwaraa ma moigu'i 'iraraa do 'au to'oraa ro'u i mena 'anai 'adoma'i nugasi'i ora-ora'a na'i marewanani.” Naasi magu o'ani 'iniai sae na abe nugusi, “Nau wai 'unua tana'o, 'oi ura ara'a, 'oi suru'iai be'amu, ma'oi 'ari ruma amua!” ");
INSERT INTO aia_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na'i mau 'ohasi na saesi 'a ura ara'a na'i maadaau hakoi inoni. 'A rahiai be'ana na dadao iei ma aho'i 'ari 'omaa ana, 'a ha'aasaa God. ");
INSERT INTO aia_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Miraaui mwane inoni narau 'omesiai marehosi ra bu'o hakoi ahudaa'i, marau ha'aasaa God. Rau honu 'iniai mamaa'u marau ha'atee o'ani, “'E kae mareho raha di'u nagau 'omesia na'i dangini.” ");
INSERT INTO aia_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Na'i muri 'ia Jisas 'agu hura'a wou ma 'omesiai sae na heinagu na'i dora ni horihori takisi. Na atanai saesi 'ia Livae. 'Iiasi 'e sae na tatau'aro tanaai gaumani 'anai si'ogoni'i takisi. Jisas 'agu o'ani 'inia, “Livae, 'oi boi suriau 'onaai rongoiusuri agua.” ");
INSERT INTO aia_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na'i mau 'ohasi, mia Livae 'a ura ara'a ma nugasi'i mwane mareho ana'i ma suria'a Jisas. ");
INSERT INTO aia_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Naasi 'ia Livae 'agu hauai kae ngaugoni tanaa Jisas na'i ruma ana. Ma ragoi inoni ha-ha'atakisi mana taraani inoni moi nara boi na'i ngaugonisi. ");
INSERT INTO aia_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Miraau na Farisei, ma tara'i Ha'ausuri 'anai Ringe ana'ia Moses nara aba beiraaui Farisei raugu ha'atee ha'a-ta'airaaui rongoiusuri ana'ia Jisas o'ani, “Ni 'uaana namou ngau 'inia beiraaui sae ha-ha'atakisi miraaui sae ta'a'isi?” ");
INSERT INTO aia_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mia Jisas 'agu aramiraau o'ani, “Na sae nara goro moi abedi ra bwa'i rabasiai 'a'au baaniai sae na matai ha'agorohi'i daoha, me 'iraau moi nei nara daoha nara rabasiai 'a'au. ");
INSERT INTO aia_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","'A o'asi ro'u, 'inau boi na'i marewanani, ai'a do 'anai 'a'auhiraau inoni odo-odo, ma'ata 'au boi 'anai 'a'auhiraaui inoni ora-ora'a dorai rihosi baani'i ora-ora'a adaa'i.” ");
INSERT INTO aia_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ma tara'i inoni ra ha'atee o'ani 'inia Jisas, “'Ado 'oha 'iraaui rongoiusuri ana'ia Jon Bwareomaea mana rongoiusuri adaa'i Farisei ra ha'aririta'i ngau 'anai ha'arahesi. Mi'oe na rongoiusuri amu'i rau ai'a ha'aririta'i ngau moe'a, rau ngau mara gono moi.” ");
INSERT INTO aia_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mia Jisas 'a aramiraau o'ani, “'A 'ua? 'I'amou mou 'adoma'inia do 'iraaui nei ra awa na'i rongo ni ha'iwai rai ha'aririta'i ngau 'oha na awa beiraau a mo'o ra ha'aha'iwaia? 'Abwa'i! ");
INSERT INTO aia_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma'ata tari 'oha na nei na ha'iwai rai waia baaniraau maraigui matai ha'aririta'i ngau 'iniai ahutotou adaau.” ");
INSERT INTO aia_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mia Jisas 'agu ha'ausuriraau ro'u o'ani, “'Abwa'i nei 'ai karia mwada'u ta maakari na'i to'oni haoru ana 'anai tata ponosia 'iniai dora na maakari na'i to'oni bwani. 'Onaa nai haua o'asi, 'ai here ha'ata'aiai to'oni haoru ana, mana maakari to'oni haorusi, 'a bwa'i 'ome ta'isada beiai to'oni bwanisi. ");
INSERT INTO aia_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Nata mareho ro'u, 'abwa'i nei nai matai nuga waen haoru suri'i bei bwani nara tagora'i 'ini'i uri-uri mwamwaa, 'inia na bei bwani ra bwane 'a'asi. Na'i 'oha na waen haoru 'ai su'u, na bei bwani rai pusu. Naasi mana waen rai ahe gata'ini'i, mana bei rai maakari ta'a'i. ");
INSERT INTO aia_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Na waen haoru rai niga'i ma'ata na'i bei haoru ro'u. ");
INSERT INTO aia_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na nei na gonohiai waen bwani na'i na'o, 'agu ai'a rabasia'a ro'u i waen haoru. 'Ai 'unua doni waen bwani na goro di'uai waen haoru.” ");
INSERT INTO aia_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ma'e ta'i dangi ni mamaro adaaui Jiu, na'i 'oha 'ia Jisas mana rongoiusuri ana'i rau tahahoro na'i 'ubutadi moui wiit, 'iraaui rongoiusuri raugu rahi'i tara'i nei marau rogaroga'i baani'i kahokahodi marau ngaa'i dora ngaungau. ");
INSERT INTO aia_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma tara'i Farisei rau o'ani 'iniraau, “Mou ga'i bwa'i husi'i wiit 'isi. Na'i dangi ni mamaro, i Ringe ana'ia Moses 'a ha'aabuai tau'aro na'i dangisi!” ");
INSERT INTO aia_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mia Jisas 'a aramiraau o'ani, “'A 'ua? Mou ai'a 'oha'iniai mamaani 'inia Mwaeraha Deved mana nei narau ta'i hano na'i 'oha narau hioro? ");
INSERT INTO aia_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","'Ia Deved 'a siri na'i Ruma Maea Saira ana God ma ngaai bredi nara ha'amaeaa ma hanganiraau ro'u i nei rau ta'i hano. Na bredisi 'iraau moi na Piriisi narau matai ngaa. Naasi 'ia Deved 'a horosia ro'u i Ringe mia God 'a ai'a taesu'a 'ana.” ");
INSERT INTO aia_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mia Jisas 'a o'ani ro'u 'iniraau, “'Inau Garei Inoni, 'inau 'au matai 'unu'i maho 'iraaui sae ra matai haa'i na'i dangi ni mamaro. 'Inia 'inau naasi Araha 'anai dangi ni mamaro.” ");
INSERT INTO aia_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma'e ta'i dangi ni mamaro ro'u, 'ia Jisas 'a siri na'i ruma ni ha'arahesi adaaui Jiu ma ha'ausuriraaui inoni. Ma na'i 'ohasi 'e sae na mae i rima odona na awa ro'u 'isi. ");
INSERT INTO aia_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Miraau na Farisei mana Ha'ausuri 'anai Ringe ana'ia Moses rau 'ome'ome 'onaa 'ia Jisas 'ai ha'agorohia aho'i sae na mae i rimanasi, do nei narai subunia do'a hauai tau'aro na'i dangi ni mamaro. ");
INSERT INTO aia_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","'Ia Jisas 'a 'iraraai 'adoma'idaa'i ma o'ani 'iniai sae na mae i rimanasi, “'Oi suruta'e ma'oi ara'a mai na'i na'o.” Mana saesi 'a ura ara'a ma ara'a ura na'i dora na mwane inoni rai matai 'omesia. ");
INSERT INTO aia_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mia Jisas 'agu o'ani 'iniraau, “Wai songa'ini'amou. 'E taha na Ringe ana'ia Moses 'a ha'awategaau 'anai haua na'i dangi ni mamaro? 'Anai haa'i mareho goro, ma'uasi 'anai haa'i mareho ta'a'i? 'Anai ha'atahiai noni ma'ua 'anai ha'amaesia?” ");
INSERT INTO aia_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mia Jisas 'a wanasiraau hakoi inoni magu o'ani 'iniai saesi, “'Oi taranga'inia hura'a i rimamu.” 'Oha na taranga'inia hura'a i rimana, na rima na ta'aasi 'a goro aho'i. ");
INSERT INTO aia_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na'i 'oha na 'iraaui Ha'ausuri 'anai Ringe ana'ia Moses miraau na Farisei rau 'omesia o'asi, rau kaeni taesu'a di'u marau ha'aradorado 'inia ta here narai haua 'ana Jisas. ");
INSERT INTO aia_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","'E ta'i dangi ro'u, 'ia Jisas 'agu ta'eha ara'a na'i hungahunga 'anai ha'arahesi. Ma'e rodo bubu na ha'arahesi suria tanaa God. ");
INSERT INTO aia_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na'i haho'oa 'a 'unuraau mai rongoiusuri ana'i beia, ma 'ome sigihiai waira ta'i tangahuru mana rua, na 'unuraau 'iniai Ha'ataari. ");
INSERT INTO aia_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","'Ia Saemon (na 'ia Jisas na 'unua 'inia Pita), 'ia Andru, do'orana Saemon, 'ia Jems, 'ia Jon, 'ia Pilip 'ia Batolomiu, ");
INSERT INTO aia_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","'ia Matiu, 'ia Tomas, mana nata Jems gare ana Alfias, 'ia Saemon baaniai ruruha ra raba taaria hura'a i gaumani adaaui Rom baania Israel, ");
INSERT INTO aia_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","'ia Jiudas gare ana Jems, mea Jiudas Iskariot, 'ia mo'o na usuha'inia Jisas tanaraaui maerongana'i. ");
INSERT INTO aia_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","'Ia Jisas 'a dio wou baaniai hungahunga beiraaui Ha'ataari ana'i marau ura na'i dora sada. Ma na'i 'ohasi 'a ragoi rongoiusuri ana'i ma tara'i inoni na'i Jerusalem mei suria hako 'ari i Provensi Jiudea nara rurugoni mai na'i dorasi. Ma ra'i nei ra boi ro'u baaniai rua kae 'omaai Taea mana Saedon nararu awa na'i bobonai asi. ");
INSERT INTO aia_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Rau boi goni 'anai rongo'i ha'ausuringa'i ana'ia Jisas, ma 'anai ha'agorohiraau baani'i daoha nara sadoiraau. Miraaui nei na adaro 'a bwauniraau, 'ia Jisas 'a taari'i hura'a baaniraau. ");
INSERT INTO aia_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na mwane inoni hako rau bonasia dorai hataria, suria na mena ana God na awa beia 'a ha'agorohiraaui nei rau daoha. ");
INSERT INTO aia_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mia Jisas 'a wanasiraaui rongoiusuri ana'i ma o'ani, “'Ia God 'ai ha'agorohi'amou i nei namou pohara, 'inia 'i'amou moi awa na'i bahainai heimarungi ana God. ");
INSERT INTO aia_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","'Ia God 'ai ha'agorohi'amou i nei namou hioro, 'inia 'i'amou moi dauai taha namou 'irisiasi. 'Ia God 'ai ha'agorohi'amou i nei namou angi, 'e madoraa nai boi mau namoi da'a ha'i wa'ewa'e. ");
INSERT INTO aia_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","'Ia God 'ai ha'agorohi'amou i nei ra 'utai'amou mara dingai'amou mara 'isi'isi'amou mara ha'atee ha'a-ta'ai'amou, suria 'i'amou ra'i rongoiusuri agu'i, 'inau i Garei Inoni. ");
INSERT INTO aia_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“'Oha na o'asi, moi honu 'iniai wa'ewa'e mamoi maomao. 'Inia 'e heitahari na raha na 'ia God 'a ha'aagau mamasi'amou 'inia na'i aro. Mamoi abui kaku'aa doni wauwa adaa'i ra here ha'ata'airaau o'asi ro'u i rarabea na'i 'oha bwani. ");
INSERT INTO aia_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ma'ata 'ai ta'aa di'u tana'amoui nei namou toto'ora, suria mou bwane awa na'i tahitahi na mwada'u mana madoraa ni pohara tana'amou 'ai boi mau. ");
INSERT INTO aia_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","'Ai ta'aa di'u tana'amoui nei namou ngaungau goro 'ohani, 'inia ni madoraa ni hioro tana'amou 'ai boi mau. 'Ai ta'aa di'u tana'amoui nei namou da'a 'ege'ege'amou, 'inia ni madoraa ni angi mana ahutotou tana'amou 'ai boi mau. ");
INSERT INTO aia_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","'Ai ta'aa di'u tana'amoui nei na 'iraaui noni rau ha'atee ha'agorohi'amou do 'i'amou ra'i sae goro. 'Inia na wauwa adaa'i ra ha'atee o'asi ro'u 'iniraaui rarabea pwapwaari'i na'i 'oha bwani. Ma rei'uaa na o'asi, mia God 'a ha'a-mama'airaau moi.” ");
INSERT INTO aia_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mia Jisas 'a o'ani ro'u, “Nau wai 'unua tana'amoui nei namou bahurongoau! Moi ta'ahiraaui maerongamoo'i mamoi goro tanaraaui nei ra 'itamou. ");
INSERT INTO aia_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Moi ha'angonia God maai ha'agorohiraaui nei ra 'uaasi'amou, mamoi ha'arahesi 'iniraaui nei ra here ha'a-ta'ai'amou. ");
INSERT INTO aia_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","'Onaa 'ia tei nai hidariai babamu, 'oi rihota'i maai hida ro'u na'i nata aba, ma 'onaa 'iatei nai rahia baani'o i to'oni bohura'a amua, nugasia mai rahia ro'u i to'oni bo siri. ");
INSERT INTO aia_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","'Iatei nai ha'angoni'o 'inia ta mareho, 'oi haua tanaa. Ma 'onaa ra'i mareho amu'i nara rahi'i baani'o, 'oi abu bonasiai rahi'i aho'i. ");
INSERT INTO aia_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ni here na'oi haua tanaai nata sae, 'ai suriai here na'o 'irisia dorai haua tana'o. ");
INSERT INTO aia_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“'Onaa na'oi ta'ahiraau moi nei narau ta'ahi'o, 'a bwa'i heitahari na'oi daua 'inia. Rei'uaa inoni ta'a'i, mara heita'ahi ro'u moi o'asi. ");
INSERT INTO aia_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma 'onaa 'o goro moi 'iniraaui nei nara goro 'ini'o, 'a bwa'i heitahari na'oi daua 'inia. 'Iraaui inoni ta'a'i mara matai haua ro'u moi o'asi. ");
INSERT INTO aia_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma 'onaa na'oi hisuhisu moi tanaraaui nei na'o 'iraraa dorai hisu aho'i tana'o, 'a bwa'i heitahari na'oi daua 'inia. Rei'uaa 'iraaui sae ta'a'i mara matai hisuhisu ro'u moi o'asi, 'iniai 'irisia adaau dorai su'u'i hako tanaraau aho'i taha narau hisu 'ini'i. ");
INSERT INTO aia_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Mi'amou moi ta'ahiraaui maerongamoo'i mamoi goro 'iniraau. Moi hisu tanaraau, mamoi abui 'adoma'inia dorai su'u'i aho'i tana'amou i taha namoi hisu 'ini'i. Naasi na heitahari amoou 'ai raha, marai 'ome 'iraraa do 'i'amou ra'i garena God na ororiu ara'a. 'Inia 'ia God 'a goro 'iniraaui inoni, rei'uaa na 'iraaui inoni rau ai'a ha'atee ha'agorohia ma'ua rau haa'i mwane here ta'a'i. ");
INSERT INTO aia_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Moi ta'ahiraaui inoni 'onaa God na ta'ahiraau hako mwane inoni.” ");
INSERT INTO aia_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","'Ia Jisas 'a o'ani ro'u 'iniraau, “'Oi abui hiiriai nata nei, mara bwa'i hiiri'o ro'u. 'Oi abui hiiri ha'a-mama'aiai nata nei, maragu bwa'i hiiri ha'a-mama'ai'o ro'u. 'Oi 'adoma'i nugasiai 'inonai nata nei maraigui 'adoma'i nugasi'i ro'u i 'inomu'i. ");
INSERT INTO aia_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Moi hisuhisu maraigui hisu ro'u tana'amou. 'Inia 'onaa moi hi-hisuhisu, na hisu narai haua tana'amou 'ai di'u ro'u wou, mai honu aharau 'onaai baegi nara ha'aburu ha'agorohia mara ha'ahonua ro'u mau. Na hisu narai haa tana'amou, 'ai suriai hisu namou haua tanaai nata nei.” ");
INSERT INTO aia_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mia Jisas 'a haa'i ro'u tara'i ha'atee heiha'auu tanaraau o'ani, “Na nei na kuru 'a bwa'i matai uruai nata sae kuru. 'Onaa 'ai urua, 'irarua rarui ahoda hako dio na'i giru. ");
INSERT INTO aia_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mana rongoiusuri 'a ai'a ahaaha di'uai ha'ausuri ana. Ma'ata na'i 'oha nai daa'i hakoi mwane ha'ausuringa'i ana'i, naasi 'aigui ta'isada beiai ha'ausuri ana. ");
INSERT INTO aia_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ni 'uaana na'o bonasiai rahia 'iniai gere mamamo na'i maanai nata nei, ma'ogu ai'a aidangisiai kae mamamo na'i maamu haari'o? ");
INSERT INTO aia_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","'A he'uai 'unua amua tanaai nata nei do'oi 'a'auhia 'anai rahiai gere mamamo baaniai maana, na'i 'oha na i'oe 'o ai'a wana goro 'iniai kae mamamo na'i maamu haari'o? 'O pwari'i ta'aa! 'Oi rahia ga'u na'i na'o i kae mamamo baaniai maamu neina 'oi matai wana goro 'anai rahiai mamamo baaniai maanai nata nei.” ");
INSERT INTO aia_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Mia Jisas 'a ha'atee ro'u o'ani, “Na hasi'ei goro 'a bwa'i matai hungu 'ini'i hua ta'a'i, mana hasi'ei ta'aa 'a bwa'i matai hungu 'ini'i hua goro. ");
INSERT INTO aia_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Na hasi'ei goro mana hasi'ei ta'aa 'oi matai 'iraraa 'iniai huadi. 'A bwa'i nei nai matai husiai huai 'aai mana memeapu suri'i waroraraki, ma'ua suri'i taraani hasi'ei ta'a'i moi. ");
INSERT INTO aia_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","'A o'asi ro'u, ni sae goro ra hura'a mai mareho goro baaniai ngoona, suria ni raromana 'a honu 'iniai maho goro. Mana sae ta'aa, ra hura'a mai mareho ta'a'i baaniai ngoona, suria ni raromana 'a honu 'iniai maho ta'aa. 'Inia ni ngoo, naasi na ha'arangasia hura'a i taha na honu 'inia 'i raromanai noni. ");
INSERT INTO aia_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ni 'uaana namou 'unu Araha 'iniau mamougu ai'a ha'isuri'i taha nau 'unu'i tana'amou? ");
INSERT INTO aia_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","'Iatei na boi na bahurongo ma ha'isuri'i mareho nau 'unu'i, wai ha'ata'inia tana'amou i 'omehana. ");
INSERT INTO aia_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","'Iia 'a 'onaai sae na tagoraai ruma. 'A 'e'eri ganu dio tarana na'i hunganai hau. Na'i 'oha na to'o i rangi raha mana ahe 'a to'iai rumasi, ni rumasi 'a ai'a 'iha'iha, suria 'ia mo'o na tagoraa 'a tagora ha'ababaua goro. ");
INSERT INTO aia_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mia mo'o na rongo'i ha'atee agu'i magu ai'a ha'isuri'i taha nau 'unu'i, 'a 'onaai sae na tagoraai ruma ana moi na'i ano na ai'a 'e'eri ganu dio tarana. Na'i 'oha na rangi mana wai 'a ahe to'iai rumasi, mana rumasi 'a arobo ma 'adarara!” ");
INSERT INTO aia_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","'Ia Jisas 'a ha'ausuriraau hako inoni na'i dorasi, maagu aho'i 'ari Kapaniam. ");
INSERT INTO aia_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma na'i 'omaasi 'e sae na daoha iei 'a gaarangi mae, 'ia mo'osi 'e sae tatau'aro anai ta'i saemaua na'i ruruhani hehei'oi adaaui Rom. Mana sae tatau'arosi 'e sae na ta'ahia di'u. ");
INSERT INTO aia_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma na'i 'oha na saemauasi 'a rongo tarohana Jisas, 'agu ha'a-taariraau tara'i saemaua adaa'i Jiu 'anai 'unua tanaa do'ai boi 'anai ha'agorohia aho'i sae tatau'aro ana. ");
INSERT INTO aia_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Miraau 'ariwou beia Jisas marau ha'abonga'inia wetewete o'ani, “'Ia mo'o na ha'ataari'ameu maini, 'a arari do'oi 'a'auhia, suria 'iia 'e sae goro. ");
INSERT INTO aia_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","'A ta'ahigaau i Jiu ma 'a'au 'anai ha'a-urasiai ruma ni ha'arahesi tana'ameu.” ");
INSERT INTO aia_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mia Jisas 'agu hano beiraau 'anai 'ari na'i ruma anai saemauasi. Na'i 'oha na gaarangia wou i ruma, ni saemauasi 'a ha'ataari'i ro'u wou tara'i sae 'anai heisadoi beia Jisas 'anai o'ani 'inia, “Araha, 'oi abui tau'aro raha 'anai hano ha'atau, 'inia 'inau 'au ai'a arari do'oi boi na'i ruma agua. ");
INSERT INTO aia_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Minau ai'a ta'isada ro'u 'anai heisadoi bei'o. Ma'ata 'au 'iraraa do 'onaa na'oi ha'atee moi mana sae tatau'aro agua 'ai matai goro'a aho'i. ");
INSERT INTO aia_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","'Au 'iraraa o'asi, suria 'inau 'au to'oraai nei na marungiau na 'inau wai ha'isuri'i heiatenga'i ana'i, minau ro'u 'au to'ora'i ro'u i sae hehei'oi na 'iraau rai ha'isuri'i ro'u i heiatenga'i agu'i. Na'i 'oha nawai o'ani 'inia ta ta'i 'iniraau, ‘'Oi 'ariwou 'isi,’ 'iia 'ai ha'isuria'a ma'ata. Ma 'onaa nawai o'ani 'inia ta nei 'iniraau, ‘'Oi boi 'ini,’ 'iia 'ai boi'a ro'u ma'ata. Ma 'onaa wai o'ani 'iniai sae tatau'aro agua, ‘'Oi hauai tau'aroni,’ 'iia 'ai haua'a ma'ata.” ");
INSERT INTO aia_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Na'i 'oha na 'ia Jisas 'a rongo'i mareho na 'unu'ia mo'osi, 'a heimwaota'i di'u ma rihota'i ma o'ani 'iniraaui noni hunga rau surisuria, “Romwane! Nau wai 'unua tana'amou, ai'a ta ta'i saeni Israel nawai 'omesia do'ai hinihini tari 'onaaia mo'osi.” ");
INSERT INTO aia_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na'i 'oha narau aho'i wou na'i ruma, i mwane nara ha'a-taariraau wou beia Jisas ani, rau 'omesia doni sae na daohasi 'a goro'a aho'i. ");
INSERT INTO aia_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na'i muri, 'ia Jisas 'a 'ari 'omaa ra 'unua 'iniai Nein, 'iraaui rongoiusuri mana mwane inoni rago rau ta'i hano beia. ");
INSERT INTO aia_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na'i 'oha na gaarangia wou i maanai bara 'anai 'omaasi, 'a 'omesiai suru'ia ada hura'a mai bwea na awa iei sae na mae na'i 'omaasi, mana sae na maesi 'e gare mwane ana 'e nao. Mana garesi, na'asi'a i ta'i gare ana. Ma ragoi inoni na'i 'omaasi narau awa beiai naosi. ");
INSERT INTO aia_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na'i 'oha na 'ia Araha 'a 'omesiai naosi, 'a kae ahutotou di'u ma o'ani 'inia, “'Oi abui angi.” ");
INSERT INTO aia_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Naasi 'a 'ariwou ma dau na'i bwea. Miraaui nei narau suru'iai bweasi rau ura papaku. Mia Jisas 'a o'ani 'iniai gare na maesi, “Geresae, 'oi suruta'e!” ");
INSERT INTO aia_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na'i 'oha nagu ha'atee o'asi moia Jisas, na gare na maesi 'a heinagu ara'a ma ha'atee. Mia Jisas 'a waia aho'i wou tanaa inana. ");
INSERT INTO aia_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mana mwane inoni hako rau mamaa'u, rau ginata'inia God marau ha'aasaa. Rau ha'atee o'ani, “'E rarabea hauasa na ha'ata'i mai beigaau na'i 'ohani. 'Ia God 'a ha'ataaria mai 'anai 'a'auhiraaui inoni ana'i.” ");
INSERT INTO aia_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mana taroha 'inia Jisas 'a 'adarara hako 'ari suri'i mwane dora na'i Provensi Jiudea, mei suri'i mwane dora hura'a wou gariai Provensisi. ");
INSERT INTO aia_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Miraaui rongoiusuri ana'ia Jon rau mamaani tanaa 'ini'i mareho na 'ia Jisas na haa'i. Mia Jon 'a soirarua mai waira rua 'ini'i rongoiusuri ana'i ");
INSERT INTO aia_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","'anai ha'a-taarirarua 'ari beia Araha 'anai songa'inia o'ani, “I'oe naasi nei nara 'unua do'ai boi 'anai ha'atahi'ameu, ma'uasi 'e nei he'ete'i namei mamasia ro'u mau?” ");
INSERT INTO aia_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na'i 'oha nararu ataha wou beia Jisas raru o'ani 'inia, “'Ia Jon na ha'ataarimiria mai do 'anai songa'ini'o o'ani, ‘'A 'ua? I'oe naasi nei nara 'unua do'ai boi 'anai ha'atahi'ameu, ma'uasi 'e nei he'ete'i namei mamasia ro'u mau?’” ");
INSERT INTO aia_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na'i ro'u mau madoraa nararu 'ari wousi, na 'ia Jisas 'a ha'agorohi'i mwane inoni nara sadoi'i mwane daoha he'ete'i hairiu, ma taari'i hura'a i adaro baani'i tara'i nei, ma ragoi nei ra kuru na ha'a-'ome'omeraau ro'u. ");
INSERT INTO aia_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","'Ia Jisas 'agu o'ani 'iniraruai rua rongoiusuri ana Jon, “Murui aho'i 'ari ma murui 'unu'i tanaa Jon i mareho namuru rongo'i mana mareho na muru 'omesi'i nau haa'i. Nei ra kuru ra wanawana'a, nei ra pwaki ra hahano'a, nei nara lepa ra goro aho'i, nei ra pwarongo ra rongorongo'a, nei ra mae ra suruta'e aho'i baaniai mae, miraaui pohara ra bahurongoai Taroha Goro. ");
INSERT INTO aia_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","'Ia God 'ai ha'agorohiai nei na 'omesi'i mareho nau haa'i, ma ai'a 'adoma'i heiruarua'a 'iniau.” ");
INSERT INTO aia_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na rua rongoiusuri ana'ia Jon raru aho'i 'ari, mia Jisas 'agu mamaani tanaraaui inoni 'inia Jon. 'A o'ani, “'A 'ua? Na'i 'oha namou 'ari na'i dora mangasara 'anai bahurongoa Jon, 'e taha namou 'adoma'inia domoi 'omesia? 'E sae na orisia tarau i 'adoma'ina 'onaai ade na gegewao? ");
INSERT INTO aia_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","'E sae he'ua namou hura'a 'anai re'ia? 'E sae na siri suri'i to'oni goro nara 'ome goro di'u? Ai'a! 'Iraaui nei ra siri suri'i bwana goro miraaui sae toto'ora ra awa suri'i ruma adaa'i mwaeraha, ai'a suri'i dora mangasara. ");
INSERT INTO aia_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma'e tahata namou hura'a 'anai 'omesia na'i dora mangasara? 'E rarabea? Ha'amomori, 'e rarabea, ma'ata 'iia ai'a do'e rarabea moi. ");
INSERT INTO aia_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","'Ia Jon naasi nei na 'ia God na taroha'i 'abaia o'ani na'i Usu-usu Maea, ‘Nau wai ha'ataaria wou i noni heitaroha'i agua na'i na'o 'ini'o. 'Iia nai ha'aagauraaui noni 'anai boi amua.’ ");
INSERT INTO aia_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nau wai 'unua tana'amou, 'ia Jon naasi na ororiu di'u'i hakoi mwane inoni nara huta mai na'i marewanani. Ma'ata, namoiwou ta sae na ai'a taraa ororiu na awa na'i heimarungi ana God, 'a ororiu di'ua Jon.” ");
INSERT INTO aia_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na'i 'oha na 'iraaui mwane inoni, goni beiraaui nei 'anai si'ogoni takisi, rau rongo'i ha'atee ana'ia Jisas, rau 'adoma'i aratara doni ha'a-aratara ana God 'a odo-odo. 'Iraausi na 'ia Jon na bwareomaearaau ani. ");
INSERT INTO aia_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Miraaui Farisei mana Ha'ausuri 'anai Ringe ana'ia Moses rau 'itaa i taha God na 'irisia tanaraau, suria rau ai'a raba rihosi marau ai'a 'irisia do'ia Jon 'ai bwareomaearaau. ");
INSERT INTO aia_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mia Jisas 'a o'ani ro'u, “'E taha nawai heiha'auu 'inia nai ta'isada beiraaui inoni na'i 'ohani? 'Iraau rau 'ome he'ua? ");
INSERT INTO aia_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","'Iraau rau 'onaai'i gare na matai ha'ariaria nara hainonora na'i dora ni maketi nara awara o'ani 'ari tanaai nata ruruha, ‘'Ei, meu uuhi'i gana ni hainonora mamou ai'a raba mao, mameu ganari'i gana ni heitori mamou ai'a raba angi.’ ");
INSERT INTO aia_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","'I'amou mou haha'ariaria o'asi ro'u! Na'i 'oha na 'ia Jon 'a boi na ha'aririta'i ngau bredi mana gono waen, mou 'unua do 'e adaro na bwaunia. ");
INSERT INTO aia_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma na'i 'oha nau boi, Garei Inoni, mou re'ia do 'au matai gono waen mau matai ngaungau, mamou 'unua do'au ngangaura'a mau bweu 'ini gonohiai waen, ma do 'inau 'e sae goro adaaui inoni ha-ha'atakisi miraaui inoni ta'a'i. ");
INSERT INTO aia_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ma'ata, na awaha odo-odo adaa'i nei narau hinihini'i ha'ausuringa'i amiria Jon 'ai ha'ata'inia hura'a i madoma nara haa'i ha'ausuringa'i 'isi.” ");
INSERT INTO aia_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ma'e ta'i 'iniraaui Farisei na ari'ahua Jisas 'anai ngau beia na'i ruma ana. Mia Jisas 'a siri wou na'i rumasi ma heinagu auru 'anai ngau. ");
INSERT INTO aia_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma na'i 'omaasi 'e urao na ora-ora'a di'u na awaiei. Na'i 'oha na uraosi 'a 'iraraa do'ia Jisas 'a awa na'i rumasi, 'a siri mai beiai gere bei 'ome goro na honu 'iniai rumu na si'ini goro di'u. ");
INSERT INTO aia_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'A siriwou ma ura na'i odohanai uwana Jisas ma angi. Na'i 'oha na angi, 'a ha'abunibuniai uwana'ia Jisas 'iniai wainai maana, ma ha'amaahaa 'iniai warihuna. 'A ngooniai uwana'i, ma ringisiai rumusi na'i uwana'i. ");
INSERT INTO aia_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma na'i 'oha na Fariseisi 'a 'omesiai mareho na haua i uraosi, 'agu 'adoma'i o'ani haaria, “'Onaa 'e rarabea naasi, 'a ga'i 'iraraa moia mo'o na daai uwanasi, ma ga'i 'iraraa doni uraosi 'e urao ta'aa.” ");
INSERT INTO aia_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","'Ia Jisas 'a o'ani 'iniai Farisei, “Saemon, 'e mareho nau raba 'unua tana'o.” Mia Saemon 'a o'ani, “'E taha ha'ausuri?” ");
INSERT INTO aia_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Mia Jisas 'agu o'ani 'inia, “'E waira rua nararu kaoni ha'a beiai noni toto'ora na matai wate'i ha'a tanaraaui nei narau raba kaoni 'iniai siha ha'a narau 'irisi'i. 'E ta'i na kaoni 'iniai rima merui korai silva, ma'e ta'i 'e rima 'arangi. ");
INSERT INTO aia_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","'Iraruai waira ruasi, ai'a ta ta'i 'inirarua naigui su'ua aho'i kaoni ana, suria raru ai'a to'o ha'a arari. Mana mareho na hauai noni toto'orasi, 'a kaku'a'i kaoni adaru'i ma 'adoma'i nugasirarua. Hoita, 'o 'adoma'inia do 'iatei 'iniraruai waira ruasi nai ta'ahia di'ua mo'o nararu kaoni beiasi?” ");
INSERT INTO aia_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mia Saemon 'a o'ani, “'Inau 'au 'adoma'inia do'ia mo'o na kaoni raha.” Mia Jisas 'agu o'ani 'inia Saemon, “'O odo ha'atai.” ");
INSERT INTO aia_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mia Jisas 'a rihota'i wou, 'a wanasiai uraosi ma o'ani 'inia Saemon, “'O 'iraraai uraoni? I'oe 'o ai'a haa ta wai tanaau 'anai wasi'i uwagu na'i 'oha nau sirimai na'i ruma amua, me'iia 'a ha'abunibuni'i uwagu 'iniai wainai maana, ma ha'amaha'i 'iniai warihuna. ");
INSERT INTO aia_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mi'oe 'o ai'a ha'amaotoau 'inia ta haingoni. Me'iia 'a ai'a mamarota'i ngoonia moe'a mau i uwagu'i, taraawa'a mau na'i 'oha nau sirimai. ");
INSERT INTO aia_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma ai'a rumu na'oi haua 'anai bwaugu, me uraoni 'a hauai rumu na si'ini goro di'u 'anai uwagu'i. ");
INSERT INTO aia_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mawai 'unua tana'o, na mwane ora-ora'a ana'i ra 'adoma'i nugasi'i hako tanaa. Naia na ta'ahiau di'u 'iniasi. Mana nei na ai'a to'ora'i mwane ora-ora'a rago 'anai 'adoma'i nugasi'i, na heita'ahi ana 'ai kekerei moi.” ");
INSERT INTO aia_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mia Jisas 'agu o'ani 'iniai uraosi, “Na ora-ora'a amu'i ra 'adoma'i nugasi'i hako tana'o.” ");
INSERT INTO aia_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Miraaui nei narau heinagu na'i dora ngaungau raugu o'ani haariraau, “'E sae he'ua naani na matai 'adoma'i nugasi'i 'ini'i ora-ora'a adaa'i inoni?” ");
INSERT INTO aia_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mia Jisas 'agu o'ani 'iniai uraosi, “I hinihinimu na 'ia God na ha'atahi'o 'inia. 'Oi 'ariwou dadara'a.” ");
INSERT INTO aia_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Na'i muri, 'ia Jisas 'agu 'aariha ro'u 'ari suri'i 'omaa raha mei gere 'omaa na'i Provensi Galili 'anai taroha'iniai Taroha Goro 'iniai heimarungi ana God. Mana waira ta'i tangahuru mana rua Ha'ataari ana'i rau ro'u beia. ");
INSERT INTO aia_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ma ro'u ra'i urao na 'ia Jisas 'a taari'i adaro baaniraau, ma ra'i nei na ha'agorohiraau ro'u baani'i daoha. Tara'i nei 'iniraau naasia Meri ni Magdala na 'ia Jisas 'a taariai biu adaro baania, ");
INSERT INTO aia_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","mia Susana, mia Joana, i urao anai sae ra 'unua 'inia Kusa. 'Ia Kusa 'e sae na tatau'aro tanaa Herod 'anai 'omesuri'i mwane toto'ora ana'i. 'Iraaui urao 'isi beiraau tara'i urao ro'u narau wate'i ha'a adaa'i 'anai 'a'auhia Jisas mana rongoiusuri ana'i 'ini'i taha narau 'irisi'i. ");
INSERT INTO aia_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","'E ta'i dangi, 'e kae ruruhai inoni baani'i mwane 'omaa he'ete'i hairiu rau boi 'anai bahurongoa Jisas. Mia Jisas 'agu haua tanaraaui ha'atee heiha'auu na o'ani, ");
INSERT INTO aia_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“'E ta'i 'oha na 'e ta'i sae na hura'a 'anai hasi korai wiit na'i mou ana. Ma na'i 'oha na rarasanga'ini'i kora, ra'i nei nara to'o na'i tara na sae ra buuri'i, mana gere manu ra dio mara ngaa'i. ");
INSERT INTO aia_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ra'i kora ra to'o na'i ano hunganai hau. Ma na'i 'oha nara tahi ara'a nagu raongi'i sina, mana kora nara tahi ra mae moi aho'i, suria 'a maamaha i dora ra tahi ei. ");
INSERT INTO aia_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ra'i kora ra to'o suri'i dora nara tahi suri'i waroraraki. Naasi na'i 'oha nara tahi ara'a, ra mae aho'i moi suria ni waroraraki ra agu ha'amaesi'i. ");
INSERT INTO aia_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma ra'i nei ra to'o na'i ano goro, mara tahi goro ara'a mara hungu. Mana hungu nara haa'i ra rago di'u'i ro'u wou i siha korai wiit na hasi'i.” Jisas 'agu ha'ahakoai hadahada ana o'ani, “Tei na to'o karinga 'anai rongo 'ai bahurongoa, mai aidangi tarihana.” ");
INSERT INTO aia_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Miraau na rongoiusuri ana'ia Jisas rau songa'inia 'iniai 'ado'ado 'anai ha'atee heiha'auu na hauasi. ");
INSERT INTO aia_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mia Jisas 'agu o'ani 'iniraau, “Na'i na'o, 'ia God ai'a ha'arangasia he'ua i marungiraau nai haai noni ana'i. Me na'i 'ohani 'a ha'ata'inia tana'amou. Mei tanaraaui nei narau ai'a hinihini mau, wai hau'i ha'atee heiha'auu tanaraau. Wai haua o'asi neina rei'uaa narai towa'i 'ome'ome marau bwa'i matai 'ome 'iraraa, ma'uasi rai towa'i bahurongo marau bwa'i aidangisia.” ");
INSERT INTO aia_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Naani 'ana 'ado'ado i ha'atee heiha'auu 'iniai sae na hasi korai wiit: Ni korai wiit, naasi ha'atee ana'ia God. ");
INSERT INTO aia_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mana kora na'i tara, naasi 'iraaui nei ra rongo'i ha'atee ana'ia God, mia Saetan 'a boi ma ha'akaku'araau aho'i 'ini'i, dorau gasi hinihini marau tahi. ");
INSERT INTO aia_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ni kora na'i hunganai hau, naasi 'iraaui nei ra dau'i ha'i wa'ewa'e i ha'atee ana'ia God. Mara ai'a daa'i orea 'inia na ha'atee ra ai'a ganu dio na'i tahingadaa'i 'onaai hasi'ei ra ai'a ganu i raridi. Tari 'oha raugu siri sadoi'i moi mareho bwara suri'i tahingadaa'i, marau gagata'ini'i hako aho'i mwane ha'atee. ");
INSERT INTO aia_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ni kora nara awa suri'i waroraraki, naasi 'iraaui nei rau rongo'i ha'atee ana'ia God ma ai'a orea mana 'adoma'idaa'i ra torakoke 'ini taraani mareho marau 'adoma'i riu 'iniai toto'ora mana mwane hei'irisi anai abe. Tarana naasi, 'a ai'a ta mareho nai goro do'ai hura'a mai baani'i tahingadaa'i. ");
INSERT INTO aia_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mana kora na'i ano goro, 'a ura 'iniraaui nei ra rongo'i ha'atee ana'ia God mara nuga ha'agorohi'i suri'i tahingadaa'i nara goro mara odo-odo. Rau dau baabau tarau suri'i ha'atee ana'ia God mana mwane mareho goro ra hura'a mai baani'i tahingadaa'i.” ");
INSERT INTO aia_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mia Jisas 'a o'ani ro'u, “'A bwa'i nei nai suu raita moi 'anai nugaa na'i bahainai rabo'o ma'ua bahainai bwea, 'ai nugaa ma'ata na'i dora ni toki raita 'anai bewaasiraaui inoni nara sirimai na'i ruma. ");
INSERT INTO aia_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","'A o'asi ro'u. Na mwane mareho nara awa bainihu suri'i ha'atee agu'i, raigui ha'ata'i hura'a mau. ");
INSERT INTO aia_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Naasi moi bahubahu rongo goro suri'i taha namou rongo'i. Suria 'iatei na aidangisi'i mareho nau maani'i ma araisuri'i, 'ia God 'ai a'oia tanaai aidangi na bwane to'oraa. Mia mo'o na 'adoma'inia do 'a aidangisi'i mareho nau maani'i magu ai'a araisuri'i, na gere aidangi na to'oraasi, 'ia God 'ai rahia baania.” ");
INSERT INTO aia_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'Ia inana Jisas miraaui do'orana'i rau 'ariwou 'anai 'omesia, mei suriai rago anai inoni, 'a bwara tanaraaui taha beia na'i ruma na awa iei. ");
INSERT INTO aia_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma'e ta'i sae na o'ani 'inia Jisas, “Inamu miraaui do'oramu'i neiraau hura'asi, maraugu raba re'i'o.” ");
INSERT INTO aia_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","'Ia Jisas 'agu ha'atee o'ani, “Na huunai inagu mana do'oragu'i naasi 'iraaui nei nara bahurongo'i ha'atee ana'ia God marau ha'isuri'i.” ");
INSERT INTO aia_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ma'e ta'i dangi 'ia Jisas miraaui rongoiusuri ana'i rau ta'e ara'a na'i ora ma ha'atee o'ani 'iniraau, “Gaau magai 'ari nata batarau 'iniai bwera.” Miraaugu tahamora ha'aro'asi 'ari. ");
INSERT INTO aia_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na'i 'oha narau 'a'ari mau, 'ia Jisas 'a dadao moi auru ma mauru'a. Raugu 'asu'a ma'e ro'a mana tabaosi raha na to'iraau'a na'i bwerasi, mana ora 'a gaarangi moi maai dodo suria 'a honu 'iniai wai. ");
INSERT INTO aia_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Miraaui rongoiusuri rau 'ariwou ha'araia Jisas, rau ha'atee o'ani, “Saemaua, Saemaua! Gai dodo'a naani.” 'Ia Jisas 'a suruta'e ara'a ma ha'atee wetewete tanaai ro'a mana tabaosi do rarui papaku. Na'i 'ohasi, na ro'a mana tabaosi raru araisuria, ma biowaa goro aho'i. ");
INSERT INTO aia_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mia Jisas 'agu ha'atee o'ani 'iniraaui rongoiusuri ana'i, “'A 'ua? Nahei hinihinimoo'i?” Miraaugu mamaa'u marau kae heimwaota'i di'u, rau heisonga'i hairiu o'ani, “Romwane, 'e sae he'ua naasi? Na'i 'oha na ha'atee tanaai ro'a mana tabaosi, raru araisuria.” ");
INSERT INTO aia_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","'Ia Jisas miraaui rongoiusuri ana'i raugu taha wou na'i dora ra 'unua 'iniai Gerasa, na'i nata batarau 'iniai kae bwera i Galili. ");
INSERT INTO aia_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Na'i 'oha na 'ia Jisas 'a siriwou na'i one, 'a heisadoi beiai sae ni dorasi na ragoi adaro na bwaunia. 'Iia 'a awa ha'i wa'aroko mai orea'a, ma ai'a awa na'i ruma, 'a awa moi suri'i wabwa nara toringi'i ei sae mae. ");
INSERT INTO aia_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","'A ragoi 'oha na adaro 'isi ra ha'a-bweubweu'aa. Ma rei'uaa narai ho'osi'i uwana'i mana rimana'i 'ini'i arihau marai nuga'i sae 'anai 'omesuria, 'iia 'ai 'idira'i mosi'i moi arihau, mana adaro 'isi rai ha'a-'usu'usua 'anai 'ari 'anai awa na'i dora mangasara. Hoita, na'i 'oha na 'ome to'oana Jisas, 'a boi ma topiruru auru tanaa. Mia Jisas 'a o'ani, “Adaro, 'oi hura'a baaniai saeni!” Mana saesi 'a awara raha ma o'ani, “Jisas garena God ororiu ara'a, 'o raba 'uaauni? Nau ha'angoni'o, 'oi abui ha'a-mama'aiau!” ");
INSERT INTO aia_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mia Jisas 'a songa'iniai saesi o'ani, “'Iatei atamu?” Mia aramia Jisas o'ani, “Ni atagu 'ia Kae Ruruha.” 'A 'unua o'asi suria 'e kae ruruhai adaro narau bwaunia. ");
INSERT INTO aia_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Marau ha'anongia wetewetea Jisas do'ai abui ha'a-taariraau 'ari na'i dora ni rongomaata'i 'anai ha'a-mama'airaau. ");
INSERT INTO aia_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma na'i bobonai abaaba gaarangiraau, ra'i mwane boo nara suasua 'isi. Mana adaro 'isi rau bonga'inia Jisas 'anai ha'a-taariraau 'anai siri suri'i boo 'isi. Mia Jisas 'agu ha'awateraau. ");
INSERT INTO aia_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na'i 'oha na adaro 'isi ra hura'a baaniai saesi, rau siri suri'i boo 'isi. Mana mwani boo 'isi ra 'eba dio suriai ahana mara rege dio na'i wai mara dodo hako. ");
INSERT INTO aia_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na'i 'oha 'iraaui nei nara 'omesuri'i boo 'isi rau 'omesia o'asi, rau 'eba 'ari 'anai taroha'inia tanaraaui inoni na'i 'omaa, mei tanaraaui nei narau awa hura'a wou baaniai 'omaa. ");
INSERT INTO aia_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na mwane inoni ra 'ari 'anai 'omesiai taha na to'o. Na'i 'oha narau ataha wou beia Jisas, rau 'omesiai sae na taari'i hura'a baania i adaro 'isi, 'a heheinagu gaarangia Jisas. 'A ho'o bwana aho'i mana aidangina 'a odo-odo aho'i. Na'i 'ohasi na inoni rau mamaa'u hako. ");
INSERT INTO aia_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Miraaui nei narau 'omesiai maho na hauasi a Jisas, rau taroha'inia hura'a hako tanaraaui noni i he'ua nagu goro aho'i 'inia i saesi. ");
INSERT INTO aia_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Miraaui saenai dorasi rau 'unua tanaa Jisas do 'ai hura'a baaniai dorasi, 'inia rau mamaa'u raha di'u. Mia Jisas 'a ta'e ara'a na'i ora ma ha'aagau 'anai hano baaniai dorasi. ");
INSERT INTO aia_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mana nei na 'ia Jisas 'a taari'i adaro baania, 'a ha'angonia wetewete 'anai hano beia, mia Jisas 'a o'ani 'inia, ");
INSERT INTO aia_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Abu, ma'ata 'oi 'ari 'omaa ma'oi taroha'inia tanaraau inoni taha na 'ia God na haua tana'o.” Naasi 'ia mo'osi 'agu aho'i 'ari 'omaa ma taroha'inia tanaraaui mwane inoni hako i mareho na 'ia Jisas 'a haa'i tanaa. ");
INSERT INTO aia_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na'i 'oha 'ia Jisas 'a ta'e ataha aho'i mai, 'e kae ruruhai inoni narau ha'amaotoa, suria rau 'iraraa do'iia 'ai aho'i mau mai. ");
INSERT INTO aia_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ma'e ta'i 'iniraaui na'otara na'i ruma ni ha'arahesi na'i 'omaasi 'a boi ma topiruru auru tanaa ma bonga'inia do rarui ta'i 'ari na'i ruma ana. Atanai saesi 'ia Jaeras. ");
INSERT INTO aia_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","'Iia 'a bonga'inia Jisas, suria na gare urao ana na harisina 'e ta'i tangahuru mana rua, 'a gaarangi mae maagu naasi'a i ta'i gare urao'a ana. Na'i 'oha na 'ia Jisas 'a hano 'anai 'ari na'i ruma ana Jaeras, rau ha'asu'isu'ia di'u 'iniai rago anai inoni. ");
INSERT INTO aia_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma'e urao na to'ia i 'abu raha suriai ta'i tangahurui harisi mana rua na awa ro'u na'i 'ohasi. Mana daohasi 'a bwara dona ta sae 'ai ha'agorohia baania. ");
INSERT INTO aia_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na uraosi 'a 'ariwou na'i murina Jisas ma karohiai gaonai to'oni tewa ana. Ma na'i 'oha na karohia mau wou, na'i mau i 'ohasi na 'abu 'a papaku. ");
INSERT INTO aia_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mia Jisas 'a ha'atee o'ani, “'Ia tei 'ini'amou na karohiau?” Miraaui noni rau tohe hako, mia Pita 'a ha'atee o'ani, “Araha, 'a bwarai 'iraraa, 'inia na inoni ra rago mara ha'asu'isu'i di'u!” ");
INSERT INTO aia_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mia Jisas 'a ha'atee o'ani, “Magu 'e sae na karohiau 'inia 'au arungana do mena agua, 'e sae na goro aho'i 'inia baaniai daoha.” ");
INSERT INTO aia_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na'i 'oha na uraosi 'a 'iraraa do 'a bwa'i matai bainihu mwada'u, 'a 'idi'idi 'iniai mamaa'u. 'A boi ma topira'i ruru auru tanaa Jisas. Ma na'i maadaau hako inoni 'a ha'arangasia hura'a i taranai taha nagu karohia 'inia i to'oni ana Jisas, ma taroha'inia tanaraau i hasi goro aho'i ana moi na'i 'ohasi baaniai daoha. ");
INSERT INTO aia_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mia Jisas 'a o'ani 'inia, “Ina, na hinihinimu na ha'agorohi'o aho'i. 'Oi 'ariwou dadara'a.” ");
INSERT INTO aia_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mau na'i 'oha na 'ia Jisas 'a ha-hadahada mau, 'e sae na ataha mai baaniai ruma ana Jaeras na o'ani, “Jaeras, ni gare amua 'a hako'a. 'Oigu abu 'unua'a i ha'ausurisi 'anai 'ari!” ");
INSERT INTO aia_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","'Oha na 'ia Jisas 'a rongoa o'asi, 'a ha'atee o'ani 'inia Jaeras, “'Oi abui mamaa'u, 'oi hinihini moi mana gare amua 'ai goro aho'i.” ");
INSERT INTO aia_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Na'i 'oha na ataha wou na'i ruma ana Jaeras, 'agu ai'a 'irisia'a do mwane sae rago rai siri ruma. Naasi 'a waia moia Pita, 'ia Jems mea Jon, mirarua'a i amana mana inanai gare uraosi. ");
INSERT INTO aia_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na'i 'ohasi na inoni ra angi mara ago-ago. Mia Jisas 'a ha'atee o'ani 'iniraau, “Moi abui angi, na garesi 'a ai'a mae, 'iia 'a mauru moi.” ");
INSERT INTO aia_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na'i 'ohasi na inoni ra da'ata'inia, suria rau 'iraraa doni garesi 'a bwane mae. ");
INSERT INTO aia_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mia Jisas 'a siriwou, 'a dau na'i rimana ma ha'atee o'ani, “Garegu, 'oi suruta'e!” ");
INSERT INTO aia_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na'i mau 'ohasi mana garesi 'a manawa aho'i ma ura ara'a. Mia Jisas 'a 'unua tanaa amana mia inana do rarui haua tanaa ta mahoingau. ");
INSERT INTO aia_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na'i 'ohasi, 'ia amana mana inanai garesi raru kae heimwaota'i di'u. Mia Jisas 'a ha'atee wetewete tanararua do rarui abui taroha'inia'a ro'u tanaa ta sae i marehosi. ");
INSERT INTO aia_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Mia Jisas 'a soi goniraau mai Ha'ataari ana'i ma haua tanaraaui tatau'aro mana mena 'anai taari'i hura'a i adaro ma 'anai ha'agorohi'i mwani daoha. ");
INSERT INTO aia_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma ha'a-taariraau hura'a 'anai taroha'iniai heimarungi ana God ma 'anai ha'agorohiraau aho'i nei ra daoha. ");
INSERT INTO aia_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","'A o'ani 'iniraau, “Na'i hano namoi haua, abu tanei 'ini'amou nai waia ta mareho. Abu ta 'a'abi, ma'ua ta anga ni 'aariha, ta huai bredi, ta ha'a, ma'ua do ta to'oni madara ro'u. ");
INSERT INTO aia_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","'E ruma rai ha'amaoto'amou na'iei 'oha moi ataha wou ta 'omaa, moi mauru iei tari 'oha moi hano baaniai 'omaasi. ");
INSERT INTO aia_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Me 'onaa 'iraaui inoni rau bwa'i ha'amaoto'amou 'anai rongo'i taha namoi hadanga'ini'i, moi hura'a baaniai 'omaasi. Ma na'i 'oha moi hura'a, moi tarohi'i kahua baani'i uwamoo'i. Naasi 'e ha'abasu tanaraau do'ia God 'ai ha'a-mama'airaau.” ");
INSERT INTO aia_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Miraau na Ha'ataari raugu hura'a marau 'ari suri'i 'omaa 'anai taroha'iniai Taroha Goro, ma 'anai ha'agorohiraau aho'i nei ra daoha. ");
INSERT INTO aia_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ma na'i 'ohasi 'ia Herod Antipas 'a rongo'i mwane mareho na 'ia Jisas 'a haa'i. Ma kae kakui ahuna, 'inia tara'i nei ra 'unua do'ia Jon Bwareomaea 'a suruta'e aho'i baaniai mae, ");
INSERT INTO aia_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ma tara'i nei ra 'unua do'ia rarabea Elaija na ha'amaranga, ma tara'i nei ro'u rau 'adoma'inia do'e nei 'iniraaui rarabea nara mae mau na'i 'oha bwani na tahi aho'i. ");
INSERT INTO aia_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mia Herod 'a o'ani, “'Ia Jon Bwareomaea 'a mae'a, 'inia 'inau bwane 'unua dorai horosiai 'u'una! Naasi 'iatei ro'u nagu hau'i mareho nara rongo o'asi ro'u 'isi?” Na'i 'ohasi 'ia Herod 'a bonasiai heisadoi beia Jisas. ");
INSERT INTO aia_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na'i 'oha na 'iraaui Ha'ataari rau aho'i mai, rau maani'i tanaa Jisas mwane mareho narau haa'i. Mia Jisas 'agu wairaau marau 'ari na'i dora na gaarangiai 'omaa nara 'unua 'iniai Betsaeda, dora rai matai awa haariraau na'iei. ");
INSERT INTO aia_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Miraaui inoni rau 'iraraa moi marau 'ari haisuri. Mia Jisas 'a ha'amaotoraau ma taroha'inia tanaraaui heimarungi ana God, ma ha'agorohiraaui nei nara daoha. ");
INSERT INTO aia_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na'i 'oha na sina 'a abari'i'a, i Ha'ataari ana'ia Jisas rau boi beia marau o'ani, “'Oi ha'a-taariraau hako inoni hura'a, marai 'ari suri'i 'omaa 'isi mana ruma suriai dorasi, marai siba 'adaau mahoingau mana dora ni mauru, 'inia 'igaau gau awa na'i dora na bwarai mwane mareho naani.” ");
INSERT INTO aia_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mia Jisas 'agu aramiraau o'ani, “'I'amou namoi ha'i 'adaau mahoingau.” Miraaugu ha'atee o'ani 'inia Jisas, “'E rima huai bredi ma'e rua ii'a moi na bei'ameu. 'O 'irisia domei 'ari 'anai hori mahoingau 'anai kae ruruhasi?” ");
INSERT INTO aia_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ma 'onaai rima merui mwane nara goni na'i dorasi. Mia Jisas 'agu o'ani 'iniraaui rongoiusuri ana'i, “Moi 'unua tanaraaui inoni marai heinagu suri'i ruruha, 'a ga'i rima tangahuru ta'i ruruha.” ");
INSERT INTO aia_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Naasi miraaui rongoiusuri rau haua 'onaai 'unua ana tanaraau. Ma na'i 'oha 'iraaui inoni rau heinagu hako auru, ");
INSERT INTO aia_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","'ia Jisas 'a dauai rima huai bredi mana rua ii'a. 'A wana ara'ai aro ma ha'atee ha'agorohia God 'inia. Naasi ma uubi'i magu hau'i tanaraaui rongoiusuri ana'i 'anai ha'atora'ini'i tanaraaui inoni. ");
INSERT INTO aia_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Rau ngau hako, marau masu. Miraaui rongoiusuri ana'i rau ha'ahonuai ta'i tangahuru mana rua abira 'ini'i taha narau ngau tahi'i. ");
INSERT INTO aia_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ma'e ta'i dangi 'oha 'ia Jisas 'a ha'arahesi haaria, 'iraaui rongoiusuri ana'i rau boi beia. Miagu songa'iniraau o'ani, “'Iraaui inoni rau 'unua do 'inau atei?” ");
INSERT INTO aia_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Miraau aramia o'ani, “Tara'i nei ra 'unua do i'oe a Jon Bwareomaea, ma tara'i nei ra 'unua do i'oe a rarabea Elaija, na ha'amaranga. Tara'i nei ra 'unua do'e rarabea ni 'oha bwani na suruta'e aho'i baaniai mae.” ");
INSERT INTO aia_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mia Jisas 'agu songa'iniraau ro'u o'ani, “Mi'amou, mou 'adoma'inia do 'inau atei?” Mia Pita 'a aramia o'ani, “I'oe naasi Ha'atahi na 'ia God na duruduru 'inia 'anai ha'ataaria mai.” ");
INSERT INTO aia_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mia Jisas 'agu ha'abasuraau wetewete dorai abui maania ro'u tanaa tanei marehosi. ");
INSERT INTO aia_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mia Jisas 'a 'unua ro'u o'ani, “'Inau, Garei Inoni, rai ha'a-rongomaata'iau di'u. 'Iraaui Na'ohadaa'i Piriisi miraaui Ha'ausuri 'anai Ringe ana'ia Moses ma tara'i saemaua ro'u rai 'utaiau marai ha'amaesiau. Ma 'e rua dangi nai hako mana'i oruna, waigu suruta'e aho'i.” ");
INSERT INTO aia_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mia Jisas 'a ha'atee tanaraau ro'u o'ani, “'Iatei na raba ha'i rongoiusuri agua, 'ai nugasiai hei'irisina haaria, 'ai mwa'emwa'e 'ado dangi 'anai suru'iai dadaahoro ana, maai suriau. ");
INSERT INTO aia_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","'Iatei na raba dau baabau na'i tahingana na'i marewanani, 'a bwa'i to'oraai huunai tahi. Me 'iatei na mwa'emwa'e 'anai ha'a-ai'aai tahingana 'iniai suriau ana, 'ai to'oraa nana i tahi. ");
INSERT INTO aia_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","'A 'ua? 'Onaa ta sae 'ai daa'i hako nana i mwani mareho na'i marewana, mana saesi 'ai mae ma'ai siri na'i dora ni rongomaata'i, ni mareho 'isi rai 'a'auhia? 'A bwa'i! ");
INSERT INTO aia_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","'Inau na Garei Inoni, wai boi aho'i mau ta 'oha ha'i raraha beiraaui enjel ana'ia God beiai mena na ta'isada beia amagu. Mana 'oha wai boi, waigui 'utairaaui nei nara ninimata'iniau na'i 'ohani. Ma wai 'utairaau ro'u i nei ra ninimata'i taroha'ini'i ha'atee agu'i. ");
INSERT INTO aia_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nau wai 'unua ha'a-momori tana'amou, ra'i nei 'ini'amou 'ini moi awa tari mau 'anai 'omesiai heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","'A ga'i 'onaai ta'i sade na hako, 'ia Jisas 'a waia Pita, 'ia Jon, mia Jems marau ta'eha ara'a na'i hungahunga 'anai ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Na'i madoraa na ha'arahesi, ni 'omeha na'i hauraena tari auru na'i 'u'una 'a orisi, mana bwana ana'i ra mamaahui wadora'i. ");
INSERT INTO aia_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na'i 'ohasi 'e waira rua sae nararu mamaani beia, na rua saesi 'ia Moses mia Elaija. ");
INSERT INTO aia_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","'Irarua raru ha'amaranga 'iniai raraha nara to'oraa i enjel na'i aro, mararu maania tanaa Jisas i mae nai haa na'i Jerusalem 'anai ha'ato'oai i ha'a-aratara na haua God na bwani awa. ");
INSERT INTO aia_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na'i madoraasi 'ia Pita mana nata rua rongoiusurisi, rau mauru. Na'i 'oha narau rarai, rau 'omesiai rarahana Jisas mana rua sae nararu ura beia. ");
INSERT INTO aia_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na'i 'oha na rua saesi raru taraawa'a hano baania Jisas, 'ia Pita 'a ha'atee o'ani 'inia Jisas, “Saemaua, 'a goro nagau awa 'ini! Mei ha'a-urasia ta oru hare, 'e ta'i tana'o, 'e ta'i tanaa Moses, ma ta ta'i tanaa Elaija.” 'Ia Pita 'agu to'o ha'atee o'asi moi. ");
INSERT INTO aia_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na'i 'oha 'ia Pita 'a ha-hadahada mau, 'e rorodo na dio huniraau ma marumarusiraau. Na oru rongoiusurisi rau mamaa'u raha di'u na'i 'oha na rorodosi 'a dio huniraau. ");
INSERT INTO aia_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na'i 'ohasi rau rongoai ringe na ao mai baaniai rorodosi, 'a o'ani, “Naani garegu nau 'ome sigihia, moi rongosuria.” ");
INSERT INTO aia_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Na'i 'oha narau rongoa hakoi ringesi, raugu 'ome mia moia Jisas nagu ura 'isi. Na'i 'ohasi rau papakunga'inia moi haariraaui marehosi. 'Ariwou na orea'a maraugu tano maani'i mareho rau 'omesi'i tanaraau tara'i nei. ");
INSERT INTO aia_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na'i nata dangi, 'oha narau aho'i dio baaniai hungahunga, rau heisadoi beiai kae ruruhai inoni nara goni mai 'anai mamasia Jisas. ");
INSERT INTO aia_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma'e ta'i 'iniraau na ha'atee hura'a o'ani, “Ha'ausuri, 'au 'irisia do'oi 'a'auhiai gare agua, naasi'a i ta'i gare agua. ");
INSERT INTO aia_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","'E adaro ta'aa na bwaunia. Na'i 'oha 'ai hurasia, na gare agua 'ai awara raha mana abena 'ai 'idi'idi. 'Ai rahuta'i dio na'i ano, mana hutohuto ra hura'a mai na'i ngoona. Ni marehosi 'a bwarai hako baania, ma here ha'ata'aia di'ui abena. ");
INSERT INTO aia_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","'Au bonga'iniraaui rongoiusuri amu'i dorai taaria hura'a, magu bwara.” ");
INSERT INTO aia_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mia Jisas 'agu ha'atee o'ani 'iniraau, “'I'amou inoni na'i 'ohani mou ha'i sae ta'a'i, mamou bwarai hinihini! 'Ai orea he'uai maratanoa nawai haua bei'amou, ma'ua wai awa orea tari he'ua bei'amou mamoigu hinihini?” Mia Jisas 'a o'ani 'iniai amanai garesi, “'Oi waia mai gare amua.” ");
INSERT INTO aia_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na'i 'oha na garesi 'agu boboi mau beia Jisas, mana adarosi 'a ha'a-ahugea dio na'i ano ma 'idi'idi na'iei. Mia Jisas 'a ha'atee wetewete tanaai adarosi do'ai hura'a, magu hura'a baaniai garesi. Mia Jisas 'agu haua aho'i garesi tanaa amana. ");
INSERT INTO aia_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na'i 'oha na 'iraaui inoni rau 'omesiai ha'abu'oahu na 'ia Jisas na hauasi, rau ta'i kaeni heimwaota'i di'u 'iniai mena ana God na ha'agorohiai garesi. Na'i 'oha 'iraaui inoni rau heimwaota'i mau 'ini'i mareho na haa'ia Jisas, 'ia Jisas 'a o'ani 'iniraaui rongoiusuri ana'i, ");
INSERT INTO aia_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Moi bahurongoai taha nawai maania tana'amou. 'Inaui Garei Inoni, ta nei nai usuha'iniau tanaraaui nei narau ha'imae beiau.” ");
INSERT INTO aia_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Miraaui rongoiusuri ana'i rau ai'a aidangisiai 'ado'ado 'anai maho na maania tanaraausi. 'Ia God 'a girua baaniraau neina rai abui 'irara'i taha narai to'o, miraau ro'u i rongoiusuri rau maguguta'i songa'inia Jisas 'inia. ");
INSERT INTO aia_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","'E heitohetohe na to'o beiraaui rongoiusuri 'inia tei 'iniraau nai ororiu di'u. ");
INSERT INTO aia_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","'Ia Jisas 'a 'irara'i 'ado'adodaa'i ma soia mai gare kekerei, 'a ha'a-urasia na'i bobona ");
INSERT INTO aia_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","magu o'ani 'iniraau, “'Onaa 'o ha'amaotoa ta nei 'onaai gareni suria 'o ta'ahiau, 'a damana ro'u moi do'o ha'amaotoau. Ma 'onaa 'o ha'amaotoau, 'o ai'a ha'amaotoau moi, mia ro'ua God na ha'ataariau mai. Naasi, 'iatei na ha'a-anoanoa haaria, naasia mo'o na ororiu di'u 'ini'amou.” ");
INSERT INTO aia_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mia Jon 'a ha'atee o'ani 'inia Jisas, “Saemaua, 'i'ameu meu 'omesiai sae na taari'i adaro baaniraaui inoni 'iniai atamu mameu ha'aabua, suria 'iia 'a ai'a awa na'i ruruha agaau.” ");
INSERT INTO aia_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mia Jisas 'agu o'ani 'inia, “Moi abui ha'aabua, 'inia 'iatei na ai'a ura bwarasigaau, 'iiasi 'e nei 'iniai ruruha agaau.” ");
INSERT INTO aia_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na madoraa na 'ia God 'ai waia Jisas ara'a aho'i aro 'a raumwadu. Mia Jisas 'a 'irisia wetewete 'anai 'ari taha na'i Jerusalem. ");
INSERT INTO aia_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Naasi 'ia Jisas 'a ha'ataari'i 'ari na'i na'o tara'i sae na'i 'omaa adaaui sae ni Samaria 'anai ha'aagau tarana Jisas. ");
INSERT INTO aia_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Miraaui sae na'i 'omaasi rau ai'a 'irisia Jisas 'anai awa na'i 'omaa adaau, suria rau 'iraraa dorau hano 'anai ha'arahesi na'i Jerusalem, ai'a na'i Samaria. ");
INSERT INTO aia_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na'i 'oha na 'ia Jems mea Jon raru rongoa do'iraaui inoni nai 'omaasi rau kakawata'inia Jisas, rarugu o'ani 'inia Jisas, “'A 'ua Araha? Mirii ha'angonia God 'anai ha'adiohiai 'eu 'anai suu gaasinga'iniraau?” ");
INSERT INTO aia_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mia Jisas 'a rihota'i ma ha'a-aburarua wetewete, ");
INSERT INTO aia_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","maraugu hano daara'i baaniai 'omaasi 'anai 'ari nata 'omaa. ");
INSERT INTO aia_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na'i 'oha 'ia Jisas mana rongoiusuri ana'i rau 'ariwou suriai tara, 'e sae na o'ani 'inia Jisas, “'Inau wai suri'o rei'uaa ta dora na'oi 'ari iei.” ");
INSERT INTO aia_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mia Jisas 'agu ha'atee o'ani 'inia, “Na mwane mwamwaa wasi ra to'o dora ni mauru, mana manu ra to'ora'i nu'i. Minau, na Garei Inoni, 'au ai'a to'o dora ni mono.” ");
INSERT INTO aia_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mia Jisas 'agu ha'atee o'ani ro'u 'iniai nata sae, “'Oi suriau 'onaai rongoiusuri agua.” Mana saesi 'agu o'ani, “Araha, wai 'ari ga'u mawai toringia amagu.” ");
INSERT INTO aia_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mia Jisas 'agu ha'atee o'ani 'inia, “Nugasiraaui nei ra suriai tara 'anai mae tarau marai toringiraaui nei nara mae. Mi'oe 'oi hura'a ma'oi taroha'iniai heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma'e ta'i sae na o'ani 'inia Jisas, “'Inau nawai suri'o Araha, ma'ata wai 'ari gau mawai haiha'ari beiraaui sae agu'i.” ");
INSERT INTO aia_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mia Jisas 'agu ha'atee o'ani, “'Iatei na taraawa'a suriau, ma na'i muri 'a 'adoma'ini'i aho'i moi mareho na bwani nugasi'i, 'a ai'a arari 'anai awa na'i bahainai heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Na'i muri 'ia Araha 'agu 'ome sigihia ro'u i biu tangahuru mana waira rua 'anai tatau'aro suri'i 'omaa nai ataha suri'i. 'E waira rua ma ha'a-taarirarua hura'a 'ari na'i ta'i 'omaa. ");
INSERT INTO aia_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Na'i na'o magu ha'a-taariraau hura'a, 'a ha'atee o'ani 'iniraau, “Na nei nara ha'aagau 'anai hinihiniau ra rago di'u'a 'onaai mwane hua nara maua'a suri'i hasi'ei. Ma ai'a rago i nei 'anai husi'i. Naasi, moi ha'arahesi tanaa God maai ha'ataari'i hura'a tara'i mwane sae tatau'aro 'anai 'a'au na'i mou hasi'eisi. ");
INSERT INTO aia_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Moi 'ari'a, ma'ata moi mamataihere, suria 'i'amou mou 'onaai'i garei siip nau ha'ataari'i hura'a na'i 'uruhadi misu hahairete. ");
INSERT INTO aia_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","'A bwa'i tanei 'ini'amou nai waa ta pwaosi, ma'uasi ta anga ni 'aariha, ma'ua ta sandol. Na'i 'oha namoi 'ariwou, moi abui mamaani orea bei'i sae namoi heito'oi bei'i suriai tara. ");
INSERT INTO aia_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Na'i 'oha namoi siriwou ta ruma moi ha'atee o'ani, ‘Gooroha ana God 'ai awa bei'amou na'i rumani.’ Naasi mareho namoi 'unua tahamora. ");
INSERT INTO aia_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","'Onaa 'ia mo'o na to'oraai rumasi 'ai ha'amaoto'amou goro, na ha'agorohi ana God 'ai awa tarau na'i rumasi, ma 'onaa 'a bwa'i, mana ha'agorohisi 'a bwa'i awa ro'u. ");
INSERT INTO aia_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Suri'i mwane 'omaa namoi taha suri'i, moi mauru na'i ruma tahamora narai ha'amaoto'amou na'iei. Moi abui mauru ta ruma he'ete'i ro'u. Mana taha narai hau'i tana'amou 'anai ngaa'i mana gonohi'i, moi ngaa'i mamoi gonohi'i. Suria na inoni tatau'aro 'a arari dorai taharia 'iniai tau'aro na haua. ");
INSERT INTO aia_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“'Onaa namoi 'ariwou ta 'omaa marai ha'amaoto'amou, taha narai ha'aagauhia tana'amou 'anai ngaua, moi ngaua. ");
INSERT INTO aia_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Moi ha'agorohirai nei ra daoha, mamoi taroha'inia tanaraaui inoni dona heimarungi ana God 'a raumwadu. ");
INSERT INTO aia_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma 'onaa namoi ataha wou ta 'omaa mana inoni na'i 'omaasi rau bwa'i ha'amaoto'amou, moi hura'a suri'i tara raha na'i 'omaasi mamoi o'ani, ");
INSERT INTO aia_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Rei'uaa na kahuanai 'omaa amoouni nara awa suri'i uwamee'i, meu tarohi'i hunimoou. 'E ha'ara ni ha'abasu tana'amou. Ma'ata, moi aidangisia do na heimarungi ana God 'a raumwadu'a.’ ");
INSERT INTO aia_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Wai 'unua tana'amou, na'i dangi ni hihiiri na ha'a-mama'ai na 'ia God 'ai haua tanaai 'omaasi 'ai di'u ro'u wou baaniai ha'a-mama'ai nai haua tanaraaui sae ni Sodom.” ");
INSERT INTO aia_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mia Jisas 'agu ha'atee o'ani ro'u, “'I'amoui Koresin mi'amoui Betsaeda, 'ai ta'aa di'u tana'amou! 'Onaa ha'abu'oahu nau haa'i tana'amou 'au ga'i haa'i tanaraaui sae ta'a'i na'i 'omaai Taea mei Saedon, rau ga'i bwane rihosi orea mau tanaa God. Ra ga'i bwane ho'osi'i bwana do'odo'o'a mana nuga dohu 'ada'i bwaudaa'i 'anai ha'ata'inia do rau ahutotou 'ini'i ora-ora'a adaa'i. ");
INSERT INTO aia_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ma na'i 'oha na 'ia God 'ai hiiriraaui inoni hako, na ha'a-mama'ai nai haua tana'amou 'ai di'ua ro'u wou i ha'a-mama'ai nai haua tanaraaui Taea mei Saedon. ");
INSERT INTO aia_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'A 'ua? 'I'amoui Kapaniam, mou 'adoma'inia do'ia God 'ai wai'amou ara'ai aro 'anai ha'a-ahaaha'amou? 'A bwa'i! 'Iia 'ai gaasi'amou auru na'i 'eu na'i dora ni rongomaata'i.” ");
INSERT INTO aia_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mia Jisas 'agu o'ani ro'u 'iniraaui rongoiusuri ana'i, “'Iatei na bahurongo'amou ma daa'i ha'atee amoo'i, 'iia 'a bahurongoau ma daa'i ro'u ha'atee agu'i. Mia tei na gagata'ini'amou, 'iia 'a gagata'iniau beia mo'o na ha'ataariau mai.” ");
INSERT INTO aia_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","'Ia Jisas 'agu ha'a-taariraau hura'a i biu tangahuru mana rua rongoiusuri ani. Ma na'i muri, rau aho'i mai ha'i wa'ewa'e marau ha'atee o'ani, “Araha, ni adaro mara araisuri'ameu ro'u na'i 'oha nameu taari'i hura'a 'iniai atamu.” ");
INSERT INTO aia_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mia Jisas 'a ha'atee o'ani, “Ha'amomori. 'Inau 'au 'omesiai ahoda ana Saetan 'onaai mararea na dio baaniai aro. ");
INSERT INTO aia_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","'Inau 'au haa tana'amoui mena 'anai ha'ahehoai mena ana Saetan, ma rei'uaa namoi buu hungadi mwaa mamaesi'i ma'ua suhari, mara bwa'i ha'amaesi'amou. 'A bwa'i mareho nai ha'a-ta'ai'amou. ");
INSERT INTO aia_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Naasi moi abui wa'ewa'e 'inia moi do 'iraaui adaro rau araisuri'amou, ma'ata moi wa'ewa'e ro'u 'iniai usu'i ana God atamoo'i na'i aro.” ");
INSERT INTO aia_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na'i madoraasi 'ia Jisas 'a honura'i wa'ewa'e na boi baaniai Hi'ona Maea ma ha'atee o'ani, “Ama, i'oe na'o marungiai aro mana ano. 'Au ha'atee ha'agorohi'o suria 'o giru'i mareho 'isi ta'iniraaui nei nara madoma mara aidangi, ma'o ha'ata'ini'i tanaraaui nei 'ini nara 'onaai gare. 'Io Ama, 'a o'asi 'inia naasi huunai hei'irisimu.” ");
INSERT INTO aia_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Na'i 'oha na 'ia Jisas 'a ha'arahesi hako tanaa God, magu ha'atee o'ani 'iniraaui inoni, “Na mwane mareho hako 'ia Amagu 'a hau'i hako tanaau. Ai'a tanei nai huunai aidangisiai garena God, me 'iia moia Amagu. Ma ai'a tanei nai huunai aidangisiai Ama, ma'ata 'iia moi garena, miraaui nei na 'inau 'au sigihiraau 'anai ha'a-aidangisiraau 'inia.” ");
INSERT INTO aia_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","'Ia Jisas 'agu rihota'i ma ha'atee o'ani 'iniraaui rongoiusuri ana'i haariraau, “Ha'amwaniraaui nei narau 'omesi'i taha namou re'i'i. ");
INSERT INTO aia_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mawai 'unua tana'amou, 'a ragoi rarabea mana mwaeraha nara mae hako'a narau raba 'omesi'i taha namou re'i'i, maraugu ai'a 'omesi'i. Marau raba rongo'i taha namou rongo'i, maraugu ai'a rongo'i.” ");
INSERT INTO aia_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ma'e ta'i 'oha 'e Ha'ausuri 'anai Ringe ana'ia Moses na ura ara'a 'anai raba ha'imaania Jisas. 'A o'ani, “Ha'ausuri, 'e taha nawai haua nawai to'oraa 'inia i tahi tarau?” ");
INSERT INTO aia_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mia Jisas 'a songa'inia aho'i o'ani, “'E taha nara usua na'i Ringe ana'ia Moses? 'A he'ua i aidangisia amua?” ");
INSERT INTO aia_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mana ha'ausurisi 'a aramia o'ani, “'Oi ta'ahia Araha God 'iniai tahingamu hako mana ahumu hako, me 'iniai 'adoma'imu hako mana wetewete amua hako. Ma'oi ta'ahiraaui noni amu'i 'onaai ta'ahi'o amua haari'o.” ");
INSERT INTO aia_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mia Jisas 'a o'ani 'inia, “'A goro i heiarami na'o haua. 'Onaa na'oi haua o'asi, 'oi to'oraa 'inia namua i tahi tarau.” ");
INSERT INTO aia_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mana saesi 'a rabasia dorai 'unua do 'iia 'e inoni odo-odo. Naasi ma o'ani, “'Ira tei inoni agu'i?” ");
INSERT INTO aia_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mia Jisas 'a aramia 'iniai ta'i mamaani. “'E ta'i ai Jiu na hano baaniai Jerusalem 'anai aurui Jeriko. Na'i 'oha na auru wou suriai tara, 'iraaui sae heingahu beri rau daua marau rahi'i hakoi bwana mana mwane mareho ana'i. Rau ha'amaara ha'ata'aia marau hano baania o'asi moi ha'i mae horo na'i bobonai tara. ");
INSERT INTO aia_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Ma na'i 'ohasi, 'e Piriisi na hano ro'u suriai tarasi, 'iia ro'u 'e ai Jiu. Na'i 'oha na ataha wou na'i dorasi, 'a re'iai sae nara ngahuiasi ma tariri baania 'ari nata abai tara. ");
INSERT INTO aia_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ma na'i ro'u moi muri, 'e sae tatau'aro na'i Ruma Maea ana God na auru mai ro'u suriai tarasi. Ma na'i 'oha na ataha na'i dorasi, 'a re'iai sae nara ngahuiasi, ma taha beira'i ro'u moi baania 'ari nata abai tara. ");
INSERT INTO aia_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ma na'i muri, 'e ta'i sae ro'u na auru ro'u wou suriai tarasi. 'Iia 'e sae ni Samaria, 'e sae ni dora nara wana bodio 'iniraau. Ma na'i 'oha na ataha wou na'i dorasi, 'a 'omesiai sae ni Jiu nara ngahuiasi, ma kae ahutotou di'u suria. ");
INSERT INTO aia_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Naasi 'a 'ariwou ma ringi rumu mana waen 'ada'i dora ra maara 'anai hunu'i, ma bibii bwarasi'i 'iniai bwana. 'A suru'ia ara'a na'i dongki ana ma waia 'ari na'i ruma ni mahuara nagu taguma'inia iei. ");
INSERT INTO aia_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na'i nata dangi 'a rahia hura'a i rua korai ha'a na arari 'anai tahariai ruma 'anai rua dangi. 'A haua tanaa mo'o na 'omesuriai rumasi, ma o'ani 'inia, ‘'Oi 'omesuria mo'oni. 'Onaa 'oi gaasi ha'a di'uai siha nau haua tana'osi, mawaigui orisia aho'i tana'o i siha ha'a na'i 'oha nawaigui aho'i mai.’” ");
INSERT INTO aia_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mia Jisas 'agu songa'iniai ha'ausurisi o'ani, “'A 'ua? 'O 'adoma'inia do 'iatei 'iniraaui waira orusi na here 'onaa do na to'oraa mo'o nara ngahuiasi?” ");
INSERT INTO aia_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mia aramia Jisas o'ani, “'Ia mo'o na 'a'auhia.” Mia Jisas 'agu ha'atee o'ani 'inia, “'Oi 'ariwou ma'oi haua o'asi ro'u.” ");
INSERT INTO aia_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na'i 'oha naraugu hano ro'u a Jisas mana rongoiusuri ana'i, rau taha na'i 'omaa na awaiei urao ra 'unua 'inia Maata. Mia Maata 'a ha'amaotoa siri na'i ruma ana. ");
INSERT INTO aia_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma'e do'orana Maata na awa na'i rumasi, atana 'ia Meri. 'Ia Meri 'a heinagu auru na'i gaarangiai uwana Jisas ma bahurongo'i mareho na 'ia Jisas 'a maani'i. ");
INSERT INTO aia_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mia Maata 'a torakoke i 'adoma'ina 'ini'i mareho 'anai ha'aagau'i. Naasi 'a boi beia Jisas ma ha'atee o'ani 'inia, “Araha, 'a ai'a 'ua tana'o i nugasiau ana do'oragu 'anai haa'i mwane tagora 'ini haariau? 'Oi 'unua mai, maai 'a'auhiau.” ");
INSERT INTO aia_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mia Jisas 'agu ha'atee o'ani 'inia, “Maata, Maata. I'oe 'a torakoke i 'adoma'imu, ma ta'aabemu 'ini'i mwane mareho rago. ");
INSERT INTO aia_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ma'ata 'e ta'i maho moi na ororiu, mia Meri na sigihia nana. Mana marehosi ra bwa'i rahia mwada'u baania.” ");
INSERT INTO aia_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","'E ta'i dangi 'ia Jisas 'a 'ari ha'arahesi na'i ta'i dora. Na'i 'oha na ha'arahesi hako, 'e rongoiusuri ana na boi ma o'ani 'inia, “Araha, 'oi ha'ausuri'ameu 'anai ha'arahesi 'onaai ha'ausuriraau ana Jon i rongoiusuri ana'i.” ");
INSERT INTO aia_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mia Jisas 'a o'ani 'iniraau, “Na'i 'oha moi ha'arahesi moi ha'atee o'ani: Amameeu, na atamu 'ai maea. Na houramu 'ai boi. ");
INSERT INTO aia_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Haa tana'ameu i mahoingau 'anai 'ado dangi. ");
INSERT INTO aia_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","'Oi 'adoma'i nugasi'ameu 'ini'i ora-ora'a amee'i, 'onaai 'adoma'i nugasi'i amee'i nei ra haa'i 'ino bwarasi'ameu. Ma'oi 'a'auhi'ameu 'anai ura bwarasi'i heiohongi.” ");
INSERT INTO aia_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mia Jisas 'agu hauai mamaani 'anai ha'ausuriraau ro'u 'iniai ha'arahesi. 'A o'ani, “'Onaa tanei 'ini'amou nai 'ari ataha beiai geresae goro amua na'i 'ubutanai rodo 'anai ha'angoni mahoingau. Gasi 'oi o'ani 'inia, ‘Geresae, 'oi hasi waa mai ga'u ta oru huai bredi. ");
INSERT INTO aia_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","'E geresae agua na boi ha'atau na ataha beiau 'anai mauru na'i ruma agua, magu ai'a mahoingau nai agau 'anai hangania 'inia.’ ");
INSERT INTO aia_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","'Ariwou mia mo'o na awa siri raronai rumasi 'ai ha'atee hurasi o'ani, ‘'Oi abui ha'ata'aabe, 'au bwane ha'ababauai honohono, minau bei'i gare agu'i meu dadao hako'a 'anai mauru. 'Au bwa'i suruta'e 'anai haua tana'o ta mareho.’ ");
INSERT INTO aia_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Wai 'unua tana'amou, rei'uaa na 'iia 'e geresae goro amua, 'iia 'ai 'ageta'i suruta'e 'anai haua tana'o ta mahoingau. Ma'ata 'onaa 'o bwa'i agoheta'i ha'angoni, 'aigui buna suruta'e 'anai hau'i hako tana'o i mareho na'o 'irisi'i. ");
INSERT INTO aia_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Naasi, wai 'unua tana'amou, moi abui agoheta'i ha'angoni. Ma naasi na mareho namoi ha'angonia, 'ia God 'aigui watea tana'amou. Moi abui agoheta'i siba. Ma naasi na mareho namou sibania, moigui sadoia. Moi abui agoheta'i pwepwee. Ma naasi 'ia God 'aigui tahangiai maraaruma tana'amou. ");
INSERT INTO aia_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","'Inia 'iatei nai ha'angonia God 'ini'i taha na 'irisi'i, 'ai hau'i tanaa. Mia tei nai siba, 'ia God 'ai haua tanaai taha na sibania. Mia tei nai pwepwee, 'ia God 'ai tahangia tanaai maraaruma. ");
INSERT INTO aia_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“'Iatei 'ini'amoui ama, na'i 'oha na gare amua 'ai ha'angoni'o 'inia ta ii'a, 'oi haua tanaa ta mwaa. ");
INSERT INTO aia_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma'ua 'ai ha'angoni popoui kua ma'oi haua tanaa ta suhari. ");
INSERT INTO aia_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Rei'uaa na'o ta'aa he'ua, me ma'ata 'o 'irara'i taha na goro 'anai haua tana'i gare amu'i. 'Onaa na o'asi, 'a ha'ata'inia goro'a hura'a doni Amamoou ara'ai aro 'ai hauai Hi'ona Maea tanaraaui nei narau ha'angonia.” ");
INSERT INTO aia_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","'E ta'i 'oha 'ia Jisas 'a taaria hura'a i adaro baaniai sae na baanguu. Na'i 'oha na adarosi 'a hura'a, na saesi 'agu ha-hadahada aho'i. Na'i 'oha na 'iraaui inoni rau 'omesia o'asi, rau kae heimwaota'i di'u. ");
INSERT INTO aia_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma tara'i nei 'iniraau rau 'unua doni mwaeraha adaaui adaro 'ia Saetan, na hauai menasi tanaa Jisas 'anai taari'i hura'a i adaro. ");
INSERT INTO aia_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma tara'i nei ra raba ha'imaania Jisas. Ra ha'angonia 'anai haua ta ha'abu'oahu ma dorai 'iraraa do'ia God na hauai mena tanaa. ");
INSERT INTO aia_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jisas 'a 'iraraai 'adoma'idaa'i inoni ma o'ani 'iniraau, “'Onaa 'e kantri na 'iraaui inoni rai hei'oi haariraau, na kantrisi 'ai ai'aa. Ma 'onaa na 'e ta'i ruruha na'i ruma ra awa heheihoa'a moi, ni ruruhasi 'ai 'adarara. ");
INSERT INTO aia_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","'I'amou mou 'unua do 'inau 'au taari'i hura'a i adaro 'iniai mena ana Saetan. Me 'onaa 'ia Saetan na haua tanaaui mena 'anai ha'ata'aiai ruruha ana haaria, ni ruruha ana 'ai hako raurau moi. ");
INSERT INTO aia_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hoita, ma 'onaa na ga'i ha'a-momori do 'inau taari'i adaro hura'a 'iniai mena ana Saetan, naasi mena ana tei na 'iraaui rongoiusuri amoo'i narau taari'i adaro 'inia? Ni mena ro'u ana Saetan? Ai'a! 'Iraaui rongoiusuri amoo'i rau haua 'onaai haua agua, ma ha'ata'inia do 'i'amou mou taritari'a. ");
INSERT INTO aia_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma 'onaa nau taari'i adaro hura'a 'iniai mena ana God, ma 'a ha'ata'inia doni heimarungi ana God 'a taha'a bei'amou.” ");
INSERT INTO aia_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mia Jisas 'a o'ani ro'u, “'Ia Saetan 'a 'onaai sae wetewete nai ha'aagau 'ini'i mwane mareho hehei'oi ana'i 'anai 'omesuriai ruma ana mana mwane toto'ora ana'i, ma 'adoma'inia doni toto'ora ana'i ra awa goro. ");
INSERT INTO aia_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma'ata 'onaa tanei nai wetewete di'ua nai hei'oi beia maai ha'ahehoa, 'iia 'ai waa'i mwane mareho hehei'oi na 'ia mo'osi 'a 'u'uri'i, mai hoai'i bori ana'i beiraaui geresae ana'i. ");
INSERT INTO aia_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“'Iatei na ai'a aba beiau, 'a ha'imae beiau. Mia tei na ai'a 'a'auhiau 'anai wai'i inoni tanaa God, 'a adara'iniraau inoni baania God.” ");
INSERT INTO aia_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Mia Jisas 'a ha'atee o'ani ro'u, “Na'i 'oha na adaro 'a hura'a baaniai inoni, 'iia 'a hano 'ari suriai dora mangasara 'anai siba dora ni mono. Ma 'onaa na bwa'i sadoia ta dora, 'iia 'aigui o'ani 'inia haaria, ‘Wai aho'i 'ari mawai siri aho'i na'i sae nau hano baania ani.’ ");
INSERT INTO aia_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na'i 'oha na aho'i wou 'a re'ia doni tahinganai saesi 'a 'onaai ruma nara tatara 'orima'inia goro mara nuga ha'a-odoodo'i goro i mareho na'i rarona. ");
INSERT INTO aia_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Na'i 'oha na 'omesia o'asi, 'agu 'ari 'anai waia ro'u mai beia i biu adaro narau ta'aa di'u ro'u wou baania. Na'i 'oha narau siri 'anai mono na'i raronai saesi, ni saesi 'a ta'aa di'u ro'u wou baaniai na'o.” ");
INSERT INTO aia_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na'i 'oha na 'ia Jisas 'a maani'i mareho 'isi, 'e urao na'i raronai kae ruruha narau bahurongoa Jisas 'a ha'atee raha ara'a o'ani, “Ha'amwania di'u i urao na ha'ahuta'o, ma ha'asuuhi'o.” ");
INSERT INTO aia_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mia Jisas 'agu ha'atee o'ani, “Ha'amomori, ma'ata 'a ha'amwania di'u ro'u woua mo'o na bahurongo'i ha'atee ana'ia God ma ha'isuri'i.” ");
INSERT INTO aia_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","'Ia Jisas 'a ha'atee o'ani 'oha nara goni moe'a mai inoni beia, “'I'amou inoni nai 'ohani mou ta'aa di'u. Mou raba 'omesia ta ha'abu'oahu magu 'a bwa'i nei nawai haua tana'amou. 'E ta'i ha'abu'oahu moi namoi re'ia, naasi ha'abu'oahu 'onaaiai nei na to'o tanaa Jona. ");
INSERT INTO aia_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ni taha na to'o tanaa Jona 'e ha'ara tanaraaui inoni na'i Ninive do'ia God na ha'ataaria mai. Ma o'asi ro'u, ni taha nai to'o tanaau, i Garei Inoni, 'e ha'ara tana'amou do 'inau 'au boi baania God. ");
INSERT INTO aia_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na'i dangi ni hihiiri, ni urao mwaeraha baania Shiba 'ai ura ara'a mai 'unua do 'i'amoui noni na'i 'ohani mou taritari'a mora. 'Inia rei'uaa na awa ha'atau 'ari nata aba 'iniai marewana, me 'iia 'a boi 'anai bahurongo'i mwane ha'ausuringa'i ana'ia Mwaeraha Solomon. Minau wai 'unua tana'amou, 'e nei na ororiu di'ua ro'ua Solomon na ataha'a bei'amou mamou ai'a raba bahurongoa. ");
INSERT INTO aia_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na'i dangi ni hihiiri, 'iraaui saeni Ninive rai ura ara'a 'anai 'unua hura'a do 'i'amoui noni 'ohani mou taritari'a mora. 'Inia na'i 'oha na 'ia Jona 'a heitaroha'i tanaraau, 'iraau rau rihosi baani'i ora-ora'a adaa'i. Mawai 'unua tana'amou, 'e nei na ororiu di'ua ro'ua Jona na ataha'a bei'amou, mi'amou ai'a raba rihosi baani'i ora-ora'a amoo'i.” ");
INSERT INTO aia_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“'A bwa'i tanei nai suungia ta raita 'anai girua, ma'ua 'ai nugaa na'i bahaina ta rabo'o. Ma'ata 'ai nugaa na'i dora ni toki raita 'anai bewaasiraaui inoni nara sirimai na'i ruma. ");
INSERT INTO aia_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ni maamu ra 'onaai raita tanaai abemu. Na'i 'oha na maamu ra goro, na abemu 'a honura'i marewa. Ma 'onaa na maamu ra ta'a'i, na abemu hako 'a honura'i kuhi. ");
INSERT INTO aia_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","'Oi herehere goro, 'o gasi 'adoma'inia do'o awa na'i marewa, me ni kuhita na awa bei'o. ");
INSERT INTO aia_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","'Onaa na tahingamu 'a honu 'iniai marewa ma ai'a kuhi na'iei, i'oe 'oi 'onaai nei na awa na'i dora na bewaasia i raita.” ");
INSERT INTO aia_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Na'i 'oha na hadahada hakoa Jisas tanaraaui inoni, 'e Farisei na 'unua do rarui 'ari ngau na'i ruma ana. Na'i 'oha nararu siriwou 'anai heinagu auru 'anai ngau'a, ");
INSERT INTO aia_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","na Farisei 'a heimwaota'i di'u na'i 'oha na 'omesia do'ia Jisas 'a ai'a dorima suriai ringe adaau. ");
INSERT INTO aia_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mia Jisas 'a ha'atee o'ani 'inia, “'I'amou Farisei, mou 'onaai sae na wasi ha'a-wadiwadi'i abedi panikeni mana abedi rabo'o, mana rarodi ra do'o'a moi. 'Inia 'omehamoou 'a kae goro na'i maadaaui sae, ma na'i raromamoo'i, naia haaria moi hairaurau mana 'ado'ado ta'a'i. ");
INSERT INTO aia_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Oru bweu! Mou ai'a 'iraraa do'ia God na hauai abega, ma haua ro'u i raromaga? 'A rabasia do 'irarua hako rarui 'ome goro. ");
INSERT INTO aia_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Naasi, moi 'adoma'i ororiu 'iniraaui pohara baani'i mwane ringe namou suri'isi, mamoigui wadiwadi hako na'i maana God. ");
INSERT INTO aia_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“'Ai ta'aa di'u tana'amoui Farisei. 'Inia rei'uaa namou wate'i tanaa God tangahurudi gere mareho rawa kekerei ta'a'i nara ha'angaugoroi mahoingau, ma'ua tara'i mareho ro'u suri'i mou amoo'i, mi'amou mou ai'a ta'ahia God mamou ai'a hauai here na odo-odo tanaraaui inoni. 'A goro domou wate'i mareho kekerei 'isi tanaa God, me mou ga'i ta'ahia ro'ua God mamou ga'i hauai here na odo-odo tanaraaui noni. ");
INSERT INTO aia_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“'Ai ta'aa di'u tana'amoui Farisei! 'Inia 'i'amou domoi heinagu moe'a suri'i dora ororiu na'i 'oha mou siri suri'i ruma ni ha'arahesi. Ma na'i 'oha namou 'ari suri'i dora ni maketi, mou 'irisia moe'a dorai ha'atee ha'a-ahaaha'amou. ");
INSERT INTO aia_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“'Ai ta'aa di'u tana'amou! 'I'amou mou 'onaai hera nara ai'a ha'ara'i, na 'iraaui inoni rau buu suri'i mareho ta'a'i ha'i ai'a 'iraraa.” ");
INSERT INTO aia_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ma'e ta'i 'iniraaui Ha'ausuri 'anai Ringe ana'ia Moses na ha'atee o'ani 'inia, “Ha'ausuri, i'oe 'o ha'a-ta'ai'ameu ro'u 'oha na'o 'unu'i mareho 'isi.” ");
INSERT INTO aia_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mia Jisas 'agu aramia o'ani, “'Ai ta'aa di'u ro'u tana'amoui Ha'ausuri 'anai Ringe ana'ia Moses! 'Inia 'i'amou mou ha'ausuriraaui inoni 'ini'i taha nara bwara tanaraau 'anai ha'isuri'i, mamougu bwa'i gere 'a'auhiraau moe'a. ");
INSERT INTO aia_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“'Ai ta'aa di'u tana'amou! Suria 'i'amou mou tau'aro ha'agorohi'i barabaradaa'i rarabea na 'iraaui wauwa amoo'i rau ngahu ha'amaesi'i na'i 'oha bwani. Mou haua o'asi domou ha'ahouraau mamougu ai'a awasuri'i mareho ra 'unu'i. ");
INSERT INTO aia_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Naasi 'a ha'ata'inia do 'i'amou mou ahu aratara 'iniai heingahu narau haasi. 'Iraau narau ngahu ha'amaesiraau, mi'amou namougu tau'aro ha'agorohi'i barabaradaa'i. ");
INSERT INTO aia_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tarana naasi, 'ia God na madoma 'a ha'atee o'ani, ‘'Inau wai ha'a-taariraau 'ari rarabea mana Ha'ataari tanaraaui noni. Ra'i nei rai ngahu ha'amaesiraau, ma ra'i nei rai norata'airaau.’ ");
INSERT INTO aia_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","'Iniai o'asi ana, 'i'amoui inoni na'i 'ohani namoigui dau ha'a-mama'ai 'ini'i rarabea nara ngahu ha'amaesiraau mau mai na'i taraawa'anai marewana, ");
INSERT INTO aia_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","taraawa'a mau na'i 'oha 'ia Kein 'a ngahu ha'amaesia Ebol, tari mai na'i 'oha nara ngahu ha'amaesia Sakaraea na'i ahoaanai dora ni ho'asi mana Ruma Maea ana God. Ha'amomori! Wai 'unua tana'amou, 'i'amoui inoni na'i 'ohani namoigui dau ha'a-mama'ai 'ini'i heingahu nara to'o 'isi. ");
INSERT INTO aia_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“'Ai ta'aa di'u tana'amoui Ha'ausuri 'anai Ringe ana'ia Moses! 'I'amou mou girua baaniraaui noni i tara 'anai aidangisia God. 'I'amou mou ai'a hano ro'u na'iei, mamougu ha'a-bwarasiraaui nei narau bonasiai hano na'iei.” ");
INSERT INTO aia_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mia Jisas 'a hano baaniai dorasi. Ma taraawa'a na'i 'ohasi, 'iraaui Ha'ausuri 'anai Ringe ana'ia Moses mana Farisei rau taraawa'a ura bwarasia Jisas marau songa'inia 'ini'i mwane heisonga'i bwara. ");
INSERT INTO aia_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Rau bonasia do'ai 'unua ta mareho taritari'a nei narai here ha'ata'aia 'inia. ");
INSERT INTO aia_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na'i mau 'ohasi, 'e taringai merui inoni narau goni mai 'anai bahurongoa Jisas. Me 'iniai rago di'u adaau, rau haisu'isu'i di'u. Mia Jisas 'a ha'atee o'ani tahamora tanaraaui rongoiusuri ana'i, “Moi 'omesuri'amou haarimoou baaniai herehere adaa'i Farisei narau ai'a awa suriai taha ra ha'ausuriraaui noni 'inia. ");
INSERT INTO aia_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mwane maho hako nara awa bainihu suri'i tahingamoo'i mana taha namou giru'i, rai ha'ata'ini'i hura'a. ");
INSERT INTO aia_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Taha namou maani'i na'i dora kuhi, rai rongo'i na'i dora marewa, mana taha namou ha'a-natanga'ini'i na'i ahii rai totoronga'ini'i hura'a tanaraaui inoni 'anai rongo'i.” ");
INSERT INTO aia_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mia Jisas 'a ha'atee o'ani ro'u, “'Inau wai 'unua tana'amou mwani sae goro agu'i, moi abui mamaa'usiraaui nei narai ngahu ha'amaesia moi abe mara bwa'i matai haua ta mareho 'anai ha'ata'ai'o na'i muri. ");
INSERT INTO aia_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","'Inau wai ha'ata'inia tana'amou a mo'o namoi mamaa'usia. 'Ia God namoi mamaa'usia, 'inia 'iia 'a to'o mena 'anai ha'amaesiai abe, mai matai gaasi'o ro'u na'i dora ni ha'a-mama'ai. Ma wai 'unua aho'i tana'amou, 'ia God namoi mamaa'usia.” ");
INSERT INTO aia_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Mou 'iraraai rima gere manu nara raonga'i rua sereni moi 'ini'i na'i maketi? Rei'uaa nara hori mwada'u o'asi, 'ia God 'a ai'a tanei 'ini'i garei manu 'isi nai kaku'aa. ");
INSERT INTO aia_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Naasi moi abui mamaa'u, 'inia 'i'amou namou ororiu di'u'i mwani manu rago. Na rei'uaa warihu suri'i bwaumoo'i, 'ia God 'a uduma'ini'i hako.” ");
INSERT INTO aia_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mia Jisas 'a o'ani ro'u, “'Iatei nai ha'arangasia tanaraaui inoni do'iia 'e rongoiusuri agua, 'inau na Garei Inoni wai ha'arangasia ro'u na'i maadi enjel ana'ia God do'iia 'e rongoiusuri agua. ");
INSERT INTO aia_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma 'onaa 'iatei nai gagata'iniau, 'inau wai gagata'inia o'asi ro'u na'i maadi enjel ana'ia God. ");
INSERT INTO aia_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“'Onaa 'iatei nai ha'atee ha'ata'aiau i Garei Inoni, 'ia God 'a matai 'adoma'i nugasia. Ma 'onaa na ha'atee ha'ata'aiai Hi'ona Maea, 'iia ra bwa'i 'adoma'i nugasia mwada'u. ");
INSERT INTO aia_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ta 'oha rai wai'amou suri'i ruma ni gonigoniha agaa'i Jiu 'anai 'i'i'amou mamoi ura na'i maadi na'otara miraaui Primia. Na'i 'ohasi moi abui 'adoma'i raha 'ini'i taha namoi 'unu'i 'anai arami'i taha rai subuni'amou 'ini'i. ");
INSERT INTO aia_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","'Inia na'i 'ohasi na Hi'ona Maea nai 'unu'i tana'amoui mareho 'anai 'unu'i.” ");
INSERT INTO aia_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ma'e ta'i 'iniraaui sae narau ura 'anai bahurongoa Jisas na o'ani 'inia, “Ha'ausuri, 'oi 'unua tanaai do'oragu mai hoai'i na'i ahoaamiria i toto'ora na maeta'ini'i amamiria.” ");
INSERT INTO aia_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mia Jisas 'agu ha'atee o'ani 'inia, “'Ei, ai'a aba agua 'anai ha'a-arataraai mahosi na'i ahoaamurua i do'oramu.” ");
INSERT INTO aia_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Magu o'ani 'iniraaui inoni, “Moi 'ome'ome goro! Mou gasi naga 'ini'i mwani toto'ora ni marewana. 'Inia na huunai tahitahi anai inoni ra ai'a awa suri'i mareho na to'ora'i, rei'uaa na towa'i toto'ora he'ua.” ");
INSERT INTO aia_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Magu hauai ha'atee heiha'auu tanaraau, “'E sae toto'ora na to'oraai ano nara hungu goro hakoi mwane mareho na hasi'i na'iei. ");
INSERT INTO aia_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","'Ariwou ma o'asi 'inia haaria, ‘'E taha gasi nawai haua? 'Inau 'au ai'a to'o dora arari'i mahoingau nau to'ora'i.’ ");
INSERT INTO aia_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Naasi ma o'ani, 'Oo, 'augu 'iraraa, wai kaiai ruma ni niga mahoingau agua mawai torai'i ara'a tara'i kae ruma narai arari 'anai nuga'i hako siri mwane mareho nau to'ora'i. ");
INSERT INTO aia_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Naasi ma waigui o'ani, ‘Mwaniau! 'Au to'o mwane mareho goro 'ada'i harisi narai boi mau. Wai mamarota'i tau'aro'a! Wai heinagu moi 'anai gono mana ngau, ma 'anai hauai taha nawai wa'ewa'e 'ini'i.’ ");
INSERT INTO aia_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mia God 'a o'ani 'inia, ‘Bweubweu'a! Na'i rodoni 'oi mae, mia tei naigui to'ora'i mwane mareho na'o ha'aagau 'ini'isi?’” ");
INSERT INTO aia_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mia Jisas 'a o'ani ro'u, “Naasi taha nai to'o tanaraaui mwane narau nuga goni'i toto'ora nadaa'i haariraau maraugu ai'a toto'ora beia God.” ");
INSERT INTO aia_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","'Ia Jisas 'agu o'ani 'iniraaui rongoiusuri ana'i, “Naasi taranai taha nau 'unua 'inia do 'ai abui ta'aabemoou 'iniai tahingamu 'ado dangi, 'iniai taha 'anai ngaa mana bwana na'oi ho'osia. ");
INSERT INTO aia_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","'Inia na tahingamu, ai'a moi 'anai ngaa'i mahoingau, mana abemu, ai'a moi 'anai ho'osiai bwana. ");
INSERT INTO aia_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Moisu 'adoma'i suri'i manu. Raau ai'a hasi mahoingau ma'ua ai'a 'e'eri, marau ai'a to'o ruma 'anai nuga mahoingau na'iei, me 'ia God 'a hanganiraau. Mi'amou tanaa God, mou ororiu di'u baani'i manu 'isi. ");
INSERT INTO aia_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ma rei'uaa na towa'i ta'aabemoou, me mareho nara ta'aabemoou 'ini'isi, ra bwa'i 'a'auhi'amou 'anai ha'atewaa 'ari tahi namou haa na'i marewana. ");
INSERT INTO aia_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma 'onaa na bwara tana'amou 'anai ha'atewaa 'ari tahitahi amoou, ma'ua na ta'aabemoou 'ini'i mwani mareho he'ete'i hairiu 'isi? ");
INSERT INTO aia_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Moisu 'adoma'i suri'i raraaua ni hasimou nara 'ome goro di'usi. Rau ai'a haua ta tau'aro ma'ua tata nadaau bwana. Mawai 'unua tana'amou, rei'uaa 'ia Mwaeraha Solomon 'a toto'ora, ma'ata ai'a ta ta'i bwana ana nai 'ome goro ta'isada beia ta ta'i tagai raraaua. ");
INSERT INTO aia_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Na hinihinimoo'i ra kekerei! 'Onaa 'ia God na ha'a-'omegoro'i tagai raraaua nara ahurara moi gere madoraa maraigui suungi'i, ni 'ua ana na bwa'i haa'i bwana 'inia tana'amou? ");
INSERT INTO aia_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Naasi moi abui 'adoma'i raha 'iniai taha namoi gonohia mana taha namoi ngaa. 'Ai abui ta'aabemoou 'ini'i mareho 'isi. ");
INSERT INTO aia_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Na'isi mareho na 'iraaui inoni nara ai'a hinihini na'i marewanani rau 'adoma'i raha 'ini'i. Naasi 'ai abui ta'aabemoou, 'inia 'ia Amamoou 'a 'iraraa do 'i'amou mou 'irisi'i mareho 'isi. ");
INSERT INTO aia_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Maho na ororiu di'u domoi haua, naasi 'anai awa tarau bahainai heimarungi ana God mia God 'aigui haua tana'amoui mwane mareho 'isi.” ");
INSERT INTO aia_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","'Ia Jisas 'agu o'ani ro'u 'iniraau, “Moi abui mamaa'u, rei'uaa mou gere ruruha moi, me 'ia Amamoou 'a 'ome sigihi'amou 'anai heimarungi beia na'i hourana ana. ");
INSERT INTO aia_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Moi raonga'ini'i mareho namou to'ora'i, mamoi haa'i ha'a 'ada'i tanaraaui pohara. 'Onaa moi haua o'asi, 'ai 'onaa domoi nuga'i toto'ora amoo'i ara'ai aro na'i anga na bwa'i 'oha nai ta'aa. Na toto'ora amoo'i rai awa na'i dora na bwa'i 'oha rai hako, 'inia 'a bwa'i sae nai beri'i, mana 'adi ra bwa'i here ha'ata'ai'i. ");
INSERT INTO aia_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Moi haua o'asi, 'inia na 'adoma'imu 'ai awa tarau na'i dora na toto'ora amu'i ra awa na'iei.” ");
INSERT INTO aia_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Moi ha'aagau tarau. Moi 'onaai'i sae tatau'aro nara totoriai saemaua adaau 'anai aho'i mai baaniai ha'aha'iwai. Rau suungiai raita marau ho'osi'i agaaui bwana adaa'i. Ma na'i 'oha na ataha aho'i mai, 'a pwepwee na'i maraaruma marau tahangia raurau tanaa. ");
INSERT INTO aia_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ha'amwaniraau di'ui sae tatau'aro narau rarai marau ha'aagau na'i 'oha ni saemaua adaau 'a aho'i mai. Wai 'unua tana'amou, na saemaua adaau 'ai siri suri'i bwana ni tagora, maai 'unua tanaraau 'anai heinagu, maai waa'i mai mahoingau tanaraau. ");
INSERT INTO aia_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ha'amwaniraau di'ui sae tatau'aro narai ha'aagau rei'uaa na saemaua 'aigui boi na'i 'ubutanai rodo ma'ua gaarangiai wa'aria. ");
INSERT INTO aia_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Moisu 'adoma'iniai taha nau maaniani. 'Onaa sae na to'oraai ruma 'ai 'iraraai 'oha na sae beriberi 'ai siri na'i ruma ana, 'a bwa'i mauru. 'Ai awa ha'aagau ma bwa'i ha'awatea doni saesi 'ai siri 'anai beri na'i ruma ana. ");
INSERT INTO aia_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Naasi 'i'amou ro'u moi ha'aagau tarau, 'inia 'inau na Garei Inoni wai aho'i mai na'i madoraa namou bwa'i 'iraraa ro'u.” ");
INSERT INTO aia_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mia Pita 'a songa'inia Jisas o'ani, “Araha, ni ha'atee heiha'auusi 'o haua tana'ameu moi rongoiusuri, ma'ua tanaraau ro'u hakoi inoni?” ");
INSERT INTO aia_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mia Jisas 'a aramia o'ani, “Sae tatau'aro he'ua ni saemaua 'ai ha'a-'omesuria 'ini'i mwane mareho na'i ruma ana, ma 'anai ha'atora'ini'i hura'a i mahoingau tanaraaui sae tatau'aro na'i madoraa 'ana? Naia i sae tatau'aro na madoma ma here goro suri'i mwane mareho nara ha'a-'u'uria 'ini'i. ");
INSERT INTO aia_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ha'amwaniai sae tatau'arosi na'i 'oha na saemaua ana 'ai boi sadoia do'iia 'a here ha'agorohiai tatau'aro ana. ");
INSERT INTO aia_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mawai 'unua ha'a-momori tana'amou, ni saemauasi 'ai ha'a-'u'uria mo'osi 'ini'i mwane mareho na to'ora'i. ");
INSERT INTO aia_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma 'onaa ni sae tatau'arosi 'ai 'adoma'i o'ani, ‘Ni saemaua agua 'a bwa'i aho'i raurau.’ Naasi ma taraawa'a ngahu ngahuraaui urao mana saemwane narau ta'i tau'aro, ma awa moi 'anai ngau mana gonogono raha 'ini wai ni bweu. ");
INSERT INTO aia_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","'Aigui 'asu'a mana saemaua ana 'ai ataha na'i madoraa na saesi 'a bwa'i 'adoma'inia do 'a ga'i ataha. Na'i 'oha nai ataha, 'ai ha'a-mama'aia di'ui sae tatau'arosi, mai nugaa 'anai mamaa'a beiraaui inoni hahairaesi. ");
INSERT INTO aia_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ni sae tatau'aro na 'iraraa moi taha na saemaua ana 'a 'irisia do'ai haa magu ai'a ha'aagau ma'ua hauai taha na ga'i haa, 'iia rai ha'a-mama'aia di'u. ");
INSERT INTO aia_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mana sae tatau'aro na ai'a 'iraraai taha na saemaua ana 'a 'irisia magu hauai maho na taritari'a, 'iia 'a bwa'i raha tanaai ha'a-mama'ai. Mana nei nara ha'aragoa tanaa, ni saemaua 'a 'irisia do'ai ha'aragoa ro'u wou, mana nei nara ha'a-'u'uria 'ini'i mwane mareho rago, ni saemaua 'a 'irisia do'ai haa'i mwane mareho goro 'ini'i.” ");
INSERT INTO aia_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Mia Jisas 'a ha'atee o'ani ro'u, “'Inau 'au waa mai tanaai marewana i hihiiri ana God na 'onaai 'eu, mau 'irisia doni 'eusi 'a ga'i taraawa'a noro'a. ");
INSERT INTO aia_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ma'ata na'i na'o wai siri ga'u na'i rongomaata'i. 'Ado 'oha moi na ta'aa 'inia i 'adoma'igu, tari 'oha nai di'uai madoraa nai to'o i marehosi. ");
INSERT INTO aia_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","'A 'ua? 'I'amou mou 'adoma'inia do 'inau 'au boi 'anai ha'a-awagorohiraau goni inoni na'i marewana? Ai'a! Nau waa mai heihoa. ");
INSERT INTO aia_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Taraawa'a na'i 'ohani ma 'ari'a, na heihoa 'ai ta'eha mai suri'i ruruha 'ado ruma. 'Onaa na'i ta'i ruma 'e waira rima, 'e waira rua nararui ta'ahiau ma'e waira oru narau bwa'i, ma'ua waira oru narai ta'ahiau ma'e waira rua nararu bwa'i. ");
INSERT INTO aia_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ni ama 'ai heihoa beiai gare mwane ana, mana ina 'ai heihoa beiai gare urao ana, mana ha'ihungo adai urao rai o'asi ro'u.” ");
INSERT INTO aia_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ma o'ani ro'u 'iniraaui inoni, “Na'i 'oha mou re'iai rorodo na ara'a na'i dora na susuu iei sina, mou o'ani, ‘'Oo, 'a bwa'i orea mai rangi'a.’ Naasi 'a bwa'i hasi orea maai rangi'a. ");
INSERT INTO aia_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma na'i 'oha na ro'a siri mai, mou 'iraraa do'ai raorao. Ma o'asi mora. ");
INSERT INTO aia_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Oru pwari'i ta'aa! 'I'amou mou matai aidangisiai 'ari na haai dangi. Ni 'uaana namou ai'a aidangisiai 'ado'ado 'ada'i mareho nau haa'i na'i madoraa 'ini?” ");
INSERT INTO aia_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","'Ia Jisas 'a o'ani ro'u 'iniraau, “Ni 'uaana namou ai'a raba hiiria ro'u moi 'inia haarimoou i taha na odo-odo 'anai haua? ");
INSERT INTO aia_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","'Onaa 'e nei na raba wai'o na'i kooti, 'oi bonasiai ha'a-odoodoa beia i taha na'o ha'atari'aa na'i 'oha na'o ai'a taha mau na'i dora ni hihiiri. 'Onaa 'o bwa'i, mea mo'o na hihiiri 'ai wate'o tanaai pulis 'anai gaasi'o na'i rumaniho'o. ");
INSERT INTO aia_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","'Inau wai 'unua tana'amou, 'oi awa 'isi tari 'oha 'oi horia hakoi siha ha'a narai 'unua tana'o do'oi horia.” ");
INSERT INTO aia_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ma ra'i nei 'iniraaui inoni narau awa 'isi rau maania tanaa Jisas 'iraaui ai Galili na 'ia Paelat 'a ha'amaesiraau na'i 'oha narau hau'i ho'asi adaa'i tanaa God. ");
INSERT INTO aia_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","'Ia Jisas 'a o'ani 'iniraau, “'A 'ua? Mou 'adoma'inia doni mae ta'aa narau haasi, 'a ha'ata'inia do 'iraau rau ta'aa di'u baaniraau tara'i sae ni Galili? ");
INSERT INTO aia_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ai'a! Mou ai'a 'iraraa do 'i'amou moi mae ro'u 'onaa namou bwa'i rihosi baani'i ora-ora'a amoo'i? ");
INSERT INTO aia_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ma 'ua i waira ta'i tangahuru mana warui sae narau mae na'i 'oha na kokohu huniraaui kae ruma ahaaha na'i Saeloam? Mou 'adoma'inia do 'iraau rau ta'aa di'u'i tara'i nei ro'u narau ta'i awa ro'u na'i Jerusalem na'i madoraasi? ");
INSERT INTO aia_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ai'a! Wai 'unua tana'amou. 'I'amou moi mae ro'u mau 'onaa namou bwa'i rihosi baani'i ora-ora'a amoo'i!” ");
INSERT INTO aia_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mia Jisas 'agu haua ro'u i ha'atee heiha'auuni, “'E sae na hasiai hasi'ei nara 'unua 'iniai fig na'i mou ana. 'Ado 'oha 'a 'ari 'anai garihia, ma bwa'i hua nai sadoia na'iei. ");
INSERT INTO aia_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Naasi ma o'ani 'inia mo'o na 'omesuriai mousi, ‘'E oru harisi na hako'a ma ai'a hua mau nai haua i hasi'eisi. 'Oi ara gata'inia baaniai dorasi, 'ai abui ura 'isi 'anai ha'agata'iniai gorohanai ano.’ ");
INSERT INTO aia_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mana nei na 'omesuriai mou 'a o'ani, ‘Abu ga'u saemaua. Gai gere ha'atoria ga'u suria ta ta'i harisi ro'u mawai ha'imaaniai taguma'inia. Wai 'e'eri garigaria mawai nuga 'ana ano goro i wa'ana. ");
INSERT INTO aia_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","'Onaa 'ai hungu na'i harisi haoru, ma goro! Ma 'onaa 'a bwa'i, ma naasi waigui ara gata'inia.’” ");
INSERT INTO aia_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ma'e ta'i dangi ni mamaro, 'ia Jisas 'a ha'ausuriraaui inoni na'i ruma ni ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma'e ta'i urao na awa 'isi, 'e adaro na ha'adaohaa suriai ta'i tangahurui harisi mana waru. Ni uraosi 'a rorosu, ma bwarai ura arasi. ");
INSERT INTO aia_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na'i 'oha na 'ia Jisas 'a 'omesia 'a 'unua do'ai ara'a mai beia ma o'ani 'inia, “Urao, 'o dadara'a baaniai daoha na here ha'ata'ai'o.” ");
INSERT INTO aia_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ma dau wou beia. Na'i mau 'ohasi mana uraosi 'a goro'a aho'i. 'A ura arasi ara'a ma ha'aasaa God. ");
INSERT INTO aia_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mana na'otara 'anai ruma ni ha'arahesi na'i 'omaasi 'a taesu'a di'u na'i 'oha na 'omesia do'ia Jisas 'a ha'agorohiai uraosi na'i dangi ni mamaro, ma ha'atee tanaraaui inoni o'ani, “'E ono dangi tatau'aro na'i ta'i sade. Na'isi dangi namoi boi bei'i daoha amoo'i neina rai ha'agorohi'i, ma 'ai abu na'i dangi ni mamaro.” ");
INSERT INTO aia_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mia Araha 'agu ha'atee o'ani, “Oru pwari'i ta'aa! Rei'uaa na'i dangi ni mamaro mi'amou matai ruhasi'i kau mana dongki amoo'i baani'i dora namou hunasi'i suri'i, 'anai waa'i 'anai ha'agonohi'i. ");
INSERT INTO aia_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Naasi 'a ga'i goro ro'u 'anai ruhasiai uraoni na'i dangi ni mamaro baaniai daoha na ha'ata'aia! 'Inia 'iiani 'e warowarona ro'u a Ebraham, mia Saetan 'a ha'adaohaa orea'a mai suriai ta'i tangahurui harisi mana waru.” ");
INSERT INTO aia_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Na'i 'oha na 'ia Jisas 'a ha'atee o'asi, 'a ha'a-ninimairaaui nei narau ha'imae beia, ma'ata 'iraaui noni hunga rau wa'ewa'e 'ini'i mwane mareho goro na hau'i. ");
INSERT INTO aia_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mia Jisas 'a songa'iniraau ro'u o'ani, “'A he'uai 'adoma'imoou 'iniai heimarungi ana God? 'E taha nawai heiha'auu 'inia namoi aidangisia 'inia? ");
INSERT INTO aia_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","'Io, na heimarungi ana God 'a 'onaai koranai hasi'ei nara 'unua 'iniai mastad nara hasia na'i mou. Rei'uaa na korasi 'a kekerei ta'aa na'i na'o, ma na'i 'oha na tahi ara'a, 'a ha'i hasi'ei mana manu ra matai boi 'anai tagora nu'i suri'i raraana.” ");
INSERT INTO aia_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","'Ariwou ma heisonga'i ro'u, “'E taha nawai heiha'auu 'inia namoi aidangisia 'inia i heimarungi ana God? ");
INSERT INTO aia_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Na heimarungi ana God 'a 'onaai urao na dorariai gere dorai draebam beiai ta'i baegi flaoa bubu. Na'i muri, na gere dorai draebamusi 'a ha'asu'uai flaoa ma ha'arahaa'a.” ");
INSERT INTO aia_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na'i 'oha na 'ia Jisas 'a hano mau 'anai Jerusalem, 'a ha-ha'ausuriraaui inoni suri'i 'omaa na taha horo suri'i. ");
INSERT INTO aia_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Naasi ma'e ta'i sae na songa'inia o'ani, “Araha, 'e taringai sae moi nai dauai tahi tarau?” Mia Jisas 'a aramia o'ani, ");
INSERT INTO aia_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Moi bonasiai siri na'i heimarungi ana God 'inia na maraaruma ana 'a 'ogo. Wai 'unua tana'amou, 'ai ragoi nei narai bonasiai siri maraugu bwa'i mwada'u. ");
INSERT INTO aia_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Na'i 'oha na nei na to'oraai ruma 'ai ura 'anai honosiai maraaruma, 'i'amou moi ura hura'a i abau 'omaa 'anai pwepwee mamoi o'ani siri, ‘Araha, 'oi tahangiai maraaruma tana'ameu mamei siriwou!’ Mia mo'o na to'oraai ruma 'ai ha'atee o'ani hura'a mai, ‘'Inau ai'a matai'amou, mau ai'a 'iraraai dora namou boi eisi.’ ");
INSERT INTO aia_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mi'amou moigui o'ani, ‘'I'ameu meu ngau mameu gono bei'o, ma'o ha-ha'ausuri suri'i 'omaa amee'i.’ ");
INSERT INTO aia_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Me'iia 'aigui arami'amou o'ani, ‘'Inau ai'a matai'amou, moi su'a wou baaniau, oru hehere ta'aa.’ ");
INSERT INTO aia_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Moi angiangi mana rihomoo'i rai ngadingadi 'iniai taesu'a na'i 'oha moi 'omesia Ebraham, 'ia Aisak, mea Jekop, miraaui mwane rarabea na'i heimarungi ana God. Mi'amou 'ia God 'ai gaasi'amou hura'a. ");
INSERT INTO aia_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Na inoni rai boi baani'i mwani dora hako na'i marewana 'anai hauai ngaugoni na'i heimarungi ana God. ");
INSERT INTO aia_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mawai 'unua tana'amou, 'iraaui nei nara ai'a 'adoma'i ororiu 'iniraau na'i marewanani, 'ia God 'ai ha'a-ororiuraau, miraaui nei nara 'adoma'i ororiu 'iniraau, 'ia God 'ai ha'a-auruhiraau.” ");
INSERT INTO aia_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na'i 'ohasi ra'i Farisei ra boi mara o'ani 'inia Jisas, “'Onaa na'o raba tahi ma'oi hano baaniai dorani, 'inia 'ia Herod Antipas 'a siba suri'o 'anai ngahu ha'amaesi'o.” ");
INSERT INTO aia_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mia Jisas 'a aramiraau o'ani, “Mou 'ari mamoi 'unua tanaa mo'o na 'onaai misu tarisi, do 'inau wai tau'aro mau 'anai taari'i adaro baaniraaui inoni, ma 'anai ha'agorohiraau baani'i daoha. Ma bwa'i orea mawaigui ha'ahakoa goro i tau'aro agua. ");
INSERT INTO aia_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Na'i dangini mana'i ho'oa ma tara'i dangi ro'u, wai haua mau i 'aariha agua tari 'oha waigui ataha na'i Jerusalem. Suria 'a ai'a ta'isada dorai ha'amaesiai rarabea ta dora he'ete'i, ma'ata na'i Jerusalem.” ");
INSERT INTO aia_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Mia Jisas 'a ha'atee o'ani, “'Ei, Jerusalem, Jerusalem! 'I'amou namou ngahu ha'amaesi'i rarabea mamou buta ha'amaesi'i sae heitaroha'i ana'ia God 'ini'i hau. 'A ragoi 'oha nau rabasia domoi boi beiau 'anai 'omesuri'amou 'onaai bi'ai kua na abwa bwarasi'i gare ana'i. Mi'amou ai'a rabasia. ");
INSERT INTO aia_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Naasi moi rongoa! 'Ia God 'a hano'a baaniai 'omaa mana Ruma Maea amoou. Ma wai 'unua tana'amou, 'a bwa'i ta 'oha namoigui 'omesiau tari 'oha namoi ha'atee o'ani, ‘Araha God, 'oi ha'agorohia mo'o na'o ha'ataaria mai!’” ");
INSERT INTO aia_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ma'e ta'i dangi ni mamaro adaaui Jiu na 'ia Jisas 'a 'ari ngau na'i ruma anai ta'i bwauodo adaa'i Farisei. Miraaui inoni rau wanawana surisuria goro, ");
INSERT INTO aia_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","'inia na'i 'ohasi 'e sae na uwana mana rimana ra su'u na boi beia Jisas. ");
INSERT INTO aia_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mia Jisas 'agu songa'iniraaui Farisei miraaui Ha'ausuri 'anai Ringe ana'ia Moses o'ani, “'A 'ua? Na Ringe ana'ia Moses 'a ha'awategaau 'anai ha'agorohiai sae na daoha na'i dangi ni mamaro?” ");
INSERT INTO aia_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ai'a ta ta'i nei 'iniraau nai 'unua ta ta'i maho. Mia Jisas 'a dau wou beiai saesi ma ha'agorohia baaniai daoha na to'ia magu ha'ahanoria. ");
INSERT INTO aia_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mia Jisas 'agu songa'iniraau ro'u o'ani, “'A 'ua? 'O ga'i rahia moi hura'a i gare amua, ma'ua ta kau amua nai ahoda dio ta girui wai na'i dangi ni mamaro?” ");
INSERT INTO aia_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na'i 'ohasi rau nuga nguu hako, ma ai'a ta nei 'iniraau nai 'unua ta ta'i maho tanaa Jisas. ");
INSERT INTO aia_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mia Jisas 'a 'omesia do 'iraaui sae nara boi 'anai ngau rau rabasia dorai heinagu moe'a suri'i dora ni heheinagu adaa'i saemaua. Ma haua tanaraaui ha'atee heiha'auu na o'ani, ");
INSERT INTO aia_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“'Onaa tanei nai ari'ahu'o 'inia ta rongo ni ha'iwai, 'oi abui bonasiai heinagu suri'i dora heheinagu adaa'i saemaua, 'inia 'a gasi 'idi ma'e sae nai ororiu di'u'o nara bwane ari'ahua ro'u mai. ");
INSERT INTO aia_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","'Inia 'onaa nai o'asi, ni sae na hauai rongosi 'ai matai o'ani 'ini'o, ‘'Oi su'a baaniai dorasi maai heinagu 'isi a mo'oni.’ Na'i 'ohasi i'oe 'oi kae arunga ta'aa di'u na'i 'oha na'oi su'a auru 'anai heinagu na'i dora ha'ahako. ");
INSERT INTO aia_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Ma'ata naani taha na'o ga'i haua na'i 'oha narai ari'ahu'o. 'Oi heinagu na'i dora heheinagu ha'ahako, neina 'oha nai boi sae na hauai rongosi, 'iia 'ai o'ani 'ini'o, ‘'Ei geresae agua, 'oi ara'a mai heinagu na'i na'o, na'i dora goro.’ Na'i 'ohasi 'ai ha'a-ara'ahi'o na'i maadi inoni. ");
INSERT INTO aia_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","'Au ha'atee o'asi 'anai ha'a-aidangisi'amou do 'iatei nai ha'a-ara'ahia haaria, 'ia God 'ai ha'a-auruhia, mia tei nai ha'a-anoanoa haaria, 'ia God 'ai ha'a-ara'ahia.” ");
INSERT INTO aia_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","'Ia Jisas 'agu ha'atee o'ani 'iniai Farisei na ngau beiasi, “Na'i 'oha na'oi haua ta ngaugoni, 'oi abui ari'ahuraaui geresae goro amu'i, ma'ua 'iraaui do'oramu'i mana sae amu'i, ma'ua sae toto'ora namou awa heigaarangi'i. 'Inia 'iraau rai matai ari'ahu'o aho'i 'anai orisia aho'i tana'o. ");
INSERT INTO aia_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ma'ata na'i 'oha na'oi haua ta ngaugoni, 'oi ari'ahuraaui pohara, miraaui sae ta'ata'a'i, 'iraau na pwaki, miraau na kuru. ");
INSERT INTO aia_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Naasi 'ia God 'aigui ha'agorohi'o, 'inia 'a bwa'i tanei 'iniraau nai matai orisia aho'i tana'o. Ma'ata 'ia God naigui orisia tana'o na'i 'oha 'iraaui inoni odo-odo rai suruta'e aho'i baaniai mae.” ");
INSERT INTO aia_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ma'e ta'i beiraaui nei narau heinagu 'isi na ha'atee o'ani, “Ha'amwania di'ua mo'o nai heinagu 'anai ngauai rongo na'i heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mia Jisas 'a ha'atee o'ani, “'E sae na hauai rongo, ma ari'ahuraau mai inoni 'anai boi na'i rongosi. ");
INSERT INTO aia_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na'i 'oha na mwane mareho ra agau, 'a ha'ataaria hura'a i inoni tatau'aro ana 'anai 'unuraau mai sae na ari'ahuraau. 'A hura'a wou ma o'ani, ‘Moi boi! Na mwane mareho ra agau'a.’ ");
INSERT INTO aia_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Na'i 'ohasi 'e nei ma 'unua ta mareho. Ma 'etanai sae na o'ani, ‘'Inau 'e dorai ano nau bura'i horia moi, naasi wai 'ari 'anai 'omesia ga'u. Ha'arohaia di'u! 'Inau 'au bwa'i boi, 'oigui 'unua moi tanaa.’ ");
INSERT INTO aia_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mana nata sae 'a o'ani, ‘'Inau 'au bura'i horia moi ta'i tangahurui kau 'anai tagora. Naasi wai 'ari 'anai ha'atagora'i mawai 'omesia 'onaa narai tagora goro ma'ua 'a bwa'i. Naasi 'oigui 'unua moi tanaa, ha'arohaia di'u, 'inau 'au bwa'i boi.’ ");
INSERT INTO aia_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mana nata sae na o'ani, ‘'Inau 'au bura'i ha'iwai moi, tarana naasi nau bwa'i boi 'inia.’ ");
INSERT INTO aia_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Na'i 'oha na aho'i wou i sae tatau'arosi, 'a maani'i mareho 'isi tanaai saemaua ana. Na'i 'oha na rongoa o'asi, 'a kaeni taesu'a di'u, ma o'ani 'iniai sae tatau'aro ana, ‘'Oi raurau 'ari suriai tara raha mei suri'i gere tara suriai 'omaa, ma'oi wairaau mai pohara, miraaui sae ta'ata'a'i, miraaui nei nara kuru mara pwaki.’ Mana sae tatau'aro 'a hura'a ma haua 'onaai 'unua ana tanaa. Ma na'i 'oha na aho'i mai 'a o'ani, ");
INSERT INTO aia_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","‘Saemaua, ni mareho na'o 'unua 'au bwane ha'ahakoa, magu na ruma 'a ai'a honu mau.’ ");
INSERT INTO aia_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mana saemaua 'agu o'ani ro'u 'inia, ‘'Oi 'ari ma'oi 'unuraau mai nei nara awa beira'i baaniai 'omaa, ma'oi 'ari suri'i mwane gere tara suriai hasimou, ma'oi 'unu'i hako mai inoni, neina 'ai honu i ruma agua. ");
INSERT INTO aia_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","'Inau wai 'unua tana'o, 'a bwa'i tanei 'iniraaui nei nau ari'ahuraau ga'u na'i na'o ani naigui ngau mania ta mahoingau 'ini'i mahoingau nau ha'aagau'i tanaraau.’” ");
INSERT INTO aia_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","'E ta'i 'oha na 'e kae ruruhai inoni narau surisuria Jisas. Mia Jisas 'a rihota'i ma ha'atee o'ani 'iniraau, ");
INSERT INTO aia_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“'Iatei na suriau ma raba ha'i rongoiusuri agua, 'ai ta'ahiau di'uai inana mana amana. 'Ai ta'ahiau di'uai urao ana mana gare ana'i, ma'ua koana'i mana do'orana'i, ma'uasi tahingana haaria. ");
INSERT INTO aia_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma 'onaa 'iatei na bwa'i suru'iai dadaahoro ana maai suriau, ai'a arari ro'u 'anai ha'i rongoiusuri agua. ");
INSERT INTO aia_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“'Onaa tanei nai raba tagoraa ta ruma. Ni mareho tahamora nai haua, naasi 'ai heinagu mai wai'ado'ado suriai siha ha'a na matai arariai rumasi mana siha na bwane to'oraa. ");
INSERT INTO aia_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ma 'onaa na bwa'i haua o'asi, rei'uaa na ha'a-urasi'i mwane auu, ma 'a bwa'i ha'aagaua mwada'u i rumasi, suria 'a pwapwaku 'iniai ha'a. Me'iraaui nei narai 'omesia rai da'ata'inia, marai o'ani, ");
INSERT INTO aia_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘'Ome, 'ia mo'osi 'a taraawa'ana moi ruma, ma bwara'ai ha'ahakoa.’ ");
INSERT INTO aia_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ma 'onaa 'e mwaeraha na ha'aagau 'anai hura'a beiai ta'i tangahuru merui sae hehei'oi ana, 'anai hei'oi beiai nata mwaeraha na to'oraai rua tangahuru merui sae hehei'oi. Ni mareho tahamora nai haua ga'u, 'ai heinagu mai wai'ado'ado goro suria, 'onaa ni ruruha ana 'a matai ha'ahehoai nata ruruha anai nata mwaerahasi ma'ua 'a bwa'i. ");
INSERT INTO aia_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","'Onaa nai 'iraraa do'a bwara, ma'ai ha'ataari'i 'ari tara'i inoni heheitaroha'i ana'i na'i na'o 'oha narau awa ha'atau mau 'anai ha'a-arataraai taha na taritari'a na'i ahoaadaau marai abui hei'oi. ");
INSERT INTO aia_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","'A o'asi ro'u, moi wai'ado'ado goro suria mamoigui ha'i rongoiusuri agua. 'Inia 'a bwa'i nei nai ha'i rongoiusuri agua 'onaa na bwa'i nugasi'i mwani mareho na to'ora'i.” ");
INSERT INTO aia_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Solt 'a goro 'anai ha'angaugoroai mahoingau. Me ma'ata 'onaa nagu ai'aai asi'ahana, ma naasi 'agu bwa'i here'a ro'u naraigui haua 'anai ha'a-asi'aa ro'u. ");
INSERT INTO aia_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","'A bwa'i goro'a 'anai haa 'inia ta mareho'a ro'u, rei'uaa 'anai doraria beiai ano na'i mou ma'ua bei'i ha'aro'a 'anai ha'agorohiai ano ma bwa'i goro'a ro'u. 'A ta'isada dorai rasaha'inia moi. 'Iatei na to'o karinga 'anai rongo 'ai bahurongo, maai aidangi tarihana.” ");
INSERT INTO aia_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Miraaui inoni si'ogoni takisi, ma tara'i inoni ta'a'i ro'u rau goni mai beia Jisas 'anai bahurongo'i mareho na maani'i. ");
INSERT INTO aia_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Miraau na Farisei miraaui Ha'ausuri 'anai Ringe ana'ia Moses rau ha'atee ha'ata'aia Jisas, rau o'ani, “'Ia mo'osi 'a wa'ewa'e 'anai awa beiraaui inoni ta'a'i ma ngau ro'u beiraau.” ");
INSERT INTO aia_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mia Jisas 'a hauai ha'atee heiha'auu tanaraau o'ani, ");
INSERT INTO aia_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“'Onaa ta ta'i 'ini'amou nai to'oraa ta ta'i 'arangi siip, ma'e ta'i nai ai'aa, 'e taha nai haua? 'Ai nugasiraaui siwa tangahuru mana siwa na awa mausi na'i dora narau ngaungau ei, ma'ai hano 'anai sibaniai ta'i na ai'aasi tari 'oha nai sadoia. ");
INSERT INTO aia_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma na'i 'oha nai to'oana, 'ai wa'ewa'e di'u 'inia. 'Ai suru'ia ara'a na'i 'aba'abana, ");
INSERT INTO aia_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","maai waia aho'i 'ari na'i 'omaa. Na'i 'oha nai ataha aho'i wou na'i 'omaa, 'ai 'unuraau mai geresae ana'i miraaui inoni narau mono goni na'i ta'i dora mai o'ani 'iniraau, ‘Naani 'au kaeni wa'ewa'e di'u suria 'au sadoia aho'i siip agua na ai'aa. Gaau magai wa'ewa'e goni 'inia.’ ");
INSERT INTO aia_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“'Inau wai 'unua tana'amou, 'a o'asi ro'u na'i 'oha na'e ta'i inoni ta'aa nai rihosi baani'i ora-ora'a ana'i. 'Iraaui nei ara'ai aro rai wa'ewa'e raha di'u 'inia mo'osi. Na wa'ewa'e narai haua 'ai raha di'uai wa'ewa'e narau haua 'iniai siwa tangahuru mana siwa sae narau odo-odo na ai'a ororiu dorai rihosi.” ");
INSERT INTO aia_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ma 'onaa 'e urao nai to'oraa ta ta'i tangahurui korai ha'a, maigui ha'a-ai'aa ta ta'i, 'e taha nai haua? 'Iia 'ai suungiai raita maai tatara 'orima'inia goro hako ha'atai ruma ana maigu sibania tari 'oha nai to'oana. ");
INSERT INTO aia_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma na'i 'oha nai to'oana, 'ai soi goniraau hako mai gere urao ana'i miraaui nei narau mono goni na'i ta'i dora mai o'ani 'iniraau, ‘Naani 'au kaeni wa'ewa'e di'u suria 'au sadoia aho'i korai ha'a agua na ai'aa. Gaau magai wa'ewa'e goni 'inia.’ ");
INSERT INTO aia_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Mawai 'unua ro'u tana'amou. Na'i beiraaui enjel ana'ia God na'i aro, 'e wa'ewa'e na raha di'u ro'u wou 'iniai ta'i inoni ta'aa na rihosi baani'i ora-ora'a ana'i.” ");
INSERT INTO aia_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","'Ia Jisas 'a ha'atee o'ani ro'u, “'E ta'i sae na to'oraai rua gare. ");
INSERT INTO aia_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","'A 'ariwou mana gare na hutai muri 'a o'ani 'iniai amadarua, ‘Ama, 'au 'irisia do'oi haua tanaaui aba 'ohagu 'ini'i toto'ora amu'i na'o ga'i hoai'i tana'amiria i do'oragu.’ Mana amadarua 'a hoai'i toto'ora ana'i tanararua i rua gare anasi. ");
INSERT INTO aia_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Na'i muri, na gare na hutai murisi 'a raonga'ini'i mwane mareho na to'ora'i ma waa'i ha'a ana'i ma hano 'anai awa na'i dora ha'atau. Na'i 'oha na awa 'isi, 'a ha'agata'ini'i ha'a ana'i suri'i mwane here to'o bweubweu'a nara ai'a goro. ");
INSERT INTO aia_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na'i 'oha na ha'agata'ini'i hakoi ha'a ana'i, 'e kae hioro raha na to'o hako 'ari suriai dorasi, maagu taraawa'a toho 'iniai ha'a 'anai hori nana mahoingau. ");
INSERT INTO aia_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Naasi 'a 'ari ma ha'angoni tagora beiai ta'i sae toto'ora na'i dorasi. Mana saesi 'a ha'ataaria 'ari 'anai 'omesuri'i boo ana'i. ");
INSERT INTO aia_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","I geresaesi 'a naga di'u 'anai ngaa'i mareho na hangani boo 'ini'i, 'inia ai'a tanei nai haua tanaa ta mahoingau. ");
INSERT INTO aia_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Na'i muri 'agu boi aho'i 'adoma'ina magu o'ani, ‘Mwane! 'Iraaui sae tatau'aro ana'ia amagu rau to'ora mahoingau di'u maugu awa moi 'anai hioroni. ");
INSERT INTO aia_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wai suruta'e mawai 'ari aho'i beia amagu mawai o'ani 'inia, “Ama, 'inau 'au here ta'aa. 'Au hairaesi beia God, mau hairaesi bei'o ro'u! ");
INSERT INTO aia_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ai'a arari do'oigui 'unuau ro'u 'iniai garemu. 'Oi here mara sae tatau'aro moi 'iniau.”’ ");
INSERT INTO aia_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Naasi na geresaesi 'a suruta'e ma hano 'anai 'ari aho'i beia amana. Ma na'i 'oha na amana 'a 'omesia ha'atau mau, 'a kae ahutotou di'u suria, 'inia 'a 'ome ha'ata'ata'ahi. Naasi ma 'eba 'anai heisadoi beia, 'a 'agoia ma ngoonia. ");
INSERT INTO aia_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mana gare anasi 'agu o'ani 'inia amana, ‘Ama, 'inau 'au here ta'aa. 'Au hairaesi beia God, mau hairaesi bei'o ro'u. 'A ai'a ta'isada do'oigui 'unuau 'iniai gare amua.’ ");
INSERT INTO aia_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Mana amanai garesi 'a o'ani 'iniraaui sae tatau'aro ana'i, ‘Moi 'ari raurau na'i ruma mamoi waa mai ta to'oni nai 'omeegoro di'u mamoi ha'asirihia 'inia. Moi haua ta ringi mamoi daraha'inia na'i kaka'una mana sandol 'anai uwana. ");
INSERT INTO aia_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Naasi moi 'ari mamoi sigihia ta garei kau nagau hangani ha'arahaa ani magai ngahuia 'anai ngau goni, magai wa'ewa'e beiai gare agua. ");
INSERT INTO aia_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","'Inia na gare aguani 'a 'onaa do'a mae ga'u, magu tahi aho'i ro'u. 'A 'onaa do'a ai'aa ma na'i 'ohani 'au adoia aho'i.’ Na'i 'oha ra agau hakoi mwane maho, mana ngaugoni 'agu taraawa'a. ");
INSERT INTO aia_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ma na'i 'ohasi na gare na hutai na'o 'a awa mau 'ari na'i mou. Na'i 'oha na gaarangiai ruma 'iniai aho'i'a ana mai baaniai mou, 'a rongo'i mareho nara ha'a-angiangi'i mana sae ra mao. ");
INSERT INTO aia_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Naasi ma soia mai ta'i 'iniraaui sae tatau'aro ma songa'inia 'iniai taha na to'o na'i ruma. ");
INSERT INTO aia_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mana sae tatau'arosi 'a o'ani 'inia, ‘I do'oramu na hano ani 'a ataha aho'i mai, mia amamu 'a 'unua dorai ngahuiai garei kau nara hangani ha'arahaa ani 'anai ngaugoni beia 'inia, suria 'iia 'a hano ma ataha aho'i mai dadara'a.’ ");
INSERT INTO aia_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Na'i 'ohasi ni gare na hutai na'osi 'a kaeni taesu'a di'u, ma kakawata'i siri ruma. Mana amana 'a hura'a wou ma bonga'inia do rarui siri. ");
INSERT INTO aia_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Miagu o'ani 'inia amana, ‘'O 'iraraa, 'ado harisi 'inau 'au tau'aro raha di'u tana'o, ma ai'a do ta ta'i 'oha nawai hairaesi bei'o. Ma ai'a do ta gere garei gout ro'u moi na do'oi haua tanaau 'anai ngau wa'ewa'e bei'i geresae agu'i! ");
INSERT INTO aia_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma na'i 'oha na ataha i gare amua na ha'agata'ini'i toto'ora amu'i 'ini'i urao horihori, 'o ngahuia tanaa i garei kau nara hangani ha'agorohia 'anai ngaugoni beia.’ ");
INSERT INTO aia_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Mana amana 'a o'ani, ‘Mama, 'o 'iraraa, i'oe 'o awa tarau beiau mana mwane mareho nau to'ora'i 'iaamu'i. ");
INSERT INTO aia_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ma'ata 'a goro dogai ngau wa'ewa'e beiai do'oramu. 'Inia 'a 'onaa do'a mae ga'u magu tahi aho'i ro'u, ma 'onaa do'a ai'aa ma na'i 'ohani 'au sadoia aho'i.’” ");
INSERT INTO aia_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","'Ia Jisas 'a hauai mamaani tanaraaui rongoiusuri ana'i o'ani, “'E ta'i sae toto'ora na rongoa doni sae na 'omesuri'i tanaa i toto'ora ana'i 'a here ha'ata'ai'i ha'a ana'i. ");
INSERT INTO aia_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","'Ariwou mana sae toto'orasi 'a 'unua mai sae tatau'aro anasi ma o'ani 'inia, ‘'A ha'a-momori gasi mareho nau rongoa 'ini'o? 'Oi usu'i dio i 'omesuri na'o haa mai 'ada'i ha'a mana toto'ora agu'i. 'Inia na'i 'ohani 'oi hako baaniai tau'aro amua.’ ");
INSERT INTO aia_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mana sae tatau'arosi 'a wai'ado'ado ma o'ani 'inia haaria, ‘'E taha gasi nawai haua? 'Inia ni bwauodo agua 'a 'unua do'ai ha'ahakoau baaniai tau'aro agua, minau 'au ai'a wetewete arari 'anai 'e'eri tarea suri'i mou, mau ninimata'i ha'angoni ha'a ro'u. ");
INSERT INTO aia_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","'Oo, 'au 'iraraai mareho nawai haa neina rei'uaa nawai hako baaniai tau'aro agua me 'iraaui noni rai matai ha'amaotoau siri moi suri'i ruma adaa'i.’ ");
INSERT INTO aia_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Naasi ma 'unuraau mai mwane narau kaoni ha'a beiai bwauodo ana ma o'ani 'iniai sae tahamora, ‘'E siha na'o kaoni 'inia beiai bwauodo agua?’ Mia aramia o'ani, ");
INSERT INTO aia_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘'E waru 'arangi galon rumui 'oliv.’ Mana sae tatau'arosi 'a o'ani 'inia, ‘Naani pepa na ha'ata'iniai kaoni amua. 'Oi kaia ma'oi hasi usua auru do'e hai 'arangi moi.’ ");
INSERT INTO aia_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Naasi ma songa'inia ro'u i nata abe, ‘Mi'oe 'e siha na'o kaoni 'inia?’ Mia aramia o'ani, ‘'Inau 'au kaoni 'iniai ta'i 'arangi baegi wiit.’ Mana sae tatau'arosi 'a o'ani 'inia, ‘Naani pepa na ha'ata'iniai kaoni amua. 'Oi kaia ma'oi hasi usua dio do'e waru tangahuru moi.’ ");
INSERT INTO aia_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“'Agu 'ariwou mana bwauodo 'agu 'iraraai mareho ta'aa na haua i sae tatau'aro anasi. Me ma'ata 'a ha'atee ha'agorohia mo'osi, 'inia 'a madoma di'u 'anai hau'i mwane here o'asi 'anai 'a'auhia haaria. 'A ha'a-momori do 'iraaui inoni ahurodo rau aidangisi'i mwane here o'asi di'uraaui inoni nara awa na'i bewaa.” ");
INSERT INTO aia_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mia Jisas 'agu o'ani, “Naasi, 'inau wai 'unua tana'amou. Moi 'a'auhiai nata nei 'ini'i toto'ora amoo'i, neina na'i 'oha narai hako, raigui ha'amaoto'amou na'i dora ni tahi tarau. ");
INSERT INTO aia_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","'Onaa ra matai 'u'uri'amou suri'i gere mareho, ra matai 'u'uri'amou ro'u suri'i kae mareho. Me 'onaa ra bwa'i 'u'uri'amou suri'i gere mareho, 'ai bwara ro'u tanaraau 'anai 'u'uri'amou suri'i kae mareho. ");
INSERT INTO aia_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Naasi 'onaa ra bwa'i 'u'uri'amou 'anai 'omesuri'i toto'ora na'i marewanani, 'ai he'ua igui 'u'uri'amou ada suri'i huudi toto'ora ana'ia God? ");
INSERT INTO aia_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma 'onaa ra bwa'i 'u'uri'amou 'anai 'omesuri'i toto'ora adaa'i sae he'ete'i na'i marewanani, ra bwa'i haua tana'amou i toto'ora namou ga'i to'oraa na'i aro. ");
INSERT INTO aia_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“'A bwara doni sae tatau'aro 'ai tau'aro goro tanaai rua bwauodo. 'Onaa nai o'asi, me 'iia 'ai 'itaa ta nei maai ta'ahiai nata nei. Ma'ua 'ai 'adoma'i ha'ahoua tanei mana nata nei 'a bwa'i. Naasi 'a bwara 'anai tau'aro tanaa God ma do'oigui ta'ahia ro'u i ha'a.” ");
INSERT INTO aia_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Miraau na Farisei narau rongoa Jisas rau haikou 'inia, suria rau ta'ahia di'u i ha'a. ");
INSERT INTO aia_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mia Jisas 'a ha'atee o'ani 'iniraau, “'I'amou mou here 'onaa domou goro na'i maadaaui inoni, mia God 'a aidangisi'i hakoi taha nara awa suri'i tahingamoo'i. Moi 'ome'ome goro! 'Inia 'a ragoi mareho na 'iraaui inoni ra 'adoma'i ha'agorohi'i, me tanaa God ra'i mareho ta'a'i moi.” ");
INSERT INTO aia_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mia Jisas 'agu o'ani ro'u, “Na'i na'o, gau suri'i Ringe ana'ia Moses bei'i ha'ausuringa'i adaa'i Rarabea. Me taraawa'a beia Jon Bwareomaea nara taraawa'a 'anai taroha'inia ro'u i heimarungi ana God, mana mwane inoni rau bonasia di'u dona rai siri na'iei. ");
INSERT INTO aia_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ma'ata ai'a do ta gere dora 'iniai Ringe ana'ia Moses do'ai ai'aa. Ni aro mana ano rarui hako, ma'ata na Ringeringe 'isi ra bwa'i hako ta'oha. ");
INSERT INTO aia_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“'Iatei na gaasiai urao ana ma wainai urao he'ete'i, 'iia 'a ora-ora'a 'inia 'a taritari'a baaniai urao ana. Ma 'onaa 'e sae na wainai urao ha'iwai na mwane ana 'a gaasia, na sae na wainai uraosi 'a ora-ora'a, 'inia 'a taritari'a beiai urao ha'iwai.” ");
INSERT INTO aia_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","'Ia Jisas 'a o'ani ro'u, “'E sae toto'ora na ho'o bwana 'ome goro tarau, ma ngaungau goro, mana mwane mareho ra mwada'u tanaa na'i awa na haa na'i marewanani. ");
INSERT INTO aia_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma'e mwaeta'aa keokeo'a na atana 'ia Lasarus, ra waia wou 'ado 'oha 'anai ha'adaohia na'i maanai baraaruma anai saesi. ");
INSERT INTO aia_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","'Ia Lasarus 'a maesia ngaa'i dorai mahoingau nara ahoda baaniai dora ngaungau anai sae toto'orasi. I misu ra boi ro'u 'anai namiri'i keona Lasarus. ");
INSERT INTO aia_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Na'i 'oha na mwaeta'aasi 'a mae, 'iraaui enjel rau waia 'anai awa beia Ebraham. 'Ariwou mana sae toto'orasi 'a mae ro'u mara toringia. ");
INSERT INTO aia_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","'Iia 'a awa 'anai rongomaata'i na'i dora nara awaiei inoni ta'a'i nara mae. Na'i 'oha na wana ara'a 'a 'omesia Ebraham ha'atau ma re'ia Lasarus na'i bobona. ");
INSERT INTO aia_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mana sae toto'orasi 'a totoro tanaa Ebraham o'ani, ‘'Ei, Ama Ebraham, 'oi ta'ahiau. 'Oi ha'ataaria maia Lasarus maai ha'abuniai kaka'una mai boi ha'abunibuniai meameagu, 'inia 'au kaeni rongomaata'i di'u 'iniai 'euni.’ ");
INSERT INTO aia_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Mia Ebraham 'a aramiai sae toto'orasi o'ani, ‘'O 'iraraa garegu, I'oe 'o to'ora mwane mareho goro na'i 'oha na'o awa na'i marewana. Na'i 'ohasi 'ia Lasarus 'a to'ora'i mwane mareho ta'a'i. Ma na'i 'ohani 'iia 'a wa'ewa'e di'u mi'oe 'ogu rongomaata'i moe'a. ");
INSERT INTO aia_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mana nata mareho ro'u, 'e kaeni marawai ganu na awa hoaigaau, ma bwara do tanei 'ai tarau wou ma'ua tarau mai bei'amiria.’ ");
INSERT INTO aia_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Mana sae toto'orasi 'agu o'ani 'inia Ebraham, ‘Na o'asi ana Ebraham, 'au ha'angoni'o, 'oi ha'ataaria 'aria Lasarus 'ari na'i ruma ana amagu. ");
INSERT INTO aia_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","'Ai 'ariwou maai ha'abasuraaui rima do'oragu neina rai abui boi na'i dora ni rongomaata'ini.’ ");
INSERT INTO aia_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mia Ebraham 'a o'ani, ‘Ni usu-usu na haa'ia Moses miraaui Rarabea ra bwani awa 'anai ha'abasuraau. 'Iraau rau ga'i rongo'i marai ha'isuri'i.’” ");
INSERT INTO aia_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Mana sae toto'orasi 'a aramia Ebraham o'ani, ‘Ai'a Ama Ebraham, rau bwa'i orisi 'onaa 'a bwa'i sae nai tahi aho'i baaniai mae nai 'ari 'anai mamaani tanaraau.’ ");
INSERT INTO aia_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Mia Ebraham 'a o'ani, ‘'Onaa narau bwa'i ha'isuri'i taha na 'ia Moses miraaui Rarabea narau 'unu'i, ma'ai bwara tanaraau ro'u i orisi rei'uaa nai 'ari mamaani tanaraau ta sae nai suruta'e aho'i baaniai mae.’” ");
INSERT INTO aia_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Mia Jisas 'agu ha'atee ro'u o'ani 'iniraaui rongoiusuri ana'i, “Ni mareho narai hauai ora-ora'a tanaai inoni rai to'o. Ma'ata ha'arohaia di'ua mo'o nai ha'a-ahodariai sae na'i ora-ora'a. ");
INSERT INTO aia_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","'Onaa 'iatei nai raba ha'atehaa tanei 'iniraaui nei kekerei 'ini, 'a goro do ra ga'i ho'osia ta kae hau na'i 'u'una marai hura'a ha'adodohia dio na'i asi rodo. 'Inia na ha'a-mama'ai na 'ia God nai haua tanaai nei nai ha'atehaa tanei 'iniraau, 'ai ta'aa di'u ro'u wou. ");
INSERT INTO aia_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Naasi, moi 'ome tarihadi mareho namoi haa'i! “'Onaa 'e nei muru hei'irara'i na hauai maho na ta'aa tana'o, 'oi ha'a-aidangisia 'iniai taritari'asi. Ma 'onaa 'a 'adoma'i orisi, ma'oi 'adoma'i nugasia. ");
INSERT INTO aia_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","'Onaa na here ha'ata'ai'o ha'abiu na'i rarona moi ta'i dangi, ma na'i 'ado 'oha, 'a 'ariwou bei'o 'anai o'ani 'ini'o, ‘'Au aidangisia do 'inau 'au taritari'a, 'ohani 'au orisi.’ I'oe 'oi 'adoma'i nugasiai taritari'a ana.” ");
INSERT INTO aia_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Miraau na Ha'ataari rau o'ani 'inia Araha, “'Oi ha'araha'i hinihinimee'i.” ");
INSERT INTO aia_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","'Ia Jisas 'agu aramiraau o'ani, “'Onaa na hinihinimoo'i 'ai kekerei ta'aa 'onaai gere korai hasi'ei nara 'unua 'iniai mastad, na kae hasi'ei 'ariani 'a ga'i araisuri'o moi 'onaa na'oi 'unua tanaa 'anai rangu'ia ara'a haaria maai hasia haaria hura'a i asi.” ");
INSERT INTO aia_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mia Jisas 'a o'ani ro'u 'iniraau, “'Onaa tanei 'ini'amou nai to'oraa ta sae tatau'aro na tau'aro na'i mou ana, ma'ua 'omesuri'i mwamwaa ana'i. 'A 'ua? Na'i 'oha na bura'i aho'i mai baaniai tagora 'o 'adoma'inia do'oi o'ani 'inia? ‘'Oi heinagu auru ma'oi ngau.’ ");
INSERT INTO aia_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'A bwa'i! Na mareho na'oi 'unua tahamora tanaa 'ai o'ani, ‘'Oi ha'aagaua ga'u i mahoingau agua. 'Oha nai agau, 'oi ha'a-orisi goro ma'oi waa mai tanaau. Na'i 'oha nawai ngau hako ma 'oigui ngau ro'uta.’ ");
INSERT INTO aia_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mana sae tatau'arosi 'a bwa'i 'adoma'inia do'oi tagio tanaa, 'inia 'iia 'a suri'i moi heiatenga'i amu'i. ");
INSERT INTO aia_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","'Ai o'asi ro'u tana'amou. Na'i 'oha namou araisuri'i taha nau 'unua tana'amou 'anai haa'i, moi o'ani, ‘'I'ameu ra'i inoni tatau'aro moi. 'A ai'a ta'isada do'oi ha'atee ha'agorohi'ameu, suria 'i'ameu meu uranga'ini'i moi taha na'o ha'atora'ameu 'ini'i.’” ");
INSERT INTO aia_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na'i 'oha na 'ia Jisas 'a hano mau 'anai Jerusalem, 'a ataha wou na'i tarihanai Provensi Samaria mei Galili. ");
INSERT INTO aia_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma na'i 'oha na siri wou na'i ta'i 'omaa na'i raronai dorasi, 'a heisadoi beiai ta'i tangahurui sae lepa. Rau gere ura ha'atau ");
INSERT INTO aia_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","marau totoro o'ani tanaa Jisas, “Jisas, saemaua, 'oi ahu ta'ahi'ameu ma'oi 'a'auhi'ameu!” ");
INSERT INTO aia_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mia Jisas 'a 'omesiraau ma o'ani 'iniraau, “Moi 'ari beiraaui Piriisi marai 'iraraa domou goro'a aho'i.” Na'i 'oha naraugu hano 'anai 'ari, rau 'omesia dona abedaa'i ra goro'a. ");
INSERT INTO aia_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ma'e ta'i 'iniraau 'a hasi aho'i mai 'oha na 'ome 'iraraa do'a goro aho'i. 'A ha'atee ha'agorohia God beiai ringe raha. ");
INSERT INTO aia_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","'A topira'i ruru auru tanaa Jisas, ma tagio tanaa. Mana sae na aho'i maisi 'e sae ni Samaria. ");
INSERT INTO aia_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mia Jisas 'agu ha'atee o'ani, “'E waira ta'i tangahurui sae nau ha'agorohia ani, neiraau hei nata waira siwa? ");
INSERT INTO aia_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ni 'uaana na 'ia mo'o na ha'i sae mahuara moi nagu boi 'anai ha'aasaa God?” ");
INSERT INTO aia_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mia Jisas 'agu ha'atee o'ani 'inia, “'Oi suruta'e ara'a ma'oi 'ari, na hinihinimu 'a ha'agorohi'o baaniai daoha.” ");
INSERT INTO aia_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ma ra'i Farisei rau songa'inia Jisas 'iniai 'oha he'ua na 'ia God 'ai taraawa'ai marungiraaui noni ana'i. Mia Jisas 'a aramiraau o'ani, “Na heimarungi ana God gau bwa'i 'omesia 'ini'i maagaa'i. ");
INSERT INTO aia_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma bwa'i sae do'ai o'ani, ‘Naani'a’ ma'uasi ‘'Ome, na 'ari ani!’ Suria na heimarungi ana God na bei'amou.” ");
INSERT INTO aia_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Magu o'ani ro'u 'iniraaui rongoiusuri ana'i, “'E 'oha nai boi mau na 'i'amou moi raba 'omesiau i Garei Inoni rei'uaa ta ta'i dangi moi. Ma'ata na'i 'ohasi mou bwa'i 'omesiau mau. ");
INSERT INTO aia_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ra'i nei rai o'ani, ‘'Ome, na 'ari ani!’ Ma'ua rai o'ani, ‘Na maini!’ Rei'uaa na o'asi ma'oi abui suriraau 'anai wanasia. ");
INSERT INTO aia_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","'Inia na'i 'oha na 'inau i Garei Inoni wai aho'i mai, wai ha'ata'i goro hura'a tanaraau hako inoni 'onaai mararea na 'ora ma marewasia hakoi ahoasara. ");
INSERT INTO aia_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma'ata na'i na'o na Garei Inoni 'ai siri na'i rongomaata'i na raha, miraaui inoni na'i 'ohani rai gagata'inia. ");
INSERT INTO aia_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ni mareho na 'iraaui inoni ra hahaa'i na'i madoraa ana Noa rai to'o ro'u na'i 'oha 'inau i Garei Inoni wai aho'i mai. ");
INSERT INTO aia_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mou 'iraraai 'oha ana Noa, 'iraaui sae rau poru ahuare moi 'iniai ngaungau mana gonogono mana ha'aha'iwai tari na'i 'oha na 'ia Noa 'agu buna siri na'i raronai haka. 'Agu haa mana rangi raha 'a dio, mana ahe 'a ngahuiraau hako. ");
INSERT INTO aia_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ma 'ai 'onaa ro'u i madoraa ana Lot. Na'i 'ohasi, na inoni ra ngau mara gono, ra horihori, mara raoraonga'i, ra hasihasi mahoingau, mara tatagora ruma. ");
INSERT INTO aia_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma na'i 'oha na 'ia Lot 'a hora hura'a baaniai Sodom, ni 'eu mana memei hau ngarungaru ra rasaha'i dio baaniai aro mara suungia hakoi 'omaasi goni bei'i inoni. ");
INSERT INTO aia_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","'Ai o'asi ro'u na'i 'oha 'inau i Garei Inoni nawai aho'i mai. 'Iraaui noni nara bwa'i ha'aagau rai 'asu'a 'inia.” ");
INSERT INTO aia_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Na'i 'ohasi 'ia mo'o nai awa hura'a na'i abau 'omaa baani'i mareho ana'i na'i raronai ruma, 'ai abui siri aho'i'a ro'u 'anai waa'i bori ana'i. Ma'ua 'ia mo'o nai awa na'i mou ana, 'aigu abui 'ari'a ro'u aho'i ruma do'aigui waa'i bori ana'i 'anai hora bei'i. ");
INSERT INTO aia_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Moi wai'ado'ado suriai urao ana Lot. 'Iia 'a poruporu'a ma wana aho'i, mia God 'a ha'a-ai'aa. ");
INSERT INTO aia_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“'Iatei na raba dau baabau na'i tahingana na'i marewanani, 'a bwa'i to'oraai huunai tahi. Mia tei na mwa'emwa'e 'anai ha'a-ai'aai tahingana 'iniau, 'iia 'ai to'oraa nana i huunai tahi. ");
INSERT INTO aia_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mawai 'unua tana'amou, na'i madoraa nawai aho'i mai, 'onaa 'e waira rua nararui mauru na'i rodo na'i ta'i be'a, 'iraau enjel agu'i rai waia ta nei mana nata nei 'ai awa mau. ");
INSERT INTO aia_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","'E rua urao nararui tau'aro mahoingau goni, 'e ta'i narai waia ma'e ta'i nai awa mau. ");
INSERT INTO aia_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","'E waira rua nararui tau'aro goni na'i mou, 'e ta'i narai waia ma'e ta'i nai awa mau.” ");
INSERT INTO aia_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Miraaui rongoiusuri ana'i raugu songa'inia o'ani, “Araha, na'i hei narai to'o i mareho 'isi?” Mia Jisas 'a aramiraau o'ani 'iniai heiha'auu, “Na'i dora na awaiei mareho mae, rai ruru wou ei manu nara matai ngaa'i mareho mae.” ");
INSERT INTO aia_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mia Jisas 'a hauai ha'atee heiha'auu tanaraaui rongoiusuri ana'i do nei narai abui maemae'a 'anai ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","'A o'ani, “'E sae haha'akooti na awa na'i 'omaa. 'Ia mo'osi 'a ai'a 'adoma'i ha'ahoua God ma ai'a rongo suriraaui noni. ");
INSERT INTO aia_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma'e ta'i nao na'i dorasi na boi tarau beia ma ha'angonia wetewete do'ai 'a'auhia na'i kooti mai ha'ahehoai sae na here ha'ata'aia. ");
INSERT INTO aia_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Na'i na'o 'a kakawa ga'u, 'agu towa'i 'a'ariwou mana sae haha'akootisi 'a o'ani'a 'inia haaria, ‘Rei'uaa nau ai'a ha'ahoua God, mau ai'a rongo suriraaui noni, ");
INSERT INTO aia_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","me ma'ata wai hauai taha na 'unua tanaaui naosi 'inia 'a ha'ata'aabegu di'u'a. 'Inia 'onaa nau bwa'i ha'a-odoodoa tanaa, me 'aigui buna ha'abweuau 'iniai here na haa guguasi.’” ");
INSERT INTO aia_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mia Araha 'agu ha'atee o'ani, “Moisu 'adoma'i suriai mahosi. 'Onaa na sae haha'akooti ta'aasi ");
INSERT INTO aia_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","'agu buna 'a'auhiai naosi, 'ia God 'ai 'a'auhiraau ma'ata i nei na bwane 'ome sigihiraau mau mai narau ha'angonia tarau i hei'a'auhi baania. Mou 'adoma'inia do 'ai poruporu'a 'anai 'a'auhiraau? ");
INSERT INTO aia_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","'Inau wai 'unua tana'amou, 'iia 'ai raurau 'anai 'a'auhiraau. Ma 'ua? Na'i 'oha nawai aho'i mai, 'inau i Garei Inoni, 'e waira siha nawai sadoiraau narai hinihiniau?” ");
INSERT INTO aia_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mia Jisas 'a haua ro'u i ha'atee heiha'auu tanaraaui nei narau 'adoma'inia dorau odo-odo na'i maana God, maraugu 'adoma'i ha'a-auruhiraaui inoni. Magu o'ani 'iniraau, ");
INSERT INTO aia_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“'E waira rua nararu 'ari 'anai ha'arahesi na'i Ruma Maea ana God. 'E ta'i 'inirarua 'e Farisei, ma'e ta'i, 'e sae ha-ha'atakisi. ");
INSERT INTO aia_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na Farisei 'a ura haaria na'i na'o ma ha'arahesi o'ani, ‘God 'au ha'atee ha'agorohi'o, 'inia 'inau 'au ai'a 'onaai'i tara'i sae nara beriberi mara taritari'a baaniai urao adaa'i, ma'ua haa'i tara'i here ta'a'i ro'u. Mau ha'atee ha'agorohi'o di'u do 'inau 'au ai'a 'onaaiai sae ha-ha'atakisi 'ariani. ");
INSERT INTO aia_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","'Inau 'au ha'aririta'i ngau rua dangi na'i ta'i sade, mau matai wate'i tana'o i tangahurudi ha'a 'iniai horihorigu.’ ");
INSERT INTO aia_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Mana sae ha-ha'atakisi 'a ura gere ha'atau moi baaniai Farisei ma totopwau auru, suria 'a 'iraraa haaria do'a ai'a ta'isada 'anai wana ara'ai aro. 'A hidai waiburuna 'inia 'a ahutotou 'ini'i taritari'a ana'i, ma ha'arahesi o'ani, ‘God 'oi ahu ta'ahiau! 'Inau 'e inoni ora-ora'a.’” ");
INSERT INTO aia_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mia Jisas 'agu ha'atee o'ani, “'Inau wai 'unua tana'amou, na'i 'oha nararu ha'arahesi hako, ai'a Farisei, ma'ata na sae ha-ha'atakisi ani na 'ia God na ahugoro 'inia. 'Onaa na'oi ha'a-ororiu'o di'uraaui inoni, 'ia God 'ai ha'a-auruhi'o, ma 'onaa na'oi ha'a-anoano'o haari'o, 'ia God 'ai ha'a-ororiu'o.” ");
INSERT INTO aia_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ma ra'i sae ra waa'i mai kakae adaa'i do'ia Jisas 'ai karohiraau maai ha'agorohiraau. Na'i 'oha na 'iraaui rongoiusuri rau 'omesia o'asi, rau ha'a-aburaaui sae. ");
INSERT INTO aia_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mia Jisas 'a 'unuraaui gare mai beia ma o'ani 'iniraaui rongoiusuri, “Moi abui ha'a-bwarasiraau. Moi wateraaui gare marai boi beiau. 'Inia 'iraaui nei ra 'onaairaausi, naasi nei nara arari 'anai awa bahainai heimarungi ana God. ");
INSERT INTO aia_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","'Inau wai 'unua ha'a-momori tana'amou: 'Iatei na bwa'i 'u'uria God 'onaai gare, 'a bwa'i siri na'i heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","'E saemaua na boi ma songa'inia Jisas o'ani, “Ha'ausuri. I'oe 'e sae goro. 'E taha nawai haua nawai daua 'iniai tahi tarau?” ");
INSERT INTO aia_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mia Jisas 'a aramia o'ani, “Ni 'uaana na'o 'unua 'inia do 'inau 'au goro? Ai'a tanei do 'ai goro, me 'iia moia God. ");
INSERT INTO aia_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","I'oe 'o bwani aidangisiai Ha'atora: Abui taritari'a baaniai urao amua ma'ua mwane amua, abui ngahu ha'amaesiai sae, abui beri, abui pwari'i na'i kooti, ma'oi ha'ahoua amamu mea inamu.” ");
INSERT INTO aia_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mana saemauasi 'a o'ani, “Na mwane mareho 'isi 'au bwane ha'isuri'i mau mai na'i 'oha nau kekerei.” ");
INSERT INTO aia_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Na'i 'oha 'ia Jisas 'a rongoa o'asi, 'agu o'ani 'inia, “'E ta'i mareho na i'oe 'o ai'a haua mau. 'Oi raonga'ini'i hakoi mareho na'o to'ora'i. Mana ha'a 'ada'i, 'oi hisungiraau 'ini'i pohara. 'Onaa 'oi haua o'asi, 'oi toto'ora na'i aro. Na'i muri 'oigui boi suriau.” ");
INSERT INTO aia_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Na'i 'oha na saesi 'a rongoa o'asi, 'a kaeni ahutotou raha di'u, 'inia 'iia 'a toto'ora di'u. ");
INSERT INTO aia_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mia Jisas 'a wanasia ma ha'atee o'ani, “'Ai bwara di'u tanaraaui sae ra toto'ora 'anai siri na'i heimarungi ana God. ");
INSERT INTO aia_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","'A 'ua? I mwamwaa nara 'unua 'iniai kamel 'a matai siri daara'i na'i maanai nira? 'A bwara! Ma bwara di'u ro'u wou tanaai nei na toto'ora 'anai siri na'i heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Miraaui inoni narau rongoai marehosi rau ha'atee o'ani, “Romwane, 'onaa na o'asi, ma 'ome 'onaa do 'a bwa'i ta sae nai dauai tahi tarau!” ");
INSERT INTO aia_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mia Jisas 'agu aramiraau o'ani, “I taha na bwara tanaai inoni 'anai haua, 'a mwada'u moi tanaa God.” ");
INSERT INTO aia_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mia Pita 'a o'ani 'inia, “'Ome Araha, 'i'ameu meu nugasi'i hakoi mareho nameu to'ora'i mameu suri'o.” ");
INSERT INTO aia_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisas 'agu o'ani 'iniraau, “Wai 'unua ha'a-momori tana'amou, 'iatei na 'adoma'i ororiu 'iniai heimarungi ana God ma nugasiai ruma ana, mana urao ana, mana do'orana'i, inana mana amana, ma'ua gare ana'i, ");
INSERT INTO aia_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","'ai dau'i mwane mareho na'i marewanani di'u'i mareho na nugasi'i. Ma na'i marewana nai boi ta'oha, 'ai daua nana i tahi tarau.” ");
INSERT INTO aia_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","'Ia Jisas 'a wairaaui ta'i tangahuru mana rua rongoiusuri ana beia ma o'ani 'iniraau, “Moi bahurongo goro. Na'i 'ohanisi gau hahano'a 'anai Jerusalem. Ma na'i 'oha nagai ataha wou, na mwane ha'atee duruduru narau haa'i rarabea na'i 'oha bwani, rai to'o ha'a-momori tanaau i Garei Inoni. ");
INSERT INTO aia_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Rai usuha'iniau tanaraaui nei narau ai'a Jiu 'anai haikou 'iniau. Rai 'isi'isiau, marai ngisuai abegu. ");
INSERT INTO aia_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Rai rorohoau marai ha'amaesiau. Ma'ata 'e rua dangi nai hako mana'i oruna wai suruta'e aho'i baaniai mae.” ");
INSERT INTO aia_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Miraaui rongoiusuri ana'i rau ai'a aidangisi'i moe'a i mareho 'isi. Na 'ado'ado 'ada'i ha'atee na haa'isi ra bainihu, marau ai'a aidangisi'i taha na 'ia Jisas 'a hadanga'ini'i. ");
INSERT INTO aia_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Na'i 'oha 'ia Jisas 'a 'ariwou gaarangiai 'omaai Jeriko, 'e sae na kuru na heinagu na'i bobonai tara 'anai haha'angoni ha'a. ");
INSERT INTO aia_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Na'i 'oha na rongoai tahahoro adaaui inoni, 'agu heisonga'i o'ani, “'E taha na to'o?” ");
INSERT INTO aia_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Rau 'unua tanaa do'ia Jisas ni Nasaret 'a tahahoro. ");
INSERT INTO aia_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Miagu totoro ara'a o'ani, “Jisas, warowarona Deved, 'oi arunga ta'ahiau ma'oi 'a'auhiau!” ");
INSERT INTO aia_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Miraaui nei narau na'o 'inia Jisas rau 'unua tanaai sae na kurusi do'ai papaku, miagu awaawara raha baaniai na'o. “I'oe warowarona Deved, 'oi arunga ta'ahiau ma'oi 'a'auhiau!” ");
INSERT INTO aia_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mia Jisas 'a ura papaku, ma 'unua dorai urua maia mo'o na kurusi tanaa. Na'i 'oha na boi gaarangia, 'ia Jisas 'agu o'ani 'inia, ");
INSERT INTO aia_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“'E taha na'o 'irisia dowai haua tana'o?” Mana sae na kurusi 'a o'ani, “Araha, 'au raba 'ome'ome.” ");
INSERT INTO aia_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mia Jisas 'a o'ani 'inia, “'Oi wana, na hinihinimu na ha'agorohi'o.” ");
INSERT INTO aia_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na'i mau 'ohasi mana sae kurusi 'a wana'a. 'A suria Jisas ma 'unu ha'aasaa God. Ma na'i 'oha na 'iraaui inoni rau 'omesia o'asi, rau 'unu ha'aasaa ro'ua God 'inia. ");
INSERT INTO aia_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na'i 'oha 'ia Jisas 'a tahahoro wou na'i 'omaai Jeriko, ");
INSERT INTO aia_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","'e sae na atana 'ia Sakias na awa 'isi. 'Ia Sakias 'e bwauodo adaaui ruruha narau si'ogoni takisi, me 'iiasi 'e sae to'ora ha'a. ");
INSERT INTO aia_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","'Ia Sakias 'e sae pwapwaku, magu raba 'omesia di'u a Jisas. Me suriai pwapwaku di'u ana 'a bwara tanaa do 'ai 'omesia, 'inia 'a rago di'ui sae narau surisuria Jisas. ");
INSERT INTO aia_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hoita, mia Sakias 'a 'eba na'i na'o ma hane ara'a na'i hasi'ei nara 'unua 'iniai Sikamo, do neina 'ai 'omesia goro a Jisas 'oha nai taha wou. ");
INSERT INTO aia_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na'i 'oha 'ia Jisas 'a ataha wou na'i marunai hasi'eisi, 'a wana ara'a ma o'ani 'inia Sakias, “Sakias, 'oi dio mai'a, 'inia na'i dangini wai awa'a ma'ata'a na'i ruma amua.” ");
INSERT INTO aia_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mia Sakias 'a dio raurau baaniai hasi'eisi, ma waia Jisas 'ari ruma ana ha'i wa'ewa'e. ");
INSERT INTO aia_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Miraaui nei narau 'omesia o'asi rau taesu'a marau o'ani, “'Ome! 'Ia Jisas 'ai siri awa na'i ruma anai sae ora-ora'a na!” ");
INSERT INTO aia_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hoita, 'ia Sakias 'a ura ma ha'atee o'ani, “'Ome Araha. Naani 'au duruduru doni aba 'ini'i mareho hako nau to'ora'i wai haa'i tanaraaui pohara, ma 'onaa 'e sae nau ha'a-bweubweu'aa, 'inau wai su'ua ha'ahai aho'i tanaai siha ha'a nau ha'a-bweubweu'aa 'inia.” ");
INSERT INTO aia_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mia Jisas 'a o'ani 'inia, “Dangini 'ia God 'a ha'atahi'o beiraau hakoi nei na'i ruruha amua, suria i'oe 'o to'oraai hinihini na 'onaai hinihinina Ebraham. ");
INSERT INTO aia_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","'Inau Garei Inoni, 'au boi 'anai sibaniraaui nei nara teha ma 'anai ha'atahiraau.” ");
INSERT INTO aia_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","'Iraaui inoni rau bahurongo'i mau i ha'atee ha'ausuringa'i ana'ia Jisas. Me 'iniai gaarangi ataha wou adaau na'i Jerusalem, 'ia Jisas 'a haua ro'u tanaraaui ha'atee heiha'auu 'anai ha'a-odoodoai 'ado'adodaau. 'Inia 'iraaui inoni rau 'adoma'inia dona heimarungi ana God 'ai taraawa'a na'i 'oha 'ia Jisas 'ai ada na'i 'omaasi. ");
INSERT INTO aia_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naasi ma o'ani, “'E saemaua na ha'aagau 'anai hano ha'atau 'ari na'i marau raha dorai ha'amwaerahaa, maigui aho'i mai. ");
INSERT INTO aia_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ma na'i na'o magu hano, 'a soiraau mai waira ta'i tangahurui sae tatau'aro ana, ma ha'a-'u'uriraau 'ini'i kae ha'a ma o'ani 'iniraau, ‘Moi ha'atagora'i ha'a 'isi mamoi ha'arago'i tari 'oha wai aho'i mai.’ ");
INSERT INTO aia_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Miraaui noni na'i dora ana rau 'itaai saemauasi. Naasi marau ha'ataari'i 'ari haisuri tara'i sae 'anai 'unua tanaai mwaeraha do'ai abui ha'amwaerahaai saemauasi, 'inia rau 'itaa do 'ai mwaeraha tanaraau. ");
INSERT INTO aia_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ma'ata rei'uaa na o'asi, ni mwaeraha 'a ha'amwaerahaai saemauasi do'ai heimarungi na'i dora na ha'a-'omesuria 'inia. Na'i 'oha na aho'i mai na'i 'omaa, 'a soiraau mai sae tatau'aro ana'i 'anai sadoiai siha ha'a narau sadoi'i 'ini'i ha'a na haa'i tanaraau 'anai ha'atagora'i. ");
INSERT INTO aia_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mana sae tahamora 'a boi ma o'ani, ‘Saemaua, ni ha'a amua nau ha'atau'aroa, 'au a'oia ara'a ha'atangahuru.’ ");
INSERT INTO aia_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mana mwaeraha 'agu o'ani, ‘'A goro ha'atai sae tatau'aro agua. Suria 'o mangudisi'i gere mareho, 'inau wai ha'a-'omesuri'o 'inia ta ta'i tangahurui kae 'omaa.’ ");
INSERT INTO aia_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Na ruanai sae 'a boi ma o'ani, ‘Saemaua, na ha'a amua nau ha'atau'aroa, 'au a'oia ara'a ha'arima.’ ");
INSERT INTO aia_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mana mwaeraha 'agu aramia o'ani, ‘I'oe 'o kae here goro di'u ro'u. I'oe wai ha'a-'omesuri'o 'inia ta rima kae 'omaa.’ ");
INSERT INTO aia_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Mana nata sae 'a boi ma o'ani, ‘Saemaua, naani ha'a amua. 'Au mamaa'usi'o, mau giru ha'agorohia na'i hangete, suria i'oe 'e sae hahaungarimu. 'Au 'iraraa do 'oi rahi'i ha'a na 'iraaui sae tatau'aro amu'i nara a'oi'i ara'a 'ini'i ha'a na'o ha'a-'u'uriraau 'ini'i, ma'o 'adoma'iniai dau ha'a baani'i mahoingau na 'iraau sae tatau'aro amu'i ra hasi'i.’ ");
INSERT INTO aia_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Mana mwaeraha 'a o'ani, ‘I'oe 'e sae tatau'aro ta'aa! Na ha'atee na'o haa'i wai hiiri'o aho'i 'ini'i! Ni 'iraraa amua do 'inau 'e sae o'asi, ");
INSERT INTO aia_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","'o ga'i ha'atagoraai ha'a agua na'i ruma ni niga ha'a! Neina na'i 'oha nawai aho'i mai, wai matai daa goni beia ta gere ha'a narai a'oia ara'a ro'u na'i hungana.’ ");
INSERT INTO aia_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Naasi magu o'asi 'iniraaui nei narau ura 'isi, ‘Moi rahiai ha'asi baania mamoi haua tanaai sae tatau'aro nara rago di'u i ha'a ana'isi.’ ");
INSERT INTO aia_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Miraau aramia o'ani, ‘Saemaua, 'iia ha'a ana'i ra bwani rago'a.’ ");
INSERT INTO aia_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Mana saemauasi 'a o'ani 'iniraau, ‘'Inau wai 'unua tana'amou, tanaa mo'o na here ha'agorohiai taha nau haua tanaa, 'inau wai ha'arago'a ro'u wou tanaa. Mei tanaa mo'o na ai'a here ha'agorohiai mareho nau haua tanaa, rei'uaa mareho kekerei he'ua na to'oraa, wai rahia aho'i baania. ");
INSERT INTO aia_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mei tanaraaui nei narau ha'imae beiau ani narau ai'a 'irisia dowai mwaeraha 'anai marungiraau, moi wairaau mai, mamoi ngahu ha'amaesiraau 'ini na'i maagu.’” ");
INSERT INTO aia_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Na'i 'oha na 'ia Jisas 'a maani'i hakoi mareho 'isi, 'agu hano 'anai na'o 'ari 'anai Jerusalem. ");
INSERT INTO aia_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ma na'i 'oha na 'ia Jisas 'a gaarangia wou i 'omaai Betfeis mei Betani gaarangiai hungahungai 'Oliv, 'a ha'a-taarirarua 'ari na'i na'o i rua rongoiusuri ana. 'A o'ani 'inirarua, ");
INSERT INTO aia_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Murui hano mamurui 'ari nai 'omaa nagau 'ari wou 'ana. Na'i 'oha namurui tahawou na'i 'omaa, murui 'omesiai garei dongki nara ho'osia. Na dongkisi 'a ai'a ta sae mau nai ta'e na'iei. Naasi murui wagasia mamurui waia mai tanaau. ");
INSERT INTO aia_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma 'onaa ta sae nai songa'inimurua 'iniai taranai taha namuru wagasia 'inia i mwamwaasi, murui 'unua tanaa do'ia Araha na 'irisia.” ");
INSERT INTO aia_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hoita, na'i 'oha na raru 'ariwou na'i 'omaasi, raru 'omesiai dongki 'onaai 'unua ana Jisas tanararua. ");
INSERT INTO aia_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na'i 'oha nararu wagasiai mwamwaasi, ni sae narau to'oraa rau o'ani 'inirarua, “'E taha na muru wagasia 'ana i mwamwaasi?” ");
INSERT INTO aia_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Miraru o'ani, “'Ia Araha na 'irisia.” ");
INSERT INTO aia_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Naasi ma rarugu waa mai dongkisi tanaa Jisas, raru nuga'i to'oni bo hura'a adaru'i na'i hungana, marau ha'ata'ehahia Jisas 'anai heinagu na'i hungana. ");
INSERT INTO aia_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na'i 'oha na ta'e 'anai 'ari Jerusalem, 'iraaui inoni rau haari'i to'oni adaa'i na'i tara. ");
INSERT INTO aia_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na'i 'oha narau gaarangia wou i Jerusalem narau taraawa'ai dio suriai hungahungai 'Oliv, na kae ruruhai sae narau rongosuria Jisas rau ha'atee ha'agorohia ha'i wa'ewa'e marau ha'aasaa God beiai ringe raha 'ini'i mwane ha'abu'oahu na 'ia Jisas 'a haa'i narau 'omesi'i. ");
INSERT INTO aia_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Rau o'ani, “Araha God, 'oi ha'agorohia mo'o na'o ha'ataaria mai 'anai mwaeraha! Goroha 'ai awa na'i aro. Gau magai ha'aasaa God na awa ara'ai aro!” ");
INSERT INTO aia_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ma tara'i Farisei narau awa na'i 'ohasi, rau ha'atee o'ani 'inia Jisas, “Ha'ausuri, 'oi ha'a-papakuraaui sae narau suri'osi.” ");
INSERT INTO aia_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mia Jisas 'a o'ani 'iniraau, “Wai 'unua tana'amou, 'onaa 'iraaui rongoiusuri agu'i rai papaku, na mwane hau hako suriai tarasi naraigu ha'atee ha'aasaa God.” ");
INSERT INTO aia_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Na'i 'oha na gaarangia wou i Jerusalem, 'a wanasia 'ari 'omaa ma angi, 'inia 'a ahutotou di'u suria. ");
INSERT INTO aia_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ma ha'atee ha'i angiangi o'ani, “'Onaa namou ga'i aidangisiai taha na matai ha'ahagumou aho'i beia God, 'a ga'i goro, me na'i 'ohani ra girua baani'amou. ");
INSERT INTO aia_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","'E 'oha nai boi mau na 'iraaui maerongamoo'i rai hei'oi bei'amou. Rai haa'i ariari ara'a na'i bara 'anai 'omaa amoou 'anai ta'eha suri'i marai siri wou na'i raronai 'omaa. Rai raroi'amou na bwa'i nei 'ini'amou nai matai hora. ");
INSERT INTO aia_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Rai ngahu ha'a-ai'a'amou goni bei'i mwane mareho na'i raronai 'omaa amoousi mana mwane ruma amoo'i rai kokohu ro'u. 'Ai o'asi suria mou ai'a 'ome 'iraraa do 'ia God 'a boi 'anai ha'atahi'amou!” ");
INSERT INTO aia_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ma na'i 'oha 'ia Jisas 'a ataha wou, 'a siri wou na'i dora a'ora na'i maanai Ruma Maea ana God ma taariraau hura'a i noni nara raoraonga'i na'i rarona. ");
INSERT INTO aia_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma o'ani 'iniraau, “Na'i Usu-usu Maea 'ia God 'a o'ani, ‘Na ruma agua 'e ruma 'anai ha'arahesi.’ Mi'amou mou ha'i dora ni bainihu 'inia nadaaui sae beriberi.” ");
INSERT INTO aia_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","'Ado dangi 'ia Jisas 'a ha-ha'ausuri na'i Ruma Maea. Miraaui Na'ohadaa'i Piriisi, miraaui Ha'ausuri 'anai Ringe ana'ia Moses, ma tara'i saemaua adaa'i Jiu rau bonasia dorai sadoia ta here narai ngahu ha'amaesia 'inia. ");
INSERT INTO aia_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Magu 'a bwara tanaraau, suria ra ragoi inoni narau goni wou 'anai bahurongo'i ha'ausuringa'i ana'i, 'inia rau ai'a rabasia dorai adarahia ta ta'i ha'atee. ");
INSERT INTO aia_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ma'e ta'i dangi na 'ia Jisas 'a ha-ha'ausuri raaui noni na'i Ruma Maea ana God, ma taroha'iniai Taroha Goro tanaraau. Miraau na Na'ohadaa'i Piriisi, miraaui Ha'ausuri 'anai Ringe ana'ia Moses ma tara'i saemaua'a ro'u, rau boi beia marau o'ani 'inia, ");
INSERT INTO aia_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“'Oi 'unua tana'ameu, 'iatei na 'unua tana'o do'oi matai haa'i mareho 'isi?” ");
INSERT INTO aia_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mia Jisas 'a o'ani 'iniraau, “'Inau wai songa'ini'amou ga'u. Moi 'unua tanaau, ");
INSERT INTO aia_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","'ia tei na 'unua tanaa Jon 'anai bwareomaearaaui inoni? 'Ia God ma'ua inoni?” ");
INSERT INTO aia_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Miraaugu hadahada haariraau hairiu o'ani, “'Onaa nagai 'unua do'ia God, me'iia 'ai o'ani, ‘Ma 'ua namou ai'a hinihinia 'inia Jon?’ ");
INSERT INTO aia_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma 'onaa nagai 'unua do 'iraau moi inoni nara 'unua tanaa, ma 'iraaui inoni rai buta ha'amaesigaau 'iniai hau, 'inia 'iraau hakoi inoni rau hinihini wetewete do'ia Jon 'e rarabea.” ");
INSERT INTO aia_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Miraaugu o'ani 'inia, “Meu ai'a 'iraraa mo'o na 'unua tanaa.” ");
INSERT INTO aia_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mia Jisas 'agu o'ani 'iniraau, “Nau bwa'i rangasia ro'u tana'amou 'iatei na 'unua tanaau do wai matai haa'i mareho 'isi.” ");
INSERT INTO aia_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mia Jisas 'a haa ro'u i ha'atee heiha'auu o'ani tanaraaui inoni, “'E ta'i sae na hasiai moui grep. Na'i 'oha na hasia hako, 'agu raonga'inia hura'a tanaraau tara'i sae narau raba 'omesuria 'anai haa'i nadaa'i hua. Na'i 'oha na ha'a-'omesuriraau 'inia, 'iia 'a hano ma 'ari awa orea na'i kantri he'ete'i. ");
INSERT INTO aia_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na'i 'oha na tari mai madoraa 'anai husi, ni sae na to'oraai mousi 'a ha'ataaria 'ari ta'i 'iniraaui inoni tatau'aro ana'i 'anai 'ari waa'i mai hua narau ga'i haa'i tanaa baaniai moui grep anasi. Na'i 'oha na ataha wou, 'iraaui mwane narau 'omesuriai mousi rau ngahu ngahua moi, marau ha'ataaria aho'i 'ari ha'i pwaranga. ");
INSERT INTO aia_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Naasi 'a 'ariwou ma ha'ataaria ro'u 'ari ta'i inoni tatau'aro ana. Na'i 'oha na 'ariwou, 'iraaui sae 'isi rau ngahu ngahua ro'u marau here ha'ata'aia marau ha'ataaria aho'i ro'u 'ari ha'i pwaranga. ");
INSERT INTO aia_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Naasi ma ha'ataaria ro'u 'ari orunai sae tatau'aro ana, mana sae 'isi rau ha'amaaraa marau gaasia hura'a baaniai dorasi. ");
INSERT INTO aia_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Hahakona mia mo'o na to'oraai mousi 'a o'ani, ‘'E taha gasi nawai haua? Wai ha'ataaria 'ari gare agua nau huunai ta'ahia ororiu, 'iia gasi narai ha'ahoua.’ ");
INSERT INTO aia_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Na'i 'oha na 'ariwou i gare ana, 'iraau sae ta'a'i 'isi rau hadanga'inia hairiu o'ani na'i ahoaadaau, ‘Naasia mo'o naigu to'oraai mousi na'i 'oha nai mae amana. Gau magai ngahu ha'amaesia magai to'oraa nagaau i moui grepisi.’ ");
INSERT INTO aia_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Rau 'ariwou marau daua. Rau waia hura'a na'i murinai mou naraugu ngahu ha'amaesia na'iei. “Hoita, 'e taha nai haua mo'o na to'oraai mou 'adaaui mwane narau 'omesuriasi? ");
INSERT INTO aia_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","'Iia 'ai boi, maai ngahu ha'amaesiraau hako maai wateai mou tanaraau tara'i nei he'ete'i ro'u.” Na'i 'oha na 'iraaui inoni rau rongoai ha'atee o'asi ana, raugu ha'atee o'ani, “'Ai abui to'o o'asi!” ");
INSERT INTO aia_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mia Jisas 'a wana wetewete 'iniraau ma ha'atee o'ani, “'Onaa 'a bwa'i o'asi, ma 'e taha naasi 'ado'ado 'anai dorai Usu-usu Maea na o'ani, ‘Na hau na 'iraaui sae tatau'aro ruma rau 'itaa, naia naagu ha'i hau na ororiu di'u na'i bani anai ruma.’ ");
INSERT INTO aia_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mia tei nai agusu na'i hausi, 'ai maara ta'aa. Mia tei na hausi 'ai ahoda hunia, 'ai meme'a.” ");
INSERT INTO aia_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na'i 'ohasi 'iraaui Na'ohadaa'i Piriisi, miraaui Ha'ausuri 'anai Ringe ana'ia Moses, rau siba herehere 'anai daua dorai ha'a-mama'aia, 'inia rau 'iraraa do na ha'atee heiha'auu na haua 'a to'iraau. Maraugu ai'a buna daua suria rau magugu do ra gasigu ha'agogoru i noni. ");
INSERT INTO aia_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","'Iraau na saemaua adaa'i Jiu rau bonasia moe'a mau 'anai sadoia ta here narai matai daua 'inia Jisas. Naasi rau ha'ataari'i sae tanaa Jisas dorai here 'onaai sae goro marai ha'imaania Jisas 'ini'i heisonga'i adaa'i. Rau bonasia do'ia Jisas 'ai 'unua ta mareho narai taarai waia 'inia 'ari tanaai sae ni Rom na Primia na'i 'ohasi, maai ha'a-mama'aia. ");
INSERT INTO aia_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Miraaui nei nara raba ha'imaania Jisas rau 'ariwou beia marau o'ani, “Ha'ausuri, meu 'iraraa dona mwane ha'ausuringa'i amu'i ra ha'a-momori hako ma'o ha'ausuriraaui noni 'ini'i taha 'ia God na 'irisiai noni 'anai haa. Ma na'i 'oha na'o ha'ausuriraau, rei'uaa na 'e sae he'ua nara bahurongo'o, mana ha'ausuringa'i amu'i ra ta'isada moi. ");
INSERT INTO aia_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Naasi, 'oi 'unua tana'ameu. 'A 'ua? Na'i ringeringe agaau, 'a odo-odo dogai hori takisi tanaai mwaeraha raha na'i Rom ma'ua ai'a?” ");
INSERT INTO aia_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","'Ia Jisas 'a 'iraraa dorau raba pwari'ia, ma o'ani 'iniraau, ");
INSERT INTO aia_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Moisu waa mai ta korai ha'a.” Rau haua tanaa, magu o'ani 'iniraau, “Na atana mana nununa tei na awa na'i korai ha'ani?” ");
INSERT INTO aia_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Miraaugu aramia o'ani, “I atana mana nununai Mwaeraha adaaui Rom.” Miagu o'ani 'iniraau, “'Onaa na o'asi, mamoi haua tanaai Mwaeraha i taha 'iia na to'oraa, mamoi haua tanaa God taha 'ia God na to'oraa.” ");
INSERT INTO aia_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Naasi, 'a bwara tanaraau dorai ha'aagauhia Jisas, rei'uaa narau bonasia do'ai 'unua ta maho taritari'a na'i maadaa'i noni. Raugu bahu moi 'iniai heimwaosi hako adaau 'iniai heiarami na haua. ");
INSERT INTO aia_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ma na'i muri, ra'i Sadiusi ra boi beia Jisas. 'Iraausi rau ai'a hinihinia do 'irai noni rai suruta'e aho'i baaniai mae, miraau songa'inia Jisas o'ani, ");
INSERT INTO aia_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ha'ausuri, 'ia Moses 'a nugaai Ha'atora tanagaau do 'onaa 'e sae ha'iwai nai mae baaniai urao ana mararu ai'a to'o gare, na do'orana 'ai orisia, mai waina ro'u i uraosi. Mana gare na rarui to'ora'i, rai 'unu'i 'ini'i gare ana'i do'orana na maesi, neina burungana 'a bwa'i hako. ");
INSERT INTO aia_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hoita, 'e heiha'auu naani. 'E ta'i 'oha 'e biu ha'ido'orada narau awa wou, mana gare na hutai na'o 'a ha'iwai. Raru ai'a to'o gare mau i urao anasi ma mae'a baania. ");
INSERT INTO aia_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","'Ariwou mana gare na hutai muri 'a waina ro'u i naosi. Raru ai'a to'o gare mau ma mae'a ro'u baaniai uraosi. ");
INSERT INTO aia_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","'Ariwou mana orunai do'oradaau 'a waina ro'u. Raru ai'a to'o gare ro'u mau ma mae'a ro'u baaniai uraosi. 'A o'asi moe'a naraugu buna mae hakoi biu ha'ido'oradasi ha'i ai'a to'o gare beiai uraosi. ");
INSERT INTO aia_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na'i muri mana uraosi 'a mae ro'u. ");
INSERT INTO aia_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hoita, na'i 'oha na 'iraaui biu ha'ido'oradasi rau waina hako o'asi uraosi, 'iatei 'iniraau nararugui ha'iwai uraosi na'i 'oha na 'ia God 'aigui ha'a-suruta'eraau aho'i baaniai mae?” ");
INSERT INTO aia_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mia Jisas 'a aramiraau o'ani, “Na'i marewanani na mwane mana urao ra matai ha'iwai. ");
INSERT INTO aia_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mei tanaraaui nei nara arari 'anai suruta'e aho'i baaniai mae 'anai awa na'i marewana nai boi ta'oha, ra bwa'i ha'iwai ");
INSERT INTO aia_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","mara bwa'i mae'a ro'u. 'Inia 'iraau rai 'onaairaaui enjel nara bwa'i mae. 'Iraau ra'i garena God, 'inia 'ia God a ha'a-suruta'eraau baaniai mae. ");
INSERT INTO aia_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","'Ia Moses 'a ha'ata'inia goro moi hura'a tanagaau dona sae 'ai suruta'e aho'i baaniai mae. Na'i dora nara maaniai gere hasi'ei na ngarungaru ani, 'ia Moses 'a 'unua do 'ia Araha God 'e God ana Ebraham, Aisak, mea Jekop. ");
INSERT INTO aia_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mana God naasi, ai'a God adaaui nei ra mae, me 'e God adaaui nei ra tahi. Naasi 'a ha'ata'inia doni waira orusi rau tahi mau, rei'uaa narau bwane mae. 'Inia na'i beia God, na mwane inoni ra tahi.” ");
INSERT INTO aia_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma tara'i Ha'ausuri 'anai Ringe ana'ia Moses raugu o'ani, “Ha'ausuri, 'o heiarami goro ha'atai!” ");
INSERT INTO aia_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma ai'a ta ta'i nei 'iniraau'a ro'u naigui raba haua ro'u ta ta'i heisonga'i. ");
INSERT INTO aia_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mia Jisas 'a o'ani 'iniraau, “'Iniai 'uaana naragu 'unua 'inia do ni Ha'atahi 'e warowarona moia Deved? ");
INSERT INTO aia_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Na'i buka Psalm 'ia Deved 'a 'unu ha'arangasia hura'a o'ani, ‘'Ia Araha God a ha'atee tanaai Araha agua o'ani: 'Oi heinagu na'i aba odogu 'anai heimarungi beiau, ");
INSERT INTO aia_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tari 'oha wai nugaraaui maerongamu na'i bahainai heimarungi amua.’ ");
INSERT INTO aia_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na'i 'oha na 'ia Deved 'a 'unua do 'ia Ha'atahi 'e Araha ana, 'a ha'ata'inia do 'ia Araha ai'a do'e warowarona moi, ma'ata 'iia Araha ro'u ana.” ");
INSERT INTO aia_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Na'i 'oha na 'iraaui inoni rau bahurongo, 'ia Jisas 'a o'ani 'iniraaui rongoiusuri ana'i, ");
INSERT INTO aia_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Moi hehere goro 'iniraaui Ha'ausuri 'anai Ringe ana'ia Moses. 'A goro adaau hano hairiu na'i maketi bei'i to'oni ororiu adaa'i do neina 'iraaui inoni rai 'ome 'irararaau marai ha'ahouraau. Na'i 'oha narau siri suri'i ruma ni ha'arahesi, mei suri'i ngau goni nara haa'i, rau 'irisia dorai heinagu moe'a suri'i dora ororiu. ");
INSERT INTO aia_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Rau matai ha'a-bweubweu'araaui nao 'ini'i ruma adaa'i mana mareho narau to'ora'i. Mana 'oha rai ha'arahesi, rau pwari'i ha'amaesiraaui inoni 'anai haa'i rihunga'i tewa. Moi 'iraraa do na ha'a-mama'ai, 'ia God 'ai ha'arahaa ro'u wou tanaraau.” ");
INSERT INTO aia_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na'i 'oha na 'ia Jisas 'a awa mau na'i Ruma Maea ana God, 'a wana ara'a ma 'omesi'i sae toto'ora nara 'ariwou nuga ha'a na'i bakosi ni wawate. ");
INSERT INTO aia_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Naasi ma 'omesia ro'u i nao pohara na 'ariwou gaasia dioi rua gere korai ha'a. ");
INSERT INTO aia_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mia Jisas 'agu ha'atee o'ani, “'Inau wai 'unua ha'a-momori tana'amou, na naosi 'a nuga ha'a di'uraau hakoi mwane sae 'isi. ");
INSERT INTO aia_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","'Iraaui mwane sae 'isi rau hisu moi 'ini'i taha nara madara suri'i toto'ora adaa'i. Mana uraosi, 'oha na wateai ha'a ana, 'agu ai'a to'oraa'a ro'u tanei.” ");
INSERT INTO aia_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Miraau tara'i rongoiusuri rau hadanga'iniai 'ome goro na haai Ruma Maea, mana hau 'ome goro ra tagorahia 'ini'i ma 'ini'i mwane mareho 'ome goro na 'iraaui noni ra wate'i 'anai ha'araunia 'ini'i. ");
INSERT INTO aia_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Mia Jisas 'a o'ani, “Mou 'omesi'i mwane mareho 'isi? 'E 'oha nai boi mau na bwa'i ta ta'i hau 'ini'i hau 'isi naraigui awa suri'i dora nara heinagu suri'i. Na mwane hau 'isi rai gaasi'i dio.” ");
INSERT INTO aia_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Miraau ha'atee o'ani 'inia, “Araha, na'i 'oha he'ua narai to'o i mareho 'isi? 'E ha'ara he'ua namei re'ia nameigu 'iraraa 'inia do 'a tari'a i madoraa 'ana?” ");
INSERT INTO aia_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mia Jisas 'agu aramiraau o'ani, “Moi 'ome'ome goro, ra gasigu ha'ateha'amou tara'i sae. 'Ai ragoi nei narai boi heitaroha'i na'i atagu narai o'ani, ‘'Iia'a ninauni. Ni ha'ahakonai dangi naani'a.’ 'Oha nai o'asi, moi abui araisuriraau. ");
INSERT INTO aia_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Moi abui mamaa'u na'i 'oha namoi rongo'i tarohani hei'oi ma'ua taroha 'iniai marau nara hei'oi haariraau. Rei'uaa narai to'o i mareho o'asi, ma'ata ai'a do na ha'ahakonai dangi naasi'a.” ");
INSERT INTO aia_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma o'ani 'iniraau, “'Iraaui sae na'i ta'i kantri rai 'ari 'anai heingahui bei'i sae na'i nata kantri. ");
INSERT INTO aia_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ra'i nunu raha mana mwane riunga ta'a'i rai to'o suri'i tara'i dora, ma tara'i dora na inoni rai mae 'iniai hioro. Mwane mareho ha'amamaa'u mana mwane mareho ha'abu'oahu rai to'o na'i ahoasara. ");
INSERT INTO aia_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ma'ata na'i na'o maraigui to'o i mareho 'isi, rai dau'amou 'anai nora ta'ai'amou. Rai 'i'i'amou suri'i ruma ni ha'arahesi marai gaasi'amou siri na'i rumaniho'o. 'Iniai hinihiniau amoou, rai wai'amou tanaraaui Primia mana Mwaeraha 'anai hiiri'amou. ");
INSERT INTO aia_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma naasi madoraa goro 'anai taroha'inia hura'a i Taroha Goro tanaraau. ");
INSERT INTO aia_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Na'i na'o maraigui hiiri'amou, 'ai abui ta'aabemoou 'iniai taha moi 'unua 'anai taatahi bwarasi'amou. ");
INSERT INTO aia_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","'Inia 'inau nawai haa'i tana'amoui heiarami nara madoma na 'a bwa'i ta ta'i nei 'iniraaui maerongamoo'i naigu ura bwarasi'i ma'ua tohe'i. ");
INSERT INTO aia_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ai'a do 'iraau moi narai here ha'a-ta'ai'amou, me ni ama mana ina mana do'oramoo'i, miraaui sae amoo'i, ma'ua geresae amoo'i moi, narai usuha'ini'amou tanaraaui maerongamoou. Miraaui na'otara rai ngahu ha'amaesi'i tara'i nei 'ini'amou. ");
INSERT INTO aia_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na mwane inoni rai 'utai'amou, suria 'i'amou ra'i rongoiusuri agu'i. ");
INSERT INTO aia_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ma'ata 'a bwa'i do ta ta'i warihu suri'i bwaumoo'i nai ai'aa ha'atai. ");
INSERT INTO aia_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","'Onaa namoi ura baabau, moi daua namooui huunai tahi. ");
INSERT INTO aia_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Na'i 'oha namoi 'omesia do'iraaui sae hehei'oi rai ura garigariai Jerusalem, 'a ha'ata'inia do naasi'a i 'oha narai here ha'ata'aiai 'omaasi. ");
INSERT INTO aia_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na'i 'ohasi, 'i'amou inoni namou awa na'i Provensi Jiudea moi hora ta'eha suri'i hungahunga 'anai bainihu. 'I'amoui nei namou awa na'i Jerusalem moi hora hura'a baania, mi'amoui nei namou awa hura'a baaniai 'omaasi, moi abui siriwou. ");
INSERT INTO aia_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","'Inia naasi madoraa na 'ia God 'ai ha'a-mama'airaaui inoni na'i dorasi, mana mareho na 'iraaui rarabea rau usu'i rai to'o ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ha'a-arohai'araau di'ui urao ra pote mana hasuuri'i, 'inia 'ai bwara tanaraaui hora. 'E kae rongomaata'i nai raha di'u nai boi hungadaaui inoni nai Israel, mana taesu'a ana God 'ai boi hungadaau. ");
INSERT INTO aia_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tara'i nei rai ngahui'i 'ini'i naihi, tara'i nei rai dauraau 'anai wairaau 'ari suri'i marau he'ete'i 'anai ha'a-tau'aroraau. 'Iraaui nei nara ai'a Jiu rai here ha'ata'aiai Jerusalem 'aigui tari na'i ha'ahakonai madoraa adaau.” ");
INSERT INTO aia_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Mia Jisas 'a o'ani ro'u, “Mwane mareho ha'amamaa'u rai to'o na'i sina, ma na'i hura, mana'i bei'i hee'u. Mana mwane inoni hako na'i marewana rai mamaa'usiai aohanai asi mana mwane tabaosi raha ma'ai kakui ahudaa'i 'inia. ");
INSERT INTO aia_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Na inoni 'ai sadoi'i 'oi'oimae 'ini mamaa'usia adaa'i mareho narai boi 'anai ha'ata'aiai marewana. 'Inia na mwane mareho na'i ahoasara rai 'iha'iha. ");
INSERT INTO aia_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Miraaui inoni raigui 'omesiau i Garei Inoni na'i 'oha nawai aho'i mai na'i rorodo beiai mena mana raraha na wetewete. ");
INSERT INTO aia_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na'i 'oha narai taraawa'a to'o i mareho 'isi, moi ura arasi mamoi wana ara'a! 'Inia na Ha'atahi amoou 'a gaarangi'a.” ");
INSERT INTO aia_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mia Jisas 'agu hauai ha'atee heiha'auu tanaraau o'ani, “Moisu 'adoma'i surisuriai hasi'ei nara 'unua 'iniai fig, ma'ua taraani hasi'ei moi. ");
INSERT INTO aia_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Na'i 'oha namou 'omesia dora asuru, mou 'iraraa do madoraa raorao 'a gaarangi'a. ");
INSERT INTO aia_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","'A o'asi ro'u, na'i 'oha namoi 'omesi'i mareho ha'amamaa'u o'asi, 'a ha'ata'inia do na madoraa na 'ia God 'ai marungiraaui inoni 'a gaarangi. ");
INSERT INTO aia_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'Inau wai 'unua ha'a-momori tana'amou, maho 'isi rai to'o, miraaui sae nara awa na'i madoraani ra bwa'i mae mau. ");
INSERT INTO aia_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","I ahoasara mana ano rarui anoro mana ha'atee agu'i rai awa tarau.” ");
INSERT INTO aia_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Moi herehere goro. Moi abui gono raha 'iniai wai ni bweu namoi here 'ome to'obweubweu'a 'inia. Mamoi abui 'ado'ado raha 'ini'i mareho namou 'irisi'i 'anai tahitahi amoou na'i marewanani. 'Onaa moi o'asi, moi 'asu'a 'iniai boi aho'i agua. 'Ai 'onaai mwamwaa na 'asu'a 'iniai huna na to'o na'iei. ");
INSERT INTO aia_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","'Inia na boi nawai haa, 'ai ha'a-'asu'araau hakoi mwane inoni nai marewanani. ");
INSERT INTO aia_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Moi 'ome'ome goro mamoi ha'arahesi tarau neina moi matai tahi dadara'a suri'i mareho ha'amamaa'u abe narai to'o, ma ro'u do na'i 'oha namoi ura gaarangiau na'i maagu, 'inau i Garei Inoni, wai wa'ewa'e 'ini'o.” ");
INSERT INTO aia_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Suri'i dangi 'ia Jisas 'a ha-ha'ausuriraaui noni na'i Ruma Maea ana God, ma su'urahi mai ma ta'eha 'anai mauru na'i hungahungai 'Oliv. ");
INSERT INTO aia_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","'Ado dangi na'i haho'oa ta'aa, 'irai inoni ra goni wou na'i Ruma Maea 'anai bahurongo'i taha na 'ia Jisas 'a maani'i. ");
INSERT INTO aia_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mana Rongo 'iniai Bredi nara ai'a doraria 'iniai draebam nara 'unua ro'u 'iniai Rongo ni Roho Aharau 'a raumwadu. ");
INSERT INTO aia_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Miraaui Na'ohadaa'i Piriisi mana Ha'ausuri 'anai Ringe ana'ia Moses, rau bonasia siba 'inia ta here na bwa'i sae rago nai 'iraraa narai ha'amaesia 'inia Jisas. Rau 'irisia o'asi, suria rau magugu do 'a gasigu to'o ta ha'agogoru na'i 'oha narai daua. ");
INSERT INTO aia_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Naasi mia Saetan 'a tau'aro na'i 'adoma'ina Jiudas Iskariot, 'e ta'i 'iniraaui ta'i tangahuru mana rua Ha'ataari ana'ia Jisas. ");
INSERT INTO aia_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","'Ia Jiudas 'a taha beiraaui Na'ohadaa'i Piriisi miraaui na'ohadaaui hehei'oi narau 'omesuriai Ruma Maea ana God 'anai ha'aradorado beiraau 'iniai here nai haua narai daua 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Miraau wa'ewa'e di'u na'i 'oha narau rongoa do'ia Jiudas 'ai 'a'auhiraau, marau 'adoma'i aratara 'anai horia. ");
INSERT INTO aia_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mia 'a 'adoma'i aratara beiraau, magu sibasiba madoraa goro 'anai usuha'inia Jisas tanaraau, na'i 'oha na 'iraaui inoni ra bwa'i awa. ");
INSERT INTO aia_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na'i 'ohasi, 'a tari mai madoraa 'anai ha'ato'oai Rongo 'ini'i Bredi nara ai'a dorari'i 'ini'i draebam. Ma na'i dangisi ra ngahui'i tara'i garei siip 'anai 'adoma'i aho'isiai Roho Aharau. ");
INSERT INTO aia_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mia Jisas 'a 'unua mai Pita mia Jon ma o'ani 'inirarua, “Muru 'ari mamurui ha'aagau tanagaau 'anai ngauai Rongo ni Roho Aharau.” ");
INSERT INTO aia_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Miraru songa'inia o'ani, “Na'i hei na'o 'irisia do miri ha'aagauhia iei?” ");
INSERT INTO aia_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mia o'ani 'inirarua, “Na'i 'oha namurui siriwou na'i Jerusalem, 'e sae na suru'iai bei wai nai heisadoi bei'amurua. Murui suria, ma murui siri suria na'i ruma nai siri na'iei. ");
INSERT INTO aia_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Na'i 'oha namurui siriwou, murui songa'iniai sae na to'oraai rumasi. Murui o'ani, ‘I Ha'ausuri ameeu 'a raba 'iraraa, na hei ahii nai matai ngau iei beiraaui rongoiusuri ana'i 'anai 'adoma'i aho'isiai Roho Aharau?’ ");
INSERT INTO aia_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","'Ia mo'osi 'aigui wai'amurua ta'eha 'anai ha'ata'inia tana'amuruai kae ahii nara bwane ha'a-aratara ha'agorohia. Na'i 'isi namurui ha'aagauhi'i ei mwane mareho.” ");
INSERT INTO aia_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Na'i 'oha raru 'ariwou, raru 'omesia do na mwane mareho ra to'o 'onaai bwane 'unua ana Jisas tanararua. Mararu ha'aagauai ngaugoni 'anai 'adoma'i aho'isiai Roho Aharau na'i rumasi. ");
INSERT INTO aia_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na'i 'oha na tari mai madoraa 'anai ngau, 'ia Jisas mana rongoiusuri ana'i rau heinagu auru ha'aagau 'anai ngau. ");
INSERT INTO aia_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mia Jisas 'agu ha'atee o'ani 'iniraau, “'A orea'a mai 'adoma'i raorao agua dowai ngau bei'amou 'anai ha'ato'oai Roho Aharau mawaigu rongomaata'i. ");
INSERT INTO aia_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","'Inia wai 'unua tana'amou, 'a bwa'i ta'oha ro'u na waigui awa 'anai ngaa i Roho Aharausi bei'amou, tari 'oha na huunai 'ado'ado 'ana 'ai to'o ha'a-momori na'i hourana ana God.” ");
INSERT INTO aia_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mia Jisas 'a dauai panikeni waen. Na'i 'oha na ha'atee ha'agorohia God 'inia 'a o'ani, “Moi daua mamoi gono hasura'i 'inia. ");
INSERT INTO aia_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Wai 'unua tana'amou, 'a bwa'i ta'oha ro'u nawai gonohiai waen, 'ai tari 'oha nai boi heimarungi ana God.” ");
INSERT INTO aia_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Naasi ma dauai huai bredi, ma ha'atee ha'agorohia God 'inia. 'A uubia ma haua tanaraaui rongoiusuri ana'i, 'a o'ani, “Naani abegu nawai watea 'ini'amou, moi haua o'ani 'anai 'adoma'i aho'isiau.” ");
INSERT INTO aia_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ma o'asi ro'u na'i murinai ngau. 'A dauai panikeni waen ma o'ani, “Ni waen naani 'e duruduru haoru ana God nawai ha'a-'o'oria 'iniai 'abugu nai ahe 'anai ha'atahi'amou. ");
INSERT INTO aia_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ma moisui 'ome, 'e ta'i abe na ngau goni beigaau 'ini nai usuha'iniau tanaraaui maerongagu. ");
INSERT INTO aia_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","'Inau i Garei Inoni wai mae 'onaai 'irisia ana God, ma'ata 'a ha'arohaia di'u a mo'osi nai usuha'iniau!” ");
INSERT INTO aia_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Miraau na rongoiusuri raugu heisosonga'i hairiu 'inia tei 'iniraau nai hauai heresi. ");
INSERT INTO aia_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma'e heitohetohe na to'o ro'u na'i ahoaadaaui rongoiusuri 'inia tei nai ororiu 'iniraau. ");
INSERT INTO aia_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mia Jisas 'a ha'atee o'ani 'iniraau, “'Iraaui mwaeraha 'anai marewanani, ni heimarungi nara haa 'a bwara tanaraaui inoni. Ma rei'uaa na towa'i o'asi, miraau rau 'unua do rau 'a'auhiraaui inoni. ");
INSERT INTO aia_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mei bei'amou 'a ga'i bwa'i o'asi. 'Iatei na ororiu 'ini'amou, naasi nai ha'i sae haraaria, mia tei na na'otara 'ini'amou 'ai ha'i sae tatau'aro tana'amou. ");
INSERT INTO aia_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Na'i 'ado'adomoou, 'ia tei na ororiu di'u? 'Ia mo'o na heinagu 'anai ngau moi, ma'ua 'ia mo'o na ha'aagau mahoingau tanaa? Mou 'adoma'inia do'ia mo'o na heinagu moi 'anai ngau, nita? Me 'inau 'au awa bei'amou 'onaai inoni tatau'aro. ");
INSERT INTO aia_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“'I'amou bwane ura wetewete beiau suri'i madoraa bwara nau siri suri'i. ");
INSERT INTO aia_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","'Ia Amagu 'a haua tanaaui mena 'anai heimarungi, ma naasi 'inau wai haua ro'u o'asi tana'amou. ");
INSERT INTO aia_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Neina 'i'amou moi heinagu 'anai ngau mana gono na'i dora ngaungau na'i dora ni heimarungi agua, mamoi heinagu suri'i dora ni mwaeraha 'anai marungiraaui ta'i tangahuru mana rua burungai inoni nai Israel.” ");
INSERT INTO aia_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mia Jisas 'a o'ani 'inia Saemon Pita, “Saemon, Saemon, 'oisui rongo! 'Ia Saetan 'a ha'angonia God 'anai ohongi'amou 'anai 'iraraa tei 'ini'amou na wetewete i hinihinina. ");
INSERT INTO aia_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma'ata Saemon, 'au bwane ha'arahesi doni hinihinimu 'a bwa'i ai'aa ha'atai. Ma na'i 'oha na'oi rihota'i aho'i mai tanaau, 'oi ha'a-'o'oriraaui do'oramu'i 'ini marai wetewete ro'u suri'i hinihinidaa'i.” ");
INSERT INTO aia_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mia Pita 'a ha'atee o'ani, “Araha, 'inau 'au ha'aagau 'anai 'ari bei'o na'i rumaniho'o, ma 'anai mae bei'o.” ");
INSERT INTO aia_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mia Jisas 'a o'ani 'inia, “Wai 'unua tana'o Pita, na kua 'a bwa'i tataraoke mau na'i wa'aria, mi'oe 'oi bwane tohe ha'a-oru do'o ai'a 'iraraau.” ");
INSERT INTO aia_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mia Jisas 'a songa'iniraaui rongoiusuri o'ani, “'A 'ua? Na'i 'oha nau ha'ataari'amou hura'a ani nau 'unua domoi abui waiwai anga mana pwaosi mana sandol, ra'i mareho he'ua namou toho 'ini'i?” Miraau o'ani, “Ai'a ta mareho namei toho 'inia.” ");
INSERT INTO aia_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Magu o'ani 'iniraau, “Me na'i 'ohani 'iatei na to'o pwaosi 'ai waa, ma 'onaa 'o to'o anga ma'oi waa ro'u, 'onaa 'iatei na ai'a to'o naihi ni hei'oi, 'ai raonga'iniai to'oni ana mai horia tana naihi. ");
INSERT INTO aia_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","'Inia wai 'unua tana'amou: 'Ai to'o ha'a-momori mareho nara usua 'iniau na'i Usu-usu Maea na o'ani, ‘'Iia ra 'unugonia beiraaui inoni hehereta'a'i.’ Ha'amomori, ni mwane mareho na Usu-usu Maea na 'unu'i 'iniau, rai to'o ha'a-momori.” ");
INSERT INTO aia_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Miraaui rongoiusuri rau o'ani 'inia, “'Ome Araha, 'e rua naihi ni hei'oi naani.” Mia Jisas 'a o'ani, “'Io, 'a goro'a!” ");
INSERT INTO aia_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Mia Jisas 'a hura'a baaniai 'omaa ma ta'eha i hungahungai 'Oliv 'onaai bwane hahaa ana. Mana rongoiusuri ana'i 'iraau ro'u beia. ");
INSERT INTO aia_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mia Jisas 'agu o'ani 'iniraaui rongoiusuri ana'i, “Moi ha'arahesi neina moi abui ahoda na'i 'oha moi siri na'i heiohongi.” ");
INSERT INTO aia_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ma gere hano beira'i baaniraau. 'A topiruru auru ma ha'arahesi o'ani, ");
INSERT INTO aia_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ama, 'onaa 'ai suriai hei'irisimu, ma'oi abui wateau 'anai siri na'i rongomaata'ini. Me 'ai abu 'onaai 'irisia agua, ma'ata 'ai suriai hei'irisimu.” ");
INSERT INTO aia_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma'e enjel na diomai baaniai aro na ha'amaranga tanaa 'anai ha'a-wetewetea. ");
INSERT INTO aia_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Beiai ahutotou raha na'i tahingana, 'a ha'arahesi wetewete ro'u wou, mana mada'a na haua 'a 'onaai 'abu na udu dio na'i ano. ");
INSERT INTO aia_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","'A suruta'e ara'a 'oha na ha'arahesi hako, ma 'ari aho'i wou beiraaui rongoiusuri ana'i. Ma sadoia dorau mauru hako, suria rau rahe 'ini ahutotou raha adaau. ");
INSERT INTO aia_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Mia Jisas 'a o'ani 'iniraau, “'A 'ua namou mauru 'inia? Moi suruta'e mamoi ha'arahesi, neina moi abui ahoda na'i 'oha moi siri na'i heiohongi.” ");
INSERT INTO aia_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na'i 'oha na ha-hadahada mau, ma ataha'a mai kae ruruhai inoni. 'Ia Jiudas 'e ta'i 'iniraaui Ha'ataari ana'ia Jisas na na'otaradaau. Mia Jiudas 'a 'ariwou odo-odo beia Jisas 'anai ngoonia. ");
INSERT INTO aia_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mia Jisas 'a o'ani 'inia, “Jiudas, naia naasi here na'oi haa 'anai ha'ahaingahu 'iniau, 'inau i Garei Inoni?” ");
INSERT INTO aia_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na'i 'oha na 'iraaui rongoiusuri nara awa 'isi rau 'ome 'iraraai taha nai to'o, rau o'ani 'inia Jisas, “'A 'ua Araha, mei haa'i naihi?” ");
INSERT INTO aia_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma'e ta'i 'iniraau na rahiai naihi ana ma taba taahiai karinga odonai sae tatau'aro anai Na'ohadaaui Piriisi. ");
INSERT INTO aia_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mia Jisas 'a ha'atee o'ani, “Abu'a!” Ma dau wou na'i karinganai inoni tatau'arosi ma ha'agorohia aho'i. ");
INSERT INTO aia_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mia Jisas 'a o'ani 'iniraaui Na'ohadaa'i Piriisi miraaui sae hehei'oi nara 'omesuriai Ruma Maea ana God, miraaui hakoi saemaua narau boi 'ana Jisas, “'A 'ua? Mou 'adoma'inia do 'inau 'e sae hehere ta'aa namou boi 'inia bei'i naihi mana hasi'ei 'anai heingahu 'anai dauau? ");
INSERT INTO aia_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","'Ado dangi 'au awa bei'amou na'i Ruma Maea ana God mamou ai'a raba dauau. Ma'ata naani 'oha na mena anai adaro 'a marungi'amou. Moi hauai taha namou 'adoma'inia.” ");
INSERT INTO aia_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Miraau na hehei'oi rau daua Jisas mara waia 'ari na'i ruma anai Na'ohadaaui Piriisi. Mia Pita 'a susuriraau ha'atau moi. ");
INSERT INTO aia_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na'i 'oha narau taha wou, 'e 'eu ni waari'u nara togaa na'i 'ubutanai dora a'ora hura'a i abau 'omaa anai rumasi. Miraau heinagu totoa 'anai waari'u, mia Pita ro'u beiraau. ");
INSERT INTO aia_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ma'e gere urao na tatau'aro na'isi 'a 'ome 'iraraa Pita ma wana wetewete 'inia. 'A o'ani, “'Ia mo'oni 'au re'ia ro'u beia Jisas.” ");
INSERT INTO aia_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mia Pita 'a tohea, 'a o'ani, “Gere urao, 'inau ai'a 'iraraa mo'osi.” ");
INSERT INTO aia_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ai'a orea mau ma'e ta'i abe 'iniraau na 'ome 'iraraa ro'u, 'a o'ani 'inia, “I'oe 'e ta'i 'iniraau ro'u i rongoiusuri ana'i.” Mia Pita 'a o'ani 'inia, “'Ei mwane, 'inau 'au ai'a.” ");
INSERT INTO aia_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","'A ga'i 'onaai ta'i 'aoa ro'u moi na'i muri ma'e ta'i nei 'iniraau na ha'atee wetewete o'ani ro'u 'inia, “Ha'amomori di'u, 'ia mo'oni 'e ta'i ro'u 'iniraau, 'inia 'iaani 'e ai Galili.” ");
INSERT INTO aia_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mia Pita 'a ha'atee o'ani, “Ai'a ha'a-momori moe'a i maho na 'o 'unuasi.” Na'i 'oha na ha-hadahada mau, na kua 'a tataraoke. ");
INSERT INTO aia_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mia Jisas 'a rihota'i ma wana wetewete 'inia Pita. Mia Pita 'agu 'adoma'i aho'isiai maho na 'ia Jisas 'a 'unua tanaa na o'ani, “'A bwa'i tataraoke mau i kua na'i wa'aria, mi'oe 'oi bwane tohe ha'a-oru do'o ai'a 'iraraau.” ");
INSERT INTO aia_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Maagu hura'a na'i maanai bara anai rumasi ma ru'uhiai angi. ");
INSERT INTO aia_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Miraaui nei narau awa beia Jisas 'anai 'omesuria, ra haikou 'inia. Ra hidaria mara rubu'ia 'ini'i rimadaa'i. ");
INSERT INTO aia_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Rau hiri ha'abwarasiai maana 'iniai bwana marau hidaria maragu o'ani 'inia, “'Oi 'unua 'iatei na ngahui'o! 'Inia i'oe 'e rarabea, nita?” ");
INSERT INTO aia_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Miraau 'unu'i ro'u i mwane mareho ta'a'i 'ana Jisas 'anai here ha'ata'aia. ");
INSERT INTO aia_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na'i haho'oa ta'aa, 'iraaui saemaua beiraaui Ha'ausuri 'anai Ringe ana'ia Moses mana Na'ohadaa'i Piriisi rau goni na'i ta'i dora. Naasi ruruha nara 'unuraau 'iniai Kansol. Maragu waia Jisas mai tanaraau. ");
INSERT INTO aia_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Miraaugu o'ani 'inia, “'Oi 'unua tana'ameu: 'A 'ua? I'oe naasi Ha'atahi?” Magu aramiraau o'ani, “Rei'uaa nawai 'unua tana'amou, mamou bwa'i hinihini, ");
INSERT INTO aia_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ma 'onaa nawai songa'ini'amou, mamou bwa'i matai aramiau ro'u. ");
INSERT INTO aia_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma na'i 'ohani ma 'ari'a, na Garei Inoni 'ai heinagu na'i dora ororiu na'i odona God huunai mena.” ");
INSERT INTO aia_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Miraaugu songa'inia ro'u o'ani, “'A 'ua? I'oe naasi garena God?” Miagu aramiraau o'ani, “Naia namou 'unua'asi.” ");
INSERT INTO aia_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Naasi maraugu o'ani 'iniraau haariraau, “'A goro'a! Gaugu bwa'i bonasiai sibania'a ro'u tanei 'anai 'unua ta mareho 'anai subunia 'inia. 'Inia 'igaau haarigaau gau rongoa'a i 'unua ana do'iia naasi garena God!” ");
INSERT INTO aia_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Miraau hakoi ruruha rau suruta'e ara'a marau waia Jisas 'ari tanaai Primia, 'ia Paelat, do'ai hiiria. ");
INSERT INTO aia_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Miraaugu taraawa'a ha'ahunia 'ini'i mareho, rau o'ani, “'Ia mo'osi meu sadoia do'a na'otaradaaui inoni 'anai ura bwarasiai Gaumani anai Rom. Ma 'unua ro'u tanaraau dorai abui hori takisi tanaai Mwaeraha, ma 'unua do'iia naasi mwaeraha mana Ha'atahi.” ");
INSERT INTO aia_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mia Paelat 'agu songa'inia Jisas o'ani, “'A 'ua? I'oe naasi Mwaeraha adaaui Jiu?” Mia Jisas 'a aramia o'ani, “Naia na'o 'unuasi.” ");
INSERT INTO aia_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mia Paelat 'a rihota'i ma o'ani 'iniraaui Na'ohadaa'i Piriisi mana ruruha nara boi 'anai bahurongo, “Ai'a ta mareho wai to'oana beia mo'oni na do'ai horosia 'inia ta ringe.” ");
INSERT INTO aia_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Miraaugu ha'atee wetewete ro'u ara'a o'ani, “'Ia mo'osi 'a ha'a awata'airaaui inoni suri'i mwane dora hako na'i Jiudea 'ini'i ha'ausuringa'i ana'isi. 'A taraawa'a na'i Provensi Galili, nagu buna boi tari 'ini beigaau.” ");
INSERT INTO aia_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Na'i 'oha na 'ia Paelat 'a rongoa do 'a taraawa'a na'i Galili, 'agu songa'iniraau ro'u o'ani, “'A 'ua? 'Ia mo'osi 'e ai Galili?” ");
INSERT INTO aia_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Miraau aramia do'ia Jisas baaniai Galili. Na'i 'oha na 'iraraa o'asi do'ia Jisas 'a boi baaniai aba na heimarungi ieia Herod, 'agu ha'ataaria 'ari tanaa Herod. Na'i madoraasi 'ia Herod 'a awa ro'u 'isi na'i Jerusalem. ");
INSERT INTO aia_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","'Ia Herod 'a rongo tarohana Jisas mau mai orea magu kaeni raba 'omesia. Ma raba 'omesia ro'u 'oha na 'ia Jisas 'ai hau'i tara'i ha'abu'oahu. Naasi na'i 'oha na 'ia Paelat 'a ha'ataaria woua Jisas tanaa, 'a kaeni wa'ewa'e di'u. ");
INSERT INTO aia_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","'A hau'i mwane heisonga'i tanaa Jisas, mia Jisas 'a ai'a raba arami'i. ");
INSERT INTO aia_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Miraaui Na'ohadaa'i Piriisi mana Ha'ausuri 'anai Ringe ana'ia Moses, rau ura gaarangi marau ha'ahunia wetewete a Jisas 'ini'i mwane mareho ta'a'i. ");
INSERT INTO aia_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mia Herod miraaui sae hehei'oi ana'i rau heiheia marau haikou 'inia. Rau ha'ato'onia Jisas 'onaai mwaeraha 'iniai to'oni tewa 'ome goro, maraugu ha'ataaria aho'i 'ari tanaa Paelat. ");
INSERT INTO aia_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Taraawa'a mau mai, 'ia Paelat mia Herod raru ha'imae hairiu, tari mai na'i madoraa nagu to'o i marehosi, ma rarugu haguhagu goro'a. ");
INSERT INTO aia_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mia Paelat 'a 'unuraau goni Na'ohadaa'i Piriisi, 'iraaui saemaua adaa'i Jiu miraaui inoni, ");
INSERT INTO aia_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ma o'ani 'iniraau, “'I'amou mou waia mai a mo'oni mamou 'unua do'a na'otaradaaui inoni 'anai ura bwarasiai Gaumani anai Rom. Hoita, minau 'au songa'i hegahegaa na'i maamoou hako ma ai'a ta ta'i maho 'ini'i mareho namou subunia 'ini'i nawai to'oana beia. ");
INSERT INTO aia_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","'Ia Herod ma 'unua ro'u do 'a ai'a to'oana ta mareho taritari'a beia, tarana naasi na ha'ataaria aho'i 'inia mai. Ai'a ta mareho na 'ia mo'oni nai haua na ta'isada do'ai mae 'inia. ");
INSERT INTO aia_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tarana naasi wai 'unua tanaraaui sae hehei'oi marai rohoa, mawai ha'ahura'ahia dadara'a.” ");
INSERT INTO aia_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","'E ringe na awa do na'i 'ado 'oha nara ha'ato'oai Rongo ni Roho Aharau, 'iraaui inoni rau matai ha'angonia Paelat anai ha'ahura'ahia baaniai rumaniho'o tanei na 'iraau rai rabasia. ");
INSERT INTO aia_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Miraau hakoi inoni raugu totoro aratara o'ani, “Ngahu ha'amaesia mo'osi! 'Ia Barabas nameu 'irisia do'oi ha'ahura'ahia baaniai rumaniho'o!” ");
INSERT INTO aia_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","'Ia Barabas 'e sae ra gaasia na'i rumaniho'o 'iniai taraawa'ana ana i ha'agogoru na'i Jerusalem, ma 'ini ngahu ha'amaesiai sae. ");
INSERT INTO aia_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","'Ia Paelat 'a 'unua ro'u tanaraau do'ai ha'ahura'ahia Jisas. ");
INSERT INTO aia_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Miraau hako rau totoro aho'i tanaa Paelat o'ani, “Rabu ahita'inia na'i dadaahoro! Rabu ahita'inia na'i dadaahoro!” ");
INSERT INTO aia_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mia Paelat 'a o'ani 'iniraau, “'Iniai 'uaana? 'E 'ino he'ua na haa? 'Inau ai'a to'oana ta mareho nai haua na ta'isada do'ai mae 'inia! Wai 'unua tanaraaui sae hehei'oi marai rohoa, mawai ha'ahura'ahia dadara'a.” Naasi orunai 'oha na 'ia Paelat 'a ha'atee o'asi. ");
INSERT INTO aia_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Miraaugu totoro raha ara'a ro'u baaniai na'o dorai rabu ahita'inia ma'ata Jisas na'i dadaahoro. 'Ariwou naraugu buna ha'ahehoa Paelat. ");
INSERT INTO aia_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Naasi 'ia Paelat 'agu 'adoma'i aratara beiraau. ");
INSERT INTO aia_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","'A ha'ahura'ahia Barabas 'onaai 'irisia adaau, 'ia mo'o nara gaasia ani na'i rumaniho'o 'iniai heingahu ma 'iniai ha'ato'oa na haa i ha'agogoru na'i Jerusalem. Ma watea Jisas tanaraau 'anai haua tanaa i maho narau 'irisiasi. ");
INSERT INTO aia_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na'i 'oha na 'iraau hehei'oi rau waia Jisas, rau 'ariwou marau heisadoi beiai ai Saerin na atana 'ia Saemon. 'Agu boi baaniai dora na gere ha'atau baaniai 'omaasi ma riutaha mai ro'u na'i tarasi. 'Iraau hehei'oi rau ha'a-'usu'usua do'ai suru'iai dadaahoro, mai suria Jisas. ");
INSERT INTO aia_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","'E kae ruruha raha narau surisuria Jisas. Ma na'i ruruhasi tara'i urao nara ahutotou 'inia Jisas. Rau ago-ago marau angi hahano. ");
INSERT INTO aia_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mia Jisas 'a rihota'i, ma ha'atee o'ani 'iniraau, “Mwane urao ni Jerusalem, mou abui angisiau. Moi angisi'amou haari'amou miraaui gare amoo'i. ");
INSERT INTO aia_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","'Inia 'e madoraa nai boi mau narai o'ani, ‘Ha'amwaniraau di'u i urao nara 'amara, mana nei nara ai'a to'ora gare mara ai'a matai ha'asusu gare.’ ");
INSERT INTO aia_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Na'i 'ohasi na inoni hako rai totoro, marai o'ani 'ini'i hungahunga mana bo'obo'o, ‘Moi ahoda auru hunimeeu, mamoi anoiameu!’ ");
INSERT INTO aia_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hoita, 'onaa narau here 'oniau, 'aigui he'ua tana'amou? 'Inia 'onaa ni 'eu 'ai noro ha'ata'aiai hasi'ei mamarewa'a, 'ai noro ha'ata'aia ro'u wou i hasi'ei na maria!” ");
INSERT INTO aia_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ma'e rua inoni hehere ta'aa nara wairarua ro'u 'anai ha'amaesirarua beia Jisas. ");
INSERT INTO aia_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na'i 'oha narau ataha wou na'i dora ra 'unua 'iniai Korai Bwau Sae raugu rabu ahita'inia ieia Jisas na'i dadaahoro, beiraruai rua inoni hehere ta'aasi. 'E ta'i na'i dadaahoro na'i odona, mana nata abe na'i dadaahoro na'i mahana. ");
INSERT INTO aia_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mia Jisas 'a ha'atee o'ani, “Ama, 'oi 'adoma'i nugasiai maho ra haua tanaauni, 'inia rau ai'a aidangisiai taha narau haua.” Miraaui sae hehei'oi rau gaasi ha'ara 'anai sadoia tei nai to'ora'i to'oni ana'i. ");
INSERT INTO aia_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","'Iraau inoni rau ura maraugu boresuria, miraaui saemaua adaa'i Jiu rau haikou 'inia. Rau o'ani, “'Iia na ha'atahi'i tara'i sae he'ete'i ani. Nugaa mai ha'atahia haaria 'onaa 'iia naasi Ha'atahi na 'ia God na 'ome sigihia!” ");
INSERT INTO aia_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Miraaui hehei'oi rau haikou ro'u 'inia. Rau haua tanaai waen mahai, ");
INSERT INTO aia_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","marau o'ani 'inia, “'Onaa i'oe naasi Mwaeraha adaaui Jiu, ma'oi ha'atahi'o haari'o.” ");
INSERT INTO aia_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mara usuai usu-usu na'i baba ma rau nugaa na'i bwaunai dadaahoro. Rau usua o'ani: ");
INSERT INTO aia_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ma'e ta'i 'iniraruai rua inoni hehere ta'aasi na ha'atee ha'ata'aia Jisas 'a o'ani, “'Onaa i'oe naasi Ha'atahi, ma'oi ha'atahigaau!” ");
INSERT INTO aia_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mana nata abe 'a ha'atee wetewete tanaa mo'osi, 'a o'ani, “'Ei. 'O ga'i ha'ahoua God, 'iniai mae amua ro'u 'onaaia mo'osi! ");
INSERT INTO aia_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","'Igaraa 'a arari do garai mae, suria 'igaraa ra'i sae hehereta'a'i. Mia mo'oni, ai'a ta ta'i mareho nai ha'atari'aa.” ");
INSERT INTO aia_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","'A ha'atee o'asi hako magu o'ani 'inia Jisas, “Jisas, 'oi 'adoma'iniau na'i 'oha 'oi mwaeraha!” ");
INSERT INTO aia_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mia Jisas 'a ha'atee o'ani 'inia, “Wai 'unua tana'o, de'eni 'oi awa beiau na'i paradaes.” ");
INSERT INTO aia_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ma na'i angi ta'i tangahuru mana rua na'i dangisi, 'a kuhi bwarasiai kantri hako tari na'i angi oru. ");
INSERT INTO aia_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","'Inia na sina 'a ai'a rara. Mana kae bwana ubu-ubu'a nara rohe bwarasia 'iniai dora maea na'i Ruma Maea ana God, 'a maakari heihoa. ");
INSERT INTO aia_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mia Jisas 'a totoro 'ini ringe raha o'ani, “Ama, na'i rimamu 'au nugaai tahingagu!” 'A ha'atee o'asi hako magu mae. ");
INSERT INTO aia_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na'i 'oha na na'ohadaaui hehei'oi 'a 'omesi'i mareho 'isi, 'a ha'aasaa God ma o'ani, “Ha'amomori, 'ia mo'oni 'e inoni odo-odo!” ");
INSERT INTO aia_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Miraaui inoni nara goni wou na'i 'isi narau 'omesi'i taha nara to'o na'i madoraasi, rau hida suri'i waiburudaa'i 'iniai ahutotou, marau aho'i 'ari suri'i ruma adaa'i. ");
INSERT INTO aia_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Me 'iraau hakoi nei narau hei'irara'i goro beia Jisas, goni bei'i urao narau ta'i boi beia baaniai Galili, rau ura ha'atau moi marau 'omesi'i 'ari taha nara to'o na'i 'ohasi. ");
INSERT INTO aia_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ma'e ta'i sae na awa na'i Kansol na atana 'ia Josep. 'Iia 'e saeni 'Arimatea, 'e 'omaa na'i Jiudea. 'Ia Josep 'e sae goro ma odo-odo, me 'iia 'a totoriai 'oha na 'ia God 'ai boi na'i marewana 'anai marungiraaui inoni. Mia Josep 'a ai'a 'adoma'i aratara beiraaui Kansol 'iniai mareho narau haua tanaa Jisas. ");
INSERT INTO aia_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","'Iia 'a ada beia Paelat ma ha'angoniai abena Jisas. ");
INSERT INTO aia_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","'A rahia dioi abena Jisas, ma ho'ua 'iniai bwana mamaahui. 'A aoraa na'i wabwa nara 'eria na'i abenai kae hau. Ma na'i wabwasi, 'a ai'a ta sae mau narai toringia iei. ");
INSERT INTO aia_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ni dangisi 'e rimanai dangi. Naasi dangi na 'iraaui Jiu ra ha'aagau 'anai dangi ni mamaro adaau, 'inia 'aigui taraawa'a na'i su'urahi. ");
INSERT INTO aia_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Miraaui urao narau ta'i boi beia Jisas baaniai Galili, rau suria Josep. Rau 'omesiai wabwasi, marau 'omesiai nuga ra haa 'anai abena Jisas na'iei. ");
INSERT INTO aia_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Maraugu aho'i 'ari 'omaa 'anai ha'aagau'i tara'i rumu si'ini goro 'anai roga'i na'i abena Jisas. Ma na'i dangi ni mamaro rau mamaro 'anai suriai taha na Ha'atora na 'unua. ");
INSERT INTO aia_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na'i wa'aria i dangi sade, 'iraaui mwani urao 'ani rau ho'orai 'ari wabwa bei'i rumu si'ini goro narau bwane ha'aagauhi'i. ");
INSERT INTO aia_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na'i 'oha narau ataha wou, rau 'omesia dona hau nara ha'abwarasia 'iniai maanai wabwa ra bwane burusia beira'i. ");
INSERT INTO aia_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Na'i 'oha naraugu siri wou, maraugu ai'a 'omesia'ai abena Araha Jisas. ");
INSERT INTO aia_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma na'i 'oha narau wai'ado'ado mau suriai marehosi, raugu 'asu'a ma'e rua enjel nararu siri suri'i to'oni mamaahui wadowado raru ura na'i bobodaau. ");
INSERT INTO aia_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na'i 'ohasi, rau mamaa'u di'u marau topira'i ruru marau mwaoro dio aurui ano. Mana enjel raru o'ani, “'A 'ua namou sibania 'inia na'i dora ni mae, 'ia mo'o na tahi'a aho'i? ");
INSERT INTO aia_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","'Iia 'a ai'a awa 'ini. 'Iia 'a suruta'e aho'i baaniai mae. Moi 'adoma'inia aho'i taha na maania tana'amou na'i 'oha na awa bei'amou na'i Galili. 'A 'unua do ");
INSERT INTO aia_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","na Garei Inoni rai watea tanaraaui inoni ora-ora'a 'anai rabu ahita'inia na'i dadaahoro, ma na'i orunai dangi murinai mae na haa, 'ai suruta'e aho'i baaniai mae.” ");
INSERT INTO aia_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na'i 'ohasi, na urao 'isi raugu 'adoma'ini'i aho'i ha'atee 'isi. ");
INSERT INTO aia_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Rau aho'i 'ari baaniai wabwa, ma rau maani'i mwane mareho 'isi tanaraaui ta'i tangahuru mana ta'i Ha'ataari, mei tanaraau ro'u i haru nei. ");
INSERT INTO aia_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mana atadaa'i urao narau 'ari heitaroha'i tanaraaui Ha'ataari, 'ia Meri ni Magdala, 'ia Joana, mia Meri inana Jems, ma tara'i urao ro'u. ");
INSERT INTO aia_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Na'i 'oha na 'iraaui Ha'ataari rau rongo, rau ai'a hinihiniraau 'inia rau 'adoma'inia dora'i mamaani to'obweubweu'a moi. ");
INSERT INTO aia_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mia Pita 'a suruta'e ma 'eba 'ari wabwa. Na'i 'oha na mwaoro 'anai wana siri, 'a 'omesia doni bwana moi nara ho'ua 'iniai abena Jisas naragu awa. 'Oha na 'omesia o'asi, 'a aho'i 'ari 'omaa ma wai'ado'ado suriai mareho na to'osi. ");
INSERT INTO aia_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mau na'i dangisi 'e rua rongoiusuri ana Jisas nararu auru 'anai 'omaai Emeas, mana ha'atau na hauai 'omaasi baaniai Jerusalem 'a ga'i 'onaai ta'i tangahuru mana ta'i kilomita. ");
INSERT INTO aia_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","'Oha nararu auru wou, raru maani'i hahano i mareho nara to'o 'isi. ");
INSERT INTO aia_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na'i 'oha nararu ma-mamaani mau, 'ia Jisas 'a 'ariwou gaarangirarua ma hano beirarua. ");
INSERT INTO aia_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ma'ata 'ia God 'a ha'abwaraa tanararua 'anai 'ome 'iraraa Jisas. ");
INSERT INTO aia_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mia songa'inirarua o'ani, “'E taha namuru maania mai suriai tarasi?” Miraru ura sua ha'i 'ome ahutotou'a. ");
INSERT INTO aia_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma'e ta'i 'inirarua na atana 'ia Kleopas na o'ani, “Gasi i'oe moi naasi ta'i sae na boi na'i Jerusalem na'o ai'a 'irara'i kae mareho nara to'o suri'i dangi nara hako'a 'ani.” ");
INSERT INTO aia_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mia Jisas 'a o'ani, “Mareho he'ua?” Miraru aramia o'ani, “Here nara haua 'ana Jisas ni Nasaret! 'Iia 'e Rarabea, mana ha'atee ana'i mana mwane mareho na hau'i ra mena di'u na'i maadaaui inoni ma na'i maana God. ");
INSERT INTO aia_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Me 'iraaui Na'ohadaa'i Piriisi miraaui saemaua agaa'i rau daua marau haua tanaai Gaumani 'anai Rom dorai hiiria 'anai ha'amaesia. Ma rau rabu ahita'inia na'i dadaahoro. ");
INSERT INTO aia_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","'I'ameu meu 'adoma'inia do 'iia naasi Ha'atahi na ga'i boi 'anai ha'atahiraaui Israel baaniraaui maeronga. Mana nata mareho ro'u na ai'a goro, naani'a i orunai dangi murinai to'o na hauai marehosi. ");
INSERT INTO aia_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mameu ta'i kaeni heimwaota'i 'iniai mareho narau maania i urao narau awa na'i ruruha ameeu. Nade'eni wa'aria rau 'ari wabwa nara nugaa iei a Jisas. ");
INSERT INTO aia_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ma na'i 'oha narau ataha wou na'i wabwasi, rau sadoia do ni abena Jisas 'a bwane ai'aa baaniai dora nara nugaa iei. Marau 'unua dora'i enjel narau re'i'i, nara 'unua tanaraau do'ia Jisas 'a tahi aho'i! ");
INSERT INTO aia_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","'Ariwou ma tara'i abe ro'u na'i ruruha ameeu, rau 'ari ro'u na'i muri marau 'omesia do ni abena Jisas 'a bwane ai'aa 'onaai 'unua nara haa i urao 'isi.” ");
INSERT INTO aia_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mia Jisas 'agu o'ani 'inirarua, “Muru bweu, ma muru ai'a raurau 'anai hinihini'i taha na 'iraaui rarabea ra 'unu'i! ");
INSERT INTO aia_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","'A 'ua? Muru ai'a aidangisia do na Ha'atahi 'ai mamaa'a ga'u, maigui heimarungi ara'ai aro beiai mena na raha?” ");
INSERT INTO aia_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mia Jisas 'a hadanga'i ha'agorohi'i tanararuai taha nara usu'i 'abaia na'i Usu-usu Maea. 'A taraawa'a bei'i buka na usu'ia Moses tari bei'i buka adaa'i Rarabea. ");
INSERT INTO aia_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na'i 'oha narau 'ariwou ada na'i 'omaa na 'iraruai rua mwanesi raru hano 'ana, 'ia Jisas 'a 'ome 'onaa do'ai hano daara'i. ");
INSERT INTO aia_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Miraru bonga'inia wetewete, raru o'ani 'inia, “'Ei, 'a su'urahi'a, gai mauru ga'u moi.” Miagu surirarua 'anai mauru beirarua. ");
INSERT INTO aia_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Na'i 'oha narau ha'aagau 'anai ngau, 'ia Jisas 'a rahiai bredi, ma ha'atee ha'agorohia God 'inia. 'A uubia ma ha'atora'inia tanararua. ");
INSERT INTO aia_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Na'i 'ohasi 'ia God 'agu ha'awatea dorarui aidangisia do 'ia Jisas ma rarugu 'ome 'iraraa'a. Mia Jisas 'a hasi ai'aa baanirarua moi na'i 'ohasi. ");
INSERT INTO aia_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Naasi mararu o'asi 'inirarua hairiu, “Na'i 'oha na 'unu tahanga'ini'i tanagaraai mareho nara usua na'i Usu-usu Maea 'oha gau boi suri tara ani, 'a 'onaai 'eu na noro suri'i tahingagara'i.” ");
INSERT INTO aia_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Raru suruta'e mau 'ohasi, mararu aho'i 'ari Jerusalem. Raru 'ariwou mararu sadoiraaui ta'i tangahuru mana waira ta'i rongoiusuri ana Jisas beiraau ro'u tara'i nei nara goni wou beiraau. ");
INSERT INTO aia_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Miraau o'ani 'inirarua, “Ha'amomori! 'Ia Araha 'a suruta'e aho'i baaniai mae ma ha'ata'i tanaa Pita.” ");
INSERT INTO aia_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mirarua maania ro'u tanaraaui taha na to'o na'i tara 'oha nararu hano 'anai Emeas, mararu maania ro'u tanaraaui 'oha nararugu 'ome 'iraraa do'ia Jisas 'oha na uubia tanararua i bredi. ");
INSERT INTO aia_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Raugu 'asu'a 'oha nararu ma-mamaani mau, mia Jisas 'a ura beiraau na'i 'ubutadaau ma o'ani 'iniraau, “Na gorohana God 'ai awa bei'amou.” ");
INSERT INTO aia_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Na'i 'ohasi rau kaeni 'asu'a marau mamaa'u, suria rau 'adoma'inia do'e anoa. ");
INSERT INTO aia_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mia o'ani 'iniraau, “'A 'ua mou mamaa'u mana 'adoma'imoo'i ra heiruarua'a? ");
INSERT INTO aia_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","'Inau moina, moisu 'omesiai rimagu'i mana uwagu'i. Moi hatariau, mamoi 'iraraa do 'inau ha'a-momori, 'inia na anoa ra ai'a to'o abe mana surisuri 'onaaiauni.” ");
INSERT INTO aia_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Maagu ha'ata'ini'i tanaraaui rimana'i mana uwana'i. ");
INSERT INTO aia_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Miraau kae wa'ewa'e di'u, ma'ata beia mau i 'adoma'i heiruarua'a. 'Ia Jisas 'a 'iraraa o'asi, magu o'ani, “'E mahoingau matota na bei'amou?” ");
INSERT INTO aia_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Marau o'ani, “'Io.” Marau taranga'inia tanaai dorai ii'a matota. ");
INSERT INTO aia_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mia Jisas 'a rahia ma ngaa na'i maadaau hako. ");
INSERT INTO aia_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ma o'ani 'iniraau, “Ni mareho na to'o tanaausi, 'au bwane 'unua mau na'i 'oha nau awa bei'amou doni mwane mareho nara usu'i 'iniau suri'i buka ana'ia Moses, mei suri'i buka adaa'i rarabea, ma na'i buka ni Psalm, rai to'o hako ma'ata.” ");
INSERT INTO aia_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Miagu tahangi'i 'adoma'idaa'i dorai aidangisi'i goro i usu-usu na'i Usu-usu Maea. ");
INSERT INTO aia_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","'A o'ani, “Naani mareho na Usu-usu Maea 'a 'unua 'iniau. Ni Ha'atahi 'ai rongomaata'i maai mae. Ma 'e rua dangi nai hako mana'i oruna 'ai suruta'e aho'i baaniai mae. ");
INSERT INTO aia_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma na'i atagu, rai taroha'inia do'ia God 'ai 'adoma'i nugasi'i 'inodaa'i nei narau rihosi baani'i ora-ora'a adaa'i. Rai taraawa'a heitaroha'i na'i Jerusalem marai 'adarara 'ari suri'i 'ado marau na'i marewana hako. ");
INSERT INTO aia_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","'I'amou namoi hura'a taroha'ini'i mareho 'isi tanaraaui inoni suria 'i'amou namou re'i'i. ");
INSERT INTO aia_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“'Inau waigui ha'ataaria mai tana'amoui nei na 'ia Amagu 'a duruduru 'inia do'ai ha'ataaria tana'amou. Naasi moi awa hatara'i 'ini na'i Jerusalem, tari 'oha na Hi'ona Maea 'ai diomai hungamoou mamoi honu 'iniai mena na boi baaniai aro.” ");
INSERT INTO aia_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","'Ia Jisas 'a wairaau hura'a baaniai Jerusalem marau 'ari Betani. Mia Jisas 'a taranga'ini'i ara'ai rimana'i ma ha'agorohiraau. ");
INSERT INTO aia_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Na'i 'oha na ha'agorohiraau mau, 'ia God 'a waia baaniraau ara'ai aro. ");
INSERT INTO aia_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na'i 'ohasi, rau taraawa'ai ha'arahesia. Marau aho'i 'ari Jerusalem beiai wa'ewa'e na raha di'u. ");
INSERT INTO aia_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","'Ado dangi rau siri awa na'i Ruma Maea 'anai ha'a-aneanea God. ");
INSERT INTO aia_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na'i taraawa'ana maragu pwa'ara i mwani mareho, ni Ha'atee 'a bwani awa'a. 'Iia 'a awa beia God, me 'iia naasi God. ");
INSERT INTO aia_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Na'i na'o maragu pwa'ara i mwani mareho, 'iia 'a bwani awa beia God. ");
INSERT INTO aia_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","'Ia God 'a hauai Ha'atee 'anai ha'apwa'ara'i mwane mareho hako. Ha'amomori, 'ia God 'a ha'apwa'ara'i mwane mareho hako 'iniai Ha'atee naasi. ");
INSERT INTO aia_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na huunai tahi 'a hura'a mai na'i Ha'atee naasi, mana tahi naasi 'e bewaa tanaraaui mwani noni. ");
INSERT INTO aia_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na bewaasi 'a marewa na'i kuhi, mana kuhi 'a bwa'i matai ha'a-ai'aa mwada'u. ");
INSERT INTO aia_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","'Ia God 'a ha'ataaria maia Jon Bwareomaea 'onaai noni heheitaroha'i ana, ");
INSERT INTO aia_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","'anai taroha'iniai bewaasi tanaraaui sae do neina rai rongo marai hinihini. ");
INSERT INTO aia_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ai'a do 'iia Jon naasi bewaa, ma'ata 'iia 'a boi 'anai ha'arangasia hura'ai bewaa naasi. ");
INSERT INTO aia_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na bewaasi, naasi huunai bewaa na boi na'i marewana anai bewaasiraau hakoi noni nai marewanani. ");
INSERT INTO aia_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ni Ha'ateesi 'a awa na'i marewana, ma rei'uaa na 'ia God na ha'apwa'araai marewana 'iniai Ha'ateesi, ma'ata 'iraaui noni nai marewana rau ai'a 'ome 'iraraa do 'iia naasi Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","'A boi beiraaui noni ana'i, 'iraaui ai Jiu, miraau inoni ana'i rau ai'a ha'amaotoa. ");
INSERT INTO aia_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mei tanaraaui nei narau ha'amaotoa marau hinihinia, 'iraau rau ha'i arai gare ana'ia God. ");
INSERT INTO aia_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ai'a dorau huta 'onaai hutahuta adai noni, ma'ua suriai 'adoma'inai noni. Ma'ata rau huta haoru 'onaai gare ana'ia God suriai 'adoma'ina. ");
INSERT INTO aia_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na Ha'ateesi 'a ha'i noni, ma awa na'i 'uruhagaau na'i marewanani. 'Iia 'a honu 'iniai heita'ahi mana mwane mareho na 'unu'i ra ha'a-momori hako. Meu 'omesiai mena ana mana gorohana, 'inia 'iia naasi ta'i gare otohuu ana God. ");
INSERT INTO aia_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","'Ia Jon 'a ha'arangasia hura'a tanaraaui noni na'i 'oha na totoro o'ani, “Naani'a a mo'o nau bwane 'unua tana'amou ga'u na'i 'oha nau o'ani ani, ‘'Iia 'ai boi na'i murigu, ma'ata 'iia 'a ororiu di'uau, 'inia 'iia 'a bwani awa maugu huta.’” ");
INSERT INTO aia_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ni Ha'ateesi 'a ha'agorohigia ma bane waiori tanagia, 'inia 'iia 'a honu 'iniai heita'ahi. ");
INSERT INTO aia_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","'Ia Moses 'a waa'i mai ringe ana'ia God tanaraaui noni, ma'ata ni heita'ahi mana ha'a-momori 'a boi baania Jisas Kraest. ");
INSERT INTO aia_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ai'a tanei nai 'omesia God. Ma'ata na garena otohuu na awa beia ma 'iia haaria 'e God, na ha'ata'inia tanagia 'a he'uai barongana God. ");
INSERT INTO aia_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","'E ta'i 'oha 'iraaui saemaua adaa'i Jiu na'i Jerusalem rau ha'a-taariraaui Piriisi ma tara'i sae ro'u nara 'a'auhiraaui Piriisi 'anai songa'inia Jon 'onaa 'iia naasi Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mia Jon 'a tohe ma o'ani, “'Inau ai'a Ha'atahi.” ");
INSERT INTO aia_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Miraaugu o'ani 'inia, “Me i'oe atei, 'ia Elaija?” Mia aramiraau o'ani, “'Inau ai'a.” Miraaugu o'ani ro'u 'inia, “Mi'oea teita? I'oe naasi Rarabea nameu mamasia?” Mia o'ani 'iniraau, “'Inau ai'a.” ");
INSERT INTO aia_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Miraaugu ha'atee o'ani 'inia, “'Oi 'unua tana'ameu, i'oe 'iatei? Mamei 'unua tanaraaui mwane narau ha'ataari'ameu maini. 'E taha na'oi 'unu'o 'ini'o haari'o?” ");
INSERT INTO aia_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mia Jon 'a aramiraau 'ini'i ha'atee ana'ia rarabea Aisaea. 'A o'ani, “'Inau nei na totoro na'i dora mangasara o'ani. Moi ha'aagau! 'Ia Araha 'a gaarangi boi'a. Moi ha'a-odoodoai tara tanaa!” ");
INSERT INTO aia_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Miraaui nei na 'iraau Farisei rau ha'a-taariraau mai raugu songa'inia ro'u a Jon o'ani, “'Onaa i'oe ai'a naasi Ha'atahi, ma'ua ai'a Elaija, ma'ua ni Rarabea nameu mamasia, ma 'iatei na 'unua tana'o 'anai bwareomaearaaui noni?” ");
INSERT INTO aia_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mia Jon 'a aramiraau o'ani, “'Inau 'au bwareomaearaaui noni 'iniai wai. Ma'ata 'e nei namou ai'a 'iraraa na awa beigaau 'ini na'i 'ohani. ");
INSERT INTO aia_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","'Iia 'a boi na'i murigu, ma'ata 'inau 'au ai'a arari ro'u do 'anai mwaoro auru 'anai wagasi'i sandol ana'i.” ");
INSERT INTO aia_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na marehosi 'a to'o na'i dora nara 'unua 'iniai Betani, na'i nata batarau 'iniai wai raha Jodan, dora na 'ia Jon 'a bwa-bwareomaearaau iei sae. ");
INSERT INTO aia_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na'i dangi ahora 'ia Jon 'a 'omesiai boi ana Jisas ma ha'atee o'ani, “'Ome, naasi garei siip ana God na wai'i beira'i 'inodai noni nai marewana. ");
INSERT INTO aia_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Naasia mo'o nau 'unua na'i 'oha nau ha'atee o'ani, ‘'E nei nai boi mau na'i muri, 'a ororiu di'uau, 'inia 'iia 'a bwani awa, maugu huta mai.’ ");
INSERT INTO aia_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na'i na'o, nau ai'a 'iraraa 'iatei, ma'ata 'inau 'au bwareomaearaaui saenai Israel 'iniai wai 'anai ha'ata'inia hura'a mo'osi tanaraau.” ");
INSERT INTO aia_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mia Jon 'a taroha'i ha'arangasia hura'a o'ani, “'Inau 'au 'omesiai Hi'ona Maea na dio mai baaniai aro 'onaai waibora, ma awa na'i hungana Jisas. ");
INSERT INTO aia_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na'i na'o magu to'o i marehosi, 'inau 'au ai'a aidangisia mau do 'iia naasi Ha'atahi. Ma na'i 'oha na 'ia God na ha'ataariau mai 'anai bwareomaea 'iniai wai, nagu 'unua tanaau o'ani, ‘Na'i 'oha na 'oi re'iai Hi'ona Maea 'ai dio mai nai awa na'i hungana tanei, 'iia naasia mo'o na boi 'anai bwareomaea'amou 'iniai Hi'ona Maea.’ ");
INSERT INTO aia_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","'Inau 'au 'omesia, ma wai 'unua tana'amou, 'iia naasi Garena God.” ");
INSERT INTO aia_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mana'i nata dangi ro'u murinai dangisi, 'ia Jon 'a ura beiai waira rua 'ini'i rongoiusuri ana'i. ");
INSERT INTO aia_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","'Oha na 'omesiai taha horo ana Jisas, 'a o'ani, “'Ome, naasi garei siip ana God.” ");
INSERT INTO aia_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Na'i 'oha na 'iraruai rua rongoiusuri anasia Jon rarugu rongo o'asi moi, mararu suria'a Jisas. ");
INSERT INTO aia_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","'Ia Jisas 'a rihota'i ma 'omesirarua, raru suria, ma o'ani 'inirarua, “'E taha muru rabasia?” Miraru aramia o'ani, “Rabae, na'i hei na'o awaiei?” (Ni 'ado'ado 'anai Rabae naasi Ha'ausuri.) ");
INSERT INTO aia_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Mia o'ani 'inirarua, “Murui boi ma murui 'omesia.” Na'i 'ohasi 'a ga'i 'onaai angi hai na'i dangisi. Naasi raru hano beia 'anai 'omesiai dora na awaiei, mararu awa beia na'i dangisi. ");
INSERT INTO aia_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ma'e ta'i 'inirarua naasia Andru, do'orana Saemon Pita. ");
INSERT INTO aia_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mana mareho tahamora na 'ia Andru 'a haua, 'a sibaniai do'orana, 'ia Saemon ma o'ani 'inia, “'I'ameu meu 'omesiai Ha'atahi.” (Ni 'ado'ado 'anai Ha'atahi naasi Kraest.) ");
INSERT INTO aia_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Magu waia 'aria Saemon tanaa Jisas. 'Ia Jisas 'a wanasia Saemon ma o'ani, “Atamu 'ia Saemon, garena Jon. Mana'i 'ohani rai 'unu'o 'inia Keifas.” ('Ado'ado 'ana, naasi hau. Ai'a he'ete'i baania Pita.) ");
INSERT INTO aia_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mana'i ro'u i nata dangi, 'ia Jisas 'a 'adoma'inia do'a raba 'ari Provens i Galili. Ma to'oana Pilip ma o'ani 'inia, “Pilip, 'oi suriau.” ");
INSERT INTO aia_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","'Ia Pilip 'e saeni Betsaeda, 'onaaia Andru mea Pita. ");
INSERT INTO aia_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na'i 'ohasi 'ia Pilip 'a sibania Nataniel ma o'ani 'inia, “Na nei na 'ia Moses miraaui Rarabea rau usu-usu 'abaia na'i 'ohabwani, meu to'oana'a. 'Ia Jisas naasi atana, 'iia 'e garena Josep ni Nasaret.” ");
INSERT INTO aia_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mia Nataniel 'agu ha'atee o'ani, “Na'i Nasaret! 'A bwa'i mareho goro nai hura'a mai baaniai 'omaasi!” Mia Pilip 'a aramia o'ani, “'Oi boi ma'oi 'omesia.” ");
INSERT INTO aia_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na'i 'oha na 'ia Nataniel 'a boboi gaarangia Jisas, 'ia Jisas 'a o'ani, “'Ia mo'osi 'e huunai saeni Israel, me 'iia 'e sae na ha'a-momori tarau.” ");
INSERT INTO aia_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mia Nataniel 'a o'ani 'inia Jisas, “'A he'uai 'iraraa amua i barongagu?” Mia Jisas 'a aramia o'ani, “'Inau 'au bwane 'omesi'o na'i marunai fig, 'oha na 'ia Pilip 'a ai'a soi'o mau.” ");
INSERT INTO aia_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","'Ia Nataniel 'agu o'ani 'inia, “Ha'ausuri, i'oe naasi garena God! Mi'oe naasi mwaeraha 'anai Israel!” ");
INSERT INTO aia_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mia Jisas 'a o'ani 'inia, “'A 'ua? 'O hinihini 'iniai 'unua agua do'au 'omesi'o na'i marunai fig ani? 'Ai ragoi mareho ha'abu'oahu na'oi 'omesi'i narai di'u ro'u mau wou.” ");
INSERT INTO aia_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Magu ha'atee o'ani ro'u 'iniraaui noni, “'I'amou moi 'omesiai aro 'ai heihoa ro'u, mana enjel ana'ia God rai tataa'eha marai didio mai na'i ahoranai Garei Inoni.” ");
INSERT INTO aia_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Murinai rua dangi, 'ia inana Jisas 'a 'ari 'anai ngau goni 'iniai ha'iwai na to'o na'i Provens i Galili na'i 'omaa ra 'unua 'iniai Kena. ");
INSERT INTO aia_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","'Ia Jisas miraaui rongoiusuri ana'i ra ari'ahuraau ro'u wou 'anai ngaugonisi. ");
INSERT INTO aia_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","'A 'ariwou mana waen 'a hakota'iniraau 'oha na ai'a hako mau i ngaugonisi. Mia inana Jisas 'a ha'atee o'ani 'inia, “'Ei, na waen 'a hako'a.” ");
INSERT INTO aia_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mia Jisas 'agu ha'atee o'ani 'inia, “Ina, ai'a aba amua, 'iaagua. 'A ai'a tari mau i madoraa agua.” ");
INSERT INTO aia_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mana inana Jisas 'a ha'atee o'ani 'iniraaui nei nara tau'aro na'i ngaugonisi, “Moi ha'isuriai taha nai 'unua tana'amou.” ");
INSERT INTO aia_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Suri'i ringe adaa'i Jiu rau to'ora'i herehere 'anai dorima. Tarana naasi nara nugaa 'iniai ono kae bei tataruwai na'i 'isi, ma na'i ta'i bei 'a matai awaiei rua tangahuru ma'ua oru tangahurui galon. Na bei 'isi ra tagoradi 'ini'i hau. ");
INSERT INTO aia_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Naasi 'ia Jisas 'a o'ani 'iniraaui nei narau tau'aro na'i ngaugonisi, “Moi ha'ahonu'i bei 'isi 'ini'i wai.” Na'i 'oha narau ha'ahonu ha'agorohi'i hako, ");
INSERT INTO aia_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","'ia Jisas 'agu o'ani 'iniraau, “Moi waa 'ari ta gere dora 'iniai waisi tanaa mo'o na bwauodo 'iniai ha'aha'iwaisi.” Naasi maraugu haua 'onaai 'unua ana tanaraau. ");
INSERT INTO aia_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Na'i 'oha na bwauodo 'anai ha'aha'iwai 'a gono maaniai wai ani, ma bwani aho'ita'i waeni'a. 'Iia 'a ai'a aidangisia na'i hei na boi waenisi, ma'ata 'iraaui nei narau waa mai waisi rau aidangisia moi. Miagu soia maia mo'o nara ha'aha'iwaiasi magu o'ani 'inia, ");
INSERT INTO aia_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“'Ado 'oha, ni waen na goro nara ha'agonohiraau ga'u 'iniai noni. Na'i 'oha nara gono ha'ahakoa wou, maragu haua tanaraau i waen na ai'a taraa goro na'i muri. Mi'oe, na waen na goro di'u na'ogu nugaa 'anai muri!” ");
INSERT INTO aia_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Hoita, na'i 'omaai Kena na'i Provens i Galili'a na 'ia Jisas 'agu hauai 'etanai ha'abu'oahu ana, ma ha'ata'iniai mena ana na hauasa, miraaui rongoiusuri ana'i raugu hinihinia. ");
INSERT INTO aia_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Na'i murinai ha'aha'iwaisi, 'ia Jisas mea inana miraaui do'orana'i mana rongoiusuri ana'i rau 'ari 'omaai Kapaniam marau awa 'isi suriai taringai dangi. ");
INSERT INTO aia_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ma gaarangi mai madoraa 'anai ha'ato'oai rongo 'ini 'adoma'i aho'isiai Roho Aharau, mia Jisas 'a ta'ehai Jerusalem. ");
INSERT INTO aia_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mana'i 'oha na siriwou na'i dora a'ora na'i maanai Ruma Maea ana God, 'a re'iraaui noni narau raoraonga'i kau mana siip mana waibora, miraaui sae 'anai orisi ha'a rau heinagu suri'i dora ni ori-orisi ha'a adaa'i. ");
INSERT INTO aia_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Naasi mia Jisas 'a hau'i hasiwaro ma tagorahiai roroho ma taariraau hako hura'ai mwamwaa baaniai dorasi. 'A rihota'ini'i tebol 'anai ori-orisi ha'a mana ha'a ra asira'i 'ari suriai dorasi. ");
INSERT INTO aia_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma ha'atee wetewete o'ani 'iniraaui nei narau raoraonga'i waibora, “Moi waa'i hura'a baaniai dorani. Moi abui ha'i dora ni raoraonga'i 'iniai ruma ana Amagu!” ");
INSERT INTO aia_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na'i 'oha na 'iraaui rongoiusuri ana'i rau 'omesia o'asi, raugu 'adoma'i aho'isiai dorai Usu-usu Maea na o'ani, “Ni ta'ahia nau haua i ruma amua God, 'a 'onaai 'eu na noro na'i tahingagu.” ");
INSERT INTO aia_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Miraaui saemaua adaa'i Jiu rau songa'inia Jisas o'ani, “'E ha'abu'oahu he'ua na'oi haua namei 'omesia, mameigui 'iraraa do'ia God na 'unua tana'o 'anai hauai heresi?” ");
INSERT INTO aia_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mia Jisas 'agu o'ani 'iniraau, “'Onaa namoi kaiai Ruma Maeani, 'e oru dangi moi mau ha'a-urasia'a aho'i.” ");
INSERT INTO aia_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Na'i 'oha narau rongoa o'asi, rau o'ani 'inia, “'O ga'i ha'a-urasia moi na'i raronai oru dangi? 'E hai tangahuru mana ono harisi ha'atai nara tagoraa suriai rumanisi!” ");
INSERT INTO aia_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mana taha na 'ia Jisas na hadahada 'abaiasi, 'a hadanga'inia haariai abena. ");
INSERT INTO aia_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hoita, na'i murinai 'oha na 'ia Jisas 'agu suruta'e aho'i baaniai mae na 'iraaui rongoiusuri ana'i raugu 'adoma'ini'i aho'i taha na 'unu'i. Na'i 'ohasi raugu hinihini'i ha'atee ana'ia Jisas mana taha na Usu-usu Maea ra 'unu'i 'abaia Jisas. ");
INSERT INTO aia_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na'i 'oha na 'ia Jisas 'a awa mau na'i Jerusalem na'i 'oha nara ha'ato'oai Roho Aharau, 'a ragoi nei nara hinihinia 'iniai 'omesi'i adaa'i ha'abu'oahu na haa'i. ");
INSERT INTO aia_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma'ata 'ia Jisas 'a ai'a taraa 'u'uriraau goro suria 'iia 'a aidangisi'i goroi 'adoma'idaa'i. ");
INSERT INTO aia_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","'A ai'a ta'isada do tanei nai ha'a-aidangisia Jisas 'ini'i barongadi noni, 'inia 'a bwane 'iraraa ha'agorohi'i. ");
INSERT INTO aia_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ma'e ta'i na'otara adaaui Jiu na atana 'ia Nikodimas, 'iia 'e ta'i 'iniraaui ruruha nara 'unuraau 'iniai Farisei. ");
INSERT INTO aia_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","'E ta'i rodo 'a boi beia Jisas ma o'ani, “Ha'ausuri, meu 'iraraa do'ia God na ha'ataari'o do 'anai ha'ausuri'ameu. Na mwani ha'abu'oahu na'o haa'i 'a ha'ata'inia do'ia God 'a awa bei'o.” ");
INSERT INTO aia_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mia Jisas 'a ha'atee o'ani 'inia, “'Inau wai 'unua tana'o ha'a-momori, na inoni 'a bwa'i siri na'i heimarungi ana God 'onaa 'a bwa'i huta haoru.” ");
INSERT INTO aia_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Mia Nikodimas 'agu o'ani 'inia Jisas, “'A bwara do 'oha na mwanemaua i noni do'aigu siri aho'i ro'u na'i ahuna inana ma do'aigu huta haoru aho'i ro'u.” ");
INSERT INTO aia_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mia Jisas 'a o'ani ro'u 'inia, “'Inau wai 'unua tana'o ha'a-momori, na inoni 'a bwa'i siri na'i heimarungi ana God 'onaa na bwa'i huta 'iniai wai mana mena ana Hi'ona Maea. ");
INSERT INTO aia_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","I nei na huta beiai urao 'a huta 'onaai noni, ma'ata i nei na huta haoru 'iniai mena anai Hi'ona Maea, 'iia 'a huta 'onaai garena God. ");
INSERT INTO aia_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Abui heimwaota'i 'iniai 'unua agua tana'o do'oi huta haoru. ");
INSERT INTO aia_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Na'i 'oha na ro'a 'a uhi 'ari na'i dora na 'adoma'iniai uhi 'ariei, 'o matai rongoai aohana. Ma'ata 'o bwa'i matai 'iraraai dora na boi iei mana dora na hano 'ana. Naasi 'a o'asi ro'u beiraaui nei nara huta haoru 'iniai mena anai Hi'ona Maea.” ");
INSERT INTO aia_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mia Nikodimas 'a o'ani, “'A he'ua naasi?” ");
INSERT INTO aia_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Mia Jisas 'a aramia o'ani, “I'oe 'e kae ha'ausuri bwarabwara na'i Israel. Ma 'ua na 'o ai'a aidangisi'i 'ini'i mareho 'isi? ");
INSERT INTO aia_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","'Inau wai 'unua tana'o ha'a-momori, 'i'ameu meu hadanga'ini'i taha nameu aidangisi'i mameu 'omesi'i, magu ai'a tanei 'ini'amou nai mwa'emwa'e 'anai hinihini'i. ");
INSERT INTO aia_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ma 'onaa mou ai'a hinihiniau 'oha nau maani'i mareho nara to'oto'o na'i marewanani, 'aigui he'uai hinihini'i amoo'i mareho ni aro nawai maani'i? ");
INSERT INTO aia_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","'Inaui Garei Inoni, nau aidangisi'i mareho ni aro, 'inia 'inau nau dio mai baaniai aro. Ai'a tanei'a ro'u naigui dio mai baaniai aro. ");
INSERT INTO aia_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Na'i 'oha na 'ia Moses miraaui Jiu rau awa na'i dora mangasara, 'ia Moses 'a ha'a-urasia ara'ai hasi'ei na awa iei mwaa nara tagorahia 'iniai bras. 'A o'asi ro'u, 'inau na Garei Inoni rai ha'a-urasiau ro'u ara'a, ");
INSERT INTO aia_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","neina 'irai nei narai hinihiniau rai daua nadaaui tahi tarau. ");
INSERT INTO aia_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Suria 'ia God 'a ta'ahiraau hakoi noni nai marewana, 'a hisu 'iniai ta'i garena otohuu, neina 'iraaui nei narai hinihinia rau bwa'i siri na'i mae tarau, ma'ata rai daua nadaaui tahi tarau. ");
INSERT INTO aia_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","'Ia God 'a ai'a ha'ataaria mai garena 'anai hiiri ha'a-mama'airaau inoni nai marewana, ma'ata 'anai ha'atahiraau baaniai ha'a-mama'ai. ");
INSERT INTO aia_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“'Iatei nai hinihiniai garena God, 'ia God 'a bwa'i hiiri ha'a-mama'aia. Ma 'onaa 'iatei na bwa'i hinihinia, 'ia God 'a bwane hiiria, suria 'iia 'a ai'a hinihiniai ta'i gare otohuu ana. ");
INSERT INTO aia_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mana taranai maho na 'ia God 'ai hiiriraaui noni 'inia 'a o'ani. Na marewa 'a boi na'i marewana, maagu 'iraaui noni nai marewanani ra ta'ahia di'u i kuhi baaniai marewa, suria na barongadaa'i ra ta'a'i. ");
INSERT INTO aia_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Na sae hehere ta'aa 'a 'itaai marewa ma bwa'i gaarangia wou, suria 'a ai'a 'irisia doni ta'aa ana'i rai ha'ata'i. ");
INSERT INTO aia_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Me 'ia mo'o na hau'i mareho nara odo-odo 'a wa'ewa'e 'anai gaarangia woui marewa, do neina 'ai ha'ata'inia hura'a do na mwane mareho na haa'i ra suriai taha na 'ia God na 'irisia.” ");
INSERT INTO aia_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma na'i moi muri, 'ia Jisas miraaui rongoiusuri ana'i rau 'ari Provens i Jiudea. Rau awa 'isi ga'u marau bwareomaea'i tara'i sae. ");
INSERT INTO aia_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mia Jon 'a bwa-bwareomaearaaui sae ro'u na'i 'omaai Aenon, gaarangiai Salim, suria na'i 'isi 'a ragoi hurahurai wai ma ragoi noni nara boboi 'anai bwareomaea. ");
INSERT INTO aia_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ma na'i 'ohasi 'ia Herod 'a ai'a nugaa maua Jon na'i rumaniho'o. ");
INSERT INTO aia_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hoita, 'ohasi 'e ai Jiu na heita'ia beiraaui rongoiusuri ana'ia Jon. Rau heita'ia suriai ringe adaaui Jiu 'iniai mwa'anu narau haua 'anai ha'a-arariraau na'i maana God. ");
INSERT INTO aia_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Naasi miraaui rongoiusuri ana'ia Jon rau 'ariwou beia marau o'ani 'inia, “Ha'ausuri, 'o 'iraraa mo'o namuru heisadoi ani na'i nata batarau 'iniai wai rahai Jodan na'o hadanga'inia ani? Na'i 'ohanisi 'a bwa-bwareomaea'a ro'u, mana mwane inoni ra 'ari hako beia!” ");
INSERT INTO aia_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mia Jon 'agu aramiraau o'ani, “'A bwa'i nei nai matai haua o'asi 'onaa na 'ia God 'a bwa'i 'ome sigihia. ");
INSERT INTO aia_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","'I'amou mou rongoa hakoi 'unua agua tana'amou do 'inau ai'a i Ha'atahi, ma'ata 'inau ra ha'ataariau mai 'anai ha'aagauraaui noni tanaa. ");
INSERT INTO aia_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Na'i ha'aha'iwai, ni urao na ha'aagau 'anai ha'iwai, 'iia anai mwane na ha'aagau 'anai waina. Ma rei'uaa na o'asi, na geresae anai mwane na ha'aagau 'anai ha'iwaisi, 'a wa'ewa'e moi 'anai 'a'auhia ma 'anai bahurongo'i ha'atee ana'i. Minau 'au wa'ewa'e o'asi ro'u 'anai bahurongo'i ha'atee ana'i Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","'Au 'irisia do'iia rai ha'a-ororiua, minau wai ano-ano moi.” ");
INSERT INTO aia_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Na nei na boi baaniai marewana, 'iia anai marewana me 'iia 'a hadanga'ini'i taha nara to'oto'o na'i marewana. Ma'ata 'ia mo'o na dio mai baaniai aro naasi na ororiu di'u. ");
INSERT INTO aia_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","'Iia 'a maani'i taha na rongo'i ma 'omesi'i, magu ai'a rago i nei narai mwa'emwa'e 'anai hinihini'i taha na maani'i. ");
INSERT INTO aia_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Miraaui nei narau hinihini, rau ha'ata'inia doni mareho na 'ia God na 'unu'i ra ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na nei na 'ia God 'a ha'ataaria 'a ha'arangasi'i ha'atee ana'ia God, suria 'iia 'a honu 'iniai Hi'ona Maea ana God. ");
INSERT INTO aia_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","'Ia Ama 'a ta'ahiai garena, ma hauai mena tanaa 'anai marungi'i mwane mareho hako. ");
INSERT INTO aia_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","'Iraaui nei narau hinihiniai garena God rau daua'a i tahi tarau. Mei tanaraaui nei nara bwa'i hinihinia, ra bwa'i dauai tahi tarau mia God 'ai hiiri ha'a-mama'airaau.” ");
INSERT INTO aia_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","'Ia Jisas 'a 'iraraa do 'iraaui Farisei rau rongoa do 'iia 'a bwareomaearaaui sae, ma waiwai rongoiusuri di'ua ro'ua Jon. Na'i 'oha na 'ia Jisas 'a rongoai mareho narau 'unua 'inia, 'a hano baaniai Jiudea ma aho'i 'ari Galili. Ma'ata 'ia Jisas 'a ai'a bwareomaeaa tanei, 'iraau moi rongoiusuri ana'i narau bwa-bwareomaearaaui sae. ");
INSERT INTO aia_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","'Oha na aho'i 'anai Galili, 'a taha horo na'i Provensi Samaria. ");
INSERT INTO aia_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mana'i Samaria 'a taha na'i 'omaa nara 'unua 'iniai Saeka, gaarangiai dorai ano na 'ia Jekop na haua nanai gare ana 'ia Josep. ");
INSERT INTO aia_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mana giruiwai ana Jekop 'a awa mau 'isi. Mia Jisas 'a 'ariwou heinagu na'i bobonai giruiwaisi 'iniai rahe ana 'iniai hahano, mana madoraa i dangi 'a 'onaai atoaa. ");
INSERT INTO aia_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","'Ariwou ma'e uraoni Samaria na boi do'ai taru wai na'i giruiwaisi. Na'i 'ohasi 'iraaui rongoiusuri ana'ia Jisas rau 'ari 'omaa 'anai hori nadaau mahoingau. Mia Jisas 'a o'ani 'iniai uraosi, “'A 'ua? 'O ga'i taru gugua wai mawai gono?” ");
INSERT INTO aia_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Na'i 'ohasi, na uraosi 'a kaeni heimwaota'i di'u, suria 'iraaui Jiu rau ai'a matai hagu goro beiraaui Samaria. Mana uraosi 'agu o'ani 'inia Jisas, “I'oe 'e ai Jiu me 'inau 'e ai Samaria. Ni 'uaana na'ogu 'unua 'iniasi dowai taru mumua waini gono?” ");
INSERT INTO aia_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mia Jisas 'agu o'ani 'inia, “I'oe 'o ai'a 'ome 'iraraai bane ana God tana'o, ma'o ai'a aidangisia tei na ha'atora'o 'anai taru 'ana wai. 'Onaa na'oi aidangisia, 'o ga'i ha'angoniau mawai haua tana'o i wai nai hauai tahi tana'o.” ");
INSERT INTO aia_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mana uraosi 'a o'ani 'inia Jisas, “Saemaua, na wai 'a awa ha'atau dio magu i'oe 'o ai'a to'oraa ta mareho 'anai taru wai hunia. Na'i hei na'oi taruhiai waini tahi naasi? ");
INSERT INTO aia_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ma ro'u, i'oe 'o 'adoma'inia do i'oe 'o ororiu di'uai wauwa agaaua Jekop na haua tanagaaui girui wainisi? Naani'a 'i wai na 'ia Jekop mana gare ana'i, mana mwamwaa adaa'i narau gogonohiasi.” ");
INSERT INTO aia_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mia Jisas 'a o'ani 'inia, “'Iatei nai gono na'i waisi 'ai matai maesiai gono ro'u mau aho'i. ");
INSERT INTO aia_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma'ata 'iatei nai gonohiai wai na 'inau wai haua tanaa, 'agu bwa'i maesiai gono'a ro'u ta'oha. 'Inia na wai nawai haua tanaa 'ai 'onaai hurahura nai haua tarau tanaa i waini tahi, mana waisi 'ai haua tanaai tahi tarau.” ");
INSERT INTO aia_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mana uraosi 'a o'ani 'inia Jisas, “Ha'ausuri, 'oi haua tanaaui waisi nei nawai abui maesi gono'a ro'u ta'oha, ma'ua boi'a ro'u na'i 'ini 'anai taru wai.” ");
INSERT INTO aia_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Mia Jisas 'agu o'ani 'inia, “'Oi 'ari ma'oi waa mai mwane amua.” ");
INSERT INTO aia_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mana uraosi 'a ha'atee o'ani, “'Inau ai'a ha'iwai.” 'Ia Jisas 'agu o'ani 'inia, “Ha'amomori, i'oe 'o ai'a ha'iwai 'ohani, ");
INSERT INTO aia_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ma'ata 'e rima mwane na'o bwane waina'a ga'u, mana mwane na'o awa beia 'ohanisi ai'a mwane amua.” ");
INSERT INTO aia_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mana uraosi 'a ha'atee o'ani, “Ha'ausuri, nau 'iraraa'a do i'oe 'e rarabea. ");
INSERT INTO aia_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Hoita, 'i'ameui Samaria meu ha'arahesi na'i hungahungai Gerisim 'onaairaaui wauwa amee'i, mi'amoui Jiu mou 'unua do na'i Jerusalem, naasi huunai dora 'anai ha'arahesi. 'Oi 'unua tanaau, nei he'ua na ha'a-momori?” ");
INSERT INTO aia_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","24","Mia Jisas 'agu o'ani 'inia, “'Oi hinihiniai mareho nawai 'unuani! Na madoraa 'ai boi ma naani'a i madoraasi na 'iraaui noni ra bwa'i ha'arahesia God na'i hungahungani ma'ua na'i Jerusalem. 'Inia 'ia God 'e hi'ona. Tarana naasi 'iraaui huudi noni ana'i rai ha'arahesia beiai hei'a'auhi anai Hi'ona Maea ma beiai ha'a-momori. Neiraausi nei na 'ia Amagu 'a 'irisia dorai ha'arahesia. 'I'amou sae ni Samaria mou haha'arahesi, mamou ai'a aidangisia goro atei namou ha'arahesia. Me 'i'ameui Jiu meu aidangisia goro, suria na'i bei'ameui Jiu na hura'a mai nei 'anai ruhasiraaui noni.” ");
INSERT INTO aia_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mana uraosi 'a o'ani, “'Inau 'iraraa doni Ha'atahi 'ai boi, ni nei nara 'unua 'inia Kraest. Mana'i 'oha nai boi 'ai mamaani ruharuhasi'i hako hura'ai mwane mareho tana'ameu.” ");
INSERT INTO aia_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mia Jisas 'a o'ani 'inia, “'Ia mo'o na ha-hadahada bei'o 'ohanisi naasi Ha'atahi!” ");
INSERT INTO aia_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na'i moi 'ohasi miraaui rongoiusuri rau ataha aho'i mai. Rau kaeni heimwaota'i di'u na'i 'oha narau 'omesia do'ia Jisas 'a mamaani beiai urao ni Samariasi. Ma ai'a do tanei 'iniraau na do'ai songa'inia 'iniai taranai taha, ma'ua taha nararu maani'i. ");
INSERT INTO aia_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mana uraosi 'a hanota'iniai bei tataruwai ana ma 'ari 'omaa 'anai soiraaui noni. 'A o'ani, ");
INSERT INTO aia_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Moi boi mamoi 'omesiai sae na 'unu'i hako hura'ai mwane mareho na 'inau 'au haa'i. 'Iia gasi naasi Ha'atahi?” ");
INSERT INTO aia_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Na'i 'ohasi 'iraaui noni rau hura'a baaniai 'omaa, marau 'ari 'anai heisadoi beia Jisas. ");
INSERT INTO aia_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na'i 'oha na uraosi 'a hano 'anai 'ari 'unua tanaraaui noni nai 'omaasi, 'iraaui rongoiusuri ana'ia Jisas rau o'ani 'inia, “Araha, 'oi ngau'a!” ");
INSERT INTO aia_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mia Jisas 'a o'ani 'iniraau, “Ai'a tanei 'ini'amou nai 'iraraa gugua mahoingau.” ");
INSERT INTO aia_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Miraaui rongoiusuri ana'i raugu heisosonga'i hairiu o'ani, “Nii? 'Iatei na ha'i nana mahoingau?” ");
INSERT INTO aia_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mia Jisas 'a o'ani 'iniraau, “Gugua mahoingau, naasi 'anai hauai hei'irisina God, ma 'anai ha'ahakoai tau'aro na ha'ataariau mai 'ana. ");
INSERT INTO aia_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","'I'amou 'iraraai ha'atee nara hahaa na o'ani, ‘'E hai hura namau maraigui mauai wiit 'anai ha'igoni'i.’ 'Inau wai 'unua tana'amou, moi 'ome'ome goro na'i mou, 'inia na mou 'a bwane maua 'anai ha'igoni'i hua. ");
INSERT INTO aia_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","'Iraaui nei nara tagora 'anai ha'igoni'i hua na'i mousi rai dauai heitahari, mana hua narau ha'igoni'i 'isi, naasi 'iraaui noni nara wai'i mai 'anai dauai tahi tarau. Naasi 'ia mo'o na hasiai mou, mea mo'o na ha'igoni'i hua na'i mousi rarui wa'ewa'e goni! ");
INSERT INTO aia_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mana ha'atee na o'ani, 'a ha'a-momori 'ohani, ‘'E nei na hasi mana nata nei nagu ha'igoni'i hua.’ ");
INSERT INTO aia_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","'Inau 'au 'onaai nei na ha'ataari'amou 'ari 'anai ha'igoni'i hua na'i mou na 'i'amou mou ai'a hasia. Ra'i sae he'ete'i nara hasiai mou, mi'amou namoigui dau maenai tau'aro raha adaau.” ");
INSERT INTO aia_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ma ragoi noni Samaria na'i 'omaasi nara hinihini 'iniai 'unua anai uraosi do'ia Jisas 'a 'unu'i hako hura'a mwane mareho na haa'i. ");
INSERT INTO aia_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Na'i 'oha narau hura'a 'anai 'omesia Jisas, rau ha'angonia wetewete do'ai awa beiraau na'i 'omaa adaau. Mia Jisas 'a awa beiraau suriai rua dangi. ");
INSERT INTO aia_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma rago ro'u i nei nara hinihini na'i 'oha ra rongo'i mamaani ana'i. ");
INSERT INTO aia_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Miraaugu o'ani 'iniai uraosi, “Naasi meugu hinihini, suria meu rongorongo'a haarimeeu, ai'a do 'ini'i moi mareho na'o 'unu'i tana'ameu. Ha'amomori, 'iia'a naasi nei na boi 'anai ha'atahiraaui noni nai marewana.” ");
INSERT INTO aia_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na'i muri, na'i 'oha na 'ia Jisas 'a ha'ahakoai rua dangi na'i 'omaasi, 'iia 'a hano ma 'ari Galili. ");
INSERT INTO aia_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","'Ia Jisas 'a bwane 'unua mau do na rarabea ra ai'a ha'ahoua na'i huunai kantri ana. ");
INSERT INTO aia_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Na'i 'oha na ataha wou na'i Provensi Galili, 'iraaui noni rau ha'amaotoa, suria rau bwane 'omesi'i ha'abu'oahu na haa'i na'i Jerusalem na'i 'oha narau 'ari 'isi 'iniai ngaugoni 'anai 'adoma'i aho'isiai Roho Aharau. ");
INSERT INTO aia_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mana 'ariwou na haa na'i Provensi Galili, 'ia Jisas 'a taha na'i 'omaai Kena, i 'omaa na ha'a-aho'ita'iniai wai ani 'iniai waen. Hoita, na'i 'omaa raha na'i Kapaniam, 'e sae mwanemaua na'i gaumani na awa iei. Mana gare anai saemauasi 'a daoha. ");
INSERT INTO aia_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Na'i 'oha na saemauasi 'a rongoa do'ia Jisas 'a hano baaniai Jiudea ma bwane ada aho'i na'i Galili, 'iia 'a 'ari na'i Kena. Na'i 'oha na ada beia Jisas, 'a bonga'inia dorai ta'i 'ari Kapaniam mai ha'agorohia aho'i gare ana na gaarangi mae. ");
INSERT INTO aia_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Mia Jisas 'a o'ani 'inia, “'A 'ua? Domoi 'omesia moe'a ta ha'abu'oahu mamoigui hinihini?” ");
INSERT INTO aia_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mana saemauasi 'a ha'a-osaosaa di'u, 'a o'ani, “'Oi boi, na gare agua 'ai mae'a!” ");
INSERT INTO aia_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mia Jisas 'agu o'ani 'inia, “'Oi aho'i 'ari 'omaa, na gare amua 'ai tahi moi!” Mana saesi 'a hinihinia Jisas ma aho'i 'ari 'omaa. ");
INSERT INTO aia_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na'i 'oha na 'a'ariwou mau suriai tara, ra'i sae tatau'aro ana'i rau boi 'anai heisadoi beia, marau 'unua tanaa doni gare ana 'a bwane 'awaa, ma awa goro'a aho'i. ");
INSERT INTO aia_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mia songa'iniraau 'iniai madoraa he'ua na taraawa'a 'awaa, miraau o'ani 'inia, “'A taraawa'a 'awaa mau na'i angi ta'i na'i atoaa nanora.” ");
INSERT INTO aia_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mana amanai garesi 'agu 'iraraa do naasi madoraa na 'ia Jisas 'a o'ani 'inia, “Na gare amua 'ai tahi moi.” Na'i 'ohasi, ni sae mwanemauasi mana ruruha ana hako rau hinihinia'a Jisas. ");
INSERT INTO aia_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Naasi ruanai ha'abu'oahu na 'ia Jisas 'agu haua na'i Galili. Mana rua ha'abu'oahusi 'a haua na'i 'oha na hano baaniai Jiudea magu taha aho'i na'i Galili. ");
INSERT INTO aia_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Na'i muri 'ia Jisas 'a 'ari Jerusalem 'anai ta'i dangi ororiu adaaui Jiu. ");
INSERT INTO aia_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Hoita, mana'i raronai 'omaa rahasi 'e oboi wai na awa iei nara 'unua 'iniai Betsata na'i ha'ateeni Jiu. Mana obosi 'a awa na'i dora ra 'unua 'iniai “Maanai barai Siip.” Na'i bobonai obosi, 'e rima ruma ni bwebwero na awa na'iei. ");
INSERT INTO aia_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","'A ragoi sae nara to'iraau i mwani daoha he'ete'i hairiu narau dadao suri'i ruma 'isi. Tara'i nei ra kuru, tara'i nei ra pwaki, ma tara'i nei abedaa'i hako ra nugu. Ra mamasiai 'oha na 'iha'iha i wai. ");
INSERT INTO aia_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","'Inia tara'i 'oha 'e enjel ana Araha 'ai boi 'anai ha'a-'iha'ihaa. Mana 'etanai sae 'anai buu dio na'i raronai wai 'ai goro aho'i baaniai daoha na to'ia. ");
INSERT INTO aia_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma'e ta'i 'iniraaui sae nara dadao 'isi, 'a daoha suriai oru tangahuru mana waru harisi. ");
INSERT INTO aia_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","'Oha na 'ia Jisas 'a re'ia, 'a bwane aidangisia do'a bwane daoha orea'a mai. Mia Jisas 'a songa'inia o'ani, “'O 'irisia do 'ai goro aho'i i abemu?” ");
INSERT INTO aia_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mia aramia Jisas o'ani, “Saemaua, 'a bwara di'u, 'inia ai'a sae 'anai waiau dio na'i obo na'i madoraa na 'iha'iha i wai. Na'i 'oha nawaigui bonasia dio, ma'e sae nai bwane dio'a na'i na'o baaniau.” ");
INSERT INTO aia_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mia Jisas 'a o'ani 'inia, “'Oi ura ara'a ma'oi suru'iai be'amu ma'oi hahano!” ");
INSERT INTO aia_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na saesi 'a goro mau na'i 'ohasi! 'A suru'iai be'ana ma hahano'a! Mana dangi na to'o i ha'abu'oahusi, 'e dangi ni mamaro adaaui Jiu. ");
INSERT INTO aia_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Miraaui saemaua adaa'i Jiu rau haungaridaau, marau o'ani 'inia mo'o na goro baaniai daohasi, “Ra ha'aabua 'anai waiwai hi'o na'i dangini, 'inia dangini 'e dangi ni mamaro!” ");
INSERT INTO aia_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mia mo'osi 'a o'ani, “'Ia mo'o na ha'agorohiau baaniai daoha na 'unua tanaausi dowai rahiai hi'o agua mawai hahano.” ");
INSERT INTO aia_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Miraau ha'atee haungaridaau o'ani, “'Iatei na 'unua tana'o 'i marehosi?” ");
INSERT INTO aia_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mia mo'osi 'a ai'a 'iraraai atana mo'o na ha'agorohia baaniai daoha, suria 'a ragoi sae, mia Jisas 'a bwane hano'a. ");
INSERT INTO aia_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Na'i muri, na 'ia Jisas 'agu to'oana ro'u na'i Ruma Maea ana God ma o'ani 'inia, “'Ome, i'oe 'o goro'a. Naasi 'oigui abui haua'a ro'u ta ora-ora'a. 'A gasigu to'i'o ta mareho nai ta'aa di'u ro'u wou.” ");
INSERT INTO aia_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mia mo'osi 'a 'ari ma maania tanaraaui saemaua adaa'i Jiu do'ia Jisas na ha'agorohia aho'i baaniai daoha. ");
INSERT INTO aia_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Na'i 'ohasi, 'iraaui saemaua adaa'i Jiu raugu taraawa'a here ha'ata'aia Jisas, 'iniai hahaa'i ana'i mareho o'asi na'i dangi ni mamaro. ");
INSERT INTO aia_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mia Jisas 'a o'ani 'iniraau, “I Amagu ai'a dangi do'ai agoheta'i tagora. Tarana naasi 'inau 'au o'asi ro'u.” ");
INSERT INTO aia_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Na'i 'oha naraugu rongoa o'asi, raugu 'adoma'i wetewete ro'u wou 'anai ha'amaesia, ai'a do 'inia moi horosia ana i ringe anai dangi ni mamaro, me 'inia ro'u i 'unua anasi do'ia God naasi amana, mana'i 'oha na 'unua o'asi, 'a here 'onaa do 'iia 'a ta'isada beia God. ");
INSERT INTO aia_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mia Jisas 'a ha'atee o'ani, “'Inau wai 'unua tana'amou ha'a-momori, na Gare 'abwa'i haua mwada'u ta mareho suria moi 'adoma'ina haaria, ma'ata 'a ha'isuriai taha na Amana 'a haua. Ni taha na Ama 'ai haa, ni Gare 'ai haua ro'u. ");
INSERT INTO aia_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","'Ia Ama 'a ta'ahiai Gare, ma ha'ata'ini'i hako tanaa i mwane mareho na 'iia 'a haa'i. Mana Ama 'ai ha'ata'inia tanaai Gare tara'i kae mareho raha 'anai haua narai di'u ro'u wou baaniai ha'agorohia na haa i saeni baaniai daoha. Mana mareho nai haa'i, moi heimwaota'i hako 'ini'i. ");
INSERT INTO aia_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","'Ia Ama 'a matai ha'a-suruta'eraau aho'i nei nara mae maai haua tanaraaui tahi. I Gare 'ai o'asi ro'u. 'Iia 'ai hauai tahi tanaraaui nei na 'ome sigihiraau. ");
INSERT INTO aia_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mana Ama 'a ai'a hiiria tanei, suria 'iia 'a bwane haua'a tanaai Gare 'i mena 'anai hiiriraau inoni. ");
INSERT INTO aia_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","'A haua o'asi do neina 'iraaui noni rai ha'ahouai Gare, 'onaai ha'ahoua adaaui Ama. 'Iatei na ai'a ha'ahouai Gare, 'a ai'a ha'ahouai Ama na ha'ataaria mai. ");
INSERT INTO aia_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Wai 'unua tana'amou ha'a-momori, 'iatei nai hinihini'i ha'atee agu'i mai hinihinia ro'ua God na ha'ataariau mai, 'ai dauai tahi tarau. 'Iia 'au bwa'i hiiria 'ini'i ora-ora'a ana'i, suria 'iia 'a 'onaai nei na hano baaniai mae na 'ari na'i tahi. ");
INSERT INTO aia_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ha'amomori. 'Inau wai 'unua tana'amou, ni madoraa 'ai boi ma naani'a i madoraasi na 'iraaui nei ra hano 'anai mae tarau rai rongoai ringenai garena God. 'Iraaui nei narai bahurongoa rai dauai tahi tarau. ");
INSERT INTO aia_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","'Inia i Ama naasi na to'o mena 'anai hauai tahi tanaraaui noni. Me 'iia 'a watea ro'u i menasi tanaai garena neina garena 'ai haua ro'u i tahi tanaraaui noni. ");
INSERT INTO aia_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma haua ro'u tanaai garena 'i mena 'anai hiirirai noni, 'inia 'iia naasi Garei Inoni. ");
INSERT INTO aia_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Moi abui heimwaota'i. 'E madoraa nai boi mau, 'iraaui nei nara mae nara awa na'i hera rai rongoai ringenai garena God. ");
INSERT INTO aia_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Na'i 'ohasi raigu suruta'e baani'i hera. 'Iraaui nei narau haa'i mwani mareho goro rai siri na'i tahi tarau, miraaui nei ra haa'i mwani mareho ta'a'i rai siri na'i mae tarau.” ");
INSERT INTO aia_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","'Ia Jisas 'a ha'atee o'ani ro'u 'iniraau, “'Inau 'au bwa'i matai haua mwada'u ta maho suriai 'adoma'igu haariau. 'Inau 'au hihiiri suriai 'unua ana God tanaau. Naasi na hihiiri nau haa 'a odo-odo, suria 'inau ai'a ha'isuriai 'adoma'igu haariau, ma'ata 'au hihiiri suriai 'adoma'ina God na ha'ataariau mai.” ");
INSERT INTO aia_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“'Onaa na 'inau moi wai ha'arangasiau haariau hura'a, na mareho nawai 'unu'i hura'a 'iniau haariau 'ai gere bwara tana'amou 'anai hinihini'i. ");
INSERT INTO aia_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma'ata 'e sae he'ete'i ro'u na ha'arangasiau hura'a tana'amou, ma wai 'unua tana'amou, na mwane mareho na maani'i hura'a 'iniau ra ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","'I'amou mou bwani ha'ataari'i 'ari tara'i sae 'anai bahurongoa Jon Bwareomaea, mana mareho na maani'i hura'a 'iniau ra ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ai'a do 'a ororiu tanaau dorai ha'arangasiau hura'a, ma'ata 'au ha'a-'adoma'i aho'isi'amou moi 'iniai heitaroha'i ana Jon nei namoi 'iraraai here namoi daua 'inia i tahi tarau. ");
INSERT INTO aia_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","'Ia Jon 'a 'onaai raita na ha'amarewa'i 'adoma'imoo'i. Mi'amou mou wa'ewa'e moi 'inia, suriai gere 'oha. ");
INSERT INTO aia_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Minau, 'e mareho na ha'ata'inia hura'a ha'a-momori do'ia God na ha'ataariau mai. Naia naasi tatau'aro nau haua na 'ia Amagu 'a 'irisia dowai haua. Marehosi 'a ha'arangasiau goro hura'a di'u'i ro'u i taha na 'ia Jon 'a maani'i 'iniau. ");
INSERT INTO aia_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mia Amagu na ha'ataariau mai 'a bwane 'unu'i hako hura'ai mwane mareho 'iniau. 'I'amou mou ai'a rongoai ringena, mamou ai'a wanara'i maa 'inia, ");
INSERT INTO aia_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","mamou ai'a hinihini'i ha'atee ana'i. 'Au 'iraraa o'asi suria mou ai'a hinihiniau, i nei na 'ia God na ha'ataariau mai. ");
INSERT INTO aia_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mou siba suri'i usu-usu na'i Usu-usu Maea, 'inia mou hinihinia do na'i suri'i namoi sadoiai tahi tarau. Na'i 'isi nara ha'arangasiau hura'a suri'i! ");
INSERT INTO aia_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mia mougu ai'a raba boi beiau mawai haua tana'amoui tahi tarau. ");
INSERT INTO aia_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“'Au ai'a bonasia domoi ha'a-ta'eta'eau, ");
INSERT INTO aia_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","'inia 'au aidangisia do 'i'amou mou ai'a ta'ahia God suri'i tahingamoo'i. ");
INSERT INTO aia_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","'Inau 'au boi bei'i ha'atee ana'ia Amagu, mi'amou ai'a ha'amaotoau. Ma 'onaa tanei he'ete'i nai boi hadanga'ini'i mareho 'inia moi haaria, 'i'amou ga'i mwa'emwa'e goro 'anai ha'amaotoa. ");
INSERT INTO aia_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","To'oana moi mou bwarai hinihini! Mou 'irisia do'iraaui noni rai ha'a-ta'eta'e'amou, mamougu ai'a 'irisiai ha'a-ta'eta'e baania God. ");
INSERT INTO aia_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Moi abui 'adoma'inia do 'inau nawai ha'ahuni'amou na'i maana Amagu. 'A bwa'i! 'Ia Moses namou 'u'uria gorosi do 'iia nai 'a'auhi'amou, 'iia nai ha'a-huni'amousi. ");
INSERT INTO aia_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ma 'onaa namou hinihinia mora Moses, 'i'amou ga'i hinihiniau ro'u, 'inia na mareho na usu'i, 'a usu'i 'iniau. ");
INSERT INTO aia_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma 'onaa namou ai'a hinihini'i mareho na usu'i, moigui hinihini'i he'uai mareho nau maani'i?” ");
INSERT INTO aia_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mana'i muri, 'ia Jisas miraaui rongoiusuri ana'i rau ta'e horo 'ari na'i nata batarau 'iniai kae bwera i Galili, na tara'i 'oha ra 'unua 'iniai bwera i Taebirias. ");
INSERT INTO aia_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma'e kae ruruhai noni narau susuria tarau 'inia rau 'omesi'i ha'abu'oahu na haa'i na'i 'oha na ha'agorohiraau aho'i nei nara daoha. ");
INSERT INTO aia_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mana'i 'oha narau ataha 'ari nata batarau, 'ia Jisas mana rongoiusuri ana'i rau ta'eha ara'a na'i gere hungahunga marau heinagu. ");
INSERT INTO aia_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mana'i 'ohasi na dangi hauasa adaaui Jiu 'anai ha'ato'oai Roho Aharau 'a gaarangi. ");
INSERT INTO aia_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","'Ia Jisas 'a wana 'ari ma 'omesia 'ari goni adaau mai mwane noni beia, ma rihota'i tanaa Pilip ma o'ani 'inia, “Na'i hei nagai matai hori bredi arari'i mwane sae 'ini?” ");
INSERT INTO aia_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","'A 'unuai marehosi, do 'a raba ha'imaania moia Pilip, me 'ia Jisas 'a bwane 'iraraai taha nai haua 'anai hanganiraaui noni. ");
INSERT INTO aia_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Mia Pilip 'a o'ani 'inia, “'Ei! Rei'uaa nagai to'oraa ta kae ha'a ma bwa'i arari mau ro'u.” ");
INSERT INTO aia_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ma'e ta'i rongoiusuri ro'u na atana 'ia Andru, 'e do'orana Saemon Pita, na o'ani, ");
INSERT INTO aia_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“'Ei! Ni gere gare mwaneni 'e rima huai bredi ma'e rua ii'a na beia. Magu 'a bwa'i arariraau hakoi mwane inoni 'ini.” ");
INSERT INTO aia_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mia Jisas 'agu o'ani 'iniraaui rongoiusuri, “Moi 'unua tanaraau inoni marai heinagu.” Mana hahaarisi 'a rago na'i dorasi, miraaui noni raugu heinagu auru hako. Mana goni nara haasi 'a gaarangi 'onaai rima merui mwane. ");
INSERT INTO aia_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mia Jisas 'a dauai rima huai bredisi ma ha'atee ha'agorohia God 'ini'i ma haa'i tanaraaui noni. Ma haa o'asi ro'u 'ini'i ii'a. Na'i 'ohasi rau ngau, marau masu hako. ");
INSERT INTO aia_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mia Jisas 'agu o'ani 'iniraaui rongoiusuri ana'i, “Moi si'o goni'i mareho na 'iraaui noni rau ngau tahi'i neina abu ta mahoingau nagai ha'agata'inia.” ");
INSERT INTO aia_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Na'i 'oha narau si'o goni'i dora narau ngau tahi'i baaniai rima huai bredi moi na 'ia Jisas na ha'atora'ini'i ani, rau ha'ahonuai ta'i tangahuru mana rua abira. ");
INSERT INTO aia_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na'i 'oha na 'iraaui noni rau 'omesiai ha'abu'oahusi, raugu ha'atee o'ani, “Ha'amomori, naia'a naasi rarabea nagau mamasiasi!” ");
INSERT INTO aia_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","'Ia Jisas 'a 'omesia do 'iraaui noni rai waia 'anai ha'a-'usu'usua do'ai mwaeraha tanaraau. Naasi ma hano ma ta'eha bo ta'eha ro'u na'i hungahunga haaria. ");
INSERT INTO aia_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na'i su'urahi 'iraaui rongoiusuri ana'i rau dio mamasia dioi bobonai bwera. ");
INSERT INTO aia_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ma hanoria woui kuhi 'ohasi mia Jisas ai'a ataha mau beiraau. Naasi marau ta'e baania ara'a na'i ora, marau haruta 'ari 'anai 'omaai Kapaniam. ");
INSERT INTO aia_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Raugu 'asu'a ma diohiraaui ro'a raha mana wai 'a taraawa'a abwao. ");
INSERT INTO aia_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na'i 'oha na 'iraaui rongoiusuri rau bwane su'ara'i ha'atau hura'a 'onaai rima ma'ua ono kilomita, maraugu 'omesia Jisas hahano ana mai gaarangiraau na'i hunganai wai. Na'i 'ohasi rau kae mamaa'u di'u. ");
INSERT INTO aia_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mia Jisas 'a ha'atee 'ari tanaraau o'ani, “'Inau moi! Mou abui mamaa'u.” ");
INSERT INTO aia_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Na'i 'ohasi ragu wa'ewa'e do'ai ta'e ara'a beiraau na'i ora. Raugu 'asu'a marau 'oto siriwou na'i dora narau hano 'ana. ");
INSERT INTO aia_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Na'i haho'oa, 'iraaui noni 'ari nata batarau 'iniai bwerasi rau goni na'i one 'anai totoria Jisas, 'inia rau 'adoma'inia do 'a awa mau na'i 'isi. Dorasi 'a awa gaarangiai dora narau ngau iei na'i 'oha na 'ia Araha 'a ha'atee ha'agorohia God 'ini'i huai bredi mana ii'a 'ani. Rau 'iraraa do'ia Jisas 'a ai'a hano beiraaui rongoiusuri ana'i, 'inia ta'i ora'a na awa 'isi na 'iraaui rongoiusuri rau bwane ta'e na'iei 'anai 'ari nata batarau. Hoita, na'i 'ohasi, tara'i ora ni Taebirias nara 'oto gaarangiraau. ");
INSERT INTO aia_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na'i 'oha na 'iraaui noni hunga rau 'ome 'iraraa do'ia Jisas mana rongoiusuri ana'i raugu ai'a awa'a 'isi, rau ta'e suri'i ora marau 'ari Kapaniam 'anai sibania Jisas. ");
INSERT INTO aia_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na'i 'oha narau ataha wou nata batarau, rau sadoia Jisas marau songa'inia o'ani, “Ha'ausuri, 'oha he'ua na'o boi 'ini?” ");
INSERT INTO aia_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mia Jisas 'a aramiraau o'ani, “Ai'a! Wai 'unua ha'a-momori tana'amou, 'i'amou mou raba suriau 'inia 'au hangani'amou mamou masu, ai'a domou aidangisi'i ha'abu'oahu nau haa'i. ");
INSERT INTO aia_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Moi abui bona 'iniai mareho na bwa'i matai awa orea 'onaai mahoingau, ma'ata moi bonasiai mareho nai matai awa tarau na 'inau i Garei Inoni nau matai haua tana'amou. 'Inia 'ia Amagu na haua tanaaui mena 'anai haua o'asi.” ");
INSERT INTO aia_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Miraau ha'atee o'ani 'inia, “Ra'i taha na 'ia God 'a 'irisia domei haa'i?” ");
INSERT INTO aia_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Mia Jisas 'a aramiraau o'ani, “Naani taha na 'ia God 'a 'irisia domoi haua. Moi hinihiniai nei na 'iia na ha'ataaria mai.” ");
INSERT INTO aia_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Miraau ha'atee o'ani ro'u 'inia, “'Onaa na'o 'irisia domei hinihini'o, ma'oi haua ta ha'ara mamei 'omesia ta. 'Ia Moses 'a hauai ha'abu'oahu tanaraaui wauwa agaa'i 'ohabwani na'i madoraa narau hano 'ari suriai dora mangasara. 'A hanganiraau 'iniai mahoingau nara 'unua 'iniai Mana na dio mai baaniai aro! 'Onaai usua ada na'i Usu-usu Maea o'ani, ‘Ni mahoingau na dio mai baaniai aro, naasi mahoingau na haua tanaraau 'anai ngaa.’ 'E ha'abu'oahu he'ua na'oi haua tana'ameu?” ");
INSERT INTO aia_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mia Jisas 'a o'ani 'iniraau, “'Inau wai 'unua ha'a-momori tana'amou, 'ia Moses 'a ai'a hauai mahoingau tanaraaui wauwa agaa'i dio mai baaniai aro. I Amagu naasi na haua tanaraau. Mana'i 'ohani 'a haua tana'amoui huunai bredi na dio mai ara'ai aro. ");
INSERT INTO aia_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mana huunai bredi ana God naasi 'ia mo'o na dio mai ara'ai aro 'anai hauai huunai tahi tanaraau hakoi noni nai marewana.” ");
INSERT INTO aia_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Miraau o'ani 'inia Jisas, “Saemaua, 'oi haua tarau tana'ameu i bredisi.” ");
INSERT INTO aia_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mia Jisas 'a o'ani 'iniraau, “'Inau naasi bredi ni tahi. 'Iatei nai boi beiau, 'agu bwa'i hioro'a ro'u ta'oha. Mia tei na hinihiniau 'agu bwa'i raba gono'a ro'u. ");
INSERT INTO aia_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","'Onaai bwane 'unua agua tana'amou, rei'uaa namou 'omesiau, me mou ai'a hinihini mau ro'u. ");
INSERT INTO aia_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ma'ata 'iraaui nei na 'ia Amagu na hau'i tanaau, rai boi beiau, mau bwa'i 'itaraau. ");
INSERT INTO aia_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","'Inia 'inau 'au dio mai 'anai hauai taha na Amagu 'a ha'ataariau mai 'ana, ai'a 'anai suria moi 'adoma'igu haariau. ");
INSERT INTO aia_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma naani hei'irisina God, do abu ta ta'i nei 'iniraaui nei na haa'i mai tanaau nawai ha'a-ai'aa, ma'ata na'i ha'ahakonai dangi wai ha'a-suruta'eraau hako baaniai mae. ");
INSERT INTO aia_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","I Amagu 'a 'irisia do 'iraaui nei ra 'ome 'iraraai garena marau hinihinia, rai to'oraai tahi tarau. Mana'i hahakonai dangi wai ha'a-suruta'eraau baaniai mae.” ");
INSERT INTO aia_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na'i 'ohasi 'iraaui Jiu raugu taraawa'a mangurunguru 'iniai 'unua ana do'iia naasi bredi na dio mai baaniai aro. ");
INSERT INTO aia_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Marau o'ani ro'u, “'Iia moia Jisas garena Josep naasi! 'Igaau mataia amana mia inana. 'A he'ua na 'unua 'inia do 'iia 'a dio mai baaniai aro?” ");
INSERT INTO aia_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mia Jisas 'a o'ani 'iniraau, “'Ei! Mou abui mangurunguru 'iniai marehosi! ");
INSERT INTO aia_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","'A bwa'i nei nai boi beiau 'onaa na 'ia Amagu na ha'ataariau mai 'a bwa'i waia mai tanaau. Mia mo'o nai boi beiau, wai ha'a-suruta'ea baaniai mae na'i ha'ahakonai dangi. ");
INSERT INTO aia_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na'i buka adaa'i rarabea ra usua o'ani, ‘'Ia God 'ai ha'ausuriraau hako.’ Naasi 'iraaui nei narau bahurongo marau ha'isuri'i taha na Ama na ha'ausuriraau 'ini'i, naasi narau boi beiau. ");
INSERT INTO aia_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ai'a do ta nei nai re'iai Ama. Ta'i, 'inau moi na 'ia Ama na ha'ataariau mai nau re'ia. ");
INSERT INTO aia_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ma wai 'unua ha'a-momori tana'amou, 'iatei na hinihiniau 'a daua'a i tahi tarau. ");
INSERT INTO aia_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","'Inau naasi bredi ni tahi! ");
INSERT INTO aia_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","'Iraau na wauwa agaa'i na'i 'oha bwani, rau ngau Mana na'i dora mangasara maraugu buna mae mau. ");
INSERT INTO aia_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ma'ata 'iraaui nei narai ngauai bredi na dio mai baaniai aro, rai daua nadaaui tahi tarau. ");
INSERT INTO aia_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","'Inau naasi bredi ni tahi nau dio mai baaniai aro. 'Iatei nai ngauai bredisi 'ai awa tarau, mana bredisi naasi abegu nau haua tanaraaui mwane inoni nai marewana hako do 'iraau rai tahi 'inia.” ");
INSERT INTO aia_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Miraaui noni raugu heitohetohe hairiu 'iniai 'ado'ado 'anai mareho na 'unuasi. Marau o'ani, “'Ai he'ua nai haa 'inia tanagaaui abena 'anai ngaua?” ");
INSERT INTO aia_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mia Jisas 'agu o'ani 'iniraau, “'Inau wai 'unua ha'a-momori tana'amou, 'onaa namou bwa'i ngauai abena mana gonohiai 'abunai Garei Inoni, mou bwa'i dauai tahi tarau. ");
INSERT INTO aia_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","'Irai nei ra ngauai abegu mara gonohiai 'abugu, rau daua'a i tahi tarau, minau wai ha'a-suruta'eraau na'i ha'ahakonai dangi. ");
INSERT INTO aia_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Suria na abegu naasi huunai mahoingau, mana 'abugu naasi huunai waini gono. ");
INSERT INTO aia_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","'Iraaui nei nara ngauai abegu mara gonohiai 'abugu rau ha'i ta'i beiau minau 'e ta'i beiraau. ");
INSERT INTO aia_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","'Ia Ama na tahitahi na ha'ataariau mai, me'iia na haua tanaaui tahi. 'A o'asi ro'u, 'iraaui nei narau ngauai abegu wai hauai tahi tanaraau. ");
INSERT INTO aia_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","'Inau naasi bredi na dio mai baaniai aro. 'Iatei nai ngauai bredi naasi, 'ai dauai tahi tarau. 'A bwa'i 'onaairaaui wauwa agaa'i narau ngauai Mana na'i dora mangasara maraugu mae ro'u mau.” ");
INSERT INTO aia_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ni mareho 'isi 'ia Jisas 'a maani'i na'i 'oha na ha'ausuriraaui noni na'i ruma ni ha'arahesi na'i Kapaniam. ");
INSERT INTO aia_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","'A ragoi nei 'iniraaui nei rau araisuria Jisas narau o'ani, “Araha, ni ha'ausuringa'i 'isi ra bwara di'u 'anai aidangisi'i. Bwa'i ta sae naigui mwa'emwa'e 'anai araisuri'i!” ");
INSERT INTO aia_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","'Ia Jisas 'a aidangisia do 'iraaui rongoiusuri rau mangurunguru hairiu 'iniai marehosi, ma o'ani 'iniraau, “'A 'ua? Na mamaani nau hau'isi ra ha'awauni'i tahingamoo'i? ");
INSERT INTO aia_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'Onaa na o'asi, ma'ai he'ua 'onaa namoi 'omesiau 'i Garei Inoni wai aho'i ara'ai dora na 'inau 'au boi baania? ");
INSERT INTO aia_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na Hi'ona Maea moi na matai hauai tahi tarau, inoni 'a bwa'i matai haua. Mana mwane mareho nau hadanga'ini'i tana'amou 'isi, ra boi baaniai Hi'ona Maea mara matai hauai tahi tarau tana'amou. ");
INSERT INTO aia_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ma'ata rei'uaa na o'asi, me tara'i nei 'ini'amou mou ai'a hinihiniau ro'u mau.” 'Ia Jisas 'a bwane aidangisiraau mau na'i na'o i nei narau bwa'i hinihinia mia tei nai usuha'inia tanaraaui maerongana. ");
INSERT INTO aia_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mia Jisas 'a o'ani ro'u 'iniraau, “Namoisi mareho nau bwane 'unua 'inia do 'a bwa'i nei nai matai boi beiau 'onaa na 'ia Amagu 'a bwa'i waia mai tanaau.” ");
INSERT INTO aia_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Na'i 'ohasi 'a ragoi nei rau suria ga'u a Jisas narau rihota'i aho'i maraugu ai'a raba suria'a ro'u. ");
INSERT INTO aia_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mia Jisas 'a rihota'i wou tanaraaui ta'i tangahuru mana rua rongoiusuri ana ma o'ani 'iniraau, “'A 'ua? 'I'amou moi nugasiau o'asi ro'u?” ");
INSERT INTO aia_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mia Saemon Pita 'a aramia o'ani, “Araha, 'iatei ro'u nameigui suria, 'inia suri'i ha'atee amu'i'a naasi namei matai sadoiai tahi tarau. ");
INSERT INTO aia_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Meu hinihini mameu 'iraraa do i'oe naasi noni maea na'o boi baania God.” ");
INSERT INTO aia_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Naasi mia Jisas 'a o'ani 'iniraau, “'A ha'a-momori, 'e waira ta'i tangahuru mana rua rongoiusuri nau 'ome sigihi'amou. Magu 'e ta'i 'ini'amou 'e adaro.” ");
INSERT INTO aia_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Na'i 'oha na ha'atee o'asi, 'a hadanga'inia Jiudas garena Saemon Iskariot. 'Iia 'e ta'i 'iniraaui ta'i tangahuru mana rua rongoiusuri nai usuha'inia Jisas tanaraaui maerongana. ");
INSERT INTO aia_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma na'i muri 'ia Jisas 'a awa na'i Provensi Galili, ma 'a'aariha 'ari suri'i 'omaa. 'Iia 'a ai'a raba 'ari na'i Provensi Jiudea suria 'iraaui saemaua adaa'i Jiu rau bonasiai ngahu ha'amaesia. ");
INSERT INTO aia_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mana rongo 'anai 'adoma'i aho'isiai 'oha na 'iraaui wauwa adaa'i rau awa suri'i ruma saira na'i dora mangasara 'a gaarangi. ");
INSERT INTO aia_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Miraaui do'orana'i a Jisas rau ha'ata'u'ua 'anai 'ari na'i Jiudea 'anai ha'ato'oai rongosi. Rau o'ani, “'Oi hano ma'oi 'ari Jiudea miraaui rongoiusuri amu'i rai 'omesi'i ha'abu'oahu na'oi haa'i! ");
INSERT INTO aia_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","'Onaa 'oi awa hatara'i moi 'ini, ma 'a bwa'i taro i atamu. 'Iniai to'oraa amua i mena 'anai hau'i mareho ha'abu'oahu o'asi, ma'oi ha'ata'ini'i tanaraaui mwani noni hako marai 'iraraa!” ");
INSERT INTO aia_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Rau ha'atee o'asi, 'inia rei'uaa na 'iraau ra'i huunai do'orana'i, me 'iraau rau ai'a hinihinia. ");
INSERT INTO aia_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mia Jisas 'agu aramiraau o'ani, “Na'i 'ohani ai'a huunai madoraa goro tanaau 'anai 'ari Jiudea. 'I'amou rei'uaa namoi 'ari namoiwou ta madoraa, ma bwa'i 'ua tana'amou. ");
INSERT INTO aia_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","'Iraaui noni nai marewanani ra bwa'i 'itamou, me 'inau rai 'itaau suria 'au 'unua tanaraau doni barongadaa'i ra ta'a'i. ");
INSERT INTO aia_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Moi 'ari mamoi ha'ato'oai rongosi. 'Inau 'au bwa'i 'ariwou mau 'inia 'a ai'a tari mau i madoraa agua.” ");
INSERT INTO aia_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Na'i 'oha na 'ia Jisas 'a 'unu'i hakoi mareho 'isi, 'agu awa suriai taringai dangi na'i Provens i Galili. ");
INSERT INTO aia_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mana'i murinai 'oha na 'iraaui do'orana'ia Jisas rau 'ari 'anai ha'ato'oai rongosi, 'ia Jisas 'a 'ari ro'u, ma'ata 'iia 'a hano haaria do 'iraau sae rau gasi 'omesia. ");
INSERT INTO aia_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Miraau na saemaua adaa'i Jiu rau 'ome sibasiba 'inia marau heisosonga'i 'inia. ");
INSERT INTO aia_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mei beiraaui noni hunga, ra ragoi nei nara hadanga'inia Jisas. Tara'i nei rau o'ani, “'E sae goro naasi.” Ma tara'i nei rau o'ani, “Ai'a na! 'Ia mo'osi 'a pwari'iraaui noni.” ");
INSERT INTO aia_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ma bwara do tanei nai ramoramo 'anai ha'atee ha'a-aneanea Jisas na'i maadaau hakoi noni, suria rau mamaa'usiraaui saemaua adaa'i Jiu. ");
INSERT INTO aia_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Murina tara'i dangi, 'oha narau gaarangi tari wou na'i 'ubutanai rongo narau hauasi, 'ia Jisas 'a 'ari na'i Ruma Maea ana God ma ha'ausuriraaui noni. ");
INSERT INTO aia_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mana'i 'oha na 'iraaui saemaua adaa'i Jiu rau rongo'i ha'ausuringa'i na haa'i, rau kaeni heimwaota'i di'u marau ha'atee o'ani, “'A he'ua na aidangi di'u 'inia, 'inia 'iia ai'a ha'ausuringa'ini'i beigaaui mareho na 'igaau gau ha'ausuringa'ini'i?” ");
INSERT INTO aia_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mia Jisas 'a o'ani 'iniraau, “Ni taha nau maani'i ai'a mareho na dowai 'adoma'ini'i moi haariau, ma'ata ra'i 'adoma'ina'i a God na ha'ataariau mai. ");
INSERT INTO aia_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","'Iatei na mwa'emwa'e 'anai ha'isuriai hei'irisina God nai matai aidangisia 'onaa ha'ausuringa'i nau haa'i 'isi ra boi baania God, ma'uasi ra'i mareho na 'inau 'au 'adoma'ini'i moi haariau. ");
INSERT INTO aia_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","'Iatei na hadanga'ini'i taha na 'adoma'ini'i moi haaria, 'a 'irisia moi do 'iraaui noni rai ha'a-aneanea. Ma'ata 'iatei na haa'i mareho 'anai ha'a-aneanea mo'o na ha'ataaria mai, ni ha'atee ana'i ra ha'a-momori, ma ai'a ta pwari'i na'i beia. ");
INSERT INTO aia_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","'Ia Moses 'a haa'i ringeringe tana'amou, magu ai'a ta ta'i nei 'ini'amou na do'ai araisuri'i hako. Naasi, ni 'uaana namou raba ngahu ha'amaesiau 'inia!” ");
INSERT INTO aia_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Miraaui noni raugu o'ani 'inia, “I'oe 'e adaro na bwauni'o gasi! Ai'a ta nei nai 'unua do'a raba ngahu ha'amaesi'o!” ");
INSERT INTO aia_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Mia Jisas 'a o'ani 'iniraau, “'E ta'i ha'abu'oahu moi nau haua na'i dangi ni mamaro namou 'omesia ani, mamou heimwaota'i di'u'a 'iniai tau'aro nau hauasi. ");
INSERT INTO aia_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Me 'i'amou mou haua ro'u i tau'aro na'i dangi ni mamaro na'i 'oha namou suriai ringei aha ha'ara 'onaai 'unua ana Moses. (Na ringesi 'a ai'a huunai boi baania Moses. 'A taraawa'a mau mai na'i madoraa ana Ebraham.) ");
INSERT INTO aia_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","'Onaa na taha mai madoraa 'anai hauai ringei aha ha'ara tanaai gare ma to'o na'i dangi ni mamaro, moi haua'a 'onaai ringe ana Moses na 'unua. Hoita, 'onaa namou hauai ringei aha ha'ara na'i dangi ni mamaro, ma'ua mou haungarimoou 'inia na'i 'oha nau ha'agorohia aho'i noni na'i dangi ni mamaro? ");
INSERT INTO aia_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","'A ai'a goro 'anai hiiria raurau i noni na'i 'oha namou ai'a aidangisia goroi taha na haua, ma'ata 'a goro domoi sadoia ha'agorohia, neina 'ai odo-odo i hihiiri namoi haua.” ");
INSERT INTO aia_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Miraau tara'i saeni Jerusalem rau o'ani, “Naasia mo'o nara raba ngahu ha'amaesiasi? ");
INSERT INTO aia_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","'Ome, 'iia 'a ha-hadahada hurasi tanaraaui noni magu ai'a ta nei 'iniraaui na'otara agaa'i naigui heitohetohe beia. Gasi raugu 'iraraa do 'iia naasi Ha'atahi? ");
INSERT INTO aia_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","'A ga'i bwa'i o'asi, 'inia 'igaau hako gau 'iraraai dora na 'ia mo'osi 'a boi baania. 'Inia na Ha'atahi 'ai ha'amaranga moi, ma 'abwa'i tanei nai 'iraraai dora na boi iei.” ");
INSERT INTO aia_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mia Jisas 'a ha'atee raha ara'a na'i 'oha na ha-ha'ausuri raaui noni na'i Ruma Maea ana God, 'a o'ani, “Ha'amomori! Mou 'adoma'inia domou 'iraraau mamou 'iraraai dora nau boi iei. Ma'ata, 'inau 'au ai'a boi suriai 'adoma'igu haariau, 'e nei na ha'ataariau mai me 'iia naasi na ha'a-momori tarau. ");
INSERT INTO aia_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","'Inau 'au aidangisia mo'osi suria 'inau 'au boi baania, me 'iia na ha'ataariau mai tana'amou.” ");
INSERT INTO aia_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Miraau tara'i sae rau bonasiai daua 'anai ha'a-mama'aia magu bwara tanaraau suria 'a ai'a tari mau i madoraa. ");
INSERT INTO aia_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Me 'a ragoi noni nara goni na'i 'isi narau hinihinia'a na'i 'ohasi marau ha'atee o'ani, “'Iia gasi Ha'atahi! 'Inia 'abwa'i ta sae'a ro'u naigui haa'i tara'i mwani ha'abu'oahu di'ua ro'ua mo'osi!” ");
INSERT INTO aia_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na'i 'oha na 'iraaui Farisei rau rongoa do 'e mareho o'asi na 'iraaui noni rau hahaanata nga'inia 'inia Jisas, 'iraau Farisei beiraaui Na'ohadaa'i Piriisi rau ha'a-taariraaui hehei'oi narau 'omesuriai Ruma Maea 'anai daua Jisas. ");
INSERT INTO aia_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mia Jisas 'a o'ani 'iniraau, “'Inau wai awa gere madoraa moi bei'amou mawai 'ari aho'i'a beia mo'o na ha'ataariau maini. ");
INSERT INTO aia_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Moi towa'i sibaniau mamou bwa'i to'oagu, mana dora nawai awa iei, mou bwa'i matai taha iei.” ");
INSERT INTO aia_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Miraaui saemaua adaa'i Jiu ra kakui ahudaau hako marau o'ani, “Na'i hei gasi naigui 'arieisi nai bwara 'inia tanagaau 'anai sadoia? Gasi 'ai 'ari beiraau tara'i ai Jiu ta marau he'ete'i? 'Onaa 'abwa'i, ma'ai hanoriai awa beiraaui nei narau ai'a Jiu 'anai ha'ausuriraau! ");
INSERT INTO aia_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","'E taha gasi 'ado'ado 'anai mareho na 'unuasi, do gai towa'i sibania magau bwa'i matai to'oana, mana dora nai awa iei, gau bwa'i matai taha na'iei?” ");
INSERT INTO aia_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na'i ha'ahakonai dangi anai rongosi, ma naasi dangi na ororiu di'u, 'ia Jisas 'a ura ara'a ma totoro tanaraaui noni o'ani, “'Onaa namou raba gono mamoi boi beiau! ");
INSERT INTO aia_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","'Inia i Usu-usu Maea 'a o'ani, ‘'Iatei nai hinihiniau, na hurahurai waini tahi 'ai hurahura hura'a baania.’” ");
INSERT INTO aia_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Na'i 'oha na hadanga'iniai waini tahi, 'iia 'a hadanga'iniai Hi'ona Maea narai haua tanaraaui nei narau hinihinia. Na Hi'ona Maeasi ra ai'a haua mau tanaraau, suria 'ia Jisas ai'a mae mau ma ai'a suruta'e 'anai ara'a mau i aro.) ");
INSERT INTO aia_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na'i 'oha na 'iraaui noni rau rongoa o'asi, raugu ha'atee o'ani, “Ha'amomori, 'ia mo'osi naasi rarabea nagau mamasia.” ");
INSERT INTO aia_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tara'i nei rau o'ani, “'Iia naasi Ha'atahi.” Ma tara'i nei 'iniraau rau heitohe ro'u mau, marau o'ani, “Mou 'adoma'inia do ni Ha'atahi 'ai hura'a mai baaniai Galili? ");
INSERT INTO aia_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","'Inia na'i Usu-usu Maea ra 'unu ha'agorohia do ni Ha'atahi 'ai huta mai baaniai burungana Deved i mwaeraha. Mana'i Betlehem naasi 'omaa na 'ia Deved na huta iei.” ");
INSERT INTO aia_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mana mwane inoni ra ai'a to'oraai ta'i 'ado'ado 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ra'i nei rau raba daua 'anai ha'a-mama'aia maraugu ai'a ha'aagauhia. ");
INSERT INTO aia_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na'i 'oha narau aho'i mai sae hehei'oi na 'iraaui Piriisi mana Farisei ra ha'a-taariraau 'ari 'anai daua maia Jisas, ra songa'iniraaui sae hehei'oi o'ani, “Ni 'uaana namou ai'a waia mai 'inia?” ");
INSERT INTO aia_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Miraau aramiraau o'ani, “'Ei, ai'a ta sae namei rongoa mau do'ai mamaani tari o'asi.” ");
INSERT INTO aia_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Miraau haikou o'ani 'iniraaui sae hehei'oi, “'A 'ua? 'A rihota'ini'i ro'u 'adoma'imoo'i mamou hinihinia'a? ");
INSERT INTO aia_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","'A 'ua? 'E nei 'ini'ameu i na'otara ma'ua Farisei na hinihinia mo'osi? Ai'a na! ");
INSERT INTO aia_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Na kaeni ruruha hako rau hinihinia 'inia rau ai'a huunai aidangisiai ringe ana'ia Moses. Nigaraau mia God 'ai ha'a-mama'airaau!” ");
INSERT INTO aia_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ma'e ta'i 'iniraaui saemaua adaa'i Jiu, naasi 'ia Nikodimas, 'ia mo'o na boi ga'u haaria ani beia Jisas. 'Iia 'a ha'atee o'ani 'iniraau, ");
INSERT INTO aia_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Na ringe agaau 'a 'unua do gau bwa'i matai hiiriai noni na'i 'oha nagau ai'a rongo ha'agorohia mau ta mamaani beia.” ");
INSERT INTO aia_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Miraaugu ha'atee o'ani 'inia, “I'oe 'e ai Galili ro'u? 'Onaa 'oi 'ome riariaa goroi Usu-usu Maea, 'o ga'i 'omesia do ai'a do ta rarabea nai boi baaniai Galili.” ");
INSERT INTO aia_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Miraaugu hano 'anai aho'i 'ari suri'i ruma adaa'i. ");
INSERT INTO aia_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mia Jisas 'a 'ari aho'i hungahungai 'Oliv, ");
INSERT INTO aia_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","mana'i haho'oa ta'aa na'i nata dangi 'a aho'i 'ari Ruma Maea. Miraau mwane inoni rau goni hako mai. Mia Jisas 'a heinagu auru ma ha'ausuriraau. ");
INSERT INTO aia_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na'i 'oha na ha-hadahada mau, 'iraaui Ha'ausuri 'anai Ringe ana'ia Moses, miraaui Farisei rau waia mai urao ha'iwai narau sadoia na'i 'oha na taritari'a beiai sae he'ete'i, marau ha'a-urasia na'i maadaau hako inoni. ");
INSERT INTO aia_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Naasi marau o'ani 'inia Jisas, “Ha'ausuri, na uraoni ra sadoia na'i 'oha na taritari'a beiai sae he'ete'i. ");
INSERT INTO aia_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na'i ringe ana Moses, 'a 'unua do ra ga'i buta ha'amaesia mo'o nai haua o'asi. I'oe 'o 'adoma'i he'ua?” ");
INSERT INTO aia_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Rau hauai heisonga'isi suria rau raba sadoia ta maho dorai subunia Jisas 'inia. Mia Jisas 'a mwaoro auru ma usu-usu na'i ano 'iniai kaka'una. ");
INSERT INTO aia_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Na'i 'ohasi rau songa'inia wetewete moe'a, mia Jisas 'a ura arasi ara'a ma o'ani, “Hoita, moi buta'ia, ma'ata 'iatei na 'iraraa do 'a ai'a haua ta ta'i ora-ora'a, nai buta'ia 'iniai hau tahamora.” ");
INSERT INTO aia_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mia Jisas 'a mwaoro aho'i auru ma usu-usu ro'u 'iniai kaka'una na'i ano. ");
INSERT INTO aia_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Na'i 'oha na 'iraaui mwane 'ani raugu rongoa o'asi, marau haihanori hako baaniai dorasi, taraawa'a beiraaui sae wari. 'Iia moia Jisas mana uraosi nararugu awa 'isi. ");
INSERT INTO aia_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","'Ia Jisas 'a ura arasi aho'i ara'a ma o'ani 'iniai uraosi, “Neiraau hei mwane 'ani? 'A 'ua? Ai'a tanei 'iniraau naigui ha'a-mama'ai'o?” ");
INSERT INTO aia_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mana uraosi 'a o'ani, “'Agu ai'aa'a Araha.” Mia Jisas 'a o'ani 'inia, “'Inau bwa'i ha'a-mama'ai'o ro'u. 'Oi 'ariwou ma'oigu abui ora-ora'a'a ro'u.” ");
INSERT INTO aia_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","'Ia Jisas 'a o'ani 'iniraaui noni, “'Inau naasi bewaa tanaraaui saenai marewana. 'Onaa namoi suriau, mou bwa'i matai awa na'i kuhi, suria moi hano na'i bewaa nai wai'amou 'ari 'anai tahi tarau.” ");
INSERT INTO aia_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Miraaui Farisei rau ha'atee o'ani, “Na mwane mareho na'o 'unu'i 'ini'o 'o 'unu'i moi haari'o, naasi meu bwa'i hinihini'o!” ");
INSERT INTO aia_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mia Jisas 'a o'ani 'iniraau, “Rei'uaa na mareho nau 'unu'i 'isi 'au 'unu'i 'iniau haariau, ma'ata na mareho 'isi ra ha'a-momori. 'Inia 'inau 'au aidangisia na'i hei nau boi iei mana'i hei nau hano 'ana. 'I'amou ai'a 'iraraai dora nau boi iei, mana dora nawai 'ariei. ");
INSERT INTO aia_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","'I'amou mou hiiriai noni na'i wanawana 'onaai noni ni marewana moi. 'Inau ai'a hihiiri o'asi. ");
INSERT INTO aia_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ma 'onaa 'inau wai hihiiri, na hihiiri agua 'a ga'i ha'a-momori, 'inia 'inau ai'a hiiriai noni haariau, ma'ata 'ia Amagu na ha'ataariau mai 'a awa beiau. ");
INSERT INTO aia_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ni ringeringe amoou 'a o'ani, ‘'Onaa 'e waira rua rarui maaniai ta'i mamaani na'i kooti, ni marehosi 'a mena ma ha'a-momori.’ ");
INSERT INTO aia_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","'Inau 'au 'unu'i mareho 'iniau haariau, mana ruana naasi 'i Amagu na ha'ataariau mai.” ");
INSERT INTO aia_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Miraaugu songa'inia o'ani, “Nahei'a amamu?” Mia Jisas 'a aramiraau o'ani, “Mou ai'a aidangisiau, me mou ai'a aidangisia ro'ua Amagu, 'inia 'onaa namoi aidangisiau, ma naasi moigui aidangisia ro'ua Amagu.” ");
INSERT INTO aia_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","'Ia Jisas 'a 'unu'i mareho 'isi na'i 'oha na ha-ha'ausuri na'i raronai Ruma Maea ana God, gaarangiai dora ra nuga iei bakosi ni nuga ha'a. Ma ai'a tanei nai daua Jisas 'anai ha'amaesia, suria 'a ai'a tari mau i madoraa 'ana. ");
INSERT INTO aia_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mia Jisas 'a o'ani ro'u 'iniraau, “'Inau wai hano. 'I'amou moi sibaniau mamou bwa'i sadoiau mamoigui buna mae bei'i ora-ora'a amoo'i. Na dora na 'inau wai 'ariei mou bwa'i matai ataha na'iei.” ");
INSERT INTO aia_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Miraau na saemaua adaa'i Jiu raugu o'ani 'iniraau haariraau, “'A 'ua gasi? 'Ai ngahuia haaria? 'E taha gasi na 'adoma'inia na'i 'oha na 'unua do gau bwa'i matai ataha na'i dora na 'iia 'ai 'ariei.” ");
INSERT INTO aia_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mia Jisas 'a o'ani 'iniraau, “'I'amou baaniai ano, 'inau baaniai aro. 'I'amou anai marewana, 'inau ai'a anai marewana. ");
INSERT INTO aia_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Naasi tarana nau 'unua 'inia do 'i'amou moi mae bei'i ora-ora'a amoo'i. 'Onaa namou bwa'i hinihinia do 'inau 'iatei nau 'unua 'iniau, moi mae bei'i ora-ora'a amoo'i.” ");
INSERT INTO aia_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Miraau ha'atee o'ani 'inia, “'Oi 'unua tana'ameu, i'oe atei?” Mia Jisas 'a aramiraau o'ani, “'Inaua mo'o nau bwane 'unua tana'amou ani. ");
INSERT INTO aia_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'A ragoi mareho na 'inau 'au ga'i 'unu'i 'ini'amou, ma 'anai hiiri'amou 'ini'i, ma'ata 'au bwa'i. 'Inia 'inau wai 'unu'i moi tanaraaui noni i taha nau rongo'i beia mo'o na ha'ataariau mai. Mana taha na 'iia na 'unu'i ra ha'a-momori hako.” ");
INSERT INTO aia_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Miraau ai'a aidangisia do'ia Jisas 'a mamaani 'abaiai Amana tanaraau. ");
INSERT INTO aia_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mia Jisas 'a o'ani, “Na'i madoraa namoi nugaau ara'a i Gare Inoni na'i dadaahoro mamoigui aidangisia do 'inau i nei nau 'unua do 'inau, mamoigui aidangisia ro'u do 'inau ai'a ha'isuri'i 'adoma'igu haariau 'ini'i mareho nau haa'i. Mana mareho nau maani'i ra'i mareho na 'ia Amagu na 'unu'i tanaau. ");
INSERT INTO aia_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mana nei na ha'ataariau mai 'a awa tarau beiau, 'iia 'a ai'a nugasiau. 'Inia 'inau 'au haa'i tarau i taha na rabasia dowai haa'i.” ");
INSERT INTO aia_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mara ragoi nei narau hinihini na'i 'oha narau rongo'i mareho na 'ia Jisas 'a maani'i. ");
INSERT INTO aia_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mia Jisas 'a o'ani 'iniraaui Jiu narau hinihinia, “'Onaa namoi ha'isuri'i tarau i ha'ausuringa'i agu'i, 'i'amou ra'i rongoiusuri ha'a-momori agu'i. ");
INSERT INTO aia_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Moi aidangisiai taha na ha'a-momori, mana taha na ha'a-momori 'ai ha'a-dadara'amou.” ");
INSERT INTO aia_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Miraaugu o'ani 'inia Jisas, “'I'ameu ra'i warowarona'i a Ebraham, ma ai'a ta nei na'i marewanani namei ha'i slev tanaa. 'E taha na'o 'adoma'inia na'i 'oha na'o 'unua do'ai ha'a-dadara'ameu?” ");
INSERT INTO aia_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Mia Jisas 'a aramiraau o'ani, “'Inau wai 'unua ha'a-momori tana'amou, 'iatei na hauai ta'aa, 'iia 'e slev tanaai ora-ora'a. ");
INSERT INTO aia_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ni slev ra ai'a 'unua do 'iia 'e huunai gare anai bwauodo, ma'ata ni gare anai sae na bwauodo ra 'unua 'iniai huunai gare ana tarau'a. ");
INSERT INTO aia_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Naasi 'onaa ni Garena God 'ai ha'a-dadara'amou, 'i'amou moi dadara'a tarau'a. ");
INSERT INTO aia_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ha'amomori! 'Au 'iraraa do rei'uaa na 'i'amou ra'i warowarona'i a Ebraham, me tara'i abe 'ini'amou mou raba ngahu ha'amaesiau, suria mou ai'a dau'i ha'ausuringa'i agu'i. ");
INSERT INTO aia_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","'Inau 'au maani'i tana'amou i mareho nau 'omesi'i na'i 'oha nau awa beia Amagu. Mi'amou mou suri'i ha'ausuringa'i ana amamoou.” ");
INSERT INTO aia_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Miraaugu 'unu ha'arangasia hura'a o'ani, “'Ia Ebraham naasi amameeu.” Mia Jisas 'agu o'ani 'iniraau, “'Onaa 'ia Ebraham naasi amamoou, mou ga'i ha'isuri'i herehere goro ana'i. ");
INSERT INTO aia_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","'Inau 'au 'unu'i tana'amoui mareho nara ha'a-momori nau rongo'i beia Amagu, mamougu raba ngahu ha'amaesiau. 'Ia Ebraham 'a bwa'i haa'i here o'asi. ");
INSERT INTO aia_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Naasi 'a ha'ata'inia domou suria amamoou na'i 'oha namou hau'i here 'isi.” Miraau ha'atee o'ani 'inia, “'Ia God moi naasi huunai amameeu, mi'ameu ra'i huudi gare ana'i.” ");
INSERT INTO aia_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Mia Jisas 'a o'ani 'iniraau, “'Onaa 'ia God naasi Amamoou, 'i'amou mou ga'i ta'ahiau, suria na dio mai nau haa bei'amou, 'au boi baania God. 'Inau ai'a boi suriai 'adoma'igu haariau, ma'ata 'ia Ama na ha'ataariau mai. ");
INSERT INTO aia_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ni 'uaana namou ai'a aidangisi'i 'ini'i mareho nau hadanga'ini'i? 'A o'asi suria mou ai'a raba ha'isuri'i ha'ausuringa'i agu'i! ");
INSERT INTO aia_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","'I'amou amamoou 'ia Saetan. Na mareho ta'a'i na haa'i, na'isi mareho namou raba haa'i. Taraawa'ana mau mai, 'iia 'e inoni hahaingahu ma 'itaai taha na ha'a-momori suria 'iia 'a honu 'iniai pwari'i. Mana'i 'oha nai pwari'i, 'e mareho goro moi tanaa, suria 'iia 'e sae 'anai pwari'i, me 'iia 'e amadaaui mwane pwari'i hako. ");
INSERT INTO aia_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Naasi na'i 'oha nau hadanga'ini'i taha nara ha'a-momori, 'i'amou ai'a hinihiniau, suria 'i'amou ra'i gare ana'i! ");
INSERT INTO aia_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","'Iatei 'ini'amou nai matai ha'ata'inia hura'a do 'inau 'au ora-ora'a? Ma 'onaa nau ha'a-momori, ma 'ua namou ai'a hinihiniau 'inia? ");
INSERT INTO aia_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","'Iatei na ha'i garena God, 'a wa'ewa'e 'anai bahurongo'i ha'atee ana'ia God, mana'i 'oha namou ai'a, 'a ha'ata'inia do 'i'amou ai'a gare ana'ia God.” ");
INSERT INTO aia_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Miraaui saemaua adaa'i Jiu raugu o'ani 'inia, “'Agu ai'a 'ome bwara'a! I'oe 'e sae ni Samaria ma'e adaro na bwauni'o!” ");
INSERT INTO aia_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mia Jisas 'a o'ani 'iniraau, “'Inau ai'a adaro nai bwauniau. 'Inau 'au ha'ahoua Amagu me 'i'amou mou ai'a ha'ahouau. ");
INSERT INTO aia_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","'Inau ai'a bonasia dorai ha'ahauasaau, ma'ata 'e nei na raba ha'ahauasaau, mia mo'osi naasia mo'o na hihiiri odo-odo. ");
INSERT INTO aia_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","'Inau wai 'unua ha'a-momori tana'amou, 'iatei nai ha'isuri'i ha'ausuringa'i agu'i, 'a bwa'i mae!” ");
INSERT INTO aia_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Miraaui noni raugu o'ani, “Naasi meugu 'iraraa goro do'e adaro mora na bwauni'o. 'Ia Ebraham miraaui rarabea rau mae, mi'oe 'o 'unua do tanei nai ha'isuri'i ha'ausuringa'i amu'i, 'a bwa'i mae! ");
INSERT INTO aia_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","'O 'adoma'inia do i'oe 'o ororiu di'uai wauwa agaaua Ebraham, miraaui rarabea narau bwane mae'a? I'oe 'o 'adoma'inia do i'oe atei?” ");
INSERT INTO aia_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mia Jisas 'a o'ani 'iniraau, “'Onaa na 'inau haariau moi nau ha'ahauasaau haariau, ma ni mareho nau hauasi 'e mareho haaria moi. Me 'ia mo'o na ha'ahauasaau naasi Amagu, 'ia mo'o namou 'unua do 'iia naasi God amoou. ");
INSERT INTO aia_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ma rei'uaa namou 'unua do 'iia naasi God amoou, me 'i'amou ai'a gere aidangisia moe'a. 'Inau nau aidangisia goro. Ma 'onaa nawai 'unua do 'inau ai'a aidangisia, ma naasi 'inau wai pwari'i 'onaaiamou'a na. Me 'inau 'au aidangisia Amagu, mau araisuri'i ha'atee ana'i. ");
INSERT INTO aia_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","I amamoou a Ebraham 'a wa'ewa'e 'oha na 'adoma'iniai 'oha do 'inau wai boi. Mana 'oha na 'omesiai boi agua, 'a wa'ewa'e 'inia.” ");
INSERT INTO aia_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Miraaugu o'ani 'inia, “Na harisimu ai'a gere tari moe'a i rima tangahuru ma'o 'unua'asi do muru hairee'i!” ");
INSERT INTO aia_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mia Jisas 'a o'ani, “Ha'amomori, 'inau wai 'unua tana'amou, 'oha 'ia Ebraham ai'a awa mau, 'inau bwani awa!” ");
INSERT INTO aia_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Na'i 'ohasi 'iraaui noni raugu si'o hau 'anai buta'ia. Mia Jisas 'a bainihu ta'iniraau, ma kumusi hura'a baaniai Ruma Maea ana God. ");
INSERT INTO aia_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na'i 'oha na 'ia Jisas 'a 'ari wou, 'a 'omesiai sae na huta ha'i kuru. ");
INSERT INTO aia_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Miraaui rongoiusuri ana'ia Jisas raugu songa'inia o'ani, “Ha'ausuri, ni 'uaana nagu huta ha'i kuru 'inia mo'osi? 'E 'inona haaria nagu o'asi 'iniasi, ma'ua 'e 'inona amana mea inana?” ");
INSERT INTO aia_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mia Jisas 'a aramiraau o'ani, “Ni kuru na to'iasi, ai'a do 'a kuru 'iniai 'inona, ma'ua 'inona amana mia inana. 'Iia 'a kuru do neina 'ia God 'ai ha'ata'iniai mena ana na'i tau'aro goro nai haua tanaa na'i tahitahi ana. ");
INSERT INTO aia_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Na'i 'oha na ai'a rodo mau, gai haa'i tatau'aro ana'ia mo'o na ha'ataariau mai, 'inia na rodo 'a raumwadu na bwa'i sae naigui haa ta tau'aro. ");
INSERT INTO aia_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na'i 'oha na 'inau awa mau na'i marewanani, 'inau naasi bewaa tanaraaui noni nai marewana.” ");
INSERT INTO aia_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mana'i 'oha na 'ia Jisas 'a ha'atee o'asi hako, 'a ngisu dioi ano. 'A dorariai mwagiro beiai ngisungisuna, ma tarohiai maana'i mo'osi 'iniai mwagirosi. ");
INSERT INTO aia_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Naasi ma o'ani 'inia, “'Oi 'ari ma'oi aromaa na'i oboi wai ra 'unua 'inia Saeloam.” (Mana 'ado'ado 'anai Saeloam naasi “ra ha'ataaria 'ari.”) Na'i 'oha na 'ia mo'osi 'a 'ari ma aromaa hako na'i oboi waisi, 'agu aho'i mai na'i 'omaa ana ma wanawana'a. ");
INSERT INTO aia_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Miraaui nei rau mono gaarangia mo'osi, ma tara'i nei narau 'iraraa do 'iia naasi sae kuru na haha'angoni ha'a ani, raugu heisosonga'i hairiu o'ani, “Naasi sae na kuru na heheinagu 'anai ha'angoni ha'a ani?” ");
INSERT INTO aia_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tara'i nei rau 'unua do 'iia, ma tara'i nei rau o'ani, “Ai'a, 'e sae he'ete'i na, magu 'ome 'onaaia moi!” Mana nei na haha'angonisi 'agu o'ani, “'Inau na, 'inau moi!” ");
INSERT INTO aia_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Maraugu songa'inia o'ani, “Ma 'a he'ua na'ogu wanawana 'inia? 'Iatei na ha'a-wanawana'o?” ");
INSERT INTO aia_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mia o'ani 'iniraau, “'E sae nara 'unua 'inia Jisas na hauai mwagiro ma tarohia suri'i maagu, ma 'unua tanaau 'anai 'ari arohiai maagu na'i oboi wai na'i Saeloam. Hoita, na'i 'oha nau 'ari naugu aromaa na'i waisi, naasi mau wanawana'asi!” ");
INSERT INTO aia_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Miraaugu songa'inia ro'u o'ani, “Ma naheia mo'osi?” Miagu aramiraau o'ani, “'Inaugu ai'a 'iraraa'a.” ");
INSERT INTO aia_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Naasi maraugu waia mo'osi 'ari tanaraaui Farisei. ");
INSERT INTO aia_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Mana'i dangi na 'ia Jisas 'a ha'agorohiai saesi, 'e dangi ni mamaro. ");
INSERT INTO aia_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Miraau na Farisei raugu sosonga'inia 'iniai taha na to'o. Mia o'ani 'iniraau, “Na'i 'oha na tarohi'i maagu hako 'iniai mwagiro, 'a 'unua dowai 'ari arohiai maagu na'i oboi wai na'i Saeloam. Na'i 'oha nau 'ariwou mau aromaa hako, mau wanawana'asi.” ");
INSERT INTO aia_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ma tara'i Farisei rau o'ani, “'Ia mo'osi 'a ai'a boi baania God, suria 'a tau'aro na'i dangi ni mamaro.” Ma tara'i nei ra o'ani, “'Onaa 'e sae ora-ora'a moi, ma'ua na haua 'inia i ha'abu'oahu o'asi?” Na'i 'ohasi, 'e kae heihoa na to'o na'i ahoaadaau hairiu. ");
INSERT INTO aia_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Miraaugu songa'inia ro'ua mo'o na huta ha'i kurusi o'ani, “I'oe 'o 'unua do 'ia mo'osi na ha'a-wanawana'o. I'oe 'o 'adoma'i he'ua 'inia mo'osi?” Miagu aramiraau o'ani, “'Inau 'au 'adoma'inia do 'iia 'e rarabea.” ");
INSERT INTO aia_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Naasi miraaui saemaua adaa'i Jiu raugu ai'a raba hinihini'a ro'u do'ia mo'osi 'a kuru ga'u. Naasi marau soia inana mana amana, ");
INSERT INTO aia_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","rau songa'inirarua o'ani, “'A ha'amori do'e gare amurua na huta ha'i kuru naanisi? Ma'ua nagu wanawana 'inia?” ");
INSERT INTO aia_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mia inana mana amana mo'osi raru o'ani, “Miria miri 'iraraa do'e gare amiria na huta ha'i kuru. ");
INSERT INTO aia_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mana 'iraraai taha nagu taarai wanawana 'inia, ma'ua 'iatei nagu ha'agorohia, na miri ai'a mataia. 'Iia 'a mwanemaua'a, 'a matai hadahada haaria. Moi songa'inia mai mamaani haaria.” ");
INSERT INTO aia_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Raru ha'atee o'asi, suria raru mamaa'usiraaui saemaua adaa'i Jiu, 'inia 'iraau rau bwani 'unua do 'onaa tanei nai 'unua do'ia Jisas naasi Ha'atahi, rai ha'aabua 'anai siri suri'i ruma ni ha'arahesi 'anai rihunga'i. ");
INSERT INTO aia_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tarana naasi nararu 'unua 'inia dorai songa'inia maai mamaani haraaria. ");
INSERT INTO aia_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Naasi marau 'unua aho'i ro'u siri maia mo'o na huta ha'i kurusi marau o'ani 'inia, “'Oi duruduru na'i maana God doni mareho na'oi 'unu'i rai ha'a-momori, 'inia 'i'ameu meu 'iraraa do 'ia Jisas 'e inoni ora-ora'a.” ");
INSERT INTO aia_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mia o'ani 'iniraau, “'Inau ai'a 'iraraa gasi 'e inoni ora-ora'a ma'ua ai'a. Ni mareho moi nau 'iraraa naasi, 'inau 'au huta ha'i kuru, mana'i 'ohani 'au matai wanawana'a!” ");
INSERT INTO aia_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Miraau o'ani 'inia, “'E taha na haua, ma here he'ua 'oha na ha'agorohi'o?” ");
INSERT INTO aia_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mia mo'osi 'a o'ani 'iniraau, “Mou ai'a bwane rongoai 'unua agua ani? Ni 'uaana namougu raba rongoa ro'u 'inia? 'A 'ua? Mou raba ha'i rongoiusuri ana ro'u?” ");
INSERT INTO aia_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Naasi marau ha'atee ha'ata'aia mo'osi, marau o'ani, “I'oe naasi rongoiusuri ana, 'i'ameu ai'a! 'I'ameu ra'i rongoiusuri ana'ia Moses. ");
INSERT INTO aia_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","'I'ameu 'iraraa do'ia Moses naasia mo'o na 'ia God na hadahada beia, me 'ia mo'osi, ai'a ta ta'i maho namei 'iraraa 'inia. Rei'uaa dora na boi baania, meu ai'a 'iraraa ro'u.” ");
INSERT INTO aia_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mana saesi 'a ha'atee o'ani, “'Ini 'uaana? 'Au kaeni heimwaota'i di'u 'ini'amou! 'Iia na ha'a-wanawanaausi, mamougu 'unua domou ai'a 'iraraai dora na boi baania! ");
INSERT INTO aia_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","'Igaau gau 'iraraa do'ia God 'a bwa'i matai arami'i ha'arahesi adaa'i noni ora-ora'a, ma'ata 'a wa'ewa'e 'anai aramiraaui nei ra ha'ahoua marau ha'isuriai hei'irisina. ");
INSERT INTO aia_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Na'i taraawa'a na haua mai marewana, ai'a do ta sae nagai rongoa do'ai ha'a-wanawanaa aho'i tanei nai huta ha'i kuru. ");
INSERT INTO aia_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Naasi 'ia mo'osi 'a bwa'i matai haua o'asi 'onaa na ai'a boi baania God.” ");
INSERT INTO aia_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Miraaugu o'ani 'inia, “Taraawa'a mau mai 'oha na'o huta 'o honu 'ini ora-ora'a, ma'ogu raba ha'ausuri'ameu aho'i!” Naasi rau asihura marau taaria hura'a baaniai ruma ni ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","'Oha na 'ia Jisas 'a rongoai mareho na to'osi, 'a heisadoi beia mo'osi ma songa'inia o'ani, “'A 'ua? 'O hinihiniai Garei Inoni?” ");
INSERT INTO aia_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mia mo'osi 'agu o'ani 'inia, “Saemaua, 'oi ha'a-aidangisiau 'inia mo'osi mawai hinihinia.” ");
INSERT INTO aia_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mia Jisas 'agu o'ani 'inia, “'Iia na'o 'omesia'asi, 'iia namuru ta'i ha-hadahada na'i 'ohanisi.” ");
INSERT INTO aia_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Na'i mau 'ohasi mana saesi 'a topira'i ruru auru tanaa Jisas ma o'ani, “Araha, 'inau hinihini'a!” ");
INSERT INTO aia_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mia Jisas 'a o'ani 'inia, “'Inau 'au boi 'anai hiiriai marewana. 'Iraaui nei ra kuru rai 'ome'ome, miraaui nei narau 'adoma'inia dorau 'ome'ome, raigui aidangisia do 'iraau rau kuru.” ");
INSERT INTO aia_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Miraaui Farisei narau ura 'isi na'i 'ohasi raugu o'ani 'inia, “'A 'ua? I'oe 'o 'unua do 'i'ameu meu kuru ro'u?” ");
INSERT INTO aia_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Mia Jisas 'a o'ani 'iniraau, “'Onaa namou ga'i kuru, mou ga'i bwa'i haai ora-ora'a namou hauasi. Mana 'unua amoou domou 'ome'ome nagu ha'ata'inia 'inia doni ora-ora'a amoo'i ra awa mau bei'amou.” ");
INSERT INTO aia_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Mia Jisas 'a ha'atee o'ani, “'Inau wai 'unua ha'a-momori tana'amou, 'iatei nai hane aharau na'i barai siip, ma ai'a siri na'i maanai bara, 'iia 'e sae beriberi! ");
INSERT INTO aia_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","'Inia na nei na huunai 'omesuri siip, 'ai siri ma'ata'a na'i maanai bara. ");
INSERT INTO aia_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na nei na 'omesuriai bara 'ai tahangiai maanai bara tanaa, miraaui siip rau rongo 'iraraai ringena marau boi beia. 'A 'unu'i atadi siip ana'i ma wairaau hura'a. ");
INSERT INTO aia_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Na'i 'oha na soi goniraau hakoi siip ana'i, 'a na'otaradaau, miraau suria 'inia rau rongo 'iraraai ringena. ");
INSERT INTO aia_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Me 'onaa ta sae he'ete'i nai 'unuraau mai, rai horata'inia. 'Inia rau bwa'i taraa to'o suria moi sae he'ete'i narau ai'a matanga'i rongoai ringena.” ");
INSERT INTO aia_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","'Ia Jisas 'a hauai heiha'auusi tanaraau, miraaui noni rau ai'a aidangisiai taha na bonasiai ha'ausuriraau 'inia. ");
INSERT INTO aia_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Naasi magu ha'atee o'ani ro'u, “'Inau wai 'unua ha'a-momori tana'amou, 'inau naasi maanai barai siip. ");
INSERT INTO aia_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tara'i nei nara boi na'o 'iniau rau 'onaai sae beriberi, 'inia rau here ha'a-ta'airaaui noni 'ini'i ha'ausuringa'i pwapwaari'i adaa'i. Me ni siip agu'i rau ai'a araisuriraau. ");
INSERT INTO aia_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","'Inau naasi maanai barai siip. 'Iatei nai boi beiau 'anai siri na'i raronai bara wai ha'atahia. 'Iia 'ai dadara'a 'onaai siip na matai hano hairiu 'anai siba 'ana mahoingau. ");
INSERT INTO aia_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na sae beriberi 'a boi moi 'anai beri, heingahu, ma 'anai hereta'aa. 'Inau 'au boi 'anai hauai huunai tahi tanaraaui noni, tahitahi na honu 'ini'i mwane mareho goro. ");
INSERT INTO aia_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“'Inau naasi 'omesuri siip goro. 'I nei na 'omesuri siip goro 'a mwa'emwa'e 'anai mae 'ini'i siip. ");
INSERT INTO aia_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Na nei nara horia moi 'anai 'omesuri, 'a matai hora moi na'i 'oha nai 'omesiai misu tari na boi 'anai ngaa'i siip. 'Iia 'a matai hora moi baani'i, suria 'iia ai'a to'ora'i siip 'isi, me 'iia 'a ai'a huunai sae 'omesuri siip. Mana'i 'oha nai hora, na misu tari 'ai tariha'ini'i siip, mana siip rai 'adarara. ");
INSERT INTO aia_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na nei nara horia 'anai 'omesuri 'a hora suria 'iia ra horia moi 'anai 'omesuri, ai'a do 'a huunai 'adoma'i ororiu 'ini'i siip. ");
INSERT INTO aia_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“'Inau naasi 'omesuri siip goro minau mwa'emwa'e 'anai mae 'ini'i siip agu'i. 'Inau 'au 'irara'i siip agu'i, mana siip agu'i ra 'iraraau ro'u. 'A 'onaai 'iraraau ana Amagu, minau 'iraraa ro'u a Ama. ");
INSERT INTO aia_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na'i raronai bara, ra'i siip agu'i ra ai'a awa mau na'iei na 'inau wai wairaau ro'u mau mai. 'Iraau rai rongo 'iraraai ringegu. Rai ha'i ta'i ruruhai siip, marai to'oraai ta'i 'omesuri. ");
INSERT INTO aia_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“'Ia Amagu 'a huunai ta'ahiau suria 'au mwa'emwa'e 'anai wateai tahingagu 'anai mae. 'Au wateai tahingagu neina 'inau wai matai tahi aho'i ro'u. ");
INSERT INTO aia_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","'A bwa'i nei nai matai ha'amaesiau 'onaa 'inau 'au bwa'i wateau. 'Inau 'au wateai tahingagu dadara'a. 'Inau nau to'oraai mena 'anai watea, mau to'oraai mena 'anai tahi aho'i, 'inia naasi taha na 'ia Amagu 'a ha'atoraau 'inia.” ");
INSERT INTO aia_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na'i 'oha na 'unu'i mareho 'isi, 'iraaui Jiu 'a heiruarua'a i 'ado'adodaa'i 'ini'i. ");
INSERT INTO aia_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tara'i nei 'iniraau rau o'ani, “'Ia mo'osi 'e adaro na bwaunia ma bweu'asi. Moi abui bahurongo'i mareho na maani'i.” ");
INSERT INTO aia_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ma tara'i nei 'iniraau rau o'ani, “Ra ai'a rongo o'asi sae ra bwaunira i adaro. Ni adaro 'a bwa'i matai ha'a-'ome'omeai sae na huta ha'i kuru!” ");
INSERT INTO aia_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ma tari mai madoraa ni wanusi. 'Ia Jisas 'a awa na'i Jerusalem na'i 'oha nara hauai rongo 'anai 'adoma'i aho'isiai 'oha nara tahangiai Ruma Maea ana God. ");
INSERT INTO aia_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mana'i raronai Ruma Maea, 'ia Jisas 'a 'ariwou na'i dora nara 'unua 'iniai Abaihare ana Solomon. ");
INSERT INTO aia_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Miraaui saemaua adaa'i Jiu rau goni wou hunia marau o'ani 'inia, “'I'ameu 'a kakui ahumeeu orea'a mai 'ini'o. 'Onaa i'oe naasi Ha'atahi, ma'oi 'unua ha'a-momori tana'ameu.” ");
INSERT INTO aia_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mia Jisas 'a o'ani 'iniraau, “'Inau bwane 'unua tana'amou memou ai'a hinihiniau. Ni mwane mareho nau hau'i beiai mena ana Amagu naasi nara ha'ata'inia hura'a do 'inaua tei. ");
INSERT INTO aia_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mou ai'a hinihiniau suria mou ai'a aba 'ini'i siip agu'i. ");
INSERT INTO aia_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Na siip agu'i ra rongo 'iraraai ringegu. 'Inau 'irararaau, miraau rau suriau. ");
INSERT INTO aia_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","'Inau 'au hauai tahi tarau tanaraau, miraau rau bwa'i siri na'i mae tarau. 'A bwa'i nei nai hasuiraau baaniau, ");
INSERT INTO aia_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","'inia 'ia Amagu na wateraau mai tanaau, me 'iia 'a wetewete ma mena di'u'i mwane mareho hako. Naasi, 'a bwa'i nei nai matai hasuiraau hura'a baania Amagu. ");
INSERT INTO aia_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","'Inau mea Amagu 'e ta'i.” ");
INSERT INTO aia_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Na'i 'ohasi, 'iraaui saemaua adaa'i Jiu rau si'o hau ro'u dorai buta ha'amaesia. ");
INSERT INTO aia_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mia Jisas 'a o'ani 'iniraau, “'Inau 'au hau'i mwane mareho goro na 'ia Amagu na 'unu'i tanaau. 'E nei he'ua 'ini'i tatau'aro goro 'isi namou raba ha'amaesiau 'inia?” ");
INSERT INTO aia_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Miraau o'ani 'inia, “'I'ameu ai'a raba buta'i'o 'ini'i mareho goro na'o haa'i, me 'o hadahada ha'ata'aia God. I'oe 'e taraani noni moi ma'ogu 'unua haari'o do i'oe God!” ");
INSERT INTO aia_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mia Jisas 'a o'ani ro'u 'iniraau, “Na'i Usu-usu Maea agaau ra usua dio do'ia God 'a o'ani 'iniraau tara'i na'otara, ‘'I'amou ra'i god.’ ");
INSERT INTO aia_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mana mareho na awa dio na'i Usu-usu Maea 'a ha'a-momori tarau. Naasi, 'onaa 'iraaui nei narau dau'i ha'atee ana'ia God ra 'unu god 'iniraau, ");
INSERT INTO aia_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ni 'uaana namou 'unua 'inia do'au ha'atee ha'ata'aia God na'i 'oha na 'inau 'au 'unua do 'inau 'e gare ana moi? 'Inia 'inau naasi nei na 'ia God na 'ome sigihiau ma ha'ataariau mai na'i marewana. ");
INSERT INTO aia_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","'Onaa na 'inau ai'a hau'i taha na 'ia Amagu na haa'i, mamoi abui hinihiniau. ");
INSERT INTO aia_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ma 'onaa nau haa'i taha 'ia Amagu na hau'i, rei'uaa namou ai'a hinihini'i ha'atee agu'i, me moi hinihini'i taha nau haa'i mamoigui tano aidangisia do 'ia Ama 'e ta'i beiau, me 'inau 'e ta'i beiai Ama.” ");
INSERT INTO aia_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Na'i 'ohasi rau raba daua ro'u 'anai hiiria magu bwara, 'ia Jisas 'a hano moi baaniraau. ");
INSERT INTO aia_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mia Jisas 'a aho'i 'ari nata bataraui wai rahai Jodan, ma awa na'i dora na 'ia Jon na bwa-bwareomaearaau ga'u i sae. ");
INSERT INTO aia_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma ra ragoi noni ra boi beia. Miraaugu o'ani 'iniraau hairiu, “'Ia Jon 'a ai'a haa'i tara'i ha'abu'oahu, ma'ata na mwane mareho na 'unu'i 'inia mo'oni ra ha'a-momori hako.” ");
INSERT INTO aia_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mana'i 'ohasi, rau ragoi nei narau hinihinia. ");
INSERT INTO aia_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ma'e sae na atana 'ia Lasarus 'a daoha. 'Iia 'a awa na'i Betani beiraruai rua asina, 'ia Meri mea Maata. ");
INSERT INTO aia_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","'Iiasi a Meri, naasi Meri na erisiai bei rumu na si'ini goro na'i uwana'ia Jisas, ma ha'amaha'i 'iniai warihuna. ");
INSERT INTO aia_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mia Meri mea Maata raru ha'ataari hadahada 'ari tanaa Jisas o'ani, “Araha, na nei na'o ta'ahia di'u 'a daoha.” ");
INSERT INTO aia_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Na'i 'oha na'ia Jisas 'a rongoa, 'a o'ani, “Ni daoha na to'ia Lasarus 'a bwa'i maesia. 'Iia 'a daoha neina mena ana God 'ai ha'ata'i marai ha'a-aneaneai Garena 'inia.” ");
INSERT INTO aia_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ma rei'uaa na 'ia Jisas 'a ta'ahia Maata mea Meri mea Lasarus, ");
INSERT INTO aia_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","'iia 'a awa ro'u mau suriai rua dangi na'i dora na awa 'ieisi. ");
INSERT INTO aia_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ma o'ani 'iniraaui rongoiusuri ana'i, “Gau magai aho'i 'ari Jiudea.” ");
INSERT INTO aia_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Miraaui rongoiusuri ana'i rau ha'atee ha'abwarasia o'ani, “Ha'ausuri, na'i moi dangi ani narau raba buta ha'amaesi'o i saemaua adaa'i Jiu, ma'o 'unua'a do gai 'ari aho'i ro'usi?” ");
INSERT INTO aia_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Mia Jisas 'a o'ani 'iniraau, “Na dangi 'a marewa suriai ta'i tangahuru mana rua 'aoa. Naasi 'onaa 'iatei nai hahano na'i dangi, 'a bwa'i tora'i, 'inia na sina 'a bewaasia. ");
INSERT INTO aia_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Me 'onaa nai hano na'i rodo, 'iia 'a matai tora'i suria 'a ai'a marewa.” ");
INSERT INTO aia_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Naasi ma ha'atee o'ani, “I geresae agaaua Lasarus 'a mauru'a, ma'ata 'inau wai 'ari mawai ha'araia.” ");
INSERT INTO aia_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Miraaui rongoiusuri ana'i rau o'ani 'inia, “Araha, 'onaa na mauru moi, me 'a ha'ata'inia do 'iia 'ai goro moi.” ");
INSERT INTO aia_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Rau ha'atee o'asi suria rau 'adoma'inia do 'ia Lasarus 'a mauru mora moi, ma'ata 'ia Jisas 'a 'iraraa do'a mae'a. ");
INSERT INTO aia_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Naasi magu 'unu ha'agorohia o'ani tanaraau, “'Ia Lasarus 'a mae'a. ");
INSERT INTO aia_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Me 'ini'amou, 'a goro do'au ai'a awa 'oha na mae, 'inia naani'a i madoraa goro tana'amou 'anai nugaai hinihinimoou beiau. Boi, magai 'ari 'omesia.” ");
INSERT INTO aia_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mia Tomas, 'ia mo'o nara 'unua 'iniai 'Iu, 'a o'ani 'iniraau hakoi rongoiusuri, “Gau magai 'ari, magai mae ro'u beia Jisas.” ");
INSERT INTO aia_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na'i 'oha na 'ia Jisas 'a ataha woui Betani, rau 'unua tanaa do'e hai dangi na hako'a murinai aoraa ada Lasarus na'i wabwa. ");
INSERT INTO aia_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","I Betani 'a ga'i 'onaai oru kilomita moi baaniai Jerusalem. ");
INSERT INTO aia_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma naasi ra ragoi Jiu nara boi 'anai ada'imae mara bonasiai ha'a-aro'i ahudaru'i a Meri mea Maata 'iniai koadarua na mae. ");
INSERT INTO aia_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Na'i 'oha na 'ia Maata 'a 'iraraa do'ia Jisas 'a gaarangi ataha, 'a hura'a 'anai heisadoi beia. Na'i 'ohasi 'ia Meri 'a awa moi siri na'i ruma. ");
INSERT INTO aia_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mia Maata 'a o'ani 'inia Jisas, “Araha, 'onaa na'o ga'i bwane awa 'ini, ni koagua Lasarus 'a ga'i bwa'i mae. ");
INSERT INTO aia_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma'ata rei'uaa na'i 'ohani, 'au 'iraraa do'ia God 'ai matai haua tana'o i taha na'oi ha'angonia 'inia.” ");
INSERT INTO aia_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mia Jisas 'a o'ani 'inia Maata, “'Ia koamu 'ai suruta'e aho'i.” ");
INSERT INTO aia_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mia Maata 'a o'ani 'inia, “'Io, 'au 'iraraa do'ai suruta'e aho'i beiraaui nei narai suruta'e aho'i na'i ha'ahakonai dangi.” ");
INSERT INTO aia_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Mia Jisas 'a 'unua tanaa, 'a o'ani, “'Inau naasi nei 'anai ha'a-suruta'eraau aho'i noni ma 'anai haua tanaraau i tahi tarau. 'Iatei nai hinihiniau, rei'uaa nai mae, 'iia 'ai tahi mau. ");
INSERT INTO aia_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mia tei na tahi ma hinihiniau, 'ai dauai tahi tarau. 'O hinihiniai mareho nau 'unuasi Maata?” ");
INSERT INTO aia_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mia Maata 'a o'ani 'inia Jisas, “'Io Araha, 'inau 'au hinihini do i'oe naasi Ha'atahi, 'i garena God nameu 'adoma'inia do'ai boi marewana.” ");
INSERT INTO aia_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Naasi mia Maata 'a hano baania Jisas, ma aho'i 'ari beia Meri. 'A siriwou na'i ruma ma waia beira'i a Meri ma o'ani 'inia, “Na ha'ausuri 'a ada'a magu raba re'i'o.” ");
INSERT INTO aia_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","30","Na'i 'ohasi 'ia Jisas 'a awa mau bohura'a 'iniai 'omaa na'i dora na 'ia Maata 'a heisadoi beia ei. Hoita, 'ia Meri 'a suruta'e raharaha moi ma hura'a 'anai 'ari heisadoi beia Jisas. ");
INSERT INTO aia_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na'i 'oha narau re'ia o'asi, 'iraaui sae narau awa beia 'anai bonasiai ha'a-aroahuna, rau suruta'e ro'u marau suria hura'a, 'inia rau 'adoma'inia do 'ai 'ari hera 'anai angi na'iei. ");
INSERT INTO aia_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","'Ia Meri 'a hura'a ma 'ari odo-odo na'i dora na 'ia Jisas 'a awa iei. Mana'i 'oha na 'omesia Jisas, 'a 'ariwou ma topiruru auru tanaa ma o'ani, “Araha, 'onaa na'o ga'i bwane awa 'ini, ni koagua Lasarus 'a ga'i bwa'i mae!” ");
INSERT INTO aia_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mia Jisas 'a re'iai 'omehana Meri 'oha na angiangi, miraau ro'u i sae narau suria rau angi ro'u. 'Ia Jisas 'a ahutotou di'u, ma ta'aai tahingana, ");
INSERT INTO aia_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ma o'ani, “Na'i hei namou nugaa ieia Lasarus?” Miraau o'ani 'inia, “Araha, gai 'ari ma'oi 'omesia.” ");
INSERT INTO aia_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mia Jisas 'a angi. ");
INSERT INTO aia_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Miraaui nei narau ura gaarangi rau o'ani, “Moisu 'omesiai ta'ahia na haua.” ");
INSERT INTO aia_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma tara'i nei ra o'ani, “'Ia mo'osi 'a ha'a-'ome'omeai sae kuru. Ni 'uaana na ai'a boi 'inia 'anai ha'agorohia aho'i a Lasarus neina 'ai abui mae?” ");
INSERT INTO aia_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mia Jisas 'a ataha na'i dora nara toringia iei abena Lasarus ma ahutotou di'u. Mana dorasi, 'e wabwa nara ha'abwarasiai maana 'iniai hau. ");
INSERT INTO aia_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Mia Jisas 'a o'ani 'iniraau, “Moi rahia baira'i hausi baaniai maanai wabwa.” Mia Maata, asina mo'o na maesi, 'a ha'atee o'ani, “Araha, 'ai si'ini ta'aa di'u'a, 'inia 'e hai dangi na hako'a murinai mae ana.” ");
INSERT INTO aia_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mia Jisas 'a o'ani 'inia, “Nau bwane 'unua tana'o do'oi 'omesiai mena ana God, 'onaa na'oi hinihini!” ");
INSERT INTO aia_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Naasi maraugu rahia baira'i hau baaniai maanai wabwa. Mia Jisas 'a wana ara'ai aro ma o'ani, “Ama, 'au ha'atee ha'agorohi'o 'ini rongoau amua. ");
INSERT INTO aia_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mau 'iraraa do 'ado 'oha 'o rongoau. Ma'ata 'iniraau mwane inoni 'ini, nau ha'atee raha 'inia hura'a, marai hinihini do i'oe na'o ha'ataariau mai.” ");
INSERT INTO aia_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mia Jisas 'agu totoro o'ani, “Lasarus, 'oi hura'a mai!” ");
INSERT INTO aia_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mia Lasarus 'a hura'a mai bei'i mau i bwana ra ho'ua 'ini'i rima mana uwana'i mana bwana nara kukuhaia 'iniai bwauna. Mia Jisas 'a o'ani 'iniraau, “Moi rahi'i baania i bwana ra ho'ua 'ini'i maai hahano a'ora!” ");
INSERT INTO aia_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","'A ragoi nei 'iniraaui Jiu nara boi beia Meri narau hinihinia Jisas 'oha narau re'ia do 'a ha'a-suruta'ea Lasarus baaniai mae. ");
INSERT INTO aia_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma tara'i nei he'ete'i, rau 'ari ataha beiraaui Farisei marau rangasia tanaraaui taha na 'ia Jisas 'a haua. ");
INSERT INTO aia_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Miraaui Na'otara adaa'i Piriisi, miraaui Farisei rau soiraau goni ruruha adaau nara 'unua 'iniai Kansol 'anai hadanga'iniai marehosi. Rau songa'iniraau hairiu o'ani, “'E taha nagai haua? Ra'i mwane ha'abu'oahu na bwane haa'i a mo'osi. ");
INSERT INTO aia_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma 'onaa nagai nugasia moi o'asi, mana mwane inoni hako rai suria. 'Aigu 'ariwou miraaui bwauodo anai Gaumani anai Rom rai matai boi 'anai here ha'ata'aiai Ruma Maea ana God mana inoni agaa'i!” ");
INSERT INTO aia_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Ma'e ta'i 'iniraau na atana 'ia Kaeafas 'a o'ani, “Oru bweu! Ai'a goro do rai urumota'iniraau hakoi noni. Nigasia mo'osi mai mae dingadaau hako.” Na'i harisisi, 'ia Kaeafas na Na'ohadaaui Piriisi. ");
INSERT INTO aia_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","'Ia Kaeafas ai'a do 'a 'unuai marehosi suriai 'adoma'ina haaria. Na'i tatau'aro ana 'onaai Na'ohadaaui Piriisi, 'ia God na tau'aro na'i 'adoma'ina 'anai ha'arangasia hura'a do'ia Jisas 'a ga'i mae dingadaau hakoi noni. ");
INSERT INTO aia_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mana ha'atee duruduru naasi, ai'a do'ia Jisas 'ai mae 'iniraau moi garenai Israel. Me 'ai mae ro'u 'iniraaui nei ana'ia God nara awa 'adarara 'ari suriai marewana marai boi goni beiraaui Jiu marai awa 'onaai ta'i ruruha. ");
INSERT INTO aia_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Taraawa'a na'i dangisi 'iraaui saemaua adaa'i Jiu rau taraawa'a ha'aradorado 'anai ha'amaesia Jisas. ");
INSERT INTO aia_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Naasi suriai o'asi ana, 'ia Jisas 'a mamaro 'anai haai tau'aro ana beiraaui Jiu ma hura'a baaniai Jerusalem. 'A hano beiraaui rongoiusuri ana'i marau 'ari awa na'i Efrem, 'e 'omaa gaarangiai kae dora mangasara. ");
INSERT INTO aia_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mana madoraa 'anai 'adoma'i aho'isiai Roho Aharau 'a gaarangi'a. Ra ragoi noni baani'i mwane 'omaa he'ete'i hairiu nara 'ari Jerusalem 'anai hauai ringe 'anai ha'a-arariraau na'i maana God maigui taraawa'a i rongosi. ");
INSERT INTO aia_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","'Iraaui noni 'isi rau wanawana sibasiba 'inia Jisas. Ma na'i 'oha ra goni mai na'i Ruma Maea rau songa'i hairiu o'ani, “Mou 'adoma'i he'ua? Mou 'adoma'inia do 'a ga'i boi na'i 'oha nagai ha'ato'oa i Roho Aharau?” ");
INSERT INTO aia_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Rau 'unua o'asi suria 'iraaui Na'ohadaa'i Piriisi, rau bwane 'unua tanaraaui noni do 'onaa tanei 'iniraau nai 'ome sadoia Jisas, 'ai 'unua raurau tanaraau marai daua. ");
INSERT INTO aia_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","'E ono dangi namau maraigui ha'ato'oai rongo 'anai 'adoma'i aho'isiai Roho Aharau. 'Ia Jisas 'a aho'i 'ari na'i Betani, i 'omaa na 'ia Lasarus na awaiei, 'ia mo'o na 'ia Jisas 'a ha'a-suruta'ea aho'i baaniai mae. ");
INSERT INTO aia_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Miraau ha'aagauai mahoingau tanaa Jisas na'isi, 'ia Maata naasi na 'a'au 'anai ha'atora'iniai mahoingau tanaraau. Mia Lasarus naasi ta'i 'iniraaui nei narau heinagu na'i dora ngaungau. ");
INSERT INTO aia_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mia Meri 'a siri mai beiai gere bei na honu 'ini rumu na hori bwara di'u. 'A ringisia na'i uwana'i a Jisas 'anai ha'ahoua, magu ha'amaha'i 'iniai warihuna. Mana si'inihanai rumusi 'a adaahusia hako i rumasi. ");
INSERT INTO aia_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mia Jiudas Iskariot, 'e ta'i 'iniraaui rongoiusuri ana'i na awa ro'u 'isi. 'Ia Jiudas naasia mo'o nai usuha'inia Jisas tanaraaui maerongana. Mia Jiudas 'a ha'atee o'ani, ");
INSERT INTO aia_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“'Ei, 'a ga'i raonga'iniai rumusi, mana ha'a 'ana 'a ga'i 'a'auhiraau 'iniai pohara. Na rumusi ra ga'i horia 'iniai oru 'arangi korai ha'a.” ");
INSERT INTO aia_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Rei'uaa na ha'atee o'asi a Jiudas, ai'a do'a huunai ta'aabena 'iniraaui pohara, me suria 'iia 'e sae beri. 'Iia naasi na 'omesuriai ha'a adaaui rongoiusuri, magu tara'i 'oha 'a rahi ha'a moi nana haaria. ");
INSERT INTO aia_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mia Jisas 'agu ha'atee o'ani, “Nigaa! 'Ia Meri 'a haua o'asi 'anai ha'aagauau 'anai 'oha narai toringiau. ");
INSERT INTO aia_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","'Iraaui nei pohara rai awa tarau moi bei'amou. 'Inau na bwa'i.” ");
INSERT INTO aia_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na'i 'oha na 'iraaui noni rau 'iraraa do'ia Jisas 'a ataha, rau goni hako mai 'anai 'omesia, ma 'anai 'omesia ro'ua Lasarus, mo'o na 'ia Jisas 'a ha'a-suruta'ea aho'i baaniai mae. ");
INSERT INTO aia_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Na'i 'ohasi 'a ragoi Jiu naraugu ai'a raba suriraau'a i Na'ohadaa'i Piriisi marau hinihinia Jisas 'iniai maho na to'o beia Lasarus. Naasi miraaui Na'ohadaa'i Piriisi rau hauai ha'aradorado 'anai ha'amaesia ro'ua Lasarus. ");
INSERT INTO aia_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mana'i nata dangi, 'iraaui noni nara boi 'anai ha'ato'oai Roho Aharau na'i Jerusalem rau rongoa do'ia Jisas 'a boi'a 'anai Jerusalem. ");
INSERT INTO aia_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Naasi rau hano marau haa'i hahaai niu, marau 'ari suri tara 'anai heisadoi beia Jisas. Na'i 'oha narau 'ariwou suri tara, rau totoro o'ani, “Ha'aasaa God! Araha God, 'oi ha'agorohia mo'o na'o ha'ataaria mai! 'Oi ha'agorohiai mwaeraha ameeui Israel!” ");
INSERT INTO aia_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas 'a hauai dongki ma heinagu na'i hungana, 'a 'onaai taha na Usu-usu Maea na 'unua na o'ani, ");
INSERT INTO aia_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mou abui mamaa'u i noni nai Jerusalem. 'Ome, na mwaeraha amoou 'a ta'e mai na'i hunganai garei dongki.” ");
INSERT INTO aia_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na'i 'ohasi 'iraaui rongoiusuri ana'i rau ai'a aidangisia do ni mareho 'isi ra'i mareho na 'iraaui rarabea rau bwane 'unu'i na'i Usu-usu Maea. Mana'i 'oha na 'ia Jisas 'a suruta'e aho'i ma ara'ai aro, naraugu aidangisia doni mareho nara usu'i dio na'i Usu-usu Maea ra to'o ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","'Iraaui nei narau 'omesia Jisas 'oha na ha'a-suruta'ea Lasarus baaniai mae, rau taroha'inia ro'u tanaraau tara'i noni. ");
INSERT INTO aia_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ma ragoi noni narau 'ariwou 'anai heisadoi beia Jisas 'iniai rongoa ada i ha'abu'oahu na hauasi. ");
INSERT INTO aia_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Miraaui Farisei raugu ha'atee o'ani hairiu, “'Ome, gau heho'a! 'A bwa'i maho na gaigui haua. 'Inia 'a 'ome 'onaa doni mwane inoni hako rau suria'a!” ");
INSERT INTO aia_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ma tara'i ai Grik narau boi 'anai ha'ato'oai Roho Aharau na'i Jerusalem, ");
INSERT INTO aia_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","rau 'ari ataha beia Pilip, 'e rongoiusuri na boi baania 'omaai Betsaeda na'i Galili. Rau o'ani 'inia, “Saemaua, meu raba 'omesia Jisas.” ");
INSERT INTO aia_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mia Pilip 'a 'unua tanaa Andru mararu 'ari 'anai 'unua tanaa Jisas. ");
INSERT INTO aia_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Na'i 'oha nararu 'unua tanaa, 'ia Jisas 'a ha'atee o'ani, “'Ohani 'a tari'a i madoraa 'anai Garei Inoni 'anai mae, neina 'ai ara'ai aro 'anai ha'ahoua. ");
INSERT INTO aia_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ha'amomori, wai 'unua ha'a-momori tana'amou, ni korai wiit 'ai ahoda aurui ano maai mae ma'ata'a, ma ta wiit haoru nai raboa ara'a maigui haa'i mwane kora haoru. Ma 'onaa na bwa'i mae, na korai wiitisi 'ai tara tata'isada moi. ");
INSERT INTO aia_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","'Iatei nai ta'ahia di'u haariai tahingana na'i marewanani, 'ai ha'a-ai'aai huunai tahi. Mia mo'o na ai'a ta'ahia di'ui tahingana na'i marewanani, 'ai daua nana haariai tahi na bwa'i hako. ");
INSERT INTO aia_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","'Iatei na raba ha'i noni tatau'aro agua, 'ai boi suriau, 'inia na inoni tatau'aro agua 'ai awa tarau na'i dora na 'inau wai awaiei. Ma 'onaa narai suriau, 'ia Amagu 'ai ha'ahouraau.” ");
INSERT INTO aia_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Maagu o'ani ro'u, “Na 'adoma'igu 'a ha'a-arungata'aiau di'u. Wai 'ua? Wai ha'arahesi o'ani gasi? ‘Ama, 'oi abui watea dowai rongomaata'i o'asi!’ Ma'ata naasi taranai taha nau boi 'inia! ");
INSERT INTO aia_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Wai ha'arahesi o'ani. ‘Ama, 'oi hauai taha narai ha'aasaa 'inia i atamu.’” Ma'e ringe na ao dio mai baaniai aro, 'a o'ani, “'Au bwane hauai taha narai ha'aasaa 'inia i atagu, mawai haua ro'u mau.” ");
INSERT INTO aia_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na'i 'oha 'iraaui noni rau rongoai ringe, tara'i nei rau 'adoma'inia do'e hita, ma tara'i nei rau 'unua hura'a do'e enjel na ha'atee tanaa. ");
INSERT INTO aia_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mia Jisas 'agu o'ani 'iniraau, “Na ringe nagau rongoa, ai'a do 'anai 'a'auhiau, me 'anai 'a'auhi'amou 'anai hinihiniau. ");
INSERT INTO aia_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Na'i 'ohani 'ia God 'ai hiiriraau hakoi noni nai marewana, mai ha'ahehoa Saetan na marungiai marewanani. ");
INSERT INTO aia_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mana'i 'oha narai nugaau ara'a, wai taragoni'i mwane inoni hako tanaau.” ");
INSERT INTO aia_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","'A ha'atee o'asi 'anai ha'a-aidangisiraau 'iniai here narai ha'amaesia 'inia na'i dadaahoro. ");
INSERT INTO aia_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Miraaui noni rau o'ani, “'I'ameu meu 'omesia na'i Usu-usu Maea doni Ha'atahi 'a bwa'i mae. Ni 'uaana na'o 'unua 'inia dorai nugaa ara'ai Garei Inoni? 'Iatei Garei Inoni na'o hadanga'iniasi?” ");
INSERT INTO aia_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mia Jisas 'a o'ani 'iniraau, “Ni bewaa 'ai awa bei'amou ta gere madoraa moi. Naasi moi hahano na'iei na'i 'oha na awa mau bei'amou, neina mou bwa'i suapou, mana kuhi 'a bwa'i kuhisi'amou. 'Inia 'onaa namoi awa na'i kuhi, mou bwa'i aidangisiai dora namou hahano 'ana. ");
INSERT INTO aia_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Moi hinihiniai bewaa na'i madoraa na awa mau bei'amou, naasi mamoigui ha'i gare ni bewaa.” Na'i 'oha na ha'atee o'asi hako tanaraau, 'ia Jisas 'a hano ma awa baira'i baaniraau. ");
INSERT INTO aia_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ma rei'uaa na 'ia Jisas 'a hau'i mwane ha'abu'oahu na'i maadaaui noni, me 'a ragoi nei narau ai'a hinihinia ro'u mau. ");
INSERT INTO aia_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ma naasi taha na 'ia Rarabea Aisaea 'a bwane 'unua do'ai to'o. 'A o'ani, “Araha God, 'e taringai sae moi nara hinihiniai taroha nameu maania. Ma ai'a ragoi nei nara 'ome 'iraraai mena amua na'o ha'ata'inia!” ");
INSERT INTO aia_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mana taranai taha narau ai'a hinihini 'inia, 'ia Aisaea 'a 'unua hura'a o'ani, ");
INSERT INTO aia_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“'Ia Araha God 'a ha'akuru'i maadaa'i, ma ha'ababau'i 'adoma'idaa'i. 'Onaa 'a ga'i bwa'i o'asi, rau ga'i 'ome 'irara'i mareho 'ini'i maadaa'i, marau ga'i aidangisi'i mareho 'ini'i 'adoma'idaa'i, marau ga'i rihota'i tanaau mawai ha'agorohiraau baaniai taha na to'iraau.” ");
INSERT INTO aia_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Na ha'atee duruduru na 'ia Aisaea na hauasi, 'a haua 'abaiai Ha'atahi, 'inia 'ia Aisaea 'a 'omesia na'i na'o i ha'ahou na 'ia Jisas 'ai daua 'oha nai tahi aho'i baaniai mae. ");
INSERT INTO aia_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hoita, rei'uaa rau ragoi nei narau ai'a hinihinia Jisas, me rau rago ro'u i nei narau hinihinia. Tara'i saemaua adaa'i Jiu rau hinihinia ro'u, maraugu ai'a ha'arangasia hura'a 'iniai mamaa'usiraau ada i Farisei, dora gasigu ha'a-aburaau 'anai siri suri'i rumani ha'arahesi 'anai rihunga'i. ");
INSERT INTO aia_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Rau ta'ahia di'u i ha'atee ha'a-ta'eta'e baaniraaui noni, marau ai'a ta'ahiai ha'atee ha'a-ta'eta'e baania God. ");
INSERT INTO aia_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mia Jisas 'a totoro o'ani tanaraaui noni, “'Onaa namou hinihiniau, mou ai'a hinihiniau moi, memou hinihinia ro'ua God na ha'ataariau mai. ");
INSERT INTO aia_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Na'i 'oha namou re'iau, 'i'amou re'ia ro'u a mo'o na ha'ataariau mai. ");
INSERT INTO aia_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","'Inau 'au boi 'onaai raita na marewa na'i marewanani, neina 'iraaui nei ra hinihiniau rai abui taraa awa-awa na'i kuhi. ");
INSERT INTO aia_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","'Onaa 'iatei na rongo'i ha'atee agu'i ma bwa'i ha'isuri'i, 'inau 'au bwa'i hiiria. 'Inia 'inau ai'a boi 'anai hiirirai noni nai marewana me 'au boi 'anai ha'atahiraau. ");
INSERT INTO aia_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Me 'iraaui nei nara 'itaau bei'i ha'atee agu'i, ni ha'a-momori nara haa'i ha'atee agu'i naasi narai hiiriraau na'i ha'ahakonai dangi. ");
INSERT INTO aia_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na mareho na 'inau 'au maani'i, ai'a do ra'i 'ado'adogu haariau, me ra'i ha'ausuringa'i baania mo'o na ha'ataariau 'anai 'unu'i tana'amou. ");
INSERT INTO aia_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mau 'iraraa doni ha'ausuringa'i ana'i rai wai'amou 'anai tahi tarau. Naasi, nau maani'i moi mwane mareho na 'ia Amagu na 'unu'i tanaau 'anai maani'i.” ");
INSERT INTO aia_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Na'i na'o magu to'o i rongo 'anai 'adoma'i aho'isiai Roho Aharau, 'ia Jisas 'a 'iraraa do madoraa ana 'a gaarangi 'anai hano baaniai marewanani 'anai aho'i 'ari beia Amana. Mana heita'ahi ana tanaraaui nei narau suria na'i marewanani, 'a 'ari tari na'i mae ana. ");
INSERT INTO aia_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ma tari madoraa 'anai ngau su'urahi. Na'i 'ohasi 'ia Saetan 'a bwane tau'aro na'i 'ado'adona Jiudas, garena Saemon Iskariot, 'anai ha'ato'oai 'ado'adona 'anai usuha'inia Jisas tanaraaui maerongana. ");
INSERT INTO aia_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","'Ia Jisas 'a 'iraraa do ni Ama 'a hau'i hako tanaai mena 'anai marungi'i mwane mareho hako, ma 'iraraa do'iia 'a boi baania God, ma'ai aho'i ro'u 'ari beia God. ");
INSERT INTO aia_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Naasi mia Jisas 'a ura ara'a na'i 'oha narau ngau ma rahiai to'oni bohura'a ana. 'A daai mamango ma hiri'ia na'i wa'ana. ");
INSERT INTO aia_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Naasi ma ringisiai wai auru na'i raronai rabo'o magu taraawa'a dori'i uwadaa'i rongoiusuri ana'i, ma ha'amamaha 'iniai mamango na hiri'ia na'i wa'ana. ");
INSERT INTO aia_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na'i 'oha na tari mai beia Saemon Pita, 'ia Pita 'a o'ani 'inia, “Araha, ni 'uaana na'oigui dori'i 'iniai uwagu?” ");
INSERT INTO aia_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mia Jisas 'a o'ani 'inia, “Na'i 'ohani 'o ai'a aidangisia mau taranai taha naugu haa o'asi 'inia, ma'ata ta 'oha 'oigui aidangisia mau.” ");
INSERT INTO aia_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Mia Pita 'agu ha'atee ha'abwarasia o'ani, “Ai'a, 'inau 'o bwa'i dori'i uwagu!” Mia Jisas 'a o'ani 'inia, “'Onaa 'au bwa'i dori'i uwamu, i'oe ai'a ta'i 'iniraaui noni agu'i.” ");
INSERT INTO aia_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mia Saemon Pita 'a o'ani, “Araha, na'oi abui dori'i moi uwagu'i, 'oi dori'i ro'u i rimagu, mana bwaugu ro'u.” ");
INSERT INTO aia_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Mia Jisas 'agu o'ani 'inia, “'Ia mo'o na bwane mwa'anu wadiwadi'a, ai'a ta'isada do'aigui mwa'anu aho'i ro'u, ma'ata ni uwana'i moi naigu dori'i. 'I'amou mou wadiwadi, ma ai'a do 'i'amou hako.” ");
INSERT INTO aia_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","'A ha'atee o'asi, suria 'a 'iraraa do'e ta'i 'iniraau nai usuha'inia tanaraaui maerongana. Naasi taranai taha na o'ani 'inia, “Ai'a do 'i'amou hako namou wadiwadi.” ");
INSERT INTO aia_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na'i 'oha na wasi'i hakoi uwadaa'i, 'a siri aho'i na'i to'oni ana ma heinagu auru, magu songa'iniraau o'ani, “Mou aidangisiai mareho nau hauasi? ");
INSERT INTO aia_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","14","'I'amou mou 'unuau 'iniai ha'ausuri mana Araha. Ma ha'a-momori, 'inia 'inau naasi Araha mana ha'ausuri amoou. Tarana naasi, 'i'amou moi wasi'i hairiu i uwamoo'i haari'amou, suria 'inau 'au wasi'i uwamoo'i. ");
INSERT INTO aia_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","'Inau 'au ha'ata'inia tana'amoui heiha'auu 'anai suria. Moi haua 'onaai haua agua tana'amou. ");
INSERT INTO aia_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Wai 'unua ha'a-momori tana'amou, 'a bwa'i sae tatau'aro do'ai ororiu di'uai bwauodo ana, ma bwa'i sae heheitaroha'i nai ororiu di'ua mo'o na ha'ataaria hura'a. ");
INSERT INTO aia_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Na mareho 'isi mou bwane aidangisi'i hako. Naasi 'ia God 'ai ha'agorohi'amou 'onaa namoi ha'isuri'i. ");
INSERT INTO aia_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Na mareho nau 'unu'i 'isi, ai'a do'au hadanga'ini'amou hako. 'Inau 'au aidangisi'amoui nei nau 'ome sigihi'amou. Na Usu-usu Maea 'a ha'arangasia hura'a o'ani, ‘Na nei na ngau hasura'i beiau, 'iia nagu ha'imae beiau.’ ");
INSERT INTO aia_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","'Inau 'au 'unua agau tana'amou do neina 'oha nai to'o, moigu 'iraraa do 'inau naasi Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","'Inau wai 'unua ha'a-momori tana'amou, 'iatei na ha'amaotoraaui noni heheitaroha'i agu'i, 'a ha'amaotoau ro'u. Ma 'onaa 'iatei na ha'amaotoau, 'iia 'a ha'amaotoa ro'u a mo'o na ha'ataariau mai.” ");
INSERT INTO aia_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","'Ia Jisas 'a ha'atee o'asi, mana 'adoma'ina 'a ha'a-arungata'aia di'u ma ha'atee hura'a o'ani, “'Inau wai 'unua ha'a-momori tana'amou, 'e ta'i 'ini'amou nai usuha'iniau tanaraaui maerongagu!” ");
INSERT INTO aia_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Miraaui rongoiusuri rau wanasiraau hairiu marau 'ado'ado sibasiba 'inia tei 'iniraau gasi na 'ia Jisas na 'unuasi. ");
INSERT INTO aia_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ma'e ta'i 'iniraaui rongoiusuri na 'ia Jisas 'a ta'ahia di'u. Mana rongoiusurisi 'a heinagu na'i bobona Jisas na'i dora ngaungau. ");
INSERT INTO aia_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mia Saemon Pita 'a hauai ha'ara 'iniai rimana tanaai rongoiusurisi do'ai songa'inia Jisas 'inia tei nai hauai heresi. ");
INSERT INTO aia_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mana rongoiusurisi 'a abesua wou beia Jisas ma o'ani 'inia, “Araha, 'iatei nai hauai heresi?” ");
INSERT INTO aia_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Mia Jisas 'a aramia o'ani, “'Ia mo'o na wai haua tanaai dorai bredi nawai toha'inia dio na'i rabo'o, naasia mo'o nai usuha'iniau tanaraaui maerongagu.” Mia Jisas 'a dauai dorai bredi ma toha'inia dio na'i rabo'o, magu haua tanaa Jiudas garena Saemon Iskariot. ");
INSERT INTO aia_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Na'i 'oha na 'ia Jiudas 'agu dauai bredisi, 'ia Saetan 'a rabe'a beia. Mia Jisas 'a o'ani 'inia, “'Oi raurau beiai taha na'o 'adoma'iniasi.” ");
INSERT INTO aia_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Na'i 'oha na 'unua o'asi, ai'a ta ta'i 'iniraaui nei narau awa 'isi nai 'iraraai taranai taha nagu ha'atee o'asi 'inia tanaa Jiudas. ");
INSERT INTO aia_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tara'i nei 'iniraau rau 'adoma'inia do'ia Jisas 'a 'unua tanaa Jiudas 'anai 'ari hori'i ro'u tara'i mahoingau, ma'ua 'anai ha'i ha'a tanaraaui pohara. 'Inia 'ia Jiudas naasi na 'omesuriai ha'a adaau. ");
INSERT INTO aia_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Na'i 'oha na ngaua hakoi bredi, 'ia Jiudas 'a hasi suruta'e ma hura'a baaniraau. 'Ohasi 'a rodo'a. ");
INSERT INTO aia_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Murina moi hura'a na haa Jiudas baaniraau, 'ia Jisas 'a o'ani 'iniraau, “Naasi 'a tari'a i madoraa narai ha'ahauasaau 'i Garei Inoni, mia God rai ha'ahauasaa 'ini'i mwane mareho nara to'o tanaau. ");
INSERT INTO aia_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma na'i 'oha narai ha'ahauasaa God 'iniai garena, 'ia God 'a bwa'i mamasi orea 'anai ha'ahauasaa o'asi ro'u i garena.” ");
INSERT INTO aia_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Magu o'ani ro'u 'iniraau, “Arai garegu, 'inau bwa'i awa orea bei'amou. Moi sibaniau mamou bwa'i to'oagu. 'Onaai bwane 'unua agua tanaraaui Jiu, mawai 'unua tana'amou ro'u. Na dora nawai 'ariei, mou bwa'i matai taha na'iei. ");
INSERT INTO aia_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Naasi 'au haua tana'amou i ha'atora haoru. Moi ta'ahi'amou hairiu. 'Onaai ta'ahi'amou agua, 'i'amou mou ga'i ta'ahi'amou hairiu o'asi ro'u. ");
INSERT INTO aia_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Na heita'ahi namou haua tana'amou hairiu, 'ai ha'ata'inia tanaraaui mwane inoni nai marewana hako do 'i'amou ra'i rongoiusuri agu'i.” ");
INSERT INTO aia_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","'Ia Saemon Pita 'a songa'inia Jisas o'ani, “Araha, na'i hei na'oi 'ariei?” Mia Jisas 'a aramia o'ani, “Na'i 'ohani 'o bwa'i matai suriau na'i dora na 'inau wai 'ari na'iei, ma'ata 'oigui haisuri mau na'i muri.” ");
INSERT INTO aia_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Mia Pita 'a ha'atee o'ani, “Ni 'uaana na'o 'unua 'inia do'au bwa'i suri'o 'ohani? 'Inau 'au ha'aagau 'ohani 'anai mae taramu!” ");
INSERT INTO aia_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mia Jisas 'a o'ani 'inia, “Nii? 'Oi mae mora taragu? Wai 'unua ha'a-momori tana'o, na kua 'a bwa'i tataraoke mau na'i de'eni wa'aria mi'oe 'oi bwane tohe ha'a-oru do'o ai'a 'iraraau.” ");
INSERT INTO aia_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Mia Jisas 'a o'ani ro'u, “Mou abui ahutotou mai abui ta'aabemoou, ma'ata moi 'u'uria God, mamoi 'u'uriau. ");
INSERT INTO aia_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na'i raronai ruma ana Amagu ra ragoi ahii, minau wai 'ari 'anai ha'aagau'i dora taramoou. 'Onaa na ga'i bwa'i o'asi, 'au ga'i bwa'i 'unua o'asi tana'amou. ");
INSERT INTO aia_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na'i 'oha na mwane mareho rai agau, 'inau wai boi 'anai wai'amou 'ari neina moi awa tarau beiau na'i dora na 'inau awaiei. ");
INSERT INTO aia_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","'I'amou 'iraraai dora na 'inau wai 'ari na'iei, mana tara he'ua namou ga'i ataha 'inia na'iei.” ");
INSERT INTO aia_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mia Tomas 'a o'ani, “Ai'a Araha, 'i'ameu ai'a aidangisiai dora na'oi 'ariei! 'Ai he'uaigu 'iraraa ameeui tara?” ");
INSERT INTO aia_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Mia Jisas 'a o'ani, “'Inau na tara, 'i ha'a-momori, mana tahi. 'A bwa'i nei nai taha beiai Ama 'onaa na bwa'i suriau. ");
INSERT INTO aia_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tari 'ohani, mou ai'a aidangisia Amagu, 'inia mou ai'a huunai aidangisiau. Me taraawa'a na'i 'ohani ma 'ari'a, mou aidangisia mamou 'omesia'a.” ");
INSERT INTO aia_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Mia Pilip 'a o'ani 'inia, “Araha, 'oi ha'ata'inia tana'ameu i Ama, maigu aro i ahumee'i.” ");
INSERT INTO aia_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Mia Jisas 'a o'ani, “Pilip, 'inau 'au awa orea'a bei'amou, ma'o ai'a aidangisiau mau? 'Iatei na 'omesiau, 'iia 'a 'omesiai Ama! Hoita, ni 'uaana na'o 'unua 'inia do wai ha'ata'inia tana'amou? ");
INSERT INTO aia_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ma 'ua Pilip? 'O ai'a hinihini do 'inau mia Amagu 'e ta'i? Taha nau maani'i tana'amou, ai'a do ra'i 'ado'adogu haariau, ma'ata ra'i 'adoma'ina'i a Amagu na awa beiau. ");
INSERT INTO aia_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mou ga'i hinihiniau na'i 'oha nau 'unua do 'inau 'e ta'i be'inia Ama, mia Ama 'e ta'i beiau. 'Onaa bwa'i, mamoi hinihini 'ini'i mareho nau haa'i. ");
INSERT INTO aia_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Wai 'unua ha'a-momori tana'amou, na nei na hinihiniau, 'ai matai hau'i mareho na 'inau haa'i, maai matai haa'i maho raha di'u'i ro'u wou, 'inia 'inau wai 'ari 'anai awa beia Ama. ");
INSERT INTO aia_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","'Iniai suriau amoou, 'inau wai 'a'auhi'amou 'anai haua ta mareho namoi ha'anongia, neina 'iraaui noni rai ha'ahauasaa Ama 'iniai tatau'aro anai garena. ");
INSERT INTO aia_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ha'amomori, 'iniai suriau amoou, 'inau wai 'a'auhi'amou 'anai haua ta mareho namoi ha'anongia.” ");
INSERT INTO aia_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“'Onaa mou ta'ahiau, mamoi araisuri'i ha'atora agu'i. ");
INSERT INTO aia_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Minau wai ha'anongia Ama mai haua tana'amou ta hei'a'auhi nai awa tarau bei'amou. ");
INSERT INTO aia_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","'Iia naasi Hi'ona Maea, 'ia mo'o na ha'ata'ini'i hura'ai mwane mareho ha'a-momori. 'Iraaui nei nara ai'a hinihiniau rau bwa'i dauai Hi'ona Maea, suria rau ai'a 'ome 'iraraa marau ai'a aidangisia. Mi'amou mou aidangisia. 'Ohani, 'iia 'a awa'a bei'amou, ma 'ai mono na'i raromoou tarau. ");
INSERT INTO aia_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“'Inau bwa'i nugasi'amou mamoi awa 'onaai gare a'osi, 'inia 'inau wai 'ari mawai aho'i ro'u mau mai bei'amou. ");
INSERT INTO aia_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","'A bwa'i orea miraaui nei narau ai'a hinihiniau ra bwa'i 'omesiau'a, ma'ata 'i'amou moi 'omesiau, suria 'inau wai tahi aho'i. Mi'amou moi tahi aho'i ro'u. ");
INSERT INTO aia_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na'i 'oha nawai suruta'e aho'i baaniai mae, namoigui 'iraraa do 'inau 'e ta'i be'inia Ama. Mamoigui 'iraraa ro'u do 'inau 'e ta'i bei'amou, mi'amou ta'i beiau. ");
INSERT INTO aia_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“'Iraaui nei narau ha'isuri'i ha'atora agu'i, naasi narau ta'ahiau, ma suria rau ta'ahiau, 'ia Amagu 'ai ta'ahiraau ro'u. 'Inau wai ta'ahiraau, mawai ha'a-aidangisiraau 'iniau.” ");
INSERT INTO aia_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mia Jiudas, ai'a Jiudas Iskariot, ma'ata 'i nata Jiudas 'a o'ani, “Araha, ni 'uaana na 'i'ameu moi na 'oi ha'a-aidangisi'ameu 'ini'o, ma bwa'i tanaraaui noni nai marewana hako?” ");
INSERT INTO aia_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mia Jisas 'a o'ani, “'Iatei na ta'ahiau, 'ai araisuri'i ha'atee agu'i. Mia Amagu 'ai ta'ahia, me 'imiria miri boi 'anai awa beia. ");
INSERT INTO aia_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Miraaui nei narau ai'a ta'ahiau, rau bwa'i raba araisuri'i ha'atee agu'i. Mamoi 'iraraa do ni mareho nau 'unu'i ai'a ha'atee agu'i haariau. Ni mareho nau maani'i ra boi baania Ama na ha'ataariau mai. ");
INSERT INTO aia_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nau 'unu'i tana'amoui mareho 'isi na'i 'oha nau awa mau bei'amou. ");
INSERT INTO aia_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma'ata na'i 'oha nawai hano baani'amou, ni Hei'a'auhi 'ai boi 'anai ha'a-aidangisi'amou 'ini'i mwane maho, mai ha'a 'adoma'i aho'isi'amou tarau 'ini'i taha nau 'unu'i tana'amou. Mana Hei'a'auhisi naasi 'i Hi'ona Maea na 'ia Amagu 'ai ha'ataaria mai 'anai ura 'iniau. ");
INSERT INTO aia_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","'Ai abui ta'aabemoou ma'ua moi abu mamaa'u. 'Inia 'inau wai ha'apapaku'i 'adoma'imoo'i nara torakoke. 'Iraaui noni nai marewana ra bwa'i matai ha'apapaku'i o'asi 'adoma'imoo'i. ");
INSERT INTO aia_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Moi 'adoma'i aho'isiai taha nau 'unua tana'amou do 'inau wai 'ari baani'amou, ma'ata wai aho'i ro'u mau mai bei'amou. 'Onaa namou huunai ta'ahiau mou ga'i wa'ewa'e 'iniai hano nawai haua 'ari beia Ama, 'inia 'iia 'a ororiu di'u ro'u baaniau. ");
INSERT INTO aia_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","'Inau 'unu'i agau tana'amou i mareho 'isi, do nei namoi hinihini na'i 'oha narai to'o. ");
INSERT INTO aia_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","'Augu ai'a to'oraa'a ro'u ta madoraa tewa 'anai 'unu'i tara'i mareho ro'u tana'amou, 'inia na mwaeraha ta'aa anai marewanani 'a gaarangi'a. 'Iia ai'a to'o mena 'anai marungiau, ");
INSERT INTO aia_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ma'ata 'inau wai hauai mareho na 'ia Amagu 'a 'irisia dowai haua, miraaui noni rai aidangisia do 'inau 'au ta'ahia. Hoita, moi suruta'e magai hano.” ");
INSERT INTO aia_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Mia Jisas 'a ha'atee o'ani ro'u tanaraaui rongoiusuri ana'i, “'Inau naasi huunai abe odonai hasi'ei nara 'unua 'iniai grep, me 'ia Amagu naasi na odora'iniai mou. ");
INSERT INTO aia_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","'Iia 'a ruhuusi'i raraa nara ai'a hungu ma taapuru orima'ini'i raraa nara matai hungu marai hungu goro ro'u wou. ");
INSERT INTO aia_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","'I'amou, ni tahingamoo'i ra wadiwadi hako'a 'iniai dau'i amoou i ha'atee agu'i. ");
INSERT INTO aia_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Moi hasi tarau beiau, minau wai hasi tarau bei'amou. 'Inia na raraai hasi'ei 'a bwa'i matai hungu haaria 'onaa na bwa'i hasi wou na'i abe odo. 'A matai hungu moi 'oha na hasi wou na'i abena. Hoita, 'i'amou bwa'i matai hungu ro'u 'onaa namou bwa'i hasi mai beiau. ");
INSERT INTO aia_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“'Io, 'inau naasi abe odonai hasi'ei, me 'i'amou naasi raraa. 'Iatei na hasi beiau minau hasi beia, 'ai hungu rago goro. 'Inia 'a bwa'i maho namoi matai haua ta'iniau. ");
INSERT INTO aia_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","'Onaa 'iatei na ai'a hasi beiau, 'iia 'a 'onaai raraa nara taba gata'inia ma maria'a. 'Inia na raraa o'asi, rai gaasi goni'i na'i robo 'anai suu gata'ini'i. ");
INSERT INTO aia_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ma 'onaa na'oi hasi tarau beiau, mana ha'atee agu'i rai awa tarau bei'o, 'ia God 'a matai haua tana'o ta maho na i'oe 'oi ha'anongia. ");
INSERT INTO aia_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","'Onaa moi hungu goro, rai ha'ahauasaa i Amagu marai aidangisia do 'i'amou ra'i huudi rongoiusuri agu'i. ");
INSERT INTO aia_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“'Inau 'au ta'ahi'amou 'onaai ta'ahiau na haa Amagu. Naasi moi hasi tarau beiau neina moi awa tarau na'i heita'ahi agua. ");
INSERT INTO aia_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","'Inau 'au araisuri'i ha'atora ana'ia Amagu, mana heita'ahi ana 'a awa tarau beiau. 'A o'asi ro'u, 'onaa namoi araisuri'i ha'atora agu'i, na heita'ahi agua 'ai awa tarau ro'u bei'amou. ");
INSERT INTO aia_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“'Inau 'au 'unua o'asi tana'amou, do neina moi honu 'iniai wa'ewa'e 'onaaiau, mana wa'ewa'e amoou 'ai honu aharau. ");
INSERT INTO aia_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Naani ha'atora agua tana'amou—moi ta'ahi'amou hairiu 'onaai ta'ahi'amou agua. ");
INSERT INTO aia_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","'Oha na 'e sae na mae dingadi geresae ana'i, ai'a ta here'a ro'u naigui goro di'uai heresi 'anai ha'ata'iniai heita'ahi ana tanaraau! ");
INSERT INTO aia_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","'I'amou ra'i geresae agu'i 'onaa namoi araisuri'i ha'atora agu'i. ");
INSERT INTO aia_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","'Ohani 'au bwa'i 'unu noni tatau'aro agu'i 'ini'amou. 'Inia na bwauodo 'a bwa'i ha'a-aidangisiraaui noni tatau'aro ana'i 'ini'i mwani mareho na haa'i. Naasi 'inau wai 'unu'amou 'ini'i geresae agu'i, 'inia ni mareho na 'ia Amagu 'a 'unu'i tanaau, 'au ha'a-aidangisi'amou hako 'ini'i. ");
INSERT INTO aia_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","'I'amou ai'a 'ome sigihiau. 'Inau nau 'ome sigihi'amou, mau haua tana'amou i tau'aro domoi hura'a 'anai hungu 'ini'i hua narai awa tarau. Naasi 'ia Amagu 'aigui haua tana'amoui taha namoi ha'anongia, 'iniai suriau amoou. ");
INSERT INTO aia_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Naani ha'atora agua tana'amou—moi ta'ahi'amou hairiu.” ");
INSERT INTO aia_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“'Onaa 'iraaui nei narau ai'a hinihiniau ra 'utai'amou, moi 'iraraa do 'inau naasi nara 'utaiau na'i na'o maragu 'utai'amou ro'u na'i muri. ");
INSERT INTO aia_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","'Onaa namoi awa moi 'onaairaausi, rau ga'i ta'ahi'amou, magu ai'a. 'Inau 'au sigihi'amou 'anai sigi baaniraau, neina moi abui awa 'onaairaau. Naasi tarana narau 'utai'amou 'inia. ");
INSERT INTO aia_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Moi aidangisiai taha nau bwane 'unua tana'amou. Na inoni tatau'aro 'a ai'a ororiu di'uai bwauodo ana. Naasi 'onaa namou 'iraraa do ra norata'aiau, 'ai o'asi ro'u tana'amou. Ma 'onaa nara araisuri'i ha'ausuringa'i agu'i, 'ai o'asi ro'u tana'amou! ");
INSERT INTO aia_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","'Iraaui nei narau ai'a hinihiniau rai haua o'asi, suria 'i'amou ra'i noni agu'i, miraau ai'a aidangisia God na ha'ataariau mai. ");
INSERT INTO aia_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","'Onaa nau ga'i bwa'i boi 'anai hadahada tanaraau ani, 'iraau rau ga'i bwa'i arunga 'ino'a na'i maana God 'iniai 'utaiau narau haa. Me na'i 'ohani rau 'utaiau'a, maigu bwara tanaraau 'anai 'unua do rau ai'a taritari'a. ");
INSERT INTO aia_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","'Iatei na 'utaiau, 'iia 'a 'utaia ro'ua Amagu. ");
INSERT INTO aia_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","'Onaa nau ga'i bwa'i hau'i ha'abu'oahu na ai'a tanei'a ro'u nai haa'i, rau ga'i bwa'i arunga 'ino'a ro'u. Me na'i 'ohani, rei'uaa narau 'omesi'i ha'abu'oahu nau hau'i, miraau 'utaimiria moe'a mau i Amagu. ");
INSERT INTO aia_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ma'ata 'a o'asi do neina 'ai to'o ha'a-momori Usu-usu Maea na o'ani, ‘Ra to'o 'utaiau moi.’ ");
INSERT INTO aia_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","'Inau wai ha'ataaria mai hei'a'auhi baaniai Ama. 'Iia naasi Hi'ona Maea, 'ia mo'o na ha'ata'ini'i hura'ai mwane mareho ha'a-momori. Mana'i 'oha nai boi, 'ai 'unu'i tana'amou i mwane mareho 'iniau. ");
INSERT INTO aia_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mi'amou moigui hura'a 'anai taroha'iniau ro'u tanaraaui noni, 'inia 'i'amou namou awa mau mai beiau 'oha nau taraawa'a hauai tatau'aro agua tari mau na'i 'ohani.” ");
INSERT INTO aia_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“'Inau 'au 'unu'i mareho 'isi tana'amou, do neina 'i'amou moi abui 'adoma'i wanusi 'iniau na'i 'oha narai here ha'a-ta'ai'amou. ");
INSERT INTO aia_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","'Iraaui noni rai ha'a-abu'amou 'anai siri suri'i rumani ha'arahesi 'anai ha'arahesi, mana'i 'oha nai boi mau, 'iraaui nei narai ngahu ha'amaesi'amou rai 'adoma'inia do here narau hauasi rau haa tanaa God. ");
INSERT INTO aia_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Rai haa o'asi, suria rau ai'a aidangisia Ama, marau ai'a aidangisiau. ");
INSERT INTO aia_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","'Inau 'au 'unu'i tana'amoui mareho 'isi, do na'i 'oha naraigui to'o, moigui aidangisia do 'inau 'au bwane ha'abasu'amou 'ini'i. Nau ai'a bwane 'unu'i tana'amou mau na'i na'o, 'iniai awa agua orea mau bei'amou.” ");
INSERT INTO aia_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Mana'i 'ohani, wai 'ari aho'i'a beia mo'o na ha'ataariau mai, ma ai'a ta ta'i abe 'ini'amou nai songa'iniau 'iniai dora na 'inau wai 'ariei. ");
INSERT INTO aia_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","'Au 'iraraa do mou ahutotou di'u 'ini'i mareho nau 'unu'i tana'amousi. ");
INSERT INTO aia_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ma'ata 'a goro di'u do 'inau wai hano, 'inia 'onaa nau bwa'i hano, na Hi'ona Maea 'a bwa'i boi 'anai 'a'auhi'amou. Me 'onaa nawai hano, naasi nawai ha'ataaria mai. ");
INSERT INTO aia_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mana'i 'oha nai boi, 'ai ha'a-'ome 'irararaaui noni nai marewana 'ini'i ora-ora'a adaa'i, ma he'ua i awaha na odo-odo ma 'iniai hihiiri nai boi ta'oha. ");
INSERT INTO aia_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","'Ai ha'a-'ome 'irararaau 'ini'i ora-ora'a adaa'i suria rau ai'a hinihiniau. ");
INSERT INTO aia_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","'Ai ha'a-aidangisiraau 'iniai awaha na odo-odo, 'inia 'inau wai 'ari beia Ama mamougu bwa'i 'omesiau'a ro'u. ");
INSERT INTO aia_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ma'ai ha'a-aidangisiraau 'iniai hihiiri, 'inia 'ia God 'a bwani hiiria Saetan na heimarungi na'i marewanani. ");
INSERT INTO aia_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“'A rago di'u i mareho 'anai maani'i tana'amou, maigui bwara tana'amou 'anai aidangisi'i hako. ");
INSERT INTO aia_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ma'ata, na'i 'oha na Hi'ona Maea ni ha'a-momori 'ai boi, 'iia 'ai ha'a-aidangisi'amou 'ini'i mwane mareho nara ha'a-momori. 'Iia 'a bwa'i maani'i mareho moi suriai 'adoma'ina, ma'ata 'ai maani'i taha na rongo'i beia God. 'Iia 'ai maani'i tana'amoui taha naraigui to'o mau. ");
INSERT INTO aia_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","'Iia 'ai ha'ahauasaau, 'inia 'iia 'ai maani'i tana'amoui taha na 'inau 'au maani'i tanaa. ");
INSERT INTO aia_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Na mwane mareho na 'ia Ama na to'ora'i, 'iia agu'i. Naasi mareho nau 'unua 'inia do ni Hi'ona Maea 'ai maani'i tana'amoui taha na 'inau 'au maani'i.” ");
INSERT INTO aia_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Mia Jisas 'a o'ani ro'u 'iniraaui rongoiusuri ana'i, “'A bwa'i orea mamou bwa'i 'omesiau ga'u, ma bwa'i orea mamoi 'omesiau aho'i ro'u.” ");
INSERT INTO aia_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ma tara'i nei 'iniraaui rongoiusuri ana'i raugu heisosonga'i hairiu o'ani, “'Ini 'uaana na 'unua 'inia do ta gere madoraa gau bwa'i 'omesia ga'u, ma na'i muri gaigui 'omesia aho'i ro'u? Ma'ua na 'unua 'inia do 'iia 'ai 'ari beia Amana? ");
INSERT INTO aia_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","'Igaau gau ai'a aidangisiai 'ado'ado 'anai gere madoraasi.” ");
INSERT INTO aia_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","'Ia Jisas 'a 'iraraa do 'iraau rau raba songa'inia, magu o'ani 'iniraau, “'A 'ua, 'a kakui ahumoou 'ini 'unua agua do 'a bwa'i orea mamou bwa'i 'omesiau ga'u, ma bwa'i orea mamoi 'omesiau ro'u aho'i? ");
INSERT INTO aia_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wai 'unua ha'a-momori tana'amou, 'i'amou moi angi mamoi ahutotou di'u 'iniai here narai haua gugua, ma'ata 'iraaui noni nara ai'a hinihiniau rai wa'ewa'e 'inia. Moi ahutotou, ma'ata ni ahutotou namoi haa 'ai aho'ita'i wa'ewa'e 'ini 'omesia amoou i boi aho'i agua. ");
INSERT INTO aia_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","'Ai 'onaai urao na maesi ahu 'anai ha'ahutaai gare. Mana'i 'oha na gare ana 'a huta, 'a kaku'aai mata'i, ma wa'ewa'e, 'inia i gare 'a huta mai na'i marewana. ");
INSERT INTO aia_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","'Ai o'asi ro'uta tana'amou. Na'i 'ohani mou ahutotou. Ma'ata na'i 'oha nagai hairee'i ro'u, 'i'amou moigui wa'ewa'e di'u ro'u wou, mana wa'ewa'e namoi to'oraa 'a bwa'i tanei nai ha'a-ai'aa baani'amou. ");
INSERT INTO aia_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na'i 'ohasi, 'a bwa'i mareho namoi ha'anongia beiau. Wai 'unua ha'a-momori tana'amou, 'ia Ama 'ai haua tana'amou taha namoi ha'angonia, 'inia 'i'amou ra'i rongoiusuri agu'i. ");
INSERT INTO aia_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tari mai 'ohani, ai'a ta mareho mau namoi ha'anongia mau 'onaai rongoiusuri agu'i. Moi ha'anongi, naasi mamoigui dauai taha namoi ha'anongia, mamoigui honu 'iniai wa'ewa'e.” ");
INSERT INTO aia_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mia Jisas 'a o'ani ro'u 'iniraaui rongoiusuri ana'i, “'Inau 'au maani'i mareho 'isi tana'amou 'ini'i heiha'auu. Ma 'e 'oha nai boi mau 'au bwa'i hau'i heiha'auu, ma'ata wai mamaani odo-odo moi tana'amou 'iniai Ama. ");
INSERT INTO aia_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Naasi mamoigui ha'anongia haarimoou 'iniai hagu amoou beiau. 'Inau 'augu bwa'i ha'anongi'a tana'amou, ");
INSERT INTO aia_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","'inia 'ia Ama 'a ta'ahi'amou suria 'i'amou mou ta'ahiau mamou hinihinia do'inau 'au boi baania God. ");
INSERT INTO aia_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","'Inau 'au boi baania Ama mau boi na'i marewana, mana'i 'ohani wai hano baaniai marewana mawai aho'i 'ari beia Ama.” ");
INSERT INTO aia_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Miraaui rongoiusuri ana'i rau o'ani 'inia, “Na'i 'ohani meugu aidangisi'i goro i mareho na'o 'unu'i, 'inia 'o ai'a haa'i ha'atee heiha'auu suri'i mamaani amu'i. ");
INSERT INTO aia_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Naasi meu 'iraraa do i'oe 'o aidangisi'i mwane mareho hako, ma rei'uaa nameu ai'a songa'ini'o mau 'inia ta maho, me i'oe 'o bwane aidangisi'i 'adoma'imee'i. Naasi meugu hinihini do i'oe 'o boi baania God.” ");
INSERT INTO aia_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","'Ia Jisas 'agu songa'iniraaui o'ani, “Nii? Naasi mougu hinihiniau ha'a-momori'a? ");
INSERT INTO aia_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","'E madoraa nai boi, mana madoraasi naani'a na 'i'amou hako moi 'adarara, 'e nei ma hano baaniau 'ari 'omaa ana. Ma'ata 'inau bwa'i awa haraariau, 'inia 'ia Ama na awa beiau. ");
INSERT INTO aia_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","'Inau 'au 'unu'i o'asi tana'amou mareho 'isi, neina 'iniai hagu amoou beiau, rai abui torakoke 'adoma'imoo'i. Na'i marewanani moi to'oadi mwane mareho bwara. Ma'ata moi ura baabau! Suria 'inau bwane ha'ahehoai mena anai marewanani.” ");
INSERT INTO aia_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","'Oha 'ia Jisas 'a 'unu'i hakoi mareho 'isi, 'a wana ara'ai Aro ma ha'atee o'ani, “Ama, ni madoraa naani'a. 'Oi ha'ahauasaai Garemu, neina 'inau, 'i Garemu, waigui ha'ahauasa'o ro'u. ");
INSERT INTO aia_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","I'oe na'o ha'awateau 'anai marungiraau hakoi noni neina wai hauai tahi tarau tanaraaui noni na'o hauraau mai tanaau. ");
INSERT INTO aia_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mana tahi tarau naani, do 'iraaui noni rai aidangisi'o, 'i ta'i huunai God ha'a-momori, marai aidangisiau ro'ua Jisas Kraest na'o ha'ataariau mai. ");
INSERT INTO aia_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","'Inau 'au ha'ahauasa'o na'i marewanani, 'inia 'au haa'i'a i tatau'aro na'o ha'ataariau mai 'anai haa'i. ");
INSERT INTO aia_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ama, na'i 'oha nawai awa aho'i bei'o, 'au 'irisia do'oi ha'ahauasaau 'onaai ha'ahauasaau ga'u amua na'i 'oha na 'inau awa ga'u bei'o mau mai maagu pwa'ara i marewana. ");
INSERT INTO aia_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","'Inau 'au ha'ata'ini'o tanaraaui mwane 'ini. Rau awa ga'u 'onaairaaui noni nai marewanani, ma'o hauraau mai tanaau. 'Iraau ra'i noni amu'i ma'o hau'i mai tanaau. 'Iraau rau araisuri'i ha'atee amu'i. ");
INSERT INTO aia_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Naasi rau aidangisia do ni mwane mareho hako nau 'unu'i mau haa'i, ra boi baani'o. ");
INSERT INTO aia_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ni mwane ha'ausuringa'i na'o hau'i mai tanaau 'au hau'i hako tanaraau, marau dau'i. Rau aidangisia goro do 'inau 'au boi baani'o, me i'oe na'o ha'ataariau mai. ");
INSERT INTO aia_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ni ha'arahesi aguani, 'au ai'a haua 'iniraaui noni nara ai'a hinihiniau. Me 'au ha'arahesi 'iniraaui nei na'o hau'i mai tanaau, suria 'iraau ra'i nei amu'i. ");
INSERT INTO aia_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Miraaui nei amu'i 'iia agu'i, mana nei agu'i 'iia amu'i. Mei suri'i tahingadaa'i, na mena mana gorohagu ra ha'ata'inia hura'a tanaraaui noni. ");
INSERT INTO aia_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Naani wai hano'a baaniai marewana maugu bwa'i awa'a ro'u na'iei. Wai aho'i 'ariwou bei'o miraaui nei amu'i rai awa mau. Ama Maea, 'oi taatahi bwarasiraau ma'oi 'omesuriraau 'iniai mena amua, 'i ta'i mena na'o haua mai tanaau. 'Oi haua o'asi neina rai ha'i ta'i 'onaaigaraa. ");
INSERT INTO aia_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na'i 'oha na 'inau 'au awa beiraau, 'au taatahi bwarasiraau 'iniai mena amua. 'Au 'omesuriraau goro ma 'e ta'i nei moi 'iniraau na ai'aa baaniau. Naasia mo'o na ta'aasi na ta'isada do'ai siri na'i mae tarau, do neina 'i Usu-usu Maea 'ai to'o ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Naani wai 'ari'a wou bei'o. 'Inau 'unu'i mwane mareho 'ini tanaraau na'i 'oha nau awa mau beiraau, do neina rai honu 'iniai wa'ewa'e 'onaai wa'ewa'e nau haa. ");
INSERT INTO aia_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","'Au hau'i tanaraaui ha'ausuringa'i amu'i, miraaui nei narau ai'a hinihiniau ra 'itaraau suria 'iraau ai'a ha'isuri'i barongadaa'i, 'onaaiau nau ai'a ha'isuri'i ro'u. ");
INSERT INTO aia_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nau ai'a ha'anongia do'oi wairaau baaniai marewana, ma'ata 'au ha'angoni'o do'oi 'omesuriraau baania mo'o na ta'aa di'usi, 'ia Saetan. ");
INSERT INTO aia_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","'Iraau ai'a anai marewanani, 'onaaiau nau ai'a anai marewanani. ");
INSERT INTO aia_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","'Oi ha'amaearaau 'ini'i ha'ausuringa'i amu'i neina rai hauai tau'aro amua. 'Inia na ha'ausuringa'i amu'i ra ha'ata'iniai taha na ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","'Inau 'au ha'a-taariraau hura'a na'i marewana hako 'onaai ha'ataariau amua mai na'i marewanani. ");
INSERT INTO aia_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","'Inau 'au wateau haariau tana'o 'anai 'a'auhiraau, do neina 'iraau rai wateraau haraariraau hako tana'o 'anai hauai tau'aro amua. ");
INSERT INTO aia_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Hoita. Nau ai'a ha'arahesi 'iniraau moi rongoiusuri 'ini, me 'iniraau ro'u i nei narai hinihiniau na'i 'oha rai maaniai tarohagu tanaraau. ");
INSERT INTO aia_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ama! 'Au ha'arahesi do 'iraau hakoi nei narai hinihiniau rai ta'i, 'onaa 'inau mi'oe gara ta'i, i'oe na'i beiau minau na'i bei'o. Mau ha'arahesi do'iraau rai ha'i ta'i beigaraa, neina inoni nai marewana hako raigui hinihinia do i'oe na'o ha'ataariau. ");
INSERT INTO aia_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","'Au haua tanaraaui mena mana goroha na'o haua tanaau. 'Au haua tanaraau do neina rai ha'i ta'i, 'onaai ha'i ta'i agaraa. ");
INSERT INTO aia_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","'Inau na'i beiraau, mi'oe na'i beiau, neina 'iraau rai ha'i ta'i ha'a-momori. Naasi na mwane inoni nai marewana hako rai aidangisia do i'oe na'o ha'ataariau mai, ma'o ta'ahiraaui noni hinihini ta'isada moi 'onaai ta'ahiau na'o haa. ");
INSERT INTO aia_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ama. 'Au 'irisia do 'iraaui nei na'o hau'i mai tanaau rai awa beiau na'i dora na wai awa iei, neina rai 'omesiai rarahagu mana hauasa nau haua, ni raraha mana hauasa na'o haua tanaau 'iniai ta'ahiau mai mau amua maagu pwa'ara i marewana. ");
INSERT INTO aia_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ama! I'oe 'o odo-odo. 'Iraaui noni narau ai'a hinihiniau, rau ai'a aidangisi'o. Ma'ata 'inau 'au aidangisi'o, miraaui nei agu'i rau 'iraraa do i'oe na'o ha'ataariau mai. ");
INSERT INTO aia_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","'Inau 'au ha'a-aidangiraau 'ini'o, mau bwa'i agohe 'anai haua o'asi, neina heita'ahi amua tanaau 'ai awa beiraau, minau ro'u beiraau.” ");
INSERT INTO aia_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","'Oha na 'ia Jisas 'a ha'arahesi hako, 'a wairaaui rongoiusuri ana'i 'ari na'i nata batarau 'iniai marawai Kidron. Marau 'ariwou awa na'i dora ra hasi 'ana hasi'ei 'oliv. ");
INSERT INTO aia_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Mia Jiudas, 'ia mo'o na hano ani 'anai usuha'inia Jisas tanaraaui maerongana, 'a 'iraraai dorasi, suria na'i dorasi 'ia Jisas 'a wairaau tarau 'ariei rongoiusuri ana'i. ");
INSERT INTO aia_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hoita, na'i 'ohasi 'ia Jiudas 'a wairaau mai ruruhai hehei'oi ni Rom beiraau ro'u tara'i sae hehei'oi narau 'omesuriai Ruma Maea na 'iraaui Na'ohadaa'i Piriisi mana Farisei rau ha'ataari'i. Rau waa'i mareho hehei'oi adaa'i, mana mareho ni ha'amarewa, marau ataha wou na'i dorasi. ");
INSERT INTO aia_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas 'a bwane aidangisi'i hakoi taha narai to'o tanaa. Naasi ma 'ariwou 'anai heisadoi beiraau, ma o'ani, “'Iatei namou sibania?” ");
INSERT INTO aia_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Miraau o'ani, “'Ia Jisas ni Nasaret.” Mia Jisas 'a o'ani, “Nei nauni.” Mana'i 'ohasi, 'ia Jiudas 'a ura ro'u moi beiraaui sae hehei'oi. ");
INSERT INTO aia_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hoita, mana'i 'oha na o'ani 'iniraau, “Nei nauni,” rau su'a marau ahurenga hako aurui ano! ");
INSERT INTO aia_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Magu songa'iniraau ro'u o'ani, “'Iatei namou sibania?” Miraau o'ani ro'u 'inia, “'Ia Jisas ni Nasaret.” ");
INSERT INTO aia_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Mia Jisas 'agu o'ani 'iniraau, “'Au bwane 'unua tana'amou niani do neinauni. Ma 'onaa na 'inau namou sibaniau, mamoi nugasiraaui rongoiusuri agu'i 'ini marai hano.” ");
INSERT INTO aia_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","'A haua o'asi neina 'ai to'o ha'a-momori mareho na 'unua na'i 'oha na o'ani, “Ai'a ta ta'i 'iniraaui nei na'o hau'i tanaau nai ai'aa.” ");
INSERT INTO aia_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mia Saemon Pita na awa beiai naihi. 'A rahia hura'a ma taba taahiai karinga odonai sae tatau'aro anai Na'ohadaaui Piriisi. Na atana 'ia Malkas. ");
INSERT INTO aia_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mia Jisas 'a o'ani 'inia Pita, “'Oi nugaa aho'i naihi amua na'i dora 'ana! 'O ai'a 'iraraa do 'inau wai rongomaata'i 'onaai 'irisia ana Amagu?” ");
INSERT INTO aia_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Naasi miraaui hehei'oi mana bwauodo adaa'i, beiraaui sae hehei'oi narau 'omesuriai Ruma Maea ana God, rau daua Jisas marau ho'o goni'i rimana'i. ");
INSERT INTO aia_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Na'i na'o rau waia ga'u tanaa 'Anas, i amana urao ana Kaeafas. 'Ia Kaeafas naasi Na'ohadaaui Piriisi 'anai harisi naasi mia 'Anas na Na'ohadaaui Piriisi ga'u na'i na'o. ");
INSERT INTO aia_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mia Kaeafas naasia mo'o na bwane 'unua tanaraaui saemaua adaa'i Jiu do 'a ga'i goro do 'onaa ta ta'i nei 'ai mae dingadaaui mwane inoni hako. ");
INSERT INTO aia_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","'Ia Pita beiai ta'i rongoiusuri ro'u raru hano suria Jisas. Mana nata rongoiusurisi, raru haimatai'i Na'ohadaaui Piriisi naasi. Na tarana naasi 'iia ra ha'awatea 'anai siri na'i dora a'ora na'i maanai ruma anai Na'ohadaaui Piriisi nara waia siri eia Jisas. ");
INSERT INTO aia_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mia Pita 'a ura moi hura'a na'i maanai bara. Mana nata rongoiusurisi 'a siri ma aho'i hura'a ma hadahada beiai gere urao na 'omesuriai maanai barasi magu waia siri a Pita. ");
INSERT INTO aia_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","'Oha nararu siri, na uraosi 'a wanasia Pita ma o'ani 'inia, “Ni'oe ro'usi ta'i rongoiusuri ana Jisas gasi!” Mia Pita 'a tohe ma o'ani 'inia, “Ai'a, 'inau ai'a.” ");
INSERT INTO aia_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Miraaui noni tatau'aro na'i rumasi, miraaui sae hehei'oi narau 'omesuriai Ruma Maea ana God rau ura garigariai 'eu narau togaa na'isi 'anai waari'u, 'inia na'i 'ohasi 'e madoraa na rodo 'a wanusi. Mia Pita 'a 'ariwou 'anai waari'u ro'u beiraau. ");
INSERT INTO aia_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mia 'Anas 'agu songa'inia Jisas 'iniraaui rongoiusuri ana'i, ma 'ini'i ro'u i ha'ausuringa'i ana'i. ");
INSERT INTO aia_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Mia Jisas 'a aramia o'ani, “Ni mareho nau maani'i 'au maani'i hako hura'a tanaraaui noni. Suria 'ado 'oha 'au mamaani suri'i dora ni rurugoni agaa'i 'onaai ruma ni ha'arahesi, mana'i Ruma Maea ana God. Ai'a ta ta'i maho nawai girua ta'iniraau. ");
INSERT INTO aia_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ni 'uaana na'ogu hau'i 'iniai heisonga'i 'isi tanaau? 'Oi songa'iniraaui nei narau rongo'i taha nau maani'i. 'Iraau narau 'irara'i mareho nau maani'i.” ");
INSERT INTO aia_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ma'e ta'i 'iniraaui sae hehei'oi na 'omesuriai Ruma Maea ana God 'a boi ma hidariai babana Jisas ma o'ani, “I'oe 'o ga'i bwa'i hadahada o'asi tanaai Na'ohadaaui Piriisi!” ");
INSERT INTO aia_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Mia Jisas 'a o'ani, “'Onaa 'e maho ta'aa nau 'unua hura'a ma'oi 'unua hura'a magai rongoa. Ma 'onaa 'a odo-odo i mareho nau 'unua, ma 'e taranai taha na'o hidariau 'inia?” ");
INSERT INTO aia_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mia 'Anas 'a ha'ataaria Jisas 'ari tanaa Kaeafas bei'i mau i ho'oho'o na'i rimana'i. ");
INSERT INTO aia_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","'Oha na 'ia Pita 'a ura mau 'isi 'anai waari'u, 'e ta'i 'iniraaui sae 'isi na o'ani 'inia, “'A 'ua? I'oe ro'u ta'i 'iniraaui rongoiusuri ana'ia mo'osi?” Mia Pita 'a tohe, 'a o'ani, “Ai'a, 'inau ai'a.” ");
INSERT INTO aia_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ma'e ta'i 'ini'i noni tatau'aro anai Na'ohadaaui Piriisi, 'e sae na heito'oranga'i beia mo'o na 'ia Pita na taba taahiai karingana ani, 'a o'ani, “'Inau 'au 'omesi'o ro'u beia mo'osi na'i 'oha nara daua 'ari moui hasi'ei ani.” ");
INSERT INTO aia_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mia Pita 'a tohe ro'u mau. Raugu rongo mana kua 'a tataraoke'a. ");
INSERT INTO aia_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na heisonga'i narau haa'i tanaa Jisas na'i ruma ana Kaeafas 'a wairaau tari 'ari na'i haho'oa ta'aa. Naasi maraugu waia 'ari na'i kae ruma raha anai ai Rom na Primia 'anai Provensi naasi. Miraaui ai Jiu 'isi rau ai'a siri na'i rumasi, 'inia 'onaa narai siri na'i ruma anai nei na ai'a Jiu, rau 'adoma'inia dorai do'o'a na'i maana God marau bwa'igui ha'i ta'i'a beiraaui noni 'oha rai ha'ato'oai rongo ni Roho Aharau. ");
INSERT INTO aia_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mana Primia, 'ia Paelat, 'a hura'a wou na'i abau 'omaa beiraau ma o'ani 'iniraau, “'E taha namou ha'ahunia 'inia mo'oni?” ");
INSERT INTO aia_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Naasi marau aramia o'ani, “'I'ameu ga'i bwa'i waia mai tana'o 'onaa na ga'i bwa'i ha'i sae hehere ta'aa!” ");
INSERT INTO aia_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mia Paelat 'agu o'ani 'iniraau, “Namoi waia mamoi hiiria suriai ringe amoou.” Miraaugu aramia Paelat o'ani, “'I'amoui Rom mou ai'a ha'awatea domei ngahu ha'amaesia ta sae.” ");
INSERT INTO aia_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Naasi 'a to'o ha'a-momori'a 'i mareho 'ia Jisas na 'unua 'iniai he'uai mae nai haa. ");
INSERT INTO aia_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mia Paelat 'a siri aho'i ruma ma 'unua dorai waia siri a Jisas, ma o'ani 'inia, “'A 'ua? I'oe naasi Mwaeraha adaaui Jiu?” ");
INSERT INTO aia_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Mia Jisas 'a aramia o'ani, “'A 'ua? I'oe na'o 'adoma'inia haari'o i heisonga'i na'o haua tanaausi, ma'ua 'e sae moi na 'unua tana'o?” ");
INSERT INTO aia_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Mia Paelat 'a o'ani, “'Eii, 'inau ai'a ai Jiu! 'Iraau haariraaui nei amu'i narau wai'o maini nara raba 'iraraai mahosi. 'E taha na'o ha'atari'aa?” ");
INSERT INTO aia_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mia Jisas 'agu aramia o'ani, “'Inau ai'a mwaeraha anai marewanani. 'Onaa nawai mwaeraha anai marewana, 'iraaui nei agu'i rau ga'i heingahui beiraaui saemaua adaa'i Jiu narau boi 'anai dauau. Ma'ata ni dora ni heimarungi agua ai'a na'i marewanani.” ");
INSERT INTO aia_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","'Ia Paelat 'a o'ani 'inia Jisas, “Naasi, i'oe 'e mwaeraha? Nita?” Mia Jisas 'agu aramia o'ani, “I'oe na'o 'unua do 'inau 'e mwaeraha, ma'o ha'a-momori. Naasi tarana nau huta mai 'inia. 'Au boi na'i marewana 'anai taroha'iniai taha na ha'a-momori, miraaui nei narau ta'ahiai taha na ha'a-momori, rau araisuriau.” ");
INSERT INTO aia_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mia Paelat 'a songa'inia ro'u o'ani, “'E taha naasi ha'a-momori?” Magu aho'i ro'u hura'ai abau 'omaa beiraaui Jiu ma o'ani 'iniraau, “'Inau ai'a to'oana ta mareho taritari'a nai haua. ");
INSERT INTO aia_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ma'ata 'i'amou mou to'oraai ringe 'anai ha'anongiau 'anai ha'ahura'ahia ta sae baaniai rumaniho'o 'ado harisi na'i madoraa ni Roho Aharau. Ma 'ua? Mou 'irisia dowai ruhasiai Mwaeraha amoou i Jiu?” ");
INSERT INTO aia_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Miraau kae awara aho'i tanaa o'ani, “'Ia mo'osi 'oi abui ruhasia, ma'ata 'ia Barabas nameu 'irisia!” ('Iiasia Barabas 'e sae hehere ta'aa na awa na'i rumaniho'o). ");
INSERT INTO aia_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mia Paelat 'a 'unua tanaraaui noni hehei'oi dorai waia Jisas marai rohoa 'iniai hasiwaro baabau. ");
INSERT INTO aia_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","'Oha narau rohoa hako, rau tau'aronai hihiiri bwau waroraraki marau darasia na'i bwauna. Naasi marau ha'asirihia 'iniai bwana ni mwaeraha. Bwanasi 'a tewa magu raba 'ome wangawanga. ");
INSERT INTO aia_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Naasi marau boi gaarangia marau haikou 'inia, rau o'ani, “Ha'aasaai Mwaeraha adaaui Jiu!” Maraugu awanga'i hidaria. ");
INSERT INTO aia_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mia Paelat 'a hura'a ro'u i abau 'omaa ma o'ani 'iniraaui noni, “Na'i 'ohani wai waia hura'a mai tana'amou, ma'ata moi aidangisia do 'inau ai'a to'oana ta mareho nai ha'atari'aa.” ");
INSERT INTO aia_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mia Jisas a hura'a mai beiai hihiiri bwau waroraraki na'i bwauna, mei beiai bwana tewa nara ha'asirihia 'inia. Mia Paelat 'a o'ani, “Naani'a mo'o ani!” ");
INSERT INTO aia_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mana'i 'oha na 'iraaui Na'ohadaaui Piriisi miraaui sae hehei'oi nara 'omesuriai Ruma Maea ana God rau 'omesia, raugu totoro ara'a o'ani, “Rabu ahita'inia na'i dadaahoro! Rabu ahita'inia na'i dadaahoro!” Mia Paelat 'a o'ani, “'I'amou namoi waia mamoi rabu ahita'inia na'i dadaahoro, 'inia 'inau ai'a to'oana ta maho nai ha'atari'aa.” ");
INSERT INTO aia_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Miraaui saemaua adaa'i Jiu raugu ha'atee o'ani, “Na'i ringeringe ameeu, 'iia 'a ta'isada do'ai mae, suria 'a 'unua haaria do'iia garena God.” ");
INSERT INTO aia_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Na'i 'oha nagu rongoa o'asi ro'ua Paelat, 'agu mamaa'u ro'u di'u wou baaniai na'o. ");
INSERT INTO aia_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Naasi ma waia Jisas aho'i siri na'i ruma ma o'ani 'inia, “Na'i dora he'ua na'o boi baania?” Mia Jisas 'a ai'a aramia. ");
INSERT INTO aia_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mia Paelat 'a ha'atee wetewete o'ani, “'Oi aramiau! 'A 'ua? 'O ai'a 'iraraa do'inau nau to'o mena 'ini'o 'anai ruhasi'o ma 'anai rabu ahita'ini'o na'i dadaahoro?” ");
INSERT INTO aia_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mia Jisas 'agu ha'atee o'ani 'inia, “Ni mena moi na'o to'oraa 'iniau naasi mena na 'ia God na haua tana'o. Naasi 'ia mo'o na waiau mai tana'osi, 'a haai ora-ora'a na raha di'u baaniai ora-ora'a amua.” ");
INSERT INTO aia_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Na'i 'oha na 'ia Paelat 'a rongoa o'asi, 'a bonasia do'ai sibania ta here nai ruhasia 'inia Jisas mai hura'a dadara'a. Miraaui saemaua adaa'i Jiu raugu totoro raha ro'u o'ani, “'Onaa na'oi ruhasia mo'osi mai hura'a dadara'a, ma ha'ata'inia do i'oe 'o ai'a aba beiai mwaeraha anai Rom. 'Inia 'iatei na 'unua hura'a haaria do'iia 'e mwaeraha, 'a ha'imae beiai mwaeraha anai Rom.” ");
INSERT INTO aia_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Na'i 'oha na 'ia Paelat 'a rongoai 'unu o'asi adaau, 'a waia aho'i hura'a maia Jisas, ma heinagu auru na'i dorani heihiiri nara 'unua 'iniai dorani hau bubuu. (Na'i ha'atee ni Jiu ra 'unua 'iniai Gabata.) ");
INSERT INTO aia_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ma 'ariwou'a 'anai atoaa na'i dangi 'anai ha'aagau 'anai rongo ni Roho Aharau. Mia Paelat 'a o'ani 'iniraaui Jiu, “Naani mwaeraha amoou!” ");
INSERT INTO aia_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Miraaugu awara aho'i wou tanaa o'ani, “Waia beira'i! Waia beira'i! Rabu ahita'inia na'i dadaahoro!” Mia Paelat 'a o'ani, “'A 'ua? Mei rabu ahita'iniai mwaeraha amoou?” Miraau na Na'ohadaaui Piriisi raugu totoro aho'i ro'u o'ani tanaa, “Ai'a ta mwaeraha he'ete'i'a ro'u nameigui to'oraa, 'iia moi 'etea Mwaeraha anai Rom.” ");
INSERT INTO aia_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mia Paelat 'agu watea Jisas tanaraaui hehei'oi 'anai rabua na'i dadaahoro. Miraau waia Jisas marau hano beira'i beia. ");
INSERT INTO aia_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Na'i 'ohasi 'ia Jisas 'a suru'ia haariai dadaahoro ana, marau ta'eha ara'a na'i gere hungahunga nara 'unua 'iniai dora ni Korai Bwau Sae. (Na'i ha'ateeni Jiu, ra 'unua 'iniai Golgota.) ");
INSERT INTO aia_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na'i 'isi naraugu rabu ahita'inia iei na'i dadaahoro. Ma'e wairarua nara raburarua ro'u na'i dadaahoro adaru'i. Raru 'ado bobo 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Mia Paelat 'a 'unua dorai usuai usu-usu na'i baba 'anai nugaa ara'a na'i bwaunai dadaahoro ana Jisas. 'A o'ani, ");
INSERT INTO aia_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mana usu-usu naasi 'a usua 'iniai ha'atee ni Jiu, Rom, mana Grik. Ma ragoi Jiu narau 'oha'iniai usu-ususi, 'inia ni dorasi 'a gaarangia moi 'omaa rahai Jerusalem. ");
INSERT INTO aia_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mana 'oha na Na'ohadaaui Piriisi 'a 'omesia o'asi, 'a o'ani 'inia Paelat, “'Oi orisia ma'oi usu 'oniaa, ‘'Iia 'a 'unua do 'iiani 'e mwaeraha adaaui Jiu.’” ");
INSERT INTO aia_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mia Paelat 'a o'ani, “Ni taha nau usua dio, ragu bwa'i matai orisia'a.” ");
INSERT INTO aia_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","'E waira hai hehei'oi nara rabu ahita'inia Jisas na'i dadaahoro. 'Oha rau rabua hako, rau 'adodi bwana ana'i. Marau rahia ro'u i to'oni tewa ana nara tagoraa 'inia ta'i kae tahangai bwana. ");
INSERT INTO aia_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Marau o'ani, “Gai abui karia. Ma'ata gai gaasi ha'ara 'ana, magai 'omesia tei nai to'oraa.” Naasi ma to'o ha'a-momori'a i taha na Usu-usu Maea na 'unu 'oniaa, “Ra hatora'ini'i bwana agu'i, mana to'oni tewa agua ra gaasi ha'ara 'ana.” Naasi taha na 'iraaui noni hehei'oi rau haua. ");
INSERT INTO aia_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Hoita, neiraauni nei narau ura gaarangiai dadaahoro ana Jisas. Ni inana, mana do'orana inana, mea Meri urao ana Klopas, mea Meri ni Magdala. ");
INSERT INTO aia_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","'Oha na 'ia Jisas 'a 'omesia inana mana rongoiusuri ana na ta'ahia 'a o'ani 'inia inana, “'Iiasi 'a 'onaa do 'e garemu.” ");
INSERT INTO aia_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Magu o'asi ro'u 'iniai rongoiusurisi, “'Iiasi 'a 'onaa do 'e inamu.” Ma taraawa'a na'i 'ohasi, na rongoiusuri naasi 'agu ha'a-awahia inana Jisas na'i ruma ana. ");
INSERT INTO aia_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","'Ia Jisas 'a aidangisia do ni mwane mareho na boi 'anai haa'i 'a ha'a-arotaha'i goro hako, me ma'ata 'anai ha'a-ha'a-momoriai taha na Usu-usu Maea na 'unua, 'ia Jisas 'a o'ani, “'Inau raba gono.” ");
INSERT INTO aia_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ma'e bei wai na honu 'iniai waen mahai na awa na'isi. Rau hauai mareho na matai omiai wai marau ha'ahonua 'iniai waen. Naasi maraugu ha'ababaua na'i raraai hasi'ei nara 'unua 'iniai Hisop, marau taranga'inia ara'a tanaai ngoona Jisas do'ai gono. ");
INSERT INTO aia_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Na'i 'oha na gono hako, 'a o'ani, “'A agaau'a!” Na'i 'oha na ha'atee o'asi hako, 'a arabwau auru ma nuga manawa. ");
INSERT INTO aia_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Miraaui saemaua adaa'i Jiu rau ai'a rabasia doni abedaa'i waira orusi do raigui awa ro'u mau hunganai dadaahoro tari nata dangi, 'inia ni nata dangi naasi dangi ni mamaro. (Na dangi ni mamarosi 'a ororiu di'u suria 'a to'o na'i sade nara 'adoma'i aho'isiai Roho Aharau.) Naasi rau ha'angonia Paelat do'ai 'unua tanaraaui hehei'oi 'anai raesi'i uwadaa'i marai rahi'i dioi abedaa'i baani'i dadaahoro. ");
INSERT INTO aia_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Miraaui hehei'oi rau 'ariwou marau raesi'i uwadaru'i rua mwane nararu 'ado bobo 'iniasi a Jisas. ");
INSERT INTO aia_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mana'i 'oha naraugu boi beia Jisas, rau sadoia do'iia 'a bwani mae, naasi marau ai'a raesi'i uwana'i. ");
INSERT INTO aia_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma'ata 'e ta'i 'iniraaui hehei'oi na 'ariwou ma rubu'iai rageragena 'iniai oo'o, mana 'abu mana wai ra ahe hura'a. ");
INSERT INTO aia_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ni mareho na to'osi 'a ha'a-momori, 'inia 'ia mo'o na 'ome'ome haraaria 'iniai maana na taroha'inia hura'a do neina moi hinihini. ");
INSERT INTO aia_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ni mareho 'isi ra to'o neina 'ai ha'a-ha'a-momoriai Usu-usu Maea na o'ani, “'A bwa'i ta ta'i susuri na'i abena nai bwaro,” ");
INSERT INTO aia_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","“marau bore suria mo'o nara rubu'ia 'iniai oo'o.” ");
INSERT INTO aia_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Na'i muri 'ia Josep ni 'Arimatea 'a taha beia Paelat ma songa'inia 'onaa 'a ga'i wateai abena Jisas 'anai rahia dio baaniai dadaahoro. ('Iiasia Josep 'e ta'i sae na suria Jisas, magu ai'a raba ha'ata'inia haaria, suria 'a mamaa'usiraaui saemaua adaa'i Jiu.) 'Ia Paelat 'a watea, mia Josep 'a 'ari ma rahia dioi abena Jisas ma waia. ");
INSERT INTO aia_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Mia Nikodimas, 'ia mo'o na ataha ga'u beia ani a Jisas na'i rodo, 'a hano ro'u beia Josep. Mia 'a waai bibii nara awaiei merisini nara 'unua 'iniai “Myrrh” mana “Alos” 'anai nuga'i na'i abena Jisas na'i 'oha rai ha'aagauai abena 'anai toringia. Mana hihi'adi mareho 'isi ra ga'i 'onaai oru tangahurui kilo. ");
INSERT INTO aia_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Miraruai rua mwanesi raru haa'i tahangai bwana mamaahui mararu ho'u'i 'iniai abena bei'i merisini 'isi. Naasi here adaaui Jiu 'anai ha'aagau'i abedi sae adaa'i nara mae 'anai toringi'i. ");
INSERT INTO aia_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ni dora nara rabua eisia Jisas na'i dadaahoro 'a awa gaarangiai moui hasi'ei. Mana'i moui hasi'eisi, 'e wabwa na awa 'isi, mana wabwasi ai'a ta sae mau narai aoraa ei. ");
INSERT INTO aia_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Hoita, me suria ra ha'a-osaosa 'iniai tari'a ana i 'oha 'anai ha'aagau 'anai dangi ni mamaro ma naasi'a i wabwa na gaarangiai dorasi, rau waiai abena Jisas marau aoraa na'i wabwasi. ");
INSERT INTO aia_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mana'i 'oha na kuhi mau na'i haho'oai Sade, 'ia Meri ni Magdala 'a ho'orai 'ari hera, ma 'omesia do ni hau nara ha'abwarasia 'iniai maanai wabwa ra bwane nigaa baira'i. ");
INSERT INTO aia_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Naasi ma 'eba aho'i ma sadoia Saemon Pita mana nata rongoiusuri na 'ia Jisas 'a ta'ahia. Mia Meri 'a o'ani 'inirarua, “'Ei, ra rahiai abena Araha baaniai wabwa, maugu ai'a 'iraraai dora ra nugaa iei!” ");
INSERT INTO aia_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Na'i 'oha nararugu rongo o'asi, mararu 'eba moe'a 'anai 'ari 'omesiai wabwa. ");
INSERT INTO aia_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Na'i 'oha raru 'eba mau wou, mana nata rongoiusurisi 'a 'eba di'ua Pita ma ataha 'ari na'i na'o na'i wabwa. ");
INSERT INTO aia_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","'Oha na 'ariwou na'i maanai wabwa 'a mwaoro dio magu wana siri na'i dora ra ha'adaohia eia Jisas. 'A 'omesi'i bwana ra ho'ua 'ini'i, ma'ata 'a ai'a siri. ");
INSERT INTO aia_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Na'i 'oha na 'ia Saemon Pita 'agu ataha, 'a siri daara'i ma re'i'i dadao ada'i bwana, ");
INSERT INTO aia_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ma 'omesia doni bwana ra bibiia 'iniai bwauna 'a awa sigi haaria, ma 'ome 'onaa dora roku taguma'inia goro. ");
INSERT INTO aia_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Naasi mana nata rongoiusurisi na ada na'i na'o 'inia Pita 'agu siri ro'u haisuri. Na'i 'ohasi 'a 'ome ma hinihini do 'ia Jisas 'a suruta'e'a aho'i. ");
INSERT INTO aia_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Rei'uaa tari mai 'ohasi raru ai'a aidangi tarihanai Usu-usu Maea na 'unua hura'a do'ia Jisas 'ai suruta'e aho'i baaniai mae. ");
INSERT INTO aia_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Naasi ma rarugu aho'i 'ari ruma. ");
INSERT INTO aia_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mia Meri 'a awa mau hura'ai maanai wabwa, magu angiangi. Mana'i mau i 'oha na angiangisi 'a mwaoro auru do'ai wana siri raronai wabwa. ");
INSERT INTO aia_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na'i 'oha nagu wana siriwou na'i dora ra nuga iei abena Jisas, 'a 'omesiai heheinagu adaruai rua enjel nararu siri suri'i to'oni mamaahui, 'e ta'i tanaai dora na awai bwauna, ma'e ta'i tanaai dora ra awaiei uwana. ");
INSERT INTO aia_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mana rua enjelisi raru songa'inia Meri o'ani, “'E taha na'o angi 'inia?” Mia Meri 'a o'ani, “Ra waiai abena Araha agua, maugu ai'a 'iraraai dora ra nugaa iei.” ");
INSERT INTO aia_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Na'i 'oha nagu agario aho'i, ma re'iai sae na ura na'i murina. Na saesi 'ia Jisas, ma'ata 'a ai'a 'ome 'iraraa do'ia Jisas. ");
INSERT INTO aia_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mia Jisas 'a ha'atee o'ani 'inia, “'E taha 'o angi 'inia? 'Iatei na'o sibania?” 'Ia Meri 'a 'adoma'inia do'ia mo'o na 'omesuriai moui hasi'eisi, magu o'ani 'inia, “Saemaua, 'onaa i'oe na'o waia, ma'oi 'unua tanaaui dora na'o nugaa iei, mawai 'arihia.” ");
INSERT INTO aia_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mia Jisas 'agu o'ani, “Meri!” Mia Meri 'a rihota'i wou tanaa ma o'ani, “Raboni!” Ni 'ado'ado 'anai ha'ateesi naasi, “Ha'ausuri.” ");
INSERT INTO aia_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Mia Jisas 'a o'ani 'inia, “'Oi abui dau mai beiau, suriai 'inau ai'a ara'a mau beia Amagu. Ma'ata 'oi 'ari beiraaui rongoiusuri agu'i ma'oi 'unua tanaraau do 'inau wai ara'a beia Amagu, 'e Amamoou ro'u, i God agua, ma'e God amoou ro'u.” ");
INSERT INTO aia_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mia Meri ni Magdala 'a aho'i 'ari ma o'ani 'iniraaui rongoiusuri, “'Inau 'omesia Araha!” Ma maani'i hakoi mwane mareho na 'unu'ia Jisas. ");
INSERT INTO aia_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mwane mareho 'isi ra to'o na'i dangi sade. Mana'i mau su'urahinai dangisi, 'iraaui rongoiusuri rau awa na'i raronai ruma narau honohono ha'ababaua, suria rau mamaa'usiraaui saemaua adaa'i Jiu. Raugu 'asu'a mia Jisas 'a ura beiraau ma o'ani 'iniraau, “Na gooroha ana God 'ai awa bei'amou!” ");
INSERT INTO aia_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","'Oha na ha'atee o'asi, 'a taranga'ini'i hura'ai rimana'i dorai 'omesi'i, ma ha'ata'inia tanaraaui rageragena. 'Oha na 'iraaui rongoiusuri rau 'ome 'iraraai Araha adaau, rau honu 'iniai wa'ewa'e. ");
INSERT INTO aia_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Magu ha'atee aho'i ro'u o'ani 'iniraau, “Na gooroha ana God 'ai awa bei'amou. 'Onaai ha'ataariau mai ana Ama, 'inau 'au ha'ataari'amou ro'u.” ");
INSERT INTO aia_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ma manawasiraau magu o'ani, “Moi dauai Hi'ona Maea. ");
INSERT INTO aia_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","'Onaa namoi 'unua tanaa tanei domou 'adoma'i nugasi'i ora-ora'a ana'i, 'ia God 'ai 'adoma'i nugasi'i ma'ata'a. Ma 'onaa namou bwa'i 'unua, 'ia God a bwa'i 'adoma'i nugasi'i.” ");
INSERT INTO aia_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ma'e ta'i 'iniraaui rongoiusuri na atana 'ia Tomas nara 'unua ro'u 'iniai 'Iu, na ai'a awa na'i 'oha na 'ia Jisas 'a ha'ata'i tanaraau. ");
INSERT INTO aia_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Na'i 'oha nagu boi aho'i, 'iraaui rongoiusuri rau o'ani 'inia, “'I'ameu meu 'omesia Araha!” Mia Tomas 'a o'ani 'iniraau, “'Inau ai'a hinihinimoou. Wai hinihini 'onaa wai re'i'i ma'ua karohi'i dora ra maara na'i rimana'i, ma 'onaa wai karo siri na'i dora na maara na'i rageragena.” ");
INSERT INTO aia_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mana'i nata sade haisuri, 'iraaui rongoiusuri ana'ia Jisas rau goni na'i ta'i ruma ro'u mausi, mia Tomas 'a awa ro'u beiraau na'i 'ohasi, mana maraaruma rau honohono ha'ababau'i goro. Raugu 'asu'a mia Jisas 'a ura ro'u na'i beiraau ma o'ani 'iniraau, “Na gooroha ana God 'ai awa bei'amou.” ");
INSERT INTO aia_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Naasi ma o'ani 'inia Tomas, “'Oi nugaai kaka'umu na'i 'ini, ma'oi 'omesi'i rimagu. 'Oi karo siri na'i dora na maara na'i rageragegu. 'Oi hinihini, ma'oi abui 'adoma'i heiruarua'a!” ");
INSERT INTO aia_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mia Tomas 'a o'ani, “I'oe Araha agua, mana God agua!” ");
INSERT INTO aia_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mia Jisas 'agu o'ani 'inia, “I'oe 'o hinihini suria 'o re'iau. Ma'ata ha'amwaniraau di'u i nei ra hinihini ha'i ai'a 'omesiau.” ");
INSERT INTO aia_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ra rago di'ui ha'abu'oahu na 'ia Jisas na haa'i na 'iraaui rongoiusuri rau 'omesi'i, maragu ai'a nuga'i dio na'i bukani. ");
INSERT INTO aia_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma'ata ni mareho nara nuga'i dio 'isi, ra nuga'i dio do neina moi hinihini do'ia Jisas naasi Ha'atahi, me 'iia naasi Garena God. Ma 'onaa moi hinihini o'asi, moi daua namooui tahi tarau. ");
INSERT INTO aia_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Na'i muri, 'ia Jisas 'a ha'ata'i ro'u tanaraaui rongoiusuri ana'i na'i bobonai kae bwera i Galili. Ma to'o o'ani. ");
INSERT INTO aia_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ra'i nei 'ini'i rongoiusuri ana'i narau awa 'ohasi. 'Ia Saemon Pita, 'ia Tomas nara 'unua ro'u 'iniai 'Iu, 'ia Nataniel baaniai 'omaai Kena na'i Provensi Galili, mana rua garena Sebedi, beiai nata rua rongoiusuri ro'u. ");
INSERT INTO aia_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mia Pita 'a o'ani 'iniraau, “'Inau wai hanoriai ahuasi.” Miraau hako raugu o'ani 'inia, “Gai ta'i hano.” Rau hano marau ta'e hura'a na'i ora. Na'i rodo bubusi ai'a ta ta'i ii'a narai ngahuia. ");
INSERT INTO aia_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mana'i 'oha na dangi 'a hane mai, rau 'omesia Jisas ura-ura ana na'i one, ma'ata rau ai'a 'ome 'iraraa do'ia Jisas. ");
INSERT INTO aia_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mia Jisas 'agu awara hura'a o'ani 'iniraau, “Mwane geresae, ra'i ii'a namou ngahui'i?” Miraau o'ani 'inia, “Ai'a.” ");
INSERT INTO aia_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Miagu o'ani ro'u 'iniraau, “Moi gaasia aurui hu'o na'i aba odo 'iniai ora mamoi to'i'i tara'i nei!” Na'i 'oha naraugu gaasia auru 'onaai 'unua ana, ma naasi ma bwara'a tanaraaui raua aho'i 'iniai honu'a ana 'iniai ii'a. ");
INSERT INTO aia_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Naasi mana rongoiusuri na 'ia Jisas na ta'ahia 'a o'ani 'inia Pita, “'Ia Araha naasi!” 'Oha na rongoa o'asi a Pita, 'a hasi siri aho'i na'i bwana bo hura'a ana ma rege dioi wai, ma arasi siri one. ");
INSERT INTO aia_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Miraaui haru rongoiusuri rau awa moi na'i ora 'anai ogea siri one 'i hu'o na honu 'iniai ii'a. Mana'i dora narau awaieisi ai'a taraa ha'atau, 'a ga'i 'onaa moi ta'i 'arangi mita baaniai one. ");
INSERT INTO aia_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na'i 'oha narau ataha siriwou, rau 'omesiai ii'a matota na awa na'i hunganai mwagaraha na'i 'eu. Ma ra'i bredi ra awa ro'u. ");
INSERT INTO aia_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Mia Jisas 'a o'ani 'iniraau, “Moi waa'i mai tara'i ii'a namougu bura'i ngahui'i 'isi.” ");
INSERT INTO aia_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mia Saemon Pita 'a ta'eha na'i ora ma 'a'auhiraau 'anai ogea siri one 'i hu'o na honu 'iniai ii'a. Rau ngahuiai ta'i 'arangi rima tangahuru mana oru kae ii'a, mana hu'o ai'a do'ai ohogao. ");
INSERT INTO aia_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Mia Jisas 'a o'ani 'iniraau, “Mou boi mamoi ngau.” Ma ai'a do ta ta'i 'iniraau naigui songa'inia o'ani, “'Iatei nei'oesi?” Suria rau bwane aidangisia hako do 'ia Araha. ");
INSERT INTO aia_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas 'a haua tanaraaui bredi 'anai ngaa, ma haua ro'u i ii'a tanaraau. ");
INSERT INTO aia_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Naasi orunai 'oha na 'ia Jisas 'a ha'ata'i tanaraaui rongoiusuri ana'i murinai suruta'e aho'i ana baaniai mae. ");
INSERT INTO aia_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Na'i 'oha narau ngau hako, 'ia Jisas 'a ha'atee o'ani 'inia Pita, “Saemon, garena Jon. 'A 'ua? I heita'ahi amua tanaau 'a raha di'uai heita'ahi narau haua i mwane 'ini tanaau?” Mia Pita 'a aramia o'ani, “'Io Araha, 'o 'iraraa do'au ta'ahi'o.” Mia Jisas 'a o'ani 'inia, “'Oi hangani'i garei siip agu'i.” ");
INSERT INTO aia_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mia Jisas 'a songa'inia ro'u aho'i a Pita o'ani, “Saemon, garena Jon. 'A 'ua? 'O ta'ahiau?” Mia Pita 'a aramia ro'u o'ani, “'Io Araha, 'o 'iraraa do'au ta'ahi'o.” Mia Jisas 'a o'ani 'inia, “'Oi 'omesuri ha'agorohi'i siip agu'i.” ");
INSERT INTO aia_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mia Jisas 'a songa'inia aho'i ro'ua Pita o'ani, “Saemon, garena Jon. 'A 'ua? 'O ta'ahiau?” Na'i 'ohasi mia Pita 'a arunga ta'aa'a, suria 'ia Jisas 'a songa'inia ha'a-oru 'iniai ta'i heisonga'i moi. Mia Pita 'agu o'ani 'inia, “Araha, ni mwane mareho 'o aidangisi'i hako'a, 'o 'iraraa do 'inau 'au ta'ahi'o.” Mia Jisas 'a o'ani 'inia, “'Oi hangani'i siip agu'i. ");
INSERT INTO aia_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wai 'unua ha'a-momori tana'o, na'i 'oha 'o haoru, 'o matai ho'osia haari'o i bwana amua, ma'o matai 'ari na'i dora na'oi raba 'ari na'iei. Ma'ata na'i 'oha 'oi wari, 'oi taranga'ini'i rimamu'i hura'a ma ra'i sae he'ete'i narai tosi'o marai wai'o 'ari na'i dora na'o bwa'i raba 'ari na'iei.” ");
INSERT INTO aia_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","'Ia Jisas 'a hadahada o'asi 'inia Pita, do neina 'ia Pita 'ai aidangisiai mae he'ua nai haua 'anai ha'ahauasaa God. Mia Jisas 'agu o'ani 'inia, “'Oi suriau tarau.” ");
INSERT INTO aia_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","'Ia Pita 'a rihota'i ma 'omesiai haisuri anai rongoiusuri na 'ia Jisas na ta'ahia. (Naasi ni rongoiusuri na abesua wou beia Jisas na'i 'oha narau ngau ani ma songa'inia 'inia mo'o nai usuha'inia tanaraaui maerongana.) ");
INSERT INTO aia_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Hoita, mia Pita 'a songa'inia Jisas o'ani, “Mia mo'osi 'ai 'ua Araha?” ");
INSERT INTO aia_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Mia Jisas 'a aramia o'ani, “'Onaa na wai 'irisia do'ai tahi tari na'i 'oha nawai aho'i mai, 'e taha na ta'aabemu 'inia? I'oe 'oi suriau.” ");
INSERT INTO aia_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Na maho na 'unuasi 'a 'adarara 'ari tanaraaui noni hinihini marau 'adoma'inia doni rongoiusurisi 'agu bwa'i mae'a. Ma'ata 'ia Jisas 'a ai'a 'unua o'asi. Ni mareho na 'unua Jisas 'a o'ani, “'Onaa nawai 'irisia do'ai tahi tari na'i 'oha nawai aho'i mai, 'e taha na ta'aabemu 'inia?” ");
INSERT INTO aia_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","'Inau naasi rongoiusuri nau re'i'i mwane mareho nau usu'i dio 'ini. Mi'ameu hako meu 'iraraa doni mareho nau usu'isi ra ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","'A rago di'u i mareho na haa'ia Jisas nau ai'a usu'i dio na'i bukani. Ma 'onaa nawai usu'i hako dio, 'au 'adoma'inia do ni marewana hako 'a bwa'i 'ohadi buka nawai usu'i 'ini'i mwane mareho 'isi. ");
INSERT INTO aia_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tana'o Tiofilas: Na'i buka tahamora agua, 'au usu'i mwani maho na 'ia Jisas 'a haa'i ma ha'ausuringa'ini'i, na'i madoraa na taraawa'a hauai tau'aro ana ");
INSERT INTO aia_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tari dangi nara waia ara'ai aro. Na'i na'o maragu waia ara'ai aro, 'a heiatenga'i 'iniai mena anai Hi'ona Maea tanaraaui Ha'ataari ana'i na 'ome sigihiraau. ");
INSERT INTO aia_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Na'i murinai mae ana, 'e hai tangahurui dangi na ha'ata'inia haaria tanaraau na'i 'ado herehere 'anai ha'ata'inia mora do'iia 'a tahi aho'i ha'a-momori. Rau re'ia ma hadanga'inia tanaraaui heimarungi ana God. ");
INSERT INTO aia_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na'i 'oha na awa mau beiraau, 'a o'ani, “Moi abu hano baaniai Jerusalem. Moi mamasiai Hi'ona Maea na 'ia Amagu na duruduru 'inia, me'inau ro'u 'au bwane maania tana'amou. ");
INSERT INTO aia_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","'Ia Jon 'a bwareomaea'amou 'iniai wai, ma bwa'i orea mia God 'ai bwareomaea'amou 'iniai Hi'ona Maea.” ");
INSERT INTO aia_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","'Oha 'iraau Ha'ataari rau awa goni beia Jisas, rau songa'inia o'ani, “Araha. 'A 'ua? I'oe 'oi haua aho'i heimarungi na'i 'ohani tanagaaui ai Jiu?” ");
INSERT INTO aia_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mia Jisas 'a o'ani, “'Iia moi Amagu na to'oraai mena 'anai ha'a-arataraai madoraa 'ana. Ma ai'a 'iaamoou 'anai 'iraraa 'oha he'ua nai to'o. ");
INSERT INTO aia_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ma'ata 'i'amou moi honu 'iniai mena anai Hi'ona Maea na'i 'oha nai dio maai sirihi'amou. Ma moi taroha'iniau na'i Jerusalem, ma na'i hakoi Provensi Jiudea ma na'i Provensi Samaria mana 'ari suria hakoi marewana.” ");
INSERT INTO aia_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","'Agu ha'atee hako mia God 'a waia ara'a 'oha rau wanasia maua Jisas. Mana rorodo 'a kukuha bwarasia maraugu ai'a re'ia'a. ");
INSERT INTO aia_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Miraau rau wana to'o buu mau ara'ai aro. Raugu 'asu'a ma'e rua sae raru to'oni 'ini to'oni mamaahui raru ura na'i bobodaau. ");
INSERT INTO aia_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Raru o'ani, “'A 'ua na 'i'amou saeni Galili mou ura 'inia na'i 'ini mamougu wana ara'ai aro? 'Ia Jisas nara waia ara'ai aro ani, 'ai boi aho'i ro'u mau 'onaai herehere namou re'ia na'i 'oha 'iia 'a aho'i ara'ai aro.” ");
INSERT INTO aia_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na'i muri 'iraaui Ha'ataari rau hano baaniai hungahungai 'Oliv marau 'ari aho'i 'omaai Jerusalem. I hungahungai 'Oliv 'a ga'i 'onaa moi ta'i kilomita baaniai Jerusalem. ");
INSERT INTO aia_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Rau ta'eha na'i ahii na'i ruma ahaaha narau bwane awa-awa na'iei. 'Iraaui Ha'ataari narau awa 'isi, 'ia Pita, Jon, Jems, Andru, Pilip, Tomas, Batolomiu, Matiu, Jems garena Alfias, Saemon—'ia mo'o na raba ha'ahakoai Mwaeraha adaaui Rom, mea Jiudas garena Jems. ");
INSERT INTO aia_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","'Iraaui Ha'ataari rau boi goni tarau na'i 'isi beiai ta'i 'ado'ado 'anai ha'arahesi. 'Iraau tara'i urao ro'u beia Meri inana Jisas, miraau do'orana'ia Jisas, rau matai boi goni ro'u beiraau. ");
INSERT INTO aia_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","'E ta'i 'oha, 'a gaarangi 'onaai ta'i 'arangi mana rua tangahuru 'iniraaui noni hinihini rau rurugoni ro'u. Mia Pita 'a ura ara'a ma ha'atee tanaraau. ");
INSERT INTO aia_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","'A o'ani, “Arai do'ora, na'i 'oha bwani 'ia Deved 'a ha'atee 'iniai mena anai Hi'ona Maea 'anai 'unuai maho 'abaia Jiudas. Mana maho na 'unua 'a to'o'a. 'Ia Jiudas 'e ta'i 'inigaau ma tau'aro beigaau miagu waia mai ruruha 'anai daua Jisas. ");
INSERT INTO aia_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Mia Jiudas 'agu horiai dorai ano 'iniai ha'a nara haua tanaa 'iniai hereta'aa na haua. Ma na'i 'isi nagu ahoda abwa-abwa na'iei mana ahuna 'a pusu mana mwane maho na'i rarona ragu teteho hura'a. ");
INSERT INTO aia_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ma na'i 'oha 'iraaui sae na'i Jerusalem rau sadoia o'asi, rau 'unua 'iniai dorasi Akeldama. 'Ado'ado 'ana 'e Ano ni 'Abu. ");
INSERT INTO aia_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Na'i buka ni Psalm, 'ia Deved 'a usua o'ani, ‘Ruma ana 'ai awa bwaranga moi mamoi abu watea ta sae nai mono na'iei.’ Ma o'ani ro'u, ‘'A goro 'onaa ta sae he'ete'i naigu tagora orisiai saesi.’ ");
INSERT INTO aia_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Naasi gau rabasia ta sae he'ete'i nai 'a'auhigaau 'anai taroha'inia do 'ia Jisas 'a suruta'e aho'i baaniai mae. Tarana naasi gai 'ome sigihia ta ta'i 'iniraaui nei narau bwane awa-awa beigaau taraawa'a mau na'i madoraa 'ia Jon 'a bwareomaeaa Jisas tari madoraa 'ia God 'a waia aho'i ara'ai aro.” ");
INSERT INTO aia_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hoita, 'e rua sae narau wai'ado'ado 'inia, 'ia Mataeas mia Josep Basabas, nata atana 'ia Jastas. ");
INSERT INTO aia_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Marau ha'arahesi o'ani, “Araha, i'oe 'o aidangisi'i 'ado'ado adaa'i mwani noni hako. 'Oi ha'ata'inia tana'ameui nei na'o 'ome sigihia ");
INSERT INTO aia_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","'anai ha'i Ha'ataari orisia Jiudas, 'ia mo'o na rihota'i baanigaau ma 'ari na'i huunai dora na araria.” ");
INSERT INTO aia_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Maraugu gaasi ha'ara ma auru na'i hungana Mataeas. 'Iia ro'u naagu siri beiraaui ta'i tangahuru mana ta'i Ha'ataari. ");
INSERT INTO aia_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ma na'i dangi na 'iraaui Jiu ra ha'ato'oai Rongo nara 'unua 'iniai Pentikos, 'iraau hakoi sae hinihini rau rurugoni na'i ta'i dora. ");
INSERT INTO aia_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Raugu 'asu'a marau rongoa'ai maho na rongo raha na dio mai baaniai aro. 'A rongo 'onaai kae ro'a raha. Mana aohanai ro'asi 'a rongo raha hako 'ari raronai ruma narau awa 'ieisi. ");
INSERT INTO aia_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Miraau re'i'i maho ra 'ome 'onaai gere ngarungarui 'eu ra 'adarara na'i raronai rumasi. Ra dio na'i hungadaau hako. ");
INSERT INTO aia_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mana Hi'ona Maea 'agu sirihiraau maraugu taraawa'a hadahada 'ini'i mwani hadahada he'ete'i hairiu na Hi'ona Maea na hau'i tanaraau. ");
INSERT INTO aia_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ma na'i 'ohasi, 'a ragoi saeni Jiu na'i Jerusalem narau boi baani'i mwani kantri he'ete'i hairiu na'i marewana narau ai'a aidangisia maua Jisas, ma'ata ra 'adoma'i ha'ahihi'aa God. ");
INSERT INTO aia_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Na'i 'oha rau rongoai maho na rongo 'onaai ro'a rahasi, rau goni ro'u mai beiraaui noni hinihini. Marau heimwaota'i, 'inia 'iraaui noni hinihini rau hadahada 'ini'i hadahada adaa'i. ");
INSERT INTO aia_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Rau heimwaota'i ma bu'o i ahudaa'i marau o'ani, “Romwane! Sae 'inisi ra'i saeni Galili moi neiraaunisi! ");
INSERT INTO aia_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","'A he'ua naraugu 'irara'i 'ini'i hadahada agaa'isi? ");
INSERT INTO aia_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tara'i sae gau boi baaniai Patia, Midia, ma na'i Elam. Tara'i abe baaniai Mesopotemia, Jiudea, Kapadosia, Pontas, Eisia, ");
INSERT INTO aia_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frijia, Pamfilia, Ijip, mana'i Libia gaarangiai Saerin. Ma tara'i abe gau boi ro'u baaniai Rom. ");
INSERT INTO aia_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tara'i nei ra'i sae ni Jiu ha'a-momori ma tara'i nei ra awa suria moi ringeringe agaaui Jiu. Tara'i sae gau boi baaniai Krit mana'i Araibia. Me'igaau hako gau rongoai hadahada adaau 'ini'i hadahada agaa'i 'abai'i kae maho na hau'ia God.” ");
INSERT INTO aia_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Rau heimwaota'i ma kakui ahudaau ro'u, marau taraawa'a songa'iniraau hairiu o'ani, “'E taha gasi naasi romwane?” ");
INSERT INTO aia_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tara'i abe rau ha'ada'ada'a 'iniraau, rau o'ani, “Rau gonogono gasi marau bweu'a.” ");
INSERT INTO aia_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Miraau hakoi ta'i tangahuru mana rua Ha'ataari rau ura ara'a mia Pita 'a ha'atee raha tanaraaui sae narau goni mai 'isi o'ani, “'I'amoui sae ni Jiu me 'i'amou ro'u i sae namou awa na'i Jerusalem, moi bahurongo goro mawai ha'a-aidangisi'amou 'iniai maho na to'o na'i 'ohanisi. ");
INSERT INTO aia_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","'I'amou mou 'adoma'inia do 'iraaui sae 'ini rau gonogono marau bweu'a. Magu ai'a! 'Agu angi siwa moi haho'oa 'ohanisi. ");
INSERT INTO aia_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ma'ata maho namou re'ia na to'o na'i 'ohanisi, 'ia Rarabea Joel 'a bwane taroha'inia mai ga'u na'i 'oha bwani. ");
INSERT INTO aia_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","'Ia God 'a o'ani, ‘Na'i 'oha nai raumwadu mai hahakonai dangi, wai ha'ataaria dio i Hi'ona Maea agua maai sirihiai tahinganai 'ado sae. Miraau gare amoo'i rai haa'i ha'atee rarabea. 'Iraau sae haoru amoo'i rai re'i'i ha'amaranga, miraau noni wari amoo'i rai re'i'i ha'amaranga na'i mauru. ");
INSERT INTO aia_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ha'amomori! Na'i 'ohasi wai ha'ataaria dio i Hi'ona Maea agua maai sirihiraaui noni tatau'aro agu'i, rei'uaa sae mwane ma'ua urao, marai haa'i ha'atee rarabea. ");
INSERT INTO aia_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mamoi re'i'i ha'ara mana ha'abu'oahu nawai haa'i na'i ahoasara mana'i ano. I 'abu, ma 'eu mana kaeni asuasu raha rai ha'ata'i. ");
INSERT INTO aia_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na sina 'abwa'i rara, mana hura 'ai wangawanga 'onaai 'abu, maigu to'o i dangina Araha na ororiu di'u ma hauasa. ");
INSERT INTO aia_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Miraaui nei rau ha'arahesia God rai tahi.’ ");
INSERT INTO aia_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Moi rongo'i ha'atee 'ini noni nai Israel! Mou 'iraraa goro do 'ia Jisas ni Nasaret 'a haa'i mwani ha'abu'oahu mana ha'ara, 'inia mareho 'isi ra to'o na'i kantri agaauni. Ni mwani ha'abu'oahu na haa'isi, ra ha'ata'inia goro hura'a do'ia God naasi na ha'ataaria mai. ");
INSERT INTO aia_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Me suriai hei'irisina mau mai, 'ia God 'a ha'awatea do moi daua Jisas. Mamou ha'amaesia 'oha mou taranga'inia tanaraaui noni ta'a'i 'anai rabu ahita'inia na'i dadaahoro. ");
INSERT INTO aia_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mia God 'a ruhasia baaniai mena anai mae ma ha'atahia aho'i. 'Iniai mae, 'abwa'i ha'abwarasia baaniai tahi aho'i. ");
INSERT INTO aia_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Na'i buka ni Psalm, 'ia Deved 'a hadanga'iniai mae ana Jisas o'ani, ‘'A bwa'i ta 'oha'a ro'u nawaigu mamaa'usia ta maho, 'inia i'oe a Araha God na'o awa tarau beiau. I'oe 'o na'otaragu. ");
INSERT INTO aia_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Naasi, 'au wa'ewa'e raha, mau hadahada ha'i wa'ewa'e ro'u. 'Inau 'au 'iraraa dowai tahi aho'i, ");
INSERT INTO aia_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","'inia 'o bwa'i wateai abenai noni maea amua 'anai ngabo na'i ano, mana aungagu do'ai awa tarau na'i dora adaaui nei nara mae. ");
INSERT INTO aia_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","I'oe 'o ha'ata'inia tanaau i tara 'anai tahi tarau, minau wa'ewa'e 'iniai awa amua beiau.’ ");
INSERT INTO aia_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“'Inau raba 'unua tana'amou mwani sae agu'i, 'abaiai wauwa agaau na'i 'oha bwani, 'ia Mwaeraha Deved. 'Iia 'a bwani mae mara bwani toringia orea mana barabarana 'a awa mau tari dangini. ");
INSERT INTO aia_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","'Ia Deved 'e Rarabea, ma 'iraraa do 'ia God 'a haua tanaa i duruduru hihi'a do baaniai burungana haaria nai ha'amwaeraha iei ta sae 'onaaia haaria. ");
INSERT INTO aia_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","'Ia Deved 'a bwane 'iraraai maho na'ia God nai haua. Naia na ha'atee rarabeanga'iniai suruta'e nai haa Ha'atahi ma ro'u do 'iia 'a bwa'i awa tarau na'i dora adaa'i nei nara mae, mana abena 'a bwa'i ngabo. ");
INSERT INTO aia_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“'Ia God 'a ha'a-suruta'ea ha'a-momori a Jisas baaniai mae. 'I'ameu hako meu re'ia 'ini'i maamee'i. ");
INSERT INTO aia_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","'Ia Godi Ama 'a waia ara'a ma ha'aheinagua na'i aba odona 'anai ha'a-ororiua. Mana Ama 'a ha'awatea Jisas 'anai ha'ataariai Hi'ona Maea tana'ameu 'onaai bwane durua ana God. Ma naasi maho namou rongoa mamou re'ia na'i 'ohanisi. ");
INSERT INTO aia_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ma'ata 'ia Deved 'a ai'a ara'ai aro 'anai heinagu na'i aba odona God, me 'iia 'a o'ani, ‘'Ia Araha God 'a o'ani 'inia Araha agua, “'Oi heinagu na'i aba odogu, ");
INSERT INTO aia_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tari 'oha wai nugaraau dio i maerongamu na'i bahainai heimarungi amua.”’ ");
INSERT INTO aia_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ma naasi 'i'amou hakoi sae ni Israel, mou ga'i aidangisia dona 'ia Jisas na mou ngahu ha'amaesia na'i dadaahoro ani, 'ia God 'a 'ome sigihia na Araha mana Ha'atahi.” ");
INSERT INTO aia_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na'i 'oha raugu rongoa o'asi, rau ta'i kaeni arunga ta'aa di'u marau songa'inia Pita miraau tara'i Ha'ataari ro'u o'ani, “Romwane! 'E taha meigu haua?” ");
INSERT INTO aia_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mia Pita 'a aramiraau, 'a o'ani, “Moi rihosi baani'i ora-ora'a amoo'i mamoi bwareomaea 'iniai atana Jisas Kraest. Mia God 'a duruduru 'inia do 'ai 'adoma'i nugasi'i ora-ora'a amoo'i maai watea mai Hi'ona Maea tana'amou. ");
INSERT INTO aia_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Na durudurusi, 'a haua tana'amou beiraaui gare amoo'i, miraau ro'u i nei rau awa ha'atau. Ha'amomori, na durudurusi 'a haa tanaraau hako ro'u i nei na 'ia God na 'unuraau.” ");
INSERT INTO aia_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","'Ia Pita 'a hadahada orea tanaraau ma ha'ata'u'uraau wetewete o'ani, “Moi 'ome'ome goro, mou gasigu siri na'i ha'a-mama'ai na'i dangi ni hihiiri 'onaairaaui sae ta'a'i na'i 'ohanisi.” ");
INSERT INTO aia_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Naasi 'iraaui nei rau rongo'i ha'atee ana'ia Pita marau hinihini, ra bwareomaearaau na'i 'ohasi. Na'i madoraasi, 'a ga'i 'onaai oru merui sae narau aho'ita'i sae hinihini. ");
INSERT INTO aia_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Miraausi rau mwa'emwa'e goro 'anai bahurongo'i ha'ausuringa'i adaa'i Ha'ataari marau 'a'auhiraau hairiu. Marau matai boi goni ro'u 'anai ngau mana ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","'Iraaui Ha'ataari rau haa'i mwani ha'ara mana ha'abu'oahu 'iniai mena na'ia God 'a haua tanaraau. Miraaui noni hunga rau heimwaota'i di'u. ");
INSERT INTO aia_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Me 'iraaui noni hinihini rau ruru goni tarau marau taraawa'a hisu hairiu 'ini'i bori adaa'i 'ini'i 'ado maho rau rabasi'i. ");
INSERT INTO aia_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Marau raonga'ini'i ro'u i toto'ora adaa'i, ma tara'i maho ro'u 'anai 'a'auhiraau ro'u i nei rau awa ha-ha'aroha'a. ");
INSERT INTO aia_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Rau boi goni 'anai ha'arahesi 'ado dangi na'i Ruma Maea ana God marau mwa'emwa'e goro 'anai 'ari goni ro'u suri'i ruma adaa'i 'anai ngaugoni beiai ahu wa'ewa'e. ");
INSERT INTO aia_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","'Ado 'oha moi narau 'unu ha'aasaa God, miraaui noni rau 'adoma'i ha'ahouraau. Mana ruruha adaau 'a rago hanehane ara'a moe'a 'ado dangi 'iniraaui nei na 'ia God 'a ruhasiraau baani'i ora-ora'a adaa'i. ");
INSERT INTO aia_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","'E ta'i dangi na'i angi oru abaidangi, 'ia Pita mea Jon raru 'ari Ruma Maea ana God, 'inia naasi madoraa nara matai ririhunga'i. ");
INSERT INTO aia_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","'Ado dangi 'e sae na pwaki mau mai 'oha na huta, ra suru'ia mai 'anai ha'aheinagua na'i bobonai maraaruma anai bara na'i Ruma Maeasi 'anai ha'angoni ha'a beiraaui sae rai siri 'anai ha'arahesi. Na maraarumasi ra 'unua 'iniai “Maanai Bara 'Ome Goro.” ");
INSERT INTO aia_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ma na'i 'oha na re'ia Pita mea Jon raru boi 'anai siri Ruma Maea, ma ha'angoni ha'a beirarua'a. ");
INSERT INTO aia_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Mia Pita mea Jon raru wanasia mia Pita 'a o'ani, “'Osu wana ga'u mai 'ini.” ");
INSERT INTO aia_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mia mo'osi 'a wanasirarua ma 'adoma'inia do rarui hisungia 'inia ta maho. ");
INSERT INTO aia_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mia Pita 'agu o'ani moi 'inia, “'Inau ai'a to'o ha'a. Ma'ata 'e maho he'ete'i moi nau to'oraa, ma naia nawai haua tana'o. Wai 'unua tana'o na'i atana Jisas Kraest ni Nasaret, 'oi ura ara'a ma'oi hahano!” ");
INSERT INTO aia_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ma dau na'i rima odona ma ha'a-suruta'ea. Na'i mau 'ohasi na rua uwana rarugu wetewete aho'i, ");
INSERT INTO aia_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ma ura ara'a ma taraawa'a hahano. Marau ta'i siri wou na'i Ruma Maea mia mo'osi 'a regerege ma 'unu ha'aasaa God. ");
INSERT INTO aia_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ma na'i 'oha 'iraaui sae rau re'iai hahano ana ma 'unu ha'aasaa God, ");
INSERT INTO aia_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","rau 'ome 'iraraa do'ia mo'osi na heinagu tarau na'i bobonai maraaruma anai bara na'i Ruma Maea 'anai ha'angoni ha'a ani. Ra bu'o hakoi ahudaa'i 'iniai hahano aho'i na haa mo'osi. ");
INSERT INTO aia_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","'Iraaui sae rau heimwaota'i di'u marau 'eba mai beiraau na'i Ruma Maea na'i dora ra 'unua 'iniai “Abaihare ana Solomon.” Na'i 'ohasi, na sae na pwaki ga'u ani, 'a dau mau wou beia Pita mea Jon. ");
INSERT INTO aia_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ma na'i 'oha 'ia Pita 'a re'ia do rau goni mai beia, 'a o'ani 'iniraau, “Mwani noni ni Israel, 'a 'ua namou heimwaota'i mamou wana wetewete 'ini'amiria? Mou 'adoma'inia do miri ha'ahahanoa mo'oni 'iniai mena amiria haarimiria ma'uasi mou 'adoma'iniai do miri odo-odo na'i maana God na miri ha'ahahanoa 'inia mo'oni? Ai'a! ");
INSERT INTO aia_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God adaaui wauwagaa'i, 'iraaua Ebraham mea Aisak mea Jekop, na hauai maho namou re'iani, neina 'igaau gai ha'aasaai atanai noni tatau'aro ana, 'ia Jisas. Mi'amougu taranga'inia Jisas tanaraaui saemaua adaa'i Rom 'anai ha'amaesia. Rei'uaa na'ia Paelat 'a raba ruhasia dadara'a mi'amou mou ai'a rabasia o'asi. ");
INSERT INTO aia_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","'I'amou mougu ha'angonia do'ai ruhasia dadara'a i sae hahaingahu. Mamougu 'itaai sae na awa maea ma odo-odo. ");
INSERT INTO aia_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mougu ha'amaesia mo'o na matai haua tana'amoui huunai tahi. Ma'ata 'ia God 'a ha'a-suruta'ea aho'i baaniai mae. 'I'ameu nameu 'omera'i maa 'iniai mahosi. ");
INSERT INTO aia_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","'I'amou mou re'iai sae pwakini mamou aidangisia ro'u. 'I'amiria miri ha'ahahanoa mo'oni 'iniai mena ana Jisas. Meu hinihiniai atana Jisas ma naia nagu hahano aho'i 'inia i sae pwakini. ");
INSERT INTO aia_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mwani sae agu'i, 'au 'iraraa do 'imoou mana na'otara amoo'i mou hauai maho ta'aa tanaa Jisas 'inia mou ai'a aidangisia do'ia God na ha'ataaria mai. ");
INSERT INTO aia_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ma'ata 'ia God 'a bwane ha'ateenga'inia tanaraaui Rarabea doni Ha'atahi 'ai rongomaata'i, ma naanigu ha'ato'oanai maho na bwane ha'atee duruduru 'inia ani. ");
INSERT INTO aia_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Naasi moi orisi mamoi rihota'i tanaa God mia God 'ai ha'a-ai'a'i ora-ora'a amoo'i. ");
INSERT INTO aia_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","'Onaa moi haua o'asi, 'ia Araha God 'ai ha'a-'o'ori'i 'adoma'imoo'i maigui ha'ataaria aho'i maia Jisas Kraest tana'amou. 'Ia naasia mo'o na 'ome sigihia 'anai Ha'atahi aga. ");
INSERT INTO aia_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ma'ata 'ia Jisas 'ai awa ga'u na'i aro tari madoraa na'ia God 'ai ha'ahaoru'i hakoi mwani maho, 'onaai bwani 'unua adaaui Rarabea maea na'i 'oha bwani. ");
INSERT INTO aia_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ma 'onaai bwani 'unua ana Moses. 'A o'ani, ‘'Ia God 'ai 'ome sigihia ta Rarabea 'onaaiau baaniraaui sae amoo'i, 'iraaui Jiu. Moi rongosuri'i mwani mareho nai 'unu'i. ");
INSERT INTO aia_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mia tei na bwa'i rongosuriai Rarabeasi, 'a bwa'i awa bei'amou na'i ta'i ruruha mia God 'ai ha'a-ai'aa.’ ");
INSERT INTO aia_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Maho naragu to'oto'o na'i madoraanisi, 'ia Samiuel miraau Rarabea naraugu awa ro'u na'i muri, rau bwani maani'i hako'a. ");
INSERT INTO aia_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","'I'amou ra'i gare adaa'i Rarabea 'isi, ma naasi ni duruduru na'ia God 'a haua tanaraaui wauwa amoo'i 'ai 'ari ro'u tana'amou. 'Inia God 'a duruduru tanaa Ebraham do 'iraau hakoi sae ni marewana rai dauai ha'agorohi baaniai burungana Ebraham. ");
INSERT INTO aia_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ma naasi, 'ia God 'a 'ome sigihiai sae tatau'aro ana, 'ia Jisas, ma ha'ataaria mai neina moi dauai ha'agorohi ana mamoi rihosi mamoi nugasi'i baronga ta'a'i amoo'i.” ");
INSERT INTO aia_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","'Ia Pita mea Jon raru hadahada mau tanaraaui noni hunga, me 'iraau tara'i Piriisi beiai bwauodo adaaui sae hehei'oi nara 'omesuriai Ruma Maea ana God, miraau ro'u tara'i Sadiusi rau ada'a. ");
INSERT INTO aia_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Rau taesu'a di'u 'ana Pita mea Jon 'iniai maania adarua doni suruta'e aho'i ana Jisas 'a ha'ata'inia do 'iraau sae rai matai suruta'e aho'i ro'u baaniai mae. ");
INSERT INTO aia_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Raugu ha marau daurarua'a. Ma 'inia 'a su'urahi'a marau nugararua na'i rumaniho'o tari haho'oa. ");
INSERT INTO aia_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma ragoi nei rau bahurongorarua rau aho'ita'i sae hinihini. Ma naasi goni beiraaui nei narau bwani hinihini, 'a 'onaai rima merui sae. ");
INSERT INTO aia_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na'i moi nata dangi, me 'iraaui bwauodo miraaui saemaua adaa'i Jiu, beiraaui Ha'ausuri 'anai Ringe ana'ia Moses rau goni'a mai na'i Jerusalem. ");
INSERT INTO aia_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","'Ia 'Anas, i Na'ohadaaui Piriisi, mea Kaeafas, mea Jon, mea Aleksanda miraau ro'u tara'i nei na'i burungana 'Anas rau boi ro'u. ");
INSERT INTO aia_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Marau waia maia Pita mea Jon. Rau ha'a-urasirarua na'i 'ubutadaau maraugu songa'inirarua o'ani, “Mena ana tei mana mena he'ua namuru haua 'anai ha'agorohia aho'i a mo'oni?” ");
INSERT INTO aia_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mia Pita i Hi'ona Maea 'a rabe beia ma aramiraau o'ani, “Tana'amou bwauodo adaa'i Jiu, mi'amou tara'i saemaua ro'u, ");
INSERT INTO aia_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","na'i 'ohani mou raba kootimiria 'iniai haua amiriai maho na goro tanaai sae na pwaki uwana. Mamou raba aidangisia ro'u i here miri haua nagu goro aho'i 'inia. ");
INSERT INTO aia_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mawai rangasia tana'amou miraau hako ro'u sae ni Israel do sae na ura na'i maamoou nisi, 'a goro aho'i 'iniai mena ana Jisas Kraest ni Nasaret namou ngahu ha'amaesia na'i hunganai dadaahoro ani, mia God 'a ha'atahia aho'i ro'u moi. ");
INSERT INTO aia_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mia Jisas naasi na Usu-usu Maea 'a hadanga'inia o'ani, ‘Na hau 'i'amou sae tatau'aro ruma mou 'itaa, 'agu buna ha'i hau ororiu di'u na'i bani anai ruma.’ ");
INSERT INTO aia_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","'Iia moia Jisas na matai ruhasigia baaniai ora-ora'a. 'A bwa'i ta sae'a ro'u na'i marewana nagaigui 'u'uria!” ");
INSERT INTO aia_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","'Iraaui sae rau ha'akootia Pita mea Jon, rau heimwaota'i, 'inia raru ai'a mamaa'usiraau, rei'uaa raru ai'a sae ororiu mararu ai'a skuru goro. Ma'ata 'iraau sae 'isi, raugu 'adoma'i aho'isia do 'iraruasi raru matai 'aariha beia Jisas. ");
INSERT INTO aia_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mana sae na goro aho'isi, rau ta'i ura ro'u. Ma bwara'a 'anai 'unua ro'u ta maho. ");
INSERT INTO aia_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Raugu bairaau moi wera orusi hura'a, 'iniai dorasi 'iaadaaui Kansol 'Iraau moi haariraau naraugu tara mamaaniai mahosi. ");
INSERT INTO aia_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Rau o'ani, “Gaigu ha'ahe'uararua rua mwanesi? 'Inia 'iraau hakoi sae ni Jerusalem rau bwane 'iraraa'ai haua adaruai ta'i ha'abu'oahu ani, rau bwa'i hinihinigaau 'onaa gai 'unua do 'a ai'a ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Magu ai'a goro i ha'ausuringa'i 'osi, rau gasi rongoa ro'u tara'i sae. Gai ha'atee ha'abasurarua wetewete mararui abu taroha'inia'a a Jisas.” ");
INSERT INTO aia_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Miraau 'unurarua aho'i mai marau ha'atee wetewete tanararua do rarui abu maania ma'uasi ha'ausuria ro'u ta sae 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mia Pita mea Jon raru aramiraau o'ani, “Moi wai'ado'ado goro. Nei he'ua na odo-odo? Mirii araisuri'amou ma'uasi araisuria God? ");
INSERT INTO aia_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","'I'amiria miri bwa'i agoheta'i maani'i maho namiri re'i'i mamiri rongo'i.” ");
INSERT INTO aia_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Miraaui saemaua na'i Kansol rau ha'abasurarua wetewete di'u ro'u wou. Maraugu nugasirarua. 'Inia 'a bwara di'u 'anai ha'a-mama'airarua, 'inia rau 'ome 'iraraa do 'iraaui noni hunga rau ha'aasaa moe'a God 'iniai maho narau re'ia ani. ");
INSERT INTO aia_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mana sae pwaki na to'o tanaa i ha'abu'oahusi, na harisina 'a di'ua'ai hai tangahuru. ");
INSERT INTO aia_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Rau nugasirarua woua Pita mea Jon mararu 'ari aho'i beiraaui sae hinihini mararu maani'i mwani maho 'iraaui Na'ohadaa'i Piriisi miraaui saemaua rau 'unu'i tanararua. ");
INSERT INTO aia_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ma na'i 'oha rau rongoai maho raru maaniasi, 'iraau hako rau ha'arahesi goni o'ani, “God, i'oe na'o Mwaeraha, mi'oe na'o ha'apwa'araai ahoasara mana ano mana asi mana mwani maho na'i rarodi. ");
INSERT INTO aia_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mana Hi'ona Maea amua na ha'atee hura'a na'i ngoonai wauwa ameeu, i sae tatau'aro amua Deved. 'A ha'atee o'ani, ‘Ni 'uaana 'iraaui sae rau ai'a Jiu rau taesu'a 'inia? Ni 'uaana narau hau'i 'inia i ha'aradorado nara bwa'i uranga'ini'i? ");
INSERT INTO aia_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","'Iraau mwaeraha ni marewanani rau ha'aagau 'anai hei'oi. Miraau nei rau marungiai marewanani rau hauai ta'i ruruha marau ha'aagau 'anai hei'oi beia God mana nei na 'ome sigihia 'anai Ha'atahi.’ ");
INSERT INTO aia_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ma naasi taha na to'o na'i 'omaanisi! 'Ia Herod Antipas mea Pontias Paelat raru hauai ta'i ruruha beiraaui nei rau ai'a Jiu mei beiraau ro'u i Israel 'anai ura bwarasia Jisas, sae tatau'aro maea amua na'o 'ome sigihia 'anai Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ni here raugu hauasi, 'a 'ari moi suriai maho na'o bwane ha'arangasia mau mai 'oha bwani do 'ai o'asi suriai hei'irisi mana mena amua. ");
INSERT INTO aia_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","God, 'oi 'ome riariaa goro na'i 'ohani hadahada wetewete adaaui saemaua tana'ameu. 'Oi 'a'auhi'ameu sae tatau'aro amu'i, mei abui mamaa'u 'anai taroha'iniai ha'atee amua. ");
INSERT INTO aia_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","'Oi ha'ata'iniai mena amua mamei ha'agorohi'i aho'i nei ra daoha, mamei haa'i ha'abu'oahu mana ha'ara ro'u 'iniai atana Jisas, sae tatau'aro maea amua.” ");
INSERT INTO aia_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Raugu ha'arahesi hako moi wou, mana ruma narau awa na'ieisi 'a 'ihara'i'a. Mana Hi'ona Maea 'agu sirihiraau hako ma na'i muri raugu wetewete 'anai taroha'iniai Taroha Goro 'inia Araha. ");
INSERT INTO aia_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na'i 'ohani, 'iraaui sae hinihini rau to'oraai ta'i 'ado'ado, ma ai'a ta ta'i nei beiraau nai 'adoma'inia 'anai to'oraa haaria ta maho. Na maho rau to'ora'i 'iaadaa'i goni hako. ");
INSERT INTO aia_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","'Iraaui Ha'ataari rau wetewete di'u 'anai maaniai suruta'e aho'i ana Araha Jisas baaniai mae. Mia God 'a ha'agorohiraau di'u. ");
INSERT INTO aia_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ma ai'a ta nei ro'u beiraaui noni hinihini nai pwapwaku 'inia ta maho. 'Inia 'iraaui nei rau to'o dorai ano ma'ua to'o ruma rau matai raonga'ini'i ro'u mana ha'a ra hori'i 'ini'i ");
INSERT INTO aia_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","raugu haa'i tanaraaui Ha'ataari. 'Iraau naraugu ha'atora'ini'i tanaraau i nei narau 'irisiai hei'a'auhi. ");
INSERT INTO aia_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ma 'e ta'i sae baaniai burungana Livae na huta na'i maraui Saepras na atana 'ia Josep. Ma'ata 'iraaui Ha'ataari rau matai 'unua ro'u 'inia Banabas, ni 'ado'ado 'anai atasi “Sae na ha'a-'o'oriai 'ado'adonai sae.” ");
INSERT INTO aia_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","'Iia ro'u 'a raonga'iniai dorai ano ana mana ha'a 'a haua tanaraaui Ha'ataari. ");
INSERT INTO aia_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","'E ta'i 'oha, 'e sae na atana 'ia Ananaeas beiai urao ana, 'ia Safaera, raru raonga'inia ro'u ta'i dorai ano adarua. ");
INSERT INTO aia_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Raru 'adoma'i aratara 'anai pwari'iraaui Ha'ataari mararu giruai dora 'iniai ha'asi do raruigu to'oraa haarirarua. Mana nata dora raru haua tanaraau. ");
INSERT INTO aia_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mia Pita 'a o'ani 'inia Ananaeas, “'Iniai 'uaana na'o ha'awatea 'inia Saetan 'anai tau'aro na'i 'adoma'imu? 'Iniai 'uaana na'o pwari'ia 'iniai Hi'ona Maea, na'ogu girua 'iniai nata aba 'iniai ha'a nara horia 'iniai dorai ano na'o raonga'iniasi? ");
INSERT INTO aia_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Na'i 'oha 'o ai'a raonga'inia mau i dorai anosi, dorai anosi 'iaamua haari'o. Ma rei'uaa no'o raonga'inia mana ha'a ra horia 'inia 'iaamua ro'u mau. Naasi, ni 'uaana no'ogu raba pwari'i 'inia? I'oe 'o ai'a pwari'iraau moi inoni, ma'ata 'o pwari'ia ro'ua God.” ");
INSERT INTO aia_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Na'i 'oha 'ia Ananaeas 'agu rongoa moi 'unu o'asi ana Pita, ma rahuta'i dioi ano ma mae'a. Miraaui nei rau rongoai maho na to'osi rau mamaa'u raha di'u. ");
INSERT INTO aia_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tara'i gere sae rau siri mai marau hiri ho'uai abena Ananaeas marau waia hura'a wou marau 'ari toringia. ");
INSERT INTO aia_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","'A gaarangi 'onaai oru 'aoa na hako maagu siri mai ro'u urao ana Ananaeas na'i rumasi. 'Iia 'a ai'a 'iraraai maho na to'o beiai mwane ana. ");
INSERT INTO aia_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","'Ia Pita 'a o'ani 'inia, “'A 'ua? Naia hako'ai ha'a nara horia 'iniai dorai ano amurua ani naanisi?” Mia aramia o'ani, “Naia moi naasi.” ");
INSERT INTO aia_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","'Ia Pita 'agu o'ani 'inia, “Ni 'uaana namuru 'adoma'i aratara 'inia 'anai pwari'iai Hi'ona Maea ana God 'anai sadoia 'onaa 'ai ha'a-mama'ai'amou ma'ua bwa'i? 'Ome, 'iraau gere sae narau toringiai mwane amua neiraau'a hura'a wou maraarumasi. 'Iraau rai suru'i'o hura'a ro'u'ana!” ");
INSERT INTO aia_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na'i moi 'ohasi 'a rahuta'i dio na'i maana Pita ma mae'a. Miraaui gere sae rau siri mai marau 'omesia do 'a mae'a ro'u. Rau suru'ia hura'a marau toringia na'i bobonai mwane ana. ");
INSERT INTO aia_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Miraau sae hinihini beiraaui nei rau rongoai maho na to'osi, rau mamaa'u hako. ");
INSERT INTO aia_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","'Iraau sae hinihini rau matai boboi goni na'i “Abaihare ana Solomon,” 'e ta'i dora na'i Ruma Maea ana God. Miraaui Ha'ataari rau haa'i mwani ha'abu'oahu mana ha'ara na'i maadaaui noni hunga. ");
INSERT INTO aia_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","'Iraaui nei rau ai'a noni hinihini rau mamaa'u 'anai boi goni beiraau. Rei'uaa na o'asi, 'iraau sae 'isi rau 'adoma'i ha'a-hihi'araaui nei hinihini. ");
INSERT INTO aia_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ma rago ro'u i sae mwane mana urao rau aho'ita'i sae hinihini marau siri wou 'anai ha'i ta'i ruruha beiraaui sae hinihini. ");
INSERT INTO aia_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Suriai re'ia adaau mwani ha'abu'oahu narau haa'i Ha'ataari, 'iraau sae rago rau waa'i mai sae daoha marau ha'adaohi'i suri'i hi'o mana be'a na'i bobonai tara. Na'i 'adoma'idaa'i do na'i 'oha 'ia Pita 'ai tahahoro mai mana nununa 'ai marumarusiraaui sae daoha 'isi marai goro'a aho'i. ");
INSERT INTO aia_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","'A rago di'u i sae suri'i gere 'omaa gariai Jerusalem narau goni mai ro'u. Rau waa'i mai sae daoha mana nei ra bwauni'i adaro marau goro hako aho'i. ");
INSERT INTO aia_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","I Na'ohadaaui Piriisi miraau nei rau tau'aro beia na'i ruruha adaaui Sadiusi, rau taesu'a di'u 'iniai rago anai sae nara boi 'ado 'oha beiraaui Ha'ataari. ");
INSERT INTO aia_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Marau dauraau mara nugaraau na'i rumaniho'o. ");
INSERT INTO aia_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ma na'i moi rodo, 'ia God 'a ha'ataariai enjel ana ma tahangiai maraaruma anai rumaniho'o tanaraaui Ha'ataari. 'A na'otaradaau hura'a ma o'ani, ");
INSERT INTO aia_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Moi 'ari Ruma Maea ana God mamoi maani'i mwani maho hako 'abaiai tahinga haorusi tanaraaui sae.” ");
INSERT INTO aia_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Na'i mau haho'oa ta'aa miraau Ha'ataari rau 'ari'a na'i Ruma Maea 'onaai 'unua anai enjel tanaraau marau ha'ausuriraau'a i noni hunga. Mana Na'ohadaaui Piriisi miraau nei rau tau'aro beia, rau 'unuraau mai hakoi sae mwanemaua ni Jiu narau awa na'i ruruha nara 'unua 'iniai Kansol. Marau ha'a-taariraaui sae hehei'oi nara 'omesuriai Ruma Maea 'ari rumaniho'o 'anai wairaau aho'i mai Ha'ataari. ");
INSERT INTO aia_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Raugu 'ari wou marau ai'a sadoiraau'a. Marau aho'i mai marau heimaani o'ani, ");
INSERT INTO aia_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Meu ada wou na'i rumaniho'o mana maraaruma ra honohono baabau mau, miraau hehei'oi narau 'omesuri'i maraaruma rau ura-ura mau ro'u. Ma na'i 'oha meugu tahangi'i maraaruma nameugu siri wou 'ome, ma ai'a ta sae nameigu re'ia.” ");
INSERT INTO aia_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na'i 'oha na bwauodo adaaui sae hehei'oi nara 'omesuriai Ruma Maea miraaui Na'ohadaa'i Piriisi raugu rongoa o'asi, ma kakui ahudaau marau wai'ado'ado 'iniai taha naigu to'o ro'u na'i muri. ");
INSERT INTO aia_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ma na'i 'ohasi, 'e ta'i sae na boi ma o'ani 'iniraau, “Romwane! 'Iraau sae namou nugaraau na'i rumaniho'o ani, na'i 'ohanisi raugu ha'ausuriraau moe'ai sae na'i Ruma Maea!” ");
INSERT INTO aia_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mana bwauodo adaaui sae hehei'oi nara 'omesuriai Ruma Maea beiraaui sae tatau'aro ana'i rau 'ari marau 'abenga'i wairaau moi hura'a i Ha'ataari, 'inia rau mamaa'usiraaui noni hunga. Rau gasigu buta'iraau 'ini'i hau. ");
INSERT INTO aia_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mara wairaau mai Ha'ataari mara ha'a-urasiraau na'i maadaau Kansol. Mana Na'ohadaaui Piriisi 'agu o'ani, ");
INSERT INTO aia_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Meu bwane 'unua tana'amou domoi abu ha'ausuri 'iniai ha'ausuringa'i ana Jisas, mana ha'ausuringa'isi 'a garia hako'ai Jerusalem. Mamou subuni'ameu ro'u 'iniai mae na haua ani a Jisas.” ");
INSERT INTO aia_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mia Pita na heiarami tanaraaui Ha'ataari, 'a o'ani, “'I'ameu mei araisuriai taha 'ia God na 'irisia, meu bwa'i araisuriai hei'irisidai inoni. ");
INSERT INTO aia_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","'I'amou namou rabu ahita'inia Jisas na'i dadaahoro mamou ha'amaesia, mia God adaaui wauwa agaa'i, 'a ha'atahia aho'i baaniai mae. ");
INSERT INTO aia_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ma waia ara'a ma ha'aheinagua na'i aba odona 'anai marungigaau mana ruhasigaau inoni nai Israel baaniai ora-ora'a. 'A haua o'asi do 'igaau gai nugasi'i baronga ta'a'i agaa'i maai 'adoma'i nugasi'i ora-ora'a agaa'i. ");
INSERT INTO aia_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","'I'ameu naasi 'anai ha'arangasi'i maho 'ini tana'amou, mana Hi'ona Maea 'a ha'arangasia ro'u do ra ha'a-momori. Mana Hi'ona Maeasi, 'ia God 'a haua tanaraaui nei rau araisuria.” ");
INSERT INTO aia_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na'i 'oha 'iraau Kansol rau rongoai ha'atee o'asi ana Pita, rau kae taesu'a di'u marau raba ha'amaesiraaui Ha'ataari. ");
INSERT INTO aia_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ma'e ta'i beiraaui Kansol na atana 'ia Gamaliel, 'a ura ara'a ma 'unua dorai ha'a-hura'ahiraau ga'u i Ha'ataari. 'Iiani 'e Farisei ma'e ta'i 'iniraaui Ha'ausuri adaa'i Ringe nara ha'ahoua. ");
INSERT INTO aia_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Maagu ha'atee tanaraau o'ani, “'Igaau saeni Jiu, gai wai'ado'ado goro ga'u suriai maho mou raba hauasi! ");
INSERT INTO aia_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","'E ta'i 'oha, 'e sae nara 'unua 'inia Tiudas 'a 'adoma'inia do 'iia 'e ta'i sae ro'u, ma gaarangi 'onaai hai 'arangi sae narau suria. Ma na'i moi murinai ngahuia ada, miraaui sae ana'i rau 'adarara'a aho'i mana ruruha ana 'a ai'aa moi. ");
INSERT INTO aia_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Na'i muri, 'oha na to'o i usu ata, 'ia Jiudas saeni Galili, 'a rago ro'u i nei na ogeraau 'anai suria. Ma na'i 'oha ragu ngahuia, 'iraaui sae ana'i raugu ha marau 'adarara'a aho'i ro'u moi. ");
INSERT INTO aia_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Naasi gai nugasiraau wou. 'Onaa ni maho rau hauasi 'a suria moi 'adoma'idaau haariraau, mana mahosi 'a bwa'i orea mai ai'aa'a aho'i ro'u. ");
INSERT INTO aia_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma 'onaa rau hauai hei'irisina God, ma mou bwa'i matai ha'a-bwarasiraau mwada'u. Mou gasi ura bwarasia God.” ");
INSERT INTO aia_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Miraau hako rau 'adoma'i aratara 'iniai maho na 'unua Gamaliel. Rau 'unuraau aho'i sirimai Ha'ataari, mara 'unua tanaraaui sae tatau'aro adaa'i dorai rohoraau'a. Marau ha'abasuraau wetewete dorai abu maania'a ro'ua Jisas. Naasi maraugu ha'a-hura'ahiraau. ");
INSERT INTO aia_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na'i 'oha rau hura'a rau wa'ewa'e di'u, 'inia 'ia God 'a ha'ata'inia do'a arari rai here ha'a-ninimairaau o'asi 'iniai suria adaaua Jisas. ");
INSERT INTO aia_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","'Ado dangi rau ai'a agoheta'i ha'ausuriraaui noni hunga na'i Ruma Maea ana God ma na'i ro'u suri'i moi ruma adaa'i. Rau maaniai Taroha Goro 'inia Jisas, 'iia na Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Rau rago hanehane moe'a ara'a i nei rau hinihinia Jisas. Miraaui Jiu hinihini narau boi baani'i dora nara mamaramara Grik rau taraawa'a 'ubwa tanaraaui Jiu hinihini narau huta na'i Israel. Rau o'ani, “'Ado 'oha mou 'a'auhiraaui nei ra pwapwaku 'iniai mahoingau, ma'ata 'i'amou mou ai'a 'a'auhiraau goroi nao amee'i.” ");
INSERT INTO aia_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Naasi 'iraau ta'i tangahuru mana rua Ha'ataari rau 'unuraau goni mai noni hinihini marau o'ani 'iniraau, “'A ai'a goro domei mamarota'i ha'ausuriraaui noni 'iniai ha'atee ana God, mameigu poru moi 'iniai 'omesuriraaui pohara. ");
INSERT INTO aia_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Naasi arai do'ora, 'a ga'i goro 'onaa moi 'ome sigihia ta biu sae madoma namou ha'ahouraau. Me'iraau mwane 'isi na Hi'ona Maea 'ai rabe ro'u beiraau, mamei nugasia tau'arosi tanaraau. ");
INSERT INTO aia_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","'I'ameu mei matai awa moi 'anai ha'arahesi mana taroha'iniai Taroha Goro 'inia Araha.” ");
INSERT INTO aia_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","'Iraau hako rau 'adoma'i aratara beiraaui Ha'ataari. Rau 'ome sigihia Stivin, 'ia mo'o na hinihinina 'a wetewete di'u ma rabe beiai Hi'ona Maea. Marau 'ome sigihia ro'ua Pilip, mea Prokoras, mea Nikeno, mea Timon, mea Pamenas mea Nikolas. 'Ia Nikolas 'e saeni Antiok ma awa suriai ringeringe adaa'i Jiu. ");
INSERT INTO aia_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Rau ha'a-urasiraau wera biusi na'i maadaaui Ha'ataari, maragu dau'i bwaudaa'i marau ha'arahesi 'adaau. ");
INSERT INTO aia_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mana tarohana Araha 'a 'adarara'a 'ari suri'i mwani 'omaa. Miraaui noni hinihini na'i Jerusalem rau rago hanehane ro'u moe'a ara'a. Ma rago ro'u i Piriisi narau taraawa'a hinihiniai ha'ausuringa'i 'inia Jisas. ");
INSERT INTO aia_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Mia God 'a ha'agorohia Stivin mana mena ana God 'a awa beia. 'Ia Stivin 'a haa'i mwani ha'abu'oahu mana ha'ara rago na'i maadaaui sae. ");
INSERT INTO aia_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma tara'i sae baaniai ruma ni ha'arahesi nara 'unua 'iniai “Ruma ni ha'arahesi adaaui Slev nara Awa Dadara'a,” rau taraawa'a ura bwarasia Stivin. 'Iraaui sae 'isi rau boi baaniai 'omaai Saerin mana Aleksandria, mana'i Provensi Silisia mana Eisia. Rau heita'ia beia Stivin. ");
INSERT INTO aia_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Maragu ai'a gere arari moe'a 'anai heiraeraesi beia, 'inia 'iia 'a madoma di'u mana Hi'ona Maea 'a 'a'auhia. ");
INSERT INTO aia_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Rau 'unuraau girugiru tara'i sae marau bonasiraau dorai pwari'i 'ana o'ani, “Meu rongoa mo'oni na ha'atee ha'ata'aia Moses ma ha'atee ha'ata'aia ro'ua God.” ");
INSERT INTO aia_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Suriai haua adaau o'asi, 'iraau sae rago miraau saemaua adaa'i Jiu miraau Ha'ausuri 'anai Ringe ana'ia Moses, rau taesu'a di'u 'ana Stivin. Rau daua marau waia 'ari na'i rurugoni adaaui Kansol. ");
INSERT INTO aia_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Rau waa'i mai tara'i abe 'anai pwari'i 'ana o'ani, “'Ia mo'oni 'ado 'oha'a na ha'atee ha'ata'aiai Ruma Maea agaau mana ringeringe ana'ia Moses. ");
INSERT INTO aia_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Meu rongoa ro'u na 'unua do'ia Jisas ni Nasaret 'ai kaiai Ruma Maea agaau, mai orisi'i ringeringe agaa'i na haa'ia Moses.” ");
INSERT INTO aia_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Miraau hakoi ruruhai Kansol, rau wana wetewete 'inia Stivin marau re'iai hauraena auru tari na'i 'u'una, 'a 'ome 'onaai enjel. ");
INSERT INTO aia_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mana Na'ohadaaui Piriisi 'a songa'inia Stivin o'ani, “'A 'ua? Maho rau maani'isi, ra ha'a-momori ma'ua ai'a?” ");
INSERT INTO aia_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Mia Stivin 'a o'ani, “Mwani sae agu'i mana mwani sae mwanimaua, moisu rongoai maho wai maaniani. 'Ia wauwa agaaua Ebraham 'a awa mau na'i Mesopotemia na'i madoraa 'ia God, na hauasa, 'a ha'ata'inia haaria tanaa. Na'i muri 'agu sara 'ari 'omaai Haran. ");
INSERT INTO aia_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","'Ia God 'a o'ani, ‘'Oi hano baaniraaui sae amu'i mana dorani, ma'oi 'ari na'i dora nawaigu ha'ata'inia tana'o.’ ");
INSERT INTO aia_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Naasi, 'ia Ebraham 'a hano baaniai Mesopotemia, dora adaaui Kaldia, ma hano ma awa ga'u na'i Haran. Ma na'i murinai mae na haua amana, 'ia God 'agu 'unua tanaa do'ai sara mai na'i dora nagaugu mono na'iei 'ohanisi. ");
INSERT INTO aia_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Na'i madoraasi, 'ia God 'a ai'a haua ta dorai ano tanaa Ebraham, rei'uaa ta gere dora ma ai'a ro'u. Ma'ata 'ia God 'a duruduru tanaa do na'i muri, 'ia Ebraham 'ai to'oraai dorasi. Rei'uaa na 'iia 'a ai'a to'oraa mau ta gare, mia God 'a bwane duruduru tanaa do 'iraaui warowarona'i narai to'oraai dorasi. ");
INSERT INTO aia_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","'Ia God 'a ha'atee o'ani ro'u, ‘'Iraau warowaromu'i rai 'ari marai awa na'i dora narau ai'a to'oraa. Miraau sae na'i dorasi rai ha'i slev 'iniraau. Rai awa ha'ata'airaau suria ta hai 'arangi harisi. ");
INSERT INTO aia_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Minau wai ha'a-mama'aiai kantrisi 'iniai ha'i slev adaau 'iniraaui burungamu. Na'i muri raigu hura'a baaniai kantrisi maraigu boi 'anai ha'arahesiau na'i 'ini.’ ");
INSERT INTO aia_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Hoita, 'ia God 'a 'unua ro'u tanaa Ebraham 'anai aha ha'araraaui gare mwane, 'e ha'ara 'iniai duruduru na haua tanaraaui warowarona'i. Naia na 'ia Ebraham 'a aha ha'araa 'inia Aisak na'i warunai dangi murinai huta ana. Mia Aisak 'a aha ha'araai garena, 'ia Jekop, mia Jekop 'a aha ha'araraau ro'u i ta'i tangahuru mana rua gare ana. 'Iraau naasi ta'i tangahuru mana rua wauwa agaau. ");
INSERT INTO aia_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Miraau gare ana'ia Jekop rau kakawa 'omesiai do'oradaau 'ia Josep marau 'ubwania. Marau raonga'inia tanaraau tara'i sae maraugu waia aurui Ijip 'anai ha'i slev 'inia. Mia God 'a awa beia Josep ");
INSERT INTO aia_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ma taatahi bwarasia suri'i madoraa bwara na siri suri'i. 'Ia God 'a ha'amadomaa Josep mana mwaeraha na'i Ijip 'a 'ome taenia ma ha'abwauodoa 'anai 'omesuriraaui saeni Ijip bei'i toto'ora ana'i. ");
INSERT INTO aia_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ma'e ta'i kaeni hioro raha na to'o 'ari suria hakoi Ijip tari Kenan. 'A bwara hako tanaraaui sae rago. 'Iraau wauwa agaa'i rau ai'a to'o mahoingau ro'u na'i madoraasi. ");
INSERT INTO aia_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mia Jekop 'a rongoa do ra'i mahoingau ra awa na'i Ijip ma ha'a-taariraaui wauwa agaa'i 'ari 'isi. ");
INSERT INTO aia_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na'i ruanai boi adaau mia Josep 'a ha'arangasia'a haaria do'iia naasi do'oradaau ani. Na'i 'ohasi 'ia Mwaeraha adaaui Ijip 'agu 'irararaaui sae ana'ia Josep. ");
INSERT INTO aia_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","'Ia Josep 'a ha'ataariai taroha tanaa amana miraaui sae ana'i ma 'unua dorai auru hako na'i Ijip. 'Iraausi 'a tari biu tangahuru mana rima goni adaau hako. ");
INSERT INTO aia_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Naasi 'ia Jekop 'a auru ma awa na'i Ijip. 'Iia goni beiraaui gare ana'i rau awa marau mae na'i 'isi. ");
INSERT INTO aia_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mana'i 'oha rau mae, na abedaa'i ra wai'i aho'i 'ari na'i Sekem naragu aora'i na'i wabwa na'ia Ebraham 'a horia baaniraaui gare ana'ia Hamo. ");
INSERT INTO aia_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“'Ari wou mana madoraa na 'ia God 'a duruduru 'inia tanaa Ebraham 'anai ruhasiraaui Jiu baania Ijip 'a gaarangi'a. Na'i 'ohasi, 'iraau sae agaa'i na'i Ijip rau kaeni rago hanehane moe'a ara'a. ");
INSERT INTO aia_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ma na'i 'ohasi 'e sae he'ete'i na mwaeraha na'i Ijip. Sae na ai'a 'iraraa Josep. ");
INSERT INTO aia_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","'A ha'a-bweubweu'araaui wauwa agaa'i ma here ha'ata'airaau di'u 'oha na ha'a-'usu'usuraau dorai nuga'i gere gare adaa'i hura'ai abau 'omaa marai mae. ");
INSERT INTO aia_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Na'i madoraasi na huta maia Moses, 'iia 'e gare na 'ome goro di'u. 'E oru hura narau 'omesuria moi na'i ruma. ");
INSERT INTO aia_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Raugu nugaa hura'ai abau 'omaa mana gare urao anai mwaeraha ni Ijip 'a waia'a ma 'omesuria 'onaai huunai gare ana. ");
INSERT INTO aia_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Rau ha'ausuri ha'agorohia 'ini'i maho rau 'irara'i ma here goro di'u suri'i mwani maho na hadanga'ini'i ma haa'i. ");
INSERT INTO aia_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Na'i 'oha na tari hai tangahurui harisi, 'a raba 'ari garihiraaui saeni Israel, 'iraau sae ana'i. ");
INSERT INTO aia_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na'i madoraasi, 'a re'iai saeni Ijip na ngahu ha'ata'aiai saeni Israel ma 'a'auhiai saeni Israel ma ngahu ha'amaesiai saeni Ijip. ");
INSERT INTO aia_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","'Ia Moses 'a 'adoma'inia do 'iraau sae ana'i rai 'ome 'iraraa do 'ia God 'a 'ome sigihia 'anai ruhasiraau maraugu ai'a 'ome 'iraraa moe'a. ");
INSERT INTO aia_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Na'i nata dangi ma re'ia ro'u rua saeni Israel nararu heingahui ma bonasia do rarui abu heingahui. 'A o'ani 'inirarua, ‘'I'amurua ra'i saeni Israel hako moi neimuruasi. Ni 'uaana namurugu heingahui 'inia?’ ");
INSERT INTO aia_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mia mo'o na taraawa'anai heingahuisi 'a burusia beira'i a Moses ma o'ani 'inia, ‘'Iatei na niga'o 'anai saemaua ma'ua 'anai hiiri'amiria? ");
INSERT INTO aia_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","'A 'ua? 'O raba ngahu ha'amaesiau 'onaai saeni Ijip na'o ngahu ha'amaesia nanora ani?’ ");
INSERT INTO aia_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Na'i 'oha 'ia Moses 'agu rongoa o'asi, ma hora'a baaniai Ijip ma 'ari na awa 'onaai mahuara na'i Midia ma ha'iwai na'iei na to'oraai rua gare mwane. ");
INSERT INTO aia_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“'E hai tangahurui harisi na hako mana enjel 'a ha'amaranga tanaa na'i dora mangasara gaarangiai hungahungai Saenai. 'A ha'amaranga na'i urunai gere hasi'ei na noro. ");
INSERT INTO aia_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","'Oha 'ia Moses 'a re'iai 'eusi, 'a heimwaota'i di'u ma 'ari wou gaarangi 'anai wana ha'agorohia. Ma rongoai ringena Araha God na o'ani, ");
INSERT INTO aia_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘'Inau God adaau wauwa amu'i. God ana Ebraham mea Aisak mea Jekop.’ 'Ia Moses 'a 'idi'idi ma mamaa'uta'i wanasiai 'eu. ");
INSERT INTO aia_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Mia God 'a o'ani 'inia, ‘'Oi rehi'i sandol amu'i baaniai uwamu, 'iniai dora na'o awa 'ieisi, 'e dora maea. ");
INSERT INTO aia_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","'Inau re'iai rongomaata'i narau haai noni agu'i na'i Ijip mau rongoai ohooho adaau mau dio mai 'anai ruhasiraau. Naasi wai ha'ataari'o aho'i 'ari Ijip.’” ");
INSERT INTO aia_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mia Stivin 'a o'ani ro'u, “'Ia God 'a ha'ataariai enjel ana 'anai hadahada beia Moses baaniai gere hasi'ei na norosi. Ma 'unua tanaa do'ia God 'ai ha'ataaria 'anai ruhasiraau ma 'anai marungiraaui inoni ana'i. 'Iia mau a Moses narau 'itaa ani naanisi nararu 'unua do 'iatei na nigaa 'anai saemaua ma'ua 'anai hiirirarua. ");
INSERT INTO aia_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mia Moses 'a aho'i 'ari ma na'otaradaaui sae ana'i hura'a baaniai Ijip ma haa'i mwani ha'abu'oahu mana ha'ara rago na'i Ijip ma na'i asi meramera'a ma na'i 'omaa mangasara suriai hai tangahurui harisi. ");
INSERT INTO aia_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“'Ia Moses na 'unua tanaraaui Israel do'ia God 'ai 'ome sigihia ta Rarabea 'onaaia baani'i warowarodaa'i. ");
INSERT INTO aia_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ma na'i 'oha 'iraau wauwa agaa'i rau awa na'i 'omaa mangasara na'i hungahungai Saenai, 'ia Moses 'a awa beiraau me 'iia naasi i enjel na ha'atee tanaa ma haa'i tanaai ha'atee ni tahi nagu haa'i mai tanagia. ");
INSERT INTO aia_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Me 'iraau wauwa agaa'i rau ai'a raba araisuria Moses. Rau 'itaa moi marau raba aho'i 'ari Ijip. ");
INSERT INTO aia_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Na'i 'oha 'ia Moses 'a awa mau ta'eha na'i hungahunga, rau 'unua tanaa Eron do'ai tagora'i tadaa'i god 'anai na'otaradaau. 'Inia raugu ai'a 'iraraa'ai taha na to'o beia Moses na wairaau hura'a baaniai Ijip. ");
INSERT INTO aia_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Na'i madoraasi narau araaranununai garei kau marau suu ho'asi tanaa. Marau hauai kae ngaugoni wa'ewa'e 'iniai god adaau narau tagorahia. ");
INSERT INTO aia_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Mia God 'a rihota'i beira'i baaniraau ma ha'awateraau rai ha'arahesi'i hee'u mana hura mana sina 'onaai ha'arangasia ana na'i Usu-usu Maea adaaui Rarabea na o'ani, ‘'I'amou saeni Israel, na'i raronai hai tangahurui harisi namou awa na'i 'omaa mangasara, mou ai'a suu ho'asi tanaau. ");
INSERT INTO aia_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","'Ado 'oha mougu suru'ia moi ruma saira ana god Molek mana araaranununai god hee'u 'ia Refan. 'I'amou namou tagoradi araaranunu 'isi 'anai ha'arahesi'i. Ma naasi 'inau wai ha'awatea dorai wai'amou ha'atau 'ari di'uai Babilon 'anai ha'a-rongomaata'i'amou.’ ");
INSERT INTO aia_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Na'i madoraa 'iraau wauwa agaa'i rau awa na'i 'omaa mangasara rau waa ro'u i ruma saira na awa ieia God. Naia mau i rumu saira na'ia God 'a 'unua tanaa Moses 'anai tagoraa, mia Moses 'a tagorahia ma suria goro i nunu na'ia God na ha'ata'inia tanaa. ");
INSERT INTO aia_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Na'i muri 'oha nagu na'otara Josua, 'iraau wauwa agaa'i rau saguai dorai ano na'ia God 'a tariha'iniraaui sae he'ete'i baania. Ma na'i 'oha narau siri wou na'i dorasi, rau waia mau i ruma sairasi na wauwa adaa'i rau haua mai tanaraau. Na ruma sairasi rau ha'arahesia moe'a mau a God na'iei tari madoraa ana Mwaeraha Deved. ");
INSERT INTO aia_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“'Ia God 'a 'ome taenia Deved. Mia Deved 'a ha'angonia God do 'ai watea tanaa maai tagoraa ta Ruma Maea tanaraaui saeni Israel. ");
INSERT INTO aia_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mia God 'a ai'a ha'awatea. 'Ia Solomon nagu tagorahiai Ruma Maea ana God na'i 'oha 'iia nagu mwaeraha. ");
INSERT INTO aia_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ma'ata, 'ia God na ororiu ara'ai aro, 'a ai'a matai awa suri'i ruma ra tagorahi'i sae. 'Onaai Rarabea na 'unua o'ani, ");
INSERT INTO aia_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘'Ia Araha God 'a ha'atee o'ani, “I aro naasi dora heheinagu agua 'anai heimarungi mana ano naasi dora ni buubuu agua. Naasi 'e ruma taha namoi tagorahia naigu marasigu? 'A bwara tana'amou 'anai tagorahia ta dora nawai mamaro iei. ");
INSERT INTO aia_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","'Inia 'inau nau ha'apwa'ara'i mwani mareho hako.”’” ");
INSERT INTO aia_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Mia Stivin 'a o'ani ro'u, “Romwane! 'I'amou mou rongoasa di'u. 'Adoma'imoo'i ra 'onaairaaui ahurodo mamou ai'a raba araisuri'i ha'atee ana'ia God. Mou hairaesi tarau beiai Hi'ona Maea 'onaairaau wauwa amoo'i na'i 'oha bwani. ");
INSERT INTO aia_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Gaarangi 'iraau hakoi Rarabea na'i 'oha bwani, 'iraau wauwa amoo'i rau norata'airaau. Rau ngahu ha'amaesi'i sae ana'ia God narau taroha'iniai boi nai haua mo'o na odo-odo hako na'i maana God. 'Iia naasi Ha'atahi namou ha'awatea tanaraaui maeronga, mamou ngahu ha'amaesia. ");
INSERT INTO aia_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","'Onaai 'iraraa amoou, 'iraaui enjel rau waa'i mai ringeringe agaa'i Jiu tanaa Moses nagu haa'i ro'u tana'amousi. Ma rei'uaa na o'asi, 'i'amou mou ai'a araisuri'i.” ");
INSERT INTO aia_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na'i 'oha 'iraaui saemaua adaa'i Jiu rau rongoai ha'atee o'asi ana Stivin, rau 'ara ha'a-ngadingadi'i rihodaa'i 'inia na ahudaa'i 'a honu 'iniai taesu'a. ");
INSERT INTO aia_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mia Stivin na Hi'ona Maea 'a rabe beia. 'A wana ara'ai aro ma re'iai rarahana God, ma re'ia Jisas na ura na'i aba odona God. ");
INSERT INTO aia_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Mia Stivin 'a o'ani, “'Au re'iai aro 'a heihoa mana Garei Inoni 'a ura na'i aba odona God.” ");
INSERT INTO aia_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Miraau saemaua rau awaawara marau here ponopono'i karingadaa'i marau 'eba wou 'anai daua. ");
INSERT INTO aia_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Rau ogea hura'a na'i murinai 'omaa mara taraawa'ai buta ha'amaesia na'iei. 'Iraau mwane narau ha'ahunia ania Stivin, rau rahi'i to'oni bohura'a adaa'i marau haa'i tanaai geresae ra 'unua 'inia Sol maraugu buta'ia ro'ua Stivin. ");
INSERT INTO aia_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na'i 'oha rau buta'ia Stivin, 'a ha'atee o'ani, “Araha Jisas, 'oi waia woui aungagu bei'o.” ");
INSERT INTO aia_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ma topira'i ruru dioi ano ma awara o'ani, “Araha, 'oi abu su'ua tanaraaui ora-ora'a rau hauani,” maagu mae. ");
INSERT INTO aia_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","'Ia Sol 'a 'adoma'inia do 'a goro moi ngahuia ada Stivin. Taraawa'a na'i madoraa na 'ia Stivin 'a mae, ra taraawa'a norata'airaaui sae ni heisoi na'i Jerusalem. Miraau hako rau hora 'ari suri'i tara'i dora na'i Jiudea ma na'i Samaria. 'Iraau moi Ha'ataari naraugu awa na'i Jerusalem. ");
INSERT INTO aia_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tara'i sae narau 'adoma'i ha'ahihi'aa God rau waai abena Stivin marau toringia. Rau angisia marau ahutotou di'u 'inia. ");
INSERT INTO aia_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mia Sol 'a bonasia do'ai ha'a-ai'aai heisoi. 'A siri suri ruma ma daa'i sae mwane mana urao ni heisoi ma nuga'i na'i rumaniho'o. ");
INSERT INTO aia_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","'Iraau sae hinihini narau hora baaniai Jerusalem rau 'adara'inia 'ari tarohana Araha suri'i mwani 'omaa narau taha suri'i. ");
INSERT INTO aia_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","'Ia Pilip 'a 'ari ro'u na'i 'omaa raha i Samaria, ma taroha'inia ro'u ieia mo'o na Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","'Iraau sae rau raba bahurongoa di'u na'i 'oha rau rongo'i maho na maani'i marau re'i'i ha'abu'oahu na haa'i. ");
INSERT INTO aia_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","'Iraau nei na bwauniraau adaro, 'iraau adaro rau awaawara marau hura'a. 'Iraau nei ra pwaki mana nei ra ngadi abedi ra goro aho'i ro'u. ");
INSERT INTO aia_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","'Iraau sae rau awa na'i kae 'omaasi rau wa'ewa'e di'u. ");
INSERT INTO aia_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na'i 'omaasi, 'e ta'i sae na awa iei, atana 'ia Saemon. 'Ia mo'osi 'a matai haa'i ha'abu'oahu 'iniai mena anai adaro miraau saeni Samaria rau heimwaota'i di'u 'ini'i. 'Ia mo'osi 'a 'unua ro'u haaria do'iia 'e saemaua. ");
INSERT INTO aia_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","'Iraau hakoi sae na'i 'omaasi goni beiraaui saemaua rau bahurongo'i maho na 'unu'i a mo'osi, marau 'unua do'iia 'a to'oraai mena. I menasi rau 'unua 'iniai ta'i kaeni mena ana God. ");
INSERT INTO aia_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Rau suria 'inia 'a orea mai haa'i ana'i mwani maho rau heimwaota'i 'ini'i. ");
INSERT INTO aia_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Na'i 'oha 'ia Pilip 'a maaniai Taroha Goro 'inia Jisas Kraest mana tahinga 'ia God na marungia, 'iraau sae mwane mana urao rau hinihinia marau 'ari wou ma bwareomaea'araau. ");
INSERT INTO aia_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mia Saemon ro'u 'a hinihini ma 'ari ro'u wou na bwareomaea. 'Ado 'oha 'a awa beia Pilip ma heimwaota'i di'u 'ini'i ha'abu'oahu mana ha'ara na haa'i. ");
INSERT INTO aia_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","'Iraau Ha'ataari na'i Jerusalem rau rongoa do 'iraau Samaria rau hinihinia'ai tarohana Araha. Naasi marau ha'ataaria Pita mea Jon 'anai garihiraau. ");
INSERT INTO aia_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Na'i 'oha raru taha beiraau nei ra hinihini, raru ha'arahesi 'adaau neina Hi'ona Maea 'ai sirihiraau. ");
INSERT INTO aia_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Rei'uaa narau bwane bwareomaea 'iniai atana Araha Jisas, mana Hi'ona Maea 'a ai'a awa mau beia tanei 'iniraau. ");
INSERT INTO aia_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Naasi 'ia Pita mea Jon raru dau'i bwaudaa'i mana Hi'ona Maea 'a sirihiraau'a. ");
INSERT INTO aia_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na'i 'oha 'ia Saemon 'a re'ia dona Hi'ona Maea 'a sirihiraaui sae na'i 'oha 'ia Pita mia Jon raru dau'i bwaudaa'i, 'agu ha ma waia'a mai ha'a tanararua ma o'ani, ");
INSERT INTO aia_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Murui haua ro'u tanaaui mena, neina 'iatei sae nawai dau na'i bwauna, na Hi'ona Maea 'ai sirihia ro'u.” ");
INSERT INTO aia_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mia Pita 'a ha'atee wetewete tanaa o'ani, “I'oe 'adoma'inia do'o ga'i matai horia moi maho na watea dadara'a God tanaraaui sae? 'A goro do'o ga'i mae na'i dora ni rongomaata'i bei'i ha'a amu'isi. ");
INSERT INTO aia_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","I'oe 'o bwa'i aba 'iniai ruruha ameeu na'i tau'aroni, suria na 'adoma'imu 'a ai'a odo-odo na'i maana God. ");
INSERT INTO aia_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","'Oi rihosi ma'oi nugasi'i herehere amu'i nara ai'a goro, ma'oi ha'arahesi tanaa God maai 'adoma'i nugasiai 'ado'adomu na ta'aa. ");
INSERT INTO aia_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","'Inau 'iraraa 'o ta'i kaeni naga di'u 'iniai to'oraai menasi, me ni ora-ora'a 'a marungi'o.” ");
INSERT INTO aia_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mia Saemon 'a 'unua tanaa Pita mea Jon do rarui ha'arahesi 'a'auhia mana maho raru 'unu'i rai abu to'ia. ");
INSERT INTO aia_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na'i 'oha 'ia Pita mea Jon raru taroha'inia hakoi tarohana Araha mararu maani'i taha nararu re'i'i na haa'i, naasi ma rarugu aho'i 'ari Jerusalem. Na'i 'oha nararu hano 'anai 'ari Jerusalem, raru taroha'inia mau ro'u i Taroha Goro suri'i tara'i 'omaa na'i Samaria. ");
INSERT INTO aia_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","'E ta'i 'oha, i enjel ana God 'a ha'atee tanaa Pilip o'ani, “'Oi hura'a suriai tara na tahamora na'i Jerusalem ma dio na'i dora mangasara ma 'ari 'anai Gasa.” ");
INSERT INTO aia_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Mia Pilip 'a hura'a suria ma re'iai saeni Itiopia. 'Ia mo'osi 'e sae mwanemaua na 'omesuri'i ha'a anai urao mwaeraha na'i Itiopia. 'Iia 'a 'ari Jerusalem 'anai ha'arahesi ");
INSERT INTO aia_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ma aho'i 'ari 'omaa ana. 'A heinagu na'i bwea na'e hoosi na ogea, magu 'oha'iniai buka anai rarabea Aisaea. ");
INSERT INTO aia_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mana Hi'ona Maea 'a o'ani 'inia Pilip, “'Oi 'ari wou beia mo'osi ma'oi hahano na'i bobona.” ");
INSERT INTO aia_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Na'i 'oha nagu 'eba wou gaarangia ma rongoai 'oha'inia anai Usu-usu Maea ana Aisaea, mia Pilip 'a o'ani 'inia, “'A 'ua? 'O aidangisiai maho na'o 'oha'iniasi?” ");
INSERT INTO aia_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mia mo'osi 'a o'ani 'inia Pilip, “'Ai he'ua nawai aidangisia 'inia 'onaa na ai'a ta sae nai ha'a-aidangisiau 'inia?” Ma 'unua tanaa Pilip do'ai hane ta'eha maai heinagu beia na'i bwea. ");
INSERT INTO aia_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Maho na 'oha'inia mo'osi na'i Usu-usu Maea 'a o'ani, “Ra waia 'onaai siip nara waa 'anai ngahuia. Ma 'onaaiai garei siip na ai'a angi na'i 'oha ra taapuruai warihuna, 'iia 'a agohe moi. ");
INSERT INTO aia_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ra ha'atee ha'ata'aia ma na'i 'oha ra hiiria ra ai'a haua beiai here na odo-odo. 'Abwa'i ta sae nai hadanga'ini'i gare ana'i, 'inia na tahingana ra ha'a-ai'aa moi baania 'oha 'iia 'a ai'a to'o gare mau.” ");
INSERT INTO aia_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mana saemauasi 'a songa'inia Pilip o'ani, “'Iatei na 'ia Aisaea na hadanga'iniasi? 'A hadanga'inia haaria ma'uasi 'e sae he'ete'i?” ");
INSERT INTO aia_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mia Pilip 'a taraawa'a maania tanaai Taroha Goro 'inia Jisas. 'A maania ga'u tanaa i gere dora baaniai buka ana Aisaea, magu maani'i tanaa ro'u tara'i dora he'ete'i ro'u. ");
INSERT INTO aia_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Rarugu ha mararu taha'a na'i wai mana saesi 'a o'ani'a 'inia Pilip, “Wai naani'a, 'e taha na ha'abwarasiau nau bwa'i matai bwareomaea 'inia?” ");
INSERT INTO aia_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Mia Pilip 'a aramia o'ani, “'Onaa na'o hinihini beiai tahingamu hako, ma'oi bwareomaea.” Mana saemauasi 'a o'ani, “'Au hinihini do'ia Jisas Kraest naasi Garena God.” ");
INSERT INTO aia_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mana saemauasi 'a 'unua dorai ha'apapakuai maho raru ta'e na'ieisi, mararu dio na'i wai mea Pilip 'agu bwareomaeaai saesi. ");
INSERT INTO aia_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Na'i 'oha raru tarau baaniai wai, na Hi'ona Maea ana God 'a waia Pilip mana saemauasi 'agu ai'a re'ia'a. 'Agu haa ma hano'a ro'u ma wa'ewa'e raha di'u. ");
INSERT INTO aia_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","'Agu 'asu'a Pilip ma ada na'i 'omaai Asotas. 'A maaniai Taroha Goro na'i 'omaasi ma ro'u suri'i mwani 'omaa na taha suri'i tari 'oha na ada na'i 'omaai Sisaria. ");
INSERT INTO aia_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mana'i 'ohasi, 'ia Sol 'a 'unua wetewete moe'a mau 'anai ngahu ha'amaesiraaui nei narau suria Araha. 'A 'ari beiai Na'ohadaaui Piriisi ");
INSERT INTO aia_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ma ha'angonia do'ai usu'i tara'i usu-usu tanaraaui bwauodo suri'i ruma ni ha'arahesi adaa'i Jiu na'i 'omaai Damaskas. 'A haua o'asi marai aidangisia do'ia Sol ra haua tanaa i mena 'anai dauraaui urao mana sae mwane nara hinihinia Jisas 'anai wairaau 'ari na'i Jerusalem. ");
INSERT INTO aia_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mia Sol 'a 'ari Damaskas ma na'i 'oha na gaarangia wou i 'omaa, 'e raraha na boi baaniai aro na raangia. ");
INSERT INTO aia_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ma ahoda aurui ano ma rongoai ha'atee na o'ani, “Sol, Sol, 'iniai 'uaana na'o norata'aiau 'inia?” ");
INSERT INTO aia_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mia Sol 'a o'ani, “Saemaua, i'oe atei?” Mia o'ani, “'Inaua Jisas na'o norata'aiausi. ");
INSERT INTO aia_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ma'ata, 'oi ura ara'a ma'oi 'ari 'omaa 'ariani. 'E sae na'iei naigui 'unua tana'o i maho na'oi haua.” ");
INSERT INTO aia_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","'Iraau hakoi mwane rau hano beia Sol, 'a bu'o i ahudaau marau ai'a 'unua ta mareho. Rau rongoa moi ha'atee marau ai'a re'ia ta sae. ");
INSERT INTO aia_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Mia Sol 'a ura ara'a ma ragata'iniai maana ma ai'a 'omesia'a ta maho. Rau dau na'i rimana marau urua 'ari Damaskas. ");
INSERT INTO aia_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","'E oru dangi na ai'a 'ome'ome ma ai'a ngau mana gono. ");
INSERT INTO aia_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na'i Damaskas 'e ta'i sae hinihini na awa na'iei na atana 'ia Ananaeas. Ma na'i 'omesia na haua Araha 'a 'onaai maho na mauru'aa. 'Ia Araha 'a o'ani, “Ananaeas!” Mia Ananaeas 'a o'ani 'inia, “'Inau neinauni Araha.” ");
INSERT INTO aia_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mia Araha 'agu o'ani, “'Oi 'ari suriai tara nara 'unua 'iniai Tara Odo-odo ma'oi taha na'i ruma ana Jiudas ma'oi songa'i 'iniai saeni Tasas na atana 'ia Sol. 'Iia 'a ha'arahesi na'i madoraanisi. ");
INSERT INTO aia_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mia Sol 'a 'onaa do 'a mauru'aai maho. 'A re'iai saena 'ome 'onaaiai sae ra 'unua 'inia Ananaeas na boi ma nugaai rimana hungana do'ai 'ome'ome aho'i.” ");
INSERT INTO aia_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mia Ananaeas 'a o'ani 'inia, “Araha, 'inau bwane rongo'i mwani mamaani 'inia mo'osi 'iniai here ha'ata'airaau 'anai sae amu'i na'i Jerusalem. ");
INSERT INTO aia_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma na'i 'ohani 'iraaui Na'ohadaa'i Piriisi rau ha'awatea 'anai daa'i sae ra hinihini'o.” ");
INSERT INTO aia_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mia Araha 'a o'ani, “'Oi 'ari! 'Inau nau 'ome sigihia 'anai hauai tau'aro agua, 'anai taroha'iniau tanaraaui sae nara ai'a Jiu miraaui mwaeraha mei tanaraau ro'u i Jiu. ");
INSERT INTO aia_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mawai ha'a-aidangisia 'iniai rongomaata'i nai to'o tanaa na'i 'oha nai taroha'iniai atagu.” ");
INSERT INTO aia_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mia Ananaeas 'a 'ari ma siri wou na'i ruma ma nugaai rimana hungana Sol ma o'ani, “Do'oragu Sol, 'ia Araha Jisas na ha'ataariau mai. 'Iia na ha'ata'i tana'o ani na'i tara. 'A ha'ataariau do'oi wanawana aho'i mana Hi'ona Maea 'ai sirihi'o.” ");
INSERT INTO aia_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Na'i mau 'ohasi, ra'i maho nara 'ome 'onaai una-unai ii'a ra ahoda baaniai maana maagu wanawana aho'i. Ma ura ara'a mara bwareomaeaa. ");
INSERT INTO aia_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Na'i muri 'agu ngau mana abena 'a wetewete aho'i. 'A ga'i 'onaai rua ma'ua oru dangi na'ia Sol 'a awa na'i Damaskas beiraaui sae hinihini. ");
INSERT INTO aia_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ma siri odo-odo suri'i ruma ni ha'arahesi adaa'i Jiu na heitaroha'i tanaraaui sae do'ia Jisas naasi huunai Garena God. ");
INSERT INTO aia_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","'Iraau nei rau bahurongoa rau heimwaota'i di'u marau o'ani, “'Ia mo'oni gasi na norata'airaaui nei rau hinihinia Jisas na'i Jerusalem? Magu boi 'ini 'anai dauraaui sae hinihini 'anai wairaau tanaraaui Na'ohadaaui Piriisi! 'Agu he'ua naani?” ");
INSERT INTO aia_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Hadahada ana'ia Sol 'inia Jisas ra wetewete di'u ro'u wou. Ma rei'uaa narau bwarai hinihini, 'iraaui Jiu na'i Damaskas ra bwarai tohea 'inia ta maho, 'inia Sol 'a ha'ata'inia goro tanaraau do 'ia Jisas naasi huunai Ha'atahi. ");
INSERT INTO aia_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","'A rago'ai dangi ra hako miraau saemaua adaa'i Jiu raugu rurugoni 'anai siba herehere narai matai ha'amaesia 'inia Sol. ");
INSERT INTO aia_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","'Ado rodo mana dangi rau matoo 'ana suri'i maadi bara na'i barahau anai 'omaasi. Mia Sol 'a rongoai ha'aradorado adaau ");
INSERT INTO aia_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ma na'i ta'i rodo 'iraaui rongoiusuri ana'i rau ha'ahura'ahia na'i riwa na'i abenai barahau na'i 'omaasi. Rau toto'oa dio hura'ai abau 'omaa na'i kae abira. ");
INSERT INTO aia_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Na'i 'oha na ada aho'i a Sol na'i Jerusalem, 'a bonasia do 'iraau sae hinihini na'i 'isi rai aidangisia do'iia 'e ta'i'a ro'u beiraau, maraugu ai'a hinihinia marau mamaa'usia. ");
INSERT INTO aia_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mia Banabas, 'e ta'i 'iniraaui noni hinihini, 'a waia 'aria Sol beiraaui Ha'ataari ma maania tanaraaui re'ia na haua Araha na'i tara. Mia Banabas 'a maania ro'u i taha na 'unua Araha tanaa Sol mana ramoramo na haua Sol 'anai taroha'inia Jisas na'i Damaskas. ");
INSERT INTO aia_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Naasi maraugu hinihinia, mia Sol 'agu awa tarau beiraau. 'A 'ari suri'i mwani dora na'i Jerusalem. 'Iiasi 'a ramoramo 'anai taroha'inia Araha. ");
INSERT INTO aia_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma heiraeraesi beiraaui Jiu narau matai maramara Grik, marau bonasia dorai sadoia ta herehere narai ha'amaesia 'inia Sol. ");
INSERT INTO aia_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na'i 'oha 'iraaui noni hinihini rau rongo sadoiai ha'aradorado narau hauasi, rau waia'a Sol dio na'i Sisaria naraugu ha'ataaria 'ari Tasas. ");
INSERT INTO aia_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na'i 'ohasi, na mwani mareho ragu papaku mara goro tanaraaui sae hinihini na'i Provens na'i Jiudea mei Galili ma na'i Samaria mara ragoi nei nara hinihinia Jisas. Rau ha'ahoua Araha mana Hi'ona Maea 'a ha'a-'o'ori'i 'adoma'idaa'i. ");
INSERT INTO aia_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na'i 'oha 'ia Pita 'a 'aariha suri'i 'omaa, 'a ada beiraaui sae ni heisoi na'i Lida. ");
INSERT INTO aia_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ma na'i 'omaasi 'a sadoia iei sae na nugu i abena. Suriai waru harisi 'a taraa dadao moi na'i be'a. Na atanai saesi, 'ia Aenias. ");
INSERT INTO aia_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Mia Pita 'a o'ani 'inia Aenias, “'Ia Jisas Kraest 'ai ha'agorohi'o aho'i. 'Oi ura ara'a mo'oi ha'a-arataraai be'amu!” Mia Aenias 'agu haa ma ura ara'a. ");
INSERT INTO aia_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Miraau saeni Lida mei Saron rau taraawa'a hinihinia Araha na'i 'oha rau re'iai taha na to'o tanaa Aenias. ");
INSERT INTO aia_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ma na'i Jopa 'e ta'i urao hinihini na awa na'iei na atana 'ia Tabita, atani Grik ana 'ia Dokas. Ni uraosi 'a haa'i mwane herehere goro ma 'a'auhiraau tarau ro'u i pohara. ");
INSERT INTO aia_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Na'i 'ohasi, 'a daoha raha ma mae'a. Mara taguma'iniai abena mara nugaa na'i ta'i ahii na'i ruanai bwea anai rumasi. ");
INSERT INTO aia_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","I 'omaai Jopa 'a gaarangia moi Lida. 'Oha 'iraaui sae hinihini rau rongoa do'ia Pita 'a awa na'i Lida, rau ha'ataariai rua sae 'anai bonga'inia do'ai raurau mai. ");
INSERT INTO aia_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mia Pita 'a 'ari beirarua na'i Jopa. Na'i 'oha rau ada wou na'i 'omaa, rau waia ta'eha na'i ahii na awa iei urao maesi. 'A ragoi nao rau ura garia Pita marau ago-ago marau ha'ata'ini'i tanaai bwana na tai'i a Tabita na'i 'oha na tahi mau. ");
INSERT INTO aia_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mia Pita 'a ha'a-hura'ahiraau baaniai ahii. Magu topira'i ruru ma ha'arahesi. Ma rihota'i wou tanaai urao maesi ma 'unuai atana, “Tabita, 'oi ura ta'e!” 'Agu haa ma ragata'iniai maana ma re'ia Pita ma heinagu ara'a. ");
INSERT INTO aia_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Mia Pita 'a dau na'i rimana ma ha'a-urasia maagu 'unuraau aho'i siri mai nao miraau ro'u i sae hinihini. 'Ia Pita 'a ha'ata'inia tanaraaua Tabita na tahi aho'i baaniai mae. ");
INSERT INTO aia_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Taroha 'iniai maho na to'osi 'a 'adarara 'ari suriai 'omaai Jopa ma ragoi nei raugu hinihinia ro'ua Araha. ");
INSERT INTO aia_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","'Ia Pita 'a gere awa orea na'i ruma ana Saemon na'i 'omaasi. 'Iiasi 'e sae na matai tatau'arodi mareho 'ini uri-uri mwamwaa. ");
INSERT INTO aia_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na'i Sisaria 'e ta'i saeni Rom na atana 'ia Konilias, 'iiani 'e na'ohadaaui ruruha hehei'oi ni Itali. ");
INSERT INTO aia_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","'Ia Konilias mana urao ana beiraaui gare adaru'i rau 'adoma'i ha'ahihi'aa marau ha'arahesia God. Ma hisungiraau tarau i Jiu pohara ma ha'arahesia tarau a God. ");
INSERT INTO aia_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ta'i 'oha na gaarangia mai angi oru na'i abaidangi, 'a re'iai maho na 'onaa do 'a mauru'aa moi. 'A re'iai enjel ana God na araiai atana. 'A o'ani, “Konilias!” ");
INSERT INTO aia_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Mia Konilias 'a mamaa'u raha ma wana wetewete 'inia ma o'ani, “'E taha saemaua?” Mana enjel 'a o'ani, “'Ia God 'a rongo'i ha'arahesi amu'i ma re'iai 'a'auhiraau amuai pohara ma wa'ewa'e 'inia. ");
INSERT INTO aia_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","'Oi ha'ataari'i 'ari tara'i sae na'i Jopa marai 'unua mai sae na atana 'ia Saemon Pita. ");
INSERT INTO aia_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","'Iia 'a awa beiai sae nara 'unua ro'u 'inia Saemon na ruma ana 'a awa na'i bobonai asi. Saesi 'a tatau'arodi mareho 'ini uri-uri mwamwaa.” ");
INSERT INTO aia_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na'i 'oha nagu ha'atee hako o'asi moi enjel ma ai'aa'a. Naasi mia Konilias 'a 'unua mai rua sae tatau'aro ana beiai ta'i sae hehei'oi. Ni sae hehei'oisi, 'a tau'aro 'a'auhia Konilias mana saesi 'a 'adoma'i ha'ahihi'aa ro'ua God. ");
INSERT INTO aia_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","'Ia Konilias 'agu 'unua hako moi tanaraaui maho na to'osi ma ha'a-taariraau'a 'ari Jopa. ");
INSERT INTO aia_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na'i nata dangi na'i atoaa, 'iraau wera orusi rau gaarangi ada'a wou na'i Jopa. Na'i madoraasi, 'ia Pita 'a ta'ehai hunganai ruma 'anai ha'arahesi. Hunganai rumasi 'a sada moi. ");
INSERT INTO aia_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","'Ohasi 'ia Pita 'a hioro ma raba ngau. Ma'ata na mahoingau ana ra tau'arodi moe'a na'i 'ohasi, mia re'iai maho na ha'amaranga tanaa. ");
INSERT INTO aia_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","'A 'omesiai aro na heihoa ma re'iai maho na 'ome 'onaai kae bwana bwabwanahora. Ma na'i hai di'una hairiu bwanasi, ra toto'oa dio baaniai aro ma dio tari na'i ano. ");
INSERT INTO aia_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na'i hunganai bwanasi, 'a re'i'i mwani taraani mwamwaa he'ete'i, ra'i mwaa mana popo'usuri mana mwani manu hehe'ete'i. ");
INSERT INTO aia_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ma rongoai ha'atee na o'ani, “Ura ara'a Pita, 'oi ngahui'i ma'oi ngaa'i.” ");
INSERT INTO aia_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mia Pita 'a o'ani, “Araha, 'a bwa'i. Ai'a ta 'oha mau wai ngaa ta mareho na ai'a arari 'anai ngaua.” ");
INSERT INTO aia_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ma rongoa ro'u i ha'atee na o'ani, “Ni maho 'ia God 'a 'unua dora arari 'anai ngaua, 'ogu bwa'i 'unua'a ro'u do ra ai'a arari.” ");
INSERT INTO aia_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","'A rongoa ha'a-oru i ha'ateesi mana bwana kakasi na re'iasi 'agu ara'a aho'i aro. ");
INSERT INTO aia_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","'Ia Pita 'a wai'ado'ado suriai maho na ha'ata'i tanaasi, taha huunai 'ado'ado 'ana. Ma na'i 'ohasi, i waira oru na ha'a-taariraausi a Konilias raugu sadoiai ruma ana Saemon marau ura na'i maanai bara anai ruma. ");
INSERT INTO aia_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Marau awara siri, rau songa'iniraaui sae na'i rumasi 'inia Saemon Pita, 'onaa 'a awa 'isi ma'ua ai'a. ");
INSERT INTO aia_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","'Ia Pita 'a wai'ado'ado mau suriai taha naasi 'ana 'ado'ado i maho na re'iasi, mana Hi'ona Maea 'a o'ani'a 'inia Saemon, “'E wera oru rau sibani'o. ");
INSERT INTO aia_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","'Oi dio raurau ma'oi abu 'adoma'i heiruarua'a 'anai hano beiraau, suria 'inau nau ha'a-taariraau mai.” ");
INSERT INTO aia_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Mia Pita 'a dio wou ma o'ani 'iniraau, “'Inau naasi namou sibaniausi. 'E taha namou rabasia?” ");
INSERT INTO aia_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Miraau wera orusi rau o'ani, “'E na'ohadaaui hehei'oi ra 'unua 'inia Konilias na ha'ataari'ameu. 'Ia mo'osi 'e sae odo-odo ma ha'arahesia God miraau Jiu rau ha'ahoua di'u ro'u. 'E enjel ana God na 'unua tanaa do'ai 'unu'o 'ari na'i ruma ana maai rongo'i maho no'oi maani'i.” ");
INSERT INTO aia_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mia Pita 'a 'unuraau siri na'i ruma ma dorai mauru ga'u na'i rodosi. Na'i nata dangi, 'iia ma tara'i sae hinihini ro'u ni Jopa rau ta'i hano beiraau waira orusi. ");
INSERT INTO aia_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mana'i nata dangi'a ro'u, naraugu ataha na'i Sisaria. 'Ia Konilias 'a 'unuraau hako mai na'i ruma ana 'iraaui nei narau heito'oranga'i, beiraaui gere sae goro ana'i narau totoria Pita. ");
INSERT INTO aia_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","'Oha na ataha Pita, 'ia Konilias 'a 'ari wou ma topira'i ruru tanaa 'anai ha'a-ororiua. ");
INSERT INTO aia_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mia Pita 'a ha'aurata'ea ara'a ma o'ani, “'Inau 'e sae ro'u moi 'onaai'osi.” ");
INSERT INTO aia_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mararu mamaani hahano siri na'i ruma. Mia Pita 'a re'i'i mwani sae rau goni mai na'i rumasi ");
INSERT INTO aia_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ma o'ani 'iniraau, “'I'amou bwani 'iraraa do'a horosiai ringeringe amee'i Jiu do mei garihiraaui nei ra ai'a Jiu ma'uasi haguhagu beiraau. Ma'ata 'ia God 'a ha'ata'inia tanaau do 'a odo-odo 'anai haguhagu beiraaui mwani sae hako. ");
INSERT INTO aia_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tarana naasi, na'i 'oha 'o ha'ataari'i wou sae 'anai 'unuau mai, 'au ai'a kakawa, 'au boi moi. Hoita, mau raba songa'ini'o. Ni 'uaana na'o rabasia 'inia dowai boi?” ");
INSERT INTO aia_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Mia Konilias 'a o'ani, “Naani hainai dangi murinai 'oha nau ha'arahesi na'i ruma agua na'i angi oru 'onaai 'ohanisi. 'Augu 'asu'a mana sae na ho'osiai bwana na wadowado di'u 'a ura'a na'i maagu. ");
INSERT INTO aia_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ma o'ani, ‘Konilias, 'ia God 'a rongo'i ha'arahesi amu'i ma re'iai 'a'auhiraau amuai pohara. ");
INSERT INTO aia_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","'Oi ha'ataaria 'ari tara'i sae na'i Jopa marai 'unua mai sae ra 'unua 'inia Saemon Pita. 'Iia 'a awa beiai sae nara 'unua ro'u 'inia Saemon na ruma ana 'a awa na'i bobonai asi. Saesi 'a tatau'arodi mareho 'ini uri-uri mwamwaa.’ ");
INSERT INTO aia_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ma naasi naugu ha'ataari'i raurau wou 'ini'i sae 'ani ma goro di'u na'o boi. Na'i 'ohanisi, 'i'ameu sae nameu goni 'ini na'i maana God, meu ha'aagau 'anai rongo'i taha 'ia Araha na 'unu'i tana'o do'oi maani'i tana'ameu.” ");
INSERT INTO aia_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","'Ia Pita 'a o'ani, “Naasi 'augu aidangisia do mwani sae hako ra ta'isada moi na'i maana God. ");
INSERT INTO aia_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","'Iatei nai ha'ahoua maai haa'i maho ra odo-odo, 'ia God 'ai wa'ewa'e 'inia, rei'uaa dora he'ua na'i marewana na boi baania. ");
INSERT INTO aia_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mou bwane 'iraraai taroha goro na 'unua tanaraau Israel do gau matai hagu goro beia God 'iniai hinihinia agaaua Jisas Kraest, i Araha aga hako. ");
INSERT INTO aia_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","'Au 'iraraa domou aidangisiai taha na to'o na'i Jiudea. 'A taraawa'a na'i Galili murinai 'unua ana Jon tanaraaui sae dorai bwareomaea. ");
INSERT INTO aia_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ni mareho na to'osi, 'a o'ani: 'Ia God 'a hauai Hi'ona Maea mana mena tanaa Jisas ni Nasaret. 'Ia God 'a awa beia mia Jisas 'a 'ari suri'i mwani dora 'anai haa'i tau'aro goro mana ha'agorohiraau aho'i nei ra awa na'i bahainai mena ana Saetan. ");
INSERT INTO aia_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“'I'ameu Ha'ataari meu re'iai taha na haua na'i Israel ma na'i 'omaai Jerusalem. Ra ha'amaesia na'i hunganai dadaahoro. ");
INSERT INTO aia_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ma'ata 'e rua dangi mana'i oruna 'ia God 'a ha'a-suruta'ea aho'i ma ha'a-'omesiraaui sae 'inia. ");
INSERT INTO aia_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ma ai'a 'iraau hakoi sae rau re'ia, 'i'ameu moi nei na 'ome sigihi'ameu a God, nameu ngau mameu gono beia na'i murinai suruta'e aho'i ana. ");
INSERT INTO aia_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","'Ia God 'a 'unua wetewete tana'ameu domei maania tanaraaui noni do'ia Jisas naasi nei na 'ome sigihia 'anai hiiriraaui nei ra tahi mau mana nei ra mae. ");
INSERT INTO aia_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Miraau rarabea rau bwani ha'arangasia do 'iatei nai hinihinia Jisas rai 'adoma'i nugasi'i ora-ora'a ana'i.” ");
INSERT INTO aia_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","'Ia Pita 'a mamaani mau mana Hi'ona Maea 'a sirihiraau'ai sae rau bahurongoa. ");
INSERT INTO aia_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Miraau ai Jiu hinihini narau ta'i boia Pita, rau heimwaota'i di'u 'iniraaui sae ra ai'a Jiu, i daua adaau ro'u i Hi'ona Maea. ");
INSERT INTO aia_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Rau rongoraau, rau haa'i ha'atee hehe'ete'i hairiu marau 'unu ha'aasaa God. Mia Pita 'a o'ani, ");
INSERT INTO aia_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“'Iraau sae 'ini, 'ia God 'a haua'a tanaraaui Hi'ona Maea 'onaai haua ana tanagaau. 'A bwa'i sae naigu ha'aabua dorai abu bwareomaearaau.” ");
INSERT INTO aia_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mia Pita 'a 'unua tanaraau dorai bwareomaea 'iniai hinihinia adaaua Jisas Kraest. Miraau ha'angonia Pita do'ai awa ro'u ga'u beiraau suria ta taringai dangi. ");
INSERT INTO aia_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","'Iraau Ha'ataari mana sae hinihini na'i Jiudea rau rongoa do tara'i sae ra ai'a Jiu rau hinihinia'ai tarohana Araha. ");
INSERT INTO aia_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Na'i 'oha na ataha Pita na'i Jerusalem, 'iraau tara'i Jiu hinihini narau 'adoma'i ororiu 'iniai aha ha'ara rau 'unu'unu ha'ata'aia. ");
INSERT INTO aia_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Marau o'ani, “I'oe 'o awa beiraaui nei narau ai'a aha ha'ara ma'o ngau ro'u beiraau!” ");
INSERT INTO aia_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mia Pita 'a maania goro tanaraaui maho na to'o. 'A o'ani, ");
INSERT INTO aia_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“'Inau awa na'i Jopa, ma na'i madoraa nau ha'arahesi, 'e mareho na ha'amaranga tanaau. 'Au 'omesiai aro na heihoa mau re'iai maho na 'ome 'onaai kae bwana bwabwanahora. Ma na'i hai di'una hairiu bwanasi, ra toto'oa dio baaniai aro ma tari dio na'i bobogu. ");
INSERT INTO aia_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","'Au wanawana mau 'omesi'i mwani mwamwaa, nei wasi mana mwaa mana popo'usuri mana manu na'i hungana. ");
INSERT INTO aia_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mau rongoai ha'atee na o'ani, ‘Ura ara'a Pita, mo'oi ngahui'i ma'oi ngaa'i.’ ");
INSERT INTO aia_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Minau o'ani, ‘Araha, 'au bwa'i matai haua o'asi. Ai'a ta 'oha mau wai ngaa ta mareho na ai'a arari 'anai ngaa.’ ");
INSERT INTO aia_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Mana ha'atee na boi baaniai aro 'a o'ani ro'u, ‘Ni maho 'ia God 'a 'unua dora arari 'anai ngaa, 'ogu bwa'i 'unua'a ro'u do ra ai'a arari.’ ");
INSERT INTO aia_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“'Au rongoa ha'a-oru i ha'ateesi maragu ara'a aho'i aroi maho 'isi. ");
INSERT INTO aia_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","'Augu 'asu'a ma'e oru saeni Sisaria rau ataha na'i ruma nau awa na'ieisi. ");
INSERT INTO aia_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mana Hi'ona Maea 'a 'unua dowai abu 'adoma'i heiruarua'a, wai hano beiraau. 'Iraau waira ono do'oragu'i beia Kraest 'ini, nameu ta'i 'ari ruma ana Konilias. ");
INSERT INTO aia_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mia Konilias 'a maania tana'ameu do'e enjel na ha'ata'i tanaa na'i ruma ana. Mana enjel 'a o'ani 'inia, ‘'Oi ha'ataaria 'ari tara'i sae na'i Jopa marai 'unua mai sae ra 'unua 'inia Saemon Pita, ");
INSERT INTO aia_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","maai maania tana'o miraaui sae na'i ruma amua i herehere moi tahi 'inia.’ ");
INSERT INTO aia_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Hoita, 'augu taraawa'a hadahada moi, mana Hi'ona Maea 'a sirihiraau'a 'onaai here na to'o tanagaau na'i na'o ani. ");
INSERT INTO aia_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mau 'adoma'i aho'isiai ha'atee na haua Araha o'ani, ‘'Ia Jon 'a bwareomaearaaui inoni 'iniai wai mi'amou rai bwareomaea'amou 'iniai Hi'ona Maea.’ ");
INSERT INTO aia_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na'i 'ohasi naugu aidangisia do 'ia God 'a banea ro'u tanaraaui nei ra ai'a Jiu i ta'i bane na haua tanagaau na'i 'oha gau hinihinia Araha aga Jisas Kraest. Naasi, 'inau 'au bwa'i ura bwarasiai hei'irisina God tanaraau.” ");
INSERT INTO aia_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Na'i 'oha 'iraau Jiu 'isi rau rongoai mamaani na haua Pita rau haa marau agoheta'i heiraeraesi'a beia, marau taraawa'a 'unu ha'aasaa God. Rau o'ani, “'Ohani, 'ia God 'a ha'awatea do 'iraaui nei ra ai'a Jiu rai rihosi marai dauai tahi tarau.” ");
INSERT INTO aia_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Murinai ngahuia ada Stivin ani, ra taraawa'a norata'airaau di'u i sae hinihini na'i Jerusalem. Me ni 'adarara rau haa i sae hinihini na'i madoraasi, 'a taha na'i Ponisia ma na'i maraui Saepras ma na'i 'omaa rahai Antiok. Rau taroha'iniai Taroha Goro, ma'ata rau heitaroha'i moi tanaraaui Jiu. ");
INSERT INTO aia_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ma'ata tara'i sae hinihini ni Saepras mei Saerin naraugu 'ari 'omaai Antiok marau taroha'iniai Taroha Goro 'inia Araha Jisas tanaraaui sae ra ai'a Jiu. ");
INSERT INTO aia_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na mena ana God 'a awa beiraau, mara rago i sae narau hinihini marau rihota'i tanaa Araha. ");
INSERT INTO aia_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na'i 'oha na taroha 'iniai mahosi 'a tari beiraaui saeni heisoi na'i Jerusalem, rau ha'ataaria Banabas 'ari Antiok. ");
INSERT INTO aia_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Na'i 'oha na ada wou 'a re'ia do'ia God 'a goro di'u 'iniraau ma wa'ewa'e raha 'inia. Ma ha'ata'u'uraau dorai ura baabau na'i tahingadaa'i beia Araha. ");
INSERT INTO aia_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","'Ia Banabas 'e sae goro na hinihinina 'a wetewete di'u, mana Hi'ona Maea 'a rabe beia. Na tarana naasi, 'a rago ro'u i nei rau hinihinia Araha na'i madoraasi. ");
INSERT INTO aia_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","'Ia Banabas 'a 'ari sibania Sol na'i Tasas ");
INSERT INTO aia_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ma waia mai na'i Antiok mararu awa beiraaui sae hinihini na'isi. Suriai ta'i harisi bubu raru awa 'isi ma ragoi nei nararu ha'ausuriraau. Antiok naasi 'omaa tahamora narau 'unuraaui sae hinihini 'ini'i “Kristin.” ");
INSERT INTO aia_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na'i madoraasi tara'i rarabea rau boi na'i Antiok baaniai Jerusalem. ");
INSERT INTO aia_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","'E ta'i 'iniraau naasia Agabas. 'Iniai mena anai Hi'ona Maea 'a 'unua hura'a do'e hioro raha nai to'o suria 'ari hakoi marewana. (Ni hioro rahasi 'a to'o na'i madoraa na heimarungi a Klodias.) ");
INSERT INTO aia_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Miraaui sae hinihini na'i Antiok rau 'adoma'inia dorai haua ta gere hei'a'auhi tanaraaui nei hinihini na'i Jiudea. 'E nei ma hisu 'iniai ha'a tari dora na matai hisu tari na'iei. ");
INSERT INTO aia_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Naasi 'ia Banabas mia Sol nararugu waiai wawate adaau tanaraaui bwauodonai heisoi na'i Jerusalem. ");
INSERT INTO aia_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na'i madoraasi, i Mwaeraha Herod 'a daa'i tara'i sae ni heisoi 'anai ha'a-rongomaata'iraau. ");
INSERT INTO aia_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","'Ia Herod 'a 'unua tanaraaui hehei'oi dorai ha'amaesia Jems, do'orana Jon, 'iniai naihi. ");
INSERT INTO aia_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","4","Na'i 'oha 'ia Herod 'a re'ia do 'iraau sae mwanemaua adaa'i Jiu rau wa'ewa'e 'iniai maho na hauasi, ma daua ro'ua Pita ma nugaa na'i rumaniho'o. ('A haua na'i 'oha 'iraau Jiu ra ha'ato'oai rongo ni Roho Aharau.) 'E hai ruruhai hehei'oi narau 'omesuria Pita. 'E hai sae hehei'oi ta'i ruruha. 'Ia Herod 'a 'adoma'inia do 'aigui hiiria Pita na'i maadaaui noni hunga na'i murinai rongo ni Roho Aharau. ");
INSERT INTO aia_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Na'i 'oha na awa Pita na'i rumaniho'o, na heisoi 'a ha'arahesi 'a'auhia wetewete. ");
INSERT INTO aia_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","'E ta'i dangi moe'a namau mia Pita 'ai siri'a na'i hihiiri. Na'i rodo 'a mauru mana rua hehei'oi raru 'omesuria, raru 'ado bobo 'inia. Raru 'ado arihau nararu tosi'i suri'i rimadaru'i ma rarugu tosi'i beia Pita. Ma tara'i hehei'oi ro'u rau 'omesuriai maraaruma anai rumaniho'o. ");
INSERT INTO aia_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mana enjel ana Araha 'a boi mana rarahana 'a marewa hako 'ari suriai ahiisi. 'A tatakiriai 'aba'abana Pita ma ha'araia, 'a o'ani, “Urata'e! Raurau!” Mana arihau ra tosi'i beia ra ahoda baaniai rimana'i ");
INSERT INTO aia_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","mana enjel 'a o'ani, “'Oi siri na'i to'oni amua ma'oi nuga'i sandol amu'i na'i uwamu.” Mia Pita 'a haua 'onaai 'unua anai enjel mana enjel 'a o'ani ro'u, “'Oi siri ro'u na'i to'oni bohura'a amua mo'oi boi suriau.” ");
INSERT INTO aia_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ma suria mana maho na to'osi 'a 'onaa moi do'a mauru'aa. 'A ai'a 'iraraa 'onaa 'a to'o ha'a-momori ma'ua ai'a. ");
INSERT INTO aia_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Raru di'ua hura'ai rua dora nara matai ura-ura iei sae hehei'oi mararu ataha na'i honohono 'aean na'i maanai bara anai rumaniho'osi. Na'i 'oha nararu ataha wou, na honohono 'a wawaa haaria mararu hura'a'a wou i abau 'omaa. Raru 'ari suri tara mana enjel 'agu ai'aa baania Pita. ");
INSERT INTO aia_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mia Pita 'agu aidangisiai maho na to'o ma o'ani, “Naani 'augu 'iraraa, 'ia God 'a ha'ataariai enjel ana 'anai ruhasiau baania Herod mei baani'i maho 'iraaui na'otara adaa'i Jiu rau bonasia haa'i tanaau.” ");
INSERT INTO aia_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","'A wai'ado'ado wou ma 'ari ruma ana Meri, inana Jon Mak. Ma ragoi nei hinihini rau awa na'i rumasi, rau ha'arahesi. ");
INSERT INTO aia_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mia Pita 'a boi ma pwepwee na'i honohono anai bara nara bara garia 'iniai rumasi. Mana urao na tagora na'i rumasi, 'a hura'a wou 'anai tahangiai honohono. Atanai uraosi 'ia Roda. ");
INSERT INTO aia_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","'Oha na rongoai ringena Pita, 'a wa'ewa'e di'u ma kaku'aai tahangiai maraaruma. Ma 'eba aho'i siri ruma ma o'ani, “'Ia Pita na ura hura'asi!” ");
INSERT INTO aia_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Miraau hako rau o'ani, “I'oe 'o bweu gasi!” Mia 'unua moe'a do'ia Pita. Miraau 'unua do ni enjel na 'omesuria gasia Pita na pwepweesi. ");
INSERT INTO aia_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mia Pita 'a pwepwee moe'a tari 'oha narau tahangia tanaa i maraaruma. Ma na'i 'oha narau re'ia, rau heimwaota'i di'u. ");
INSERT INTO aia_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Mia Pita 'a haai ha'ara 'iniai rimana 'anai ha'a-papakuraau ma maania tanaraaui here na haua Araha tanaa ma ha'ahura'ahia baaniai rumaniho'o. Ma 'unua tanaraau dorai maania tanaa Jems mei tanaraau hakoi sae hinihini 'abaiai maho na to'osi. Miagu hura'a ma 'ari dora he'ete'i. ");
INSERT INTO aia_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na'i haho'oa, 'iraaui sae hehei'oi na'i rumaniho'o, 'a ta'aabedaau ma kakui ahudaau 'iniai maho na to'o tanaa Pita. ");
INSERT INTO aia_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","'Ia Herod 'a 'unua tanaraaui sae hehei'oi ana'i dorai sibania Pita maraugu ai'a sadoia. Ma songa'iniraaui sae hehei'oi rau 'omesuria Pita magu 'unua dorai ha'amaesiraau. Mia Herod 'a hano baania Jiudea ma 'ari na awa ga'u na'i Sisaria. ");
INSERT INTO aia_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","'Ia Herod 'a taesu'a di'u 'adaau saeni Taea mei Saedon. 'Iraau sae 'isi, mahoingau adaa'i ra boi baaniai dora na heimarungi ieia Herod. Naasi rau ha'ataariai ruruhai sae 'ari beia Herod 'anai ha'a-arataraai heihoa na awa na'i ahoaadaau neina rai matai to'oraa mahoingau aho'i. Ma na'i na'o, rau ataha beia Blastas, 'e saemaua na tatau'aro tanaa Herod. Rau mamaani beia ma 'adoma'i aratara 'anai 'a'auhiraau. ");
INSERT INTO aia_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Marau duruai dangi beia Blastas 'anai hauai ha'a-aratara beia Herod. Ma na'i dangisi, 'ia Herod 'a siri suri'i to'oni hauasa ana'i ma heinagu na'i dora ni mwaeraha ana magu hadahada. ");
INSERT INTO aia_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Miraaui sae rau awara o'ani, “I'oe 'o ai'a hadahada 'onaai inoni, 'o rongo hauasa 'onaai hi'ona.” ");
INSERT INTO aia_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mana enjel ana God 'a ha'adaohaa Herod suria 'a wa'ewa'e 'iniai ha'a-ta'eta'e ada magu ai'a rabasia dorai ha'aasaa God. 'Ari wou mana mwamwaa ni ahu ra ha'amaesia. ");
INSERT INTO aia_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Na tarohana Araha 'a 'adarara 'ari suriai mwani dora ma ragoi nei nara aho'ita'i sae hinihini. ");
INSERT INTO aia_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Hoita, 'ia Banabas mia Sol raru haua hakoi wawate tanaraaui sae hinihini na'i Jerusalem, mararu aho'i 'ari Antiok. Raru waia Jon Mak beirarua. ");
INSERT INTO aia_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","I heisoi na'i Antiok, ra'i rarabea mana ha'ausuri ra awa na'iei. 'Ia Banabas mia Simion nara 'unua ro'u 'inia mo'o na abeburu, mia Lusias baaniai Saerin, mia Sol mia Manaen. 'Ia Manaen 'a raha ara'a goni beia Herod Antipas na'i ruma adaau. ");
INSERT INTO aia_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hoita, 'e ta'i 'oha na'i madoraa rau ha'arahesi marau ha'aririta'i ngau, i Hi'ona Maea 'a 'unua tanaraau dorai 'ome sigihia Banabas mea Sol 'anai hauai tau'aro na 'unurarua 'ana. ");
INSERT INTO aia_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","'Oha na ha'arahesi mana ha'ariri 'a hako, marau dau na'i bwaudaru'i a Banabas mia Sol marau ha'a-taarirarua hura'a 'anai hauai tau'aro adarua. ");
INSERT INTO aia_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ma naasi na Hi'ona Maea 'a ha'a-taarirarua Banabas mea Sol mararu 'ari Selusia. Na'i 'isi nararugu ta'e iei 'anai maraui Saepras. ");
INSERT INTO aia_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Na'i 'oha raru taha na'i 'omaai Salamis raru taraawa'a taroha'iniai tarohana Araha suri'i ruma ni ha'arahesi adaa'i Jiu. 'Ia Jon Mak 'a hano ro'u beirarua 'anai 'a'auhirarua. ");
INSERT INTO aia_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Rau 'ari tari na'i 'omaa rahai Pefos na'i nata ngongoo 'iniai marau. Na'isi rau heisadoi beia ta'i ai Jiu na atana 'ia Bajisas. 'Iiasi 'e rarabea pwapwaari'i na matai haa'i ha'abu'oahu 'iniai mena anai adaro. ");
INSERT INTO aia_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","'A hagu goro beia Sejias Polas, 'iiani 'e sae aidangi na Primia 'anai marausi. Na Primia 'a raba rongoai tarohana Araha ma 'unua Banabas mia Sol. ");
INSERT INTO aia_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mia Bajisas, nata ata ro'u 'ia Elimas, 'a ura bwarasia Banabas mia Sol, 'a ai'a rabasia Sejias Polas do'ai hinihinia Jisas. ");
INSERT INTO aia_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mia Sol, 'iiasi ra 'unua ro'u 'inia Pol, i Hi'ona Maea 'a rabe beia. 'A wanasia Elimas ");
INSERT INTO aia_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ma o'ani 'inia, “I'oe 'e gare ana Saetan! 'O pwari'iraau taraui noni 'anai ha'a-bweubweu'araau, mi'oe 'e maeronga 'ada'i mwani maho goro. 'Oha he'ua na'oigui agoheta'i hiosi'i ha'ausuringa'i odo-odo ana'ia Araha? ");
INSERT INTO aia_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Na'i 'ohani, 'ia God 'ai ha'a-mama'ai'o! Naasi, ta madoraa 'o bwa'i wanawana. Rei'uaa marewahanai sina, ma 'o bwa'i re'ia ro'u.” 'Agu 'asu'a Elimas mana maana ra gahu'a mara kuhi ma to'o karokaro 'inia ta sae do'ai urua. ");
INSERT INTO aia_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Na'i 'oha 'ia Sajias Polas 'a re'iai maho na to'osi 'a hinihinia'a Araha, 'inia 'a heimwaota'i di'u 'iniai ha'ausuringa'i 'inia Araha. ");
INSERT INTO aia_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","'Ia Pol miraaui nei rau hano beia, rau hano baaniai Pefos marau ta'e na'i haka 'ari Provens nara 'unua 'iniai Pamfilia marau siri na'i 'omaai Paga. Na'isi nagu aho'i eia Jon Mak baania Pol mea Banabas 'ari Jerusalem. ");
INSERT INTO aia_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Rau hano baaniai Paga marau hatare 'anai Antiok. Antiok 'e 'omaa na'i Provensi Pisidia. Ma na'i dangi ni mamaro rau siri heinagu na'i ruma ni ha'arahesi adaaui Jiu. ");
INSERT INTO aia_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Na'i murinai 'oha'inia ada i Ringeringe ana'ia Moses mana Usu-usu Maea adaa'i rarabea, 'iraaui na'otara 'anai ruma ni ha'arahesi rau ha'ataari ha'atee 'ari tanaa Pol mea Banabas. Rau o'ani, “Rua do'ora, 'onaa muru raba maania ta maho 'anai 'a'auhiraaui sae, ma murui mamaani'a.” ");
INSERT INTO aia_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mia Pol 'a hauai ha'ara 'iniai rimana do'a raba 'unua ta maho ma o'ani, “'Igaau saeni Israel mi'amou sae he'ete'i namou ha'arahesia God, moi rongobahuau. ");
INSERT INTO aia_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","I God agaaui Israel 'a 'ome sigihiraaui wauwa agaa'i ma ha'awateraau dorai tabara na'i Ijip. 'Iniai mena ana na wetewete 'a wairaau hura'a baaniai dorasi. ");
INSERT INTO aia_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Rei'uaa narau hau'i here nara ta'a'i di'u, me 'iia 'a oosi suriraau moi na'i 'omaa mangasara suriai hai tangahurui harisi. ");
INSERT INTO aia_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ma here ha'ata'aiai biu burungai noni na awa na'i Kenan ma ha'a-to'oraraaui wauwa agaa'i 'iniai dorasi. ");
INSERT INTO aia_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Taraawa'a mau na'i 'oha rau ataha i wauwa agaa'i na'i Ijip, tari na'i 'oha na gare adaa'i raugu awa goro na'i Kenan 'a 'onaai hai 'arangi mana rima tangahurui harisi. “Na'i muri, 'a nuga'i sae hihiiri 'anai marungiraau tari mai madoraa ana Rarabea Samiuel. ");
INSERT INTO aia_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Miraau rabasia ta mwaeraha. Mia God 'a ha'amwaerahaa Sol, garena Kis. 'Ia Sol baaniai burungana Benjamin, ma heimarungi suriai hai tangahurui harisi. ");
INSERT INTO aia_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mia God 'a nugaa dioa Sol ma orisia 'inia Deved. 'A o'ani, ‘'Ia Deved, garena Jesi, naasia mo'o na suriai barongagu. 'Iia nai haa'i mwani mareho nau 'irisi'i.’ ");
INSERT INTO aia_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Ma durua do ta sae baaniai burungana Deved 'ai huta, ma'ai ruhasiraaui saeni Israel. Mana saesi naasi 'ia Jisas. ");
INSERT INTO aia_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Na'i na'o maagu boia Jisas, 'ia Jon 'a 'unua tanaraau hakoi saeni Israel dorai rihosi baani'i ora-ora'a adaa'i marai bwareomaea. ");
INSERT INTO aia_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","'A gaarangi ha'ahakoa'ai tagora ana maagu songa'iniraau o'ani, ‘'I'amou 'adoma'inia do'inau naasi Ha'atahi? Ai'a! 'Iia 'ai boi mau na'i muri. 'Inau ai'a arari 'anai dunasi'i sandol ana'i.’” ");
INSERT INTO aia_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Mia Pol 'a 'unua o'ani ro'u, “Arai do'ora, na'i 'ohani moi bahurongo goro, 'i'amou warowarona'i a Ebraham mi'amou ro'u i nei namou ai'a Jiu namou ha'arahesia God. 'Igaau hako na haua God 'i taroha tanagaau do'ai ruhasigaau baaniai ora-ora'a. ");
INSERT INTO aia_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","'Iraaui saeni Jerusalem miraaui bwauodo adaa'i rau ai'a 'ome 'iraraa do'ia Jisas naasi Ha'atahi aga. Marau ai'a aidangisi'i Usu-usu Maea adaa'i Rarabea nara 'oha'ini'i 'ado dangi ni mamaro. Ma rei'uaa na o'asi, rau hiiri ha'amaesia 'onaai bwane ha'arangasia adaaui Rarabea. ");
INSERT INTO aia_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ma rei'uaa rau ai'a sadoia ta maho ta'aa nai haua nai arari 'inia 'anai mae, maraugu buna ha'angonia Paelat do'ai ha'amaesia. ");
INSERT INTO aia_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Na'i 'oha nara ha'ato'o'i tanaa hako i mwani mareho na Usu-usu Maea na 'unua 'inia, ra rahia dioi abena baaniai dadaahoro mara aoraa na'i wabwa. ");
INSERT INTO aia_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mia God 'a ha'a-suruta'ea aho'i baaniai mae. ");
INSERT INTO aia_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","'A ragoi 'oha na ha'ata'i tanaraaui nei narau bwane ta'i hano ani baaniai Galili 'anai 'ari Jerusalem 'oha na tahi mau. Ma na'i 'ohani rau taroha'inia tanaraaui sae agaa'i. ");
INSERT INTO aia_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Miria Banabas miri boi 'ohani 'anai maaniai Taroha Goronisi tana'amou. Ni maho na 'ia God na bwane durua tanaraaui wauwa agaa'i 'anai haua, 'a haua na'i madoraa agaau 'oha na ha'atahia aho'i ania Jisas. 'A 'onaai 'unua ana na'i ruanai Psalm o'ani, ‘I'oe gare agua. Dangini wai ha'ata'inia tanaraaui noni do 'inau naasi amamu.’ ");
INSERT INTO aia_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","'Ia God 'a ha'a-suruta'ea Jisas baaniai mae 'inia 'a ai'a rabasia do'ai mae'a ro'u ta 'oha. 'A 'onaai 'unua anai Usu-usu Maea na o'ani, ‘Wai haua tana'amoui ha'agorohi maea nau durua tanaa Deved.’ ");
INSERT INTO aia_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ma na'i nata Psalm 'ia Deved 'a 'unua ro'u o'ani, ‘'Ia God 'a bwa'i wateai abenai noni maea ana nai ngabo.’ ");
INSERT INTO aia_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Na'i Psalm naasi, 'ia Deved 'a ai'a hadanga'inia haaria. 'Oha na tahi maua Deved, 'a araisuria goro i hei'irisina God. Ma na'i 'oha na mae, ra toringia na'i hera adaaui burungana mana abena 'a ngabo. ");
INSERT INTO aia_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ma'ata, 'ia mo'o na mae mia God 'a ha'a-suruta'ea aho'i, 'a ai'a ngabo i abena. ");
INSERT INTO aia_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Sae agu'i, 'inau rabasia domoi aidangisia do'ia Jisas 'a matai 'adoma'i nugasi'i 'inomoo'i. Rei'uaa namoi suri'i mwani Ringe ana'ia Moses, 'ia God 'a bwa'i matai 'unua domou odo-odo na'i maana. Ma'ata 'iatei nai hinihinia Jisas, 'ia God 'ai 'unua do 'a odo-odo'a na'i maana. ");
INSERT INTO aia_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Naasi moi 'ome'ome goro, 'a gasi to'i'amou i maho rau 'unua i rarabea o'ani, ");
INSERT INTO aia_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘'I'amou nei mou haikou 'inia God, 'ai bu'oi ahumoo'i mamoi mae! 'Inia na'i madoraa amoou, 'inau wai hauai maho namou bwa'i hinihinia, rei'uaa rai maania tana'amou.’” ");
INSERT INTO aia_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Hoita, 'ia Pol mea Banabas raru taraawa'ai hura'a baaniai ruma ni ha'arahesi miraaui sae rau ha'angonirarua 'anai aho'i mai ro'u na'i nata dangi ni mamaro 'anai maani'i tara'i maho ro'u. ");
INSERT INTO aia_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Na'i murinai rihunga'i, rau ragoi ai Jiu mana nei ra ai'a Jiu narau boi 'anai ha'arahesi rau surisuria Pol mea Banabas. Mararu ha'atee ha'ata'u'uraau hako dorai ura baabau na'i hinihinidaau beia God 'inia 'iia 'a goro 'iniraau. ");
INSERT INTO aia_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na'i nata dangi ni mamaro, gaarangi 'iraau hakoi sae na'i 'omaasi rau boi 'anai rongoai tarohana Araha. ");
INSERT INTO aia_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Na'i 'oha 'iraau bwauodo adaa'i Jiu raugu re'ia o'asi, rau taesu'a di'u 'iniai rago anai sae nara boboi beirarua. Rau hadahada ha'ata'aia Pol marau 'unu'unu'i maho na maani'isi. ");
INSERT INTO aia_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mia Pol mea Banabas raru ai'a mamaa'usiraau, raru o'ani, “'Ia God 'a 'irisia do miri taroha'iniai tarohana Araha tana'amoui Jiu na'i na'o. Mi'amou mou 'itaa. Naasi ha'ata'i ana do 'i'amou mou ai'a 'adoma'inia domou arari 'anai dauai tahi tarau. 'Imiria mirii 'ari'a beiraaui nei rau ai'a Jiu. ");
INSERT INTO aia_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","'Inia 'ia Araha na 'unua tana'amiria. 'A o'ani, ‘'Au nuga'o 'onaai raita na marewasiraaui nei ra ai'a Jiu, ma'oi ha'ata'iniai tara 'anai tahi tarau tanaraau hako i sae suriai marewana hako.’” ");
INSERT INTO aia_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Na'i 'oha 'iraaui sae ra ai'a Jiu rau rongoai tarohasi, rau wa'ewa'e di'u 'inia, marau ha'atee ha'agorohiai tarohana Araha. Miraaui nei na 'ome sigihiraaua God 'anai dauai tahi tarau, rau nugaai hinihinidaau beia. ");
INSERT INTO aia_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ni tarohana Araha 'a 'adarara 'ari suria hakoi mwani dora na'i 'isi. ");
INSERT INTO aia_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Miraaui bwauodo adaa'i Jiu rau 'ari beiraau tara'i saemaua mana urao mwanemaua na'i 'omaasi narau 'adoma'i ha'ahihi'aa God. Rau mamaani ha'a-taesu'araau ma do neina rai ura bwarasia Pol mea Banabas. 'Agu haa marau taraawa'ai haa'i here ta'a'i tanararua. Marau tariha'inirarua hura'a baaniai Antiok. ");
INSERT INTO aia_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","'Ia Pol mea Banabas raru tarohi'i moi kahua baani'i uwadaru'i, 'anai ha'ata'inia tanaraau doni here narau hauasi, 'a taritari'a. Ma rarugu 'ari 'anai 'omaai Aekoniam. ");
INSERT INTO aia_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","'Iraaui sae ni heisoi na'i Antiok rau wa'ewa'e di'u mana Hi'ona Maea 'a rabe beiraau. ");
INSERT INTO aia_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","'Ia Pol mea Banabas raru siri ruma ni ha'arahesi adaaui Jiu na'i Aekoniam mararu heitaroha'i na'iei 'onaai bwane haua adarua ga'u na'i Antiok. Mana hadahada nararu haua, raru mataihere mamaani di'u. Ma ragoi Jiu miraaui nei nara ai'a Jiu narau aho'ita'i sae hinihini. ");
INSERT INTO aia_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Miraaui Jiu narau kakawata'i hinihinia Jisas, rau 'ari beiraaui nei ra ai'a Jiu nara ai'a hinihini ro'u, marau mamaani ha'a-taesu'araau, ma dorai 'itaraaui sae hinihini. ");
INSERT INTO aia_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","'Ia Pol mea Banabas raru awa orea ga'u na'i 'isi. Raru ramoramo 'anai taroha'iniai Taroha Goro tanaraaui sae 'i goro ana God tanagia. 'Ia Araha God 'a hauai mena tanararua 'anai haa'i mwani ha'abu'oahu ma 'anai ha'ata'inia doni ha'atee adaru'i ra ha'a-momori. ");
INSERT INTO aia_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Miraaui noni hunga rau heihoa marau hauai rua ruruha. 'E ta'i ruruha rau aba beiraaui saemaua adaa'i Jiu mana nata ruruha rau aba beia Pol mea Banabas. ");
INSERT INTO aia_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ma tara'i Jiu mana nei ra ai'a Jiu beiraaui na'otara adaa'i, rau hauai ha'aradorado 'anai ngahuia Pol mea Banabas dorai buta'irarua 'ini'i hau. ");
INSERT INTO aia_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Na'i 'oha raru rongo sadoiai ha'aradorado rau hauasi, mararu hora'a 'ari na'i Provensi Likeonia. Rarugu taroha'iniai Taroha Goro na'i Listra ma na'i Debe mei suri'i 'omaa garigariai rua 'omaasi. ");
INSERT INTO aia_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na'i Listra 'e sae na awa na'iei na huta ha'i pwaki ma ai'a hahano. ");
INSERT INTO aia_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","'A rongobahua Pol 'oha na maaniai Taroha Goro. Mia Pol 'a wanasia mo'osi ma 'ome 'iraraa do 'a hinihiniai heitaroha'i na haasi, ma ga'i matai goro aho'i moi. ");
INSERT INTO aia_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Mia Pol 'a awara tanaa, 'a o'ani, “'Oi ura ara'a!” Mia mo'osi 'a kae suruta'e raha moi ara'a ma taraawa'ai hahano hairiu. ");
INSERT INTO aia_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","'Oha 'iraaui noni hunga rau re'iai maho na haua Pol, rau awara 'iniai ha'ateeni Likeonia o'ani, “I rua hi'ona agaau, raru aho'ita'i sae mararu dio mai'a beigaau!” ");
INSERT INTO aia_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Rau 'unua Banabas 'iniai Sus, 'e hi'ona adaaui Grik, mia Pol 'ia Hamis, suria 'iia naasi sae 'anai 'unu'i hura'ai maho. ");
INSERT INTO aia_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na ruma ni suu ho'asi tanaa Sus 'a awa moi na'i gaarangiai 'omaasi. Mana Piriisi 'anai rumasi mana noni hunga rau raba suu ho'asi tanaa Banabas mea Pol. Naasi rau waa'i mai kau nara ha'arauni'i 'ini'i tagai hasi'ei marau ataha na'i maanai bara 'anai 'omaa. ");
INSERT INTO aia_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Na'i 'oha raru rongoai mareho rau raba haua, raru kari'i to'oni adaru'i 'anai ha'ata'inia do raru ai'a 'adoma'i aratara 'iniai marehosi. Mararu 'eba wou huniraaui noni hunga mararu awara o'ani, ");
INSERT INTO aia_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Romwane, ni 'uaana mou haua o'asi 'inia? 'Imiria ra'i sae ro'u moi 'onaaimousi! Miri boi 'anai waa mai Taroha Goro tana'amou. Moi abui ha'arahesi'i hi'ona nara bwa'i 'a'auhi'amou, ma'ata moi rihota'i tanaai God tahitahi na ha'apwa'araai ahoaa mana ano mana asi mana mwani maho na'i rarodi. ");
INSERT INTO aia_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Taraawa'a mau mai, 'ia God 'a nugasiraaui noni dorai suri'i hinihinidaa'i haariraau. ");
INSERT INTO aia_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ma'ata rei'uaa na o'asi, 'iia 'a ha'ata'inia ro'u mau haaria tana'amou suri'i maho goro na haa'i. 'A ha'adiohiai rangi baaniai aro 'anai ha'atahi'i maho mou hasi'i, ma haa'i mahoingau tana'amou mamou wa'ewa'e 'ini'i.” ");
INSERT INTO aia_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Rei'uaa na'ia Pol mea Banabas raru 'unu'i maho 'isi, ma rarugu buna wetewete mau ro'u 'anai bonasia dorai abu suu ho'asi tanararua. ");
INSERT INTO aia_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ma tara'i na'otara adaa'i Jiu na'i Antiok ma na'i Aekoniam rau boi marau mamaani ha'a-taesu'araaui noni hunga 'anai ura bwarasia Pol. Naasi marau buta'ia Pol 'ini'i hau marau oge tatarasia hura'a baaniai 'omaasi. Rau 'adoma'inia do'a mae'a. ");
INSERT INTO aia_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Na'i 'oha 'iraau sae hinihini rau boi ura garigaria Pol, mia 'a urata'e ma siri aho'i na'i 'omaa. Ma na'i nata dangi, 'ia Pol mea Banabas raru 'ari Debe. ");
INSERT INTO aia_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","'Ia Pol mea Banabas raru taroha'iniai Taroha Goro na'i Debe ma ragoi nei ra siri ro'u na'i heisoi. Mararu aho'i 'ari Listra mei Aekoniam mei Antiok na'i Provensi Pisidia. ");
INSERT INTO aia_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Raru mamaani ha'a-'o'oriraaui sae ni heisoi na'i 'isi dorai ura baabaui hinihinidaau beia Jisas. Mararu o'ani, “'Ai ragoi maho rai ha'abooboo abe na'i tahingagaa'i nagai siri suri'i magaigu matai siri na'i hourana ana God.” ");
INSERT INTO aia_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mararu 'ome sigihi'i tara'i saemwane narau bwane hinihinia Araha 'anai bwauodo na'i heisoi suri'i 'omaa 'isi. Rau ha'aririta'i ngau marau ha'arahesi maraugu wate'i woui sae 'isi tanaa Araha 'anai na'otara na'i heisoi. ");
INSERT INTO aia_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","'Ia Pol mea Banabas raru hano baaniai Antiok na'i Provensi Pisidia mararu 'ari Provensi Pamfilia ");
INSERT INTO aia_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","mararu taroha'iniai Taroha Goro na'i 'omaai Paga. Raru dio 'anai Atalia ");
INSERT INTO aia_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ma na'i 'isi nararugu ta'e iei 'anai 'omaa ra 'unu Antiok ro'u 'inia. 'A awa na'i Provensi Siria. Na'i Antiok na'i Provensi Siria, naasi dora ra waterarua ani na'i bwabwahenai rimana God, 'anai hauai tau'aro nararu bura'i ha'ahakoasi. ");
INSERT INTO aia_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","'Oha raru ada na'isi, raru soigoniraau mai sae ni heisoi, mararu maani'i tanaraaui mwane mareho na haa'ia God suri'i mwane 'aariha nararu bwane haa'i. Mararu maania ro'u do'ia God 'a ha'awateraaui nei nara ai'a Jiu do 'anai hinihinia ro'ua Jisas. ");
INSERT INTO aia_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Raru awa orea na'i 'omaasi beiraaui sae hinihini. ");
INSERT INTO aia_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tara'i Jiu hinihini na'i Jiudea rau boi na'i Antiok marau maania tanaraaui sae ni heisoi na'isi do 'onaa rau bwa'i dauai ringei aha ha'ara 'onaai 'unua ana Moses, 'ia God 'a bwa'i ruhasiraau baani'i ora-ora'a adaa'i. ");
INSERT INTO aia_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol mea Banabas raru ai'a 'adoma'i aratara beiraau 'iniai mahosi mararu hauai kaeni heiraeraesi beiraau. Naasi mara 'ome sigihirarua bei'i tara'i sae ro'u 'anai 'ari aho'i Jerusalem 'anai hadanga'iniai mahosi beiraaui Ha'ataari ma tara'i na'otara ro'u na'i heisoi. ");
INSERT INTO aia_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","'Iraaui sae hinihini na'i Antiok rau ha'a-taariraau 'ari, marau riuhoro na'i Ponisia mana Samaria. Rau maania tanaraaui sae ni heisoi 'isi, do tara'i nei nara ai'a Jiu rau hinihinia'a Jisas. Miraaui sae ni heisoi rau wa'ewa'e di'u 'iniai tarohasi 'oha rau rongoa. ");
INSERT INTO aia_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Na'i 'oha 'iraau ruruha ana Pol rau ada na'i Jerusalem, 'iraaui sae ni heisoi na'isi goni beiraaui Ha'ataari miraaui na'otara rau ha'amaotoraau. Mia Pol mea Banabas raru maani'i mwani maho na haa'ia God suri'i mwane 'aariha nararu bwane haa'i. ");
INSERT INTO aia_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tara'i Farisei nara siri mai na'i heisoi rau ura ara'a marau o'ani, “'Iraaui sae ra ai'a Jiu narau siri mai na'i heisoi rai daua ma'ata 'i ringei aha ha'ara, marai ha'isuri'i Ringe ana'ia Moses.” ");
INSERT INTO aia_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Miraaui Ha'ataari mana na'otara rau rurugoni marau hadanga'iniai haiu'au'a na to'o beiraaui nei ra ai'a Jiu. ");
INSERT INTO aia_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Rau hadanga'inia orea di'u i mahosi. Mia Pita 'a ura ara'a ma o'ani, “Arai do'ora, mou aidangisia do'ia God 'a bwane 'ome sigihiau mau mai baaniai ruruhani 'anai taroha'iniai Taroha Goro tanaraaui nei ra ai'a Jiu. 'Ia God 'a haua o'asi dorai rongoai Taroha Goro marai hinihinia. ");
INSERT INTO aia_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mia God 'a 'ome 'iraraa do rau hinihinia ha'a-momori, 'inia 'iia 'a 'irara'i hakoi 'adoma'igaa'i. Ma ha'ata'inia do'a 'ome sigihiraau ro'u i nei ra ai'a Jiu na'i 'oha na banea tanaraaui Hi'ona Maea 'onaai banea ana ro'u tanagia. ");
INSERT INTO aia_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Mana here na haua tanaraau 'a ta'isada beiai here na haua nagaau. 'Inia 'oha raugu hinihinia ma ha'a-ai'a'i ora-ora'a adaa'i 'onaai bwane haua ana beigaau. ");
INSERT INTO aia_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Naasi, ni 'uaana namou raba ha'ataesu'aa 'inia God na'i 'oha namou ha'a-'usu'usuraaui nei nara ai'a Jiu 'anai suri'i mwane ringe ana'ia Moses? Ai'a odo-odo 'anai ha'a-hihi'araaui sae hinihini nara ai'a Jiu 'ini'i ringe na 'igaau miraaui wauwa agaa'i rau bwara ro'u 'anai ha'isuri'i! ");
INSERT INTO aia_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","'Igaau gau hinihinia do 'ia Araha aga Jisas 'a ruhasigia 'iniai goro ana 'inigia, 'onaai ruhasiraau ana ro'u i nei narau ai'a Jiu.” ");
INSERT INTO aia_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","'Iraau hako rau ngotoburu marau rongobahua Banabas mea Pol, maania adaruai mena na haua God tanararua nararugu haa'i 'ini'i mwani ha'abu'oahu mana ha'ara tanaraaui nei ra ai'a Jiu. ");
INSERT INTO aia_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","'Oha raru mamaani hako, mia Jems 'a o'ani, “Arai do'ora, moisu rongoai maho wai maaniani. ");
INSERT INTO aia_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","'Ia Saemon Pita 'a bura'i maania moi tanagaau do'ia God 'a ta'ahiraaui nei narau ai'a Jiu ma 'ome sigihi'i tara'i nei 'anai ha'i noni ana'i. ");
INSERT INTO aia_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","'A ta'isada 'onaai maho narau usuai rarabea o'ani, ");
INSERT INTO aia_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘'Inaua God wai aho'i mai mawai ha'a-urasia aho'i ruma ana Deved na kokohu. Wai tagoraa aho'i 'ini'i hau 'ana nara 'adarara. ");
INSERT INTO aia_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Wai haua o'asi neina 'iraaui nei narau ai'a Jiu rai matai rihosi mai tanaau, marai ha'i inoni agu'i. 'Ia God na ha'atee o'asi, ");
INSERT INTO aia_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","'iia 'a bwane 'unu'i mau mai doni mwane mareho 'isi rai to'o.’” ");
INSERT INTO aia_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Mia Jems 'a o'ani ro'u, “Naasi, na'i 'ado'adogu, gai abu ha'a-hihi'araaui nei narau ai'a Jiu narau rihota'i tanaa God 'anai araisuri'i hakoi ringe agaa'i Jiu. ");
INSERT INTO aia_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Gai usu-usu moi tanaraau magai 'unua tanaraau dorai abui wawaasua'a ma'ua ngaa'i mahoingau ra ho'asi'i 'iniai araaranunu. Marai abu ngaa'i 'abudi mwamwaa ma'uasi ngaa'i hasi'odi mwamwaa nara ri'oi'i. ");
INSERT INTO aia_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Rai abui hau'i mareho o'asi, suria na ringe 'isi, ra'i ringe ana'ia Moses nara bwane maani'i tarau suri'i mwani 'omaa hako mara 'oha'ini'i 'ado 'oha gau boi goni suri'i dangi ni mamaro.” ");
INSERT INTO aia_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","'Iraaui Ha'ataari miraaui na'otara miraau hakoi sae hinihini na'i Jerusalem, rau 'adoma'inia dorai ha'ataari'i tara'i sae beia Pol mea Banabas 'ari Antiok. Rau 'ome sigihia Saelas mea Jiudas Basabas, 'irarua 'e rua na'otara na'i heisoi. ");
INSERT INTO aia_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ra hauai usu-usu 'anai ha'ataaria beirarua. Ma na'i raronai usu-ususi 'a o'ani, 'I'ameui Ha'ataari miraaui na'otara, meu haua woui ha'atee wa'ewa'e ameeu tana'amoui nei mou ai'a Jiu na'i 'omaai Antiok mei Siria mana'i Silisia namou aho'ita'i sae hinihini. Arai do'oramee'i na'i Kraest, ");
INSERT INTO aia_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","meu rongoa do ra'i sae nara hano 'ini, rau 'ari wou marau maani'i mareho tana'amou nara torakoke 'ini'i 'adoma'imoo'i. 'I'ameu meu ai'a ha'ataari'i sae 'isi. ");
INSERT INTO aia_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Meu rurugoni mameu 'adoma'i aratara hako 'anai 'ome sigihi'i sae 'anai ha'ataari'i wou tana'amou. Rai hano beiraruai rua gere sae goro ameeu, 'ia Banabas mea Pol, ");
INSERT INTO aia_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","nararu bwane siri'a ga'u na'i maemaeha 'iniai tau'aro adarua tanaa Araha aga Jisas Kraest. ");
INSERT INTO aia_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Naasi mei ha'ataaria woua Jiudas mea Saelas, 'irarua rarui maani'i ro'u mau tana'amoui maho nameu maani'i na'i usu-usuni. ");
INSERT INTO aia_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","I Hi'ona Maea 'a ha'ata'inia tana'ameu mameu 'adoma'i aratara beia domei abu ha'ahihi'amou 'ini'i mwani ringeringe. Ma'ata 'a ga'i goro do moi ha'isuri'i mareho 'ini. ");
INSERT INTO aia_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Moi abui ngaa'i mahoingau nara ho'asi'i 'iniai araaranunu, mana ngaa'i 'abudi mwamwaa, ma'uasi ngaa'i hasi'odi mwamwaa nara ri'oi'i, mamoi abui wawaasua'a. 'Onaa moi ha'isuri'i ringeringe 'ini, 'i'amou mou suriai taha na odo-odo. 'Io, moigui mauru goro'a. ");
INSERT INTO aia_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Miraaui waira haisi rau hano baaniai Jerusalem marau ada na'i Antiok. Rau soigoniraau mai sae hinihini marau taranga'inia tanaraaui usu-usu. ");
INSERT INTO aia_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","'Oha rau 'oha'iniai usu-usu, rau wa'ewa'e di'u, 'inia 'a ha'a-'o'ori'i tahingadaa'i. ");
INSERT INTO aia_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","'Ia Jiudas mea Saelas 'e rua sae nararu matai ha'arangasi'i hura'a i 'ado'adona'i a God, raru hadahada orea tanaraaui sae hinihini mararu ha'a-weteweteai hinihinidaau. ");
INSERT INTO aia_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Raru awa gere orea ga'u na'i Antiok. Mana'i 'oha raru ha'aagau 'anai 'ari aho'i Jerusalem, 'iraau sae hinihini rau hauai ha'atee ha'agorohi mana haiha'ari adaau tanararua. ");
INSERT INTO aia_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Mia Saelas 'agu 'adoma'inia do'ai awa moi. ");
INSERT INTO aia_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Mia Pol mea Banabas raru awa mau na'i Antiok. 'Iraau goni tara'i sae ro'u, rau ha'ausuri marau taroha'iniai Taroha Goro ana Araha tanaraaui sae. ");
INSERT INTO aia_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Na'i muri, mia Pol 'a 'unua tanaa Banabas do rarui 'ari gaariri suri'i 'omaa raru bwane taroha'iniai tarohana Araha suri'i mararui aidangisia 'a he'uai tahingadaa'i sae hinihini. ");
INSERT INTO aia_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Mea Banabas 'a rabasia do rarui waia Jon Mak. ");
INSERT INTO aia_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Mia Pol 'a ai'a rabasia o'asi, 'inia Mak 'a aho'i moi baanirarua na'i 'oha rau taha ga'u na'i Pamfilia, maagu ai'a tagora'a beirarua. ");
INSERT INTO aia_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Raru kae heiraeraesi suria mararu heihoahoa'a. 'Ia Banabas 'a waia Mak mararu ta'e na'i haka 'anai hura'ai Saepras. ");
INSERT INTO aia_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Mia Pol 'a 'ome sigihia Saelas 'anai 'a'auhia. Miraaui sae hinihini rau ha'arahesi 'a'auhirarua marau ha'angonia God 'anai 'omesurirarua. ");
INSERT INTO aia_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Naasi, raru 'ari daara'iniai Siria mei Silisia, raru hadahada ha'a-'o'oriraau sae ni heisoi. ");
INSERT INTO aia_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","'Ia Pol mea Saelas raru 'ari Debe mei Listra, mararu sadoiai sae hinihini na atana 'ia Timoti. 'Ia inana 'e urao hinihini ni Jiu mia amana 'e ai Grik. ");
INSERT INTO aia_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","'Iraaui sae hinihini na'i Listra mei Aekoniam rau haa'i mamaani rongo goro 'inia Timoti. ");
INSERT INTO aia_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Naasi mia Pol 'a rabasia dorai ta'i hanoa Timoti. Ma aha ha'ara ga'ua Timoti, 'inia 'ia Pol 'a rabasia do 'iraaui Jiu na'i dorasi rai wa'ewa'e 'anai bahurongoa Timoti. 'Iraau Jiu 'isi rau 'iraraa do 'ia Timoti, ai'a 'oha nai aha ha'ara, 'inia amana 'e ai Grik. ");
INSERT INTO aia_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na'i 'oha 'iraaua Pol rau 'aariha suri'i 'omaa, rau maani'i tanaraaui sae hinihini ringe 'iraaui Ha'ataari miraaui na'otara na'i Jerusalem rau 'unua tanaraaui sae 'anai araisuri'i. ");
INSERT INTO aia_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mana hinihinidaa'i sae hinihini 'agu wetewete di'u ro'u wou. Ma ragoi nei rau hinihinia Jisas 'ado dangi. ");
INSERT INTO aia_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","'Iraaua Pol rau riuhoro na'i Provensi Frijia mana Galesia 'iniai Hi'ona Maea 'a ai'a ha'awateraau dorai heitaroha'i na'i Provensi Eisia na'i 'ohasi. ");
INSERT INTO aia_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Na'i 'oha rau ada na'i tariha anai Provensi Mesia, rau taraawa'ai siri na'i Provensi Bitinia mana Hi'ona Maea 'a ai'a ha'awateraau. ");
INSERT INTO aia_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Marau 