﻿USE sofia;
DROP TABLE IF EXISTS sofia.ahr_vpl;
CREATE TABLE ahr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ahr_vpl WRITE;
INSERT INTO ahr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","सुरवातले देवनी आकाश अनं पृथ्वी हाई निर्माण करी. ");
INSERT INTO ahr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","अनी पृथ्वी आकारविरहित अनं शुन्य व्हती, खोल पाणीना वरना भागवर अंधार व्हता. अनी देवना आत्मा जलवर तळपी राहिंता. ");
INSERT INTO ahr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","तवय देव बोलना, प्रकाश व्हय जाय, अनी प्रकाश व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","देवनी दखं की, तो चांगला शे; अनी देवनी प्रकाश अनं अंधार ह्या एकमेकसपाईन येगळा करात. ");
INSERT INTO ahr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","देवनी प्रकाशले दिन अनी अंधारले रात म्हणं; अनी संध्याकाळ व्हयनी अनं सकाय व्हयनी; हाऊ पहिला दिन. ");
INSERT INTO ahr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","मंग देव बोलना, जलना मध्यभागमा अंतराळ व्हय जाय, अनं ते जलले दोनभाग करनारा व्हवोत. ");
INSERT INTO ahr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","अश देवनी अंतराळ बनाडं अनी अंतराळ खालना अनं वरना जलले वेगळा करात; अनी तश व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","देवनी अंतराळले आकाश म्हणं; अनी संध्याकाळ व्हयनी अनं सकाय व्हयनी; हाऊ दुसरा दिन. ");
INSERT INTO ahr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","मंग देव बोलना, आकाशखालना पाणी एक ठिकानमा गोया व्होवो, अनं कोरडी जमीन दृष्टीमा पडो; अनी तश व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","देवनी कोरडी जमिनले भूमी म्हणं अनं गोया व्हयेल पाणीले समुद्र म्हणं; देवनी दखा की, हाई चांगलं शे. ");
INSERT INTO ahr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","तवय देव बोलना, हिरवळ, बी देनारी वनस्पती अनी स्वतःव्हईसन बीसहीत फळ देनारी फळझाडं भूमी आपलावर उगाडो; अनी तस व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","हिरवळ, स्वतःव्हईसन बी देनारी वनस्पती अनं स्वतःव्हईसन बीसहीत फळ देनारा फळझाडं भूमीनी उगाडं; देवनी दखं की, हाई चांगलं शे. ");
INSERT INTO ahr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","अनी संध्याकाळ व्हयनी अनं सकाय व्हयनी हाऊ तिसरा दिन. ");
INSERT INTO ahr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","मंग देव बोलना, दिन अनं रात हाई भिन्न कराकरता आकाशना अंतराळमा ज्योती व्हवोत; त्या चिन्ह, र्ऋतु, दिन अनं वरीस दखाडनारा व्हवोत. ");
INSERT INTO ahr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","पृथ्वीले प्रकाश देवाकरता आकाशना अंतराळमा त्या ज्योती व्हवोत; अनी तस व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","देवनी दोन मोठल्या ज्योती बनाड्यात; दिनवर प्रभुत्व चालाडाकरता मोठी ज्योती अनी रातवर प्रभुत्व चालाडाकरता धाकली ज्योती; तसच त्यानी तारा बी बनाडात. ");
INSERT INTO ahr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","देवनी त्यासले आकाशना अंतरमा याकरता ठेयं की त्यासनी पृथ्वीवर प्रकाश दे; ");
INSERT INTO ahr_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","अनी दिन अनं रात यासवर प्रभुत्व चालाले पाहिजे अनी ज्योती ले अंधारापाईन येगळं करं, देवनी दखं की, हाई चांगलं शे. ");
INSERT INTO ahr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","अनी संध्याकाळ व्हयनी अनं सकाळ व्हयनी; हाऊ चौथा दिन. ");
INSERT INTO ahr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","मंग देव बोलना जीवजंतुसना घोळकासघाई जलं भरी जावोत अनी पृथ्वीवरीन आकाशना अंतराळमा पक्षी उडान करोत. ");
INSERT INTO ahr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","पाणीमाधला मोठा जलचर प्राणी, पाणीमा गजबजनारा अनं संचार करनारा प्रत्येक जातीना सर्वा जीव अनी प्रत्येक प्रकारना पक्षी ज्या पाणीमा पण अनं बाहेर बी राहतस असा प्राणी देवनी निर्माण करात; देवनी दखं की, हाई चांगलं शे. ");
INSERT INTO ahr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","देवनी त्यासले आशिर्वाद दिधा, फलद्रूप व्हा, बहुगुणित व्हा, समुद्रामाधलं पाणी व्यापी टाका; अनी पृथ्वीमा पक्षी बहुगुणित व्हवोत. ");
INSERT INTO ahr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","अनी संध्याकाळ व्हयनी अनं सकाळ व्हयनी; हाऊ पाचवा दिन. ");
INSERT INTO ahr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","मंग देव बोलना, \"प्रत्येक जातना पाळीव प्राणी, सरपटणारा प्राणी अनं वनपशु अस जीवधारी प्राणी पृथ्वी उपजवो.\" अनी तसच व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","अस प्रत्येक जातना वनपशु, ग्रामपशु अनं जमीनवर रांगनारा जीव देवनी बनाडं; देवनी दखं की, हाई चांगलं शे. ");
INSERT INTO ahr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","मंग देव बोलना, \"आपला प्रतिरूपना अनं आपलासारखा दिसनारा अस मनुष्य आपण बनाडूत; समुद्रमाधलं मासा, आकाशमाधलं पक्षी, ग्रामपशु, सर्वी पृथ्वी अनी पृथ्वीवरला रांगनारा सर्वा प्राणी यासनावर त्या सत्ता करतीन.\" ");
INSERT INTO ahr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","देवनी आपला प्रतिरूपना मनुष्य बनाडं; देवना प्रतिरूप अस तो बनाडामा वना, नर अनं नारी अस त्या बनाडाई गयात. ");
INSERT INTO ahr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","देवनी त्यासले आशिर्वाद दिधा; अनी त्यासले बोलना, फलद्रूप व्हा, बहुगुणित व्हा, पृथ्वी व्यापी टाका अनं तिले सत्तामा आणा; समुद्रमाधला मासा, आकाशमाधला पक्षी अनं पृथ्वीमा संचार करनारा सर्वा प्राणी यासनावर सत्ता चालावा. ");
INSERT INTO ahr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","देव बोलना, दखा, सर्वा भुतलावरनं बीज देनारी प्रत्येक वनस्पती अनं स्वतःव्हईसन बीसहीत फळ देनारा प्रत्येक झाड मी तुमले देस; ह्या तुमना अन्न व्हतीन; ");
INSERT INTO ahr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","तसच पृथ्वीवरला सर्वा पशु, आकाशमाधलं सर्वा पक्षी अनं पृथ्वीवर संचार करनारा सर्वा जीवधारी प्राणी यासले सर्व हिरवळ खावाकरता देस; अनी तसच व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","आपण करेल सर्वा भलतंच चांगलं शे अस देवनी दखं, संध्याकाळ व्हयनी अनं सकाळ व्हयनी हाऊ सहावा दिन. ");
INSERT INTO ahr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","याप्रमाणे आकाश अनं पृथ्वी अनी त्यानामाधलं सर्व काही पुरं व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","देवनी करेल आपला कामं सातवा दिनले समाप्त करात, सर्वा करेल कामपाईन त्यानी सातवा दिनले विसावा लिधा. ");
INSERT INTO ahr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","देवनी सातवा दिन आशिर्वाद दिसन पवित्र करा; कारण सृष्टी बनाडानं काम पुरं करीसन त्यानी‍ त्या दिनले विसावा लिधा. ");
INSERT INTO ahr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","आकाश अनी पृथ्वी यासनी उत्पती देवनी करी, तवयना हाऊ उत्पतीक्रम शे. ");
INSERT INTO ahr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","परमेश्वर देवनी आकाश अनी पृथ्वी बनाडी तवय शेतमाधलं कोणतच उदभिज्ज पृथ्वीमा नव्हतं अनी शेतमाधलं कोणतं भी वनस्पती अजुन उगायल नव्हती कारण परमेश्वर देवनी पृथ्वीवर अजुन पाणी पाडेल नव्हता, अनी जमिननी मशागत कराले कोणी मनुष्य नव्हता. ");
INSERT INTO ahr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","पण पृथ्वीवरतीन धुकं वर जाये अनं त्याघाई सर्व जमीनवर सिंचन व्हई जाये. ");
INSERT INTO ahr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","मंग परमेश्वर देवनी जमीनवरली मातीघाई आदामले बनाडं अनं त्याना नाकपुडामा जीवनना श्वास फुका; तवय आदाम जीवधारी प्राणी बनना. ");
INSERT INTO ahr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","परमेश्वर देवनी पुर्व दिशाले एदेन बाग बनाडा अनी त्यामा आपण बनाडेल आदामले ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","परमेश्वर देवनी दिसाले सुंदर अनं अन्नकरता उपयोगी अस सर्वा जातीना झाडे, बागना मध्यभागी जीवनना झाड, अनी बऱ्यावाईटना ज्ञान करी देनारा झाड भी जमीनमाईन उगाडं. ");
INSERT INTO ahr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","बागले पाणी देवाकरता एदेनमा एक नदी उगम पावनी; तठेन ती निंघीसन तिना फाटा फुटीसन तिना चार नद्या व्हयन्यात. ");
INSERT INTO ahr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पहिलीनं नाव पीशोन, हाई सगया हवीला देशले चारीमेरतीन वेढस; तठे सोनं सापडस; ");
INSERT INTO ahr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ह्या देशनं सोनं उत्तम ऱ्हास आठे मोती अनं किमती खडा बी सापडतस. ");
INSERT INTO ahr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दुसरी नदीनं नाव गीहोन शे; हाई सगया कूश देशले चारीमेरतीन वेढस. ");
INSERT INTO ahr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","तिसरी नदीनं नाव हिद्दकेल; हाई अश्शुरना पूर्वले वाहस, चौथी नदीनं नाव फरात. ");
INSERT INTO ahr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","परमेश्वर देवनी आदामले एदेन बागमा लईसन तिनी मशागत अनं राखण कराले ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","तवय परमेश्वर देवनी आदामले अशी आज्ञा दिधी की, बागमाधला तुले वाटी त्या झाडनं फळ शंका न करता खा; ");
INSERT INTO ahr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","पण बऱ्यावाईटनं ज्ञान करी देणारं झाडनं फळ खावानं नही; कारण ज्या दिन त्यानं फळ तु खाशी त्या दिन तु पक्का मरशी.\" ");
INSERT INTO ahr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","मंग परमेश्वर देव बोलना, \"आदाम एकटा ऱ्हावाले पाहिजे हाई बरं नही, तर त्यानाकरता अनुरूप सहाय्यक मी करसु.\" ");
INSERT INTO ahr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","परमेश्वर देवनी सर्वा वनपशु अनी आकाशमाधला सर्वा पक्षी ह्या मातीघाई बनाडावर आदाम त्यासले कोणतं नाव देस हाई दखाकरता देवनी त्या आदामकडे लयात; तवय आदामनी प्रत्येक सजीव प्राणीले जे नाव दिधं तेच त्यानं नाव पडनं. ");
INSERT INTO ahr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","आदामनी सर्वा ग्रामपशु, आकाशमाधला पक्षी अनं सर्वा वनपशु, यासले नाव दिधात; पण आदामले कोणी अनुरूप सहाय्यक भेटना नही. ");
INSERT INTO ahr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","मंग परमेश्वर देवनी आदामले गाढ झोपमा आणं; अनी आदाम झोपना तवय त्यानी एक फासळी देवनी काढी लिधी, तिनी जागा मासघाई भरी दिधी; ");
INSERT INTO ahr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","परमेश्वर देवनी आदामनी फासळी काढीसन तिनी बाई बनाडी अनी तिले आदामनाजोडे लयं. ");
INSERT INTO ahr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","तवय आदाम बोलना, आते हाई तर मना हाडमाधलं हाड अनी मासमाधलं मास शे; हिले नारी सांगानं कारण हाई नरपाईन बनाडेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","यामुये पुरूष आपला मायबापले सोडीन आपला बाईसंगे जडी राही; त्या दोन्ही एकदेह व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","आदाम अनं त्यानी बाई ह्या दोन्ही नंगा व्हतात, तरी त्यासले संकोच वाटेच नही. ");
INSERT INTO ahr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","परमेश्वर देवनी बनाडेल सर्वा वनचरमा साप पक्का लबाड व्हता. तो आदामनी बाईले बोलना, \"तुम्हीन बागमाधला कोणतं बी झाडनं फळ खावानं नही अश देवनी तुमले सांगं हाई खरं शे का?\" ");
INSERT INTO ahr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","बाईनी सापले सांगं, \"बागमाधला झाडंसनं फळ खावानी आमले परवांगी शे, ");
INSERT INTO ahr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","पण बागना मध्यभागमा जे झाड शे त्यानाविषयी देवनी आमले सांगेल शे की, त्यानं फळ खावानं नही; त्याले स्पर्श बी करानं नही, करशात तर मरशात.\" ");
INSERT INTO ahr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","साप त्या बाईले बोलना, \"तुम्हीन खरोखर मरावुत नहीत.\" ");
INSERT INTO ahr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","कारण देवले हाई माहिती शे की, ज्या दिनले तुम्हीन त्यानं फळ खाशात त्याच दिनले तुमना डोया उघडतीन, अनी तुम्हीन देवना मायक चांगलं अनी वाईट जाणनारा व्हशात.\" ");
INSERT INTO ahr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","त्या झाडनं फळ खावाले चांगलं, दखाले मनोहर, अनी समजदार कराले इष्ट शे अश त्या बाईले दिसनं, तवय तिनी त्या झाडनं फळ तोडीसन खादं अनं आपलासोबत आपला नवराले बी ते दिधं; अनं त्यानी पण ते फळ खादं. ");
INSERT INTO ahr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","तवय त्या दोनी नवरा बायकोसना डोया उघडनात अनी आपन नंगा शेतस अश त्यासले समजनं; तवय त्यासनी आपलं अंग झाकाकरता अंजिरना झाडना पानं शिईसन स्वतःले झाकी लिधं. ");
INSERT INTO ahr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","मंग संध्याकाळना थंडा वारा सुटना तवय परमेश्वर देव एदेन बागमा फिरी राहिंता, त्याना आवाज आदामले ऐकु वना, तवय परमेश्वर देवना नजरतीन आदाम अनं त्यानी बाई बागना झाडसमा लपनात. ");
INSERT INTO ahr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","तवय परमेश्वर देवनी आदामले हाक मारीसन सांगं, \"तु कोठे शे?\" ");
INSERT INTO ahr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","आदामनी देवले सांगं, \"मी बागमा तुना आवाज ऐका, पण मी नंगा शे, म्हणीसन भ्याईसन लपनु.\" ");
INSERT INTO ahr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","देवनी त्याले सांगं, \"तु नंगा शे हाई तुले कोणी सांगं? ज्या झाडनं फळ तु खावानं नही अशी आज्ञा मी तुले देल व्हती त्यानं फळ तु खादं का?\" ");
INSERT INTO ahr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","आदाम बोलना, \"जी बाई तु माले सोबतमा दिधी तिनी त्या झाडनं फळ माले दिधं अनी ते मी खादं.\" ");
INSERT INTO ahr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","परमेश्वर देव त्या बाईले बोलना, \"हाई तु काय करं? बाई बोलनी, सापनी माले भुरळ घाली म्हणीसन मी ते खादं.\" ");
INSERT INTO ahr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","तवय परमेश्वर देव सापले बोलना, \"तु हाई करं म्हणीसन सर्वा ग्रामपशु अनं वनचर यासनापेक्षा तु शापग्रस्त हो; तु पोटघाई चालशी अनी आयुष्यभर माती खाशी; ");
INSERT INTO ahr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","अनी तु अनं बाई, तुनी संतती अनं तिनी संतती यासनामा मी परस्पर वैर स्थापन करसु; ती तुना डोका फोडी, अनं तु तिनी टाच फोडशी.\" ");
INSERT INTO ahr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","परमेश्वर बाईले बोलना, \"मी तुना दु:ख अनं तुना गर्भधारणा बहुगुणित करसु; तु क्लेशमा पोऱ्यासले जन्माले घालशी; तरी तुना ओढा नवराकडे राही अनी तो तुनावर स्वामीत्व चालाडी.\" ");
INSERT INTO ahr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","आदामले तो बोलना, \"तु तुना बाईना ऐकनास अनी ज्या झाडनं फळ खावानं नही म्हणीसन मी तुले आज्ञा करेल व्हती त्यानं फळ तु खादं; म्हणीन तुनामुये भुमीले शाप येल शे; तु आयुष्यभर कष्ट करीसन तिना उपज खाशी; ");
INSERT INTO ahr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ती तुले काटा अनं कुसळ दि; तु शेतमाधलं पिक खाशी; ");
INSERT INTO ahr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","तु आपला निढळना घामघाई भाकर मियाडीसन खाशी अनं शेवट परत मातीले जाईसन मिळशी; कारण तिनापाईनच तुनी उत्पती शे, तु माती शे अनी मातीले परत जाईसन मिळशी.\" ");
INSERT INTO ahr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदामनी त्यानी बाईना नाव हव्वा ठेवं, कारण ती सगया जीवधारी जणसनी माय शे. ");
INSERT INTO ahr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","परमेश्वर देवनी आदाम अनं त्यानी बाई यासनाकरता चर्मवस्त्र बनाडीसन त्यासले घालात. ");
INSERT INTO ahr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","मंग परमेश्वर देव बोलना, \"मानवले चांगलं अनी वाईट कळीसन तो आमनामातीन एकसमान व्हयेल शे; तर आते कदाचित मानव आपला हात जिवनना झाडले लाईन त्याना बी फळ तोडीसन खाई अनं सर्वाकाळ जिवत राही.\" ");
INSERT INTO ahr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","पण ज्या भुमीमाईन त्यासले बनाडेल व्हतं तिनी मशागत कराले पाहिजे म्हणीसन परमेश्वर देवनी त्यासले एदेन बागमाईन बाहेर काढी दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","देवनी मानवले बाहेर काढी दिधं अनी जिवनना झाडकडे जाणारा वाटनी राखण कराकरता एदेन बागना पुर्व भागले करूबीम अनं गरागर फिरणारी ज्वालारूपी तलवार ठेई. ");
INSERT INTO ahr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","आदाम त्यानी बाई हव्वा हिना पान गया; ती गर्भवती व्हईसन तिनी काईनले जन्म दिधा; ती बोलनी, \"परमेश्वराना साहाय्यातीन माले पुरूषसंतान लाभना शे.\" ");
INSERT INTO ahr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","नंतर तिनी त्याना भाऊ हाबेल याले जन्म दिधा. हाबेल मेंढपाळ व्हयना अनी काईन शेतकरी व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","काही काळ लोटावर अश व्हयना की, काईननी परमेश्वरले शेतना उत्पनापाईन काही अर्पन आणात. ");
INSERT INTO ahr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","हाबेलनी बी आपला मेंढरंसना कळपसमाईन पहिला जन्मेलसपाईन, म्हणजे त्यामातीन चांगलं चरबीवालं अर्पन आणं, परमेश्वरनी हाबेल अनं त्याना अर्पन यासना आदर करा; ");
INSERT INTO ahr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","पण काईन अनं त्यानं अर्पन यासना त्यानी आदर करा नही; म्हणीसन काईन संतापना अनं त्यानं तोंड उतरना. ");
INSERT INTO ahr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","तवय परमेश्वर काईनले बोलना: तु का संतापनास? अनी तुनं तोंड का उतरनं? ");
INSERT INTO ahr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","तु चांगलं करशी तर तुनी मुद्रा प्रसन्न व्हवावु नही का? पण तु चांगलं करनास नही तर दारनाजोडे पाप टपी बसेल शे, त्याना रोख तुनावर शे, म्हणीन तु त्याले दाबमा ठेव. ");
INSERT INTO ahr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","मंग काईननं त्याना भाऊ हाबेल यानासंगे बोलनं व्हयनं; अनी अश व्हयनं की, त्या वावरमा व्हतात तवय काईननी आपला भाऊ हाबेल यानावर चाल करीसन त्याले मारी टाका. ");
INSERT INTO ahr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","मंग परमेश्वर देवनी काईनले ईचारं, \"तुना भाऊ हाबेल कोठे शे?\" तो बोलना, \"माले माहित नही; मी काय मना भाऊना राखणदार शे?\" ");
INSERT INTO ahr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","परमेश्वर काईनले बोलना, \"तु हाई काय करं? ऐक! तुना भाऊना रक्त भुमीमाईन माले आवाज दि राहीना शे. ");
INSERT INTO ahr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","तर आते तुना हाततीन तुना भाऊनं पडेल रक्त पेवाकरता ज्या भुमीनी तोंड उघाडेल शे, तिना तुले शाप शे; ");
INSERT INTO ahr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","तु जमीननी मशागत करशी तवय ती यानापुढे तुले आपला सत्व देवाव नही; तु पृथ्वीवर बेघर अनं भटक्या व्हशी.\" ");
INSERT INTO ahr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","तवय काईन परमेश्वरले बोलना, \"हाई मनी शिक्षा माले सहन करता येवाव नही इतली भारी शे. ");
INSERT INTO ahr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","दखा, हाई जमीनवरीन माले आज तु हाकली देल शे; मी तुना नजरतीन लपेल ऱ्हासु, मी पृथ्वीवर बेघर अनी भटक्या व्हसु; अनी ज्या कोणले बी मी सापडसु तो माले मारी टाकी अश व्हई.\" ");
INSERT INTO ahr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","परमेश्वर त्याले बोलना, \"तर मंग जो कोणी काईनले ठार मारी त्याना सातपट सूड लेवामा ई अनी काईन कोणले सापडना तर त्याले कोणी मारानं नही म्हणीसन त्याले परमेश्वरनी खूण नेमी दिधी.\" ");
INSERT INTO ahr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","काईन परमेश्वरपाईन निंघना अनी एदेनना पुर्वले नोद नावना देशमा वस्ती करीन राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","काईन आपली बाईकोपान गया, अनी ती गर्भवती व्हईन तिले हनोख व्हयना; काईननी एक नगर बांधा; त्या नगरना नाव त्यानी आपला पोऱ्याना नाव वरीन हनोख अश ठेवा. ");
INSERT INTO ahr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोखाले इराद व्हयना; इरादले महूयाएल व्हयना; महूयाएलले मथुशाएल व्हयना अनी मथुशाएलले लामेख व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लामेखनी दोन बायका करात; पहिलीनं नाव आदा अनं दुसरीनं नाव सिल्ला. ");
INSERT INTO ahr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदा हिले याबाल व्हयना; तो तंबु बनाडीसन राहनारा अनं गुरंढोरं पाळनारा यासना मूळपुरूष व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","त्याना भाऊना नाव युबाल अश व्हतं; तो तंतुवाद्ये अनं वायुवाद्ये वाजडनारासना सर्वासना मूळपुरूष व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","सिल्ला हिले बी तुबल काईन नावना पोऱ्या व्हयना; तो तांबासनी अनी लोखंडनी धारनी सर्वा प्रकारना हत्यारं बनाडनारा व्हयना; अनी तुबल काईनले नामा नावनी बहीण व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लामेख आपला बायकासले बोलना, आदा अनी सिल्ला, तुम्हीन मना आवाजकडे ध्यान द्या, लामेखन्या बायकासहो, मना भाषणकडे कान द्या; एक माणुसनी मनावर प्रहार करा म्हणीसन मी त्याले ठार मारी टाकं. ");
INSERT INTO ahr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","काईननाबद्ल सातपट सूड लेवाना तर लामेखबद्ल सत्याहत्तरपट लेवामा ई. ");
INSERT INTO ahr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आदाम आपली बायकोपन गया, अनी तिले पोऱ्या व्हयना, त्याना नाव तिनी शेथ ठेवं; ती बोलनी, \"काईननी हाबेलना घात करा म्हणीन देवनी त्याना जागी माले दुसरा पोऱ्या देल शे.\" ");
INSERT INTO ahr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","शेथ याले पोऱ्या व्हयना त्यानं नाव त्यानी अनोश अश ठेवात; त्या काळपाईन लोक परमेश्वरना नावतीन आराधना कराले लागनात. ");
INSERT INTO ahr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","आदामनी वंशावळीनी नोंद याप्रकारतीन. देवनी मानव उत्पन्न करा त्या येळले त्यानी तो स्वतःनामायक दिसणारा असा करा, ");
INSERT INTO ahr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","त्यानी त्यासले नर अनं नारी अश उत्पन्न करात अनं त्यासले आशिर्वाद दिधा; अनी त्यासले उत्पन्न करात त्या येळले त्यासले आदाम हाई नाव दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","आदाम एकशेतीस वरीसना व्हवावर त्याले त्यानाशी सदृश, त्याना प्रतिरूपना पोऱ्या व्हयना, त्याना नाव त्यानी शेथ ठेवा; ");
INSERT INTO ahr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","शेथ व्हवावर आदाम आठशे वरीस जगना, अनं त्याले अजुन पोऱ्या अनं पोऱ्यी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","आदाम जोडे जोडे नऊशेतीस वरीस जगना, मंग तो मरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","शेथ एकशेपाच वरीसना व्हवावर त्याले अनोश व्हयना; ");
INSERT INTO ahr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","अनोश व्हवावर शेथ आठशेसात वरीस जगना, अनं त्याले अजुन पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","शेथना आयुष्य जोडेजोडे नवशेबारा वरीसना व्हयना; मंग तो मरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","अनोश नव्वद वरीसना व्हयना तवय त्याले केनान व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान व्हवावर अनोश आठशेपंधरा वरीस जगना, अनं त्याले अजुन पोऱ्या अनं पोरी व्हयनात; ");
INSERT INTO ahr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","अनोशना आयुष्य जोडेजोडे नऊशेपाच वरीसना व्हयना; मंग तो मरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","केनान सत्तर वरीसना व्हवावर त्याले महललेल व्हयना; ");
INSERT INTO ahr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","महललेल व्हवावर केनान आठशेचाळीस वरीस जगना, अनं त्याले अजुन पोऱ्या अनं पोरी व्हयन्यात; ");
INSERT INTO ahr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","केनान जोडेजोडे नऊशेदहा वरीसना व्हयना; मंग तो मरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","महललेल पासष्ट वरीसना व्हवावर त्याले यारेद व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","यारेद व्हवावर महललेल आठशेतीस वरीस जगना, अनं त्याले अजुन पोऱ्या अनं पोरी व्हयनात; ");
INSERT INTO ahr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","महललेल याना आयुष्य जोडेजोडे आठशेपंचाण्णव वरीसना व्हयनात, मंग तो मरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","यारेद एकशेबासष्ट वरीसना व्हवावर त्याले हनोख व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोख व्हवावर यारेद आठशे वरीस जगना, अनं त्याले अजुन पोऱ्या अनं पोरी व्हयनात; ");
INSERT INTO ahr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","यारेदना जोडेजोडे नऊशेबासष्ट वरीसना व्हयनात, मंग तो मरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","हनोख पासष्ट वरीसना व्हवावर त्याले मथुशलह व्हयना; ");
INSERT INTO ahr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मथुशलह व्हवावर हनोख तीनशे वरीस देवनासोबत चालना, अनं त्याले अजुन पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","हनोखना आयुष्य जोडेजोडे तीनशेपासष्ट वरीसना व्हयनात; ");
INSERT INTO ahr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोख देवनासोबत चालना, त्यानानंतर तो जगमा नव्हता, कारण देव त्याले ली गया. ");
INSERT INTO ahr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","मथुशलह एकशेसत्याऐंशी वरीसना व्हवावर त्याले लामेख व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लामेख व्हवावर मथुशलह सातशेब्यायशी वरीस जगना, त्याले अजुन पोऱ्या अनं पोरी व्हयनात; ");
INSERT INTO ahr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","मथुशलहना आयुष्य जोडेजोडे नऊशेएकुणसत्तर वरीसना व्हयनात, मंग तो मरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","लामेख एकशेब्यायशी वरीसना व्हवावर त्याले पोऱ्या व्हयना; ");
INSERT INTO ahr_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","त्याना नाव त्यानी नोहा अश ठेवात, तो बोलना, जी भुमी परमेश्वरनी शाप ठराई तिनासंबधना आमनं काम अनं आमनं हातनं कष्ट याविषयी हाऊ आमनं सांत्वन करी. ");
INSERT INTO ahr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नोहा व्हवावर लामेख पाचशे पंचाण्णव वरीस जगना; अनं त्याले अजुन पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","लामेखना आयुष्य जोडेजोडे सातशेसत्ताहत्तर वरीसना व्हयनात; मंग तो मरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","नोहा पाचशे वरीसना व्हयना तवय त्याले शेम, हाम, अनं याफेथ ह्या पोऱ्या व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","नंतर पृथ्वीवर मानवनी वाढ व्हवाले लागनी अनी त्यासले पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","तवय मानव पोरी देखन्या शेतस अश देवपुत्रसनी दखं, अनं त्यासमाईन त्यासले ज्या पटन्यात त्या त्यासनी बायका कऱ्यात. ");
INSERT INTO ahr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","तवय परमेश्वर देव बोलना, मनुष्य भ्रांत व्हवामुये मना आत्मानी त्यानाठायी सर्वकाळ सत्ता रावावु नही; तो शरीरधारी शे, पण त्याले मी एकशेवीस वरीसना काळ दिसु. ");
INSERT INTO ahr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","त्या काळले पृथ्वीवर महाकाय व्हतात, पुढे देवपुत्र मानव पोरीसना जोडे गयात तवय त्यासले पोऱ्या व्हयनात, त्या प्राचीन काळना वीर अनं नावाजेल पुरूष व्हई गयात. ");
INSERT INTO ahr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","पृथ्वीवर मानवनी दुष्टाई खुप शे, त्यासन्या मनमाधल्या येनाऱ्या सगळ्या कल्पना मात्र एकसारख्या वाईट शेतस अश परमेश्वर देवनी दखं. ");
INSERT INTO ahr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","म्हणीन मानवले पृथ्वीवर बनाडाबद्दल परमेश्वरले अनुताप व्हयना, अनी त्याना चित्तले खेद व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","तवय परमेश्वर बोलना, \"मी बनाडेल मानवले पृथ्वीवरीन नष्ट करसु; मानव, पशु, रांगनारा प्राणी, आकाशमाधला पक्षी ह्या सगया नष्ट करसु, कारण त्यासले बनाडाना माले अनुताप व्हई राहिना शे.\" ");
INSERT INTO ahr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","पण नोहावर परमेश्वर देवनी कृपादृष्टी व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नोहानी वंशावळी याप्रकारे नोहा हाऊ आपला काळना लोकसमा नितीमान अनं सात्विक मनुष्य व्हता; नोहा देवनासोबत चाले. ");
INSERT INTO ahr_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","नोहाले शेम, हाम, अनं याफेथ अश तीन पोऱ्या व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","त्या काळले देवना नजरमा पृथ्वी भ्रष्ट व्हयेल व्हती; ती जासजुलुमघाई भरेल व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","देवनी पृथ्वीकडे दखा, तवय ती भ्रष्ट व्हई जायेल व्हती, कारण पृथ्वीवरला सगया प्राणीसनी आपलं चालचलणूक बिघाडी लेयल व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","मंग देव नोहाले बोलना, सर्वा प्राणीसना नष्ट कराना विचार मना मनमा येल शे, कारण त्यासनामुये पृथ्वीवर जाचजुलुम व्हई राहिना शे, दख, मी पृथ्वीनासंगे त्यासना नाश करसु. ");
INSERT INTO ahr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","तु आपलाकरता गोफेर लाकुडना तारू कर; त्या तारूमा खोल्या बनाड्यात अनी त्यासले मजारतीन अनं बाहेरतीन डांबर लावं. ");
INSERT INTO ahr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","तारूले या प्रकारेतीन बनाड, त्यानी लांबी तीनशे हात, रूंदी पन्नास हात, अनं उंची तीस हात अश कर. ");
INSERT INTO ahr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","तारूले उजेडकरता खिडकी बनाड, तिना माथा वरपाईन एक हात राही अश ती कर; तारूना एक बाजुले दार ठेव; त्याले खालना, दुसरा अनं तिसरा अश ताल बनाड. ");
INSERT INTO ahr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","दख, ज्यासनामा प्राण शे, अश सर्वा देहधारी आकाशना खालतीन नष्ट कराना म्हणीसन मी पृथ्वीवर जलप्रलयना पाणी लवसु; पृथ्वीवर जे काही शे ते नष्ट व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","तरी पण मी तुनासंगे आपला करार स्थापन करस; तु आपला पोऱ्या, आपली बायको, अनं आपल्या सुना यासले लिसन तारूमा जा. ");
INSERT INTO ahr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","सर्वा प्राणीसना जातीमाईन नर अनं मादी अश दोन दोननी जोडी जिवत ऱ्हावाकरता आपलासंगे तारूमा ली जाय. ");
INSERT INTO ahr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","पक्षीसना प्रत्येक जातीमाईन, पशुसना प्रत्येक जातीमाईन अनी जमीनवर रांगनारा प्राणीसना प्रत्येक जातीमाईन दोनदोन जिवत रावाकरता तुनाकडे येतीन. ");
INSERT INTO ahr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","खावामा येस ते सर्वा प्रकारना अन्न आपलाजोडे आणीसन त्याना साठा कर; ते तुले अनं त्यासले खावाले भेटी. ");
INSERT INTO ahr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","नोहानी तशच करं; जश देवनी त्याले जे काही सांगेल व्हतं ते त्यानी करं. ");
INSERT INTO ahr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","मंग परमेश्वरनी नोहाले सांगं, \"तु आपला सर्वा कुटुंबनासंगे तारूमा जाय; कारण मी दखेल शे की, हाई पिढीमा तुच मनासमोर नितीमान शे. ");
INSERT INTO ahr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","सर्वा शुध्द पशुमातीन नरमादी सात सात अनी अशुध्द पशुपाईन दोन दोन संगे ले ");
INSERT INTO ahr_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","अनी आकाशमाधला पक्षीमातीन नरमादी सात सात संगे ले; म्हणजेच त्यानामुये पृथ्वीवर त्यासनं जाती टिकी राही. ");
INSERT INTO ahr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","अजुन सात दिनना अवकाश शे; मंग मी पृथ्वीवर चाळीस दिन अनं चाळीस रात पाणी पाडसु, अनी मी बनाडेल जमीनवरनं सर्वकाही नष्ट करसु.\" ");
INSERT INTO ahr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","तवय नोहानी परमेश्वरनी सांगेल प्रमाणे सर्वकाही करं. ");
INSERT INTO ahr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","पृथ्वीवर जलप्रलय व्हयना त्या येळले नोहा सहाशे वरीसना व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","काईननं वंशजहाऊ जलप्रलय जोडे वना म्हणीसन नोहा त्याना पोऱ्या, बायको अनं सुनासले लिसन तारूमा गया. ");
INSERT INTO ahr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","शुध्द अनं अशुध्द पशुपक्षी अनं जमीनवर रांगनारा सर्वा प्राणी यासमाईन, ");
INSERT INTO ahr_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","नर अनं मादी अश जोडीजोडीतीन, देवनी नोहाले आज्ञा करेल प्रमाणे त्या तारूमा त्यानाकडे गयात. ");
INSERT INTO ahr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","सात दिननंतर प्रलयनं पाणी पृथ्वीवर वनं. ");
INSERT INTO ahr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","नोहा सहाशे वयना व्हता तवय दुसरा महिनाना सतरावा दिनले महाजलाशयना सर्वा झरा फुटनात अनी आकाशना दार उघडी गयात. ");
INSERT INTO ahr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","चाळीस दिन अनं चाळीस रात पाऊसनी झडी लाई. ");
INSERT INTO ahr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","याच दिनले नोहा, अनी त्याना पोऱ्या शेम, हाम, अनं याफेथ, त्यासनासोबत नोहानी बायको अनं त्याना तिनी सुना बी तारूमा गयात. ");
INSERT INTO ahr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","त्या सगया अनी प्रत्येक जातीना वनपशु, प्रत्येक जातीना ग्रामपशु, प्रत्येक जातीना रांगनारा प्राणी अनं प्रत्येक जातीना उडनारा पक्षी अनी सर्व जातीना पक्षी बी तारूमा गयात. ");
INSERT INTO ahr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","सर्वा देहधारी प्राणीस पाईन एक एक नोहाना जोडे तारूमा गयात. ");
INSERT INTO ahr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","देवनी नोहाले आज्ञा करेल प्रमाणे सर्वा देहधारी प्राणीसमातीन एक एक नरमादी तारूमा गयात; मंग परमेश्वरनी तारूनं दार बंद करं. ");
INSERT INTO ahr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","पृथ्वीवर जलप्रलय चाळीस दिन अनं चाळीस रात चालना, अनी पाणी वाढामुये तारू जमीन सोडीसन पाणीवर तरंगु लागना. ");
INSERT INTO ahr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","जलप्रलय व्हईसन पृथ्वीवर पाणी भलतच वाढनं अनी तारू पाणीना वरला भागवर तरंगत चालत राहिनं. ");
INSERT INTO ahr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","पृथ्वीवर पाणीना भलताच जोर व्हयना अनं त्यानामुये आकाशखालना सर्वा उचा डोंगरं बुडनात. ");
INSERT INTO ahr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","जलप्रलयना पाणी त्यासनावर पंधरा हात चढना; याप्रमानी सर्वा डोंगरं झाकाई गयात. ");
INSERT INTO ahr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","तवय पृथ्वीवर जिवत राहनारा सर्वा प्राणी म्हणजे पक्षी, ग्रामपशु, वनपशु, पृथ्वीवर गजबजून राहनारा सर्वा जिव जंतु अनं सर्वा मानव मरण पावनात. ");
INSERT INTO ahr_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ज्यासना नाकमा जिवनना श्वास व्हता त्या सर्वा कोरडा जमीनवरला जलप्रलयमा सापडीसन मरी गयात. ");
INSERT INTO ahr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","पृथ्वीवर राहनारा सर्वा काही म्हणजे मानव, पशु, रांगनारा प्राणी अनं आकाशमाधला पक्षी या सर्वासना देवनी नाश करा, त्या सर्वा पृथ्वीवरीन नष्ट व्हयनात; नोहा अनं त्यानासोबत ज्या व्हतात तेवढाच मात्र वाचनात. ");
INSERT INTO ahr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","दिडशे दिनपावत जलप्रलयनं पाणी पृथ्वीवर राहिनं. ");
INSERT INTO ahr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","मंग परमेश्वरनी देवनी नोहा अनं तारूमा त्यानासोबत ज्या वनपशु अनी ग्रामपशु व्हतात या बठासनी आठवन करी. देवनी पृथ्वीवर वारा सोडा, तवय पाणी ओसरू लागनं. ");
INSERT INTO ahr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","जलप्रलयना झरा अनी आकाशना दारे बंद व्हयनात अनी आकाशमाईन पाऊसनी झडी थांबनी. ");
INSERT INTO ahr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","पृथ्वीवरना पाणी एकसारखा थांबत गया, दिडशे दिन सरावर पाणी ओसरत गया. ");
INSERT INTO ahr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","सातवा महिनाना सतरावा दिनले अरारात डोंगरवर तारू टेकायनं. ");
INSERT INTO ahr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","दहावा महिनापावत पाणी एकसारखं ओसरी ऱ्हाईंत; अनं दहावा महिनाना पहिला दिनले डोंगरना माथा दखावु लागना. ");
INSERT INTO ahr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","याले चाळीस दिन लोटावर नोहानी तारूले जी खिडकी करेल व्हती ती त्यानी उघाडी. ");
INSERT INTO ahr_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","अनी त्यानी एक कावळा बाहेर सोडं; तो पृथ्वीवरना पाणी सुकास तोपावत इकडे तिकडे फिरत राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","मंग त्यानी जमिन वरनं पाणी आटनं की नही हाई दखाकरता त्यानी एक कबुतर बाहेर सोडं; ");
INSERT INTO ahr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","त्या कबुतरले पाय टेकाले कोठेच आधार भेटना नही म्हणीन ते त्यानाकडे तारूनाजोडे परत वनं; कारण सर्वीच पृथ्वीना पाठवर अजुन बी पाणी व्हतं; तवय नोहानी आपला हात बाहेर काढीसन त्याले धरीसन आपलाजोडे तारूमा लिधं. ");
INSERT INTO ahr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","त्यानी अजुन सात दिन वाट दखीसन त्या कबुतरले तारूमाईन परत बाहेर सोडा; ");
INSERT INTO ahr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","संध्याकाळले ते कबुतर त्यानाकडे परत वनं, ते त्याना चोचमा जैतुन झाडना नुकताच फुटेल पान शे अश त्याले दखायनं, नोहाले त्यावरीन समजनं की, पृथ्वीवरलं पाणी आते आटी जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","त्यानी अजुन सात दिन थांबीसन त्या कबुतरले परत सोडं; तवय ते त्यानाकडे परत फिरीन वनं नही. ");
INSERT INTO ahr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नोहाना सहाशेएक वरीसना पहिला महिनाना पहिला दिनले पृथ्वीवरलं पाणी सुकी गयं तवय नोहानी तारूनं छप्पर काढीसन दखं ते, पृथ्वीना जमिनना भाग सुकी जायेल शे, अश त्याले दिसनं. ");
INSERT INTO ahr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","दुसरा महिनाना सत्ताविसावा दिनले जमीन खडखडीत वाळनी. ");
INSERT INTO ahr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","मंग परमेश्वर देव नोहाले बोलना, ");
INSERT INTO ahr_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","\"तु तुनी बायको, पोऱ्या अनं सुना यासले लिसन तारूमाईन बाहेर निंघ. ");
INSERT INTO ahr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","पक्षी, पशु अनं भुमीवर रांगनारा सर्वा यासनापाईन ज्या प्राणी तुनासोबत शेतस, त्या सर्वासले बाहेर आणं, म्हणजे पृथ्वीवर त्यासनी संतति विपुल व्हई ते फलद्रूप व्हईसन पृथ्वीवर बहुगुणित व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","तवय नोहा त्यानी बायको, पोऱ्या अनं सुना यासले लिसन बाहेर निंघना. ");
INSERT INTO ahr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","प्रत्येक पशु, प्रत्येक रांगनारा प्राणी, प्रत्येक पक्षी अश पृथ्वीवर संचार करनारा प्राणी जातप्रमाणे तारूमाईन बाहेर निंघनात. ");
INSERT INTO ahr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","नंतर नोहानी परमेश्वरकरता एक वेदी बांधी अनी सर्वा शुध्द पशु अनं सर्वा शुध्द पक्षी यासमाईन काही लिसन त्या वेदीवर त्यासनं होमार्पण करं. ");
INSERT INTO ahr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","परमेश्वर त्या वेदीवरना सुवास लिसन आपला मनमा बोलना, मानवमुये मी आठेनपुढे भुमीले कधीच शाप देवाव नही; कारण मानवना मनमाधल्या कल्पना जन्मपाईनच दुष्ट ऱ्हातस; तर मी आत्ताना सारखा परत सर्वा जिवसना नाश करावु नही. ");
INSERT INTO ahr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","पृथ्वी राही तोपावत पेरणी अनं कापणी, थंडी अनं ऊन, उन्हाळा अनं हिवाळा, दिन अनं रात हाई व्हवाशिवाय ऱ्हावावुत नही. ");
INSERT INTO ahr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","मंग देव नोहा अनं त्याना पोऱ्यासले आशिर्वाद दिसन बोलना, \"फलद्रूप व्हा, बहुगुणित व्हा अनी पृथ्वी व्यापी टाका. ");
INSERT INTO ahr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","पृथ्वीवरना सर्व पशु, आकाशमाधला सर्व पक्षी, भुमीवर रांगनारा सर्व प्राणी अनं समुद्रामाधला सर्व मासा यासले तुमना भय अनं धाक राही; त्या तुमना स्वाधीन करेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","सर्व संचार करनारा प्राणी तुमना अन्न व्हतीन; जसं तुमले हिरवा वनस्पती देयल शेतस त्यानाप्रमाणे सर्व काही आते तुमले देस. ");
INSERT INTO ahr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","पण मासना जिवन रक्त शे, म्हणीन रक्तनासंगे मास खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","मी नक्कीच तुमनं रक्त म्हणजे तुमना जीवना हिसाब लिसु; सर्व पशु अनं मनुष्य दोन्हीसघाई हिसाब लिसु, मनुष्यना प्राणना बदला प्रत्येक कडतीन लिसु. ");
INSERT INTO ahr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","जो कोणी मनुष्यना रक्तपात करी तेना रक्तपात मनुष्यकडीन व्हई; कारण देवनी मनुष्यले आपला प्रतिरूपमा बनाडेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","तुम्हीन फलद्रूप व्हा, बहुगुणित व्हा, पृथ्वीवर विपुल वंशवृध्दी करा, तिनावर बहुगुणित व्हा.\" ");
INSERT INTO ahr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","देव नोहाले अनं त्यानासोबत त्याना पोऱ्यासले बोलना, ");
INSERT INTO ahr_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","\"मी तुमनासंगे अनं तुमनानंतर तुमना संतानना संगे करार करी ठेवस. ");
INSERT INTO ahr_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","त्यानाप्रमाणे तुमनासोबत ज्या सजीव प्राणी शेतस, म्हणजे तुमनासोबत तारूमाईन बाहेर येल पक्षी, ग्रामपशु अनं पृथ्वीवरना बाकी सर्वा प्राणी यासनासंगे बी मी करार करी ठेवस. ");
INSERT INTO ahr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","तुमनासंगे हाऊ करार करी ठेवस की, परत जलप्रलमा जीव नाश व्हवावुत नही, अनी पृथ्वीना नाश करनारा जलप्रलय परत कधीच व्हवावु नही. ");
INSERT INTO ahr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","देव बोलना, मनामा अनी तुमनामा त्यानाप्रमाणे तुमनासंगे राहेल सर्वा सजीव प्राणीसमा पिढ्यानपिढा, युगानुयुग राहनारा जो करार मी करी ऱ्हायनु शे त्यानं हाई चिन्ह शे. ");
INSERT INTO ahr_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","मी ढगमा धनुष्य ठेयल शे, तो पृथ्वीना अनं मनासोबत व्हयेल करारना चिन्ह राही. ");
INSERT INTO ahr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","मी पृथ्वीना वर ढग पसारसु तवय त्यामा मेघधनुष्य दखाई, ");
INSERT INTO ahr_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","तवय मनामा अनी तुमनामा अनं सर्वा देहधारी सजीव प्राणी यासनामा व्हयेल करार मी आठवसु, अनी यानापुढे सर्वा देहधारीसना नाश व्हई अशा जलप्रलय व्हवावु नही. ");
INSERT INTO ahr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","धनुष्य ढगमा दखाई ते दखीसन मनामा अनी पृथ्वीवरना सर्वा सजीव प्राणीसमा व्हयेल युगानुयुग करेल करारनी माले आठवन राही. ");
INSERT INTO ahr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","देव नोहाले बोलना, मनामा अनं पृथ्वीना सर्वा प्राणी यासनामा जो करार मी करी ठेयेल शे त्यानं हाई चिन्ह शे.\" ");
INSERT INTO ahr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नोहाना पोऱ्या तारूमाईन बाहेर निंघनात त्यासना नावे शेम, हाम अनं याफेथ अश व्हतात; हाम हाऊ कनानना बाप व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ह्या तीन नोहाना पोऱ्या; यासनापाईन पृथ्वीमा लोकसना विस्तार व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नोहा जो शेतकरी व्हता, तो पहिला माणुस व्हयना ज्यानी द्राक्षमळा लावा. ");
INSERT INTO ahr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","तो द्राक्षरस पिसन मस्त व्हयना अनी आपला तंबुमा उघडानागडा व्हईसन पडना. ");
INSERT INTO ahr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","तवय कनानना बाप हाम यानी आपला बापले उघडा नंगा दखीसन आपला दोन्ही भाऊ ज्या बाहेर व्हतात त्यासले हाई सांगं. ");
INSERT INTO ahr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","तवय शेम अनं याफेथ यासनी कपडा आपला खांदावर लिसन अनं पाठमोरा व्हईसन आपला बापनी नग्नता झाकी; त्यासना तोंड पाठमोरा व्हतात म्हणीन आपला बापनी नग्नता त्यासले दिसनी नही. ");
INSERT INTO ahr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","द्राक्षरसना गुंगीमाईन सावुध व्हवावर आपला धाकला पोऱ्यानी काय करं हाई नोहाले समजनं. ");
INSERT INTO ahr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","तो बोलना, कनान शापित व्हई, तो आपला भाऊसना दाससना दास व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","तो बोलना, शेमाचा देव यहोवा धन्य! कनान त्याना दास व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","देव याफेथना विस्तार करी; तो शेमना तंबुमा राही; अनी कनान त्याना दास व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","नोहा जलप्रलय व्हवानंतर तिनशेपन्नास वरीस जगना. ");
INSERT INTO ahr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","नोहा जोडेजोडे नऊशेपन्नास वरीस जगना, मंग तो मरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नोहाना पोऱ्या शेम हाम अनं याफेथ यासनी वंशावळी हाईप्रमाणे: जलप्रलय व्हवानंतर त्यासले पोऱ्या व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","याफेथना पोऱ्या गोमार, मागोग, मादय, यावान, तुबाल, मेशेख अनं तीरास. ");
INSERT INTO ahr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमारना पोऱ्या आष्कनाज, रीपाथ अनं तोगार्मा. ");
INSERT INTO ahr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","यावानना पोऱ्या अलीशा, तार्शीश, कित्तीम, अनं दोदानीम. ");
INSERT INTO ahr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","यासनी समुद्रकाठनाजोडे भाषा, कुळ अनं राष्ट्रे त्यानाप्रमाणे येगयेगळा देश उभारनात. ");
INSERT INTO ahr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हामना पोऱ्या कुश, मिस्त्राईम, पुट अनं कनान. ");
INSERT INTO ahr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कुशना पोऱ्या सबा, हवीला, साब्ता, रामा अनं साब्तका; अनी रामना पोऱ्या शबा अनं ददान. ");
INSERT INTO ahr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कुशले निम्रोद व्हयना. तो पृथ्वीवर पहिला वीर व्हयी गया. ");
INSERT INTO ahr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","तो परमेश्वरना समोर ताकदवान शिकारी व्हयना, म्हणीसन तो निम्रोदसारखा परमेश्वरना समोर ताकदवान शिकारी अश बोलानं प्रघात शे. ");
INSERT INTO ahr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","शिनार देशमा बाबेल, एरक, अक्काद, अनं कालने हाई त्याना राज्यनी सुरवात शे. ");
INSERT INTO ahr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","त्या देशमाईन तो पुढे अशशुरमा गया अनं त्यानी निनवे, रहोबोथ ईर अनं कालह हाई उभारं. ");
INSERT INTO ahr_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","तसंच निनवे अनं कालह यासना दरमान त्यानी रेसन शहर उभारं हाईच ते मोठं शहर शे. ");
INSERT INTO ahr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिस्त्राईम याले लूदीम, अनामीम, लहाबीम, नाप्तुहीम, ");
INSERT INTO ahr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","पात्रुसीम, कास्लूहीम, (याजपाईन पलिष्टी व्हयनात) अनं कफतोरी ह्या व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान याले सीदोन हाऊ पहिला पोऱ्या व्हयना अनी हेथ, ");
INSERT INTO ahr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","यबूसी, अमोरी, गिर्गाशी, ");
INSERT INTO ahr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्वी, आर्की, शीनी. ");
INSERT INTO ahr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वादी, समारी अनं हमाथी ह्या व्हयनात; पुढं कनानी कुळना विस्तार व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","कनानी रहिवासीसनी सीमा सीदोनवरीन गरारले जावानी वाटवरना गज्जापावत अनी सदोम, गमोरा, आदमा अनं सबोईम याकडे जानारी वाटवर लेशापावत व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","कुळ, भाषा, देश अनं राष्ट्र यावरीन सांगेल हामानी संतती शे. ");
INSERT INTO ahr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","शेम हाऊ सर्वा एबर वंशना पूर्वज अनं याफेथना मोठा भाऊ व्हता, याले बी संतती व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेमना पोऱ्या एलाम, अश्शूर, अर्पक्षद, लूद अनं अराम. ");
INSERT INTO ahr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अरामना पोऱ्या ऊस, हूल, गेतेर अनं मश. ");
INSERT INTO ahr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अर्पक्षदले शेलह व्हयना, अनं शेलहले एबर व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एबरले दोन पोऱ्या व्हयनात, एकना नाव पेलेग व्हतं, कारण त्याना येळले पृथ्वीनी वाटनी व्हयनी, त्याना भाऊना नाव यक्तान व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","यक्तानले अलमोदाद, शेलेफ, हसर्मावेथ, येरह. ");
INSERT INTO ahr_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोराम, ऊजाल, दिक्ला. ");
INSERT INTO ahr_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमाएल, शबा. ");
INSERT INTO ahr_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओफीर, हवीला, अनं योबाब, अश पोऱ्या व्हयनात, ह्या सर्वा यक्तानना पोऱ्या व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","त्यासनी वस्ती मेशापाईन पुर्वकडना डोंगर सफार याकडे जावानी वाटवर व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","कुळ, भाषा, देश, अनं राष्ट्र यावरीन हाई शेमानी संतती शे. ");
INSERT INTO ahr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","पिढ्या अनं राष्ट्र यावरीन हाई नोहाना वंशजसना कुळ सांगेल शेतस; जलप्रलयना नंतर त्यासना पृथ्वीवर येगयेगळा राष्ट्र व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","सर्व पृथ्वीनी पहिले एकच भाषा, अनी एकच बोली व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","पुढे अश व्हयनं की, पुर्वले जाता जाता त्या लोकसले शिनार देशमा एक मैदान लागनं, तठे त्यासनी वस्ती करी. ");
INSERT INTO ahr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","त्या एकमेकसले सांगु लागनात, चला आपण ईटा बनाडीसन पक्या भाजुत, त्यासनी दगडना बदलामा ईटा अनी चुनाना बदलामा मातीना गारा वापरात. ");
INSERT INTO ahr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","मंग त्या बोलनात, चला, आपलाकरता एक नगर अनी गगनचुंबित शिखरना एक बुरूज बांधुत; अनी आपलं नाव मोठं करूत म्हणजे सर्वा पृथ्वीवर आपण भटकावुत नही. ");
INSERT INTO ahr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","तवय मानवपोऱ्या नगर अनं बुरूज बांधी ऱ्हाईंतात हाई दखाकरता परमेश्वर देव पृथ्वीवर उतरना. ");
INSERT INTO ahr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","परमेश्वर देव बोलना, दखा, या लोके एक शेतच, ह्या सर्वासनी भाषा बी एकच शे, अनं हाई यासनी कामसनी सुरवात शे; अनी ज्या काही पण ह्या बनाडानं योजना करतीन ते कराले यासले काहीच अडथळा येवाव नही. ");
INSERT INTO ahr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","तर चला, आपण खाल उतरीसन यासन्या भाषाना घोटाळा करू म्हणजे यासले एकमेकसनी भाषा समजावू नही. ");
INSERT INTO ahr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","नंतर परमेश्वरनी तठेन त्यासले सर्वा पृथ्वीवर भटकाडी दिधं; म्हणीसन त्यासनं नगर बांधानं राही गयं. ");
INSERT INTO ahr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","म्हणीन त्या नगरनं नाव बाबेल अश पडनं, कारण त्या ठिकानमा परमेश्वरनी सगया पृथ्वीना भाषाना घोटाळा करा अनी तठेन त्यासले सर्वा पृथ्वीवर भटकाले लाये दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेमनी वंशावळी ह्याप्रमाणे शेम शंभर वरीसना व्हवावर जलप्रलयना नंतर दोन वरीसमा त्याले अर्पक्षद व्हयना; ");
INSERT INTO ahr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","अर्पक्षद व्हवावर शेम पाचशे वरीस जगना. अनी त्याले पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","अर्पक्षद पस्तीस वरीसना व्हवावर त्याले शेलह व्हयना; ");
INSERT INTO ahr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","शेलह व्हवावर अर्पक्षद चारशेतीन वरीस जगना, अनी त्याले पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","शेलह तीस वरीसना व्हवावर त्याले एबर व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","एबर व्हवावर शेलह चारशेतीन वरीस जगना, अनी त्याले पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","एबर चौतीस वरीसना व्हवावर त्याले पेलेग व्हयना; ");
INSERT INTO ahr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","पेलेग व्हवावर एबर चारशेतीस वरीस जगना, अनी त्याले पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","पेलेग तीस वरीसना व्हवावर त्याले रऊ व्हयना; ");
INSERT INTO ahr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","रऊ व्हवावर पेलेग दोनशेनऊ वरीस जगना; अनी त्याले पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","रऊ बत्तीस वरीसना व्हवावर त्याले सरूग व्हयना; ");
INSERT INTO ahr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","सरूग व्हवावर रऊ दोनशेसात वरीस जगना, अनी त्याले पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","सरूग तीस वरीसना व्हवावर त्याले नाहोर व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","नाहोर व्हवावर सरूग दोनशे वरीस जगना; अनी त्याले पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","नाहोर एकुणतीस वरीसना व्हवावर त्याले तेरह व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","तेरह व्हवावर नाहोर एकशेएकोणीस वरीस जगना, अनी त्याले पोऱ्या अनं पोरी व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","तेरह सत्तर वरीसना व्हवावर त्याले अब्राम, नाहोर अनं हारान ह्या पोऱ्या व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरहनी वंशावळी ह्याप्रमाणे तेरहले अब्राम, नाहोर अनं हारान ह्या व्हयनात, अनं हारानले लोट व्हयना, ");
INSERT INTO ahr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हारान त्याना बाप तेरह यानादेखत आपली जन्मभूमी खास्दीसना ऊर आठे मरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम अनं नाहोर यासनी बायका कऱ्यात; अब्रामनी बायकोना नाव सारा अनी नाहोरनी बायकोना नाव मिल्का; मिल्का हाई हाराननी पोर; हाऊ हारान मिल्का अनं इस्का यासना बाप व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","सारा हाई वांझ व्हती, तिले पोऱ्यासोऱ्या नव्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","मंग तेरह त्याना पोऱ्या अब्राम, अनं त्याना नातू म्हणजे हारानना पोऱ्या लोट अनी त्यानी सून म्हणजे त्याना पोऱ्या अब्राम यानी बायको सारा, यासले लिसन खास्दीसना ऊर नगर आठेन कनान देशमा जावाले निंघना; पण त्या हारान आठे जाईसन तठेच राहावाले लागनात. ");
INSERT INTO ahr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तेरहना वय दोनशेपाच वरीस व्हईसन तो हारान आठे मरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","तवय परमेश्वरनी अब्रामले सांगं, तू आपला देश, आपला नातेवाईक, अनं आपला बापना घर सोडीसन मी दखाडसू त्या देशमा जाय. ");
INSERT INTO ahr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","मी तुनापाईन मोठं राष्ट्र बनाडसू, मी तुले आशिर्वाद दिसु, तुना नाव मोठं करसु; तू आशिर्वादीत व्हशी. ");
INSERT INTO ahr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","जो तुले आशिर्वाद दी, त्यासले मी आशिर्वाद दिसु, तशच जो तुले शाप दी, त्यासले मी शाप दिसु, तुनाद्वारा पृथ्वीवरना सर्वा कुळं आशिर्वादीत व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","परमेश्वरनी हाई आज्ञा देयल प्रमाणे अब्राम निंघी गया, अनं लोट बी त्यानासोबत गया; हारान आठेन निंघाना येळले अब्रामना वय पंचाहत्तर वरीसना व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्राम आपली बायको सारा अनं त्याना पुतण्या लोट, आपली सर्वी धनसंपत्ती जी त्यानी गोळा करेल व्हती, अनी हारान आठे त्यानी मियाडेल माणसं बी लिसन अब्राम कनान देशमा जावाले निंघना. असा प्रकारे कनान देशमा त्या जाईसन पोहचनात. ");
INSERT INTO ahr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","अब्राम त्या देशमाईन शखेमना प्रदेशना पवित्र जागावर म्हणजे मोरे आठे पवित्र झाडनाजोडे जाईसन पोहचना, त्या काळले त्या देशमा कनानी लोके राही राहिंतात. ");
INSERT INTO ahr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","परमेश्वर अब्रामले आशिर्वाद दिसन बोलना, हाऊ देश मी तुना संतानले दिसु; परमेश्वरनी त्याले दर्शन दिधं म्हणीन त्यानी तठे परमेश्वरनी एक वेदी बांधी. ");
INSERT INTO ahr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","मंग तो तठेन निंघना अनी बाबेलना पुर्वले डोंगर व्हता तठे जाईसन त्यानी तंबू उभा करं, त्याना पश्चिमले बेथेल शहर व्हतं अनं पुर्वले आय शहर व्हतं; तठे त्यानी परमेश्वरनी वेदी बांधी अनी परमेश्वरनी नावनी आराधना करी. ");
INSERT INTO ahr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","तठेन निंघीसन अब्राम प्रवास करीसन कनान देशना दक्षिणकडे गया. ");
INSERT INTO ahr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","त्या येळले देशमा दुष्काळ पडेल व्हता; त्यामुये काही दिन मिसरमा जाईसन रावानं म्हणीन अब्राम तिकडे निंघी गया, कारण त्या देशमा दुष्काळ खुपच भयानक व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","मंग अश व्हयना की, तो मिसरमा प्रवेश करनारच तोच त्यानी बायको साराले बोलना, दख, तू दिसाले सुंदर बाई शे हाई माले माहित शे. ");
INSERT INTO ahr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","तुले मिसरी गावना लोके दखतीन तवय हाई यानी बायको शे अस म्हणतीन, अनी माले मारी टाकतीन अनं तुले जिवत ठेवतीन. ");
INSERT INTO ahr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","यामुये कृपा करीसन त्यासले हाई सांग, मी यानी बहीण शे, म्हणजे तुनामुये मनं भलं व्हई, अनी तुनामुये मना जीव वाची. ");
INSERT INTO ahr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","मंग अब्राम मिसर देशमा जाईन पोहचना, तवय ती बाई भलती सुंदर शे अश मिसर देशना लोकसनी दखं. ");
INSERT INTO ahr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","फारोना सरदारसनी तिले दखीसन फारोनाजोडे तिनी प्रशंसा करी अनी तिले त्याना घर आनीसन ठि दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","तिनामुये फारोनी अब्रामनं भलं करं, अनी त्याले मेंढरं, बैल, गाढव, दास, दासी, गाढवी अनं उंट भेटनात. ");
INSERT INTO ahr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","तरी अब्रामनी बाई सारा हिना कारण परमेश्वरनी फारोले अनं त्याना घरनासले भयानक पीडा भोगाले लायं. ");
INSERT INTO ahr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","तवय फारोनी अब्रामले बलाईसन सांगं, \"तू मनासंगे हाई काय करं? हाई ते तुनी बायको शे, तू माले हाई काबंर नही सांग? ");
INSERT INTO ahr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ती तुनी बहीण शे अस तु माले काबंर सांगं? मी तिले आपली बायको कराकरता मनाकडे ठेयल व्हतं; तर आते दख हाई तुनी बायको शे, हिले लई जाय. ");
INSERT INTO ahr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","तवय फारोनी आपला दाससले त्यानाविषयी हुकूम करा; अनी त्यानी बायको अनं त्यानं जे काही व्हतं त्यासनासंगे त्याले वाट लायं. ");
INSERT INTO ahr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","तवय अब्राम आपली बायको, अनी सर्वी मालमत्ता लिसन मिसर देशमाईन निंघीसन दक्षिणकडे गया, अनी लोट बी त्यानासोबत गया. ");
INSERT INTO ahr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम आपला जनावरे अनी सोना अनं चांदी यासमुये खुप धनवान व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","मंग तो प्रवास करत करत नेगेबपाईन बेथेलपावत गया, बेथेल अनं आय यासना मधोमध तो वना. ");
INSERT INTO ahr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","सुरवातले त्यानी जठे वेदी बांधेल व्हती त्याच ठिकाणमा तो वना; तठे त्यानी परमेश्वरनी आराधना करी. ");
INSERT INTO ahr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","आते लोटनाजोडे बी मेंढरं, गुरंढोरं अनं तंबू बी व्हतात, जो अब्रामनासोबत येल व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","त्यासले एकत्र राहावाले तो प्रदेश पुरी नही राहिंता; कारण त्यासनी मालमत्ता एवढी व्हयनी की, त्यासले एक जनावरसले चाराना एक ठिकाणमा सोबत राहता नही ई ऱ्हाईंत. ");
INSERT INTO ahr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","तसच अब्रामना अनं लोटना गुराखीसनी भांडण व्हवाले लागनी; त्या येळले त्या देशमा कनानी अनं परिज्जी यासनी वस्ती व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","तवय अब्राम लोटले बोलना, हाई दख, नही तुनामा अनं मनामा, नही तुना अनं मना गुराखीसमा भांडण व्हवाले नको, कारण आपण भाऊबंद शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","सर्वा देश तुले मोकळा नही शे का? यामुये मनापाईन येगळा व्हई जाय; तू डावीकडे जाशी तर मी उजवीकडे जासु; तू उजवीकडे जाशी तर मी डावीकडे जासु. ");
INSERT INTO ahr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","तवय लोटनी आपली नजर टाकीसन यार्देनना खोरे दखं की ती परमेश्वरना बागनागत सोअरना वाट पावत मिसर देशना भुमीनागत सगयीकडे भरपुर पाणी शे अश त्याले दिसनं त्या येळपावत परमेश्वरनी सदोम अनं गमोराना नाश करेल नव्हता. ");
INSERT INTO ahr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","यामुये हाई यार्देननी सर्वा तळवट लोटनी आपलाकरता पसंद करी लिधा अनी तो पुर्वेकडे प्रवास करू लागना; ह्या प्रमाणे त्या एकमेकसपाईन येगळा व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम कनान देशमा राहिना, अनं लोट तळवटीना नगरसमा राहिना, अनी मुक्काम करत करत त्यानी आपला तंबू सदोमाजोडे उभं करा. ");
INSERT INTO ahr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोमना लोके ते परमेश्वरना नजरमा भलताच दुष्ट अनी महापापी व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","लोट अब्रामपाईन येगळा व्हवावर परमेश्वर अब्रामले बोलना, तू जठे शे तठेन उत्तरकडे, दक्षिणकडे, पुर्वकडे, अनं पश्चिमकडे नजर लाईसन दख. ");
INSERT INTO ahr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","कारण जो हाऊ सर्वा देश तुले दखाई राहिना शे, तो तुले अनं तुना संततीले मी कायमना दिसु. ");
INSERT INTO ahr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","मी तुनी संतती पृथ्वीना धुळना समान वाढावसु; यामुये कोणले पृथ्वीना धुळनी गणना करता वनी तर तुना संततीनी बी गणना व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ऊठ, हाई देशनी लांबी रूंदी फिरीसन दखं, कारण तो मी तुले देणार शे. ");
INSERT INTO ahr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","मंग अब्राम मुक्काम करत करत हेब्रोनजोडे मम्रेना एलोन राईमा ईसन तठे आपला तंबू उभारा; अनी तठे त्यानी परमेश्वरनी एक वेदी बांधी. ");
INSERT INTO ahr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","शिनारना राजा अम्राफेल, एल्लासारना राजा अर्योक, एलामना राजा कदार्लागोमर अनी गोयीमना राजा तिदाल यासना येळले अश व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","त्यासनी सदोमना राजा बेरा, गमोराना राजा बिर्शा, अदमना राजा शिनाब, सबोयिमना राजा शमेबर अनी बेला म्हणजे सोअर याना राजा यासनासंगे युध्द करात. ");
INSERT INTO ahr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ह्या सर्वा एकजूट करीसन सिद्दीम खोरामा गयात; हाई खोरा म्हणजे क्षारसमुद्र शे. ");
INSERT INTO ahr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","त्या कदार्लागोमर यासना बारा वरीसपावोत अधीन व्हतात, पण तेराव्या वरीसले त्या त्यानावर उठनात. ");
INSERT INTO ahr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","चौदाव्या वरीसले कदार्लागोमर अनं त्याना पक्षना राजे यासनी ईसन अष्टरोथ-कर्णईम अठे रेफाई लोकसले, हाम अठे जूजी लोकसले, किर्याथाईमना मैदानमा एमी लोकसले पराजीत करं. ");
INSERT INTO ahr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","अनी होरी लोकसले त्यासन्याच सेईर डोंगरमा मार दिसन एल्-पारानना जोडेना रानपावत हाकली दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","मंग मांगे फिरीसन एन-मिशपात म्हणजे कादेशमा त्या वनात अनं त्यासनी अमालेकी लोकसना सर्वा देश जिकी लिधा अनं हससोन- तामार अठे राहनारा अमोरी लोकसले बी जिकी लिधा. ");
INSERT INTO ahr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","तवय सदोमना राजा, गमोराना राजा, अदमना राजा, सबोयिमना राजा, अनी बेला म्हणजे सोअर याना राजा ह्या त्यानासंगे युध्द कराले निंघनात अनी सिद्दीम खोरामा‍ त्यासनी आपला सैनासनी रचना करी. ");
INSERT INTO ahr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","एलामना राजा कदार्लागोमर, गोयिमना राजा तिदाल, शिनारना राजा अम्राफेल, अनी एल्लासारना राजा अर्योक यासनासंगे त्या युध्द करनात; चार राजासनी पाच राजासनासंगे सामना करात. ");
INSERT INTO ahr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दीम खोरामा डांबरना बऱ्याच खाणी व्हत्यात, सदोम अनं गमोरा यासना राजा पळनात तवय त्या खाणीसमा पडनात अनी बाकीना ज्या वाचनात त्या डोंगरसमा पळत सुटनात. ");
INSERT INTO ahr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","तवय सदोम अनं गमोरा आठली मालमत्ता अनं पुरी अन्न-सामुग्री शत्रु लुटीसन लई गयात. ");
INSERT INTO ahr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","अब्रामना पुतण्या लोट ह्याले पण त्यासनी धरीसन त्यानी बी मालमत्ता लई गयात, कारण तो सदोम आठे राही राहिंता; ");
INSERT INTO ahr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","तवय तठेन पळी येल एक माणुसनी जाईसन अब्राम इब्रीले हाई बातमी सांगी; त्या येळले तो अष्कोल अनं आनेर यासना भाऊ अमोरी मम्रे याना एलोन झाडना जंगलमा राही राहिंता; ह्या अब्रामना संगेना व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","आपला भाऊबंधले धरीसन लई गयात हाई ऐकीसन अब्रामनी आपला घरमा जन्मेल अनं लढाईना काममा तयार करेल असा तीनशेअठरा दास लिसन त्यानी दान शहरपावत शत्रूसना पाठलाग करा. ");
INSERT INTO ahr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","त्यानी आपला दाससन्या टोळ्या करीसन त्यासनावर रातले चाल करी अनी त्यासले मार दिसन दिमिष्कना उत्तरमा होबापावत त्यासना पाठलाग करा. ");
INSERT INTO ahr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","त्यानी सगयी मालमत्ता वापस आणी; तसच आपला भाऊबंध लोट, त्यानी मालमत्ता, बाया अनं लोके यासले सोडाईसन परत लयना. ");
INSERT INTO ahr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","कदार्लागोमर अनी त्यानासोबतना राजा यासले मारीसन तो वापस ई ऱ्हाईंता त्याले भेटाले सदोमना राजा शावेखिंड म्हणजे राजेखिंड आठेपावत वना. ");
INSERT INTO ahr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","अनी शालेमना राजा मलकीसदेक भाकर अनं द्राक्षरस लिसन त्याले भेटाले वना; हाऊ परात्पर देवना याजक व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","त्यानी त्याले हाई आशिर्वाद दिधं आकाशना अनं पृथ्वीना मालक जो परात्पर देव तो अब्रामले आशिर्वाद देवो. ");
INSERT INTO ahr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ज्या परात्पर देवनी तुना शत्रू तुना स्वाधीन करा तो धन्य! तवय अब्रामनी त्याले दहावा हिसा दिधा. ");
INSERT INTO ahr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","मंग सदोमना राजा अब्रामले बोलना, माणसे माले दि टाका अनी मालमत्ता तुमनाकरता ठेई ल्या. ");
INSERT INTO ahr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","पण अब्राम सदोमना राजाले बोलना, मी आकाशना अनं पृथ्वीना जो मालक परात्पर देव यहोवा यानी शपथ लिसन सांगस की, ");
INSERT INTO ahr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","तुमना एक सुतळीना तोडा किंवा वहाणना बंद मी लेवाव नही; मी अब्रामले धनवान बनाडं अश बोलाले तुमले कारण नको भेटाले. ");
INSERT INTO ahr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ह्या माणसंसनी अन्न खादं तेवढं पुरं, मनासंगे येल आनेर, अष्कोल अनं मम्रे यासले वाटा भेटना तेवढच पुरं शे; त्यासले आपला वाटा लेऊ द्या. ");
INSERT INTO ahr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ह्या गोष्टी घडन्यात तवय अब्रामले दृष्टांतमा परमेश्वरनं वचन प्राप्त व्हयनं ते अश अब्राम, भिऊ नको, मी तुनी ढाल शे; तुले मोठा प्रतिफळ भेटी. ");
INSERT INTO ahr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","अब्राम बोलना, हे प्रभु परमेश्वर तू माले काय दिशी? मी तर निसंतान जासु अनी दिमिष्की अलियेजर मना घरना मालक व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","अब्राम परत बोलना, अनी दख, तू माले काही संतान दिधं नही तर मना घरमा जन्मेल दास मना वारीस व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","तवय परमेश्वरनं वचन‍ त्याले प्राप्त व्हयनं की, हा माणुस तुना वारीस व्हवावू नही, तर तुना पोटनाच तुना वारीस व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","मंग त्याले त्यानी बाहेर आणीसन सांगं, आकाशकडे नजर लाव; तुले ह्या तारा मोजता येतीन तर मोज, त्यानी त्याले सांगं तुनी संतती अशीच व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","अब्रामनी परमेश्वरावर ईश्वास करा अनी अब्रामना हाऊ ईश्वास परमेश्वरनी त्याना नितीमान गणात. ");
INSERT INTO ahr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","तो त्याले बोलना, तुले हाऊ देश देवाना म्हणीसन खास्दीसना ऊर गावमाईन ज्यानी तुले आणा तो मीच परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","अब्राम बोलना, प्रभू परमेश्वर, माले हाई आधिकार भेटी हाई कशावरीन? ");
INSERT INTO ahr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","त्यानी त्याले सांगं, मनाकरता तीन वरीसनी कालवड, तीन वरीसनी एक बकरी, तीन वरीसना एक मेंढा, एक होला, अनी कबूतरना एक पिल्ला अश लई ये. ");
INSERT INTO ahr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","त्यानी ती सर्वा लिधात अनं मधोमध चिरीसन त्यासना दोन दोन तुकडा करात अनी प्रत्येकना तुकडा समोरा समोर ठेयात; पक्षीसले मात्र त्यानी मधोमध चिरात नही. ");
INSERT INTO ahr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","त्या तुकडासवर हिंस्त्र पक्षीसनी झडप घाली, पण त्यासले अब्रामनी हाकली दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","सुर्य ढुबाना येळले अब्रामले गाढ झोप लागनी तवय भलतंच भितीनं, काळोख अंधार त्यानावर पडना. ");
INSERT INTO ahr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","परमेश्वर अब्रामले बोलना, तू निश्चितपणी समज की, जो देश स्वत:ना नही अश देशमा तुनी संतान उपरी व्हईसन राही अनं तठला लोकेसना दास व्हतीन, अनी त्या लोके चारशे वरीस त्यासले छळतीन. ");
INSERT INTO ahr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","मंग ज्या राष्ट्रसना दास त्या व्हतीन त्यासना मी नायनाट करीन. त्यानानंतर त्या भरपुर मालमत्ता लिसन तठेन निंघतीन. ");
INSERT INTO ahr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","तू तर शांतीमा आपला पुर्वजसकडे जाशी; चांगला म्हातारा व्हवावर तुले मूठमाती देतीन. ");
INSERT INTO ahr_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","तुना चौथ्या पिढीना लोके इकडे वापस येतीन, कारण अमोरी लोकसना पापना घडा अजुन भरेल नही शे. ");
INSERT INTO ahr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","सुर्य मावळना अनं काळोख अंधार पडना तवय अस व्हयनं की, आगभट्टी अनं जळती मशाल त्या मासना तुकडासमाईन जातांना दखायनी. ");
INSERT INTO ahr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","त्या दिनले परमेश्वरनी अब्रामनासंगे करार करीसन सांगं की, \"मिसरना नदीपाईन ते महानदी फरात आठेपावतना प्रदेश मी तुना संतानले देस. ");
INSERT INTO ahr_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","म्हणजे केनी, कनिज्जी, कदमोनी, ");
INSERT INTO ahr_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्ती, परिज्जी, रफाईम, ");
INSERT INTO ahr_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","अमोरी, कनानी, गिर्गाशी, अनं यबूशी ह्या लोकसना प्रदेश मी तुना वंशले देस.\" ");
INSERT INTO ahr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्रामले आपली बायको सारा हिनापाईन काही पोऱ्यासोऱ्या व्हयेल नव्हतात; पण तिले हागार नावनी एक मिसरी दासी व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","सारा अब्रामले बोलनी, \"परमेश्वरनी माले पोऱ्या व्हवापाईन वंचित ठेयेल शे; तर मनी दासीना जोडे जाय; कदाचित तिनापाईन तुले संतान व्हई, \"तवय अब्रामनी साराना शब्द मान्य करा. ");
INSERT INTO ahr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","अब्रामले कनान देशमा राहीसन दहा वरीस व्हवावर त्यानी बायको सारा हिनी आपला नवरा अब्राम याले आपली मिसरी दासी हागार हाई बायको म्हणीन करी दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","तो हागारना जोडे गया तवय ती गर्भवती व्हयनी; आपण गर्भवती व्हयेल शे हाई दखीसन तिले तिनी मालकीन सारा तुच्छ वाटाले लागनी. ");
INSERT INTO ahr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","तवय सारा अब्रामले बोलनी, \"मनासंगे जो अन्याय व्हई राहिना शे तो तुमनावर व्हवो, मी मनी दासी तुमले सोपी दिधी पण आपण गर्भवती शे हाई दखीसन ती माले तुच्छ मानी राहिनी शे, परमेश्वर आपला दोन्हीसना न्याय करो.\" ");
INSERT INTO ahr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","अब्राम साराले बोलना, \"तुनी दासी तुनाच हातमा शे, तुनी नजरमा जे योग्य वाटी तश तिनासंगे कर.\" मंग सारा तिनासंगे कठोरतामा व्यवहार कराले लागनी, तवय ती तिले सोडीसन पळी गई. ");
INSERT INTO ahr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","रानमा शूर नावना वाटवर एक झरा लागस त्या झरानाजोडे परमेश्वरना दूतले ती दखायनी. ");
INSERT INTO ahr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","तो बोलना, \"हे सारानी दासी हागार, तु कोठेन ई ऱ्हाईनी अनी कोठे जाई ऱ्हाईनी?\" ती बोलनी, \"मी मनी मालकीन सारा हिनापाईन पळी जाई राहिनु शे.\" ");
INSERT INTO ahr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","परमेश्वरना दूत तिले बोलना, \"तू तुनी मालकीनकडे परत जाय अनी तिनी दासी व्हय.\" ");
INSERT INTO ahr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","परमेश्वरना दूत तिले बोलना, मी तुनी संतती इतली वाढावसु की, तिनी गणती करता येवाव नही. ");
INSERT INTO ahr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","परमेश्वरना दूत तिले परत बोलना, तू गर्भवती शे, तुले पोऱ्या व्हई, त्यानं नाव तू इश्माएल ठेव, कारण परमेश्वरनी तुना आक्रोश ऐकेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","तो रान गधडाना मायक माणुस व्हई; त्याना हात सर्वासना विरूध्द उठी, अनी सर्वासना हात त्याना विरूध्द उठी; तो आपला सर्वा भाऊबंदसमा वस्ती करी. ");
INSERT INTO ahr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","तिनासंगे बोलनारा परमेश्वरना नाव तिनी आत्ता-एल-रोई म्हणजे \"तु दखनारा देव\" अस ठेवं; ती बोलनी, \"मी त्याले दखीसन बी हाई ठिकाणमा जिवत राहिनु?\" ");
INSERT INTO ahr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","यामुये त्या विहीरना नाव \"बैर- लहाय-रोई म्हणजे माले दखनारा जिवत विहिर\" अस पडनं; कादेश अनं बेरेद यासना जोडे हाई विहिर शे. ");
INSERT INTO ahr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हागारला अब्रामपाईन पोऱ्या व्हयना; हागारपाईन व्हयेल आपला पोऱ्याना नाव अब्रामनी इश्माएल ठेवा. ");
INSERT INTO ahr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","हागारपाईन अब्रामले इश्माएल व्हयना तवय अब्राम शहायची वरीसना व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","अब्राम जवय नव्यान्नव वरीसना व्हयना तवय परमेश्वर त्याले दर्शन दिसन बोलना, मी सर्वसमर्थ देव शे; तू मनासमोर शे हाई मनमा धरीन चाल अनं सात्विकपणमा राय. ");
INSERT INTO ahr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","तुनामा मी मना करार स्थापसु तुले मी बहुगुणित करीन. ");
INSERT INTO ahr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","तवय अब्राम उपडा पडना, अनी देव त्यानासंगे बोलना, तो बोलना, ");
INSERT INTO ahr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","दख मी तुनासंगे मना हाऊ करार करस तू राष्ट्रसमूहना जनक व्हसी. ");
INSERT INTO ahr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","यापुढे तुले अब्राम अश‍ म्हनावुत नहीत, तर तुले अब्राहाम अश म्हणतीन, कारण मी तुले राष्ट्रसमूहना जनक बनाडेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","मी तुले भलतं फलसंपन्न करसु; तुनापाईन मी राष्ट्र बनाडसु; तुनापाईन राजा उत्पन्न व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","मी तुना अनं तुनामांगे तुना संतानना देव व्हसु, अश कायमना करार मी तुनासंगे अनी तसच तुना पश्चात तुना संताननासंगे पिढानपिढा करस. ");
INSERT INTO ahr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","हाऊ जो कनान देशमा तु उपरी शे, तो सर्वा देश मी तुले अनं तुना पश्चात तुनी संतानले कायमना वतन म्हणीसन दिसु अनी मी त्यासना देव व्हसु. ");
INSERT INTO ahr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","देव अब्राहामले आखो बोलना, आते तू अनी तुना पश्चात तुनी संततीने पिढानपिढा कायम मना करार पाळानं. ");
INSERT INTO ahr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","मनासंगे अनी तू अनं तुना पश्चात तुनी संतती यासनामा स्थापेल मना करार जो तुम्हीन पाळाशात तो हाऊ; तुमनामातील प्रत्येक माणुसनी सुंता व्हवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","तुमनी अग्रत्वचा काढामा येवाले पाहिजे; हाई मनामा अनं तुमनामा व्हयेल करारनी खूण राही. ");
INSERT INTO ahr_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","अनी पिढीनपिढी प्रत्येक माणुस आठ दिनना व्हवावर त्यानी सुंता व्हवाले पाहिजे; मंग तो तुमना घरमा जन्मेल राहो, किंवा तुमना बीजना नसेल, परकापाईन धन दिसन लेयल राहो. ");
INSERT INTO ahr_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","तुना घरी जन्मेलना किंवा परकापाईन धन दिसन ईकत लेयलनी सुंता अवश्य व्हवाले पाहिजे; म्हणजे ज्या करारनी खूण तुमना शरीरमा करेल राही तो मना करार कायमना राही. ");
INSERT INTO ahr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","कोणी सुंता व्हयेल नही राहिनी, म्हणजे कोणी माणुसनी अग्रत्वचा काढामा वनी नही, तर त्याले आपला लोकसमाईन नष्ट करना; कारण त्यानी मना करार मोडेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","मंग परमेश्वरनी अब्राहामले सांगं, तुनी बायको साराय हिले यानापुढे साराय म्हनानं नही, तर तिना नाव सारा राही. ");
INSERT INTO ahr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","मी तिले आशिर्वादीत करसु, इतलंच नही तर तिनाद्वारा मी तुले एक पोऱ्या दिसु; मी तिले आशिर्वादीत करसु, तिनापाईन राष्ट्र उत्पन्न व्हतीन, तिनापाईन राष्ट्रसना राजा उत्पन्न व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","अब्राहामनी उपडा पडीसन अनं हसना अनी मनमान मनमा बोलना, शंभर वरीसना माणुसले पोऱ्या व्हई का? अनी नव्वद वरीसनी साराले पोऱ्या व्हई का? ");
INSERT INTO ahr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","अब्राहाम देवले बोलना, इश्माएल तुना नजरसमोर जगना म्हणजे हाई भरपुर शे. ");
INSERT INTO ahr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","पण देव बोलना, नही, नही, तुनी बायको सारा हिनाच पोटी तुले पोऱ्या व्हई; तू त्याना नाव इसहाक ठेव; त्याना पश्चात त्याना संततीनीसंगे कायम टिकी अश करार मी त्यानासंगे करसु. ");
INSERT INTO ahr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","इश्माएलनाविषयी बी मी तुनी प्रार्थना ऐकेल शे; दख, मी त्याले आशिर्वादीत करसु; त्याले सफळ अनं बहुगुणित करसु, तो बारा सरदारसना बाप व्हई; अनं मी त्यानं मोठं राष्ट्र बनाडसु. ");
INSERT INTO ahr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","पण पुढला वरीसले हाईच येळले तुले साराना पोटतीन इसहाक व्हई; त्यानासंगेच मी मना करार करसु. ");
INSERT INTO ahr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","मंग अब्राहामनासंगे बोलनं व्हवावर देव त्याले सोडीसन गया. ");
INSERT INTO ahr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","तवय अब्राहामनी आपला पोऱ्या इश्माएल, तसच त्याना घर जन्मेल अनं ईकत लियेल आपला सर्वा दास यासले म्हणजे आपला घरना सर्वा माणसंसले आणीसन देवनी त्याले सांगेल व्हतं त्याप्रमाणे त्याच दिनले त्यासनी सुंता करी. ");
INSERT INTO ahr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","अब्राहामनी सुंता व्हयनी तवय तो नव्यान्नव वरीसना व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","तसच त्याना पोऱ्या इश्माएल यानी सुंता व्हयनी तवय तो तेरा वरीसना व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहाम अनी त्याना पोऱ्या इश्माएल यासनी एकच दिनले सुंता व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","अनी त्याना घरमा जन्मेल अनं परकासपाईन ईकत लियेल अश त्यासना सर्वा घरना माणसंसनी त्यासनासंगे सुंता व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","मंग अब्राहाम दिनना भर दुपारना येळले आपला तंबूना दारजोडे बसेल व्हता, तवय परमेश्वरनी त्याले मम्रेना पवित्र झाडमां दर्शन दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","त्यानी आपली नजर वर करीसन दखं, तवय त्याले त्याना समोर तीन माणसं उभा राहेल दिसनात, तो आपला तंबूना दारपाईन पयत जाईसन जमीनवर पडीन त्यासले नमन करना. ");
INSERT INTO ahr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","मंग तो बोलना, हे प्रभू, मनावर तुनी कृपा व्हई तर आठेन तुना दासपाईन पुढे जाऊ नको; ");
INSERT INTO ahr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","थोडं पाणी आणु द्याव; तुम्हीन आपला पाय धुईसन हया झाडनाखाल आराम करा. ");
INSERT INTO ahr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","तुम्हीन आपला दासकडे येल शेतस, म्हणीसन मी थोडी भाकर लयस तिना आपला जिवले आधार कर, मंग तुम्हीन पुढे जा; त्या बोलनात, जस तू बोलनास तस कर. ");
INSERT INTO ahr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","तवय अब्राहाम लगेच तंबूमा साराजोडे जाईसन बोलना, तीन माप सपीठ लगेच लिसन मळ अनी त्यासन्या भाकरी कर. ");
INSERT INTO ahr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","परत अब्राहाम आपला गुरांकडे पयत गया अनं त्यानी एक चांगलं वासरू निवडीसन चाकरकडे दिधं; त्यानी ते फटकामा बनाडं. ");
INSERT INTO ahr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","नंतर अब्राहामनी दही, दूध अनं ते बनाडेल वासरू आणीसनं त्यासनासमोर ठेवं, अनी त्या भोजन करी राहींतात तवय तो त्यासनाजोडे झाडनाखाल उभा राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","मंग त्या त्याले बोलनात, तुनी बायको सारा कोठे शे? तो बोलना, ती तंबूमा शे\". ");
INSERT INTO ahr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","मंग तो बोलना, पुढला वसंतरऋतुमा मी तुनाकडे परत ईसु; तवय दख, तुनी बायको सारा हिले पोऱ्या व्हई, त्यानामांगे तंबूमा सारा हाई ऐकी राहिंती. ");
INSERT INTO ahr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहाम अनं सारा ह्या म्हातारा व्हई जायेल व्हतात अनी साराले मासिक पाळी येवानं बंद व्हई जायेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","तवय सारा मनमाच हसत बोलनी; मी पुरी म्हतारी व्हई जायेल शे अनं मना धनी बी म्हतारा व्हई जायेल शे, तर हाई सुख आते माले भेटी का? ");
INSERT INTO ahr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","परमेश्वर अब्राहामले बोलना, सारा काबंर हसनी? मी आते म्हतारी‍ राहीसन माले आते खरच पोऱ्या व्हई का अश ती काबंर सांगस? ");
INSERT INTO ahr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","परमेश्वरले काही अशक्य शे का? पुढला वसंत ऋतुमा नेमेल येळले मी तुनाकडे परत ईसु तवय साराले पोऱ्या व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","तवय सारा हाई सांगीसन नाकारनी, मी हसनी नही; कारण ती घाबरी जायेल व्हती; पण तो बोलना, नही तू हसनीच. ");
INSERT INTO ahr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","मंग त्या माणसे तठेन उठीसन सदोम नगरकडे जावाले निंघनात अनी अब्राहाम बी त्यासले वाटमा पोसाडाले गया. ");
INSERT INTO ahr_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","परमेश्वर बोलना, मी जे करनार शे ते अब्राहामपाईन कशे दपाडीसन ठेवु. ");
INSERT INTO ahr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","कारण त्यानापाईन मोठा अनी समर्थ राष्ट्र उत्पन्न व्हनार शे, अनी त्यानाद्वारा पृथ्वीवरला सर्व राष्ट्र आशिर्वादीत व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","मी त्याले याकरता निवडेल शे की, त्यानी आपला लेकरासले अनं आपला पश्चात आपला घरनासले आज्ञा देवाले पाहिजे म्हणजे त्यासनी न्यायतीन वागीसन परमेश्वरना मार्ग आचाराले पाहिजे अनं हाई यानाकरता की, परमेश्वर जे काही अब्राहामनासंगे बोलना ते त्यासले प्राप्त व्हवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","मंग परमेश्वर बोलना, सदोम अनं गमोरा या नगरसनाईषयी ओरड भलतीच व्हयेल शे, अनं त्यासनं पाप भयानक व्हयी जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","त्यामुये त्यासनाविषयी जी ओरड मना कानमा येयल शे, ते तसच शे का हाई दखाकरता मी खाल जायी राहिनु शे, तश नही राहिनं तर माले समजी जाई. ");
INSERT INTO ahr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","तठेन त्या माणसे फिरीसन सदोम अनं गमोरा नगरकडे गयात; पण अब्राहाम परमेश्वरनासमोर तसच उभा राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","मंग अब्राहाम जोडे ईसन बोलना, तू दुष्टनासंगे न्यायीसना बी नाश करशी का? ");
INSERT INTO ahr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","कदाचित नगरमा पन्नास न्यायीजन राहिनात, तर त्यासना बी तू नाश करशी का? त्यासनामाईन पन्नास न्यायीजनसकरता त्या नगरनी तू गय करावू नही का? ");
INSERT INTO ahr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","हाई प्रकारनी गोष्ट तुनापाईन दूर राहो की, दुष्टसनासंगे न्यायीजनसना नाश करीसन न्यायीजनसनी अनं दुष्टसनी गती सारखीच व्हई अश करानं तुनापाईन दूर राहो, सर्वा पृथ्वीना न्यायधीश योग्य न्याय कराऊ नही का? ");
INSERT INTO ahr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","परमेश्वर बोलना, माले सदोम नगरमा पन्नास न्यायीजन भेटनात तर मी त्यासनामुये सगया स्थळनी गय करसु. ");
INSERT INTO ahr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","अब्राहाम बोलना, दख, मी ते धूळ अनं राख शे, पण प्रभुनासंगे बोलाना मी धाडस करी राहिनु शे. ");
INSERT INTO ahr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","कदाचित पन्‍नासमा पाच न्यायीजन कमी राहिनात तरी त्या पाच कमी म्हणीसन तू सर्वा नगरना नाश करशी का. ");
INSERT INTO ahr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","त्यानी परत सांगं, तठे फक्त चाळीसच राहिनात तर? तो बोलना, त्या चाळीसचकरता मी तश कराऊ नही. ");
INSERT INTO ahr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","तवय अब्राहाम त्याले बोलना, हे प्रभु तुले राग येवाव नही ते हाई म्हणस, तठे जर तीसच राहिनात तर? तो बोलना, माले तीसच भेटनात तरी तश कराऊ नही. ");
INSERT INTO ahr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","तो बोलना, प्रभुनासंगे बोलाना, मी प्रयत्न करी राहिनु शे, तठे जर फक्त वीसच राहिनात तर? तो बोलना, त्या वीसचकरता मी त्यासना नाश कराऊ नही. ");
INSERT INTO ahr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","अब्राहाम बोलना, प्रभुले राग न येवो, अजुन एकदाव मी सांगस, तठे फक्त दहाच राहिनात तर? तो बोलना, त्या दहाकरता मी त्यासना नाश कराऊ नही. ");
INSERT INTO ahr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","मंग अब्राहामनासंगे बोलनं व्हवावर परमेश्वर निंघी गया, अनी अब्राहाम आपला ठिकानले वापस वना. ");
INSERT INTO ahr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","मंग संध्याकाळना येळले त्या दोन दूत सदोमले वनात, तवय लोट हाऊ सदोमना वेशीमा बठेल व्हता; त्यासले दखीसन लोट त्यासनाजोडे गया, अनी भुमीपावत तोंड करीसन त्यासले नमन करं; ");
INSERT INTO ahr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","तो त्यासले बोलना, दखा, मना धनीसवन, कृपा करीसन आपला दासना घर या; अनी आपला हातपाय धुईसन आठेच रातले मुक्काम करा, मंग सकासले उठीसन आपला वाटले लागी जा, पण त्या बोलनात, नही आमी रातभर रस्तामाच मुक्काम करसुत. ");
INSERT INTO ahr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","पण त्यानी त्यासले खुपच रावन्या करामुये त्या त्याना घर गयात; त्यानी त्यासनाकरता भोजन बनाडं; त्यानी बेखमीर भाकरी बनाड्यात मंग त्या जेवनात. ");
INSERT INTO ahr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","त्या झोपाना पहिलेच तठे त्या नगरना माणसंसनी, म्हणजे सदोमना माणसे, तरूणपाईन ते म्हातारापावत, सगयाच माणसंसनी चारीबाजुतीन ईसन त्या घरले घेरी लिधं. ");
INSERT INTO ahr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","त्या लोटले ओरडीसन बोलाले लागनात, आज रातले ज्या माणसे तुनाकडे येयल शेतस, त्या कोठे शेतस? त्यासले बाहेर आण, म्हणजे आम्हीन त्यासनासंगे समागम करसुत. ");
INSERT INTO ahr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","तवय लोट दारना बाहेर त्यासनाजोडे गया अनं त्यानी आपला मांगेतीन दार लाई लिधं. ");
INSERT INTO ahr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","अनी बोलाले लागना, भाऊसवन, मी तुमले ईनंती करसं आशे दुष्कर्म करू नका. ");
INSERT INTO ahr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","हाई दखा, मन्या दोन पोरी शेतस, त्या अजुन बी कुवार्‍या शेतस, मी तिसले तुमनाजोडे आणु का? तुमले वाटी तश तिसनासंगे वर्तन करा, पण ह्या माणसंसले काही करू नका, कारण त्या आसरासाकरता मना घर येल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","त्या बोलनात, बाजुले व्हय, हाऊ आठे थोडा दिन रावाकरता वना अनी आते आमले शहानपण शिकाडी राहीना शे! आते त्यासनापेक्षा तुनीच चांगली खबर लेतस, अश म्हणीसन त्या लोटले जोरमा ढकलु लागनात अनं दार तोडाले जोडे वनात. ");
INSERT INTO ahr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","पण त्या माणसंसनी बाहेर हात काढीसन लोटले घरमा आपलाजोडे ओढीसन दार लाई लिधं. ");
INSERT INTO ahr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","अनी ज्या धाकला मोठा माणसे घरना दारजोडे जमेल व्हतात त्यासले त्यासनी आंधळ करी टाकं; मंग त्या घर दखी दखी थकनात. ");
INSERT INTO ahr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","तवय त्या माणसे लोटले बोलनात, तुना आठे कोण कोण शेतस? तुना पोऱ्या-पोरी, जावई, अनी जो कोणी बी हाई नगरमा तुना व्हई त्या सर्वासले लिसन तू हाई ठिकाणतीन निंघी जाय. ");
INSERT INTO ahr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","कारण आम्हीन हाई स्थळना नाश करनार शेतस, ह्या लोकसनाविषयी परमेश्वरनापुढे खुपच ओरड व्हयेल शे, अनी हाई नगरना नाश कराले परमेश्वरनी आमले धाडेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","तवय लोट बाहेर जाईसन आपला जावईले ज्यानासंगे त्यानी पोरना लगीन व्हनार व्हतं, त्याले सांगं, उठा हाई स्थळमाईन बाहेर निंघा, कारण परमेश्वर हाई नगरना नाश करनार शे; पण त्याना जावईले वाटनं तो आमनासंगे गंमत करी राहीना. ");
INSERT INTO ahr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","पहाट व्हताच दूतसनी लोटले आग्रह करीसन सांगं, ऊठ, तुनी बायको, अनं तुन्या दोनी पोरी ज्या आठे शेतस तिसले लिसन निंघ, नहीते हाई नगरना शिक्षामा तुना बी नाश व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","पण लोट संकोच करू लागना, तवय परमेश्वरनी कृपा त्यानावर व्हती म्हणीसन त्या माणसंसनी त्याना अनी त्याना बायकोना अनी त्याना दोनी पोरीसना हात धरीसन त्यासले नगरना बाहेर आणीसनं सोडं. ");
INSERT INTO ahr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","मंग आशे व्हयनं त्यासले बाहेर आणावर दूत त्याले बोलना, आपला जीव लिसन पळ; मांगे दखानं नही अनं खोरामा कोठेच थांबानं नही; डोंगरकडे पळी जाय, नहीते तुना नाश व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","पण लोट त्यासले बोलना, नही प्रभु नही! ");
INSERT INTO ahr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","दख, तुना ह्या दासवर तुनी कृपादृष्टी व्हयेल शे; मना जीव वाचाडं हाई तुनी मनावर अपार दया प्रकट व्हयेल शे; पण माले डोंगरकडे पळी जाता येवाऊ नही; काय सांगता येस हाई संकट मनावर ईसन मी मरी जासु. ");
INSERT INTO ahr_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","तर दख, पळी जावाले हाई नगर जोडे राहीसन धाकलंबी शे; दखा, ते कितलं धाकलं शे; माले तिकडे पळी जावु दे, म्हणजे मना जीव वाची. ");
INSERT INTO ahr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","तवय तो त्याले बोलना, दख, तुनी हाई गोष्टले बी मान्य करस; तू सांगस त्या नगरना मी नाश कराऊ नही. ");
INSERT INTO ahr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","पटकन, तिकडे पळी जाय; कारण तू तठे जास नही तोपावोत माले काहीच करता येवाऊ नही. यावरीन त्या नगरना नाव सोअर (धाकलं) आशे पडनं. ");
INSERT INTO ahr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","लोट सोअरमा जाईसन पोचना तवय पृथ्वीवर याळ उगी वना. ");
INSERT INTO ahr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","तवय परमेश्वरनी सदोम अनं गमोरा नगरवर गंधक अनं अग्नी यासना वर्षाव आकाशमाईन करं. ");
INSERT INTO ahr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","अनी त्यानी त्या नगरसले, सर्व तळवटीसले, अनी त्या नगरमा सर्व राहानारा रहिवासीसले अनी तठे जमिनमा उगेल सर्व काही यासना नाश करं. ");
INSERT INTO ahr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","पण लोटनी बायको त्यानामांगे चाली राहिंती तिनी वळीसन मांगे दखं, तोच ती मिठना खांब बनी गई. ");
INSERT INTO ahr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","इकडे अब्राहाम मोठी पहाटलेच उठीसन जठे परमेश्वरनापुढे उभा राहिना व्हता‍ त्या ठिकाणमा गया. ");
INSERT INTO ahr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","त्यानी सदोम अनं गमोरा अनी सर्वा तळवटीना प्रदेश यासनावर नजर टाकी दखं, त्या प्रदेशमाईन भट्टीना धुरनामायक धुर वर जाई राहिंता. ");
INSERT INTO ahr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","याप्रकारं देवनी त्या तळवटीना नगरंसना नाश करं, त्या येळले देवनी अब्राहामनी आठवण करी, अनी लोट राही राहिंता तठला नगरंसना नाश कराना येळले लोटले त्या नाशमाईन वाचाडं. ");
INSERT INTO ahr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","नंतर लोट आपल्या दोनी पोरीसनासंगे सोअरमाईन निंघीसन डोंगरमा जाईसन राहिना; कारण त्याले सोअरमा रावाले भ्याव वाटनं, अनी तो आपला दोनी पोरीसले लिसन एक गुफामा राहावाले लागना. ");
INSERT INTO ahr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","एक दिन मोठी पोर धाकलीले बोलनी, आपला बाप धैयडा व्हयेल शे, अनी जगना रितीरिवाजप्रमाणे आपलाजोडे येतीन, आशे कोणीच माणुस पृथ्वीवर नही. ");
INSERT INTO ahr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","तर चल, आपण आपला बापले द्राक्षरस पाजूत अनी त्यानाजोडे निजुत; आशे प्रकारतीन आपण आपला बापना वंश चालाडूत. ");
INSERT INTO ahr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","त्यासनी ती रातले आपला बापले द्राक्षरस पाजं अनी मोठी पोर त्यानाजोडे जाईसन निजनी; पण ती कवय निजनी अनी कवय उठनी हाई त्याले समजनं नही. ");
INSERT INTO ahr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","मंग दुसरा रोज मोठी पोर धाकलीले बोलनी, दख, कालदिन रातले मी बापनाजोडे निजनू; तर आज रातले बी आपण त्याले द्राक्षरस पाजुत अनी तू त्यानाजोडे जाईसन निज. हाई प्रकारतीन आपण आपला बापना वंश चालाडूत. ");
INSERT INTO ahr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","त्या रातले बी त्यासनी आपला बापले द्राक्षरस पाजं अनी धाकली पोर जाईसन त्यानाजोडे निजनी; पण ती कवय निजनी अनी कवय उठनी हाई त्याले समजनं नही. ");
INSERT INTO ahr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","याप्रकारमा लोटन्या दोनी पोरी बापपाईन गर्भवती व्हयन्यात. ");
INSERT INTO ahr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","मोठी पोरले पोऱ्या व्हयना, त्यानं नाव तिनी मवाब आशे ठेवं; आजपावोत ज्या मवाबी वंशज शेतस‍ त्यासना हाऊ मूळ बाप शे. ");
INSERT INTO ahr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","धाकली पोरले बी पोऱ्या व्हयना, तिनी त्यानं नाव बेनअम्मी आशे ठेवं; आजपावोत ज्या अम्मोनी वंशना शेतस त्यासना हाऊ मूळबाप शे. ");
INSERT INTO ahr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","अब्राहाम तठेन निंघीसन कनानं दक्षिणले प्रवास करीसन कादेश अनं शूर यासना मजारमा मुक्काम करं अनी काही दिन गरार आठे राहावाले लागना. ");
INSERT INTO ahr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","आपली बायको सारा हिनाबद्दल अब्राहामनी आशे सांगं की, हाई मनी बहीण शे, तवय गरारना राजा अबीमलेख यानी माणसे धाडीसन साराले आपलाजोडे ठेई लिधं. ");
INSERT INTO ahr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","पण त्या रातले देव सपनमां ईसन अबीमलेखले बोलना, तू हाई जी बाई आणेल शे तिनामुये तुना नाश व्हई, कारण ती लगीन व्हयेल बाई शे. ");
INSERT INTO ahr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","अबीमलेख तिनाजोडे काही जायेल नव्हता, म्हणीसन तो बोलना, हे प्रभू, तू नितीमान राष्ट्रना बी नाश करशी का? ");
INSERT INTO ahr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ती मनी बहीण शे आशे तो सोता माले बोलना नही का? तसच तो मना भाऊ शे आशे ती बी माले बोलनी नही का? मी सात्विक मनतीन अनं स्वच्छ हाततीन हाई करेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","देवनी त्याले स्वप्नमा सांगं, तू सात्विक मनतीन हाई करेल शे हाई माले बी ठाऊक शे, अनी मीच तुले मनाविरूध्द पाप व्हवापाईन वाचाडेल शे; म्हणीसन मी तुले तिले हात बी लावु दिधं नही. ");
INSERT INTO ahr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","आते त्या माणुसनी बाई त्याले वापस दे, कारण तो संदेष्टा शे; तो तुनाकरता प्रार्थना करी अनी तू वाची जाशी; पण जर तू त्यानी बाई वापस नही दिधी, तर समजी ले तू अनं तुना जितला बी लोके शेतस बठा पक्का मरतीन. ");
INSERT INTO ahr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","मंग अबीमलेख मोठी पहाटमाच उठीसनं आपला सर्व सेवकसले बलाईसन या सर्वा गोष्टी त्यासले सांग्यात; तवय त्या माणसे भयान घाबरनात. ");
INSERT INTO ahr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","तवय अबीमलेखनी अब्राहामले बलाईसन त्याले सांगं, तू आमनासंगे हाई काय करं? मी तुना आशे कोणतं अपराध करं की, तू मनावर अनी मना राज्यवर आशे महापातक आणात? करानं नही अश वर्तन तू मनासंगे करेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","अबीमलेख अब्राहामले ईचारं, हाई गोष्ट कराकरता तुना मनमा काय व्हतं? ");
INSERT INTO ahr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहामनी उत्तर दिधं, मी हाई यानाकरता आशे करं की, माले आशे वाटनं हाई ठिकाणले आठे कोनले बी परमेश्वरनं भय नही शे, म्हणीसन मनी बायकोमुये या लोके माले मारी टाकतीन. ");
INSERT INTO ahr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","तसच ती खरंच मनी बहीण शे, ती मना बापनी पोर शे; पण मनी मायनी ती पोर नही, म्हणीन ती मनी बायको व्हयेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","अनी अश व्हयनं की, देवनी माले मना बापना घर सोडीसन निंघानी आज्ञा करी तवय मी तिले सांगं, तू मनावर इतली कृपा कर की, आपण जठे बी जाशुत तठे हाऊ मना भाऊ शे अश मनाबद्दल सांग. ");
INSERT INTO ahr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","तवय अबीमलेखनी मेंढरं, बैल, दास अनं दासी आनीसन अब्राहामले दिधं, अनी त्यानी बायको सारा हाई बी परत त्याले आणी दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","\"मंग अबीमलेख बोलना, \"मना देश तुले मोकळा शे; तुले वाटी तठे राय. ");
INSERT INTO ahr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","तो साराले बोलना, दख, मी तुना भाऊले एक हजार चांदीना नाणा दि राहिनु शे; ज्या लोके तुनासंगे शे त्या सर्वासना नजरमा तु निर्दोष शे अनी त्या सर्वासले समजी की तुनी काहीच चुकी करेल नही शे. ");
INSERT INTO ahr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","मंग अब्राहामनी परमेश्वरकडे प्रार्थना करी, तवय परमेश्वरनी अबीमलेख, त्यानी बायको अनं त्याना दासी यासले बरं करं, अनी त्यासले पोऱ्या व्हवाले लागनात. ");
INSERT INTO ahr_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","कारण अब्राहामनी बायको सारा हिनामुये परमेश्वरनी अबीमलेखना घराणामातील सर्व बायासनं गर्भाशय बंद करेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","तवय परमेश्वरनी सांगेल प्रमाणे सारावर आशिर्वादीत करं अनी तिले देयल वचन पुरं करा. ");
INSERT INTO ahr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","सारा गर्भवती व्हयनी, देवनी सांगेल येळले अब्राहामले म्हतारंपणमा तिनापाईन पोऱ्या व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","अब्राहामले सारापाईन पोऱ्या व्हयना त्यानं नाव इसहाक ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","जवय अब्राहामना पोऱ्या आठ दिनना व्हयना तवय देवनी सांगेल आज्ञा प्रमाणे त्यानी सुंता व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","जवय त्याना पोऱ्या इसहाक व्हयना तवय अब्राहाम शंभर वरीसना व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","सारा सांगु लागनी, \"देवनी माले आनंद अनं हसु देयल शे; जो कोणी हाई ऐकी तो मनासंगे आनंद करी.\" ");
INSERT INTO ahr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","आखो ती बोलनी, \"कोणी अब्राहामले सांगु शकी की, सारा पोऱ्यासले दूध पाजी? तरी बी त्याना म्हतारपणमा मनापाईन त्याले पोऱ्या व्हयेल शे.\" ");
INSERT INTO ahr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","अनी तो बाळ मोठा व्हयना तवय त्यानं दूध तोडं; इसहाकनं दूध तोडं त्या दिनले अब्राहामनी मोठी मेजवानी दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","तवय मिसरी दासी हागारले अब्राहामपाईन व्हयेल पोऱ्याले इसहाक संगे खेळतांना सारानी दखं. ");
INSERT INTO ahr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","तवय ती अब्राहामले बोलनी, \"हाई दासीले अनं हिना पोऱ्याले काढी टाका; मना पोऱ्या इसहाक यानासंगे हाई दासीना पोऱ्या वारीस ऱ्हावाले नको. ");
INSERT INTO ahr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","अब्राहामले आपला पोऱ्यानाबद्दल हाई गोष्ट खुप वाईट वाटनी. ");
INSERT INTO ahr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","तवय देव अब्राहामले बोलना, हाऊ पोऱ्या अनं हाई दासी यासनाबद्दल तू वाईट वाटीसन लेवु नको; सारा तुले जे काही सांगस ते सर्वा ऐकी ले; तुना वंशजना नाव इसहाकच चालावनार शे. ");
INSERT INTO ahr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","अनी हाई दासीना पोऱ्यापाईन बी मी एक राष्ट्र बनाडसु; कारण तो पण तुनाच वंशज शे. ");
INSERT INTO ahr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","नंतर अब्राहामनी पहाटमाच उठीन भाकरी अनं पाणीघाई भरेल चामडानी थैली लिधी अनी ती लिसन हागारना खांदावर ठेई अनी तिना पोऱ्या तिनाजोडे दिसन तिले वाट लायं, ती निंघीसन बैर-शेबाना रानमा भटकत राहीनी. ");
INSERT INTO ahr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","जवय थैलीमाधलं पाणी संपी गयं तवय तिनी आपला पोऱ्याले झुडूपना खाल ठि दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","\"अनी ती काही अंतरवर जाईसन त्यानासमोर बसनी; कारण ती बोलनी, \"मना पोऱ्याले मी मरतांना नही दखु शकस.\" म्हणीसन ती थोडं दुर जाईसन त्यानाकडे तोंड करीसन बठनी अनी हंबरडा फोडीन रडाले लागनी. ");
INSERT INTO ahr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","देवनी पोऱ्यानं रडानं आवाज आयकं; अनं देवना दूतनी आकाशमाईन हाक मारीसनं हागारले बोलना, हागार, तुले काय व्हयनं शे? घाबरू नको, कारण जठे पोऱ्या शे तठेतीन देवनी त्याना आवाज आयकेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ऊठ, पोऱ्याले उचलीसनं आपला हातमां धर, त्यानापाईन मी एक मोठं राष्ट्र बनाडनार शे. ");
INSERT INTO ahr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","मंग देवनी तिना डोया उघडात अनं तिले पाणीनी विहीर दखायनी; तवय तिनी जाईसनं थैलीमा पाणी भरं अनं पोऱ्याले पाजं. ");
INSERT INTO ahr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","देव त्या पोऱ्यानासंगे व्हता, अनं तो पारानना रानमा धाकलाना मोठा व्हईसन तिरंदाज बनना. ");
INSERT INTO ahr_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","तो पारानाना रानमा वस्ती करीन राहिना, अनी त्यानी मायनी त्याले मिसर देशनी बायको करी दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","त्या येळले अश व्हयनं की, अबीमलेख अनं त्याना सेनापती पीकोल ह्या अब्राहामले बोलनात, ज्या काही तुम्हीन करतस त्यामा देव तुम्हनासंगे शे. ");
INSERT INTO ahr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","यामुये तू आते मनासंगे परमेश्वरनी हाई शपथ खाय की, तुम्हीन मना संतानासंगे कपटीन वागाऊ नही, अनी जशी तुम्हीन मनावर कृपा करी, तशी मी तुमनावर अनं ज्या देशमा मी प्रवासी म्हणीसन राहिनु शे, तो हाई देशवर कृपा करसु. ");
INSERT INTO ahr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहाम बोलना, बरं, मी हाई शपथ लेस. ");
INSERT INTO ahr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","मंग अबीमलेखना चाकरंसनी पाणीनी एक विहिर आपला ताबामा लेयल व्हती, त्यानाबद्दल अब्राहामनी अबीमलेखले दोष लायं. ");
INSERT INTO ahr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","अबीमलेख बोलना, हाई काम कोणी करेल शे हाई माले माहित नही; तुम्हीन माले हाई पहिले सांगेल नव्हतं; अनी मी पण हाई ऐकेल नव्हतं, आजच ऐकी राहीनु शे. ");
INSERT INTO ahr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","मंग अब्राहामनी मेंढरं अनं बैल आणीसन अबीमलेखले दिधं अनी त्या दोन्हीसनी एकमेकससंगे करार करा. ");
INSERT INTO ahr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहामनी कळपमाईन कोकरूमाधलं सात माद्या येगळ्या काढी ठेयात. ");
INSERT INTO ahr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","तवय अबीमलेख अब्राहामले बोलना, तुम्हीन ह्या सात कोकरू कसाले येगळा काढी ठेयल शेतस? ");
INSERT INTO ahr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","तो बोलना, तुम्हीन ह्या सात कोकरू मना हाततीन ल्या, म्हणजे यानी हाई साक्षी राही की, हाई विहिर मी खंदेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","यावरीन त्या ठिकाणना नाव बैर-शेबा (शपथनी विहिर) असं पडनं, कारण तठे त्या दोन्हीजणसनी शपथ लिधी. ");
INSERT INTO ahr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","बैरशेबा आठे त्यासनी करार करावर अबीमलेख त्याना सेनापती पीकोल ह्या निंघीसन पलिष्टयासना देशले परत गयात. ");
INSERT INTO ahr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","मंग अब्राहामनी बैर-शेबा आठे एशेल नावना झाड लायं, अनी तठे सनातन देव परमेश्वर याना नावनी आरधना करी. ");
INSERT INTO ahr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","अब्राहाम हाऊ पलिष्टयासना देशमा बराच दिन प्रवासी म्हणीसन राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","मंग या गोष्टी घडण्यात तवय आशे व्हयनं की, देवनी अब्राहामनी परीक्षा लिधी; अनी त्यानी अब्राहाम, अशी हाक मारी, तवय अब्राहाम बोलना, काय आज्ञा? ");
INSERT INTO ahr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","देव बोलना, तुना पोऱ्या, तुना एकुलता एक आवडता इसहाकले ज्यानावर तू प्रिती करस त्याले लिसन मोरिया देशमा जाय अनी मी तुले सांगसु त्या डोंगरवर त्यानं अर्पण कर. ");
INSERT INTO ahr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","तवय अब्राहाम मोठी पहाटमाच उठीसन आपला गधडावर गासडा बांधं, आपलासंगे दोन सेवक अनं आपला पोऱ्या इसहाक याले संगे लिधं, अनी होमार्पणकरता लाकडे फोडी लिधात, मंग देवनी सांगेल ठिकानपान तो निंघना. ");
INSERT INTO ahr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तिसरा रोजले अब्राहामनी वर नजर करीसन ती जागा दुरतीन दखी. ");
INSERT INTO ahr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","अब्राहाम आपला सेवकसले बोलना, तुम्हीन आठेच गधडानाजोडे थांबा, पोऱ्या अनी मी पलीकडे जाईसन देवनी आराधना करीसनं मंग तुमनाजोडे परत येतस. ");
INSERT INTO ahr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","तवय अब्राहामनी होमार्पणकरता लाकडे लिसन आपला पोऱ्या इसहाक यानी पाटवर ठेवात, अनी आपला हातमा ईस्तव अनं सुरा लिधा, अनी दोन्ही संगेसंगे चालनात. ");
INSERT INTO ahr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","तवय इसहाकनी आपला बापले सांगं, बाबा! तो बोलना, काय सांगस बाळा? त्यानी सांगं, दखा, ईस्तव अनं लाकडे पण लेयल शेतस पण होमार्पणकरता कोकरू कोठे शे? ");
INSERT INTO ahr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहाम त्याले बोलना, बाळा, देव स्वत: होमार्पणकरता कोकरू दखी दी; अनी त्या दोन्ही संगेसंगे चालनात. ");
INSERT INTO ahr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","देवनी त्याले सांगेल ठिकानपान त्या वनात तवय अब्राहामनी तठे वेदी बांधी, तिनावर लाकडे रचात अनी आपला आवडता पोऱ्या इसहाक याले बांधीसन वेदीवरना लाकडसवर ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","तवय अब्राहामनी आपला पोऱ्याना वध कराकरता हात पुढे करीसन सुरा लिधा. ");
INSERT INTO ahr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","तवय परमेश्वरना दूत अब्राहामले आकाशमाईन हाक मारीन बोलना, \"अब्राहाम, अब्राहाम!\" त्यानी सांगं, \"काय आज्ञा?\" ");
INSERT INTO ahr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","मंग तो बोलना, \"तू तुना हात आपला पोऱ्यावर चालावू नको, त्याले काही करू नको; आते माले समजेल शे की, तु देवले भ्याईसन चालनारा शे, कारण तू आपला पोऱ्याले, आपला एकुलता एक पोऱ्याले बी मनाकरता सोडं नही.\" ");
INSERT INTO ahr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","तवय अब्राहामनी नजर वर करीसन दखं, ते त्याले आपलामांगे झुडपा शिंगं अटकेल एक एडका दिसना; मंग अब्राहमनी तो एडका लिसन आपला पोऱ्याना बदलामा अर्पण करं. ");
INSERT INTO ahr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","\"अनी अब्राहामनी त्या ठिकाननं नाव \"याव्हे-यिरे म्हणजे परमेश्वर दखी दी\" अस ठेवं; तवयपाईन परमेश्वरना डोंगरवर दखी देवामा ई अस आजपावत बोलामा येस. ");
INSERT INTO ahr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","परमेश्वरना दूतनी आकाशमाईन अब्राहामले दुसरांदाव हाक मारीसन बोलना, ");
INSERT INTO ahr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","परमेश्वर सांगस, मी स्वत:नी शपथ लिसन सांगस की, तू हाई कृत्य करा; आपला पोऱ्याले, आपला एकुलता एक पोऱ्याले मनापाईन राखी ठेया नही; ");
INSERT INTO ahr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","यामुये मी तुले आशिर्वादीत करसु, अनं भरभराट‍ करीसन तुनी संतती आकाशमाधलं तारा इतला, समुद्रकाठना वाळू इतली व्हई आशे मी करसु; तुनी संतती आपला शत्रूसना नगरेसवर अधिकार करी लेतीन. ");
INSERT INTO ahr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","तू मना शब्द आयकं म्हणीसन पृथ्वीवरना राष्ट्र तुना संततीमुये आशिर्वादीत व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","मंग अब्राहाम आपला सेवकसकडे परत वना, अनी त्या उठीसन बैर-शेबा आठे वनात; अनी अब्राहाम बैर-शेबामा रावाले लागना. ");
INSERT INTO ahr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","या गोष्टी घडन्यात तवय कोणीतरी अब्राहामले सांगं, दख, तुना भाऊ नाहोर यानापाईन मिल्काले बी पोऱ्यानी संतती व्हयेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","मिल्काना पोऱ्या या व्हतात, ऊस हाऊ त्याना ज्येष्ठ पोऱ्या, त्याना भाऊ बूज अनं अरामना बाप कमुवेल. ");
INSERT INTO ahr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","अनी केसद, हजो, पिलदाश, यिदलाप, अनं बथुवेल. ");
INSERT INTO ahr_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","बथुवेलपाईन रिबका व्हयनी; अब्राहामना भाऊ नाहोर यानापाईन मिल्काले ह्या आठ पोऱ्या व्हयनात; ");
INSERT INTO ahr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","अनी त्यानी उपपत्नी रेऊमा हिले बी तेबाह, गहाम, तहश, अनं माका ह्या व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा एकशेसत्तावीस वरीस जगनी; एवढाच तिना आयुष्य व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","सारा हाई कनान देशमा किर्याथ-आरबा म्हणजे हेब्रोन आठे मरण पावनी, अनी अब्राहाम तिनाकरता शोक अनं विलाप कराले वना. ");
INSERT INTO ahr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","अब्राहाम आपला मयत व्हयेल बायकोना जोडेतीन उठीन हेथीले बोलना, ");
INSERT INTO ahr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","मी तुमनामा प्रवासी अनं परदेशी शे; मना मालकीनी कबर तुमनामा ऱ्हावाले पाहिजे म्हणीसन माले जागा द्या, म्हणजे मी आपला मरेलसले मूठमाती दिसन नजरना आड करसु. ");
INSERT INTO ahr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","तवय हेथी लोकसनी अब्राहामले बोलनात, ");
INSERT INTO ahr_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","\"हे आमना मालक आमनं ऐक; आमनामा तुम्हीन एक देवना सरदार शेतस; आपण आमना कबरसमाईन तुमले वाटी त्यामा आपला मयतले मूठमाती द्या; आपला मयतले मूठमाती देवाकरता आपली कबर देवाले आमनामाधला कोणी बी नाकार देवाव नही.\" ");
INSERT INTO ahr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","तवय अब्राहामनी उठीन त्या देशमा लोकसले म्हणजे हेथीसले नमन करा. ");
INSERT INTO ahr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","तो त्यासले बोलना, \"मी आपला मयतले नजरना आड कराले पाहिजे अशी तुमनी इच्छा व्हई तर तुम्हीन मना ऐका; एफ्रोन बिन सोहर यानाजोडे मनाकरता ईनंती करा की, ");
INSERT INTO ahr_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","त्याना वावरना हद्दना मजारली त्यानी मकपेला नावनी गुहा शे, ती मनी मालकीनी कबरस्तान व्हवाले पाहिजे म्हणीसन त्यानी तुमनासमोर पुरी किंमत लिसन माले देवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","एफ्रोन हित्ती हाऊ हेथीसमा बठेल व्हता, तो हेथीसना समक्ष, त्याना गावना वेशीमाईन येनारा जानारा सर्वासमक्ष अब्राहामले सांगं, ");
INSERT INTO ahr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","\"हे मना मालक, अस नही, मनं ऐका, ते वावर मी तुमले देस, अनी त्यामा जी गुहा शे ती बी तुमले देस; मना भाऊसना समक्ष मी तुमले देस, तठे आपला मयतले मूठमाती द्या.\" ");
INSERT INTO ahr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","तवय अब्राहामनी त्या देशना लोकसले नमन करं.\" ");
INSERT INTO ahr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","अनी त्या देशना लोकसना समक्ष तो एफ्रोनले बोलना, \"मनं एवढं खरच ऐकी ले; मी वावरना पैसा देस ते मनाकडीन ले म्हणजे मी मनी बायकोना शरीरले तठे मूठमाती दिसु. ");
INSERT INTO ahr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","तवय एफ्रोननी अब्राहामले उत्तर दिधं, ");
INSERT INTO ahr_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","\"मालक, मनं ऐका, हाई फक्त चारशे शेकेल रूपे किंमतनी जमीन, तिनं काय मोठं? तुम्हीन आपला मयतले मूठमाती द्या.\" ");
INSERT INTO ahr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","अब्राहामनी एफ्रोननं सांगनं मानीसन हेथीसना समक्ष जेवढा पैसा सांगेल व्हतात तेवढा चलनी चारशे शेकेल रूपे त्यासले मोजी दिधात. ");
INSERT INTO ahr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","अश प्रकारमा एफ्रोनना शेत जे मम्रेना पुर्वले मकपेलमा व्हतं ते अनी त्यामधली गुहा, अनी शेतामाधलं अनी त्यानाहद्दमाधलं प्रत्येक झाडं. ");
INSERT INTO ahr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","हेथीसमक्ष वेशीमाईन जानारा येनारा सर्वासमक्ष, अब्राहामना कबजामा पुरा वना. ");
INSERT INTO ahr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","नंतर अब्राहामनी आपले बायको सारा हिले कनान देशना मम्रे म्हणजे हेब्रोन याना पुर्वले मकपेलाना शेतमाधलं गुहामा पुरा. ");
INSERT INTO ahr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","अनी ते शेत गुहानासोबत कबरस्तान व्हवाले पाहिजे म्हणीसन हेथी यासना कडीन अब्राहामना कबजामा पुरा वना. ");
INSERT INTO ahr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहाम आते म्हतारा व्हईसन खूप वयना व्हई जायेल व्हता; परमेश्वरनी अब्राहामले बठया गोष्टीसमा आशिर्वादीत करेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","अब्राहामना मालमत्ताना सर्वा कारभार दखनारा एक सर्वसमा जुना सेवक व्हता, त्याले त्यानी सांगं, तू तुना हात मना मांडीनाखाल ठेव. ");
INSERT INTO ahr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","मी तुले परमेश्वरनी, आकाश अनं पृथ्वी यासना देवनी शपथ लेवाले सांगस की, ज्या कनानी लोकसमा मी ऱ्हाई राहिनु शे. त्यासना पोरीपाईन कोणती बी मना पोऱ्याकरता तू बायको दखावु नही. ");
INSERT INTO ahr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","तर मना देशले मना नातेवाईकसजोडे जाईसन तठेन मना पोऱ्या इसहाक करता बायको दखी लयशी. ");
INSERT INTO ahr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","त्याना सेवक त्याले बोलना, कदाचित ती बाई मनासंगे हाई देशमा येवाले राजी नही व्हयनी ते मंग ज्या देशमाईन तुम्हीन वनात तठे तुमना पोऱ्याले मी परत ली जावानं का? ");
INSERT INTO ahr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","तवय अब्राहाम बोलना, खबरदार! मना पोऱ्याले तठे ली जावानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","स्वर्गना ज्या परमेश्वर देवनी माले मना बापना घरमाईन, मनी जन्मभुमीमाईन आणं अनी माले शपथ खाईसन सांगं की, हाऊ देश मी तुना संततीले दिसु. तो तुनापुढे त्याना दूत धाडी, अनी तठेनच तू मना पोऱ्याकरता बायको आण. ");
INSERT INTO ahr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","पण ती बाई तुनासंगे येवाले राजी नही व्हयनी तर तू मनी शपथपाईन मोकळा व्हसी; पण मना पोऱ्याले तिकडे कधीच ली जावानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","तवय त्या सेवकनी आपला मालक अब्राहामना मांडीनाखाल हात ठेईसन हाई गोष्टनी शपथ लिधी. ");
INSERT INTO ahr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","मंग तो सेवक आपला मालकना उंटसपाईन दहा उंट लिसन निंघना; त्यानाजोडे त्याना मालकन्या सर्वा प्रकारन्या मौलवान वस्तु व्हत्यात; तो उत्तरले मेसोपोटामिया माधलं नाहोरना नगरमा गया. ");
INSERT INTO ahr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","संध्याकाळले बाया पाणी भराले बाहेर निंघतस त्या येळले त्यानी आपला उंट नगरना बाहेर एक विहिरनाजोडे बसाडं. ");
INSERT INTO ahr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","अनी तो बोलना, हे परमेश्वरा, मना मालक अब्राहाम याना देवा, तू आज कृपा करीसन मना कार्य सफल कर; मना मालक अब्राहाम यानावर दया कर. ");
INSERT INTO ahr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","दख, मी हाई पाणीनी विहिरनाजोडे उभा शे, अनी गावमाधल्या पोरी पाणी भराले बाहेर ई ऱ्हाईन्या शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","आते असं व्हवू दे की, जी पोरले मी सांगसु, माले पाणी पेवाकरता घागर खाल उतार, अनी ती माले म्हणी तू पण पी अनी तुना उंटसले बी पाणी पाजस, तीच पोर तुना सेवक इसहाक यानाकरता निवडेल शे, यावरीन माले समजी की, तू मना मालकवर दया करेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","अनी तसच व्हयनं जो ते सांगी राहिंता, तवय अब्राहामना बंधु नाहोर यानी बायको मिल्का हिना पोऱ्या बथुवेलनी पोर रिबका खांदावर घागर लिसन तठे वनी. ");
INSERT INTO ahr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","हाई पोर दखावाले देखनी व्हती; ती कुवारी व्हती; तिनी माणुस दखेल नव्हता; ती विहिरमा उतरनी अनं घागर भरीसन वर वनी. ");
INSERT INTO ahr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","तवय तो सेवक धावत जाईसन तिले गाठीसनं बोलना, तुनी घागरमाईन माले थोडं पाणी पाज. ");
INSERT INTO ahr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ती त्याले बोलनी, प्या, बाबा; अनी तिनी लगेच आपला हातवर घागर उतारीसन त्याले पाणी पाजं. ");
INSERT INTO ahr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","त्याले भरपुर पाणी पाजावर ती बोलनी, तुमना उंटसले मी पाणी आणीसनं त्यासले पोटभर पाजस. ");
INSERT INTO ahr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","मंग तिनी लगेच घागर कुंडीमा रिकामी करी अनी परत विहिरनाजोडे पाणी भराले धावत गई; अश करीसन तिनी त्याना सर्वा उंटसकरता पाणी काढं. ");
INSERT INTO ahr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","तवय तो माणुस आश्चर्य व्हईसन तिनकडे दखी राहिना; परमेश्वरनी आपला प्रवास सफल करं की नही हाई ईचार करीसन गप्प राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","मंग अश व्हयन की, उंटसना पाणी पेवावर त्या माणुसनी अर्धा शेकेल भार सोनानी एक नथ अनं तिना हातमा घालाकरता दहा शेकेल भार दोन सोनान्या बांगड्या काढयात, ");
INSERT INTO ahr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","अनी तो तिले बोलना, तू कोणी पोर शे हाई माले सांग; तुना बापना घर थांबाकरता आमले जागा शे का? ");
INSERT INTO ahr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ती त्याले बोलनी, नाहोरपाईन मिल्काले व्हयेल बथुवेलनी मी पोर शे. ");
INSERT INTO ahr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ती त्याले आखो बोलनी, आमना आठे भरपुर चारा अनी थांबाकरता जागा बी शे. ");
INSERT INTO ahr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","तवय त्या माणुसनी झुकीसन परमेश्वरनी आरधना करी. ");
INSERT INTO ahr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","तो बोलना, मना मालक अब्राहाम याना देव यहोवा धन्यवादित शे; त्यानी मना मालकवर दया करानं अनी त्यानासंगे सत्यमा चालानं सोडं नही; परमेश्वरनी माले सरळ वाट दखाडीसन मना मालकना भाऊसना घर पोचाडेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","तवय त्या पोरनी पयत जाईसन तिनी मायना घरनासले हाई गोष्ट सांगी. ");
INSERT INTO ahr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","रिबकाले एक भाऊ व्हता; त्यानं नाव लाबान व्हतं, तो विहिरनाजोडे त्या माणुसकडे धावत गया. ");
INSERT INTO ahr_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","त्यानी नथ अनं आपला बहिणना हातमाधल्या बांगड्या दखेल व्हत्यात, अनी तो माणुस माले अश बोलना, हाई रिबकानं तोंडनं शब्द आयकीसनं तो त्या माणुसकडे वना अनी दखं तर तो उंटसपान विहिरनाजोडे उभा व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","तवय त्यानी त्याले सांगं, अहो परमेश्वरना आशिर्वाद \"मजार या, बाहेर का बर उभा शेतस? मी आपलाकरता घर अनी उंटसकरता जागा करी ठेयल शे. ");
INSERT INTO ahr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","तवय तो माणुस घर वना; अनी लाबाननी उंटसन्या कंठाळी सोडीसन त्यासले चारा अनं भुसा दिधा अनी त्या माणुसले अनं त्यानासंगेनासले पाय धुवाले पाणी दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","जवय त्यानासमोर जेवण वाढी दिधं तवय तो त्यासले बोलना, \"जोपावत मी आठे येवानं कारण तुमले सांगस नही,\" तोपावत मी भोजन करावु नही, तवय तो बोलना, \"मंग सांगा.'' ");
INSERT INTO ahr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","तो बोलना, \"मी अब्राहामना सेवक शे.\" ");
INSERT INTO ahr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","परमेश्वरनी मना मालकनं कल्याण करेल शे; तो मोठा व्हयेल शे; त्यानी त्याले गुरं, मेंढरं, सोनं, रूपे, दासदासी, उंट अनं गाढवं बी देयल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","मना मालकनी बायको सारा हिले म्हतार पणमा त्यानापाईन पोऱ्या व्हयना, त्याले त्यानी सर्वाकाही देयल शे. ");
INSERT INTO ahr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","अनी मना मालकनी माले शपथ लेवाले लाईसन सांगेल शे की, ज्या कनानीसना देशमा मी ऱ्हाई राहिनु शे, त्यासन्या पोरीसमाईन कोणती बी पोर मना पोऱ्याले बायको दखु नको; ");
INSERT INTO ahr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","तर मना बापना घर मना नातेवाईकस कडे जाय अनी तठेन मना पोऱ्याले बायको दखी आण. ");
INSERT INTO ahr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","तवय मी मना मालकले सांगं, ती पोर मनासंगे येवाले तयार व्हयनी नही ते. ");
INSERT INTO ahr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","तवय तो माले बोलना, ज्या परमेश्वरनी संगे मी चालस, तो आपला दूत तुनासंगे धाडी अनं तुना प्रवास सफल करी, अनी तू मना नातेवाईकस कडे, मना बापना घराणामाईन मना पोऱ्याले बायको आण. ");
INSERT INTO ahr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","तू मना नातेवाईकस कडे गया म्हणजे मनी शपथपाईन मोकळा व्हसी; पोर देवाले त्या तयार नही व्हयनात तरी तू मनी शपथपाईन मोकळा व्हशी. ");
INSERT INTO ahr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","मी आज हाई विहिरना जोडे वनु तवय बोलनु, मना मालक अब्राहामना देव यहोवा मी जो प्रवास करेल शे, तो सफल करशी तर. ");
INSERT INTO ahr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","दख, मी हाई विहिरनाजोडे उभा राहेल शे; तर अस व्हवू दे की, पाणी भराले जी पोर ई, तिले मी सांगसु, तुनी घागरमाईन माले थोडं पाणी पाज. ");
INSERT INTO ahr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","अनी ती माले सांगी, तू पी अनी तुना उंटसले बी मी पाणी काढस; तीच पोर परमेश्वरनी मना मालकना पोऱ्याकरता नेमेल शे अश ठरो. ");
INSERT INTO ahr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","मी मना मनमा हाई बोली राहिंतु तितलामा रिबका खांदावर घागर लिसन तठे वनी अनी तीनि विहिरमा उतरीसन पाणी भरं, मंग मी तिले बोलनु, माले थोडं पाणी पेवाले देय. ");
INSERT INTO ahr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","तिनी लगेच आपला हातवर घागर उतारीन सांगं, तू पी अनी तुना उंटसले बी मी पाणी पाजस, तवय मी पाणी पिनु अनं तिनी मना उंटसले बी पाणी पाजं. ");
INSERT INTO ahr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","मंग मी तिले इचारनु, तू कोणी पोर शे? ती बोलनी नाहोरपाईन मिल्काले व्हयेल बथुवेलनी मी पोर शे? तवय मी तिना नाकमा नथ अनं हातमा बांगड्या घालात. ");
INSERT INTO ahr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","मी नमीसन परमेश्वरले स्तवन करा अनी मना मालकनी भाऊनी पोर त्याना पोऱ्याकरता लई जावो म्हणीसन मना मालक अब्राहाम याना देव यहोवा यानी माले सरळ वाट दखाडी म्हणीन मी त्यानं स्तवन करा. ");
INSERT INTO ahr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","तर आते मना मालकसंगे कृपातीन अनं खरापणतीन वागशात तर माले तश सांगा, नही व्हई तर तश सांगा, म्हणजे मी ठरावसु माले काय करानं शे. ");
INSERT INTO ahr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","तवय लाबान अनी बथुवेल यासनी उत्तर दिधं, हाई परमेश्वरनी योजना शे; म्हणीसनं आमनाघाई तुमले चांगलं न वाईट काही बोलता नही ई ऱ्हाईनं. ");
INSERT INTO ahr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","दखा, रिबका तुमनापुढे शे; तिले लई जा; परमेश्वरनी सांगेलप्रमानी ती तुमना मालकना पोऱ्यानी बोयको होऊ द्या. ");
INSERT INTO ahr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","अब्राहामनं सेवकनी त्यासनं हाई शब्द आयकं तवय त्यानी भुमीपावत झुकीसन परमेश्वरले नमन करं. ");
INSERT INTO ahr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","मंग त्या सेवकनी सोना रूपाना दागिना अनं कपडा काढिसन रिबकाले दिधं. अनी तिना भाऊ अनं तिनी माय यासले मुल्यवान वस्तु दिधात. ");
INSERT INTO ahr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","मंग त्यानी अनं त्यानासंगेना माणसंसनी जेवण करीसन रातले तठेच मुक्काम करं; सकासले उठावर तो बोलना, मना मालककडे जावाकरता माले निरोप द्या. ");
INSERT INTO ahr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","हाई ऐकीसन तिना भाऊ अनं तिनी माय हाई बोलनात, पोरले आमनाजोडे थोडं दिन, निदान दहा दिन राहु द्या; मंग ती तुमनासंगे ई; ");
INSERT INTO ahr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","पण तो त्यासले बोलना, परमेश्वरनी मना प्रवास सफल करेल शे, \"तर माले थांबाडू नका; माले निरोप द्या, माले मना मालककडे जावु द्या.\" ");
INSERT INTO ahr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","तवय त्या बोलनात, आम्हीन पोरले बलाईसन ईचारतस ती काय म्हणस. ");
INSERT INTO ahr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","त्यासनी रिबकाले बलाईसन ईचारं, तू हाई माणुसनासंगे जास का? ती बोलनी, \"हा मी जास.\" ");
INSERT INTO ahr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","मंग त्यासनी आपली बहीण रिबका, तिनी दासी, अब्राहामना सेवक अनं त्याना माणसे यासले वाट लायं. ");
INSERT INTO ahr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","त्यासनी रिबकाले आशिर्वाद दिसन बोलनात, \"हे आमनी ताई, तु हजारोसनी अनी लाखोसनी माय बन,\" अनं तुनी संतती आपला वैरीसना नगरंसना अधिकारी बनोत. ");
INSERT INTO ahr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","मंग रिबका अनं तिना मैत्रीन उठन्यात अनी उंटवर बसीन त्या माणुसन्या मांगे गयात; अस प्रकारे तो माणुस रिबकाले लई गया. ");
INSERT INTO ahr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","इकडे इसहाक रानमाईन लहाय-रोई विहिरकडीन येयल व्हता; तो दक्षिणले कनानमा राही राहिंता. ");
INSERT INTO ahr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","इसहाक हाऊ संध्याकाळना येळले रानमा फिराले जायेल व्हता, त्यानी नजर वर करीसन दखं, ते त्याले उंट येतांना दखायनात. ");
INSERT INTO ahr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबकानी नजर वर करीसन इसहाकले दखं, तवय ती उंटवरतीन उतरनी. ");
INSERT INTO ahr_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","तिनी त्या सेवकले ईचारं, हाऊ रानमा आपला समोर ई राहिना तो कोण शे? सेवक तिले बोलना, हाऊ मना मालक शे, तवय तिनी बुरखा लिसन आपलं आंग झाकी लिधं. ");
INSERT INTO ahr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","तवय सेवकनी आपण जे काही करं ते सर्व इसहाकले सांगं, ");
INSERT INTO ahr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","मंग इसहाकनी रिबकाले आपली माय सारा हिना तंबूमा आणं अनी त्यानी तिनासंगे लगीन करीन तिनावर प्रेम करं; हाई प्रकारं आपली मायना मृत्युना बदलामां बी इसहाकले शांती भेटनी. ");
INSERT INTO ahr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","अब्राहामनी दुसरी बायको करी, तिन नाव कटूरा व्हतं, ");
INSERT INTO ahr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","तिले त्यानापाईन जिम्रान, यक्षान, मदान, मिद्यान, इश्बाक अनं शुह ह्या पोऱ्या व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","यक्षानानले शबा अनं ददान ह्या पोऱ्या व्हयनात; अनी ददानना पोऱ्या अश्शुरी, लटूशी अनं लऊमी ह्या व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिद्यानना पोऱ्या एफा, एफर, हनोख, अबीदा, अनं एल्दा ह्या व्हतात. हया सर्व कटूरना वंश. ");
INSERT INTO ahr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","अब्राहामनी सर्वकाही इसहाकले दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","अनी अब्राहामले उपपत्न्या व्हत्यात त्यासन्या पोऱ्यासले त्यानी देणग्या दिसन आपला जीवमा जीव व्हतं तोपावत आपला पोऱ्या इसहाक यानापाईन येगळं करीसन पुर्व दिशाले धाडी दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहामनं आयुष्यनं सर्व वरीस एकशेपंचाहत्तर व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","अब्राहाम पुरं आयुष्य जगना म्हणजे म्हतारा व्हईसन मरण पावना, अनं आपला पुर्वजसले जाईन भेटना. ");
INSERT INTO ahr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","मंग त्याना पोऱ्या इसहाक अनं इश्माएल यासनी त्याले एफ्रोन बिन सोहर हित्ती याना मम्रेनासमोरनी वावरमाधली मकपेलना गुहामा मूठमाती दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","हाई शेत अब्राहामनी हेथीपाईन ईकत लियेल व्हतं, अनी तठेच अब्राहाम अनं त्यानी बायको सारा यासले मूठमाती दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहामना मृत्युनंतर देवनी त्याना पोऱ्या इसहाकले आशिर्वाद दिधा; जो त्या येळले लहाय-रोई विहिरनाजोडे ऱ्हाई राहिंता. ");
INSERT INTO ahr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","सारानी मिसरी दासी हागार हिनापाईन अब्राहामले इश्माएल नावना पोऱ्या व्हयना, त्यानी हाई वंशावळी. ");
INSERT INTO ahr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इश्माएलना पोऱ्यासना नावे त्यासना वंशप्रमाणे ह्या शेतस, नबायोथ, हाऊ इश्माएलना पहिला पोऱ्या अनी केदार, अदबील, मिबसाम, ");
INSERT INTO ahr_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्मा, दुमा, मस्सा, ");
INSERT INTO ahr_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नापीश अनं केदमा. ");
INSERT INTO ahr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ह्या इश्माएलना पोऱ्या व्हतात; त्यासना गाववरीन अनं गोटावरीन त्यासले ह्या नावे पडेल शेतस, ह्या आपापला वंशना बारा सरदार व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्माएलना आयुष्यना वय वरीस एकशेसदतीस व्हवावर तो मरण पावना अनं आपला पुर्वजसले जाईन भेटना. ");
INSERT INTO ahr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","त्यानं वंशज हवीलापाईन शूर देशपावत वस्ती करीसन राहिनात; हाऊ देश मिसरना पुर्वले राहीसन अश्शुरकडे जातांना लागस; अश प्रकारे तो आपला भाऊबंधूसना देखत पुर्वले जाईसनं राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहामना पोऱ्या इसहाक यानी वंशावळी हाई शे, अब्राहामनी इसहाकले जन्म दिधा. ");
INSERT INTO ahr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","इसहाक चाळीस वरीसना व्हयना तवय त्यानी अरामी लाबान यानी बहिण पदन-अरामना माधलं अरामी बथुवेल यानी पोर रिबका हाई बायको करी. ");
INSERT INTO ahr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","इसहाकनी आपली बायको करता परमेश्वरकडे प्रार्थना करी, कारण ती वांझ व्हती; परमेश्वरनी त्यानी प्रार्थना ऐकी अनी त्यानी बायको रिबका गर्भवती व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","पण तिना गर्भमा पोऱ्या एकमेकसना संगे भांडण कराले लागनात, तवय ती बोलनी, माले काबंर अश व्हई राहिनं शे? हाई काय शे म्हणीसन ती परमेश्वरले ईचाराले गई. ");
INSERT INTO ahr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","परमेश्वर तिले बोलना, तुना गर्भमा दोन राष्ट्र शेतस; तुना उदरमाईन दोन वंश निंघतीन; एक वंश दुसरा वंशपेक्षा शक्तीशाली व्हई; अनी मोठा धाकलानी सेवा करी. ");
INSERT INTO ahr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","तिना प्रसूतिना दिन भरानी येळ वनी; तवय दखा, तिना उदरमा दोन जुळा पोऱ्या व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","पहिला पोऱ्या लाल रंगना व्हता अनी त्याना सर्वा आंग केसना वस्त्रनामायक व्हतं; त्यानं नाव एसाव ठेवात. ");
INSERT INTO ahr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","त्यानानंतर त्याना भाऊ जन्मना; एसावनी टाच त्याना हातमा व्हती; त्यानं नाव याकोब अश ठेवात (टाच धरनारा किंवा युक्तीमा हिराई लेणारा) तिनी त्याले जन्म दिधा तवय इसहाक साठ वरीसना व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","त्या पोऱ्या मोठा व्हयनात, एसाव हाऊ रानमा फिरनारा हुशार पारधी व्हयना; अनं याकोब हाऊ तंबूमा राहनारा साधा माणुस व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","एसाव मास आणे ते इसहाकले भलतं आवडे म्हणीसनं तो त्याले आवडे, पण याकोब रिबकाना आवडता व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","एकदाव याकोबनी वरण बनाडेल व्हतं, तवय एसाव रानमाईन थकी बंगीसन वना. ");
INSERT INTO ahr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","तवय एसावनी याकोबले सांगं, ते लाल दखास ना, त्यानामाईन लवकर माले खावाले आण, मी भयान गळी जायेल शे; त्यावरीन त्यानं नाव अदोम (लाल) अश पडनं. ");
INSERT INTO ahr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","याकोब त्याले बोलना, पहिले तुना मोठा पणना हक्क माले मोबदला दे. ");
INSERT INTO ahr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसाव त्याले बोलना, दख, मी मराले टेकनु शे; तर माले मना मोठा पणना हक्कना काय उपयोग? ");
INSERT INTO ahr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","याकोब बोलना, तर आत्तेच मनासंगे शपथ खाय; तवय त्यानी शपथ खाईन आपला मोठा पणना हक्क याकोबले मोबदला दिधा. ");
INSERT INTO ahr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","तवय याकोबनी एसावले भाकर अनं मसुरनं वरण दिधं; तो खाईपिसन उठना अनं चालता व्हयना; अस प्रकारतीन एसावनी आपला मोठा पणना हक्क तुच्छ लेखं. ");
INSERT INTO ahr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","अब्राहामना येळले जस दुष्काळ पडेल व्हता तस दुसरा दुष्काळ आते देशमा पडना, तवय इसहाक हाऊ पलिष्टसना राजा अबीमलेख यानाकडे गरार नगरमा गया. ");
INSERT INTO ahr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","तवय परमेश्वरनी त्याले दर्शन दिसन सांगं, मिसर देशमा जाऊ नको; मी सांगस त्या देशमा ऱ्हाय. ");
INSERT INTO ahr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","तू हाईच देशमा ऱ्हाय, मी तुनासंगे ऱ्हासु, अनी तुले आशिर्वादित करसु; कारण हाऊ सर्वा देश मी तुले अनं तुना संतानले दिसु; अनी मी तुना बाप अब्राहाम यानासंगे खायेल शपथ करी करसु. ");
INSERT INTO ahr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","मी आकाशमाधली तारासना इतली तुनी संतान वाढावसु, हाई सर्व तुना संतानले दिसु, अनी पृथ्वीवरना सर्व राष्ट्र तुना संतानमुये आशिर्वादित व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","कारण अब्राहामनी मना शब्दले मान दिधा, मना सांगानं ऐकं, मना आज्ञा, मना नियम अनं कायदा पाळात. ");
INSERT INTO ahr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","तवय इसहाक गरार नगरमां वस्ती करीसनं राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","तठला लोकसनी त्यानी बायकोबद्दल ईचारं तवय तो बोलना, हाई मनी बहिण शे; त्यानी हाई इचार करीसन अश सांगं, कारण त्याले भिती वाटनी की, जर मी तिले मनी बायको म्हणसु, तर या लोके रिबकामुये माले मारी टाकतीन कारण ती देखणी शे. ");
INSERT INTO ahr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","तो तठे बराच काळ राहावावर एक दिनले पलिष्टसना राजा अबीमलेख यानी खिडकीमाईन दखं की, इसहाक आपली बायको रिबकानासंगे प्रेमगोष्टी करतांना त्याले दिसनात. ");
INSERT INTO ahr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","तवय अबीमलेखनी त्याले बलाईसन ईचारं, खरेच हाई तुनी बायको शे, तर हाई मनी बहीण शे, अश तू काबंर सांगनास? इसहाकनी त्याले सांगं, मी अश इचार करं की, तिनामुये मी मराले नही पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमलेख बोलना, तू आमनासंगे अश का बर करं? बरं व्हयनं नहीते ह्या लोकेसमाईन कोणी तुनी बायकोजोडे सहज जाता अनी तू आमले दोष देता. ");
INSERT INTO ahr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","मंग अबीमलेखनी लोकसले अशी ताकीद दिधी की, जो कोणी या माणुसले किंवा त्यानी बायकोले हात लावं त्याले खरच कठोर शिक्षा व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","इसहाकनी त्या देशमा धान्यसनी पेरणी करी अनी त्याले त्याच वरीसले पिक मिळनं, अनी परमेश्वरनी त्यानं भलं करं. ");
INSERT INTO ahr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","तो धनवान व्हयना अनी कायमनाच धनवान व्हत गया, आठेपावत की, तो खुपच मोठा व्हई गया. ");
INSERT INTO ahr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","कारण त्यानाजोडे मेंढरं बकरं, गाय बैल अनी बराच दासदासी व्हई जायेल व्हतात म्हणीसनं पलिष्टी लोक त्याना हेवा कराले लागनात. ");
INSERT INTO ahr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","त्याना बाप अब्राहाम याना येळले त्याना दाससनी ज्या विहिर खोदेल व्हतात, त्या सर्व पलिष्टीसनी मातीघाई बुंजी दिधात. ");
INSERT INTO ahr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","अबीमलेख इसहाकले बोलना, तू आमनामाईन निंघी जाय, कारण तू आमनातीन सामर्थ्यवान व्हई जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","तवय इसहाक तठेन निंघी गया अनी गरार खोरामा तंबू करीसन तठे राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","तवय इसहाकनी पाणीन्या त्या विहिरीसले परत खोद्यात ज्या त्याना बाप अब्राहामना येळले खोदेल व्हत्यात, अनी जिसले पलिष्टीसनी अब्राहामना मृत्यूनंतर बुजी टाकेल व्हतं, अनं त्यानी तिसले परत त्यानं नावे दिधात ज्या त्याना बापनी देयल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","इसहाकना दास त्या खोरामा खंदी राहिंतात तवय त्यासले जिवत पाणीना झरा सापडना. ");
INSERT INTO ahr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","तवय गरार आठला गुराखी इसहाकना गुराखीसंगे भांडाले लागनात, अनं बोलनात, हाई पाणी आमनं शे; तेनावरीन त्यानी ती विहिरनं नाव एसेक (कलह) ठेवा; कारण त्यासनी त्यानासंगे भांडण करा. ");
INSERT INTO ahr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","मंग त्यासनी दुसरी विहिर खोदी, तिनावर बी त्या भांडनात म्हणीन त्यानी तिनं नाव सितना (वैर) ठेवात. ");
INSERT INTO ahr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","तो तठेन पुढे गया, अनी तठे त्यानी आखो एक विहिर खोदी; तवय तिनावरीन त्या भांडनात नहीत, म्हणीन त्यानी तिनं नाव रहोबोथ (विस्तार) अश ठेवा, अनी तो बोलना, परमेश्वरनी आमनं भूमीना विस्तार करेल शे आते हाई देशमा आमनी वाढ व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","तवय तो तठेन बैर-शेबा आठे गया. ");
INSERT INTO ahr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","त्याच रातले परमेश्वरनी त्याले दर्शन दिसन सांगं, मी तुना बाप अब्राहाम याना देव शे; भिऊ नको, कारण मी तुनासंगे शे; मी मना दास अब्राहाम यानामुये तुले आशिर्वादीत करसु अनं तुनी संतान बहुगुणित करसु. ");
INSERT INTO ahr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","मंग त्यानी तठे एक वेदी बांधी अनी परमेश्वरनी नावनी अराधना करी; अनं तठे त्यानी आपला तंबू उभा करा, तठे इसहाकना दाससनी एक विहिर खोदी. ");
INSERT INTO ahr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","तवय अबीमलेख आपला मित्र अहुज्जाथ अनं आपला सेनापती पीकोल याले संगे लिसन गरारमाईन त्यानाकडे गया. ");
INSERT INTO ahr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","तवय इसहाक त्याले बोलना, तुम्हीन तर मना द्वेष करतस, अनी तुम्हीन माले तुमनामाईन काढी दिधं; अश राहीसन बी तुम्हीन मनाकडे काबंर वनात? ");
INSERT INTO ahr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","त्यासनी सांगं, परमेश्वर तुमनासंगे शे हाई आमले स्पष्ट दखाई राहिनं शे; म्हणीन आम्हीन हाई इचार करा की, आपलामा म्हणजे आमनामा अनं तुमनामा हाई शपथ लेवाले पाहिजे, म्हणजे आमी तुमनासंगे हाई करार करानं. ");
INSERT INTO ahr_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","आम्हीन तुमले काही उपद्रव करा नही; आम्हीन फक्त तुमनं बरं करा अनं तुमले शांतीमा निरोप दिधा, तश तुम्हीन बी आमनं वाईट करानं नही; आते तुमनावर परमेश्वरना आशिर्वाद शे. ");
INSERT INTO ahr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","तवय त्यानी त्यासले मेजवानी दिधी, अनी त्यासनं खानं पिनं व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","त्यासनी पहाटमाच उठीन एकमेकसंगे शपथ लिधी; मंग इसहाकनी त्यासले निरोप दिधा. अनी त्या त्यानापाईन शांतीमा गयात. ");
INSERT INTO ahr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","त्याच दिनले अश व्हयनं की, इसहाकना दास जी विहिर खोदी राहिंतात तिनाबद्दल त्यासनी खबर आणी की विहिरले पाणी लागनं. ");
INSERT INTO ahr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","त्यानी तिनं नाव शेबा ठेवा. तिनावरीन त्या नगरना नाव बैर-शेबा पडनं ते आजपावत चालू शे. ");
INSERT INTO ahr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","एसाव चाळीस वरीसना व्हयना तवय त्यानी बैरी हित्ती यानी पोर यहूदीथ अनी एलोन हित्ती यानी पोर बासमथ ह्या बायका कऱ्यात; ");
INSERT INTO ahr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","अनी या सुनासमुये इसहाक अनं रिबका यासले दु:ख व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","इसहाक म्हतारा व्हयना अनी त्यानी नजर इतली कमजोर व्हयनी की, त्याले काही दखावाले लागनं नही. तवय त्यानी एक दिनले आपला मोठा पोऱ्या एसाव याले बलाईसन सांगं, की, बाळा, तो बोलना, काय बाबा? ");
INSERT INTO ahr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","तो त्याले बोलना, दख, मी आते म्हतारा व्हई जायेल शे; अनी माले मरण कवय ई जाई सांगता येस नही. ");
INSERT INTO ahr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","तर तू आपला हत्यार, आपला धनुष्य अनं भाता लिसन रानमा जाय अनी शिकार करीसन मनाकरता मास लई ये. ");
INSERT INTO ahr_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","अनी मना आवडीना स्वादिष्ट भोजन तयार करीसन आण; मी ते खासु अनी मंग मराना पहिले तुले आशिर्वाद दिसु. ");
INSERT INTO ahr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","इसहाक आपला पोऱ्या एसाव यानासंगे बोली राहिंता तवय रिबका ऐकी राहिंती, मंग एसाव शिकार कराले रानमा गया. ");
INSERT INTO ahr_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","इकडे रिबका आपला पोऱ्या याकोब याले बोलनी, दख, मी तुना बापले तुना भाऊ एसावसंगे अश बोलतांना ऐकं की, ");
INSERT INTO ahr_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","शिकार करीसन स्वादिष्ट भोजन तयार करीसन आण, म्हणजे मी ते खाईन मराना पहिले तुले परमेश्वरना समक्ष तुले आशिर्वाद दिसु. ");
INSERT INTO ahr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","तर मना बाळा, आते मी तुले सांगस ते ऐक; मना सांगानाप्रमाणे कर. ");
INSERT INTO ahr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","आत्तेनी आत्ते कळपमा जाय अनी त्यामाईन बकरीना दोनली बच्चा लई ये; म्हणजे मी त्यासनं तुना बापनं आवडतं स्वादिष्ट जेवण बनाडसु. ");
INSERT INTO ahr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","मंग ते तुना बापले लई जाय, म्हणजे तो ते जेवण खाईन मराना पहिले तुले आशिर्वाद दि. ");
INSERT INTO ahr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","यावर याकोब त्यानी माय रिबकाले बोलना, दख, मना भाऊ एसाव केसाळ माणुस शे, अनी मी तर बिगर केसना माणुस शे. ");
INSERT INTO ahr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","मना बाप माले कदाचित चापलीसनं दखी अनी मी त्याले फसाडी राहिनु शे अस त्याले दिसी मंग आशिर्वादना बद्लामा मी मनावर शाप लई ईसु. ");
INSERT INTO ahr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","त्यानी माय त्याले बोलनी, मना बाळा, तुले शाप भेटना तर तो माले लागो; पण मना एवढं सांगनं ऐक अनं बकरीनं पिल्लासले ली ये. ");
INSERT INTO ahr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","तवय त्यानी जाईसन ते आपली मायनाजोडे आणं अनी तिनी त्याना बापना आवडीना भोजन बनाडं. ");
INSERT INTO ahr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","मंग रिबकानी आपला मोठा पोऱ्या एसावना उत्तम वस्त्र लिसन ज्या त्याना घरमा व्हतात, आपला धाकला पोऱ्या याकोब याले घालात. ");
INSERT INTO ahr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","तिनी त्याना हातले अनं मानना गुळगुळीत भागले पिल्लासनी कातडी चिटकाडी दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","अनी आपला हातघाई बनाडेल स्वादिष्ट भोजन अनं भाकर आपला पोऱ्या याकोब याना हातमा दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","तवय याकोब आपला बापनाजोडे जाईसन बोलना, बाबा, तवय इसहाक बोलना, मी आठे शे? मना बाळा तू कोण शे? ");
INSERT INTO ahr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","तवय याकोब त्याना बापले बोलना, मी तुमना मोठा पोऱ्या एसाव शे? जस तुम्हीन माले सांगेल व्हत, तसच मी करेल शे, तर उठीन बसा अनी मास आणेल शे, एवढं खा; अनी तुम्हीन माले आशिर्वाद द्या. ");
INSERT INTO ahr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","तवय इसहाक आपला पोऱ्याले बोलना, मना बाळा तुले शिकार इतलं लवकर कश भेटनं? तो बोलना, आपला देव यहोवा यानी माले ते लवकर मिळु दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","मंग इसहाक याकोबले बोलना, मना बाळा, तू मनाजोडे ये; तू मना पोऱ्या एसावच शे की नही हाई माले चापलीसनं दखु दे. ");
INSERT INTO ahr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","तवय याकोब आपला बाप इसहाकनाजोडे गया; तो चापलीसनं बोलना, आवाज तर याकोबना शे पण हात तर एसावना शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","त्याना हात त्याना भाऊ एसाव याना हातनासारखा केसाळ व्हतात म्हणीन त्यानी त्याले वळख नही अनी त्याले आशिर्वाद दिधा. ");
INSERT INTO ahr_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","तो त्याले बोलना, तू मना पोऱ्या एसावच शे ना? तो बोलना, हा, मी तोच शे. ");
INSERT INTO ahr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","तवय त्यानी सांगं, भोजन मनजोडे लई ये; मी मना पोऱ्यानाद्वारा करेल शिकारना मास खासु मंग मी तुले आशिर्वाद दिसु. याकोबनी जेवण त्यानाजोडे आणं अनी त्यानी ते खादं, त्यानी त्यानाकरता द्राक्षरस बी आणा अनी त्यानी ते पिदं. ");
INSERT INTO ahr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","मंग त्याना बाप इसहाक त्याले बोलना, \"हे मना पोऱ्या जरासा जोडे ईसन मना मुका ले.\" ");
INSERT INTO ahr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","त्यानी जोडे जाईन त्याना मुका लिधात; तवय त्याना वस्त्रना वास लिसन असा आशिर्वाद दिधा, \"मना पोऱ्याना सुगंध त्या शेतना सुगंधनामायक शे, ज्याले परमेश्वरनी आशिर्वाद देयल शे. ");
INSERT INTO ahr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","देव तुले आकाशतीन ओस अनी पृथ्वीवरनी सुपीक जमीनी अनी विपुल धान्य अनं द्राक्षरस देवो; ");
INSERT INTO ahr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","राज्य राज्यना लोके तुनी सेवा करोत; अनी वंशना लोके तुले नमन करोत; तू आपला भाऊबंदसना मालक हो; मायना पोऱ्या तुले नमन करोत; जो तुले शाप दि त्या सर्वा शापीत व्हवोत; अनी जो तुले आशिर्वाद दि त्या सर्वा आशिर्वादीत व्हवोत.\" ");
INSERT INTO ahr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","तवय अश व्हयनं की, इसहाक याकोबले आशिर्वाद देवानं व्हवावर याकोब आपला बाप इसहाक यानाजोडेतीन जास नही तोच त्याना भाऊ एसाव शिकारवरीन वना. ");
INSERT INTO ahr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","त्यानी बी स्वादिष्ट भोजन तयार करीसन आपला बापनाजोडे आणा, अनं त्याले बोलना, मना बाबानी उठीन आपला पोऱ्यानी आणेल हरणनं मास खावं, अनी माले आशिर्वाद द्यावं. ");
INSERT INTO ahr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","हाई ऐकीसन त्याना बाप इसहाक त्याले बोलना, तू कोण शे? त्यानी सांगं, मी तुमना पोऱ्या, तुमना मोठा पोऱ्या एसाव शे. ");
INSERT INTO ahr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","तवय इसहाक भयान थरथरीन बोलना, तर शिकार करीन आणेल मास जो मनाकडे लिसन वना, अनी तू येवाना पहिले मी ते खाईसन ज्याले आशिर्वाद दिधा तो कोण? तो आशिर्वादित व्हईच. ");
INSERT INTO ahr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","एसावनी आपला बापना हाई शब्द ऐका तवय तो भलता दु:खमा रडना अनी आपला बापले बोलना, माले बी आशिर्वाद द्या. ");
INSERT INTO ahr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","तो त्याले बोलना, तुना भाऊनी कपटतीन ईसन तुले भेटनारा आशिर्वाद ली गया. ");
INSERT INTO ahr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","तवय एसाव बोलना, त्यानं नाव याकोब हाई बरोबरच ठेयल शे की नही? कारण त्यानी माले दोनदाव दगा देयल शे, त्यानी मना ज्येष्ठपणना आधिकार बी ली लिधा अनी आते मना आशिर्वाद बी काढी लेयल शे; तर तुम्हीन मनाकरता बी काहीच आशिर्वाद राखी ठेवं नही का? ");
INSERT INTO ahr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाकनी एसावले सांगं, मी त्याले तुना मालक करी ठेयेल शे, त्याना सर्वा भाऊ त्याना सेवक करेल शेतस अनी धान्य अनं द्राक्षरस यासनायोगे त्याले मी समृध्द करेल शे; तर मना बाळा, मी तुनाकरता आते काय करू? ");
INSERT INTO ahr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसाव बापले बोलना, बाबा, तुमनाजोडे एकच आशिर्वाद शे का? बाबा माले बी आशिर्वाद द्या, अनी एसाव जोरजोरमा रडाले लागना. ");
INSERT INTO ahr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","तवय त्याना बाप इसहाक त्याले बोलना, दख, पृथ्वीवरनी सुपीक जमीनपाईन दूरतीन आकाशमाईन दव पडस तठेन दूर तुनी वस्ती व्हई; ");
INSERT INTO ahr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तू आपली तलवारघाई जगशी, अनं आपला भाऊसना नोकर व्हसी, तरी अश व्हई की, जवय तू निराश व्हसी तवय आपला खांदावरना त्याना जु तोडी टाकशी. ");
INSERT INTO ahr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","याकोबले आपला बापनी आशिर्वाद दिधा त्यामुये एसावनी त्यानासंगे वैर धरं; एसावनी आपला मनमा सांगं, मना बापनं मरणनं दिन जोडे येल शे, त्यानानंतर मी आपला भाऊ याकोबले मारी टाकसु. ");
INSERT INTO ahr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","आपला मोठा पोऱ्या एसाव यानं म्हणनं रिबकाले सांगाम वनं, तवय तिनी आपला धाकला पोऱ्या याकोब याले बलाईसन सांगं, दख, तुले मारी टाकना बेत करीसन तुना भाऊ एसाव आपला समाधान करी ली राहिना शे. ");
INSERT INTO ahr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","तर मना बाळा, आते मना ऐक: ऊठ, हारान आठे मना भाऊ लाबान शे, त्यानाकडे पळी जाय, ");
INSERT INTO ahr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","अनी तुना भाऊना तुनावरना राग जास तोपावत थोडा दिन त्यानाजोडे राय. ");
INSERT INTO ahr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","तुना भाऊना तुनावरना राग जाईसन तू त्यानासंगे जे करं त्याना त्याले विसर पडस नही तोपावत तू तठेच राय; मंग मी तुले तठेन बलाई लयसु; एकच दिनले तुम्हीन दोन्ही बी मनापाईन काबंर दूर व्हवाले पाहिजेत. ");
INSERT INTO ahr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","\"तवय रिबका इसहाकले बोलनी, या हेथीसन्या पोरीमुये माले मना जीव नको व्हई राहिना शे, जर याकोब बी त्या देशमाधल्या पोरीमाईन एकादी हेथी पोरनासंगे लगीन करी लिधं, तर मना जगीन काय फायदा शे?\" ");
INSERT INTO ahr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","तवय इसहाकनी याकोबले बलाईसन आशिर्वाद दिधा अनी बजाईसन सांगं, की, कनानी पोरीसमाईन बायको करानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","तर ऊठ पदन-अराम आठे तुनी मायना बाप बथुवेल याना घर जाय अनं तुना मामा लाबान याना पोरीसमाईन बायको कर. ");
INSERT INTO ahr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","सर्वसमर्थ देव तुले आशिर्वाद देवो, तुले फलद्रूप करीसन तुनी वंशवृध्दी अस कराले पाहिजे की, तुनापाईन राष्ट्रसमुदाय निर्माण व्हवो. ");
INSERT INTO ahr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","तो तुले अनं तुनाबराबर तुना संतानले अब्राहामले दियेल आशिर्वाद देवो, म्हणजे देवनी अब्राहामले देल देश ज्यामा तू आते प्रवासी राहिना शे, तो तुना वतन व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","अश प्रकारमा इसहाकनी याकोबले निरोप दिधा, अनी याकोब पदन-अराम आठे लाबानजोडे निंघी गया, जो अरामी बथुवेलना पोऱ्या व्हता अनी याकोब अनी एसाव यासनी माय रिबकाना भाऊ व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","एसावनी दखं, की, इसहाकनी याकोबले आशिर्वाद दिसन पदन-अराम आठे बायको कराकरता तिकडे धाडेल शे; अनी आशिर्वाद देवाना येळले त्यानी त्याले बजाईसन सांगेल शे की, कनानी पोरीसमाईन बायको करानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","अनी याकोब आपला मायबापसनी आज्ञा मानीसन पदन-अरामले जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","एसावनी दखं, की, आपला बाप इसहाक याले कनानी पोरी पसंद नहीत हाई जाणीसन, ");
INSERT INTO ahr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","तो इश्माएलकडे गया अनी त्यानी इश्माएल बिन अब्राहाम यानी पोर अनं नबायोथनी बहीण महलथ हिनासंगे लगीन करीसन तिले आपला बायकोसमा सामील करं. ");
INSERT INTO ahr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","तवय याकोब बैर-शेबा आठेन हारानले जावले निंघना. ");
INSERT INTO ahr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","तो एक ठिकाणमा पोहचना तवय सुर्य मावळना म्हणीन तठेच मुक्काम करानी हाई विचारमा तठला एक धोंडा उसाले लिसन तो त्याच ठिकाणमा झोपी गया. ");
INSERT INTO ahr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","तवय त्याले सपन पडनं त्यामा त्यानी दखं की, एक शिडी पृथ्वीवर उभी करेल शे अनी तिना शेंडा आकाशले लागेल शे; अनी देवदूत तिनावरीन येजा येजा करी राहिना शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","अनी दखा, परमेश्वर त्यानाजोडे उभा राहिनं त्याले बोलना, मी परमेश्वर तुना बाप अब्राहाम याना देव अनं इसहाकना देव शे; ज्या भुमीवर तू निजेल शे, ती मी तुले अनं तुनी संतानला दिसु. ");
INSERT INTO ahr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","तुनी संतती पृथ्वीनी धुळनीसारखी व्हई, पुर्व, पश्चिम, उत्तर अनं दक्षिण अश चारी दिशासले तुना विस्तार व्हई, अनी तुना अनं तुनी संततीनाद्वारा पृथ्वीना सर्वा कुळं आशिर्वादित व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","दख, मी तुनासंगे शे; जिकडे तू जाशी त्या सर्वा ठिकाणमा मी तुना संरक्षण करसु अनी तुले हाई देशमा परत आणसु; तुले सांगेल ते करस तोपावत मी तुले सोडावु नही. ");
INSERT INTO ahr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","मंग याकोब झोपमाईन उठीन बोलना, खरंच हाई ठिकाणमा परमेश्वर शे, पण माले समजेल नव्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","तो घाबरी गया अनं बोलना, कितला भयानक ठिकाण शे हाई, हाई प्रत्यक्ष देवनं घर, स्वर्गनं दार शे! ");
INSERT INTO ahr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","याकोब पहाटमाच उठना अनी जो धोंडा त्यानी उसाले लेयेल व्हता त्याना त्यानी स्मारकस्तंभ उभा करा अनी त्यानावर तेल ओतं. ");
INSERT INTO ahr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","अनी त्यानी त्या ठिकाणना नाव बेथेल अस ठेवात. सुरवातले त्या नगरना नाव लूज अस व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","याकोबनी अस नवस करा की, जर परमेश्वर मनासंगे राही, अनी ज्या वाटतीन मी जाई ऱ्हायनु शे तिमा मना संरक्षण करी अनी माले खावाले अन्न अनं घालाले कपडा दि, ");
INSERT INTO ahr_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","अनी मी आपला बापना घर सुखरूप वापस वना तर परमेश्वर मना देव व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","अनी हाऊ धोंडा मी स्मारकस्तंभ म्हणीन उभा करेल शे, तो देवनं घर व्हई; अनी जे काही तू माले दिशी त्याना दशमांश मी तुले अवश्य अर्पण करसु. ");
INSERT INTO ahr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","तवय याकोब आपली वाटले लागना अनी पुर्वकडना लोकसना देशमा जाईन पोहचना. ");
INSERT INTO ahr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","तठे त्यानी दखं की, शेतमा एक विहिर शे; अनी तिना जोडे मेंढरंसना तीन कळप बसेल व्हतात; कारण लोके त्या विहिरनं पाणी काढीसन कळपले पाजेत, विहिरनं तोंडनाजोडे एक मोठा धोंडा ठेयेल व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","सर्व कळप एकजागेवर गोया व्हवावर विहिरना तोंडवरना धोंडा लोटीसन मेंढरंसले पाणी पाजेत अनी मंग तो परत त्याना जागमा विहिरना तोंडवर ठेई दियेत. ");
INSERT INTO ahr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याकोब त्यासले बोलना, मना बंधूसवन, तुम्हीन कोठला शेतस? त्या बोलनात, आम्हीन हारान गावना शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","मंग तो त्यासले ईचारना, तुम्हीन नाहोरना पोऱ्या लाबानले वळखतच का? त्या बोलनात, हा आम्हीन त्याले वळखतच. ");
INSERT INTO ahr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","तवय त्यानी सांगं, तो बरा शे का? त्या बोलनात, हा बरा शे, अनी ती दख, त्यानी पोर राहेल मेंढरंसले लिसन इकडे ई ऱ्हायनी शे. ");
INSERT INTO ahr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","त्यानी सांगं, दखा, दिन अजून बराच शे, जनावरंसले एकत्र गोया करानी येळ अजून व्हयेल नही, तर मेंढरंसले पाणी पाजा अनी चाराले परत लई जावा. ");
INSERT INTO ahr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","त्या बोलनात, तश आमले करता येस नही; सर्व कळप एकत्र गोया व्हवावर विहिरना तोंडवरना धोंडा लोटतस अनी मंग आम्हीन मेंढरंसले पाणी पाजतस. ");
INSERT INTO ahr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","तो त्यासनासंगे बोली राहिंता तवढामा राहेल आपला बापना मेंढरं लईसन तठे वनी; कारण ती मेंढरंसले चारे. ");
INSERT INTO ahr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","जवय याकोबनी आपला मामा लाबान यानी पोर राहेल अनी आपला मामानं मेंढरंसले दखं, तवय त्यानी जोडे जाईन विहिरना तोंडवरना धोंडा लोटीसन आपला मामा लाबान याना मेंढरंसले पाणी पाजा. ");
INSERT INTO ahr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","मंग याकोब राहेलना मुका लिसन जोरजोरमा रडना. ");
INSERT INTO ahr_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","याकोबनी राहेल ले सांगं, मी तुना बापना नातेवाईक, रिबकाना पोऱ्या शे; तवय ती पयत जाईसन आपला बापले हाई माहिती सांगी. ");
INSERT INTO ahr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","मंग अश व्हयनं की, लाबाननी आपला भाचा याकोब यानी खबर ऐकताच तो त्याले भेटाले धावत गया, अनी त्याले मिठ्ठी मारीसंन त्याना मुका लिधात; अनी त्याले आपला घर ली वना, तवय याकोबनी लाबानले सर्व हकीकत सांगी दखाडी. ");
INSERT INTO ahr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","तवय लाबान त्याले बोलना, हा तू खरोखर मना हाडमासना शे, याकोब त्यानाजोडे महिनाभर राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","तवय लाबान याकोबले बोलना, \"तू मना नातेवाईक म्हणीसनं फुकट मनी सेवा करानी का? तुनी मजुरी काय राही हाई माले सांग.\" ");
INSERT INTO ahr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबानले दोन पोरी व्हत्यात, मोठी पोरनं नाव लेआ अनी धाकली पोरनं नाव राहेल. ");
INSERT INTO ahr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लेआनं डोळा निस्तेज व्हतात, पण राहेल दिसाले सुरेख अनी देखणी व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकोबनं राहेलवर प्रेम व्हतं म्हणीसनं तो बोलना, आपली धाकली पोर राहेल हिनाकरता मी सात वरीस तुमनी सेवा करसु. ");
INSERT INTO ahr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","त्यानावर लाबान त्याले बोलना बरं ठिक शे, परका माणुसले देवापेक्षा हाई उत्तम शे, त्याकरता तु मनाजोडे राहाय. ");
INSERT INTO ahr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","तवय याकोबनी राहेल करता सात वरीस सेवा करी; अनी राहेलवर प्रेमना कारण त्याले ती सात वरीस फक्त थोडाच दिनसारखा वाटनात. ");
INSERT INTO ahr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","मंग याकोब लाबानले बोलना, आते मनी सात वरीसनी सेवा पुरी व्हयेल शे, आते माले मनी बायको वापस द्या म्हणजे मी तिनाजोडे जासु. ");
INSERT INTO ahr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","तवय लाबाननी तठला सर्वा लोकसले एकत्र गोया करीसन मेजवाणी दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","संध्याकायले अश व्हयनं की, त्यानी आपली पोर लेआ हिले याकोबना जोडे आणं, अनी तो तिनाजोडे गया. ");
INSERT INTO ahr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","लाबाननी आपली दासी जिल्पा, हिले आपली पोर लेआले दिधी, यानाकरता की, ती तिनी दासी व्हवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","सकाळ व्हयनी तवय याकोबनी दखं, की, हाई ते लेआ शे, तवय त्यानी लाबानले ईचारं, तू मनासंगे हाई काय करं? मी राहेलनाकरता तुमनी सेवा करी नही का? तरी तुम्हीन माले का बरं फसाड? ");
INSERT INTO ahr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","तवय लाबान त्याले बोलना, मोठी पोरना पहिले धाकली पोरना लगीन करानं हाई आमनाकडे रित नही शे. ");
INSERT INTO ahr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","हाऊ सप्ता पुरा व्होऊ दे, मंग आम्हीन ती पण तुले दिसुत, त्यानाबद्दल तुले अजून सात वरीस मनी सेवा करना पडी. ");
INSERT INTO ahr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","याकोबनी अश करीसन त्याना सप्ता पुरं करा, तवय लाबाननी आपली पोर राहेल याकोबले बायको करी दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबाननी आपली दासी बिल्हा हिले आपली पोर राहेल करता दासी म्हणीन दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","तवय याकोब राहेलना जोडे बी गया; पण लेआ पेक्षा राहेलवर त्यानं जास्त प्रिती व्हती म्हणीन तो लाबानजोडे अजून सात वरीस राहिन त्यानी सेवा करी. ");
INSERT INTO ahr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","मंग परमेश्वरनी दखं की, लेआ नावडती शे; म्हणीसनं त्यानी तिनी कूस वाहती करी अनी राहेल वांझ राहिनी. ");
INSERT INTO ahr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लेआ गर्भवती व्हईन तिले पोऱ्या व्हयना, त्यानं नाव तिनी रऊबेन ठेवं; ती बोलनी, परमेश्वरनी मना दु:खकडे नजर करेल शे, आते मना नवरा मनावर प्रिती करी. ");
INSERT INTO ahr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ती परत गर्भवती व्हईसन तिले पोऱ्या व्हयना, तवय ती बोलनी मी नापसंत शे हाई देवनी ऐकेल शे, म्हणीन त्यानी माले हाऊ एक पोऱ्या दियेल शे; तिनी त्यानं नाव शिमोन ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ती परत गर्भवती व्हईन तिले पोऱ्या व्हयना; तवय ती बोलनी, आते माले तीन पोऱ्या व्हयेल शेतस, आते तरी मना नवरा मनासंगे जडी राही; म्हणीसनं तिनी त्या पोऱ्यानं नाव लेवी ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ती आखो गर्भवती व्हईन तिले पोऱ्या व्हयना; ती बोलनी मी आते परमेश्वरनी आराधना करसु; यानावरीन तिनी त्यानं नाव यहूदा ठेवं; मंग पुढे तिले पोऱ्या व्हवानं थांबनं. ");
INSERT INTO ahr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","मंग राहेलनी दखं, की, याकोबले आपलापाईन काही पोऱ्यासोऱ्या व्हई नही राहिनात, तवय ती आपली बहीणना हेवा कराले लागनी अनी ती याकोबले बोलनी, तुम्हीन माले बी पुत्रवती करा, नही ते मी मरी जासु. ");
INSERT INTO ahr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","तवय याकोब राहेलवर संताप करीन बोलना, मी काय देवना जागवर शे का? म्हणीसनं तुले गर्भना फळपाईन वंचित ठेयेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","मंग ती बोलनी, दखा, हाई मनी दासी बिल्हा शे; हिनाजोडे जाय, म्हणजे हाई मनी मांडीवर प्रसूत व्हईसन हिनामुये मना घर नांदाले लागी. ");
INSERT INTO ahr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","तवय तिनी आपली दासी बिल्हा त्याले बायको करी दिधी अनी याकोब तिनाजोडे गया. ");
INSERT INTO ahr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","बिल्हा याकोबपाईन गर्भवती व्हईन तिले पोऱ्या व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","तवय राहेल सांगाले लागनी, देवनी मना न्याय करेल शे, अनी मना आवाज ऐकीसन माले एक पोऱ्या देल शे; म्हणीन तिनी त्यानं नाव दान ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","मंग राहेलनी दासी बिल्हा हाई याकोबपाईन परत गर्भवती व्हईन तिले दुसरा पोऱ्या व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","तवय राहेल बोलनी, मी आपली बहिणनासंगे खुप झगडा करीसन यश मियाडेल शे; अनी तिनी त्यानं नाव नफताली ठेवा. ");
INSERT INTO ahr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","जवय लेआ हिनी हाई दखं की, माले पोऱ्या व्हवानं थांबी जायेल शे, तवय तिनी आपली दासी जिल्पा याकोबले बायको करी दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","लेआ हिनी दासी जिल्पा हिले याकोबपाईन पोऱ्या व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","तवय लेआ बोलनी, मी कितली नशीबवान! अनी तिनी त्या पोऱ्यानं नाव गाद ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","लेआ हिनी दासी जिल्पा हिले याकोबपाईन दुसरा पोऱ्या व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","तवय लेआ बोलनी, मी कितली धन्य शे! बाकीन्या बाया माले धन्य म्हणतीन, म्हणीन तिनी त्यानं नाव आशेर ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गहूना कापणीना येळले रऊबेन शेतमा गया तवय त्याले तठे पुत्रदात्रीनं फळं भेटनात, ती त्यानी आपली माय लेआ हिनाजोडे आणीसन दिधी; तवय राहेल लेआले बोलनी, पुत्रदात्रीनं फळं तुना पोऱ्यानी आणेल शेतस त्यामाईन थोडसं माले बी दे. ");
INSERT INTO ahr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","पण ती तिले बोलनी, तू मना नवराले ली लियेल शे, हाई धाकली गोष्ट शे का? अनी आते तू मना पोऱ्यानी आणेल पुत्रदात्रीनं फळं बी लेवाले दखस का? मंग राहेल तिले बोलनी, बरं तुना पोऱ्यानी आणेल पुत्रदात्रीनं फळना बदलामा आज रातले तो तुनासंगे झोपी. ");
INSERT INTO ahr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","संध्याकायना येळले याकोब शेतमाईन घर वना तवय लेआ त्यानाजोडे जाईसन त्याले बोलनी, तुमले आज मनाजोडे येणच पडी; कारण मी खरंच तुमले मना पोऱ्यानी आणेल पुत्रदात्रीनं फळंसना बदलामा भाडातीन लियेल शे, तवय त्या रातले तो तिनासंगे झोपना. ");
INSERT INTO ahr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","देवनी लेआ हिनं ऐकं, अनी ती गर्भवती व्हईन याकोबपाईन तिले पाचवा पोऱ्या व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","तवय लेआ बोलनी, मी मनी दासी मना नवराले दिधी म्हणीसन देवनी माले हाई वेतन देल शे; अनी तिनी त्यानं नाव इस्साखार ठेवा. ");
INSERT INTO ahr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","याकोबपाईन लेआ परत गर्भवती व्हयनी तिले सहावा पोऱ्या व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","तवय लेआ बोलनी, देवनी माले उत्तम वरदानतीन संपन्न करेल शे, हाई खेपले मना नवरा मनासंगेच राही, कारण मी त्याना सहा पोऱ्यासले जन्म दियेल शे. म्हणीन तिनी त्यानं नाव जबुलून ठेवा. ");
INSERT INTO ahr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","त्यानानंतर तिले एक पोर व्हयनी तिनं नाव तिनी दीना ठेवात. ");
INSERT INTO ahr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","मंग देवनी राहेलनी प्रार्थना ऐकी; अनी त्यानी तिनं ऐकीसन तिनी कूस वाहती करी. ");
INSERT INTO ahr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ती गर्भवती व्हईन तिले पोऱ्या व्हयना; ती बोलनी, देवनी मनी निंदा व्हवानं दूर करेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","अनी तिनी त्यानं नाव योसेफ ठेईसन सांगं, परमेश्वर माले पोऱ्यानी अजून एक जोड देवो. ");
INSERT INTO ahr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","राहेलले योसेफ व्हयना तवय याकोब लाबानले बोलना, माले निरोप द्या म्हणजे मी स्वदेशी आपला ठिकाणमा जासु. ");
INSERT INTO ahr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मी ज्यासनाकरता तुमनी सेवा करी त्या मन्या बायका अनं पोऱ्या माले परत द्या म्हणजे मी जास, मी तुमनी सेवा कशी करेल शे हाई तुमले माहित शे. ");
INSERT INTO ahr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","तवय लाबान त्याले बोलना, तुनी मनावर कृपा व्हई तर आठेच मनासंगे राही जाय, तुनामुये परमेश्वरनी माले आशिर्वादित करेल शे, हाई माले समजी जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","आखो तो बोलना, तुना वेतन काय राही ते माले सांग, ते मी तुले दिसु. ");
INSERT INTO ahr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याकोब त्याले बोलना, मी तुमनी सेवा कशी करी अनी तुमना जनावरे मनाजोडे कशा व्हतात हाई तुमले चांगलं माहीत शे. ");
INSERT INTO ahr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","मी येवाना पहिले तुमनाजोडे थोडसं व्हतात, आते त्या कितला पट वाढी जायेल शेतस; जठे मना पाय लागना तठे परमेश्वरनी तुमले आशिर्वाद देयल शे. तर आते मी स्वत:ना घरदारना कवय दखु? ");
INSERT INTO ahr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","लाबान त्याले बोलना, मी तुले काय देऊ? याकोब बोलना, माले काहीच देऊ नका? मनी फक्त एकच गोष्ट मान्य करशात तर मी पहिलं सारखा तुमनं कळपले चारसु अनं त्यासना संभाळ करसु. ");
INSERT INTO ahr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","आज मी तुमना सर्वा कळपमा फिरीसन त्यामाईन मेंढरंसमा ठिपकादार, काबऱ्या, अनी काळा रंगना मेंढरं, तसच बकरीसमाईन ठिपकादार, अनं काबऱ्या रंगना बकऱ्या येगळा काढसु; हाईच मना वेतन राही. ");
INSERT INTO ahr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","जर सकाय उठीन तुम्हीन मना वेतनना हिशोब लेवाले वनात तर मनी इमानदारीनी साक्ष तुमले बी पटी; म्हणजे बकरीमाईन ज्या ठिपकादार, अनं काबऱ्या नहीत अनं मेंढरंमाईन ज्या काळा रंगना नहीत अश मनाजोडे निंघनात तर त्या चोरीना शेतस अश समजानं. ");
INSERT INTO ahr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","तवय लाबान बोलना, ठिक शे, तुना सांगाप्रमाणे होऊ दे. ");
INSERT INTO ahr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","तवय त्याच दिनले बांडे अनं ठिपकादार, एडके, थोडसं ढवळा रंगना सर्व ठिपकादार अनं काबऱ्या बकऱ्या, अनी मेंढरासमाईन सगयी काळी मेंढरं या येगळा करीसन लाबाननी आपला पोऱ्यासना हातमा सोपी दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","त्यानी आपलामा अनं याकोबमा तीन दिनना अंतर ठेवात; अनी याकोब लाबानना बाकीना उरेल कळप चारत राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","मंग याकोबनी लिबने, बदाम, अनी अर्मोन, ह्या झाडासन्या हिरव्या अनं कोवळ्या काठया काढात अनी त्यासन्या मजारन्या सालना ढवळा आंग उघडी करात. ");
INSERT INTO ahr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","त्या सोलेल काठया त्यानी त्या बकऱ्यासना समोर त्यासना पाणी पिवाना नालामा अनं कुंडामा ठेवात; अनी जवय त्या पाणी पिवाले जायेत तवय गाभन व्हई जायेत. ");
INSERT INTO ahr_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","त्या छड्यासना समोर बकऱ्या, मेंढ्या गाभन व्हत्यात तिसले बांडी, ठिपकादार, अनं काबऱ्या असा पिल्ला व्हई जायेत. ");
INSERT INTO ahr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","मंग याकोबनी मेंढरूसना पिल्लासले येगळं करं अनी लाबानना कळपमा माधला बांड्या अनं काळ्या मेंढरंकडे कळपनं तोंड करं; त्यानी आपला कळपले येगळं करं, लाबानना कळपमा ठेवं नही. ");
INSERT INTO ahr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","धष्टपुष्ट मेंढ्या गाभन व्हयेत तवय त्यासना नजरसमोर नालामा तो त्या छड्या ठि दे, याकरता की, त्यासनी त्या छडीसना दरम्यानमा गाभन व्हवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","मेंढ्या कमजोर राहिन्यात म्हणजे त्या छड्या त्यासनासमोर तो ठेय नही, या प्रकारमा दुबळ्या त्या लाबानन्या अनं धष्टपुष्ट त्या याकोबन्या व्हयन्यात. ");
INSERT INTO ahr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","अश रितीतीन तो माणुस खुप संपन्न व्हई गया, अनी पुष्कळ शेरडे, मेंढरं, दास, दासी उंट अनं गाढवी त्यानी मियाडं. ");
INSERT INTO ahr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","नंतर याकोबनी हाई ऐकं, की, लाबानना पोऱ्या अस म्हणतस की, \"आमना बापनं व्हतं नव्हतं ते सर्व याकोबनी हडप करी लियेल शे, अनी जे काही आमना बापनं व्हतं त्यानामाईनच त्यानी हाई सर्वी धनसंपत्ती कमाडेल शे.\" ");
INSERT INTO ahr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","याकोबनी लाबानना तोंड दखीसन वळखी लिधं की, तो पहिलासारखा मनावर खुश नही शे. ");
INSERT INTO ahr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","परमेश्वरनी याकोबले सांगं, की, \"तू आपला पुर्वजसना देशले आपला नातेवाईकसकडे परत जाय, मी तुनाबरोबर ऱ्हासु.\" ");
INSERT INTO ahr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","तवय याकोबनी राहेल अनं लेआ हिसले निरोप धाडीसन वावरमा आपला कळपकडे बलाई लिधं. ");
INSERT INTO ahr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","त्या तठे वन्यात तवय तो तिसले बोलना, \"तुमना बापना व्यवहार मनासंगे आते पहिलासारखा राहिना नही, पण मना बापना देव मनासंगे शे. ");
INSERT INTO ahr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","तुमले ते हाई माहीत शे की, मी तुमना बापनी सेवा बळ लाईसन करेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","पण तुमना बापनी माले फसाडीसन दहा येळा मना कमाईमा बदल करा, तरी बी देवनी त्याले मनं नुकसान करू दिधा नही. ");
INSERT INTO ahr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","त्यानी जवय सांगं की, ठिपकादार मेंढ्या बकरीसना तुले वेतन भेटी, तवय सर्वा कळपासमा ठिपकादार पिल्ला व्हवाले लागनात; त्यानी जवय सांगं, की, बांड्या बकऱ्या तुन्या, तवय सर्व कळपासमा बांडी पिल्ला व्हवाले लागनात. ");
INSERT INTO ahr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","अस देवनी तुना बापना जनावरे लिसन माले देल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","कळपसमा मेंढ्या, बकऱ्या गाभन व्हवाना ऋतुमा मी मनी नजर वर करीसन स्वप्नमा दखं की, मेंढ्यासवर उडनारा एडका बांड्या, काबऱ्या अनं करडा व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","तवय परमेश्वरना देवदूतनी स्वपनमां माले सांगं, \"याकोबा!\" अनी मी बोलनु, \"मी आठे शे.\" ");
INSERT INTO ahr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","तो बोलना, \"तुनी नजर वर करीन दख, मेंढ्यासवर उडनारा सर्वा एडका बांडे, ठिपकादार, अनं करडे शेतस; कारण लाबान तुनासंगे कसं वर्तन करी राहिना शे, हाई सर्व मी दखेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","बेथेल आठे तू एक स्तंभले तेलना अभ्यंग करीन माले नवस करं तठला मी देव शे; आते तू हावु देशमाईन निंघीसन आपली जन्मभूमीले परत जाय. ");
INSERT INTO ahr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","तवय राहेल अनं लेआ त्याले बोलन्यात, आते आमना बापना घरमा अजून काही वाटा किंवा वेतन आमनाकरता थोडं ठेयेल शे? ");
INSERT INTO ahr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","त्याना नजरमा आमी परक्याच शेतस ना? कारण त्यानी आमले ईकी देयल शे, अनी आमनं धन बी खाई टाकेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","यामुये जो सर्वा धन परमेश्वरनी आमना बापपाईन ली लियेल शे, तो आमनं अनं आमना पोऱ्यासना शे, त्यामुये आते जे परमेश्वरनी तुमले सांगेल शे तशे करा. ");
INSERT INTO ahr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","मंग याकोब उठीसन आपला पोऱ्या अनं बायकासले उंटसवर बसाडं. ");
INSERT INTO ahr_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","अनी आपली सर्वा जनावरे, अनी पदन-अराममा मियाडेल सर्वी मालमत्ता लिसन तो आपला बाप इसहाक यानाकडे कनान देशमा जावाले निंघना. ");
INSERT INTO ahr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","जवय लाबान आपला मेंढरंसनी कातरणी कराले जायेल व्हता, तवय राहेलनी आपला बापन्या (तेराफीम) गृहदेवत्या चोरी लिधं. ");
INSERT INTO ahr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","अस याकोबनी अरामी लाबानले फसाडं; कारण आपण पळी जाई ऱ्हायनुत हाई त्यानी त्याले समजू दिधं नही. ");
INSERT INTO ahr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","मंग तो त्यानाजोडे जे काही व्हतं, ते लिसन तो पळी गया; अनी पुढं जाईसन त्यानी फरात नदी ओलांडीसन गिलादना डोंगरनी बाजुले जावाना बेत करं. ");
INSERT INTO ahr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","याकोब पळी गया शे, हाई तिसरा दिनले कोणीतरी लाबानले सांगं. ");
INSERT INTO ahr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","तवय त्यानी आपला सर्वा भाऊबंदसले लिसन सात दिनपावत प्रवास करीसन त्याना पाठलाग करं अनी त्याले गिलाद डोंगरवर सापडावं. ");
INSERT INTO ahr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","मंग देवनी अरामी लाबानले रातले सपनमां दर्शन दिसन सांगं, सावधान, तू याकोबले बरं वाईट बोलानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","लाबाननी जवय याकोबले सापडावं, तवय याकोबनी डोंगरवर आपला पडाव टाकेल व्हता; लाबाननी बी आपला भाऊबंदनासंगे गिलाद नावना डोंगरवर पडाव टाकं. ");
INSERT INTO ahr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","मंग लाबान याकोबले बोलना, तू हाई काय करं? माले फसाडीसनं मन्या पोरी युध्दमा पाडाव करेलप्रमाण लई वनास. ");
INSERT INTO ahr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","तू गुपचुप पळीसन माले फसाडेल शे; माले काबंर सांगं नही, तू माले सांगता तर मी आंनदमा वाजागाजा करीसन डफ, तुतारी वाद्य वाजाडीसनं तुले निरोप दितु. ");
INSERT INTO ahr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","तू माले आपला पोऱ्यासोऱ्यासना मुका लेवानी सवड बी दिधी नही; हाऊ सर्व तू मुर्खपणा करेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","तुना नुकसान करानं सामर्थ्य मनामा शे, पण कालदिन रातले तुना बापना देवनी माले सांगं की, सावधान, याकोबले बरं वाईट बोलानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","बरं व्हयनं, तुले आपला बापनी घरनी ओढ लागी व्हती म्हणीसनं तू वनास, पण मन्या गृहदेवता का बरं चोरात? ");
INSERT INTO ahr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","तवय याकोबनी लाबानले उत्तर दिधं, माले भिती वाटनी; मी इचार करं की, तुम्हीन मनाकडतीन तुमन्या पोरीसले हिसकाई लिशात. ");
INSERT INTO ahr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","तुमन्या देवता ज्यानाकडे सापडतीन तो जिवत रावावु नही; तुम्हीन तुमना भाऊबंदनासमक्ष मनी तपासी ल्या अनी तुमना काही सापडनं तर वळखीन लि लेवानं, कारण याकोबले माहित नव्हतं की, राहेलनी देवता चोरी आणेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","तवय लाबान याकोबना तंबूमा, लेआना तंबूमा अनी त्या दोन दासीसना तंबूमा गया, पण त्याले काहीच सापडनं नही, मंग तो लेआना तंबूमाईन राहेलना तंबूमा गया. ");
INSERT INTO ahr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेल त्या गृहदेवता उंटसना कंठाळीमा ठिसन त्यावर बसेल व्हती, लाबाननी सर्वा तंबू शोधीसन दखा, पण त्याले काही सापडनं नही. ");
INSERT INTO ahr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ती बापले बोलनी, मना धनी माले तुमनापुढे उभं राहता येवाऊ नही म्हणीसन राग येऊ देवानं नही, कारण माले स्त्रीधर्म प्राप्त व्हयेल शे, त्यानी खुप शोध करा पण त्याले त्या गृहदेवता सापडन्यात नहीत. ");
INSERT INTO ahr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","तवय याकोबले राग वना अनी तो लाबाननासंगे भांडाले लागना; याकोबनी लाबानले सांगं, मी अश कोणता अपराध, कोणता पाप करेल व्हतं? म्हणीसन तुम्हीन मना पाठलाग करनात? ");
INSERT INTO ahr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","तुम्हीन मना सर्वा वस्तुसनी झडती लिधी त्यामा तुमन्या घरना वस्तु सापडन्यात का? सापडन्या व्हईत तर त्या मना अनं तुमना भाऊबंदनासमक्ष ठेवा; म्हणजे त्यासले आपला दोन्हीसना न्याय करता ई. ");
INSERT INTO ahr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","आज तीस वरीसपावत मी तुमनासंगे ऱ्हायनु; इतला काळमा तुमन्या मेंढ्या बकऱ्या गाभटन्या नहीत अनं तुमना कळपासमाधलं एक बी मेंढानं मास खादं नही. ");
INSERT INTO ahr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ज्यासले जंगली जनावरेसनी मारीन खादं, ती तशच तुमनाजोडे न आणता मी त्यासना बदलामा दुसरी मेंढरंनी भरपाई मी दिधी; दिनरातले चोरी व्हयेल मेंढरं तुम्हीन मनाकडीन भरपाई लिधी. ");
INSERT INTO ahr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","मनी हालत अशी व्हई जायेल व्हती, दिनले उन्हना ताप अनं रातले गारठा यासघाई मनी डोळासनी झोप उडी जाये. ");
INSERT INTO ahr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","वीस वरीसपावत मी तुमना घरमा ऱ्हायनु, चौदा वरीस तुन्या दोन्ही पोरीकरता अनी सहा वरीस तुमना मेंढ्या बकऱ्या करता मी तुमनी सेवा करी अनी दहा येळा तुम्हीन मना वेतनमां बदल करं. ");
INSERT INTO ahr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","मना बापना देव, अब्राहामना देव, इसहाकना धाक मना पाठिराखा नही ऱ्हाता, तर आते बी तुम्हीन माले रिकामा लाई देतात, पण देवनी मना दु:ख अनी मना कष्ट दखेल शे म्हणीसन त्यानी कालदिन रातले तुमले धमकाडं. ");
INSERT INTO ahr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","तवय लाबान याकोबले बोलना, ह्या पोरी ते मन्या पोरी शेतस, अनी ह्या पोऱ्या ते मना पोऱ्या शेतस; ह्या मेंढ्या बकऱ्या बी मन्या शेतस अनी ज्या काही तू दखी ऱ्हाईना शे, त्या सर्वा मना शे; आते ह्या मन्या पोरी अनं त्यासना पोटना पोऱ्या यासले मी काय करू शकस. ");
INSERT INTO ahr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","तर चल, तू अनी मी एकमेकसंगे करार करूत; अनी तो तुनामा अनी मनामा साक्षी राही. ");
INSERT INTO ahr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","तवय याकोबनी एक धोंडा लिसन त्याना स्तंभ उभा करा. ");
INSERT INTO ahr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","मंग याकोब आपला भाऊबंदसले बोलना, धोंडा गोया करा; अनी त्यासनी धोंडा गोया करीसन त्यासना ढिग करात. अनी तठे त्यासनी जेवण करं. ");
INSERT INTO ahr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","लाबाननी त्या ढिगनं नाव यगर-सहदूथा अश ठेवं, तर याकोबनी तिले गिलाद अश ठेवा. ");
INSERT INTO ahr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबान बोलना, \"आते हावु ढिग तुनामा अनं मनामा साक्ष शे, म्हणीन ह्यानं नाव गिलाद ठेवं.\" ");
INSERT INTO ahr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","तसच मिस्पा हाई बी नाव तिले दिधा; कारण तो बोलना, आपण एकमेकसना नजरआड व्हयनुत तर परमेश्वर तुना अनी मना साक्षी राही. ");
INSERT INTO ahr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","तू मना पोरीसले दु:ख दिधं किंवा दुसरा बाया बायका कऱ्यात तर दख, तुना मनामा कोणी दुसरा माणुस नही राहिना तरी देव साक्षी राही. ");
INSERT INTO ahr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","लाबान याकोबले आखो बोलना, दख, तुना मनामा हाई रास शे, अनं हाऊ स्तंभ मी उभा करेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","हाई रास अनं हाऊ स्तंभ साक्षी शे; अनिष्ट कराना हेतुतीन मी तुनाकडे हाई रास ओलांडीसन येवाव नही अनं तू पण हाई रास अनं हाऊ स्तंभ ओलांडीसन मनाकडे येवानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्राहामना देव, नाहोरना देव, त्यासना बापना देव आमना न्याय करोत, मंग याकोबनी त्यानी शपथ लिधी ज्याना भय त्याना बाप इसहाक धरी राहिंता. ");
INSERT INTO ahr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","मंग याकोबनी डोंगरवर यज्ञ करं, अनं आपला भाऊबंदसले जेवण कराले बलायं, त्यासनी जेवण करीसन रातले तठेच मुक्काम करात. ");
INSERT INTO ahr_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","लाबान मोठी पहाटमाच उठना, त्यानी आपला पोऱ्या पोरीसना मुका लिसन त्यासले आशिर्वाद दिधा, मंग लाबान निंघीसन आपला ठिकानमा वापस गया. ");
INSERT INTO ahr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","इकडे याकोब आपला वाट धरीसनं जाई राहिंता तवय देवदूत त्याले भेटनात. ");
INSERT INTO ahr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","त्यासले दखीसनं याकोब बोलना, हाई देवना सैन्य शे, म्हणीन त्या ठिकानना नाव त्यानी महनाइम ठेवात. ");
INSERT INTO ahr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","मंग याकोबनी सेईर देशमा म्हणजे अदोम प्रांतमा आपला भाऊ एसाव यानाकडे आपला पहिले संदेशवाहकसले धाडं. ");
INSERT INTO ahr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","त्यानी त्यासले आज्ञा दिधी की, मना बंधू एसाव याले जाईसन सांगा की, आपला सेवक याकोब म्हणस, लाबाननाजोडे प्रवासी व्हईसन आजपावत ऱ्हायनु. ");
INSERT INTO ahr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","तर आते मनी गुरं, गाढवं, शेरडंमेंढरंसना कळप, दास अनं दासी शेतस; मना बंधूनी मनावर कृपा व्हवाले पाहिजे म्हणीन हाऊ निरोप मी धाडी राहिनू शे. ");
INSERT INTO ahr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","संदेशवाहकसनी परत ईसन याकोबले सांगं, “आम्हीन आपला बंधू एसाव याले जाईन भेटनुत; तो आपलाले भेटाले ई राहिना शे, त्यानासोबत चारशे माणसे शेतस.” ");
INSERT INTO ahr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","तवय याकोब भलताच घाबरना अनी चिंतामा पडना अनी आपलासोबतना माणसे, शेरडंमेंढरं गुरं अनं उंट यासन्या त्यानी दोन टोळ्या करात. ");
INSERT INTO ahr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","तो बोलना, “एसावनी ईसन एक टोळीना नाश करा तर दुसरी टोळी पळीसन वाची जाई.” ");
INSERT INTO ahr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","मंग याकोब बोलना, हे परमेश्वरा, मना बाप अब्राहाम अनं इसहाक यासना देव, तू माले सांगस की, तू आपला देशले आपला भाऊबंदसमा परत जाय; मी तुना कल्याण करसु. ");
INSERT INTO ahr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","तू करूणा अनं सत्यता दखाडीसन आपला दासकरता जे काही करेल शे, त्याले मी पात्र नही; मी फक्त मनी काठी लिसन हाई यार्देन नदी उतरी जायेल व्हतु, अनी आते मनाजोडे दोन टोळ्या व्हई जायेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","मी प्रार्थना करस की, माले मना भाऊ एसावना हाततीन सोडाव; कारण माले त्यानी भिती वाटस, अस नको व्हवाले की तो ईसन मनावर हमला करी, अनी पोऱ्यासले बी मायनासोबत मारी टाकी. ");
INSERT INTO ahr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","तू माले वचन देयल शे की, मी तुना खरंच कल्याण करसु, अनी तुनी संतती समुद्रना वाळूना कणनामायक वाढावसु ज्यासनी मोजनी करता येस नही. ");
INSERT INTO ahr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ती रातले तो तठेच राहिना; अनी आपलाजोडे जे व्हतं त्यामाईन त्यानी आपला भाऊ एसाव यानाकरता भेट तयार करी. ");
INSERT INTO ahr_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","दोनशे बकऱ्या अनं वीस बोकडं, दोनशे मेंढ्या अनं तीस एडका, ");
INSERT INTO ahr_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","तीस दूध देनारी उंटनी अनी त्यासना पिल्ला, चाळीस गायी अनं दहा बैल, वीस गाढवी अनं दहा शिंगरं. ");
INSERT INTO ahr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","या सगयासना त्यानी येगयेगळा कळप करात, अनी आपला चाकरासना स्वाधीन करीसन त्यासले सांगं, तुम्हीन कळपा कळपामा अंतर ठेईसन मनापुढे चाला. ");
INSERT INTO ahr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","त्यानी सर्वासना पुढला चाकरले सांगं की, तुले मना भाऊ एसाव भेटना अनं ईचारना की, तू कोना दास शे? कोठे जाई राहिना? अनी हाई तू लई जाई राहिना शे ह्या जनावरं कोणा शेतस? ");
INSERT INTO ahr_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","तवय त्याले सांग की, आपला सेवक याकोब याना ह्या शेतस; त्यानी ह्या आपला बंधू एसाव याले भेट म्हणीसनं धाडेल शे; अनी दखा, तो बी आमना मांगे मांगे ई ऱ्हाईना शे. ");
INSERT INTO ahr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","मंग त्यानी दुसराले तिसराले अनी बाकीना कळप हाकलनारासले तसंच आज्ञा दिसन बोलना की, जर तुमले एसाव भेटना तर अशच बोलानं. ");
INSERT INTO ahr_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","अनी सांगा, दखा, तुमना दास याकोब बी आमनामांगेन ई ऱ्हायना शे, याकोबले वाटनं की, पुढं भेट धाडीन त्याले शांत करा अनी मांगेतीन त्याना दर्शन लिधा तर तो आपलावर संतुष्ट व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","अस त्यानी ती भेट पुढं गयी अनं तो ती रातले तंबू करीसन राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","मंग तो रातलेच उठीन आपला दोन्ही बायका, दोन्ही दासी अनी अकरा पोऱ्या यासले लिसन यब्बोक नदीना उतारतीन पार गया. ");
INSERT INTO ahr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","त्यानी त्यासले नदीना पलीकडे उतारी दिधं, अनी आपला सर्व काही तिकडे धाडी दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","याकोब एकलाच मांगे राहिना, तवय एक माणुस ईसन त्यानासंगे पहाट व्हस तोपावत कुस्ती खेळना. ");
INSERT INTO ahr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","याकोबवर मी यशस्वी व्हवावु नही हाई दखीसन त्यानी त्याना जांघले स्पर्श करा म्हणीन याकोबनी जांघनी जागा कुस्ती कराना येळले सुजनी. ");
INSERT INTO ahr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","तवय तो बोलना, “पहाट व्हई राहिनी माले जाऊ दे,” पण याकोब बोलना, “जोपावत तू माले आशिर्वाद देस नही तोपावत मी तुले जाऊ देवावू नही.” ");
INSERT INTO ahr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","तवय त्यानी ईचारं, \"तुना नाव काय शे?\" तो बोलना, \"याकोब\" ");
INSERT INTO ahr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","तवय त्यानी सांगं, \"आतेपाईन तुले याकोब म्हणावुत नहीत, तर इस्त्राएल म्हणतीन, कारण तू देवनासंगे अनी मनुष्यनासंगे लढीसन यशस्वी व्हयेल शे.\" ");
INSERT INTO ahr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","तवय याकोबनी त्याले सांगं, \"कृपा करीसन माले तुनं नाव सांग\" पण तो बोलना, \"मनं नाव काबंर ईचारस?\" मंग त्यानी त्याले तठेच आशिर्वाद दिधा. ");
INSERT INTO ahr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","मंग याकोबनी त्या ठिकाणनं नाव पनिएल अस ठेवं, कारण तो बोलना, मी देवना मुख प्रत्यक्ष दखीसन बी मना जीव वाची जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","तो पनिएल सोडीन जाई राहिंता तवय सकाळ व्हयनी; अनी आपली मांडीमुये लंगडा व्हईन चाली राहिंता. ");
INSERT INTO ahr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","म्हणीन इस्त्राएल लोक जनावरंसना जांघना स्नायू आजपावत खातस नही; यानं कारण हाईच शे की, त्यानी याकोबना जांघना स्नायूले स्पर्श करा. ");
INSERT INTO ahr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकोबनी नजर वर करीसनं दखं, तवय त्याले एसाव चारशे माणसे लिसन ई राहिना शे अस त्याले दखायना; तवय त्यानी लेआ अनं राहेल अनी त्या दोन दासीसनाजोडे आपला पोऱ्यासले दिधात. ");
INSERT INTO ahr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","त्यानी दासी अनं त्यासना पोऱ्यासले सर्वासना पुढे, त्यासना मांगे लेआ अनं तिना पोऱ्या अनी सर्वासना मांगे राहेल अनं योसेफ यासले ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","तो स्वत: त्या सर्वासना पुढं चालत गया, अनी भाऊनाजोडे जाईसन पोहचस नही तोपावत त्यानी त्याले सात दाव भूमीवर पडीसन नमन करं. ");
INSERT INTO ahr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","तवय एसाव त्याले भेटाकरता धावत वना, त्यानी त्याले मिठ्ठी मारी; त्याना गळामा गळा घालीसनं त्याना मुका लिधा, अनी त्या दोन्हीजण रडाले लागनात. ");
INSERT INTO ahr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","एसावनी वर नजर करीसनं बाया पोऱ्यासोर्‍यासले दखं, तवय तो बोलना ह्या कोण शेतस? तो बोलना देवनी आपला दासवर कृपा करीसनं देयल ह्या पोऱ्या शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","तवय त्याना दासीसनी पोऱ्यासनासंगे जोडे जाईसन त्याले नमन करं. ");
INSERT INTO ahr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","मंग लेआ अनं तिना पोऱ्यासनी जोडे ईसन त्याले नमन करं, अनी त्यासना नंतर योसेफ अनी राहेल यासनी जोडे ईसन त्याले नमन करं. ");
INSERT INTO ahr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","मंग तो बोलना, माले तुना सर्वा कुटूंब भेटना तो कसाकरता? तो बोलना, मना स्वामीनी मनावर कृपा दृष्टी व्हवाले पाहिजे म्हणीसन. ");
INSERT INTO ahr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","एसाव त्याले बोलना, मना बंधू तुना तुलेच राहु दे, मनाजोडे भरपुर शे. ");
INSERT INTO ahr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकोब त्याले बोलना, नही, नही, जर मनावर तुनी कृपादृष्टी व्हयेल व्हई, तर मना हाततीन हाई भेट स्वीकर कर, कारण माले तुनं दर्शन व्हयनं हाई एक देवना दर्शनमायक शे, अनी तुम्हीन बी मनावर खुश शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","तर तुमनाकरता आणेल भेट तुम्हीन ल्या; कारण देवनी मनावर कृपादृष्टी व्हवामुये मनाजोडे सर्वाकाही शे; त्यानी त्याले खुप रावन्या करामुये त्यानी ती भेट लिधी. ");
INSERT INTO ahr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","मंग एसाव त्याले बोलना, चला आपण वाटले लागुत अनी पुढे जाऊत, मी तुमनापुढे जास. ");
INSERT INTO ahr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","याकोब त्याले बोलना, मना स्वामीले माहित शे की, ह्या पोऱ्या धाकला शेतस; अनी दूध पाजनारा बकऱ्या, मेंढ्या अनं गायी यासनं बी माले दखना पडी, जर एक दिनमा विनाकारण त्यासले चालाडं तर सर्वा कळप मरी जाई. ");
INSERT INTO ahr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","तर मना स्वामी तुम्हीन आपला दासना पुढं जा, अनी मना गुरं, मेंढरं, अनं पोऱ्या यासनाघाई चालाई तश मी बागेबागे चालत सेईरमा मना स्वामीकडे ईसु. ");
INSERT INTO ahr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","मंग एसाव बोलना, \"मनाजोडेना लोकमाईन तुनाजोडे ठेई जास,\" याकोब बोलना, कशाले? मना स्वामीनी मनावर कृपादृष्टी व्हयनी म्हणजे बस. ");
INSERT INTO ahr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","तवय एसाव त्याच दिनले सेईरले परत जावाले निंघना. ");
INSERT INTO ahr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","याकोब प्रवास करीसन सुक्कोथले गया तठे त्यानी आपलाकरता एक घर बांधं अनं आपला गुरंढोरंसकरता झोपडा बनाडात, म्हणीसनं त्या ठिकाणना नाव सुक्कोथ अस पडनं. ");
INSERT INTO ahr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","याकोब पदन-अरामापाईन प्रवास करीसन कनान देशना शखेम नावना नगरले जाईन सुखरूप पोहचना, अनी नगरापुढे पडाव टाकीसनं राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","जठे त्यानी पडाव टाकेल व्हता, तठली काही जमीन त्यानी शखेमना बाप हमोर याना वंशजकडीन शंभर चांदीना सिक्का दिसन ईकत लिधं. ");
INSERT INTO ahr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","अनी तठे त्यानी एक वेदी बांधी अनी तिन नाव एल-एलोहे-याकोब अस ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","मंग लेआनी पोर दीना, जी याकोबपाईन उत्पन्न व्हयेल व्हती, त्या देशमाधल्या पोरीसले दखाले बाहेर गयी. ");
INSERT INTO ahr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","तवय त्या देशना अधिपती हमोर नावना हिव्वी पोऱ्या शखेम यानी नजर तिनावर गयी, अनी त्यानी तिले भ्रष्ट करं. ");
INSERT INTO ahr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","याकोबनी पोर दीना हिनावर त्यानं मन बसनं; त्यानं त्या पोरवर प्रेम जडना, अनी त्यानी तिनं समाधान करं. ");
INSERT INTO ahr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","मंग शखेमनी आपला बाप हमोर याले सांगं, माले हाई पोर बायको करी द्या. ");
INSERT INTO ahr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","त्यानी आपली पोर दीना हिले भ्रष्ट करं हाई माहिती याकोबले समजनी, तवय त्याना पोऱ्या रानमा गुरंसमा जायेल व्हतात, म्हणीसनं त्या परत येतस तोपावत तो गप्प राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","तवय शखेमना बाप हमोर याकोबनासंगे बोलनं कराकरता निंघना. ");
INSERT INTO ahr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ती माहिती ऐकीसन याकोबना पोऱ्या रानमाईन घर वनात; तवय त्या खुप दु:खमा संतापेल व्हतात, कारण शखेमनी याकोबनी पोरले भ्रष्ट करीसनं याकोबमा एक अश गोष्ट करेल व्हती जे त्यानी नको कराले पाहिजे व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","पण हमोरनी त्यानासंगे अश बोलनं करीसन सांगं, मना पोऱ्या शखेम यानं तुमनी पोरवर खुप प्रेम शे, तरी ती त्याले बायको करी द्या. ");
INSERT INTO ahr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","तुम्हीन आमनासंगे सोयरीक करा, तुमन्या पोरी आमले द्या अनं आमन्या पोरी तुम्हीन करा. ");
INSERT INTO ahr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","आमनामा वस्ती करीसनं राहा, हाऊ‍ देश तुमले मोकळा शे; त्यामा ऱ्हावा, व्यापार करा, अनी वेतन मियाडा. ");
INSERT INTO ahr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","शखेम दीनाना बापले अनं भाऊसले बोलना, मनावर एवढी कृपा करा म्हणजे तुम्हीन ज्या बी मांगशात ते मी दिसु. ");
INSERT INTO ahr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","तुमले वाटी ते किम्मतनी वस्तु मनाजोडे मांगा, तुमना सांगेल प्रमाणे ते मी दिसु; पण ती पोर माले बायको करी द्या. ");
INSERT INTO ahr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","आपली बहीण दीना शखेमनी भ्रष्ट करेल शे, म्हणीन याकोबना पोऱ्यासनी मनमा डाव धरीन त्याले अनं त्याना बाप हमोरले उत्तर दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","त्या त्याले बोलनात, बेसुंता व्हयेल माणुसले आमनी बहीण देवानं हाई आमना हाततीन व्हवावू नही; आमले बाट लागी. ");
INSERT INTO ahr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","आम्हीन फक्त एक अटवर तुमनासंगे सहमत व्हसुत, जर तुम्हीन आमनागत व्हई जाशात, म्हणजे तुमनामाईन सर्वा माणसंसनी सुंता व्हवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","तवय आम्हीन आमन्या पोरी तुमले बायका कराले दिसुत, अनी तुमन्या पोरी आम्हीन करसुत, अनी तुमनासंगे वस्ती करीन एकजातना व्हई जासुत. ");
INSERT INTO ahr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","पण जर तुम्हीन सुंता कराकरता आमनं ऐकनात नहीत, तर आम्हीन आमनी पोरले लिसन निंघी जासुत. ");
INSERT INTO ahr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","त्यासनं बोलनं हमोर अनं त्याना पोऱ्या शखेम याले मान्य व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","त्या जवान पोऱ्यानी तश कराले उशीर करा नही, कारण याकोबनी पोरवर त्यानं मन बसेल व्हतं; त्याना बापना घरमाधला सर्वापेक्षा त्याना मान मोठा व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","अस हमोर अनं त्याना पोऱ्या शखेम यासनी आपला नगरना वेशीजोडे जाईसन नगरवासी लोकसले अश सांगाले लागनात की, ");
INSERT INTO ahr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","ह्या माणसे आपलासंगे बंधुप्रेममा राहनारा शेतस, त्यामुये त्यासले हाई देशमा राहीसन व्यापार करू द्या, कारण दखा, त्यासले वस्ती करीन राहता ई इतला हाऊ देश पुरा शे, आम्हीन त्यासन्या पोरी बायका करूत अनी आपल्या पोरी त्यासले देऊत. ");
INSERT INTO ahr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","आपलामा राहिसन एक राष्ट्र व्हवाले त्या ज्या अटवर मान्य व्हयेल शेतस, ती हाई शे की, त्यासनी सुंता व्हयेल शे, तशी आपलामा सर्वा माणसेसनी सुंता व्हवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","अश करावर त्यासनं कळप, मालमत्ता अनी त्यासनी सर्वी जनावरे आपली नहीत का व्हवावुत? एवढं त्यासनं बोलनं मान्य करी ल्या, म्हणजे त्या आपलामा वस्ती करीन राहतीन. ");
INSERT INTO ahr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","हमोर अनी त्याना पोऱ्या शखेम यासनं बोलनं, वेशीमाईन येनारा जानारा सर्वासनी ऐकात; मंग त्या नगरमा येनारा जानारा सर्वा माणसेसनी सुंता व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","मंग अश व्हयनं की, तिसरा दिनले त्या सर्वा माणसे तराशमा पडी राहिंतात, तवय याकोबना दोन पोऱ्या म्हणजे दीनाना भाऊ शिमोन अनं लेवी यासनी आपली तरवार लिसन त्या नगरमा अचानक हामला करा, अनी तठला सर्वा माणसेसनी कत्तल करी. ");
INSERT INTO ahr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","अनी त्यासनी हमोर अनं त्याना पोऱ्या शखेम याना बी तरवारघाई कत्तल करीसन दीनाले शखेमना घरमाईन काढी लई गयात. ");
INSERT INTO ahr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","मंग याकोबना पोऱ्यासनी त्या कत्तल करेल नगरमा जाईसन त्या नगरले लुटी लिधात, कारण त्या नगरवासीसनी त्यासनी बहीण दीना हिले भ्रष्ट करेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","त्यासनी त्यासनं शेरडं मेंढरं, गायबैल, गाढवं अनी नगरमा अनी शेतमा जे काही व्हतं ते सर्वा त्यासनी लि लिधा. ");
INSERT INTO ahr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","अनी त्यासनी त्यासनं सर्व मालमत्ता, अनं पोऱ्यासोऱ्या अनं बाया अनी त्यासना घरमा जे काही सापडनं ते सर्वा त्यासनी लुटी लिधं. ");
INSERT INTO ahr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","तवय शिमोन अनं लेवी यासले याकोब बोलना, या देशना रहिवासी कनानी अनं परिज्जी यासले मना वीट ई अश करीन तुम्हीन माले संकटमा पाडेल शेतस; मना माणसे फक्त मुठभर शेतस, म्हणीसंन त्या मनावर चाल करीसन येतीन अनी मना कत्तल करतीन अनी मना अनं मना घरणासना नायनाट करतीन. ");
INSERT INTO ahr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","पण त्या त्याले बोलनात, त्यासनी आमनी बहीणसंगे अश व्यवहार का बरं करा, जश वेश्यानीसंगे करतस. ");
INSERT INTO ahr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","मंग देव याकोबले बोलना, ऊठ बेथेलमा जाईसनं राहाय; अनी तू आपला भाऊ एसाव याले घाबरीसन पळी जाई राहिंता तवय ज्या देवनी तुले दर्शन दिधं त्यानाकरता तठे वेदी बांध. ");
INSERT INTO ahr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","मंग याकोब आपला घरना मंडळीले अनं त्यानासंगेना सर्वा माणसंसले बोलना, तुमनाजोडे ज्या परका देव शेतस, त्या सर्वा फेकी द्या अनं स्वताले शुध्द करीसन आपला कपडा बदली टाका. ");
INSERT INTO ahr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","अनी चला आपण आठेन निंघीसन बेथेलमा जाऊत; तठे मी परमेश्वरना करता वेदी बांधसु; संकटना येळले त्यानी मनं ऐका; अनी ज्या वाटतीन मी प्रवास करी राहिंतु तिमा तो मनासंगे व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","तवय त्यासनी त्यासनाजोडे ज्या परका देवसन्या मुर्ती व्हत्यात अनी आपला कानमाधलं कुंडलं याकोबनाजोडे दिधात; मंग याकोबनी शखेमनाजोडे एक एला झाडजोडे ती पुरी दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","मंग त्यासनी तठेन पलायन करं; अनी आसपासना नगरना लोकसना मनमा देवनी अश भय निर्माण करा की, त्या याकोबना पोऱ्यासना मांगे लागनात नहीत. ");
INSERT INTO ahr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","अश प्रकारतीन याकोब आपलाबरोबरना सर्वा लोकसनासंगे कनान देशमा लूज आठे ईसन पोहचना. ");
INSERT INTO ahr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","तठे त्यानी एक वेदी बांधी अनं त्या स्थळले एल-बेथेल अश नाव दिधं; कारण तो आपला भाऊपाईन पळी जाई राहिंता तवय आठेच देव त्याले प्रकट व्हयना व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","रिबकानी दाई दबोरा हाई मरण पावनी अनं तिले बेथेलना खालना बाजुले अल्लोन झाडनाखाल पुरं; ह्या झाडना नाव अल्लोन-बाकूथ अश ठेवात. ");
INSERT INTO ahr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","याकोब पदन-अराममाईन परत येवावर देवनी त्याले परत दर्शन दिसन आशिर्वाद दिधा. ");
INSERT INTO ahr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","देव त्याले बोलना, तुनं नाव याकोब शे; पण आतेपाईन तुले याकोब म्हणावुत नहीत, तर तुनं नाव इस्त्राएल व्हई; अनी देवनी त्याले इस्त्राएल हाई नाव दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","देव त्याले आखो बोलना, मी सर्वसमर्थ देव शे; तू फलद्रूप व्हईसन बहुगुणित व्हई जाय; तुनापाईन एकच राष्ट्र नही, तर राष्ट्र समूह उत्पन्न व्हतीन; अनी तुनापाईन राजा उत्पन्न व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","अनी जो देश मी अब्राहाम अनं इसहाक यासले दिधा, तो तुले दिसु अनी तुनामांगे तुनी संतानले बी तोच देश दिसु. ");
INSERT INTO ahr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","मंग देवनी जठे याकोबना संगे भाषण करं तठेनच तो वर निंघी गया. ");
INSERT INTO ahr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","अनी जठे देवनी याकोबना संगे भाषण करं तठे त्यानी एक दगडना स्तंभ उभा करा, अनी त्यानावर पेयार्पण करीसन त्यानावर तेल ओतं. ");
INSERT INTO ahr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","मंग याकोबनी त्या स्थळना नाव बेथेल ठेवा जठे देवनी त्यानासंगे भाषण करेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","मंग त्यासनी बेथेलमाईन वाटचाल करी अनी एफ्राथ नावना गाव अजुन थोडंच बाकी व्हता तवय राहेलले प्रसूत पिडानी सुरवात व्हयनी अनं तिले भयानक प्रसूती पिडा व्हवाले लागनी. ");
INSERT INTO ahr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","प्रसूतीपिडा व्हई राहिंतात तवय सुईण तिले बोलनी घाबरू नको, कारण आते बी तुले हाऊ पोऱ्याच व्हवाव शे. ");
INSERT INTO ahr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","तवय अश व्हयनं की, ती मरण पावनी अनी तिना जीव जावाना येळले तिनी पोऱ्याना नाव बेनओनी अश ठेवात. पण त्याना बापनी त्यानं नाव बन्यामिन (मना उजवा हातना पोऱ्या) अश ठेवात. ");
INSERT INTO ahr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","अश प्रकारतीन राहेल मरण पावनी अनी एफ्राथ (म्हणजे बेथलेहेम) गावना वाटवर तिले पुरं. ");
INSERT INTO ahr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","मंग याकोबनी तिना कबरवर एक स्तंभ उभा करा; तो स्तंभ राहेलना कबरवर आजपावत कायम शे. ");
INSERT INTO ahr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","नंतर याकोबनी पलायन करीसन एदेर कोटना पलीकडे आपला पडाव टाकात. ");
INSERT INTO ahr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","तवय अश व्हयनं की, याकोब त्या देशमा राही राहिंता तो रऊबेन हाऊ आपला बापनी उपपत्नी बिल्हा हिनाजोडे जाईसन झोपना, अनं हाई याकोबले समजनं याकोबना बारा पोऱ्या व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","लेआ हिना पोऱ्या: याकोबना पहिला पोऱ्या रऊबेन अनी शिमोन, लेवी, यहूदा, इस्साखार अनं जबुलून; ");
INSERT INTO ahr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","राहेलना पोऱ्या: योसेफ अनं बन्यामिन; ");
INSERT INTO ahr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","राहेलनी दासी बिल्हा हिना पोऱ्या: दान अनं नफताली; ");
INSERT INTO ahr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","अनी लेआनी दासी जिल्पा हिना पोऱ्या: गाद अनं आशेर; ह्या याकोबना पोऱ्या त्याले पदन-अराममा व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","मंग किर्याथ अरबा म्हणजे हेब्रोन अठला मम्रेमा याकोब आपला बाप इसहाक याले भेटाले गया; तठेच अब्राहाम अनं इसहाक ह्या सुरवातले वस्ती करीन राही राहिंतात. ");
INSERT INTO ahr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाकनं वय एकशेऐंशी वरीसना व्हई जायेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","अनी इसहाकना जीव निंघी गया; तो म्हतारा अनं पुरा वयना व्हईसन मरण पावना अनी आपला लोकसमा जाईन भेटना; त्याना पोऱ्या एसाव अनी याकोब यासनी त्याले मूठमाती दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव म्हणजे अदोम यानी वंशावळी: ");
INSERT INTO ahr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसावनी कनानी पोरीसमाईन बायको करी, एलोन हित्ती यानी पोर आदा, सिबोन हिव्वी यानी नात म्हणजे अनानी पोर अहलीबामा, ");
INSERT INTO ahr_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","अनी इश्माएलनी पोर, नबायोथनी बहीण बासमाथ ह्या बायको त्यानी करी. ");
INSERT INTO ahr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","एसावपाईन आदाले अलीपाज अनं बासमाथले रगुवेल ह्या पोऱ्या व्हयनात; ");
INSERT INTO ahr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","अनी अहलीबामले यऊश, यालाम, अनं कोरह ह्या पोऱ्या व्हयनात, एसावले ह्या पोऱ्या कनान देशमा व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","मंग एसाव आपल्या बायका, पोऱ्या अनं पोरीसले अनं आपला घरना सर्वा माणसे, आपला गुरंढोरं अनं बाकीना जनावरे अनी कनान देशमा मियाडेल मालमत्ता हाई सर्व लिसन याकोब राही राहिंता त्या देशमाईन दूर निंघी गया. ");
INSERT INTO ahr_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","कारण त्यानी संपत्ती इतली वाढनी की, त्यासले एकत्र रावाले सोय नव्हती; तसंच त्यासनं गुरंढोरं जास्त वाढामुये ज्या देशमा त्या प्रवासी म्हणीन राही राहिंतात तठे तेवढासना निर्वाह व्हई नही राहिंतं. ");
INSERT INTO ahr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","म्हणीन एसाव सेईरना डोंगराळ प्रदेशमा वस्ती करीन राहिना, एसावले अदोम नावतीन बी वळखेत. ");
INSERT INTO ahr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेईरना डोंगराळ प्रदेशमा राहनारा अदोमी लोकसना मूळपुरूष एसाव यानी वंशावळीना लिखाण यानाप्रमाणे ");
INSERT INTO ahr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसावना पोऱ्यासना नावे ह्या शेतस: एसावनी बायको आदा हिना पोऱ्या अलीपाज अनी एसावनी बायको बासमाथ हिना पोऱ्या रगुवेल. ");
INSERT INTO ahr_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","अलीपाज याना पोऱ्या तेमान, ओमार, सपो, गाताम, अनी कनाज ह्या व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसावना पोऱ्या अलीपाज यानी तिम्ना नावानी एक उपपत्नी व्हती, तिनापाईन त्याले अमालेक व्हयना, एसावनी बायको आदा हिना हाऊ वंश. ");
INSERT INTO ahr_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रगुवेलना पोऱ्या नहाथ, जेरह, शम्मा, अनं मिज्जा ह्या व्हतात; एसावनी बायको बासमाथ हिना हाऊ वंश. ");
INSERT INTO ahr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","सिबोननी पोर अना, हिनी पोर अहलीबामा हाई जी एसावनी बायको तिनापाईन एसावले यऊश, यालाम, अनं कोरह ह्या पोऱ्या व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसाव वंशमाधला सरदार व्हयनात, त्या ह्या शेतस, एसावना पहिला पोऱ्या अलीपाज, याना पोऱ्‍या सरदार तेमान, सरदार ओमार, सरदार सपो, सरदार कनाज, ");
INSERT INTO ahr_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","सरदार कोरह, सरदार गाताम, अनं सरदार अमालेक; अदोम देशमा अलीपाज यानाद्वारे ह्या सरदार व्हयनात, ह्या आदाना पोऱ्या शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसावना पोऱ्या रगुवेल याना पोऱ्या ह्या शेतस: सरदार नहाथ, सरदार जेरह, सरदार शम्मा अनं सरदार मिज्जा ह्या सरदार रगुवेलले अदोम देशमा व्हयनात; एसावनी बायको बासमाथ हिना या पोऱ्या शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसावनी बायको अहलीबामा, हिना पोऱ्या ह्या शेतस, सरदार यऊश, सरदार यालाम, अनं सरदार कोरह, ह्या सरदार एसावनी बायको अहलीबामा, अनानी पोर हिले व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","एसाव म्हणजे अदोम याना हाऊ वंश शे, अनी त्यानामा ह्या सरदार तयार व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","सेईर हाऊ जो होरी जातना व्हता, त्याना ह्या पोऱ्या पहिलापाईन त्या देशमा राही राहिंतात त्या ह्या शेतस: लोटन, शोबाल, सिबोन, अनं अना, ");
INSERT INTO ahr_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दिशोन, एसर अनं दीशान; ह्या अदोम देशमा सेईरना होरी वंशमाधला सरदार व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोटनना पोऱ्या होरी अनं हेमाम ह्या व्हतात; लोटननी बहीण तिम्ना हाई व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबालना पोऱ्या अलवान, मानहाथ, एबाल, शपो, अनं ओनाम ह्या व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिबोनना पोऱ्या अय्या अनं अना ह्या व्हतात; हाऊ तो अना शे, ज्यानी आपला बाप सिबोन याना गाढवं जंगलमा चारी राहिंता तवय त्याले गरम पाणीना झरा सापडना व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अनाले दिशोन नावना पोऱ्या अनं अहलीबामा नावनी पोर व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दिशोनना पोऱ्या हेमदान, एश्बान, यित्रान अनं करान ह्या व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसरना पोऱ्या बिल्हान, जावान अनं अकान ह्या व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशानना पोऱ्या ऊस अनं अरान ह्या व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरीसमाईन ज्या सरदार व्हयनात त्या ह्या शेतस. सरदार लोटान, सरदार शोबाल, सरदार सिबोन, सरदार अना. ");
INSERT INTO ahr_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","सरदार दिशोन, सरदार एसर, सरदार दीशान; सेईर देशमाधला होरीसना ह्या सरदार व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","इस्त्राएल लोकसवर कोणी राजा राज्य कराना पहिले अदोम देशवर ज्या राजासनी राज्य करा त्या ह्या शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बौराना पोऱ्या बेला यानी अदोममा राज्य करं; त्यानी राजधानी दिन्हाबा नगर हाई व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेला मरण पावना तवय त्याना जागावर बस्त्रा आठला जेहरना पोऱ्या योबाब हाऊ त्याना जागेवर राजा व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाब मरावर तेमानी देशना हुशाम त्याना जागेवर राजा व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","हुशाम मरण पावना तवय बदाद याना पोऱ्या हदाद हाऊ त्याना जागेवर राजा व्हयना; यानीच मवाब मैदानमा मिद्यानसले हाराय व्हतं; त्यानी राजधानी अवीत शहर व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हदाद मरावर मास्त्रेका आठला साम्ला त्याना जागेवर राजा व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","साम्ला मरावर फरात नदीनाजोडेना रहोबोथ नगरना शौल त्याना जागेवर राजा व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शौल मरावर अकबोरना पोऱ्या बाल-हनान त्याना जागेवर राजा व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अकबोरना पोऱ्या बाल-हनान हाऊ मरावर त्याना जागेवर हदार हाऊ राजा व्हयना; त्यानी राजधानी पाऊ व्हती अनं त्यानी बायकोनं नाव महेटाबेल व्हतं; हाई मेजाहाबनी पोर मात्रेद हिनी पोर व्हती. ");
INSERT INTO ahr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","एसाव वंशामाधलं सरदारसना नावे, कुळं, अनं रावानं ठिकाण व्हयनात त्यानावरीन त्यासनं हाई नावे शेतस: सरदार तिम्ना, सरदार आल्वा, सरदार यतेथ, ");
INSERT INTO ahr_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","सरदार अहलीबामा, सरदार एला, सरदार पीनोन, ");
INSERT INTO ahr_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","सरदार कनाज, सरदार तेमान, सरदार मिब्सार, ");
INSERT INTO ahr_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","सरदार माग्दीएल अनं सरदार ईराम; अदोम वंशजसनी जो देश वतन करी लिधा, त्यासनामाईन त्यासना रावाना ठिकाणप्रमाणे त्यासना ह्या सरदार व्हतात; अदोमी लोकसना मूळ बाप एसाव शे. ");
INSERT INTO ahr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकोब कनान देशमा वस्ती करीन राहिना; त्याना बाप बी तठेच प्रवासी म्हणीसन राहिना ‍व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","याकोब वंशना वर्णन हाऊ शे: योसेफ सतरा वरीसना व्हता तवय आपला भाऊसनासंगे म्हणजे आपला बापना बायका बिल्हा अनी जिल्पा यासना पोऱ्यासंगे राहीसन मेंढरंसना कळप चारे; अनी योसेफ त्यासनी वाईट गोष्टीसनी खबर आपला बापले जाईसन सांगे. ");
INSERT INTO ahr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","याकोब आपला सर्व पोऱ्यासपेक्षा योसेफवर जास्त प्रेम करे, कारण तो त्याना म्हतारपणना पोऱ्या व्हता; त्यानी त्यानाकरता एक पायघोळ झगा बनडेल व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","आपला बाप आपलासपेक्षा त्यानावर जास्त प्रेम करस हाई दखीन त्या त्याना राग कराले लागनात, अनं त्यानासंगे चांगलं बात बी नही करेत. ");
INSERT INTO ahr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","मंग एकदाव योसेफले सपन पडनं त्यानी ते त्यासले सांगी दखाडं, तवय त्या त्याना जास्तच राग कराले लागनात. ");
INSERT INTO ahr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","तो त्यासले बोलना, माले पडेल सपन ऐका जे मी दखेल शे: ");
INSERT INTO ahr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","दखा, आपण सर्वा शेतमा पेंढ्या बांधी राहिंतुत तवय मनी पेंढी उठीन उभी राहिनी; तवय तुमन्या पेंढ्या मनी पेंढीना चारीबाजुले उभ्या राहिन्यात अनं त्यासनी तिले नमन करात. ");
INSERT INTO ahr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","हाई ऐकीसन त्याना भाऊ त्याले बोलनात, तू खरंच आमनावर राज्य कराव शे का? म्हणजे आमनावर तू सत्ता चालावनार शे का? म्हणीन त्या त्याना सपनमुये अनी त्यानी बातमुये त्याना जास्तच राग कराले लागनात. ");
INSERT INTO ahr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","परत त्याले आखो एक स्वप्न पडनं, ते पण त्यानी आपला भाऊसले सांगी दखाडं, तो बोलना, दखा, माले आखो एक सपन पडनं, ते अस की, सुर्य, चंद्र अनं अकरा तारा यासनी ईसन माले नमन करात. ");
INSERT INTO ahr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","त्यानी हाई सपन आपला बापले अनं भाऊसले सांगं, तवय त्याना बाप त्याले दटाडीसनं बोलना, हाई आशे काय सपन पडनं शे तुले? मी अनी तुनी माय अनं तुना भाऊ या खरंच तुनापुढे भूमीवर झुकीसन तुले नमन कराले येतीन. ");
INSERT INTO ahr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","त्याना भाऊ त्याना हेवा कराले लागनात, पण त्यानं म्हणनं त्याना बापनी आपला मनमा ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","यानानंतर त्याना भाऊ आपला बापना कळप चाराले शखेमले गयात. ");
INSERT INTO ahr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","मंग याकोब योसेफले बोलना, तुना भाऊ शखेमले कळप चारी राहिनात शेतस ना; तर चाल; मी तुले त्यासनाकडे धाडस, तो बोलना, हा मी जावाले तयार शे. ");
INSERT INTO ahr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","अनी त्यानी त्याले सांगं, \"जाय तुना भाऊ कशा काय शेतस अनी कळप पण ठिक शे का ते दखीसनं माले ईसन सांगं,\" तवय त्यानी त्याले हेब्रोन खोरामाईन धाडं, अनं तो शखेमले जाईसनं पोहचना. ");
INSERT INTO ahr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","तो जंगलमा इकडे तिकडे भटकी राहिंता तवय एक माणुसनी त्याले ईचारं तू काय शोधी राहिना शे? ");
INSERT INTO ahr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","तो बोलना, मी आपला भाऊसले शोधी राहिनु शे; त्या कळप कोठे चारी राहिनात शेतस तेवढं माले सांगा. ");
INSERT INTO ahr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","तो माणुस योसेफले बोलना, त्या आठेन निंघी जायेल शेतस; मी त्यासनं हाई बोलनं ऐका, आपण दोथानले जाऊत, मंग योसेफ आपला भाऊसना शोध करत गया अनं त्या त्याले दोथानमा सापडनात. ");
INSERT INTO ahr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","त्यासनी त्याले दूरतीन दखं, तवय तो त्यानाजोडे येवाना पहिले त्याले मारी टाकाना त्यासनी बेत करं. ");
INSERT INTO ahr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","त्या एकमेकसले बोलनात, दखा, हाऊ स्वप्नदर्शी ई ऱ्हाईना शे; ");
INSERT INTO ahr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","तर आते चला, आपण त्याले मारी टाकुत, अनी मंग सांगूत कोणी हिस्त्र पशुनी त्याले खाई टाकं; मंग दखुत त्यानं सपनना काय व्हस ते. ");
INSERT INTO ahr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","पण हाई रऊबेननी ऐका, तवय त्यानी त्यासना हाततीन वाचाडी लिधं; तो त्यासले बोलना, आपण त्याले जिवे मारानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","रऊबेन त्यासले बोलना, रक्तपात करानं नही, याले जंगलना खड्डामा टाकी द्या, पण त्यानावर हात टाकान नही, त्यासना हाततीन सोडाईसन त्याले बापकडे परत धाडी देवानं म्हणीसनं तो अस बोलना. ");
INSERT INTO ahr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","योसेफ आपला भाऊसनाजोडे पोहचना, तवय त्याना आंगमा पायघोळ झगा व्हता तो त्यासनी काढी लिधा. ");
INSERT INTO ahr_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","अनी त्याले उचलीसनं खड्डामा टाकी दिधं; तो खड्डा कोरडा व्हता त्यामा पाणी नव्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","मंग त्या जेवण कराले बठी गयात तवय त्यासनी नजर वर करीन दखं, तवय इश्माएली लोकसनी एक टोळी उंटवर मसाला, ऊद अनं गंधरस लटकाडीसनं गिलादमाईन मिसरले जाई राहिना शेतस अस त्यासले दखायनं. ");
INSERT INTO ahr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","तवय यहूदा आपला भाऊसले बोलना, आपला भाऊले ठार मारीसन अनं त्याना रक्त लपाडीसन आपलाले काय फायदा व्हनार शे? ");
INSERT INTO ahr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","चला, आपण त्याले ह्या इश्माएली लोकसले ईकी टाकुत; आपण त्यानावर हात टाकनं नही; कारण तो पण आपलाच भाऊ शे; आपला हाडमासना शे, हाई त्याना भाऊसले पटी गयं. ");
INSERT INTO ahr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","तवय काही मिद्यानी व्यापारी जोडेतीन जाई राहिंतात तवय त्यासनी योसेफले त्या खड्डामाईन बाहेर काढं अनी त्या इश्माएली लोकसले वीस रूपयामा ईकी दिधं, त्या योसेफले मिसर देशमा लई गयात. ");
INSERT INTO ahr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","जवय रऊबेन खड्डानाजोडे गया तवय त्यानी दख की, योसेफ खड्डामा नही शे, म्हणीसन त्यानी आपला कपडा फाडात. ");
INSERT INTO ahr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","तो आपला भाऊसकडे ईसन बोलना, पोऱ्या ते नही शे; आते मी कोठे जाऊ? ");
INSERT INTO ahr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","मंग त्यासनी योसेफना झगा लिसन तो एक बकरा मारीन तो झगा त्याना रंगतमा भिजाडं. ");
INSERT INTO ahr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","मंग त्यासनी तो पायघोळ झगा धाडी दिधा; तो त्यासनी आपला बापनाजोडे आणीसन सांगं, की, हाऊ आमले सापडना शे; हाऊ तुमनाच पोऱ्याना झगा शे का हाई वळखा. ");
INSERT INTO ahr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","त्यानी वळखीन सांगं, हाऊ मनाच पोऱ्याना झगा शे! हिस्त्र पशुनी त्याले खाई टाकं, म्हणजेच योसेफले फाडी टाकेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","तवय याकोबनी आपला कपडा फाडात अनी कंबरले गोणताट गुंडाळीसन आपला पोऱ्याकरता बराच दिन शोक करं. ");
INSERT INTO ahr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","त्याना पोऱ्या अनं पोरी ह्या सर्वा त्याना सांत्वन कराकरता त्यानाजोडे गयात; पण त्याले काही समाधान वाटनं नही, अनं तो बोलना, मी शोक करत करत अधोलोकमा मना पोऱ्याकडे जासु, अस त्याना बापनी त्यानाकरता शोक करं. ");
INSERT INTO ahr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","मिद्यानी लोकसनी योसेफले मिसरमा आणीसन पोटीफर नावना फारोना एक अमलदार गारद्यासना सरदार व्हता, त्याले ईकी दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","त्या येळले यहूदा आपला भाऊसले सोडीसनं खालना प्रदेशमा गया अनी अदुल्लामकर हिरा नावना माणुसना घर जाईसनं राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","तठे शूवा नावना एक कनानी माणुसनी पोर यहूदानी नजरमा पडनी; त्यानी ती बायको करी लिधी अनं तो तिनाजोडे गया. ");
INSERT INTO ahr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ती गर्भवती व्हईसनं तिले पोऱ्या व्हयना; त्यानी त्यानं नाव एर ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ती परत गर्भवती व्हयनी अनं तिले पोऱ्या व्हयना; तिनी त्यानं नाव ओनान ठेवं; ");
INSERT INTO ahr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","आखो तिले एक पोऱ्या व्हयना; त्यानं नाव तिनी शेला ठेवं तो व्हयना तवय यहूदा कबीज आठे राही राहिंता. ");
INSERT INTO ahr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","मंग यहूदानी आपला पहिला पोऱ्या एर याले बायको करी दिधी, तिनं नाव तामार अस व्हतं; ");
INSERT INTO ahr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","पण यहूदाना पहिला पोऱ्या एर हाऊ परमेश्वरना नजरमा दुष्ट व्हता म्हणीसनं परमेश्वरनी त्याले मारी टाकं. ");
INSERT INTO ahr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","मंग यहूदा ओनानले बोलना, आपली भावजयीनाजोडे जाय अनी दिरना धर्मले धरीन भाऊना वंश चालाव; ");
INSERT INTO ahr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","पण ओनान याले माहित व्हतं की, संतती व्हयनी तरी मनी नही व्हवावु, म्हणीसनं तो त्यानी भावजयीनाजोडे जाये तवय आपलं वीर्य जमीनवर पाडी दिये, त्याना हेतु हाऊ व्हता की, आपला भाऊले आपला बीज देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","हाई त्यानं कृत्य परमेश्वरले दुष्ट वाटनं म्हणीसनं त्यानी त्याले बी मारी टाकं. ");
INSERT INTO ahr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","यहूदा त्यानी सून तामार हिले बोलना, मना पोऱ्या शेला वयमा येस तोपावत तुना बापना घर विधवा बनीसन राय; कारण त्याले वाटनं की, शेला बी त्याना भाऊनागत नको मराले, मंग तामार आपला बापना घर जाईन रावाले लागनी. ");
INSERT INTO ahr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","बराच काळ व्हवावर यहूदानी बायको जी शूवानी पोर व्हती ती मरण पावनी; तिनाकरता शोक कराना संपावर यहूदा त्याना मित्र अदुल्लामकर हिरा यानासंगे तिम्रा आठे आपला मेंढरंसना लोकर कातरनारासकडे गया. ");
INSERT INTO ahr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","तवय तामार हिले कोणीतरी सांगं की, तुना सासरा आपला मेंढरंसना लोकर कातराकरता तिम्रा आठे जाई राहिना शे. ");
INSERT INTO ahr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","तवय तिनी विधवाना कपडा उतारी दिधं अनी बुरखा लिसन आपला शरीरले झाकी लिधं अनी तिम्राना रस्तावरना एनाईम गावना वेशीजोडे ती जाईन बसनी; शेला जवान व्हई जायेल तरी बी माले अजून त्यानी बायको करं नही आशे तिले दखायनं. ");
INSERT INTO ahr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","यहूदानी तिले दखं, पण हाई कोणीतरी वेश्या व्हई; आशे त्याले वाटनं कारण तिनी आपला तोंड झाकेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","तवय हाई आपली सून शे हाई त्याले माहित नव्हतं, म्हणीसनं तो वाटवरतीन तिनाकडे वळीसन बोलना, चाल माले तुनाजोडे येऊ दे, तवय ती बोलनी, मनाजोडे येसी तर माले काय दिसी? ");
INSERT INTO ahr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","तो बोलना, मी मना कळपमाईन एक बच्चा तुले दि धाडसु; ती बोलनी, ते धाडस तोपावत मनाजोडे काय गहाण ठेवसी? ");
INSERT INTO ahr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","तो तिले बोलना, मी तुनाजोडे काय गहाण ठेवु? ती बोलनी, तुनी एखादी निशानी, गोफ अनं हातमाधली काठी दे, हाई दिसन तो तिनाजोडे गया तवय तिले त्यानापाईन गर्भ राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","तठेन ती निंघी गयी अनी आपला बुरखा काढीसन विधवाना कपडा परत घाली लिधात. ");
INSERT INTO ahr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","मंग त्या बाईपाईन आपला गहाण आणाकरता त्याना मित्र अदुल्लामकर यानाकडे यहूदानी एक बच्चा दि धाडं; पण त्याले ती सापडनी नही. ");
INSERT INTO ahr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","मंग त्यानी तठला लोकसले ईचारं, एनाईम गावनाजोडे रस्तावर एक वेश्या व्हती ती कोठे शे? त्या बोलनात, आठे कोणतीच वेश्या नव्हती. ");
INSERT INTO ahr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","मंग तो यहूदाकडे परत जाईसन बोलना, माले ती काही सापडनी नही; तठला लोकेसनी बी सांगं, आठे कोणतीच वेश्या नव्हती. ");
INSERT INTO ahr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","तवय यहूदा बोलना, ते वस्तु तिनाजोडेच राहु दे, नहीतर तठला लोके आपली टिंगल करतीन; मी तर बच्चा धाडं, पण तुले ती सापडनी नही. ");
INSERT INTO ahr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","हाई गोष्ट व्हवाले जोडेजोडे तीन महीना व्हई गया तवय कोणीतरी यहूदाले सांगं की, तुनी सून तामार हिनी वेश्याकर्म करं अनं त्या जारकर्ममुये तिले दिवस जायेल शेतस, तवय यहूदा बोलना, तिले बाहेर काढीसन जाळी टाका. ");
INSERT INTO ahr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","तिले बाहेर काढं तवय तिनी आपला सासराले निरोप धाडं की, ह्या वस्तु ज्या माणुसन्या शेतस त्यानापाईन माले दिवस राहेल शेतस; आखो ती बोलनी, डोळा नीट उघाडीसनं दखा, हाई निशान हाऊ गोफ अनं हाई काठी कोणी शे ती. ");
INSERT INTO ahr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदा त्या वस्तु वळखीसन बोलना, ती मनापेक्षा नितीमान शे; कारण मी मना पोऱ्या शेला तिले नवरा करी दिधा नही; अनी त्यानी परत कधीच तिनासंगे संबंध करं नही. ");
INSERT INTO ahr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","तिना प्रसूती येळले तिना पोटमा जुळा पोऱ्या शेतस अश दिसी वनं. ");
INSERT INTO ahr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","प्रसूतीना येळले एक लेकरूना हात बाहेर वना तवय सुइणीनी त्याना हातले लाल सूत बांधीसन सांगं, हाऊ पहिले जन्मना. ");
INSERT INTO ahr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","पण अश व्हयनं की, जवय त्यानी हात आखडाई लिधं तवय त्याना भाऊ पहिले जन्मना; तवय सूईण बोलनी, तू आपलाकरता कश वाट काढा? म्हणीन त्यानं नाव पेरेस अश पडनं. ");
INSERT INTO ahr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","मंग ज्याना हातले लाल सूत बांधेल व्हता तो जन्मना अनी‍ त्यानं नाव जेरह ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","इकडे योसेफले मिसरमा लई गयात, तवय ज्या इश्माएल लोकसनी त्याले तठे लयी जायेल व्हतात, त्यासनापाईन योसेफले पोटीफर नावना एक मिसरी अधिकारीनी त्याले ईकत लिधं; तो फारोना एक अमलदार व्हता अनी तो गारद्यासना सरदार बी व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","परमेश्वर योसेफनासंगे व्हता म्हणीन तो यशस्वी माणुस व्हयना; तो आपला मिसरी मालकना घरमा राहे. ");
INSERT INTO ahr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","परमेश्वर त्यानासंगे व्हता म्हणीन जे बी काम तो हातमा लेस, त्यामा परमेश्वर त्याले यशस्वी करस अस त्याना मालकले दखायनं. ");
INSERT INTO ahr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","योसेफवर त्यानी कृपादृष्टी व्हयनी; योसेफ त्यानी सेवा कराले लागना, अनी त्यानी त्याले आपला घरना कारभारी नेमीसन आपलं सर्व काही त्याना हातमा दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","अनी त्यानी त्याना ताबामा आपला घरदार अनं सर्वकाही दिधं, तवयपाईन योसेफ करता परमेश्वरनी त्या मिसरीना घरदारना भलं करं, अनी त्याना घरदार अनं शेतीवाडी या सर्वासमा परमेश्वरनी आशिर्वाद दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","त्यानी आपलं सर्वाकाही योसेफना हातमा दियेल व्हता, म्हणीसनं तो जे जेवण करे त्यानापलीकडे आपलं काही शे यानं त्याले काहीच माहीत नव्हतं, योसेफ तर दखावाले देखणा व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","मंग आशे व्हयनं की, योसेफनी मालकनी बाई त्यानावर डोया ठेईन त्याले बोलनी, मनाजोडे झोप. ");
INSERT INTO ahr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","पण तो राजी व्हयना नही, तो आपला मालकनी बाईले बोलना, हाई दख, घरमा मना ताबामा काय शे, यानं मना मालकले भान सुध्दा नही शे; आपला सर्व काही त्यानी मना हातमा देयल शे. ");
INSERT INTO ahr_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","हाई घरमा मनापेक्षा त्या मोठा नहीत; अनी त्यासनी तुमले सोडीन जी त्यानी बायको शे, बाकीना सर्वा गोष्टी मनापाईन दूर ठेयल नहीत, तवय मी अश मोठी वाईट गोष्ट करीसन देवना विरूध्द पाप कश करू. ");
INSERT INTO ahr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","मंग अश व्हयनं की, ती रोज रोज योसेफनासंगे बोले, पण तिनाजोडे झोपाले किंवा तिनासंगे राहावाले तो तिना आयके नही. ");
INSERT INTO ahr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एक दिनले अश व्हयनं की, तो आपला काही कामकाज कराले घरमा गया, त्या येळले घरमाधला माणसंमाईन कोणी बी माणुस तठे घरमा नही व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","तवय तिनी त्याना कपडा धरीसन बोलनी, मनाजोडे झोप; पण तो आपला कपडा तिना हातमा सोडीसन पळी गया. ");
INSERT INTO ahr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","जवय तिनी हाई दखं, की, तो आपला कपडा मना हातमा सोडीसन पळी जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","तवय तिनी घरना माणसंसले बलाईसन सांगं, \"दखा, आमनी अब्रु लेवाकरता त्यासनी हाऊ इब्री माणुस घरमा आणेल शे; तो मनाजोडे झोपाकरता मजार मनाजोडे येयल व्हता, तवय मी जोरमा ओरडनू. ");
INSERT INTO ahr_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","मी जोरमा ओरडनू हाई दखीन तो त्याना कपडा मनाजोडे सोडीसन बाहेर पळी गया. ");
INSERT INTO ahr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","त्याना मालक घर येसतोपावत तिनी तो कपडा आपलाजोडे ठेवात. ");
INSERT INTO ahr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","तो येवावर तिनी त्याले आशे सांगं, की, जो इब्री दास तुम्हीन आपला घरमा आणेल शे, तो मनी अब्रु लेवाले मनाकडे येयल व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","मी जोरमा ओरडनू तवय तो आपला कपडा मनाजोडे टाकीसन बाहेर पळी गया. ");
INSERT INTO ahr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","मना नोकरनी मनासंगे अश वर्तन करं, हाई जवय त्यानी आपली बायकोनी सांगेल आयकं, तवय त्याले भलता राग वना. ");
INSERT INTO ahr_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","योसेफना मालकनी त्याले धरं, अनी राजाना कैदी व्हतात त्या बंदीगृहमा टाकात; तो त्या बंदीगृहमा राहिना. ");
INSERT INTO ahr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","पण परमेश्वर योसेफनासंगे व्हता, त्यानी त्यानावर दया करी, अनी त्या बंदीगृहना अधिकारीनी त्यानावर कृपादृष्टी व्हई अस करं. ");
INSERT INTO ahr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","बंदीगृहना अधिकारीनी त्या बंदीगृहमाधला सर्वा कैदी योसेफना हातमा दिधा; अनी तठे जे काही त्या करेत, ते करी लेनारा तो राहे. ");
INSERT INTO ahr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","त्याना हातमा जे काही व्हतं त्याकडे बंदीगृहना अधिकारी दखे नही, कारण परमेश्वर योसेफनासंगे व्हता, अनी जे काही तो काम करे, त्यामा परमेश्वर यशस्वी करे. ");
INSERT INTO ahr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","यानानंतर अश व्हयनं की, मिसरना राजाना प्यालेबरदार अनं आचारी या दोन्हीसनी आपला मालक मिसरना राजा याना अपराध करा. ");
INSERT INTO ahr_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","प्यालेबरदारसना नायक अनं आचारीसना नायक ह्या त्याना दोन्ही सरदारसवर फारो रागावना. ");
INSERT INTO ahr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","तवय त्यानी त्यासले गारद्यासना सरदारसना वाडामा कैद करी ठेवं; तठेच योसेफ बी कैदमा व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","गारद्यासना सरदारनी योसेफले त्यासना अधिकारी नेमा; अनं त्यानी त्यासनी सेवा करी; तठे त्या काही दीन कैदमा राहिनात. ");
INSERT INTO ahr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","बंदीगृहमा कैदमा पडेल मिसरी राजाना प्यालेबरदार अनं आचारी या दोन्हीसले एकच रातले त्यासले लागु व्हतीन अश अर्थना स्वप्न पडनात. ");
INSERT INTO ahr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","सकासले योसेफ त्यासनाकडे गया तवय त्या त्याले नाराज दखायनात. ");
INSERT INTO ahr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","तवय त्यानी फारोना त्या सरदारले ज्या त्यानासंगे त्याना मालकना बंदीगृहमा कैद व्हतात, त्यासले ईचारं, आज तुमना तोंडे का बर उतरेल दखाई राहिनात शेतसॽ ");
INSERT INTO ahr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","त्या त्याले बोलनात, “आमले स्वप्न पडेल शे, पण त्याना अर्थ सांगनारा कोणी नही शे,” “योसेफ त्यासले बोलना, सपनना अर्थ सांगानं काम देवना शे?” तुम्हीन आप आपल सपन माले सांगा. ");
INSERT INTO ahr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","प्यालेबरदारसना नायकनी योसेफले आपला स्वप्न सांगा, ते अश व्हतं, स्वप्नमा मनासमोर एक द्राक्षवेल व्हता, ");
INSERT INTO ahr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","त्या द्राक्षवेलले तीन फाटा व्हतात, त्याले कळ्या लागीसन बहार वना मंग त्याना गुच्छासले द्राक्ष लागीसन पिकनात. ");
INSERT INTO ahr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","अनी फारोना प्याला मना हातमा व्हता; मी द्राक्ष लिसन त्या फारोना प्यालामां पिळात अनं तो प्याला फारोना हातमा दिधा. ");
INSERT INTO ahr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","योसेफ त्याले बोलना, याना अर्थ आशे शे, त्या तीन फाटा म्हणजे तीन दिन. ");
INSERT INTO ahr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","तीन दिनमा फारो तुले उचा करी अनी तुले तुना पदवर परत नेमी, अनी तू पहिला सारखा फारोना प्यालेबरदार व्हईसन त्याना हातमा प्याला दिशी. ");
INSERT INTO ahr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","पण तुना भलं व्हयनं तर मनी आठवन कर, अनी मनावर कृपा करीसनं फारोनाजोडे मनी चर्चा कर अनी हाई बंदीगृहमाईन मनी सुटका कर. ");
INSERT INTO ahr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","कारण माले इबऱ्यासना देशमाईन चोरी आणेल शे; अनी आठे बी मी अश काही काम करेल नही ज्यानामुये मी हाई बंदीगृहमा टाकाई जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","सपनना अर्थ चांगला शे हाई दखीसन, आचारीसना नायक योसेफले बोलना, माले बी अश सपन पडनं की, धवया भाकरीसन्या तीन टोपल्या मना डोकावर व्हत्यात. ");
INSERT INTO ahr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","अनी वरनी टोपलीमा फारोनाकरता सर्वा प्रकारना बनाडेल जेवण व्हता, अनी पक्षी मना डोकावरन्या टोपलीमाधलं वस्तुसले खाई राहिंतात. ");
INSERT INTO ahr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","योसेफनी त्याले उत्तर दिधं, हाऊ सपनना अर्थ आशे शे, त्या तीन टोपल्या म्हणजे तीन दिन; ");
INSERT INTO ahr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","फारो तीन दिनमा तुना मुंडका वर करीन उडाई, तुले झाडवर फाशी दि अनी चिडा तुना मास तोडीन खातीन. ");
INSERT INTO ahr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","तिसरा दिनले फारोना जन्मदिन वना, तवय त्यानी आपला सर्वा चाकरंसले मेजवाणी दिधी, अनी त्यानी आपला प्यालेबरदारसना नायक अनं आचारीसना नायक यासले समोर आणात. ");
INSERT INTO ahr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","त्यानी प्यालेबरदारसना नायकले त्याना पदवर परत नेमा, अनी तो फारोना हातमा प्याला देवाना काम कराले लागना. ");
INSERT INTO ahr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","पण त्यानी आचारीसना नायकले फाशी दिधी, योसेफनी त्यासना सपनना अर्थ सांग व्हतं तस घडनं. ");
INSERT INTO ahr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","पण प्यालेबरदारसना नायकले योसेफनी आठवन ऱ्हायनी नही, तो त्याले ईसरी गया. ");
INSERT INTO ahr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","पुरा दोन वरीस व्हवावर फारोले एक सपन पडनं, त्यामा तो नील नदीना काठवर उभा राहिना शे. ");
INSERT INTO ahr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","मंग दखा, नील नदीमाईन सात सुंदर अनं धष्टपुष्ट गायी नदीमाईन बाहेर निंघीसन लव्हाळमा चराले लागन्‍यात. ");
INSERT INTO ahr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","त्यानानंतर अजून सात गायी ज्या कुरूप अनं दुबळ्या व्हत्यात त्या नील नदीमाईन निंघन्यात अनी दुसऱ्या गायीसना जोडे जाईन नदीकाठवर उभ्या राहिन्यात. ");
INSERT INTO ahr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","तवय कुरूप अनं दुबळ्या गायीसनी त्या सुंदर अनं धष्टपुष्ट गायीसले खाई टाकं, तवय फारो जागा व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","मंग तो परत झोपना तवय त्याले दुसरांदाव स्वप्न पडनं की, एकच ताटले सात चांगला भरदार कणसे वनात; ");
INSERT INTO ahr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","अनी त्यानानंतर खूरटलेल अनं पुर्वकडना गरम झाकासघाई करपेल अश सात कणसं निंघनात. ");
INSERT INTO ahr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","त्या खूरटलेल कणसंसनी त्या सात चांगला भरदार कणसंसले गिळी लिधं, मंग फारो जागा व्हयना, त्यानी दखं, की, हाई स्वप्न व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","सकासले येळले फारोना मन अस्वस्त व्हयना, मंग त्यानी मिसर देशना सर्व ज्योतिषी अनं पंडीत यासले बलायं; फारोनी आपलं स्वप्न त्यासले सांग, पण त्यासनामाईन कोणलेच फारोना स्वप्नना अर्थ सांगता वना नही. ");
INSERT INTO ahr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","तवय प्यालेबरदारसना नायक फारोले बोलना, माले आज मना अपराधनी जाण व्हई ऱ्हाईनी शे. ");
INSERT INTO ahr_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","जवय फारो आपला सेवकसवर क्रोधीत व्हयेल व्हता, तवय त्यानी माले अनी आचारीसना नायकले गारद्यासना सरदारना वाडामा कैद करीसनं ठेयल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","तवय एकच रातले आमले दोन्हीसले, माले अनं त्याले लागु व्हतीन अश सारखाच अर्थना स्वप्न पडना. ");
INSERT INTO ahr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","तठे आमनासंगे एक इब्री जवान व्हता; तो गारद्यासना सरदारना दास व्हता; आम्हीन त्याले आपापला स्वप्न सांगात अनं त्यानी त्यासना अर्थ आमले सांगं; त्यानी प्रत्येकना स्वप्ननुसार त्याना अर्थ सांगं. ");
INSERT INTO ahr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","त्यानी आमले स्वप्नना अर्थ सांगांत तसंच घडी वनं; माले मना पदवर परत लिधात अनी त्याले फाशी देवामा वनी. ");
INSERT INTO ahr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","मंग फारोनी योसेफले बलावाले धाडां तवय त्याले तवयच बंदीगृहामाईन बाहेर आणं; अनी त्यानी आपला मुडंन करीसनं अनं कपडा बदलाईसनं फारोनासमोर वना. ");
INSERT INTO ahr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फारो योसेफले बोलना, मी एक स्वप्न दखेल शे, पण त्याना अर्थ सांगनारा कोणीच नही शे, मी तुनाविषयी आयकं की, तू स्वप्न ऐकताच त्याना अर्थ सांगस? ");
INSERT INTO ahr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","योसेफ फारोले बोलना, मी कोण शे सांगनारा? फारोले शांती देणारं उत्तर परमेश्वरच दि. ");
INSERT INTO ahr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","मंग फारोनी योसेफले सांगं, मी स्वप्नमा नील नदीना काठवर उभा व्हतु. ");
INSERT INTO ahr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","तवय दखा, सात धष्टपुष्ट अनं सुंदर गायी नदीमाईन बाहेर निंघीसन लव्हाळीसमा चराले लागनात; ");
INSERT INTO ahr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","अनी त्यासनामांगतीन दुबळ्या अनी कुरूप अश सात गायी निंघन्यात; त्यासनासारख्या बेढब गायी सर्वा मिसर देशमा मी कधीच दखात नही. ");
INSERT INTO ahr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ह्या दुबळ्या अनं कुरूप गायीसनी त्या पहिल्या सात पुष्ट गायीसले खाई टाकात. ");
INSERT INTO ahr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","त्या कुरूप गायीसनी तिसले खाई टाकात, तवय त्या तिसना पोटमा गयात अश दिसनच नही; पण पहिलासारख्याच त्या कुरूप राहिन्यात, मंग मी जागा व्हयनु. ");
INSERT INTO ahr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","परत मी आखो एक स्वप्न दखा, की, चांगला भरदार कणसं एकच ताटले वनात. ");
INSERT INTO ahr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","अनी त्यानामांगेन सुकेल, खुरटायेल अनं पुर्वना गरम झाकासघाई करपेल अस सात कणसं निंघनात. ");
INSERT INTO ahr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","अनी त्या सात खुरटायेल कणसंसनी त्या सात चांगला कणसंसले गिळी लिधं, हाई मी ज्योतिषसले सांगात, पण त्याना उलगडा करीन माले सांगनारा कोणीच नव्हता. ");
INSERT INTO ahr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","योसेफ फारोले बोलना, फारोले पडेल स्वप्न एकच शे; परमेश्वर जे काही कराव शे, ते त्यानी फारोले सांगेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","त्या सात चांगल्या गायी म्हणजे सात वरीस शेतस; अनी सात चांगला कणसं म्हणजे सात वरीस शेतस; स्वप्न एकच शे. ");
INSERT INTO ahr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","मांगेन येयल सात दुबळ्या अनं कुरूप गायी अनी सुकेल अनं पुर्वना गरम झाकासघाई करपेल सात कणसं ह्या दुष्काळना सात वरीस शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","हाई ती गोष्ट शे जी मी फारोले सांगी देयल शे, परमेश्वर जे काही कराव शे, ते त्यानी फारोले दखाडेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","दख, सर्वा मिसर देशमा सुकाळना सात वरीस ई राहिना शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","अनी त्यानानंतर दुष्काळना सात वरीस येतीन; तवय मिसर देशले सगया सुकाळना ईसर पडी, अनी दुष्काळमां देशना उजाड व्हयी. ");
INSERT INTO ahr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","पुढे जो दुष्काळ पडाव शे, त्यामुये सुकाळ व्हता की नव्हता त्यानं कोनलेच ध्यान रावाव नही, एवढं भयानक तो दुष्काळ राही. ");
INSERT INTO ahr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","हाई स्वप्न फारोले दोनदाव पडनं यानं कारण हाईच शे की, देवनी जे ठरायेल शे, ते देव लवकरच पुरा कराव शे. ");
INSERT INTO ahr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","तर आते फारोनी एकादा चतुर अनी शहाणा माणुस दखीसन त्याले मिसर देशवर नेमाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","अनी फारोनी हाई करीसन देशवर अधिकारी नेमाले पाहिजे अनी सुकाळना सात वरीसमा मिसर देशमाधलं उत्पन्नना पंचमांश लेवानं. ");
INSERT INTO ahr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","हाऊ येनारा सुकाळना वरीसमा सर्वा प्रकारना अन्न वस्तु गोया करानं अनी नगरनगरमा अन्नना पुरवठाकरता धान्यना साठा फारोना ताबामा ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","अनी हाई अन्न वस्तु दुष्काळना त्या सात वरीस करता उपयोगी राहतीन जो मिसर देशमा येवाव शे, त्यामुये दुष्काळमा देशना नाश व्हवावू नही. ");
INSERT INTO ahr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","हाई फारोले अनं त्याना सर्व सेवकसले लगेच पटनं. ");
INSERT INTO ahr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","तवय फारो आपला सेवकसले बोलना, ज्यानाठायी देवना आत्मा शे, अश ह्या मनुष्यनासारखा दुसरा कोणी सापडी का? ");
INSERT INTO ahr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","मंग फारो योसेफले बोलना, देवनी तुले ह्या गोष्टीसनी बुध्दी देयल शे, त्यामुये तुनासारखा चतुर अनं शहाणा दुसरा कोणीच नही शे. ");
INSERT INTO ahr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","तर आते तू मना घरना अधिकारी बनी जाय; तुना आज्ञाप्रमाणे मनी बठी प्रजा चाली, मी फक्त राजासनां पुरता तुनापेक्षा मोठा ऱ्हासु. ");
INSERT INTO ahr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","फारो योसेफले आखो बोलना, दख, मी तुले सर्वा मिसर देशवर नेमसं. ");
INSERT INTO ahr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","मंग फारोनी आपला बोटमाधली अंगठी काढीसन योसेफनी बोटमा घाली; त्याले तलम तागना वस्त्र घाली दिधं, अनी‍ त्याना गळामा सोनानी माळ घाली दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","मंग त्यानी त्याले आपला मांगेना रथवर बसाडं, अनी मजुरा करं, अश त्या त्यानापुढे घोषणा करीसन चालाले लागनात अस त्यानी त्याले सर्व मिसर देशवर अधिकारी नेमं. ");
INSERT INTO ahr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","फारो योसेफले हाई बी सांगं, मी जरी फारो शे, पण तुना हुकुमशिवाय मिसर देशमा कोणी हात अनं पाय हालावु नही. ");
INSERT INTO ahr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फारोनी योसेफना नाव सापनाथ-पानेह अस ठेवं; अनी ओन आठेना याजक पोटीफरा यानी पोर आसनथ हाई त्याले बायको करी दिधी, मंग योसेफ मिसर देशमा दौरा कराले लागना. ");
INSERT INTO ahr_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","जवय योसेफ मिरसना राजा फारो यानापुढे जाईन उभा राहिना तवय तो तीस वरीसना व्हता, मंग योसेफ फारोना जोडेतीन निंघीसन सर्वा देशमा दौरा कराले लागना. ");
INSERT INTO ahr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","त्या सुकाळना सात वरीसमा जमीनले भरपुर पिक वनं. ");
INSERT INTO ahr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","म्हणीन त्यानी या सात वरीसमा मिसर देशमाधलं सर्वा प्रकारना अन्न वस्तु गोया करीसन नगर नगरमा गोया करी ठेवं; एक एक नगरना आसपासना पिक त्यानी त्या त्या नगरमा गोया करी ठेवं; ");
INSERT INTO ahr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","योसेफनी समुद्रना वाळूनागत धान्यना बराच साठा करी ठेवं; त्यानी मोजानं सोडी दिधं कारण त्यानं हिशाब ठेवानं कठीण व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","दुष्काळ पडाना पहिले ओन आठला याजक पोटीफरा यानी पोर आसनथ हिनापाईन योसेफले दोन पोऱ्या व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","योसेफनी आपला पहिला पोऱ्यानं नाव मनश्शे ठेवात; कारण तो बोलना, देवनी मना सर्वा क्लेश अनी मना बापना सर्वा घरानासना विसर पाडेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","त्यानी दुसराना नाव एफ्राईम ठेवात; कारण तो बोलना, मना विपत्तीना देशमा देवनी माले फलद्रूप करेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","मिसर देशमाधलं सुकाळना सात वरीस सरी गयात. ");
INSERT INTO ahr_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","मंग योसेफनी सांगेल प्रमाणे दुष्काळना सात वरीस सुरू व्हयनात, तवय देशदेशमा दुष्काळ पडना, पण मिसर देशमा बठीकडे अन्नधान्य व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","सगया मिसर देशनी उपासमार व्हवाले लागनी अनं लोके फारोनाजोडे अन्न मांगाले लागनात, तवय फारो सर्वा मिसरी लोकसले बोलना, योसेफकडे जा; तो तुमले सांगी तश करा. ");
INSERT INTO ahr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","जवय दुष्काळ सर्वा पृथ्वीवर पडना, तवय योसेफ कोठारं उघडीसन मिसरी लोकसले अन्न ईकाले लागना, कारण मिसर देशमा बी भयंकर दुष्काळ पडेल व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","तवय देशदेशमाधला लोके धान्य ईकत लेवाकरता मिसर देशमा योसेफकडे गयात, कारण सर्वा पृथ्वीवर भयंकर कडक दुष्काळ पडेल व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","जवय याकोबनी आयकं की, मिसर देशमा धान्य शे, तवय तो आपला पोऱ्यासले बोलना, तुम्हीन एकमेकसना तोंड काय दखी ऱ्हाईना शेतस? ");
INSERT INTO ahr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","तो त्यासले बोलना, दखा, मी आयकेल शे की, मिसर देशमा धान्य शे, तुम्हीन तठे जाईसन आपलाकरता धान्य ईकत लयी या, म्हणजे आपण जगसुत, मरावुत नही. ");
INSERT INTO ahr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","मंग योसेफना दहा भाऊ धान्य ईकत लेवाकरता मिसर देशमा गयात. ");
INSERT INTO ahr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","पण याकोबनी योसेफना भाऊ बन्यामिनले त्याना भाऊसनासंगे धाडं नही, कारण तो बोलना, कदाचित यावर एकादं संकट ई पडी. ");
INSERT INTO ahr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","अश प्रकारं याकोबना पोऱ्याबी इतर लोकसनासंगे धान्य ईकत लेवाकरता वनात; कारण कनान देशमा दुष्काळ पडेल व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","योसेफ त्या देशना प्रधानमंत्री व्हता, अनी देशना सर्वा लोकसले तोच धान्य ईकत दि राहिंता, योसेफना भाऊसनी ईसन त्याले जमीनपावत झुकीन नमन करात. ");
INSERT INTO ahr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","योसेफनी आपला भाऊसले दखताच वळखी लिधं, पण त्यासनासंगे अनोळखी प्रमाणे वागीसन त्यानी कठोर पणतीन त्यासले ईचारं, की, तुम्हीन कोठेन येयल शेतस? त्यासनी सांगं, कनान देशमाईन धान्य ईकत लेवाकरता आम्हीन येयल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","योसेफनी आपला भाऊसले वळखी लिधं, पण त्यासनी त्याले वळखं नही. ");
INSERT INTO ahr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","मंग त्यानाविषयी ज्या स्वप्न पडेल व्हतात, ते योसेफले आठवीसन तो त्यासले बोलना, “तुम्हीन जासुस शेतस, देशनी बिकट आवस्था दखाकरता तुम्हीन येल शेतस.” ");
INSERT INTO ahr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","तवय त्या त्याले बोलनात, नही महाराज; आपला दास फक्त धान्य ईकत लेवाकरता येयल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","आम्हीन सर्व एकच माणुसना पोऱ्या शेतस, अनी आम्हीन इमानदार माणसं शेतस, तुमना दास जासुद नही शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","तो त्यासले बोलना, नही तुम्हीन देशनी बिकट आवस्था दखाकरता येयल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","पण त्या त्याले बोलनात, आम्हीन तुमना दास बारा भाऊ शेतस अनी कनान देशवासी एकच माणुसना पोऱ्या शेतस; अनी दखा, सर्वसमा धाकला या येळले बापनाजोडे शे अनी एक भाऊ मरी गया. ");
INSERT INTO ahr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","मंग योसेफ त्यासले बोलना, तर मंग मी तुमले बोलनु ते खरं शे, तुम्हीन जासुस शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","आते तुमनी परीक्षा लेस; फारोनी जीवनी शपथ, तुमना धाकला भाऊ आठे येवाशिवाय तुमनी आठेन सुटका व्हवाव नही. ");
INSERT INTO ahr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","तुमनापाईन एकले तुमना भाऊले लेवाले धाडा; तुम्हीन आठेच कैदमा राहा; म्हणजे तुम्हीन ज्या सांगतस ते खरं शे की, नही यानी परिक्षा व्हई, नहीते फारोनी जीवनी शपथ, तुम्हीन जासुस ठरशात. ");
INSERT INTO ahr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","मंग त्यानी त्यासले तीन दिन कैदमा ठेवं. ");
INSERT INTO ahr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तिसरा दिनले योसेफ त्यासले बोलना, तुम्हीन एक काम करा तरच तुमना जीव वाची, कारण मी देवना भय धरनारा शे. ");
INSERT INTO ahr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","जर तुम्हीन खरा माणसे व्हशात तर तुमना भाऊसमाईन एकले तुमना हाई कैदखानामा आठे राहु द्या अनी तुमना घरनासनी उपासमार व्हवाले नको म्हणीसनं तुम्हीन धान्य लई जा; ");
INSERT INTO ahr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","अनी तुमना धाकला भाऊले मनाकडे लई या, म्हणजे तुमनं बोलानं माले खरं वाटी अनं तुमनं मरण टळी जाई, तवय त्यासनी तसच करं. ");
INSERT INTO ahr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","तवय त्या एकमेकसले बोलनात, आपण आपला भाऊना विषयमा अपराधी शेतस, कारण त्यानी रावन्या करात तरी आम्हीन त्याना दु:खले दखनुत, अनी आम्हीन त्यानं ऐका नही, म्हणीन हाई संकट आमनावर येल शे. ");
INSERT INTO ahr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रऊबेन त्यासले बोलना, पोऱ्याले काही अपाय करानं नही अश मी तुमले बोलनु नव्हतु का? पण तुम्हीन मना आयकं नही; दखा, आते त्याना रक्तना बदला देना पडी ऱ्हाईना शे. ");
INSERT INTO ahr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","त्यासले हाई माहीत नही व्हतं की, योसेफनी आमनं बोलनं समजी लियेल शे, कारण त्यासनामा दुसरी भाषा बोलनं चालु व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","तो त्यासनापाईन एक बाजुले जाईसन रडना; मंग परत ईसन तो त्यासनासंगे बोलाले लागना; त्यानी त्यासनामाईन शिमोनले काढीसनं त्यासनादेखत बांधं. ");
INSERT INTO ahr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","मंग योसेफनी आज्ञा दिधी की, त्यासना गोणीमा धान्य भरा; प्रत्येकना पैसा ज्यानात्याना गोणीमा टाका, वाटमां जेवण कराले द्या. ");
INSERT INTO ahr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","आशे त्या गधडासवर धान्य ठेयीसनं तठेन निंघनात. ");
INSERT INTO ahr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","त्यासनामाईन एकनी वाटमा आपला गधडासले चारा देवाकरता आपली गोणी उघाडी, तवय आपला पैसा गोणीना तोंडनाजोडे ठेयेल दखं, ");
INSERT INTO ahr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","“अनी तो आपला भाऊसले बोलना, मना पैसा परत करेल शे, दखा, हाऊ मनी गोणीमा शे, तवय त्यासना जीवमा जीव राहिना नही, त्या घाबरीसन एकमेकसले दखीन बोलाले लागनात, देवनी आमनासंगे हाई काय करेल शे.?” ");
INSERT INTO ahr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","मंग त्या कनान देशले आपला बाप याकोब यानाजोडे जाईन पोहचनात अनी जे काही त्यासनासंगे व्हयेल व्हतं ते सर्वा त्यासनी त्याले सांगा, ते आशे; ");
INSERT INTO ahr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","त्या देशना अधिकारी आमनासंगे कठोरतीन बोलना, अनं त्यानी आमले जासुस ठरायं. ");
INSERT INTO ahr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","पण आम्हीन त्याले बोलनुत, आम्हीन खरा माणसे शेतस, आम्हीन जासुस नही. ");
INSERT INTO ahr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","आम्हीन बारा भाऊ एकच बापना पोऱ्या शेतस, ज्यानामाईन एक नही ऱ्हायना अनी सर्वासमा धाकला हाऊ येळले कनान देशमा आमना बापनाजोडे शे. ");
INSERT INTO ahr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","यावर तो माणुस बोलना, म्हणजे त्या देशना अधिकारी आमले बोलना, तुम्हीन खरा माणसे शेतस तर, तुम्हीन तुमना एक भाऊले मनाजोडे राहु द्या. अनी आपला घरनासना उपासमार व्हवाले नको म्हणीन तुम्हीन धान्य लई जा. ");
INSERT INTO ahr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","तुम्हीन तुमना धाकला भाऊले मनाजोडे लई या म्हणजे माले खरं वाटी की, तुम्हीन जासुस नही शेतस, तर चांगला माणसे शेतस; मंग मी तुमना भाऊ तुमले परत दिसु अनी तुमले हाई देशमा धान्य ईकत लेता ई. ");
INSERT INTO ahr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","मंग त्या सर्वजण आपापला धान्यसन्या गोणी रिकाम्या करी राहिंतात तवय प्रत्येकनी पैसासनी थैली ज्यानात्याना गोणीमा सापडनी; त्यासना बापनी अनं त्यासनी त्या पैसासन्या थैल्या दखात तवय त्या भलताच घाबरनात. ");
INSERT INTO ahr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","त्यासना बाप याकोब त्यासले बोलना, तुम्हीन माले मना पोऱ्यासपाईन वंचित करी देयल शे; योसेफ नही राहिना, शिमोन बी नही शे, अनी तुम्हीन बन्यामिनले बी लि जावाले दखी राहिना शेतस; हाई बठं संकट मनावर ई पडेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","मंग रऊबेन त्याना बापले बोलना, मी जर त्यासले नही लयनु, तर तुम्हीन मना दोन पोऱ्यासले मारी टाका; त्याले मना हवाली करा, मी त्याले परत तुमनाकडे आणसु. ");
INSERT INTO ahr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","पण याकोब बोलना, मी मना पोऱ्याले तुमनासंगे धाडावु नही कारण त्याना भाऊ बी मरी जायेल शे अनी तो आते एकटाच राहिना शे; जर तुमना मार्गमाच त्यानावर एकाद संकट ई पडना, तवय ते मंग तुम्हीन माले दु:खमा धैयडपनमां अधोलोकमा उतारी दिशात. ");
INSERT INTO ahr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","देशमा दुष्काळ भयानक व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","त्यासनी मिसर देशमाईन आणेल धान्य खाईसन संपाडं तवय त्यासना बाप त्यासले बोलना, परत जाईसन आपलाकरता धान्य ईकत लई या. ");
INSERT INTO ahr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","तवय यहूदा त्याले बोलना, त्या माणुसनी आमले ताकीद दिसन सांगना शे की, तुम्हीन तुमना भाऊले लयात नही तर तुमले मनं तोंड दखता येवाव नही. ");
INSERT INTO ahr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","तुम्हीन आमना भाऊले आमनासोबत धाडत व्हशात तर आम्हीन जाईन तुमनाकरता धान्य ईकत आणसुत. ");
INSERT INTO ahr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","पण जर तुम्हीन आमना भाऊले आमनासंगे नही धाडशात, तर आम्हीन बी जावावुत नही; कारण त्या माणुसनी आमले बोलना शे की, तुम्हीन तुमना भाऊले संगे आणात नहीत तर तुमले मनं तोंड दखता येवाव नही. ");
INSERT INTO ahr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","मंग याकोब बोलना, अजून एक भाऊ शे अश त्या माणुसले सांगीन मनावर काबंर हाई संकट आणा? ");
INSERT INTO ahr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","पण त्या सांगाले लागनात, त्या माणुसनी आमले आमना घरनाविषयी बारीकी ईचारी, तो आमले बोलना, तुमना बाप अजून जिवत शे का? तुमले अजून एक भाऊ शे का? तवय त्याना ह्या प्रश्नासना उत्तर आमले देना पडना, तुम्हीन तुमना भाऊले लई अश तो आमले सांगी हाई आमले पहिले कश कळतं? ");
INSERT INTO ahr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","मंग यहूदा आपला बाप याकोबले बोलना, पोऱ्याले मनासंगे धाड, म्हणजे आमी प्रवासले निंघसुत; त्यामुये आमी, तुम्हीन अनं आमना पोऱ्यासोऱ्या वाचतीन, मरावुत नहीत. ");
INSERT INTO ahr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","मी त्याना जामीन व्हस, त्यानी हमी मी लेस, मी त्याले परत आणीसन तुमनाजोडे स्वाधीन नही करं तर मी कायमना तुमना दोषी ऱ्हासु. ");
INSERT INTO ahr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","आम्ही येळ नही करतुत ते आमनी आते दुसरी खेप व्हयेल ऱ्हाती. ");
INSERT INTO ahr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","मंग त्यासना बाप याकोब त्यासले बोलना, अश व्हई ते मंग एवढं करा; हाई देशमा उत्पन्न व्हनारा मोलवान पदार्थ त्या माणुसले भेट म्हणीसन देवाकरता आपला गोणीमा थोडाचं डिंक, थोडाचं मध, मसाला अनं गंधरस, अनी काही पिस्त बदाम घालीसन लई जावा. ");
INSERT INTO ahr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","दुप्पट पैसा सोबत लई जावा; तुमना गोणीमा जो पैशा परत येल शे, तो बी परत लई जावा, कदाचित काही चूक व्हयनी व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","तर आते तुमना भाऊले सोबत लिसन त्या माणुसकडे निंघा. ");
INSERT INTO ahr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","त्या माणुसनाजोडे जावावर सर्वसमर्थ देवले तुमनी दया येवो, अनी तुमना भाऊ बन्यामिनले तो माणुस परत तुमना हवाली करो अनी यावर मी आपला पोऱ्यासले मुकनु ते मुकनु. ");
INSERT INTO ahr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","मंग त्या माणसंसनी ती भेट संगे लिधं; दुप्पट पैसा हातमा लिधं, अनी बन्यामिनले संगे लिसन त्या मिसर देशमा निंघी गयात अनं योसेफना पुढे जाईन उभा राहिनात; ");
INSERT INTO ahr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","योसेफनी त्यासनासोबत बन्यामिनले दख, तवय तो घरना अधिकारीले सांगना, हाऊ माणुसले घरमा लि जाय, पशु मारीसन जेवण तयार कर, कारण आज दोनना प्रहरले ह्या माणसे मनासंगे जेवण कराव शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","योसेफनी सांगाप्रमाणे त्या माणुसनी करं, अनी मंग त्यानी त्यासले योसेफना घरमां आणं. ");
INSERT INTO ahr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","आपलाले योसेफना घरमा आणं म्हणीसनं त्या भलताच घाबरी गयात अनं बोलनात, पहिला येळले आपला गोणीमा पैसा परत गया म्हणीसनं आपलाले मजार लई जायी ऱ्हाईना शेतस; यानं ईचार अश दिसच की, काहीतरी कारण काढीसन आपलावर तुटी पडानं, अनं आपला गधडा बी लिसन आपलाले नोकर बनाडी लेवानं. ");
INSERT INTO ahr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","तवय त्या योसेफना घरना अधिकारीकडे वनात अनी घरना फाटकजोडे त्यानासंगे बोलनात, ");
INSERT INTO ahr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","महाराज, कृपा करीसन आमनं ऐकी ल्या, पहिला येळले धान्य ईकत लेवाले आम्ही आठे येयल व्हतुत. ");
INSERT INTO ahr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","पण तवय अश व्हयनं की, आम्ही घर जाई राहिंतुत तवय उतार शाळमा जाईन पोहचनुत अनी आपला गोणी उघडीसन दखात तवय प्रत्येकजनना पुरा पैसा ज्यानात्याना गोणीमा ठेयल दिसना म्हणीन आम्हीन तो आमनासोबत परत लेयल शे. ");
INSERT INTO ahr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","अनी धान्य ईकत लेवाकरता अजून पैसा बी आणेल शे; आमना गोणीमा पैसा कोणी ठेवात हाई आमले माहीत नही. ");
INSERT INTO ahr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","तो बोलना, तुम्हीन खुश रावा, घाबरू नका, तुमना अनं तुमना बापना देव यहोवा यानी तुमना गोणीमा धन घालेल व्हई; माले ते तुमना पैशा भेटी जायेल शे. मंग त्यानी शिमोनले त्यासनाकडे आणं. ");
INSERT INTO ahr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","तवय त्या माणुसनी त्यासले योसेफना घरमा लिसन पाणी दिधं, अनी त्यासनी आपला पाय धुवात; अनं त्यानी त्यासना गाढवंसले चारा बी दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","दुपारले योसेफ येवाव शे त्या येळले त्याले देवाकरता त्यासनी भेट तयार करी ठेई; कारण आपलाले आठे जेवण करानं शे हाई त्यासले समजी जायेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","योसेफ घर वना तवय त्यासनी आपलासंगे भेट आणेल व्हती ती घरमा आणीसन त्यानापुढं ठेवं अनी त्याले जमीनपावत झुकीन नमन करं. ");
INSERT INTO ahr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","मंग योसेफनी त्यासले क्षेमकुशल ईचारं; “त्यानी सांगं, मांगना येळले तुमना म्हतारा बापना विषयी सांगं व्हतं तो सुखरूप शे ना? तो अजून जिवत शे ना?” ");
INSERT INTO ahr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","त्या त्याले बोलनात, तुमना दास आमना बाप सुखरूप शे, तो अजून जिवत शे त्यासनी त्याले झुकीन नमन करं. ");
INSERT INTO ahr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","तवय त्यानी नजर वर करीसन आपला सगा भाऊ बन्यामिनले दखं, अनी ईचारं, हाऊच तुमना धाकला भाऊ शे का ज्यानी चर्चा तुम्हीन मनासंगे करा व्हतं, मंग तो त्याले बोलना, हे मना पोऱ्या परमेश्वरनी तुनावर कृपा व्हवो. ");
INSERT INTO ahr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","तवय आपला भाऊले दखीन त्यानं मन भरी वनं अनी कोठेतरी जाईन रडावं अश त्याले व्हई गयं, म्हणीन तो पटकन मझारनी खोलीमा जाईन रडना. ");
INSERT INTO ahr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","मंग तो आपला तोंड धुईसन परत बाहेर वना अनी आपला गहिंवर आवरीन बोलना, जेवण वाढा. ");
INSERT INTO ahr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","तवय त्‍यासनी त्यासनं ताट येगळा मांडात, त्याना भाऊसना ताट येगळा मांडात अनी त्यासनासंगे भोजन करनारा मिसरी लोकसना ताटे येगळी मांडात; कारण मिसरी इब्रीसना पंगतमा बसीसन भोजन नही करेत; मिसरी लोकसले हाई गोष्टनी किळस वाटे. ");
INSERT INTO ahr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","त्यासले पंगतमा योसेफनासमोर बसाडं तवय पहिला पोऱ्याना हक्कप्रमाणे पहिलाले प्रथम बसाडं, अनी बाकीनासले त्यासना वयना क्रमतीन बसाडं; तवय त्या चकित व्हईसन एकमेकसले दखाले लागनात. ");
INSERT INTO ahr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","मंग योसेफ समोरना जेवण त्यासले लिसन वाढात; पण बन्यामिनले बाकीनापेक्षा पाचपट जास्त वाढात; अनी त्या त्यानासोबत भरपुर खाद पिद. ");
INSERT INTO ahr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","मंग त्यानी आपला अधिकारीले आज्ञा करी की, ह्या माणसंसना गोणीसमा त्यासले लई जाता ई तितलं धान्य भरा अनी प्रत्येकना पैसा ज्यानात्याना गोणीमा ठेवा. ");
INSERT INTO ahr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","अनी मना चांदीना पेला धान्यसना पैशासंगे सर्वासमा धाकलाना गोणीना तोंडनाजोडे ठेव, अनी जश योसेफनी सांगेल व्हतं तश त्यानी करा. ");
INSERT INTO ahr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","सकाळ व्हताच त्या माणसंसले त्यासना गाढवंसना संगे निरोप दिधा. ");
INSERT INTO ahr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","त्या नगर सोडीसन जास्त दूर गयात नहीत तोवर योसेफ आपला अधिकारीले बोलना, चल, त्या माणसंसना पाठलाग कर, अनी जवय तू त्यासनाजोडे जाशी तवय त्यासले बोल, तुम्हीन चांगलानी फेड वाईटतीन का बर करात? (मना चांदीना पेला तुम्हीन का बर चोरनात?) ");
INSERT INTO ahr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ज्यामा मना मालक पेस अनं ज्यामा शकुन बी दखस, तो हाऊच नही शे का? तुम्हीन अश करीसन भलतं वाईट करेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","तो त्यासनाजोडे गया तवय अश बोलना. ");
INSERT INTO ahr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","त्या त्याले बोलनात, आमना मालक काबंर अश शब्द बोली राहिना शे? अश गोष्ट करानं आपला दासंसपाईन दूर राहो. ");
INSERT INTO ahr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","दखा, जो पैसा आमले आमना गोणीना तोंडजोडे सापडना व्हता तो पण कनान देशमाईन परत आणीसन आपलाले दिधा, तर आपला मालकना घरमाधलं सोनं रूपा आम्हीन कश बर चोरसुत. ");
INSERT INTO ahr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","आपला दासंसपाईन ज्या कोणपान बी ते सापडनं त्याले मारी टाकनं, अनी आम्हीन बी त्या आमना मालकना नोकर बनसुत. ");
INSERT INTO ahr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","तो त्यासले बोलना, तर तुमना सांगाप्रमाणे व्हवु द्या; ज्यानाजोडे तो चांदीना पेला सापडी तो मना नोकर व्हई अनं बाकीना निर्दोष ठरतीन. ");
INSERT INTO ahr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","तवय त्यासनी लगेच धान्यसनी गोणी जमीनवर उतारीसन प्रत्येकनी आपआपली गोणी सोडी दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","तवय त्यानी मोठा पाईन सुरवात करीन सर्वासमा धाकलापावत त्यासनी झडती लिधी तवय तो चांदीना पेला बन्यामिनना गोणीमा सापडनं. ");
INSERT INTO ahr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","हाई दखीसन त्यासनी आपापला कपडा फाडात अनी आपलं गधडा लादीसन त्या सर्वा नगरमा परत वनात. ");
INSERT INTO ahr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","मंग यहूदा अनी त्याना भाऊ योसेफना घर गयात; तो अजून तठेच व्हता, अनी त्यासनी त्यानापुढं जमीनवर लोटांगण घालनात. ");
INSERT INTO ahr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","योसेफ त्यासले बोलना, तुम्हीन अश काम का बर करनात? मनासारखा माणुसले शकुन दखता येस हाई तुमले माहीत नही का? ");
INSERT INTO ahr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदा बोलना, आम्हीन मालकनापुढे काय बोलुत? आम्हीन काय सांगानं? आमनावरना हाऊ आरोप कश दूर करानं? आपला दासंसना दोष देवनी पकडेल शे; तर आते आम्हीन अनं ज्यानाजोडे पेला सापडना अश सर्वा मालकना दास व्हयेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","पण तो बोलना, मना हाततीन अश नको घडाले, ज्यानाजोडे हाऊ पेला सापडना तोच मना नोकर व्हई, तुम्हीन आपला बापनाजोडे सुखमा जावा. ");
INSERT INTO ahr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","मंग यहूदा जोडे जाईन बोलना, मालक कृपा करीन आपला दासले आपला कानमा एक शब्द बोलानी परवांगी दया; तुमना राग आपला दासवर नको व्हवाले; तुम्हीन तर फारोना समान शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","मना मालकनी आपला दासंसले ईचारं व्हतं की, तुमले बाप किंवा भाऊ शेतस का? ");
INSERT INTO ahr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","तवय आम्हीन मालकले बोलनुत की, आमना बाप म्हतारा शे, अनी त्याले म्हतारपणमा व्हयेल एक पोऱ्या शे; त्याना भाऊ मरी जायेल शे, त्याना मायना तेवढाच तो राहिना शे, अनं त्याना बापना बी त्यानावर प्रेम शे. ");
INSERT INTO ahr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","तुम्हीन आपला दासंसले बोलनात की, त्याले मनाकडे लई या, म्हणजे मी त्याले मना डोळासघाई दखसु. ");
INSERT INTO ahr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","पण आम्हीन आमना मालकले बोलनु व्हतुत की, त्या पोऱ्याले आपला बापले सोडीन येता येवाव नही, कारण त्यानी आपला बापले सोडा म्हणजे त्याना बाप पक्का मरी जायी. ");
INSERT INTO ahr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","तरी बी तुम्हीन आपला दासंसले बोलना व्हतात की, जोपावत तुम्हीन तुमना धाकला भाऊले तुमनासोबत लयतस नही तोपावत तुमले मन तोंड दखता येवाव नही. ");
INSERT INTO ahr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","आपला दास आमना बाप यानाकडे जाईसन आम्हीन पोहचनुत तवय मालकनी सांगेल ते सर्वा आम्हीन त्याले सांगात. ");
INSERT INTO ahr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","अनी आमना बापनी सांगं, परत जाईसन आपलाकरता धान्य ईकत लई या. ");
INSERT INTO ahr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","तवय आम्हीन आमना बापले सांगं, की, आमले मिसर देशमा परत जाता येवाव नही; आमना धाकला भाऊ आमनासोबत राही तरच आम्हीन जासुत, कारण तो जर आमनासोबत नही राहिना तर आमले त्या माणुसना तोंड बी दखता येवाव नही. ");
INSERT INTO ahr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","अनी आमना बाप तुमना दासनी आमले बोलना, तुमले माहीत शे की, मनी बायकोले दोन पोऱ्या व्हयना; ");
INSERT INTO ahr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","त्यानामाईन मी एकले गमाडं, तवय मी बोलनु की, खरच त्याले जंगली पशुसनी फाडी टाका व्हतीन; कारण आजपावत तो मना नजरमा वना नही. ");
INSERT INTO ahr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","आते तुम्हीन याले बी मनाजोडेतीन लई जाशात अनी वाटमाच एकाद संकट त्यानावर वनं तर तुम्हीन माले दु:ख करीसन मना पिकेल केससंगे अधोलोकमा जावाना कारण करशात. ");
INSERT INTO ahr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","यामुये जर तुना दास मना बाप यानाकडे मी पोहचनु अनी पोऱ्या मनासोबत नही ऱ्हाईना तर, ह्या पोऱ्यामा त्याना जीवमा जीव रावामुये. ");
INSERT INTO ahr_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","पोऱ्या नही शे हाई दखीसन तो लगेच जीव सोडी दी; अशामा आपला ह्या दासना कारण तुमना दास जो आमना बाप शे, त्याले दु:खी करीसन त्याना पिकेल केस अधोलोकमा आम्हीच उतार अश व्हई. ");
INSERT INTO ahr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","मना बापनाजोडे हाऊ पोऱ्यामुये मी जामीन व्हयनु शे; मी बोलनु की, ह्याले मी तुमनाकडे परत नही लयनु तर मी तुमना कायमनाच दोषी ऱ्हासु. ");
INSERT INTO ahr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","तर आते मी विनंती करस की, ह्या पोऱ्यानाबद्दल मालकनी आपला दासले नोकर व्हवाकरता ठेवानं अनी हाऊ पोऱ्याले त्याना भाऊसनासंगे जाऊ देवानं. ");
INSERT INTO ahr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","कारण हाऊ पोऱ्या मनासोबत नही राहिना तर मी मना बापकडे कश जावानं? मना बापले जे दु:ख व्हई ते माले दखता येवाव नही. ");
INSERT INTO ahr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","तवय योसेफना आजुबाजूले लोके उभा व्हतात त्यासनासमोर त्याले स्वताले रोकता वना नही; तो मोठा आवाजमा बोलना, की, सर्वा लोकसले बाहेर काढी द्या, मंग योसेफनी आपला भाऊसले वळख दिधी तवय त्यानाजोडे दुसरा कोणी बी नव्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","तवय तो इतलं जोरजोरमा रडाले लागना की, ते मिसरी लोकसनी आयकं, अनी फारोना घरनासना बी यानाबद्दल आयकं. ");
INSERT INTO ahr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","तवय योसेफ आपला भाऊसले बोलना, मी योसेफ शे! मना बाप अजून जिवत शे का? त्याना भाऊसना तोंडतीन काही उत्तर निंघना नही, कारण त्यानापुढे सर्वा घाबरी जायेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","योसेफ त्याना भाऊसले बोलना, मनाजोडे या; तवय त्या जोडे गयात, तवय तो त्यासले बोलना, तुमना भाऊ मी योसेफ शे, ज्याले तुम्हीन मिसर देशमा ईकी टाकं व्हतं, तो मीच शे. ");
INSERT INTO ahr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","तुम्हीन माले हाई देशमा ईकी टाकं यानाबद्दल आते काही दु:ख करानं नही; अनी संताप करी लेवानं नही, कारण तुमना जीव वाचाडवा म्हणीन देवनी माले तुमनापुढं धाडेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","हाऊ देशमा अजून दोन वरीस दुष्काळ पडाव शे; अनी आखो पाच वरीस अशच येवाव शेतस की, त्यामा नांगराणी अनं कापणी काहीच व्हवाव नही. ");
INSERT INTO ahr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","देवनी माले तुमनापुढे यानाकरता धाडं की, पृथ्वीवर तुमना वंशजना सांभाळ व्हवाले पहिजे, अनी मोठी सुटका करीसन तुमना जिव वाचाडाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","म्हणीन आते माले आठे धाडनारा तुम्हीन नहीत तर देव शे, अनी माले त्यानी फारोना बापना समान करीन त्याना सर्वा घरदारना मालक अनी सर्वा मिसर देशना शासक बनाडी ठेयेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","तुम्हीन लवकर उठीन मना बापकडे जावा अनी त्याले सांगां, तुमना पोऱ्या योसेफ अश सांगस की, देवनी माले सर्वा मिसर देशना सत्ताधीस बनाडेल शे, तर मनाकडे लवकर निंघी या उशीर करानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","तुम्हीन गोशेन प्रांतमा वस्ती करीन रावानं; तुम्हीन तुमना पोऱ्यासोऱ्या, नातवंडं, शेरडंमेंढरं, गुरंढोरं अनं तुमना सर्वा काही लिसन मनाजोडे रावानं. ");
INSERT INTO ahr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","कारण अजून पाच वरीस दुष्काळ पडनार शे, अनी तुमले लागनारं सर्वा वस्तु मी तुमले पुरावसु; अशमा तुम्हीन, तुमना घरना लोके, अनं तुमना सर्वा परीवार भुका मरावुत नही. ");
INSERT INTO ahr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","दखा, मी योसेफ तुमनासंगे प्रत्यक्ष बोली राहिनु शे, हाई तुमना डोळासले अनी मना भाऊ बन्यामिनले बी दखाय राहिना शे. ");
INSERT INTO ahr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","मिसर देशमाधलं मना सर्वा वैभव तुम्हीन दखेल शे, हाई मना बापले जाईसन सांगा, अनी मना बापले लवकर आठे लई या. ");
INSERT INTO ahr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","तो आपला भाऊ बन्यामिन याना गळामा पडीसन रडना, अनी बन्यामिन बी त्याना गळामा पडीन रडना. ");
INSERT INTO ahr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","मंग तो सर्वा भाऊसना मुका लिसन त्यासना गळामा पडीन तो रडना; तवय त्याना भाऊ त्यानासोबत बोलाले लागनात. ");
INSERT INTO ahr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","योसेफना भाऊ येल शेतस अशी बातमी फारोना राजवाडामा पोहचनी, ती ऐकीन फारोले अनं त्याना चाकरंसले आनंद व्हयना. ");
INSERT INTO ahr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","फारो योसेफले बोलना, तू तुना भाऊसले सांग, एक काम करा की, आपला जनावरं लादीसन निंघा अनं कनान देशमा जावा. ");
INSERT INTO ahr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","अनी आपला बाप अनं आपला पोऱ्यासोऱ्या लिसन मनाजोडे या, मिसर देशनी जी सर्वासमा चांगली जागा ती तुमले दिसु अनी तुमले हाई देशमाधलं उत्तम पदार्थ खावाले भेटतीन. ");
INSERT INTO ahr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","आते तुले सांगस की, त्यासले सांग, एवढं काम करा, आपला बायका पोऱ्यासकरता मिसर देशमाईन गाड्या लई जावा, अनी आपला बापले बी लई या. ");
INSERT INTO ahr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","आपला मालमत्ता बद्ल चिंता करानं नही, कारण मिसर देशनी जी बी चांगली जमीन शे, ती तुमनी शे. ");
INSERT INTO ahr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","याकोबना पोऱ्यासनी तसंच करं; अनी फारोना हुकूमप्रमाणे योसेफनी त्यासले गाड्या अनं प्रवासकरता भोजन वस्तु दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","त्यानी प्रत्येकले एक एक नवा कपडा दिधा अनी बन्यामिनले तीनशे रूपये अनी पाच नवा कपडा दिधात. ");
INSERT INTO ahr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","तसंच त्यानी आपला बापकरता मिसर देशमाधलं उत्तम पदार्थ लादेल दहा गाढवं अनी धान्य, भाकरी अनं प्रवासकरता बाकीना अन्नधान्य लादेल दहा गाढवी धाडात. ");
INSERT INTO ahr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","अश प्रकारं त्यानी आपला भाऊसले निरोप देवावर त्या प्रवासमा निंघनात; त्या जावाले लागनात तवय तो त्यासले बोलना, प्रवासमा भांडण करानं नही. ");
INSERT INTO ahr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","त्या मिसर देशमाईन निंघीसन कनान देशमा आपला बाप याकोब यानाजोडे पोहचनात. ");
INSERT INTO ahr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","योसेफ अजून जिवत शे, सर्वा मिसर देशमा त्यानी सत्ता शे अश त्यासनी त्याले सांगं, तवय तो गप्पच राहिना, कारण त्यासनी सांगेल गोष्टवर त्यानं ईश्वास बशी नही राहिंता. ");
INSERT INTO ahr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","मंग योसेफनी त्यासले सांगेल व्हतं ते सर्वा त्यासनी त्याले सांगात; अनी त्यासना बाप याकोब याले आणाकरता योसेफनी धाडेल गाड्या दखात तवय त्याना जीवमा जीव वना. ");
INSERT INTO ahr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","अनी याकोब बोलना, पुरं व्हयना, मना पोऱ्या योसेफ अजून बी जिवत शे, मी मराना पहिले जाईसन त्याले दखसु. ");
INSERT INTO ahr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","तवय याकोब सर्वाकाही लिसन निंघना, अनी बैरशेबामा ईसन त्यानी आपला बाप इसहाक याना देवले बलिदान करात. ");
INSERT INTO ahr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","तवय रातले दृष्टांतमा देव याकोबनासंगे बोलना, “याकोब हे याकोब;” अनी तो बोलना, मी आठे शे? ");
INSERT INTO ahr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","तो बोलना, “मी देव शे, तुना बापना देव शे;” तू मिसर देशमा जावाले घाबरू नको; तठे तुना मी एक मोठा राष्ट्र बनाडसु; ");
INSERT INTO ahr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","मी तुनासोबत मिसर देशमा ईसु, तठेन मी तुले पक्का परत आणसु, अनी योसेफ आपला हाततीन तुना डोळा झाकी. ");
INSERT INTO ahr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","मंग याकोब बैरशेबातीन निंघना, अनी त्याले लेवाकरता फारोनी धाडेल गाडीसमा याकोबना पोऱ्यासनी आपला बाप याकोब अनी आपला बायका पोऱ्यासले बसाडीसन गयात. ");
INSERT INTO ahr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","त्यासनी आपली गुरंढोरं अनी कनान देशमा कमाडेल मालमत्ता लिसन मिसर देशमा वनात; याप्रमाणे याकोब अनं त्यानी बठी संतती मिसर देशमा वनी. ");
INSERT INTO ahr_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","आपलासंगे आपला पोऱ्या अनं नातवंड, पोरी अनं नाती आपली सर्वी संतती मिसर देशमा लयी वना. ");
INSERT INTO ahr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","इस्त्राएलनी संतती म्हणजे अर्थात याकोब अनं त्याना पोऱ्यासोऱ्या मिसरमा गयात त्यासनं ह्या नावे शेतस: याकोबना पहिला पोऱ्या रऊबेन. ");
INSERT INTO ahr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रऊबेनना पोऱ्या हनोक, पल्लू, हेस्रोन अनं कार्मी. ");
INSERT INTO ahr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमोनना पोऱ्या: यमुवेल, यामीन, ओहाद, याकीन, सोहार अनी कनानी बाईपाईन व्हयेल पोऱ्या शौल. ");
INSERT INTO ahr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवीना पोऱ्या: गेर्षोन, कहाथ, अनं मरारी. ");
INSERT INTO ahr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदाना पोऱ्या: एर अनं ओनान, शेला, पेरेस अनं जेरह; यासनामाईन एर अनं ओनान ह्या कनान देशमा मरण पावना व्हतात अनी पेरेसना पोऱ्या हेस्रोन अनं हामूल ह्या व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साखारना पोऱ्या: तोला, पुवा, योब अनं शिम्रोन. ");
INSERT INTO ahr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबुलूनना पोऱ्या: सेरेद, एलोन, अनं याहलेल. ");
INSERT INTO ahr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ह्या सर्वा लेआना पोऱ्या अनं तिनी पोर दीना हाई तिले याकोबपाईन पदन-अराममा व्हयनी; त्याना पोऱ्या अनं पोरी मिळीसन तेहतीस जण व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","गादानं पोऱ्या: सिफयोन, हग्गी, शूनी, एसबोन, एरी रोदी अनं अरेली. ");
INSERT INTO ahr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेरना पोऱ्या: इम्रा, इश्वा, इश्वी अनं बरीया; अनी त्यासनी बहीण सेराह, बरीयाना पोऱ्या हेबेर अनं मालकीएल. ");
INSERT INTO ahr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","लाबाननी आपली पोर लेआ हिले देल जिल्पाना ह्या पोऱ्या शेतस, तिले ह्या याकोबपाईन सोळा जण व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","याकोबनी बायको राहेल हिना पोऱ्या: योसेफ अनं बन्यामिन. ");
INSERT INTO ahr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","मिसर देशना ओनना याजक पोटीफरा यानी पोर आसनथ हिनापाईन योसेफले मनश्शे अनं एफ्राईम ह्या व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बन्यामिनना पोऱ्या: बेला, बेकेर, आशबेल, गेरा, नामान, एही, रोष, मुप्पीम, हुप्पीम अनी आर्द. ");
INSERT INTO ahr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ह्या पोऱ्या याकोबपाईन राहेलले व्हयनात; त्या सर्वा चौदा जण व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","दानना पोऱ्या: हुशीम. ");
INSERT INTO ahr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नफतालीना पोऱ्या: यासहेल, गूनी, येसेर अनी शिल्लेम. ");
INSERT INTO ahr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","लाबाननी आपली पोर राहेल हिले देयल दासी बिल्हाना ह्या पोऱ्या शेतस, तिले ह्या सात जण याकोबपाईन व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","याकोबना वंशजमाधला ज्या माणसे मिसर देशमा गयात ती याकोबना पोऱ्यासना बायका सोडीसन सहासष्ट जण व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","योसेफले मिसर देशमा व्हयेल दोन पोऱ्या, ह्या मिळीसन याकोबना घरनासमाईन मिसर देशमा जोडेजोडे सत्तर जण व्हतात. ");
INSERT INTO ahr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","योसेफनी गोशेन प्रांतनी वाट दखाडाले पाहिजे म्हणीन याकोबनी यहूदाले आपलापाईन त्यानाकडे धाडं; अशप्रकारं त्या गोशोन प्रांतमा वनात. ");
INSERT INTO ahr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","तवय योसेफ आपला रथ लिसन आपला बाप याकोब याले भेटाले गोशेन प्रांतमा गया; त्याले भेटीसन त्याना गळामा त्यानी मिठी मारी अनी त्याना गळामा गळा घालीसन तो बराच येळ रडना. ");
INSERT INTO ahr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","तवय याकोब योसेफले बोलना, आते ते माले खुशाल मरण येवो, कारण आते मी तुना तोंड दखेल शे, तू अजून बी जिवत शे. ");
INSERT INTO ahr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","योसेफ आपला भाऊसले अनी आपला बापना घरनासले बोलना, मी जाईसन फारोले माहीती देस की, कनान देशमाधला मना भाऊ अनं मना बापना घरना माणसे मनजोडे येल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ह्या सर्वा मेंढरं पाळनारा, गुरंढोरं पाळनारा शेतस म्हणीन त्या आपला सर्वा शेरडंमेंढरं, गुरंढोरं अनं आपला सर्वा काही लिसन येयल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","फारो तुमले बलाईसन ईचारी की, तुमना धंदा काय शे? ");
INSERT INTO ahr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","तवय तुम्हीन सांगानं दाखलपनपाईन आतेपावत आम्हीन आपला दास गुरंढोरं पाळी रायनु शेतस; आमना अनं आमना बापना बी हाऊच धंदा शे; अशमा तुमले गोशेन प्रांतमा रावाले भेटी; कारण जितला बी मेंढपाळ शेतस तेवढासले दखीन मिसरी लोकसले किळस वाटी. ");
INSERT INTO ahr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","मंग योसेफ फारोकडे जाईसन त्याले बोलना, मना बाप अनं मना भाऊ या आपला शेरडंमेंढरं, गुरंढोरं अनी जे काही त्यासना शे ते सर्वा लिसन कनान देशमाईन निंघी येल शेतस; सध्या त्या गोशेन प्रांतमा शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","त्यानी आपला भाऊसपाईन पाच जणसले लिसन फारोना पुढं उभं करं. ");
INSERT INTO ahr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फारोनी योसेफना भाऊसले ईचारं, तुमना धंदा काय शे? त्या फारोले बोलनात, आपला दाससना अनं त्यासना बापदादाना धंदा मेंढरं पाळानं शे. ");
INSERT INTO ahr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","त्या फारोले आखो बोलनात, आम्हीन हाई देशमा काही दिन रावाले येल शेतस; कनान देशमा भयानक दुष्काळ पडामुये आपला दाससंना शेरडंमेंढरंसले चारा नही शे, म्हणीन कृपाकरीसन आपला दाससले गोशेन प्रांतमा राहु दया. ");
INSERT INTO ahr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","फारो योसेफले बोलना, तुना बाप अनं तुना भाऊ तुनाकडे येल शेतस; ");
INSERT INTO ahr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","मिसर देश तुनापुढं मोकळा पडना शे; हाऊ देशना उत्तम ठिकाणमा तुना बाप अनं तुना भाऊसले वस्ती करू दे; त्यासले गोशेन प्रांतमा राहू दे; त्यासनामाईन जो कोणी हुशार माणुस तुले माहीत व्हई त्यासले मना गुराखीसना नायक कर. ");
INSERT INTO ahr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","योसेफनी आपला बाप याकोब ह्याले फारोना पुढं आणीसन हजर करं, तवय याकोबनी फारोले आशिर्वाद दिधं. ");
INSERT INTO ahr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","फारोनी याकोबले ईचारं, तुना वय कितलं वरिसना शे? ");
INSERT INTO ahr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकोब फारोले बोलना, मनी जीवनयात्रा एकशेतीस वरीसनी व्हयनी शे; मना आयुष्यना दिन थोडसं चांगला थोडसं वाईट जायेल शेतस, अजून पावत मी ते तेवढा बी दिन नही दखनु जितला मना बापदादानी प्रवासी व्हईसन घालात. ");
INSERT INTO ahr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","याकोब फारोले आशिर्वाद दिसन त्यानापुढेन निंघी गया. ");
INSERT INTO ahr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","नंतर योसेफनी आपला बाप अनं भाऊ यासना रावानी व्यवस्था करी; त्यानी फारोना आज्ञाप्रमाणे मिसर देशना उत्तम भागमा म्हणजे रामसेस प्रांतमा त्यासले वतन करी दिधा. ");
INSERT INTO ahr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","योसेफनी आपला बाप, आपला भाऊ अनी आपला बापना घरना माणसे यासले त्यासना पोऱ्यासोऱ्यासना संख्याप्रमाणे अन्नधान्य दिसन त्यासनं पालन पोषण करं. ");
INSERT INTO ahr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","त्या येळले सर्वा देशमा अन्न राहिना नही, कारण दुष्काळ इतला भयानक व्हता की, त्यानामुये मिसर देश अनं कनान देश हैराण व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","मिसर देशमाधला अनं कनान देशमाधला लोकसनी ईकत लियेल धान्यसना मोबदलामा जेवढा पैसा भेटना तेवढा पैसा योसेफनी गोया करा अनं तो फारोना घरमा धाडी दिधा. ");
INSERT INTO ahr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","मिसर देशमा अनं कनान देशमा काही पैसा बचना नही, तवय सर्वा मिसरी लोके योसेफकडे ईसन बोलनात, आमले अन्न द्या तुमनादेखत आम्हीन काबंर उपाशी मरानं? आमना सर्वा पैसा संपी गया शे. ");
INSERT INTO ahr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","योसेफ बोलना, तुमना पैसा संपना तर तुमना जनावरे द्या म्हणजे त्यासना मोबदलामा तुमले अन्न दिसु. ");
INSERT INTO ahr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","तवय त्यासनी त्यासना जनावरे योसेफजोडे आणात; त्यासनं घोडे, शेरडं मेंढरं, अनं गाढवं लिसन त्यासना मोबदलामा तो त्यासले अन्न पुरावू लागना; त्यासना सर्वा जनावरे लिसन तो त्यासनं पोषण कराले लागना. ");
INSERT INTO ahr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ते वरीस संपना तवय पुढला वरीसले त्या त्यानाकडे ईसन बोलनात, आमना सर्वा पैसा संपना शे, हाई आम्हीन मालकपाईन लपाडी नही राहिनु; आमना गुरंढोरंसना कळप मालकना व्हई जायेल शे; आते माकलनासमोर सादर कराकरता आमना शरीर अनं आमना जमीनी यासशिवाय आमनाजोडे काहीच राहिनं नही शे. ");
INSERT INTO ahr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","तुमनादेखत आम्हीन काबरं मरानं अनी आमना अनं आमन्या जमीनीसना नाश काबरं व्हवाले पाहिजे? आमन्या जमीनी ईकत लिसन आमले अन्न द्या, आम्हीन अनं आमन्या जमीनी याजवर फारोनी मालकी व्हवो; आमले बियानं द्या म्हणजे आम्हीन जगसुत, मरावुत नहीत अनी आमन्या जमिनी उजाड पडावुत नहीत. ");
INSERT INTO ahr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","अश प्रकारं योसेफनी मिसर देशमाधली सर्वी जमीन फारोना नावतीन ईकत लिधी, दुष्काळ कडक पडामुये प्रत्येक मिसरी माणुसनी आपली शेतीजमीन ईकी, सर्वी भुमी फारोनी व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","त्यानी देशना ह्या टोकपाईन त्या टोकपावतना सर्वा लोकसले दास करात. ");
INSERT INTO ahr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","पण याजकसनी जमीन त्यानी लिधी नही, कारण याजकसले फारोकडीन नेमणुक व्हती अनी फारोनी त्यासले दियेल नेमणुकमा त्या निर्वाह करेत, म्हणीन त्यासनी आपली जमीन ईकी नही. ");
INSERT INTO ahr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","मंग योसेफ लोकसले बोलना, आज मी तुमनी जमीनसंगे तुमले फारोना नावतीन ईकत लियेल शे; ह्या बियानं ल्या अनं जमीनी पेरणी करा. ");
INSERT INTO ahr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","तुम्हीन हंगामना येळले उत्पन्नना पाचवा हिस्सा फारोले देवानं; बाकीना चार हिस्सा तुमना मालकीन ऱ्हातीन; त्या शेतना बियानकरता अनं तुमले, तुमना घरनासले अनी तुमना पोऱ्यासोऱ्यासले खावाकरता ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","त्या बोलनात, तुम्हीन आमना प्राण वाचडात, मालकनी आमनावर कृपादृष्टी राहो, आम्हीन फारोना दास बनी ऱ्हासुत. ");
INSERT INTO ahr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","फारोले उत्पन्नना पाचवा हिस्सा देवानं हाऊ कायदा योसेफनी मिसर देशना जमीनीसले लायी दिधा तो आजपावत चाली राहिना शे; पण याजकसना जमीनी फारोन्या व्हयनात नहीत. ");
INSERT INTO ahr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इस्त्राएल लोक मिसर देशना गोशेन प्रांतमा वस्ती करीन राहिनात; तठे त्यासनी वतन करात; त्या फलद्रूप व्हईसन बहुगुणित व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","याकोब मिसर देशमा सत्तर वरीस जगना; याप्रमाणे याकोबना सर्वा वय एकशेसत्तेचाळीस वरीसना व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","याकोबना अंतकाळ जोडे वना तवय त्यानी आपला पोऱ्या योसेफ याले जोडे बलाईसन सांगं, तुनी मनावर कृपादृष्टी व्हई तर मनासंगे तू ममतामा अनं सत्यमा वागीसन माले मिसर देशमा मूठमाती नही देवाव अश शपथ मनी मांडीवर हात ठेईसन खाय. ");
INSERT INTO ahr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","मी मना बापदादासना संगे झोपी जासु तवय माले मिसर देशमाईन बाहेर लई जाय अनी मना बापदादासना कबरस्तानमा ठेव, तो बोलना, “तुमना सांगाप्रमाणे मी ते करसु.” ");
INSERT INTO ahr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","तो बोलना, \"मनाजोडे शपथ खाय; तवय त्यानी शपथ खादी; अनी याकोबनी आपला पलंगना उशीकडे वाकीसन नमन करं.\" ");
INSERT INTO ahr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","या गोष्टी व्हवावर कोणी योसेफले सांगं, की, \"दख तुना बाप आजारी शे, \"तवय तो आपला दोन्ही पोऱ्या मनश्शे अनं एफ्राईम यासले संगे लिसन त्यानाकडे गया. ");
INSERT INTO ahr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","आपला पोऱ्या योसेफ आपलाकडे वना शे, अश कोणीतरी याकोबले माहिती सांगी, तवय याकोब स्वतःले संभाळीसन पलंगवर बसना. ");
INSERT INTO ahr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","याकोब योसेफले बोलना, \"सर्वसमर्थ देवनी कनान देशना लूज शहर आठे माले दर्शन दिसन आशिर्वाद दिधा.\" ");
INSERT INTO ahr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","तो माले बोलना, \"दख, मी तुले फलद्रूप करीसन बहुगुणित करसु अनी तुनापाईन राष्ट्रसमुदाय उत्पन्न करसु अनी तुनामांगे तुना संततीले हाऊ देश कायमनाच वतन करी दिसु.\" ");
INSERT INTO ahr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","मी मिसरमा तुनाकडे येवाना पहिले तुले ज्या दोन पोऱ्या मिसरमा व्हयनात त्या मनाच शेतस, जश रऊबेन अनं शिमोन तसच एफ्राईम अनं मनश्शे ह्या बी मनाच शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","त्यासनामांगे ज्या पोऱ्या तुले व्हतीन त्या तुना ऱ्हाईत, त्यासना वतन त्यासना भाऊसना नावतीन चाली. ");
INSERT INTO ahr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","मी पदन आठेन ई ऱ्हायंतु तवय वाटमाच एफ्राथ गावले पोहचाना अगोदर थोडंच दूर कनान देशमा राहेल मरी गयी, अनी मी तिले तठेच एफ्राथना वाटले म्हणजे बेथलेहेममा मुठमाती दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","जवय याकोबनी योसेफना दोन पोऱ्यासले दखं, तवय त्यानी ईचारं, \"या कोण शेतस?\" ");
INSERT INTO ahr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","मंग योसेफ आपला बापले बोलना, \"ह्या मना पोऱ्या शेतस, देवनी माले ह्या मिसर देशमा देयल शेतस, तवय तो बोलना, \"त्यासले मनाजोडे आण म्हणजे मी त्यासले आशिर्वाद दिसु.\" ");
INSERT INTO ahr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","याकोबनी नजर वयना मानतीन मंद व्हई जायेल व्हती, म्हणीन त्याले बराबर दखाई नही राहिंतं, योसेफनी त्यासले त्यानाजोडे लयं, तवय त्यानी त्यासना मुका लिसन त्यासले मिठ्ठी मारी. ");
INSERT INTO ahr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","याकोब योसेफले बोलना, \"माले आशा नव्हती की, मी तुनं तोंड दखसु; पण दख, देवनी माले तुनी संतती बी दखाडी देयल शे.\" ");
INSERT INTO ahr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","मंग योसेफनी त्यासले त्याना मांडीवरीन बाजुले करं अनी जमिनवर झुकीसन नमन करात. ");
INSERT INTO ahr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","मंग त्या दोन्हीसले एफ्राईमले आपला उजवी बाजुले म्हणजे याकोबनी डावी बाजुले अनी मनश्शेले आपला डावी बाजुले म्हणजे याकोबनी उजवीकडे अश धरीन त्यानाजोडे आणं. ");
INSERT INTO ahr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","याकोबनी आपला उजवा हात पुढं करीन एफ्राईमना म्हणजे धाकला पोऱ्याना डोकावर ठेवा; अनी आपला डावा हात मनश्शेना डोकावर ठेवा; त्यानी आपला हात उजवाडावा करात; मनश्शे तर मोठा पोऱ्या व्हता. ");
INSERT INTO ahr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","त्यानी योसेफले आशिर्वाद दिसन सांगं, की, \"ज्या देवनासंगे मना बाप अब्राहाम अनं इसहाक चालनात, मना जन्मपाईन ज्या देवनी आजपावत मना सांभाळ करेल शे. ");
INSERT INTO ahr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","जो दूतनी माले सर्व वाईटपाईन सांभाळं तो या पोऱ्यासले आशिर्वाद देवो, अनी ह्या मना अनी तुना पुर्वज अब्राहाम अनं इसहाक यासनं नाव ह्या चालवोत, अनी पृथ्विना मध्यभागमा यासनी मोठी वाढ व्हवो. ");
INSERT INTO ahr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","आपला बापनी एफ्राईमना डोकावर उजवा हात ठेयेल शे हाई योसेफनी दखं, तवय त्याले वाईट वाटनं, अनी त्यानी एफ्राईमना डोकावरना बापना हात काढीन मनश्शेना डोकावर ठेवाकरता त्यानी तो धरा. ");
INSERT INTO ahr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","योसेफ आपला बापले बोलना, \"बाबा, अस नका करा, मोठा हाऊ शे, याना डोकावर आपला हात ठेवा.\" ");
INSERT INTO ahr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","त्यानं बोलनं, नाकारीसन त्याना बाप त्याले बोलना, \"हाई माले माहित शे, त्यानं बी एक राष्ट्र व्हई अनी तो बी महान व्हई, पण त्याना धाकला भाऊ त्यानापेक्षा मोठा व्हई अनी त्याना वंशजमाईन राष्ट्रसना समुदाय उत्पन्न व्हई.\" ");
INSERT INTO ahr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","त्याच दिन त्यानी त्यासले हाई सांगीसन आशिर्वाद दिधा, याकोब लोक तुना नाव लिसन हाई आशिर्वाद देतीन, एफ्राईम अनं मनश्शे यासनासारखा देव तुना करो, अश प्रकारमा त्यानी एफ्राईमले मनश्शेपेक्षा श्रेष्ठ करा. ");
INSERT INTO ahr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","याकोब योसेफले बोलना, \"दख, मी तर आते मरसु, पण देव तुनासंगे राही अनी तुमले तुमना पुर्वजसना देशले परत लई जाई. ");
INSERT INTO ahr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","मी तुले तुना भाऊसनापेक्षा जमीनना एक वाटा जास्त देस, तो मी मना तलवारना अनं धनुष्यना जोरवर अमोरी लोकसपाईन लेयल शे. ");
INSERT INTO ahr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","मंग याकोबनी आपला पोऱ्यासले बलाईसन सांगं, \"तुम्हीन सर्वजन एकत्र जमा म्हणजे पुढला काळले काय व्हई ते मी तुमले सांगस, ");
INSERT INTO ahr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","\"हे याकोबना पोऱ्यासवंन, एकत्र ईसन ऐका; अनी आपला बाप याकोब याना गोष्टी ध्यान दिसन ऐका. ");
INSERT INTO ahr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","हे रऊबेन, तू मना ज्येष्ठ, मना बळ, मना पौरूषानं पहिलं फळ शे; प्रतिष्ठानं अनी सामर्थ्यनं उत्तम भाग तुच शे. ");
INSERT INTO ahr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","तू पाणीनागत चंचल शे, त्यामुये तुले श्रेष्ठत्व भेटावू नही; कारण तू आपला बापना खाटवर चढनास; तू ती भ्रष्ट करेल शे, तो ते मनी खाटवर चढना. ");
INSERT INTO ahr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","शिमोन अनं लेवी ह्या भाऊ भाऊ शेतस; त्यासन्या तरवारी अत्याचारना हत्यारं शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","मना जीव, त्यासना मसलतीमा जाऊ नको, मनी महिमा त्यासनी मंडळीमा नको भेटाले, कारण त्यासनी रागना भरमा मनुष्यवध करेल शे; त्यासनी उन्मत पणतीन बैलसना पायन्या शिरा तोडात. ");
INSERT INTO ahr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","त्यासना रागले धिक्कार राव्हो, कारण तो भयानक शे; त्यासना क्रोधले धिक्कार राव्हो, कारण तो निष्ठुर शे; मी त्यासले याकोबमा पांगापांग अनी याकोबमा त्यासले येगयेगळा करी दिसु. ");
INSERT INTO ahr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","हे यहूदा तुना भाऊ तुना धन्यवाद करतीन; तुना हात तुना शत्रुसना मानगुटी धरी; तुना बापना पोऱ्या तुनापुढं नमतीन. ");
INSERT INTO ahr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदा सिंहासना बच्चा शे; मना पोऱ्या, तू शिकार करीन डोंगरमा जायेल शे; तो सिंहासनासारखा सिंहणीसारखा दबीन बसेल शे, त्याले कोण छेडी? ");
INSERT INTO ahr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","यहूदाकडनं राजदंड ज्यानं शे, तो येवापावत ते त्यानाकडीन जावाव नही, राजदंड त्याना पायासमाईन ढळावु नही; राष्ट्रना लोके त्यानी आज्ञा मानतीन. ");
INSERT INTO ahr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","तो आपला जवान गधडाले द्राक्षरसनावेलले, अनी आपला गधडीनना शिंगरूले उत्तम द्राक्षरसनावेलले बांधी ठेई; तो आपला कपडा द्राक्षरसमा, अनी आपला पोषाख द्राक्षरसमा धुई टाकी. ");
INSERT INTO ahr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","त्याना डोळा द्राक्षरसघाई चमकतीन; अनी त्याना दात दुधघाई धवळा व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","जबुलून समुद्रकिनारले वस्ती करी; तो जहाजसनं बंदरच व्हई जाई; त्यानी सरहद्द सीदोनपावत जाई. ");
INSERT INTO ahr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","इस्साखार ताकदवान गाढव शे; तो मेंढवाडासमा झोपी ऱ्हास; ");
INSERT INTO ahr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","त्यानी दखं, की, विश्रामगृह चांगलं शे, अनी हाऊ देश मनोहर शे अश दखीन, भार वाहा करता त्यानी आपला खांदाले झुकाड; तो बिगार काम करनारा दास बनी गया. ");
INSERT INTO ahr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","दान याकोबना एक वंश राहिसन आपला लोकसना तो न्याय करी. ");
INSERT INTO ahr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान हाऊ मार्गवरना साप, वाटवरना नाग व्हई, हाऊ घोडासना टासले दंश करस तवय त्यानावरना स्वार उलटीन मांगे पडतस. ");
INSERT INTO ahr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","हे परमेश्वर, मी तुनाकडीन उध्दार व्हवानी प्रतिक्षा करी ऱ्हायनु शे. ");
INSERT INTO ahr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","गाद यानावर हल्लाखोरसनी टोळी हल्ला करी; तरी पण तो मांगे फिरीसन त्यासना मांगे ज्या शेतस त्यासवर हामला करी. ");
INSERT INTO ahr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","आशेरानं अन्न पोष्टिक व्हई तो राजाले योग्य अस भोजन पुराई. ");
INSERT INTO ahr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","नफताली हाई मोकळी सुटेल एक हरीण शे, तो चांगलं भाषण करनारा बनी. ");
INSERT INTO ahr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","योसेफ हाऊ फळझाडसनी शाखा शे, निर्झराजोडे लायेल फळझाडासनी शाखा शे, त्याना डहाळ्या भितवर पसरेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","धनुष्य चालाडनारासनी त्याले भलतं त्रास दिधा, त्याले बाण मारात, त्याना मांगे पडी गयात; ");
INSERT INTO ahr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","पण त्यानं धनुष्य मजबूत राहिना; याकोबना समर्थ देव, मेंढपाळ, याकोबना खडक याना नावतीन त्याना भुज स्फुरण पावना. ");
INSERT INTO ahr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","तुना सहाय्य करनारा तुना बापना देव, तुले वरदान देनारा सर्वसमर्थ देव यानाकडीन हाई व्हई, वरतीन आकाशनी अनं खालतीन जलाशयना वरदाने तो तुले दि, आंगवर पिनारासना अनं पोटना फळसना वरदाने तो तुले दि. ");
INSERT INTO ahr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तुना बापना वरदाने प्राचीन पर्वतसना वरदानसपेक्षा श्रेष्ठ शेतस; ती सनातन डोंगरसपाईन प्राप्त व्हनारा इष्ट वस्तूसपेक्षा श्रेष्ठ शेतस; हाई आशिर्वाद योसेफना मस्तकवर राही, आपला भाऊबंधमा जो प्रमुख त्याना शिरी येवो. ");
INSERT INTO ahr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","बन्यामिन हाऊ फाडी टाकनारा लांडगा शे; सकायमा तो शिकार खाई टाकी, संध्याकाळना लुटीना वाटा करी. ");
INSERT INTO ahr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ह्या सर्व याकोबना बारा वंश शेतस, त्यासना बाप त्यासले आशिर्वाद देतांना ह्या वचने बोलना, प्रत्येकले त्यासनी योग्यता प्रमाणे त्यानी आशिर्वाद दिधा. ");
INSERT INTO ahr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","मंग त्यानी त्यासले आज्ञा दिधी की, मी आपला पुर्वजसले जाईन भेटसु तवय माले एफ्रोन हित्ती याना शेतमाधली गुफामा मना बापनाजोडे माले मूठमाती देवानं. ");
INSERT INTO ahr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","कनान देशमाधली मम्रेसमोरनी मकपेला नावनी वावरमाधली गुफा जी अब्राहामना वावरनासंगे एफ्रोन हित्ती यानाकडीन आपला मालकीन कबरस्तान व्हवाले पाहिजे म्हणीन ईकत लियेल व्हती ती हाई शे. ");
INSERT INTO ahr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","तठेच अब्राहाम अनं त्यानी बाई सारा यासले मूठमाती देयल व्हतं; इसहाक अनं त्यानी बाई रिबका यासले बी तठेच मूठमाती देवामा येल व्हतं तठेच मी लेआले बी मूठमाती दिधी. ");
INSERT INTO ahr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ते वावर अनं त्यामाधली गुफा हाई हेथीकडीन ईकत लेयल शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","आपला पोऱ्यासले आज्ञा देवावर याकोबनी पलंगवर आपला पाय लिधात अनं प्राण सोडा अनी आपला पुर्वजसले जाईन भेटना. ");
INSERT INTO ahr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","मंग योसेफ आपला बापना तोंडले तोंड लाईन रडना अनी त्यानी त्याना मुका लिधात. ");
INSERT INTO ahr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","योसेफनी आपला सेवकसले म्हणजे वैद्यसले आपला बापना प्रेतले मसाला लावाले आज्ञा करी; त्याप्रमाणे त्या वैद्यसनी याकोबना प्रेतले मसाला भरा. ");
INSERT INTO ahr_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","हाई कार्यले चाळीस दिन लागनात; प्रेतले मसाला भराले इतला दिन लागेत; अनी मिसरी लोकसनी सत्तर दिन त्यानाकरता शोक करात. ");
INSERT INTO ahr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","शोकना दिन संपावर योसेफ फारोना घरना लोकसले बोलना, जर तुमनी मनावर कृपादृष्टी व्हई तर फारोले एवढा संदेश सांगा की, ");
INSERT INTO ahr_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","मना बापनी माले हाई सांगीसन शपथ घालेल शे की, दख, आते मी मरसु; तर कनान देशमा जी कबर मी मनाकरता खोदेल शे तिमा माले लई जाईसन मूठमाती दे, म्हणीसन माले तिकडे जाईसन मना बापले मूठमाती देवाकरता जाऊ द्यावा मंग मी परत येसु. ");
INSERT INTO ahr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","तवय फारो बोलना, जा, तुमना बापनी देयल शपथ प्रमाणे त्याले मूठमाती दे. ");
INSERT INTO ahr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","मंग योसेफ आपला बापले मूठमाती देवाले निंघी गया, अनी फारोना सर्व सेवक, त्याना घरना वडीलजन अनं मिसर देशना सर्वा वडीलजन. ");
INSERT INTO ahr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","योसेफना घरना सर्वा लोके, त्याना भाऊ अनी त्याना बापना घरना लोके त्यानासोबत गयात; आपला पोऱ्यासोऱ्या, शेरडंमेंढरं, गुरंढोरं, हाई मात्र त्यासनी गोशेन प्रांतमाच मांगे ठेवात. ");
INSERT INTO ahr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","त्यानासोबत रथ, अनं घोडास्वार बी गयात; अश त्यानासंगे मोठा समुदाय निंघना. ");
INSERT INTO ahr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","यार्देनपलीकडे अटादना खळानाजोडे त्या वनात तवय त्यासनी तठे मोठा शोक करात; योसेफनी तठे आपला बाप करता सात दिन शोक करात. ");
INSERT INTO ahr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","जवय कनानी देशना रहिवासी हाई शोक दखा, तवय त्या बोलनात, हाऊ मिसरी लोकसना भयानक शोक शे; त्यावरीन त्या ठिकाणना नाव अबेलमिस्त्राइम (मिसरना शोक) अश पडनं; ते यार्देनना पलीकडे शे. ");
INSERT INTO ahr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","याकोबनी आपला पोऱ्यासले जश आज्ञा करी व्हती त्यानाप्रमाणे त्यासनी करात. ");
INSERT INTO ahr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","त्यासनी त्याले कनान देशमा लिसन मम्रेनासमोर मकपेला नावना शेतना गुफामा त्याले मूठमाती दिधी; अब्राहामनी एफ्रोन हित्तीकडीन आपला मालकीना कब्रस्तान व्हवाले पाहिजे म्हणीन शेतनासोबत ईकत लेयल व्हती, तीच हाई गुफा शे. ");
INSERT INTO ahr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","योसेफनी आपला बापले मूठमाती देवावर तो, त्याना भाऊ अनं त्याना बापना मूठमाती देवाकरता त्यानासोबत जायेल व्हतात त्या सर्वा मिसर देशमा परत गयात ");
INSERT INTO ahr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","आपला बाप मरण पावना हाई मनमा आनीसन योसेफना भाऊ म्हणाले लागनात, आते योसेफ कदाचित आमनासंगे वैर करी अनं आपण त्याना जे वाईट करा त्याना पुरा बदला ली. ");
INSERT INTO ahr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","त्यासनी योसेफले निरोप धाडीन सांगा की, आपला बापनी मराना पहिले आमले आज्ञा करी ती हाई, ");
INSERT INTO ahr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","तुम्हीन योसेफले सांगानं, तुना भाऊसनी तुना वाईट करा हाऊ त्यासना अपराध अनं पाप यासनी त्यासले क्षमा कर; आते आपला बापना देवना ज्या दास शेतस त्या आमना अपराधना क्षमा करा, अश आम्हीन ईनंती करतस, हाई त्यासनं भाषण ऐकीन योसेफले रडू वनं. ");
INSERT INTO ahr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","तवय त्याना भाऊ स्वत: त्यानाकडे जाईन त्याना पाय पडीन बोलनात, दखा, आम्हीन तुमना दास शेतस. ");
INSERT INTO ahr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","योसेफ त्याना भाऊसले बोलना, भिवानं नही, मी का देवना ठिकानमा शे का? ");
INSERT INTO ahr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","तुम्हीन मना वाईट करा, पण आज दखतस त्यानाप्रमाणे बराच लोकसना जिव वाचाले पाहिजे म्हणीन देवनी ते चांगलाकरता योजेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","तर आते भिवानं नही; मी तुमना अनं तुमना पोऱ्यासोऱ्यासना पालण पोषण करसु. अशप्रकारं त्यानी त्यासनासंगे ममतामा बोलींन त्यासना समाधान करा. ");
INSERT INTO ahr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","योसेफ अनी त्याना बापना घरनासहीत मिसर देशमा राहिनात, तो एकशेदहा वरीस जगना. ");
INSERT INTO ahr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","योसेफनी एफ्राईमना तिसरा पिढीना पोऱ्यासले दखात, तसंच मनश्शेना पोऱ्या माखीर याना पोऱ्यासले त्यानी आपला मांडीवर लिधात. ");
INSERT INTO ahr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","मंग योसेफ आपला भाऊसले बोलना, मी आते मरण पावसु; पण देव खरच तुमनी भेट करी अनं जो देश अब्राहाम, इसहाक अनं याकोब यासले त्यानी शपथपुर्वक देल शे, त्यामा तुमले हाई देशमाईन लई जाई. ");
INSERT INTO ahr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","मंग योसेफनी याकोब वंशजसले शपथ घालीन सांगं, देव खरंच तुमनी भेट करी तवय तुम्हीन मना अस्थी आठेन लई जावानं. ");
INSERT INTO ahr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","योसेफ एकशेदहा वरीसना व्हईन मरण पावना; त्यासनी त्याना प्रेतमा मसाला भरीन ते पेटीमा घालीन मिसर देशमा ठेवं.");
INSERT INTO ahr_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","इस्त्राएल म्हणजे याकोबना पोऱ्यासना नावे ज्या आपला कुटूंबना संगे मिसर देशमा जायेल व्हतात, त्या ह्या शेतस ");
INSERT INTO ahr_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रऊबेन, शिमोन, लेवी, यहुदा; ");
INSERT INTO ahr_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साखार, जबुलून, बन्यामिन; ");
INSERT INTO ahr_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नफताली, गाद अनं आशेर, ");
INSERT INTO ahr_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","याकोबपाईन व्हयेल एकुण त्या सत्तर जन व्हतात; योसेफ हावु मिसरमाच व्हता. ");
INSERT INTO ahr_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","नंतर योसेफ अनं त्याना सर्वा भाऊ अनी त्या पिढीना सर्वाजन मरी गयात. ");
INSERT INTO ahr_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","इस्त्राएलना पोऱ्यासले पुत्र व्हयनात अनी अशी त्यासनी संख्या बरीच वाढीसन त्या बलवान व्हयनात अनी त्यासनाघाई पुरा देश भरी गया. ");
INSERT INTO ahr_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","तवय, योसेफबद्दल ज्याले माहीती नव्हती असा एक नवा राजा मिसर देशमा वना. ");
INSERT INTO ahr_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","तवय तो त्याना लोकसले बोलना, “ह्या इस्त्राएल वंशना लोके आपलापेक्षा शक्तीशाली अनी संख्यातीन बी भलताल वाढेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","तर चला आपण त्यासनासंगे चालाकितीन वागूत; नहीतर त्यासनी संख्या भलतीच वाढी अनी एखादंदाव युध्दनी परिस्थिती वनी म्हणजे त्या आपला शत्रुसमा सामील व्हतीन अनी कदाचीत आपलासंगे लढाई करतीन अनं या देशमाईन निंघी जातीन.” ");
INSERT INTO ahr_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","त्यासनी त्यासनावर भलताच कामना भार टाकीसन त्यासले थकाडानं, असा हेतूतीन त्यासनाकडतीन अतिकष्ट करी लेणारा मुकडदम नेमात; तवय त्यासनी फारोकरता पिथोम अनं रामसेस ह्या नगरं कोठारंसकरता बांधात. ");
INSERT INTO ahr_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","पण जस त्यासनी त्यासले तरास दिधा त्या भलताच वाढत गयात अनी त्या चारीमेर पसरी गयात, मंग मिसरी लोकसले इस्त्राएल लोकसनी भिती अनी घृणा वाटू लागनी. ");
INSERT INTO ahr_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","म्हणीसन मिसरी लोके इस्त्राएल लोकसकडतीन सक्तीतीन काम करी लेवू लागणात. ");
INSERT INTO ahr_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","त्यासनाकडतीन मातीना गारा अनं ईटा बनाडी लेत अनी त्यासले वावर माधला प्रत्येक प्रकारणा कामं कराले लायेत; असा कठीण काममुये त्यासले जीव नकोसा व्हयना; कारण त्यासनाकडतीन ज्या कामे करी ली राहींतात त्या भलताच जबरदस्तीना व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","दोन इब्री सुइणी व्हत्यात, एकनं नाव शिफ्रा अनं दुसरीनं नाव पुवा व्हतं, त्यासले मिसरना राजानी आज्ञा करी की, ");
INSERT INTO ahr_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","तुम्हीन इब्री बायासनं बांयतपण करतस, प्रसुती व्हवाना येळले तुम्हीन बठश्यात तर नीट दखा अनी पोऱ्या व्हयना तर त्याले मारी टाका अनी पोर व्हयनी तर तीले जिवत राहू द्या. ");
INSERT INTO ahr_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","त्या सुइणी देववर भरोसा ठेवणाऱ्या व्हत्यात म्हणीसन त्यासनी मिसरी राजाना हुकूमप्रमाणे न करता पोऱ्यासले जीवत राहू दिधं. ");
INSERT INTO ahr_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","तवय मिसरी राजानी त्या सुइणीसले बलाईन ईचारं, “तुम्हीन हाई काय करी राहीनात, पोऱ्यासले काबरं जीवत राहू दि राहिनात?” ");
INSERT INTO ahr_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","त्यासनी उत्तर दिधं, “इब्री बाया काय मिसरी बायासनामायक नहीत; त्या भलत्यास दमवाल्या शेतस, म्हणीसन सुइणी येवाना पहिले त्या मोकळ्या व्हई जातस.” ");
INSERT INTO ahr_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","या कामबद्दल देवनी त्या सुइणीसनं कल्याण करं, अनी इस्त्राएल लोके तर भलताच वाढीसन मजबूत व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","त्या सुइणी देवले भ्याईन वागणाऱ्या व्हत्यात, म्हणीसनी त्यानी त्यासना घरानं बसाडं. ");
INSERT INTO ahr_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","तवय फारोनी आपला सर्व लोकसले आज्ञा करी की, इब्री लोकसले व्हतीन तेवढा सर्व पोऱ्या नील नदीमा टाका अनी सर्व पोरीसले जीवत ठेवा. ");
INSERT INTO ahr_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी घरानामातील एक माणुसनी लेवी वंशनी पोरसंगे लगीन करं. ");
INSERT INTO ahr_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ती बाई गर्भवती व्हईसन तिले पोऱ्या व्हयना, ते बाळ देखणा शे हाई दखीसन तिनी त्याले तीन महीना दपाडीन ठेवं. ");
INSERT INTO ahr_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","पुढे त्याले दपाडीन ठेवता ई नही राहिंतं म्हणीसन लव्हाळंनं एक टोपली बनाडीन त्याले डांबर चोपडं अनं ती टोपलीमा त्या पोऱ्याले ठिसन नदीना किणारले जे उच्च गवत ऱ्हास तठे ठेवं. ");
INSERT INTO ahr_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","अनी त्यानं काय व्हई हाई दखाकरता त्यानी बहीण थोडी दूर उभी राहिनी. ");
INSERT INTO ahr_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","मंग फारोनी पोर तठे आंग धोवाले वनी, ती तीना‍ दासीससंगे नदी काठतीन जाई राहींती तवय गवतमा ती टोपली तिले दखायनी, तीनी दासीसले ती टोपली आणाले सांगं. ");
INSERT INTO ahr_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","जवय ती टोपली उघाडी तवय तिले ते बाळ दखायनं, ते रडी राहिंतं, तिले त्यानी किव वनी ती बोलनी, “हाई कोणीतरी इब्रीनं बाळ शे.” ");
INSERT INTO ahr_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","तवय त्या बाळनी बहिण फारोना पोरले बोलनी, “तुमनाकरता ह्या बाळले दुध पाजाकरता इब्री बायासमातीन एखादी बाईले बलावू का?” ");
INSERT INTO ahr_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फारोनी पोर तिले बोलनी, “जाय” बलावं तवय ती पोर जाईसन त्या बाळना मायले लई वनी. ");
INSERT INTO ahr_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फारोनी पोर तिले बोलनी, “ह्या पोऱ्याले लई जा अनी मनाकरता ह्याले दुध पाज, मी तुले पगार दिसू.” मंग ती बाई त्याले लई जाईसन दुध पाजू लागनी. ");
INSERT INTO ahr_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ते बाळ वाढीसन मोठं व्हयनं तवय ती त्याले लिसन फारोना पोरकडे गई, अनी तो तिना पोऱ्या व्हयना, तिनी त्यानं नाव मोशे ठेवं, \"कारण मी त्याले पाणीमातीन काढेल शे\" अस ती बोलणी. ");
INSERT INTO ahr_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","जवय मोशे मोठा व्हयना तवय त्या दिनसमा तो बाहेर आपला भाऊबंधकसकडे गया अनी त्यासनं काबाडकष्ट त्यानी दखं, तवय आपला भाऊबंधसपैकी एकले मिसरी माणुस मारी राहिना अस त्यानी दखं. ");
INSERT INTO ahr_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","तवय त्यानी आरंतारं दखं अनी कोणीच नही हाई दखीसन त्यानी त्या मिसरी माणुसले मारी टाकं अनी वाळूमा बुंजी दिधं. ");
INSERT INTO ahr_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","तो परत दुसरा दिन बाहेर गया तवय दोन इब्री माणसे एकमेकससंगे मारामारी करतांना त्यानी दखं, तवय त्यानी जो चुकीना व्हता त्याले बोलना, “तु आपलाच इब्री भाऊले का बरं मारी राहिना?” ");
INSERT INTO ahr_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","तो त्याले बोलना, “तुले आमनावर अधिकारी अनी न्यायाधीश कोणी नेमेल शे? तु त्या मिसरीले मारी टाकं, तस माले बी माराले दखी राहिना का?” तवय मोशे भ्यायना, तो स्वतःलेच बोलना, “जे मी करं ते लोकसले माहित पडनं वाटतं.” ");
INSERT INTO ahr_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","फारोना कानवर हाई गोष्ट गई तवय त्यानी मोशेले मारी टाकानं ठरायं, पण मोशे फारोपाईन पळी गया अनी मिद्द्यान देशमा जाईन राहु लागना अनी तठे एक विहीरजोडे बठना. ");
INSERT INTO ahr_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","तठे एक मिद्द्यानी माणुसले सात पोरी व्हत्यात त्या आपला बापन्या शेळ्यामेंढ्यासले पाणी पाजाकरता भांडा भरी राहिंतात. ");
INSERT INTO ahr_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","इतलामा काही धनगरसनी ईसन त्यासले हाकलु लागनात, तवय मोशेनी उठीसन त्या पोरीसले मदत करी अनी त्यासना कळपसले पाणी पाजं. ");
INSERT INTO ahr_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","त्या आपला बापकडे वनात, तवय तो बोलना, “आज तुम्हीन लवकर कश्या वन्यात.” ");
INSERT INTO ahr_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","तवय त्या बोलन्यात, धनगरसपाईन एका मिसरी माणुसनी आमले सोडावं अनी आमनाकरता पाणी काढीसन कळपले पाजं. ");
INSERT INTO ahr_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","तो त्यासले बोलना, “तो कोठे शे?” “त्याले तुम्हीन तठेच का बरं सोडी वनात? त्याले जेवाकरता बलाई आना.” ");
INSERT INTO ahr_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","मोशे त्या माणुसकडे ऱ्हावाले तयार व्हयना, त्यानी आपली पोरं सिप्पोरा संगे मोशेनं लगीन करी दिधं. ");
INSERT INTO ahr_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","तिले पोऱ्या व्हयना, त्यानी त्यानं नाव गेर्षोंम ठेवं, “कारण मी परदेशमा वस्ती करीसन राही राहिनु, अस तो बोलना.” ");
INSERT INTO ahr_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","बराच वरीसनंतर मिसरना राजा मरी गया, अनी इकडे इस्त्राएल लोके गुलामगिरी मुये आक्रोश करी राहिंता अनी ती गुलामगिरीमुये त्यासनी करेल आक्रोश देवपावत जाईसन पोहचना. ");
INSERT INTO ahr_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","देवनी त्यासना आक्रोश ऐका तवय अब्राहाम, इसहाक अनं याकोब यासनाशी करेल करारनी त्याले आठवण वनी. ");
INSERT INTO ahr_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","म्हणीसन देवनी इस्त्राएल लोकसकडे नजर लाई; देवनी त्यासनाकडे ध्यान दिधं. ");
INSERT INTO ahr_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मोशे आपला सासरा मिद्द्यानी याजक इथ्रो यान्या शेळ्यामेंढ्या चारे, एक रोज तो आपला कळप लिसन जंगलना मांगे देवना डोंगर होरेब आठपावत लई गया. ");
INSERT INTO ahr_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","तवय परमेश्वरना दूतनी एक झुडूपमातीन अग्नीज्वालाना व्दारे त्याले दर्शन दिधं, त्यानी नजर लाईसन दखं की, अग्नीघाई झुडूप जळी राहिनं पण ते भस्म व्हयनं नही अस त्याले दखायनं. ");
INSERT INTO ahr_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","तवय त्यानी ईचार करा, मी तठे जाईसन दखंस की काय चमत्कार शे, ते झुडूप का बरं भस्म नही व्हई राहिनं. ");
INSERT INTO ahr_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ते दखाकरता मोशे तिकडे वळना हाई परमेश्वरनी दखं अनी झुडूपमातीन देवनी त्याले हाक मारीन सांंगं, मोशे तवय तो बोलना, काय आज्ञा? ");
INSERT INTO ahr_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","देव त्याले बोलना, “इकडे जोडे येऊ नको, तु तुना पायमाधला जोडा काढ, कारण जी जागावर तु उभा शे ती पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","मी तुना बापना देव, अब्राहामना देव, इसहाकना देव, याकोबना देव शे.” तवय मोशेनी आपलं तोंड झाकं, कारण देवकडे दखानी त्यानी हिम्मत व्हयनी नही. ");
INSERT INTO ahr_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","देव बोलना, मिसर देशमा ज्या मना लोके शेतस त्यासना हाल मी दखेल शे, त्यासनाकडतीन मजूरी करी लेणारा मुकडदमसना तरासमुये त्यासनी करेल आक्रोश मी ऐकेल शे, त्यासना क्लेश माले समजेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","त्यासले मिसरी लोकसपाईन सोडावानं अनी चांगला मोठा देशमा, दुध अनं मधन्या धारा वाही राहिन्यात असा देशमा म्हणजे कनानी, हित्ती, अमोरी, परिज्जी, हिव्वी अनं यबूसी यासना देशमा त्यासले लई जावानं म्हणीसन मी उतरेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","इस्त्राएल वंशना आक्रोश मनापावत येल शे, मिसरी लोके कसा त्यासनावर जुलूम करी राहिनात हाई बी मी दखेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","तर आते चाल, मी मिसर देशमातील मना इस्त्राएल वंशना लोकसले बाहेर काढानं म्हणीसन मी तुले फारोकडे धाडी राहीनु. ");
INSERT INTO ahr_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","तवय मोशे देवले बोलना, “फारोकडे जाईसन इस्त्राएल लोकसले मिसर देशमातील काढी आनणारा अशा मी कोण?” ");
INSERT INTO ahr_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","देव बोलना, “मी तुनासंगे ऱ्हासु, मी तुले धाडं यानी तुले हाईच खूण की, तु लोकसले मिसरमातीन काढीन आणावर याच डोंगरवर तुम्हीन मनी उपासना करशात. ");
INSERT INTO ahr_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","“तवय मोशे देवले बोलना, मी इस्त्राएल लोकसकडे जासु, दखा ‘माले तुमना पुर्वजसना देवनी तुमनाकडे धाडेल शे.’ अस त्यासले सांगं, तवय त्यासनी ईचारं, ‘त्यानं नाव काय?’ तवय मी त्यासले काय सांगु?” ");
INSERT INTO ahr_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","देव मोशेले बोलना, “जो मी शे तोच राहसु, तु इस्त्राएल लोकसले सांगं, ‘मी शे ह्यानी माले तुमनाकडे धाडेल शे.’ ");
INSERT INTO ahr_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","आखो त्यासले सांगं, तुमना पुर्वजसना देव, अब्राहामना देव, इसहाकना देव अनं याकोबना देव यहोवा यानी माले तुमनाकडे धाडेल शे, हाईच मनं सनातन नाव शे अनं ह्याच नावतीन पिढ्यानपिढ्या मनं स्मरण व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","तु जाय अनी इस्त्राएलना वडील लोकसले जमाडीसन सांगं, तुमना पुर्वजना देव, अब्राहामना देव, इसहाकना देव, याकोबना देव परमेश्वर यानी माले दर्शन दिसन सांगं की, मनं तुमनाकडे खरंच ध्यान येल शे अनी मिसर देशमा तुमनं काय व्हई राहीनं हाई माले समजेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","मिसर देशमातील पिळवणुक पाईन मी तुमले सोडाईसन कनानी, हित्ती, अमोरी, परिज्जी, हिव्वी अनं यबूसी यासना देशमा, जठेन दुध अनं मधन्या धारा वाही राहिन्यात असा देशमा लई जासु, अस मी सांगेल शे.” ");
INSERT INTO ahr_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","तुनं सांगनं त्या ऐकतीन, मंग तु अनी इस्त्राएलसना वडील लोकं मिसर देशना राजाकडे जा अनी त्याले सांगा, इब्रीसना देव यहोवा आमले भेटेल शे, तर आमना देव यहोवा याले होमबली अर्पण करानं शे म्हणीसन आमले तीन दिवसनी वाट चालीसन जंगलमा जाऊ दे. ");
INSERT INTO ahr_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","पण माले माहीत शे की मिसर देशना राजा तोपावत तुमले जावू देवाव नही जोपावत त्याले सामर्थ्यशाली हात दखाडावं नही. ");
INSERT INTO ahr_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","मंग मी आपला हात दखाडीसन मिसर देशमा ज्या सर्व अद्भुत कृती करणार शे त्याना मारा मी त्यासनावर करसु, मंग तो तुमले जावु दि. ");
INSERT INTO ahr_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“अनी ह्या लोकसवर मिसरी लोकसनी कृपा व्हई अस मी करसु, म्हणीसन तुम्हीन निंघशात तवय रिकामे हाते निंघावुत नही. ");
INSERT INTO ahr_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","तर तुमनी प्रत्येक बाई आपली शेजारीणी बाईपाईन अनं तिनाकडे राहणारी बाईपाईन सोने-चांदीना अलंकार अनी कपडा मांगी ली; ते तुम्हीन आपला पोऱ्या अनी पोरीसले घालशात अशा तुम्हीन मिसरी लोकसले लुटशात.” ");
INSERT INTO ahr_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","तवय मोशेनी उत्तर दिध, “पण त्या मनावर ईश्वास करावूत नही अनं मनं म्हणनं बी ऐकी लेणार नहीत, त्या बोलतीन परमेश्वरनी तुले दर्शन दिध नही.” ");
INSERT INTO ahr_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","तवय परमेश्वर त्याले बोलना, “तुना हातमा ते काय शे?” तो बोलना, “काठी शे.” ");
INSERT INTO ahr_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","परमेश्वर त्याले बोलना, “ती जमिनवर टाक” ती त्यानी टाकताच तिना साप व्हयना, त्याले दखीसन मोशे पळना. ");
INSERT INTO ahr_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","तवय परमेश्वर मोशेले बोलना, “आपला हात पुढे करीसन त्यानी शेपुटले धर” तवय त्यानी हात पुढे करीसन त्याले धरं त्यानी परत काठी व्हई गई. ");
INSERT INTO ahr_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“म्हणजे त्यासना पुर्वजसना देव, अब्राहामना देव, इसहाकना देव अनं याकोबना देव यहोवा ह्यानी तुले दर्शन देल शे, हाई यावतीन त्यासले पटी.” ");
INSERT INTO ahr_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","परमेश्वर त्याले आखो बोलना, “आते तु आपला हात उरवर ठेव” त्यानी आपला हात उरवर ठेवा तर, तो कोड व्हईसन बरफना मायक धवळाभडक व्हयना. ");
INSERT INTO ahr_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","मंग परमेश्वर त्याले परत बोलना, “आपला तू हात परत उरवर ठेव” अनी त्यानी ठेवा तर त्याना हात परत पहिलासारखा व्हई गया. ");
INSERT INTO ahr_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","तो आखो बोलना, “तुना पहिला‍ चमत्कारले दखीसन त्यासनी जर तुना ईश्वास नही ठेवा तर त्या ह्या तुना दुसरा चमत्कारले खरं मानतीन. ");
INSERT INTO ahr_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","जर त्या ह्या दोन्ही चमत्कार मानावूत नहीत अनं तुनं ऐकणार नहीत तर तु नदीतीन पाणी लिसन कोरडी जमिनवर वत, म्हणजे तु नदीमातीन लेयल पाणीनं कोरडी जमिनवर रक्त व्हई.” ");
INSERT INTO ahr_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","पण मोशे बोलना, “हे प्रभु, मी वक्ता नही शे, पहिले बी नव्हतु, अनं तु आपला दासकडे बोलना तवयपाईन बी नही, मी तर बोलामा कच्चा शे, जड जिभना शे.” ");
INSERT INTO ahr_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","तवय परमेश्वर त्याले बोलना, “मनुष्यले तोंड कोणी देयल शे? मनुष्यले मुका, बहिरा, डोळस अनी आंधया कोण करस? मीच ना? ");
INSERT INTO ahr_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","तर आते जाय, मी तुना बोलाले मदत करसु, अनी तु काय बोलानं ते तुले शिकाडसु.” ");
INSERT INTO ahr_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","पण मोशे बोलना, “नको प्रभु, दुसरं कोणले तरी धाड.” ");
INSERT INTO ahr_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","मंग मोशेवर परमेश्वरना संताप व्हयना अनी त्याले बोलना, “लेवी वंशना अहरोन हावु तुना भाऊ नही शे का? त्याले चांगलं बोलता येस हाई माले माहीत शे, तो दख तुले भेटाले ई राहीना, तुले दखीसन तो मनमा भलताच खुश व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","तु त्यानासंगे बोल अनी त्याले सांग तुले काय बोलनं शे, मी त्याले अनी तुले बोलाकरता मदत करसु अनी तुमले काय करनं शे हाई तुमले शिकाडसु. ");
INSERT INTO ahr_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","तो तुनाकडतीन लोकससंगे बोली, तवय तु त्यानाकरता देवनामायक व्हशी, त्याले तु सांगानं काय बोलनं शे. ");
INSERT INTO ahr_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","तु आपला हातमा हाई काठी ले, ह्याघाई तु चिन्ह दखाडशी.” ");
INSERT INTO ahr_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","मंग मोशे तठेन निंघीसन आपला सासरा इथ्रो यानाकडे गया अनं त्याले बोलना, “माले मिसरमाधला मना भाऊबंधकसकडे दे, त्या आजूनपावत जिवत शेतस की नही हाई माले दखु दे.” तवय इथ्रो बोलना, “सुखमा जा.” ");
INSERT INTO ahr_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","मिद्द्यान प्रांतमा परमेश्वर मोशेले बोलना, “चल मिसर देशमा परत जाय, तुना जीव लेवाले दखणारा सर्वा मरी जायेल शेतस.” ");
INSERT INTO ahr_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","मंग मोशे आपली बायको अनं पोऱ्यासले गधडावर बसाडीसन मिसर देशले जावाकरता निंघना अनी देवनी देल काठी बी हातमा लिधी. ");
INSERT INTO ahr_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","परमेश्वर मोशेले बोलना, “तु मिसरमा परत गया म्हणजे ज्या चमत्कार तुना हातमा शेतस त्या सर्व फारोपुढे करी दखाड, तरी बी तो मना लोकसले जाऊ देवाव नही, कारण त्यानं मन मी कठीण करसु. ");
INSERT INTO ahr_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","तु जाईसन फारोले सांग, परमेश्वर म्हणस इस्त्राएल हावु मना पोऱ्या शे, मना थोरला पोऱ्या शे. ");
INSERT INTO ahr_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","मी तुले सांगेल शे, मना पोऱ्यासले मनी उपासना कराले जावु दे, पण तु त्यासले जावु दि नही राहीना, तर दख मी तुना पोऱ्या, तुना थोरला पोऱ्याले मारी टाकसु.” ");
INSERT INTO ahr_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","मंग प्रवास करतांना त्या उतारशाळमा व्हतात तठे परमेश्वरनी मोशेले गाठं अनी त्याले मारी टाकाना प्रयत्न करा. ");
INSERT INTO ahr_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","तवय मोशेनी बायको सिप्पोरा हिनी एक धारदार दगड लिसन त्याना पोऱ्यानी माय अंगना समोरली कातडी कापी अनी ती मोशेना पायजोडे ठिसन बोलनी, “तु रक्तघाई लेयल मना नवरा शे.” ");
INSERT INTO ahr_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","तवय परमेश्वरनी मोशेले मारं नही, रक्तघाई लेयल नवरा अस ती सुंताले अनुसरीसन बोलनी. ");
INSERT INTO ahr_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","मंग परमेश्वर अहरोनले बोलना, “मोशेले भेटाकरता तु रानमा जा.” तो गया अनी देवना डोंगरवर त्याले भेटीसन त्याले नमस्कार करा. ");
INSERT INTO ahr_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","मंग परमेश्वरनी त्याले ज्या आज्ञा दिसन धाडं अनं ज्या चमत्कार दखाडाले आज्ञा करी ते सर्व मोशेनी अहरोनले सांगं. ");
INSERT INTO ahr_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","नंतर मोशे अनी अहरोन ह्यासनी जाईसन इस्त्राएल वंशना सर्व वडील लोकसले एकत्र जमाडात. ");
INSERT INTO ahr_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","अनी परमेश्वरनी जे मोशेले सांगं ते सर्व अहरोननी इस्त्राएल लोकसले सांगं अनी त्यासले चमत्कार करी दखाडात. ");
INSERT INTO ahr_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","तवय लोकसले भरोसा पटना, परमेश्वरनी इस्त्राएल घराणानी भेट लिसन त्यासनी विपत्तीकडे लक्ष देयल शे हाई त्यासनी ऐकं तवय त्यासनी त्याले नमन करीसन त्यानी आराधना करी. ");
INSERT INTO ahr_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","मंग मोशे अनी अहरोन मिसरना राजा फारोकडे जाईसन बोलनात, “इस्त्राएलना देव यहोवा सांगी राहिना की, मना लोकसले मनाकरता रानमा जाईसन उत्सव कराले जाऊ दे.” ");
INSERT INTO ahr_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","तवय फारो बोलना, “हावु कोण परमेश्वर की त्यानं ऐकीसन मी इस्त्राएल लोकसले जाऊ देवु? मी त्या परमेश्वरले वळखस नही अनी इस्त्राएल लोकसले काय जाऊ देवाव नही.” ");
INSERT INTO ahr_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","मोशे अनी अहरोन बोलनात, “इब्रीसना देवनी आमले भेट देयल शे, तर आते तीन दिननी वाट चालीसन रानमा जाऊ दे अनी आमना देव यहोवा ह्याले यज्ञबली अर्पु दे, अशी आमले परवानगी दे, अस नही करं तर तो तलवारघाई नहितर युध्द करीसन आमले मारी टाकी.” ");
INSERT INTO ahr_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","मिसरना राजा त्यासले बोलना, “हे मोशे अनी अहरोन, तुम्हीन लोकसले काम सोडीसन काबरं जावाले लाई राहिनात? निंघा आठेन, आपला कामे करा! ");
INSERT INTO ahr_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ह्या मजुर लोके देशमा बराच शेतस अनी तुम्हीन त्यासले काम सोडीसन जावाले लाई राहिनात!” ");
INSERT INTO ahr_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","त्याच रोज फारोनी त्या लोकसना मुकडदम अनी त्यासना ठेकेदारसले आज्ञा करी की, ");
INSERT INTO ahr_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ईटा पाडाकरता आजपावत तुम्हीन या लोकसले गवत अनी दिधं तसं आते करू नका त्यासले स्वतः गवत आनु द्या. ");
INSERT INTO ahr_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","अनी जेवढ्या ईटा त्या पाडेत तेवढ्याच आते बी त्यासनाकडतीन पाडी ल्या, त्यामा काही कमी करानं नही, त्या आळशी व्हयेल शेतस म्हणीसन त्या वरड करी राहिनात की, आमले जाऊ दे, आमना देवले यज्ञबली अर्पु दे. ");
INSERT INTO ahr_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","या लोकसले आखो काम द्या म्हणजे त्यासनावर कामनं वझ पडीसन त्या ह्या खोटं बोलनावर ध्यान देवावुत नही.” ");
INSERT INTO ahr_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","मंग लोकसना मुकडदम अनी ठेकेदार बाहेर जाईसन त्यासले बोलनात, “राजानी सांगा, मी तुमले गवत पुरावनार नही. ");
INSERT INTO ahr_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","तुम्हीन स्वतः कुठेन बी गवत शोधी आणा अनी तुमनं काम काही कमी व्हणार नही.” ");
INSERT INTO ahr_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","तवय त्या लोके गवतना बदलामा धान्यनं कुड जमा कराकरता पुरा मिसर देशमा पसरी गयात. ");
INSERT INTO ahr_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","त्यासना मांगे मुकडदम रोज तगादा लावत राहे अनी सांगे की, तुमले गवत देयेत तवय जीतलं काम करेत तेवढच रोजनं काम आत्ते बी पुरं करा. ");
INSERT INTO ahr_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","इस्त्राएल लोकसवर त्यासनापैकी ज्या ठेकेदार नेमेल व्हतात त्यासले फारोना मुकडदमसनी मार दिसन ईचारं, “तुम्हीन कायम पाडतस तेवढ्या ईटा काबरं पाडी नही राहिनात?” ");
INSERT INTO ahr_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","तवय इस्त्राएल लोकसना ठेकेदार फारोकडे जाईसन वरड करू लागनात, “आपण आपला दाससंगे असा काबरं वागी राहिनात? ");
INSERT INTO ahr_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","आपला दाससले गवत देतस नही तरी त्या आमले म्हणतस, ईटा पाडा, दखा, तुमना दाससले मार भेटी राहिना, पण चुक सर्व तुमना माणससनी शे.” ");
INSERT INTO ahr_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फारो राजा बोलना, “तुम्हीन आळशी शेतस आळशी, तुमले काम कराले नको, म्हणीसन तुम्हीन म्हणतस, आमले जाऊ द्या, आमना देवले आमले यज्ञ करू द्या. ");
INSERT INTO ahr_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","निंघा आठेन अनी आपलं काम करा, तुमले गवत काय मिळावं नही अनी ईटा तर तेवढ्याच येवाले पाहीजे जेवढ्या पहिले ईयेत.” ");
INSERT INTO ahr_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ईटा अनं रोजनं काम यामा तुम्हीन काहीच कमी करानं काम नही, अस इस्त्राएलसना ठेकेदारसले धमकाडं, तवय आपण भलताच संकटमा पडी गवुत अस त्यासना ध्यानमा वनं. ");
INSERT INTO ahr_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","फारोकडतीन निंघानंतर त्यासले वाटमा मोशे अनं अहरोन भेटनात, ");
INSERT INTO ahr_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","तवय त्या त्यासले बोलनात, “परमेश्वर तुमले दखी लेवो, तुम्हीन हाई काय करं फारो अनं त्याना नौकर आमना व्देष करी राहिनात, तुम्हीन आमले त्यासना हातमा मारी टाकाकरता दि टाकेल शे.” ");
INSERT INTO ahr_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","मंग मोशे परमेश्वरकडे परत जाईसन बोलना, “प्रभु तु तुना लोकसले कसाले काबरं पिढा दि राहिना? माले तु त्यासनाकडे काय म्हणीसन धाडं? ");
INSERT INTO ahr_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","मी तुनं नाव करीसन बोलाकरता फारोकडे वनु तवय पाईन तो या लोकसले पिढा दि राहिना, तु आपला लोकसले तर अजिबातच सोडायं नही.” ");
INSERT INTO ahr_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","मंग परमेश्वर मोशेले बोलना, “मी आते फारोले काय करस ते तु दखशी, मी त्याले भुजबल दखाडा म्हणजे तो या लोकसले जाऊ दि, मना भुजबल त्याले दखाडा म्हणजे तो यासले आपला देशमातीन बाहेर हाकली दि.” ");
INSERT INTO ahr_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","देव मोशेले बोलना, “मी यहोवा परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","मी अब्राहाम, इसहाक अनं याकोब यासले सर्वसमर्थ देव म्हणीसन प्रकट व्हयेल शे तरी परमेश्वर हाऊ मना नावतीन मी त्यासले माहित नव्हतु. ");
INSERT INTO ahr_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ज्या कनान देशमा त्या पाहुणा व्हतात तो परदेश त्यासले वतन म्हणीसन देवाना करार मी त्यासनाशी करेल शे, ");
INSERT INTO ahr_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","आते ज्या इस्त्राएल लोकसले मिसरीसनी दास करी ठेयल शे, त्यासना आक्रोश ऐकीसन मी आपला करारनं स्मरण करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","म्हणीसन इस्त्राएल लोकसले सांग, ‘मी यहोवा परमेश्वर शे, मी तुमले मिसरीसना मजुरीमातीन सोडावसु, त्यासना गुलामगिरीतीन तुमले मुक्त करसु अनी हात लांब करीसन त्यासले चांगलीच शिक्षा दिसु अनी तुमले वाचाडसु. ");
INSERT INTO ahr_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","मी तुमले आपली प्रजा करी लिसु अनी मी तुमना देव व्हसु, म्हणजे तुमले मिसरी लोकसना गुलामगिरीमातीन सोडावनारा मी तुमना देव यहोवा शे, हाई तुमले समजी. ");
INSERT INTO ahr_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","अनी जो देश अब्राहाम, इसहाक अनं याकोब यासले देवानी शपथ मी हात वर करीसन देयल व्हती, त्यामा मी तुमले लई जासु अनी तो मी तुमले वतन म्हणीसन दिसु, मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","मोशेनी हाई सर्व इस्त्राएल लोकसले सांगं, पण त्या आपला मनमातील संतापमुये अनी कठीण गुलामगिरीमुये त्या मोशेनं ऐकी नही राहिंतात.’” ");
INSERT INTO ahr_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","मंग परमेश्वर मोशेले बोलना, ");
INSERT INTO ahr_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“तु जाईसन मिसरना राजा फारोले सांग की, ‘इस्त्राएल लोकसले’ तुना देशमातीन निंघी जाऊ दे.” ");
INSERT INTO ahr_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","पण मोशे बोलना, “इस्त्राएल लोकसनी मनं ऐकं नही तर फारो मनं कसं ऐकी? मी तर बोलामा कच्चा शे.” ");
INSERT INTO ahr_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","तवय देवनी मोशे अनी अहरोनले आज्ञा करी, “इस्त्राएल लोकसले अनी मिसरना राजाले आज्ञा करी की, तो इस्त्राएल लोकसले मिसर देशमातीन बाहेर काढी आनी.” ");
INSERT INTO ahr_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","मोशे अनी अहरोन यासना पुर्वजसपैकी प्रमुख पुरूष ह्या शेतस, इस्त्राएलना थोरला पोऱ्या रऊबेन याना पोऱ्या हानोख, पल्लू हेस्त्रोन अनं कर्मी, ह्या रऊबेनना कुळं. ");
INSERT INTO ahr_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमोनना पोऱ्या: यमुवेल यामीन, ओहद, याखीन जोहर अनं कनानी बाईपाईन व्हयेल शौल, ह्या शिमोनना कुळं, ");
INSERT INTO ahr_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवीना वंशावळीप्रमाणे त्यासना पोऱ्यासनी नावं अशा शेतस: गेर्षोन, कहाथ अनं मरारी, लेवी एकशे सदतीस वरीस जगना. ");
INSERT INTO ahr_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्षोनना कुळप्रमाणे त्याना पोऱ्या लिब्नी अनं शिमी ह्या मुख्य व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहाथना पोऱ्या: अम्राम, इसहाक, हेब्रोन अनं उज्जियेल, कहाथ एकशे तेहतीस वरीस जगना. ");
INSERT INTO ahr_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारीना पोऱ्या: महली अनं मुशी. लेवीना वंशावळीप्रमाणे ह्या त्याना कुळं. ");
INSERT INTO ahr_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्रामानी आपली आत्यासंगे लगीन करं, तिनापाईन तिले अहरोन अनी मोशे व्हयनात, अम्राम हावु एकशे सदतीस वरीस जगना. ");
INSERT INTO ahr_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","इसहारना पोऱ्या: कोरह, नेफेग अनं जिख्री. ");
INSERT INTO ahr_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्जियेलना पोऱ्या मिशाएल, एलसाफान अनं सिथ्री. ");
INSERT INTO ahr_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","अहरोननी अम्मीनादाबनी पोर, नहशोननी बहिण अलिशेबा हिनासंगे लगीन करं, तिनापाईन त्याले नादाब, अबीहू, एलाजार, अनं इथामार ह्या व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरहाले तीन पोऱ्या व्हतात: अस्सीर, एलकाना अनं अबीयासाफ, ह्या कोहरना कुळं. ");
INSERT INTO ahr_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","अहरोनना पोऱ्या एलाजार यानी पुटियेलना पोरीसपैकी एकसंगे लगीन करी लिधं. तिनापाईन त्याले फिनहास व्हयना. त्यासना घराणा प्रमाणे लेवीना पितृकुलमातील मुळ पुरूष ह्याच व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","इस्त्राएल लोकसले दल करीसन मिसर देशमातीन बाहेर लई जा अशी परमेश्वरनी ज्यासले आज्ञा देयल व्हती त्याच ह्या मोशे अनी अहरोन. ");
INSERT INTO ahr_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","इस्त्राएल लोकसले मिसरमातीन बाहेर लई जासू अस मिसरी राजाले सांगनारा त्याच ह्या मोशे अनी अहरोन. ");
INSERT INTO ahr_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","मंग ह्या दिनले मिसरमा परमेश्वर मोशेसंगे बोलना, ");
INSERT INTO ahr_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","तो मोशेले बोलना, “मी यहोवा शे, मी तुले सांगस ते सर्व मिसरी राजा ह्याले सांग.” ");
INSERT INTO ahr_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","तवय मोशे बोलना, “तुले माहीत शे, मी बोलामा कच्चा शे, मंग फारो मनं कसं ऐकी.” ");
INSERT INTO ahr_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","तवय परमेश्वर मोशेले बोलना, “दख मी तुले फारोना देवच बनाडस अनी तुना भाऊ अहरोन तुना संदेष्टा व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","जी काही आज्ञा मी तुले करसु ती अहरोनले सांग की तो फारोले सांगी की, तु इस्त्राएल लोकसले तुना देशमातीन जाऊ दे. ");
INSERT INTO ahr_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","पण मी फारोनं मन कठीण करसु अनी मिसर देशमा मना बराच चिन्ह अनी चमत्कार दखाडसु. ");
INSERT INTO ahr_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","तरी फारो तुमनं काय ऐकाव नही मंग मिसरवर मना हात चालावसु, अनी त्यासले मोठे शिक्षा करीसन आपली सेना इस्त्राएल लोकसले मिसर देशमातीन लई जासु. ");
INSERT INTO ahr_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","अनी मी मिसरवर आपला हात उगारीसन त्यासनामातीन इस्त्राएल लोकसले लई जासु, तवय मिसरी लोकसले समजी की मी परमेश्वर शे.” ");
INSERT INTO ahr_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","परमेश्वरनी करेल आज्ञाप्रमाणे मोशे अनी अहरोननी करं. ");
INSERT INTO ahr_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","जवय ह्यासनी फारोसंगे हाई बोलनं करं तवय मोशे ऐंशी अनी अहरोन त्र्याऐंशी वरीसना व्हता. ");
INSERT INTO ahr_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","मंग परमेश्वर मोशे अनं अहरोनले यासले बोलना, ");
INSERT INTO ahr_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“तुम्हीन स्वतः काही अद्भुत कृती करी दखाडा अस फारो तुमले बोलना तवय तु अहरोनले सांग, आपली काठी लिसन फारोपुढे टाक म्हणजे तिना साप व्हई.” ");
INSERT INTO ahr_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","मंग मोशे अनी अहरोन यासनी परमेश्वरनी आज्ञाप्रमाणे फारोकडे करं, अहरोननी आपली काठी फारो अनी त्याना सेवकसनापुढे टाकी अनी तिना साप व्हयना. ");
INSERT INTO ahr_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","हाई दखीसन फारोनी त्याना जानते अनी मांत्रीक ह्यासले बलावं, त्या मिसरी जादुगरसनी बी तसा प्रकार करी दखाडा. ");
INSERT INTO ahr_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","त्यासनी बी आप आपल्या काठ्या खाल टाकताच त्यासना बी सापं व्हयनात, पण अहरोनना काठीनी त्यासन्या काठ्यासले गिळी टाकं. ");
INSERT INTO ahr_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","पण फारोनं मन अजून कठीण व्हयनं अनी परमेश्वरनी सांगेलप्रमाणे त्यानी मोशे अनं अहरोन यासनं ऐकं नही. ");
INSERT INTO ahr_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","तवय परमेश्वर मोशेले बोलना, “फारोनं मनं कठिण शे तो या लोकसले जाऊ देवाव नही. ");
INSERT INTO ahr_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","जवय फारो सकासले नदीजोडे ई तवय तू त्यानाजोडे जाय अनी जी काठी साप बनेल व्हती, ती आपला हातमा लिसन तू निल नदीना किनारले जाईन त्यानी वाट पाय. ");
INSERT INTO ahr_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","त्याले अस सांग की, इब्रीसना देव परमेश्वर यानी मनाकडे तुनाकरता निरोप देयल शे की, मना लोकसले जाऊ दे म्हणजे त्या रानमा मनी उपासना करतीन, पण तु अजून ऐकी नही राहिना. ");
INSERT INTO ahr_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","परमेश्वर म्हणस की, मी परमेश्वर शे हाई तुले यावरतीन समजी दख, मी मना हातमाधली काठी नदीना पाणीवर मारसु तवय पाणीनं रक्त व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","नदीमाधला मासा मरतीन अनी तिमा घाण वास सुटी, अनी तिनं पाणी पेवाकरता मिसरी लोकसले किळस वाटी.” ");
INSERT INTO ahr_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","“मंग परमेश्वरनी मोशेले सांगं, तु अहरोनले सांग की, आपली काठी लिसन मिसर देशमा जितलं पाणी शे म्हणजे नद्या, नाला, तलाव अनं हौद या सर्वांसवर आपला हात उगार म्हणजे त्या सर्वांसवर आपला हात उगार म्हणजे त्या सर्वासनं रक्त व्हई अनी मिसरमातील खडकसमातीन सर्व झरासमा रक्तच रक्त व्हई.” ");
INSERT INTO ahr_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","तवय मोशे अनी अहरोन यासनी परमेश्वरना आज्ञाप्रमाणे करं. त्यानी काठी उचलीसन फारो अनं त्याना सेवकसना समोर पाणीवर मारी तवय नदीमातीन सर्व पाणी रक्त व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","नदिमातील मासा मरी गयात त्यामातीन घाण वास सुटना अनी मिसरी लोकसले नदीमातीन पाणी पिता ई नही राहिंतं, सारा मिसर देशमा रक्तच रक्त व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","तवय मिसरी जादुगरसनी बी मंत्रतंत्रसघाई तसाच प्रकार करा. तवय फारोनं मनं कठीण व्हयनं अनी त्यानी मोशे अनं अहरोन यासनं ऐकं नही, हाई परमेश्वरनी मोशेले पहिलेच सांगेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","फारो तठेन मांगे फिरना अनी आपला घर गया, ह्यावर बी त्यानी भरोसा करा नही. ");
INSERT INTO ahr_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","सर्व मिसरी लोकसनी पेवाना पाणीकरता नदीना आसपास झरा खोदात. कारण नदिनं पाणी त्यासले पिता ई नही राहिंतं. ");
INSERT INTO ahr_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","परमेश्वरनी नदीले शिक्षा करीसन सात दिन व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","तवय परमेश्वर मोशेले बोलना, “फारोकडे जाईसन त्याले सांगं, परमेश्वर अस सांगस कि, ‘मना लोकसले मनी उपासना कराकरता जाऊ दे. ");
INSERT INTO ahr_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","तु जर त्यासले जाऊ देवाव नही तर दख मी बेडकसघाई तुना पुरा देशले पिढा दिसु. ");
INSERT INTO ahr_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","नील नदीमा बेडकसना सुळसुकाट व्हई अनी तुना मंदिरमा, तुनी झोपानी खोलीमा, तुना आंथरूनवर, तुना नौकरचाकरसना घरमा, तुनी प्रजावर, तुन्या भट्ट्यासमा अनी भांडासमा बेडूकच बेडूक व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","तुना अनं तुना लोकसना अनी तुना सर्व सेवकसना आंगवर बेडकं चढतीन.” ");
INSERT INTO ahr_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","परमेश्वर मोशेले बोलना, “अहरोनले सांग की, आपली काठी लिसन नद्या, नाला, अनं तलाव यासवर आपला हात उगार अनी बेडूक मिसर देशवर चढी येतीन.” ");
INSERT INTO ahr_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","म्हणीन अहरोननी मिसरमातील सर्व पाणीवर आपला हात उगारा तवय बेडूक बाहेर निंघनात अनी त्यासनी पुरा मिसर देश भरी गया. ");
INSERT INTO ahr_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","जादुगरसनी बी आपला तंत्रमंत्रसघाई तसच करं त्यासनी बी पुरा मिसर देशवर बेडूक आणात. ");
INSERT INTO ahr_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","मंग फारोनी मोशे अनी अहरोन यासले बलाईसन सांगं की, “परमेश्वरले ईनंती करा की, मनापाईन अनी मनी प्रजापाईन त्यानी या बेडकसले दूर करावं म्हणजे परमेश्वर करता यज्ञ कराकरता मी तुमना लोकसले जाऊ दिसु.” ");
INSERT INTO ahr_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मोशे फारोले बोलना, “तुनापाईन अनी तुनी प्रजापाईन बेडूक काढी टाकीसन फक्त नदीमा राहु दिसु यामुये मी तुनाकरता अनं तुना सेवकसकरता कोणती येळले प्रार्थना करू हाई तु माले सांग.” ");
INSERT INTO ahr_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","राजा बोलना, “सकाय” मोशे बोलना, “तुनी आज्ञाप्रमाणे व्हई म्हणजे तुले समजी कि आमना देव यहोवाना मायक कोणताच देव नही. ");
INSERT INTO ahr_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","बेडूक तुनापाईन तुना सेवकसपाईन, तुनी प्रजापाईन दूर व्हई, त्या फक्त नील नदीमा राहतीन.” ");
INSERT INTO ahr_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","मंग मोशे अनं अहरोन फारोकडतीन निंघी गयात अनी परमेश्वरनी फारोवर ज्या बेडूक आनेल व्हतात त्याबद्दल मोशेनी परमेश्वरकडे प्रार्थना करी. ");
INSERT INTO ahr_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","परमेश्वरनी मोशेनी सांगेलप्रमाणे करं, अनी घरदारमा, अंगनमा अनं वावरसमा‍ ज्या बेडूक व्हतात त्या मरी गयात. ");
INSERT INTO ahr_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","लोकसनी त्यासले गोया करीसन त्यासना ढिग करात, तवय सर्वीकडे घाण वास सुटना. ");
INSERT INTO ahr_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","फारोनी दखं कि, बेडुक मरी गयात तवय त्यानं मन परत कठीण व्हयनं अनी त्यानी मोशे अनं अहरोन यासनं ऐकं नही, परमेश्वरनी अस सांगेलच व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","मंग परमेश्वनी मोशेले सांगं, “अहरोनले सांग की, आपली काठी उगारीसन जमिनवरली धुळवर मार म्हणजे मिसरदेश भर त्या धुळन्या पिसवा बनतीन.” ");
INSERT INTO ahr_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","अहरोननी आपला हातमाधली काठी उगारीसन जमिननी धुळवर मारी तवय मनुष्य अनी पशुसवर पिसू व्हयन्यात. जमिनवरली धुळघाई सर्व मिसर देशमा पिसवाच पिसवा व्हयन्यात. ");
INSERT INTO ahr_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","पिसवा बनाडाकरता जादुगरसनी बी आपला मंत्र बोलीसन तसाच प्रकार करा. पण त्यासले काय जमनं नही, मनुष्य अनी पशु पिसवासघाई सर्वीकडे भरी गयात. ");
INSERT INTO ahr_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","तवय जादुगर फारोले बोलनात, “यामा देवना हात शे.” तरी फारोनं मन कठीण व्हयनं अनी त्यानी त्यासनं ऐकं नही. जसं देवनी सांगेल व्हतं ");
INSERT INTO ahr_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","मंग परमेश्वरनी मोशेले सांगं की, “पहाटले उठ अनी जाईसन फारोपुढे उभा ऱ्हाय. तो ती येळले नदिवर येस, तु त्याले सांग, ‘परमेश्वर म्हणस, मना लोकसनी मनी उपासना कराले पाहीजे म्हणीसन त्यासले जाऊ दे. ");
INSERT INTO ahr_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","त्यासले जाऊ देवाव नही तर दख, तुनावर, तुना सेवकसवर, तुनी प्रजावर अनी तुना घरमा मी गोमाशीसना थवा धाडसु. मिसरी लोकसना घरं अनी ते राहतस तो सर्व प्रदेश गोमाशीसना थवाघाई व्यापी टाकसु. ");
INSERT INTO ahr_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","पण गोशेन प्रांतमा मना लोकं राहतस तो मी त्या दिन अलग करसु, गोमाशीसना थवा तठे जावाव नही, यावरतीन पृथ्वीवर मीच परमेश्वर शे. हाई तुले समजी. ");
INSERT INTO ahr_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","मनी प्रजामा अनी तुनी प्रजामा मी अंतर ठेवसु, सकाय हावु चमत्कार व्हई.” ");
INSERT INTO ahr_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","तसच परमेश्वरनी करं, फारोना घरमा, त्याना सेवकसना घरमा अनं पुरा मिसर देशमा गोमाशीसना थवाना थवा वनात. गोमाशीसना या थवासमुये मिसर देशमा नुकसान व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","मंग फारोनी मोशे अनं अहरोन यासले बलाईसन सांगं की, “तुम्हीन जा, याच देशमा तुमना देवले यज्ञ करा.” ");
INSERT INTO ahr_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","मोशे बोलना, “हाई करनं चांगलं नही शे, कारण आम्हीन जो यज्ञ आमना देव यहोवा याले करावं शेतस त्यानी मिसरी लोकसले किळस ई, मिसरी लोकसना नजरमा किळसवाना असा यज्ञ आम्हीन करा तर त्या आमले दगडमार करावुत नही का? ");
INSERT INTO ahr_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","आम्हीन रानमा तीन दिननी वाट चाली जासुत अनी परमेश्वर आमना देव सांगी तसा आम्हीन त्याले यज्ञ करसु.” ");
INSERT INTO ahr_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फारो बोलना, “तुम्हीन रानमा जाईसन परमेश्वर तुमना देव याले यज्ञ कराकरता मी तुमले जाऊ देस, पण जास्त दूर जाऊ नका अनी मनाकरता प्रार्थना करा.” ");
INSERT INTO ahr_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मोशे बोलना, “मी लगेच जास, अनी परमेश्वरले प्रार्थना करस की, फारो अनं त्याना सेवक अनी त्याना लोके यासनावरला गोमाशीसना थवा सकाय निंघी जावोत, पण परमेश्वरले यज्ञ कराकरता लोकसले जाऊ न देवाना फारोनी परत ईचार करू नये.” ");
INSERT INTO ahr_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","मंग मोशे फारोकडतीन निंघी गया अनी देवले प्रार्थना करी. ");
INSERT INTO ahr_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","परमेश्वरनी मोशेनी प्रार्थनाप्रमाणे करं, फारो त्याना सेवक अनी त्याना लोके यासवर येल गोमाशीसना थवा त्यानी दूर करात, एक बी गोमाशी राहिनी नही. ");
INSERT INTO ahr_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","पण फारोनी या येळले बी आपलं मन कठिण करं अनी लोकसले जाऊ दिध नही. ");
INSERT INTO ahr_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","मंग परमेश्वर मोशेले बोलना, “फारोले जाईसन सांग, ‘इब्रीसना देव परमेश्वर अस सांगस की, मना लोकसनी मनी उपासना कराले पाहिजे म्हणीसन त्यासले जाऊ दे. ");
INSERT INTO ahr_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","जर तु त्यासले जाऊ देवाव नही अनी आखो अडाईन ठेवशी, ");
INSERT INTO ahr_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","तर दख, घोडा, गधडा, उंट, गुरंढोरं, शेळ्यामेंढ्या ह्या ज्या तुना पशु रानमा शेतस त्यासनावर परमेश्वरना हात पडी, अनी भयंकर मरी ई. ");
INSERT INTO ahr_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","इस्त्राएल लोकसना गुरंढोरं अनी मिसरी लोकसना गुरंढोरं यासले मी अलग अलग करसु. इस्त्राएल लोकसना एक बी पशु मराव नही. ");
INSERT INTO ahr_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","मंग परमेश्वरनी येळ ठराई अनी सांगं की, सकाळ मी परमेश्वर हाऊ मिसर देशमा हाई काम करसु.’” ");
INSERT INTO ahr_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","दुसरा दिन परमेश्वरनी हाई गोष्ट करी अनी मिसर देशमा सर्वा गुरं मरणात. पण इस्त्राएल लोकसना गुरंसपैकी एक बी मरनं नही. ");
INSERT INTO ahr_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फारोनी माणसे धाडीसन दखं तर इस्त्राएल लोकसना गुरंसपैकी एक बी मरनं नही. तरी बी फारोनं मन कठिणच राहिनं, त्यानी लोकसले जाऊ दिध नही. ");
INSERT INTO ahr_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","“मंग परमेश्वर मोशे अनं अहरोनले बोलना की, मोशेनी भट्टीमातील मुठभर राख लिसन फारोना समोर आकाशमा उधळानी. ");
INSERT INTO ahr_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","म्हणजे ती राखना कण पुरा मिसर देशमा पसरी अनी सर्व देशमातील लोकसले अनं जनावरसले गळवा अनं फोड व्हतीन.” ");
INSERT INTO ahr_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","त्या भट्टीमातील मुठ्ठीभर राख लिसन फारोनापुढे उभा राहिनात; मोशेनी ती आकाशकडे हवामा उधळी तवय त्यामुये लोकसले अनं जनावरसले फोड वनात. ");
INSERT INTO ahr_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","गळवामुये जादुगरसले मोशेना पुढे उभं राहता ई नही राहिंतं, कारण सर्व मिसरी लोकेसले अनी जादुगर यासले बी गळवा येल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","पण परमेश्वरनी फारोनं मनले अजून कठीण करं अनी त्यानी त्यासनं ऐकं नही, परमेश्वरनी मोशे अनं अहरोनले अस सांगेलच व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","परत परमेश्वर मोशेले बोलना, “पहाटले उठीसन फारोपुढे उभा ऱ्हाय अनी त्याले सांग, ‘इब्रीसना देव परमेश्वर अस म्हणस की, मना लोकसनी मनी उपासना कराकरता त्यासले जाऊ दे. ");
INSERT INTO ahr_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","नहीतर या खेपले मी सर्वाप्रकारनी पिढा तुनावर, तुना सेवकसवर अनं तुनी प्रजावर धाडसु, म्हणजे पुरी पृथ्वीवर मनामायक कोणीच नही हाई तुले यावरतीन समजी. ");
INSERT INTO ahr_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","आतेपावत मी मना हात उगारीसन तुनावर अनी तुनी प्रजावर मरीना प्रहार करतु अनी जगमातीन तुना पुरा नाश करी टाकतु. ");
INSERT INTO ahr_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","पण तुले मनं सामर्थ्य दखाडानं अनी मनं नाव सर्व पृथ्वीवर पसरावं यानाकरता मी तुले जिवत ठेयल शे. ");
INSERT INTO ahr_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","तु आते बी मना लोकससंगे गमंडीनामायक वागीसन त्यासले जावु दि नही राहिना का? ");
INSERT INTO ahr_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","सकाळ याच येळले मी गारासना अशा भयंकर पाऊस पाडसु ना, जसा मिसर देशनी स्थापना व्हयनी तवयपाईन ते आजपावत असा पाऊस व्हयना नही व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","तर आते रानमा तुना लोकसले धाडीसन गुरं अनी दुसरी जे काही व्हई ते लई ये. ज्या माणसे अनी गुरं रानमा सापडतीन त्यासनावर गारासनी झोड पडीसन त्या मरतीन.” ");
INSERT INTO ahr_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","यामुये फारोना काही सेवकसपैकी ज्यासले परमेश्वरनी सांगेल गोष्टनी भिती वाटनी त्यासनी रानमातीन आपला दास अनं गुरंसले घर आणं. ");
INSERT INTO ahr_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","अनी ज्यासनी परमेश्वरना सांगाकडे ध्यान दिधं नही त्यासनी आपला दास अनं गुरं यासले रानमाच राहू दिधं. ");
INSERT INTO ahr_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","मंग परमेश्वर मोशेले बोलना, “तु आपला हात आकाशकडे कर म्हणजे सर्व मिसर देशमा गारासना पाऊस पडी. सर्व देशमातील जनावरसवर अनी वावरमातील पिकसवर सर्वा निळागार झाडझुडपसमा तो पडी.” ");
INSERT INTO ahr_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","मोशेनी आपली काठी आकाशकडे वर करी तवय परमेश्वरनी ढगसना कडकडाट अनी गारासना पाऊस पाडा अनी ईजा तर जमिनपावत ई राहिंत्यात, असा परमेश्वरनी मिसर देशवर गारासना पाऊस पाडा. ");
INSERT INTO ahr_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","गारा पडी राहिंतात अनी मजारमां ईजा बी चमकी राहिंतात. हावु गारासना पाऊस ईतला भयंकर व्हता की असा पाऊस मिसर देशनी स्थापना व्हयनी तवय पाईन कुठेच व्हयेल नव्हता. ");
INSERT INTO ahr_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","यामुये सर्व मिसर देशमा, माणसं, गुरंढोरं अनी जे काही जंगलमा व्हतं त्या सर्वावर गारासना मारा व्हयना. वावरमातील सर्व पिक अनं झाडे तुटीन पडी गयात. ");
INSERT INTO ahr_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","पण गोशेन प्रांतमा इस्त्राएल लोकं राही राहिंतात तठे मात्र गारासना पाऊस पडना नही. ");
INSERT INTO ahr_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","तवय फारो राजानी मोशे अनी अहरोन यासले बलाईसन सांगं, “मी या खेपले पाप करेल शे, परमेश्वर न्यायी शे, मी अनी मनी प्रजा अपराधी शेतस. ");
INSERT INTO ahr_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","तुम्हीन परमेश्वरले ईनंती करा, हाई इतली कडकडात अनं गारासना पाऊस पडना हाईच पुरं शे, मी तुमले जाऊ देस, तुम्हीन आखो आठे जास्त येळ राहू नका.” ");
INSERT INTO ahr_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मोशे बोलना, “मी शहरना बाहेर गवु का परमेश्वरकडे मना हात पसारसु तवय मेघगर्जना बंद व्हई अनी गारा पडनार नहीत; यावरतीन तुले समजी की, पृथ्वी परमेश्वरनी शे. ");
INSERT INTO ahr_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","पण माले हाई माहित शे की अजून बी तु अनी तुना सेवक परमेश्वरले भ्यातस नही.” ");
INSERT INTO ahr_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ती येळले जवस अनी सातू यासना नाश व्हयना, तवय तु सातू निवाडेल व्हतात अनी जवसले बोंडा येल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","पण गहू अनी काठ्यागहू यासना नाश व्हयना नही, कारण त्या आजुनपावत वाढेल नव्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","मोशे फारोना पुढेतीन निंघीसन शहरना बाहेर गया अनी परमेश्वरकडे त्यानी हात पसारात तवय मेघगर्जना अनं गारा बंद व्हयन्यात अनी पाऊस पडनं थांबनं. ");
INSERT INTO ahr_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","पाऊस, गारा अनं कडकडात बंद व्हयनी अस दखीसन फारोनी अनी त्याना सेवकसनी आपलं मन कठीण करीसन परत पाप करं. ");
INSERT INTO ahr_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","अनी त्यानी इस्त्राएल लोकसले जाऊ दिध नही, परमेश्वरनी मोशेना व्दारा हाई सांगेलच व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","मंग परमेश्वर मोशेले बोलना, “फारोनापुढे जाय, मीच त्यानं अनी त्याना सेवकसनं मन कठीण करेल शे ते यानाकरता की त्यासना मी ह्या चिन्ह चमत्कार दखाडावं. ");
INSERT INTO ahr_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","मी मिसर देशनी कशी फजिती करी अनी त्यासनामा कायकाय चिन्ह चमत्कार करात हाई तुना पोऱ्या अनी नातुसना कानवर पडू दे, म्हणजे मी परमेश्वर शे हाई तुमले समजी.” ");
INSERT INTO ahr_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","मोशे अनी अहरोन फारोनापुडे जाईसन त्याले बोलनात, “इब्रीसना देव यहोवा अस म्हणस, ‘तु मनासमोर कवयपावत झुकाव नही? मना लोकसले मनी उपासना कराले जाऊ दे. ");
INSERT INTO ahr_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","तु जर मना लोकसले जाऊ देवाव नही तर दख, मी सकाळ तुना देशमा टोळ आणसु. ");
INSERT INTO ahr_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","त्या जमिनले अस झाकी टाकतीन की, जमिन दखावणार नही, गारासना पाऊसपाईन जे काही वाचेल व्हई त्याना त्या नाश करतीन, जंगलमा तुमना जितला झाडे लायेल शेतस त्याना बी त्या नाश करतीन. ");
INSERT INTO ahr_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","तुना घरं, तुना सेवकसना घरं, सर्वा मिसरीसना घरसले त्या भरी टाकतीन. इतला टोळ तुना बापदादानी किंवा त्यासना बापदादासनी आजपावत कधी जन्ममा दखेल नही व्हतीन.’” मंग मोशे तठेन फिरना अनं निंघी गया. ");
INSERT INTO ahr_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","फारोना सेवक त्याले बोलनात, “आम्हीन कोठपावत या माणुसना तरासमा राहसुत? त्यासना देव यहोवा यानी उपासना कराले त्या लोकसले जाऊ द्या, मिसर देश उध्वस्त व्हयेल शे, हाई तुमले का बरं समजी नही राहीनं.” ");
INSERT INTO ahr_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","मंग मोशे अनी अहरोन यासले परत राजाकडे बलाई आणं, तो त्यासले बोलना, “तुम्हीन तुमना देव यहोवा यानी उपासना करा, पण कोण कोण जावाव शे?” ");
INSERT INTO ahr_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मोशे बोलना, “आमना धल्ला लोकं, आमना पोऱ्या अनं पोरी, आमना शेरडंमेंढरं अनं गुरंढोरं या सर्वासले आम्हीन लई जाणार शेतस, कारण परमेश्वर करता आमले उत्सव करना शे.” ");
INSERT INTO ahr_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","राजा त्यासले बोलना, “मी तुमले जर तुमना लेकरंबाळस संगे जाऊ दिधं तर देव तुमनं भल करो, सावधान, तुमना मनमा खोट शे, ");
INSERT INTO ahr_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","हाई व्हवाव नही, फक्त माणससनीच जाईसन परमेश्वरनी उपासना करानी, कारण हाईच तर तुमले पाहीजे व्हतं.” मंग मोशे अनं अहरोन यासले फारोना पुढेतीन हाकली दिधं. ");
INSERT INTO ahr_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","परमेश्वर मोशेले बोलना, “मिसर देशवर आपला हात उगार म्हणजे त्यासनावर टोळ ईसन गारासना सपाटामातीन ज्या वनस्पती वाचेल शेतस त्या त्यासना नाश करतीन.” ");
INSERT INTO ahr_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","मोशेनी मिसर देशवर आपली काठी उगारी, तवय परमेश्वरनी दिवसभर अनं रात्रभर पुर्व दिशातीन वारा सोडा अनी सकाळ व्हयनी तवय त्या वारासंगे टोळ बी वनात. ");
INSERT INTO ahr_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","सर्व मिसर देशवर टोळसनी धाड टाकी अनी त्या सर्वीकडे उतरनात. त्या बराच व्हतात, ऐवढा टोळ कधी येल नव्हतात अनी कधीच येवाव नही. ");
INSERT INTO ahr_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","त्यासनी सर्वी जमिनले झाकी टाकं त्यामुये सर्वीकडे अंधार पडना अनी त्यासनी जमिनवरला सर्वा झाडे अनी ज्या फळ गारासमातीन वाचेल व्हतात त्या सर्वा खाई टाकात, पुरा मिसर देशमा झाडसपैकी किंवा वावरमातील एक बी हिरवं अस काही उरनं नही. ");
INSERT INTO ahr_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","मंग राजानी लवकरच मोशे अनं अहरोन यासले बलाईसन सांगं, “मी तुमना देव यहोवा यानाविरूध्द अनं तुमनाविरूध्द पाप करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","तर आते एकदाव मना अपराधसनी क्षमा करा अनी ऐवढीदाव मृत्यूपाईन माले वाचाडा म्हणुन तुम्हीन आपला देव यहोवा यानाकडे प्रार्थना करा.” ");
INSERT INTO ahr_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","मोशेनी फारोकडतीन निंघी गया अनी देवकडे प्रार्थना करी. ");
INSERT INTO ahr_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","तवय देवनी पश्चिम दिशातीन प्रचंड वारा सोडा, त्यानी त्या टोळसले उडाईसन तांबडा समुद्रमा टाकं, मिसर देशनी हद्दमा एक बी टोळ राहिना नही. ");
INSERT INTO ahr_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","पण परमेश्वरनी फारोनं मन कठीण करं अनी त्यानी इस्त्राएल लोकसले जाऊ दिध नही. ");
INSERT INTO ahr_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","मंग परमेश्वरनी मोशेले सांगं, “आकाशकडे आपला हात उगार म्हणजे मिसर देशवर आंधार पडी अनी तो सर्वी जमिनले झाकी टाकी.” ");
INSERT INTO ahr_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","तवय मोशेनी आपला हात आकाशकडे करा अनी तिन दिनपावत सर्वा मिसर देशवर काळाकुट्ट आंधार पडना. ");
INSERT INTO ahr_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","तीन दिन कोणीच कोणले दखायना नही की कोणीच आपली जागा सोडीन हालना नही, पण इस्त्राएल लोकसनी वस्तीमा उजेड व्हता. ");
INSERT INTO ahr_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","मंग राजानी मोशेले बलाईसन सांगं, “तुम्हीन जाईसन तुमना परमेश्वरनी उपासना करा, पण शेरडंमेंढरसले अनी गुरंढोरसले आठेच राहू द्या, तुमना लेकरंबाळसले लई जा.” ");
INSERT INTO ahr_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मोशेनी उत्तर दिधं, “आमना देव यहोवाकरता यज्ञपशु अनं होमबली तु आमना हवाली कराले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","आमना जनावरं बी आमनासंगे जावाले पाहीजे, एक बी ऱ्हावाले नको, कारण यामातीनच आमले आमना देव यहोवानी उपासना कराकरता यज्ञपशु लेना पडतीन अनी परमेश्वरनी उपासनाकरता काय लागी हाई आमले तठे पोहचाशिवाय समजाव नही.” ");
INSERT INTO ahr_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","परमेश्वरनी राजानं मन कठीण करं अनी त्यानी त्यासले जाऊ दिधं नही. ");
INSERT INTO ahr_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","फारो त्याले बोलना, “मनापुढेतीन चालता व्हयं, अनी संभाय परत फिरीन तुनं तोंड दखाडू नको, ज्या दिन तु तुनं तोंड माले दखाडं त्या दिन तु मरणाच!” ");
INSERT INTO ahr_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मोशे बोलना, “तु बरोबर बोलना, मी परत तुनं तोंड कधी दखावं नही.” ");
INSERT INTO ahr_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","मंग परमेश्वर मोशेले बोलना, “मी राजावर अनं मिसर देशवर आखो एक पिढा लयसु, तवय तो तुमले तठेन जाऊ दि. अनी तो तुमले जाऊ दि तवय तुमले हाकली दि. ");
INSERT INTO ahr_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","तु तुना लोकसले सांगी ठेव की, प्रत्येक माणुसनी आपला शेजारनाकडतीन अनी प्रत्येक बाईनी आपली शेजारीनकडतीन सोनं चांदिना दागिना मांगी लेवानं.” ");
INSERT INTO ahr_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","मिसरी लोकसनी इस्त्राएल लोकसवर कृपादृष्टी व्हई अस परमेश्वरनी करं अनं त्यामाच मिसर देशना राजाना सेवक अनी सामान्य लोकं यासना नजरमा मोशे हावु थोर माणुस व्हता. ");
INSERT INTO ahr_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","मंग मोशे राजाले बोलना, “परमेश्वर म्हणस, ‘मी आज मध्यरातनी येळले मिसर देशमा फिरसु, ");
INSERT INTO ahr_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","तवय प्रत्येक थोरला पोऱ्या मरी राजापाईन ते जातावर दळनारी दासीपावत सर्वासना थोरला पोऱ्या अनी गुरसनं पहेलं पिल्लु मरतीन. ");
INSERT INTO ahr_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","मिसर देशमा मोठा हाहाकार व्हई, असा की पहेले कधी व्हयेल नव्हता अनी कधी व्हवाव नही. ");
INSERT INTO ahr_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","पण इस्त्राएल लोकसवर काय त्यासना गुरंसवर बी एक कुत्रा बी भुकाव नही. यावतीन मिसरी लोकसमा अनी इस्त्राएल लोकसमा मी कशा भेद ठेवस हाई तुमले समजी.’” ");
INSERT INTO ahr_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","मोशे आखो बोलना, “तवय या तुना सेवक मनाकडे ईसन माले नमन करीसन म्हणतीन की, आपला परिवारससंगे आपण निंघी जा, तवय मी निंघी जासु.” यावरतीन मोशे संतापमा फारोनापुढेतीन निंघी गया. ");
INSERT INTO ahr_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","परमेश्वर मोशेले बोलना व्हता की, “फारो तुमनं ऐकावं नही, कारण मिसर देशमा मना बराच चमत्कार व्हवाले पाहिजे अशी मनी इच्छा शे.” ");
INSERT INTO ahr_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मोशे अनी अहरोन यासनी फारोपुढे या सर्वा चमत्कार करात तरी परमेश्वरनी फारोनं मन कठीण करं अनी त्यानी इस्त्राएल लोकसले देशमातीन जाऊ दिधं नही. ");
INSERT INTO ahr_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","मंग परमेश्वरनी मिसर देशमा मोशे अनी अहरोनले सांगं की, ");
INSERT INTO ahr_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","हावु महिना तुमना वरीसना पहिला महिना व्हवाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इस्त्राएलना सर्व मंडळीसले सांगा की, या महिनाना दहावा दिन तुम्हीन आपआपला घराणाप्रमाणे एक एक घराणाकरता एक एक कोकरू लेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","अनी एक कोकरू सरनार नही इतला लोकं जर घरमा व्हतीन तर त्यानी शेजारीसना घरमा कितला शेतस अनी आपला कितला याना हिशोब करीसन कोकरू लेवानं अनी एक कोकरू कितला लोकसले खावाले पुरी याना हिशोब करी लेवाना. ");
INSERT INTO ahr_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","कोकरू लिधं तर तो निर्दोष ऱ्हावाले पाहिजे, हावु नर तुम्हीन मेंढरं किंवा बोकडंमाईन तुमले पटी त्यामातीन लेवु शकतस. ");
INSERT INTO ahr_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","या महिनाना चौदा तारीख पावत ते संभाळीन ठेवानं अनी त्या संध्याकायले इस्त्राएल लोकसनी त्याले मारानं. ");
INSERT INTO ahr_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","त्यानं रक्त लिसन ज्या घरमा त्या कोकरुले खाणार शेतस त्या घरनी चौकटले आजुबाजू अनं वरना बाजूले ते रक्त लावानं. ");
INSERT INTO ahr_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","अनी त्यासनी त्याच रातले ते मांस ईस्तववर भाजीसन ते बेखमीर भाकरसंगे अनी कडू भाजीसंगे खावानं. ");
INSERT INTO ahr_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","मांस कच्च खावानं नही अनं शिजाडीसन बी खावानं नही, तर ते ईस्तववर भाजीसन खावानं, त्यानी मुंडी, पाय, आतडी हाई बी खावानं. ");
INSERT INTO ahr_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","त्यामातील सकाळपावत काहीच उरू देवानं नही अनी सकाळपावत काय राहिनं तर ते आगमा टाकीसन जाळी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","त्याले तुम्हीन अस खावानं, कबंर कशीसन, पायमा जोडा घालीसन अनी हातमा काठी लिसन ते घाईघाईमा खावानं, हावु परमेश्वरना वल्हांडण सण शे. ");
INSERT INTO ahr_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“कारण हाई रातले मी मिसर देशमा फिरीसन त्यामातील मनुष्य अनं पशु या सर्वासना पहिला जन्मेलले मी मारी टाकसु अनी मिसरना सर्व देवसले मी शिक्षा करसु. मी यहोवा शे. ");
INSERT INTO ahr_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","अनी ज्या घरमा तुम्हीन राहाशात त्यावर लागेल ते रक्त तुमनाकरता खूण व्हई. मी जवय रक्त दखसु तवय तुमले वलांडीन जासु, मिसर देशना लोकसले मी मारसु तवय तुमनावर अनर्थ येवाव नही, तुमना नाश व्हवाव नही. ");
INSERT INTO ahr_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","हावु दिन तुमले कायम ध्यानमा राही, या दिनले तुम्हीन परमेश्वर करता मेळा भराईसन सण पाळना; पिढ्यानंपिढ्या म्हणजे कायमनी विधी समजीसन हावु सण तुम्ही पाळाना.” ");
INSERT INTO ahr_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","आखो परमेश्वर बोलना, “सात दिनपावत तुम्हीन खमीरनी भाकर खावानी नही, पहिलाच दिन तुमना घरमातीन सर्व खमीर काढी टाकानं, पहिला दिनपाईन सातवा दिनपावत जो कोणी खमीरनी भाकर खाई त्याले इस्त्राएलमातीन काढी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","पहिला दिन तुमना पवित्र मेळा भराना तसाच सातवा दिन बी पवित्र मेळा भराना, या दोन दिन काहीच काम करानं नही फक्त जेवनखावन करता जे करनं पडस तेच करानं. ");
INSERT INTO ahr_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","अशा तुम्हीन बेखमीर भाकरना सण पाळानं कारण याच रोज मी तुमनी सैनाले मिसर देशमातीन बाहेर आनेल शे, तरी बी हावु दिन तुम्हीन पिढ्यानपिढ्या सण म्हणीसन पाळाना. ");
INSERT INTO ahr_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","पहिला महिनाना चौदावा दिननी संध्याकायपाईन ते त्या महिनाना एकविसवा दिननी संध्याकायपावत तुम्हीन बेखमीरघाई बनाडेल भाकरी खावान्या. ");
INSERT INTO ahr_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","सात दिनपावत तुमना घरमा अजिबात खमिर ऱ्हावाले नको, कारण जो कोणी एखादी खमीरघाई बनाडेल एक बी वस्तु खाई, तो परदेशी ऱ्हावो की स्वदेशी, त्याले इस्त्राएल लोकसनी मंडळीमातीन कायमनं काढी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","तुम्हीन कोणता बी खमीरना पदार्थ खाऊ नका, तुम्हीन घरोघर बिगर खमीरन्या भाकरी खावान्या.” ");
INSERT INTO ahr_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","मंग मोशेनी सर्वा इस्त्राएलना वडील मंडळीले बलाईसन सांगं, “तुम्हीन आप आपला घरानाप्रमाणे एक एक कोकरू निवाडी लेवानं अनी वल्हांडणना यज्ञ कराना, असा तुमना परिवार वल्हांडण सण साजरा करू शकतस. ");
INSERT INTO ahr_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","नंतर एजोब झाडनी एक जुडी लिसन ती भांडामातील रक्तमा बुचकाडानी अनी तीनाघाई ते रक्त दरवाजानी चौकटले वर अनं आजुबाजू लावानं अनी सकाळपावत कोणी बी घरना बाहेर जावानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","कारण परमेश्वर मिसरीसना वध कराकरता बाहेर फिराव शे, ज्या ज्या घरना चौकटले वर अनं आजुबाजू रक्त लागेल परमेश्वर दखी तर ते दार तो वलांडीसन जाई अनी वध करणाराले वध कराकरता तुमना घरमा जाऊ देवाव नही. ");
INSERT INTO ahr_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","हाई आज्ञा तुम्हीन अनी तुमना लेकरसले कायमनी शे. ");
INSERT INTO ahr_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","वचन देयेलप्रमानं देश परमेश्वर तुमले दि, तठे तुम्हीन जाशात तवय हाई उपासना करानी पध्दत तुम्हीन पाळानी. ");
INSERT INTO ahr_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","तुमना लेकरंबाळ तुमले ईचारतीन की, ‘या उपासनाना अर्थ काय?’ ");
INSERT INTO ahr_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तवय तुम्हीन सांगा कि, हावु परमेश्वरना वल्हांडणना यज्ञ शे, त्यानी मिसरी लोकसले मारं अनी आपला घरसना बचाव करा ती येळले तो इस्त्राएल लोकसना घरं वलांडीन गया.” हाई ऐकीसन लोकसनी गुडघावर ईसन उपासना करी. ");
INSERT INTO ahr_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","तवय इस्त्राएल लोकसनी तसच करं जस देवनी मोशे अनी अहरोनले आज्ञा करी व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","मध्यरातमा अस व्हयनं की मिसर देशना सिंहासनवर बठेल राजाना थोरला पोऱ्यापाईन ते कैदखानामा पडेल कैदीसना थोरला पोऱ्यापावत सर्वा अनी गुरंढोरसपैकी सर्वा पहिला जन्मेल देवनी मारी टाकात. ");
INSERT INTO ahr_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","रातले राजा, त्याना सर्व सेवक अनी सर्वा मिसरी लोकं जागा व्हयनात अनी मिसर देशमा मोठा हाहाकार उडना, कारण ज्यामा कोणी मरना नही अस एक बी घर राहिनं नही. ");
INSERT INTO ahr_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","तवय फारोनी रातमाच मोशे अनं अहरोनले बलाईसन सांगं, “तुम्हीन अनं सर्वा इस्त्राएल लोकं मना लोकसमातीन निंघी जा, तुम्हीन म्हणतस तशी परमेश्वरनी उपासना करा. ");
INSERT INTO ahr_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","तुम्हीन म्हणतस तस सर्व गुरंढोरं अनं शेरड्यामेंढ्या लिसन चालता व्हा अनी माले बी आशिर्वाद द्या.” ");
INSERT INTO ahr_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","इस्त्राएल लोकसनी लगेच निंघी जावाले पाहीजे म्हणीसन मिसरी लोकं बोलु लागनात; त्या बोलनात, “तुम्हीन जर गयात नही तर आम्हीन मरसुत.” ");
INSERT INTO ahr_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","इस्त्राएल लोकसनी मळेल पिठ खमीर न घालता तशीच ताठवाटीसंगेच गासोडामा बांधीसन खांदावर आवरी लिधं. ");
INSERT INTO ahr_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","मोशेनी सांगेलप्रमाणे इस्त्राएल लोकसनी करं; त्यासनी मिसरी लोकसपाईन सोनाचांदिना दागीना अनं कपडा मांगी लिधात. ");
INSERT INTO ahr_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","इस्त्राएल लोकसवर मिसरी लोकसनी कृपादृष्टी व्हावी अस परमेश्‍वरनी करं, म्हणीसन इस्त्राएल लोकसनी जे जे मांग ते मिसरी लोकसनी दि टाकं. अस त्यासनी मिसरी लोकसले लुटं. ");
INSERT INTO ahr_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","मंग इस्त्राएल लोकं रामसेस आठेन निंघीसन सुक्कोथ आठे गयात. त्या जवळजवळ पायी चालणारा सहा लाख माणसेच व्हतात बाया अनी लेकरसनी तर मोजनी नव्हती. ");
INSERT INTO ahr_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","त्यासनासंगे दुसरा लोकसना बी मोठा समुदाय गया; तसच शेरड्यामेंढ्या, गुरंढोरं वगैरे असा बराच जनावरं बी गयात. ");
INSERT INTO ahr_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","त्यासनी आपलासंगे मिसर देशमा मळेल पिठ आणेल व्हतं. त्यानं त्यासनी बेखमीर भाकरी भाज्यात, तिमा काय खमीर नव्हतं, मिसर देशमातीन त्यासले बळजबरी बाहेर काढेल व्हतं, त्यामुये त्यासले खावाकरता बनाडाले येळ नव्हती म्हणीसन त्यासले काय बनाडता वनं नही. ");
INSERT INTO ahr_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इस्त्राएल लोकं मिसर देशमा ईसन ऱ्हावाले चारशे तीस वरीस व्हयेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","चारशे तीस वरीसना बरोबर त्याच दिनले परमेश्वरनी सर्व सेना मिसर देशमातीन बाहेर पडनी. ");
INSERT INTO ahr_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","परमेश्वरनी त्यासले मिसर देशमातीन बाहेर काढं यानाकरता बी परमेश्वरकरता जागरणनी रात म्हणीसन अवश्य पाळानी; इस्त्राएल लोकसनी पिढ्यानपिढ्या हाई रात जागरणनी रात म्हणीसन अवश्य पाळी. ");
INSERT INTO ahr_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","परमेश्वर मोशे अनं अहरोन यासले बोलना, “वल्हांडण सणना विधी असा: कोणी विदेशीनी वल्हांडणनं बनाडेल जेवण खावानं नही, ");
INSERT INTO ahr_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","पण जर कोणी पैसा दिसन एखादा दास ईकत लिधा अनी त्यानी सुंता व्हयनी व्हई तर तो त्यामातील खाऊ शकस. ");
INSERT INTO ahr_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","घर येल पाहुणा किंवा नौकर यासनापैकी कोणीच ते खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","हाई जेवण एकच घरमा व्हवाले पाहिजे त्या मांसमातील काहीच घरना बाहेर लई जावानं नही अनी यज्ञ करेल पशुनं एकबी हाडूक मोडानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","इस्त्राएलना सर्व मंडळीसनी हावु विधी पाळाना. ");
INSERT INTO ahr_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","कोणी परदेशी तुमनासंगे राही राहीना अनी त्याले वल्हांडण सण पाळानी इच्छा व्हई तर त्याना घरना सर्व माणससनी सुंता व्हवाले पाहीजे मंग त्याले जोडे करीसन वल्हांडण सण पाळु देवाना अनी आपला लोकसनामायकच त्याले समजानं; पण बेसुंता माणुसनी ते खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","इस्त्राएलमा जन्मेल अनी तुमनामा राहनारा विदेशी यासले एकच नियम राही.” ");
INSERT INTO ahr_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","यानाप्रमाणे सर्व इस्त्राएल लोकसनी करं, परमेश्वरनी मोशे अनं अहरोनले आज्ञा करेल प्रमाने त्यासनी करं. ");
INSERT INTO ahr_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","त्याच रोज परमेश्वरनी इस्त्राएल लोकसले टोळीटोळीतीन मिसर देशमातीन बाहेर काढं. ");
INSERT INTO ahr_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","मंग परमेश्वरनी मोशेले सांगं की, ");
INSERT INTO ahr_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“इस्त्राएल लोकसमा मनुष्य अनं पशु यामातील जे पहिलं जन्मेल त्यासले मनाकरता पवित्र म्हणीसन येगळं ठेव, त्या मना शेतस.” ");
INSERT INTO ahr_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","मोशे इस्त्राएल लोकसले बोलना, “या दिननं स्मरण ठेवा; याच दिन तुम्हीन मिसर देशमातीन, गुलामगिरीतीन बाहेर निंघनात, परमेश्वरनी आपला सामर्थी हातघाई तुमले ती जागावरतीन बाहेर काढं म्हणीसन या दिन खमीरनी भाकर खावानी नही. ");
INSERT INTO ahr_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","तुम्हीन अबीब महिनाना या दिनले निंघेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","कनानी, हित्ती, अमोरी, हिव्वी, अनी यबूसी यासना देशमा तुना पुर्वजले परमेश्वरनी प्रतिज्ञा करीसन देयल दुधमधना प्रवाह वाही राहिनात असा देशमा तुले आणावर या महिनामा तु हावु सण पाळाना. ");
INSERT INTO ahr_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","सात दिन बेखमीरन्या भाकरी खावान्या अनी सातवा दिनले परमेश्वरकरता सण कराना. ");
INSERT INTO ahr_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","या सात दिनसमा बेखमीर भाकर खावानी, खमीरनी भाकर तुना जोडेबी दिसाले नको, तुना पुरा देशमा खमीरनं दर्शन सुध्दा व्हवाले नको. ");
INSERT INTO ahr_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","जवयबी तु हावु सण करश्यात, तवय तुना लेकरंसले हाई सांग की, मी मिसर देशमातीन निंघनु तवय परमेश्वरनी मनाकरता जे काही कर त्यानाकरता मी हावु सण करस. ");
INSERT INTO ahr_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","हाई चिन्ह तुना हातवर, तुना दोन्ही डोयासना मझार आठवण म्हणीसन ऱ्हावाले पाहीजे; परमेश्वरना नियम तुना तोंडमा ऱ्हावाले पाहीजे कारण की परमेश्वरनी त्याना बलवान हातसघाई तुले मिसर देशमातीन बाहेर काढेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","म्हणीसन तु प्रत्येक वरीसले नेमी ठेयल येळले हावु सण पाळाना. ");
INSERT INTO ahr_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“परमेश्वरनी तुले अनं तुना पर्वजसले कनानीसना जो देश प्रतिज्ञा करीसन देयल शे तठे तुले लई जाईसन तुना हातमा सोपी दि. ");
INSERT INTO ahr_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तवय पहिला जन्मेल पोऱ्या अनी जनावरसना पहिला जन्मेल पिल्लू यासले परमेश्वरकरता येगळं करानं; या सर्वा नर परमेश्वरना शेतस ");
INSERT INTO ahr_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","गधडानं पहिलं पिल्लू एक कोकरू दिसन सोडाई लेवानं; त्याना मोबदला जर काही नही दिधा तर त्यानी मान मुरगळी टाकानी. तुना वंशमातील प्रथम नर मोबदला दिसन सोडाई लेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","पुढला काळमा तुना पोऱ्या तुले ईचारी की हाई काय शे, तु त्याले उत्तर देवानं, ‘मिसर देशमातीन, गुलामगिरी मातीन परमेश्वरनी त्याना सामर्थ्य हाततीन आमले बाहेर काढं. ");
INSERT INTO ahr_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","अनी फारो आमले जाऊ दि नही राहिंता तवय परमेश्वरनी मिसर देशमा मनुष्य अनं पशु यासना पहिला जन्मेल सर्व नरसले मारी टाकं; म्हणीसन पहिला जन्मेलले मी परमेश्वरले बली अर्पण करस; पण मना सर्व थोरला पोऱ्यासले मोबदला दिसन मी सोडाई लेस. ");
INSERT INTO ahr_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","तुना हातवर अनी तुना डोयासना मध्यभागमा हाई आठवण चिन्ह म्हणीसन ऱ्हावं; कारण परमेश्वरनी आपला सामर्थी हातघाई आमले मिसर देशमातीन बाहेर काढी आणं.’” ");
INSERT INTO ahr_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","फारोनी लोकसले जाऊ दिधं तवय पलिष्टी लोकसना देशमातीन वाट जोडीनी व्हती तरीबी देवनी त्यासले ती वाटतीन जाऊ दिध नही, कारण युध्द करनं पडी यानी भितीतीन या लोकं परत मिसर देशमा जातीन अस परमेश्वरले वाटनं. ");
INSERT INTO ahr_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","म्हणीसन फेरा लिसन रानमातील वाटघाई त्यानी त्यासले तांबडा समुद्रकडे लई गया; इस्त्राएल लोकं मिसरमातीन सशस्त्र व्हईसन बाहेर निंघेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मोशेनी आपलासंगे योसेफन्या अस्थि लिध्यात, कारण योसेफनी इस्त्राएल लोकसकडतीन आणभाक करीसन त्यासले सांगं व्हतं की, देव खात्रीतीन तुमले भेट दि तवय तुम्हीन आपलासंगे मन्या अस्थि लई जा. ");
INSERT INTO ahr_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","मंग त्या सुक्कोथ आठेन रवाना व्हयनात अनी रानना हद्दवर एथाम आठे त्यासनी तळ ठोका. ");
INSERT INTO ahr_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","त्यासनी रातदिन चालाले पाहिजे म्हणीसन परमेश्वरनी दिनले त्यासले वाट दखाडाले मेघस्तंभ अनी रातले प्रकाश देवाकरता अग्नीस्तंभ असा त्यासनापुढे ठेवात अनी त्या त्यासनापुढे चालेत. ");
INSERT INTO ahr_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","दिवसले मेघस्तंभ अनी रातले अग्नीस्तंभ ह्या कधीच लोकसपाईन दूर व्हयनात नही. ");
INSERT INTO ahr_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","तवय परमेश्वर मोशेले बोलना, ");
INSERT INTO ahr_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्त्राएल लोकसले सांग की तुम्हीन फिरीसन मिग्दोल अनी लाल समुद्र यासनामातीन पीहहीरोथाना पुढे बालसफोन समोर तळ ठोका. ");
INSERT INTO ahr_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","मंग फारो राजा इस्त्राएल लोकसबद्दल म्हणी की, त्या देशमा गोंधळी जायेल शेतस, त्यासना जंगलमा कोंडमारा व्हई राहिना. ");
INSERT INTO ahr_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","मी फारोनं मनं कठीण करसु अनी तो त्यासना मांगे लागी, असा प्रकारे फारो अनं त्यानी सर्व सेनाना मी पराभव करीसन मना प्रताप प्रकट करसु अनी मी परमेश्वर शे हाई मिसरी लोकसले समजी.” तसं इस्त्राएल लोकसनी करं. ");
INSERT INTO ahr_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","इस्त्राएल लोकसनी पलायन करं हाई बातमी जवय फारो राजाले समजनी तवय फारोनं अनी त्याना सेवकसनं मन त्या लोकसकरता बदलनं अनं त्या बोलु लागनात, “इस्त्राएल लोकसले आपली गुलामगिरीमातीन सुटीन जाऊ दिधं हाई आपण काय करं!” ");
INSERT INTO ahr_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","तवय राजानी आपला रथ लिधा अनी सैनीकसले तयार करं. ");
INSERT INTO ahr_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","त्यानी सवूशे निवाडेल रथ अनं त्यावरला सरदारसले लिधं. ");
INSERT INTO ahr_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","परमेश्वरनी मिसरना राजानं मन कठीण करं अनी तो इस्त्राएल लोकसना मांगे लागना अनी इस्त्राएल लोकं तर धैर्यतीन चाली राहिंतात. ");
INSERT INTO ahr_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","मंग फारोना सर्व घोडा, रथ अनं रथस्वार यासनासंगे मिसरी सैनिकसनी त्यासना पाठलाग करीसन पीहहीरोथाना जोडे अनं बालसफोना समोर समुद्रना किनारले त्यासनी तळ ठोकेल व्हता तठे त्यासले गाठं. ");
INSERT INTO ahr_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","फारो जोडेच ई लागना तवय इस्त्राएल लोकसनी ध्यान दिसन दखं की, मिसरी लोकं आपला मांगेच ई राहिनात, हाई दखीसन त्यासले धडकी भरनी अनं त्या परमेश्वरना धावा करु लागनात. ");
INSERT INTO ahr_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","त्या मोशेले बोलनात, “मिसरमा का कबर नव्हत्या का म्हणीसन तु आमले आठे रानमा मराले लई वना? तु आमले मिसरमातीन बाहेर काय म्हणीसन काढी आणं! ");
INSERT INTO ahr_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","आम्हीन तुले मिसरमा बोलनु नव्हतुत का की, आम्हीन जठे शेतस तठेच बरा शेतस, आमले आमना मिसरी लोकसनी गुलामगिरी करत राहू दे; आठे रानमा मरापेक्षा तठे मिसरी लोकसनी गुलामगिरी करनं चांगलं व्हतं.” ");
INSERT INTO ahr_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मोशे लोकसले बोलना, “भिऊ नका, आपली जागावर उभा ऱ्हा अनी परमेश्वर आज तुमनं तारण करी ते दखा, कारण ज्या मिसरी लोकं तुम्हीन आज दखी राहिनात त्या परत कधीच तुमना नजरमा पडावुत नही. ");
INSERT INTO ahr_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","परमेश्वर तुमनाकरता लढी, तुम्हीन गप्पच ऱ्हा.” ");
INSERT INTO ahr_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","मंग परमेश्वर मोशेले बोलना, “मना धावा काय करत बठना? इस्त्राएल लोकसले सांग की पुढे चला. ");
INSERT INTO ahr_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","तु आपला काठी वर कर अनी आपला हात समुद्रवर उगारीन त्याले दुभाग म्हणजे इस्त्राएल लोकं भर समुद्रमातीन कोरडी जमिनवर चालतीन. ");
INSERT INTO ahr_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","अनी दखा मी स्वतः मिसरी लोकसनं मन कठिण करसु अनी त्या ह्यासना मांगे लागतीन अनी राजा फारो, त्यानी सर्व सेना, त्याना रथ अनं त्याना स्वार यासना पराभव करामुये मनी महिमा प्रकट व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","मी जवय त्यासना पराभव करसु तवय मिसरी लोकसले समजी की, मी परमेश्वर शे.” ");
INSERT INTO ahr_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","तवय जो देवना दूत इस्त्राएली सैनिकसना पुढे चाले तो मांगे ई लागना अनी मेघस्तंभ बी जो त्यासना पुढे चाले तो मांगे ई लागना. ");
INSERT INTO ahr_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","तो मिसरीसनी सैना अनं इस्त्राएलसनी सैना यासना मझार राहिना. त्या मेघनी मिसरीसवर अंधार करा अनं इस्त्राएल लोकसले प्रकाश दिधा, रातभर एक पक्षीले दुसरा पक्षीकडे जाता वन नही. ");
INSERT INTO ahr_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","मोशेनी आपला हात समुद्रवर उगारा अनी परमेश्वरनी रातभर पुर्व दिशातीन जोरदार वारा सोडीसन समुद्रले अस मांगे करं की पाणीना दोन भाग व्हईसन कोरडी जमिन तयार व्हयनी, ");
INSERT INTO ahr_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","इस्त्राएल लोकं कोरडी जमिनवरतीन चालू लागनात अनी त्यासनी उजवी अनी डावी बाजुले पाणी भितनामायक उभं राहिनं. ");
INSERT INTO ahr_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","तवय मिसरीसनी त्यासना पाठलाग करा अनी फारोना सर्व घोडा, रथ अनं स्वार त्यासना मांगे मांगे समुद्रमा गयात. ");
INSERT INTO ahr_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","तवय रातना शेवटना येळले परमेश्वरनी अग्नीस्तंभ अनी मेघस्तंभ यासनामातीन मिसरी सैन्यसले दखं अनी त्यासले फटका दिधा. ");
INSERT INTO ahr_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","त्यानी त्यासना रथसना चाकं काढीसन ते चालावाले कठिण करं, तवय मिसरी लोकं म्हणु लागनात, “आपण इस्त्राएलसपाईन पळी जाऊत, कारण परमेश्वर त्यासनाकडतीन मिसरीससंगे लढी राहिना!” ");
INSERT INTO ahr_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","परमेश्वर मोशेले बोलना, “आपला हात समुद्रवर उगार म्हणजे पाणी परत पहिलासारखं व्हईसन मिसरीसवर, त्यासना रथसवर अनं स्वारसवर ई.” ");
INSERT INTO ahr_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","मोशेनी आपला हात समुद्रवर उगारा तवय दिन उगताच समुद्र परत पहिलासारखा व्हवाले लागना हाई दखीसन मिसरी लोकं पळू लागनात, पण परमेश्वरनी त्यासले समुद्रमाच उलथाई पाडं. ");
INSERT INTO ahr_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","पाणी परत पहिलंसारखं व्हई गयं. रथ, घोडा अनी फारोनी सर्व सैना त्यामा बुडी गयात; त्यासनापैकी एक बी वाचनं नही. ");
INSERT INTO ahr_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","पण इस्त्राएल लोकं जमीनवरतीन चालत गयात पाणी त्यासनाकरता उजवीकडे अनं डावीकडे भितीसनामायक उभं व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","अस परमेश्वरनी त्या दिन इस्त्राएल लोकसले मिसरीसना हातमातीन सोडावं अनी मिसरी लोकं समुद्र किनारवर मरी पडेल हाई इस्त्राएल लोकसनी डोळासघाई दखं. ");
INSERT INTO ahr_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","परमेश्वरनी इस्त्राएल लोकसले आपला सामर्थ्यीशाली हात दखाडा हाई इस्त्राएल लोकसनी दखं, तवय त्यासनी परमेश्वरनं भय धरं अनी परमेश्वरावर अनी त्याना सेवक मोशे यानावर त्यासनी ईश्वास ठेवा. ");
INSERT INTO ahr_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","तवय मोशे अनी इस्त्राएल लोकसनी परमेश्वरकरता हाई गीत म्हणं: “मी परमेश्वर करता गीत म्हणसु, कारण तो महाप्रतापी ठरेल शे; घोडासले सवारीसंगे त्यानी समुद्रमा उलथाई देयल शे. ");
INSERT INTO ahr_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","परमेश्वर मनं बल अनी मनं गीत शे; मना देव हावुच, त्यानी मी स्तुती करसु, हावुच मना बापना देव शे, मी यानीच महिमा गासु. ");
INSERT INTO ahr_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","परमेश्वर शुरवीर शे; त्यानं नाव यहोवा शे. ");
INSERT INTO ahr_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","फारोना रथ अनी त्यानी सैनाले समुद्रमा फेकी दिधं; त्‍याना महारथ अनं सरदार लाल समुद्रमा बुडी गयात. ");
INSERT INTO ahr_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","खोल पाणीनी त्यासले झाकी लेयल शे; त्या दगडनामायक खोल तळले जायेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","हे परमेश्वर तुना उजवा हात सामर्थ्यतीन पराक्रमी व्हयेल शे. हे परमेश्वर तुना उजवा हात शत्रुसना भुसा करस. ");
INSERT INTO ahr_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","तुनासंगे लढाई करणारासले तु आपला महा प्रतापतीन उलथाई टाकस; तुना संताप व्हयना तर तु त्यासना भुसानामायक भस्म करी टाकस. ");
INSERT INTO ahr_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तुना नाकपुडसना फुंकीमुये जलना राशी बननात जलप्रवाह राशीनामायक उभा राहिनात, खोल पानी समुद्रना तळले जमी गया. ");
INSERT INTO ahr_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","शत्रु बोलना, ‘मी पाठलाग करसु, मी त्यासले गाठी लिसु, मी लुटेल वाटी लिसु; त्याघाई मना जीव तृप्त व्हई, मी तलवार उपशीसन आपला हातघाई त्यासना नाश करसु.’ ");
INSERT INTO ahr_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","तु फुंकिसन आपला वारा सोडा तवय समुद्रमा त्या गडप व्हयनात; त्या दडगनामायक पाणीमा बुडी गयात. ");
INSERT INTO ahr_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","हे परमेश्वर देवसमा तुनामायक दुसरा देव कोण शे? पवित्र्यमुये वैभवी स्तवनीय कृत्यसनी भयानक, अद्भुत चमत्कार करणारा असा जो तु त्या तुनामायक कोण शे? ");
INSERT INTO ahr_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","तु आपला उजवा हात उगारा, अनी पृथ्वीनी त्यासले गिळी टाकं. ");
INSERT INTO ahr_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","तु उध्दार करेल आपला लोकसले तु आपली सामर्थ्यातीन नेयल शे; आपला बलघाई तु त्यासले आपला पवित्र निवासकडे लई जाई राहिना शे. ");
INSERT INTO ahr_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","हाई ऐकीसन राष्ट्र घाबरी जायेल शेतस; पलेशेथ निवासी घाबरी जायेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","तवय अदोमना अधिपती हैराण व्हयनात; मवाबना शुरवीर थराथर कापी राहिनात, सर्व कनान निवासीसनी मनस्थिती खराब व्हयेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","भिती अनं दहशत त्यासले घेरेल शे. तुना पराक्रमी हातमुये त्या दगडनामायक गप्पच व्हतीन, हे परमेश्वर, तुना लोक पार निंघी गयात तोंवर, तु खरेदी करेल तुनी प्रजा पार निंघी गई तोपावत अस व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","तु त्यासले लई जासी, अनी तु निवाडेल देशमा आणीन ठेवशी; हे यहोवा तु आपलाकरता निवाडेल निवास्थान हाईच शे, हे प्रभु, तुना हातघाई बनाडेल तुनं पवित्र स्थान हाईच शे. ");
INSERT INTO ahr_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","परमेश्वर युगानयुग राज्य करी.” ");
INSERT INTO ahr_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","फारोना घोडा, रथ अनं स्वार समुद्रना तळमा जाईन पडनात अनी परमेश्वरनी सुमद्रनं पाणी त्यासनावर टाकं, पण इस्त्राएल लोकं समुद्रमातीन कोरडी जमिनवर चालीसन गयात, म्हणीसन त्यासनी हाई गीत म्हणेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","मंग अहरोननी बहिण मिर्याम संदेष्टी हिनी हातमा डफ लिधा अनी सर्व बाया तिना मांगे डफ लिसन नाचत चालु लागन्यात. ");
INSERT INTO ahr_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","अनी मिर्यामनी त्यासना गाणानं धृपद लिधं: “परमेश्वर करता गीत म्हणा, कारण तो महाप्रतापी ठरेल शे; घोडासले सवारीसंगे त्यानी समुद्रमा उलथाई देयल शे.” ");
INSERT INTO ahr_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","मंग मोशे इस्त्राएल लोकसले लाल समुद्रपाईन पुढे लई गया अनी त्या शूर नावना वैराण प्रदेशमा जाईन पोहचनात, त्यामातीन तिन दिन प्रवास करतांना त्यासले कुठेच पाणी भेटी नही राहिंतं. ");
INSERT INTO ahr_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","मंग त्या मारा नावनी एक जागावर वनात, तठलं पाणी भलतच कडू व्हतं म्हणीसन त्यासले पिता ई नही राहिंतं, म्हणीसन त्या स्थळनं नाव मारा अस पडनं. ");
INSERT INTO ahr_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","तवय आम्हीन काय पेवानं? अस म्हणीसन त्यासनी मोशेकडे कुरकूर करी ");
INSERT INTO ahr_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","मोशेनी परमेश्वरना धावा करा तवय त्यानी त्याले एक वनस्पती दखाडी, ती त्यानी पाणीमा टाकी तवय ते पाणी गोड व्हयनं; तठे त्यासनी त्यासना करता विधी अनं नियम लाई दिधात अनी त्यासनी परीक्षा बी लिधी. ");
INSERT INTO ahr_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","अनी सांगं, “तु आपला देव यहोवा यानं वचन मनपुर्वक ऐकशी अनी त्यानी नजरमा जे चांगलं ते करशी, त्यानी आज्ञासकडे कान देशी अनी त्याना सर्व विधी पाळशी तर मिसरी लोकसवर ज्या संकट मी धाडात त्यासमातीन एक बी तुनावर धाडावं नही, कारण मी तुले संकटमुक्त करनारा देव शे.” ");
INSERT INTO ahr_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","मंग त्या एलीम आठे वनात; तठे पाणीना बारा झरा अनी सत्तर खजूरना झाडं व्हतात; तठे पाणीजोडे त्यासनी तळ ठोका. ");
INSERT INTO ahr_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","मंग एलीम आठेन कुच करीसन इस्त्राएल लोकसना सर्व समुदाय मिसर देशमातीन निंघावर दुसरा महिनाना पंधरावा दिनले एलीम अनी सीनाय यासनामातील सीन नावना रानमा ईसन पोहचनात. ");
INSERT INTO ahr_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","त्या रानमा इस्त्राएल लोकसना सर्व मंडळीनी मोशे अनं अहरोन यासनाबद्दल कुरकूर करी. ");
INSERT INTO ahr_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","अनी बोलनात, “आम्हीन मिसर देशमा मासघाई भरेल ताटवर बठीसन मनसोक्त जेवण करे, तवय आमले परमेश्वरना हाततीन मरण येतं तर बरं व्हतं, पण या सर्व समुदायले उपाशी मरावं म्हणीसन तुम्हीन आमले या रानमा लई येल शेतस.” ");
INSERT INTO ahr_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","तवय परमेश्वर मोशेले बोलना, “मी आकाशमातीन तुमनाकरता अन्नवृष्टी करसु अनी या लोकसनी बाहेर जाईसन एक दिनकरता पुरी इतलं जमा करानं; यावरतीन त्या मना नियमतीन चालतस की नही याबद्दल मी त्यासनी परीक्षा दखसु. ");
INSERT INTO ahr_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","सहावा दिन जे काही त्या एकत्र जमाडीसन शिजाडतीन ते रोज जमा करतस त्यानापेक्षा दुप्पट ऱ्हावाले पाहीजे.” ");
INSERT INTO ahr_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","यामुये मोशे अनी अहरोन सर्व इस्त्राएल लोकसले बोलनात की, “परमेश्वरनीच तुमले मिसर देशमातीन काढं हाई तुमले संध्याकायले समजी. ");
INSERT INTO ahr_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","अनी सकाय परमेश्वरनं तेज तुमले दखाई, कारण परमेश्वर विरूध्द तुम्हीन कुरकूर करी राहिनात ती त्यानी ऐकेल शे, आम्हीन कोण शेतस की तुम्हीन आमनाबद्दल कुरकूर करतस?” ");
INSERT INTO ahr_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","मोशे बोलना, “परमेश्वर संध्याकायले तुमले मांस खावले दि अनं सकाय पोटभर भाकरी दि तवय दखा; कारण तुम्हीन परमेश्वर विरुध्द जी कुरकूर करी ती त्यानी ऐकेल शे; आम्हीन कोण शेतस? तुमनं कुरकूरनं आमना विरोधमा नही तर परमेश्वरना विरोधमा शे.” ");
INSERT INTO ahr_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","मोशे अहरोनले बोलना, “इस्त्राएल लोकसनी सर्व मंडळीसले सांग की, तुम्हीन परमेश्वरना समोर या, कारण त्यानी तुमनी कुरकूर ऐकेल शे.” ");
INSERT INTO ahr_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","अहरोन इस्त्राएल लोकसनी सर्व मंडळीसंगे बोली राहिंता तवय त्यासनी रानकडे नजर फिराई, तवय त्यासले अचानक ढगमा परमेश्वरनं मोठं तेज त्यासले दखायनं. ");
INSERT INTO ahr_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","परमेश्वर मोशेले बोलना, ");
INSERT INTO ahr_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“इस्त्राएल लोकसनी कुरकूर मी ऐकेल शे, त्यासले सांग की, संध्याकायले तुम्हीन मांस खाशात अनी सकाय पोटभर भाकर खाशात तवय मी तुमना देव परमेश्वर शे हाई तुमले समजी.” ");
INSERT INTO ahr_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","अनी संध्याकायले अस व्हयनं की लावरी पक्षी ईसन सर्व छावनीवर पसरणार अनी सकाय छावनीना सर्वी बाजूले दव पडनं. ");
INSERT INTO ahr_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","हाई पडेल दव सुकनं तवय ते रानमधली सर्व जमिनवर खवल्यासनामायक बारीक चादर पसरेल दखायनी. ");
INSERT INTO ahr_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","जवय इस्त्राएल लोकंसनी ते दखीसन एकमेकसले बोलनात, “हाई काय शे?” ते काय व्हतं हाई त्यासले माहीत नव्हतं; मोशे त्यासले बोलना, “परमेश्वरनी तुमले खावाले देयल शे ते हाईच शे. ");
INSERT INTO ahr_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","परमेश्वरनी आज्ञा करेल शे की प्रत्येकनी लागी तेवढच गोळा करानं, प्रत्येकना तंबुमा जितला लोकं शेतस त्यासनी संख्याप्रमाणे प्रत्येकनी एक एक ओमर जमा करानं.” ");
INSERT INTO ahr_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","इस्त्राएल लोकसनी तसच करं कोणी कमी तर कोणी जास्त गोळा करं. ");
INSERT INTO ahr_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","त्यासनी ओमरना मापतीन त्यासले मापी दखं तवय ज्यासनी जास्त गोया करेल व्हतं तरी त्यासनं जास्त भरनं नही; तसंच ज्यासनी कमी गोया करेल व्हतं त्यासले कमी पडनं नही. प्रत्येकनी आपआपला खावाना मानतीनच गोया करेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","मोशेनी त्यासले सांगं की, “यानामातील कोणीच सकायपावत उरावानं नही.” ");
INSERT INTO ahr_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","तरी बी त्यासनापैकी कित्येक लोकसनी मोशेनं न ऐकता त्यामातील काही सकायपावत ठेवं तवय त्यामा किडा पडीसन त्याना घाण वास येवाले लागना; त्यावरतीन मोशे त्यासनावर संतापना. ");
INSERT INTO ahr_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","याप्रमाणे त्या कायम सकायले आपले जेवढं लागी तेवढ गोया करेत अनी उन वाढनं म्हणजे ते वितळी जायं. ");
INSERT INTO ahr_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","सहावा दिन त्यासनी दुप्पट म्हणजे एकले दोन ओमर असा गोया करात; तवय त्या मंडळीसना सर्व सरदारसनी ईसन मोशेले हाई सांगं. ");
INSERT INTO ahr_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","तो त्यासले बोलना, “परमेश्वरनं म्हणनं अस शे की सकाय विश्रामना दिन म्हणजे परमेश्वरना शाब्बाथ शे; तुमले भाजानं शे ते भाजा अनी जे शिजाडानं ते शिजाडा अनी जे काही उरी ते आपलाकरता सकायपावत ठेवा.” ");
INSERT INTO ahr_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","मोशेनी त्यासले सांगं तस त्यासनी सकायपावत ठेवं; पण त्याना घाण वास सुटना नही अनी त्यामा किडा बी पडनात नही. ");
INSERT INTO ahr_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","मंग मोशे त्यासले बोलना, “ ते आज खा कारण आज परमेश्वरना शाब्बाथ शे, आज रानमा जेवण तुमले भेटाव नही. ");
INSERT INTO ahr_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","सहा दिन तुम्हीन ते गोया करानं; सातवा दिन शाब्बाथ शे, त्या दिन काहीच ऱ्हावाव नही.” ");
INSERT INTO ahr_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","तरी सातवा दिन ते गोया कराकरता काही लोकं बाहेर गयात पण त्यासले काहीच भेटनं नही. ");
INSERT INTO ahr_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तवय परमेश्वर मोशेले बोलना, “मन्या आज्ञा अनं मना नियम पाळाकरता तुम्हीन कवयपावत तयार व्हवात नही? ");
INSERT INTO ahr_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","हाई ध्यानमा ठेवा, परमेश्वरनी तुमले शाब्बाथ दिधा म्हणीसन सहावा दिन तो तुमले दोन दिननं अन्न देस; प्रत्येकनी आप आपला तंबुमा ऱ्हावानं, आपली जागा सोडीसन कोणीच बाहेर जावानं नही.” ");
INSERT INTO ahr_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","यानाप्रमाणे लोकसनी सातवा दिनले विसावा लिधा. ");
INSERT INTO ahr_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्त्राएल लोकसनी त्या अन्ननं नाव मान्ना ठेवं कारण ते धनानामायक धवळं व्हतं अनी त्यानी चव मध लाईसन बनाडेल पोळीनामायक व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","मोशे बोलना, “परमेश्वरनी अशी आज्ञा देयल शे की, यामातील एक ओमरभर मान्ना पुढली पिढीना लोकसकरता ठेवा, मी तुमले मिसर देशमातीन काढी आणीसन रानमा कोणता प्रकारनं अन्न दिधं हाई त्यासले यावरतीन समजी.” ");
INSERT INTO ahr_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","तवय मोशेनी अहरोनले सांग की, “एक भांड लिसन त्यामा एक ओमरभर मान्ना घाल; ते तुमनी पुढली पिढीकरता परमेश्वरना समोर संभाळीन ठेवानं शे.” ");
INSERT INTO ahr_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","परमेश्वरनी मोशेले आज्ञा करेलप्रमाणे ते संभाळीन ठेवानं म्हणीसन आज्ञासन्या पाट्याससमोर अहरोननी ते ठेवं. ");
INSERT INTO ahr_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्त्राएल लोकं जठे पोहचनं व्हतं त्या कनान देशमा पोहचतस तोपावत चाळीस वरीस “मान्ना” खाई राहिंतात; ");
INSERT INTO ahr_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ओमर हावु एफाना दहावा भाग शे. ");
INSERT INTO ahr_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","मंग इस्त्राएल लोकसना सर्व समुदाय सीन रानमातीन निंघनात; परमेश्वरनी आज्ञाप्रमाणे तठेन जाईसन त्यासनी रफिदीम आठे तळ ठोका; तठे लोकसले पेवाले पाणी भेटी नही राहिंतं. ");
INSERT INTO ahr_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","म्हणीसन लोकं मोशेसंगे भांडण कराले लागनात अनं बोलनात, “आमले पेवाले पाणी दे.” तवय मोशे त्यासले बोलना, “तुम्हीन मनासंगे का बरं भांडी राहिनात? परमेश्वरनी परीक्षा का बरं दखतस?” ");
INSERT INTO ahr_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","पण त्यासले भलतीच तिस लागनी तवय त्या मोशेले कुरकूर करीसन बोलनात, “आमले, आमना पोऱ्यासले अनं आमना गुरंढोरंसले तिशा मारी टाकाकरता तु आमले मिसर देशमातीन बाहेर काढं का?” ");
INSERT INTO ahr_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","मोशे परमेश्वरना धावा करीसन बोलना, “या लोकसनं मी काय करू? या तर जसा माले दगडं माराले तयार व्हयेल शेतस.” ");
INSERT INTO ahr_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","परमेश्वर मोशेले बोलना, “इस्त्राएलना काही वडील माणसे संगे लिसन तु नील नदिवर आपटेल व्हती ती काठी हातमा लिसन लोकसना पुढे चाल. ");
INSERT INTO ahr_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","होरेब डोंगरवरला एक खडकवर मी तुनापुढे उभा राहसु; तु त्या खडकवर काठी आपट; त्यामातीन पाणी निंघी म्हणजे ते या लोकं पेतीन.” मोशेनी इस्त्राएलना वडील लोकसना समोर हाई करं. ");
INSERT INTO ahr_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","मोशेनी ती जागानं नाव मस्सा अनी मरीबोथ अस ठेवं; कारण इस्त्राएल लोकसनी तठे कुरकूर करी अनी परमेश्वरनी परीक्षा दखीसन बोलनात, “परमेश्वर आमनामा शे किंवा नही?” ");
INSERT INTO ahr_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","मंग अमालेकी जातीने ईसन रफिदीम आठे इस्त्राएल लोकससंगे लढाई करू लागना. ");
INSERT INTO ahr_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","तवय मोशेनी यहोशवाले सांगं, “आपलामातील काही माणसे निवाडी काढं अनी जाईसन अमालेकसंगे युध्द कर; सकाय मी देवनी काठी हातमा लिसन डोंगरना माथावर उभा राहसु.” ");
INSERT INTO ahr_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","मोशेनी सांगेल प्रमाणे यहोशवानी करं अनी तो अमालेकसंगे लढाई करू लागना; मोशे, अहरोन अनी हूर ह्या डोंगरना माथावर गयात. ");
INSERT INTO ahr_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","तवय अस व्हयनं की मोशे आपला हात वर करे तवय इस्त्राएल लोकसनी सरशी व्हये अनी तो आपला हात खाल करे तवय अमालेकनी सरशी व्हये. ");
INSERT INTO ahr_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","मोशेना हात भरी वनात तवय त्यासनी एक दगड ठेवा अनं मोशे त्यावर बठना अनी अहरोन अनं हूर यासनी दोन्ही बाजुतीन मोशेना हातले टेका दिधा म्हणीसन सुर्य बुडापावत त्याना हात स्थिर राहिनात. ");
INSERT INTO ahr_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","मंग यहोशवानी आपली तलवारनी धारघाई अमालेकना अनी त्याना लोकसना पराभव करा. ");
INSERT INTO ahr_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","तवय परमेश्वर मोशेले बोलना, “यानी आठवण ऱ्हावाले पाहीजे म्हणीसन हाई गोष्ट एक ग्रंथमा लिखी ठेव अनी यहोशवाना कानवर टाकं; मी परमेश्वर अमालेकनी जातना नावनिशाण पुरं नष्ट करसु.” ");
INSERT INTO ahr_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","तठे मोशेनी एक वेदी बांधीसन तिनं नाव “याव्हे निस्सी म्हणजे परमेश्वर मना झेंडा” अस ठेवं. ");
INSERT INTO ahr_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","तो बोलना, “परमेश्वरना सिंहासनवर हात उचला म्हणीसन परमेश्वरनं अमालेकी लोकससंगे पिढ्यानंपिढ्या युध्द व्हई!” ");
INSERT INTO ahr_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","देवनी मोशे अनी आपला लोकसकरता काय काय करं, परमेश्वरनी इस्त्राएल लोकसले मिसर देशमातीन कसं बाहेर काढं हाई मोशेना सासरा मिद्द्यानी याजक इथ्रो यानी ऐकं. ");
INSERT INTO ahr_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","मोशे आपली बायको सिप्पोरा अनं तिना दोन्ही पोऱ्यासले सोडीसन येल व्हता, त्यासले इथ्रो लिसन वना. ");
INSERT INTO ahr_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","“मोशेनी एक पोऱ्यानं नाव गेर्षोंम अस ठेयल व्हतं, कारण तो बोलना, मी परका देशमा प्रवाशी शे.” ");
INSERT INTO ahr_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","आखो त्यानी दुसरानं नाव एलियेजर अस ठेयल व्हतं, कारण तो बोलना, “मना बापना देवनी माले मदत करीसन फारोना तलवारपाईन वाचाडं.” ");
INSERT INTO ahr_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","रानमा परमेश्वरना डोंगरना पायथाशी मोशेनं तळ ठोकेल व्हतं तठे त्याना सासरा इथ्रो मोशेनी बायको अनी त्याना पोऱ्यासले लिसन वना. ");
INSERT INTO ahr_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","अनी त्यानी मोशेले सांगीसन धाडं की, आम्हीन येल शेतस, ");
INSERT INTO ahr_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","तवय मोशे आपला सासरना पुढे गया अनी त्यासले दंडवत करीसन नमस्कार करं; अनी एकमेकसनी ख्यालीखुशाली ईचारावर त्या तंबुमा गयात. ");
INSERT INTO ahr_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","परमेश्वरनी इस्त्राएलसकरता फारोनं अनं मिसरी लोकसनं काय करं, वाटमा त्यासले काय काय तरास व्हयना अनी परमेश्वरनी त्यासनी सोडवणूक कशी करी हाई सर्व मोशेनी आपला सासराले सांगं. ");
INSERT INTO ahr_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","परमेश्वरनी इस्त्राएल लोकसले मिसरी लोकसना हाततीन सोडाईसन त्यासनं कसं भलं करं हाई ऐकीसन इथ्रोले भलताच आनंद व्हयना. ");
INSERT INTO ahr_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","इथ्रो बोलना, “ज्यानी तुमले राजा फारो अनी मिसरी लोकसना हाततीन सोडावं,‍ ज्यानी आपला लोकसले मिसरीसना तावडीमातीन सोडावं, तो परमेश्वर धन्य शे! ");
INSERT INTO ahr_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","आते माले समजनं की, सर्व देवसपेक्षा श्रेष्ठ परमेश्वर शे, ज्या गोष्टीसबद्दल मिसरी लोक इस्त्राएल लोकससंगे ताठ वागनात, त्याबद्दल तो श्रेष्ठ शे. ");
INSERT INTO ahr_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","मंग मोशेना सासरा इथ्रो यानी देवकरता होमबली अर्पण करं अनं यज्ञ करा; अनी अहरोन इस्त्राएलसना सर्व वडील लोकससंगे मोशेना सासरा इथ्रो यासनासंगे जेवण कराकरता वना.” ");
INSERT INTO ahr_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","दुसरा दिन मोशे लोकसना न्यायनिवाडा कराले बठना, अनी सकायपाईन संध्याकायपावत लोकं त्याना आजुबाजू उभा व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","मोशे लोकसकरता काय काय करस हाई त्याना सासरानी दखं तवय तो बोलना, “तु लोकसकरता हाई काय करस? तु एकलाच बठस अनी सकायपाईन संध्याकायपावत लोकं तुना आजुबाजू उभा राहतस अस का बरं?” ");
INSERT INTO ahr_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मोशे बोलना, “लोकं देवले प्रश्न ईचाराकरता मनाकडे येतस. ");
INSERT INTO ahr_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","त्यासनामा काही झगडा ऱ्हास तर त्या मनाकडे येतस, तवय मी त्यासना न्यायनिवाडा करस अनी देवना विधी अनं नियम त्यासले सांगस.” ");
INSERT INTO ahr_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","तवय इथ्रो बोलना, “तु जे करस ते बरोबर नही शे. ");
INSERT INTO ahr_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","अस करीसन तु अनी तुना संगेना सर्व लोकं थकी जातीन, कारण हाई काम तुले एकलाले भलतच जड पडी. ");
INSERT INTO ahr_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","तर आते तु मनं ऐक मी तुले सल्ला देस, या लोकसकरता देवना तु मध्यस्ती व्हय अनी यासना झगडा देवकडे ने. ");
INSERT INTO ahr_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","विधी अनं नियम त्यासले शिकाड अनी त्यासनी कोणता मार्गतीन चालानं अनी कोणतं काम करानं हाई त्यासले दखाडत जाय. ");
INSERT INTO ahr_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","पण तु या सर्व लोकसमातीन गुणवान, देवनं भय धरणारा, सत्य वागणारा, घुसखोरी न करणारा असा माणसे निवाडी ले अनी त्यासले हजार हजार, शंभर शंभर, पन्नास पन्नास, दहा दहा लोकसवर नायक म्हणीन नेमी ठेव. ");
INSERT INTO ahr_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","त्यासनी लोकसना कायम न्यायनिवाडा कराना; त्यासनी सर्व मोठा झगडा तुनाकडे आनाले पाहीजे अनी धाकला झगडा त्यासनीच मिटाडानात; अस करामुये तुना भार हलका व्हई अनं त्या तुना भारना वाटेकरी व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","तु अस करशी अनी देवनी तुले अशी आज्ञा दिधी तर तुना बचाव व्हई अनी या सर्व लोकं आप आपला घर सुखमा जातीन.” ");
INSERT INTO ahr_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","मोशेनी आपला सासरा इथ्रो यानं ऐकं अनी तस करं. ");
INSERT INTO ahr_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","त्यानी इस्त्राएलमातीन गुणवान पुरुष निवाडी लिधात अनी त्यासले हजार हजार, शंभर शंभर, पन्नास पन्नास, दहा दहा लोकसवर अधिकारी अस नेमी दिधं. ");
INSERT INTO ahr_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","त्या लोकसना कायमना न्यायनिवाडा करू लागनात, एखादं प्रकरण मोठं राहीनं तर ते मोशेकडे आनेत, पण धाकला प्रकरणं त्याच मिटाडू लागनात. ");
INSERT INTO ahr_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","मंग इथ्रोनी मोशेना निरोप लिधा अनी आपला देशले निंघी गया. ");
INSERT INTO ahr_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इस्त्राएल लोकं रफिदीन आठेन निंघनात अनी मिसर देशमातीन निंघीसन तीन महिना व्हयनात त्याच दिनले त्या सीनायना रानमा ईसन पोहचनात. ");
INSERT INTO ahr_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","तठे त्यासनी डेरा दिसन सीनाय पर्वतना समोरच तळ ठोका, ");
INSERT INTO ahr_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","अनी मोशे देवले भेटाकरता डोंगरवर चढी गया. परमेश्वरनी त्याले पर्वतवरतीन हाक मारीसन सांगं की, याकोबना वंशले, इस्त्राएल लोकसले हाई सांगं: ");
INSERT INTO ahr_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“मिसरी लोकसनं मी काय करं ते अनं तुमले जस काही गरुडना पंखवर बसाडीसन कसं आणं हाई तुम्हीन दखेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","म्हणीसन तुम्हीन आते खरोखर मनी वाणी ऐकशात अनी मना करार पाळश्यात तर सर्व लोकसमा मना खास विधी व्हशात, सर्व पृथ्वी मनी शे, पण तुम्हीन मना निवाडेल लोकं शेतस, ");
INSERT INTO ahr_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","पण तुम्हीन मनाकरता याजकराज्य, पवित्र राष्ट्र व्हशात. तुले इस्त्राएल लोकसले जे सांगनं शे ते हाईच शे.” ");
INSERT INTO ahr_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","मोशेनी ईसन लोकसना वडीलसले बलायं अनी परमेश्वरनी ज्या आज्ञा त्यासले सांगाले लायेल व्हतं ते सर्व त्यानी त्यासले सांगं. ");
INSERT INTO ahr_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","तवय सर्व लोकं एकमततीन बोलनात, “परमेश्वरनी सांगेल शे ते सर्व आम्हीन करसुत.” मोशेनी लोकसनं हाई उत्तर परमेश्वरले सादर करं. ");
INSERT INTO ahr_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","मंग परमेश्वर मोशेले बोलना, “मी घनमेघमा तुनाकडे येस, म्हणजे मी तुनासंगे बोलसु ते लोकसना कानवर पडी अनी मंग त्यासना कायम तुनावर ईश्वास बठी.” मोशेनी लोकसनं म्हणनं परमेश्वरले सांगं. ");
INSERT INTO ahr_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","परमेश्वर मोशेला बोलना, “तु लोकसकडे जाय अनी त्यासले आज अनं सकाय पवित्र कर अनी त्यासले त्यासना कपडा धुवाले सांग, ");
INSERT INTO ahr_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","तिसरा दिन ई तोपावत त्यासले तयार ऱ्हावाले लाव, कारण तिसरा दिन सर्व लोकससमोर परमेश्वर सीनाय पर्वतवर उतरी. ");
INSERT INTO ahr_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","तु लोकसकरता आजुबाजू मर्यादा आखीसन लोकसले सांग, संभाळा, पर्वतवर चढू नका, त्यानी सिमाले शिवानं नही, जो कोणी पर्वतले स्पर्श करी तो मरी; ");
INSERT INTO ahr_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","कोणी आपला हात त्याले लावाना नही, लावा तर त्याले दगडमार कराना किंवा बाणघाई मारी टाकानं; तो जनावर असो की मनुष्य असो, त्याले जिवत ठेवानं नही, शिंगसना नाद व्हई तवय लोकसनी पर्वतवर चढानं.” ");
INSERT INTO ahr_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","मोशे पर्वतवरतीन उतरीसन लोकसकडे खाल वना; त्यानी लोकसले पवित्र करं अनी त्यासनी आपला कपडा धुवात. ");
INSERT INTO ahr_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","अनी मोशेनी त्यासले सांगं की, “तिसरा दिन ई तोपावत तयार ऱ्हा, स्त्रीले स्पर्श करू नका.” ");
INSERT INTO ahr_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","तिसरा दिन उजाडताच मेघगर्जना व्हयनी अनं ईजा चमकु लागनात, पर्वतवर घनमेघ वनात अनं प्रचंड शिंगासना नाद व्हवु लागना तवय छावनीमातील सर्वा लोकं थरथर कापू लागनात. ");
INSERT INTO ahr_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","मोशेनी लोकसले देवनं दर्शन कराकरता छावनीना बाहेर आणं अनी त्या पर्वतना पायथाशी उभा राहिनात. ");
INSERT INTO ahr_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","परमेश्वर अग्नीमा सीनाय पर्वतवर उतरना म्हणीसन तो धुममय व्हयना, भट्टीना धूरनामायक त्याना धूर वर चढना अनी सर्वा पर्वत थरथर कापू लागना. ");
INSERT INTO ahr_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","रणसिंगना आवाज वाढतच गया, तवय मोशे बोलू लागना अनी देव त्याले आपली वाणीघाई उत्तर देत गया. ");
INSERT INTO ahr_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","परमेश्वरनी पर्वतना शिखरवर खाल उतरीसन मोशेले सीनाय पर्वतना शिखरवर बलावं, तवय तो वर गया. ");
INSERT INTO ahr_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","परमेश्वर मोशेले बोलना, “खाल जाईसन लोकसले ताकीद दे, नाहीतर त्या मर्यादा वलांडीसन हाई काय शे हाई दखाकरता परमेश्वर शे तठे येतीन अनी त्यासनापैकी बराच जण मरतीन. ");
INSERT INTO ahr_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","तसच परमेश्वर समोर राहणारा याजकसनी बी पवित्र व्हवाले पाहिजे, नहितर परमेश्वर त्यासले शिक्षा दि.” ");
INSERT INTO ahr_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मोशे परमेश्वरले बोलना, “लोकसले सीनाय पर्वतवर येवावनार नही, कारण तुच आमले ताकीद दिधी अनं माले सांगं की, पर्वतना आजुबाजू मर्यादा घाल अनं तो अधिक पवित्र कर.” ");
INSERT INTO ahr_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","तवय परमेश्वर मोशेले बोलना, “तु उतरीसन खाल जाय, नंतर तु अनं अहरोननी वर येवानं; याजकसनी अनं लोकसनी मर्यादा वलांडीसन वर येवालेच नको, वनात तर परमेश्वर त्यासले शिक्षा करी.” ");
INSERT INTO ahr_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","मंग मोशेनी ह्या गोष्टी खाल जाईसन लोकसले हाई सांगं. ");
INSERT INTO ahr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","देवनी या सर्व वचनं सांगात: ");
INSERT INTO ahr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","ज्यानी तुले मिसर देशमातीन, गुलामगिरीमातीन काढं तो मी परमेश्वर तुना देव शे. ");
INSERT INTO ahr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","मनासमोर तुले दुसरा देव नकोत. ");
INSERT INTO ahr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","आपलाकरता मुर्ती बनाडू नको, तसच आकाशमातील, खाल पृथ्वीवरली कसानी अनं पृथ्वीखालना जलमातील कसानीबी मुर्ती बनाडू नको. ");
INSERT INTO ahr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","त्यासन्या पाया पडू नको किंवा त्यासनी पुजा करू नको; कारण मी परमेश्वर तुना देव ईर्ष्यावान शे;‍ ज्या मना विरोध करतस त्यासना पोऱ्यासले चौथी पिढीपावत बापना अन्यायबद्दल शिक्षा करसु. ");
INSERT INTO ahr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","पण ज्या मनावर प्रेम करतस अनं मन्या आज्ञा पायतस असा लोकसना हजारो पिढीसवर मी दया करसु. ");
INSERT INTO ahr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","तुना देव यहोवा यानं नाव व्यर्थ लेवु नको, कारण जो परमेश्वरनं नाव व्यर्थ ली त्याले तो शिक्षा दि. ");
INSERT INTO ahr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","शाब्बाथ दिननी आठवण ठिसन तो पवित्र अशा पाळ. ");
INSERT INTO ahr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","सव दिनपावत कष्ट करीसन आपलं कामकाज कर, ");
INSERT INTO ahr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","पण सातवा दिन तुना देव यहोवा याना शाब्बाथ शे, त्या दिन कोणतच कामकाज करु नको; तु, तुना पोरंसोरं, तुना नौकर, तुना जनावरं किंवा तुनी हदमा ज्या विदेशी शेतस त्यासनी बी काम करानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","कारण सव दिनमा परमेश्वरनी आकाश, पृथ्वी अनं त्यामातील सर्वकाही बनाडं अनी सातवा दिनले आराम करा; म्हणीसन परमेश्वरनी शाब्बाथ दिन आशिर्वाद दिसन पवित्र करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","आपला बाप अनं आपली माय यासना मान राख, म्हणजे जो देश तुना देव यहोवा तुले दि राहिना त्यामा तु कायमना राहशी. ");
INSERT INTO ahr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","खुन करानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","व्यभिचार करानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","चोरी करानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","आपला शेजारनाबारामां खोटं बोलानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“आपला शेजार जो शे त्याना घरना मोह करानं नही, आपला शेजारीनी बाईना मोह करानं नही. आपला शेजारीना नौकर, बैल, गधडा किंवा त्यानी कोणती बी वस्तुना लोभ करानं नही.” ");
INSERT INTO ahr_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","मेघगर्जना व्हई राहिनी, ईजा चमकी राहिन्यात, करणा वाजाना आवाज ई राहिना अनी पर्वतमातीन धुर निंघी राहिना अस सर्व लोकसले दखायनं, ते दखीसन त्यासना थरकाप व्हयना अनी त्या दूर सरकीसन उभा राहिनात. ");
INSERT INTO ahr_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","त्या मोशेले बोलू लागनात, “आमनाशी तुच बोल अनी आम्हीन ऐकसुत; देव आमनासंगे बोलस तर आमले भिती वाटस, तो बोलना तर आम्हीन मरसुत.” ");
INSERT INTO ahr_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मोशेनी लोकसले सांगं, भ्याऊ नका कारण तुमनी परीक्षा दखाकरता अनी त्यानं भय तुमना डोयासमोर राहीनं तर तुम्हीन पाप करावुत नही यानाकरता देव येल शे. ");
INSERT INTO ahr_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","लोकं दुर उभा राहिनात पण मोशे काळोख अंधारमा देव व्हता तिकडे गया. ");
INSERT INTO ahr_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","तवय परमेश्वर मोशेले बोलना तु इस्त्राएल लोकसले अस सांग, मी तुमनासंगे आकाशमातीन भाषण करेल शे हाई तुम्हीन स्पष्ट दखेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","तुम्हीन मना बरोबरीले दुसरा देव करानं नही किंवा आपलाकरता सोनाचांदिना देव बनाडानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","मनाकरता एक मातीनी वेदी करा अनी तिनावर शेरडंमेंढरंसनं अनी गुरंढोरंसन होम अनी शांती अर्पणं करा. अनी कुठे कुठे तुम्हीन मनी आराधना करशात तो तो ठिकाण मी तुमले सांगसु अनी तठे मी ईसन तुमले आशिर्वाद दिसु. ");
INSERT INTO ahr_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","तुम्हीन मनाकरता दगडसनी वेदी बांधशात तर ती फोडेल दगडसनी नही पाहीजे कारण तुम्हीन आपला हत्यारं त्या दगडले लावशात तर तो भ्रष्ट व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","मनाकरता पायऱ्यासनी वेदी बनाडू नको, जर तु पायऱ्या करीसन त्यावरतीन वेदीवर चढशी तर तुनं उघडं शरीर माले दखाई. ");
INSERT INTO ahr_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","आते इस्त्राएल लोकसले या नियम लाई दे: ");
INSERT INTO ahr_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","तु एकादा इब्री गुलाम ईकत लिधा तर त्यानी सव वरीस काम करानं अनी सातवा वरीसले त्यानाबद्दल काही वसुली न करता त्याले जावु देवानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","तो कुवारा जर व्हई तर त्यानी कुवारच मुक्त व्हवानं, जर तो बाईसंगे येल व्हई त्यानी बाईनी बी त्यानासंगे मुक्त व्हईसन जावानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","त्याना मालकनी त्याले बायको करी दिधी व्हई अनी त्याले पोर्‍या अनं पोरी व्हयन्यात तर ती अनी लेकरं त्याना मालकना राहतीन; त्यानी एकलानीच जावानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","पण जर तो दास सांगु लागना की, मना मालकवर अनं मना बायको लेकरंसवर मनं प्रेम शे, माले मुक्त व्हईसन जावानी ईच्छा नही. ");
INSERT INTO ahr_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","तर त्याना मालकनी त्याले देवसमोर आणीसन दारजोडे किंवा दारना चौकटजोडे उभं करानं अनं आरीघाई त्याना कान टोचाना म्हणजे तो त्याना कायमना गुलाम राही. ");
INSERT INTO ahr_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","कोणी आपली पोर दासी म्हणीसन ईकी तर दासनामायक तिनी मुक्त व्हईसन जावानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","तिना मालक तिले आपली बाई करी ली अनी पुढे तिनावर त्यानं मन भरी गयं तर त्यानी खंड लिसन तिले मुक्त करानं; तिनासंगे त्यानी कपट करामुये परका लोकसले तिले ईकाना त्याले अधिकार नही. ");
INSERT INTO ahr_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","जर ती दासीले त्याले आपला पोऱ्याकरता ठेवनं व्हई तर तिले त्यानी आपली पोर प्रमाणे वागाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","त्यानी दुसरी बाई जरी करी तरी अन्न, वस्त्र अनं निवारा यामा तिले काही कमी पडू देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","या तिन्ही गोष्टी जर तो करत नही व्हई तर खंड न देता तिनी मुक्त व्हई जावानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","कोणी एकादाले शिक्षा करी अनी त्यामा तो मरी गया तर शिक्षा करणाराले मरणदंड व्हवालेच पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","एकादाना घात कराना इरादातीन कोणी टपीन बठेल नही व्हई तरी देवनी त्याले त्याना हातमा दि दिध तर त्याले पळी जावाकरता मी तुले एक जागा नेमी देस. ");
INSERT INTO ahr_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","जर एकादा धिटाई करीसन टपीन एकादावर चाल करी गया अनी त्याना घात करा तर त्याले मारी टाकाकरता मनी वेदीना जोडेतीन बी लई जावानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","कोणी आपला बापले किंवा मायले शिक्षा करस तर त्याले मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","कोणी एकादा माणुसले चोरीसन ईकत व्हई किंवा त्यानाजोडे तो सापडना तर चोरनाराले मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","कोणी आपला बापले किंवा आपली मायले शिव्या शाप देत व्हई तर त्याले मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","दोन माणसं भांडी राहिनात अनी एकनी दुसराले दगड मारा किंवा बुक्का मारा अनी त्यामुये तो मरणा नही पण अंथरुन धरी बठना. ");
INSERT INTO ahr_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","अनी तो उठीसन, काठी धरीसन हिंडूफिरु लागना तर मारणाराले सोडी देवानं. पण तो घर बठामुये त्यानं व्हयेल नुकसान त्यानी भरी देवानं अनी त्यानी त्याले पुरं बरं करी देवानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","कोणी आपला दास किंवा दासीले काठीघाई मारं अनी मारता मारता तो दास मरी गया तर मारणाराले शिक्षा व्हवालेच पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","पण तो एकदोन दिन जिवत राहिना तर मालकले दंड कराना नही; कारण तो त्यानच धन शे. ");
INSERT INTO ahr_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","कोणी आपसमा मारामारी करी राहिनात अनी त्यामा एकादी गर्भवती बाईले धक्का लागीसन तिना गर्भपात व्हयना, पण तिले दुसरी काही इजा व्हयनी नही तर ती बाईना नवरा सांगी तो दंड देना पडी अनी न्यायाधिशना आज्ञातीन त्यानी तो भराना. ");
INSERT INTO ahr_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","पण दुसरी काही इजा व्हयनी तर जीव बद्दल जीव, ");
INSERT INTO ahr_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","डोयाबद्दल डोया, दातबद्दल दात, हातबद्दल हात, पायबद्दल पाय, ");
INSERT INTO ahr_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","चटकाबद्दल चटका, जखमबद्दल जखम, फटकाबद्दल फटका असा बदला लेवाना. ");
INSERT INTO ahr_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","जर कोणी वार करीसन आपला दास किंवा दासीना डोया फोडी तर तो डोया गया म्हणीसन त्यानी त्याले दास्यमुक्त करानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","अनी जर कोणी वार करीसन आपला दास किंवा दासीना दात पाडी तर तो दात गया म्हणीसन त्यानी त्याले दास्यमुक्त करानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","एकादा बैलनी एकादा माणुसले किंवा बाईले घोमालीसन मारी टाकं, तर त्या बैलले दगडमार करीसन मारी टाकानं, पण त्यानं मांस कोणी खावानं नही; बैलना मालकले मात्र सोडी देवानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","जर त्या बैलले शिंग मारानी सवयच व्हई अनी त्याना मालकले त्यानाबद्दल सांगं तरी बी त्यानी त्याले बांधी ठेवं नही, अनी त्यानी एकादा माणुसले किंवा बाईले मारी टाकं, तर बैलले दगडमार कराना अनी त्याना मालकलेबी मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","जर कोणी त्यानाबदलामा किंमत भरी मांगी तर त्या मालकनी आपलं जीव वाचाडाकरता जी काही किंमत मांगी व्हई ती दि टाकानी. ");
INSERT INTO ahr_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","बैलनी एकादाना पोऱ्याले किंवा पोरले घोमालीसन मारी टाकं तरी बी हावुच न्याय त्याले लागू व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","जर बैलनी एकादाना दासले किंवा दासीले घोमालीसन मारं तर त्या बैलना मालकनी त्याले तीस चांदीनं शिक्का देवानात अनी त्या बैलले दगडमार करानी. ");
INSERT INTO ahr_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","एकादानी खड्डा खोदीसन किंवा उघडीसन त्याले झाकं नही अनी त्यामुये एकादानं गधडा किंवा बैल पडना, ");
INSERT INTO ahr_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","तर खड्डाना मालकनी नुकसान भरपाई करी देवानी, जनावरना मालकले त्याना मोल देवाना अनी मरेल जनावर त्या खड्डाना मालकनं व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","एकादाना बैलनी दुसराना बैलले जखमी करीसन मारी टाकं तर त्या दुसरा बैलले ईकीसन दोन्ही मालकसनी तो पैसा वाटी लेवाना, तसच मरेल बैलबी त्यासनी वाटी लेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","पण बैल पहिलापाईन मारका शे हाई माहीत राहिसन बी मालकनी त्याले बांधी ठेवं नही तर त्यानी बैलना बदलामा बैल देवाना अनी मरेल बैल त्याना व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","एकादा माणुसनी बैल किंवा मेंढरु चोरीसन ते कापं किंवा ईकी टाकं तर त्यानी बैलबद्दल पाच बैल अनी मेंढरुबद्दल चार मेंढरं देवानात. ");
INSERT INTO ahr_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","चोर घरफोडी करतांना सापडना किंवा तो मरी जाई असा त्याले जर मार भेटना तर त्याना खुनना गुन्हा कोणवर लावाना नही, ");
INSERT INTO ahr_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","पण तो चोरी करतांना सुर्य उगायना तर मारणारावर खुनना दोष लागी; चोरनी नुकसान भरपाई देवानी तो कंगाल व्हई तर भरपाई करता त्याले ईकी देवानं. ");
INSERT INTO ahr_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","चोरेल बैल, गधडा, मेंढरु वैगेरे चोरकडे जिवत सापडनं तर त्यानी एकना बदले दोन दोन देवानात. ");
INSERT INTO ahr_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","कोणी दुसरानं वावर किंवा द्राक्षमळामा आपला जनावरं मोकया सोडी दिधात अनी त्यासनी तठे नुकसान करं तर त्यानी आपला वावरमातील अनी आपला द्राक्षमळामातील चांगलं ते पिक दिसन त्यानी नुकसान भरपाई करानी. ");
INSERT INTO ahr_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","एकादाना वावरमा आग लाईसन, काटाकुटा जाळात अनी त्यामुये पिकन्या काड्या, उभं पिक किंवा वावर जळी गयं तर ज्यानी आग चेटाडेल व्हई त्यानी नुकसान भरपाई करीच देवाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","जर कोणी आपला शेजारीकडे पैसा किंवा किमती वस्तु ठेयात अनी त्याना घरतीन ते चोराई गयं तर जवय चोर सापडना तवय त्या चोरकडतीन ते दुप्पट लेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","पण चोर जर नही सापडना तर घरना मालकले देवसमोर लई जावानं म्हणजे त्यानी आपला शेजारीना वस्तुसले स्वतः हात लावा की नही याना निर्णय व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","कारण कोणता बी प्रकारनी अपराध व्हयनं, मंग तो बैल, गधडा, मेंढरु, कपडा किंवा कोणती बी गमाडेल वस्तु यासनाबद्दल व्हई, तर ती मनी शे अशी कोणी तक्रार करी तर दोन्हीसनं प्रकरण देवसमोर लई जावानं अनं ज्याले देव दोषी ठराई त्यानी आपला शेजारीले त्यापेक्षा दुप्पट परत देवानं. ");
INSERT INTO ahr_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","कोणी शेजारीकडे बैल, गधडा, मेंढरु, कपडा किंवा कोणतं बी जनावर राखाकरता ठेवं अनं जर ते मरणं किंवा त्याले काही जखम व्हयनी किंवा ते कोणले न दखावता हाकली लई गया. ");
INSERT INTO ahr_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","तर त्या दोन्हीसले परमेश्वरनी शपथ लेवाले लावानी अनी मी दुसराना वस्तुले हात लायेल नही अस जर राखणारा बोलना तर मालकनी ते खरं मानानं; मंग त्याले भरपाई करनी नही पडावं. ");
INSERT INTO ahr_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","त्यानाकडतीन जर ते खरंच चोराई गयं व्हई तर त्यानी मालकले भरपाई करी देवानी. ");
INSERT INTO ahr_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","त्या जनावरले जर कोणी फाडी टाकं व्हई तर त्यानी पुरावा दखाडाना म्हणजे त्याले भरपाई करनी पडावं नही. ");
INSERT INTO ahr_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","कोणी आपला शेजारीकडतीन त्यानं जनावर मांग अनी त्याना मालक त्यानासंगे नही व्हई तवय त्या जनावरले काही दुखापत व्हयनी किंवा ते मरी गयं तर त्यानी त्या मालकले भरपाई करी देवानी. ");
INSERT INTO ahr_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","पण त्याना मालक संगे शे तर भरपाई करनी पडाव नही; ते भाडातीन लेयल व्हई तर त्यानी भरपाई भाडामाच ई लागस. ");
INSERT INTO ahr_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","लगीन व्हयेल नही अशी कुमारीले कोणी फुस लाईसन तिनासंगे झोपना तर त्यानी देज दिसन तिनासंगे लगीन करानं. ");
INSERT INTO ahr_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","पण तिना बाप त्याले ती देवाले अजिबात तयार नही तर कुमारीले देज देवानी प्रथाप्रमाणे त्या माणुसनी पैसा मोजीन देवाना. ");
INSERT INTO ahr_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","चेटकिणले जिवत ठेवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","पशुगमन करणाराले तर मारीच टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","जो कोणी परमेश्वरले सोडीसन दुसरा देवसले बली अर्पण करी तर त्याना पुरा नाश करी टाकाना. ");
INSERT INTO ahr_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","कोणता बी परदेशीले छळू नको किंवा त्यानावर जुलूम करू नको, कारण मिसर देशमा तुम्हीन बी परदेशी व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","तुम्ही कोणती बी विधवा किंवा अनाथले तरास देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","जर तुम्हीन तस करं अनी त्यासनी मनाकडे रडीसन मदत मांगी तर मी त्यासनं ऐकसुच ऐकसु, ");
INSERT INTO ahr_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","अनी मना राग भडीसन मी तुमना तलवारघाई नाश करसु; तुमन्या बाया विधवा अनी तुमना पोऱ्या अनाथ व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","तुनाकडे राहणारा मना लोकसपैकी कोणी कंगाल व्हई अनं तु त्याले पैसा उसना दिधात तर तु त्यानासंगे सावकारनामायक वागू नको अनं त्यानाकडतीन व्याज लेऊ नको. ");
INSERT INTO ahr_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","तु जर तुना शेजारीपाईन त्यानं अंथरून गहाण ठि लिधं व्हई तर सुर्य बुडाना पहिले त्याले ते परत दे. ");
INSERT INTO ahr_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","कारण त्यानाजोडे ते एकच पांघरान राहीसन त्यानं आंग झाकाले तेवढच राही; ते लिधं तर तो काय पांघरीन निजी? त्यानी मनाकडे गाऱ्हाणं करं तर मी त्यानं ऐकसु, कारण मी करूणामय शे. ");
INSERT INTO ahr_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","तु देवले दोष लावानं नही, आपला राजकर्ताले शिव्याशाप देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","आपला वावरना उपज अनं आपला फळसना रस माले अर्पण कराकरता हयगय करानं नही. तुना पोऱ्यासपाईन पहिला जन्मेल माले देवानं. ");
INSERT INTO ahr_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","तसंच बैल अनं मेंढरं यासनाबी पहिला जन्मेल माले देवानं; सात दिनपावत त्या बच्चानी आपला मायनासोबत रावानं; आठवा दिनले तु ते माले देवानं. ");
INSERT INTO ahr_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","तुम्हीन मना पवित्र लोक शेतस म्हणीन रानमा फाडी टाकेल पशुनं मांस तुम्हीन खावानं नही; ते कुत्रासले देवानं. ");
INSERT INTO ahr_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","खोटी अफवा उडावानं नही; खोटा साक्षीदार व्हावाकरता ज्या वाईट शेतस त्यासले साथ देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","तु वाईट कराकरता गर्दिनीमांगे जावानं नही अनी गर्दीनी मांगे लागीसनी एकादा खटलामा चुकीनं न्याय व्हावाकरता साक्ष देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","गरीबसना खटला व्हयी तर भेदभाव करानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","आपला शत्रुना बैल नाहिते गधडा सुटा फिरतांना तु दख व्हयीते त्यासले फिराईसनी परत त्यानाकडे धाडी देवानं. ");
INSERT INTO ahr_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","तु आपला शत्रुना गधडा भारखाल दाबायेल दखा व्हयीते त्याले तशेच सोडानं नही तर त्याले मदत करीन त्यामाईन सोडावानं. ");
INSERT INTO ahr_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","तुना लोकासमाईन कोनी गरीब व्हयी त्याना खटलाना न्याय चुकीतीन करानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","खोटा खटलासपाईन दुर राहावानं; निर्दोष अनी न्यायी यासले मारानं नही, कारन दुष्टासले मी निर्दोष ठरावावु नही. ");
INSERT INTO ahr_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","लाच लेवानी नही; कारन लाच डोळासले आंधळी करस अनी न्यायीसनी शब्दले पलटाई देतस. ");
INSERT INTO ahr_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","एकादा परकावर जुलुम करानं नही, कारण त्यासनं मन कशे राहास हाई तुम्हले माहिती शे; कारण तुम्हीबी मिसर देशमा पारका व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","सव वरीस आपला वावर पेरानं अनी तिना उत्पन्न साठाडानं; ");
INSERT INTO ahr_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","पण सातवा वरिशले तिले विसावा देईसनी तिले पडीत राहू देवानं, म्हणजे तुना लोकासमाईन कोणी गरीब व्हतीन ते तिमा उगाडेल खातीन अनी त्यासनी खायेल जे उरायेल व्हयी ते वनपशु खातीन. तुना द्राक्षमळा अनी जैतुन जंगल यानाबारामा तशेच करानं. ");
INSERT INTO ahr_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","सहा रोज तु कामधंदा कर अनी सातवा रोजले आराम करानं, म्हणजे तुना बैल अनी गधडा यासले आराम भेटी अनी तुना दाससनी संतती अनी विदेशी यासना जीव तृप्त व्हयी. ");
INSERT INTO ahr_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","मी जे काही तुम्हले सांगेल शे त्या सर्वासनी बारामा सावध राहावानं, दुसरा देवसनं नावसुध्दा लेवानं नही, त्यासना नाम उच्चार तोंडमाईन आयकाले येवाले नही पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","वरिशमा तीनदाव तु मनाकरता मेळा भराईसनी सण करानं. ");
INSERT INTO ahr_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","बेखमीर भाकरीसनं सण पाळ; त्या सणासमा मना आज्ञापरमानं अबीब महिनामा नेमेल येळनं सात रोज तु बेखमीर भाकरी खा, कारण तोच महिनामा तुम्हीन मिसर देशमाईन बाहेर निघेल व्हता; कोनीच रिकामा हात लईसनी मनं दर्शनले येवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","जवय वावरमा पैयरेल धान्यनं पहिलं पिक तयार व्हयी तवय तु कापणीनं सण पाळ अनी वरिशनं शेवटले तु आपला वावरमा कष्ट करेल फळनं साठा करशी तवय साठानं सण पाळ. ");
INSERT INTO ahr_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","वरशमा तीनदाव तुम्हना माधला बठा माणसानी परमेश्वर देवनं दर्शन लेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","मना यज्ञपशुसनं रंगत खमिरनं भाकरीसनीसंगे अर्पानं नही; अनी मनाकरता करेल सणसमासली वपा सकाळपावोत राहु देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","आपला जमीननं पहिला उत्पन्नमाधला पहिला भाग आपला देव यहोवा याना मंदिरमा तु आणानं. कोकरू त्याना मायनं दुधमा शिजाडानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","दख, मी एक दूत तुन्हामोरे धाडी राहीनु, तो वाटमा तुनं रक्षन करी अनी जे ठिकान मी तयार करेल शे तठे तुले धाडसू. ");
INSERT INTO ahr_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","त्यानामोरे तुम्ही सावध राहीसनी त्याना म्हणनं मानानं; त्यानी आज्ञा मोडानी नही; कारण तो तुम्हना अपराधनं माफ कराऊ नही; त्यानामा मना नाव शे. ");
INSERT INTO ahr_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","जर तु खरच मनं म्हणनं ऐकशी अनी मी तुले सांगस ते बठ करशी तर मी तुना शत्रुना शत्रु, तुना विरोधीना विरोधी व्हसु. ");
INSERT INTO ahr_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","मना दूत तुनामोरे चालीसनी तुले अमोरी, हित्ती, परिज्जी, कनानी, हिव्वी, अनी यबुसी लोकेसकडे लयी जासू अनी मी‍ त्यासना नाश करसू. ");
INSERT INTO ahr_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","त्यासना देवले तु नमन करानं नही, त्यानी पुजापाट करानी नही अनी त्यासनासारखा काम करानं नही, तर त्यासना नाश करानं अनी त्यासना खांबसनं तुकडा तुकडा करी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","तु आपला देव यहोवा यानी उपासना करानं म्हणजे तो तुम्हना अन्नपानीले बरकत देई अनी तुनामाधला रोगराई काढी टाकी. ");
INSERT INTO ahr_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","तुना देशमा कोनबी गर्भपात व्हावाले नही पाहिजे नाहिते कोनी वांझ राहावू नही अनी मी तुले बराच आयुष्य दिसुं ");
INSERT INTO ahr_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","ज्या ज्या लोकेसमा तु जाशी त्यासले मी आगोदरच मनी भिती घालीसनी त्यासले भिवाडसू अनी तुना शत्रु तुले पाठ दखाडतीन आशे करसू. ");
INSERT INTO ahr_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","मी तुनापहिले गांधीलमाशी धाडसू, त्या हिव्वी, कनानी, अनी हित्ती यासले तुनामोरेतीन पळाडसु. ");
INSERT INTO ahr_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","मी त्या बठासले एक वरिशमा हाकालावु नही; तशे करं ते देश उजाड व्हयी अनी वनपशु बराच व्हयीसनी तुले त्रास देतीन. ");
INSERT INTO ahr_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","तुनी संख्या व्हईसनी तु देशना ताबा लिसी तोपावत मी बागेबागे तुनामोरेतीन त्यासले काढसु ");
INSERT INTO ahr_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","तांबडा समुद्रपाईन ते पलिष्टीसना समुद्रपावोत अनी जंगलपाईन ते फरात नदिपावत तुना देशनी हद्द् करसू; त्या देशमाधला लोके तुना काबुमा आणसु अनी तु त्यासले तुनामोरेतीन हाकली दिशी. ");
INSERT INTO ahr_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","तु त्यासनासंगे किंवा त्यासना देवनीसंगे करार करानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","त्या तुना देशमा राहावाले नही पाहिजे; त्या राहीनात त्या मनाविरुध्दमा तुले पाप कराले लावतीन; कारन तु त्यासना देवनी पुजापाट करशी अनी त्या तुले पक्का फाशीवर आणतीन. ");
INSERT INTO ahr_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","मंग त्यानी मोशेले सांग, तु, अहरोन, नादाब, अबीहू अनी इस्त्राएलसना वडीलसमाईन सत्तर जण मिळीसनी परमेश्वरकडं वर येईसनी त्याले दुरतीन दंडवत घाला. ");
INSERT INTO ahr_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","एकला मोशेनी परमेश्वरनीजोडे येवानं; बाकीना जोडे येवानं नही अनी इतर लोकेसनी ते त्यानासंगे वर चढीसनी येवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","मंग मोशे लोकसनीजोडे जाईसनी परमेश्वरनं बठा वचन अनी बठा नियम त्यासले सांगं, तवय बठा लोके एक आवाजमा बोलनात की ज्या वचन परमेश्वरनी सांगेल शेतस त्याप्रमानं आम्ही वर्तन करसुत. ");
INSERT INTO ahr_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","मोशेनी परमेश्वरना बठा वचन लिखी काढ अनी पहाटमास उठीसनी डोंगरनं पायथाले एक वेदी अनी इस्त्राएलनं बारा वंशपरमानं बारा खांब उभारं. ");
INSERT INTO ahr_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","त्यानी इस्त्राएल लोकेसमाईन काही तरुणसले धाडं, त्यासनी परमेश्वरले होमबली अनी बैलनं शांतीर्पण करं. ");
INSERT INTO ahr_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मोशेनी अर्धा रंगत लयीसनी वाटकामा ठेवं अनी अर्धा वेदीवर शितडं. ");
INSERT INTO ahr_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","मंग त्यानी करार पुस्तक लयीसनी लोकेसले वाची दखाडं; ते आयकीसनी त्या बोलनात, जे काही परमेश्वरनी सांगेल शे ते बठं आम्ही करसुत अनी त्यानी आज्ञामा राहासुत. ");
INSERT INTO ahr_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","मोशेनी रंगत लयीसनी लोकेसवर शितडं अनी त्यासले सांगं की दखा, परमेश्वरनी हाई बठा आज्ञानी शर्तवर तुम्हनासंगे जे करार करेल शे त्यानं हाई रंगत शे. ");
INSERT INTO ahr_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","मंग मोशे, अहरोन, नादाब, अबीहू अनी इस्त्राएलमाईन सत्तर वडील वर चढीसनी गयात. ");
INSERT INTO ahr_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","त्यासनी इस्त्राएलनं देवनं दर्शन लिधं; त्याना चरनमा नीलमणीना चौरंगनागतक दखायनं जे आकाशनासारखा स्वच्छ व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","इस्त्राएल लोकेसना सरदारसवर त्यानी हात उगारं नही; त्यानी परमेश्वरनं दर्शन लिधं अनी खावापेवानं कार्यक्रम करं. ");
INSERT INTO ahr_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","मंग परमेश्वरनी मोशेले सांगं; पर्वतवर चढीसनी मनाजोडे ये अनी तठे राहाय; मी तुले दगडन्या पाटया अनी लोकेसना शिक्षणकरता स्वतः लिखीसनी नियम अनी आज्ञा देस. ");
INSERT INTO ahr_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","मोशे अनी त्याना सेवक यहोशवा हया देवना पर्वतवर चढीसनी वर गयात. ");
INSERT INTO ahr_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","मोशे वडीलसले बोलना; आम्ही तुम्हनाकडे परत येतस तोपावत आठे तुम्ही वाट दखत राहावानं; दखा, अहरोन अनी हूर हया तुम्हनासंगे शेतस; कोण काही परकरन व्हयीते ते त्यानाकडे लयी जावानं. ");
INSERT INTO ahr_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","मोशे पर्वतवर चढी गया अनी ढगसघाई पर्वत झाकाई गया. ");
INSERT INTO ahr_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","परमेश्वरनं तेज सीनाय पर्वतवर राहीनं अनी ढगसनी सव रोज ते ढाकी टाकं अनी सातवा रोजले ढगमाईन परमेश्वरनी मोशेले हाक मारी. ");
INSERT INTO ahr_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","परमेश्वरनं तेज पर्वतना माथावर धगधगनारा आगप्रमाणं इस्त्राएल लोकेसले दखायनं. ");
INSERT INTO ahr_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","हाई प्रकारं मोशे ढगमा जाईसनी पर्वतवर चढी गया; मंग तो पर्वतवर चाळीस दिवस अनी चाळीस रात व्हता. ");
INSERT INTO ahr_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","परमेश्वर मोशेले बोलना; ");
INSERT INTO ahr_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","इस्त्राएल लोकेसले आशे सांग की त्यासनी मनाकरता अर्पण लयानं; ज्याले मनपाईन अर्पण करानी इच्छा शे त्या बठासनं अर्पण मान्य करानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ज्या वस्तुसनी अर्पण त्यासपाईन लेवानी शेतस त्या आशे; सोनं, चांदी, पितळ, ");
INSERT INTO ahr_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","निया, जांभया अनी किरमिजी रंगनं सुत अनी तलम सणसनं कपडा, बकर्‍यासनं केस; ");
INSERT INTO ahr_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","लाल रंगाडेल मेंढासनं कातडं, शुस नावना मोठा मासानं कातडं; बाभुळनं लाकुड; ");
INSERT INTO ahr_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","दिवानं तेल, अभिषेकनं तेलकरता अनी सुगंधी धुपकरता मसालं. ");
INSERT INTO ahr_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","एफोद अनी उरपट यामा खचाकरता गोमेद मनी अनी दुसरा रत्न. ");
INSERT INTO ahr_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","मना त्यामा निवास राहावाले पाहिजे म्हणीसनी त्यासनी मनाकरता एक पवित्रस्थान बनाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","निवासमंडपनं अनी त्यामासला बठा वस्तुसना नमुना तुले दखाडस त्या बठासप्रमानं तुम्ही ते करानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","बाभुळनं लाकडसनं एक कोश बनाडानं; त्यानी लांबी अडीच हात, रुंदी दीड हात अनी उंची दिड हात राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ते मजारतीन शुध्द सोनाघाई मढावानं अनी कोशनं वर आजुबाजूले सोनानं गोट बनाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","अनी त्याना चारी पायले लावाकरता सोनानं चार कडया ओतीन अनी मजारतीन एक बाजुले दोन अनी दुसरी बाजुले दोन आशे लावानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","अनी बाभुळनं लाकडासनं दांडा करीसनी तेबी सोनाघाई मढावानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","तो कोश उचलाकरता हाई दांड त्याना दोनी बाजुले कडयासमा घालानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","हाई दांड कोशनं कड्यासमां राहावाले पाहिजे; त्यामाईन ते काढानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","अनी जे आज्ञापट तुले दिसु तेबी‍ त्या कोशमा ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","अनी शुध्द सोनानं एक दयासन बनाडानं; त्यानी लांबी अडीच हात अनी रुंदी दीड हात राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","अनी सोनं घडाईसनी दोन करुब कर; ते दयासननं दोनी बाजुले कर. ");
INSERT INTO ahr_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एक करुब एक बाजुले अनी दुसरा करुब दुसरी बाजुले करानं; ह्या प्राणी करुब दयासननाजोडे एकसारखा ठेईसनी दोनी बाजुले करानं ");
INSERT INTO ahr_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","त्या करुबना पखा आशे पसरेल राहावाले पाहिजे की त्याघाई ते दयासन झाकाले पाहिजे अनी त्याना तोंड एकमेकसनामोरे राहीसनी त्यासनी नजर दयासनकडं राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","दयासन कोशवर लावानं अनी ज्या आज्ञापट तुले दिसु त्या कोशमा ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","तठे तुले मी भेट देत जासु; अनी इस्त्राएल लोकेसकरता ज्या गोष्टीसनीबारामा मी तुले आज्ञा देनार शे त्या सर्वासनीबारामा मी दयासनवरतीन अनी त्या आज्ञापटन्या कोशवरना दोनी करुबमाईन तुनासंगे बोलत राहासु. ");
INSERT INTO ahr_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","अनी बाभुळनं लाकुडघाई एक मेज बनाड; त्यानी लांबी दोन हात, रुंदी एक हात अनी उंची दिड हात राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ते शुध्द सोनाघाई मढाईसनी त्याना आजुबाजूले सोनानं गोट करानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","अनी त्यानाकरता चार बोट रुंदीनं एक चौकट करीसनी तिना आजुबाजूले सोनानं गोट करानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","सोनान्या चार कडया करीसनी त्याना चारी पायसना चार कोपराले लावानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","त्या कडया चौकटन्या जोडे राहावाले पाहिजे; मेज उचलाकरता त्यामां दांडा घालानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","हाई मेज उचलानं दांडा बाभुळनं लाकुडनं करीसनी सोनाघाई मढावानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","अनी त्यानावरना परात, धुपाटनं, चमचा नई पेय अर्पननं भांड हाई बठा सोनानं करानं; ");
INSERT INTO ahr_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","अनी मेजवर मनामोरे समर्पित करेल भाकर कायम ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","अनी शुध्द सोनानं एक दिवट बनाडानं, हाई दिवट, त्यानी बैठक, त्याना दांडा, त्यान्या वाटया, त्यासना बोंडा अनी त्याना फुल हाई बठा सोनानं एकच एकसारखा तुकडासना घडावानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","हाई दिवटना सव फांद्या राहावाले पाहिजे; त्याना एक बाजुले तीन फांद्या अनी दुसरी बाजुले तीन फांद्या राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","एक बाजुले प्रत्येक फांद्यासले बदामना फुलना सारखा तीनतीन वाटया बोंडफुलासनासंगे; अनी दुसरी बाजुले त्यान्या जोडीना प्रत्येक फांद्यासले बदामना फुलना सारखा तीन तीन वाटया बोंडफुलासनीसंगे राहावाले पाहिजे; दिवटमाईन निघेल सव फांद्यासनी रचना आशी राहावाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","अनी दिवटना दांडीले बदामना फुलनासारखा बोंडफुलससंगे चार वाटया राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","अनी दिवटमाईन निघेल सव फांद्या दोनदोन फांद्यासन्या खाल एक एक बोंड राहीसनी ती‍ त्यानासंगे एकासारख्या जोडानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","त्‍याना बोंडा अनी त्यान्या फांद्या हाई बठा त्याले एकसारखं जोडानं; तो बठा दिवट शुध्द सोनानं एक तुकडा ठोकीसनी घडावानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","अनी त्यानाकरता सात दिवा करीसनी त्यानावर ठेवानं म्हणजे दिवटना पुढली बाजुले त्याना प्रकाश पडी. ");
INSERT INTO ahr_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","त्याना चिमटा अनी ताटल्या हाई बठा शुध्द सोनानं करानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","हाई बठा सामान हाई दिवट चोतीस किलो शुध्द सोनाघाई करानं. ");
INSERT INTO ahr_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","अनी परवतवर तुले दखाडेल नमुनाप्रमानं हाई बठा सामान बनाडानं तु सावधगिरी ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","निवास मंडपकरता दहा पडदा करानं; त्या कातेल तलम सणसना कापडासना अनी निया, जांभया अनी किरमिजी रंगनं सुतघाई तयार करानं अनी त्यामा मोठा चतुर कारागीरकडतीन करुब काढी लेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","एक एक पडदानी लांबी आठ्ठावीस हात अनी रूंदी चार हात राहावाले पाहिजे; त्या बठा पडदा एक मापना राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","त्यामासला पाच पडदा येरायेरले जोडीसनं राहावाले पाहिजे अनी दुसरा पाच पडदा येरायेरले जोडीसनं राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","जठे एक पडदा जोडामां येई तठे काठले निया सुतनं फंदा कर; तशेच दुसरा पडदानं काठलेबी तशच फंदा कर. ");
INSERT INTO ahr_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","एक पडदाले पन्नास फंदा कर अनी दुसरा पडदानं काठले पन्नास फंदा कर. ह्या फंदा समोरासमोर राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","तशेच सोनानं पन्नास आकडा बनाडानं अनी या आकडासना अनी त्या आकडासना पडदा आशे जोडानं की बठा मिळीसनं निवासमंडप अखंड दखाई. ");
INSERT INTO ahr_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","निवासमंडपवार तंबू राहावाले पाहिजे‍ म्हणीसनं बकर्‍यासना केसासना पडदा करानं; त्या पडदा आकरा राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","एक एक पडदानी लांबी तीस हात अनी रूंदी चार हात राहावाले पाहिजे; हया आकरा पडदा एक मापना राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","पाच पडदा येगळा अनी सव पडदा तंबूना समोरनी बाजुले दोन भाग करानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","जोडीसनं करेल एक फंदानं बाहेरतीन शेवटना पडदानं काठले पन्नास फंदा करानी; तशेच फंदानं दुसरा पडदानं काठले पन्नास फंदा करानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","अनी पितळनं पनास आकडा बनाडानं; अनी ते फंदासमा घालीसनं तंबू आशे जोडानं ते अखंड दखाई. ");
INSERT INTO ahr_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","तंबूना पडदाना लटकेल भाग म्हणजे उरेल आरधा पडदा निवासमंडपना मांगेना बाजुले लटकत सोडानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","अनी तंबूना पडदा लांबीकडतीन हातभर हाई बाजुले अनी हातभर त्या बाजुले आशे निवासमंडप झाकाकरता त्यान्या दोनी बाजुले लटकाडी ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","तंबुकरता तांबडा रंग देयेल मेंढाना कातडानं एक आच्छादन अनी त्यानावर तहश्यानं कातडानं एक आच्छादन करानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","निवासमंडपले उभा लावाकरता बाभुळना लाकडेसना फळया बनाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","प्रत्येक फळीनी लांबी दहा हात अनी रूंदी दीड हात राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","प्रत्‍येक फळी दुसरी फळीले जोडानी म्हणजे तिले दोनदोन कुसे राहावाले पाहिजे; निवासमंडपन्या बठया फळया आशेच करानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","निवासमंडपकरता ज्या फळया तु करशी त्यासनामाईन वीस फळया दक्षिण बाजुकरता राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","या ईस फळयासना खाल लावाकरता चांदीन्या चाळीस उथळ्या बनाडानं म्हणजे एक एक फळीना खाल चुलाकरता दोन दोन खाचा; ");
INSERT INTO ahr_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","त्याप्रमानं निवासमंडपन्या दुसरी म्हणजे उत्तर बाजुकरता वीस फळया बनाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","त्याकरता चांदीन्या चाळीस खाचा बनाडानं म्हणजे एक एक फळीनं खाल दोन दोन खाचा. ");
INSERT INTO ahr_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","निवासमंडपनी मांगेनी म्हणजे पश्चिम बाजुकरता सव फळया बनाडानं; ");
INSERT INTO ahr_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","अनी मांगली बाजुले निवासमंडपन्या कोपरासकरता दोन फळया बनाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","हया फळया खालपाईन दोनदोन राहीसनं त्या दोनी वरना भागले एक एक कडीघाई जोडी टाकानं, अनी दोनी फळया आशेच राहावाले पाहिजे; दोनी कोपरासकरता आशे फळया राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","आठ फळया अनी त्यान्या चांदीन्या सोळा खाचा राहावाले पाहिजे, अनी एक एक फळीनं खाल दोन दोन खाचा राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","अनी बाभुळना लाकडासना अडसर तयार करानं; निवासमंडपनं एक बाजुना फळीकरता पाच, ");
INSERT INTO ahr_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","अनी दुसरी बाजुनी फळीकरता पाच अनी त्याना पश्चिमले म्हणजे मांगली बाजुकरता पाच अडसर बनाडान्यात. ");
INSERT INTO ahr_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","अनी फळयासना मजारमा लावानं मजारनं अडसर तंबूना एक शेवटपाईन दुसरा शेवटपावोत जावाले पाहिजे आशे राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","त्या फळया सोनाघाई मढावानं अनी अडसर लावाकरता कडया सोनान्या बनाडान्यात, अनी अडसरबी सोनाघाई मढावानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","मी तुले पर्वतवर दखाडेल प्रमानं निवासमंडप उभं करानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","तशेच निया, जांभया अनी किरमिजी रंगनं अनी कातेल तलम सणसनं सुतनं एक आंतरपट बनाडानं अनी त्यानावर चतुर कारागीरकडतीन करुब काढी लेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","हाई पट सोनाघाई मढायेल बाभुळनं लाकुडनं चार खांबवर लटकाढानं, त्यान्या आकडया सोनान्या राहावाले पाहिजे अनी ते खांब चांदीन्या चार खाचासमां उभं करानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","आंतरपट आकडयासनाखाल लटकाढीसनं त्यानाआड मजारनी बाजुले आज्ञापटनी कोश ठेवानं; हाई आंतरपट पवित्रस्थान अनी परम पवित्रस्थान हाई तुमले येगळं करी. ");
INSERT INTO ahr_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","मंग पवित्रस्थानमां आज्ञापटना कोशवर दयासन ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","अनी त्या आंतरपटनाबाहेर निवासमंडना उतर बाजुले मेज ठेवानं अनी दक्षिण बाजुले मेजनामोरे दिवट ठेवानं; ");
INSERT INTO ahr_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","अनी तंबूना दारकरता निया, जांभया अनी किरमिजी रंगन अनी कातेल तलम सणसनं सुतनं वेलबुट्टीदार पडदा बनाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","या पडदाकरता बाभुळना लाकडसना पाच खांब करानं अनी ते सोनाघाई मढावानं; त्यासना आकडा सोनानं राहावाले पाहिजे अनी त्यानाकरता पितळन्या पाच खाचा वती टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","बाभुळना लाकडसना पाच हात लांब अनी पाच हात रुंदी आशी एक वेदी बनाड; ती चौकोन राहीसनं तिनी उंची तीन हात राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","तिन्या चारी कोपरासले चार शिंग बनाडानं; ते शिंग तिना आंगनच राहावाले पाहिजे; हाई वेदी पितळघाई मढावानं. ");
INSERT INTO ahr_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","त्यामाधली राख उचलीसनं ली जावाकरता भांडा, त्याप्रमानं तिनाकरता पावडी, कटोरा, काटे अनी अग्नीपात्र बनाडानं; तिना बठा भांडा पितळनं राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","तिनाकरता पितळनं जाळीनं एक चाळण बनाडानं अनी तिना चारी कोपरासले पितळनं चार कडया लावानं. ");
INSERT INTO ahr_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","हाई चाळन वेदीना आजुबाजूले कंगोरानं खाल आशे लावानं की ती वेदीना अर्धा उचा राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","वेदीकरता बाभुळना लाकुडनं दांड बनाड अनी ते पितळघाई मढाई लेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","त्या दांडा कडामां घालानं म्हणजे जवय जवय उचलामां येई तवय तवय तिना दोनी बाजुले त्या राहातीन. ");
INSERT INTO ahr_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","वेदीमां पोकय ठेईसनं अनी बाजुले फया लाईसनं बनाडानं; पर्वतवर दखाडेल प्रमानं ते करानं. ");
INSERT INTO ahr_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","निवासमंडपले आंगन कर; त्याना दक्षिण बाजुले कातेल तलम सणसनं ईनेल पडदा मिळीसनं त्यासनी लांबी एक बाजुले शंभर हात राहावाले पाहिजे; ");
INSERT INTO ahr_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","त्यासले वीस खांब करानं अनी त्या खांबसले पितयन्या वीस खाचा करी लेवानं; खांबासना आकडा अनी त्यासनी साखय चांदीनी करानी; ");
INSERT INTO ahr_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","त्याप्रमानं आंगणनं उतर बाजुलेबी शंभर हात लांबना पडदा राहावाले पाहिजे; त्यासले ईस खांब राहीसनं त्यासले वीस खाचा राहावाले पाहिजे अनी त्या खांबासना आकडा अनी साखया चांदीन्या राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","आंगणनं रुंदीकडला भागमां म्हणजे पश्चिमले पनास हात पडदा राहावाले पाहिजे; त्यासना खांब दहा अनी खाचा दहा राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","पुर्व बाजुले आंगणनी रूंदी पनास हात राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","अनी आंगणनं दारनं एक बाजुले पंधरा हात पडदा राहावाले पाहिजे; त्यासना खांब तीन अनी खाचा तीन राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","अनी दारना दुसरी बाजुले पंधरा हात पडदा राहीसन त्यासलेबी तीन खांब अनी तीन खाचा राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","आंगणनं दारकरता एक पडदा बनाडानं; तो निया, जांभया अनी किरमिजी रंगनं कातेल तलम सणनं सुतना वेलबुट्टीदार राहावाले पाहिजे; तो वीस हात राहीसनं त्याले चार खांब अनी चार खाचा राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","आंगणनं आजुबाजूना बठा खांब चांदीन्या साखयासघाई जोडेल राहावाले पाहिजे; त्यासना आकडा चांदीन्या अनी खाचा पितळन्या राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","आंगणनी लांबी शंभर हात अनी रूंदीनासारखा पन्नास हात अनी पडदानी उंची पाच हात राहावाले पाहिजे; त्याना पडदा कातेल सणसना सुतनं राहीसनं त्यान्या खांबन्या खाचा पितळनं राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","निवासमंडपमासला बठा उपकरनं सामान त्याना बठा खुट, अनी आंगणनं बठा खुट पितळना राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","तु इस्त्राएल लोकेसले आशे आज्ञा करानं की दिवा कायमनं पेटेल राहावाले पाहिजे त्यासनी दिवटकरता जैतुननं कुटीसनं काढेल शुध्द तेल लिसनं येवानं. ");
INSERT INTO ahr_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","आज्ञापटनामोरे ज्या आंतरपट शेतस त्या आंतरपटनाबाहेर दर्शनमंडपमां अहरोन अनी त्याना पोर्‍या यासनी तो दिवट संध्याकायपाईन ते सकायपावोत परमेश्वरनामोरे उजाळानी व्यवस्था करानी; हाई इस्त्राएल लोकेसकरता पिढयानपिढया कायमनं विधी शे. ");
INSERT INTO ahr_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","तुना भाऊ अहरोन यानी याजक हाई नातातीन मनी सेवा कराले पाहीजे म्हणीसनं त्यासले अनी त्यानासंगे त्याना पोर्‍या नादाब, अबीहू, एलाजार अनी इथामार यासले इस्त्राएल लोकेसमाईन मनाकडे लई ये; ");
INSERT INTO ahr_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","अनी गौरव अनी शोभा व्हावाकरता तु आपला भाऊ अहरोन यानाकरता पवित्र कपडा बनाड; ");
INSERT INTO ahr_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","अनी ज्या बुध्दीवान शेतस अनी ज्यासनामां मी बुध्दीना बठा प्रेरणा करेल शे अनी‍ त्या बठासले तु अहरोनना कपडा तयार करानी आज्ञा दे; त्यामुये त्या मनाकरता याजकनं काम चालाडाकरता पवित्र व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","त्यासनी तयार कराना कपडा हया शेतस; उरपट, एफोद, झगा, बुट्टीदार अंगरखा, फेटा अनी कमरबंद; हया पवित्र कपडा तुना भाऊ अहरोन अनी त्याना पोर्‍या यासले करानं; यानाकरता की त्यासनी याजकना नातातीन मनी सेवा करानी. ");
INSERT INTO ahr_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","त्यासनी सोनानं धागा अनी निया, जांभया अनी किरमिजी रंगनं सुत अनी तलम सणनं कपडा लेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","एफोद सोनानं धागानं अनी निया, जांभया अनी किरमिजी रंगनं सुतनं अनी तलम सणनं कापडनं चतुर कारागीरकडतीन तयार करी लेवानं; ");
INSERT INTO ahr_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","त्यान्या दोन खांदपटट्या जोडेल राहावाले पाहिजे; अनी त्याना दोन टोक शेवट जोडानं; ");
INSERT INTO ahr_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","एफोद बांधाकरता त्यानावर कारागीरनी ईनेल पट्टी राहास तिनी बनावट तिनासारखाच राहीसनं ती अखंड राहावाले पाहिजे; सोनानं धागानं अनी निया, जांभया अनी किरमिजी रंगनं सुतनं अनी तलम सणनं कापडनी राहावाले पाहिजे; ");
INSERT INTO ahr_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","मंग दोन गोमेद रत्न लिसनं त्यानावर इस्त्राएल पोर्‍यासनं नाव कोरानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","त्यासना नावसमाईन सव नावे एक रत्नावर अनी बाकीना सव नावे दुसरा रत्नावर त्यासना जन्मना क्रमतीन कोरानं; ");
INSERT INTO ahr_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","रत्नासवर कोरीव काम करनारा सोनारसघाई मुद्रा कोरतसं त्याप्रमानं त्या दोनी रत्नासवर इस्त्राएलना पोर्‍यासना नावे कोरानं अनी ती सोनानं जाळीदार कोंदणमां बसाडानं; ");
INSERT INTO ahr_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","त्या दोनी रत्ना एफोदना दोनी खांदपट्टयासले लावनं; ती इस्त्राएल पोर्‍यासना स्मारकरत्न वतीन, म्हणजे अहरोन त्यासना नाव परमेश्वरनामोरे आपला दोनी खांदासवर आठवन‍ म्हणीसनं वागाडतीन. ");
INSERT INTO ahr_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","त्याप्रमानं सोनानी जायीदार कोंदण करानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","पीळ घालेल दोरीनासारखा दोन साखया शुध्द सोनानं बनाडानं अनी त्या पीळ घालेल साखया त्या कोंदणमां बसाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","न्यायनं उरपटबी मोठा चतुर कारागीरकडतीन तयार करी लेवानं; एफोदप्रमानं तो सोनानं धागानं अनी निया, जांभया अनी किरमिजी रंगनं सुतनं अनी कातेल तलम सणसनं कापडनं बनाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","तो चौकोन अनी दुहेरी राहावाले पाहिजे अनी त्यानी लांबी अनी रूंदी एक एक ईत राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","त्यानामां रत्न टाकानं, रत्नासना चार रांगा राहावाले पाहिजे; पहिली रांगमां लाल पुष्कराज अनी माणिक; ");
INSERT INTO ahr_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दुसरी रांगमां पाचू, नीलमणी अनी हिरा; ");
INSERT INTO ahr_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तिसरी रांगमां तृणमणि, सुर्यकांत अनी पराग; ");
INSERT INTO ahr_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","अनी चवथी रांगमां लसणा, गोमेद अनी यास्फे; या बठा रत्न सोनानं खाचामां खोचानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","इस्त्राएल पोर्‍यासना नावसनी संख्याएवढी या रत्ना राहावाले पाहिजे; त्यासना संख्याप्रमानं बारा नाव राहावाले पाहिजे; मुद्रा जशी कोरतसं तशे बारा वंशमाईन एक एक नाव एक एक रत्नासवर कोरीसनं काढानं; ");
INSERT INTO ahr_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","दोरीनासारखा पिळ घालेल शुध्द सोनानं साखया उरपटवर लावानं; ");
INSERT INTO ahr_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","उरपटवार दोन सोनान्या कडया बनाडानात; त्या दोनी कडया उरपटन्या दोनी टोकले लावानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","उरपटनं शेवटले लायेल या दोन कडयासमां पीळ घालेल सोनान्या साखया टाकानं; ");
INSERT INTO ahr_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","पीळ घालेल दोनी साखयासनी दुसरी शेवटले दोनी खाचामा टाकीसनं त्या एफोदन्या दोनी खांदपट्टयासवार समोरनां भागमां लावानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","सोनान्या आजुन दोन कडया करीसनं उरपटना दोनी शेवटले म्हणजे एफोदना मजारनी बाजुले जे कोरी शेतस त्यानावर लावानं; ");
INSERT INTO ahr_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","सोनान्या आजुन कडया करीसनं एफोदन्या दोनी खांदपट्टयासवार खालनी बाजुले त्यानासमोर त्याना सांधानाजोडे ईनेल बुट्टीदार पटीवर लावानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","त्या उरपटन्या कडया एफोदन्या कडयासले निया पटीघाई बांधानं; याप्रमानं तो एफोदना बुट्टीवार राही, अनी त्यानापाईन येगळा व्हावाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","अहरोन पवित्रस्थानले प्रवेश करी तवय न्यायना उरपटवार, आपला मनमा, इस्त्राएलना नावं वागतीन; त्यामुये परमेश्वरनामोरे त्यासनी आठवण कायम राही. ");
INSERT INTO ahr_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","तु न्यायना उरपटमां उरीम अनी थुम्मीम ठेव अनी अहरोन परमेश्वरनामोरे येई तवय ते त्याना हृदयमां राहावाले पाहिजे; हाई प्रकारं अहरोननी इस्त्राएल लोकेसना न्याय आपला हृदयमा परमेश्वरनामोरे कायम वागाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“एफोदनासंगे घालेल झगा बठा निया रंगनं करानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","त्याना मजारमां डोक घालाकरता एक छिद्र राहावाले पाहिजे अनी त्याना आजुबाजूले चिलखतनं छिद्रले राहास तशे ईनेल गोट राहावाले पाहिजे म्हणजे झगा फाटाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","त्याना खालना घेरामां आजुबाजूले निया, जांभया अनी किरमिजी रंगनं सुतनं डाळींब काढानं अनी त्यासना मजारमां आजुबाजूले सोनानं घुंगरु लावानं; ");
INSERT INTO ahr_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","म्हणजे एक सोनानं घुंगरु अनी एक डाळींब, अनी परत एक सोनानं घुंगरु अनी एक डाळींब आशे झगानं खालना घेराना आजुबाजूले राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","सेवा करानं येळले तो झगा अहरोननी घाली लेवानं; जवय जवय तो पवित्रस्थाननं मजारमां परमेश्वरनामोरे जाई किवा बाहेर निंघी तवय तवय त्या घुंगरुसना आवाज व्हावाले पाहिजे, नाहीते तो मरी जाई; ");
INSERT INTO ahr_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","शुध्द सोनानी एक पट्टी बनाडानी अनी जशी मुद्रा कोरतसं तशी तीनावर हाई अक्षर कोरानं; परमेश्वरकरता पवित्र; ");
INSERT INTO ahr_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","अनी ती निया फितले आटकाडीसनं फेटाना मोरेना भागले लायेल राहावाले पाहिजे; ");
INSERT INTO ahr_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ती अहरोनना कपायले राहावाले पाहिजे, यानाकरता की इस्त्राएल लोके जेबी पवित्र करतीन म्हणजे जेवढया पवित्र भेट त्या आनतीन त्याबारामा जे दोष अहरोननी वाव्हाले पाहिजे; ती त्याना कपायले कायम राहावाले पाहिजे; यावरतीन परमेश्वर लोकेसवर प्रसन्न व्हयी. ");
INSERT INTO ahr_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","अंगरखा तलम सणसना नकशीदार ईनी लेवानं; तशेच एक फेटालेबी तलम सणनं करानं अनी वेलबुट्टीदार काढेल एक कमरबंद करानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","अहरोनना पोर्‍यासकरताबी अंगरखे, कमरबंद अनी फेटा बनाडानं; या कपडा गौरव अनी शोभा याकरता बनाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","तुना भाऊ अहरोन याले अनी त्यानासंगे त्याना पोर्‍यासले या कपडा घालीसनं अभिषेक अनी संस्कार करानं, अनी त्यासले पवित्र करानं म्हणजे त्या मनी सेवा याजक हाई नातातीन करतीन. ");
INSERT INTO ahr_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","त्याकरता सणसना चोळनं करानं, त्यासनी त्यासना आंग झाकेल राही; ते कंबरपाईन ते मांडीपावोत राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","अनी अहरोन नाहिते त्याना पोर्‍या दर्शनमंडपमां जातीन अनी पवित्रस्थानमां सेवा कराकरता वेदीनाजोडे जातीन तवय त्यासनी हाई चोळनं घालेल राहावाले पाहिजे, नाहिते त्याना दोष लागीसनं त्या मरतीन; अहरोनले अनी त्यानामांगे वंशले हाऊ नियम कायमनं शे.” ");
INSERT INTO ahr_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","त्यासनी याजक हाई नातातीन मनी सेवा करानी म्हणीसनं त्यासले पवित्र कराकरता जे तुले करानं शे ते हाई; एक वासरू अनी दोन निर्दोष मेंढा लेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","अनी बेखमीर भाकर, तेलमां मळेल बेखमीर चानकी अनी तेल लायेल बेखमीर चानकी लेवान्या; हया बठा गहुनं पिठनं राहवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","हया बठा एक टोपलीमां टाक अनी तो वासरू अनी मेंढा यासनासंगे ती टोपली लिसनं ये; ");
INSERT INTO ahr_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","मंग अहरोन अनी त्याना पोर्‍या यासले दर्शनमंडपना दारनामोरे लयीसनं आंग धव; ");
INSERT INTO ahr_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","अनी त्या कपडा लिसनं अहरोनले त्याना अंगरखा अनी एफोदना झगा घाल; त्याले एफोद अनी उरपट बांध अनी एफोदना बुट्टीदार पट्टा त्याना कंबरले बांध; ");
INSERT INTO ahr_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","त्याना डोकाले फेटा घाल अनी फेटाले पवित्र मुकूट लाव. ");
INSERT INTO ahr_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","मंग अभिषेकनं तेल त्याना डोकावर वतीसनं त्याले अभिषेक कर. ");
INSERT INTO ahr_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","मंग त्याना पोर्‍यासले जोडे आणीसनं त्यासना आंगमां अंगरखा घाल; ");
INSERT INTO ahr_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","अनी अहरोन अनी त्याना पोर्‍यासले कमरबंद बांध; त्यासना डोकासले फेटा बांध; याप्रकारं हाई कायमनं विधीतीन त्यासले याजकपद भेटाले पाहिजे. अहरोन अनी त्याना पोर्‍या यासना संस्कार करानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","तो वासरू दर्शनमंडपनामोरे लई येवानं. अहरोन अनी त्याना पोर्‍या यासनी आपला हात त्यासना डोकावर ठेवानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","मंग परमेश्वरनामोरे दर्शनमंडपना दारजोडे तो वासरू मारानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","वासरूनं रंगत लिसनं तु आपली आंगठीघाई ते वेदीना शिंगले लावानं अनी बाकीना बठा रंगत वेदीना पायनाजोडे वतानं. ");
INSERT INTO ahr_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","त्यानी आतडीवरनी बठी चरबी, काळीज वरना पडदा, दोनी गुर्दा अनी त्यानावरनी चरबी हाई बठा लिसनं त्यासना वेदीवर होम करानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","पण वासरूनं मास, त्याना कातडा अनी ईष्टा हाई छावनीनाबाहेर लिसनं आंगनमां जाळानं; कारन हाई पाप अर्पन बली शे; ");
INSERT INTO ahr_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","एक मेंढा लिसनं त्याना डोकावर अहरोन अनी त्याना पोर्‍या यासनी आपला हात ठेवानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","अनी तो मेंढा मारीसनं त्याना रंगत वेदीना आजुबाजूले शितडानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","मंग तो मेंढा कापीसनं त्याना तुकडा करानं अनी त्यानी आतडी अनी पाय धयीसनं ती त्याना तुकडा अनी डोकं यानासंगे ठेवानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","मंग बठा मेंढानं वेदीवर होम करानं; ते परमेश्वरकरता होमबली शे; तो परमेश्वरकरता मधुर सुगंध हवन शे; ");
INSERT INTO ahr_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","मंग दुसरा मेंढा लिसनं त्याना डोकावर अहरोन अनी त्याना पोर्‍या यासनी आपला हात ठेवानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","मंग तो मेंढा मारानं अनी त्याना काही रंगत लिसनं अहरोन अनी त्याना पोर्‍या यासना उजवा कानना शेंडाले अनी त्यासना उजवा हातना अनी उजवा पायना आंगठाले लावानं अनी बाकीना वेदीना आजुबाजूले शितडानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","वेदीवरना रंगत अनी अभिषेकनं तेल यामासला काही लिसनं अहरोनवर अनी त्याना कपडासवर, तशेच त्यानासंगे त्याना पोर्‍यासवर अनी त्यासना कपडासवर शितडानं; यावरतीन तो अनी त्याना कपडा अनी त्यानासंगे त्याना पोर्‍या अनी त्यासना कपडा पवित्र वतीन. ");
INSERT INTO ahr_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","तो मेंढा संस्कारना शे म्हणीसनं त्यानी चरबी, त्यानी चरबीदार शेपुट, त्यासनी आतडयासवरनी चरबी अनी काळीजनावरना पडदा, दोनी गुर्दा अनी त्यानावरनी चरबी अनी उजवा फरा हाई ले; ");
INSERT INTO ahr_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","त्याप्रमानं परमेश्वरनामोरे ठेयेल बेखमीर भाकरनी टोपलीमाईन एक भाकर तेलमां मळेल पिठनी एक चानकी अनी एक भाकर लेय; ");
INSERT INTO ahr_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","अनी या बठा अहरोन अनी त्याना पोर्‍या यासना हातवर ठेव अनी ते वोवाळनीनं अर्पन म्हनीसनं परमेश्वरनामोरे वोवाळ. ");
INSERT INTO ahr_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","मंग त्या वस्तु त्याना हातमाईन लिसनं वेदीवरना होमबलीवर होम करानं; हाई परमेश्वरनामोरे मधुर सुगंध शे; हाई परमेश्वरले अर्पन करेल हवन शे; ");
INSERT INTO ahr_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","मंग अहरोनना संस्कारकरता मारेल मेंढानं छाती लिसनं वोवाळनी म्हनीसनं परमेश्वरनामोरे वोवाळ; तो तुना हिसा शे; ");
INSERT INTO ahr_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","अनी अहरोन अनी त्याना पोर्‍या यासना संस्कारकरता मारेल मेंढानं वोवाळेल छाती अनी समर्पन करेल फरा हया तु पवित्र करानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","इस्त्राएल लोकेसकडतीन भेटनारा अहरोननं अनी त्याना पोर्‍यासना हाऊ कायमनं हक्क शे; हाई त्यासनाकडतीन इस्राएलसना शांती अर्पणनं यज्ञमाईन परमेश्वरकरता समर्पित करेल दान शे; ");
INSERT INTO ahr_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","अहरोननं पवित्र कपडा त्यानानंतर त्याना पोर्‍यासकरता राहावाले पाहिजे; हया कपडासनासंगे त्यासना अभिषेक व्हईन त्यासनावर संस्कार व्हवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","त्या पोर्‍यासमाईन जो त्याना जागवर याजक व्हयी त्यानी पवित्रस्थानमा सेवा कराकरता दर्शनमंडपमां जातस तवय हया कपडा सात रोज घालाले पाहिजे; ");
INSERT INTO ahr_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","संस्कारकरता मारेल मेंढा लिसनं त्याना मास एखादं पवित्र जागवर शिजाडं; ");
INSERT INTO ahr_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","मंग अहरोन अनी त्याना पोर्‍या यासनी त्या मेंढासना मास अनी टोपलीमाधली भाकर दर्शनमंडपना दारनाजोडे खावानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","त्यासना संस्कार अनी पवित्रकरन याकरता ज्या पदार्थासघाई प्रायश्चितविधी करामां येई त्या पदार्थ त्यासनी खावानं; पन दुसरा कुळमासला कोनीबी हाई खावानं नही; कारन त्या पदार्थ पवित्र शेतस; ");
INSERT INTO ahr_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","समर्पन करेल काही मास किवा भाकर सकासपावोत राहिनी तर उरेल आगमां जाळी टाकानं; ते खावानं नही कारन ते पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","मी तुले आज्ञा देयेल बठया गोष्टप्रमानं अहरोन अनी त्याना पोर्‍या यासनं कर; अनी सात रोजपावोत त्यासना संस्कार कर; ");
INSERT INTO ahr_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","प्रायश्चितकरता पापबली म्हणीसनं एक वासरू रोज बली दे अनी वेदीकरता प्रायश्चित करीसनं ती शुध्द करानं अनी पवित्र कराकरता तिले अभिषेक कराले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सात रोज वेदीकरता प्रायश्चित करीसनं ती पवित्र कर म्हणजे वेदी परमपवित्र व्हयी; ज्याना वेदीले हात लागी ते पवित्र व्हई; ");
INSERT INTO ahr_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","वेदीवर कायमनं होम करानं ते आशे; रोज एक एक वरीसनं दोन कोकरासना होम करानं. ");
INSERT INTO ahr_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एक कोकराना होम सकासले अनी दुसरा कोकराना होम संध्याकायले करानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","कुटिसनं काढेल दोन लिटर तेलमां, एक दशमांस माप पिठ मिळीसनं ते एक कोकरानासंगे अर्पन करानं; अनी दोन लिटर द्राक्षरसनं पेयार्पण करानं; ");
INSERT INTO ahr_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","दुसरा कोकरा सांयकायले अर्पाणं अनी त्यानासंगे सकायपरमानं अन्न पेयार्पण अनी पेय अर्पण करानं; हाई परमेश्वरकरता मधुर सुगंध हवन शे. ");
INSERT INTO ahr_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","तुमन्या पिढयानपिढया दर्शनमंडपना दारनाजोडे परमेश्वरनामोरे आशेच होमबली कायम अर्पानं; हाई जागवर तुनासंगे बोलाकरता मी तुमले भेटसू; ");
INSERT INTO ahr_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","हाई जागवर मी इस्त्राएल लोकेसले भेट दिसू अनी मना तेजघाई ते मंडप पवित्र व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","दर्शनमंडप अनी वेदी मी पवित्र करसुं; अहरोन अनी त्याना पोर्‍या यासनी याजक हाई नातातीन मनी सेवा करानी म्हनीसनं त्यासलेबी मी पवित्र करसुं. ");
INSERT INTO ahr_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","अनी मी इस्त्राएल लोकेसमां मना निवास करसुं अनी त्यासना देव व्हसू. ");
INSERT INTO ahr_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","त्यासनामां राहावाले जावाकरता ज्यानी त्यासले मिसर देशमाईन बाहेर काढ तो मी परमेश्वर त्यासना देव शे असं त्यासले कळी; मी त्यासना देव यहोवा शे. ");
INSERT INTO ahr_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","धुप जायाकरता एक वेदी बनाड; ती बाभुळनी लाकुडनी राहावाले पाहिजे; ");
INSERT INTO ahr_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","तिनी लांबी एक हात अनी रूंदी एक हात आशी ती चौकोन राहावाले पाहिजे; अनी तिनी उची दोन हात राहीसनं तिना शिंग आंगनच राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ती वेदीना वरना भाग अनी तीन्या चारी बाजु अनी तीना शिंग आशी ती बठी शुध्द सोनाघाई मढावानं; अनी तीना आजुबाजूले सोनानं कंगोरा बनाडानं. ");
INSERT INTO ahr_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","सोनान्या कडया बनाडीसनं त्या तिन्या कंगोरानंखाल तिन्या दोनी आंगले दोन कोनासले दोन दोन लाई देवानं; या कडयासमां वेदी उचली लई जावाना दांडा घालता येतीन. ");
INSERT INTO ahr_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","दांडा बाभुळना लाकुडना बनाडीसनं सोनाघाई मढाई लेवानं; ");
INSERT INTO ahr_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","आज्ञापटन्या कोशनाजोडे ज्या पडदा शेतस त्यासनासमोर, म्हणजे आज्ञापटवरला जे दयासनजोडे मी तुले दर्शन देत जासू त्यानामोरे हाई वेदी ठेवानी; ");
INSERT INTO ahr_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","हाई वेदीवर अहरोननी सुगंधी द्रवघाई धुप जाळानं; रोज सकासले तो तेलवात करी तवय हाई धुप त्यानी जाळानं. ");
INSERT INTO ahr_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","तशेच संध्याकायले तो दिवा लाई तवय त्यानी कायम धुप जाळानं; हाई धुप तुम्हीन पिढयानपिढया कायम परमेश्वरनामोरे जायत राहावानं. ");
INSERT INTO ahr_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","त्यानावर येगया धूप, होमबली, अन्नबली तशेच कोनतेबी प्रकारनं पेयार्पण करानं नही; ");
INSERT INTO ahr_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","अहरोननी वरीसमां एकदाव तिना शिंगासले प्रायश्चित करानं; पिढयानपिढया वरीसमां एकदाव प्रायश्चितकरता अर्पन करेल पापबलीनं रंगतघाई तिनाकरता त्यानी प्रायश्चित करानं; हाई वेदी परमेश्वरकरता परमपवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","मंग परमेश्वर मोशेले बोलना; ");
INSERT INTO ahr_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","तु इस्त्राएल लोकेसना संख्याप्रमानं त्यासनी मोजनी करशी तवय मोजानं येळले त्यासनावर मरी येवाले नही पाहिजे‍ म्हनीसनं त्यासनामाईन प्रत्येकनी आपला जीवबद्दल परमेश्वरले त्या येळले खंड देवानं. ");
INSERT INTO ahr_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","जेवढा लोकेसनी मोजनी व्हई तेवढासनी पवित्रस्थानमासला शेकेलना चलनप्रमानं अर्धा शेकेल देवानं. शेकेल म्हणजे वीस गेरे हाऊ आरधा शेकेल परमेश्वरकरता समर्पित करेल हिस्सा शे. ");
INSERT INTO ahr_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","वीस वरीसना अनी त्यानापेक्षा जास्त वयना लोकेसमां ज्यासनी मोजनी व्हई त्यामाधला प्रत्येकनी परमेश्वरकरता हाऊ हिस्सा अर्पण करानं; ");
INSERT INTO ahr_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","तुम्हीन आपला जीवबद्दल प्रायश्चित म्हनीसनं परमेश्वरकरता हाऊ हिस्सानं अर्पण करशात तवय मोठा लोकेसनी अर्धा शेकेलनावर देवानं नही, किवा गरीब लोकेसनी त्यानापेक्षा कमी देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","इस्त्राएल लोकेसपाईन प्रायश्चितना पैसा लिसनं दर्शनमंडपनं कामले लावानं; हाऊ पैसा इस्त्राएल लोकेसना जीवबद्दल प्रायश्चित देयेलनं स्मारक म्हनीसनं त्यासनाकरता परमेश्वरनामोरे राही; ");
INSERT INTO ahr_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","मंग परमेश्वरनी मोशेले सांग; ");
INSERT INTO ahr_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","धवाकरता तु पितळनं एक भांड बनाडानं; त्याले पितळनी बैठक करानी; ते दर्शनमंडप अनी वेदी यासना मजारमां ठेईसनं त्यामां पानी भरानं. ");
INSERT INTO ahr_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","अहरोन अनी त्याना पोर्‍यासनी आपला हातपाय त्यामा धवानं; ");
INSERT INTO ahr_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","दर्शनमंडपमां जावानं आगोदर अनी वेदीपान सेवा कराकरता म्हणजे परमेश्वरकरता हवन जाळाले जावानं येळले त्यासनी आपला हातपाय धवानं, नाहिते त्या मरतीन. ");
INSERT INTO ahr_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","हाई प्रकारंतीन त्यासनी हातपाय धवानं, नाहिते त्या मरतीन; अहरोन त्याना वंश यासनाकरता पिढयानपिढया हाई कायमनं विधी व्हावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","मंग परमेश्वरनी मोशेले सांगं; ");
INSERT INTO ahr_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","तु उत्तम प्रकारनं मसाला ले, म्हणजे पवित्रस्थाननं चलनप्रमानं पाचशे शेकेल पाक गंधरस, त्याना निमा म्हणजे अडीचशे शेकेल सुगंधी दालचिनी अडीचशे शेकेल सुगंधी बच, ");
INSERT INTO ahr_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","सहा किलो तेजपान, अनी चार लिटर जैतुननं तेल हाई लिसनं. ");
INSERT INTO ahr_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","त्यासना अभिषेकनं पवित्र तेल म्हणजे गंधनं रिवाजप्रमानं एकजागे करेल सुगंधी तेल तयार कर; हाई अभिषेकनं पवित्र तेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","हाई तेलघाई दर्शनमंडप अनी आज्ञापटनं कोश, ");
INSERT INTO ahr_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","मेज अनी त्यानावरना बठा सामान, दिवट अनी त्यासना उपकरनं, धुपवेदी, ");
INSERT INTO ahr_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","होमवेदी अनी तिना बठा सामान अनी बैठकनासंगे पितळना भांडा यासले अभिषेक करानं; ");
INSERT INTO ahr_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","त्यासले पवित्र करानं म्हणजे ती परमपवित्र व्हतीन; ज्याना हातना स्पर्श त्यासले व्हई त्या पवित्र व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","अनी याजक हाई नातातीन मनी सेवा कराकरता अहरोन अनी त्याना पोर्‍या यासले अभिषेक करीसनं पवित्र करं; ");
INSERT INTO ahr_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","इस्त्राएल लोकेसले मनी हाई आज्ञा सांग पिढयानपिढया तुमले मनाकरता पवित्र अभिषेकनं तेल हाईच राही. ");
INSERT INTO ahr_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","हाई तेल कोनतेबी माणसासनी आंगले लावानं नही अनी यानासारखा एखादानी मिळाडानं नही; हाई पवित्र शे; अनी याले पवित्र समजानं. ");
INSERT INTO ahr_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","एखादानी त्यासासारखा मिळाडीसनं तयार करं किवा एखादाले ते लावं तर त्यानी मोजणी करामा येवाव नही. ");
INSERT INTO ahr_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","मंग परमेश्वर मोशेले बोलना तु सुंगंधी मसाला म्हणजे उत्तम गंधरस, जटामासी, गंधबिरुजा अनी शुध्द उद हाई लेवानं; हाई बठा एकसारखं लेवानं; ");
INSERT INTO ahr_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","अनी गंधनं रिवाजप्रमानं मीठ मिळाडीसनं निर्मळ, शुध्द अनी पवित्र आशे धुपद्रव्य तयार करान: ");
INSERT INTO ahr_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","त्यामासलं काही कुटिसनं त्यानी बुकटी करानं अनी ती जराशी लिसनं दर्शनमंडपमासला जे कोशनामोरे मी तुले दर्शन देत जासू त्यामां ठेवानं; ती तुम्हीन परमपवित्र समजानं. ");
INSERT INTO ahr_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","जे धुपद्रव्य तु तयार करशी त्यानासारखा मिळाडीसनं तुम्हीन कोनीबी स्वताले तयार करानं नही; हाई परमेश्वरकरता पवित्र समजानं. ");
INSERT INTO ahr_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","कोनी वास लेवाकरता आशे काही तयार करी तर त्यानी मोजणी करामा येवाव नही. ");
INSERT INTO ahr_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","मंग परमेश्वरनी मोशेले सांगं; ");
INSERT INTO ahr_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","दख मी यहुदा वंशमाधला उरीना पोर्‍या अनी हूरना नातु बसालेल याले नाव लिसनं बलावं शे; ");
INSERT INTO ahr_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","देवनं आत्माघाई मी त्याले परिपुर्ण करीसन आक्कल, बुध्दी ज्ञान अनी सर्वा प्रकारनी कला देयेल शे; ");
INSERT INTO ahr_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","तो कलाकसरीनी काम करी, सोना, रुपे अनी पितळ यासनं काम करी. ");
INSERT INTO ahr_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","जडावाकरता रत्नासना पैलु पाडी, लाकडासना नक्षीदार काम करी अनी आशे सर्व प्रकारनं कारागीरनं काम करी. ");
INSERT INTO ahr_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","अनी दख, त्याना जोडीले मी दान वंशमाधला अहीसामाखना पोर्‍या अहलियाब याले नेमेल शे; एवढच नाहिते जेवढा बुध्दीवान शेतस त्या बठासना मनमां मी बुध्दी ठेयेल शे; ती यानाकरता की ज्या गोष्टीसनाबारामां मी तुले आज्ञा करेल शे त्या सर्वा त्यानी करान्यात; ");
INSERT INTO ahr_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","म्हणजे दर्शनमंडप, आज्ञापट अनी त्यानावरना दयासन अनी तंबुना बठा सामान, ");
INSERT INTO ahr_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","मेज अनी त्यानावरना बठा सामान, शुध्द दिवट अनी त्याना बठा उपकरनं, धुपवेदी, ");
INSERT INTO ahr_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","होमवेदी अनी तिना बठा सामान अनी पितळनं भांड अनी त्यानी बैठक, ");
INSERT INTO ahr_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","सेवाकरता ईनेल तलम कपडा अनी याजकनं काम चालाडाकरता अहरोन याजकना पवित्र कपडा, त्याना पोर्‍यासना कपडा. ");
INSERT INTO ahr_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अभिषेकन तेल अनी पवित्रस्थानकरता सुगंधी द्रव्यनं धूप या बठासना बारामां मी तुले आज्ञा देयेल शे त्याप्रमानं त्या करतीन. ");
INSERT INTO ahr_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","मंग परमेश्वर मोशेले बोलना; ");
INSERT INTO ahr_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","तु इस्त्राएल लोकेसले आजुन आशे सांग, तुमीन मना शाब्बाथ पक्का पाळानं; कारन तुमन्या पिढयानपिढया मनामां अनी तुमनामां हाई एक खूण राही; यावरतीन आशे समजानं की मी तुमले पवित्र करनारा परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","त्याकरता तुमीन शाब्बाथ पाळानं; ते तुमनाकरता पवित्र शे, जर एखादा ते भ्रष्ट करी त्याले पक्का मारी टाकानं; एखादा त्यारोजले एखादं काम करी तर त्याले आपला लोकसमाईन काढी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","सव रोज काम करानं, पण सातवा रोजले, तुमले परमेश्वरकरता पवित्र दिवस, परम विश्रामनं शाब्बाथ शे; कोनी शाब्बाथना रोज काम करी, त्याले नकी मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इस्त्राएल लोकेसनी शाब्बाथ पाळानं; हाई कायमनं करार समजीसनं ते पिढयानपिढया पाळानं. ");
INSERT INTO ahr_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","मनामां अनी इस्त्राएल लोकेसमां हाई कायमनी खूण शे; कारन परमेश्वर सव रोजमां आकाश अनी पृथ्वी बनाडीसनं सातवा रोजले आराम करं अनी काम थांबाडं. ");
INSERT INTO ahr_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","परमेश्वरनी मोशेनीसंगे सीनाय पर्वतवर हाई बठा भाषण करानंतर आपला बोटघाई लिखेल दगडन्या दोन आज्ञापट त्याले दिधं. ");
INSERT INTO ahr_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","मोशेले परवतवरतीन येवाले येळ लागनं हाई इस्राएल आशे लोकेसनी दख तवय त्या अहरोनना आजुबाजूले जमीसनं त्याले बोलनात, “उठ, आमनामोरे चालतीन आशे देव आमनाकरता बनाड; कारन आमले मिसर देशमाईन बाहेल लयी आननारा माणुस मोशे यानं काय व्हयनं हाई आमले माहित नही?” ");
INSERT INTO ahr_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","तवय अहरोननी त्यासले सांग तुमन्या बाया, पोर्‍या अनी पोरी यासना कानमां सोनान्या कुंडल्या शेतस त्या काढीसनं मनाकडे लई या; ");
INSERT INTO ahr_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","मंग बठा लोकेसनी आपला कानमासला कुंडल्या काढीसनं अहरोनकडे आणं. ");
INSERT INTO ahr_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","तवय अहरोननी त्यासना हातमाईन लिधं, अनी एक साचामा टाकात, अनी एक वासरूनी मूर्ती बनाडी; तवय त्या बोलाले लागनात, हे इस्त्राएला, ज्या देवनी तुले मिसर देशमाईन सोडाईसनं आनेल शे त्याच हया तुना देव. ");
INSERT INTO ahr_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","हाई दखीसनं अहरोननी त्यासनामोरे एक वेदी बांधी अनी जाहीर करं की सकाय परमेश्वरकरता उत्सव करानं शे; ");
INSERT INTO ahr_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","मनीसनं दुसरा रोज लोके पहाटले उठीसनं होमबलीनं अर्पन करं अनी शांती अर्पन लयात; मंग त्या खावाले पेवाले बसनात अनी ऊठीसनं मोजमस्ती कराले लागनात. ");
INSERT INTO ahr_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","तवय परमेश्वर मोशेले बोलना; चाल, खाल उतर, कारन ज्या तुना माणसे तु मिसर देशमाईन आणेल शे त्या बिघडी जायेल शेतस; ");
INSERT INTO ahr_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ज्या मार्गतीन त्या जावाले पाहिजे व्हतात मनीसनं मी त्यासले आज्ञा देयेल व्हती तो मार्ग सोडीसनं त्या बहकी जायेल शेतस; त्यासनी ओतीव वासरु बनाडीसनं त्यानी पुजा आरचा करी अनी त्याले बली अर्पन करं अनी हे, इस्त्राएला, ज्यानी तुले मिसर देशामाईन सोडायेल शे त्याच हया तुना देव आशे त्या बोलाले लागना शेतस. ");
INSERT INTO ahr_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","मंग परमेश्वनी मोशेले सांगं, मी या लोकेसले दखी लियेल शे या फक्त ताठ मानना लोके शेतस; ");
INSERT INTO ahr_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","तर माले आडवं येवानं नही; मी मना कोप त्यासनावर भडकावसू त्यासले भस्म करसू अनी तुनाच एक राष्ट्र बनाडसू. ");
INSERT INTO ahr_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","तवय मोशे आपला देव यहोवा यानी किवा कराले लागना, हे परमेश्वरा, तु आपला माणसासले महासामर्थ्यातीन अनी भुजबळतीन मिसर देशमाईन सोडाई आनेल शे त्यासनावर तुना कोप काबर भडकाले पाहिजे? ");
INSERT INTO ahr_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","त्यासले पहाडमां मारी टाकानं अनी पृथ्वीवरतीन त्यासले नष्ट करानं मनीसनं त्यासले मिसर देशमाईन परमेश्वरनी बाहेर काढं आशे मिसरी लोकेसनी बोलानं का? आपला कोपपाईन दुर व्हय, आपला लोकेसवर अरिष्ट आणानं तू ठरायेल शे त्यापाईन दुर व्हय. ");
INSERT INTO ahr_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","तुन दास अब्राहाम, इसहाक अनी इस्त्राएल यासनी आठवन करं; तु त्यासले सोतानी शपथ लिसनं सांग व्हतं की तुमनी संतती आकाशमाधली तारासनीसारखी बहुगुनित करसू, अनी हया देशनीबारामां मी तुमले सांगं तो बठा तुमनी संततीले दिसू अनी ती त्यासनी कायमनी वतनदार व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","तवय मी मना लोकेसनी अनिष्ट करसू आशे जे परमेश्वरनी सांगं व्हतं त्यापाईन तो दुर व्हयना. ");
INSERT INTO ahr_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","मंग मोशे मांगे फिरसनं आपला हातमां आज्ञापटन्या त्या दोन पाटया लिसनं डोंगरवरतीन खाल वना; त्या पाटयासवर मोरेना अनी मांगेना आशे दोनी बाजुले लिखेल व्हतं; ");
INSERT INTO ahr_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","हया पाटया देवनी बनाडेल व्हत्या अनी त्यानावर खोदेल लेख देवनी लिखेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","यहोशवाने लोकेसना आवाज आयकं तवय तो मोशेले बोलना, छावनीमां रनशब्द ऐकू ई राहिनं शे. ");
INSERT INTO ahr_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","तो बोलना, हाई शब्द जे‍ व्हई राहिनं शे, तो नही विजय व्हयेलसना, नही हारेलसना, मना कानवर पडी राहिना शे, तो तर गाणानं आवाज शे. ");
INSERT INTO ahr_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","मोशे छावनीनाजोडे येवानंतर ते वासरू अनी नाचनारा माणसे त्याना नजरमां वनात, तवय त्याले राग वना अनी त्यानी आपली हातमाधली पाटया पर्वतना पायथाले फेकीसनं फोडी टाकं. ");
INSERT INTO ahr_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","तशेच त्यासनी बनाडेल ते वासरू लिसनं त्यानी आगमां टाकं अनी त्याना कुटीसनं चुरा करी टाकं; ते त्यानी पानीमा टाकं अनी ते पानी त्यानी इस्त्राएल लोकेसले पेवाले दिधं. ");
INSERT INTO ahr_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","तवय मोशे अहरोनले बोलना, तु या लोकेसले एवढं पापमां टाक आशे यासनी तुनं काय करं व्हत? ");
INSERT INTO ahr_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","अहरोन बोलना, मना स्वामीना कोप मनावर येवाले नही पाहिजे; या माणसासनी प्रवृती पापकडे शे हाई तुलेबी माहीत शे. ");
INSERT INTO ahr_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","त्यासनी माले सांगं की आमनामोरे चालतीन आशे देव आमनाकरता बनाड; कारन आमले मिसर देशमाईन बाहेर आननारा माणुस मोशे यानं काय व्हयनं ते आमले माहित नही. ");
INSERT INTO ahr_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","मी त्यासले सांगं, ज्यानाजोडे सोनं व्हई त्यानी काढीसनं माले देवानं; त्याप्रमानं त्यासनी ते माले दिधं; ते मी आगमां टाकात तवय त्यामाईन वासरू बनना; ");
INSERT INTO ahr_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मोशेनी दखं हया माणसे बेलगाम व्हई जायेल शेतस; अहरोननी त्यासले बेलगाम होऊ दिधं त्यामुये त्या शत्रुसना मजाक पात्र व्हयनात; ");
INSERT INTO ahr_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","तवय तो छावनीना परवेशना ठिकानले उभा राहीसनं बोलना, परमेश्वरनाकडतीन ज्या व्हतीन त्यासनी मनाकडे येवानं, तवय लेवी वंशमाधला बठा माणसे त्यानाजोडे जमा व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","तो त्यासले बोलना, इस्त्राएलना देव यहोवा सांगस की तुम्हीन प्रत्येकसनी आपली कंबरले तलवार लटकाडानं अनी छावनीना हाई प्रवेश दारपाईन ते त्या प्रवेश दारपावोत सगळीकडे फिरीसनं आपला भाऊ, संगेना, शेजारना, या बठा माणसासले मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","मोशेनी आज्ञाप्रमानं लेवी वंशमाधला लोकेसनी करं अनी त्या रोज तीन हजार लोकेसले मारी टाकं; ");
INSERT INTO ahr_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","मंग मोशे बोलना, परमेश्वरकरता आपला समर्पन करीसनं प्रत्येक माणुसनी आपला पोर्‍या राहो का भाऊ राहो, त्यानावर चाली गयात म्हणजे परमेश्वर आज तुमले वरदान देई. ");
INSERT INTO ahr_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","दुसरा रोजले मोशे लोकेसले बोलना, तुमीन हाई घोर पाप करेल शे, तरी मी आते परमेश्वरकडे जासं, माले कदाचित तुमना पापकरता प्रायश्चित करनं पडी. ");
INSERT INTO ahr_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","मोशे परत परमेश्वरकडं जाईसनं बोलना, हाय! हाय! या लोकेसनी घोर पाप करेल शे, यासनी त्यासनाकरता सोनानं देव बनाडं; ");
INSERT INTO ahr_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","तरी आते तु त्यासना पापसनी क्षमा करीशी ते; नही करशीते तर तु लिखेल पुस्तकमाईन माले काढी टाक. ");
INSERT INTO ahr_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","परमेश्वर मोशेले बोलना, ज्यासनी मनाविरोधमां पाप करेल शे त्यालेच मी मना पुस्तकमाईन काढी टाकसू. ");
INSERT INTO ahr_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","आते तु जाय, ज्या ठिकाननाबारामां मी तुले सांगेल शे तिकडे त्यासले लई जाय; दख, मना दूत तुनामोरे चालतीन, तरी ज्या रोज मी झडती लिसू त्या रोज त्यासना पापना बारामा समाचार लिसू. ");
INSERT INTO ahr_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","अहरोननी बनाडेल वासरू लोकेसनीच बनाडेल व्हतं, त्याकरता परमेश्वरनी त्यासनावर पिढा धाडी. ");
INSERT INTO ahr_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","मंग परमेश्वरनी मोशेले सांगं, तु अनी ज्या माणसे तु मिसर देशमाईन आनेल शेतस त्या, आठेन निघीसनं मार्गस्थ व्हावानं; अनी जो देश तुनी संततीले दिसू आशे अब्राहाम, इसहाक अनी याकोब यासले मी शपथ दिसनं सांगेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","मी तुनामोरे एक दूत धाडसू अनी कनानी, अमोरी, हित्ती, परिज्जी, हिव्वी अनी यबूसी यासले मी हाकली दिसु. ");
INSERT INTO ahr_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","दुधमधनं प्रवाह वाही राहीना शेतस त्या देशमां तू जाय; तरीबी तुम्हीन ताठ मानना लोके शेतस त्यामुये मी तुनासंगे येवावू नही; वनुते रस्तामां मी तुमले भस्म करसू. ");
INSERT INTO ahr_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","लोकेसनी हाई वाईट बातमी ऐकी तवय त्या विलाप कराले लागनात; अनी कोनीबी आपला दागदागिना घालात नही. ");
INSERT INTO ahr_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","परमेश्वर मोशेले बोलना, तु इस्त्राएल लोकेसले सांग की तुमीन ताठ मानना लोके शेतस; मी थोडा येळबी तुमनासंगे राहीनू तर मी तुमले भस्म करसू; त्याकरता तुमीन आपला दागदागिना आपला आंगवरतीन उतारी ठेवानं; म्हणजे तुमनं काय करानं ते मी दखसू. ");
INSERT INTO ahr_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","यामुये होरेब पर्वतपाईन इस्त्राएल लोक बिन दागदागिनना राहीनात. ");
INSERT INTO ahr_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मोशे छावनीबाहेर बराच दुर जाईसनं तंबू लिसनं उभा करी; अनी त्याले तो दर्शनमंडप सांगे, कोणले परमेश्वरले काही ईचारानं व्हई म्हणजे तो छावनीबाहेर त्या दर्शनमंडपकडे जायेत. ");
INSERT INTO ahr_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","आशे व्हस जास की जवय मोशे त्या मंडपजोडे जाये तवय बठा लोके उठीसनं‍ ज्यानात्याना तंबूमां दारपान उभा राहेत अनी तो मंडपमा जातस तोपावोत त्यानाकडे नजर लावेत. ");
INSERT INTO ahr_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","मोशे मंडपमां प्रवेश करे तवय मेघस्तंभ उतरीसनं मंडपना दारपान उभा राहे, अनी परमेश्वर मोशेनीसंगे भाषण करे. ");
INSERT INTO ahr_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","त्या मंडपना दारपान मेघस्तंभ ऊभा शे आशे बठा लोके दखेत तवय त्या बठा उठीसनं ज्यानात्याना तंबुना दारपान दंडवत घालेत. ");
INSERT INTO ahr_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","एखादा मित्रनंसंगे भाषन करतसं तशे परमेश्वर मोशेनीसंगे समोरासमोर भाषन करे. मोशे छावनीकडे परत येस, तरी त्याना सेवक नुनाना पोर्‍या यहोशवा हाऊ तरुण माणुस मंडप सोडीसनं बाहेर नही जाये. ");
INSERT INTO ahr_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मोशे परमेश्वरले बोलना, दख, तु माले सांगस की या माणसासले लई जाय; पण तु मनासंगे कोनले धाडसी हाई माले तु आजुन कळाडं नही; तरी तु सांगेल शे की मी तुले तुनं नावतीन वळखस अनी तुनावर मनी कृपादृष्टी शे. ");
INSERT INTO ahr_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","याकरता तुनी मनावर कृपादृष्टी शे तर तुना मार्ग माले दखाड म्हणजे तुनी माले वयख व्हई अनी त्यामुये तुनी कृपादृष्टी मनावर व्हई; दख, हाई राष्ट्र तुनी प्रजा शे. ");
INSERT INTO ahr_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","परमेश्वर बोलना मी प्रत्यक्ष ईसु अनी तुले विश्राती दिसू. ");
INSERT INTO ahr_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","तो त्याले बोलना, तू प्रत्यक्ष नही वना तर तु आमले आठेतीन मोरे लि जावानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","तुनी कृपादृष्टी मनावर अनी तुनी प्रजावर व्हयेल शे हाई समजानं कसावरतीन? तु आमनासंगे येवामुये मी अनी तुनी प्रजा पृथ्वीवरना दुसरा बठा लोकेसपेक्षा येगळा व्हयेल शेतस यावरतीन ते समजानं का? ");
INSERT INTO ahr_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","परमेश्वर मोशेले बोलना, तुना सांगाप्रमानं हाई मी करसू; कारन मनी कृपादृष्टी तुनावर व्हयेल शे अनी मी तुले तुनं नावतीन वळखस. ");
INSERT INTO ahr_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","तो बोलना, कृपा करीसनं माले तुनं तेज दखाड. ");
INSERT INTO ahr_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","तो बोलना, मना सर्वा चांगुलपन तुनामोरे चालाडसू; तुनामोरे तुनं नावनी घोषना करसू; ज्यानावर कृपा करानं वाटी त्यानावर मी कृपा करसू अनी ज्यानावर दया कराले वाटी त्यानावर दया करसू. ");
INSERT INTO ahr_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","आजुन तो बोलना तु मना तोंड दखु शकस नही, कारन मनं तोंड दखीसनं कोनीबी माणुस जीवत राहावावू नही. ");
INSERT INTO ahr_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","परमेश्वर बोलना, मनाजोडे एक जागा शे; आठे हाई खडकवार उभा ऱ्हाय; ");
INSERT INTO ahr_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","आशे घडी की, मनं तेज जोडेतीन जाई तवय मी तुले खडकना भेंगमां ठेवसू; मी निंघी जास तोपावोत मना हातघाई तुले झाकसू; ");
INSERT INTO ahr_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","मंग मी मना हात काढी लिसू अनी तुले पाठमांगेन दखायसू; पण मनं तोंड दखावाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","परमेश्वरनी मोशेले सांगं, पहिल्या पाटयासनासारखा दोन दगडी पाटया घडाईसनं तयार म्हणजे तु फोडी टाका व्हतात त्या पहिल्या पाटयासवर ज्या वचन व्हतात त्या मी त्यानावर लिखसू. ");
INSERT INTO ahr_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","तु पहाटले तयार व्हयीसनं सीनाय परवतवर चढी जाय अनी पर्वतशिखरवार मनासमोर दाखल व्हय; ");
INSERT INTO ahr_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","तुनासंगे कोनीबी चढाले नही पाहिजे; सगळा पर्वतवार कोनताच माणुस दखावाले नही पाहिजे; तशेच शेरडामेंढरा अनी गुरढोरेसले डोंगरना कडाले चारू देवानं नही; ");
INSERT INTO ahr_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","तवय मोशेनी पहिल्या पाटयासनासारखा दोन दगडी पाटया घड्यात अनी सकासले उठीसनं त्या हातमां लिसनं परमेश्वरनी आज्ञाप्रमानं तो सीनाय पर्वतवर चढी गया; ");
INSERT INTO ahr_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","तवय परमेश्वर मेघनाद्वारे उतरना अनी तठे त्यानाजोडे उभा राहीना, अनी त्यानी परमेश्वर ह्या आपला नावनी घोषना करी. ");
INSERT INTO ahr_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","परमेश्वर त्यानामोरेतीन आशी घोषना करत गया; परमेश्वर, परमेश्वर दयाळू अनी कनवाळु देव, मंदक्रोध, दयानं अनी सत्यना सागर, ");
INSERT INTO ahr_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","हजारो लोकेसवर दया करनारा, अधर्म अपराध अनी पाप यानी क्षमा करनारा, आजीबात दया नही करनारा, आशे तो वडीलासना अधर्मना बारामां पोर्‍यासोर्‍यासना तिसरी चौथी पिढीपावोत समाचार लेस ");
INSERT INTO ahr_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","तवय मोशेनी लगेच भूमीपावोत वाकीसनं नमन करं. ");
INSERT INTO ahr_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","अनी तो बोलना, हे प्रभू तुनी मनावर कृपादृष्टी व्हयेल व्हयीते परमेश्वरनी आमनसंगे चालाले पाहीजे; हया माणसे ताठ मानना शेतस; आमना अधर्म अनी पापनी क्षमा कर अनी आपलं वतन समजीसन आमले जोडे कर. ");
INSERT INTO ahr_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","देव बोलना, दख, मी एक करार कसर; तुना सर्वा लोकेसनीसमोर आशी अद्भुत कृत्य करसू तशे बठी पृथ्वीवर व्हयेल नही व्हावावुत; ज्या लोकेसमा तु राहाशी त्या बठा परमेश्वरना कृत्य दखतीन, कारन जे मी तुनाकरता करनार शे ते भयानक शे. ");
INSERT INTO ahr_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","जी आज्ञा मी तुले दी राहीनू शे ती तुले पायनच पडी; दख, मी तुनासमोर अमोरी, कनानी, हित्ती परिज्जी, हिव्वी अनी यबुसी या लोकेसले काढी टाकसु. ");
INSERT INTO ahr_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","तु सावध राय; ज्या देशमां तु जायी राहीना शे तठेना लोकेसनीसंगे करारमदार करानं नही; करं ते तुले पाश व्हई. ");
INSERT INTO ahr_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","त्यासन्या वेदया पाडी टाक, त्यासना खांब फोडी टाक, त्यासना आशेरन्या मुर्त्यासले तोडीन टाक. ");
INSERT INTO ahr_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","कारन तुले दुसरा कोनतेबी देवनी पुजा करानी नही शे, कारन ज्यान नाव ईर्ष्यावान शे, तो परमेश्वर ईर्ष्यावान शे; ");
INSERT INTO ahr_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","तु संभायीसनं राय, देशमाधला लोकेसनी तुला करारमदार कराले नही पाहीजे; नाहीते त्या व्यभिचार मनतीन त्यासना देवानामांगे लागीसनं त्यासले बलिदान करतीन; अनी त्यासमासला कोनी तुले बलावं व्हई तु त्यासना बलिदानमासला काही खाशी, ");
INSERT INTO ahr_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","त्यासना पोरीसमाईन कोनी तु आपला पोर्‍यासकरता बायको करशी, अनी त्यासन्या पोरी व्यभिचार मनतीन आपला देवसनीमांगे जातीन अनी तुना पोर्‍यासलेबी व्यभिचारी मनतीन त्यासनामांगे लावतीन. ");
INSERT INTO ahr_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","तु तुनाकरता घडायेल देव करू नको; ");
INSERT INTO ahr_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","बेखमीर भाकरनं सण पाळ, मनी आज्ञा पाळीसनं अबीब महिनानं येळले सात रोज तु बेखमीर भाकर खावानं; कारन अबीब महिनामां तु मिसर देशमाईन निंघेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","प्रत्येक पहिला जन्म व्हयेल मना शे; तुना गुराढोरासमासला बैलनं अनी मेंढरासना पहिला जन्म व्हयेल नर मना शेतस. ");
INSERT INTO ahr_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","गाढवनं पहिलं पिलुबद्दल कोकरुनं दिसनं ते सोडावानं, त्याले तसं सोडायं नही, तर त्यानी मान मोडानी. तुना पोऱ्यासपाईन प्रत्येक मोठा पोऱ्याले मोबदला दिसन सोडाई लेवानं. कोणी रिकामा हाततीन मनासमोर येवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","सव रोज तु तुना कामधंदा करं अनी सातवा रोजले आराम करं, नांगरनीनं अनी हंगामनी येळलेबी आराम कर. ");
INSERT INTO ahr_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","तु सप्तानं म्हणजे गहूनं हंगामनं पहिला पिकना सण पाळानं. ");
INSERT INTO ahr_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","वरीसमा तीन दाव तुनामाईन बठा माणसासनी इस्त्राएलना देव प्रभु परमेश्वर यानं दर्शन लेवानं. ");
INSERT INTO ahr_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","मी ते परराष्ट्रसले तुनामोरे घालाडसूं अनी तुनी सरहद्द वाढावसूं अनी वरीसमां तीनदाव तु आपला देव यहोवा यानं दर्शन लेवाले जाशी तवय कोनीबी तुनी जमीनना लोभ धरावु नही. ");
INSERT INTO ahr_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","मन यज्ञबलीनं रंगत खमीरनी भाकरनीसंगे अर्पानं नही अनी वल्हांडण सणमासला यज्ञबलीमाईन सकायपावोत राहू देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","आपली जमीनमासला पहिला पिकना हिसा आपला देव यहोवा याना मंदिरमां लई येवानं; करडुले त्याना मायनं दुधमां शिजाडानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","मंग परमेश्वरनी मोशेले सांगं हाई वचन लिखी ठेव, कारन हाईच वचनले अनुसरीसनं मी तुनासंगे अनी इस्त्राएल लोकेसनीसंगे करार करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मोशे तठे परमेश्वरनाजोडे चायीस दिवस अनी चायीस रात व्हतां, तेवढा कायमां त्यानी अन्ननं सेवन करं नही, अनी त्या पाटयासवर त्यानी करारनं वचन म्हणजे दहा आज्ञा लिखी काढयात. ");
INSERT INTO ahr_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","मोशे आज्ञापटन्या दोनी पाटया हातमां लिसनं सीनाय पर्वतवरीन उतरी राहींता तवय त्याना चेहरामाईन, परमेश्वरनासंगे भाषण करामुये, तेजनं किरन निंघी राहीना व्हतात, त्याना त्यालेच भान नही व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","मोशेना चेहरामाई तेजनं किरन निंघी राहिना शेतस आशे अहरोननी अनी बठा इस्त्राएल लोकेसनी दखं तवय त्या त्यानाजोडे जावाले भिवायनात. ");
INSERT INTO ahr_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","मंग मोशेनी अहरोन अनी मंडयीनं प्रमुख यासले बलावं तवय त्या बठा त्यानाकडे परत वनात अनी मोशे त्यासनासंगे भाषन कराले लागना. ");
INSERT INTO ahr_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","बठा इस्त्राएल लोके जोडे वनात अनी जे काही सीनाय पर्वतवर परमेश्वरनी त्याले सांगं व्हतं ते सर्वा त्यानी त्यासले आज्ञा दिधी. ");
INSERT INTO ahr_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","मोशेनी त्यासनासंगे बोलानं व्हवानंतर आपला तोंडवर आच्छादन घालं; ");
INSERT INTO ahr_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","पण मोशे परमेश्वरनासंगे भाषण कराले त्यानामोरे मजार जाये तवय तो बाहेर येस तोपावोत आपला तोंडवरला आच्छादन काढी लेय अनी बाहेर ईसनं जीबी आज्ञा त्याले व्हई ती तो इस्त्राएल लोकेसले सांगे. ");
INSERT INTO ahr_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इस्त्राएल लोके मोशेना तोंडकडे दखेत तवय त्याना चेहरामाईन तेजनं किरन दखाये; परमेश्वरनीसंगे संभाषन कराले मोशे मझार जास तोपावोत तो आपला तोंडवर आच्छादन करे. ");
INSERT INTO ahr_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मोशेनी इस्त्राएल लोकेसनी बठी मंडयीले एकजागे करीसनं त्यासले सांगं, ज्या गोष्टी करानीबारामां परमेश्वरनी आज्ञा करेल शे त्या हया शेतस; ");
INSERT INTO ahr_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","सव रोज काम करानं, पण सातवा रोज तुमले पवित्र दिवस, परमेश्वरकरता परमविश्रामनं दिवस आराम शे; त्यारोज कोनी काम करी त्यासले मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","आरामना रोज तुम्हीन आपला घरमां ईस्तव पेटाडानं नही. ");
INSERT INTO ahr_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","मोशेनी इस्त्राएल लोकेसनी बठी मंडयीले सांगं परमेश्वरनी आज्ञा दिधी ती हाई शे: ");
INSERT INTO ahr_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","तुम्हीन आपलाकडला अर्पन परमेश्वरकरता आणानं; ज्यासनी मनपाईन ईच्छा व्हयी त्यानी परमेश्वरकरता अर्पण लई येवानं; सोनं, रुपे, पितय ");
INSERT INTO ahr_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","निया, जांभया अनी किरमिजी रंगनं सूत अनी तलम सणसनं कापड, बकर्‍यासनं केस; ");
INSERT INTO ahr_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","मेंढयासनं लाल रंग देयेल कातडी, तरस्यानं कातडं, बाभुळनं लाकूड, ");
INSERT INTO ahr_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","दिवानं तेल, अभिषेकनं तेलकरता अनी सुगंधी धुपकरता मसाला, ");
INSERT INTO ahr_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","एफोद अनी उरपट यामां खोचाकरता गोमेदमनी अनी दुसर रत्न लई येवानं; ");
INSERT INTO ahr_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","अनी तुमनामाईन जे कोनी बुध्दीमान ह्रदयनं व्हई त्या बठासनी ईसनं ज्या‍‍ ज्या वस्तु करानी आज्ञा परमेश्वरनी देयेल शे त्या बठया तयार करान्या, त्या हया शेतस: ");
INSERT INTO ahr_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","निवासमंडप, त्यासना तंबू अनी त्यानावरना आच्छादन, त्याना आकडा, फया, अडसर, खांब अनी खाचा; ");
INSERT INTO ahr_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","कोश अनी त्याना दांडा, दयासन अनी आंतरपट; ");
INSERT INTO ahr_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","मेज अनी त्यासना दांडा, त्यानावरना बठा भांडा अनी समर्पित करेल भाकर; ");
INSERT INTO ahr_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","उजेडकरता दिवट अनी त्यानं उपकरनं दिवा अनी दिवासनं तेल; ");
INSERT INTO ahr_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","धूपवेदी, तिना दांडा, अभिषेकनं तेल, सुगंधी धूप, निवासमंडपना दारकरता दारपट; ");
INSERT INTO ahr_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","होमवेदी अनी तिन्या पितयनी जायी, दांडा अनी तिना सामान, पितयनं भांडा अनी त्यानी बैठक, ");
INSERT INTO ahr_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","आंगनन पडदा, त्याना खांब अनी खाचा अनी आंगननं प्रवेश दारकरता पडदा; ");
INSERT INTO ahr_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","निवासमंडप अनी आंगन याकरता मेखा अनी तनावे; ");
INSERT INTO ahr_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पवित्रस्थानमां सेवा कराकरता चांगला ईनेल कपडा अनी याजकनं काम कराकरता अहरोन याजकनं पवित्र कपडा अनी त्याना पोर्‍यासना कपडा. ");
INSERT INTO ahr_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","मंग इस्त्राएल लोकेसनी बठी मंडयी मोशेनी मोरेतीन निंघी गयी. ");
INSERT INTO ahr_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ज्यासना मनमां स्फुर्ती व्हयनी अनी ज्यासना मनपाईन इच्छा व्हयनी त्यानी दर्शनमंडपनं काम त्यामासली सर्वी सेवा अनी पवित्र कपडा यानाकरता परमेश्वरले अर्पण आनं. ");
INSERT INTO ahr_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ज्यासले ज्यासले मनपाईन इच्छा व्हयनी त्या बठा बाया माणसे वनात, त्यासना नथा, कुंडले, मुद्रीका, कंकने आशे सोनानं बठा प्रकारनं दागिना लयात; परमेश्वरले सोनं अर्पन करनारा प्रत्येक माणसे वनात. ");
INSERT INTO ahr_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","निया, जांभया अनी किरमिजी रंगनं सुत अनी तलम सणसनं कापड, बकर्‍यासनं केस, तांबडा रंग देयेल मेंढयासनी कातडी अनी तहशानी कातडी ज्या माणसासपान व्हती ती त्या लई वनात. ");
INSERT INTO ahr_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","चांदी अनी पितय यासना अर्पन करनारा प्रत्येकनी परमेश्वरकरता अर्पण आनं अनी सेवानं कामकरता उपयोगमां येनारा बाभुळना लाकूड ज्या प्रत्येक माणुसपान व्हतात ते तो लई वना. ");
INSERT INTO ahr_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ज्या बाया बुध्दीमान व्हत्या त्या बठयासनी निया, जांभया अनी किरमिजी रंगना सुत अनी तलम सणसना कापड आपला हातघाई ईनेल व्हतात त्या आनात. ");
INSERT INTO ahr_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","अनी ज्या बायासना मनमां स्फुर्ती व्हयीसनं त्यासले बुध्दी वनी अनी त्या बठयासनी बकर्‍यासना केस ईनी टाकं. ");
INSERT INTO ahr_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","सरदार मंडयीनी एफोद अनी उरपट यामा खोचाकरता गोमेदमणी अनी रत्ने, ");
INSERT INTO ahr_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","अनी दिवाकरता, अभिषेककरता अनी सुगंधी धुपकरता मसाला अनी तेल आनं. ");
INSERT INTO ahr_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","जे करानं बारामां परमेश्वरनी मोशेनीकडतीन जी आज्ञा देयेल व्हती त्या बठासाठी इस्त्राएल लोकेसनी खुशीतीन परमेश्वरकरता अर्पण लय; ज्या ज्या बाया अनी माणसासले मनपाईन स्फुर्ती व्हयनी त्यासनी त्यासनी हाई अर्पन आनं. ");
INSERT INTO ahr_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","मंग मोशे इस्त्राएल लोकेसले बोलना, दख, यहुदा वंशमासला उरीना पोर्‍या अनी हूरना नातू बसालेल याले परमेश्वरनी नाव लिसनं बलायेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","अनी त्यानी त्याले देवना आत्मानी परीपुर्ण करीसनं आक्क्ल, बुध्दी ज्ञान अनी बठा प्रकारनं कला हाई देयेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","तो कलाकुसरना काम करी; सोना, रुपे अनी पितय यासना काम करी. ");
INSERT INTO ahr_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","जडवाकरता रत्नासले पैलू पाडी; लाकडासना नक्षीदारना काम करी, अनी आशे बठा प्रकारनं कारागीरनं काम करी. ");
INSERT INTO ahr_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","परमेश्वरनी त्यानामां अनी दान वंशमासला अहीसामकना पोर्‍या अहलियाब यानामां शिक्षन देवानं सामर्थ्य ठेयेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","कोरीव काम करनारा चतुर कारागीर निया, जांभया अनी किरमिजी रंगन सुत अनी तलम सणसना कापडवर नक्षी काढनारा, ईनकाम करनारा, बठा प्रकारनं सोनारंना काम करनारा अनी चतुरतीन कामनी योजना करनारा आशेना बठा कारागीरासना काम करनारासकरता या दोनीसना हृदय आकलन पुरा करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","परमेश्वरन्या बठया आज्ञा प्रमानं पवित्र स्थाननं सेवा कराकरता बठा प्रकारनं काम कसं करानं ते समजाले पाहिजे म्हणीसनी यानामां परमेश्वरनी बुध्दी अनी समज घालेल शे; त्यानी हाई काम करानं. ");
INSERT INTO ahr_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","मंग बसालेल अनी अहलियाब यासले अनी ज्या ज्ञानी माणसंना हृदयमा परमेश्वरनी बुध्दी घालेल व्हती त्यासले मोशेनी बलावं. ");
INSERT INTO ahr_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","इस्त्राएल लोकेसनी पवित्रस्थाननी सेवा कराकरता अनी ते बांधाकरता जे अर्पण आणेल व्हतं ते‍ त्यानी माशेनी मोरेतीन लिधं; लोकेसनी रोज सकासले आपला स्वखुशीतीन अर्पण त्यानाजोडे आणाले लागनात. ");
INSERT INTO ahr_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ज्या बुध्दिमान माणसे पवित्र स्थानना काम करत व्हतात त्या बठा आपआपला काम सोडीसनी मोशेकडे वनात. ");
INSERT INTO ahr_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","त्या मोशेले सांगाले लागनात; परमेश्वरनी जे काम कराले आज्ञा देयेल शे ती कराले जी सामग्री लागस त्यानापेक्षा जास्त लोके लयी राहीना शेतस. ");
INSERT INTO ahr_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तवय मोशेनी बठी छावणीभर आशे हुकूम फरमावं की एकादा माणुसनी नाहिते बाईनी पवित्रस्थानकरता आजुन कष्टना काम करीसनी लवानं नही हाई प्रमानं आजुन अर्पण आणानं प्रतिबंध व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","त्यासना हातमा जी सामग्री व्हती ती त्यासले काम कराले पूरीसनी उरी जाई आशी व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","त्यासमासला ज्या हुशार माणसे काम करत व्हतात त्या बठासनी पडदासना निवासमंडप करं; हया पडदा त्यासनी कातेल तलम सणसना कापडनं अनी निया, जांभया अनी किरमिजी रंगनं सुतघाई तयार करेल अनी त्यामा हुशार कारागीरकडतीन करुब काढाई लिधं. ");
INSERT INTO ahr_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","एक एक पडदसनी लांबी अठ्ठावीस हात, अनी रूंदी चार हात व्हती; त्या बठा पडदा एकच मापना व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","त्यासनी त्यामासला पाच पडदा येरायेरमा जोडं, दुसरा पाच पडदा पण एकमेकसले जोडात. ");
INSERT INTO ahr_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","त्यानी जठे एक पडदा जोडं व्हतं तठे पडदानं काठले निया सुतनी फंदा लायी; अनी दुसरा पडदानी काठले तशीच फंदा लायी. ");
INSERT INTO ahr_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","एक पडदाले त्यानी पन्नास फंदा करं दुसरा पडदानं काठलेबी पन्नास फंदा करं हया फंदा येरायेरना मोरे व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","तशेच सोनानं पन्नास आकडं बनावं; त्या आकडासघाई त्यानी पडदासले आशे जोडं की बठा एकजागे व्हयीसनी एक निवासमंडप व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","निवासमंडपावर तंबूकरता बोकडयानं केसनं आकरा पडदा त्यासनी बनाडं. ");
INSERT INTO ahr_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","एक एक पडदानी लांबी तीस हात अनी रुंदी चार हात व्हतात; हया आकरा पडदा एक मापना व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","त्यानी पाच पडदा येगळं जोडं अनी सव पडदा येगळं जोडं. ");
INSERT INTO ahr_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","जोडीसनी करेल एक शेवटला पडदानं काठले त्यानी पन्नास फंदा करात, तशेच दुसरा कनानं शेवटला पडदानं काठले त्यानी पन्नास फंदा करात. ");
INSERT INTO ahr_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","हाई तंबू जोडीसनी एक कराकरता त्यासनी पितळनं पन्नास आकडा बनाडं ");
INSERT INTO ahr_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","या तंबुसकरता तांबडा रंग देयेल मेंढानं कातडासनं एक आच्छादन अनी त्यानावर शुस मासाना कातडाना एक आच्छादन करं. ");
INSERT INTO ahr_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","मंग निवासमंडपले उभा लावाकरता त्यानी बाभळासना लाकडसना फळया कर्‍यात. ");
INSERT INTO ahr_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","प्रत्येक फळी दहा हात लांब अनी दिड हात रुंदी व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","प्रत्येक फळी दुसरी फळीले जोडाकरता त्यानी तिले दोन दोन कुसा करात; ");
INSERT INTO ahr_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","निवासमंडपकरता ज्या फळया त्यासनी कर्‍यात त्यासमाईन वीस दक्षिणनं बाजुले लावं; ");
INSERT INTO ahr_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","त्या वीस फळयासनी खाल लावाकरता चांदीन्या चाळीस खाचा करात. एक एक फळीनं खाल तिना दोन कुसाकरता त्यानी दोन दोन खाचा कर्‍यात. ");
INSERT INTO ahr_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","त्याप्रमानं निवासमंडप‍न्या दुसरा म्हणजे उत्तर बाजुकरता त्यासनी वीस फळया कर्‍यात. ");
INSERT INTO ahr_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","त्यासनी त्याकरता चांदीन्या चाळीस खुरच्या बनाडयात म्हणजे एक एक फळीनं खाल दोन खाचा. ");
INSERT INTO ahr_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","निवासमंडपन्या मांगल्या म्हणजे पश्चिम बाजुकरता त्यासनी सव फळया बनाडात. ");
INSERT INTO ahr_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","अनी मांगला बाजुनं निवासमंडपनं कोपराकरता त्यासनी दोन फळया बनाडात. ");
INSERT INTO ahr_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","या फळया खालपाईन दोन दोन राहीसनी त्या दोन्ही वरन्या भागले एक एक कडीनं त्यासनी जुळाडं; दोनी कोपरासकरता त्यासनी आश्या दोन फळया बनाडात. ");
INSERT INTO ahr_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","हाई प्रकारं आठ फळया अनी चांदीन्या सोया खाचा व्हयन्यात, म्हणजे एक एक फळीनं खाल दोन दोन खाचा व्हत्यात. ");
INSERT INTO ahr_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","त्यासनी बाभुळना लाकडासना अडसर बनाडं, निवासमंडपना एक बाजुले फळयासकरता पाच. ");
INSERT INTO ahr_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","दुसरा बाजुकरता पाच अनी निवासमंडपनं पश्चिमले म्हणजे मांगली बाजुकरता पाच; ");
INSERT INTO ahr_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","अनी त्यासनी फळयासनी मधला भागले लावाले मधला अडसर एक टोकपाईन ते दुसराटोकपावोत जाई आशे करं. ");
INSERT INTO ahr_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","त्या फळया त्यासनी सोनाघाई मढावं अडसर लावान्या कडया सोनासना बनाडं अनी अडसरबी सोनाघाई मढावं. ");
INSERT INTO ahr_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","मंग त्यासनी निळया, जांभळया अनी किरमिजी रंगन्या सुतसना अनी तलम सणसना कापडनं एक अंतरपट बनाडं अनी त्यामा चतुर कारागीरकडतीन करुब काढं ");
INSERT INTO ahr_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","अनी त्याकरता त्यासनी बाभुळना लाकडसना चार खांब करात अनी त्या सोनाघाई मढावं; त्यान्या आकडया सोनासघाई कर्‍यात अनी त्यानाकरता चार चांदीन्या खाचा बनाडात. ");
INSERT INTO ahr_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","त्यासनी तंबुना दारकरता निळया, जांभळया अनी किरमिजी रंगना सुतासना अनी कातेल तलम सणसना कापडनं नक्षीदार पडदा बनाडं. ");
INSERT INTO ahr_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","अनी त्यासनी त्याना पाच खांब अनी आकडा बनाडं; त्यान्या शिरोभाग अनी त्यान्या साखळी सोनाघाई मंढावं; अनी त्यासन्या पाच खाचा पितळन्या बनाडयात. ");
INSERT INTO ahr_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","मंग बसालेल यानी बाभुळना लाकडासना एक कोश तयार करं; त्यानी लांबी अडीच हात, रूंदी दीड हात अनी उंची दीड हात व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","त्यानी ते मजारतीन अनी बाहेरतीन शुध्द सोनाघाई मढावं; त्यासले चारीमेर सोनानं गोट करं. ");
INSERT INTO ahr_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","त्याना चारी पायसले लावाकरता त्यानी सोनान्या चार कडया वतीसनी एक बाजुले दोन अनी दुसरी बाजुले दोन लावं. ");
INSERT INTO ahr_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","त्यानी बाभुळना लाकडासना दांडा करीसनी त्याबी सोनाघाई मढावं. ");
INSERT INTO ahr_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","कोश उचलाकरता त्या दांडा त्यानी त्याना दोनी बाजुना कडयासमा टाकं. ");
INSERT INTO ahr_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","त्यानी शुध्द सोनानं दयासन बनाडं; त्यानी लांबी अडीच हात अनी रुंदी दीड हात व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","त्यानी सोना घडाईसनी दोन करुब करं; त्या दयासनना दोनी बाजुले करं. ");
INSERT INTO ahr_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","एक करुब एक बाजुले अनी दुसरा करुब दुसरी बाजुले करं; करूब अनी दयासन एकसारखा राहीसनी त्या त्यानी दोनी बाजुले करं. ");
INSERT INTO ahr_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","त्या करुबासना पख आशे पसारेल व्हतं की त्यानाघाई ते दयासन झाकेल व्हतं; त्यासना तोंड येरायेरनामोरे राहीसनी त्यासना डोळा दयासनकडे लागेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","त्यानी बाभुळना लाकडासना मेज बनाडं, त्यानी लांबी दोन हात, रुंदी एक हात अनी उंची दीड हात व्हती; ");
INSERT INTO ahr_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","त्यानी ते शुध्द सोनाघाई मढायं अनी त्याना आजूबाजुले सोनानं गोट करं. ");
INSERT INTO ahr_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","अनी त्यानी त्यानाकरता चार बोट रुंदीनी एक पटी बनाडी अनी त्या पटीसनी आजुबाजूले सोनानं गोट करं. ");
INSERT INTO ahr_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","त्यानाकरता सोनान्या चार कडया वतीसनी तयार कर्‍यात अनी त्याना चार पायसन्या चार कोपरासले लावं. ");
INSERT INTO ahr_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","या कडया त्या पटीन्या जोडे व्हत्यात; मेज उचलाकरता त्यामा दांडा टाकात. ");
INSERT INTO ahr_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","मेज उचलाकरता बाभुळना लाकडासना दांडा करात अनी सोनाघाई मढावं; ");
INSERT INTO ahr_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","अनी त्यानी मेजवरना भांडा म्हणजे परात, धुपाटणी, चमचा अनी पेय अर्पणनं भांड हाई बठा शुध्द सोनाघाई करं. ");
INSERT INTO ahr_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","त्यानी शुध्द सोनानं दिवट बनाडं अनी हाई दिवट, त्यानी बैठक, त्यान्या वाटया, त्याना फुलं हाई बठा एकच एकसारखा तुकडासना बनाडं; ");
INSERT INTO ahr_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","हाई दिवटला सव फांद्या व्हत्यात; एक बाजुले तीन अनी दुसरी बाजुले तीन; ");
INSERT INTO ahr_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","प्रत्येक फांदीले बदामना फुलनासारखा तीन तीन वाटया बोंडाफुलसहित कर्‍यात अनी दुसरा बाजुले त्याना जोडीना प्रत्येक फांदीलेबी बदामना फुलनासारखा तीन तीन वाटया बोंडफुलसहित कर्‍यात; दिवटसमाईन निंघेल सवू फांद्यासनी रचना आशी व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","दीपवुक्षना दांडीले बदामना फुलनासारखा बोंडफुलसहीत चार वाटया व्हत्यात. ");
INSERT INTO ahr_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","दिवटमाईन निघेल सव फांदीसले दोन दोन फांद्यासना खाल एक एक बोंड राहीसनी त्या एकच तुकडानी बनाडेल व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","बोंडा अनी फांद्या ह्या बठा एकसारखा राहीसनी त्यासना संबंध दिवट शुध्द सोनानं एक तुकडा ठोकीसनी घडावं. ");
INSERT INTO ahr_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","त्यानी त्या दिवटले सात दिवा, त्याना चिमटा अनी ताटली शुध्द सोनाघाई बनाडं. ");
INSERT INTO ahr_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","त्यानी त्या दिवट अनी त्याना बठा सामान एक किक्कार शुध्द सोनानं करं. ");
INSERT INTO ahr_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","मंग त्यानी बाभुळना लाकडासना धुपवेदी करी; तिनी लांबी एक हात अनी रूंदी एक हात आशी ती चौरस व्हती; तिनी उची दोन हात व्हती अनी तिना शिंग आंगनास व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","त्यानी त्या वेदीना वरना भाग तिना चारी बाजु अनी तिना शिंग शुध्द सोनानं मढावं अनी तिनी आजुबाजूले सोनानं गोट करं. ");
INSERT INTO ahr_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","त्यानी सोनान्या कडया करीसनी तिन्या गोटासना खाल तिना दोनी भागले, दोनी कोनासले वेदी उचलीसनी लयी जावानं दांडा घालाकरता दोन दोन लावात. ");
INSERT INTO ahr_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","त्यानी बाभुळना लाकडासना दांडा करीसनी त्या सोनाघाई मढावं. ");
INSERT INTO ahr_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","त्यानी पवित्र अभिषेकना तेल अनी सुगंधी द्रवासना शुध्द धुप गंधी बनाडतस तशे बनाडं. ");
INSERT INTO ahr_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","त्यानी होमवेदी बाभुळना लाकडासनी बनाडी; तिनी लांबी पाच हात अनी रुंदी पाच हात आशी ती चौरस राहीसनी तिनी उंची तीन हात व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","त्यानी तिन्या चारी कोपरासले चार शिंग बनाडं; ती तिनं आंगनं व्हतं; त्यानी हाई वेदी पितळघाई मढावं. ");
INSERT INTO ahr_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","अनी त्या वेदीना बठा भांड म्हणजे हंडया, पावडी, कटोरं, काटे, आगपात्र हाई बठा पितळनं बनाडं. ");
INSERT INTO ahr_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","वेदीले त्यानी आजुबाजूले गोटासना खाल पितळनं जाळीनं एक चाळन करं, ती वेदीना खालतीन तिना अर्धा उचीपावोत व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","त्यानी पितळनं चाळनीनं चारी कोपरासले दांडया घालाकरता चार कडया वतीसनी तयार कर्‍यात. ");
INSERT INTO ahr_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","त्यानी बाभुळना लाकडासना दांडया करीसनी ते पितळघाई मढावं. ");
INSERT INTO ahr_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","वेदी उचलाकरता तिन्या बाजुना कडयासमा त्यानी दांडया घालात; मजारमा पोकळ ठेयीसनी बाजुले फया बसाडेल वेदी बनाडी. ");
INSERT INTO ahr_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","त्यानी हौद अनी त्यानी बैठक पितळनी बनाडी; दर्शनमंडपना दारपान ज्या बाया सेवा करेत त्यासना आरशानी हाई पितळ व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","त्यानी आंगन तयार करं; त्याना दक्षिण बाजुले तलम सणनं ईनेल पडदा बठा शंभर हात व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","त्यासले वीस खांब व्हतात अनी त्या खांबासले पितळन्या वीस खाचा व्हत्या; खांबासना आकडा अनं त्यान्या रोहाड चांदीन्या व्हत्यात. ");
INSERT INTO ahr_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","त्यान्या उत्तर बाजुले शंभर हात लांबीन पडदा व्हतात; त्या धरीसनी वीस खांब राहीसनी त्यासले पितळन्या वीस खाचा व्हत्यात; खांबासना आकडा अनी त्यानी रोहाड चांदीन्या व्हत्यात. ");
INSERT INTO ahr_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","अनी पश्चिम बाजुले पन्नास हात लांब पडदा व्हतात; त्यासले दहा खांब अनी दहा खाचा व्हत्या; या खांबासना आकडा अनी रोहाड चांदीन्या व्हत्‍यात; ");
INSERT INTO ahr_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","पुर्व बाजुले पन्नास हात ठेवं ");
INSERT INTO ahr_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","आंगणना दारनं एक बाजुले पंधरा हात लांबनं पडदा व्हता, त्याना खांब तीन अनी खाचाबी तीन व्हत्या ");
INSERT INTO ahr_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","अनी आंगणनी दुसरी बाजुबी तशीच व्हती; आंगणनं दारनी हाई बाजु अनी त्या बाजुले पंधरा पंधरा हात पडदा व्हतात, त्याना खांब तीन अनी खाचा तीन तीन व्हत्या ");
INSERT INTO ahr_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","आंगणना आजुबाजूना बठा पडदा कातेल तलम सणसना कापडनं व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","खांबन्या खाचा पितळनं अनी त्यासना आकडा अनी त्यासनी रोहाड चांदीनी व्हती; त्यासना मथळा चांदीना मढायेल व्हतात अनी आंगणनं बठा खांब चांदीना रोहाडघाई जोडेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","आंगणना दारना पडदा वेलबुट्टीदार राहीसनी निया, जांभळा अनी किरमिजी रंगना सुतनं अनी कातेल तलम सणसना कापडासना व्हतात; त्यासनी लांबी वीस हात अनी त्यानी रुंदीकडली उची आंगणनं काठना इतली पाच हात व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","त्याना खांब चार अनी त्यासले पितळनं खाचा चार व्हत्या; त्यासना आकडा चांदीना राहीसनी त्यासना मथला चांदीना मढायेल व्हतं अनी त्यासनी रोहाड चांदीनी व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","निवासमंडपना अनी आंगणन्या आजुबाजूना बठा खुट्या पितळन्या व्हत्यात. ");
INSERT INTO ahr_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","निवासमंडपना म्हणजे आज्ञापटन्या निवासमंडपनं जे सामान लेवीसना सेवाकरता कर्‍यात त्यासनी यादी मोशेनी सांगावरतीन अहरोन याजकना पोर्‍या इथामार यानी कर्‍यात त्या हयाच शेतस. ");
INSERT INTO ahr_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ज्या ज्या वस्तु करानीबारामा परमेश्वरनी मोशेले आज्ञा देयेल व्हती त्या यहुदा वंशासमासली हूराना नातू अनी उरीना पोर्‍या बसालेल यानी बनाडयात. ");
INSERT INTO ahr_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","त्याना जोडीले दान वंशमासला अहीसामकाना पोर्‍या अहलियाब हाऊ कोरीव काम करनारा हुशार कारागीर राहीसनी निळा, जांभळा अनी किरमिजी रंगना अनी तलम सणना कपडासवर नक्षीकाम करनारा व्हता. ");
INSERT INTO ahr_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पवित्रस्थाननी बठा कामसकरता लागेल लोकेसनी अर्पन करेल बठा सोना एकोणतीस किक्कार व्हतं, अनी पवित्रस्थानमासला शकेलना चलनप्रमानं सातशे तीस शेकेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","मंडळीमाईन ज्यासनी नोंदनी करेल व्हतात त्यासनी जी चांदीनं अर्पण करं ती शंभर किक्कार भरनी, अनी पवित्रस्थानमासला शकेलना चलनप्रमान सतराशे पंच्याहतर शकेल भरनी. ");
INSERT INTO ahr_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","म्हणजे जेवढा वीस वर्षसना अनी त्यानापेक्षा बराच व्हतात त्यासनी मोजनी व्हयनी तवय, त्या सव लाख साडेतीन हर पन्नास भरनात. त्यासमासला एकमागे एक पवित्रस्थानमासला शकेलना चलनप्रमानं एक एक बेका म्हणजे अर्धा शकेल भेटनं. ");
INSERT INTO ahr_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ती शंभर किक्कार चांदी पवित्रस्थानमासली खाचा अनी पडदासन्या खाचा वताले लागनात; एक एक खाचाले एक एक किक्कार आशे शंभर किक्कारनं शंभर खाचा कर्‍यात. ");
INSERT INTO ahr_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","अनी बाकीना सतराशे पंचाहतर किलो चांदीना खांबासकरता आकडा करात; खांबासना मथळावर मढवनी करी अनी त्यानाकरता रोहाड बनाडी. ");
INSERT INTO ahr_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","अर्पन करेल पितळ सत्तर किक्कार अनी दोन हजार चारशे पस्तीस किलो व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ती पितळ लयीसनी दर्शनमंडपना दारना खाचा, पितळनं वेदी, पितळनी चाळनी अनी वेदीना बठा सामान, ");
INSERT INTO ahr_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","अनी आंगण चारी बाजुले खाचा, त्यान्या दारन्या खाचा अनी निवासमंडप अनी आंगण यासन्या चारी बाजुना खुट्या बनाडयात. ");
INSERT INTO ahr_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","त्यानी पवित्रस्थानमासली सेवा करनारा याजकसकरता निळया, जांभळया अनी किरमिजी रंगनं सुत ईनीसनी कपडा करात; परमेश्वरनी मोशेले सांगं व्हतं त्या प्रमानं ते करं. अनी अहरोनकरता पवित्र कपडा करात ");
INSERT INTO ahr_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","त्यासनी एफोद सोनानं धागा अनी निळया, जांभळया अनी किरमिजी रंगनं सुतनं अनी तलम सणसनं कापड तयार करं. ");
INSERT INTO ahr_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","त्यासनी सोना ठोकीसनी त्याना पत्रा बनाडं अनी ते पत्रा कापीसनी त्यानी तार बनाडी अनी ती हुशार कारागीरकडतीन अनी निळया, जांभळया अनी किरमिजी रंगनं सुतनं अनी तलम सणसनं कापडमा भरं. ");
INSERT INTO ahr_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","त्यासनी एफोदले खांदपट्टया जोडयात; त्यानी दोनी टोक जोडेल व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","एफोद बांधाकरता त्यानावर जी कुशलतीन इनेल पट्टी राहास तिनी बनावट त्यानासारखी राहीसनी ती एकसारखी तुकडानी बनाडं; ती सोनानी जराघाई अनी निळया, जांभळया अनी किरमिजी रंगनं सुतनं अनी कातेल तलम सणसना कापडासना करं; परमेश्वरनी मोशेले सांगं व्हतं त्याप्रमानं हाई करं. ");
INSERT INTO ahr_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","मुद्रासवर छाप कोरतस तशे त्यासनी गोमेद मण्यावर इस्त्राएल पोर्‍यासनी नावं कोरात; त्या मणी सोनानं जाळीदार खाचामा बसाडं. ");
INSERT INTO ahr_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","इस्त्राएल पोर्‍यासनी स्मारकरत्न व्हावाले पाहिजे म्हणीसनी ती एफोदनं खांदपट्टयासावर लावं; परमेश्वरनी मोशेले सांग व्हतं त्या प्रमानं हाई करं. ");
INSERT INTO ahr_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","त्यानी एफोदप्रमानं कातेल सोनासना धागानं अनी निळया, जांभळया अनी किरमिजी रंगनं सुतसना अनी कातेल तलम सणसना कापडना उरपट हुशार कारागीरकडतीन बनाडं. ");
INSERT INTO ahr_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","तो चौरस व्हता; हाई उरपट त्यासनी दुहेरी करं; ते दुहेरी राहिसनी एक ईत लांब अनी एक ईत रूंद व्हती. ");
INSERT INTO ahr_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","त्यासमा रत्नासना चार रांगा बसाडयात; पहिली रांगमा लाल, पुष्कराज अनी माणिक; ");
INSERT INTO ahr_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","दुसरी रांगमा पाच, नीलमणी अनी हिरा; ");
INSERT INTO ahr_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","तिसरी रांगमा तृणमणि, सुर्यकांत अनी पदमराग: ");
INSERT INTO ahr_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","अनी चौथी रांगमा लसणा,गोमेद अनी यास्फे; हाई रत्ना सोनानं जाळीदार खाचामा खोचं. ");
INSERT INTO ahr_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","इस्त्राएल पोर्‍यासनी नावसनी संख्याएवढी या रत्ना व्हतात; त्यासनी संख्या प्रमानं बारा नावं व्हतात; मुद्रा जशी खोदतस तशे बारा वंशसमाईन एक एक नाव एक एक रत्नासवर त्यासनी खोद. ");
INSERT INTO ahr_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","दोरीनासारखा पिळ घालेल शुध्द सोनानी साखळया करीसनी उरपटले लावं. ");
INSERT INTO ahr_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","सोनानं दोन जाळीदार खाचा अनी दोन कडया करीसनी उरपटनं दोनी बाजुले लावं. ");
INSERT INTO ahr_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","उरपटना शेवट लायेल दोनी कडयासमा सोनानं पिळ घालेल साखळया टाक्यात. ");
INSERT INTO ahr_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","पिळ घालेल दोनी साखळयासनं दुसरा दोन तोंडासले दोनी जाळीदार खाचामा मढाईसनी त्या एफोदना दोनी खांदपट्टयासना समोरनं भागले लावं. ");
INSERT INTO ahr_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","सोनानं आजुन दोन कडया करीसनी उरपटना दोनी तोंडाले म्हणजे एफोदनं मजारनी बाजुले जी कोरेल शे तठे लावं. ");
INSERT INTO ahr_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","सोनानं आजुन दोन कडया करीसनी एफोदनं दोनी खांदपट्टयासना खालतीन त्यानामोरे त्याना सांधानाजोडे ईनेल बुट्टीदार पट्टीवर लावं. ");
INSERT INTO ahr_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","त्यासनी त्या उरपटन्या कडया एफोदन्या कडयासले निया फीतीसघाई आशे बांध एफोदनं बुट्टीदार पट्टीवर राहावाले पाहिजे अनी त्यानापाईन ते येगळं व्हावाले नही पाहिजे, परमेश्वरनी मोशेले सांगं व्हतं त्याप्रमानं हाई करं. ");
INSERT INTO ahr_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","त्यानी एफोदनासंगे घालानं झगा ईनीसनी बठा निया रंगनं करी टाकं. ");
INSERT INTO ahr_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","मध्यभागमा चिलखतप्रमानं एक छिद्र ठेवं, अनी ते फाटाले नही पाहिजे म्हणीसनी ते छिद्रनं काठले आजुबाजूले गोट घालं. ");
INSERT INTO ahr_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","त्यासनी त्या झगानं खालना घेरामा आजुबाजूले निळा, जांभळा अनी किरमिजी कातेल सुतनं डाळींब काढं. ");
INSERT INTO ahr_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","शुध्द सोनानं घंटया बनाडयात अनी झगानं खालनं घेरानं आजुबाजूले दोन डाळींबनं मजारमा एक एक आशी त्या लाव्यात; ");
INSERT INTO ahr_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","म्हणजे झगानं खालनं घेरानं आजुबाजूले एक सोनानी घंटी अनी एक डांळीब, परत एक सोनानी घंटी अनी एक डांळीब आशा त्या लाव्यात; हाई झगा सेवा करानी येळले घालानं; परमेश्वरनी मोशेले सांगं व्हतं त्याप्रमानं हाई करं. ");
INSERT INTO ahr_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","अहरोन अनी त्याना पोर्‍या यासनकरता तलम सणसना ईनेल कपडासना अंगरखा, ");
INSERT INTO ahr_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","अनी तलम सणसना फेटा, तलम सणसना सुंदर फेटा, कातेल तलम सणसना चोळनं, ");
INSERT INTO ahr_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","कातेल तलम सणसना अनी निळया, जांभळया अनी किरमिजी रंगनं नक्षीदार काढेल कमरबंद हाई बनाडी; परमेश्वरनी मोशेले सांगेल व्हतं त्याप्रमानं हाई करं. ");
INSERT INTO ahr_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","त्यासनी पवित्र मुकुटनं पट्टी शुध्द सोनानी करी अनी मुद्रा कोरतस तशे तिनावर हया अक्षरं कोरी टाकं; परमेश्वरकरता समर्पित. ");
INSERT INTO ahr_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ती फेटावर बांधता यावाले पाहीजे म्हणीसनी तिले त्यासनी निया रंगन फीत लाव; परमेश्वरनी मोशेले सांगं व्हतं त्याप्रमानं हाई करं. ");
INSERT INTO ahr_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","हाई प्रकारं दर्शनमंडपना निवासमंडपना बठा काम सरी गयात; परमेश्वरनी मोशेले आज्ञा देयेल व्हती त्यापध्दतमा इस्त्राएल लोकेसनी हाई करं. ");
INSERT INTO ahr_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","त्यासनी मंग ते निवासमंडप मोशेकडं लयं; तंबू अनी त्याना बठा सामान म्हणजे त्याना आकडा त्यान्या फळया, त्यानं अडसर, त्यानं खांब अनी त्यान्या खाचा; ");
INSERT INTO ahr_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","अनी मेंढासनी लाल रंगाडेल कातडी अनी शुस मासानी कातडी अनी अंतरपट; ");
INSERT INTO ahr_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","आज्ञापटना कोश अनी त्यासना दांडा अनी दयासन; ");
INSERT INTO ahr_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","मेज, त्यानावरना बठा सामान अनी समर्पित करेल भाकर; ");
INSERT INTO ahr_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","शुध्द दिवट, त्याना दिवा मनजे रांगमा लायेल दिवा, त्याना बठा उपरकन अनी दिवाकरता तेल; ");
INSERT INTO ahr_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","सोनानी वेदी, अभिषेकनं तेल, सुंगधी धुप अनी तंबुन दारनाकरता पडदा; ");
INSERT INTO ahr_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","पितळनी वेदी अनी तिना पितळन जाळी, तिना दांडा अनी तिना बठा भांडा, पितळना भांडा अनी त्यानी बैठक; ");
INSERT INTO ahr_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","आंगनं पडदा, खांब अनी खाचा, आंगनं दारनं पडदा, दोर अनी खुटया अनी निवासमंडपनं अनी दर्शनमंडपनं सेवाकरता लागनारा बठा साहित्य; ");
INSERT INTO ahr_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","पवित्र ठिकानले सेवा कराकरता इनेल तलम कपडा, अहरोन याजकनं पवित्र कपडा अनी याजकनं काम चालावाकरता त्याना पोर्‍यासना कपडा हाई बठा त्यासनी आणं; ");
INSERT INTO ahr_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","परमेश्वरनी मोशेले आज्ञा देयल व्हती त्याप्रमानं इस्त्राएल लोकेसनी बठा काम करं. ");
INSERT INTO ahr_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","मोशेनी हाई बठा काम दख; ते त्यासनी परमेश्वरनी आज्ञाप्रमानं करेल शे आशे त्यासना दखामा व्हनं येवानंतर त्यानी त्यासले आशिर्वाद दिधं. ");
INSERT INTO ahr_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","परमेश्वर मोशेले बोलना; ");
INSERT INTO ahr_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","पहिला महीनानं पहिला दिनले दर्शनमंडपना निवासमंडप उभा कर. ");
INSERT INTO ahr_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","त्यानामा आज्ञापटनं कोश ठेवानं अनी तो आंतरपटतीन झाकानं ");
INSERT INTO ahr_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","मेज मजारमा लयीसनी त्यानावरना सामान नेवनेटका ठेवानं अनी दिवट मजारमा आणीसन त्याना दिवा लावनं. ");
INSERT INTO ahr_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","आज्ञापटना कोशनामोरे सोनानी धुपवेदी ठेव अनी निवासमंडपना दारनं पडदा लाव. ");
INSERT INTO ahr_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","दर्शनमंडपना निवासमंडपना दारनामोरे होमवेदी ठेव. ");
INSERT INTO ahr_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","दर्शनमंडप अनी वेदी यानामध्ये पितयना भांड ठेयीसनी त्यानामा पाणी भर. ");
INSERT INTO ahr_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","आजुबाजूले आंगन कर अनी त्याना दारले पडदा लाव. ");
INSERT INTO ahr_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","अभिषेकनं तेल आणीसन निवासमंडपले अनी त्यामासला बठया वस्तुसले अभ्यंग कर अनी तो मंडप अनी त्याना बठा सामान हाई पवित्र कर, हाई प्रकारं तो पवित्र व्हयी. ");
INSERT INTO ahr_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","होमवेदी अनी त्याना बठा सामान यासले अभिषेक करीसनी अर्पण कर, म्हणजे ती परमपवित्र व्हयी. ");
INSERT INTO ahr_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","पितयना भांडा अनी त्यानी बैठक यासले अभिषेक करीसनी अर्पण कर, ");
INSERT INTO ahr_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","अहरोन अनी त्याना पोर्‍या यासले दर्शनमंडपना दारपान लयीसनी जलस्नान घाल. ");
INSERT INTO ahr_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","अहरोनंले पवित्र कपडा घालीसन अनी त्याले अभिषेक करीसनी समर्पण कर; म्हणजे तो याजकनं नातातीन मनी सेवा करी. ");
INSERT INTO ahr_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","त्याना पोर्‍यासले लयीसनी त्यासना आंगमा कपडा घाल; ");
INSERT INTO ahr_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","तु त्यासना वडीलले जशे अभिषेक करशी तशेच त्यासले कर, म्‍हणजे ते याजक हाई नातातीन मनी सेवा करतीन; हाई त्यासना अभिषेक पिढयानपिढया कायमनं याजक बनाडीन ठेवसु. ");
INSERT INTO ahr_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","मोशेनी आशे करं; परमेश्वरनी आज्ञा देवाप्रमानं त्यानी बठ काही करं. ");
INSERT INTO ahr_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","अनी दूसरा वरिशनं पहिला महीनानं दिवसले निवासमंडप उभं करं. ");
INSERT INTO ahr_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मोशेनी निवासमंडप उभं करं, त्यानी त्यासन्या खाचा बसाडीसनी फळया लाव्यात. ");
INSERT INTO ahr_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","अनी त्यानी निवासमंडपवरतीन तंबु तानं अनी तंबुनं छप्पर त्यानावर घालं; परमेश्वरनी आज्ञा देयेलप्रमानं मोशेनी हाई करं. ");
INSERT INTO ahr_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","त्यानी आज्ञापट लयीसनी कोशमा ठेवं अनी कोशले दांडी लायीसनी त्यानावर दयासन ठेवं. ");
INSERT INTO ahr_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","त्यानी तो कोश निवासमंडपमा लयी गयात अनी आंतरपट लायीसनी आज्ञापटनं कोश झाकं; परमेश्वरनी आज्ञा करेलप्रमाण हाई व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","त्यानी निवासमंडपनं उत्तर बाजुले दर्शनमंडपमा आंतरपट बाहेर मेज ठेवं; ");
INSERT INTO ahr_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","अनी त्यानावर परमेश्वरनीमोरे समर्पित करेल भाकर ठेयी दिधं; परमेश्वरनी मोशेले आज्ञा करेल प्रमानं हाई व्हयनं; ");
INSERT INTO ahr_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","त्यानी निवास मंडपनं दक्षिण बाजुले दर्शनमंडपमा मेजनामोरे दिवट ठेवं. ");
INSERT INTO ahr_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","अनी परमेश्वरनीमोरे दिवा लावं; परमेश्वरनी आज्ञा करेलप्रमाण हाई व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","त्यानी दर्शनमंडपमा आंतरपटनामोरे सोनानी वेदी ठेव; ");
INSERT INTO ahr_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","तिनावर त्यानी सुगंधी द्रवनं धुप जाळं; परमेश्वरनी मोशेले आज्ञा कराप्रमानं हाई व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","त्यानी निवासमंडपनं दारले पडदा लावं ");
INSERT INTO ahr_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","अनी दर्शनमंडपनं निवासमंडपनं दारपान होमवेदी ठेयीसनी तिनावर होमबली अनी अन्नबलीनं अर्पण करं; परमेश्वरनी मोशेले आज्ञा कराप्रमानं हाई व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","दर्शनमंडप अनी वेदी यानामा त्यानी पितयना भांडा ठेयीसनी धवाकरता त्यामा पाणी भरं. ");
INSERT INTO ahr_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","मोशे अनी अहरोन अनी त्याना पोर्‍या त्यामा आप आपला हातपाय धवं; ");
INSERT INTO ahr_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ते दर्शनमंडपमा किवा वेदीनाजोडे जातस तवय त्या आपला हातपाय तठे धोयेत; परमेश्वरनी मोशेले आज्ञा कराप्रमानं हाई व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","त्यानी निवासमंडपना आजुबाजूले अनी वेदीनं जोडे आंगनंना कडाले उभी करं अनी त्याना दारले पडदा लावं; हाई प्रमानं मोशेनी बठा काम सरावं. ");
INSERT INTO ahr_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","मंग दर्शनमंडपनावर ढगनी सावली करी अनी निवासमंडप परमेश्वरनी तेजघाई भरी गयं. ");
INSERT INTO ahr_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","दर्शनमंडपनावर ढग थांबनं अनी परमेश्वरनी तेजघाई निवासमंडपघाई भरी गयं म्हणीसनी मोशेले मजारमा येवाले जमनं नही. ");
INSERT INTO ahr_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","जवय इस्त्राएल लोकेसनं सर्वा प्रवासमा निवासमंडपना वरना ढग वर जाये तवय त्या मोरे सरकेत. ");
INSERT INTO ahr_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","अनी तो ढग तठेतीन वर नही गया तर त्या मोरे सरकत नव्हतात; तो वर जास तोपावोत त्या तठेच थांबेत. ");
INSERT INTO ahr_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","परमेश्वरनं ढग दिवसले निवासमंडपवर राहे अनी रातले त्यामा आग राहे; हाई आशे प्रवासमा बठा इस्त्राएल घरानासना नजरमा दखाई रांहितं.");
INSERT INTO ahr_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","परमेश्‍वरनी दर्शनमंडप माईन मोशेले आवाज दिसन बोलना. ");
INSERT INTO ahr_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","इस्राएल लोकेसले अस सांगानं, जर तुम्‍हना माईन एखादा माणुस पशुबळिना अर्पण करी तवय त्यानी बकर्‍यामेंढया यामातील अर्पण करानं. ");
INSERT INTO ahr_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","गुरंढोरसमातील होमबळी अर्पण करानं व्‍हई त्‍यासनी पाक नर अर्पण करानं; तो त्यासनी दर्शनमंडपना दारमा अर्पण करानं, तवय परमेश्‍वर देखत मान्‍य व्‍हई. ");
INSERT INTO ahr_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","होमबळीना पशुना डोकावर हात ठेवाना तवय तो पशु पश्चातापकरता मान्‍य व्‍हई. ");
INSERT INTO ahr_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","त्यानी त्‍या वासुरुले देवना देखत मारानं अनं अहरोनना पोर्‍या ज्या सेवक शेतस त्यासनी त्‍यानं रंगत अर्पण करीसन दर्शनमंडपना दारपान जी वेदी शे त्‍यावर आजुबाजूले शितडानं. ");
INSERT INTO ahr_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","तवय होमबळी पशुना कातडा काढीसन त्‍यासना तुकडा कराना. ");
INSERT INTO ahr_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","नंतर अहरोन सेवकना पोर्‍यासनी वेदीवर इस्‍तव ठेवानं अनी त्‍यानावर लाकड ठेवानं; ");
INSERT INTO ahr_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","अनं अहरोनना पोर्‍या ज्‍या सेवक शेतस त्यासनी वेदीवरना इस्‍तववरना लाकडासवर पशुना त्या तुकडा, डोका अनं चरबि हाई रचाना. ");
INSERT INTO ahr_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","त्यानी आतडि आनं पाय त्यानी पाणीघाई धोवानं तवय सेवकसनी सर्वासना वेदीवर होम करीसन ते अर्पण करानं तवय ते परमेश्‍वरनि करता सुवासिक अर्पण व्‍हई. ");
INSERT INTO ahr_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","शेरडामेंढारा माईन होमबळी अर्पण करानं व्‍हईते तो नर पाक‍ र्‍हावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","त्यासनी त्‍याले परमेश्‍वरनां देखत वेदीना उत्‍तर बाजुले मारि टाकानं आनं अहरोनना पोर्‍या जे सेवक शेतस त्यासनी त्‍याना रंगत वेदीना आजुबाजूले शितडानं. ");
INSERT INTO ahr_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","त्यानी त्‍याना कापीसन तुकडा करानं अनी त्‍याना डोका अनं चरबी हाई वेगळा करानं ह्या सर्वा तुकडा सेवकसनी वेदीना इस्‍तववरना लाकडसवर रची देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","त्यानी आतडी अनं पाय त्यानी पाणीघाई धवानं. मंग सेवकसनी बठासना वेदीवर होम करीसन त्‍यानं अर्पण करानं. हाई होमबळी परमेश्‍वरना करता सुवासिक अर्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","परमेश्‍वरनि करता त्‍याले पक्षीसनी होमबळी अर्पण कराना व्‍हईते होलासना आनं पारवसना पिल हयासना अर्पण करना पडि. ");
INSERT INTO ahr_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","सेवकसनी तो पक्षी वेदीजोडे आनीसन त्‍याना डोका मोडीसन येगळं करी टाकानं अनी वेदीवर त्‍याना होम करानं अनी त्‍यानं रंगत वेदीना बाजुले गाळी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","त्‍याना गळानी पिशवी अनं पिस काडीसन वेदीना पुर्व भागले राख टाकाना जागावर फेकी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","त्यानी तो पंखना मझारमाईन फाडी टाकानं. पण ते भाग वेगळा कराना नही. तवय सेवकसनी वेदीना ईस्‍तवना लाकडासवर त्‍याना होम करानं. हाई होमबळी परमेश्‍वरना करता सुवासिक अर्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","ज्‍या कोणी परमेश्‍वरले अन्नार्पण करानं व्‍हई तर त्यानी मैदाना अर्पण करानं. त्‍यानावर तेल टाकीसन लोबान ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","त्यानी ते अहरोना पोर्‍या ज्‍या सेवक शेतस त्‍यानाकडे आनानं. त्‍यामाईन मुठ भरीसन मैदा, तेल अनं सर्वा लोबान संगे आणीसन सेवकसनी स्‍मारकभाग म्‍हणीसन त्‍याना वेदीवर भेट करानं. ");
INSERT INTO ahr_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","अर्पण माईन जे काही उरी ते अहरोना अनं त्‍याना पोर्‍यासना व्‍हई; हाई उरेल भेट परमेश्‍वरले नवस करानं जी भेट हवन त्‍यामासला परम पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","भट्‍टीमा भाजेल अर्पण करानं व्‍हईते ते तेलमा मळेल मयदान्‍या बेखमीर भाकरी नाहीते तेलमा चोपडेल बेखमीर चानक्‍या राहावाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","तवामां भाजेल भेट करानं व्‍हई ते तेलघाई मळीसनी बेखमीर मयदानं ऱ्हावाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","त्‍याना दाखला दाखली तुकडा करीसनी त्‍यानावर तेल टाकानं, हयाले अन्नार्पण म्‍हणतस. ");
INSERT INTO ahr_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","कढाईमा तळेल अर्पण करानं व्‍हई ते बी तेलघाई मळीसनी बेखमीर मैदानं ऱ्हावाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","हाई पध्‍दतमां अर्पण लयी येवानं; ते परमेश्‍वरना देखत आणानं, सेवकसकडे आणानं. त्‍यानानंतर सेवक ते वेदीनाजोडे लई जाई. ");
INSERT INTO ahr_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","सेकवकसनी अर्पण माईन स्‍मारकभाग काडीसनी त्‍याना वेदीवर होम करानं. तवय ते परमेश्‍वरना करता सुवासिक भेट व्‍हई. ");
INSERT INTO ahr_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","अर्पण माईन जे काही उरी ते अहरोनना अनं त्‍याना पोर्‍यासना व्‍हई, हाई उरेल परमेश्‍वरले नवस करानं जे भेट त्‍यामासला परम पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","परमेश्‍वरले अर्पण करेल कोणते भी अर्पणमाईन खमीर ऱ्हावाले नही पाहीजे, खमीर नाहिते मध हयाना अग्‍नीमा हवन करीसनी ते परमेश्‍वरले अर्पण करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","पहिला फळ म्‍हणीसनी त्‍याना अर्पण परमेश्‍वरले करानं; पण ते सुवासिक हवन म्‍हणीसनी वेदीवर अर्पण करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","तू बनाडशी त्‍या सर्वा अर्पण मिठघाई चवदार बनाडानं; तू आपले देवनीसंगे करेल करारनं मिठ आपले अर्पणमा घालाले चुकानं नही. तुना सर्वा अर्पण मिठना ऱ्हावाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","परमेश्‍वरनी करता तु अर्पण म्‍हणीसनी पहिला पिक अर्पण करशी तवय ईस्‍तववर भाजेल हीरवा कनससना दाना; म्‍हणजे हिरव्‍या कनससले चोळीसनी काढेल उंब्‍या पहिला पिक अर्पण म्‍हणीसनी लय; ");
INSERT INTO ahr_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","त्‍यानावर तेल टाक अनं लोबान ठेव; हयाले म्‍हणतस अन्नार्पण. ");
INSERT INTO ahr_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","चोळीनी काढेल दाना अनं तेल यानामाईन जरासा अनं सर्वा लोबान स्‍मारकभाग म्‍हणीसनी सेवकसनी जाळनं; हाई परमेश्‍वरनी करता हवन शे. ");
INSERT INTO ahr_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","ज्‍यासले शांती अर्पणना यज्ञ करानं व्‍हई अनं ते बी पाळेल प्राणीनं करानं व्‍हई तर ते यज्ञपशु नर राहो का मादी राहो ते परीपुर्ण दखीसनी परमेश्‍वर करता अर्पानं. ");
INSERT INTO ahr_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","त्यानी त्‍यासना पशुना डोकावर हात ठेवानं अनं ते दर्शनमंडपना दारपान मारानं. अनं अहरोना पोर्‍या ज्‍या याजक शेतस त्‍यासनी त्‍याना रंगत वेदीना आजुबाजूले शितडानं. ");
INSERT INTO ahr_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","शांती अर्पणना यज्ञपशूना ज्‍या भागना परमेश्‍वरकरता होम करानं ते आशे; आतडासवर पसरेल चरबी अनं त्‍याले लागेल बठी चरबी. ");
INSERT INTO ahr_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","दोन्‍ही गुर्दासनावरना कमरना जोडे जी चरबी अनं गुर्दासपावोत काळजना वरना पडदा हाई सर्वा न्‍यारा करानं. ");
INSERT INTO ahr_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","हाई बठा लयसनी अहरोना पोर्‍यासनी वेदीवर, इस्‍तवर रचेल लाकडासवरना होमबळीवर त्‍याना होम करानं; हाई परमेश्‍वरनीकरता सुवासिक अर्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","परमेश्‍वरनी करता शांती अर्पणना यज्ञकरता पाळेल प्राणी व्‍हईते, ते नर राहो की मादी राहो, त्यानी ते परीपुर्ण दखीसन आनानं. ");
INSERT INTO ahr_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","जर त्‍याले मेंढाना बळी अर्पण करानं व्‍हई ते त्यानी परमेश्‍वरना देखत अर्पण करानं. ");
INSERT INTO ahr_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","त्यानी त्‍या पशुना डोकावर त्‍याना हात ठेवानं अनं ते दर्शनमंडपनाजोडे मारानं अनं अहरोना पोर्‍यासनी त्‍याना रंगत वेदीना चारीबाजुले शितडानं. ");
INSERT INTO ahr_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","शांती अर्पणना यज्ञपशुना जे भागना परमेश्‍वर करता होम करानं शे ते आश शे त्यानी चरबी अनं पाठना कणामाईन कापीसन काढेल चरबी लागेल शेपटी, आतडासवर पसरेल चरबी अनं त्‍याले लागेल चरबी. ");
INSERT INTO ahr_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","दोन्‍ही गुर्दा, त्‍यानावरना कंबरना जोडेना अनं गुर्दयासपावोत काळजना वरना पडदा अलग करी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","याना सेवकसनी वेदीवर जाळानं; हाई परमेश्‍वर करता अर्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","बकरीनी बळी व्‍हईते त्यानी ते परमेश्वरना देखत अर्पानं. ");
INSERT INTO ahr_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","त्यानी त्‍याना डोकावर त्‍याना हात ठेवानं अनं दर्शनमंडपना समोर ते मारानं. अनी अहरोना पोर्‍यासनी त्‍यान रंगत वेदीवर चारीबाजुले शितडानं. ");
INSERT INTO ahr_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","हाई बळीना जे भाग परमेश्‍वरले भेट म्‍हणीसनी अर्पानं ते आशे शे; आतडासवर पसरेल चरबी, त्‍याले लागेल बठी चरबी, ");
INSERT INTO ahr_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","दोन्‍ही गुर्दा, त्‍यानावरना कंबरना जोडेनी चरबी अनं गुर्दासपावोत काळजना वरना पडदा अलग करी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","त्‍याना सेवकसनी वेदीवर जाळानं; हाई सुवासिक अर्पण शे; चरबी म्‍हणीसन जेवढं व्‍हई ते परमेश्‍वरनं शे. ");
INSERT INTO ahr_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","तुम्‍हीन चरबी अनं रंगत खावानं नई; हाऊ तुमले अनं तुमना घराणासले कायमना नियम शे. ");
INSERT INTO ahr_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","तवय परमेश्‍वर मोशेले बोलना, ");
INSERT INTO ahr_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","इस्राएल लोकेसले अस सांग; ज्‍या कामसले देवनी नही सांगेल शे तरी बी एखादानी चुकीसनी पाप करी टाकं तवय ते पाप कोणाकडतीन घडनं, ");
INSERT INTO ahr_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","लोकेसले पाप लागी आशे पाप अभिषिक्‍त सेवकनी करेल व्‍हई तर त्यानी त्‍याना पापनीकरता पापर्पण म्‍हणीसनी एखादा तरुण बैल परमेश्‍वरले अर्पानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","तो बैल देवना देखत दर्शनमंडपना दारपान त्यानी आनानं अनं त्‍याना डोकावर हात ठेईसनी देवनी देखत ते अर्पानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","अभिषिक्‍त सेवकसनी बैलनं थोडं रंगत आनीसनी दर्शनमंडपमा लई जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","अनी सेवक त्‍यासना बोट रंगतमा बुडाईसनी देवनी देखत पवित्र भागमा अंतरपटना समोर ते सात दाव शितडानं ");
INSERT INTO ahr_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","याजकसनी त्‍यामाईन काही रंगत लईसनी दर्शनमंडपमा देवनीमोरे धुपवेदीना शिंगासले लावानं; अनं बैलना बाकीना सर्व रंगत दर्शनमंडपना दारपान वती टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","त्‍यानंतर पापबळीना वासरुना बठी चरबी काढी टाकानं म्‍हणजे आतड्यासवर पसरेल चरबी अनं त्‍याले लागेल बठी चरबी, ");
INSERT INTO ahr_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","दोन्‍ही गुर्दा, त्‍यानावरना कमरना जोडे जी चरबी अनं गुर्दासपावोत काळजना वरना पडदा हाई सर्वा न्‍यारा करानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","जस हाई सर्व होमबळीना वासरूपाईन न्‍यारा करतस तसे हाई न्यारा करी टाकानं अनं ते सेवकसनी ते होमवेदीवर अर्पानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","बैलनं कातडं, मास, डोक, पाय, आतडी, शेण, ");
INSERT INTO ahr_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","हाई बठा बैल छावणीना बाहेर जठे राख टाकतस आशे शुध्‍द ठिकानले लयी जावानं अनं लाकडासवर ठेईसनी आगघाई जाळी टाकानं, जठे राख टाकतस तठे ते जाळानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","इस्राएलनी बठी मंडळीनी चुकीसन एखादं पाप करं अनं ते मंडळीले समजनं नई, जे काम देवनी नई सांगेल व्हतं, ते काम करं तर त्‍या दोषी ठरतीन, ");
INSERT INTO ahr_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","मंग त्‍यासनी करेल पाप उजेडमा उना, तवय मंडळीनी बैलनं पापबळी अर्पण करानं अनी तो दर्शनमंडपना समोर आणानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","मंडळी माईन पुठारीसनी परमेश्वरना देखत त्या बैलना डोकावर हात ठेवानं अनी त्याले परमेश्वरना देखत मारानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","अभिषिक्‍त सेवकसनी ते बैलनं जरासं रंगत लीसनी दर्शनमंडपमा आनानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","सेवकनी त्‍या रंगतमा त्‍याना बोट बुडावानं परमेश्वरना देखत, आंतरपटना समोर सात दाव शितडानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","मंग दर्शन मंडपमा परमेश्वरना समोर जी वेदी शे तिना शिंगसले काही रंगत लावानं; अनी बाकीनं सर्व रंगत लईसनी दर्शनमंडपना दारपान जी वेदी शे तिना पायथापान वती देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","त्या बैलनी बठी चरबी काढीसनी वेदीवर तिना होम करानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","पापार्पणना बैलना जसं करतस, तशच याना भी करानं; ह्या प्रकारे सेवकसनी इस्राएल लोकसना करता प्रायश्चित करानं, मनजे त्‍यासले क्षमा व्हई. ");
INSERT INTO ahr_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","पहिला बैल बाहेर लई जाईसनी जाळं तशं हाऊ भी बैल छावणीना बाहेर लईसनी जाळानं; हाई मंडळीना करता पापार्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","ज्‍या कामसले देवनी नई सांगेल शे अशं एखादं काम करी टाकं तो दोषी धराई जाई. ");
INSERT INTO ahr_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","अनी त्यानी करेल पाप त्‍याले समजनं; त्यानी परिपुर्ण आशे बोकडा बळी देवानं करता आणानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","त्यानी त्‍या बोकड्याना डोकावर हात ठेवानं. अनी परमेश्‍वरना समोर जठे यज्ञपशु मारतस तठे ते मारानं; हाई पापार्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","त्‍याना नंतर सेवकसनी त्‍याना बोटघाई ते पापार्पणनं काही रंगत लिसन होम वेदीना शिंगसले लावानं अनं बाकीनं सर्व रंगत होम वेदीना पायथावर वती टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","शांत्‍यर्पणना यज्ञपशूना चरबीनागत यानी भी बठी चरबी वेदीवर होम करी टाकानं; ह्या प्रकारे त्‍याना पापना करता सेवकसनी प्रायश्‍चित करानं मनजे त्यानी क्षमा व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","सामान्य लोकासमाईन एखादानं चुकीसनी पाप करेल व्‍हई मनजे ज्‍या कामे परमेश्वरनी नही सांगेल शे ते त्‍यासनी करी टाकेल व्‍हई तो दोषी ठरी. ");
INSERT INTO ahr_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","अनं त्यानी करेल पाप त्‍याले समजनं व्‍हई तर त्यानी ते पापना करता एखादी परिपुर्ण बकरी लई येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","अनं त्या पापार्पणना डोकावर हात ठेवानं अनी जठे होमबळी करतस त्‍या जागावर ते मारानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","त्‍या नंतर सेवकसनी त्‍याना बोटघाई ते पापार्पणना काही रंगत आणीसन होम वेदीना शिंगसले लावानं अनं बाकीना सर्व रंगत वेदीना पायथावर वती टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","अनी शांत्‍यर्पणना यज्ञपशुना चरबीना मायक याना भी बठी चरबी अलग करी टाकानं अनं याजकसनी ती परमेश्‍वरना करता सुखदायी हवन व्‍हई; त्‍या करता तिना वेदीनावर होम करानं; सेवकसनी त्‍याना करता प्रायश्‍चित करानं मनजे त्यानी क्षमा व्हई. ");
INSERT INTO ahr_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","जर त्यानी अर्पणना करता पापर्पण मेंढा आणेल व्‍हई ते निर्दोष राहावाले पाहिजे अनी ती मादी पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","त्यानी पापबळीना डोकावर हात ठेवानं अनं जठे होमबळी मारतस त्‍या ठिकाणले ते मारानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","त्‍या नंतर सेवकसनी त्‍याना बोटघाई ते पापबळीना काही रंगत आणीसन होमवेदीना शिंगसले लावानं अनं बाकीना रंगत वेदीना पायथावर वती टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","अनी शांत्‍यर्पणना कोकराना चरबीना मायक बठी चरबी अलग करी टाकानं अनी परमेश्‍वरना करता वेदीनावर हव्‍यवर तिना होम करानं; हाई पध्‍दतमा त्यानी करेल पापना करता सेवकसनी त्‍याना करता प्रायश्‍चित करानं मनजे त्यानी क्षमा व्हई. ");
INSERT INTO ahr_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","तु काही दखेल शे का, नाहिते काही ऐकेल शे आशे एखादानं साक्षीदार हाई नातातीन शपथ दिसन ईचारं व्‍हई अनं त्यानी सांगाले नही‍ बोली दिधं, हाई दोष त्‍याना कडतीन घडेल शे तर त्याले शिक्षा भेटी. ");
INSERT INTO ahr_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","जर एखादानं चुकीसनी अशुध्‍द् वस्‍तुले हात लाई दिद तर तो दोषी ठरी, मंग ते अशुध्‍द् वनपशुना राहो का मरेल ग्रामपशुना राहो नाहिते रांगणारं अशुध्‍द् मरेल जनावरसनं शव राहो. ");
INSERT INTO ahr_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","हाई प्रमाण एखाद माणुसनी एखादी अशुध्‍द् वस्‍तुले चुकीसनी हात लाय व्‍हई अनं हाई त्‍याले समजनं मनजे तो दोषी ठरी, मंग ती अशुध्‍द् होणारी वस्‍तु कशाभी परकारनी राहो. ");
INSERT INTO ahr_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","कोणी माणुसनी बरावाईट कराबद्दल अविचारमा शपथ लिदी व्‍हई, मंग अविचारमा लेयल कशाभी गोष्‍ट राहो अनं ती त्‍यान चुकीसनी करेल व्‍हई, अनं ती त्‍याले समजनं व्‍हई तर त्‍याले बठया गोष्‍टीनाबद्दल त्‍याले दोषी समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","तो अशा कशाभी गोष्‍टीमा दोषी व्‍हईना अनं त्यानी पाप कर व्‍हई तर त्यानी पाप कबुल करानं. ");
INSERT INTO ahr_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","त्यानी करेल पाप बद्दल परमेश्‍वरकरता दोष अर्पन आणानं; त्यानी गवारामाईन एक मादी मनजे मेंढी नाहिते बकरी पाप अर्पनाकरता आणानं. सेवकसनी त्‍याना पापना करता प्रायश्‍चित करानं. ");
INSERT INTO ahr_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","त्‍याले मेंढा देवानी ऐपत नही व्‍हईते त्यानी दोन होले नाहिते पारवासना दोन पिला दोष अर्पनाकरता परमेश्‍वरपान लई येवानं. त्‍यानामाईन एक पापर्पण अनं दुसरा होमर्पण करानं. ");
INSERT INTO ahr_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","त्यानी ती सेवकसकडे लई येवानं; त्‍यानंतर सेवकसनी पापबळी पहिला देवानं अनं त्यानी मुंडक मोडानं पण त्‍याले न्‍यारा करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","पापबळीना बाकीना रंगत वेदीनाजोडे शितडानं अनं बाकीना रंगत वेदीना पायथापान वतानं; हाई पापर्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","दुसरा चिडाना त्यानी विधिपुर्वक होम करानं. त्यानी करेल पापविषयी त्‍यानाकरता याजकसनी प्रायश्‍चित करानं; मनजे त्यानी क्षमा होई जाई. ");
INSERT INTO ahr_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","दोन होले नाहिते पारवासना दोन पिला हयाभी देवानी ऐपत नही व्‍हईते त्यानी त्‍याना पापनीबद्दल एक दशमांश मयदा पापार्पण म्‍हणीसनी आणानं अनं त्यानी त्‍यामा तेल टाकानं नही अनं धुप टाकानं नही कारण हाई पापार्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","त्यानी सेवकसकडे आणानं अनं सेवकसनी त्‍यामाईन मुठभर लईसनी स्‍मारकभाग म्‍हणीसनी वेदीवर परमेश्‍वरकरता करेल हवनावर त्‍याना होम करानं, हाई पापर्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","शेवट कशाभी गोष्‍टीसनाबारामा कोणी पाप करी तवय याजकसनी त्‍यानाकरता प्रायश्‍चित करानं मनजे त्यानी क्षमा‍ व्‍हई जाई ");
INSERT INTO ahr_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","तवय परमेश्‍वर मोशेले बोलना. ");
INSERT INTO ahr_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","जर कोणी परमेश्‍वरनी पविञ वस्‍तुनीबारामा अविश्‍वास देखाडी अनं चुकीसनी पाप कर व्‍हई त्यानी परमेश्‍वरले दोष अर्पण करानीकरता गवारामाईन एखादा परिपुर्ण मेंढा लई येवानं; तु ठरावसी तेवढा चांदीना शकेल एवढा राहावाले पाहिजे, हाई शकेल पविञस्‍थानंना पैसा परमानी राहावाले पाहिजे; हाई दोष अर्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","जी पविञ वस्‍तुनीबारामा त्यानी पाप कर व्‍हई तिना भरपाई करी दयावना; अनं ती वस्‍तुनी किंमतमा अजुन पाचवा भाग टाकीसनी सेवकसले देवानं; अनं सेवकसनी हाई दोष अर्पणना मेंढा अर्पण करीसनी त्‍याकरता प्रायश्‍चित करानं मनजे त्यानी क्षमा व्‍हई जाई. ");
INSERT INTO ahr_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","परमेश्‍वरनी नही सांगेल शे आशे पाप एखादाकडतीन व्‍हईल होई, मंग ते चुकीसनी का होयना त्‍याले दोषी समजानं; अनं त्‍याले पापना भार उचलं पडी. ");
INSERT INTO ahr_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","त्यानी मेंढासना गवारासमाईन एक परिपुर्ण मेंढा दोष अर्पणकरता सेवकसपान आणानं; तु ठरावसी तेवढी किंमतमा तो राहावाले पाहिजे; त्यानी चुकीसनी पाप करं व्‍हई त्‍याकरता सेवकसनं पाप झाकनं पडी, मनजे त्‍याले क्षमा व्‍हई ");
INSERT INTO ahr_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","हाई दोष अर्पण शे, परमेश्‍वरनी देखत तो माणुस नि:संशय दोषी शे. ");
INSERT INTO ahr_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","परमेश्‍वर मोशेले बोलना. ");
INSERT INTO ahr_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","जर एखादानी पाप करीसनी परमेश्‍वरना अपराधी व्‍हयना, मनजे ठेव, गहाण नाहिते लुट हयानीबारामा त्याना शेजारनी संगे करेल व्‍हई नाहिते त्‍यानावर जुलूम करेल व्‍हई. ");
INSERT INTO ahr_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","नाहिते एखादानी दवडेल वस्‍तु सापडेल व्‍हई अनं त्यानी त्‍याबारामा खोटी शपथ लीसनी लबाड बोलीसनी अशा गोष्‍टी करीसनी लोक पापमा पडतस, ");
INSERT INTO ahr_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","मनजे आशे पाप करीसनी दोषी व्‍हईना, त्‍याने लुट करीसनी, नाहिते जुलूम करीसनी काही लिद व्‍हई ते, नाहिते एखादानं देन बुडायल‍ व्‍हई ते, नाहिते एखादानं दवडेल वस्‍तु त्‍याले सापडेल व्‍हई अनं ती देयल नहि‍ व्‍हई ते. ");
INSERT INTO ahr_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","नाहिते एखादी वस्‍तुनाबारामा खोटी शपथ लिदी व्‍हई ते, ती बठी भरी दयावानं. जा दिवस त्‍याले दोषी लावामा येई, त्‍यारोजच ज्‍याना अपहार करेल‍ व्‍हई त्‍याले बठी भरपाई करी दयावानं अनी त्‍याल पाचवा भाग देवानं ");
INSERT INTO ahr_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","त्यानी परमवेश्‍वरकरता दोष अर्पण लई येवानं, तु ठरावशी तेवढी किंमतना गवारामाईन एक परिपुर्ण मेंढा दोष अर्पणीकरता सेवकसकडे लई येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","सेवकसनी तो घेईसनी परमेश्‍वर देखत त्‍यानाकरता प्रयाश्‍चित करानं, जे काही देवानं विरोधमा काम करेल‍ व्‍हई, त्यानी त्‍याले क्षमा व्‍हई. ");
INSERT INTO ahr_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","परमेश्‍वर मोशेला बोलना: ");
INSERT INTO ahr_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","अहरोन अनी त्‍यान पोरे यासले सांग, होमबळी आशे करानं, होमबळी वेदीनावर आगमा रातभर ठेईसनी ते सकाळ पावोत राहु दयावानं अनी वेदीनावरना आग जळता ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","अनी याजकसनी सणसना झगा घालीसनी त्‍यानंतर सणसनी चोळनी आंगवर झाकीसनी होमबळीना आगघाई भस्‍म व्‍हावा नंतर त्यानी जी राख राही ती काढीसनी वेदीनाबाजूले ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","मंग त्यानी कपडा काढीसनी दुसरा कपडा घालानं अनं ती राख छावणीबाहेर जठे शुध्‍द जागा व्‍हई तठे लई जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","वेदीवरनी आग वेदीवरच जळत ठेवानं, ती ईझु देऊ नको; याजकनी त्यानावर रोज सकाळले लाकडं लाईसन ती पेटत ठेवानं अनं त्‍यानावर होमबळी रचीसनी त्‍यानावर शांत्‍यर्पणना चरबीना होम करानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदीनावर आग एकसारखा जळत ठेवानं, ते ईझाले नही पाहिजे ");
INSERT INTO ahr_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","अन्‍न अर्पण विधि आशे शे: अहरोना पोर्‍यासनी परमेश्‍वरनीमोरे वेदीनाजोडे ते अन्‍न अर्पानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","त्‍या अन्‍न अर्पणमाईन मुठभरीनी मयदा, थोडा तेल अनं त्‍यावरला सर्वा लोबान घेईसनी ते अन्‍न अर्पणना स्‍मारकभागना परमेश्‍वरनी करता सुवासिक हवन व्‍हावाले पाहिजे‍ म्‍हणीसनी त्‍याना वेदीवर होम करानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","त्‍यामाईन जे उरेल राही ते अहरोना अनं त्‍याना पोर्‍यासनी खावानं, ते त्‍यासनी पविञ जागावर दर्शनमंडपना आंगणमा बिना खमिरना खावानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","जवय ते भुजतस तवय त्‍यामा खमीर टाकानं नही; ते मी भेटमाईन त्‍याना भाग‍ म्‍हणीसनी त्‍यासले देयेल शे; पापार्पण नाहिते दोषार्पण जशा परम पवित्र शे तशा हाई भी शे. ");
INSERT INTO ahr_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","अहरोनना संततीमाईन बठा माणसंसले ते खावानं हक्‍क शे; परमेश्‍वरनी भेट माईन हाई त्‍यासना हक्‍कना पिढयानी पिढया कायमना चालु राहावाले पाहिजे, हाई भेटले जो हात लाई तो पविञ व्हई जाई. ");
INSERT INTO ahr_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","परमेश्‍वर मोशेले बोलना, ");
INSERT INTO ahr_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","अहरोनले अभिषेक‍ व्‍हई त्‍यारोज त्यानी त्‍याना पोर्‍यासनी संगे परमेश्वरले जे अर्पण करानं शे ते हाई: एक दशमांस एफा मयदा रोजना अन्‍न अर्पण समजीने दयावानं अनी त्‍यामाईन अर्धा सकासले अनी अर्धा संध्‍याकाळले अर्पानं ");
INSERT INTO ahr_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ते तवावर तेलमा शिजाडानं, त्‍यामा तेल चांगला मुरानंतर ते लई येवानं अनी भुजेल अन्‍न अर्पणना वाटा पाडीसनी ते परमेश्‍वरनीकरता सुवासिक म्हणीसनी अर्पानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","त्‍याना पोर्‍यासमाईन जो त्‍याना जागवर अभिषिक्‍त व्‍हतीन त्‍यासनीभी आशेच अर्पण करानं. कायमना विधिपरमान परमेश्‍वरकरता बठा होम करी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","याजकसनी सर्वा अन्‍न अर्पणना बठा होम करी टाकानं अनं ती खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","परमेश्वर मोशेले बोलना; ");
INSERT INTO ahr_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","अहरोन अनी त्याना पोर्‍यासले सांग पाप अर्पणनं विधी आशे शे; ज्या ठिकानले होमपशु मारतसं तठेच परमेश्वरनामोरे पापबलीबी मारानं; तो परम पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","जो याजक पापबलीनं अर्पन करी त्यानी ते खावानं; दर्शनमंडपना आंगणमां पवित्र ठिकानले तो खावानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","त्याना मासना स्पर्श ज्याले व्हयी तो पवित्र; अनी त्याना रंगतना थेंब कपडासवर उडनं तर ते थेंब उडालेल कपडा एखादं पवित्र ठिकानले जाईसन धवानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","तो पापबली मडकामां शिजाडेल व्हयी ते मडकं फोडी टाकानं; पन पितळना भांडामां तो शिजाडं व्हयी तर ते घशीसनी पानीघाई धयी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","तो खावानं हक्क याजकवर्गमासला बठा माणसासले शे; तो परम पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","पन ते पापबलीनं काही रंगत दर्शनमंडपना पवित्र ठिकानले प्रायश्चितकरता आणतीन ते त्यानं मास खावानं नही, तो आगमा जायी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","दोष अर्पणना विधी आशे शे: हाई अर्पण अती पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ज्‍या ठिकाणले होमबळी मारानं शे त्‍या ठीकाणलेस दोष अर्पणना बळी मारानं अनी त्‍याना रंगत याजकनी वेदीना चारीबाजूले शितडानं ");
INSERT INTO ahr_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","त्यानी बठी चरबी त्यानी अर्पण करानं. त्यानी चरबीदार शेपटी, आतडयासवर पसरेल चरबी. ");
INSERT INTO ahr_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","दोन्‍ही गुर्दा, त्‍यानावरनी कमरनीजोडेनी चरबी अनं गुर्दापावोतना काळजनीवरना पडदा हाई‍ न्‍यारी काढी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","त्‍याना याजकनी वेदीवर परमेश्‍वरना करता वेदीना आगवर होम करानं; हाई दोष अर्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","हाई बळी खावानं हक याजकासमासले बठा माणसाले शे; ते पविञ ठीकाणले खावानं: ते परम पविञ शे. ");
INSERT INTO ahr_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","पापार्पण मायक दोष अर्पणनी विधी शे; दोन्‍ही विधी सारखाच शेतस; जो याजक त्‍याना कडतीन पापले झाकीसन, त्याना त्‍यानावर हक्‍क शे. ");
INSERT INTO ahr_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","जो याजक एखादा माणुसनीकरता होमबळीना अर्पण करी त्‍याना हक्‍क ते होमबळीना कातडयासवर शे. ");
INSERT INTO ahr_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","भट्टीना, कढाईमा नाहिते तवावर भाजेल बठा अन्‍नर्पणना यज्ञ करणारा याजकना शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","परतेक अन्‍नबळी, ते तेलमा राहो नाहिते कोयडा राहो, ते अहरोनना बठा वाडवडीलसना शे, त्‍या बठासना त्‍यानावर सारखाच हक्‍क शे. ");
INSERT INTO ahr_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","परमेश्‍वरना करता ज्‍यासले शांत्‍यर्पण करानं व्‍हई त्‍यासनी विधी आशे शे. ");
INSERT INTO ahr_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","त्‍याले ते उपकास्तुतीना करता करानं व्‍हई तर तेलमा तळेल बेखमीर भाकरी, तेल लायेल बेखमीर पापड्या अनी मैदामा मळेल, तेलमा तळेल पुर्‍या उपकारस्‍तुतीना अर्पणनासंगे अर्पण करानं. ");
INSERT INTO ahr_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","अनी हाई उपकारस्तुतीना शांत्यर्पणना यज्ञमा खमीर टाकेल भाकरीसनभी अर्पण करानं. ");
INSERT INTO ahr_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","त्‍या परतेक अर्पण माईन त्यानी एक एक भाकर परमेश्‍वरना करता समर्पित करेल आशे म्‍हणीसन अर्पण करानं. शांत्‍यर्पणना रंगत शितडणारा याजकना तिनावर हक्‍क शे. ");
INSERT INTO ahr_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","उपकारस्‍मरण म्‍हणीसनी व्‍हयेल शांत्‍यर्पणना यज्ञ बळीना मास अर्पण करानं दिवसलेस खावानं. सकाळपावोत त्‍यामा काहीच उराले नही पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","पण यज्ञबळीना अर्पण नवसना नाहिते स्‍वखुशीना व्‍हई तर ज्‍या दिनले ते तो अर्पण करी त्‍या दिनले ते खावानं अनी ज्‍या काही त्‍यामा राही ते दुसरा रोज खावानं. ");
INSERT INTO ahr_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ते यज्ञबळीमाईन बाकीना मास तिसरा रोज उरेल व्‍हईते ते आगमा जाळी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","त्‍याना शांती अर्पण यज्ञबळीना मासमाईन बाकीना तिसरा रोज खावामा वनं व्‍हईते ते मान्‍य व्‍हवाऊ नही. उलटं, ते अमंगळ व्हयी; अनी जो कोनी ते खादं त्याले त्यानी अपराधनी शिक्षा भेटी. ");
INSERT INTO ahr_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","ज्‍या मांसले एखादी अशुध्द वस्‍तुना स्‍पर्श‍ व्‍हयेल वई ते खावानं नही. तर ते आगमा जाळी टाकानं, जे शुध्‍द व्‍हई त्‍यानीच यज्ञबळीनं मांस खावानं; ");
INSERT INTO ahr_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","पण एखादामा अशुध्‍दता शे अनी तो परमेश्‍वरकरता व्‍हयेल शांत्‍यर्पणना यज्ञ अर्पणना मांस खाई त्‍याना आपला लोकेसमाईन नाश व्‍हवाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","एखादा माणुसनी एखादी अशुध्‍द वस्‍तुले हात लाई दिधं व्‍हई, मंग ती अशुध्‍द माणुसना असो किवा पशुना असो नाहिते दुसरा एखादाना अमंगळ वस्‍तुना राहो, त्यानी परमेश्‍वरकरता करेल शांत्‍यर्पणना यज्ञ अर्पणनं मास खादं व्‍हई ते, त्‍याना आपला लोकेसमाईन नाश व्‍हवाले पाहीजे ");
INSERT INTO ahr_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","परमेश्‍वर मोशेले बोलना; ");
INSERT INTO ahr_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","इस्राएल लोकसले अशं सांग, तुम्‍हीन बैलनी, मेंढरासनी नाहिते बकरीनी चरबी खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","त्‍यासना-त्‍यासना मरेल जनावरसनी नाहीते दुसरा पशुनी फाडी टाकेल जनावरनी चरबी दुसरा काही कामले पाहिजे व्‍हईते ते लावानं, पण ते अजीबात खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","परमेश्‍वरकरता भेट म्‍हणीसनी जे यज्ञअर्पण आगमा होम करिसनी अर्पण करतस त्यानी चरबी कोणी खाद तर त्‍याना आपला लोकेसमाईन नाश व्‍हवाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","तुम्‍ही ज्‍यानात्‍याना घर चिडासना, जनावरसना आशे कसानभी रंगत खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","जो कोणी रंगत खाई त्‍याना आपला लोकेसमाईन नाश व्‍हावाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","परमेश्‍वर मोशेले बोलना; ");
INSERT INTO ahr_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","इस्राएल लोकसले सांग, जो कोणी परमेश्‍वरकरता शांत्‍यर्पणना यज्ञबळीना अर्पण करी त्यानी ते शांत्‍यर्पणना काही भाग परमेश्‍वरना समोर लई येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","त्यानी त्‍याना हातघाई परमेश्‍वरकरता हवन लई येवानं, परमेश्‍वना समोर ओवाळनीना अर्पण म्हणीसन ओवाळणीना करता चरबीना संगे आणानं. ");
INSERT INTO ahr_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","याजकनी ती चरबीना वेदीनावर होम करानं पण बळीना ऊर अहरोना अनी त्‍याना वंशजना राही. ");
INSERT INTO ahr_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","तुम्‍ही आपला शांत्‍यर्पणना यज्ञबळीना उजवा फरा समर्पित व्‍हयेल अंश म्‍हणीसनी याजकले दयावानं. ");
INSERT INTO ahr_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","अहरोनना पोर्‍यासमाईन जो कोणी शांत्‍यर्पणना यज्ञबळीना रंगत नाहीते चरबी याना अर्पण करी त्‍याना हक्‍क त्‍या उजवा फरासवर राव्‍हाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","कारण इस्‍ञाएल लोकेसना शांत्‍यर्पणमाईन ओवाळणीना ऊर अनी समर्पणना फरा हाई मी अहरोन याजक अनी त्‍याना पोर्‍या यासले दी राहीनू शे. हया दोन्‍ही इस्‍ञाएल लोकेसकडीन मिळणारा त्‍यासना कायमना हक्‍क शे. ");
INSERT INTO ahr_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","याजक हाई नातातीन परमेश्‍वरनी सेवा कराकरता अहरोन अनी त्‍याना पोर्‍या जवय त्‍यासले सादर करामा व्‍हनात त्‍यारोज परमेश्‍वरकरता लयाना हव्‍यासमाईन हाई त्‍याना अनी त्‍याना पोर्‍यासना पोर्‍यासले अभिषेक भाग ठरना शे. ");
INSERT INTO ahr_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ज्‍यारोज परमेश्‍वरनी त्‍यासना अभिषेक करा त्‍यारोज त्यानी त्‍यासले इस्राएल लोकासकडतीन हाई भाग मिळाले पाहिजे आशी आज्ञा करी. म्‍हणुन त्‍यासले पिढयानपिढया हाई हक्‍क कायमना ठरना. ");
INSERT INTO ahr_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","होमबली, अन्‍नबलि, पापबलि, दोषबलि याजकना समर्पणना येळले बलि अनी शांत्‍यर्पणना अशं शे. ");
INSERT INTO ahr_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","सीनाय जंगलमा इस्राएल लोकसनी परमेश्‍वरले काय काय अर्पण करानं हयानाबद्द्ल त्‍यासले आज्ञा दिधी, त्‍या वेळले त्यानी मोशेले याना परमान सीनाय डोंगरवर हाई विधि लाई दिधी. ");
INSERT INTO ahr_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","परमेश्‍वर मोशेले बोलना ");
INSERT INTO ahr_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","तु अहरोन अनी त्‍यानासंगे त्‍याना पोर्‍या यासले अनी त्‍यासना कपडा, अभिषेकना तेल पापबलिकरता बैल, दोन मेंढा अनी बेखमीर भाकरीसनी टोपली लईसनी. ");
INSERT INTO ahr_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","दर्शनमंडपना दारपान ये अनी तठे बठी मंडळीसले जमा कर. ");
INSERT INTO ahr_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","परमेश्‍वरनी आज्ञापरमानं मोशेनी करं अनी मंडळी दर्शनमंडपना दारपान जमा व्‍हयनी. ");
INSERT INTO ahr_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","मोशेनी मंडळीले सांग, परमेश्‍वरनी जे काही करानी आज्ञा देयेल शे ती आशी; ");
INSERT INTO ahr_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","मोशेनी अहरोन अनी त्‍याना पोर्‍या यासले आणीसनी त्‍यासना जलस्‍नान करं. ");
INSERT INTO ahr_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","मंग त्यानी त्‍यासले कपडा घाला, त्‍यासना करमरले कमरबंद बांध, झगा घाल, त्‍यानावर एफोद घाला अनी नक्षीदार पट्टी एफोदनावरतीन तानीसन बांधी. ");
INSERT INTO ahr_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","मंग त्यानी त्‍यानावर उरपट बांधा अनी त्‍यानामां उरीम अनी थुम्‍मीम ठेव. ");
INSERT INTO ahr_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","मंग त्‍याना डोकामा फेटा घाला अनी फेटाना समोरना भागमा सोनानी पट्टी म्‍हणजे पवित्र मुकूट लावं, परमेश्‍वरनी मोशेले आज्ञा देयेल परमानं हाई व्‍हयनं. ");
INSERT INTO ahr_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","मंग मोशेनी अभिषेकना तेल लईसनी निवासमंडपले अनी त्‍यामासले बठया वस्‍तुसले अभिषेक करीसनी पवित्र करं ");
INSERT INTO ahr_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","त्‍यामाईन काही तेल लईसनी त्यानी वेदीवर सातदाव शितडानं अनी वेदी, तिना बठा उपकरणं, गंगाळ अनी त्यानी बैठक याले अभिषेक करीसनी त्‍याले पवित्र करं. ");
INSERT INTO ahr_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","त्यानी अभिषेकना काही तेल लईसनी अहरोना डोकावर वतं. हाईपरमानं अभिषेक करीसनी त्‍याले पवित्र करं. ");
INSERT INTO ahr_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","मंग मोशेनी अहरोना पोर्‍यासले आणं, त्‍यासले कपडा घालात, कमरले कमरबंद तानीसनी बांध अनी त्‍यासले फेटा बांध. परमेश्‍वरनी मोशाले आज्ञा करं होत तशे हाई व्‍हईनं. ");
INSERT INTO ahr_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","मंग त्यानी पापार्पणना वासरु आणं अनी अहरोन अनी त्‍याना पोऱ्‍या यासनी अपला हात त्‍या पापार्पणना बैलना डोकावर ठेवं. ");
INSERT INTO ahr_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ते मारा नंतर माशेनी त्‍यानं रंगत लिसन त्‍याना बोटघाई वेदीना चारी शिंगसना चारीबाजूले लाईसनी ती शुध्‍द करं अनी ते रंगत वेदीना पायनाजोडे वतं अनी तिनाकरता प्रायश्‍चित करीसनी तिले पवित्र करं. ");
INSERT INTO ahr_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","मोशेनी आतडयासवरना बठी चरबी, काळीजनीवरना पडदा अनी चरबीनीसंगे दोन्‍ही गुर्दा हाई लईसनी त्‍याना होम करी टाकं. ");
INSERT INTO ahr_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","बैल, त्‍याना कातडा, त्‍याना मास अनी त्यानी ईष्‍टा हाई बठी तळनीबाहेर लईसनी ते आगघाई जाळी टाकं. परमेश्वरनी मोशेले आज्ञा देयलपरमानं त्यासनी हाई करं, ");
INSERT INTO ahr_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","मंग त्यानी होमबळीना मेंढा जोडे आनं तवय अहरोना अनी त्‍याना पोर्‍या यासनी त्‍यासना हात मेंढासना डोकावर ठेवं. ");
INSERT INTO ahr_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","त्‍याले मारा नंतर मोशेनी त्‍याना रंगत वेदीना चारीबाजूले शितडां ");
INSERT INTO ahr_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","मंग त्‍या मेंढाना तुकडा करा अनी मोशेनी त्‍याना डोका, त्‍याना मासना तुकडा अनी चरबी हयाना होम करं. ");
INSERT INTO ahr_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","आतडा अनी पाय पाणीघाई धईसनी मोशानी बठा मेंढाना होम करी टाकं, ते परमेश्‍वरकरता सुवासीक होमबळी व्‍हयना; परमेश्‍वरनी मोशेले आज्ञा करी व्‍हती तशे हाई व्‍हयनं. ");
INSERT INTO ahr_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","मंग त्यानी दुसरा मेंढा मनजे समर्पणाना मेंढा जोडे आणा, अहरोन अनी त्‍याना पोर्‍या यासनी त्‍यासना हात मेंढाना डोकावर ठेवं. ");
INSERT INTO ahr_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ते मारानंतर त्‍याना काही रंगत मोशेनी लईसनी अहरोनना उजवा कानना शेंडाले, उजवा हातना अंगठाले अनी उजवा पायनी अंगठाले लावं. ");
INSERT INTO ahr_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","मंग मोशेनी अहरोनना पोर्‍यासपान आनीसनी त्‍याना उजवा कानना शेंडाले, उजवा हातना अंगठाले अनी उजवा पायना अंगठाले लावं. मंग मोशेनी वेदीना चारीबाजूले शितडं. ");
INSERT INTO ahr_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","त्यानी चरबी, चरबीदार शेपटी आतडयासवर राहेल बठी चरबी, काळीजनीवरना पडदा, दोन्‍ही गुर्दा, त्‍यानवरनी चरबी अनी उजवा फरा हाई काढी लिदी. ");
INSERT INTO ahr_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","परमेश्‍वरनीमोरे ठेयेल बेखमीर भाकरीन्‍या टोपलीमाईन एक भाकर, तेल लायेल एक पोळी अनी एक पोळी लईसनी त्‍या चरबीवर अनी उजवा मांडीवर ठेवं. ");
INSERT INTO ahr_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","हाई बठा त्यानी अहरोनना अनी त्‍याना पोर्‍यासनी हातसवर ठेवं अनी परमेश्‍वरनीमोरे ओवाळणीनं अर्पण म्‍हणीसनी ते ओवाळानं. ");
INSERT INTO ahr_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","मंग मोशेनी त्‍यासना हातमाईन लईसनी त्‍यासना वेदीनावरना होमबळीवर होम करं; हाई समर्पणना परमेश्‍वरनीकरता सुवासिक भेट व्‍हयनं. ");
INSERT INTO ahr_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","मंग मोशेनी ऊर लईसनी परमेश्‍वरनीमोरे ओवाळणीनं अर्पण म्‍हणीसनी ओवाळी लिदं, समर्पणना मेंढाना हाई भाग मोशाना व्‍हता. परमेश्वरनी मोशेले आज्ञा करी व्‍हती तशे हाई व्‍हयनं. ");
INSERT INTO ahr_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","मंग मोशेनी अभिषेकना तेल अनी वेदीनावरना रंगत थोडासा लईसनी अहरोन अनी त्‍याना कपडा, त्‍याना पोर्‍या अनी त्‍यासना कपडा यासवर शितडं अनी अहरोन अनी त्‍याना कपडा अनी त्‍यान पोर्‍या अनी त्‍यासना कपडा पवित्र करं. ");
INSERT INTO ahr_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","मोशेनी अहरोन अनी त्‍याना पोर्‍या यासले सांग, हाई मास दर्शनमंडपना दारपान शिजाडानं अनी तठे समर्पणना टोपलीमाईन भाकरीनासंगे ते खा. अहरोन अनी त्‍याना पोर्‍या यासनी ते खावानं आशी आज्ञा मी देयेल शे. ");
INSERT INTO ahr_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","मास अनी भाकरी यामाईन जे काही उरेल व्‍हयी ते आगमा जाळी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","तुम्‍हना समर्पणनी विधीना दिवस पुरा व्‍हतस तोपावत म्‍हणजे सात दिवस दर्शनमंडपना दारनामोरे जावाले नही पाहिजे, कारण सात दिवसपावोत तुम्‍हना समर्पणनी विधी व्‍हई. ");
INSERT INTO ahr_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","तुम्‍हनाकरता प्रायश्‍चित व्‍हावाले पाहिजे‍ म्‍हणीसनी आज करं त्‍यापरमान करानी आज्ञा परमेश्‍वरनी देयेल शे. ");
INSERT INTO ahr_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","हाई परकारे तुम्‍ही दर्शनमंडपना दारपान सात दिवस रात्र अनी दिवस राहीसनी परमेश्वरनी आज्ञापरमाने वर्तन करानं. नहीते तुमीन मरशात; कारण माले आशी आज्ञा शे. ");
INSERT INTO ahr_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","परमेश्‍वरनी मोशेनीव्दारे ज्‍या गोष्‍टीनीबारामा आज्ञा करेल व्‍हता त्‍या सर्वा अहरोन अनी त्‍याना पोर्‍या यासनी करं. ");
INSERT INTO ahr_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठवा दिवसले मोशेनी अहरोन, त्‍याना पोर्‍या अनी इस्‍ञाएलना वडील यासले बलावं. ");
INSERT INTO ahr_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","त्यानी अहरोनले सांग, पापार्पणकरता एक परिपुर्ण वासरु अनी होमार्पणाकरता एक परिपुर्ण मेंढा लईसनी परमेश्‍वरनीमोरे अर्पण कर; ");
INSERT INTO ahr_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","अनी इस्राएल लोकसले आशे सांगानं, पापार्पणाकरता एक बोकड लई येवानं. अनी होमार्पणाकरता एक वासरु अनी मेंढा लई येवानं. हाई दोनी एक वरीसना अनं परिपुर्ण ऱ्हावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","अनी परमेश्‍वरनीमोरे शांत्‍यर्पणे कराकरता एक बैल, एक मेंढा अनी तेलमा टाकीसनी अन्‍न अर्पण लई येवानं. कारण परमेश्‍वर आज तुम्‍हले दर्शन देणार शे. ");
INSERT INTO ahr_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","मंग मोशेनी आज्ञा देयेल परमानं त्‍यासनी त्‍या बठा दर्शनमंडपना दारपान लई व्‍हना अनी सर्वी मंडळी जोडे जाईसनी परमेश्‍वरनामोरे उभी राहीनी. ");
INSERT INTO ahr_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","तवय मोशे बोलना; तुम्‍हले जे काही करानं म्‍हणीसनी परमेश्‍वरनी आज्ञा दिदी ती आशी; मंग परमेश्‍वरनी महिमा तुम्‍हना दृष्‍टिमा पडी. ");
INSERT INTO ahr_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","मोशेनी अहरोनले सांग; वेदीनाजोडे जाईसनी आपला पापबळी अनी होमबळी यानां अर्पण कर अनी स्‍वताकरता अनी लोकेसकरता पाप झाकी; अनी लोकासकडले बळीभी अर्पण करीसनी त्‍याकरता प्रायश्‍चित कर; परमेश्‍वरनी आज्ञा देयल परमानं हाई कर; ");
INSERT INTO ahr_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","तवय अहरोनी वेदीनाजोडे जाईसनी त्‍याना पापार्पणना वासरु अर्पण करं. ");
INSERT INTO ahr_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","अहरोना पोर्‍या त्‍यानाकडे रंगत लई गयात, तवय त्यानी त्‍याना बोट बुडाईसनी ते वेदीना शिंगासले लावं अनी ते वेदीना पायथाले वतं. ");
INSERT INTO ahr_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","पापबळीनी चरबी, गुर्दा अनी काळीजनीवरना पडदा हयाना त्यानी वेदीवर होम करा. परमेश्‍वरनी मोशेले आज्ञा करी व्‍हती तशे व्‍हयनं ");
INSERT INTO ahr_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","मास अनी कातडा त्यानी छावनीनाबाहेर आणीसनी आगघाई जाळी टाकं. ");
INSERT INTO ahr_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","मंग त्यानी होमबळीना पशु मारं तवय अहरोनना पोर्‍यासनी त्‍याना रंगत त्‍याले दिद्. त्यानी ते लईसनी वेदीना आजुबाजूले शितडी दिद्. ");
INSERT INTO ahr_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","मग‍ त्‍यासनी ते होमबळीनं तुकडा करीसनी एक एक तुकडा अनी मस्‍तक हाई त्‍यानापान दिद् त्‍यासना त्यानी वेदीवर जाळी टाकं. ");
INSERT INTO ahr_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","मंग त्यानी आतडा अनी पाय धईसनी वेदीनावरना त्‍याना होमबळीनावर होम करं. ");
INSERT INTO ahr_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","मंग त्यानी लोकासकडले अर्पण जोडे लईसनी त्‍यासनाकरता आणेल पापार्पणना बोकड मारं अनी पहिलापरमानं तेभी पापबळी म्‍हणीसनी अर्पण करं. ");
INSERT INTO ahr_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","अनी त्यानी होमबळीलेभी जोडे लईसनी विधीपुर्वक अर्पण करं. ");
INSERT INTO ahr_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","मंग त्यानी अन्‍न अर्पण जोडे आणं अनी त्‍यामासाला मुठ भरीसनी त्‍याना वेदीवर होम करां. ");
INSERT INTO ahr_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","बैल अनी मेंढा ज्‍या लोकासकरता शांत्‍यर्पण म्‍हणीसनी आणं व्‍हतं ते‍ त्यानी मारं अनी अहरोनना पोर्‍यासनी त्‍यासना रंगत त्‍यासना जोडे दिद्, ते‍ त्यानी वेदीना चारीमेर शितडं; ");
INSERT INTO ahr_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","त्यानी बैलासनी अनी मेंढासनी वपा अनी मेंढासनी चरबीदार शेपटी आतडयासनीवरनी चरबी गुर्दा अनी काळजना पडदा हाई त्‍याले दिदि. ");
INSERT INTO ahr_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","अनी त्‍यासनी चरबी त्‍या बळीना उरवर ठेवानंतर त्यानी तिना वेदीवर होम करं. ");
INSERT INTO ahr_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","उर अनी उजवी मांडी हाई मोशेनी आज्ञापरमानं अहरोननी परमेश्‍वरनीमोरे ओवाळणीनं अर्पण म्‍हणीसनी ओवाळी टाकं. ");
INSERT INTO ahr_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","मंग अहरोननी लोकेसकडे वळीसनी हात वर करीसनी त्‍यासले आशिर्वाद दिदा अनी जठे त्यानी पापार्पणबळी, होमार्पणबळी अनी शांत्‍यार्पणबळी यासना अर्पण करं व्‍हतं तथाईन उतरीसनी खाल व्‍हनां. ");
INSERT INTO ahr_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","मंग मोशे अनी अहरोन दर्शनमंडपमा गयात अनी बाहेर येईसनी लोकेसले आशीर्वाद दिधा, तवय परमेश्‍वरनी महीमा बठा लोकेसले दखायनी. ");
INSERT INTO ahr_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","अनी परमेश्‍वरकडतीन आग व्‍हनं अनी त्यानी वेदीनावरना होमबळी अनी चरबी हाई जाळी टाकं; हाई दखीसनी बठा माणसेनी जयजयकार करं अनी साष्‍टांग नमस्‍कार करं. ");
INSERT INTO ahr_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","मंग अहरोनना पोर्‍या नादाब अनी अबीहू यासनी ज्‍यानात्‍याना धुपाटण लईसनी त्‍यामा आग टाकं अनी त्‍यानावर धूप टाकीसनी ते अशुध्द अग्‍नी परमेश्‍वरनीमोरे आणं; आशे अग्नी लई जावानाबारामा परमेश्‍वरनी आज्ञा कायनी व्‍हती. ");
INSERT INTO ahr_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","तवय परमेश्‍वरकडतीन आग व्‍हनं अनी त्यानी त्‍यासले भस्‍म करी टाकं अनी परमेश्‍वरनी देखत मरी गयात. ");
INSERT INTO ahr_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","मंग मोशेनी अहरोनले सांग; परमेश्‍वरनी सांगेल शे ते हाई, ज्‍या मनाजोडे येतीन त्‍यासनी माले पवित्र मानानं अनी सर्वा लोकासनासमोर म्‍हना महिमा व्‍हावाले पाहिजे; तवय अहरोन शांत व्‍हईना. ");
INSERT INTO ahr_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","मंग अहरोनना चुलतभाऊ उज्‍जीयेल याना पोर्‍या मिशाएल अनी एलसाफान यासले मोशेनी बलाईसनी सांग की तुम्‍ही इकडे या, तुम्‍हना भाऊसले पविञस्‍थाननामोरेतीन छावणीनीबाहेर लई जा. ");
INSERT INTO ahr_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","मोशेनी आज्ञापरमानं त्‍या व्‍हनातं अनी त्‍यासना कपडासुध्‍दा छावणीनाबाहेर लई गयात. ");
INSERT INTO ahr_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","मोशेनी अहरोन अनी त्‍याना पोर्‍या एलाजार अनी इथामार यासले सांग की तुम्‍ही आपला डोकासनं केस मोकळ सोडानं नही अनी आपला कपडा फाडानं नही; जर तुम्‍ही तशे करं तर मरशी अनी सर्वा मंडळीवर परमेश्‍वरना कोप भडकी; परमेश्‍वरनी जे हाई अग्‍नी पेटाडेल व्‍हतं त्‍यानीबारामा तरी तुम्‍हना भाऊबंदसनी म्‍हणजे सर्वा इस्राएल घराणानी शोक करानं. ");
INSERT INTO ahr_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","तुम्‍ही दर्शनमंडपना दारनीबाहेर जावानं नही; जाशी ते मरशी: कारण परमेश्‍वरनी विहीत करेल अभिषेकना तेलघाई तुम्‍हना अभिषेक व्‍हयेल शे; त्‍यासनी मोशानी सांगेलपरमानं करं. ");
INSERT INTO ahr_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","अजुन परमेश्‍वरनी अहरोनले सांग: ");
INSERT INTO ahr_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","जवय-जवय तुम्‍ही मनजे तु अनी तुना पोर्‍या दर्शनमंडपमा जातीन तवय तुम्‍हनामाईन कोणी द्राक्षरस नाहिते कोनता भी परकारनी दारु पेव्‍हानं नही, पिसी ते मरशी; हाई तुम्‍हनाकरता पिढयानपिढया कायमना नियम शे: ");
INSERT INTO ahr_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","हाई परमानं तुम्‍ही पवित्र अनी अपवित्र, शुध्‍द अनी अशुध्‍द यामासला भेद वयखानं. ");
INSERT INTO ahr_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","अनी परमेश्‍वरनी मोशानीव्दारे सांग सर्वा नियम तुम्‍ही इस्राएल लोकेसले शिकाडानं. ");
INSERT INTO ahr_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","मंग मोशेनी अहरोनले अनी त्‍याना बाकीना उरेल पोर्‍या म्‍हणजे एलाजार अनी इथामार यासले सांग की परमेश्‍वरनी हव्‍यामाईन जे अन्‍नार्पण बाकी ऱ्हाई ते लईसनी वेदीपान बिगर खमिरनं खाशी; कारण ते परम पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ते तुम्‍ही पवित्र ठिकानं खावानं, परमेश्‍वरले हव्‍यासमाईन तो तुना अनी तुना वंशजना हक्‍क शे; माले आशीच आज्ञा व्‍हयेल शे. ");
INSERT INTO ahr_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ओवाळेल ऊर अनी समर्पित करेल फरा हाई तुम्‍ही तुम्‍हना पोर्‍या अनी पोरीसोबत शुध्‍द ठिकाणले बशीनी खावानं; कारण इस्राएल लोकेसनी करेल शांत्‍यर्पणमाईन तुले अनी तुना पोर्‍यासोर्‍यासना ते हक्‍क म्‍हणीसनी देयेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","समर्पण करानं फरा अनी ओवाळानं ऊर हाई चरबीना हव्‍यांसना सोबत ओवाळणीनं अर्पण, त्‍याकरता परमेश्‍वरना देखत आणानं; हाई तुम्‍हना अनी तूम्‍हना वंशना कायमना हक्‍क शे; आशी परमेश्‍वरनी आज्ञा शे. ");
INSERT INTO ahr_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","मोशेनी पापबळीना बोकडले ध्यान दिसन दखं; तवय त्‍याले सापडनं की ते जाळी टाकं व्‍हतं, हाई देखसनी अहरोनना बाकी ऱ्हायेल पोर्‍या एलाजार अनी इथामार यासले संताप करिसनी बोलना. ");
INSERT INTO ahr_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","तुम्‍ही पापबळी पवित्र ठिकानं काबर खादं नही? ते परमपवित्र शे अनी मंडळीना दुष्‍कर्मासना भार वाहीसनी त्‍यासना करता परमेश्‍वरनामोरे प्रायश्‍चित करानं याकरता ते तुम्‍हले देयेल शे. ");
INSERT INTO ahr_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","दखा, त्‍याना रंगत पवित्र ठिकाणले मजारमा लयं नही, तुम्‍ही मना आज्ञापरमानं त्‍याना मास खावालेच पाहिजे व्हतं. ");
INSERT INTO ahr_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","याना उत्‍तर अहरोननी मोशेले दिधं की दखं, आज त्‍यासनी पापबळी अनी होमबळी हाई परमेश्‍वरनामोरे अर्पण करं म्‍हणुन मनावर आशे संकट येयल शेतस; समजा आज मी पापबळी खाई लिधं व्‍हतं ते परमेश्‍वरलं चांगलं वाटी कां? ");
INSERT INTO ahr_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","जवय मोशेले हाई ऐकं मंग त्याले चांगलं वाटनं. ");
INSERT INTO ahr_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","परमेश्‍वरनी मोशे अनी अहरोनले सांग; ");
INSERT INTO ahr_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","इस्राएल लोकेसले सांगानं की, जगमासला पशुसमाईन ज्‍याना मास तुम्‍हले खावानं शे ते हाई; ");
INSERT INTO ahr_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","जनावरसमाईन ज्‍याना खुर चिरेल शे नाहिते दुभागेल शेतस अनी ज्‍या रवंथ करंतस त्‍या बठा तुम्‍ही खावानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","पण ज्‍या नुसता रवंथ करंतस नाहिते ज्‍यासना नुसता खुर चिरेल शेतस त्‍या खावानं नही, उंट हाई रवंथ करस पण त्‍याना खुर चिरेल नही शे म्‍हणुन ते अशुध्द शे. ");
INSERT INTO ahr_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","शाफान रवंथ करस पण त्‍याना खुर चिरेल नही, म्‍हणुन ते तुम्‍हले अशुध्द शे. ");
INSERT INTO ahr_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ससा रवंथ करस पण त्‍याना खुर चिरेल नही, म्‍हणीन ते भी तुमना करतता अशुध्द शे. ");
INSERT INTO ahr_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","डुकरना खुर चिरीसनी दुभागेल शे पण ते रवंथ करस नही, म्‍हणीन ते भी तुमना करतता अशुध्द शे. ");
INSERT INTO ahr_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","त्‍यासना मास खावानं नही, त्‍यासना शवले हात लावानं नही, तुम्‍हले हाई बठा अशुध्द शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","पाणीमासले जे खावानं ते हाई शे; समुद्रमा अनी नदयासमा राहाणारा ज्‍या प्राणीसले पख अनी खवला शेतस त्‍या तुम्‍ही खावानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","पाणीमासाला ज्‍या प्राण्‍यासले पख नाहीते खवला नही आशे समुद्रमा अनी नदयासमा राहाणारा बठा पाणीमासाला प्राणी अमंगळ शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","तुम्‍ही त्‍यासले अमंगळ समजानं; त्‍यासना मास खावानं नही अनी त्‍यासना शवसले अमंगळ समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","जलाशयामासला‍ ज्‍या प्राण्‍यासले पख नही अनी खवलाबी नही त्‍या बठासले अमंगळ समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","चिडासमाईन जे अमंगळ समजीसनी खावानं नही त्‍या हया शेतस; गरुड, लोळणारा गीध, कुरर ");
INSERT INTO ahr_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","घार, न्‍यार्‍या-न्‍यार्‍या जातीसना ससाणा, ");
INSERT INTO ahr_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","परतेक जातना हाडयाल ");
INSERT INTO ahr_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","शहामग, गवळण, कोकीळा न्‍यारा-न्‍यारा जातीसना बहिराससाणं ");
INSERT INTO ahr_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","पिंगळा, करडोक, मोठा घुबड, ");
INSERT INTO ahr_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","राजहंस, पाणकोळी, गिधाड ");
INSERT INTO ahr_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","करकोच, अलग अलग जातीसना बगळा, टीटवी अनी वटवाघुळ. ");
INSERT INTO ahr_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","ज्‍या पखासवाले प्राणी पायसवर चालतस त्‍यासले तुम्‍ही अमंगळ समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","पण चार पायसवर चालणारा पखासवाले प्राण्‍यासमाईन ज्‍यासले जमीनवर उडया माराले पायसनावर तंगडया राहतस त्‍या खावानं ");
INSERT INTO ahr_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","त्‍यासमाईन जे खावानं शेतस त्‍या हाई; टोळ, नाकतोडा, खरपुडे, गवत्‍यटोळ हाई खावानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","जमीनवर रांगणारा चार पायसना पखसना प्राणी तुम्‍ही अमंगळ समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","त्‍यासनामुळे तुम्‍ही अशुध्‍द व्‍हई जातीन. जो कोणी त्‍यासना शवसले स्‍पर्श करी त्यानी संध्‍याकाळपावोत अशुध्‍दच राव्‍हानं ");
INSERT INTO ahr_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","त्‍यासना शवसना एकादा भाग कोणी उचलं तर ‍त्‍यानी आपला कपडा धईसनी संध्‍याकाळपावोत अशुध्‍दस राव्‍हानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ज्‍या पशुसना खुर चिरेल शे पण दुभागेल नही अनी रवंथ करतस नही ते तुम्‍हले अशुध्द शेतस; त्‍यासले ज्‍याना स्‍पर्श व्‍हई त्यानी अशुद्धच राव्‍हानं ");
INSERT INTO ahr_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","चार पायसावर चालणारा बठा पशुसमाईन ज्‍या आपला पंजासवर चालतस त्‍या तुम्‍हले अशुध्द शेतस; त्‍यासना शवसले जो स्‍पर्श करी त्यानी संध्‍याकाळपावोत अशुद्धच राहावानं ");
INSERT INTO ahr_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ज्‍यानी त्‍यासना शव उचलं त्यानी आपला कपडा धईसनी संध्‍याकाळपावोत अशुध्‍दस राहावानं, कारण ते तुम्‍हले निषिध्‍द् शेतस; ");
INSERT INTO ahr_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","जमीनवर रांगणारा जीवसमाईन तुम्‍हले निषिध्‍द त्‍या हया शेतस; मुंगूस, उंदिर, वेगवेगळया जातीसना सरडा ");
INSERT INTO ahr_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","चौपई, घोरपड,पाल, सांडा अनी गुहिर्‍या सरडा ");
INSERT INTO ahr_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","जमीनावर रांगणारासमाईन हाई बठा तुम्‍हले निषिध्‍द शेतस; जो कोणी त्‍यासना शवसले स्‍पर्श करी त्यानी संध्‍याकाळपावोत अशुध्‍दस राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","त्‍यासमाईन कोणी मरीसनी एखादी वस्‍तुवर पडी तेबी अशुध्‍द समजानं; मंग ते काठना पाञ, वस्‍ञ, तरट, नाहिते कोनतेभी कामना हत्‍यार राहो ते पाणीमा टाकानं अनी संध्‍याकाळपावोत अशुध्‍दस राहावानं; मंग त्‍याले स्‍पर्श करानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","यामाईन एखादा मातीना भांडामा पडं तर‍ त्‍या भांडमा जे काही राही ते अशुध्‍द व्‍हई अनी ते भांड फोडी टाकानं; ");
INSERT INTO ahr_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","जर एकादी वस्‍तु खावाकरता योग्‍य व्‍हई पण त्‍यामा पानी पडेल शे तर ती वस्‍तूले अशुध्‍द समजानं अनी आशे भांडामा काही पेय राहिते तर तेभी अशुध्‍द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","अनी त्‍यासना शवंसना एखादा भाग भट्टीनावर नाहीते चुलावर पडनं तर ते अशुध्‍द समजीसनी मोडी टाकानं; कारण त्यानी ती अशुध्‍द व्‍हतस. अनी तुम्‍ही ती अशुध्‍द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","झरा नाहिते विहिर ज्‍यामा पाणी साठा राहास ते शुध्‍द राहास; तरी त्‍यामासाला शवले ज्‍याना स्‍पर्श व्‍हई ते अशुध्‍द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","त्‍यासना शवसना काही भाग पैरानां बियासवर पडनं तरी त्‍या बियासले शुध्‍द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","त्‍या बियासवर पाणी शितडेल शे त्‍यानावर त्‍या प्राण्‍यासना शेवळासना पडनं तर ते तुम्हले अशुध्‍द शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","खावानं पशुसमाईन एखादा मरना तर त्‍याना शवसले शिवणार्‍यासनी संध्‍याकाळपावोत अशुध्‍दस राहावानं ");
INSERT INTO ahr_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","त्‍याना शवसना काही भाग त्यानी खाद् तर त्यानी आपला कपडा धईसनी संध्‍याकाळपावोत अशुध्‍दस राहावानं; त्‍याना शव उचलनारासनभी आपला कपडा धईसनी संध्‍याकाळपावोत अशुध्‍दस राहावानं; ");
INSERT INTO ahr_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","जमीनवर रांगणारा बठा प्राणी अमंगळ शेतस; ते खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","जमीनवार रांगणारासमाईन ज्‍या पोटवर चालतस नाहिते चार पायसवर चालतस अनी ज्‍यासले बराच पाय शेतस त्‍या काही तुम्‍ही खावानं नही; त्‍या अमंगळ शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","तुम्‍ही कोणत्‍याभी प्रकारना रांगत चालणारा प्राण्‍यासमुळे अमंगळ होवु देवानं नही नाहिते त्‍यासनाव्‍दारा अशुध्‍द व्‍हईसनी विटाळ व्‍हवाले नही पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","मी परमेश्‍वर तुम्‍हना देव शे म्‍हणुन स्‍वत:ले पवित्र करीसनी पविञ राहावानं; कारण मी पविञ शे;‍ म्‍हणुन जमीनवर रांगणारा कोतणतेभी जातीसना विटाळानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","कारण मी तुमना देव व्हावाले पाहिजे म्हणीसनं त्या परमेश्वरनी तुमले मिसर देशमाईन आठे आणं तोच मी शे; मी पवित्र शे; त्याकरता तुमीबी पवित्र व्हावानं. ");
INSERT INTO ahr_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","पशु, पक्षी सर्व पाणीवर अनं जमिनवर रांगणारा बठा जनावर यासनाबारामां ");
INSERT INTO ahr_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","अशुध्द अनी शुध्द, जे खावानं अनी जे खावानं नही यासमासला भेद दखानं हाई नियम शे. ");
INSERT INTO ahr_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","परमेश्‍वरनी मोशेले सांग ");
INSERT INTO ahr_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","इस्राएल लोकेसले सांग: बाई गर्भवती व्‍हईसनी तिले पोर्‍या व्‍हवानंतर तिनी सात दिवस अशुध्‍द ऱ्हावानं; ऋतुकाली जशी दुर बससं तशी तिले अशुध्‍द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","आठवा रोजले त्‍या पोर्‍यानी सुंता करी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","नंतर त्या बाईनी आपला रक्‍तस्रावपाईन शुध्‍द व्‍हावाकरता तेहतीस दिवस पुरा करानं; तिना शुध्‍दीना दिवस पुरा व्‍हस तोपावोत तिनी कोणतेभी पवित्र वस्‍तुले हात लावानं नही अनी पवित्र ठिकानवर जावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","तिले पोर व्‍हईनीते जशी ती ऋतुकाली दुर बसस त्‍यापरमानं तिनी चौदा दिवस अशुध्‍द ऱ्हावानं अनी रक्‍तस्रावपाईन शुध्‍द व्‍हवाकरता सहासष्‍ट दिवस पुरा करानं; ");
INSERT INTO ahr_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","जवय त्‍यासना शुध्‍द व्‍हवानं दिवस पुर वतीन तवय तिले पोर्‍या अनी पोर वतीन तवय होमबळी कराकरता एक वर्षीना मेंढा अनी पापबळीकरता पारवासना पिला नाहीते होला दर्शनमंडपना दारपान याजकसकडे लई जावानं ");
INSERT INTO ahr_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","मंग याजकसनी ते परमेश्‍वरनीमोरे अर्पिसनी तिनाकरता प्रायश्‍चित करानं; म्‍हणजे रक्‍तस्रावमाईन शुध्‍द व्‍हई; जी बाईले पोर्‍या नाहिते पोर व्‍हई तिनीबारामा नियम हाई. ");
INSERT INTO ahr_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","तिले मेंढा अर्पण करानी ऐपत नही व्‍हईते तिनी दोन होला नाहिते पारवासना दोन पिला, एक होमबळी कराकरता अनी दुसरा पापबळी कराकरता आणानं अनी याजकसनी तिनाकरता प्रायश्‍चित करानं म्‍हणजे ती शुध्‍द व्‍हई. ");
INSERT INTO ahr_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","परमेश्‍वरनी मोशे अनी अहरोन यासले सांग; ");
INSERT INTO ahr_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","जवय माणुसनी कातडीले सुज, खवले नाहीते पांढरा डाग व्‍हई अनी कुष्टरोगना चट्टा शे आशे दिसनं तवय त्‍यासले अहरोन याजककडे नाहिते त्‍याना पोर्‍या जे याजक शेतस त्‍यामाईन एकजणकडे लई जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","मंग याजकसनी आंगना चामडीनावरना चट्टा तपासानं अनी त्‍यामासला केस धवळा व्‍हयेल वतीन अनी ते चामडीना मजारमा व्‍हई तवय त्‍याले कुष्टरोगना चट्टा समजानं त्‍या माणससले याजकसकडे तपासणी करीसनी त्‍याले अशुध्‍द करी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","त्‍याना आंगना चामडीवरना डाग धवळा व्हई पण त्‍याना चामडीपेक्षा ते खोल जायेल नही व्‍हई अनी त्‍यानावरना केस धवळा व्‍हयेल नही व्‍हई तर याजकसनी चट्टा पडेल त्‍या माणससले सात दिनपावत अलग ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","सातवा रोज परत एकदाव याजकसनी त्यानी तपासनी करानं अनी चट्टा जशानं तशे व्‍हई अनी चामडीमा पसरेल नही व्हई आशे दखामां व्‍हनं तर याजकसनी त्‍याले आखो कोंडी ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","सातवा रोज याजकसनी परत एकदावं तपासानं अनी चट्टा कमी व्‍हई राहिना अनी चामडीमा ते पसरेल नही शे आशे त्‍याले दखायनं तर याजकसनी त्‍याले शुध्‍द करानं; कारण ते साधा खवले शे; त्यानी त्‍याना कपडा धईसनी शुध्‍द व्‍हई जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","तो शुध्‍द शे आशे त्‍याले ठरावनं म्‍हणीसनी याजकले दखाडानंतर चामडीना तो डाग पसरत व्‍हई तर त्‍या माणुसनी परत एकदाव याजकले दखाडानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","याजकनी तपासनी करानं अनी ते डाग चामडीमा परसरेल शे आशे दखामां व्‍हना त्यानी त्‍याले अशुध्‍द ठरावानं; ते कुष्टरोग शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","जर एखादा माणुसले कुष्टरोग चट्टा व्‍हई त्‍याले याजकसकडे लई जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","याजकसनी तपासनी करानं अनी जर त्‍याना चामडीमा धवळी सुज व्‍हई अनी त्‍यानामुळे त्‍याना केस धवळा व्‍हतीन अनी त्‍यामासला मास मुडदार व्‍हयेल शेतस, ");
INSERT INTO ahr_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","तर त्‍याना चामडीमा ते जुना कुष्टरोग शे. याजकनी त्‍याले अशुध्‍द ठरावानं, त्‍याले त्यानी कोंडी ठेवानं, तो अशुध्‍दस शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","एखादाना चामडीमा कुष्टरोग फुटिसनी तो नखशिखात बठा आंगभर पसरेल शे आशे याजकले दिसनं, ");
INSERT INTO ahr_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","तर‍ त्यानी तपासनी करानं अनी त्‍याले बठा आंगले कुष्टरोग व्‍हयेल शे त्यानी चट्टा पडेल माणुसले शुध्‍द ठरावान; त्‍याना सर्वा आंग शुभ्र व्‍हयनं म्‍हणुन तो शुध्‍द शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","त्‍याना आंगवर काही मास मुडदार दखायनं तर त्‍याले अशुध्‍द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","याजकनी मुडदार मास दखीसनी त्‍याले अशुध्‍द ठरावानं; कारण आशे मास अशुध्‍दस ऱ्हास: तो कुष्टरोग शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ते मुडदार मास पलटीसनी धवळ व्‍हयनं तर त्यानी परत याजकसडे येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","याजकनी त्‍याले तपासानं अनी जर त्‍याना चट्टा पलटीसनी धवळा व्‍हयेल शे तर त्यानी त्‍या चट्टा पडेल माणसासले शुध्‍द ठरावानं; कारण तो शुध्‍द शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","एखादानी चामडीले फोड येईसनी तो बरा व्‍हयना. ");
INSERT INTO ahr_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","अनी फोडनी जागावर धवळी सुज व्‍हयनी नाहिते लालसर धवळा डाग पडनं तर त्यानी ते याजकले दखाडानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","याजकसनी तपासनी करानं अनी जर ते चामडीपेक्षा ती जागा खोल जायेल दखामा व्‍हनी अनी त्‍यानावरना केस धवळा व्‍हयेल शेतस तर त्‍याले अशुध्‍द् ठरावानं; हाई फोडमाईन बाहेर फुटेल महारोगना चट्टा शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","त्‍यानावरना केस धवळा नही शेतस अनी ती जागा चामडीपेक्षा खोल जायेल नही व्‍हयी अनी ते बुजी राहीनं शे आशे तपासतांना दखायनं तर त्यानी त्‍या माणुसले सात दिवस कोंडी ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","तेवढा मुदतमा ते चामडीवर पसरेल शे आशे दखायनं तर याजकसनी त्‍या माणुसले अशुध्‍द ठरावनं अनी ते कुष्टरोगना चट्टा समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","तो धवळा डाग जेवढानं तेवढं ऱ्हाईसन ते पसरेल नही व्‍हई तर ते फोडनं ओळखनं शे आशे समजीसनी याजकसनी त्‍याले शुध्‍द ठरावानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","एखादाना चामडीवर जळानं ओळखन व्‍हई अनी ती ओळखनले मुडदार मासमा लालसर पांढरा नाहिते नुसता पांढरा डाग येयेल व्‍हई. ");
INSERT INTO ahr_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","अनी याजकले तपासनी व्‍हतांना आशे दखायनं की त्‍या पांढरा ठिकानवर केस येयल शेतस अनी चामडीपेक्षा ती जागा खोल जायेल शे, त्‍या जागावर कुष्टरोग फुटेल शे आशे समजानं; याजकनी त्‍याले अशुध्‍द ठरावानं, कारण ते कुष्टरोगना चट्‍टा शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","तरीभी याजकसले आशे दखायनं त्‍या धवळा जागमा धवळा केस नही शेतस अनी चामडीमा खोल जायेल नही शेतस, बुजी जायं राहीना शेतस, तर त्यानी त्‍याले सात रोज कोंडी ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","सातवा रोजले त्यानी त्‍याले तपाशी दखानं; चामडीना तो डाग पसरेल शे आशे दखायनं त्यानी त्‍याले अशुध्‍द ठरावानं. ते कुष्टरोगना चट्टा शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","पण पांढरा डाग जेवढाना तेवढा शे, चामडीवर पसरेल नही शे अनी ते बुजी राहिना शे तर ती जळेल ठिकानले सुज समजानं अनी याजकसनी त्‍याले शुध्‍द ठरावानं. कारण ते नुसते जळेल जागवार ओळखन शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","एखादा माणुसनी नाहिते बाईना डोकावर नाहिते दाढीवर चट्टा व्‍हईते, ");
INSERT INTO ahr_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","अनी याजकनी त्यानी तपासनी करानं अनी ती जागा चामडीपेक्षा खोल दखायनी अनी तिनावर काही बारीक केस व्‍हतीन तर त्यानी त्‍या माणुसले अशुध्‍द ठरावानं; हाई चाई डोकानी नाहिते दाढीना कुष्टरोग शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","याजकसनी हाई चाईना चट्‍टा तपाशी दखानं अनी ते चामडीनापेक्षा खोल नही व्‍हई अनी त्‍यानावर काळा केस नही व्‍हई तर चाईना चट्टा राहेल त्‍या माणुसले सात रोज कोंडी ठेवानं ");
INSERT INTO ahr_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","सातवा रोजले त्यानी परत चट्टासनी तपासनी करानं; ती चाई पसरेल नही, त्‍यावार काही राखाडी केस नही शेतस अनी चाईना जागा चामडीपेक्षा खोलगट नही व्‍हयी आशे त्‍याले दखायनं. ");
INSERT INTO ahr_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","तर त्‍या माणुसनं मुंडन करी टाकानं, पण चाईवरना केस काढानं नही; याजकनी चाई लागेल माणुसले आजुन सात रोज कोंडी ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","सातवा रोजले याजकनी ती चाई परत तपाशी दखानं अनी त्‍यासले आशे दखामां व्‍हनं की चाई चामडीवर पसरेल नही शे अनी ती चामडीपेक्षा ती खोल नही जायेल शे तर त्यानी त्‍याले शुध्‍द ठरावानं. त्‍या माणुसनी आपला कपडा धवानं अनी शुध्‍द व्‍हयी जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","तरिभी ते शुध्‍द व्‍हावानंतर ती चाई पसरत गईते ");
INSERT INTO ahr_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","याजकाने त्‍याले तपासानं अनी ती चाई चामडीवर पसरेल शे आशे दखामां व्‍हनं व्‍हयीते राखडी केस दखत बसानं नही तर त्‍या माणुसले अशुध्‍द ठरावानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ती चाई जेवढीना तेवढी शे अनी तिनावर काळा केस येल शेतस आशे जर दखायनं तर ती चाई बरी व्‍हयेल शे अनी ती शुध्‍द शे; याजकनी त्‍याले शुध्द ठरावानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","एखादा माणुसना नाहिते बाईना आंगवर पांढरा चकचकीत डाग व्‍हतीन ते, ");
INSERT INTO ahr_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","याजकनी ते तपासानं अनी त्‍याना आंगना चामडीनं त्‍या दाग भुरा व्‍हतीनते तर ती चामडीले फुटेल दाद समजानं; तो मनुष्‍य शुध्‍द शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","एकादा माणुसना डोकाना केस गळीसनी त्‍याना टक्‍कल पडेल व्‍हयी तर तो शुध्‍द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","त्‍याना कपाळना पुढला भागना केस गळीसनी त्‍याना टक्‍कल पडनं व्‍हयी तर‍ त्‍याले शुध्‍द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","त्‍या टक्‍कल पडेल डोकावरना नाहिते कपाळनावरना बाजुले काहिसा लालसर पांढरा चट्टा पडनं तर आशे समजानं की ते टक्‍कल पडेल डोकावर नाहिते कपाळवर कुष्टरोग फुटीसनी निघि राईना शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","तवय याजकनी त्‍याले तपाशी दखानं अनी त्‍याना डोकानं टक्‍कलमा नाहिते कपाळना वरना भागमा आंगना चामडीनावर कुष्टरोगना मायक तांबूस पांढरा चट्टा शे आशे त्‍याले दखायनं. ");
INSERT INTO ahr_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","तर तो माणूस कुष्टरोग शे अनी तो अशुध्‍द भी शे, याजकनी त्‍याले अशुध्‍द ठरावानं; त्‍याना डोकाले व्‍हयेल तो कुष्टरोगना चट्टा शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","ज्‍या कुष्टरोगना आंगवर हाई चट्‍टा व्‍हई त्‍याना कपडा फाडेल राहावाले पाहिजे, त्‍याना डोकानं केस सोडेल ऱ्हावाले पाहिजे, त्यानी आपला वरला ओठ झाकीसनी ठेवानं अनी अशुध्‍द आशे ओरडत ऱ्हावानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","जेवढा दिवस हाई चट्टा त्‍याना आंगवर ऱ्हाई तेवढा दिवस त्यानी अशुध्‍द ऱ्हावानं. तो अशुध्‍द शे, त्यानी एकला ऱ्हावानं अनी छावणीबाहेर त्यानी वस्‍ती ऱ्हावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","एखादा कपडाले, मंग तो कपडा लोकरना ऱ्हावो नाहिते सणसना ऱ्हावो, कुष्टरोगना चट्टा पडनं. ");
INSERT INTO ahr_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","तो सणसना नाहिते लोकरना ताण्‍याले नाहिते बाण्‍याले, चामडाले नाहिते चामडानी बनाडेल वस्‍तुले पडना. ");
INSERT INTO ahr_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","अनी त्‍या कपडाले, चामडाले, ताण्‍याले नाहिते बाण्‍याले अनी चामडाना वस्‍तुमा पडेल तो चट्टा हिरवट नाहिते तांबुस व्‍हयना तर ते कुष्टरोगना चट्टा समजानं, अनी याजकले दखाडानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","याजकनी ते तपासानं; चट्‍टा पडेल वस्‍तुले सात रोज त्यानी अलग करी ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","त्यानी सातवा रोज तो चट्टा तपासनं अनी कपडासना ताणावर नाहिते बाणावर, चामडासवर नाहिते चामडासनी कोनतेभी वस्‍तुवर तो चट्‍टा पसरेल शे. आशे दखायनं तर ते चढत जाणारा कुष्‍ठ समजानं, ती वस्‍तु अशुध्‍द शे. ");
INSERT INTO ahr_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","त्‍या कपडा लोकरीना ऱ्हावो की सणासना ऱ्हावो, त्‍यासना बाणामा, चामडामा अनी चामडानी एखादी वस्‍तुले चट्टा व्‍हयी तर चढत जाणारा कुष्‍ठ ऱ्हावामुळे ती वस्‍तुले आगघाई जाळी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","तपासणी व्‍हावानंतर जर याजकले दखामां व्‍हनं की कपडासना ताणामा नाहिते बाणामां नाहिते चामडाना व्‍हयेल एखादी वस्‍तुमां तो चट्टा पसरत नही. ");
INSERT INTO ahr_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","तर चट्टा व्‍हयेल वस्‍तुले धई टाकानी आज्ञा याजकनी करानं अनी अजुत सात रोज ती अलग करी ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ती वस्‍तु धवानंतर तिले याजकनी दखानं अनी त्‍या चट्‍टान रंग बदलेल नही व्‍हयी अनी ते पसरेल नही व्‍हयी तरी त्‍याले अशुध्‍द समजानं; ती वस्‍तुले आगमा जाळानं; तो चट्टा मजारमां ऱ्हावो नाहिते बाहेरना बाजुमां ऱ्हावो, त्‍याले चढत जाणारा चट्टा समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","धवामुळे त्‍या डागना चकचकीतपणा कमी व्‍हयेल शे आशे जर याजकले दखायनं तर त्यानी कपडासना ताणाना नाहिते बाणासाना नाहिते चामडासना वस्‍तुसना तेवढाच भाग फाडी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","एवढं करिसनीबी जर कपडासना ताणामां नाहिते बाणामां नाहिते चामडानी वस्‍तुमा तो चट्टा परत फुटीसनी व्‍हनं तर ती चट्टा फुटेल वस्‍तुले आगमा जाळी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","कपाडासना ताणा नाहिते बाणा नाहिते चामडानी कोनतीबी वस्‍तुले धवानंतर त्‍याना ते डागना नायनाट व्‍हयनं तर ती वस्‍तुले परत एकदाव धवानी म्‍हणजे ती शुध्‍द व्‍हयी. ");
INSERT INTO ahr_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","लोकरनं नाहिते सणासना कपडासना ताणामा नाहिते बाणामा नाहिते चामडामा एखादा वस्‍तुले कुष्टरोगना डाग दखामां व्‍हनं तर शुध्‍द नाहिते अशुध्‍द ठरावानं हाई नियम शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","परमेश्‍वरनी मोशेले सांग. ");
INSERT INTO ahr_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","कुष्टरोगले शुध्‍द ठरावानं नियम हाई शेतस; त्‍याले याजककडे लयी येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","याजकसनी छावणीनाबाहेर जाईसनी त्‍या कुष्टरोगले तपासी दखानं अनी त्‍याना आंगना कुष्टरोगना चट्टा बरा व्‍हयेल शेतस आशे त्‍याले दखामां व्‍हनंते ");
INSERT INTO ahr_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","त्यानी आज्ञा करानी की ज्‍याले शुध्‍द करानं शे त्‍यानाकरता दोन जीवंत शुध्‍द चिडा, गंधसरुना लाकडं, किरमिजी रंगना कपडा अनी एजोब हाई बठा लयी येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","मंग याजकनी आज्ञा करानी की वाहाता पाणीमां माटीना भांडामा त्‍यामासला एक पक्षी मारानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","अनी बाकीना जीवता चिडा, गंधसरुना लाकडं, किरमिजी रंगनं कापड अनी एजोब हाई बठा लयीसनी वाहता पाणीमां मारेल चिडासना रंगतमा त्‍यासनी बुडावानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","अनी ते महारोगापाशीन शुध्‍द ठरावानं माणुसवर सातदाव शितडानं; अनी ते शुध्‍द व्‍हयेल शे आशे सांगीसनी ते जीवता चिडाले जंगलमा सोडी दयावानं; ");
INSERT INTO ahr_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","अनी शुध्‍द होणारा माणुसनी आपला कपडा धवानं, आपला सर्वा केस मुंडन करानं अनी पाणीघाई आंग धवानं; मंग तो शुध्‍द व्‍हयी; त्‍यानंतर त्यानी छावणीमां येवानं; त्यानी सातरोज तंबूनी बाहरे राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","सातवारोज त्यानी आपला डोका,दाढी, भुवया हाई म्‍हणजे आंगवरला जवळपास बठा केसना मुंडन करानं, आपला कपडा धवानं अनी पाणीघाई आंग धवानं म्‍हणजे तो शुध्‍द व्‍हयी. ");
INSERT INTO ahr_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","आठवा रोजले दोन निर्दोष कोकरु, एक वर्षनी निर्दोष मेंढी, अन्‍नर्पणाकरता तेलमा मळेल तीन दशांश एफा मयदा अनी लोगभर तेल हाई सर्वा आणानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","अनी शुध्दी करणारा याजकनी शुध्‍द करानं माणुसले हाई बठा वस्तूनीसंगे परमेश्‍वरनीमोरे दर्शनमंडपना दारपान उभं करानं ");
INSERT INTO ahr_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","मंग याजकनी दोषार्पणकराकरता एक कोकरु अनी लोगभर तेल आशी अर्पानी ती परमेश्‍वरनीमोरे ओवाळनीनं अर्पण म्हणीसनी अर्पानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","अनी पवित्रस्थानमा जठे पापबळी अनी होमबळी मारतसं तठे ते कोकरु मारानं; कारण पापबळीपरमानं दोषबळीलेभी याजकनं हक्क शे. हाई अर्पण परमपवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","मंग याजकनी दोषबळीन काही रंगत लयीसनी शुध्दकराकरता माणूसनी उजवा काननं शेंडाले, ऊजवा हातना अंगठाले अनी उजवा पायनं अंगठाले लावानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","याजकनी लोगभर तेलमासले थोडं तेल आपला डावा हातना तळवर वतानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","त्यानी आपला उजवा हातनं बोट आपला डावा हातना तेलमा बूडाईसनी त्यामासला काही परमेश्वरनीमोरे सातदाव बोटघाई शितडानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","त्‍याना तळहातवर जे तेल उरेल राही त्‍यामासला काही लयीसनी याजकनी शुध्द ठरावानं माणुसनी उजवा काननी शेंडाले अनी उजवा हातनं अनी उजवा पायना अंगठयासले दोषबळीनं रंगत लावानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","तळहातवर शिल्लक राहेल तेल त्यानी शुध्द ठरावानी माणुसनी डोकाले लावानं अनी त्यानाकरता त्यानी परमेश्वरनीमोरे प्रायश्चित करानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","मंग याजकनी पापबळी अर्पानं अनी अशुध्‍दतेपाईन शुध्द ठरावानं त्या माणुसनीकरता प्रायश्चित करानं; मग‍ त्यानी होमबळी करानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","मंग याजकनी होमबळी अनी अन्नबळी वेदीवर अर्पण करानं अनी त्याकरता प्रायश्चित करानं, म्हणजे तो शुध्द व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","तो गरीब व्हयी एवढं आणानं त्यानी ऐपत नही व्हयी तर त्या प्रायश्चित कराकरता वोवाळणीनं एक कोकरु दोषार्पण म्हणीसनी आणानं, अनी अन्नर्पणकराकरता तेलमा मळेल एक दशांश एफा सपीठ अनी लोगभर तेल आणानं; ");
INSERT INTO ahr_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","अनी त्याले मिळतीन तसे दोन होले नाहीते पारवासना दोन पिला आणानं; त्यामासला एक पापबळी अनी दुसरा होमबळी राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","आठवा रोजले आपला शुध्दीकरणकराकरता त्यानी हाई बठा दर्शनमंडपना दारपान याजकडे परमेश्वरनीमोरे जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","मंग याजकनी दोषर्पणनं कोकरु अनी लोगभर तेल लयीसनी वोवाळनीनं अर्पण म्हणीसनी परमेश्वरनीमोरे वोवाळानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","मंग दोषर्पण कोकरु मारानं अनी याजकनी त्‍यासना थोडा रंगत लयीसनी शुध्द ठरावानं माणुसनी उजवा कानना शेंडाले अनी उजवा हातना अनी उजवा पायनं अंगठाले लावानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","याजकनी त्या तेलमासला काही डावा हातना तळवर वतानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","अनी आपला उजवा हातनं बोट आपला हातनं तळवरनं तेलमा बुडाईसनी त्यामासले परमेश्वरनीमोरे सातदाव शितडानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","मंग याजकनी आपला तळहातवरला काही तेल लयीसनी ज्याले शुध्द ठरावानं त्या माणुसनी उजवा काननं शेंडाले अनी उजवा हातनं अनी उजवा पायनं अंगठाले दोषबळीना रंगतवर लावानं; ");
INSERT INTO ahr_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","याजकना तळहातवर जे उरेल तेल ते शुध्द ठरावानं, माणुसनं डोकाले परमेश्वरनीमोरे त्यानाकरता प्रायश्चित म्‍हणीसनी वतानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","मंग त्याले भेटेल व्हतीन त्या होला नाहिते पारवासना पिला यासमाईन एकनं त्यानी अर्पण करनं. ");
INSERT INTO ahr_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","त्‍याले जे पक्षी मिळेल व्हतीन त्यानामाईन एकनं पापार्पण करानं अनी दुसरा अन्नार्पणसंगे होमर्पण करानं; हाई परकारं याजकनी शुध्द ठरावानं माणुसकरता परमेश्वरनीमोरे प्रायश्चित करानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","आंगवर कुष्टरोगना चटा व्हयेल जो माणुसले शुध्दीकरणनी सामग्री मिळाडानं ताकद नही व्हयी त्या बारामा त्याना नियम हया शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","परमेश्वरनी अहरोन अनी मोशेले सांग; ");
INSERT INTO ahr_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","जो कनान देश तुम्हले वतन म्‍हणीसनी दी राहिनू तठे तूम्ही जवय जाशाल तवय तुम्ही तुम्हनी वतनना देशमासला एकादा घरले कुष्टरोगना चट्टा उमटाडं. ");
INSERT INTO ahr_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","तर ज्यानं ते घर व्हयी त्यानी याजकले जाईसनी सांगानं की मना घरले कुष्टरोगना चट्टानीगत दखासं. ");
INSERT INTO ahr_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","मंग याजकनी आज्ञा करानी की जाईसनी घर दखसू त्याना आगोदर ते रिकामं करानं; नाहिते एकादा येळले घरमासला बठया वस्तू अशुध्द ठरावानं. मंग याजकनी मजारमा जाईसनी घर तपासानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","तो चट्टा त्यानी दखानं अनी घरना भितवर हिरवट अनी लालसर रंगन रेघा पडेल व्हतीन अनी भितमा जायेल वतीन ते. ");
INSERT INTO ahr_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","याजकनी घरमाईन दारनीबाहेर जावानं अनी सातरोज ते घर बंद करी ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","सातवा रोज याजकनी ते घर परत जाईसनी दखानं अनी जर तो चट्टा घरना भितवर पसरेल व्हयी आशे दखायनं तर ");
INSERT INTO ahr_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","याजकनी आशी आज्ञा करानी की डाग राहेल दगडा काढीसनी गावनीबाहेर अशुध्द जागवर फेकी देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","अनी घरना मजारमाईन चारीबाजुले खरवडानं अनी खरवडीसनी काढेल माती त्यानी गावनीबाहेर अशुध्द जागवर टाकी देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","मंग ते दगडना जागवर दुसरा दगड बसाडानं अनी ते घरले नवीन मातीना गारा करानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","दगड काढानंतर अनी घर खरवडीसनी नवीन गिलावा करानंतर जर परत तो चट्टा दखावाले लागना. ");
INSERT INTO ahr_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","याजकनी लयीसनी तो दखानं अनी घरमा पसरेल शे आशे त्याले दखायनं तर तो घरमा पसरत जाणारा कुष्ट शे आशे त्यानी ठरावानं; ते अशुध्द शे. ");
INSERT INTO ahr_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","मंग‍ त्यानी ते खंदी टाकानं त्यानं दगड,लाकूड अनी बठा माती त्यानी तठेईन काढीसनी गावनीबाहेर अशुध्द जागवर फेकी देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","घर बंद व्हयी जर कोणी तठे जाईसनी राहिना तर तो संध्याकाळपावोत अशुध्दच राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","अनी कोणी ते घरमा झोपेल व्हयी तर‍ त्यानी आपला कपडा धवानं; अनी घरमा कोणी अन्न खायेल व्हयी तर‍ त्यानीभी आपला कपडा धवानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","याजकनी मजारमा जाईसनी दखानंतर त्याले जर दखामां व्हनं की घरले गिलावा करानंतर काही चट्टा नही व्हन व्हयी, तर त्याना तो चट्टा दुर व्हानंतर त्यानी ते शुध्द ठरावानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","त्या घरनं शुध्दीकरनकराकरता दोन चिडा, गंधसरुनं लाकूड, किरमिजी रंगनं कपडा अनी एजोब हाई त्यानी लयानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","त्यानी एक चिडा वाहाता पाणीमां मातीना भांडामा मारानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","मंग त्यानी गंधसरुनं लाकूड, एजोब, किरमिजी रंगनं कापड अनी जीवत चिडा हाई लयीसनी त्या मारेल चिडासना रंगतमा अनी वाहाता पाणीमा बूडाईसनी ते घरवर सातदाव शितडानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ते चिडानं रंगत, वाहता पाणी, तो जीवत चिडा, गंधसरुनं लाकूड, एजोब, किरमिजी रंगनं कापड यानकडतीन ते शुध्द करानं. ");
INSERT INTO ahr_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","मंग त्यानी जीवत चिडा गावनीबाहेर सोडी देवानं, हाई परकारं त्यानी घरनं प्रायश्चित करं म्हणजे ते शुध्द व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","बठा परकारनं कुष्टरोग चट्टा, चाई, ");
INSERT INTO ahr_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","कपडासवरला नाहिते घरवरला कुष्टरोग, ");
INSERT INTO ahr_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","सूज, खवले, पांढरा डाग हाई बठा बारामा हाई नियम शे; ");
INSERT INTO ahr_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","हाई शुध्द कवय अनी अशुध्द कवय हाई ठरावानाबारामां हाई नियम शे; हाई कुष्टरोगना इषयीना शे. ");
INSERT INTO ahr_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","परमेश्वरनी मोशे अनी अहरोनले सांग, ");
INSERT INTO ahr_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","इस्राएल लोकेसले सांग, एकादा माणुसनी आंगमाईन स्राव व्हयी ते अशुध्द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","हाई स्राव चालू राहो की बंद राहो, ते अशुध्दस शे. ");
INSERT INTO ahr_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","स्राव व्हनारा माणुस ज्या अंथरुनवर झोपी त्याले अशुध्द समजानं अनी ज्या वस्तुवर तो बसी तिभी वस्तु अशुध्द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","अनी जो कोणी अंथरुनले हात लाई त्यानी आपला कपडा धवानं, पाणीघाई आंग धवानं अनी संध्याकाळपावोत अशुध्दस राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","स्राव व्हयले माणुस जी वस्तुवर बठसं व्हयी अनी तिनावर कोणी बठं तर‍ त्यानी आपला कपडा धवानं, पाणीघाई आंघोळ करानं अनी संध्याकाळपावोत अशुध्दस राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","स्राव व्हयेल माणुसनी आंगले कोणी हात लावं तर‍ त्यानी आपला कपडा धवानं, पाणीघाई स्नान करावे अनी संध्याकाळपावोत अशुध्दस राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","स्राव व्हयेल माणुसनी एकादा शुध्द माणुसवर थुंक तर‍ त्यानी माणुसनी आपला कपडा धई टाकानं अनी संध्याकाळपावोत अशुध्दस राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","स्राव व्हयेल माणुस जे वाहानंन वापर करी ते अशुध्द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","त्याना आंगना खालना एकादी वस्तुले कोणी हात लाई दिद् तर त्यानी संध्याकाळपावोत अशुध्दस राहावानं. अनी जो कोणी ती वस्तुले उचली त्यानी आपला कपडा धवानं, पाणीघाई अंघोळ करानं अनी संध्याकाळपावोत अशुध्दस राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","स्राव व्हयेल माणुसनी हात धवाशिवाय एकादा माणुसले हात लाई दिद् तर त्यानी आपला स्नान करानं पाणीघाई आंग धवानं अनी संध्याकाळपावोत अशुध्दस राहावानं ");
INSERT INTO ahr_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","स्राव व्हयेल माणुसनी एकादा मातीना भांडाले हात लाई दिद् तर ते भांड फोडी टाकानं, त्यानी हात लावं ते भांड लाकूडनं व्हयीते पाणीघाई धवानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","स्राव व्हयेल माणुस आपला‍ स्रावपाईन बरा व्हयीना तर त्यानी आपला शुध्दीकरणकराकरता त्यानी सात दिवस मोजानं अनी आपला कपडा धईसनी वाहता पाणीमा स्नान करानं, म्हणजे तो शुध्द व्हयी ");
INSERT INTO ahr_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","आठवा रोजले त्यानी दोन होला नाहिते पारवासना दोन पिला लयीसनी दर्शनमंडपना दारपान परमेश्वरनीमोरे जाईसनी याजकडे ते देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","मंग याजकनी त्यामासला एकनं पापार्पण अनी दुसरानं होमर्पण करानं अनी त्याना स्राववास्तव परमेश्वरनीमोरे त्यानाकरता प्रायश्चित करानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","एकाद माणुसनं वीर्यपतन व्हयनं व्हयी तर‍ त्यानी आपला बठा आंग पाणीघाई धईसनी संध्याकाळपावोत अशुध्द राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ज्या कपडावर नाहिते चामडावर वीर्यपतन व्हयनं व्हयी तेभी पाणीघाई धईसनी संध्याकाळपावोत अशुध्द राहावानं ");
INSERT INTO ahr_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","माणुसनी बाईनीसंगे संभोग कर व्हयी त्या दोन्हीसनी पाणीघाई आंग धईसनी संध्याकाळपावोत अशुध्द राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","जर एकादी बाईले पाळी वनी तर तीनी सात रोज अशुध्द राहावानं; जर कोणी तिले हात लावं व्हयी त्यानी संध्याकाळपावोत अशुध्द राहावानं ");
INSERT INTO ahr_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ती अशुध्द राहास तोपावोत ज्या वस्तुवर ती झोपी नाहिते बठी त्या बठया वस्तु अशुध्द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","जर कोणी तिना अंथरुनले हात लाई दिद् त्यानी आपला कपडा धवानं, पाणीघाई स्नान करानं अनी संध्याकाळपावोत अशुध्दस राहावानं ");
INSERT INTO ahr_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ती बसले कोनतेभी वस्तुले कोणी हात लाई दिद् तर त्यानी आपला कपडा धवानं, पाणीघाई स्नान करानं अनी संध्याकाळपावोत अशुध्द राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","तिना अंथरुनले नाहिते जी वस्तुवर ती बसेल व्हयी तिले हात लावणार्‍यानी संध्याकाळपावोत अशुध्द राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","एकादा माणुसनी तिनेसंगे संभोग करं अनी तिन विटाळ त्याले लागनं तर त्यानी सातरोज अशुध्द राहावानं अनी ज्या अंथरुनवर तो झोपी त्याले अशुध्द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","एकादी बाईले तिना मासिक दिवसनापेक्षा जास्त दिवस स्राव होत व्हयी नाहिते ते मासिक पाळीना येळपेक्षा जास्त व्हत व्हयीते तिने बठा दिवस अशुध्द राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","तिले मासिक पाळी येत व्हयी तर त्या बठा दिवस ती ज्या अंथरुनवर झोपी तर ते विटाळना अंथरुण समजानं; अनी ती जी वस्तुवर बठी तर ती मासिक पाळीना विटाळपरमानं अशुध्द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","जर कोणी त्या वस्तुसले हात लाई ते अशुध्द समजानं अनी त्यानी आपला कपडा धवानं,पाणीघाई आंग धवानं अनी संध्याकाळपावोत अशुध्द राहावानं ");
INSERT INTO ahr_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","त्या बाईनी आपला मासिक पाळी शुध्द व्हवानंतर आजुन सात रोज मोजान; त्यानंतर तिले शुध्द समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","आठवा रोजले तिनी दोन होला नाहिते पारवासना दोन पिला लयीसनी दर्शनमंडपना दारपान याजककडे जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","मंग याजकनी एकनं पापार्पण अनी दुसरानं होमार्पण करानं अनी तिना विटाळना अशुध्दतामुळे तिनाकरता याजकनामोरे पाप छाकाणं करानं. ");
INSERT INTO ahr_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","हाई परकारं तुम्ही इस्राएल लोकेसले त्यासना अशुध्दतापाईन दारु ठेवानं म्हणजे त्याना जोडे राहेल मना निवासस्थान त्या भ्रष्ट करनार नही. ");
INSERT INTO ahr_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","स्राव व्हयीसनी नाहिते वीर्यपतन व्हयीसनी जो माणुस अशुध्द व्हसं ");
INSERT INTO ahr_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","जी बाई‍ले मासिक पाळी व्हस अनी जो माणुसले नाहिते बाईले स्राव‍ व्हस, जो माणुस अशुध्द बाईनीसंगे संभोग करस, त्यानाबारामा ह्या नियम शेतस; ");
INSERT INTO ahr_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","अहरोना दोन पोर्‍या परमेश्वरनाजोडे जावामुळे मरनात परमेश्वरनी मोशेले सांग बोलना; ");
INSERT INTO ahr_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","परमेश्वरनी मोशेले सांग; तुना भाऊ अहरोन याले सांग, कोशवर शे ते दयासनामोरे अंतरपटना मजारना पवित्र स्थानमा तु कवयभी जावानं नही, गया ते मरशी, कारण दयासना मेघवर मी दर्शन देस राहासु. ");
INSERT INTO ahr_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","जवय अहरोन पवित्रस्थानमां प्रवेश करी तवय त्यानी पापार्पण कराकरता एक बैल अनी होमार्पण कराकरता एक मेंढा लयी येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","त्यानी सणना कपडाना पवित्र अंगरखा घालानं, सणना कडाना चोळणीघाई आपला आंग झाकानं सणना कमरबंदघाई आपली कंबर बांधानी अनी सणना फेटा बांधानं, हाई बठा पवित्र कपडा शेतस; त्यानी पाणीघाई स्नान करीसन हाई कपडा घालीसनी येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","मंग त्यानी इस्राएलना मंडळीकडतीन पापार्पण कराकरता दोन बोकडया अनी होमार्पणना एक मेंढा लयी येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","अहरोननी त्यानाकरता आणेल पापार्पणना बैल अर्पण करिसनी सोताकरता अनी स्वताना घराणाकरता प्रायश्चित करानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","मंग त्यानी त्या दोन बोकडया लईसनी दर्शनमंडपना दारपान परमेश्वरनीमोरे ठेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","अहरोननी त्या दोन बोकडयासवर चिठया टाकानं, एक चिठी परमेश्वरकरता अनी दुसरी पाप वाही लयी जावाकरता. ");
INSERT INTO ahr_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ज्या बोकडयासवर परमेश्वरनी नावनी चिठी निघी ते अहरोननी पापार्पण म्हणीसनी बळी देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ज्या बोकडयासवर पाप वाही लयी जावानं बारामां चिठी निघी त्याले परमेश्वरनीमोरे जीवता उभा करानं अनी त्यानाकडतीन प्रायश्चित व्हावाले पाहिजे; अनी तो बोकडया पाप वाही लेवाकरता जंगलमां सोडी देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","मंग सोताकरता पापर्पण कराना वासरु अहरोननाजोडे आणानं अनी ते मारीसनी आपलाकरता अनी आपला घरानाकरता प्रायश्चित करानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","अनी परमेश्वरनीमोरे राहेल वेदीनावरतीन जळेल निखारासना भरेल धुपाटनं लेवानं अनी कुटेल बारीक ओंजळभर सुंगधी धूप आंतरपटना मजारमा लयानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ते धुप परमेश्वरनीमोरे आगवर आशे घालानं की त्याना धुरघाई साक्षपटलनावरना दयासनले भरि टाकानं, म्हणजे ते मराऊ नही. ");
INSERT INTO ahr_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","मंग त्यानी बैलन काही रंगत दयासननं पूर्व भागले बोटघाई शितडानं; अनी ते रंगत बोटघाई त्या दयासननामोरे सातदाव शितडानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","मंग त्यानी लोकेसनीकरता आणेल पापार्पणना बोकडया मारानं; त्याना रंगत अंतरपटना मजार लयी जावानं अनी जशे त्यानी वासरुना रंगतना करानं तशे बोकडयानं रंगतनं करानं, म्हणजे ते दयासननावर अनी दयासननामोरे शितडानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","आजून त्यानी इस्राएल लोकेसनी अशुध्दता अनी अपराध यानाकरता म्हणजे त्याना बठा पापसकरता पवित्रस्थानकरता प्रायश्चित करानं; माणसासनी अशुध्दताघाई व्याप्त व्हईसनी त्यासनामा राहणारा दर्शनमंडपनाकरता तशे करानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","अहरोन प्रायश्चित कराकरता पवित्रस्थानमां प्रवेस करी तवयपाईन तो आपलाकरता, आपला घराणाकरता अनी इस्राएलनी बठी मंडळीकरता प्रायश्चित करीसनी बाहेर येईपावोत त्या दर्शनमंडपमा दुसरा कोणी भी माणुस नही राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","मंग तो तथाईन निघीसनी परमेश्वरनीमोरे वेदीनाजोडे जाईसनी तिनाकरता प्रायश्चित करानं; बैल अनी बोकडयानं काही रंगत लयीसनी ते वेदीनं चारी बाजुना शिंगासले लावानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","अनी काही रंगत लयीसनी आपला बोटघाई सातदाव तिनावर शितडीसनी ती इस्राएलना अशुध्दतापाईन मुक्त करीसनी पवित्र करानी. ");
INSERT INTO ahr_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","मंग पवित्रस्थान, दर्शनमंडप अनी वेदी यानाकरता प्रायश्चित करानं सरानंतर तो जीवता बोकडया जोडे आणानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","अहरोनी आपल दोन्‍ही हात ते जीवत बोकडयानं डोकावर ठेईसनी इस्राएल लोकेसनी बठा दुष्कर्म अनी अपराध यासना म्हणजे बठा पापना अंगीकार करानं; अनी ती बठी तो बोकडयानं डोकावर ठेईसनी त्याले नेमेल माणुसनी हातघाई जंगलमा धाडी देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","तो बोकड त्याना बठा दुष्कर्मना भार त्यानावर लिईसनी त्या बोकडयाले जंगलमा सोडी देवानं; त्या मानुसनी त्या बकराले जंगलमा सोडी देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","मंग अहरोन दर्शनमंडपमा येईसनी पवित्रस्थानमा जावानी आगोदर परिधान करेल सणसना कपडा काढीसनी ठेई देवानं ");
INSERT INTO ahr_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","मंग त्यानी एकादा पवित्र ठिकाणले पाणीघाई स्नान करानं अनी आपला कपडा घालीसनी बाहेर जाईसनी सोताकरता अनी लोकासना होमर्पण करीसनी सोताकरता अनी लोकसकरता पापछाकी. ");
INSERT INTO ahr_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","पापार्पणना चरबीना त्यानी वेदीवर होम करानं ");
INSERT INTO ahr_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","पाप वाही लयी जावानीबारामा बोकडं ज्या माणुसनी सोडेल शे त्यानी आपला कपडा धवानं, पाणीघाई आंग धवानं अनी मंग छावणीमा येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","पापार्पणना ज्या बैल अनी पापार्पणना‍ ज्या बोकडयासना पवित्र ठिकाणले प्रायश्चित कराकरता लयी जावामा येई, त्या दोन्ही तळनाबाहेल लयी जावानं अनी त्याना कातडा, मास अनी शेन हाई आगमा जाळी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ते जाळणारानी आपला कपडा धवानं, पाणीघाई स्नान करानं अनी मंग छावणीमा येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","तुम्हले कायमनं आशे नियम राहावाले पाहिजे; सातवा महिनानी दशमीले तुम्ही आपलं जीवले त्रास देवानं; त्यारोजले काम करानं नही, मंग ते स्वदेशना राहो की तुम्हना राहणारा परदेशी राहो. ");
INSERT INTO ahr_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","कारण त्यारोज तुम्ही शुध्द व्हावानं म्हणीसनी तुमनाकरता प्रायश्चित करामा येई; पमेश्वरनीमोरे तुम्ही आपला बठा पापसपाईन शुध्द ठरावामा येई. ");
INSERT INTO ahr_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","तुम्हले हाई परम विश्रामनं शाब्बाथ शे; हाई रोज तुम्ही आपला जीवले क्लेश देवानं. हाई कायमनी विधी शे. ");
INSERT INTO ahr_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ज्याले आपला वडीलनं जागवर याजक व्हावाकरता अभिषेक अनी शुद्ध व्हई त्यानी प्रायश्चित करानं; म्हणजे सणना कपडा घालीसनी. ");
INSERT INTO ahr_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","पवित्र स्थान, दर्शनमंडप अनी वेदी यानाकरता त्यानी प्रायश्चित करानं अनी याजक अनं मंडळीमासला दुसरा बठा माणसे यासनाकरताभी प्रायश्चित करानं. ");
INSERT INTO ahr_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","इस्राएल लोकेसकरता वर्षमा एकदाव त्यासना बठा पापसना प्रायश्चित करानं, म्हणीन हाउ तुमले कयमना नियम शेतस, परमेश्वरनी मोशेले आज्ञा देल परमानी त्यानी करं. ");
INSERT INTO ahr_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","परमेश्वर मोशेले बोलना, ");
INSERT INTO ahr_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","अहरोन, त्याना पोर्‍या अनी बठा इस्राएल लोक यासले सांग की परमेश्वरनी आशी आज्ञा देयेल शे; ");
INSERT INTO ahr_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","इस्राएल घराणामाईन एखादा माणूसनी छावणीमा किवा छावणीइना बाहेर बकरा मारानं, ");
INSERT INTO ahr_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","दर्शनमंडपना दारपान परमेश्वरनी निवासमंडपनामोरे परमेश्वरले अर्पण करानं तो नही लवाऊ नही, तर त्या माणुसना हत्यानं दोष लागी; त्यानी खून करेल शे म्हणून त्याना लोकेसनामोरे त्याना नाश व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","याना हेतू आशे शे की इस्राएल लोक आपला यज्ञपशू मोकळी जागामा मारत व्हतात, ते‍ त्यानी दर्शनमंडपना दारपान याजककडे परमेश्वरनीमोरे लयीसनी परमेश्वरकरता शांतिर्पण म्‍हणीसनी अर्पण करानं. ");
INSERT INTO ahr_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","याजकनी त्याना रंगत दर्शनमंडपना दारपान परमेश्वरनी वेदीवर शितडानं अनी त्याना चरबीना परमेश्वरले सुवासिक हवन म्हणीसनी होम करानं. ");
INSERT INTO ahr_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","जे व्यभिचारी इचारतीन बोकड देवतासनीमागे लागीसनी त्‍यासले यज्ञपशूनं अर्पण करतस त्यासनी यानापूढेतीन त्यास यज्ञ करानं नही, हाई तुम्हले कायमना अनी पिढयानपिढयाना विधी समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","तु त्‍यासले सांग की इस्राएल घराणासमाईन नाहिते त्यामा राहाणारा उपरी लोकेसमाईन कोणी होमार्पण नाहिते शांत्यर्पण करी, ");
INSERT INTO ahr_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","अनी ते दर्शनमंडपना दारपान परमेश्वरले अर्पण कराकरता लवानं नही, तर त्याना लोकेसनीमोरे नाश व्हावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","इस्राएल लोकेसमाईन नाहिते त्यासमा राहाणारा उपरी लोकेसमाईन कोणी कोणतेभी परकारंन रंगतना सेवन करं तर त्या माणुसना विरोध व्हईसनी त्याना लोकेसनामोरे त्याना नाश करसू. ");
INSERT INTO ahr_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","कारण शरीरना जीव रंगतमा राहास अनी तुम्हना जीवकरता प्रायश्चित व्हावाले पाहिजे‍ म्हणून ते तुम्हले वेदीवर देयेल शे, कारण जीवकरता प्रायश्चित रंगतघाईस व्हसं. ");
INSERT INTO ahr_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","हयानाकरता मी इस्राएल लोकेसले आज्ञा दिदि की तुम्हनामाईन कोणी रंगतना सेवन कराले नही पाहिजे, तुम्हनामां राहाणारा परदेशीसनीभी नही कराले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","पण इस्राएल लोकेसमाईन नाहीते त्यासमा राहाणारा उपर्‍यासमाईन कोणी खावासारखा पशूनं नाहिते चिडासना शिकार करं तर त्यानी त्याना रंगत काढीसनी ते माटीघाई झाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","कारण प्राणीमात्राना जीवनबारामा म्हणशा ते त्‍यासना रंगत हाईच त्यासना जीवन शे; याकरता इस्राएल लोकेसले मी आज्ञा देयेल शे की कोणतेभी जनावरनं रंगत सेवन करानं नही, कारण बठा जनावरसना जीवन हाईच रंगत शे; ते जे कोणी सेवन करं त्याना नाश व्हावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","एकाद माणुस, मंग तो स्वदेशना राहो नाहिते परदेशना राहो. त्यानात्याना मरेल नाहिते फाडेल जनावरसना मास खाद तर त्यानी आपला कपडा धईसनी पाणीघाई आंग धवानं स्नान करानं अनी संध्याकाळपावोत अशुध्दस राहावानं म्हणजे तो शुध्द व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","जर त्यानी आपला कपडा धवात नही अनी स्नान करं नहीते त्याना पापनं फळ त्या मिळी. ");
INSERT INTO ahr_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","परमेश्वर मोशेले बोलना, ");
INSERT INTO ahr_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","इस्राएल लोकेसले सांग की मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","तुम्ही मिसर देशमा राहात व्हतात तठेन्या चालीरितीसना अनुकरण करानं नही; अनी ज्या कनान देशमा लयी जाई राहीनू शे, तठेन्या चालीरितीसना अनुकरण करानं नही अनी तठेन्या विधी परमानं चालानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","मना नियम पाळानं अनी म्हनास विधी मान्य करीसनी त्यानापरमानं वागान; मी तुम्हना देव यहोवा शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","तुम्हीन म्हना विधी अनी नियम पाळानं; त्या जो पाळी तो‍ त्यानामा जीवता राही; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","तुम्हना माईन कोणी आपला जोडेना नातेवाईकसना काया उघडी कराले त्यासपान जावानं नही; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","तु आपला वडीलनी म्हणजे आपली मायनी काया उघडी करानं नही, ती तुन्ही माय शे म्हणून तिनी काया उघडी करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","आपली सावत्र मायनी काया उघडी करानं नही; ती तुन्ही वडिलनीस काया शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","आपली बहीण मंग ती सगी राही का सावत्र राहो; ती घरमा जन्म व्हयेल राहो का बाहेर जन्म व्हयेल राहो, तिनी काया उघडी करानी नही. ");
INSERT INTO ahr_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","आपली नात, मंग ती पोर्‍यानी पोर राहो का पोरनी पोर राहो तिनी काया उघडी करानी नही, तिनी काया ती तुनीस शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","वडीलले व्हयेल वडीलनी व्हयेल पोर ती तुनी बहीण शे म्हणून तिनी काया उघडी करानी नही. ");
INSERT INTO ahr_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","आपली आत्यानी काया उघडी करानी नही. ती तुनी वडीलनी बहीण शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","आपली मावशीनी काया उघडी करानी नही; कारण ती तूनी मायनी बहीण शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","आपला चुलतानी काया उघडी करानी नही म्हणजे त्यानी बायकोनीसंगे संभोग करानं नही; ती तुनी चुलती शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","आपली सुननी काया उघडी करानी नही; ति तुनी पोर्‍यानी बायको शे;‍ म्हणून तिनी काया उघडी करानी नही. ");
INSERT INTO ahr_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","आपली भावजायनी काया उघडी करानी नही; ती तुनी भाऊनी काया शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","एकादी बायनी अनी तिनी पोरनी दोन्हीसनी काया उघडी करानी नही; तिनी नात मंग ती तिना पोर्‍यानी पोर राहो नाहिते पोरनी पोर राहो, तिले आपली बायको करिसनी तिनी काया उघडी करानी नही; त्या जोडेना नाता शेत. आशे करानं म्हणजे मोठ पाप शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","तु तुनी बायकोनी बहीणले आपली बायको करिसनी तिले सवत करानं नही; ती जीवत राहीसनी तिनी बहीणनी काया उघडी करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","बाय ऋतुमती व्हावानंतर ती अशुध्दस राहास तोपावत तिनी काया उघडी कराकरता तिना जोडे जावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","तु आपली शेजारनी बाईनीसंगे कुकर्म करिसनी अशुध्द व्हवानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","आपला संतानमाईन एकादानं मोलख देवना करता आगनं होम करानं नही; तुना देव यहोवा याना पवित्र नावले कलंक लावानं नही; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","स्रीसंभोगपरमानं पूरुषसंभोग करानं नही, ते अमंगळ काम शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","कोणतेभी जनावरनीसंगे संभोग करिसनी अशुध्द व्हवानं नही; बाईनी जनावरनीसंगे कुकर्म कराले त्यानामोरे उभं राहावानं नही; हाई विपरीत कर्म शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","आशापरकारनं कोणतेभी कर्म करीसनी भ्रष्ट व्हवानं नही; कारण ज्या देशले मी तुम्हनामोरेतीन घालाडानार शे त्या आशा बठा कर्म करीसनी भ्रष्ट व्हयेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","त्यासना देश भ्रष्ट व्हयेल शे, त्यासनं दुष्टतामुळे मी त्यासना समाचार लि राहीनू शे अनी तो देश आपला रहिवाशासले वकी टाकेल शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","हयानाकरता तुम्ही मना विधी अनी नियम पाळानं अनी स्वदेश अनी तुमनामासला विदेशी उपरी यासनामाईन कोणी भी आशे अमंगळ काम करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","कारण तुम्हना आगोदर हाई देश राहाणारा लोकेसनी आशे बठा अमंगळ कर्म करामुळे हाई देश अशुध्द व्हयेल शे. ");
INSERT INTO ahr_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","तुमना आगोदर ज्या लोक हाई देशमा राहात व्हतात त्यासले जशे हाई देशनी वकी टाकं, तशे तुम्ही देश अशुध्द करं तुम्हलेभी वकी टाकाले नही पाहिजे; ");
INSERT INTO ahr_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ज्या कोणी आशे अमंगळ कर्म करतीन त्या बठासना त्यासना लोकेसनामोरे नाश व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","हाई ज्या आज्ञा मी तुम्हले देयेल शे त्या तुम्ही पाळानी; तुमनआगोदर प्रचलित राहेल अमंगळ रिवाजपरमानं तुम्ही चालानं नही अनी त्यानामुळे अशुध्द व्हवानं नही; मी परमेश्वर तुमना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","परमेश्वर मोशेले बोलना ");
INSERT INTO ahr_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","इस्राएलन्या बठया मंडळीसले सांग, तुम्ही पवित्र राहावानं, कारण मी परमेश्वर तुम्हना देव पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","तुम्ही आपला मायेले अनी बापले यासले भिवानं अनी म्हना शाब्बाथ दिवस पाळान; मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","तुम्ही मुर्तीसकडे वळानं नही अनी आपलाकरता ओतीव देव करानं नही; मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","जवय तुम्ही परमेश्वरकरता शांत्यर्पणकराकरता यज्ञ करशाल तवय मी तुम्हले प्रसन्न व्हसुं आशे ते करानं. ");
INSERT INTO ahr_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","त्या अर्पणनं मास यज्ञानं रोज अनी दुसरा रोज खावानं, पण तिसरा रोजले काही उरनं व्हयी ते आगमा जाळी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","तिसरा रोजले ते खावानं अमंगळ शे, ते मान्य व्हवाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","जो कोणी त्यामासला खाई त्याले त्याना दुष्कर्मानं फळ भेटी, कारण त्यानी परमेश्वरनी पवित्र वस्तुले दूषित करेल शे आशे व्हईल; त्या माणसासना स्वजनासमाईन नाश व्हावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","जवय तुम्ही तुमना देशना पिकासनी कापणी करशाल तवय तु आपला शेतना कोपराकापरासमासला पिक झाडीसनी बठा कापानं नही अनी पिक काढानंतर त्यासमासला सरवा येचानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","आपला द्राक्षमळाभी झाडीसनी ते खुडानं नही, द्राक्षमळामासला पडझड गोळा करानं नही; गरीब अनी उपरी यासनाकरता ते राहू देवानं,मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","तुम्ही चोरी करानं नही येरायेरनं कपट करानं नही अनी खोट बोलानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","मना नावानी खोटी शपथ लिईसनी आपला देवनी नावले कलंक लावानं नही. मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","आपला शेजारनावर जुलूम करानं नही अनी त्याले लूटा नही, मजूरनी मजूरी रातभर आपलाजोडे ठेवानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","बहिराले शिवीशाप देवानं नही; नहित्ये आंधळाले ठोकर लागी अशी वस्तू त्याना पुढे ठेऊ नको, तू आपाला देवले भिवानं, मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","न्याय करतांना अन्याय करानं नही, दारीद्रेनी दारिद्रवर नजर ठेवानं नही, मोठानं तोंड दखीसनी न्याय करानं नही, तर आपला शेजारनाना खरा मनतीत न्याय कर. ");
INSERT INTO ahr_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","आपला लोकासमा आठेतठे चुगल्या करत फिरानं नही,आपला शेजारनानावर जीववर उठानं नही, मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","आपला मनमासुध्दा भाऊनीबारामा व्देष करानं नही, आपला शेजारनाले दटाडानं नाहिते तो तुना माथा पाप लागी ");
INSERT INTO ahr_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","बदला लेवानं नही; आपला भाऊबंदमाईन कोणवर दावा करानं नही, आपला शेजारनावर प्रेम करानं; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","मना विधी पाळानं, आपला जनावरसना येगळा जातसना जनावरसनासंगे ताळमेळ बसू देवानं नही. आपला वावरमा दोन जातीसना बिवारा एकजागे मिळाडानं नही; दोन परकारनं सुत मिळाडेल कपडा आंगवर घालानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","एकादी बाई दासी शे अनी तिनी एकादा माणुसनीसंगे संभोग करं पण ती एकादानी बायको व्हयी; तिनासंगे कोणी कुकर्म करं व्हयीते त्या दोन्हीसले शिक्षा व्हावाले पाहिजे; पण तिनी मुक्तता व्हयेल नही व्हयी तर तिले मारानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","मंग माणसुनी दर्शनमंडपना दारपान परमेश्वरनीमोरे दोषर्पणकराकरता एक मेंढा लई येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","अनी त्यानी करेल पापसनीकरता दोषर्पणना मेंढानीद्वारे त्यानाकरता याजकनी परमेश्वरनीमोरे प्रायश्चित करानं, म्हणजे त्यानी करेल पापसनी क्षमा मिळी. ");
INSERT INTO ahr_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","तुम्ही त्या देशमा जावानंतर खावाकरता येगळं-येगळं झाड लावशात तवय तीन वरिषपावोत त्यासना फळ निशिध्द समजानं, त्या खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","चौथा वरिसले त्या बठा फळ परमेश्वरनी उपकारस्मरण करता पवित्र समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","मंग पाचवा वरिषले त्‍यासना फळ खावानं म्हणजे त्यासमाईन तुम्हले बराच फळ भेटतीन. मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","तुम्ही कोणतेबी मास रंगतनासंगे खावानं नही; तुम्ही जादु-टोना करानं नही अनी शकूनमुहर्त दखानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","आपला डोकानं घेरा ठेवानं नही; आपला दाढीना कोपरा काढीसनी तिले कूरुप बनाडानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","कोणी मरेल व्हयीते आपाला आंगले इजा करानं नही, आपला आंग गोंदानं नही; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","आपली पोरले अशुध्द करीसनी तिले वेशा होऊ देवानं नही; वेशागमनमुळे देश दुष्टतातीन भरी जाई आशे करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","मना शाब्बाथ पाळानं अनी मना पवित्रस्थानना बारामा आदर करानं; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","पंचाक्षरसना अनी चेटकासनी मागे लागानं नही; त्यासना मागे लागीसनी अशुध्द व्हवानं नही; मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","पिकेल केसासनीमोरे उठीसनी उभं ऱ्हाय; म्हातारासले मान देवानं; आपला देवले भिवानं; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","एकाद विदेशी माणुस तुम्हना देशमा तुम्हनासंगे राहास व्हयी तर त्याले त्रास देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","तुम्हनाबरोबर राहाणारा विदेशी माणुसले तुम्ही स्वदेश माणुसनीसारखा ठेवानं अनी त्यानावर आपलासारखाच प्रेम करानं; कारण तुम्ही मिसर देशमासला परदेशी व्हतात. मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","न्याय करामा, मोजणी करामा, वजन तोलामा अनी माप करामा काही अन्याय करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","खरा तागडा, खरा वजन, खरा एफा अनी खरा हिन हाई तुम्हनाजोडे राहावाले पाहिजे; ज्यानी तुम्हले मिसर देशमाईन आणेल शे तो मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","त्याकरता तुम्ही मना बठा विधी अनी बठा नियम मान्य करीसनी पाळानं; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","परमेश्वर मोशेले बोलना ");
INSERT INTO ahr_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","इस्राएल लोकेसले आजुन आशे सांग; इस्राएल लोकेसमाईन नाहिते इस्राएल लोकेसमा राहानारा उपर्‍यासमाईन कोणी आपला अपत्य मोलखा अर्पण करं त्याले मारी टाकानं; देशना लोकेसनी त्याले दगडमार करानं ");
INSERT INTO ahr_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","मी त्याना विरोधी व्हयीसनी त्याना स्वजनासनमोरे नाश करसु; कारण त्यानी अपत्य मोलख देवताले देईसनी मना पवित्रस्थानले अशुध्द करेल शे अनी मना पवित्र नावले कलंक लायेल शे. ");
INSERT INTO ahr_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","मोलख देवताले आपला अपत्य अर्पण करनाराकडे देशमासला लोकेसनी कानाडोळा करीसनी त्याले मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","तर मी त्या माणुसले अनी त्याना कूटुंबले विरोधी व्हयीसनी त्याना अनी जो कोणी त्यानासारखा व्यभिचार मनतीन मोलख देवताले धरतीन, त्या बठासना नाश करी टाकसु. ");
INSERT INTO ahr_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","जो माणुस व्यभिचार मनतीन पंचाक्षरी अनी चेटका यासना मांगे लागी त्याले विरोध व्हयीसनी त्याना नाशे करी टाकसु. ");
INSERT INTO ahr_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","म्हणुत तुम्ही स्वताले पवित्र करिसनी पवित्र राहावानं; कारण मी परमेश्वर तुमना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","तुम्ही मना विधी मान्य करिसनी पाळानं; तुम्हले पवित्र करनारा मीच परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","आपला बापले अनी मायले जो शिव्याशाप देस त्यासले नक्की मारी टाकानं; जो आपला बापले अनी मायले शिव्याशाप देई त्याना रंगत त्याना माथाले लागी. ");
INSERT INTO ahr_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","कोणी एकादी बाईनीसंगे संभोग करी तर आपला शेजारनी बाईनीसंगे व्यभिचार करणारा तो जार अनी ती जारनी या दोन्हीसले नक्की मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","जो आपला बापनी बाईनीसंगे झोपना तर तो आपली बापनी काया उघडी करसं त्या दोन्हीसले नक्की मारी टाकानं; त्यासना रंगत त्यासना माथाले लागी. ");
INSERT INTO ahr_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","कोनी आपली सुननीसंगे झोपना तर त्या दोन्हीसले नक्की मारी टाकानं; त्यासना कर्म विपरित शे; त्यासना रंगत त्यासनास माथाले राही. ");
INSERT INTO ahr_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","कोनी स्री-स्रीसंगेझोपी किवा पुरुषप-पुरुषसंगेझोपी तर त्या दोन्हीसना हाई अमंगळ कर्म शे. त्यासले नक्की मारी टाकानं. त्यासना रंगत त्यासनास माथाले राही. ");
INSERT INTO ahr_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","एकादी बाई अनी तिनी माय या दोन्हीसले कोणी ठेवं तर ते महापाप शे; तो माणुस अनी त्या दोन्ही बाया यासले आगमा जाळी टाकानं; तुम्हनामं आशे दुष्कर्म राहावाले नही पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","एकादा माणुसनी एकाद जनावरनीसंगे झोपना तर त्याले मारी टाकानं; अनी ते जनावरलेबी मारी टाकानं ");
INSERT INTO ahr_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","एकादी बाई कुकर्म कराले एकादा जनावरकडे गयी तर तिले अनी जनावरले मारी टाकानं; त्यासना रंगत त्यासनास माथाले राही. ");
INSERT INTO ahr_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","कोणी आपली बहीणले, मंग ती त्यानी बापनी पोर असो नाहिते त्यानी मायनी पोर असो, आपली बायको करिसनी तो तिनी काया दखी अनी ती त्यानी काया दखी तर हाई वाईट परकार शे; त्या दोन्हीसले त्यासना भाऊबंदसनादेखत नाश करानं; त्यानी आपली बहीणनी काया उघडी करी आशे व्हयी; त्यानी आपला दुष्कर्मना भार वाहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","जर एकादी बाईले मासिक पाळी व्हयी अनी तिनासंगे कोणी झोपना अनी तिनी काया उघडी करी तर त्यानी तिना रंगतना झरा उघडं कर आशे व्हयी, त्या दोन्हीसना भाऊबंदसनादेखत नाश करानं. ");
INSERT INTO ahr_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","आपली मावशी नाहिते आत्या यासनी काया उघडी करानी नही जो तशे करी त्यानी जोडेना नातेवाईकासकडे काया उघडी करेल शे आशे व्हयी, त्यानी आपला दुष्कर्मना भार वाहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","कोणी आपली काकूनीसंगे झोपना तर त्यानी आपला काकानी काया उघडी करेल शे आशे व्हयी, त्या आपला पापना भार वाहीसनी बिना अपत्यसना मरतीन. ");
INSERT INTO ahr_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","कोणी आपली भावजायले ठेई तर ती भ्रष्टता शे; तशे करीसनी आपला भाऊनी काया उघडी करेल शे आशे व्हयी; त्या बिना पोऱ्यासोऱ्यासना राहातीन ");
INSERT INTO ahr_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","हयानाकरता तुम्ही मना बठा विधी अनी मना बठा नियम मान्य करीसनी पाळानं म्हणजे ज्या देशमा तुम्हले लयी जाई राहीनु शे तो तुम्हले वकनार नही. ");
INSERT INTO ahr_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ज्या देशले मी तुम्हनामोरेतीन घालाडनार शे त्यासना चालीरितीसना अनुकरण करानं नही; त्यासनी आशे भ्रष्टाचार करं म्हणीन माले त्यासना तिटकारा व्हनं ");
INSERT INTO ahr_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","पण मी तुम्हले सांगेल शे की त्यासना देश तुम्हना वतन व्हयी, मी ते तुम्हले सोपासुं जठे दुधमधना प्रवाह वाही राहीना शेतस आशा देश तुम्हना ताब्यामां दिसु; तुम्हले इतर राष्ट्रासमाईन येगळा करणारा मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","याकरता तुम्ही शुध्द अनी अशुध्द चिडा यामासला भेद पाळानं अनी जो कोणताबी जनावर,चिडा नाहिते जमिनवर रांगणारा जनावर मी तुम्हनाकरता अशुध्द ठराईसनी निषेधेल शे. त्यानद्वारे तुम्ही स्वताले अमंगळ करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","तुम्ही मनाकरता पवित्र व्हवानं; कारण मी परमेश्वर पवित्र शे; तुम्ही मनावाला राहावाले पाहिजे म्हणुन मी तुम्हले इतर देशमाईन येगळं करेल शे. ");
INSERT INTO ahr_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","कोणी करनीकवटाळ वाला व्हयी, मंग तो माणुस राहो की बाई राहो त्यासले नक्की मारी टाकानं, त्यासले दगडमार करानं; त्यासना रंगतपात त्यासना माथाले राहि. ");
INSERT INTO ahr_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","परमेश्वर मोशेले बोलना, अहरोनना पोर्‍या ज्या याजक शेतस त्यासले आशे सांग; त्यासना कुळमाईन कोणी मरं त्यासना कोणीच सुतक धरानं नही; ");
INSERT INTO ahr_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","आपला जोडेना सगा म्हणजे आपली माय, बाप, पोर्‍या, पोर, भाऊ, ");
INSERT INTO ahr_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","अनी जोडे राहेल कुवार्‍या बहीनी यासना मात्र सुतक धरानं. ");
INSERT INTO ahr_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","पण याजक आपला लोकेसमा परमुख शेतस म्हणुन त्यासनी सुतक धरीसनी स्वताले अपवित्र करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","त्यासनी आपला डोकानं मुंडन करानं नही, आपला दाढीना केस काढानं नही, आपला आंगले घाव करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","त्यानी आपला देवनीकरता पवित्र राहावानं अनी आपला देवनं नाव अपवित्र करानं नही; कारण ते परमेश्वरकरता हव्य म्हणजे देवकरता अन्न अर्पण करतस, म्हणून त्यानी पवित्र राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","त्यासनी वेश्या नाहिते भ्रष्ट बाई आपली बायको करानं नही; सोडेल बाईनीसंगे लगीन करानं नही. कारण याजक देवनीकरता पवित्र शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","हयाकरता तु त्यासले पवित्र मानान; तो तुना देवले अन्न अर्पण करस म्हणुन त्यासले पवित्र समजानं; कारण तुम्हले पवित्र करनारा मी परमेश्वर पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","एकादा याजकनी पोर वेश्याकर्म करीसनी अशूध्द व्हयेल व्हयी तर तिनी आपला बापले अशूध्द करेल शे आशे व्हयी; तिले आगमा जाळी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","जो आपला भाऊसमा परमुख याजक शे,‍ ज्याना डोकाले अभिषेक तेलना अभ्यंग व्हयेल शे, पवित्र कपडा घालाकरता ज्याना शूध्द व्हयेल शे, त्यानी आपला डोकानं केस सोडानं नही; आपला कपडा फाडानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","त्यानी कोणा प्रेतपान जावानं नही; आपला बापनी नाहिते मायनी सुतक धरानं नही; ");
INSERT INTO ahr_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","त्यानी पवित्रस्थाननीबाहेर जावानं नही; आपला देवनं पवित्तस्थान अशूध्द करानं नही; कारण त्याना देवना अभीषेक तेलघाई त्याना अशूध्द व्हयेल शे; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","त्यानी कवारी पोरनीसंगेस लगीन करानं ");
INSERT INTO ahr_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","विधवा,सोडेल बाई, भ्रष्ट बाई नाहिते वेश्या यासनामाईन कोणीस बायको करानं नही. तर‍ त्यानी भाऊबंदसमासली एकादी कुवारी पोरनी संगे लगीन करानं. ");
INSERT INTO ahr_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","त्यानी आपला नातेवाईकसमा आपली संतती अशूध्द होऊ देवानं नही; कारण त्याले पवित्र करानारा मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","आजुन परमेश्वरनी मोशेले सांग. ");
INSERT INTO ahr_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","अहरोनले सांग तुना वंशमा पिढयानपिढया ज्याले व्यंग व्हयी त्यानी देवले अन्न अर्पण कराकरता जोडे जावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","त्याले कोनतेबी व्यंग व्हयी तर त्यानी जोडे जावानं नही; मंग तो आंधळा,लंगडा, चपटया नाकना, जास्त आंगना व्हयेल राहो, ");
INSERT INTO ahr_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","तुटेल पायना नाहीते अपंग राहो, ");
INSERT INTO ahr_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","कुबडा, खुजा, नेत्रदोषी, राहो नाहिते चाई, गजकर्न व्हयेल अनी हिजडा राहो; ");
INSERT INTO ahr_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","अहरोन याजकना वंशमाईन एकादाले आशे व्यंग व्हयी तर त्यानी परमेश्वरले हव्य अर्पण कराकरता जोडे जावानं नही; त्याना आंगना व्यंग राव्हामुळे त्यानी आपला देवले अन्न अर्पण कराले जोडे जावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","त्यानी आपला देवले अर्पण करेल परमपवित्र अन्न खावानं. ");
INSERT INTO ahr_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","पण त्याले व्यंग राव्हामुळे त्यानी अंतरपटना मजार अनी वेदीनाजोडे जावानं नही; त्यानी मना पवित्रस्थाले अशुध्द करानं नही, कारण त्यासले पवित्र करनारा मी परमेश्वर शे ");
INSERT INTO ahr_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","मोशेनी अहरोन, त्याना पोर्‍या अनी बठा इस्राएल लोक यासले हाई सांग ");
INSERT INTO ahr_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","परमेश्वरनी मोशेले सांग ");
INSERT INTO ahr_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","अहरोन अनी त्याना पोर्‍या यासले सांगानं की इस्राएल लोकेसना‍ ज्या पवित्र वस्तु शेतस ते मला समर्पित करतस त्याबारामा त्यासनी जपानं अनी पवित्र नाव अशुध्द करानं नही; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","तु त्यासले सांग पिढयानपिढया तुम्हना बठा वंशमा ज्या कोणी अशुध्द अवस्थामा शेतस इस्राएल लोकेसनी परमेश्वरले समर्पित करेल पवित्र वस्तुसले हात लावतीन त्यासना मनासमोर नाश व्हावाले पाहिजे; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","अहरोनना वंशासमाईन कोणी कोड व्हयेल नाहीते स्राव व्‍हतीन तर त्यानी शुध्द व्हस तोपावोत पवित्र करेल वस्तु खावानं नही, मयतमुळे अशुध्द व्हयेल माणुसले नाहिते वीर्यपात व्हयेल माणुसले स्पर्श करी. ");
INSERT INTO ahr_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ज्याना स्पर्शतीन माणसे अशुध्द व्हतात आशे रांगणारे जंतुसले नाहिते कोनतेबी परकारनं अशुध्द व्हयेल एकादा माणुसले जो स्पर्श करी. ");
INSERT INTO ahr_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","जो माणुस यासनामाईन कोणलेबी स्पर्श करी त्यानी संध्याकाळपावोत अशुध्द राहावानं अनी स्नान करतस तोपावोत पवित्र वस्तु खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","सुर्यास्त व्हावानंतर तो शुध्द व्हयी, त्यानी त्यानंतर पवित्र वस्तूसनं सेवन करानं, कारण ते त्याना अन्न शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","त्यानात्याना मरेल नाहिते हिंसक जनावरसनी फाडेल आशे काही खाईसनी त्यानी अशुध्द व्हवानं नही; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","मनी आज्ञा त्यासनी पाळाले पाहिजे, नहीते त्या पापनाकरता त्यासले शिक्षा भेटी अनी त्यासनी आदज्ञाभम करी तर त्या मरतीन; त्यासले पवित्र करणारा मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","कोणी परकासनी पवित्र पदार्थ खावानं नही; तो याजकना घरना पाहूना नाहिते मजुर राहीना तरिबी त्यानी पवित्र पदार्थ खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","पण याजकनी मोल देईसनी एकादा माणुस विकत लिद् तर त्यानी ते खावानं, त्यापरमानं याजकना घरमा जन्म लिद व्हतीन त्यासनी ते खावानं ");
INSERT INTO ahr_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","याजकनी पोर कोणी परकाले देयेल व्हयी तर तिनी समर्पण करेल पदार्थ खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","याजकनी पोर विधवा व्हयी नाहिते नवरानी तिले सोड व्हयी अनी तिले पोरेसोरे नही व्हतीन अनी तरुण‍ व्हती तशीच आपला बापनी घर परत व्हनी व्हयीते तर तिनी आपला बापनं अन्न सेवन करानं; पण कोणी परकासनी ते खावानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","एकादा माणुसनि चुकीसन पवित्र पदार्थ खाद् व्हयी तर त्यानी पदार्थना पाचवा भाग इतले त्यामा भरीसन याजकले मोबदला देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","इस्राएल लोक ज्या पवित्र वस्तु परमेश्वरले अर्पण करतस त्या त्यासनी अशुध्द करानं नही; ");
INSERT INTO ahr_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","पवित्र पदार्थ खावानंतर उद्भवनारं त्यासना दोषजनक अधर्मभार वाहाकरता याजकसनी कारण व्हावानं नही; कारण त्यासले पवित्र करनारा मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","परमेश्वरनी मोशेले सांग ");
INSERT INTO ahr_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","अहरोन, त्याना पोर्‍या अनी बठा इस्राएल लोक यासले सांग; इस्राएल लोकेसमाईन नाहिते इस्राएल लोकेसमा राहानारा उपरी लोकेसमाईन कोणी आपला नवसना नाहिते स्वखुशीतीन बलीना परमेश्वरकरता होम करी. ");
INSERT INTO ahr_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","तुम्हना स्वीकार व्हावाले पाहिजे म्हणुन बैल, मेंढरे, नाहिते बकरी यासमासला परिपुर्ण नर अर्पण करानं. ");
INSERT INTO ahr_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","दोष राहेल कोनतेबी जनावरनं अर्पण करानं नही; कारण ते तुम्हनाकरता स्वीकार करता येवाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","आपला नवस पुरा कराकरता नाहिते स्वखुशीतीन अर्पण कराकरता कोनी परमेश्वरकरता बैलसमाईन नाहिते शेरडामेंढरासमाईन शांत्यर्पण करी तर ते मान्या व्हावाकरता परिपुर्ण राहावाले पाहिजे, त्यामा काही दोष राहावाले नही पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","आंधया, अवयव तुटेल व्हयेल, लुळा नाहिते आंगवर मस,नायटे नाहिते खरुज व्हयेल आशे कोनतेबी जनावर परमेश्वरले अर्पा नही नाहिते त्याना वेदीवर बळी म्हणीसनी परमेश्वरकरता होम करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","बैल, मेंढा नाहिते एकादा अवयव कमी-अधिक व्हयी तर ते स्वखुशीतीन अर्पण कराले चाली; पण नवस फेडा करता त्याना स्वीकार व्हनार नही. ");
INSERT INTO ahr_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ज्याना आंडा दाबेल, बडवेल, फुटेल नाहिते कापेल व्हतीन आशे कोनतेबी जनावर परमेश्वरले अर्पण करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","यामासला कोनतेबी जनावर परकासना हाततीन लयीसनी आपला देवले अन्न म्हणीसन अर्पण करानं नही; कारण त्यामा व्यंग शे, त्यामा दोष शे, म्हणुन ते तुम्हनाकरता स्वीकारामा येवाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","परमेश्वरनी मोशेले सांग. ");
INSERT INTO ahr_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","बैल, मेंढा नाहिते करडू यासना जन्म व्हावानंतर सात रोज आपला मायनीसंगे राहावाले पाहिजे, आठवा रोजले हव्यरुपतीन अर्पण कराकरता स्वीकाराले योग्य ठरी. ");
INSERT INTO ahr_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","बैल नाहिते मेंढीनं अनी तिना वत्साना एकच रोज बळी देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","जवय तुम्ही परमेश्वरकरता शांत्यर्पणना बळीना यज्ञ करशी तवय तुम्हना अंगीकार व्हयी तेच रितीतीन ते करानं. ");
INSERT INTO ahr_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","त्यारोज ते खावानं; त्यामासला काही सकाळ पावोत ठेवानं नही, मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","तुम्ही मन्या आज्ञा मान्य करीसनी त्या पाळानं; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","मना पवित्र नावले बट्टा लावानं नही; इस्राएल लोकेसमा माले पवित्र समजानं; तुम्हले पवित्र करनारा मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","तुम्हना देव व्हावाले पाहिजे म्हणुन मी तुम्हले मिसर देशमाईन बाहेर आणं शे; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","परमेश्वरनी मोशेले सांग; ");
INSERT INTO ahr_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","इस्राएल लोकेसले सांग, पवित्र मेळा लेवाकरता परमेश्वरनी ज्या पर्वकाळसना जे तुम्हले जाहीर करानं शे ते मना नेमेल पर्वकाळ ते अशं; ");
INSERT INTO ahr_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","सहारोज बठा कामकाज करानं पण सातवारोजले विश्राम दिवस अनी पवित्र मेळानं दिवस शे; हाई दिवसले तुम्ही कोणतभी काम करानं नही; तुम्हना बठा घरासमा हाई परमेश्वरनं शब्बाथ राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","परमेश्वरनी जे नेमेल येळ म्हणजे पवित्र मेळानं दिवस तुम्ही नियमतीन येळले जाहीर करानं ते हाई; ");
INSERT INTO ahr_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","पहिला महिनानं चौथा दिनले संध्याकाळले परमेश्वरनं वल्हाडण सण येस. ");
INSERT INTO ahr_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","त्याच महीनानं पंधरावा रोजले परमेश्वरकरता बेखमीर भाकरीनं सण सुरु व्हस; त्यामा तुम्ही सातरोज बेखमीर भाकर खावानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","त्यामाईन पहिला रोज तुम्ही पवित्र मेळावा भरावानं; त्या रोजले काहिच काम करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","सात रोज तुम्ही परमेश्वरले हव्य अर्पानं, सातवा रोजले पवित्र मेळावा भरावानं; त्या रोज आंगमेहनतनं काम करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","परमेश्वरनी मोशेले सांग, ");
INSERT INTO ahr_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","इस्राएल लोकेसले सांग; जो देश मी तुम्हले देयेल शे तठे तुम्ही जाशाल अनी त्यामासला पीक कापशाल तवय आपला पीकनं पहिला उपजनी पेंढी याजककडे लयानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ती पेंढी तुम्हनाकरता स्वीकारामा येवाले पाहिजे म्हणुन ती त्यानी परमेश्वरनीमोरे ओवाळानं; शाब्बाथना दुसरा रोजले याजकनी ती ओवाळानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","जवय पेंढीनी ओवाळनी करशी तवय त्या रोजले एक वरिशना एक परिपुर्ण मेंढानं परमेश्वरकरता होम करानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","त्यानासंगे अन्नबली तेलमा मळेल दोन दशमांस एफा सपीठ राहावाले पाहिजे; हाई परमेश्वरनीकरता सुवासिक हव्य व्हयी ; अनी त्यानासंगे पेयर्पण म्हणीन एक चतुर्थांश हिन द्राक्षरस अर्पानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","हाई बठा अर्पण कराकरता तुम्ही आपला देवनीमोरे लयी जाशी त्या दिवसपावोत नवीन पीकनं भाकर खावानं नही. तशेच हिरवा हुरडा नाहिते हिरवा धान्य खावानं नही. तुम्हन बठा घर हाई पिढयानपिढया कायमनं विधी शे. ");
INSERT INTO ahr_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","शब्बाथना दुसरा दिवस तुम्ही ओवाळनीनं पेंढी आणशाल तवयपाईन पुरा सात शब्बाथ मोजान; ");
INSERT INTO ahr_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","सातवा शब्बाथना दुसरा दिवसले पन्नासावा दिवस मोजीसनी त्या रोज परमेश्वरकरता नवीन अन्नर्पण करानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","तुम्ही आपला घरमाईन दोन दशमांश एफाभर सपिठन्या दोन भाकरी ओवाळनीकरता आणानं. त्यामा खमीर घालीसनी भुजानं. परमेश्वरकरता हाई पहिलं उपज अर्पण शे. ");
INSERT INTO ahr_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","एक एक वरिशना सात परिपुर्ण कोकरा, एक बैल अनी दोन मेंढा भाकरीनीसंगे अर्पानं; त्यानाबरोबरनं अन्नार्पण अनी पेयर्पण यासनसंगे त्यासना परमेश्वरकरता होम करानं; हाई परमेश्वरकरता सुवासिक हव्य शे. ");
INSERT INTO ahr_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","मंग पापार्पणकराकरता एक बोकडया अनी शांतीर्पणना यज्ञकरता एक एक वरिशनं दोन मेंढासनं अर्पण करानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","याजकनी त्या पहिल्या उपजन्या भाकरीसनाबरोबर त्या दोन मेंढयासंगे ओवाळानं; हाई परमेश्वरकरता पवित्र व्हयीसनी याजकनं भाग व्हावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","तुम्ही त्याच रोजले पुकारानं की हाई दिवस आपला एक पवित्र मेळा भरी, म्हणुन त्यारोजले कोणीबी आंगमेहनतनं काम करानं नही; तुम्हना बठा घरबारेशले हाई पिढयानपिढया कायमना विधी शे. ");
INSERT INTO ahr_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","जवय तुम्ही आपला देशमासला पिक कापशाल तवय कानाकोपराना झाडीसनी बठी कापनी करानी नही, अनी आपला पिकना सरवा येचानं नही; गरीब अनी विदेशी हयासनाकरता राखी ठेवानं; मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","परमेश्वरनी मोशेले सांग, ");
INSERT INTO ahr_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","इस्राएल लोकेसले सांग; सातवा महीनानं प्रतिपदा तुम्हले परमविश्राम राहावाले पाहिजे; आठवण देवाकरता त्यारोजले रणशिंगा फुकानं अनी पवित्र मेळा भरावानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","त्यारोजले तुम्ही अंगमेहनतनं काम करानं नही तर परमेश्वरले हव्य अर्पानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","परमेश्वरनी मोशेले सांग. ");
INSERT INTO ahr_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","त्याच सातवा महिनाना दशमीसले प्रायश्चितना दिवस पाळानं, त्यारोज तुम्हना पवित्र मेळा भरावानं; त्यारोज तुम्ही आपला जीवले क्लेश देवानं अनी परमेश्वरले हव्य अर्पानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","त्यारोज तुम्ही कोणतेभी काम करानं नही; कारण हाऊ प्रायश्चितना दिवस शे; त्यारोज तुम्ही देव यहोवा यानामोरे तुम्हनाकरता प्रायश्चित करानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","त्यारोज जो माणुस आपला जीवले क्लेश देवाऊ नही त्याना आप्तसनामोरे नाश व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","एकादा माणुसनी त्यारोज कोनतेबी काम करं व्हयी तर त्याना आप्तासनामोरे नाश व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","तुम्ही कोणतेभी काम नही कराले पाहिजे; तुम्हना बठा घरानाले ते पिढयानपिढया कायमनं विधी शे. ");
INSERT INTO ahr_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","तो दिवस तुम्हले परम विश्राम व्हावाले पाहिजे अनी तुम्ही आपला जीवले क्लेश देवानं; अनी ते महीनानं नववा रोज एक संध्याकाळपाईन ते दुसरा संध्याकाळपावोते तुम्ही शब्बाथ पाळानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","परमेश्वर मोशेले बोलना ");
INSERT INTO ahr_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","इस्राएल लोकेसले सांग; त्याच सातवा महीनानं पंधरावा दिवसपाईन सात दिवसपावोत परमेश्वरकरता मांडवनं सण पाळानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पहिला दिवसले पवित्र मेळा भरावानं, त्यारोजले आंग मेहनतनं काम करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","सातवा रोजले परमेश्वरले हव्य अर्पानं अनी आठवा रोजले आपला पवित्र मेळा भराईसनी परमेश्वरले हव्य अर्पानं. हाई महामेळानं समारोपदिन शे; त्यारोजले कोनतेबी आंगमेहनतनं काम करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","परमेश्वरना पर्वकाळ हया शेतस; त्यामा हव्य म्हणजे होमबळी; अन्नबळी शांत्यर्पण अनी पेयार्पण त्या दिवस परमानं परमेश्वरले अर्पानं त्याकरता पवित्र मेळा लेवानं आशे तुम्ही पुकारानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","हयानाशिवाय आजुण पाळाना सण म्हणजे परमेश्वरनं शब्बाथ पाळानं, भेटीसना अर्पण करानं, बठा नवस फेडानम अनी परमेश्वरले स्वखुशीतीन बठा अर्पण करानं हया शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","जमीननं उत्पन्न गोळा करानंतर त्याच सातवा महीनानं पंधरावादिवसपाईन सात दिवसपावोत परमेश्वरकरता सण पाळानं; पहिला रोज अनी आठवा रोज हाई परमविश्रामदिवस शे. ");
INSERT INTO ahr_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","पहिला रोज तुम्ही चांगला झाडासना फळं, खजुरन्या झावळया, दाट पानासना झाडासना फांदया, ओहळन्याजोडेन्या वाळुंजे हाई आणीसनी परमेश्वर तुमना देव यानामोरे सात रोज उत्सव करानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","वर्ष अनी वर्ष सात रोजपावोत परमेश्वरकरता हाई सण पाळानं, तुम्हना हाई पिढयानपिढया कायमनं विधी शे; सातवा महीनामा हाई सण पाळानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","तुम्ही सातरोज मांडवमा राहावानं; जेवढा जन्मतीन इस्राएल शेतस त्यासनी मांडवमा राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","म्हणजे तुम्हनी पुढली पिढिले कळी की मी इस्राएल लोकेसले मिसर देशमाईन काढ तवय त्यासनी मांडवमा वस्ती करेल शे आशे वाटी; मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","हाई परमानं माशेनी इस्राएल लोकेसले परमेश्वरना पर्वकाळ सांग. ");
INSERT INTO ahr_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","परमेश्वर मोशेले बोलना ");
INSERT INTO ahr_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","इस्राएल लोकेसले हाई आज्ञा दे; दिवा एकसारखा पेटत राहावाले पाहिजे म्हणून जैतुनं कुटीसनी काढेल निरे तेल तुनाकडे लयी येवानं. ");
INSERT INTO ahr_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","अहरोननी दर्शनमंडपमा आज्ञापट‍न्या आंतरपटना बाहेर परमेश्वरनीमोरे कायमनं संध्याकाळपाईन ते सकाळपावोत त्यानी व्यवस्था करी ठेवानी; हाई तुम्हन पिढयानपिढया कायमनं विधी शे. ");
INSERT INTO ahr_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","त्यानी हाई दिवा शुध्द दिपवक्षावर परमेश्वरनामोरे कायमनं ठेवानी व्यवस्था करानी. ");
INSERT INTO ahr_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","तु सपीठ लयीसनी त्यान्या बारा रोटया भुजानं; एक रोटी दोन दशमांस एफाभर सपीठमा करानं. ");
INSERT INTO ahr_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","त्यासना दोन रांगा करीसनी एक एक रांगमा सहा-सहा पोळ्या शुध्द मेजवर परमेश्वरनीमोरे ठेवानं ");
INSERT INTO ahr_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","एक एक रांगमा शुध्द लोबान ठेव म्हणजे तो त्या रोटीसना परमेश्वरले आठवण देनारं भेट आशं व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","परतेक शब्बाथ दिनले त्यानी परमेश्वरनीमोरे त्या कायम मांडानं; इस्राएल लोकेसकडतीन हाई कायमनं करार शे. ");
INSERT INTO ahr_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","हाई रोटी अहरोन अनी त्याना पोर्‍या यासना वाटा शे; त्यानी ती पवित्र ठिकानले खावानं; कारण कायमनं विधीपरमानं परमेश्वरले अर्पेल भेटमाईन ती त्याले परम पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","त्या येळले कोणी इस्राएल बाईनं मिसरी बापना एक पोर्‍या व्हता, तो इस्राएल लोकेसमा गया: तवय तो अनी इस्राएल माणुस छावणीमा भांनगड कराले लागनात. ");
INSERT INTO ahr_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","तो इस्राएल बाईना पोर्‍या परमेश्वरनं नावतीन निंदा करिसनी त्याले गाया देवाले लागी गया; तवय त्याले मोशेकडे लयी वनात, त्यानी मायनं नाव शलोमीथ शे ती दान वंशमासली दिब्री यानी पोर व्हती. ");
INSERT INTO ahr_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","त्याबारामा परमेश्वर काय सांगस ते कळाले पाहिजे म्हणुन त्यानी त्यासले अटक करी ठेवं. ");
INSERT INTO ahr_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","मंग परमेश्वरनी मोशेले सांग. ");
INSERT INTO ahr_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","तुम्ही त्या गाया देनाराले छावणीबाहरे लयी जा; जेवढासनी ती निंदा आयकेल शे तेवढासनी आपला हात त्याना डोकावर ठेवानं; त्यानंतर बठी मंडळीनी त्याले दगडमार करानं. ");
INSERT INTO ahr_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","तु इस्राएल लोकेसले सांग की ज्या कोणी आपला देवले गाया दी त्याना पापना फळ त्याले भेटी. ");
INSERT INTO ahr_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","परमेश्वरनी नावले निंदा करनारासले नक्की मारी टाकानं; बठी मंडळीने त्याले दगडमार करानं. तो परदेशी राहो का स्वदेशी राहो त्यानी परमेश्वरनी नावनी निंदा करी तर त्याले जीवत मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","जो माणुस खून करी त्याले निश्चित मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ज्या कोनी एकादा ग्रामपशुले मारं त्यानी जनावरना बद्दल जनावर भरी देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","कोण आपला शेजारनावर व्यंग करी तर त्यानी जशे करेल शे तशे त्याले करानं; ");
INSERT INTO ahr_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","अवयवभंगनीबद्दल अवयवभंग, डोळानीबद्दल डोळा दातसनीबद्दल दात हाई परमानं त्यानी माणुसले जी इजा करेल व्हई तशच त्याले भी करानं. ");
INSERT INTO ahr_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","पशु मारनार्‍यानी त्यानी भरपाई करानी, पण माणुसनी हत्या करनाराले मारी टाकानं ");
INSERT INTO ahr_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","तुम्ही स्वदेशी राहो का विदेशी राहो, तुम्हले बठासले एकच नियम शेतस; कारण मी परमेश्वर तुमना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","मोशेनी इस्राएल लोकेसले हाइपरमानं सांग तवय त्यासनी त्या गाया देनाराले छावणीबाहेर लयी जाईसनी दगडमार करं, परमेश्वरनी मोशेला आज्ञा देयेल परमानं इस्राएल लोकेसनी करं. ");
INSERT INTO ahr_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","परमेश्वरनी सीनाय पर्वतपान मोशेले बोलना ");
INSERT INTO ahr_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","इस्राएल लोकेसले आशे सांग; जो देश मी तुम्हले दि राहीनूं शे तठे तुम्ही जाशाल म्हणजे परमेश्वरकरता विश्राम मिळाडानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","सहा वरिश शेती करानीस अनी सहा वरिश द्राक्षमळानं छाटनी करीसनी त्याना उत्पन्न जमा करानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","पण सातवा वरिशले जमीनले परमविश्रामना शब्बाथ परमेश्वरकरता राहावाले पाहिजे. त्या वरिशले वावरमां पैरानं नही नाहिते छाटनी करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","त्यानात्याना उगेल धान्य कापानं नही; छाटनी नही व्हयेल द्राक्षयेलना फळ तोडानं नही; जमीननं परमविश्रामना ते वरिश राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","जमीनना विश्रामकालना उपजवर तुम्हना, तुम्हना दासदासीले, तुम्हना मजुरसले, अनी तुम्हनासंगे राहानारा परदेशीसले जेवण भेटी; ");
INSERT INTO ahr_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","तुम्हना पशू अनी देशमासला जनावरं यासले जमीननं बठा उत्पन्न खावाले भेटी. ");
INSERT INTO ahr_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","सात विश्रामवरिश म्हणजे सात गुना सात एवढा वरिश मोजानं; या सात विश्राम वरिशना काळ एकूणपन्नास वरिश शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","मंग सातवा महीनानं दशमीले म्हणजे प्रायश्चितना दिवसले महानांदना शिंग देशमा बठीकडे फुकानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","त्या पन्नासावा वरिसले पवित्र मानानं अनी देशमासला बठा रहिवाशीसले मोकळ करानी घोषणा करानी; हाई वरिसले तुम्ही योबेल म्हणानं; हाई वरिसले तुम्ही‍ ज्यानात्याना वतनमां अनी आपआपला घर परत जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","हाई पन्नासाव वरिश तुम्हले योबेल वरिस शे; हाई वरिशले तुम्ही काही पैरानं नही, त्यानात्यान उगेल कापानं नही अनी छाटनी नही व्हयेल द्राक्षयेलनं फळ खूडानं नही; ");
INSERT INTO ahr_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","कारण हाई योबेलनं वरिश शे; हाई तुम्हले पवित्र राहावाले पाहिजे; हाई वरिशले तुम्हले वावरमा जे सापडी ते खावानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","हाई योबेल वरिश तुम्ही बठासनी आपआपला वतनमा परत जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","जवय तुम्ही आपल भाउबंदसले काही विकशाल नाहिते त्यासनाकडतीन विकत लिद् तवय येरायेरवर अन्याय करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","योबेल वरिशनंतर जेवढा वरिश व्हयेल व्हतीन त्यासना आकडापरमानं आपला भाउबंदसपाईन मोल लेवानं अनी तेवढा वरिशना उत्पन्नपरमानं त्यानी विक्री करानी. ");
INSERT INTO ahr_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","त्या वरिशना आकडा जास्त व्हतीन ते त्या मनतीन मोल कमी करानं; कारण जेवढा पिक व्हयले व्हतीन त्यासना हिशोबतीन त्यानी ती विक्री करानी. ");
INSERT INTO ahr_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","तुम्ही येरायेरवर अन्याय करानं नही; तर आपला देवले भिवानं, कारण मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","हयानाकरता तुम्ही मना विधी मानानं अनी मना नियमकडे ध्यान देवानं अनी ते पाळानं; आशे करानंतर तुम्ही देशमा बेफिकीर राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","भुमी आपला उपज देई अनी तुम्ही पोटभर खाशा; तठे वस्तीमा सुकीतीन राशात. ");
INSERT INTO ahr_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","तुम्ही कदाचित बोलशात, आम्ही सातवा वरिशले काय खावानं? कारण त्या वरीशले आम्हले पैरानं नही अनी वावरमा उत्पन्न जमा करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","तर मी सहावा वरिशले आशी बरकत दिसु की, जमीन तुम्हले तीन वरिशनं उत्पन्न देई. ");
INSERT INTO ahr_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","मंग आठवा वरिशले तुम्ही पैरशात तवय जुना साठा तुम्ही खात राहाशात; नववं वरिशनं पिक हातमा येस तोपावोत त्या वरिशले तुम्ही जुना साठा खात राहाशात. ");
INSERT INTO ahr_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","जमीन ईकानी शे म्हणीसनी ती कायमनी ईकानी नही; कारण जमीन मनी शे अनी तुम्ही मना आश्रयले परदेशी अनी उपरि राहानार शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","म्हणुन तुम्हना वतनना बठा व्यवाहरमा जमीन सोडानाबारामा तुम्ही तरतूद करानी. ");
INSERT INTO ahr_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","तुम्हना भाऊबंदसमाईन कोणी कंगाल व्हयीसनी त्यानी आपला वतनना काही भाग ईकी दिधा तर‍ त्याना नातेवाईकसनी समोर येईसनी आपला भाउबंदसनी ईकेल भाग सोडी लेवानं ");
INSERT INTO ahr_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","जर त्या माणुसना कोणी नातेवाईक नही व्हतीन ज्या ते सोडतीन, अनी आपला वतनभाग सोडवता येई एवढी ऐपत त्यानी व्हयनी, ");
INSERT INTO ahr_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","तर त्यानी ते वतन ईकी टाकं व्हयीते तर त्या वरिसपाईन हिशोब करीसनी बाकीना वरिसना उत्पन्न ईकत लेनाराले देवानं अनी आपला वतनले परत जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","पण ते वतन परत मिळाडानीकरता त्यानी ऐपत नही व्हयी तर आपली ईकेल जमीन ईकत लेनारानी ताबामा योबेल वरिशपावोत राहू देवानं; योबेल वरिशले ती सुटी तवय त्यानी आपला वतनले परत जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","एकादा माणुसनी तटबंदीना नगरमासला घर ईकं तर त्यानी ईकानंतर एक वरिशना आगोदर पैसा देईसनी त्याले सोडवता येई; पैसा देईसनी त्याले सोडता येई; पैसा देईसनी सोडावानं हक्क त्याले पुरा एक वरिश राही. ");
INSERT INTO ahr_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","एक पुरा वरिशना आगोदर ते सोडावं नही तर तटबंदिना नगरमासला घर ईकत लेनारानी व्हयी जाई अनी पिढयानपिढया त्याना वंशमा कायम राही. योबेल वरिश ते सुटाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","पण बिगर तटबंदिना खेडामा ज्या घरे व्हतीन त्या देशमा शेतनासारखं समजानं; ती सोडा येतीन अनी योबेल वरिशले त्यासनी सुटका व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","लेवीसना वतनना नगरमा बांधेल घरं लेवीसले पाहीजे तवय सोडावता येई. ");
INSERT INTO ahr_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","एकादा लेवीनं घर दुसरा एकादानी सोडाई लिद् तर त्याना वतनना नगरमासला त्यानं ते ईकेल घर याबेल वरिसले सूटी; कारण इस्राएलमा लेवीसना वतन म्हणं म्हणजे त्यासना नगरमासला घरच शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","त्या नगरनी शिवारनी जमीन ईकानी नही; ते त्यासना कायमनं वतन शे. ");
INSERT INTO ahr_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","तुना कोनी भाऊ कंगाल व्हयना अनी त्याना हात काम नही करी राहिना आशे तुले दखायनं तर तु त्याले आधार देवानं. परदेशीपरमानं नहीतर उपर्‍यासपरमानं तो तुना जोडे राही. ");
INSERT INTO ahr_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","त्यानापाईन व्‍याज किंवा फायदा लेवानं नही; आपला देवले भ्याईसनी आपलाजोडे आपला भाऊसले राहु देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","तु आपला पैसा त्याले व्याजतीन देवानं नही; नाहितर आपला दाणा गोटा वाढीदीडीसनी त्याले देवानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","मी परमेश्वर तुमना देव शे; तुम्हले कनान देश देवानं अनी तुम्हना देव व्हवानं म्हणीसनी मी तुम्हले मिसर देशमाईन तुम्हले बाहेर आणेल शे. ");
INSERT INTO ahr_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","तुना कोनी भाऊबंद तुनामोरे कंगाल व्हयनं अनी त्यानी स्वताले ईकी टाक तर त्यानापाईन सेवा करी लेवानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","मजुरना सारखा नाहिते उपर्‍यासपरमानं तो तुनाजोडे राहावले पाहिजे; योबेल वरिशपावोत तो तुना सेवाचाकरी करी. ");
INSERT INTO ahr_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","त्या वरिशले आपला पोर्‍यासोर्‍यासंगे त्यानी तुनापाईन निघीसनी आपला कुटूंबमा अनी आपला वाडवडीलसनीसंगे वतनमा परत जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","कारण मिसर देशमाईन मी ज्यासले काढेल शे त्या मना सेवक शेतस; दासपरमानं त्यासनी विक्री करानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","कठोरनागतक त्यानावर अधिकार चालाडानं नही; आपला देवले भिवानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","तुम्हले दास अनी दासी ठेवानं व्हतीन त्या तुम्ही दुसरा देशमाईन लयी येवानं; दास अनी दासी हया त्यासमाईन ईकत लेवानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","तुमनामा येईसनी राहेल ज्या उपरी लोक अनी त्यासना पोटी जो घराना तुम्हना देशमा पैदा व्हयेल शेतस त्यासनामाईन तुमी दास अनी दासी ईकत लेवानं, ती तुम्हनी मालमता शे. ");
INSERT INTO ahr_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तुम्ही आपलामागे आपला पोर्‍यासले त्यासना ताबा देवानं, अनी ती त्याना वतनभाग व्हयी; त्या माणसासमाईन तुम्हले कायमनं दास करता येई, पण तुम्हना इस्राएल भाऊबंदसनी तिकडलातिकडे आपला अधिकार कठोरतीन चालाडानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","तुना गावामा राहेल परदेशी नाहिते उपरी धनवान व्हयेल शे अनी त्यानाजोडे राहेल तुना एकादा भाऊ कंगाल व्हयीसनी त्यानी स्वताले त्या परदेशीसले नाहिते उपरी माणसुले नाहिते त्यासना वंशमासला कोणले ईक व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","तर‍ त्यानी ईक्री व्हावानंतर त्याले सोडावता येई, त्याना भाऊबंदसमाईन कोणलेबी त्याले सोडावता येई. ");
INSERT INTO ahr_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","आपला चुलता, आपला चुलत भाऊ नाहिते आपला कूळमाईन कोणी जोडेना नातेवाईक यासले त्याले सोडावता येई नाहिते तो स्वतः धनवान व्हयेल शे तर त्याले आपली सुटका करता येई. ");
INSERT INTO ahr_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ज्यानी त्याले ईकत लिधं व्हयी त्यानाजोडे त्यानी आपली विक्रीना वरिशपाईन ते योबेल वरिशपावोत हिशोब करानं; वरिशना आकडापरमानं विक्रीना दाम ठरावानं; मजुरना रोजपरमानं दाम लेता येवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","योबेल वरिशले बराच वरिश राहातीन, तर जेवढी रकमले त्यानी विक्री व्हयेल शे, त्यासमाईन आपला भागना दाम, त्या वरीशना आकडापरमानं त्याले परत देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","योबेलले थोडा वरिश व्हतीन तरिबी त्यानी आपला मालकना हिशोब करिसनी आपला भागना दाम तेवढा वरिशना त्याले परत देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","त्यानी आपला मालकनासंगे सालदारपरमानं राहावानं, त्याना मालकनी तुनामोरे त्यानावर कठोरतीन अधिकार चालाडानं नही. ");
INSERT INTO ahr_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","हाई परकारं त्यानी सुटका नही व्हयनी तर योबेल वरिश तो आपला पोर्‍यासोर्‍यासंगे सटी जावानं. ");
INSERT INTO ahr_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","कारण इस्राएल लोक मना दास शेतस, मिसर देशमाईन काढेल हया मना दास शेतस, मी परमेश्वर तुमना देव शे; ");
INSERT INTO ahr_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","तुम्ही तुम्हना करता मुर्ती करानं नही, त्याचपरमानं कोरीव मुर्ती तशेच दगडना खांब उभा करानं नही नाहिते आकृती कोरेल दगड, पुजाकराकरता आपला देशमा स्थापन करानं नही. मी परमेश्वर तुम्हना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","तुम्ही मना शब्बाथ पाळानं अनी मना पवित्रस्थानना बारामा पुज्यबुध्दी ठेवानी; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","तुम्ही मना विधीपरमानं चालानं अनी मन्या आज्ञा पाळीसनी त्यापरमानं वर्तन करानं. ");
INSERT INTO ahr_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","तर योग्य येळले तुम्हना करता मी पाऊस पाडसु, जमीन आपला पीक देई अनी मळामासाला झाडं आपआपला फळ देतीन. ");
INSERT INTO ahr_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","द्राक्षना हंगामपावोत तुम्ही धान्यनी मळणी करत राहाशात अनी पैरनीना येळपावोत द्राक्षसना खुडनी करत राहाशात; तुम्ही मनसोक्त अन्न खाशात अनी आपला देशमा निर्भय वस्ती करशात. ");
INSERT INTO ahr_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","मी तुम्हना देशले शांती दिसु; अनी तुम्ही झोपशात तवय तुम्हले कोणपाईन भिती वाटाऊ नही; मी देशमासाल दुष्ट पशुनम नाश करी टाकसू अनी तुम्हना देशवर तलवार चालाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","तुम्ही आपला शत्रूले पळाडी लावशात; अनी तुम्हनादेखत त्या तलावरघाई मरतीन. ");
INSERT INTO ahr_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तुम्हनामाईन पाच जण शंभर जणसले, शंभर जण दहा हजारसले पळाडी लावतीन अनी तुम्हना शत्रु तुम्हनादेखत तलवारघाई मरतीन. ");
INSERT INTO ahr_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","मी तुम्हनावर‍ दया करीसनी तुम्हले फलद्रूप अनी बहुगूणित करसू अनी तुम्ही करेल मना करार पुरा करसु. ");
INSERT INTO ahr_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","तुम्ही बराच दिवस संगाळी ठेयेल धान्य खाशात; अनी नवीन धान्य येवानंतरबी जुना धान्य बाहेर काढशात. ");
INSERT INTO ahr_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","मी तुम्हनामां निवास करी राहासू; मना जीवले तुम्हले तिरस्कार करावं नही. ");
INSERT INTO ahr_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","तुम्हनासंगे मना येवजाव राही; मी तुम्हना देव वसु अनी तुम्ही मनी प्रजा वशात. ");
INSERT INTO ahr_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","मी परमेश्वर तुम्हना देव शे; तुम्ही मिसरासना दास राहावानं नही त्याकरता मी तुम्हले मिसर देशमाईन काढी आणेल शे; मी तुम्हना जोखडा मोडीसनी मी तुम्हले ताठ चालाडेल शे. ");
INSERT INTO ahr_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","यानावर तुम्ही मना आयकेल नही शे; हया बठया आज्ञा पाळेल नही शेतस; ");
INSERT INTO ahr_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","मना विधीसना नकार देयेल शे; तुमना जीवतीन मना निर्बंधसले तुच्छ मानेल शेतस अनी मन्या बठा आज्ञा अमान्य करीसनी मना करार मोडेल शे. ");
INSERT INTO ahr_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","तर मी तुम्हना काय करसू ते आयकी लेवानं; मी तुम्हले भिवाडसू, क्षयरोग अनी ज्वर यासघाई तुम्हले पीडा दिसू; त्यामुळे तुम्हना डोळा क्षीण व्हतीन अनी तुम्हना जीव दुखी व्हयी; तुम्ही वावरमा बियाणं पैरशात त्याबी व्यर्थ जातीन; कारण त्याना उत्पन्न तुम्हना शत्रु खाई टाकतीन. ");
INSERT INTO ahr_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","मी तुम्हले परका व्हयी जासू; तुम्हना शत्रुसनादेखत तुम्हना नाश व्हयी; तुम्हना वैरी तुम्हनावर अधिकार चालाडतीन अनी तुम्हनी मांगे कोणी नहीबी लागनं तरी पळशात. ");
INSERT INTO ahr_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","एवढं करीसनीबी तुम्ही मना आयकाउत नही तर पापनीकरता तुम्हले सातपट शिक्षा करसू. ");
INSERT INTO ahr_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","तुम्हना ताकदना गर्व भग्न करी टाकसू अनी तुम्हले आकाश लोखंडनागत अनी जमीन पितळनासारखा करसू. ");
INSERT INTO ahr_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","तुम्हना कष्ट व्यर्थ जातीन कारण तुम्हनी जमीन उपज देवाऊ नही अनी देशमा झाड फळ देवाउत नही. ");
INSERT INTO ahr_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","मनाइरोधमा तुम्ही चालशात अनी मना आयकाउत नही तर तुम्हना पापना सातपत तुम्हनावर संकत आनसू. ");
INSERT INTO ahr_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","मी तुम्हनावर वनपशू सोडसू, त्या तुम्हना पोर्‍यासले मारी टाकतीन, तुम्हना गुराढोरासले मारी टाकतीन, तुम्हनी संख्या कमी करी टाकतीन अनी त्यानीमुळे तुम्हना रस्ता वसाड पडतीन. ");
INSERT INTO ahr_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","एवढया गोष्टी करीसनीबी तुम्ही मनाकडे वळाऊत नही अनी मना विरुध्द चालनात ते, ");
INSERT INTO ahr_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","मी तुम्हना विरुध्द जासू अनी मीच तुम्हना पापनाकरता तुम्हले सातपट दंड करसू. ");
INSERT INTO ahr_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","तुम्हनावर तलवार चाली, ती करार मोडानं बदला लि, जवय तुम्ही आपला गावमा एकजागे वशात तवय तवय तुम्हनावर महामारी लयसू; मी तुम्हले तुमना शत्रुना हातमा दि टाकसू. ");
INSERT INTO ahr_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","मी तुम्हना जेवननं आधार तोडी टाकसू, तवय दहा बाया एकच भट्टीमा तुम्हनी भाकर्‍या भुजतीन अनी त्या तुम्हले मोजीसनी देतीन ज्यासघाई तुम्हनं पोट भराऊ नही. ");
INSERT INTO ahr_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","एवढा बठा करीसनी भी मना तुम्ही आयकाऊत नही, मनाविरुध्द चालशात ते, ");
INSERT INTO ahr_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","तुम्हना संताप करीसनी तुम्हना विरुध्द चालसू अनी तुम्हना पापनीकरता मी तुम्हले सातपत शिक्षा करसू. ");
INSERT INTO ahr_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","तवय तुम्हना पोर्‍या अनी पोरीसना मास तुम्हले खावानी येळ येई. ");
INSERT INTO ahr_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","तुम्हना पुजापाट करानं ठीकाणले मी पाडी टाकसू, तुम्हनी सुर्यमुर्तीले फोडी टाकसू अनी तुम्हन्या मुर्तीसन्या मढयासवर तुम्हनी मढी फेकी दिसु; मनी जीवले तुम्हनी कीळस भरी. ");
INSERT INTO ahr_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","मी तुम्हना गावसले वसाड करी टाकसू, तुम्हनी पवित्र ठीकाणले वसाड करी टाकसू, तुम्हनी सुगंधी वस्तुसना सुवास मी लेवाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","मी तुम्हना देशनी नासाडी करी टाकसू; देशमा राहानारा तुमना शत्रु हई दखीसनी चकीत व्हयी जातीन. ");
INSERT INTO ahr_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","परराष्ट्रमा तुम्हनी पांगापांग करी टाकसू, मी तलवार काढीसनी तुम्हनी मागे लागसू, तुम्हना देशना नाश व्हयी अनी तुम्हना गाव ओसाड पडतीन. ");
INSERT INTO ahr_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","जेवढा दिवस हाई देश वसाड पडी, तुम्ही आपला शत्रुना देशमा राशात तेवढा दिवस देश शब्बाथ भोगी; तवय हाई देशले विश्राम मिळी अनी तो आपला शब्बाथ भोगत राही. ");
INSERT INTO ahr_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","देश वसाड पडस तोपावोत त्याले विश्राम मिळी; जवय तुम्ही तठे राहत व्हतात तुमना शब्बाथनं भेटनं नही आशे विश्राम त्याले भेटी. ");
INSERT INTO ahr_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","तुम्हनामाईन ज्या उरेल राहतीन त्यासना मनमा आशी भीती घालसू की त्या झाडनं पानबी वाजनं तरी पळी जातीन; जशी तलवार लिसनी कोणी मांगे लागस तशे त्या पळतीन; कोणी मांगे लागाऊ नही तरिबी त्या पळतीन. ");
INSERT INTO ahr_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","कोणी मांगे लागाऊ नही तरिबी‍ त्या येरायेरवर ठोकाईसनी त्या पडतीन; जशी काय तलवार त्याशनी मांगे लागेल शे; तुम्हना शत्रूसले लढा देवानी ताकद उराऊ नही. ");
INSERT INTO ahr_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तुम्ही राष्ट्रराष्ट्रसामाईन पांगापांगा व्हयीसनी नाश पावशात; तुम्हना शत्रुना देश तुम्हले खाई टाकी. ");
INSERT INTO ahr_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","तुम्हनामाईन ज्या उरेल शेतस त्या आपला शत्रूना देशमा आपला दुष्टतामुळे क्षीण व्हतीन, अनी त्या आपल्या वाडवडीलसना दुष्टतामुळे त्यासना सारखाच क्षीण व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","त्यासनी मनासंगे विश्वासघात करं, हाई त्यासना अनी त्यासना वाडवडीलसना दुष्टता शे. आशे त्या कबूल करतीन; त्या परमानं त्या मनाविरुध्द चालतीन. ");
INSERT INTO ahr_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","हाई कारणतीन मिबी त्यासना विरुध्द व्हयीसनी त्यासले शत्रुना देशमा आणेल शे आशे त्या कबूल करतीन; अनी त्यासना बेसुनत ह्दय नम्र व्हयीसनी त्या आपला दुष्टताना दंड मान्य करतीन ते. ");
INSERT INTO ahr_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","जे करार याकोबनीसंगे करं त्यानी मी आठवण करसू; त्यापरमानं इसहाक अनी अब्राहाम यासनासंगे मना व्हयेल करारनी आठवण करसू अनी तो देशनीबी आठवण करसू. ");
INSERT INTO ahr_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","देश माईन त्यासना नायनाट व्हयी अनी जोपावोत तो त्यासनशिवाय वसाड राही तोपावोत तो शब्बाथ भोगत राही: त्यासनी मना निर्बंधसना अव्हेर करं अनी मना विधी तुच्छ मानं म्हणून त्यासना दुष्टतानाबद्दल करेल दंड त्या मान्य करतीन. ");
INSERT INTO ahr_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","एवढं व्हयीसनीबी त्या आपला शत्रुना देशमा व्हतात त्यासना मुयासकट नाश करानं अनी त्यासना करार मोडी टाकानं एवढा त्यासना अव्हेर कराऊ नही नाहिते त्यासना मी राग कराऊ नही; कारण मी परमेश्वर त्यासना देव शे. ");
INSERT INTO ahr_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","मी त्यासनाकरता त्यासना वाडवडीलसनासंगे करेल करारनी आठवण करसू, मी त्यासना देव व्हवाले पाहिजे म्हणुन मी बठा राष्ट्रासनादेखत त्यासले मिसर देशमाईन आणेल शे; मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","जे विधी, निर्वंध अनी नियम परमेश्वरनी आपला अनी इस्राएल लोकेसमा सीनाय पर्वतनाजोडे मोशेनी हातघाई जे ठरायेल शे ते हाईच शे. ");
INSERT INTO ahr_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","परमेश्वर मोशेले बोलना, ");
INSERT INTO ahr_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","इस्राएल लोकेसले सांग; एकादा माणुसनी विशेष नवस करं तर‍ त्या माणुसनं मोल तु ठरावानं तवय ते परमेश्वरले मान्य व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","तो वीस वरीसपाईन साठ वरिशना आगोदरना माणुस व्हयी तर पवित्रस्थानमासला चलन परमानं त्याना मोल पन्नास शेकेल राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ती बाई व्हयीते तिना मोल तीस शेकेल एवढा राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","पोर्‍या पाच वरीसतीन मोठा व्हयी अनी वीस वरीसतीन दाखला व्हयी तर‍ त्याना मोल वीस शेकेल अनी पोरना दहा शेकेल एवढा राहावले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","अनी पोर्‍या एक महीनातीन मोठा अनी पाच वरीसतीन दाखला व्हयीते त्याना मोल पाच शेकेल अनी पोर व्हयीते तीन शेकेल राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","माणुस साठ वरीसतीन जास्त वयना व्हयीते त्याना मोल पंधरा शेकेल अनी बाई व्हयीते दहा शेकेल राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","एकादा एवढा कंगाल व्हयी की तु ठरायेल दाम त्याले देता नही व्हनं तर त्यानी याजकनामोरे उभं राहावानं अनी याजकनी त्याना दाम ठरावानं; नवस करानी शक्ती व्हयी त्यापरमानं याजकनी मोल ठरावानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","लोक परमेश्वरले जे पशू अर्पण करत व्हतात त्यासनामाईन एकादा पशुनं नवस करं तर परमेश्वरले अर्पण करानं ते पवित्र समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","त्यानी ते आजिबात बदलानं नही, म्हणजे वाईटना बद्दल बरा नाहिते बरानीबद्दल वाईट आशे बद्दल त्यानी करानं नही, त्यानी एक पशुबद्दल दुसरा दिद् तो अनी त्यानाबद्दल देयेल हाई दोन्ही पवित्र समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","लोके परमेश्वरले अर्पण करतस नही आशे अशुध्द पशुमाईन तो व्हयी तर त्यानी याजकनीमोरे उभा राहावानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ते पशु चांगले शे का वाईत शे ते दखीसनी त्याना मोल याजकनी ठरावानं; तु ठरावशी तेवढा त्यानं मोल समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","नवस करनारा काही मोल देईसनी तो सोडाई तर याजकनी ठरायेल मोलमा आजुन एक पंचमांश भर घालीसनी ते त्यानी देवानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","कोणी आपला घर पवित्र करीसनी परमेश्वरले वाहेल व्हयी तर याजकनी त्या घरनं चांगला शे का वाईट ते दखीसनी त्याना मोल ठरावानं; याजक ठराई तेवढ त्यानं मोल समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","घर पवित्र करीसनी वाहणारा मोल देईसनी ते सोडाईसनी दखी तर ठरायेल मोलमा एक पंचमांश भर घालीसनी त्यानी ते देवानं म्हणजे घर त्यानं व्हयी जाई. ");
INSERT INTO ahr_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","आपला वतनना जमीनना काही भाग जर कोणी पवित्र करिसनी पवित्र करीसनी परमेश्वरले वाही, तर त्यामा बियाणं पडी त्या मानतीन तु त्यानं मोल ठरावानं; एक होमभरीसनी जवनी पैरनी त्यामा व्हत व्हयी तर त्या वावरना मोल पन्नास शेकेल ठरावानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","योबेल वरिश ते पवित्र ठेवं तरिबी तु ठरावशी त्या परमानं त्याना मोल व्हवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","योबेल व्हावानंतर जर कोणी आपला वावर पवित्र करिसनी दखी तर दुसरा योबेल वरिशले जेवढा वरिश व्हतीन त्या मानतीन याजकनी त्याना पैसा ठरावानं; तुना अंदाजतीन तेवढा पैसा कमी करानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","वावर पवित्र करी ठेवनारा आपला वावर सोडाई दखी तर तु ठरायेल मोलमा आजुन एक पंचमांश भर घालीसनी त्यानी ते देवानं म्हणजे वावर त्यानं ठरी. ");
INSERT INTO ahr_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","त्यानी ते वावर सोडायेल नही व्हयी नाहिते दुसराले ईकेल व्हयीते मंग ते यानापुढे सोडाई लेता येवाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","योबेल वरीससले ते वावर सुटी तवय बठा समर्पण करेल वावरपरमानं परमेश्वरकरता ते पवित्र ठरी म्हणजे ते याजकनं वतन व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","दुसरासडतीन ईकत लेयेल अनी स्वताना वतनमासला नही व्हयी आशे वावर कोणी परमेश्वरकरता पवित्र करानं वाटत व्हयी. ");
INSERT INTO ahr_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","तर याजकनी योबेल वरिशपावोत त्यानं हिशोब करी अनी जेवढ मोल तू ठरावशी तेवढ परमेश्वरकरता पवित्र समजीसनी त्याच रोजले त्यानी दि टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ज्यानापाईन ते पहिलापाईन ईकत लेयेल शेतस, म्हणजे ज्याना वतनमाईन ते शे त्याना ताबामा ते योबेल वरिश परत जावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ज्याना मोल तु ठरावशी त्या पवित्र स्थानमासला चलनपरमानं ठरावानं; शेकेल म्हणजे वीस गेरा. ");
INSERT INTO ahr_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","ग्राम पशुसमाईन प्रथम वत्स परमेश्वरनं ठरेल शे; त्याले कोणी पवित्र करीसनी वाहावानं नही; ते गुराढोरासमासला राहो का शेरडामेंढरासमासला राहो, त्या परमेश्वरनाच शेतस. ");
INSERT INTO ahr_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","तो वत्स अशुध्द पशूना व्हयी तर त्यानी तु ठरावंपरमानं जे मोल व्हयी त्यामा एक पंचमांश भर घालीसनी पाहिजे तर ते सोडावानं; पण ते सोडावानं नही व्हयी तर ठरायेल किंमतले ते ईकी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","तरीभी ज्यानी आपला बठा जे काही व्हयी ते परमेश्वरले वाहेल शे, पशू असो नही ते माणुस राहो का त्याना वतनमासला वावर राहो, ते ईकानं नही नाहिते सोडावानं नही; ज्या काही वाहेल शेत त्या परमेश्वरकरता अतीपवित्र समजानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","एकादा माणुसले वाहेल व्हयी तर‍ त्याले सोडवता लेता येवाऊ नही त्याले मारी टाकानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","जमीनना उत्पन्नना दशमांस परमेश्वरना शे, मंग ते जमीनंन धान्य राहो का झाडनं फळ राहो; ते परमेश्वरकरता पवित्र शे. ");
INSERT INTO ahr_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","आपला देयेल दशमांसमाईन काही त्याले दाम देईसनी सोडावानी ईच्छा व्हयी त्यामा त्यानी एक पंचमांशनी भर घालीसनी ते सोडावानं. ");
INSERT INTO ahr_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","गुरेढोर नाहिते शेरडामेंढरा यासमाईन ज्यासनी गणना काठीखालतीन चालत व्हती आशे परतेक दहासमाईन एकएक पशू परमेश्वरकरता पवित्र राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","कोणी त्याना गुणगान दखानं नही नाहिते त्याले बदलानं नही; कोणी त्याले बदली तर तो पशू अनी त्याना बदला हया दोन्ही पवित्र समजानं; ए खंड देईसनी ते सोडावत येवाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ज्या आज्ञा परमेश्वरनी इस्राएल लोकेसकरता सीनाय पर्वतनाजोडे मोशेले देयेल त्या हयाच शेतस.");
INSERT INTO ahr_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","परमेश्वरना सेवक मोशे हाऊ मरानंतर परमेश्वरनी मोशेले मदत करनारा नुनाना पोर्‍या, यहोशवा याले सांग की ");
INSERT INTO ahr_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","मना सेवक मोशे मरी जायेल शे; तर ऊठ, इस्त्राएल लोकेसले जो देश दी राहीनू शे, तठे या लोकेसना संगे यार्देन नदी उतरीसन जाय. ");
INSERT INTO ahr_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","मी मोशेले सांग व्हतं त्याप्रमाणे ज्या ज्या ठिकानले तुमनं पाय पडी ते ते ठिकानले मी तुमले देयेल शे. ");
INSERT INTO ahr_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","रान अनी हाऊ लबानोन पर्वत, महानदी फरात आठेपावोत हित्ती लोकसना बठा देश मावळतीकडतीन ते महासमुद्रपावतना मुलूख तुमना व्हयी. ");
INSERT INTO ahr_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","तुनी हयातीमां तुनामोरे कोणाच टिकाऊ लागाऊ नही; जस मोशेना संगे मी राहीनू तसच तुनासंगे मी राहसू, मी तुले सोडावू नही, तुले टाकावू नही. ");
INSERT INTO ahr_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","खंबीर व्हय; हिंमत धर; कारण जो देश देवाबद्दल या लोकसनी वाडवडीलसले मी आणभाक करेल शे, तो तु यासले वतन करी देशी. ");
INSERT INTO ahr_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","पण खंबीर व्हय अनी हिंमत धर अनी मना सेवक मोशे यानी तुले देयेल सर्व नियमशास्त्र मान्य करीसनं पाळ; ते सोडीसनं उजवीडवीकडे जावानं नही; म्हणजे तु जाशी तिकडे तुले यश मिळी; ");
INSERT INTO ahr_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","नियमशास्त्रना हाऊ ग्रंथ तुना मुखमाईन ढळाले नको; त्यामा जे काही लिखेल शे ते तु मान्य करीसनं पाळानं; त्याकरता रातदिन तु त्यानं मनन करानं; म्हणजे तुना मार्ग सुखमां व्हयीसनं तुले यश मिळी. ");
INSERT INTO ahr_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","मी तुले आज्ञा करी व्हती ना? खंबीर व्हय, हिंमत धर, भ्यावानं नही, घाबरानं नही; तु जाशी तिकडे तुना देश परमेश्वर तुनासंगे राही. ");
INSERT INTO ahr_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","मंग यहोशवानी लोकेसना पूढारीसरसले आशी आज्ञा करी की, ");
INSERT INTO ahr_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","छावनीना चारीमेरले फिरीसनं लोकेसले अशा हुकूम कराना की, “आपला जेवणनी सामग्री तयार करानी; कारण तुमना देव यहोवा जो देश तुमले वतन करी राहीना शे, त्याना ताबा लेवाकरता तीन दिन पहिले हाई यार्देन नदी उतरीसनं तुमले जावानं शे. ");
INSERT INTO ahr_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","मंग यहोशवानी रऊबेनी, गादी अनी मनश्शना आर्धा वंश यासले सांग. ");
INSERT INTO ahr_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","परमेश्वरना सेवक मोशे यानी तुमले आज्ञा देयेल व्हती तिनी आठवण करा; त्यानी तुमले सांगं व्हतं की, तुमना देव यहोवा तुमले आराम दि राहीना शे अनी हाऊ देश तुमले देणार शे. ");
INSERT INTO ahr_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","तुमन्या बाया, पोरेसोरे अनी जनावरे यासनी या यार्देनना पुर्वले जो देश मोशेनी तुमले देयेल शे त्या देशमां राहावानं; पण तुम्हीन बठा योद्यासनी सशस्त्र व्हयीसनं आपला भाऊसनामोरे कुच करीसनं नदीना तिकडे जावानं अनी त्यासले मदत करानी. ");
INSERT INTO ahr_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","तुमले आराम देयेल शे तसा आराम, परमेश्वर तुमना भाऊसले दी अनी तुमना देव यहोवा यानी त्यासले देयल देशना त्या ताबा लेतीन, तवय परमेश्वरना सेवक मोशे यानी यार्देनना इकडे, उगवतीले जो देश तुमले देयेल शे त्या तुमना वतनना देशमां परत ईसनं त्याना ताबा तुम्हीन लेवाना.” ");
INSERT INTO ahr_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","तवय त्या बठा यहोशवाले बोलनात, “जे काही करानी तु आमले आज्ञा दी राहीना शे ते आम्हीन करसुत अनी तु आमले धाडशी तठे आम्हीन जासुत. ");
INSERT INTO ahr_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","जस आम्हीन सर्वाबाबतमां मोशेना ऐकी राहिंतु आम्हीन तुन बी ऐकसुत; पण तुना देव यहोवा मोशेनीसंगे व्हता तशेच तुनासंगे राहो. ");
INSERT INTO ahr_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","तुनी आज्ञानी विरोधमां जो कोनी जायी अनी तुन्या बठया आज्ञा वचनना अवमान करी त्याले मरणदंड देवानं; तु मात्र खंबीर व्हय, हिंमत धर.” ");
INSERT INTO ahr_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","नूनाना पोर्‍या यहोशवा यानी लपाडीन दोन हेर शिट्टीमा आठेतीन धाडं; त्यानी त्यासले सांग, “जा अनी तो देश अनी विशेषतः यरीहो हाई दखी या.” त्या गयात अनी रहाब नावनी वेशाना घरमा उतरनात. ");
INSERT INTO ahr_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","मंग कोणीतरी यरीहोना राजाले सांग की आज रातले काही इस्त्राएल लोक आमना देशमा भेद काढाले आठे येल शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","तवय यरीहोना राजानी रहाबले सांगीसन धाडं की ज्या माणसे तुनाकडे ईसन तुनी घर उतरेल शेतस त्यासले बाहेर काढ; कारण बठा देशना भेद काढाले त्या येयल शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","“त्या दोनी माणससले लपाडीसन ती बाई बोलनी, मनाकडे ज्या कोणीतरी माणसे येल व्हतात हाई खरं शे, पण त्या कथाना शेतस हाई माले माहीत नही. ");
INSERT INTO ahr_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","आंधार पडावर वेस लाईसन लेवाना येळले त्या निंघी गयात; त्या कोठे गयात ते माले माहीत नही; तुम्हीन लवकर त्यासना पिछा करा म्हणजे त्यासले सापडावशात.” ");
INSERT INTO ahr_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","पण तिनी‍ त्या माणससले धाबावर लिसनं तठे जवसना ताटे पसारेल व्हतात त्यामा दपाडी ठेयेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","त्या माणसे त्यासना शोध करत यार्देनना वाट वरतीन उतारपावोत गयात; त्यासना पिछा करनारा गावना बाहेर जातस वेस बंद करामा ऊनी. ");
INSERT INTO ahr_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","इकडे त्या हेर झोपाना पहिले ती बाई त्यासनाकडे धाबावर गयी. ");
INSERT INTO ahr_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","अनी त्यासले बोलनी “परमेश्वरनी हाऊ देश तुमले देयेल शे; आमना देश मधला सर्वा रहिवाशी तुमना भीतीतीन गाळण उडेल शे, हाई माले माहीत शे; ");
INSERT INTO ahr_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","कारण तुम्हीन मिसर देशमाईन निंघनात तवय तुमनासमोर परमेश्वरनी तांबडा समुद्रनं पाणी आटाडं अनी यार्देनना तिकडे राहणारा अमोर्‍यासना दोन राजा सीहोन अनं ओग यासना तुम्हीन संहार करा हाई आमना कानवर येल शे. ");
INSERT INTO ahr_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","हाय ऐकीसन आमना मनन पाणी पाणी व्हयनं, तुमनामुये कोणाच जीवमां जीव राहीना नही; कारण तुमना देव यहोवा हाऊ वर आकाशमां अनी खाल पृथ्वीवर देव शे. ");
INSERT INTO ahr_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","मी तुमनावर दया करेल शे, याकरता आते मनासंगे परमेश्वरनी नावतीन आणभाक करानं की आम्हीन तुमना बापना घरानावर दया करसू; अनी याकरता माले खात्रीलायक खूण दे; ");
INSERT INTO ahr_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","अनी आम्हीन तुना मायबाप, भाऊबहीन अनी तुमना बठासना बचाव करसू अनी तुमना बठासना जीव मृत्युपाईन वाचाडसूत आशी मनासंगे आणभाक करानं!” ");
INSERT INTO ahr_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","तवय त्या माणससनी तिले सांग, “तुम्हीन कोणी बी आपली गोष्ट फोडी नही तर तुमना जीवकरता आम्हीन आमना जीव दिसुत; अनी परमेश्वर आमले हाई दी तवय आम्हीन तुनासंगे दयातीन अनी खरा मनतीन वागसुत.” ");
INSERT INTO ahr_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","तवय राहाबनी त्यासले खिडकीमाईन दोरघाई गावनाबाहेर उतारं; कारण तिनं घर गावकुसनी भितले लागीसनं व्हतं; तठे ती राहे. ");
INSERT INTO ahr_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","तिनी त्यासले सांग की, “तुमना पाठलाग करनारासनी तुमले गाठाले नही पाहीजे म्हणीसनं त्या डोंगरपान तठे तीन दिन दपी बठा; तेवढा येळमां तुमना पाठलाग करनारा परत येतीन; मंग तुम्हीन जावानं.” ");
INSERT INTO ahr_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","त्या माणसे तिले बोलनात; “तु आमनाकडतीन जी आणभाक करेल शे तिना बारामां आमले दोष नही लागाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","दख, आम्हीन हाऊ देशमां इसुत तवय जी खिडकीमाईन तु आमले उतारं तिले हाऊ लाल धागा बांध; अनी तुना हाई घरमां आपला मायबाप, भाऊबंद अनी आपला पितृकुळमाधला बाकीना बठासले एकजागे कर. ");
INSERT INTO ahr_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","त्या येळले कोनी तुना घरना दारनाबाहेर रस्तावर गया ते त्याना रक्तपातना दोष त्याना माथे राही; आमनाकडे त्याना दोष येवाऊ नही; घरमां तुनासंगे ज्या राहातीन त्यासनावर कोणा हात पडना तर त्यासना रक्तपातना दोष त्यासना माथाले. ");
INSERT INTO ahr_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","जर का हाई गोष्ट तु कोठे बाहेर फोडी तर आमनासंगे जी आणभाक तु करेल शे, तीमातीन आम्हीन मुक्त व्हई जासुत.” ");
INSERT INTO ahr_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","ती बोलनी, “तुम्हीन सांगेल प्रमाणेच व्हई; तिनी त्यासले निरोप देवानंतर त्या मार्गस्थ व्हयनात; नंतर तिनी लाल रंगना धागा आपली खिडकीले बांधा.” ");
INSERT INTO ahr_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","त्या जाईसनं डोंगरवर वनात; अनी त्यासना पाठलाग करनारा परत जातसं तोपावोत तठे तीन दिन राहीनात; त्यासना पाठलाग करनारासनी, वाटमां चारीमेर शोध करा; पण त्या त्यासले सापडनात नही. ");
INSERT INTO ahr_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","मंग त्या दोनी माणसे डोंगर उतरीसनं नुनाना पोर्‍या यहोशवा यानाकडे परत गयात अनी आपलं बठं वर्तमान त्यासनी त्याले सांग. ");
INSERT INTO ahr_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","त्या यहोशवाले बोलनात, हाऊ बठा देश परमेश्वरनी आपला हातमां खरच देयल शे; अनी हावु देशना बठा रहीवासी आपलामुये घाबरी जायेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","यहोशवा पहाटले ऊठना अनी बठा इस्त्राएलसले शिट्टीमाईन कुच करीसनं यार्देननी काठले ऊना; ती उतरीसनं जावाना पहिले तठे त्यानी मुक्काम करा. ");
INSERT INTO ahr_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","तीन दिन नंतर पूढारीसनी छावनीमां फिरीसनं ");
INSERT INTO ahr_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","लोकसले अशी आज्ञा करी की, “तुमना देव यहोवा याना करारना कोश लेवी याजक उचलीसनं लयी जातांना दखशात तवय तळ हालाईसनं त्यानामांगे जावा; ");
INSERT INTO ahr_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","पण कोशमां अनी तुमनामां जवयपास दोन हजार हात मोजीसनं आतर ठेवानं; त्याना जास्त जवय जावानं नही, म्हणजे जी वाटतीन तुमले जावानं शे ती तुमले दखायी; कारण आजुनपावोत हाई वाटघाई तुम्हीन कवयच जायेल नही शे. ");
INSERT INTO ahr_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","मंग यहोशवानी लोकेसले सांग की शुध्द व्हा, कारण सकाय परमेश्वर तुमनामां अद्भुत कृत्य करणार शे. ");
INSERT INTO ahr_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","मंग यहोशवानी याजकसले सांग की करारनं कोश उचलीसनं लिसन लोकेसनीमोरे चाला त्याप्रमाणे त्या तो लिसन लोकेसनामोरे चालनात. ");
INSERT INTO ahr_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","परमेश्वर यहोशवाले बोलना, आज मी बठा इस्त्राएल लोकेसनासमोर तुनी थोरवी वाढावानी सुरुवात करस; म्हणजे मी जशे मोशेनीसंगे व्हतु तशे तुनासंगेबी शे हाई तुले कळी. ");
INSERT INTO ahr_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","करारना कोश वाहनारा याजक यासले आशी आज्ञा करी की जवय तुम्हीन यार्देनना पाणीना काठले जाशात तवय यार्देनमां उभं ऱ्हावानं.” ");
INSERT INTO ahr_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","मंग यहोशवानी इस्त्राएल लोकेसले सांग, जोडे ईसनं परमेश्वर तुमना देव यानं म्हणनं ऐका. ");
INSERT INTO ahr_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","यहोशवा बोलना, जिवत देव तुमनामां शे, अनी कनान, हित्ती, हिव्वी, परिज्जी, गिर्गाशी, अमोरी अनी यबुसी यासले तो तुमनासमोर हाकली दी हाई यानावरतीन समजमा ई. ");
INSERT INTO ahr_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","बठी पृथ्वीना जो प्रभु त्याना करारना कोश तुमनासमोर यार्देनमां परवेश करी राहीना शे. ");
INSERT INTO ahr_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","तर आते इस्त्राएल वंशमाईन बारा माणसे निवाडानं, परतेक वंशमाईन एक एक. ");
INSERT INTO ahr_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","बठी पृथ्वीना जो प्रभु परमेश्वर याना करारना कोश वाहनारा याजकना पाय यार्देनना पाणीले लागताच वरतीन वाहत येनारा यार्देनना पाणी थांबी जमी अनी त्यानी रास व्हयी. ");
INSERT INTO ahr_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","बठा माणसे यार्देननातिकडे जावाकरता आपला डेरामाईन निघनात तवय करारना कोश वाहनारा याजक लोकेसनामोरे चालनात. ");
INSERT INTO ahr_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","करारना कोश वाहनारा यार्देनपान यिसनं पोहचनात अनी त्यासना पाय काठना पाणीमां बुडनात (सुगीना दिवसमां यार्देन नदी दुथडी वाहास राहास) ");
INSERT INTO ahr_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","तवय जे पाणी वरतीन वाहीसनं येत व्हतं ते बराच अंतरवार म्हणजे सारतान नगरजोडे आदाम नगरपान एकजागे व्हयीसनं चढनात अनी त्यासनी रास व्हयनी, अनी जे पाणी अरबना समुद्रमां म्हणजे क्षार समुद्र यानाकडे वाहात जात व्हतं ते सरकनं; अनी त्या बठा लोक यरीहोनामोरे उतरीसनं पार गयात. ");
INSERT INTO ahr_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","परमेश्वरना करारना कोश वाहनारा याजक यार्देनना मजारमां कोयडी जमीनवार उभा राहीनात; अनी बठा इस्त्राएल लोक कोयडी जमीनवरतीन निघी गयात; हाई परकारं झाडीसनं बठा राष्ट्र यार्देनना तिकडे निघी गयात. ");
INSERT INTO ahr_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","त्या राष्ट्रमाधला झाडीसनं बठा माणसे यार्देनना तिकडे गयात तवय परमेश्वरानी यहोशवाले सांगं. ");
INSERT INTO ahr_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“लोकसमाईन वंशनामांगे एक असा बारा माणसे निवाड, ");
INSERT INTO ahr_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","अनी त्यासले अशी आज्ञा दे; यार्देनना मजारमां म्हणजे याजकसना पाय जठे स्थिर व्हयेल व्हतीन तठेतीन बारा दगड उचलीसनं आपलासोबत पलीकडे लयी जाय अनी आज रातले ज्या ठिकाणले तुमना मुक्काम व्हयी तठे ते ठेव.” ");
INSERT INTO ahr_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","मंग यहोशवानी इस्त्राएल लोकेसमाधला वंशमांगे एक असा ज्या बारा माणसे तयार करा व्हतात त्यासले बलावं. ");
INSERT INTO ahr_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","यहोशवा त्यासले बोलना, “तुम्हीन आमला देव यहोवा याना करारना कोशना समोर यार्देनना मजारमां जाईसनं इस्त्राएल वंशना संख्याप्रमाणे एक एक दगड उचलीसनं आपला खांदावर ल्या. ");
INSERT INTO ahr_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","हाई तुमनामां चिन्हदाखल व्हयी, अनी पुढे तुमना पोरेसोरे ईचारतीन की हाई दगडीसनं प्रयोजन काय? ");
INSERT INTO ahr_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","तवय तुम्हीन त्यासले सांगानं की, यार्देननं पाणी परमेश्वरना करारना कोशना समोर दोन भागमा व्हयनं; तो कोश यार्देनमाईन जाई राहिंता तवय यार्देनना पाणीना दोन भाग व्हयनात; अशा प्रकारे या दगडी इस्त्राएल लोकेसले कायमनं स्मारक व्हयनात.” ");
INSERT INTO ahr_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","यहोशवानी हाई आज्ञाप्रमाणे इस्त्राएल लोकेसनी करं; परमेश्वरानी इस्त्राएल लोकेसले सांगं व्हतं त्याप्रमाणे त्यासनी इस्त्राएल वंशना संख्याप्रमाणे बारा दगड यार्देनना मजारमाईन उचलात अनी जठे त्यासनी मुक्काम करा तठे त्यासनी त्या आपलासंगे लयी जाईसन ठेवात; ");
INSERT INTO ahr_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","अनी यार्देनना मजारमां करारना कोश वाहनारा याजकना पाय जठे स्थिर व्हयेल व्हतात तठे यहोशवानी बारा दगडं उभा करात; त्या अजून तठेच शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","लोकेसले जे सांगानी आज्ञा परमेश्वरानी यहोशवाले करी व्हती ते बठं सरस तोपावोत करारना कोश वाहनारा याजक यार्देनना मधला भागमां उभा राहीनात; इकडे माणसे लवकर पार उतरीसनं गयात. ");
INSERT INTO ahr_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","झाडीसनं बठा माणसे उतरीसनं जावानंतर त्‍यासनादेखत परमेश्वरना कोश अनी याजक पलीकडे गयात. ");
INSERT INTO ahr_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","रऊबेनी, गादी अनी मनश्शना आर्धा वंश हाई मोशेनी आज्ञाप्रमाणे सशस्र व्हयीसनं इस्त्राएल लोकेसनामोरे उतरीसनं पलीकडे गयात; ");
INSERT INTO ahr_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","युध्दकरता तयार व्हयेल जवयपास चाळीस हजार माणसे परमेश्वरनामोरे नदी उतरीसनं यरीहोनाजोडे मैदानवर गयात. ");
INSERT INTO ahr_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","त्या दिन परमेश्वरनी बठा इस्त्राएलदेखत यहोशवानी थोरवी वाढायी; म्हणीसनं जस त्या मोशेना भय धरेत तस यहोशवानं भय त्यासनी बठी हयातीमां धरं. ");
INSERT INTO ahr_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","परमेश्वरनी यहोशवाले सांगं; ");
INSERT INTO ahr_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","आज्ञापटना कोश वाहानारा याजक यासले आज्ञा दे की, त्यासनी यार्देनमाईन वर येवानं. ");
INSERT INTO ahr_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","त्याप्रमाणे यहोशवानी याजकसले आज्ञा करी की यार्देनमाईन निघीसनं वर यावं. ");
INSERT INTO ahr_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","परमेश्वरना कोश वाहानारा याजक यार्देनना मधला भागमाईन निघीसनं वर वनात अनी‍ त्यासनी आपला पाय उचलीसनं कोयडी जमिनवर ठेवात तवय यार्देननं पाणी मुळ ठिकानले वनं अनी पहीलेना मायक दोनी थडी भरीसनं वाहावाले लागनं; ");
INSERT INTO ahr_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","पहिल्या महिनानं दशमीले इस्त्राएल लोकेसनी यार्देनमाईन निघीसनं यरीहोनना पुर्व दिशानी सीमाले गिलगाल आठे डेरा दिदा. ");
INSERT INTO ahr_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","ज्या बारा दगड यार्देनमाईन उचलीसनं आनेल व्हतात त्या यहोशवानी गिलगाल आठे उभं करं; ");
INSERT INTO ahr_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","तो इस्त्राएल लोकेसले बोलना की, “पुढे तुमना पोरेसोरे ज्याना त्याना वडीलसले ईचारतीन, हाई दगडसना प्रयोजन काय? ");
INSERT INTO ahr_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","तवय तुम्हीन त्यासले सांगानं की, इस्त्राएल लोक हया यार्देनमाईन कोयडया जमीनवर चालीसनं पार वनात. ");
INSERT INTO ahr_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","कारण तुमना देव यहोवा यानी आम्हीन उतरीसनं पार जातसं तोपावोत आमनामोरेतीन तांबडा समुद्र हटाडीसनं कोयडी जमीन करी; ");
INSERT INTO ahr_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","यावरतीन पृथ्वीमाधला बठा देशना माणसेसले कळी की, परमेश्वरना हात समर्थ शे; अनी तुमना देव यहोवा याना धाक त्यासले कायम वाटी.” ");
INSERT INTO ahr_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","परमेश्वरनी यार्देननं पाणी आटाडं अनी इस्त्राएल लोकं त्याना पलिकडे कशा गयात हाई यार्देनना पश्चिमले राहाणारा अमोर्‍यासना बठा राजासनी ऐकं, तवय त्यासना धाकमां त्यासना पाणी पाणी व्हयनं अनी त्यासमां काय हिंमत राहीनी नही. ");
INSERT INTO ahr_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","त्या येळले परमेश्वरनी यहोशवाले सांगं, गारगोटयासना सुर्‍या बनाडीसनं परत इस्त्राएल लोकेसनी सुंता कर. ");
INSERT INTO ahr_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","त्याप्रमाणे यहोशवानी गारगोटयासन्या सुर्‍या बनाडीसनं सुंता हाई नाव देयेल टेकडीपान इस्त्राएल लोकेसनी सुंता करी. ");
INSERT INTO ahr_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","यहोशवानी सुंता करी त्यानं कारण हाईच शे की युध्दले लायक असा मिसर देशमाईन निघेल बठा माणसे मिसरमाईन निघानंतर वाटमां रानमां मरी जायेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","ज्या माणसे मिसरमाईन निघनात त्या बठासनी सुंता व्हयेल व्हती, पण मिसरमाईन बाहेर निघानंतर रानमां ज्या माणसासना जन्म व्हयेल व्हता त्यासनी सुंता व्हयेल नव्हती. ");
INSERT INTO ahr_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","कारण इस्त्राएल लोक रानमां चाळीस वरीस फिरी राहिंतात, तेवढा येळमां बठा राष्ट्र म्हणजे युध्दले लायक असा माणसे मिसरमाईन निघेल व्हतात त्यासनी परमेश्वनी सांगेल ऐकं नही, त्यामुये त्यासना नाश व्हयेल व्हता; परमेश्वरनी त्यासले शपथ देईसनं सांग व्हतं की, जो देश मी तुमना पुर्वजसले आणभाक करीसनं देऊ करेल शे अनी जठे दुधमधन्या नद्या वाही राहीन्या शेतस तो मी तुमनी दृष्टीले पडू देवावू नही. ");
INSERT INTO ahr_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","त्यासना जागावर त्यासना ज्या पोर्‍या त्यासनी उत्पन्न कर व्हतं त्यासनी यहोशवानी सुंता करी; कारण वाटमां त्यासनी सुंता व्हयेल नव्हती म्हणीसनं त्या बेसुंत राहेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","त्या बठा राष्ट्रासनी सुंता व्हावानंतर त्या बरा व्हतात तोपावोत छावणीमां आप आपला ठिकानले राहीनात. ");
INSERT INTO ahr_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","मंग परमेश्वर यहोशवाले बोलना, मिसरी तुमनावर अत्याचार करी राहींतात तो आज मी तुमनापाईन दुर करेल शे, त्यावरतीन ती जागाले गिलगाल म्हणतंस. ");
INSERT INTO ahr_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","इस्त्राएल लोकेसनी गिलगालमा तळ देवानंतर यरीहोना जोडेना मैदानमां महिनाना चौदवा दिन संध्याकायले वल्हांडण सण करा. ");
INSERT INTO ahr_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","वल्हांडणना दुसरा रोज त्या देशमां उत्पन्न व्हयेल धान्यनी बेखमीर भाकर अनी हुरडा त्यासनी खादा. ");
INSERT INTO ahr_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","ज्या रोज त्यासनी त्या देशमाधला उपज खादा त्याच रोज मान्ना बंद व्हयना, तो परत इस्त्राएल लोकेसले भेटना नही; त्या वरीसले त्यासनी कनान देशमासलं पिक खादं. ");
INSERT INTO ahr_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","यहोशवा यरीहोनाजोडे व्हता वर दृष्टी करी तो कोणी माणसु हातमां उपसेल तलवार लिसनं मोरे उभा शे अस त्याले दखायनं; यहोशवानी जोडे जाईसनं त्यासले ईचारं, “तुम्हीन आमना पक्षना की आमना वैरीसना पक्षना?” ");
INSERT INTO ahr_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","तो बोलना, “नही,” “मी आठे परमेश्वरना सेनानायक या नातातीन येल शे;” तवय यहोशवानी त्याले साष्टांग नमस्कार करीसनं बोलना, “प्रभूनी आपला दासले काय आज्ञा देयेल शे?” ");
INSERT INTO ahr_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","परमेश्वरना सेनानायक यहोशवाले बोलना, “आपला पायमासा पायतण काढ; कारण ज्या भुमीवर तु उभा शे ती पवित्र शे.” यहोशवानी तस करं. ");
INSERT INTO ahr_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","इस्त्राएल लोकेसनी धाकतीन यरीहोन्या बठया वेशी मजबूत लाई लेयल व्हत्यात; कोणले बाहेर जाता येवाऊ नही अनी मजारमा येता येवाऊ नही; ");
INSERT INTO ahr_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","परमेश्वर यहोशवाले बोलना, “मी यरीहो शहर, त्याना राजा अनी त्याना पराक्रमी वीर तुना हातमां देयेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","तुम्हीन बठा योध्दा हाई नगरले एक येळ प्रदक्षिणा घालानं; अस सव रोज करत ऱ्हावानं. ");
INSERT INTO ahr_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","कोशनामोरे सात याजकसनी रणशिंगं लिसनं चालानं; सातवा रोजले तुम्हीन नगरले सात प्रदक्षिणा घालानं; अनी याजकनी रणशिंग फुकानं. ");
INSERT INTO ahr_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","रणशिंगं फुकतस तवय त्याना आवाज बराच काळ कानमां पडताच बठा लोकेसनी जयघोष करानं; म्हणजे नगरना तट जागावरच पडी अनी मंग बठासनी मोरे चालीसनं जावानं.” ");
INSERT INTO ahr_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","मंग नुनाना पोर्‍या यहोशवा यानी याजकसले बलायीसनं सांग; करारना कोश उचली ल्या अनी परमेश्वरना कोशनामोरे सात याजकसनी रणशिंगे लिसनं चालानं; ");
INSERT INTO ahr_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","त्यानी लोकेसले सांगं, “चला नगरले प्रदक्षिणा घाला, अनी हत्यार लिसनं लोकेसनी परमेश्वरना कोशनामोरे चालानं.” ");
INSERT INTO ahr_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","यहोशवानी लोकेसले अस सांगावर सात याजक परमेश्वरनामोरे रणशिंगे लिसनं फुकत चालनात परमेश्वरना करारना कोश त्यासना मांगेमांगे बी लिसन चाली राहिंतात. ");
INSERT INTO ahr_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","हत्यारबंद लोकं रणशिंग वाजाडनारा याजकसना मोरे चालेत, मांगेना माणसे मांगेमांगे चालेत अनी याजक रणशिंगा फुंकत चालनात. ");
INSERT INTO ahr_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","मंग यहोशवानी लोकेसले आशी आज्ञा करी की, मी तुमले सांगस तोपावोत जयघोष करानं नही; त्यासना कानवर आवाज जाऊ देवानं नही; तुम्हीन आपला तोंडवाटेतीन चकार शब्द काढानं नही; आज्ञा व्हताच जयघोष करा. ");
INSERT INTO ahr_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","हाई प्रकारे परमेश्वरनी करारना कोशनी नगरना आजुबाजूले एक येळ प्रदक्षिणा व्हयनी; मंग त्यासनी छावनीमां ईसनं मुक्काम करं. ");
INSERT INTO ahr_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","यहोशवा पहाटलेच ऊठना अनी याजकसनी परमेश्वरना कोश उचली लिदा. ");
INSERT INTO ahr_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","सात याजकसनी रणशिंगे लिसनं परमेश्वरना कोशनामोरे ती एकसारखी फुकत चालानात अनी हत्याबंद लोक त्यानामोरे चालनात; मांगेना माणसे परमेश्वरना कोशनामांगे चालनात अनी याजक रणशिंगं फुंकत चालनात. ");
INSERT INTO ahr_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","त्या दुसरा रोजले बी नगरले प्रदक्षिणा करीसनं छावनीमां परत ऊनात; अस त्यासनी सव रोज करं. ");
INSERT INTO ahr_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","मंग सातवा रोजले पहाटलेच ऊठीसनं त्यासनी असच प्रकारे सात प्रदक्षिणा त्या नगरले घालात; त्यारोज मात्र त्यासनी त्या नगरले सात प्रदक्षिणा घाल्यात. ");
INSERT INTO ahr_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","सातव्या येळले याजक रणशिंग फुकतस तवय यहोशवा लोकेसले बोलना, “जयघोष करा, कारण परमेश्वरनी हाई नगर तुमना हातमां देयेल शे; ");
INSERT INTO ahr_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","हाई नगर अनी यामां जे काही व्हई ते बठं परमेश्वरले अर्पण करानं; पण रहाब वेशाले अनी जो कोणी तिना घरमां व्हतीन त्यासले जीवत ठेवानं, कारण आपण धाडेल हेरसले तिनी दपाडी ठेवं व्हतं. ");
INSERT INTO ahr_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","पण तुम्हीन नाश व्हणारा वस्तुमातीन काहीच लेवानं नही, त्या नाश करावर त्यामासली तुम्हीन एखादी वस्तु लिशात ते इस्त्राएलना छावनीमां शाप आणीसनं संकट आणशात. ");
INSERT INTO ahr_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","अनी बठं सोनं, रुपे अनी पितळनं अनी लोखंडना भांडा परमेश्वरना अर्पण शेतस; त्या परमेश्वरना भांडारमां जावाले पाहिजे.” ");
INSERT INTO ahr_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","तवय लोकेसनी जयघोष करा अनी याजक रणशिंगा वाजाडत राहीनात; रणशिंगना शब्द ऐकावर लोकेसनी मोठा जयघोष करा अनी तट जागवरच पडना; मंग लोकेसनी नीट आपला आपला समोर त्या नगरमां चालीसनं ते हस्तगत करं. ");
INSERT INTO ahr_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","माणसे, बाया, तरूण,वृध्द, गुरेढोरे, गधडा वगैरे जे काही त्या नगरमां व्हत ते समर्पित राहावामुये त्या बठासनी तलवारघाई समुळ नाश करं. ");
INSERT INTO ahr_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","तवय ज्या माणसे तो देश दखाले जायेल व्हतात त्यासले यहोशवा बोलना, “तुम्हीन आणभाक कराप्रमाणे ती वेशाना घर जाईसनं तिले अनी तिनं जे काही व्हयी ते बाहेर काढा.” ");
INSERT INTO ahr_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","तवय त्या तरुण हेरसनी मजार जाईसनं रहाबले, तिना मायबाप, भाऊबंदसले, तिनं जे काही व्हत ते अनी तिना बठा नातेवाईकसले बाहेर काढीसनं इस्त्राएल लोकेसनी छावनीबाहेर आणी ठेवं. ");
INSERT INTO ahr_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","मंग त्यासनी ते नगर अनी त्यामा जे काही व्हतं ते बठ आग लाईसनं जाळी टाकं; मात्र सोनं, रुपे अनी पितळनं अनी लोखंडना भांडा हाई त्यासनी परमेश्वरना मंदीरना भांडारमां ठेव. ");
INSERT INTO ahr_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","यहोशवानी रहाब वेशा, अनी तिना बापनं कुटूंब अनी तिना ज्या व्हतात त्या बठासले वाचाडं; तिना वंश आजपावोत इस्त्राएल लोकेसमां राही राहीना शे; कारण ज्या हेर यरीहो शोध कराले यहोशवाने धाडं व्हतं, त्यासले तिनी दपाडी ठेवं व्हतं. ");
INSERT INTO ahr_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","त्या येळले यहोशवानी इस्त्राएल लोकेसले आशी आज्ञा घाली की, “जो कोणी मोरे व्हईसनं हाई यरीहो नगर बसाडी त्याले परमेश्वरना शाप लागी; तो त्याना पाया घाली तवय त्याना मोठा पोर्‍या मरी अनी तो त्यानी वेशी उभारी तवय त्याना दाखला पोर्‍या मरी.” ");
INSERT INTO ahr_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","याप्रमाणे परमेश्वर यहोशवाना संगे राहीना, अनी त्यानी किर्ती देशभर पसरनी. ");
INSERT INTO ahr_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","त्या येळले इस्त्राएल लोकेसनी समर्पित वस्तुनीबारामां देवनं ऐकं नही त्यासनी अपराध करा; यहुदा वंशमाधला आखान बिन कर्मी जब्दी बिन जेरह यानी समर्पित वस्तुसमाईन काही ठि लिदयात त्यामुये इस्त्राएल लोकंसवर परमेश्वरना कोप भडकना. ");
INSERT INTO ahr_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","बेथेलना पुर्वले बेथ-आवेनाजोडे आय नगर शे तठे यहोशवानी यरीहोतीन माणसे धाडीसनं त्यासले सांगं की, जाईसनं तो देश हेरा, तवय त्यासनी जाईसनं आय नगर शोध करी टाक. ");
INSERT INTO ahr_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","त्या यहोशवाकडे परत ईसन बोलनात, “बठासनी तठे जावाले नको; फक्त दोन तीन हजार माणसंसनी जाईसनं हस्तगत करानं; तठे बठा माणससले जावानं कष्ट देवानी गरज नही शे; कारण त्या लोकं थोडाच शेतस;” ");
INSERT INTO ahr_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","म्हणीसनं जवयपास तीन हजार माणसे तिकडे गयात; पण आय आठेना माणसेसना मोरेतीन त्यासले पळ काढना पडा. ");
INSERT INTO ahr_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","आय आठेना माणससनी त्यामाधला आजमासे छतीस माणसे मारी टाकात अनी आपला वेशीपाईन दगडसनी खदानपावोत त्यासना पाठलाग करीसनं उतरतीपावोत मारतच लयी गयात; त्यामुये लोकेसना काळीजनं पाणी पाणी व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","यहोशवानी आपला कपडा फाडात मंग तो अनी इस्त्राएलना वडीलजन संध्याकायपावोत परमेश्वरना कोशनामोरे उपडा पडी राहीनात; अनी त्यासनी आपला डोकावर धुळ टाकी लिदी. ");
INSERT INTO ahr_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","यहोशवा बोलना, “हायहाय! हे प्रभू परमेश्वर आमले अमोरीसना हातमां देईसनं आमना नि:पात कराले पाहिजे म्हणीसनं तु हाई बठी प्रजा यार्देननापार का बरं आनी? आम्हीन सावध राहीसनं यार्देननातिकडे राहातु ते बरं व्हतं! ");
INSERT INTO ahr_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","हे प्रभू, इस्त्राएलनी आपला शत्रुले पाठ दखाडी ते मी आते काय सांगू! ");
INSERT INTO ahr_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","आते कनानी लोक अनी देशमाधला बठा रहीवाशी हाई ऐकीसन आमले घेरतीन अनी पृथ्वीवरलं आमनं नाव नाहीसं करतीन, तर तुनं थोर नाव राखाकरता काय करशी?” ");
INSERT INTO ahr_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","तवय परमेश्वर यहोशवाले बोलना, “ऊठ, अस उपडा का बर पडना? ");
INSERT INTO ahr_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","इस्त्राएल लोकेसनी पाप करेल शे! मी त्यासनासंगे करेल करार त्यासनी मोडेल शे; समर्पित वस्तुमाईन काही त्यासनी लेयल शेतस; एवढेच नही ते त्यासनी चोरी अनी लबाडी करेल शे, अनी त्या वस्तु त्यासना सामानमां ठेयल शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","त्यामुये इस्त्राएल लोकसले आपला शत्रुनामोरे टिकाव धरता येस नही; त्या आपल्या‍ शत्रुले पाठ दखाडतसं; कारण त्या शापग्रस्त व्हयेल शेतस; तुमनामाईन त्या समर्पित वस्तु नष्ट व्हस तोपावोत तुमनासंगे मी आठेतीन मोरे राहावू नही; ");
INSERT INTO ahr_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","तर ऊठ, लोकेसले शुध्द कर; त्यासले सांग; सकायकरता तुम्हीन बठा शुध्द व्हा; कारण इस्त्राएलना देव यहोवा म्हणसं; ‘हे इस्त्राएला, तुमपान समर्पित वस्तू शेतस; तुमनामाईन त्या समर्पित वस्तु दुर करावूत नही तोपावोत तुले तुना वैर्‍यासनीमोरे टिकाव धरता येवावू नही!’ ");
INSERT INTO ahr_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","सकासले तुमनामाईन एक एक वंशनी जोडे यिसनं उभं राहावानं;‍ ज्या वंशनी चिठी निघी त्यामाधला एकएक गोत्रसनी जोडे जावानं अनी ज्या गोत्रानी चिठी निघी त्यामाधला एक एक घरानानं जोडे येवानं; अनी ज्या घरानानी चिठी निघी त्यामाधला एक एक माणसासनी जोडे येवानं.” ");
INSERT INTO ahr_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","ज्यानाजोडे समर्पित वस्तु सापडी त्याले त्याना आपतासनीसंगे जाळी टाकानं; कारण त्यानी परमेश्वरना करार मोडेल शे; अनी इस्त्राएलमां मुढमां काम करेल शे. ");
INSERT INTO ahr_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","यहोशवा पहाटले उठीसनं इस्त्राएलना एक एक वंश जोडे उभं कर; तवय यहुदा वंशनी चिठी निघनी; ");
INSERT INTO ahr_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","मंग त्यानी यहुदाना एक एक गोत्र जोडे आणं, तवय जेरह गोत्रानी चिठी निघनी; अनी जेरहना गोत्रामाधला एक एक घरानाले जोडे आणं, तवय जब्दीनी घरानानी चिठी निघनी; ");
INSERT INTO ahr_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","मंग त्या घरानानां एक एक माणुसले जोडे आणं तवय यहुदा वंशमाधला आखान बिन कर्मी जब्दी बिन जेरह याले धरं; ");
INSERT INTO ahr_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","तवय यहोशवा आखानले बोलना, “पोर्‍या, इस्त्राएलना देव यहोवा याले थोर मान; त्यानामोरे आपला पाप कबुल कर; तु काय करं ते माले सांग; मनापाईन काही दपाडू नको.” ");
INSERT INTO ahr_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","आखान यहोशवाले बोलना, “मी खरंच इस्त्राएलना देव यहोवा याना अपराध करेल शे, मी जे काही करेल शे ते हाई; ");
INSERT INTO ahr_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","लुटमां एक चांगला शिनारी झगा, दोन किलो चांदी अनी अर्धा किलो वजननी एक सोनानी ईट हाई मनी नजरमां पडनी; तवय त्याना लोभ करीसनं ती लिदी; ती दख, मना डेरामां जमीनमां बुजेल शेतस अनी झगानाखाल चांदी शे.” ");
INSERT INTO ahr_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","तवय यहोशवानी काही जासुद धाडात; त्या डेरामां पयत गयात; अनी झगा त्याना डेरामां दपाडेल शेतस त्याना खाल रुपे ठेयेल शे अस त्यासले दखायनं. ");
INSERT INTO ahr_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","त्यासनी ती डेरामाईन काढीसनं यहोशवा अनी बठा इस्त्राएल लोक यानाकडे लयीसनं परमेश्वरनामोरे ठेवं. ");
INSERT INTO ahr_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","तवय यहोशवानी अनी त्यानासंगेना बठा इस्त्राएलसनी आखान बिन जेरह याले अनी त्यानासंगे ते चांदी, तो झगा अनी सोनानी ईट, त्याना पोरीसना पोर्‍या, त्यासना बैल, गधडा, शेरडामेंढरा, त्याना डेरा अनी त्यानं जे काही व्हतं नव्हतं ते बठं आखोर खिंडमां आणं. ");
INSERT INTO ahr_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","तवय यहोशवा बोलना, “तु आमले त्रास का बरं दिधा? परमेश्वर तुले आज त्रास देई,” मंग बठा इस्त्राएलसनी त्यासले दगडमार करी अनी ती बठी आगघाई जायीसनं त्यानावर दगड टाकात. ");
INSERT INTO ahr_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","त्यानावर त्यासनी एक मोठी दगडासनी रास करी ती आजपावोत शे; तवय परमेश्वरना भडकेल कोप कमी व्हयनं; यावरतीनी ती जागले आजपावोत आखोर म्हणजे त्रास देणारी खिंड बोलतसं. ");
INSERT INTO ahr_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","मंग परमेश्वर यहोशवाले बोलना, “भ्याऊ नको, कचरु नको; ऊठ, बठा योध्दयासले संगे लिसन आय नगरवर चढाई कर; आय नगरना राजा, त्याना नगर अनी त्याना देश हाई मी तुना हातमां देयेल शेतस; ");
INSERT INTO ahr_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","यरीहो नगर अनी त्याना राजा यासना यासना जशे तु करं तशे आय अनी त्याना राजा यासनं कर; मात्र तठेना हातमां लागी ती मालमत्ता अनी गुरेढोरे हाई तुम्ही तुमनाकरता लुट म्हणीसनं लेवानं; नगरना मांगली बाजुना लोकेसले दबा धरीसनं बसाले सांग,” ");
INSERT INTO ahr_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","त्याप्रमाणे यहोशवानी बठा योध्दयासनीसंगे आय नगरवर चढाई करानी तयारी करी; यहोशवानी तीस हजार पराक्रमी वीर पुरुष निवाडीसनं रातमाच धाडी दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","त्यानी त्यासले आज्ञा करी की “ऐका, नगरना मांगली बाजुले दबा धरीसनं बठी ऱ्‍हावानं; नगरपाईन जास्त दुर जावानं नही, पण तुम्हीन बठ्ठा तयारीमां ऱ्हावानं. ");
INSERT INTO ahr_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","मी अनी मनासंगेना बठा माणसे त्या नगरना जोडे येसुत; अनी त्या पुर्वीप्रमाणे आपलावर हल्ला कराले येतीन तवय आपन त्यासनामोरे पळाले लागानं, ");
INSERT INTO ahr_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","अस आपण त्यासले चाळवत नगरनाबाहेर दूर लयी जातस तोपावोत त्या आपलामांगे लागतीन; त्या म्हणतीन, पुर्वीप्रमाणे हया आपुनले भ्यायीसनं पळी राहीना शेतस; अस त्यासनामोरे आपुन पळाले लागानं; ");
INSERT INTO ahr_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","मंग दबा धरीसनं ज्या बसेल शेतस त्यासनी उठीसनं हल्ला करानं अनी ते नगर काबीज करानं; कारण तुमना देव यहोवा ते तुमना हातमां देई. ");
INSERT INTO ahr_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","तुम्हीन ते नगर हातमां लेतास त्याले आग लावा; परमेश्वरनी आज्ञाप्रमाणे करा; दखा, मी तुमले बठ सांगेल शे.” ");
INSERT INTO ahr_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","यहोशवानी त्यासले रवानं करं तवय त्या आयना पश्चिम बाजुले बेथेल अनी आय यानं मजारमां दबा धराकरता जाईसनं राहीनात; यहोशवा त्या रातले आपला लोकेसनीसंगे राहीना. ");
INSERT INTO ahr_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","यहोशवा पहाटलेस ऊठीसनं लोकेसले जमा करं अनी तो अनी इस्त्राएलना वडीलजन लोकेसनी आगोदर आय नगरकडे चालनात. ");
INSERT INTO ahr_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","त्यानासंगे बठा योध्दा कुच करीसनं गयात, अनी आय नगरनाजोडे जावानंतर त्यासनी त्यासनामोरे उत्तरले तळ दिदा; त्या अनी आय नगर यासना मजारमां दरी व्हती. ");
INSERT INTO ahr_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","त्यानी जवयपास पाच हजार माणसे नगरना पश्चिमले बेथेल अनी आय याना मजार दबा धराले ठेवं. ");
INSERT INTO ahr_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","नगरना उत्तरले कोणता सैन्य जावाले पाहिजे अनी पश्चिमले कोणी दबा धरानं हाई ठराईसनं यहोशवा त्या रातले त्या दरीमां राहीना. ");
INSERT INTO ahr_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","आय नगरना राजानी हाई दख तवय तो अनी त्याना नगरना बठा माणसे पहाटले लवकर उठीसनं इस्त्राएल लोकसनासंगे सामना कराले यार्देनना घाटनामोरे ठरायेल येळले गयात; नगरनी मांगेनी बाजुले माणसे दबा धरीसनं शेतस हाई त्या राजाले माहीत नव्हतं. ");
INSERT INTO ahr_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","मंग यहोशवा अनी बठा इस्त्राएल लोक हारी गयुत अस दखाडीसनं त्या जंगलना वाटकडे पयनात. ");
INSERT INTO ahr_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","त्यासना पाठलाग कराकरता नगरना बठा माणसासले एकजागे बलावं; त्यासनी यहोशवाना पाठलाग करा अनी तो त्यासले नगरपाईन बराच दुर लयी गया. ");
INSERT INTO ahr_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","इस्त्राएलनामांगे कोनी गयात नही अस कोनताच माणुस आय अनी बेथेल आठे राहीनात नही; त्यासनी ते नगर खुल टाकीसनं इस्त्राएलना पाठलाग करा. ");
INSERT INTO ahr_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","तवय परमेश्वर यहोशवाले बोलना, तुना हातमाधला भाला आय नगरबाग कर, कारण ते मी तुना हातमां देस, यहोशवानी आपला हातमाधला भाला नगरबागकडे करं. ");
INSERT INTO ahr_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","तवय त्यानी आपला हात उगारताच दबा धरीसनं बसेल लगेच उठीसनं पयत जाईसनं नगरमां घुसनात अनी ते काबीज करं, अनी त्वरा करीसनं त्या नगरले आग लाई. ");
INSERT INTO ahr_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","आय आठेना माणसासनी मांगे वळीसनं दख ते नगरमाईन धुर आकाशमां चढतांना त्यासले दखायनं, तवय त्यासले हाई बाजुले नाहीते त्या बाजुले पयानी ताकद राहीनी नही; इकडे ज्या माणसे जंगलकडे पयत व्हतात त्यासनी उलटीसनं आपला पाठलाग करनारासनी पाठ धरी. ");
INSERT INTO ahr_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","दबा धरनार्‍यासनी नगर हस्तगत करं शे अनी त्याना धुर वर यि राहीना शे, अस यहोशवानी अनी बठा इस्त्राएल लोक यासनी दख तवय त्यासनी मांगे उलटीसनं आयमाधला लोकेसना संहार करं. ");
INSERT INTO ahr_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","त्यासनासंगे सामना कराले दुसरी टोयीबी नगरमाईन निघीनी, अस त्या हाई बाजूतीनबी आनी त्याबाजुतीन इस्त्राएलना लोकेसना कचाटामां सापडनात; त्यासनी त्यासना संहार करं; त्यासमाधला कोनीच जीवता राहिना नही अनी कोनी निसटीसनं गयात नही. ");
INSERT INTO ahr_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","आय नगरना राजाले त्यासनी जीवता धरीसनं यहोशवाकडे आणं. ");
INSERT INTO ahr_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","मैदानमां म्हणजे जंगलमां पाठलाग करं व्हत तठे इस्त्राएलनी आय नगरना बठा रहिवाशासाना संहार करं, अनी तलवारना धारखाल सापाडायीसनं त्यासना बठा फडशा उडाई दिद, मंग इस्त्राएल लोक आय नगरमां परत ऊनात अनी त्यासनावर त्यासनी तलावर चालाई. ");
INSERT INTO ahr_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","त्या रोज बठा बाई माणसे ज्या माणसे पडनात त्या बारा हजार व्हतात, म्हणजे आय नगरना बठा माणसे. ");
INSERT INTO ahr_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","आय आठेना बठा माणसे निपात व्हतसं तोपावोत यहोशवानी ज्या हातघाई आपला भाला नगरकडे करं व्हतं तो मांगे लिदा नही. ");
INSERT INTO ahr_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","परमेश्वरनी यहोशवाले सांगाप्रमाणे इस्त्राएल लोकेसनी त्या नगरना गुरेढोरे अनी इतर मालमत्ता मात्र सोताकरता लुट म्हणीसनं लिदी. ");
INSERT INTO ahr_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","तवय यहोशवानी आय नगरले आग लाई अनी त्यानी कायमनं नाश करी टाक. आजपावोत ते तशेच उजाड पडेल शे. ");
INSERT INTO ahr_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","आय नगरना राजाले यहोशवानी संध्याकायपावोत झाडले टांग अनी सुर्यास्तवना येळले त्यानी आज्ञातीन त्याना प्रेत झाडवरतीन उतारीसनं नगरना वेशीपान त्यानी टाकी अनी त्यानावर एक दगडासनी मोठी रास करी, ती आजपावोत शे. ");
INSERT INTO ahr_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","मंग यहोशवानी इस्त्राएलना देव यहोवा यानाकरता एबाल पर्वतवर वेदी बांधी; ");
INSERT INTO ahr_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","परमेश्वरना सेवक मोशे यानी इस्त्राएलले आज्ञा देयल व्हती त्यानाप्रमाणे, मोशेना नियमशास्त्रमां लिखेल शे त्याप्रमाणे, म्हणजे बिगर घडायेल दगडनी वेदी त्यानी बांधी दगडसले लोखंडना स्पर्श व्हयेल नव्हता; त्या वेदीवर त्यानी परमेश्वरले होमबली अर्पन करं अनी शांत्यर्पण करं. ");
INSERT INTO ahr_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","त्याच ठिकानले यहोशवानी इस्त्राएल लोकेसना देखत त्या दगडसवर मोशेनी लिखेल नियमशास्त्रनी नक्कल उतारी. ");
INSERT INTO ahr_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","मंग बठा देशी परदेशी इस्त्राएल लोक आपला वडील माणसे, सरदार अनी न्यायधीश यासनासंगे परमेश्वरना करारना कोश वाहानारा लेवीय याजकसनामोरे त्या कोशना इकडे अनी तिकडे उभा राहीनात; आर्धा लोक गरिज्जीम पर्वतनामोरे उभा राहीनात, परमेश्वरना सेवक मोशे यानी आज्ञा देयेल व्हती की इस्त्राएल लोकेसले आगोदर आशिर्वाद देवानं. ");
INSERT INTO ahr_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","मंग आशिर्वादनं अनी शापनं वचन नियमशास्त्रमां लिखेल शेतस ती बठी यहोशवानी वाची दखाडी. ");
INSERT INTO ahr_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","मोशेनी देयेल सगळया आज्ञा इस्त्राएल लोकेसना बठी मंडयीनासमोर अनी त्यासन्या बाया, पोरसोरे अनी त्यासमां राहानारा परदेशी यासनासमोर वाची दखाडं; त्यामाधला एक बी शब्द सोडा नही. ");
INSERT INTO ahr_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","हाई ऐकीसन हित्ती, अमोरी, कनानी. परिज्जी, हिव्वी अनी यबुसी यासना ज्या राजा यार्देनना डोंगराळ देशमां, तळवटमां अनी लबानोनासमोर महासागरना काठले राही राहिंतात. ");
INSERT INTO ahr_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","त्या बठा एकोपा करीसनं यहोशवा अनी इस्त्राएल लोक यासनासंगे लढाई कराले जमा व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","यहोशवानी यरीहो अनी आय नगरनं काय करं हाई गिबोनना रहीवासीसनी ऐकं; ");
INSERT INTO ahr_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","तवय त्यासनी कपटतीन युक्ती करी; त्यासनी वाटमां शिधा लिदा अनी आपला गधडासवर जुना गोणताटे अनी जुनी, फाटेल, ठिगळा मारेल बुधला लादयात; ");
INSERT INTO ahr_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","त्यासनी आपला पायमां जुना अनी ठिगळना जोडा घालात, आंगमा जुना कपडा घालात; त्यासना शिदोरीमांसली भाकरी सुकाईसनं चुरा व्हयी जायेल व्हत. ");
INSERT INTO ahr_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","त्या गिलगालना छावनीमां यहोशवाकडे जाईसनं त्याले अनी इस्त्राएल लोकेसले बोलनात; “आम्हीन दुर देशमाईन वनु शेतस, आमनासंगे करार करा.” ");
INSERT INTO ahr_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","इस्त्राएल लोकेसनी त्या हिळयास सांगं, “कोणले माहीत कदाचित तुम्हीन आमनामां राहानारा व्हशात; तुमनासंगे करार कसा कराना?” ");
INSERT INTO ahr_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","त्या यहोशवाले बोलना, “आम्ही तुमना दास शेतस.” यहोशवानी त्यासले ईचारं, “तुम्हीन कोन अनी कथाईन ऊनात?” ");
INSERT INTO ahr_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","त्या बोलनात, “तुना दास दुर देशमाईन तुना देव यहोवा यानं नाव ऐकीसन येयल शेतस; त्यानी किर्ती अनी त्यानी मिसरमां कायकाय करं हाई बठ आम्हीन आयकेल शे; ");
INSERT INTO ahr_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","अनी यार्देनना पुर्वले अमोर्‍यासना दोन राजा म्हणजे हेशबोन निवासी राजा सीहोन अनी अष्टरोथ निवासी बाशानना राजा ओग, यासनं त्यानी काय करं हाई आमले माहीत शे. ");
INSERT INTO ahr_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","तवय आमना वडील माणसे अनी आमना देशना बठा रहीवासी आमले बोलनात, वाटमां तुमनासंगे शिदोरी लिसन त्यासले भेटाले जा अनी त्यासले सांगा की, आम्हीन तुमना दास शेतस; आता आमनासंगे करार करा. ");
INSERT INTO ahr_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","आम्हीन तुमनाकडे येवाले निघनुत त्या रोज आम्हीन घरतीन ऊन्या ऊन्या भाकरी लिदया व्हत्यात पण त्या आते सुकाई जायेल शेतस अनी त्यासना भुगा व्हई जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","हाई द्राक्षरसना भांडा भरी लिदात तवय त्या नवा व्हतात, पण त्या आता फाटीतुटी जायेल शेतस; हाई आमना कपडा अनी आमना चपला बराच दुरना प्रवासमा घसाई जायेल शेतस.” ");
INSERT INTO ahr_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","तवय इस्त्राएली माणससनी परमेश्वरले ईचाराशिवाय त्यासना जेवनमातीन काही लिधं. ");
INSERT INTO ahr_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","मंग यहोशवानी त्यासनासंगे सल्ला करीसनं त्यासले जीवत ठेवाना करार करा; मंडयीना सरदारसनी त्यासनासंगे करार करा. ");
INSERT INTO ahr_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","त्यासनासंगे करार व्हावानंतर तीन दिनसमां त्यासले समजनं की, हया आपला शेजारना शेतस अनी आपलामां राहानार शेतस; ");
INSERT INTO ahr_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","मंग इस्त्राएल लोक कुच करीसनं तिसरा रोज त्यासना नगरमां जाई पोहचनात, त्यासना नगरसनं नाव हाई; गिबोन, कफीरा, बैरोथ अनी किर्याथ-यारीम. ");
INSERT INTO ahr_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","इस्त्राएल लोकेसनी त्यासले मारी टाकं नही, कारण मंडयीना सरदारसनी इस्त्राएलना देव यहोवा याना नावतीन आणभाक करी व्हती; पण बठी मंडयीनी सरदारनी विरोधमां कुरकूर करी, ");
INSERT INTO ahr_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","तवय त्या बठा सरदार मंडयीले बोलनात, आम्हीन इस्त्राएलना देव यहोवा याना नावतीन आणभाक करेल शे; तर आते आमले त्यासले हात लावता येवावू नही; ");
INSERT INTO ahr_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","त्यासनासंगे आम्हीन असच वागसुत; त्यासले आम्हीन जीवत ठेवसुत; तशे नही करंते त्यासनासंगे आणभाक कराप्रमाणे आम्हीन क्रोधपात्र व्हसुत. ");
INSERT INTO ahr_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","तवय सरदारसनी त्यासले सांग की त्यासले जीवत सोडा; सरदारसनी त्यासले सांगाप्रमाणे त्या माणसे बठी मंडयीना लाकुतोडे अनी पाणक्ये व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","यहोशवानी त्यासले बलाईसनं सांग, “तुम्हीन आमनासंगे राही राहीना शेतस पण आम्हीन भलता दुरना शेतस अस सांगीसनं आमले का बर फसाडं? ");
INSERT INTO ahr_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","तर आते तुमले अस शाप शे की, तुमनामाईन कोणलेच दास व्हावाले चुकावू नही; तुम्हीन मना देवना मंदिरमा लकुडतोडे अनी पाणी भरणारा व्हयीसनं राहाशात.” ");
INSERT INTO ahr_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","त्या यहोशवाले बोलनात, “हावु बठा देश तुमले दिसनं अनी तुमनासमोर देशमाधला बठा रहीवाशीसना संहार करसु अस तुना देव यहोवा यानी आपला सेवक मोशे याले सांग व्हतं. हाई खरच तुना दासना कानवर वन; तुमनामुये आमले आमना जीवनी भ्याव वाटनं त्यामुये आम्हीन अस काम करं. ");
INSERT INTO ahr_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","आते दख, आम्हीन तुना हातमां शेतस; तुले जे बरं अनी ठिक वाटी तस आमनासंगे कर.” ");
INSERT INTO ahr_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","त्यानी त्यासनी ईनंती ऐकी अनी त्यासले इस्त्राएल लोकेसना हातमाईन सोडावं, त्यासनी त्यासना संहार करा नही. ");
INSERT INTO ahr_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","यहोशवानी त्यारोज मंडयीनाकरता अनी परमेश्वर निवडनार व्हता त्या जागावर वेदीकरता त्यासले लाकुडतोड्या अनी पाणी भरणारा म्हणीसन नेमी ठेवं, तसच त्या आजपावोत शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","यहोशवानी आय नगर लिसन त्यासना बठा नाश करी टाक; अनी जशे त्यानी यरीहोन अनी त्याना राजानं करं तशेच आय नगरनं अनी त्याना राजानं करं, अनी गिबोनना रहीवाशी इस्त्राएल लोकसनासंगे सल्ला करीसनं त्यासमां जाईसनं राहीनात; हाई बठं यरुशेलमना राजा अदोनीसदेक यानी ऐकं; ");
INSERT INTO ahr_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","तवय त्यासले भ्याव वाटनं; कारण गिबोन हाई मोठं नगर व्हतं अनी राजधानी व्हतं अनी ते आय नगरपेक्षा मोठ शे अनी तठेना लोके बलाढय व्हतात. ");
INSERT INTO ahr_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","तवय यरुशेलमना राजा अदोनीसदेक यानी हेब्रोनना राजा होहाम, यर्मुथना राजा पिराम, लाखीशना राजा याफीय अनी एग्लोनना राजा दबीर यासले निरोप धाडा की, ");
INSERT INTO ahr_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","मनाकडे ईसन माले कुमक करा, आपण गिबोन नगरले मार दिसुत; कारण त्यानी यहोशवानीसंगे अनी इस्त्राएल लोकसनासंगे सल्ला करेल शे. ");
INSERT INTO ahr_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","तवय यरुशेलम, हेब्रोन, यर्मुथ, लाखीश अनी एग्लोन आठेना पाच अमोरी राजासनी आपली सेना जमा करीसनं चढाई करी अनी गिबोननामोरे तळ दिसनं त्या त्यासनासंगे लढाले लागनात. ");
INSERT INTO ahr_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","तवय गिबोनना रहीवासीसनी गिलगालनना छावनीमां यहोशवाले सांगी धाडं की, “आपला दासासवरतीन आपला हात मांगे लेऊ नको; लवकर आमनाकडे यिसनं आमले वाचाडं; कारण डोंगरकडतीन बठा अमोरी राजा एकजागे व्हयीसनं आमनावर येयल शेतस!” ");
INSERT INTO ahr_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","तवय यहोशवा त्याना योध्दे अनी बठा शुरवीर यासले संगे लिसनं गिलगाल आठे निघना. ");
INSERT INTO ahr_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","परमेश्वर यहोशवाले बोलना, “त्यासनी भीती धरु नको; मी त्यासले तुना हातमां देयेल शे; त्यासमाधला एकबी माणुस तुनामोरे टिकाऊत नही.” ");
INSERT INTO ahr_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","यहोशवा त्यासनावर एकाएकी चाल करीसनं ऊना; तो रातमास गिलगालकडे कुच करीसन गया. ");
INSERT INTO ahr_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","परमेश्वरनी इस्त्राएलनासमोर त्यासनी गाळण करी अनी त्यासनी गिबोनपान त्यासनी कत्तल उडाईसनं बेथ-हारोनना घाटमां त्यासना पाठलाग करा अनी अजेक अनी मक्केदा आठेपावोत त्या त्यासले मारत गयात. ");
INSERT INTO ahr_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","त्या इस्त्राएलना समोरतीन पळीसनं बेथ-हारोनना उतरतीपान येवावर अजेकले जातस तोपावोत परमेश्वरनी आकाशमाईन मोठया गारा‍ त्यासनावर पाडीसन त्यासले ठार करं; इस्त्राएल लोकेसनी तलवारघाई मारं, त्यापेक्षा जास्त गारासघाई मरनात; ");
INSERT INTO ahr_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","परमेश्वरनी अमोरी लोकेसले इस्त्राएल लोकेसना हातमां दिद् तवय यहोशवा परमेश्वरपान बोलना, इस्त्राएलनासमोर तो अस बोलना, “हे सुर्या, तु गिबोनवार स्थिर व्हय; हे चंद्रा तु अयालोनना खोरावर स्थिर व्हय.” ");
INSERT INTO ahr_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","तवय सुर्य स्थिर व्हयना अनी चंद्र थांबना, त्या राष्ट्रनी आपला शत्रुना बठा उसना फेडस तोपावोत त्या थांबनात. याशार नावना ग्रंथमां हाई कथा लिखेल शे ना? सुर्य आकाशमंडयमां थांबना अनी जवयजवय चार प्रहर गया नही. ");
INSERT INTO ahr_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","असा दिन याना पहिले ऊना नही अनी यानामोरे येवाऊ नही; परमेश्वरनी मानवना शब्द ऐका; परमेश्वर इस्त्राएलकरता लढना. ");
INSERT INTO ahr_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","मंग यहोशवा बठा इस्त्राएलनासंगे गिलगालना छावनीकडे परत गया. ");
INSERT INTO ahr_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","त्या पाच राजा पळीसनं मक्केदानाजोडे एक गुहामां दपी बसनात. ");
INSERT INTO ahr_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","त्या पाच राजा मक्केदा आठे गुहामां दपेल शेतस अस कोणी यहोशवाले कळाडं. ");
INSERT INTO ahr_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","तवय यहोशवानी सांग की, “गुहानां तोंडपान मोठमोठा दगड ढकला अनी तिनावर माणसासना पहारा ठेवा. ");
INSERT INTO ahr_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","पण तुम्हीन थांबानं नही, आपला शत्रुना पाठलाग करीसनं त्यासनामांगेना लोकसले मारी टाका, त्यासले त्यासना नगरमां जाऊ देवानं नही; कारण तुमना देव यहोवा यानी त्यासले तुमनां हातमां देयेल शे.” ");
INSERT INTO ahr_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","यहोशवा अनी इस्त्राएल लोक यासनी त्यासनी मोठी कत्तल करीसनं त्यासना संहार करानं काम आपटी लिधं; त्यासमाधला काही माणसे वाचीसनं तटबंदीना नगरमां गयात, ");
INSERT INTO ahr_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","तवय बठा लोक मक्केदाना छावनीमां यहोशवाकडे सुखरुप ऊनात; इस्त्राएलना विरोधमां कोणीच शब्द बी काढा नही. ");
INSERT INTO ahr_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","तवय यहोशवानी आज्ञा करी की, “गुहानं तोंड उघाडीसनं त्या पाच राजासले मनाकडे लयी या.” ");
INSERT INTO ahr_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","त्यासनी तसं करं अनी यरुशेलम, हेब्रोन, यर्मुथ, लाखीश अनी एग्लोन आठेना पाच राजासले गुहामाईन काढीसन त्यानामोरे आणं. ");
INSERT INTO ahr_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","त्यासनी त्या राजासले यहोशवाकडे लई ऊनात तवय बठा इस्त्राएल लोकेसले बलाईसनं तो आपलासंगे योध्द्यांसना नायकसले बोलना, “जोडे ईसन तुमना पाय या राजासना मानवर ठेवा.” त्यासनी जोडे ईसनं त्यासना मानवर पाय ठेवं. ");
INSERT INTO ahr_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","यहोशवा त्यासले बोलना, “भ्याऊ नका, धीर धरा; कारण ज्यासनासंगे तुम्हीन लढशात त्या तुमना बठा शत्रुसनं परमेश्वर असच कराव शे.” ");
INSERT INTO ahr_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","मंग यहोशवानी त्या राजासले ठार मारीसनं पाच झाडसवर टांगं; अनी त्या संध्याकायपावोत त्या झाडासवर लटकी राहीनात. ");
INSERT INTO ahr_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","सुर्य मावयाना येळले यहोशवानी आज्ञावरतीन लोकेसनी त्यासले त्या झाडसवरतीन उतारं, अनी ज्या गुहामां त्या दपेल व्हतात तठे त्यासले टाकं, अनी त्या गुहाना तोंडले त्यासनी मोठमोठा दगड लोटी दिद्; आजपावोत त्या तशेच शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","त्या रोज यहोशवानी मक्केदा लिसनं तलवारघाई त्यासना बठाच संहार करं, त्याना राजालेबी मारी टाकं अनी जेवढा जनावर तठे व्हतात त्यासमाईन कोणलेच जीवत राहू दिद् नही; त्यानी यरीहोना राजानं जशे करं तशेच मक्केद्ना राजानं करं. ");
INSERT INTO ahr_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","मंग मक्केदामाईन निघीसनं बठा इस्त्राएलसले संगे लिसनं यहोशवा लिब्ना आठे गया अनी त्यासनासंगे लढना; ");
INSERT INTO ahr_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","परमेश्वरनी ते नगर अनी त्याना राजा यासले इस्त्राएलना हातमां दिध अनी यहोशवानी त्याना अनी त्या नगरमाधला बठा जनावरसना तलवारघाई संहार करं; त्यामाधला काहीच जीवत राहू दिध नही; यरीहोना राजानं जशे त्यानी करं तशेच त्यानी आठेना राजानं करं. ");
INSERT INTO ahr_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","मंग लिब्ना सोडीसनं बठा इस्त्राएलनासंगे यहोशवा लाखीश नगर आठे गया अनी त्यासनामोरे तठ दिसनं त्यासनासंगे लढना; ");
INSERT INTO ahr_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","परमेश्वरनी लाखीश नगरले इस्त्राएलना हातमां दिधं अनी त्यासनी ते दुसरा रोज लिधं; लिब्ना आठेना बठा जनावरासना त्यानी तलवारघाई संहार करा व्हता तसच लाखीश नगर आठे बी करं. ");
INSERT INTO ahr_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","तवय गेजेरना राजा होराम हाऊ लाखीशला कुमक कराकरता चाली ऊना; तवय यहोशवानी त्याना अनी त्याना लोकसना एवढा संहार करा की, त्यासमाधला कोणले बी जीवत राहू दिध नही. ");
INSERT INTO ahr_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","मंग लाखीश सोडीसनं यहोशवा बठा इस्त्राएलनासंगे एग्लोन आठे गया; त्यासनामोरे तळ दिसनं त्यासनासंगे लढनात; ");
INSERT INTO ahr_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","त्याच रोज त्यासनी ते नगर लिद् अनी त्याना तलवारघाई संहार करं; लाखीश नगरमां जस बठा जिवसना संहार करं व्हतं तशेच त्यानी त्या रोज एग्लोनं नगरनं बी करं. ");
INSERT INTO ahr_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","मंग एग्लोन सोडीसनं बठा इस्त्राएलनासंगे यहोशवा हेब्रोन नगरले गया; अनी त्या त्यासनासंगे लढनात; ");
INSERT INTO ahr_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","त्यासनी ते नगर लिद् अनी त्या, त्याना राजा, त्याना बठा नगर अनी त्यामाधला बठा जनावर यासना तलवारघाई संहार करं; यहोशवानी एग्लोनना मायकच हेब्रोनमां कोणलेच जीवत राहू दिद् नही; त्यानी त्यासना अनी तठेना बठा जनावरासले संहार करं. ");
INSERT INTO ahr_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","मंग यहोशवा बठा इस्त्राएलनासंगे मांगे वळीसनं दबीरा नगरले गया अनी त्यासनासंगे लढना; ");
INSERT INTO ahr_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","तठेना राजा अनी त्याना बठा नगर त्यानी हस्तगत करीसनं त्यासना तलवारघाई संहार करं; तठे जेवढा जनावर व्हतात त्यासना त्यानी संहार करं, कोणलेच जीवत राहू दिद नही; हेब्रोनना अनी लिब्ना अनी त्यासना राजा यासना जशे त्यानी करं तशेच दबीर अनी त्याना राजा यासनं बी करं. ");
INSERT INTO ahr_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","असं यहोशवानी त्या बठा देशना म्हणजे पहाडी परदेश, दक्षिण देश, तळवट अनी उतरण हाई बठा प्रांत अनी त्यासना राजासना धुव्वा उडावा, कोणलेच जीवत राहू दिद् नही; इस्त्राएलना देव यहोवा याना आज्ञाप्रमाणे बठा जनावरासना त्यानी संहार करं. ");
INSERT INTO ahr_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","यहोशवानी कादेश-बर्ण्यापाईन गज्जापावोत मुलूख अनी गिबोनपावोत बठा गोशेन प्रांत यासना धुव्वा उडावं. ");
INSERT INTO ahr_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","हया बठा राजा अनी त्यासना देश यहोशवानी एकच येळमां लिधात; कारण इस्त्राएलना देव यहोवा इस्त्राएलकडतीन लढना. ");
INSERT INTO ahr_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","मंग यहोशवा बठा इस्त्राएलनासंगे गिलगालनी छावनीमां परत गयात. ");
INSERT INTO ahr_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","हाई ऐकीसन हासोरना राजा याबीन यानी मादोनना राजा योबाब अनी शिम्रोनना राजा अनी अक्षाफाना राजा यासले, ");
INSERT INTO ahr_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","त्याप्रमाणे उत्तर दिशाले डोंगराळ भागमां, किन्नेरोथना दक्षिणले अराबामां, तळवट अनी पश्चिमले दोराना माळामाधला राजासले, ");
INSERT INTO ahr_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","अनी पुर्वेले अनी पश्चिमले कनानी, अमोरी, हित्ती, परिज्जी अनी डोंगरकडला यबुसी अनी हर्मोन पहाडना तळपान मिस्पा प्रांतमां राहानारा हिव्वी यासले बलावनं धाडं. ");
INSERT INTO ahr_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","तवय त्या बठा आपला सेन लिसन सागरना काठले वाळुनासारखा अगणित बाहेर निघनात; त्यासनासंगे घोडा अनी रभ बराच व्हतात. ");
INSERT INTO ahr_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","हया बठा राजासनी एकजागे व्हयीसनं इस्त्राएलनासंगे लढाकरता मेरोम नावना तलावना जोडे तळ दिदा. ");
INSERT INTO ahr_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","तवय परमेश्वर यहोशवाले बोलना, त्यासले भ्याऊ नको, कारण सकाय हाई येळले मी त्या बठासले इस्त्राएलना हातमां दिसन त्यासना संहार करसू; तवय तु त्यासना घोडासना मांडयासना शिर तोडी टाकं अनी रथ आगमां जायी टाकात. ");
INSERT INTO ahr_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","तवय यहोशवा बठा योध्दयासनीसंगे मेरोम सरोवरपान आचानक ईसन त्यासना तुटी पडना. ");
INSERT INTO ahr_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","परमेश्वरनी त्यासले इस्त्राएलना हातमां दिद्, त्यासनी त्यासले मार दिसनं सीदोन महानगरपावोत अनी मिस्रोपोथ-माईमापावोत अनी पुर्वले मिस्पा खोरापावोत त्यासना पाठलाग करा अनी त्यासले मारी टाक; त्यासमाधला एकलेबी जीवत राहू दिद् नही. ");
INSERT INTO ahr_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","परमेश्वरनी सांग व्हतं त्याप्रमाणे यहोशवानी त्यासनं करं; त्यानी त्यासना घोडासना मांडयासना शिरा तोडयात अनी त्यासना रथ आगमां जायी टाकात. ");
INSERT INTO ahr_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","त्या येळले यहोशवानी मांगे परतीसनं हासोर लिद्, अनी त्याना राजाले तलवारघाई मारी टाक; आगोदर हासोर हया त्या राष्ट्रमां परमुख व्हतात. ");
INSERT INTO ahr_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","जेवढा जनावर तठे राहात व्हतात त्या बठासना तलवारघाई संहार करीसनं कोणताच जनावर जीवत राहू दिद् नही; अनी त्यानी हासोर हयाले आग लाईसनं ते जायी टाकं. ");
INSERT INTO ahr_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","परमेश्वरना सेवक मोशे याना आज्ञाप्रमाणे त्या राजासना बठा नगर अनी त्यासना बठा राजा हस्तगत करीसनं यहोशवानी त्यासना तलवारघाई संहार करीसनं बठकाही नाश करी टाकं. ");
INSERT INTO ahr_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","तरी बी ज्या नगर टेकडीवर बसेल व्हतात त्या इस्त्राएल लोकसनी जाळं नही; पण हासोर नगरले यहोशवानी जाळी टाकं; ");
INSERT INTO ahr_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","त्या नगरमाधला बठी मालमत्ता अनी गुरेढोरे इस्त्राएल लोकेसनी लुटी लिद्, पण तलवार चालाडीसनं मनुष्यना नि:पात करं, एकबी जनावर जीवत राहू दिद नही. ");
INSERT INTO ahr_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","परमेश्वरनी आपला सेवक मोशे याले आज्ञा कराप्रमाणे मोशेनी यहोशवाले सांग; अनी त्याप्रमाणे यहोशवानी करं. परमेश्वरनी मोशेले सांगेल कोणतीबी गोष्ट करावाचून त्यानी सोडं नही. ");
INSERT INTO ahr_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","या परकारं यहोशवानी डोंगरी मुलूख, बठा दक्षिण देश, बठा गोशेन प्रांत, तळवट, अराबा, इस्त्राएलना डोंगराळ परदेश अनी त्यानी तळवट हाई लिदी. ");
INSERT INTO ahr_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","सेईरना वाटपान हालाक डोंगरपाईन हर्मोन पर्वततळपान लबानोन खोरामाधला बाल-गाद आठेना बठा मुलूख अनी त्यामाधला राजा त्यानी हस्तगत करं, अनी त्यासना मोड करीसनं त्यासले मारी टाक. ");
INSERT INTO ahr_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","त्या बठा राजासनासंगे यहोशवानी बराच काळ युध्द करं. ");
INSERT INTO ahr_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","गिबोनमां राहानारा हिळयासले सोडीसन इस्त्राएल लोकेसनीसंगे सल्ला करं अस एक बी नगर नव्हतं; त्या बठा त्यानी लढाई करीसनी जिंकी लिधात. ");
INSERT INTO ahr_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","परमेश्वरनं मानस अस व्हतं की त्यानी मोशेले सांगाप्रमाणे त्यासना निखालस नि:पात करानं, त्यासले काहीच दयामाया नही दखाडता त्यासना संहार करानं, म्हणीसनं त्यानी त्यानं कठीण करं अनी त्या इस्त्राएलनासंगे युध्द कराले बाहेर निघनात. ");
INSERT INTO ahr_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","त्या येळले यहोशवानी पहाडी देशमां जाईसनं हेब्रोन, दबीर अनी अनाब यामाधला अनी यहुदा अनी इस्त्राएल यासना बठा डोंगराळ परदेशमां राहानारा अनाकी लोकेसना नाश करा अनी त्यासना अनी त्यासना नगरना बठा सत्यानाश करी टाका. ");
INSERT INTO ahr_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","इस्त्राएल लोकसना देशमां कोणी अनाकी लोके जीवत राहीना नहीत; पण गज्जा, गथ अनी अश्दोद यामाधला थोडा लोके जीवत राहीनात. ");
INSERT INTO ahr_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","परमेश्वरनी मोशेले सांगं व्हतं त्याप्रमाणे यहोशवानी बठा देश लिदात अनी तो इस्त्राएल लोकेसना वंशना नियमप्रमाणे त्यासले वाटीसनं वतन करी दिधा; तवय देशले युध्दपाईन आराम भेटना. ");
INSERT INTO ahr_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","यार्देनना तिकडे उगवतीले आर्णोन खोरापाईन हर्मोन पर्वतपावोत ज्या देश इस्त्राएल लोकेसनी लढीसनं काबीज कर; त्यासना राजासना नाव हया शेतस; ");
INSERT INTO ahr_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","आर्णोन खोरानं कडाले अरोएर नगरपाईन अनी त्याच खोरामां मजारमाईन अम्मोनी लोकेसना सीमावर यब्बोक नदीपावोत ज्या आर्धा गिलादवार, ");
INSERT INTO ahr_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","अनी पुर्वेले किन्नेरोथ सरोवरपाईन बेथ-याशिमोथना वाटवरला सपाटीपावोत म्हणजे क्षारसमुद्रपावोत ज्या प्रांत अनी दक्षिणले पिसगाना उतरतीपावोत बठा परदेश यासवर अमोर्‍यासना राजा हेशबोननिवासी सीहोन यानी सत्ता व्हती; ");
INSERT INTO ahr_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","अवशिष्ट राहेल रेफाई लोकेसमाधला बाशानना राजा ओग, हावु अष्टरोथ अनी एद्रई आठे राहे; ");
INSERT INTO ahr_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","हर्मोन पर्वत, सलका, गशुरी अनी माकाथी यासना सीमापावोत बठा बाशान प्रांत अनी हेशबोनना राजा सीहोन याना मुलूखनी सीमा आठेपावोत त्यानी सत्ता आर्धा गिलादवर व्हती. ");
INSERT INTO ahr_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","परमेश्वरना सेवक मोशे अनी इस्त्राएल लोक यासनी त्याना मोड करं व्हतं; अनी परमेश्वरना सेवक मोशे यानी त्याना देश रऊबेनी, गादी अनी मनश्शाना आर्धा वंश यासले वतन करी दिद व्हत. ");
INSERT INTO ahr_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","यार्देनना पश्चिमले लबानोन खोरामां बालगादपाईन सेईराले जाणारा घाटमां हालाक पर्वतपावोत ज्या राजासना देश व्हतात अनी ज्यासले यहोशवा अनी इस्त्राएल लोक हयासनी मारं त्यासना नावे हया शेतस; हया देश यहोशवानी इस्त्राएल लोकेसना वंशप्रमाणे अनी विभागप्रमाणे त्यासले वतनदाखल वाटी दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","हित्ती, अमोरी, कनानी, परिज्जी, हिव्वी, यबूसी हया डोंगराळ परदेश, तळवट अराबा, उतरण, रान अनी दक्षिण देश यामा राही राहिंतात. ");
INSERT INTO ahr_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","यरीहोना राजा एक, बेथेलना बाजुले ज्या आय नगर त्याना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","यरुशेलमना राजा एक, हेब्रोनना राज एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","यर्मुथना राजा एक, लाखाशीना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","एग्लोनना राजा एक, गेजेरना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","दबीरना राजा एक, गेदेरना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","हर्माना राजा एक, अरादना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","लिब्नाचा राजा एक, अदुल्लामना राज एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","मक्केदाना राजा एक, बेथेलना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","तप्पुहाना राजा एक, हेफेराना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","अफेकना राजा एक, लशारोनना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","मादोनना राजा एक, हासोरना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","शिम्रोनमरोनना राजा एक, अक्षाफाना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","तानखाना राजा एक, मगिद्दोनना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","केदेशाना राजा एक, कर्मेलाना जोडेना यकनामाना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","दोरना डोंगरळवटीमाधला दोरना राजा एक, गिलगालना राष्ट्रना राजा एक, ");
INSERT INTO ahr_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","तिरसाना राजा एक; हया बठा राजा एकुण एकतीस व्हतात. ");
INSERT INTO ahr_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","यहोशवा आते भलता धैयडा अनी उतार वयना व्हयेल व्हता, तवय परमेश्वर त्याले बोलना, “तु धैयडा अनी उतार वयना व्हयी जायेल शे अनी देशना बराच भाग आजुन ताबामां लेवानं राहेल शे. ");
INSERT INTO ahr_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","ज्या परदेश बाकी राहेल शेतस त्या हया; पलिष्टीसना बठा परदेश, बठा गशुरी; ");
INSERT INTO ahr_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","मिसरनामोरेना शीहोर नदीपाईन उत्तरपावोत एक्रोनना सीमापावोत कनान्यासना म्हणीसनं ज्या मोडेल शेतस त्या प्रांत, तशेच पलिष्टीसना पाच सुभा म्हणजे गज्जा, अश्दोद, अष्कलोन, गथ अनी एक्रोन; यानाशिवाय, दक्षिणकडला अव्वी, ");
INSERT INTO ahr_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","अफेक अनी अमोर्‍यासनी सरहद्द आठेपावतना कनान्यासना बठा देश अनी सीदोन्यासना मारा नावना देश; ");
INSERT INTO ahr_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","अनी गिबली यासना देश तसच उगवतीकडला हर्मोन पर्वतना तळपाईन, बाल-गादपाईन हमाथाना घाटपावोत बठा लबनोन. ");
INSERT INTO ahr_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","लबानोनपाईन मिस्रोपोथ-माईमपावोत सीदोन्यासना डोंगराळ देशना रहीवाशी यासले मी इस्त्राएल लोकसनामोरे हाकली दिसू; एवढं मात्र तु कर की मनी आज्ञाप्रमाणे चिठया टाकीसनं त्यासना देश इस्त्राएल लोकेसले वाटी देय. ");
INSERT INTO ahr_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","हाई देश नऊ वंश अनी मनश्शना आर्धा वंश यासले वतनदाखल वाटी देय.” ");
INSERT INTO ahr_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","मनश्शना बाकीना आर्धा वंश अनी रऊबेनी अनी गादी यासले वतनना वाटा मिळीसनं चुकेल शे; परमेश्वरना सेवक मोशे यानी पुर्वले यार्देननातिकडे त्यासले आपूण करेल ठरावप्रमाणे वतन दिध. ");
INSERT INTO ahr_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","म्हणजे आर्णोन खोरानं बाजुले जे अरोएर शे अनी खोरामाधला नगर आठेतीन गिबोनपावोत मेदबाना बठा पठारना परदेश, ");
INSERT INTO ahr_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","अमोर्‍यासना हद्दपावोत हेशबोननिवासी अमोर्‍यासना राजा सीहोन याना बठा नगर, ");
INSERT INTO ahr_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","गिलाद देश, गशुरी अनी माकाथी यासना बठा प्रांत, हर्मोन पर्वत अनी सलकापावोत बठा बाशान देश; ");
INSERT INTO ahr_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","म्हणजे रेफाईतमा जो एकठाच वाचेल अष्टरोथ अनी एद्रई आठे राज्य करणारा ओग याना बठा राज्य, तठे बठासना मोशेनी मोड करीसनं त्यासले देशमाईन घालाडी दिध व्हतं. ");
INSERT INTO ahr_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","तरी इस्त्राएल लोकसनी गशुरी अनी माकाथी यासले त्यासना देशमाईन घालानं नही म्हणीसनं गशुरी अनी माकाथी आजपावोत इस्त्राएलमां वस्ती करीसनं राही राहीना शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","लेवी वंशासले मात्र त्यानी कोणतच वतन दिद नही, कारण इस्त्राएलना देव यानी सांगाप्रमाणे परमेश्वरले वाहेल हव्ये हाईच त्यासना वतनभाग शे. ");
INSERT INTO ahr_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","मोशेनी रऊबेनी वंशसले त्यासना कुळप्रमाणे वतन दिधा. ");
INSERT INTO ahr_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","त्यासना मुलूख हावु शे; आर्णोन खोराना बाजुले जे अरोएर अनी खोरामाधला नगर यानापाईन मेदबानाजोडेना बठा पठार परदेश; ");
INSERT INTO ahr_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","पठारवरना हेशबोन अनी त्याना बठा नगर, दिबोन, बामोथ-बाल, बेथ-बालमोन; ");
INSERT INTO ahr_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","याहस, कदेमोथ, मेफाथ; ");
INSERT INTO ahr_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","किर्या-थईम, सिब्मा, खोरामाधला बसेल सरेथ शहर; ");
INSERT INTO ahr_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","बेथ-पौर, पिसगानी उतरती, बेथ-याशिमोथ; ");
INSERT INTO ahr_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","अनी माळवरना बठा गाव, म्हणजे हेशबोनमां राज्य करणारा अमोर्‍यासना राजा सीहोन याना बठा राज्य; या राजाले मोशेनी ठार मारं, अनी त्यानासंगे त्या देशमां राहानारा सिहोनना अधिपति अनी मिद्द्यानसना सरदार अवी, रेकेम, सूर, हूर अनी रेबा यासलेबी त्यानी मारं. ");
INSERT INTO ahr_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","इस्त्राएल लोकेसनी तलवारघाई ज्यासना संहार करं त्यामाच बौरना पोर्‍या बलाम दैवज्ञ यासनाबी वध करं. ");
INSERT INTO ahr_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","रऊबेन यानी सीमा यार्देनना काठले ठरनी, रऊबेनी यासना वतनभाग त्यासना कुळप्रमाणे नगर अनी गाव हयासलेबी हाईच ठरनं. ");
INSERT INTO ahr_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","मंग मोशेनी गाद वंशनीसंगे त्यासना कुळप्रमाणे वतन दिधं. ");
INSERT INTO ahr_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","त्यासना मुलूख हाई शे; याजेर, गिलादांतली बठा नगर; अनी राब्बासनामोरेना अरोएरापावोत अमोर्‍यासना आर्धा देश; ");
INSERT INTO ahr_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","हेशबोनापाईन रामाथमिस्पापावोतना परदेश, बतोनीम महनाईमापाईन दबीरना हद्दपावोतना परदेश; ");
INSERT INTO ahr_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","खोरामाधला बेथहाराम , बेथ-निम्रा, सक्कोथ, साफोन, म्हणजे हेशबोनाना राजा सीहोन याना राज्यना अवशिष्ट भाग अनी यार्देनना काठनं किन्नेरोथ सरोवरपावोत यार्देनना पुर्वेना परदेश. ");
INSERT INTO ahr_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","गादी यासनं वतन त्यासना कुळप्रमाणे नगर अनी गाव यानासंगे हाईच ठरनं. ");
INSERT INTO ahr_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","मंग मोशेनी मनश्‍शना आर्धा वंशले वतन दिद व्हतं ते मनश्शना आर्धा वंशले त्याना कुळप्रमाणे व्हतं. ");
INSERT INTO ahr_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","त्यासना मुलूख हाई; महनाईमापाईन बठा बाशान देश म्हणजे बाशानना राजा ओग याना बठा राज्य अनी बाशानमाधला याईरना साठ नगर; ");
INSERT INTO ahr_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","गिलादना आर्धा भाग, अनी बाशानना राजा ओग याना राज्यमाधला अष्टरोथ अनी एद्रई या नगरे मनश्शना पोर्‍या माखीर याना वंशना म्हणजे माखीरना आर्धा वंशना त्याना कुळप्रमाणे वतन ठरन. ");
INSERT INTO ahr_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","यरीहोनाजोडे यार्देनना पुर्वेले मवाबना मैदानमां मोशेनी वाटी देयल वतन हया शेतस; ");
INSERT INTO ahr_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","पण लेवी वंशले मोशेनी एक बी वतन दिधा नही; इस्त्राएलना देव यहोवा हाऊच त्याना सांगाप्रमाणे त्यासना वतन शे. ");
INSERT INTO ahr_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","एलाजार याजक, नूनाना पोर्‍या यहोशवा अनी इस्त्राएल वंशना पितृकुळना प्रमुख यासनी वाटा पाडी देयेल जे वतनभाग म्हणीसन इस्त्राएल लोकेसले जे भेटनं ते हाई शे; ");
INSERT INTO ahr_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","परमेश्वरनी साडेनऊ वंशनाबारामां मोशेकडतीन देयेल आज्ञाप्रमाणे त्यासना वतनभाग चिठया टाकीसनं वाटं. ");
INSERT INTO ahr_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","अडीच वंशसले मोशेनी यार्देनना पुर्वले वतन देयेल व्हतच; पण लेवी वंशसले त्यासनासंगे काहीएक वतन देयल नव्हतं. ");
INSERT INTO ahr_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","योसेफना वंशना दोन शाखा व्हयेल व्हत्यात, त्या मनश्शे अनी एफ्राईम हया व्हत्यात; पण त्या देशमां लेवीसले काही विभाग दिधा नही; पण राहावाले नगर अनी जनावर अनी धन याकरता काही शिवार देयेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","परमेश्वरनी मोशेले देयेल आज्ञाले अनुसरीसनं इस्त्राएल लोकेसनी तो देश वाटी लिदात. ");
INSERT INTO ahr_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","मंग यहुदा वंशना लोके गिलगालमां यहोशवाकडे ऊनात; अनी कनिज्जी यफुन्नेना पोर्‍या कालेब त्याले बोलना, “परमेश्वरनी देवभक्त मोशे याले तुना बारामां अनी मना बारामां कादेश-बर्ण्यात काय सांग व्हतं ते तुले आठवत व्हयीच; ");
INSERT INTO ahr_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","परमेश्वरना सेवक मोशे यानी माले हाई देश शोध कराले कादेश-बर्ण्यामाईन धाडं; तवय मी चाळीस वरीसना व्हतू अनी मना मनना समजुतप्रमाणे मी त्यानाकडे बातमी आणी; ");
INSERT INTO ahr_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","पण मना भाऊ मनासंगे जायेल व्हतात त्यासनी लोकेसनी कायीजमां पानी पानी व्हयी अस करं; मी मात्र आपला देव यहोवा यानं सर्वाकाही अनुसरीसनं करं. ");
INSERT INTO ahr_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","तवय त्या रोजले मोशेनी आणभाक करीसनं माले सांग की तु मना देव यहोवा यानं अनुसरनं करं म्हणीसनं ज्या भुमीले तुना पाय लागेल शे ती तुनी अनी तुना वंशनं कायमनं वतन व्हयी. ");
INSERT INTO ahr_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","आते दख, परमेश्वरनी मोशेले हाई सांगं ती बातले पंचेचाळीस व्हयेल शेतस, एवढा येळमां इस्त्राएल लोक जंगलमां भटकत व्हतात तवय परमेश्वरनी आपला वचनप्रमाणे माले जीवत ठेयेल शे अनी मी आज पंचाऐंशी वरीसना व्हयेल शे. ");
INSERT INTO ahr_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","मोशेनी माले धाडं त्या रोज मनामां जेवढी शक्ती व्हती तेवढी आज बी शे; लढाई करानी अनी येजा करानी ताकद मनामां जशी त्या येळली व्हती तशी आज बी शे. ");
INSERT INTO ahr_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","तर त्या येळले परमेश्वरनी सांगाप्रमाणे हावु डोंगर माले दे; त्या येळले तु एकलाच व्हता की, तठे अनाकी लोके राहीसनं तठेना नगर मोठमोठा अनी तटबंदी शेतस; आते परमेश्वर माले सहाय्यक राहीना तर त्याना सांगाप्रमाणे मी त्याले तठेतुन हाकली दिसू.” ");
INSERT INTO ahr_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","तवय यहोशवानी त्याले आशिर्वाद दिद; अनी यफुन्नेना पोर्‍या कालेब याले हेब्रोन नगर वतन करी दिद; ");
INSERT INTO ahr_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","हाई परकारं आजपावोत कनिज्जी यफुन्नेना पोर्‍या कालेब याना हेब्रोन हाई वतन व्हयेल शे; कारण तो इस्त्राएलना देव यहोवा याले पुर्णपणे अनुसरना. ");
INSERT INTO ahr_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","आगोदर हेब्रोनना नाव किर्याथ-आर्बा‍‍ व्हतं; हाई आर्बा अनाक्यामां भलता थोर माणुस व्हयीसन गया, त्यानंतर त्या देशमां युध्दपाईन विसावा भेटनं. ");
INSERT INTO ahr_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","यहुदा वंशले त्यासना कुळप्रमाणे चिठया टाकीसनं जो भाग भेटना तो अदोमना सीमापावोत अनी दक्षिणले सीन जंगलपावत जोडेच दक्षिणनना हदद्पावोत पसरेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","त्यासना दक्षिण सीमाले क्षारसमुद्रना दक्षिणले खाडीपाईन सुरु व्हयनं; ");
INSERT INTO ahr_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","ती तशीच अक्राबीम नावनी चढतीले दक्षिणले निघीसनं सीन जंगलना कडाले कादेश-बर्ण्याना दक्षिणले जाईसनं हेब्रोनना जोडेतीन अद्दारवरतीन जाईसनं कर्काकडे वळेल शे; ");
INSERT INTO ahr_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","तठेतीन ती सीमा असमोनाले जाईसनं मिसरना नालापावत निघेल शे; तिना शेवट समुद्रनाजोडे व्हयेल शे; तुमनी दक्षिण सीमा हाईच शे. ");
INSERT INTO ahr_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","त्यासनी पुर्व सीमा यार्देनना मुखपावोत क्षारसमुद्र ठरेल शे. उत्तर सीमा यार्देनना तोंडनाजोडे समुद्रना खाडीपाईन सुरु व्हयीसनं, ");
INSERT INTO ahr_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","बेथ हाग्लाना चढतीवरतीन जाईसनं बेथ अराबना उत्तरले रऊबेनी बोहनना खडकपावोत जायेल शे; ");
INSERT INTO ahr_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","तठेतीन ती सीमा आखोर खोरापाईन दबीरपावोत जाईसनं उत्तरले गिलगालकडे वळेल शे; हाई गिलगाल नदीना दक्षिणले अदुम्मीमाना चढावनीमोरे शे, मंग ती सीमा एन-शेमेश नावना झरानीजोडेतीन जाईसन तिना शेवट एनरोगेलासले व्हस. ");
INSERT INTO ahr_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","तठेतीन ती सीमा हिन्नोम पोर्‍यासना खिंडमाईन यबूसी चढतीना दक्षिण भागवर म्हणजे यरुशेलम चढी जाईसनं पश्चिमले हिन्नोमाना खोरानीमोरे अनी रेफाईम खोराना उत्तरना टोकले जे पहाडना माथावर जाईसनं पोचेल शे; ");
INSERT INTO ahr_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","तठेतीन ती सीमा त्या पहाडना माथापाईन नफ्तोहाना झरापावोत जासं अनी एफ्रोन डोंगरवरना नगरवरतीन निघीसनं तठेतीन बाला ऊर्फ किर्याथ-यारीम आठेपावत जास. ");
INSERT INTO ahr_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","तठेतीन ती सीमा बालाना पश्चिमले वळसा लिसनं सेईर डोंगरले लागीसनं यारीम ऊर्फ कसालोन डोंगरना उत्तर बाजुले जाईसनं बेथ-शेमेश आठे उतरसं अनी तशीच तिम्नाकडे निघसं; ");
INSERT INTO ahr_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","तठेतीन ती सीमा एक्रोनना उत्तर भागवरतीन शिक्रोनपावोत जायेल शे अनी बाला पहाडवरतीन यबनेलास निघेल शे; या सीमानी शेवट समुद्रनी काठले व्हसं. ");
INSERT INTO ahr_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","पश्चिमनी सरहद्द महासमुद्रना किनारा शे, यहुदा वंशले त्यासना कुळप्रमाणे जो भाग मिळना त्यानं हया चतु:सीमा शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","यफुन्नेना पोर्‍या कालेब याले परमेश्वरनी सांगाप्रमाणे यहोशवानी यहुदाना वंशनासंगे वतन दिधा ते म्हणजे किर्याथ-आर्बा ऊर्फ हेब्रोन शे; हाऊ आर्बा अनाकना बाप. ");
INSERT INTO ahr_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","कालेबनी शेशय, अहीमान अनी तलमय या अनाकना तिनी पोर्‍यासले तठेतीन घालाडी दिद. ");
INSERT INTO ahr_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","तठेतीन त्यानी दबीरना रहीवाशासवर हल्ला करा; दबीरना आगोदरना नाव किर्याथ-सेफर व्हत. ");
INSERT INTO ahr_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","कालेब बोलना, “जो कोनी किर्याथ-सेफर लढीसनं काबीज करी त्याले मी मनी पोर अखसा हिले दिसू.” ");
INSERT INTO ahr_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","त्यावरतीन कालेबना भाऊ कनाज याना पोर्‍या अथनिएल यानी ते नगर लिधं; तवय कालेबनी आपली पोर अखसा हिले त्याले बायको करी दिधी. ");
INSERT INTO ahr_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","ती ऊनी तवय आपला वडीलपाईन काही जमीन लेवानी भर तिनी त्याले दिधी. ");
INSERT INTO ahr_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","ती बोलनी, “माले एक देणगी दे; तु माले दक्षिणकडली जमीन देयल शेच; माले पाणीना झरा बी देय;” तवय त्यानी वरला अनी खालना झरा तिले दिधा. ");
INSERT INTO ahr_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","यहुदा वंशना कुळनासारखा जो त्यासना वतनभाग ठरनं तो हाई शे; ");
INSERT INTO ahr_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","यहुदाना वंशासले दक्षिणले अदोमना सीमानाजोडेना नगर भेटनात त्या हया शेतस; कबूसेल, एदेर अनी यागूर; ");
INSERT INTO ahr_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","कीना, दीमोना अनी अदादा; ");
INSERT INTO ahr_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","केदेश, हासोर अनी इथनान; ");
INSERT INTO ahr_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","जीफ, टेलेम अनी बालोथ; ");
INSERT INTO ahr_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","हासोर-हदत्ता अनी करीयोथ-हस्रोन (हाईच हासोर) ");
INSERT INTO ahr_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","अमाम; शमा अनी मोलादा; ");
INSERT INTO ahr_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","हसर-गदा, हेष्मोन अनी बेथ-पेलेट; ");
INSERT INTO ahr_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","हसर-शुवाल, बैर-शेबा अनी बिजोथा; ");
INSERT INTO ahr_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","बाला, ईयीम अनी असेम; ");
INSERT INTO ahr_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","एल्तोलाद, कसील अनी हर्मा; ");
INSERT INTO ahr_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","सिकलाग, मह्‍न्ना अनी सन्सन्ना ");
INSERT INTO ahr_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","लवावोथ, शिलहीम, अईन अनी रिम्मोन; या बठा नगर मिळीसनं एकोणतीस अनी त्यासना गाव. ");
INSERT INTO ahr_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","तळवटना नगर हया शेतस: एष्टोवोल, सरा अनी अषणा; ");
INSERT INTO ahr_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","जानोह, गेन-गन्नीम, तप्पुहा अनी एनाम; ");
INSERT INTO ahr_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","यर्मुथ, अदुल्लाम, सोखो अनी अजेका; ");
INSERT INTO ahr_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","शारईम, अदीथईम, गदेरा अनी गदेरोथईम; आशा चौदा नगर अनी त्यासना गावं. ");
INSERT INTO ahr_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","सनान, अनी हदाशा अनी मिग्दल-गाद; ");
INSERT INTO ahr_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","दिलान, मिस्पा अनी यकथेल; ");
INSERT INTO ahr_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","लाखीश, बसकाथ अनी एग्लोन; ");
INSERT INTO ahr_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","कब्बोन, लहमाम अनी किथलिश; ");
INSERT INTO ahr_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","गदेरोथ, बेथ-दागोन, नामा अनी मक्केदा अस सोया नगर अनी त्यासना गाव. ");
INSERT INTO ahr_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","लिब्ना, एतेर अनी आशान; ");
INSERT INTO ahr_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","इफताह, अष्णा अनी नसीब; ");
INSERT INTO ahr_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","कईला, अकबीज अनी मारेशा; अस नऊ नगर अनी त्यासना गाव. ");
INSERT INTO ahr_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","एक्रोन अनी त्याना खेडापाडा; ");
INSERT INTO ahr_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","एक्रोननाजोडे अनी पश्चिमनं अश्दोदानना बाजुना बठा नगर अनी त्यासना गाव. ");
INSERT INTO ahr_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","अश्दोद अनी त्यासनं खेडापाडा; गज्जा अनी त्यासना खेडापाडा; मिसरना नाला अनी महासमुद्रना काठना नगर. ");
INSERT INTO ahr_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","अनी डोंगरवटना हया नगर शेतस; शामीर, यत्तीर अनी सोखो; ");
INSERT INTO ahr_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","दन्ना, किर्याथ अनी सन्ना उर्फ दबीर; ");
INSERT INTO ahr_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","अनाब, एष्टमो अनी अनीम; ");
INSERT INTO ahr_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","गोशेन, होलोन, अनी गिलो, अस आकरा नगर अनी त्यासना गाव. ");
INSERT INTO ahr_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","अराब, दूमा अनी एशान; ");
INSERT INTO ahr_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","यानीम, बेथतप्पुहा अनी अफेका; ");
INSERT INTO ahr_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","हुमटा किर्याथ-अर्बा ऊर्फ हेब्रोन अनी सियोर; अस नऊ नगर अनी त्यासना गाव. ");
INSERT INTO ahr_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","मावोन, कर्मेल, जीफ अनी युटा; ");
INSERT INTO ahr_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","इज्रेल, यकदाम अनी जानोह; ");
INSERT INTO ahr_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","काइन, गिबा अनी तिम्ना; अस दहा नगर अनी त्यासना गाव. ");
INSERT INTO ahr_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","हल्हुल, बेथ-सूर, गदोर; ");
INSERT INTO ahr_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","माराथ, बेथ-अनोथ अनी एकतकोन; अस सवू नगर अनी त्यासना गाव. ");
INSERT INTO ahr_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","किर्याथ-बाल म्हणजे किर्याथ यारीम अनी राब्बा हया दोन नगर अनी त्यासना गाव. ");
INSERT INTO ahr_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","रानमाधला हया नगर शेतस; बेथ-अराबा, मिद्दीन अनी सखाखा; ");
INSERT INTO ahr_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","निबशान, क्षारनगर अनी एन-गेदी; अस सवू नगर अनी त्यासना गाव. ");
INSERT INTO ahr_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","यरुशेलमां राहानारा यबुशी लोकेसले यहुदाना वंशासले घालाडता ऊनं नही; अनी आजपावोत यबुशी लोक यरुशेलमा यहुदानासंगे राही राहीना शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","योसेफनं वंशनं जे भाग चिठया टाकीसनं ठरायेल व्हतं ते हाई शे: त्यानी सीमा यरीहोनाजवय यार्देन नदीपाईन पुर्वतीन यरीहोना जलसंचयपान जाईसनं जंगलमां पहाडी प्रदेशमाईन बेथेलले जासं; ");
INSERT INTO ahr_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","तठेतीन ती लूज आठे जाईसनं अर्कीना सीमापाईन अटारोथ आठे जास; ");
INSERT INTO ahr_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","पश्चिमले यफलेटी यासन्या सरहद्दपाईन खालनं बेथ-हारोन अनी गेजेर आठे उतरीसनं समुद्रनी सीमापान जासं. ");
INSERT INTO ahr_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","योसेफना पोर्‍या मनश्शे अनी एफ्राईम यासनी आपआपलं वतन लिधं. ");
INSERT INTO ahr_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","एफ्राईम वंशाची सरहद्द ज्यान्या त्यान्या कुयप्रमाणे ठरनी ती आशी; त्यासन्या वतनना सरहद्दले पुर्वेले सुरुवात व्हयीसनं अटारोथ अद्‍दार आठेतीन वरनी बेथ-हारोनले जासं; ");
INSERT INTO ahr_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","उत्तर सीमा पश्चिमले मिखमथाथ आठे सुरु व्हयीसनं पुर्वले वळसा लिसनं तानथशिलो आठे जासं अनी तठेतीन मोरे निघीसनं यानोहा आठेपावत जासं; ");
INSERT INTO ahr_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","अनी यानोहा आठेतीन ती आटारोथ अनी नारा आठे उतरीसनं यरीहोपान यार्देनपान निंघस. ");
INSERT INTO ahr_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","हाई सीमा तप्पुहा आठेतीन निघीसनं पश्चिम दिशाले जाईसनं काना नालावरतीन समुद्रपान जासं; एफ्राईमना वंशसनं त्यासना कुयप्रमाणे वतन हाई शे: ");
INSERT INTO ahr_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","तशेच मनश्शेना वंशसना वतनमाईन नगरे आस-पासना खेडापाडासनीसंगे एफ्राईमना वंशकरता येगळी करीसनं ठेवामां वनात. ");
INSERT INTO ahr_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","गेजेरमां ज्या कनानी लोके राहात व्हतात त्यासले एफ्राईमनी घालाडं नही म्हणीसनं त्या कनानी त्यासमां आजपावोत वस्ती करी राहीना शेतस; त्या दास व्हयीसनं बिगारकाम करनारा व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","योसेफना वडील पोर्‍या मनश्शे याना वंशना भाग चिठया टाकीसनं ठरावं ते हाई शे: माखीर हाऊ वडील पोर्‍या गिलादना बाप व्हतां, हाऊ मोठा योध्दा व्हता म्हणीसनं त्याले गिलाद अनी बाशान हाई प्रांत भेटनं. ");
INSERT INTO ahr_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","मनश्शेना बाकीना वंशसले त्यासना कुळ‍प्रमाणे जो भाग भेटना तो अशा; अबिजेयेर, हेलेक, अस्रियेल, शेखेम, हेफेर अनी शमीदा हया आपआपला कुळप्रमाणे योसेफना पोर्‍या मनश्शे याना वंशमाधला ज्या माणसे व्हतात, त्यासन्या येगयेगळ्या कुळप्रमाणे ह्या विभाग ठरनात; ");
INSERT INTO ahr_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","पण सलाफहाद बिन हेफेर बिन गिला बिन माखीर बिन मनश्शे याले पोर्‍यासोरे नही व्हतात. पोरी व्हत्यात, त्या पोरीसना नाव महला, नोआ, हाग्ला, मिल्का अनी तिरसा ह्या व्हत्यात. ");
INSERT INTO ahr_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","एलाजार याजक, नूनाना पोर्‍या यहोशवा अनी सरदार मंडयी यासनामोरे या पोरी यिसनं बोलन्यात, परमेश्वरनी मोशेले आज्ञा देयेल व्हती त्याप्रमाणे आमले आमना भाऊबंदासमां वतन दया; तवय यहोशवानी परमेश्वरनी आज्ञाप्रमाणे त्यासले त्यासना बापना भाऊबंदसनीसंगे वतन दिध. ");
INSERT INTO ahr_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","असा प्रकारे यार्देनना तिकडे गिलाद अनी बाशान या प्रांतासनासंगे मनश्शेले दहा भाग भेटनात; ");
INSERT INTO ahr_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","कारण मनश्शेना वंशमासल्या बायासले त्यासन्या पुत्रसंततीनासंगे वतन भाग भेटनं अनी मनश्शेना वंशना बाकिना बी लोकसले गिलाद प्रांत भेटना. ");
INSERT INTO ahr_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","मनश्शेनी सीमा आशेरपाईन शखेमासमोरनी मिखमथाथापावोत जास; अनी मोरे ती उजवी बाजुले एन-तप्पुहाना लोकवस्तीपावोत जाईसनं भिडसं. ");
INSERT INTO ahr_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","तप्पुहाना प्रांत मनश्शना व्हता; पण मनश्शेना सीमापान तप्पुहा नगर हाई एफ्राईमनं व्हतं. ");
INSERT INTO ahr_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","तठेतीन ती सीमा काना नालापावत उरतरीसनं त्याना दक्षिणले भिडसं; तठेतीन मनश्शेना प्रांतमां काही नगर एफ्राईमना व्हतात; आजून मनश्शानी सीमा त्या ओहळना उत्तरले जाईसनं समुद्रपावोत जासं; ");
INSERT INTO ahr_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","दक्षिणकडला परदेश एफ्राईमना अनी उत्तरकडला मनश्शाना, त्यानी सीमा समुद्र शे; त्याना उत्तर सीमाले आशेर अनी पुर्वले इस्साखार शे. ");
INSERT INTO ahr_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","इस्साखार अनी आशेर यासना प्रांतमां मनश्शेना गाव व्हतं ते अस: बेथ-शान अनी त्याना खेडापाडा, इब्लाम अनी त्याना खेडापाडा; दोर आठेनी लोकवस्ती अनी त्याना खेडापाडा; एन-दोरनी लोकवस्ती अनी त्याना खेडापाडा; तानख आठेनी लोकवस्ती अनी त्यानी खेडीपाडी; मगिद्दो अनी त्यानी खेडीपाडी अनी त्यासन्या रहीवाशासनीसंगे तीन टेकडया; ");
INSERT INTO ahr_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","पण हाई नगरना रहीवाशासले मनश्शना वंशसले घालाडाता ऊनं नही; त्या देशमांस राहावानं हट्ट कनान्यासनी धरं. ");
INSERT INTO ahr_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","इस्त्राएल लोके समर्थ व्हयनात तवय त्यासनी त्या कनानी लोकेसले बिगारकाम कराले लावं, बठासले हाकलं नही. ");
INSERT INTO ahr_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","योसेफ वंशसनी यहोशवाले बोलनात, परमेश्वरना आमनावर आजपावोत प्रसाद राहावामुये आम्हीन संख्यातीन बराच शेतस तर तु चिठी टाकीसनं आमले वतनना एकच भाग का बर दिध? ");
INSERT INTO ahr_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","यहोशवा त्यासले बोलना, तुम्हीन संख्यातीन बराच शेतस अनी एफ्राईमना डोंगराळ परदेश तुमले पुरस नही तर परिज्जी अनी रेफाई यासना देशमाधला जंगल तोडीसनं तठे वस्ती करा. ");
INSERT INTO ahr_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","तवय योसेफना वंश बोलनात, हाई डोंगराळ परदेश आमले पुरस नही; बेथ-शान अनी त्याना आसपासना खेडापाडा अनी इज्रेल खोरं, या तलप्रांतमां राहानारा कनानी लोकेसपान लोखंडी रथ शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","यहोशवानी योसेफना वंशसले म्हणजे एफ्राईम अनी मनश्शे यासले सांग, तुम्हीन संख्यातीन बराच शेतस अनी तुमना सामर्थ्यबी मोठ शे; तुमले फक्त एकच विभाग भेटी अस नही. ");
INSERT INTO ahr_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","तर तो पहाडी देश तुमना‍ व्हयी; तठे जंगल शे ते तोडा म्हणजे त्याना आसपासना देश तुमना व्हयी. कनानी लोकेसपान लोखंडी रथ व्हतीन अनी त्या बलिष्ट व्हतीन तरीबी तुमले त्यासले घालाडाता येई. ");
INSERT INTO ahr_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","मंग इस्त्राएलनी बठी मंडयी शिलो आठे एकजागे व्हयनी अनी तठे‍ त्यासनी देवनं दर्शनमंडप उभं करं; आते बठा देश त्यासना हातमां येयल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","इस्त्राएल लोकेसमाईन ज्यासले वतनभाग भेटनं नही अस सात वंश राहेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","यहोशवा इस्त्राएल लोकेसले बोलना, “तुमना पुर्वजना देव यहोवा यानी तुमले जो देश दिध तो आपला ताबामां लेवानाबारामां तुम्हीन कोठपावोत येळ लावशात? ");
INSERT INTO ahr_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","परतेक वंशमाधला तीन माणसे नेमा म्हणजे मी‍य त्यासले धाडंस; त्यासनी जाईसनं चारीमेर फिरीसनं देश दखानं, अनी आप आपला वंशासले मिळानं वतनभागना वर्णन लिखीसनं मनाकडे लयी येवानं. ");
INSERT INTO ahr_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","त्यासनी उरेल देशना सात भाग रेखाटानं; यहुदानी दक्षिणकडला आपला नेमेल वतनभागमां वस्ती करानी अनी योसेफना वंशसनी उत्तरले आपला वतनभागमां वस्ती करानी. ");
INSERT INTO ahr_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","त्या देशना सात भागनी माहीती काढीसन ते वर्णन मनाकडे लयी येवानं म्हणजे मी आठे आपला देव यहोवा यानामोरे तुमना नावसनी चिठी टाकसू. ");
INSERT INTO ahr_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","लेवीसले तर तुमनामां वतनभाग नही; परमेश्वरनी त्यासले देयेल याजकवृत्ती हाईच त्यासना वतन शे; गाद, रऊबेन अनी मनश्शेना आर्धा वंश यासले यार्देनना पुर्वले वतन भेटी चुकेल शे; परमेश्वरना सेवक मोशे यानी त्यासले ते देयेल शे.” ");
INSERT INTO ahr_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","मंग त्या माणसे मार्गस्थ व्हयनात; तवय त्या देशना वर्णन लिखाले ज्या जाणार व्हतात त्यासले यहोशवानि आज्ञा दिधी की, “जा अनी इकडे तिकडे फिरा अनी त्याना वर्णन लिखीसनं मनाकडे लयी या अनी म्हणजे मी शिलो आठे परमेश्वरनामोरे तुमन्या नावन्या चिठया टाकसू.” ");
INSERT INTO ahr_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","तवय त्या माणसे तठेतीन निघीसनं देशभर फिरनात अनी तठेना नगरप्रमाणे त्यासन्या सात वाटयासन्या वर्णन त्यासनी वहीमां लिखीसनं त्या बठा शिलो आठे छावनीमां यहोशवाकडे लयात. ");
INSERT INTO ahr_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","शिलो आठे परमेश्वरनामोरे यहोशवानी त्यासन्या नावन्या चिठया टाक्यात; त्या ठिकाणले यहोशवानी इस्त्राएल लोकेसले‍ ज्याना त्याना वतनप्रमाणे जमीन वाटी दिधी. ");
INSERT INTO ahr_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","बन्यामिनना वंशले त्यासना कुयप्रमाणे चिठी टाकीसनं जो वाटा भेटना तो आशा: त्याना वाटा यहुदाना वंश अनी योसेफना वंश यासना प्रांतले लागीसनं व्हता. ");
INSERT INTO ahr_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","त्यासनी उत्तर सीमा यार्देननाजोडे सुरु व्हसं व्हयीसनं यरीहोना उत्तरकडतीन वर जाईसनं पश्चिमले डोंगरवरतीन बेथ-आवेनना जंगलमां निघसं; ");
INSERT INTO ahr_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","तठेतीन ती लूज ऊर्फ बेथेल आठे येस अनी लूजन दक्षिण बाजुतीन निघीसनं खालना बेथ-हारोनना दक्षिणले पहाडपाईन अटारोथ-अदार आठे निघस. ");
INSERT INTO ahr_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","तठेतीन पश्मिम सीमाले वळसा घालीसनं बेथ-हारोनना मोरेतीन त्याना दक्षिणकडला पहाडवरतीन यहुदा नगर किर्याथ-बाल ऊर्फ किर्याथ-यारीम आठे निंघसं; यानी पश्चिम सीमा हाईच शे. ");
INSERT INTO ahr_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","दक्षिणनी सीमा पश्चिमले सुरु व्हईसन किर्याथ-यारीमना वरन टोकपाईन निंघीसनं नफ्तोह झरापान जासं. ");
INSERT INTO ahr_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","तठेतीन हिन्नोमपुत्रसना खिंडनासमोरतीन अनी रेफाई खिंडना उत्तरले जो पहाड शे त्याना उत्तर टोकपाईन हिन्नोम खिंडमां म्हणजे यबूसीना दक्षिण बाजुतीन ती सीमा एनरोगेलासले आठे उतरसं. ");
INSERT INTO ahr_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","तठेतीन ती सीमा उत्तरले वळसा लिसनं एन-शेमेश आठे निंघसं अनी तशीच अदुम्मीम चढावनामोरे जे गलीलोथ शे तिकडे जासं; तठेतीन ती रऊबेनपुत्र बोहन याना खडककडे जास. ");
INSERT INTO ahr_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","मंग ती उत्तरले जाईसनं मैदाननामोरे यार्देनना घाटमा उतरसं. ");
INSERT INTO ahr_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","तठेतीन ती सीमा बेथ-हाग्लाना उत्तर दिशाले जाईसनं क्षारसमुद्रना उत्तरनी घाटपान यार्देनना दक्षिण मुखपान निंघसं; हाई दक्षिण सीमा शे. ");
INSERT INTO ahr_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","त्यानी पुर्व सीमा यार्देन शे. बन्यामिनना वतनभाग त्यानी चतु:सीमासहीत त्याना कुयप्रमाणे हाई शे. ");
INSERT INTO ahr_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","बन्यामिन वंशना लोकेसले त्यानसा त्यासना कुयप्रमाणे हया नगर भेटनात; यरीहो, बेथ-हाग्लाना, एमेकक-केसास, ");
INSERT INTO ahr_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","बेथ-अराबा, समाराईस, बेथेल, ");
INSERT INTO ahr_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","अव्वीम, पारा, अफ्रा, ");
INSERT INTO ahr_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","कफर अम्मोनी, अफनी, अनी गेबा; हया बारा नगर अनी त्यासना आसपासना गाव; ");
INSERT INTO ahr_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","गिबोन, रामा, अनी बैरोथ; ");
INSERT INTO ahr_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","मिस्पा, कफीरा अनी मोजा; ");
INSERT INTO ahr_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","रेकेम, इपैल अनी तरला; ");
INSERT INTO ahr_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","सेला, एलेफ, यबुशी ऊर्फ यरुशेलम, गिबाथ अनी किर्याथ; हया चौदा नगर अनी त्यासना आसपासना गाव; बन्यामिनना वंशना त्यासना त्यासना कुयप्रमाणे हाई वतन शे. ");
INSERT INTO ahr_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","दुसरी चिठी शिमोननी नावनी म्हणजे शिमोनी वंशनी त्याना कुयप्रमाणे निंघनी: यहुदाना वंशना वतनमां त्याले वतन भेटनं, ");
INSERT INTO ahr_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","त्यासले हाई नगर वतन भेटनात; बैर-शेबा नाहीते शेबा अनी मोलादा; ");
INSERT INTO ahr_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","हसर-शुवाल, बाला अनी असेम; ");
INSERT INTO ahr_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","एल्तोलाद, बथुल अनी हर्मा, ");
INSERT INTO ahr_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","सिकलाग, बेथ-मर्का; बोथ अनी हसर सुसा; ");
INSERT INTO ahr_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","बेथ-लबवोथ अनी शारुहेन हया तेरा नगर अनी त्याना आसपासना गाव; ");
INSERT INTO ahr_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","अईन, रिम्मोन, एतेर अनी आशान; हया चार नगर अनी त्याना आसपासना गाव; ");
INSERT INTO ahr_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","अनी बालथ-बैर, ज्याले दक्षिण देशना रामा म्हणतसं तठेपावोत या नगरना आजुबाजूना बठा गाव त्यासले भेटनात; शिमोनी वंशसले त्यासना कुयप्रमाणे हाईच वतनभाग शे. ");
INSERT INTO ahr_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","शिमोनले यहुदा वंशना वतनभागमांस वाटा दिदा कारण यहुदी वंशना वतन त्यासना संख्याना मानतीन बराच मोठा व्हता, म्हणीसनं त्यासना वतनमां शिमोनी वंशले वतन भेटनं. ");
INSERT INTO ahr_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","तिसरी चिठी जबुलून वंशनी त्यासना कुयपरामाण निंघनी; त्यासनी वतननी सीमा सारीदपावत शे; ");
INSERT INTO ahr_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","त्यासनी सीमा पश्चिमले मरलापावोत जाईसनं दब्बेशेथ आठे येस अनी यकनामानामोरे नालाले जाईसनं लागस; ");
INSERT INTO ahr_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","ती सारीद आठेतीन पुर्वले उगवतीले वळीसनं किसलोथ-ताबोर यान्या सीमाले लागस; तठेतीन दाबरथ आठे जाईसन याफीयपावत वर जास; ");
INSERT INTO ahr_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","तठेतीन पुर्व दिशाले गथ-हेफेर अनी इत्ता-कासीन आठेपावोत जासं; अनी तठेतीन नेयाजोडे रिम्मोन आठे निंघस; ");
INSERT INTO ahr_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","तठेतीन ती सीमा त्याले वळसा घालीसनं उत्तरले हन्नोथोनपावोत जास अनी तठेतीन एफताह-एल खोरामां सरस; ");
INSERT INTO ahr_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","कट्टाथ, हलाल, शुम्रोन, ईदला, बेथलहेम या बारा नगर अनी त्यासना आसपासना गाव त्यासले दिद. ");
INSERT INTO ahr_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","जबुलून वंशमाधला लोकेसना त्यासना कुयप्रमाणे नगर अनी त्यासना आसपासना गाव हया शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","इस्साखारनी वंशसनी त्यासना कुयप्रमाणे चौथी चिठी निघी. ");
INSERT INTO ahr_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","त्यासनी सीमामां हया नगर व्हतात; इज्रेल, कसुल्लोथ अनी शुनेम; ");
INSERT INTO ahr_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","हफाराईम, शियोन अनी अनाहरथ; ");
INSERT INTO ahr_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","रब्बीथ, किशोन अनी अबेस; ");
INSERT INTO ahr_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","रेमेथ, एन-गन्नीम एन-हद्दा अनी बेथपसेस; ");
INSERT INTO ahr_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","त्यानी सीमा ताबोर, शहसुमा अनी बेथ-शेमेश आठेपावोत जास अनी ती यार्देनपान सरस; त्यासले हया सोया नगर अनी त्यासना आसपासना गाव भेटनात. ");
INSERT INTO ahr_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","इस्साखारना वंशसना त्यासना कुयप्रमाणे नगर अनी त्यासना आसपासना गाव हया शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","पाचवी चिठी आशेर वंशसनी नावनी त्यासन्या कुयप्रमाणे निघी. ");
INSERT INTO ahr_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","त्यासन्या सीमान्या मजारमां हया देश व्हतात: हेलकाथ, हली, बटेन, अनी अक्षाफ; ");
INSERT INTO ahr_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","अल्लामेलेख, आमाद, अनी मिशाल; त्यासनी सीमा पश्चिमले कर्मेल अनी शिहोर-लिब्नाथ आठपावोत जास; ");
INSERT INTO ahr_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","ती वळीसनी उगवतीले बेथ-दागोन आठेपावोत जाईसनं उत्तरले जबुलूनना वतनभागपावोत अनी एफताह-एल खोराना उत्तरकडतीन बेथ-एमेक अनी नियेल आठेपावोत जासं; अनी तशीच ती डावीकडं काबूल आठे निंघस; ");
INSERT INTO ahr_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","तठेतीन ती एब्रोन, रहोब, हम्मोन अनी काना यावरतीन मोठी सीदोनपावोत जासं; ");
INSERT INTO ahr_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","तठेतीन ती वळसा लिसनं रामापावोत जासं अनी तठेतीन ती सोर नावनी तटबंदीना नगरपावोत जासं; तठेतीन ती होसाकडे वळसं अनी अकजीब परदेशमाईन जाईसनं समुद्रमां मिळसं; ");
INSERT INTO ahr_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","उम्मा, अफेक अनी रहोब, हयाबी त्यासना वाटाले ऊनात; जवयपास बाबीस नगर अनी त्यासना आसपासना गाव त्यासले भेटनात. ");
INSERT INTO ahr_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","आशेरना वंशजसना त्यासना कुयप्रमाणे नगर अनी त्यासना आसपासना गाव हया शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","सहावी चिठी नफताली वंशसनी नावनी त्यासन्या कुयप्रमाणे निघनी. ");
INSERT INTO ahr_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","त्यासनी सीमा हेलेफ अनी साननीमासली एला वृक्ष यापाईन अदामी नेकेब अनी यबनेल यावरतीन लक्कुम आठे जाईसनं यार्देनपान निंघसं; ");
INSERT INTO ahr_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","तठेतीन ती पश्चिमले वळीसनं अजनोथ-ताबोर आठे जासं अनी तठेतीन हुक्कोम आठे जासं अनी तठेतीन दक्षिणले जबुलूनना वतनभागपावोत अनी पश्चिमले आशेरना वतनभागपावोत उगवतीले यार्देनपान यहुदाना वतनभागले जाई पोहचसं. ");
INSERT INTO ahr_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","तठेना तटबंदीना नगर हया; सिद्दीम, सेर, हम्मथ, रक्कथ अनी किन्नरेथ; ");
INSERT INTO ahr_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","अदामा, राम; अनी हासोर; ");
INSERT INTO ahr_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","केदेश, एद्रई अनी एन-हासोर; ");
INSERT INTO ahr_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","इरोन, मिग्दल-एल, हरेम, बेथ-अनाथ अनी बेथ-शेमेश हया एकोणीस नगर अनी त्यासना गाव. ");
INSERT INTO ahr_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","नफताली वंशजसना त्यासना कुयप्रमाणे नगर अनी त्यासना आसपासना गाव हया शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","सातवी चिठी दान वंशसनी नावनी त्यासन्या कुयप्रमाणे निघनी. ");
INSERT INTO ahr_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","त्यासनी वतनसीमानी मजारमां हया नगर शेतस; सरा, एष्टोवोल अनी ईर-शमेश; ");
INSERT INTO ahr_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","शालब्बीन, अयालोन अनी इथला; ");
INSERT INTO ahr_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","एलोन, तिम्ना अनी अनी एक्रोन; ");
INSERT INTO ahr_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","एलतके, गिब्बथोन अनी बालाथ; ");
INSERT INTO ahr_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","यहुद, बने-बराक अनी गथ-रिम्मोन; ");
INSERT INTO ahr_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","मीयकोन, रक्कोन अनी याफोना समोरना परदेश. ");
INSERT INTO ahr_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","दान वंशजसनी सीमा त्यासना कुय वतननाबाहेर गयात; कारण दान वंशजसनी लेशेमावर स्वारी करीसनं ते लढीसनं लिद्, तलवारघाई त्याना नाश करं अनी त्यासना ताबा लिसनं तठे वस्ती करी; अनी आपला मुयपरुष दान यानं नाव त्यासनी लेशेमास ठेवं. ");
INSERT INTO ahr_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","दानना वंशजसना त्यासना कुयप्रमाणे ज्या नगर अनी त्यासना आसपासना गाव भेटनात त्या हया शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","चतु: सीमापरमानं वतन वाटी देवानं सरानंतर इस्त्राएल लोकेसनी नूनाना पोर्‍या यहोशवा याले आपलामाईन हिस्सा दिदा; ");
INSERT INTO ahr_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","त्यानी मांगेल एफ्राईमना डोंगराय देशमाधला तिम्नाथ-सेरह नावनं नगर परमेश्वरनी आज्ञाप्रमाणे त्याले दिध; ते नगर बसाडीसनं तठे तो राहावाले लागना. ");
INSERT INTO ahr_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","एलाजार याजक, नूनाना पोर्‍या यहोशवा अनी इस्त्राएल वंशसना त्यासना पितृकुयप्रमाणे प्रमुख यासनी शिलो आठे देवना दर्शनमंडपना दारपान परमेश्वरनामोरे चिठया टाकीसनं ज्या वतन वाटी दिदात त्या हया याप्रमाणे देश वाटीसनं देवानं सरनं. ");
INSERT INTO ahr_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","मंग यहोशवा परमेश्वरले बोलना, ");
INSERT INTO ahr_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","इस्त्राएल लोकेसले सांग, मी मोशेकडतीन तुमले सांग व्हतं की शरणपुरे ठरावानं; ");
INSERT INTO ahr_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","म्हणजे कोणी भुलीचुकीसनं एखादाना जीव लिदा व्हई त्यामा त्याले पयी जाता येई अनी खूनना सुड लेनारापाईन तुमले ती रक्षणस्थान व्हई. ");
INSERT INTO ahr_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","असा माणुस एखादा नगरकडे पयी गया म्हणजे त्यानी नगरना वेशीपान उभं राहावानं अनी तठेना वडील मंडयीले आपलं प्रकरनं सांगानं, मंग त्यासनी त्याले आपला नगरमां लिसनं आपलामां राहावाले जागा देवानं. ");
INSERT INTO ahr_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","खुनना सुड लेनारानी त्याना पाठलाग करं ते त्या वडील लोकेसनी त्या मनुष्यवध करनाराले त्याना हातमां देवानं नही; कारण त्यानी नकयत आपला शेजाराले मारेल शे; त्यानं त्यानासंगे पुर्वीन वैर नही व्हतं. ");
INSERT INTO ahr_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","मंडयीनासमोर त्याना न्याय व्हसं तोपावोत नाहीते त्या येळना मुख्य याजक हयातमां व्हयी तोपावोत त्यानी त्या नगरमां राहावानं; मंग पाहीजे ते ज्या गावमाईन तो पयेल शे तठे त्यानी परत जाईसन आपला घर राहावानं. ");
INSERT INTO ahr_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","यानावरतीन त्यासनी नफतालीना डोंगराय परदेशमाधला गालीलमां केदेश, एफ्राइमना डोंगरवटले शखेम, यहुदाना डोंगराय परदेशमाधला किर्याथ-आर्बा ऊर्फ हेब्रोन हया नगर येगळा नेमी ठेयेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","यरीहोना पुर्वेले यार्देननातिकडे त्यासनी रऊबेन वंशना विभागमाईन मायवरना जंगलमाधला बेसेर, गाद वंशना विभागमाईन गिलादमाधला रामोथ अनी मनश्शे वंशना विभागमाईन बाशानमाधला गोलान हया नगर ठेवात. ");
INSERT INTO ahr_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","बठा इस्त्राएल लोकेसकरता अनी त्यासमां राहानारा परदेशी लोकेसकरता हया नेमेल नगर व्हतात; त्या यानाकरता की एखादानी एखादाले भुलीचुकीतीन मारं अनी तो अस एक नगरमां पयी गया ते मंडयीनामोरे उभं राहीसनं त्याना न्याय व्हावाशिवाय खुनना सुड लेनाराले त्याले जीवे मारता येवाले नही पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","मंग लेवी वंशमाधला पितृकुयना परमुख माणसे हया एलाजार याजक, नुनाना पोर्‍या यहोशवा अनी इस्त्राएली वंशना पितृकुयना परमुख यापान ऊनात. ");
INSERT INTO ahr_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","त्या कनान देशमाधला शिलो आठे यिसनं बोलनात की परमेश्वरनी मोशेकडतीन आशी आज्ञा करी व्हती की आमनी वस्तीकरता नगर अनी आमना जनावरासकरता शिवार देवानं. ");
INSERT INTO ahr_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","त्यावरतीन इस्त्राएल लोकेसनी परमेश्वरनी आज्ञाप्रमाणे ज्यानात्याना वतनभागमाईन लेवीसले नगरे अनी शिवार दिधात, त्या याप्रमाणे; ");
INSERT INTO ahr_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","कहाथी कुयनी चिठी निघी तवय लेवीसमाईन अहरोन याजकनं वंशले यहुदा, शिमोन अनी बन्यामिन या वंशासना वाटासमाईन तेरा नगर भेटनात. ");
INSERT INTO ahr_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","बाकीना कहाथी वंशसले एफ्राईम वंशमाधला कुयना वाटासमाईन अनी दान वंशना अनी मनश्शना आरधा वंशना नगरमाईन दहा नगर चिठया टाकीसनं दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","गेर्षोन वंशसले इस्साखार वंशमाधला कुयना अनी आशेर अनी नफताली यासना वंशना अनी अनी बाशानमाधला मनश्शेना आरधा वंशना नगरमाईन तेरा नगर चिठया टाकीसनं दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","मरारी वंशासले त्यासना कुयप्रमाणे रऊबेन अनी जबुलून यासना वंशना वाटामाईन बारा नगर दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","परमेश्वरनी मोशेले देयेल आज्ञाप्रमाणे इस्त्राएल लोकेसनी लेवीसले चिठया टाकीसनं हाई नगर अनी त्यासना शिवार दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","त्यासनी यहुदा अनी शिमोन यासना कुयमाधला विभागमाईन पुढे सांगेल नगर दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","लेवी वंशमाधला कहाथी कुयमाधला अहरोनना वंशले पहिला वाटा मिळना. ");
INSERT INTO ahr_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","त्यासले त्यानी यहुदामाधला डोंगराय परदेशमाधला किर्याथ-आर्बा ऊर्फ हेब्रोन हाई नगर शिवारनीसंगे दिधं; आर्बा हाऊ अनाकना बाप व्हता; ");
INSERT INTO ahr_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","पण त्या नगरना वावर अनी आसपासना खेडापाडा यफुन्नेना पोर्‍या कालेब याले त्यानी वतन करी देयेल व्हता. ");
INSERT INTO ahr_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","अहरोन याजकना वंशले मनुष्यवध कराकरता शरणपूर म्हणीसनं हेब्रोन अनी त्याना शिवार, यानाशिवाय लिब्ना अनी त्याना शिवार; ");
INSERT INTO ahr_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","यत्तीर अनी त्याना शिवार, एष्टमोवा अनी त्याना शिवार; ");
INSERT INTO ahr_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","होलोन अनी त्याना शिवार, दबीर अनी त्याना शिवार; ");
INSERT INTO ahr_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","अईन अनी त्याना शिवार, युटा अनी त्याना शिवार, बेथ-शेमेश अनी त्याना शिवार आशा बठा नऊ नगर त्या दोन वंशासले विभागी दिदात. ");
INSERT INTO ahr_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","बन्यामिन वंशना विभागमाईन गिबोन अनी त्याना शिवार, गेबा अनी त्याना शिवार, ");
INSERT INTO ahr_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","अनाथोथ अनी त्याना शिवार, अलमोन अनी त्याना शिवार दिदात, अस चारा नगर दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","यापरकारं अहरोन वंशमाधला याजकले तेरा नगर अनी त्यासना शिवार मिळनात. ");
INSERT INTO ahr_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","बाकीना कहाथी वंशमाधला लेवीसले एफ्राईम वंशमाधला विभागमाईन चिठी टाकीसनं नगर दिदात. ");
INSERT INTO ahr_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","मनुष्यवध कराकरता शरणपूर म्हणीसनं त्यासले एफ्राईमना डोंगराळ परदेशमाधला शखेम नगर अनी त्याना शिवार, यानाशिवार गेजेर अनी त्याना शिवार; ");
INSERT INTO ahr_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","किबसाईम अनी त्याना शिवार अनी बेथ-हारोन अनी त्याना शिवार, अस बठा चार नगर त्यासनी दिदात. ");
INSERT INTO ahr_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","दान वंशना विभागकरता एलतके अनी त्याना शिवार, गिब्बथोन अनी त्याना शिवार, ");
INSERT INTO ahr_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","अयालोन अनी त्याना शिवार अनी गथ-रिम्मोन अनी त्याना शिवार हाई चार नगर दिदात. ");
INSERT INTO ahr_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","मनश्शेना आरधा वंशना विभागमाईन तानख अनी गथ-रिम्मोन अनी त्याना शिवार हया दोन नगर दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","या प्रकारे बाकीना राहेल कहाथी वंशसले जवयपास बठा दहा नगर शिवारनासंगे दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","लेवी वंशमाधला गेर्षोनना कुयले मनश्शना आरधा वंशना विभागमाईन मनुष्यवध कराकरता शरणपूर म्हणीसनं बाशानमाधला गोलान अनी त्याना शिवार, यानाशिवाय बैश्तरा अनी त्याना शिवार, अस जवयपास बठा दोन नगर त्यासनी दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","इस्साखार वंशना विभागमाईन किशोन अनी त्याना शिवार, दाबरथ अनी त्याना शिवार; ");
INSERT INTO ahr_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","यर्मुथ अनी त्याना शिवार, एन-गन्नीम अनी त्याना शिवार अस चार नगर त्यासनी दिदात. ");
INSERT INTO ahr_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","आशेर वंशना विभागमाईन मिशाल अनी त्याना शिवार, अब्दोन अनी त्याना शिवार; ");
INSERT INTO ahr_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","हेलकाथ अनी त्याना शिवार, अनी रहोब अनी त्याना शिवार, हया चार नगर त्यानी दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","नफताली वंशना विभागमाईन गालीलमाधला नगर मनुष्यवध कराकरता शरणपूर म्हणीसनं केदेश अनी त्याना शिवार, हम्मोथ-दोर अनी त्याना शिवार अनी कर्तान अनी त्याना शिवार हया तीन नगर त्यासनी दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","याप्रमाणे त्यासनी गेर्षोन वंशसले त्यासना कुयप्रमाणे जवयपास तेरा नगर त्यासना शिवारसहीत दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","बाकीना लेवीसले म्हणजे मरारी वंशना लोकेसले जबुलून वंशना विभागमाईन यकनाम अनी त्याना शिवार, कर्ता अनी त्याना शिवार; ");
INSERT INTO ahr_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","दिम्रा अनी त्याना शिवार अनी नहलाल अनी त्याना शिवार असा चार नगर त्यासनी दिदात. ");
INSERT INTO ahr_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","रऊबेन वंशना विभागमाईन बेसेर अनी त्याना शिवार, याहस अनी त्याना शिवार, ");
INSERT INTO ahr_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","कदेमोथ अनी त्याना शिवार अनी मेफाथ अनी त्याना शिवार अस चार नगर त्यानी दिदात. ");
INSERT INTO ahr_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","मनुष्यवध कराकरता शरणपूर म्हणीसनं गाद वंशना विभागमाईन गिलादमाधला रामोथ अनी त्याना शिवार; यानाशिवाय महनाइम अनी त्याना शिवार; ");
INSERT INTO ahr_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","हेशबोन अनी त्याना शिवार अनी याजेर अनी त्याना शिवार, अस जवयपास बठा चार नगर त्यासनी दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","याप्रमाणे बाकीना लेवीसले म्हणजे मरारी वंशना लोकेसले त्यासना कुयप्रमाणे अस जवयपास बारा नगर चिठया टाकीसनं त्यासनी दिदात. ");
INSERT INTO ahr_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","इस्त्राएल लोकेसनी वतनमाईन लेवीसले जवयपास अठ्ठेचायीस नगर अनी त्यासना शिवारसहीत त्यासनी दिदात. ");
INSERT INTO ahr_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","हया नगर त्यासना आसपासना बठा शिवारसहीत भेटनात; यापरकारं त्या बठा नगरले लागीसनं व्हतात. ");
INSERT INTO ahr_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","याप्रकारं जो देश देवानीबारामां परमेश्वरनी इस्त्राएल लोकेसनी पुर्वजसनीसंगे आणभाक करी व्हती तो बठा त्यानी त्यासले दिधा अनी त्या त्याना वतन पाईसन तठे राहावाले लागनात. ");
INSERT INTO ahr_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","परमेश्वरनी त्यासना पुर्वजसले वचन दिद् व्हतं त्याप्रमाणे चारीमेर विसावा भेटना; त्यासना कोनताच शत्रुले त्यासनामोरे टिकनात नही; परमेश्वरनी त्यासना बठा शत्रुसले त्यासना हातमां दिधं. ");
INSERT INTO ahr_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","परमेश्वरनी इस्त्राएल घराणाले ज्या‍ ज्या हितन्या गोष्ट सांग्या व्हत्यात‍ त्यामासली एक बी कमी पडनी नही; त्या बठया शिध्दीस गयात. ");
INSERT INTO ahr_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","मंग यहोशवानी रऊबेन वंश, गादी वंश अनी मनश्शना आरधा वंश यासना लोकेसले बलाई धाडं, ");
INSERT INTO ahr_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","परमेश्वरना सेवक मोशे यानी तुमले जे काही सांग व्हतं त्याप्रमाणे तुम्हीन सर्व काही करं अनी जी जी आज्ञा मी तुमले दिधी ती तुम्हीन ऐकी; ");
INSERT INTO ahr_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","आजपावोत तुम्हीन आपला भाऊबंदसले सोडीसनं गयात नही अनी आपला देव यहोवा यानी आज्ञा ध्यान दिसनं पाळयात. ");
INSERT INTO ahr_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","आता तुमना देव यहोवा यानी आपला वचनप्रमाणे तुमना भाऊबंदसले विसावा देयेल शे, तर आते परमेश्वरना सेवक मोशे यानी यार्देनना तिकडे तुमले जी भुमी वतन करी देयेल शे तठे तुम्हीन ज्याना त्याना डेरासले परत जा. ");
INSERT INTO ahr_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","पण परमेश्वरना सेवक मोशे यानी तुमले जे धर्मशास्त्र अनी नियमशास्त्र लायी देयेल शे ते पाळानं; आपला देव यहोवा यानावर प्रेम करानं, त्याना बठा मार्गतीन चालानं, त्यानी आज्ञा पाया, त्याना व्हयीसनं राहा अनी त्यानी सेवा मन लाईसनं करा; हाई बठा करानं ध्यानमां ठेवानं; ");
INSERT INTO ahr_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","यहोशवानी त्यासले आशिर्वाद दिसनं धाडी दिध, अनी त्या ज्याना त्याना डेराकडे गयात. ");
INSERT INTO ahr_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","मनश्शेना आरधा वंशले मोशेनी बाशानमां विभाग दिदा व्हता, पण त्याना दुसरा आरधा वंशले यहोशवानी यार्देनना पश्चिमले त्यासना भाऊबंदसमां विभाग देयेल व्हता, यहोशवानी त्यासले ज्याना त्याना डेरासकडे रवानं करं तवय त्यानी त्यासले आशिर्वाद दिद अनी सांग, ");
INSERT INTO ahr_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","विपुल पशु, रुपे, सोने, पितळ, लोखंड, बराच कपडा, आशी संपत्ती लिसनं ज्याना त्याना डेराले जावा; आपला शत्रुपाईन लेयेल लुट आपला भाऊबंदसनीबरोबर वाटी ल्या. ");
INSERT INTO ahr_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","मंग रऊबेन वंश, गादी वंश, मनश्शना आरधा वंश यासना माणसे इस्त्राएल लोकेसपाईन कनान देशमां शिलोहपाईन परमेश्वरनी आज्ञाप्रमाणे मोशेनी देयेल गिलाद नावनं वतनभुमीले परत निघी गयात. ");
INSERT INTO ahr_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","जवय रऊबेन वंश, गाद वंश अनी मनश्शेना आरधा वंश यामाधला माणसे कनान देशमां यार्देनना थडीना परदेशमां ऊनात तवय त्यासनी यार्देननाजोडे मोठी प्रेक्षणीय वेदी बांधी. ");
INSERT INTO ahr_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","रऊबेन वंश, गाद वंश अनी मनश्शना आरधा वंश यामाधला लोकेसनी कनान देशनासमोर यार्देननी पैलथडीले इस्त्राएल लोकेसनी ताबामाधला परदेशमां एक येदी बांधानी बातमी इस्त्राएल लोकेसनी कानवर व्हनं. ");
INSERT INTO ahr_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","इस्त्राएल लोकेसनी बठी मंडयीनी हाई आयकावर त्यासनावर लढाई कराले चाली जावानं म्हणीसनं त्या बठा शिलो आठे एकजागे गोया व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","मंग इस्त्राएल लोकेसनी रऊबेन वंश, गाद वंश अनी मनश्शना आरधा वंश यामाधला लोकेसकडे गिलाद देशमाधला एलाजार याजकना पोर्‍या फिनहास याले धाडं. ");
INSERT INTO ahr_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","अनी त्यानासंगे इस्त्राएल लोकेसना वंशना पितृकुयमाधला परतेक वंशनामांगे अस दहा सरदार धाडात; त्या इस्त्राएल लोकेसना कुयमाधला आप आपला पितृकुयना परमुख व्हतात. ");
INSERT INTO ahr_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","त्या गिलाद देशमां रऊबेन वंश, गाद वंश अनी मनश्शना आरधा वंश यामाधला लोकेसकडे जाईसनं बोलनात, ");
INSERT INTO ahr_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","परमेश्वरनी बठी मंडयी सांगी राहीनी शे, “तुम्हीन इस्त्राएलना देव यहोवा यानाविरोधमां हाई काय पाप करेल शे? तुम्हीन आते हाई येदी बांधेल शे, यामां तुम्हीन परमेश्वरले अनुसरानं सोडीसनं त्यानाविरोधमां बंड करेल शे. ");
INSERT INTO ahr_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","दखा, पौरना प्रकरणमां जे आमनाकडतीन अधर्म घडनं त्यामुये परमेश्वरनी मंडयीवर मरी यि गयी, तरीबी आम्हीन आजपावोत त्या अधर्मपाईन शुध्द व्हयनुत नही हाई आमले थोडं व्हयेल शे त्यामुयेच, ");
INSERT INTO ahr_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","तुम्हीन परमेश्वरले अनुसरानं सोडी दि राहीना शेतस का? आज तुम्हीन परमेश्वनी येदीनाशिवाय दुसरी येदी बांधीसनं परमेश्वरनी विरोधमां बंड कर ते सकाय बठी इस्त्राएलनी मंडयीवर त्याना क्रोध व्हयी. ");
INSERT INTO ahr_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","तुमनी वतन भुमी अपवित्र व्हयीते परमेश्वरना निवासमंडप जठे शे त्या परमेश्वरनी वतनदेशमां नदीना तिकडे यिसनं आमनामां वतन ल्या, पण आमना देव यहोवा यानी येदीशिवाय दुसरी येदी बांधीसनं परमेश्वरना विरोधमां अनी आमनाविरोधमां बंड करानं नही. ");
INSERT INTO ahr_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","जेरहना पोर्‍या आखान यानी समर्पित वसतुनीबारामां आज्ञा मोडी अनी इस्त्राएलनी बठी मंडयीवर कोप व्हयना नही का? त्याना अधर्मतीन त्याना एकलानां नाश व्हयनं नही.” ");
INSERT INTO ahr_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","तवय रऊबेन वंश, गाद वंश अनी मनश्शना आरधा वंश यामाधला माणसे इस्त्राएलना पितृकुयना प्रमुखसले बोलनात, ");
INSERT INTO ahr_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“देवाधिदेव यहोवा, देवाधिदेव यहोवा याले माहीत शे; इस्त्राएल लोकेसले बी माहीती पडो की, आम्हीन परमेश्वरना विरोधमां बंड करीसनं अनी त्यानी आज्ञा मोडीसनं असं करं व्हई ते तो आज आमले जीवत नही ठेवो! ");
INSERT INTO ahr_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","परमेश्वरले अनुसरानं सोडी देवाकरता आम्हीन हाई येदी बांधी व्हई ते, तिनावर होमार्पण, पेयार्पन अनी शांतीर्पण कराकरता बांधेल व्हई ते, परमेश्वर आमनी झडती लेवो. ");
INSERT INTO ahr_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","आम्हीन पुढला ईचार करीसनं अनी ईषेस हेतुतीन हाई करेल शे; आम्हीन बोलनुत, एखादा येळले पुढला कायमां तुमना पोर्‍या आमना पोर्‍यासले म्हणानं की, इस्त्राएलना देव यहोवा यानासंगे तुमना काय संबंध शे? ");
INSERT INTO ahr_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","ये रऊबेनी अनी गादी लोकेसहो, परमेश्वरनी तुमनामां अनी आमनामां यार्देननी सीमा लाई देयल शे, म्हणीसनं परमेश्वरवर तुमना काही हक्क नही शे; अस म्हणीसनं तुमना वंश आमना वंशसले परमेश्वरनी भक्ती सोडी देवाले भाग पडतीन. ");
INSERT INTO ahr_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","तवय आम्हीन बोलनूत चाला, आपण एक येदी बांधू; ती होमबली नाहिते यज्ञबली अर्पाकरता नही ते, ");
INSERT INTO ahr_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","तुमना आमनामां अनी आमना मांगेतीन आमन्या अनी तुमन्या पिढयासमां साक्ष राहावाले पाहीज, याकरता की आपण होमबली, यज्ञबली अनी शांतीर्पण या करीसनं परमेश्वरनामोरे उपासना करानी, म्हणजे परमेश्वर वर तुमना काही हक्क नही अस पुढला कायमां तुमना पोर्‍यासनी आमना पोर्‍यासले नही म्हणाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","आम्हीन सांगनूत, मोरे जवय त्या माणसे आमले नाहिते आमना वंशसले अस म्हनतीन तवय आम्हीन त्यासले सांगसूत, परमेश्वरवार येदीना नमुना दखा; आमना पुर्वजसनी ती होमबली नाहीते यज्ञबली अर्पाकरता करी नही ते, ती तुमना आमनामां साक्ष म्हणीसनं शे. ");
INSERT INTO ahr_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","आमना देव यहोवा याले होमार्पण, अन्नर्पण कराकरता आमना देव यहोवा यानी त्याना निवासमंडपनामोरेनी जी येदी शे तिनीशिवाय दुसरी येदी बांधीसनं परमेश्वरना विरोधमां बंड करानी अनी प्रभुले अनुसरानं आज सोडी देवानं आमना हातमाईन कधीच नही घडो.” ");
INSERT INTO ahr_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","रऊबेन वंश, गाद वंश अनी मनश्शना आरधा वंश यामाधला, लोकेसना हाई म्हणनं ऐकीसन फिनहास याजक अनी त्यानासंगे‍ना ज्या इस्त्राएल वंशना सरदार व्हतात यासनं समाधान व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","तवय एलाजार याजकना पोर्‍या फिनहास यानी, रऊबेन, गाद अनी मनश्शे याना वंशसले सांग, यामां तुमीन काही परमेश्वरना गुन्हा करेल नही म्हणीसनं आमनी खातरी व्हयेल शे की परमेश्वर आमनामां शे; तुम्हीन आते इस्त्राएल लोकेसले परमेश्वरनी हातमाईन वाचाडेल शे. ");
INSERT INTO ahr_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","तवय एलाजार याजकना पोर्‍या फिनहास अनी सरदार हया रऊबेनी अनी गादी यासपाईन निघीसनं गिलादमाईन कनान देशले इस्त्राएल लोकेसकडे परत गयात अनी त्यासनी त्यासले हाई बातमी सांगी. ");
INSERT INTO ahr_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","इस्त्राएल लोकेसना समाधान व्हयीसनं त्यासनी परमेश्वरना धन्यावद करं अनी रऊबेनी अनी गादी यासनासंगे लढाना बारामां नाहिते त्या राहातात, तो देश नाश करानीबारामां त्यासनी परत ती गोट काढी नही. ");
INSERT INTO ahr_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","रऊबेनी अनी गादी यासनी सांग की परमेश्वर हाऊच देव शे, यानी तुमना आमनामां साक्ष म्हणीसनं हाई येदी शे; यावरतीन त्यासनी तिनं नाव एद अस ठेवं. ");
INSERT INTO ahr_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","इस्त्राएलले परमेश्वरनी त्यासना आसपासना बठा शत्रुसपाईन आराम देवावर बराच येळ गये; अनी यहोशवा बराच वृध्द अनी उतार वयना व्हयी गया; ");
INSERT INTO ahr_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","तवय यहोशवानी बठा इस्त्राएलसले म्हणजे त्यासना वडीलसले, त्यासना परमुख, त्यासना न्यायधीश अनी त्यासना अमलदार यासले बलाईसनं सांग; मी आते वृध्द अनी उतार वयना व्हयी जायेल शे; ");
INSERT INTO ahr_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","तुमनाकरता तुमना देव यहोवा यानी या बठा राष्ट्रासनं काय करं हाई तुम्हीन दखेल शे; तुमनाकरता लढना तो तुमना परमेश्वर. ");
INSERT INTO ahr_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","दखा हाई अवशिष्ट राष्ट्र अनी ज्या राष्ट्रसना संहार करेल शे त्यासना बठा देश जो यार्देनपाईन सुर्य मावयतीले मोठा समुद्रपावोत शे तो मी तुमले तुमना वतनना वंश व्हावाले पाहीजे म्हणीसनं वाटी देयेल शे; ");
INSERT INTO ahr_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","अनी तुमना देव यहोवा त्यासले तुमनामोरेतीन घालाडी अनी तुमनासमोर हाकली देई; तुमना देव यहोवा यानी सांगाप्रमाणे तुम्हीन त्याना भुमीनं वतन पावशात. ");
INSERT INTO ahr_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","मोठी हिंमत धरा, मोशेना नियमशास्त्रना ग्रंथमां जे लिखेल शे ते बठ मान्य करीसनं पाळा, त्यानापाईन उजवी डावीकडे वळानं नही; ");
INSERT INTO ahr_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","तुमनामां ज्या राष्ट्र राहेल शेतस त्यासमां मियानं नही; त्यासना देवनं नावबी लेवानं नही, त्यासनी नावनी शपथ कोणले वाहावाले सांगानं नही;‍ त्यासनी उपासना करानी नही; त्यासले नमन करानं नही. ");
INSERT INTO ahr_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","तर तुम्हीन आजपावोत आपला देव यहोवा याले धरीसनं राहेल शेतस तशे राहावानं. ");
INSERT INTO ahr_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","परमेश्वरनी तुमनामोरेतीन मोठमोठा अनी बलाढय राष्ट्रसले घालाडी देयेल शेतस; तुमनामोरे ते आजपावोत कोणीच टिकेल नही शे. ");
INSERT INTO ahr_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","तुमनामाईन एक जण सहसांस्र पयाडी लायी, कारन तुमले सांगाप्रमाणे तुमनाकरता लढनारा परतेक्ष तुमना देव यहोवा शे. ");
INSERT INTO ahr_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","तुमना देव यहोवा यानावर तुमना प्रेम राही आशी खबरदारी लेवानी; ");
INSERT INTO ahr_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","पण जर तुम्हीन कोनतेबी परकारतीन त्यानापाईन दुर वशात ते, तर तुमनामां वस्ती करी राहानारा अवशिष्ट राष्ट्रासले जाई मियशात अनी त्यासनासंगे शरीरसंबंध करीसनं दयनवयन करशात. ");
INSERT INTO ahr_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","तर हाई पक्क समजानं की यानामोरे तुमना देव यहोवा या राष्ट्रासले तुमना नजरनामोरेतीन घालाडावू नही, तर ती तुमले पाश अनी सापळा, तुमना कुशीले चाबूक अनी डोयाले काटा अस व्हतीन; अनी शेवट जी उत्तम भुमी तुमना देव यहोवा यानी तुमले देयेल शे तठेतीन तुमना नायनाट व्हयी. ");
INSERT INTO ahr_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“दखा, मी आज बठी दुनियानी रिवाजप्रमाणे जासु; तुमना बठासनी मननी अनी चितनी खातरी व्हयी जायेल शे की आपला देव यहोवा यानी आपलाबारामां ज्या ज्या हितन्या गोट सांग्यात त्यामासली एक बी कमी पडनी नही; त्या बठया तुमनीबारामां व्हयन्यात; एक बी गोट कमी पडनी नही. ");
INSERT INTO ahr_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","तुमना देव यहोवा यानी तुमले सांगाप्रमाणे बठया हितन्या गोष्टी ज्याप्रमाणे घडन्यात त्याप्रमाणे अहितना परसंग परमेश्वर तुम्हनावर गुजारीसनं जी उत्तम भुमी तुमना देव यहोवा यानी तुमले देयेल शे तठेतीन तुमना नायनाट करी. ");
INSERT INTO ahr_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","तुमना देव यहोवा यानी जो करार पायानी तुमले आज्ञा देयेल शे त्यानं उल्लंघन करीसनं दुसरा देवनी उपासना करशात अनी त्यासना नमन करशात तर परमेश्वरना कोप तुमनावर भडकी अनी जो देश त्यानी तुमले देयेल शे तठेतीन तुमना लवकर नायनाट व्हयी.” ");
INSERT INTO ahr_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","मंग यहोशवानी इस्त्राएल वंशना बठा लोकेसले शखेम आठे जमाडं; अनी इस्त्राएल लोकेसना वडीलसले त्यासना परमुख, त्यासना न्यायधीश अनी अमलदार यासले बलावनं धाडं; अनी त्या देवनामोरे हजर व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","यहोशवा बठा लोकेसले बोलना, इस्त्राएलना देव यहोवा सांगस, प्राचीन कायले अब्राहाम अनी नाहोर यासना वडील तेरह यानावरतीन तुमना पुर्वज फरात नदीना तिकडे राहात व्हतात अनी त्या अन्य देवनी उपासना करेत. ");
INSERT INTO ahr_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","तुमना मुयपुरुष अब्राहाम याले महानदना तताईन आणं, कनान देशभर फिरावं, त्याना वंश बहुगुणित करं अनी त्याले इसहाक दिदा. ");
INSERT INTO ahr_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","मंग मी इसहाकले याकोब अनी एसाव हया दिदात, अनी एसावले सेईर डोंगर वतन करी दिदा; याकोब हाऊ आपला पोरेसोरेसनासंगे मिसर देशमां गया. ");
INSERT INTO ahr_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","नंतर मोशे अनी अहरोन यासले धाडीसनं मिसर देशमां ज्या कृत्य करात यावरतीन त्या देशले पिडनात; नंतर मी तुमले बाहेर आणं; ");
INSERT INTO ahr_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","मी तुमना पुर्वजसले मिसर देशमाईन काढी आणं; मंग तुम्हीन समुद्रपावोत येई पोहचनात; अनी मिसरी लोकेसनी रथ अनी स्वार यानासंगे तांबडा समुद्रपावोत तुमना पाठलाग करात. ");
INSERT INTO ahr_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","त्यासनी परमेश्वरना धावा करं तवय त्यानी तुमना अनी मिसर्‍यासनामजारमां आंधार पाडं अनी त्यासनावार समुद्र आणीसनं त्यासले गडप करं; मिसर देशमां मी जे काही करं ते तुम्हीन आपला डोयाघाई दख मंग जंगलमां तुम्हीन वस्ती करीसनं बराच दिन व्हयनात. ");
INSERT INTO ahr_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","मंग मी तुमले यार्देनना पुर्वले राहानारा अमोरी लोकेसना देशमां आण; त्या तुमनासंगे लढनात; मी त्यासले तुमना हातमां दिद् अनी तुम्हीन त्यासना देशना ताबा लिदा; तुमनामोरे मी त्यासना संहार करं. ");
INSERT INTO ahr_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","नंतर मवाबना राजा सिप्पोरपुत्र यानी ऊठीसनं इस्त्राएलनीसंगे युध्द करं; तुमले शाप देवाकरता त्यानी बौरना पोर्‍या बालाक याले बलाई आण; ");
INSERT INTO ahr_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","पण मी बलामनं ऐकं नही; त्यानी तुमले उलट आशिर्वाद दिदा; यापरकारं मी तुमले त्याना हातमाईन सोडावं. ");
INSERT INTO ahr_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","तुम्हीन यार्देन नदी उतरीसनं यरीहोले ऊनात अनी यरीहोना लोके अनी अमोरी, परिज्जी, कनानी, हित्ती, गिर्गाशी, हिव्वी अनी यबुसी यासनी तुमनासंगे लढाई करी तवय मी त्यासले तुमना हातमां दिद्. ");
INSERT INTO ahr_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","मी तुमना आघाडीसले गांधीलमाशा धाडयात अनी त्यासनी अमोर्‍यासना दोन राजे तुमनामोरेतीन हाकली दिद्; हाई काम तुमनी तलवारघाई अनी धनुष्यघाई व्हयनं नही. ");
INSERT INTO ahr_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","मंग ज्या जमीनवर तुम्हीन कष्ट करेल नही शेतस आशी भुमी मी तुमले दिदी; ज्या नगर तुम्हीन बांधात नही तठे तुम्हीन राही राहीना शेतस, ज्या द्राक्षना मया अनी जैतुनना बाग लावं नहीत त्याना उपज तुम्हीन खाई राहीना शेतस. ");
INSERT INTO ahr_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“तर आते परमेश्वरनं भर धरा, त्यानी सेवा सात्विक अनी खरं मनतीन करा; अनी महानदनातिकडे अनी मिसर देशमां ज्या देव तुमना पुर्वजसनी पुजात त्या टाकीसनं परमेश्वरनी सेवा करा. ");
INSERT INTO ahr_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","परमेश्वरनी सेवा करानं हाई तुमले गैर दखास व्हयीते तुम्हीन कोनी सेवा करशात हाई आज ठरावानं; महानदीना तिकडे तुमना पुर्वजसनी ज्या देवनी पुजा करी त्यासनी नाहीते तुम्हीन राही राहीना शेतस त्या देशमाधला अमोर्‍यासनी देवनी मी अनी मना घरानं परमेश्वरनी सेवा करसुत.” ");
INSERT INTO ahr_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","तवय लोकेसनी उत्तर दिद्, “परमेश्वरना त्याग करीसनं अन्य देवनी पुजा करानी हाई आमनाकडतीन न घडो! ");
INSERT INTO ahr_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","कारण आमना देव यहोवा यानीच आमले अनी आमना पुर्वजसले मिसर देशमाईन, दास्यगृहामाईन बाहेर आणं; त्यानीच आमना नजरनासमोर मोठमोठा चमत्कार करात अनी ज्या वाटघाई आम्हीन परवास करा अनी ज्या लोकेसमाईन आम्हीन मार्गक्रमन करं तठे त्यानी आमनं रक्षण करं. ");
INSERT INTO ahr_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","अनी या देशमां राहानारा अमोरी वगैरे बठा लोकेसले त्यानी आमनामोरेतीन घालाडी दिद्; आम्हीनबी परमेश्वरनी सेवा करसतु, कारन तोच आमना देव शे.” ");
INSERT INTO ahr_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","यहोशवा लोकेसले बोलना, “तुमनाकडतीन परमेश्वरनी सेवा घडाऊ नही; कारण तो पवित्र देव शे; तो ईर्ष्यावान देव शे; तो तुमना अधर्मना अनी तुमना पापसनी क्षमा कारावू नही. ");
INSERT INTO ahr_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","तुम्हीन परमेश्वरना त्याग करीसनं दुसरा देवनी पुजा करशात, तर जो तुमना कल्यान करत ऊना शे तो तुमले प्रतिकुय व्हयीसनं तुमना अकल्यान करी, तुमना नाश करी.” ");
INSERT INTO ahr_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","लोके यहोशवाले बोलनात, “नही, नही, आम्हीन परमेश्वरनी सेवा करसतु.” ");
INSERT INTO ahr_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","यहोशवा लोकेसले बोलना, “तुम्हीन सेवाकरता परमेश्वर निवाडेल शे यानाबारामां तुमनी तुमनाच साक्षी शेतस.”‍ त्या बोलनात, “हा, आम्हीनच साक्षी शेतस.” ");
INSERT INTO ahr_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","यहोशवा बोलना, “आपलामाधला दुसरा देव तुम्हीन टाकी दया, आपला मन इस्त्राएलना देव यहोवा यानाकडे लावा.” ");
INSERT INTO ahr_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","लोके यहोशवाले बोलनात, “आमना देव यहोवा यानीच आम्हीन सेवा करसुत अनी त्यानीच वाणी आम्हीन आयकसुत.” ");
INSERT INTO ahr_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","तवय यहोशवानी त्या दिनले त्या लोकेसकडतीन करार करी लिदा अनी शखेममां त्यासले विधी अनी नियम लाई दिधात. ");
INSERT INTO ahr_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","या गोष्टी यहोशवानी देवना नियमशास्त्रना ग्रंथमां लिखी ठेवात अनी एक मोठी शिला लिसनं परमेश्वरना पवित्र ठिकानना जोडे एक एला झाडनाखाल ती उभी करानं. ");
INSERT INTO ahr_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","यहोशवा बठा लोकेसले बोलना, “हाई शिला आपली साक्ष व्हई कारण परमेश्वरनी आमले सांगेल बठा वचन हिनी ऐकेल शेतस; एकादा येळले तुम्हीन परमेश्वरना त्याग करशात त्यामुये हाई शिला तुमनी साक्ष म्हणीसनं ठेयल शे.” ");
INSERT INTO ahr_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","मंग यहोशवानी लोकेसले ज्याना त्याना वतनकडे धाडी दिधं. ");
INSERT INTO ahr_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","ह्या गोष्टी व्हावानंतर परमेश्वरना सेवक नुनाना पोर्‍या यहोशवा एकशे दहा वरीस व्हईसनं मरना. ");
INSERT INTO ahr_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","एफ्राईमना डोंगराय परदेशमां गाश नावनं डोंगरना उत्तरले तिम्नाथ-सेरह आठे त्याना वतन भागना सीमावर त्यासनी त्याले मुठमाती दिदी. ");
INSERT INTO ahr_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","यहोशवानी हयातीमां अनी यहोशवा मरानंतर जीवत राहेल वडील लोकेसले परमेश्वरनी इस्त्राएलकरता काय काय करं हाई दखाई राहीनं व्हतं, त्यानी हयातीमां इस्त्राएल लोकेसनी परमेश्वरनी सेवा करी. ");
INSERT INTO ahr_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","योसेफानी अस्थी इस्त्राएल लोकेसनी मिसर देशमाईन आन्या व्हत्यात त्या शखेम आठे एकजागे पुर्‍यात; हाई जागा याकोबनी शखेमना बाप हमोर याना वंशकडतीन शंभर चांदिना शिक्का दिसनं ईकत लिदी व्हती; हाई ठिकान योसेफ वंशजसना वतन व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","नंगर अहरोनना पोर्‍या एलाजार हाऊ मरना; त्याले त्यासनी एफ्राईमना डोंगराय प्रांतमां त्याना पोर्‍या फिनहास यानं गाव गिबा आठे मुठमाटी दिधी.");
INSERT INTO ahr_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","अहश्वेरोश राजाना कारकीर्दीमा पुढे देल घटना घडनी: त्यानं साम्राज्य भारतपाईन कूश देशपावत व्हतं; ज्याना अमल एकशे सत्तावीस प्रांतसवर व्हता तोच हाऊ अहश्वेरोश राजा शे. ");
INSERT INTO ahr_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","अहश्वेरोश राजानी राजधानी शूशन राजवाडामाधला आपला राजसनवर बठानंतर. ");
INSERT INTO ahr_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","आपला कारकीर्दीना तिसरा वरीसले आपला सर्वा सरदार अनं सेवक यासले मेजवाणी दिधी, पारस अनं मेदय यासना सेनापती, प्रांतोप्रांतीना राज्यपाल अनं सरदार त्यानापुढे हजर व्हयनात; ");
INSERT INTO ahr_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","त्यासले त्यानी बराच दिनपावत म्हणजे एकशेऐंशी दिनपावत आपला वैभवशाली राज्यनी दौलत अनी आपला श्रेष्ठ प्रतापनं वैभव दखाडात. ");
INSERT INTO ahr_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","एवढा दिन जावावर राजानी शूशन राजवाडामा येल धाकलामोठा लोकसले राज मंदिरना बागना पटांगणमा सात दिन मेजवाणी दिधी. ");
INSERT INTO ahr_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","तठला पडदा ढवया, हिरवा अनं निळा रंगना व्हतात; ह्या पडदा तलम सणना अनं जांभळा रंगनी दोरीसघाई चांदीना कडीसमा अडकाईसन संगमरवरी खांबसले लायेल व्हतं; तठला बसान्या चौकडया सोना रूपासना राहिसन तांबडा, ढवया, पिवया अनं काया संगमरवरी पाषाणना फरशीसवर ठेयेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","त्या मेजवाणीमा राजाले पेवाले योग्य अश द्राक्षना मद्य येगयेगळा सुवर्णपात्रसमा घालीसन राजाना औदार्यानुसार लोकसले भरपूर अस पेवाले देवामा वनं. ");
INSERT INTO ahr_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","हाई पेवानं नियमनानुसार राहे; कोणी कोणले बळजबरी नही करे; राजानी आपला मंदिरना सर्वा कारभारीसले आज्ञा करेल व्हती की, त्यासनी पाहूणासनी तब्येतकडे ध्यान देवानी. ");
INSERT INTO ahr_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","वश्ती राणीनी बी राजा अहश्वेरोश याना राजमंदिरमा बाईसले मेजवाणी दिधी. ");
INSERT INTO ahr_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","सातवा दिनले द्राक्षरसघाई राजानं मन उल्लासयुक्त व्हयेल व्हता त्यानी महूमान, बिगथा, हरबोना, बिगथा, बिग्था, अवगथा, जेथर, कर्खस असा ज्या सात खोजे त्याना तैनातमा व्हतात त्यासले आज्ञा करी की, ");
INSERT INTO ahr_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","वश्ती राणीनं सौंदर्य देशदेशना लोकसले अनं सरदारसले दखाडानं म्हणीन तिले राजमुकूट घालीन आपलापुढे लई येवानं; कारण ती भलती देखणी व्हती. ");
INSERT INTO ahr_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","खोजेसनाद्वारा वश्ती राणीले राजानी आज्ञा वनी तरी तिनी येवाले नकार दिधं; त्यावरीन राजाले भलता क्रोध ईसन तो संतापना. ");
INSERT INTO ahr_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","मंग राजानी काळ जाननारा पंडितसले ईचारं; तो राजा सर्वा न्‍यायीशास्त्री अनं धर्मज्ञ यासना सल्ला लेत राहे; ");
INSERT INTO ahr_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","त्यानाजोडे कर्शना, शेथार, अदमाथा, तार्शीश, मेरेस, मर्सना अनं ममुखान हाई पारस अनं मेदय आठला सात सरदार राहेत. त्या राजानं हुजूरमा राहिसन राज्यमा त्यासना पहिला मान राहे; ");
INSERT INTO ahr_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","राजानी त्यासले ईचारं, की, “अहश्वेरोशनी खोजेसनाद्वारा करेल आज्ञा वश्ती राणीनी मान्य करी नही तर आम्हीन कायदेशीर रितीतीन तिनं काय करानं?” ");
INSERT INTO ahr_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","तवय ममुखाननी राजाले अनं सरदारसले उत्तर दिधं, “वश्ती राणीनी हाऊ अपमान फक्त राजाना करेल शे अस नही? तर सर्वा सरदारसना अनं अहश्वेरोश राजानं सर्वा प्रांतमा राहनारा सर्वा लोकेसनाबी करेल शे. ");
INSERT INTO ahr_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","राणीनी हाई कृत्यनी बातमी सर्वा बायासले लागी अनी राजा अहश्वेरोश यानी वश्ती राणीले आपलासमोर येवाले आज्ञा करी तरी बी ती वनी नही, अस तिसले समजी तवय त्या आप आपला नवरासले तुच्छ मानाले लागतीन. ");
INSERT INTO ahr_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","आज राणीनं हाई कृत्य पारस अनं मेदय देशना ज्या सरदार बायासनी ऐकेल शे त्या राजाना सरदारसले अशच म्हणतीन; तवय भलतं अपमान अनं संताप उत्पन्न व्हई. ");
INSERT INTO ahr_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","राजानी मर्जी व्हई तर त्यानी एक राजकीय फर्मान फिरवानं अनी काही फेरबदल व्हवाले नको म्हणीन पारसी अनं मेदय देशना कायदामा अस लिखी ठेवानं की वश्ती राणीनी अहश्वेरोश यानासमोर परत येवानं नही अनी तिनापेक्षा कोणी चांगली व्हई तिले पद्दराणीनं पद भेटी. ");
INSERT INTO ahr_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","राजानी हाई आज्ञा त्याना सर्वा विस्तीर्ण साम्राज्यमा जाहीर व्हई तवय सर्वा बायका आपला धाकला किंवा मोठा अस आपला नवराले मान देतीन.” ");
INSERT INTO ahr_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","हाई बोलनं, राजाले अनं सरदारसले पटनं अनी ममुखानना सांगाप्रमाणं राजानी करं. ");
INSERT INTO ahr_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","त्यानी आपला राज्यमाधला सर्वा प्रांतमाईन त्या त्या प्रांतना लिपीमा अनं त्या त्या राष्‍ट्रनी भाषामा पत्रे धाडात की प्रत्येक माणुसनी आपला घरमा सत्ता चालाडानी अनी हाई आज्ञा आपला लोकसन्या भाषासमा प्रसिध्द करानी. ");
INSERT INTO ahr_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","यानानंतर अहश्वेरोश राजाना राग शांत व्हयना, तवय त्याले वश्ती राणीनी काय करेल व्हतं अनं त्यामुये तिनाविरूध्द काय ठराव व्हयेल व्हता यानं याद वनी. ");
INSERT INTO ahr_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","मंग त्यानी सेवाचाकरी करनारा त्याना सेवक त्याले बोलनात, “राजाकरता तरूण अनं देखणी कुवारीसना शोध करानं; ");
INSERT INTO ahr_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","राजानी आपला सर्वा प्रांतसमा अमलदार नेमानं; त्यासनी सर्वा देखण्या अनं तरूण कुवाऱ्या शूशन वाडामाधलं अंतपुरमा गोया करीसन राजबाईसना रक्षक हेगे नावना खोजा जो शे, त्याना स्वाधीन करानं अनी त्यासन्या शुध्दताकरता त्यासले पाहिजे त्या वस्तु देवानं; ");
INSERT INTO ahr_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","मंग त्यासनापाईन जी कुवारी राजाना मनमा ई ती वश्ती राणीना ठिकाणमा राजानी पट्टराणी व्हवानं.” हाई गोष्ट राजाले पसंत पडनी मंग त्यानी त्यानाप्रमाणे करं. ");
INSERT INTO ahr_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","शूशन राजवाडामा मर्दखय बिन याईर बिन शिमई बिन कीश हाऊ नावना एक बन्यामिनी यहूदी व्हता; ");
INSERT INTO ahr_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","बाबेलना राजा नबुखद्नेस्सर यानी यहूदाना राजा यखन्या यानाबरोबर ज्या लोके यरुशेलममाईन धरी लेयल व्हतात त्यासनापाईन हाऊ एक व्हता. ");
INSERT INTO ahr_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","त्यानी आपला चुलतानी पोर हदस्सा म्हणजे एस्तेर हिना पालनपोषण करेल व्हतं; तिले मायबाप नव्हतात; ती पोर देखणी अनं रूपवान व्हती. तिना मायबाप मरावर मर्दखयनी तिले स्वतःनी पोरनागत सांभाळेल व्हता. ");
INSERT INTO ahr_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","राजानी आज्ञा अनं त्याना ठराव प्रसिध्द व्हवावर बऱ्याच कुवाऱ्या शूशन राजवाडामा हेगेना हवाली करामा वन्यात; एस्तेर हिलेबी राजमंदिरमाधलं बाईसना रक्षक हेगे याना ताबामा दिधं. ");
INSERT INTO ahr_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","ती तरूण बाई त्याले पसंत पडनी अनं तो तिनावर प्रसन्न व्हयना; त्यानी काहीबी उशीर न करता तिना शुध्दतेना वस्तु, तिना भोजन पदार्थ अनी तिले साजीत अश सात सख्या राजवाडामाईन दिधात अनी तिले अनं तिना सख्यीसले तठेन लिसन अंतपुरमा सर्वापेक्षा उत्तम जागा रावाले दिधी. ");
INSERT INTO ahr_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","एस्तेरनी आपलं घराणाबद्दल सांगात नहीत; तिनी सांगाले नको म्हणीन तिले मर्दखयनी बजाईन सांगेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","एस्तेर कशी काय शे अनं तिनं काय व्हई, हाई समजाकरता मर्दखय रोजनरोज अंतपुरना अंगणसमोर फेऱ्या मारे. ");
INSERT INTO ahr_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","बाईसनाबाबत ठरायेल नियमप्रमाणे बारा महिनापावत सर्वा काही उपचार व्हवावर एक एक कुवारीनी अहश्वेरोश राजाकडे जावानी पाळी वनी. त्यासन्या शुध्दीकरणनी रीत सांगं म्हणजे त्यासले गंधरसना तेल सहा महिना अनं सुगंधी द्रव्य सहा महिना लायेत; तसेच इतर शुध्दतेना वस्तु त्यासले लायेत. ");
INSERT INTO ahr_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","कुवारीनी राजानाकडे जावाना प्रकार अश: अंतपुरमाईन राजमंदिरमा जावाना येळले जे काही ती मांगे ते तिले देवामा येई. ");
INSERT INTO ahr_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","संध्याकाळले ती जाये, अनी सकासले ती उपपत्नीना रक्षक राजाना खोजा शाशगज याना देखरेखखाल दुसरा अंत:पुरमा जाये; राजानी तिनावर प्रसन्न व्हईन तिनं नाव लिसन बलावाशिवाय ती परत त्यानाकडे नही जाये. ");
INSERT INTO ahr_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","मर्दखयना चुलता अबीहाइल यानी पोर एस्तेर, जिले मर्दखयनी पोर म्हणीन सांभाळेल व्हतं. तिनी राजानाजोडे जावानी पाळी वनी तवय बाईसना रक्षक राजाना खोजा हेगे यानी जे तिले देवानं ठरायेल व्हतं त्यानापेक्षा जास्त काही तिनी मांगात नही. ज्यानी ज्यानी एस्तेरले दखा त्या सर्वासनी तिनावर कृपादृष्टी व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","हाई एस्तेर अहश्वेरोश राजाना कारकीर्दीना सातवा वरीसना दहावा महिनामा म्हणजे तेबेथ महिनामा राजमंदिरमा राजाकडे लवामा वनी. ");
INSERT INTO ahr_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","राजानी एस्तेरवर इतर बायासपेक्षा जास्त प्रिती करी अनी बाकिन्या सर्वा कुवारीसपेक्षा तिनावर त्याना अनुग्रह अनं कृपादृष्टी विशेष व्हयनी. त्यानी तिना डोकामा राजमुकूट घालात अनं वश्तीना जागवर तिले राणी करं. ");
INSERT INTO ahr_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","मंग राजानी सर्वा सरदार अनं सेवक यासले एस्तेरना निमित्त मोठी मेजवाणी दिधी; प्रांतोप्रांतीसना लोकसना कर माफ करात अनी आपला उदारताले शोभनारं इनामं दिधं. ");
INSERT INTO ahr_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","कुवारी दुसरांदाव एकत्र गोया व्हयन्यात तवय मर्दखय राजद्वारी बठेल व्हता. कारण राजानी त्याले आपल्या सेवामां ह्या येळले नियुक्त करेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","एवढा येळ एस्तेरनी आपलं घराणाबद्दल सांगेल नव्हतं; मर्दखयनी तिले तशीच आज्ञा देल व्हती. एस्तेरना मर्दखयना आठे संगोपन व्हई राहिंता तवय जशी ती त्यानी आज्ञा माने, त्यानाप्रमाणेच तिनी ह्या येळले बी त्यानी आज्ञा मानी. ");
INSERT INTO ahr_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","त्या दिनले मर्दखय राजद्वारमा बसेल राहे; तवय राजाना द्वारपाळस पैकी त्याना दोन खोजा बिग्थान अनं तेरेश ह्या संतापमा अहश्वेरोश राजावर हात टाकानी संधी दखी राहिंतात. ");
INSERT INTO ahr_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","मर्दखयले हाई गोष्ट समजनी तवय त्यानी ती एस्तेर राणीले सांगं, अनी एस्तेरनी मर्दखयना नावतीन राजाले ती सांगी. ");
INSERT INTO ahr_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","चौकशी व्हवावर ती बातमी खरी ठरनी; तवय त्या दोन्हीसले झाडंसवर फाशी दिधी, हाई माहिती राजानासमोर इतिहासना ग्रंथमा लिखी ठेवामा वना. ");
INSERT INTO ahr_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","या गोष्टी घडी जावावर अहश्वेरोश राजानी अगागी हामान बिन हम्मदाथा याले बढती दिसन पंतप्रधान बनाडं अनं त्यानाबरोबरना सरदारसंपेक्षा त्यानं आसन उचा करात. ");
INSERT INTO ahr_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","राजद्वारमा असेल राजाना बट्टा सेवक हामाननासमोर वाकीसन त्याले मुजरा करीत राहेत, कारण त्याना बाबतमा राजानी अशीच आज्ञा करेल व्हती; मर्दखय त्याले अजिबात नमन किंवा मुजरा करे नही. ");
INSERT INTO ahr_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","तवय राजद्वारमाधला राजसेवकसनी मर्दखयले ईचारं, की, तू राजआज्ञाना काबंर उल्लंघन करस? ");
INSERT INTO ahr_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","त्या त्याले अश रोज सांगेत तरी त्यानी त्यासनं बोलनं, ऐकं नही, तवय मर्दखयना हाई चालावू किंवा नही हाई दखाकरता त्यासनी हामानना कानमा हाई गोष्ट टाकी; आपण यहूदी शेतस अस त्यानी त्यासले सांगेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","मर्दखय आपलासमोर वाकीन मुजरा करस नही हाई हामाननी दखं तवय त्याले त्याना भलता राग वना. ");
INSERT INTO ahr_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","एकटा मर्दखयवर हात टाकानं हाई त्याले हलकं वाटनं, कारण मर्दखय कोणता जातना शे हाई त्यासनी हामानले सांगेल व्हतं; त्यामुये अहश्वेरोशना सगया साम्राज्यमाधला मर्दखयना लोके म्हणजे सर्व यहूदी लोके यासना नायनाट कराना बेत हामाननी करा. ");
INSERT INTO ahr_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","अहश्वेरोश राजाना कारकीर्दीना बारावा वरीसले त्यासनी पहिला म्हणजे निसान महिनापाईन हामाननासमक्ष चिठया टाकाले लायात. हाऊ क्रम दररोज, दरमहिनाले, बारावा महिना अदार संपापावत चालू राहिना. ");
INSERT INTO ahr_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","हामान अहश्वेरोश राजाले बोलना, “आपला साम्राज्यमाधला सर्वा प्रांतामाईन राहनारा देशदेशना लोकसमा पांगेल अनं विखरेल एक राष्ट्र शे; त्या लोकेसना कायदा इतर सर्वा लोकसना कायदापेक्षा येगळा शेतस. त्या राजाना कायदाप्रमाणे चालतस नही म्हणीन त्यासले राहू देवानं राजाना हितना नही शे. ");
INSERT INTO ahr_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","राजानी मर्जी व्हई तर त्यासना नाश करानं अशी आज्ञा लिखानी; राजभांडारमा गोया कराकरता मी दहा हजार चांदीना शिक्का राजाना कारभारीसना हातमा देस.” ");
INSERT INTO ahr_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","तवय राजानी आपली आंगठी बोटमाईन काढीन यहूदीसना शत्रु हामान बिन हम्मदाथा याले दिधी. ");
INSERT INTO ahr_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","राजानी हामानले सांगं, तुले चांदी देल शे अनं लोकं बी देल शेतस; तुले वाटी तसं त्यासनं कर. ");
INSERT INTO ahr_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","तवय पहिला महिनाना त्रयोदशीस राजानं लेखकसले बोलवामा वनात अनी राजानं प्रतिनिधि, प्रत्येक प्रांतना सुभे अनं सगया लोकसना सरदार यासले हामानना सांगेल प्रमाणे प्रत्येक प्रांतना लिपीक अनं प्रत्येक जातीना लोकसना भाषामा खलिते लिखीन धाडामा वना. अहश्वेरोश राजाना नावतीन ते लिखीन त्यानावर राजानी आंगठीना मोहर करेल व्हती. ");
INSERT INTO ahr_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","राजाना सर्वा प्रांतप्रांतमाईन जासूदसना हाततीन अश आशयानी पत्रं धाडामा वनं की, एकच दिनले म्हणजे बारावा अदार महिनाना त्रयोदशीसले म्हातारा, जवान, बाया, पोऱ्या अश सर्वा यहूदी लोकसना विध्वंस अनं नायनाट कराना अनं त्यासनी धनसंपत्ती लुटी लेवानी. ");
INSERT INTO ahr_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","हाई आज्ञा पत्रसन्या प्रत सर्वा प्रांतासमा खुल्या धाडात. त्या अशा हेतूतीन की सर्वा लोकसनी त्या दिनले तयार रावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","हाऊ हुकूम शूशन राजवाडामा देवामा वना अनी राजआज्ञा मानीसन जासूद लगेच निंघी गयात; त्या येळले राजा अनं हामान ह्या पेवाले बसनात; पन शुशन नगर चिताक्रांत व्हयनं. ");
INSERT INTO ahr_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","हाई बातमी मर्दखयना कानमा पडनी तवय त्यानी आपला कपडा फाडात. गोणताट नेसीन राख लाई अनी नगरना मध्यभागमा जाईन जोरमा ओरड करी. ");
INSERT INTO ahr_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","तो राजमंदिरना दरवाजासमोरबी गया; गोणताट नेसीन राजमंदिरना दरवाजाना मझार जावाले कोणलेच परवांगी नही राहे. ");
INSERT INTO ahr_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","राजाना हुकूम अनं फर्मान ज्या ज्या प्रांतमा जाईन पोहचना तठे तठे यहूदी लोकसमा मोठा विलाप, उपोषण अनं रडारड चालू व्हयनी; बराच लोके गोणताट नेसीन राखमा पडी राहिनात. ");
INSERT INTO ahr_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","एस्तेरन्या दासी अनं खोजासनी हाई बातमी तिले जाईन सांगात, तवय राणीले भलता खेद व्हयना; मर्दखयनी गोणताट काढीन कपडा घालानं म्हणीन तिने ते त्यानाकडे धाडात, पन त्या तो नही लिये. ");
INSERT INTO ahr_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","राजानी एस्तेरना तैनातमा ठेयेल खोजापाईन हथाक याले तिनी बोलाईसन सांगं की, मर्दखयकडे जाईन हाई काय अनं अश काबंर शे यानी चौकशी कर. ");
INSERT INTO ahr_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","हथाक निंघीन राजमंदिरना दरवाजासमोरना नगरना चौकमा मर्दखयकडे गया. ");
INSERT INTO ahr_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","आपलावर काय प्रसंग गुदरेल शे अनी यहूदी लोकसना वध व्हवाले पाहिजे म्हणीन हामाननी राजभांडारमा कितला पैसा भरेल शेतस हाई सर्वी माहिती मर्दखयनी त्याले सांगी. ");
INSERT INTO ahr_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","यहूदी लोकसना नाश करानंविषयी जी आज्ञा शूशन आठे देल व्हती त्या लेखनी प्रत बी एस्तेरले दखाडाकरता त्याना हातमा त्यानी दिधी अनी हाई सर्वा कयाडीसन त्यानी तिले अश बजावाले सांगं, की, तू राजाकडे जाईन आपला लोकसकरता ईनंती अनी रावन्या करानी. ");
INSERT INTO ahr_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","हथाकनी ईसन मर्दखयनं बोलनं एस्तेरले सांगं. ");
INSERT INTO ahr_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","तवय एस्तेरनी हथाकनासोबत मर्दखयले सांगी धाडात की, ");
INSERT INTO ahr_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","राजाना सर्वा सेवक अनं राजाना सर्वा प्रांतमाधला लोकेसले माहित शे की कोणी माणुस किंवा बाई बलावाशिवाय मझारना चौकमा राजाकडे गयी तर त्याले किंवा तिले प्राणदंड कराना अश सक्त हुकूम शे; मात्र राजा आपला सोनानं राजदंड ज्यानापुढे करी त्यानाच बचाव व्हई; माले तर आज तीस दिन राजाकडीन बोलावनं येल नही शे. ");
INSERT INTO ahr_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","एस्तेरना हाई सांगनं मर्दखयले कयाडामा वना. ");
INSERT INTO ahr_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","तवय त्यानी त्याना हाततीन एस्तेरले सांगीन धाडात की, “तू राजमंदिरमा शे म्हणीन तू यहूदी लोकसमाईन वाची जाशी अश तुना मनले नको वाटू देऊ. ");
INSERT INTO ahr_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","तू अस येळले गप्प राहिनीस तरी दुसरं कोठेन बी यहूदीसनी सुटका अनं मदत व्हईच. पण मंग तुनं अनं तुना बापना घरानाना नाश व्हई. तुले हाई असच येळनाकरता राजपद प्राप्त व्हयना नही कसावरीन!” ");
INSERT INTO ahr_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","मंग एस्तेर राणीनी मर्दखयले उलट निरोप धाडात की, ");
INSERT INTO ahr_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","जाय, शूशन आठला सर्वा यहूदीसले गोया करा; मनाकरता उपास करा; तीन दिन अनं तीन रात अन्नपाणीले शिवानं नही; मी बी आपल्या दासीसंगे तसंच उपास करसु; अश स्थितीमा नियमनाविरूध्द मी राजाकडे जासू; मंग मी मरनी तर मरनी. ");
INSERT INTO ahr_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","मर्दखयनी जाईन एस्तेरना आज्ञाप्रमाणे सर्वा काही करात. ");
INSERT INTO ahr_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","तिसरा दिनले एस्तेर राणी आपली राजकीय कपडा घालीसन राजमंदिरना मझारना चौकमा जाईन राजमंदिरना समोर उभी राहिनी; राजा राजमंदिरमा सिंहासनवर राजद्वारसमोर बठेल व्हता. ");
INSERT INTO ahr_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","राजानी एस्तेर राणी आंगणमा उभी शे अश दखा तवय त्यानी तिनावर कृपादृष्टी व्हयनी; अनी राजानी आपला हातमाधला सुवर्णदंड पुढे करा. तवय एस्तेरनी जोडे जाईन राजदंडना टोकले स्पर्श करा. ");
INSERT INTO ahr_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","राजानी तिले ईचारं, “एस्तेर राणी, तुले काय पाहिजे? तुनी काय मागणी शे? अर्धा राज्यएवढी तुनी मागणी व्हई तरी भेटी.” ");
INSERT INTO ahr_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","एस्तेर राणी बोलनी, महाराजना मर्जीमा वनं तर मी आज आपलाकरता जे भोजन तयार करेल शे. त्यामा आपण हामानले लिसन यवानं. ");
INSERT INTO ahr_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","राजा बोलना, “जा हामानले लवकर लिसन या, म्हणजे एस्तेरना सांगेल प्रमाणे करानं.” मंग एस्तेरनी तयार करेल भोजनले राजा अनं हामान ह्या गयात. ");
INSERT INTO ahr_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","जेवतांना द्राक्षरस पेवाना येळले राजानी एस्तेरले ईचारं, “तुना काय अर्ज शे? तो मान्य करामा ई; तुनी मागणी काय शे? ती अर्धा राज्यनाएवढी राहिनी तरी तिनाप्रमाणे करामा ई.” ");
INSERT INTO ahr_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","एस्तेर बोलनी, “मना अर्ज अनं मागणी हाईच. ");
INSERT INTO ahr_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","महाराजनी मनावर कृपादृष्टी व्हयनी शे तर अर्ज मंजुर करानं अनं मनी मागणी मान्य करानी अश महाराजसना मर्जीमा वना व्हई तर मी मेजवाणी करसु तिले महाराजसनी अनं हामाननी येवानं, मंग महाराजसनी सांगेल प्रमाणे मी सकाय काय मांगानं ते मांगसु.” ");
INSERT INTO ahr_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","त्या दिनले हामान आनंदमा अनं प्रसन्न‍ व्हईसन बाहेर निंघना; पन राजवाडामा दरवाजाजोडे आपलाले दखीन मर्दखय उठना नही की घाबरना नही हाई हामाननी दखं तवय त्याले त्याना भलता राग वना; ");
INSERT INTO ahr_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","तरी आपला राग आवरीन हामान घर गया अनी त्यानी आपला मित्र अनं आपली बाई जेरेश यासले बोलावनं धाडीन आणात. ");
INSERT INTO ahr_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","आपला धनसंपतीना थोरवी, आपला संपत्तीना विस्तार, राजानी आपलाले कसं बढती दिसन राजानं सरदार अनं सेवक यासनावर दर्जा देयल शे. हाई सर्वा त्यानी त्यासले सांगी दखाडा. ");
INSERT INTO ahr_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","हामाननी त्यासले अजुन सांगं की, “एस्तेर राणीनी मेजवानी दिधी, त्या मेजवानीमा तिनी राजानासोबत मनाशिवाय दुसरा कोणलेच बलायं नही; सकाय बी तिनी माले राजानासोबत आमंत्रण देयल शे. ");
INSERT INTO ahr_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","एवढं राहिसनबी तो मर्दखय यहूदी राजद्वारनाजोडे बसेल मना नजरमा पडेल शे. तोपावत हाई सर्वा व्यर्थ शे.” ");
INSERT INTO ahr_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","तवय त्यानी बाई जेरेश अनं त्याना सर्वा मित्र त्याले बोलनात, “पन्नास हात उचा फाशी देवाना एक खांब उभा कराना अनी सकायसले राजाले विनंती करानं की मर्दखयले त्यानावर फाशी देवानं; मंग तुम्हीन आनंदमा राजानासोबत मेजवानीले जा.” हाई गोष्ट हामानले पसंत वाटनी त्यानी फाशीना खांब तयार करी लिधा. ");
INSERT INTO ahr_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","त्या रातले राजानी झोप उडनी; तवय त्याना आज्ञातीन इतिहासना ग्रंथ आणीसन लोकसनी त्यानापुढे वाचात. ");
INSERT INTO ahr_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","त्यामा हाई लिखेल व्हतं: अहश्वेरोश राजाना खोजे द्वारपाल राहेत, त्यासनामाईन दोनजन बिग्थान अनं तेरेश यासनी राजावर हात टाकाना बेत करानी बातमी मर्दखयनी दिधी. ");
INSERT INTO ahr_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","तवय राजानी ईचारं की, “हाई कामगिरीबद्दल मर्दखयना काही गौरव किवा मानसम्मान करामा वना का?” तवय राजाना सेवा करनारा सेवकसनी त्याले सांगं, “त्यानाकरता ते काहीच करामा वनं नही.” ");
INSERT INTO ahr_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","तवय राजानी ईचारं, “चौकमा कोण शे?” त्या येळले हामान राजमंदिरना बाहेरना चौकमा येल व्हता, फाशी देवाना जो खांब त्यानी बनाडेल व्हता त्यानावर मर्दखयले फाशी देवानी म्हणीन तो राजानाजोडे ईनंती कराकरता येल व्हता. ");
INSERT INTO ahr_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","राजसेवकसनी राजाले सांगं, हामान चौकमा उभा शे. राजा बोलना, “त्याले मझार बलावा.” ");
INSERT INTO ahr_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","हामान मझार येवावर राजानी त्याले ईचारं, “एकादा माणुसना मानसम्मान करानं राजानं मनमा वना तर त्या माणुसनीकरता काय कराले पाहिजे? तवय हामान आपला मनमा ईचारं कराले लागना, मनापेक्षा दुसरा कोनी जास्त मानसम्मान करानं राजानी मनमा ई.” ");
INSERT INTO ahr_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","हामान राजाले बोलना, “एकादानं गौरव करानं राजानं मनमा वना तर. ");
INSERT INTO ahr_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","महाराज वापरतस तो कपडा आणानं, त्यानाप्रमाणच ज्या घोडावर महाराज स्वारी करतस तो अनं महाराजना डोकावर जो राजमुकूट ठेवतस तो आणानं; ");
INSERT INTO ahr_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","मंग तो कपडा अनं घोडा महाराजना कोन एक मोठा सरदारना हातमा दिसन महाराज ज्यानं गौरव कराले इच्छितस त्याले त्यानी कपडा घालानं. अनी त्याले घोडावर बसाडीसन नगरना चौकमाईन त्यानी मिरवणूक काढानी अनी त्यानापुढे हाई प्रचार करानं की, ‘महाराज ज्यानं गौरव कराले इच्छितस त्यानं सम्मान हाई प्रकारमा व्हस!’” ");
INSERT INTO ahr_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","राजा हामानले बोलना, पटकन हाऊ कपडा अनं हाऊ घोडा ले अनी राजद्वारनाजोडे मर्दखय बसना शे, त्यानं सम्मान तुना सांगाप्रमाण कर, तू बोलनास तसं करामा काहीबी कमी व्हवाले नको. ");
INSERT INTO ahr_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","हामाननी तो कपडा अनं तो घोडा लिसन मर्दखयले सजाडं अनी शहरना रस्तातीन त्यानी मिरवणूक काढीन त्यानापुढे प्रचार करा की, “महाराज ज्यानं गौरव कराले दखतस त्यानं सम्मान या प्रकारमा व्हसं!” ");
INSERT INTO ahr_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","मर्दखय राजद्वारनाजोडे परत वना अनी हामान शोक करत अनं आपलं तोंड झाकीन लगेच आपला घर निंघी गया. ");
INSERT INTO ahr_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","मंग हामाननी आपली बाई जेरेश अनं आपला सर्वा मित्र यासले आपलावर येल प्रसंग बद्दल माहिती सांगी. तवय त्याना बुध्दिमान मित्र अनं त्यानी बाई ह्या त्याले बोलनात, “हाऊ मर्दखयनापुढे तुमना पराभव व्हई राहिना शे, तो जर यहूदी वंशमाधला व्हई तर तुमनं वर्चस्व व्हवावू नही, त्यानापुढे तुमना पराभवच व्हई.” ");
INSERT INTO ahr_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","त्यानी बाई त्यानासंगे बोली राहिंती तितलामाच राजाना खोजा वनात अनी एस्तेर राणीनी तयार करेल मेजवाणीमा त्या हामानले लगेच लई गयात. ");
INSERT INTO ahr_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","ठरायेल येळना प्रमाणे राजा अनं हामान एस्तेर राणीना मेजवाणीमा गयात. ");
INSERT INTO ahr_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","दुसरा दिनले भोजनना येळले द्राक्षरस पेवाना येळले राजानी एस्तेरले परत ईचारं, “एस्तेर राणी तुनं काय अर्ज शे? ते मान्य करामा ई. तुनी मागणी काय शे? ती अर्धा राज्यना एवढी बी राहिनी तरी तीनाप्रमाणे करामा ई.” ");
INSERT INTO ahr_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","मंग एस्तेर राणी बोलनी, “महाराज, मनावर आपली कृपा दृष्टी व्हयेल शे, तर आपला मर्जीमा वना तर माले अनं मना लोकसले जीवनदान देवानं हाऊच मना अर्ज अनं ईनंती शे. ");
INSERT INTO ahr_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","मना अनं मना लोकसना विध्वंस, संहार अनं नायनाट व्हवाले पाहिजे हाई हेतूतीन आमनी विक्री व्हई जायेल शे; आम्हीन फक्त दासदासी व्हवाले पाहिजे हाई हेतूतीन आमनी विक्री व्हती तर आम्हीन गप्प ऱ्हातुत; तरी बी त्या स्थितीमा त्या वैरीले राजाना नुकसाननी भरपाई करता नही येती.” ");
INSERT INTO ahr_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","अहश्वेरोश राजानी एस्तेर राणीले ईचारं, “अस करानं धाडस करनारा कोन शे? अनं तो कोठे शे?” ");
INSERT INTO ahr_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","एस्तेर राणी बोलनी, “हाऊ विरोधी अनं हाऊ शत्रु कोण शे म्हणीन इचारशात तर, हाऊ दुष्ट हामानच शे!” हाई ऐकीन राजा अनं राणी यासनापुढे हामान घाबरना. ");
INSERT INTO ahr_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","तवय राजा रागाईसन भोजनवरीन उठना अनं राजमंदिरना बागमा गया; तवय माले जीवनदान द्या अशा रावण्या करत हामान एस्तेर राणीनापुढे उभा राहिना; कारण राजानी आपलं वाईट करानं ठराई लेयल शे हाई‍ त्याले समजी जायेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","मंग राजा मंदिरना बागमाईन त्या भोजनना जागामा परत वना तवय एस्तेर राणीना मंचकवर हामानले वाकेल त्यानी दखं तवय राजा बोलना, “हावु घरमा अनी मनासमोर हाऊ राणीवर जबरदस्ती बी कराले दखस का?” राजाना तोंडतीन हाई शब्द निंघताच सेवकसनी जाईन हामाननं तोंड झाकं. ");
INSERT INTO ahr_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","राजाना तैनातीमा राहेल खोजापाईन हरबोना नावना एक खोजा बोलना, दखा, हामानना आठे पन्नास हात उचा एक फाशी देवाना खांब उभा करेल शे; ज्या मर्दखयनी राजाना हितकरता खबर दिधी त्याले टांगाकरता हामाननी तो उभा करेल शे. राजानी सांगं, “तोच खांबवर याले फाशी द्या.” ");
INSERT INTO ahr_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","तवय जो खांब मर्दखयाकरता हामाननी तयार करेल व्हता तेनावर त्यालेच फाशी दिधी. तवय राजाना राग शांत व्हयना. ");
INSERT INTO ahr_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","त्याच दिनले अहश्वेरोश राजानी यहूदीसना वैरी हामान यानं घरदार एस्तेर राणीले दिधं. मर्दखय बी राजाकडे वना; कारण त्यानं एस्तेरनासंगे काय नातं व्हतं ते तिनी राजाले सांगेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","हामानकडीन लेयल आंगठी राजानी काढीन मर्दखयले दिधी. एस्तेरनी मर्दखयले हामानना घरना कारभारी नेमं. ");
INSERT INTO ahr_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","मंग एस्तेरनी परत राजाले अर्ज करा; ती त्याना पाय पडनी अनी रडीसन त्यानी मोठी कळकळ करिसन तिनी सांगं, यहूदीसना नायनाट करानाविषयी अगागी वंशना हामान यानी करेल अनर्थ योजना रद्द करामा येवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","तवय राजानी एस्तेरनापुढे आपला सोनाना राजदंड करात अनी एस्तेर उठीसन राजानापुढे उभी राहिनी. ");
INSERT INTO ahr_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","ती बोलनी, “महाराजना मर्जीमा वना व्हईते, मनावर त्यासनी कृपादृष्टी व्हयनी व्हई तर, त्यासले योग्य दिसनं किंवा मी त्यासले आवडत व्हसू, तर महाराजसना सर्वा प्रांतमा ज्या यहूदी शेतस त्यासना नायनाट करानाविषयी अगागी हामान बिन हम्मदाथा यानी ज्या पत्र लिखी धाडेल शेतस त्या रद्द व्हवाले पाहिजे अश फर्मान धाडामा येवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","मना लोकेसवर जो अनर्थ ई तो मी कस काय दखू? मना घराणासना नाश व्हई तो मी डोयासघाई कस काय दखू?” ");
INSERT INTO ahr_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","मंग अहश्वरोश राजा एस्तेर राणीले अनं मर्दखय यहूदीले बोलना, “हामाननी यहूदीसवर हात टाकात म्हणीन त्यानं घरदार एस्तेरले दिधं अनं त्याले फाशी दिधी. ");
INSERT INTO ahr_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","तुमले वाटी त्यानाप्रमाणे राजाना नावतीन यहूदीसविषयी लिखानं, अनी पत्रसवर राजानी मोहर करानं; राजानं नावतीन लिखेल लेख अनं त्यानावर व्हयेल राजानी मोहर कोनले बी रद्द करता येवावू नही.” ");
INSERT INTO ahr_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","त्या येळले शिवान महिनाना म्हणजे तिसरा महिनाना तेवीसवा दिनले राजाना लेखकसले बलावामा वनं, अनी मर्दखयना सांगाप्रमाणे इस्त्राएलना अधिपतीसले अनी भारतपाईन कूश देशपावतना एकशे सत्तावीस परगन्यासना अधिपती अनं सरदार यासले प्रत्येक प्रांतना लिपीमा अनं येगयेगळा लोकसना भाषामा अनी यहूदीसले त्यासना लिपीमा अनं भाषामा पत्र धाडामा वनात. ");
INSERT INTO ahr_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","मर्दखयनी अहश्वेरोश राजानं नावतीन पत्र लिखीन त्यानावर राजानी मोहर करीन ती वेगवान सरकारी घोडा, खेचरे यासना स्वारसनासोबत डाकतीन धाडी दिधात. ");
INSERT INTO ahr_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","त्या पत्रसमा सर्वा नगरसना यहूदीसले परवानगी देल व्हती की तुम्हीन एकत्र गोया व्हईन आपला प्राणना रक्षण कराकरता उभं रावानं अनी ज्या ज्या प्रांतमाधला लोके जबरदस्ती व्हईन तुमले, तुमन्या बायासले अनं तुमना पोऱ्यासोऱ्यासले उपद्रव देवाले दखतीन त्यासना नायनाट करानं अनं त्यासनी धनसंपत्‍ती लुटी लेवानी. ");
INSERT INTO ahr_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","हाई सर्वा एकच दिनले बारावा म्हणजे अदार महिनाना त्रयोदशीसले अहश्वेरोश राजाना सर्वा प्रांतमा करामा येवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","फर्माननी नक्कल प्रत्येक प्रांतमा प्रसिध्द व्हवाले पाहिजे अनी त्या दिनले आपला शत्रुनं उसनं फेडाले सर्वा यहूदीसनी तयार ऱ्हावाले पाहिजे अश सर्वा लोकसले जाहिर करामा वना. ");
INSERT INTO ahr_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","डाकना स्वारसनी सरकारी वेगवान घोडासवर स्वार व्हईसन राजानी आज्ञाप्रमाणं तवय लगेच वाटचाल करी; हाऊ हुकूम शूशन राजवाडामाईन सोडामा वना. ");
INSERT INTO ahr_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","मंग मर्दखय निळा, ढवळा रंगना राजकीय कपडा घालीन, डोकावर सोनाना मोठा मुकुट ठेईन, अनं तलम सणाना अनं जांभळा रंगना झगा घालीन राजानासमोरतीन निंघना; तवय शूशन नगरना लोके आनंदमा जयघोष कराले लागनात. ");
INSERT INTO ahr_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","अनी यहूदी लोकसले उल्लास आनंद अनं मान हाई प्राप्त व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","ज्या प्रांतमा अनं ज्या नगरमा राजानी आज्ञा अनं फर्मान जाईन पोहचना तठला यहूदी लोकसले मोठा आनंद व्हयना अनी त्यासनी भोजनसमारंभ करीन तो मंगलदिन म्हणीन पाळात अनी त्या देशना पुष्कळ लोके यहुदी व्हयनात, कारण त्यासले यहूदीसना मोठा धाक बसेल व्हता. ");
INSERT INTO ahr_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","अदार जो बारावा महिना तेना त्रयोदशीले राजानी आज्ञा अनं फर्मान अमलमा ईसन यहूदी लोकेसवर वरचढ व्हवाना आशेना दिन जोडे वना तो सर्वा उलट व्हईन यहूदी लोके आपला वैरीसवर वरचढ व्हयनात; ");
INSERT INTO ahr_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","आपलाले उपद्रव करनारा वैरीसले हात दखाडाना म्हणीन अहश्वेरोश राजाना सर्वा प्रांतमाधला यहूदी लोके आपापला गावमा एकत्र गोया व्हयनात; त्यासनासंगे कोणलेबी सामना करानी हिंमत व्हयनी नही; त्यासना सर्वा लोकसले धाक बसना. ");
INSERT INTO ahr_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","प्रांतना सरदार, इलाखाना अधिपती, प्रांतना अधिपती अनं राज्य कारभार चालाडनारा सर्वाजण यासनी यहूदीसले मदत करी; त्या सर्वासले मर्दखयना धाक बसेल व्हता. ");
INSERT INTO ahr_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","मर्दखयना राजदरबारमा मोठा मान राहिसन त्यानी किर्ती सर्वा प्रांतमाईन पसरेल व्हती; मर्दखयना महिमा उत्तरोत्तर वाढत गई. ");
INSERT INTO ahr_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","इकडे यहूदी लोकसनी आपला सर्वा शत्रुसवर तरवार चालाडीसन त्यासना वध अनं नाश करात; मनमा ई तसं त्यासनी आपला विरोधीसना समाचार लिधात. ");
INSERT INTO ahr_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","शूशन राजवाडामा यहूदी लोकसनी पाचशे लोकसना वध करीन त्यासना धुव्वा उडावा. ");
INSERT INTO ahr_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","पर्शन्दाथा, दलफोन, अस्पाथा. ");
INSERT INTO ahr_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","पोराथा, अदल्या, अरीदाथा, ");
INSERT INTO ahr_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","पर्मश्ता, अरीसई. अरीदय अनं वैजाथा. ");
INSERT INTO ahr_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","ह्या यहूदीसना वैरी हामान बिन हम्मदाथा याना दहा पोऱ्या त्यासनी ठार करात. पण त्यासनी धन लुटा नही. ");
INSERT INTO ahr_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","त्या दिनले शूशन राजवाडामा ज्यासना वध व्हयना त्यासनी यादी राजाकडे आणी. ");
INSERT INTO ahr_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","तवय राजा एस्तेर राणीले बोलना, “यहूदीसनी शूशन राजवाडामाधला पाचशे माणसं अनं हामानना दहा पोऱ्या मारीसन त्यासना फडशा उडायेल शे; मंग राज्यना इतर प्रांतमा त्यासनी काय करं व्हई ते कोणले ठाऊक शे! आते अजून तुनं काही अर्ज शे का? तो मंजुर करामा ई; अजून काही मागणं शे का? त्यानाप्रमाणं करामा ई.” ");
INSERT INTO ahr_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","एस्तेर राणी बोलनी, “राजानी मर्जी व्हई तर आजना हुकूमनामायक सकाय बी कराले शूशन आठे यहूदीसले मुभा भेटाले पाहिजे अनी हामानना दहा पोऱ्यासले फाशी देवाना खांबवर लटकाडानं.” ");
INSERT INTO ahr_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","त्यानाप्रमाणं करानी राजआज्ञा व्हयनी. शूशन आठेन फर्मान निंघनात अनं लोकसनी हामानना दहा पोऱ्यासले फासावर लटकाडात. ");
INSERT INTO ahr_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","शूशन आठला यहूदीसनी अदार महिनाना चौदावा दिनले एकत्र गोया व्हईसन शूशन आठला तीनशे माणसंसले मारी टाकात; पण त्यासनी लुटेल धनले हात लाया नही. ");
INSERT INTO ahr_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","राज्यमाधला येगयेगळा यहूदी एकत्र व्हईसन आपला जीव वाचाडाले उभा राहिनात; त्यासनी आपला वैरीसपाईन पंचाहत्तर हजार लोकेसना नाश करात अनं त्या वैरीसपाईन विसावा पावनात; पण त्यासनी लुटले हात लायात नही. ");
INSERT INTO ahr_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","अदार महिनाना तेरावा दिनले हाई घडनं; त्यासनी चौदावा दिनले आराम करीसन तो दिन मेजवाणीना अनं आनंद उत्सवना ठरायं. ");
INSERT INTO ahr_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","पण शूशन आठला यहूदी तेरावा अनं चौदावा असा दोन दिनले एकत्र गोया व्हयनात अनी पंधरावा दिनले त्यासनी आराम करीसन तो दिन मेजवाणीना अनं आनंद उत्सवना ठरावा. ");
INSERT INTO ahr_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","पण गावकूस न राहेल गावमा राहनारा गावढेकरी यहूदी अदार महिनानी चौदावा दिनले आनंद उत्सवना मंगलदिनले एकमेकसले भेटना ताटे धाडाना दिन ठराईसन पाळतस. ");
INSERT INTO ahr_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","मंग मर्दखयनी हाई सर्वी माहिती लिखी काढी अनी अहश्वेरोश राजाना दूरना अनं जोडेना सर्वा प्रांतमाधला यहूदी लोकसले पत्र धाडीसन येनाप्रमाणं फर्मान करात. ");
INSERT INTO ahr_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","अदार महिनाना चौदावा अनं पंधरावा ह्या दिन वरीसन वरीसले पाळत जावानं. ");
INSERT INTO ahr_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","ह्या दिनले यहूदीसले आपला शत्रुसपाईन विसावा प्राप्त व्हयना, हाऊ महिनामा दु:ख जाईन आनंद प्राप्त व्हयना, अनी शोक जाईन शुभदिन प्राप्त व्हयना, म्हणीन तो पाळानं; ह्या दिन आनंद उत्सव करामा, एकमेकसले भेटना ताटे धाडानं अनं गोरगरीबसले दानधर्म करामा घालानं. ");
INSERT INTO ahr_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","यहूदी लोकसनी सुरवात करेल व्हती त्यानाप्रमाणं अनं मर्दखयनी त्यासले लिखी धाडेल व्हतं त्यानाप्रमाणं यहूदीसनी संप्रदाय चालू करानं कबूल करात. ");
INSERT INTO ahr_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","सर्वा यहूदीसना विरोधी अगागी हामान बिन हम्मदाथा यानी यहूदीसना नाश कराना बेत करीसन त्यासना पुर्ण नायनाट कराकरता त्यानी पुर म्हणजे चिठया टाकेल व्हत्यात. ");
INSERT INTO ahr_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","पण राजाना ध्यानमा हाई प्रकरण ईसन त्यानी लेखी हुकूम करात यावरीन हामानना जे कपट कारस्थान यहूदी लोकेविरूध्द योजेल व्हतं ते त्यानाच माथावर उलटना अनी तो अनं त्याना पोऱ्या फाशीना खांबवर टांगामा वनात. ");
INSERT INTO ahr_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","यामुये पुर हाऊ शब्दवरीन त्या दिनले पुरीम हाई नाव पडनं. हाऊ पत्रमाधला अक्षरवरीन अनी त्यासनी स्वत: या बाबतमा जे दखेल व्हतं अनी त्यासनावर जे बितेल व्हतं त्यानावरीन. ");
INSERT INTO ahr_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","यहूदी लोकेसनी आपलाकरता, आपला वंशजकरता अनं ज्या त्यामा सामील व्हयना व्हतात त्यासनाकरता असा अढळ नियम अनं प्रतिज्ञा करी की, त्या लेखनानुसार वरीसवरीसले योग्य काळले ह्या दोन दिन पाळानं. ");
INSERT INTO ahr_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","अनी पिढानपिढी प्रत्येक कुटुंबमा, प्रत्येक प्रांतमा अनं प्रत्येक गावमा ह्या दिननं स्मरण करीसन तो पाळामा येवाले पाहिजे. हाऊ पुरीम सणना दिन पाळाले यहूदी लोकसनी चुकानं नही; त्यानं स्मरण त्यासना वंशजमाईन कधीच नष्ट व्हवाले नको. ");
INSERT INTO ahr_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","हाऊ दुसरा पत्रनानुसार पुरीम पाळानं मंजुर व्हवाले पाहिजे म्हणीन अबीहाइलानी पोर एस्तेर राणी हिनी अनी मर्दखय यहूदी यानी आपला अधिकारतीन फर्मान लिखात. ");
INSERT INTO ahr_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","त्याना नकला मर्दखयनी अहश्वेरोश राजाना एकशे सत्तावीश प्रांतमाधल्या सर्वा यहूदीसले लिखी धाडात; त्यामा शांती देनारा सत्यवचनं व्हतं. ");
INSERT INTO ahr_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","ह्या पत्रना आशय अश व्हतं की, पुरीमना नेमेल येळले मर्दखय अनं एस्तेर राणी यासन्या आज्ञा प्रमाणं अनी यहूदी लोकसनी स्वत:करता अनं आपला वंशजकरता करेल ठरावप्रमाणं उपवास अनं विलाप करामा येवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","पुरीमना संबधना नियम एस्तेरना आज्ञातीन स्थिर करामा वना, अनी हाई ग्रंथमा लिखी ठेवात. ");
INSERT INTO ahr_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","अहश्वेरोश राजानी देशवर अनं समुद्रजोडेना बेटसवर खंडणी बसाडी. ");
INSERT INTO ahr_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","त्याना सामर्थ्याना अनं पराक्रमना कृत्यसनी अनी मर्दखयले राजानी महतीस चढायं यानी साध्यंत हकीकत मेदय अनं पारसी यासना इतिहासना ग्रंथमा लिखेल नही शेतस का? ");
INSERT INTO ahr_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","मर्दखय यहूदी याना दर्जा अहश्वेरोश राजाना खालोखाल व्हता; यहूदी लोकसमा तो भलता थोर व्हता; त्याना बांधव समुदायमा त्यानी मोठी मान्यता व्हती; तो आपला लोकसनं कल्याण कराकरता प्रयत्न करत राहे, अनं आपला सर्व लोकसनं चांगलं कसं व्हई यानाकडे त्यानं ध्यान राहे.");
INSERT INTO ahr_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","यरुशेलममाधला राजा दावीदना पोर्‍या उपदेशक याना वचन. ");
INSERT INTO ahr_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","व्यर्थ हो‍ व्यर्थ! अस उपदेशक सांगस, व्यर्थ हो व्यर्थ! बठं काही व्यर्थ. ");
INSERT INTO ahr_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","हाई जगमां माणुस जे काही कष्ट करसं त्यामा त्याले काय फायदा? ");
INSERT INTO ahr_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","एक पिढी जास अनी दुसरी येस; फक्त पृथ्वी जशीनी तशीच राहास. ");
INSERT INTO ahr_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","सुर्य उगीसन मावळी जास अनी उगाना जागावर येस. ");
INSERT INTO ahr_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","वारा दक्षिण दिशाकडे वाहास अनी परत उलटीसनं उत्तर दिशाले वाहास; तो एकसारखा घुमीसनं परत परत आपली फेरी पुरी करसं. ");
INSERT INTO ahr_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","बठया नदया समुद्रले जाईसन मियस तरीबी समुद्र भरस नही. ज्या ठिकानले त्या जाईसन मियतस तठे त्या परत परत वाही राहातस. ");
INSERT INTO ahr_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","बठं काही थकाडी देनाऱ्या शेतस; कोनलेच त्यानं वर्णन करता येस नही; ते दखीसन डोयासना मन भरसं नही. ऐकीसन कानले समाधान मियस नही. ");
INSERT INTO ahr_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","एकदाव व्हयी गये ते परत व्हस, जे करामा येस तेच परत करामा ई; हाई जगमा नवीन आशे काहीच नही शे; ");
INSERT INTO ahr_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","हाई दख, काही नवीन शे का? आशे एखादी गोष्टनीबारामा एखादानी सांगं व्हई ती व्हई जायेल ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","जुनी आठवन राहीनी नही; मोरे जे काही व्हई त्यानी आठवन पुढलासले राहावावू नही. ");
INSERT INTO ahr_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","मी उपदेशक, यरुशेलममां इस्त्राएलना राजा व्हतू. ");
INSERT INTO ahr_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","हाई जगमा जे काही व्यापार चालतस त्यासना नीट शोध लाईसन आपली बुध्दीतीन त्याना रहस्य दखाले चित लावं; देवनी माणुसनीमांगे बराच कठीन कष्ट लायी देयल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","हाई जगमा ज्या काम चालतस ते मी दखेल शेतस; ते दख, ते बठं व्यर्थ, बिनकामना उदयोग शे. ");
INSERT INTO ahr_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","जे वाकडं शे ते सरय व्हस नही; जे कमी शे ते मोजता येस नही. ");
INSERT INTO ahr_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","मी आपला मनमा बोलनू, आपलामोरे यरुशेलमवर जेवढा राजा व्हई गयात त्यासनापेक्षा मी जास्त ज्ञान प्राप्त करी लिधा; ज्ञान अनी बुध्दी यानी पुरी वयख माले व्हई जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","ज्ञान काय, येडापना अनी मुर्खपना काय शे , हाई समजी लेवाले मी चित्त लावं, तवय माले आशे दखामा वनं की हाई बठं बिनकामना उदयोग शे. ");
INSERT INTO ahr_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","जठे ज्ञान जास्त तठे चिंता जास्त; ज्याले बुध्दी जास्त त्याले दु:खबी जास्त. ");
INSERT INTO ahr_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","मंग मी आपला मनमा बोलनू, चाल, हासी मजाकतीन मी तुले आजमाडी दखस; आते तु सुख भोगी ले; पण हाईबी व्यर्थ शे. ");
INSERT INTO ahr_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","मी हसीले बोलनू, तु येडा शे. हासी मजाकले बोलनू, तुनापाईन काय फायदा शे? ");
INSERT INTO ahr_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","मानवपोऱ्यानी आपला बठा आयुष्यमा हाई जगमा काय करं व्हई ज्यामुये त्याना हित व्हई याना निर्णय समजाले पाहीजे म्हनीसन विवेकनी मना मनमा संयमतीन द्राक्षरसघाई शरीरले आराम कसे भेटी अनी मुर्खपना आचरनना अवलंबन कशे करता येई याना मी आपला मनमा शोध करं. ");
INSERT INTO ahr_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","मी मोठमोठला काम हातमा लिधात; आपलाकता घरदार बांधात, द्राक्षना मया लावात. ");
INSERT INTO ahr_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","मी मनाकरता बागा अनी प्रत्येक प्रकारना झाडे लावात; ");
INSERT INTO ahr_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","झाडे लायेल जंगलले पाणीना पुरवठा व्हवाले पाहीजे म्हनीसन मी तलाव बनाडं. ");
INSERT INTO ahr_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","मी दास दासी ईकत लिधात; मना घरमा जन्म व्हयेल दास मना व्हयनात; बैल अनी कळप यासना मोठा धन मनाजोडे व्हतं, एवढ धन याना आगोदर यरुशेलममां कोनपानच नही व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","मी सोना चांदीसना अनी राजासनीजोडे देशदेशमासला ज्या किंमती वस्तुसना साठा मी करात. स्व:ताकरता गायक अनी गायिका अनी मनुष्यनापोऱ्याले सुख देवाकरता बऱ्याच बाया ठेयात. ");
INSERT INTO ahr_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","आशे मी मोठा व्हयनू; मना आगोदर यरुशेलमा जे व्हई गये त्यासनापेक्षा मी मोठा व्हयनू तरी मना बुध्दी कायम व्हती. ");
INSERT INTO ahr_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","मना डोयासनी ईच्छा धरी ते मी त्यासनापाईन येगळं करं नही; मी कोनतबी आनंदना ईषयनाबारामा आपल मन आवरं नही; कारन हाई बठी कष्टतीन मना मनले बरं वाटे; हाई बठी कष्ट करीसन माले एवढंच वनं. ");
INSERT INTO ahr_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","मंग मी मना हातघाई बनाडेल बठा काम अनी कष्ट याना निरीक्षन करं; पण दखा; बठं काही व्यर्थ अनी बिनकामना उदयोग शे; जगमा हित व्हई आशे काहीच नही शे. ");
INSERT INTO ahr_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","तवय मी, ज्ञान, येडापना अनी मुर्खपना यासकडे मी ध्यान दिधं; कारन राजानी मांगेतीन येनारा माणुसना हातघाई काय व्हई? आजपावोत लोके जे करत वनात तेच तो करस. ");
INSERT INTO ahr_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","मंग मना नजरमा वनं की आंधारपेक्षा जशे प्रकाश श्रेष्ठ शे तशे मुर्खपेक्षा ज्ञान श्रेष्ठ शे. ");
INSERT INTO ahr_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","ज्ञानना डोया त्याना डोकामा राहास; अनी मुर्ख आंधारमा चालस; आशे राहीसन सर्वासना वेग एकच शे आशे मना ध्यानमा वनं. ");
INSERT INTO ahr_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","मंग मी आपला मनमां बोलनू, मुर्खसना जो वेग तोच मना, तर मी एवढा ज्ञानी व्हयनू तरी कसाले? मी आपला मनमा बोलनू, हाई व्यर्थ शे; ");
INSERT INTO ahr_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","मुर्खसनामायक ज्ञान कायम राहास नही; कारन मोरे येनारा काय बठासले ईसर पडनार शे, तर दख, ज्ञानी कशा मरस पावस तर मुर्खनामायक! ");
INSERT INTO ahr_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","यावरतीन माले मना जीवनना ईट वना; कारन हाई जगमा जे काही व्यवहार व्हतस त्या माले चुकीना वाटनात; हाई बठं काही व्यर्थ अनी बिनकामना उदयोग शे. ");
INSERT INTO ahr_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","मना बठा कष्टना फय मनामांगेतीन येनारा माणुसले सोडीसन माले जानं पडी; हाई ध्यानमा ठेईसन मी हाई जगमा जे कष्ट करात त्याना माले संताप वना. ");
INSERT INTO ahr_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","तो चांगला निंघी का वाईट निंघी हाई कोनले माहीत? तरीबी जे काही मे कष्ट करीसनं अनी शहापन खर्च करीसन हाई जगमा जे प्राप्त करेल शे त्यावर तो ताबा चालाडी. हाईबी व्यर्थ शे! ");
INSERT INTO ahr_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","तरीबी हाई जगमा जे काही मी कष्ट करत व्हतू ते मी सोडी दिधं; अनी मी निराश व्हई गयू. ");
INSERT INTO ahr_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","कोनी सुज्ञता, ज्ञान अनी हुशारीतीन कष्ट करीसन प्राप्त करानं; अनी त्यानाकरता ज्या माणुसनी कष्ट करात नही त्याना वाटाले ते ठेईसन सोडी देवानं; हाईबी व्यर्थ अनी मोठं संकट शे. ");
INSERT INTO ahr_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","माणुस जे काही कष्ट करस अनी जीवनी उलथा पालथा करीसन हाई जगमा खटपट करस त्याना त्याले काय लाभ शे? ");
INSERT INTO ahr_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","त्याना बठा दिन दुखना राहातस; त्यानी दगदग कष्टमय राहास; रातलेबी त्याना मनले चैन नही राहास; हाईबी व्यर्थच शे. ");
INSERT INTO ahr_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","माणुसनी खावानं, पेवानं अनी कष्ट करीसन आपला जीवले सुख देवानं यानापेक्षा दुसरं सुख कोनतच नही; हाई देवकडतीन भेटस आशे मना ध्यानमा वनं. ");
INSERT INTO ahr_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","कारन त्याना प्रसादशिवाय खावापेवानं अनी सुख भोगानं हाई कोनले प्राप्त व्हई? ");
INSERT INTO ahr_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","जो माणुस देवना नजरमा चांगला त्याले तो बुध्दी, ज्ञान अनी सुख हाई देस; साठा कराना काम देव पापीसले देस; ते हयानाकरता की ज्या देवना नजरमा चांगला त्यासले ते देवानं; हाई व्यर्थ अनी बिनकामना उदयोग शे. ");
INSERT INTO ahr_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","प्रत्येक गोष्टले येळ काय राहास; हाई जगमां प्रत्येक कामले येळ ऱ्हास; ");
INSERT INTO ahr_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","जन्म व्हवानी येळ अनी मरानी येळ, रोप लावानी येळ अनी रोप उपटानी येळ ऱ्हास; ");
INSERT INTO ahr_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","वध करानी येळ अनी बरं करानी येळ, मोडानी येळ अनी बांधानी येळ ऱ्हास; ");
INSERT INTO ahr_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","रडानी येळ अनी हासानी येळ ऱ्हास; शोक करानी येळ अनी नाचानी येळ ऱ्हास; ");
INSERT INTO ahr_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","दगड फेकानी येळ ऱ्हास अनी दगड गोया करानी येळ ऱ्हास; दुसरा लोकेसले अलींगन देवानी येळ ऱ्हास अनी अलींगन आवरी धरानी येळ ऱ्हास; ");
INSERT INTO ahr_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","गोष्टि दखानी येळ ऱ्हास अनी दखाडानं थांबाडानी येळ ऱ्हास. वस्तुसले एकजागे करानी येळ ऱ्हास अनी ती फेकी देवानी येळ ऱ्हास; ");
INSERT INTO ahr_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","कपडा फाडानी येळ ऱ्हास; अनी त्या शिवानी येळ ऱ्हास; शांत बसानी येळ ऱ्हास अनी बोलानीबी येळ ऱ्हास; ");
INSERT INTO ahr_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","प्रेम करानी येळ ऱ्हास अनी व्देष देवानी येळ ऱ्हास; युध्द करानी येळ ऱ्हास अनी शांती करानी येळ ऱ्हास; ");
INSERT INTO ahr_vpl VALUES ("EC3_9","022_3_9","ECC","3","9","9","काम करनारा जे कष्ट करसं त्यामा त्याले काय फायदा? ");
INSERT INTO ahr_vpl VALUES ("EC3_10","022_3_10","ECC","3","10","10","देवनी मानवजातले जे काम पुरा कराले लायेल शे ते मी दखेल शे; ");
INSERT INTO ahr_vpl VALUES ("EC3_11","022_3_11","ECC","3","11","11","देवनी त्याना येळनुसार प्रत्येक गोष्ट बराबर बनाडेल शे, त्यानी त्याना मनमा अनंतकायना कल्पना तयार करेल शे; तरी देवना पहिलापाईन ते शेवटपावोतना काम माणुस समजु शकावू नही. ");
INSERT INTO ahr_vpl VALUES ("EC3_12","022_3_12","ECC","3","12","12","त्यासनी जीवता शेत तोपावोत खुश ऱ्हावानं अनी चांगलं करत ऱ्हावानं यानाशिवाय उत्तम दुसरं काहीच नही आशे माले समजनं. ");
INSERT INTO ahr_vpl VALUES ("EC3_13","022_3_13","ECC","3","13","13","अनी प्रत्येक माणुसनी खावानं, पेवानं अनी बठा कामसमाईन आनंद कशे मियाडानं हाई देवनी देणगी शे. ");
INSERT INTO ahr_vpl VALUES ("EC3_14","022_3_14","ECC","3","14","14","देव जे बी करसं ते सर्वकाय राहानार शे आशे माले समजनं. त्यामां जास्त काहीच मियावू नही अनी त्यामाईन काहीच कमी व्हवाऊ नही. कारन लोकेसनी आदरतीन त्यानाजोडे येवाले पाहिजे म्हनीसनं देवनी हाई बठ काही करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EC3_15","022_3_15","ECC","3","15","15","जे काही व्हई राहीनं शे ते याना आगोदर व्हई जायेल शे; अनी जे काही व्हवाव शे ते याना पहीलेच व्हई जायेल शे; देव व्हयेल गोष्टी मनुष्यसनापुढे आणस. ");
INSERT INTO ahr_vpl VALUES ("EC3_16","022_3_16","ECC","3","16","16","अनी हाई जगमा न्यायना ठिकान दखं तर तठे दुष्टता अस्तित्वमां व्हती. अनी नीतीमानना ठिकान दखं तवय तठे कायम दुष्टता सापडस. ");
INSERT INTO ahr_vpl VALUES ("EC3_17","022_3_17","ECC","3","17","17","मी मना मनमा बोलनू, देव प्रत्येक गोष्टनी अनी प्रत्येक कामनी योग्य येळले न्याय करी. ");
INSERT INTO ahr_vpl VALUES ("EC3_18","022_3_18","ECC","3","18","18","मी मना मनमा बोलनू, देव मानवजातनी पारख करस ते यानाकरता की आम्हीन जनावर शेतस हाई दखाडामा येवाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EC3_19","022_3_19","ECC","3","19","19","जे मानवजातमा घडस तेच जनावरसमा घडस; जशा जनावर मरतस तशे माणसेबी मरतस; त्या बठा एकच हावामाईन श्वास लेतस, जनावरपेक्षा मानवजात वरचढ नही; बठं काही व्यर्थ शे आशे वाटस नही का? ");
INSERT INTO ahr_vpl VALUES ("EC3_20","022_3_20","ECC","3","20","20","बठाच एकच ठिकानले जातस, बठं काही माटीपाईन येयल शे अनी बठं काही माटीले जाईसन मियतीन. ");
INSERT INTO ahr_vpl VALUES ("EC3_21","022_3_21","ECC","3","21","21","मानवजातना आत्मा वर जास अनी जनावरना जीव खाल जमीनमा जास हाई कोनले माहीत? ");
INSERT INTO ahr_vpl VALUES ("EC3_22","022_3_22","ECC","3","22","22","मंग मी दखं तवय, माणुसनी आपला काममा खुश ऱ्हावानं यानापेक्षा उत्तम काहीच नही, कारण हाऊ त्याना वाटा शे. कारण तो मरावर जे काही व्हई ते दखाले त्याले कोन परत लई? ");
INSERT INTO ahr_vpl VALUES ("EC4_1","022_4_1","ECC","4","1","1","मी परत एकदाव दखं, हाई जगमा जे काही जाचजुलूम चालतस ते मी दखं, दुखी लोकेसना आसु दखा, तठे त्यासले कोन सोडाई आशे कोनीच नही. त्यासवर ज्या जुलूम करतस त्यासनी हातमा ताकद शे; पण दुखी लोकेसले सोडावाले कोनीच नही. ");
INSERT INTO ahr_vpl VALUES ("EC4_2","022_4_2","ECC","4","2","2","त्याकरता मी ज्या मरी जायेल शेतस त्यासना अभिनंदन करस, ज्या आज जीवत शेतस अनी आज जगी राहीना शेतस, त्यासना नही. ");
INSERT INTO ahr_vpl VALUES ("EC4_3","022_4_3","ECC","4","3","3","ज्याना आजुन जन्म व्हयेल नही, ज्या हाई जगमा वाईट कृत्य करतस ते त्यानी आजुन दखं नही; तो त्या दोनीपेक्षा बरा शे आशे मी समजस. ");
INSERT INTO ahr_vpl VALUES ("EC4_4","022_4_4","ECC","4","4","4","मंग मी दखं तवय; बठा कष्ट अनी कारागीरना काम आशे शे, ज्यानामुये त्याना शेजारना हेवा करस. हाई बठं व्यर्थ शे अनी बिनकामनी कोशीस शे. ");
INSERT INTO ahr_vpl VALUES ("EC4_5","022_4_5","ECC","4","5","5","मुर्ख हातनी घडी घालीसन शांत बसी ऱ्हास अनं आपलाच शरीरना नाश करी लेस. ");
INSERT INTO ahr_vpl VALUES ("EC4_6","022_4_6","ECC","4","6","6","पण भरेल दोन मुठपेक्षा अनी बिनकामना प्रयत्न करापेक्षा आप आपला काम करीसन मुठभर कमाई करेल बरी शे. ");
INSERT INTO ahr_vpl VALUES ("EC4_7","022_4_7","ECC","4","7","7","मी परत बिनकामना गोष्टीसनाबारामा ईचार करं तवय हाई जगमासल्या बठया गोष्टी व्यर्थ शेतस. ");
INSERT INTO ahr_vpl VALUES ("EC4_8","022_4_8","ECC","4","8","8","तठे आशा प्रकारना माणुस शे, तो एकलाच शे, त्याले कोनीच नही, त्याले पोऱ्या किवा भाऊ नही. पण तठे त्याना कष्टले अंत नही, जे धन तो कमाडस त्यामा त्याले समाधान नही, तो स्व:तालेच ईचारस, एवढा कष्ट मी कोना करता करी राहीनु शे? मना जीवनना सुख हिसकाई ली राहीनू शे, हाई कोनाकरता? हाई व्यर्थ शे, कष्टमय शे. ");
INSERT INTO ahr_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","एकपेक्षा दोन माणसे काम करनारा बरा शेतस; त्या एकजागे काम करीसन चांगल कमाडु शकतस. ");
INSERT INTO ahr_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","जर एखादा पडना तर त्याना मित्र त्याले उचलस, पण जो एकलाच ऱ्हास अनी तो जर पडना त्याले उचलाले कोनीच ऱ्हास नही; त्यानामांगे कायम दु:ख ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","अनी जर त्या दोनी एकजागे झोपनात तर त्यासले ऊब लागस. पण एकलाले ऊब कशे लागी? ");
INSERT INTO ahr_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","जो माणुस एकला शे त्याले जर कोनी भारी पडना तर दोनीसले त्याना ईरोध करता ई. तीनपदरी दोर सहजा सहज तुटस नही. ");
INSERT INTO ahr_vpl VALUES ("EC4_13","022_4_13","ECC","4","13","13","गरीब पण शहाना तरूण हाऊ धैयडा अनी मुर्ख राजापेक्षा चांगला ऱ्हास; तो धैयडा राजा त्याले देल इशाराकडे ध्यान देस नही. ");
INSERT INTO ahr_vpl VALUES ("EC4_14","022_4_14","ECC","4","14","14","कदाचित तो तरूण राजा आपला राज्यमा गरीब जन्मना व्हई नहीते तुरुंगमाईन राज्य कराले बाहेर वना व्हई. ");
INSERT INTO ahr_vpl VALUES ("EC4_15","022_4_15","ECC","4","15","15","तरीबी, ज्या बठा ह्या जगमा चालतस त्यासले मी दखं, जो दुसरा तरूण त्यासना जागवर राजा म्हनीसन उभा राहिना त्या त्याले शरण गयात. ");
INSERT INTO ahr_vpl VALUES ("EC4_16","022_4_16","ECC","4","16","16","त्या बठा लोकेसवर तो अधिकारी व्हयना, त्याना अंत नही व्हता, तरी ज्या लोके मोरे येनार शेतस त्या त्याना ईषयी आनंद करावूत नही, खरच हाई व्यर्थ अनी बिनकामना उदयोग शे. ");
INSERT INTO ahr_vpl VALUES ("EC5_1","022_5_1","ECC","5","1","1","जवय तु देवना मंदिरमा जास तवय आपली वागनुककडे ध्यान दे; तठे ऐकाले जाय. ऐकी लेवानं हाई मुर्खना यज्ञपेक्षा चांगल शे; जीवनमा त्या वाईट करतस हाई त्या वळखतस नही. ");
INSERT INTO ahr_vpl VALUES ("EC5_2","022_5_2","ECC","5","2","2","तुना तोंडघाई बोलानी घाई करु नको, अनी देवनासमोर कोनतीबी गोष्ट उच्चार कराले उतावळा करानं नही, कारण देव स्वर्गमा शे अनी तु पृथ्वीवर शे, म्हनीसन तुना शब्द मोजकाच राहावाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EC5_3","022_5_3","ECC","5","3","3","जर तुमले बऱ्याच गोष्टी करन्या व्हतीन तर तुम्हीन त्याईषयी काळजी करतस, अनी तुमले बराचदाव वाईट सपन पडतस, अनी तुम्हीन बराच बोलतस, अनी बहुतेक करीसन बऱ्याच मुर्ख गोष्टी बोलतस. ");
INSERT INTO ahr_vpl VALUES ("EC5_4","022_5_4","ECC","5","4","4","जर तु देवले नवस करं व्हई तर ते फेडाले येळ लावू नको; कारण देव मुर्खसवर प्रसन्न व्हस नही. जे नवस तु करेल शे त्यानी फेड कर. ");
INSERT INTO ahr_vpl VALUES ("EC5_5","022_5_5","ECC","5","5","5","नवस करानं अनी तो फेडानं नही त्यानापेक्षा ते नही करेल बरं शे. ");
INSERT INTO ahr_vpl VALUES ("EC5_6","022_5_6","ECC","5","6","6","आपला तोंडमुये आपला शरीरले शिक्षा व्हवु देऊ नको, मी चुकीसन बोलनू अश देवनादूतनासमोर बोलू नको; तुना बोलानं राग ईसन देवना क्रोध तुनावर काबर येवाले पाहिजे, तुना हातना काम त्यानी काबर नष्ट करान? ");
INSERT INTO ahr_vpl VALUES ("EC5_7","022_5_7","ECC","5","7","7","कारण बराच स्वप्न दखनं अनं बराच भाषण करानं ह्या वायफळ गोष्टी शेतस, पण तु देवना भय धरीन ऱ्हाय. ");
INSERT INTO ahr_vpl VALUES ("EC5_8","022_5_8","ECC","5","8","8","जवय एखादा प्रांतमा गरीब लोकेसवर जुलूम व्हई राहीना शे, न्याय अनी वागनुक योग्य मिळस नही, तर त्यामा आश्चर्य वाटासारख काहीच नही, कारण वरीष्ठवर त्यानापेक्षा वरीष्ठसनी नजर ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC5_9","022_5_9","ECC","5","9","9","आजुन, पृथ्वीना फय सर्वासकरता शे, अनी राजा स्व:ताकरता वावरमासला कमाई लेस. ");
INSERT INTO ahr_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","जो पैसासवर प्रेम करस तो पैसासघाई सुखी ऱ्हास नही अनी जो संपत्तीवर प्रेम करस त्याले जास्त लाभ ऱ्हास; हाईबी व्यर्थ शे. ");
INSERT INTO ahr_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","जशी भरभराटी व्हस, तशे खानाराबी वाढतस; आपला डोयासघाई दखाशिवाय तठे मालकले संपत्तीमा काय लाभ व्हस? ");
INSERT INTO ahr_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","जो काम करस त्यानी झोप गोड ऱ्हास; तो जरासा खावो कि जास्त खावो, पण श्रीमंत माणुसले त्यानी संपत्ती झोपू देस नही. ");
INSERT INTO ahr_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","हाई जगमा आजुन एक संकट मी दखेल शे, ते म्हणजे श्रीमंतनी आपला नाश कराकरता राखी ठयेल धन शे. ");
INSERT INTO ahr_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","जवय श्रीमंत माणुस आपली धनसंपत्ती चुकीन्या गोष्टीसमा गमाडस, ज्यामुये त्याना घरमा जन्मेल पोऱ्या त्याले देवाले त्याना हातमां काहीच राहास नही. ");
INSERT INTO ahr_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","जशे माणुसना जन्म मायना पोटमाईन नग्न व्हयेल शे, जशा तो व्हना तशा तो नग्न व्हईसन परत जाई, आपला काममाईन आपला हातमा काहीच लई जावावू नही. ");
INSERT INTO ahr_vpl VALUES ("EC5_16","022_5_16","ECC","5","16","16","दुसरा एक मोठा संकट दखेल शे, तो जशा वना तशा परत जाई, म्हनीसन जो कोनी वायफळ काम करस त्याले काय फायदा? ");
INSERT INTO ahr_vpl VALUES ("EC5_17","022_5_17","ECC","5","17","17","तो त्याना आयुष्यभर चिंता करी ऱ्हास अनी शेवट तो दु:खी अनी रागीट व्हई जास. ");
INSERT INTO ahr_vpl VALUES ("EC5_18","022_5_18","ECC","5","18","18","माले जे बरं अनं चांगलं दखायनं ते हाई शे; माणुसनी खावानं पेवानं अनी देवनी त्याले जे आयुष्य देल शे त्या बठा दिन तो ज्या कामदंधामा कष्ट करस त्यामा सुख भोगानं हाई त्यानाकरता चांगलं अनी उत्तम शे. ");
INSERT INTO ahr_vpl VALUES ("EC5_19","022_5_19","ECC","5","19","19","जर देवनी एखादा माणुसले संपत्ती, मालमत्ता अनी या गोष्टीसनी उपभोग लेवानी शक्ती देल व्हई तर त्यानी त्याना उपभोग लेवाले पाहिजे. त्यानाकडे ज्या गोष्टी शेतस त्यासना स्विकार कराले पाहिजे, अनी कामबी आनंदमा कराले पाहिजे. ती देवनी देल भेट शे. ");
INSERT INTO ahr_vpl VALUES ("EC5_20","022_5_20","ECC","5","20","20","माणुसले जगाले जास्त वरीस नही राहातस, म्हनीसन त्यानी आयुष्यभर बठया गोष्टीसनी आठवन ठेवाले पाहिजे. देव त्याना आवडता काम कराले मग्न ठेई. ");
INSERT INTO ahr_vpl VALUES ("EC6_1","022_6_1","ECC","6","1","1","हाई जगमा मी आजुन एक संकट दखं, अनी ते माणुसनीकरता भलतं भारी शे; ");
INSERT INTO ahr_vpl VALUES ("EC6_2","022_6_2","ECC","6","2","2","देव एखादा माणुसले भलतं संपत्ती, धनदौलत एवढी देस की त्याले जी इच्छा व्हई ते त्याले मियस, त्याले काहीच कमी पडाव नही. पण देव त्याले नंतर त्याना उपभोग लेवानी शक्ती देस नही, त्याना ऐवजी कोनतरी दुसराच बिन वयखना उपभोग लेस हाई व्यर्थ शे, भलतं वाईट शे. ");
INSERT INTO ahr_vpl VALUES ("EC6_3","022_6_3","ECC","6","3","3","जर एखादा माणुसनी शंभर पोऱ्यासले जन्म दिधा अनी बराच वरीस जगना, त्याना आयुष्यना वरीस बराच राहीनात, त्याना जीवले सुख मियन नही अनी मानसन्मानतीन त्याले वाट लावं नही व्हई तर त्यानापेक्षा मरेल बाळ बरा शे, आशे मी सांगस. ");
INSERT INTO ahr_vpl VALUES ("EC6_4","022_6_4","ECC","6","4","4","जशा तो जन्म व्हयेल बाळ बिनकामना शे, आंधारामा नाहीसा व्हस अनी त्यानं नाव लपेल ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC6_5","022_6_5","ECC","6","5","5","त्यानी कवयच सुर्य दखा नही अनी त्याले काहीच माहित नही, त्याले त्या माणुसपेक्षा जास्त विसावा शे. ");
INSERT INTO ahr_vpl VALUES ("EC6_6","022_6_6","ECC","6","6","6","तो माणुस दोन हजार वरीसबी जगना पण तो चांगल्या गोष्टीसना उपभोग लेवाले शिकना नही, मंग प्रत्येक झन ज्या जागवर जातस तठेच तो बी जाई. ");
INSERT INTO ahr_vpl VALUES ("EC6_7","022_6_7","ECC","6","7","7","मनुष्यना बठा कष्ट पोटकरता शेतस, तरी त्यानी भुक भागस नही. ");
INSERT INTO ahr_vpl VALUES ("EC6_8","022_6_8","ECC","6","8","8","मुर्खपेक्षा शहानाले काय जास्त फायदा व्हस? तशेच जो गरीब राहीसन दुसरा लोकेसनीसंगे कशे वागानं हाई ज्याले समजस त्याले तरी काय फायदा व्हस? ");
INSERT INTO ahr_vpl VALUES ("EC6_9","022_6_9","ECC","6","9","9","ज्या डोया दखीसन समाधान राहातस ते चांगलं शे, मन इकडे तिकडे भटकापेक्षा हाई बरं शे. ");
INSERT INTO ahr_vpl VALUES ("EC6_10","022_6_10","ECC","6","10","10","जे काही व्हयनं त्याना नाव पहिला पाईन ठेयेल शे अनी माणुस काय शे हाई समजाडेल शे, तो फक्त माटी शे त्यानापेक्षा जो समर्थ शे त्यानासंगे भांडन करता येस नही. ");
INSERT INTO ahr_vpl VALUES ("EC6_11","022_6_11","ECC","6","11","11","जास्त बोलावर त्याले काही अर्थ ऱ्हास नही, त्यामा मनुष्यले काय फायदा? ");
INSERT INTO ahr_vpl VALUES ("EC6_12","022_6_12","ECC","6","12","12","मनुष्य हाऊ ज्याले काही अर्थ नही आशे आयुष्य सावलीनामायक काढस, त्यामा त्याले काय फायदा हाई कोनले माहीत? कारण तो मरावर हाई जगमा काय व्हई हाई मनुष्यले कोण सांगी? ");
INSERT INTO ahr_vpl VALUES ("EC7_1","022_7_1","ECC","7","1","1","महागा सुंगधी द्रव्यपेक्षा चांगलं नाव ऱ्हावानं हाई बरं शे, जन्मदीनपेक्षा मरणना दिन बरा ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC7_2","022_7_2","ECC","7","2","2","मेजवानीना घर जावापेक्षा शोक करनारानी घर जायेल बरं ऱ्हास, कारन परतेक माणुसना शेवट हाईच शे, ज्या जिवत शेतस त्यासनी हाई मनमा राखी ठेवानं म्हनीसन जिवत हाई तुमना मनमा कायम राही. ");
INSERT INTO ahr_vpl VALUES ("EC7_3","022_7_3","ECC","7","3","3","हासी मजाक करापेक्षा शोक करानं चांगलं शे, दु:खी तोंड नंतर आनंदी व्हस. ");
INSERT INTO ahr_vpl VALUES ("EC7_4","022_7_4","ECC","7","4","4","ज्या शहाना राहातस त्यासना मन शोक घरकडे लागस, पण मुर्खना चित्त हसी मजाककडे लागस. ");
INSERT INTO ahr_vpl VALUES ("EC7_5","022_7_5","ECC","7","5","5","मुर्खसना गाना ऐकापेक्षा शहानासनी निषेधवानी ऐकेल बरं ऱ्हास ");
INSERT INTO ahr_vpl VALUES ("EC7_6","022_7_6","ECC","7","6","6","कारण मुर्खसना हासू भांडानीखाल जळेल काटाकुटासना कडकडनारामायक ऱ्हास; हाई व्यर्थ शे. ");
INSERT INTO ahr_vpl VALUES ("EC7_7","022_7_7","ECC","7","7","7","जुलूम करावर शहाना येडा बनतस; लाच लेवामुये बुध्दी भ्रष्ट व्हस. ");
INSERT INTO ahr_vpl VALUES ("EC7_8","022_7_8","ECC","7","8","8","एखादी गोष्टनी सुरुवात पेक्षा तिना शेवट व्हयेल बरा ऱ्हास. गर्व करनारा माणुसपेक्षा सहन करनारा माणुस बरा ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC7_9","022_7_9","ECC","7","9","9","मन उतावीळ व्हईसन राग येऊ देवानं नही, कारण राग मुर्खसना मनमा घर करीसन ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC7_10","022_7_10","ECC","7","10","10","या दिनपेक्षा आगोदरना दिन बरा व्हतात आशे काबर? आशे ईचारानं नही; हाई ईचारानं शहानापण नही शे. ");
INSERT INTO ahr_vpl VALUES ("EC7_11","022_7_11","ECC","7","11","11","मिळेल धनसंपत्तीनासंगे शहानापण राहीनं तर बरं ऱ्हास; कारण हाई जगमा जन्म व्हयेलसना हितना शे. ");
INSERT INTO ahr_vpl VALUES ("EC7_12","022_7_12","ECC","7","12","12","ज्ञान आश्रय देनारा शे अनी पैसाबी आश्रय देनारा शे; ज्ञानपाईन आशे फायदा ऱ्हास की ज्यानापाण शहानपण ऱ्हास तो त्याना जीव वाचाडस. ");
INSERT INTO ahr_vpl VALUES ("EC7_13","022_7_13","ECC","7","13","13","देवनी करनी दखा; त्यानी जे वाकडं करेल शे ते कोनीच सरळ करावूत नही? ");
INSERT INTO ahr_vpl VALUES ("EC7_14","022_7_14","ECC","7","14","14","जवय येळ चांगली राही तवय आनंद कर; पण जवय संकटमा सापडसी तवय विवेकतीन वाग; कारण माणुसनीमांगे काय व्हई हाई त्याले कळाले नको म्हनीसन देवनी सुखदूखले जोडे जोडे ठेयेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","एखादा नीतिमान चांगल आचरन करीसनबी नष्ट व्हस; अनी एखादा दुष्ट वाईट वागीसनबी त्याले जास्त आयुष्य भेटस; हाई बठं मी मना व्यर्थ जायेल दिनमा दखेल शे. ");
INSERT INTO ahr_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","तोंड देखल्या नीतिमान व्हवू नको; मर्यादानीबाहेर राहीसन शहानपण दखाडू नको; तु आपला नाश का बरं करी लेवानं? ");
INSERT INTO ahr_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","दुष्टपना जास्त करु नको; मुर्ख बनु नको; तु पहिलेच काबरं मरानं? ");
INSERT INTO ahr_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","याले तु धरी ऱ्हावान; अनी त्यानापाईन हात मांगे लेवान नही हाई बरं शे; कारण देवले जो घाबरीसन राहतस तो पार पडी. ");
INSERT INTO ahr_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","नगरमासला दहा अधिपतीसपेक्षा जास्त रक्षण शहानाले शहानपण करस. ");
INSERT INTO ahr_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","चांगला ईचारतीन वागनारा अनी पाप नही करनारा आशा नीतिमान माणुस हाई जगमा सापडस नही. ");
INSERT INTO ahr_vpl VALUES ("EC7_21","022_7_21","ECC","7","21","21","बोलेल बठा शब्दसकडे ध्यान देऊ नको; जर ध्यान दिधं तर तु तुना नोकरले शिव्याशाप देतांना ऐकशी; ");
INSERT INTO ahr_vpl VALUES ("EC7_22","022_7_22","ECC","7","22","22","कारण तु बी दुसरासले रोज शिव्याशाप देयल शेतस हाई तुले माहीत शे. ");
INSERT INTO ahr_vpl VALUES ("EC7_23","022_7_23","ECC","7","23","23","या बठया गोष्टी मी विवेकतीन आजमाडी दखेल शेतस; आपलाले बराच ज्ञान मियाले पाहीजे आशे माले वाटनं, पण ते मनापाईन दुर राहीनं. ");
INSERT INTO ahr_vpl VALUES ("EC7_24","022_7_24","ECC","7","24","24","जे शे ते बराच दूर अनी गुढ शे; त्याना शोध कोनले लागी? ");
INSERT INTO ahr_vpl VALUES ("EC7_25","022_7_25","ECC","7","25","25","ज्ञान अनी विवेक हाई समजीसन त्याना रहस्य वळखानं अनी त्याना शोध लावानं, अनी दुष्टपना हाई फक्त मुर्खपना शे अनी मुर्खपना हाई येडापना शे, हाई समजाले पाहीजे म्हनीसन मी परत मना चित्त या गोष्टीसकडे लाया. ");
INSERT INTO ahr_vpl VALUES ("EC7_26","022_7_26","ECC","7","26","26","माले मरनपेक्षा दु:ख वाटी आशी वस्तु सापडनी, ती म्हणजे पाशरुप बायी शे, तिना मन पारधीसना जाळा शे; तिना हात साखळी शेतस; जो मानूस देवले आवडस तोच तिना हातमाईन सुटस; पण पापी तिना हातमा सापडस. ");
INSERT INTO ahr_vpl VALUES ("EC7_27","022_7_27","ECC","7","27","27","उपदेशक सांगस; हिशोब दखाले गयू तवय गोळाबेरीज माले सापडनी ती आशी; ");
INSERT INTO ahr_vpl VALUES ("EC7_28","022_7_28","ECC","7","28","28","पण मी आजपावोत सापडाई राहीनू शे तरी माले सापडनी नही ती हाई शे; हजारसमां एक माणुस माले सापडना; पण तेवढया बायासमा माले ऐकबी बायी सापडनी नही. ");
INSERT INTO ahr_vpl VALUES ("EC7_29","022_7_29","ECC","7","29","29","दखा, माले एवढेच सापडनं की देवनी मनुष्यले सरळ आशे तयार करेल शे, पण तो बऱ्याच कल्पनासना मांगे लगी जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("EC8_1","022_8_1","ECC","8","1","1","ज्ञानी मानुसनीमायक कोन शे? कोनत्याबी गोष्टीसना उलगडा कराले कोनले समजस? ज्ञानी मानुसना तोंड तेज देस; ज्यामुये त्याना मुखना कठीनपना दुर व्हई जास. ");
INSERT INTO ahr_vpl VALUES ("EC8_2","022_8_2","ECC","8","2","2","मी तुले आशे सांगस की राजानी आज्ञा पाळ; तु परमेश्वरनी शपथ लेल शे म्हणीन ती पाळ. ");
INSERT INTO ahr_vpl VALUES ("EC8_3","022_8_3","ECC","8","3","3","त्याना समोरतीन जावानी घाई करु नको; वाईट गोष्टीसकरता थांबू नको; कारण त्याले जे आवडस ते तो करस. ");
INSERT INTO ahr_vpl VALUES ("EC8_4","022_8_4","ECC","8","4","4","राजाना शब्द ताकतवान ऱ्हास, तु हाई काय करस आशे त्याले कोन म्हनी? ");
INSERT INTO ahr_vpl VALUES ("EC8_5","022_8_5","ECC","8","5","5","जर राजानी आज्ञा पाळसी तर सुरक्षित ऱ्हासी, पण जो बुध्दीमान ऱ्हास त्याले हाई येळ माहीत ऱ्हास अनी त्याले हाईबी माहीत ऱ्हास कि कवय बोलानं शे. ");
INSERT INTO ahr_vpl VALUES ("EC8_6","022_8_6","ECC","8","6","6","प्रत्येक गोष्टले नेमेल काळ अनी न्याय करानं येळ ऱ्हास, कारण मनुष्यना संकट बराच शेतस. ");
INSERT INTO ahr_vpl VALUES ("EC8_7","022_8_7","ECC","8","7","7","मोरे काय व्हई हाई त्याले माहीत नही ऱ्हास, कशे काय व्हई हाई त्याले कोन सांगी? ");
INSERT INTO ahr_vpl VALUES ("EC8_8","022_8_8","ECC","8","8","8","जीववर कोनताच माणुसनी सत्ता ऱ्हास नही की तो त्याले जावू देवावू नही; मराना दिन कोनाच हातमा नही; हाई संकट कोनलेच सोडावू नही, दुष्कर्म आपला मालकले वाचाडावू नही. ");
INSERT INTO ahr_vpl VALUES ("EC8_9","022_8_9","ECC","8","9","9","हाई बठं मी दखेल शे; हाई जगमा ज्या गोष्टी चाली राहीन्यात हया बठया गोष्टीसकडे मी मना चित्त लायेल शे; एक मनुष्य दुसरावर सत्ता चालाडीसन त्याना नुकसान करस. ");
INSERT INTO ahr_vpl VALUES ("EC8_10","022_8_10","ECC","8","10","10","त्या येळले मना नजरमा आशे वनं की दुष्टले मुठमाटी दिसन तो विश्राम पावस; अनी नीतिमानतीन वागनाराले पवित्र ठिकान सोडीसन जाना पडस, अनी गावमासला लोके त्याले ईसरी जातस हाई बी व्यर्थ. ");
INSERT INTO ahr_vpl VALUES ("EC8_11","022_8_11","ECC","8","11","11","दुष्टले लगेच शिक्षा व्हस नही म्हनीसन मनुष्यनापोऱ्यानं मन दुष्कर्म कराले तयार व्हस. ");
INSERT INTO ahr_vpl VALUES ("EC8_12","022_8_12","ECC","8","12","12","पापी शंभर येळ पाप करना अनी बराच वरीसन जगना; आशे व्हई तरी माले माहीत शे ज्या देवले मानपान देतस त्यासनं कल्यान व्हई. ");
INSERT INTO ahr_vpl VALUES ("EC8_13","022_8_13","ECC","8","13","13","पण ज्या दुष्ट शेतस त्यासना भलं व्हवावू नही; त्यासले जास्त आयुष्य मिळावू नही; त्यासना जीवन सावलीनामायक शे, कारन त्या देवले मानपान देतस नही. ");
INSERT INTO ahr_vpl VALUES ("EC8_14","022_8_14","ECC","8","14","14","हाई जगमा आजुन एक बिनकामनी गोष्ट व्हस; आशे काही नीतिमान ऱ्हातस, दुष्टसनी करनीमुये त्यासनी जी गती व्हवाले पाहीजे ती यासनी व्हस अनी आशे काही दुष्ट ऱ्हातस की नीतिमानसनी करनीमुये त्यासनी गती व्हवाले पाहीजे ती यासनी व्हस. मी हाई सांगस हाई बठं व्यर्थ शे. ");
INSERT INTO ahr_vpl VALUES ("EC8_15","022_8_15","ECC","8","15","15","मंग मी आनंदनी शिफारस करी, कारण मनुष्यनी खावानं, पेवानं अनी आनंद करानी यानापेक्षा पृथ्वीनाखाल दुसरं काहीच उत्तम नही शे. कारण त्यासना आयुष्यना दिन देवनी त्यासले पृथ्वीवर देयल शेतस त्याना कष्टमा हाई त्यानाजोडे राही. ");
INSERT INTO ahr_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","तवय ज्ञान समजाकरता अनी जे काम हाई जगमा चाली राहीना शे ते दखाले जवय मी मना चित्त लावं. कारण रातदिन ज्याना डोयाले डोया लागस नही आशेबी लोके राहातस. ");
INSERT INTO ahr_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","तवय माले देवना बठा काम दखीसन आशे समजन की जे काम हाई जगमा करामा ई राहीना शे ते माणुसले शोध लावता येस नही, कारण ते दखी काढाले माणुसनी कितलाबी कष्ट करात तरी त्या सापडावू नही अनी तशेच एखादा ज्ञानी मानुस, माले माहीत शे आशे जरी बोली, तरी त्याले ते सापडावू नही. ");
INSERT INTO ahr_vpl VALUES ("EC9_1","022_9_1","ECC","9","1","1","मी बठया गोष्टीसनी कायजीपुर्वक ईचार करा, नीतिमान अनी ज्ञानी माणुस अनी त्याना काम समजानी कोशीस करात, त्या बठा देवना हातमा ऱ्हास. कोनीतरी आपला व्देष करी अनी प्रेमना करी यानाबदल काहीच माहीत नही ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC9_2","022_9_2","ECC","9","2","2","जे काही व्हस ते बठं सारखच व्हस, नीतिमान अनी दुष्ट, चांगला अनी वाईट, शुध्द अनी अशुध्द, यज्ञ करनारा अनी यज्ञा नही करनारा या बठासनी गती एकच व्हस, चांगला मानुस पापी मानुसनामायक मरी. शपथ लेनारानी, तशेच शपथ देनारानी त्यानी गती तशीच व्हई. ");
INSERT INTO ahr_vpl VALUES ("EC9_3","022_9_3","ECC","9","3","3","हाई जगमा जे काही घडस त्यामा हाई एक आशे वाईट शे की बठासनी सारखीच गती व्हई, मनुष्यनापोऱ्याना मनमा दुष्टता भरेल ऱ्हास, त्यासना मना बठा आयुष्यभर भ्रांतीमय ऱ्हास, मंग त्या मरेलसले जाईसन मिळतस. ");
INSERT INTO ahr_vpl VALUES ("EC9_4","022_9_4","ECC","9","4","4","जो माणुस अजुन जिवत शे, त्याले आशा ऱ्हास, पण जिवत कुत्रं मरी जायेल सिंहनापेक्षा चांगला ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC9_5","022_9_5","ECC","9","5","5","आपलाले मरनं शे हाई जिवंतसले समजस; पण मरेलसले काहीच समजस नही; त्यासले आणखी काही फळ भेटावं नही; त्यानं स्मरण कोणले ऱ्हास नही. ");
INSERT INTO ahr_vpl VALUES ("EC9_6","022_9_6","ECC","9","6","6","त्यासना प्रेमना, व्देष अनी मत्सर हाई आगोदरच नष्ट व्हई जायेल शेतस, अनी जे काही हाई जगमा करामा ई राहीना शे, त्यामा त्यासले परत जागा मिळावू नही. ");
INSERT INTO ahr_vpl VALUES ("EC9_7","022_9_7","ECC","9","7","7","तुना मार्गतीन जाय, आनंदमा तुनी भाकर खाय अनी आनंदमा द्राक्षरस पेय, कारण देवनी तुना चांगला काम साजरा कराकरता मान्यता देयेल शे. ");
INSERT INTO ahr_vpl VALUES ("EC9_8","022_9_8","ECC","9","8","8","तुना कपडा कायम शुभ्र राहावाले पाहीजे अनी तुना डोकाले तेलना अभिषेक ऱ्हावाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("EC9_9","022_9_9","ECC","9","9","9","तुना ज्या व्यर्थ आयुष्यना दिन त्यानी तुला हाई जगमा देयल शेतस त्यामा, तुना बठा व्यर्थ दिनमा तुनी बायको जी तुले प्रिय शे तिनासंगे तु प्रेमतीन आयुष्य घालव. कारण आयुष्यमा अनी तुना उदयोगधंदामां पृथ्वीवर कष्ट करस तठेबी तुना हाऊच वाटा शे. ");
INSERT INTO ahr_vpl VALUES ("EC9_10","022_9_10","ECC","9","10","10","जे काही काम तुना हातमा ई ते बठे ताकदतीन कर, कारण ज्या कबरमा आपन जानार शेतस तठे काम, ईचार, ज्ञान अनी शहापन नही शे. ");
INSERT INTO ahr_vpl VALUES ("EC9_11","022_9_11","ECC","9","11","11","मी पृथ्वीवर बऱ्याच गोष्टी दख्यात, जोरमा पयनारा शर्यंत जिकस नही, ताकदवान लढाई जिकस आशे व्हस नही, शहानानी अन्न खावानं आशे व्हस नही, जो ज्ञानी शे त्यानावरच कृपा व्हस आशे नही, त्याना ऐवजी संधी अनी येळ याना बठासवर परीनाम व्हस. ");
INSERT INTO ahr_vpl VALUES ("EC9_12","022_9_12","ECC","9","12","12","कोनलेच त्याना मरानी येळ माहीत नही, जशा मासा मरानी जाळामा सापडस, नहीते फासामा आटकनारा चिडानामायक, तशेच जनावर, मनुष्यजात संकटना येळले तो त्यासनावर आचानक ई पडना मनजे तो फासामा आटकस. ");
INSERT INTO ahr_vpl VALUES ("EC9_13","022_9_13","ECC","9","13","13","ज्ञानीबी मी हाई जगमा दखात अनी त्या माले महत्वना वाटनात. ");
INSERT INTO ahr_vpl VALUES ("EC9_14","022_9_14","ECC","9","14","14","एक धाकलं शहर व्हतं, एक मोठा राजानी त्या शहराना ईरोधमा लढाई करी अनी त्यानी त्याना ईरोधमा सेना शहरना आजुबाजूले ठेवात. ");
INSERT INTO ahr_vpl VALUES ("EC9_15","022_9_15","ECC","9","15","15","पण त्या शहरमा एक विद्वान व्हता, तो विद्वान गरीब व्हता, पण त्यानी आपला ज्ञानतीन त्या शहरना बचाव करा, बठं काही सरावर लोके त्या गरीब माणुसले ईसरी गयात. ");
INSERT INTO ahr_vpl VALUES ("EC9_16","022_9_16","ECC","9","16","16","मंग मी निर्णय लिधा, ताकदपेक्षा ज्ञान श्रेष्ठ शे पण गरीबना ज्ञानले तुच्छ मानतस अनी त्याना शब्द ऐकतस नही. ");
INSERT INTO ahr_vpl VALUES ("EC9_17","022_9_17","ECC","9","17","17","विद्वान मानुसनी शांततातीन सांगेल शब्द हाई मुर्खसना राजानी वरडीसन सांगेल शब्दसपेक्षा चांगला ऱ्हातस. ");
INSERT INTO ahr_vpl VALUES ("EC9_18","022_9_18","ECC","9","18","18","शहानपण हाई युध्दमासली तलवार अनी भाला यानापेक्षा चांगला ऱ्हास. पण एखादा पापी बऱ्याच चांगल्या गोष्टीसना नुकसान करस. ");
INSERT INTO ahr_vpl VALUES ("EC10_1","022_10_1","ECC","10","1","1","जशा मरेल माख्या सुगंधी तेल दुर्गंधीत करतस तशा मुर्खपना हाई शहानपण अनी मानपाण यासना नाश करु शकतस. ");
INSERT INTO ahr_vpl VALUES ("EC10_2","022_10_2","ECC","10","2","2","शहाणना मन त्याना उजवीकडे शे, पण मुर्खना मन त्याना डावीकडे ऱ्हास, ");
INSERT INTO ahr_vpl VALUES ("EC10_3","022_10_3","ECC","10","3","3","जवय मुर्ख वाटधरी जाई ऱ्हास तवय त्याना ईचार आर्धावट ऱ्हातसं हाई दखाई जास, म्हणीसन तो मुर्ख शे हाई बठासले दखास. ");
INSERT INTO ahr_vpl VALUES ("EC10_4","022_10_4","ECC","10","4","4","तुमना वरीष्ठ लोके तुमनावर चिडेल शेतस म्हणीसन काम सोडानं नही, शांत ऱ्हावामुये राग शांत व्हई जास. ");
INSERT INTO ahr_vpl VALUES ("EC10_5","022_10_5","ECC","10","5","5","एक संकट मी हाई पृथ्वीवर दखेल शे, अधिकारीनी चुकमुये ती येस ते मी दखेल शे. ");
INSERT INTO ahr_vpl VALUES ("EC10_6","022_10_6","ECC","10","6","6","मुर्खसले नेता पदनी जागा देवामा येस अनी ज्या यशस्वी व्हयेल ऱ्हातस त्यासले खालनी जागा देवामा येस. ");
INSERT INTO ahr_vpl VALUES ("EC10_7","022_10_7","ECC","10","7","7","ज्या नोकर शेतस त्यासले मी घोडावर जातांना दखं अनी ज्या यशस्वी लोके व्हतात त्यासले नोकरनामायक जमीनवर चालतांना दखं. ");
INSERT INTO ahr_vpl VALUES ("EC10_8","022_10_8","ECC","10","8","8","जो कोनी खड्डा खंदस, त्यामा तोच पडस अनी जो कोनी भित तोडी टाकस त्याले साप चावस. ");
INSERT INTO ahr_vpl VALUES ("EC10_9","022_10_9","ECC","10","9","9","अनी जो कोनी वेसना दगड फोडस त्याले त्यानामुये इजा व्हस अनी जो लाकडं तोडस तो संकटमा ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC10_10","022_10_10","ECC","10","10","10","लोखंडी हत्यार बोथट व्हयनं अनी त्याले धार लाई नही तर जास्त ताकद लावनी पडस, पण काम साध्य कराकरता बुध्दी उपयोगनी शे. ");
INSERT INTO ahr_vpl VALUES ("EC10_11","022_10_11","ECC","10","11","11","जर सापवर मंत्र प्रयोग व्हवानी आगोदर तो चावना तर मोरे मांत्रिकसना काहीच उपयोग नही. ");
INSERT INTO ahr_vpl VALUES ("EC10_12","022_10_12","ECC","10","12","12","शहाणाना तोंडना वचन कृपामय ऱ्हातस, पण मुर्खना तोंड त्यालेच गिळी टाकस. ");
INSERT INTO ahr_vpl VALUES ("EC10_13","022_10_13","ECC","10","13","13","त्याना तोंडना वचन करानी सुरुवात मुर्खपना ऱ्हास, अनी त्याना भाषन कराना शेवट येडापना ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC10_14","022_10_14","ECC","10","14","14","मुर्ख वचन वाढाईसन सांगस. पण मोरे काय येनार शे हाई माणुसले माहीत नही. त्यानामांगे काय व्हई हाई त्याले कोन सांगी? ");
INSERT INTO ahr_vpl VALUES ("EC10_15","022_10_15","ECC","10","15","15","मुर्ख कष्ट करीसन थकी जास, कारण शहरमा जावानी वाट त्याले माहीत नही ऱ्हास. ");
INSERT INTO ahr_vpl VALUES ("EC10_16","022_10_16","ECC","10","16","16","हे देश, तुना राजा पोऱ्यानीमायक व्हई अनी अधिपती सकायसले जेवानी सुरुवात करी तर तुनी कितली वाईट परीस्थिती व्हई! ");
INSERT INTO ahr_vpl VALUES ("EC10_17","022_10_17","ECC","10","17","17","पण जर राजा उचा कुळना पोऱ्या व्हई अनी तुना अधिपती नशा कराकरता नही तर शक्तीकरता जेवन करत व्हतीन तवय तुना देश आनंदमां शे. ");
INSERT INTO ahr_vpl VALUES ("EC10_18","022_10_18","ECC","10","18","18","जर एखादा मानुस कामनी बारामा आळशी व्हई तर त्याना घर गयाले लागी अनी त्याना धाबा पडी जाई. ");
INSERT INTO ahr_vpl VALUES ("EC10_19","022_10_19","ECC","10","19","19","लोके हासीमजाक कराकरता मेजवानी बनाडतस, द्राक्षरस जीवले सुख देस अनी पैसा प्रत्येक गोष्टनी गरज पुरावस. ");
INSERT INTO ahr_vpl VALUES ("EC10_20","022_10_20","ECC","10","20","20","तु आपला मनमा सुध्दा राजाले शाप देवू नको. धनवानले आपली झोपानी खोलीमा शाप देऊ नको कारण आकासमासला चिडा तुना शब्द लिसन जाई अनी ज्या बाकीना चिडा शेतस ते त्या गोष्टी पसरावतीन. ");
INSERT INTO ahr_vpl VALUES ("EC11_1","022_11_1","ECC","11","1","1","तुनी भाकर पानीवर सोड कारण बराच दिनमा ती तुले परत भेटी ");
INSERT INTO ahr_vpl VALUES ("EC11_2","022_11_2","ECC","11","2","2","तु सात-आठ लोकेसले वाटी दे, कारण हाई जगमां कोनत्या वाईट गोष्टी व्हतीन हाई तुमले माहीत नही, ");
INSERT INTO ahr_vpl VALUES ("EC11_3","022_11_3","ECC","11","3","3","जर ढग पानीघाई भरेल व्हई तर ते पृथ्वीवर सोताले खाली करतस, जर झाड उत्तरकडे नहिते दक्षिणकडे पडनं मनजे ते जठे पडेल शे तठेच पडी राही. ");
INSERT INTO ahr_vpl VALUES ("EC11_4","022_11_4","ECC","11","4","4","जो वारा दखी राहास तो पेरणी कराव नही, जो ढगसना रंग दखी राहास तो कापणी कराव नही. ");
INSERT INTO ahr_vpl VALUES ("EC11_5","022_11_5","ECC","11","5","5","जशे वारा कताईन येस हाई तुले माहीत नही, मायना गर्भमा शरीर कशे वाढतस हाई जशे तुले कळस नही तशे बठं काही निर्मान करनारा देवना कार्यना आकलन तुले करता येवावू नही. ");
INSERT INTO ahr_vpl VALUES ("EC11_6","022_11_6","ECC","11","6","6","सकासले बिवारा पेरी दे, अनी संध्याकायले हात आवरानं नही, कारन त्यामाईन कोनतं फळ दि हाई नहिते दोनी मिळीसन चांगल व्हई हाई तुले माहीत नही. ");
INSERT INTO ahr_vpl VALUES ("EC11_7","022_11_7","ECC","11","7","7","प्रकाश खरच गोड शे, अनी सुर्य डोयाघाई दखाले आनंद वाटस. ");
INSERT INTO ahr_vpl VALUES ("EC11_8","022_11_8","ECC","11","8","8","जर माणुस कितलाबी वरीस जगना तरी त्यामा तो आनंद करो, अनी येनारा आंधारना दिनबी ईचार करो, कारण त्या बराच व्हतीन. जे बठं येस ते व्यर्थ शे. ");
INSERT INTO ahr_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","हे तरुना, तु आपला तरुनपनमा आनंद कर, तुना तरुनपनना दिनमा तुना मन तुले आनंदीत करो, अनी तुना मनले वाटी त्या मार्गतीन अनी तुना नजरमा ई तशे चाल; पण या बठया गोष्टीसनीबारामा देव तुना न्याय करी. हाई तुना ध्यानमा राहु दे. ");
INSERT INTO ahr_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","आपला मनमाईन राग काढी टाक, आपला शरीरना दु:खंकडे ध्यान देवू नको, कारण तारुन्य अनी सामर्थ्य हाई व्यर्थ शे. ");
INSERT INTO ahr_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","तु आपला तरुनपणना दिनमांसुध्दा आपला निर्मानकरतानी आठवन कर, वाईट दिन येवाना आगोदर अनी सांगशी, माले हाई दिनमा काहीच सुख नही. ");
INSERT INTO ahr_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","त्या दिनमा सुर्य, चंद्र अनी तारा यासना प्रकाशनी आगोदर आंधार वाढी अनी पाणी पडावर काया ढग परत येतीन. ");
INSERT INTO ahr_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","त्या येळले महालना पहारेकरी थरथर कापतीन अनी ताकदवान मानसे वाकी जातीन, अनी दयनाऱ्या बाया थांबी जातीन कारण त्या कमी शेतस, अनी ज्या खिडक्यासमाईन दखनाऱ्या शेतस त्यासले चांगल दखता येवावू नही. ");
INSERT INTO ahr_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","त्या येळले जवय रस्तावरना दार बंद व्हतीन अनी घरटाना आवाज बंद व्हई जाई, तवय चिडासना आवाजवर लोकेसनी झोप उडी जाई, अनी सर्वा गायनस्वर बंद व्हई. ");
INSERT INTO ahr_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","तवय माणुसले उचा ठिकाननी अनी रस्तावरनी पुढला धोकानी भीती वाटी, अनी बदामना झाड फुली, तवय टोळ सोतानीमोरे भारी वाटी, अनी तवय सहाजिकच इच्छा दुर्बल व्हई, तवय मानुस आपला अनंतकाळना घरले जाई, अनी शोक करनारा रस्तावर फिरतीन. ");
INSERT INTO ahr_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","मंग चांदीना दोर तुटी, सोनाना वाटका फुटी जाई, झरानीजोडेना घागर फुटी जाई, हेरवरनी रहाट मुडी जाई. ");
INSERT INTO ahr_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","ज्या ठिकानपाईन ती व्हई, माटी परत माटीले मियस अनी देवनी देयल आत्मा परत त्यानाकडे जाई. ");
INSERT INTO ahr_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","व्यर्थ हो व्यर्थ, उपदेशक सांगस बठं काही व्यर्थ शे. ");
INSERT INTO ahr_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","उपदेशक ज्ञानी व्हता अनी तो लोकेसले ज्ञान शिकाडत गया, त्यानी इचार करीसन अनी शोध करीसन बराच बोधवचन रचात. ");
INSERT INTO ahr_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","सरय लिखेल सत्य अनी मनोहर वचन दखाना उपदेशकनी प्रयत्न करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","बुध्दीमाणना शब्द आगनामायक ऱ्हास; सभापतीना शब्द ठोकेल खियानामायक ऱ्हातस; एकच मेंढपायपाईन ती मियेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","मना पोऱ्या, यानाशिवाय दुसरा शिक्षणनाबारामा सावध ऱ्हाय, पुस्तक लिखाले अंत नही शे, बराच पुस्तकवाचन शरीरले थकाडस. ");
INSERT INTO ahr_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","आते बठं काही तुम्हीन ऐका; हाई बठासना अर्थ एकच शे की देवले भ्याईसन ऱ्हाय, अनी त्यानी आज्ञा पाळ; माणुसन काम हाईच शे. ");
INSERT INTO ahr_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","सर्वा बऱ्यावाईट गुप्त गोष्टीसना न्याय कराना येळले देव बठा कामन्या झडत्या ली.");
INSERT INTO ahr_vpl VALUES ("EK1_1","027_1_1","EZK","1","1","1","मी खबार नदीना काठले धरी आणेल लोकेसमा राहात व्हतु, तवय तिसवा वरीसना चौथा महीनाना पाचवा दिनले आशे व्हयनं की आकाशा दुभागीसनं माले परमेश्वरनी दिव्यदृष्टी दखायनी. ");
INSERT INTO ahr_vpl VALUES ("EK1_2","027_1_2","EZK","1","2","2","हाई यहोयाखीन राजानं बंदीवासनं पाचवा वरीस व्हता; त्या महीनाना पाचवा दिनले, ");
INSERT INTO ahr_vpl VALUES ("EK1_3","027_1_3","EZK","1","3","3","खास्दयासना देशमां खबार नदीना काठले बुजीना पोर्‍या यहेज्केल याजक याले परमेश्वरनं वचन स्पष्टतीन प्राप्त व्हयनं; तठे परमेश्वरना सामर्थ्य त्यानावर वनं. ");
INSERT INTO ahr_vpl VALUES ("EK1_4","027_1_4","EZK","1","4","4","मी दख ते उत्तरकडतीन तुफानना वारा सुटना, तवय एक मोठा ढग ई राहिना शे, त्यानामां गुंडाळेल एक आगना गोया व्हता; त्याना आजुबाजूले मोठा ढग पसरेल राहीसनं आगना मजारतीन पितयनामायक तेज झळकत व्हता. ");
INSERT INTO ahr_vpl VALUES ("EK1_5","027_1_5","EZK","1","5","5","त्याना मजारना भागमां चार जनावरसना आकृतीनामायक काहीतरी दखायनं; दखावाले त्या माणुसना आकृतीनामायक व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK1_6","027_1_6","EZK","1","6","6","त्या परतेकले चार तोंड व्हतात अनी परतेकले चार पखं व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK1_7","027_1_7","EZK","1","7","7","त्यासना पाय ताठ उभा व्हतात अनी त्यासना पायसना तळवा वासरूना पायना तळवानामायक दिसी राहिंतं अनं पितयनामायक त्याना उजाळा झळकी राहिंता. ");
INSERT INTO ahr_vpl VALUES ("EK1_8","027_1_8","EZK","1","8","8","त्यासना चारी बाजुले पंखसना खाल त्यासले माणसेसना हात व्हतात; त्या चारीसले तोंड अनी पंख व्हतात. त्या आशे व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK1_9","027_1_9","EZK","1","9","9","त्यासना पंख एक दुसराले लागीसनं व्हतात; त्या चालतांना वयेत नही, तर त्या परतेक पाहीजे त्या आपला तोंडना दिशाकडे सरळ समोर जाये. ");
INSERT INTO ahr_vpl VALUES ("EK1_10","027_1_10","EZK","1","10","10","त्या चारीसना तोंडपैकी एक तोंड माणुसना व्हता; त्या चारीसना उजवी बाजुले एक तोंडना सिंह व्हता, त्या चारीसना डावा बाजुले एक तोंड बैलनं व्हतं; अनी त्या चारीसना एक तोंड गरुडनामायक व्हतं; असा त्यासना तोंड व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK1_11","027_1_11","EZK","1","11","11","वरनी बाजुले त्यासना तोंड अनी त्यासना पंख येगळा व्हतात, परतेकना दोन पखसनाजोडे दुसरानं एक एक पंखले लागेल व्हतं अनी परतेकना दोन पंखसघाई त्यासना शरीर झाकायेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK1_12","027_1_12","EZK","1","12","12","त्या परतेक पाहिजे त्या आपला तोंडना दिशाकडे सरळ समोर जायेत; आत्मा लयी जाई तिकडे जायेत; चालतांना वळेत नही; ");
INSERT INTO ahr_vpl VALUES ("EK1_13","027_1_13","EZK","1","13","13","त्या प्राणीसनं रुप सांगं तर आगना इंगळनामायक, मशालनामायक दखायी राहींनतात; आग त्या प्राण्यासमां खेळी राहींनता; तो धगधगीत व्हईसनं त्यानामाईन ईजा निघी राहींनतात. ");
INSERT INTO ahr_vpl VALUES ("EK1_14","027_1_14","EZK","1","14","14","त्या प्राणी विजनामायक इकडे तिकडे पयेत; ");
INSERT INTO ahr_vpl VALUES ("EK1_15","027_1_15","EZK","1","15","15","मी त्या जनावरसकडे दख तवय त्यासनाजोडे त्यासना चारी तोंडना बाजुले जमीनवर एक एक चाक व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK1_16","027_1_16","EZK","1","16","16","त्या चाके अनी त्यासना घाट हया सोनानं मणीसनामायक दखाई राहींनात; त्या चारीसना आकार एकच व्हता. त्यासना आकार अनी घाट जशे काय चाकमां चाक आशे व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK1_17","027_1_17","EZK","1","17","17","त्या चालेत तवय त्या चार दिशासपैकी पाहिजे त्या दिशाले नीट सरळ चालेत; चालतांना वळेत नही. ");
INSERT INTO ahr_vpl VALUES ("EK1_18","027_1_18","EZK","1","18","18","चाकेसना घेरा दखात तवय त्या भलता उचा अनी भयानक व्हत्यात; त्या चारीसना घेरासना आजुबाजूले सगळीकडे डोया व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK1_19","027_1_19","EZK","1","19","19","त्या जनावर चालेत तवय चाकेबी त्यासनासंगे चालेत अनी त्या जमीन सोडीसनं त्या वर चढेत तवय चाकेबी चढेत. ");
INSERT INTO ahr_vpl VALUES ("EK1_20","027_1_20","EZK","1","20","20","जिकडे आत्मा लयी जाई तिकडे त्यासना गतीना रोखतीन त्या जायेत;‍ त्यानासंगे चाकेबी उचलायेत; कारण त्या जनावरसना आत्मा चाकसमां व्हतात; ");
INSERT INTO ahr_vpl VALUES ("EK1_21","027_1_21","EZK","1","21","21","त्या चालनात म्हणजे त्याबी चालेत; त्या थांबनात मनजे त्याबी थांबेत; त्या जमीन सोडीसनं वर चढनात मनजे त्यासनासंगे चाके बी चढेत; कारण त्या जनावरसना आत्मा चाकमां व्हता. ");
INSERT INTO ahr_vpl VALUES ("EK1_22","027_1_22","EZK","1","22","22","त्या जनावरासना माथावर काजवासनीमायक काही तरी व्हतं; त्या दिपवनारा अनी भयानक दवनामायक दखायनात; त्या त्यासना डोकावरतीन पसरेल व्हतात; ");
INSERT INTO ahr_vpl VALUES ("EK1_23","027_1_23","EZK","1","23","23","त्या चांदव्यासनाखाल त्यासना पख नीट पसरीसनं येरा येरले लागेल व्हतात; हाई बाजुले अनी ती बाजुले शरीर झाकाई जायी आशे परतेकले दोन दोन पख व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK1_24","027_1_24","EZK","1","24","24","त्या चालत व्हतात तवय माले त्यासना पखसना आवाज आयकु व्हंनं; तो महाजलाशयना आवाजनामायक, सर्वसमर्थनना वाणीनामायक व्हता; लष्करना गजबजीनासारखा तो मोठा व्हता; त्या उभा राहेत तवय आपला पख खाल सोडेत. ");
INSERT INTO ahr_vpl VALUES ("EK1_25","027_1_25","EZK","1","25","25","त्यासना डोकावरना चांदव्यासमाईन वाणी व्हये; त्या उभा राहेत तवय आपला पख खाल सोडेत. ");
INSERT INTO ahr_vpl VALUES ("EK1_26","027_1_26","EZK","1","26","26","त्यासना डोकावर ज्या चांदवा व्हतात त्यासनावर नीलमणीना सिंहासननामायक काही तरी दखाई राहींनतं; अनी त्या सिंहासनवर माणुस शे आशे भास व्हये. ");
INSERT INTO ahr_vpl VALUES ("EK1_27","027_1_27","EZK","1","27","27","त्यासमा सगळीकडे तृणमणीना तेजनामायक आगना भास माले व्हयनं; त्याना कंबरपाईन वर अनी त्याना कंबरपाईन खाल आगना भास माले व्हयनं अनी त्याना आजुबाजूले प्रकाश चमकी राहींनता. ");
INSERT INTO ahr_vpl VALUES ("EK1_28","027_1_28","EZK","1","28","28","पाऊसना दिनमां ढगमां दखास तशे धनुष्यनंपरमानं त्याना आजुबाजूले प्रभा फाकायेल माले दखायन्यात; परमेश्वरनं शक्तीनं हाई दर्शन व्हतं; मी ते दखीसनं उपडा पडनू अनी कोणीतरी बोलानी वाणी मना कानवर ऊनी. ");
INSERT INTO ahr_vpl VALUES ("EK2_1","027_2_1","EZK","2","1","1","तो माले बोलना, मानवपुत्रा, तु तुना पायवर उभा राहाय, मनजे मी तुनासंगे बोलसू, ");
INSERT INTO ahr_vpl VALUES ("EK2_2","027_2_2","EZK","2","2","2","तो मनासंगे बोली राहींनता तवय आत्मानी मनामां परवेश करीसनं माले मना पायवर उभं करं तवय त्यानं बोलनं माले आयकू व्हनं; ");
INSERT INTO ahr_vpl VALUES ("EK2_3","027_2_3","EZK","2","3","3","तो माले बोलना, हे मानवपुत्रा, मी तुले इस्त्राएल वंशकडे, मनासंगे झगडा करणारा राष्ट्रसकडे धाडसं त्यासनी अनी त्यासना वाडवडीलसनी आजपावोत मना ईरोधमां वागेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK2_4","027_2_4","EZK","2","4","4","हया त्यासना वंशज उध्द्ट अनी कठीण ह्दयना शेतस; मी तुले त्यासनाकडे धाडी राहीनू; प्रभू परमेश्वर आशे सांगस हाई त्यासले सांग. ");
INSERT INTO ahr_vpl VALUES ("EK2_5","027_2_5","EZK","2","5","5","त्या तुना आयकोत किंवा नही आयकोत, निदान त्यासनाकडे कोणीतरी संदेष्टा जायेल व्हता हाई त्यासले समजी; त्या तर बोली चालीसनं फितुरी व्हयी जायेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK2_6","027_2_6","EZK","2","6","6","हे मानवपुत्रा, तुना आजुबाजूले काटाझुडपा अनी काटा राहीनात तरी, तु इचुसमा राहाशी तरी त्यासले भिऊ नको, त्यासना शब्दसले भ्यावनं नही, ती फितुरी जायी राहीनी शे, तरी त्यासना शब्दले भिवानं नही; त्यासना चर्येले भिवानं नही; ");
INSERT INTO ahr_vpl VALUES ("EK2_7","027_2_7","EZK","2","7","7","त्या आयकोत किंवा नही आयकोत; तु मना वचन त्यासले सांग; त्या तर भलता भांडखोर शेतस; ");
INSERT INTO ahr_vpl VALUES ("EK2_8","027_2_8","EZK","2","8","8","हे मानवपुत्रा, मी सांगस ते आयक, त्या फितुरी जातपरमानं तु फितुरनामायक होऊ नको; तुनं उघाड अनी मी देस ते खाय; ");
INSERT INTO ahr_vpl VALUES ("EK2_9","027_2_9","EZK","2","9","9","मी दख तवय मनाकडे एक हात पुढे वना, अनी दख, त्या हातमां ग्रंथना पट व्हता; ");
INSERT INTO ahr_vpl VALUES ("EK2_10","027_2_10","EZK","2","10","10","तो त्यानी मनासमोर पसारं; त्यानावर पाठपोट लिखेल व्हतं अनी त्यामा विलाप, शोक अनी दुख हयानाबारामां लिखेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK3_1","027_3_1","EZK","3","1","1","तो माले बोलना, मानवपुत्रा, तुनासमोर जे व्हनं शे ते खाय; हाऊ पुस्तक खाय अनी जायीसनं इस्त्राएलना घराणानासंगे बोल, ");
INSERT INTO ahr_vpl VALUES ("EK3_2","027_3_2","EZK","3","2","2","तवय मी आपला तोंड उघाडं अनी त्यानी माले ते पट सेवन कराले लावं. ");
INSERT INTO ahr_vpl VALUES ("EK3_3","027_3_3","EZK","3","3","3","तो माले बोलना, मानवपुत्रा, जो पुस्तक मी तुले देस तो पोटमां जाऊ देय, त्यानीघाई आपली आतडी भर, मी ते खाद् तवय ते माले तोंडमां मधनासारखा गोड लागना. ");
INSERT INTO ahr_vpl VALUES ("EK3_4","027_3_4","EZK","3","4","4","मंग तो माले बोलना, मानवपुत्रा, जाय, इस्त्राएलना घराणाकडे जाय अनी त्यासनाजोडे मना वचन बोल. ");
INSERT INTO ahr_vpl VALUES ("EK3_5","027_3_5","EZK","3","5","5","कारण बाबर ओठना अनी जड जीभना लोकेसकडे नही तर इस्त्राएलना घराणाकडे मी तुले धाडसं. ");
INSERT INTO ahr_vpl VALUES ("EK3_6","027_3_6","EZK","3","6","6","ज्यासनी बोली तुले समजसं नही आशे बाबर ओठना अनी जड जीभना बराच राष्ट्र शेतस, त्यासकडे मी तुले धाडसं नही, त्यासकडे मी तुले धाडतूं तर खरच त्या तुना आयकतात. ");
INSERT INTO ahr_vpl VALUES ("EK3_7","027_3_7","EZK","3","7","7","पण इस्त्राएल घराणं तुनं आयकावूत नही; कारण त्या मना सुध्दा आयकावुत नही; कारण इस्राएलना बठा घराणा कठीण कपायनां अनी कठीण ह्रदयना शे. ");
INSERT INTO ahr_vpl VALUES ("EK3_8","027_3_8","EZK","3","8","8","दख, मी त्यासनी मुद्रासारखी तुनी मुद्रा वज्रपाय करसं, त्यासना कपायनासारखा तुनं कपाय कठीण करसं. ");
INSERT INTO ahr_vpl VALUES ("EK3_9","027_3_9","EZK","3","9","9","मी तुनं डोकं गारगोटीपेक्षा वज्रप्राय कठीण करस; त्यासले तु भ्यावानं नही; त्यासना कटाक्षाघाई कापानं नही. ");
INSERT INTO ahr_vpl VALUES ("EK3_10","027_3_10","EZK","3","10","10","आजुन तो बोलना, मानवपुत्रा, ज्या सर्वा वचन मी तुले सांगस त्या आपल ह्दयमां साठाडं, ती कानघाई आयक. ");
INSERT INTO ahr_vpl VALUES ("EK3_11","027_3_11","EZK","3","11","11","जाय, धरीसनं लयी जायेल तुना लोकेसना वंशसकडे जायीसनं त्यासनासंगे बोल; त्यासले सांग की प्रभु परमेश्वर असं सांगस, मंग त्या तुना आयकोत किंवा नही आयकोत. ");
INSERT INTO ahr_vpl VALUES ("EK3_12","027_3_12","EZK","3","12","12","तवय माले आत्मानी उचली धरं अनी मनामांगेतीन त्याना स्थानमाईन, परमेश्वरना वैभवना धन्यवाद असो, असं जोरमां शब्द व्हयेल मी आयकं. ");
INSERT INTO ahr_vpl VALUES ("EK3_13","027_3_13","EZK","3","13","13","अनी त्या जनावरसना पख येरायेरले लागेत त्यासना आवाज अनी त्यासना बाजुले ज्या चाक व्हतात त्यासना आवाज, असं जोरमां प्रचंड वेगमां मी शब्द आयकं. ");
INSERT INTO ahr_vpl VALUES ("EK3_14","027_3_14","EZK","3","14","14","मंग आत्मानी माले उचली धरं; मी मना मनतीन संतापतीन क्लेश पावनू तवय परमेश्वरनं वरहदस्त जोरमां मनावर वना. ");
INSERT INTO ahr_vpl VALUES ("EK3_15","027_3_15","EZK","3","15","15","मंग धरीसनं लयी जायेल लोके जठे राहेत तठे त्यासनाकडे खबार नदीना काठले तेल-अबीब हाई नगरमां मी वनू अनी त्या बठेल व्हतात तठे मी बसनू; भ्यायी भ्यायीसनं सात दिन मी त्यासनामां बसी राहीनू. ");
INSERT INTO ahr_vpl VALUES ("EK3_16","027_3_16","EZK","3","16","16","मंग त्या सात दिन व्हवावर परमेश्वरनं वचन माले प्राप्त व्हयनं ते आशे; ");
INSERT INTO ahr_vpl VALUES ("EK3_17","027_3_17","EZK","3","17","17","मानवपुत्रा, मी तुले इस्त्राएलना घराणावर पहारेकरी नेमेल शे, म्हनीसनं तु मनं तोंडनं वचन आयकीसनं मनाकडतीन‍ त्यासले बजाडीसनं सांग, ");
INSERT INTO ahr_vpl VALUES ("EK3_18","027_3_18","EZK","3","18","18","तु नक्की मरशी आशे मी पातक्यासले बोलनू तवय तु जर त्यासले बजाडं नही अनी पातक्यासनी आपला कुमार्ग सोडीसनं जगाले पाहिजे म्हनीसनं तु‍ त्यासले बजाडीसनं सांग नही, तर तो पातकी आपली दुष्टाईमुये मरी; पण त्याना रंगतना झाडा मी तुनापाईन लिसू. ");
INSERT INTO ahr_vpl VALUES ("EK3_19","027_3_19","EZK","3","19","19","तु त्या पातक्याले बजाडं तरीबी त्यानी आपली दुष्टाई अनी कुमार्ग सोडं नहीत, तर तो आपली दुष्टाईमुये मरी, अनी तु आपला जीव वाचाडं असं व्हयी. ");
INSERT INTO ahr_vpl VALUES ("EK3_20","027_3_20","EZK","3","20","20","तसच धार्मिक आपली धार्मिकता सोडीसनं अधर्म कराले लागना अनी मी त्यानासमोर अडखुळा ठेवा तर तो मरी; तु त्याले बजाडं नही व्हयीते तो आपला पातकमुये मरी, अनी त्यानी करेल धार्मिकता जमेस धरता येवावू नही, पण त्याना रंगतना झाडा मी तुनापाईन लिसू ");
INSERT INTO ahr_vpl VALUES ("EK3_21","027_3_21","EZK","3","21","21","पाप कराले नही पाहिजे असं तु त्या धार्मिकले बजाडं, अनी त्यानी पाप करं नही, तर त्यानी बोध लेवाशिवाय तो जगी अनी तु आपला जीव वाचाडं असं व्हयी. ");
INSERT INTO ahr_vpl VALUES ("EK3_22","027_3_22","EZK","3","22","22","तवय तठे परमेश्वरनं सामर्थ्य मनावर व्हनं अनी तो माले बोलना, ऊठ, खोरामां जाय, तठे मी तुनासंगे बोलसू. ");
INSERT INTO ahr_vpl VALUES ("EK3_23","027_3_23","EZK","3","23","23","मंग मी ऊठीसनं खोरामां गयू तवय खबार नदीनाजोडे मी दख‍ व्हतं तसं परमेश्वरनं तेज तठेबी मनासमोर उभं व्हतं, तवय मी उपडा पडनू. ");
INSERT INTO ahr_vpl VALUES ("EK3_24","027_3_24","EZK","3","24","24","मंग आत्मानी मनामां परवेश करीसनं माले मना पायवर उभं करं; त्यानी मनासंगे भाषण करीसनं सांग, \"जाय, तु सोताले घरमां कोंढी लेय.\" ");
INSERT INTO ahr_vpl VALUES ("EK3_25","027_3_25","EZK","3","25","25","हे मानवपुत्रा, दख, तुले बंधनमां बांधी ठेवतीन, अनी तुले बाहेर त्या लोकेसमां जाता येवावू नही; ");
INSERT INTO ahr_vpl VALUES ("EK3_26","027_3_26","EZK","3","26","26","तुनी जीभ तुनी टाळुले चिटकी असं मी करसूं, मनजे तु मुका व्हशी; अनी तु त्यासना निषेधकर्ता व्हवावू नही; कारण ते भांडखोर घराणं शे. ");
INSERT INTO ahr_vpl VALUES ("EK3_27","027_3_27","EZK","3","27","27","तरीबी मी तुनासंगे बोलसू तवय मी तुनं तोंड उघाडसू, मंग तु त्यासले सांग की, प्रभू परमेश्वर सांगस, ज्याले आयकानं व्हयी तो आयको, ज्याले आयकानं नही‍ व्हयी, तो नही आयको, त्या तर भांडखोर घराणं शे. ");
INSERT INTO ahr_vpl VALUES ("EK4_1","027_4_1","EZK","4","1","1","हे मानवपुत्रा, एक ईट लिसनं तुनासमोर मांड; तिनावर यरुशेलम नगरना चित्र काढ. ");
INSERT INTO ahr_vpl VALUES ("EK4_2","027_4_2","EZK","4","2","2","त्याले वेढा पडेल शे; त्यानासमोर बुरुज रचीसनं मोरचा बांधेल शेतस; त्यानासमोर तळ पडेल शे; टक्कर दिसनं भित पाडानं यंत्र त्याना आजुबाजूले शेतस, असं चित्र काढ. ");
INSERT INTO ahr_vpl VALUES ("EK4_3","027_4_3","EZK","4","3","3","मंग तु एक लोखंडी कढई लेय, ती तुनामां अनी त्या नगरमां जशी काय लोखंडी भित म्हनीसनं ठेव; तु आपला तोंड तिनाकडे कर; तिले वेढाना स्थीतीमां लय; तु तिले वेढा घालनारा व्हय, हाई इस्त्राएल घराणाले चिन्ह व्हयी. ");
INSERT INTO ahr_vpl VALUES ("EK4_4","027_4_4","EZK","4","4","4","आजुन तु आपली डावी कुशीवर झोप अनी इस्त्राएल घराणानं अधर्म त्या कुशीवर ठेव; जेवढा दिन तु त्या कुशीवर झोपी राहाशी तेवढा दिन त्यासना अधर्म भार वाही राहाय. ");
INSERT INTO ahr_vpl VALUES ("EK4_5","027_4_5","EZK","4","5","5","कारण त्यासना अधर्मना वरीस एवढा दिन मी तुना हिशोबमां मोजेल शेतस; तिनशे नव्वद दिन तुले इस्त्राएलना घराणानं भार वाहावानं शे. ");
INSERT INTO ahr_vpl VALUES ("EK4_6","027_4_6","EZK","4","6","6","मंग त्या दिन सरावर तु उजवी कुशीवर झोप अनी चाळीस दिन यहुदा घराणानं अधर्मना भार वाहाय; परतेक वरीसनाबद्दल तुना हिशोबमां मी एक दिन धरेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK4_7","027_4_7","EZK","4","7","7","तु आपला तोंड अनी उघडा हात यरुशेलमना वेढाना चित्रकडे रोखीसनं धरं अनी त्यानाईरोधमां संदेश देय. ");
INSERT INTO ahr_vpl VALUES ("EK4_8","027_4_8","EZK","4","8","8","दख, मी तुले बंधनघाई बांधसं, मनजे तु आपला वेढाना दिन सरस तोपावोत हाई कुशीकडतीन ती कुशीकडे वळानं नही. ");
INSERT INTO ahr_vpl VALUES ("EK4_9","027_4_9","EZK","4","9","9","तु गहू, जव, पावटे, मसुर, बाजरी अनी काठया गहु लिसनं एक भांडामां टाक; अनी आपलाकरता त्यानी भाकर बनाडं; तु आपला कुशीवर झोपशी त्या दिनना संख्याना मानतीन तीनशे नव्वद दिन तुले ती खावानी शे. ");
INSERT INTO ahr_vpl VALUES ("EK4_10","027_4_10","EZK","4","10","10","तु जे अन्न खाशी ते वजनतीन रोजनं ईस शेकेल राहीसनं ते तु मजार मजारमां खाय; ");
INSERT INTO ahr_vpl VALUES ("EK4_11","027_4_11","EZK","4","11","11","अनी दोन ग्लास पाणी पेय; ते तु दिनमां एकदाव पेय. ");
INSERT INTO ahr_vpl VALUES ("EK4_12","027_4_12","EZK","4","12","12","जवना भाकर परमानं ती भाकर करीसनं खाय; ती लोकेसनासमोर मानवी विष्ठघाई भुज. ");
INSERT INTO ahr_vpl VALUES ("EK4_13","027_4_13","EZK","4","13","13","परमेश्वर बोलना, यापरमानं मी इस्त्राएल वंशसना ज्या राष्ट्रमां हाकली दिसू तठे त्या आपली अमंगळ भाकर खातीन. ");
INSERT INTO ahr_vpl VALUES ("EK4_14","027_4_14","EZK","4","14","14","तवय मी बोलनू, अहा! प्रभू परमेश्वरा! दख, मी कवयच ईटाळनू नही; मी दाखलपनपाईन आजपावोत कधीच त्याना मरेल नाहिते जनावरले फाडीसनं मारेल जनावरनं मांस खाद नही; अमंगळ मांस मना तोंडले लागनं नही. ");
INSERT INTO ahr_vpl VALUES ("EK4_15","027_4_15","EZK","4","15","15","मंग तो माले बोलना, दख, मानवी विष्ठेना जागवर गायनं शेण वापरानी मी तुले परवानगी देस; त्याना गोवर्‍यासघाई आपली भाकर भुज. ");
INSERT INTO ahr_vpl VALUES ("EK4_16","027_4_16","EZK","4","16","16","आजुन तो माले बोलना, मानवपुत्रा, दख, मी यरुशेलममां भाकरीसना आधार तोडसू मनजे लोके कष्टी व्हयीसनं भाकरी तोलीसनं खातीन; अनी भ्याईसनं पानी मापमास पितीन. ");
INSERT INTO ahr_vpl VALUES ("EK4_17","027_4_17","EZK","4","17","17","कारण भाकर अनी पानी यासनी तुट पडी, लोके येरायेरकडे दखीसनं भयचकीत व्हतीन अनी अधर्ममां क्षय पावतीन. ");
INSERT INTO ahr_vpl VALUES ("EK5_1","027_5_1","EZK","5","1","1","हे मानवपुत्रा, तु एक धारदर तलवार लेय; ती न्हावीना वस्तरानामायक वापरीसनं आपला डोकावर अनी दाढीवर चालाडं; मंग तराजू लेय अनी केसना वजन करीसनं त्यासनी वाटणी करं. ");
INSERT INTO ahr_vpl VALUES ("EK5_2","027_5_2","EZK","5","2","2","नगरना वेढाना दिन सरनात मनजे हया केससना एक तृतीयांश नगरनां मजारमां आगघाई जाळी टाक; एक तृतीयांश केस लिसनं त्यानावर चारीमेर तलवार चालाडं अनी उरेल तृतीयांश वारावर उडाव; हाई परकारं मी तलवार उपसीसनं त्या लोकेसनी पाठ पुरावसू. ");
INSERT INTO ahr_vpl VALUES ("EK5_3","027_5_3","EZK","5","3","3","त्यासमासला थोडासा केस लिसनं आपला कपडासना पदरले बांध. ");
INSERT INTO ahr_vpl VALUES ("EK5_4","027_5_4","EZK","5","4","4","त्यामाईन आजुन थोडा लिसनं आगमां टाकीसनं जाळं, मनजे त्यामाईन आग निघीसनं इस्त्राएलना सर्वा घराणाले व्यापी. ");
INSERT INTO ahr_vpl VALUES ("EK5_5","027_5_5","EZK","5","5","5","प्रभु परमेश्वर सांगस, दखा, हे यरुशेलम; ज्या दुसरा राष्ट्रसमां स्थापेल शे अनी हयाना आजुबाजूले देश बसाडेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK5_6","027_5_6","EZK","5","6","6","तरी त्यानी दुष्ट आचरण करीसनं मना निर्णयले दुसरा राष्ट्रसपेक्षा जास्त ईरोध करं, त्यानी आजुबाजूना परदेशपेक्षा मना नियमना ईरोध जास्त करं; कारण त्यासनी मना निर्णयना अव्हेर करा अनी मना नियमपरमानं त्या चालनात नही. ");
INSERT INTO ahr_vpl VALUES ("EK5_7","027_5_7","EZK","5","7","7","यामुये प्रभु परमेश्वर सांगस, ज्यामुये तुमी आपला आजुबाजूना राष्ट्रसपेक्षा जास्त बंडाळी करी अनी मना नियमपरमानं चालनात नही, मना निर्णय पाळात नही अनी आसपास राष्ट्र शेतस त्यासना निर्णयपरमानंसुध्दा वागनात नही. ");
INSERT INTO ahr_vpl VALUES ("EK5_8","027_5_8","EZK","5","8","8","यामुये प्रभु परमेश्वर सांगस, दखा, मी, मीच तुनाईरोधमां व्हसू अनी राष्ट्रसदेखत तुना न्यायशासन करसू. ");
INSERT INTO ahr_vpl VALUES ("EK5_9","027_5_9","EZK","5","9","9","तुना सर्वा अमंगळ कृत्यासमुये, आजपावोत मी करं नही अनी परत त्यापरमानं करावू नही, अस मी तुनामां करसू. ");
INSERT INTO ahr_vpl VALUES ("EK5_10","027_5_10","EZK","5","10","10","तुनामां बाप आपला पोर्‍याना मास खायी अनी पोर्‍या आपला बापना मास खायी; अनी तुनामां न्यायशासन करी अनी तुना बठा उरेल लोके दिशा दिशाले पसारी टाकसू. ");
INSERT INTO ahr_vpl VALUES ("EK5_11","027_5_11","EZK","5","11","11","प्रभु परमेश्वर सांगस, मनी जीवनी शपथ, तु मना पवित्रस्थान आपला सर्वा तिरस्करणीय वस्तुसनी अनी अमंगळ कर्म करीसनं भ्रष्ट करं, म्हनीसनं खात्रीतीन मी तुनावरतीन कृपा काढी लिसू, दया करावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK5_12","027_5_12","EZK","5","12","12","तुना वस्तीना तिसरा हिस्सा महामारीघाई मरी अनी तुनामां लोके उपासमारीमां नाश पावतीन; तिसरा हिस्सा तुना आजुबाजूले तलवारघाई पडतीन; अनी तिसरा हिस्सा दिशा दिशाले विखरी टाकसू; मी तलवारघाई त्यासनी पाठ फिरावसू. ");
INSERT INTO ahr_vpl VALUES ("EK5_13","027_5_13","EZK","5","13","13","\"अशी मना रागनी पुर्तता व्हयी अनी त्यानावरना मना क्रोधना तृप्ती व्हयीसनं मन समाधान व्हयी, मी त्यानावरना मना क्रोधना शेवट करं मनजे त्या समजतीन की मी परमेश्वर हाई आवेशतीन बोलेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK5_14","027_5_14","EZK","5","14","14","आजुन तुना आजुबाजूना राष्ट्रसमां मी तुले उजाड करसू, अपशब्दसना विषय करसू, अनी येनारा जाणारा हाई दखतीन. ");
INSERT INTO ahr_vpl VALUES ("EK5_15","027_5_15","EZK","5","15","15","\"मी क्रोधतीन, संतापतीन अनी तीव्र निषेधवाणीघाई तुनं न्यायशासन करसू तवय तुना आजुबाजूना राष्ट्रसले तु अपशब्द, निंदा, ताकीद अनी विस्मय यासना विषय व्हशी; मी परमेश्वर हाई बोलनू शे. ");
INSERT INTO ahr_vpl VALUES ("EK5_16","027_5_16","EZK","5","16","16","मी तुमना नाश कराकरता उपासमारीनं नाशकारक तीक्ष्ण बाण सोडसू, तवय तुमनावर मी दुष्काळनं कहर करसू अनी तुमन्या भाकरीसना आधार तोडसू; ");
INSERT INTO ahr_vpl VALUES ("EK5_17","027_5_17","EZK","5","17","17","मी तुमनावर दुष्काळ अनी हिस्र पशु धाडसू; त्या तुमले निसंतान करतीन; मरी अनी रक्तपात हाई तुमनावर येतीन; मी तुमनावर तलवार आणसू; मी परमेश्वर हाई बोलनू शे. ");
INSERT INTO ahr_vpl VALUES ("EK6_1","027_6_1","EZK","6","1","1","मंग परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK6_2","027_6_2","EZK","6","2","2","मानवपुत्रा, तु आपला तोंड इस्त्राएलना पर्वतकडे करीसनं त्यासले लायीसनं संदेश देय. ");
INSERT INTO ahr_vpl VALUES ("EK6_3","027_6_3","EZK","6","3","3","असं सांग, इस्त्राएलना पर्वतसवन, प्रभु परमेश्वरनं वचन आयका, प्रभु परमेश्वर पर्वत, टेकडया, नाला अनी खोरा यासले म्हणसं, दखा, मी, मीच तुमनावर तलवार आणीसनं तुमना उच्चस्थानना नायनाट करसू. ");
INSERT INTO ahr_vpl VALUES ("EK6_4","027_6_4","EZK","6","4","4","तुमन्या वेदया वसाड व्हततीन, तुमन्या सुर्यमूर्त्या फोडी टाकतीन; तुमना मरी जायेल लोके तुमन्या मुर्तीसनासमोर पडतीन अस करसू. ");
INSERT INTO ahr_vpl VALUES ("EK6_5","027_6_5","EZK","6","5","5","मी इस्त्राएल लोकेसना प्रेतं त्यासन्या मुर्तीससमोर टाकसू, तुमन्या वेदयासनी आजुबाजूले तुमना हाडं पसरतीन. ");
INSERT INTO ahr_vpl VALUES ("EK6_6","027_6_6","EZK","6","6","6","तुमना बठा वस्तीस्थानमासला नगरसना नाश व्हतीन अनी उच्चस्थान उजाड व्हतीन. तुमन्या मुर्त्या भंगीसनं नष्ट व्हतीन, तुमन्या सुर्यमुर्ती तोडी टाकतीन; हाई परकारं तुमना हातना कामसना नाश करतीन. ");
INSERT INTO ahr_vpl VALUES ("EK6_7","027_6_7","EZK","6","7","7","तुमनामां वध व्हयेल पडतीन तवय तुमले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK6_8","027_6_8","EZK","6","8","8","\"तरीबी तुमीनं हाई देशमाईन तो देशमां इकडे तिकडे वशात तवय राष्ट्रसमां तुमनामाईन काही तलवारपाईन वाचीसनं राहातीन, आशे ज्या उरेल राहातीन त्यासले मी राखी ठेवसू. ");
INSERT INTO ahr_vpl VALUES ("EK6_9","027_6_9","EZK","6","9","9","तुमनामाईन ज्या राही जायेल शेतस ज्यासले राष्ट्रमां धरीसनं लयी जातीन तठे त्या मनी आठवन करतीन; तवय मनापाईन दुर व्हयेल त्यासनं दुराचारी ह्दय अनी त्यासनी मुर्तीकडे लायेल त्यासना दुराचारी डोया हाई मी वठणीमां लयीसू. ");
INSERT INTO ahr_vpl VALUES ("EK6_10","027_6_10","EZK","6","10","10","तवय त्या समजतीन की मी परमेश्वर शे, मी त्यासवर हाई अरीष्ट लयीसू हाई मी निरर्थक सांग नही. ");
INSERT INTO ahr_vpl VALUES ("EK6_11","027_6_11","EZK","6","11","11","प्रभु परमेश्वर सांगस, \"आपला हातपाय आपटीसनं सांग, इस्त्राएल घराणानां सर्वा अमंगळ दुष्कर्मसले धिक्कार असो; त्या तलवार, दुष्काळ अनी मरी यासघाई मरतीन. ");
INSERT INTO ahr_vpl VALUES ("EK6_12","027_6_12","EZK","6","12","12","जो दुर राही तो मरीघाई मरी, जो जोडे राही तो तलवारघाई मरी, यामाईनबी जो कोणी वाची तो दुष्काळमां मरी. ");
INSERT INTO ahr_vpl VALUES ("EK6_13","027_6_13","EZK","6","13","13","परतेक उंच टेकडीवर, बठा डोंगरसना माथावर, परतेक हिरवा झाडनाखाल, परतेक दाट पानसना एला झाडखाल ज्या ज्या ठिकानले त्यासनी आपला सर्वा मुर्तीसनासमोर धुपनं अर्पण करं, तठेना त्यासन्या मुर्त्यासमां त्यासन्या वेदयासनाभोवती त्यासना वध पावले पडतीन, तवय तुमले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK6_14","027_6_14","EZK","6","14","14","मी आपला हात त्यासनावर उगारसू अनी त्यासना सर्वा वस्तीस्थानमासला भुमी दिबलकडला रानपेक्षा वैरान अनी ओसाड करसू; तवय त्यासले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_1","027_7_1","EZK","7","1","1","आजुन परमेश्वरनं वचन माले प्राप्त व्हयनं; ");
INSERT INTO ahr_vpl VALUES ("EK7_2","027_7_2","EZK","7","2","2","\"प्रभु परमेश्वर इस्त्राएल देशले सांगस, \"हे मानवपुत्र,\" शेवट व्हयेल शे, देशना चारी बाजुना अंत व्हयेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_3","027_7_3","EZK","7","3","3","\"आते तुना अंत व्हयेल शे, मी मना संताप तुनावर भडकावसू, तुनी करणीपरमानं तुनं न्याय करसू अनी तुना सर्वा अमंगळ कृत्यासना प्रतिफळ तुले दिसू ");
INSERT INTO ahr_vpl VALUES ("EK7_4","027_7_4","EZK","7","4","4","मी तुनावर कृपादृष्टी करावू नही, मी दया करावू नही; तर तुना करणीना प्रतिफळ तुले दिसू, तुना अमंगळ कृत्यासना प्रतिफळ तुनामां दखाई तवय तुमले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_5","027_7_5","EZK","7","5","5","प्रभु परमेश्वर सांगस, विपत्तिमांगे विपत्ती यि राहीनी शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_6","027_7_6","EZK","7","6","6","अंत व्हयेल शे, व्हयेल शे, तो तुनाकरता जागृत व्हयेल शे; दख, तो यि राहीना शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_7","027_7_7","EZK","7","7","7","देशमासला रहीवास्या, तुनी घडी भरेल शे, काळ ऊना शे, दिन जोडे येयल शे, डोंगरवर आनंद नहीते धुमाकूळ व्हनार शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_8","027_7_8","EZK","7","8","8","\"आते मी संतापमां क्रोधना वर्षाव तुनावर करसू, मी मनी क्रोधनी परीपूर्ति तुनावर करसू, तुना आचरनपरमानं तुना‍ न्याय करसू अनी तुना सर्वा अमंगळ कृत्यासना प्रतिफळ तुले दिसू. ");
INSERT INTO ahr_vpl VALUES ("EK7_9","027_7_9","EZK","7","9","9","मी तुनावर कृपादृष्टी करावू नही; मी तुनी दया करावू नही; तर तुनं आचरणंनं प्रतिफळ तुले दिसू, तुना अमंगळ कृत्यासना प्रतिफळ तुले दिसू. तवय तुले समजी की मी परमेश्वर तुले मारणार शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_10","027_7_10","EZK","7","10","10","दख, तो दिन! दख तो यि राहीना शे! तुना शिक्षारुपी रोप उगवना शे, तो फोफाईसनं त्याना दंड बनेल शे, तो गर्वतीन फुगी जायेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_11","027_7_11","EZK","7","11","11","बलात्कार हाई शासनदंड व्हयीसनं बसेल शे, त्या लोकेसमासला कोणीबी, त्यासना समुहमासला कोणीबी, त्याना धनमासला काहीबी, उराव नही; त्यासनी काहीच प्रतिष्ठा राहावावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK7_12","027_7_12","EZK","7","12","12","येळ येयल शे, दिन जोडे येयल शे, ईकत लेनारानी आनंद कराले नको, ईकनाराले दुख व्हवाले नको; कारण त्या सर्वा समुहवर क्रोध यि राहिना शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_13","027_7_13","EZK","7","13","13","ईकनारा जीवत राहिना तरी तो ईकेल जमीनपान परत जावावू नही; कारण हाई भविष्य त्या सर्वा समुहबद्दल शे; त्यामासला काहीच चुकावू नही; कोणीच आपला अधर्मतीन आपला जीवले बळकटी आणावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK7_14","027_7_14","EZK","7","14","14","त्या करणा वाजाडतसं, बठी तयारी करतसं, तरी कोणीच युध्द कराले पुढे सरकतसं नही; कारण त्या समुहवर मना कोप व्हयेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_15","027_7_15","EZK","7","15","15","बाहेर तलवार, मजारमां मरी अनी दुष्काळ; वावरमां ज्या‍ शेतस त्या तलवारघाई मरतीन; नगरमां ज्या शेतस त्या दुष्काळ अनी महामारी त्यासले मारी टाकी. ");
INSERT INTO ahr_vpl VALUES ("EK7_16","027_7_16","EZK","7","16","16","त्यासमासला काही वाचतीन त्या वाचतीन, पण त्या सर्वा खोरामासला पारवासपरमानं डोंगरवर आपला अधर्ममुये फिरत राहातीन. ");
INSERT INTO ahr_vpl VALUES ("EK7_17","027_7_17","EZK","7","17","17","बठासना हात ढिला पडतीन, त्यानसा गुडघामां पाणी व्हयी. ");
INSERT INTO ahr_vpl VALUES ("EK7_18","027_7_18","EZK","7","18","18","त्या कंबरले गोणताट गुंडाळतीन, दरारा त्यासले व्यापी टाकी; त्या बठासनी तोंडवर लज्जा राही अनी सर्वासना डोका भादरतीन. ");
INSERT INTO ahr_vpl VALUES ("EK7_19","027_7_19","EZK","7","19","19","त्या आपला पैसा रस्तावर फेकी देतीन; त्यासले आपला सोना अमंगळ वाटी, परमेश्वरना कोपना दिन त्यासना सोनारुप्यासघाई त्यासना बचाव व्हवावू नही, त्यासपाईन त्यासनी जीवनी तृप्ती व्हवावू नही, त्यासनं पोट भरावू नही, कारण त्यासनी त्यामुये ठोकर खाईसनं अधर्म करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_20","027_7_20","EZK","7","20","20","त्यासनी त्यानी करेल भुषणे दिमाख दखाडाकरता वापरी; त्यासनी त्यानी अमंगळ मुर्ती अनी तिरस्करणीय वस्तु आपलाकरता बनाडयात; म्हनीसनं ते त्यासले अमंगळ वस्तुसनासारखा वाटाले पाहिजे अस मी करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK7_21","027_7_21","EZK","7","21","21","ते मी परदेशीसले भक्ष्य म्हनीसनं दिसू, ते जगमासला दुष्टासले लूट म्हनीसनं दिसू, त्या ते भ्रष्ट करतीन. ");
INSERT INTO ahr_vpl VALUES ("EK7_22","027_7_22","EZK","7","22","22","मी आपलं तोंड त्यासनापाईन फिरावसू, मनजे त्या लोके मना भांडार भ्रष्ट करतीन, लुटारु त्यामां घुशीसनं ते भ्रष्ट करतीन. ");
INSERT INTO ahr_vpl VALUES ("EK7_23","027_7_23","EZK","7","23","23","\"बेडी तयार करा, कारण देश रक्तपातना गुन्हासघाई भरेल शे, नगर हिंसाघाई भरेल शे ");
INSERT INTO ahr_vpl VALUES ("EK7_24","027_7_24","EZK","7","24","24","त्याकरता मी वाईटमासाला वाईले लयी यिसू; त्या त्यासना घर ताबामां लेतीन; ज्या ताकदवान शेतस त्यासना ताठपणा तोडी टाकसू; त्यासना पवित्रस्थान भ्रष्ट करी टाकसू. ");
INSERT INTO ahr_vpl VALUES ("EK7_25","027_7_25","EZK","7","25","25","नाश यि राहीना शे; त्या शांती शोधतीन पण त्यासले सापडावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK7_26","027_7_26","EZK","7","26","26","संकटवर संकट येतीन अनी अफवावर अफवा पसरतीन; तवय त्या संदेष्टासले दृष्टांत सांगाले सांगतीन पण याजकसना धर्मशास्रना ज्ञान अनी वडीलसना मसलत देवानं सामर्थ्य हाई नष्ट व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("EK7_27","027_7_27","EZK","7","27","27","राजा शोक करतीन सरदार दराराघाई भ्याईतीन; देशमासला लोकेसना हात थरथर कांपतीन; मी त्यासना आचरणपरमानं त्यासनासंगे वागसू, त्यासना गुणपरमानं त्यासना न्याय करसू; तवय त्यासले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK8_1","027_8_1","EZK","8","1","1","सहावा वरीसले सहावा महीनाना पंचमीले आशे व्हयनं की मी मना घर बसेल व्हतूं अनी यहुदासना वडील मनासमोर बसेल व्हतात; तवय तठे परमेश्वरना सामर्थ्य मनावर ऊना. ");
INSERT INTO ahr_vpl VALUES ("EK8_2","027_8_2","EZK","8","2","2","मी दख तवय एक माणसु शे आशे माले भास व्हयनं; त्यानां कंबरपाईन खाल आगना शे आशे माले भास व्हयनं अनी त्याना कंबरपाईन वर पितयना तेजनासारखा तेज माले दखायनं. ");
INSERT INTO ahr_vpl VALUES ("EK8_3","027_8_3","EZK","8","3","3","तवय त्यानी हात पुढे करीसनं मनी डोकानी एक लट धरी, अनी आत्मातीन आकाश अनी पृथ्वीनी मजार माले उचलीसनं दिव्यदृष्टीतीन यरुशेलम आठे उत्तरले मजारमां आंगणना दारनाजोडे आणं; तठे जाळी टाकी आशी मुर्तीनं आसन व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK8_4","027_8_4","EZK","8","4","4","मंग दख, तवय मी खोरामां दृष्टांत दखं व्हतं त्यानासारखाच इस्त्राएलना देवना तेज तठे व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK8_5","027_8_5","EZK","8","5","5","तवय तो माले बोलना, मानवपुत्रा, आपला डोया वर करीसनं उत्तर दिशाकडे दख, मी उत्तरले दृष्टी लायी तवय वेदीना वेशीना उत्तरले मंदीरना प्रवेशव्दारना रस्तामां आग तयार करनारी मुर्ती व्हती. ");
INSERT INTO ahr_vpl VALUES ("EK8_6","027_8_6","EZK","8","6","6","तो माले बोलना, मानवपुत्रा, त्या काय करी राहिना शेतस ते दखी राहीना ना? मी मना पवित्रस्थानमाईन दूर निघी जावाले पाहिजे म्हनीसनं आशी अमंगळ कृत्ये इस्त्राएल घराणं करी राहीना शे; यानापेक्षा जास्त अमंगळ कृत्ये तुले दखायतीन. ");
INSERT INTO ahr_vpl VALUES ("EK8_7","027_8_7","EZK","8","7","7","तवय त्यानी माले आंगणना प्रवेशना रस्तामां आणं; मी दख भितले छीद्र पडेल व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK8_8","027_8_8","EZK","8","8","8","त्यानी माले सांग, मानवपुत्रा, भित खंद, मी भित खंदी तवय दखं तर; दार लागनं ");
INSERT INTO ahr_vpl VALUES ("EK8_9","027_8_9","EZK","8","9","9","तवय तो माले बोलना, आठे हया माणसे कसाना दुष्ट अनी अमंगळ कृत्ये करी राहीना शेतस त्या दख. ");
INSERT INTO ahr_vpl VALUES ("EK8_10","027_8_10","EZK","8","10","10","मी मजार जायीसनं दख तवय सरपटणारा प्राणी, अमंगळ पशु अनी इस्त्राएल घराणान्या बठया मुरत्या त्यासना चित्र भितना चारीमेर काढेल व्हत्यात. ");
INSERT INTO ahr_vpl VALUES ("EK8_11","027_8_11","EZK","8","11","11","त्यासनासमोर इस्त्राएल घराणाना वडीलमासला सत्तर माणसे उभा व्हतात तवय त्यासनामां याजन्या बिन शाफान हाऊ उभा व्हता; त्या परतेक माणुसना हातमां धुपाटना व्हतात; तठे धुपना दाट धुरना धुराडा वर जाई राहींनता. ");
INSERT INTO ahr_vpl VALUES ("EK8_12","027_8_12","EZK","8","12","12","तो माले बोलना, मानवपुत्रा, इस्त्राएल घराणाना परतेक वडील आपला मुर्तीसना घरमां अंधारमां काय करी राहीना शे हाई तुले दखाई राहीना शे ना? त्या तर सांगतस की परमेश्वर आमले दखसं नही; परमेश्वरनी देशना त्याग करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK8_13","027_8_13","EZK","8","13","13","तो माले बोलना, त्या यानापेक्षा जास्त अमंगळ कृत्ये करी राहीना शेतस, त्या तुले परत दखावामां येतीन. ");
INSERT INTO ahr_vpl VALUES ("EK8_14","027_8_14","EZK","8","14","14","तवय त्यानी माले परमेश्वरना मंदीरना उत्तरले जो दरवाजा व्हता तठे आणं; तवय तठे बाया बसीसनं तम्मुजकरता शोक करी राहींनत्यात. ");
INSERT INTO ahr_vpl VALUES ("EK8_15","027_8_15","EZK","8","15","15","तो माले बोलना, मानवपुत्रा, तुले हाई दखास ना? हयानापेक्षा जास्त अमंगळ गोष्टी तुले दखायतीन. ");
INSERT INTO ahr_vpl VALUES ("EK8_16","027_8_16","EZK","8","16","16","तवय त्यानी माले परमेश्‍वरना मंदीरना मजारना आंगणमां लयी गया; तवय दख, परमेश्वरना मंदीरना दारपान देवडी अनी वेदीना मजारमां जवयपास पंचवीस माणसे परमेश्वरना मंदीरकडे पाठ करीसनं अनी पुर्वले तोंड करीसनं उभा व्हतात; त्या पुर्व दिशाले सुर्यनी उपासना करत व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK8_17","027_8_17","EZK","8","17","17","तो माले बोलना, मानवपुत्रा, तुले हाई दखास ना? यहुदाना घराणं आठे अमंगळ कृत्ये करी राहीना शे, हाई कमी व्हयनं का? देश जुलूमना कृत्यासघाई भरीसनं त्या माले परत परत राग आनाडी राहीना शेतस; दख, त्या आपला नाकाले फाटा लायी राहीना शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK8_18","027_8_18","EZK","8","18","18","यामुये संतापमां मी जे करसू ते करसू; मी त्यासवर कृपादृष्टी करावू नही; त्यासवर दया करावू नही; त्या मोठा आवाजतीन मना कानपान आरोळया मारतीन तवय मी त्यासना आयकावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK9_1","027_9_1","EZK","9","1","1","मंग त्यानी माले आयकाले यी आशे जोरमां बोलना, नगरना राखणदारसवन, तुमी आपला बठा नाश करनारा हत्यार हातमां लिसनं ईकडे या. ");
INSERT INTO ahr_vpl VALUES ("EK9_2","027_9_2","EZK","9","2","2","तवय दख, उत्तरकडली वरनी वेशीना सवू माणसे आपला हातमां नाश करनारा हत्यार लिसनं ऊनात; त्यासनामां शुभ्र तागना कपडा घालेल एक माणुस व्हता; त्याना कंबरनाजोडे कारकुनी दऊत व्हती. त्या मजार जायीसनं पितळी वेदीनाजोडे उभा राहीनात. ");
INSERT INTO ahr_vpl VALUES ("EK9_3","027_9_3","EZK","9","3","3","करुबारढ इस्त्राएलना देवना तेज तठेन निघीसनं मंदीरना उंबरठावर ऊना; अनी कंबरनाजोडे कारकुननी दऊत ज्यापान व्हती अनी शुभ्र कपडा घालेल त्या माणसुले त्यानी हाक मारी. ");
INSERT INTO ahr_vpl VALUES ("EK9_4","027_9_4","EZK","9","4","4","परमेश्वर त्याले बोलना, नगरमाईन, यरुशेलममां जाईसनं ज्या माणसे आपलामां व्हयी राहेल बठा अमंगळ कृत्यासमुये उसासे टाकीसनं विलाप करी राहीना शेतस त्यासना कपायवर चिन्ह कर. ");
INSERT INTO ahr_vpl VALUES ("EK9_5","027_9_5","EZK","9","5","5","माले आयकाले यी आशे तो बाकीसले बोलना, त्यानामागे नगरमां जा अनी त्यासना नाश कर; कृपादृष्टी करानं नही अनी दया करानं नही; ");
INSERT INTO ahr_vpl VALUES ("EK9_6","027_9_6","EZK","9","6","6","धयडा, तरुण अनी कुवार्‍या, पोर्‍या अनी बाया हया बठासना कत्तल कर; पन ज्यासवर चिन्ह व्हयी त्यासले हात लावानं नही; मना पवित्रस्थानपाईन चालू करा; तवय मंदीरनासमोर ज्या वडील उभा व्हतात तठेन त्यासनी सुरुवात करी. ");
INSERT INTO ahr_vpl VALUES ("EK9_7","027_9_7","EZK","9","7","7","त्यानी त्यासले सांग, मंदीर भ्रष्ट करा; आंगण वधेलसघाई भरी टाका; चाला, निघा; तवय त्यासनी जायीसनं नगरना नाश करं; ");
INSERT INTO ahr_vpl VALUES ("EK9_8","027_9_8","EZK","9","8","8","त्यासनी आशी कत्तल चालू व्हती तवय मी सुटनूं अनी मी उपडा पडीसनं वरडीसनं बोलनू; हाय! प्रभु परमेश्वरा, तु यरुशेलमवर आपला क्रोधना वर्षाव करीसनं बठा इस्त्राएलना नाश करशी का? ");
INSERT INTO ahr_vpl VALUES ("EK9_9","027_9_9","EZK","9","9","9","तवय तो माले बोलना, इस्त्राएल अनी यहुदा यासना घराणाना अधर्म भलता भारी शे; देश रक्तपातना भरेल शे; नगर अन्यायघाई भरेल शे; कारण त्या म्हनतसं, परमेश्वरनी देशना त्याग करेल शे, परमेश्वर दखस नही. ");
INSERT INTO ahr_vpl VALUES ("EK9_10","027_9_10","EZK","9","10","10","मी तर कृपादृष्टी करावू नही, दया करावू नही, त्यासना आचरणं प्रतिफय त्यासना डोकावर टाकसू. ");
INSERT INTO ahr_vpl VALUES ("EK9_11","027_9_11","EZK","9","11","11","तवय दख; कंबरनाजोडे कारकूननं दऊत ज्यापान व्हतं अनी शुभ्र तागना कपडा घालेल तो माणुस परत यिसनं कळाडं की तुनी आज्ञापरमानं मी करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK10_1","027_10_1","EZK","10","1","1","मी दख तवय तो करुबनावरना छतवर तृणमनीनासारखा काही तरी दखयनं; ते सिंहना मूर्तीनामायक व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK10_2","027_10_2","EZK","10","2","2","मंग परमेश्वर तागना कपडा घालेल माणुसले बोलना, करुबानाखाल चाकना मजार जायीसनं करुबमाईन भितकासघाई आपली ओंजळ भर अनी ते नगरवर विखर, तवय तो मनासमोर गया. ");
INSERT INTO ahr_vpl VALUES ("EK10_3","027_10_3","EZK","10","3","3","तो माणसु मजार गया तवय करुब मंदीरना उजवीकडे उभा व्हतात अनी मजारना आंगण ढगघाई व्यापी टाकं व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK10_4","027_10_4","EZK","10","4","4","परमेश्वरनं तेज करुबवरतीन निघीसनं मंदीरना उंबरठावर येयल व्हतं; मंदीर ढगघाई व्यापी जायेल व्हतं अनी आंगण परमेश्वरनं तेजघाई भरी जायेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK10_5","027_10_5","EZK","10","5","5","करुबना पंखसना आवाज बाहेर आंगणमां जायी राहींनता; सर्वसमर्थ देवनी वाणीनामायक तो व्हता. ");
INSERT INTO ahr_vpl VALUES ("EK10_6","027_10_6","EZK","10","6","6","त्यानी शुभ्र तागना कपडा घालेल माणसुले आज्ञा दिसनं सांग की त्या चाकसमाईन, करुबना मजारतीन भितकं लेय; तवय तो जायीसनं चाकना बाजुले उभा राहीना. ");
INSERT INTO ahr_vpl VALUES ("EK10_7","027_10_7","EZK","10","7","7","मंग त्या करुबासमाईन एकनी आपला हात लांबाडीसनं करुबमासला ईस्तवले तो लावं; त्यानी त्यामाईन काही इंगळ लिसनं तागना कपडा घालेल त्या माणुसना हातमां दिद्; तो त्या लिसनं निघी गया. ");
INSERT INTO ahr_vpl VALUES ("EK10_8","027_10_8","EZK","10","8","8","तठे करुबनाजोडे त्यासना पखसनाखाल माणुसना हातना आकृतीनामायक काही तरी नजरमां व्हनं. ");
INSERT INTO ahr_vpl VALUES ("EK10_9","027_10_9","EZK","10","9","9","मी दख तवय परतेक करुबना बाजुले एक आशी बठया करुबना बाजुले चार चाके व्हतात; त्या चाके चमकनारा दखाई राहींनात. ");
INSERT INTO ahr_vpl VALUES ("EK10_10","027_10_10","EZK","10","10","10","दखावाले त्या चार चाकना डौलनामायक व्हतात; त्या जशे काय चाकनामांगे चाक आशे व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK10_11","027_10_11","EZK","10","11","11","त्या चालेत तवय चारी दिशाले पाहीजे त्या दिशासले जायेत; चालतांना वयेत नही; परतेक मस्तकना रोखतीन त्या जायेत, त्या चालेत तवय वयेत नही. ");
INSERT INTO ahr_vpl VALUES ("EK10_12","027_10_12","EZK","10","12","12","त्यासना बठा आंग, पाठ, हात, पख अनी चार चाके यासले बठीकडे डोया व्हतात. ");
INSERT INTO ahr_vpl VALUES ("EK10_13","027_10_13","EZK","10","13","13","चाकसले गरगर फिरनारा चाके आशे मी आयकं, ");
INSERT INTO ahr_vpl VALUES ("EK10_14","027_10_14","EZK","10","14","14","त्या परतेकले चार तोंड व्हतात; पहीले तोंड करुबना तोंडनामायक व्हतं; दुसरं माणुसना तोंडनामायक व्हतं; तिसरं सिंहना तोंडनामायक व्हतं अनी चौथ गरुडना तोंडनामायक व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK10_15","027_10_15","EZK","10","15","15","त्या करुब वर उडीसनं गयात; मी खबार नदीना काठले दख तो हाऊ प्राणी शे. ");
INSERT INTO ahr_vpl VALUES ("EK10_16","027_10_16","EZK","10","16","16","करुब चालनात मनजे चाके त्यानासंगे चालेत अनी जमीनवरतीन वर उडाकरता त्या आपला पख उचलेत तवय त्या चाके येगळा व्हयेत नही. ");
INSERT INTO ahr_vpl VALUES ("EK10_17","027_10_17","EZK","10","17","17","त्या थांबनात मनजे त्याबी थांबेत; त्या वर उडनात मनजे त्यानाबरोबर त्या वर जायेत; कारण त्या प्राण्यासना आत्मा त्यासमां व्हता. ");
INSERT INTO ahr_vpl VALUES ("EK10_18","027_10_18","EZK","10","18","18","तवय परमेश्वरनं तेज मंदीरना उंबरठावरतीन निघीसनं करुबनाजोडे जायीसनं राहीनात. ");
INSERT INTO ahr_vpl VALUES ("EK10_19","027_10_19","EZK","10","19","19","निंघाना येळले करुबनी आपला पख उचलात अनी त्या मनासमोर जमीनपाईन वर चढीसनं गयात; त्यानासंगे चाकबी गयात; त्या परमेश्वरना मंदीरना पुर्व दारपान थांबनात; त्यासनावर इस्त्राएलना देवना तेज व्हता. ");
INSERT INTO ahr_vpl VALUES ("EK10_20","027_10_20","EZK","10","20","20","खबार नदीना काठले मी इस्त्राएलना देवना आसननीखाल दख व्हतं तो हाऊ प्राणी शे; त्या करुब शेतस हाई माले कयनं. ");
INSERT INTO ahr_vpl VALUES ("EK10_21","027_10_21","EZK","10","21","21","त्यासले परतेकले चार तोंड व्हतात अनी त्यासले परतेकले चार पख व्हतात; त्यासना पखनाखाल माणसुनी हातनामायक आकृती व्हती. ");
INSERT INTO ahr_vpl VALUES ("EK10_22","027_10_22","EZK","10","22","22","त्यासना चेहरानीबारामां बोलशात ते खबार नदीना काठले मी दखेल चेहरानामायक त्या व्हतात. त्यासना रुप अनी त्या सोता तशाच व्हतात; त्या सरळ आपलासारखा चालेत. ");
INSERT INTO ahr_vpl VALUES ("EK11_1","027_11_1","EZK","11","1","1","मंग आत्मानी माले उचलीसनं परमेश्वरना मंदीरना पुर्वाभिमुख पुर्व वेशीकडे आणं; तवय दख, वेशीनामोरे पंचवीस माणसे व्हतात; त्यासनामां याजन्या बिन अज्जूर, अनी पलटया बिन बनाया हया लोकनायक मना नजरमां पडनात. ");
INSERT INTO ahr_vpl VALUES ("EK11_2","027_11_2","EZK","11","2","2","तो माले बोलना, मानवपुत्रा, वाईट योजना करनारा अनी हाई नगरमां अनिष्ट संकल्प करनारा त्या हयाच माणसे शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK11_3","027_11_3","EZK","11","3","3","त्या बोलतसं, घर बांधानी येळ आजुन येयल नही शे; हाई नगर जशी काय कढई अनी आमी त्यामासला मांस शे. ");
INSERT INTO ahr_vpl VALUES ("EK11_4","027_11_4","EZK","11","4","4","त्याकरता त्यासनाईरोधमां संदेश देय, मानवपुत्रा, संदेश देय. ");
INSERT INTO ahr_vpl VALUES ("EK11_5","027_11_5","EZK","11","5","5","तवय परमेश्वरना आत्मा मनावर उतरना, तो बोलना, आशे सांग, परमेश्वर सांगस, अहो इस्त्राएल वंशसवन, तुमी आशे सांग; तुमना मनमां काय काय यि राहीना शे ते माले माहीत शे. ");
INSERT INTO ahr_vpl VALUES ("EK11_6","027_11_6","EZK","11","6","6","तुमी हाई नगरमां बराच जणसले मारी टाक; तठेना रस्ता प्रेतघाई भरी टाकात. ");
INSERT INTO ahr_vpl VALUES ("EK11_7","027_11_7","EZK","11","7","7","यामुये प्रभू परमेश्वर सांगस, तुमी या नगरमां ज्यासले मारी टाकं, त्या मांस शेतस, अनी हाई नगर कढई शे; तुमले तर तठेतीन बाहेर लयी जातीन. ");
INSERT INTO ahr_vpl VALUES ("EK11_8","027_11_8","EZK","11","8","8","तुमी तलवारले भ्यायतसं, मी तुमनावर तलवार आणसू आशे परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK11_9","027_11_9","EZK","11","9","9","मी तुमले त्यामाईन बाहेर काढसू, मी तुमले परदेशीसना हातमां दिसू अनी तुमले न्यायदंड करसू. ");
INSERT INTO ahr_vpl VALUES ("EK11_10","027_11_10","EZK","11","10","10","तुमी तलवारघाई पडशात, इस्त्राएलनी सीमावर तुमनं न्याय करसू तवय तुमले समजी की मी परमेश्‍वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK11_11","027_11_11","EZK","11","11","11","हाई नगर तुमले कढई व्हवावू नही अनी तुमीन त्यामासला मांस व्हवात नही, इस्त्राएलना सीमावर तुमनं न्याय करसू. ");
INSERT INTO ahr_vpl VALUES ("EK11_12","027_11_12","EZK","11","12","12","तवय तुमले समजी की मी परमेश्वर शे; कारण तुमीन मना नियमपरमानं चालनात नही, मना निर्णय तुमी पायात नही, तर तुमीन आपला आजुबाजूना राष्ट्रसना नियमपरमानं वागनात. ");
INSERT INTO ahr_vpl VALUES ("EK11_13","027_11_13","EZK","11","13","13","मी हाऊ संदेश दि राहींनतु तवय आशे व्हयनं की पलटया बिन बनाया मरना, तवय मी उबडा पडीसनं जोरमां वरडीसनं बोलनू, अहा प्रभु परमेश्वरा, तु इस्त्राएलना अवशेषसना पुरा अंत करीशी का? ");
INSERT INTO ahr_vpl VALUES ("EK11_14","027_11_14","EZK","11","14","14","परमेश्वरनं वचन माले प्राप्त व्हयनं की ");
INSERT INTO ahr_vpl VALUES ("EK11_15","027_11_15","EZK","11","15","15","मानवपुत्रा, \"ज्या यरुशेलमनिवासी, परमेश्वरपाईन दूर राहाय, आमले देश वतन मिळेल शे, आशे म्हणतसं त्या तुना भाऊबंदच, तुना आप्तजन, इस्त्राएलना बठा घराणा शेतस.\" ");
INSERT INTO ahr_vpl VALUES ("EK11_16","027_11_16","EZK","11","16","16","त्याकरता आशे बोल, प्रभु परमेश्वर सांगस की मी त्यासले राष्ट्रमाईन घालाडीसनं देश देशमां पांगाडेल शे; तरी ज्या ज्या देशमां त्या जायेल शेतस तठे मी त्यासले अल्पकाय पवित्रस्थान व्हसू. ");
INSERT INTO ahr_vpl VALUES ("EK11_17","027_11_17","EZK","11","17","17","त्याकरता आशे बोल, प्रभु परमेश्वर सांगस की मी तुमले राष्ट्रसमाईन गोया करीसनं आणसू; ज्या ज्या देशमां तुमीन पांगले शेतस तठेन मी तुमले जमा करीसन आणसू. अनी इस्त्राएल देश तुमले दिसू. ");
INSERT INTO ahr_vpl VALUES ("EK11_18","027_11_18","EZK","11","18","18","त्या आठे येतीन अनी तठेना तिरस्करणीय अनी अमंगळ वस्तू आठेतीन काढी टाकसू. ");
INSERT INTO ahr_vpl VALUES ("EK11_19","027_11_19","EZK","11","19","19","मी त्यासले एकच ह्दय दिसू; तुमनामां नवीन आत्मा घालसू; मी त्यासना देहमाईन पाषाणयुक्त ह्दय काढी टाकसू त्यासले मांसमय ह्दय दिसू. ");
INSERT INTO ahr_vpl VALUES ("EK11_20","027_11_20","EZK","11","20","20","मनजे त्या मना नियमले धरीसनं चालतीन, मना निर्णय पायीसनं त्यापरमानं वागतीन, त्या मना लोके व्हतीन अनी मी त्यासना देव व्हसू. ");
INSERT INTO ahr_vpl VALUES ("EK11_21","027_11_21","EZK","11","21","21","तरी ज्यासनं मन त्यासना तिरस्करणीय अनी अमंगळ वस्तुसना मनोरथ परमानं चालतीन त्यासनं आचरणनं प्रतिफळ त्यासनाच माथी यी आशे मी करसू, आशे प्रभु परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK11_22","027_11_22","EZK","11","22","22","तवय करुबसनी आपला पख उचलात, त्यासनासंगे चाक बी उचलाई गयात अनी इस्त्राएलना देवना तेज त्यासनावर व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK11_23","027_11_23","EZK","11","23","23","मंग परमेश्वरना सामर्थ्य नगरनां मध्यभागतीन वऱ चढीसनं नगरना पुर्वना पर्वतवर राहीनं. ");
INSERT INTO ahr_vpl VALUES ("EK11_24","027_11_24","EZK","11","24","24","तवय त्या आत्म्यानी दृष्टांतमां माले उचलीसनं खास्दी देशमां धरीसनं आणेल लोकेसकडे आणं; अनी जो दृष्टांत मी दखी राहींनतू तो मना डोयाआड व्हयना. ");
INSERT INTO ahr_vpl VALUES ("EK11_25","027_11_25","EZK","11","25","25","मंग परमेश्वरनी माले सांगले सर्वा वचन, धरीसनं आणेल त्या लोकेसले मी सांग. ");
INSERT INTO ahr_vpl VALUES ("EK12_1","027_12_1","EZK","12","1","1","परमेश्वरनं वचन माले प्राप्त व्हयनं की ");
INSERT INTO ahr_vpl VALUES ("EK12_2","027_12_2","EZK","12","2","2","मानवपुत्रा, तु फितुरी घराणामां राही राहीना शे, त्यासले डोया राहीसनं दखास नही, कान राहीसनं आयकाले येस नही; कारण त्या फितुरी घराणामासला शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK12_3","027_12_3","EZK","12","3","3","त्याकरता हे मानवपुत्रा, तु देशांतर कराले लागनारी सामग्री तयार कर, अनी भरदिवसमां त्यासनादेखत निघी जाय; त्यासनासमोर आपला ठिकान सोडीसनं दुसरी ठिकानले जाय; न जानो हाई त्यासना ध्यानमा तरी यि; त्या तर बंडखोर घराणामासला शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK12_4","027_12_4","EZK","12","4","4","देश सोडी जाशी तवय सामग्री बाहेर काढतसं तशे तु भरदिनमां त्यासनासमोर आपला सामानसुमान बाहेर काढ, अनी देश सोडीसनं निघतसं तशे संध्याकायले त्यासनासमोर निघं. ");
INSERT INTO ahr_vpl VALUES ("EK12_5","027_12_5","EZK","12","5","5","त्यासनासमोर तटले आरपार भोक पाड अनी त्यामाईन आपला सामानसुमान लयी जाय. ");
INSERT INTO ahr_vpl VALUES ("EK12_6","027_12_6","EZK","12","6","6","त्यासनासमोर ते खांदावर लेय अनी अंधार पडना मनजे ते लयी जाय, तु आपला तोंड झाकी ले मनजे जमीन तुले दखावू नही; कारण मी तुले इस्त्राएल घराणानं चिन्हवत नेमेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK12_7","027_12_7","EZK","12","7","7","माले आज्ञा व्हयनी तशे मी करं देशांतराले सामान लयी जातस तशे मी भरदीनमां आपला सामानसुमान बाहेर काढं अनी संध्याकायल मी तटले आरपार छिद्र पाडात; अंधार पडना तवय मी सामान बाहेर लयी गयू अनी त्यासनासमोर ते मी खांदावर लिद. ");
INSERT INTO ahr_vpl VALUES ("EK12_8","027_12_8","EZK","12","8","8","सकासले परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK12_9","027_12_9","EZK","12","9","9","मानवपुत्रा, तु काय करसं, आशे तुले त्या इस्त्राएल घराणानी, त्या फितुरी घराणानी, सांग ना? ");
INSERT INTO ahr_vpl VALUES ("EK12_10","027_12_10","EZK","12","10","10","त्यासले सांग, प्रभु परमेश्वर सांगस की हाई देववचन यरुशेलममासला अधिपतीसले अनी ज्या इस्त्राएल घराणामासला त्या शेतस त्या बठा घराणाले लागू शे. ");
INSERT INTO ahr_vpl VALUES ("EK12_11","027_12_11","EZK","12","11","11","आशे सांग की मी तुमले चिन्हवत शे; मी त्यासले करी दखाडं तसेच त्यासले घडी; त्या हद्दपार व्हतीन; बंदीवासमां जातीन. ");
INSERT INTO ahr_vpl VALUES ("EK12_12","027_12_12","EZK","12","12","12","त्यासमासला सरदार अंधार पडना मनजे खांदावर सामान लिसनं निघी जाई; त्या भितडा फोडीसनं त्यामाईन त्या लयी जातीन; तो आपला तोंड झाकी मनजे त्याना डोयाला जमीन दखावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK12_13","027_12_13","EZK","12","13","13","मी त्यानावर आपलं जाळं टाकसू मनजे तो मना फासामां सापडी; मी त्यासले बाबेलले खास्दयासना देशमां लयी जासू; पण तो देश त्याले दखामां येवावू नही अनी तो तठेच मरी. ");
INSERT INTO ahr_vpl VALUES ("EK12_14","027_12_14","EZK","12","14","14","मी त्याना आजुबाजूना त्याले मदत करनारा अनी त्यानी बठी सेना यासनी दाही देशामा दाणादाण करसू, अनी मी तलवार काढीसनं त्यासना पाठलाग करसू. ");
INSERT INTO ahr_vpl VALUES ("EK12_15","027_12_15","EZK","12","15","15","\"मी त्यासले राष्ट्रसमां इकडे तिकडे करसू, तवय त्यासले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK12_16","027_12_16","EZK","12","16","16","तरी त्यासमासला बाकीनासले तलवार, दुष्काळ अनी मरी हयानापाईन वाचाडसू; मनजे त्या ज्या ज्या राष्ट्रमां जातीन तठे आपल्या अमंगळ कृत्यासना गोष्टया सांगतीन; तवय त्यासले समजी की मी परमेश्वर शे.\" ");
INSERT INTO ahr_vpl VALUES ("EK12_17","027_12_17","EZK","12","17","17","मंग परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK12_18","027_12_18","EZK","12","18","18","मानवपुत्रा, तु थरथर कापीसन अन्न खाय; कंपायमन व्हयीसनं अनी चिंतातूर व्हयीसनं पाणी पेय; ");
INSERT INTO ahr_vpl VALUES ("EK12_19","027_12_19","EZK","12","19","19","अनी हया देशमासला लोकेसले सांग की प्रभू परमेश्वर इस्त्राएल देशमासला यरुशेलम निवासीसनीबारामां सांगस की त्या चिंतातूर व्हयीसनं अन्न खातीन; भयभीत व्हयीसनं पाणी पितीनं; कारण त्या देशमासला रहीवाशासना दुष्टपनातीन त्या भुमीमासला बठ काही नष्ट करीसनं ओसाड करामां येयल शे. ");
INSERT INTO ahr_vpl VALUES ("EK12_20","027_12_20","EZK","12","20","20","बसेल नगर उजाड व्हतीन, जमीन ओसाड व्हयी, मनजे तुमले समजी की परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK12_21","027_12_21","EZK","12","21","21","मंग परमेश्वरनं वचन माले प्राप्त व्हयनं की मानवपुत्रा, ");
INSERT INTO ahr_vpl VALUES ("EK12_22","027_12_22","EZK","12","22","22","दिन लांबी राहीना शेतस, परतेक दृष्टांत निष्फळ व्हयी राहीना शे, हाई जो प्रवाद इस्त्राएल देशमां तुमना तोंडमां पडेल शे त्याना अर्थ काय? ");
INSERT INTO ahr_vpl VALUES ("EK12_23","027_12_23","EZK","12","23","23","मंत त्यासले सांग;‍ प्रभु परमेश्वर आशे सांगस की मी हया म्हणीसना प्रचार बंद करसू अनी ती त्या इस्त्राएलमां परत कोणी बोलावूत नही; त्यासले सांग दिन जोडे येयल शेतस अनी परतेक दृष्टांत प्रतयास येवानं येळ जोडे शे. ");
INSERT INTO ahr_vpl VALUES ("EK12_24","027_12_24","EZK","12","24","24","इस्त्राएल घराणामां यानामोरे निरर्थक दृष्टांत अनी खुश करनारा शकून सांगावूत नही. ");
INSERT INTO ahr_vpl VALUES ("EK12_25","027_12_25","EZK","12","25","25","कारण मी परमेश्वर शे, मी बोली राहीनू शे अनी जे मी बोलसं ते व्हसं; त्याले येळ लागावू नही, कारण प्रभू परमेश्वर सांगस, हे फितुर घराण, मी तुमना कायमां वचन बोलस अनी ते पुरं करसू. ");
INSERT INTO ahr_vpl VALUES ("EK12_26","027_12_26","EZK","12","26","26","परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK12_27","027_12_27","EZK","12","27","27","मानवपुत्रा, दख, इस्त्राएल घराणं सांगी राहीना शे की त्यानी जे दर्शन दख त्याले बराच येळ शे. तो दुरना काळनीबारामां संदेश दी राहीना शे. ");
INSERT INTO ahr_vpl VALUES ("EK12_28","027_12_28","EZK","12","28","28","त्यामुये त्यासले सांग, प्रभु परमेश्वर सांगस की मना कोणतेच वचनले येळ लागावू नही; मी बोलसू ते वचन पुरं व्हयीच जाई आशे परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK13_1","027_13_1","EZK","13","1","1","परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK13_2","027_13_2","EZK","13","2","2","\"मानवपुत्रा,\" संदेश देनारा इस्त्राएलना संदेष्टासना ईरोधमां संदेश देय; ज्या आपला मनतीन संदेश देतसं त्यासले सांग, परमेश्वरनं वचन आयका. ");
INSERT INTO ahr_vpl VALUES ("EK13_3","027_13_3","EZK","13","3","3","प्रभु परमेश्वर सांगस, ज्या मुर्ख संदेष्टा दृष्टांत दखाशिवाय आपला मनतीन संदेश देतसं त्‍या हायहाय करोत. ");
INSERT INTO ahr_vpl VALUES ("EK13_4","027_13_4","EZK","13","4","4","हे इस्त्राएला, तुना संदेष्टा ओसाड जागमां राहाणारा कोल्हासनामायक व्हयी जायेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK13_5","027_13_5","EZK","13","5","5","परमेश्वरना दिनमां युध्दले तोंड देवाले तुमी खिंडारमां उभं राहातसं नही अनी इस्त्राएल घराणाना तट नीट बांधीसनं काढतसं नही. ");
INSERT INTO ahr_vpl VALUES ("EK13_6","027_13_6","EZK","13","6","6","परमेश्वरनी त्याले धाडं नही व्हतं ते हाई परमेश्वरनी वाणी आशे म्हणनारा पोकय दृष्टांत अनी खोटं शकून दखतसं; अनी शकून परमानं घडी अशी आशा त्या धरतसं. ");
INSERT INTO ahr_vpl VALUES ("EK13_7","027_13_7","EZK","13","7","7","तुमीन निरर्थक दृष्टांत दख, खोठा शकून सांग, अनी मी बोलतू नही ते हाई परमेश्वरनं वचन आशे तुमीन म्हणतसं, आशी गोष्ट शे ना? ");
INSERT INTO ahr_vpl VALUES ("EK13_8","027_13_8","EZK","13","8","8","यामुये प्रभू परमेश्वर सांगस, तुमी पोकय गोष्टी सांगतस अनी खोटं दृष्टांत दखतसं, तर दखा, मी तुमले ईरोध करसू आशे प्रभु परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK13_9","027_13_9","EZK","13","9","9","निरर्थक दृष्टांत दखणारा अनी खोटा शकून सांगणारा संदेष्टासवर मना हात चाली; मना लोकेसनी मंडयीमां त्यासले प्रवेश मिळावू नही, इस्त्राएल घराणानी नावनी यादीमां त्यासनी नोंद व्हवावू नही, इस्राएल देशमां त्यासनं जाणं व्हवावू नही; तवय तुमले समजी की मी प्रभू परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK13_10","027_13_10","EZK","13","10","10","हयानं कारण हाईच शे की त्यासनी मना लोकेसले फसाडं शे, शांती नही शे तरी शांती शे आशे त्यासले सांगेल शे; अनी मना लोके तट बांधत व्हतात तवय दख, त्याले ते कच्चा चुनाघाई लिपी राहीना शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK13_11","027_13_11","EZK","13","11","11","त्या कच्चा चुना लिपनारासले सांग, तडा पडतीन, जोरमां पाऊस लागी; अहो मोठया गारासवन, तुमी पडशात; तुफानी वारा सुटी. ");
INSERT INTO ahr_vpl VALUES ("EK13_12","027_13_12","EZK","13","12","12","दख, तो भित पडावर तुमी लिपेल चुना कोठे शे, आशे लोके तुमले बोलावूत नही का?\" ");
INSERT INTO ahr_vpl VALUES ("EK13_13","027_13_13","EZK","13","13","13","हयाकरता प्रभु परमेश्वर सांगस, आपला संतापमुये तुफानी वारा सुटी आशे मी करसू; मना कोपमुये जोरमां पाऊस पडी, नाश व्हवाकरता मना संतापमुये मोठया गारा पडतीन. ");
INSERT INTO ahr_vpl VALUES ("EK13_14","027_13_14","EZK","13","14","14","तुमना कच्‍चा चुना लिपेल भित मी पाडीसनं जमीनदोस्त करसू, मनजे त्याना पाया उघडा पडी; भित पडी अनी तुमी त्यानासंगे नष्ट व्हशात; तवय तुमले समजी की मी प्रभू परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK13_15","027_13_15","EZK","13","15","15","मी मना संतापना कहर त्या भितडासवर अनी त्याले कच्चा चुना लिपनारा लयी यिसू; तवय मी तुमले सांगसू, तट अनी त्याले कच्चा चुना लिपनारा नष्ट व्हयी जायेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK13_16","027_13_16","EZK","13","16","16","ज्या संदेष्टयासनी यरुशेलमनाबारामां संदेश दिदा अनी शांती नही व्हती तरी शांती शे आशे दृष्टांत सांग, त्या तुमी नष्ट व्हयी जायेल शेतस, आशे परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK13_17","027_13_17","EZK","13","17","17","आजुन हे मानवपुत्रा, आपलाच मनतीन संदेश देनारा तुना लोकेसनी पोरीसकडे तोंड करीसनं त्यासना ईरोधमां त्यासले संदेश देय. ");
INSERT INTO ahr_vpl VALUES ("EK13_18","027_13_18","EZK","13","18","18","त्यासले सांग, प्रभु परमेश्वर सांगस, लोकेसले फसाडाकरता ज्या तुमी परतेक कोपराले पट्टया शिसनं लावतसं, अनी येगयेगळा उचा माणुसना डोकाकरता जाया तयार करतसं, त्या तुमी हायहाय म्हणशात, तुमी मना लोकेसले फसाडाकरता, सोतानं जीवना बचाव करतसं. ");
INSERT INTO ahr_vpl VALUES ("EK13_19","027_13_19","EZK","13","19","19","लबाडीले कान देनारा मना लोकेसले लबाडी सांगीसनं, ज्या मराले नही पाहीजेत त्यासले मारीसनं अनी ज्या जगाले नही पाहीजेत त्यासले वाचाडीसनं मुठभर साळकरता अनी भाकरीसना तुकडासकरता तुमी मना लोकेसमोर मना अपमान करेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK13_20","027_13_20","EZK","13","20","20","हयाकरता प्रभु परमेश्वर सांगस, दखा, ज्या पट्टया बांधीसनं तुमीन चिडासपरमानं शिकार करतसं, त्यासनी मी वाट लावसू; मी तुमना बाहूवरतीन त्या पट्टया फाडीसन काढी टाकसू अनी ज्या आत्म्यासना तुमी चिडासपरमानं शिकार करतसं, त्यासले मुक्त करसू. ");
INSERT INTO ahr_vpl VALUES ("EK13_21","027_13_21","EZK","13","21","21","तुमन्या डोकावरना जाळ्याभी मी फाडी टाकसू, तुमना हातमासला मना लोकेसले सोडावसू; त्या यानामोरे तुमना हातघाई भक्ष्य व्हवावूत नही, तवय तुमले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK13_22","027_13_22","EZK","13","22","22","\"कारण ज्या धार्मिकसले मी दुखाडं नही त्याना मन तुमी खोट बोलीसनं दुखाडतसं, अनी दुष्टनी आपला कुकर्मपाईन वळाले नही पाहिजे, आपला जीव वाचावू नही आशे तुमी त्याना हातले बळ देतसं. ");
INSERT INTO ahr_vpl VALUES ("EK13_23","027_13_23","EZK","13","23","23","म्हनीसनं यानामोरे तुमी बिनकामनं भविष्य दखानं अनी तुमनं शकून दखानं बंद व्हयी; अनी मी आपला लोकेसले तुमना हातमाईन सोडावसू, तवय तुमले समजी की मी परमेश्वर शे.\" ");
INSERT INTO ahr_vpl VALUES ("EK14_1","027_14_1","EZK","14","1","1","इस्त्राएलना वडीलसमाईन बराच माणसे मनाकडे यिसनं मनासमोर बसनात. ");
INSERT INTO ahr_vpl VALUES ("EK14_2","027_14_2","EZK","14","2","2","तवय परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK14_3","027_14_3","EZK","14","3","3","मानवपुत्रा, हया लोकेसनी आपला मनमां आपल्या मुरत्या वागाडेल शेतस; त्यासनी आपलं पापजनक अडखळण आपला नजरनासमोर ठेयेल शे; आशे लोकेसले मी तुमले प्रश्न ईचारु दिसू का? ");
INSERT INTO ahr_vpl VALUES ("EK14_4","027_14_4","EZK","14","4","4","हयाकरता त्यासनासंगे बोल, त्यासले सांग की परमेश्वर सांगस, इस्त्राएल घराणामासला जो कोनी आपला मनमां मुर्ती वागाडसं, आपलं पापजनक अडखळण आपली नजरसमोर ठेवसं अनी संदेष्टयासकडे येस त्यासले मना उत्तर त्याना मुर्तीना संख्याना मानतीन भेटी. ");
INSERT INTO ahr_vpl VALUES ("EK14_5","027_14_5","EZK","14","5","5","मी इस्राएल घरानाना मन वर परत कब्जा कराकरता असं करसु, कारण त्यासनी आपली मुर्तीसकरता माले सोडी देयल शे. ");
INSERT INTO ahr_vpl VALUES ("EK14_6","027_14_6","EZK","14","6","6","तरीबी इस्त्राएल घराणाले सांग, प्रभु परमेश्वर सांगस, मांगे फिरा, आपल्या मुरत्यासपाईन फिरा अनी आपला बठा अमंगळ कर्मसपाईन तोंड फिरावा. ");
INSERT INTO ahr_vpl VALUES ("EK14_7","027_14_7","EZK","14","7","7","इस्त्राएलना घराणामासला अनी इस्राएलमां वस्ती करीसनं उपरीमासला जो कोनी मनापाईन येगळा व्हयीसनं आपला ह्दयमां मुर्ती वागाडसं, आपली पापनी ठोकर आपली नजरनीसमोर ठेवसं अनी माले प्रश्न ईचाराकरता संदेष्टयासकडे येस; त्याले मी सोता योग्य वाटी ते उत्तर दिसू; ");
INSERT INTO ahr_vpl VALUES ("EK14_8","027_14_8","EZK","14","8","8","मी त्यानापाईन तोंड फिराई लिसु; मी त्याले एक उदाहरण बना़डसु, मी त्याले आपली प्रजानी मंडळीमातीन काढी टाकसु, अनी तुमले समजी कि मीच प्रभु परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK14_9","027_14_9","EZK","14","9","9","“जर एखादा संदेष्टा धोकामां पडीसनं संदेश देत व्हयी तर समजानं की मी त्याले धोकामां पाडेल शे, मी मना हात त्यानावर उगारसू अनी मना लोक ज्या इस्त्राएल त्यासमाईन त्यासना नाश करसू. ");
INSERT INTO ahr_vpl VALUES ("EK14_10","027_14_10","EZK","14","10","10","प्रश्न करनारासना जशे दोष तशेच त्या संदेष्टासना दोष; त्या दोनी आपला दोषना फळ भोगतीन; ");
INSERT INTO ahr_vpl VALUES ("EK14_11","027_14_11","EZK","14","11","11","मनजे इस्त्राएल घराण मनापाईन बहकीसनं जावावून नही अनी आपला सर्व पातकसघाई सोताले ईटाळवू नही; तर त्या मना लोके व्हतीन अनी मी त्यासना देव व्हसू;” आशे परमेश्वर म्हणसं. ");
INSERT INTO ahr_vpl VALUES ("EK14_12","027_14_12","EZK","14","12","12","तवय परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK14_13","027_14_13","EZK","14","13","13","“मानवपुत्रा,” “एखादा देशनी ईस्वासघात करीसनं मनाईरोधमां पाप करं व्हयीते मी त्यानावर आपला हात चालाडसू, त्याना अन्नना आधार तोडसू; देशमां दुष्काळ पाडसू; अनी त्यामाईन माणुस अनी पशुसना नाश करसू. ");
INSERT INTO ahr_vpl VALUES ("EK14_14","027_14_14","EZK","14","14","14","तवय त्यामां नोहा, दानीएल अनी ईयोब हया तिन्ही राहीनात तरी बस व्हयनं; त्या आपला धार्मिकतामुये आपला तेवढा जीव वाचाडतीन अश परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK14_15","027_14_15","EZK","14","15","15","“मी देशमां हिंस्र पशू धाडीसनं तो उद्ध्वंस्त करं अनी त्या पशुमुये कोणी त्यामाईन येत जात नही एवढा तो निर्जन करी टाक. ");
INSERT INTO ahr_vpl VALUES ("EK14_16","027_14_16","EZK","14","16","16","तर प्रभु परमेश्वर सांगस, मनी जीवनी शपथ, त्यामां त्या तिन्ही राहीनात तरी त्यासले पोर्‍यासना अनी पोरीसना बचाव करता येवावू नही; त्यासना मात्र निभाव लागी, पण बठा देश नष्ट व्हयी. ");
INSERT INTO ahr_vpl VALUES ("EK14_17","027_14_17","EZK","14","17","17","“मी देशवर तलवार आणीसनं सांग की, अरे तलवार देशवार फिर, अनी तिनी मनुष्यले अनी पशुसना नाश करी टाक. ");
INSERT INTO ahr_vpl VALUES ("EK14_18","027_14_18","EZK","14","18","18","तर प्रभु परमेश्वर सांगस, मनी जीवनी शपथ, त्यामां त्या तिन्ही राहीनात तरी त्यासले पोर्‍यासना अनी पोरीसना बचाव करता येवावू नही; त्यासना मात्र निभाव लागी, ");
INSERT INTO ahr_vpl VALUES ("EK14_19","027_14_19","EZK","14","19","19","“मी त्या देशवर महामारी धाडी अनी त्यामाईन लोके अनी पशू यासना नाश कराकरता रंगतना रुपमां मना संतापना वर्षाव करी टाक. ");
INSERT INTO ahr_vpl VALUES ("EK14_20","027_14_20","EZK","14","20","20","तर प्रभु परमेश्वर सांगस, त्यामां नोहा, दानीएल अनी ईयोब हया राहीनात तरी त्यासले पोर्‍यासना अनी पोरीसना बचाव करता येवावू नही; त्या आपला धार्मिकतामुये फार तर आपला जीव वाचाडतीन.” ");
INSERT INTO ahr_vpl VALUES ("EK14_21","027_14_21","EZK","14","21","21","मंग मी तलवार, दुष्काळ, हिंस्र पशू अनी मरी हया मना चारी उग्र शासन यरुशेलममासला मनुष्य अनी पशू हयासना नाश कराकरता त्यासवर धाडसू; तवय त्यासना निभाव कशे लागी, आशे प्रभू परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK14_22","027_14_22","EZK","14","22","22","तरी दख, त्यानामां अवशेष राहातीन; त्या अवशिष्ट पोर्‍यासले अनी पोरीसले बाहेर आणतीन, दख, त्या तुनाकडे येतीन, तुमी त्यासना मार्ग अनी त्यासना कर्म दखशात; तवय मी यरुशेलमवर आणेल अनर्थ, त्यासवर आणेल बठा प्रसंग यानाबारामां तुमी सांत्वन पावशात. ");
INSERT INTO ahr_vpl VALUES ("EK14_23","027_14_23","EZK","14","23","23","तुमी त्यासना मार्ग अनी त्यासना कर्म दखशात तवय त्यामुये तुमनं सांत्वन व्हयी, अनी मी जे त्यासनं बठ काही करेल शे त्यामासलं काहीबी विनाकारण करेल नही शे हाई तुमले समजी, आशे प्रभु परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK15_1","027_15_1","EZK","15","1","1","परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK15_2","027_15_2","EZK","15","2","2","“मानवपुत्र, जंगलमासला कोणता बी झाडनी फांदीनी काठीपेक्षा द्राक्षना वेलनी काठी कशी चांगली शे? ");
INSERT INTO ahr_vpl VALUES ("EK15_3","027_15_3","EZK","15","3","3","तिनं लाकूड कोणी कामले लावसं का? भांडा टांगी ठेवाले त्यान्या खुटया बनाडतसं का? ");
INSERT INTO ahr_vpl VALUES ("EK15_4","027_15_4","EZK","15","4","4","दख, ती आगमां सरपन म्हनीसनं टाकतसं, आगघाई तिना दोन्ही टोके जाळी टाकात अनी मधला भाग भस्म व्हयनाते ते कोणता काममां पडी? ");
INSERT INTO ahr_vpl VALUES ("EK15_5","027_15_5","EZK","15","5","5","दख ती शाबूत राहास तवय ती कोणताच कामले उपयोगमां पडसं नही, तर मंग आगघाई जाळीसनं तिना कोळसा व्हवावर तो कोणता काममा पडी?” ");
INSERT INTO ahr_vpl VALUES ("EK15_6","027_15_6","EZK","15","6","6","हयाकरता प्रभु परमेश्वर सांगस, वनवृक्षमासला द्राक्ष येलना आगमां सरपन म्हनीसनं टाकतसं त्यापरमानं यरुशेलमना निवासीसले आगमां टाकसू. ");
INSERT INTO ahr_vpl VALUES ("EK15_7","027_15_7","EZK","15","7","7","मी त्यासकडे तोंड फिरायी लिसू; त्या आगमाईन बाहेर पडनात तरी आग त्यासले खायी टाकी; मी त्यासकडे तोंड फिरायी लिसू; तवय तुमले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK15_8","027_15_8","EZK","15","8","8","त्यासनी ईस्वासघात करेल शे म्हनीसनं मी देश विराण करसू आशे प्रभू परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK16_1","027_16_1","EZK","16","1","1","परत माले परमेश्वरनं वचन प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK16_2","027_16_2","EZK","16","2","2","“मानवपुत्रा,” “यरुशेलमनं अमंगळ कृत्य त्यासना ध्यानमां अनी देय. ");
INSERT INTO ahr_vpl VALUES ("EK16_3","027_16_3","EZK","16","3","3","आशे सांग, प्रभु परमेश्वर यरूशलेमले सांगस, “तुना जन्म अनी उत्पती हया कनान देशमासला शेतस; तुना बाप अम्मोरी अनी तुनी माय हित्तीण व्हती. ");
INSERT INTO ahr_vpl VALUES ("EK16_4","027_16_4","EZK","16","4","4","तुना जन्मनाबारामां सांग तर तुना जन्म व्हयनं तवय तुनं नाळ कापी नही, तुले पाणीघाई धईसनं स्वच्छ करं नही, तुनं आंगले मीठ लावं नही अनी तुले बाळंतनमां गुंडाळं नही. ");
INSERT INTO ahr_vpl VALUES ("EK16_5","027_16_5","EZK","16","5","5","तुनी करुणा यिसनं यामासलं कोणतबी काम करानं आशी तुनावर कोणीच दयादृष्टी व्हयनी नही; तर तुनं जन्म व्हयनं तवय तुले अमंगळ समजीसनं वावरमां टाकी देयेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK16_6","027_16_6","EZK","16","6","6","“मी तुना जवयतीन जायी राहींनतू तवय तुले तुना रंगतमां लोळतांना दख, तवय मी तुले बोलनू; तु आपला रंगतमां लोळी राहीना शे तरी बी जीवत राहाय; आशेच मी तुले बोलनू. ");
INSERT INTO ahr_vpl VALUES ("EK16_7","027_16_7","EZK","16","7","7","वावरमासलं बीज वाढीसनं शंभर पट व्हसं तशी मी तुनी वृध्दी करी; तु वाढीसनं उची व्हयनी, तु भलती सुंदर व्हयनी, तुले ऊर फुटनं, तुना केस वाढनात तरी तु उघडीनागडी व्हती. ");
INSERT INTO ahr_vpl VALUES ("EK16_8","027_16_8","EZK","16","8","8","“मी तुना जवयतीन जायी राहींनतू तवय मी तुले दखनू, तवय ती येळ तुनी प्रेमविकासनी व्हती; तवय मी तुनावर पदर टाकीसनं तुनी नग्नता झाकी; प्रभु परमेश्वर सांगस, तवय मी शपथ लिसनं तुनासंगे करार करं तु मनी व्हयनी. ");
INSERT INTO ahr_vpl VALUES ("EK16_9","027_16_9","EZK","16","9","9","“मी तुनी पानीघाई आंघोळ करी, तुनावरना रंगत धयी काढ अनी तेलमां तुले मळी टाक. ");
INSERT INTO ahr_vpl VALUES ("EK16_10","027_16_10","EZK","16","10","10","तुले वेलबुट्टीना कपडा घालात, चांगला चामडानं चपला घालात, तुना डोकाले उत्तम तागना कपडाघाई गुंडाळं, अनी तुले रेशमी ओढणी पांघरी. ");
INSERT INTO ahr_vpl VALUES ("EK16_11","027_16_11","EZK","16","11","11","मी तुले दागिनासघाई सजाडं, तुना हातमा बांगडया घाल्यात अनी गळामां हार घालात. ");
INSERT INTO ahr_vpl VALUES ("EK16_12","027_16_12","EZK","16","12","12","मी तुना नाकमां नथ घाली, कानमां बाळया घाल्यात, तुना डोकाले उत्तम शिरोभुषण घालात. ");
INSERT INTO ahr_vpl VALUES ("EK16_13","027_16_13","EZK","16","13","13","तु सोनारुप्यासघाई नटली; तुना पेहराव उत्तम ताग रेशीम अनी जरतारी यासना व्हता; तुले जेवनले सपीठ, मध अनी तेल हया राहेत; तु अती सुंदर व्हती अनी राजवैभवले पोहंची जायेल व्हती. ");
INSERT INTO ahr_vpl VALUES ("EK16_14","027_16_14","EZK","16","14","14","तुनी सुंदरतामुये तुनी किर्ती राष्ट्रमां पसरनी; कारण मी तुले देयल तेजघाई तुनी सुंदरता अप्रतिम व्हयनी; आशे‍ प्रभू परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK16_15","027_16_15","EZK","16","15","15","“तु तुना सौंदर्यावर भरवसा ठेयीसनं आपली किर्तीना जोरवर शिंदळकी करी, येवा जावाबरोबर शिंदळकीना सपाटा तु चालाडं; तुना सौंदर्य त्यासले लुटाले सापडनं. ");
INSERT INTO ahr_vpl VALUES ("EK16_16","027_16_16","EZK","16","16","16","तु आपला कपडा लिसनं रंगबेरंगी उच्च स्थान तुनाकरता सजाडं अनी कधी व्हयनं नही आशी शिंदळकी त्यासवर करी. ");
INSERT INTO ahr_vpl VALUES ("EK16_17","027_16_17","EZK","16","17","17","मी देयल सोनरुपासनं शोभवंत दागिना लिसनं तु त्यासन्या पुरुषमुरत्या कर्‍यात अनी त्यानासंगे शिंदळकी करी. ");
INSERT INTO ahr_vpl VALUES ("EK16_18","027_16_18","EZK","16","18","18","तु आपली वेलबुट्टीना कपडा लिसनं त्यास घालात, मी देयेल तेलना अनी धुपना तु त्याले नैवेदय दखाडं. ");
INSERT INTO ahr_vpl VALUES ("EK16_19","027_16_19","EZK","16","19","19","मी भाकर, सपीठ, तेल अनी मध हाई तुले देयेत अनी तुले खावाडेत; ती बी तु त्यानामोरे सुगंध म्हनीसनं अर्पण करे; हाई आशे घडसं आशे प्रभू परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK16_20","027_16_20","EZK","16","20","20","“आजुन तुले मनापाईन पोर्‍या अनी पोरी व्हयन्यात, ती तु लिसनं त्यासले खाई टाकाकरता बळी म्हनीसनं अर्पण करं; हया तुन्या शिंदळक्या तुले पुरेशा व्हयन्यात नही. ");
INSERT INTO ahr_vpl VALUES ("EK16_21","027_16_21","EZK","16","21","21","म्हनीसनं मना पोर्‍यासले मारीसनं त्यासन्या मुरतीसकरता आगमां होम करं का? ");
INSERT INTO ahr_vpl VALUES ("EK16_22","027_16_22","EZK","16","22","22","हया बठया अमंगळ कृत्य अनी शिंदळक्या करतांना तु दाखलपणमां उघडीनागडी व्हती तवय तु आपला रंगतमां लोळी राहींनती यानी तुले कधीच आठवण व्हनी नही.” ");
INSERT INTO ahr_vpl VALUES ("EK16_23","027_16_23","EZK","16","23","23","तु हाई दुष्कर्म करावर प्रभु परमेश्वर सांगस, तुले धिक्कार असो! तुले धिक्कार असो! आशे‍ व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK16_24","027_16_24","EZK","16","24","24","तु तुनाकरता कमानदार घर बांधी टाकं, रस्ता रस्तासमां तु आपलाकरता उच्च स्थान बनाडात. ");
INSERT INTO ahr_vpl VALUES ("EK16_25","027_16_25","EZK","16","25","25","तु रस्तासना नाका नाकासवर आपला उच्च स्थान बनाडी टाकात; आपली सुंदरता भ्रष्ट करी, वनात - गयात सर्वासनामोरे आपला पाय पसारीसनं मनसोक्त व्यभिचार करं; ");
INSERT INTO ahr_vpl VALUES ("EK16_26","027_16_26","EZK","16","26","26","मोठा आंगना तुना शेजारना मिसरी लोके यासनासंगे तु व्यभिचार करं; माले चिडावाकरता तुनी मनसोक्त शिंदळकी करी. ");
INSERT INTO ahr_vpl VALUES ("EK16_27","027_16_27","EZK","16","27","27","“तर मंग दख, मी तुनावर हात उगारीसनं तुनं कायमनं अन्न कमी करं अनी ज्यासले तुनी शिंदळकी लज्जास्पद वाटसं त्या तुना व्देष करनारा पलिष्टीसन्या पोरीसना हातमां तुले देतीन. ");
INSERT INTO ahr_vpl VALUES ("EK16_28","027_16_28","EZK","16","28","28","“तुनी तृप्ती म्हनीसनं कवयच व्हसं नही, त्या करता तु अश्शुर्‍यासनीसंगेबी व्यभिचार करं; हा, त्यासनासंगे तुनी व्यभिचार करं तरी तुनी तृप्ती व्हयनी नही. ");
INSERT INTO ahr_vpl VALUES ("EK16_29","027_16_29","EZK","16","29","29","व्यापार्‍यासना मनजे खास्दयासना देश तठेपावोत तुनी मनसोक्त शिंदळकी चालाडी तरीबी त्यानाघाई तुनी तृप्ती व्हसं नही.” ");
INSERT INTO ahr_vpl VALUES ("EK16_30","027_16_30","EZK","16","30","30","प्रभु परमेश्वर सांगस, “तु निर्लज्ज वेश्याना कामनामायक हाई बठ करं; तुनं मन कितलं दुर्बल शे! ");
INSERT INTO ahr_vpl VALUES ("EK16_31","027_16_31","EZK","16","31","31","नाका नाकासवर तुनी आपलाकरता कमानदार घरं बांधातं; अनी रस्ता-रस्तासवर तुनी उच्च स्थान बनाडात; पन तुनी व्यभिचारना वेतननी पर्वा करी नही; आठे तुनी वेशानी रीत सोडी. ");
INSERT INTO ahr_vpl VALUES ("EK16_32","027_16_32","EZK","16","32","32","तु तर नवराले सोडीसनं दुसरा माणुसनीसंगे सहवास करनारानीमायक शे. ");
INSERT INTO ahr_vpl VALUES ("EK16_33","027_16_33","EZK","16","33","33","लोके वेशाले पैसा देतसं पन तु उलट आपला ‍बठा‍ प्रेमीसले पैसा देसं! त्यासनी चारीमेरतीन यिसनं तुनासंगे व्यभिचार कराले पाहीजे म्हनीसनं तु त्यासले लालूस दखाडसं. ");
INSERT INTO ahr_vpl VALUES ("EK16_34","027_16_34","EZK","16","34","34","तुनी व्यभिचारनी रीत दुसर्‍या बायासनी उलट शे, एखादा व्यभिचारी माणसु तुनामांगे येस नही, तुले कोणी पैसा देस नही, तर तु उलट त्यासले पैसा देस; हाई तुनं वागनं येगळं शे.” ");
INSERT INTO ahr_vpl VALUES ("EK16_35","027_16_35","EZK","16","35","35","त्याकरता आये वेश्या, परमेश्वरनं वचन आयकं, ");
INSERT INTO ahr_vpl VALUES ("EK16_36","027_16_36","EZK","16","36","36","प्रभु परमेश्वर सांगस, तु आपला पैसा उडाई टाकं, आपला प्रेमीसनीसंगे व्यभिचार करीसनं आपली लाज दखाडी; तु आपली मुर्तीनासंगे अमंगळ कृत्य करात अनी आपला पोर्‍यासना रंगत त्यासले अर्पण करं. ");
INSERT INTO ahr_vpl VALUES ("EK16_37","027_16_37","EZK","16","37","37","त्याकरता हाई दख, ज्यासले तु खुश करं, प्रेमपात्र अनी व्देषपात्र आशे ज्या तुना बठा प्रेमी, त्यासले मी चारीमेरतीन तुना ईरोधमां जमा करसूं; त्यासनामोरे तुनी लाज उघडी करसू मनजे त्या तुनी बठी लाज दखतीन. ");
INSERT INTO ahr_vpl VALUES ("EK16_38","027_16_38","EZK","16","38","38","व्यभीचारणी अनी रक्तपात करनार्‍या बाया यासनं न्याय करतसं तशे मी तुनं न्याय करसू अनी ईर्ष्यातीन अनी क्रोधतीन मी तुनं रक्तपात करसूं. ");
INSERT INTO ahr_vpl VALUES ("EK16_39","027_16_39","EZK","16","39","39","मी तुले त्यासना हातमां दिसु, मनजे त्या तुना कमानदार घरं नष्ट करतीन, तुना उच्च स्थान पाडी टाकतीन, तुना कपडा हिसकाईसनं अनी तुना दाग दागिना काढीसनं तुले उघडी बिनकपडासना करतीन. ");
INSERT INTO ahr_vpl VALUES ("EK16_40","027_16_40","EZK","16","40","40","त्या तुना ईरोधमां मंडयीले जमा करीसनं तुले दगडमार करतीन अनी आपल्या तलवारीसघाई तुले भोसकतीन. ");
INSERT INTO ahr_vpl VALUES ("EK16_41","027_16_41","EZK","16","41","41","त्या तुना घरं आगघाई जायी टाकतीन अनी बर्‍याच बायासनीदेखत तुले शिक्षा करतीन; हाई परकारतीन तुनी शिंदळकी बंद करतीन, अनी यानामोरे तु कोणले पैसा देवावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK16_42","027_16_42","EZK","16","42","42","तवय तुनावरना मना संताप शांत करसू, तुनाईषयी मनी ईर्ष्या कमी व्हयी, मी शांत व्हसू, परत संताप करावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK16_43","027_16_43","EZK","16","43","43","तु आपला तरूणपणना दिनना आठवण ठेवसी, हाई बठ करीसनं तुनी माले चिडावं, म्हनीसनं दख, प्रभु परमेश्वर सांगस, तुनं अनाचारनं प्रतिफळ मी तुनं माथी लावसू; मनजे तुन्या दुसर्‍या बठया अमंगळ कृत्यासमां आजुन पापना भर तु टाकावू नही, ");
INSERT INTO ahr_vpl VALUES ("EK16_44","027_16_44","EZK","16","44","44","दख, म्हण सांगणारा बठा तुनाबारामां सांगतीन जशी माय तशी पोर, ");
INSERT INTO ahr_vpl VALUES ("EK16_45","027_16_45","EZK","16","45","45","आपला नवरानी अनी पोर्‍यासना धिक्कार करनारी तुनी माय तिनी तु पोर; आपला नवरानी अनी पोर्‍यासना धिक्कार करनार्‍या तुन्या बहीणी त्यासनी तु बहीण; तुनी माय व्हती हित्तीण अनी बाप व्हता अमोरी. ");
INSERT INTO ahr_vpl VALUES ("EK16_46","027_16_46","EZK","16","46","46","“तुनी डावी बाजुले तुन्या पोरीसनीसंगे राहानारी शोमरोन ती तुनी मोठी बहीण अनी तुनी उजवी बाजुले आपल्या पोरीसनीसंगे राहानारी सदोम हाई तुनी धाकली बहीण. ");
INSERT INTO ahr_vpl VALUES ("EK16_47","027_16_47","EZK","16","47","47","तु त्यासना मार्गतीन अनी त्यासना अमंगळ कृत्यासपरमानं थोडी चालनी आशे नही, तर तु आपला बठा आचरण त्यानापेक्षा भ्रष्ट करं. ");
INSERT INTO ahr_vpl VALUES ("EK16_48","027_16_48","EZK","16","48","48","“प्रभु परमेश्वर सांगस, मनी जीवनी शपथ, तु अनी तुन्या पोरीसनी जशे वर्तन करं तशे तुनी बहीण सदोम हिनी अनी तीन्या पोरीसनी करं नही. ");
INSERT INTO ahr_vpl VALUES ("EK16_49","027_16_49","EZK","16","49","49","दख, तुनी पोर सदोम हिनं पाप यापरमानं व्हतं; गर्व, अन्ननी विपुलता अनी आयीष आराम हाई तिले अनी तिन्या पोरीसले व्हती; दरीद्री अनी गरजवंतसले यासले तिनी हात दिद् नही. ");
INSERT INTO ahr_vpl VALUES ("EK16_50","027_16_50","EZK","16","50","50","त्यासनी अहंकारी व्हयीसनं मनासमोर अमंगळ कृत्य करात, ती दखीसनं त्यासले हाकली दिद्. ");
INSERT INTO ahr_vpl VALUES ("EK16_51","027_16_51","EZK","16","51","51","“शोमरोनीने तर तुनापेक्षा आरधा पापबी करात नही; तु आपला अमंगळ कृत्य त्यानापेक्षा जास्त करात, तु करेल अमंगळ कृत्यासना मानतीन तुन्या बहीणी निर्दोष ठरन्यात. ");
INSERT INTO ahr_vpl VALUES ("EK16_52","027_16_52","EZK","16","52","52","तु आपल्या बहीणीसले आपलापेक्षा निर्दोष ठरावं यानी तुले लाज वाटो; तु त्यानापेक्षा घोर पाप करामुये तुना मानतीन त्यासले निर्दोष समजाले पाहिजे; तुन्या बहीणी जास्त नीतीमान शेतस हाई तुनी दखाडं,‍ म्हनीसनं तु लज्जीत अनी फजीत होवो.” ");
INSERT INTO ahr_vpl VALUES ("EK16_53","027_16_53","EZK","16","53","53","मी सदोम अनी तिन्या पोरीसना, अनी शोमरोन अनी तिन्या पोरीसना, अनी त्यासनामां तुना धरी लयी जायेल लोकेसलेबी लयी यिसू. ");
INSERT INTO ahr_vpl VALUES ("EK16_54","027_16_54","EZK","16","54","54","मनजे तुले लाजना काळींबा लागी, ज्या तुना बठया कृत्यासघाई त्यासना मनले समाधान प्राप्त व्हयनं त्यासनाबारामां तु लज्जित व्हशी. ");
INSERT INTO ahr_vpl VALUES ("EK16_55","027_16_55","EZK","16","55","55","तुन्या बहीणी, सदोम अनी तिन्या पोरी परत आपली पहीली दशामां येतीन. शोमरोन अनी तिन्या पोरी परत आपली दशामां येतीन; तु अनी तुन्या पोरी परत आपली पहीली दशामां येतीन. ");
INSERT INTO ahr_vpl VALUES ("EK16_56","027_16_56","EZK","16","56","56","तु तुना तोरामां व्हती तवय; तुनी बहीण सदोम हिनं नावसुध्दा तुनं तोंडमां नही व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK16_57","027_16_57","EZK","16","57","57","अरामी बाया अनी तिना आसपासना बठा अनी तुले तुच्छ माननर्‍या पलिष्टी बाया यासनी तुनी अप्रतिष्ठा करी, त्या येळले तुनी दुष्टता प्रकट व्हयनी, तशी आजपावोत प्रकट व्हयनी नही. ");
INSERT INTO ahr_vpl VALUES ("EK16_58","027_16_58","EZK","16","58","58","तु तुना दुष्कर्मना अनी अमंगळ कृत्यासना फळ भोगी राहीनी शे, आशे परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK16_59","027_16_59","EZK","16","59","59","प्रभु परमेश्वर सांगस, “तु सोता वाहेल शपथले तुच्छ मानीसनं आपला करार मोडं; तु जशे करं तशे मी तुनं करसू. ");
INSERT INTO ahr_vpl VALUES ("EK16_60","027_16_60","EZK","16","60","60","तरी मी तुना तरुणपणमां तुनासंगे करेल करारनी आठवन करीसनं तुनासंगे सर्वकायनं करार करसू. ");
INSERT INTO ahr_vpl VALUES ("EK16_61","027_16_61","EZK","16","61","61","तु तुन्या मोठल्या बहीणी अनी धाकल्या बहीणी यासले आपलं करशी तवय तु तुन्या आचरणनं आठवन करीसनं लज्जित व्हशी. अनी त्या तुनी करेल करारमासल्या नही व्हतीन तरीबी त्या पोरी म्हनीसनं दिसू. ");
INSERT INTO ahr_vpl VALUES ("EK16_62","027_16_62","EZK","16","62","62","मी तुनासंगे मना करार स्थापन करसू तवय तुले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK16_63","027_16_63","EZK","16","63","63","तु जे बठ करं त्यानी मी क्षमा करसू, मनजे तुला त्यानी आठवण व्हयीसनं तु लज्जित व्हशी अनी अप्रतिष्ठामुये तु परत आपलं तोंड उघडावू नही,” आशे‍ प्रभु परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK17_1","027_17_1","EZK","17","1","1","परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK17_2","027_17_2","EZK","17","2","2","“मानवपुत्रा,” इस्त्राएल घराणाले कोडे घाल; हाई दृष्टांत कथन कर; ");
INSERT INTO ahr_vpl VALUES ("EK17_3","027_17_3","EZK","17","3","3","त्यासले आशे सांग, प्रभु परमेश्वर सांगस, मोठला पखसना, लांब पिसारासना अनी चित्रविचित्र पिसासना आशे एक मोठ गरुड लबानोन पर्वतवर ऊना; त्यानी गंधसरुनी शेंडाकडली एक फांदी तोडी लिदी. ");
INSERT INTO ahr_vpl VALUES ("EK17_4","027_17_4","EZK","17","4","4","त्यानी त्यामासली अगदी वरनी फांदी तोडीसनं व्यापार्‍यासना देशमां लयी गया अनी सौदा करनारासना एक शहरमां लायी दिदी. ");
INSERT INTO ahr_vpl VALUES ("EK17_5","027_17_5","EZK","17","5","5","त्यानी देशमासला बाकीना बीवारा लिसनं ती पिकावू जमीनमां पैयरी, वाळुज लावतसं तशे ते बराच पानीनाजोडे लावं. ");
INSERT INTO ahr_vpl VALUES ("EK17_6","027_17_6","EZK","17","6","6","ते वाढीसनं त्यानी आखूड पन पसरेल अशी द्राक्षलता व्हयनी; तिन्या फांदया गरुडकडे झुकेल राहीसनं तिना मुळा त्यानाखाल जायेल व्हतात; ती वाढीसनं मोठा द्राक्ष व्हयनात; तिले फाटा फुटनात अनी पाला ऊना. ");
INSERT INTO ahr_vpl VALUES ("EK17_7","027_17_7","EZK","17","7","7","दुसरा एक मोठा गरुड व्हता, त्याले बराच पिसे व्हतात अनी मोठला पखं व्हतात; दख, त्यानी लायेल वाफासमां आपलाले पानी मिळाले पाहिजे म्हनीसनं त्या द्राक्षीनी आपला मुळा त्यानाकडे वाकाडात अनी आपला फाटा त्यानाकडे झुकाडात. ");
INSERT INTO ahr_vpl VALUES ("EK17_8","027_17_8","EZK","17","8","8","त्या रोपसले फाटा फुटीसनं त्याला फळ यावाले पाहिजे अनी भव्य द्राक्षी यावले पाहिजे म्हनीसनं तो एक सुपीक मळामां बराच पानीजोडे लायेल व्हतं. ");
INSERT INTO ahr_vpl VALUES ("EK17_9","027_17_9","EZK","17","9","9","“प्रभु परमेश्‍वर सांगस, सांग बरं, ती जीव धरी का? ती सुकी जावाले पाहिजे म्हनीसनं तिले मुळनासंगे उपाडीसनं तिना फय तोडी टाकावूत नही का? तिना बठा पाला सुकाई जातीन; तिना मुळा उपडाले जास्त ताकदनी नाहिते बराच लोके लागावूत नही. ");
INSERT INTO ahr_vpl VALUES ("EK17_10","027_17_10","EZK","17","10","10","दख, तिनी लावणी व्हयनी तरी जीव धरी का? पुर्वकडला वारा तिले लागना मनजे ती सुकावू नही का? ती ज्या वाफामां वाढनी तठेच ती मरी जाई.” ");
INSERT INTO ahr_vpl VALUES ("EK17_11","027_17_11","EZK","17","11","11","परत परमेश्वरनं वचन माले प्राप्त व्हयनं की ");
INSERT INTO ahr_vpl VALUES ("EK17_12","027_17_12","EZK","17","12","12","“या बंडखोर घराणाले सांग, या गोष्टी काय शेतस हाई तुमले समजत नही का? त्यासले सांग की दखा, बाबेलना राजानी यरुशेलममां यिसनं तिना राजा अनी तिना सरदार यासले धरं अनी आपलाकडे बाबेल आठे आणं; ");
INSERT INTO ahr_vpl VALUES ("EK17_13","027_17_13","EZK","17","13","13","तवय त्यानी राजवंशमासला एक माणसुले निवाडीसनं त्यानासंगे करार करं अनी त्यानाकडतीन प्रतिज्ञा करी लिदी; त्या राष्ट्र नीच व्हावाले पाहिजे; त्यानी आपल डोकं वर करानं नही; जर त्यानां करार त्यानी पाय तर ते कायम राहावाले पाहिजे, म्हनीसनं त्यानी बठा कर्ता माणससले बी लयी गया. ");
INSERT INTO ahr_vpl VALUES ("EK17_14","027_17_14","EZK","17","14","14","हयानाकरता की त्या राष्ट्र नीच राहावाले पाहीजे, त्यानी आपलं डोकं वर कराले नही पाहीजे, पन त्याना करार पाळावर ते कायम राहावाले पाहीजे. ");
INSERT INTO ahr_vpl VALUES ("EK17_15","027_17_15","EZK","17","15","15","पण त्यानी त्यासनाईरोधमां फितुरी करीसनं मिसर देशनी आपलाले घोडे अनी बराच लोके दयावाले पाहिजे म्हनीसनं त्यानाकडे आपला जासुद धाडात. त्याले यश भेटी का? ज्यानी आशा गोष्टि कर्‍यात तो निभावेल का? त्यानी करार मोडेल शे तरी बी तो निभावले का? ");
INSERT INTO ahr_vpl VALUES ("EK17_16","027_17_16","EZK","17","16","16","“प्रभू परमेश्वर सांगस, मनी जीवनी शपथ, ज्यानी त्याले राजा करं, ज्यानासंगे करेल आणभाक त्यानी तुच्छ मानी, ज्यानं करार त्यानी मोडं, त्या राजानं निवासस्थानमां, बाबेलमां तो मरी. ");
INSERT INTO ahr_vpl VALUES ("EK17_17","027_17_17","EZK","17","17","17","जवय बराच जणसना फडशा उडावाकरता शत्रु मोरचे लावतीन अनी बुरुज बांधतीन तवय युध्दना येऴले फारोना मोठा सैनिक अनी बराच लोके संगे लिसन त्यानी कुमक करता येवावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK17_18","027_17_18","EZK","17","18","18","त्यानी शपथ तुच्छ मानीसनं करार मोडं; दख, त्यानी हातवर हात मारं तरी त्यानी हाई बठ करं; तो निभावनार नही.” ");
INSERT INTO ahr_vpl VALUES ("EK17_19","027_17_19","EZK","17","19","19","त्याकरता परमेश्वर सांगस, “मनी जीवनी शपथ, त्यानी मनी प्रतिज्ञा तुच्छ मानी; त्यानी मना करार मोडं यानं प्रतिफळ मी त्याना डोकावर टाकसू. ");
INSERT INTO ahr_vpl VALUES ("EK17_20","027_17_20","EZK","17","20","20","मी मना जाळं त्यानावर टाकसू; तो मना फासामां सापडी; मी त्याले बाबेलमां लयी जासू; त्यानी मनासंगे करेल ईस्वासघातबारामां तठे मी त्यानी झडती लिसू. ");
INSERT INTO ahr_vpl VALUES ("EK17_21","027_17_21","EZK","17","21","21","त्याना बठा सैन्यमासला पयनारा त्या बठा तलवारघाई पडतीन; ज्या उरतीन त्यासनी चारीमेर दाणादाण व्हयी; तवय तुमले समजी की मी परमेश्वर हाई बोलनू शे.” ");
INSERT INTO ahr_vpl VALUES ("EK17_22","027_17_22","EZK","17","22","22","प्रभु परमेश्वर सांगस, मी उची गंधसरुना शेंडावरनी एक फांदी तोडीसनं ती लावसू, त्यानी वरनी कोवळी फांदीमासली एक लिसनं ती एक मोठा उचा पर्वतवर लावसू. ");
INSERT INTO ahr_vpl VALUES ("EK17_23","027_17_23","EZK","17","23","23","मी इस्त्राएलना उचा पर्वतवर ती लावसू; तिले फाटा फुटतीन, फळे येतीन, तिना उत्तम गंधसरु व्हयी; मनजे मंग त्यानाखाल बठया चिडासनी जाती राहातीन, त्याना फाटासना सावलीमां त्या राहातीन. ");
INSERT INTO ahr_vpl VALUES ("EK17_24","027_17_24","EZK","17","24","24","जंगलमासला बठा झाडसले कयी की मी परमेश्वर उचा झाडसले नीच करेल शे अनी नीचासले उचा करेल शे, हिरवा झाडसले सुकाडेल शे अनी सुकेल झाडसले फलद्रूप करेल शे; मी परमेश्वर हाई बोलनू शे अनी मी हाई करेल बी शे. ");
INSERT INTO ahr_vpl VALUES ("EK18_1","027_18_1","EZK","18","1","1","परमेश्वरनं वचन माले प्राप्त व्हयनं की ");
INSERT INTO ahr_vpl VALUES ("EK18_2","027_18_2","EZK","18","2","2","बापनी आंबट द्राक्ष खादात अनी पोर्‍यासना दात आंबनात, हाई म्हण तुमी इस्त्राएल देशमां वापरतसं ती का? ");
INSERT INTO ahr_vpl VALUES ("EK18_3","027_18_3","EZK","18","3","3","“प्रभु परमेश्वर सांगस, मनी जीवनी शपथ,” हाई म्हण इस्त्राएलमां यानामोरे तुमी वापरानं नही. ");
INSERT INTO ahr_vpl VALUES ("EK18_4","027_18_4","EZK","18","4","4","दख, बठा जीव मना शेतस, बापना जीव तशे पोर्‍यानं जीव मना शे, जो जीव आत्मा पाप करसं तो मरी. ");
INSERT INTO ahr_vpl VALUES ("EK18_5","027_18_5","EZK","18","5","5","धार्मिक माणसे कोणले म्हणशात जो न्यायतीन अनी धर्मतीन वागस, ");
INSERT INTO ahr_vpl VALUES ("EK18_6","027_18_6","EZK","18","6","6","डोंगरवर जेवण करतसं नही, इस्त्राएल घराणासना मुर्तीसकडे डोया लावतसं नही, आपली शेजारनी बाईले भ्रष्ट करसं नही,‍ पाळी येयल बाईऩाजोडे जात नही. ");
INSERT INTO ahr_vpl VALUES ("EK18_7","027_18_7","EZK","18","7","7","कोणवर जुलूम करस नही, कर्जदारनं गहाण त्याले परत करसं, कोणले लूटसं नही, ज्या भुक्या शेतस त्यासले जेवण देस अनी ज्या उघडा शेतस त्यासले कपडा देतसं, ");
INSERT INTO ahr_vpl VALUES ("EK18_8","027_18_8","EZK","18","8","8","वाढीदिढी करसं नही, व्याज लेस नही, वाईटपाईन आपला हात आवरसं, माणुस माणुसमां सत्य निर्णय करसं. ");
INSERT INTO ahr_vpl VALUES ("EK18_9","027_18_9","EZK","18","9","9","मना नियमपरमानं चालसं, अनी मना निर्णय पाळीसनं सत्यतीन वागसं; तोच धार्मिक शे; तो नक्की वाची, आशे प्रभू परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK18_10","027_18_10","EZK","18","10","10","“तरी बी त्याले बलत्कारी अनी खुनशी पोर्‍या व्हयना. अनी बापनी हयापैकी कोणतच काम कर नही जर पोर्‍यानी त्यामासलं एकबी काम करं. ");
INSERT INTO ahr_vpl VALUES ("EK18_11","027_18_11","EZK","18","11","11","त्यानी डोंगरवर जेवण करं, आपली शेजारनी बाईले भ्रष्ट करं, ");
INSERT INTO ahr_vpl VALUES ("EK18_12","027_18_12","EZK","18","12","12","लाचार अनी दुबळा यासवर जुलूम करं, एखादाले लुटं, कर्जदारनं गहाण त्याले परत करं नही, मुर्तीकडे दख, अमंगळ कृत्य करं, ");
INSERT INTO ahr_vpl VALUES ("EK18_13","027_18_13","EZK","18","13","13","वाढीदिढी करी, व्याज लिद्, मंग आशे माणूस वाची का? तो वाचावू नही; त्यानी हाई बठा अमंगळ कृत्ये करेल शेतस; तो नक्की मरी, त्यानी करेल रक्तपात त्यानावरच उलटी. ");
INSERT INTO ahr_vpl VALUES ("EK18_14","027_18_14","EZK","18","14","14","परत दख, त्याले आशे पोर्‍या व्हयना की बाप जे पाप करसं ती तो दखसं, तरी ते दखीसनं तो सोता तशे करसं नही, ");
INSERT INTO ahr_vpl VALUES ("EK18_15","027_18_15","EZK","18","15","15","तो डोंगरवर जेवण करसं नही, इस्त्राएल घराणानी मुर्तीकडे दखसं नही, आपली शेजारनी बाईले भ्रष्ट करसं नही, ");
INSERT INTO ahr_vpl VALUES ("EK18_16","027_18_16","EZK","18","16","16","कोणवर जुलूम करसं नही, कर्जदारनं गहाण आडावसं नही, कोणले लुटसं नही, ज्या भुक्या शेतस त्यासले अन्न देस अनी ज्या उघडा शेतस त्यासले घालाले कपडा देस, ");
INSERT INTO ahr_vpl VALUES ("EK18_17","027_18_17","EZK","18","17","17","गरीबसले हानी करापाईन आपला हात आवरी धरसं, वाडीदिढी करसं नही, व्याज लेस नही, मना निर्णय पायस, मना नियमपरमानं चालसं, तो आपला बापना पापमुये मरावू नही, तो नक्की वाची. ");
INSERT INTO ahr_vpl VALUES ("EK18_18","027_18_18","EZK","18","18","18","त्याना बापनी बारामां सांगशात ते त्यानी जुलूम करं, आपला भाऊले लुटं अनी आपला लोकेसवर अत्याचार करं, त्यामुये दख, तो आपला अधर्मतीन मरी. ");
INSERT INTO ahr_vpl VALUES ("EK18_19","027_18_19","EZK","18","19","19","“तरी तुमी म्हणतसं, बापना पापना भार पोर्‍यानी का बर वाहावानं नही? हाई दख, पोर्‍या न्यायतीन अनी धर्मतीन वागना, त्यानी मना बठा नियम पाळीसनं त्यापरमानं वर्तन करं तर तो नक्की वाची. ");
INSERT INTO ahr_vpl VALUES ("EK18_20","027_18_20","EZK","18","20","20","जो जीवआत्मा पाप करी तोच मरी, पोर्‍या बापना पापना भार वाहावू नही, अनी आपला बाप आपला पोर्‍याना पापना भार वाहावू नही, धार्मिकले त्याना धार्मिकतीन फळ भेटी; दुष्टले त्याना दुष्टतीन फळ भेटी, ");
INSERT INTO ahr_vpl VALUES ("EK18_21","027_18_21","EZK","18","21","21","“तरीबी दुष्ट त्यानी करेल बठा पापसपाईन फिरीसनं मना बठा नियम पाळी अनी तो नीतीतीन अनी धर्मतीन वागना तर तो नक्की वाची, मरावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK18_22","027_18_22","EZK","18","22","22","त्यानी करेल कोणतच पाप त्याना हिशोबमां धरता येवावू नही, त्यानी करेल धार्मिकतीन तो वाची, ");
INSERT INTO ahr_vpl VALUES ("EK18_23","027_18_23","EZK","18","23","23","प्रभु परमेश्वर सांगस, दुष्ट मरावर माले आनंद व्हसं का? त्यानी आपला मार्ग सोडीसनं वाचाले पाहीजे यावरतीन माले आनंद व्हसं ना? ");
INSERT INTO ahr_vpl VALUES ("EK18_24","027_18_24","EZK","18","24","24","“तरी बी धार्मिक आपली धार्मिकता सोडीसनं दुष्कर्म कराले लागना अनी अधार्मिकना बठा अमंगळ आचरणपरमानं वागाले लागना, तर तो वाची का? त्यानी करेल बठी धार्मिकता हिशोबमां धरता येवावू नही, त्यानी करेल भ्रष्टाचार अनी त्यानी करेल पाप यामुये तो मरी. ");
INSERT INTO ahr_vpl VALUES ("EK18_25","027_18_25","EZK","18","25","25","“तरी तुमी सांगतसं, प्रभुना मार्ग न्यायी नही, हे इस्त्राएल घराणा, आयकी लेय, मना मार्ग न्यायी नही का? तुमनाच मार्ग न्यायी नही शेतस, आशे नही का? ");
INSERT INTO ahr_vpl VALUES ("EK18_26","027_18_26","EZK","18","26","26","एखादा धार्मिक आपली धार्मिकता सोडीसनं दुष्कर्म करसं अनी त्यानामुये मरसं तर तो आपला करेल दुष्कर्मतीन मरसं. ");
INSERT INTO ahr_vpl VALUES ("EK18_27","027_18_27","EZK","18","27","27","दुर्जन त्यानी करेल आपला दुष्टाईपाईन दूर व्हयीसनं नीतीतीन अनी धार्मिकतीन वागी तर तो आपला जीव वाचाडी. ");
INSERT INTO ahr_vpl VALUES ("EK18_28","027_18_28","EZK","18","28","28","तो आपला करेल बठा पाप ध्यानमां आणीसनं वळी तर तो नक्की वाची, मरावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK18_29","027_18_29","EZK","18","29","29","तरीबी इस्त्राएल घराणं‍ म्हणसं, देवना मार्ग न्यायी नही, हे इस्राएल घराणा, मना मार्ग न्यायी नहीत का? तुमनाच मार्ग न्यायी नहीत, हाई नही का? ");
INSERT INTO ahr_vpl VALUES ("EK18_30","027_18_30","EZK","18","30","30","“प्रभु परमेश्वर सांगस, हे इस्त्राएल घराणा, मी तुमना परतेकना ज्याना त्याना मार्गपरमानं न्याय करसू, तुमी फिरा, आपला बठा पापपाईन मांगे फिरा, मनजे तुमना अधर्म तुमले अडथळा व्हावाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("EK18_31","027_18_31","EZK","18","31","31","तुमी आचरण करेल बठा दुराचार टाकी दया; तुमनामां नवीन ह्दय अनी नवीन आत्मा स्थापन करा; हे इस्त्राएल घराणा तुमीन का बरं मरतस? ");
INSERT INTO ahr_vpl VALUES ("EK18_32","027_18_32","EZK","18","32","32","कारण प्रभु परमेश्वर सांगस, मरनारासना मृत्युमुये माले आनंद व्हस नही; तर मांगे फिरा अनी जीवत राहा.” ");
INSERT INTO ahr_vpl VALUES ("EK19_1","027_19_1","EZK","19","1","1","आते तु इस्त्राएलसना सरदारसकरता विलाप कर, ");
INSERT INTO ahr_vpl VALUES ("EK19_2","027_19_2","EZK","19","2","2","तु आशे सांग, तुनी माय कोण? ती सिंहीण व्हती, ती सिंहसमां राहात व्हती, ती तरुण सिंहसमां आपला बच्चासना देखभाल करं; ");
INSERT INTO ahr_vpl VALUES ("EK19_3","027_19_3","EZK","19","3","3","तिनी आपला बच्चासपैकी एकले वाढावं, ते वाढीसनं तरुण सिंह व्हयना अनी शिकार कराले शिकना, तो माणुसले खावाले लागना. ");
INSERT INTO ahr_vpl VALUES ("EK19_4","027_19_4","EZK","19","4","4","राष्ट्रसनी त्यानाबारामां आयकं; त्यासनी करेल खड्डामां तो आडकी गया; त्यासनी त्याले वेसण घालीसनं लयी गयात. ");
INSERT INTO ahr_vpl VALUES ("EK19_5","027_19_5","EZK","19","5","5","आपली आशा भग्न व्हयीसनं नष्ट व्हयनी हाई तिनी दख तवय तिनी आपला दुसरा एक बच्चा लिसनं त्याले वाढावं अनी त्याले तरुण्यावस्थामां आणं. ");
INSERT INTO ahr_vpl VALUES ("EK19_6","027_19_6","EZK","19","6","6","तो सिंहसमां हिराफिराले लागना. तरुण सिंह व्हयना अनी शिकार कराले सिकना, तो माणसेसले भक्ष कराले लागना. ");
INSERT INTO ahr_vpl VALUES ("EK19_7","027_19_7","EZK","19","7","7","त्यानी त्यासना वाडा उद्ध्वस्त करात अनी त्यासना नगर उजाड करात; त्यानी गर्जनाना शब्दघाई देश अनी त्यामासला सर्वा काही ओसाड व्हयी गये. ");
INSERT INTO ahr_vpl VALUES ("EK19_8","027_19_8","EZK","19","8","8","आजुबाजूना येगयेगळा प्रांतमासला राष्ट्र त्यानावर उठनात; त्यासनी त्यानावर आपला जाळा टाकात; त्यासनी करेल खड्डामां तो आडकी गया. ");
INSERT INTO ahr_vpl VALUES ("EK19_9","027_19_9","EZK","19","9","9","त्यासनी त्याले वेसण घालीसनं पिंजरामां कोंड अनी बाबेलना राजाकडे लयी गयात. इस्त्राएलना डोंगरवर त्याना शब्द परत आयकाले येवाले नको म्हनीसनं त्याले दरीमां टाकी दिदी. ");
INSERT INTO ahr_vpl VALUES ("EK19_10","027_19_10","EZK","19","10","10","तुनी माय तुनी आबादानीमां पानीनाजोडे लायेल द्राक्षीनामायक व्हती; पानीना विपुलतामुये ती सफळ व्हयीसनं तिले बराच फाटा फुटनात. ");
INSERT INTO ahr_vpl VALUES ("EK19_11","027_19_11","EZK","19","11","11","अधिपतीसना राजवेत्रे तयार व्हतीन आशे मजबूत फाटा वनात; त्या उचा वाढीसनं ढगना वर गयात अनी बराच फाटासहीत ती उंचीमां मोठया दखाई राहींनत्यात. ");
INSERT INTO ahr_vpl VALUES ("EK19_12","027_19_12","EZK","19","12","12","तवय तिनावर संताप व्हयीसनं तिले उपाडीसनं जमीनवर पाडामां ऊनं; पुर्वकडला वारा वाहीसनं तिना फळ करपनात, तिना मजबुत फाटा मोडीसनं सुकाई गयात; आगघाई त्या खाक व्हयी गयात. ");
INSERT INTO ahr_vpl VALUES ("EK19_13","027_19_13","EZK","19","13","13","आते तिले जंगलमां रुक्ष अनी निर्जल जागवर लायेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK19_14","027_19_14","EZK","19","14","14","तिना शाखासना फाटासमाईन आग निघीसनं त्यानी तिना फये खाई टाकेल शेतस; आते अधिकार चालाडनारासना राजदंड व्हयी आशे एकबी मजबूत फाटा राहीनात नही; हाई विलापगीत शे अनी विलापकरता राही. ");
INSERT INTO ahr_vpl VALUES ("EK20_1","027_20_1","EZK","20","1","1","सातवा वरीसना पाचवा महीनाना दशमीले आशे व्हयनं की इस्त्राएलना काही वडील प्रश्न ईचाराकरता यिसनं मनासमोर बसनात, ");
INSERT INTO ahr_vpl VALUES ("EK20_2","027_20_2","EZK","20","2","2","तवय परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK20_3","027_20_3","EZK","20","3","3","\"मानवपुत्रा,\" \"इस्त्राएलना वडीलसनीसंगे बोल, त्यासले सांग, प्रभु परमेश्वर आशे सांगस, तुमी माले प्रश्न ईचाराले येयल शेतस का? प्रभु परमेश्वर सांगस, मनी जीवनी शपथ, मी तुमले माले प्रश्न ईचारु देवावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK20_4","027_20_4","EZK","20","4","4","\"तु त्यासनं न्याय करानं नही का? मानवपुत्रा, तु त्यासना न्याय करानं नही का? त्यासले त्यासना वडीलसना अमंगळ कृत्य विधित करं. ");
INSERT INTO ahr_vpl VALUES ("EK20_5","027_20_5","EZK","20","5","5","त्यासले सांग प्रभु परमेश्वर सांगस, ज्या दिन मी इस्राएलले निवाडी लिद्, याकोब वंशकडे हात करीसनं मी शपथ लिदी, मिसर देशमां मी त्यासले प्रकट व्हयनू; हात उचलीसनं मी त्यासले शपथपुर्वक सांग की मी परमेश्वर तुमना देव शे. ");
INSERT INTO ahr_vpl VALUES ("EK20_6","027_20_6","EZK","20","6","6","त्या दिन मी हात उचलीसनं, त्यासनासंगे शपथ लिदी की, मी तुमले मिसर देशमाईन काढिसनं दुधमधना प्रवाह वाहातसं आशे तुमनाकरता दखेल देशमां लयी यिसु; तो देश बठा देशसमां मुकूटमणी शे. ");
INSERT INTO ahr_vpl VALUES ("EK20_7","027_20_7","EZK","20","7","7","तवय मी त्यासले सांग, तुमी सर्वासनी तुमनी नजरमां प्रिय आशा अमंगळ वस्तु फेकी देवानं अनी मिसर देशन्या मुर्तीसघाई सोताले विटाळ व्हवू देवानं नही; मी परमेश्वर तुमना देव शे. ");
INSERT INTO ahr_vpl VALUES ("EK20_8","027_20_8","EZK","20","8","8","तरीबी त्यासनी मनासंगे फितुरी करी अनी मना आयकनात नही; त्यासनी नजरमां त्यासले प्रिय आशा तठेन्या अमंगळ वस्तु फेकात नही; मिसर देशमासल्या मुर्त्याबी त्यासनी सोडयात नही; तवय मिसर देशमां त्यासनावर मनी संतापनी वृष्टी व्हावाले पाहिजे;‍ मना कोप त्यासनावर परा व्हावाले पाहिजे, आशे मी सांग. ");
INSERT INTO ahr_vpl VALUES ("EK20_9","027_20_9","EZK","20","9","9","तरी मना नावकरता, ज्या राष्ट्रासमां त्या राही राहींनतात त्यासनासमोर आपलं नावनं आपमान व्हावाले नको, म्हनीसनं मी हाई काम करं; मी त्यासले मिसर देशमाईन काढीसनं त्या राष्ट्रासनासमोर त्यासले प्रकट व्हयनु. ");
INSERT INTO ahr_vpl VALUES ("EK20_10","027_20_10","EZK","20","10","10","\"मी त्यासले मिसर देशमाईन काढीसनं जंगलमां आणं. ");
INSERT INTO ahr_vpl VALUES ("EK20_11","027_20_11","EZK","20","11","11","मी त्यासले नियम लायी दिद्, मना निर्णय त्यासले दखाडी दिदात, हाई जो कोणी पाळी तो‍ त्यापरमानं वाची. ");
INSERT INTO ahr_vpl VALUES ("EK20_12","027_20_12","EZK","20","12","12","आजुन त्यासनामां अनी मनामां चिन्ह व्हावाकरता मी त्यासले आपलं शाब्बाथ दिद; ते हयानाकरता की मी परमेश्वर त्यासले पवित्र करं आशे त्यासले समजाले पाहिजे. ");
INSERT INTO ahr_vpl VALUES ("EK20_13","027_20_13","EZK","20","13","13","तरीबी रानमां इस्त्राएल घराणानं मनासंगे फितुरी करी, ज्यानं पाळामुये माणुस वाचसं; त्या मना नियमपरमानं चालनात नही, मना निर्णय त्यासनी टाकी दिदात अनी मना शाब्बाथ भलत भ्रष्ट करं; तवय रानमां त्यासनावर आपली क्रोधनी वृष्टी करीसनं त्यासनं नाश करानं आशे मी सांग. ");
INSERT INTO ahr_vpl VALUES ("EK20_14","027_20_14","EZK","20","14","14","तरीबी ज्या राष्ट्रासनादेखत मी त्यासले बाहेर आणं त्यासनादेखत आपलं नावनं आपमान व्हावाले नही पाहिजे म्हनीसनं आपलं नावकरता आशी कृती करी. ");
INSERT INTO ahr_vpl VALUES ("EK20_15","027_20_15","EZK","20","15","15","आजुन मी हात उचलीसनं रानमां अशी शपथ लिदी की दुधमधनं प्रवाह जठे वाही राहीना शेतस अनी जो बठा देशना मुकूटमणी शे आशे देश मी त्यासले देयल व्हतुं, तठे मी त्यासले आणाऊ नही. ");
INSERT INTO ahr_vpl VALUES ("EK20_16","027_20_16","EZK","20","16","16","कारण त्यासनं मन त्यासना मुर्तीसनीसंगे जुडामुये त्यासनी मना निर्णय टाकी दिदात; त्या मना नियमपरमानं चालनात नही, अनी त्यासनी मनी शपथ भ्रष्ट करी. ");
INSERT INTO ahr_vpl VALUES ("EK20_17","027_20_17","EZK","20","17","17","\"तरीबी मी त्यासनावर कृपादृष्टी करीसनं त्यासनी दया करी, रानमां त्यासना नाश करं नही, त्यासना पुरा शेवट करं नही. ");
INSERT INTO ahr_vpl VALUES ("EK20_18","027_20_18","EZK","20","18","18","तशेच रानमां त्यासना वंशसले बोलनू, तुमी आपला वडीलसना नियमपरमानं चालू नका, त्यासना निर्णयले अनुसरानं नही, अनी त्यासन्या मुरत्यासघाई सोताले ईटाळू नका; ");
INSERT INTO ahr_vpl VALUES ("EK20_19","027_20_19","EZK","20","19","19","मी परमेश्वर तुमना देव शे, मना नियमले धरीसनं चाला; आपला निर्णय पायीसनं त्यापरमानं वागा. ");
INSERT INTO ahr_vpl VALUES ("EK20_20","027_20_20","EZK","20","20","20","मना शाब्बाथ पवित्र माना, मनजे ते तुमनामां अनी मनामां चिन्ह व्हतीन अनी तुमले समजी की मी परमेश्वर तुमना देव शे. ");
INSERT INTO ahr_vpl VALUES ("EK20_21","027_20_21","EZK","20","21","21","\"तरीबी त्या वंशनीबी मनासंगे फितुरी करी; जे पायामुये माणुस वाचसं, त्या मना नियमपरमानं चालनात नही; त्यासनी मना निर्णय टाकी दिदात, मना शाब्बाथ त्यासनी भ्रष्ट करं; तवय रानमां त्यासनावर मनी क्रोधनी वृष्टी करीसनं त्यासनावर मना कोप पुरा व्हावाले पाहिजे आशे मी बोलनू. ");
INSERT INTO ahr_vpl VALUES ("EK20_22","027_20_22","EZK","20","22","22","तरीबी ज्या राष्ट्रासनादेखत मी त्यासले बाहेर आणं त्यासनादेखत आपलं नावनं आपमान व्हावाले नही पाहिजे म्हनीसनं मी आपला हात आवरा; आपलं नावकरता आशी कृती करी. ");
INSERT INTO ahr_vpl VALUES ("EK20_23","027_20_23","EZK","20","23","23","आजून त्यासनी राष्ट्रासामां पांगापांग करसूं अनी‍ त्यासले देशोधडीले लावसू आशी प्रतिज्ञाबी मी रानमां हात उचलीसनं करी. ");
INSERT INTO ahr_vpl VALUES ("EK20_24","027_20_24","EZK","20","24","24","कारण त्यासनी मना निर्णय पायात नही; मना नियम टाकी दिदात, मना शब्बाथ भ्रष्ट करी टाक; अनी त्यासनी नजर त्यासन्या वडीलसनी मुरतीसकडे लागनं. ");
INSERT INTO ahr_vpl VALUES ("EK20_25","027_20_25","EZK","20","25","25","\"तवय जे चांगल नही आशे नियम मी त्यासले दिदात, ज्यानाघाई त्या वाचावूत नही आशे निर्णय त्यासले दिदात. ");
INSERT INTO ahr_vpl VALUES ("EK20_26","027_20_26","EZK","20","26","26","मी त्यासनी नासधुस करामुये त्यासले आशे कळी की मी परमेश्वर शे; मी त्यासले त्यासना यज्ञ अर्पणनाबारामां आशे भ्रष्ट करी टाक की त्यासनी गर्भमाईन निघेल पहिलं आगमां होमं करी टाक. ");
INSERT INTO ahr_vpl VALUES ("EK20_27","027_20_27","EZK","20","27","27","\"म्हनीसनं हे मानवपुत्रा, इस्त्राएलना घराणानीसंगे बोल, अनी हाई सांग; प्रभु परमेश्वर आशे सांगसं, परत फिरीसनं तुना पुर्वजसनी मनासंगे ईस्वासघात करीसनं मना अपमान करं; ते आशे. ");
INSERT INTO ahr_vpl VALUES ("EK20_28","027_20_28","EZK","20","28","28","मी मना हात उचलीसनं शपथ लिसनं देयल देशमां त्यासले आणं तवय त्यासनी उचा टेकडया अनी परतेक दाट सावलीना झाड दखीसनं तठे आपला यज्ञबलीना अर्पण करात; तठे राग यि आशे अर्पण त्यासनी करात; तठे त्यासनी सुवासिक धुप जाळात अनी तठेच त्यासनी आपला पेयार्पण वाही टाकात. ");
INSERT INTO ahr_vpl VALUES ("EK20_29","027_20_29","EZK","20","29","29","तवय मी त्यासले बोलनू; तुमी ज्या उचा ठिकानले जातसं ते कसानं शे? आजपावोत त्याले बामा (उंचवट) आशे बोलत ऊना शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK20_30","027_20_30","EZK","20","30","30","म्हनीसनं इस्त्राएल घराणाले सांग, प्रभु परमेश्वर सांगस, तुमी आपला बापना मार्गले लागीसनं सोताले विटाळंतसं, अनी अनाचार करीसनं त्यासन्या अमंगळ वस्तुसनामांगे लागतसं. ");
INSERT INTO ahr_vpl VALUES ("EK20_31","027_20_31","EZK","20","31","31","अनी आपला अर्पण वाहीसनं अनी आपला पोर्‍यासना आगमां होम करीसनं आपल्या बठया मूर्तीसकडतीन आजपावोत सोताले विटाळत ऊना शेतस; आशे राहीसनं बी मी तुमले प्रश्न ईचारु दिसू का? प्रभु परमेश्वर सांगस, मनी जीवनी शपथ मी तुमले प्रश्न ईचारू देवावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK20_32","027_20_32","EZK","20","32","32","तुमी म्हनतसं, राष्ट्रासमां, देश देशमासला लोकेसपरमानं आम्ही दगडनी मुर्तीनी पुजा करसतू; हाई जे तुमी मनमा तरंग उडावतसं ते सिध्दीस जावावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK20_33","027_20_33","EZK","20","33","33","\"प्रभु परमेश्वर सांगस, मनी जीवनी शपथ, मी शक्तीशाली बाहूघाई, उगारेल हातघाई अनी कोपवृष्टी करीसनं तुम्हनावर राज्य करसू. ");
INSERT INTO ahr_vpl VALUES ("EK20_34","027_20_34","EZK","20","34","34","मी प्रबळ बाहूघाई, उगारेल हातघाई अनी कोपवृष्टी करीसनं तुमले राष्ट्रसमाईन लयी यिसु; ज्या देशमां तुमनी पांगापांग व्हयेल शे तठेतून मी तुमले एकजागे करसू. ");
INSERT INTO ahr_vpl VALUES ("EK20_35","027_20_35","EZK","20","35","35","अनी मी तुमले राष्ट्रसना रानमाईन आणीसनं तठे तुमनासंगे समक्ष वाद करसू. ");
INSERT INTO ahr_vpl VALUES ("EK20_36","027_20_36","EZK","20","36","36","मी मिसर देशना रानमां तुमना वाडवडीलसनीसंगे वाद करं तशे तुमनासंगे वाद करसू, आशे प्रभु परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK20_37","027_20_37","EZK","20","37","37","\"तुमले काठीखालतीन चालाडीसनं करारबध्द करसू; ");
INSERT INTO ahr_vpl VALUES ("EK20_38","027_20_38","EZK","20","38","38","बंडखोर अनी मनासंगे फितुरी करनारा यासले मी तुमनापाईन येगळं करसू; त्या थोडाच येळ वस्ती करीसनं शेतस त्या देशमाईन त्यासले बाहेर लयी जासु; पन इस्राएल देशमां त्यासनं येणं व्हवावू नही; मनजे तुमले समजी की मी परमेश्वर शे.\" ");
INSERT INTO ahr_vpl VALUES ("EK20_39","027_20_39","EZK","20","39","39","म्हनीसनं प्रभु परमेश्वर आशे‍ म्हणसं, हे इस्राएलना घराणा, जा, तुले पाहिजे त्या मुरत्यासनी पुजा कर; पन पुढे तुमी नक्कीच म्हना आयकशात, अनी आपला अर्पणघाई अनी मुरतीसघाई म्हनं पवित्र नावले बट्टा लावावूत नही. ");
INSERT INTO ahr_vpl VALUES ("EK20_40","027_20_40","EZK","20","40","40","तर तुमी मना पवित्र पर्वतवर, इस्राएलना उचा पर्वतवर, इस्राएलन सर्वा घराणा, त्यामासला बठा जण, आपला देशमां मनी सेवा करतीन, आशे प्रभु परमेश्वर सांगस, तठे मी त्यासना अंगीकार करसू; तठे तुमनाजोडे अर्पण, तुमना श्रेष्ठ अर्पण, समर्पित करेल बठया वस्तु मी मांगसू. ");
INSERT INTO ahr_vpl VALUES ("EK20_41","027_20_41","EZK","20","41","41","मी तुमले राष्ट्रसमाईन बाहेर आणसू अनी ज्या देशमां तुमनी पांगापांग व्हयेल शे तठेतीन तुमले जमा करसू; तवय मी सुंगधपरमानं तुमनं स्विकार करसू, अनी तुमनामां मनी पवित्रता विदेशी राष्ट्रसमां प्रकट व्हयी. ");
INSERT INTO ahr_vpl VALUES ("EK20_42","027_20_42","EZK","20","42","42","जो इस्राएल देश मी हात वर करीसनं तुमना वडीलले दिद् तठे मी तुमले आणसू तवय तुमले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK20_43","027_20_43","EZK","20","43","43","ज्य तुमना मार्गतीन अनी ज्या तुमना बठा कर्मतीन तुमी सोताले विटाळेल शे, त्यासनी तुमले आठवन यि अनी ज्या तुमी सर्व दुष्कर्म करात‍ त्यामुये तुमी सोताले वीट मानशात. ");
INSERT INTO ahr_vpl VALUES ("EK20_44","027_20_44","EZK","20","44","44","हे इस्राएल घराणा, प्रभु परमेश्वर सांगस, तुमना कुकर्मपरमानं, तुमना भ्रष्ट कृत्यासपरमानं नही ते मना नावकरता मी तुमनामां करनी करसू, तवय तुमले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK20_45","027_20_45","EZK","20","45","45","परमेश्वरनं वचन माले परत प्राप्त व्हयनं; ");
INSERT INTO ahr_vpl VALUES ("EK20_46","027_20_46","EZK","20","46","46","मानवपुत्रा, दक्षिणकडे आपलं तोंड कर, दक्षिणकडे आपली वाणीनं ओघ वाहू देय अनी दक्षिणनां मैदानमां वननीबारामां संदेश देय. ");
INSERT INTO ahr_vpl VALUES ("EK20_47","027_20_47","EZK","20","47","47","दक्षिणना वनले सांग, परमेश्वरनं वचन आयक, प्रभु परमेश्वर सांगस, दख, मी तुनामां आग पेटाडसू, तो तुनामासला परतेक हिरवा झाड अनी परतेक शुष्क झाड भस्म करी; धगधगनारा जाळं ईझावू नही अनी तिनामुये दक्षिणना अनी उत्तरना बठा तोंड पोळतीन. ");
INSERT INTO ahr_vpl VALUES ("EK20_48","027_20_48","EZK","20","48","48","मी परमेश्वरनी तो अग्नी पेटाडेल शे आशे बठा माणसे समजतीन; तो ईझावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK20_49","027_20_49","EZK","20","49","49","मी सांग, अहा! प्रभु परमेश्वर; लोके मनाबारामां सांगतस, हाऊ दृष्टांत सांगनारा नही का? ");
INSERT INTO ahr_vpl VALUES ("EK21_1","027_21_1","EZK","21","1","1","परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK21_2","027_21_2","EZK","21","2","2","\"मानवपुत्रा,\" \"यरुशेलमकडे आपल तोंड करं; पवित्रस्थानकडे आपली वाणीनी ओघ वाहू देय अनी इस्राएल देशना ईरोधमां संदेश देय. ");
INSERT INTO ahr_vpl VALUES ("EK21_3","027_21_3","EZK","21","3","3","इस्राएल देशले सांग, परमेश्वर आशे सांगस की, दख, मी तुनाईरोधमां शे, मी मनी तलवार म्यानमाईन काढीसनं तुनामासला धार्मिक अनी दुष्कर्मी यासले छेदी टाकसू. ");
INSERT INTO ahr_vpl VALUES ("EK21_4","027_21_4","EZK","21","4","4","मी तुनामासला धार्मिक अनी दुष्कर्मी यासले छेदी टाकसू; म्हनीसन मनी तलवार म्यानमाईन निघीसनं दक्षिण अनी उत्तरकडला सर्व मानवजातवर चाली; ");
INSERT INTO ahr_vpl VALUES ("EK21_5","027_21_5","EZK","21","5","5","तवय बठी मानवजातले समजी की मी परमेश्वरनी आपली तलवार म्यानमाईन उपसेल शे; ती परत त्यामा जावावू नही. ");
INSERT INTO ahr_vpl VALUES ("EK21_6","027_21_6","EZK","21","6","6","म्हनीसनं हे मानवपुत्रा, कंबर मोडी आशे उसासा टाक,‍ त्यासनासमोर कष्टना उसासा टाक; ");
INSERT INTO ahr_vpl VALUES ("EK21_7","027_21_7","EZK","21","7","7","उसासा का बर टाकी राहीना शे आशे कोनी तुले ईचारी तवय त्यासले सांग की, हाई वार्ता ध्यानमां यि राहीनी शे म्हनीसनं; तवय बठासना मन खची, सर्वासना हात निर्बल व्हतीन, सर्वासना उत्साह कमी व्हयी, बठासना गुडघामां पानी व्हयी, दख, ती प्रत्ययास यि राहीनी शे, त्यामा खास घडणार शे, आशे प्रभु परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK21_8","027_21_8","EZK","21","8","8","परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK21_9","027_21_9","EZK","21","9","9","\"मानवपुत्रा,\" संदेश दिसनं सांग, परमेश्वर आशे सांगस, तलवार, पानी देयेल, पाजेल तलवार! ");
INSERT INTO ahr_vpl VALUES ("EK21_10","027_21_10","EZK","21","10","10","वध कराले पाहिजे म्हनीसनं तिले पानी देयेल शे, ती ईजपरमानं चमकाले पाहिजे म्हनीसनं ती पाजेल शे, मना पोर्‍याना राजवेत्र बठा दंडले तुच्छ लेखसं आशे शे म्हनीसनं तुमी आनंद करतसं का? ");
INSERT INTO ahr_vpl VALUES ("EK21_11","027_21_11","EZK","21","11","11","ती हातमां धरता येवाले पाहिजे म्हनीसनं पाजाले देयेल शे, तलवार वध करनारानी हातमां देवानी शे म्हनीसनं तिले पानी देयेल शे, ती पाजेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK21_12","027_21_12","EZK","21","12","12","मानवपुत्रा, वरड, आक्रोश कर, कारण ती मना लोकेसवर चालेल शे; ती इस्त्राएलना बठा सरदारसवर चालेल शे; मना लोकेसनीसंगे त्याबी तलवारघाई पडेल शेतस, म्हनीसनं आपलं ऊर बडवं. ");
INSERT INTO ahr_vpl VALUES ("EK21_13","027_21_13","EZK","21","13","13","कारण त्याले परिक्षामां टाकेल शे, अनी तुच्छ माननारा राववेत्र टिकावुत नहीते कशे, आशे प्रभु परमेश्वर सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK21_14","027_21_14","EZK","21","14","14","मानवपुत्रा तु संदेश दिसनं टाळया वाजाड मनजे तलवारले, भोसकनारी तलवारले, तिप्पट जोर यि, त्याले घेरनारी तलवार, थोरसलेबी भोसकनारी व्हयी. ");
INSERT INTO ahr_vpl VALUES ("EK21_15","027_21_15","EZK","21","15","15","त्यासना ह्दय गलित व्हावाले पाहिजे, अनी त्यासना पाया पराकाष्ठतीन लटपटाले पाहिजे म्हनीसनं मी त्यासनी बठी वेशीवर घात करनारी तलवार चालाडेल शे; अहो! ती ईजपरमानं चमकाले पाहिजे आशे तिले करेल शे, ती माराकरता उपसेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK21_16","027_21_16","EZK","21","16","16","आये तलवार, तुनं तोंड जशे फिरी तशे तु सवारीसनं उजवीकडे वय, डावीकडे फिर. ");
INSERT INTO ahr_vpl VALUES ("EK21_17","027_21_17","EZK","21","17","17","मी बी टायी वाजाडीसनं मनी क्रोधनी पुर्तता करसू; मी परमेश्वर हाई सांगस. ");
INSERT INTO ahr_vpl VALUES ("EK21_18","027_21_18","EZK","21","18","18","परमेश्वरनं वचन माले परत प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK21_19","027_21_19","EZK","21","19","19","मानवपुत्रा बाबेलना राजानी तलवार येवाकरता दोन रस्ता आखी ठेव; नगरमां जानारा रस्तानी चवाठीवर मार्गदर्शक हातनी एक आकृती खंदी ठेव. ");
INSERT INTO ahr_vpl VALUES ("EK21_20","027_21_20","EZK","21","20","20","अम्मोनी पोर्‍यासना राब्बा यानावर तलवार येवाकरता एक रस्ता अनी यहुदामां जायीसनं तटबंदी करेल यरुशेलमवर तलवार येवाकरता एक रस्ता आखी ठेव. ");
INSERT INTO ahr_vpl VALUES ("EK21_21","027_21_21","EZK","21","21","21","कारण बाबेलना राजा चवाठावर, दोन रस्ता फुटतसं तठे शकून दखाले थांबेल शे; तो भातामासला बाण हालाडीसंन प्रश्न दखी राहीना शे; तेराफिमले कौल लायी राहीना शे, बली चढायेल पशुना काळजवरतीन शकून दखी राहीना शे. ");
INSERT INTO ahr_vpl VALUES ("EK21_22","027_21_22","EZK","21","22","22","त्यानी उजवीकडे यरुशेलमनीबारामां शकून निघना; तो आशे शे की आघातयंत्र लवावी; मारा! हाणा! आशे शब्द तोंडमाईन निंघाले पाहिजे; सिंहानंद करानं, वेशीले आघतयंत्र लावानं; मोरचे रचानं अनी बुरुज बांधानं. ");
INSERT INTO ahr_vpl VALUES ("EK21_23","027_21_23","EZK","21","23","23","इस्राएलना नजरतीन हाई शकून खोटा शे, कारण त्यासनाजोडे देवनं प्रतिज्ञापुर्वक करार शेतस. तरीबी तो त्यासले त्यासना अधर्मनी आठवन करीसनं परकासनी हातमां दी. ");
INSERT INTO ahr_vpl VALUES ("EK21_24","027_21_24","EZK","21","24","24","हयामुये प्रभु परमेश्वर सांगस, तुमना पाप उघडा व्हयीसनं तुमन्या बठया कृत्यासमां तुमनी पापं दखायतसं, ज्यानामुये तुमीच सोताले अधर्मनी आठवन करी देतस; तुमले आठवन व्हयी जायेल शे म्हनीसनं तुमी परक्यासना हातमां सापडेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK21_25","027_21_25","EZK","21","25","25","हे जखमी व्हयेल पापी सरदार, तुनी येळ, तुनं पापनं शेवट जोडे यि लागेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK21_26","027_21_26","EZK","21","26","26","प्रभु परमेश्वर आशे सांगस, शिरोभुषण उतार, मुकूट काढी टाक; काहीच कायमनं राहावावू नही; ज्या नीच त्या उचा व्हतीन अनी उचा त्या नीचा व्हतीन. ");
INSERT INTO ahr_vpl VALUES ("EK21_27","027_21_27","EZK","21","27","27","मी त्यासना नाश करसू; करसूस करसू; हाई स्थिती आशी राहावावू नही; ज्याना हक्क शे तो येवावर मी सत्त दीसू, ");
INSERT INTO ahr_vpl VALUES ("EK21_28","027_21_28","EZK","21","28","28","\"हे मानवपुत्रा संदेश दिसनं सांग, अम्मोनी पोर्‍यासनीबारामां अनी त्यासनी करेल निंदानीबारामां प्रभु परमेश्वर जे सांगस ते सांग, तलवार वध कराकरता तलवार उपशेल शे; फन्ना उडावाकरता, चमकाडाकरता ती पाजेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK21_29","027_21_29","EZK","21","29","29","त्या तुनासमोर कपटना संदेश देतस तवय; तुले खोटं शकून सांगतस तवय; ज्या जखमी व्हयेल पापीसना पापजन्य‍ शेवट जवय यि लागेल शे त्यासनी कापेल मानवर ती तलवार तुले झोपाडी. ");
INSERT INTO ahr_vpl VALUES ("EK21_30","027_21_30","EZK","21","30","30","\"ती परत म्यानमां घाल, जठे तु तयार व्हयेल शे ती तुनी जन्म भुमीवर मी तुना न्याय करसू. ");
INSERT INTO ahr_vpl VALUES ("EK21_31","027_21_31","EZK","21","31","31","मी मना कोपना वर्षाव तुनावर करसू, अनी ज्या राक्षशनासारखा अनी नाश करानाबारामां कुशल शेतस आशे माणसासनी हातमां तुले दिसू ");
INSERT INTO ahr_vpl VALUES ("EK21_32","027_21_32","EZK","21","32","32","तु आगमां भस्म व्हशी; तुना रंगत देशमां पडी राही; तुनी मोरे आठवन राहावावू नही; कारण मी परमेश्वर हाई बोलेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK22_1","027_22_1","EZK","22","1","1","परमेश्वरनं वचन माले प्राप्त व्हयन की, ");
INSERT INTO ahr_vpl VALUES ("EK22_2","027_22_2","EZK","22","2","2","\"मानवपुत्रा,\" \"तु न्याय करशी ना? त्या खुनी नगरीना न्याय करशी ना? त्या येळले तिले तिना बठा अमंगळ कृत्य दखाड. ");
INSERT INTO ahr_vpl VALUES ("EK22_3","027_22_3","EZK","22","3","3","तिले सांग, प्रभु परमेश्‍वर सांगस, आये नगरी, तुना काय येवाले पाहिजे म्हनीसनं तु आपलामां रक्तपात करस, अनी सोताले विटाळ कराकरता मुर्ती करस. ");
INSERT INTO ahr_vpl VALUES ("EK22_4","027_22_4","EZK","22","4","4","सोता पाडले रंगतघाई तु आपलाला दोषी करं, तु करेल मुर्तीघाई सोताले विटाळ; तु आपला काय जोडे आणं, तुना वरीस भरी जायेल शेतस, म्हनीसनं मी तुले राष्ट्रसना निंदाले, बठा देशना थटाले पात्र करसू. ");
INSERT INTO ahr_vpl VALUES ("EK22_5","027_22_5","EZK","22","5","5","तु अभद्र नावनी अनी बेबंदपणतीन भरेल नगरी शे हाई समजीसनं जोडेना अनी दुरना तुना उपहास करतीन, ");
INSERT INTO ahr_vpl VALUES ("EK22_6","027_22_6","EZK","22","6","6","दख, इस्त्राएलना बठा सरदार आप आपला बाहुबलपरमानं रक्तपात कराकरता तुनामां राहेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK22_7","027_22_7","EZK","22","7","7","तुमनामां लोके मायबापले तुच्छ मानतसं, तुनामां त्या परदेशीवर जुलूम करतसं, तुमनामां त्या अनाथ अनी विधवासवर अत्याचार करतसं, ");
INSERT INTO ahr_vpl VALUES ("EK22_8","027_22_8","EZK","22","8","8","तु मन्या पवित्र वस्तुसले तुच्छ मानस, तु मना शाब्बाथ अपवित्र मानी राहीना शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK22_9","027_22_9","EZK","22","9","9","तुनामां रक्तपात कराकरता लुचा लोके राही राहीना शेतस, त्या तुना डोंगरवर मेजवानी करतसं, तुनांमा बदलफैलीमां चालतसं. ");
INSERT INTO ahr_vpl VALUES ("EK22_10","027_22_10","EZK","22","10","10","तुनामां त्या बापनी लाज उघडी करतसं, पाळी येयल बाई दुर बशेल व्हती तवय तिनावर बलात्कार करतसं. ");
INSERT INTO ahr_vpl VALUES ("EK22_11","027_22_11","EZK","22","11","11","तुनामां कोणीबी आपली शेजारनी बाईनीसंगे अघोर कर्म करसं, कोनी आपली सुननीसंगे शरीरसंबध करीसनं तिले भ्रष्ट करसं, कोनी आपली बहीनले, कोनी आपला बापनी पोरले भ्रष्ट करसं. ");
INSERT INTO ahr_vpl VALUES ("EK22_12","027_22_12","EZK","22","12","12","तुनामां रक्तपात कराले पाहिजे म्हनीसनं त्या लाच लेतस, तु व्याजबटा करस, जुलूम करीसनं आपला शेजारीले त्रास देस अनी माले ईसरेल शे, आशे प्रभु परमेश्वर सांगस, ");
INSERT INTO ahr_vpl VALUES ("EK22_13","027_22_13","EZK","22","13","13","म्हनीसनं हयामुये, तु अन्यायतीन करेल कमायीमुये, अनी तुनामासला रक्तपातमुये मी मना हात उपटी राहीनू शे. ");
INSERT INTO ahr_vpl VALUES ("EK22_14","027_22_14","EZK","22","14","14","मी तुना समाचार लिसू त्या दीन तुन मन टिकावू धरावू नही का? तु हात दृढ राहातीन का? मी परमेश्वर हाई जे बोलेल शे ते मी करसुच. ");
INSERT INTO ahr_vpl VALUES ("EK22_15","027_22_15","EZK","22","15","15","मी राष्ट्रसमां तुनी पांगापांग करसू, देश देशमां तुनी दाणादाण करसू अनी तुनी अशुध्दता नष्ट करसू. ");
INSERT INTO ahr_vpl VALUES ("EK22_16","027_22_16","EZK","22","16","16","तु राष्ट्रासदेखत आपला कर्मतीन अपवित्र ठरशी; तवय तुले समजी की मी परमेश्वर शे. ");
INSERT INTO ahr_vpl VALUES ("EK22_17","027_22_17","EZK","22","17","17","परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK22_18","027_22_18","EZK","22","18","18","मानवपुत्रा, इस्त्राएलना घराणां मनी नजरमां फक्त गाळ व्हयी जायेल शे, भट्टीमासला पितय, कथील, लोखंड अनी शिसा यानासारखा त्या सर्वा शेतस; त्या रुप्यामासला गाळ व्हयी जायेल शेतस. ");
INSERT INTO ahr_vpl VALUES ("EK22_19","027_22_19","EZK","22","19","19","हयामुये प्रभु परमेश्वर सांगस, तुम्ही सर्वा गाळ व्हयेल शेतस; म्हनीसनं दख, मी तुमले यरुशेलममां एकजागे करसू. ");
INSERT INTO ahr_vpl VALUES ("EK22_20","027_22_20","EZK","22","20","20","रुपे, पितय, लोखंड, शिसा अनी कथील लोके भट्टीमां टाकतसं अनी ती ईतवळाकरता आगमां फुकी तापाडतस, तशे मी मना क्रोधघाई अनी संतापतीन तुमले जमा करसू अनी भट्टीमां ईताळसू. ");
INSERT INTO ahr_vpl VALUES ("EK22_21","027_22_21","EZK","22","21","21","मी तुमले जमा करीसनं मनी क्रोध आगना फुंकर तुमनावर घालसू, ज्यामुये तुमी भट्टीमां ईतळी जाशात. ");
INSERT INTO ahr_vpl VALUES ("EK22_22","027_22_22","EZK","22","22","22","रुपे भट्ठीमां ईतळतसं तशे तुमी यरुशलेमां ईतळी जाशात, तवय तुमले समजी की मी परमेश्वरनी आपला संताप तुमनावर वतेल शे. ");
INSERT INTO ahr_vpl VALUES ("EK22_23","027_22_23","EZK","22","23","23","मंग परमेश्वरनं वचन माले प्राप्त व्हयनं की, ");
INSERT INTO ahr_vpl VALUES ("EK22_24","027_22_24","EZK","22","24","24","मानवपुत्रा, हाई भुमीले सांग, क्रोधनां दिनमां ज्या शुध्दी न पावेल अनी पर्जन्यवृष्टी नही व्हयेल तु भुमी शे. ");
INSERT INTO ahr_vpl VALUES ("EK22_25","027_22_25","EZK","22","25","25","तठे संदेष्टयानी एकोपा करेल शे; भक्ष्या फाडीसनं खानारा गरजना करनारा सिंहपरमानं त्या लोकेसना प्राण ग्रासी टाकतीन; त्या धन अनी पैसा लयी जातसं; त्या तिना विधवासनी संख्या वाढवतसं. ");
INSERT INTO ahr_vpl VALUES ("EK22_26","027_22_26","EZK","22","26","26","तिना याजक मना धर्मशास्रना नियम मोडीसनं मन्या पवित्र वस्तु भ्रष्ट करतसं; पवित्र अनी अपवित्र यासमां त्या काही भेद ठेवतसं नही; शुध्द अनी अशुध्द यासना फरक त्या शिकाडतसं नही; त्या मना शब्बाथनीबारामां डोयाझाकपना करतसं; त्यासनामां मना अपमान व्हसं. ");
INSERT INTO ahr_vpl VALUES ("EK22_27","027_22_27","EZK","22","27","27","तिनामासला सरदार भक्ष्य फाडीसनं खानारा लांडगानामायक शेतस; त्या अन्यायतीन कमाई कराकरता रक्तपात करतसं; मानव जातनं विनाश करतस. ");
INSERT INTO ahr_vpl VALUES ("EK22_28","027_22_28","EZK","22","28","28","तिना संदेष्टा कच्चा चुना त्यासनाकरता वापरतसं; मिथ्या दृष्टांत दखीसनं त्या त्यासले खोटा शकून सांगतसं अनी परमेश्‍वर सांगस नही तरीबी परमेश्वरनी सांगेल शे आशे त्या सांगतसं. ");
INSERT INTO ahr_vpl VALUES ("EK22_29","027_22_29","EZK","22","29","29","देशमासला लोके बलत्कार अनी चोरी करतसं; त्या दुर्बल अनी दारीद्रयासले दाबी टाकतसं अनी परदेशीसवर अन्याय अनी जुलूम करतसं. ");
INSERT INTO ahr_vpl VALUES ("EK22_30","027_22_30","EZK","22","30","30","मी भुमीना नाश नही कराले पाहिजे म्हनीसनं तिनामां कोनी तट बांधी, कोनी मनासमोर देशकरता खिंडमां उभा राही की काय यानी मी वाट दखी, पन कोनीच माले तशे दखायनं नही. ");
INSERT INTO