﻿USE sofia;
DROP TABLE IF EXISTS sofia.aguBl_vpl;
CREATE TABLE aguBl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aguBl_vpl WRITE;
INSERT INTO aguBl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Yi tcya'j tu yi wuxtx'otx', Ryos ncu' xtxumul tetz le xe'tzbil tzaj. ");
INSERT INTO aguBl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Poro yi wuxtx'otx' qui'c xtxolbil tane'n. Na a' cu'n pi'lij tibaj cyakil luwar. Ej nin tz'o'tz nintunin bene'n tzi'n. Qui'c jun takle'n at. Poro yi Porer Ryos na nin xon tera'tz tibaj yi a' yi pi'lij. ");
INSERT INTO aguBl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Itzun bantz, nin tal Ryos: “Na waj yil jal yi tkan skil.” Jale'n nintzun ban tkan skil. ");
INSERT INTO aguBl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nintzun til Ryos yi chumbalaj nin yi jale'n tkan skil. Ej nin cu jatxol yi tkan skil, tu yi tz'o'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nin oc tk'ol Ryos bi' tkan skil tetz “sk'ejl,” ma yi tz'o'tz, “lak'bal” tzun ban bi'-tz ta'n. Icy'e'n nintzun ban yi bajx k'ej. ");
INSERT INTO aguBl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ej itzun tal i' le ca'p k'ej: “Tajwe'n yil jatx tib yi a' yi pi'lij tibaj cyakil luwar, bantz at a' sban tul cob ama'l.” Ej i nintzun bantz chi yi tal i'. ");
INSERT INTO aguBl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Bnix yi jatxbil xo'l yi a' ta'n. Jun tx'akaj a' cyaj tzak' yi jatxbil tetz. Ej nin junt tx'akaj a' cyaj cyen tibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Yi jatxbil xo'l yi a', “tcya'j”, ban bi' tan Ryos. Icy'e'n nintzun ban yi ca'p k'ej. ");
INSERT INTO aguBl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ej itzun tal i' le toxi'n k'ej: “Yi a' yi at wuxtx'otx', na waj yil ẍchamcu'n tib tul jun ntzi' ama'l, bantz jale'n jun ama'l yi skej.” I nintzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Yi ama'l yi skej, kale qui'cle't a', “tx'otx'” tzun ban bi'-tz ta'n. Ma yi a' yi pi'lij, “mar” tzun ban bi'-tz. Nin til Ryos yi ba'n atite't cyakil. ");
INSERT INTO aguBl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ncha'tz tal i': “Na waj yil txa'xan cyakil yi wuxtx'otx'. Nin na waj yil jal cyakil jilwutz ujul yil tak' tijal. Na waj yil jal e'chk jilwutz itzaj yil tak' wutz. Nin na waj yil jal e'chk jilwutz tze' yil tak' lo'baj.” Nin ya'tz nin bantz chi tal i'. ");
INSERT INTO aguBl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Jal cyakil jilwutz ujul. Nin ncha'tz jal e'chk jilwutz itzaj yi na tak' tijal. Nin jal e'chk jilwutz tze' yi na tak' lo'baj. Nin til Ryos yi ba'n atite't cyakil. ");
INSERT INTO aguBl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Icy'e'n nintzun ban yi toxi'n k'ej. ");
INSERT INTO aguBl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Ej itzun taltz le cyaji'n k'ej: “Na waj yil lajluchax yi e'chk txekbil tcya'j tan xtxeke'n yi wuxtx'otx', nin tan jatxle'n yi sk'ejl tu yi lak'bal. Ncha'tz tan ẍchajle'n yi e'chk yob tu e'chk k'ejlal.” Nin ya'tz nin bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Yi bnixe'n yi e'chk txekbila'tz, ja bnix cob lmak txekbil ta'n. Yi jun yi mas na txekun ya'stzun yi jun yi na xcon tan xtxeke'n tkan skil. Ma yi junt yi qui'c mas na txekun, ya'stzun na xcon tan xtxeke'n lak'bal, nin ncha'tz bnix yi e'chk tx'uml ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Cyakil yi e'chk txekbil yi at tcya'j, Ryos txumul tetz tan xtxeke'n yi wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ryos txumul tetz yi e'chk txekbila'tz tan xcone'n tetz katxekbil, nin ncha'tz tan jatxle'n xo'l yi sk'ejl tu lak'bal. Ej nin til Ryos yi ba'n atit. ");
INSERT INTO aguBl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Icy'e'n nintzun ban yi cyaji'n k'ej. ");
INSERT INTO aguBl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ej itzun taltz le to'e'n k'ej: “Na waj yil jal wi'nin txuc xe a'. Ncha'tz na waj yil jal wi'nin jilwutz txuc yi ba'n chixicy'in.” I nintzun bana'tz chi tal i'. ");
INSERT INTO aguBl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ryos txumul tetz cyakil jilwutz txuc yi at xe mar. Lmak lo'tz, co'chk lo'tz, i' txumul tetz tircu'n. Ncha'tz i' txumul tetz cyakil jilwutz txuc yi ba'n na chixicy'in. ");
INSERT INTO aguBl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Yi tilol Ryos yi ba'n atite't cyakil, tk'ol tzun i' banl squibaj. Nintzun tal i'-tz: “Na waj yil puc'un chiwutz cyakil yi txuque'j. Na waj yil noj xe mar cyak'un. Ncha'tz na waj yil jal wi'nin jilwutz txuc yil chixicy'in tcya'j.” ");
INSERT INTO aguBl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Icy'e'n nintzun ban yi to'i'n k'ej. ");
INSERT INTO aguBl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ej itzun taltz le kaki'n k'ej: “Ncha'tz na waj yil jal wi'nin txuc wuxtx'otx'. Na waj yil chijal txuc tetz awuna'n, nin na waj yil chijal smaron txuc. Ncha'tz na waj yil chijal txuc yi tul chijutnin tu quib wuxtx'otx'.” I nintzun bana's chi tal i'. ");
INSERT INTO aguBl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ryos mbanon tetz cyakil jilwutz txuca'tz. Nin til i' yi chumbalaj nin cyakil. ");
INSERT INTO aguBl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ej nintzun taltz: “Ncha'tz skabne' wunak. Ni'cu'n che' kulej chi kutane'n ketz. Nin e' ajcaw sbne' scye'j cyakil jilwutz txuc, nin scye'j cyakil jilwutz cay, nin scye'j cyakil jilwutz txuc yi na chixicy'in tcya'j. Nin e' ajcaw sbne' scye'j cyakil yi e' yi na chijutnin tu quib wuxtx'otx'.” ");
INSERT INTO aguBl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Itzun bantz yi cwe'n xtxumul Ryos yi e' wunak, cho'n cu'n e' tulej chi tane'n i' tetz. Yaj tu xna'n e' tulej. ");
INSERT INTO aguBl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ej nin tak' Ryos banl squibaj. Nin tal i' scyetz: “Na waj yil cxpuc'unwok. Na waj yil xcawunwok tzone'j wuxtx'otx'. Axwok ajcaw sbne' scye'j cyakil jilwutz txuc, chi tane'n cay, nin cyakil yi e' txuc yi na chixicy'in, nin scye'j cyakil yi e' txuc yi na chibiknin quib nka yi na chijut nin quib wuxtx'otx',” chij i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ej nin ncha'tz tal i' junt xtxolbil scyetz: “Bitwok tzaj. Cyakil jilwutz ch'im tu tze' yi na tak' wutz, ya'stzun ba'n baj ita'n tetz iwa'. ");
INSERT INTO aguBl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ma yi e' txuc, ch'im cu'n sbajk cya'n, tu e'chk jilwutz xtze',” chij Ryos bantz. I nintzun bantz chi tal Ryos scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Wi'nin stzatzine'n Ryos te cyakil yi ak'un yi mbnix ta'n. Icy'e'n nintzun ban yi wukaki'n k'ej. ");
INSERT INTO aguBl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ya'stzun ban Ryos tan banle'n yi tcya'j tu yi wuxtx'otx', tu cyakil yi e'chk takle'n yi at bene'n tzi'n wi munt. ");
INSERT INTO aguBl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ej ma le juki'n k'ej, ujewe'n nin ban, na nsken wi't bnix cyakil ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nin tak' i' banl tib yi juki'n k'eja'tz. Chin xan nintzun yi jun k'eja'tz bantz ta'n na ya's tzun k'ej yi tujewe'n i'. ");
INSERT INTO aguBl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Je xtxolbile'j te yi ẍe'n cu'n bnixe'n yi tcya'j tu yi wuxtx'otx'. Yi bnixe'n yi tcya'j tu yi wuxtx'otx' tan Kataj Ryos, ");
INSERT INTO aguBl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","qui'c jun jilwutz xtze' at. Ej nin qui'c nin jun jilwutz ujul at, na ntaxk saj a'bal tan Kataj. Nin ncha'tz qui'c jun wunak at wuxtx'otx' tan ak'un. ");
INSERT INTO aguBl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Poro yi bnixe'n yi tcya'j tu yi wuxtx'otx', nintzun je'ul mulk'uj yi a' ta'n, tan sijle'n yi wuxtx'otx' tan jale'n e'chk jilwutz xtze'. ");
INSERT INTO aguBl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Toque'n tzun Kataj tan banle'n yi bajx wunak. Tx'otx' xcon ta'n, tan banle'n. Ej nin yi bnixe'n ta'n, nintzun oc juclul yi xewtz. Ma yi toque'n juclul yi xewtz, oque'n nin bantz tetz jun wunak yi itz'. ");
INSERT INTO aguBl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Itzun bantz nintzun oc Kataj tan banle'n jun chum balaj cojbil jalen lilen, tul yi ama'l yi na bi'aj Edén. Cho'n tzun topone'n yi yaj yi nsken bnix ta'n tul yi jun cojbila'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Kataj jalsan cyakil jilwutz tze' tul yi jun cojbila'tz. Chum balaj tze' jal ta'n yi na tak' wutz, nin yi ba'n na bajsij. Ej nin nicy'al yi jun ama'la'tz bnix jun balaj wi' tze' yi na tak' itz'ajbil. Nin ncha'tz bnix junt wi' tze' yi na xcye' wutz tan tele'n katxum te e'chk takle'n balaj nin te e'chk takle'n cachi'. ");
INSERT INTO aguBl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ej nin tul yi jun ama'la'tz yi na bi'aj Edén at jun a' yi xcon tan sijle'n cyakil yi ama'l. Te yi jun a'a'tz cyaj cu'n k'ab na el. ");
INSERT INTO aguBl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Pisón bi' yi bajx, yi na icy'ak tul cyakil ama'l Havila, kale atite't wi'nin oro. ");
INSERT INTO aguBl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Nin ncha'tz tul yi jun ama'la'tz, at perfum yi chin c'o'c nin. Nin ncha'tz at e'chk balaj c'ub yi na bi'aj ónice. ");
INSERT INTO aguBl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ma yi ca'p scyeri a'a'tz, Gihón bi' nin i'tz yi a' yi na icy'ak tul cyakil ama'l cwent Cus. ");
INSERT INTO aguBl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Yi toxi'n scyeri yi a'a'tz, Tigris bi', nin i'tz yi a' yi na icy'ak swutzlen yi ama'l cwent Asiria. Ma yi cyaje'n k'ab yi jun a'a'tz Eufrates bi'. ");
INSERT INTO aguBl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nintzun tak' Kataj Ryos ama'l tetz Adán tan ta'te'n tul yi jun ama'la'tz, nin tan toque'n tan cojle'n wutz. ");
INSERT INTO aguBl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Itzun tal Kataj tetz: “Ba'n lbaj cyakil yi e'chk lo'baj awa'n yi at tzone'j. ");
INSERT INTO aguBl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Poro qui'c rmeril tan abajsal yi wutz yi jun wi' tze' yi na xcye' tan ẍchajle'n yi e'chk takle'n balaj tu e'chk takle'n cachi'. Kol baj awa'n, jun cu'n yol ẍquimok,” stzun Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Toque'n tzun Kataj tan xtxumle'n yi qui na yub yi ẍchuc yi yaj at. “Tajwe'n no'c tan banle'n jun xk'ajlab yi ba'n tetz i', nin yi ba'n xcon tan ẍch'eye'n,” stzun Ryos tc'u'l cuntu'. ");
INSERT INTO aguBl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ma yi e' txuc yi nsken chibaj bnix tan Kataj, yi e' yi na chixon wuxtx'otx', scyuch' yi e' yi na chixicy'in tcya'j, tx'otx' tu' xcon ta'n tan chibanle'n. Ej nin e' opon cyakil yi e' txuca'tz tan Kataj swutz yi yaj tan toque'n i' tan tocse'n chibi'. Yi chibi' yi e' txuc yi e' baj oc ta'n, i nin chibi'a'tz at jalu'. ");
INSERT INTO aguBl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","I' ocsan chibi' yi e' txuc yi ba'n tetz awu'n, nin i' ocsan chibi' yi e' txuc yi na chixicy'in, nin i' ocsan chibi' yi smaron txuc. Poro qui'c nin jun scyeri e' txuc yi oc chibi' ta'n yi nink xcon tetz xk'ajlab i', nka nink xcon tan ẍch'eye'n. ");
INSERT INTO aguBl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Joyol tzun Kataj puntil, nin cu watzal yi yaj. Nin te yi na wit, nin eltzaj tcy'al jun tembl. Ma yi tele'n tzaj tcy'al, ite'n nin ban cyen yi ẍchi'bel yi yaj tan Kataj chitane'n nin. ");
INSERT INTO aguBl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Te yi jun tembl yaj yi eltzaj tcy'al Kataj, bnix jun xna'n ta'n. Yi bnixe'n yi xna'n topone'n tzun tan Ryos swutz yi yaj. ");
INSERT INTO aguBl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Yi bene'n tilol yaj yi xna'n nintzun taltz: “Yi june'j i'tz mero imbakil, i'tz mero inwankil. Xna'n tz'a'lchok tetz, na cho'n mme'ltzaj tinwankil tan Kataj,” stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Cha'stzun te cyakil yi e' yaj, yi na oc quixkel na quil cyen chitaj chitxu', tan chinajewe'n tu quixkel. Ej nin yi jun lmuja'tz yi na cyok'bej quib, junit na ban chiwankil. ");
INSERT INTO aguBl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Yi bnixe'n yaj tu xna'n tan Kataj tx'anlche' cuntu', poro qui'c mu'ẍ tal nak chitx'ixwij squibil quib. ");
INSERT INTO aguBl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ẍchixo'l cyakil txuc yi bnix tan Kataj Ryos, at tzun jun lu'baj. Chin list nin i' ẍchiwutz cyakil smaron txuc. Nintzun opon yi jun lu'baja'tz te Eva, nintzun taltz: —¿Bintzij pe' yi ko ja tal Ryos tzitetz yi qui'c cuj tan ibajsal jun scyeri e'chk jilwutz lo'baj te yi at tzone'j? stzun lu'baj tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Saje'n tzun tlol Eva tetz: —Qui', at cuj tan kabajsal alchok jilwutz lo'baj. ");
INSERT INTO aguBl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Poro ntina'tz jun yi qui'c cuj tan kabajsal wutz, i'tz yi jun wi' lo'baj yi at nicy'al yi cojbile'j. Na ja tal Ryos yi ntin yi kol kamacquen skaquimok tan i'. ");
INSERT INTO aguBl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","—Nk'e'tz bintzi. Quil xquimwok. ");
INSERT INTO aguBl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Na je yi puntile'j, na na til Ryos yi kol baj ita'n sjalok itajtza'kl. Tz'elepon itxum tetz e'ch balaj ajtza'kl, nin tz'elepon itxum tetz e'ch ajtza'kl cachi'. Cho'n sbne' itxumu'n chi tane'n xtxumu'n Ryos. Cha'stzun te qui na taj i' yil baj yi jun lo'baja'tz ita'n, stzun Bayba'n ban tetz Eva. ");
INSERT INTO aguBl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Toque'n tzun yi xna'n tan xmaye'n yi lo'baj. Chin elsbil alma' nin, na chin yube'n nin, nin ba'n na bajsij. Toque'n tzun tan xtxumle'n tan baje'n jun ta'n, tan jale'n yi tetz tajtza'kl. Saje'n tzun stzutul jun nin je bajsaltz, nin ben tk'ol jun tetz yi chmil. Nin ncha'tz yi chmil nin bajtz ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yi wi't baje'n yi lo'baj cya'n tele'n tzun pacxuj yi wutz yi cyajtza'kl. Chinachone'n tzuntz te'j yi tx'anl che' cuntu'. Cyoque'n tzuntz tan stz'isle'n xak ibẍ tan toque'n wutz quikan tan jople'n chiwankil. ");
INSERT INTO aguBl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Itzun bantz yi cwe'n k'ej nin ben quibital yi na xon Kataj Ryos wi cojbil. Cyewal tzun quib xo'lak tze'. ");
INSERT INTO aguBl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Jilone'n tzaj tzun Kataj Ryos scyetz itzun taltz: —¡Adán! ¿Na' atiẍe't? ");
INSERT INTO aguBl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Saje'n tzun stza'wel Adán: —Ja ben wital yi na xonu' Ta'. Nin tantu' yi tx'anl chin cuntu' ja chinxob, cha'stzun te ja wew wib, chij Adán tetz Kataj. ");
INSERT INTO aguBl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","—¿Na' tzun chij tzatz yi tx'anl quiẍ cuntu'? ¿Ja pe' baj yi lo'baj awa'n, yi walnak yi qui'c cuj tan abajsal? ");
INSERT INTO aguBl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","—Ja Ta', na yi xna'n yi ntak'u' tetz wuxk'ajlab, i' nmak'on yi lo'baj swetz tan baje'n wa'n, stzun Adán bantz tetz Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Bene'n tzun jakol Kataj Ryos tetz yi xna'n: —¿Mbi tzun ncu' anuc'ul atz? —“Bajse'n yi lo'baj,” chij lu'baj mban swetz. Ja tzun xcye' i' tan insuble'n, nin ja baj yi lo'baj wa'n, chij xna'n tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Bene'n tzun tlol Kataj Ryos tetz yi lu'baj: —Tan yi awil yi ncu' ajuchul, swak'e' acaws. Nin swak'e' mas acaws ẍchiwutz cyakil yi e' mas txuc. Tajwe'n yil tzabiknin ac'u'l wuxtx'otx' sbne' opon tunintz. Nin ncha'tz sbajk tx'otx' awa'n. ");
INSERT INTO aguBl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nin je ẍwuleje'j: Icontr itib sbne' tu yi xna'n. Ej nin ncha'tz chicontr quib sbne' yi e' ara xonl scyuch' yi e' xonl yi xna'n. Nin yi awi', slo'onk tan yi xonl yi xna'n. Ma yi xonl yi xna'n ntin ẍchu's tkan slo'onk awa'n, chij Kataj Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Itzun ben tlol Kataj tetz xna'n: —Ma aẍ atz, q'uixc'uj tzawalaj jun awal. Ej nin yi tajbil yi awankil tetz yi awuchmil sbne'. Ncha'tz ajcaw sbne' i' tzawe'j. ");
INSERT INTO aguBl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Itzun ben tlol Kataj tetz yi yaj: —Ma jalu', tan paj yi ja cxom te tajtza'kl yi awuxkel, nin tan paj yi ja baj yi lo'baj awa'n yi walnak yi qui'c cuj tan abajsal, spo'tok yi wuxtx'otx' wa'n. Tan awil yi ncu' ajuchul, sbne' opon tunintz chin q'uixc'ujnin ljale't awa' swutz yi tx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tan apaj sjalok wi'nin tx'i'x nin xtze' wuxtx'otx'. Sbajk e'chk jilwutz xtze' awa'n tetz awa'. ");
INSERT INTO aguBl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ej nin tan tu' yi mapaj inca'wl, tajwe'n tz'el a' te awi' tan awane'n. Ya'stzun cẍwulej jalen yil cẍo'c junt tir tetz tx'otx'. Na tx'otx' tu' ncẍbnixe't, nin tx'otx'te'n nin cẍtzajpont, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Toque'n tzun bi' txkel Adán ta'n tetz Eva, na i' chitxu'cy'e'x cyakil jilwutz wunak bene'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Nintzun oc Kataj Ryos tan banle'n be'ch cyetz. Stz'uml txuc xcon ta'n. Yi bnixe'n ta'n nin octz tan chiwekle'n. ");
INSERT INTO aguBl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Itzun tal Kataj Ryos: “Ni'cu'n cyajtza'kl jalu' chi kutane'n ketz, na na el chitxum tetz na'j scyetz e'chk ajtza'kl balaj, nin na el chitxum tetz na'j scyetz e'chk ajtza'kl cachi'. Lastum kol baj wutz yi tze' cya'n, yi tze' yi na tak' itz'ajbil tetz ben k'ej ben sak, na kol baj cya'n qui't chiquim sbne' pon tunintz,” stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Cha'stzun te cyele'n lajul Kataj Ryos, le cojbila'tz, yi na bi'aj Edén. E' el lajul tan quicy'e'n tul junt ama'l, tan cyak'uje'n wi tx'otx', wech na tx'otx' te'n e'. ");
INSERT INTO aguBl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Yi cyele'n lajul Ryos, nintzun cyaj tk'ol cobox querubim swutz yi jun balaj cojbila'tz. Ncha'tz cyaj tk'ol jun spar yi nternin na tzan k'a'kl, nin yi lajke'lnin na weltin tu'tz tan q'uicy'le'n yi jun wi' tze'a'tz, yi na tak' itz'ajbil. Ya'stzun tulejtz tan qui cyocompone'n te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Itzun bantz yi chiwitbel quib Adán tu txkel, tekal tzun Eva pwokil jun ni'. Yi titz'e'n yi jun ni'a'tz nin oc bi' tetz Caín. Nintzun tal Eva: “Tan tu' banl talma' Ryos ja jal jun tal wal yi xicy,” stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ej nin yi tele'n tiemp nin jal junt tal Eva, yi na bi'aj Abel. Itzun yi chich'uye'n yi cob tal Eva, pstor cne'r tzun ban tetz Abel, ma tetz Caín ak'unwil ban wi cojbil. ");
INSERT INTO aguBl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ma yi tele'n tiemp, nin ben tcy'al Caín jun oy swutz Kataj. Yi toy i' i'tz wutz tetz tujul. ");
INSERT INTO aguBl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ncha'tz Abel nin ben tcy'al jun oy swutz Kataj. Yi tetz toy yi ben tcy'al i'tz cobox scyeri e' bajx cyal e' cne'r, poro yi e' yi mas balaj. Ej wi'nin tzun stzatzine'n Kataj ban te Abel nin te yi tetz toy. ");
INSERT INTO aguBl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ma tetz Caín quinin tzatzin Ryos te'j, pyor te yi toy. Nintzun je' swutz Caín, nin wi'nin ẍchi'che'n c'u'l bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Bene'n tzun jakol Kataj tetz “¡Caín! ¿Mbi na chi'ch ac'u'l te'j? ¿Mbi'tz na chukin awutz te'j? ");
INSERT INTO aguBl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Yi nink cxom te balaj xtxolbil, cẍtzatzink tzun. Poro tan paj yi qui na cxom te'j, list yi aya'bl tan toque'n tetz ajcaw tzawe'j. Poro nk'e'tz tajwe'n tan xcyewe'n tzawe'j. Tin tu' qui't tzawak' ama'l tetz,” stzun Ryos bantz tetz Caín. ");
INSERT INTO aguBl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Itzun bantz nin ben moxol Caín yi Abel tan chibene'n tan xo'n xo'l wutz. Te yi na chixon, nintzun oc Caín tan biyle'n cu'n Abel yi titz'un. ");
INSERT INTO aguBl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Itzun te yi nsken quim Abel tan Caín, nintzun jak Kataj tetz: —¡Caín! ¿Na' tzun atite't Abel yi awitz'un? —Cuquen Ta', qui na wil wetz. ¿Iẍkaj in tzunk q'uicy'lom te yi witz'un? ");
INSERT INTO aguBl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","—¡Yaj! chin juntlen nin yi awajtza'kl yi ncu' anuc'ul. Na yi ẍch'el yi awitz'un yi mme'l kojxuj wuxtx'otx', na tzan tan aẍochle'n tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Cha'stzun te swak'e' acaws. Tajwe'n cẍe'l swutz yi tx'otx'e'j yi ntz'ubun yi ẍch'el awitz'un. ");
INSERT INTO aguBl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ej nin mpe lok cẍo'c tan cojle'n wutz tx'otx' qui't ltak' balaj cosech tzatz. Jalt xo'n tzabne' bene'n tzi'n wi munt, nin quil cẍuje', stzun Ryos tetz Caín. ");
INSERT INTO aguBl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Stza'wel tzun Caín yol Kataj: —¿Ẍe'n lwulej Ta'? Quil chinxcye' tan muc'le'n yi incaws yi ntak'u' swetz, na tajwe'n tan wele'n tul yi ama'le'j, nin qui'c rmeril tan wilolt wutzu'. ");
INSERT INTO aguBl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Jalt xo'n tzimbne' bene'n tzi'n. Quil na'tij tul junt ama'l, nin awer nak tzimbne' kale na't cu'nt. Alchok scyetz yil chinnoj quen swutz chinquimok ta'n, stzun Caín bantz tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Saje'n tzun stza'wel Kataj: —Alchok scyetz yil tz'oc tan abiyle'n cu'n swak'e' juk tir mas yi caws tzawutz, stzun Kataj bantz. Toque'n tzun jun techl Caín tan Kataj, bantz cya'l jun tz'oc tan biyle'n cu'n. ");
INSERT INTO aguBl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tele'n tzun Caín tul yi ama'l kale e' jilone't tu Kataj. Cho'n tzun topone'n tan najewe'n tul yi ama'l yi na bi'aj Nod. Yi jun ama'la'tz cho'n at swutzlen Edén. ");
INSERT INTO aguBl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Itzun bantz, nintzun chiwitbej quib Caín tu txkel. Tekal tzun yi txkel pwokil jun ni'. Yi tele'n tiemp nin itz'ij yi jun ni'a'tz, nin oc bi' tetz Enoc. Yi puc'une'n chiwutz yi e' xonl Caín nin bnix jun tnum ta'n. Enoc ban yi bi' yi tnuma'tz. I te'n bi' yi cy'ajl Caín ja oc tk'ol tetz bi' yi tnum. ");
INSERT INTO aguBl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoc ya'stzun taj Irad, Irad ya'stzun taj Mehujael, Mehujael ya'stzun taj Metusael, nin Metusael ya'stzun taj Lamec. ");
INSERT INTO aguBl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Cob txkel Lamec banak, Ada bi' jun, ma junt Zila bi'. ");
INSERT INTO aguBl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Yi Ada ya'stzun xtxu' Jabal, ma yi jun Jabala'tz ya'stzun chimam chite' yi e' wunak yi mantial tu' chica'l, nin yi awuna'n wacẍ cya'n. ");
INSERT INTO aguBl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jal jun titz'un Jabal yi Jubal bi'. Yi Jubala'tz ya'stzun yi ntxumun tetz yi bajx kbetz. Cha'stzun te yi oc i' tetz chimam chite' tane'n cyakil yi e' aj kbetzum, chi tane'n yi e' yi na xconsan arpa tu e'chk jilwutz chirimiy. ");
INSERT INTO aguBl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ncha'tz Zila yi ca'p txkel Lamec, jal jun tal yi na bi'aj Tubal-caín. Yi Tubal-caína'tz i' jun txak'ol ch'ich' banak. Ja xcon hierro ta'n tu jun jilwutz ch'ich' yi k'an yubil, yi na bi'aj brons. Ej nin ncha'tz jal jun tanub Tubal-caín yi na bi'aj Naama. ");
INSERT INTO aguBl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Inti Lamec nintzun ben tlol scyetz e' txkel: “I bin jalu', na waj chinjilon tzitetz. At jun yaj yi ja quim wa'n tan tu' yi nchinq'uixpij ta'n. Xicye't i', poro ja quim wa'n tan tu' yi nchinlo'on mu'ẍ tal ni' ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Talnak Ryos yi tz'ak'lok juk tir chicaws yi e' yil biyon cu'n Caín. Poro pyor cu'n yi e' yil cho'c tan imbiyle'n wetz, na yi in wetz swak'e' oxc'al tu juklaj tir chicaws,” stzun Lamec bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Itzun bantz nin chiwitbej quib Adán tu Eva. Tekal tzun pwokil Eva junt ni'. Yi titz'e'n yi ni' nin oc bi' i' tetz Set. Itzun tal yi xna'ntz, “Ryos mmak'on junt wale'j, tetz xel Abel yi quimnak tan Caín.” ");
INSERT INTO aguBl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Itzun bantz, yi yajine'n Set nin jal jun cy'ajl yi na bi'aj Enós. Te yi at tzaj Enós wuxtx'otx', ya'stzun cyoque'n tan xconse'n yi bi' “Jehová” tan na'wse'n Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Cyakil yi e'chk bi'aje'j yi kocopon tan xtxumle'n, e' cu'n xonl Adán. Itzun yi bnixe'n cu'n yi bajx wunak tan Ryos, ni'cu'n tulej chi tane'n i'. ");
INSERT INTO aguBl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Yaj tu xna'n e' bnix ta'n. Nin yi chibnixe'n, toque'n tzun chibi' tak'un tetz Adán. Nin tak' i' banl squibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ma Adán, a'tij jun cient tu junaklaj yob yi ntaxk itz'ij junt cy'ajl i'. I cunin yubil Adán cy'a'n ta'n yi titz'e'n. Toque'n tzun bi' yi jun ni'a'tz ta'n tetz Set. ");
INSERT INTO aguBl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Wajxakt cient yob a'tijt Adán yi nsken itz'ij Set. Ej nin te yi tiempa'tz jale'n nin ban mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Quime'n nintzun ban Adán yi stz'ake'n beluj cient tu junaklaj yob ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ma Set, a'tij jun cient tu o' yob yi ntaxk itz'ij yi cy'ajl yi na bi'aj Enós. ");
INSERT INTO aguBl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Wajxakt cient tu juk yob a'tijt Set yi nsken itz'ij yi cy'ajla'tz. Ej nin te yi jun tiempa'tz jale'n nin ban mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Quime'n nintzun ban Set yi stz'ake'n beluj cient tu coblaj yob ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ma Enós, a'tij jun mutx' tu lajuj yob te yi ntaxk itz'ij yi cy'ajl yi na bi'aj Cainán. ");
INSERT INTO aguBl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Wajxakt cient tu o'laj yob a'tijt Enós te yi nsken itz'ij Cainán. Ej nin te yi tiempa'tz jale'n nin ban mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Quime'n nintzun ban Enós yi stz'ake'n beluj cient yob ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ma Cainán nsken tz'ak oxc'al tu lajuj yob yi titz'e'n yi cy'ajl i' yi na bi'aj Mahalaleel. ");
INSERT INTO aguBl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Wajxakt cient tu ca'wunak yob a'tijt Cainán yi nsken itz'ij Mahalaleel. Ej nin te yi waxak cient tu ca'wunak yoba'tz, jale'n nin ban mas nitxajil i'-tz. ");
INSERT INTO aguBl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Quime'n nintzun ban Cainán yi stz'ake'n beluj cient tu lajuj yob ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ma Mahalaleel, a'tij oxc'al tu o' yob yi ntaxk itz'ijt yi cy'ajl i' yi na bi'aj Jared. ");
INSERT INTO aguBl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Wajxakt cient tu junaklaj yob a'tij Mahalaleel yi nsken itz'ij Jared nin te yi tiempa'tz jale'n nin ban mas nitxajil i'-tz. ");
INSERT INTO aguBl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Quime'n nintzun ban Mahalaleel yi stz'ake'n waxak cient tu jun mutx' tu o'laj yob ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ma Jared, nsken tz'ak jun cient tu oxc'al tu cob yob ta'n yi titz'e'n yi cy'ajl i' yi na bi'aj Enoc. ");
INSERT INTO aguBl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Wajxakt cient yob a'tijt Jared yi nsken itz'ij Enoc, nin te yi tiempa'tz, jale'n nin ban mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Quime'n nintzun ban Jared yi stz'ake'n beluj cient tu oxc'al tu cob yob ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ma Enoc, a'tij oxc'al tu o' yob te yi ntaxk itz'ij yi cy'ajl i' yi na bi'aj Matusalén. ");
INSERT INTO aguBl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Oxt cient yob a'tijt Enoc yi nsken itz'ij Matusalén. Nin te yi tiempa'tz jale'n nin ban mas nitxajil i'. Ej nin te yi tiemp yi a'tij Enoc wuxtx'otx', xom i' te tajbil Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ox cient tu oxc'al tu o' yob a'tij Enoc wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Poro qui nin quim, na tan tu' yi xom i' te tajbil Ryos ntx'akx cuntu', na Ryos icy'an nin i'. ");
INSERT INTO aguBl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ma Matusalén, sken tz'ak jun cient tu jun mutx' tu juk yob ta'n yi titz'e'n yi cy'ajl i' yi na bi'aj Lamec. ");
INSERT INTO aguBl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Jukt cient tu jun mutx' tu cob yob a'tijt Matusalén te yi sken itz'ij Lamec. Nin te jun tiempa'tz jale'n nin ban mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Quime'n nintzun ban Matusalén yi stz'ake'n beluj cient tu oxc'al tu beluj yob ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ma Lamec, sken tz'ak jun cient tu jun mutx' tu cob yob ta'n yi titz'e'n jun cy'ajl. ");
INSERT INTO aguBl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Noé tzun ban bi' tak'un, na talnak Lamec: “Po'tnakt yi tx'otx' tan Kataj Ryos, cha'stzun te tajwe'n tan kak'uje'n swutz tan kac'a'chal kib, poro tan yi jun ni'e'j skujek ta'n,” stzun Lamec bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","O't cient tu jun mutx' tu o'laj yob a'tijt Lamec yi nsken itz'ij Noé. Nin tul yi jun tiempa'tz jale'n nin ban mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Quime'n nintzun ban Lamec yi stz'ake'n juk cient tu oxc'al tu juklaj yob ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ma Noé, yi stz'ake'n o' cient yob ta'n, kalena's tzun jale'n ox cy'ajl i' yi na chibi'aj Sem, Cam nin Jafet. ");
INSERT INTO aguBl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Itzun bantz yi chipuc'une'n wunak wuxtx'otx', nintzun jal wi'nin chinitxa', nin wi'nin balaj xun ban ẍchixo'l. ");
INSERT INTO aguBl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ej nin yi quilol yi e' nitxajil Ryos yi chumbalaj nin e' xuna'tz, cyoque'n tzuntz tan joyle'n yi cyajbil chixo'l tan cyok'bel quib scyuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Poro yi tilol Kataj Ryos, itzun taltz: “Ja wi't icy' impaj scye'j cyakil wunak. Qui't no'c il tan makle'n chiwutz na qui na cho'c jak' inca'wl. Ntin na cyak' ama'l tetz cyajtza'kl cachi'. Iẍnin cuntunin ate' jak' ca'wl yi tajbil chiwankil. Cha'stzun te, junt cuntu' cient tu junak yob swak'e' scyetz tan cya'te'n wuxtx'otx'.” ");
INSERT INTO aguBl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Itzun bantz yi cyok'bel quib yi e' nitxajil Ryosa'tz scyuch' yi e' xuna'tz, nintzun jal chinitxajil scyuch'. Yi chinitxajila'tz yi jal, chin wutz quikan nin e' ban. Ej nin yi e' nitxa'a'tz yi e' jal, ilenin na kana'wsaj, tantu' yi mbi cu'n banake' tentz. ");
INSERT INTO aguBl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Itzun bantz yi tilol Ryos yi chin juntlen nin cyajtza'kl cyakil wunak, yi ntin e'chk ajtza'kl cachi' na chitxum, ");
INSERT INTO aguBl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","nintzun saj jun chin bis te talma'. Itzun taltz: “Qui'k e' mbnix yi e' wunake'j wa'n. ");
INSERT INTO aguBl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ba'n tcu'n chisotzok chicyakil cu'n wa'n. Nin ncha'tz chicopon insotzal cyakil e' jilwutz txuc. Chisotzok tircu'n wa'n, na ba'n tcu'n qui'ck e' cu' imbnol.” ");
INSERT INTO aguBl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ntin jun tal wunak yi tzatzin Kataj Ryos te'j, i'tz Noé. ");
INSERT INTO aguBl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","I bin jalu' je xtxolbile'j te yi mbi cu'n banak Noé. Chumbalaj nin i' banak, na nin xom i' te ca'wl Ryos. Ntin cu'n i' jal c'ulutxumil swutz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ej nin e' jal ox cy'ajl. At jun na bi'aj Sem, nin at junt na bi'aj Cam, nin at junt yi Jafet bi'. ");
INSERT INTO aguBl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Chum balaj nintzun banak Noé swutz Ryos, ma yi e' mas wunak chin juntlen nin cyetz cyajtza'kl. E' len cu'n mal nak. Itzun yi tilol Ryos yi mbi cunin na chitzan wunak tan banle'n, ");
INSERT INTO aguBl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","nintzun ben tlol tetz Noé: “Ja wi't bixe' wa'n tan chisotzaje'n cyakil wunak, na ntin na chibiy quib squibil quib. Cha'stzun te chicopon insotzal tuml cyakil jilwutz txuc tu cyakil e'chk takle'n yi at wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ma aẍa'tz Noé, banaj jun xo'mbil wi a'. Ba'n xcon jun jilwutz tze' awa'n yi at k'olil. Nin banaj e'chk cuart tul yi jun xo'mbila'tz. Ma yil bnix, tajwe'n tzanojsaj yi ẍchubil tze' tan jun jilwutz k'ol yi na bi'aj brea, bantz quil tz'oc a' tul. Okquen yi k'ol awa'n tc'u'l, nin ncha'tz solte'j tan qui toque'n a' tul. ");
INSERT INTO aguBl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","”Ej nin je tzawuleje'j: Yi ẍkinewe'n, jun cient tu junak o'laj metr tzawulej. Ma yi wutz, junak cob metr tu ni'c tzawulej. Ej nin oxlaj metr tu ni'c tzawulej yi wutz tkan. ");
INSERT INTO aguBl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ej nin ox chup tzawulej tc'u'l yi jun barca'tz. Nin ba'n tzaban jun wentanu' tzak' yi tz'ujbil, tak'un me' war. Ej nin ba'n tzaban jun puert xlaj. ");
INSERT INTO aguBl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","”Tajwe'n tzaban yi jun xo'mbila'tz na tz'ul a'bal wa'n wi munt tan chisotzaje'n cyakil wunak, nin cyakil txuc. Chicyakil cu'n ẍchiquimok yil noj bene'n tzi'n wuxtx'otx' tan a'. ");
INSERT INTO aguBl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","”Ma aẍa'tz Noé, swale' jun xtxolbil tzatz. Ja wi't imbixbaj yi xtxolbile'j tzawuch'. Ẍclaxok wa'n tuml anajal, na cẍocopon tul yi barc scyuch' e' acy'ajl, tu awuxkel, scyuch' e' awulib. ");
INSERT INTO aguBl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ncha'tz na waj yil cho'c jujun lmuj txuc tzite'j le barc, jun mam nin jun tij. Na na waj yil chiclax, chi sbajok tzite'j itetz. ");
INSERT INTO aguBl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Tajwe'n tan cyoque'n jujun lmuj txuc tzite'j te cyakil jilwutz txuc yi at bene'n tzi'n wi munt. Jujun lmuj scyeri e' yi tetz awuna'n, nin jujun lmuj scyeri e' yi tu na chijut nin quib wuxtx'otx'. Ya'stzun wajbil, bantz quil chisotz yi txuca'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Poro tajwe'n cxo'c tan ẍchamle'n iwa', nin chiwa' yi e' txuc. Ej nin tajwe'n tan acolol tul barc bantz quil xquimwok tan we'j,” stzun Ryos bantz tetz Noé. ");
INSERT INTO aguBl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Bnix cyakil e'chk takle'na'tz tan Noé, quib yi talnak Kataj tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Itzun bantz yi tele'n tiemp nintzun tal Ryos tetz Noé: “Ma jalu' Noé, ẍchixo'l cyakil wunak yi ate' wuxtx'otx', ntin cu'n aẍ, aẍ balaj. Nque'n bin le barc cyuml e' anitxa' tu awuxkel nin e' awulib. ");
INSERT INTO aguBl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ma yi e' txuc yi nk'e'tz xan, yi at cuj tan baje'n ita'n, tajwe'n tan cyoque'n le barc tzite'j, juk chak lmuj te jujun jilwutz txuca'tz, ma yi e' txuc yi xan tan baje'n ita'n, cho'ken jun ntzi' lmuj awa'n te jujun jilwutz. ");
INSERT INTO aguBl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ncha'tz yi e' txuc yi na chixicy'in tcya'j tajwe'n cho'c, juk chak lmuj te jujun jilwutz bantz chiclaxe'n. ");
INSERT INTO aguBl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Na le jukt k'ej xe'tok a'bal wa'n. Ca'wunak k'ej nin ca'wunak ak'bal sbne' yi a'bala'tz. Na yi wetz wajbil i'tz tan chisotzaje'n cyakil wunak nin cyakil txuc yi bnixnak wa'n,” stzun Kataj Ryos bantz tetz Noé. ");
INSERT INTO aguBl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ej nin quib yi talnak Ryos tetz, i nin tzun tulejtz. ");
INSERT INTO aguBl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","At Noé tul wukak cient yob yi cwe'n yi jun chin a'bal tan nojse'n yi wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Toque'n tzun i' le barc tan colol tib tk'ab yi a'bal, nin xomquen yi txkel te'j, scyuch' e' cy'ajl tu quixkel. ");
INSERT INTO aguBl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ncha'tz e' baj oc cyakil jilwutz txuc. E' oc yi e' txuc yi at cuj tan chibaje'n cya'n. Ej nin e' oc yi e' txuc yi qui'c cu tan chibajsal. Ncha'tz e' oc yi e' yi na chixicy'in tcya'j nin yi e' yi na chijut nin quib wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Quicobenle'n baj cyoque'n tak'un. Jun mam nin jun tij e' baj octz ta'n, i nintzun tulej i'-tz, quib yi tal Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Yi je'mpone'n yi juki'n ke'j yi cyocompone'n tul barc nintzun xe'tij yi a'bal wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ja xe'tij yi jun a'bala'tz te yi na xon Noé tul wukak cient yob, le juklaj tajlal yi ca'p xaw te yi jun yoba'tz. Nintzun saj kojxuj wi'nin a'bal tcya'j. Nin ncha'tz je'ul mulk'uj wi'nin a' xe mar. ");
INSERT INTO aguBl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ca'wunak k'ej nin ca'wunak ak'bal ban yi a'bal. ");
INSERT INTO aguBl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Poro te ite'n nin k'eja'tz yi xe'te'n a'bal ya'stzun cyoque'n Noé tu txkel le barc tu yi ox cy'ajl yi na chibi'aj Sem, Cam nin Jafet. Ncha'tz e' oc xomok yi quixkel yi e' cy'ajola'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Oque'n nin e' bantz scyuch' cyakil e' smaron txuc, nin cyakil txuc yi ba'n tetz awuna'n. Ncha'tz e' oc cyakil jilwutz txuc yi na chixicy'in tcya'j, scyuch' yi e' txuc yi tu na chijut nin tu quib wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Quicobenle'n baj cyoque'n cyakil jilwutz txuca'tz te'j Noé le barc. ");
INSERT INTO aguBl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Quib yi tal Kataj tetz Noé i nintzun tulej. Yi wi't cyoque'n cyakil, nintzun cu' lamol Kataj yi puertil yi barc. ");
INSERT INTO aguBl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ca'wunak k'ej nin ca'wunak ak'bal ban yi a'bal. Yi ẍch'uye'n yi a' wuxtx'otx' nin je' palol yi barc. ");
INSERT INTO aguBl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ch'uye'n nin ban yi a' nin palij yi barc ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Yi ẍch'uye'n yi a' ja xcye' tan jople'n yi e'chk wutz yi chin wutz tkan nin. ");
INSERT INTO aguBl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Juk metr icy' yi a' tibaj yi e'chk wutza'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Yi baje'n yi xtxolbila'se'j, ya'stzun chiquime'n cyakil wunak yi ate' wuxtx'otx', nin ya'stzun chiquime'n cyakil jilwutz smaron txuc, nin ya'stzun chiquime'n cyakil txuc yi ba'n tetz awuna'n scyuch' yi e' yi na chijut nin quib wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Cyakil yi wunaka'tz nin cyakil txuca'tz e' baj quim len. ");
INSERT INTO aguBl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ntina'tz e', e' clax yi e' yi e' oc tej Noé le barc. Ma yi e' mas wunak e' baj quim. Ncha'tz yi e' mas smaron txuc, nin e' mas txuc yi ba'n tetz awuna'n e' baj quim. E' baj quim yi e' txuc yi na chixicy'in, scyuch' yi e' yi na chijut nin quib wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Xkanca'p tzun cient k'ej a'tij a' wi tx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Poro Noé scyuch' yi e' txuc yi ate' tc'u'l yi barc, quinin e' el te c'u'l Ryos. Cha'stzun te xtxumul i' tan saje'n jun cyek'ek' tan tajse'n cu'n yi a'. ");
INSERT INTO aguBl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ncha'tz yi a'bal, makxe'n nintzun bantz. Nin ncha'tz qui'ct a' je'ul mulk'uj xe mar. ");
INSERT INTO aguBl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Yi makxe'n e'ch ẍchun a' nsken el xkanca'p cient k'ej cyak'un Noé tul barc, nintzun xe'tij yi a' tan taje'n cu'n. ");
INSERT INTO aguBl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Juklaj tajlal yi juki'n xaw ya'stzun yi cwe'n pone'n lajpuj yi barc tibaj jun scyeri e'chk wutz cwent luwar yi na bi'aj Ararat. ");
INSERT INTO aguBl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Jun tzunin taje'n cu'n yi a'. Ej nin yi tucumule'n yi bajx k'ej te yi lajuji'n xaw sken tzun lajluchax wi'ak wutz. ");
INSERT INTO aguBl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ẍch'iwal tzun Noé ca'wunakt k'ej. Kalena's tzun je'n jakol yi wentanu'il yi barc. ");
INSERT INTO aguBl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Yi jakxe'n yi wentanu' nintzun eltzaj stzakpul jun joj. Poro tunin na xicy'in cuntunin i'-tz tcya'j, tan ẍch'iwe'n jalen yi skeje'n wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Yi sken eltzaj yi joj, ncha'tz nin eltzaj stzakpul Noé jun slu'k tan tele'n xtxum i' tetz yi ko sken skej yi wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Poro tan paj yi iẍnin pi'lij yi a' wuxtx'otx', cya'l nin jale't ama'l tan yi slu'k tan tujewe'n. Cha'stzun te nin opont junt tir kale eltzit tzakpu'n. Ej nin list Noé tan xtxoble'n quen junt tir tul barc. ");
INSERT INTO aguBl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nintzun ẍch'iw Noé jukt k'ej, kalena's tzun tele'nt stzakpul junt tir yi tal slu'ka'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Yi tele'nt stzakpul sken nintzun cu k'ej yi pakxe'nt junt tir. Cy'a'n jun tal xak oliw ta'n yi tocompone'n. Nin tan tu' yi cy'a'n yi xak tze'a'tz ta'n, nin el xtxum Noé tetz yi tzan skeje'n wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Itzun te yi nsken ocopon junt tir yi tal slu'k, nintzun ẍch'iw Noé jukt k'ej, kalena'tz tzun tele'nt tzakpultz, poro qui't pakxij yi tal slu'ka'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Itzun bantz yi na xon tzaj Noé tul kak cient tu jun yob, yi bajx k'ej te ac'aj yob, tele'n tzun tcy'al i' mu'ẍ wi' yi barc. Yi tele'n ta'n nintzun tiltz yi sken skej yi wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Itzun le junak juk tajlal te yi ca'p xaw teri yoba'tz, nternin chin skejt ban yi wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Nintzun tal Kataj Ryos tetz Noé: ");
INSERT INTO aguBl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ba'n cxe'lwok le barc jalu'. Ba'n tz'el awuxkel nin e' anitxa' scyuch' e' awulib. ");
INSERT INTO aguBl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ncha'tz ba'n che'l yi e' txuc yi ate' tzawe'j le barc. Ba'n che'l chicyakil yi e' yi ba'n chixiquin, scyuch' yi e' yi ba'n tetz awuna'n, nin ba'n che'l yi e' yi tu na chijut nin quib wuxtx'otx'. Tajwe'n tan cyele'n chicyakil bantz chibene'n bene'n tzi'n wuxtx'otx', na yi wajbil i'tz tan chipuc'une'n,” stzun Ryos bantz tetz Noé. ");
INSERT INTO aguBl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Cyele'n tzaj tzun Noé le barc. Xome'l tzaj yi txkel, cyuml yi e' cy'ajl scyuch' e' tlib. ");
INSERT INTO aguBl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ncha'tz yi e' txuc yi ba'n tetz awuna'n, e' baj eltzaj. Ncha'tz e' smaron txuc e' baj eltzaj. Ej nin e' baj eltzaj yi e' txuc yi tu na chijut nin quib, scyuch' yi e' txuc yi na chixicy'in. Chicyakil cu'n e' baj eltzaj. ");
INSERT INTO aguBl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Toque'n tzun Noé tan wekle'n cobox c'ub tetz patbil chitx'ixwatz. Yi bnixe'n nintzun e' baj saj stz'amol Noé jujun scyeri e' txuc yi ba'n tetz chitx'ixwatz. Ej nin pat Noé yi e' txuca'tz tetz toy tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Itzun yi topone'n yi c'o'cal yi toy i' swutz Kataj, nintzun tal Kataj tetz: “Qui't no'c tan sotzaje'n cyakil e'chk takle'n yi at wuxtx'otx' tan a' tan chipaj e' wunak, na yi e' wunak, e' cu'n juchul il yi chijuyil tzaj. Qui't sotz junt tir yi e'chk takle'na'tz wa'n tan a' tan chipaj. Ncha'tz e' txuc, qui't chisotz junt tir wa'n, chi mimban te jun tire'j. ");
INSERT INTO aguBl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","”Jalen pe'k atite't yi wuxtx'otx', tz'ocopon ujul nin sjalok cosech. Sjalok jujun tiemp tz'a', nin jujun tiemp che'w. Sjalok jujun tiemp a'bal, nin jujun tiemp cresum. Ncha'tz yi sk'ejl tu lak'bal, ite'n nin sbne' chi tane'n nin,” chij Ryos bantz tetz Noé. ");
INSERT INTO aguBl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ej nin ncha'tz tak' Ryos banl tib Noé scyuch' e' nitxajil tan yi yole'j: “Sjalok wi'nin initxa' bantz jale'n wi'nin wunak bene'n tzi'n wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Cyakil jilwutz txuc yi at bene'n tzi'n wi munt chocopon jak ica'wl. Ẍchixobok tzitetz. Yi e' yi ate' xe mar scyuch' yi e' yi na chixicy'in tcya'j, chicyakil cu'n ẍchixobok tzitetz. ");
INSERT INTO aguBl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Swak'e' ama'l tzitetz tan chibajse'n alchok scyetz scyeri e' txuca'tz nin alchok jilwutz itzaj yi na el italma' te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ntina'tz jun takle'n yi qui'c rmeril tan baje'n ita'n, i'tz yi chichi'bel yi e' txuc yi qui na el chiẍch'el yi na chiquim. Na yi stz'ajbil jun txuc nka jun yaj cho'n at le ẍch'el. ");
INSERT INTO aguBl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ej nin cyakil wunak, nin cyakil txuc yi na cho'c tan biyle'n cu'n jun cyuch', banij cyetz chicawsa'tz wa'n. Na alchok scyetz jun yil sbiy cu'n jun tuch', stak'e' cwent tzinwutz nin banij tetz cawsa'tz wa'n. ");
INSERT INTO aguBl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Alchok scyetz yil sbiy cu'n junt wunak tajwe'n yil cu biyij tetz, na axwok cu'n welblal. ");
INSERT INTO aguBl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ncha'tz axwok itetz, ba'n chijal wi'nin initxajil bantz chibene'n lo'on wunak bene'n tzi'n wi munt,” stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ncha'tz tal Ryos tetz Noé scyuch' e' cy'ajl: ");
INSERT INTO aguBl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Bitwok tzaj. Ja bixe' jun ac'aj xtxolbil wa'n tetz itetz. Poro nk'e'tz ntin tetz itetz ma na ncha'tz scyetz cyakil ixonl yi ẍchijalok tzantzaj. ");
INSERT INTO aguBl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Yi jun ac'aj xtxolbila'tz i'tz tetz itetz nin scyetz cyakil yi e' txuc yi xomche' tzite'j yi ncxe'lwok tzaj le barc. Qui'c na ban mpe ik e' txuc yi na chixicy'in, nka e' txuc yi ba'n tetz awuna'n. Qui'c na ban ko e' smaron txuc nka qui', na yi jun ac'aj xtxolbila'tz yi ja bixe' wa'n i'tz tetz cyakil jilwutz txuc. ");
INSERT INTO aguBl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ej nin qui'c rmeril tan xite'n yi jun ac'aj xtxolbila'tz. Je xtxolbile'j: Ja wi't bixe' wa'n yi qui't no'c tan chisotzaje'n cyakil wunak tan a'. Qui't saj a'bal wa'n tan sotzaje'n yi e'chk takle'n yi at wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Nin je jun techle'j tan ẍchajle'n tzitetz scyuch' cyakil txuc yi ne'lk cu'n te inyol. ");
INSERT INTO aguBl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ja wi't je' yi arco iris wa'n tcya'j, ya'stzun yi techl yi ja wi't bixe' jun xtxolbila'tz wa'n skaxo'l tzituch'. ");
INSERT INTO aguBl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ej nin sbne' opon tunintz, yil smoltzaj tib sbak' wa'n, ilenin ẍchaje' tib yi jun arco irisa'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ej nin cyakil tir yil ẍchaj tib, swile', nin tz'ul tx'akx tinc'u'l yi xtxolbil yi ja wi't bixe' wa'n skaxo'l tzituch', nin scyuch' cyakil txuc. Qui't tzun saj junt tir a'bal wa'n tan isotzaje'n. ");
INSERT INTO aguBl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Yil ẍchaj tib yi arco iris tul sbak', tz'ul tzun tx'akxuj tinc'u'l yi xtxolbil yi ja bixe' wa'n skaxo'l tzituch' nin skaxo'l scyuch' cyakil txuc yi ate' bene'n tzi'n wi munt. ");
INSERT INTO aguBl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Yi arco irisa'tz ya'stzun quiwel yi xtxolbil yi ja bixe' wa'n tzituch' nin scyuch' cyakil txuc yi ate' wuxtx'otx',” stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Je chibi' yi e' cy'ajl Noé yi e' eltzaj te'j le barc: Sem, Cam, nin Jafet. Yi Cama'tz, ya'stzun taj Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nin tan chixonl yi ox cy'ajl Noé-a'tz, ja noj junt tir yi wuxtx'otx' cya'n wunak. ");
INSERT INTO aguBl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Itzun bantz yi xone'n tiemp nintzun xe'tij Noé tan ak'un wi cojbil, nin cu tawal jalaj uva. ");
INSERT INTO aguBl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ej nin yi jale'n wutz yi uva nintzun je tc'ajal yi win yi bnix ta'n te yi wutz uvaja'tz, nin oc a' twi'. Yi toque'n a' twi' nintzun cyaj cutxlok nicy'al tal pach yi mantial tu'. Qui'c be'ch tetz at. ");
INSERT INTO aguBl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ma Cam, yi taj Canaán, nintzun ben tilol yi cutxlij yi taj, nin qui'c yi be'ch tetz. Tele'n tzaj tzun tan talche'n scyetz Sem tu Jafet. ");
INSERT INTO aguBl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Yi quibital nintzun ben quicy'al jun xbu'k. Nin je nin chik'ol wi chixulchub. Nin wutzcoquenle'n e' bene'ntz tuch' tan jople'n yi wankil prow chitaj. Ya'stzun e' bantz tan qui quilol wankil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Itzun yi tule'n yos tu Noé, nin yi tbital yi mbi cu'n ban yi ẍch'i'p, nintzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“I bin jalu' cawsok Canaán. Tz'ocopon tetz chimos yi e' mos yi e' stzicy.” ");
INSERT INTO aguBl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ej nin ncha'tz tal Noé: “Tak' tzaj Kataj Ryos yi banl tibaj Sem. Ma tetz Canaán, ba'n tz'oc tetz mos i'. ");
INSERT INTO aguBl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ej nin ncha'tz nink tak' Ryos ama'l tetz Jafet tan bene'n lo'on yi tetz xtx'otx'. Ej nin snajank i' ẍchixo'l yi e' xonl Sem. Ma Canaán, mos tu' Jafet sbne'.” ");
INSERT INTO aguBl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Itzun yi nsken icy' yi jun chin wutzile'n a'bala'tz, a'tij Noé oxt cient tu ni'cy yob wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","At Noé tul beluj cient tu ni'cy yob yi quime'n. ");
INSERT INTO aguBl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","I bin jalu' katxume' chixonl yi e' cy'ajl Noé. Yi nsken icy'pon yi jun chin wutzile'n a'bala'tz, jale'n nintzun ban chinitxajil yi e' cy'ajl Noé, yi Sem, Cam tu Jafet. ");
INSERT INTO aguBl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Itzun yi e' cy'ajl Jafet, ja chibi'aj: Gomer, Magog, Madai, Javán, Tubal, Mesec tu Tiras. ");
INSERT INTO aguBl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ma yi e' cy'ajl Gomer, yi bajx cy'ajl Jafet, ja chibi'aj: Askenas, Rifat tu Togarma. ");
INSERT INTO aguBl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ma yi e' cy'ajl Javán, yi cyaje'n cy'ajl Jafet, ja chibi'aj Elisa, Tarsis, Quitim tu Rodanim. ");
INSERT INTO aguBl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Cyakil yi e' bi'aja'tz, e' cu'n xonl Jafet banake'. Cho'n najlche' cwe'n tzi'n tzi'ak mar. Ej nin at len chitnumil, nin apartchk len chiyol jujun tx'akaj. ");
INSERT INTO aguBl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ma yi e' cy'ajl Cam ja chibi'aj, Cus, Mizraim, Fut tu Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ma yi e' cy'ajl Cus ja chibi'aj, Seba, Havila, Sabta, Ra'ama tu Sabteca. Ma yi e' cy'ajl Ra'ama yi cyaje'n cy'ajl Cus ja chibi'aj, Seba tu Dedán. ");
INSERT INTO aguBl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Inti Cus, ncha'tz i' taj Nimrod, yi bajx yaj yi mo'c tetz ajcaw squibaj wunak. ");
INSERT INTO aguBl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ej nin i' jun chin wi'tz aj txuquinl tantu' porer Kataj Ryos. Cha'stzun te na cyal wunak yi jun xtxolbile'j: “Tak' tzaj Kataj awajtza'kl tan awoque'n tetz jun wi'tz aj txuquinl chi banak kataj Nimrod,” che'ch tzun. ");
INSERT INTO aguBl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Bajx toque'n i' tan chicawe'n yi e'chk tnum yi na chibi'aj Babel, Erec, Acad tu Calne. Cyakil e'chk tnuma'tz cho'n at le ama'l yi na bi'aj Sinar. ");
INSERT INTO aguBl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Yi xone'n tiemp ja cyaj cyen tilol Nimrod yi jun ama'la'tz nin ja opon le luwar yi na bi'aj Asiria kale ocnak i' tan nuc'le'n yi e'chk tnum yi na bi'aj Nínive, Rehobot-Ir tu Cala. ");
INSERT INTO aguBl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Ncha'tz ocnak i' tan nuc'le'n yi chumam tnum yi na bi'aj Resén, yi cho'n at nicy'al yi tnum Nínive tu Cala. ");
INSERT INTO aguBl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ma Mizraim, yi ca'p cy'ajl Cam, i' chitaj yi e' ludeo, yi e' anameo, yi e' lehabita, tu yi e' naftuhita. ");
INSERT INTO aguBl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Ncha'tz yi Mizraima'tz i' chitaj yi e' patruseo tu e' casluhita, tu yi e' caftorita, yi chimam chite' yi e' filistey. ");
INSERT INTO aguBl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ma Canaán, Sidón bi' yi bajx cy'ajl i'. Ma yi ca'p cy'ajl, Het bi'. ");
INSERT INTO aguBl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Ncha'tz yi e' jebuseo, e' amorreo, tu yi e' gergeseo, ");
INSERT INTO aguBl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","e' heveo, e' araceo, e' sineo, ");
INSERT INTO aguBl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","e' arvadeo, e' zemareo, scyuch' e' hamateo, e' cu'n xonl Canaán. Ma yi xone'n tiemp nintzun e' ben lo'on bene'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Yi chiluwar yi e' xonl Canaána'tz ja opon joylaj jalen yi ama'l cwent Gera. Ja xe'tij stzi' chitx'otx' le tnum yi na bi'aj Sidón, ej nin ja opon tampuj te yi tnum yi na bi'aj Gaza. Ej nin yi ja icy'ak mojomil chitx'otx' nakajil yi e'chk tnum yi na bi'aj Sodoma, Gomorra, Adma tu chitanum yi e' aj Zebo, jalen yi mpon tampuj te yi tnum Lasa. ");
INSERT INTO aguBl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Cyakil yi e' wunaka'tz yi ja kil chibi', e' cu'n xonl Cam. At len chitnumil nin apart chak len chiyol jujun tx'akaj. ");
INSERT INTO aguBl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ma Sem, yi stzicy Jafet, ncha'tz jal nitxajil i'. Na cyakil yi e' xonl Heber e' cu'n xonl Sem. ");
INSERT INTO aguBl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ma chibi' yi e' cy'ajl Sem i'tz Elam, Asur, Arfaxad, Lud tu Aram. ");
INSERT INTO aguBl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ma yi e' cy'ajl Aram i'tz Uz, Hul, Geter tu Mas. ");
INSERT INTO aguBl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ma Arfaxad, jun scyeri yi e' cy'ajl Sem, i' taj yi yaj yi na bi'aj Sala. Ma Sala i' taj Heber. ");
INSERT INTO aguBl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ma Heber ja chijal cob tetz nitxajil. Yi jun na bi'aj Peleg. Ej nin ja oc yi jun bi'aja'tz, yi titz'e'n, na ya's tzun tiemp yi cwe'n chijatxol quib e' wunak wi munt. Ma yi junt cy'ajl Heber na bi'aj Joctán. ");
INSERT INTO aguBl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ej nin yi Joctána'tz, i' chitaj yi e' wunake'j: Almodad, Selef, Hazar, Mavet, Jera, ");
INSERT INTO aguBl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO aguBl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO aguBl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila tu Jobab. Cyakil cu'n yi e' wunaka'tz e' cu'n nitxajil Joctán. ");
INSERT INTO aguBl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Cho'n chinajewe'n le ama'l yi na icy'pon nin cwent Mesa, jalen le ama'l cwent Sefar. Yi jun ama'la'tz cho'n at jalen lilen tzi'n, nin wi'wtz cunin cyakil luwar. ");
INSERT INTO aguBl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Cyakil yi e' wunaka'tz yi ja kil chibi' e' cu'n xonl Sem. At len chitnumil. Ej nin apart chak len chiyol. ");
INSERT INTO aguBl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Cyakil yi e' najala'tz yi ja wi't kil, e' cu'n xonl yi e' cy'ajl Noé. Nin yi e'chk luwara'tz yi ja wi't kil ya'stzun cyetz chitnumil kale najlche't. Na yi nsken wi't cu yi jun chin wutzile'n a'bala'tz tan Ryos ja chiben lo'on yi e' chixonl yi e' cy'ajl Noé bene'n tzi'n. Tan tu' e', ja jal cyakil jilwutz wunak yi ate' wi munt jalu'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Itzun bantz le xe'tzbil tzaj, junit chiyol cyakil wunak. ");
INSERT INTO aguBl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ej nin yi cyele'n tzaj lilen tzi'n, jal jun chin ẍk'ajlaj cya'n le ama'l cwent Sinar. Ya'stzun e' a'te'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Itzun bantz nintzun cyal cobox squibil quib: “Kabne' lagris nin ba'n kapat.” Ej nin yi bnixe'n cya'n ja xcon tetz xel c'ub tan banle'n chica'l. Ncha'tz ja xcon jun jilwutz ẍpupu' cya'n tetz ẍchib lagris. ");
INSERT INTO aguBl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Yi xone'n tiemp at e' cyal: “Or itetz kabne' jun chin tnum nin jun chin wutzile'n muyc tzone'j, yil jepon jalen tzi'n tcya'j. Sjalok wi'nin kak'ej ta'n. Ej nin qui tajwe'n tan kele'n xit bene'n tzi'n wi munt.” ");
INSERT INTO aguBl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Inti Ryos nin cu'ul tan xmaye'n yi jun tnuma'tz tu yi jun chin muyc yi na chitzan wunak tan banle'n. ");
INSERT INTO aguBl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Toque'n tzun i'-tz tan xtxumle'n, nintzun taltz: “Tampaj yi junit e', nin junit chiyol, ja cho'c tan banle'n yi ak'une'j. Nin cya'l jun yi nink xcye' tan xite'n chitxumu'n. ");
INSERT INTO aguBl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ba'n tcu'n kacuk ẍchixo'l tan suk'le'n cu'n chiyol, bantz qui't tz'el chitxum squibil quib.” ");
INSERT INTO aguBl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","I nintzun tulejtz. Ej nin cyaj cyen quilol yi ak'un tan banle'n yi jun muyca'tz, na qui't na el chitxum tetz chiyol squibil quib. Ej nin e' el xit bene'n tzi'n wi' munt tan Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ya'stzun cwe'n suk'ul Kataj chiyol cyakil wunak. Ej nin ya'stzun yi cyele'n xit bene'n tzi'n wi munt. Cha'stzun te ja oc bi' yi jun tnuma'tz tetz Babel. ");
INSERT INTO aguBl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Je tzun yi e' xonl Sem banake'. Te yi nsken el cobix yob yi ticy'le'nix yi jun chin wutzile'n a'bala'tz, at tzun Sem tul jun cient yob. Ej nin ya'stzun yi titz'e'n yi cy'ajl yi na bi'aj Arfaxad. ");
INSERT INTO aguBl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","A'tij Sem o'-t cient yob yi nsken itz'ij Arfaxad. Ej nin tul yi jun tiempa'tz e' jal mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","At Arfaxad tul junak o'laj yob yi titz'e'n Sala yi cy'ajl i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nin a'tij cyaj cient tu oxt yob, nin tul yi tiempa'tz e' jal mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","At Sala tul junaklaj yob yi titz'e'n Heber yi cy'ajl. ");
INSERT INTO aguBl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Nin a'tij cyaj cient tu oxt yob, nin tul yi tiempa'tz e' jal mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","At Heber tul junak cyajlaj yob yi titz'e'n Peleg yi cy'ajl i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nin a'tij cyaj cient tu junaklajt yob, nin tul yi tiempa'tz e' jal mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","At Peleg tul junaklaj yob yi titz'e'n Reu yi cy'ajl i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Nin a'tij cob cient tu belujt yob, nin te yi tiempa'tz e' jal mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","At Reu tul junak coblaj yob yi titz'e'n Serug yi cy'ajl i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Nin a'tij cob cient tu jukt yob, nin tul yi tiempa'tz e' jal mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","At Serug tul junaklaj yob yi titz'e'n Nacor yi cy'ajl i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nin a'tij cobt cient yob, nin tul yi tiempa'tz e' jal mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","At Nacor tul junak beluj yob yi titz'e'n Taré yi cy'ajl i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nin a'tij jun cient tu belujt yob, nin tul yi tiempa'tz e' jal mas nitxajil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","At Taré tul oxc'al tu lajuj yob yi quitz'e'n yi e' nitxajil yi na chibi'aj: Abram, Nacor, tu Harán. ");
INSERT INTO aguBl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","I bin jalu' je chibi' e' xonl Taré yi chitaj Abram, Nacor tu Harán, yi taj Lot. ");
INSERT INTO aguBl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Yi Harána'tz bajx quime'n i' swutz yi taj, na cho'n quime'n i' le ama'l Ur, cwent e' caldeo, kale itz'e't i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ma Abram umewe'n nin e' bantz tu Sarai. Nin ncha'tz Nacor umewe'n nin e' bantz tu Milca, yi me'l Harán, yi stzicy Isca. ");
INSERT INTO aguBl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ma yi Sarai, yi txkel Abram, qui nin jal tal, na qui'c talbil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Inti yi Taré nin cyaj tilol yi tnum Ur, cwent e' caldeo, tan bene'n le ama'l yi na bi'aj Canaán. Ej nin el tcy'al yi cy'ajl yi Abram, tu Lot yi mam i', nin ncha'tz Sarai yi tlib. Poro yi cyopone'n le tnum Harán, tanewe'n nintzun e' bantz te chipyaj. Ej nin ya'stzun e' najewe'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Cho'n tzun quime'n Taré-tz le ama'la'tz. At i' tul cob cient tu o' yob yi quime'n. ");
INSERT INTO aguBl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Itzun bantz yi tele'n tiemp nintzun jilon Ryos tetz Abram. Itzun taltz: “Il cyen yi atanum. Ncha'tz il cyen yi najbil ataj. Ilwe' cyen yi axonl. Ej nin tzinchaje' junt ama'l tzatz kale cẍa't cu'nt. ");
INSERT INTO aguBl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Tan ara axonl, tzimbne' jun chumam tnum. Swak'e' imbanl tzawibaj nin sjalok ak'ej. Ej nin tan aẍ tu jun ara axonl sjalok chibanl cyakil jilwutz wunak wi munt. ");
INSERT INTO aguBl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Swak'e' imbanl squibaj yi e' yil cyak' ak'ej, nin swak'e' imbanl squibaj yi e' yil cyak' ke'j axonl. Che' incawse' chicyakil yi e' yil cho'c tan telse'n ak'ej scyuch' yi e' axonl. Ej nin tan aẍ lwak'wit imbanl squibaj cyakil jilwutz wunak bene'n tzi'n wi munt.” ");
INSERT INTO aguBl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","I nintzun tulej Abram quib yi tal Ryos tetz. Nin cyaj cyen tilol yi luwar. At i' tul nicy' cient tu junak o' yob yi cyaje'n cyen tilol yi jun luwara'tz, tan topone'n Canaán. Xomij Sarai yi txkel te'j tu Lot yi cy'ajl yi stzicy. ");
INSERT INTO aguBl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ncha'tz el tzaj tcy'al cyakil me'bi'l scyuch' cyakil yi e' mos yi ate' tuch', yi e' mosa'tz yi e' oc jak' ca'wl i' te yi at tzaj i' le tnum Harán. ");
INSERT INTO aguBl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Yi cyopone'n Canaán e' icy'ak tc'u'l wi'nin ama'l, jalen yi cyopone'n nakajil yi tnum yi na bi'aj Siquem. Cho'n tzun cya'te'n xe jun wi' bakch yi at wi jun ẍk'ajlaj yi na bi'aj More. Yi jun wi' tze'a'tz chin xan nin. Te yi jun tiempa'tz najlche' yi e' aj Canaán tul cyakil yi ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ej nin ya'stzun yi ama'l kale ẍchaj wit tib Ryos swutz Abram. Itzun taltz: “Cyakil yi ama'le'j swak'e' scyetz e' axonl,” stzun Ryos bantz tetz. Tantu' yi ẍchajol tib Ryos swutz Abram nintzun oc i' tan nuc'le'n jun patbil xtx'ixwatz tan tk'ol k'ajsbil tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Itzun bantz yi xone'n tiemp nin cyaj cyen tilol Abram yi jun ama'la'tz. Cho'n tzun topone'ntz wi'wtz, swutzlen yi tnum Betel. Ya'stzun je't nuc'ult yi tetz mantial. Cho'n tzun cyaje'n cyen yi tnum Hai swutzlen yi jun luwara'tz. Ej nin ya'stzun e' cwe't tetz cobox k'ej. Nin oc Abram tan nuc'le'n junt patbil xtx'ixwatz tetz Kataj Ryos. Ej nin octz tan na'wse'n bi' i'. ");
INSERT INTO aguBl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Chebele'n cuntu' tzun quicy'e'n Abram jalen cyopone'n le ama'l yi na bi'aj Néguev. ");
INSERT INTO aguBl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Itzun bantz te yi jun tiempa'tz, nintzun cu' jun chin wutzile'n we'j. Qui'c mu'ẍ tal chiwa' yi wunak jal. Cha'stzun te e' ben Abram jalen Egipto tan najewe'n tetz cobox tiemp. ");
INSERT INTO aguBl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Te yi txant tan cyocompone'n jalen Egipto, nintzun tal Abram tetz Sarai yi txkel: “Sarai, na el intxum tetz yi aẍ jun xna'n yi chin yube'n nin. ");
INSERT INTO aguBl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ej nin yil quil yi e' aj Egipto ayubil scyale': ‘I jun chin xna'ne'j, ya'stzun txkel nocxe'j,’ che'ch sbne'. Ej nin chocopon tzun tan imbiyle'n cu'n bantz acyaje'n cyentz chik'ab. ");
INSERT INTO aguBl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ma jalu' tan qui inquime'n cya'n, banaj pawor tan talche'n scyetz yi kitz'un kutzicy kib tzawuch',” stzun Abram bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Yi cyopone'n Abram Egipto, nintzun quil yi e' aj Egipto yi chin yube'n nin Sarai. ");
INSERT INTO aguBl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ncha'tz quil yi e' mas ajcaw xlaj yi faraón, yi chireyil yi e' aj Egipto, yi chin yube'n nin Sarai. Chibene'n tzuntz tan talche'n tetz yi chin yube'n nin yi jun xna'n yi xomij te Abram. Nintzun ben quicy'altz xe ca'l rey. ");
INSERT INTO aguBl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Tantu' yi toque'n klo' Sarai tetz txkel yi rey nintzun toy i' wi'nin e'chk takle'n tetz Abram, wi'nin cneru', wi'nin wacẍ, nin wi'nin buru' scyuch' camey. Ncha'tz toy i' wi'nin yaj tu xna'n tetz mos Abram. ");
INSERT INTO aguBl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Poro ncha'tz tan paj yi toque'n klo' Sarai tetz txkel yi rey ja tak' Ryos jun chin wutzile'n ya'bil tetz, tuml najal i'. ");
INSERT INTO aguBl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Cha'stzun te nin ben mantar rey tan ẍchakle'n Abram. Itzun taltz: “¿Nxac ncu' atxumul yi jun awajtza'kle'j? ¿Nxac qui mawal yi mero bintzi swetz yi ko awuxkel yi jun chin xna'ne'j? ");
INSERT INTO aguBl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Na je bin awale'j: ‘Wanub tu' i'.’ Cha'stzun te mmo'c klo' i' tetz wuxkel. Ma jalu' je awuxkele'j. Cy'aj nin. Quitele'nk wok.” ");
INSERT INTO aguBl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Cawune'n tzun yi rey scyetz e' ẍchakum tan cyele'n chilajul Abram tu txkel tuml cyakil yi at tuch' le tnum Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Itzun bantz yi tele'n tzaj Abram Egipto tu txkel, tu cyakil yi me'bi'l, nintzun e' opontz junt tir le ama'l Néguev. Ncha'tz Lot yi titz'un xomnin te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ma yi Abram chin ric nin i'. At or tuch'. At sakal tuch'. Ej nin wi'nin tawun i'. ");
INSERT INTO aguBl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ma yi tele'n tiemp nintzun cyaj cyen tilol yi ama'l Néguev. Ej nin chebcun tu' topone'nt le tnum Betel. Itzun yi tele'ntz le tnum Betel nintzun opontz junt tir le ama'l xo'l Betel tu Hai, kale atit tzaj i' yi ntaxk ben Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Yi jun ama'la'tz ya'stzun yi ama'l kale mbnixnakit yi jun patbil xtx'ixwatza'tz ta'n. Yi topone'n, nintzun oc i' tan na'wse'n bi' Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ej nin ncha'tz Lot, chin ric nin i'. Ni'cu'n riquil i' tu wutzile'n Abram yi xonl i'. At wi'nin cneru', wi'nin wacẍ. Ej nin ncha'tz wi'nin mos xomche' te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Poro yi luwar kale najlche't tu Abram qui nin xcye' tan tak'le'n chiwa' cyakil cyawun. ");
INSERT INTO aguBl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Cha'stzun te qui't jal puntil tan chinajewe'n junit, na yi e' pstor Abram tu yi e' pstor wacẍ Lot chilab quib. Wech te yi jun tiempa'tz najlche't nin yi e' aj Canaán scyuch' yi e' ferezeo yi e' chicontr Abram tu Lot. ");
INSERT INTO aguBl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Bene'n tzun talol Abram tetz Lot: “I bin jalu' Lot, kaxonl cunin kib tzawuch', cha'stzun te qui na yub ko at oyintzi' skaxo'l, nin ẍchixo'l ara pstor scyuch' yi e' wetz. ");
INSERT INTO aguBl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Je'j, ilnin cyakil yi ama'le'j. Banaj pawor, txa'aj yi awajbil tan kajatxol kib tzawuch'. Ko na awaj cẍben toque'n tzi'n, ba'n tzun na'j wetz tele'n tzi'n. Ko na awaj cẍben tele'n tzi'n, na'j wetz toque'n tzi'n,” stzun Abram bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Bene'n tzun xmayil Lot yi ẍk'ajlaj kale na icy'ak cu'nt yi a' Jordán. Yi jun ẍk'ajlaja'tz wi'nin a' tul, nin chin yube'n nin. Ej nin cyakil yi luwara'tz jalen le tnum Zoar ni'cu'ntz chi i cunink cojbil Ryos. Ni'cu'n yi jun ama'la'tz chi tane'n yi balaj ama'l Egipto. Ya'stzun tane'n yi jun luwara'tz te yi ntaxk cu xitul Ryos yi ama'l Sodoma tu Gomorra. ");
INSERT INTO aguBl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Je'n tzun xtxa'ol Lot yi jun ẍk'ajlaja'tz kale na icy'ak cu'nt yi a' Jordán. Cho'n tzun taje'n tetz Lot jalen lilen. Ma yi Abram, cho'n tzun cyaje'n cyentz Canaán nicy' yi cwe'n chijatxol quib tu Lot. ");
INSERT INTO aguBl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ma tetz Lot, cho'n tzun taje'ntz tan najwe'n nakajil Sodoma, ẍchixo'l yi e' aldey yi ate' wi ẍk'ajlaja'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Poro yi e' wunak yi najlche' wi jun ẍk'ajlaja'tz, chin mal nin e'. Chin wi'tz juchul il nin e' swutz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Itzun bantz, te yi nsken wi't aj Lot, nintzun jilon Kataj Ryos tetz Abram. Itzun taltz: “I bin jalu' Abram, xmaynin je'n tzi'n, nin cwe'n tzi'n. Ej nin xmaynin tele'n tzi'n nin toque'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Cyakil yi ama'le'j yi na axmaynin, swak'e' tzatz nin scyetz e' ara axonl tetz ben k'ej ben sak. ");
INSERT INTO aguBl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Jepon tajlal ara axonl wa'n chi tane'n yi tajlal yi samlicy' yi at wuxtx'otx'. Cya'l nin jun na xcye' tan tajle'n yi samlicy'a'tz. Ncha'tz cunin ẍchibne' ara xonl, cya'l nin jun nink xcye' tan cyajle'n. ");
INSERT INTO aguBl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ma jalu' quilo'k tan xo'n stzi'ak yi luware'j, yi ja inchaj tzatz, na swoye' tzatz,” stzun Kataj bantz tetz Abram. ");
INSERT INTO aguBl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Toque'n tzun Abram tan wekle'n yi be'ch tetz, nin bentz tan najewe'n nakajil yi tnum Hebrón. Cho'n cyaje'n i' tul jun ama'l tetz jun yaj yi na bi'aj Mamre, kale atit wi'nin wi' bakch. Cho'n tzun toque'n i' tan nuc'le'n junt patbil xtx'ixwatz tan tk'ol i' yi k'ajsbil tetz Kataj. ");
INSERT INTO aguBl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Itzun bantz te yi tiempa'tz yi chijatxol quib Abram tu Lot, at tzaj Amrafel tetz rey yi tnum Sinar. Nin ncha'tz at tzaj Arioc tetz rey yi tnum yi na bi'aj Elasar. Ncha'tz at tzaj Quedorlaomer tetz rey yi tnum yi na bi'aj Elam, nin at tzaj Tidal tetz rey yi tnum yi na bi'aj Goim. ");
INSERT INTO aguBl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Yi cyaj reya'tz e' oc tan oyintzi' tu Bera, rey tetz yi tnum Sodoma, nin te Birsa, rey tetz yi tnum Gomorra, ej nin te Sinab rey tetz yi tnum Adma. Ncha'tz e' oc tan oyintzi' te Semeber, rey tetz yi tnum Zeboim, nin te yi rey tetz yi tnum Bela, yi ncha'tz na bi'aj Zoar. ");
INSERT INTO aguBl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Yi o' reya'tz cho'n tzun chichamol quib scyuch' chisanlar wi jun ẍk'ajlaj yi na bi'aj Sidim, kale atit yi jun mar yi na bi'aj “Yi mar yi chin c'a' nin tan atz'um”. ");
INSERT INTO aguBl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Nsken wi't el coblajix yob yi cyocle'nix jak cawl yi rey Quedorlaomer. Poro itzun bantz tul yi oxlaji'n yob nintzun e' txum yi o' reya'tz tan cyoque'n tan oyintzi' tu Quedorlaomer tan cyele'n klo' liwr jak cawl i'. ");
INSERT INTO aguBl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Itzun bantz, le cyajlaji'n yob nintzun ben Quedorlaomer scyuch' yi e' rey yi xomij chiwi' te'j, tan oyintzi' le jun ama'l yi na bi'aj Astarot Karnaim. Cho'n tzun xcyewe'n i' scye'j yi e' aj Refa le jun ama'la'tz. Ncha'tz xcye' i' scye'j yi e' Zuzitas le ama'l yi na bi'aj Ham. Ej nin xcye' scye'j yi e' aj Emit le ama'l yi na bi'aj Save-quiriataim. ");
INSERT INTO aguBl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ncha'tz xcye' i' scye'j yi e' aj Hor le wi'wtz Seir, nin e' xom nin tan chibiyle'n cu'n jalen wi ẍk'ajlaj Parán, yi cho'n at nakajil yi luwar yi tz'inunin tu'. ");
INSERT INTO aguBl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Yi chipakxe'n tzaj yi rey Quedorlaomer scyuch' yi e' yi xomche' te'j, cho'n tzun cyopone'ntz le ama'l yi na bi'aj En-mis-pat, yi ncha'tz na bi'aj Cades. Ma yi quicy'ake'n le ama'l cwent yi e' xonl k'ajtzun Amalec, cyaj cyen chixitul cyakil e'chk takle'n yi nojquen ẍchiwutz. Ncha'tz ite'n nin e' bantz scye'j yi e' amorreo yi najlche' le ama'l Hazezon-tamar. ");
INSERT INTO aguBl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Ma yi e' rey tetz Sodoma, Gomorra, Adma, Zeboim tu Bela, cho'n tzun chichamwit quib le jun ẍk'ajlaj yi na bi'aj Sidim. Cho'n tzun cyoque'ntz yi o' reya'tz tan oyintzi' tu Quedorlaomer scyuch' yi e' mas rey, yi na chibi'aj Tidal, Amrafel tu Arioc. Ya'stzun yi e' rey tetz tnum Elam, Goim, Sinar tu Elasar. ");
INSERT INTO aguBl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ej itzun le jun ama'la'tz kale mbaje't yi jun oyintzi'a'tz at wi'nin e'chk jul yi nojnak tan ẍpupu'. Ej nin yi cyele'n klo' ojkuj yi e' rey tetz Sodoma tu Gomorra, cho'n chibene'n mulk'uj tul e'chk jula'tz yi nojnak tan ẍpupu'. Ma yi oxt rey, e' el ojk xo'lak xtze' tan colon ib. ");
INSERT INTO aguBl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ma yi e' rey yi sken chitx'acon nintzun e' oc tan telse'n tzaj cyakil yi ixi'n triw, tu e'chk takle'n yi wi'nin jamel yi at le tnum Sodoma tu Gomorra. ");
INSERT INTO aguBl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ncha'tz nin ben quicy'al Lot, yi titz'un Abram yi cho'n najlij Sodoma. Nin cha'tz el quicy'al cyakil yi me'bi'l Lot. ");
INSERT INTO aguBl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","At tzun cobox aj Sodoma yi e' clax cyen chik'ab e' contra'tz. Ej nin jun scyeri e'a'tz opon swutz Abram yi hebrey, tan talche'n tetz yi mbi cu'n bajij Sodom tu Gomorra. Cho'n nin najlij Abram xo'l yi jun c'oloj wi' bakch yi at tuch' yaj yi na bi'aj Mamre, yi amorreo. Quitz'un quitzicy quib i' tu Escol tu Aner. Yi ox yaja'tz xomij chiwi' te Abram. ");
INSERT INTO aguBl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ma yi tbital Abram yi sken ben yi titz'un pres, nintzun octz tan chichamle'n nin tan chiwekle'n yi e' tetz mos yi cho'n quitz'e'n tuch', yi chusijche't tan oyintzi'. Ox cient tu waxaklaj chixone'n e' mosa'tz. Ej nin yi wi't bnixe'n ta'n, nintzun xomnin Abram scyuch' yi e' mosa'tz tan chitz'amle'n yi e' contra'tz. Cho'n chitx'amxe'n cya'n jalen tzi'n le ama'l yi na bi'aj Dan. Ya'stzun chitx'amxe't cya'n. ");
INSERT INTO aguBl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Lak'baline'n tzun cyoque'n Abram tan oyintzi' scyuch' yi e' reya'tz. Qui cunin tzun tz'icy' scyetz yi cyocompone'n Abram tan chibiyle'n cu'n. Ej nin yi cyele'n ojkuj nintzun e' xom nin Abram tan chibiyle'n jalen le tnum Hoba, yi at swutze'n Damasco. ");
INSERT INTO aguBl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Yi xcyewe'n Abram scye'j, nintzun el tzaj majol cyakil yi e'chk takle'n yi nsken el tzaj cyalk'al. Ncha'tz, xcye' i' tan colpe'n Lot tu yi najal i'. Ej nin ncha'tz yi e' mas pres yi ate' ẍchik'ab, e' el tzaj liwr tak'un Abram. ");
INSERT INTO aguBl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Itzun bantz, yi pakxe'n tzaj Abram te yi nsken wi't xcye' scye'j yi rey Quedorlaomer scyuch' e' mas rey yi xomche' te'j, nintzun el tzaj chireyil yi e' aj Sodoma tan c'ulche'n wi jun ẍk'ajlaj yi na bi'aj Save, nka “wi chiẍkajlaj yi e' rey.” ");
INSERT INTO aguBl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ncha'tz opon Melquisedec, yi rey tetz yi tnum Salem, i' jun wi'tz pale' swutz yi Wi'tz Ryos, yi bnol tetz yi wuxtx'otx' tu yi tcya'j. Yi jun pale'a'tz opontz tan c'ulche'n Abram. Nintzun el tzaj tcy'al pam tu win tan toye'n tetz Abram. ");
INSERT INTO aguBl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ej nin tak' i' banltz tib Abram tan yi yole'j: “I bin jalu', tak' tzaj yi wi'tz Ryos, yi jun yi bnon tetz yi tcya'j tu wuxtx'otx', yi banl tzawibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kak'e' kak'ajsbil tetz, na tan tu' yi porer yi wi'tz Ryosa'tz nxcyewe't scye'j e' acontr.” Bene'n tzun tk'ol Abram mu'ẍ oy tetz Melquisedec. Ja toy lajuj te jujun cient te cyakil e'chk takle'n yi ncambaj scye'j e' contr. ");
INSERT INTO aguBl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ma yi rey tetz Sodoma nintzun ben tloltz tetz Abram: —I bin jalu' ta' Abram, qui na waj yi e'chk takle'n yi ncambaju' scye'j e' contr. Teru' sbne' cyakil. Ntin na waj yi e' wunak yi nchiclax tanu', stzun yi rey tetz Sodoma bantz tetz Abram. ");
INSERT INTO aguBl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Saje'n tzun stza'wel Abram: —Qui' ta'. Sak swutz yi Intaj Jehová, yi Wi'tz Ryos, yi ja wi't wal tetz: “Cyakil yi e' wunak tuml yi e'chk takle'n yi mincambaj te'j, tetz chireyil yi e' aj Sodoma sbne'.” ");
INSERT INTO aguBl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Qui na waj siquierk jun tal piẍ nok' nka jun tal tz'u'm tan c'alche'n wutz inxajab. Na qui na waj yil tz'ocu' tan talche'n: “In nchinjalsan riquil nocx Abram.” ");
INSERT INTO aguBl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Qui na waj nink tzintz'ame'n jun e'chk takle'n te yi mincambaj, ma na ntin yi mu'ẍ ixi'n yi ja wi't xcon tetz chigast e' inmos. Poro yi ox yaje'j yi ja chich'eyan swe'j, yi na chibi'aj Aner, Escol tu Mamre, tajwe'n jatxlij cyetz te yi e'chk takle'n yi ja kaxcye' tan majle'n scyetz e' kacontr, stzun Abram bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Itzun bantz yi nsken bajij cyakil e'chk takle'na'se'j, nintzun jilon Kataj tetz Abram le wutzicy'. Itzun taltz: —Abram, quil cxob te yi mbi sbajok tzawe'j, na in colol awetz. Ej nin swak'e' jun balaj oy tzatz. ");
INSERT INTO aguBl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Talol tzun Abram tetz Jehová, yi Cawl tetz: —Ilu' Kataj, ilu' Cawl wetz, chumbalaj nin yi jun oya'tz yi na tzanu' tan suki'n swetz, poro qui'c ltak' swetz na na tilu' yi qui'c jun tal ẍutuj incy'ajl. Yi nink ltak'u' jun tal incy'ajl, tetz klo' i' sbne' cyakil yi inme'bi'l. Ma na yi jun yil scambok te'j i'tz Eliezer, yi martoma' squibaj e' inmos, i' awer nak tu', na i' jun aj Damasco. Nin i' jun esclaw tu', stzun Abram tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","—Qui', nk'e'tz jun awer nak scambank yi ame'bi'l na yi jun yil tetzaj cyakil ame'bi'l i'tz jun mero acy'ajl, stzun Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Tele'n tzaj tzun tcy'al Kataj yi Abram xe tal pach, yi mantial tu', itzun taltz: —Il nin e'chk tx'uml yi ate' tcya'j. Cya'l jun yi nink xcye' tan tajle'n, na jun c'oloj cunin e'. Cha'tz cunin ẍchibne' tajlal araxonl. Cya'l jun xcye'k tan cyajle'n, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Tocsal tzun Abram cyakil yi mbi cu'n tal Ryos tetz. Ej nin tantu' yi tocsal, wi'nin tzun stzatzine'n Ryos te'j. Cha'stzun te jale'n yi balajil i' swutz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Bene'n tzun tlol Ryos tetz Abram: —I ina'tz in Jehová. Ej nin i ina'tz yi jun yi ncẍe'lsan tzaj le ama'l Ur, chicwent e' caldeo, tan wuk'ol yi ama'le'j tzatz. ");
INSERT INTO aguBl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","—Ta', ilu' Cawl wetz, ilu' Kataj Jehová. Poro cuyu' impaj, ¿ẍe'n tz'el intxum tetz yi kol swetzaje' cyakil yi ama'le'j? ");
INSERT INTO aguBl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Stza'wel tzun Ryos tetz: —Cy'ajwe'tzaj jun tal ne'ẍ wacẍ, nin jun chiw, nin jun tal ne'ẍ cne'r tan ox yob yi jujun. Ej nin cy'aj tzaj jun tal slu'k tu jun tal ne'ẍ plomẍ. ");
INSERT INTO aguBl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Saje'n tzun tcy'al Abram yi e' txuca'tz swutz Kataj Ryos. Ej nintzun e' cu' cabsal, nin cu tk'ol jalajchak wuxtx'otx'. Ej nin swutz yi jalaja'tz, cu tk'ol jalajtz. Ma yi slu'k tu tal ne'ẍ plomẍ, qui e' cu' cabsaltz. ");
INSERT INTO aguBl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Itzun yi e' ku's nintzun e' baj cu'ultz tan bajse'n klo' chiwankil e' txuca'tz. Poro nin oc Abram tan chilaje'n len. ");
INSERT INTO aguBl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ma yi cwe'n yup, nsken tzun k'e'xij i', nin saj jun chin watl te'j. Nin chin tz'o'tz nin tunin tzun bantz xlaj. Nintzun saj jun chin xo'w te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Bene'n tzun tlol Kataj tetz: —Tajwe'n yil tz'el atxum tetz yi xtxolbile'j. Ẍchinajank araxonl ẍchixo'l jun tx'akaj awer nak tetz cyaj cient yob. Chocopon araxonl tetz chimos yi e' awer naka'tz nin ẍchibuchlok cya'n. ");
INSERT INTO aguBl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Poro swak'e' chicaws yi e' awer naka'tz tan paj yi chocopon yi e' araxonl tetz chimos. Poro yil tz'ak yi cyaj cient yoba'tz cya'n, chelepon liwr, nin chin ric nin ẍchibne'. ");
INSERT INTO aguBl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ma aẍ awetz Abram, yil cẍtijin cu'n, tzatzin cu'n lẍquim nin cẍa'j scye'j k'ajtzun ataj, tu k'ajtzun atxu'. ");
INSERT INTO aguBl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Yi sken wi't icy' cyajix wekl araxonl ẍchipakxok junt tir le ama'le'j. Quil chu'l chan, na txe'n opon k'ejlal yil jepon tamp yi ẍch'onal yi quil yi e' wunak yi najlche' tzone'j, yi e' amorreo, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Itzun yi toque'n ak'bal, chin tz'o'tz nin tu nin bantz. Nintzun ẍchaj tib jun ẍwok' yi wi'nin na juquin sib tul, tu jun k'ak'. Ja chixon nicy'al yi chiwankil yi e' txuca'tz yi cabsa'nche' tan Abram. ");
INSERT INTO aguBl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ya'stzun yi bixewe't yi trat Ryos te'j Abram. Ej nin je yol Ryose'j: —Cyakil yi luware'j swak'e' scyetz yi e' araxonl. Xe'tok tzaj stzi' a' cwent Egipto, nin tz'elepon jalen lilen tzi'n, stzi' yi nim a' yi na bi'aj Eufrates. ");
INSERT INTO aguBl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","I'tz chiluwar yi e' ceneo tu e' cenezeo nin scyuch' e' cadmoneo, ");
INSERT INTO aguBl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","nin chiluwar e' hitita nin e' ferezeo scyuch' e' rafaíta, ");
INSERT INTO aguBl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","e' amorreo tu e' cananeo nin e' gergeseo, scyuch' yi e' jebuseo. Tircu'n yi e'chk ama'la'tz swak'e' scyetz araxonl, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Itzun bantz yi tele'n tiemp quinin tzun jal tal Sarai yi txkel Abram na qui'c talbil i'. Poro at tzun jun mos i' yi najlij scyuch', yi aj Egipto i', nin yi bi' i' i'tz Agar. ");
INSERT INTO aguBl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Bene'n tzun tlol Sarai tetz Abram: —Qui nin ntak' Ryos ama'l swetz tan chijale'n wal, cha'stzun te na cu' inwutz teru' ta' tan cyok'bel quibu' tu inmos Agar, nin yil jal chinitxajilu' tuch' ba'n tzun tz'octz chi k'ajbil wal. Nintzun cu'-tz swutz Abram yi xtxumu'n Sarai. ");
INSERT INTO aguBl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ej nintzun saj tcy'al Sarai yi mosa'tz tetz Abram. Yi baje'n yi xtxolbila's ya'stzun yi nsken el lajujix yob yi chinajle'nix Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Itzun yi chiwitbej quib Abram tu Agar nintzun tekaj pwokil jun ni'. Poro yi tele'n xtxum Agar tetz yi ẍe'n tane'n i', nintzun oc tan xbajtzije'n Sarai yi patrón. ");
INSERT INTO aguBl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ma Sarai nintzun taltz tetz Abram: —Aẍ aj paj yi na tzan Agar tan telse'n ink'ej wech na in te'nin nnak'on tzatz tan toque'n tetz awuxkel, ma jalu' tantu' yi sjalok tal, na tocsaj tib nim tzinwutz. Nin qui'c wetz inxac swutz i'. Ma jalu' cho'n sak swutz Ryos na'j scyetz aj paj skaxo'l tzawuch', aẍ pelo' atz nka in tzun wetz, stzun Sarai tetz Abram. ");
INSERT INTO aguBl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","—Yi amos cho'n at jak aca'wl, banaj bin awajbil te'j, stzun Abram bantz. Yi tbital Sarai yi yol Abram nintzun xe'tijtz tan jisle'n nin tan buchle'n Agar, jalen cu'n yi tele'n ojkujtz. ");
INSERT INTO aguBl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Itzun te yi tele'n ojkuj Agar, cho'n tzun noje'n quen i' swutz jun ángel tetz Ryos le jun ama'l yi tz'inunin tu', xlaj jun tal bo'm, cy'anl tetz yi be' yi na opon jalen Shur. ");
INSERT INTO aguBl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Nintzun ben jakol yi ángel tetz: —¡Agar! Aẍ jun c'oloj mos Sarai, ¿Na ncẍsaje't, nin na' ncẍbene't? stzun ángel Ryos tetz Agar. —Ojke'n bin mimbane'ltzaj wetz swutz wutzile'n na' Sarai yi impatrón. ");
INSERT INTO aguBl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Bene'n tzun tlol yi ángel tetz Ryos tetz: —Quilo'k, ba'n ẍpakxijt tuch' yi apatrón nin nque'n c'ulutxum jak' ca'wl i'. Nin ba'n tzaban cyakil yi mbil tal i' tzatz. ");
INSERT INTO aguBl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ej ncha'tz tal yi ángel tetz Ryos tetz: “Ẍchipuc'unk cyakil yi e' axonl wa'n, nin cya'l nin jun nink xcye' tan cyajle'n. ");
INSERT INTO aguBl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Bintzij nin, eka'n pwokil jun ni' awa'n. Ej nin xicy sbne' yi awal. Nin yil tz'ul itz'ok ba'n tz'oc bi' awa'n tetz Ismael. Ya'stzun bi' sbne'-tz na ja opon to'k yi atzi' yi akul swutz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Chin macle'n nin sbne' yi awal. Ni'cu'n sbne' tu jun txuc yi chin smaron nin. Stz'oyintzink scye'j cyakil wunak. Ej nin cyakil wunak ẍchoyintzink te'j i'. Yi e' xonl i' ẍchijunaje' quib scyuch' e' titz'un. Ej nin cho'n ẍcha'tok jalen lilen tzi'n,” stzun ángel bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ej nin tantu' yi ja chijilon Agar tu Kataj nin jalt junt bi' Ryos ta'n. Ej nin i'tz: “Yi Ryos yi na ko' til.” Na nin tal i'-tz “Ja chin til Ryos, poro qui nin nchinquim ta'n, na itz'ine't.” ");
INSERT INTO aguBl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Cha'stzun te toque'n bi' yi jun a'a'tz ta'n tetz: “A' tetz yi jun yi itz', nin yi na ko' til.” Yi jun a'a'tz cho'n at xo'l Cades tu Bered. ");
INSERT INTO aguBl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ej itzun bantz yi tule'n yos tu Agar, nintzun oc tk'ol Abram yi bi' yi ni' tetz Ismael. ");
INSERT INTO aguBl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","At tzun Abram tul jun mutx' tu kak yob yi titz'e'n Ismael. ");
INSERT INTO aguBl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Itzun te yi at tzaj Abram tul jun mutx' tu belujlaj yob, nintzun ẍchaj tib yi Kataj Jehová junt tir swutz i'. Itzun taltz tetz: —I ina'tz yi Ryos yi cya'l jun na xcye' swe'j. Ej nin yi wajbil i'tz yil cẍo'c tetz jun yaj yi chin tz'aknak cu'n, yi qui'c mu'ẍ tal paltil. ");
INSERT INTO aguBl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ej nin ko ya'tz tzaban, bixek cunin jun contrat skaxo'l tzawuch'. Je xtxolbile'j: chijepon impuc'sal wi'nin axonl, stzun Ryos bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Te yi na tzan Ryos tan yol cwe'n tzun joklok Abram jalen cu'n yi cwe'n pone'n yi wutz plaj wuxtx'otx'. Ej nin ncha'tz tal Ryos: ");
INSERT INTO aguBl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","—Ẍocopon wa'n tetz chitaj wi'nin jilwutz wunak. ");
INSERT INTO aguBl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ej nin yi abi' nk'e'tz Abram sbne' ma na Abraham, na cẍocopon tetz chitaj wi'nin jilwutz wunak. ");
INSERT INTO aguBl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ẍchipuc'unk cyakil yi araxonl wa'n. Qui nin ajlbe'n cyetz sbne'. Ej nin tan aẍ ẍchijale't wi'nin wi'tz ajcaw nin wi'nin lmak tnum. ");
INSERT INTO aguBl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ej nin yi contrate'j yi bixek cu'n skaxo'l stzawuch' nin scyuch' e' araxonl tzantzaj, i'tz, yi in te'nin iRyosil sbne', scyuch' araxonl tetz ben k'ej ben sak. ");
INSERT INTO aguBl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Swak'e' tzatz cyakil yi luware'j cwent Canaán kale najlquixe't jalu'. Ncha'tz swak'e' scyetz e' araxonl tetz ben k'ej ben sak. Ej nin yi in wetz in iRyosil sbne'-tz. ");
INSERT INTO aguBl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","—Ej nin na waj yil tzaban tane'n yi xtxolbile'j yi swale' cyen tzatz. Ej nin ncha'tz yi e' axonl tajwe'n yil chixom te'j sbne' opon tunintz. ");
INSERT INTO aguBl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Je yi xtxolbile'j yi na waj tzibanwok tane'n scyuch' yi e' axonl: Tajwe'n tan chibaje'n circuncidar cyakil yi e' yaj tzixo'lwok. ");
INSERT INTO aguBl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ba'n bin tzic'aplen mu'ẍ tal te yi stz'uml iwankil, na yi techla'tz xconk tan ẍchajle'n yi ja bixe' yi katrate'j skaxo'l tzituch'. ");
INSERT INTO aguBl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Sbne' opon tunintz tajwe'n tan chibaje'n circuncidar cyakil yi e' xicy yi na chitz'ij tzixo'lwok. Mpe chicy'ajl yi e' imos yi lok'ij che't ita'n scyetz awer nak. Tajwe'n tan chibaje'n len circuncidar. Banwok yi xtxolbile'j le waxaki'n k'ej yi titz'le'nix jun ni'. ");
INSERT INTO aguBl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Tajwe'n tan chibaje'n circuncidar yi e' anitxa' scyuch' e' chinitxa' yi e' amos yi lok'ijt che' awa'n. Ej nin yi jun techla'tz yi tz'ocopon te iwankil ya'stzun xe' incontrat yi ja bixe' wa'n tzituch' tetz ben k'ej ben sak. ");
INSERT INTO aguBl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Poro ko at jun tzixo'lwok yi quil sban tane'n inca'wle'j chin tajwe'n cunin tan tele'n laju'n tzixo'l wok, na i' pajol ca'wl. ");
INSERT INTO aguBl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ncha'tz tal Ryos tetz Abraham: —Inti Sarai yi awuxkel qui't lbi'aj Sarai, ma na sbi'ajk Sara. ");
INSERT INTO aguBl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Swak'e' imbanl tibaj, na cho'n stz'itz'ok acy'ajl te'j. Jun cu'n yol swak'e' imbanl tibaj, na tz'ocopon i' tetz chitxu' jun c'oloj jilwutz wunak. Ej nin ẍchixo'l yi xonl i' ẍchijalo'k wi'nin wi'tz ajcaw, nin wi'nin lmak tnum, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Cwe'n tzun joklok Abraham swutz Ryos jalen cu'n cwe'n pone'n lajpuj yi plaj wuxtx'otx'. Ej nin te yi joklij, nintzun saj jun chin tze'e'n te'j, tc'u'l cuntu': “Iẍkaj at tzunk rmeril tan jale'n innitxa' na na chinxon tul jun cient yob. Ncha'tz Sara, iẍkaj atk rmeril tan talal jun tal, na na xon i' tul jun mutx' tu lajuj yob,” stzun Abraham. Wi'nin tzun stze'ene'n i'-tz tc'u'l cuntu'. ");
INSERT INTO aguBl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Jilone'n tzun Abraham tetz Ryos, itzun taltz: —Chumbalaj nin klo' Ta' yi cho'nk ltak'u' banlu' tibaj Ismael. ");
INSERT INTO aguBl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Stza'wel tzun Ryos yol Abraham: —Jun cu'n yol na walnin tzatz, stz'itz'ok jun acy'ajl te'j Sara, yi mero atz awuxkel. Nin ba'n tzawak' quen bi' tetz Isaac. Na te'j i', nin scye'j xonl i', lbixewe't yi trate'j tetz ben k'ej ben sak. ");
INSERT INTO aguBl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","”Inti tetz Ismael, swak'e' imbanl tibaj. Sjalok wi'nin nitxajil i' wa'n. Tz'ocopon i' tetz chitaj coblaj wi'tz ajcaw. Nin tan i' ljale't jun chin wutzile'n tnum. ");
INSERT INTO aguBl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Poro yi wetz intrat cho'n sbixek wa'n tu Isaac yi acy'ajl, yi cho'n tz'itz'ok te'j Sara chwa'nin le junt yob, stzun Ryos bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Yi stzaje'n wi' yol Ryos tu Abraham aje'n nintzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Itzun te ite'n nin k'eja'tz toque'n Abraham tan banle'n circuncidar Ismael scyuch' cyakil yi e' mos yi nchitz'ij tuch', cyuml yi e' yi lok'ij che' ta'n. Tircu'n tzun e' yaja'tz e' bajij circuncidar ta'n, quib yi tal Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","At tzaj tzun Abraham tul jun mutx' tu belujlaj yob yi banol circuncidar tib. ");
INSERT INTO aguBl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ma Ismael at tul oxlaj yob yi baje'n circuncidar. ");
INSERT INTO aguBl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ite'n nintzun k'eja'tz yi chibnol tane'n Abraham tu Ismael yi circuncisión. ");
INSERT INTO aguBl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ej nin ncha'tz cyakil yi e' yaj yi najlche' tu Abraham, e' bajij circuncidar, tuml yi e' mos yi e' itz'ij tuch', scyuch' cyakil yi e' mos yi lok'ij che' ta'n, tircu'n tzun e' bajij circuncidar te yi jun k'eja'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Itzun bantz te yi at tzaj Abraham wi'wtz xo'l bakch cwent Mamre. Cho'n tzun ẍchajol tib Ryos swutz Abraham. Cho'n tzun c'olchij swutz tal pach yi mantial tu'. E'chk chajcu'n k'ej nin lo'. ");
INSERT INTO aguBl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Te yi c'olchij i', nintzun ben xmayil ox yaj yi txiclche' nakajil. Lajke'l nintzun bene'ntz tan chic'ulche'n, nin cu' jokloktz ẍchiwutz. ");
INSERT INTO aguBl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Itzun taltz: —Wajcaw, max c'u'lu', in ẍchakumu', na cu' inwutz teru', yi qui'k tz'icy' chanu', nink cyaju' jun rat swuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","¿Qui pe' na cyaju' yi nink ben q'uil tetz mu'ẍ a' tan xtx'ajle'n quikanu' nin lchuje'u' jun tkuj tmujil jun wi' tze'e'j? ");
INSERT INTO aguBl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","¿Qui pe' na cyaju' yi nink chimben tan ticy'le'n tzaj cobox chiwa'u'? Na ja lo' chik'e'xiju' nin na lo' chiquimu' tan we'j. Ba'n tcu'n chiwank ninu', na ja bin chu'lu' swuch', stzun Abraham scyetz. —Ba'n bin, che'ch e' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Lajke'l nintzun bene'n Abraham xe chipach nintzun taltz tetz Sara: —Or cy'ajtzaj cob arow arin, nin or tzawoque'n tan xyulk'e'n. Ej nin banaj cobox kapam, nin tzask'ajsaj tan yi xew k'ak' yi at cyentz. ");
INSERT INTO aguBl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ntin nin xtalol tzaj Abraham tetz Sara, lajke'l nintzun bene'ntz kale ate't yi wacẍ i', nin je' xtxa'ol jun tal ne'ẍ wacẍ, nin tak'tz tetz jun scyeri mos tan toque'n tan banle'n ba'n tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ma yi bnixe'n chiwa', nintzun bentz tan tak'le'n scyetz yi e' yaj. Poro nk'e'tz ntin chi'baj tu pam tak' scyetz ma na ncha'tz tak' i' ques tu lech. Ej nin te yi na chiwan yi ox yaja'tz tmujil tze', list cuntunin tane'n Abraham ẍchiwutz na ko tak'le'n bi' chijak tzaj tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ej, itzun yi chiwi't wane'n nintzun e' octz tan jakle'n tetz Abraham. Itzun cyaltz: —¿Na' atite't Sara yi awuxkel? —At i' tzi'n xe kapach. ");
INSERT INTO aguBl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Bene'n tzun tlol jun scyeri ox yaja'tz. —I bin jalu' Abraham, chwa'nin le junt yob nu'lt jun tir tan axajse'n. Ej nin yil nu'ltzaj, nsken wi't jal jun tal Sara, stzun yaj bantz. Ma yi Sara cho'n tzun na xk'ukene'l tzaj wutz coc yi puertil chipach tan tbite'n chiyol yi ox yaja'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Poro te yi tiempa'tz nsken wi't chitijin cunin Abraham tu Sara. Sken wi't tzaj wi' yi yablil Sara. ");
INSERT INTO aguBl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Yi tbital Sara yi yola'tz quib yi tal yaj tetz Abraham, nintzun saj jun chin tze'e'n tc'u'l cuntu'. Ej nin cha'tz nin xtxum i'-tz: “¿Mbi rmeril jal jun wal? Na ja wi't chimbi'ẍin cunin, nin ncha'tz tane'n wutzile'n wajcaw Abraham,” stzun i' bantz tc'u'l cuntu'. ");
INSERT INTO aguBl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Bene'n tzun jakol Kataj tetz Abraham: —¿Mbi xac na tze'en Sara te inyol? Na ja tal i' tc'u'l cuntu': “¿Mbi rmeril tan jale'n jun wal? na ja wi't chimbi'ẍin cunin.” ");
INSERT INTO aguBl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Poro swale' tzatz: ¿At pelo' jun e'chk takle'n yi quil xcye' Ryos te'j? Ma jalu' Abraham, chwa'nin le junt yob nu'lt junt tir tan axajse'n. Ej nin yil nu'lt, nsken wi't jal jun tal Sara, stzun Ryos bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Yi tbital Sara yi yol Ryos nintzun xob i'-tz nin taltz: —Qui' Ta', qui na chintze'en wetz. —Nk'e'tz bintzij na awaltzaj. Cẍchij tu', na jun cu'n ja cẍtze'en, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Itzun yi stzaje'n wi' chiyol, chije'n tzun txiclok yi ox yaja'tz nin e' icy'tz tan cyopone'n Sodoma. Xom nin jun tkuj Abrahamtz scye'j. ");
INSERT INTO aguBl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nintzun oc Ryos tan xtxumle'n: “Ba'n tcu'n swale' tetz Abraham clar cunin yi mbi'tz tzimbne'. ");
INSERT INTO aguBl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Na tan i' ljale't chibanl cyakil wunak bene'n tzi'n wi munt. ");
INSERT INTO aguBl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ej nin cha'tz txa'ijt i' wa'n tan toque'n tan chicawe'n yi e' tetz nitxajil scyuch' yi e' xonl, tan cyoque'n jak inca'wl nin tan chibnol cyakil e'chk takle'n balaj, bantz wele'n cu'n te'j cyakil yi ja wi't insuk tetz,” stzun Ryos tc'u'l cuntu'. ");
INSERT INTO aguBl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Saje'n tzun tlol Ryos tetz: —Ma jalu' Abraham ja wit jun xtxolbil yi cyakil yi e' wunak yi najlche' Sodoma tu Gomorra, chin juntlen nin e' tu cyajtza'kl. ");
INSERT INTO aguBl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Cho'n tzun nchimbentz tan quilwe'n yi ko bintzij nin yi chin cachi' nin e', nin yi ko chin juntlen nin cyajtza'kl quib yi mma'lchij swetz, stzun Ryos bantz tetz Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Cho'n tzun chibene'n cob scyeri yi e' yaja'tz jalen Sodoma. Ma tetz Abraham nintzun cyaj cyen tan yol tetz Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Toque'n tzun ẍkansal tib mu'ẍt swutz Ryos nintzun oc tan jakle'n: —Ta' yil tz'ocu' tan chibiyle'n yi e' juchul il ¿ẍchitzajk cunin polo' yi e' yi qui'c quil? ");
INSERT INTO aguBl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Na qui cunin batz at nicy' cient wunak Sodoma yi qui'c cyetz quil. ¿Stzajk cunin polo' cyakil yi tnuma'tz tanu'? ¿Qui polo' scuyu' chipaj tan tu' yi ko at nicy' cient balaj ẍchixo'l? ");
INSERT INTO aguBl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Qui' lo' Ta', na el intxum teru' yi quil sbanu' yi juna'tz yi tul chitz'aben nin tu' e' balaj wunak scye'j yi e' juchul il, na nk'e'tz nicy' nin tu' e' juchul il. ¡Quil sbanu' juna'tz Ta'! Na yi ilu' teru' ilu' jun balaj juez yi chin tz'aknak cu'n. Nin yi ilu' teru' quil xubsiju' tan chibanle'n tane'n cyakil wunak bene'n tzi'n wi munt. Ej nin ko ya'tz, nink che' jatxcyenu' e' balaj. Ntink e' juchul il che' cawsaju', stzun Abraham tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Stza'wel tzun Ryos yi yol Abraham itzun taltz: —Yi nink chijal nicy' cient wunak wa'n yi nk'e'tz e' juchul il, tan tu' yi nicy' cienta'tz tzincuye' chipaj cyakil e' aj Sodoma, stzun Ryos tetz Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Jilone'nt tzun junt tir Abraham tetz Ryos. Itzun taltz: —Cuyu' impaj Ta', qui'c nin intx'ix yi na chinjilon quen teru', nin yi na injak quen yi e'chk takle'na'tz teru'. Na yi ilu' teru', ilu' Ryos, yi ca'wl wetz, ma yi in we'tz in tu' wunak, in tu' tx'otx', qui'c eka'n wa'n. ");
INSERT INTO aguBl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Poro Ta' yi ko ca'wunak o'-te'n yi qui tz'aknak yi nicy' cienta'tz, ¿ẍchitzajk cunin polo' cyakil yi e' wunaka'tz tanu' tan tu' yi ca'wunak o'-ta'tz yi qui'ct? Stza'wel tzun Kataj yi yol Abraham: —Yi nink chijal ca'wunak o' wa'n yi nk'e'tz e' juchul il, quil chisotz wak'un. ");
INSERT INTO aguBl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Jakol tzun Abraham junt tir: —¿Ma tzun yi ko at ca'wunak ntzi' yi nk'e'tz e' juchul il? —Quil che' insotzaj tantu' yi ca'wunaka'tz, stzun Kataj bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Bene'n tzun jakol junt tir Abraham tetz Ryos itzun taltz: —Cuyu' impaj Ta' na cu inwutz teru' yi qui'k lje' swutzu' yi chin ch'inch'uj nin tu' nin in tan jakle'n quen ite'n nin xtxolbila'tz teru'. Poro ¿mbi tzun sbanu'-tz yi ntink junaklaj ntzi' balaj lchijal tanu'? Stza'wel tzun Katajtz, itzun taltz: —Yi nink chijal junaklaj balaj wa'n, tan tu junaklaja'tz tzincuye' chipaj yi e' mal nak nin quil chisotz wa'n. ");
INSERT INTO aguBl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Toque'n tzun jakol Abraham junt tir tetz Ryos itzun taltz: —Ilu' Wajcaw, qui'c nin intx'ix yi na injakquen yi e'chk takle'ne'j teru'. Poro ¿mbi' sbanu' yi ntink junak ntzi' balaj lchijal tanu'? Saje'n tzun tza'wel Ryos tetz: —Yi nink chijal junak ntzi' balaj wa'n quil chisotz yi e' wunaka'tz wak'un. Tzincuye' chipaj. ");
INSERT INTO aguBl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Chin ch'inch'uj nintzun ban Abraham tan yol tetz Ryos i tzun taltz: —Ilu' Wajcaw cuyu' impaj qui'k tz'oyintzin c'u'lu' swe'j yi na chin jilonquen teru', poro jalta'tz wi'tzbil tir yi tzinjake' teru', nin qui't tzinxuxu' mas. ¿Mbil sbanu' yi ko ntin lchijal lajuj ntzi' balaj tanu'? Saje'n tzun stza'wel, i tzun taltz: —Yi ate' nink yi lajuj balaja'tz ẍchixo'l, quil chisotz wa'n. Tzincuye' chipaj, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yi wi't chijilone'n Ryos tu Abraham aje'n nintzun ban i'-tz. Ma Abraham nin pakxijtz xe pach yi mantial tu'. ");
INSERT INTO aguBl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Itzun bantz yi nsken oc yupcan yi cyocompone'n yi cob ángela'tz le tnum Sodoma. Cho'n tzun c'olchij Lot tzi sawanil yi tnum kale na chimolwit quib cyakil yi e' wunak. Jalt cuntunin yi chibene'n tilol yi cob ángela'tz nintzun je txicloktz tan chic'ulche'n. Nin cu jokloktz ẍchiwutz. ");
INSERT INTO aguBl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Nintzun taltz scyetz: —E'u' wajcaw, max chic'u'lu' swibaj. Yi in wetz, in chixconsbe'tzu'. Ej nin na cu' inwutz scyeru' tan chicyaje'n cyenu' xe' inca'l te ak'bale'j. Choktzaju' swuch', na at a' tan xtx'ajle'n quikanu'. Nin eklen jalchan chicy'ajtu' chibe'u', stzun i' bantz scyetz. Saje'n tzun chitza'weltz, itzun cyaltz. —Qui' lo' ta', ntyoẍtu' teru'. Ba'n tcu'n kawitok cyen ketz tbe' te jun ak'bale'j. ");
INSERT INTO aguBl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Poro quinin tzun tane' Lot tan chimoxe'n jalen cu'n chicujij tan chicyaje'n cyen xe ca'l i'. Ej itzun yi cyocopone'n xe' ca'l nintzun cawunin Lot tan banle'n chiwa'-tz. Bnix pam yi qui'c xtx'amil. Ej nin yi bnixe'n, nintzun e' wan yi cob aj xajsanla'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ej itzun te yi ntaxk chinuc' quib tan watl cyopone'n tzun nil cyakil e' yaj cwent Sodoma swutz yi ca'l Lot. Cyakil yi e' xicy scyuch' yi e' biẍu' e' baj opontz. ");
INSERT INTO aguBl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Chixe'te'n tzuntz tan sich' tetz Lot. Itzun cyaltz: —Lot, ¿la'kbe' cob yaj yi nchixom quen tzawe'j xe aca'l te jun ak'bale'j? ¡Cy'ajwe'ltzaj! na na kaj kawitbej kib scyuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Telemule'n tzun Lot tan yol scyetz, poro te yi tele'n tzaj cy'a'nt nin jople'n yi puert ta'n, nin cyaj cunin lajpultz. ");
INSERT INTO aguBl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Bene'n tzun tloltz scyetz: —E'u' jun c'oloj wamiw quil chibanu' yi e'chk takle'na'tz scye'j cob intxocuma'tz, na qui na yub cyajtza'klu'. ");
INSERT INTO aguBl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ate' bin cob wetz inme'l yi txe'n cunin chipo'tzaj quib te jun yaj. ¿Qui pe' na cyaju' yi nink che' incy'aje'l tzaj tan chibnolu' yi cyajbilu' scye'j? Na qui na waj yi nink chibanu' jun e'chk takle'n yi chin juntlenin scye'j yi cob intxocum. ");
INSERT INTO aguBl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Saje'n tzun chitza'wel cyakil yi e' wunaka'tz. Itzun cyaltz: —¡Cawle'n tzaj! Caje'n tzi be', na kocopon. ¿Nka kocopon ptzun ketz jak aca'wl? Aẍ tu' awer nak. ¿Nka na tzun awaj yi aẍ cẍben tc'u'l yi mbi na kaj tan kabnol scye'j atxocuma'tz? Xe'te'n nintzun e' ban tan jisle'n Lot nin e' octz tan pok'le'n quen puert. ");
INSERT INTO aguBl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ma yi cob txocuma'tz, lajke'l nintzun je'n chijakol yi puert nin oc chikinol Lot xe ca'l, nin lajke'l nin tele'n chilajpul. ");
INSERT INTO aguBl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ej nin cyakil yi e' wunaka'tz yi ate' solte'j puert e' cyaj cyen moyi'ẍ cya'n, chicyakil yi e' xicy scyuch' e' biẍu'. K'e'xe'n nintzun e' bantz tan joyle'n yi puertil yi ca'l. ");
INSERT INTO aguBl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ma yi e' xtxocuma'tz, nintzun ben chijakol tetz Lot: —¿Ate' pe' mas axonl tzone'j? Ko at acy'ajl nka ame'l, e' aji' nka alchok axonl le tnume'j, molwe' len nin quilo'k scyuch' joylaj. ");
INSERT INTO aguBl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Na copon kaxitul cyakil yi ama'le'j. Nimix cunin xocho'n opon swutz Ryos scye'j e' aj Sodomaje'j. ");
INSERT INTO aguBl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Bene'n tzun Lot tan quilwe'n yi e' ji'-tz poro ntaxk cyok'bej quib tu me'l, ntin nsken bnix chitrat. Itzun ben tlol scyetz: —¡Yaj cale'nwok tzaj! Nuc'wok itib, nin quitele'nk. Ilwok quen yi ama'le'j, na copon xitul Kataj Ryos. Poro qui nintzun cyajlajtz yi yol Lot yi tal scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Itzun te yi txant tan tule'n skil, nintzun e' jilon yi e' ángela'tz tetz Lot, itzun cyaltz: —Or awetz Lot, nuc'aj awib nin cy'ajwe' len yi awuxkel scyuch' yi cob ame'l tan qui iquime'n tzone'j na copon kasotzal cyakil yi tnume'j. ");
INSERT INTO aguBl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Poro tantu' yi quinin nuc'x chan tib Lot, chibene'n tzun yi e' ángel tan ẍch'ine'n e'ltzaj yi k'ab, na nin el k'ajab Kataj Ryos te'j. Ej nin ncha'tz ban yi txkel scyuch' yi e' me'l. Ej nintzun e' el quicy'altz solte'j len yi tnum tan cyele'n liwr. ");
INSERT INTO aguBl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Te yi nsken wit che'l tzaj joylaje'l tzaj yi tnum, at tzun jun scyeri yi e' ángel tal scyetz: —¡Quilo'k lajke'l tan iclaxe'n! Nin quil cxmayin tzajwok wutz icoc. Nin quil xtaque' cu'nwok siquier jun tal tkuj le ama'le'j, ma na cyenin cxbenwok xo'l wutz. Ojke'l ninwok tan itopone'n wi'wtz tan iclaxe'n. ");
INSERT INTO aguBl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","—¡E'u' jun c'oloj wajcaw, max chic'u'lu' swibaj! ");
INSERT INTO aguBl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Bintzij nin nimix pawor nchibanu' swetz. Nin chumbalaj nin banl cyalma'u' swibaj tan inclaxe'n. Poro chicuyu' impaj. Qui na waj yil chimben xo'l wutz. Na ko tzun quil kopon chan, nin skatx'amxok tak'un yi caws yi cupon cyak'unu'. ");
INSERT INTO aguBl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Poro je jun tal juy tnum at naka'j chone'j. Nink cyak'u' ama'l sketz tan kopone'n tul, bantz kaclaxe'n, na i'tz jun tal juy tnum, stzun Lot scyetz e' ángel. ");
INSERT INTO aguBl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Bene'n tzun tlol jun scyeri e' ángela'tz: —Ja wit yi mbi' majak swetz. Swak'e' bin ama'l tzitetz tan ibene'n tc'u'l, na quil sotz yi jun tnuma'tz wa'n. ");
INSERT INTO aguBl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Poro or itkan, na qui'c rmeril tan imbnol jun takle'n te ntaxk cxopon wok le jun tnuma'tz. Cha'stzun te toque'n bi' yi jun tnuma'tz tetz Zoar. ");
INSERT INTO aguBl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Itzun yi tule'n skil sken tzun opon Lot le tnum Zoar. ");
INSERT INTO aguBl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Saje'n tzun kojol Kataj jun chin k'ak' tcya'j yi asufre cu'n. Cho'n tzun cwe'n squibaj yi tnum Sodoma tu Gomorra. ");
INSERT INTO aguBl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Cyakil cunin tzun chisotze'n yi e' wunak yi ate'-tz. Nin cyakil e'chk takle'n yi at tc'u'l yi jun ama'la'tz, sotz tera'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Itzun yi txkel Lot yi xomij te'j, yi cyele'n tzaj ojkuj, nintzun xmayinin i' wutz coc. Ej nin yi xmayine'n nin, nta'tz te'n nin oc cyen tetz jun tunuj c'ub atz'um. ");
INSERT INTO aguBl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ma le junt eklok, jalchan cunin tzun bene'n Abraham kale e' jilone't tu Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nintzun ben xmayil i' yi tnum Sodoma tu Gomorra tu cyakil yi ẍk'ajlaj yi at-tz, nin tibaj cyakil ama'la'tz ja til yi jalt cuntu' sib na juquin. I cunin tane'n jun chin patbil txun. ");
INSERT INTO aguBl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ya'stzun tulej Kataj yi cwe'n sotzal i' e'chk tnuma'tz kale najle't Lot. Poro nin ul tx'akxuj yi yol Abraham tc'u'l Kataj. Cha'stzun te nin el tzaj tcy'al i' yi Lot le jun ama'la'tz yi ntaxk sotz ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Itzun bantz te yi topone'n Lot jalen Zoar nin xob i'-tz tan najewe'n le jun tnuma'tz. Cha'stzun te ticy'e'n i' junt tir tan najewe'n xo'l wutz scyuch' yi cob me'l. Cho'n tzun chinajewe'n tzak' jun picy. ");
INSERT INTO aguBl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ej itzun yi bajx me'l Lot nin jilonin tetz yi titz'un itzun taltz: “Ma jalu' witz'un, ja bi'ẍin kataj, nin le ama'le'j qui'c nin jun yaj at tan toque'n tetz kuchmil. ");
INSERT INTO aguBl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","¿Qui pe' na awaja'tz yil tz'oc a' ka'n twi' ta'? Ej nin yil tz'oc a' twi' ba'n tzun kawitbej kib tuch' tan jale'n jujun kal.” ");
INSERT INTO aguBl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ma yi toque'n ak'bal nintzun ben cyak'ol win tetz chitaj. Ej itzun yi bajxnak ya'stzun coye' cu'ntz te'j, nin quinin tzun tz'icy' tetz Lot yi cwe'n coylok. Nin ncha'tz qui nin nachon i' te'j yi tele'n watl. ");
INSERT INTO aguBl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ma le junt eklok itzun tal yi bajxnak tetz yi titz'un: “Bit tzaj, cho'n nchinwit wetz te'j kataj ewt. Ej ma te ak'bale'j, aẍ. Kak'e' nin junt tir win tetz ta' tan awite'n atz te'j, bantz jale'n awal.” ");
INSERT INTO aguBl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ej i nintzun cyuleja'tz quib yi tal yi bajxnak tetz yi ca'p. I te'n nin ak'bala'tz toque'n a' cya'n twi' chitaj tan wite'n yi ca'p me'l i' te'j, poro qui nin nachon i' te'j yi tele'n watl. ");
INSERT INTO aguBl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Tan tu' yi cwe'n chitxumul yi cob me'l Lot yi jun ajtza'kla'tz, ja tzun oc lac'puj jujun ni' scye'j. ");
INSERT INTO aguBl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ej itzun yi bajxnak yi jale'n yi tetz tal nintzun oc bi' ta'n tetz Moab. Ya'stzun chimam chite' yi e' moabita. ");
INSERT INTO aguBl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ma yi ca'p, yi titz'e'n yi tetz tal nintzun oc bi'-tz ta'n tetz Benami. Ya'stzun chimam chite' yi e' amonita jalu'. ");
INSERT INTO aguBl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Itzun yi tele'n tiemp, nintzun icy' Abraham swutz yi ama'l kale najle't i'. Cho'n tzun topone'n le ama'l cwent Néguev. Ej nin yi topone'n, cho'n tzun najewe'ntz le tnum yi na bi'aj Gerar, nicy'al Cades tu Shur. ");
INSERT INTO aguBl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ej itzun bantz yi chinajewe'n tul yi jun ama'la'tz nintzun tal Abraham scyetz yi e' wunak yi najlche' yi quitz'un quitzicy quib tu Sara yi txkel. Ma yi tbital Abimelec, yi rey tetz Gerar yi jun xtxolbila'tz, nintzun ben mantartz tan ticy'le'n tzaj Sara tan toque'n klo' tetz ca'p txkel. ");
INSERT INTO aguBl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Poro nintzun ẍchaj tib Ryos swutz i' le wutzicy', ej nin taltz tetz: “Abimelec, ẍquimok, na mbi xac nsaj awucy'al yi jun xna'na'tz tzawuch', na at tetz chmila'tz.” ");
INSERT INTO aguBl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Poro ntaxk chiwitbej quib Abimelec tu Sara. Cha'stzun te talol i'-tz tetz Ryos: “Ilu' Wajcaw, poro ẍchinquimok polo' tanu', na qui'c jun takle'n cachi' mimban te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Na wutzile'n cunin Abraham mma'lon swetz yi tanub tu' i'. Ncha'tz yi xna'n ja tal swetz yi quitz'un quitzicy quib tu Abraham. Cha'stzun te mmu'l swuch'. Qui'c cunin tzun wetz wil te'j.” ");
INSERT INTO aguBl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Saje'n tzun tlol Ryos tetz tul wutzicy', itzun taltz: “Na el intxum tetz yi qui'c cunin awil te'j yi mmu'l tzawuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ma jalu', cun ak' te yi chmil, na i' jun elsanl intzi', nin copon wutz tan jakle'n abanl. Poro ko quil tz'oc te awi', ẍquimok, scyuch' cyakil yi e' yi ate' jak aca'wl.” ");
INSERT INTO aguBl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Itzun le junt eklok, chin jalchan cunin tzun c'ase'n Abimelec nin ben mantartz scye'j yi e' ẍchakum. Ma baje'n chimolol quib, nintzun baj xtxolil scyetz yi mbi cu'n a'lchij tetz le wutzicy'. Yi quibital yi e' ẍchakum nintzun e' baj xob lentz. ");
INSERT INTO aguBl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ẍchakol tzun Abimelec yi Abraham. Yi tule'n i', itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","—¡Yaj! Mbi nintzun jun chin il yi bnix awa'n ske'j. ¿Mbi wil tzatz yi ncu' atxumul, tan tulse'n jun chin ila'tz swibaj, nin squibaj cyakil intanum? ¡Qui na yub yi mo'c tzaj anuc'ul swe'j yaj! ¿Mbi na cẍtzan tan xtxumle'n yi ncu' anuc'ul yi jun ila'tz swe'j? stzun Abimelec ban tetz Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","—Max c'u'lu' ta', poro tane'n tzinwutz wetz, cya'l jun najk tek ẍchi' Ryos tzone'j. Na nin inxob ko tzun cho'c wunak tan imbiyle'n cu'n tan cyetzal wuxkel. ");
INSERT INTO aguBl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Poro yi mero bintzi wanub i', na junit kataj tuch'. Ntin katxu' apart. Ej nin jalu' kok'be'nt kib tuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Nin yi talol Ryos swetz tan wele'ntzaj le tanum intaj, ja tzun bixe' ka'n tu wuxkel tan kalol scyetz cyakil wunak tul alchok ama'lil kalel ka'tcu'nt yi kitz'un kutzicy kib skibil kib, stzun Abraham bantz tetz Abimelec. ");
INSERT INTO aguBl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Taje'n tzun tk'ol Abimelec Sara tetz Abraham. Ncha'tz toy i' jun c'oloj cne'r tu wacẍ, tu jun c'oloj yaj tu xna'n tetz mos Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ej nin taltz tetz: —Xmaynin cyakil yi weri inluware'j. Nin ba'n tzatxa'e'n jalaj atz, yi mas ba'n tzawutz tan anajewe'n swutz. ");
INSERT INTO aguBl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ncha'tz tal Abimelec tetz Sara: —Yi walor cyakil yi nwak' tetz axibin, i'tz jun mil piẍ sakal. Xconk tan ẍchajle'n scyetz cyakil wunak yi aẍ jun balaj xna'n, nin cya'l jun jalsan yolbil atz, stzun Abimelec bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Toque'n tzun Abraham tan nachle'n Kataj tibaj Abimelec tu txkel, scyuch' cyakil e' xna'n yi na chimosin tuch', bantz jale'nt cyalbil. ");
INSERT INTO aguBl_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ya'stzun quitane'n yi e' xna'na'tz yi najlche' tu Abimelec, na Ryos mmakon yi cyalbil, tantu' yi ncu' klo' xtxumul Abimelec yi jun tajtza'kla'tz te Sara. ");
INSERT INTO aguBl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Itzun bantz nintzun tak' Kataj yi banl tibaj Sara chi suki'nt ta'n, na nin tekaj i' pwokil jun ni'. ");
INSERT INTO aguBl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ma yi topone'n yi tiemp yi alijt cyen tan Ryos, ule'n nintzun ban yos tuch'. Tul bi'ẍil tlen tu' ate't Abraham yi tk'ol Ryos yi jun cy'ajla'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","4","Ej nin le waxaki'n k'ej nintzun ban circuncidar Abraham yi ni'a'tz, quib yi talnak Ryos tetz. Nin oc tk'ol Abraham yi bi' tetz Isaac. ");
INSERT INTO aguBl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","At i' tul jun cient yob yi titz'e'n yi ni'. ");
INSERT INTO aguBl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ma yi tule'n itz'ok yi ni' te'j Sara, nintzun taltz tc'u'l cuntu': “Tan yi tzatzin yi ntak' Ryos swetz na chintze'en. Ncha'tz alchok scyetz yil quibit intziblal ẍchitzatzink swuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Na cya'l nin jun jak tal tetz Abraham yi ko tzantzaj xtxutxunk jun ni' swe'j. Poro yi jalu' tul bi'ẍil tlen tu' i' ja itz'ij jun cy'ajl,” stzun Sara bantz tan yi tzatzi'n yi at cu'nt. ");
INSERT INTO aguBl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Itzun bantz yi ẍch'uye'n yi ni'a'tz nintzun bnix jun chin wutzile'n wa'a'n tan Abraham tan tu' yi tele'n yi ni' te xtxu'tx. ");
INSERT INTO aguBl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Poro te yi jun k'eja'tz nin til Sara yi na tzan yi tal Agar tan xcy'aklil te'j Isaac. Yi jun aj xuxinla'tz, ya'stzun chinitxajil Abraham jal tu Agar, yi aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Yi tilol Sara yi mbi na ban yi tal Agar nintzun xochontz tetz Abraham. Itzun taltz: “Lajlen yi mose'j tu yi tal, na qui'c tocle'n yi tal i' te yi ame'bi'l yil scyajk cyen tk'ab wetz wal.” ");
INSERT INTO aguBl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Yi tbital Abraham yi yol Sara wi'nin tzun bisune'n tan tu' yi mbi sbajok te yi cy'ajl i' yi jal te Agar. ");
INSERT INTO aguBl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bene'n tzun tlol Ryos tetz Abraham: “Abraham, qui cẍbisun te acy'ajl tu yi amos Agar. Ba'n tcu'n banaj tajbil Sara, na tan Isaac ẍchijale't yi mero araxonl. ");
INSERT INTO aguBl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Poro ncha'tz Ismael yi acy'ajl yi njal te yi amos, tan i' ljale't jun nación na ncha'tz i', i' jun acy'ajl,” stzun Ryos bantz tetz Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Itzun le junt eklok, chin jalchan cunin tzun c'ase'n Abraham. I nintzun tulej i' chi tal Kataj Ryos tetz. Nin ben tk'ol cobox pam tu jun cu'lbil a' tetz Agar tan bene'n tcy'al tetz chiwa' nin quic'a' tbe'. Ncha'tz ben tk'ol yi xicy tetz xtxu' nin e' el lajultz. Ele'n tzaj nintzun e' bantz nin e' octz tan joyle'n chibe', poro qui nin jal cya'n. Tx'akxe'n nin e' bantz tul yi ama'l yi tz'inunin tu' cwent Beerseba. ");
INSERT INTO aguBl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ma baje'n yi quic'a', nin yi nsken wi't k'e'xij yi xicy tan saktzi', nintzun cyaj cyen cutx'bal Agar tmujil jun tal wi' tze'. ");
INSERT INTO aguBl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ma i' tetz, nin el ẍkansal tibtz joylaj len te yi xicy na nin tal i' tc'u'l cuntu': “Ba'n tcu'n quil wil yil quim yi wal.” Ma yi cwe'n c'olchok Agar, xe'te'n tzun yi xicytz tan o'kl. ");
INSERT INTO aguBl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Saje'n tzun tbital Ryos to'kl yi tal xicy. Cha'stzun te jilone'n tzaj yi ángel tetz Ryos. Itzun taltz: “Agar, ¿mbi na abislej? Quil cxob na ja tbit Ryos yi o'kl yi at cu'nt awal. ");
INSERT INTO aguBl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Quilo'k, cun txicbaj yi awal, nin ncwe'n tu'tz tan ẍch'eye'n, na tan i' ljale't jun nación wa'n,” stzun yi ángel tetz Ryos bantz tetz Agar. ");
INSERT INTO aguBl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ẍchajol tzun Ryos jun bo'm tetz Agar. Bene'n tzun i'-tz tan nojse'n yi cu'lbil a' yi cy'a'n ta'n nin ben tk'ol tetz yi tal. ");
INSERT INTO aguBl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","At nin Ryos tan ẍch'eye'n yi xicy, nin yi ẍch'uye'n, cho'n tzun najewe'n le jun ama'l yi tz'inunin tu'. Nin i' jun balaj c'oxol flech ban. ");
INSERT INTO aguBl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Cho'n najewe'n i' le ama'l tz'inunin tu' cwent Parán. Ej nin aj Egipto yi txkel bantz tan xtxu'. ");
INSERT INTO aguBl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Itzun bantz te yi ite'n nin tiempa'tz, nintzun opon Abimelec tan yol tetz Abraham. Xomij Ficol te'j, yi wi'tz ajcaw squibaj cyakil yi e' sanlar cwent Abimelec. Itzun tal Abimelec tetz Abraham: —I bin jalu' Ta' Abraham, ja lajluchax skawutz yi xomij Ryos te'ju' tan ẍch'eye'nu'. ");
INSERT INTO aguBl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Cha'stzun te, te yi atu' tzone'j swutz yi ama'le'j, na waj yi swutz cu'n Ryos yil talu' swetz yi qui pel tz'ocu' tan banle'n jun e'chk takle'n cachi' swe'j, nka scye'j e' incy'ajl scyuch' e' inmam. Ej nin ncha'tz swutz cu'n Ryos tale'u' swetz, yi cho'n cunin pe' sbne' yi banl talma'u' swe'j chi banakin wetz te'ju'. Ej inin pe' sbne'u'a'tz scye'j cyakil yi e' inwunakil yi najlche' tzone'j le intanum kale najle'tu', stzun Abimelec tetz Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","—Jun cu'n yol ya'stzun swulej, stzun Abraham bantz tetz Abimelec. ");
INSERT INTO aguBl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Poro ncha'tz, nin jak Abraham tkanil yi jun a' yi kopijt tan i' yi elnak chimajol yi e' mos Abimelec. ");
INSERT INTO aguBl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Bene'n tzun tlol Abimelec tetz Abraham: —Qui na wit wetz yi ko ya'tz e' ban inmos, na ncha'tz bin ilu' qui nin bin talu' mu'ẍ rasonil swetz. Qui tzun na wil wetz na' txumun cu'n yi jun ajtza'kla'tz, stzun Abimelec tetz Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ej nintzun saj tcy'al Abraham cobox cneru' nin cobox wacẍ nin tak'tz tetz Abimelec. Ej nin te yi jun k'eja'tz ya'stzun bixewe'n chitrat. ");
INSERT INTO aguBl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Poro ncha'tz nin oc Abraham tan chijatxle'n el tzaj jukt tal tij cneru' ẍchixo'l yi e' tawun. ");
INSERT INTO aguBl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Nin yi tilol Abimelec, nin ben jakoltz tetz: —¿Mbi xac nche'l tzaj xtxa'olu' yi jukt cneru'e'j? ");
INSERT INTO aguBl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Bene'n tzun tlol Abraham tetz: —Tan yi jukt cneru'e'j yi swak'e' teru', ya'stzun jun techl yi mero bintzi, in inkopon yi jun julil a'e'j, stzun Abraham bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Cha'stzun te toque'n bi' yi jun ama'la'tz tetz Beerseba, na cho'n bnixe'n yi chitrat Abraham tu Abimelec le jun ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Yi wi't bnixe'n yi chitrat le ama'la'tz yi oc bi' tetz Beerseba, nintzun e' pakxij cyetz Abimelec tu Ficol le cyetz chitanum ẍchixo'l yi e' filistey. ");
INSERT INTO aguBl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ej nin ta'ste'n nin le ama'la'tz yi na bi'aj Beerseba cwe't tawal Abraham jun wi' tze' yi na bi'aj tamarisco. Ej nin ta'ste'n nin oque'tz tan c'u'laje'n Ryos, yi jun kaRyosil yi at nin i' le xe'tzbiltzaj, at jalu' nin sbne' opontunintz. ");
INSERT INTO aguBl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ala' nintzun yob a'tij Abraham le chitanum yi e' filistey. ");
INSERT INTO aguBl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Itzun bantz yi nsken wi't bnix e'chk takle'ne'j nintzun oc Ryos tan pile'n Abraham tan tilol yi ko bintzi nin k'uklij c'u'l i'. Jilone'n tzaj tzun Ryos tetz Abraham. Itzun taltz: —¡Abraham! ¡Abraham! —¿Mbi' Ta'? ");
INSERT INTO aguBl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","—Cy'aj nin yi jun tal ẍutuj acy'ajl yi wi'nin na cẍpek' te'j. Quilo'k jalen le luwar cwent Moriah. Ej nin yil cẍopon wi jun scyeri wutz yi tzinchaje' tzatz, ba'n tzapat yi acy'ajl tetz jun atx'ixwatz tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Chin jalchan cunin tzun c'ase'n Abrahamtz nin oc tan wekle'n jun buru' tan ticy'le'n nin cyektz. Ncha'tz e' ben stzoc'ol cobox si' tan pate'n yi xtx'ixwatz. Ncha'tz ben tcy'al cob mos tu Isaac yi cy'ajl. Bene'n nintzun e' bantz tan cyopone'n le ama'l yi tal Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Itzun le toxi'n k'ej chibe', nintzun ben xmayil Abraham yi ama'l yi tal Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Bene'n tzun tlol Abraham scyetz yi e' mos yi xomche' te'j: —Ncye'n tu wok tzone'j tu yi kaburu' na yi o' ketz tu incy'ajl nkaben ketz tzi'ne'j tan c'u'laje'n Ryos. Ej nin kapakxok chan. ");
INSERT INTO aguBl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Saje'n tzun tcy'al Abraham yi si' nin je tk'ol wutz coc Isaac. Ma i' tetz nin ben tcy'al yi cchilu' tu yi k'ak'. Nin e' bentz. ");
INSERT INTO aguBl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Nsken wi't chixon jun tkuj yi bene'n jakol Isaac tetz taj: —Ta'. —¿Mbi na awaj aẍ jun c'oloj incy'ajl? stzun Abraham tetz Isaac. —¿Lok tzun jun tal cneru' tetz katx'ixwatz? Cy'a'n si' ka'n nin cy'a'n k'ak' ka'n tu yi cchilu'. Poro ¿lak tzun jun tal cneru' tetz katx'ixwatz? ");
INSERT INTO aguBl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","—Ryos tz'ak'on sketz, stzun Abraham tetz Isaac te yi na chixon tan cyopone'n le ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ma yi cyopone'n le ama'l yi tal Ryos tetz, nintzun oc Abraham tan wekle'n jun patbil xtx'ixwatz. Ma yi nuc'xe'n ta'n nintzun baj je tk'ol yi si' tibaj. Kalena'tz tzun bene'ntz tan c'alche'n cu'n Isaac nin je tk'oltz tibaj yi patbil xtx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Bene'n nintzun bantz tan ticy'le'n yi cchilu' tan biyle'n cu'n yi cy'ajl. I cunin tzun klo' na bentz tu yi cchilu' tan biyle'n cu'n, ");
INSERT INTO aguBl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","yi jilone'n tzaj yi ángel tetz Ryos jalen tzi'n tcya'j. Itzun taltz: —¡Abraham! ¡Abraham! —Je ine'j Ta' stzun Abraham bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","—Qui bin tzabiy cu'n yi acy'ajl nin quil tzaban jun e'ch takle'n te'j, na na el intxum tetz yi bintzinin na awek ẍchi' Ryos, na qui nin macabej ac'u'l te'j yi mawak' klo' yi jun tal ẍutuj acy'ajl swetz, stzun yi ángel tetz Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Xmayine'n nintzun Abraham wutz coc nin ben tilol jun tal cneru' yi ẍoplij cyen yi tuc' xo'l cobox k'ab tze'. Bene'n tzun Abraham tan telsene'l tzaj. Ej nin te yi tele'n tzaj ta'n, nin tak'tz tetz xtx'ixwatz tetz xel yi cy'ajl. ");
INSERT INTO aguBl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Oque'n cyen nintzun ban bi' yi jun wutza'tz tan Abraham tetz “Ryos tz'ak'on”. Cha'stzun te jalu' na a'lchij tetz jun luwara'tz: “Yi wi'wtz tetz Kataj kale tz'ak'le't katx'ixwatz.” ");
INSERT INTO aguBl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Itzun yi wi't tk'ol Abraham yi xtx'ixwatz jilone'n tzaj tzun junt tir yi ángel tetz Kataj tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Itzun taltz: —Abraham, je yol Ryose'j: “Tantu' yi qui nin macabej ac'u'l tan awak'ol yi jun tal ẍutuj acy'ajl swetz, ja tzun aban tane'n inca'wl. Ma jalu' jun cu'n yol na walnin tzatz: ");
INSERT INTO aguBl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Swak'e' wi'nin imbanl tzawibaj na chijepon impuc'sal yi tajlal yi axonl. Ni'cu'n sbne' cyajlal chi tane'n tajlal yi e' tx'uml yi ate' tcya'j nka chi tane'n tajlal yi samlicy' yi at tzi'ak mar. Ej nin nk'e'tz ntina'tz ma na ncha'tz chixcyek scye'j cyakil chicontr. ");
INSERT INTO aguBl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ej nin tan tu' yi e' axonl, sjalok chibanl cyakil e'chk jilwutz wunak bene'n tzi'n wi munt. Ya'stzun sbajok tan tu' yi maban yi wetz wajbil,” stzun ángel tetz Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Yi nsken wi't bnix yi xtxolbila'se'j nintzun pakxij Abraham le ama'l Beerseba. Cho'n tzun najewe'n Abraham tetz coboxt tiemp le jun ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Itzun bantz yi tele'n tiemp yi baje'n cyakil yi xtxolbila'se'j, nintzun opon stziblal twi' Abraham yi nsken jal chinitxajil Nacor yi titz'un. ");
INSERT INTO aguBl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Yi bajx yi mitz'ij i'tz Uz, yi ca'p i'tz Buz. Ej nin yi toxi'n i'tz Kemuel yi taj Aram. ");
INSERT INTO aguBl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Pontzaj tlen quitz'e'n Quesed, Hazo, Pildas, Jidlaf tu Betuel. ");
INSERT INTO aguBl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Yi jun Betuela'tz ya'stzun yi taj Rebeca. Cyakil yi bi'aja'tz ya'stzun yi waxak cy'ajl Nacor yi titz'un Abraham yi e' itz'ij te'j Milca. ");
INSERT INTO aguBl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ncha'tz e' jal chinitxa' Nacor tu Reúma, yi ca'p txkel i'. Yi chibi' yi chinitxa' e' jal i'tz: Teba, Gaham, Tahas tu Maaca. ");
INSERT INTO aguBl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Itzun bantz, a'tij Sara jun cient tu junak juk yob wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Cho'n quime'n i'-tz le ama'l Quiriat-arba, nka Hebrón cwent ama'l Canaán. Ma yi Abraham wi'nin tzun bisune'n te'j Sara, nin wi'nin tok'e'n i' yi quime'n. ");
INSERT INTO aguBl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Tele'n tzaj tzuntz le ama'la'tz kale atit wankil yi k'ajtzun txkel. Bene'n tzun i'-tz tan talche'n scyetz yi e' xonl Het yi najlche' le jun luwara'tz. Itzun taltz scyetz: ");
INSERT INTO aguBl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","—Ibin jalu' tan pe' in tu' jun awer nak ẍchixo'lu' ntin na waj tzinc'uch jun pawor scyeru'. Yi nink chic'ayu' jalaj intx'otx' kale tzinmukwit yi wankil k'ajtzun wuxkel na ja quim i', chij Abraham scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Saje'n tzun cyalol yi e' xonl Het tetz Abraham. Itzun cyaltz: ");
INSERT INTO aguBl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","—I bin jalu' ta' Abraham bne'u' pawor. Tbitzaju' kayol, che'ch tzun bantz. —Ilu' jun wi'tz ajcaw skaxo'l, nin txa'ijtu' tan Ryos. Ba'n smuku' yi txkelu' le mukbil alma' yi mas balaj tcu'n ẍchixo'l yi ketz, nin cya'l nin jun skaxo'l yi nink scabej c'u'l tan tk'ol jun ama'la'tz teru'. ");
INSERT INTO aguBl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Je'n tzun txiclok Abraham, nin k'ajlan nin i' scyetz tan tak'le'n chik'ej e' xonl Heta'tz. Itzun ben tlol scyetz: ");
INSERT INTO aguBl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","—Yi ko mero bintzij na cyaju' yi cho'n tzinmuk cyen wankil yi prow wuxkel tzone'j, chibne' binu' pawor swetz. Tan imbi' chijakquenu' tetz Efrón yi cy'ajl Zohar, ");
INSERT INTO aguBl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","yi qui pel sc'ay i' jun picy swetz yi na bi'aj Macpela yi cho'n at tul yi xtx'otx' i'. Ba'n tzinchoj jamel nicy'na' ljak i' te'j. Bantz wetzal jun picya'tz tetz mukbil k'ajtzun wuxkel scyuch' e' inxonl. ");
INSERT INTO aguBl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","At cu'n tzun Efrón ẍchixo'l e' xonl Heta'tz. Jilone'n tzaj tzuntz tetz Abraham ẍchiwutz cu'n e' wunak yi ate'-tz bantz quibital yi yol i' nin ncha'tz ẍchiwutz e' yi wi'nin cyoque'n nin wi'nin cyele'n tzaj stzi puertil yi tnum. Itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","—¡Qui' lo' ta'! Bne'u' pawor, tbitzaju' in yole'j: Swoye' yi jalaj tx'otx'a'tz teru' tuml yi picy yi at nintz le luwara'tz. Ẍchiwutz cu'n e' intanume'j yi swoye' teru' nin e' cu'n stiw te'j. Ba'n bin smuku' yi k'ajtzun prow txkelu' le luwara'tz, stzun Efrón tetz Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Poro nin aj junt tir Abraham tan k'ajla'n tan tak'le'n chik'ej e' wunaka'tz yi ate' le luwara'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Jilone'n tzun Abraham tetz Efrón ẍchiwutz cu'n e' wunak yi ate'-tz. Itzun taltz: —Bne'u' pawor swetz tbitzaju' inyol, na cu' inwutz teru' yi na waj yi stz'amu' jamel yi tx'otx'a'tz tan qui imbisune'n, nin kalena's tzun tzinmukcu'n wankil k'ajtzun wuxkel, stzun Abraham bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Bene'n tzun tlol Efrón tetz Abraham. Itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","—Ilu' jun c'oloj ta' Abraham, yi jamel yi tx'otx'e'j i'tz cyaj cient piẍ sakal. Ba'n tcu'n quil ko'c tan xtxumle'n jamel yi tx'otx', ma na ba'n tcu'n benku' tan mukle'n wankil k'ajtzun txkelu'. ");
INSERT INTO aguBl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ej nintzun cujij Abraham tan ẍchojle'n yi jamel yi nsken tal Efrón ẍchiwutz e' mas xonl Het. Nin ẍchoj i' cyaj cient piẍ sakal yi tz'aknak cu'n, chi yi c'uch Efrón tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Tan yi xtxolbila'se'j, yi xtx'otx' Efrón yi at xlajlen Mamre, kale atit yi jun picy Macpela'tz, scyuch' cyakil tze' yi at swutz yi tx'otx'a'tz, ");
INSERT INTO aguBl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","tetz cunin tzun Abraham bantz tircu'n. Ej nin e' cu'n stiw ban cyakil yi e' wunak, scyuch' yi e' yi wi'nin cyopone'n stzi' puertil yi tnum. ");
INSERT INTO aguBl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Itzun bantz yi wi't bnixe'n e'ch xtxolbila'se'j, kalena's tzun cwe'n mukul Abraham yi wankil k'ajtzun Sara tc'u'l jun picya'tz yi na bi'aj Macpela, yi cho'n at xlajlen Mamre, yi ncha'tz na bi'aj Hebrón, cwent Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Cha'stzun te cyakil yi tx'otx'a'tz kale atit yi jun picya'tz tetz cu'n Abraham ban. E' cu'n xonl Het c'ayin tetz nin xcontz ta'n tetz mukbil alma'. ");
INSERT INTO aguBl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Itzun bantz te yi nsken wi't tijin c'u'l Abraham nin te yi nsken wi't tak' Kataj yi banl tibaj, nintzun octz tan xtxumle'n yi txkel Isaac. ");
INSERT INTO aguBl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ẍchakol tzun jun scyeri yi e' ẍchakum yi mas tcunin ja tijin c'u'l ẍchiwutz yi e' mas, nin yi i' wi'tz ajcaw tibaj cyakil yi me'bi'l. Bene'n tzun tlol tetz: —Ma jalu' ak'oc tzaj ak'ab tzak' incux. ");
INSERT INTO aguBl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Na na waj yil tzawal swetz, swutz cu'n Kataj, yi kaRyosil yi taw tcya'j tu wuxtx'otx', yi cẍelepon cu'n te yi xtxolbil yi swale' tzatz. Je wajbile'j: qui na waj yi nink tzajoy txkel incy'ajl ẍchixo'l yi e' xun tzone'j cwent Canaán kale najlcho't. ");
INSERT INTO aguBl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ma na na waj yil cẍben jalen le intanumbe'n tan joyle'n txkel incy'ajl ẍchixo'l yi e' inxonl. ");
INSERT INTO aguBl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Bene'n tzun tlol yi ẍchakum Abraham tetz: —Ba'n bin Ta', poro ¿ẍe'n tzimban ko quil sc'ul yi xun yil xomtzaj swe'j? ¿Ba'n pe tzun yi nink nu'l tan ticy'le'n nin yi cy'ajlu' tan cyaje'n le tanumbe'nu' kale elnaktzitu' tentz? ");
INSERT INTO aguBl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","—¡Qui'! qui'c rmeril tan bene'n incy'ajl tan najewe'n chone'j. ");
INSERT INTO aguBl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Na yi Wajcaw yi inRyosil, yi Ryos yi at tcya'j, yi nchin ne'lsan tzaj kale najle't tzaj k'ajtzun intaj, i' nsukin yi ama'le'j scyetz e' inxonl. Mben tzun ẍchakol yi tetz ángel tan bajxe'n cu'n tzawutz tan joyle'n tzaj yi txkel yi jun tal ẍutuj incy'ajle'j. ");
INSERT INTO aguBl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Poro ko quil sc'ul yi xun yil xom tzaj tzawe'j qui'c tzun ara paj te'j, nin cẍelepon liwr te yi jun trat yi copon skaxo'l. Poro jun cu'n yol na wal nin tzatz, yi qui'c rmeril tan bene'n incy'ajl chone'j. ");
INSERT INTO aguBl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Bene'n tzun yi ẍchakumtz tan tak'le'n quen yi k'ab tzak' yi cux Abraham yi tajcawil. Nin tal i'tz: —Tzimbne' tajbilu' ta', quib yi ntalu' swetz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Toque'n tzun yi mos tan xtxa'le'n e'chk balaj oy txo'l cyakil yi me'bi'l Abraham. Ej nin octz tan chiwekle'n lajuj camey i'. Bene'n nintzun bantz le tanum Nacor cwent Mesopotamia. ");
INSERT INTO aguBl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Itzun bantz yi topone'n nakajil yi tnum nskenin tzun cu' k'ej. Nintzun e' uje'-tz tuml chicamey stzi' julil jun a'. Nin te yi ora'tz ya'stzun na chibaj opon len yi e' xun tan ticy'le'n a'. ");
INSERT INTO aguBl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ej nin te yi ujlche' yi e' camey ta'n, nintzun oc yi chakuma'tz tan nachle'n Kataj. Itzun taltz: “Kataj, yi atu' tcya'j, nin ilu' Ryosil Wajcaw Abraham, chin ẍch'eyaju' tan joyle'n yi injoybe'tz. Elk k'ajabu' te wajcaw Abraham tan jale'n txkel Isaac. ");
INSERT INTO aguBl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tzinch'iwe' tzone'j stzi' yi julil a'e'j jalen pe'k yil chibaj ul len yi e' xun tan sya'i'n. ");
INSERT INTO aguBl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ya'tzk tajbilu' Ta', yi jun xun kale lwal nint: ‘Aẍ jun c'oloj xun banaj pawor swetz, nink tzawoy mu'ẍ wuc'a',’ chinch sbanin. Ej nink tal tzaj swetz: ‘Uc'a'ku' ta', ncha'tz swak'e' quic'a' yi cameyu',’ itzunk i'a'tz yi txa'ijt tanu' tetz txkel Isaac yi ẍchakumu'. Ej nin tan yi xtxolbile'j slajluchaxk tzinwutz yi at balajilu' te'j Abraham, yi wajcawil.” ");
INSERT INTO aguBl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ntaxk nintzun tane' i'-tz tan nachle'n Kataj yi bene'n tilol jun xun yi ule'n tlen tu' atit tan sya'i'n. Cho'n ate'n yi ẍchok' wi xulchub. Ej nin yi jun xuna'tz i'tz Rebeca yi me'l Betuel. Yi jun Betuela'tz ya'stzun chinitxajil Nacor tu Milca. Ej nin yi Nacora'tz quitz'un quitzicy quib tu Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Yi Rebeca chin yube'n nin. Ej nin ntaxk nin po'tzaj tibtz te jun yaj. Yi tponen stzi' yi julil a', nin octz tan nojse'n yi ẍchok'. Ma yi noje'n, nin je' tk'ol wi xulchub nintzun pakxijtz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Bene'n nintzun ban yi ẍchakum Abraham tan stz'amle'n nin jilon nintz tetz. Itzun taltz: —Aẍ jun c'oloj xun, banaj jun pawor swetz, tzawak' mu'ẍ tal wuc'a' te yi a' yi cy'a'n awa'n tul yi aẍchok'. ");
INSERT INTO aguBl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","—Cuj ta', uc'a'ku' stzun xun bantz tetz. Cwe'n tzaj tzun tcy'al yi ẍchok' le k'ab nintzun ben tk'ol yi tc'a'-tz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ma yi wi't tuc'a'e'n yi chakum nintzun ben tlol Rebeca tetz: —Ncha'tz ban ljetzaj quic'a' yi e' cameyu' wa'n, jalen yil noj len chic'u'l. ");
INSERT INTO aguBl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Lajke'l nintzun cyaje'n cyen kojol yi sowril yi a' yi at tul yi ẍchok' tul yi cu'lbil a' yi at nintz naka'j. Ala' nin tzun tir bantz stzi' yi julil a' tan je'se'n tzaj quic'a' yi e' camey. ");
INSERT INTO aguBl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Itzun te yi na tzan yi xuna'tz tan bale'n quic'a' e' camey ntin xmayi'n na ban nin yi ẍchakum Abraham te'j i'. Nin qui'c nin jun yol na talnintz tetz. Na yi tajbil i' i'tz tan tele'n xtxum tetz yi ko bintzij nin ẍchaje' Ryos yi joybe'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Yi nsken chuc'a' yi e' camey nintzun ben yi chakum tan lac'baje'n cyen jun tal argoy yi oro cu'n te ju'. Mu'ẍt cuntu' qui tz'aknak me' ons yi talil. Ncha'tz ben tk'ol cob te'j k'abaj, yi oro cu'n, mas ox ons tu ni'cy yi talil jujun. ");
INSERT INTO aguBl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Nintzun ben jakoltz te yi xun: —Banaj pawor, alaj swetz ¿na' scyetz i' ataj? Ej nin qui polo' ljal mu'ẍ kaposar tuch' ataj te ak'bale'j, stzun yi chakum tetz xun. ");
INSERT INTO aguBl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","—Yi in wetz in me'l Betuel, yi nitxajil Nacor tu Milca. ");
INSERT INTO aguBl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","At ama'l xe kaca'l tan chicyaje'n cyenu' te ak'bale'j. Ej nin cha'tz at tkan ch'im tetz chiwa' yi e' cameyu', stzun xun bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Cwe'n tzun mejlok yi ẍchakum Abraham nin octz tan c'u'laje'n Kataj. ");
INSERT INTO aguBl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Itzun taltz: “Wajcaw, ilu' Ryosil wajcaw Abraham, wi'nin banl talma'u'. Chin tz'aknak cunin teru'. Nin chin balaj ilu' te'j wajcaw Abraham, na ja chinsaj tcy'alu' jalen tzone'j ẍchixo'l yi e' xonl i'.” ");
INSERT INTO aguBl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Lajke'l nintzun bene'n Rebeca jalen xe ca'l tan talche'n tetz yi xtxu' yi mbi cu'n mbajij. ");
INSERT INTO aguBl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","At tzun jun xibin Rebeca yi na bi'aj Labán. Yi tbital yi mbi' cu'n bajij, lajke'l nintzun bene'n stzi' julil yi a' tan joyle'n yi jun yaja'tz yi jilon tetz Rebeca. ");
INSERT INTO aguBl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Na nin til yi jun argoy tu yi cob te'j k'abaj yi at cyen tkul k'ab Rebeca. Ej nin ncha'tz tbit i' mbi cu'n tal yi jun yaja'tz tetz. Itzun yi topone'n Labán stzi' yi julil a', iẍnin tzun atite't yi ẍchakum Abraham scyuch' e' camey. Nintzun oc ẍkansal tib xlaj. ");
INSERT INTO aguBl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Itzun taltz: —Max c'u'lu' ta', na el intxum tetz yi at banl Kataj tibu'. Bne'u' pawor, xomokninu' swe'j. Quil cyaju' tzone'j, na at ama'l kale chicyaj cyent yi e' cameyu'. ");
INSERT INTO aguBl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Bene'n nintzun ban xomok yi mos Abraham te Labán tan cyaje'n cyen xe ca'l i'. Ma yi e' baj cyopone'ntz nintzun oc Labán tan telse'n cyektz yi e' camey nin tak' i' chiwa'-tz. Ncha'tz ul tcy'al a'-tz tan xtx'ajle'n quikan yi chakum scyuch' e' mos yi xomche' te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Itzun bantz te yi nsken wi't bnix yi wa' yi ẍchakum Abraham qui nintzun cujij yi wa'. Itzun taltz: —Max chic'u'lu', poro qui'c rmeril tan inwane'n jalen yi ntaxk wal yi inmantar scyeru'. —Ba'n bin ltal tzaju' yi mantaru' sketz, stzun Labán bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","—I bin jalu' yi in wetz in ẍchakum wajcaw Abraham. Je tane'n i'e'j: ");
INSERT INTO aguBl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","At banl Kataj kaRyosil tibaj, na chin ric nin i'. Na ja tak' Kataj wi'nin tawun. At cneru', at wacẍ, at oro tu sakal at wi'nin camey tu buru' tuch'. Ej nin ate' wi'nin yaj tu xna'n jak' ca'wl i'. ");
INSERT INTO aguBl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nin ncha'tz nk'e'tz ntina'tz ma na ja itz'ij jun cy'ajl te'j k'ajtzun na' Sara tul bi'ẍil tlentu'. Ej nin wajcaw Abraham ja cyaj cyen tk'ol cyakil yi me'bi'l tetz yi jun tal ẍutuj cy'ajla'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ja tzun chimbixe' ta'n tan joyle'n txkel yi cy'ajl. Ej nin ncha'tz in, ja wal cuj tetz tan wele'n cu'n te'j. Je tzun yol i' yi ntal swetze'j: “Qui na waj yi cho'nk tzajoy txkel incy'ajl ẍchixo'l cyakil yi e' xun yi ate' tzone'j Canaán kale najlcho't. ");
INSERT INTO aguBl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ma na quilo'k ẍchixo'l yi e' ketz kaxonl. Ej nin joyaj jun txkel incy'ajl ẍchixo'l.” ");
INSERT INTO aguBl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nintzun waltz tetz: “Ilu' wajcaw ¿ma tzun yi kol quil sc'ul yi jun xuna'tz yil xomtzaj swe'j?” ");
INSERT INTO aguBl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Nintzun tal i' swetz: “Yi in wetz xomchin te'j tajbil Ryos, nin na el intxum tetz yi tz'ul ẍchakol yi tetz ángel tan xome'n nin tzawe'j te yi apyaj yi ncẍben te'j. Ba'n tzun tzajoy jun txkel incy'ajl ẍchixo'l yi e' inxonl, yi e' xonl k'ajtzun intaj. ");
INSERT INTO aguBl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ntin, yi ko quil cyak' yi e' inxonl yi xun tzatz, cẍelepon tzuntz liwr te ayole'j.” ");
INSERT INTO aguBl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","”Cha'stzun te, yi nnu'l jalu' tzi julil a' ja tzun no'ctz tan nachle'n Kataj yi Ryosil wajcaw Abraham. Itzun waltz tetz: “¡Wajcaw! yi ko bintzij nin ya'tz yi tajbilu' yi ba'n cuntu'k sban yi jun impyaje'j, ");
INSERT INTO aguBl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","na cu' inwutz teru' ta', te yi atin tzone'j stzi' yi jun julil a'e'j. Jek ltuleju'e'j: Ik yi xun yil tz'ul tan ticy'le'n a', ej nin kalel wal nint yi xtxolbile'j tetz: ‘Banaj pawor swetz, tzawak' mu'ẍ tal wuc'a' te yi a' yi at tul aẍchok'’, chinchk sbanin tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ej nink ltal tzaj swetz: ‘Je'j, uc'a'ku' ta'. Ncha'tz je'ul imbalul quic'a' yi e' cameyu',’ chijk i' sban tzaj, itzunk i'a'tz yi jun xun yi txa'ijt tanu' tetz txkel yi cy'ajl wajcaw Abraham,” chinch ban tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ntaxk nintzun chintane'-tz tan nachle'n Kataj yi nwilnin yi opone'n tlen tu' atit Rebeca tan ticy'le'n a'. Ate'n ẍchok' i' ta'n wi xulchub. Nintzun nwaltz tetz: “Banaj pawor swetz tzawak' mu'ẍ tal wuc'a'.” ");
INSERT INTO aguBl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Lajke'l nintzun ncutzaj tcy'al i' yi ẍchok'tz, nin taltz swetz: “Je'j, uc'a'ku' ta'. Ncha'tz wak'e' quic'a' yi e' cameyu',” stzun i' ban swetz. Nintzun nuc'a'-tz ta'n. Ncha'tz ja chibaj uc'a' len yi incameytz ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kalena's tzun mben injakoltz tetz: “¿Na' tzun scyetz ataj atxu'?” Nintzun tal i'-tz: “In me'l Betuel, yi cy'ajl incy'e'x Nacor tu wutzile'n na' Milca,” stzun i' swetz. Yi nwit yi yol i' nin mmo'c inlac'bal jun argoy te ju', nin mmo'c tzaj ink'ol cob kul k'abaj te yi k'ab. ");
INSERT INTO aguBl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nintzun nchincu' mejloktz tan c'u'laje'n Ryos. Ja wak' ink'ajsbil tetz Kataj, yi Ryosil wajcaw Abraham, tantu' yi sbejnin nchinsaj tcy'al tzone'j tan joyle'n jun xun tetz txkel yi cy'ajl i', ẍchixo'lu' yi e'u' xonl kawutzile'n Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","I bin jalu', max chic'u'lu', elk chik'ajabu' te wajcaw. Ej nin cyale'u' swetz: ¿Ba'n pe' ẍchiwutzu', nka qui'? Na waj lwit, bantz wilol yi mbil tzimban, stzun ẍchakum Abraham scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Chijilone'n tzaj tzun Labán tu Betuel itzun cyaltz: —Ja wi't cawun Ryos te cyakil yi xtxolbile'j nin yi o' ketz qui'c rmeril tan kalol cuj nka qui'. ");
INSERT INTO aguBl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ma jalu' bin, je Rebeca je'j, tcy'ajninu' nin chibenku'. Oken bintz tetz txkel yi cy'ajl yi tajcawilu' quib yi tajbil Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Yi wi't tbital yi ẍchakum Abraham yi chiyol, cwe'n tzun jokloktz swutz Ryos jalencu'n cwe'n pone'n yi wutz plaj wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kalena'tz tzun baje'n tzaj tcy'al cyakil e'chk oy yi cya'n ta'n. Jetzaj tcy'al oro tu sakal, nin e'chk balaj be'chok. Nin baj nin tk'ol tetz Rebeca. Ncha'tz at mbaj nin tk'oltz tetz yi xibin Rebeca tu yi xtxu'. ");
INSERT INTO aguBl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kalena'tz tzun wane'n i'-tz scyuch' yi e' mos yi xomche' te'j. Ej nin cho'n tzun chicyaje'n cyen tan watl te yi jun ak'bala'tz. Itzun yi chic'ase'n le junt eklok nintzun tal yi chakum: —I bin jalu' nkaje'n bin ketz tu yi xun xe ca'l wajcaw Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Chijilone'n tzaj tzun yi stzicy Rebeca tu yi xtxu'. Itzun cyaltz tetz chakum: —Na bin kaj cobox k'ej plas. Kalena'tz tzun tz'aj xun tanu', che'ch. ");
INSERT INTO aguBl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","—Qui', quil chin chimaku', na ntyoẍa'tz tetz Kataj yi ba'n cuntu' mban yi impyaj. Ba'n tcu'n cyak'e'u' ama'l tetz yi xun tan xome'n nin junawes swe'j bantz kopone'n xe ca'l yi wajcawil, stzun yi chakum scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","—Cuquen ta', kachake' yi xun, che'ch. —Ej nin kajake' tetz yi ko cuj ta'n yil tz'aj chan nka qui', che'ch bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Chakxe'n tzun Rebeca-a'tz cya'n nintzun ben chijakoltz tetz: —¿Cuj pe' awa'n yi ninink cẍa'j te yaje'j? —Ninin nnaje'n wetz, stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kalena's tzun cyak'ol ama'ltz tetz Rebeca, tuml yi xna'n yi na tzan tan q'uicy'le'n i', tan chixome'n nin te yi ẍchakum Abraham scyuch' yi e' mos i'. ");
INSERT INTO aguBl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Itzun te yi ntaxk cha'j tzaj nintzun cyak' yi chibanltz tibaj Rebeca. Itzun cyaltz: “Aẍ jun tal c'oloj kanub tak' tzaj kataj banl tzawibaj nink cẍo'c tetz chitxu' jun chin c'oloj wunak yi qui'c ajlbe'n cyetz. Ej nink chixcye' yi e' axonl scye'j chicontr.” ");
INSERT INTO aguBl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Toque'n tzun Rebeca scyuch' e' tetz mos tan nuc'u'n ib, ma yi wi't chibaj nuc'xe'n nintzun e' baj je'-tz te'jak jujun camey. Bajxe'n tzun yi ẍchakum Abraham nin saj tcy'al i' yi Rebeca scyuch' yi e' mos i'. ");
INSERT INTO aguBl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Itzun bantz cho'n tzun saje'n tetz Isaac stzi' yi a' yi na bi'aj “A' tetz yi jun yi itz'nin nin na ko' til.” Na cho'n najlijtz le jun ama'l yi na bi'aj Néguev. ");
INSERT INTO aguBl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Cho'n sajnak i'tz tan xo'n stzi' yi jun a'a'tz. Ej nin cwe'n k'ej cuntu' pakxe'n tzajtz. Jalt cuntunin yi bene'n xmayil yi txant cuntu' tan cyule'n cobox camey. ");
INSERT INTO aguBl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ncha'tz Rebeca nin saj tilol wutz Isaac. Ma yi saje'n tilol nintzun cutzajtz te yi camey. ");
INSERT INTO aguBl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Na nsken wi't jak tetz yi chakum. —¿Na' tzun scyetz i' yi jun yaje'j yi tz'ul tzi'ne'j tan kac'ulche'n? —Ya'stzun yi cy'ajl yi wajcaw, stzun yi mos ban tzaj tetz. Yi cwe'n tzaj Rebeca nintzun jetzaj tcy'al jun xbu'k, nin je tk'ol twi' tan tewe'n yi wutz. ");
INSERT INTO aguBl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ma yi chic'ulul quib yi chakum tu Isaac nintzun baj xtxolil i' tetz yi mbi' cu'n ban i' te yi pyaj. ");
INSERT INTO aguBl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Yi cyule'n tzaj le chinajbil nintzun saj tcy'al Isaac yi Rebeca xe mantialbe'n yi k'ajtzun xtxu'. Ok'be'n ib nintzun e' bantz, nin wi'nin pek'e'n cyen Isaactz te'j Rebeca. Cha'stzun tele'n yi bis te c'u'l Isaac tan yi k'ajtzun xtxu' yi quimnak. ");
INSERT INTO aguBl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Itzun bantz yi xone'n tiemp nintzun oc junt txkel Abraham, yi na bi'aj Cetura. ");
INSERT INTO aguBl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Jale'n nintzun ban nitxajil Abraham te junt txkela'tz. Ej nin yi chibi' i'tz: Zimram, Jocsán, Medán, Madián, Isbac nin Súa. ");
INSERT INTO aguBl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ma Jocsán ya'stzun chitaj Seba tu Dedán. Ej nin yi e' xonl Dedán ban i'tz yi e' Asur, yi e' letuseo scyuch' yi e' leumeo. ");
INSERT INTO aguBl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ma yi e' tu Madián, ya'stzun Efa, Efer, Hanoc, Abida nin Elda. Nin yi jun c'oloj wunaka'tz, e' cu'n xonl na' Cetura, yi ca'p txkel Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Poro ntin tak' Abraham mu'ẍ tal te yi tetz me'bi'l scyetz yi e' nitxajila'tz yi nchijal te yi e' mas txkel i'. Ej nin ncha'tz, te yi ntaxk tijin c'u'l, nin e' el jatxoltz yi e' mas cy'ajl i', joylaj len te Isaac. Cho'n tzun chibene'n ẍchakol jalen lilen tzi'n. Ma cyakil me'bi'l Abraham cho'n tzun cyaje'n tk'ol tetz Isaac, yi jun tal cy'ajl yi jal te Sara. ");
INSERT INTO aguBl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","A'tij tzun Abraham jun cient tu ox c'al tu o'laj yob. ");
INSERT INTO aguBl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Quime'n nintzun ban tantu' yi nsken tijin cunin c'u'l. Cho'n tzun topone'n yi talma' te'j k'ajtzun taj tu k'ajtzun xtxu'. ");
INSERT INTO aguBl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ma yi wankil cho'n tzun mukxe'n cya'n Isaac tu Ismael le jun picy yi na bi'aj Macpela. Yi jun picya'tz cho'n at xlajlen Mamre, tul yi luwar Efrón yi cy'ajl Zohar, yi e' xonl Het. ");
INSERT INTO aguBl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ya'stzun yi luwar yi lok'nak Abraham scyetz yi e' xonl Het. Cho'n tzun mukxe'n yi wankil xlaj k'ajtzun Sara yi txkel. ");
INSERT INTO aguBl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Itzun te yi nsken wi't quim, tk'ol tzun Ryos banl tibaj Isaac. Cho'n tzun cyaje'n i' tan najewe'n le yi ama'l yi na bi'aj “A' tetz yi jun yi itz', nin na ko' til.” ");
INSERT INTO aguBl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Je chibi' yi e' nitxajil Ismael yi cy'ajl Abraham, yi jal te Agar, yi aj Egipto, yi mos Sara. ");
INSERT INTO aguBl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Je bin chibi'e'j: yi bajx na bi'aj Nebaiot, xomche'tzaj Cedar, Adbeel, Mibsam, ");
INSERT INTO aguBl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO aguBl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Nafis tu Cedema. ");
INSERT INTO aguBl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ya'stzun chibi' yi coblaj nitxajil Ismael yi e' jal. Xomcyentu' chibi' yi jujun te'ak yi chiluwar. Nin ẍchijunale'n e' cawuntz squibaj yi chiwunakil. ");
INSERT INTO aguBl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","At tzun Ismael tul jun cient tu junak juklaj yob yi quime'n. Cho'n tzun topone'n talma'-tz scye'j k'ajtzun taj tu k'ajtzun xtxu'. ");
INSERT INTO aguBl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Cyakil yi e' xonl i' cho'n chinajewe'n tul yi luwar xo'l Havila tu Shur, swutze'l tzaj Egipto, xlaj yi be' yi na opon le ama'l Asiria. Nin ncha'tz wi'nin chilab quib bantz scyuch' yi e' mas chixonl. ");
INSERT INTO aguBl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Je yi xtxolbile'j tetz Isaac yi cy'ajl Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","At tzaj tzun Isaac tul ca'wunak yob yi cyok'bel quib tu Rebeca, yi me'l Betuel yi arameo, yi najlij Padan-aram. Ej nin yi Rebeca-a'tz, ya'stzun tanub Labán. ");
INSERT INTO aguBl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Qui'c nintzun tal Rebeca na jaltz, cha'stzun te toque'n Isaac tan cu'swutzil tetz Kataj tan jale'n talbil Rebeca. Yi tbital Kataj yi oración Isaac ninin tzun tekaj Rebeca pwokil cob ni'. ");
INSERT INTO aguBl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Itzun te yi ate' yi cob ni'a'tz twankil Rebeca, tza'j nin tzun oyintzi' ate' cu'ntz. Toque'n tzun Rebeca tan xtxumle'n. I tzun taltz tc'u'l cuntu': “Yi ko ya'tz nin tunin tzimbantze'j ¿mbi xac mas ank'i'n swetz?” Bene'n nintzun bantz tan jakle'n tetz Kataj Ryos yi mbi tzuntz yi na chibiy quib yi cob ni'a'tz twankil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Jilone'n tzaj tzun Kataj tetz. Itzun taltz: “Quil cẍbisun, na yi cob ni'a'tz yi eka'n pwokil awa'n, i'tz cob chin wutzile'n nación yi na choyintzin te yi ntaxk chu'l itz'ok. At jun yi mas cham sbne' swutz yi junt, nin yi bajx tz'ocopon tzak' yi ca'wl yi ca'p.” ");
INSERT INTO aguBl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ma yi topone'n yi k'ejlal tan tule'n yos tu Rebeca, e' cu'n yoẍ ban yi tal i'. ");
INSERT INTO aguBl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Chin ẍeẍ nin, nin chin pay nin te'j yi bajx yi titz'e'n, nin oc bi'-tz cya'n tetz Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ule'n nin ban itz'ok yi ca'p. Tz'amij yi ẍchu's tkan yi stzicy ta'n, yi tule'n itz'ok. Cha'stzun te toque'n yi bi'-tz cya'n, tetz Jacow. At tzaj tzun Isaac tul oxc'al yob yi tule'n yos tu Rebeca scyuch' yi cob ni'-tz. ");
INSERT INTO aguBl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ch'uye'n nintzun e' ban yi cob xicya'tz. Yi bajx yi na bi'aj Esaú nin oc tetz jun balaj ak'unwil wi cojbil. Nin ncha'tz i' jun balaj aj txuquinl bantz. Ma yi Jacow, apart nin tetz xtxumu'n bantz. Chin tajbil nin i' yi na cyaj cyen xe chipach yi tal mantial tu'. Nin chin c'ulutxum nin i', qui tu na tzantu'. ");
INSERT INTO aguBl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Mast cunin tzun na pek' Isaac te Esaú, na chin tajbil nin i' bajse'n yi e'chk t'imbil yi na bnix tan Esaú te e'chk smaron txuc yi na chilo'on ta'n xo'l tze'. Ma tzun tetz Rebeca mast cunin na pek' tetz te Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","At tzun jun tir yi na tzan cunin Jacow tan sk'ajse'n jun chin balaj t'imbil yi tule'n tzaj Esaú tan ak'un wi cojbil. Nsken tzun nk'e'xij i'. ");
INSERT INTO aguBl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Yi tule'n tzaj nintzun ben jakol tetz Jacow. Itzun taltz: —Banaj pawor swetz yaj, tzawak' mu'ẍ tal wetz te yi ara t'imbil cyake'j, yi ja wi't bnix awa'n, na na chin tzajk nin tan jun chin we'j. (Cha'stzun te toque'n junt bi' Esaú tetz Edom.) ");
INSERT INTO aguBl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","—Cuj, stzun Jacow —poro ko bajx tzawak' arak'ej swetz, tan woque'n tetz axel, chi ink bajxk cy'ajol sban. ");
INSERT INTO aguBl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","—Qui'c bin na ban, yi ko ya'tz awajbil. Na yi wetz ink'ej qui'c xac swetz, ntin ak'tzaj inwa', na na chin quim tan we'j, stzun Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","—Ma jalu', alaj bin yi mero bintzij swetz: ¿Jun cunin pe' ayol? ¿Nk'e'tz pe' tzantzaj tlen tzatx'ixpuj awajtza'kl? stzun Jacow bantz. —Jun cunin yol na walnin tzatz, nin sak swutz Ryos, stzun Esaú bantz. Tan yi xtxolbile'j icy' c'ayil Esaú yi tetz k'ej tetz bajx cy'ajol. ");
INSERT INTO aguBl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yi talol Esaú yi xtxolbila'se'j, bene'n tzun tk'ol Jacow pam tu jun chin lak t'imbil te yi nsken bnix ta'n. Yi wi't bnixe'n Esaú tan wa'a'n ele'n tzaj nin bantz. Sicyer nin oc tan xtxumle'n yi nsken wi't icy' c'ayil yi tetz k'ej tetz bajx cy'ajol tetz titz'un. ");
INSERT INTO aguBl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Itzun bantz te yi tiempa'tz nintzun cu' jun chin wutzile'n we'j tul cyakil yi luwar kale najlche't Isaac. Nimte'n cunin ban yi jun we'ja'tz swutz yi jun yi cu' te yi tiemp yi at tzaj k'ajtzun Abraham. Cha'stzun tej quicy'e'nt Isaac tul yi luwara'tz tan cyopone'n le tnum Gerar, kale najle't Abimelec, yi chireyil yi e' filistey. ");
INSERT INTO aguBl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Cho'n tzun ẍchajol tib Kataj swutz Isaac le ama'la'tz. Itzun taltz tetz: “Quil cẍben jalen Egipto, ma na ba'n cẍcyaj tul yi ama'l yi swale' tzatz. ");
INSERT INTO aguBl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Poro ba'n cẍcyaj cobox k'ej tzone'j le yi luware'j, na sna'tok tzawe'j, nin swak'e' imbanl tzawibaj, na cho'n swak'e' tzatz scyuch' yi e' axonl cyakil yi luware'j. Ya'tz tzimbne' tan wele'n cu'n te yi inyol yi insuknak tetz k'ajtzun ataj Abraham. ");
INSERT INTO aguBl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ej nin chijepon impuc'sal yi tajlal yi axonl. Ni'cu'n sbne' cyajlal chi tane'n cyajlal yi e' tx'uml. Nin swak'e' cyakil yi luware'j scyetz. Ncha'tz, tantu' e' ljale't chibanl cyakil jilwutz wunak bene'n tzi'n wi munt. ");
INSERT INTO aguBl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ya'stzun sbne'tz tantu' c'ulutxumil k'ajtzun ataj Abraham na ja ban tane'n cyakil yi walnak tetz. Ncha'tz ja ban tane'n cyakil yi weri inca'wl, tu yi inchusu'n yi wak'nak tetz,” stzun Ryos bantz tetz Isaac. ");
INSERT INTO aguBl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Cho'n nintzun cyaje'n cyen Isaac tan najewe'n le tnum Gerar. ");
INSERT INTO aguBl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Yi chinajewe'n le jun luwara'tz, nintzun e' oc yi e' wunak tan jakle'n tetz Isaac yi ko txkel i' yi Rebeca. Nintzun tal yi tanub tu' i', na nin xobtz tan talche'n yi mero bintzij, na nin oc tan xtxumle'n yi copon biyij tan paj yi yubel Rebeca. ");
INSERT INTO aguBl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Itzun bantz yi tele'n tiemp yi chinajewe'n tul yi jun luwara'tz, cho'n tzun na xmayinin Abimelec le wentanu'il tetz ca'l. Nin ben xmayiltz yi na chik'al quib Isaac tu Rebeca yi txkel. ");
INSERT INTO aguBl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Bene'n tzun mantar Abimelec tan ticy'le'n Isaac. Itzun taltz tetz: —I bin jalu' Isaac, yi xna'n yi xomij tzawe'j, chinch wetz i'tz mero awuxkel. Ma jalu' ¿mbi tzun xac na awaltz sketz yi awanub tu'? —Qui nin nwal yi mero bintzij na nin intxum yi qui cunin batz chincopon biyij tampaj yubil yi wuxkel, stzun Isaac bantz tetz rey. ");
INSERT INTO aguBl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Talol tzun Abimelec: —¿Mbi xac maban yi jun ajtza'kla'tz ske'j? Yi qui'k nlajluchax skawutz, al pe'k scyetz jun ẍchixo'l yi e' yaj yi ate' tzone'j le intanum nje' pe'k tuch'lel yi awuxkel. Nin tan yi xtxolbile'j, apaj klo' yi nkajuch kil, stzun Abimelec bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Cawune'n nintzun Abimelec tan chimolche'n cyakil yi e' wunak. Itzun taltz scyetz: —Alchok scyetz yil sban cyen jun e'chk takle'n cachi' te yaje'j nin te txkel, junawes squimok tera'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Itzun te yi tiempa'tz, nin tawaj Isaac wi'nin ujul. Ej nin chin balaj nin ban yi cosech i'-tz, na nin tak' Kataj Ryos banl tibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Chin ric nin ban i', nin jal wi'nin me'bi'ltz. ");
INSERT INTO aguBl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","E' jal wi'nin cneru' tu wi'nin wacẍ. Ncha'tz e' jal wi'nin mos i'. Tan tu' cyakil yi me'bi'l i' yi njal, wi'nin tzun ẍchi'che'n chic'u'l yi e' filistey te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Chin juntlen nin e', na te yi itz' tzaj yi taj Isaac nin ocnak yi e' mos i' tan kople'n cobox julil a'. Poro yi quime'n Abraham nin e' oc yi e' filisteya'tz tan nojse'nt cu'n tan tx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Itzun bantz yi tilol Abimelec yi nsken riquin Isaac, tlol tzun i'-tz tetz: —Cawle'n skaxo'l tzone'j, na mas tcunin ja cẍriquin skawutz ketz. ");
INSERT INTO aguBl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ele'n nintzun ban Isaac le luwara'tz. Cho'n tzun topone'n tan najewe'n tul jun joco'j cwent nin yi tnum Gerar. ");
INSERT INTO aguBl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Yi chinajewe'n tul yi jun luwara'tz, nintzun oct Isaac tan kople'nt yi e'chk julil a' yi cu'nak cyen kopol yi k'ajtzun taj. Na nsken wi't baj chinojsal yi e' filistey. Ite'n nin chibi' yi e'chk julil a'a'tz octz ta'n quib yi chibi' yi ocnakt cyen tak'un yi k'ajtzun taj. ");
INSERT INTO aguBl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Itzun bantz te yi na chitzan yi e' mos Isaac tan kople'n jun julil a' tul yi jun joco'ja'tz, jalt cuntunin quilol yi je'n mule'n mulk'uj yi a' ẍchiwutz, nin xon. ");
INSERT INTO aguBl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ma yi e' pstor cwent Gerar, scyuch' e' pstor Isaac cho'n tzun toque'n majo'n ib te yi jun a'a'tz. Na nin cyal e' pstor cwent Gerar yi cyetz. Cha'stzun te yi toque'n bi' yi jun a'a'tz tan Isaac tetz “Oyintzi'”, tantu' yi toque'n majo'n ib te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Pontzaj tlen cyoque'n yi e' mos Isaac tan kople'n junt julil a'. Poro ite'n nin e' bana's tan oyintzi' te'j. Cha'stzun te yi toque'n bi' yi junt julil a'a'tz tan Isaac tetz “Chi'ch C'u'lal”. ");
INSERT INTO aguBl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ele'n tzaj nintzun e' ban Isaac tul yi jun luwara'tz nin e' eltz joylaj len. Cho'n tzun cyoque'ntz tan kople'n junt julil a'. Yi jale'n cya'n cya'l nin jun octz tan oyintzi' te'j. Cha'stzun te toque'n bi' yi junt a'a'tz ta'n tetz “Ja Ke'l Liwr” na nin tal Isaactz: “Ja tak' Kataj Ryos puntil sketz tan kariquine'n.” ");
INSERT INTO aguBl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Yi tele'n tiemp icy'e'n nintzun e' ban junt tir Isaac swutz yi luwara'tz. Cho'n tzun cyopone'ntz jalen Beerseba. ");
INSERT INTO aguBl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ninin tzun te yi ak'bala'tz, ẍchajolt tib Kataj swutz i'. Itzun taltz tetz: “I ina'tz yi Ryosil k'ajtzun ataj Abraham. Quil cxob, na atin nintz tzawe'j. Tantu' yi mbi banak inchakum, k'ajtzun ataj, swak'e' imbanl tzawibaj, nin chijepon impuc'sal yi tajlal axonl.” ");
INSERT INTO aguBl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ta'tz te'n nintzun oque't Isaac tan nuc'le'n jun patbil xtx'ixwatz, nin octz tan na'wse'n bi' Kataj. Cho'n tzun cya'te'ntz tul yi jun luwara'tz. Ej nintzun e' oc yi mos i' tan kople'n junt julil a'. ");
INSERT INTO aguBl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Yi nsken wi't el tiemp yi cyoponle'n Isaac Beerseba, icy'pontzaj nintzun Abimelec jalen Gerar tan yol tetz Isaac. Xomche' cob tamiw te'j yi na chibi'aj Ahuzat tu Ficol. Yi Ficola'tz ya'stzun ajcaw squibaj cyakil yi e' sanlar Abimelec. ");
INSERT INTO aguBl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Yi cyopone'n nintzun tal Isaactz scyetz: —¿Mbi na chijoyu' tzone'j? Na qui bin na chipek'u' swe'j, na ja bin ne'l tzaj chilajulu' swutz yi chitx'otx'u'. ¿Mbi tzun na cyaju' swetz jalu'? ");
INSERT INTO aguBl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","—Max c'u'lu' Ta', poro ja el katxum tetz nin na kil, yi mero bintzij xomij Ryos te'ju'. Cha'stzun te nkatxum tan kule'n te'ju' tan bixbaje'n jun katrat tuch'u'. Je yi na kaj yil bixe' skaxo'le'j: ");
INSERT INTO aguBl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Qui'k tz'ocu' tan banle'n jun e'chk takle'n cachi' ske'j, na yi o' ketz cya'l cunin nkoque't tan banle'n jun e'chk takle'n cachi' te'ju', na yi tele'n tzaju' skaxo'l, pe cunin sk'il yi tele'n tzaju' ka'n. Poro yi jalu', na kil yi na tzan Kataj Ryos tan tak'le'n banl tibu'. ");
INSERT INTO aguBl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Yi wi't tbital Isaac yi chiyol, nintzun bnix jun chin wutzile'n wa'a'ntz ta'n. Nin e' baj wan len cunintz. ");
INSERT INTO aguBl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ma le junt eklok chin jalchan cunin tzun e' baj c'ase'ntz, nin baj chisukil chiyoltz tan qui chibanol jun e'chk takle'n cachi' squibil quib. Chin cyamiw nin quib e' bantz yi chipaxul quib. Aje'n nintzun e' ban Abimelec. ");
INSERT INTO aguBl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Itzun te yi ite'n nin k'eja'tz, cyule'n tzaj yi e' mos Isaac tan talche'n stziblal tetz, yi nsken wi't jal a' cya'n tul yi jul yi na chitzan tan kople'n. ");
INSERT INTO aguBl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Oque'n nintzun ban bi' yi jun a'a'tz tan Isaac tetz Seba. Cha'stzun te Beerseba bi' jun luwara'tz jalu'. ");
INSERT INTO aguBl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","At tzaj tzun Esaú tul ca'wunak yob yi cyok'bel quib tu Judit yi me'l Beeri, jun scyeri yi e' xonl Het. Ncha'tz cyok'bej quib tu Basemat, yi me'l junt yaj scyeri e' xonl Het, yi na bi'aj Elón. ");
INSERT INTO aguBl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Yi cyok'bel quib Esaú scyuch' yi cob awer naka'tz, ntin tak' bis scyetz Isaac tu Rebeca. ");
INSERT INTO aguBl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Itzun bantz te yi nsken bi'ẍin Isaac, nin yi qui't na a'w wutz, nintzun saj ẍchakol i' yi Esaú yi bajx cy'ajl, nin ben tloltz tetz: —¡Aẍ jun c'oloj incy'ajl! —¿Mbi' ta'? chij Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","—Na awil yi ja wi't chimbi'ẍin. Ej nin qui cunin batz na xontzaj yi quimichil tzinwutz tetz ek ca'p. ");
INSERT INTO aguBl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Cha'stzun te na waj yil cẍben xo'l tze'. Cy'ajwe' nin yi ama'cl tetz txuqui'n nin cun joy jun inchib. ");
INSERT INTO aguBl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Yil tz'ul yi txuc awa'n, nintzun tzaban cu'n jun chin int'imbil yi chumbalaj nin chi yi wetz yi na chimpek' te'j. Yil bnix awa'n ba'n tzun tz'ul tzinwutz tan baje'n wa'n. Kalena'tz tzun lwak' cyen imbanl tzawibaj jalen pe'k yi ntaxk chinquim. ");
INSERT INTO aguBl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ma yi Rebeca, atequen tzun i'-tz tan tbite'n yi mbi cu'n na tzan nin Isaac tan talche'n tetz Esaú. Yi tilol i' yi nsken wi't ben Esaú tan txuqui'n xo'l tze', ");
INSERT INTO aguBl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","lajke'l nintzun bene'n tan talche'n tetz Jacow, yi ca'p chinitxa', yi mbi cu'n baj tlol Isaac tetz Esaú, itzun taltz: —Aẍ jun c'oloj wal, je mbaj tlol ataj tetz awutzicye'j: ");
INSERT INTO aguBl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Quilo'k xo'l tze' tan txuqui'n. Cun joy jun inchib. Ma yi ljaltzaj awa'n, nintzun tzaban jun chin balaj int'imbil te'j. Kalena's tzun lwak' cyen imbanl tzawibaj jalen pe'k te ntaxk chinquim,” stzun ataj mban tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ma jalu' bin aẍ jun c'oloj wal, bit tzaj cunin yi xtxolbil yi swale' tzatz: ");
INSERT INTO aguBl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Quilo'k jalcu'n kale ate't yi e' kawun, nin joywe' e'l tzaj cob tal chiw yi ba'nt e' tetz chibaj, nin tzimbne' yi t'imbil chi na pe'k ataj te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Yil bnix yi jun balaj t'imbila'tz wa'n, nintzun tzacy'aj nintz swutz ataj tan wane'n i' te'j, bantz cyaje'n tk'ol yi banl tzawibaj te yi ntaxk quim, chij Rebeca bantz tetz Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Saje'n tzun stza'wel Jacow yi yol xtxu': —Na', poro yi Esaú, chin pay nin te'j wankil, ma yi wetz qui'. ");
INSERT INTO aguBl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ko tzun lben intaj tan inmacle'n, tz'elpon xtxum swetz nin tz'ocopon tan xtxumle'n yi na chintzan tan telse'n k'ej i'. Ej nin qui cunin batz tz'elepon ink'ej ta'n. Wech na imbanl klo' na lwaj cyen tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Saje'n tzun stza'wel yi xtxu': —Aẍ jun c'oloj wal, ba'n tcu'n yi in wetz no'c cyen tzak' awil. Ntin banaj quib yi nwalnin tzatz. Cun cy'aj yi cob chiw yi nwal. ");
INSERT INTO aguBl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Bene'n nintzun ban Jacow tan quicy'le'n tzaj yi cob tal chiwa'tz nin e' oc tk'oltz tk'ab yi xtxu'. E' cwe'n tzun biyol Rebeca nin octz tan banle'n jun balaj t'imbil chi yi na pe'k Isaac te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Saje'n tzun tcy'al Rebeca yi balaj be'ch tetz Esaú yi colijche', nin oc tk'oltz te'j Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Nin oc tk'ol Rebeca yi stz'uml chiw te'j k'ab nin te'j kul Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Yi wi't toque'n yi be'ch tetz Esaú tu stz'uml chiw te'j Jacow, kalena's tzun bene'n tk'ol Rebeca yi jun balaj t'imbila'tz tetz tan bene'n tan tak'le'n tetz Isaac, yi taj. ");
INSERT INTO aguBl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yi tocompone'n Jacow kale atit yi taj, nintzun tziwun nintz tetz. Itzun taltz: —Quech ta'. Ja nu'l. —¿Na'j scyetz aẍ? ¿Aẍ pe' Esaú, nka aẍ Jacow? chij Isaac ban nintz. ");
INSERT INTO aguBl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","—In Esaú yi bajx cy'ajlu', chij Jacow. —Ja bnix yi tajbilu' wa'n yi njaku' swetz. Or c'oleke'nu'. Wanku' te yi t'imbil yi ja bnix wa'n te'j yi txuc yi nẍimbiye', bantz tk'olu' yi banlu' swetz, stzun Jacow ban. ");
INSERT INTO aguBl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Nin ben jakol Isaac tetz Jacow: —¿Jalcunin petzun njal txuc awa'n? —Jalcu'n ta', na i yi Ryosilu' mmo'c tan wuch'eye'n tan joyle'n, chij Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Bene'n tzun tlol Isaac tetz: —Ẍkanso'c tzaj bin awib tzinwutz, na swile' ko bintzi nin i aẍa'tz yi incy'ajl Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Toque'n tzun ẍkansal tib Jacow swutz yi taj tan tilol i' yi ko i nin i'-a'tz Esaú. Ma yi toque'n macol Isaac te'j k'ab Jacow, nintzun taltz: —Yi wi' tan yol icunin i'-a'tz Jacow, poro yi te'j k'ab, icunin i'-a'tz Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Qui nin tzun el xtxum Isaac tetz yi ko i'tz Jacow, na ni'cu'n tane'n payil te'j k'ab Jacow chi tane'n tetz Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Itzun yi ntaxk tak' Isaac yi banl tetz Jacow nintzun jak i' junt tir tetz Jacow, itzun taltz: —¿Bintzij nin pe' i aẍa'tz Esaú? —I ina'tz Esaú ta', chij Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","—Ak'tzaj bin yi int'imbil, nin inwa'. Chinwank jun te yi int'imbil yi ja bnix awa'n. Kalena'tz tzun lwak' imbanl tzawibaj, stzun. Bene'n tzun tk'ol Jacow yi wa' Isaac. Ncha'tz tak' i' win tetz tc'a'. ");
INSERT INTO aguBl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Yi wi't wane'n nintzun taltz: —¡Catzam! aẍ jun c'oloj incy'ajl. Tz'ube'n xak intzi'. ");
INSERT INTO aguBl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yi tocompone'n Jacow tan stz'uble'n xak stzi' yi taj, nin oc sakol Isaac te yi be'ch tetz Esaú yi at te'j Jacow, nin tak' i' banl tibaj. Nin je'j yol tal Isaac: “Ya'stzun c'o'cal yi incy'ajl. Ni'cu'n c'o'cal tu jalaj luwar yi na ac' tan a'bal tan Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Lok skoj tzaj Kataj a'bal tibaj yi atx'otx'. Lok jal balaj acosech ta'n. Lok jal wi'nin triw nin wi'nin lo'baj uva tzawuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ẍchijalok wi'nin wunak yi chocopon tetz amos. Yi e' wunak yi ate' bene'n tzi'n wi munt ẍchimejek tzawutz nin ẍchiwutz axonl. Aẍ ajcaw sbne', squibaj yi e' awitz'un nin ẍchimejek tzawutz. Ej nin yi e' yil cho'c tan telse'n ak'ej tz'ak'lok cyetz chicawsa'tz. Ma yi e' yil tz'ak'on ak'ej stz'ak'lok cyetz chibanla'tz,” stzun Isaac bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yi tk'ol Isaac yi banl tibaj, ele'n tzaj nin ban Jacow. Watok cunin tzun el tzaj Jacow swutz yi taj, yi pakxe'n tzaj Esaú tan txuqui'n. Cy'a'n jun txuc ta'n tetz ẍchib yi taj. ");
INSERT INTO aguBl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ncha'tz nin octz tan banle'n jun balaj t'imbil te yi txuc yi ul ta'n. Yi wi't bnixe'n ta'n nin ben tcy'altz swutz yi taj. Nin tal i'-tz: —C'oleke'n tzaju' ta'. Wanku'. Je yi t'imbilu'e'j yi ja bnix wa'n te yi txuc yi ja quim wa'n, bantz tk'olu' yi banlu' swibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Bene'n tzun jakol Isaac tetz: —¿Na' tzun scyetz aẍ? —I ina'tz in Esaú ta', yi bajx cy'ajlu', stzun Esaú bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ele'n tunin yab Isaac yi jilone'n cyen Esaú tetz. Xe'te'n nintzun bantz tan lucnewe'n. Nin ben tloltz tetz Esaú: —¿Na' tzun scyetz i' yi jun yi mu'lak swe'j? na ja tal i' swetz yi ja xa'k tan txuqui'n nin ja ul yi int'imbil ta'n. Nin ja baj cunin wa'n te yi ntaxk cẍu'l atz, nin ja wi't wak' yi imbanl tibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Yi wi't tbital Esaú yi yol yi taj, saje'n tzun bu'k jun chin o'kl te talma'. Ej nin chin wi' nin bantz tan sich'. Itzun taltz: —Ncha'tz in ta', tak'u' mu'ẍ banlu' swibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","—Qui'c rmeril yaj, na ja wi't ulak yi awitz'un nin ja xcye' i' tan insuble'n, na ja el tcy'al i' yi imbanl yi awetz klo' mban. ");
INSERT INTO aguBl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","—¡Ah! qui bin tulej yi toque'n bi'-x tetz Jacow, chij Esaú. —Na ya'stzun cobix tir ocx tan insuble'n. Bajx tele'n tcy'al i' yi ink'ej tetz bajx cy'ajol. Ma jalu' ja elt majol yi imbanl yi at ak'bil swetz. ¿Poro qui pel sc'ulu' yi nink ltak'u' sicyer mu'ẍ tal yi banlu' swibaj ta'? ");
INSERT INTO aguBl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","—Bitzaj, ja wi't wak' ama'l tetz Jacow tan toque'n tetz ajcaw tzawibaj, nin ja wi't wak' ama'l tetz tan cawune'n squibaj cyakil yi e' tetz xonl. Nin ja wak' ama'l tetz tan cawune'n squibaj cyakil yi e' axonl, nin ja wi't wak' banl i' tan jale'n wi'nin triw nin wi'nin lo'baj uva tuch'. Ma jalu' aẍ jun c'oloj incy'ajl, ¿ẍe'n tzimban tzawe'j? ");
INSERT INTO aguBl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","—Poro ta', ¿qui't pe' sc'ulu' yi nink tak'u' mu'ẍ tal banlu' swibaj? ¿Qui pel tz'ok' c'u'lu' swe'j? ¡Nink ltak'u' mu'ẍ tal banlu' swibaj! Xe'te'n nin tzuntz tan o'kl. Chin wi' nin ban. ");
INSERT INTO aguBl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Jilone'n tzaj tzun Isaac tetz Esaú itzun taltz: “Cho'n bin ẍnajank atz joylaj len te yi e'chk balaj tx'otx', nin kale qui'cle't mas a'bal. ");
INSERT INTO aguBl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Tajwe'n bin yi tzacol awib achuc tu yi aspar, nin cẍocopon tetz xconsbe'tz yi awitz'un. Poro yil cẍquiwix atz, cẍelepon liwr tzak' cawl i'.” ");
INSERT INTO aguBl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Jetza'tz tzun jale'n chi'ch c'u'lal tetz Esaú te Jacow tantu' yi tk'ol Isaac yi banl tibaj i'. Toque'n tzun Esaú tan xtxumle'n yi txant tan quime'n yi taj. Ej nin taltz: “Yil quim intaj copon imbiyol yi witz'un,” stzun Esaú bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Yi tbital Rebeca yi mbi'tz xtxumu'n Esaú, bene'n tzun mantar i'-tz tan ticy'le'n Jacow. Nintzun taltz tetz: —Wal, je jun yole'j, tz'ocopon Esaú tan abiyle'n cu'n chij. ");
INSERT INTO aguBl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Cha'stzun te aẍ jun c'oloj wal, ok cu'n te awi' yi swale' nin tzatz: Kale'n ojkuj nin quilo'k te'j inxibin yi cho'n najlij jalen Harán. ");
INSERT INTO aguBl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ba'n cẍa'tij cobox tiemp te'j jalen cu'n yil tz'el awil tu yi chi'ch c'u'lal te c'u'l awutzicy. ");
INSERT INTO aguBl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Kalena's tzun tz'opon stziblal wa'n tawi' tan awule'n junt tirt tzone'j. Na qui na waj jun ntzi'-k k'ej chiquime't cob wal. ");
INSERT INTO aguBl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Cha'stzun te bene'n Rebeca tan yol tetz Isaac. Itzun taltz tetz: —Ja baj inc'u'l tan chipaj yi cob txkel Esaú yi e' awer nak. Nin yi ko cho'n sjoy Jacow yi tetz txkel ẍchixo'l e' wunak tzone'j Canaán, ba'n tcu'n yi nink chinquim. ");
INSERT INTO aguBl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Bene'n tzun mantar Isaac tan ẍchakle'n Jacow. Ma yi tule'n, nintzun tak' banltz tibaj. Ncha'tz tak' jun ca'wl tetz. Je tale'j: “Quil tzajoy awuxkel ẍchixo'l yi e' xun yi najlche' tzone'j Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ma na quilo'k jalen Padan-aram, kale najle't acy'e'x Betuel. Ba'n tzajoy awuxkeltz ẍchixo'l yi e' me'l Labán yi xibin atxu'. ");
INSERT INTO aguBl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Lok tak' tzaj kaRyosil banl tzawibaj, yi jun yi na xcye' tan cojle'n tzaj yi banl i' skibaj. Lok tak' i' wi'nin axonl, na tan aẍ ljale't wi'nin wutzile'n tnum. ");
INSERT INTO aguBl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Cho'n stk'e' i' tzatz nin scyetz yi e' axonl yi banl i' yi suknak tetz k'ajtzun intaj Abraham, yi acy'e'x. Stk'e' i' cyakil yi luware'j yi najlcho't swutz chi awer nak kutane'n jalu'. Na suknak i' yi yola'tz tetz k'ajtzun intaj Abraham.” ");
INSERT INTO aguBl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ya'stzun bantz yi bene'n ẍchakol Isaac yi Jacow jalen Padan-aram. Cho'n tzun topone'n Jacow tuch' Labán, yi cy'ajl Betuel, yi arameo. Ej nin yi jun Labána'tz, i' xibin Rebeca, yi chitxu' Jacow tu Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Inti Esaú nin ben tilol yi tk'ol Isaac yi banl tibaj Jacow, nin yi bene'n ẍchakol jalen Padan-aram tan joyle'n yi txkel. Ncha'tz tbit yi bene'n tlol tetz yi qui'c rmeril tan joyol yi txkel ẍchixo'l yi e' xun yi najlche'-tz Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Nin ncha'tz ben tilol yi jalcunin bene'n Jacow jalen Padan-aram quib yi tal yi taj xtxu' tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tan yi xtxolbila'se'j el xtxum Esaú tetz yi qui na pek' yi taj i' scye'j yi e' xun yi najlche' Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Cha'stzun te, bene'n Esaú kale najle't Ismael yi cy'ajl Abraham, tan joyle'n junt tetz txkel. Nintzun cyok'bej quibtz tu jun scyeri e' me'l Ismael yi na bi'aj Mahalata, yi titz'un Nebaiot. Ya'stzun yi toxi'n txkel i' bantz. Ma yi cobt txkel i' yi ate' nintz, e' cu'n aj Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Cho'n tzun tele'n tzaj Jacow le ama'l yi na bi'aj Beerseba nin icy' tcy'aj yi be'-tz yi na ben Harán. ");
INSERT INTO aguBl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Itzun bantz te yi na xon i' tbe' tan topone'n Harán, at tzun jun tir yi nsken cu k'ej nin joy i' jun ama'ltz kalel lwit cyent te jun ak'bala'tz. Yi jale'n ta'n nin octz tan nuc'le'n yi soc. Nin oc tk'ol jun c'ub yi at nintz le ama'la'tz tetz witz'. Watl nintzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Cho'n tzun ẍchajol tib jun balaj wutzicy' swutz i'. Ej nin tul yi wutzicy'a'tz til i' jun chin yotx yi cho'n opnaknin wuxtx'otx' nin je'nak pone'n cu'n jalen tcya'j. Ncha'tz til yi tibaj yi jun yotxa'tz na chicu'ul, nin na cha'jte'n yi e' ángel tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ncha'tz til i' wutz Ryos. Cho'n txicl tzaj jalen tzi'n tcya'j. Saje'n tzun tloltz tetz: “I ina'tz Ataj Jehová, chiRyosil acy'e'x Abraham tu ataj Isaac. Cho'n swak'e' tzatz nin scyetz cyakil yi e' axonl yi tx'otx'e'j kale coylquiẍe't. ");
INSERT INTO aguBl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ej nin cho'n cunin sbne' cyajlal yi araxonl, chi tane'n tajlal yi samlicy' yi at wuxtx'otx' yi quinin ajlbe'n tetz. Nin nchiben lo'on swutz cyakil yi ama'le'j. At e' nchiben je'n tzi'n. Nin at e' nchiben cwe'n tzi'n. Nin at e' nchiben tele'n tzi'n, nin toque'n tzi'n. Ej nin tan aẍ scyuch' yi e' axonl ljale't chibanl cyakil wunak bene'n tzi'n wi munt. ");
INSERT INTO aguBl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Quil cẍbisun, na atin tzawe'j. Chinxomok tan aq'uicy'le'n alchok tu nin cẍa'tcu'nt. Nin cẍpakxok junt tir wa'n le luware'j. Quil cẍincolcyen jun tkuj jalen yil ne'lcu'n te cyakil yi ja insuk tzatz”, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Itzun te yi tele'n watl Jacow, nintzun xtxumtz: “Jun cu'n yol, at Ryos le ama'le'j. Qui'c cunin wetz intz'a'chil te'j yi ko ya'tz.” ");
INSERT INTO aguBl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Saje'n tzun jun chin xo'wtz te'j, nintzun xtxumtz: “I yi jun ama'le'j chin xan nin te'tz. Cho'n at yi ca'l Ryos tzone'j, nin i'tz yi puertil yi tcya'j.” ");
INSERT INTO aguBl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Itzun le junt eklok chin jalchan cunin tzun c'ase'n Jacow. Nin saj tcy'al yi c'ub yi xcon ta'n tetz witz'. Ej nin ta'ste'n nin cwe't tawaltz. Txicl tzun tulej cyentz, chi jun tkan ca'l, nin je' kojol aceit tibaj tan xanse'n. ");
INSERT INTO aguBl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Tul yi jun luwara'tz at jun tnum tentz yi na bi'aj Luz, poro nintzun je' xtx'ixpul Jacow yi bi' jun luwara'tz, nin oc tk'ol yi bi' tetz Betel. ");
INSERT INTO aguBl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Cho'n tzun sukil Jacow cobox yole'j: “Yi kol xom Ryos swe'j nin kol chin q'uicy'lej te yi jun impyaje'j, nin yi kol tak' inwa' tu be'ch wetz, ");
INSERT INTO aguBl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","nin yi ko ba'n cun tu' chin pakxijt ta'n xe najbil intaj, i' tzun yi Wajcaw nin inRyosil sbne'-tz. ");
INSERT INTO aguBl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ej nin i yi jun c'ube'j, yi ja cyaj cyen wawal tzone'j, ya'stzun ca'l Ryos sbne'. Nin ilen nin swak'e' indiesum teru' Ta', te cyakil yi stk'e'u' swetz.” ");
INSERT INTO aguBl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Icy'e'n nintzun ban Jacow, nin icy' tcy'aj yi be' yi na opon kale najlche't yi e' aj tele'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Yi topone'n le yi jun ama'la'tz, nin ben tilol jun julil a' yi juk'lche' ox k'u'j cneru' nakajil. Na cho'n cu'n na chuc'a' cyakil yi e' cyawun yi e' aj pstorinl te yi jun a'a'tz. Ej nin stzi' yi jun julil a'a'tz ate'n jun chin wutzile'n c'ub tan jople'n. ");
INSERT INTO aguBl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Jalen cunin tzun na chimol quib yi e' pstor tan tak'le'n quic'a' yi e' cyawun kalena'tz tzun na el yi c'ub cya'n. Ma yi na wi't chuc'a' yi e' cyawun nintzun na chijopt cyen junt tir stzi' yi jul. ");
INSERT INTO aguBl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Bene'n tzun jakol Jacow scyetz yi e' pstor yi nsken wi't chopontz: —¿Na' tzun nchisaje't cyeru' e'u' wamiw? stzun i' bantz. —O' bin aj Harán ketz, che'ch tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","—¿Cyajske'n pe'u' wutz yi jun yaj yi na bi'aj Labán, yi cy'ajl Nacor? stzun Jacow scyetz: —Kajske'n wutz, che'ch. ");
INSERT INTO aguBl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Toque'n nintzun Jacow ch'inch'uj tan jakle'n tkanil Labán, itzun taltz: —¿Ba'n pe' wutz i'? ¿Qui'c pe' yab? —Ba'n, qui'c yab i', che'ch e' pstor. —Xmayninu' tzi'ne'j, tz'ul yi me'l i' yi Raquel bi' tan tak'le'n quic'a' yi cneru'. ");
INSERT INTO aguBl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Bene'n tzun tlol Jacow scyetz yi e' pstora'tz, itzun taltz: —At tzaj nin tan cwe'n k'ej, ¿mbi tzuntz yi chin junye'ne't nin na chilam cyenu' yi cyawunu'? ¿Mbi tzuntz yi nink lchuc'a' chan cyanu', bantz chibene'nu' tan chic'a'che'n junt tkuj? ");
INSERT INTO aguBl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","—Qui'c cuj te'j, che'ch. —Na tajwe'n cunin kach'iw yil chimol quib cyakil yi e' pstor scyuch' cyawun. Ba'n tzun tz'el yi c'ub ka'n. Ej nin kalena'tz tzun lchuc'a' yi e' kawun, che'ch tzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","I nin na tzan Jacow tan yol scyetz yi e' pstora'tz, yi topone'n Raquel scyuch' yi tawun, na i' pstor cyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yi bene'n tilol Jacow yi nsken wi't ul Raquel scyuch' yi tawun Labán yi xibin yi xtxu', bene'n tzun i'-tz tan telse'nlen yi c'ub yi at tan jople'n stzi' yi julil a'a'tz. Uc'a'e'n nin e' bantz yi tawun Labána'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ncha'tz bene'n nin bantz tan k'ale'n Raquel, nin bentz tan stz'uble'n xak stzi'. O'kl nin bantz tan yi tzatzi'n yi at cu'ntz. ");
INSERT INTO aguBl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ma yi tbital Raquel tetz Jacow, yi tetz xtxu' i'tz tanub Labán, lajke'l nintzun bene'ntz tan talche'n tetz taj i'. ");
INSERT INTO aguBl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Yi wi't tbital Labán stziblal Jacow, yi i' tal yi tanub, lajke'l nintzun tele'n tzajtz tan c'ulche'n. Bene'n nin bantz tan ẍchajle'n tetz yi wi'nin tzatzine'n te'j. Nin bentz tan k'ale'n nin je' stz'ubul yi xak stzi'. Ej nin ben tcy'altz xe c'al. Yi cyopone'n xe ca'l xe'te'nin ban Jacow tan xtxole'n tetz Labán yi mbicunin bajij te'j i'. ");
INSERT INTO aguBl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Saje'n tzun tlol Labán tetz: “Aẍ cunin witz'un, na junit kaẍch'el tzawuch',” stzun Labán bantz. Cyaje'n cyen nin ban Jacow tuch' Labán tetz jun xaw. ");
INSERT INTO aguBl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Yi je'n pone'n yi jun xawa'tz tan Jacow, nintzun tal Labán tetz: —Nk'e'tz tan paj yi jun cunin o' tzawuch' oy tunin tzunk cẍak'uje't, ma na alaj swetz yi nicy'na' na awaj yil tzinchoj te'j ak'ej, stzun Labán bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ate' tzun cob me'l Labán, yi bajx na bi'aj Lea, ma yi ca'p na bi'aj Raquel. ");
INSERT INTO aguBl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Yi bajx me'al yi na bi'aj Lea, ntin tal bak' wutz tu' na yub. Ma yi Raquel, yi ca'p me'al, chin yube'nt cunin cyakil yi wankil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Cha'stzun te mast cunin na pe'k quen Jacowtz te'j. Nin nsken wi't ben tcy'al yi xtxumu'n. Cha'stzun te ben tloltz tetz Labán: —Yi nink ltak'u' yi me'lu' swetz, yi na bi'aj Raquel, ba'n lnak'uj juk yob tuch'u' tan ẍchojle'n. ");
INSERT INTO aguBl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Saje'n tzun tlol Labán, itzun taltz: —Ba'n tcu'n yi cho'n lwak' yi inme'l tzatz, swutz yi cho'nk lben tk'ab jun awer nak. Ba'n bin, ba'n ẍcyaj cyen swuch' tan ak'un. ");
INSERT INTO aguBl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ya'stzun bantz yi cyaje'n cyen Jacow juk yob tan ak'un tuch' Labán tan xtx'acle'n yi txkel. Qui tunin k'usij ban yi juk yoba'tz swutz Jacow, tantu' yi wi'nin na pe'k i' te'j Raquel. ");
INSERT INTO aguBl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yi je'mpone'n yi juk yob tan Jacow tan ak'un nintzun taltz tetz Labán: —Tak'e'u' yi wuxkel tan kok'bel kib tuch', na ja wi't je'ul yi juk yob ak'un wa'n yi insuknak teru' tan ẍchojle'n me'lu'. ");
INSERT INTO aguBl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Che' baje'n tzun xtxocol Labán cyakil yi e' wisintz tan cyopone'n te yi jun chin umle'na'tz yi bnix ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Itzun yi toque'n akale'n, nin yi topone'n oril yi umle'n nintzun ben tcy'al Labán yi bajx me'l yi na bi'aj Lea, tan cyok'bel quib tu Jacow. Ok'be'n ib nintzun e' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ncha'tz tak' Labán jun scyeri mos tetz Lea yi na bi'aj Zilpa, tan xcone'n tetz i'. ");
INSERT INTO aguBl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Itzun le junt eklok yi c'ase'n Jacow kalena'tz tzun tele'n xtxum tetz yi nk'era'tz yi txkel i' ak'lij, ma na cho'n c'ase'n i' te'j Lea, yi bajx me'al. Bene'n tzun i'-tz te'j Labán, itzun taltz: —¿Mbi eka'n tan yi tajtza'klu' yi ncu' nuc'ulu' swe'j? ¿Nk'e'tz pe' katrat tan wak'uje'n tuch'u' tan wetzal Raquel? Ma jalu' ¿mbi tzuntz mmo'cu' tan insuble'n? ");
INSERT INTO aguBl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Saje'n tzun stza'wel Labán, itzun taltz: —Nk'era'tz ketz kacstumbr tzone'j, yi bajxk ltz'oc chmil yi ca'p me'al swutz yi bajx. ");
INSERT INTO aguBl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ma jalu' bin cale'n cu'n te'j yi jun sman k'eje'j te yi i umle'n tu Lea, kalena's tzun lwak' Raquel tzatz. Yi ko ya'tz awajbil, ba'n. Ntin ko list aẍ tan awak'uje'n jukt yob swuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Nintzun cu'-tz swutz Jacow, quib yi tal Labán tetz. Nin yi je'n pone'n yi jun sman k'ej te yi umle'n, kalena'tz tzun tk'ol Labán yi Raquel tetz ca'p txkel Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ncha'tz tak' Labán jun mos tetz Raquel yi na bi'aj Bilha tan xcone'n tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ok'be'n ib nintzun e' ban Jacow tu Raquel. Poro mast tcunin tzun pek'e'n Jacow te Raquel swutz Lea. Qui't nin octz tan xtxumle'n yi stz'ak'ujk jukt yob tan paj. ");
INSERT INTO aguBl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Itzun bantz yi tilol Kataj Ryos yi qui na pe'k Jacow te'j Lea, nintzun tak' ama'ltz tan jale'n cobox tal i', ma yi Raquel nin cu' makol yi talbiltz. ");
INSERT INTO aguBl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Je'n tzun tekal Lea pwokil jun ni'. Ma yi tule'n itz'ok yi jun ni'a'tz, nin oc tk'ol yi bi'-tz tetz Rubén. ");
INSERT INTO aguBl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Yi xone'n tiemp tekal tzun Lea pwokil junt ni'. Ej nin yi bi' tulej i'tz Simeón. Ej itzun taltz: “Ja tbit Wajcaw yi na tzan telse'n ink'ej, cha'stzun te ja tak' i' junt wal.” ");
INSERT INTO aguBl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nin yi tele'n mas tiemp tekal tzun Lea pwokil yi toxe'n ni'. Nin yi tule'n itz'ok yi toxe'n ni'a'tz nin oc tk'ol yi bi' tetz Leví. Nin tal i': “Ma jalu' spek'ok wuchmil swe'j chinch wetz, na oxix wal che' walaj ta'n.” ");
INSERT INTO aguBl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ej nin tekal Lea pwokil junt ni'. Ya'stzun cyaje'n tal i'. Nin yi bi' tulejtz i'tz Judá. Ej nin yi ntaxk ul itz'ok nintzun tal Lea: “Swak'e' ink'ajsbil tetz Wajcaw jalu'.” Ya'stzun taltz yi tule'n itz'ok yi cyaji'n ni'. Poro ya'stzun wi'tzbil tal Lea njal, na makxe'n nin ban yi talbil i' tan Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Itzun yi tele'n tiemp, nin yi tilol Raquel yi qui'c rmeril tan jale'n chinitxa' tu Jacow, ẍchi'che'n tzun c'u'l i'-tz te'j Lea yi stzicy. Nintzun tal i' tetz Jacow: —Ma jalu' bin, na waj jun wal, kok qui', ẍchinquimok. ");
INSERT INTO aguBl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yi tbital Jacow yi yol Raquel, nintzun je' swutz. Itzun taltz: —¿In ptzun Ryos wetz? ¿In ptzun na chintzan tan makle'n awalbil? Ntin Ryos ilol tetz, stzun Jacow bantz tetz Raquel. ");
INSERT INTO aguBl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","—Ko ya'tz, ba'n tcu'n bin cy'aj tzaj inmos yi na bi'aj Bilha nin okwok itib tuch'. Ma yil jal yi tal, ni'cu'ntz chi ik ina'tz jal wal, stzun Raquel bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Nin tan yi xtxolbile'j tak' Raquel ama'ltz tetz Jacow tan cyok'bel quib tu Bilha, chi txkel bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ma yi cyok'bel quib nintzun jal jun chinitxa' Jacow tu Bilha, yi mos Raquel. ");
INSERT INTO aguBl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Yi jale'n chinitxa' Jacow tu Bilha, nintzun tal Raquel: “Yi ni'e'j, Dan sbne' bi', na tantu' mbit Ryos yi intzi' nin inkul, ja tzun tak' i' jun wal.” ");
INSERT INTO aguBl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Yi xone'n tiemp, jale'n nintzun ban junt tal Bilha. ");
INSERT INTO aguBl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ma yi tule'n itz'ok yi jun ni'a'tz nintzun tal Raqueltz: “Yi ni'e'j, Neftalí sbne' bi', na sajle'n tunintz at bano'n ib skaxo'l tu wutzicy tan paj yi qui'c wetz wal, poro jalu' ja chinxcye' te'j,” stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ma yi tilol Lea yi qui'ct tetz talbil, nintzun tak' ama'l tetz yi mos, yi na bi'aj Zilpa, tan cyok'bel quib tu Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ma yi jale'n chinitxa' Jacow tu Zilpa, ");
INSERT INTO aguBl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","nintzun tal Lea: “¡Chumbalaj nin inswert! Cha'stzun te Gad sbne' bi' yi ni'e'j.” ");
INSERT INTO aguBl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ma yi jale'n yi ca'p chinitxa' Jacow tu Zilpa, ");
INSERT INTO aguBl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","nintzun tal Lea: “Ma jalu' wi'nin na chintzatzin. Ej nin cyakil xna'n scyale': ‘Ba'n tetz Lea, na tzatzin.’ Cha'stzun te Aser sbne' bi' yi ni'e'j,” stzun Lea bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","At tzun jun tir te yi tiemp tan je'se'n triw nin ben Rubén tan xo'n wi cojbil. Te yi na xon i' nin nojquen te jun jilwutz lo'baj yi na bi'aj mandragora. Nin saj tcy'al swutz Lea yi xtxu'. Yi tilol Raquel yi lo'baja'tz te'j Lea, nintzun taltz: —Banaj pawor, tzawak' jun wetz te yi lo'baj yi mmu'l tan awal. ");
INSERT INTO aguBl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Saje'n tzun stza'wel Lea: —¿Qui nin pe' ncu' ac'u'l tan yi mme'l amajol yi wuchmil? ¿Nin ncha'tz na awaj yil tzamaj tlen yi lo'baj yi mmu'l tcy'al wal? —Swak'e' bin ama'l tetz Jacow tan wite'n tzawe'j te ak'bale'j kol tzawak' yi lo'baj swetz, chij Raquel ban. ");
INSERT INTO aguBl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Itzun bantz yi toque'n akale'n, yi tule'n tzaj Jacow tan ak'un wi cojbil, lajke'l nintzun tele'n tzaj Lea tan c'ulche'n. Nin tal tetz: —Ma jalu' cho'n cẍwitok swe'j te jun akale'ne'j, na ja wi't cẍinc'am tetz Raquel, tan yi mandragora yi mmu'l tan wal, chij Lea bantz tetz Jacow. Cho'n tzun wite'n Jacow te Lea te jun ak'bala'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Jale'n nintzun ban yi to'e'n chinitxa' Jacowtz tu Lea, na nsken tbit Kataj Ryos yi stzi' yi kul Lea. ");
INSERT INTO aguBl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Yi tule'n itz'ok, nintzun tal Lea: “Isacar sbne' bi' yi ni'e'j, na i'tz jun oy yi ntak' Ryos swetz tantu' yi nwak' ama'l tetz wuchmil tan toque'n te inmos.” ");
INSERT INTO aguBl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ma yi jale'n yi wukake'n chinitxa' Jacow tu Lea ");
INSERT INTO aguBl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","nintzun tal Lea: “Ryos nmak'on yi jun balaj oye'j swetz. Ma jalu' yi wuchmil spek'ok mas swe'j na ja jal wukakix kanitxa' tuch'. Cha'stzun te Zabulón sbne' bi' yi ni'e'j.” ");
INSERT INTO aguBl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Wi'tzbiltlen jale'n junt tal Lea, yi xun. Dina ban bi'. ");
INSERT INTO aguBl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ma Raquel, qui nin el i' te'j c'u'l Ryos. Nin tbit Ryos yi stzi' yi kul, cha'stzun te k'ak'ane'n c'u'l Ryos tibaj tan jale'n tal. ");
INSERT INTO aguBl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Yi jale'n bajx tal i', nintzun taltz: “Ryos micy'anlen yi jun chin tx'ixwe'n yi at swetz, tan paj yi qui'c wal at. ");
INSERT INTO aguBl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ya'tzk tajbil i' tan jale'n junt wal,” chij Raquel ban. Cha'stzun te toque'n bi' yi ni'a'tz tetz Ẍep ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Itzun bantz te yi nsken ul yos tu Raquel tu ni', nintzun tal Jacow tetz Labán: —Tak'u' ama'l swetz tan waje'n le wetz inluwar. ");
INSERT INTO aguBl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ej nin tak'u' ama'l swetz tan cyaje'n wucy'al yi e' innitxa' nin yi e' wuxkel na ja nak'uj tuch'u' tan chitx'acle'n. Sak cunin swutzu' yi ẍe'n cu'n nnak'uj tuch'u'. ");
INSERT INTO aguBl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Saje'n tzun tlol Labán tetz Jacow: —Yaj, banaj pawor, ncwentu'tz swuch', na ja chinnachon te'j, nin ja lajluchax tzinwutz yi tan aẍ ntak' wit Ryos banl swibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Al tzaj swetz yi nicy'na' nin na awaj yil tzinchoj te ak'ej, list in tan ẍchojle'n, chij Labán ban. ");
INSERT INTO aguBl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Itzun saj tlol Jacow: —Elnak xtxumu' tetz yi ẍe'n cunin nnak'uj tuch'u', ej nin ẍe'n cunin nche' inq'uicy'lej tawunu'. ");
INSERT INTO aguBl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Te yi ntaxk nu'l tuch'u' qui'c mas tawunu', poro jalu' at wi'nin. Jetza'tz yi wule'n tuch'u', ya'stzun xe'te'n Ryos tan tak'le'n banl tibu'. Ba'n yi nink nak'uj tuch'u', poro, ¿tona' lnak'uj wetz tan wetzal yi wetz inme'bi'l? stzun Jacow tetz Labán. ");
INSERT INTO aguBl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","—Qui' yaj, altzaj swetz nicy'na' nin na awaj yil tzinchoj te ak'ej, chij Labán ban. —Qui tajwe'n chin ẍchoju' jun centaw ta', na list in tan chiq'uicy'le'n yi tawunu'. Poro yi kol cu' swutzu' yi xtxolbile'j: ");
INSERT INTO aguBl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tak'u' ama'l swetz tan woque'n chixo'l tawunu', tan chitxa'le'n cyakil yi e' ne'ẍ cneru' yi k'ek cye'j nin yi e' ne'ẍ chiw yi pint cye'j, ya'stzunk injamel sbantz. ");
INSERT INTO aguBl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ej nin yil kaben mas skawutz ba'n tz'ulu' tan tilwe'n yi nicy'na' cu'n yi injamel yi tzintx'aque'. Nin yi kol chijal cneru' nin chiw ẍchixo'l yi wetz yi nk'e'tz k'ek nin nk'e'tz pint cye'j ya'stzun techl yi alak' tzun nche'wulej ẍchixo'l yi e' teru' tawunu'. ");
INSERT INTO aguBl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","—Ba'n, ba'n atit yi atxumu'n yi mbixe' awa'n, chij Labán bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Poro itzun bantz, ite'n nin k'eja'tz toque'n Labán tan chitxa'le'n cyakil yi e' mam chiw yi pint cye'j. Ej nin ncha'tz octz tan chitxa'le'n cyakil tij chiw yi pint cye'j, scyuch' yi e' cneru' yi k'ek cye'j, nin yi e' yi tz'itaji'n tan sak scye'j. Ej nin e' baj nin tk'oltz scyetz e' tetz nitxajil tan cyoque'n tan chiq'uicy'le'n. ");
INSERT INTO aguBl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nin e' el tewal joylajlen, e'ch ox lo' k'ej be' xo'l kale e' opone't ta'n. Ma Jacow, nintzun cyaj cyen tan chiq'uicy'le'n yi sobril tawun Labán. ");
INSERT INTO aguBl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Toque'n tzun i' tan tamle'n e'ch k'ab tze' yi txa'x, yi na bi'aj álamo, almendro tu castaño. Ej nin oc tan telse'n len te'jak tan jale'n cyen tx'ilaji'n sak te'j e'ch k'ab tze'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Cwe'n tzun xtxicbal yi e'ch k'ab tze' ẍchiwutz yi cneru' le ama'l kale na chimolwit quib tan uc'a'e'n. Ej nin yi chimolol quib tul yi jun ama'la'tz, ja chisakchij e' mam chiwtz scye'j e' ti. Tantu' yi cho'n nchisakchbej quib swutz yi e'chk tze'a'tz yi txiclij ẍchiwutz, ja chitz'ij ni' yi pint cu'n cye'j. Yi nchitz'ij nin e' el jatxol Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Cho'n tzun e' baj cwe'ntz yi e' cne'ra'tz ẍchiwutz yi e' tawun Labán yi k'ek tu pint cye'j. Ya'stzun ban Jacowtz tan chijalse'n yi e' tetz tawun yi mero tetz cu'n. ");
INSERT INTO aguBl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ej nin ncha'tz cyakil tir yi nchisakchij yi e' cneru' yi chin chic'atzaj nin, nintzun cu tk'ol Jacow yi e'chk tze'a'tz ẍchiwutz. Na yi xac yi tze'a'tz i'tz: Te yi na chisakchbej quib yi e' tij ja quil yi yubil yi tze'. Ja tzun chitz'ij ni' yi pint cu'n cye'j. ");
INSERT INTO aguBl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ma yi na chisakchij yi e' cneru' yi qui'c mas chic'atzaj qui tzun cu tk'ol Jacow yi tze'a'tz ẍchiwutz, na ya'stzun tetz Labán ban. ");
INSERT INTO aguBl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ya'stzun ban Jacowtz tan riquine'n. Ej nin chin ric nin ban i'. Wi'nin yaj nin wi'nin xna'n jalt tetz mos. Ej nin wi'nin cneru', nin wi'nin buru' scyuch' camey e' jaltz tuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Poro nintzun tbit Jacow yi na chitzan yi e' nitxajil Labán tan talche'n: “Ja riquin Jacow tan yi me'bi'l kataj yi mme'ltzaj tcy'al,” che'ch. ");
INSERT INTO aguBl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ncha'tz el xtxum Jacow tetz yi qui't na pe'k Labán te'j, chi sajle'nix. ");
INSERT INTO aguBl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Yi tilol Kataj Ryos yi na tzan buchle'n Jacow, nintzun taltz tetz: “Ba'n cẍa'jt le chiluwar ataj atxu', kale najlche't yi e' axonl, nin chinxomok tzawe'j.” ");
INSERT INTO aguBl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Bene'n tzun mantar Jacow scye'j Raquel tu Lea yi e' txkel, tan cyule'n te'j, kale atit i' tan chiq'uicy'le'n yi e' cyawun. Yi cyopone'n te'j nintzun taltz scyetz: ");
INSERT INTO aguBl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","—Ja el intxum tetz, yi qui't na pe'k itaj swe'j jalu' chi tane'n sajle'n. Poro yi ketz kaRyosil tu intaj, ilenin xomij swe'j. ");
INSERT INTO aguBl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Sak cunin tziwutz yi ja nak'uj tuch' itaj tetz cu'n walma'. ");
INSERT INTO aguBl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Poro i' tetz ja oc tan insuble'n. Nin cha'tz cuntu' nin nxtx'ixpuj i' yi injamel. Poro qui'c na ban, na quinin ntak' Ryos ama'l tetz tan impo'tze'n. ");
INSERT INTO aguBl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Na yi talol i' swetz: “I yi e' cneru' yi pint cu'n cye'j ya'stzun swak'e' tzatz tetz achojo'n.” Inin tzun bantz. Na yi chijale'n cyal yi e' tij, pint cu'n tzun cye'j e' ban. Ncha'tz yi talol i': “I yi e' cneru' yi xk'inco'j cye'j, ya'stzun swak'e' tetz achojo'n,” tircu'n tzun yi e' cyal yi e' tij yi jal, xk'inco'j cu'n ban yi cye'j. ");
INSERT INTO aguBl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ya'stzun tulej Ryos tan cyelse'n tzaj yi e' wawun tk'ab itaj tan tk'ol i' swetz. ");
INSERT INTO aguBl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","”Ncha'tz at junt tir te yi topone'n yi tiemp tetz chisakchbil yi e' cneru', nin ẍchaj tib jun wutzicy' tzinwutz. I'tz yi e' cneru' xk'inco'j nin sak tu k'ek cye'j ja chisakchij scye'j e' tij. ");
INSERT INTO aguBl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ncha'tz tul yi jun inwutzicy'a'tz wilnin yi jilone'n tzaj yi ángel tetz Kataj swetz. Ja xcon imbi' ta'n tan inchakle'n. Ej nin yi bene'n wital nintzun intziwun nintz: “Je ine'j ta',” chinch ban nintz. ");
INSERT INTO aguBl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ja tzun tal yi ángel swetz: “Xmaynin cunin yi e' mam cneru' yi na chisakchij scye'j e' tij. E' cu'n xk'inco'j nin pint cu'n cye'j. Ya'stzun sbne'tz na ja el intxum tetz cyakil yi na tzan Labán tan nuc'le'n tzawe'j,” stzun yi ángel. Ncha'tz tal i' swetz: ");
INSERT INTO aguBl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","“I ina'tz yi Ryos yi nẍchaj tib tzawutz le ama'l Betel, kale axansawit yi jun c'ub tan aceit nin kale asukwit cobox ayol swetz. In bin yi ara Ryosil. Or awetz, quin, cale'n tzone'j tul yi luware'j nin quilo'k tul yi luwar kale itz'nak quiẍt,” chij i' ban swetz, stzun Jacow bantz scyetz yi e' txkel. ");
INSERT INTO aguBl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Bene'n tzun cyalol Raquel tu Lea: —Qui'ct kocle'n ketz te yi me'bi'l kataj. ");
INSERT INTO aguBl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Na ni'cu'n chi o'-k tu'k awer nak tane'n swutz i', na ja ko' c'ay i' nin ja baj kajamel ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Yi mero bintzij, cyakil yi riquil yi mme'l tzaj tcy'al Ryos tk'ab kataj i'tz ketz, nin cyetz kanitxa'. Ba'n tcu'n banaj cyakil, quib yi ntal Ryos tzatz, che'ch Raquel tu Lea tetz Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Oque'n nintzun ban Jacow tan wekle'n yi e'chk be'ch tetz, tan taje'n tzaj i' Canaán kale najlche't Isaac yi taj. Che' baje'n tzun tk'ol Jacow cyakil yi e' nitxajil nin e' txkel te'jak camey. Nin ncha'tz baj eltzaj tcy'altz cyakil be'ch tetz scyuch' cyakil yi e' cneru' scyuch' yi e' camey nin e' buru', yi e' baj xtx'acoltz te tiemp yi ta'te'n Padan-aram. ");
INSERT INTO aguBl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ma tetz Labán cho'n atpon tan telse'n xi'il yi e' tawun joylaj. Tele'n tzun talk'al Raquel yi e'chk q'uiwil yi at xe c'al Labán. ");
INSERT INTO aguBl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ncha'tz Jacow qui nin ben stziblal ta'n tetz Labán yi ko at cyelbiltzaj. Ya'stzun tulej tan suble'n Labán, yi aj Aram. ");
INSERT INTO aguBl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ele'n tzaj nintzun e' bantz Jacow tu cyakil yi me'bi'l yi nsken jal. Cho'n quicy'e'n tzajtz tibaj yi jun chumam a' yi na bi'aj Eufrates. Ej nin nim nintzun e' sajtz te chibe'. Cho'n tzun cyule'n wi'wtz cwent Galaad. ");
INSERT INTO aguBl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Nsken tzun wi't el oxix k'ej yi cyenle'nix tzaj Jacow yi tbital Labán. ");
INSERT INTO aguBl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Nintzun cu xtxumul chitz'amle'n. Bene'n tzun tcy'al cobox tetz xonl te'j. Yi tele'n juk k'ej chibe' kalena's tzun chitx'amxe'n Jacow cya'n wi'wtz cwent Galaad. ");
INSERT INTO aguBl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Poro itzun bantz, te yi ak'bal yi topone'n Labán kale atit Jacow, nin ẍchaj tib Ryos swutz tul wutzicy'. Itzun tal Ryos tetz: “Bit tzaj, yil cẍoc tan yol tetz Jacow qui na waj yil xcon quiw yol awa'n,” stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Cho'n tzun ujlche' Jacow wi'wtz cwent Galaad yi chitx'amxe'n tan Labán. Yi topone'n i' scyuch' yi e' tetz xonl nintzun e' uje'-tz chixlaj Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Itzun le junt eklok toque'n tzun Labán tan jakle'n puntil tetz Jacow. Itzun taltz: —¿Mbi tzuntz ncu' anuc'ul yi jun ile'j? ¿Nxac nchincu' asubul? I cu'n pres quitane'n inme'l tak'ab yi nche'l tzaj awucy'al. ");
INSERT INTO aguBl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Mbi xac nchincyaj cyen asubul? na ja cẍe'l tzaj tu ojktz nin qui nin mawal tziblal swetz. Yi nink mawal swetz yi ko at awelbiltzaj, tzatzi'n cu'n klo' ncẍe'l tzaj wa'n. Ja klo' katxum jun balaj k'ej. Ja klo' oc tampor tu arpa ka'n. ");
INSERT INTO aguBl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ba'n pe'k yi jak awak' ama'l swetz tan kacawul kib scyuch' yi e' inme'l nin e' inmam. Chin yab nin aẍ te atxumu'n. ");
INSERT INTO aguBl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","At ca'wl tink'ab nin ba'n wicy'sal inc'u'l tzawe'j. Poro quil tzimban na ma's lak'bal njilon yi Ryosil ataj swetz. Ej nin je ntal i'e'j swetz: “Bit tzaj Labán, quil tzawal jun yol quiw tetz Jacow,” chij i' mban. ");
INSERT INTO aguBl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Poro ko wi'nin na el awalma' tan awopone'nt xe ca'l ataj, nin ko ya'tz ncẍe'ltzit ojkuj, nxac nche' baj eltzaj awalk'al yi e' inryosil, stzun Labán bantz tetz Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Saje'n tzun stza'wel Jacow yi yol Labán. I tzun taltz: —Quinin nwal intziblal, tan paj yi ja chinxob na ja no'c tan xtxumle'n, ko tzun che' majquenu' yi e' me'lu' tink'ab. ");
INSERT INTO aguBl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Poro ko al scyetz jun ẍchixo'l yi innajal yi micy'antzaj yi e' ryosilu', ba'n lquim yi juna'tz. Yi e' kaxonl yi ate' tzone'j e' stiw sban te'j. Nin yi ko at e'chk takle'n yi teru' yi ja che' baj eltzaj wucy'al, ba'n tcy'ajninu', chij Jacow bantz. Tal Jacow yi yola'se'j tan paj yi quinin til yi ko Raquel alk'ene'l tzaj yi e' ryosil Labán. ");
INSERT INTO aguBl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Oque'n nintzun ban Labán tulak chimantial yi nsken wi't bnix cya'n tetz chiwitbil. Bajx cunin toque'n i' tul yi mantial Jacow, ma yi baje'n xtxuk'il cyakil, qui nin jal ta'n. Ncha'tz nin octz tan joyle'n tul yi mantial Lea. Ncha'tz baj joyoltz tulak chimantial yi cob xna'n yi chimos yi xomche' scye'j Lea tu Raquel. Poro cya'l nin jale't ta'n. Wi'tzbil tlen nintzun toque'ntz xe mantial Raquel. ");
INSERT INTO aguBl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Yi ntaxk oc Labán tan joyle'n xe mantial Raquel nsken cu tewal Raquel yi cobox ryosa'tz. Cho'n tzun toque'n quen tk'oltz tzak' yi siy yi na je' te'j camey. Nintzun je' c'olchoktz tibaj. Baj cunin joyol Labán tul yi mantial Raquel poro cya'l nin jale'tz ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Jilone'n tzaj tzun Raquel tetz Labán. Itzun taltz: —Ta', max c'u'lu', qui'k lje' swutzu', yi quinin chinxcyeje'n swutzu', na at intx'ajo'n swe'j, chij Raquel ban nintz. Itzun yi wi't baje'n joyol Labán yi e' ryosil xe mantial Raquel, cya'l nintzun jale'tz ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Tantu' yi cya'l nin e' jale't yi e' ryosil Labán ta'n, nintzun je'-tz swutz Jacow. Itzun taltz tetz Labán: —¿Mbi tzun ncu' injuchul swutzu'? ¿Mbi tzun ilil mbnix wa'n, yi ncu' xtxumulu' tan saje'nu' tan intz'amle'n? ");
INSERT INTO aguBl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ja bin baj cunin joyolu' txo'l cyakil yi be'ch wetz. Poro ¿ja pe tzun jal jun takle'nu' txo'l be'ch ketz? Yi ko ja jal tanu' ẍchaj tzaj binu'. Quile' tzaj yi e' teru' xonlu', nin quile' nin yi wetz inxonl na' scyetz i' yi ajpaj skaxo'l tuch'u'. ");
INSERT INTO aguBl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Te yi junak yob yi nnak'uj tuch'u', qui'c cunin jun tawunu' yi qui'k mmitz'ij. Ej qui'c nin jun tir yi jak quim jun tawunu' tetz inchib. ");
INSERT INTO aguBl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ej nin qui'c cunin jun tir jak opon jun tawunu' swutzu' yi quimnak tan balum, na yi na chilo'on cya'n txuc, in tzun wetz na chinchojon teru'. Ej nin cha'tz e' ban yi e' yi ja chiben tan alk'om, na ja bin peyu' swetz. ");
INSERT INTO aguBl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Wi'nin q'uixbel ja icy'pon wa'n tan chiq'uicy'le'n tawunu', ja icy'pon tz'a' wa'n, ja icy'pon che'w wa'n nin ja icy'pon watl wa'n tan paj. ");
INSERT INTO aguBl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Junak yob nna'tij xe ca'lu'. Ja nak'uj cyajlaj yob tuch'u' tan chichojle'n yi cob me'lu', nin kak yob tan chiq'uicy'le'n tawunu'. Nin cha'tz cuntunin na xtx'ixpuju' injameltz. ");
INSERT INTO aguBl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Yi qui'k xomij yi Ryosil incy'e'x Abraham swe'j, yi ite'n nin Ryos yi na c'u'laj intaj Isaac, jun cu'n yol, ntin klo' ink'ab k'alu'n wa'n yi nne'l tzaj klo' lajulu'. Poro ja til Ryos yi bis yi atin cu'nt. Ej nin ncha'tz ja til yi ja jamelan cunin yi wak'un yi mimban tuch'u', cha'stzun te yi mmo'c tan makle'n wutzu' ma's lak'bal, stzun Jacow ban tetz Labán. ");
INSERT INTO aguBl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Jilone'n tzaj tzun Labán tetz Jacow. Itzun taltz: —Yi e' xna'n yi xomche' tzawe'j e' cu'n inme'l. Ej nin yi cyal yi e' xna'na'tz e' cu'n inmam. Ncha'tz cyakil yi awawun yi cy'a'nche' awa'n, e' cu'n wawun. Nin cyakil e'chk takle'n yi cy'a'nche' awa'n, we'tz cu'n. Poro qui'c ltak' kol no'c tan abuchle'n na e' cu'n inme'l, e' cu'n inmam yi xomche' tzawe'j. ");
INSERT INTO aguBl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Cha'stzun te ba'n tcu'n kabixbaje' jun katrat tzawuch' yi xconk tetz quiwel kayol. ");
INSERT INTO aguBl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Bene'n tzun Jacow tan ticy'le'ntzaj jun c'ub, nin cu tawal. Txicl tzun tulejtz chi na ban jun tkan ca'l. ");
INSERT INTO aguBl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Bene'n tzun tloltz scyetz yi e' xonl: —Molwok tzaj cobox c'ub tzone'j, stzun i' ban nintz. Cyoque'n tzun yi e' xonl Jacow tan molche'n tzaj c'ub. Junit nin chin muluj bantz cya'n. Ej cho'n tzun e' wane'ntz Jacow tu Labán xlaj yi jun chin muluj c'uba'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Toque'n tzun tk'ol Labán bi' yi jun ama'la'tz le tetz yol. Yi bi' oc ta'n i'tz Jegar Sahaduta. Ma tetz Jacow nin oc tk'ol bi' tetz Galaad na ja xcon yi tetz yol ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","—Yi jun muluj c'ube'j ya'stzun stiw sbne' skaxo'l tzawuch', stzun Labán bantz. Cha'stzun te toque'n bi' yi jun luwara'tz tetz Galaad. ");
INSERT INTO aguBl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ncha'tz oc bi' tetz Mizpa na nin tal Labán: —Kajatxe' kib jalu' tzawuch'. Poro tz'ocopon Ryos tan kaxmaye'n tzaj. Ej nin stk'e' kacaws kol quil ke'l cu'n te'j kayol. ");
INSERT INTO aguBl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Or tzawil yaj yi kol cẍoc tan chibuchle'n yi e' inme'l, nka kol jal mas awuxkel. Qui lo' lwil wetz, poro Ryos stile', na i' stiw skaxo'l, stzun Labán bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ncha'tz tal Labán tetz Jacow: —Yi jun muluj c'ube'j tu yi jun yi ja cyaj cyen wawal tzone'j, ");
INSERT INTO aguBl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ya'stzun cob kastiw sbne' kol kicy' cu'n te yi mojome'j tan oyintzi' skibil kib. ");
INSERT INTO aguBl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ba'n tz'oc yi Ryosil acy'e'x Abraham, yi ryosil incy'e'x Nacor tu e'chk ryosil chitaj tan kama'le'n nin tan tak'le'n kacaws, ko quil ke'l cu'n te kayol, stzun Labán tetz Jacow. Nintzun cu'-tz swutz Jacow yi xtxumu'n Labán nintzun ben sukil yi yoltz tetz: —Sak cu'n swutz inRyosil, yi ncha'tz na c'u'laj intaj Isaac te'j, yi nelepon cu'n te'j inyol, stzun Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Toque'n tzun Jacow tan pate'n xtx'ixwatz wi yi ju'wtza'tz kale ate't. Ncha'tz e' baj ẍchakol cyakil yi e' xonl yi ate'-tz. E' baj wan lentz ta'n. Ej nin baj cunin jun ak'bala'tz cya'ntz wi jun ju'wtza'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Itzun yi tule'n skil, chin jalchan cunin c'ase'n Labán nintzun octz tan stz'uble'n xak chitzi' yi e' mam, scyuch' yi e' me'l. Nin tak' yi banl squibaj. Ma yi baje'n tk'ol yi banl squibaj aje'n nintzun bantz xe tetz najbil. ");
INSERT INTO aguBl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Icy'e'n nintzun e' ban Jacow. Poro te yi na chixon tbe' nin e' chaj quib jun c'oloj ángel tetz Ryos swutz. ");
INSERT INTO aguBl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yi chibene'n xmayil, nintzun taltz: “Jun cu'n yol yi jun c'oloje'j, e' cu'n sanlar tetz Ryos.” Cha'stzun te toque'n bi' yi jun ama'la'tz ta'n tetz Mahanaim. ");
INSERT INTO aguBl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Che' bene'n tzun ẍchakol Jacow cobox ẍchakum, jalen le yi luwar yi na bi'aj Seir, cwent Edom, tan talche'n stziblal tetz Esaú yi stzicy yi at topombil i'. ");
INSERT INTO aguBl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Nin je ben tloltz scyetz yi e' ẍchakum: “Quibene'nk wok nin alwok cyen tetz wutzicy Esaú: ‘Tz'ul Jacow yi titz'unu', nin list i' tan banle'n tane'n cyakil yi tajbilu'. Nin je nsaj tlol i' teru'e'j: Ja chinnaje' jun c'oloj tiemp tu Labán. ");
INSERT INTO aguBl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Nin jalu' ja chijal inwacẍ, ja chijal imburu', ja chijal wi'nin incneru'. Ncha'tz ja chijal wi'nin yaj tu xna'n tetz inmos,’ ẍchijwok sban tetz wutzicy. Alwok quen yi xtxolbile'j tetz, na na waj yil tz'opon yi intziblal twi' tan mayse'n c'u'l i', nin ba'nk sban swutz.” ");
INSERT INTO aguBl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Itzun yi chipakxe'n tzaj yi e' mos Jacow te yi chimantar, nintzun cyaltz tetz: —Ja wi't xka'ktzaj te yi stzicyu' Esaú, nin xomtzaj i' wutz kacoc tan c'ulche'nu'. Xomche' cyaj cient yaj te'j, che'ch yi e' ẍchakum Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yi tbital Jacow yi xtxolbile'j, nintzun saj jun chin xo'wtz te'j, nin octz tan xtxumle'n. Toque'n tzuntz tan chijatxle'n cu'n cyakil yi e' wunak yi xomche'-tz te'j. Cob cuntunin e' eltz ta'n. Ncha'tz e' tulej yi e' cneru' tu yi e' wacẍ scyuch' e' camey. ");
INSERT INTO aguBl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Na nin octz tan xtxumle'n: “Yi kol tz'oc Esaú tan oyintzi' scye'j yi bajx k'u'j yi bajxche', ba'n tzun lche'l ojkuj yi ca'p k'u'j yi xomche't nin.” ");
INSERT INTO aguBl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Xe'te'n nintzun bantz tan nachle'n Kataj. Itzun taltz: “Wajcaw, ilu' Ryosil incy'e'x Abraham nin ilu' Ryosil intaj Isaac. Ilu' bin a'lon swetz tan impakxe'n tzaj tul yi intanum, nin tan wopone'nt scye'j intaj intxu'. Nin ncha'tz talu' swetz yi ba'n cuntu' sbne' yi impyaj. ");
INSERT INTO aguBl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Qui'c mu'ẍ tal eka'n wa'n ta', poro ja tak'u' yi banlu' swibaj, nin ja elcu'nu' te yi suknaku' swetz. Qui'c cy'a'n wa'n yi wicy'e'n tibaj yi jun tzanla'e'j yi na bi'aj Jordán. Ntin jun intx'amij cy'a'n wa'n yi wicy'e'n tzaj, poro jalu' xomche' cob chin wutzile'n k'u'j wunak tu cob k'u'j wawun swe'j. ");
INSERT INTO aguBl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","I bin jalu' ta', bne'u' pawor swetz, chin cole'u' tk'ab wutzicy Esaú. Jun cu'n yol na chinxob tetz na quicunin batz tz'ul i' tan oyintzi' swe'j. Nin lche' biycu'n yi e' wuxkel scyuch' yi e' tal innitxa' yi xomche' swe'j. ");
INSERT INTO aguBl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ma jalu' bin ta', chincole'u'. Na clarcunin talnaku' swetz yi ba'n cuntu' sbne' yi impyaj tanu'. Ej nin talnaku' swetz yi quinin ajlbe'n cyetz sbne' cyajlal yi e' inxonl. Ej nin talnaku' yi cho'n sbne' cyajlal chi tane'n yi samlicy' yi at stzi mar yi qui nin ajlbe'n tetz,” stzun Jacow bantz tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ta'ste'n nintzun cyaj cyent Jacow tan watl te yi jun ak'bala'tz nin octz tan xtxa'le'n balaj oytz ẍchixo'l cyakil yi cy'a'ntz ta'n tan tak'le'n tetz Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","E' je' xtxa'ol cob cient chiw yi e' cu'n tij, tu junak mam, nin e' je' xtxa'ol cob cient cneru' yi e' cu'n tij, tu junak mam. ");
INSERT INTO aguBl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Ncha'tz e' je' xtxa'ol junaklaj tij camey yi ac'aj cunin baj cu' yi cyal, nin e' baj ben xomok yi cyal scye'j. Ncha'tz e' je' xtxa'ol ca'wunak tij wacẍ tu lajuj tor. Wi'tzbil tlen cyele'n tzaj xtxa'ol junak tij buru' tu lajuj mam. ");
INSERT INTO aguBl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Nintzun e' baj nin jatxoltz scyetzak yi e' ẍchakum. Ej ben jatxol yi jun k'u'j chiw scyetz cobox ẍchakum. Ej nin ben tk'ol yi jun k'u'j cneru' scyetz coboxt ẍchakum. Ncha'tz e' tulej yi e' mas tawun. Nintzun ben tloltz scyetz e' ẍchakuma'tz: —Ba'n cẍbajxij wok nin ba'n lch'uy mu'ẍ ixo'l yi jujun k'u'j axwok scyuch' yi e' awun. ");
INSERT INTO aguBl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ej nin ben cawultz yi bajxom te yi bajx k'u'j. Itzun taltz tetz: —Yil tzic'ul cu'n itib tu wutzicy Esaú, nin yil sjaktzaj tzatz na' scyetz i' yi apatrón, nin na' ncẍbene't, nin na' cyaw yi awun yi cy'a'nche' ita'n, ");
INSERT INTO aguBl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ba'n tzawal tetz: “Yi je'j i'tz jun oy teru', ta' Esaú. Kawutzile'n Jacow, yi xconsbe'tzu', mmak'on tzaj tetz teru'. Cho'n xomtzaj i' tetz jalen wutz kacoc,” ẍchij wok sbantz tetz, stzun Jacow bantz tetz yi ẍchakum. ");
INSERT INTO aguBl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ncha'tz taltz tetz yi ca'p nin yi toxi'n scyuch' cyakil yi e' yi e' ben ẍchakol scyuch' yi jujun jilwutz awun. —Yil tzic'ulwok yi wutzicy Esaú, ite'n nin tzital woktz tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ncha'tz alwok tetz: “Yi wutzile'n ta' Jacow yi xconsbe'tzu' xomt tzaj jalen wutz kacoc,” ẍchij wok sban. Ya'stzun tulej Jacow, na nin octz tan xtxumle'n: “Tan yi e'chk oy yi lbajxopon wa'n swutz, xcyek tan xite'n yi ẍchi'che'n c'u'l swe'j, te yi ntaxk kac'ul kib tuch'. Nin quicunin batz stzatzink swe'j yil kac'ul kib.” ");
INSERT INTO aguBl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Bene'n nintzun e' ban yi mos scyuch' yi jujun jilwutz oy yi ben quicy'al. Ma Jacow, nin cyajtz. Cho'n tzun wite'ntz le ama'la'tz scyuch' yi e' mas yi xomche' te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ite'n nin ak'bala'tz oc Jacow tan chichakle'n cy'en yi cob txkeltz tu yi cob chimos, scyuch' yi junlaj cy'ajl. Cho'n tzun quicy'e'ntz ta'n tibaj yi jun tzanla' yi na bi'aj Jaboc. ");
INSERT INTO aguBl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ncha'tz e' baj ben xomok cyakil yi e' yi xomche'tz te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Itzun te yi cyaje'n cyen Jacow ẍchuc, nin oc jun yaj tan pil ib tuch'. Ul cunin skiltz cya'n tan pil ib. ");
INSERT INTO aguBl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ma yi tilol yi jun yaja'tz yi qui'c nin rmeril tan xcyewe'n te'j Jacow, nin bentz tan xtxak'le'n yi xtxo' cy'ach Jacow. Ej ninin tzun el jiẍpuj yi bakil yi cux Jacow ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Jilone'n nin tzun yi jun yaja'tz tetz. Itzun taltz: —Chin atzakplen, na tzan tule'n skil, stzun i'-tz tetz Jacow. —Yi ko quil tak'cyenu' yi imbanl, quil tzintzakplenu', stzun Jacow tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","—¿Mbi tzun abi'? stzun yi yaj tetz Jacow. —Jacow bin wetz imbi', stzun i' ban. ");
INSERT INTO aguBl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Bene'n tzun tlol yi yaja'tz tetz: —Ma jalu', nk'e'tz Jacow sbne' abi' ma na Israel sbne' ara bi', na ja abuch awib tan jakle'n abanl tetz Ryos nin scye'j wunak nin ja ẍcye'-tz. ");
INSERT INTO aguBl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","—Ma jalu' bin, tale'u' swetz, ¿mbi tzun teru' bi'u'? stzun Jacow banintz tetz yi jun yaja'tz. Saje'n tzun stza'wel yi jun yaja'tz: —¿Mbi xac na ajak tzaj swetz yi imbi'? stzun i' bantz. Ej nin ta'tz te'nin bentz tan tak'le'n yi banl tibaj Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Nintzun oc tk'ol Jacow bi' yi jun luwara'tz tetz Penuel, na nin tal i'-tz: “Ja wil wutz Ryos, poro ntyoẍ tetz i' yi itz'ine't.” ");
INSERT INTO aguBl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Itzun yi je'n mule'n yi k'ej icy'e'n atit Jacow le yi jun luwara'tz yi na bi'aj Penuel. Co'xi'n na xon tan paj yi q'uixpnak yi xtxo' cux. ");
INSERT INTO aguBl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Cha'stzun te jalu', cyakil yi e' xonl Israel, qui na baj yi ibotx' cya'n yi at te yi bakil yi cux na ya'stzun elsawutzil te yi bakil Jacow yi lo'on, nin yi el tzaj jiẍp, nicy' yi chipilul quib tu Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yi bene'n tilol Jacow yi txant tan tule'n Esaú tu yi cyaj cient ẍchakum, nintzun cu jatxol yi e' cy'ajl chik'ab Lea tu Raquel scyuch' yi cob chimos. ");
INSERT INTO aguBl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ej nin oc tan chitxole'n cu'n. E' bajx cu'n yi cob chimos scyuch' yi cyal ta'n. Xomt nin Lea scyuch' yi tetz tal. Wi'tzbil tlen xomt nin Raquel tu Ẍep yi tal i'. ");
INSERT INTO aguBl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ma i' tetz, nin bajx cu'n ẍchiwutz tan c'ulche'n Esaú. Nin yi txant tan chic'ulul quib nin cu jokloktz jalen cu'n cwe'n pone'n lajpuj yi wutz plaj wuxtx'otx'. Juk tzun tir bantz jalen cu'n chic'ulul quib tu Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ma yi Esaú lajke'l tzun bene'ntz tan c'ulche'n Jacow. Nin bentz tan k'ale'n nin tan stz'uble'n xlajak stzi'. Ej nin e' baj ok' cu'ntz chicabil. ");
INSERT INTO aguBl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Itzun yi bene'n tilol Esaú yi e' xna'n scyuch' yi e' nitxa' yi xomche' te'j Jacow nintzun ben jakoltz tetz: —¿Na' cyaw yi cobox xna'ne'j scyuch' yi e' nitxa' yi xomche' scye'j? —E' cu'n wetz, ma yi e' nitxa'e'j e' cu'n incy'ajl yi Ryos mak'on swetz, stzun Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Chisaje'n tzun chiẍkansal quib yi cob mos scyuch' cyal nin e' baj cu'n joklok swutz Esaú jalen cu'n cwe'n pone'n yi wutz chiplaj wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ncha'tz ban Lea scyuch' tal, e' baj ul chiẍkansal quibtz nin e' baj cu jokloktz swutz Esaú. Wi'tzbil tlen cyule'n Ẍep tu Raquel nin e' cu jokloktz swutz. ");
INSERT INTO aguBl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","—¿Ma jalu' mbi'tz yi atxumu'n scye'j yi jujun k'u'j awawun yi nchibaj inc'ulul? —I'tz jun oy teru' ta', tan stzatzine'nu' swe'j, stzun Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","—Qui', aẍ jun c'oloj witz'un, at wi'nin wetz wawun, stzun Esaú bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Poro chin ch'inch'uj nintzun ban Jacowtz tan chisuke'n. Itzun taltz: —Bane'u' pawor swetz ta', yi ko bintzij nin na tzatzinu' swe'j, stz'ame'u' yi oye'j. Na tantu' yi na tzanu' tan ẍchajle'n yi balajilu' swetz, ni'cu'n chi nak chintzan tan tilwe'n wutz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Na cu' inwutz teru' ta' tan stz'amolu' yi jun oya'tz yi ja ul wa'n teru' na Ryos mmak'on inriquil nin qui'c tajwe'n swuch'. Tantu' yi chin ch'inch'uj nin ban Jacow tan suke'n yi oy, baj nintzun c'u'l Esaú yi stz'amol. ");
INSERT INTO aguBl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Bene'n tzun tlol Esaú: —Quin bin. Kicy'okt. Chimbajxok cu'n tziwutz. ");
INSERT INTO aguBl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","—Max c'u'lu' ta', ilu' jun c'oloj wutzicy, poro na tilu' yi e' nitxa' quil chitx'aj xo'n lajke'l. Ej nin ncha'tz yi e' tal cneru' scyuch' inwacẍ yi at len cyal yi quil chitx'aj xo'n. Kol chik'e'xij, qui cunin batz tul jun ntzi' k'ej ẍchiquimok tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Max c'u'lu' wajcaw, ba'n tcu'n yi nink lbajxiju' skawutz. Cheb cuntu' kaxomtnin ketz wutz chicocu', quib yi chixon yi e' wawun scyuch' e' nitxa'. Cho'n kilt kib jalen Seir kale najle'tu', stzun Jacow tetz Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","—Cuj, chij Esaú. —Poro ba'n chicyaj cobox inchakum tetz ixk'ajlab. —Qui' lo' ta', quil bisunu' ske'j. Kopon ketz. ");
INSERT INTO aguBl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ite'n nintzun k'eja'tz cwe'n Esaú tbe' tan je'n pone'n jalen Seir. ");
INSERT INTO aguBl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ma Jacow qui nin xom nintz wutz coc ma cho'n taje'n cu'ntz Sucot. Ya's bnixe't jun tetz ca'l ta'n. Ncha'tz bnix cobox scabte' scyetz e' tawun. Cha'stzun te toque'n bi' yi jun ama'la'tz ta'n tetz Sucot. ");
INSERT INTO aguBl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ba'n cuntu' mu'l Jacow Canaán jetz yi tele'n tzaj jalen Padan-aram. Ej nin cho'n je'n bnol yi tal pach i' yi mantial tu' swutz len yi tnum Siquem. ");
INSERT INTO aguBl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ej nin lok' i' jalaj tx'otx' scyetz xonl Hamor yi taj Siquem. Jun cient pwok lok'wit i' yi jalaj tx'otx'a'tz. Ej nin ya'stzun luwar kale je't bnol yi tal pach. ");
INSERT INTO aguBl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yi xone'n tiemp nin bnix jun patbil xtx'ixwatz ta'n. Nin oc tk'ol yi bi' tetz El-Elohe-Israel. ");
INSERT INTO aguBl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","2","At tzun jun ajcaw te yi tnum Siquema'tz yi na bi'aj Hamor yi heveo. Ej nin at jun cy'ajl i' yi na bi'aj Siquem. Itzun bantz nin ben Dina, yi me'l Jacow te'j Lea tan chixajse'n yi e' xun yi najlche' tul yi jun tnuma'tz. Poro yi bene'n tilol Siquem nin tzun octz tan banle'n ruinl tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Poro tan paj yi wi'nin pek'e'n quen i' te'j Dina, nin octz tan tocse'n c'u'l tan cyok'bel quib tuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ej nin ncha'tz tal i' tetz taj: —Bane'u' pawor ta', benku' swe'j tan jakle'n yi jun xune'j, na na waj kok'bej kib tuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yi tele'n xtxum Jacow tetz yi nsken wi't ban Siquem ruinl te yi me'l, qui nin tal jun yol, tan paj yi quibe' cy'ajl i' xe ca'l. Na cho'n cu'n ate' joylaj tan chiwate'n cyawun. Nintzun ẍch'iw i' jalen yi baj cyule'n. ");
INSERT INTO aguBl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Te yi na tzan Jacow tan chich'iwe'n yi e' cy'ajl opone'n nin ban Hamor yi taj Siquem tan jakle'n Dina. ");
INSERT INTO aguBl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Itzun yi chipakxe'n tzaj yi e' cy'ajl Jacow tan chiwate'n yi cyawun nin yi quibital yi mbi cu'n bajij, nintzun saj jun chin chi'ch c'u'lal scyetz, na chin tx'ixwil nin scyetz yi e' xonl Israel yi toque'n Siquem tan banle'n ruinl te yi me'l Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ma Hamor, nintzun opon junt tir tan yol scyetz Jacow tu e' cy'ajl. Itzun taltz: —Wi'nin na pe'k yi incy'ajl Siquem te cyeru' cyanubu'. Max chic'u'lu', chibne'u' jun pawor sketz. Qui pe'l cyak'u' ama'l tetz cyanubu' tan cyok'bel quib tu wetz incy'ajl. ");
INSERT INTO aguBl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ej junit tzun lkaban scyuch'u'. Nin ba'n tzun lcyok'bej kib yi ketz kacy'ajl scyuch' yi cyeru' chime'lu'. Ncha'tz lchiban yi cyeru' chicy'ajlu', ba'n lcyok'bej quib scyuch' yi ketz kame'l. ");
INSERT INTO aguBl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ej nin ban chinaje'u' skuch'. Na je katnume'j. Ba'n lchijoyu' na'l chinajewe'tu'. Ba'n lchinegosinu' skaxo'l, nin ba'n lchilok'u' chitx'otx'u' skaxo'l, stzun Hamor bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ncha'tz Siquem nin taltz tetz taj Dina scyuch' e' xibin: —Na cu inwutz scyeru' yi nink cu yi jun inyole'j ẍchiwutzu'. List in tan tak'le'n nicy'na' cu'n lchijaku' swetz. ");
INSERT INTO aguBl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Qui'c na ban kol chijaku' mas swutz yi kacstumbr tzone'j. Max chic'u'lu', cyak'e'u' ama'l sketz tan kok'bel quib tu cyanubu'. ");
INSERT INTO aguBl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ma yi e' cy'ajl Jacow nin e' octz tan chisuble'n Siquem tu yi taj tan paj yi nsken wi't ban Siquem ruinl tetz Dina. ");
INSERT INTO aguBl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Itzun cyaltz: —Qui'c rmeril tan kak'ol yi kanub tetz jun yaj yi nk'e'tz circuncidado, na chin tx'ixwil nin tetz ketz. ");
INSERT INTO aguBl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Cuj ka'n, poro ntin yi ko list e'u' tan chibnol circuncidar quibu' chi kutane'n ketz. Poro ncha'tz tajwe'n tan chibaje'n circuncidar cyakil yi e' yaj yi ate' ẍchixo'lu'. ");
INSERT INTO aguBl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ba'n tzun cyok'bej quib yi e' kame'l scyuch' cyeru' chinitxajilu'. Ej nin ncha'tz o' ketz, ba'n lkok'bej quib scyuch' cyeru' chime'lu'. Skanajank tzun ẍchixo'lu' nin junit lkaban scyuch'u'. ");
INSERT INTO aguBl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Poro ko quil cu ẍchiwutzu' tan chibanolu' circuncidar quibu', kicy'tpon tzun ketz tzone'j nin mben kucy'al yi kanub ske'j, che'ch yi e' xibin Dina bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Nintzun cu ẍchiwutz Hamor tu Siquem mbi cu'n a'lchij scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Lajke'l nintzun toque'n Siquem tan joyle'n puntil tan banol circuncidar tib na wi'nin pek'e'n i' te me'l Jacow. Nin tan tu' yi chumbalaj nin tajtza'kl yi jun xicya'tz ẍchiwutz cyakil wunak, ");
INSERT INTO aguBl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","e' bene'n tzun tu taj tan yol scyetz wunak stzi puertil yi tnum na ya'stzun yi luwar kale na bnixe't e'chk contrat. Itzun cyaltz scyetz e' aj tnum: ");
INSERT INTO aguBl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","—Yi e' wunak yi nchu'l skaxo'l, e' cu'n kamiw. Ẍchinajank nin ẍchinegosink skaxo'l tzone'j, na at wi'nin tx'otx' tzone'j tetz ketz, nin tetz cyetz. Ncha'tz ba'n lkok'bej kib scyuch' yi cyetz chime'l. Ej nin yi e' cyetz chicy'ajl ba'n lcyok'bej quib scyuch' yi ketz kame'l. ");
INSERT INTO aguBl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Poro tan koque'n junit scyuch', nin tan chinajewe'n skaxo'l, ntin at jun xtxolbil yi tajwe'n tan kabnol tane'n. I'tz yi tajwe'n tan kabnol circuncidar kib ketz, chi na chiban cyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kol kacujij yi chiyol, ketz tzun sbne' cyakil chime'bi'l scyuch' cyakil yi cyawun. Ntin na taj yil kal cuj. Ej nin ẍchicyajk tzuntz skaxo'l. ");
INSERT INTO aguBl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Cyakil tzun e' yaj yi ate'-tz, yi nsken wi't opon chitiemp tan chixcone'n tetz sanlar, oc chicuj te'j yi mbi cu'n cyal Hamor tu Siquem. Ninin tzun e' bajij circuncidar. ");
INSERT INTO aguBl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Itzun bantz, le toxi'n k'ej yi nsken wi't chiban circuncidar quib, nin te yi atit yi ẍch'onal scye'j, nintzun e' ben Simeón tu Leví tnum. Ej nintzun e' octz tan chibiyle'n cu'n yi e' yaj tan spar. Na qui'ct rmeril tan chicolol quib tan paj yi ẍch'onal yi chiwankil. Yi Simeón tu Levíja'tz, e' cob scyeri yi e' cy'ajl Jacow. Ej nin e' xibin Dina. ");
INSERT INTO aguBl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ncha'tz Hamor tu Siquem yi cy'ajl, e' baj quim cya'n tan spar. Ej nin eltzaj quicy'al Dina xe ca'l Siquem, nin aj quicy'altz scye'j. ");
INSERT INTO aguBl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ncha'tz e' baj opon len yi e' mas cy'ajl Jacow. Ej nin e' icy'tz ẍchixo'l e' alma' tan talk'e'n tzaj cyakil yi mbi cu'n attz tnum. Ya'stzun e' bantz tan quicy'sal chic'u'l scye'j, tan paj yi bnol Siquem ruinl te cyanub. ");
INSERT INTO aguBl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Baj el quicy'al cyakil cneru' tu wacẍ scyuch' cyakil e' buru'. Ej nin baj el quicy'al cyakil yi at tnum tu yi at solte'j len. ");
INSERT INTO aguBl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ncha'tz e' baj oc xe'ak ca'l tan talk'e'n cyakil yi attz. Ej nin baj ben quicy'al yi e' nitxa' scyuch' yi e' xna'n tan chixcone'n tetz chimos. ");
INSERT INTO aguBl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yi tbital Jacow yi mbi cu'n bajij nin tzun taltz tetz Simeón tu Leví: —Atin wutz pe'm tan yi xtxolbile'j, na cyakil yi e' wunak yi najlche' tzone'j, yi e' aj Canaán scyuch' yi e' ferezeo, ẍchi'chok chic'u'l swe'j. Tan paj yi xtxolbile'j, tz'ul chimolol quib tan oyintzi' swe'j. Ẍchinquimok cya'n scyuch' innajal na qui'c mas kawunakil tan oyintzi'. ");
INSERT INTO aguBl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Saje'n tzun chitza'wel Simeón tu Leví: —¿Nxac mo'c Siquem tan banle'n ruinl te kanub? ¿Wi'tz bnol tetz pe' kanub swutz i'? che'ch bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Itzun bantz nintzun jilon Ryos tetz Jacow. Itzun taltz: “Ma jalu' Jacow quilo'k jalen Betel, nin ba'n cẍnaje' chone'j. Ej nin tul yi jun ama'la'tz ba'n tzaban jun patbil atx'ixwatz tan inc'u'laje'n. Yi in wetz, in yi Ryos yi inchaj wib tzawutz nicy' yi awele'n tzaj ojk swutz awutzicy Esaú.” ");
INSERT INTO aguBl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Bene'n tzun tlol Jacow scyetz cyakil yi najal scyuch' cyakil yi e' wunak yi xomche'-tz te'j: —Or tele'n tzaj itcy'al cyakil yi e'chk iryosil yi colij ita'n. Ej nin or tx'ajwok itib, ncha'tz tx'ixpwok len be'ch itetz. ");
INSERT INTO aguBl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Na cho'n kaben jalen Betel, nin cho'n sbnixok jun patbil tx'ixwatz wak'un tan tak'le'n k'ej yi inRyosil yi ocnak tan wuch'eye'n nicy' yi na sotz tzaj inc'u'l. Ej nin i' yi jun yi xomquen tunin swe'j alchok tunin na na'j nint. ");
INSERT INTO aguBl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Baj saje'n tzun chik'oltz tetz Jacow cyakil yi e'chk chiryosil. Ncha'tz baj saj chik'ol yi e'chk tc'u'l chiẍchin. Bene'n tzun Jacow tan mukle'n xe jun wi' bakch yi attz nakajil Siquem. ");
INSERT INTO aguBl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Itzun te yi cyele'n tzaj Jacow, nin saj jun chin xo'w tan Ryos scye'j cyakil yi e' wunak yi najlche'-tz tulak yi e'chk tal tnum yi ate'-tz nakajil Siquem. Cha'stzun tej qui nin chinimsaj chic'u'l tan chisaje'n tan chitz'amle'n nin tan chibiyle'n cu'n Jacow scyuch' yi e' nitxajil. ");
INSERT INTO aguBl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Cho'n tzun cyopone'n Jacowtz scyuch' cyakil yi e' yi xomche' te'j le tnum yi na bi'aj Luz. Yi jun tnuma'tz ncha'tz na bi'aj Betel. Nin cho'n attz cwent Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Itzun te yi wi't baj cyopone'ntz le jun tnuma'tz nintzun oc Jacow tan banle'n jun patbil xtx'ixwatz, nin oc tk'ol yi bi'tz tetz El-betel, ya'stzun tulejtz na i yi nicy' yi tele'n ojkuj swutz yi stzicy, cho'n ẍchajol tib Ryos swutz le jun ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ncha'tz tul yi jun ama'la'tz, cho'n quime'n yi jun xna'n yi na bi'aj Débora yi mos Rebeca. Cho'n tzun mukxe'ntz cya'n tzak' jun wi' bakch yi attz nakajil Betel. Nin oc tk'ol Jacow yi bi' yi jun ama'la'tz tetz “Yi jun wi' bakch kale baje't bis o'kl.” ");
INSERT INTO aguBl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Itzun nicy' yi tele'n tzaj Jacow Padan-aram, nin yi nicy' yi na xon i' tbe', nin ẍchaj tib Ryos swutz, nin tak' yi banltz tibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Na je tal i'e'j: “Yi ara bi' i'tz Jacow, poro sbne' opon tunintz nk'e'tz Jacow sbne', ma na Israel sbne'.” Itzun te yi nsken wi't je' xtx'ixpul Ryos yi bi' Jacow, ");
INSERT INTO aguBl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","nintzun taltz tetz: “I ina'tz yi Ryos yi na chin xcye' tan kojle'n nin yi imbanl tibaj jun. Ẍchijalok tzun wi'nin anitxa'. Nin ẍchijalok wi'nin axonl. Nin tan aẍ ljale't wi'nin nación, nin chin wutzile'n nin ẍchibne' e'chk nacióna'tz. Ncha'tz ẍchijalok rey ẍchixo'l yi e' axonl. ");
INSERT INTO aguBl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ej nin cyakil yi luwar yi wak'nak tetz Abraham nin tetz Isaac. Ncha'tz swak'e' tzatz. Ej nin yil ẍquim atz swak'e' scyetz yi e' axonl.” ");
INSERT INTO aguBl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Itzun yi wi't jilone'n Ryos tetz Jacow tul yi luwara'tz aje'n nin bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Bene'n tzun Jacow tan ticy'le'n tzaj jun c'ub, nin cu tawaltz. Txicl tzun tulejtz chi na ban tawle'n jun tkan ca'l. Cho'n tzun cwe'n tawaltz le ama'l kale jilone't Ryos tetz. Bene'n nin bantz tan xanse'n yi jun c'uba'tz nin baj je' kojol aceit tu win tibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ncha'tz nin oc tk'ol bi' yi jun ama'la'tz tetz Betel. ");
INSERT INTO aguBl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Icy'e'nt nintzun e' bantz swutz yi jun ama'la'tz yi na bi'aj Betel. At tzaj nintzun mu'ẍt yi chibe' tan cyopone'ntz jalen Efrata yi tule'n yos tu Raquel. Chin q'uixc'uj nin bantz yi tule'n yos tuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Itzun te yi at Raquel swutz yi wi'tzbil q'uixc'uj tan tule'n yos tuch', jilone'n tzaj tzun yi xe'iyum tetz. Itzun taltz: “Quil cxob na yi ni', i'tz jun awal xicy.” ");
INSERT INTO aguBl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Poro jalt cuntunin tan quime'n Raquel tan bi'l yi q'uixc'uj. Pentlen tunin tzun na molne' yi talma' Raquel, yi toque'n cyen yi bi' yi ni' ta'n, nin oc tk'ol tetz Benoni. Ma yi Jacow nin oc tk'ol yi bi'tz tetz Benjamín. ");
INSERT INTO aguBl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ya'stzun bantz yi quime'n Raquel. Cho'n mukxe'n cyentz cya'n tbe' nicy' yi na chixon tan cyopone'n Efrata. Yi jalu' yi jun tnuma'tz na bi'aj Belén. ");
INSERT INTO aguBl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yi wi't mukxe'n Raquel nintzun je cyen banol Jacow jun nich tibaj yi mu'ẍ ama'l kale mukxe't. Ya'stzun yi jun nicha'tz yi na chajon yi ama'l kale mukxe't Raquel. ");
INSERT INTO aguBl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Nintzun e' cu' Israel junt tirtz tbe'. Cho'n tzun cyopone'ntz swutz len yi Torre cwent Edar. ");
INSERT INTO aguBl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Itzun te yi chinajewe'n tul yi jun luwara'tz nintzun e' witbej quib Rubén tu Bilha. Yi jun Bilha-a'tz i' jun ca'p txkel yi taj tane'n. Yi tbital Jacow, yi taj Rubén, yi xtxolbile'j wi'nin tzun ẍchi'che'n c'u'l bantz. Coblaj cu'n tzun cy'ajl Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Yi e' cy'ajl Jacow yi e' jal te'j Lea i'tz: Rubén yi bajx cy'ajol, Simeón, Leví, Judá, Isacar tu Zabulón. ");
INSERT INTO aguBl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ma e' yi e' jal te'j Raquel i'tz: Ẍep tu Benjamín. ");
INSERT INTO aguBl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Nin e' yi e' jal te Bilha, yi mos Raquel i'tz: Dan tu Neftalí. ");
INSERT INTO aguBl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Nin e' yi e' jal te'j Zilpa, yi mos Lea, i'tz: Gad tu Aser. Ya'stzun yi e' cy'ajl Jacow yi e' itz'ij nicy' yi ate' tzaj Padan-aram. ");
INSERT INTO aguBl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Bene'n tzun Jacow jalen Mamre tan tilwe'n yi wutzile'n taj. Yi jun tnuma'tz ncha'tz na bi'aj Arba nka Hebrón. Ya'stzun yi tnum kale najewe't Abraham, nin kale najle't Isaac yi taj Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","At tzun Isaac tul jun cient tu jun mutx' yob yi quime'n. ");
INSERT INTO aguBl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Nsken nintzun bi'ẍin Isaac yi quime'n. Yi quime'n, cho'n tzun topone'n talma' kale opnake't yi cyalma' e' tacy'e'x i'. Mukxij tzun yi wankil cya'n Esaú tu Jacow yi cob cy'ajl i'. ");
INSERT INTO aguBl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Cyakil yi bi'aje'j e' cu'n najal Esaú. Yi Esaú-a'tz ncha'tz na bi'aj Edom. ");
INSERT INTO aguBl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Cob scyeri e' txkel Esaú e' aj Canaán, na nin cyok'bej quib tu Ada, yi me'l Elón, yi xonl Het nin tu Aholibama, yi me'l yaj Aná. Yi Aholibama-a'tz i' mamaj Zibeón yi heveo. ");
INSERT INTO aguBl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ncha'tz cyok'bej quib Esaú tu yi me'l Ismael, yi na bi'aj Basemat, yi tanub Nebaiot. ");
INSERT INTO aguBl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Yi xone'n tiemp itz'ij jun tal Ada yi xicy yi na bi'aj Elifaz. Ej nin itz'ij junt te'j Basemat yi na bi'aj Reuel. ");
INSERT INTO aguBl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ma te'j Aholibama e' itz'ij cobox cy'ajl Esaú yi na chibi'aj: Jeús, Jalaam tu Coré. Cyakil yi e' xicya'tz e' cu'n cy'ajl Esaú yi e' jal nicy' yi najlij tzaj Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Itzun bantz nintzun ben Esaú joylaj tan najewe'n. Nin e' baj nin tcy'al cyakil yi e' najal scyuch' yi e' tetz mos. Ncha'tz e' ben tcy'al cyakil yi e' tawun tu cyakil yi me'bi'l yi nsken jal. Cho'n tzun topone'n joylaj tan jatxol tib tu Jacow yi titz'un na chin latz'luj nin yi luwar kale najlche't. ");
INSERT INTO aguBl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ej nin tan paj yi wi'nin cyawun qui't na xcye' yi ch'im yi at swutz luwar tetz chiwa'. ");
INSERT INTO aguBl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Cha'stzun te yi bene'n Esaú, nka Edom, joylaj, tan najewe'n jalen wi'wtz Seir. ");
INSERT INTO aguBl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ma jalu' cyakil yi e'chk bi'aje'j e' cu'n xonl Esaú yi chimamaj yi e' aj Edom yi najlche' wi'wtz Seir. ");
INSERT INTO aguBl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Je chibi' yi e' cy'ajl Esaú yi e' jal: Elifaz yi tal Ada, Reuel yi tal Basemat. ");
INSERT INTO aguBl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ma yi e' nitxajil Elifaza'tz, yi bajx cy'ajl Esaú, i'tz: Temán, Omar, Zefo, Gatam tu Cenaz. Ya'stzun yi e' mamaj Ada tu Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Poro ncha'tz at jun ca'p txkel Elifaz tane'n, yi na bi'aj Timna, nin jal junt cy'ajl i' te'j, yi na bi'aj Amalec. ");
INSERT INTO aguBl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ma yi e' nitxajil Reuel yi e' jal i'tz: Nahat, Zera, Sama tu Miza. Ya'stzun yi e' mamaj Basemat tu Esaú. ");
INSERT INTO aguBl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ncha'tz e' jal cobox cy'ajl Esaú tu Aholibama yi me'l Aná, nin yi mamaj Zibeón. Ej nin yi chibi' yi e' cy'ajla'tz i'tz: Jeús, Jaalam, tu Coré. ");
INSERT INTO aguBl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ma yi e' ajcaw squibaj yi e' xonl Esaú yi e' jal te'j txkel Elifaz i'tz: Temán, Omar, Zefo, Cenaz, ");
INSERT INTO aguBl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam tu Amalec. Ya'stzun yi e' ajcaw squibaj yi e' xonl Elifaz, yi bajx cy'ajl Esaú tu Ada, yi cho'n najlche' Edom. ");
INSERT INTO aguBl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ma yi e' ajcaw squibaj yi e' xonl Esaú yi e' jal te'j txkel Reuel i'tz: Nahat, Zera, Sama tu Miza. ");
INSERT INTO aguBl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ma yi e' ajcaw bantz squibaj yi e' chixonl yi e' tal Aholibama yi me'l Aná i'tz: Jeús, Jaalam tu Coré. ");
INSERT INTO aguBl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Cyakil yi e' bi'aja'tz yi ja wi't kil e' len cu'n xonl Esaú, yi ncha'tz na bi'aj Edom. E' len cu'n ajcaw squibaj chixonl. ");
INSERT INTO aguBl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ma chibi' yi e' cy'ajl Seir yi aj Hor, yi najlche' tul yi jun ama'la'tz i'tz: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO aguBl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer tu Disán. Ya'stzun yi e' yi e' cawun squibaj yi e' aj Hor. E' cu'n xonl Seir yi cho'n najlche' swutz yi luwar yi na bi'aj Edom. ");
INSERT INTO aguBl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ma yi e' cy'ajl Lotán i'tz: Hori tu Heman. Ma yi Timna ya'stzun yi tanub Lotán. ");
INSERT INTO aguBl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ma yi e' cy'ajl Sobal i'tz: Alván Manahat, Ebal, Sefo tu Onam. ");
INSERT INTO aguBl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ma yi e' cy'ajl Zibeón i'tz: Aja tu Aná. Yi Aná-a'tz ya'stzun yi jun yi nojpon te yi jun tal a' tul yi ama'l yi tz'inunin tu', te yi na tzan tan chipstore'n yi e' buru' yi taj. ");
INSERT INTO aguBl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ncha'tz yi Aná jal jun cy'ajl yi na bi'aj Disón. Nin jal jun xun yi na bi'aj Aholibama. ");
INSERT INTO aguBl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ma yi e' cy'ajl Disón yi e' jal i'tz: Hemdán, Esbán, Itrán tu Querán. ");
INSERT INTO aguBl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ma yi e' cy'ajl Ezer i'tz: Bilhán, Zaaván tu Acán. ");
INSERT INTO aguBl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ma yi e' cy'ajl Disán bantz i'tz: Uz tu Arán. ");
INSERT INTO aguBl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Itzun yi e' ajcaw bantz squibaj yi e' aj Hor i'tz: Lotán, Sobal, Zibeón tu Aná, ");
INSERT INTO aguBl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer tu Disán. Ya'stzun yi e' baj cawun len squibaj yi e' aj Hor. E' baj cawun lentz squibaj yi chixonl le jun ama'la'tz yi na bi'aj Seir. ");
INSERT INTO aguBl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","I bin jalu' je chibi' yi e' rey, yi e' cawun le luwar Edom yi ntaxk jal chireyil yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, yi cy'ajl Beor ja cawun squibaj yi e' aj Edom. Ej nin yi bi' yi tnum kale najle't i'tz Dinaba. ");
INSERT INTO aguBl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Yi quime'n Bela nin oc cyen Jobab yi cy'ajl Zera tetz xel. Cho'n najlij i' le tnum Bosra. ");
INSERT INTO aguBl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yi quime'n Jobab, oc cyen Husam yi aj Temán tetz xel. ");
INSERT INTO aguBl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ma yi quime'n Husam nin oc cyen Hadad yi cy'ajl Bedad tetz xel. Ja chixcye' yi e' sanlar i' scye'j e' sanlar cwent Madián jalen le ama'l Moab. Ej nin yi tanum i' i'tz Avit. ");
INSERT INTO aguBl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ma yi quime'n Hadad nin oc cyen Samla yi aj Masreca. ");
INSERT INTO aguBl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ma yi quime'n Samla nin oc cyen Saúl yi aj Rehobot, yi tnum yi at stzi' a'. ");
INSERT INTO aguBl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ma yi quime'n Saúl, nin oc cyen Baal-hanán yi cy'ajl Acbor tetz xel tan cawun. ");
INSERT INTO aguBl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ma yi quime'n Baahanán, nin oc cyen Hadad yi aj Pau, tetz xel. Nin yi bi' yi txkel Hadad i'tz Mehetabel yi me'l Matred, yi mamaj Mezaab. ");
INSERT INTO aguBl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Je chibi' yi e' ajcaw squibaj yi jujun k'u'j xonl Esaú: Timna, Alva, Jetet, ");
INSERT INTO aguBl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibama, Ela, Pinón, ");
INSERT INTO aguBl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Cenaz, Temán, Mibzar, ");
INSERT INTO aguBl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel tu Iram. Ya'stzun yi e' yi e' cawun squibaj yi jujun k'u'j xonl Edom. E' cawun lakak chitanum kale e' najewe't. Nin yi Edoma'tz ya'stzun junt bi' Esaú yi cy'ajl Isaac. ");
INSERT INTO aguBl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ma yi Jacow cho'n tzun cyaje'n cyentz le ama'l cwent Canaán, kale najewe't yi taj chi awer nak tu' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ma jalu' katxume' yi mbi banake' yi e' najal Jacow. Itzun bantz yi at tzaj Ẍep tul juklaj yob, nintzun octz tan pstore'n cne'r chi quitane'n e' stzicy. Cho'n tzun xome'n quen i'-tz tan pstori'n scye'j yi e' tal Bilha tu Zilpa, yi e' ca'p txkel Jacow tane'n. Ilenin tzun na xochon Ẍep tetz yi taj te yi e'chk takle'n cachi' yi na chiban yi e' stzicy. ");
INSERT INTO aguBl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Inti wutzile'n Israel mas tcunin pe'k i' te'j Ẍep ẍchiwutz yi e' mas cy'ajl, na sken bi'ẍin i' yi titz'e'n. Cha'stzun te bnixe'n jun chum balaj be'ch tetz Ẍep ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ma yi tele'n chitxum yi e' stzicy tetz, yi mas tcunin na pe'k chitaj te'j Ẍep wi'nin tzun ẍchi'che'n chic'u'l bantz. Nin qui't na chitziwuntz tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Itzun bantz nin oc ẍchajol tib jun wutzicy' swutz Ẍep, nin octz tan xtxole'n scyetz yi e' stzicy. Ma yi quibital, mas tcunin ẍchi'che'n chic'u'l bantz te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Na je tal i'e'j: —E'u' wutzicy, quibit tzaju'. Intxole' jun inwutzicy' scyeru' yi mmo'c ẍchajol tib tzinwutz ma's. ");
INSERT INTO aguBl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Yi inwutzicy' i'tz: Cho'n ato' scyuch'u' wi cojbil tan c'alche'n xe c'u'l triw. Jalt cuntunin nje' txiclok yi wetz intriw yi nsken c'alxij xe c'u'l wa'n. Ma yi cyeru' yi nsken c'alxij xe c'u'l cyanu' nin nchibaj opon chitxolil quib solte'j yi wetz. Ej nin nchibaj cu'n ch'uylok tan tak'le'ntz k'ej yi wetz, stzun Ẍep scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Saje'n tzun chitza'wel yi e' stzicy. Itzun cyaltz: —I bin yi awajbil i'tz tan awoque'n tetz kareyil nin tan acawune'n skibaj, che'ch yi e' stzicy. Mas tcunin tzun ẍchi'che'n chic'u'l bantz te'j tan paj yi wutzicy' nin tan paj yi puntil yi ban i' tan xtxole'n scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yi xone'n tiemp nintzun oc ẍchajol tib junt wutzicy' swutz Ẍep nintzun xtxoltz scyetz yi e' stzicy. Itzun taltz: —Quibit tzaju' at junt inwutzicy' mban. Ja ẍchaj tib yi k'ej tu yi xaw scyuch' junlaj tkan tx'uml tzinwutz. Ej nin ja chibaj octz tan tak'le'n ink'ej, stzun Ẍep bantz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Itzun yi wi't xtxolil Ẍep yi junt wutzicy'a'tz nintzun oc yi taj tan yajle'n nin tan makle'n stzi'. —¿Mbi tzun na elepone't yi jun ara wutzicy'a'tz? ¿I pe' awajbil yil meje' cu'n atxu' scyuch' e' awutzicy nin yi in wetz tzawutz? stzun taj Ẍep bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Wi'nin tzun chixcy'akline'n yi e' stzicytz te'j. Ma yi taj, wi'nin txumu'n at cu'ntz tan yi e'chk wutzicy' Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Itzun bantz, at jun tir yi cho'n ate' opon yi e' stzicy Ẍep jalen Siquem tan chic'a'che'n yi e' tawun chitaj. ");
INSERT INTO aguBl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Bene'n tzun tlol Israel tetz Ẍep: —Bit tzaj yaj, yi e' awutzicy cho'n ate' jalen Siquem tan chipstore'n kawun. Ma jalu' yi wajbil i'tz yil cẍben tan quilwe'n. —Cu ta', list in tan imbene'n, chij Ẍep tetz taj. ");
INSERT INTO aguBl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","—Ma jalu' bin je amantare'j: Quilo'k tan tilwe'n yi ko ba'n ate't awutzicy scyuch' yi e' kawun. Ntin che' ben axmaye' tzaj ko ba'n ate't. Ej nin cẍpakxij lajke'l tan talche'n stziblal swetz, stzun Israel bantz. Cho'n tzun ticy'pone'n Ẍeptz tan Israel le joco'j cwent Hebrón tan topone'n jalen Siquem. ");
INSERT INTO aguBl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Itzun te yi topone'ntz Siquem nintzun octz tan chijoyle'n yi e' stzicy. Inin tzun na el yabtz tan chijoyle'n yi noje'n cyen jun yaj te'j nintzun ben jakol yi yaja'tz tetz: —¿Mbi na ajoy tzone'j? ");
INSERT INTO aguBl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","—Na chintzan tan chijoyle'n yi e' wutzicy. ¿Qui pe' na til teru' na ate't tan chipstore'n yi e' kawun? stzun Ẍep bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","—Cho'n bin ate' tzone'j, poro ja wi't chicy't. Nwit nin tu' scye'j yi cho'n nchibent jalen Dotán, stzun yi yaja'tz bantz tetz Ẍep. Bene'n nintzun ban Ẍeptz tan chijoyle'n yi e' stzicy. Cho'n tzun e' jale'ntz ta'n jalen Dotán. ");
INSERT INTO aguBl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yi quilolnin yi e' stzicy Ẍep yi txant tan tule'n scye'j cyoque'n tzuntz tan xtxumle'n yi ẍe'n chiban tan biyle'n cu'n. ");
INSERT INTO aguBl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Chijilone'n tzuntz squibil quib. Itzun cyaltz: —Ilwoknin, je nocx aj wutzicy'inl tz'ul. ");
INSERT INTO aguBl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Or kabiye' cu'nx, nin kayok'e' cu'nx tul jun jul. Ej nin skale' yi i'tz jun smaron txuc yi mbajsan. Skile' tzun ko tz'elpon k'ab yi wutzicy'x te'j quib yi talnakx sketz, che'ch bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Itzun yi bene'n tbital Rubén yi chitxumu'n nin octz tan joyle'n puntil tan colche'n chik'ab. Itzun taltz: —Quil tzibiy cu'n. ");
INSERT INTO aguBl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ma na cun c'oxwok tul yi jun jul yi at tzi'ne'j kale qui'cle't wunak. Poro quil cxo'cwok tan biyle'n, stzun Rubén bantz. Ja tal Rubén yi xtxolbile'j na yi tajbil i' i'tz tan claxe'n klo' Ẍep chik'ab nin tan topone'nt te yi taj. ");
INSERT INTO aguBl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Poro itzun yi topone'n Ẍep kale ate't yi e' stzicy nintzun e' baj bentz tan stz'amle'n nin el chik'olpil yi tal be'ch tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ej nin e' bentz tan c'oxle'n tul yi jun jula'tz yi nsken skej a' tul. ");
INSERT INTO aguBl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kalena's tzun e' baj cwe'n c'olchok tan wa'a'n. I nintzun na chitx'ujtijtz tan wa'a'n yi bene'n quilol jun chin txol aj pyaj yi cho'n chisaje'n Galaad. E' cu'n xonl Ismael. Cy'a'n len chicamey cya'n. Ej nin te'jak chicamey cy'a'n e'chk k'olil tze' cya'n yi chin c'o'c nin. Cho'n at chibembil yi e' aj pyaja'tz tan c'aye'n jalen Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Bene'n tzun tlol Judá scyetz: —¿Mbil katx'ac te'j kol kabiy cu'n yi kitz'un nin lko'c tan joyle'n puntil tan tewe'n cu'n yi ẍe'n nquim ka'n? ");
INSERT INTO aguBl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ba'n tcu'n kac'aye' nin scyetz yi e' xonl Ismael yi chu'l tzi'ne'j, swutz yi nink lkabiy cu'n. Na yi mero bintzi kitz'un kutzicy kib tuch', stzun i' bantz scyetz. Ba'n tzun ban yi xtxumu'n Judá ẍchiwutz. ");
INSERT INTO aguBl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Itzun yi quicy'e'n cu'n yi e' aj pyaja'tz yi e' aj Madián ẍchinaka'jil, nintzun e' bentz tan je'se'n tzaj Ẍep tjul nin ben chic'ayiltz scyetz tan junak piẍ sakal. Ya'stzun bantz yi bene'n quicy'al Ẍep jalen Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Itzun yi topone'n Rubén tan xmaye'n yi jul, nin yi tilol yi qui'ct Ẍep at, nintzun octz tan katzle'n yi be'ch tetz tan ẍchajle'n yi na bisun. ");
INSERT INTO aguBl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Lajke'l nintzun saje'ntz kale ate't yi e' titz'un nintzun taltz scyetz: —¡Qui'ct Ẍep at tjul! ¿Ma jalu' ẍe'n tzimban? ");
INSERT INTO aguBl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Chibene'n tzuntz tan ticy'le'n tzaj tal be'ch tetz Ẍep, nin oc chisuk'ul yi ẍch'el jun tal ne'ẍ chiw te'j yi nsken wi't quim cya'n. ");
INSERT INTO aguBl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Nintzun e' saj chichakol cobox ẍchixo'l tan ẍchajle'n tetz yi chitaj. Nin saj cyalol scyetz: “Je tzitale'j: Til tzaju' yi je'j. Tilcunu'. ¿Nk'era'tz polo' yi be'ch tetz yi cy'ajlu'?” ");
INSERT INTO aguBl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Itzun yi cwe'n techal wutzile'n Jacow wutz yi be'ch tetz yi cy'ajl, nintzun taltz: “I'tz. Ya'stzun be'ch tetz yi tal incy'ajl. Alonin bin scyetz smaron txuquila'tz mbajsan tal incy'ajl,” stzun wutzile'n Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Toque'n tzun i'-tz tan katzle'n yi be'ch tetz, nin oc tk'ol yi be'ch tetz te'j yi na xcon yi na quim jun wunak. Wi'nin tzun tiemp ok' Jacowtz tan paj yi quime'n yi cy'ajl. ");
INSERT INTO aguBl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","E' joy puntil yi e' cy'ajl scyuch' yi e' me'l tan mayse'n i'. Poro quinin na cujijtz yi na cho'c tan mayse'n c'u'l. Ma na mas tcunin na ok'tz tan yi cy'ajl. Itzun na taltz: “Quil tz'el yi incy'ajl te'j inc'u'l, jalen cu'n yil chinquim nin wilt wutz i' ẍchixo'l alma'.” ");
INSERT INTO aguBl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ma tetz Ẍep cho'n bene'n c'ayi'n cyak'un yi e' aj Madián jalen le tnum Egipto. Cho'n bene'n c'ayi'n tetz jun yaj yi na bi'aj Potifar. Yi jun yaja'tz i' jun ajcaw xlaj faraón yi rey tetz Egipto nin i' jun capitán ẍchiwutz jun c'oloj sanlar, yi q'uicy'lom tetz rey. ");
INSERT INTO aguBl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Itzun bantz te yi tiempa'tz nin el jatxol tib yaj Judá scye'j e' stzicy tu yi e' titz'un. Cho'n tzun bene'ntz tan najewe'n tu jun aj Adulam yi na bi'aj Hira. ");
INSERT INTO aguBl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Cho'n tzun tajskel Judá wutz yi me'l Súa yi aj Canaán. Ok'be'n ib nintzun e' bantz tuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Itzun yi cyok'bel quib nin tekaj yi txkel Judá pwokil jun ni'. Ej nin yi tule'n itz'ok yi ni'a'tz xicy tzun bantz. Nintzun oc tk'ol yi bi'-tz tetz Er. ");
INSERT INTO aguBl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Yi xone'n tiemp nintzun jal junt chinitxa' yi xicy. Ej nin oc tk'ol yi bi' yi ni'a'tz tetz Onán. ");
INSERT INTO aguBl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ncha'tz jale'n nin ban yi toxi'n chinitxa' nin oc tk'ol yi bi' tetz Sela. Yi jun xicya'tz, itz'ij nicy' yi at tzaj Judá le tnum Quezib. ");
INSERT INTO aguBl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Itzun yi nsken wi't yajin Er, yi bajx cy'ajl, nintzun joy Judá txkel. Tamar bi' yi txkel i' ban. ");
INSERT INTO aguBl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Poro quim Er, tan paj yi qui nin tzatzin Kataj Ryos te yi tajtza'kl. ");
INSERT INTO aguBl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Bene'n tzun tlol Judá tetz Onán: —Ba'n tzitok'bej itib tu txkel yi k'ajtzun awutzicy, tan abnol tane'n yi kacstumbr, bantz tan aẍ jale't xonl k'ajtzun awutzicy. ");
INSERT INTO aguBl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Poro yi Onán elnak xtxum tetz yi nk'e'tz nitxajil i' ẍchibne' yi e' ni' yi ẍchitz'ok te yi txkelbe'n yi stzicy. Cha'stzun te ilenin joy i' puntil tan qui toque'n lac'puj jun ni' te'j yi xna'na'tz bantz quil jal xonl yi k'ajtzun stzicy. ");
INSERT INTO aguBl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Qui nintzun pe'k Kataj Ryos te yi tajtza'kl Onán. Cha'stzun te quime'n i'-tz tan Ryos. ");
INSERT INTO aguBl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yi quime'n Onán nintzun tal Judá tetz Tamar yi tlib: —Ma jalu' ja cẍcyaj tul xma'lca'nil. Ba'n tcu'n cẍa'j tu ataj jalen pe'k yil ch'uy Sela yi junt incy'ajl. Kalena's tzun tzitok'bej itib tuch'. Ya'stzun tal Judá tetz yi tlib tan mayse'n c'u'l. Poro yi mero bintzi i'tz, yi ja xob Judá, na le wutz tetz tajtza'kl ncha'tz Sela squimok chi nchiban yi e' stzicy. Cha'stzun te taje'n Tamar tan najewe'n tuch' yi taj. ");
INSERT INTO aguBl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Itzun bantz yi tele'n tiemp, quime'n nintzun ban yi txkel Judá yi me'l Súa. Ma yi tele'n yi bis te c'u'l Judá, nintzun bentz le tnum yi na bi'aj Timnat kale ate't yi e' mos i' yi na chitzan tan telse'n xi'il yi e' tawun. Nintzun ben xomok yi jun tamiw i' te'j yi na bi'aj Hira yi aj Adulam. ");
INSERT INTO aguBl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Itzun yi tbital Tamar, yi nsken wi't ben yi tlib i' le tnum Timnat tan telse'n xi'il yi e' tawun, ");
INSERT INTO aguBl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","nintzun el xtx'ixpul yi be'ch tetz yi na ẍchaj yi quimnak yi chmil. Ej nin je tk'ol jun su't twi' tan tewe'n wutz, bantz cya'l jun tz'echan wutz i'. Cho'n tzun c'olewe'n cu'ntz ju' tnum Enaim yi at xlaj be' yi na opon Timnat. Ya'stzun tulej i'-tz na elnak xtxum tetz yi nsken yajin Sela poro qui nin na tak'o'k Judá ama'l tetz tan cyok'bel quib tuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Itzun yi bene'n xmayil Judá yi c'olchij yi jun xna'na'tz stzi be' nintzun xtxumtz yi i' jun wi'tz bnol tetz, na jopij wutz tan su't. ");
INSERT INTO aguBl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Nintzun el jatxol tibtz te yi be' yi cy'a'n ta'n tan topone'n kale c'olche't yi xna'n. Qui nin el xtxum tetz yi ko i'tz yi tlib. Bene'n tzun jakoltz tetz: —¿Cuj pe' awa'n yi nink kawitbej kib tzawuch'? —Cuj, ¿poro mbi ltak'u' swetz kol kawitbej kib? ");
INSERT INTO aguBl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","—Tz'ul ak'ol tetz jun atz scyeri e' tal inchiw. —Ba'n, chij xna'n bantz. —Poro na waj yil cyaj cyen jun prent jalen cu'n tz'ul yi inchiw tanu'. ");
INSERT INTO aguBl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","—¿Mbi na awaj yil wak' cyen tetz prent? stzun Judá. —Tak' cyenu' yi teru' seyu' yi cotlij skulu' tuml yi tx'amij yi cya'n tanu', stzun yi xna'n bantz tetz Judá. Bene'n tzun tk'ol Judá yi sey tu yi xtx'amij tetz. Kalena'tz tzun chiwitbej quib tuch'. Ej ninin tekaj Tamar pwokil jun ni' tan paj. ");
INSERT INTO aguBl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Yi chijatxol quib tu Judá nintzun ben Tamar tan xtx'ixpe'n be'ch tetz nin el tcy'al yi jun su't yi je tk'ol twi', nin oct tk'ol yi tetz be'ch tetz te'j yi na ẍchaj yi quimnak yi tetz chmil. ");
INSERT INTO aguBl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yi topone'n Judá kale ate't yi tawun nintzun saj ẍchakol yi tamiw, yi aj Adulam tan tak'le'n yi tal chiw tetz yi jun xna'na'tz nin tan chicolpene'l tzaj yi e'chk prent yi cyaj tk'ol. Poro qui nin jal yi jun xna'na'tz tan yi tamiw i'. ");
INSERT INTO aguBl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Toque'n tzun yi tamiw Judá tan jakle'n scyetz cyakil yi e' wunak yi najlche' tul jun luwara'tz. —¿Na' atite't yi jun xna'n aj Enaim yi wi'tz bnol tetz yi c'olchij tzi be'e'j? —Qui'c jun xna'n wi'tz bnol tetz skaxo'l ketz tzone'j, che'ch yi wunaka'tz bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Pakxe'n nintzun ban yi tamiw Judá nin taltz tetz: —Ta', qui't njal yi xna'n wak'un. Ncha'tz ja baj injakol scyetz cyakil wunak yi ate'-tz. Nin ja cyal swetz yi qui'c jun xna'n wi'tz bnol tetz ẍchixo'l cyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","—Pues ja bin cyaj cyenxa'tz tuch' yi e'chk intakle'na'tz, bantz quil cho'c wunak tan kaxbajtzi'e'n. Poro ntin, ja nin bin cẍa'k tan tak'le'n klo' yi tal chiw, poro qui bin njal awa'n. Qui'c ketz kapaj te'j, stzun Judá bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Itzun yi tele'n ox xaw, nintzun ul stziblal twi' Judá yi nsken wi't tekaj yi tlib i' pwokil jun ni', tan paj yi na witbej tib scye'jak yaj. —Ko ya'tz, stzun Judá —or tele'n tzaj ticy'le'n, nin cuk pati'n. ");
INSERT INTO aguBl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Poro te yi na chitzan tan telse'n tzaj Tamar nintzun saj alol tetz, tan talche'n tetz yi tlib: —Ta', je yol Tamar yi nsaj tlol swetze'j: “Yi taw yi e'chk takle'ne'j, ya'stzun jun yi nkawitbej kib tuch', nin tetz i' yi ni' yi eka'n pwokil wa'n. Tilcunu', ko pel techu' wutz na' taw yi jun seye'j tu yi jun tx'amije'j,” stzun i', chij yi alol tetz bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yi cwe'n techal Judá wutz, yi tetz i' yi e'chk takle'na'tz nintzun taltz: “Ba'n atit tajtza'kl Tamar. In te'tz yi cachi' wajtza'kl, na qui nin wak' ama'l tan cyok'bel quib tu incy'ajl Sela,” stzun Judá bantz. Jetza'tz tzuntz, qui't nchiwitbej quib junt tir. ");
INSERT INTO aguBl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Itzun yi topone'n k'ejlal tan tule'n yos tu Tamar, e' tzun yoẍ ban yi e' tal. ");
INSERT INTO aguBl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ej nin te yi jun tkuj yi at Tamar swutz q'uixc'uj tan tule'n yos tuch' at tzun jun scyeri yi e' ni' yi bajx tele'n mule'n yi k'ab. Yi tilol yi xe'iyum nin oc c'alol jun nok' cyak te k'ab. Itzun taltz: “Yi june'j ya'stzun yi bajx nak.” ");
INSERT INTO aguBl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Poro ite'n nin tkuja's taje'n quen tcy'al yi ni' yi k'ab. Ej itzun yi junt, itz'ij bajx. Cha'stzun te toque'n tk'ol yi xe'iyum bi' yi ni' tetz Fares na nin taltz “ẍe'n jakxij be' awa'n.” ");
INSERT INTO aguBl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ma yi titz'e'n yi junt xicy, yi c'alij yi nok' cyak te k'ab, nintzun oc tk'ol yi bi' tetz Zara. ");
INSERT INTO aguBl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Itzun bantz yi topone'n Ẍep jalen Egipto, nintzun c'ayij i'-tz tetz jun yaj aj Egipto yi na bi'aj Potifar. Cho'n lok'ol Potifar yi Ẍepa'tz scyetz yi e' xonl Ismael, yi oponsan Egipto. Yi jun Potifara'tz i' jun ajcaw xlaj faraón. Ncha'tz i' capitán squibaj yi e' sanlar yi q'uicy'lom tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Quinin tzun cyaj cyen Ẍep ẍchuc ma na xomquen tunin Ryos te'j tan ẍch'eye'n. Cha'stzun te ba'n mban Ẍep nicy' yi najlij i' xe ca'l yi patróna'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ncha'tz el xtxum yi patrón tetz yi xomij Ryos te'j Ẍep, na cyakil e'chk takle'n yi na ban, ba'n na ban tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Cha'stzun te wi'nin stzatzine'n Potifar te'j nin octz ta'n tetz martoma' xe ca'l i'. Nin cyaj cyen tk'ol cyakil yi me'bi'l tk'ab Ẍep tan je'n ju' ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Yi cyaje'n cyen Ẍep tetz bajx martoma' ya'stzun yi xe'te'n Ryos tan tak'le'n banl tibaj Potifar tu cyakil yi me'bi'l. ");
INSERT INTO aguBl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tantu' yi toque'n cyen Ẍep tetz martoma', qui't nin tzun na bisun Potifar te yi me'bi'l. Ma na jaltnin wa'a'n na xtxumtz. Itzun Ẍep, chin yube'n nin i', nin chin elsbil alma' nin. ");
INSERT INTO aguBl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Cha'stzun te, yi tele'n tiemp yi tponle'nix Ẍep tu Potifar, nintzun elquen talma' yi txkel Potifar te'j i'. Itzun taltz: —Aẍ jun c'oloj Ẍep, kawitok tzawuch', stzun xna'n tetz Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Poro qui nin cujij Ẍep, na nin taltz tetz: —Qui pe' na el xtxumu' tetz, yi cyajnak cyen tk'ol yi chmilu' cyakil e'chk me'bi'l tincwent. Ej nin tantu' yi at cyakil cu'n tincwent qui't na bisun i' te yi me'bi'l. ");
INSERT INTO aguBl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","In nin ajcaw tibaj cyakil e'chk takle'n yi at xe chinajbilu'. Qui'c jun e'chk takle'n yi qui'k cuj tan xcone'n wa'n, ma na jatxijt tink'ab tan impatrón. Ntin cu'n ilu'a'tz yi qui'c nin wocle'n te'ju', na ilu' txkel impatrón. Cha'stzun te qui'c rmeril tan imbnol jun takle'na'tz yi chin cachi' nin, na kol tzimban, tzinjuche' wil swutz Ryos, stzun Ẍep tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Poro cyakil nin k'ej na oc yi txkel Potifar ch'inch'uj tan moxe'n Ẍep tan chiwitbel quib tuch'. Poro qui nin tak' Ẍep ama'l tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Itzun bantz at tzun jun tir yi ntin txkel Potifar at cyen nicy' yi tocompone'n Ẍep tan ak'un xe ca'l. ");
INSERT INTO aguBl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ej nin tan paj yi cya'l at xe ca'l toque'n tzun yi xna'na'tz tan stz'amle'n cu'n Ẍep nin tan moxe'n tan chiwitbel quib tuch'. Itzun taltz: —Aẍ jun c'oloj Ẍep, kawitbej kib tzawuch'. Nintzun oc tan stz'amle'n be'ch tetz Ẍep. Lajke'l nintzun tele'n tzaj ojkuj Ẍep swutz. Poro tan paj yi ojke'l, nintzun cyaj kinol xna'n yi xbu'k Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yi tilol xna'n yi nsken cyaj cyen yi be'ch tetz Ẍep tk'ab nintzun octz tan chichakle'n tzaj yi e' mos yi na chak'uj xe ca'l. ");
INSERT INTO aguBl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Itzun taltz scyetz: —Ilwok tzaje'j, yi wuchmil ulsan jun hebrey xe kaca'l, poro yi jalu' yi tajbil yi jun hebreya'tz i'tz tan telse'n katx'ix, na ja ocpon i' swe'j xe ca'l, nin yi tajbil i' i'tz yi nink kawitbej kib tuch'. ");
INSERT INTO aguBl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Poro tan paj yi chin wi' nin imban tan sich' nintzun me'l tzaj ojkuj. Ncyaj cyen tu tilol i' yi be'ch tetze'j, stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Bene'n nintzun bantz tan colche'n yi be'ch tetz Ẍep jalen yi topone'n yi chmil xe ca'l. Itzun yi topone'n yi chmil nintzun ẍchaj tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ite'n nin xtxolbila'tz taltz tetz chi yi mbaj xtxolil scyetz yi e' mos. Itzun taltz: —I jun amos yi hebrey yi ul acy'al tzone'j xe kaca'l, ja ocopon i' swe'j ma's xe incuart. Nin yi tajbil i', i'tz klo' tan banle'n ruinl swetz. ");
INSERT INTO aguBl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Poro tan paj yi ja chinẍch'in, nin chin inwi' nin imban tan sich', cha'stzun te yi mme'l ojk nin ncyaj cyen tu' tk'ol yi be'ch tetze'j le incuart. ");
INSERT INTO aguBl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ya'stzun ban yi amos swe'j, stzun yi xna'n bantz. Wi'nin tzun ẍchi'che'n c'u'l yi patrón te'j Ẍep tantu' tbital yi xtxolbila'se'j. ");
INSERT INTO aguBl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Nintzun cawunintz tan stz'amle'n Ẍep, nin tan tocse'n xetze', kale ate't cyakil yi e' pres yi juchij quil cya'n swutz yi rey. ");
INSERT INTO aguBl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Nintzun oc cyen Ẍep xetze'. Poro at nin Ryos te'j, na nin tak' i' banl tibaj, na tantu' porer Ryos ja jal yi balajil i' swutz yi wi'tz q'uicy'lom pres. ");
INSERT INTO aguBl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Itzun yi q'uicy'lom presa'tz cyaje'n cyen tzun tk'ol yi e' mas pres tcwent Ẍep. Ẍep tzun na ak'on yi e'chk ort te yi mbi cu'n yi tajwe'n tan chibnol cyakil yi e' mas pres. ");
INSERT INTO aguBl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ma yi wi'tz q'uicy'lom pres, qui'c nin na tajquentz tan jakle'n cwent te cyakil yi at tk'ab Ẍep, na chin tz'aknak cunin i' tan ak'un na ba'n na ban cyakil yi e'chk takle'n yi na bnix ta'n na ilenin xomij Ryos te'j tan ẍch'eye'n. ");
INSERT INTO aguBl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Itzun yi xone'n tiemp nintzun cu juchul yi k'ol tc'a' faraón jun til swutz. Ncha'tz yi banol pam faraón cu juchul tiltz. ");
INSERT INTO aguBl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Wi'nin tzun ẍchi'che'n c'u'l faraón scye'j yi cob ẍchakuma'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ej nintzun cawunin i'-tz tan cyoque'n xetze'. Cho'n tzun e' bene'ntz ta'n xe' ca'l yi wi'tz ajcaw squibaj yi e' sanlar yi e' q'uicy'lom rey, na cho'n at yi xetze' kale najle't i'. Ej nin ta'tz te'n nin atite't Ẍep pres. ");
INSERT INTO aguBl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Yi cyopone'n yi cob yaja'tz xetze' cho'n tzun cyoque'n tk'ol yi wi'tz ajcaw tk'ab Ẍep tan chiq'uicy'le'n. Nim tzun tiemp e' bantz xetze'. ");
INSERT INTO aguBl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","At tzun jun ak'bal, nin oc ẍchajol tib jujun chiwutzicy' yi cob presa'tz yi ak'ol tc'a' tu yi bnol pam yi rey. Apartchk len ban chiwutzicy'. ");
INSERT INTO aguBl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Chin jalchan cunin tzun topone'n Ẍep tan quilwe'n, nin yi tocompone'n scye'j wi'nin chibisune'ntz. ");
INSERT INTO aguBl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Nintzun ben jakoltz scyetz: —¿Mbi tzun na ibislej? ");
INSERT INTO aguBl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","—At bin jun ketz kawutzicy' mban ma's, poro cya'l nin jun at tan xtx'olche'n xo'l sketz yi mbi na elepont, che'ch tzun bantz tetz Ẍep. —Qui pe' na el itxum tetz yi ntin Ryos na xcye' tan xtx'olche'n xo'l yi e'chk wutzicy'. Or alwok tzaj swetz mbi i ila'tz yi iwutzicy', stzun Ẍep scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Xe'te'n nintzun ban yi chibajxom yi ak'ol tetz tc'a' yi rey tan xtxole'n yi wutzicy' i' tetz Ẍep. Itzun taltz: —Tul yi wetz inwutzicy' ja wil jun wi' uva, yi at ox k'ab, ");
INSERT INTO aguBl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","nin yi jun wi' uvaja'tz wi'nin saje'n xlumil nin wi'nin jale'n xu'm, nin yi xu'mila'tz yi nchibaj jal, wi'nin cyoque'n tetz jujun jutuj lo'baj uva. ");
INSERT INTO aguBl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ma yi in wetz, tz'amij yi cu'lbil tc'a' yi rey wa'n nin ja no'c tan chitzutle'n tzaj yi jujun jutuj uva nin na inyutz cu'ntz le yi cu'lbil tc'a' yi rey. Nin in te'n nintz na chin bentz tan tak'le'n tk'ab, stzun yi jun yaja'tz bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Jilone'n tzaj tzun Ẍep. Itzun taltz: —I na elepont yi teru' wutzicy'u' i'tz: Yi ox k'ab uva yi ntilu', na ẍchaj ox k'ej. ");
INSERT INTO aguBl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ej nin chwa'nin le oxt k'ej, tz'ocopont yi rey tan xtxumle'n yi tilu', poro quil bisunu', na tz'ocoponu' junt tir te yi tak'unu'. Tz'ocoponu' junt tir tan tak'le'n quen yi tc'a' rey chi sajle'nu'. ");
INSERT INTO aguBl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Yil tz'elu' tzone'j, nink lnu'l tx'akx tc'u'lu'. Nink lbanu' pawor swetz tan yol tetz yi faraón tan welse'n tzone'j xetze'. Elk k'ajabu' swe'j nink lnu'l tx'akx tc'u'lu'. ");
INSERT INTO aguBl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Yi mero bintzi qui'c wetz wil. Alak' tu' nchinsite't wetz chixo'l e' intanum yi o' hebrey. Ej nin qui'c xe' wil yi atin tzone'j xetze', stzun Ẍep bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ej itzun yi tbital yi chibajxom yi e' banol pam tetz rey, yi ba'n elpone't yi wutzicy' yi tuch' yi baj xtx'olol Ẍep xo'l. Itzun taltz: —Ma yi in wetz je inwutzicy' mbane'j: Ja inwutzcy'aj yi usk'u'n ox mi't pam wa'n. ");
INSERT INTO aguBl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Itzun yi toxi'n mi't nojnak tan ala' jilwutz balaj pam, yi tetz cuntu' faraón. Poro ja wil yi ja chibaj ul jun c'oloj ch'u'l tan bajse'n yi balaj pama'tz yi usk'u'n wa'n, stzun bnol pam tetz Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Jilone'n tzaj tzun Ẍep. Itzun taltz: —Yi na elpone't yi teru' wutzicy'u' i'tz: Yi ox mi't pam yi usk'u'n tanu' na ẍchaj ox k'ej. ");
INSERT INTO aguBl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ej nin chwa'nin le oxt k'ej tz'ocopon faraón tan xtxumle'n junt tir yi tilu'. Poro jepon ch'imbanu' tzak' jun wi' tze'. Ej nin chu'l cyakil ku's tan bajse'n wankilu', stzun Ẍep bantz tetz yi bnol pam. ");
INSERT INTO aguBl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Itzun le toxi'n k'ej ya'stzun yi wutz k'ej faraón, nintzun xtxum jun balaj wa'a'n scyetz cyakil yi e' yi na chak'uj xlaj. Ẍchiwutz cunin tzun yi e' xtxocum i' yi bene'n mantar tan cyelsene'l tzaj yi chibajxom yi e' ak'ol tc'a' tuml chibajxom yi e' banol pam. ");
INSERT INTO aguBl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Yi chibajxom yi e' ak'ol tc'a' i', nin oct junt tirt ta'n te yi tetz tak'un. Toque'nt tzun i'-tz tan tak'le'n tc'a' faraón chi sajle'n nin. ");
INSERT INTO aguBl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ma yi chibajxom yi e' bnol pam nin cawunin faraóntz tan je'n ch'imba'n tzak' jun wi' tze', quib yi tal Ẍep tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Inti yi chibajxom yi e' ak'ol tc'a' faraón qui't nintzun ul tx'akx Ẍeptz tc'u'l. ");
INSERT INTO aguBl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Itzun bantz te yi nsken wi't el cobix yob yi baje'n yi xtxolbila'se'j nintzun witzcy'aj faraón yi cho'n txiclij i' stzi' jun chin tzanla' yi na bi'aj Nilo. ");
INSERT INTO aguBl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ej nin te yi txiclij stzi' yi jun tzanla'a'tz nin ben tilol yi chije'n tzaj juk wacẍ yi chin chiyube'n nin, nin chin chilanewe'n nin. Nin e' baj bentz tan bajse'n yi txa'x ch'im yi at xo'l aj. ");
INSERT INTO aguBl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Wutz chicoc yi juka'tz xomche'e'n tzaj jukt wacẍ yi chin ẍtow nin e', nin chin juntlen nin chiyubil. Cho'n tzun cyopone'n stzi' a' chinaka'jil yi juk balaj wacẍa'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Cyoque'n tzun yi juk wacẍa'tz yi chin ẍtow nin e' tan chibajse'n yi jukt yi chin chilanewe'n nin. Ele'n nintzun ban watl faraón te yi jun tkuja'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Poro taje'n tzun subij junt tir faraón tan watl, nin oc ẍchajol tib junt wutzicy' swutz. Nin til yi je'n mule'n jun wi' triw yi baj elu'l juk bakaj wutz te'j, yi chumbalaj nin. ");
INSERT INTO aguBl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Poro i te'n nin te yi jun tkuja'tz yi e' eltu'l te ite'n nin wi' triwa'tz jukt bakaj triw yi chin matz' nin wutz nin chin tz'e'nak nin. ");
INSERT INTO aguBl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ej nin yi juk bakaj wutz triwa'tz yi chin matz' nin, e' oc tan chibajse'n yi juk bakaj yi chin balaj nin. Ele'n nintzun ban watl faraón nin el xtxumtz tetz yi wutzicy' na ban. ");
INSERT INTO aguBl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Itzun yi tule'n skil le junt eklok wi'nin txumu'n atit cu'n tan paj yi wutzicy', nintzun cawunintz tan quicy'le'n tzaj cyakil yi e' nachol yi ate' Egipto tan xtx'olche'n xo'l yi wutzicy'. Toque'n tzun faraón tan xtxole'n yi wutzicy' i' scyetz. Poro cya'l nin jun xcye' tan talche'n tetz yi mbi na elepont yi wutzicy'. ");
INSERT INTO aguBl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Bene'n tzun tlol yi cyajcawil yi ak'ol tc'a' faraón tetz: —Max c'u'lu' ta', poro jalcu'n ja ul tx'akx tinc'u'l yi kil yi kajuchnak swutzu', yi in wetz tu yi k'ajtzun cyajcawil yi e' bnol pamu'. ");
INSERT INTO aguBl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ya'stzun ẍchi'che'n c'u'lu' ske'j nin cho'n tzun o' bene'ntz tanu' xetze', xe ca'l yi wi'tz ajcaw squibaj yi e' q'uicy'lom pres. ");
INSERT INTO aguBl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ej nin te yi ato' xetze' nintzun oc ẍchajol tib jun wutzicy' swutz yi cyajcawil yi bnol pam. Ej nin ncha'tz in wetz at jun inwutzicy' ban. Apartchk len eka'n tan yi jujun kawutzicy'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ej nin tul yi ama'la'tz kale ato't xetze' at jun xicy attz yi hebrey i', jun ẍchakum yi wi'tz ajcaw scye'j q'uicy'lom pres. Cho'n tzun katxolil yi kawutzicy' te yi jun xicya'tz nin xcye' i'-tz tan xtx'olche'n xo'l yi mbi na elepont. ");
INSERT INTO aguBl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","El cunintz te'j quib yi baj tlol i' sketz. Yi in wetz in no'c junt tir te wak'une'j. Ma yi junt je nin ch'imba'n te'tz tcya'j jalen cu'n quime'n, stzun i' bantz tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Yi tbital faraón yi xtxolbila'tze'j nintzun cawunin tan ẍchakle'n Ẍep. Lajke'l tzun tele'n tzaj quicy'altz xetze'. Ma Ẍep ninin octz tan telse'n jak' wi', nin tan xtx'ixpe'n be'ch tetz. Kalena's tzun tocopone'n swutz faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Jilone'n tzun faraón tetz. Itzun taltz: —At jun inwutzicy' mban, poro cya'l nin jun yi jak xcye' tan xtx'olche'n xo'l. Poro ja wit yi aẍatz yi na awit jun kawutzicy' na cxcye' tan xtx'olche'n xo'l. ");
INSERT INTO aguBl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","—Ta' nk'e'tz bin in wetz na tx'olon xo'l, stzun Ẍep. —Ma na Ryos xtx'olonk xo'l teru', ilu' jun c'oloj inrey. ");
INSERT INTO aguBl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Saje'n tzun xtxolil faraón yi wutzicy' tetz Ẍep. Itzun taltz: —Yi inwutzcy'aj i'tz, yi cho'n txiclchin stzi' a' Nilo. ");
INSERT INTO aguBl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Nin jalt cuntunin nwilnin yi nchije'ul juk wacẍ yi chin chic'atzaj nin, nin chin chiyube'n nin. Yi nchije'ul nin ncho'c tan bajse'n ch'im yi at txo'l aj. ");
INSERT INTO aguBl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Wutz chicoc yi juka'tz xomche'e'n tzaj jukt wacẍ yi qui'c nin chiyubil nin chin ẍtow nin e'. Qui cunin otojt na wil wacẍ tzone'j Egipto chi quitane'n yi e' wacẍa'tz yi nwil yi qui'c nin chiyubil. ");
INSERT INTO aguBl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Itzun yi juk wacẍa'tz yi chin ẍtow nin e' nin ncho'c tan chibajse'n yi juk yi chin chic'atzajwe'n nin. ");
INSERT INTO aguBl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Yi nwi't baj yi juka'tz cyak'un iẍnin chiẍtowil mban quentz. Ele'n nintzun mban jun rat inwatltz. ");
INSERT INTO aguBl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","”Ma yi nchinwit junt tir nin mmo'ct ẍchajol tib junt wutzicy' tzinwutz. Nin ja wil yi nje'ul jun wi' triw. Nin te yi jun wi' triwa'tz ja chelu'l juk bakaj wutz yi chin yube'n nin. ");
INSERT INTO aguBl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ej nin ta'ste'n nin te yi jun wi' triwa'tz ja wil yi chibaj elu'l jukt bakaj triw yi chin matz' nin. ");
INSERT INTO aguBl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Itzun yi juk bakaj wutz triwa'tz yi chin matz' nin, nin ncho'c tan bajse'n yi jukt bakaj wutz triw yi chumbalaj nin. Ja intxol scyetz yi e' nachol, poro cya'l nin jun yi nink nxcye' tan xtx'olche'n xo'l swetz yi mbi na elepont. ");
INSERT INTO aguBl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Jilone'n tzaj tzun Ẍep tetz faraón. Itzun taltz: —I cob wutzicy' yi nẍchaj tib swutzu' ta', jun ntzi' xtxolbil na ẍchaj. Na tzan Ryos tan talche'n teru' yi mbi cu'n sbne' i' tzone'j Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","I yi juk wacẍ yi chin chic'atzaj nin na ẍchaj juk yob. Ncha'tz yi juk bakaj wutz triw yi chumbalaj nin ite'n nin yi juk yoba'tz na ẍchaj. Yi cob wutzicy'u' na ẍchaj ite'n nin xtxolbila's. ");
INSERT INTO aguBl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ma yi juk wacẍ yi chin ẍtow nin na ẍchaj juk yob. Ncha'tz yi juk bakaj wutz triw yi chin matz' nin ite'n nin yi juk yob na ẍchaj. Yi juk yoba'tz na ẍchaj juk yob we'j. ");
INSERT INTO aguBl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Tan yi xtxolbile'j, na tzan Ryos tan ẍchajle'n teru' yi mbi sbne' i' tzone'j Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","At juk yob balaj cosech sbne' swutz cyakil yi luwar cwent Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Yil jepon tampuj yi juk yob balaj cosecha'tz, xomt tzaj tzun jukt yob yi ploj cosech sbne'. Nin copon jun chin wutzile'n we'j. Cya'lt nin jun yi nink ltz'ult tx'akxuj tc'u'l yi e'ch balaj cosech yi sjalok cyen, na i yi jun chin wutzile'n we'ja'tz ya'stzun ltz'ocsan yab twi' cyakil yi tnum Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Chin wutzile'n nin sbne' yi jun chin we'ja'tz, na sicyer nink lcyaj cyen senil yi balaj cosech yi sjalok. ");
INSERT INTO aguBl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Cob tir nẍchaj tib ite'n nin wutzicy'a'tz swutzu' ta' na ja wi't bixe' tan Ryos tan tele'n cu'n te'j nin sbnixok chan ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Cha'stzun te ilu' jun c'oloj karey, ba'n tcu'n yi nink ljoyu' jun yaj yi chin list nin, nin yi at tajtza'kl tan toque'n i' tetz ajcaw tibaj cyakil yi tnum Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ilu' jun c'oloj karey, je ltuleju' je'j: Che' bixbaju' cobox gobernador, tan chibene'n tulak yi e'chk luwar cwent Egipto tan molche'n yi to'i'n part tetz yi balaj triw yi sjalok tul yi juk yob balaj cosech. ");
INSERT INTO aguBl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Cho'kentz tan molche'n yi balaj triw yi sjalok tul yi balaj tiemp yi tz'ul. Nin ba'n lchimoltz tul jun ama'l tan toque'n tcwentu' ilu' karey. Nin ba'n lchicoltz tulak jujun tnum, bantz jale'n chiwa' yi e' wunak tzantzaj. ");
INSERT INTO aguBl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tan yi xtxolbile'j scolxok wi'nin triw tetz cyakil yi e'chk tnum tcwent Egipto bantz qui chiquime'n yi e' wunak tan we'j tul yi juk yob we'j yi copon, stzun Ẍep bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ba'n tzun bantz ẍchiwutz faraón scyuch' yi e' mas ajcaw yi ate'-tz xlaj. ");
INSERT INTO aguBl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Cha'stzun te talol faraón scyetz: —Chinch wetz quil jal junt yaj ka'n yi ni'cu'n i' tu yi jun yaje'j, yi xomij yi espíritu Ryos te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Bene'n tzun tlol faraón tetz Ẍep: —Cya'l nin junt yi chin list nin, nin chin tz'aknak cu'nk tzawutz, na Ryos mma'lon cyakil yi xtxolbile'j tzatz. ");
INSERT INTO aguBl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ma jalu', cẍocopon tetz ca'p ajcaw tzinxlaj. Nin cyakil wunak chocopon tzak' aca'wl. Cya'l jun yi atk mas k'ej sbne' tzawutz ma na ntin cu'n in, na in yi rey. ");
INSERT INTO aguBl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","¡Bit tzaj Ẍep! in nchincawun tan awoque'n tetz ca'p ajcaw tibaj cyakil Egipto, stzun faraón bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Yi wi't tlol yi xtxolbile'j, nintzun ben faraón tan telse'n tzaj yi xmalk'ab yi at wi k'ab, tu yi sey i', nin cu tk'ol yi xmalk'ab wi k'ab Ẍep. Ncha'tz tulej yi sey, nin cu cotbaltz skul Ẍep. Nin lajke'l nin cawune'n nintz tan toque'n tak'le'n e'chk balaj be'ch tetz Ẍep yi lino cu'n, nin tan cwe'n cotba'n jun balaj uwaj yi or cu'n skul. ");
INSERT INTO aguBl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Yi wi't wekxe'n Ẍep kalena'tz tzun je'n nintz tan yi faraón tul yi jun balaj care't yi cyakil nin tir cho'n na xomnin wutz coc yi tetz care't. Nin cawun nintz scyetz e' ẍchakum tan chibajxe'n tbe' swutz Ẍep yi na xon tul care't, tan talche'n scyetz cyakil yi e' wunak yi ate'-tz tan chije'n tbe'. Ya'stzun bantz yi bixewe'n Ẍep tetz ca'p ajcaw tibaj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Bene'nt tzun tlol faraón tetz Ẍep: —Yi in wetz, in yi wi'tz ajcaw tzone'j, poro cya'l nin jun yi nink scaw cu'n tib tan banle'n jun takle'n yi ko nk'e'tz aẍ cawunin te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Nintzun oc tk'ol yi faraón jun bi' Ẍep tetz Zafnat-panea. I'tz jun bi'aj yi cho'n na xcon ẍchixo'l yi e' aj Egipto. Ncha'tz nin e' cu tok'bel faraón yi Ẍep tu Asenat, yi me'l Potifera yi jun wi'tz pale' le tnum On. Ya'stzun bantz yi toque'n cyen Ẍep tetz ca'p ajcaw tibaj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","At tzun Ẍep tul junaklaj yob yi topone'n ticy'le'ntz swutz faraón. Yi tele'n tzaj i' swutz faraón nintzun bentz tan xajse'n cyakil yi luwar cwent Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Wi'nin tzun cosech bantz tul yi juk yob balaj tiempa'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Nintzun oc Ẍep tan molche'n cyakil yi triw yi jaltz Egipto tul yi juk yoba'tz. Nin baj cyen cololtz tulak yi jujun tnum. Cyakil yi triw yi baj mololtz wutzak yi e'ch cojbil, cho'n baj cyaje'n cyen cololtz tulak yi e'ch tnum yi ate'-tz naka'j. ");
INSERT INTO aguBl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Cho'n cunin ban triw yi baj molol Ẍep chi tane'n yi samlicy' tzi mar. Tan paj yi wi'nin triw opontz swutz Ẍep qui nin xcye' i' tan ticy'le'n nin tajlal. Cha'stzun te tele'n stzakpul yi ma'le'n yi triw yi na opon. ");
INSERT INTO aguBl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Te yi ntaxk xe'tij yi juk yob we'j, ya'stzun e' jale'n yi cob cy'ajl Ẍep te yi txkel yi na bi'aj Asenat. ");
INSERT INTO aguBl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yi bajx cy'ajl yi itz'ij nin oc tk'ol yi bi'-tz tetz Manasés, na nin taltz: “Ryos me'lsan te inc'u'l cyakil yi sotzaj c'u'lal. Nin ncha'tz qui't na chu'l tx'akxuj inxonl tinc'u'l.” ");
INSERT INTO aguBl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ma yi ca'p yi itz'ij nin oc tk'ol yi bi' tetz Efraín, na nin taltz: “Ryos nchijalsan innitxa' tzone'j tul yi jun tnume'j kale intijnakwit wi'nin q'uixc'uj.” ");
INSERT INTO aguBl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Yi ticy'e'n pone'n yi juk yob balaj cosecha'tz Egipto, ");
INSERT INTO aguBl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","xe'te'n nintzun ban yi jukt yob we'j quib yi talnak Ẍep. Ncha'tz wi'nin we'j ban tulak e'chk mas tnum. Ntin cu'n Egipto qui nchiquim tan we'j na at cyetz chiwa' colij cya'n. ");
INSERT INTO aguBl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ma yi baje'n chiwa' yi e' aj Egipto yi colij cya'n xe'ak chipach nintzun e' bentz swutz faraón tan jakle'n chiwa'. Itzun taltz scyetz: —Quilo'kwok swutz Ẍep, nin tzibanwok tane'n yi mbil tal i' tzitetz, stzun faraón bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Itzun yi bene'n lo'on yi we'j tulak yi e'chk tnum cwent Egipto nintzun baj je jakol Ẍep cyakil yi e'chk cu'lbil triw tan c'aye'n scyetz e' aj Egipto, na maxe'n nin ban yi we'j. ");
INSERT INTO aguBl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ncha'tz e' baj sajle'n wunak tulak e'chk nación tan lok'che'n triw tetz Ẍep, na qui'c chiwa' jaltz tulak cyetz chitanum. ");
INSERT INTO aguBl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Itzun bantz yi tbital Jacow yi at triw Egipto, nintzun taltz scyetz yi e' cy'ajl: “¡Or yaj! ¿Mbi na ibanwok tzone'j? Tunin na ixmaywok cuntunin itibtz, ");
INSERT INTO aguBl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","na ja a'lchij swetz yi at triw Egipto. Or tzibene'n. Cun lok'wok mu'ẍ kuxi'n triw, tan qui kaquime'n tan we'j.” ");
INSERT INTO aguBl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Bene'n nintzun e' ban lajujtz scyeri e' stzicy Ẍep tan lok'che'n triw jalen Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Poro qui nin ben stzakpul wutzile'n Jacow yi Benjamín, yi titz'un Ẍep scye'j yi e' stzicy. Na nin octz tan xtxumle'n ko takle'n bi' sban. ");
INSERT INTO aguBl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Cho'n tzun chixome'n nin yi e' cy'ajl wutzile'n Israel ẍchixo'l coboxt aj Canaán yi cho'n at chibembiltz Egipto tan lok'che'n chiwa'. Na ncha'tz, nsken wi't ben lo'on yi we'j Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ma yi Ẍep, i' tzun yi ca'p ajcawtz tibaj cyakil yi tnum Egipto. Nin ite'n nin i' na c'ayin triw scyetz cyakil yi e' wunak yi na' cuntu' na chibaj sit tulak e'chk tnum. Itzun bantz yi cyocompone'n yi e' stzicy Ẍep swutz, nintzun e' baj cu'n mejlok swutz, jalen cu'n yi baj cwe'n pone'n yi wutz chiplaj wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Nicy' yi baj cyocompone'ntz swutz Ẍep, ninin tzun tajskej i' chiwutz yi e' stzicya'tz, poro quinin tal scyetz. Poro yi Ẍep nintzun xcon cobox yol ta'n yi chin quiw nin. Itzun taltz scyetz: —Ma axwok itetz, ¿mbi tzun na ijoywok tzone'j? ¿Na' ncẍsite't wok? —Cho'n bin nkabaj saj ketz Canaán. Ja ku'l tan lok'che'n triw, che'ch tzun ban nintz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Nsken tajskej Ẍep chiwutz yi e' stzicy, ma yi e' cyetz quinin el chitxumtz tetz yi ko i i'a'tz yi Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tule'n tzun tx'akx tc'u'l Ẍep yi wutzicy' yi ban scye'j yi e' stzicy. Itzun taltz scyetz: —Yi axwok itetz axwok tu' xk'ukwil. Ntin ja cxu'lwok tan tilwe'n yi ẍe'n tane'n yi katanum, stzun Ẍep scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","—Qui' ta', yi o' ketz o' xconsbe'tzu'. Ej nin ntin ja ku'l tan lok'che'n mu'ẍ kawa' triw. ");
INSERT INTO aguBl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nin yi cobox o' ketz junit yi ketz kataj, nin o' balaj wunak, cya'l cunin na koque't ketz tetz xk'ukwil, che'ch tzun bantz. Poro yi Ẍep nin oc ch'inch'uj tan talche'n scyetz: ");
INSERT INTO aguBl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","—Nk'e'tz bintzi na ital. Na yi ax itetz ntin ja cxu'lwok tan xk'uke'n yi ẍe'n tane'n yi katanum, stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","—Qui' ta', che'ch. —Yi o' ketz o' xconsbe'tzu'. Coblaj kaxone'n yi kitz'un kutzicy kib. Junit kataj. Jalt yi kach'i'pil ja cyaj cyen tu wutzile'n kataj jalen Canaán, na cho'n nka saj ketz Canaán. Ma yi junt kitz'un, alo' atite't i' nin ẍe'n lo' bene'n i'. ");
INSERT INTO aguBl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Bene'n tzun stza'wel Ẍep yi chiyol, itzun taltz: —Jun cu'n yol, axwok cu'n xk'ukwil. ");
INSERT INTO aguBl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Poro skile' ko bintzinin na ital nka qui'. Tan bi' faraón quil xintzakplenwok jalen yil tz'ul yi ich'i'pil tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Or bin sbene'n jun tzixo'l tan ticy'le'n. Ma yi mas chocopon cyen pres, bantz kilol yi ko bintzinin mitalwok. Nin yi ko nk'e'tz bintzi yi mitalwok, axwok nintzun xk'ukwil tera'tz. Jun cu'n yol na walnin tzitetz, stzun Ẍep bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Nintzun e' oc ox k'ej xetze' tak'un Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Itzun le toxe'n k'ej nintzun tal Ẍep scyetz yi e' stzicy: —Yi in wetz na wek ẍchi' Ryos, tzincuye' yi ipaj kol tziban yi xtxolbile'j yi swale' tzitetz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Yi ko bintzinin na ital, yi ko axwoknin balaj wunak, cyajk jun stzixo'lwok tzone'j xetze'. Ma yi e' mas, ba'n lcha'jt nin ba'n chicy'ajnin triw tetz chiwa' chinajal. ");
INSERT INTO aguBl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Nin ba'n cxpakxijwok lajke'l. Poro cy'ajwok tzaj yi ititz'un yi tal ich'i'p. Kalena'tz tzun lkil yi ko bintzinin na ital. Nin yi ko quil tz'ul ita'n xquimok tzun woktz, stzun Ẍep bantz scyetz. Nintzun cu'-tz ẍchiwutz yi e' stzicy Ẍep yi mbi cu'n baj tlol scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Chibaj xe'te'n tzuntz tan yol squibil quib. Itzun cyaltz: —Yi mero bintzi, chin mal nin banako' te tal kitz'un. Na qui nin oc jun yol te kawi' nicy' yi na cu' wutz i' sketz tan tele'n kak'ajab te'j. Wech na kilnin cunintz tzituch' yi chin bisnin tal tane'n i'-tz tkak'ab. Cha'stzun tej ja ul yi jun chin sotzaj c'u'lal skawutz ketz jalu', che'ch tzun bantz squibil quib. ");
INSERT INTO aguBl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Saje'n tzun stza'wel Rubén yi chiyoltz: —Qui tzun wal tzitetzwok yi qui' klo' iban wok yi jun xtxolbila'tz te'j tal kitz'un. Poro qui nin oc inyol te'j iwi'. Ana' tzuntz skachoje' yi kil yi quime'n yi kitz'un ka'n, stzun Rubén bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Qui tzun el chitxum tetz yi ko na icy' yi chiyoltz le wi' Ẍep. Na yi toque'n Ẍep tan yol ẍchiwutz nin joy i' junt tan toque'ntz tan xtx'ixpe'n yi yol i' le yi cyetz chiyol. ");
INSERT INTO aguBl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Tele'n tzaj tzun Ẍeptz ẍchixo'l nin xe'tijtz tan o'kl. Itzun yi wi't ticy'e'n pajtz tan o'kl, nin yi quiwixe'n talma'-tz tan yol scyetz nin oc pon junt tir chixo'l. Yi tocopone'n ẍchixo'l nintzun el jatxol yi Simeón nin cu c'aloltz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Kalena's tzun cawune'n nin Ẍep scyetz yi e' tetz mos tan cwe'n chinojsal chisac tan triw. Ncha'tz cawunintz scyetz tan taje'n junt tir yi jamel tulak chisac. Nin cawunintz tan bene'n ak'ij chiwa' tetz chibe'. Ej nin ya'tz nintzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Chibene'n tzun yi e' stzicy Ẍep tan je'se'n yi cyektz te'jak chiburu'. Ma yi chibaj wekxe'n, aje'n nin e' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Itzun te yi cyopone'ntz tul yi ama'l kale e' baj cyaj cyent tan watl, bene'n tzun jun tan pujle'n stzi' yi tetz sac, tan je'se'n tzaj cba's triw tetz chiwa' e' buru'. Nintzun nojcyentz te'j yi cho'n at tzaj yi tetz pu'k stzi' yi sac. ");
INSERT INTO aguBl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Bene'n tzun tlol scyetz yi e' tuch': —¡Xmaywok tzaj! Ja ajtzaj tak'le'n yi wetz impu'k. Je, at stzi' insaque'j, stzun i' bantz. Xobe'n nintzun e' bantz, nin e' baj xe'tijtz tan lucnewe'n tan paj yi xo'w yi ate' cu'nt. E' xe'te'n tzuntz tan yol squibil quib. Itzun cyaltz: —¿Mbi nintzun i ila'tz yi ncu' nuc'u'l Ryos ske'j? che'ch tzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Yi wi't cyopone'n Canaán, nintzun baj quen chitxoliltz tetz Jacow yi chitaj yi mbi cu'n e' bantz. Itzun cyaltz: ");
INSERT INTO aguBl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","—I yi jun yaj yi na cawun le tnum kale nxkake't, chin cachi' nin yol baj tlol i' sketz. Na i ban swutz i' o' tu' xk'ukwil ketz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nintzun kal ketz tetz yi o' ketz o' balaj wunak, nin cya'l cunin na koque't ketz tetz xk'ukwil. ");
INSERT INTO aguBl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ej nin ncha'tz kal ketz yi coblaj cu'n ketz kaxone'n yi kitz'un kutzicy kib. Junit yi ketz kataj. Ntin jun kitz'un cho'n at cyen te'j kataj ma yi junt qui'ct i' at, ẍe'n lo' bene'n i', ko'ch ketz bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","”Itzun yi tbital yi jun yaja'tz yi xtxolbil yi nkal tetz, nintzun taltz sketz: “Ibin jalu', tan tele'n intxum tetz yi ko bintzinin axwok balaj wunak, na waj yil lcyaj cyen jun tzixo'lwok xetze'. Ma ax itetz ba'n cxben tan nojse'n yi isac nin cy'ajwoknin mu'ẍ triw tetz chiwa' inajal. ");
INSERT INTO aguBl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Itzun yil cxsajwok junt tir, cy'ajwoktzaj yi ititz'un, yi tal ch'i'p yi na ital, nin yi kol tz'ul ita'n, swocsaje' tzuntz yi i'tz yi mero bintzi yi na ital yi axwok balaj wunak. Nk'e'tz tzun axwok xk'ukwil. Kalena'tz tzun ltz'el liwr yi jun yi scyajk xetze'. Ncha'tz swak'e' tzun ama'l tzitetz tan ixone'n alchok ama'lil tzone'j Egipto,” stzun yi jun yaja'tz ban tzajtz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Itzun te yi baj tele'n tzaj chikojol yi triw yi cy'a'n cya'n tulak chisac nin ben quiloltz yi baj cyele'n tzaj wokpuj jujun tal tx'u'y yi c'alijlen stzi'. Cho'n tzun at tzaj yi chipu'ktz tul. Itzun yi quilol yi baj cyele'n tzaj wokpuj yi jujun tal tx'u'ya'tz tulak yi chisac ninin tzun e' baj xobtz tuml chitaj. ");
INSERT INTO aguBl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Bene'n tzun tlol Jacow scyetz yi e' cy'ajl: —Ko pe' qui'ct nin jun tal incy'ajl sbne' cyen ita'n wok. Je nin Ẍep qui'ct at ske'j tzituch'. Ncha'tz Simeón qui't mmu'ltz ita'n wok. Ma jalu' na itajwok tzitcy'ajwoknin Benjamín. Tin tzun in, na chintzaj tan bis tan o'kl yi xtx'akxle'nix yi jun incy'ajl. Ma axwok itetz qui na cxbisunwok, stzun Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Jilone'n nintzun Rubén tetz yi taj. Itzun taltz: —Ma jalu' bin ta', stzakpninu' Benjamín ske'j. In lnicy'anin, nin in te'nin lnu'lsan swutzu'. Ej nin yi ko quil tz'ult wa'n, ba'n tzun lche' biycunu' yi cob tal wetz incy'ajl. ");
INSERT INTO aguBl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Saje'n tzun tza'wel Jacow. Itzun taltz: —Qui'c rmeril tan bene'n intzakpul yi tal incy'ajl tzite'jwok. Cunin pe'k k'ajtzun inẌep yi quimnak. Jaltnin tal Benjamín at cyen swe'j. Nin yi ko takle'n bi' sban i'-tz tik'abwok ẍe'n tzun tzimban, stzun i' ban. —Na yi in wetz ja chin tijin, nin ipajwok yi kol chinquim tan bis. ");
INSERT INTO aguBl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Bene'n nintzun ban lo'on yi we'j Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Itzun baje'n yi triw cya'n Jacow scyuch' yi e' cy'ajl yi ẍchicy'aje' tzaj Egipto, nintzun tal Jacow scyetz: —Or tzibene'nt junt tirt, nin cun lok'wok mu'ẍt kawa' triw, stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Saje'n tzun stza'wel Judá. Itzun taltz: —Ba'n ta'. Poro sajcunin tlol yi jun yaj yi c'ayin tzaj yi triw sketz, yi qui't na taj i' ltilcu'n kawutz chone'j yi ko qui cy'a'n yi kitz'un ka'n yil kopont. ");
INSERT INTO aguBl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ntin yi kol stzakpninu' yi kitz'un ske'j, ba'n tzun lkabentz tan lok'che'n triw. ");
INSERT INTO aguBl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Poro ko quil stzakpninu' yi kitz'un ske'j, quil kaben ketz. Na saj cunin tlol yi jun yaja'tz sketz, yi qui't na taj ltil cu'n kawutz chone'j yi ko qui cy'a'n yi kitz'un ka'n, stzun Judá tetz taj. ");
INSERT INTO aguBl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","—¿Mbi tzuntz yi wi'nin tunin e'ch takle'n na cxtzanwok tan nuc'le'n swe'j? ¿Nxac na italquen wok tetz yi jun yaja'tz yi ko at junt ititz'un? stzun Jacow scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Saje'n tzun chitza'weltz: —I' bin jakon sketz yi ẍe'n kutane'n scyuch' yi e' kanajal, na je bin jak i' sketze'j: “¿Itz'e't pe' itaj? ¿At pe' junt ititz'un?” chij i' ban sketz. Nintzun kal ketz yi bintzi, na qui nin el katxum tetz yi ko stale' i' sketz yi tajwe'n tan bene'n kucy'al yi kitz'un ske'j, che'ch tzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Bene'n tzun tlol Judá tetz yi taj: —Ma jalu' ta', ko qui na kaj lkaquim tan we'j, stzakpninu' yi kitz'un ske'j. Cho'n xomk nin i' swe'j. Ej nin ko ba'n swutzu' ta', ba'n tzun kaben chan tan lok'che'n triw. Qui't tzun kaquimtz tan we'j, scyuch' yi e' kanajal. ");
INSERT INTO aguBl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Poro ko takle'n bi' sban yi kitz'un, in tzun te'tz yi mero aj paj sbne' ko qui't xomij swe'j yil ku'lt tzaj swutzu'. ");
INSERT INTO aguBl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Yi qui'k nko'c tan xtxumle'n yi xtxolbila'se'j, ja klo' wi't el cobix tir kukan tan lok'che'n triw. ");
INSERT INTO aguBl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Saje'n tzun tlol Jacow tetz: —I bin jalu' qui'ct nin junt rmerila'tz. Poro je bin tzibanwoke'j: Ba'n tzicy'ajwok nin e'chk oy tetz yi jun ajcawa'tz. Cy'ajwok nin yi e'chk takle'n yi mas balaj yi na jal tzone'j le ketz katanum. Cy'ajwok nin balsamo, cy'ajwok nin ta'al wunak txuc, cy'ajwok nin perfum, cy'ajwok nin mirra, ej nin cy'ajwok nin nues tu almendra. ");
INSERT INTO aguBl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ncha'tz cy'ajwok nin cob tir mas tajlal yi pwok swutz yi pwok yi ben itcy'al bajx tir. Nin axwok nin klo' xak'on cyen yi pwok yi ult ita'n na qui cunin batz xubse'n ibanwok. ");
INSERT INTO aguBl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Quilo'k bin wok junt tir. Ej nin cy'ajwok nin ititz'un tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nink tz'el k'ajab Kataj Ryos tzite'jwok. Na yi ketz kaRyosil wi'nin ẍchamil, nin na xcye' te cyakil. Xcyek tzun i' tan telse'n tzaj liwr yi junt incy'ajl yi at cyen xetze'. Nin ncha'tz xcyek tan tulse'n Benjamín. Ban wetz, yi ko qui'ct jal jun incy'ajl sban cyen, ja bina'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Chibaj bene'n tzun yi e' cy'ajl Jacow. Ej nin ben quicy'al yi e'ch oy, tu cobt tir mas yi tajlal pwok. Ncha'tz e' ben quicy'al Benjamín. Bene'n nintzun e' bantz Egipto. Itzun bantz yi cyopone'ntz swutz Ẍep, ");
INSERT INTO aguBl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","nin ben tilol Ẍep yi xomij Benjamín scye'j. Bene'n tzun tlol tetz yi martoma': —Cy'ajwe' nin yi cobox yaje'j xe inca'l. Ej nin ba'n tzabiy cu'n jun wacẍ, nin banaj ba'n tetz, na yi e' yaje'j cho'n ẍchiwank swuch' tetz chajcu'n k'ej. ");
INSERT INTO aguBl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Inin tzun tulej yi martoma'a'tz quib yi tal Ẍep tetz. Nintzun e' ben ticy'le'n yi e' stzicy Ẍep xe ca'l. ");
INSERT INTO aguBl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Itzun bantz yi chibene'n ticy'le'n xe ca'l Ẍep nin e' xobtz, nintzun cyaltz squibil quib: —Yi xtxolbile'j i'tz tan kasuble'n tu', tan paj lo' yi pwok yi ajt junt tir tul yi e'chk kasac. Quicunin batz chocopon tan kabuchle'n nin skacyajk cyen kacyakil cu'n tetz esclaw cyuml yi e' kaburu'. ");
INSERT INTO aguBl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ma yi cyopone'n stzi' yi puertil yi ca'l Ẍep nintzun e' jilontz tetz martoma', nin cyaltz: ");
INSERT INTO aguBl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","—¡Siwl ta'! Yi mero bintzi i'tz yi kulake'n bajx tir ja ku'lak tan lok'che'n triw. ");
INSERT INTO aguBl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ma yi kapakxe'n Canaán nin yi kujewe'n yi bajx akale'n nin yi je'n kapujul kasac, ja kil yi jamel yi triw yi nkachoj. Ni'cu'n yi tajlal tu yi pwok yi ncyaj kak'ol scyeru' tetz jamel yi ixi'n. Ma jalu' ja ult junt tir yi pwok ka'n. ");
INSERT INTO aguBl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ncha'tz ja ul mas pwok ka'n tan lok'che'n mas triw. Poro qui na pujx ka'n na' ak'on cu'n kapu'k tulak yi kasac yi kaje'n, che'ch bantz tetz martoma'. ");
INSERT INTO aguBl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","—Quil cxbisunwok nin quil cxobwok, na i lo' iRyosil, yi Ryosil itaj, yi mmak'on cu'n ipu'k tulak isac. Na yi in wetz ja intz'am yi jamel triw yi itak'wok. Bene'n tzun martoma' tan telse'n tzaj Simeón xetze' nin ben tcy'altz scye'j yi e' stzicy. ");
INSERT INTO aguBl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kalena'tz tzun cyoque'ntz xe ca'l Ẍep. Ej nin tak' martoma' a' scyetz tan chitx'ajol quikan. Ncha'tz tak' chiwa' yi e' chiburu' yi cy'a'n cya'n. ");
INSERT INTO aguBl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ma yi e' stzicy Ẍep cyoque'nt tzuntz tan nuc'le'n e'chk oy yi cy'a'n cya'n tan cyoyil tetz Ẍep. Nintzun e' ch'iw jalen yi topone'n Ẍep chajcu'n k'ej na nsken quibit yi at tpombil i' tan wa'a'n. ");
INSERT INTO aguBl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yi topone'n Ẍep xe ca'l nintzun cyak' yi oya'tz yi cy'a'n cya'n, nin e' cu jokloktz jalen yi cwe'n pone'n yi wutz chiplaj wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Toque'n tzun Ẍep tan jakle'n yi ẍe'n chiyol, nin tan jakle'n scyetz: —¿Ẍe'n yol itaj yi italwok swetz? ¿Ba'n pe' i'? ¿Itz'e't pe'? ");
INSERT INTO aguBl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","—Ba'n ta'. Ba'n atit yi ẍchakumu' yi wutzile'n kataj. Nintzun cu' chiwutz junt tir tan tak'le'n k'ej Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Itzun yi xmayine'n nin Ẍep scyetz nintzun til yi titz'un Benjamín yi junit chitaj chitxu' tuch'. Bene'n tzun tlol scyetz: —¡Ah! yi xicye'j, ya'tz lo' ich'i'pilwok yi italwok swetz. Bene'n tzun tlol tetz Benjamín: —Aẍ jun c'oloj yaj, tak' tzaj Kataj banl tzawibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Itzun yi bene'n tlol Ẍep yi yola'se'j nintzun ok' c'u'ltz te yi titz'un. Lajke'l nintzun bene'n i' ẍchuc xe cuart. Nin oc jopol tibtz tan o'kl tan yi tzatzi'n yi at cu'nt yi tilol wutz yi titz'un. ");
INSERT INTO aguBl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Yi ticy'e'n yi o'kl te'j nintzun oc tan xtx'ajle'n wutz nin eltzaj junt tir ẍchixo'l. Qui nin tzun ẍchaj i' yi mbi na icy' tc'u'l, ma na ja tal i'. “Ma jalu' cy'ajwok tzaj kalak na kawank jalcu'n.” ");
INSERT INTO aguBl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Apart wane't tetz Ẍep. Ej nin apart e' wane't yi e' stzicy. Ncha'tz apart e' wane't yi e' aj Egipto yi na chak'uj tu Ẍep, na xan ẍchiwutz yi nink chiwan scyuch' yi e' hebrey. ");
INSERT INTO aguBl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Cawune'n nintzun Ẍep scyetz yi e' stzicy tan chic'olewe'n cu'n. Txolcunin tzun e' bantz. Xomquen tu' te chiyob. Bajx c'olewe'n cu'n yi bajx nak ta'n na at tetz k'ej, nin wi'tzbil tlen c'olewe'n yi ch'i'p ta'n. Ma cyetz wi'nin tzun cyele'n yabtz te'j nintzun e' baj chixmayil quib squibil quib tan yi xtxolbil yi bajij scye'j. ");
INSERT INTO aguBl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Tk'ol tzun Ẍep yi chiwa' tuch' yi tetz wa' yi at wi tetz mes. Itzun yi lak Benjamín, o' cu'n tir mas nim ntak' swutz yi e' stzicy. E' wan tzuntz nin e' uc'a'-tz. Wi'nin tzun e' tzatzine'ntz tu Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Itzun yi wi't chiwane'n, nintzun cawunin Ẍeptz tetz yi martoma': —Cun nojsaj chisac yi e' yaje'j tan ixi'n triw. Nojk cunin awa'n. Nin cuknin yi jamel stzi'ak chisac. ");
INSERT INTO aguBl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ncha'tz na waj yil cu nin weri inlak yi sakal cu'n, stzi' yi sac yi jun mas juy, tuml yi jamel triw i'. Ej nin ya'tz nintzun tulej yi martoma'. ");
INSERT INTO aguBl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Itzun yi tule'n skil le junt eklok, nintzun tak' Ẍep ama'l scyetz tan chipakxe'n le chi'ama'l. Cy'a'n len chiburu' cya'n yi chipakxe'n. ");
INSERT INTO aguBl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","5","Yi ntaxk chiben mas joylaj, nintzun cawunin Ẍep tetz martoma'. Itzun taltz: —Cun tz'amwe' yi cobox yaj yi e' ulak tzone'j. Nin ba'n tzawal scyetz: “¿Nxac nsaj italk'al yi lak impatrón yi sakal cu'n? Na na xcon ta'n tetz tc'a' nin tan k'eja'n. ¿Nxac mibanwok yi jun takle'na'tz te yi impatrón? Wech pawor mban i' tzitetz. ¡Chin cachi' nin mibanwok!” cẍchij sban scyetz, stzun Ẍep bantz tetz martoma'. ");
INSERT INTO aguBl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yi chitx'amxe'n tan martoma', nintzun taltz yi xtxolbila's scyetz quib yi baj tlol Ẍep tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Yi quibital yi e' stzicy Ẍep, nintzun cyaltz: —¿Mbi tzuntz na xtxum yi patrónu' yi takle'na's ske'j? Na yi o' ketz qui na kaban yi e'chk takle'na'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Na ja tilu' ta', yi ja ul yi jun tx'akaj pwok ka'n yi njal stzi'ak yi kasac yi kopone'n Canaán. Yi ko ya'tz nkaban ¿ẍe'n tzun kalk' nin oro nka sakal xe ca'l yi patrónu'? ");
INSERT INTO aguBl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","¡Kol jal skaxo'l ba'n lquim yi jun yi q'uil tetz! Ma yi o' ketz ba'n kacyaj tetz esclaw yi patrónu', che'ch stzicy Ẍep bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Bene'n tzun tlol yi martoma': —Ba'n, ya'tz nin lkulejtz chi mitalwok. Poro ntin yi jun yi q'uil tetz yi lak, tz'ocopon i' tetz esclaw te yi impatrón. Ma yi e' mas chelepon liwr na qui'c cyetz chipaj. ");
INSERT INTO aguBl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Lajke'l nintzun cwe'n tzaj yi cyektz cya'n. Nin je' chijakol stzi' yi chisac swutz yi martoma'. ");
INSERT INTO aguBl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Nin oc i'-tz tan joyle'n tulak chisac. Cho'n tzun xe'te'n tzaj te yi bajxnak jalen te yi ch'i'p. Ej nin yi jun laka'tz, cho'n tzun jale'n le sac Benjamín. ");
INSERT INTO aguBl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Yi quilol, nintzun e' octz tan katzle'n yi be'ch cyetz tan bis yi ate' cu'nt. Ej nin je' junt tirt yi cyektz cya'n te yi chiburu'. Pakxe'n nintzun e' bantz tnum. ");
INSERT INTO aguBl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Itzun cyopone'n Judá tu yi e' titz'un xe ca'l Ẍep, nintzun e' cu joklok jalen cu'n cwe'n pone'n wutz chiplaj wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Inti Ẍep nin ben tlol scyetz: —¿Mbi tzun na iban itetz? ¿Qui pe' na el itxum tetz yi in nachol, nin na el intxum tetz yi mbi na ibanwok? stzun Ẍep scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","—Ko ya'tz ta', ¿mbi tzun kaltz teru'? Na ja wi't katxamxij. Quil jal puntil ka'n tan talche'n teru' yi qui'c ketz kil nkajuch. Na ja lo' lajluchax tan Ryos. Ba'n tzun ko'c len kacyakil cu'n tetz esclawu', tuml yi jun kale njale't yi laku', stzun Judá tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Stza'wel tzun Ẍep: —Qui' lo', quil tzimban yi juna'tz. Quil cxcyajwok tetz inesclaw, ma na ntin cu'n yi jun kale njale't weri inlak. Ma axwok itetz ba'n cxa'jwok, stzun Ẍep bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Toque'n tzun Judá tan moxe'n: —Max c'u'lu' ta', tak'e'u' ama'l swetz tan walol cobox inyol teru'. Quil tzicy'anu' swe'j, na ilu' teru' ni'cu'n k'eju' tu wutzile'n faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Yi kulake'n bajx tir ja jaku' jun xtxolbil sketz nin je yolu'e'j: “¿Itz'e't pe' itaj? ¿At pe' junt ititz'un?” chiju' ban sketz. ");
INSERT INTO aguBl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Itzun kal ketz teru': “Itz'e't wutzile'n kataj nin at junt cy'ajl i' yi xicye't. Nsken tijin c'u'l kataj yi titz'e'n yi jun cy'ajla'tz. Ntin cu'n i' itz'e't. Na quimnak yi junt stzicy, yi junit chitaj chitxu'. Cha'stzun te wi'nin na pek' wutzile'n kataj te'j.” ");
INSERT INTO aguBl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ej nin ncha'tz ja talu' sketz: “Cy'ajwok tzaj yi ititz'una'tz na na waj wech wutz,” chiju' ban sketz. ");
INSERT INTO aguBl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ja tzun kal teru' yi qui'c rmeril tan cyaje'n cyen tilol yi taj, na ko ya'tz squimok wutzile'n kataj tan bis. ");
INSERT INTO aguBl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Poro nin talu' sketz: “Ko quil xom tzaj ititz'un tzite'j yil cẍu'lwok junt tir, qui'c tzun rmeril tan ijilone'n swetz,” chiju' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","”Itzun yi kapakxe'n ja tzun kal yi xtxolbila'se'j tetz wutzile'n kataj. ");
INSERT INTO aguBl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ma yi xone'n tiemp nin tal kataj sketz: “Cun lok'wok mu'ẍt kawa' jalen Egipto.” ");
INSERT INTO aguBl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Poro nin kaltz tetz yi qui'c rmeril yi nink kaben yi ko quil xomnin yi kitz'un ske'j. Qui'c cuj yi nink kajilon tu yi ajcaw jalen Egipto ko qui'c Benjamín xomij ske'j yil kopon swutz i'. ");
INSERT INTO aguBl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Saje'n tzun tlol kataj sketz: “Na itilwok yi cobintzi' incy'ajl ja jal te k'ajtzun wuxkel. ");
INSERT INTO aguBl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Jun scyeri yi coba'tz tx'akxnak. Ja lo' baj tan smaron txuc. Qui't nwil wutz i' junt tir. ");
INSERT INTO aguBl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ej nin kol ben yi junt tal incy'ajle'j ita'n, nin ko takle'n nin sban, chinquimok tan bis. Poro ipajwok sbne',” stzun i' bantz sketz. ");
INSERT INTO aguBl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","”Cha'stzun te ko qui't xomij yi kitz'une'j ske'j yil kopon, squimok wutzile'n kataj tan bis. ");
INSERT INTO aguBl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Na cho'n ajlij c'u'l kataj te'j. Ej nin sjalok kapaj kol quim kataj tan bis. ");
INSERT INTO aguBl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ma yi in wetz walnak tetz wutzile'n kataj: “Jun cu'n yol ta' tz'ult junt tir yi cy'ajlu' wa'n. Ej nin ko qui't tz'ul wa'n, in tzun ajpaj sbne' swutzu' sbne' opontunintz.” ");
INSERT INTO aguBl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ma jalu' ta', na cu' inwutz teru' yi nink tak'u' ama'l swetz tan incyaje'n cyen tetz xel Benjamín nin tan woque'n tetz esclawu'. Ma i' tetz ba'n tak'u' ama'l tetz tan taje'n junt tir scyuch' e' stzicy. ");
INSERT INTO aguBl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Na qui'c rmeril tan impakxe'n te intaj yi ko qui xomij yi xicy swe'j. Na qui na waj wil yi bis o'kl yi sbne' intaj tan paj yi qui't tz'opon Benjamín te'j i', stzun Judá bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Itzun yi tbital Ẍep yi xtxolbila'se'j qui nin tzun xtx'ajtz, nintzun taltz scyetz yi e' aj Egipto yi ate' xe ca'l. “Cale'nwok tzone'j.” Itzun yi cyele'n, nin yi chicyaje'n cyen Ẍep chichuc scyuch' yi e' stzicy, nintzun tal i' yi bintzi scyetz yi i i'a'tz yi quitz'un. ");
INSERT INTO aguBl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Xe'te'n nin ban Ẍep tan o'kl. Chin wi' nintzun bantz ninin quibit yi e' aj Egipto yi ate' chinaka'jil. Bene'n nintzun ban lo'on yi stziblala'tz nin ncha'tz tbit faraón yi mbi cu'n bajij xe ca'l Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Je yol Ẍepe'j yi tlol yi bintzi scyetz e' stzicy: —I ina'tz in Ẍep yi ititz'un, ¿Itz'e't pe' tal intaj? Yi quibital yi e' stzicy Ẍep yi xtxolbila'se'j, qui't nin tzun a'w yol cya'n tan paj yi cyele'n tunin yabtz te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Bene'n tzun tlol Ẍeptz scyetz: —¡Ẍkantzajwok tzinwutz! Nintzun e' ben chiẍkansal quibtz. —I ina'tz in Ẍep. Kitz'un kutzicy kib tzituch'. ¿Qui pe' na cxnachon wok te'j, yi sajle'n ic'ayil in scyetz yi e' aj pyaj yi at cyulbil tzone'j Egipto? ");
INSERT INTO aguBl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Poro qui na waj yil cxbisunwok ta'n, nka yil jal oyintzi' tzixo'lwok tan paj. Ryos txumul tetz yi xtxolbile'j tan wule'n chan tzone'j, bantz kaclaxe'n. ");
INSERT INTO aguBl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ja wi't kil cob yob we'j. Ej nin at tzaj nin o't yob yi qui't kil cosech. ");
INSERT INTO aguBl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Poro Ryos nnu'lsan tzone'j yi ntaxk cxu'l itetz tan qui kasotze'n tuml kaxonl. Tan jun chin milawr ja kaclax ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ryos nnu'lsan tzone'j. Nk'e'tz axwok nnu'lsan. Nin Ryos no'csan tetz ak'ol tajtza'kl faraón. Ncha'tz i' nno'csan tetz wi'tz martoma' tibaj cyakil ca'l faraón. Ej nin tantu' yi banl talma' Ryos na chincawun tibaj cyakil Egipto, stzun Ẍep bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Itzun yi tlol i' yi xtxolbila'se'j nintzun taltz scyetz yi e' stzicy: —Or quilo'kwok, nin cun alwok tetz intaj. Je yol Ẍep yi cy'ajlu'e'j: “Ryos nno'csan tetz ajcaw tzone'j Egipto. Ma jalu' ba'n tz'ulu' tzone'j Egipto tan najewe'nu'. Ej nin lok tz'ulchanu'. ");
INSERT INTO aguBl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ba'n naje'u' le jun ama'l yi na bi'aj Gosén, tuml yi e' cy'ajlu', nin yi e' mamu' scyuch' cyakil yi e' tawunu'. Ba'n tz'ulu' tan najewe'n le ama'l Gosén bantz naka'j skaxo'l sbne' tuch'u'. ");
INSERT INTO aguBl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Yil chinaje'u' tul yi jun ama'la'tz, swak'e' chiwa'u' bantz qui chitijolu' q'uixc'uj, scyuch' yi e' yi xomche' te'ju', na yi jun we'j yi na tzan at tzaj nin o't yob tan ticy'e'n,” cxchijwok tz'an tetz intaj. ");
INSERT INTO aguBl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","I bin jalu' axwok stiw te inyole'j yi ja wal tzitetz. Ncha'tz yi witz'un Benjamín i' stiw sbne' te inyole'j. ");
INSERT INTO aguBl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Alwok cyen tetz intaj yi ẍe'n wutane'n tu yi ink'ej yi at tzone'j Egipto. Nin alwok cyen tetz, cyakil yi mitilwok tzone'j. ¡Quilo'k binwok jalcu'n, nin cy'ajwok tzaj yi tal intaj! stzun Ẍep bantz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Bene'n tzun Ẍeptz tan k'ale'n Benjamín yi titz'un, nin ok'tz. Ncha'tz ban Benjamín nin bentz tan k'ale'n tzaj Ẍep nin e' ok' cu'ntz chicabil. ");
INSERT INTO aguBl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ncha'tz ban i' scye'j yi e' mas stzicy nin ben i'-tz tan chik'ale'n nin tan stz'uble'n xak chitzi'. Yi baje'n yi xtxolbila'se'j kalena's tzun e' nimsaj chic'ul yi e' stzicy tan yol tetz Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Bene'n nintzun ban lo'on yi stziblal, nin tbit faraón yi i'tz yi e' stzicy Ẍep yi cobox yaja'tz yi e' opon. Nintzun tzatzin faraón scyuch' yi e' mast ajcaw yi ate' jak' ca'wl i', te yi xtxolbila'se'j. ");
INSERT INTO aguBl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Itzun tal faraón tetz Ẍep: —Al nin scyetz yi e' awutzicy yi ba'n cho'c tan chiwekle'n chiburu' nin ba'n cha'j Canaán le chitanum. ");
INSERT INTO aguBl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ej nin ba'n chipakxij junt tir tu itaj nin cyakil ixonl. Ba'n lwak' jun chinajbil te yi tx'otx' yi mas balaj tzone'j Egipto. Ba'n tzun baj yi e'chk takle'n balaj cya'n yi na jal tzone'j. ");
INSERT INTO aguBl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ncha'tz al nin scyetz yi ba'n chicy'ajnin cobox care't tan ticy'le'n tzaj itaj scyuch' chinajal. ");
INSERT INTO aguBl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ej nin al nin scyetz tan qui sotze'n chic'u'l tan quicy'le'n tzaj yi e'chk chime'bi'l na cyakil cu'n yi e'chk takle'n balaj yi at tzone'j Egipto, cyetz sbne', stzun faraón bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","I nintzun cyuleja'tz yi e' cy'ajl Israel. Toque'n tzun Ẍep tan tak'le'n e'chk care't scyetz, nin yi chiwa' yi tajwe'n tetz chibe'. ");
INSERT INTO aguBl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ej nin ncha'tz tak'le'n jujun lmuj be'ch cyetz. Ma tetz Benjamín tak' o' lmuj be'ch tetz tu ox cient piẍ sakal. ");
INSERT INTO aguBl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ej nin tetz yi taj Ẍep e' ben tabnal lajuj buru' yi cy'a'n len yi e'chk takle'n yi mas balaj yi na jal Egipto. Ncha'tz e' bent lajujt buru' yi cy'a'n triw tu pam tu yi mas takle'n yi ba'n xcon tetz wa' yi taj tul yi tiemp yi xonk tbe' tan tule'n Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Itzun yi chijatxol quib Ẍep scyuch' yi e' stzicy nintzun taltz scyetz: —Cheb cuntu' cxbenwok nin qui na waj yil cxo'yintzink wok tbe'. ");
INSERT INTO aguBl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Aje'n nintzun e' bantz nin e' opontz tu chitaj jalen Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Itzun yi cyopone'n nintzun cyaltz tetz Jacow yi chitaj: “Ta', itz'e't Ẍep. Ej nin i' yi wi'tz ajcaw tetz Egipto,” che'ch tzun bantz. Itzun yi tbital Jacow, qui nintzun a'w yoltz ta'n, nin qui nin tocsaj i' chiyoltz. ");
INSERT INTO aguBl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Poro yi cyoque'n tan xtxole'n cyakil cu'n yi xtxolbil yi tal Ẍep scyetz nin yi tilol i' yi e'chk care't yi ntak' Ẍep tan ticy'le'n nin i' tu yi najal jalen Egipto, nintzun ul yos tuch'. Ej nin tocsaj chiyol yi e' cy'ajl. ");
INSERT INTO aguBl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Itzun taltz: “¡Ma jalu' na wocsaj yi itz'e't incy'ajl! Nchimben bin tan tilwe'n yi ntaxk chinquim,” stzun Israel bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Itzun bantz cwe'n nintzun e' ban Israel tbe' tu cyakil yi najal i' tuml yi be'ch cyetz tan chibene'n Egipto. Yi cyopone'n Beerseba, nintzun toy i' jun xtx'ixwatz tetz Kataj Ryos, yi Ryosil yi k'ajtzun taj. ");
INSERT INTO aguBl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Te yi jun ak'bala'tz jilone'n tzun Ryos tetz Israel tc'u'l jun wutzicy' tane'n. Itzun taltz tetz: —¡Jacow! ¡Jacow! —Je ine'j Ta', stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","—I ina'tz in Ryos, yi Ryosil yi k'ajtzun ataj. Qui bin cxob tan abene'n Egipto, na cho'n chijepon impuc'sal e' axonl tetz jun chin wutzile'n nación. ");
INSERT INTO aguBl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Chinxomok tzawe'j nin jun cu'n yol cheltu'l incy'al yi e' axonl. Ej nin ncha'tz yil cẍquim tz'ocopon Ẍep, yi acy'ajl, tan jople'n cu'n awutz, stzun Ryos bantz tetz Jacow. ");
INSERT INTO aguBl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Itzun yi nsken jilon Ryos tetz Jacow, icy'e'n nin e' bantz. Nintzun e' oc yi e' cy'ajl tan tocse'n yi wutzile'n chitaj tul jun scyeri care't yi ntak' faraón scyetz. Ncha'tz e' ban tu quixkel scyuch' chinitxa'. ");
INSERT INTO aguBl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ej nin ncha'tz e' ben quicy'al yi e' cyawun tu cyakil chime'bi'l yi nsken jal cyak'un Canaán. Icy'e'n nintzun e' ban Jacow tan cyopone'n Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Cyakil yi e' cy'ajl Jacow scyuch' yi e' mamaj e' xomnin te'j. ");
INSERT INTO aguBl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Je chibi'e'j yi e' xonl Jacow yi e' opon Egipto: Rubén, yi bajx cy'ajol. ");
INSERT INTO aguBl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ma yi e' cy'ajl Rubén i'tz: Hanoc, Falú, Hezrón tu Carmi. ");
INSERT INTO aguBl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ma yi e' tetz Simeón: Jemuel, Jamín, Ohad, Jaquín, Zohar tu Saúl, yi tal jun xna'n aj Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ma yi e' tetz Leví: Gersón, Coat tu Merari. ");
INSERT INTO aguBl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ma yi e' tetz Judá: Er, Onán, Sela, Fares tu yi yaj Zara. (Yi Er tu Onán, nsken chiquim Canaán.) Yi e' cy'ajl Fares i'tz: Hezrón tu Hamul. ");
INSERT INTO aguBl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ma yi e' tetz Isacar: Tola, Fúa, Job tu Simrón. ");
INSERT INTO aguBl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ma yi e' tetz Zabulón: Sered, Elón tu Jahleel. ");
INSERT INTO aguBl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Cyakil yi e'chk bi'aja'tz e' cu'n tal tu mamaj Lea. Cho'n jale'n yi e' tal Lea-a'tz tu Jacow yi nicy' yi ate' tzaj le luwar Padan-aram. Ncha'tz at jun xun yi tal i' yi na bi'aj Dina. Yi tajlal cyakil yi e' tal tu mamaj Lea jepon te junak oxlaj chixone'n, yaj tu xna'n. ");
INSERT INTO aguBl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ma yi e' cy'ajl Gad yi tal Zilpa i'tz: Zifión, Hagui, Ezbón, Suni, Eri, Arodi tu Areli. ");
INSERT INTO aguBl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ma yi e' cy'ajl Aser i'tz: Imna, Isúa, Isúi, Bería tuml Sera yi cyanub. Itzun yi e' cy'ajl Bería yi e' mamaj Aser i'tz: Haber tu Malquiel. ");
INSERT INTO aguBl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Cyakil yi e'chk bi'aja'tz e' cu'n tal tu mamaj Zilpa tu Jacow. Yi Zilpa'a'tz i'tz yi esclaw yi toynak wutzile'n Labán tetz Lea yi me'l, nin yi tajlal cyakil yi e' tal tu mamaj Zilpa e' jepon te waklaj chixone'n, yaj tu xna'n. ");
INSERT INTO aguBl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ma yi e' tal Raquel yi txkel Jacow i'tz: Ẍep tu Benjamín. ");
INSERT INTO aguBl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Itzun yi e' cy'ajl tetz Ẍep yi jal tu Asenat yi me'l Potifera yi pale' le tnum On, i'tz Manasés tu Efraín. Cho'n quitz'e'n cye'tz Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Itzun yi e' cy'ajl tetz Benjamín i'tz: Bela, Bequer, Asbel, Gera, Naamán, Ehi, Ros, Mupim, Hupim tu Ard. ");
INSERT INTO aguBl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Cyakil yi e'chk bi'aja'tz e' cu'n tal tu mamaj Raquel tu Jacow, nin e' jepon te cyajlaj chixone'n, yaj tu xna'n. ");
INSERT INTO aguBl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ma yi jun cy'ajl Dan i'tz Husim. ");
INSERT INTO aguBl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ma yi e' cy'ajl Neftalí i'tz: Jahzeel, Guni, Jezer tu Silem. ");
INSERT INTO aguBl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Cyakil yi e'chk bi'aja'tz e' cu'n tal tu mamaj Bilha tu Jacow. Yi Bilha-a'tz i'tz yi esclaw yi toynak wutzile'n Labán tetz Raquel yi me'l. E' jepon juk chixone'n. ");
INSERT INTO aguBl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Cyakil yi e' xonl Jacow yi e' yaj yi e' opon Egipto e' jepon cyajlal te oxc'al tu kak chixone'n. Ma yi e' yi e' tlib Jacow qui e' oc tajlal yi oxc'al tu kaka'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ma yi cob cy'ajl Ẍep cho'n quitz'e'n cye'tz Egipto. Ja tzun jepon yi tajlal yi xonl Jacow yi e' opon Egipto tetz oxc'al tu lajuj chixone'n. ");
INSERT INTO aguBl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Itzun yi cyopone'n nakajil Egipto nintzun ben ẍchakol Jacow yi Judá tan talche'n stziblal tetz Ẍep, nin tan talche'n tetz tan saje'n i' tan chic'ulche'n yi taj le luwar Gosén. ");
INSERT INTO aguBl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yi tbital Ẍep yi nsken chu'l yi taj Gosén nintzun cawunintz scyetz yi e' ẍchakum tan cyoque'n tan wekle'n yi tetz xo'mbil tan bene'n tan chic'ulche'n yi e' taj. Yi topone'n tu taj nintzun bentz tan k'ale'n nin ok' cu'ntz. Nim tzun tiemp ban i'-tz tan o'kl. ");
INSERT INTO aguBl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Itzun tal yi taj tetz: —Ma jalu' yaj, ba'n chinquim na ja bin kil kib tzawuch' nin itz'iẍe't, stzun Israel bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Bene'n tzun tlol Ẍep scyetz e' stzicy scyuch' e' najal yi taj: —I bin jalu' nchimben wetz tan talche'n stziblal tetz faraón. Swale' cyen tetz yi ja chu'l yi e' wutzicy scyuch' e' inxonl yi najlche' Canaán. Ja chu'l tan chinajewe'n tzone'j Egipto. ");
INSERT INTO aguBl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ja ul cyakil chime'bi'l cya'n. Ej nin xomche' cyakil yi cyawun scye'j na yi cyetz cyak'un i'tz pstore'n cne'r tu wacẍ, chinch sbne' tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ma cyeru', kol jak faraón scyeru' mbi'tz cyak'unu', ba'n cyalu' tetz: ");
INSERT INTO aguBl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","“Yi ketz kak'un ta' i'tz pstore'n cneru', na ya'stzun cyak'un kamam kate' sajle'n tunintz,” che'chu' sban tetz. Ba'n cyalu' yi xtxolbile'j tetz, bantz chicyaje'n cyenu' tzone'j Gosén, na yi e' aj Egipto, xan ẍchiwutz kol chinaje' pstor cne'r ẍchixo'l. ");
INSERT INTO aguBl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Nintzun ben Ẍeptz tan talche'n stziblal tetz faraón. Nin taltz tetz: “Ja chu'l intaj scyuch' wutzicy yi najlche' Canaán. Ja wi't chu'l le ama'l Gosén. Cy'a'n len cyakil chime'bi'l cya'n. Ej nin xomche' cyawun scye'j,” stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Nintzun e' je' xtxa'ol o' scyeri e' stzicy tan tajskel faraón chiwutz. ");
INSERT INTO aguBl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ma yi cyopone'n nintzun oc faraón tan jakle'n scyetz: —¿Mbi jilwutz ak'unil na a'w ita'n? —Ta', yi ketz, yi o' ẍchakumu', o' len pstor cneru' chi chisajle'n e' kamam kate'. ");
INSERT INTO aguBl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Cha'stzun te ja ku'l tan kanajewe'n tzone'j, na qui'ct kawa' Canaán. Ej nin qui'ct mu'ẍt tal ch'im tetz chiwa' yi e' kawun. Cha'stzun te elk k'ajabu' ske'j nink tak'u' ama'l sketz tan kanajewe'n tul yi ama'l Gosén, che'ch e' bantz tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Bene'n tzun tlol faraón tetz Ẍep: —Ma jalu' Ẍep, ja bin chu'l yi ara taj scyuch' yi e' awutzicy tzawe'j. ");
INSERT INTO aguBl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ba'n bin chinaje' tul alchok luwaril cwent Egipto. Poro ba'n tzawak' ama'l scyetz tan chinajewe'n cyen le ama'l Gosén na i'tz yi luwar mas balaj tzone'j Egipto. Ej nin ko at cobox chixo'l yi chin list nin e', ba'n cho'c awa'n tan chiq'uicy'le'n yi e' wetz wawun, stzun faraón bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ncha'tz ben tcy'al Ẍep yi taj tan tajskel faraón wutz. Itzun yi cyocompone'n swutz nintzun k'ajlan Jacow tetz nin tak' banl tibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Jakol tzun faraón tetz Jacow. —¿Jatna' yobu' ta'? ");
INSERT INTO aguBl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","—Yi mero bintzij Ta', ja chinxon bene'n tzi'n wuxtx'otx' mas jun cient tu junaklajix yob. Poro qui nin mben xcon mas intiemp ẍchiwutz yi e' inmam inte'. Ej nin te yi cobox yoba'tz at balaj nin at ploj yi ja noj quen tzinwutz, stzun Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yi tlol Jacow yi xtxolbila'se'j nintzun e' jatx quib tu faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Inin tzun tulej Ẍeptz quib yi tal faraón tetz. Nintzun tak' yi balaj ama'l tetz taj scyuch' yi e' stzicy. Cho'n tzun chinajewe'n swutz yi ama'la'tz yi na bi'aj Ramsés. ");
INSERT INTO aguBl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ncha'tz toy Ẍep ixi'n triw tetz chiwa' yi wutzile'n taj, scyuch' yi e' stzicy, tu cyakil yi e' xonl i'. ");
INSERT INTO aguBl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Itzun bantz bene'n nintzun ban lo'on yi we'j. Nin cya'l nin na jale't triw. Wi'nin tzun wunak e' quimtz tan we'j Egipto. Ej nin ncha'tz nk'e'tz ntin Egipto, ma na ncha'tz Canaán. ");
INSERT INTO aguBl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ma yi triw yi nsken wi't chamxij tan Ẍep nintzun baj c'ayiltz. Itzun yi jamel yi triwa'tz cho'n tzun tk'ol Ẍep tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Itzun yi baje'n chipu'k yi e' aj Egipto tu yi e' aj Canaán, nintzun e' opontz tan talche'n tetz Ẍep. —Ta', elk k'ajabu' ske'j. Tak'u' kawa'. ¿Nxac ltak'u' ama'l tan kaquime'n tan we'j tan paj tu yi qui'ct ketz kapu'k tan lok'che'n mas triw? ");
INSERT INTO aguBl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","—Ba'n, stzun Ẍep. —Ko qui'c ipu'k cy'ajwok tzaj yi itawun. Tzintx'exe' tu triw. ");
INSERT INTO aguBl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Cyopone'n tzun e' aj Egipto tu Ẍep cy'a'n len yi cyawun cya'n. At e' cy'a'n chej cya'n, cy'a'n wacẍ cya'n, cy'a'n cne'r cya'n, cy'a'n buru' cya'n, tan xtx'exe'n tu triw. Nin tak' Ẍep ixi'n triw scyetz tetz yi jun yoba'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Itzun yi ticy'e'n yi jun yoba'tz nintzun e' opont junt tir swutz Ẍep tan cu'swutzil, nintzun cyaltz: —Ilu' kajcaw, quil kajal cu'n wikak' tan talche'n yi skachoje' yi triw, na qui'ct kapu'k. Ej nin ncha'tz qui'ct kawun tan katx'exul tu triw. Na ja wi't kak' cyakil kame'bi'l teru'. Qui'c junt takle'n lkak' tetz jamel yi triw, jalt yi o' tu yi katx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Cujk tanu' ta' tan kac'ayil kib teru' tu yi katx'otx', na jalta'tz at skuch'. Ej nin list o' tan koque'n tetz esclaw yi patrónu'. Ej nin ba'n kak'uj swutz yi katx'otx' cwent i'. Ntin nink tak'u' kasemiy tan koque'n tan ak'un, bantz qui tx'akxe'n yi katx'otx', che'ch tzun e' bantz tetz Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Nintzun cujij Ẍeptz. Nin lok' i' cyakil yi chitx'otx' yi e' aj Egipto. Nintzun octz tetz cwent faraón. Tan paj yi jun chin we'j yi ate' cu'nt, ja chic'ay yi e' aj Egipto cyakil yi chitx'otx' tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Itzun yi baje'n chic'ayil yi chitx'otx', nintzun e' octz chicyakil cu'n yi e' aj Egipto tetz esclaw faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Jalt chitx'otx' yi e' pale' qui lok' Ẍep, na na tak' faraón ixi'n triw scyetz tetz chiwa'. Cha'stzun te qui nchic'ay yi chitx'otx', na at cyetz chiwa'. ");
INSERT INTO aguBl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Itzun tal Ẍep scyetz cyakil wunak: —Yi axwok itetz tu yi itx'otx' ja cxo'c len cwent faraón. Ma jalu' or tzibene'n tan ak'un swutz yi itx'otx', nin cy'ajwoknin yi semiy triwe'j. ");
INSERT INTO aguBl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ej nin yil je' yi cosech tajwe'n tzitak'wok yi to'i'n part te yi cosech tetz faraón. Ma yi cyajt ya'stzun itetz. Ba'n xcon ita'n tetz iwa' nin tetz semiy tetz junt tiemp, stzun Ẍep bantz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","—Ilu' kajcaw, tyoẍtu' teru' ta', na chin balaj nin ilu' ske'j, na ja kaclax tanu' tk'ab we'j. Ma jalu' ba'n ko'c tetz esclaw faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ej nintzun cawun Ẍep tan telse'n yi jun leya'tz scyetz cyakil wunak cwent Egipto tan cyak'ol yi to'i'n part te yi cosech tetz faraón. Ej nin yi jun leya'tz at nintz jalu'. Poro yi e' pale' qui na cyak' cyetz, na qui nchic'ay chitx'otx' tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Itzun yi tele'n tiemp cyak'un yi e' xonl Israel le ama'l Goséna'tz puc'une'n nin e' bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Inti Jacow, a'tij juklaj yob le ama'la'tz. Cho'n stz'ake'n jun cient tu ca'wunak juk yob ta'n. ");
INSERT INTO aguBl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ma yi nachone'n i' yi nsken tijin, nin yi txant tan quime'n, nin cawun i' tan ẍchakle'n Ẍep. Itzun yi topone'n Ẍep nintzun tal tetz: —Ma jalu' Ẍep, na waj yil tzaban yi june'j, ak'oc tzaj ak'ab jak' incux, tetz jun techl yi cẍelepon cu'n te'j yi cawl yi swale' tzatz. ");
INSERT INTO aguBl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Je wajbile'j, yil chinquim: Qui na waj yil chin mukxij tzone'j Egipto na yi wajbil i'tz yil chinmukxij kale e' mukxnake't yi e' inmam inte'. Cha'stzun te na waj yil cẍben tan mukle'n inwankil kale e' mukxnake't cyetz. —Cuj ta', stzun Ẍep. —Tzimbne' yi teru' tajbilu'. ");
INSERT INTO aguBl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","—¿Jun cu'n pe' na awal Ẍep? —Jun cu'n ta', sak swutz Ryos yi nelepon cu'n te'j quib yi tajbilu', stzun Ẍep bantz. Yi tbital Israel yi yol Ẍep, nintzun aj coyloktz wi xtx'ach. ");
INSERT INTO aguBl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Itzun bantz yi tele'n tiemp, nintzun opon stziblal twi' Ẍep yi yabi'ẍ yi taj. Bene'n tzun Ẍeptz tan tilwe'n nin e' xom nin yi cob cy'ajl te'j, yi Manasés tu Efraín. ");
INSERT INTO aguBl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ma yi cyopone'n nintzun a'lchij tetz wutzile'n Jacow yi nsken chopon Ẍep tan tilwe'n. Yi tbital yi xtxolbile'j nintzun buch tibtz tan c'olewe'n wi tx'ach. ");
INSERT INTO aguBl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Itzun taltz tetz Ẍep: —Nicy' yi atin tzaj le ama'l yi na bi'aj Luz, cwent Canaán, ja ẍchaj tib Kataj Ryos tzinwutz, yi Kataj yi na xcye' te cyakil, nin ja tak' i' banl swibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Na nin tal swetz: “Ma jalu' Jacow, sjalok wi'nin acy'ajl wa'n. Nin yi e' acy'ajla'tz sjalok wi'nin chixonl sbne' opon tunintz. Nin yi aẍa'tz cxocopon tetz chimam cyen cobox nación. Nin swak'e' yi ama'le'j, yi Canaán, scyetz chixonlu' tetz ben k'ej ben sak'”, stzun Ryos bantz swetz. ");
INSERT INTO aguBl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ma jalu' Ẍep, yi cob atz acy'ajl yi nchitz'ij tzone'j Egipto yi ntaxk nu'l wetz, yi tal Efraín tu Manasés, ncha'tz e' wetz jalu' chi quitane'n Rubén tu Simeón. ");
INSERT INTO aguBl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Poro kol chijal mas atz acy'ajl, e' awetz sbne'. Ej nin tantu' yi quitz'un quitzicy quib ẍchibne' tu Efraín nin Manasés stz'ak'lok nin cyetz chi'herens. ");
INSERT INTO aguBl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Te yi waje'n tzaj Padan-aram, nin yi kule'n Canaán, cho'n tzun quime'n yi k'ajtzun atxu'. Mu'ẍt cuntu' tan kopone'n le tnum Efrata yi quime'n i'. Cho'n tzun mukxe'n cyentz wa'n, ta'ste'nintz tzi be', yi be'a'tz yi na ucu'l Efrata, yi jalu' na bi'aj Belén, stzun Israel bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ma yi bene'n tilol Israel chiwutz yi e' cy'ajl Ẍep, nintzun jaktz: —¿Na' scyetz e' yi cob yaje'j? ");
INSERT INTO aguBl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","—Ya'stzun yi cob incy'ajl yi ntak' Ryos swetz te yi atin tzone'j Egipto, stzun Ẍep bantz. —Yi ko ya'tz yi e' acy'ajl ba'n bin chiẍkanko'c tzaj tzinxlaj na swak'e' imbanl squibaj, stzun wutzile'n Israel bantz tetz Ẍep. ");
INSERT INTO aguBl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Qui nintzun a'w mas wutz Israel tan paj yi nsken tijin. Nintzun e' ben ẍkansal Ẍep yi cob cy'ajla'tz swutz wutzile'n taj. Toque'n tzun Israel tan chimoxe'n tzaj nin tan stz'uble'n xak chitzi'. ");
INSERT INTO aguBl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ncha'tz ben tloltz tetz Ẍep: —I bin jalu' Ẍep, Ryos nmak'on puntil sketz tan kilolt kib junt tir tzawuch', nin tan che' wajskel yi cob acy'ajle'j, stzun Israel. ");
INSERT INTO aguBl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tele'n tzaj tzun tcy'al Ẍep yi e' cy'ajl wi tkan yi taj, nintzun cu joklok i' swutz jalen cwe'n pone'n yi wutz plaj wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Itzun yi je'n txiclok nintzun ben tan ẍch'ine'n tzaj Efraín tan yi jalaj k'ab yi sbal ma Manasés tan yi jalajt k'ab yi max. Nintzun e' octz ta'n xlaj yi taj. Cho'n tzun cyaje'n cyen Efraín le max Israel, ma yi Manasés le sbal. ");
INSERT INTO aguBl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Poro yi je'n tk'ol Israel k'ab chiwi', cho'n tzun taje'n cy'en yi sbal twi' Efraín yi ca'p cy'ajol, ma yi max, cho'n taje'n nin twi' Manasés yi bajx cy'ajol. Pasyoni'n tzun ban yi k'ab i' chiwi'. ");
INSERT INTO aguBl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ya'stzun ban Israel tan tak'le'n banl tibaj Ẍep tu yi e' xonl sbne' opon tunintz. Nin te yi ate'n yi k'ab Israel ẍchiwi' yi e' cy'ajl Ẍepa'tz itzun taltz: “Yi chiRyosil intaj Isaac tu incy'e'x Abraham, nin yi ite'n nin wetz inRyosila'tz, yi q'uicy'lom wetz jetz yi witz'le'nix, ");
INSERT INTO aguBl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","tu yi ángel yi nchincolon tk'ab yi e'chk takle'n cachi', tak' tzaj I' yi banl squibaj yi cob xicye'j. Na tan e' quil sotz imbi' tu chibi' intaj Isaac tu Abraham. Nink jal wi'nin chinitxajil. Nink chipuc'un wi munt,” stzun Israel bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Poro yi tilol Ẍep yi xtxolbile'j qui nin cu swutz yi cho'n taje'n cy'en yi jalaj k'ab sbal twi' Efraín, nintzun bentz tan telse'n yi jalaj k'ab sbal yi taj twi' Efraín nin icy' tk'ol twi' Manasés. ");
INSERT INTO aguBl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Nintzun taltz: —¡Qui' ta', nk'era'tz ntuleju'! na je te'tz yi bajxnake'j. Tak'e'nu' yi jalaj k'abu' yi sbalu' twi' i'. ");
INSERT INTO aguBl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Qui nintzun cujij yi wutzile'n Jacow, nin taltz tetz: —Na el intxum tetz, nin ja wi't wil yi ncha'tz Manasés tz'ocopon tetz jun tnum, nin sjalok k'ej. Poro yi titz'un, sjalok mas k'ej swutz yi stzicy. Sjalok wi'nin nación tan tetz xonl. ");
INSERT INTO aguBl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Yi tk'ol Israel yi banl squibaj yi cob cy'ajl Ẍepa'tz nin xcon yi cobox yole'j ta'n: —Cyakil cu'n yi e' inxonl xconk yi ibi' cya'n tan tak'le'n chibanl squibaj chinitxa' nin scyale': “Nink sban Ryos tzawe'j chi ban scye'j Efraín tu Manasés,” stzun Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Tan yi xtxolbile'j oc Efraín tetz bajx tan Jacow. —Ma jalu' Ẍep, chinquimok wetz, poro Ryos stz'a'tok tzite'j nin xpakxokwok ta'n le chiluwar yi e' kamam kate'. ");
INSERT INTO aguBl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ja wak' mas ara herens ẍchiwutz yi e' awutzicy, na atz yi ama'l yi elnaktzaj incolpil ẍchik'ab yi e' amorreo yi koque'n tan oyintzi' scyuch'. Yi jun ama'la'tz i'tz yi Siquem, nin awetz sbne', stzun Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Itzun bantz, chicwe'n tzun molol Jacow yi e' cy'ajl nintzun octz tan talche'n scyetz yi mbi xom tzaj ẍchiwutz, nin ncha'tz ẍchiwutz yi e' chixonl. Je yol i'e'j: ");
INSERT INTO aguBl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Axwok jun c'oloj incy'ajl ẍkanwoko'c tzaj swe'j, na na waj yil tzitbitwok tzaj inyol, na in Israel, yi itaj. ");
INSERT INTO aguBl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","”Ma jalu' yi aẍ Rubén, aẍ bajx incy'ajl. Ja cẍitz'ij te yi inxiquil tzaj, te yi at tzaj inwalor. At klo' mas ak'ej tan cawu'n ẍchiwutz yi e' awitz'un. ");
INSERT INTO aguBl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Poro nk'era'tz sbne' jalu', na ni'cu'n aẍ tu jun tojkbil a' yi qui na makxij, na ja iwitbej itib tu yi xna'n yi ca'p wuxkel tane'n. Nin tan yi xtxolbile'j ja el ink'ej awa'n. ");
INSERT INTO aguBl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","”Ma axwok itetz Simeón tu Leví, junit itxumu'n na ntin na xcon ima'cl tan biyo'n. ");
INSERT INTO aguBl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Poro yi in wetz qui na chinxom te itxumu'n, qui na xom inwi' te itajtza'kl. Na tan tu' yi ẍchi'chbe'n ic'u'l ja chiquim wi'nin wunak ita'n nin tan sajach tu' ja cxo'cwok tan kuxle'n pakbil quikan balaj tor. ");
INSERT INTO aguBl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Chin juntlenin yi ẍchi'chbe'n ic'u'l banak, na ni'cu'n itajtza'kl chi jun smaron txuc. Cha'stzun te cxelepon xit tan inajewe'n ẍchixo'l yi e' mas itanum. ");
INSERT INTO aguBl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","”Ma aẍatz Judá, sjalok ak'ej, na cyakil yi e' awitz'un, scyuch' yi e' awutzicy scyak'e' ak'ej. Ẍchimejek tzawutz. Ej nin cyakil yi e' acontr chocopon tzak' awukan. ");
INSERT INTO aguBl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Na ni'cu'n aẍ sbne' chi tane'n jun ne'ẍ león yi na xcye' tan biyle'n nin tan bajse'n jun txuc tetz ẍchib. Ej nin yi na noj c'u'l, nintzun na juk'e' cu'ntz chi na ban jun wutzile'n león. Cya'l nin jun na nimsaj c'u'l tan xuxe'n. Ni'cu'n tzun aẍ sbne' chi tane'n yi jun ne'ẍ leóna'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Cha'stzun cya'l nin jun nink xcye' tan telse'n yi ca'wl yi at tak'ab, nka tan majle'n yi tx'amij yi na ẍchaj yi at ak'ej tan cawu'n. Scyajk cyen chik'ab yi axonl, nin at nintz chik'ab yil tz'ul tzaj yi mero taw yi jun tx'amija'tz. Nin chocopon cyakil jilwutz wunak jak' ca'wl i'. Tetz cu'n cyalma' ẍchibne' tane'n yi tetz ca'wl. ");
INSERT INTO aguBl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Tz'ocopon i' tan c'alche'n cyen yi tetz buru' te jun wi' uva yi mas balaj. Nin xconk ta'al uva ta'n tan xtx'ajle'n be'ch tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Chin yube'n nin sbne' yi bak' wutz, swutz yi balaj ta'al uva. Chin sak nin sbne' yi te' swutz yi sakal lech. ");
INSERT INTO aguBl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","”Ma aẍatz Zabulón, cẍnajank tzi mar kalel chicolwit quib e'chk barc tk'ab pak'bil mar. Ej nin yi mojomil yi ara luwar cho'n tz'opon jalen Sidón. ");
INSERT INTO aguBl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","”Ma aẍatz Isacar, ni'cu'n aẍ sbne' chi jun buru', yi chin chamnin tan teke'n ektz, yi na juk'lij le ujbil. ");
INSERT INTO aguBl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Na yil tzawil yi chumbalaj nin yi ara ama'l tetz ujbil, tzawak'e' awib tetz chi'esclaw yi e' wunak. Cẍocopon tzak' cyektz bantz acyaje'n cyen tul yi ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","”Ma aẍatz Dan, chin tz'aknak cu'n tzabne' tan chicawe'n yi e' atanum. ");
INSERT INTO aguBl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Cẍocopon chi tane'n jun lu'baj yi jutlij tzi be' yi na oc tan ẍchi'le'n ẍchu's quikan yi e' chej yi na chicy' cu'n. Cxcyek tan chitrimpe'n cu'n yi e' aj chejinl yi na chicy'aktz. ");
INSERT INTO aguBl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","”¡Siwl Ta', chin cole'wu'! ");
INSERT INTO aguBl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","”Ma aẍatz Gad, chocopon yi e' acontr tan abiyle'n klo', poro xcyek scye'j, nin cxomoknin tan chibiyle'n. ");
INSERT INTO aguBl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","”Ma aẍatz Aser sjalok wi'nin awa'. Sjalok balaj cumir tzawuch' chi tane'n cumir jun rey. ");
INSERT INTO aguBl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","”Ma aẍatz Neftalí, ni'cu'n tzabne' chi jun masat yi chin yube'n nin yi nk'e'tz pres wutz, nin yi na talaj balaj tal. ");
INSERT INTO aguBl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","”Ma aẍ Ẍep, cẍwutzink chi na ban jun wi' tze' yi cho'n at stzi a' yi ba'n na ch'uy nin tz'icy'pon cu'n yi k'ab tibaj tapij. ");
INSERT INTO aguBl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Chocopon yi e' aj flechinl tan ac'oxle'n tan yi ẍchi'chbe'n chic'u'l. Ej nin cha'tz cuntunin e' ẍchibne' tan axuxe'n. ");
INSERT INTO aguBl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Poro chin chamnin tzabne' tan xconse'n yi arco. Quinin lk'e'xij ak'ab tan c'oxle'n yi e'chk flech. Na yi wetz inRyosil stz'a'tok tzawe'j, yi Ryos yi wi'nin ẍchamil, yi Pstor wetz tu colol wetz, yi in Israel. ");
INSERT INTO aguBl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Quil cẍk'e'xij na tz'ocopon yi kaRyosil tan awuch'eye'n, yi kaRyosil yi na xcye' te cyakil. I' tz'ak'on yi banl tzawibaj. I' tz'ak'on yi a'bal yi cho'n na saj tcya'j tu yi a' yi cho'n na saj jak' tx'otx'. Ẍchipuc'unk yi ara xonl na stk'e' i' banl squibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ma jalu' bin Ẍep ja wak' mas ara banl swutz yi wetz yi ncyak' k'ajtzun intaj. Ej nin quil tzaj abanl jalen yil sotz yi e'chk wi'wtz tu ju'wtz. Na yi aẍatz, txa'ijquiẍt tan jale'n mas ara banl tu ara k'ej ẍchiwutz yi e' awutzicy. ");
INSERT INTO aguBl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","”Ma aẍatz Benjamín, cẍocopon chi tane'n jun xo'j yi chin xo'wbil nin tan biyo'n. Cẍocopon chi tane'n jun xo'j yi sk'ejl tu lak'bal na oc tan biyo'n nin tan bajse'n cyakil yi na cambaj,” stzun Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Cyakil yi e'chk bi'aja'tze'j ya'stzun yi coblaj cy'ajl Israel yi e' octz tetz xe' yi coblaj bu'j xonl Israel. Ej nin ya'stzun tulej yi taj yi tk'ol yi banl squibaj. ");
INSERT INTO aguBl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ncha'tz tal Jacow scyetz yi e' cy'ajl: “Txant tan inquime'n, nin na waj yi cxbenwok tan inmukle'n le picy kale ocnake' quent yi e' inmam inte' tentz. Yi jun picya'tz cho'n at tul xtx'otx'be'n yi yaj Efrón jun scyeri e' xonl Het. ");
INSERT INTO aguBl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","32","Yi jun picya'tz yi Macpela bi', cho'n at swutz len Mamre jalen Canaán. Na yi jun picya'tz k'ajtzun incy'e'x Abraham lok'ol cyen. Cho'n lok'ol tetz Efrón yi aj Het tan xcone'n tetz chimukbil najal i'. Cho'n e' mukxe'n Abraham tu Sara. Ncha'tz ban yi cy'ajl i', yi Isaac tu yi tetz txkel yi Rebeca. Ej nin ncha'tz cho'n cyaje'n quen inmukul k'ajtzun wuxkel yi Lea,” stzun Jacow bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yi baje'n tlol Jacow yi xtxolbila'se'j scyetz yi e' cy'ajl nintzun el ẍchich'bal tibtz wi xtx'ach, nin quime'n nin bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yi tilol Ẍep yi quime'n yi taj nintzun bentz tan k'ale'n yi wankil nin tan stz'uble'n yi xak stzi'. Wi'nin tzun tok'e'n i'. ");
INSERT INTO aguBl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Cawune'n nintzun scyetz yi e' ajtz'ac tan cyoque'n tan xtx'ajle'n yi wankil yi taj, nin tan cu'se'n tul balsamo. Ya'stzun cyulejtz tan qui k'aye'n chan. ");
INSERT INTO aguBl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ca'wunak tzun k'ej e' bantz tan tocse'n balsamo te'j, na ya'stzun tiemp yi na taj tan cu'se'n wankil jun yi na quim. Tan yi bis yi quime'n Israel qui e' ak'uj yi e' aj Egipto oxc'al tu lajuj k'ej. ");
INSERT INTO aguBl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Itzun yi je'mpon yi oxc'al tu lajuj k'ej bisa'tz nintzun jilon Ẍeptz scyetz yi e' yi najlche' te'j faraón, itzun taltz: —Yi ko ja jal imbalajil ẍchiwutzu', na tzun klo' waj yil chibanu' pawor tan talche'n tetz faraón yi xtxolbile'j: ");
INSERT INTO aguBl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Ta' je yol Ẍepe'j: Te yi itz' tzaj yi k'ajtzun intaj, nin yi txant tan quime'n, nintzun jak i' swetz tan imbene'n tan mukle'n tc'u'l yi nich yi bnixnak cyen ta'n. Poro yi jun nicha'tz cho'n at tc'u'l jun picy jalen tzi'n Canaán. Cha'stzun te nink ltak'u' ama'l swetz tan imbene'n tan mukle'n yi wankil yi k'ajtzun intaj. Ej nin yil mukx cyen wa'n, chimpakxok junt tir tzone'j,” che'chu' sban cyen, stzun Ẍep scyetz yi e' yi najlche'-tz te'j faraón. Ej nin ya'tz nintzun cyulejtz. ");
INSERT INTO aguBl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Yi tbital faraón nintzun taltz: —Ba'n, ba'n cẍben tan mukle'n yi wankil tal k'ajtzun ataj, quib yi tal i' tzawetz, stzun faraón bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yi tbital Ẍep yi yol faraón nintzun ben tan mukle'n yi wankil yi k'ajtzun taj. Ej nin e' xomnin cyakil cu'n yi e' ẍchakum faraón yi at chik'ej. ");
INSERT INTO aguBl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ncha'tz e' ben cyakil yi najal Jacow, nin cyakil yi najal Ẍep. Ncha'tz cyakil yi e' stzicy. Ntin e' nitxa' tu yi cyawun, e' cyaj cyen le ama'l Gosén. ");
INSERT INTO aguBl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Wi'nin tzun wunak e' xomnin te'j Ẍep tan mukle'n yi taj. At e' cy'a'n care't cya'n, nin at e' yi cho'n ate' te'j chej. ");
INSERT INTO aguBl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Yi cyopone'n le ama'l yi na bi'aj Goren-ha-atad, yi cho'n at swutz len a' Jordán, cho'n tzun e' cyaje'n cyen juk k'ejtz tan bis o'kl, le jun ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Itzun yi quilol yi e' aj Canaán yi najlche' le ama'la'tz, yi bis o'kl yi ate' cu'nt yi e' aj Egipto nintzun cyaltz: “At jun chin muku'n yi chin bisbil nin chixo'l yi e' aj Egipto.” Cha'stzun te yi toque'n bi' yi jun ama'la'tz cya'n tetz Abel-mizraim. Yi jun ama'la'tz cho'n at swutz len yi a' Jordán. ");
INSERT INTO aguBl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ya'stzun cyulej yi e' cy'ajl Jacow tan mukle'n yi wankil chitaj. Ja chixom te yi tajbil Jacow quib yi talnak scyetz, ");
INSERT INTO aguBl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","na nin e' ben tan mukle'n yi wankil yi tal k'ajtzun chitaj jalen Canaán. Cho'n tzun toque'n cyen cya'n le picy yi at le ama'l Macpela, yi ama'l yi lok'nak Abraham tetz Efrón yi aj Het, na ya'tz nin xac yi lok'ol Abraham. Na ja lok' i tetz chimukbil cyakil cu'n e' najal. Yi jun ama'la'tz cho'n at swutzlen Mamre. ");
INSERT INTO aguBl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Itzun yi wi't mukxe'n yi wankil Jacow nin e' pakxij Ẍeptz tu yi e' stzicy. Xomche' cyakil yi e' ẍchakum faraón yi at chik'ej scye'j. ");
INSERT INTO aguBl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Itzun yi quilol yi e' stzicy Ẍep yi nsken quim yi chitaj nintzun cyaltz: “Ma jalu', qui'ct yi kataj at skaxo'l. Quicunin batz na chi'ch c'u'l Ẍep ske'j tan yi e'chk takle'n cachi' yi banako' te'j, yi saje'n kac'ayil,” che'ch tzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Nintzun ben mantar tan talche'n tetz Ẍep: “Yi ntaxk quim kataj, nin cawun cyen sketz tan kalol yi yole'j teru'. Je yol i'e'j: ");
INSERT INTO aguBl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Ma jalu' Ẍep, nink tzaban pawor tan cuyle'n chipaj yi e' awutzicy yi chin cachi' nin banake' tzawe'j,’ chij i' ban. Cha'stzun te na katzan tan jakle'n cuybil kapaj swutzu' yi o' yi ato' jak' ca'wl yi Ryosil yi kataj.” Wi'nin tzun tok'e'n Ẍeptz te yi na tzan yi chakum tan xtxole'n cyen yi xtxolbila's tetz. ");
INSERT INTO aguBl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Cyopone'n tzun yi e' mero tetz stzicy tan jakle'n cuybil chipaj tetz. Ej nintzun e' baj cu' jokloktz jalen cu'n cwe'n pone'n yi wutz chiplaj wuxtx'otx'. Itzun cyaltz: —Je o'e'j, ba'n ko'c tetz esclawu'. ");
INSERT INTO aguBl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","—Quil cxobwok, stzun Ẍep ban scyetz. —Na qui'c cuj yi nink no'c tetz Ryos tan ma'le'n itajtza'kl yi ko at ipaj nka qui'. ");
INSERT INTO aguBl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Bintzi lo' yi mero itajbil i'tz klo' tan imbiyle'n cu'n, poro Ryos ntx'ixpune'n yi xtxolbile'j tetz balaj tan chiclaxe'n wi'nin wunak. ");
INSERT INTO aguBl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Cha'stzun te quil cxobwok na swak'e' iwa', tuml chiwa' yi e' initxa', stzun Ẍep bantz. Chin putzpujnin yol nxcon ta'n tan chimayse'n yi e' stzicy. ");
INSERT INTO aguBl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Cho'n tzun e' najewe'n Ẍep tu yi najal yi k'ajtzun taj le ama'l Egipto. Na tzun xon Ẍep tul jun cient tu lajuj yob te yi jun tiempa'tz. ");
INSERT INTO aguBl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Tajskej i' chiwutz chicy'ajl yi e' mamaj Efraín. Ncha'tz tajskej Ẍep chiwutz yi e' nitxajil yi mamaj i', yi Maquir yi cy'ajl Manasés. ");
INSERT INTO aguBl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Itzun yi nachone'n Ẍep te yi txant tan quime'n, nintzun taltz scyetz yi e' stzicy: “Yi in wetz txant tan inquime'n, poro Ryos tz'ocopon tan ich'eye'n, tan itelse'n le jun tnume'j. ");
INSERT INTO aguBl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ej nin je jun xtxolbile'j yi na waj yil tzibanwok. Yil tz'oc Ryos tan itelse'n tzone'j tan itopone'n junt tir le ama'l yi suki'nt ta'n tetz Abraham, Isaac tu Jacow, na klo' waj yi tzicy'ajwok nin inwankil tzite'j,” stzun Ẍep bantz. ");
INSERT INTO aguBl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Jun cient tu lajuj yob Ẍep yi quime'n. Cho'n tzun quime'ntz Egipto, nintzun oc tz'ac'bil te yi wankil tan qui k'aye'n chan. Nin cu'-tz cyak'un tc'u'l jun cajón.");
INSERT INTO aguBl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Je chibi' cyakil yi e' xonl Israel tuml chinajal yi xomche' te'j Jacow yi cyopone'n Egipto: ");
INSERT INTO aguBl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, Simeón, Leví, Judá, ");
INSERT INTO aguBl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulón, Benjamín, ");
INSERT INTO aguBl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftalí, Gad tu Aser. ");
INSERT INTO aguBl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Oxc'al tu lajuj chixone'n yi e' xonl Jacow, tuml Ẍep yi ate' nintz Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Itzun bantz yi xone'n tiemp e' quime'n tzun cyakil yi jun wek wunaka'tz tuml Ẍep tu cyakil yi e' stzicy. ");
INSERT INTO aguBl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Puc'une'n nin tzun e' ban mas yi e' xonl Israel na nin jal wi'nin chinitxajiltz. Nintzun e' ben lo'ontz bene'n tzi'n Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ej itzun bantz yi xone'n tiemp nintzun oc cyen junt rey tan chicawe'n yi e' aj Egipto. Poro qui nin tajskej i' wutz k'ajtzun Ẍep, cha'stzun te talol i' scyetz cyakil yi tanum yi xtxolbile'j: ");
INSERT INTO aguBl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“¡Bitwok tzaj, wi'nin ẍch'uye'n yi cyajlal yi e' xonl Israel! Ej nin at mas chichamil skawutz ketz. ");
INSERT INTO aguBl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Cha'stzun te tajwe'n kajoye' puntil tan qui ẍch'uye'n mas cyajlal, na kol ko'c tan oyintzi' scyuch' yi e' kacontr quicunin batz xomok chiwi' scye'j nin chelepon ojk jak' kaca'wl.” ");
INSERT INTO aguBl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Cyoque'n tzun yi e' aj Egipto tan chibuchle'n yi e' xonl Israel, na nin e' bixe' cobox ajcaw squibaj tan cyak'ol e'chk jilwutz ak'un scyetz yi chin q'uixbel nin, chi tane'n je'se'n yi cob tnum yi na bi'aj Pitón tu Ramsés. Yi cob tnuma'tz xconak tan yi faraón tetz cu'lbil me'bi'l i'. ");
INSERT INTO aguBl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Poro yi toque'n chibuchle'n yi e' xonl Israel mas tcunin tzun chipuc'une'n. Cha'stzun te wi'nin e' xobe'n yi e' aj Egipto scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Mas tcu'n tzun cyoque'n tan chibuchle'n tan quiw ak'un, ");
INSERT INTO aguBl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","na nin e' cawun tan cyoque'n tan banle'n xk'ol tetz xan, nin tan ak'un wi cojbil. Chin buchij nin tzun e' ban yi e' xonl Israel tan cyakil yi ak'un yi ak'lij scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ma yi rey nintzun e' ẍchak yi Sifra tu Fúa yi cob xna'n, yi e' xe'iyum yi ate' ẍchixo'l yi e' hebrey. Itzun taltz scyetz: ");
INSERT INTO aguBl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","—Yil cxben wok tan quiwle'n yi xna'n yi na ul yos scyuch', ilwok yi e' ni' yi na chitz'ij. Ko e' xicy, biywok cu'n, na qui na waj yil chitz'ij. Poro ko e' tal xun ba'n tzitak' wok ama'l tan quitz'e'n, stzun yi rey scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Poro quinin e' xom yi e' xe'iyum te yi tajtza'kl yi rey, na nin cyek ẍchi' Ryos. Cha'stzun te cyak'ol ama'l tan quitz'e'n yi e' ni' yi xicy. ");
INSERT INTO aguBl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Yi tbital yi rey yi ya'stzun na chiban yi e' xna'na'tz, nintzun ben mantar tan chichakle'n. Yi cyopone'n nintzun taltz: —¿Mbi tzuntz yi mitak'wok ama'l scyetz yi e' ni' xicy tan quitz'e'n? ");
INSERT INTO aguBl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","—Yi mero bintzi ta', i'tz, yi e' xna'n, yi o' hebrey, apart e' ẍchiwutz yi e' aj Egipto, na yi cyetz chin chamnin e', na jalcu'n na ul yos scyuch'. Cha'stzun te taxknin kopon ketz tan quiwle'n yi na ul yos scyuch', che'ch tzun yi e' xe'iyum bantz tetz rey. ");
INSERT INTO aguBl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Tan yi xtxolbile'j ch'uye'n nin ban mas cyajlal yi e' xonl Israel. Nin jal mas chichamil tan paj yi nim chixone'n. Ma yi e' xe'iyum, tantu' yi ncyek ẍchi' Ryos, ja tak' Ryos banl squibaj. Cha'stzun te ja jal wi'nin cyetz cyal tu cyetz chimamaj. ");
INSERT INTO aguBl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Poro yi rey nin el junt ley ta'n ẍchiwi' cyakil yi e' tanum. Itzun taltz: “Na waj yil chiben jo'li'n wi tzanla' cyakil yi e' xicy yi na chitz'ij ẍchixo'l yi e' hebrey. Ma ko e' xun, quil tzibiy wok cu'n,” stzun yi rey bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Itzun bantz, cyok'bel tzun quib jun yaj tu jun xna'n. E' cu'n xonl Leví. ");
INSERT INTO aguBl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Yi cyok'bel quib nintzun oc lac'puj jun ni' te yi xna'n. Yi tule'n yos tuch', xicy tzun ban yi ni'. Yi tilol yi xna'n yi chin yube'n nin yi ni' nintzun octz tan tewe'n tetz ox xaw. ");
INSERT INTO aguBl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Poro quinin xcye' tan tewe'n mas tiemp. Yi je'mpone'n yi ox xawa'tz, nintzun oct junt tir tan joyle'n puntil tan claxe'n yi ni'. Joyol tzun i' puntil tan tewe'n junt tir. Toque'n tzuntz tan banle'n jun mo'tx, nin baj nojsal xe'ak yi mo'txa'tz tan wix tu ẍpupu' tan qui tocompone'n a' tc'u'l. Yi wi't bnixe'n nintzun cu' coybal yi ni' tul. Ej nintzun bentz tan tak'le'n xo'l aj stzi' yi tzanla' Nilo. ");
INSERT INTO aguBl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ncha'tz ben ẍchakol jun tanub yi ni' tan xk'uke'n, nin tan q'uicy'le'n. ");
INSERT INTO aguBl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Itzun bantz nintzun ben yi me'l yi faraón tan jichi'n stzi' yi jun tzanla'a'tz. Yi chicwe'n pone'n stzi' yi a'a'tz nintzun ben tilol jun mo'tx yi at xo'l aj stzi' a'. Yi bene'n tilol nintzun ben ẍchakol jun scyeri yi e' mos yi xomche'tz te'j tan ticy'le'n tzaj yi jun mo'txa'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Yi tule'n swutz, nintzun tbit yi na ok' jun tal ni' tc'u'l. Lajke'l nintzun bene'ntz tan jakle'n yi mo'tx. Ma yi cwe'n tilol nintzun ok' cu'n c'u'ltz te'j. Itzun taltz: —¡Ah! yi jun tal ni'e'j i'tz tal jun hebrey, stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Yi tilol yi stzicy yi ni' yi nsken opon ticy'le'n yi titz'un tk'ab yi me'l faraón, lajke'l nin tzun bene'ntz tan yol tetz. Itzun taltz: —Ilu' jun c'oloj me'l rey, ¿qui pe' na taju' yil chimben tan joyle'n jun xna'n yi at ta'al tim tan tk'ol tetz yi ni' nin tan ẍch'uyse'n? stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","—Ba'n, ba'n cẍben tan joyle'n, stzun me'l faraón bantz. Lajke'l nintzun bene'n yi xun tan ẍchakle'n yi xtxu' yi ni'. ");
INSERT INTO aguBl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Yi topone'n yi xtxu', nintzun tal yi me'l faraón tetz: —Cy'aj nin yi ni'e'j. Nin ch'uysaj, list wutane'n tan ẍchojle'n atiemp, stzun i' bantz. Bene'n tzun tcy'al yi xna'n yi tetz tal nintzun octz tan q'uicy'le'n. ");
INSERT INTO aguBl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Yi ẍch'uye'n yi ni' nintzun ben yi xna'n tan tak'le'n tetz me'l faraón. Nintzun oc yi ni'a'tz chi k'ajbil tal me'l faraón. Ej nin oc tk'ol yi me'l faraón yi bi' yi ni' tetz Moisés, na nin tal: “Cho'n je'n tzaj wa'n stzi' a'.” ");
INSERT INTO aguBl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Itzun bantz yi yajine'n Moisés, nintzun bentz tan xo'n ẍchixo'l yi tetz tanum yi e' xonl Israel yi ate' tan ak'un wi cojbil. Yi topone'n nintzun ok' c'u'ltz scye'j. Na chin q'uixbel nin quitane'n tan ak'un. Ncha'tz til yi at jun aj Egipto yi na tzan tan biyle'n jun scyeri xonl i', jun hebrey bina'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Yi bene'n tilol nintzun bentz tan colche'n. Yi topone'n nin baj xmayil xlaj yi ko cya'l attz naka'j. Ma yi tilol yi cya'l at nintzun bentz tan biyle'n cu'n yi jun aj Egipto. Yi cwe'n biyol, ta'ste'n nin tzun cwe't mukul tul samlicy'. ");
INSERT INTO aguBl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ej itzun le junt ekloktz nin el junt tir tan xo'n. Nin te yi na xon nin ben tilol cob hebrey yi na chibiy quib squibil quib. Yi tilol yi xtxolbile'j nintzun ben jakol tetz yi jun yi na tzan tan biyle'n yi tuch'. Itzun taltz: —¿Nxac na cẍtzan tan biyle'n awuch'? na itanum itib, stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Saje'n tzun stza'wel yi jun hebreya'tz: —Ma atz ¿na' ncẍo'csan tetz ajcaw skaxo'l? ¿Na pe' cẍtzan tan xtxumle'n tan imbiyle'n cu'n chi aban te yi aj Egipto ewt? Itzun yi tbital Moisés yi xtxolbile'j nintzun saj jun chin xo'w te'j, na nin el xtxum tetz yi nsken quibit wunak yi nsken quim jun aj Egipto ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ma yi tbital faraón yi nsken wi't quim jun aj Egipto tan Moisés, nintzun el jun ort ta'n tan stz'amle'n nin tan cwe'n klo' biyij. Poro nintzun tbit Moisés yi na tzan joyle'n i'. Lajke'l nintzun tele'n ojktz. Cho'n tzun topone'ntz le ama'l yi na bi'aj Madián. Yi topone'n Madián nin c'ole' cu'ntz nakajil jun julil a'. ");
INSERT INTO aguBl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ej nin te yi c'olchij Moisés naka'jil yi jun julil a'a'tz nintzun e' opon yi juk me'l Reuel tan je'se'n tzaj a' tetz quic'a' yi cyawun. Yi jun Reuela'tz i' yi pale' tetz Madián. ");
INSERT INTO aguBl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Poro te yi ate' yi e' xuna'tz te yi jun julil a'a'tz nin e' baj opon coboxt pstor tan tak'le'n quic'a' yi cyetz cyawun. Yi cyopone'n nin e' octz tan chilaje'n len klo' yi juk xuna'tz. Poro yi tilol Moisés nintzun octz tan chicolche'n. Ncha'tz oc i' tan je'se'n tzaj a' tetz quic'a' e' tal cyawun. ");
INSERT INTO aguBl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Yi chipakxe'n yi e' xuna'tz xe chinajbil nin el yab yi chitajtz scye'j, na or cyopone'n. Nintzun tal scyetz: —¿Mbi tzuntz jalcunin nxpakxij wok? stzun i' bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Bene'n tzun cyalol tetz chitaj yi mbi bajij scye'j. Itzun cyaltz: —Ta', at jun aj Egipto mmo'c tan kacolche'n ẍchik'ab yi e' mas pstor. Ej nin ja je' tzaj tcy'al i' a' tetz quic'a' yi kawun, che'ch tzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","—¿Na't tzun atit yi jun yaja'tz? ¿Mbi tzuntz ncyaj cyen itilol wok? ¡Or tzibene'n lajke'l tan joyle'n i' nin chakwok tzaj tan wane'n skuch'! stzun Reuel bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ya'stzun bantz yi topone'n Moisés tan najewe'n xe ca'l Reuel. Ej nin yi xone'n tiemp ja tak' Reuel yi jun me'l yi na bi'aj Séfora tetz txkel i'. ");
INSERT INTO aguBl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Yi cyok'bel quib Séfora tu Moisés nin jal jun chinitxa'. Gersón tzun ban bi'tz tan Moisés na nin taltz: “In jun awer nak tul jun ama'le'j yi qui wajske'n.” ");
INSERT INTO aguBl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Itzun bantz yi xone'n yi tiemp nin quim yi rey tetz Egipto. Poro yi e' xonl Israel iẍnin buchij che' cyak'un yi e' aj Egipto. Poro tbit Ryos yi chitzi' chikul, na chin q'uixc'uj nin ate' cu'nt. ");
INSERT INTO aguBl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Tbit tzun Ryos yi cyo'kl, nin ul tx'akx tc'u'l yi trat yi bnixnak ẍchixo'l tu Abraham, Isaac nin Jacow. ");
INSERT INTO aguBl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ja che' til Ryos yi ẍe'n quitane'n, nin ja el to'kl c'u'l scye'j. ");
INSERT INTO aguBl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Itzun bantz cho'n at pon Moisés tan pstore'n yi tawun Jetro yi ji' i' le ama'l tz'inunin tu', naka'jil yi wutz tetz Ryos, yi na bi'aj Horeb. Yi Jetro, i' yi chipale'il yi e' aj Madián. ");
INSERT INTO aguBl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Cho'n tzun ẍchajol tib yi ángel tetz Kataj Jehová swutz i' le ama'la'tz. Cho'n ẍchajol tibtz tul jun wi' xtxoybchej yi na tzan k'a'kl. Poro qui na tz'e'. Yi bene'n tilol Moisés yi na tzan k'a'kl yi jun xtxoybcheja'tz, ");
INSERT INTO aguBl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","toque'n tzun i'-tz tan xtxumle'n yi mbi tzuntz yi qui na tz'e'. Nin oc ẍkansal tibtz tan xmaye'n yi mbi tzuntz qui na tz'e'. ");
INSERT INTO aguBl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Itzun yi tilol Kataj Ryos yi topone'n ẍkansal tib Moisés tan xmaye'n, nintzun jilon tzaj tetz tul yi jun wi' xtxoybcheja'tz. Itzun taltz: —¡Moisés, Moisés! —¿Mbi' ta'? Je ine'j, stzun Moisés ban nintz. ");
INSERT INTO aguBl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nintzun tal Ryos tetz: —Moisés, quil cẍkano'c tzaj mas, nin cy'ajwe' len yi axajab, na chin xan nin yi ama'l kale txicl quiẍe't. ");
INSERT INTO aguBl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Na i ina'tz yi chiRyosil yi e' amam ate', yi k'ajtzun Abraham tu Isaac nin Jacow, stzun Ryos bantz tetz Moisés. Tan paj yi xo'wl yi at cu'nt cwe'n tzun tewal Moisés yi wutz, na nin xobtz tan xmaye'n wutz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Poro nintzun tal Ryos tetz: —Ma jalu' Moisés, na wil yi q'uixc'uj yi ate' cu'nt yi e' intanum yi ate' Egipto jak' ca'wl yi faraón. Ncha'tz ja opon yi cyo'kl tzinwutz, na chin buchij nin quitane'n cyak'un yi ajcaw yi na chicawun squibaj. ");
INSERT INTO aguBl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Cha'stzun te ja nu'l tan chicolpe'n chik'ab yi e' aj Egipto. Chelu'l tzun incy'al le jun ama'la'tz. Nin chopon wa'n le jun balaj ama'l kale atite't balaj cojbil, jun ama'l kale atit wi'nin lech tu ca'bil wunak txuc. Yi jun ama'la'tz i'tz kale najlche't yi e' aj Canaán, e' hitita, scyuch' yi e' amorreo, e' ferezeo, e' heveo nin e' jebuseo. ");
INSERT INTO aguBl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ma jalu' bin Moisés, ja wit yi cyo'kl yi atanum, yi e' xonl Israel. Nin ja wil yi chin q'uixc'uj nin quitane'n cyak'un yi e' aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Cha'stzun te na waj yi ẍcu' tbe' ninin jalcu'n, na na waj cẍben tan yol swutz yi faraón tan cyelsene'l tzaj yi intanum Israel yi ate' Egipto, stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Nintzun tal Moisés tetz Ryos: —Ta', ¿mbi eka'n wa'n tan woque'n tetz chibajxom yi e' intanum, nin tan yol tetz faraón, tan cyelsene'l tzaj jak' chica'wl yi e' aj Egipto? Na yi mero bintzi yi in wetz quil chinxcye' te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Poro nin tal Ryos tetz: —Moisés, chinxomok tzawe'j. Ej nin je jun techle'j yi in inchakon nin aẍ: Yil che'l tzaj yi intanum awa'n, cxu'l wok icyakil cu'n tan inc'u'laje'n swutz yi wutze'j, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","—Poro Ta', kol chimben tan yol scyetz yi e' bajxom tetz intanum, nin kol wal scyetz yi ja chinsaj chakij tan Kataj Ryos yi chiRyosil yi e' kamam kate' ej nin kol chijak swetz, yi mbi' bi'u', ¿mbi tzun wal nin wetz scyetz? stzun Moisés bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","—Ma jalu', I INA'TZ YI IN. Ej nin ba'n tzawal scyetz: Yi Ryos yi na bi'aj I INA'TZ, i' nchinchakon tzaj. ");
INSERT INTO aguBl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ncha'tz tal Ryos tetz Moisés: —Ba'n tzawal scyetz yi e' atanum yi e' xonl Israel: “Yi Kataj Jehová, yi chiRyosil yi e' kamam kate', yi Abraham tu Isaac nin Jacow, i' mma'lon swetz tan wule'n ẍchiwutzu',” cẍchij sban scyetz. Ya'stzun wetz imbi'. Ej nin ba'n xcon yi jun imbi'a'tz ita'n tan inna'wse'n tetz ben k'ej ben sak. ");
INSERT INTO aguBl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","”Ma jalu' Moisés quilo'k Egipto, nin molwe' yi e' bajxom scyetz yi e' xonl Israel. Ej nin alaj scyetz yi xtxolbile'j: ‘Yi Kataj Jehová yi chiRyosil yi e' kamam kate', yi Abraham tu Isaac nin Jacow, ja ẍchaj tib tzinwutz nin ja tal i' swetz: Ja wit, nin ja wil yi ẍe'n cunin itane'n wok cyak'un yi e' aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Cha'stzun te cxelpon wok liwr wa'n tk'ab yi q'uixc'uj, nin jak' chica'wl yi e' aj Egipto. Ej nin nxben wok wa'n le junt balaj ama'l yi at chik'ab yi e' cananeo scyuch' e' amorreo, e' hitita, e' ferezeo, e' heveo tu e' jebuseo. I'tz jun balaj ama'l kale atit balaj cojbil,’ cẍchij sban scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ej nin yil tzawal yi xtxolbile'j scyetz yi e' bajxom tetz Israel, scyocsaje' yi xtxolbila'se'j yi ja wi't wal tzatz. Ej nin yil cyocsaj ayol kalena'tz tzun cxben wok tan yol swutz yi rey tetz Egipto. Yil cxopon wok ba'n tzawal tetz: ‘Yi ketz kaRyosil yi o' hebrey ja jilon sketz le ama'l tz'inunin tu'. Cha'stzun te nink tak'u' ama'l sketz tan kabene'n tan toye'n katx'ixwatz swutz i'. Nink tak'u' ama'l sketz tetz ox k'ej, na ya'stzun yi tkanil yi kabe',’ cẍchij sban tetz yi rey. ");
INSERT INTO aguBl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Poro na el intxum tetz yi quil tak' yi rey ama'l tzitetz tan itele'n tzaj Egipto. Ntin kol tzimban puers te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Na je swuleje'j. Tzinchaje' yi wetz imporer tetz yi rey. Ẍchiquimok wi'nin aj Egipto wa'n. Nin tan yi cyakil yi mbi cu'n tzimbne' scye'j, kalena's tzun ltak' ama'l tzitetz tan itele'n tzaj. ");
INSERT INTO aguBl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Nk'e'tz ntina'tz ma na ncha'tz swak'e' yi imbanl tzitetz tan jale'n ibalajil ẍchiwutz yi e' aj Egipto. Na yil cxe'l wok tzaj, quil cxe'l tzaj tu', ma na tz'elu'l itcy'al wi'nin e'chk takle'n chik'ab yi e' aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Na cyakil yi ixna'nil ẍchijake' e'chk takle'n scyetz chiwisin, nka scyetz alchok xna'nil aj Egipto. Ẍchijake' balaj oro tu sakal, ncha'tz ẍchijake' balaj be'ch cyetz scyetz tan jale'n chime'bi'l. Tz'elepon tzun itcy'al cyakil chime'bi'l yi e' aj Egipto,” stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","—Poro Ta', jun cu'n yol quil cyocsaj intanum yi ja ẍchaj tibu' tzinwutz. Ej nin quil chiban tane'n inyol. Ma na scyale': “Qui', qui ẍchaj tib Kataj Ryos tzawutz.” ");
INSERT INTO aguBl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Poro nin tal Ryos tetz Moisés: —Moisés ¿mbi tz'amij awa'n le ak'ab? —I'tz intx'amij Ta', stzun Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","—Ma jalu' bin, c'oxcu'n wuxtx'otx', stzun Ryos tetz. Cwe'n tzun c'oxol Moisés yi xtx'amij wuxtx'otx'. Yi topone'n sanlok wuxtx'otx', oque'n nintzun bantz tetz lu'baj. Ej nin yi bene'n tilol Moisés, wi'nin tzun xobe'ntz tetz. Nin el ojk swutz. ");
INSERT INTO aguBl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Tlol tzun Kataj tetz: —¡Yaj! tz'ame'n yi je' yi lu'baj. Bene'n tzun Moisés tan stz'amle'n yi je' yi jun lu'baja'tz. Yi je'n stz'amol yi je' oque'n nintzun ban junt tir tetz xtx'amij. ");
INSERT INTO aguBl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","—Ma jalu' Moisés ba'n tzaban yi xtxolbile'j ẍchiwutz, scyocsaje' tzun yi ja inchaj wib tzawutz. Ej nin yi in wetz in Cyajcawil yi e' imam ite', yi k'ajtzun Abraham tu Isaac nin Jacow, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ncha'tz tal Ryos tetz Moisés: —Ak' quen ak'ab wutz awembl. Toque'n tzun tk'ol i' yi k'ab wutz yi tembl. Ma yi tele'n tzaj tcy'al, chin skoj nin ban tan jun jilwutz tx'a'c yi na bi'aj lepra. ");
INSERT INTO aguBl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Bene'n tzun tlol Ryos tetz Moisés: —Ak' quen junt tir yi ak'ab wutz awembl. Toque'n tzun tk'ol yi k'abtz wutz tembl. Ma yi tele'n tzaj tcy'al, qui'ct tzun yab yi k'ab bantz. Cho'n cunin ban cyen chi tane'n yi jalajt. ");
INSERT INTO aguBl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ncha'tz talt Ryos tetz Moisés: —Ko quil cyocsaj yi bajx techl yi minchaj tzatz, scyocsaje' yi ca'p. ");
INSERT INTO aguBl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Poro ko qui nin lcyocsaj tan yi cob techla'tz, ba'n tzaban yi xtxolbile'j: Ba'n tzacy'aje'n tzaj mu'ẍ a' te yi tzanla' yi attz naka'j, nin ba'n tzakoj nin wuxtx'otx'. Nin yil copon wuxtx'otx' chich' cu'n sbne', stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","—¡Siwl Ta'! Poro qui na a'w yol wa'n. Ej nin sak swutzu' Ta' yi ya'tz wutane'n sajle'n tunintz nk'e'tz ntin jalu', stzun Moisés bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Stza'wel tzun Kataj Ryos tetz: —¡Yaj! ¿Na' mbnon yi atzi'? ¿Nk'e'tz pe' in? ¿Nk'e'tz pe' in nchimbnon yi e' mem, scyuch' yi e' ẍcan nin yi e' moyi'ẍ tu yi e' yi ba'n chixmayin? ");
INSERT INTO aguBl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Cha'stzun te quilo'k te amantar, na chinxomok tzawe'j. Ej nin yil cẍjilon, swale' tzatz yi mbi tajwe'n tan awalol, stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Poro nintzun oc Moisés ch'inch'uj tan talche'n tetz Ryos: —Wajcaw, ¿qui'c pe' junt yaj yi nink ẍchakninu' tetz inxel? na qui nin chinxcye' wetz te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Nintzun je' swutz Ryos cyakil yi yol Moisés. Ej nin taltz tetz: —Xomok nin bin yi awutzicy Aarón tzawe'j, yi levita, na na el intxum tetz yi ba'n na jilon i'. Ncha'tz tz'ul i' tan ac'ulche'n nin stzatzink yil til awutz. ");
INSERT INTO aguBl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Alaj bin yi xtxolbila'se'j tetz nin txolaj yi mbi tajwe'n tan tlol i'. Ma yi in wetz chinxomok tzite'j yil cxjilon wok. Nin swale' tzitetz yi mbi tajwe'n tan ibnol. ");
INSERT INTO aguBl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ba'n tzawal tircu'n tetz chi ink na chinjilon tetz. Nin cyakil yi tzawale' tetz tajwe'n tan tlol i' scyetz yi e' intanum. ");
INSERT INTO aguBl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Cy'ajnin yi atx'amij na xconk tzatz, na tan yi atx'amij tzabne' wi'nin e'chk milawr yi chelepon yab wunak te'j, stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Itzun yi wi't baje'n yi xtxolbila'se'j, nintzun pakxij Moisés xe yi ca'l Jetro yi ji'. Yi topone'n nintzun tal tetz: —Ta', chimpakxokt wetz junt tir Egipto. Na tajwe'n che' wil junt tir yi e' inxonl. Na na waj che' wil yi ko itz' e' nka qui'. —Ba'n bin cẍben ko ya'tz, stzun Jetro bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ej itzun bantz te yi ntaxk el tzaj Moisés le jun ama'la'tz cwent Madián, nintzun jilon Ryos junt tir tetz. Itzun taltz: —Quil tzacabej ac'u'l tan apakxe'n junt tir Egipto, na ten chiquim yi e' yi ocnake' klo' tan abiyle'n, stzun Ryos bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Cyoque'n tzun Moisés tu txkel tu chinitxa' tan weko'n ib. Ej nin e' baj je' nintz squibaj chiburu'. Cwe'n nintzun e' bantz tbe' tan cyopone'n Egipto. Ma Moisés cy'a'n nin yi xtx'amij ta'n chi tal Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Itzun bantz yi na chixon tbe' jilone'nt tzun Kataj tetz. Itzun taltz: —Yil cẍopon nin yil cẍben tan jakle'n ama'l tetz faraón tan itele'n tzaj Egipto, ba'n tzun tzachaj cyakil yi e'chk milawr tetz i' yi ja wi't inchaj tzatz. Ma in wetz nocopon tan quiwse'n yi talma' tan qui tk'ol i' ama'l tan cyele'n tzaj yi e' atanum. ");
INSERT INTO aguBl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ncha'tz ba'n tzawal tetz i': “Je yol Ryose'j: Yi e' xonl Israel e' bajx incy'ajl tane'n. ");
INSERT INTO aguBl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Cha'stzun te na chintzan tan talche'n tzatz tan awak'ol ama'l scyetz tan chibene'n tan inc'u'laje'n. Poro tan tu' yi stze'tzal awalma' yi qui na awak' ama'l tan chibene'n tan inc'u'laje'n, copon imbiyol yi bajx acy'ajl,” cẍchij sban tetz, stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Itzun bantz te yi na chixon Moisés tbe', ẍchajol tzun tib Ryos swutz i' le jun ama'l kale e' cyaj cyent tan watl. Yi ẍchajol tib nintzun klo' octz tan biyle'n cu'n Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ma yi tilol Séfora yi mbi na bajij nintzun bentz tan kuxle'n len mu'ẍ stz'uml yi ẍchi'ol yi tal, tan jun c'ub yi chin cchilu' nin yi wi'. Nin oc t'oyol yi tkan Moisés tan yi mu'ẍ tz'umla'tz yi el ta'n. Ej nin taltz: “Mero bintzi aẍ jun wuchmil yi tz'ajij chich' tzawe'j.” ");
INSERT INTO aguBl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Tk'ol tzun Ryos ama'ltz tetz Moisés tan ticy'e'nt tan topone'n Egipto. Ej nin yi baje'n yi circuncisión te ni' ya'stzun yi talol Séfora tetz Moisés: Yi aẍ jun wuchmil yi tz'ajij chich' tzawe'j. ");
INSERT INTO aguBl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Te yi baje'n yi xtxolbile'j ya'stzun yi jilone'n Ryos tetz Aarón. Nintzun taltz: “Quilo'k, nin cun c'ul Moisés le ama'l yi tz'inunin tu'.” Bene'n nintzun ban Aarón tan c'ulche'n. Cho'n tzun chic'ulul quib tu Moisés le wi'wtz yi na bi'aj wi'wtz tetz Ryos. Yi chic'ulul quib, nintzun ben Aarón tan stz'uble'n yi xak tzi' Moisés tan yi tzatzi'n yi at cu'nt. ");
INSERT INTO aguBl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ma yi chic'ulul quib nintzun baj xtxolil Moisés yi xtxolbil quib yi tal Ryos tetz. Ncha'tz tal cyakil yi e'chk milawr yi ẍchaj Ryos tetz tan bnol i'. ");
INSERT INTO aguBl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ej itzun yi tbital Aarón yi xtxolbila'tz nintzun e' bentz tan yol scyetz yi e' ajcaw tetz Israel yi ate' Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Nintzun baj xtxolil Aarón cyakil, quib yi tal Ryos tetz Moisés. Ncha'tz ẍchaj i' yi e'chk milawra'tz yi tal Ryos tan chibnol swutz faraón. ");
INSERT INTO aguBl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Yi quilol yi e' wunak yi e'chk milawra'tz, cyakil cu'n tzun e' cyocsaj yi ya'stzun tal Ryos tetz Moisés. Ej nin ncha'tz el chitxum tetz yi nin el k'ajab Ryos scye'j, na ja til yi q'uixc'uj yi ate' cu'nt. Chicwe'n tzun joklok cyakil wunak tan c'u'laje'n Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Itzun yi tele'n tiemp nintzun e' opon Moisés tu Aarón tan yol tetz faraón. Itzun cyaltz: —Cyakil yi yol yi skale' teru', i'tz yol yi ketz kaRyosil yi o' xonl Israel. Je yol i'e'j: “Ak'aj ama'l scyetz yi e' intanum tan chibene'n le ama'l tz'inunin tu' tan ticy'se'n jun balaj k'ej tan tak'le'n wetz ink'ej,” stzun i'. ");
INSERT INTO aguBl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Yi tbital faraón yi yole'j nintzun taltz: —¿Na' tzun scyetz yi jun itetz iRyosila'tz yi na taj yil cawun swe'j tan wak'ol ama'l tzitetz tan itele'n liwr? Qui wajske'n wutz nin quil wak' ama'l tzitetz tan itele'n liwr. ");
INSERT INTO aguBl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","—Poro ta', yi ketz kaRyosil yi o' hebrey ja ẍchaj tib skawutz. Cha'stzun te na kaj kaben le ama'l yi tz'inunin tu' tan tak'le'n katx'ixwatz tetz i', bantz qui kaquime'n tan ya'bil nka tan ch'ich'. Nin yi tkanil yi kabe' i'tz ox k'ej, che'ch tzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","—¿Nxac na cxtzan wok tan telse'n chitiemp yi e' wunak te cyak'un? ¡Ba'n tcu'n yi nink cxben itetz tan ak'un! stzun yi rey scyetz Moisés tu Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ncha'tz tal i' scyetz: —Ma jalu' wi'nin xonl Israel najlche' tzone'j. Ej nin tan ipaj qui't na chak'uj, stzun yi rey bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ej ite'n nintzun te k'eja'tz yi tele'n jun ort tak'un faraón scyetz yi e' martoma' tibaj yi ak'un kale na chak'uje't yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","—Yi jalu', nin sbne' opon tunintz, qui't tzitak' wok xaktz scyetz yi e' xonl Israel yi na chitzan tan banle'n xan, chi yi na ban nin. Ma na tajwe'n tan chibene'n cyetz tan molche'n chixaktz. ");
INSERT INTO aguBl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Poro tajwe'n tan bnixe'n ite'n nin tajlal xana'tz chi yi na bnix nin cya'n. Tajwe'n tz'aku'l len chitarey na chin cy'aj nin e'. Cha'stzun te na chitzan tan talche'n: “¡Quin kak'e' katx'ixwatz tetz kaRyosil!” ");
INSERT INTO aguBl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Cha'stzun te ak'wok mas cyak'un yi chin quiw nin, nin qui't tzitak' wok ama'l scyetz tan cyujewe'n, bantz quil chitxum yi e'chk la'jila'tz yi na tzan talche'n scyetz, stzun yi rey bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Itzun yi quibital yi e' martoma' cyakil yi xtxolbila'se'j, nintzun e' baj eltz tan talche'n scyetz cyakil wunak. Itzun cyaltz: —Ma jalu' cyakil yi xtxolbile'j i'tz ort tetz yi rey. Qui't tz'ak'lij tkan triw tzitetz yi na xcon ita'n tan banle'n xan. ");
INSERT INTO aguBl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ma na tajwe'n cxben wok tan ẍchamle'n yi tkan triw yi na xcon ita'n. Poro quil cutzaj yi tajlal itarey tan tu' yi cxbenwok tan molche'n yi tkan triw, che'ch yi e' martoma' bantz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Yi quibital yi e' xonl Israel yi xtxolbile'j nintzun e' baj el xittz Egipto tan joyle'n e'chk xe' triw tu' tetz xel yi mero tkan triw yi na xcon cya'n sajle'n tunintz tan banle'n xan. ");
INSERT INTO aguBl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","14","Cyakil nintzun k'ej e' oc yi e' ajcaw tetz faraón tan jakle'n ite'n nin tajlal xana'tz chi yi na bnix nin cya'n te yi na ak'lij tzaj tkan triw scyetz. Ncha'tz ja chibiylij yi e' xonl Israel yi e' martoma' nintzun cyaltz scyetz: —¿Mbi tzuntz qui't na xcye' wok te itarey? na yi ewt nin jalu' qui nin nxcye' wok te yi tajlal xan nxcye' wok te'j sajle'n tunintz, che'ch tzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Yi quibital nin yi quilol yi e' xonl Israel yi e' martoma' nintzun e' baj ben tan xocho'n tetz faraón. Yi cyopone'n nintzun cyaltz: —Ta' ¿mbi tzuntz yi chin q'uixc'uj nin na ko' tuleju' yi o' yi o' xconsbe'tzu'? ");
INSERT INTO aguBl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Na qui't na ak'lij xaktz sketz, poro na nin kabuchlijtz tan banle'n ite'n nin tajlal xana'tz chi yi sajle'n yi na ak'lij tzaj yi tkan triw sketz. Ej nin nk'e'tz tina'tz, ma na na kabiylijtz cyak'un yi e' teru' ẍchakumu'. ¡Poro ta', e' te'n yi tanumu' yi mero ajpaj! ");
INSERT INTO aguBl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Saje'n tzun tlol faraón scyetz. Itzun taltz: —Ma jalu' yi ax wok itetz qui'c nin junt na itxum wok, ma na ntin cy'ajil, chin cy'aj nin ax wok. Cha'stzun te na cxtzan wok tan talche'n: “Quin le ama'l tz'inunin tu' tan toye'n katx'ixwatz tetz Kataj,” cẍchij wok na ban. ");
INSERT INTO aguBl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","¡Or tzibene'n wok tan ak'un mpe qui'kt tz'ak'lij tkan triw tzitetz! Poro tajwe'n tan bnixe'n ite'n nin tajlal xana'tz chi yi na bnix nin ita'n, stzun faraón bantz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Itzun yi quibital yi e' bajxom tetz Israel yi xtxolbila'se'j, ja el chitxum tetz yi mas tcunin q'uixc'uj ẍchibne' jak' chica'wl yi e' aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ej itzun yi cyele'n tzaj tan yol tetz faraón, nintzun e' noj cyen Moisés tu Aarón ẍchiwutz cobox chitanum. Nintzun ben cyaloltz scyetz Moisés: ");
INSERT INTO aguBl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","—Ryos tz'ak'on icaws tan cyakil yi e'chk takle'n yi na cxtzan wok tan banle'n ske'j. Na ipaj wok yi na chi'ch chic'u'l faraón scyuch' yi e' tetz ẍchakum ske'j. Ax wok te'n nin na cxtzan tan tak'le'n cyen yi spar chik'ab tan kabiyle'n cu'n, che'ch tzun bantz tetz Moisés tu Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Yi tbital Moisés yi xtxolbile'j nintzun bentz tan nachle'n Kataj. Itzun taltz tul yi oración: —Ta', ¿mbi tzuntz na tzanu' tan tak'le'n bis tetz yi intanum? na chin q'uixc'uj nin ate' cu'nt. ¿Nxac nchinsaj ẍchakolu' tzone'j? ");
INSERT INTO aguBl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Na jetz yi wunle'n tan yol tetz yi faraón tan bi'u', nin tan cyelse'n klo' yi tanumu' liwr, mas tcunin q'uixc'uj na tzan tak'le'n sketz, nin txe'n nin che'lo'k liwrtz tanu', stzun Moisés tetz Kataj le oración. ");
INSERT INTO aguBl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","—Ma jalu' Moisés tzawile' yi mbi cu'n swulej yi rey, nin tan tu' yi e'chk takle'na'tz yi tzimbne' te'j, stk'e' i' ama'l tan itele'n liwr. Nin i' te'n nin tz'a'lon tzitetz tan ibene'n, stzun Kataj Jehová bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nintzun jilont junt tir Ryos tetz Moisés. Itzun taltz: —I ina'tz iTaj Jehová. ");
INSERT INTO aguBl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nin ite'n nin ina'tz yi inchaj wib ẍchiwutz Abraham tu Isaac nin Jacow. Ej nin yi imbi' yi nwal scyetz i'tz, yi in “Yi Ryos yi na xcye' tan kojle'n tzaj yi imbanl tibaj jun.” Poro qui nin wal scyetz yi mero imbi', yi i'tz yi “In iTaj Jehová.” ");
INSERT INTO aguBl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ncha'tz bnixnak jun katrat skaxo'l scyuch' Abraham, Isaac tu Jacow, kale insukwit tan wak'ol yi ama'l cwent Canaán scyetz. Nin yi jun ama'la'tz i'tz kale e' cyaje't cyen cobox tiemp tetz awer nak tane'n. ");
INSERT INTO aguBl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ma jalu' na wil yi q'uixc'uj yi ate' cu'nt yi e' xonl Israel jak' chica'wl yi e' aj Egipto, na chin buchij nin quitane'n cyak'un e'. Cha'stzun te ja ul tx'akx tinc'u'l yi trat yi bnixnak skaxo'l scyuch' yi e' imam ite'. ");
INSERT INTO aguBl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Cha'stzun te, cun al scyetz yi atanum xonl Israel: “Quil cxbisun wok na cxelepon wok liwr. Cxelepon tzak' yi jun chin q'uixc'uja'tz yi atix cu'nt. Na chin buchij nin itane'n cyak'un yi e' aj Egipto tan yi e'chk ak'un yi chin q'uixbel nin. Tzinchaje' yi imporer nin tan yi e'chk milawr yi sbnixok wa'n cxelu'l wok liwr. ");
INSERT INTO aguBl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Cxelu'l incy'al nin cxocopon wok tetz intanum, na nocopon tetz iRyosil. Ej nin tz'elepon itxum tetz yi ina'tz in iTaj Jehová, yi iRyosil. Ej nin chinxcyek tan itelsene'l tzaj tk'ab yi q'uixc'uj yi atix wok cu'nt jak' chica'wl yi e' aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nin cxben incy'al le ama'l yi insuknak tetz Abraham tu Isaac nin Jacow, nin swak'e' tzitetz wok, na nelpon cu'n te inyol, na in iTaj Jehová,” stzun Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Itzun yi tbital Moisés nintzun ben i'-tz tan talche'n scyetz cyakil yi e' xonl Israel. Poro qui nin cyocsaj tan paj yi bis yi ate' cu'nt na chin buchij nin quitane'n tan ak'un cyak'un yi e' aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Tlol tzun junt tir Ryos tetz Moisés: ");
INSERT INTO aguBl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","—Ma jalu' Moisés ba'n bin cẍben tan yol tetz faraón tan tk'ol i' ama'l tan cyele'n tzaj yi e' xonl Israel Egipto, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","—Poro Ta', qui na cyocsaj yi e' xonl Israel inyol. Pyor tzun faraón. ¿Ẍe'n ltocsaj kol wal yi xtxolbile'j tetz? Nin jenin, qui na a'w yol wa'n, stzun Moiséstz bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Cha'stzun te bene'n ẍchakol Kataj yi Moisés tu Aarón tan chibene'n tan talche'n scyetz yi e' xonl Israel nin tetz faraón yi cy'a'n ort cya'n tan talche'n yi chin tajwe'n cunin tan cyele'n yi e' xonl Israel Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Je chibi' yi e' chimam chite' yi e' xonl Israele'j: Je chibi' yi e' cy'ajl Rubén yi bajx cy'ajl Israel, i'tz: Hanoc, Falú, Hezrón tu Carmi. Ya'stzun yi e' cy'ajl Rubén. ");
INSERT INTO aguBl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ma yi e' cy'ajl Simeón i'tz: Jemuel, Jamín, Ohad, Jaquín, Zohar tu Saúl. Yi Saúla'tz i' tal jun xna'n aj Canaán. Ya'stzun yi e' cy'ajl Simeón. ");
INSERT INTO aguBl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ma yi e' cy'ajl Leví i'tz: Gersón, Coat tu Merari. At Leví tul jun cient tu junak juklaj yob yi quime'n. ");
INSERT INTO aguBl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ma tetz Gersóna'tz, yi bajx cy'ajl Leví, ja jal cob tetz cy'ajl, yi bajx i'tz Libni. Ej nin yi ca'p i'tz Simei. ");
INSERT INTO aguBl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ma yi e' cy'ajl Coat yi ca'p cy'ajl Leví i'tz: Amram, Izhar, Hebrón tu Uziel. At tzun Coat tul jun cient tu junak oxlaj yob yi quime'n. ");
INSERT INTO aguBl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ma yi e' cy'ajl Merari yi toxi'n cy'ajl Leví i'tz: Mahli tu Musi. Cyakil yi e'chk bi'aja'tz e' cu'n cy'ajl tu mamaj Leví. Cho'n nxe'tij te yi bajx cy'ajol jalen te yi ch'i'p. ");
INSERT INTO aguBl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ma Amram yi cy'ajl Coat nintzun cyok'bej quibtz tu Jocabed tanub yi taj. Ej nin yi chibi' yi cob cy'ajl Amrama'tz i'tz Aarón tu Moisés. At Amram tul jun cient tu junak juklaj yob yi quime'n. ");
INSERT INTO aguBl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ma yi e' cy'ajl Izhar yi ca'p cy'ajl Coat i'tz: Coré, Nefeg tu Zicri. ");
INSERT INTO aguBl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ma yi e' cy'ajl Uziel yi toxi'n cy'ajl Coat i'tz: Misael, Elsafán tu Sitri. ");
INSERT INTO aguBl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ma yi Aarón yi bajx cy'ajl Amram nin cyok'bej quib tu Elizabet yi me'l Aminadab. Yi Elizabeta'tz i'tz tanub Naasón. Ej nin yi xone'n tiemp jal chinitxa'. Je chibi' yi e' cy'ajle'j: Nadab, Abiú, Eleazar tu Itamar. ");
INSERT INTO aguBl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ma yi e' cy'ajl Coré yi bajx cy'ajl Izhar i'tz: Asir, Elcana tu Abiazaf. Ya'stzun yi e' cy'ajl Coré. ");
INSERT INTO aguBl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ma tetz Eleazar yi cy'ajl Aarón, nintzun cyok'bej quib tu jun scyeri yi me'l Futiel. Yi cyok'bel quib nintzun jal jun cy'ajl yi na bi'aj Finees. Cyakil yi e'chk bi'aje'j e' cu'n chimam chite' yi e' xonl Leví. ");
INSERT INTO aguBl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Inti Aarón tu Moisés ite'n nin e'a'tz yi talnak Ryos scyetz: “Quibene'nk jalen Egipto tan cyelsene'l tzaj yi e' xonl Israel. Ba'n che'l tzaj ita'n chi na chiban ala' k'u'j sanlar.” ");
INSERT INTO aguBl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ej nin ite'n nin Aaróna'tz tu Moisésa'tz yi e' ẍchak tan yol tetz faraón tan cyelsene'l tzaj yi e' xonl Israel jak' ca'wl i'. ");
INSERT INTO aguBl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Je yole'j yi talnak Ryos tetz Moisés Egipto: ");
INSERT INTO aguBl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","—I ina'tz in itajcawil. Alaj bin tetz faraón tircu'n yi xtxolbile'j yi swale' tzatz. ");
INSERT INTO aguBl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","—Poro Ta', yi in wetz qui na a'w mas yol wa'n. ¿Ẍe'n ltocsaj faraón yi xtxolbil yi swale' tetz? stzun Moisés bantz tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Bene'n tzun tlol Ryos tetz Moisés: —Yaj, aẍ ink'ajbil sbne' swutz faraón nin yi awutzicy Aarón sjilonk tetz axel. ");
INSERT INTO aguBl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tajwe'n tan ibene'n tan talche'n tetz faraón tan tk'ol i' ama'l tan cyele'n tzaj yi e' xonl Israel Egipto. Swale' tzatz yi mbi tajwe'n tan awalol tetz Aarón. I' tzun tz'a'lon tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Poro tzinquiwse' yi talma' faraón tan qui tk'ol ama'l tan cyele'n tzaj. Na tzinchaje' yi imporer nin tzimbne' wi'nin e'chk milawr le luwar Egipto tan xtx'ixpe'n tajtza'kl tan tk'ol i' ama'l tan cyele'n tzaj. ");
INSERT INTO aguBl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Poro quil tocsaj faraón yi iyol. Ma na jalen yil tzinchaj yi imporer tibaj Egipto. Ej nin yil til e'chk milawra'tz kalena's tzun ltak' yi rey ama'l tan cyele'n tzaj intanum. ");
INSERT INTO aguBl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Tz'elepon tzun chitxum yi e' aj Egipto yi at imporer nin yi in yi wi'tz ajcaw bene'n tzi'n wi munt, stzun Ryos bantz scyetz Moisés tu Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ya'tz nin tzun cyulej Moisés tu Aarón quib yi tal Ryos scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","At tzun Moisés tul jun mutx' yob, ma tetz Aarón at i' tul jun mutx' tu ox yob te yi chijilone'n tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ej itzun tal Ryos scyetz Moisés tu Aarón: ");
INSERT INTO aguBl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","—Yil xben wok tan yol tetz faraón, nin kol jak tan ichajol jun milawr, ba'n tzichajwok. Yi aẍatz Moisés ba'n tzawal nin tetz Aarón yi ba'n sc'ox cu'n yi xtx'amij wuxtx'otx'. Ej nin yil sc'ox cu'n, tz'ocopon tetz lu'baj. Ba'n tzibanwok yi xtxolbile'j swutz faraón, stzun Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Chibene'n tzun Moisés tu Aarón tan yol tetz faraón. Yi cyopone'n nintzun e' ban quib yi tal Ryos scyetz. Cwe'n tzun c'oxol Aarón yi xtx'amij ẍchiwutz faraón scyuch' yi e' mas ajcaw yi ate'-tz xlaj. Oque'n nin tzun ban yi xtx'amij tetz lu'baj. ");
INSERT INTO aguBl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Yi tilol faraón yi xtxolbile'j, nintzun cawunin tan chichakle'n yi e' nachol scyuch' e' wi'tz aj cun. Nin tan yi cyetz quipisyo' e' xcye' tan banle'n chi e' ban Moisés tu Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Cwe'n tzun chic'oxol len yi cyetz chitx'amij wuxtx'otx', nintzun e' oc lentz tetz lu'baj. Poro nin ben yi xtx'amij tetz Aarón tan chibajse'n yi chitx'amij yi e' nachol scyuch' yi e' wi'tz ajcaw yi nsken cho'c tetz lu'baj. ");
INSERT INTO aguBl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Chin xo'wbil nin ban yi xtxolbile'j, poro yi tetz faraón mas tcunin stze'tzaxe'n talma' nin qui nin tak' i' ama'l scyetz yi e' xonl Israel tan cyele'n tzaj Egipto. Tan yi xtxolbile'j el cu'n te'j quib yi tal Kataj Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Itzun tal Ryos tetz Moisés: —Yi faraón ja tocsaj tib nim, nin ja tze'tzax yi talma' tan qui tk'ol ama'l tzitetz, yi axwok xonl Israel, tan itele'n liwr. ");
INSERT INTO aguBl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ma jalu' tajwe'n tan abene'n tan yol tetz ek jalchan. Ba'n cẍben tzi yi tzanla' nin cho'n tzach'iwtz jalen yil copon, na copon i' tzi' a' tan jichi'n. Cy'ajnin yi atx'amij yi oc tetz lu'baj. Nin ba'n tzawal yi xtxolbile'j tetz: ");
INSERT INTO aguBl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","“Yi Kataj yi kaRyosil yi o' hebrey, i' nchinchakon tzaj swutzu' tan talche'n yi xtxolbile'j. Nin je yi yol i'e'j: ‘Ak'aj ama'l scyetz intanum tan chibene'n tan inc'u'laje'n le ama'l tz'inunin tu'.’ Poro qui nin na awak'o'k ama'l scyetz, stzun i'. ");
INSERT INTO aguBl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Cha'stzun te ja tal i' yi xtxolbile'j: ‘Ma jalu' tzinchaje' tetz faraón chij, yi in yi wi'tz ajcaw,’ nin je jun techle'j yi nẍchaj i' swetz: Yil tzinjab cu'n yi a' tan yi intx'amij yi cy'a'n wa'n, tz'ocopon yi a' tetz chich'. ");
INSERT INTO aguBl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ej nin ẍchiquimok cyakil cay. Ej nin chin xewe'n nin sbne' yi jun tzanla'a'tz. Ej nin cyakil yi axwok aj Egipto smulmuchk ic'u'l yil chic'aje'n,” cẍchij sban tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ncha'tz tal Ryos tetz Moisés. —Alaj tetz Aarón yi ba'n ẍchajnin yi xtx'amij, te cyakil yi e'chk ne'ẍ tzanla' tu e'chk lawun nin alchok ama'l kale atit a' cwent Egipto. Na na waj yil tz'oc cyakil yi a' tetz chich'. Chich' cu'n sbne' cyakil yi a' yi at tulak e'chk cu'lbil. Qui'c na ban yi ko c'ub nka tze' yi cu'lbil a'a'tz, stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","I nintzun cyulej Moisés tu Aarón quib yi tal Ryos scyetz. Chibene'n tzun tan yol tetz faraón. Yi cyopone'n tzi a', bene'n tzun Aarón tan jabe'n cu'n yi a' tan yi xtx'amij ẍchiwutz cu'n faraón scyuch' yi e' mas ajcaw yi xomche' te'j. Tircu'n tzun yi a' octz tetz chich'. ");
INSERT INTO aguBl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Chiquime'n tzun cyakil yi e' cay yi ate' xe a'. Chin tzu'j nin tzun ban yi a'a'tz nin qui't jal quic'a' yi e' aj Egipto na chich' cu'n tane'n tircu'n yi a' cwent Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Yi quilol yi e' nachol scyuch' yi e' ajcun yi xtxolbile'j nintzun e' octz tan banle'n cyetz, chi yi e' ban Moisés tu Aarón, nin e' xcye' te'j tan yi cyetz quipisyo'. Cha'stzun te qui nin bisun faraón ta'n. Nin qui nin tocsaj i' yi chiyol Moisés. Ma na mas tcunin tocsal tib nim tu tajtza'kl. Nin qui nin tbit yi yol Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Aje'n nin ban faraón xe tetz ca'l. Qui nin oc il i' tan xtxumle'n yi xtxolbila'se'j nin qui nin bisun i' ta'n, na chin tze'tzuj nin ban yi talma', chi alijt tan Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ma yi e' aj Egipto cyoque'n tzun tan kople'n jul tzi'ak yi tzanla' tan joyle'n balaj a' tetz quic'a', na yi tzanla' qui'c rmeril tan baje'n cya'n tetz quic'a'. ");
INSERT INTO aguBl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Itzun bantz yi tele'n juk k'ej yi tocle'nix Kataj Ryos tan po'tze'n yi a'. ");
INSERT INTO aguBl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Nintzun tal Kataj tetz Moisés: —Ba'n cẍben junt tir te'j faraón nin alaj tetz: “Je yol Kataje'j: ‘Ak'aj ama'l tetz intanum tan chibene'n tan inc'u'laje'n le ama'l tz'inunin tu'. ");
INSERT INTO aguBl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Na ko quil tzawak' ama'l scyetz tz'ul junt icaws, nin i'tz yi ẍchijalok wi'nin wo' bene'n tzi'n Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ẍchijalok wi'nin wo' tul yi tzanla', nin chiben lo'on bene'n tzi'n Egipto. Ncha'tz chocopon le ama'l kale na cxcawune't nin chijepon wi asoc. Ncha'tz chocopon xe'ak chica'l yi e' mas ajcaw nin scye'j cyakil wunak. Chin xo'wbil nin sbne' na chocopon yi e' wo'a'tz tul cyakil yi e'chk takle'n, chi tane'n yi e'chk ẍwok' tu ẍchujil pam. ");
INSERT INTO aguBl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ej nin chijepon wi'nin wo' tzawibaj nin squibaj yi e' mas ajcaw nin squibaj cyakil wunak.’ ” ");
INSERT INTO aguBl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ncha'tz tal Ryos tetz Moisés: —Al nin tetz Aarón tan je'n ẍchajol yi k'ab tibaj yi tzanla' nin tibaj cyakil ama'l kale atite't a' na na waj yil chijal wi'nin wo' bene'n tzi'n Egipto, stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Bene'n tzun ẍchajol Aarón yi xtx'amij tibaj cyakil yi a' bene'n tzi'n Egipto. Wi'nin tzun wo' e' jal xe a'. Nintzun e' jetzaj, nin e' baj noj cyakil ama'l cwent Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ncha'tz yi e' nachol scyuch' yi e' wi'tz ajcun nin je'n chichajol yi cyetz chitx'amij wi'ak e'chk a'. Nintzun e' jetzaj wi'nin wo' cya'n. E' xcye' te'j tan yi cyetz quipisyo', nin wi'nin wo' e' jal Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Yi tilol faraón yi xtxolbile'j nintzun e' ẍchak Moisés tu Aarón. Itzun taltz scyetz: —Jak wok pawor tetz iRyosil tan cyele'n yi e'chk wo' ta'n swe'j, nin scye'j cyakil intanum. Swak'e' tzun ama'l tzitetz tan ibene'n tan toye'n yi itx'ixwatz swutz i'. ");
INSERT INTO aguBl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","—Ba'n ta', stzun Moisés. —Poro tale'u' swetz tona' na taju' yil tzinjak tetz Ryos tan cyele'n yi e' wo' te'ju', nin scye'j yi e' mas ajcaw nin scye'j cyakil wunak. Ntin yi e' yi ate' xe' a' ẍchicyajk cyen, stzun Moisés bantz tetz rey. ");
INSERT INTO aguBl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","—Ninin eklen, stzun yi rey bantz. —Ba'n ko ya'tz na taju', ninin ek chelepon, bantz tele'n xtxumu' tetz yi qui'c junt ryos yi ni'cu'nk tu Jehová yi kaRyosil yi at jalen tzi'n tcya'j. ");
INSERT INTO aguBl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Na jun cu'n yol xcyek i' tan chilaje'n len yi e' wo' yi ate' te'ju' scyuch' cyakil yi e' yi ate' xe ca'lu'. Ncha'tz xcyek tan chilaje'n len cyakil yi e' wo' yi ate' scye'j yi e' mas ajcaw yi na chicawun xlaju' nin scye'j cyakil yi e' tanumu'. Ntin ẍchicyajk yi e' yi ate' xe a' Nilo, stzun Moisés bantz tetz rey. ");
INSERT INTO aguBl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ele'n tzaj nintzun e' ban cyetz Moisés tu Aarón kale na cawune't yi rey. Toque'n tzun Moisés tan nachle'n Kataj nin tan jakle'n tetz tan cyele'n yi e' wo' yi ate' Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Nintzun tbit Ryos yi mbi jak Moisés tetz. Chiquime'n tzun cyakil yi e' wo' yi ate' xe'ak ca'l, nin wi'ak cojbil nin yi e' yi ate' tbe'. ");
INSERT INTO aguBl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Cyoque'n tzun yi e' wunak tan chimolche'n nin chibu'jbaje'n. Chin xewe'n nin tzun ban cyakil yi ama'l cwent Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Poro itzun yi tilol faraón yi stzaje'n yi jun ila'tz qui'ct nintzun bislej i'-tz. Mas tcunin tzun stze'tzaxe'n yi talma'. Nin qui nin tocsaj yi mbi ntal Kataj Ryos tetz i' tan Moisés tu Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Jilone'n tzun Ryos junt tir tetz Moisés. Itzun taltz: —Alaj tetz Aarón yi ba'n sjab cu'n yi xtx'amij wuxtx'otx' tul yi puklaj, tan toque'n yi puklaj tetz ne'ẍ us, bantz jale'n wi'nin us bene'n tzi'n Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ya'tz nintzun cyulejtz, nintzun cu' jabul Aarón yi xtx'amij wuxtx'otx'. Ej nin cyakil yi puklaj cwent Egipto oc tetz ne'ẍ us. Nin e' baj octz tan chichi'le'n cyakil wunak scyuch' yi e' txuc. ");
INSERT INTO aguBl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Cyoque'n tzun yi e' nachol scyuch' yi e' wi'tz ajcun cwent Egipto tan pile'n tan jalse'n us, chi mban Aarón. Poro qui nin xcye' yi cyetz quipisyo' te'j. Ma yi e' us yi e' jal tan Aarón mas tcunin saje'n chiwi' tan chichi'le'n yi e' wunak tu e' txuc. ");
INSERT INTO aguBl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Yi quilol yi e' nachol yi xtxolbile'j nintzun cyaltz tetz faraón: —Yi xtxolbile'j yi na bajij i'tz chiRyosil yi e' xonl Israel yi nchakon tzaj, che'ch e' nachol. Poro qui nin tocsaj faraón, ma na mas tcunin stze'tzaxe'n yi talma'. Ej nin tan yi xtxolbila'se'j ja el cu'n te'j yi yol yi alijt cyen tan Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Itzun bantz nintzun jilont Ryos tetz Moisés. Itzun taltz: —Ba'n cẍben ek jalchan stzi' a' tan yol tetz faraón, na ek ben i' tan xo'n stzi' a'. Yil tz'opon ba'n tzawal yi xtxolbile'j tetz: Je yol yi kaRyosile'j: “Tajwe'n tzawak' ama'l scyetz intanum tan chibene'n tan inc'u'laje'n le ama'l tz'inunin tu'. ");
INSERT INTO aguBl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Na ko quil tzawak' ama'l scyetz tan cyele'n tzone'j, tz'ul jun chin c'oloj jilwutz us wa'n tetz icaws. Quin technin jilwutz us ẍchijalok xe' aca'l. Ncha'tz ẍchijalok scye'j yi e' mas ajcaw nin scye'j cyakil wunak bene'n tzi'n Egipto, nin qui'c nin jun ama'l yi qui'k noj tan e'chk usa'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Nin yil bajij yi xtxolbile'j tzone'j Egipto yi tircu'n bene'n tzi'n snojk tan e'chk usa'tz, ma na tzincole' yi ama'l Gosén kale ate't yi wetz intanum, qui'c nin jun us sjalok ẍchixo'l nin qui'c nin chibislej cyetz. Ej nin tan yi xtxolbile'j tzinchaje' tzatz nin scyetz cyakil wunak yi in yi wi'tz ajcaw tzone'j Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Tzincole' yi ama'l kale ate't yi intanum tan inchajol yi apart yi wetz intanum ẍchiwutz cyakil yi mas tnum. Ej nin yi xtxolbila'se'j ninin ek tzimbne',” stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","I nin tzun tulej Ryosa'tz. Le junt eklok nintzun saj bnol tib jun chin wutzile'n sbak' yi chin k'ek nin tan us. E' baj len tunin tzun xit. Ej nin wi'nin tzun e', e' ocpon xe yi ca'l kale na cawune't yi faraón. Ncha'tz ban kale ate't yi e' mas ajcaw yi na chicawun xlaj faraón. Ej nin ncha'tz e' ban bene'n tzi'n Egipto. Tircunin tzun yi ama'l cwent Egipto lo'ontz cya'n. ");
INSERT INTO aguBl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Yi tilol faraón yi chin xo'wbil nin tane'n yi jun chicawsa'tz bene'n tzun mantartz ta'n tan chichakle'n Moisés tu Aarón. Yi cyopone'n Moisés swutz itzun taltz scyetz: —Ba'n cxben wok tan pate'n yi itx'ixwatz tan toye'n tetz yi iRyosil. Poro qui na waj yil cxben wok joylaj, ma na ta'ste'n nin tzone'j Egipto, stzun faraón bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","—Poro ta', stzun Moisés bantz, kol ya'tz kulej, ko na kaj kapat yi katx'ixwatz swutz Kataj Ryos tzone'j, ploj sbne', na yi e' txuc yi na kaj koy tetz katx'ixwatz, xan ẍchiwutzu' yi e'u' aj Egipto, na wi'nin na cyak'u' k'ej yi e' txuca'tz nin na chilok'u' wutz. Itzun yi kol quil ninu' yi na katzan ketz tan pate'n yi e'chk txuca'tz tetz katx'ixwatz, quicunin batz chocoponu' tan kabiyle'n cu'n tan c'ub. ");
INSERT INTO aguBl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Cha'stzun te, mas balaj yil tak'u' ama'l sketz tan kabene'n tan pate'n yi ketz katx'ixwatz jalen le ama'l tz'inunin tu', yi i'tz ox k'ej be'. Mas balaj yi nink tak'u' ama'l sketz tan kabene'n chone'j. Na ya'stzun tal yi kaRyosil sketz, stzun Moisés bantz tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","—Ma jalu' bin, swak'e' ama'l tzitetz tan ibene'n tan toye'n yi itx'ixwatz tetz yi iRyosil. Ba'n cxben wok le ama'l tz'inunin tu'. Poro qui na waj yil cxben wok joylaj. Nin ncha'tz na waj yil xpakxij wok junt tir. Ba'n cxben wok, nin jakwok yi banl iRyosil swibaj, stzun yi rey bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Nintzun tal Moisés tetz: —Ko ya'tz ta', yil ne'l tzone'j nchimben tan jakle'n tetz Ryos tan tele'n tcy'al i' cyakil yi us tzone'j. Tzinjake' tetz yi ninin ek qui't ljal jun us xe yi ca'lu' nin xe yi chica'l yi e' mas ajcaw, nin ncha'tz xe'ak chica'l cyakil wunak. Ya'stzun sbne' ko bintzi na talu' yi qui't tz'ocu' tan kamakle'n tan kabene'n tan toye'n yi katx'ixwatz tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Quenin tzun bene'n tetz Moisés tan nachle'n Kataj yi tele'n tzaj tan yol tetz yi rey. ");
INSERT INTO aguBl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Jak tzun i' tetz Ryos tan cyelse'n cyakil yi e'chk usa'tz yi attz Egipto. Nin tbit Ryos cyakil yi oración Moisés. Ej nin ya'tz nin tulejtz na le junt eklok qui'c nin tzun junt us ban cyen le ca'l yi rey. Ncha'tz ban cyetz yi e' mas ajcaw, nin bene'n tzi'n Egipto. Qui'c nin jun usil wacẍ ban cyentz. ");
INSERT INTO aguBl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Poro yi tilol faraón yi qui'ct nin jun us jal cyen Egipto nintzun ajt junt tir te yi tetz stze'tzal yi talma', na qui nin tak' i' ama'l scyetz yi e' xonl Israel tan chibene'n tan toye'n yi chitx'ixwatz tetz Ryos le ama'l tz'inunin tu'. ");
INSERT INTO aguBl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Itzun bantz yi wi't baje'n yi xtxolbile'j nintzun jilon junt tir Ryos tetz Moisés. Itzun taltz: —Tajwe'n cẍben junt tir swutz faraón nin ba'n tzawal tetz: “Je yi yol kajcawe'j yi kaRyosil yi o' hebrey: Tajwe'n tan awak'ol ama'l scyetz e' intanum tan chibene'n tan inc'u'laje'n. ");
INSERT INTO aguBl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Na ko quil tzawak' ama'l scyetz tan cyele'n ej nin kol tzaban seguir tan chimakle'n, tz'ul acaws. ");
INSERT INTO aguBl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Tz'ul Ryos tu yi tetz ẍchamil tan tak'le'n jun chin wutzile'n ya'bil ẍchixo'l cyakil yi cyawunu' yi ate' bene'n tzi'n. Chin xo'wbil nin sbne' yi jun ya'bila'tz, na ẍchiquimok cyakil yi e' chej scyuch' yi e' buru', ncha'tz yi e' wacẍ tu e' cne'r tu cyakil yi e' camey. ");
INSERT INTO aguBl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Cyakil yi cyawun yi e' aj Egipto ẍchiquimok. Poro quil wak' ama'l tan chiquime'n yi cyawun yi e' xonl Israel, na yi wajbil i'tz tan inchajol yi apart yi e' xonl Israel tziwutz wok,” stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ncha'tz tal Ryos: —Ninin eklen tz'ul yi jun cawsa'tz wa'n. ");
INSERT INTO aguBl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ej nin ya'tz nin tulej Ryos. Na yi tule'n skil le junt eklok tircu'n chiquime'n yi cyawun yi e' aj Egipto. Qui'c nin jun yi jak clax cyen. Poro ẍchixo'l yi e' xonl Israel qui'c nin jun cyawun yi nink quim. ");
INSERT INTO aguBl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Yi tbital faraón yi qui e' quim yi cyawun yi e' xonl Israel, nintzun e' ben ẍchakol cobox tan xmaye'n yi ko bintzinin. Yi cyopone'n nintzun quil yi qui'c nin jun yi jak quim. Chipakxe'n tzuntz tan talche'n tetz faraón. Poro yi i' tetz mas tcunin stze'tzaxe'n yi talma' nin qui nin tak' ama'l scyetz yi e' xonl Israel tan chibene'n tan c'u'laje'n yi chiRyosil. ");
INSERT INTO aguBl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Itzun bantz tan paj yi qui na tak' faraón ama'l scyetz yi e' xonl Israel tan cyele'n Egipto, nintzun tal Kataj tetz Moisés tu Aarón: —Cy'ajwok nin jun txob stza'jil chuj swutz faraón, nin yil cxopon ba'n tzichitwoke'n tcya'j swutz i'. ");
INSERT INTO aguBl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Yi mu'ẍ tza'ja'tz tz'ocopon tetz puklaj nin mben lo'on bene'n tzi'n Egipto. Ej nin i'tz jun chin wutzile'n ya'bil sbne' scye'j cyakil wunak nin scye'j cyakil txuc. Nin yi jun ya'bila'tz yi sjalok i'tz yi xpok'on tx'a'c. ");
INSERT INTO aguBl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Yi quibital Moisés tu Aarón yi xtxolbile'j, ya'tz nin tzun cyulejtz. Nintzun e' quicy'al jun txob tza'j. Ej nin e' bentz swutz faraón. Yi cyopone'n nintzun je' ẍchitol Moisés yi tza'j tcya'j. Nin tan yi xtxolbile'j tircu'n tzun yi e' wunak tu cyakil e' txuc oc lac'puj yi xpok'on tx'a'c scye'j. ");
INSERT INTO aguBl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ma yi e' nachol cwent Egipto, qui'c nintzun oc cyajal tan pile'n yi cyetz quipisyo', na ncha'tz e' cyetz nsken oc lac'puj yi xpok'on tx'a'c scye'j, chi quitane'n yi e' mas aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Poro yi talma' faraón, mas tcunin stze'tzaxe'n tan Ryos. Cha'stzun te qui nin ocopon yi chiyol Moisés tu Aarón te wi'. Inin bana's, chi yi talnak Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Itzun bantz nintzun jilon junt tir Ryos tetz Moisés. Je tzun tale'j: —Moisés na waj yil cẍben ek jalchan tan yol tetz faraón. Ej nin ba'n tzawal tetz: “Je yol yi kajcaw yi kaRyosil yi o' hebrey: Ak'aj ama'l scyetz intanum tan chibene'n tan inc'u'laje'n le ama'l tz'inunin tu'. ");
INSERT INTO aguBl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Na ko quil tzawak' ama'l scyetz tan chibene'n tan inc'u'laje'n, tz'ul jun icaws wa'n yi chin xo'wbil nin. Nin yi jun icawsa'tz i'tz tetz icyakil, scyetz yi e' mas ajcaw nin scyetz cyakil wunak bantz tele'n itxum tetz yi qui'c junt Ryos bene'n tzi'n wi munt yi ni'cu'nk chi in. ");
INSERT INTO aguBl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ja klo' wi't cxsotzok wok wa'n scyuch' cyakil yi atanum. ");
INSERT INTO aguBl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Poro ja wak' ama'l tzitetz tan qui iquime'n, na na waj yil tzitil wok yi imporer. Nin ncha'tz na waj yil tz'el chitxum yi e' mas wunak wi munt yi in yi wi'tz Ryos bene'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","¿Nxac na awocsaj awib nim na qui na awak' ama'l tetz intanum tan chibene'n tan inc'u'laje'n le ama'l yi walnak scyetz? ");
INSERT INTO aguBl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ma jalu' bin, chwa'nin eklen tz'ul jun chin wutzile'n c'ub a'bal wa'n tetz icaws. Nin yi jun c'ub a'bala'tz chin xo'wbil nin sbne', na qui otojt na bajij yi jun xtxolbila's tzone'j Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Cha'stzun te ko na awaj yil chiclax yi e' awawun, ba'n tzajoy puntil tan chicolche'n, na yi jun c'ub a'bala'tz yi tz'ul, xcyek tan chibiyle'n cyakil yi e' wunak tu cyakil txuc yi ate' wi'ak cojbil, stzun Ryos bantz.” ");
INSERT INTO aguBl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Yi quibital yi e' ajcaw yi ate' xlaj faraón yi xtxolbile'j, at e' yi ja cyocsaj, nin ja chixobtz. Chibene'n tzun tan chicawe'n yi e' chimos tan chicolol quib xe'ak ca'l, ej nin ncha'tz tan chicolche'n yi cyawun. ");
INSERT INTO aguBl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Poro wi'nin e' yi qui nin cyocsaj yi yol Ryos. E' cyajcyen tu' yi cyawun wi cojbil. Ncha'tz chimos e' cyajcyen tu' wi cojbil. ");
INSERT INTO aguBl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Itzun le junt eklok nintzun tal Ryos tetz Moisés: —Moisés, ak'e'n yi ak'ab tcya'j tan saje'n c'ub a'bal squibaj cyakil wunak tu cyakil txuc nin tibaj cyakil yi ama'l bene'n tzi'n Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Inin tzun tulej Moisésa'tz chi tal Ryos tetz. Je'n tzun tk'ol yi k'ab tcya'j, nintzun saj ẍchitul Ryos jun chumam k'ancyok tu xlitz'. Ej nin saje'n nintzun ban yi c'ub a'bal, nin baj noj cyakil yi ama'l Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Qui otoj na bajij yi jun xtxolbila'tz Egipto, na sk'ejl tu lak'bal qui na tane' yi jun chin c'ub a'bala'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Tircu'n tzun yi ama'l cwent Egipto lo'on tan yi jun chin wutzile'n c'ub a'bala'tz. Wi'nin wunak e' quim. Ncha'tz e' quim wi'nin txuc. Nin cyakil yi tze' tu e'chk ujul e' baj lo'on. ");
INSERT INTO aguBl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ma le ama'l Gosén kale ate't yi e' xonl Israel qui'c nin jun c'ub a'bal cu'-tz. ");
INSERT INTO aguBl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Yi tilol yi rey yi xtxolbile'j nintzun ben mantar tan chichakle'n Moisés tu Aarón, nintzun taltz scyetz: —Ma jalu' ja el intxum tetz yi ja injuch wil swutz Ryos nin cyakil yi na bajij i'tz weri impaj scyuch' intanum. Nk'e'tz paj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Cha'stzun te ja wi't intxum tan wuk'ol ama'l tzitetz tan ibene'n tan c'u'laje'n yi iRyosil, na wi'nin kacaws ja ul, chi tane'n yi c'ub a'bale'j yi qui't na tane'. Ntin jakwok tetz iRyosil tan cuyul i' ketz kapaj, nin tan tanewe'n yi jun chin c'ub a'bale'j, stzun yi rey bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","—Quil bisunu' ta', na yil ne'l tzone'j ninin nocopon tan jakle'n tetz Ryos yi tajbilu'. Nin jun cu'n stanek yi jun c'ub a'bale'j nin ncha'tz cyakil yi k'ancyok yi at, bantz tele'n xtxumu' tetz, yi tetz Ryos cyakil yi ama'l bene'n tzi'n, nin i' na cawun tibaj. ");
INSERT INTO aguBl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Poro ta', na el intxum tetz yi qui na teku' ẍchi' Ryos. Ncha'tz quitane'n yi e' mas ajcaw yi ate' xlaju', txe'n nin cyek ẍchi' Ryos, stzun Moisés bantz tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Cyakil yi e'chk ujul chi tane'n yi lino tu yi cebada ja lo'on, na yi cebada sken wi't jal wutz. Ej nin yi lino nsken wi't jal xu'm. Cha'stzun te yi e'chk ujula'tz ja lo'on. ");
INSERT INTO aguBl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ma yi triw tu yi centeno qui'c ban na taxk jal wutz nin taxk jal xu'm. Na buch na jal wutz. ");
INSERT INTO aguBl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ma yi tele'n tzaj Moisés xe yi ca'l kale na cawune't faraón, ej nin yi pakxe'n le tetz ama'l nintzun octz tan nachle'n Kataj nin tan jakle'n tetz tan tanewe'n yi c'ub a'bal. Ninin tzun te rata'tz tanewe'n yi c'ub a'bal. Ej nin qui'ct k'ancyok bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Itzun bantz yi tilol faraón yi tanewe'n yi c'ub a'bal nin yi qui'c nin k'ancyok na cu' nin qui'ct na bajij, nintzun tze'tzax junt tir yi talma'. Ncha'tz e' ban yi mas ajcaw yi ate' xlaj tan cawu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Qui't tzun tak' i' ama'l scyetz yi e' xonl Israel tan cyele'n tzaj Egipto, na mas tcunin tze'tzaxe'n yi talma'. Tan yi xtxolbile'j el cunin te'j chi yi tal Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Nintzun tal Ryos junt tir tetz Moisés: —Na waj yi cẍben junt tir tan yol tetz faraón. Na ja tze'tzax yi talma' wa'n scyuch' yi e' mas ajcaw yi na chicawun xlaj. Ya'stzun nwulej na na waj tzimban wi'nin e'chk milawr ẍchiwutz tan inchajol imporer scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ncha'tz tajwe'n tan italol yi e'chk milawra'tz scyetz yi e' initxa' scyuch' yi e' imamaj tan tele'n chitxum tetz yi ẍe'n cu'n ban yi mme'l chik'ej yi e' aj Egipto wa'n bantz tele'n chitxum tetz yi in Jehová iRyosil, stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Chibene'n tzun Moisés tu Aarón tan yol tetz faraón. Yi cyopone'n nintzun cyaltz: —Je yol kaRyosile'j yi o' hebrey: “¿Tona' cẍoc juy tzinwutz? ¿Tona' tzawak' ama'l scyetz yi e' intanum tan chibene'n tan inc'u'laje'n le ama'l yi ja wi't wal scyetz? ");
INSERT INTO aguBl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Na ko quil tzawak' ama'l scyetz, ninin eklen tz'ul inchakol jun chin c'oloj sac' yi chinojk bene'n tzi'n Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Nin yi jun icawsa'tz chin xo'wbil nin sbne', na snojk cunin yi wuxtx'otx' ta'n. Ej nin sbajk cyakil yi e'chk takle'n cya'n yi e' clax cyen tan yi c'ub a'bal nin sbajk cyakil yi e'chk tze' cya'n yi at wi cojbil bene'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Chin xo'wbil nin sbne', na chocopon xe yi ca'lu' kale na cawune'tu'. Ncha'tz chocopon xe yi chica'l yi wi'tz bajxom yi ate' xlaju' tan cawu'n. Ncha'tz xe chica'l cyakil yi e' aj Egipto. Yi jun xtxolbile'j yi sbajok, qui otoj na bajij bene'n tzi'n wi munt nin sajle'n tunintz scye'j yi e' chimam chite'u',” stzun Ryos swetz, stzun Moisés. Yi wi't tlol Moisés yi xtxolbile'j nintzun el tzaj i' xe yi ca'l yi faraón: ");
INSERT INTO aguBl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Yi cyele'n tzaj Moisés nintzun cyal yi e' ajcaw yi ate' xlaj faraón. —Ta', ¿tona' ltane' yi jun yaja'tz tan kaxuxe'n? Ba'n tcu'n yi nink tak'u' ama'l scyetz yi e' tetz tanum tan chibene'n tan c'u'laje'n yi cyetz chiryosil, na ¿qui pe' na el xtxumu' tetz yi ja wi't el cu'n katanum swutz tan paj yi qui na tak'u' ama'l scyetz? che'ch tzun bantz tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Bene'n tzun mantar faraón tan chichakle'n Moisés tu Aarón. Yi cyopone'n nintzun taltz scyetz: —Ma jalu' ba'n cxben wok tan c'u'laje'n yi iRyosil. Poro alcyen swetz na' scyetz e' yi nchiben. ");
INSERT INTO aguBl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","—Kacyakil nkaben scyuch' yi e' kanitxa' tu yi e' katijl c'u'lal. Ncha'tz cyakil yi e' kawun. Na i'tz jun balaj k'ej yil skabne' swutz Ryos, stzun Moisés tetz rey. ");
INSERT INTO aguBl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","—Lajluch cunin yi mbi i ila'tz yi itxumu'n, nin i'tz tan insuble'n tu' na itajwok. Tan paj yi ya'tz nin itxumu'n quil xom Ryos tzite'j. Ncha'tz quil wak' ama'l tzitetz tan ibene'n icyakil cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ma na ntin swak'e' ama'l scyetz yi e' yaj tan chibene'n tan c'u'laje'n yi iRyosil na ya'stzun na itajwok. Nintzun e' el tzaj lajul faraón. ");
INSERT INTO aguBl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Poro nintzun jilon junt tir Ryos tetz Moisés. Itzun taltz: —Moisés ak'e'n ak'ab tcya'j tan achajol yi at imporer tibaj cyakil Egipto nin tan chisaje'n sac' tan bajse'n cyakil yi e'chk tze' yi nchiclax cyen tk'ab yi c'ub a'bal. ");
INSERT INTO aguBl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Nintzun je tk'ol Moisés yi xtx'amij tcya'j tibaj Egipto. Saje'n nintzun ban jun chin wutzile'n cyek'ek' tele'n tzi'n. Sk'ejl tu lak'bal ban yi jun chin wutzile'n cyek'ek'a'tz. Nin tul yi jun chin wutzile'n cyek'ek'a'tz cho'n cyule'n yi sac'. ");
INSERT INTO aguBl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Noje'n tzun cyakil Egipto cya'n. Qui otojt na bajij yi jun chin wutzile'n chicawsa'tz, nin quil bajij sbne' opon tunintz, na wi'nin sac' bantz te jun k'eja'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Wi'nin tzun sac' bantz nin tircu'n jopxe'n yi wuxtx'otx' cya'n. Ncha'tz baj cyakil xtze' cya'n, tuml yi e'chk tze' yi clax tk'ab yi c'ub a'bal. Qui'c nintzun jun wi' tze' ban cyen bene'n tzi'n Egipto. Ncha'tz cyakil e'chk xtze', tircu'n baj cya'n. ");
INSERT INTO aguBl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Yi tilol faraón yi xtxolbile'j nintzun ẍchak i' Moisés tu Aarón. Itzun taltz scyetz: —Ja injuch wil swutz Ryos nin ncha'tz tziwutz wok. ");
INSERT INTO aguBl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ma jalu' na waj tzinjak cuybil impaj tzitetz nin ncha'tz nachwok Kataj swibaj tan cuyul Ryos impaj nin tan telse'n yi jun chin wutzile'n incawse'j yi ja ul, stzun yi faraón bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Yi tbital Moisés yi xtxolbile'j nintzun el tzaj i' kale atite't faraón nin oc i'-tz tan nachle'n Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nintzun tbit Ryos yi oración Moisés. Xtx'ixpul tzun Ryos yi tojkbil yi cyek'ek'. Cho'n tzun saje'n yi cyek'ek' toque'n tzi'n. Nintzun icy' tcya'j yi e'chk sac' yi ate' Egipto. Cho'n tzun cyopone'n ta'n tul yi Cyak Mar. Qui'ct nin tzun jun sac' ban quentz Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ja til faraón cyakil yi xtxolbile'j, poro qui nin tak' ama'l scyetz yi e' xonl Israel tan cyele'n tzaj, na nsken tze'tzax yi talma' tan Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Itzun bantz nintzun jilon junt tir Ryos tetz Moisés, itzun taltz: —Ma jalu' Moisés ak'e'n ak'ab tcya'j. Ej nin tz'ocopon tz'o'tz wutz cya'j bene'n tzi'n Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ya'tz nin tzun tulej Moisés quib yi tal Ryos tetz. Na yi je'n tk'ol yi k'ab tcya'j oque'n nintzun ban tz'o'tz bene'n tzi'n Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ox cu'n tzun k'ej ban yi jun chin wutzile'n tz'o'tza'tz. Cya'l nin tzun jun wunak xon tbe', tunink xajse'n yi chiwisin. Ma ẍchixo'l yi e' xonl Israel qui'c tz'o'tz jal, ma na chin tkan k'ej nin tane'n. ");
INSERT INTO aguBl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Yi tilol faraón yi xtxolbile'j nintzun ben mantar tan ẍchakle'n Moisés. Yi topone'n Moisés nintzun taltz tetz: —Ma jalu' Moisés ba'n cxben wok tan c'u'laje'n yi iRyosil. Ej nin ba'n tzicy'aj wok nin cyakil yi ixna'nil scyuch' initxa'. Poro cyakil yi itawun ẍchicyajk tzone'j. ");
INSERT INTO aguBl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Stza'wel tzun Moisés tetz faraón: —Poro ta', ilu' tz'ak'on tetz cyakil yi e' txuc yi skabiye' nin yi skapate' tetz katx'ixwatz tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Poro qui', na cyakil yi ketz kawun nchiben xomok ske'j. Qui'c nin jun yi nink cyajcyen. Ma na tircu'n nchiben, na yil kopon chone'j kocopon tan chitxa'le'n cobox ẍchixo'l tan kak'ol tetz Ryos. Na te yi ntaxk kopon chone'j qui na el katxum tetz na' scyetz e' yil skoye' tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Poro qui nin tzun tak' faraón ama'l scyetz tan cyele'n na Ryos mak'on cyen le wi' tan stze'tzaxe'n yi talma' tan qui tk'ol ama'l scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ncha'tz tal faraón tetz Moisés: —Cawle'n tzone'j nin qui't na waj yil wil cu'n awutz junt tir tzone'j, na kol cẍu'l junt tir oknin cu'n le awi' yi ẍquimok wa'n, stzun faraón bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","—Jun cu'n yol qui't nu'l tan yol teru', stzun Moisés bantz tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Itzun bantz nintzun jilon Ryos tetz Moisés, itzun taltz: —Tajwe'n tan wak'ol junt caws faraón scyuch' cyakil yi e' aj Egipto. Ej nin yil tz'icy' yi jun chicawsa'tz stk'e' i' ama'l tzitetz tan itele'n wok tzone'j. Na i' te'nin faraón tz'ocopon tan ilaje'n len tan itele'n wok tzone'j. ");
INSERT INTO aguBl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Cha'stzun te alaj scyetz cyakil yi e' xonl Israel tan cyoque'n tan jakle'n e'chk oro tu sakal scyetz chiwisin yi aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Nintzun tak' Ryos yi banl squibaj yi e' xonl Israel na nin jal chibalajil ẍchiwutz cyakil yi e' aj Egipto. Ncha'tz e' ban yi e' ajcaw yi na chicawun xlaj faraón nin cyak' k'ej Moisés. Ej nin cyakil yi e' aj Egipto chumbalaj nin e' bantz scye'j yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ej itzun ban, nin tal Moisés tetz faraón: —Ta' faraón je yol yi ketz kaRyosil: “Chin xonk ẍchixo'l yi e' aj Egipto axen nicy'ak'bal. ");
INSERT INTO aguBl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ej nin ẍchiquimok cyakil yi bajx cy'ajol wa'n. Chicyakil cu'n ẍchiquimok. Qui'c na ban ko at chik'ej chitaj nka qui'c. Chi tane'n yi faraón yi at k'ej, squimok yi bajx cy'ajl wa'n, nin yi e' yi qui'c chik'ej chi quitane'n yi e' yi na chak'uj wi cojbil ẍchiquimok yi cyetz wa'n. Ncha'tz ẍchibne' yi bajx cyal yi e' txuc. Tircu'n ẍchiquimok. ");
INSERT INTO aguBl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Wi'nin tzun bis o'kl sbajoktz bene'n tzi'n Egipto. Wi'nin e' chiẍch'ink tan bis na qui otojt na bajij yi xtxolbile'j ẍchixo'l.” ");
INSERT INTO aguBl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Nin tan tele'n chitxumu' tetz yi apart yi o' xonl Israel ẍchiwutz yi e' aj Egipto, siquier nink jun tx'i' yi nink wojon cyen te jun xonl Israel, mpe ik te cyawun. ");
INSERT INTO aguBl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ma jalu' chicyakil cu'n tzun yi e' wi'tz ajcawe'j, chu'l tan cu'swutzil tzinwutz nin chicopon mejlok tzinwutz. Ej nin scyale' swetz: “Bne'u' pawor ta' tan cyele'nu' scyuch' cyakil tanumu'.” Poro ko quil chiban yi xtxolbile'j quil ke'l, stzun Moisés bantz tetz yi rey. Wi'nin tzun ẍchi'che'n c'u'l Moisés yi tele'n tzajtz tan yol tetz faraón. ");
INSERT INTO aguBl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Bene'n tzun tlol Ryos tetz Moisés: —Jun cu'n yol quil tak' faraón ama'l tzitetz tan itele'n. Ma na tajwe'n cu'n tan inchajol mas e'chk milawr tzone'j Egipto kalena'tz tzun ltak' ama'l tan itele'n, stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ja bnix cyakil e'chk milawra'tz swutz faraón cya'n Moisés tu Aarón. Poro yi tetz faraón mas tcunin stze'tzaxe'n talma' tan Ryos na qui nin tak' i' ama'l tan cyele'n yi e' xonl Israel Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Itzun bantz nintzun jilont Ryos tetz Moisés tu Aarón le ama'l Egipto, itzun tal scyetz: ");
INSERT INTO aguBl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Yi jun xawe'j tz'ocopon tetz bajx xaw tetz yi yob nin sbne' opon tunintz bajx xaw sbne'. ");
INSERT INTO aguBl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Cha'stzun te alwok scyetz cyakil yi e' xonl Israel yi xtxolbile'j: ‘Tul yi lajuj tajlal yi xawe'j, tajwe'n tan chijoyol yi jujun najal jun cne'r nka jun chiw tan cyoyil swetz, jun le jujun najal. ");
INSERT INTO aguBl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ma ko cobox intzi' chixone'n jun najal nin qui nin chixcye' tan bajse'n jun cne'r nka jun chiw, ba'n tzun chijilon tetz yi chiwisin yi at mas naka'j. Junit tzun chiban tan bajse'n yi jun txuca'tz. Ba'n chijatx cu'n ẍchixo'l. Tunin xomquen cya'n te cyajlal le jujun najal. ");
INSERT INTO aguBl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Tajwe'n yi tzijoy wok jun cne'r yi mam yi ja wi't tz'ak jun yob ta'n, nin yi qui'c mu'ẍ tal yana'sil. Qui'c na ban yi ko cne'r nka chiw. ");
INSERT INTO aguBl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Yil jal yi cneru' nka yi chiw tajwe'n tan colche'n, jalen yil jepon yi cyajlaj tajlal yi xaw tajwe'n tan cwe'n ibiyol. Poro ba'n tzibiy wok cu'n cwe'n k'ej. ");
INSERT INTO aguBl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kalel baje't yi jun cne'ra'tz, ba'n tzisuk' wok cyen yi ẍch'el te'jak yi marquil yi puertil ica'l. ");
INSERT INTO aguBl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Yi jun cne'ra'tz ba'n tzibajswok ninin te ak'bala'tz nin boxij tzitulej wok. Ba'n tzibajsaj wok tu e'chk c'a' itzaj tu pam yi qui'c xtx'amil. ");
INSERT INTO aguBl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Qui'c cuj tan ibajsal yi chibaj yi txa'xenlen nka yi txiquij sban, ma na cyakil yi tkan tu yi wi' tu cyakil yi talma' nka yi e'chk takle'n yi at tc'u'l, cyakil boxij cu'n sbne'. ");
INSERT INTO aguBl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Nin tajwe'n tan ibajsal cyakil. Na qui tajwe'n tan sowrine'n nin kol sowrin ba'n tcu'n yi tzitz'e'swok cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Nin ncha'tz bajx wekwok itib, banwok list te be'ch itetz, nin yi ixajab. Ej nin tz'amwoke'n yi itx'amij, kalena's tzun ba'n tzibajswoke'n yi cne'r lajke'l na ya'stzun yi Pasc tetz Kataj. ");
INSERT INTO aguBl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Na te yi ak'bala'tz nicy'ak tan chibiyle'n cyakil yi e' bajx chicy'ajl yi e' aj Egipto. Ncha'tz wulej yi bajx cyal yi e' txuc, nin wak'e' chicaws yi e'chk ryos cwent Egipto. Tz'elepon cu'n te'j yi xtxolbile'j na i'tz inyol yi in iTaj Jehová. ");
INSERT INTO aguBl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","’Ma yi chich' yi tz'ocopon ita'n te marquil yi puertil ica'l, xconk tetz jun techl yi cho'n atixwok le ca'la'tz tan qui iquime'n, na yil wil yi at chich' te'jak puert nicy'pon nin quil cxquim wok, na cyakil yi e' aj Egipto ẍchiquimok wa'n. ");
INSERT INTO aguBl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ba'n tzinach wok cu'n yi jun k'eja'tz, na i'tz jun balaj k'ej nin tzibne' wok jun balaj k'ej tetz Kataj. Na yi jun k'eja'tz tajwe'n tan ibnol wok tane'n chi jun ley. Nin sbne' opon tunintz tajwe'n tan chibnol tane'n yi initxa' tu cyakil yi e' imamaj. ");
INSERT INTO aguBl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ncha'tz sbajk pam yi qui'c xtx'amil ita'n, tetz juk k'ej, nin yil xe'tij yi bajx k'ej tajwe'n yi qui'c mu'ẍ xtx'amil pam yi nink jal le jun ca'l. Nin yi jun yil baj yi pam yi at xtx'amil ta'n tul yi juk k'eja'tz, tz'elpon laju'n tzixo'l wok. ");
INSERT INTO aguBl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Le bajx k'ej tu yi wi'tzbil k'ej tajwe'n tan imolol itib tan banle'n jun balaj k'eja'tz. Tul yi cob k'eja'tz cya'l jun tz'ak'uj, ntin cu'n tan banle'n yi iwa' ba'n cxak'uj jun rat, na yi cob k'eja'tz chin xan nin. ");
INSERT INTO aguBl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Yi jun k'eja'tz tetz yi pam yi qui'c xtx'amil i'tz jun balaj k'ej yi tajwe'n tan ticy'e'n wutz k'ej ita'n, na ya'stzun yi k'ej yi xelepon wok tzone'j Egipto. Cha'stzun te tzibne' wok tane'n yi jun k'eja'tz sbne' opon tunintz, nin i'tz jun ley yi tajwe'n tan ibnol tane'n, nin tan chibnol tane'n yi e' initxa'. ");
INSERT INTO aguBl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Sbajk yi pam yi qui'c xtx'amil ita'n. Juk k'ej sbne', na cxe'tok wok tan bajse'n cwe'n k'ej le cyajlaj tajlal yi bajx xaw tetz yi yob, jalen cwe'n k'ej le junakjun tajlal yi ite'n nin xawa'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Tul yi juk k'eja'tz qui'c cuj tan jale'n mu'ẍ xtx'amil pam le jun ca'l. Na cyakil yi e' yi sbajk pam cya'n yi at xtx'amil, juncu'n chelepon laju'n tzixo'l wok. Qui'c na ban ko awer nak i' nka mero xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Cha'stzun te cya'l jun bajsan yi e'chk takle'n yi at xtx'amil. Ma na ba'n tzibajswok yi e'chk takle'n yi qui'c xtx'amil alchok atixe't nin alchok ama'lil yi xa't cu'nt,’ ” stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Itzun bantz nintzun el mantar tan Moisés tan chichakle'n cyakil yi e' wi' banl wi' tetz Israel. Nintzun taltz scyetz: “E'u' jun c'oloj kacmon chibenku' tan ticy'le'n jun ne'ẍ cneru' nka jun chiw, jujun le jun najbil. Ba'n chibiycu'nu' na skabne' jun balaj k'ej yi i'tz yi Pasc. ");
INSERT INTO aguBl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ma yi ẍch'el yi cne'r ba'n molxij tul jun plancan nin yil molxij ba'n tzun chijoyu' jun tal sbil nka jun k'ab xtze' tan suk'le'n cyen te'jak yi marquil yi chipuertu'. Cya'l tzun jun tz'el tzajtz te ak'bala'tz jalen yil tz'ul skil. ");
INSERT INTO aguBl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Na yil tz'icy'ak yi Kataj tan chibiyle'n cyakil yi bajx chicy'ajl yi e' aj Egipto stile' yi at yi chich' te'jak yi marquil yi chipuertu'. Nin yil til yi at chich' te'jak yi chipuertu' tz'icy'pon tzun i'-tz, nin quil chiquim yi e' bajx chicy'ajlu' ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Nin yi jun ca'wle'j tajwe'n tan chibnolu' tane'n scyuch' cyakil yi chixonlu' sbne' opon tunintz. ");
INSERT INTO aguBl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Nin yil choponu' le ama'l yi suki'nt tan Ryos scyeru' tajwe'n tan chibnolu' tane'n yi jun xtxolbila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ej nin yil chijak yi chinitxajilu' scyeru' yi mbi xac yi jun k'eja'tz yi na chibanu', ");
INSERT INTO aguBl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ba'n cyalu': ‘Yi jun k'eja'tz yi na icy' skaxo'l i'tz Pasc nin yi na quim yi cne'r i'tz jun katx'ixwatz tan tak'le'n k'ej Kataj. Na yi chiquime'n yi bajx chicy'ajl yi e' aj Egipto ta'n, qui'c nintzun oc tajaltz scye'j yi bajx chicy'ajl yi xonl Israel yi ate'-tz Egipto. Cha'stzun te chiclaxe'n cyakil cu'n yi e' kaxonl,’ ” stzun Moisés bantz scyetz cyakil cu'n yi e' xonl Israel. Yi quibital yi e' xonl Israel yi xtxolbile'j chicwe'n tzun mejloktz tan tak'le'n k'ej Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ej nin e' ban tane'n cyakil yi xtxolbil yi tal Ryos tetz Moisés tu Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Itzun bantz yi topone'n nicy'ak'bal nintzun e' quim cyakil yi bajx chicy'ajl yi e' aj Egipto tan Ryos. Tircu'n tzun e' quimtz, qui'c na ban yi ko ric nka me'ba', chi tane'n yi bajx cy'ajl faraón jalen te yi bajx cy'ajl yi yaj yi at pres. Ncha'tz ban yi bajx cyal cyakil yi e' txuc. Tircu'n chiquime'n. ");
INSERT INTO aguBl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Yi chiquime'n, tircu'n tzun yi e' wunak e' baj c'as len. Ncha'tz ban faraón scyuch' yi e' mas ajcaw yi ate' xlaj tan cawu'n. Chin bisbil nin ban yi jun ak'bala'tz na cyakil cunin yi e' wunak na chok' len tan bis, na qui'c nin jun najal yi qui'k jun alma' scyuch'. ");
INSERT INTO aguBl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ite'n nin te rata'tz bene'n mantar yi faraón tan chichakle'n Moisés tu Aarón. Ma yi cyopone'n Moisés nintzun taltz scyetz: —Ma jalu' Moisés, ba'n tcu'n quilo'k wok tan c'u'laje'n yi iRyosil chi yi na cxtzan wok tan talche'n. Na ba'n tcu'n yi cxe'l wok skaxo'l. ");
INSERT INTO aguBl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ba'n cxben wok icyakil cu'n, cy'aj wok nin cyakil yi itawun chi yi txumijt ita'n. Ba'n cxe'l wok ninin jalu' nin nachwok tu' Kataj swibaj, stzun yi faraón bantz scyetz Moisés tu Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Itzun yi e' wunak cwent Egipto cyoque'n tzuntz tan chilaje'n len yi e' xonl Israel yi ate' ẍchixo'l. Na nin e' oc tan xtxumle'n ko tzun chiquim chicyakil cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Lajke'l nintzun cyoque'n yi e' xonl Israel tan cu'se'n yi k'otil pam yi ntaxk cu' xtx'amil cy'a'n tulak yi cu'lbil, nin tircu'n tu yi cu'lbil cwe'n quik'ol tulak chixbu'k nin baj je' cyekaltz. ");
INSERT INTO aguBl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ncha'tz cawunin Moisés scyetz cyakil yi e' xonl Israel tan chibene'n tan jakle'n oro tu sakal nin e'chk be'chok scyetz yi e' aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Toque'n tzun tk'ol Ryos le chitxumu'n yi e' aj Egipto tan quik'ol cyakil yi mbi cu'n na chijak yi e' xonl Israel scyetz, nin tan yi xtxolbile'j el tzaj quicy'al cyakil chime'bi'l yi e' aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Itzun bantz ele'n tzaj nintzun e' ban yi e' xonl Israel le ama'l Ramsés tan cyopone'n Sucot. Yi cyajlal yi cyele'n tzaj i'tz kak cient mil chixone'n yi e' yaj yi nsken tz'ak chitiemp nka yi e' yi nsken opon chitiemp tetz sanlari'n. Qui e' oc yi e' xna'n tu nitxa' cyajlal. ");
INSERT INTO aguBl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Wi'nin tzun wunak yi nk'e'tz e' xonl Israel e' xomnin ẍchixo'l. Ncha'tz wi'nin wacẍ tu cne'r e' xomnin scye'j. ");
INSERT INTO aguBl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Nin tan paj yi ojke'l yi cyele'n tzaj qui nin bnix chiwa' tetz chibe', na nin e' oc yi e' aj Egipto tan chilaje'n len le cyetz chitanum. Cyoque'n tzuntz tan banle'n pam te yi k'ot yi cy'a'n cya'n. Na ntaxk tx'amin. ");
INSERT INTO aguBl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Cyaj cient tu junaklaj yob e' a'tij yi e' xonl Israel le ama'l Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Na nintzun tz'ak yi cyaj cient tu junaklaj yoba'tz cya'n te yi k'eja'tz yi cyele'n tzaj. Chicwe'n tzun chicyakil yi tanum Ryos tbe'. ");
INSERT INTO aguBl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Te yi jun ak'bala'tz Ryos oc tan chiq'uicy'le'n nin tan cyelsene'l tzaj Egipto. Cha'stzun te yi jun ak'bala'tz i'tz tetz Kataj, na ya'stzun yi ak'bal tan tak'le'n k'ej i'. Ej nin chin tajwe'n cunin tan china'wsal yi e' xonl Israel yi jun ak'bala'tz sbne' opon tunintz. Ncha'tz ẍchibne' yi e' chixonl tajwe'n tan china'wsal yi jun k'eja'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Jilone'n tzun Ryos tetz Moisés tu Aarón itzun taltz: “Je cobox ca'wle'j yi tajwe'n tan ixome'n te'j tan ticy'se'n Pasc: Qui'c cuj tan bajsal jun awer wunak yi ẍchi'bel yi txuc yi spat-xok tetz itx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Poro ko at jun imos yi lok'ij tane'n ba'n sbajsaj i' ntin ko banij circuncidar. ");
INSERT INTO aguBl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Qui'c cuj tan bajsal jun awer wunak yi ẍchi'bel yi txuc yi na ipat tetz itx'ixwatz, mpe ik jun awer wunak yi na icy' cu'n tzixo'l wok nka jun imos yi na ichoj wok tan ak'un, qui'c cuj tan baje'n ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Nin yi chi'baj tajwe'n tan baje'n cyak'un yi jujun najal xe'ak chica'l. Na cya'l jun tz'elsan tzaj yi chi'baj xe ca'l, nin cya'l jun puch'un cu'n siquier jun scyeri bakil yi itx'ixwatza'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ej nin yi jun xtxolbile'j tajwe'n tan ibnol tane'n yi axwok xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Poro ko at jun awer wunak yi at tzixo'l yi na taj yil sban tane'n yi Pasc tan tak'le'n k'ej Kataj, tajwe'n tan bnol circuncidar tib. Ncha'tz cyakil yi e' yaj yi ate' le najbil i' tajwe'n tan chibnol circuncidar quib. Ej nin kalena's tzun sban tane'n yi jun k'eja'tz. Na ni'cu'n tzun sbne' i'-tz chi jun mero xonl Israel. Poro ko nk'e'tz circuncidado qui'c cuj tan baje'n ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ite'n nintzun leya'tz xconk scyetz yi e' awer nak yi nchitz'ij nin yi e' yi ate' tzixo'l wok.” ");
INSERT INTO aguBl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ma yi e' xonl Israel, nintzun e' ban tane'n cyakil yi xtxolbil quib yi tal Ryos scyetz Moisés tu Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ite'n nintzun k'eja'tz cyele'n tzaj tcy'al Ryos yi tanum jak' ca'wl faraón chi jun k'u'j sanlar tane'n. ");
INSERT INTO aguBl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ncha'tz tal Ryos tetz Moisés: ");
INSERT INTO aguBl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Jatx wok cyakil bajx icy'ajl, tan chixcone'n swetz. Na cyakil yi bajx icy'ajl yi axwok xonl Israel, e' cu'n wetz. Ncha'tz cyakil yi bajx cyal yi itawun e' cu'n wetz,” stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Yi tbital Moisés yi xtxolbile'j nintzun bentz tan talche'n scyetz cyakil yi tanum. Poro bajx talol i' yi yole'j: “Sbne' opon tunintz tajwe'n tan china'wsalu' yi jun k'eje'j yi ẍe'n cu'n ban Ryos tan cyelsene'l tzaju' jak' chica'wl yi e' aj Egipto tan yi tetz porer kale ate'tu' tetz esclaw. Nin te yi jun k'eja'tz qui'c cu tan chibajsalu' pam yi at xtx'amil. ");
INSERT INTO aguBl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Chinach cu'nu' yi tajlal yi xaw te yi jun k'eje'j yi i'tz jun k'ej tetz xaw Abib. ");
INSERT INTO aguBl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ej nin yil choponu' le ama'l yi suknak Ryos scyetz yi e' kamam kate', yi jun ama'la'tz yi chumbalaj nin, kale najlche't yi e' cananeo, e' hitita, e' amorreo, e' heveo tu e' jebuseo, tajwe'n tan china'wsalu' yi jun k'eje'j cyakil tiemp. ");
INSERT INTO aguBl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Yil tz'icy' yi jun balaj k'eja'tz cyanu' ba'n chibajsaju' yi pam yi qui'c xtx'amil. Juk k'ej chibanu' tan bajse'n. Poro le juki'n k'eja'tz ba'n chibanu' jun balaj k'ej tan tak'le'n k'ej Kajcaw. ");
INSERT INTO aguBl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Tul yi juk k'eja'tz ntin pam yi qui'c xtx'amil sbajk cyanu'. Ej nin qui'c cuj tan jale'n mu'ẍ xtx'amil pam ẍchixo'lu', nka jun pam yi at xtx'amil. ");
INSERT INTO aguBl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ej nin tul yi jun k'eja'tz ba'n cyalu' scyetz chinitxajilu' yi mbi na elepont yi k'eja'tz. Ej nin ba'n cyalu' scyetz: ‘Yi jun xtxolbile'j i'tz tan na'wse'n yi k'ejlal yi kele'n tzaj tan Ryos jak' chica'wl yi e' aj Egipto,’ che'chu' sban scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Tajwe'n cunin tan quicy'salu' yi jun k'eja'tz na ni'cu'n sbne' chi atk jun techl wutz chik'abu' nka wutzak chiplaju' tan na'wse'n scyeru' yi tajwe'n tan china'wsalu' yi ca'wl Ryos. Na tan tu' yi porer i' nche'lsan tzaju' jak' chica'wl yi e' aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Cha'stzun te tajwe'n tan ticy'e'n yi jun k'eja'tz cyanu' cyakil yob le xawe'j. ");
INSERT INTO aguBl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","”Ej ncha'tz yil choponu' tan Ryos le chiluwar yi e' aj Canaán, yi ama'l yi suknak i' scyeru', nin scyetz yi e' chimam chite'u', ");
INSERT INTO aguBl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","tajwe'n yil chijatxu' yi bajx chicy'ajlu' tetz Ryos. Ncha'tz cyakil yi bajx cyal yi cyawunu' yi mam, tajwe'n yil cyak'u' tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ma yi bajx cyal yi e' buru' ba'n chitx'exu' tu jun tal ne'ẍ cne'r nka tu jun tal chiw. Poro ko qui na cyaju' yil chitx'exu' ba'n chiwak'e'nu' yi kul. Ncha'tz na taj yil chibanu' te yi bajx chicy'ajlu'. Tajwe'n yil chitx'exu' tu jun ne'ẍ cne'r tan claxe'n. ");
INSERT INTO aguBl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ej nin tzantzaj yil chijak yi e' chinitxajilu' yi mbi na elepont yi xtxolbile'j, ba'n cyalu' scyetz: ‘Na kaban yi xtxolbile'j tan na'wse'n yi ẍe'n cunin ban Ryos tu yi tetz porer tan kelse'ne'l tzaj jak' chica'wl yi e' aj Egipto kale o' a'te't tetz esclaw jak' chica'wl. ");
INSERT INTO aguBl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Na yi stze'tzaxe'n yi talma' faraón yi qui nin tak' i' ama'l sketz tan kele'n tzaj ẍchixo'l, ja chiquim cyakil yi bajx chicy'ajl yi e' aj Egipto tan Ryos. Ncha'tz ban yi bajx cyal yi e' txuc. Cha'stzun te na koy yi bajx cyal yi e' txuc tetz Ryos, nin ncha'tz na kak' jun ne'ẍ cne'r tan qui chiquime'n yi bajx kacy'ajl. ");
INSERT INTO aguBl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Nin yi jun xtxolbile'j ni'cu'nk chi atk jun techl sbne' wutz ik'ab nka wutz iplaj tan na'wse'n tzitetz yi ẍe'n cunin ban Ryos tu yi tetz porer tan kelse'ne'l tzaj Egipto,’ che'chu' sban scyetz chinitxajilu'.” ");
INSERT INTO aguBl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Itzun bantz yi tk'ol faraón ama'l scyetz yi e' xonl Israel tan cyele'n tzaj Egipto, qui nin e' ben tcy'al Ryos le be' yi quenin na opon le ama'l ẍchixo'l yi e' filistey. Na nin oc Ryos tan xtxumle'n ko tzun chipakxij junt tir Egipto yil cho'c yi e' filistey tan oyintzi' scye'j. ");
INSERT INTO aguBl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Cha'stzun te e' bene'n tcy'al le ama'l tz'inunin tu' tan cyopone'n stzi' yi Cyak Mar. Yi cyele'n tzaj yi e' xonl Israel Egipto cho'n cunin e' ban chi na chiban ala' k'u'j sanlar. ");
INSERT INTO aguBl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ma tetz Moisés nintzun cawunin tan bene'n quicy'al yi bakil k'ajtzun Ẍep. Na, cawun cyen i' scyetz yi e' xonl tan chibnol yi xtxolbile'j. Nin je yol i'e'j: “Jun cu'n yol wale' cyen tzitetz yi tz'ocopon Ryos tan ich'eye'n nin tan itelse'n tzone'j. Nin yil bajij yi je'j tajwe'n tan bene'n itcy'al yi imbakil tzite'j,” stzun Ẍep banak cyen. ");
INSERT INTO aguBl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Yi cyele'n tzaj yi e' xonl Israel le ama'l Sucot cwent Egipto, cho'n tzun cyopone'n le ama'l Etam stzi' yi ama'l tz'inunin tu'. ");
INSERT INTO aguBl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ej nin yi na chixon chajk'ej bajxij Ryos ẍchiwutz tul jun boc'oj sbak' tan ẍchajle'n yi chibe'. Ma lak'bal bajxij Ryos ẍchiwutz tul jun boc'oj k'ak' tan xtxeke'n chibe'. Cha'stzun te ja chixon sk'ejl nin lak'bal. ");
INSERT INTO aguBl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Bajx cuntunin yi jun boc'oj sbak'a'tz ẍchiwutz chajk'ej. Ma lak'bal bajx cuntunin yi jun boc'oj k'ak'a'tz ẍchiwutz tan xtxeke'n yi chibe'. ");
INSERT INTO aguBl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Itzun bantz nintzun jilont Ryos tetz Moisés. Itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Moisés, alaj scyetz cyakil yi e' xonl Israel tan chipakxe'n, nin tan cyopone'n swutz yi ama'l Pi-hahirot yi at txo'l Migdol tu yi mar, nin xlaj yi ama'l Baal-zefón. Ba'n cha'tij cobox k'ej le ama'la'tz nin ba'n je' cobox k'ej chipach swutz yi ama'la'tz yi at swutz yi mar. ");
INSERT INTO aguBl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Nin yil tbit faraón yi cho'n atixwok le ama'la'tz, stale' i': ‘Yi e' xonl Israel qui't na pujx cya'n na'l cha'j nint. Nin tx'akxnake' tul yi ama'l tz'inunin tu'.’ ");
INSERT INTO aguBl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nin ncha'tz tzintx'ixpuj yi tajtza'kl faraón tan saje'n i' tan itz'amle'n. Poro quil cxbisun wok na tzinchaje' yi imporer tan yi e'chk takle'n yi tzimbne' te'j i' nin scye'j yi e' tetz sanlar. Ej nin yil tzimban yi xtxolbile'j tz'elepon chitxum cyakil yi e' aj Egipto tetz yi in yi wi'tz Ajcaw,” stzun Ryos bantz. Ya'tz nin tzun cyulej yi e' xonl Israel quib yi tal Ryos scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Itzun bantz yi tbital faraón scyuch' yi e' ajcaw yi na chicawun xlaj yi nsken che'l ojk yi e' xonl Israel, nintzun je' xtx'ixpul yi xtxumu'n scye'j. Itzun cyaltz: “¿Ẍe'n tzun ban yi kak'ol ama'l scyetz yi e' xonl Israel tan cyele'n skaxo'l, nin tan qui cyak'uje'n ske'j?” che'ch tzun e' bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Nintzun cawunin yi rey tan wekle'n yi tetz care't tetz oyintzi', nin cawunin tan chiwekle'n jun c'oloj sanlar, tan chixome'n nin te'j. Ben tcy'al cyakil yi tetz care't tetz oyintzi'. ");
INSERT INTO aguBl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ncha'tz e' xom nin kak cient balaj care't tetz oyintzi' yi at len jun ajcaw tetz sanlar tul. ");
INSERT INTO aguBl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mas tcunin tzun stze'tzaxe'n yi talma' yi rey tan Ryos tan bene'n i' tan chitz'amle'n yi e' xonl Israel yi sk'il cu'n cyele'n tzaj tzak' chica'wl. ");
INSERT INTO aguBl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Cyele'n tzaj tzun yi e' sanlar cwent Egipto tu cyakil chicare't tetz oyintzi' tu cyakil yi e' sanlar yi ate'e'n te'jak chichej, tan chitz'amle'n yi e' xonl Israel. Cho'n tzun e' tx'amxe'n yi e' xonl Israel cyak'un stzi' yi mar, xlaj yi ama'l Pi-hahirot nin swutz yi ama'l Baal-zefón. Na cho'n chicyaje'n cyen yi e' xonl Israel le ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Yi quilol yi e' xonl Israel yi topone'n faraón tu cyakil yi e' tetz sanlar yi xomche' te'j tu e'chk care't tetz oyintzi', nintzun e' xobtz, nin e' oc tan jakle'n ẍch'eybil cyetz tetz Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Poro nintzun e' oc tan yajle'n Moisés. Itzun cyaltz tetz: —Moisés ¿nxac nke'l tzaj acy'al Egipto tan kaquime'n tzone'j le ama'l tz'inunin tu'? Mas balaj klo' cho'nk nkaquim Egipto. ¿Nxac maban yi juna'tz ske'j? ¿Nxac nke'l tzaj acy'al? ");
INSERT INTO aguBl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ya'tz nintzun kal tzatz yi ato' tzaj Egipto. Je bin kayol kal tzatze'j: “Ak'aj ama'l sketz tan kak'uje'n jak' chica'wl yi e' aj Egipto, na mas balaj yi tz'icy'pon yi buchbe'n ketz ka'n swutz yil kaquim le ama'l tz'inunin tu'.” ");
INSERT INTO aguBl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Yi tbital Moisés yi chiyol nintzun tal i' scyetz: —E'u' intanum, quil chibisunu', nin quil chixobu'. Quiwit yi cyeru'. K'ukek chic'u'lu' te'j Kajcaw. Na ẍchaje' i' yi tetz porer sketz jalu', nin jun cu'n skaclaxok ta'n. Nin yi e' kacontr yi na kil nin chiwutz jalcu'n, qui't kil chiwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Cha'stzun te quil chibisunu', na nk'e'tz tajwe'n yil ko'c tan oyintzi' scyuch' ma na Ryos tz'ocopon tan oyintzi' scye'j tetz kaxel, stzun Moisés ban scyetz yi e' tanum yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Nintzun tal Ryos tetz Moisés: —Moisés ¿nxac na cẍtzan tan jakle'n swetz yi mbi tajwe'n tan abnol? Cawunin scyetz yi e' xonl Israel tan chicwe'n junt tir tbe'. ");
INSERT INTO aguBl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ma atz, cy'aje'n yi atx'amij, nin chajnin tibaj yi mar tan cwe'n jatxol tib. Bantz quicy'e'n yi xonl Israel tul. ");
INSERT INTO aguBl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ma in wetz swak'e' cyen le chitxumu'n yi e' aj Egipto tan chixome'n tzaj tan itz'amle'n wok. Poro quil cxbisun wok na tzinchaje' yi imporer tetz faraón scyuch' yi e' tetz sanlar, nin scyetz yi e' yi ate'e'n te chichej. ");
INSERT INTO aguBl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Nin yil tzinchaj yi imporer yil no'c tan chixite'n faraón scyuch' yi e' mas sanlar yi xomche' te'j, scyuch' yi e' yi ate'e'n te chej, tz'elepon tzun chitxum tircu'n yi e' aj Egipto tetz yi in yi wi'tz Ajcaw, stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Itzun yi ángel yi bajxij ẍchiwutz nintzun xtx'ixpuj yi luwar kale ate't. Ncha'tz ban yi jun boc'oj sbak'. Cho'n bajxche' ẍchiwutz yi xonl Israel, poro cho'n e' cyaje'n cyen wutz chicoc. ");
INSERT INTO aguBl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Cho'n tzun e' cyaje'n cyen ẍchixo'l yi e' sanlar tetz Egipto scyuch' yi e' xonl Israel. Yi jun boc'oj sbak'a'tz xcye' tan tak'le'n tz'o'tz scyetz yi aj Egipto, ma scyetz yi e' xonl Israel xcon tan chitxeke'n te yi jun ak'bala'tz. Cha'stzun te qui nin e' xcye' yi e' sanlar tetz Egipto tan chitz'amle'n yi e' xonl Israel te jun ak'bala'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ma tetz Moisés inin tzun tuleja'tz quib yi tal Ryos tetz, nin ben ẍchajol yi xtx'amij wi mar. Yi bnol i' yi xtxolbile'j nintzun saj jun chin wutzile'n cyek'ek' tan Ryos tele'n tzi'n. Baj cunin ak'bal tan yi jun cyek'ek'a'tz. Cwe'n tzun jatxol yi mar. Cob cuntu' el ta'n. Ya'stzun tulej Ryos tan skejse'n yi mar kale e' icy'e't cu'n yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Chin skej nintzun ban chibe' yi xonl Israel kale e' icy'e't. Na yi a' nintzun oc chi cob tapij ẍchixlajak. ");
INSERT INTO aguBl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Tircu'n tzun yi e' sanlar tetz yi faraón yi ate' te'j chej tu cyakil yi e' yi ate' tul care't e' xom nin tan chitz'amle'n yi e' xonl Israel, jalen nicy'al mar. ");
INSERT INTO aguBl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Poro yi tule'n skil cho'n na xmayin tzaj Ryos tul yi jun boc'oj sbak' tu k'ak'. Yi tilol yi mbi na chiban yi e' aj Egipto nintzun octz tan chixite'n cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Po'te'n tzun yi tolo'il yi chicare't. Pentlen tunin na chixon. Itzun cyaltz: —Ke'lken ojk ẍchiwutz yi e' xonl Israel na i Ryos na tzan tan oyintzi' ske'j, che'ch tzun yi e' sanlar tetz Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Te yi rata'tz nintzun tal Ryos tetz Moisés: —Moisés chaj nin ak'ab tibaj yi mar tan cwe'n jopol tib yi mar nin tan cwe'n squibaj yi e' sanlar cwent Egipto tu cyakil yi e' yi ate' tib chej nin tul chicare't. ");
INSERT INTO aguBl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","I nin tulej Moisés quib yi tal Ryos tetz. Je'n tzun ẍchajol Moisés yi k'ab tibaj yi mar. Yi tule'n skil sken bnix yi mar chi tane'n nin yi taxk chicy' yi e' xonl Israel tibaj. Ma yi quilol yi e' aj Egipto yi xtxolbile'j nintzun klo' e' el ojktz, poro qui' nin na nsken jopx yi chibe'. Ta'tz te'nin e' cyaje'n cyen cyakil yi e' sanlar tetz Egipto xe mar. Na Ryos nchimulk'un nin xe mar. ");
INSERT INTO aguBl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Yi taje'n junt tir yi mar chi tane'n nin tircu'n tzun yi e' sanlar cwent Egipto e' bek'xij. Tircu'n e' bek'xe'n yi e' yi e' xom nin tan chitz'amle'n yi e' xonl Israel. Qui'c nin jun yi nink clax, ma na tircu'n chiquime'n. ");
INSERT INTO aguBl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Poro yi e' xonl Israel sk'il cu'n quicy'e'n, na skej yi chibe' kale e' icy'e't, na cob cuntu' el yi mar. At jun tx'akaj yi cyaj cyen le chimax nin junt tx'akaj le chisbal, chi cob tapij ban ẍchixlaj. ");
INSERT INTO aguBl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Te yi jun k'eja'tz ja che' col Ryos yi e' xonl Israel ẍchik'ab cyakil yi e' aj Egipto. Na yi e' xonl Israel quil chiwankil cyakil yi e' aj Egipto yi e' quim xe mar. Cho'n sanlche'e'n tzaj stzi' a'. ");
INSERT INTO aguBl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Yi quilol yi e' xonl Israel yi porer Ryos yi ẍe'n cunin ban i' tan chibiyle'n yi e' sanlar tetz Egipto, nintzun cyak' k'ej Ryos nin k'uke' mas chic'u'l te'j. Ncha'tz e' ban te Moisés yi ẍchakum Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Itzun bantz yi wi't baje'n yi xtxolbile'j, nintzun cyak' Moisés scyuch' yi e' xonl Israel chik'ajsbil tetz Ryos tan tak'le'n k'ej i'. Je na tal chibitze'j: “Kak'e' kak'ajsbil tetz Kataj. Na sk'il cunin nxcye' i' te kacontr yi chibek'xe'n yi e' aj chejinl tu chichej xe mar. ");
INSERT INTO aguBl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Cha'stzun te na wak' ink'ajsbil tetz Kataj, na i' na ak'on inwalor nin ja chincolpij ta'n. I' Ryosil intaj cha'stzun te tajwe'n tan wak'ol ink'ajsbil tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yi kaRyosil i' yi wi'tz aj tx'aconl nin yi bi' i'tz wi'tz Ajcaw. ");
INSERT INTO aguBl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Na ja xcye' tan chibense'n kacontr xe mar scyuch' cyakil chicare't tu cyakil yi e' sanlar tetz faraón. Ej nin tircu'n yi balaj cyajcawil sanlar ja chibek'xij xe mar tan i'. ");
INSERT INTO aguBl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Cho'n cunin e' ban chi na ban jun c'ub yi na ben jo'li'n xe mar, nin jalen xe mar nchopone't ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Wajcaw chin cham nin ilu'. Wi'nin ẍchamilu', nin wi'nin poreru'. Na ja xcye'u' scye'j kacontr. ");
INSERT INTO aguBl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Tan yi teru' poreru' ja xcye'u' tan chixite'n yi e' kacontr. Na ja xcye'u' scye'j cyakil yi e' yi e' oc tan oyintzi' te'ju'. Ja ticy'saju' c'u'lu' scye'j. Cho'n cu'n ntuleju' e' chi na tz'e' mu'ẍ tz'is. ");
INSERT INTO aguBl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Tan yi waloru', ja xupu' wi mar nin ja jatx tib. Cho'n cunin ban cyen chi cob tapij. Ja nac'nax yi xe mar tanu', qui't nẍchuc tib mu'ẍ tal. ");
INSERT INTO aguBl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Nin je chiyol kacontre'j: ‘Kaxomok nin tan chitz'amle'n yi e' xonl Israel, jalen yil chitx'amxij ka'n. Nin yil chitx'amxij ka'n, tz'elpon kamajol cyakil chime'bi'l nin copon kajatxol skawutz. Ẍchiquimok ka'n. Ẍchiquimok ka'n tan kaspar,’ che'ch e' bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Poro teru' ta' ja saj kojolu' yi mar ẍchiwi' nin ja chibek'xij tanu'. Cho'n cunin e' ban chi na ban jun lmak c'ub yi na ben jo'li'n xe mar. ");
INSERT INTO aguBl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Kataj, ¡qui'c nin junt ryos yi ni'cu'nk yi porer tu yi teru'! Qui'c junt yi chin tz'aknak cu'n swutzu' ta', na na xcye'u' tan banle'n wi'nin milawr yi chin xo'wbil nin. Cha'stzun te tajwe'n tan kak'ol kak'ajsbil teru'. ");
INSERT INTO aguBl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ja ẍchaju' yi poreru' scyetz nin tircu'n ja chiquim tanu'. ");
INSERT INTO aguBl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ncha'tz wi'nin na pek'u' ske'j yi o' yi elnako' tzaj liwr jak' chica'wl yi e' aj Egipto, ej nin tan tu' yi na pek'u' ske'j, na tzanu' tan kicy'le'n nin le teru' ama'lu'. ");
INSERT INTO aguBl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Yil quibit cyakil yi e' mas tnum yi xtxolbile'j yi mbanu', ẍchilucnek tan xo'w. Ncha'tz ẍchibne' yi e' filistey, ẍchixobok nin skejk chitzi' tan paj. ");
INSERT INTO aguBl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ncha'tz ẍchibne' yi e' aj Edom yil quibit yi xtxolbile'j, smakxok chixew tan paj. Ma yi e' ajcaw tetz Moab ẍchilewnek tan xo'w. Nin qui't jal chiwalor yi e' aj Canaán. ");
INSERT INTO aguBl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ilu' Kajcaw, che' xo'wsaju' tan chixobe'n. Nink cho'c quen chi jun c'ub yi qui na yucan, jalen yil kicy' jalaj cy'en chiluwar, yi o' tanumu' yi ja kacolpij tanu'. ");
INSERT INTO aguBl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Kataj, ko' tcy'ajninu' tan kanajewe'n tul yi teru' ama'lu' yi wi'nin xanil. Ko' tcy'ajninu' le ca'lu' yi ilu' mbnon tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Scawunku' Kataj tetz ben k'ej ben sak,” che'ch tzun Moisés tul chibitz. ");
INSERT INTO aguBl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Itzun bantz yi e' xome'n tzaj yi e' care't tu e' aj chej tetz faraón wutz chicoc yi e' xonl Israel, tul mar, saje'n tzun kojol Ryos yi a' tetz mar squibaj ninin e' quim. Ma yi e' xonl Israel e' icy' tul mar chi skej chibe'. ");
INSERT INTO aguBl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Toque'n tzun Mariy yi tanub Aarón, yi ncha'tz i' elsanl stzi' Ryos, tan tocse'n jun kbetz yi na bi'aj pandereta nin octz tan bixl. Ncha'tz e' ban yi e' mas xna'n nin e' oc tan tocse'n yi cyetz chikbetz, nin tan bixl te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Toque'n tzun Mariy tan bitz. Je na tal yi bitze'j: “Kabitzink tan tak'le'n k'ej Kajcaw. Na ja tx'acon i' scye'j kacontr. Na ja xcye' i' tan chibense'n chicyakil yi e' aj chejinl tetz oyintzi' xe mar. Kak'e' bin kak'ajsbil tetz.” ");
INSERT INTO aguBl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Quicy'e'n tzun Moisés scyuch' yi e' aj Israel swutz yi ama'l yi at xlaj yi mar. Cho'n tzun e' bene'n le ama'l tz'inunin tu' yi na bi'aj Shur. Ox k'ej e' xon tul yi ama'la'tz. Poro qui nin jal mu'ẍ a' cya'n tetz quic'a'. ");
INSERT INTO aguBl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Yi cyopone'n le ama'l Mara, at jun a' at poro qui nin baj cya'n na chin c'a' nin. Cha'stzun te toque'n yi bi' yi ama'la'tz cya'n tetz Mara. ");
INSERT INTO aguBl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tan paj yi qui jal quic'a' cyoque'n tzun yi xonl Israel tan xbajtzi'e'n te Moisés, itzun cyaltz: “Moisés ¿mbi kuc'aj jalu' tetz kuc'a' na qui'c balaj a' at tzone'j?” ");
INSERT INTO aguBl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Toque'n tzun Moisés tan jakle'n ẍch'eybil tetz, tetz Ryos. Tbit tzun Ryos yi stzi' yi kul Moisés, nintzun ẍchaj i' jun wi' tze' tetz. Ma yi cwe'n tk'ol Moisés yi jun wi' tze'a'tz xe a', toque'n tzun yi a' tetz balaj a'. Cho'n tzun toque'n Ryos tan chipile'n le ama'la'tz. Ncha'tz cho'n tak'ol i' yi tetz ca'wl tan chixome'n te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Itzun taltz scyetz: “Kol tzitbitwok cyakil yi xtxolbil yi swale' tzitetz wok, ej nin kol tziban wok tane'n yi wetz wajbil, tu yi wetz inca'wl; ej nin kol cxomwok te weri inley, qui tzun tz'ul yi e'ch ya'bil tzite'j wok chi yi nche'wulej yi e' aj Egipto. Na in yi itajcawil,” stzun Ryos bantz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Cho'n tzun cyopone'n yi xonl Israel le ama'l yi na bi'aj Elim, kale atite't coblaj ne'ẍ a' tu oxc'al tu lajuj wi' xa'j. Cho'n tzun e' cyaje'n cyen cobox k'ej le jun ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Itzun bantz quicy'e'n tzun yi xonl Israel swutz yi ama'l kale e' cyaje't cyen yi na bi'aj Elim. Cho'n tzun cyopone'n le ama'l tz'inunin tu' yi na bi'aj Sin yi at txo'l Elim tu Sinaí. I'tz yi o'laj tajlal yi ca'p xaw yi cyenle'nix tzaj Egipto yi cyopone'n tul yi jun ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Yi cyopone'n le ama'la'tz, cyoque'n tzuntz tan xocho'n tetz Moisés tu Aarón tan paj yi qui jal chiwa'. ");
INSERT INTO aguBl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Je tzun chiyole'j: —¡Moisés! ¿Nxac nke'l tzaj awucy'al Egipto? Mas balaj klo' cho'nk nkaquim tan Ryos Egipto, na chone'j at ketz kawa'. Cho'n na kawan xlaj ẍwok'il chi'baj, nin na baj ka'n jalen yi na el chin kagan te'j. Poro yi jalu' ntin nkasaj itcy'al wok tzone'j le ama'le'j tan kaquime'n tan we'j, che'ch tzuntz tetz Moisés tu Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Poro nintzun tbit Ryos chiyol cha'stzun tlol i' yi yole'j tetz Moisés: —Swak'e' chiwa' yi xonl Israel. Cho'n lsaj tcya'j. Ntina'tz na taj tan cyele'n cyakil jalchan tan molche'n yi mu'ẍ yi xconk scyetz te yi jun k'eja'tz. Na na waj wil na' scyetz e' yil chixom te inca'wl nin na' scyetz yi qui'. ");
INSERT INTO aguBl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ma le kaki'n k'ej yil cho'c tan molche'n yi chiwa' ba'n chimole'n tetz cob k'ej. Ba'n chimole'n mas swutz yi na ban xo'l sman, stzun Ryos bantz scyetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Cyalol tzun Moisés tu Aarón yi xtxolbila'tz scyetz xonl Israel: —Quibitzaju' e'u' katanum, axen cwe'n k'ej squile'u' yi porer Ryos, yi Ryos yi o' elsan tzaj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ma eklen jalchan squile'u' yi banl i' skibaj, na ja tbit i' yi nchixochonu' tetz. Na cho'n nchixochonu' tetz i', nk'e'tz sketz. ");
INSERT INTO aguBl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ncha'tz tal Moisés scyetz: —Yi jalu' cwe'n k'ej stk'e' Kataj Ryos chi'baj tetz kawa'. Ma jalchan stk'e' pam sketz jalen tz'icy' kapaj te'j. Na ja tbit yi nchixochonu' tetz, na nk'e'tz cho'n nchixochonu' sketz ma na tetz Kajcaw. ");
INSERT INTO aguBl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Bene'n tzun tlol Moisés tetz Aarón: —Alaj scyetz cyakil yi e' xonl Israel tan chibansal quib tu Ryos na ja tbit i' chixocho'n, stzun Moisés bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ej nin te yi tlol Aarón yi xtxolbile'j scyetz xonl Israel tircu'n nintzun e', e' xmayinin le ama'l tz'inunin tu'. Ej nin le rata'tz ja ẍchaj tib yi pak'puchal yi porer Ryos tul yi jun boc'oj sbak'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Cho'n tzun jilone'n Ryos tetz Moisés itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","—Moisés, ja wit yi xocho'n yi nchiban yi xonl Israel. Alaj bin yi xtxolbile'j scyetz: “Jalu' cwe'n k'ej sbajk chi'baj ita'n tetz iwa'. Ej nin ek jalchan sbajk pam ita'n jalen yil tz'icy' ipaj te'j. Tan yi xtxolbile'j tz'elepon itxum tetz yi in yi itajcaw tu iRyosil,” cẍchij sban scyetz, stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","I nintzun bana'tz. Ite'n nin te cwe'n k'eja'tz cyule'n jun c'oloj tz'ichin xlaj yi ama'l kale e' quicyent te jun ak'bala'tz. Ncha'tz ban yi tule'n skil nojnak cu'n yi ama'la'tz tan k'ab che'w. ");
INSERT INTO aguBl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Poro itzun bantz yi skeje'n yi k'ab che'w cyaje'n cyen tzun jun tx'akaj takle'n yi chin sak nin wuxtx'otx' ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Yi quilol yi e' xonl Israel yi chin sak nin ban cyen yi wuxtx'otx' tan yi takle'n yi icunin k'ab che'w, nintzun cyaltz: “¿Mbi tzun i ila'tz yi je'j?” che'ch tzun bantz. —Ya'stzun yi pam yi ja tak' Ryos tetz kawa', stzun Moisés scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","—Ba'n tzimol wok yi mu'ẍ yi tajwe'n tetz itetz. Tunin xomquen te'j yi tajlal ixone'n. Ba'n tzimol wok cob liwr te jujun axwok, stzun Ryos bantz swetz, chij Moisés scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Cyoque'n tzun yi e' xonl Israel tan molche'n. At e' yi nim cyetz baj chimolol, nin at e' yi mu'ẍ ntzi' cyetz baj chimolol. ");
INSERT INTO aguBl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Itzun chipakxe'n xe chipach nin yi toque'n ma'le'n cabal cuntu' na ban, cucoblen liwr te jujun ban. Yi e' yi nim cyetz e' mol, qui'c cyetz sowrin. Ma yi e' yi mu'ẍ ntzi' e' mol, cabal mban. ");
INSERT INTO aguBl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ncha'tz tal Moisés scyetz: —Qui'c cuj tan cyaje'n cyen icolol mu'ẍ tetz ek, mpe ik yi sowril. ");
INSERT INTO aguBl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Poro ilenin ate' cobox yi qui oc yol Moisés te chiwi' na nin cyaj cyen chicolol mu'ẍ tetz junt k'ej. Poro yi tule'n skil, nsken tx'amin nin nsken jal tamlu'il nin chin xewe'n nin mban. Saje'n tzun colp wi' Moisés scye'j tan paj yi qui nin oc yi yol i' te chiwi'. ");
INSERT INTO aguBl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Cyakil nintzun jalchan e' el yi e' xonl Israel tan molche'n chiwa' yi tak' Ryos scyetz. Xomcyentu' te yi tajlal yi jujun najal. Ma yi na mak'tij k'ej nintzun na el a' yi jun jilwutz waja'tz yi cyaj cyen wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ma le kaki'n k'ej tetz yi sman, nim tzun chiwa' e' moltz, na nin e' mol tetz cob k'ej. Cyaj tzun liwr tetz jujun. Poro ate' tzun cobox ajcaw e' opon tan talche'n tetz Moisés tan yi xtxolbila'se'j. ");
INSERT INTO aguBl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Tlol tzun Moisés scyetz: —Quil chibisunu' ta'n na ya'stzun ca'wl Ryos. I' mma'lon yi eklen i'tz yi k'ej tetz ujle'n, nin i'tz jun k'ej yi chin xan nin. Ba'n chitxicu' yi mbi tajwe'n tetz cyeru', nin ba'n chicolu' yi sowril tetz eklen, na cya'l tz'ak'uj eklen, stzun Moisés scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ya'tz tzun cyulej yi e' xonl Israel quib yi tal Moisés scyetz. Cyaje'n cyen tzun chicolol yi sowril tetz junt eklok. Ma yi tule'n skil qui nin tx'amin mu'ẍ tal yi chiwa'a'tz nin qui'c tamlu'il ncu'. Nin qui'c nin mu'ẍ tal nink nxewan. ");
INSERT INTO aguBl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","—Ba'n chibajse'nu' yi chiwa'u' yi cyaj chimololu' na jalu' i'tz jun k'ej ujle'n yi chin xan nin swutz Ryos. Ncha'tz te yi jun k'eje'j cya'l jale't pam cyanu'. ");
INSERT INTO aguBl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ba'n chimololu' yi chiwa'u' tul kak k'ej, ma le juki'n k'ej i'tz yi k'ej tetz ujle'n, quil jal pam cyanu' na ya'stzun yi jun k'ej ujle'n, stzun Moisés ban scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Poro ilenin at e', e' el tan joyle'n yi pama'tz tul yi juki'n k'ej poro qui'c mu'ẍ jal cya'n. ");
INSERT INTO aguBl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Jilone'nt tzun Ryos tetz Moisés itzun taltz: —¿Tona' nin cxom wok te yi wetz inchusu'n? ¿Tona' nin cxo'c wok c'ulutxum jak' inca'wl? ");
INSERT INTO aguBl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Tajwe'n yil tz'oc le iwi' yi in Jehová yi iRyosil nin in ncawun tan itujewe'n le juki'n k'ej. Ncha'tz cyakil k'ej na wak' iwa'. Ej nin tul yi kaki'n k'ej na wak' mas waj tan je'n imolol tetz cob k'ej. Cha'stzun te qui tajwe'n tan itele'n tzaj xe ica'l le juki'n k'ej, stzun Ryos ban scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Chicyakil tzun yi xonl Israel e' xom te yol Ryos, na tircu'n e', e' uje' te e'chk k'ej ujle'n. ");
INSERT INTO aguBl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Toque'n tzun yi bi' yi jun jilwutz waja'tz cyak'un tetz Maná, na yi yubil i'tz sak. Nin icunin wutz clant. Ma yi c'o'cal icunin c'o'cal pam tu cabil wunak txuc. ");
INSERT INTO aguBl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Nintzun tal Moisés scyetz yi xonl Israel: —Je junt ca'wl yi na tzan Ryos tan talche'n tan kaxome'n te'j. “Mol wok mu'ẍ maná nin colwok tul jun ma'lbil yi gomer bi' tan ẍchajle'n scyetz ixonl, yi ya'stzun yi iwa' yi nwak' tul yi ama'le'j yi tz'inunin tu' yi itele'n tzaj Egipto,” stzun Moisés bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Bene'n tzun tlol Moisés tetz Aarón: —Joyaj jun mi't nin ba'n tzawak' cu'n jun gomer maná tul, nin ba'n tzacy'aj kale najle't Ryos, na xconk tzitetz tan ẍchajle'n scyetz ixonl tzantzaj, stzun Moisés tetz Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Joyol tzun Aarón jun tal mi't kale cwe't yi maná, kalena's tzun topone'n ta'n swutz yi caẍa' kale atite't yi ca'wl Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ca'wunak tzun yob baj maná cyak'un yi e' xonl Israel jalen yi cyopone'n kale najlche't wunak stzi' yi mojomil yi ama'l Canaán. ");
INSERT INTO aguBl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Yi gomer ni'cu'n tu cyaj lo' liwr, nin at lajuj ma'lbil gomer tul jun efa. ");
INSERT INTO aguBl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Itzun bantz nintzun e' icy't yi xonl Israel swutz yi ama'l tz'inunin tu' yi na bi'aj Sin. Chebele'n quicy'e'n le jujun ama'l chi yi tal Ryos scyetz. Cho'n tzun cyopone'n le ama'l Refidim. Poro yi cyopone'n le ama'la'tz qui jal mu'ẍ a' cya'n tetz quic'a'. ");
INSERT INTO aguBl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Chibene'n tzun yi e' xonl Israel tan xocho'n tetz Moisés, itzun cyaltz: —Moisés lo'k kuc'a' awa'n na skaquimok tan saktzi', che'ch tzun bantz. —¿Nxac nchu'lu' tan xocho'n swetz? ¿Nxac na chitzanu' tan pile'n Kataj Ryos? stzun Moisés scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Poro tan paj yi saktzi' yi ate' cu'nt e' octz tan yajle'n Moisés. Itzun cyaltz: —¿Nxac nke'l tzaj acy'al Egipto? ¿Ya'tz ptzun awajbil yil kaquim len tzone'j scyuch' cyakil yi e' kanitxa' tu cyakil kawun? ");
INSERT INTO aguBl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Toque'n tzun Moisés tan jakle'n ẍch'eybil tetz, tetz Ryos. Itzun tal i'tz: —Wajcaw, ¿mbil tzimban scye'j cyakil yi wunake'j? Quicunin batz ẍchin lo'onk cya'n tan c'ub, stzun Moisés tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Stza'wel tzun Kataj tetz: —Bajxen ẍchiwutz yi xonl Israel, nin moxwe' nin cobox wi' banl wi' tzawe'j yi ate' tzixo'l wok. Ncha'tz cy'aj nin yi atx'amij yi nxcon awa'n tan jabe'n cu'n yi tzanla' Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ba'n ẍbajxij ẍchiwutz. Nin ojkel nin wok na cho'n cxinch'iwok le wi'wtz Horeb, tibaj yi jun chin wutz kotx'. Yil xopon ba'n tzaxuy cyen yi atx'amij te yi jun wutz kotx'a'tz, tz'elu'l tzun a' te'j bantz jale'n quic'a' yi e' xonl Israel. Yi cyopone'n ya'tz nin tzun tulej Moisés quib yi tal Ryos tetz. Ẍchiwutz cunin cyakil yi e' wi' banl wi' tetz yi e' xonl Israel yi bnol Moisés yi xtxolbila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Toque'n tzun bi' yi ama'la'tz tan Moisés tetz Meriba, na nin tal i': “Ja chixochon yi e' wunak swetz.” Ncha'tz oc tk'ol yi bi'-tz tetz Masah, na nin e' oc yi e' xonl Israel tan pile'n Ryos tan yi e'chk yole'j: ¿Xomij nin polo' Ryos ske'j nka qui'? che'ch tzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Itzun bantz yi cyopone'n yi e' xonl Israel le ama'l Refidim, cyopone'n tzun yi e' xonl k'ajtzun Amalec tan oyintzi' scye'j. ");
INSERT INTO aguBl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Nintzun tal Moisés tetz Josué: —Txa'we'e'n cobox yaj skaxo'l nin ba'n xben wok tan oyintzi' scye'j. Ma in wetz, jalchan nchimben jalen wi'wtz nin mben incy'al yi tx'amij yi na ẍchaj porer Ryos, stzun Moisés bantz tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Cyele'n tzun Josué tan oyintzi' scye'j e' xonl k'ajtzun Amalec quib yi tal Moisés scyetz. Ma cyetz Moisés tu Aarón nin Hur, cho'n chibene'n cyetz wi'wtz. ");
INSERT INTO aguBl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Yi cyopone'n wi'wtz nintzun je' tk'ol Moisés yi k'ab tcya'j. Yi je'nt tk'ol Moisés yi k'ab tcya'j e' tzun xonl Israel nchixcye' scye'j yi e' xonl k'ajtzun Amalec. Ma yi na cutzaj yi k'ab i' yi na k'e'xij, e' xonl k'ajtzun Amalec nchitx'acon scye'j e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Poro itzun bantz yi k'e'xe'n yi k'ab Moisés saje'n tzun chijoyol jun c'ub tetz c'olchbil Moisés tan tujewe'n i'. Ncha'tz e' oc Aarón tu Hur tan palche'n yi k'ab Moisés, jun le sbal nin jun le max. Cha'stzun te xtx'ajol Moisés yi ate'n tu' yi k'ab tcya'j te cyakil yi jun k'eja'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ya'stzun bantz yi xcyewe'n Josué scye'j yi e' xonl Amalec. ");
INSERT INTO aguBl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Tlol tzun Ryos tetz Moisés: —Tz'ib wok cu'n yi xtxolbile'j yi mbajij tul jun u'j tan tule'n tx'akx tic'u'l tzantzaj. Ncha'tz alaj tetz Josué yi xtxolbile'j: “Chicopon insotzal cyakil yi e' xonl Amalec nin cya'l na'wse't chibi',” stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Je'n tzun bnol Moisés jun patbil xtx'ixwatz le ama'la'tz nin oc tk'ol yi bi' tetz: “Yi Kajcaw, i' kabajxom nin i' na ak'on kachamil”. ");
INSERT INTO aguBl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ncha'tz tal i'-tz: “Tan tu' yi ncho'c yi e' xonl Amalec tan oyintzi' te'j Ryos, cha'stzun te tz'ocopon Ryos tan oyintzi' scye'j yi e' xonl Amalec sbne' opon tunintz.” ");
INSERT INTO aguBl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Itzun bantz nintzun tbit Jetro, yi ji' Moisés, ẍe'n cunin ban Ryos tan cyelse'n Moisés scyuch' yi xonl Israel jak' chica'wl yi e' aj Egipto. Yi jun Jetro-a'tz, i' jun chipale'il yi e' aj Madián. ");
INSERT INTO aguBl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ma yi txkel Moisés yi na bi'aj Séfora tu yi e' tal nsken chopon tu tetz taj. ");
INSERT INTO aguBl_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Gersón bi' jun scyeri yi cob cy'ajl Moisés. Oc tlol i' yi bi'aja'tz na nin tal i': “In jun awer nak tane'n tzone'j le ama'le'j.” ");
INSERT INTO aguBl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ma yi junt cy'ajl Moisés, Eliezer bi', na nin tal Moisés yi titz'e'n yi ni'a'tz: “Yi Ryosil k'ajtzun intaj i' nmo'c tan wuch'eye'n nin tan incolche'n tan qui inquime'n tan faraón.” ");
INSERT INTO aguBl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Cho'n tzun at Moisés scyuch' cyakil yi e' xonl Israel le ama'l tz'inunin tu' naka'jil yi wi'wtz tetz Ryos, yi cyopone'n Jetro tu yi txkel Moisés nin yi cob cy'ajla'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yi cyopone'n Jetro nintzun ben mantar tan talche'n tetz Moisés: —Ja ul yi ji'u' tan tilwe'nu'. Nin xomche' yi txkelu' tu yi cob cy'ajlu' te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Tele'n tzaj tzun Moisés tan chic'ulche'n yi ji'. Nintzun cu' mejloktz tan tak'le'n k'ej. Ncha'tz ben i'-tz tan stz'uble'n yi xak stzi'. Kalena'tz tzun cyoque'n xe yi mantial kale najle't Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Yi cyoque'n xe mantial toque'n tzun Moisés tan xtxole'n tetz yi ji' yi ẍe'n cunin ban Kataj Ryos tan cyelse'n tzaj jak' chica'wl aj Egipto. Nin yi ẍe'n cunin ban Kataj te'j faraón scyuch' cyakil yi e' mas aj Egipto. Ncha'tz xtxol i' cyakil yi q'uixc'uj yi nchitij tbe', nin ẍe'n cunin ban Kataj Ryos tan chicolche'n tk'ab yi e'chk q'uixc'uja'tz. Tircu'n baj xtxolil Moisés tetz yi ji'. ");
INSERT INTO aguBl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Wi'nin tzun stzatzine'n Jetro te yi xtxolbil yi tbit nin, yi ẍe'n cunin ban Ryos tan ẍchajle'n yi banl talma' squibaj yi e' xonl Israel tan chicolpene'l tzaj jak' chica'wl yi aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Nintzun taltz: —K'ajsbil tetz Kajcaw yi ja xcye' tan icolpe'n wok jak' ca'wl yi faraón scyuch' yi e' aj Egipto, yi e' ocnake' tan ibuchle'n na le wutz cyetz cyajtza'kl yi qui'c ixac. ");
INSERT INTO aguBl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ntyoẍ tetz Kataj yi ja cxe'l wok tzak' yi buchbe'n itetz yi chin q'uixbel nin ncxu'lij wok. K'ajsbil tetz Kajcaw na na el intxum tetz yi at mas ẍchamil i' ẍchiwutz cyakil chiryosil yi e' aj Egipto, stzun Jetro bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Toque'n tzun Jetro tan pate'n jun xtx'ixwatz tan tak'le'n k'ej Ryos. Ncha'tz toy i' coboxt oy tetz Kajcaw. Cyule'n tzun Aarón scyuch' yi e' wi' banl wi' tetz Israel tan wa'a'n te'j Jetro tan tak'le'n k'ej Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Itzun bantz le junt eklok nintzun oc Moisés tan pujle'n xtisya' ẍchixo'l yi e' xonl Israel yi at chiproblem. Baj cunin jun k'eja'tz cyak'un wunak tan ẍch'iwe'n. Wi'nin e' txiclche' tan ẍch'iwe'n tan cyoque'n swutz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yi tilol yi ji' Moisés yi qui na el i' tan pujle'n ẍchixo'l yi jun c'oloj wunaka'tz, nintzun taltz tetz: —¿Nxac na cẍtzan tan banle'n yi xtxolbila'tz? ¿Mbi tzuntz yi achuc atiẍ ẍchiwutz cyakil yi e' wunake'j tan chibanle'n tane'n, nin yi cyetz txiclche' tu' tan ach'iwe'n cyakil k'ej? stzun Jetro tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","—Yi mero bintzi ta' i'tz cyakil yi e' wunake'j na chu'l tzinwutz tan jakle'n swetz nin tan injakol tetz Ryos yi mbi tajwe'n tan chibnol. ");
INSERT INTO aguBl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Na yi na jal problem ẍchixo'l cyenin na chu'l tan injoyle'n tan woque'n tan ma'le'n na' scyetz yi aj paj. Na tzun wal scyetz yi mbi na tal yi ca'wl Ryos tan chixome'n te'j, stzun Moisés tetz yi ji'. ");
INSERT INTO aguBl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","—Poro yaj, ploj yi na cẍtzan tan banle'n scye'j e' wunak, na achuc na cẍtzan tan chibanle'n tane'n. ");
INSERT INTO aguBl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Na nim yi jun ak'une'j. Wi'nin na ẍk'e'xij ta'n. Ncha'tz yi e' xonl Israel na chik'e'xij tan ach'iwe'n. Wi'nin e' txiclche' tu' tan ach'iwe'n te yi jun k'eje'j. Cha'stzun te quil cxcye' te'j achuc. ");
INSERT INTO aguBl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ma jalu' Moisés mas balaj yil ẍo'c tan xtxumle'n yi xtxolbile'j yi swale' tzatz nin lok tz'oc Ryos tan awuch'eye'n. Mas tajwe'n tan awoque'n tetz chiyolol yi e' wunak swutz Ryos tan talche'n chiproblem tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ncha'tz tajwe'n tan chichusle'n te cyakil yi ley tu ca'wl Ryos, tan chixome'n te'j nin tan chibanol tane'n. ");
INSERT INTO aguBl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ncha'tz, txa'we'e'n cobox yaj yi tz'aknak cu'n e', yi na cyek ẍchi' Ryos. Tajwe'n yi jicyuch te cyajtza'kl, nin yi qui na chitzantu' tan chisuble'n wunak tan jale'n yi cyetz chime'bi'l. Ba'n tzun che' abixbaj tan chicawune'n squibaj yi mas wunak. Ba'n che' abixbaj jun squibaj jun mil xone'n, nin jujun squibaj jun cient, nin jujun squibaj nicy' cient xone'n, nin ba'n cho'c jujunt squibaj lajuj. ");
INSERT INTO aguBl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ba'n chicawun yi e'a'tz scye'j yi e' yi ate' chicwent. Ma ko quil chixcye' te jun problem ba'n tzun chu'l tzawutz tan abnol tane'n. Poro ko i'tz yi e'chk problem yi chixcyek e' te'j ba'n chiban tane'n chichuc. Kol tzaban yi xtxolbile'j quil ẍk'e'xij mas, na chocopon yi e'a'tz tan awuch'eye'n. ");
INSERT INTO aguBl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Kol cxom te yi xtxolbile'j nin ko ya'tz tajbil Ryos tan abnol, quil ẍk'e'xij nin cha'tz yi e' mas wunak chitzatzink te'j, stzun yi ji' Moisés bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Inin tzun tulej Moisés quib yi tal yi ji' tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Toque'n tzuntz tan chitxa'le'n cobox yaj ẍchixo'l yi xonl Israel, yi e' yi at mas cyajtza'kl. Nintzun e' octz ta'n tetz chibajxom squib yi xonl Israel. At e', e' oc tetz chibajxom jun mil nak. Ej nin at e', e' octz tetz bajxom squibaj jun cient. Ej nin at e', e' oc squib nicy' cient, nin at e', e' oc squibaj lajuj ntzi' xone'n. ");
INSERT INTO aguBl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","E' tzun pujun chixo'l yi e' yi na jal chiproblem. Ma yi e'chk problem yi qui nchixcye' te'j, cho'n tzun topone'n cya'n swutz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Chijatxol tzun quib Moisés tu yi ji', pakxij tetz Jetro le tetz tanum. ");
INSERT INTO aguBl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Itzun bantz cho'n tzun cyopone'n yi e' xonl Israel le ama'l tz'inunin tu' yi na bi'aj Sinaí. Oxix xaw chibe' jetz yi cyele'n tzaj Egipto, yi cyopone'n le jun ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Na yi quicy'e'n Refidim, cho'n tzun cyopone'ntz Sinaí nin cho'n e' cyaje'n cyen cobox k'ej xe wutza'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ej nin tul yi jun ama'la'tz cho'n xa'ke'n Moisés tan yol tetz Ryos. Na nin jilon tzaj Ryos tetz i' wi'wtz. Itzun taltz: —Alaj yi xtxolbile'j scyetz cyakil yi e' xonl Jacow, yi e' xonl Israel: ");
INSERT INTO aguBl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Ja itil wok yi ẍe'n cunin mimban scye'j yi e' aj Egipto. Ncha'tz ja itilwok yi ẍe'n cunin ncxu'l wok wa'n tzone'j kale atine't wetz. Ja cxu'l wok wa'n chi na ban jun q'uilq'uitx tan palcheje'n yi e' tal. ");
INSERT INTO aguBl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Cyakil yi ama'l yi at bene'n tzi'n, wetz. Poro kol cxom wok te wetz inca'wl, nin kol tziban wok yi wetz wajbil cxocopon wok tetz mero intanum, yi mas chimpek'ok te'j, ẍchiwutz cyakil e' mas tnum. ");
INSERT INTO aguBl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ncha'tz cxocopon wok tetz jun k'u'j pale' tzinwutz nin tetz jun tnum yi xansa'nt tan ixcone'n swetz.” Alaj yi xtxolbile'j scyetz, stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Bene'n tzun mantar Moisés tan chichakle'n yi e' wi' banl wi' cyetz yi e' xonl Israel. Yi cyopone'n nintzun tal i' tircu'n yi ntal Kataj Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Yi quibital yi e' wi' banl wi' scyuch' yi e' mas wunak yi xtxolbila'tz, tircunin tzun chicujij nin cyaltz: —Skabne' tane'n cyakil yi ntal Kataj Ryos, che'ch. Yi tbital Moisés yi chitxumu'n yi e' xonl Israel nintzun bentz tan talche'n tetz Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Talol tzun Kataj Ryos tetz Moisés: —¡Moisés! Chinjilonk tzatz. Poro cho'n chincyaj tc'u'l jun sbak' yi chin tz'o'tz nin yil chinjilon. Ya'stzun wulej bantz quibital yi e' wunak inyol te yil chinjilon tzatz, nin tan cyocsal yi bintzinin ja chinjilon tzatz, stzun Ryos bantz. Nintzun tal Moisés junt tir tetz Kataj Ryos yi chitxumu'n yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","11","Ej nintzun tal Kataj tetz: —Culo'k bin nin alaj scyetz yi tajwe'n tan chixansal quib ek tu ca'p. Tajwe'n tan chitx'ajol be'ch cyetz tan chibnol list quib tetz ca'pen, na ya'stzun yil chincu'ul tib yi wutze'j ẍchiwutz cu'n chicyakil. ");
INSERT INTO aguBl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Cuken techl solte'j yi wutz awa'n tan qui quicy'e'n yi xonl Israel te yi mojoma'tz. Nin alaj scyetz yi cya'l jun yi nink ẍkan tzaj mu'ẍ te wutze'j. Ej nin yi e' yi quil chiban tane'n tajwe'n tan chicwe'n biyij. ");
INSERT INTO aguBl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ncha'tz qui'c cuj tan itz'amol yi jun yaja'tz yi ja juch til. Ma na tajwe'n yil cu' biyij tan c'ub nka tan flech. Ncha'tz qui'c na ban yi ko i'tz jun wunak nka jun txuc. Tajwe'n yil cu' biyij yi ko quil xom te yi xtxolbile'j. Ntin le toxi'n k'ej yil ẍch'in yi cornet, yi tuc' cne'r, ba'n tzun chije' tzaj xe c'u'l yi wutze'j, stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Taje'n tzaj tzun Moisés wi'wtz kale e' jilone't tu Ryos. Yi cwe'n mule'n nintzun tal i' scyetz yi e' xonl Israel yi tajwe'n tan chibnol list quib tan tak'le'n k'ej Ryos. Tircunin tzun yi xonl Israel e' octz tan xtx'ajle'n yi be'ch cyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Nintzun tal Moisés scyetz: —Quil chiwitbej quibu' tu quixkelu' tan chixansal quibu' te yi ox k'eje'j, stzun Moisés bantz scyetz yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Itzun bantz le toxi'n k'ej, cwe'n tzun chin xlitz' tu k'ancyok nin saj jun c'oloj sbak' nin opon tibaj yi wutza'tz. Nintzun ẍch'in jun chun yi chin wi' nin ban. Ninin e' lucne' yi e' xonl Israel tan xo'w. ");
INSERT INTO aguBl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Cawunin tzun Moisés scyetz cyakil yi e' xonl Israel, tan chibene'n xe c'u'l yi wi'wtz tan c'u'laje'n Ryos. Yi cyopone'n nintzun e' xcyewe'n cu'n solte'j yi wi'wsa'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Chin sib nin tunin ban yi wi'wsa'tz tan yi sibel k'ak' na cho'n cwe'n mule'n Ryos tul k'ak'. Cho'n cunin ban yi sib chi na ban sibel jun patbil txun, nin cyakil yi wi'wsa'tz chucan. ");
INSERT INTO aguBl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ej nin yi jun chun yi na ẍch'in wi'nin ẍch'uye'n yi wi'. Toque'n tzun Moisés tan yol tu Ryos. Nintzun na stza'wej Ryos yi yol i', poro chin xo'wbil nin ban yi jilone'n Ryos na cho'n cunin ban chi na nilcan k'ancyok. ");
INSERT INTO aguBl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Cho'n tzun cwe'n mule'n Ryos mero tibaj yi wi'wsa'tz yi na bi'aj Sinaí, nintzun taltz tetz Moisés tan je'n pone'n te i' nintzun je' Moisés le ama'la'tz kale atit Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Nintzun tal Ryos tetz: —Moisés, na waj yil cẍben tan talche'n scyetz cyakil yi e' xonl Israel yi quil chicy' tibaj yi mojom yi ja bnix ka'n, nin yi junt i'tz yi qui'c cuj tan cyoque'n tan inxmaye'n, na kol quil inwutz ẍchiquimok. ");
INSERT INTO aguBl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ncha'tz yi e' pale' yi ate' tzixo'l wok, yi e' yi na chu'l tzinwutz, tajwe'n tan chixansal quib, na ko qui', chelepon cu'n wa'n swutz, stzun Kataj bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","—Quil bisunu' Ta', stzun Moisés. —Na yi e' xonl Israel quil chinimsaj quib tan chije'n tzaj tzone'j. Na ja bin talu' sketz tan cwe'n mojomil yi ama'l ka'n nin ja talu' yi xan kol kicy' tzaj mu'ẍ tal tibaj. ");
INSERT INTO aguBl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Poro nintzun tal Ryos tetz: —Quilo'k Moisés, ba'n ẍcu' nin ba'n ẍpakxij junt tir poro xomok tzaj Aarón tzawe'j yil cẍu'lt. Ma yi e' mas pale' tu cyakil yi e' xonl Israel chicyajk cyentu' kale ate't. Nin qui'c cuj yi nink chicy' tzaj mu'ẍ te yi mojom yi ja cu' wa'n, na ko at jun yil tz'icy' tzaj squimok tera'tz wa'n, stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Taje'n tzaj tzun Moisés wi'wtz, nin yi cwe'n mule'n nintzun tal i' scyetz cyakil yi e' xonl Israel yi xtxolbil yi tal Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Je ca'wl Ryos yi talnak scyetz yi e' xonl Israel: ");
INSERT INTO aguBl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“I ina'tz in iRyosil yi nxe'lsan tzaj wok Egipto, kale nxa'te't wok tetz chisclaw yi e' aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","”Quil tzitak' k'ej junt Ryos, ma na ntin in. ");
INSERT INTO aguBl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","”Quil tziban wok teblal jun takle'n tan itk'ol wok k'ej, mpe ik teblal jun yi at tzone'j wuxtx'otx', nka jun yi at tcya'j nka teblal jun yi at xe mar. Qui'c cuj yi nink tziban wok teblal jun scyeri e'a'tz, tan itk'ol k'ej. ");
INSERT INTO aguBl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Qui'c cuj yi nink xmeje' cu'n wok ẍchiwutz, nin qui'c cuj yi nink cxo'c wok tan chic'u'laje'n, na yi in wetz in yi iRyosil, nin na je' tzinwutz ko ya'tz tziban wok. Ej nin swak'e' chicaws yi e' yi qui na cyek inchi', tu yi e' yi na chi'ch chic'u'l swe'j. Swak'e' chicaws tuml chinitxa' tu chimamaj yi e'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Poro yi e' yi na chipek' swe'j, nin yi na chiban tane'n yi inca'wl swak'e' imbanl squibaj nin squibaj chinitxa' scyuch' chimamaj, tetz jun c'oloj tiemp. ");
INSERT INTO aguBl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","”Quil tzina'wsaj wok imbi' tan cha'tz tu', na swak'e' icaws ko ya'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","”Ban wok tane'n yi jun k'ej ujle'n na xansa'nt wa'n. ");
INSERT INTO aguBl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ba'n xak'uj wok kak k'ej le sman tan banle'n cyakil itak'un yi tajwe'n tetz itetz. ");
INSERT INTO aguBl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ma le juki'n k'ej i'tz yi k'ej tetz ujle'n, nin i'tz tan itk'ol ink'ej. Qui'c cuj yi nink xak'uj wok, mpe ik initxa' nka yi e' imos yi ate' tzite'j wok, mpe ik yi e' awer nak yi ate' tzixo'l wok. Qui'c cuj tan cyak'uje'n. Ncha'tz yi e' itawun qui'c cuj yi nink chak'uj te yi jun k'eja'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Cya'l tz'ak'uj na kak k'ej imban wetz tan banle'n cyakil yi tcya'j tu yi wuxtx'otx', tu yi mar, tu cyakil yi at. Ma le juki'n k'ej, nintzun nuje'. Cha'stzun te ja inxansaj yi jun k'eja'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","”Lok' wok itaj itxu' tan bene'n ẍkon itiemp yi ak'ij wa'n tzitetz tzone'j wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","”Quil xbiyolnakin. ");
INSERT INTO aguBl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","”Quil cxjopon wutzaj. ");
INSERT INTO aguBl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","”Quil cxalk'ij. ");
INSERT INTO aguBl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","”Quil tzijal wok cu'n jun wi' itak' te'j junt wunak. ");
INSERT INTO aguBl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","”Quil tz'el italma' te yi me'bi'l junt. Quil tz'el italma' te yi txkel, nka te yi mos nka te yi tawun nka alchok e'chk takle'n yi at tuch',” stzun Ryos bantz scyetz yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Tircu'n tzun yi e' xonl Israel stiw te cyakil yi xtxolbila'se'j yi bajij te yi wutza'tz na ja quibit cyakil yi e'chk xlitz' tu k'ancyok yi baj cu'. Nin quibit yi chun yi nẍch'in. Nin quil cyakil yi sib yi jal te yi wi'wsa'tz. Cha'stzun te wi'nin e' xobe'ntz, nin kajpe'n nin e' xmayinint. ");
INSERT INTO aguBl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ncha'tz cyal tetz Moisés: —Mas balaj yi ilu' jilon sketz, nin skabne' tane'n cyakil yi stale'u'. Na kol jilon Ryos sketz, qui cunin bantz skaquimok ta'n, che'ch tzun bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","—Quil chixobu', stzun Moisés scyetz. —Na yi tajbil Ryos i'tz tan chixo'wse'nu', bantz cyekalu' ẍchi' i' sbne' opon tunintz. Nin i'tz chixo'wse'nu' tan qui chijuchulu' mas quilu', stzun Moisés bantz scyetz yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Te yi ate' cyen yi e' xonl Israel joylaje'l tzaj yi wutz, nintzun je' tetz Moisés wi'wtz tul yi sbak' yi chin tz'o'tz nin kale atit Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yi je'mpone'n Moisés nintzun jilon Ryos tetz, itzun taltz: “Alaj yi xtxolbile'j scyetz yi e' xonl Israel: ‘Ja wi't itil wok nin ja itbit wok yi cho'n nchinjilon tzaj tzitetz tcya'j. ");
INSERT INTO aguBl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Cha'stzun te quil tziban wok teblal jun iryosil. Quil tziban wok jun iryosil tan oro nka tan sakal. ");
INSERT INTO aguBl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ma na ban wok jun patbil itx'ixwatz yi tx'otx' tu'. Nin ba'n tzipat wok cu'n itx'ixwatz tibaj, chi tane'n yi cne'r tu wacẍ. Ncha'tz ba'n tzipat wok e'chk oy tibaj yil xconk tan ẍchajle'n yi tzatzin paz yi ja jal skaxo'l tzituch'. Nin ko ya'tz tzibanwok, nu'l, nin swak'e' imbanl tzitibaj tul yi luwar kale na wajwit yil tzina'wsaj wok imbi'. ");
INSERT INTO aguBl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Nin ko tziban wok jun patbil tx'ixwatz yi c'ub cu'n ba'n tzijoy wok yi c'ub yi qui se'ij, na kol xo'c wok tan se'le'n yi c'ub tz'elepon k'ej inaltara'tz ita'n, nin qui'c xac sbne'. ");
INSERT INTO aguBl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ncha'tz qui na waj yil tziban wok yotx te'jak yi jun patbil itx'ixwatza'tz, na yil cxje' wok tibaj qui na waj yi tzichaj wok yi iwankil yi ewu'n ita'n.’ ");
INSERT INTO aguBl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","”Je cyakil yi ca'wl yi tajwe'n tan awalol scyetz cyakil yi e' xonl Israel tan chibnol scye'j yi e' esclaw yi ate' scyuch': ");
INSERT INTO aguBl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","”Yi kol tzilok' wok jun esclaw yi hebrey, ba'n tz'ak'uj kak ntzi' yob tzituch'. Ma le juki'n yob ba'n tz'el liwr, nin qui tajwe'n tan ẍchojol jun centaw tan tele'n liwr. ");
INSERT INTO aguBl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Yi ko qui'c txkel yi topone'n, ite'n nin sbne'a'tz yil tz'el liwr. Ma ko xomij txkel te'j yi topone'n ba'n xom nin yi txkel te'j yil tz'el liwr. ");
INSERT INTO aguBl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ma ko i yi patrón yi mo'csan yi txkel nin ko ja jal chinitxa', cho'n nin chicyajk cyera'tz jak ca'wl yi patrón. Ẍchuc cuntu' yaj tz'elepon liwr, na ẍchuc cuntu' topone'n. ");
INSERT INTO aguBl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Poro kol xtxum yi mos tan qui tele'n liwr tan tu' yi na pek' i' te yi txkel nin scye'j nitxajil, nin te yi patrón, ba'n cyaj cyen i'. ");
INSERT INTO aguBl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Ko ya'tz ba'n tzun ben yi yaj tu yi patrón ẍchiwutz yi e' pujul xtisya' cwent Ryos tan banle'n jun chitrat. Ba'n tzun tak'cyen yi mos yi ẍchin te yi marquil yi puert, nin ba'n tz'oc yi patrón tan kople'n yi ẍchin tuml yi marquil yi puert. Ya'stzun techl yi tz'ocopon junawes tetz jun esclaw yi patrón. ");
INSERT INTO aguBl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","”Ko at jun yaj yil sc'ay nin jun me'l chi jun esclaw tetz junt, quil tz'el liwr chi na chiban yi e' yaj yi na cho'c tetz esclaw. ");
INSERT INTO aguBl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ko qui na taj yi patrón tz'oc tetz txkel, tan paj yi qui na pek' te'j, ba'n tzun tak' yi patrón ama'l tetz tan tele'n liwr poro tajwe'n tan ẍchojol tetz yi patrón tan tele'n liwr. Ej nin qui'c cuj tan bene'n c'ayil scyetz awer nak tan tu' yi qui na pek' te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ma ko tz'oc tetz txkel yi cy'ajl, ba'n tzun tz'oc yi mos chi jun me'l yi patrón, nin tajwe'n yil pek' i' te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ma kol jal junt txkel yi yaj ta'n, qui'c cuj yi nink tz'el k'ej yi bajx txkel ta'n. Ma na tajwe'n yil tak' i' yi tajwe'n tetz chi tane'n wa' tu be'ch tetz. Ncha'tz tajwe'n yil tak' yi wankil tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ma ko quil sban yi patrón yi e'chk xtxolbile'j, ba'n tzun tz'el xna'n liwr. Nin qui tajwe'n tan ẍchojol jun centaw, tan tele'n i' liwr. ");
INSERT INTO aguBl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","”Ncha'tz ko at jun yil tz'oc tan biyle'n junt yaj nin kol quim ta'n tajwe'n tan cwe'n biyij yi juna'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Poro ko nk'e'tz yi tajbil i' tan bnol yi xtxolbila'tz te yi tuch' nin ko ya'tz nin quimbil yi juna'tz, ba'n tzun tz'el ojk yi jun yi mbiyon tan ew ib. Poro swale' tzitetz na'l bene't i' tan tewal tib. ");
INSERT INTO aguBl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Poro ko at jun yi ba'n cunin sbiy cu'n jun tuch' tan paj yi na chi'ch c'u'l te'j, ba'n tzun cu' biyij yi juna'tz yi mbiyon yi tuch' nin ko tz'el ojk tan ew ib ba'n tz'oc joyle'n. Petzunk cho'n tew tib kale atit yi patbil tx'ixwatz ba'n nin lcu' biyijtz. ");
INSERT INTO aguBl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","”Ko at jun tz'oc tan biyle'n taj xtxu', tajwe'n cu' biyij yi juna'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","”Ncha'tz alchok scyetz yil tz'oc tan talk'e'n jun yaj tan bene'n c'ayil tajwe'n tan cwe'n biyij yi juna'tz, petzunk atit yi yaj tk'ab, nka nsken ben c'ayil. Tajwe'n tan cwe'n biyij yi jun alk'om wunaka'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","”Alchok scyetz yil tz'oc tan jisle'n yi taj xtxu', tajwe'n tan cwe'n biyij. ");
INSERT INTO aguBl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","”Ncha'tz ko at jun biyo'n mbajij nin ko ja lo'on jun tan c'ub nka tan k'abaj, poro qui nin nquim, nin ba'n xon te tx'amij qui tzun lcu' biyij yi jun yi mbnon tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Ntin na taj yil ẍchoj yi jun yi mbiyon cyakil yi stz'acbe'n tetz, nin yi tiemp yi ntx'akx tan yi q'uixpnak jalen yil tz'ul yos tuch'. Kol sban yi xtxolbile'j, ba'n tzun tz'el liwr yi juna'tz yi mbnon, nin qui'c til sbne'. ");
INSERT INTO aguBl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","”Kol tz'oc jun patrón tan biyle'n jun scyeri esclaw tan tze', nin kol quim yi mos ta'n, tajwe'n tan ẍchojol. ");
INSERT INTO aguBl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Poro ko quil quim chan tetz cobox k'ej, qui'c tzun til yi patrón te'j na at i' jak' ca'wl yi patrón. ");
INSERT INTO aguBl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","”Kol chibiy quib cob yaj nin lo'on jun xna'n yi ch'on wi' cya'n, nin kol quim yi ni' cya'n, poro quil quim yi xtxu', tajwe'n tan chichojol yi mult jatna' sc'uch yi chmil yi xna'n, nin mbi na cyal yi e' pujul xtisya'. ");
INSERT INTO aguBl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Poro kol quim yi xna'n tajwe'n tan chiquime'n yi e' yi nlo'onsan. ");
INSERT INTO aguBl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Na je tane'ne'j: Kol tz'el bak' wutz jun yaj tan junt tajwe'n tan tele'n yi tetz. Ko i yi te' tz'el, ncha'tz tz'an yi junt, tajwe'n tan tele'n yi tetz te'. Ma ko jalaj k'ab tz'el, tajwe'n tan tele'n jalaj k'ab yi junt. Ma ko jalaj tkan tz'el, ncha'tz tz'an yi junt, tajwe'n tan tele'n jalaj tkan. ");
INSERT INTO aguBl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ko tz'e'se'n tz'u'lij tajwe'n yil cu' tz'e'sa'n yi jun yi mbnon tetz. Ma ko lo'one'n tu' mban, tajwe'n yi ya'stzun tz'u'lij yi mbnon tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","”Ko at jun patrón yi lo'on jalaj wutz yi mos ta'n, ba'n tak' i' ama'l tan tele'n liwr tetz xel yi wutz yi nlo'on ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ko i'tz jun te' tz'el, tajwe'n tan tk'ol yi patrón ama'l tan tele'n liwr tetz xel yi te'. ");
INSERT INTO aguBl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","”Ko at jun yaj, nka xna'n, yi lo'on tan wacẍ nin quimtz, tajwe'n tan cwe'n biyij yi jun wacẍa'tz tan c'ub, nin qui'c cuj tan ibajsal yi ẍchi'bel. Poro yi taw qui'c til te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Poro ko na nin til yi taw yi ba'n tocon yi wacẍ, nin kol quim jun yaj ta'n, tajwe'n cu' biyij yi wacẍ nin ncha'tz yi taw tajwe'n tan cwe'n biyij, tan paj yi na til i' yi at wi' yi wacẍ nin nk'e'tz c'alij ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Poro ko cuj yi chojij tz'an tajwe'n tan ẍchojol i' yi mult tan qui quime'n i'. ");
INSERT INTO aguBl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ite'n nin xtxolbil tz'an yi ko i'tz jun xicy nka jun xun yi lo'on tan jun wacẍ. ");
INSERT INTO aguBl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Poro ko i'tz jun esclaw lo'on tan yi wacẍ tajwe'n tan cwe'n biyij yi wacẍ tan c'ub, nin tajwe'n tan ẍchojol yi taw yi wacẍ junaklaj piẍ sakal tetz yi patrón yi esclaw. ");
INSERT INTO aguBl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","”Ko at jun yi skop jun julil a', nka at jun julil a' tuch' jun yaj nin ko quil sjop, nin ben jun wacẍ nka jun buru' tul, ");
INSERT INTO aguBl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","tajwe'n tan ẍchojol yi taw yi julil a' tetz yi taw yi wacẍ yi jamel, nin ba'n tetzaj yi yaj yi taw yi julil a' yi ẍchi'bel yi wacẍ. ");
INSERT INTO aguBl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","”Ma ko i'tz wacẍ jun yaj yi lo'on tan wacẍ junt yaj, tajwe'n tan bene'n c'a'y yi wacẍ yi lo'onsan yi junt, nin cob tz'el yi jamel ẍchiwutz yi cob yaja'tz. Nin ncha'tz tz'an yi ẍchi'bel yi wacẍ yi quimnak. ");
INSERT INTO aguBl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Poro ko na til yi taw yi wacẍ yi ba'n tocon yi tetz wacẍ nin quim junt ta'n nin qui na oc il i' te'j, tajwe'n tan ẍchojol i' jamel yi wacẍ yi junt, nin tetz i' sbne' yi ẍchi'bel jun yi quimnak. ");
INSERT INTO aguBl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","”Ko at jun yil talk'e'l tzaj jun wacẍ nka jun cne'r tan cwe'n biyol tetz ẍchib nka tan c'ayil, tajwe'n tan tk'ol o'-t wacẍ tetz xel yi juna'tz. Ma ko i'tz jun cne'r tajwe'n tan tk'ol cyajt cne'r tetz xel. ");
INSERT INTO aguBl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","”Ej nin kol tx'amxij jun alk'om te yi na tzan cunin tan alak' nin kol biylij nin quimtz, qui'c til yi jun yi mbiyon tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Poro ko i'tz chajk'ej yil tx'amxij yi juna'tz yi na tzan tan alak' nin tz'oc biyle'n nin quimtz at tzun til yi jun yi mbnon tetz. ”Ncha'tz kol tx'amxij jun alk'om tajwe'n tan ẍchojol i' yi jamel yi e'chk takle'n yi mme'l tzaj talk'al. Poro ko qui'c pu'k tan ẍchojle'n tajwe'n tan bene'n c'ayi'n i' tetz esclaw tan jale'n pwok tan ẍchojle'n yi mult. ");
INSERT INTO aguBl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","”Kol tx'amxij yi alk'om nin ko atit tuch' i' yi nme'l tzaj talk'al, tajwe'n tan tk'ol junt tir, nin tajwe'n tan ẍchojol cob tir yi jamel yi wacẍ, nka yi cne'r, nka yi buru', yi mme'l tzaj talk'al. ");
INSERT INTO aguBl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","”Ej nin ko at jun yil tzakpun cyen tawun tul cojbil jun wisin, tajwe'n tan tk'ol xel yi mbi mbaj tan yi tawun. Poro tajwe'n tan tk'ol yi mas balaj te yi tetz cosech. ");
INSERT INTO aguBl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","”Ncha'tz ko at jun yi tzakpun len jun k'ak' xo'l tze' nin kol tz'e' yi triw yi wisin ta'n, tajwe'n tan ẍchojol tircu'n yi ntz'e' tan yi k'ak'a'tz, qui'c na ban yi ko nsken molxij yi triw nka qui'. ");
INSERT INTO aguBl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","”Ej nin ncha'tz kol tabnaj jun yaj mu'ẍ pu'k nka alchok e'chk takle'n tetz junt nin kol tz'e'l alk'a'n xe yi ca'l yi yaj, nin kol tx'amxij yi alk'om tajwe'n tan ẍchojol yi alk'om cob tir mas yi jamel yi mme'l tzaj talk'al. ");
INSERT INTO aguBl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Poro ko quil tx'amxij yi alk'om, yi yaj kale ncyaje't tabnal yi pu'k, tajwe'n tan bene'n ticy'le'n ẍchiwutz yi e' pujul xtisya' cwent Ryos tan lajluchaxe'n yi ko nk'e'tz i' yi alk'om. ");
INSERT INTO aguBl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","”Ncha'tz ko at jun yil tetzaj jun wacẍ nka jun cne'r nka jun chej nka alchok scyetz be'chok yi ncyaj stz'akol yi taw tajwe'n tan chibene'n yi taw tu yi nsic'on tetz ẍchiwutz yi e' pujul xtisya' cwent Ryos tan tiwle'n na' scyetz i' yi mero taw. Ma yi jun yi nk'e'tz yi taw tajwe'n tan ẍchojol cob tir jamel yi ntetzaj klo'. ");
INSERT INTO aguBl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","”Kol tabnaj jun yaj jun wacẍ nka jun ẍchej nka jun cne'r tetz junt yaj, nin ko takle'n bi' sban chi tane'n jun q'uixpe'n nka kol baj tan xo'j nka alchok junt jilwutz txuc, nka kol quim ẍchuc nin cyal jun tz'i'lon tetz, ");
INSERT INTO aguBl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","tajwe'n tan talol yi yaj kale abna'nt yi mero bintzi tetz yi taw, nin tajwe'n tan xcone'n bi' Ryos ta'n tetz stiwil yi yol yi bintzi nin na tal i' yi qui ntil i' yi ẍe'n mban yi txuc. Ko ya'tz, tajwe'n yil tocsaj yi taw yi txuc nin qui tajwe'n tan ẍchojol yi yaj kale abna'nt. ");
INSERT INTO aguBl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Poro ko swutz cunin i' yi ben alk'a'n yi tawun yi junt, tajwe'n tan ẍchojol i' yi jamel tetz yi taw. ");
INSERT INTO aguBl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ma ko i'tz jun smaron txuc mbnon, tajwe'n tan tule'n sowril nka yi wa'be'n yi smaron txuc ta'n tan ẍchajle'n tetz yi taw, nin qui tzun ẍchoj i'-tz yi jamel. ");
INSERT INTO aguBl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","”Ko at jun c'amon jun wacẍ nka jun chej tetz jun wisin, nin kol lo'on te yi c'amij tan yi yaj, tajwe'n tan ẍchojol i' yi jamel yi jun yi nc'am. ");
INSERT INTO aguBl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Poro ko xomij yi taw te'j yil lo'on nka yil quim, qui tajwe'n tan ẍchojol, ma na ntin yi c'ambil tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","”Ko at jun yaj yil tz'oc tan banle'n ruinl tetz jun xun yi ntaxk cunin po'tzaj tib, nin txe'n cunin ban jun trat tu jun yaj tajwe'n tan ẍchojol i' yi jamel xun yi bixba'nt, nin tajwe'n tan cyumewe'n tuch'. ");
INSERT INTO aguBl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Poro ko quil sc'ul yi taj yi xun tan toque'n yi yaj tetz chmil yi me'l, tajwe'n tan ẍchojol yi yaj yi bnon ruinl tetz, yi jamel yi xun. ");
INSERT INTO aguBl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","”Tajwe'n tzibiywok cu'n cyakil yi e' ajcun yil chijal tzixo'l wok. ");
INSERT INTO aguBl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","”Ncha'tz ko at jun yaj nka xna'n yi chiwitbej quib tu jun txuc, tajwe'n tan cwe'n biyij. ");
INSERT INTO aguBl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","”Cyakil yi e' yi chipate' chitx'ixwatz swutz junt ryos tajwe'n tan chicwe'n biyij. ");
INSERT INTO aguBl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","”Quil che' ibuch yi e' awer nak yi najlche' tzixo'l wok, nin quil che' ijis wok. Na ncha'tz axwok itetz ocnakquix tetz awer nak ẍchixo'l yi e' aj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","”Ej nin ncha'tz quil cxo'c wok tan chibuchle'n nka tan majle'n chime'bi'l yi e' xma'lca'n tu yi e' me'ba' yi qui'c chitaj chitxu'. ");
INSERT INTO aguBl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Na kol cxo'c wok tan chibuchle'n, nin yil jepon cyo'kl tzinwutz nocopon wetz tan chicolche'n tik'ab wok. ");
INSERT INTO aguBl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Nin ko ya'tz tziban wok ẍchi'chok inc'u'l tzite'j nin xquimok wa'n tul oyintzi'. Ej nin yi e' yi ẍchicyajk tetz xma'lca'n i'tz yi e' itetz ixkel tuml yi e' initxa'. ");
INSERT INTO aguBl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","”Ej ko at jun tzixo'l wok yil tz'ak'on c'mo'n tetz junt tanum qui na waj yil sjak ta'al yi pu'k chi na chiban yi e' ak'ol c'mo'n. ");
INSERT INTO aguBl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kol tak' jun yaj yi be'ch tetz, tetz prentil yi c'mo'n tajwe'n tan taje'n yi be'ch tetza'tz yil cu' k'ej. ");
INSERT INTO aguBl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Na quicunin batz ntina'tz yi be'ch tetz, nin ko tzun lquim tan che'w ko quil tzitak' wok yi be'ch tetz. Na ko quil tzitak' wok, mbil xcon ta'n tan colol tib tk'ab che'w yil wit. Cha'stzun te tajwe'n tan itk'ol wok yi be'ch tetz. Ncha'tz in kol chijak ẍch'eybil cyetz swetz swak'e', na yi in wetz na el ink'ajab scye'j. ");
INSERT INTO aguBl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","”Ncha'tz quil cxo'c wok tan telse'n k'ej yi itajcawil scyuch' yi e' pujul xtisya' cwent Ryos yi ate' tzitibaj. ");
INSERT INTO aguBl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","”Quil tz'el te ic'u'l tan tulse'n yi e'chk oy tzinwutz chi tane'n yi bajx wutz yi na jal te icosech tu yi bajx ta'al uva yi na jal. ”Ncha'tz yi bajx icy'ajl tajwe'n tan ijatxol swetz. ");
INSERT INTO aguBl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ncha'tz yi bajx cyal yi e' itawun yi ko mam chi tane'n wacẍ nka cne'r, ba'n tz'ul tan itoyil swetz, ba'n chicyaj cyen juk k'ej te chitxu', poro le wajxaki'n k'ej tajwe'n tan itk'ol swetz. ");
INSERT INTO aguBl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","”Ma jalu' yi axwok itetz tajwe'n tan itoque'n tetz intanum yi xansa'n che't. Qui tzun tzibajsaj wok yi ẍchi'bel jun itawun kol quim tan jun smaron txuc. Ma na ba'n tzic'ox wok len scyetz tx'i'. ");
INSERT INTO aguBl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","”Quil tzital yi e'chk takle'n yi qui'c xe' nin nk'era'tz bintzi. Quil cxo'c wok tetz stiw jun mal wunak, nin quil cxo'c wok tetz tuch' tan nuc'le'n jun xtxolbil yi nk'e'tz bintzi. ");
INSERT INTO aguBl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","”Ko at jun c'oloj wunak yi na chitzan tan nuc'le'n jun e'chk takle'n cachi' quil xom iwi' scye'j ptzunk jun c'oloj cu'n chixone'n. Quil xom iwi' scye'j. ");
INSERT INTO aguBl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ncha'tz quil xom iwi' te jun, ptzunk chin me'ba' nin i', ko i' aj paj. Quil xom iwi' te'j, mas balaj nque'n tan ma'le'n yi bintzi. ");
INSERT INTO aguBl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","”Ncha'tz ko ja tx'akxij yi tawun yi acontr, chi tane'n jun wacẍ, nka jun cne'r, nka alchok scyetz tawun i', nin kol nojquen tzawutz tajwe'n tan abene'n tan tak'le'n tetz i'. ");
INSERT INTO aguBl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Tajwe'n tan awoque'n tan ẍch'eye'n yi acontr yi na chi'ch c'u'l tzawe'j. Kol tzawil yi ja cu' jok yi ẍchej tzak' yi tektz, ch'eyaj i' tan telse'n yi tektz yi ẍchej. ");
INSERT INTO aguBl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","”Quil tz'el chik'ej yi e' me'ba' ita'n yil cxo'c wok tan jun xtisya'i'n, ma na tajwe'n yil cxom wok te yi xtxolbil yi bintzi. ");
INSERT INTO aguBl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","”Quil xom iwi' te jun ajxochonl yi nk'e'tz bintzi na tal. Nin quil tzibiy wok cu'n jun yaj yi qui'c til. Na quil tzincuy chipaj yi e' yi ya'tz na chiban. ");
INSERT INTO aguBl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","”Quil tzitz'am wok pwok tan tak'le'n til junt. Na na xcye' yi xo'c yi na ak'lij tzitetz tan jople'n iwutz nin tan xtxalbaje'n yi xtxumu'n jun balaj yaj. ");
INSERT INTO aguBl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","”Quil tzibuch wok yi e' awer nak yi ate' tzixo'l wok na ncha'tz axwok ocnakix tetz awer nak ẍchixo'l yi e' aj Egipto nin ilijt ita'n yi q'uixbel yi na ban jun yi awer nak,” stzun Ryos bantz scyetz yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Ncha'tz tal Ryos: “Ba'n xak'uj wok kak yob swutz itx'otx', nin ba'n lje' yi e'chk cosech swutz tetz yi kak yoba'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Poro le juki'n yob tajwe'n yil tz'uje' yi tx'otx', quil tzitawaj wok jun wi' ujul swutz te yi jun yoba'tz, na tajwe'n tan tujewe'n yi tx'otx'. Nin ba'n cyaj quen yi e'chk takle'n yi na ch'uy swutz scyetz e' me'ba', ncha'tz tetz chiwa' yi e' smaron txuc. Ban wok yi xtxolbile'j te cyakil yi icojbil, chi tane'n kale awije't e'chk uva nka yi e'chk oliw. ");
INSERT INTO aguBl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","”Ba'n cxak'uj wok kak k'ej. Na tajwe'n tan itujewe'n le juki'n k'ej. Ban wok yi xtxolbile'j tan cyujewe'n yi e' esclaw scyuch' yi e' awer nak yi na chak'uj tzituch'. Ncha'tz yi wacẍ tu yi e' chej tajwe'n tan cyujewe'n. ");
INSERT INTO aguBl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Cyakil yi xtxolbile'j yi ja wi't wal tzitetz, ban wok tane'n. Ej nin qui na waj yil tzina'wsaj wok junt ryos yi apart tzinwutz wetz mpe ik talche'n chibi',” stzun Ryos bantz scyetz yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Tajwe'n tan ticy'e'n ox balaj k'ej ita'n tul jujun yob tan itk'ol ink'ej. ");
INSERT INTO aguBl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ban wok tane'n yi wutz k'ej yi na baj yi pam yi qui'c xtx'amil ita'n. Ban wok chi yi walnak tzitetz. Tul yi juk k'eja'tz tajwe'n yil tzibajsaj wok yi pam yi qui'c xtx'amil. Tajwe'n tan iticy'sal le xaw Abib, na ya'stzun yi xaw yi itele'n tzaj Egipto. Nin cya'l jun nink tz'ul tzinwutz yi ko qui cy'a'n jun oy ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","”Ncha'tz ban wok junt balaj k'ej yil je' yi bajx wutz icosech. Ncha'tz ban wok junt balaj k'ej yil tzimol wok yi wi'tzbil icosech, yi na baj wi' yi yob. ");
INSERT INTO aguBl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Tajwe'n tan cyopone'n cyakil yi e' yaj tzinwutz ox tir le jujun yob. ");
INSERT INTO aguBl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","”Quil tzitoy wok yi ẍch'el itx'ixwatz swetz ko at mu'ẍ xtx'amil pam tzituch'. Ncha'tz quil tzicolwok yi ẍepu'il itx'ixwatz tetz junt eklok. ");
INSERT INTO aguBl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Nin ncha'tz i'tz yi bajx wutz yi mas balaj yi na waj yil tz'ul ita'n tzinwutz, na i ina'tz in itajcawil, yi iRyosil. ”Ncha'tz quil tzitxic wok yi e' tal ne'ẍ chiw tul yi xtxu'tx. ");
INSERT INTO aguBl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","”Bit wok tzaj, tz'ul inchakol yi wetz inángel tan bajxe'n tziwutz wok tan ẍchajle'n ibe', nin tan iq'uicy'le'n tan itopone'n le ama'l yi bixba'n wa'n. ");
INSERT INTO aguBl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Quil tzijatx wok len itib te'j, nque'n wok c'ulutxum jak' ca'wl, quil tzipaj wok yi ca'wl i', na ya'stzun inxel yi stz'a'tok tzixo'l wok, nin ko at jun sjuch til quil clax tk'ab. ");
INSERT INTO aguBl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Poro kol cxom wok te yi tetz tajbil, nin kol tziban wok tane'n yi tetz ca'wl, nin kol xom wok te yi xtxolbil yi nwal tzitetz, nocopon tzuntz tan icolche'n tk'ab yi icontr, nin tan oyintzi' scye'j. ");
INSERT INTO aguBl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Na sbajxok yi wetz inángel tziwutz wok, nin mben tcy'al i' axwok le ama'l kale ate't yi e' amorreo, e' hitita, e' ferezeo, e' cananeo, e' heveo tu e' jebuseo. Ej nin cyakil yi e' wunaka'tz chicopon insotzal. ");
INSERT INTO aguBl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Yil xopon wok le ama'la'tz quil xom wok te cyetz cyajtza'kl. Quil xmeje' wok ẍchiwutz yi cyetz chiryosil. Nin quil cxo'c wok tan chic'u'laje'n. Ma na ba'n tcu'n joy wok puntil tan xite'n cu'n chiryosila'tz yi banij tu' tane'n tu yi e'chk c'ub yi na chimeje' quen swutz. ");
INSERT INTO aguBl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ak' wok ink'ej, swak'e' tzun imbanl tibaj iwa' tu itc'a'. Ej nin xincole' tk'ab cyakil ya'bil yi tz'ul tziwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nin nocopon tan icolche'n. Nin mben ẍkon yi itiemp wa'n jalen yil tz'opon yi itiemp. Kalena'tz xquim wok. Ncha'tz kol tzitak' wok ink'ej quil jal jun xna'n tzixo'l wok yi quil jal tal nka jun yi quil jepon xa'wlil. ");
INSERT INTO aguBl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","”Tz'ocopon ink'ol jun chin xo'w scyetz cyakil wunak nin cyakil nación kale xicy'e't wok, nin chixobok tzitetz. Nocopon tan chixo'wse'n, tan cyele'n ojk tziwutz wok. ");
INSERT INTO aguBl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nocopon tan chixo'wse'n, bantz cyele'n ojk yi e' heveo scyuch' yi e' hitita, nin yi e' cananeo. ");
INSERT INTO aguBl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Quil che'l chan yi e' wunaka'tz swutz yi ama'la'tz. Quil che'l tetz jun ntzi' yob wa'n. Ma ko che'l, qui cunin batz ẍchijalok wi'nin smaron txuc tul yi ama'l nin xlo'onk cya'n. ");
INSERT INTO aguBl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Chelopon incy'al swutz yi tx'otx' poro chebele'n cuntu'. Quil che'l wa'n jalen yil jal wi'nin initxajil. Kalena's tzun che'l wa'n bantz itetzal yi ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ma yi mojomil yi ama'la'tz ja wi't cu' wa'n. Cho'n xe'tij kale atite't yi Cyak Mar nin cho'n na opon jalen stzi' mar kale ate't yi e' filistey. Ncha'tz cho'n na xe'tij le ama'l tz'inunin tu' nin na opon kale atite't yi tzanla' Eufrates. Ja wi't wak' yi jun ama'la'tz tzitetz. Nin axwok xe'lsan yi e' wunak yi ate' swutz. ");
INSERT INTO aguBl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","”Quil tzitok'bej itib scyuch'. Nin quil cxom wok te cyetz cyajtza'kl. Nin quil tziban wok jun trat scyuch' mpe ik te chiryosil. ");
INSERT INTO aguBl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ncha'tz quil tzitak' wok ama'l tan chicyaje'n cyen tzixo'l wok, na ko tzun cxom wok scye'j tan lok'e'n yi cyetz chiryosil. Na ko ya'tz, xtx'akxok wok tan paj,” stzun Ryos bantz scyetz yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Itzun bantz nintzun jilont Ryos tetz Moisés itzun taltz: —Ba'n cxu'l wok tzinwutz. Xomok tzaj Aarón tu Nadab tu Abiú tzawe'j. Ncha'tz chixomok tzaj oxc'al tu lajuj wi' banl wi' yi ate' ẍchixo'l yi e' xonl Israel. Catzamwok le ama'l kale atine't. Poro quil tziẍkans tzaj itib mas kale atine't, ma na ba'n tcu'n xcyaj wok joylajlen mu'ẍ. Ej nin tajwe'n tan imejewe'n cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ntin cu'n aẍ Moisés ba'n cẍu'l tzinwutz, ma yi e' mas wi' banl wi' tajwe'n tan chicyaje'n cyen joylajlen. Ej nin qui'c cuj tan chije'n tzaj wunak wi wutze'j, stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Bene'n tzun Moisés tan talche'n scyetz cyakil yi e' xonl Israel yi mbi cu'n tal Ryos tetz. Ncha'tz tal i' cyakil yi e'chk ca'wl yi alijt tan Ryos tetz. Yi quibital yi e' xonl Israel yi e'chk ca'wla'tz nintzun e' cujijtz nin cyaltz: —Skabne' tircu'n, quib yi ntal Ryos yi tajwe'n tan kabnol. ");
INSERT INTO aguBl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Toque'n tzun Moisés tan stz'ibe'n cyakil yi xtxolbil yi tal Ryos tetz. Ma le junt eklok jalchan cunin c'ase'n Moisés nintzun ben i'-tz tan banle'n jun patbil xtx'ixwatz xe c'u'l yi wutz. Ncha'tz cu' tawal coblaj c'ub, jujun te jujun k'u'j xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Yi wi't bnixe'n yi patbil xtx'ixwatz nin ben ẍchakol cobox xicy tan quicy'le'n tzaj cobox mam tor, tan chicwe'n biyij nin tan pate'n tetz chitx'ixwatz swutz Ryos, tan jale'n cuybil chipaj swutz i'. Ncha'tz e' cu biyol cobox mam tora'tz tan toye'n tetz tan ẍchajle'n yi tzatzin paz yi ja jal ẍchixo'l tu Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Toque'n tzun Moisés tan stz'amle'n yi chiẍch'el yi mam tora'tz tul e'chk xal. Cob tzun eltz ta'n. Jun tx'akaj cho'n cwe'n ta'n tul xal, nin junt tx'akaj cho'n bene'n kojol tibaj yi patbil tx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Kalena'tz tzun je'n tcy'al Moisés yi liwr kale atit yi trat yi bnixnak tu Ryos, nin oc i'-tz tan si'le'n ẍchiwutz cyakil yi e' xonl Israel. Yi quibital cyakil yi xonl Israel nintzun cyaltz: —Skabne' tane'n cyakil yi na tzan Ryos tan talche'n sketz nin kocopon c'ulutxum jak' ca'wl i'. ");
INSERT INTO aguBl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Bene'n tzun Moisés tan ẍchitle'n yi chich' ẍchiwi' cyakil yi e' wunak yi ate'-tz, nin tal i'-tz: —Yi chich'e'j i'tz jun techl yi ja bixe' chitratu' tu Ryos. Cyakil yi yol yi minsi'lej ẍchiwutzu' ya'stzun xe' yi katrat tu Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Chibene'n tzun tetz Moiséstz wi'wtz. Xomche' Aarón, Nadab tu Abiú te'j. Ncha'tz xomche' oxc'al tu lajuj wi' banl wi' scye'j. ");
INSERT INTO aguBl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Cho'n tzun quilol wutz yi chiRyosil. Tzak' tkan Ryos at jun yi chin litz'unin chi tane'n yi jun jilwutz c'ub yi na bi'aj zafiro, nin yi chin skoj nin chi tane'n yi tcya'j. ");
INSERT INTO aguBl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Qui'c nin tzun e' ban yi e' yaja'tz yi quil wutz Ryos, na qui'c e' tulej Ryos. Ncha'tz e' wan nin e' uc'a'-tz swutz yi jun ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Jilone'nt tzun Ryos tetz Moisés. Itzun taltz: —Moisés, ba'n cẍu'l wi'wtz kale atine't wetz, nin ba'n chin ach'iw na swak'e' cobox lepaj c'ub tzatz kale tz'ibane't yi e'chk ca'wl tu e'chk ley yi tajwe'n tan chibnol tane'n yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Bene'n tzun Moisés le ama'l kale talwit Ryos tetz. Cho'n tzun je'n i' wi'wtz nin xomnin Josué te'j, yi tetz ẍch'eyum. ");
INSERT INTO aguBl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Yi chijatxol quib nintzun tal Moisés scyetz yi e' wi' banl wi': —Chicyajku' tzone'j nin ba'n ko' chich'iwu' tzone'j jalen yil kacu'ul. Ẍchicyajk cyen Aarón tu Hur scye'ju', nin ko at jun tajwe'n nka jun chiproblemu' ba'n cyalu' scyetz, stzun Moisés ban. ");
INSERT INTO aguBl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Yi baje'n tlol Moisés yi xtxolbile'j nintzun je'-tz wi'wtz. Saje'n tzun jun c'oloj sbak' nin jopxij yi wi'wtz ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Cwe'n mule'n tzun yi k'ej tu pak'puchal Ryos tibaj yi wi'wtz Sinaí. Kak k'ej ban yi sbak' tibaj yi wi'wsa'tz, ma le juki'n k'ej nintzun ẍchak Ryos Moisés tul yi sbak'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ma yi e' xonl Israel ja quil yi pak'puchal Ryos yi at tibaj yi wutz Sinaí. Cho'n cunin ban yi sbak' chi na ban k'ak'. ");
INSERT INTO aguBl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Inti Moisés nintzun octz tc'u'l yi sbak'a'tz nintzun je'-tz jalen wi'wtz. Ca'wunak k'ej nin ca'wunak ak'bal a'tij Moisés tul yi jun sbak'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Nintzun tal Ryos tetz Moisés: ");
INSERT INTO aguBl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Moisés, alaj scyetz cyakil yi e' xonl Israel tan chimolol jun balaj oy tan cyak'ol swetz. Poro ntin na waj yil cyak' yi e' yi tetz cu'n cyalma' yi na cyaj cyak'. Nin quil tziban wok puers scyetz yi e' yi qui na cyaj cyak'. ");
INSERT INTO aguBl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Nin cyakil yi e'chk takle'n yi ba'n cyak' i'tz yi oro, sakal tu cobre. ");
INSERT INTO aguBl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Ncha'tz ba'n cyak' yi e'chk nok' yi txib yubil tu púrpura, nin cyak. Ncha'tz ba'n cyak' yi balaj nok' lino tu yi xi'il chiw. ");
INSERT INTO aguBl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Nin ba'n chimol yi stz'uml cne'r yi ocnak stz'acl yi cyak yubil. Nin ba'n chimol balaj tz'u'm, tu yi e'chk balaj tze' chi tane'n yi acacia. ");
INSERT INTO aguBl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Ncha'tz ba'n cyak' aceit yi xconk tetz lampr, nin yi e'chk tz'ac'bil yi na cu' tc'u'l tetz perfum yi xconk tan xanse'n e'chk takle'n nin tan pate'n tan c'o'caxe'n tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Nin ncha'tz ba'n cyak' yi e'chk balaj c'ub, chi tane'n yi cornalina, nka yi e'chk mas balaj c'ub. Na xconk tetz yi lantar tu yi xbu'k yi xconk wutz c'u'l yi wi'tz pale'. ");
INSERT INTO aguBl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ncha'tz ban wok jun innajbil tan innajewe'n tzixo'l wok. ");
INSERT INTO aguBl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Poro yi jun innajbila'tz tu cyakil yi e'chk takle'n yi tz'ocopon tc'u'l, tajwe'n tan ibanol chi yi swale' tzatz. Tajwe'n yi ni'cu'n tz'an chi yi tzinchaje' tzawetz. ");
INSERT INTO aguBl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","”Ban wok jun caẍa' te yi balaj tze' acacia. Nin je yi ma'lbil yi ba'n xcon ita'n tan banle'n. Jun metr tu lajuj centimetr tzitulej wok yi tkan, ma yi wutz, oxc'al tu o' centimetr tz'an. Ncha'tz tz'an yi wutz tkan, oxc'al tu o' centimetr tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Yil bnix, ba'n tz'oc jun yubil stzi'ak chi tane'n cornis, yi oro cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ncha'tz ban wok cyaj argoy yi oro cu'n, nin ba'n tz'oc te c'u'l yi caẍa'. Cob le jalaj xlaj nin cob le jalajt. ");
INSERT INTO aguBl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Nin ban wok cob k'a'j te yi tze' acacia. Nin ba'n tz'oc oro te'jak. ");
INSERT INTO aguBl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Yil bnix ba'n tz'icy' ita'n tc'u'l yi e'chk argoy yi at te c'u'l yi caẍa', na xconk tan palche'n nin. ");
INSERT INTO aguBl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Yil tz'oc yi e'chk k'a'jila'tz tul e'chk argoy, nin ba'n cyaj quen tu' tul. ");
INSERT INTO aguBl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ej nin tul yi caẍa'a'tz ba'n tzitak' wok cu'n yi cob lepaj c'ub kale tz'ibane't yi ca'wl yi swak'e' tzitetz. ");
INSERT INTO aguBl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","”Ncha'tz ban wok jobsel yi caẍa', tan balaj oro. Jun metr tu lajuj centimetr yi tkan, ma yi wutz, i'tz oxc'al tu o' centimetr tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ban wok teblal cob querubim, txak'ij tzitulej wok te yi balaj oro. Nin ak'woke'n tibaj yi jobsel yi caẍa'a'tz. Ba'n cyaj jun le max nin jun le sbal. ");
INSERT INTO aguBl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Yi jobsel yi caẍa'a'tz, tu yi cob teblal querubima'tz, junit tz'an yi bambil tetz. Nin yi cob querubima'tz ba'n lcyaj jujun le jalaj stzi' yi jobsel yi caẍa'. ");
INSERT INTO aguBl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ma yi cob teblal querubima'tz, yi ate' tibaj yi jopsel, tajwe'n tan chixmayil quib squibil quib. Poro na taj yi cho'n chixmayin cu'n te jobsel yi caẍa'a'tz. Ncha'tz tz'an yi chixicy'. Cho'n tz'aj cu'n wi yi caẍa', tan jople'n cu'n yi caẍa' tan chixicy'. ");
INSERT INTO aguBl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Yil bnix yi jobsel yi caẍa' ita'n, ba'n tzitak' woke'n tibaj yi jun caẍa'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ma jalu' Moisés, cho'n chinjilon tzaj tzatz tibaj yi jobsel yi caẍa'a'tz nin ẍchixo'l yi cob teblal querubima'tz. Cho'n chinjilonk tzatz nin swale' yi inca'wl tzawetz tan awalol scyetz yi e' xonl Israel tan chixome'n te'j,” stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Ncha'tz tal Ryos tetz Moisés: “Ban wok jun mes tan yi balaj tze' yi acacia. Nin je yi ma'lbil yi ba'n xcon ita'n. Jun mutx' tu lajuj centimetr tz'an yi tkan. Ma yi wutz, ca'wunak o' centimetr tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ba'n tz'oc oro ita'n te cyakil yi jun mesa'tz tan jople'n cyakil yi tze'. Nin ba'n tz'oc jun yubel stzi'ak yi mes yi oro cu'n tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ncha'tz ba'n bnix junt yubil yi oro cu'n tibaj yi mesa'tz nin loxcunin tz'an stzi'ak. Juk centimetr tz'an yi wutz tkan yi jun yubila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ncha'tz ban wok cyaj argoy yi oro cu'n, nin oken jujun te'jak yi xtx'u'c yi mes, kale atit yi cyaj tkan. ");
INSERT INTO aguBl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Yi cyaj argoy ba'n tz'oc tzak' yi yubil yi at stzi' yi mes, na yi xac i'tz tan ticy'e'n jun k'a'j tul tan palche'n nin yi mes. ");
INSERT INTO aguBl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ncha'tz ban wok yi cob k'a'j tan acacia nin ba'n tz'oc oro te'jak. Xconk yi cob k'a'ja'tz tan palche'n nin yi mes. ");
INSERT INTO aguBl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ncha'tz cyakil yi e'chk ma'cl yi xconk xe innajbil, chi tane'n yi e'chk lmak cuchar, nka yi e'chk xaru', nka yi e'chk ẍwok' yi na xcon tan molche'n yi e'chk oy yi na opon, tajwe'n yi oro cu'n tz'an tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Yi pam yi ilenin tz'ul ita'n tan cyaje'n cyen tzinwutz, ba'n cyaj tibaj yi jun mesa'tz,” stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ncha'tz tal Ryos tetz Moisés: “Ban wok jun cantil yi oro cu'n. Yil cxo'c tan banle'n txak'ij tzitulej wok tan martiy. Juk wi' tz'an yi jun cantila'tz. Junit tz'an cyakil weklil yi jun cantila'tz. Yi xe' tu yi tkan tu yi juk cu'lbil aceit tu yi yubil chi tane'n tal ne'ẍ buch yi ntaxk je pok'l, junit tz'an tircu'n tan jun ntzi' piẍ oro. ");
INSERT INTO aguBl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Nin te yi jun cantila'tz, ba'n tz'el kak k'ab, ox le jalajchak xlaj, nin jun nicy'al. ");
INSERT INTO aguBl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ncha'tz te'jak yi kak k'ab yi na el te yi tkan, ba'n tziban wok ox tal ne'ẍ buch. Cho'n cunin tz'an chi tane'n tal buchil jun wi' almendro yi ntaxk je chitp. ");
INSERT INTO aguBl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Nin te yi tkan, ba'n bnix cyajt tal ne'ẍ buch. Cho'n tz'an chi tane'n yi buchil yi almendro yi ntaxk je' chitp. ");
INSERT INTO aguBl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ba'n tz'oc jujun tzak' e'chk k'ab yi na el te yi tkan. ");
INSERT INTO aguBl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Yi e'chk tal ne'ẍ bucha'tz tu e'chk k'ab junit tz'an tu yi tkan. Oro cu'n tz'an tircu'n nin txak'ij tzitulej wok tan martiy. ");
INSERT INTO aguBl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Nin tibaj yi jujun k'ab, ban wok jujun tal ne'ẍ txekbil tan xcone'n tan xtxeke'n cyakil yi at swutz. ");
INSERT INTO aguBl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Cyakil yi e'chk ma'cl chi tane'n yi elsbil yi mecha' yi tz'e'nak tu e'chk tal ne'ẍ lak tajwe'n yi oro cu'n tz'an chicyakil cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ba'n xcon ox arow balaj oro ita'n, tan banle'n yi jun cantila'tz tu cyakil yi e'chk ma'cla'tz yi na taj. ");
INSERT INTO aguBl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ban wok yi jun ak'une'j Moisés, nin ban wok chi yi e'chk techl yi minchaj tzatz tzone'j wi'wtz,” stzun Ryos bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Ncha'tz tal Ryos tetz Moisés: “Ban wok jun innajbil yi mantial cu'n tz'an. Ba'n xcon lajuj xbu'k yi lino cu'n yi bak'u'n wutz, tu yi e'chk yubil yi txib, xk'ayk'uj nin cyak. Nin ban wok teblal e' querubim swutz. Nin joy wok puntil yi sk'il cunin tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Cyakil yi e'chk xbu'k yi tzibne', tajwe'n yi junit ma'lbil tz'an tircu'n. Nin je yi ma'lbile'j: Coblaj metr tu ni'cy tz'an yi tkan, ma yi wutz cob metr tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Chup wok cu'n o' xbu'k. Ncha'tz tz'an yi o'-t, chup wok cu'n, ba'n tok'bej tib yi stzi'ak tan yi stz'isbil tetz yi junt. ");
INSERT INTO aguBl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ban wok e'chk jul stzi'ak yi cob chin xbu'ka'tz, tan ticy'e'n yi c'albil tetz tc'u'l. Ba'n xcon yi lino yi txib yubil ita'n tan banle'n e'chk c'albila'tz. Ncha'tz ni'cu'n sban yi cob chin xbu'ka'tz yi chupijche'. ");
INSERT INTO aguBl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ban wok nicy' cient jul te yi cob xbu'ka'tz. Nicy' cient te yi jujun, nicy' nin tu' tz'an yi xo'l tan cwe'n tok'bel tib yi cob xbu'ka'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Nin ban wok nicy' cient ganch yi oro cu'n tan ẍchuple'n yi cob xbu'ka'tz, na xconk tan stz'amle'n yi xbu'k tu yi junt bantz junit tz'an yi wi' yi jun innajbila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","”Ncha'tz ban wok junlaj xbu'k tan xi'il chiw tan je'n tibaj yi bajx xbu'ka'tz yil je' tibaj innajbil. ");
INSERT INTO aguBl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Junit ma'lbil tz'an cyakil yi e'chk xbu'k yi xi'il chiw cu'n. Nin je yi ma'lbile'j: Oxlaj metr tu ni'cy yi tkan. Ma yi wutz cob metr. ");
INSERT INTO aguBl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Tz'is wok cu'n o' xbu'k nin junit sban. Ncha'tz yi kakt, tz'is wok cu'n. Ma yi bajx te yi kaka'tz yil cyaj swutz, ba'n tzipak wok cu'n nicy'al. ");
INSERT INTO aguBl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ba'n tziban wok nicy' cient jul te'jak yi cob lmak xbu'ka'tz kalel tz'icy'e't e'chk ganch tan chic'alche'n. ");
INSERT INTO aguBl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ban wok nicy' cient ganch yi brons cu'n. Nin ba'n tz'oc te'jak yi e'chk julil yi cob xbu'ka'tz bantz junit tz'an yi wi' innajbila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Nin yi sobril yi cob xbu'ka'tz yi junit mban, ba'n cyaj tu' ch'imba'n wutz coc yi innajbila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ma yi xlajak yi innajbila'tz sobrink cyen ca'wunak o' centimetr swutz yi bajx xbu'k. ");
INSERT INTO aguBl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","”Ncha'tz ban wok jun pa'tbil tan stz'uml cne'r nin ba'n je' ita'n tibaj innajbil. Ba'n cu' yi tz'u'ma'tz tul stz'acl yi cyak yubil. Ncha'tz ban wok junt pa'tbil tan junt jilwutz tz'u'm tan jople'n tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","”Ban wok cobox tablón te yi balaj tze' acacia tan xcone'n tetz cajonil innabil. Nin joy wok puntil tan banle'n yi sk'il cunin tan yube'n. ");
INSERT INTO aguBl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Yi jujun tablóna'tz tajwe'n yi cyaj metr tu ni'cy tz'an yi tkan. Ma yi wutz oxc'al tu o' centimetr tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Te yi e'chk tablóna'tz ba'n bnix cob stz'ambil tetz te yi jujun. Nicy' nin tu' tzitulej cyakil yi e'chk tablóna'tz yi xconk tetz cajonil yi innajbil. ");
INSERT INTO aguBl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ban wok junak tablón te yi jalaj xlaj yi na xmayin nin cwe'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Nin ban wok ca'wunak simient yi sakal cu'n tz'an tan cyaje'n cyen xe yi e'chk tablóna'tz. Cob simient te yi jujun tablóna'tz tan toque'n yi cob stz'ambil tetz tul. ");
INSERT INTO aguBl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ncha'tz tz'an yi jalajt xlaj yi innajbil yi na xmayinin je'n tzi'n. Tajwe'n yil xcon junak tablón ita'n te yi jalaja'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Nin ban wok ca'wunak simient yi sakal cu'n tz'an tan cyaje'n cyen cob tzak' yi jujun tablón. ");
INSERT INTO aguBl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ma yi jalajt xlaj innajbil, yi jalaj yi na xmayin nin toque'n tzi'n, ban wok kak tablón tan xcone'n te yi jalaja'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Nin ba'n xcon cobt tablón tetz yi cob xtx'u'c. ");
INSERT INTO aguBl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ba'n tz'oc te yi jujun yi at lakak xtx'u'c. Nin ba'n chic'alxij tan ch'ich'. ");
INSERT INTO aguBl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Nin yi wajxak tablóna'tz tajwe'n yi at len cob simientil te jujun yi sakal cu'n. Waklaj tzun simient na taj tan cyaje'n cyen tzak' yi wajxak tablóna'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","”Ban wok o' k'a'j tan tze' acacia. Na xconk tetz k'a'jil yi tablón yi tz'ocopon te yi jalaj xlaj yi cajonil innajbil. ");
INSERT INTO aguBl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Ncha'tz ban wok o't k'a'j tetz yi jalajt xlaj yi cajonil, nin ban wok o't k'a'j tetz yi jalajt wutz coc yi na xmayinin toque'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Yi jun k'a'j yi tz'icy'pon tul yi e'chk tablón, tajwe'n yil tz'icy' tc'u'l tircu'n nin nicy'al cu'n tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ncha'tz ba'n tz'oc oro te'jak yi e'chk tablóna'tz tu yi e'chk k'a'jil yi xconk tetz solte'j. Ncha'tz ban wok cobox argoy yi oro cu'n tz'an kalel chicy'e't yi e'chk k'a'jila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Nuc' wok bin yi jun innajbila'tz, tajwe'n tan ixome'n te yi plan minchaj tzatz wi'wtz,” stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Ncha'tz tal Ryos tetz Moisés: “Ban wok jun xbu'k tan jople'n yi ama'l yi chin xan nin. Tajwe'n xcon yi nok' yi txib yubil tu xk'ayk'uj nin cyak, nin ba'n bnix tan yi balaj lino yi bak'u'n tz'an. Yi jun xbu'ka'tz chemij tzitulej wok nin ba'n tz'oc teblal cob querubim swutz yi chin c'otij cunin tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ba'n cho'c cobox ganch yi oro cu'n te'j nin ba'n je' ch'imba'n te'j cyaj tkan ca'l. Yi cyaj tkan ca'la'tz ba'n bnix tan acacia nin ba'n tz'oc oro te'j, nin ba'n je' len tibaj jujun xe' yi sakal cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ba'n tzun tzich'imbaj woke'n yi xbu'ka'tz te yi e'chk gancha'tz. Ej nin tc'u'l yi jun xbu'ka'tz ak'wok quen yi caẍa' kale tz'ibane't yi contrat yi bnixnak wa'n tzituch'. Ncha'tz yi jun xbu'ka'tz xconk tan jatxle'n xo'l yi ama'l yi xan, tu yi ama'l yi wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Nin tc'u'l yi ama'la'tz yi wi'nin xanil ba'n tz'oc yi caẍa' kale atit yi incontrat yi bnixnak wa'n tzituch', nin ak'woke'n yi jopselil. ");
INSERT INTO aguBl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Swutze'l tzaj yi jun xbu'ka'tz ba'n cyaj cyen yi mes kale na je't yi pam. Ba'n tz'oc xlaj yi tapij yi na xmayinin je'n tzi'n. Ma yi jun cantila'tz yi juk cu'n wi' at, ba'n cyaj te yi jalaj xlaj yi na xmayinin cwe'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","”Ncha'tz banaj junt xbu'k yi xconk tetz yi puertil yi innajbil. Ba'n xcon yi nok', yi lino bi', ita'n, yi bak'u'n tane'n. Nin ba'n xcon yi txib yubil tu yi xk'ayk'uj nin cyak. Chin c'otij cunin tzitulej wok. ");
INSERT INTO aguBl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ej nin ncha'tz ban wok o' tkan ca'l te yi tze' acacia yi xconk tan je'n yi xbu'k te'j. Nin oken oro te'jak. Ba'n tz'oc jujun ganch yi oro cu'n te'jak yi jujun tze'a'tz. Nin ban wok o' xe' tetz yi e'chk tkan ca'la'tz tan brons,” stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ncha'tz tal Ryos tetz Moisés: “Ban wok jun patbil itx'ixwatz tan acacia yi cyaj xtx'u'cnaki'n, nin je yi ma'lbil tzituleje'j: Cob metr tu junak o' centimetr tzitulej yi xlajak, ma yi wutz tkan jun metr tu junak o' centimetr tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ban wok cyaj tuc', jujun lakak xtx'u'c. Junit tz'an yi tuc'a'tz tu yi patbil tx'ixwatz. Ej ba'n tz'oc brons te'jak nin tul yi jun altara'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ncha'tz ban wok cobox ma'cl yi xconk te yi patbil itx'ixwatz, chi tane'n yi cu'lbil tza'j tu yi e'chk pale't nin yi e'chk ẍwok' nin cyakil yi e'chk pac'bil ẍwok' tu e'chk cu'lbil xtxak'ak'. Brons cu'n tzitulej wok tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ban wok jun patbil chi'baj tan brons nin oken cyaj argoy te'jak xtx'u'c yi jun patbil chi'baja'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Yil bnix yi jun ch'ich'a'tz ba'n cu' ita'n tc'u'l yi altar poro tul nicy'an cyen tu', na qui tajwe'n tan cwe'n pone'n jalen txe' cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ncha'tz ba'n tziban wok cobox k'a'j nin ba'n xcon yi tze' acacia ita'n tan banle'n, nin ba'n tz'oc brons ita'n te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Yil bnix yi e'chk k'a'ja'tz ba'n tzun tz'icy'tz ita'n tul yi e'chk argoy yi at te yi altar. Na xconk tan palche'n nin yi altar, nin tan ticy'le'n nin. ");
INSERT INTO aguBl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Yi jun patbil itx'ixwatza'tz, jul tz'an tc'u'l nin ba'n xcon tz'lum acacia ita'n tan banle'n chi yi jun yi minchaj tzatz wi'wtz,” stzun Ryos ban tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Ban wok jun tapij solte'j yi wutzk'anil yi innajbil. Ca'wunak o' metr tz'an yi xlaj yi na xmayin nin cwe'n tzi'n. Ba'n xcon yi balaj lino yi bak'u'n tan banle'n jun xbu'k yi xconk tetz yi jun tapija'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ncha'tz ban wok junak tkan tze' kalel je't yi jun xbu'ka'tz. Ncha'tz ban wok junak cu'lbil tkan yi tze'a'tz te'j. Brons cu'n tzitulej. Ncha'tz ban wok junak ganch tu yi stz'amol tetz yi e'chk cu'lbila'tz, tan yi ch'ich' yi sakal, na xconk tan stz'amle'n yi xbu'k. ");
INSERT INTO aguBl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ncha'tz tz'an yi jalaj xlaj yi na xmayin nin je'n tzi'n, tajwe'n yil tz'oc yi balaj xbu'k te'j, nin ite'n nin ma'lbila'tz sbne' chi yi jalajt xlaj. Ncha'tz yi junak tkan tu e'chk cu'lbil tkana'tz, brons cu'n tz'an. Ma yi e'chk ganch tu e'chk tz'ambil tetz, sakal cu'n tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ma te yi jalaj xlaj yi na xmayin nin toque'n tzi'n, tajwe'n yi junak cob metr tu ni'cy tz'an. Nin ban wok lajuj tkan tu yi e'chk cu'lbil. ");
INSERT INTO aguBl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ej ite'n nin tz'ana'tz yi jalajt xlaj yi na xmayin nin tele'n tzi'n. Junak cob metr tu ni'cy tz'an, nin xconk xbu'k tan jople'n. Nin te yi xlaje'j ba'n cyaj cyen yi puertil yi innajbil. ");
INSERT INTO aguBl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Xlajak yi puert ba'n tziban wok juk metr balaj xbu'k tetz tapij. Ban wok ox tkan tu ox simientil te yi bajx xlaj. ");
INSERT INTO aguBl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ncha'tz tz'an le jalajt xlaj, juk metr tz'an nin ba'n tz'oc ite'n nin ma'lbil xbu'ka'tz. Ej nin ban wok oxt tkan tu yi cu'lbil tkan. ");
INSERT INTO aguBl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ma tetz yi puertil, ba'n xcon yi e'chk nok' yi txib yubil tu xk'ayk'uj nin cyak, nin ba'n bnix tan yi balaj lino yi bak'u'n tz'an. Yil cxo'c wok tan ẍchemle'n chin c'otij cunin tz'an. Beluj metr tz'an yi jun xbu'ka'tz yi xconk tetz yi puert. Ncha'tz ban wok cyaj tkan tu cyaj xe' yi e'chk tkana'tz yi tz'ocopon tzak' yi xbu'k tetz puert. ");
INSERT INTO aguBl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Cyakil yi e'chk tkan yi tz'ocopon solte'j yi innajbil tajwe'n yil xcon sakal tan banle'n yi e'chk ganch tu yi stz'ambil tetz yi ganch. Ncha'tz tajwe'n yil xcon brons tan banle'n yi e'chk xe'. ");
INSERT INTO aguBl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ma yi wutzk'anil yi innajbil ca'wunak o' metr yi tkan tz'an, nin yi wutz junak cob metr tu ni'cy tz'an. Ite'n nin tz'ana'tz yi wutz coc. Ma yi wutz tkan cob metr tu junak o' centimetr tz'an. Ej nin yi e'chk xbu'k yi xconk te yi innajbil lino cu'n yi bak'u'n tane'n. Ma yi e'chk xe', brons cu'n tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Nin cyakil yi e'chk ma'cl yi xconk ita'n wutzk'anil tan inna'wse'n tajwe'n yi brons cu'n tz'an tircu'n. Ncha'tz cyakil yi e'chk staqui yi at tc'u'l nin solte'je'l tzaj yi pe'm, tajwe'n yi brons cu'n tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","”Ma jalu' Moisés alaj scyetz cyakil yi e' xonl Israel tan tule'n balaj aceit tetz oliw yi che'ja'n tane'n, na xconk tan cu'se'n tul yi e'chk cantil tan xtxeke'n cyakil k'ej xe innajbil. ");
INSERT INTO aguBl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Nin ba'n cho'c Aarón scyuch' e' cy'ajl tan cu'se'n aceit tul yi e'chk cantil yi at tul yi bajx cuart yi at swutz yi xbu'k yi na jopon tetz yi caẍa' kale atit yi ca'wl tetz katrat yi bnixnak wa'n tzituch'. Nin yi e'chk cantila'tz tajwe'n yi tuninl txekun cu'ntz cyakil ak'bal tul yi ama'l kalel kac'ulwit kib tzituch'. Ej nin yi xtxolbila'se'j i'tz jun ca'wl sbne' scyetz yi e' xonl Israel scyuch' cyakil chixonl sbne' opon tunintz,” stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ma jalu' Moisés, ẍchixo'l cyakil yi e' xonl Israel chakwe' yi awutzicy Aarón scyuch' yi e' cy'ajl yi na chibi'aj Nadab tu Abiú tu Eleazar nin Itamar. Chakwe' tan cyule'n tzawutz, na tajwe'n tan chixcone'n swetz tetz pale'. ");
INSERT INTO aguBl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Nin ba'n tzaban be'ch tetz yi awutzicy Aarón, tan jale'n k'ej i' nin tan yube'n. Chin xan nin sbne' yi be'choka'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Joywe' cobox balaj yaj yi ja wak' cyajtza'kl tan banle'n yi balaj be'choka'tz. Ba'n tzawal scyetz tan cyoque'n tan banle'n yi be'ch tetz Aarón. Bantz xansal tib Aarón tetz jun pale' tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Nin yi be'ch tetz i' yi tajwe'n tan ibnol i'tz yi je'j: jun tal ne'ẍ xbu'k yi tz'ocopon wutz c'u'l yi na bi'aj pectoral tu jun lantar yi na bi'aj efod. Ncha'tz banaj junt xbu'k yi chitpu'n nintu' yi at yubil stzi'ak nin yi xconk tzak' yi lantar. Nin ban wok junt xbu'k yi nim tcu'n tkan yi scyajk tzak' yi mant. Ncha'tz banaj jun xbu'k yi jepon te wi', nin banaj jun c'albil yi tz'ocopon xe c'u'l. Ban wok bin yi balaj be'choka'tz tetz yi awutzicy Aarón tu yi e' cy'ajl, bantz chixcone'n tetz pale' tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Yil tz'oc banle'n, ba'n xcon oro tu e'chk xbu'k yi txib yubil tu xk'ayk'uj nin cyak. Ej nin chemij tz'an tan balaj lino yi bak'u'n wutz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","”Yi yubil yi nok' yi xconk tan banle'n yi lantar i'tz oro, tu e'chk nok' yi txib nin xk'ayk'uj tu cyak yubil. Ej nin ba'n xcon yi e'chk lino yi bak'u'n wutz. Chemij tz'an, nin chin c'otij cunin tz'an yil tz'oc ẍchemle'n. ");
INSERT INTO aguBl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Nin ba'n tz'oc cob ganchil wi xulchub tan stz'amle'n. ");
INSERT INTO aguBl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ncha'tz banaj jun c'albil yi tz'ocopon xe c'u'l tan c'alche'n yi jun lantara'tz. Ite'n nin tzitulej yi bambil tetz. Ba'n xcon nok' yi txib yubil tu yi xk'ayk'uj nin yi cyak. Chemwok tan lino yi bak'u'n wutz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","”Ej nin ba'n tzajoy cob balaj c'ub yi ónice na bi'aj. Nin ba'n tz'oc chibi' yi coblaj k'u'j xonl Israel te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Yil tz'oc chibi' yi e' xonl Israela'tz te'j yi cob c'uba'tz tajwe'n yi tunin lxom cyen te chitiemp. Bajx tz'oc yi bi' yi bajx nak nin wi'tzbil tlen yi ch'i'p. Kakchak bi'aj te yi jujun balaj c'uba'tz tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Tan tocse'n yi e'chk bi'aja'tz te yi cob lepaj c'uba'tz ba'n xcon jun yaj yi na a'w se'le'n c'ub ta'n, chi yi e' bnol xmalk'ab. Cho'n tz'an chi jun sey. Ba'n xcon oro tan banle'n yi cob gancha'tz, nin ba'n je' jun c'ub tibaj jujun gancha'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Yi gancha'tz xconk tan stz'amle'n yi lantar wi xulchub Aarón. Ej nin yil tz'opon i' tzinwutz, xconk yi cob c'uba'tz kale atit chibi' yi coblaj k'u'j xonl Israel tan cyulse'n tx'akx tinc'u'l. ");
INSERT INTO aguBl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ban wok bin yi cob gancha'tz nin oro cu'n tzitulej wok. ");
INSERT INTO aguBl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Ej nin ncha'tz ban wok cob caren yi oro cu'n, nin lasu'n tzitulej. Nin yil bnix ba'n tzilac'baj wok cyen te yi cob gancha'tz yi tz'ocopon wi xulchup Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","”Ma yi ne'ẍ xbu'k yi tz'ocopon wutz c'u'l Aarón kale atit yi ma'cl yi xconk tan xtisya'i'n, chemij tz'an. Chin c'otij cunin tzitulej. Ba'n xcon balaj nok' yi banij te oro tu lino yi txib yubil, nin xk'ayk'uj tu' cyak. Ej nin bak'u'n wutz yi lino. ");
INSERT INTO aguBl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Pakwutzi'n tz'an tan jale'n yi cyaj xtx'u'c. Ej nin junak cob centimetr tz'an yi jalajchak xlaj. ");
INSERT INTO aguBl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ba'n tz'oc cyaj txol ne'ẍ c'ub te'j, yi na litz'un. Te yi bajx txol ba'n tz'oc ox tal ne'ẍ c'ub, yi na bi'aj rubí, crisólito nin esmeralda. ");
INSERT INTO aguBl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ma te yi ca'p txol ba'n tz'oc oxt balaj c'ub yi na bi'aj granate, safiro nin jade. ");
INSERT INTO aguBl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ma tetz yi toxi'n txol ba'n tz'oc oxt c'ub yi na bi'aj jacinto, ágata nin amatista. ");
INSERT INTO aguBl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ma te yi cyaji'n txol ba'n tz'oc yi e'chk ne'ẍ c'ub yi na bi'aj topacio, cornalina nin jaspe. Yi e'chk tz'amol tetz yi e'chk c'uba'tz tajwe'n yi oro cu'n sban. ");
INSERT INTO aguBl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Tajwe'n yi coblaj xone'n yi tal ne'ẍ c'uba'tz, na coblaj chixone'n yi e' cy'ajl Israel. Nin te yi coblaj c'uba'tz tajwe'n yil tz'oc cyen yi chibi' yi coblaj k'u'j xonl Israel, jujun bi'aj te jujun c'ub. Cho'n sban cyen chi na ban jun sey. ");
INSERT INTO aguBl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","”Ncha'tz banwok cob caren yi oro cu'n tz'an. Bak'u'n tzitulej chi jun akwil. Xconk tan stz'amle'n yi jun ne'ẍ xbu'ka'tz yi tz'ocopon wutz c'u'l Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Nin ncha'tz banwok cob argoy yi oro cu'n tz'an. Nin yi cob argoya'tz ba'n tz'oc stzi'ak yi jalaj xlaj tibe'n tzaj yi tal ne'ẍ xbu'ka'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ba'n tz'oc yi cob carena'tz te yi cob argoya'tz yi ate' te yi jalaj xlaj tibe'n tzaj. ");
INSERT INTO aguBl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ej nin ba'n c'alxij yi ju' yi cob carena'tz te yi cob gancha'tz yi oro cu'n, nin yi cho'n at wi xulchub. C'alwok cyen te yi jalaj xlaj swutz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ncha'tz banwok cobt argoy yi oro cu'n, nin ak'we' cyen te yi cob xtx'u'c tzak' cu'n tzaj yi jun xbu'ka'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Nin banwok cobt argoy nin tz'iswok cyen te yi lantar tibe'n tzaj mu'ẍ tal kale na icy'e't yi c'albil tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Nin ba'n tzic'al wok cu'n yi cob argoya'tz yi at te yi ne'ẍ xbu'k te yi cob argoy yi at te yi lantar. Nin c'alwok tan cob tal ne'ẍ c'albil yi txib yubil. C'al wok cu'n tan qui jatxol tib yi ne'ẍ xbu'k tu yi lantar. ");
INSERT INTO aguBl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ej nin cyakil tir yil tz'oc Aarón xe ama'l yi wi'nin xanil tan yol swetz, tz'ul tcy'al yi chibi' yi e' xonl Israel yi se'ij te'jak yi balaj c'uba'tz yi at swutz yi tal ne'ẍ xbu'ka'tz yi at wutz c'u'l nakajil yi talma'. Tz'ul tzun tx'akx chibi' yi e' xonl Israel tinc'u'l. ");
INSERT INTO aguBl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ma yi Urim tu Tumim, ak'wok cu'n tc'u'l yi ne'ẍ xbu'ka'tz yi at wutz c'u'l. Ak'wok cu'n bantz ta'te'n wutz c'u'l, nin cy'a'n nintz ta'n yil tz'ocopon tzinwutz tan yol. ");
INSERT INTO aguBl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","”Ej nin ncha'tz banwok yi xbu'k yi tz'ocopon jak' yi lantar. Txib cu'n tz'an yubil. ");
INSERT INTO aguBl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ej nin nicy'al yi jun xbu'ka'tz ba'n tzic'aple'n kul. Nin stzi'ak yi kul ba'n tz'oc baltz'e'n tan qui katze'n. Cho'n sbne' cyen chi na ban jun colbaj. ");
INSERT INTO aguBl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Cho'ken e'chk yubil stzi'ak yi xbu'k. Woloji'n tzitulej. Nin ba'n xcon yi xbu'k yi txib yubil tu xk'ayk'uj nin cyak. Nin ba'n tziban wok e'chk tal campanu' yi oro cu'n tan toque'n stzi'ak yi xbu'ka'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Je puntil tzituleje'j, jun woloj nok' nin jun campanu' tz'an, jalen yil bnix cyakil yi stzi'ak yi xbu'k. ");
INSERT INTO aguBl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Tajwe'n tz'oc jun xbu'ka'tz te Aarón yil tz'oc tan banle'n yi munl xe yi mantial. Ẍch'ink e'chk campanu' yil tz'oc Aarón xe yi ama'la'tz yi wi'nin xanil nin yil tz'el tzaj. Kol xom te e'chk ca'wla'tz quil tzun lquim i'-tz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","”Ncha'tz tajwe'n tan bnixe'n jun tal ne'ẍ placa yi oro cu'n, nin ba'n tz'oc cobox yol te'j chi na ban yi na bnix jun sey. Nin je yi yole'j yi tajwe'n tz'oc te'j: ‘Xansa'n cho't tan kaxcone'n tetz Jehová yi kaRyosil.’ ");
INSERT INTO aguBl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Yi jun tal ne'ẍ placa-a'tz ba'n tz'oc swutz plaj yi xbu'k yi tz'ocopon te yi wi', nin c'alwok cyen tan jun xbu'k yi txib yubil bantz cyaje'n cyen junawes te yi xbu'ka'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Yi jun tal ne'ẍ placa-a'tz tajwe'n yil cyaj cyen wutz plaj Aarón yil tz'ocopon i' tzinwutz tan toye'n yi cyoy yi e' intanum, yi e' xonl Israel, na yi tetz munl i'tz tan toye'n yi cyoy yi e' xonl Israela'tz tan jople'n cyakil quil yi juchij cya'n te cyakil e'chk takle'n yi wi'nin xtxintxal. Ej nin yil wil yi jun placa-a'tz chintzatzink te cyoy. ");
INSERT INTO aguBl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","”Banwok yi jun xbu'k yi chitpu'n nintu' yi at yubil tzi'ak tan lino. Ncha'tz yi xbu'k yi jepon te yi wi', lino cu'n tz'an. Ej nin ncha'tz banaj jun c'albil. Chemij tzitulej wok. Nin chin c'otij cu'n tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ncha'tz tz'an be'ch cyetz yi e' cy'ajl Aarón. Banwok jujun chixbu'k yi chitpu'n nintu' nin jujun chic'albil tu yi xbu'k yi jepon te chiwi'. Banaj yi je'j tan jale'n chik'ej. ");
INSERT INTO aguBl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","”Ya'stzun yi be'ch cyetz yi awutzicy scyuch' yi e' tetz cy'ajl yi xconk tan awekol e'. Ej nin ncha'tz tajwe'n yil je' aceit ẍchiwi' tan chibixbaje'n sju' chimunl, na tajwe'n tan chixansaje'n tan cyoque'n tetz pale'. ");
INSERT INTO aguBl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ncha'tz banwok ne'ẍ wex tan toque'n scye'j tan tewe'n chiwankil. ");
INSERT INTO aguBl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Nin yil cho'c wutzk'anil yi ama'l kale tzinc'ulwit wib scyuch' tan banle'n chimunl tajwe'n yi at yi ne'ẍ wexa'tz scye'j. Tajwe'n tan chixome'n Aarón scyuch' yi e' cy'ajl te yi xtxolbila'se'j tan qui jale'n quil, bantz qui chiquime'n. Yi jun leya'tz i'tz tetz Aarón scyuch' yi e' cy'ajl tu cyakil chixonl sbne' opon tunintz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","”Je xtxolbile'j yi tajwe'n tan abnol yil cẍo'c tan chixansaje'n yi e' pale'. Cy'aj tzaj jun ne'ẍ wacẍ yi mam tu cob tal ne'ẍ cne'r yi mam yi qui'c chiyab, nin qui'c mu'ẍ chiyana'sil. ");
INSERT INTO aguBl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Ncha'tz banaj cobox pam yi qui'c xtx'amil tan balaj jarin. Ncha'tz banaj cobox torta nin cobox wotz' yi na bnix tan jarin. Ej nin ba'n tz'oc mu'ẍ tal aceit swutz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Yil bnix, ba'n cu' tul jun tal ne'ẍ mi't nin tzitcy'aj wok nin swutz yi mantial. Ncha'tz tz'an jun tal ne'ẍ wacẍ yi mam tu cob tal ne'ẍ cne'r yi e' cu'n mam. ");
INSERT INTO aguBl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ej nin cy'ajwe' nin Aarón scyuch' yi e' cy'ajl stzi' yi puertil yi mantial kale na kac'ul wit kib tu intanum. Ej nin ba'n chicu' tan jichi'n. ");
INSERT INTO aguBl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ncha'tz ba'n tzacy'aj nin yi be'ch cyetz yi ja bnix. Nin wek cu'n Aarón tan yi be'choka'tz. Ak' cyen yi xbu'k yi chitpu'n nintu', tu yi junt yi at yubil stzi'ak. Ncha'tz ak' cyen yi lantar yi na bi'aj efod, tu yi ne'ẍ xbu'k yi tz'ocopon wutz c'u'l. Ej nin c'al cyen yi c'albil xe c'u'l. ");
INSERT INTO aguBl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ncha'tz ak'e'n yi xbu'k te wi' nin ak' cyen yi jun tal ne'ẍ placa swutz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Nin cy'ajwok nin aceit yi na xcon tan chixanse'n yi e' pale'. Nin ba'n tzakoje'n twi' Aarón tan xanse'n tan toque'n tetz jun pale'. ");
INSERT INTO aguBl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ncha'tz chiban yi e' cy'ajl tajwe'n yil che' awek tan yi xbu'k yi chitpu'n nintu'. ");
INSERT INTO aguBl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","C'al cyen yi c'albil xe c'u'l Aarón. Ncha'tz tzawulej yi e' cy'ajl. Ej nin ak'e'n yi xbu'k te chiwi'. Tan yi xtxolbila'se'j tzaxanse' Aarón scyuch' yi e' cy'ajl te chimunl. Yi jun munla'tz i'tz tetz sbne' opon tunintz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","”Ej nin ncha'tz cy'aj wok nin yi jun tal ne'ẍ wacẍ yi mam swutz yi mantial kalel kac'ulwit kib tan je'n cyak'ol Aarón scyuch' yi e' cy'ajl chik'ab tibaj yi wi'. ");
INSERT INTO aguBl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Biycu'n yi jun tal ne'ẍ wacẍa'tz tzinwutz stzi' yi puertil yi mantial kalel kac'ulwit kib. ");
INSERT INTO aguBl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Yil tzibiy wok cu'n yi jun tal wacẍa'tz ba'n tzimol wok yi ẍch'el nin tz'aj cyen mu'ẍ chich' tan yi ak'ab te yi e'chk tuc' yi at te yi patbil tx'ixwatz. Ma yi mas chich', ba'n tzikoj cyen xe yi patbil itx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ma cyakil yi until yi tal wacẍ chi tane'n yi at te'j yi xtx'otx', nin chi tane'n yi at te'j yi xtxicunil, cy'aj wok len tan pate'n tibaj yi patbil itx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Poro yi ẍchi'bel tu yi stz'uml tu xtxa' yi wacẍ tajwe'n yi cho'n tz'oc stz'e'se'n joylaj len yi ama'l kale atixe't. Na i'tz jun itx'ixwatz tan jale'n cuybil ipaj. ");
INSERT INTO aguBl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","”Ej nin ncha'tz ba'n tzicy'aj wok nin jun scyeri yi cob cne'ra'tz swutz yi mantial tan je'n chik'ol Aarón scyuch' yi e' cy'ajl chik'ab tibaj yi wi'. ");
INSERT INTO aguBl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ba'n tzibiy wok cu'n nin ba'n tzichit wok cyen yi ẍch'el xlajak yi patbil itx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ej nin ba'n tzipiẍ wok cu'n yi jun cne'ra'tz nin tx'aj wok yi lasu' tu yi e'chk tkan, nin junit tz'an yi wi' tu yi mas piẍa'l. ");
INSERT INTO aguBl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Nin ba'n tzapat cyakil yi ẍchi'bel yi jun cne'ra'tz wi yi patbil itx'ixwatz, tetz jun balaj oy tan c'o'caxe'n tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","”Ej nin ba'n tzitcy'aj wok nin yi junt cneru' tan je'n cyak'ol Aarón scyuch' yi e' cy'ajl chik'ab tibaj. ");
INSERT INTO aguBl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ej nin biy wok cu'n yi jun cne'ra'tz nin te yi ẍch'el ba'n tzatz'aj cyen mu'ẍ tal te yi chiẍchin Aarón nin yi e' cy'ajl. Tajwe'n cho'n tz'oc yi chich'a'tz te jalaj chiẍchin yi sbal. Ncha'tz tz'an te mamil yi wi' chik'ab. Ba'n tz'oc tz'ajij yi chich' te yi sbal. Ej nin ncha'tz tz'an mamil yi wi' quikan, yi jalaj chisbal. Ma yi sowril yi chich' chite'n tibaj nin solte'j yi patbil itx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Cy'aje'l tzaj mu'ẍ te yi chich'a'tz tib yi aceit yi na xcon tan xanse'n jun tan toque'n tetz pale' nin ban tzachit nin te Aarón tu yi be'ch tetz nin ncha'tz scye'j yi e' cy'ajl tu yi be'ch cyetz. Tan yi xtxolbile'j ẍchixansok Aarón scyuch' yi e' cy'ajl nin ncha'tz tz'an yi be'ch cyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","”Kalena's tzun tzacy'aj len yi ẍepu'il yi at te yi je' nin yi at te yi xtx'otx' nin yi at te yi lasu'. Nin ncha'tz cy'aj len yi cob xtxicunil nin cyakil yi ẍepu'il yi at te'j, tuml yi jalaj cux yi sbal, na i'tz yi jun ne'ẍ cne'r yi mam yi xconk tan chixanse'n yi e' pale'. ");
INSERT INTO aguBl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ej nin ncha'tz cy'aje'n jun pam te yi pam yi at tc'u'l yi tal ne'ẍ mi't yi at xe yi mantial tzinwutz. Ncha'tz cy'aje'n jun tort tu jun wotz' yi banijt te jarin yi at aceit swutz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ak'wok cyakil yi e'chk takle'na'tz tetz Aarón scyuch' yi e' cy'ajl nin ba'n cyak'e'n nin chichuque'n tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Yil bnix cyen yi jun xtxolbila'tz ba'n tzacy'aje'n tzaj yi e'chk takle'na'tz yi at chik'ab nin ba'n tzapat cu'n tibaj yi patbil itx'ixwatz tuml cyakil yi wankil yi bajx cne'r. Banaj yi xtxolbile'j bantz itoyil jun balaj oy swetz yi wi'nin c'o'cal, jun oy yi pati'n cu'n tz'an. ");
INSERT INTO aguBl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","”Yil cẍo'c tan xanse'n Aarón ba'n tzacy'aj cyen yi wutz c'u'l yi cneru' yi nquim tan chixanse'n Aarón nin ba'n tzachuque'n tzinwutz. Ej nin yi jun piẍ chi'baja'tz awetz sbne'. ");
INSERT INTO aguBl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Jatxle'n yi wutz c'u'l tu yi k'ab yi cneru' yi nquim tan chixanse'n Aarón na cyetz sbne', tetz chichib. ");
INSERT INTO aguBl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Cyetz Aarón sbne' scyuch' yi e' cy'ajl. Nin yi xtxolbile'j i'tz jun ley yi tajwe'n tan chibnol yi e' xonl Israel sbne' opon tunintz yil cyak' chitx'ixwatz tzinwutz. Nin yi jun oya'tz ni'cu'n chi nak chitzan tan toye'n swetz tan ẍchajle'n yi ja wi't jal tzatzin paz skaxo'l tzituch'. ");
INSERT INTO aguBl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","”Ma yi be'ch tetz Aarón, ba'n cyaj cyen tk'ab yi e' xonl i' yil quim, yil chibixe' tetz pale', nin yil tz'ak'lij yi ca'wl scyetz tan cyoque'n tetz pale'. ");
INSERT INTO aguBl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Yi jun pale'a'tz yi tz'ocopon cyen tetz xel Aarón yil quim, ej nin yil tz'oc le ama'l kalel kac'ulwit kib, tajwe'n tan xcone'n yi be'choka'tz ta'n tetz juk k'ej. ");
INSERT INTO aguBl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","”Ma yi ẍchi'bel yi cneru' yi nquim tan xansaje'n Aarón, ba'n tzitcy'aj nin tc'u'l jun ama'l yi xansa'nt, nin ba'n tzitxicwoktz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ba'n tzawak' scyetz Aarón scyuch' yi e' cy'ajl tan chibajsal yi ẍchi'bel yi cneru'a'tz na jatxijt tetz Ryos. Ncha'tz tz'an yi pam yi at tul tal ne'ẍ mi't, e' chibajsan. Ba'n baj cya'n stzi' yi puertil yi mantial kale kac'ulwit kib. ");
INSERT INTO aguBl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Tajwe'n tan baje'n cya'n, na ya'stzun yi oy yi ncyak' swetz tan jople'n yi quil nin tan chibixbaje'n tetz pale'. Poro qui'c cuj tan bajsal junt, na nk'e'tz alchok scyetz lbajsan yi e'chk takle'na'tz, na xansa'nt swutz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ma yi kol sowrin mu'ẍ tetz junt k'ej, mpe ik yi pam nka yi chi'baj tajwe'n tan cwe'n ipatil wok na xansa'nt tetz Ryos, nin qui'c cuj tan bajsal junt. ");
INSERT INTO aguBl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","”Banaj bin cyakil yi xtxolbila'tz te'j Aarón scyuch' e' cy'ajl chi nwal tzatz. Juk k'ej tzabne' tan chixanse'n nin tan tak'le'n yi ca'wl scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Tul yi jujun k'ej te yi juk k'eja'tz, tajwe'n tan awoyil jujunt tal ne'ẍ wacẍ yi mam tetz yi chitx'ixwatz tan jale'n cuybil chipaj tzinwutz. Tajwe'n tan axansal yi patbil chitx'ixwatz tan jun chitx'ixwatz yil xcon tan jale'n cuybil chipaj nin ba'n tzakoj nin aceit tibaj tan xansaje'n. ");
INSERT INTO aguBl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Juk k'ej tzaban tan pate'n yi e'chk itx'ixwatz tibaj yi patbil tetz tan jale'n cuybil ipaj. Tan yi xtxolbila'tz, tzaxanse' yi jun patbil tx'ixwatza'tz. Chin xan nin sbne', na al scyetz jun yil smac cyen yi jun patbil tx'ixwatza'tz, xanse' tib tantu' yil smac cyen. ");
INSERT INTO aguBl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","”Cyakil k'ej tajwe'n tan apatil cob tal ne'ẍ cneru' yi ja tz'ak jun yob cya'n. Eli'ch yi jun xtxolbila'se'j te'j ac'u'l. ");
INSERT INTO aguBl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ba'n tzapat jun scyeri yi cob ne'ẍ cne'ra'tz jalchan nin ba'n tzapat yi junt cwe'n k'ej. ");
INSERT INTO aguBl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Tetz tuch' yi bajx cne'r tajwe'n tzawoy cyaj liwr balaj jarin tu jun litr aceit oliw. Ej nin ba'n tzakoj nin jun litr win tibaj tetz jun oy tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ite'n nin tz'ana'tz cyakil yil tzitoy yi jun cne'r cwe'n k'ej. Tajwe'n tan awak'ol yi jarin tu yi aceit nin yi vino, na i'tz jun oy yi tajwe'n yil pat-xij cyakil cwe'n k'ej tan c'o'caxe'n tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ya'stzun yi e'chk oy yi tajwe'n yil tzitak' wok swetz nin yi sbne' opon tunintz tajwe'n tan itk'ol yi e'chk oya'tz. Ncha'tz chiban yi e' icy'ajl. Ba'n cxopon wok tan toye'n yi oya'tz stzi' yi mantial, yi mantiala'tz kalel lna'te't tan ich'iwe'n wok tan kajilone'n tzituch'. ");
INSERT INTO aguBl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Cho'n sna'tok le ama'la'tz tan kilol kib tzituch' wok yi axwok xonl Israel. Ej nin yi jun ama'la'tz chin xan nin sbne', na cho'n sna'toktz tul. ");
INSERT INTO aguBl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Tzinxansaje' bin yi mantial kalel kac'ulwit kib scyuch' yi e' xonl Israel. Ncha'tz sbne' yi patbil itx'ixwatz, tzinxansaje'. Ej nin ncha'tz tzinxansaje' Aarón scyuch' yi e' cy'ajl, tan chixcone'n tetz pale' tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Sna'tok ẍchixo'l yi e' xonl Israel nin nocopon tetz chiRyosil. ");
INSERT INTO aguBl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Tan yi xtxolbile'j tz'elepon chitxum tetz yi in yi chiRyosil nin Cyajcawil. Tz'elepon chitxum tetz yi in yi jun yi e' elsan tzaj Egipto tan wa'te'n ẍchixo'l, in chiRyosil, yi Cyacawil. ");
INSERT INTO aguBl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","”Ncha'tz banwok jun patbil insens tan yi tze' acacia. ");
INSERT INTO aguBl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Tajwe'n yi cyaj xtx'u'cnaki'n tz'an. Ej nin ca'wunak o' centimetr tz'an yi tkan nin ca'wunak o' centimetr tz'an yi wutz. Ej nin jun mutx' tu lajuj centimetr tz'an yi wutz tkan. Ej nin yi e'chk tal tuc' junit tz'an yi bambil tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ba'n tz'oc oro ita'n tan jople'n cyakil. Ncha'tz tz'an yi cyaj xlaj tu yi e'chk tal tuc', oro cu'n tz'oc te'j. Ej nin ba'n tz'oc jun yubil chi tane'n jun tal cornis tzi'ak, yi oro cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Nin tzak' yi cornisa'tz ba'n tz'oc cyaj argoy yi oro cu'n. Cucob le jalajchak. Na xconk tan toque'n jun k'a'j tan palche'n. ");
INSERT INTO aguBl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ma yi e'chk k'a'jila'tz ba'n tziban wok tan yi acacia. Ej nin ba'n tz'oc oro ita'n te'j tan jople'n cyakil yi tze'. ");
INSERT INTO aguBl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ej nin yil bnix yi jun patbil insensa'tz ba'n tzitak'wok cyen swutz yi xbu'k yi at swutz yi caẍa' kale atit yi quiwel yi katrat yi ja bixe' skaxo'l tzituch'. Cho'n tz'oc mero swutz cu'n yi jopsel yi caẍa' kalel kac'ulwit kib tzituch'. ");
INSERT INTO aguBl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ej nin cyakil jalchan yil tz'oc nuc'le'n yi jun chin cantil yi juk cu'n wi' at, ba'n spat Aarón yi insens yi at wi'nin c'o'cal tibaj yi jun patbil insensa'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ncha'tz tz'an cwe'n k'ej yil tz'oc i' tan tocse'n k'a'kl yi jun cantila'tz, ba'n spat i' insens tibaj. Yi jun xtxolbile'j tajwe'n tan ixome'n te'j sbne' opon tunintz. ");
INSERT INTO aguBl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Qui'c cuj yi nink tzipat wok junt tx'akaj insens nka jun itx'ixwatz tibaj. Nin qui'c cuj tan toque'n tk'ol alchok jilwutz oy tibaj chi tane'n jarin nka win. ");
INSERT INTO aguBl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Yi jun patbil insensa'tz xansok ntin tetz wetz, nin jun ntzi' tir tul jujun yob tz'ocopon Aarón tan tak'le'n cyen yi ẍch'el yi itx'ixwatz yi tzipate' tan jale'n cuybil ipaj tzinwutz. Tajwe'n tan itoyil yi jun oya'tz jun tir le jujun yob. Na te'jak yi tuq'uil yi jun patbil insensa'tz cho'n jepon yi ẍch'el yi itx'ixwatz yi tzitk'e' swetz tan jale'n cuybil ipaj.” ");
INSERT INTO aguBl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Itzun bantz nintzun jilont Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Yil cẍo'c tan cyajle'n cyakil yi e' xonl Israel tajwe'n yil cyak' len jun cutxuj tan chiclaxe'n tan qui saje'n jun quimichil ẍchiwutz, tan paj yi tz'ocopon cyajle'n. ");
INSERT INTO aguBl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Cyakil yi e' yi ja wi't tz'ak chitiemp, tajwe'n tan cyak'ol yi jun cutxuja'tz. Nin i'tz o' tz'el jun ons sakal, ni'cu'n tu me' sakal te yi jilwutz pwok yi banijt tan xcone'n le mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Cyakil yi e' yaj yi ja tz'ak junak yob cya'n nka mas, tajwe'n tan cyak'ol yi chicutxuj swetz. ");
INSERT INTO aguBl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Nin yil cyak' yi e' xonl Israel chicutxuj, tajwe'n yi nicy' nintu' tz'an. Quil sc'ul yi nim tcu'n stak' jun ric, nin ncha'tz quil sc'ul yi mu'ẍe'nk ltak' jun me'ba'. Ma na tajwe'n yi nicy' nintu' chibaj ben yil cyak' chicutxuj tan qui chiquime'n. ");
INSERT INTO aguBl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ma yil cyak' yi xonl Israel yi chicutxuj, yi scyak'e' tan qui chiquime'n, ba'n tzamolnin tircu'n, nin ba'n tzacy'aj nin xe yi mantial, na cho'n xconktz. Nin yi jun xtxolbila'tz xconk tan na'wse'n swetz yi ja cyak' yi e' xonl Israel yi chicutxuj tan qui chiquime'n,” stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Itzun bantz nintzunt jilon Ryos tetz Moisés itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Banwok jun chin wutzile'n plancan yi brons cu'n tz'an tircu'n tu yi xe'. Na xconk tetz tx'ajbil. Yil bnix, ba'n tzitak' wok quen txo'l yi mantial tu yi patbil itx'ixwatz. Ej nin nojswok cu'n tan a'. ");
INSERT INTO aguBl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Na xconk yi a' tan Aarón scyuch' yi e' cy'ajl tan xtx'ajle'n chik'ab tu quikan. ");
INSERT INTO aguBl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Na tajwe'n tan chitx'ajone'n Aarón scyuch' yi e' cy'ajl yil cho'c xe yi mantial kalel kac'ulwit kib. Ncha'tz yi ntaxk cho'c tan banle'n chimunl swutz yi altar tan pate'n yi cyoy tzinwutz, tajwe'n tan chitx'ajone'n tan qui chiquime'n. ");
INSERT INTO aguBl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Sbne' opon tunintz i'tz jun ley tetz Aarón scyuch' yi e' cy'ajl, yi tajwe'n tan chitx'ajol yi chik'ab tu quikan tan qui chiquime'n yil cho'c xe yi mantial,” stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Jilone'nt tzun Ryos tetz Moisés itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ba'n tzajoy e'chk balaj xtze' yi na xcon tan banle'n yi e'chk perfum. Molaj coblaj liwr mirra, nin kak liwr canel, tu kak liwr yi jun jilwutz aj yi wi'nin c'o'cal. ");
INSERT INTO aguBl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Nin ba'n tzajoy kak liwr yi balaj xtze' casia. Ba'n tzama'laj chi yi ma'lbil yi na xcon xe yi mantial. Ncha'tz joyaj ox litr tu ni'cy aceit oliw. ");
INSERT INTO aguBl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Te cyakil yi e'chk balaj perfuma'tz yi tzajoye', ba'n tzaban jun jilwutz aceit yi at xanil. Xconk tan xanse'n yi mantial. Ba'n tzaban yi aceita'tz chi na ban banle'n yi e'chk balaj perfum. Ya'stzun yi aceit yi wi'nin xanil yi xconk awa'n tan xansaje'n cyakil yi mantial tuml yi at txe'. ");
INSERT INTO aguBl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Yil bnix yi perfuma'tz, ba'n tzun cẍo'c tan kojle'n te yi mantial kalel kac'ulwit kib. Ncha'tz na taj tzakoj cyen te yi caẍa' kale atit yi quiwel kayol. ");
INSERT INTO aguBl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Ncha'tz tz'an wi yi mes kale na je't yi pam yi xansa'nt, tu yi cyakil yi ma'cl yi na xcon te'j. Ncha'tz tz'an yi jun chin wutzile'n cantil yi juk cu'n wi' tuml yi e'chk ma'cl yi na xcon te'j. Tajwe'n tan toque'n kojij yi aceita'tz te'j. Nin ncha'tz tz'an yi patbil insens. ");
INSERT INTO aguBl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Nin tajwe'n tan je'n akojol tibaj yi patbil itx'ixwatz tu yi cyakil yi e'chk ma'cl yi na xcon te'j. Ncha'tz tz'an yi jun chin wutzile'n plancan tu yi xe' tajwe'n tan je'n akojol tibaj. ");
INSERT INTO aguBl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Tan yi xtxolbila'tz tzaxanse' yi e'chk ma'cla'tz nin chin xan nin sbne', nin alchok scyetz yil smac cyen yi e'chk ma'cla'tz xansaj tib tantu' yi smac cyen. ");
INSERT INTO aguBl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","”Ncha'tz tajwe'n tan je'n akojol yi aceit twi' Aarón tan xanse'n. Ncha'tz yi e' cy'ajl tajwe'n tan abnol yi jun xtxolbila'tz scye'j bantz chixcone'n swetz tetz pale'. ");
INSERT INTO aguBl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Nin ba'n tzawal yi xtxolbile'j scyetz cyakil yi e' xonl Israel nin je tzawale'j: ‘Sbne' opon tunintz ntin xconk yi jun jilwutz aceite'j tan xanse'n yi e'chk takle'n yi xconk tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ej nin yi jun aceita'tz quil tzitak'e'n wok ẍchiwi' alchok wunak. Nin quil tziban wok junt clas aceit swutz yi je'j. Na yi aceit xansa'nt, nin na taj yil tzitek wok ẍchi'. ");
INSERT INTO aguBl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Alchok scyetz yil sban junt tx'akaj aceit yi ni'cu'n tu yi je'j nin kol xconsaj, tz'elpon laju'n tzixo'l wok,’ ” stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ej nin ncha'tz tal Ryos tetz Moisés: “Ba'n tzajoy yi e'chk jilwutz takle'ne'j: yi k'olil yi sturaqui, tu jun jilwutz ẍmecy' yi patu'n tzawulej, tu junt jilwutz k'ol yi na jal te jun wi' tze' yi na bi'aj gálbano, tu insens puro. Nicy' nintu' ma'lbil te yi jujun k'ol. ");
INSERT INTO aguBl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Tan yi e'chk c'o'csbila'tz ba'n tzaban jun balaj insens, yi chin xan nin sbne'. Na taj yi cwenta cunin tzaban tan banle'n chi na ban jun balaj bnol perfum. ");
INSERT INTO aguBl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ba'n tzajocy'e'n mu'ẍ. Chin coch' nin tzawulej. Ba'n tzun ben awuk'e' swutz yi caẍa' kale atit yi quiwel kayol. Yi jun insensa'tz chin xan nin sbne'. ");
INSERT INTO aguBl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Qui'c cuj tan ibnol wok jun tx'akaj insens tan xcone'n tzitetz chi yi jun tx'akaja'tz. Na yi jun insensa'tz i'tz tetz wetz nin chin xan nin sbne'. Ncha'tz chin xan nin sbne' tetz itetz. ");
INSERT INTO aguBl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Alchok scyetz yil sban junt tx'akajt insens yi ni'cu'n c'o'cal tan xcone'n tu' tetz, tz'elepon laju'n ẍchixo'l wok.” ");
INSERT INTO aguBl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Itzun bantz nin jilont junt tir Ryos tetz Moisés itzun taltz tetz: ");
INSERT INTO aguBl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Moisés bit tzaj, ja wi't je' intxa'ol jun xonl Judá yi na bi'aj Betzaleel, i' cy'ajl Uri. Ej nin i' jun scyeri e' mam Hur. ");
INSERT INTO aguBl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ja wi't wak' yi inespíritu tetz nin ja wi't wak' tajtza'kl tu yi xtxumu'n. Nin chin list nin i' sbne' tan banle'n wi'nin e'chk takle'n. ");
INSERT INTO aguBl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ej nin xcyek i' tan xtxumle'n nin tan banle'n e'chk balaj ak'un te oro, sakal tu brons. ");
INSERT INTO aguBl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Xcyek i' tan chinuc'le'n yi e'chk balaj c'ub tan chiyube'n mas nin tan chiwekle'n. Ncha'tz xcyek tan se'le'n balaj tze' tan yube'n. Xcyek te alchok jilwutz ak'unil. ");
INSERT INTO aguBl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ncha'tz tz'ocopon Aholiab tetz ẍch'eyum i'. Yi jun Aholiaba'tz i' cy'ajl Ahisamac yi xonl Dan. Nin cyakil yi e' yi at cyajtza'kl, ja wak' mas cyajtza'kl tan banle'n cyakil yi e'chk takle'n yi nwal tzatz, ");
INSERT INTO aguBl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","chi tane'n yi mantial kalel kac'ulwit kib tu yi caẍa' kale atit yi quiwel kayol tuml yi jopsel yi jun caẍa'a'tz. Ncha'tz ja wak' cyajtza'kl tan banle'n cyakil yi e'chk ma'cl yi na xcon xe yi mantial, ");
INSERT INTO aguBl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","chi tane'n yi mes tu cyakil yi e'chk ma'cl, nin yi jun chin wutzile'n cantil yi oro cu'n sbne' tu yi patbil insens. ");
INSERT INTO aguBl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Ncha'tz tan chibnol e' yi patbil itx'ixwatz tu yi e'chk ma'cl yi na xcon te'j, nin yi jun chin wutzile'n plancan tu yi wi'txlil. ");
INSERT INTO aguBl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Nin ja wak' cyajtza'kl tan stz'isle'n yi balaj be'chok yi xconk tetz Aarón scyuch' yi e' cy'ajl, na xconk be'ch cyetza'tz yil cho'c tan banle'n chimunl tetz pale' tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ncha'tz ja wak' cyajtza'kl tan cyoque'n tan banle'n yi aceit yi na xcon tan xanse'n jun takle'n. Nin ncha'tz yi insens yi spat-xok xe yi mantial. Tajwe'n tan chibnol yi ak'un chi nwal tzatz,” stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ncha'tz tal Ryos tetz Moisés: ");
INSERT INTO aguBl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ma jalu' Moisés, na waj yil cẍjilon scyetz cyakil yi e' xonl Israel nin ba'n tzawal yi xtxolbile'j scyetz: ‘Na waj yil chiban tane'n yi inca'wl te yi e'chk k'ej tetz ujle'n. Na ya'stzun jun techl yi copon skaxo'l tzituch' sbne' opon tunintz tan tele'n itxum tetz yi I ina'tz yi itajcawil, nin I ina'tz intxa'one'n ax wok. ");
INSERT INTO aguBl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Tajwe'n tan ixansal wok e'chk k'eja'tz. Nin tajwe'n tan itekal ẍchi'. Ej nin alchok scyetz yi quil xom te yi xtxolbile'j tajwe'n tan cwe'n biyij. Nin yi e' yil chak'uj te yi jun k'eja'tz sotzel wutz ẍchibne'. ");
INSERT INTO aguBl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ej nin ba'n xak'uj wok kak k'ej le sman. Poro le juki'n k'ej i'tz jun ke'j ujle'n yi xansa'nt tan Ryos. Ej nin al scyetz jun yil tz'ak'uj te yi jun k'eja'tz squimok. ");
INSERT INTO aguBl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Cha'stzun te tajwe'n tan chixome'n yi e' xonl Israel te yi jun ca'wle'j na tajwe'n tan chibnol tane'n yi jun k'ej ujle'n. Na i'tz jun trat yi ja bixe' skaxo'l tzituch' nin tu yi chixonl sbne' opon tunintz. ");
INSERT INTO aguBl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Sbne' opon tunintz, i'tz jun techl yi scyajk cyen skaxo'l tzituch' wok yi axwok xonl Israel. Na kak intzi' k'ej mimban tan banle'n yi tcya'j tu yi wuxtx'otx', ma le juki'n k'ej qui nnak'uj ma na ja nuje',’ ” stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Yi wi't jilone'n Ryos tetz Moisés wi'wtz Sinaí nintzun tak' i' cob lepaj c'ub kale tz'ibane't yi tetz ca'wl. Ej nin i' tz'iban tetz tan yi tetz k'ab. ");
INSERT INTO aguBl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ej itzun bantz yi quilol yi e' xonl Israel yi lolch nin na cu'ulo'k Moisés wi'wtz, nintzun e' bentz tan yol tetz Aarón. Itzun cyaltz: —Or, Aarón, banaj jun karyosil tan bajxe'n cu'n skawutz tan ẍchajle'n kabe', na qui na kil yi mbi mban Moisés, yi jun yi nke'lsan tzaj Egipto, che'ch tzun bantz tetz Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Nintzun tal Aarón scyetz: —Ba'n bin tzitcy'aj wok tzaj yi tc'u'l chiẍchin yi e' itxkel, e' icy'ajl tu e' ime'l. Ba'n tz'ul ita'n swetz. ");
INSERT INTO aguBl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Yi quibital yi e' xonl Israel, cyoque'n tzuntz tan telse'ne'l tzaj e'chk tc'u'l chiẍchin, nin e' ben tan tak'le'n tetz Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Yi wi't molxe'n yi e'chk oroja'tz tan Aarón nin octz ta'n wi k'ak', kalena's tzun cwe'n ta'n tul jun molt tan banle'n jun teblal jun ne'ẍ wacẍ. Yi bnixe'n, nintzun octz tan nicy'se'n tan skub. Yi bnixe'n yi jun teblala'tz nintzun tal i'-tz scyetz cyakil yi e' xonl Israel: —Je yi iryosile'j yi nxcye' tan itelsene'l tzaj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ncha'tz oc Aarón tan banle'n jun patbil tx'ixwatz swutz yi jun teblala'tz yi oro cu'n. Yi bnixe'n ta'n, nintzun taltz: —¡Eklen kaban jun chin wutzile'n k'ej tan tak'le'n k'ej kajcawe'j! stzun Aarón scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ma yi tule'n skil le junt eklok, chin jalchan cunin tzun chic'ase'ntz tan pate'n cu'n chitx'ixwatz. Ej nin tan toye'n chitx'ixwatz swutz yi teblal yi ne'ẍ wacẍa'tz, yi na ẍchaj yi ja wi't jal tzatzin paz tu chiryosila'tz. Yi wi't cyoyil yi e'chk chitx'ixwatz nintzun e' baj cu' c'olchoktz tan wa'a'n te'j yi chi'baj te yi chitx'ixwatz tetz tzatzin paz. Ej nin yi wi't chiwane'n nin e' baj octz tan banle'n yi cyetz cyajbil scye'jak yi e' xna'n. ");
INSERT INTO aguBl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ma Kataj Ryos nintzun tal tetz Moisés: —Ma jalu' Moisés, quilo'k, cun ilwe' yi atanum yi e' yi elnake' tzaj awucy'al Egipto, na tircu'n e' ja chijuch quil. ");
INSERT INTO aguBl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Na jalcu'n mme'l chijatxol quib te yi be' yi nwal scyetz tan chixome'n te'j. Qui nin nchixom te'j na ja cho'c tan banle'n jun teblal ne'ẍ wacẍ yi oro cu'n ncyulej. Nin yi jun teblala'tz ja oc cya'n tetz jun chiryosil na na chitzan tan c'u'laje'n nin tan toye'n nin tan pate'n chitx'ixwatz tetz. Ncha'tz na cyaltz tetz: “Yi june'j, ya'stzun yi jun yi nxcye' tan kelse'ne'l tzaj jak' chi ca'wl yi e' aj Egipto.” ");
INSERT INTO aguBl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ncha'tz tal Ryos tetz Moisés: —Na wil cyakil yi e' xonl Israel nin na el intxum tetz yi chin ẍcan nin chiwi'. ");
INSERT INTO aguBl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ma jalu' qui chin axux mas tan chicolche'n na ja je' tzinwutz cyakil yi na chitzan tan banle'n. Cha'stzun te chicopon imbiyol chicyakil. Poro yi aẍatz, quil cẍquim wa'n na tan aẍ ljalwit junt chin wutzile'n nación. ");
INSERT INTO aguBl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Toque'n tzun Moisés tan cu'swutzil tetz Ryos nintzun taltz tetz: —Wajcaw, ¿mbi tzun yi na chi'ch c'u'lu' scye'j yi e' tanumu' yi elnake' tzaj tcy'alu' jak' chica'wl yi e' aj Egipto tan yi teru' poreru'? ");
INSERT INTO aguBl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ba'n tcu'n quil tak'u' ama'l scyetz yi e' aj Egipto tan chitze'ene'n ske'j yi o' tanumu' na qui cu'n batz scyale': “Ryos nche'lsan yi e' xonl Israel skaxo'l ntin tan chiquimse'n joylaj len nin tan chisotzaje'n junawes tan qui cyaje'n cyen jun chixonl wi munt.” Cha'stzun te Ta' stzajscunu' yi jun xtxumu'nu'a'tz yi copon biyolu' cyakil yi tanumu'. ");
INSERT INTO aguBl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ulk tx'akx tc'u'lu' Ta' yi yolu' yi talnaku' tetz Abraham tu Isaac nin tetz Israel. Na je bin yi yolu' yi talu' scyetze'j: “Cyakil yi e' axonl chijepon impuc'sal nin cho'n cunin che' wulej chi tane'n yi cyajlal yi tx'uml yi at tcya'j. Ej nin swak'e' yi ama'l scyetz yi ja wi't insuk,” stzun Moisés bantz tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Nintzun je' xtx'ixpul Ryos yi xtxumu'n tan qui't chicwe'n biyol cyakil yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Kalena's tzun taje'n tzaj Moisés wi'wtz. Nin cy'a'n yi cob lepaj c'ub ta'n kale tz'ibane't yi ca'wl Ryos. Yi cob c'uba'tz tz'iba'n len cabil xlaj. ");
INSERT INTO aguBl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ryos te'n nin bnol tetz yi cob lepaj c'uba'tz. Ej nin i' te'n tz'iban tetz yi e'chk yol yi at swutz. ");
INSERT INTO aguBl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Itzun yi cwe'n mule'n chinaka'jil nintzun ben quibital Josué yi wi'nin chiẍch'ine'n jun c'oloj wunak. Nintzun ben tloltz tetz Moisés: —Moisés, bit nin. Wi'nin sich' na tzan ẍchixo'l yi e' katanum, nin yi sich'a'tz i'tz tetz oyintzi'. ");
INSERT INTO aguBl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Poro nintzun tal Moisés tetz: —Bintzi poro nk'e'tz jun bitz tetz tx'aco'n nin nk'e'tz jun bitz yi bisbil yi qui'k nchitx'acon. Poro yi e'chk bitze'j yi na wit nin i'tz apart. ");
INSERT INTO aguBl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ma yi cwe'n mule'n Moisés naka'jil kale ate't chicyakil yi e' xonl Israel nintzun ben tilol teblal yi jun ne'ẍ wacẍa'tz tu yi e'chk bixl yi na bajijtz ẍchixo'l. Nintzun saj jun chin chi'ch c'u'laltz tetz i'. Nintzun bentz tan c'oxle'n len yi cob lepaj c'ub yi cy'a'n ta'n ninin e' cu' piẍtz yi tele'n c'oxoltz. ");
INSERT INTO aguBl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ncha'tz ben i' tan ticy'le'n tzaj yi jun teblal wacẍ yi oro cu'n nintzun oc c'oxol wi k'ak' nin oc i'-tz tan ẍche'je'n jalen yi toque'n tetz puklaj. Kalena'tz bene'n ẍchitol wi a', nintzun cawunin tan baje'n yi a' cya'n. ");
INSERT INTO aguBl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Bene'n tzun tlol Moisés tetz Aarón: —¿Mbi nchiban yi e' wunake'j tzawe'j yi ja chijuch quil tan apaj? stzun Moisés tetz Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","—Wajcaw quil chi'ch c'u'lu' swe'j na na tilu' yi e' wunake'j chin chigan nin tan banle'n yi e'chk takle'n cachi'. ");
INSERT INTO aguBl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Na je bin chiyole'j swetz: “Aarón banaj jun karyosil tan bajxe'n cu'n skawutz tan ẍchajle'n kabe' na qui na kil yi mbi mbajij te'j nocx Moisés yi jun yi nke'lsane'l tzaj Egipto,” che'ch swetz. ");
INSERT INTO aguBl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nintzun wal wetz scyetz cyakil yi e' yi at oro scyuch': “Ba'n tzicy'aj tzaj swetz.” Ma yi tule'n yi oroja'tz cy'a'n, ja tzun octz wa'n wi k'ak' nin ja el tzaj yi jun teblale'j, stzun Aarón bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ma yi tilol Moisés yi nsken oc yab chiwi' cyakil yi e' wunak tan paj yi qui nin xcye' Aarón tan makle'n chiwutz, nin yi nsken cho'c tetz chitze'lbe'tz e' chicontr, ");
INSERT INTO aguBl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","nintzun cu' txiclok stzi' yi puertil yi ama'l kale ate't, nin ben tlol scyetz cyakil yi e' xonl Israela'tz: “Cyakil yi e'u' yi na cyeku' ẍchi' Ryos, chu'lkenu' swe'j,” chij. Tircu'n tzun yi e' levita e' opontz te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Nintzun tal Moisés scyetz: —Je yi yol kajcaw yi kaRyosil yi o' xonl Israel: “Cy'ajwok nin yi ispar, nin nque'n wok ẍchixo'l yi e' itanum, nin nque'n wok xe'ak chipach tan chibiyle'n cu'n yi e' ixonl scyuch' e' itamiw scyuch' yi e' iwisin.” ");
INSERT INTO aguBl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Cyoque'n tzun yi e' levita tan banle'n tane'n yi ca'wl Moisés. Nintzun e' octz tan chibiyle'n cu'n yi e' xonl Israela'tz. Te yi jun k'eja'tz e' quim lo' ox mil yaj. ");
INSERT INTO aguBl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Talol tzun Moisés scyetz yi e' levita: —Jalu' ja wi't ixansaj itib tan ixcone'n tetz kajcaw na qui nin mijuẍ itib tan chibiyle'n ixonl, yi e' itzicy scyuch' yi e' icy'ajl. Cha'stzun te stk'e' Ryos yi banl tzitibaj wok. ");
INSERT INTO aguBl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Itzun le junt eklok nintzun tal Moisés scyetz cyakil yi e' wunak yi ate'-tz: —Yi axwok itetz ja ijuch jun chin wutzile'n itil swutz Ryos. Cha'stzun te jalu' nchimben junt tir tan yol tetz Ryos tan injoyol puntil tan jale'n cuybil ipaj wok, stzun Moisés bantz scyetz yi e' wunaka'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Pakxe'n tzun junt tir Moisés wi'wtz tan yol tetz Ryos itzun taltz tetz: —Ta', max c'u'lu' tibaj yi tanumu' na jun cu'n yol ja chijuch jun chin wutzile'n quil swutzu' na ja cho'c tan banle'n jun cyetz chiryosil yi oro cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Poro max c'u'lu' Ta', nink scuyu' chipaj. Poro ko qui', ba'n stzajscunu' yi wetz imbi' tul yi teru' liwru' yi ilu' bnol tetz, stzun Moisés tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","—Ntin chibi' yi e' yi ja chijuch quil tzinwutz ya'stzun yi e' yi tzintzajse' yi chibi' tul yi weri inliwr. ");
INSERT INTO aguBl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ma aẍatz, cy'ajwe' nin cyakil yi e' atanum le ama'l yi alijt wa'n tzatz. Quil cẍbisun na yi weri inángel sbajxok tzawutz tan ẍchajle'n yi ibe'. Poro yil tz'opon yi tiemp tetz xtisya'i'n swak'e' chicaws yi e'a'tz yi ja chijuch quil, stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Saje'n tzun jun chin wutzile'n chicaws yi e' xonl Israel tan Ryos tan paj yi cyoque'n tan c'u'laje'n yi jun teblal yi bnix tan Aarón te yi oro yi baj chimolol. ");
INSERT INTO aguBl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Itzun bantz nin tal Ryos tetz Moisés: —Ma jalu' Moisés wek wok itib nin ncy'e'nt wok tul junt ama'l. Cy'ajwe' nin cyakil yi e' atanum yi nche'l tzaj awucy'al Egipto. Ba'n cxben wok le ama'l yi insuknak tetz Abraham, Isaac, nin Jacow. In suknak scyetz tan wak'ol scyetz yi chixonl. ");
INSERT INTO aguBl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mben inchakol yi wetz inángel tan bajxe'n cu'n tziwutz tan ẍchajle'n yi ibe'. Ej nin chelepon inlajul yi e' cananeo, scyuch' yi e' amorreo, scyuch' yi e' hitita scyuch' yi e' jebuseo, e' ferezeo nin yi e' heveo. ");
INSERT INTO aguBl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Quilo'k wok le yi ama'l kale atit balaj cojbil. Poro wale' nin tzitetz wok, yi wetz, quil chinxom nin tzite'j wok, na ko tzun ximbiy wok cu'n tbe' na chin ẍcan nin tunin ax wok. ");
INSERT INTO aguBl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Yi quibital yi e' xonl Israel yi xtxolbile'j wi'nin tzun chibisune'ntz ta'n, na i'tz cobox yol yi tal Ryos scyetz yi chin bisbil nin. Ej nin qui'c nin jun yi nink mmo'c yi uwaj skul mpe ik yi chixmalk'ab tan paj bis. ");
INSERT INTO aguBl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Na nsken tal Ryos tetz Moisés cyakil yi xtxolbile'j: —Moisés, alaj scyetz cyakil yi e' xonl Israel: “Yi ax wok itetz ax wok jun c'oloj wunak yi chin ẍcan nin yi iwi'. Yi nink na'tij jun rat tzixo'l wok, xquimok lo' icyakil wa'n. Ma jalu' cy'aj wok len e'chk ituwaj yi cy'a'n ita'n nin swile' yi mbi i ila'tz yi tzimbne' tzite'j.” ");
INSERT INTO aguBl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Cha'stzun te qui't nin nxcon e'chk uwaj cya'n jetz yi cyaje'n cyen yi jun ama'la'tz yi na bi'aj Horeb. ");
INSERT INTO aguBl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Itzun bantz nintzun el tcy'al Moisés yi mantial. Cho'n topone'n ta'n solte'j len kale najlche't. Nintzun oc tk'ol yi bi' tetz: Yi ama'l kale na kac'ulwit kib tu Ryos. Nin cyakil yi e' yi na cyaj yil chijilon tu Ryos, cho'n na ẍcha'k tan yol tetz i' le ama'la'tz yi at solte'j len kale ate't. ");
INSERT INTO aguBl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ma yi na ben Moisés tan yol tetz Ryos le mantiala'tz, tircu'n yi e' mas xonl Israel na che'l tzaj stzi' yi puertil yi cyetz chimantial, nintzun na chixcye' cu'ntz tan xmaye'n nin Moisés, jalen yi na oc i' xe yi mantiala'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Nin yi na ocopon Moisés tul yi mantiala'tz, nintzun na cu'ul yi jun boc'oj sbak' tibaj yi jun mantiala'tz. Cho'n tzun na cu'ul stzi' yi puertil yi mantial nintzun na jilon Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Itzun yi na quilnin yi e' mas xonl Israel yi na cu'ul yi jun boc'oj sbak'a'tz nintzun na chimeje' cu'ntz stzi' yi cyetz chimantial. Chicyakil na chimeje' cu'ntz tan c'u'laje'n Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Tan yi xtxolbile'j ja chijilon Ryos tu Moisés chi na chijilon cob wunak squibil quib. Ej nin yi ntzaj wi' chiyol nintzun na pakxij tetz Moisés ẍchixo'l yi e' mas xonl Israel. Poro yi Josué yi cy'ajl Nun, junawes at i' xe yi mantial nin qui na el tzaj i'. ");
INSERT INTO aguBl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Itzun bantz nintzun jilon Moisés tetz Ryos: —Ma jalu' Ta', na bin tzanu' tan talche'n swetz tan imbajxe'n cu'n ẍchiwutz yi e' wunake'j yi i'tz yi tanumu', poro qui na talu' swetz yi na' scyetz i' junt yi xomok swe'j tan wuch'eye'n. Ncha'tz na talu' yi na k'uke' c'u'lu' nin at banlu' swe'j. ");
INSERT INTO aguBl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Yi ko bintzi nin yi xtxolbila'tz, tale' binu' swetz yi mbi' i ila'tz yi xtxumu'nu' tan imbnol bantz k'ukewe'n inc'u'l te'ju' nin tan ta'te'n yi banlu' swe'j. Na cyakil yi e' wunake'j e' cu'n tanumu', stzun Moisés tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","—Moisés, in te'n nin chinxomok tzawe'j nin ẍujek wa'n, stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","—Bintzi Ta', yi ko quil xom ninu' swe'j mas balaj yi quil ke'l tanu' tzone'j le ama'le'j. ");
INSERT INTO aguBl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Na yi ko quil xomu' ske'j, ẍe'n tz'el katxum tetz yi ko at yi banlu' skaxo'l. Poro kol xomu' ske'j tz'elepon tzun katxum tetz yi xomiju' ske'j. Apart tzun o' sbne' ẍchiwutz yi e' mas nación yi ate' bene'n tzi'n, stzun Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","—Tzimbne' tircu'n chi mawal Moisés, na k'uklij inc'u'l tzawe'j nin na chintzatzin tzawe'j, na at imbanl tzawibaj, stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","—Ko ya'tz, ẍchaje' tibu' tzinwutz tan wilol yi k'eju', stzun Moisés tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","—Ba'n, tz'icy'pon bin yi impak'puchal tzawutz nin tzawutz cu'n yil wal imbi' tzatz. Tz'elepon ink'ajab scye'j yi e' yi na waj, nin tz'ok'ok inc'u'l scye'j yi e' yi na waj. ");
INSERT INTO aguBl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Poro qui'c cuj tan awilol weri inwutz, na qui'c rmeril yi nink til jun yaj inwutz yi qui'k quim. ");
INSERT INTO aguBl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ncha'tz tal Ryos: —Xmay tzaj Moisés, at jun ama'l tzinxlaj yi i'tz jun picy wutz c'ub, ba'n cẍo'c tul. ");
INSERT INTO aguBl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ma yil nicy' swutz yi jun picya'tz, tz'ocopon ink'ol ink'ab tan jople'n, bantz qui awilol inwutz jalen cu'n yil nicy'. ");
INSERT INTO aguBl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ma yil nicy' kalena'tz tzincy'ajlen ink'ab, nin ba'n tzun tzaxmay nin wutz incoc, na qui'c cu yi nink til jun yaj inwutz, stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Itzun bantz nintzun tal Ryos tetz Moisés: —Banaj cob lepaj c'ub chi yi cob bajx. Banaj bantz toque'n intz'ibal yi inca'wl swutz chi ban yi cob yi cu' apuch'ul. ");
INSERT INTO aguBl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Banaj list awib tan abene'n jalen tibaj yi wi'wtz Sinaí. Na klo' waj yi jalchan cunin klo' cẍjepon ek tan yol swetz. ");
INSERT INTO aguBl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Cya'l jun xom nin tzawe'j nin cya'l jun yi nink xon solte'j yi wi'wtz. Nin ncha'tz qui'c cuj yi nink wan jun wacẍ nka cne'r solte'j yi wi'wtza'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Toque'n tzun Moisés tan banle'n cob lepaj c'ub chi yi cob yi ntak' Ryos tetz. Ma le junt eklok jalchan cunin tzun bene'n Moisés, nin ben tcy'al i' yi cob lepaj c'uba'tz. Cho'n tzun bene'n i'-tz wi'wtz Sinaí chi yi ntal Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Cho'n tzun cwe'n mule'n Kataj Ryos tul jun boc'oj sbak' nintzun jilon tetz Moisés, nin tal i' yi mero tetz bi'. ");
INSERT INTO aguBl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ticy'e'n tzun i'-tz swutz Moisés, nin chin wi' nin bantz tan yol. Itzun taltz: —In Jehová, in Ajcaw, chin cham nin in, nin na el ink'ajab scye'j wunak. At wi'nin impasens, nin wi'nin banl walma'. Ilenin na wal yi bintzi. ");
INSERT INTO aguBl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Sajle'n tunintz, nin sbne' opon tunintz, ilenin at imbanl squibaj cyakil wunak, nin na incuy chipaj yi e' yi chin cachi' nin cyajtza'kl scyuch' yi e' pajol ca'wl, nin cyakil yi e' juchul il. Poro qui na je' ink'ab ẍchiwi' e' malnak. Nin na wak' chicaws yi e' malnaka'tz tuml chinitxa' nin chimamaj tu chinitxajil yi chimamaj. ");
INSERT INTO aguBl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Yi tbital Moisés yi xtxolbile'j nintzun cu' jokloktz jalen yi cwe'n pone'n yi wutz wuxtx'otx'. Nintzun oc i'tz tan c'u'laje'n Ryos, nin taltz: ");
INSERT INTO aguBl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","—Ma jalu' Ta', ilu' Wajcaw, ko bintzij nin at banlu' swibaj, xomok binu' ske'j. Cuyu' kapaj, na jun cu'n yol yi e' wunake'j chin tze'tzuj nin cyalma'. Poro cuyu' kapaj, katx'ok'be'n Ta'. Nink ko'c tanu' tetz tanumu'. ");
INSERT INTO aguBl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Nintzun tal Ryos tetz Moisés: “Ba'n bin. Bixek bin jun trat skaxo'l tzituch'. Nin tzimbne' wi'nin e'chk milawr yi chin xo'wbil nin yi qui otojt na bajij tul junt nación bene'n tzi'n wi munt, nin squile' cyakil yi e' mas wunak kale xicy'e't wok. Cyakil yi xtxolbile'j yi tzimbne' tzixo'l chin xo'wbil nin sbne'. ");
INSERT INTO aguBl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","”Ban wok bin tane'n cyakil yi xtxolbil yi swale' tzitetz jalu'. Ko ya'tz, chelepon tzun incy'al cyakil yi icontr wok yi ate' tziwutz, chi tane'n yi e' amorreo, e' cananeo scyuch' yi e' hitita, e' ferezeo, e' heveo tu e' jebuseo. ");
INSERT INTO aguBl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","”Qui'c cu tan itok'bel itib nin quil tziban wok jun itrat scyuch' yi e' wunak yi najlche' le ama'l kale cxopone't wok. Xomen wok te yi xtxolbila'tz tan qui icwe'n tul il cya'n. ");
INSERT INTO aguBl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ma na mas balaj yil cxo'c wok tan woq'ue'n yi e'chk patbil chitx'ixwatz. Nin ncha'tz ba'n cxo'c wok tan puch'le'n cu'n teblal chiryosil yi banij cya'n tu e'chk teblal chiryosil yi na bi'aj Aserá. ");
INSERT INTO aguBl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","”Quil tzitak' wok k'ej junt Ryos, ma ntin in, na na je' tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","”Quil tziban wok jun itrat scyuch' yi e' wunaka'tz yi najlche' le ama'la'tz, na yil cho'c cyetz tan c'u'laje'n chiryosil nin yil cho'c tan tak'le'n chitx'ixwatz ẍchiwutz, chocopon tan imoxe'n tan iwane'n scyuch'. ");
INSERT INTO aguBl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ncha'tz quil tzitak' wok ama'l tan cyok'bel quib yi e' icy'ajl scyuch' chime'l. Na yil cyok'bej quib, chixomok tan c'u'laje'n yi chiryosil yi banij tu' tane'n. Ẍchijuche' quil tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","”Quil tziban wok e'chk iryosil yi banij tu' quitane'n tul molt. ");
INSERT INTO aguBl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","”Ban wok tane'n yi jun balaj k'ej tetz yi pam yi qui'c xtx'amil. Ban wok chi yi walnak tzitetz. Ba'n baj pam ita'n yi qui'c xtx'amil tetz juk k'ej. Tajwe'n tan ticy'e'n yi jun k'eja'tz le xaw Abib na ya'stzun yi xaw yi ite'nle'n tzaj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","”Ej nin cyakil yi bajx icy'ajl yi na chitz'ij, e' wetz ẍchibne'. Ncha'tz yi bajx cyal yi itawun yi mam, wetz ẍchibne' tircu'n, chi tane'n wacẍ tu cne'r yi ko e' mam. ");
INSERT INTO aguBl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ma ko i'tz bajx tal jun buru' tajwe'n tan itk'ol jun ne'ẍ cne'r nka jun ne'ẍ chiw tetz xel. Poro ko qui na itaj tzitak', tajwe'n tzikin len wi'. Ncha'tz tajwe'n tan itk'ol jun oy tetz xel yi bajx icy'ajl, na qui'c cuj tan tule'n jun tzinwutz yi ko qui cy'a'n jun oy ta'n tetz wetz. ");
INSERT INTO aguBl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","”Ak'ujen wok kak k'ej ma le juki'n k'ej ujlen wok. Qui'c na ban yi ko tiemp tetz tawle'n yi cosech nka tiemp tan je'se'n yi cosech, tajwe'n yil xuje' wok. ");
INSERT INTO aguBl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","”Ban wok tane'n yi k'ej tetz sman, kale na itoywit yi bajx wutz yi cosech tetz triw. Ncha'tz banwok tane'n yi k'ej tetz wi'tzbil cosech yi na bajij le wi'tz xaw tetz yob. ");
INSERT INTO aguBl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","”Ej nin cyakil yi e' yaj tajwe'n tan cyoque'n tzinwutz ox tir le jun yob. Tajwe'n tan cyoque'n tzinwutz, na in iRyosil yi axwok xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ej nin chelepon inlajul yi e' mas nación yi ate' le ibe'. Yi ama'l kalel cxopone't, ẍch'uyok wa'n. Ej nin kol cxopon len wok tan inc'u'laje'n ox tir le jun yob, cya'l jun yi nink tz'oc tan majle'n yi i ama'l yi ja wi't insuk tzitetz. ");
INSERT INTO aguBl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","”Yil tzitoy wok jun itx'ixwatz, qui na waj yil tzitoy wok pam yi at tx'am tul. Ncha'tz quil tzicol wok yi sowril yi itx'ixwatz yi na quim tetz Pasc tetz junt eklok. Na xansa'n wa'n. ");
INSERT INTO aguBl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","”Yil tzitcy'aj wok nin yi bajx wutz icosech tzinwutz, cy'ajwok nin yi mas balaj. ”Quil tzitxic wok jun ne'ẍ chiw tul yi xtxu'tx.” ");
INSERT INTO aguBl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ej nin ncha'tz tal Ryos tetz Moisés: “Tz'ib cu'n yi e'chk yola'se'j, na ya'stzun yi xe' yi jun trat yi ja bixe' skaxo'l tzawuch' nin scyuch' yi e' xonl Israel.” ");
INSERT INTO aguBl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Cyaje'n quen tzun Moisés ca'wunak k'ej tu ca'wunak ak'bal te'j Ryos. Qui wan nin qui uc'a' te yi ca'wunak k'eja'tz. Cho'n tzun tz'ibxe'n yi e'chk yola'tz, yi lajuj ca'wl, swutz yi cob lepaj c'ub. ");
INSERT INTO aguBl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Itzun bantz yi cwe'n mule'n Moisés tu yi cob lepaj c'uba'tz kale atite't yi ca'wl Ryos, qui nin tz'icy' tetz yi ko wi'nin pak'puchaxe'n yi wutz tan paj yi jilone'n i' tu Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ma yi quilol Aarón scyuch' yi e' mas xonl Israel yi wutz Moisés yi wi'nin pak'puchaxe'n, wi'nin tzun e' xobe'ntz. Ej nin tan yi xo'w yi ate' cu'nt qui nin chinimsaj chic'u'l tan cyocompone'n xlaj Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Poro nintzun ben tlol Moisés scyetz: —Or itetz swe'j, stzun i' bantz scyetz. Yi quibital Aarón scyuch' yi e' mas ajcaw squibaj yi e' xonl Israel yi yola'tz, chisaje'n tzun te'j Moisés. Nintzun jilon i'-tz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Cyopone'n tzun nil cyakil yi e' xonl Israel kale atite't Moisés. Toque'n tzun i'-tz tan talche'n cyakil yi e'chk ca'wla'tz yi tak' Ryos tetz i' wi'wtz Sinaí. ");
INSERT INTO aguBl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Yi wi't tlol Moisés yi xtxolbila'tz scyetz cyakil yi e' xonl Israel, nintzun oc tk'ol jun xbu'k tan jople'n yi litz'unil yi at te wutz. ");
INSERT INTO aguBl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Poro yi na ben Moisés tan yol tetz Ryos, nintzun na tcy'aj len yi xbu'k yi at te wutz. Jalen yi na eltzaj kalena'tz na oct junt tir ta'n. Nin kalena'tz na oc i'-tz tan talche'n scyetz yi e' xonl Israel yi mbi tal Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Itzun na bantz yi na quil nin yi e' xonl Israel yi wi'nin na litz'un yi wutz Moisés, nintzun na tak' quen yi jun xbu'ka'tz tan jople'n yi wutz. Ej nin jopij yi wutz ta'n jalen yi na oct i' tan yol tetz Ryos. Kalena'tz na tcy'ajlen. ");
INSERT INTO aguBl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","E' cwe'n tzun molol Moisés cyakil yi e' xonl Israel, nintzun tal i' scyetz: “Je yi ca'wl yi ntal Ryos tan kabnol tane'n. ");
INSERT INTO aguBl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Ba'n kak'uj kak k'ej, poro le juki'n k'ej cya'l tz'ak'uj na i'tz jun k'ej ujle'n yi xansa'nt tan Ryos. Nin yi jun k'eja'tz i'tz tan tak'le'n k'ej Ryos yi kajcaw. Nin ko at jun yil tz'ak'uj te yi jun k'eja'tz tajwe'n yil cu' biyij. ");
INSERT INTO aguBl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Qui'c cuj tan kabnol mu'ẍ k'ak' te yi jun k'eja'tz, nin alchok ka't cu'nt tajwe'n tan kabnol tane'n yi ca'wle'j, na i'tz jun k'ej tetz ujle'n yi tajwe'n tan kabnol tane'n.” ");
INSERT INTO aguBl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ncha'tz tal Moisés scyetz cyakil yi e' xonl Israel: “Je yi ca'wl yi ntal Ryos, yi tajwe'n tan kabnol tane'n yi o' yi o' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Kamole' jun oy tetz Ryos. Poro ntin na taj yil cyak' yi e' yi tetz cu'n cyalma' yil cyak', qui na taj yi puers tu' na tetz kajcaw yi oya'tz. Nin yi e' yi tetz cu'n cyalma' na cyaj cyak' yi oya'tz ba'n tz'ul oro tu sakal nin brons cya'n. ");
INSERT INTO aguBl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Ncha'tz ba'n tz'ul yi balaj xbu'k ita'n yi txib yubil tu xk'ayk'uj nin yi cyak yubil. Ncha'tz ba'n tz'ul yi xbu'k yi banij tan balaj lino tu e'chk xbu'k yi banij tan xi'il chiw. ");
INSERT INTO aguBl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Ba'n tz'ul yi stz'u'mil cne'r yi ocnak stz'acl yi cyak, tu junt jilwutz balaj txuc tu yi balaj tze' yi acacia bi'. ");
INSERT INTO aguBl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Nin ncha'tz cy'aj wok tzaj aceit, na xconk tetz yi jun chin wutzile'n cantil. Ncha'tz cy'aj wok tzaj e'chk balaj perfum yi xconk tan xanse'n jun takle'n nka jun yaj, nin tan c'o'caxe'n yi insens. ");
INSERT INTO aguBl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Ncha'tz ba'n tzitcy'aj tzaj cobox jilwutz balaj ne'ẍ c'ub chi tane'n cornalina, na xconk tan toque'n te yi lantar nin te yi ne'ẍ xbu'k yi tz'ocopon wutz c'u'l yi pale'. ");
INSERT INTO aguBl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","”Cyakil yi e' yaj yi chin list nin e' tan banle'n e'chk balaj ak'un, ba'n cho'c tan banle'n yi e'chk ak'un yi ntal Kataj Ryos tan kabnol, ");
INSERT INTO aguBl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","chi tane'n yi mantial, yi ama'l yi xan tuml yi e'chk xbu'k yi jepon tibaj, yi e'chk argoy, tu e'chk ptzo'm, tuml e'chk k'a'j yi xconk te'j, tu yi e'chk tz'lum yi xconk tetz yi k'a'j, tu yi e'chk tkan mantial tuml e'chk xe' yi scyajk tzak'ak. ");
INSERT INTO aguBl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Ncha'tz na taj banle'n yi caẍa' tuml e'chk k'a'jil tuml yi jopsel tu yi jun xbu'k yi xconk tan jatxle'n yi ama'l yi wi'nin xanil tu yi ama'l yi xan. ");
INSERT INTO aguBl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Ncha'tz yi mes tu tetz k'a'jil nin tircu'n yi e'chk ma'cl yi xconk te'j, tu yi pam yi xansok tan tak'le'n swutz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Ncha'tz yi jun chin wutzile'n cantil yi xconk tan xtxeke'n yi xe' yi mantial tu cyakil yi e'chk ne'ẍ lampr yi at te'j tu yi e'chk mas ma'cl yi xconk te'j, tu yi aceit yi xconk te yi jun cantila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Ncha'tz yi patbil insens tu tetz k'a'jil tu yi aceit yi xconk tan xanse'n jun yaj nka jun takle'n, tu yi insens yi wi'nin c'o'cal. Ncha'tz yi xbu'k yi xconk tetz puertil yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Ncha'tz na taj banle'n yi patbil tx'ixwatz tu yi e'chk ch'ich' yi scyajk tul, yi brons cu'n sbne'. Ncha'tz yi k'a'jil tu cyakil yi e'chk ma'cl yi xconk te'j tu yi jun chin wutzile'n plancan tuml yi xe'. ");
INSERT INTO aguBl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Ncha'tz na taj banle'n yi xbu'k tu e'chk tkan nin yi e'chk xe', na xconk tetz yi pe'm yi tz'ocopon solte'je'l tzaj. Ncha'tz yi xbu'k yi xconk tetz puertil yi pe'm. ");
INSERT INTO aguBl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Ej nin ncha'tz na taj banle'n yi e'chk staqui tu e'chk cy'ajaj yi xconk tan stz'amle'n yi ju'ak yi mantial tu yi tz'ambil tetz yi pe'm. ");
INSERT INTO aguBl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Ncha'tz na taj banle'n yi be'ch tetz yi wi'tz pale' yi xconk tetz yil tz'oc tan banle'n yi munl swutz Ryos xe yi mantiala'tz, tu yi be'ch cyetz yi e' cy'ajl.” ");
INSERT INTO aguBl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Itzun bantz yi quibital yi e' xonl Israel yi xtxolbila'tz nintzun e' jatx quibtz. ");
INSERT INTO aguBl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Wi'nin tzun e'-tz e' oc tan xtxumle'n tan cyak'ol e'chk balaj oy tetz Ryos. Cyopone'n tzun niltz tan toye'n e'chk balaj oy tetz Kajcaw tan banle'n yi mantial kalel chic'ulwit quib tu Ryos. Cyakil nintzun yi tajwe'n ultz cya'n tu e'chk xbu'k yi xconk tetz yi be'ch cyetz pale'. ");
INSERT INTO aguBl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Tircu'n tzun yi e' xonl Israel e' opontz tan toye'n balaj oy. At e' yaj e' baj opontz, nin at xna'n e' opontz. Ej nin tetz cu'n cyalma' cyopone'n tan toye'n e'chk balaj xmalk'ab tu e'chk balaj uwaj yi oro cu'n nin e'chk balaj argoy. Ncha'tz at e' cy'a'n e'chk balaj caren cya'n yi oro cu'n, nin wi'nin e'chk takle'n yi oro cu'n opontz cya'n. Na nsken chijatx yi e'chk oya'tz tetz Ryos. Tircu'n tzun yi e'chk takle'na'tz yi tajwe'n, baj opontz cya'n. ");
INSERT INTO aguBl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Cyakil yi e' yi colij balaj xbu'k cya'n chi tane'n yi xbu'k yi txib yubil, tu cyak nka yi xk'ayk'uj, tu yi e' yi cy'a'n balaj xbu'k yi lino, tircu'n tzun yi e'a'tz cyule'n tan toye'n. Ncha'tz e' ban yi e' yi colij xi'il chiw cya'n tu yi e' yi colij stz'uml cne'r yi ocnak stz'acl yi cyak yubil, tuml yi e' yi colij yi junt jilwutz balaj tz'u'm cya'n. Tircu'n tzun baj opontz cya'n. ");
INSERT INTO aguBl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Cyakil yi e' yi colij sakal nka brons cya'n, ul quicy'al tetz Ryos. Ncha'tz yi e' yi at balaj tz'lum acacia scyuch', e' baj opontz tan toye'n tetz Ryos, tan bnixe'n cyakil yi tajwe'n te yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ncha'tz yi e' xna'n yi balaj chemol, ul balaj nok' cya'n. At e' ul nok' txib cya'n nin at e' ul nok' cyak cya'n, nin at e' ul balaj nok' lino cya'n. ");
INSERT INTO aguBl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ncha'tz yi e' xna'n yi at cyajtza'kl tan bak'e'n nok' nin yi saj bu'k te cyalma' tan banle'n, nintzun e' octz tan bak'e'n yi xi'il chiw. ");
INSERT INTO aguBl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ma yi e' wi'tz ajcaw cyopone'n tan toye'n e'chk balaj ne'ẍ c'ub chi tane'n cornalina tu cobox jilwutz c'ub tan xcone'n te yi lantar nin te yi xbu'k yi tz'ocopon wutz c'u'l yi wi'tz pale'. ");
INSERT INTO aguBl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ncha'tz ul quicy'al e'chk perfum tu aceit tan xcone'n tan xtxeke'n xe yi mantial, nin tan banle'n yi balaj aceit tu sturaqui yi xconk tan xanse'n jun takle'n nka jun yaj. ");
INSERT INTO aguBl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Cyakil yi e' yaj nin yi e' xna'n ẍchixo'l yi e' xonl Israel, yi tetz cu'n cyalma' yi e' oc tan xtxumle'n tan chich'eyane'n tan banle'n cyakil yi xtxolbil yi tal Ryos tetz Moisés, tircu'n e'a'tz e' ultz tan tak'le'n yi cyoy tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ncha'tz tal Moisés scyetz cyakil yi e' xonl Israel: “Quibit tzaju' e'u' intanum. Ja wi't je xtxa'ol Ryos jun scyeri e' xonl Judá nin i'tz yi yaj Bezaleel, cy'ajl ta' Uri yi mamaj kawutzile'n ta' Hur. ");
INSERT INTO aguBl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Nk'e'tz ntin ja je' xtxa'ol ma na ja tak' yi tetz espíritu tetz i', nin ja tak' balaj xtxumu'n tu tajtza'kl nin ẍc'atnakil i', bantz xcyewe'n tan banle'n alchok jilwutz balaj ak'un. ");
INSERT INTO aguBl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Xcyek tzun i' tan xtxumle'n balaj ak'un yi txe'n cu'n bnix. Ncha'tz xcye'k i' tan xtxak'le'n oro tu sakal nin brons. ");
INSERT INTO aguBl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Ncha'tz yi jun yaja'tz xcyek tan se'le'n nin nuc'le'n e'chk balaj ne'ẍ c'ub yi chin yube'n nin. Nin xcyek tan banle'n e'chk ak'un te yi balaj tze' nka alchok scyetz ak'unil yi chin tajwe'n cunin tan bnixe'n, nin tan yube'n. ");
INSERT INTO aguBl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ncha'tz xcyek i' tan chichusle'n yi e' mas, na ak'ijt yi jun ajtza'kla'tz tetz tan Ryos. Nin ncha'tz yaj Aholiab yi cy'ajl Ahisamac, jun xonl Dan. ");
INSERT INTO aguBl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","At cyajtza'kl tan banle'n e'chk balaj ak'un yi wi'nin na yub. Na chixcyek tan banle'n nin tan xtxumle'n yi e'chk balaj ak'un yi tz'aknak cu'n. Nin ncha'tz chixcyek tan ẍchemle'n e'chk xbu'k yi cyak yubil tu yi txib yubil nin xk'ayk'uj tu yi e'chk xbu'k yi lino, nka alchok clasil xbu'k yi na yub, nin chin c'otij cunin sbne'. ");
INSERT INTO aguBl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","”Cha'stzun te tajwe'n tan chibnol yi Bezaleel tu Aholiab yi ak'une'j. Ncha'tz yi e' mas yi ja ak'lij yi cyajtza'kl tan banle'n e'chk balaj ak'un, tajwe'n tan chibnol cyakil yi e'chk takle'n yi xconk xe yi mantial, kale tz'oque't na'wse'n Kataj Ryos. Nin tajwe'n tan bnixe'n chi yi ntal i',” stzun Moisés bantz scyetz yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Itzun bantz nintzun e' chakxij cyetz Bezaleel tu Aholiab scyuch' yi e' mas yaj yi ak'lijlen cyajtza'kl tan banle'n e'chk balaj ak'un. Na Ryos ak'on yi cyajtza'kl yi e' yaja'tz tan cyoque'n tan banle'n yi e'chk ak'una'tz. Nin tetz cu'n cyalma' cyak'uje'n tan banle'n, quib yi tal Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Nintzun tak' Moisés cyakil yi e'chk oy scyetz yi baj opon cyak'un chitanum, bantz chixe'te'n tan banle'n yi e'chk takle'n yi xconk xe yi mantial. Poro itzun bantz, wi'nin tzun oy baj opon cyak'un yi e' xonl Israel. Na cyakil k'ej wi'nin cyopone'n tan tak'le'n mas oy, nin tetz cu'n cyalma' cyak'ol. ");
INSERT INTO aguBl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ma yi quilol yi e' yi na chitzan tan banle'n yi ak'un yi wi'nin oy tzan topone'n, cyaje'n cyen tzun quilol yi cyak'un yi na chitzan tan banle'n. ");
INSERT INTO aguBl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Nintzun e' bentz tan yol tetz Moisés. Itzun cyaltz: “Ta', nimix cunin oy ul cyak'un wunak, nin sowrink. Na ja ul mas cyak'un swutz yi xconk te yi ak'un,” che'ch bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Tele'n tzun stziblal tan Moisés ẍchiwi' cyakil yi e' xonl Israel yi qui tajwe'n tan tule'n jun xna'n nka jun yaj tan tak'le'n mas oy tetz yi tak'un Kataj. Cha'stzun te makxe'n yi oya'tz yi baj opon cyak'un yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Makxij yi oya'tz, na nk'e'tz ntin molxij cyakil yi tajwe'n ma na nim cunin sowrink. ");
INSERT INTO aguBl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Cyoque'n tzun yi e' yaj yi at mas cyetz cyajtza'kl ẍchiwutz yi e' mas ak'unwil tan banle'n yi mantial. E' oc tzuntz tan ẍchemle'n lajuj xbu'k tan balaj lino yi bak'un wutz. Ja xcon lino cyak'un yi txib yubil tu xk'ayk'uj tu cyak, nin ja bnix cob teblal swutzak jujun xbu'ka'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Coblaj metr tu ni'cy mban yi tkan yi jujun xbu'ka'tz. Ma yi wutz i'tz cob metr ban. Junit ma'lbil ban tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","O' tzun xbu'k e' tz'is. Junit ban yi o' xbu'ka'tz. Ncha'tz ban yi o't, junit ban. ");
INSERT INTO aguBl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ncha'tz e' oc cobox xmalk'ab tzi'ak jalaj xlaj yi cob lmak xbu'ka'tz. Txib yubil yi e'chk xmalk'abila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ni'cy cient c'albil tetz oc cya'n stzi' jalajchak xlaj yi cob xbu'ka'tz. Nicy' nintu' xo'lak ban tan tok'be'n cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ncha'tz bnix ni'cy cient ganch yi oro cu'n kale tz'icy'e't yi c'albil tetz tan ẍchuple'n yi cob xbu'ka'tz. Ja tzun bnix yi bajx xbu'k tetz wi' yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ncha'tz bnix junlajt xbu'k tan Bezaleel tan xi'il chiw. Yi junlaj xbu'ka'tz xcon tan banle'n jun pa'tbil yi nje' tibaj yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Oxlaj metr tu ni'cy ban yi tkan yi jujun xbu'k nin cob metr ban yi wutz. Junit ma'lbil xcon te tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","O' tzun te yi junlaj xbu'ka'tz e' tz'is nin junit ban yi o'a's. Nin ncha'tz ban yi kakt. ");
INSERT INTO aguBl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Nin bnix ni'cy cient xmalk'abil stzi' yi jalajchak xlaj yi cob xbu'ka'tz. Nicy' nin tu' xo'lak ban tan tok'be'n cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ncha'tz bnix ni'cy cient ganchil yi brons cu'n kalel tz'icy'e't yi c'albil tetz tan ẍchuple'n cu'n yi cob xbu'ka'tz. Ya'stzun yi cob xbu'k tetz wi' yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ncha'tz bnix junt pa'tbil yi mantial tan Bezaleel yi stz'uml cne'r cu'n yi cyak stz'acl ocnak. Ej nin tetz yi mero tibaj, ja bnix junt pa'tbil te junt jilwutz tz'u'm yi na bi'aj tejón. ");
INSERT INTO aguBl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ncha'tz oc i' tan banle'n yi balaj tablón te yi tze' acacia. Chin jicyuch nin tulej i'. ");
INSERT INTO aguBl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Cyaj metr tu ni'cy ban yi tkan yi jujun tablóna'tz, nin oxc'al tu o' centimetr ban yi wutz. ");
INSERT INTO aguBl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Nin stzi'ak yi e'chk tablóna'tz bnix cob tz'ambil tetz, itzun yi na oc yi junt tablón xlaj nintzun na cyok'p cu'n quibtz. Ya'stzun cyulej tircu'n yi tablón yi nxcon tan banle'n yi cajonil yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Junak tablón bnix tetz yi jalaj xlaj yi na xmayinin cwe'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Nin ca'wunak simientil bnix cyen tzak' yi junak tablóna'tz nin sakal cu'n ban. Cob simientil cyaj xe'ak yi jujun tablón. ");
INSERT INTO aguBl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ncha'tz ban yi jalajt xlaj yi na xmayinin je'n tzi'n, bnix junakt tablón. ");
INSERT INTO aguBl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Ca'wunak simientil ban nin sakal cu'n xcon tan banle'n, na cob simientil te jujun tablón. ");
INSERT INTO aguBl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ma le jalajt yi na xmayin nin toque'n tzi'n, kak tzun tablón bnix tan xcone'n te jalaja'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Nin cobt tablón bnix tan toque'n te yi cob xtx'u'c. ");
INSERT INTO aguBl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Yi e'chk tablóna'tz junit mban te yi cob yi at nin xtx'u'c, na ja chic'alxij swi' nin xe' tan ch'ich'. Ya'stzun cyulej yi cob xtx'u'ca'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Wajxak tzun tablón xcon te yi jalajt xlaja'tz yi na xmayinin toque'n tzi'n, tuml waklaj simientil na ja xcon cob te yi jujun tablón. ");
INSERT INTO aguBl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ncha'tz bnix o' k'a'j tan Bezaleel. Ja bnix yi e'chk k'a'ja'tz tan yi tze' acacia. Nin yi o' k'a'ja'tz ya'stzun xcon tan stz'amle'n jalaj xlaj yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Nin ncha'tz bnix o't tetz yi jalajt xlaj, nin o't tetz yi jalajt xlaj wutz coc yi na xmayinin toque'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Te yi o' k'a'ja'tz yi xcon te yi jalajchak xlaj at jun yi icy' nicy'al yi e'chk tablón yi at le jalajchak xlaj. Cho'n ticy'e'n tul yi bajx tablón jalen te yi wi'tzbil tablón. ");
INSERT INTO aguBl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Nintzun oc tk'ol oro te yi e'chk tablóna'tz nin bnix cobox ganch yi oro cu'n kale icy'e't yi e'chk k'a'j yi bnix. Ncha'tz yi e'chk k'a'ja'tz oc oro te'j chi yi mban yi e'chk tablóna'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Nin ncha'tz oc Bezaleel tan banle'n yi xbu'k yi xcon tan jople'n yi ama'l yi wi'nin xanil. Oc i' tan banle'n tan nok' yi txib tu xk'ayk'uj yubil, ncha'tz xcon balaj lino yi bak'u'n wutz. Nin oc i' tan ẍchemle'n teblal e' querubim swutz. Chin c'otij cu'n tulej. ");
INSERT INTO aguBl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Yi bnixe'n yi xbu'ka'tz nintzun oc tk'ol cobox ganch, kalena'tz tzun je'n ẍch'imbaltz te yi cyaj tkan yi bnix ta'n. Yi cyaj tkana'tz bnix tan yi tze' acacia, nin oc oro te'jak. Bnix simientil tan sakal. ");
INSERT INTO aguBl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Nin tetz yi puertil yi mantiala'tz bnix jun balaj xbu'k te yi e'chk nok' yi txib yubil tu xk'ayk'uj yubil tu cyak. Ncha'tz xcon yi balaj lino ta'n yi bak'u'n wutz, nin ja oc yubel te'j yi chin yube'n nin. ");
INSERT INTO aguBl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ncha'tz bnix o' tkan ca'l tuml yi ganchil, nin o' simientil yi brons cu'n. Nintzun oc oro te'jak yi o' tkan ca'la'tz tuml yi e'chk xmalk'abil. ");
INSERT INTO aguBl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Ncha'tz oc Bezaleel tan banle'n yi caẍa' kale atit yi ca'wl Ryos. Oc i' tan banle'n te yi balaj tze' yi acacia. Jun metr tu lajuj centimetr ban yi tkan. Ma yi wutz i'tz oxc'al tu o' centimetr ban, nin oxc'al tu o' centimetr ban yi wutz tkan. ");
INSERT INTO aguBl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Nintzun oc oro te'j tircu'n. Oc solte'j nin oc tc'u'l. Nin ncha'tz bnix jun yubil stzi'ak chi tane'n cornis yi oro cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Nin ncha'tz bnix cyaj argoy yi oro cu'n. Cho'n tzun toque'n tk'ol cob le jalaj xlaj nin cobt le jalajt. ");
INSERT INTO aguBl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ncha'tz bnix cob k'a'jil yi caẍa' te yi tze' acacia. Nintzun oc oro te'jak yi e'chk k'a'ja'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Yi bnixe'n yi e'chk k'a'ja'tz nintzun icy' cya'n tul yi e'chk orgoy yi at te yi caẍa'a'tz. Na yi xac i'tz tan palche'n nin, nin tan ticy'le'n nin yi jun caẍa'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Nin ncha'tz bnix jun jopsel tan Bezaleel te yi balaj oro. Jun tzun metr tu lajuj centimetr ban yi tkan, nin oxc'al tu o' centimetr ban yi wutz yi jun jopsela'tz yi bnix. ");
INSERT INTO aguBl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Nin tibaj yi jun jopsela'tz bnix teblal cob querubim. Txak'ij tzun bantz tan ch'ich' nin oro cu'n ban. Cho'n tzun cyaje'n cyen jun le jalaj stzi' yi jopsel nin yi junt le jalajt stzi'. ");
INSERT INTO aguBl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Junit tzun ban yi jopsela'tz tu yi cob teblala'tz. Na cho'n at yi jun teblal le jalaj stzi' ma yi junt cho'n at le jalajt. ");
INSERT INTO aguBl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Nintzun na tok'bej cu'n tib yi chiwutz yi cob teblala'tz. Poro yi chiwutz cho'n ajnak cu'n tibaj yi jun jopsela'tz. Ma yi chixicy', elnak xit, nin na xcye' tan jople'n tircu'n yi jun jopsela'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ncha'tz oc Bezaleel tan banle'n yi mes tan yi balaj tze' acacia. Jun tzun mutx' tu lajuj centimetr ban yi tkan, nin ca'wunak o' centimetr ban yi wutz, nin oxc'al tu o' centimetr ban yi wutz tkan yi jun mesa'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Nintzun oc oro te'jak yi mes, nin bnix jun yubil stzi'ak, yi oro cu'n ban. ");
INSERT INTO aguBl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ncha'tz bnix junt yubil yi oro cu'n chi tane'n cornis yi lox cunin ban. Juk centimetr ban yi wutz yi jun yubila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Nin cha'tz ban Bezaleel cyaj argoy yi oro cu'n. Nintzun oc tk'ol te yi cyaj xtx'u'c kale atit yi cyaj tkan yi mes. ");
INSERT INTO aguBl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Cho'n tzun toque'n tzak' yi yubel yi at stzi'ak yi mes, nin xcon tan ticy'e'n yi e'chk k'a'j tul tan palche'n yi mes. ");
INSERT INTO aguBl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Yi e'chk k'a'ja'tz ja bnix tan yi tze' acacia. Nin yi bnixe'n nintzun oc oro te'jak. ");
INSERT INTO aguBl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ncha'tz cyakil yi e'chk ma'cl yi xcon te yi jun mesa'tz oro cu'n ban, chi tane'n yi e'chk platu' tu yi e'chk lmak cuchar, tu e'chk xaru', tu e'chk lak yi na xcon tan kojle'n yi e'chk oy, oro cu'n ban tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ncha'tz oc Bezaleel tan banle'n yi jun chin wutzile'n cantil tan oro. Txak'ij tzun tulej tan martiy. Oro cu'n ban yi xe' tu yi tkan tu yi e'chk copa yi at te'j, tu yi e'chk yubel yi at te'j. Yi e'chk yubela'tz icunin wutz almendro tane'n te yi ntaxk je' chitp. Nin junit ban yi bambil tetz cyakil yi weklil yi jun cantila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ej nin yi jun cantila'tz ox ox k'ab na el xlajak yi tkan. Juk cu'n tzun wi' na bantz. ");
INSERT INTO aguBl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Te cyakil yi kak k'ab yi na el tzaj te yi jun chin wutzile'n cantila'tz, at len ox tal ne'ẍ yubil chi tane'n yi buchil yi almendro yi ntaxk je chitpuj. ");
INSERT INTO aguBl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ma te tkan, ncha'tz at cyaj tal ne'ẍ buch chi tane'n yi buchil almendro yi ntaxk je chitp. ");
INSERT INTO aguBl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ma jak' yi ama'l kale na ele't yi e'chk k'ab yi jun cantila'tz ja bnix jun yubil chi tane'n sopil buch. Jujun tal yubil oc tzak' kale na ele't jun lmuj k'ab. ");
INSERT INTO aguBl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Cyakil yi e'chk weklila'tz, chi tane'n yi e'chk tal ne'ẍ buch, junit ban. Oro cu'n ban cyakil yi jun cantila'tz. Nin txak'ij mulij tan martiy. ");
INSERT INTO aguBl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ncha'tz oro cu'n ban yi juk tal ne'ẍ txekbil yi at twi', tu yi e'chk ma'cl chi tane'n yi elsbil mecha' tu yi e'chk ne'ẍ lak yi xcon te'j. Oro cu'n ban tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Tan banle'n yi jun wutzile'n cantila'tz tu yi cyakil yi e'chk weklil tu yi e'chk ma'cl yi xconk te'j, ja xcon ox lo' arow balaj oro tan banle'n. ");
INSERT INTO aguBl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ncha'tz bnix yi patbil insens tan Bezaleel. Ej nin xcon yi balaj tze' acacia tan i' tan banle'n. Cyaj tzun xtx'u'cnaki'n ban yi jun patbil insensa'tz. Ca'wunak o' centimetr ban yi tkan nin ca'wunak o' centimetr ban yi wutz, nin jun mutx' tu lajuj centimetr ban yi wutz tkan. Ncha'tz ja bnix yi e'chk tal ne'ẍ tuc'. Tircu'n bnix tan junit topoj tze'. ");
INSERT INTO aguBl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Yi wi't bnixe'n yi patbil insens toque'n tzun oro te'jak, chi tane'n yi tibaj, tuml yi cyaj xlaj tu yi e'chk tal ne'ẍ yubil tzi'ak yi patbil insensa'tz nin oro cu'n ban. ");
INSERT INTO aguBl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Nin tzak' yi jun yubila'tz oc cyaj argoy yi oro cu'n. Cob tzun oc quen le jalaj xlaj nin cobt le jalajt. Yi e'chk argoya'tz xcon tan palche'n yi patbil insens, na cho'n ticy'e'n yi k'a'j tul. ");
INSERT INTO aguBl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ma yi e'chk k'a'j xcon yi balaj tze' acacia tan banle'n, nin oc oro te'jak tan jople'n yi tze'. ");
INSERT INTO aguBl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Nin oc Bezaleel tan banle'n yi aceit tu yi insens yi chin xan nin yi na xcon tan xanse'n jun takle'n nka jun yaj. Cho'n cunin tzun ntulej i'-tz chi yi na quilej yi e' wi'tz bnol perfum. ");
INSERT INTO aguBl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Itzun bantz nintzun oc Bezaleel tan banle'n yi patbil tx'ixwatz te balaj tze' acacia. Yi toque'n i' tan banle'n cyaj xtx'u'cnaki'n tulej. Cob metr tu junak o' centimetr ban yi xlajak. Ma yi wutz tkan, i'tz jun metr tu junak o' centimetr ban. ");
INSERT INTO aguBl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ncha'tz bnix cyaj tuc', jun tzun le jujun xtx'u'c. Junit tzun ban yi cyaj tuc'a'tz tu cyakil yi patbil tx'ixwatz. Ej nin oc brons te yi jun patbil tx'ixwatz tan jople'n yi tze'. ");
INSERT INTO aguBl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Nin cyakil yi e'chk ma'cl yi xcon te yi jun patbil tx'ixwatza'tz brons cu'n ntulej i'. Yi e'chk ma'cla'tz chi tane'n yi cu'lbil tza'j, tu yi e'chk pale't, tu yi e'chk lmak lak, tu yi e'chk lmak pac', tu e'chk cu'lbil xtxak'ak', brons cu'n ban tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Bnix jun pariy yi brons cu'n. Cho'n cwe'n tul yi patbil tx'ixwatz, nicy'an cuntu' tan je'n k'ak' tibaj. ");
INSERT INTO aguBl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ncha'tz bnix cyaj argoy, jujun le jujun xtx'u'c yi pariy. Yi xac yi argoya'tz i'tz tan ticy'e'n yi k'a'j tul. ");
INSERT INTO aguBl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Nintzun oc Bezaleel tan banle'n yi k'a'jil. Ej nin bnix ta'n te yi tze' acacia. Ncha'tz oc brons te'j yi k'a'ja'tz yi xcon te yi patbil tx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Yi bnixe'n yi e'chk k'a'ja'tz nintzun icy' ta'n tul yi e'chk argoy yi at te yi patbil tx'ixwatz, na yi xac i'tz tan palche'n, nin tan ticy'le'n nin yi patbil tx'ixwatza'tz. Yi jun patbil tx'ixwatza'tz jul sbne' tul chi tane'n jun cajón. Poro oc brons te'j cyakil tan jople'n yi tze'. ");
INSERT INTO aguBl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Toque'n tzun Bezaleel tan molche'n yi chispej yi e' xna'n yi ate'-tz stzi' yi puertil yi pach yi mantial tu'. Yi molxe'n nintzun oc i' tan banle'n jun chin wutzile'n plancan yi brons cu'n ban. Ncha'tz ban yi c'olchbil, brons cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ncha'tz bnix yi pe'm solte'j yi mantial tan Bezaleel. Bajx bnixe'n yi jalaj xlaj yi na xmayin nin cwe'n tzi'n. Oc ca'wunak o' metr balaj xbu'k yi lino cu'n te yi jalaj xlaja'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Bnix yi junak tkan tu yi junak simientil yi jalaj pe'ma'tz. Brons cu'n ban. Ma yi e'chk ganchil tu yi e'chk tz'amol tetz i'tz sakal cu'n ban tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ncha'tz yi jalajt yi na xmayin nin je'n tzi'n, ca'wunak o' metr balaj xbu'k oc te'j. Ma yi junak tkan tuml yi junak simientil, i'tz brons cu'n ban tircu'n. Ma yi e'chk ganchil tuml yi e'chk xmalk'abil sakal cu'n ban. ");
INSERT INTO aguBl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ma te yi jalajt yi na xmayin nin toque'n tzi'n oc junak cob metr tu ni'cy balaj xbu'k te'j. Ncha'tz bnix yi lajuj tkan tu lajuj simientil tuml yi e'chk argoy tu e'chk ganch, sakal cu'n ban. ");
INSERT INTO aguBl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ncha'tz ban yi jalajt xlaj yi na xmayin nin tele'n tzi'n junak cob metr tu ni'cy balaj xbu'k oc te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ma xlaj yi puert at juk metr balaj xbu'k tu ox tkan tuml e'chk simientil. ");
INSERT INTO aguBl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ncha'tz ban le jalajt xlaj yi puert, oc juk metr balaj xbu'k te'j tu ox tkan tuml e'chk simientil. ");
INSERT INTO aguBl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Cyakil yi xbu'k yi oc te pe'mil yi mantial i'tz xbu'k lino cu'n yi bak'u'n. ");
INSERT INTO aguBl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Cyakil e'chk simientil yi tkan pe'm i'tz brons cu'n, ma yi e'chk ganch yi na xcon te yi tkan tu yi e'chk argoy i'tz sakal cu'n. Ma twi'e'n yi tkan ate'n jujun yubil yi sakal. Ej nin cyakil e'chk tkan atlen argoy te'jak. ");
INSERT INTO aguBl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ma yi xbu'k yi oc tetz yi puertil yi pe'm, chemij ban tan yi balaj nok' yi txib yubil tu xk'ayk'uj tu cyak, nin yi balaj lino yi bak'un wutz. Beluj tzun metr ban yi tkan. Ma yi wutz tkan i'tz cob metr tu junak o' centimetr, chi tane'n yi mas xbu'k. ");
INSERT INTO aguBl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","At cyaj tkan nin cyaj simientil yi brons cu'n, ma yi e'chk ganch tu yi e'chk argoy sakal cu'n ban. Ej nin yi twi' yi e'chk tkana'tz ate'n jujun yubil yi sakal cu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Cyakil yi e'chk staqui yi xcon tetz yi mantial tuml yi xcon te yi pe'm yi at solte'j, brons cu'n ban tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Tan ca'wl Moisés oc Itamar yi cy'ajl yi wi'tz pale' Aarón tan ticy'le'n nin ju' yi ak'un. Ej nin i' a'lon scyetz yi e' levita tan ticy'le'n nin yi tajlal cyakil yi ch'ich' yi xcon tan banle'n yi mantial kale atit yi caẍa' tetz yi trat. ");
INSERT INTO aguBl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Ma tetz Bezaleel bnix cyakil yi ak'un ta'n chi yi tal Ryos tetz Moisés. Yi jun Bezaleela'tz i' yi cy'ajl ta' Uri nin mamaj wutzile'n ta' Hur jun scyeri xonl Judá. ");
INSERT INTO aguBl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ncha'tz oc Aholiab tan ẍch'eye'n Bezaleel, na i' jun wi'tz txak'ol ch'ich', ncha'tz i' jun balaj chemol, na ba'n na bnix balaj xbu'k ta'n te yi nok' yi txib yubil tu xk'ayk'uj nin cyak tu yi balaj lino. Yi yaj Aholiab i' cy'ajl Ahisamac jun scyeri xonl Dan. ");
INSERT INTO aguBl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Cyakil yi oro yi xcon tan banle'n yi e'chk takle'n tetz mantial i'tz cyoy yi e' xonl Israel yi opon cya'n tetz Ryos. Nin yi tajlal yi oro yi opon i'tz junak cob lo' quintal chi yi ma'lbil yi xcon xe yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ma yi sakal yi molxij yi je'n yi sens ẍchixo'l yi xonl Israel i'tz oxc'al tu o'laj quintal tu cob arow chi yi ma'lbil yi na xcon xe yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Cyakil yi e' yi e' oc tajlal yi toque'n cyajle'n, i'tz yi e' yi nsken tz'ak junak yob cya'n le je'nak. Nin yi cyajlal, i'tz kak cient tu ox mil tu o' cient tu ni'cy chixone'n. Nin yi e'a'tz cyak' len chicutxuj, yi i'tz o' el yi jun ons sakal chi yi ma'lbil yi xcon tetz yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Molxij tzun ox c'al tu o'laj quintal sakal. Ya'stzun xcon tan banle'n yi e'ch simientil te yi tkan yi mantial tuml e'chk simientil yi tkan yi xbu'k yi at tul yi mantial. Ja tzun bnix jun cient simientil. Ej nin xcon ox ox arow sakal te jujun. ");
INSERT INTO aguBl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ncha'tz te yi sakala'tz yi baj opon cyak'un yi e' xonl Israel oc Bezaleel tan banle'n cyakil yi e'chk ganch tu argoy yi xcon te e'chk tkan yi mantial. Ej nin ja xcon tan banle'n yubil yi je' tibaj yi e'chk tkana'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ma yi brons yi opon cyak'un yi e' xonl Israel tan toye'n tetz Ryos i'tz nicy' cient tu ox quintal tu lajuj liwr. ");
INSERT INTO aguBl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ej nin te cyakil yi bronsa'tz yi molxij, bnix cyakil yi simientil yi tkan, yi puertil yi ama'l kale na chic'ulwit quib tu Ryos. Ncha'tz bnix yi patbil tx'ixwatz yi brons cu'n tuml yi pariyil, tu cyakil yi e'chk mas ma'cl yi xcon te yi patbil tx'ixwatz, brons cu'n ban. ");
INSERT INTO aguBl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Ncha'tz cyakil yi simientil yi xcon tetz yi e'chk tkan yi pe'm yi at solte'j yi mantial, tu yi simientil yi e'chk tkan yi puertil yi pe'm, tu cyakil yi e'chk staqui yi xcon tan stz'amle'n yi mantial tu yi pe'm yi at solte'j, brons cu'n ban. ");
INSERT INTO aguBl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Yi toque'n banle'n yi e'chk be'ch cyetz yi e' pale' yi e' xcon xe yi mantial, xcon yi e'chk nok' yi txib yubil tu xk'ayk'uj nin cyak. Ncha'tz bnix yi balaj be'ch tetz Aarón, chi yi tal Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Yi toque'n banle'n yi lantar xcon yi oro tu yi nok' yi txib yubil tu xk'ayk'uj nin cyak. Cyakil yi nok'a'tz i'tz balaj lino, yi bak'u'n wutz. ");
INSERT INTO aguBl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Oc xtxak'le'n yi oro tan martiy tan tele'n yi wutz. Ej nin e' baj oc tan xtx'ilche'n cu'n tan toque'n tetz nok'. Ma yi toque'n chi tane'n nok', nintzun oc ẍchemle'n xo'l yi lino yi txib yubil yi sak tu xk'ayk'uj nin cyak. ");
INSERT INTO aguBl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Nin oc cob ganchil wi xulchub tan stz'amle'n yi lantara'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ej nin cha'tz, bnix yi c'albil yi tz'ocopon tan c'alche'n yi jun lantara'tz. Cho'n nin ban yi bambil tetz chi yi lantar, na xcon yi oro tan banle'n tu yi balaj lino yi bak'u'n wutz tu yi txib yubil tu xk'ayk'uj nin cyak. Bnix yi jun lantara'tz, chi yi tal Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ma yi cob ne'ẍ c'ub yi ónice cho'n toque'n wi jun tz'ambil tetz yi oro cu'n. Ej nin swutz yi cob ne'ẍ c'uba'tz oc chibi' yi coblaj k'u'j xonl Israel. Ej nin cho'n cu'n ban chi tane'n jun sey. ");
INSERT INTO aguBl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Yi bnixe'n nintzun oc tk'ol Bezaleel tibaj yi cob ganch tetz yi jun lantara'tz. Nin yi xac yi e'chk ne'ẍ c'uba'tz i'tz tan china'wse'n yi e' xonl Israel swutz Ryos, chi yi tal Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ma yi jun tal ne'ẍ xbu'k yi oc wutz c'u'l, bnix chi yi ban yi lantar. Xcon oro te'j, nin xcon yi nok' yi txib yubil tu xk'ayk'uj, tu yi cyak. Cyakil yi nok'a'tz i'tz lino cu'n yi bak'u'n wutz. ");
INSERT INTO aguBl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Pakwutzi'n ban nin cyaj xtx'u'cnaki'n ban cyentz. Junak cob centimetr ban yi jalajchak xlaj. ");
INSERT INTO aguBl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ej nin te yi jun ne'ẍ xbu'ka'tz oc cyaj txol tal ne'ẍ balaj c'ub yi wi'nin na yub. Te yi bajx txol oc jun tal ne'ẍ balaj c'ub yi rubí nin oc jun crisólito, nin jun esmeralda. ");
INSERT INTO aguBl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ma te yi ca'p txol oc jun granate jun zafiro nin jun jade. ");
INSERT INTO aguBl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Ma te yi toxi'n txol oc jun jacinto, jun ágata nin jun amatista. ");
INSERT INTO aguBl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ma te yi cyaji'n txol oc jun topacio jun cornalina nin jun jaspe. Cyakil yi e'chk tal ne'ẍ c'uba'tz tz'amij tan oro. ");
INSERT INTO aguBl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Coblaj ne'ẍ c'ub xcon, na xomcyen tu' te yi coblaj k'u'j xonl Israel. Te yi jujun tal ne'ẍ c'ub at cyen yi jujun chibi' yi jun k'u'j xonl Israela'tz. Cho'n tane'n chibi' chi tane'n cyen te jun sey. ");
INSERT INTO aguBl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Nin tan stz'amle'n yi jun tal ne'ẍ xbu'ka'tz bnix cob caren yi oro cu'n ban nin bak'u'n ban wutz. ");
INSERT INTO aguBl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ncha'tz bnix cob stz'ambil tetz yi oro cu'n nin bnix cob argoy yi oro cu'n ban. Cho'n tzun toque'n yi cob argoya'tz yi oro cu'n stzi' yi jalaj xlaj yi at twi'e'n yi ne'ẍ xbu'ka'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Nin yi e'chk caren cho'n toque'n te yi e'chk argoya'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ma yi ju' yi cob carena'tz cho'n toque'n te yi cob stz'ambil tetz yi at wi xulchub, nin cho'n toque'n c'alij te lantar. ");
INSERT INTO aguBl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ej nin ncha'tz bnix cobt argoy. Nintzun oc wutz coc, xtx'u'c cu'n tzaj yi jun tal ne'ẍ xbu'ka'tz, poro wutz coc kale na tok'be't tib tu yi lantar. ");
INSERT INTO aguBl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ncha'tz bnix cobt argoy yi oro cu'n, cho'n tzun toque'n tz'isij te yi lantar yi at swutz, poro cho'n cyaje'n cyen naka'jil yi stz'isbil kale na icy'e't yi c'albil tetz yi lantar. ");
INSERT INTO aguBl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Cwe'n tzun c'alij yi cob argoya'tz yi at sju'ak yi tal ne'ẍ xbu'k, yi tz'ocopon wutz c'u'l yi pale', tu yi argoy yi at te yi lantar, tan jun c'albil yi txib yubil. Cho'n tzun cyaje'n cyen yi jun tal ne'ẍ xbu'k swutz yi lantar, nin tibe'n tzaj mu'ẍ tal yi c'albil yi lantara'tz. Nin junawes cyaje'n cyentz. Ja bnix cyakil chi yi tal Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ncha'tz bnix yi xbu'k yi cyaj cyen jak' yi lantar. Txib cu'n ban yubil. ");
INSERT INTO aguBl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ma yi kul, nintzun je c'aplu'n chi na ban jun colbaj. Nin yi stzi'ak yi kul, nintzun oc baltz'e'n tan qui katze'n. ");
INSERT INTO aguBl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Baj oc len yubil stzi'ak yi jun xbu'ka'tz. Oc e'chk yubil yi woloji'n ban, tan yi nok' lino yi bak'u'n wutz tu yi txib yubil tu xk'ayk'uj nin cyak. ");
INSERT INTO aguBl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ej nin ncha'tz bnix e'chk tal ne'ẍ cumpanu' yi oro cu'n ban. Nin octz cyak'un stzi'ak tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Jun tzun woloj nok' oc nin jun tal ne'ẍ cumpanu' octz stzi'ak cyakil yi xbu'ka'tz. Yi jun xbu'ka'tz xcon tetz yi pale' yi na oc tan banle'n yi munl swutz Ryos xe yi mantial. Bnix cyakil, chi yi tal Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ncha'tz bnix yi xbu'k yi chitpun nintu' tan balaj lino. Chemij ban tan jun wi'tz chemol. Ite'n nin bana'tz be'ch cyetz yi e' cy'ajl Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Nin ncha'tz ban yi xbu'k yi jepon te chiwi' tu yi yubil lino cu'n ban. Ej nin ja bnix e'chk ne'ẍ wex tan balaj lino yi tz'ocopon scye'j tan tewe'n yi chiwankil. ");
INSERT INTO aguBl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ma yi c'albil ja bnix tan nok' lino yi bak'u'n wutz tu yi txib yubil tu xk'ayk'uj nin cyak. Chemij tzun ban nin chin c'otij cunin cyulej. Bnix cyakil chi yi tal Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Nin ncha'tz bnix yi jun ne'ẍ placa yi oro cu'n yi xcon tan ẍchajle'n yi xansa'nt i' tetz pale'. Bnix chi na ban banle'n jun sey. Je yi yole'j yi oc swutz: “Xansa'ncho't tetz Jehová yi kajcawil”. ");
INSERT INTO aguBl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Yi bnixe'n, nintzun oc chic'alol tan jun c'albil yi txib yubil, kalena'tz tzun toque'n te yi xbu'k yi jepon te wi'. Bnix chi yi tal Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Bnixe'n tzun yi ca'l Ryos, yi mantial kale na chic'ulwit quib Ryos scyuch' yi e' xonl Israel. Bnix yi jun ca'la'tz, chi yi tal Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Yi bnixe'n tircu'n cyak'un yi ak'unwil, nintzun e' jatx tetz Moisés. Ncha'tz e' jatx cyakil yi e'chk ma'cl, chi tane'n yi staqui, tu yi e'chk tz'lum, tu yi e'chk k'a'j, tu yi tkan ca'l, tu cyakil e'chk xe' tkan ca'l. ");
INSERT INTO aguBl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Nin cha'tz e' jatx yi stz'uml cne'r yi ocnak yi stz'acl yi cyak yubil, yi xconk tan jople'n yi wi' mantial, tu yi balaj stz'uml txuc, nin yi xbu'k yi xcon tan jatxle'n xo'l yi ama'l yi chin xan nin. ");
INSERT INTO aguBl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Ncha'tz e' jatx yi caẍa' kale atit yi ca'wl Ryos tuml tetz k'a'jil, nin ncha'tz yi jopsel yi na xcon tan jople'n yi caẍa'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Ncha'tz e' jatx yi mes tu yi e'chk ma'cl yi xconk te'j tu yi pam yi xansa'nt tetz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Ncha'tz e' jatx yi jun wutzile'n cantil yi oro cu'n, tircu'n tuml cyakil yi e'chk ne'ẍ txekbil yi at te'j, tu cyakil yi e'chk mas ma'cl yi xconk te'j, tuml yi aceit yi xconk tetz yi txekbila'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Nin ncha'tz e' jatx yi patbil insens yi oro cu'n, tu yi aceit yi xconk tan xanse'n jun takle'n, nin yi insens yi wi'nin c'o'cal, tu yi xbu'k yi xcon tetz yi puertil yi mantial kale na chic'ulwit quib Ryos scyuch' yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Ncha'tz e' jatx yi patbil tx'ixwatz tu yi pariyil yi brons cu'n, tu cyakil yi k'a'jil nin cyakil yi e'chk ma'cl yi xcon te'j. Ncha'tz yi jun chin wutzile'n plancan tu cyakil yi xe'. ");
INSERT INTO aguBl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Ncha'tz e' jatx yi e'chk xbu'k yi xconk tetz yi pe'mil yi mantial, tu yi e'chk tkan pe'm, tu e'chk xe' tkan pe'ma'tz. Ncha'tz yi xbu'k yi xconk tetz yi puertil yi pe'm, tu e'chk akwil yi xconk tan c'alche'n, tu cyakil e'chk estaque. Cyakil yi e'chk ma'cla'tz yi xconk xe yi ca'l Ryos, e' jatx tk'ab Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Ncha'tz e' jatx yi be'ch cyetz yi e' yi chixconk xe yi mantial. Ak'lij yi balaj be'ch tetz yi pale' Aarón. Ncha'tz ak'lij yi be'ch cyetz yi e' cy'ajl Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Bnixe'n tzun cyakil yi ak'una'tz cyak'un yi e' xonl Israel, chi yi tal Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Itzun bantz yi tilol Moisés yi ba'n mban cyak'un yi e' xonl Israel, chi yi tal Ryos tetz, tk'ol tzun i' yi banl squibaj yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Itzun bantz nintzun jilont Ryos tetz Moisés. Nintzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Tul yi bajx k'ej, tetz yi bajx xaw tetz yi yob tajwe'n tan awekol yi mantial, na i'tz yi ama'l kale na kac'ulwit kib tzituch' wok yi axwok xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Yil wekxij yi mantiala'tz ba'n tzun tz'oc yi caẍa' kale atit quiwel katrat tul yi mantiala'tz, nin ba'n je jun xbu'k te yi ama'l tan jople'n. ");
INSERT INTO aguBl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Nin ba'n tz'oc yi mes awa'n xe yi mantial, nin ba'n tz'oc yi jun chin wutzile'n cantil, nin ba'n che' aban cyakil yi e'chk ne'ẍ txekbil te'j. Ncha'tz na taj nuc'le'n yi mes. ");
INSERT INTO aguBl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ncha'tz ba'n tz'oc yi patbil insens yi oro cu'n tul yi mantial. Ba'n tz'oc awa'n swutz yi xbu'k yi at swutz caẍa' kale atit quiwel katrat. Nin ba'n tz'oc yi xbu'k yi xconk tetz yi puertil yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ma yi patbil tx'ixwatz, ba'n tz'oc awa'n swutz yi puertil yi mantial kale na kac'ulwit kib tzituch' yi axwok xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ncha'tz yi jun chin wutzile'n plancan, oken txo'l yi mantial tu yi patbil tx'ixwatz nin ba'n tzanojscu'n tan a'. ");
INSERT INTO aguBl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Nin ba'n tzawek yi pe'm solte'j yi mantial. Ej nin ba'n tz'oc yi xbu'k yi xconk tetz puertil. ");
INSERT INTO aguBl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","”Ej nin yil bnix, ba'n tzun tzacy'aj tzaj mu'ẍ aceit, yi aceit yi na xcon tan xanse'n jun takle'n. Ej nin ba'n tzachit nin tibaj yi mantial, nin tibaj cyakil yi e'chk ma'cl yi at xe yi mantial. Tan yi xtxolbila'se'j tzaxanse' yi mantial tu cyakil yi e'chk ma'cl yi at xe'. Chin xan nin sbne' cyakil. ");
INSERT INTO aguBl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ncha'tz tz'an yi patbil tx'ixwatz, ba'n tzachit nin yi aceit tibaj tan xanse'n. Ncha'tz tz'an yi e'chk ma'cl yi na xcon te'j. Tan yi xtxolbila'tz tzaxanse' yi jun altara'tz, nin tz'ocopon tetz jun patbil itx'ixwatz yi chin xan nin. ");
INSERT INTO aguBl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ncha'tz tzawulej yi jun chin wutzile'n plancan tu yi xe'. Ba'n tzaxansaj. Tz'it nin yi aceit te'j tan xanse'n,” stzun Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ncha'tz tal Ryos: “Ba'n tzacy'aj nin Aarón scyuch' yi e' cy'ajl stzi' yi puertil yi ama'l kale na kac'ulwit kib tzituch' yi axwok xonl Israel. Ej nin alaj scyetz tan chicwe'n tan jichi'n. ");
INSERT INTO aguBl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Nin ba'n tzawal tetz Aarón tan toque'n yi balaj be'ch tetz te'j, tetz pale'. Nin ba'n tzatz'itnin aceit te'j tan xanse'n, na tajwe'n tan xanse'n i' tan toque'n tetz pale' tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ncha'tz che' awulej yi e' cy'ajl. Ba'n chopon awa'n swutz yi mantial nin ok yi be'ch cyetz yi chemij. ");
INSERT INTO aguBl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Nin ba'n tzatz'itnin aceit scye'j chi yi maban te'j Aarón. Banaj yi xtxolbila'tz tan cyoque'n tetz pale' tzinwutz. Na tan yi aceit yi tz'ocopon tz'itu'n scye'j chocopon tetz pale' tzinwutz, sbne' opon tunintz,” stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Toque'n tzun Moisés tan banle'n cyakil yi xtxolbil yi tal Ryos tetz i'. ");
INSERT INTO aguBl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ya'stzun ban tul yi ca'p yob yi cyenle'n tzaj yi e' xonl Israel Egipto. Nin tul yi bajx k'ej tetz yi bajx xaw tetz yi yoba'tz, ya'stzun toque'n wekle'n mantial yi xcon tetz yi ca'l Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Toque'n tzun Moisés tan banle'n, nin tan wekle'n yi mantiala'tz. Cu' yi xe' yi e'chk tkan. Ncha'tz oc yi e'chk tablón tu yi e'chk k'a'jil nin oc yi e'chk tkan yi xcon te'j. ");
INSERT INTO aguBl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Nin ncha'tz je' tk'ol Moisés yi e'chk xbu'k yi xcon tetz pa'tbil. Cho'n je'n tk'ol tibaj yi cajonil yi mantial. Je'n tzun tk'ol i' yi e'chk xbu'ka'tz tibaj yi cajonila'tz chi alijt tan Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ncha'tz oc Moisés tan tak'le'n cu'n yi cob lepaj c'ub kale atit yi ca'wl Ryos. Cho'n tzun cwe'n tk'ol tul yi caẍa' nin oc tk'ol yi e'chk k'a'j te yi caẍa'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Nin cha'tz je' tk'ol Moisés yi jopsel tibaj yi caẍa'a'tz. Nin yi wi't bnixe'n, nintzun oc ta'n xe' yi mantial nin je' ẍch'imbal yi xbu'k yi xcon tan jople'n yi caẍa' chi yi alijt tan Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ncha'tz oc yi mes ta'n. Cho'n tzun toque'n cyen tul yi mantial nka yi ama'l kale na chic'ulwit quib Ryos scyuch' yi e' xonl Israel. Cho'n tzun cyaje'n cyen xlaje'n yi puert poro tc'u'l, nin solte'je'l tzaj yi xbu'k yi nxcon tan jople'n yi ama'l yi wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ej nin tibaj yi jun mesa'tz je' tk'ol Moisés yi pam yi ncyaj cyen swutz Ryos, chi alijt ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ma yi jun chin wutzile'n cantil, cho'n toque'n ta'n xlaj cu'n yi puert. ");
INSERT INTO aguBl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Yi wi't toque'n yi jun cantila'tz, nintzun oc tk'ol Moisés k'a'kl yi e'chk tal ne'ẍ txekbil yi at te'j. Oc tk'ol k'a'kl nin cyaj cyen swutz Ryos chi alijt ta'n. ");
INSERT INTO aguBl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ma yi patbil insens yi oro cu'n, cho'n tzun toque'n tul yi ama'l kale na chic'ulwit quib Ryos scyuch' yi e' xonl Israel, nin cho'n cyaje'n cyen swutz yi xbu'k tc'u'l cyen. ");
INSERT INTO aguBl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Toque'n tzun i'-tz tan pate'n yi insens yi wi'nin c'o'cal chi alijt tan Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ncha'tz oc Moisés tan tocse'n yi e'chk xbu'k yi xcon te yi puertil yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ej nin ncha'tz oc tk'ol Moisés yi patbil tx'ixwatz swutz yi puertil yi mantial. Toque'n tzun Moisés tan pate'n yi chitx'ixwatz. Oc i' tan pate'n yi e'chk txuc tu jarin nin aceit, chi alijt tan Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ncha'tz ban yi jun chin wutzile'n plancan, cho'n tzun cyaje'n cyen txo'l yi patbil tx'ixwatz tu yi ama'l kale na chic'ul wit quib Ryos scyuch' yi e' xonl Israel. Cwe'n tzun nojsal Moisés tan a'. ");
INSERT INTO aguBl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Cho'n tzun na jetzaj a' yi na xcon tan xtx'ajle'n chik'ab tu quikan Moisés tu Aarón scyuch' yi e' cy'ajl Aarón. ");
INSERT INTO aguBl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Na ilenin na chitx'aj chik'ab tu quikan yi na cho'c tan banle'n chimunl xe yi mantial, ej nin yi na chocopon te yi patbil tx'ixwatz. Ya'stzun na cyulejtz, na ya'stzun alijt tan Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Wi'tzbil tlen oc Moisés tan tocse'n yi xbu'k solte'j yi mantial tu yi patbil tx'ixwatz. Nin oc yi xbu'k yi xcon tetz puertil yi pe'm. Ya'stzun bnixe'n yi wi'tzbil ak'un tan Moisés. ");
INSERT INTO aguBl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Yi wi't bnixe'n cyakil yi mantial, nintzun cu'ul jun boc'oj sbak' tibaj. Ej nin noj cyakil yi mantial tan yi k'ej tu pak'puchal Ryos. ");
INSERT INTO aguBl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Qui'c tzun rmeril tan toque'n Moisés tul yi ama'la'tz tan paj yi sbak' yi ncu'ul, nin tan paj yi k'ej tu pak'puchal Ryos yi at. ");
INSERT INTO aguBl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Te cyakil yi tiemp yi nchixon yi e' xonl Israel, qui nin chicy' tul junt ama'l jalen yi na je' yi jun boc'oj sbak'a'tz yi at tibaj yi mantial. Yi na je' yi sbak' kalena's tzun na cho'c tan molche'n be'ch cyetz tan quicy'e'n. ");
INSERT INTO aguBl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Poro ko qui na je' yi sbak', ncha'tz yi e' xonl Israel qui na chicy'. ");
INSERT INTO aguBl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Nin te cyakil yi chibe' yi e' xonl Israel, ja quil yi jun boc'oj sbak'a'tz tibaj yi mantial. Chajk'ej cho'n at yi sbak'a'tz tibaj yi ca'l. Ma lak'bal na oc tetz jun boc'oj k'ak' yi na a'tij tibaj yi jun mantiala'tz.");
INSERT INTO aguBl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Itzun bantz, nintzun jilon tzaj Kataj Ryos tetz Moisés, tul yi mantial tetz molbil ib tu Kataj. Itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Chamwe' cu'n cyakil yi e' atanum, yi e' xonl Israel, nin alaj yi xtxolbile'j scyetz: ”Cyakil axwok yil cxu'l wok tan toye'n itx'ixwatz tzinwutz, tajwe'n cu'n yi cho'n tz'el tzaj ita'n ẍchixo'l wacẍ nka ẍchixo'l cne'r. ");
INSERT INTO aguBl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","”Ko at jun yi na taj toy jun wacẍ tetz xtx'ixwatz, yi spat-xok tircu'n, tajwe'n cu'n yi mam, nin yi qui'c mu'ẍ tal yana'sil. Nin tajwe'n yil toy swetz tetz cu'n talma'. Nin cho'n tz'opon ita'n swutz yi puertil yi pe'mil yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Tajwe'n yil tak'e'n yi aj oyinl yi k'ab twi' yi wacẍ yi spat-xok, bantz incuyul paj yi jun aj oyinla'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ej, nin te yi nsken wi't je' tk'ol yi k'ab twi' yi wacẍa'tz, ba'n tzun tz'oc jak' kultz ta'n. ”Ma yi e' xonl Aarón yi e' cu'n pale', ba'n cho'c tan suke'n nin yi ẍch'el swetz, nin tan kojle'n nin tibaj nin xlajak yi patbil tx'ixwatz, yi cho'n at nicy'al yi wutzk'anil yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ej, ba'n tzun tz'oc yi aj oyinla'tz tan telse'n cyakil yi stz'uml yi tetz xtx'ixwatz, nin tan ẍek'le'n cu'n yi wankil yi txuca'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Inti yi e' pale', ba'n lcyak'e'n k'ak' wi yi altar, yi patbil tx'ixwatz, nin ba'n chinuque'n yi si' tibaj yi k'ak'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Kalena's tzun lje' txoli'n yi e'chk piẍa'l yi wacẍa'tz yi nsken ẍek'xij tibaj yi si'. Ncha'tz sbne' yi wi' tuml cyakil yi ẍepu'il, ba'n lje' tak'le'n wi k'ak'. ");
INSERT INTO aguBl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ma te yi ntaxk oc wi k'ak', tajwe'n yil tz'oc yi aj oyinl tan xtx'ajle'n te'j yi lasu' tu yi cux yi wacẍ. Kalena's tzun tz'oc yi pale'-tz tan pate'n tircu'n, yi jun oya'tz. Na ni'cu'n chi i'tzk jun cumir yi na oylij swetz yi wi'nin c'o'cal tzinwutz, nin yi wi'nin na chintzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","”Ma kol tz'eltzaj yi tx'ixwatz ita'n ẍchixo'l cne'r, nka ẍchixo'l chiw, tajwe'n yi i'tz jun mam yi qui'c mu'ẍ tal yana'sil. ");
INSERT INTO aguBl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ej nin cho'n tz'oc jak' kul, tzinwutz yi in Jehová yi iRyosil, te yi jalaj xlaj yi altar yi na xmayinin je'n tzi'n. Tajwe'n tzun yil cho'c yi e' pale', tan xtxitle'n nin yi ẍch'el yi jun oya'tz wi yi patbil tx'ixwatz nin ncha'tz xlajak. ");
INSERT INTO aguBl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Kalena's tzun tz'oc piẍe'n cu'ntz. Nin tajwe'n tz'oc yi pale' tan nuc'leje'n yi chi'baja'tz tibaj yi si' yi at wi altar. Nin ncha'tz sbne' i' te yi wi', tuml until yi lasu'. Tircu'n jepon nuq'uij wi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Te yi ntaxk je' wi altar, tajwe'n yil tz'oc yi aj oyinl, tan xtx'ajle'n yi lasu' tuml yi cux yi jun oya'tz. Tz'ocopon tzun jun pale'-tz tan tocse'n k'a'kl tircu'n, tetz jun oy yi wi'nin c'o'cal tzinwutz, nin yi wi'nin na chintzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","”Ma jalu', ko i'tz jun tal ch'u'l yi spat-xok tetz oy, tajwe'n cu'n yil xcon jun tal xmucuy, nka jun tal ne'ẍ slu'k. ");
INSERT INTO aguBl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Nin tajwe'n yi cho'n tz'oc yi pale' tan banle'n yi munl swutz yi patbil tx'ixwatz. Tajwe'n bajx skinlen wi' yi tal txuca'tz, kalena's tzun lyutz'nin yi ẍch'el le jalaj xlaj yi patbil tx'ixwatz. Ba'n tzun tz'octz tan pate'n yi tal txuca'tz wi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Poro te yi ntaxk oc yi pale' tan pate'n, tajwe'n yil tz'el yi xpatzqui'y ta'n, tuml cyakil yi at le c'u'l, nin cho'n mben tcy'al xlaj len yi patbil tx'ixwatz, kale na molxe't yi tza'j. ");
INSERT INTO aguBl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ncha'tz, ba'n che' stz'ame'n yi xicy' tan katzle'n yi tal txuca'tz. Poro qui'c cuj tan cwe'n cobsal junawes. Kalena's tzun tz'octz tan pate'n tibaj yi si' yi at wi yi patbil tx'ixwatz, tetz jun oy yi wi'nin c'o'cal tzinwutz, nin yi wi'nin na chintzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","”Ma jalu', yi ko at jun yil tz'oc tan toye'n alchok jilwutz ixi'n, ba'n tz'ul balaj jarin ta'n tzinwutz. Nin ba'n ben aceitil oliw ta'n txo'l yi jarina'tz, nin tajwe'n yi xomij insens xlaj yi oya'tz yil bnix. ");
INSERT INTO aguBl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Ma yi list tane'n, ba'n tzun tz'ultz ta'n ẍchiwutz yi e' xonl Aarón, yi e' pale'. Nin jun scyeri e' pale'a'tz ba'n xtxobe'n jun txob te yi jarina'tz yi yuju'n tib tu aceit. Ej nin ba'n tz'oc tan pate'n yi jun txoba'tz wi altar, tuml cyakil yi insens. Yi jun txoba'tz yi na pat-xij, i'tz k'ajbil tircu'n yi jarin tu yi aceit. ");
INSERT INTO aguBl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ma yi sowril yi jarina'tz, ya'stzun tetz Aarón yi wi'tz pale', scyuch' yi e' nitxajil, nin wi'nin xanil yi jun jarina'tz chi yi jun txob yi na patij swutz Kataj. ");
INSERT INTO aguBl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","”Ma ko at jun yi na taj toy jun pam yi cho'n na bnix tul ẍchujil pam, tajwe'n yil bnix te balaj jarin yi qui'c xtx'amil, nin tajwe'n yil co'sij tu aceit. Ncha'tz ba'n bnix chi tane'n ẍec yi qui'c xtx'amil, nin ba'n ben ch'uli'n aceit tibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","”Ma ko at jun yi na toy jun pam yi cho'n na bnix wi xc'o'n, ncha'tz tajwe'n yil bnix te balaj jarin yi qui'c xtx'amil nin yi co'si'nt tu aceit. ");
INSERT INTO aguBl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Yil bnix, ba'n tzun lcu' piẍu'ntz, nin ba'n ben ch'uli'n aceit tibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","”Ej nin ko at jun yi na toy jun jilwutz pam yi cho'n na bnix tul jun sartén, ncha'tz tajwe'n yil bnix te balaj jarin tu aceit. ");
INSERT INTO aguBl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ba'n tzun tz'ul ticy'le'n e'chk oya'tz tzinwutz yi in Jehová yi iRyosil, nin tajwe'n tan tak'le'n tetz yi pale'. Nin i' tzun tz'icy'ank nintz kale atit yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Nin tajwe'n stz'ame'n jun piẍ te yi oya'tz tetz k'ajbil tircu'n yi pam, nin tajwe'n ltak'e'n wi altar tan pat-xe'n. I'tz jun oy yi spat-xok, yi wi'nin c'o'cal tzinwutz, nin yi wi'nin na chintzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ej nin yi sowril yi jun oya'tz ba'n xcon tetz chiwa' Aarón scyuch' yi e' nitxajil. Wi'nin xanil yi pama'tz chi tane'n yi jun piẍ yi na patij tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","”Qui'c rmeril tan cwe'n xtx'amil e'chk oya'tz, na qui'c rmeril tan toye'n jun takle'n swetz yi ko at xtx'amil. Ncha'tz qui'c rmeril tan cwe'n ca'bil wunak txuc tul e'chk oya'tz yi na patij tetz jun oy yi wi'nin na chintzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ma yi e'chk oy yi na ak'lij tetz yi bajx cosech, ba'n tzun cu' xtx'amil tu ca'bil wunak txuc tul. Ma yi e'chk oya'tz tetz bajx ujul, qui'c cu tan xcone'n tetz xel yi e'chk oy yi na ak'lij swetz, yi wi'nin c'o'cal, nin yi wi'nin na chintzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","”Ncha'tz tajwe'n tan cwe'n atz'um tul tircu'n e'chk oy yi ixi'n triw cu'n yi tzitak'e' swetz, na yi atz'uma'tz, na ẍchaj yi bixba'nt cyen jun trat skaxo'l. ");
INSERT INTO aguBl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","”Ej nin kol tzitak' jun oy yi ixi'n triw cu'n tetz yi bajx wutz icosech, tajwe'n cu'n yi woyi'nt, nka yi che'ja'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Nin tajwe'n tzikoj nin aceitil oliw tu insens tibaj yi jun oya'tz, na i'tz jun oy yi ixi'n triw cu'n. ");
INSERT INTO aguBl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Ma yil bnix yi jun oya'tz yi che'ja'nt, tajwe'n ben yi pale' tan pate'n mu'ẍ tal te yi oya'tz yi yujijt tu aceitil oliw, nin tu cyakil yi insens. Yi mu'ẍ triwa'tz tu yi aceitil oliw yi spat-xok, i'tz k'ajbil tircu'n yi oy. I'tz jun oy yi stz'e'ok, yi at wi'nin c'o'cal tzinwutz, nin yi wi'nin na chintzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","”Ko at jun yil tak' jun oy tan ẍchajle'n yi ja jal tzatzin paz skaxo'l tuch', tajwe'n yil toy jun mam tor nka jun tij wacẍ. Ej nin tajwe'n yi qui'c mu'ẍ tal yana'sil. ");
INSERT INTO aguBl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Yi jun yil tz'oponsan yi jun oya'tz swutz cunin yi puertil yi pe'mil yi mantial tetz molbil ibaj, tajwe'n yi bajx ltak'e'n yi k'ab twi', ba'n tzun tz'oc jak' kultz ta'n. Kalena's tzun cho'c yi e' pale', yi e' cy'ajl Aarón, tan kojle'n nin yi ẍch'el tibaj, nin xlajak yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","”Ej nin tajwe'n yil pat-xij cyakil yi ẍepu' yi at le c'u'l yi jun oya'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Ncha'tz, tajwe'n yil patij yi cob xtxicunil tu yi ẍepu' yi at scye'jak, nin tu yi xtx'otx' tu yi ẍepu'il. Tajwe'n tz'el ticy'le'n tircu'n yi e'chk takle'na'tz tan pat-xe'n. ");
INSERT INTO aguBl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Nin i'tz yi e' pale' yi chocopon tan pate'n tibaj te'n yi tx'ixwatz yi na pat-xij tircu'n wankil, yi na tzan k'a'kl wi altar, na yi e'chk ẍepu'ila'tz, na ẍchaj yi ja jal tzatzin paz skaxo'l tu yi jun aj oyinl i'tz jun oy yi stz'e'ok, nin yi wi'nin c'o'cal tzinwutz, nin yi wi'nin na chintzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","”Ej nin alchok scyetz yil tz'ul tan toye'n jun awun yi na ẍchaj yi ja jal tzatzin paz skaxo'l, tajwe'n yi cho'n tz'eltzaj yi oya'tz txo'l yi tawun, nin chin tajwe'n cunin yi i'tz jun mam, nka jun tij yi qui'c mu'ẍ tal yana'sil. ");
INSERT INTO aguBl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ma yi ko i'tz jun ne'ẍ cneru' yil tz'opon oyi'n tzinwutz, ");
INSERT INTO aguBl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","tajwe'n yil tz'opon ticy'le'n swutz cunin puertil yi pe'mil yi mantil tetz molbil ibaj. Nin yi aj oyinla'tz tajwe'n yi bajx ltak'en yi k'ab twi' yi tawuna'tz, kalena's tzun tz'oc jak' kultz ta'n. Nin yi e' pale' chocopon tan kojle'n nin yi ẍch'el tibaj, nin xlajak yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","”Ej nin te yi jun oya'tz tetz tzatzin paz, stoye' tircu'n yi ẍepu'il tan pat-xe'n, tu yi je'. Nin tajwe'n tz'el kuxij yi je' kale na xe'te't tzaj wutz coc. Ncha'tz tajwe'n tan pate'n cyakil yi ẍepu' yi at te lasu', nin tircu'n yi at le c'u'l. ");
INSERT INTO aguBl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Ncha'tz tajwe'n yil pat-xij cabil yi xtxicun tuml yi ẍepu'il, nin tu xtx'otx' tuml yi ẍepu'il, tajwe'n tz'el ticy'le'n tan pate'n, yil tz'el ticy'le'n yi xtxicun. ");
INSERT INTO aguBl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ma yil bnix yi xtxolbila'tz ba'n tzun tz'oc yi pale'-tz tan pate'n tircu'n yi mbi cu'n na el tzaj twankil yi oya'tz wi altar, na ni'cu'n chi i'tzk cumir yi na tzan toye'n tan tak'le'n ink'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","”Ma ko i'tz jun chiw yil tz'opon jun tan toye'n tetz xtx'ixwatz tzinwutz, ");
INSERT INTO aguBl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ba'n je k'ab twi' bajx, kalena's tzun tz'oc jak' kultz ta'n swutz cunin yi puertil yi pe'mil yi mantial tetz molbil ibaj. Ma yi e' pale', e' tzuntz chocopon tan kojle'n nin yi ẍch'el tibaj nin xlajak yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","”Ej nin yil bnix yi xtxolbila'tz, kalena's tzun tz'oc yi pale' tan pate'n tircu'n yi ẍepu'il yi lasu', nin tircu'n yi ẍepu' yi at le c'u'l, tetz jun oy yi patu'n cu'n sbne' tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Ncha'tz tajwe'n tan pat-xe'n cabil yi xtxicun tu yi ẍepu'il, nin tajwe'n tan pat-xe'n yi xtx'otx' tu yi ẍepu'il, tuml yi ẍepu' yi at wutz coc. ");
INSERT INTO aguBl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Yil bnix yi xtxolbila'tz, tz'ocopon tzun yi pale'-tz tan pate'n tircu'n yi ẍepu'il tuml yi xtxicun tu yi xtx'otx' wi yi altar, na ni'cu'n chi i'tzk cumir yi na tzan toye'n tan tak'le'n ink'ej. Na tircu'n yi ẍepu'il i'tz wetz. ");
INSERT INTO aguBl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","”Ej nin yi xtxolbila'tz i'tz jun ca'wl tetz itetz, nin scyetz imamaj. Qui'c na ban alchok ama'lil kalel cxa't cu'nt, tajwe'n tan ibnol tane'n. Qui'c cuj tan ibajsal ẍepu' nka chich',” stzun Ryos bantz tetz Moisés, tan tlol scyetz yi e' tanum, yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Itzun bantz, nintzun jilon tzaj junt tir Kataj Ryos tetz Moisés, itzun saj tloltz: ");
INSERT INTO aguBl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Alaj yi xtxolbile'j scyetz yi e' atanum, yi e' xonl Israel: Ko na xubsij jun, nin na juch til tampaj yi qui na ban tane'n jun scyeri inca'wl, tajwe'n tan bnol yi xtxolbile'j: ");
INSERT INTO aguBl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","”Ko i'tz jun wi'tz pale' yi na xubsij, na jal quil cyakil wunak tan paj, nin tajwe'n yil toy jun tal ne'ẍ tor tetz xtx'ixwatz yi qui'c mu'ẍ tal yana'sil, tan jale'n cuybil paj tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Tajwe'n yil tcy'aj tzaj yi jun tal ne'ẍ wacẍa'tz stzi' cunin puertil yi pe'mil yi mantial tetz molbil ibaj, nin ba'n tak'e'n k'ab twi'. Kalena's tzun tz'oc jak' kultz ta'n, tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ej, nin ite'n nin yi wi'tz pale'a'tz, tz'icy'ank nin mu'ẍ ẍch'el yi tal ne'ẍ tora'tz, le yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Nin yil tz'opon tc'u'l yi mantial tetz molbil ibaj, copon mu'ul yi wi k'ab tul yi chich' yi cy'a'n ta'n, nin tzinwutz cu'n, tajwe'n yil stz'it nin juk tir te yi xbu'k yi ch'inlij swutz yi ama'l yi chin xan nin. ");
INSERT INTO aguBl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ncha'tz tz'ocopon suk'ul chich' te e'chk tuc' yi altar kale na pat-xe't yi insens yi wi'nin c'o'cal, yi cho'n at le mantial tetz molbil ibaj. Nin yi sowril yi ẍch'el yi tal ne'ẍ tora'tz, cho'n mben kojij stkan cu'n yi patbil tx'ixwatz yi cho'n at wutzk'anil yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Yil bajij tircu'n yi xtxolbila'tz, ba'n tz'oc yi wi'tz pale' tan telse'n len tircu'n yi ẍepu'il yi at te lasu', nin tircu'n yi at le c'u'l, ");
INSERT INTO aguBl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ba'n tcy'aj len tircu'n, tuml cabil yi xtxicun tu yi ẍepu' yi at te'jak, nin yi xtx'otx' tu yi ẍepu'il. ");
INSERT INTO aguBl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Tircu'n tz'elpon ticy'le'n, chi na u'lij jun mam tor yi na oylij tan ẍchajle'n yi at tzatzin paz. Tircu'n yi na el ticy'le'n te'j, cho'n jepon tk'ol yi pale' wi altar tan toque'n i' tan pate'n. ");
INSERT INTO aguBl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ma yi stz'umlil yi tal ne'ẍ tora'tz, tu yi wi', nin yi tkan tu yi lasu', nin yi xtxa', ");
INSERT INTO aguBl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","nin tircu'n yi wankil, ba'n ben ticy'le'n joylaj len yi ama'l kale najlche't yi e' atanum, tul jun ama'l yi xansa'nt. Cho'n tzun tz'ocopon pate'ntz kale na bene't kojij yi tza'j. Nuc'xok yi si' tibaj yi tza'j, nin tz'ocopon k'ak' tan pate'n cu'n yi xtx'ixwatz yi wi'tz pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","”Ma jalu', ko tircu'n e' atanum na chijuch quil, tampaj yi ja el te chic'u'l yi qui'c cuj tan chibnol jun xtxolbil yi qui'c cuj tan banle'n, nin qui'c na ban ko cya'l nin jun na el xtxum tetz yi ja chipaj inca'wl, ilenin at quil te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Yi na lajluchax yi chipaltila'tz ẍchiwutz, tircu'n tzun e'-tz tajwe'n tan chibene'n tan toye'n jun tal ne'ẍ tor tetz chitx'ixwatz, tan jale'n cuybil chipaj. Ej, nin tajwe'n tan topone'n cy'a'n swutz yi puertil yi pe'mil yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Nin tircu'n yi e' wi' banl wi' tetz tnum, ba'n je' chik'ab twi' yi tal ne'ẍ tora'tz, tzinwutz, nin ta'ste'nin tz'oque't jak' kultz cya'n. ");
INSERT INTO aguBl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ma yi wi'tz pale', ba'n tcy'aj nin mu'ẍ ẍch'el yi chitx'ixwatza'tz tul yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Nin yil tz'ocopon i' tul, copon mu'ul yi wi k'ab tul yi chich' yi cy'a'n ta'n, nin ba'n stz'it nin juk tir te yi xbu'k yi at swutz yi ama'l yi wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Nin ite'n nin yi chich'a'tz tajwe'n yil suk' quen te yi e'chk tuc' yi altar tetz patbil insens yi at tzinwutz, tc'u'l yi mantial tetz molbil ibaj. Ma yi sowril yi chich', cho'n mben kojij xe' cu'n yi patbil tx'ixwatz yi at wutzk'anil yi mantial. ");
INSERT INTO aguBl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ncha'tz ba'n tcy'ajlen tircu'n yi ẍepu'il yi tal ne'ẍ tora'tz, nin ba'n tz'oc tan pate'n wi yi patbil tx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ni'cu'n yi xtxolbile'j chi na ban yi wi'tz pale' tan jale'n cuybil yi tetz paj. Ej nin ite'n nin xtxolbila'tz na ban tan pate'n chitx'ixwatz tircu'n wunak, tan jale'n cuybil chipaj tzinwutz. Ej nin tan yi xtxolbila'tz na cuylij chipaj. ");
INSERT INTO aguBl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Kalena's tzun tcy'aj nin tircu'n yi wankil yi tal ne'ẍ mam tora'tz, joylaje'l tzaj yi ama'l kale najlche't, nin tz'ocopon i' tan pate'n chi na tulej yi jun tal ne'ẍ tor tan jale'n cuybil paj. ");
INSERT INTO aguBl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","”Yi ko i'tz jun ajcaw tetz tnum yi na tzan tan banle'n e'chk takle'n yi na el k'ej inca'wl ta'n, tampaj yi ja el te c'u'l yi qui'c cuj tan banle'n, na juch til tampaj. Nin ptzun nk'era'tzk nin tajbil tan banle'n e'chk takle'na'tz, ilenin na juch til tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ma yi na lajluchax swutz i' yi na tzan tan juchle'n til, tajwe'n tan tule'n tcy'al jun mam chiw tan toye'n tzinwutz, yi qui'c mu'ẍ tal yana'sil, tan jale'n cuybil paj. ");
INSERT INTO aguBl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Nin yil tz'ul ta'n tzinwutz, ba'n tak'e'n k'ab twi', nin ba'n tz'oc jak' kul ta'n, le yi ama'l kale na chibiyxe't yi e'chk awun yi na pat-xij tircu'n chiwankil tetz tx'ixwatz, na yi jun mam chiwa'tz i'tz jun tx'ixwatz tan jale'n cuybil paj jun wi'tz ajcaw. ");
INSERT INTO aguBl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Yi pale' ba'n tcy'aj nin mu'ẍ te ẍch'el yi jun chiwa'tz, nin tan yi wi k'ab tz'ocopon suk'ul chich' te e'chk tuc' yi altar kale na pat-xe't e'chk tx'ixwatz. Nin yi sowril yi chich', ba'n skoj nin xe' cu'n yi altara'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ncha'tz tz'ocopon tan stz'e'se'n tircu'n yi ẍepu'il wi altar, chi na ban stz'e'se'n yi ẍepu'il jun oy tetz tzatzin paz. Nin tan yi xtxolbila'tz, na jal cuybil paj yi wi'tz ajcaw tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","”Yi ko i'tz jun sloj wunak yil juch til, tampaj yi na tzan tan banle'n e'chk takle'n yi qui'c cuj tan banle'n nin ptzun buch tlenk tz'el xtxum tetz yi ploj mban, na juch til. ");
INSERT INTO aguBl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Nin yil lajluchax swutz, yi ploj mban, tajwe'n tan tule'n tcy'al jun tij chiw tetz xtx'ixwatz yi qui'c mu'ẍ tal yana'sil, tan jale'n cuybil paj. ");
INSERT INTO aguBl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Nin jepon tk'ol yi k'ab twi' yi jun oya'tz, yi xtx'ixwatz, nin tz'ocopon jak' kul ta'n kale na oque't jak' chikul yi e' tx'ixwatz yi na pat-xij tircu'n chiwankil. ");
INSERT INTO aguBl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Yi pale' mben tcy'al mu'ẍ te ẍch'el yi jun tij chiwa'tz, nin tan wi k'ab tz'ocopon suk'ul te yi e'chk tuq'uil yi patbil tx'ixwatz, yi altar. Ma yi sowril yi chich', ba'n skoj nin xe' cu'n yi altara'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ba'n tz'oc tan telse'n len tircu'n yi ẍepu'il, ni'cu'n chi na u'lij te yi oy tetz tzatzin paz, nin ba'n tz'oc tan pate'n tibaj yi patbil tx'ixwatz yi altar, na i'tz jun oy yi wi'nin c'o'cal tzinwutz. Ya'stzun stuleje' yi pale' tan cuyxe'n paj yi jun sloj wunaka'tz, nin tan yi xtxolbila'tz scuye' paj. ");
INSERT INTO aguBl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","”Ej nin kol tz'ul jun tal ne'ẍ cneru' ta'n yi jun sloj wunaka'tz tetz toy tampaj yi til, tajwe'n yi tij, nin yi qui'c mu'ẍ tal yana'sil. ");
INSERT INTO aguBl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ba'n ltak'e'n yi k'ab twi' yi toya'tz, nin ba'n tz'oc jak' kul ta'n le ama'l kale na chibiyxe't yi e'chk tx'ixwatz yi patu'n cu'n na chu'lij. ");
INSERT INTO aguBl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Yi pale' ba'n tcy'aj nin mu'ẍ te ẍch'el yi jun oya'tz, nin tan yi wi k'ab ba'n suk' quen chich' te yi e'chk tuq'uil yi patbil tx'ixwatz yi altar. Ma yi sowril yi chich', ba'n lkoj nin xe' cu'n yi altara'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Tajwe'n tcy'ajlen tircu'n yi ẍepu'il yi oya'tz, chi na ban yi tal ne'ẍ cneru' yi na ẍchaj yi ja jal tzatzin paz, nin ba'n tz'oc tan pate'n yi ẍepu'a'tz wi yi altar, tuml yi e'chk oy yi spat-xok tan tak'le'n ink'ej. Nin tan yi xtxolbile'j, xcyek yi pale' tan jale'n cuybil paj yi jun wunaka'tz yi ja juch til, nin scuye' paj. ");
INSERT INTO aguBl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","”Yi ko at jun yil chakxij tan testiwi'n jun takle'n yi ja til, nka yi ja tbit, nin quil tak' tib tan xtxole'n yi mbi cu'n mbajij, na tzun elpont yi ncha'tz i' aj paj, nin jepon yi jun ila'tz te'j kul. ");
INSERT INTO aguBl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","”Ncha'tz ko at jun yil mac alchok takle'n yi xan, chi tane'n yi wankil alchok jilwutz txuc yi quimnakt, nin qui'c na ban ko smaron nka awuna'n yi txuca'tz, ilenin tz'ocopon lac'p ilc'ol te'j tane'n, ptzun qui'k tz'icy' tetz yi nje' macol. ");
INSERT INTO aguBl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","”Ej nin alchok scyetz yil maque'n e'chk takle'n juntlen yi na el twankil jun wunak, nka alchok takle'nil yi xcyek tan tocse'n il c'ol te'j tane'n, nin qui tz'icy' tetz yi ko ja mac e'chk takle'na'tz, na oc il c'ol te'j tane'n, ptzun buch tlenk lnachon i' te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","”Ej nin ko at jun yi jo'le'n tlen tu' ltal ‘Jun cu'n yol tzimbne', yi je'j’, (qui'c na ban yi ko ba'n nka ploj yi jun xtxolbila'tz yi ja klo' oc tan banle'n) poro qui nin me'l cu'n te'j yi yol yi nsuk, ilenin sjalok til tan paj. ");
INSERT INTO aguBl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","”Ej nin alchok scyetz yi na nachon te yi ja juch til tan yi e'chk xtxolbila'tz, tajwe'n yi quil jiẍ tib tan xtxole'n tircu'n yi til yi njuch. ");
INSERT INTO aguBl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Nin tajwe'n tcy'aj nin jun tij chiw tzinwutz, nka jun tij cne'r, tetz xtx'ixwatz tan yi til yi njuch, nin tz'ocopon yi pale' tan toye'n yi xtx'ixwatz yi jun juchul ila'tz tzinwutz tan tele'n yi til te'j kul. ");
INSERT INTO aguBl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","”Ma ko qui'c pu'k jun tan lok'che'n jun ne'ẍ cneru', nka jun ne'ẍ chiw, tajwe'n ltoy jun lmuj tal slu'k, nka jun lmuj tal ne'ẍ plomẍ. Jun i'tz tan yi til yi njuch, tan yi xubse'n yi mban, nin yi junt i'tz chi jun tx'ixwatz yi spat-xok tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Tajwe'n tz'opon yi tx'ixwatza'tz swutz yi pale', nin yi pale' ba'n tz'oc tan suke'n nin yi jun yi squimok tetz oy tampaj yi il, nin tz'elpon kinol yi wi', poro quil tz'el junawes. ");
INSERT INTO aguBl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Kalena's tzun ben ch'uli'n mu'ẍ te yi ẍch'el yi tx'ixwatza'tz le jalaj xlaj yi altar, nin yi sowril yi chich' tajwe'n syutz' nin xe' cu'n yi altar. Na i'tz jun tx'ixwatz tan stzajse'n yi il yi njuchlij. ");
INSERT INTO aguBl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ma yi junt, spat-xok tircu'n wankil chi na ban nin. Nin tz'ocopon yi pale' tan toye'n yi tx'ixwatz yi jun juchul ila'tz tzinwutz tan tele'n yi til te'j kul, nin scuylok paj. ");
INSERT INTO aguBl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","”Ej nin yi ko at jun yi quil xcye' tan lok'che'n cob tal ne'ẍ slu'k, nka cob tal ne'ẍ plomẍ, tajwe'n tcy'ajnin cyaj liwr te yi chumbalaj jarin. Poro qui'c cuj tan bene'n yujul aceitil oliw txo'l, nin qui'c cuj tan bene'n yujul insens txo'l yi jarina'tz, na i'tz jun oy tan jale'n cuybil paj. ");
INSERT INTO aguBl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Nin tajwe'n tan bene'n tcy'al yi jarina'tz swutz yi pale'. Nin yi pale' ba'n xtxobe'n jun chi'm te yi jarina'tz, tetz k'ajbil tircu'n yi jarin, nin ba'n ben tan pate'n wi yi patbil tx'ixwatz txo'l yi e'chk tx'ixwatz yi na tzan pate'n tzinwutz. I'tz jun tx'ixwatz tan jale'n cuybil paj. ");
INSERT INTO aguBl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ya'stzun sbne' yi pale' tan toye'n yi xtx'ixwatz juna'tz, tan jale'n cuybil paj. Inti sowril yi jarin, ba'n lcyaj cyen tetz wa' yi pale', chi na ban yi ixi'n triw yi che'ja'nt yi na opon oyi'n,” stzun Ryos bantz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Itzun bantz nintzun jilon tzaj junt tir Kataj Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Alchok scyetz yi qui na el cu'n te jun munl i' tzinwutz, na tzun juch til tampaj. Yil nachon te til, tajwe'n tzun ltcy'aj tzaj jun mam cne'r yi qui'c mu'ẍ tal yana'sil, tan ẍchojle'n yi til, nka tajwe'n tan ẍchojol jun mult chi yi walor yi jun mam cne'ra'tz. Yi jun multa'tz cho'n na xom te jamel yi jun cne'ra'tz yil bixe' cyak'un yi e' pale'. Nin tajwe'n tan ẍchojle'n tan yi jun jilwutz pwok yi na xcon cyak'un e' pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Tajwe'n yil ẍchoj yi walor yi juchbe'n, na at wi'nin xanil yi e'chk munla'tz tzinwutz. Tajwe'n tan ẍchojle'n tuml jun mult yi i'tz jun part te o' piẍ yi jamel yi cne'ra'tz. Cho'n stk'e' yi jamel yi tawun tu yi mult tetz yi pale'. Ma yi pale' tajwe'n tz'oc tan pate'n yi xtx'ixwatz yi juna'tz, nin tzincuye' paj. ");
INSERT INTO aguBl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","”Ej nin ko at jun yil juch til tampaj yi qui nin nxom te jun inca'wl, nin ptzun qui'k tz'icy' tetz yi ploj mban, ilenin sjalok til, nin tajwe'n tan ẍchojol yi mult. ");
INSERT INTO aguBl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Tajwe'n ltcy'aj tzaj jun mam cne'r, yi qui'c mu'ẍ tal yana'sil tetz xtx'ixwatz, tetz xel i' tan yi til. Nin aẍ Moisés tz'a'lon yi nicy'na' sbne' jamel yi jun awuna'tz, nin tajwe'n tcy'aj nin yi juchul il swutz yi pale', tetz xel yi juchbe'n, nin tan jale'n cuybil paj, na qui tz'icy' tetz yi njuch til, nin scuylok tzun pajtz tan yi xtx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Yi jun tx'ixwatza'tz i'tz tetz xel yi juchbe'n, na yi juna'tz i' aj paj tzinwutz,” stzun Ryos ban tzajtz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ej, itzun bantz, nintzun cawun tzaj junt tir Kataj Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Ko at jun yaj yil sjuch cu'n til tzinwutz tajwe'n tan ẍchojol til. Yi e'chk juchbe'na'tz i'tz: Tan paj yi na oc tan suble'n junt wunak yi ja k'uke' c'u'l te'j. I' jun subulnak kol tabnaj jun yaj mu'ẍ pwok nka alchok e'chk takle'n tetz, nin qui't na pakxij ta'n tetz taw; nka ko na c'am jun e'chk takle'n nin qui't na pakxij ta'n tetz taw. Ncha'tz ko na talk'aj jun e'chk takle'n, nka ja el majol jun e'chk takle'n tan puers; ");
INSERT INTO aguBl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","nka ja cu' tewal jun takle'n yi ja noj pon te'j, yi na nachon i' te'j na'j taw; nka tampaj yi ja tal jun yol yi qui nin mme'l cu'n k'ab te'j. Alchok scyetz yi na ban jun scyeri e'chk ila'tz, ja wi't juch til tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","I' aj paj sbne' tan yi subulnaki'n. Nin chin tajwe'n cunin yil tz'ajt yi takle'na'tz ta'n yi ja el tzaj talk'al, nka yi mme'l tzaj majol tan puers, nka tan paj qui mo'c il tan quicy'le'n yi takle'n yi ja ak'lij tetz tan colol, nka jun takle'n yi ja je' sicy'ol, yi qui nin mma'jt ta'n tetz yi taw. ");
INSERT INTO aguBl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Ncha'tz ko quinin mme'l cu'n te yol yi nsuknak, tajwe'n tan tele'n cu'n te'j. Ej nin chin tajwe'n cunin tan tk'ol jun part te yi o'i'n part te yi jamel yi e'chk takle'na'tz. Ncha'tz tajwe'n tan toye'n yi xtx'ixwatz swetz, bantz jale'n cuybil paj. Na ja oc tan suble'n jun wunak, nin ncha'tz ja oc tan insuble'n tan yi e'chk ajtza'kla'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Nin yi xtx'ixwatz yi stoye' swetz tan jale'n cuybil paj, tajwe'n yi i'tz jun cne'r yi qui'c mu'ẍ tal yana'sil. Nin yi jamel yi jun tx'ixwatza'tz, aẍ bixba'n tetz yi nicy'na' sbne' jamel tan ẍchojol yi mult. Tajwe'n yi cho'n ltz'el tzaj yi cne'ra'tz xo'l yi tawun yi aj juchunla'tz, nin tajwe'n tan topone'n ta'n swutz yi pale', tetz xtx'ixwatz tan jale'n cuybil paj. ");
INSERT INTO aguBl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Nin yi pale' tz'ocopon tan toye'n yi xtx'ixwatz yi juna'tz tzinwutz, nin tzincuye' paj te alchok ajtza'kl kale yi njuchwit yi til.” stzun Ryos bantz tetz Moisés, tan tlol i' scyetz yi e' tanum yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Itzun bantz nintzun jilon tzaj junt tir Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Cawun nin tetz Aarón scyuch' nitxajil, nin alaj yi e'chk ca'wle'j scyetz, te e'chk tx'ixwatz yi na pat-xij tircu'n chiwankil. ”Yi awun yi tz'ocopon pate'n tetz tx'ixwatz, tajwe'n yil cyaj cyen wi k'ak' wi yi altar tetz cyakil ak'bal, bantz stz'e'e'n cu'n tan k'ak'. ");
INSERT INTO aguBl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ba'n tz'oc be'ch tetz yi pale' nin ba'n xcon calsonsiy ta'n yi lino cu'n. Nin ba'n ben i' tan molche'n yi stza'jil yi jun awuna'tz yi tz'e'nakt wi altar, nin tajwe'n ltak' cu'n xlaj yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ma yil bnix cyakil yi xtxolbila'tz, ba'n tzun xtx'ixplen yi be'ch tetz, nin ba'n tcy'aj nin yi stza'jil joylaj len chinajbil wunak, tul jun ama'l yi xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","”Ma yi k'ak' yi na tzan wi altar, qui'c cuj tan stzaje'n tetz cyakil k'ej. Nin tajwe'n tan toque'n yi pale' tan nuc'leje'n si' wi yi altara'tz cyakil jalchan, nin tajwe'n tan je'n nuc'u'l yi awun yi tz'ocopon pate'n wi k'ak'a'tz. Ncha'tz stz'e'sok ntin yi ẍepu'il yi e' tx'ixwatz yi na ak'lij tan ẍchajle'n yi ja jal tzatzin paz tu Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Qui'c rmeril tan stzaje'n yi k'ak' wi altar, tajwe'n yi na tzan sk'ejl tu lak'bal. ");
INSERT INTO aguBl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","”Je bin yi e'chk xtxolbile'j yi tajwe'n tan banle'n te e'chk oy, yi ixi'n triw cu'n yi che'ja'nt: Tajwe'n tz'opon jun scyeri e' pale' yi e' xonl Aarón, tan toye'n wi altar tzinwutz yi in Jehová iRyosil. ");
INSERT INTO aguBl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ej, nin tajwe'n tan je'n xtxobol mu'ẍ te yi jarin yi na tzan toye'n tu mu'ẍ aceitil oliw, tuml cyakil yi insens yi xomij xlaj yi oya'tz, nin tz'ocopon tan pate'n wi altar na yi jun txoba'tz yi na pat-xij, i'tz k'ajbil tircu'n yi jarin tu yi aceit, na i'tz jun tx'ixwatz yi wi'nin c'o'cal tzinwutz nin yi wi'nin na chintzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ma yi sowril yi jun oya'tz, ba'n xcon tetz chiwa' Aarón scyuch' e' nitxajil, ba'n bnix pam cya'n te'j yi qui'c xtx'amil, nin ba'n baj cya'n le k'anil yi mantial tetz molbil ibaj, yi wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Qui'c rmeril tan toque'n xtx'amil yi jarina'tz cya'n. Na ya'stzun yi cyetz chipart yi ja wak' scyetz te yi e'chk oy yi na ak'lij swetz, yi wi'nin xanil chi tane'n yi e'chk tx'ixwatz tetz juchle'n il, nin yi e'chk tx'ixwatz tan jale'n cuybil chipaj tan yi xubse'n yi nchiban. ");
INSERT INTO aguBl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Tetz ben k'ej ben sak, nin sbne' opon tunintz, cyakil yi e' yaj yi e' xonl Aarón, ba'n lbaj yi cyetz chipart cya'n te e'chk oy yi na pat-xij tzinwutz wetz. Xan kol maque'n alchok wunakil yi e'chk oya'tz,” stzun Ryos ban tzajtz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Itzun bantz nintzun cawun tzaj junt tir Kataj Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Je yi jilwutz oye'j yi tajwe'n ltoy Aarón scyuch' yi e' xonl, tetz Kataj Ryos, yil tz'opon yi k'ej yil cho'c quen tetz pale': cyaj liwr te yi chumbalaj jarin, chi jun oy yi ixi'n triw cu'n yi che'ja'nt, nin tajwe'n cob tx'akaj sban, stz'oyxok jun tx'akaj jalchan nin yi junt tx'akaj, cwe'n k'ej, nicy' nin tu' sbne'tz tetz cyakil tiemp. ");
INSERT INTO aguBl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Tajwe'n yi cho'n sk'ajsij yi oya'tz tul jun sartén, nin tajwe'n yujle'n tu aceitil oliw, nin yil tz'opon oyi'n tajwe'n yi piẍu'n cu'n sban, na i'tz jun oy yi wi'nin c'o'cal tzinwutz, nin yi wi'nin na chinzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Cho'n tzun scyuleje' yi e' pale', yi e' xonl Aarón yil cho'c cyen tetz wi'tz pale', na tetz Kataj tircu'n yi oy nin tajwe'n yi patu'n cu'n tz'u'lij. ");
INSERT INTO aguBl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Tircu'n yi e'chk oya'tz, tajwe'n yi patu'n cu'n tz'u'lij, nin qui'c cuj tan baje'n mu'ẍ tal cya'n te yi oya'tz,” stzun Ryos ban tzajtz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Itzun bantz nintzun cawun tzaj junt tir Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Txolaj yi e'chk ca'wle'j tetz Aarón scyuch' yi e' nitxajil, te yi mbi tajwe'n tan banle'n te e' tx'ixwatz yil xcon tan xtx'ajle'n quil: Yi awun yi stz'oyxok tampaj quil, tajwe'n yil tz'oc jak' kul tzinwutz, le yi ama'l kale na chibiyxe't yi e'chk awun yi na patij tircu'n chiwankil, na i'tz jun tx'ixwatz yi wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Yi pale' yi tz'ocopon tan toye'n yi tx'ixwatza'tz, ba'n lwan te'j, poro tajwe'n lbaj ta'n le jun ama'l yi xansa'nt, yi cho'n at wutzk'anil yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Alchok takle'nil yil noj quen te yi tx'ixwatza'tz sxansok cyen, nin yi kol noj chich' te yi be'ch tetz yi pale', tajwe'n tan xtx'ajle'n tul jun ama'l yi wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Yi ẍwok' tx'otx' kale ntxicyxe't yi oy, tajwe'n yil cu' paxu'n. Ma yi ko cho'n ntxicyxij tul jun ẍwok' yi brons cu'n, tzicu'n tzuntz yi ntin je' tx'ajij wutz. ");
INSERT INTO aguBl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","”Yi jun tx'ixwatza'tz wi'nin xanil. Nin ntin yi e' pale' ba'n lchiwan te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Poro qui'c rmeril tan baje'n jun awun cya'n yi na oylij tampaj quil, ko ja opon ticy'le'n yi ẍch'el le mantial tetz molbil ibaj, tan jale'n cuybil paj, na yi wankil yi jun tx'ixwatza'tz tajwe'n tan pat-xe'n tircu'n yi wankil. ");
INSERT INTO aguBl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","”At wi'nin xanil yi e'chk tx'ixwatz yi na xcon tan ẍchojle'n paj jun. ");
INSERT INTO aguBl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Yi awun yi stz'oylok, tajwe'n yil tz'oc jak' kul le ama'l kale na chibiyxe't yi e'chk awun yi na chipat-xij, nin yi ẍch'el, tajwe'n ben kojij tibaj, nin xlajak yi patbil tx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Tajwe'n tan toye'n tircu'n yi ẍepu'il yi awuna'tz, yi ẍepu' yi at te yi je', nin tircu'n yi at te yi lasu', nin yi at le c'u'l. ");
INSERT INTO aguBl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Ncha'tz cabil yi xtxicun, tu yi ẍepu'il yi at scye'jak, tu yi at xe c'u'l nin tu yi ẍepu' yi at te yi xtx'otx', tajwe'n tz'el ticy'le'n tuml yi cob xtxicun. ");
INSERT INTO aguBl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kalena's tzun tz'oc yi pale' tan pate'n tircu'n yi e'chk takle'na's wi yi altar, chi jun oy yi na pat-xij tan tak'le'n k'ej Ryos. Nin i'tz jun xtxolbil yi tajwe'n tan bnol jun juchul il te xtx'ixwatz, tan ẍchojle'n yi ca'wl yi mpaj. ");
INSERT INTO aguBl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Nin tircu'n yi e' pale' ba'n chiwan te'j, poro tajwe'n tan chiwane'n le jun ama'l yi xansa'nt, na wi'nin xanil yi jun wa'na'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","”Ej nin yi jun jilwutz tx'ixwatz yi na xcon tan ẍchojle'n yi ca'wl yi mpajlij, ni'cu'n tu yi tx'ixwatz yi na xcon tan xtx'ajle'n til jun, yi e'chk ca'wla'tz ni'cu'n tetz cabil xtxolbil. Ej nin yi oya'tz i'tz tetz yi pale' yi na oc tan banle'n yi jun munla'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ncha'tz yi pale' yi tz'ocopon tan biyle'n yi tawun junt, yi ja toy tan pat-xe'n, tetz yi pale'a'tz sbne' yi stz'uml yi jun tx'ixwatza'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ncha'tz cyakil yi e'chk oy yi ixi'n triw cu'n, na ja oc tetz jarin, nin ja oc sk'ajse'n tul ẍchujil pam, nin tircu'n yi na bnix tul e'chk ẍwok' tu apast, tetz yi pale' sbne', na i' na tzan tan toye'n yi oya'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Nin ite'n nin sbne' cyakil yi e'chk oya'tz yi ixi'n triw cu'n yi che'ja'nt, tuml yi e'chk oy yi na oc co'se'n tu aceitil oliw, nin tu yi e'chk oy yi skejenle'n, cyetz cyakil yi e' nitxajil Aarón sbne', nin nicy' nin tu' na chibaj ben. ");
INSERT INTO aguBl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","”Ma jalu', je xtxolbile'j yi ẍe'n tzitulej, ko at jun yil tak' jun oy yi na ẍchaj yi ja jal tzatzin paz ẍchixo'l tu Ryos: ");
INSERT INTO aguBl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Yi ko i'tz tan tyoẍi'n tetz Ryos yi oy, tajwe'n yil toy e'chk pam yi qui'c xtx'amil. Ba'n tak' e'chk pam yi co'si'nt tu aceit, nka ba'n tak' e'ch ẍec yi qui'c xtx'amil, nin yi ch'uli'n aceit tibaj. Ncha'tz ba'n ltoy junt jilwutz pam, yi na bnix te balaj jarin, yi co'si'n tu aceit. ");
INSERT INTO aguBl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ej nin tuml yi jun oya'tz tetz tzatzin paz, tajwe'n yi xomij pam yi at xtx'amil. ");
INSERT INTO aguBl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Te tircu'n e'chk oya'tz tz'elpon ticy'le'n mu'ẍ te'jak, tan toye'n swutz Kataj. Poro tetz yi pale' sbne', na i' na tzan tan kojle'n yi ẍch'el yi oy yi na ẍchaj yi ja wi't jal tzatzin paz, xe' cu'n yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","”Yi tx'ixwatz yi na oylij tan tyoẍi'n tetz Ryos, nin tetz tzatzin paz, tajwe'n yil baj te ite'n nin k'eja'tz yi na oylij. Qui'c rmeril tan cyaje'n cyen colij jun tal piẍ tetz junt k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ma jalu' yi awun yi na tzan toye'n swetz, ko i'tz tan tele'n cu'n te jun yol yi suknak swetz, nka na tzan tan toye'n tan tu' yi at tzatzin te talma', ba'n baj yi jun oya'tz te ite'n nin k'eja'tz, poro ko at sowril, ba'n lcyaj colij, nin ba'n lbaj cya'n le junt eklok. ");
INSERT INTO aguBl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ma yi ko atit nin sowril yi jun oya'tz le toxi'n k'ej, chin tajwe'n cunin yil patij tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Nin kol bajsij sowril yi oya'tz na ẍchaj yi at tzatzin paz skaxo'l, le toxi'n k'ej, qui tzun chintzatzin te yi jun aj oyinla'tz, nin quil jal k'ej tzinwutz. Ncha'tz yi oy, ni'cu'n yi jak oc il c'ol te'j, nin yi e' yil bajsan yi chi'baja'tz, sjalok quil te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","”Kol nojquen lac'p alchok takle'n yi xan, yi cy'a'n il c'ol ta'n, te yi chibaj, tz'ocopon tzun lac'p yi ilc'ola'tz te yi chibaj, nin qui'c cuj tan baje'n. Tajwe'n tzun yil tz'oc pate'n tircu'n. Ma ko qui'c jun e'chk takle'n yil nojquen te yi xan qui'c tzun il c'ol te yi chi'baja'tz, ba'n tzun lbajtz tan alchok wunak yi xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","”Poro kol baj tan alchok yi qui xansa'nt, tajwe'n yil tz'el laju'n tzixo'l wok, na ja oya'tz ja wi't oylij swetz, nin wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","”Ncha'tz alchok scyetz yil maque'n jun takle'n yi chin juntlen nin, chi tane'n e'chk takle'n yi na el twankil jun wunak, nka yi na el twankil jun txuc, nka alchok takle'n yi chin xa'bil nin, yi at il c'ol te'j tane'n, ej nin ko tz'ocopontz tan bajse'n yi chi'baj tetz tzatzin paz, yi wi'nin xanil, yi na oylij swetz, tajwe'n tan tele'n laju'n tzixo'l wok,” stzun Ryos ban tzajtz tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Itzun bantz nintzun jilon tzaj Ryos junt tir tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Txolnin scyetz yi e' axonl Israel yi e'chk xtxolbile'j: Qui'c rmeril tan baje'n mu'ẍ tal ẍepu'il mam tor, nka ẍepu'il ne'ẍ cne'r, nka yi ẍepu'il jun mam chiw ita'n. ");
INSERT INTO aguBl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ma yi ẍepu'il jun awun yi ẍchuc nquim, nka yi ja quim tan jun smaron txuc, ba'n xcon te alchok takle'n, poro qui'c cuj tan je'n ibajsal. ");
INSERT INTO aguBl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","”Alchok scyetz yil bajse'n yi ẍepu'il jun awun yi na oylij swetz chi inwa' tane'n, tajwe'n tan tele'n laju'n tzixo'l wok. ");
INSERT INTO aguBl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","”Alchok ama'lil kalel cxa't cu'nt, qui'c cuj tan baje'n mu'ẍ chiẍch'el yi e' txuc ita'n, ");
INSERT INTO aguBl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","nin ko at jun yil bajse'n alchok jilwutz chich', tajwe'n cu'n tan tele'n laju'n tzixo'l.” ");
INSERT INTO aguBl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Itzun bantz nintzun jilon tzaj junt tir Kataj Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Alaj scyetz yi e' axonl, yi alchok scyetz yil toy jun oy tetz tzatzin paz, tajwe'n tz'opon mu'ẍ te yi oya'tz tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Nin tajwe'n yi i' te'n nin tz'icy'an nin yi mu'ẍ te yi oya'tz yi spat-xok tzinwutz. Mben tzun tcy'al yi ẍepu'il tu tircu'n yi wutz c'u'l, yi tz'ocopon yi pale' tan suke'n nin tcya'j tetz jun balaj oy tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ej nin yi pale' tz'ocopon tan pate'n yi ẍepu' wi altar, ma yi wutz c'u'l, i'tz tetz wa' Aarón scyuch' yi e' tetz xonl. ");
INSERT INTO aguBl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ncha'tz tzitk'e' yi jalaj cux yi sbal yi oya'tz tetz ẍchib yi pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Na i' mmo'c tan pate'n yi ẍepu'il tu yi ẍch'el yi jun oya'tz yi na ẍchaj yi ja wi't jal tzatzin paz skaxo'l. ");
INSERT INTO aguBl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Yi wutz c'u'l yi oya'tz, nin yi cux yi oy yi na saj suki'n swetz, i'tz jun balaj oy yi na intz'am scyetz yi e' ixonl tan toye'n scyetz Aarón scyuch' yi e' nitxajil. Tajwe'n tan cyak'ol yi e' atanum yi jun oya'tz tetz Aarón, scyuch' e' xonl, sbne' opon tunintz,” stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ya'stzun chiwa' Aarón scyuch' yi e' xonl te yi e'chk oy yi na ak'lij tetz Kataj Ryos, te yi toque'n cunin i' tetz pale' tan xcone'n tetz ẍchakum Kataj. ");
INSERT INTO aguBl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Na ya'stzun ca'wl Kataj Ryos tan chibnol tane'n, jetz yi je'n aceit twi' Aarón, tan ẍchajle'n yi i' yi wi'tz chipale'il, nin yi xtxolbila'tz i'tz jun ca'wl yi tajwe'n tan chibnol tane'n tetz cyakil tiemp. ");
INSERT INTO aguBl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ej nin cyakil yi e'chk ca'wla'tz yi ja wi't kil, ya'stzun yi xtxolbil yi mbi cunin tajwe'n tan chibnol te yi e'chk tx'ixwatz yi na pat-xij, tu yi e'chk oy yi ixi'n triw cu'n yi che'ja'nt, tu yi e'chk tx'ixwatz tan xtx'ajle'n il, tu yi e'chk oy yi na xcon tan ẍchojle'n yi ca'wl yi mpajlij, tu yi e'chk oy yi na xcon tan chixanse'n yi e' pale', tu e'chk oy tetz tzatzin paz. ");
INSERT INTO aguBl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ya'stzun yi e'chk ca'wla'tz yi tak'nak Kataj Ryos tetz Moisés tul yi ama'l yi tz'inunin tu', wi yi wutz yi na bi'aj Sinaí, tan cyak'ol yi e'chk cyoy swutz i'. ");
INSERT INTO aguBl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Nintzun jilon tzaj junt tir Kataj Ryostz tetz Moisés, je tzun yol i' bantze'j: ");
INSERT INTO aguBl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Cy'ajwe' tzaj Aarón scyuch' yi e' cy'ajl, swutz yi puertil yi pe'mil yi at solte'j yi mantial tetz molbil ibaj, nin cy'aj nin yi be'chok yi ntin na xcon cyak'un yi e' pale', tu mu'ẍ aceit yi xconk tan chixanse'n. Ncha'tz cy'aj tzaj jun tal ne'ẍ wacẍ yi xconk tetz chitx'ixwatz tan paj yi il c'ol. Ncha'tz cob cneru' tu jun mi't pam yi qui'c xtx'amil. ");
INSERT INTO aguBl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ej nin molwe' nin cyakil nim juy swutz yi mantial tetz molbil ibaj.” ");
INSERT INTO aguBl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Ej i nin tzun tulej Moiséstz quib yi a'lchij tetz, na cyakil yi e' wunak e' mol quib swutz yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Itzun ben tlol Moiséstz scyetz: “Je yi e'chk xtxolbile'j yi ja tal Kataj Ryos, yi tajwe'n tan kabnol tane'n.” ");
INSERT INTO aguBl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Bene'n tzun tlol Moisés tetz Aarón scyuch' yi e' nitxajil, tan saje'n chiẍkansal quib swutz i', tan xtxajle'n chiwankil. ");
INSERT INTO aguBl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ma yi wi't chitx'ajone'n, nintzun oc tk'ol Moisés yi be'chok yi chukpi'n nin tu' te'j Aarón, nin je' ẍinul yi xe c'u'ltz tan jun c'albil, nin oc tk'ol yi xbu'k yi txowi'n quen tu', te'j Aarón. Ncha'tz oc tk'ol yi be'ch tetz yi na bi'aj efod wutz c'u'l Aarón, nin cu' c'alol yi e'chk ju' yi efoda'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Nin tibaj yi jun efoda'tz oc tk'ol yi junt tal xbu'k yi na bi'aj pectoral, nin tc'u'l yi jun xbu'ka'tz ba'n tz'oc cob tal ne'ẍ c'ub yi na bi'aj Urim tu Tumim. ");
INSERT INTO aguBl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Nin tzun je nuc'ul jun xbu'k te'j wi', nin swutz yi xbu'ka'tz oc tk'ol jun tal placa yi oro cu'n, nin yi na ẍchaj yi Aarón i' jun wi'tz pale'. I nintzun tulej Moisésa'tz quib yi xtxolbil yi a'lchij tetz tan Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ej nintzun je tcy'al Moisés yi aceit, nin ben kojoltz tibaj yi mantial tetz molbil ibaj, nin tibaj yi e'chk ma'cl yi at tul, ya'stzun tulejtz tan xanse'n tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ncha'tz nin ben kojol juk tir yi aceita'tz tibaj yi altar, nin tibaj yi e'chk ma'cl yi na xcontz te yi altar. Ncha'tz ben kojol tibaj yi pila' tu yi xe', ya'stzun tulejtz tan xanse'n tircu'n. ");
INSERT INTO aguBl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ncha'tz je' kojol Moisés mu'ẍ te yi aceit tetz xansa'n ib twi' Aarón, tan xanse'n i' tetz wi'tz pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Saje'n tzun ẍchakol Moisés yi e' cy'ajl Aarón, nintzun octz tan tocse'n be'ch cyetz yi chukpi'n nin tu' scye'j, nin oc tk'ol chic'albil xe chic'u'l, nin je' tk'ol yi xbu'k te'j chiwi', quib yi tal Kataj Ryos tetz. Ej nin ya'tz nin tulejtz. ");
INSERT INTO aguBl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ma yi wi't bnixe'n cyakil yi xtxolbile'j, nintzun ben mantar Moisés tan ticy'le'n tzaj jun tal ne'ẍ tor, yi na patij tampaj juchle'n il, nintzun je' chik'ol Aarón scyuch' yi e' nitxajil chik'abtz twi'. ");
INSERT INTO aguBl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Kalena's tzun toque'n jak' kultz tan Moisés, nin ben mu'ul yi wik'abtz tul yi chich', nin oc suk'ultz te'jak e'chk tuq'uil yi altar, tan xanse'n, ma yi sowril yi chich' nin tzun ben kojoltz xe' cu'n yi altar. Ya'stzun bantz tan xanse'n yi altar, tan jale'n cuybil chipaj tan e'chk quil. ");
INSERT INTO aguBl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ej nintzun eltzaj tcy'al Moisés tircu'n yi ẍepu'il yi lasu', tu yi xtx'otx' tu cyakil yi ẍepu'il, tuml cabil yi xtxicun tu yi ẍepu'il, nintzun octz tan pate'n tircu'n wi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ma yi ẍchi'bel tu yi stz'u'mil, tu yi tircu'n yi at le c'u'l, nin oc k'a'kl ta'n solte'j yi ama'l kale najlche't, quib yi tal Kataj Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Bene'n tzun mantar Moisés tan ticy'le'n tzaj yi cneru' yi bak wi' yi spat-xok tircu'n wankil, nin je' chik'ol Aarón scyuch' yi e' cy'ajl chik'abtz twi' yi cneru'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Nintzun oc jak' kultz tan Moisés, nin ben kojol yi ẍch'el tibaj nin xlajak yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Nin cu' kuxul yi cneru'a'tz, piẍu'n cu'n tulejtz, nin octz tan pate'n yi wi' tu cyakil yi wankil yi piẍu'nt tu tircu'n yi ẍepu'il. ");
INSERT INTO aguBl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ncha'tz, nin octz tan xtx'ajle'n yi lasu' tu yi e'chk cux, nin tuml yi e'chk tkan, nin octz tan pate'n tircu'n wi altar tetz jun tx'ixwatz yi patu'n cu'n na u'lij, na i'tz jun oy yi wi'nin c'o'cal swutz Ryos, nin yi wi'nin na tzatzin i' te'j. Ya'stzun tulej Moiséstz quib yi tal Kataj Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ej nin ben mantar Moisés tan ticy'le'n tzaj yi junt cneru' yi xcontz tan chixanse'n Aarón scyuch' yi e' cy'ajl, nintzun je' chik'abtz twi' yi jun cneru'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Kalena's tzun toque'n jak' kultz tan Moisés, nin je tcy'al mu'ẍ te yi ẍch'el yi jun cneru'a'tz nin oc suk'ul mu'ẍ te yi ẍchin yi at le sbal Aarón. Ncha'tz oc suk'ul te mamil wi k'ab yi sbal. Ncha'tz oc te mamil wi tkan yi at le sbal. ");
INSERT INTO aguBl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Nintzun e' saj ẍchakol yi e' cy'ajl Aarón, nin oc suk'ul mu'ẍ chich' te yi ẍchi'belil yi chiẍchin yi at le chisbal, ncha'tz te yi mamil wi chik'ab tu yi mamil wi quikan yi at le chisbal. Yi wi't bnixe'n yi xtxolbile'j nintzun ben kojol yi chich' yi sowrin, tibaj nin xlajak yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ej nintzun je tcy'al Moisés yi ẍepu', tu yi je', nin tircu'n yi ẍepu' yi at te'jak yi lasu', tu yi ẍepu' yi at te'j xtx'otx', tu cabil yi xtxicun, tu yi cux yi at le sbal. ");
INSERT INTO aguBl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Nin te yi jun tal mi't pam yi qui'c xtx'amil, yi na opon tak'le'n swutz Kataj Ryos, nintzun je tcy'al jun pam yi qui'c xtx'amil tu junt yi co'si'nt tu aceit, ncha'tz jun tal wotz', nintzun cu'-tz xlaj yi ẍepu', tu yi cux yi sbal. ");
INSERT INTO aguBl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Bene'n tzun tk'ol tircu'n le chik'ab Aarón tu yi e' cy'ajl, tan chibnol chimunl, tan chichajol swutz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Bene'n tzun Moiséstz tan ticy'le'n tzaj tircu'n yi at ẍchik'ab, nintzun octz tan pate'n wi altar, tibaj yi tx'ixwatz yi na tzan pate'n. I'tz jun oy yi ja xcon tan chixansaje'n, nin i'tz jun oy yi wi'nin c'o'cal, yi na pat-xij tan tak'le'n ke'j Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Ej nintzun je tcy'al Moisés yi wutz c'u'l yi jun mam cneru'a'tz, nintzun octz tan banle'n tane'n yi munl tan suke'n nin tetz Ryos. Yi jun piẍ wutz c'u'la'tz i'tz tetz Moisés, na ya'stzun saj tlol Kataj Ryos tetz. ");
INSERT INTO aguBl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ej nin je tcy'al Moisés mu'ẍ te yi aceit yi na xcon tan xansa'n, nin mu'ẍ te yi chich' yi at wi altar, nin ben stz'itultz ẍchiwi' Aarón tu yi e' cy'ajl, nin te yi be'ch cyetz. Ya'stzun tulejtz tan chixanse'n Aarón scyuch' yi e' nitxajil, nin tan xanse'n yi be'ch cyetz, yi na xcon cya'n. ");
INSERT INTO aguBl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Nintzun cawun Moisés scyetz Aarón tu yi e' cy'ajl: “Txicywoke'n yi chi'baj stzi' cunin yi puertil yi pe'mil yi mantial tetz molbil ibaj, nin ba'n cxwanwok te'j, le ite'n nin ama'la'tz. Nin ba'n lbaj yi pam ita'n yi qui'c xtx'amil yi at tul tal mi't. Ej inin tzituleja'tz, chi tal Kataj Ryos swetz, yi tlol i': ‘Yi Aarón tuml yi e' cy'ajl ilenin chiwank te yi chi'baje'j.’ ");
INSERT INTO aguBl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Tajwe'n tan toque'n k'a'kl yi sowril yi chi'baj tu yi pam. ");
INSERT INTO aguBl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Nin quil cxe'l wok tzaj le yi ama'l kale atit yi puertil yi pe'mil yi mantial tetz molbil ibaj, tetz juk k'ej, na ya'stzun yi tiemp tetz xansa'n ib. ");
INSERT INTO aguBl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Yi Kataj Ryos ja cawun tzaj tan banle'n e'chk munla'tz chi mbajij te cobox k'eje'j, tan stzajse'n itil yil tzijuch. ");
INSERT INTO aguBl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Cha'stzun te tajwe'n yil xcyaj wok cyen sk'ejl tu lak'bal stzi' yi puertil yi pe'mil yi mantiale'j, tetz juk k'ej. Nque'n wok bin c'ulutxum jak' ca'wl Kataj Ryos tan qui iquime'n, na ya'stzun yi ca'wl yi ja tal i' swetz.” ");
INSERT INTO aguBl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Inin tzun cyulej Aaróntz tuml yi e' cy'ajl, chi yi ca'wl yi tal Kataj Ryos tetz Moisés tan tlol scyetz tan chibnol tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Itzun bantz te yi nsken wi't cho'c cyen Aarón tetz pale', nin yi nsken icy' wajxakix k'ej, nintzun ben mantar Moisés tan chichakle'n, scyuch' yi e' wi' banl wi' tetz yi chitanum Israel. ");
INSERT INTO aguBl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Itzun taltz tetz Aarón: “Biy cu'n jun ne'ẍ tor, tan jale'n cuybil ipaj, nin jun mam cne'r yi qui'c mu'ẍ tal yana'sil, tan pat-xe'n swutz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ma yi e' mas wunak, al nin scyetz tan cwe'n chibiyol jun chiw tetz chitx'ixwatz, bantz jale'n cuybil chipaj tan yi e'chk quil, nin jun ne'ẍ tor, tu jun tal ne'ẍ cne'r yi junixe't yob cya'n, yi qui'c mu'ẍ tal chiyana'sil tetz jun tx'ixwatz yi patu'n cu'n sbne'. ");
INSERT INTO aguBl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Ncha'tz ba'n lcu' biyij jun mam tor tu jun mam cne'r tetz jun oy tetz tzatzin paz, nin ya'stzun yi tzitoye' tetz Ryos. Ncha'tz ba'n tzitoy e'chk ixi'n triw yi che'ja'nt nin yi yujijt tu aceitil oliw, na ninin jalu' ẍchaje' tib Kataj Ryos tziwutz.” ");
INSERT INTO aguBl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Inin tzun cyulejtz, chi yi tal Moisés scyetz, nin ben quicy'al yi e'chk oy swutz yi mantial tetz molbil ibaj. Cyakil cunin tzun e' nim juy saj chimolol quibtz swutz Kataj Ryos tan c'u'laje'n i'. ");
INSERT INTO aguBl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Bene'n tzun tlol Moiséstz scyetz: “Ryos ncawun tzitetz tan itule'n tzone'j, bantz itilol yi tetz k'ej tu yi tetz pak'puchal.” ");
INSERT INTO aguBl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ncha'tz ben tlol Moiséstz tetz Aarón: “Ẍkans quen awib te yi altar nin nque'n tan pate'n atx'ixwatz. Jakaj cuybil apaj, nin jakaj cuybil chipaj cyakil yi e' kawunakil, yi e' xonl Israel. Ncha'tz ak'e'n yi oy wi altar yi ja ul cyak'un yi e' wunak tetz Ryos. Ncha'tz jakaj cuybil chipaj, na ya'stzun yi ntal i', yi tajwe'n tan ibnol tane'n.” ");
INSERT INTO aguBl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Bene'n tzun Aaróntz swutz yi altar, tan tocse'n jak' kul yi tal ne'ẍ tor tetz xtx'ixwatz tan yi tetz til. ");
INSERT INTO aguBl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ma yi e' cy'ajl, e' tzun icy'anin yi ẍch'el yi xtx'ixwatz. Ma Aarón nin cu' mu'ul yi wi k'abtz tul yi chich', nin oc suk'ultz te'jak yi e'chk tuc' yi at te altar, ma yi sowril yi chich' cho'n tzun bene'n kojoltz txe' cu'n yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Nin octz tan pate'n yi ẍepu' tu yi xtxicunil yi at le c'u'l, tuml yi ẍepu'il yi xtx'otx' yi xtx'ixwatza'tz. Ya'stzun tulejtz, na ya'tz tal Jehová Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Poro yi ẍchi'bel tu yi stz'uml, cho'n tzun toque'n pate'ntz joylaj len yi ama'l kale najlche't. ");
INSERT INTO aguBl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ncha'tz cu' biyol Aarón yi xtx'ixwatz i' yi na pat-xij tircu'n wankil, nintzun ben quik'ol yi e' cy'ajl yi ẍch'el yi xtx'ixwatza'tz tetz, nin cho'n bene'n kojol i' xlajak yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Te yi nsken wi't bnix yi xtxolbile'j nintzun opon ticy'le'n swutz Aarón, yi wi' yi tx'ixwatz tu yi ẍchi'bel yi kuxij cu'n tane'n, nintzun octz tan pate'n wi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Nintzun octz tan xtx'ajle'n tircu'n yi at le c'u'l yi xtx'ixwatz, tu yi cux, kalena's tzun pat-xe'ntz, tuml yi e'chk piẍa'l yi nsken wi't je' nuc'ij wi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Yi baje'n yi xtxolbile'j, nin tzun octz tan toye'n yi cyoy yi tanum. Nin xcon jun mam chiw ta'n, tetz chitx'ixwatz, nin oc jak' kultz ta'n, nin octz tan pate'n swutz Ryos, bantz jale'n cuybil chipaj, chi ntulej yi tetz xtx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Nintzun octz tan toye'n yi tx'ixwatz, quib yi ca'wl yi at cyen. ");
INSERT INTO aguBl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ncha'tz tak' i' jun oy yi ixi'n triw yi che'ja'nt, nintzun je tcy'al mu'ẍtz te'j, nintzun oc k'a'kltz ta'n wi altar, chi mban yi jun tx'ixwatz yi mpat-xij jalchan. ");
INSERT INTO aguBl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Oc jak' kul yi mam tor ta'n tu yi cneru', tetz jun oy tetz tzatzin paz, tetz cyakil yi e' tanum. Ma yi e' cy'ajl Aarón, e' oponsan yi ẍch'el yi tx'ixwatza'tz tk'ab i', nin tzun ben kojol Aaróntz tibaj nin xlajak yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Nin je tk'ol Aarón yi ẍepu'il yi tor, tu yi ẍepu'il yi cneru', tu tircu'n yi je', tu ẍepu'il yi lasu', yi xtxicun yi at le c'u'l, nin yi ẍepu'il yi xtx'otx', ");
INSERT INTO aguBl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","nin je tk'ol yi ẍepu'a'tz tuml yi wutz c'u'l wi yi altar. Nintzun oc k'a'kltz ta'n. ");
INSERT INTO aguBl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Ej, nin oc Aarón tan suke'n nin yi wutz c'u'l yi tx'ixwatz, tu yi cux yi sbal tetz Ryos. Ya'stzun bantz na i'tz jun oy yi je' suki'n swutz Ryos, na ya'stzun ca'wl yi tal Moisés tan bnixe'n. ");
INSERT INTO aguBl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Yi bnixe'n cyakil yi e'chk xtxolbila'tz tan Aarón nintzun je tk'ol k'abtz squibaj yi e' wunak tan tak'le'n chibanl, nin eltzajtz te yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Nin e' oc Moiséstz, tu Aarón le yi mantial tetz molbil ibaj. Ma yi cyele'n tzaj nintzun cyak' chibanl squibaj cyakil yi e' wunak. Lajluchaxe'n tzun yi pak'puchal Kataj Ryos ẍchiwutz tircu'n e'. ");
INSERT INTO aguBl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Na nin cu'ul tinc'uj jun chin k'ak'tz tan stz'e'se'n cu'n yi tx'ixwatz, tu yi e'chk ẍepu' yi list tan pate'n wi altar. Ma yi quilol yi xtxolbile'j, tircunin tzun e' wunak e' ẍch'intz, nin e' cu' jokloktz wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Itzun bantz nin e' ben yi e' cy'ajl Aarón yi na chibi'aj Nadab tu Abiú, tan ticy'le'n tzaj yi chipatbil insens, nin tzun cu' chinojsaltz tan xtxak'ak', nin je' insens cya'n tibaj yi k'ak'a'tz, nin e' octz tan toye'n tetz Ryos. Poro yi jun oya'tz nk'e'tz Ryos a'lon scyetz tan chibnol tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Tele'n tzaj tzun tinc'uj jun chin k'ak' tan Kataj Ryos, nin yi jun k'ak'a'tz xcye' tan chitz'e'se'n, nin tan chibiyle'n cu'n. ");
INSERT INTO aguBl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Nintzun ben tlol Moisés tetz Aarón: —Ya'stzun yi xtxolbile'j yi tal Jehová Ryos, na je yol i'e'j: “Tzinchaje' yi wi'nin inxanil scyetz yi e' yi na chiban tane'n chimunl tzinwutz. Nin tzinchaje' yi at wi'nin ink'ej scyetz cyakil e' xonl Israel,” stzun Ryos, chij Moisés bantz. Qui'c nin tzun jun yol je tlol Aaróna'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Lajke'l nintzun bene'n mantar Moisés tan ẍchakle'n Misael tu Elsafán, yi e' cy'ajl Uziel, yi tío Aarón. Itzun ben tloltz scyetz: —Or itetz lajke'l, nin cy'ajwoke'l tzaj chiwankil itzicy, swutz yi mantial, nin cy'ajwoke' nin joylaj len yi tnum. ");
INSERT INTO aguBl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Lajke'l nin tzun cyopone'ntz, nin je chitz'amol yi be'ch cyetz tan cyelsene'l tzaj chiwankil yi e' alma'a'tz joylaj len yi tnum, quib yi tal Moisés scyetz. ");
INSERT INTO aguBl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Bene'n tzun tlol Moiséstz tetz Aarón scyuch' yi e' cy'ajl yi na chibi'aj Eleazar tu Itamar: —Quil tzichitpwok len xi'il iwi', nin quil tzirit' cu'n yi be'ch itetz, tan qui iquime'n, nin tan qui jale'n ẍchi'chbe'n c'u'l Ryos te yi e' katanum. Poro yi e' mas wunak tetz yi tnum, tircu'n e', ba'n chichunan tan ẍchajle'n yi bis yi ate' cu'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Nin quil cxe'ltzaj wok solte'j yi mantial tetz molbil ibaj, na ko ya'tz xquimok wok, na je'nak aceit tiwi' tan ixanse'n tan Jehová Ryos. Ej, ya'tznin tzun cyulejtz quib yi tal Moisés scyetz. ");
INSERT INTO aguBl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Itzun bantz nin tal Ryos tetz Aarón: ");
INSERT INTO aguBl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Qui'c cuj tan baje'n win awa'n scyuch' acy'ajl, nka alchok jilwutz xc'ala', yi ntaxk cxo'c wok tul yi mantial tetz molbil ibaj, bantz qui iquime'n. Yi jun xtxolbile'j i'tz jun ca'wl tetz itetz scyuch' e' ixonl tetz ben k'ej ben sak. ");
INSERT INTO aguBl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Yi xac yi jun ca'wla'tz i'tz tan lajluchaxe'n tziwutz yi mbi'tz xan, nin mbi'tz yi nk'e'tz xan. Ncha'tz i'tz tan lajluchaxe'n yi e'chk munl yi skoj cu'n te'j txo'l yi e'chk munl yi na jal itil ta'n, ");
INSERT INTO aguBl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","nin tajwe'n tan ichusul yi e' itanum te tircu'n yi e'chk ca'wl yi walnak tetz Moisés, tan ixome'n te'j.” ");
INSERT INTO aguBl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Nintzun tal Moiséstz tetz Aarón scyuch' yi cob cy'ajl, Eleazar tu Itamar, yi jalta'tz cob e' e' cyaj cyen: —Ba'n xcon yi oy yi ixi'n triw cu'n ita'n, yi ja cyaj cyen te yi e'chk oy yi ja pat-xij swutz Jehová Ryos, nin ba'n tzibajswoke'n, poro quil tz'oc xtx'amil yi e'chk pama'tz ita'n. Bajswoke'n naka'jil yi patbil tx'ixwatz, na i'tz jun oy yi wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Yi jun jilwutz oya'tz axwok bajsank tetz, sbne' opon tunintz. Nin tajwe'n tan baje'n ita'n tul jun ama'l yi wi'nin xanil, na ya'stzun itetz sbne'. I'tz ipart te e'chk oy yi na pat-xij swutz Kataj Ryos tan tak'le'n ke'j i'. Na ya'stzun jun scyeri ca'wl yi tak' Kataj Ryos swetz. ");
INSERT INTO aguBl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Nin ncha'tz ba'n cxwan wok tej yi wutz c'u'l yi tx'ixwatz yi suki'n mmu'lij, yi wi'nin k'ej. Nin ba'n cxwan wok te yi cux yi sbal, yi jun tx'ixwatza'tz yi na oylij tetz Ryos. Nin tajwe'n tan ibajsal scyuch' yi e' acy'ajl nin scyuch' e' ame'l, tul jun ama'l yi xan, na ya'stzun itetz ipart te e'chk oy tetz tzatzin paz yi na cyak' yi e' itanum tetz Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Yi cux yi tx'ixwatz yi sbal, tu yi wutz c'u'l yi suki'n na u'lij tetz Kataj Ryos, yi na chicy'aj tzaj yi ẍepu' yi na patij swutz Ryos, cyakil yi chi'baja'tz ya'stzun itetz sbne' nin scyetz initxa' tetz ben k'ej ben sak. Na ya'stzun alijt cyen tan Kataj Ryos swetz. ");
INSERT INTO aguBl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ej nintzun oc Moisés tan jakle'n tkanil yi jun mam chiw yi ak'lij tan jale'n cuybil chipaj, poro nsken wi't pat-xij. Nintzun je' lajp wi' Moiséstz scye'j Eleazar tu Itamar, yi e' cy'ajl Aarón, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","—¿Mbi tzuntz yi qui mbaj yi tx'ixwatz ita'n yi na xcon tan jale'n cuybil paj jun, tul jun ama'l yi xan? Na, chin xan nin yi jun oya'tz, na ja tak' Ryos tzitetz tan bene'n tekal tircu'n yi quil yi e' itanum. ");
INSERT INTO aguBl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Na yi ẍch'el yi jun tx'ixwatza'tz qui nin mben ticy'le'n tul yi mantial tetz molbil ibaj, cha'stzun te ja klo' baj yi chi'baj ita'n le jun ama'l yi xan, quib yi walnak tzitetz. ");
INSERT INTO aguBl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Stza'wel tzun Aarón yi yol Moisés, itzun taltz: —Jalu', ja cyoy yi e' wunak chitx'ixwatz tan jale'n cuybil chipaj, nin ja cyoy chitx'ixwatz yi patu'n cu'n na u'lij swutz Jehová Ryos, poro ilenin ja bajij e'chk il swe'j, nin yi wetz yi na waj tz'el intxum tetz i'tz: ¿Yi jajk chinwan te yi tx'ixwatza'tz, ja ptzun klo' tzatzin Ryos te'j? ");
INSERT INTO aguBl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Nintzun cu c'u'l Moiséstz tba'n tan yi xtxolbil yi ben tbital te'j Aarón. ");
INSERT INTO aguBl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ej, nintzun jilon tzaj Ryostz scyetz Moisés tu Aarón, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Alwok scyetz yi e' xonl Israel yi ba'n chibajsaj cyakil e'chk jilwutz txuc yi at wi munt. ");
INSERT INTO aguBl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Ba'n lbaj yi e' txuc ita'n yi na chiwoch' cob tir chiwa', nin yi cob cuntu' elnak chipac'. ");
INSERT INTO aguBl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","”Ma na ẍchixo'l yi e' txuca'tz yi na chiwoch' cob tir chiwa' nin yi at chipac' yi nk'e'tz cob cuntu' elnak, quil baj ita'n. Quil baj yi e' camey ita'n, na ba'n na chiwoch' cob tir chiwa' poro nk'e'tz cob cuntu' elnak chipac', nin xan kol baj jun txuca'tz ita'n. ");
INSERT INTO aguBl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","”Ncha'tz yi xpitak', ba'n na chiwoch' cob tir chiwa', poro nk'e'tz cob cuntu' elnak yi pac', nin sjalok itil kol baj ita'n. ");
INSERT INTO aguBl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","”Ncha'tz yi e' umul ba'n na chiwoch' cob tir chiwa', poro nk'e'tz cob cuntu' elnak chipac'. Nin tajwe'n tz'oc ita'n chi jun txuc yi xan, yi qui'c cuj tan bajse'n. ");
INSERT INTO aguBl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","”Quil baj chi'baj boch ita'n, na at pac' nin cob cuntu' elnak, por qui na chiwoch' cob tir chiwa'. Xan kol baj ita'n. ");
INSERT INTO aguBl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","”Qui'c rmeril tan baje'n yi chichi'bel yi txuca'tz ita'n, nin qui'c cuj tan imacol chiwankil yi ko quimnakt, na sjalok itil kol tzimac. ");
INSERT INTO aguBl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","”Ma jalu', scye yi e' txuc yi na chixon xe a' ba'n lbaj ita'n, poro ko ntin at chixicy' nin ko at cxti'lil cye'j, nin yi cho'n na chixon tul e'chk tzanla' nka xe mar. ");
INSERT INTO aguBl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ma yi e' txuc yi qui'c chixicy', nin qui'c cxti'lil cye'j, yi cho'n nin najlche'-tz xe a', xan kol tzibajsan, nin chin xa'bil nin e'chk txuca'tz sbne' tetz itetz. ");
INSERT INTO aguBl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Quil tzibajsaj yi chichi'bel yi e' txuca'tz, nin ko quimnake't, chin xa'bil nin chiwankil sbne' tetz itetz. ");
INSERT INTO aguBl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Tircu'n jilwutz txuc yi cho'n ate' xe a', nin yi qui'c chixicy' tu cxti'lil yi cye'j, chin juntlenin sbne' tetz itetz. ");
INSERT INTO aguBl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","”Ma jalu', chixo'l yi txuc yi na chixicy'in, qui'c cuj tan baje'n yi jun tx'akaje'j ita'n: yi e' q'uilq'uitx, tu yi e' wa'kl bak, tu yi e' aj cayinl yi cho'n najlche' kale atit mar, ");
INSERT INTO aguBl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","tu cyakil jilwutz ku's, tu yi e' ku's yi ẍel, ");
INSERT INTO aguBl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","nin tircu'n yi e' jilwutz joj yi at, ");
INSERT INTO aguBl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","tu yi e' avestruz, tu yi e' xitx', tu yi e' gaviota, nin tu cyakil jilwutz q'uil q'uitx yi at, ");
INSERT INTO aguBl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","tu cyakil jilwutz tucruj, nin yi junt jilwutz yi na chibi'aj cormorán, tu yi junt jilwutz yi na chibi'aj ibis, ");
INSERT INTO aguBl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","tu yi junt jilwutz yi na chibi'aj cisne yi nim tkan quikan, tu yi junt jilwutz yi na chibi'aj pelícano, tu yi e'chk jilwutz joj, ");
INSERT INTO aguBl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","tu yi e' cigueña, nin cyakil yi e'chk jilwutz garza yi at, tu yi junt jilwutz yi na bi'aj abubilla, tu yi sotz'. ");
INSERT INTO aguBl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","”Ncha'tz yi e' tal ne'ẍ txuc yi qui tunin ilwutz e', yi na chixicy'in, nin yi at cyaj quikan, chin xan nin kol baj yi jun jilwutz txuca'tz ita'n. ");
INSERT INTO aguBl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Poro txo'l yi tal txuca'tz, at e' yi na chitz'itpun, nin je yi e'chk jilwutze'j yi ba'n lbaj ita'n: ");
INSERT INTO aguBl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ba'n lbaj tircu'n yi e'chk jilwutz sac' ita'n, tu e'chk jilwutz tzu' yi na chixicy'in, tu yi tal sac' yi qui tunin ilwutz e'. ");
INSERT INTO aguBl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ma yi ko i'tz junt jilwutz ne'ẍ txuc, qui'c tzun cujtz tan baje'n ita'n, na chin xan nin kol baj ita'n. ");
INSERT INTO aguBl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","”Ma jalu', yi e'chk takle'ne'j yi swale' nin tzitetz, xcyek tan tocse'n lac'puj yi il c'ol tzite'j tane'n, kol cxom wok te'j: ”Alchok scyetz yil maque'n yi wankil jun scyeri txuca'tz yi quimnakt, tz'ocopon lac'p il c'ol te'j tane'n jalen cu'n yil cu' k'ej, kalena's tzun tz'oc junt tirtz tetz tajlal yi e' yi xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","”Alchok scyetz yil teke'n jun scyeri txuca'tz, tajwe'n cu'n tan xtx'ajol chan be'ch tetz na ja oc lac'p il c'ol te'j tane'n jalen cu'n yil cu' k'ej. Kalena's tzun tz'octz tetz xansa'nt junt tir. ");
INSERT INTO aguBl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","”Tircu'n yi e' txuc yi at chipac', poro yi nk'e'tz cob cuntu' elnak, nin yi qui na chiwoch' cob tir chiwa', xan kol baj ita'n. Nin alchok scyetz yil maque'n chiwankil yi txuca'tz yi quimnakt, tz'ocopon tetz jun yi ja oc lac'p il c'ol te'j tane'n, na at il c'ol tane'n te wankil yi txuca'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","”Nin te cyakil yi e' txuc yi at cyaj quikan, nin at chipac' yi jatxo'n tib, xan kol tz'oc jun tan macle'n chiwankil yi e' txuca'tz yi ja quim. Tz'ocopon tzun lac'p il c'ol te'j tane'n jale'n cu'n yil cu' k'ej. Kalena's tzun tz'el il c'ol te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Nin alchok scyetz yil tek nin wankil jun scyeri txuca'tz yi quimnakt, tajwe'n tan xtx'ajol yi be'ch tetz, na ja wi't oc lac'p il c'ol te'j tane'n. Jalen yil cu' k'ej, kalena's tzun tz'el il c'oltz te'j. Tajwe'n tz'el itxum tetz, yi tircu'n chiwankil e' txuca'tz, yi ẍchuc nchiquim, cya'n il c'ol cya'n tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","”Ma jalu', ẍchixo'l e' txuc yi yaka'n cu'n na chixon wuxtx'otx', at il c'ol scye'j tane'n, chi tane'n yi sak'aben, nin e' itx'ij, tu cyakil jilwutz txuc yi na chijutnin quib wuxtx'otx', ");
INSERT INTO aguBl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","chitane'n yi e' camaleón, tu yi e' lagart, tu yi e' ẍulu', tu junt jilwutz yi na chibi'aj salamanquesa. ");
INSERT INTO aguBl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","”Tircu'n yi e' jilwutz txuca'tz, yi na chijut nin chic'u'l wuxtx'otx', xan sbne' tetz itetz. Na alchok scyetz yil maque'n chiwankil yi txuca'tz yi quimnakt, tz'ocopon lac'p il c'ol te'j tane'n jale'n cu'n tz'oc akale'n. ");
INSERT INTO aguBl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","”Ncha'tz alchok scyeri e' txuca'tz yi quimnakt yil saj tx'akx tibaj alchok e'chk takle'n, chi tane'n tze', jun be'chok, jun tz'u'm, jun cstal, nka jun ma'cl tetz ak'un, tz'ocopon tetz xan kol kamac. Nin tajwe'n tan cwe'n xe a', jalen yil cu' k'ej, kalena's tzun xansij junt tir. ");
INSERT INTO aguBl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","”Alchok scyetz te yi txuca'tz yi quimnakt yil saj tx'akx tul alchok lak, nka ẍwok' yi tx'otx', tz'ocopon tircu'n yi at tul yi ẍwok'a'tz, tetz xan kol kamac. Tajwe'n tan tele'n jo'li'n, nin tajwe'n tan cwe'n paxi'n yi ẍwok'. ");
INSERT INTO aguBl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Yi kol cu' tz'it yi a' yi at tul yi ẍwok' yi qui xansa'nt, tibaj alchok jilwutz t'imbil, tircu'n yi t'imbil kalel nojcu'n yi a'a'tz tz'ocopon tetz xan, nin yi a' yi at tul yi ẍwok'a'tz, qui'c xac sbne', na xan yi ẍwok' kale atit cu'nt yi a'. ");
INSERT INTO aguBl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Alchok takle'nil kalel noj cu'nt yi chiwankil yi e' txuca'tz yi quimnakt, tz'ocopon tetz xan. Yi ko i'tz jun ẍchujil pam, nka jun chuj yi tal juy, tajwe'n yil cu' xitu'n. Na xan kol xcon junt tir ita'n. Ej nin cyakil yi xtxolbila'se'j tajwe'n tzitocsaj, na ya'stzun yi mero bintzi. ");
INSERT INTO aguBl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","”Poro te yi a' yi na mulk'in, nin yi a' yi at tul pila' tetz uc'a'bil, ilenin xansa'nt sbne', na ya'stzun na ele't tzaj yi itc'a', ntin cu'n yi e' wunak yi na chimaque'n chiwankil yi e' txuca'tz yi quimnake't, na cho'c tetz tajlal jun wunak yi ja oc lac'p il c'ol te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","”Yi kol cu' tx'akx chiwankil yi txuca'tz yi quimnakt txo'l e'chk ij, yi txant tan toque'n xtx'ople'n, ilenin xansa'nt sbne'. ");
INSERT INTO aguBl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ma jalu', yi ko ac'sa'nt yi ij, nka cho'n at ij tul a', nin lcu' tx'akxuj wankil yi txuca'tz tibaj, tz'ocopon tzun tetz xan. ");
INSERT INTO aguBl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","”Ej nin yi kol quim jun itawun tan ya'bil nka ẍchuc lquim qui'c itocbil tan bajse'n. Ej nin alchok scyetz yil maque'n yi wankil yi jun awuna'tz yi quimnakt tz'ocopon lac'p il c'ol te'j tane'n jalen cu'n yil cu' k'ej, kalena's tzun tz'oc junt tir tetz xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Nin alchok scyetz yil baj yi ẍchi'bel yi jun awuna'tz ta'n, tajwe'n cu'n tan xtx'ajol yi be'ch tetz, nin tz'ocopon lac'p il c'ol te'j jalen cu'n yil tz'oc akale'n. Ncha'tz yi jun yil tz'oc tan telsene'ltzaj wankil yi awuna'tz, tajwe'n tan xtx'ajol yi be'ch tetz, nin tz'ocopon lac'p il c'ol te'j jalen cu'n yil tz'oc akale'n. ");
INSERT INTO aguBl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","”Tircu'n jilwutz txuc yi tu na chijut nin tu' chiwankil wuxtx'otx', chin xan nin e', nin qui'c cuj tan baje'n chichi'bel ita'n. ");
INSERT INTO aguBl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","”Qui'c cuj tan baje'n jun txuc ita'n yi na jut nin c'u'l wuxtx'otx', mpe jun yi at cyaj tkan, nka at wi'nin tkan, qui'c cuj tan baje'n ita'n, na xan tetz itetz. ");
INSERT INTO aguBl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Qui bin tzitak' ama'l tan toque'n lac'p il c'ol tzite'j tan tu' bajse'n yi e' txuca'tz yi xan, yi e'a's yi na chijut nin tu' chiwankil wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Na yi in wetz in Jehová yi iRyosil, tajwe'n bin yil tzixansaj itib, na yi in wetz chin xan nin in. Qui bin tzipo'tzaj iwankil tan tu' jun txuc yi na jut nin c'u'l wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Na in iTaj Jehová, nin ja cxe'l wok tzaj wa'n jak' chica'wl e' aj Egipto, nin in iRyosil. Cha'stzun te tajwe'n tan ixansal itib, na yi in wetz chin xan nin in.” ");
INSERT INTO aguBl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ya'stzun yi e'chk xtxolbila'tz yi tajwe'n tan banle'n tane'n ẍchixo'l cyakil yi txuc yi ate' wuxtx'otx', nin ẍchixo'l yi e' yi na chixicy'in, nin ẍchixo'l yi e' yi cho'n ate' xe a', nin yi e' yi tu na chijut nin tu' chic'u'l wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Yi e'chk xtxolbila'tz i'tz tan tele'n itxum tetz yi na' scyetz txuquil yi xan nin na' scyetz e' yi nk'e'tz xan nin na' scyetz e' yi ba'n tzibajsaj, nin yi e' yi qui'c cuj tan ibajsal. ");
INSERT INTO aguBl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ej itzun bantz nintzun jilon tzaj junt tir Kataj Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Alaj scyetz cyakil yi e' atanum, yi axwok xonl Israel, yi xtxolbile'j: Yil tz'ul yos tu jun xna'n, nin ko i'tz jun tal xicy yi mitz'ij, nk'e'tz xansa'nt sbne' yi xna'n tetz juk k'ej. Ni'cu'n yi xtxolbile'j te yi na tzan te yi tiempil tetz xtx'ajo'n. ");
INSERT INTO aguBl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ej nin le wajxaki'n k'ej yi titz'le'nix yi ni', tajwe'n yil banlij circuncidar. ");
INSERT INTO aguBl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ej nin yi xtxu' yi ni' tajwe'n tan ẍch'iwal junaklaj tu ox k'ej tan xansal tib. Nin qui'c cuj tan macol jun takle'n yi xan, nin qui'c cuj tan topone'n le mantial tetz molbil ibaj, jalen cu'n yil tz'icy' yi cobox k'eja'tz yi na xcon tan xansal tib. ");
INSERT INTO aguBl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ej nin ko i'tz jun tal xun yi na itz'ij, qui xansa'nt yi xna'n sbne' tetz cyajlaj k'ej. Ni'cu'n yi xtxolbile'j tu yi na icy' yi tiemp tetz yi xtx'ajo'n. Nin tajwe'n yil ẍch'iw ox c'al tu kak k'ej tan xansal tib tan paj yi chich' yi mme'l twankil. ");
INSERT INTO aguBl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","”Ej, ma yil jepon tamp yi jun tiempa'tz tan xansal tib, qui'c na ban yi ko i'tz tampaj jun tal yi xicy, nka tan jun tal yi xun yi mmitz'ij, tajwe'n tan bene'n tcy'al tetz yi pale' jun tal ne'ẍ cne'r yi junixe't yob ta'n, tetz xtx'ixwatz yi spat-xok tircu'n wankil, nin jun plomẍ, nka jun xmucuy tan jale'n cuybil paj. Nin tajwe'n chopon yi xtx'ixwatza'tz ta'n stzi' cunin yi puertil yi pe'mil yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Nin yi pale' tz'ocopon tan suke'n nin yi oya'tz tzinwutz, nin tz'ocopon tan pate'n yi xtx'ixwatz tetz yi xna'n, nin tan yi xtxolbila'tz tzincuye' paj, nin tz'ocopon junt tir tetz xansa'nt,” stzun Ryos bantz tetz Moisés. Cyakil yi xtxolbila'tz i'tz jun ca'wl tetz jun xna'n yi na talaj jun tal, nin qui'c na ban ko i'tz jun xun, nka i'tz jun xicy. ");
INSERT INTO aguBl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ma na yi ko quil xcye' yi xna'n tan lok'che'n jun ne'ẍ cneru', ba'n chopon cob tal xmucuy ta'n, nka cob tal plomẍ yi mam. Jun xconk tetz xtx'ixwatz yi patu'n cu'n sbne', nin yi junt xconk tan ẍchojle'n yi til. Tz'ocopon tzun yi pale' tan banle'n yi munl swutz Ryos tan tele'n yi il c'ol te yi xna'n, nin tan xansal tib junt tir. ");
INSERT INTO aguBl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Ej, itzun bantz nin tzun jilon tzaj junt tir Kataj Ryos scyetz Moisés tu Aarón, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Alchok scyetz yi at jun ya'bil te'j, yi tx'a'c wutz tane'n, nka jun c'u' te wankil, yi ja ẍeẍax jun piẍ te wankil, ej nin yi lmaxe'n atit, tajwe'n yil tz'opon ticy'le'n swutz Aarón yi pale', nka swutz alchok scyeri yi cob cy'ajl i'. ");
INSERT INTO aguBl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Nin yil tz'ocopon swutz yi pale'a'tz, tajwe'n tan toque'n i'-tz tan tilwe'n yi tx'a'c yi at te yi yabi'ẍ. Ej nin ko nsken sakax yi xi' yi at tul jun tx'a'ca'tz, nin ko cu'nak t'ok, na elepont yi i'tz jun ya'bil yi xlac'at wutz. Stale' tzun yi pale' yi at il c'ol tej tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","”Ma ko sak yi tx'a'c nin ko qui cu'nak t'ok, nin ko nk'e'tz sak yi xi', ba'n tzun ltal yi pale' tetz yi yabi'ẍ yi tajwe'n tan cyaje'n cyen, xe tetz ca'l, tetz juk k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ej nin yi nsken wi't icy' yi juk k'eja'tz, stile' tzun yi pale' yi ẍe'n tane'n yi jun tx'a'ca'tz. Yi ko na til yi qui mben lo'on te wankil yi yabi'ẍ, nin iẍnin tane'ntz, tajwe'n tzun tan tlol junt tir yi pale' tetz yi yabi'ẍ tan cyaje'n cyen xe tetz ca'l, tetz jukt k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ej nin yi nsken wi't icy' yi jukt k'eja'tz, stile' tzun junt tir yi pale' yi mbi tane'nt nin yi tx'a'c. Nin kol til yi ja skej yi tx'a'c nin qui mben lo'on, stale' tzun yi pale'a'tz, yi qui nin mo'c lac'p il c'ol tane'n te'j jun wunaka'tz, na i'tz jun tu' tal ne'ẍ tx'a'c yi njal te'j. Poro tajwe'n tan xtx'ajol yi be'ch tetz tan xansal tib. ");
INSERT INTO aguBl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","”Ma ko ja ben lo'on yi jun tx'a'ca'tz te yi nsken quen wi't xansij, tajwe'n yil tz'opon junt tir swutz yi pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Nin yil til yi pale' yi nsken wi't ben lo'on yi jun male'na'tz te wankil yi yabi'ẍ, stale' i' yi ja oc lac'p il c'ol te'j tane'n. Nin stale' yi pale' yi ya'bil i'tz lepra. ");
INSERT INTO aguBl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","”Alchok scyetz yi at yi jun jilwutz tx'a'ca'tz te'j, tajwe'n tan topone'n tan chajo'n ib swutz yi pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Tz'ocopon tzun yi pale'a'tz tan tilwe'n yi ya'bil. Ej nin kol til, yi i'tz jun tx'a'c, yi ja wi't skojax yi xi'il, nin yi at pojil, na tzun elpont yi i'tz jun ya'bil yi quil tz'icy'. ");
INSERT INTO aguBl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Stale' tzun yi pale' yi nk'e'tz tajwe'n tan jople'n yi yabi'ẍ xe jun ca'l, na tech cu'n tib yi ja wi't oc lac'p il c'ol te'j tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","”Poro ko ja ben lo'on lajke'l yi ya'bil te tircu'n wankil yi yabi'ẍ, ");
INSERT INTO aguBl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","tz'ocopon tzun yi pale' tan tilwe'n, nin ko na til yi ja noj tircu'n wankil tan yi ya'bila'tz, tajwe'n tzun ltal yi pale' yi xansa'nt yi yabi'ẍ, na ja sakax cyakil yi wankil yi yabi'ẍ, xansa'nt tzun i'-tz, na qui'c il c'ol te'j tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Poro kol tz'opon jun k'ej yil jal tx'a'c te'j yi wankil yi juna'tz ja tzun oc il c'ol te'j tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Nin tajwe'n tz'oc yi pale' tan xmaye'n yi jun tx'a'ca'tz, tan tilol yi ko bintzi nin ja oc lac'p il c'ol te'j. Na yi jun tx'a'ca'tz ja xcye' tan c'ayse'n ẍchi'bel, nin lepra bi' yi jun ya'bila'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","”Ma yi kol je' tx'ixp wutz yi jun tx'a'ca'tz, nin yi ko ja wi't skej, tajwe'n tzun tz'opon i' tan ẍchajle'n tetz yi pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ba'n tzun tz'oc yi pale'a'tz tan tilwe'n yi ya'bil te'j yi yaj, nin ko ja skojax yi tx'a'c, tz'ocopon tzun yi pale' tan xanse'n yi jun yabi'ẍa'tz, nin tz'ocopon tetz tajlal yi e' yi xansa'nche't. ");
INSERT INTO aguBl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","”Ncha'tz alchok scyetz yil jal jun tx'a'c te wankil, nin yil tz'icy' tetz coboxt k'ej, ");
INSERT INTO aguBl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","nin kol ben mal yi mu'ẍa'tz kale icy'nakit yi jun tx'a'ca'tz, nin sak nin tu' sban, nka lbolbax yi jun piẍa'tz, tajwe'n tzun tz'oc yi pale'-tz tan tilwe'n ko nim il tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Nin yi kol til yi pale' yi ja wi't cu' xe' yi jun piẍa'tz swutz yi wankil, nin ko ja skojax yi xi' yi at-tz, stale' tzun yi pale' yi ja oc lac'p il c'ol te'j tane'n. Na tul yi tx'a'c yi at te'j ja lajluchax yi i'tz junt jilwutz tx'a'c tul, yi na bi'aj lepra. ");
INSERT INTO aguBl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Poro kol til yi pale' yi qui'c jun xi' yi ja skojax kale atit yi tx'a'c, nin ko qui cu'nak xe' yi jun piẍa'tz, ma na tzan skeje'n, ba'n tzun ltal yi pale' tetz yi yabi'ẍ tan jopol tib xe ca'l tetz juk k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ma ko wi'nin bene'n lo'on yi tx'a'c te tircu'n wankil yi juna'tz, stale' tzun yi pale' yi ja oc lac'p il c'ol te'j tane'n, na yi tx'a'ca'tz yi ja ben lo'on te yi wankil, i'tz lepra. ");
INSERT INTO aguBl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ma jalu', yi ko qui na ben lo'on yi jun piẍa'tz yi lo'nakt tan yi tx'a'c, na tzun elpont-tz yi skeje'n atit. Ej nin, stale' tzun yi pale' yi qui nin mo'c lac'p il c'ol tane'n te yi yabi'ẍ. ");
INSERT INTO aguBl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","”Ncha'tz, alchok scyetz yil tz'e' yi wankil, nin kol jal mu'ẍ manch tul yi tz'e'naka'tz yi ẍeẍ, nka yi sak yubel, ");
INSERT INTO aguBl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ba'n tzun tz'oc yi pale' tan xmaye'n. Ej nin ko ja sakax yi xi' yi at tul yi mancha'tz, nin ko ja cu' xe', na tzun elpont-tz yi i'tz lepra yi ja jal te yi tz'e'nak. Ej nin ko ya'tz, ba'n ltal yi pale' yi ja oc lac'p il c'ol tane'n te jun wunaka'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Poro kol til yi pale', yi qui nskojax yi xi' yi at tul yi mancha'tz, nin qui cu'nak xe' yi jun piẍa'tz, na elpont yi tzan skeje'n. Ba'n tzun ltal yi pale' tetz yi yabi'ẍ tan jopol tib xe ca'l tetz juk k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Nin yil tz'icy' yi juk k'eja'tz, ba'n xmay junt tir yi pale' yi ẍe'n tane'n nint yi yabi'ẍ. Nin ko nsken wi't ben lo'on yi mancha'tz te wankil, ba'n tal yi pale' yi ja oc lac'p il c'ol te'j tane'n, na yi tx'a'c yi at te'j i'tz lepra. ");
INSERT INTO aguBl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Poro ko qui mben lo'on yi tx'a'ca'tz, ma na tzan ticy'e'n, na tzun elpont yi ja ben mal tampaj yi ja tz'e'. Ba'n tzun tal yi pale' yi qui'c il c'ol te'j tane'n, na i'tz ticy'be'n tu' yi tz'e'nak. ");
INSERT INTO aguBl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","”Ma jalu', kol jal jun tx'a'c te wi' jun yaj, nka te wi' jun xna'n, nka te chipetx', ");
INSERT INTO aguBl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","tajwe'n tzun tz'oc yi pale' tan xmaye'n. Ej nin ko lajluch cu'n yi ja cu' t'ok, nin ko ja k'anix yi xi'il, nin ko ja cu' jol, ba'n tzun tal yi pale' yi at il c'ol te jun wunaka'tz tane'n, na yi tx'a'c yi at te wi', nka te petx', chin xo'wbil nin. ");
INSERT INTO aguBl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Poro kol til yi pale' yi i'tz jun tx'a'c yi xcy'akach, nin qui cu'nak t'ok, nin ko nk'e'tz k'an yi xi' yi at tul yi jun piẍa'tz, tajwe'n tzun tan jopol juk k'ej yi pale' yi jun wunaka'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ma le juki'n k'ej stile' yi pale' yi ẍe'n tane'nt nin yi tx'a'c te yi yabi'ẍ. Nin ko qui benak lo'on yi jun ya'bila'tz te wankil yi yabi'ẍ, nin ko qui'c xi' yi k'an yubel tul, nin ncha'tz ko qui cu'nak t'ok yi, ");
INSERT INTO aguBl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ba'n tzun tal yi pale'-tz tetz, tan tele'n yi xmatzi' ta'n, ma kale atit yi tx'a'c ba'n lcyaj tu'tz, nin tajwe'n jopxij jukt k'ej yi yabi'ẍ tan yi pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ma yil tz'icy' yi juk k'eja'tz, xmaye' tzun junt tir yi pale' yi jun ya'bila'tz yi ni'cu'n tu xcy'akach. Nin ko qui benak lo'on yi jun tx'a'ca'tz, nin ko lajluch cu'n yi qui ncu' t'ok, stale' tzun yi pale'-tz yi qui'c il c'ol te yi yabi'ẍ. Ncha'tz tajwe'n tz'oc yi yabi'ẍ tan xtx'ajle'n yi be'ch tetz. ");
INSERT INTO aguBl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Poro ko nsken wi't xansaj tib, ej nin kol jal junt tir yi jun tx'a'ca'tz te'j, nin lben lo'on te wankil, ");
INSERT INTO aguBl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","tajwe'n tzun tan xmayil junt tir yi pale' yi yabi'ẍa'tz. Nin ko ja nin ben lo'on yi jun tx'a'ca'tz, qui't tzun na taj joyle'n yi xi' ko k'an, nka qui', na lajluch cu'n yi at il c'ol te yi yabi'ẍ. ");
INSERT INTO aguBl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Poro ko qui't mben lo'on, nin ko ja k'ekax yi xi' tul, na elpont yi ja skej yi tx'a'ca'tz. Ej, ba'n tzun tal yi pale' tetz, yi qui'ct il c'ol te yi jun wunaka'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","”Ma jalu', yi kol tz'elu'l manch sak te'j jun yaj, nka te'j jun xna'n, ");
INSERT INTO aguBl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","tz'ocopon tzun yi pale' tan xmaye'n yi cye'j. Nin ko sak nin tu' tane'n yi mancha'tz, yil til yi pale', nin ko at e'chk piẍ yi xk'ayk'uj wutz, i'tz tu tzun jun ya'bil yi na jal te stz'umlil chiwankil, qui'c tzun il c'oltz te'j yi jun wunaka'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","”Ma kol cu' jol xi'il wi' jun yaj, nin qui'ct mu'ẍ xi'il wi' lcyaj cyen, qui'c il c'ol sbne' te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ncha'tz ko ntin lcu' jol yi xi'il wi' wutz plaj, qui'c na ban, na quil tz'oc il c'ol te'j, tampaj tu' yi na cu' jol xi'il wi'. ");
INSERT INTO aguBl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Poro je jun xtxolbile'j: Yi ko na lajluchax jun tx'a'c te wi' jun yaj yi sak ẍeẍ nin tu' wutz, kale cu'nakit jol yi xi'il wi', qui'c na ban ko swutz, nka wutz coc, na elpont yi i'tz yi tx'a'c tetz lepra yi tzan telmule'n te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Tajwe'n tzun tan tilol yi pale', nin ko sak ẍeẍ nin tu' wutz yi tx'a'ca'tz ni'cu'n chi yi ẍeẍal yi tx'a'c yi na jal te chiwankil, ");
INSERT INTO aguBl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","na tzun elpont-tz yi i'tz lepra yi at te'j, nin yi ja oc lac'p ilc'ol tane'n te'j. Nin tajwe'n tan tele'n stziblal tan yi pale' yi i'tz jun yaj yi at il c'ol te'j tane'n tan yi ya'bil. ");
INSERT INTO aguBl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","”Ej nin alchok scyetz yil jal yi tx'a'ca'tz te'j, tajwe'n xcon be'chok ta'n yi rit'u'nt, nin quil tew yi wi' tan xbu'k, ma na tajwe'n tan tewal yi ju' tu yi stzi' tan xbu'k, nin tajwe'n ẍch'in: ¡At il c'ol swe'j! ¡At il c'ol swe'j! ");
INSERT INTO aguBl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Nin te yi tiemp yi at yi tx'a'c te'j, at il c'ol te'j tane'n, nin qui xansa'nt yi jun wunaka'tz. Ncha'tz tajwe'n tan najewe'n ẍchuc, le jun tetz ca'l joylaj len yi ama'l kale najlche't yi e' mas wunak, ya'stzun sban na chin xlac'at wutz nin yi tx'a'c yi at te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","”Ma yi kol jal jun jilwutz tx'a'c te alchok be'chok, qui'c na ban ko i'tz nok', nka lino cu'n yi xbu'k, ");
INSERT INTO aguBl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","nka te wa' alchok xbu'k, nka te wa' yi xbu'k yi lino cu'n, nka te jun piẍ tz'u'm, nka te e'chk takle'n yi banij te tz'u'm, ");
INSERT INTO aguBl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","nin ko txa'x nin tu', nka ẍeẍ nin tu' yi manch yi at te e'chk takle'na'tz, qui'c na ban ko lino, nka nok' cu'n yi xbu'k, na tan tu' yi jun mancha'tz na elpont yi at ticy'be'n yi tx'a'c te'j. Nin tajwe'n cu'n tzun tan ẍchajle'n tetz yi pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Tz'ocopon tzun yi pale' tan tilwe'n yi jun takle'na'tz yi at manchil tx'a'c te'j, nin tajwe'n tan tewe'n yi e'chk takle'na'tz tetz juk k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ma yil jepon yi juk k'ej mben yi pale' tan tilwe'n yi manch. Nin yi ko ja ben lo'on te yi be'chok, nin ko ja noj txo'l yi wa' yi xbu'k, nka te alchok takle'nil chi tane'n e'chk takle'n yi na bnix te tz'u'm, yi ko ja ben lo'on na elpont yi i'tz jun jilwutz tx'a'c yi chin xo'wbil nin yi at il c'ol eka'n ta'n. ");
INSERT INTO aguBl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Tajwe'n tzuntz tan pate'n tircu'n yi e'chk takle'na'tz na chin xo'wbil nin yi ya'bila'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Ma jalu', yil til yi pale' le juki'n k'ej, ko qui mben lo'on yi manch te yi be'chok, nin qui mben lo'on te yi wa' yi xbu'k, nka qui mben lo'on te alchok takle'nil yi tz'u'm cu'n, ");
INSERT INTO aguBl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","stale' tzun yi pale'a'tz yi ntin na taj xtx'ajle'n junt tir, nin tajwe'n tan colche'n tetz jukt k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","”Ej nin te yi nsken wi't el tx'ajij yi manch, tz'ocopon yi pale' tan xmaye'n yi ko iẍnin tane'n yi manch te jun takle'na'tz. Ko na til yi pale' yi atit nin yi manch na tzun elpont yi i'tz jun manch yi cy'a'n il c'ol ta'n nin tajwe'n tan toque'n yi e'chk takle'na'tz wi k'ak', qui'c na ban yi ko ja ben lo'on nka qui'. Na i'tz jun ya'bil, nin qui'c na ban yi ko cho'n at tul nka solte'j. ");
INSERT INTO aguBl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Poro kol til yi pale' yi qui't lajluch yi ticy'le'n tampaj yi ja tx'ajxij, tajwe'n tzun tan tele'n c'aplu'n yi jun piẍa'tz te yi be'chok, nka te yi xbu'k. ");
INSERT INTO aguBl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Nin kol lajluchax junt tir te yi xbu'k, nka te yi wa' yi bu'y, nka te alchok takle'nil yi tz'u'm cu'n, yi tzan bene'n lo'on junt tir, tajwe'n tzuntz tan pate'n yi jun takle'na'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ma jalu', yi be'chok, nka yi xbu'k, nka alchok takle'nil yi tz'u'm cu'n, yi ntx'ajxij, tajwe'n tan xtx'ajxe'n junt tir, tan skojaxe'n cunin.” ");
INSERT INTO aguBl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ya'stzun yi e'chk ca'wla'tz te yi e'chk manchil tx'a'c yi na noj te wa' e'chk be'chok yi lino cu'n, nka yi nok' cu'n, nin te alchok takle'nil yi tz'u'm cu'n, tan lajluchaxe'n yi skoj cu'n, nin yi qui'ct il c'ol te'j tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ej itzun bantz nintzun jilon tzaj junt tir Kataj Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Je yi ca'wle'j yi tajwe'n tan bnol tane'n jun wunak yi at tx'a'c te'j, tan xansal tib: Tajwe'n tan topone'n yi wunaka'tz swutz yi pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Nin yi pale' cho'n tz'ocopon tan tilwe'n yi ya'bil yi wunaka'tz solte'je'l tzaj yi ama'l kale najlche't tircu'n wunak, nin kol til yi pale' yi tzan skeje'n yi tx'a'c te'j, ");
INSERT INTO aguBl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","stale' tzun yi pale'-tz yi tajwe'n tcy'ajnin yi yabi'ẍ cob tal ch'u'l yi itz', tan xcone'n tan xanse'n, nin yi qui'c mu'ẍ tal chiyana'sil. Ncha'tz tajwe'n tcy'aj nin jun piẍ jilwutz tze' yi na bi'aj cedro, tu jun tal piẍ xbu'k yi cyak te'j tu jun tal k'ab hisopo. ");
INSERT INTO aguBl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Nin scawunk yi pale' tan biyle'n cu'n jun scyeri cob tal ch'u'la'tz, tibaj jun xaru' yi tx'otx' cu'n, yi at a' tul yi cho'n na el tzaj te jun bo'm a'. ");
INSERT INTO aguBl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ma yi junt tal ch'u'l, tu yi jun piẍ cedro, tu yi jun piẍ xbu'k yi cyak, tu yi jun tal k'ab hisopo, copon tzun mu'ul cyakil tu yi tal ch'u'l itz'enle'n, tul yi ẍch'el yi jun tal ch'u'l yi ja quim, tibaj yi a' yi at tul yi ẍwok'. ");
INSERT INTO aguBl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ma yi nsken wi't bnix yi xtxolbile'j, mben tzun tz'itu'n juk tir yi chich'a'tz te'j yi jun yi na tzan xanse'n, kalena's tzun tz'el yi il c'ol yi at te'j tane'n. Nin yi jun tal ch'u'la'tz, yi qui nquim, tz'elpon tzakpu'n. ");
INSERT INTO aguBl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","”Ncha'tz yi jun yi na xansaj tib tajwe'n tan banle'n yi xtxolbile'j: Tajwe'n tan xtx'ajol yi be'ch tetz, nin tajwe'n tan jichine'n, nin tajwe'n tan tele'n tircu'n yi xi' yi at te'j. Tan yi xtxolbila'se'j, na tzun xansaj tibtz. Ba'n tzun lnajantz ẍchixo'l yi e' mas wunak yi ate' tul yi ama'l kale najlche't, poro tajwe'n yi quil tz'oc chan xe yi tetz mantial, jalen yi nsken wi't el juk k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ma le juki'n k'ej, tajwe'n tan tele'n junt tir tircu'n yi xi'il yi at te wankil, yi xi'il wi', tuml tircu'n yi xmatzi', tuml tircu'n yi xwatz. Nin tajwe'n tan xtx'ajol tircu'n be'ch tetz, nin tajwe'n tan jichine'n, ya'stzun sbne'-tz tan xansal tib. ");
INSERT INTO aguBl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ma le wajxaki'n k'ej, ba'n chopon cob ne'ẍ cne'r ta'n yi mam, yi qui'c mu'ẍ tal chiyana'sil, yi inak nin jun yob cya'n. Ncha'tz ban tz'opon junt tal ne'ẍ cne'r ta'n yi tij yi ja tz'ak jun yob, nin yi qui'c mu'ẍ tal yana'sil. Ncha'tz tajwe'n tz'opon kak liwr te yi chumbalaj jarin, tetz jun oy yi ixi'n triw cu'n yi yuju'n tib tu aceitil oliw, nin ncha'tz yi toxe'n part te jun litr aceitil oliw. ");
INSERT INTO aguBl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Yi pale' tajwe'n tcy'aj nin yi jun wunaka'tz yi sxanse' tib, stzi' cunin puertil yi mantial tetz molbil ibaj, tu yi e'chk takle'n yi ja wi't a'lchij. ");
INSERT INTO aguBl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Nin stoye' jun scyeri cob cne'ra'tz swutz Ryos, chi jun oy tan jale'n cuybil paj yi jun wunaka'tz, tuml jun was aceit. ");
INSERT INTO aguBl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Cho'n tzun tz'ocopon jak' kul yi jun cne'ra'tz ta'n le yi ama'l yi xansa'nt kale na chibiyxe't yi e' tx'ixwatz tan xtx'ajle'n il nin yi e' tx'ixwatz yi patu'n cu'n na u'lij chiwankil. Yi e'chk tx'ixwatz tan ẍchojle'n il tu yi e'chk tx'ixwatz tan xtx'ajle'n il, tetz yi pale' sbne', na wi'nin xanil yi e'chk oya'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","”Ej nin ncha'tz jepon tcy'al yi pale' mu'ẍ te yi ẍch'el yi tx'ixwatza'tz, nin tz'ocopon suk'ul te jalajt ẍchin yi at le sbal yi jun yi na xansaj tib. Tz'ocopon te yi jun piẍil yi ẍchin yi chi'baj cu'n. Ncha'tz tajwe'n tz'oc suk'ul te yi mamil wi k'ab yi at le sbal, nin te yi mamil wi tkan yi at le sbal. ");
INSERT INTO aguBl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Ej, nin ite'n nin sbne' yi pale' te yi aceit. Copon kojol mu'ẍ le k'ab yi max. ");
INSERT INTO aguBl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Nin copon mu'ul yi wi k'ab yi sbal tul yi aceita'tz yi cy'a'n ta'n le k'ab, nin mben stz'itul juk tir swutz Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Nin yi sowril yi aceita'tz, cho'n tz'ocopon tk'ol te yi tal ẍchi'belil yi ẍchin yi sbal yi juna'tz yi na xansaj tib, nin te mamil wi k'ab yi sbal, nin ncha'tz te mamil wi tkan yi sbal, tibaj yi ama'l kale moque't suk'ij yi ẍch'el yi tx'ixwatz yi na xcon tan jale'n cuybil paj. ");
INSERT INTO aguBl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Nin yi sowril yi aceit yi at le k'ab yi pale', cho'n tzun jepon kojoltz twi' yi jun yi na xansaj tib. Nin tan yi xtxolbila's, ja tzun el yi juna'tz tk'ab yi til. ");
INSERT INTO aguBl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ma yi nsken wi't bajij yi xtxolbile'j, tz'ocopon tzun yi pale'-tz tan pate'n xtx'ixwatz yi juna'tz tan jale'n cuybil paj tan til. Ej kalena's tzun tz'oc jak' kul yi tx'ixwatz yi spat-xok tircu'n wankil. ");
INSERT INTO aguBl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Nin tz'ocopon yi pale' tan toye'n yi tx'ixwatza'tz, tu yi jun oy yi ixi'n triw cu'n wi altar. Nin tan yi xtxolbila's, scuye' Kataj Ryos paj yi jun wunaka'tz, nin sxansok. ");
INSERT INTO aguBl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","”Ma jalu', yi ko i'tz jun tal prow me'ba' yi yabi'ẍ, yi qui'c pu'k tan lok'che'n e'chk jilwutz tx'ixwatz yi ja wi't kil, tajwe'n tzun tan bene'n tcy'al jun tal ne'ẍ cne'r tetz xtx'ixwatz tan jale'n cuybil paj, chi jun oy yi na je' suki'n tetz Kataj Ryos, nin chi jun oy yi na pat-xij, tetz xel i' swutz Kataj, tu kak liwr yi jarin yi co'si'nt tu aceit, tetz jun oy yi ixi'n triw cu'n, tu ox was aceitil oliw, ");
INSERT INTO aguBl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","tu cob tal xmucuy, nka cob tal plomẍ yi mam. Xom quen tu' te yi nicy'na' cu'n walor yi jun yabi'ẍa'tz tan lok'che'n. Jun scyeri cob tal txuca'tz tz'ocopon tetz oy tan jale'n cuybil paj, nin yi junt patu'n cu'n sbne'. ");
INSERT INTO aguBl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Nin le waxaki'n k'ej tajwe'n tz'opon yi e'chk takle'na'tz ta'n, stzi' cunin puertil yi pe'mil yi mantial tetz molbil ibaj, kale atit Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Nin yi pale' mben tcy'al yi tal ne'ẍ cne'r tetz yi tx'ixwatz, tan jale'n cuybil paj yi yabi'ẍ, tu jun was aceit, nin tz'ocopon tan suke'n nin yi oya'tz swutz Kataj Ryos, na i'tz jun oy yi apart swutz yi oy yi na cyoy yi e' mas yi at chipu'k. ");
INSERT INTO aguBl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Nin tz'ocopon tzun jak' kul yi jun cne'ra'tz tan yi pale', nin jepon tcy'al mu'ẍ te ẍch'el nin tz'ocopon suk'ultz te yi ẍchi'belil yi ẍchin yi juna'tz yi na xansaj tib. Nin tz'ocopon suk'ul te mamil wi tkan yi sbal, nin ncha'tz te mamil wi k'ab yi sbal. ");
INSERT INTO aguBl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Nin jepon tcy'al yi pale' mu'ẍ te yi aceit, le k'ab yi max, ");
INSERT INTO aguBl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","nin copon mu'ul yi wi k'ab yi sbal tul yi aceit yi at le junt k'ab, nin tz'ocopon tan stz'ite'n nin juk tir swutz tkan Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Nin te ite'n nin aceit yi at le k'ab, tz'ocopon suk'ul mu'ẍ te yi tal ẍchi'belil yi ẍchin yi yabi'ẍ yi sbal, nin tz'ocopon suk'ul te yi mamil wi k'ab yi sbal, nin ncha'tz te yi mamil wi tkan yi sbal, tibaj yi ama'l kale atit yi ẍch'el yi tx'ixwatz yi na cu' biyij tan jale'n cuybil paj yi yabi'ẍ. ");
INSERT INTO aguBl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Nin yi sowril yi aceit yi at le k'ab yi pale', cho'n jepon kojol twi' yi jun yi na xansaj tib, bantz stzaje'n yi til tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ncha'tz, suke' jun scye yi cob tal xmucuy, nka jun scye yi cob tal plomẍ yi mam, qui'c na ban yi ko i'tz plomẍ nka xmucuy, ma na cho'n na xom te yi nicy'na' cu'n walor yi jun tal prow me'ba'a'tz tan lok'che'n. ");
INSERT INTO aguBl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Nin te yi xtx'ixwatz yil tz'ul ta'n, jun tzun stz'oyloktz tetz xtx'ixwatz tan jale'n cuybil paj, nin yi junt spat-xok tetz xel i' tan yi til, nin tajwe'n tan toye'n jun oy yi ixi'n triw cu'n. Tan yi xtxolbila's tzincuye' paj yi juna'tz, nin tz'ocopon tetz jun wunak yi xansa'nt.” ");
INSERT INTO aguBl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ya'stzun yi e'chk ca'wla'tz scyetz yi e' wunak yi na ul yos scyuch' tan yi jun jilwutz tx'a'c yi chin xlac'at wutz nin, nin yi pentu' na jal puntil jamel yi chitx'ixwatz cya'n. ");
INSERT INTO aguBl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Ej, nin tzun jilon tzaj Kataj Ryostz tetz Moisés nin tetz Aarón, itzun saj tloltz scyetz: ");
INSERT INTO aguBl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Yil cxo'c wok tul yi ama'l yi na bi'aj Canaán, yi ja wi't wak' tzitetz, nin kol wak' ama'l tan jale'n manch, nka xpitak' swutzak xanil jun ca'l, ");
INSERT INTO aguBl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","tajwe'n yil ben yi taw yi ca'la'tz tan talche'n stziblal tetz yi pale', nin je yol i'e'j sbne': ‘At jun takle'n chi tane'n manch ja jal xe innajbil.’ ");
INSERT INTO aguBl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","”Mben tzun mantar yi pale'-tz tan talche'n yi che'lken tircu'n yi e'chk takle'n yi at xe ca'la'tz, te ntaxk opon tan tilwe'n, bantz quil noj yi ya'bil te yi e'chk takle'na'tz yi at xe ca'la'tz. Tz'ocopon tzun yi pale'-tz tan tilwe'n yi manch. ");
INSERT INTO aguBl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","”Ej nin ko lajluch cu'n yi at manch yi icu'n txa'x, nka chin ẍeẍ nin tane'n wutzak yi ca'l, nin yi ja oc tc'u'l yi xan ta'n, ");
INSERT INTO aguBl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","tajwe'n tzun tan tele'n tzaj yi pale'-tz, nin slame' yi ca'l tetz juk k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Nin le juki'n k'ej spakxok yi pale' tan xmaye'nt yi ca'l, nin kol til yi ja ben lo'on yi manch swutzk yi tapijil, ");
INSERT INTO aguBl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","mben tzun mantar yi pale'-tz tan bale'n ne'l tzaj yi e'chk c'ub kale atit yi manch, nin tajwe'n tan tele'n c'oxij joylaj len yi tnum, le jun ama'l yi qui xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Nin ncha'tz tajwe'n tan tele'n kichu'n tircu'n wutzak tapijil yi ca'l, nin yi puklajil tajwe'n tan tele'n kojij joylajlen yi tnum, le jun ama'l yi qui xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Nin mben tcy'al yi pale' jun tx'akajt c'ub nin copon ta'n kale elnakit ticy'le'n yi jun tx'akaj yi ja el c'oxij. Nin tz'ocopon ac'aj xk'ol cya'n swutzak tapijil yi ca'l. ");
INSERT INTO aguBl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","”Nin kol jal junt tir yi manch swutz yi ca'l, te nsken wi't banlij ba'n tetz, ");
INSERT INTO aguBl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","tz'opon tzun junt tir yi pale' tan tilwe'n. Nin ko ja ben lo'on junt tir yi manch swutz yi ca'l, na tzun elpont-tz yi i'tz jun jilwutz manch yi cy'a'n quimichil ta'n. Nin tan yi xtxolbile'j na elpont yi at il c'ol te yi ca'l. ");
INSERT INTO aguBl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Tajwe'n cunin tzuntz tan cwe'n woq'ue'n yi ca'l, nin tz'elpon quicy'al yi e'chk c'ub, tu yi e'chk ptzo'mil yi ca'l, tu cyakil yi puklajil, joylaj len yi tnum, tul jun ama'l yi qui xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Nin alchok scyetz yil tz'oc xe jun ca'la'tz te yi tiemp yi ja tal yi pale' tan lamxe'n, tz'ocopon il c'ol te'j tane'n, jale'n yil cu' k'ej kalena's tzun tz'octz tetz jun yi xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Nin alchok scyetz yi ja wit xe jun ca'la'tz, tajwe'n tan xtx'ajol yi be'ch tetz. Ncha'tz alchok scyetz yil wan tul, tajwe'n tan xtx'ajol yi be'ch tetz, tan tele'n yi il c'ol te yi be'ch tetz. ");
INSERT INTO aguBl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","”Poro kol tz'oc yi pale' tul, nin ltil yi qui nin mben lo'on yi manch xe ca'l swutz yi ac'aj xk'ol yi ja oc swutz xan, stale' tzun yi pale' yi qui'c ya'bil tul yi ca'l, na ja tzaj yi manch. ");
INSERT INTO aguBl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Nin tan xanse'n yi ca'l, tajwe'n tan cyopone'n ticy'le'n cob tal ch'u'l, nin jun piẍ jilwutz tze' yi na bi'aj cedro, tu jun tal piẍ xbu'k yi cyak te'j, nin jun tal k'ab hisopo. ");
INSERT INTO aguBl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Tz'ocopon tzun jak' kul jun scyeri cob tal ch'u'la'tz ta'n, tibaj jun xaru', yi tx'otx' cu'n, yi at a' tul yi chin skoj nin wutz yi cho'n na el tzaj te jun bo'm. ");
INSERT INTO aguBl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ncha'tz jepon tcy'al yi tze' yi na bi'aj cedro, tu yi jun tal k'ab hisopo, nin tu yi jun tal piẍ xbu'k yi cyak te'j, tuml yi junt tal ch'u'l yi itz', nin che' copon mu'ul tircu'n tul yi ẍch'el yi jun tal ch'u'l yi cho'n mpon kojxuj ẍch'el tul xaru'. Ej tz'ocopon tzuntz tan stz'ite'n nin yi chich'a'tz juk tir xe yi ca'l. ");
INSERT INTO aguBl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Sxansok tzun yi ca'ltz tan yi ẍch'el yi tal ch'u'l, tu yi a' yi chin skoj nin wutz, nin tan yi junt tal ch'u'l yi itz', nin tan yi xan tze' yi na bi'aj cedro, nin tan yi hisopo, tu yi xbu'k yi cyak te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ma yi nsken wi't bajij yi xtxolbila's, tz'elpon tzun stzakpul yi jun tal ch'u'l yi itz'e't, solte'j yi tnum. Nin tan yi xtxolbila'tz, ja tzun el yi il c'oltz te'j yi ca'l, nin ja skojax cyen.” ");
INSERT INTO aguBl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ya'stzun yi e'chk ca'wla'tz te alchok manchil tx'a'c, nka e'chk manch yi i'tz xcy'akach, ");
INSERT INTO aguBl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","nin te yi e'chk ya'bil yi na wan te e'chk be'chok, tu yi na jal swutzak xanil jun ca'l. ");
INSERT INTO aguBl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Nin te yi e'chk c'u' yi na jal te kawankil, nka e'chk ne'ẍ tx'a'c, nka e'chk xcy'akach yi sak nin tu' wutz. ");
INSERT INTO aguBl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Yi e'chk ca'wla'tz i'tz tan tele'n katxum tetz yi ko cy'a'n il c'ol ta'n, nka qui'. Ya'stzun yi e'chk ca'wla'tz yi tajwe'n lbajij tane'n ko na jal manchil jun ya'bil ske'j nka te jun kaca'l. ");
INSERT INTO aguBl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ej, nin tzun jilon tzaj junt tir Kataj Ryostz tetz Moisés tu Aarón, itzun saj tloltz scyetz: ");
INSERT INTO aguBl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Txolwok yi xtxolbile'j scyetz tircu'n yi e' itanum, nin tajwe'n tan quibital yi e' yaj, na alchok scyetz yi at jun ya'bil te yi ẍchi'ol qui xansa'nt sbne'. ");
INSERT INTO aguBl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Qui'c na ban ko na el poj nka qui', qui xansa'nt sbne'. ");
INSERT INTO aguBl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","”Alchok tx'achil kalel coyewe't yi juna'tz, nka alchok chemil kalel c'olewe't cu'n, tz'ocopon tetz jun takle'n yi at il c'ol te'j tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","”Nin ko at jun macone'n yi xtx'ach yi juna'tz, tajwe'n tan xtx'ajol yi tetz be'ch tetz, nin tajwe'n tan jichine'n, nin tz'ocopon tetz tajlal jun wunak yi qui xansa'nt, jalen cu'n yil cu' k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","”Nin kol c'ole' cu'n jun kale nc'olewe't yi yabi'ẍ, tajwe'n tzuntz tan xtx'ajol yi be'ch tetz, nin tajwe'n tan jichine'n, nin scyajk cyen tetz jun yi qui xansa'nt jalen cu'n yil cu' k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","”Alchok scyetz yil maque'n yi juna'tz yi yabi'ẍ, tajwe'n tan xtx'ajol yi be'ch tetz, nin tajwe'n tan jichine'n, nin tz'ocopon tetz tajlal jun wunak yi qui xansa'nt jalen cu'n yil cu' k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","”Nin alchok scyetz yi yabi'ẍ, nin stzub nin ta'al stzi' te'j junt yi qui'c il c'ol te'j, yi junta'tz, tajwe'n tan xtx'ajol yi be'ch tetz, nin tajwe'n tan jichine'n, nin tz'ocopon tetz tajlal jun wunak yi qui xansa'nt jalen cu'n yil cu' k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","”Alchok siyil chej kalel c'olewe't jun yabi'ẍ, tz'ocopon il c'ol te jun siya'tz ta'n. ");
INSERT INTO aguBl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","”Ej nin alchok scyetz yil maque'n alchok takle'n yi ja cyaj cyen tzak' yi yabi'ẍ, tz'ocopon tetz tajlal jun wunak yi qui xansa'nt jalen cu'n yil cu' k'ej. ”Nin alchok scyetz yil teke'n yi e'chk takle'na'tz, tajwe'n tan xtx'ajol yi be'ch tetz, nin ncha'tz i', tajwe'n tan jichine'n, nin tz'ocopon tetz tajlal jun wunak yi qui xansa'nt, jalen yil cu' k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","”Ncha'tz alchok scyetz yil mac jun yabi'ẍ yi at yi jun jilwutz ya'bila'tz te'j, ej nin ko qui na xtx'aj chan yi k'abtz tajwe'n tan xtx'ajol yi be'ch tetz, nin tajwe'n tan jichine'n, na ja wi't oc lac'p il c'ol te'j tane'n jalen yil cu' k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","”Ej nin kol maque'n yi yabi'ẍ jun xaru' yi tx'otx', tajwe'n tan cwe'n pok'lo'n. Nin ko i'tz jun ma'cl yi tze' cu'n tajwe'n yil tx'ajxij cunin. ");
INSERT INTO aguBl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","”Yi nsken ul yos tu yi yabi'ẍ, juk tzun k'ej sbne'-tz tan xansal tib. Ma yil jepon tamp yi juk k'eja'tz, tajwe'n tzun tan xtx'ajol yi be'ch tetz, nin tajwe'n tan jichine'n tul a' yi chin skoj nin wutz. Tan yi xtxolbile'j tz'ocopon tzuntz tetz jun wunak yi xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Nin le wajxaki'n k'ej, tajwe'n tan topone'n tcy'al cob tal xmucuy, nka cob tal plomẍ yi mam. Cho'n tzun tz'opontz tan tak'le'n tetz yi pale' stzi' cunin yi puertil yi mantial tetz molbil ibaj, tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Nin yi pale' tz'ocopon tan toye'n jun scyeri plomẍa'tz tzinwutz, tan jale'n cuybil paj yi yabi'ẍ. Ma yi junt spat-xok tircu'n, tan xanse'n yi yabi'ẍ tan yi ya'bil yi njal te yi ẍchi'ol. ");
INSERT INTO aguBl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","”Ko at jun yaj yil tz'el ta'al yi ẍchi'ol, tajwe'n tan jichine'n, nin tz'ocopon chi tajlal jun yaj yi qui xansa'nt, jalen cu'n yil cu' k'ej, kalena's na el yi il c'ol te'j tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","”Tircu'n yi e'chk be'chok, nka jun takle'n yi tz'u'm cu'n, kalel noje't yi ta'al yi ẍchi'ol jun yaj, chin tajwe'n cunin xtx'ajle'n, nin tz'ocopon tetz jun takle'n yi qui xansa'nt, jalen cu'n yil cu' k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","”Yi kol chiwitbej quib jun yaj tu jun xna'n, tajwe'n tan chitx'ajol quib, nin chocopon tetz cob wunak yi qui xansa'nche't, jalen cu'n yil cu' ke'j. ");
INSERT INTO aguBl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","”Yi na opon tiempil xtx'ajo'n jun xna'n, tz'ocopon tetz tajlal jun wunak yi qui xansa'nt, tetz juk k'ej. ”Ej nin alchok scyetz yil maque'n yi jun xna'na'tz, ncha'tz i' tz'ocopon tetz tajlal jun yi qui xansa'nt, jalen cu'n yil cu' k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","”Ej nin alchok takle'nil, nka tx'ach kalel coyewe't yi xna'na'tz te yi at tul jun tiempa'tz, tz'ocopon tetz jun takle'n yi qui xansa'nt. ”Ncha'tz alchok takle'n kalel c'olewe't, te yi tiempa'tz, tz'ocoponintz tetz jun takle'n yi qui xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","”Nin alchok scyetz yil maque'n yi ama'l, nka takle'n kale ncoyewe't yi xna'na'tz, tajwe'n tan jichine'n, nin tajwe'n tan xtx'ajol yi be'ch tetz, nin tz'ocopon tetz tajlal jun yi qui xansa'nt, jalen cu'n yil cu' ke'j. ");
INSERT INTO aguBl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","”Alchok scyetz yil maque'n jun takle'n kale nc'olewe't yi xna'na'tz, tajwe'n tan xtx'ajol yi be'ch tetz, nin tajwe'n tan jichine'n, nin tz'ocopon tetz tajlal jun wunak yi qui xansa'nt jalen cu'n yil cu' k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Qui'c na ban ko ja je' macol yi takle'n kale ncoyewe't, nka ja je' macol yi takle'n kale nc'olewe't yi xna'n, tz'ocoponintz tetz tajlal jun yi qui xansa'nt, jalen cu'n yil cu' ke'j. ");
INSERT INTO aguBl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","”Nin ko at jun yaj yil witbej tib tuch', tz'ocopon yi juna'tz tetz tajlal jun wunak yi qui xansa'nt, tetz juk k'ej, tuml yi ama'l kale ncoyewe't cu'n. ");
INSERT INTO aguBl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","”Ma jalu', yi ko na el ẍch'el jun xna'n, nin nk'e'tz tul yi tiemp tetz yi xtx'ajo'n, nin ltz'a'tij tetz ala' k'ej, nka yi tiemp tetz yi xtx'ajo'n ltz'icy' tibaj yi tetz tiempil nin, tz'ocopon tzuntz tetz tajlal jun wunak yi qui xansa'nt, te yi tiemp yi na el ẍch'el, nka te yi tiemp yi qui na makxij yi xtx'ajo'n, ni'cu'n xtxolbil tu yi cho'nk at tul yi tiempil yi xtx'ajo'n. ");
INSERT INTO aguBl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","”Alchok ama'lil kalel coyewe't yi juna'tz, yi yabi'ẍ, nin ncha'tz alchok ama'lil kalel c'olewe't cu'n te yi tiemp yi qui na makxij yi ya'bil, tz'ocopon tetz tajlal jun yi qui xansa'nt, ni'cu'n chi che'nk at tul yi tiempil yi xtx'ajo'n. ");
INSERT INTO aguBl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","”Nin alchok wunakil yil maque'n yi e'chk takle'na'tz, tz'ocopon tetz tajlal jun wunak yi qui xansa'nt. Ej nin tajwe'n tan xtx'ajol yi be'ch tetz yi at te'j, nin tajwe'n tan jichine'n, nin qui xansa'nt i' sbne' jalen cu'n yil cu' k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","”Nin yil makxij yi ya'bila'tz te alchok xna'n, tajwe'n tzuntz yil tz'oc te'j tajal yi tajwe'n tan ticy'e'n juk k'ej tan xansal tib. ");
INSERT INTO aguBl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ma le wajxaki'n k'ej, mben tcy'al cob tal xmucuy, nka cob tal plomẍ yi mam cu'n chicabil, tetz yi pale' stzi' cunin yi puertil yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Nin yi pale' stoye' jun, chi jun oy tan jale'n cuybil paj yi xna'n, nin yi junt oy, spat-xok tircu'n tetz xel yi xna'n tan yi ya'bil. Nin tan yi xtxolbila'tz, tzincuye' paj yi jun yabi'ẍa'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Tan yi xtxolbila'tz, chelpon tzun yi e' itanum ita'n swutz yi e'chk juchle'n ila'tz, bantz quil chiquim tan tu' yi na chitzan tan po'tze'n yi ama'l kale najlchine't.” ");
INSERT INTO aguBl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Yi e'chk ca'wla'tz, i'tz scyetz yi e' xna'n yi qui na makxij chitx'ajo'n, nin i'tz scyetz yi e' yaj yi na el ta'al yi chichi'ol, na na cho'c tetz tajlal jun wunak yi qui xansa'nt, tan yi e'chk xtxolbila'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Ncha'tz, i'tz scyetz yi e' xna'n, yi ate' tul yi tiempil yi chitx'ajo'n, nka tircu'n yi e' yi na el ta'al chiwankil, qui'c na ban ko i'tz jun xna'n, nko i'tz jun yaj. Ej nin i'tz scyetz yi e' yaj yi na chiwitbej quib tu quixkel yi at quen cunin tul tiempil yi xtx'ajo'n. ");
INSERT INTO aguBl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ej nin tzun jilon tzaj Kataj Ryos tetz Moisés, te yi nsken quen chiquim yi cob nitxajil Aarón, tampaj yi nim te'n cu'n cyocompone'n chiẍkansal quib swutz yi ama'l kale na a'te't Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Itzun saj tloltz tetz Moisés: “Alaj tetz yi awutzicy Aarón, yi quil tz'oc alchok tu' k'ejil tul yi ama'l yi wi'nin xanil yi at wutzcoc yi xbu'k, yi at tc'u'l yi mantial. Na qui na waj yil xcye' cu'n i' swutz yi jopbilil yi caẍa'a'tz, alchok tu' k'ejil, bantz qui quime'n, na cho'n na inchaj wib tibaj yi jopbilil yi caẍa'a'tz tul noc sbak' yi chin pak'puch nin. ");
INSERT INTO aguBl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Te yi ntaxk tz'oc Aarón le ama'l yi wi'nin xanil le mantial tetz molbil ibaj, tajwe'n tan toyil jun tal ne'ẍ tor yi mam tetz xtx'ixwatz i', bantz jakol cuybil paj i', nin ncha'tz tajwe'n tan toyil jun cne'r yi spat-xok tircu'n yi wankil. ");
INSERT INTO aguBl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Nin tajwe'n tan toque'n nin yi be'ch tetz te'j, yi chukpi'n nin tu', yi lino cu'n, tuml yi e'chk wex yi lino nintz, nin tz'ocopon tk'ol yi c'albil xe c'u'l, tu yi xbu'k yi na je' te'j wi'. Tircu'n yi be'choka'tz wi'nin xanil. Cha'stzun te tajwe'n tan jichine'n i' bajx. ");
INSERT INTO aguBl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","”Ncha'tz, tajwe'n tan bene'n tcy'al Aarón cob mam chiw, tan jale'n cuybil chipaj cyakil yi e' xonl Israel, tu jun cne'r tan pat-xe'n tircu'n wankil tetz chitx'ixwatz. ");
INSERT INTO aguBl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Stoye' tzun yi jun tal tora'tz swutz Kataj Ryos, tetz yi tetz xtx'ixwatz, tan jale'n cuybil paj i' tuml yi tetz najal. ");
INSERT INTO aguBl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Kalena's tzun che' tcy'aj nin yi cob chiw swutz Kataj Ryos, stzi' cunin puertil yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ej tz'ocopon tzuntz tan tx'ilu'n scye yi cob chiwa'tz, tan tilwe'n yi na' scyetz jun stz'oylok tetz Kataj Ryos, nin na' scyetz jun yi tetz Azazel sbne'. ");
INSERT INTO aguBl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Copon tzun biyol Aarón yi jun mam chiw yi i'tz tetz Kataj mban. Copon biyol i' tetz tx'ixwatz tan jale'n cuybil chipaj yi e' wunak. ");
INSERT INTO aguBl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ma yi junt mam chiw yi tetz Azazel sbne', tz'opon tzuntz swutz Kataj Ryos itz'enle'n. Kalena's tzun mben tzakpu'n le ama'l tz'inunin tu' tan tpone'n swutz Azazel. I' tzun tekan nin tircu'n quil yi e' wunak swutz Azazel, le ama'l tz'inunin tu'. ");
INSERT INTO aguBl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","”Ma yi tal ne'ẍ tor, tz'ocopon jak' kul tan Aarón tan quime'n tetz xel i', nin tan jale'n cuybil paj i' tuml yi e' tetz najal. ");
INSERT INTO aguBl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Mben tzuntz tan ticy'le'n jun patbil insens, yi nojnak cu'n tan xtxak'ak'il yi altar yi at swutz cunin Kataj Ryos, nin cob chi'm insens yi che'ja'nt, yi nternin na paxin c'o'cal. Cho'n tzun mben tcy'altz tc'u'l cyen yi ama'l yi wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Tz'ocopon tzun i'-tz tan pate'n yi insens swutz Kataj, na yi sibel yi insensa'tz xcyek tan tewe'n yi jopbilil yi caẍa' kale atit yi cob lepaj c'ub kale tz'ibane't yi lajuj ca'wl. Nin tan yi sibel yi insensa'tz quil xcye' tan tilwe'n yi jopbilil yi caẍa'a'tz, bantz qui quime'n i'. ");
INSERT INTO aguBl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ncha'tz jepon tcy'al mu'ẍ te ẍch'el yi jun ne'ẍ tora'tz, nin tan yi wi k'ab tz'ocopon tan stz'ite'n nin tibaj yi jopbilil yi caẍa'. Ncha'tz mben stz'itul juk tir yi chich'a'tz swutz cu'n yi caẍa'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Kalena's tzun sbiy cu'n yi chiw tetz chitx'ixwatz tircu'n yi e' wunak, nin mben tcy'al yi ẍch'el tc'u'l quen yi ama'l yi chin xan nin. Tz'ocopon tzuntz tan stz'ite'n nin yi chich'a'tz tibaj yi jopbilil yi caẍa' nin swutz cunin yi caẍa'a'tz. Ite'n nin puntila'tz stuleje' chi ntulej yi ẍch'el yi jun ne'ẍ tor. ");
INSERT INTO aguBl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Nin tan yi xtxolbila'tz xcyek yi chich' tan xansaje'n yi ama'l yi wi'nin xanil tan paj yi nk'e'tz xansa'nt yi e' wunak, nin tan paj cyakil yi il c'ol yi cy'a'n len cya'n. Ncha'tz ite'n xtxolbila'tz sbne' Aarón tan xansaje'n yi mantial tetz molbil ibaj yi cho'n cunin at nicy'al yi ama'l kale najlche't cyakil yi e' wunaka'tz, yi e' pajol ca'wl. ");
INSERT INTO aguBl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","”Te yi at Aarón tul yi ama'l yi wi'nin xanil tan jale'n cuybil paj, qui'c rmeril tan ta'te'n jun wunak tul yi mantial tetz molbil ibaj. Jalen cu'n yil tz'el tzaj i'. Ej nin yi nsken wi't jal cuybil paj i' tu yi tetz najal, nin tuml cyakil yi e' mas tanum, ");
INSERT INTO aguBl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","tz'elu'l tzuntz tan xanse'n yi altar yi at swutz Kataj. Jepon tcy'al mu'ẍ te ẍch'el yi jun tal ne'ẍ tor, tu mu'ẍ ẍch'el yi chiw, nin ch'on tzun tz'ocopon suk'ultz te'jak yi e'chk tuc' yi at te yi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ej juk tzun tir mben stz'itul yi chich'a'tz wi altar tan wik'ab. Nin tan yi xtxolbila'tz, xansok yi altar tk'ab yi il c'ol yi at cyak'un wunak. ");
INSERT INTO aguBl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","”Ma yil xcye' Aarón tan xanse'n yi ama'l yi wi'nin xanil, tu cyakil yi mantial tetz molbil ibaj, nin tu yi altar, mben tzun mantartz tan ticy'le'n tzaj yi junt chiw yi itz'e't. ");
INSERT INTO aguBl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Jepon tzun tk'ol k'abtz twi' yi jun chiwa'tz, nin tz'ocopon tan xtxole'n nin tircu'n yi quil, tu chipajpal yi e' xonl Israel. Nin tan yi xtxolbile'j, yi chiw mben tekal tircu'n yi quil, nin apart junt wunak mben tan stzakpe'n tul yi ama'l yi tz'inunin tu'. ");
INSERT INTO aguBl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Nin yi na ben yi chiw joylaj, tul yi ama'l yi tz'inunin tu', na tek nin tircu'n yi quil tul e'chk ama'l yi tz'inunin tu'. ");
INSERT INTO aguBl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Te yi nsken wi't bajij yi xtxolbile'j, tz'ocopon tzun junt tir Aarón tul yi mantial tetz molbil ibaj, nin tz'elpon tcy'al yi be'ch tetz yi lino cu'n, yi oc tk'ol te'j bajx cunin tan toque'n tul yi ama'l yi wi'nin xanil, nin cho'n scyajk cyentz ta'n. ");
INSERT INTO aguBl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Nin ta'ste'nintz tul yi mantial tetz molbil ibaj, sjichink junt tir, nin te yi nsken wek tib, tz'elu'l tzuntz tan pate'n yi tetz xtx'ixwatz tuml yi chitx'ixwatz yi e' tanum, nin tan yi xtxolbila's scuylok tzun tetz pajtz, tuml chipaj tircu'n yi e' tanum, yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Yi ẍepu'il yi tx'ixwatz tan jale'n cuybil paj, cho'n na patij wi altar. ");
INSERT INTO aguBl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Nin yi jun yi mben tan stzakpe'n yi chiw tetz Azazel, tajwe'n tan xtx'ajol yi be'ch tetz yi at te'j, nin tajwe'n tan jichine'n, nin ba'n tzun tz'octzajtz le ama'l kale najlche't tircu'n yi e' mas wunak. ");
INSERT INTO aguBl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","”Yi jun tal ne'ẍ tor, tu yi jun chiw yi ja chiquim, tan quil yi e' wunak, nin yi chiẍch'el yi ja opon ticy'le'n le ama'l yi wi'nin xanil, tan jale'n cuybil chipaj, tajwe'n tan cyele'n ticy'le'n joylaj len yi ama'l kale najlche't. Ncha'tz yi chitz'uml, tu chichi'bel, tuml yi e'chk lasu' yi na el ẍchiwankil, tajwe'n tan pate'n cu'n joylaj len yi tnum. ");
INSERT INTO aguBl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Nin yi jun yi tz'ocopon tan pate'n yi e'chk takle'na'tz, tajwe'n tan xtx'ajol yi be'ch tetz, nin tajwe'n tan jichine'n yil baj wi' yi munl, at tzun rmeriltz tan toque'n tzaj le yi ama'l kale najlche't tircu'n yi e' wunak. ");
INSERT INTO aguBl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","”Ma yi xtxolbila'tz i'tz jun ca'wl tetz itetz, tetz cyakil tiemp: Te yi lajuj tajlal yi beluji'n xaw, tajwe'n yil tzijatx yi jun k'eja'tz tan muc'le'n we'j, nin quil cxak'uj te jun k'eja'tz, nin ite'n nin xtxolbila'tz sbne' scyetz e' awer nak yi najlche'-tz tzixo'l, ");
INSERT INTO aguBl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","na ya'stzun k'ejlal yil jal cuybil ipaj swutz Kataj Ryos. Nin cxelpon liwr tk'ab tircu'n yi e'chk itil. ");
INSERT INTO aguBl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Wi'nin xanil yi jun k'eja'tz sbne' tetz itetz, na i'tz jun k'ej tetz ujle'n, nin tajwe'n tzimuc' we'j. Nin i'tz jun ca'wl tetz cyakil tiemp. ");
INSERT INTO aguBl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Yi pale' yi ja je' sicy'ij, nin yi ja ak'lij yi ca'wl tetz tan cyaje'n cyen le luwar yi taj chi jun wi'tz pale', i' tz'ocopon tan banle'n e'chk munla'tz, bantz jale'n cuybil chipaj. Nin tajwe'n tan toque'n yi be'chok te'j, yi lino cu'n yi xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Ej nin xanse' yi ama'l yi wi'nin xanil, tu yi mantial tetz molbil ibaj, tu yi altar, nin sjalok cuybil chipaj yi e' pale' tan e'chk quil yi na chijuch, nin sjalok cuybil chipaj tircu'n yi wunak yi najlche'-tz. ");
INSERT INTO aguBl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","”Yi jun xtxolbila'tz, i'tz jun ca'wl tetz cyakil tiemp. Tajwe'n yi jun tir le jujun yob tziban tane'n e'chk munla'tz, tan jale'n cuybil chipaj tircu'n yi e' wunak, tan e'chk quil yi mbaj chijuchul.” Ej nin ya'tz nin tzun tulej Moiséstz, quib yi tal Kataj tetz. ");
INSERT INTO aguBl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Ej nin tzun jilon tzaj junt tir Kataj tetz Moisés, itzun saj tloltz: ");
INSERT INTO aguBl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Txolnin tetz Aarón nin scyetz yi e' nitxajil, nin scyetz cyakil yi e' mas itanum, yi xtxolbile'j: ");
INSERT INTO aguBl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","”Alchok scyetz tzitetz yil quim jun mam tor ta'n, nka jun ne'ẍ cne'r, nka jun chiw tetz xtx'ixwatz, ");
INSERT INTO aguBl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","nin ko quil tz'opon ta'n stzi' cunin puertil yi mantial tetz molbil ibaj tan ẍchajle'n chi jun oy, sjalok til ta'n na mme'l tu' kojxuj yi ẍch'el yi xtx'ixwatz, tajwe'n tzuntz tan tele'n laju'n tzixo'l wok tampaj. ");
INSERT INTO aguBl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Yi na elpont yi jun ca'wla'tz, i'tz yi cyawun yi nchiquim cyak'un sajle'n tul alchok ama'lil, tajwe'n tan cyoyil jalu' tetz Kataj Ryos, swutz yi mantial tetz molbil ibaj, ba'n tzun tz'oc yi pale'-tz tan toye'n tetz Kataj Ryos, tetz jun oy tetz tzatzin paz. ");
INSERT INTO aguBl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Nin yi pale' tz'ocopon tan kojle'n nin yi chich' wi altar, yi at swutz Kataj Ryos. Ej nin ncha'tz stzi' cunin puertil yi mantial tetz molbil ibaj, nin tz'ocopon tan pate'n yi ẍepu', chi jun oy yi wi'nin c'o'cal swutz Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Nin qui't lcyak' yi e'chk oya'tz scyetz yi e' espíritu cwent Bayba'n yi najlche' le ama'l yi tz'inunin tu', na tampaj yi jun ajtza'kla'tz ja ijuch itil swutz Kataj Ryos. Nin yi jun ca'wla'tz i'tz tetz cyakil tiemp, i'tz tetz itetz ax wok xonl Israel, nin ncha'tz scyetz yi e' initxa', sbne' opon tunintz. ");
INSERT INTO aguBl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","”Ncha'tz al nin scyetz yi e' atanum, nka scyetz alchok awer nakil, yi cho'n najlij tzixo'l, yi ko na taj lpat jun xtx'ixwatz, nka na taj ltoy junt jilwutz xtx'ixwatz, ");
INSERT INTO aguBl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","tajwe'n yi tz'opon ta'n stzi' cunin yi puertil yi mantial tetz molbil ibaj, tan toye'n tetz Kataj, nin ko quil xom te yi ca'wla's, tajwe'n tan tele'n laju'n tzixo'l wok. ");
INSERT INTO aguBl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","”Alchok scyetz tzitetz, nka jun awer nak yi cho'n najlij tzixo'l, yil baj ẍch'el alchok txuc ta'n, jun cu'n incontr sbne' te'j, nin tz'elpon cu'n wa'n swutz. ");
INSERT INTO aguBl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Na alchok scyetz yi na xon wuxtx'otx', itz' tan tu' yi chich' yi na xon le wankil, nin ja wak' tzitetz tan xcone'n ita'n wi altar, tetz ixel tan qui iquime'n tan yi e'chk itil yi na ijuch tzinwutz, na yi chich'a'tz yi na el kojxuj wi altar, ya'stzun na chojon tircu'n yi itil. ");
INSERT INTO aguBl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","”Cha'stzun te na walnin: Ax wok jun c'oloj xonl Israel, ncha'tz ax wok awer nak yi najlquix ẍchixo'l, qui'c cuj tan baje'n mu'ẍ tal chich' ita'n. ");
INSERT INTO aguBl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Cha'stzun te alchok scyetz tzitetz yil ben tan txuqui'n, nin yil sbiycu'n jun txuc, yi ba'n lbaj ta'n, tajwe'n tan tele'n tircu'n yi ẍch'el yi jun txuca'tz, nin tajwe'n tan cwe'n mukul, ");
INSERT INTO aguBl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","na tan yi chich'a'tz, ya'stzun na chixone't cyakil txuc wuxtx'otx'. Cha'stzun te na wal nin, yi qui'c cuj tan baje'n chich' ita'n, nin alchok scyetz yil bajse'n yi ẍch'el jun txuc, tajwe'n tan tele'n laju'n tzixo'l wok. ");
INSERT INTO aguBl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","”Ej nin alchok xonl Israel, nka awer nak, yil bajse'n jun txuc yi quimnakt, nka junt txuc mbiyon cu'n, tajwe'n tan xtx'ajol yi be'ch tetz yi at te'j, nin ncha'tz tajwe'n tan jichine'n, nin tz'ocopon i' tetz tajlal jun yi qui xansa'nt jalen cu'n yil cu' k'ej. Ej kalena's tzun tz'octz tetz tajlal jun yi xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Poro ko quil tz'oc tan xtx'ajle'n yi be'ch tetz, nin quil jichin, qui tzun ltzaj yi tila's yi njuch, nin i' nin ajpaj sbne'tz te'j sbne' opon tunintz.” ");
INSERT INTO aguBl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Ej nin tzun jilon tzaj junt tir Kataj Ryostz tetz Moisés, je tzun saj tlol i'-tze'j: ");
INSERT INTO aguBl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Txolnin yi e'chk xtxolbile'j scyetz yi e' atanum yi e' xonl Israel: Yi in wetz in iRyosil, nin in Ajcaw tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","”Quil cxom wok te cyajtza'kl yi e' aj Egipto, yi tnum kale ncxa'te't. ”Quil cxom wok te cyajtza'kl yi e' aj Canaán kalel cxopone't wa'n, nin quil cxom wok te yi e'chk chicxtumbr yi e' wunaka'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","”Xomen wok te e'chk inca'wl, nin ban wok tane'n. Na in iRyosil yi ca'wl itetz. ");
INSERT INTO aguBl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","”Ban wok bin tane'n e'chk inca'wl, tu e'chk ley yi ja bixe' wa'n. Nin alchok scyetz yil xom te'j, mben ẍkon tetz tiempa'tz. Na in yi Ryos yi itajcawil. ");
INSERT INTO aguBl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","”Qui'c cuj tan witbel tib jun yaj tu jun xna'n, ko cyajwutz quib. Banwok tane'n inca'wl na in iRyosil. ");
INSERT INTO aguBl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","”Quil tzitelsaj k'ej itaj, tan tu' yil tziwitbej itib tu itxu', na i'tz itxu' nin qui'c rmeril yil tziban yi jun ajtza'kla's. ");
INSERT INTO aguBl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","”Quil tzitelsaj k'ej itaj, tan tu' yil tziwitbej itib tu txkel. ");
INSERT INTO aguBl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","”Quil tziwitbej itib tu itanub, qui'c na ban ko i'tz me'l itaj, nka tal itxu', qui'c rmeril yil tziban jun ajtza'kla'tz. Ncha'tz qui'c na ban ko cho'n mmitz'ij te'j junt xna'n, qui'c cuj tan iwitbel itib tuch'. ");
INSERT INTO aguBl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","”Quil cyelsaju' chik'eju' squibil quibu', tan tu' yil chiwitbej quibu' tu chimamaju', qui'c na ban ko i'tz me'l chicy'ajlu', nka tal chime'lu'. Qui'c cuj tan chibnolu' jun ajtza'kla'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","”Quil tziwitbej itib tuch' yi tal yi txkel itaj, na ni'cu'n itaj tuch', nin i'tz itanub. Qui'c cuj tan ibnol jun ajtza'kla'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","”Quil tziwitbej itib tuch' yi tanub itaj, na ite'n nin ẍch'el itaja'tz cya'n ta'n. ");
INSERT INTO aguBl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","”Quil tziwitbej itib tuch' jun stzicy, nka titz'un itxu', na ite'n nin ẍch'el itxu'a'tz cy'a'n ta'n. ");
INSERT INTO aguBl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","”Quil tzitelsaj k'ej stzicy, nka titz'un itaj, tan tu' yil tziwitbej itib tuch' yi txkel, na ncha'tz yi xna'na'tz i'tz itxu' tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","”Quil tziwitbej itib tuch' itlib, na ya'stzun txkel icy'ajl, nin qui'c cuj tan ibnol jun ajtza'kla'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","”Quil tzitelsaj k'ej itzicy, nka ititz'un, tan tu' yil tziwitbej itib tu yi txkel. ");
INSERT INTO aguBl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","”Quil tziwitbej itib tu yi tal jun xna'n yi ja wi't chiwitbej quibu' tuch' nin ncha'tz quil tziwitbej itib tuch' yi mamaj yi jun xna'na'tz, qui'c na ban ko i'tz me'l yi tal, nka tal yi tal, qui'c cuj tan iwitbel itib tuch'. Yi jun ajtza'kla'tz chin juntlen nin, na junit len chiẍch'el tircu'n e' xna'na'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","”Quil tz'oc yi titz'un, nka stzicy inajal ita'n tetz itxkel, nin qui'c cuj tan iwitbel itib tuch' te itz'e't inajal, tan qui jale'n oyintzi' ẍchixo'l. ");
INSERT INTO aguBl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","”Quil tziwitbej itib tu jun xna'n, yi at cunin tul tiempil tetz yi tetz xtx'ajo'n. ");
INSERT INTO aguBl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","”Quil tziwitbej itib tuch' yi txkel jun awisin, tan qui itoque'n tetz tajlal jun yi qui xansa'nt, tan yi jun ajtza'kla'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","”Quil tzitak' nin jun initxa' tetz yi ryos yi na bi'aj Moloc. Qui tzitelsaj xtx'ix imbi' tan yi jun ajtza'kla'tz. Na yi in wetz in Jehová yi iRyosil. ");
INSERT INTO aguBl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","”Quil witbej tib jun yaj tu junt yaj, nka jun xna'n tu junt xna'n. Na chin tx'ixwil nin yi jun ajtza'kla'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","”Quil tzixconsaj itib tu jun txuc, tan qui ijuchul itil tan yi jun ajtza'kla'tz. Ncha'tz yi e' xna'n qui'c cu tan chixconsal quib tu jun txuc, na chin juntlen nin. ");
INSERT INTO aguBl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","”Quil tzijuch itil tan yi e'chk ajtza'kla'tz. Na tampaj yi e'chk xtxolbila'tz chelpon inlajul yi e'chk tnum tul yi ama'l kalel cxopone't wok wak'un. ");
INSERT INTO aguBl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ncha'tz ja jal til yi ama'l kale najlche't yi e' wunaka'tz tan chipaj. Poro ja wak' caws yi e'chk ama'la'tz, cha'stzun te ja che'l xit tircu'n yi e' wunaka'tz tul yi cyetz chi'ama'l. ");
INSERT INTO aguBl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ma jalu', ax wok jun c'oloj xonl Israel, scyuch' yi e' awer nak yi najlche' tzixo'l, nque'nwok il tan banle'n tane'n yi e'chk inca'wl tu e'chk inley yi ja bixe' wa'n, nin quil tziban yi e'chk ajtza'kla'tz, chi na chiban yi e' mas wunak, bantz qui tele'n itx'ix. ");
INSERT INTO aguBl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Na tircu'n yi e'chk ajtza'kla'tz, yi chin tx'ixwil nin, ya'stzun e' ban yi e' wunak yi najlche' tzaj tzone'j yi ntaxk cxu'l wok, nin tan chipaj ja oc tetz jun ama'l yi qui xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Qui bin cxom wok te cyetz cyajtza'kla'tz. Na ko ya'tz, cxelepon wok laju'n tan yi tx'otx', chi mbajij scye'j yi e' mal wunaka'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Alchok scyetz yil sban yi e'chk takle'na'se'j yi chin tx'ixwil nin, tajwe'n yil tz'el cu'n swutz. ");
INSERT INTO aguBl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Cha'stzun te nque'nwok il tan banle'n tane'n yi e'chk inca'wl, nin quil tziban yi e'chk takle'n yi chin tx'ixwil nin, yi bajijnak sajle'nix tunintz tul yi ama'la's, nin quil tzijuch itil tampaj. Na in iRyosil yi cawl itetz.” ");
INSERT INTO aguBl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ej nin tzun jilon tzaj junt tir Kataj tetz Moisés itzun saj tloltz: ");
INSERT INTO aguBl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Alaj yi xtxolbile'j scyetz yi e' atanum Israel: Nque'nwok tetz jun jilwutz wunak yi xansa'nt, na yi in wetz yi iRyosil, chin xan nin in, nin chin tz'aknak cunin in. ");
INSERT INTO aguBl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","”Ak'wok len k'ej itaj itxu'. ”Ncha'tz banwok tane'n e'chk k'ej tetz ujle'n yi txumijt wa'n. Na yi in wetz in iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","”Quil tzilok'wok wutz junt ryos, nin quil tziban junt ryos yi ch'ich' cu'n. Na yi in wetz in iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","”Yil cxopon tan toye'n yi oy yi na ẍchaj yi ja jal tzatzin paz skaxo'l, oyinwok sk'il cu'n, nin banwok yi e'chk xtxolbil yi na chintzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Yi itawun yil tzitoy, tajwe'n tan baje'n ita'n te ite'n nin k'eja'tz, nin ncha'tz ba'n lbaj le ca'pi'n k'ej, poro yi sowril yil cyaj tetz yi toxi'n k'ej, tajwe'n tan pat-xe'n. ");
INSERT INTO aguBl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Yi kol je' bajsa'n yi jun oya'tz le toxi'n k'ej, qui'c xac sbne' tzinwutz, nin quil chintzatzin te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Alchok scyetz yil bajse'n, sjalok til, nin stz'elk cu'n swutz, tampaj yi ja po'tzaj yi oy yi wi'nin k'ej tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","”Yil tz'opon k'ejlal yil je' yi icosech, quil tzisicy'e'n yi e'chk tal bakaj yi na cyaj cyen tx'akxuj, nin quil cxo'c tan xtxoye'n txo'lak yi stz'isil yi ja el quen. ");
INSERT INTO aguBl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ncha'tz quil cxo'c tan xtxoye'n wutz yi uva, nin quil tzisicy'e'n yi e'chk wutz yi na cyaj cyen tx'akxuj, cyajk tu'tz ita'n scyetz yi e' tal prow me'ba', nin scyetz yi e' awer nak. Na yi in wetz in iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","”Quil cxalk'ij. Ncha'tz quil tzijal jun wi itak', nin quil tzijop iwutz tzitibil itib. ");
INSERT INTO aguBl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","”Quil tzisuk jun iyol tan imbi', yi quil cxe'l cu'n te'j, na ko ya'tz tziban na tzun elpont-tz yi na cxtzan tan telse'n ink'ej. Na yi in wetz in Jehová iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","”Quil cxo'cwok tan oyintzi' tu junt, nin quil tzimajlen yi e'chk takle'n yi at tuch'. Nin chojwok chik'ej yi e' imos te ite'n nin k'eja'tz. Quil tzich'iw junt k'ej tan chichojle'n. ");
INSERT INTO aguBl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","”Quil cxo'c tan xbajtzije'n jun chcan wi'. ”Quil tzitak'wok cu'n e'chk takle'n le chibe' yi e' moyi'ẍ tan chije'n trimp te'j. Ma na chajwok ic'ulutxumil tzinwutz. Na yi in wetz in Jehová iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","”Yil cxo'c tan pujle'n xtisya', quil tzitak'e'n ik'ab twi' jun. Quil xom iwi' tan colche'n jun prow me'ba', yi ko i' nin aj paj, nin quil xom iwi' tan colche'n jun ric, yi ko i' nin aj paj. Nicy'nin tu' tzitulej ca'wbe'n cyetz alchok jilwutz wunak. ");
INSERT INTO aguBl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","”Quil cxo'c wok tan ẍchaq'ue'n yol ẍchixo'l yi e' itanum. ”Quil cxo'cwok tan biyle'n cu'n junt iwunakil. Na yi in wetz in Jehová iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","”Quil tzitawaj chi'ch c'u'lal tetz italma', te jun ititz'un, nka te jun itzicy. ”Ej nin ko na itil yi tajwe'n tan makle'n wutz jun iwisin, ba'n tzimak wutz. Quil cxom te yi tetz tajtza'kl, ko na tzan tan juchle'n til. ");
INSERT INTO aguBl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","”Quil tziticy'se' ic'u'l tzitibil itib, nin quil tzitawaj chi'ch c'u'lal scye'j yi e' itanum. Lok'wok chiwutz iwisin, na ni'cu'n axwok scyuch'. Na yi in wetz in Jehová iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","”Banwok tane'n yi e'chk inca'wl. ”Quil tzitak' ama'l tan chisakche'n yi itawun tu junt jilwutz txuc. ”Quil tziyuj cu'n junt jilwutz ij txo'l yi ij yi na itaw wok swutz itx'otx'. ”Quil tz'oc jun be'ch itetz tzite'j, ko banij tane'n tan cobox jilwutz nok'. ");
INSERT INTO aguBl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","”Yi ko at jun lwitbej tib tu jun xun esclaw yi i'tz tetz junt yaj, nin txe'n lok'xij yi jun xuna'tz tan tele'n liwr, yi juna'tz yi nwitbej tib tuch', tajwe'n tan ẍchojol yi paltil. Poro nk'e'tz sotzel chiwutz sbne', na yi jun xuna'tz atite't jak' cawl yi patrón. ");
INSERT INTO aguBl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Nin yi juna'tz yi nwitbej tib tu yi xun yi esclaw, tajwe'n tan toyil jun cne'r tzinwutz tan jale'n cuybil paj, nin tajwe'n tan bene'n tcy'al kale atit puertil yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Nin tan yi jun cne'ra'tz, tajwe'n tan jakol yi pale' cuybil paj yi jun yaja'tz swetz, nin tzincuye' paj. ");
INSERT INTO aguBl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","”Yil tzicambaj yi ama'l yi suki'nt wa'n tzitetz, yi na bi'aj Canaán, nin yil tzitawaj e'chk tze' yi na tak' lo'bajil, qui'c cuj tan cwe'n tzaj yi wutz ita'n, nin qui'c cuj tan baje'n yi wutz ita'n tetz ox yob. ");
INSERT INTO aguBl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ma le cyaji'n yob, tircu'n yi wutz yi e'chk tze'a'tz, xansok tzinwutz, nin tircu'n wunak ẍchimole' quib tan xanse'n yi e'chk lo'baj. ");
INSERT INTO aguBl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ma le o'i'n yob, ba'n tzun baj wutz yi e'chk tze'a'tz ita'n. Nin tan yi xtxolbila'tz yi tze' wi'nin wutz sbne' opon tunintz. Na yi in wetz in iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","”Quil tzibajsaj jun takle'n yi at ẍch'el. ”Quil cxo'cwok tan wutz mesi'n, nin quil tzijoy puntil tan tilwe'n yi mbi sbajok ek ca'p. ");
INSERT INTO aguBl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","”Quil tz'el xi'il iwi' ita'n yi junit setej sban, nin quil tz'el ju' ixmatzi' ita'n. ");
INSERT INTO aguBl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","”Quil tziq'uixpuj iwankil tampaj tu' yi na quim jun. Nin quil tz'oc jun itechl ita'n te iwankil. Na yi in wetz in Jehová iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","”Quil tzitelsaj k'ej ime'l, tan tu' yil tz'oc ita'n tetz jun wi'tz aj bnol tetz. Quil tzipo'tzaj itanum tan e'chk ajtza'kl yi chin xa'bil nin. ");
INSERT INTO aguBl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","”Banwok tane'n e'chk k'ej tetz ujle'n yi bixba'nt wa'n. Ak'wok k'ej yi mantial tetz molbil ibaj kale najlchine't. Na yi in wetz in iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","”Quil tzijak itajtza'kl scyetz yi e' alma', nin scyetz yi e' aj wutz mes. Quil tzijuch itil tan yi e'chk takle'na'tz. Na yi in wetz in iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","”Ak'wok chik'ej yi e' yi ja tijin chic'u'l, ba'n cxcye'e'n wok ẍchiwutz tan tak'le'n chik'ej. Chajwok ic'ulutxumil, tan imbi'. Na yi in wetz in Jehová iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","”Quil che' ibuch yi e' awer nak yi najlche' tzixo'lwok. ");
INSERT INTO aguBl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Chajwok lok' ib scyetz chi na ilok' itib itetz tzitibil itib. Lok'wok chiwutz, na ni' cu'n axwok scyuch', na ncha'tz ax itetz, ax awer nak banak Egipto. Banwok tane'n, na yi in wetz in iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","”Quil tziban tramp, te alchok jilwutz ma'lbil. ");
INSERT INTO aguBl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Tajwe'n xcon e'chk ma'lbil ita'n yi tz'aknak cu'n yi talal. Na in iRyosil, yi ncxe'lsan tzaj Egipto. ");
INSERT INTO aguBl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","”Ma jalu', banwok bin tane'n e'chk inca'wl, tu e'chk ley yi bixba'nt wa'n. Xomenwok te'j. Na yi in wetz in Jehová iRyosil, yi na chincawun tzite'j.” ");
INSERT INTO aguBl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Nin jilon tzaj junt tir Kataj Ryos tetz Moisés, itzun taltz tetz: ");
INSERT INTO aguBl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Txolnin yi xtxolbile'j scyetz yi e' atanum: Alchok wunakil yil toy jun nitxajil tetz yi ryos Moloc, qui'c na ban ko i'tz jun xonl Israel nka jun awer nak yi cho'n najlij tzixo'l wok, tajwe'n cu'n tan cwe'n biyij tan c'ub cyak'un yi e' nim juy. ");
INSERT INTO aguBl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Na yi in wetz, incontr sbne' te yi juna'tz, nin stz'elk cu'n wa'n swutz, na ja oc il c'ol ta'n te inca'l yi mantial tetz molbil ibaj, nin ja el k'ej imbi' ta'n tan tu' yi ja toy jun nitxajil tetz Moloc. ");
INSERT INTO aguBl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ma jalu', ko qui na chixom yi e' wunak te yi jun xtxolbila'tz nin ko quil quim yi jun wunaka'tz cya'n, ");
INSERT INTO aguBl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","in tzun contr sbne'-tz te juna'tz, tuml yi najal, nin stz'elk cu'n wa'n swutz, scyuch' yi e' yi ja chixom te'j tan juchle'n quil swutz Moloc. ");
INSERT INTO aguBl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ej nin ko cho'n tz'opon jun swutz jun aj wutz mes, tan yol scyetz alma', sjuche' til tampaj, nin in contr sbne'-tz te'j, nin stz'elk cu'n wa'n swutz. ");
INSERT INTO aguBl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","”Ma na ntin k'ukek ic'u'l swe'j, nque'nwok tetz tz'aknak cu'n, na yi in wetz in iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Xanswok itib tan ixome'n swe'j nin banwok tane'n e'chk inca'wl tetz cu'n italma'. Na in Jehová yi iRyosil yi ja no'c tan ixanse'n, nin tan ibixbaje'n tetz inxconsbe'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","”Alchok scyetz yil tz'oc tan chijisle'n yi e' taj xtxu', tajwe'n tan cwe'n biyij, na i' te'n aj paj te'j yil cu' biyij, na ja oc tan telse'n chik'ej yi e' taj xtxu'. ");
INSERT INTO aguBl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","”Yi ko at jun yaj lwitbej tib tu txkel junt, tajwe'n tan quime'n yi yaj tu yi xna'n na ja chijuch quil. ");
INSERT INTO aguBl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","”Ko at jun lwitbej tib tu txkel yi taj, na elpont yi na tzan tan telse'n k'ej yi taj. Nin tan yi xtxolbila'se'j, tajwe'n tan quime'n yi yaj, tu yi xna'n na ja chijuch quil, nin e' te'n aj paj te yil chicu' biyij. ");
INSERT INTO aguBl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","”Ko at jun lwitbej tib tu txkel yi cy'ajl, tajwe'n tan quime'n yi yaj tu yi xna'n, nin tajwe'n tan toque'n te cyajal yi ẍchiquimok, na e' te'n aj paj te yil chicu' biyij na yi jun ajtza'kla'tz chin tx'ixwil nin. ");
INSERT INTO aguBl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","”Ma jalu', kol witbej tib jun yaj te junt yaj, chi na witbej tib jun yaj tu jun xna'n, tajwe'n tan chiquime'n chicabil, na e' te'n ajpaj te yil chicu' biyij, na chin tx'ixwil nin yi jun xtxolbila'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","”Ko at jun ltok'bej tib tu jun xna'n, nin ltok'bej tib tu xtxu' yi jun xna'na'tz, na tzun tzantz tan po'tza'n ib, nin tajwe'n tan chipate'n cyoxlil, itz'enle'n, bantz quil jal junt tir yi takle'na'tz yi chin tx'ixwil nin tzixo'lwok. ");
INSERT INTO aguBl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","”Yi ko at jun yaj yil xcon jun txuc chi na xcon jun xna'n, tajwe'n tan cwe'n biyij. Nin tajwe'n tan cwe'n biyij yi txuc. ");
INSERT INTO aguBl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","”Ko at jun xna'n yil xcon jun txuc chi na xcon jun yaj, tajwe'n tan cwe'n biyij yi xna'n tu yi txuc. Na chipaj nin cyera'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","”Ko at jun ltok'bej tib tu jun tanub, qui'c na ban ko nk'e'tz junit chitaj chitxu', nin lchiwitbej quibtz, sotzel chiwutz sbne', na yi na witbej tib jun tu tanub i'tz jun xtxolbil yi chin tx'ixwil nin, nin e' te'n ajpaj sbne' te yil chicu' biyij. ");
INSERT INTO aguBl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","”Ko at jun lwitbej tib tu jun xna'n yi na tzan quen cunin tul tiempil yi xtx'ajo'n, na tzun tzantz tan telse'n k'ej yi xna'n, nin ncha'tz yi xna'n i' aj paj te'j, na ja cujij yi jun ajtza'kla'tz, nin tan yi xtxolbila'tz tajwe'n tan chicwe'n biyij. ");
INSERT INTO aguBl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","”Quil tziwitbej itib tu jun titz'un, nka stzicy itxu', nin ncha'tz tu jun titz'un, nka stzicy itaj, na e' te'n ixonl, nin ko ya'tz tziban tzichoje' itil. ");
INSERT INTO aguBl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","”Alchok scyetz yi na witbej tib tu txkel yi xibin yi xtxu', na el k'ej yi xibin yi xtxu' ta'n, nin chicabil jepon cyeklal yi quila'tz, nin quil jal jun chinitxa'. ");
INSERT INTO aguBl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","”Alchok scyetz yil majlen txkel yi titz'un, nka stzicy, na el k'ej yi titz'un, nka stzicy ta'n. Nin yi jun ajtza'kla'tz na tak' chi'ch c'u'lal, nin yi e'a'tz yil chijuch quil, quil jal chinitxa'. ");
INSERT INTO aguBl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","”Banwok bin tane'n e'chk inca'wl, tu e'chk inley yi bixba'nt wa'n, bantz quil cxe'lwok laju'n le yi tnum yi na chintzan tan iticy'le'n nin tul tetz inajbil. ");
INSERT INTO aguBl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Quil cxomwok te cyajtza'kl yi e' wunak yi chelpon inlajul swutz yi ama'la'tz. Na yi e'a'tz ja chiban yi e'chk yab ajtza'kla'tz yi chin juntlenin, cha'stzun te qui nin mintx'aj yi cyajtza'kl, nin chelpon inlajul swutz yi ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Jun cu'n swale' nin tzitetz, yi itetz sbne' yi jun ama'la'tz yi chum balaj nin. ”In iRyosil, yi ja cxje' intxa'ol ẍchixo'l yi e' mas jilwutz wunak. ");
INSERT INTO aguBl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Cha'stzun te tajwe'n tan tele'n itxum scyetz yi e' txuc yi xan tu yi e' yi nk'e'tz xan tan ibajsal nka tan imacol. Quil tzitelsaj ik'ej tan tu' yil tzibajsaj nka yil tzimac yi e' txuca'tz yi xan. ");
INSERT INTO aguBl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Yi ax itetz tajwe'n tan itoque'n tetz jun jilwutz wunak yi xansa'nt tzinwutz, na yi in wetz in Jehová, nin chin xan cunin in, nin ja cxje' intxajol ẍchixo'l tircu'n yi e' wunak yi ate' wuxtx'otx' tan itoque'n tetz intanum. ");
INSERT INTO aguBl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","”Alchok yaj nka alchok xna'n yi na chijoy puntil tan xcone'n jun aj wutz mes tetz chiyolol scyuch' alma', tajwe'n tan quime'n tan c'ub. Nin e' te'n aj paj te yil chicu' biyij,” stzun Ryos bantz. ");
INSERT INTO aguBl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Ej nintzun jilon tzaj junt tir Kataj Ryos tetz Moisés, tan talche'n yi xtxolbile'j: “Jilonin scyetz yi e' pale', yi e' xonl Aarón, nin alaj scyetz yi chijoye' puntil tan qui cyoque'n tetz tajlal jun yi qui xansa'nt, tan tu' yil chimac yi wankil jun chixonl yi ja quim. ");
INSERT INTO aguBl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Ma na ko i'tz jun chixonl chi tane'n chitxu', chitaj, chinitxa', nka jun quitz'un, ");
INSERT INTO aguBl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","nka jun cyanub yi qui ocnak chmil, nin yi cho'n najlij scyuch', ba'n tzun chimactz wankil yi alma'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Poro qui'c cuj tan chimacol jun alma' yi ko i'tz jun cyanub yi umnakt. ");
INSERT INTO aguBl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","”Qui'c cuj tan tele'n chijukul xi'il chiwi', nin qui'c cuj tan tele'n chixmatzi' cya'n, nin qui'c cuj tan q'uixpe'n chiwankil. ");
INSERT INTO aguBl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ma na tajwe'n yi cyak'o'nt quib tan chixcone'n swetz, nin yi quil tz'el k'ej imbi' cya'n na e' na cho'c tan pate'n e'chk tx'ixwatz tzinwutz, nin na cyoy yi pam yi wi'nin xanil swetz, cha'stzun te tajwe'n yil cho'c tetz tz'aknak cu'n. ");
INSERT INTO aguBl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","”Qui'c cuj tan tumewe'n jun pale' tu jun wi'tz bnol tetz, nka tu jun xun yi po'tza'nt, nka tu jun xna'n yi xma'lca'n, na yi e' pale'a'tz jatxij che' tan chixcone'n swetz. ");
INSERT INTO aguBl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Makaj bin chiwutz yi e' pale' te e'chk takle'na'tz, na e' na chopon tu yi e'chk oy tzinwutz. Nin chin skoj cu'n te cyalma' sbne' ẍchiwutz tircu'n yi e' wunak, na yi in wetz in iRyosil, nin chin tz'ak nak cunin in, nin in na cho'csan tetz tz'aknak cu'n. ");
INSERT INTO aguBl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","”Yi ko at jun xun yi me'l jun pale', yil telsaj k'ej stibil tib yil tz'oc tetz wi'tz bnol tetz, na el k'ej yi taj ta'n, nin tajwe'n tan stz'e'se'n itz'enle'n. ");
INSERT INTO aguBl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","”Ej nin yi wi'tz pale', at rmeril tan xconsal yi be'chok yi wi'nin xanil, na je'nak kojij yi aceit yi wi'nin xanil twi'. Cha'stzun te qui'c rmeril tan je'n ẍchitpul xi'il wi', nin qui'c rmeril tan cwe'n katzol yi be'ch tetz tan ẍchajle'n yi na bisun tan jun xonl yi na quim. ");
INSERT INTO aguBl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ncha'tz qui'c rmeril tan toque'n le jun ama'l kale atit jun alma', mpe ik yi taj, nka yi xtxu' yi ja quim, na qui'c rmeril tan toque'n yi wi'tz pale' tetz jun wunak yi qui xansa'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Qui'c rmeril tan tele'n tzaj le ama'l yi wi'nin xanil, kale najle't Ryos, tan toque'n tul jun ama'l kale atit jun alma', qui'c na ban ko i'tz yi taj nka yi xtxu', na ko ya'tz sban tz'elpon k'ej yi ama'l yi wi'nin xanil ta'n, na je'nak kojij yi aceit twi' yi na xcon tan xanse'n jun wi'tz pale'. Banwok bin tane'n yi inca'wl na in Jehová iRyosil. ");
INSERT INTO aguBl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","”Tajwe'n tan tumewe'n jun wi'tz pale' tu jun xun yi txe'n cu'n til jun yaj. ");
INSERT INTO aguBl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Na qui'c cuj tan tumewe'n tu jun xma'lca'n yi ja quim chmil, nka tu jun xna'n yi ja chipax tu chmil, nka tu jun xna'n yi po'tza'nt, nka tu jun xna'n yi wi'tz bnol tetz. Qui'c cuj tan tok'bel tib tu alchok tu' xna'nil, ma na tajwe'n tan tumewe'n tu jun xun yi txe'n cu'n til jun yaj, nin yi cho'n tz'el tzaj ta'n ẍchixo'l yi e' tetz xonl, yi e' xonl k'ajtzun Leví. ");
INSERT INTO aguBl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Yi e' wi'tz pale', tajwe'n tan chibnol tane'n yi e'chk xtxolbila'tz tan qui tele'n chik'ej yi e' chinitxa' cya'n ẍchixo'l chitanum, na yi in wetz, in nchixansan tan cyoque'n tetz tz'aknak cu'n.” ");
INSERT INTO aguBl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ej nin jilon tzaj junt tir Ryos tetz Moisés, tan talche'n yi xtxolbile'j: ");
INSERT INTO aguBl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Alaj tetz Aarón yi sbne' opon tunintz, qui'c rmeril tan toque'n jun tetz xonl yi at yana'sil, tan toye'n pam tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Yi xtxolbila'tz na elpont, yi alchok scyetz yi at jun yana'sil qui'c rmeril tan banle'n yi jun munla'tz. Qui'c rmeril tan chixcone'n tetz pale' yi e' moyi'ẍ, yi e' co'x, scyuch' yi e' yi at yana'sil yi ju', nka ko at yana'sil yi ẍchin, ");
INSERT INTO aguBl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","nka wak'xnakt yi tkan, nka yi k'ab, ");
INSERT INTO aguBl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","nka yi at muc'uxil wutz coc, nka yi qui nin ch'uy wutz tkan, nka yi muj nin tu' te'j wutz, nka yi xlac'at wutz yi xcy'akach yi at te'j, nka yi at tx'a'c te wankil, nka po'tnak yi chiquiwel. ");
INSERT INTO aguBl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Alchok scyetz scyeri e' xonl Aarón yi at jun te e'chk yana'sila'tz te'j, qui'c cuj tan toque'n tan banle'n jun munl swutz Ryos, yi patu'n na u'lij, nin qui'c cuj tan toque'n tan toye'n yi pam, na at yana'sil. ");
INSERT INTO aguBl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ba'n lbaj yi pam ta'n yi na oyij, nin ba'n lbaj yi e'chk takle'n ta'n yi wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Poro qui'c rmeril tan toque'n tc'u'l yi ama'l yi wi'nin xanil yi cho'n at tul yi mantial tetz molbil ibaj, nin qui'c cuj tan tocompone'n ẍkansal tib te yi altar yi at le wutzk'anil, bantz qui tele'n ke'j yi inca'l ta'n, tan yi tetz yana'sil. Na in yi iRyosil, yi mmak'on k'ej yi e'chk takle'na'tz.” ");
INSERT INTO aguBl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","I nin tzun yol Moisésa'tz bantz tetz Aarón, quib yi tal Ryos tetz, nin ncha'tz ite'n nin tala'tz scyetz yi e' nitxajil Aarón, nin scyetz cyakil yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Ej nintzun jilon tzaj junt tir Kataj Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Alaj tetz Aarón, nin scyetz yi e' xonl i', yi cwent cu'n chiban te e'chk takle'n yi wi'nin xanil yi na oylij swetz, tan qui tele'n k'ej imbi' cya'n, yi wi'nin xanil. Na in Jehová iRyosil. ");
INSERT INTO aguBl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","”Ej nin jalu', nin sbne' opon tunintz, alchok scyetz ẍchixo'l yi pale'a'tz yil tz'oc tan banle'n chimunl yi e' xonl Israel tzinwutz, tajwe'n tan xansal tib bajx cu'n. Ko quil sban tane'n yi inca'wle'j, tajwe'n tan tele'n laju'n tzixo'l wok. Qui'c cuj tan xcone'n. Na in Jehová, iRyosil. ");
INSERT INTO aguBl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","”Qui'c cuj tan baje'n e'chk takle'n yi wi'nin xanil, tan jun xonl Aarón yi ko at jun jilwutz tx'a'c te'j yi xlac'at wutz, nka yi na el poj te wankil, jalen cu'n yil xansaj tib. ”Alchok scyetz tzitetz yil maque'n jun alma', nka lmaque'n junt wunak yi ja el ta'al yi ẍchi'ol, ");
INSERT INTO aguBl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","nka alchok scyetz yil tz'oc quen tetz jun yi qui xansa'nt, tampaj yil maque'n jun txuc yi tu na jut nin tu' wankil wuxtx'otx', nka yil noj quen te jun wunak yi qui xansa'nt, ");
INSERT INTO aguBl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","tz'ocopon tzun tetz tajlal jun yi qui xansa'nt, jalen cu'n yil cu' k'ej, nin qui'c cuj tan baje'n e'chk takle'n ta'n yi wi'nin xanil, yi ko quil jichin te yi ntaxk oc tan bajse'n yi e'chk pama'tz yi wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Jalen cu'n yil cu' k'ej, kalena's tzun tz'octz tetz jun wunak yi xansa'nt swutz Ryos. Ej kalena's tzun at rmeriltz tan baje'n yi e'chk oy ta'n yi wi'nin xanil, na ya'stzun yi tetz wa'. ");
INSERT INTO aguBl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Qui'c cuj tan baje'n ẍchi'bel jun txuc ta'n yi quimnakt yi nnoj quen swutz, nin qui'c cuj tan baje'n yi ẍchi'bel jun txuc ta'n yi rit'ij cu'n tane'n tan jun smaron txuc, bantz quil tz'oc lac'p il c'ol te'j tan yi chi'baja'tz. Na in Jehová iRyosil. ");
INSERT INTO aguBl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","”Al nin scyetz tan cyoque'n tan banle'n tane'n e'chk inca'wl, nin quil chijuch quil tantu' yi quil chiban tane'n, bantz quil chiquim. Na in Jehová iRyosil, yi na chinxansan yi e' pale'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","”Yi ko at jun yi nk'e'tz pale', qui'c cuj tan baje'n yi e'chk takle'n yi wi'nin xanil ta'n. Qui'c na ban ko i'tz jun wunak yi ja opon tu yi pale' tan posari'n, nka yi aj ch'eyanl le najbil yi pale', qui'c cuj tan baje'n yi e'chk pama'tz ta'n yi wi'nin xanil. ");
INSERT INTO aguBl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","”Yi kol lok' yi pale' jun esclaw tan yi tetz pu'k, yi jun esclawa'tz ba'n lbaj yi e'chk takle'n ta'n yi wi'nin xanil. Ncha'tz yi e' yi cho'n nchitz'ij xe ca'l yi pale', ban chiwan te e'chk waja'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","”Yi ko at jun xun yi me'l jun pale' yi ja ume' te jun yi qui'c tocbil tetz pale', qui'c rmeril tan baje'n yi e'chk oya'tz ta'n yi na ak'lij scyetz yi e' pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Poro ko i'tz xma'lca'n, nka ja chipax tu chmil, nin qui'c tal, nin ja pakxij xe ca'l yi taj, ba'n wan te yi oy yi na ak'lij tetz yi taj. Poro qui'c rmeril tan wane'n junt yi nk'e'tz pale' te e'chk oya'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","”Yi ko at jun yi qui na til yi xanil yi e'chk takle'na'tz, nin ja baj ta'n, tajwe'n tan xtxumul xel, tuml junt to'i'n part te yi mbaj ta'n. ");
INSERT INTO aguBl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Poro yi e' pale' qui'c rmeril tan cyak'ol ama'l tan cyoque'n e' xonl Israel tan telse'n k'ej yi e'chk takle'na'tz yi wi'nin xanil, yi na oylij swetz, ");
INSERT INTO aguBl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","nin quil cyak' ama'l tan chijuchul quil, tan yil baj yi e'chk oya'tz cya'n. Na in yi Ryos, yi na ak'on chik'ej yi e' pale'.” ");
INSERT INTO aguBl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ej nintzun jilon tzaj junt tir Ryos tetz Moisés, itzun saj tloltz: ");
INSERT INTO aguBl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","19","“Jilonin tetz Aarón tuml yi e' cy'ajl, nin scyetz yi e' atanum, nin txolnin yi e'chk xtxolbile'j scyetz: Yi ko at jun scyeri e' kaxonl Israel, nka jun scyeri e' awer nak yi najlij skaxo'l yil toy jun xtx'ixwatz tetz Ryos tan pat-xe'n tircu'n wankil, tajwe'n yi i'tz jun txuc yi mam nin yi qui'c mu'ẍ tal yana'sil, bantz stzatzine'n Ryos te'j. Qui'c na ban ko i'tz tan tele'n k'ab te jun yol yi suki'nt ta'n swetz, nko i'tz jun oy yi tetz cu'n talma' na tak' tetz Ryos. Nin tajwe'n yi i'tz jun mam tor, nka i'tz jun tal mam cneru' yi junixe't yob, nka jun mam chiw. ");
INSERT INTO aguBl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Poro qui'c rmeril ko at chiyana'sil yi e' tawuna'tz, na quil c'u'lchij ko ya'tz quitane'n yil chopon tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","”Alchok scyetz yil tz'opon tan tak'le'n jun oy tetz tzatzin paz, qui'c na ban ko i'tz tan tele'n k'ab te jun yol yi suki'nt tetz Ryos, nka i'tz jun oy yi tetz cu'n talma' na tak', tajwe'n yil toy e' mam tor, nka e' cneru', yi qui'c mu'ẍ tal chiyana'sil, bantz stzatzine'n Ryos te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Quil tzitoywok e'chk awun swetz yi moyi'ẍ, nka q'uixpnake', nka qui'c junt quikan, nka yi je'nak tx'anol tib mu'ẍ chichi'bel, nka at xcy'akach scye'j, nin quil tzitak' tan chipat-xe'n tetz oy wi altar tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ma jalu', ko i'tz jun oy yi na toy jun tan tu' yi na tzatzin, ba'n tzun ltak' jun mam tor, nka jun cne'r yi at jalaj tkan juy, poro ko i'tz tan banle'n tane'n jun ca'wl, qui tzun tz'ak'lij ama'ltz tetz tan toyil jun awun yi nk'e'tz tz'aknak. ");
INSERT INTO aguBl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Qui'c rmeril tan itk'ol e'chk awun swetz yi q'uixpnak chiquiwel, nka lo'onsa'nt, nka elnakt tzutij, nka elnak kuxij. Quil tzitoywok yi jun jilwutz awuna'tz swetz. ");
INSERT INTO aguBl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ncha'tz quil tzitz'amwok e'chk awuna'tz tetz jun awer nak tetz inwa' yi in iRyosil, na yi e' txuca'tz at chiyana'sil, nin quil tzintz'am tik'ab.” ");
INSERT INTO aguBl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ej nin jilon tzaj junt tir Kataj Ryos tetz Moisés, itzun taltz tetz: ");
INSERT INTO aguBl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Yil tz'itz'ij jun tal ne'ẍ tor, nka yil tz'itz'ij jun tal ne'ẍ cneru', nka jun tal ne'ẍ chiw, tajwe'n yil cyajcyen te yi xtxu' tetz juk k'ej, ma yil tz'icy' yi juk k'eja'tz, stz'ocsok tzuntz tan pat-xe'n tetz oy tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","”Quil tzibiy cu'n jun wacẍ, nka jun cne'r tu tal te ite'n nin k'eja'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","”Yil tzitak'wok jun oy tan tyoẍi'n swetz, puntil cu'n tzitulej, bantz intzatzine'n te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Nin bajswoke'n tircu'n te ite'n nin k'eja'tz nin quil tzitak'wok cyen sowril tetz junt k'ej. Na in Jehová iRyosil yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","”Banwok tane'n e'chk inca'wl, xomenwok te'j. Na in Jehová iRyosil yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","”Quil tzitelsaj k'ej imbi' yi chin xan nin, bantz jale'n ink'ej tzixo'lwok, yi axwok xonl Israel. Na in, in Jehová yi iRyosil, yi ja ixansij tan ixcone'n swetz. ");
INSERT INTO aguBl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Nin ja cxe'l tzajwok wa'n Egipto, tan woque'n tetz iRyosil. Na in Jehová iRyosil yi na tzan tan talche'n e'chk ca'wla'tz tzitetz,” stzun Ryos bantz tetz Moisés tan talche'n scyetz wunak. ");
INSERT INTO aguBl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Ej nin tzun jilon tzaj junt tir Ryos tetz Moisés, itzun taltz tetz: ");
INSERT INTO aguBl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Txolaj yi xtxolbile'j scyetz yi e' atanum yi e' xonl Israel: Je bi' yi e'chk k'ejlale'j yi tajwe'n tan itoque'n tan inc'u'laje'n. Wi'nin xanil sbne' e'chk k'eja'tz yil tzimole' itib tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","”Kak' k'ej cxak'uj wok ma le juki'n k'ej, i'tz jun k'ej tetz ujle'n nin wi'nin xanil jun k'eja'tz sbne' yil tzimol cun itib tzinwutz. Tajwe'n tziban tane'n jun k'eja'tz alchok ama'lil kalel cxa'te't, na wi'nin xanil jun k'eja'tz tan tak'le'n ink'ej, na in iTaj Jehová. ");
INSERT INTO aguBl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","”Je yi e'chk k'ejlale'j tan imolol itib tan tak'le'n ink'ej, nin wi'nin xanil e'chk k'ejlala'tz: ");
INSERT INTO aguBl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","”Yi cyajlaj tajlal yi bajx xaw, cwe'n k'ej, tajwe'n tan ibnol tane'n yi Pasc, tan tak'le'n ink'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","”Nin le o'laji'n k'ej te ite'n nin xawa'tz, na taj ticy'se'n yi k'ejlal tan bajse'n yi pam yi qui'c xtx'amil, tan tak'le'n ink'ej. Tetz juk k'ej tajwe'n tan ibajsal pam yi qui'c xtx'amil. ");
INSERT INTO aguBl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Nin yi bajx k'ej te yi juk k'eja'tz, tajwe'n tan imolol itib na wi'nin xanil yi jun k'eja'tz. Quil xak'uj wok le jun k'eja'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Nin tul yi jujun k'eja'tz tajwe'n tan ipatil itx'ixwatz tzinwutz. Ej nin le juki'n k'ej, tajwe'n tan imolol itib na wi'nin xanil yi jun k'eja'tz. Qui'c cuj tan ibnol jun jilwutz ak'un.” ");
INSERT INTO aguBl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ej nin tzun jilon tzaj junt tir Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Txolnin yi e'chk xtxolbile'j scyetz yi e' atanum, yi e' xonl Israel: Yi nsken wi't cxo'c tul yi ama'l yil swak'e' tzitetz, nin yil je' yi icosech tetz triw, tajwe'n tz'opon yi bajx boc'oj ita'n tk'ab yi pale'. ");
INSERT INTO aguBl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ma yi nsken wi't icy' yi jun k'ej tetz ujle'n, tajwe'n tzun tan sukil yi pale' yi jun boc'oj triwa'tz tzinwutz chi jun oy yi wi'nin k'ej, bantz wuk'ol ama'l tan itule'n tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Nin le ite'n nin k'eja'tz yil cyoy yi jun boc'oj triwa'tz, tajwe'n tan ipatil jun tal ne'ẍ cneru' yi junixe't yob, yi qui'c mu'ẍ tal yana'sil, tan tak'le'n ink'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ncha'tz tajwe'n tzicy'aj tzaj wajxak liwr tu ni'cy te yi balaj jarin yi co'si'nt tan aceitil oliw, tan ipatil. I'tz jun oy yi wi'nin c'o'cal tzinwutz. Tajwe'n tan itoyil jun litr win xe c'u'l yi jun oya'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Quil baj pam ita'n, nka triw yi woyi'nt, nka triw yi skejt, jalen cu'n yil tz'opon yi jun itoya'tz ita'n tzinwutz. Ej nin yi jun xtxolbila'tz, i'tz jun ca'wl tetz cyakil ixonl tan chibnol tane'n sbne' opon tunintz. Qui'c na ban na'l cxa't cu'n wok. ");
INSERT INTO aguBl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","”Ma yi nsken wi't itoy yi jun boc'oj triwa'tz, tul yi k'ej tetz ujle'n, itzun yi junt eklok tajwe'n tan itajlal juk seman. ");
INSERT INTO aguBl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Nin te yi junt k'ej, tib yi ca'wunak beluj k'eja'tz, i'tz jun k'ej ujle'n, nin na jepon tajlal tetz nicy' cient k'ej. Ej nin te yi jun k'eja'tz tajwe'n yil tzitoy wok swetz yi wutz yi ac'aj cosech tetz triw. ");
INSERT INTO aguBl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Nin tajwe'n tan bene'n chicy'al jujun najal cob pam yi at xtx'amil, yi na bnix te yi balaj jarina'tz, yi cyaj liwr talal jujun, chi jun oy yi wi'nin k'ej, tetz yi bajx wutz yi cosech tan itoye'n tzinwutz, yi in Jehová yi iRyosil. ");
INSERT INTO aguBl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Nin tuml yi pama'tz, tajwe'n tan bene'n quicy'al juk ne'ẍ cne'r tan jun yob jujun, yi qui'c mu'ẍ tal chiyana'sil, tu jun ne'ẍ tor, nin cob cne'r yi mam, tan chipat-xe'n tan tak'le'n ink'ej, na i'tz jun oy yi wi'nin c'o'cal tzinwutz. Tajwe'n xomt nin yi e'chk oya'tz tetz triw tu win, yi na chiquim yi e' awuna'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","”Ncha'tz tajwe'n tan itoyil jun chiw, tan xtx'ajle'n itil, nin cob tal ne'ẍ cneru' tan jun yob jujun, tetz jun oy tetz tzatzin paz. ");
INSERT INTO aguBl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Nin yi pale' tz'ocopon tan suke'n nin yi e'chk awuna'tz chi jun oy yi wi'nin k'ej swutz Ryos, tuml yi pam yi na bnix te yi bajx wutz yi cosech, nin tuml yi cob ne'ẍ cne'r. Wi'nin xanil yi oya'tz swutz Ryos, nin tetz yi pale' sbne'. ");
INSERT INTO aguBl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","”Nin te ite'n nin k'eja'tz, tajwe'n tan ibnol jun molo'n ib yi wi'nin xanil, nin quil tziban jun ak'un yi na taj wi'nin walor. Nin yi jun xtxolbile'j, i'tz jun ca'wl sbne' yi tajwe'n tziban tane'n tetz cyakil tiemp, nin qui'c na ban na' lcxa't cu'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","”Yil tz'opon k'ejlal tan je'n icosech, quil tzisicy'e'n yi e'chk tal bak'wutz yi na cyaj cyen tx'akxuj, nin quil tzitxoy yi e'chk wutz yi bakaji'n yi na cyaj cyen wi tx'otx'. Ak'wok quen scyetz yi e' tal prow me'ba', nin scyetz yi e' awer nak. Na in iRyosil, yi na chincawun tzite'j.” ");
INSERT INTO aguBl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ej nintzun jilon tzaj junt tir Kataj Ryos tetz Moisés tan talche'n: ");
INSERT INTO aguBl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Txolaj yi xtxolbile'j scyetz yi e' atanum yi e' xonl Israel: Yi bajx k'ej tetz yi juki'n xaw, tajwe'n tan ibnol tane'n jun k'ej ujle'n, nin jun molo'n ib yi wi'nin xanil, nin tajwe'n tz'oc chun te jun k'eja'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Tajwe'n tan ipatil jun oy tan tak'le'n k'ej Ryos, nin qui'c cuj tan ibnol jun jilwutz ak'un yi na taj wi'nin walor.” ");
INSERT INTO aguBl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Jilone'n tzaj Kataj Ryos junt tir tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Yi lajuji'n k'ej tetz yi juki'n xaw tetz cyakil yob, ya'stzun yi k'ejlal tan xtx'ajle'n itil. Nin tajwe'n tan ibnol tane'n yi jun molo'n ib yi wi'nin xanil, nin tajwe'n tan ibnol tane'n yi muc'le'n we'j, nin tajwe'n tan ipatil jun oy tan tak'le'n k'ej Ryos le jun k'eja'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Nin quil cxak'uj te jun k'eja'tz, na ya'stzun yi jun k'ej tan intx'ajol itil, nin sjalok cuybil ipaj swutz Ryos, yi itajcawil. ");
INSERT INTO aguBl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Alchok scyetz yi quil sban tane'n yi muc'le'n we'j le jun k'eja'tz, qui'c na ban mbi wunakil, tajwe'n tan tele'n laju'n le tnum. ");
INSERT INTO aguBl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Nin alchok scyetz yil tz'ak'uj te jun k'eja'tz, qui'c na ban mbi wunakil, sotzel wutz sbne' wa'n. ");
INSERT INTO aguBl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","”Quil tziban jun ak'un, na i'tz jun inca'wl tetz cyakil tiemp, yi tajwe'n tan chibnol tane'n yi e' initxa' yi xomt che' tzaj, nin tajwe'n tan ibnol tane'n qui'c na ban na' lcxa't cu'nt. ");
INSERT INTO aguBl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Yi jun k'eja'tz tajwe'n tz'oc tetz itajal yi i'tz jun k'ej tetz ujle'n, nin tetz muc'le'n we'j, nin tajwe'n yil xe'tij yi jun k'eja'tz yi beluj tajlal yi xaw, cwe'n k'ej, jalen yil cu' k'ej le junt eklok, ya'stzun yil tane' imunl.” ");
INSERT INTO aguBl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Cawun tzaj Kataj Ryos junt tir tetz Moisés itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Txolaj yi xtxolbile'j scyetz yi e' atanum yi e' xonl Israel: Cyakil yob, le o'laji'n k'ej tetz yi juki'n xaw, tajwe'n tan ibnol tane'n jun wutz k'ej yi na bi'aj Scabte'. Juk tzun k'ej sbne' yi jun tzatzina'tz, tan tak'le'n k'ej Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Nin le bajx k'ej tajwe'n tzimol itib. Nin chin xan nin jun molo'n iba'tz sbne'. Quil tziban jun jilwutz ak'un yi quiw te yi jun k'eja'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Nin tul yi juk k'eja'tz, tajwe'n tan ipatil e'chk oy tzinwutz, nin le wajxaki'n k'ej tajwe'n yil tziban junt molo'n ib yi wi'nin xanil, nin tzipate' junt oy tzinwutz. Na i'tz jun k'ej tetz tzatzi'n, nin qui'c cuj tan ibnol jun jilwutz ak'un. ");
INSERT INTO aguBl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","”Je yi e'chk k'ej yi tajwe'n tan ibnol tane'n tan tak'le'n ink'ej, nin tajwe'n tan ibnol tane'n e'chk molo'n iba'tz na at xanil. Nin tajwe'n tan ipatil e'chk oy swutz Kataj Ryos, nin e'chk itx'ixwatz yi na patij tircu'n wankil, tuml e'chk oy yi ixi'n triw cu'n, nin e'chk oy yi win cu'n, xom quen tu' te yi mbi tajwe'n tan itoyil le jujun k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ncha'tz tajwe'n tan ticy'se'n e'chk k'ej tetz ujle'n cyakil sman tan tak'le'n ink'ej. Ncha'tz ba'n tzitak' e'chk oy yi suki'nt ita'n swetz tu yi e'chk oy yi tu na saj bu'k te italma'. ");
INSERT INTO aguBl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","”Ej nin yi o'laj tajlal yi juki'n xaw, yi nsken wi't je' yi cosech ita'n, tajwe'n tan ibnol jun tzatzi'n tetz juk k'ej tan tak'le'n k'ej Ryos. Nin le bajx k'ej te yi tzatzi'na'tz tajwe'n tan itujewe'n. Ma yil jepon tamp yi juk k'eja'tz, tajwe'n tan itujewe'n junt k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Le bajx k'ej ba'n tzimol wok e'chk balaj lo'baj. Ncha'tz ba'n tzimol wok e'chk xak xa'j, nin e'chk k'ab tze' yi wi'nin xak, tu yi e'chk k'ab k'an tze' yi cho'n na jal tzi'ak a' tan ibnol scabte'. Nin te yi juk k'eja'tz cxtzatzinkwok tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Na tul yi juki'n xaw tetz cyakil yob, tajwe'n tan ibnol tane'n yi jun tzatzi'na'tz tetz juk k'ej tan tak'le'n ink'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Nin tul yi juk k'eja'tz, tircu'n axwok, yi ax intanum, tajwe'n tan ita'te'n txe'ak tal scabte'a'tz, ");
INSERT INTO aguBl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","bantz tule'n tx'akx ẍchic'u'l yi e' initxa' yi mbi cu'n bajij yi woque'n tan itelsene'ltzaj le tnum Egipto, nin yi xcone'n tal scabte' ita'n tetz inajbil. Ban wok bin tane'n e'chk inca'wl, na in Jehová iRyosil.” ");
INSERT INTO aguBl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ya'stzun yi e'chk xtxolbil yi talnak Moisés scyetz yi e' xonl Israel, te e'chk k'ej, yi tajwe'n tan ticy'e'n cya'n swutz Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ej nintzun jilon tzaj junt tir Ryostz tetz Moisés itzun taltz tetz: ");
INSERT INTO aguBl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Cawunin scyetz yi e' atanum yi e' xonl Israel tan cyak'ol aceitil oliw te yi balaj, bantz quil chitzaj yi e'chk txekbil. ");
INSERT INTO aguBl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Nin tajwe'n yil tz'oc Aarón tan nuc'le'n yi e'chk cantil, bantz quil chitzaj yi e'chk txekbil yi at swutz Kataj Ryos le mantial tetz molbil ibaj, swutze'ltzaj yi xbu'k yi at swutz yi caẍa' kale atit cu'nt yi cob lepaj c'ub tetz yi trat. Nin yi xtxolbile'j i'tz jun ca'wl tetz cyakil tiemp, yi tajwe'n tan quibital yi e' initxa' yi xomt che' tzaj. ");
INSERT INTO aguBl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Tajwe'n bin tan nuc'le'n yi e'chk txekbila'tz yi ate' nintz le chicu'lbil, yi oro cu'n, tan chitxekune'n swutz Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","”Xconken yi chumbalaj jarin awa'n, nin banaj coblaj pam yi wajxak liwr tu ni'cy talal jujun sban, ");
INSERT INTO aguBl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","nin ba'n je' yi pama'tz awa'n wi yi mes, yi oro cu'n yi at tzinwutz, nin ba'n tzatxole'n cob txol tan kakchak nin tu' yi jujun txol. ");
INSERT INTO aguBl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Nin ba'n tz'icy' cu'n yi insens awa'n tibaj yi jujun txol pam, na yi insensa'tz spat-xok swutz Kataj tan tak'le'n k'ej i', yi jun xtxolbila'tz sbajok sbne' opon tunintz. ");
INSERT INTO aguBl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Nin yi pama'tz tajwe'n tan topone'n swutz Kataj Ryos, cyakil tir yi na bajij yi jun k'ej ujle'n, chi jun trat tetz cyakil tiemp. ");
INSERT INTO aguBl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Nin yi e'chk pama'tz cyetz Aarón scyuch' yi e' nitxajil sbne', nin ba'n lbaj cya'n le jun ama'l yi xan, na wi'nin k'ej yi jun oya'tz txo'l cyakil yi e'chk oy yi na opon swutz Ryos.” ");
INSERT INTO aguBl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Ej itzun bantz at tzun jun yaj yi xonl Israel yi xtxu', ma yi taj i'tz aj Egipto. Nin yi bi' yi xtxu' i'tz Selomit, nin yi xna'na'tz i' tal Dibri, nin i' jun chixonl yi e' aj Dan. Nin tzun je' chiyajol quib yi jun yaja'tz tu jun xonl Israel. Itzun yi jun yaja'tz yi xonl Israel xtxu', nintzun octz tan telse'n k'ej yi bi' Kataj Ryos. Ej nin tzun ben ticy'le'ntz swutz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ej, nin te yi na chitzan tan ẍch'iwe'n yi tajbil Kataj Ryos tan chibnol, nin tzun octz cyak'un xetze'. ");
INSERT INTO aguBl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Saje'n tzun tlol Kataj Ryos tetz Moisés, itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Cy'ajlen yi juna'tz yi mmo'c tan telse'n ink'ej, le yi ama'l kale najlquixe't, nin tircu'n yi e' yi ja quibit yi mmo'c tan telse'n ink'ej ba'n lje' chik'ab twi' tan ẍchajle'n yi juncu'n i' ajpaj. Nin tircu'n yi e' wunak tetz tnum ba'n lchibiy cu'n tan c'ub. ");
INSERT INTO aguBl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","16","Ma jalu', txolnin yi xtxolbile'j scyetz yi e' xonl Israel: Alchok scyetz yil tz'oc tan telse'n k'ej yi bi' yi kaRyosil, i' aj paj, nin tircu'n yi e' xonl Israel chocopon tan biyle'n cu'n, tan c'ub. Nin qui'c na ban ko i'tz jun xonl Israel, nka jun awer nak yil tz'oc tan telse'n k'ej Ryos, tajwe'n tan quime'n. ");
INSERT INTO aguBl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","”Ncha'tz alchok scyetz yil biycu'n jun wunak, tajwe'n tan quime'n. ");
INSERT INTO aguBl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","”Alchok scyetz yil quim tawun junt ta'n, tajwe'n tan tk'ol xel. ");
INSERT INTO aguBl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","”Nin alchok scyetz yil ban quen jun takle'n te'j junt, tajwe'n tan tijol yi mbi cu'n mban. ");
INSERT INTO aguBl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Ko at jun yi ja wak'xij bakil junt ta'n, tajwe'n tan wak'xe'n tetz bakil, ko ja el wutz jun tan junt, tajwe'n tan tele'n wutz yi jun yi me'lsan wutz yi tuch', ko ja el te' jun tan junt tuch', ncha'tz tajwe'n tan tele'n te' yi juna'tz. Bantz tijol yi q'uixc'uj yi na icy'pon tan yi jun yi na lo'on. ");
INSERT INTO aguBl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","”Alchok scyetz yil biy cu'n tawun junt, tajwe'n tan tk'ol xel. Ma na alchok scyetz yil biy cu'n jun wunak, tajwe'n tan cwe'n biyij. ");
INSERT INTO aguBl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","”Na yi e'chk ca'wla'tz nicy' nintu' sbne' scyetz yi e' xonl Israel, scyuch' yi e' awer nak yi najlche'-tz. Ban wok bin tane'n e'chk inca'wl na in yi Ryos yi itajcawil.” ");
INSERT INTO aguBl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Jilone'n tzun Moiséstz scyetz yi e' xonl Israel, nin tzun el tzaj quicy'al yi juna'tz yi oc tan telse'n k'ej Kataj Ryos, nin tzun cu' chibiyoltz tan c'ub. Quib yi tal Ryos tetz Moisés, inin tzun cyulej yi e' xonl Israeltz. ");
INSERT INTO aguBl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Itzun yi jilone'n tzaj Kataj Ryos tetz Moisés, wi yi wutz yi na bi'aj Sinaí, itzun saj tloltz tetz: ");
INSERT INTO aguBl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Txolnin yi e'chk xtxolbile'j scyetz yi e' atanum yi e' xonl Israel: Yil cxo'cwok tul yi ama'l yi swak'e' tzitetz, tajwe'n yil tz'uje' yi tx'otx' jujun tiemp tan tak'le'n k'ej Ryos. ");
INSERT INTO aguBl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Ej ba'n tzun tz'oc wutz yi tx'otx'tz ita'n tetz kak yob. Ncha'tz ba'n cxo'c tan pore'n yi uva yi awij ita'n, nin ba'n tzimol yi e'chk wutz. ");
INSERT INTO aguBl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ma le juki'n yob, tajwe'n tan tujewe'n yi tx'otx', tan tak'le'n k'ej Kataj. Nin quil tz'oc wutz itx'otx' ita'n, nin quil tziban ba'n tetz e'chk uva yi awij ita'n. ");
INSERT INTO aguBl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Nin quil je' jun cosech te yi triw yi na je'ul ẍchuc tul yi jun yoba'tz, nin quil molxij jun cosech te yi wutz yi uva yi na k'anax tul jun yoba'tz, na tajwe'n tan tujewe'n yi tx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Poro yi e'chk takle'n yi ẍchuc na ch'uy tul yi juki'n yoba'tz xcyek tan ic'a'che'n len, yi axwok itetz, scyuch' yi e' imos, scyuch' yi e' ak'unwil, nin scyuch' yi e' awer nak yi najlche' tzixo'l. ");
INSERT INTO aguBl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ncha'tz ba'n chiwan yi e' itawun, scyuch' yi e' smaron txuc te'j. Cyakil yi na je'ul ẍchuc ba'n xcon tetz iwa'. ");
INSERT INTO aguBl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","”Ej, nin tajwe'n tan itajlal juk tir juk yob, tan je'mpone'n tajlal tetz ca'wunak tu beluj yob. ");
INSERT INTO aguBl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ej nin yi lajuj tajlal yi juki'n xaw, yi k'ej tetz Cuybil Paj, tajwe'n tz'oc yi chun ita'n yi banij te tuc' cne'r, lakak tnum Israel, tan telse'n stziblal yi txant tan je'mpone'n yi nicy' cient yob. ");
INSERT INTO aguBl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ma yil jepon yi nicy' cient yoba'tz, tajwe'n tz'oc ita'n tetz jun yob yi wi'nin xanil, na i'tz jun yob tan ele'n liwr. Tircu'n yi e' esclaw chelpon liwr tan chipakxe'n te yi chinajal, nin ba'n lcyetzaj junt tir yi chitx'otx' yi benak c'a'y. ");
INSERT INTO aguBl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Yi jun yoba'tz yi na bi'aj jubileo, i'tz jun tiemp sbne' tan cyele'n cyakil wunak liwr, nin tul jun yoba'tz qui'c cuj tan tocse'n wutz yi e'chk cojbil, nin qui'c cuj tan je'n yi triw yi na itz'ij ẍchuc wi cojbil, nin qui'c cuj tan pore'n e'chk uva, nin qui'c cuj tan molche'n e'chk wutz, ");
INSERT INTO aguBl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","na i'tz jun yob yi wi'nin xanil, nin tan cyele'n yi e' pres liwr. Nin ntin cxwankwok te yi mbi'tz na ch'uy ẍchuc swutz cojbil. ");
INSERT INTO aguBl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","”Te yi jun yoba'tz yi na bi'aj jubileo, tircu'n e' yi benak chitx'otx' c'a'y tajwe'n tan cyetzal junt tir. ");
INSERT INTO aguBl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Na ko at jun slok' jun piẍ tx'otx', nka sc'ay nin jun piẍ tx'otx', qui'c cuj tan paysal wutz yi jun yi na tzan tan c'aye'n, nka yi jun yi na tzan tan lok'che'n. ");
INSERT INTO aguBl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Na yi wunak yi lok'on jun piẍ tx'otx', ntin ẍchoje' yi tajlal cosech yi sjalok jalen yil tz'ucu'l junt tir yi jun yob yi na bi'aj jubileo, nin yi jun yi na c'ayin tetz yi tx'otx', ntin sjake' yi jamel yi e'chk cosecha'tz yi txe'n je' swutz yi cojbil. ");
INSERT INTO aguBl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Xom quen tu' te yi jatna' tlen cosech txe'n je', ya'tz nin jamel yi cojbil sbne'-tz. Nin yi ko coboxte'n yob cosech tan je'n, ajnak tzaj nin tzun sbne' jameltz, na yi na c'aylij i'tz yi tajlal e'ch cosech. ");
INSERT INTO aguBl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","”Qui tzun tzipaysaj iwutz tzitibil itib. Ma na ek wok inchi', na yi in wetz in iRyosil yi na cawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Banwok tane'n e'chk inca'wl tu e'chk inley yi bixba'nt wa'n. Nque'n wok c'ulutxum tan banle'n tane'n, bantz penin sk'il cxnajank wok le itanum. ");
INSERT INTO aguBl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Stk'e' tzun itx'otx' balaj cosech, nin cxtzatzink wok swutz icojbil, nin sbajk yi e'chk wutz yi e'chk cosecha'tz ita'n jale'n cu'n yil noj ic'u'l. ");
INSERT INTO aguBl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","”At lo' e' scyale': ‘¿Mbil baj ka'n yil ko'c tul yi juki'n yob, na qui'c cuj tan kak'uje'n wi cojbil, nin qui'c cuj tan kabene'n tan je'se'n kacosech?’ ");
INSERT INTO aguBl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Je puntile'j, yi in wetz, swak'e' imbanl tzitibaj le kaki'n yob, nin yi cosech yil je' ita'n xcyek tan ic'a'che'n tetz ox yob. ");
INSERT INTO aguBl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Cxwank tzun woktz te yi colij ita'n, jalen yil cxo'c wok tan tawle'n itujul le wajxaki'n yob, nin xcyek yi colij ita'n tan ic'a'che'n jalen yil je' yi ac'aj cosech. ");
INSERT INTO aguBl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","”Yi tx'otx' qui'c rmeril tan bene'n ita'n c'ay tetz cyakil tiemp, na i'tz wetz, nin yi axwok itetz, ni'cu'n chi axwok tu'k c'amol tane'n swutz incojbil. ");
INSERT INTO aguBl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Cha'stzun te yi tx'otx' yi at tik'ab, ba'n tzitak' ama'l tetz yi taw banak, tan lok'ol junt tir tzitetz. ");
INSERT INTO aguBl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","”Yi ko at jun itanum yil ben tul il, nin sc'ay icy' tzaj yi xtx'otx' tzitetz, ba'n tzilok'. Poro ko at jun xonl i' yi naka'j chixo'l tuch', yi na taj tan colpil yi tx'otx' yi ja wi't ben c'ay, ba'n tzitak' ama'l tetz tan lok'ol junt tir tetz yi mero taw. ");
INSERT INTO aguBl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","”Ma jalu', ko i'tz jun itanum yi qui'c tetz xonl tan xcyewe'n tan colpe'n yi tx'otx', ba'n tz'oc il tan molche'n pu'k tan lok'olt tzitetz. Yil jal yi tajwe'n ta'n, ");
INSERT INTO aguBl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","tz'ocopon tan telse'n cwent te yi jatna' yob na taj tan je'mpone'n te yi yob tetz jubileo, nin ya'stzun jamel yi stk'e' tzitetz tan tetzal junt tir yi tx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ma jalu', ko quil xcye' yi yaj tan molche'n yi pwok yi tajwe'n, scyajk tzun yi tx'otx'a'tz tcwent yi jun yi nlok'on jalen cu'n yil tz'opon yi jun yob yi na bi'aj jubileo tan tetzal junt tir, na ya'stzun yi jun tiempa'tz yi na pakxij junt tir chitx'otx' cyakil wunak ẍchik'ab. ");
INSERT INTO aguBl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","”Ko at jun yi ja c'ay jun ca'l tul jun tnum yi tapij cu'n te'j, ntin at rmeril tan lok'olt tul yi bajx yob yi benle'nix c'ay. ");
INSERT INTO aguBl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Poro ko quil xcye' junt tir tan lok'che'n yi ca'l, te jun yoba'tz, scyajk yi ca'l tetz yi junt wunak yi nlok'on, tetz cyakil tiemp, nin qui't xcye' yi taw banak cyen tan colpe'n, mpe ik tul jun yob yi na bi'aj jubileo. ");
INSERT INTO aguBl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ma yi e'ch ca'l yi cho'n je'nake' tul e'chk tnum yi qui'c tapij solte'j, ni'cu'n sbajok scye'j chi na bajij te jun piẍ tx'otx' yi ba'n lok'xij kol xcye' yi taw tan colpe'n junt tir, ma ko qui', spakxok tzuntz tk'ab yi taw yil jepon yi jun yob tetz jubileo. ");
INSERT INTO aguBl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","”Ma yi e' xonl Leví, ba'n chilok' junt tir e'chk chica'l yi cho'n at tul jun tnum yi tapij cu'n te'j. ");
INSERT INTO aguBl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Yi kol ben jun ca'l c'a'y tan jun xonl Leví yi cho'n at le jun tnum yi tapij cu'n te'j, nin ko quil xcye' tan lok'che'n junt tir, tajwe'n yil pakxij tk'ab i' yil jepon yi yob tetz jubileo. Na yi e'chk chica'l yi e' xonl Levíja'tz ya'stzun yi cyetz chica'l tetz cyakil tiemp. ");
INSERT INTO aguBl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Nin yi e'chk ama'l tetz pstorbil, yi cho'n at ẍchik'ab yi e' xonl Leví, qui'c rmeril tan bene'n c'a'y, na yi e'chk ama'la'tz i'tz cyetz, tetz cyakil tiemp sbne' opon tunintz. ");
INSERT INTO aguBl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","”Ko at jun itanum, yil cyajcyen me'ba', nin ltz'opon tan jakle'n ẍch'eybil tetz tzitetz, tajwe'n tan ich'eyal chi na ich'ey jun awer nak tbe', nin tajwe'n tan itk'ol posar. ");
INSERT INTO aguBl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Quil tzimajwok len jun takle'n tetz, nin quil tzitz'am ta'al yi pwok yi ja c'am tzitetz, quil tziban jun xtxolbila'tz, ma na ekwok ẍchi' iRyosil, nin ak'wok posar yi jun prowa'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Quil tzijak ta'al yi pwok yi na itak' tan c'mo'n tetz, nin quil je' jamel yi wa' ita'n. ");
INSERT INTO aguBl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Na in iRyosil, yi itajcawil, nin ja cxe'lwok tzaj wa'n ẍchik'ab yi e' aj Egipto, tan woque'n tetz iRyosil, nin tan itopone'n le tnum yi na bi'aj Canaán. ");
INSERT INTO aguBl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","”Yi kol cyajcyen jun itanum tul me'ba'il te yi at tan posari'n tzituch', nin lc'aytib tzitetz tan ak'un, quil tzibuch chi jun esclaw tane'n, ");
INSERT INTO aguBl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ma na tajwe'n tzitak' k'ej chi na itak' k'ej jun ak'unwil, nka chi na itak' k'ej jun aj posarinl. Nin stz'ak'ujk tzituch' jalen yil tz'opon k'ejlal yi jun yob tetz jubileo, tan tele'n liwr. ");
INSERT INTO aguBl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Kalena's tzun tz'eltz liwr tuml yi najal, tan ta'te'n ẍchixo'l yi e' tetz xonl, nin tan ta'te'n swutz yi tetz cojbil, chibanak cyen. ");
INSERT INTO aguBl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Na axwok len cu'n inchakum, na ja cxe'ltzaj wa'n jak' ca'wl Egipto, nin qui'c rmeril tan ibene'n c'ayi'n chi na ben c'ayi'n jun esclaw. ");
INSERT INTO aguBl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Qui bin che' ibuch, ma na chajwok yi na itek inchi'. ");
INSERT INTO aguBl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","”Ko na itaj tzilok' jun esclaw yaj nka xna'n, ba'n tzilok', poro yi cho'n ljal ẍchixo'l yi e' awer nak tetz junt tnum. ");
INSERT INTO aguBl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ncha'tz ba'n tzilok' yi e' awer nak yi najlche' tzixo'l, tuml chinitxa' yil chijal te yi ate' le itanum, ba'n lche' ilok' tetz esclaw. ");
INSERT INTO aguBl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Nin ba'n chicyaj cyen ita'n tetz esclaw scyetz initxa' yil cxquim itetz. Poro qui'c rmeril tan itoque'n tan chibuchle'n yi e' itanum yi ko e' esclaw tzituch'. ");
INSERT INTO aguBl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","”Ma jalu', ko at jun awer nak yil tz'oc tetz ric, nin ko at jun itanum yi ja ben tul tx'ok'be'n, nin na c'ay tib tetz yi jun rica'tz, nka na c'ay tib tetz alchok awer nakil, ");
INSERT INTO aguBl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","at cuj tan ẍchojol jamel tan tele'n liwr, nin qui'c na ban ko ja wi't c'ay tib. Ba'n colpij tan jun titz'un, nka jun stzicy, ");
INSERT INTO aguBl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","nka tan jun quitz'un, nka quitzicy yi e' taj xtxu', nka alchok jun scyetz yi e' xonl yi naka'j nin chixo'l tuch'. Ncha'tz ba'n colpij tib kol xcye' te'j ẍchuc cuntu'. ");
INSERT INTO aguBl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Nin na taj telse'n ajal te yi jatna' tiemp na taj tan je'mpone'n te yi yob tetz jubileo, nin yi jamel tan tele'n liwr i'tz yi tajlal yi e'chk yob yi quil xcon tetz yi patrón. Yi pwok cho'n xomok te yi na chitx'ac yi e' ak'unwil tul jun k'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Nin ko at tzaj nin coboxt yob yi qui njepon te yi jun yob jubileo, tajwe'n tan tk'ol mu'ẍ te yi pwok yi nstz'am yi bene'n c'ayil tib. ");
INSERT INTO aguBl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ko coboxte'n yob tan je'mpone'n te yi jun yob tetz jubileo, ntin ẍchoje' yi jamel yi mu'ẍt tiempa'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Nin tajwe'n tz'i'lwij wutz chi jun ak'unwil yi na ak'uj tan yobi'n, quil tzitak' ama'l tan toque'n buchle'n. ");
INSERT INTO aguBl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","”Ma jalu', ko cya'l na jal puntil ta'n tan colpe'n, ilenin tz'elpon liwr scyuch' yi e' nitxajil, yil jepon yi jun yob yi na bi'aj jubileo, ");
INSERT INTO aguBl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","na tircu'n yi e' xonl Israel e' len cu'n inchakum, e' wetz, na in nche'lsan tzaj Egipto. Na in yi Ryos yi ca'wl itetz. ");
INSERT INTO aguBl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","”Quil tziban teblal e'chk ryos yi banijt cuntu' quitane'n, nin quil tzilok' wutz e'chk teblal junt ryos, nin quil tz'oc e'chk c'ub ita'n chi wi'nink xanil, nka e'chk c'ub yi se'ij tu' wutz. Quil cxmeje' wok swutz e'chk takle'na'tz tan tak'le'n ke'j, na yi in wetz in Jehová iRyosil. ");
INSERT INTO aguBl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Banwok tane'n e'chk k'ej tetz ujle'n yi bixba'nt wa'n. Ak'wok k'ej yi mantial tetz molbil ibaj kale najlchine't. Na yi in wetz in Jehová iRyosil, yi na chincawun tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","”Yi kol cxom wok te e'chk inca'wl, nin kol tziban tane'n tircu'n yi na walnin tzitetz, ");
INSERT INTO aguBl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","tz'opon tzun yi a'baltz wa'n te yi tiempil, nin tircu'n e'chk ujul swutzink. ");
INSERT INTO aguBl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Nin yi triw yi jepon ita'n xtx'aje' yil tz'ucu'l tiempil yi uva, nin yi uva xtx'aje' jalen yil tz'oc junt tir yi cosech wi yi cojbil. Nin quil xquim wok tan we'j, nin tan yi na cxtzan wok tan banle'n tane'n e'chk inca'wl quil sotz ic'u'l le itanum. ");
INSERT INTO aguBl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Nin sjalok tzatzin paz le itanum, nin quil cxob wok yil cxwit, nin cxincole'wok ẍchik'ab yi e' smaron txuc, nin quil wak' ama'l scyetz yi e' icontr tan oyintzi' tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Cxcyekwok tan chilaje'n len e' icontr, nin ẍchiquimok tircu'n ita'n tan spar. ");
INSERT INTO aguBl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ntin o' ntzi' ixone'n cxcyek tan chilaje'n len jun cient icontr, nin yi jun cient itetz, chixcyek tan chilaje'n len lajuj mil icontr, nin tircu'n ẍchiquimoklen ita'n tan spar. ");
INSERT INTO aguBl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Wi'nin ẍchin tzatzink tzite'j, nin cxpuc'unk wa'n, nin jun cu'n nelpon cu'n te inyol yi insuknak tzitetz. ");
INSERT INTO aguBl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Nin cxwankwok te yi cosech triw yi colije't ita'n, nin tajwe'n tan tele'n tzaj ita'n le cu'lbel, tan icolol yi wutz yi ac'aj cosech. ");
INSERT INTO aguBl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","”Yi in wetz na'tok tzite'j, nin quil tzinxajslen wib tzite'j. ");
INSERT INTO aguBl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nin cyakil nin tiemp ẍchinxonk tzixo'l. Nin nocopon tetz iRyosil. Nin yi axwok cxocopon tetz intanum. ");
INSERT INTO aguBl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Na in iRyosil yi itajcawil yi ncxe'lsan tzaj jak' chica'wl yi e' aj Egipto, tan qui't ita'te'n tetz chi'esclaw. Nin ja el yi yucu' wa'n te ikul yi tz'amol itetz, nin ja wak' ik'ej. ");
INSERT INTO aguBl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","”Ma jalu', ko quil cxo'c c'ulutxum jak' inca'wl, nin ko quil tziban tane'n e'chk xtxolbil yi ja wi't wal, ");
INSERT INTO aguBl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ma na ko quil tzicujij e'chk inley nin kol cxo'cwok tan telse'n k'ej e'chk inca'wl, nin ko quil tziban tane'n, qui tzun cxe'l cu'n wok te yi katrat. ");
INSERT INTO aguBl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Ko ya'tz tziban wok, je tzimbane'j tzite'j: Chin xo'wbil nin sbne', cupon ya'bil yi sbiyonk, tz'elu'l ik'a'kl, ẍchiyobtok iwutz, nin quil jal iwalor, nin qui'c wutzil yi e'chk ujul sbne' yil tzitawaj, na yi e' icontr e' scambank yi wutz icosech. ");
INSERT INTO aguBl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nocopon contr tzite'j, nin yi e' icontr chixcyek tzite'j, nin ẍchicawunk yi e' yi wi'nin na chi'ch chic'u'l tzite'j, nin cxelpon ojk ptzun cya'lk jun xomij tan itz'amle'n. ");
INSERT INTO aguBl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","”Nin ko qui nin cxo'ctz c'ulutxum jak' inca'wl, cxincawse' jukt tir tampaj itil yi na ijuch. ");
INSERT INTO aguBl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Na itocsaj itib nim tu itajtza'kl, poro tzinxite' cunin yi jun iya'pla'tz, nin qui't wak' ama'l tan cwe'n a'bal wi'ak yi icojbil bantz quil wutzin itujul. ");
INSERT INTO aguBl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Nin yi itak'un tan cha'tz tu' sbne', na quil wutzin, nin ncha'tz yi e'chk wi' lo'baj quil jal jun tal ẍutuj wutz. ");
INSERT INTO aguBl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","”Nin ko qui nin tz'ocopon inca'wl te iwi', nin iẍnin axwoktz tan pajle'n e'chk inca'wl, swak'e' tzun jukt tir icaws, xomquen tu' te ipajpal. ");
INSERT INTO aguBl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Swak'e' ama'l tan cyopone'n e'chk smaron txuc tan ibajse'n, nin ẍchibajk initxa' cya'n, nin chocopon tan chibajse'n e'chk itawun, nin chixcyek yi e' txuca'tz tan chibiyle'n wi'nin wunak, nin qui't jal mas ixone'n tan xo'n lakak be'. ");
INSERT INTO aguBl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","”Nin ko chin pajpuj nin axwok, nin ch'inch'uj nin tunin axwok tan pajle'n e'chk inca'wl, ");
INSERT INTO aguBl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","cxincawse' jukt tir, tan e'chk itil yi na ijuch. ");
INSERT INTO aguBl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nin copon jun chin wutzile'n oyintzi' wa'n tzixo'l scyuch' yi e' icontr bantz wicy'sal inc'u'l tzite'j, tampaj yi qui nin ncxe'l cu'n wok te katrat yi bnixnakt ka'n tzituch'. Cxelpon ojkuj tan icolol itib le'ak itanum, poro copon e'chk ya'bil wa'n tzixo'l. Ncha'tz ncxben wok pres cyak'un yi e' icontr. ");
INSERT INTO aguBl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","”Ej, nin yil tzaj yi iwa' wa'n, yi colij ita'n tan iwane'n coboxt k'ej te'j, lajuj cu'n xna'n chocopon tan sk'ajse'n jun tal pam tul jun ntzi' tal chuj, nin piẍu'n cu'n sbne' tziwutz, nin quil noj ic'u'l ta'n. ");
INSERT INTO aguBl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","”Ej, nin ko qui nin na ocopon inyol te iwi', nin ch'inch'uj nin tunin axwok tan pajle'n inca'wl, ");
INSERT INTO aguBl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ẍchi'chok inc'u'l tzite'j, nin cxincawse' wok jukt tir yi nimte'n cu'n q'uixbel sbne', tan yi ipajpal. ");
INSERT INTO aguBl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Nin tan yi xtxolbila'se'j, axwokte'n cxocopon tan chibajse'n initxa'. ");
INSERT INTO aguBl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nocopon tan xite'n cu'n e'chk k'ajbil yi na xcon ita'n tan c'u'laje'n e'chk ryos. Nin cob cuntu' chelpon e'chk patbil insens yi na xcon tzitetz. Nin yi iwankil yi quimnakt cho'n jepon intenul tibaj chiwankil e'chk iryosil yi qui na chinachon. Tzinchaje' tzuntz tzitetz yi qui na chimpek' te itajtza'kl. ");
INSERT INTO aguBl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Chin tz'inunin tu' sbne' itanum wa'n. Nin tzinxite' e'chk ica'l kale na imolwit itib tan tak'le'n k'ej e'chk ryos. Nin qui't chintzatzin te e'chk balaj insens yil tzitak' swetz. ");
INSERT INTO aguBl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","”Slo'onk yi tnum wa'n, nin yi e' icontr yil chu'l tan najewe'n tul chelpon yab te yi squile'. ");
INSERT INTO aguBl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nin cxelpon xit wa'n bene'n tzi'n ẍchixo'lak e'chk tnum; nin nocopon tan ibiyle'n cu'n tan spar; nin yi itanum tz'ocopon tetz jun ama'l yi tz'inunin tu' yi chin xo'wbil nin. ");
INSERT INTO aguBl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Nin tan yi xtxolbila'tz stz'ujek yi tx'otx', nin tz'elpon xel yi tiemp tzite'j yi qui nin mitak' tan tujewe'n. Te yi tiemp yil cxa'tijwok tan najewe'n le chitanum e' icontr, ya'stzun yi tiemp yi stz'ujek yi tx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Cyakil yi tiemp yil cyaj yi tx'otx' ẍchuc, ya'stzun yi xel yi tiemp yi qui nin mitak' tan tujewe'n te yi atix tzaj wok swutz. ");
INSERT INTO aguBl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","”Nin yi axwok yil cxclax cyen ẍchik'ab yi e' icontr te yi atix ẍchixo'l, swak'e' wi'nin xo'w tzitetz, nin cxelpon ojkuj tan tu' yil tzibitnin yi na cutzaj tx'akxuj jun tal xak xtze', cxelpon ojkuj swutz, ni'cu'n chi alk jun xomij wutz icoc tu spar tan ibiyle'n cu'n. Ej nin cxjepon trimp tan bi'l nin ojke'l. Poro cya'l xomij tan itz'amle'n. ");
INSERT INTO aguBl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Nin ichucte'n tzibowle' itib. Na ni'cu'n chi najk icol itib tk'ab jun chin wutzile'n oyintzi', poro cya'l jun xomij tan itz'amle'n. ¡Nin cya'l nin jun tzitetz yi nink jal walor tan oyintzi' tu icontr! ");
INSERT INTO aguBl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Nin yi e' mas tnum chocopon tan itelse'n cu'n swutz, nin xquimok wok cyak'un yi e' icontra'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ej nin yi e' yi quil chiquim le chitanum yi e' icontra'tz, ẍchiquimok tampaj yi cyetz quil. Ẍchiquimok scyuch' chitaj chitxu', na ncha'tz e', at len quil. ");
INSERT INTO aguBl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","”Ma yi e' ixonl yil chixomtzaj, mpe nink chinachon te chipaj tu chipaj yi e' chimam chite', yi e' yi oc tan contri'n swe'j tan yi cyajtza'kl yi chin pajpuj nin, ");
INSERT INTO aguBl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ilenin nocopon tan contri'n scye'j, nin swak'e' ama'l tan chibene'n pres chik'ab chicontr. Kalena's tzun chitx'ixwok nin chichoje' yi pajpal yi cyajtza'kl. ");
INSERT INTO aguBl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Kalena's tzun tz'ul tx'akx yi trat tinc'u'l, yi bnixnak wa'n tu Jacow, nin Isaac, nin tu Abraham. Ej nin ncha'tz tz'ul tx'akx yi tx'otx' tinc'u'l yi suki'nt wa'n tzitetz. ");
INSERT INTO aguBl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Na yi tx'otx'a'tz tz'ujek tik'ab. Nin tzatzin cu'n tz'ujek yi cobox yoba'tz yi qui nin mitak' ujle'n tetz, na quibix axwok sbne' tan ak'un swutz. Na ya's tzun icaws, tan paj yi qui nin mitak' k'ej e'chk inca'wl tu e'chk inley, na qui nin ixomwok tan banle'n tane'n. ");
INSERT INTO aguBl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","”Nin te yi na itijwok cyakil e'chk cawsa'tz, le chi ama'l yi e' icontr, quil cxe'lwok te inc'u'l junawes, nin quil cxe'l wok cu'n wa'n swutz junawes, na quil tz'el yi trat te inc'u'l yi mbnixnak wa'n skaxo'l, scyuch' yi e' imam ite', na yi in wetz in Jehová, yi iRyosil. ");
INSERT INTO aguBl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ma na chu'l tx'akx e' tinc'u'l tan paj yi trat yi mbnixnak wa'n scyuch', yi cyele'n tzaj wa'n Egipto, ẍchiwutz jun c'oloj nación, tan woque'n tetz chiRyosil. Na in Jehová iRyosil.” ");
INSERT INTO aguBl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ya'stzun yi e'chk ley tu e'chk ca'wl, tu e'chk chusu'n, yi cyaj tlol Kataj Ryos tetz Moisés wi wutz Sinaí, tan xtxolil scyetz yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Ej, nintzun jilon tzaj junt tir Kataj Ryos tetz Moisés tan talche'n: ");
INSERT INTO aguBl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Txolnin yi e'chk xtxolbile'j scyetz yi e' atanum yi e' xonl Israel: Alchok scyetz yi na taj ẍchoj yi jamel tan colpe'n jun wunak nka jun e'chk takle'n yi sukij swetz, je yi pwok yi tajwe'n tan ẍchojle'n swetz tan colpene'l tzaj tk'ab yi yol yi nsuk swetz: ");
INSERT INTO aguBl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ko i'tz jun yaj yi at tul junak yob jalen ox c'al yob yi jamel i'tz nicy' cient piẍ sakal. Xom quen tu' te yi walor yi jilwutz pwok yi na xcon le mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ma ko i'tz jun xna'n yi nsukij swetz, yi jamel i' i'tz, junaklaj piẍ sakal. ");
INSERT INTO aguBl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ma scyetz yi e' wunak yi ate' tul o' yob jalen junak yob yi nsukij swetz, yi chijamel i'tz junak piẍ sakal yi ko i'tz yaj, ma ko i'tz xna'n, lajuj ntzi' tzuntz. ");
INSERT INTO aguBl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ma scyetz yi e' nitxa' tan jun xaw jalen o' yob, yi chijamel i'tz o' ntzi' piẍ sakal ko i'tz xicy, ma ko xun ox ntzi' tzuntz. ");
INSERT INTO aguBl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ma scyetz yi e' yi ja tz'ak ox c'al yob cya'n, o'laj tzun piẍ sakaltz, scyetz yi e' yaj, nin lajuj scyetz yi e' xna'n. ");
INSERT INTO aguBl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ma ko chin me'ba' nin jun wunak, tan ẍchojle'n yi pwok yi bixba'nt, tajwe'n tzun tz'opontz tan yol tetz yi pale', tan tbite'n yi nicy'na' ẍchoje', xomquen tu' te yi walor yi jun yi sukin yi yol. ");
INSERT INTO aguBl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","”Ma jalu', yi ko i'tz jun awun yi suki'nt swetz, qui'c tzun rmeriltz tan xite'n yi jun trata'tz, na ja wi't xansij. ");
INSERT INTO aguBl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Nin qui'c cuj tan je'n tx'exu'n tu junt awun. Qui'c na ban ko chin ba'nt cunin, nka ajnakt tzaj cunin. Ma ko na tx'e'xij jun awuna'tz yi suki'nt, chicabil tzuntz na chixansij, yi jun yi at nintz, tu yi xel yi mopon oyi'n. ");
INSERT INTO aguBl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","”Ma ko i'tz jun txuc yi nk'e'tz xansa'nt, yi qui'c cuj tan toye'n tetz Ryos, tajwe'n tzuntz tan bene'n ticy'le'n yi jun awuna'tz swutz yi pale', ");
INSERT INTO aguBl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","nin yi pale' tz'a'lonk tzaj yi nicy'na' jamel yi jun txuca'tz. Nin yi jamelil yi na bixe' tan yi pale', tajwe'n tan cujil yi taw yi awun. ");
INSERT INTO aguBl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Nin ko na a'wij tan taje'n junt tir yi awun, tajwe'n tzuntz tan ẍchojol yi jamel yi bixba'nt, tuml jun mult, yi i'tz jun part te o' piẍ yi jamel yi awuna'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","”Ko at jun yil suk yi ca'l swetz, yi pale' bixbank yi walor yi ca'l, xomquen tu' te yi balajil yi ca'l, nin yi walor yi na bixbaj yi pale', tajwe'n yil cu' swutz yi taw ca'l. ");
INSERT INTO aguBl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ma jalu', ko na taj yi taw tan colpe'n junt tir yi ca'l, tajwe'n tzuntz tan ẍchojol yi walor yi ca'l tuml jun part te yi o' piẍ yi jamel yi ca'l yi bixba'nt tan yi pale', spakxok tzun junt tir yi ca'l tk'ab. ");
INSERT INTO aguBl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","”Ko at jun ja suk jun piẍ cojbil swetz, yi walor yi jun piẍ cojbila'tz cho'n xomok te yi nicy'na' cosech na je' swutz, yi walor i'tz nicy' cient piẍ sakal te cyakil ca'wunak cient tu ca'wunak liwr cebada yi na je' swutz. ");
INSERT INTO aguBl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Nin kol suk yi tx'otx' tul yi yob yi na bi'aj jubileo, tajwe'n tan ẍchojle'n yi jamel cawal. ");
INSERT INTO aguBl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Poro kol suk swetz te nsken wi't icy' yi jun yoba'tz yi na bi'aj jubileo, qui'c mas jamel sbne'. Cho'n xomok te jatna' yob na taj tan je'n pone'n te yi jun yob tetz jubileo. ");
INSERT INTO aguBl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","”Ma na ko na taj yi taw yil pakxij junt tir yi xtx'otx' tk'ab, tajwe'n tan ẍchojol yi walor yi tx'otx' tuml jun part te o' piẍ yi jamel. Stetzaje' tzun junt tir yi tx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Poro ko quil cambaj yi tx'otx', nin lben c'a'y tetz junt wunak, qui'ct tzun cuj tan cambal junt tir yi tx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Nin yil jepon yi jun yob yi na bi'aj jubileo, qui'c jun taw sbne', ma na ntin in, nin yi pale' i' tz'ocopon tan q'uicy'le'n yi tx'otx'a'tz. ");
INSERT INTO aguBl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","”Ko at jun ltak' jun piẍ tx'otx' swetz yi ja lok', nin nk'e'tz herens yi at tk'ab, cyak'un taj, ");
INSERT INTO aguBl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","stile' yi pale' nicy'na' jamel sbne' jalen yil jepon yi jun yob jubileo. Nin te ite'n nin k'eja'tz na taj ẍchojle'n. ");
INSERT INTO aguBl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ma yil tz'opon yi jun yob jubileo, spakxok tzun junt tir yi tx'otx' tk'ab yi mero taw banak. ");
INSERT INTO aguBl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","”Tircu'n jamel e'chk takle'n tajwe'n yi cho'n lxom te yi jun jilwutz pwok yi na xcon le yi mantial tetz molbil ibaj. ");
INSERT INTO aguBl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","”Ma jalu', je xtxolbile'j scye yi awun yi bajx na chitz'ij. Yi e'a's yi bajx na chitz'ij wetz sbne', qui'c rmeril tan suke'n swetz, na bixba'nt wa'n yi wetz sbne'. Qui'c na ban ko i'tz jun tal wacẍ, nka jun tal ne'ẍ cne'r, wetz sbne'. ");
INSERT INTO aguBl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ma jalu', ko i'tz bajx tal jun txuc yi xan kol bajsij, ba'n colpij. Ntin na taj ẍchojle'n yi jamel yi na bixe' tan yi pale', tuml jun mult yi i'tz jun part te o' piẍ yi jamel yi jun txuca'tz. Poro ko quil je' colpi'n, ba'n lben c'a'y tan yi pale' chi yi jamel yi ja wi't bixe'. ");
INSERT INTO aguBl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","”Ko at jun yi ja wi't suk yi me'bi'l swetz, qui'c na ban ko i'tz wunak, tawun, nka jalaj tx'otx' yi ya'stzun yi herens yi ncyaj chik'ol yi e' taj xtxu'. Qui'c cuj tan bene'n c'a'y, nin qui'c rmeril tan cambe'n junt tir na ya'stzun xac yi ja ak'lij swetz, nin wi'nin xanil tzinwutz. ");
INSERT INTO aguBl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Nin ncha'tz qui'c cuj tan colpe'n jun wunak yi suki'nt swetz, ma na tajwe'n tan quime'n. ");
INSERT INTO aguBl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","”Yi lajuji'n piẍ te yi e'chk cosech yi na je' wi yi cojbil, tu yi wutz e'chk tze' i'tz wetz. ");
INSERT INTO aguBl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ma ko at jun na taj tan colpe'n mu'ẍ te yi lajuji'n piẍa'tz, tajwe'n tan ẍchojol yi jamel tuml o'i'n part te tircu'n yi jamel. ");
INSERT INTO aguBl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","”Jun te yi lajuj awun, tajwe'n tan tak'le'n swetz, na ya'stzun yi lajuji'n part, ");
INSERT INTO aguBl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","nin qui'c cuj tan tak'le'n junt xel yi ba'nt cu'n, nka ploj mu'ẍ tal. Nin kol je' tx'exu'n jun awun, chicabil tzuntz ẍchicyajk tetz wetz, nin qui'c cuj tan chicolpe'n.” ");
INSERT INTO aguBl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ya'stzun yi e'chk ca'wl yi tak' Kataj Ryos tetz Moisés wi yi wutz yi na bi'aj Sinaí, tan xtxolil scyetz yi e' tetz tanum, yi e' xonl Israel.");
INSERT INTO aguBl_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Itzun bantz, te yi nsken quim Moisés, yi ẍchakum Ryos, nintzun jilon Kataj Ryos tetz Josué. Yi Josuéja'tz i' cy'ajl Nun, nin i' ẍch'eyum Moisés banak. ");
INSERT INTO aguBl_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","Itzun tal Kataj tetz: “Ma jalu' Josué, ja quim Moisés, yi inchakum. Cha'stzun te tajwe'n tan abajxe'n cy'en ẍchiwutz cyakil yi e' mas atanum, yi e' xonl Israel, wi yi a' Jordán, bantz itopone'n swutz yi ama'l yi swak'e' tzitetz. ");
INSERT INTO aguBl_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","”Suki'nt cyakil yi e'chk ama'la'tz wa'n tzitetz, chi walnak tetz Moisés. Cyakil yi ama'l kale cxicy'e'twok, itetz sbne'. ");
INSERT INTO aguBl_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Suki'nt yi e'chk ama'la'tz tzitetz, yi na xe'tnin te yi ama'l tz'inunin tu' jalen te yi wi'wtz Líbano. Ma tele'n tzi'n, cho'n na xe't tzaj tzi yi jun chin wutzile'n tzanla' Eufrates, nin na opon jalen te yi mar Mediterráneo, kale na cwe't yi k'ej. Nin na jop cyakil yi chi'ama'l yi e' hitita. ");
INSERT INTO aguBl_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","”Cya'l jun xcye' tzawe'j Josué te yi cobox k'ej yi atiẍ tzone'j wuxtx'otx', na chinxomok tzawe'j, chi banakin te'j Moisés. Quil ẍwil cyen achuc, na ilenin chinxomok tzawe'j. ");
INSERT INTO aguBl_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Benk awukan ttx'otx' nin quil cxob, na aẍ cẍocopon tan jatxle'n cu'n chi'ama'l yi e' intanume'j. Yi ama'la'tz, ya'stzun yi suki'nt wa'n scyetz imam ite'. ");
INSERT INTO aguBl_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Ntin na taj yi benk awukan ttx'otx', nin yi quil cxob. Nque'n il tan banle'n tane'n cyakil yi ley yi talnak yi inchakum Moisés tzatz. Xomen te'j, quib yi na tal, bantz penin sk'il sban cyakil yi e'chk takle'n yil tzaban. ");
INSERT INTO aguBl_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","”Ntin na taj yi quil tz'el te ac'u'l, yi mbi na tal yi liwr kale atit yi wetz inca'wl. Sk'ejl nin lak'bal na taj yil tzatxum yi mbi na tal. Nin kol cxom te'j, penin sk'il sbne' cyakil yi tzabne'. ");
INSERT INTO aguBl_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","”Qui bin cxob. Benk awukan ttx'otx'. ¡Quiwit! Quil tzacabej ac'u'l, na in awAjcawil, nin in aRyosil, nin chinxomok tzawe'j alchok cẍa'jnint.” ");
INSERT INTO aguBl_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Toque'n tzun Josué tan chicawe'n yi e' mas ajcaw yi ate' ẍchixo'l yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","Itzun taltz scyetz: “Chibenku' ẍchixo'l yi e' katanum, nin cyale'u' scyetz: ‘Banwok list iwa'. Na le oxt k'ej kicy'pon wi a' Jordán tan ketzal yi ama'l yi ja wi't suk Kataj yi kaRyosil sketz,’ che'chu' sban.” ");
INSERT INTO aguBl_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Ncha'tz jilon Josué scyetz yi e' xonl Rubén, scyuch' yi e' xonl Gad, scyuch' jun k'u'j scyeri e' xonl Manasés yi cob elnake'. ");
INSERT INTO aguBl_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","Itzun taltz scyetz: “Ulk tx'akx yi yol Moisés, yi inchakum, ẍchic'u'lu'. Na je yol i'e'j: ‘Kataj, yi kaRyosil mmak'on yi ama'le'j tan cyetzalu' nin tan cya'te'nu' swutz,’ chij i' ban. ");
INSERT INTO aguBl_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Chicyajk cyen bin yi quixkelu' scyuch' chinitxajilu' tzone'j. Ncha'tz yi cyawunu' chicyajk cyen tzone'j. Na yi ama'le'j, yi at jalajicy' tzaj yi a' Jordán, ya'stzun yi cyeru' yi tak'nak Moisés. Poro cyakil yi e'u' yi chusij che'tu' tan oyintzi', yi e'u' yi qui na chixobu', ba'n chixomu' tu chima'clu' ske'j tan kuch'eye'n. ");
INSERT INTO aguBl_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Tajwe'n tan kuch'eye'n, jalen cu'n yil tak' Kataj ketz ka'ama'l tan kujewe'n swutz chi mban i' tan tak'le'n yi cyeru'. Yil ko'c tetz taw yi ama'l yi stk'e' Kataj sketz, kalena's tzun cha'jt tzaju' swutz chi'ama'lu' yi at tzone'j jalajicy' tzaj yi a' Jordán, yi ntak' Moisés yi ẍchakum Ryos scyeru',” stzun Josué bantz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","“Ba'n ta', che'ch. Skabne' cyakil yi na talu', na list o' tan kabene'n kale na tajwitu'. ");
INSERT INTO aguBl_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Nin kocopon jak' ca'wlu' chi banako' te Moisés. Ntina'tz na kaj, yi nink xom Kataj Ryos te'ju' chi banak i' te Moisés. ");
INSERT INTO aguBl_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Ncha'tz, alchok scyetz yi quil tz'oc jak' ca'wlu', tajwe'n tan quime'n. Ntina'tz na kaj kal teru' ¡quiwit! Benk tkanu' ttx'otx',” che'ch bantz tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Itzun bantz, te yi ate' yi e' xonl Israel le ama'l Sitim, nintzun e' ben ẍchakol Josué cob xk'ukwil. Te yi ntaxk chiben, nintzun tal scyetz: “Quibene'nk tan tilwe'n ẍe'n tane'n yi tnum Jericó, tuml yi e'chk ama'l yi at cwent,” stzun i' bantz. Yi chibene'n tan tilwe'n e'chk ama'la'tz cho'n tzun cyopone'ntz xe ca'l jun xna'n yi wi'tz bnol tetz yi na bi'aj Rahab, yi najlij Jericó. Ya'stzun e' cyaj cyent te yi jun ak'bala'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Poro at tzun jun opon tan talche'n stziblal tetz yi rey yi at Jericó. Nin je yol i'e'j: —Te yi akale'ne'j at e' xonl Israel yi ja chu'l tan xk'uke'n yi katnumil, che'ch bantz. ");
INSERT INTO aguBl_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Chibene'n tzun ẍchakol yi rey cobox aj mantarinl tan talche'n tetz Rahab: —Chajwe'e'l tzaj yi e' xonl Israel yi ncho'c xe aca'l. Na ja chu'l tan xk'uke'n yi ka'ama'l, che'ch yi e' aj mantarinla'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Poro yi xna'n nsken che' tew yi cob yaja'tz. Saje'n tzun tlol yi xna'n scyetz yi e' aj mantarinla'tz: —Bintzinin, ja chu'lak cob yaj swuch', poro quinin mme'l intxum tetz yi na' nchisaje't. ");
INSERT INTO aguBl_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Akale'nt cuntu' nche'l, te yi ntaxk jopxij yi e'chk sawan. Ncha'tz qui na wil alo' ncha'jnint. Poro yi nink chiben chanu' tan chitz'amle'n, ẍchitx'amxok cyanu', stzun Rahab ban scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Poro nsken che' tew i' yi cob yaja'tz wi ca'l. Na cho'n cyoque'ntz ta'n jak' e'chk tkan lino yi at wi ca'l tan skejse'n. ");
INSERT INTO aguBl_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Chibene'n tzun yi e' ẍchakum rey tan chitz'amle'n klo'. Cho'n chibene'n tul yi be' yi na opon tzi Jordán kale na chicy'e't wunak. Watok cunin tzun che'l tzaj yi e' sanlara'tz yi jopxe'nt yi e'chk puertil yi tnum. ");
INSERT INTO aguBl_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Itzun bantz, te yi ntaxk chiwit yi e' xk'ukwil, nintzun je' Rahab wi ca'l tan yol scyetz. Itzun taltz: ");
INSERT INTO aguBl_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","—Na wocsaj yi ak'ijt yi e'chk ama'le'j scyeru' tan yi cyeru' chiRyosilu'. Cha'stzun te wi'nin na kaxob scyeru'. Na cyakil yi o' yi najlcho' tzone'j, jalt nin tan kaquime'n tan xo'w. ");
INSERT INTO aguBl_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Ncha'tz kubitnak yi ẍe'n cunin skeje'n yi Cyak Mar ẍchiwutzu' tan Ryos yi cyele'n tzaju' Egipto. Nin kubitnak yi mbi cu'n bajij scye'j Sehón tu Og yi cob chireyil yi e' amorreo yi najlche' jalajcy'en yi a' Jordán. Ja kubit yi ja che'l cu'n cya'nu' swutz. ");
INSERT INTO aguBl_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","”Yi kubital yi xtxolbila'tz, nintzun o' bisuntz ta'n. Cya'l jun yi nink nimsaj c'u'l tan xcyewe'n cu'n ẍchiwutzu' tan oyintzi', na ja el katxum tetz yi cyAjcawilu', yi chiRyosilu', i' taw yi tcya'j tu yi wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","”Ma jalu' bin, chibne'u' jun pawor swetz, chi mimban wetz scye'ju'. Cyale'u' swetz swutz cu'n chiRyosilu' yi quil chinquim cyanu' cyuml yi e' intaj scyuch' yi e' wutzicy yil chu'lu' tan oyintzi' tzone'j. Ej nin cyak' cyenu' jun techl swetz, bantz k'ukewe'n inc'u'l scye'ju'. ");
INSERT INTO aguBl_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Ncha'tz nink chiclax intaj tu intxu', scyuch' yi e' inxibin tu yi e' mas wutzicy, scyuch' cyakil yi e' inxonl. Ko' chicole'u' bin tk'ab quimichil, stzun Rahab bantz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","—Quil bisunu'. Yil tak' Kataj yi ama'le'j sketz, skak'e' kib tan chicolche'nu', penin sk'il che' kacole'u'. Poro qui na kaj yil cyalu' katziblal tetz jun, che'ch yi cob xk'ukwila'tz bantz. ");
INSERT INTO aguBl_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Yi ca'l Rahab cho'n at wi tapij yi at solte'j yi tnum Jericó. Cho'n tzun chicwe'n tzaj yi e' xk'ukwila'tz tan Rahab te akwil. ");
INSERT INTO aguBl_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Poro yi ntaxk chicu' tzaj, nintzun taltz scyetz: —Cho'n chibenku' wi'wtz, bantz quil chijalu' cyak'un yi e' yi na chitzan tan chijoyle'nu'. Cyewe' quibu' wi'wtz tetz ox k'ej, jalen cu'n yil chipakxij yi e' yi nche'l tan chijoyle'nu', kalena's tzun chicy'ajtu' chibe'u', stzun Rahab ban scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Cyaje'n tzun cyaloltz tetz Rahab: —Ntyoẍtu'. Nkaje'n ketz, poro kelepon cu'n te kayol yi ja wi't cyaj kasukil teru'. ");
INSERT INTO aguBl_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","I bin jalu', tbit tzaju' kayole'j: Yil ku'l tzaj tan oyintzi' tzone'j, ba'n c'alquenu' yi jun akwile'j, yi cyak yubil, te yi wentanu'il yi ca'lu' kale kelpone't. Nin ba'n chimol quibu' xe ca'lu', scyuch' yi e' taj xtxu'u', tu yi e' stzicyu' nin yi e' xonl yi taju'. ");
INSERT INTO aguBl_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Alchok scyetz yil tz'el solte'j yi ca'lu', squimok, nin qui'c ketz kapaj te'j kol quim, ma na i' ajpaj te'j. Poro ko at jun sketz ketz yil tz'oc tan chibiyle'n yi e' yi ate' xe ca'lu', o' tzun ajpajtz sbne'. ");
INSERT INTO aguBl_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Poro ncha'tz kol talu' katziblal, qui't kaban tane'n yi nkasuk teru', che'ch yi e' xk'ukwila'tz bantz tetz Rahab. ");
INSERT INTO aguBl_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","—Ba'n, chij Rahab. Nintzun e' jatx quibtz. Yi chicwe'n tzaj, nintzun oc c'alol Rahab yi jun akwila'tz te yi wentanu'il yi ca'l i'. ");
INSERT INTO aguBl_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Inti yi e' xk'ukwila'tz cho'n chibene'ntz wi'wtz, nin cho'n cya'te'n tetz ox k'ej tan ew ib xo'l tze'. Ma yi e' sanlar yi na chitzan tan chijoyle'n nin e' pakxij junt tir tnum na cya'l e' jale't. ");
INSERT INTO aguBl_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Ma yi ticy'e'n yi ox k'eja'tz, nintzun e' cu' tzaj wi'wtz, nin e' cy'ajt chibe' tan quicy'e'n wi a'. Kalena's tzun cyopone'ntz te Josué. Yi cyopone'n, nin baj chitxolil tetz Josué cyakil yi e'chk takle'n yi mbajij scye'j. ");
INSERT INTO aguBl_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Itzun cyaltz: —Ja wi't tak' Kataj cyakil yi e'chk ama'l sketz, na ja kil yi wi'nin na chixob yi e' wunak sketz. ");
INSERT INTO aguBl_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Itzun bantz le junt eklok, chin jalchan cunin tzun e' baj c'ase'n Josué scyuch' cyakil yi e' xonl Israel. Nintzun e' icy'tz swutz yi ama'l Sitim. Cho'n tzun cyopone'ntz stzi' a' Jordán, kale e' cyaj cyent tetz ox k'ej. ");
INSERT INTO aguBl_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Ej nin yi ticy'e'n yi ox k'eja'tz, nintzun e' ben yi chibajxom tan talche'n yi ca'wle'j scyetz: ");
INSERT INTO aguBl_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","“Yil quilninu' yil tz'icy' yi caẍa' kale atit yi quiwel yol Kataj yi kaRyosil, ba'n chixomninu' wutz coc. Na tz'icy'pon chicy'al yi e' pale' yi e' xonl Leví. ");
INSERT INTO aguBl_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","”Tajwe'n chixomninu' wutz coc yi caẍa'a'tz na qui cyajske'nu' yi be' kalel kicy'e't. Poro qui'c rmeril tan cyocomponu' mero wutz coc yi caẍa'. Ma na tajwe'n tan cyaje'n cyen jun kilómetro ẍchixo'lu' tu yi caẍa'a'tz.” ");
INSERT INTO aguBl_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Ncha'tz tal Josué yi xtxolbile'j scyetz yi e' tanum: “Chixanse' quibu', na ek, ẍchaje' Kataj jun chin milawr skawutz.” ");
INSERT INTO aguBl_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Ncha'tz tal i' scyetz yi e' pale': “Chipalninu' yi caẍa', nin ba'n chicy'u' wi a'. Chibajxoku' ẍchiwutz yi e' mas katanum,” stzun Josué. Ya'tz nintzun cyulejtz, nin ben chipalol yi caẍa'. Nin e' bajx cu'ntz ẍchiwutz yi e' mas xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Tlol tzun Kataj tetz Josué: “I bin jalu' Josué, sbne' opon tunintz sjalok mas ak'ej wa'n ẍchiwutz yi atanum. Nin tz'elepon chitxum tetz yi xomchin tzawe'j, chi banakin te Moisés. ");
INSERT INTO aguBl_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Ncha'tz, ba'n ẍcawunin scyetz yi e' pale' yi palol tetz yi caẍa'. Alaj scyetz yil chopon tzi a' Jordán, tajwe'n tan chixcyewe'n cu'n xe a',” stzun Kataj bantz tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Bene'n tzun tlol Josué scyetz yi e' tanum: “Chisajku' tan tbite'n yi yol Kataj yi kaRyosil yi swale' scyeru'. ");
INSERT INTO aguBl_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Yil chibenu' ẍchiwutzu', tz'elepon chitxumu' tetz yi bajxij yi kaRyosil skawutz, yi kaRyosil yi itz' nin tetz. Na tz'ocopon i' tan chilaje'n len cyakil yi e' aj Canaán swutzak chi'ama'l, yi e' hitita, scyuch' yi e' heveo, scyuch' yi e' ferezeo, scyuch' yi e' gergeseo, scyuch' yi e' amorreo, scyuch' yi e' jebuseo. ");
INSERT INTO aguBl_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Tz'elepon chitxumu' tetz yi xomij Kataj yi kaRyosil ske'j, yil quilu' yil bajxij yi caẍa' skawutz yi jun caẍa'a'tz kale atit yi quiwel yi yol i'. Yi jun Kataj a'tz i' taw cyakil ama'l bene'n tzi'n wi munt. ");
INSERT INTO aguBl_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","”Ma jalu', tajwe'n chisicy'e'nu' coblaj yaj ẍchixo'lu'. Jun te jujun k'u'j xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Na yil copon yi quikan yi e' pale' yi cy'anl tetz yi caẍa'a'tz xe a', copon jatxol tib yi a' ẍchuc. Nin stanek yi a' yi na elu'l, nin smole' tib,” stzun Josué bantz. ");
INSERT INTO aguBl_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Icy'e'n tzaj nintzun e' ban yi e' xonl Israel swutz yi ama'l kale ate't. Nin e' bajx cu'n yi e' pale' yi palol tetz yi caẍa'. ");
INSERT INTO aguBl_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Yi cyule'n stzi' a' Jordán, nintzun e' bajx cu'n yi e' pale' yi q'uil tetz yi caẍa' xe a'. (Te yi tiempa'tz nim te'j yi a' na i'tz k'alaj.) ");
INSERT INTO aguBl_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","Yi chicwe'n pone'n xe a' nintzun cu' cabsal tib yi a' yi na elu'l. Tircu'n cwe'n makol tib jalen le tnum Adán, yi at naka'jil yi ama'l Saretán. Ma yi a' yi sken wi't el, cho'n stzaje'n pon le yi mar yi chin c'a' nin tan atz'um nka yi Mar Muerto. Ya'stzun bantz yi cwe'n jatxol tib yi a' Jordán, nin yi quicy'e'n tzaj yi e' xonl Israel. Cho'n tzun quicy'e'n tzaj swutz yi tnum Jericó. ");
INSERT INTO aguBl_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Ma yi e' pale' yi q'uil tetz yi caẍa' cho'n e' cwe'n txiclok nicy'al yi tkambe'n a' yi nsken skej. Cho'n e' cyaje'n cyentz, jalen cu'n quicy'e'n tzaj cyakil yi e' xonl Israel jalajicy' tzaj. Skejenle'n tzun yi ama'l kale e' icy' tzit yi xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Itzun bantz, yi chibaje'nicy' tzaj cyakil yi e' xonl Israel wi a' Jordán. Nintzun tal Katajtz tetz Josué: ");
INSERT INTO aguBl_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Txa'we'e'n coblaj yaj. Txa'e'n jun te jujun k'u'j xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Nin alaj scyetz tan chibene'n tan je'se'n tzaj jun c'ub te jujun le xo'mbil a'. Nin cho'n lje' tzaj cya'n kale txiclche't yi e' pale' yi palol tetz yi caẍa'. Nin cy'ajwoknin, kale cxcyaj cyentwok jalu', nin banwok jun muyc te'j,” stzun Kataj bantz tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Inin tzun tulej Josué-tz quib yi a'lchij tetz. Chije'n tzun xtxa'ol coblaj yaj, jun te jujun k'u'j xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","Nin ben tloltz scyetz: “Quibene'nkwok nicy'al yi xo'mbil a' kale txiclche't yi e' pale' tu yi caẍa', kale atit yi ca'wl Kataj. Nin palwok tzaj jujun c'ub te jujun. Xomok cyen tu' tajlal te coblaj k'u'j o' yi o' xonl kamam Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Yi coblaj c'uba'tz xconk sketz tan banle'n jun muyc tetz jun techl sbne' opon tunintz. Nin tzantzaj yil chijak yi e' kanitxa' yi mbi na elepont yi jun muyca'tz, ");
INSERT INTO aguBl_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","ba'n tzun kaltz scyetz: ‘Yi muyque'j na ẍchaj yi ẍe'n ban yi kicy'e'n tzaj wi a' Jordán. Bajx ticy'e'n tzaj yi caẍa'. Ma ticy'e'n tzaj, nintzun cu' jatxol tib yi a'. Ya'stzun xac yi coblaj c'uba'tz tan tule'n tx'akx tkac'u'l yi ẍe'n cunin ban yi kicy'e'n tzaj wi a' Jordán,’ ko'ch sbne',” stzun Josué bantz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","I nintzun cyuleja'tz, quib yi tal Josué scyetz. Nintzun je' tzaj chicy'al coblaj c'ub le xo'mbil a'. Jujun c'ub te jujun k'u'j xonl Israel. Nintzun ben quicy'altz kale atit chicampament. Nin cu' chiwekoltz, chi tal Kataj tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Poro te yi ntaxk chicy' tzi a' Jordán, nintzun oc Josué tan wekle'n junt muyc tan coblajt c'ub, le xo'mbil a' kale e' xcye' cu'nt yi e' pale' tu yi caẍa'. Nin iẍnin wekije't yi c'uba'tz jalu'. ");
INSERT INTO aguBl_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Ma yi e' pale'a'tz yi q'uil tetz yi caẍa', e' cyaj cyentz le xo'mbil a', jalen yi quicy'e'n tzaj yi e' mas xonl Israel, quib yi talnak Kataj tetz Josué. Bnix cyakil cyak'un quib yi tal Moisés tetz Josué. Ej nin lajke'l nin quicy'e'n tzajtz. ");
INSERT INTO aguBl_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Yi chibaje'nicy' tzaj, kalena's tzun quicy'e'n tzaj yi e' pale' tu yi caẍa'. Nintzun e' cu'-t bajxok ẍchiwutz yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Ncha'tz yi e' xonl Rubén, scyuch' yi e' xonl Gad, nin yi junt k'u'j xonl Manasés, e' bajx cu'ntz tan quich'eye'n yi e' mas chixonl, chi yi talnak Moisés scyetz. Ej nin cy'a'n len chima'cl cya'n tetz oyintzi' yi chibene'n tan quich'eye'n yi chixonl. ");
INSERT INTO aguBl_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","At lo' ca'wunak mil chixone'n yi e'a'tz yi list quitane'n tan oyintzi', nin cho'n bajxche' swutz yi caẍa' tetz Kataj. Cho'n tzun cyopone'ntz wi ẍk'ajlaj naka'jil Jericó. ");
INSERT INTO aguBl_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Te yi tiempa'tz, jale'n nintzun ban mas k'ej Josué ẍchiwutz yi xonl Israel tan Kataj. Cyek ẍchi' Josué, chi e' ban tan teke'n ẍchi' Moisés yi itz' tzaj i'. ");
INSERT INTO aguBl_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Ma yi quicy'e'n tzaj cyakil yi e' xonl Israel jalajicy' tzaj yi a' Jordán, nintzun tal Kataj tetz Josué: ");
INSERT INTO aguBl_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“Alaj scyetz yi e' pale' tan chije'n tzaj tkambil a' tu yi caẍa' tetz yi trat.” ");
INSERT INTO aguBl_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Cawune'nin tzun Josué scyetz yi e' pale'a'tz tan chije'n tzaj. ");
INSERT INTO aguBl_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Itzun bantz, yi chije'n tzaj yi e' pale', nintzun xe'tij junt tir yi a' tan xo'n le xo'mbil. ");
INSERT INTO aguBl_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Le lajuj tajlal yi bajx xaw tetz yi yob, ya'stzun yi quicy'e'n yi e' xonl Israel wi a' Jordán. Cho'n tzun bnixe'n chicampament le ama'l Gilgal yi at swutze'l tzaj Jericó. ");
INSERT INTO aguBl_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Nin cho'n je'n wekol Josué yi coblaj c'uba'tz yi saj quicy'al le xo'mbil a' Jordán. ");
INSERT INTO aguBl_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Yi wi't bnixe'n, nintzun tal scyetz cyakil yi e' tanum: “Yil chijak yi kanitxa' tzantzaj yi mbi na elepont yi cobox c'ube'j, ");
INSERT INTO aguBl_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","ba'n tzun kal scyetz yi ẍe'n cu'n ban yi kicy'e'n tzaj wi a' Jordán. ");
INSERT INTO aguBl_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Nin ba'n katxol scyetz yi ẍe'n cu'n makxe'n yi tzanla' tan Kataj yi kicy'e'n tzaj, chi banak i' scye'j kamam kate' yi quicy'e'n tzaj wi Cyak Mar. ");
INSERT INTO aguBl_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Nin tan yi xtxolbila'se'j, tz'elpon chitxum cyakil yi e' wunak yi ate' bene'n tzi'n wi munt te yi ẍchamil yi ketz Kataj. Tajwe'n bin tan kak'ol k'ej i' sbne' opon tunintz,” stzun Josué bantz scyetz cyakil yi e' tanum. ");
INSERT INTO aguBl_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Itzun bantz, yi quibital yi e' wi'tz cyajcawil yi e' amorreo yi ate' jalajicy' tzaj yi a' Jordán, nintzun e' xobtz. Ncha'tz e' ban yi e' wi'tz cyajcawil yi e' aj Canaán yi najlche' naka'jil yi mar Mediterráneo. Na nin quibit, yi ẍe'n cunin ban Kataj tan cabse'n cu'n yi a' Jordán, yi quicy'e'n tzaj yi e' xonl Israel tibaj. Qui'ct nintzun oc cyajaltz tan makle'n chiwutz na wi'nin chixobe'n scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Ej, ite'n nin tiempa'tz yi tlol Kataj tetz Josué: “Banaj cobox c'ub yi chin cchilu' nin tz'an wi'. Nin banwe' circuncidar junt tir yi e' xonl Israel yi qui banij che' circuncidar.” ");
INSERT INTO aguBl_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Inin tzun tulej Josué-tz. Toque'n tzun i'-tz tan banle'n cobox c'uba'tz. Nintzun octz tan chibanle'n circuncidar yi e' yaj wi ju'wtz Aralot. ");
INSERT INTO aguBl_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Oc Josué tan chibanle'n circuncidar, na cyakil yi e' yaj yi nsken tz'ak chiyob yi cyele'n tzaj Egipto, nsken chiquim le ama'l tz'inunin tu'. ");
INSERT INTO aguBl_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Na cyakil yi e'a'tz yi e' el tzaj Egipto banijche' circuncidar, poro nsken chiquim. Ma yi e' yi e' itz'ij te yi ca'wunak yob, yi e'a'tz yi nchixon le ama'l tz'inunin tu', qui banijche' circuncidar. ");
INSERT INTO aguBl_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","E' xon ca'wunak yob le ama'la'tz tz'inunin tu' tan paj yi quinin chiban tane'n yi tajbil Ryos. Nin cho'n e' quime'n cyakil yi e' yi nsken tz'ak chiyob yi cyele'n tzaj Egipto. Ya'stzun ntulej Ryos tan qui quilol wutz yi balaj ama'l yi suk i' scyetz chimam chite'. ");
INSERT INTO aguBl_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Ma yi chicy'ajl yi e'a'tz, ya'stzun yi oc Josué tan chibanle'n circuncidar. Na cho'n quitz'e'n cyera'tz tbe'. Nin ya'stzun chixel yi e' yi banijche' circuncidar yi nsken chiquim. ");
INSERT INTO aguBl_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Yi chibaje'n circuncidar chicyakil yi yaja'tz. Ta'ste'nin e' cyaje't cyentz jalen cu'n yi tule'n yos scyuch'. ");
INSERT INTO aguBl_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Tlol tzun junt tir Kataj tetz Josué: “Te yi jun xtxolbile'j yi mmaban, qui't tz'el itx'ix ẍchiwutz yi e' aj Egipto.” Cha'stzun te toque'n quen bi' yi jun ama'la'tz tetz Gilgal. Ite'n nin bi'a'tz yi ama'l jalu'. ");
INSERT INTO aguBl_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Cho'n tzun cwe'n chicampament tetz cobox k'ej, yi e' xonl Israela'tz le ama'l Gilgal yi at ẍk'ajlaj cwent Jericó. Itzun yi cwe'n k'ej te yi cyajlaj tajlal yi xawa'tz, nintzun e' ban tane'n yi Pasc. ");
INSERT INTO aguBl_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Baj pam cya'n yi qui'c xtx'amil tu ixi'n triw yi woyi'n. Ma le junt eklok, baj wutz yi cojbil yi at Canaán cya'n. ");
INSERT INTO aguBl_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Jetza'tz tzun qui't baj yi maná cya'n. Na i yi wutz yi cojbil yi at Canaán, ya'stzun baj cya'n. ");
INSERT INTO aguBl_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Itzun bantz, te yi at Josué naka'jil Jericó, nintzun ẍchaj tib jun yaj yi aj oyintzinl swutz i', yi cy'a'n jun spar ta'n le k'ab. Bene'n tzun ẍkansal tib Josué nin ben jakol tetz: —¿Ilu' pe' kacontr, nka cho'n xomij wi'u' ske'j? ");
INSERT INTO aguBl_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","—Cya'l xomije't wetz inwi' te'j. Na yi in wetz in yi wi'tz cyajcawil yi e' sanlar cwent Ryos, stzun yi juna'tz ban. Cwe'n tzun joklok Josué-tz jalen cu'n yi cwe'n pone'n yi wutz wuxtx'otx'. Nintzun ben jakoltz tetz yi jun Sanlara'tz: —¿Mbi'tz tajwe'n tan imbnol ta', na in ẍchakumu'? ¿Mbi nsaj tlol Wajcaw teru'? ");
INSERT INTO aguBl_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","—Ma jalu' Josué, cy'ajwe' len yi axajab, na yi ama'l kale txicl quiẍe't, chin xan nin, stzun yi jun wi'tz Ajcawa'tz bantz tetz Josué. Inin tzun tulej Josuéja'tz, quib yi a'lchij tetz. ");
INSERT INTO aguBl_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Ej itzun yi tnum Jericó, nin jopxij cyakil yi e'chk sawanil, tan yi xo'w yi e' ban yi e' wunak scyetz yi e' xonl Israel. Cya'l nintzun jun ak'lij ama'l tetz tan toque'n nka tan tele'n tul yi jun tnuma'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Itzun tal Kataj Ryos tetz Josué: “Bit tzaj Josué. Ja bixe' wa'n, yi cxcyekwok scye'j yi e' aj Jericó, tuml yi chireyil, scyuch' cyakil yi e' sanlar. ");
INSERT INTO aguBl_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Poro je yi tajwe'n tan ibnolwoke'j: Tajwe'n tan chixone'n yi e' isanlar solte'j yi tnum Jericó, jun tir le jun k'ej, tetz kak k'ej. ");
INSERT INTO aguBl_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Ba'n chibajxij juk pale' swutz yi caẍa', nin ba'n chicy'ajnin juk curnet yi banij tan tuc' cne'r. Ma le juki'n k'ej, tajwe'n tan chixo'mbel juk tir solte'j yi tnum. Nin ba'n cho'c yi e' pale' tan tocse'n yi e'chk curneta'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Yil tzibitwok yil chitx'ixpuj kulil yi curnet, tajwe'n tan iẍch'ine'n icyakil cu'n. Nin junit tz'an iwi'. Ej, nin tan yi xtxolbila'tz, copon woc' yi tapijil yi tnum. Sbejnin tzun cxo'cwoktz tul yi tnum tan chibiyle'n cu'n cyakil yi e' yi ate'-tz,” stzun Ryos bantz tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Toque'n tzun Josué tan chimolche'n yi e' pale', i tzun taltz scyetz: “Chicy'ajninu' yi caẍa' kale atite't yi ca'wl Kataj. Nin ba'n chibajxij juk pale' swutz yi caẍa', yi cy'a'n jujun curnet cya'n yi banij tan tuc' cne'r, swutz yi caẍa'a'tz.” ");
INSERT INTO aguBl_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Nintzun cawun nin scyetz cyakil yi e' wunak tan chixone'n solte'j yi tnum. Ma yi e' sanlar, tajwe'n tan chibajxe'n swutz yi caẍa'. ");
INSERT INTO aguBl_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Inin tzun cyuleja'tz chi tal Josué scyetz. E' bajxe'n cu'n tzun yi juk pale'a'tz, yi na chitzan tan tocse'n yi e'chk curnet swutz yi caẍa' tetz Kataj. ");
INSERT INTO aguBl_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Nin ẍchiwutz yi e' pale'a'tz, bajxche' yi e' sanlar yi cy'a'n len chima'cl cya'n tetz oyintzi'. Nin at jun k'u'j yi cy'a'n chima'cl cya'n yi cho'n xomche' nin wutz coc yi caẍa'. Inti yi juk pale', qui na chitane' tan tocse'n yi e'chk curneta'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Nsken tzun tal Josué yi xtxolbile'j scyetz cyakil yi e' wunak: “Yi e' cyeru', quil chiẍch'inu', nin quil chijilonu'. Jalen cu'n yil wal scyeru', ba'n tzun chiẍch'inu' tetz cu'n chiwaloru'.” ");
INSERT INTO aguBl_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Inin tzun tulej Josué-tz, quib yi tal Ryos. Na nin e' ben tan tak'le'n jun welt solte'j yi tnum Jericó. Nin ben quicy'al yi caẍa'. Te yi cyak'ol yi jun welta'tz, ta'ste'nin e' pakxe't kale na chiwite't. Nin cho'n ticy'e'n ak'baltz cya'n. ");
INSERT INTO aguBl_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","13","Ma le junt eklok, jalchan cu'n tzun chic'ase'ntz. Nintzun ben chicy'al yi e' pale' yi caẍa' tan tak'le'n junt welt solte'j yi tnum. Ncha'tz e' ban yi juk pale' yi cy'a'n e'chk curnet cya'n. Nintzun e' bajx cu'ntz swutz yi caẍa'a'tz. Ncha'tz at sanlar yi bajxche', nin at sanlar yi xomche' nin wutz coc yi caẍa'. Inti yi e' pale', qui na chitane' tan tocse'n yi e'chk curneta'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Ite'n nin e' bantz te yi ca'p k'ej, chi e' ban te yi bajx k'ej, nin e' pakxijt kale ate't. Ya'tz e' bantz tetz kak k'ej. ");
INSERT INTO aguBl_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Ma le juki'n k'ej jalchan cunin tzun e' c'ase'ntz. Nintzun e' bentz tan xo'n solte'j yi tnum. Poro te yi juki'n k'eja'tz juk tir e' bantz tan xo'n solte'j yi tnum. ");
INSERT INTO aguBl_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Itzun te yi toque'n yi curnet le juki'n tir, nintzun cawun nin Josué scyetz cyakil yi e' sanlar: “Chiẍch'inku', na ja wi't tak' Kataj yi tnume'j sketz. ");
INSERT INTO aguBl_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Nin ja cawun yi tajwe'n tan cwe'n kaxitul cyakil yi mbi cu'n at tnum. Nin qui'c jun takle'n nink clax quen ka'n, na ya'stzun yol Kataj swetz. Ntin cu'n Rahab yi wi'tz bnol tetz sclaxok, scyuch' cyakil yi e' yi ate' xe yi tetz ca'l, na ja oc i' tan cyewe'n yi cob xk'ukwil yi ja chu'lak tan tilwe'n yi tnume'j. ");
INSERT INTO aguBl_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Chiq'uicy'lej bin quibu' te yi e'chk takle'n yi at tnum na cy'a'n ilc'ol ta'n. Quil chimacu', nin qui'c cuj tan bene'n chicy'alu' jun takle'n. Na qui na kaj tz'opon jun e'chk takle'n skaxo'l yi at ilc'ol te'j. Kol katz'ame'n, tz'ul kacaws tan Ryos, nin tz'ul sotzaj c'u'lal skawutz kacyakil cu'n. ");
INSERT INTO aguBl_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Poro cyakil yi oro, tu sakal, tu brons nin yi e'chk takle'n yi ch'ich' cu'n, ba'n chicy'aj tzaju' tan kak'ol tetz Kataj. Tajwe'n tz'opon cyanu' le ama'l kale na molxe't yi pwok yi na xcon xe ca'l Kataj,” stzun Josué bantz scyetz cyakil yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Yi toque'n yi e'chk curnet, ja chiẍch'in cyakil yi e' xonl Israel tetz cu'n chiwalor. Cwe'n tzun woc' yi tapij yi at solte'j yi tnum Jericó. Ma yi cwe'n woc', sbejnin cyoque'n len yi e' xonl Israel le tnum. ");
INSERT INTO aguBl_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Tircunin tzun chiquime'n yi e' aj Jericó tan spar. Yi e' yaj, yi e' xna'n, yi e' wutzile'n tijl c'u'lal, nin yi e' xicy, tircu'n chiquime'n. Ncha'tz ban cyakil yi cyawun, yi chiwacẍ, yi chicneru', tu chiburu'. Tircu'n chiquime'n. ");
INSERT INTO aguBl_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Ma Josué, nin ben tlol scyetz yi cob xk'ukwil yi e' ulak tan tilwe'n yi tnum. “Or quibene'nk tan telse'n tzaj yi xna'n yi wi'tz bnol tetz, scyuch' yi e' mas xonl i', chi mmisukwok tetz,” stzun Josué bantz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Chibene'n tzuntz tan cyelsene'l tzaj. El tzaj Rahab cya'n tu yi taj xtxu', tu yi e' titz'un, scyuch' cyakil yi e' mas xonl yi ate' xe tetz ca'l. Cho'n tzun cyopone'n cya'n tul jun ama'l, naka'jil kale ate't yi e' mas xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Toque'n tzun k'a'kl cyakil yi tnum cya'n. Tircu'n yi at tul yi tnuma'tz ja tz'e'. Ntin cu'n yi oro, tu e'chk ma'cl yi banij tan brons, tu ch'ich', qui tz'e' cya'n. Ma na saj quicy'al kale colije't cyakil yi e'chk takle'n yi na xcon tetz Kataj. ");
INSERT INTO aguBl_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Ma tetz Rahab tu yi e' taj, scyuch' yi e' mas xonl i', e' clax tan Josué. E' clax tantu' yi tewal Rahab yi cob xk'ukwil yi ẍcha'ke'n tan xk'uke'n yi tnum Jericó. Cha'stzun te at xonl Rahab skaxo'l yi o' xonl Israel jalu'. ");
INSERT INTO aguBl_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Itzun bantz, bixe' jun xtxolbil tan Josué: “Alchok scyetz yil tz'oc tan xtxicbaje'n yi tnume'j, stz'ak'lok caws tan Ryos, na squimok yi bajx cy'ajl, yi yaj yil tz'oc tan cu'se'n xe' yi tnume'j, nin squimok yi ẍch'i'p, yil tz'oc tan tocse'n e'chk sawanil,” stzun Josué bantz. ");
INSERT INTO aguBl_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Tan cyakil yi mbajij te yi tnum Jericó, ja lajluchax yi xomij Kataj te Josué. Nin ben lo'on yi stziblal i' bene'n tzi'n Canaán. ");
INSERT INTO aguBl_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Itzun bantz, e' juch yi e' xonl Israel quil swutz Ryos, tan paj yi at jun scyeri yi jun k'u'j xonl Judá, nin saj tcy'al cobox takle'n le tnum Jericó yi qui'c cuj tan cyetzal. Na sken a'lchij scyetz yi tajwe'n tan tele'n cu'n tircu'n swutz. Tan yi cobox takle'na'tz yi saj tcy'al, tircu'n tzun xonl Israel jal quil swutz Ryos. Cha'stzun te je'n lajp wi' i' scye'j. Yi juna'tz yi njuch til, i'tz Acán, yi cy'ajl Carmi, nin yi taj Carmi i'tz Zabdi, ma taj Zabdi i'tz Zera, yi e'a'tz e' cu'n xonl Judá. ");
INSERT INTO aguBl_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Itzun yi tele'n cobox k'ej, nintzun e' ben ẍchakol Josué cobox xk'ukwil tan xk'uke'n yi tnum Hay yi at swutz len yi tnum Betel, naka'jil Bet-avén. Chibene'n tzuntz tan tilwe'n yi ama'l, chi tal Josué scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Yi chipakxe'nt nintzun cyaltz tetz Josué: “Qui'c tajwe'n tan chije'n pone'n cyakil yi e' sanlar tan oyintzi' scye'j yi e' aj Hay, ma na tzicu'n tan cob nka ox mil sanlar, na qui'c mas chixone'n yi aj Hay,” che'ch tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","I nintzun tulej Josuéja'tz. Ox ntzi' mil sanlar e' ben ta'n tan oyintzi'. Poro quinin e' xcye', na tircu'n yi ox mila'tz e' el ojk ẍchiwutz yi e' aj Hay. ");
INSERT INTO aguBl_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","E' xcye' yi e' aj Haya'tz tan chiquimse'n e'chk junak waklaj lo' xonl Israel. Nin e' xomnin tan chibiyle'n yi e' mas jalen wutz cu'nak Sebarim. Cha'stzun te wi'nin chixobe'n yi e' xonl Israel scyetz yi e' aj Hay. Qui'tnin tzun chinimsaj chic'u'l tan oyintzi' scye'j. ");
INSERT INTO aguBl_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Yi quibital Josué scyuch' yi e' wi' banl wi' yi cyele'n ojk ẍchiwutz yi e' chicontr, nintzun e' oc tan katzle'n yi be'ch cyetz, nin e' oc tan ẍchitle'n puklaj xo'l chiwi' tan ẍchajle'n yi wi'nin na chibisun. Chicwe'n tzun joklok swutz yi caẍa' tetz Kataj, jalen bene'n k'ej. ");
INSERT INTO aguBl_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Itzun tal Josué tetz Kataj Ryos: —Ta', ¿mbi xac mbanu' yi xtxolbile'j ske'j? Ba'n tcu'n qui'k nku'l tanu' tzone'j. Ko ya'tz kaxac nku'l tanu' tan kaquime'n ẍchik'ab yi e' amorreo. Ba'n tcu'n cho'nk nkacyaj cyen jalaj cy'en Jordán. ");
INSERT INTO aguBl_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Lastum ta', ¿mbil wal jalu'? na cyakil yi e' kasanlar ja che'l ojk ẍchiwutz yi kacontr. ");
INSERT INTO aguBl_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","”Ej, nin yil quibit yi e' aj Canaán scyuch' yi e' mas kacontr yi mbi mbajij, chu'l tan kabiyle'n, nin skasotzok junawes cya'n. Nin ko ya'tz ẍchibne' ske'j ¿ẍe'n lajluchax yi teru' k'eju'? stzun Josué tetz Kataj. ");
INSERT INTO aguBl_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Nintzun saj tlol Ryos tetz Josué: —¡Josué! txiclije'n. ¿Mbi xac joklquiẍ wuxtx'otx'? ");
INSERT INTO aguBl_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Na yi jun xtxolbila'tz ja bajij, tan paj yi ja chijuch yi e' atanum yi quil. Ja chipaj inca'wl, na ja saj cyalk'al cobox takle'n yi ja klo' tz'e' cya'n. E' la'j. Wech na bita'nt cya'n yi at xtxintxal talk'e'n yi e'chk takle'na'tz, ma na ja saj cyalk'al, nin ja cyew xo'l be'ch cyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Cha'stzun te qui'c rmeril tan ixcyewe'n scye'j yi e' icontr. Ej nin ilenin cxelepon ojk ẍchiwutz, na tajwe'n klo' tan iquime'n. Nin ko quil tz'el cu'n yi e'chk takle'na'tz swutz ita'n, tircu'n axwok cxelepon cu'n wa'n swutz. ");
INSERT INTO aguBl_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","Ma jalu' bin Josué. Txicleje'n, molwe' cu'n cyakil yi e' atanum, nin alaj scyetz yi tajwe'n tan chixansal quib, na tajwe'n chu'l tzinwutz ek jalchan. Ej, nin je swale' scyetze'j: In yi Ajcaw tzite'j, nin in iRyosil. Poro ja jal jun chin ilc'ol tzixo'lwok, na ja saj itcy'al e'chk takle'n yi ja klo' el cu'n swutz ita'n. Ej, nin ko quil tz'el cu'n yi e'chk takle'na'tz ita'n swutz, qui'ct rmeril tan ixcyewe'n scye'j icontr. ");
INSERT INTO aguBl_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Ma jalu', na waj yil chu'l cyakil atanum tzinwutz ek jalchan. Nin junale'n chichaj quib yi coblaj k'u'j atanuma'tz tzinwutz, na tzinchaje' jun k'u'j ẍchixo'l yi coblaj k'u'ja'tz. Nin ẍchixo'l yi jun k'u'ja'tz tzinchaje' junt k'u'j yi chixonl quib, nin ẍchixo'l yi e'a'tz tzinchaje' jun najal. Nin tul yi jun najala'tz tzinchaje' yi jun yaj yi aj paj. ");
INSERT INTO aguBl_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Ma yil jal yi jun yaja'tz yi mmicy'an tzaj yi e'chk takle'na'tz yi ja klo' tz'e' stz'e'ok i' tuml yi najal, tuml cyakil yi me'bi'l. Na e' pajol ca'wl tzixo'lwok, na quinin nchiban tane'n yi inca'wl yi walnak, stzun Kataj bantz tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Itzun bantz, le junt eklok. Chin jalchan cunin tzun c'ase'n Josué. Nintzun ben mantartz tan i' tan chichakle'n yi e' tanum. Yi cyule'n, nintzun e' baj cu'n jatxol yi jujun k'u'j e'. Je'n tzun xtxa'ol Kataj yi jun k'u'j xonl Judá. ");
INSERT INTO aguBl_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Chisaje'n tzun ẍchakol Josué yi jun k'u'j xonl Judája'tz, nin ẍchixo'l yi e'a'tz, nin je' xtxa'ol Kataj yi jun k'u'j e' tu Zera, nin ẍchixo'l yi e'a'tz, nin je' xtxa'ol yi najal Zabdi. ");
INSERT INTO aguBl_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Cyopone'n tzun cyakil najal Zabdi, nin ẍchixo'l yi e'a'tz tx'amxij Acán, yi cy'ajl Carmi. Yi Carmi i' cy'ajl Zabdi, nin yi Zabdi, i' cy'ajl Zera. Cyakil yi e'a'tz, e' cu'n xonl Judá. ");
INSERT INTO aguBl_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Nintzun ben tlol Josué tetz Acán: —Ma jalu' yaj, alaj yi mero bintzi swetz. Quil tzajuẍ awib swutz Kataj, yi kaRyosil yi o' xonl Israel. Alaj swetz yi mbi ncu' anuc'ul. Nin quil tzawew tzinwutz, stzun Josué tetz Acán. ");
INSERT INTO aguBl_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Tlol tzun Acán yi mero bintzi: —Bintzi ta', ja injuch wil swutz Kataj yi kaRyosil. Na je mmimbane'j: ");
INSERT INTO aguBl_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Yi kopone'n Jericó, nin wil jun balaj xbu'k yi cho'n sajnak Babilonia, nintzun saj wucy'altz. Ncha'tz saj wucy'al cob cient piẍ sakal tu jun chin lepaj oro, at lo' jun liwr talal. Na nin el quen walma' te'j, cha'stzun te saje'n wucy'altz. Cho'n tzun cwe'n inmukul xe inmantial tan tewe'n, stzun Acán tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Chibene'n tzun ẍchakol Josué cobox chakum tan tilwe'n le mantial Acán. Lajke'l nintzun e' bene'ntz tan tilwe'n. Nin cho'n nin jale'ntz cyak'un. Cho'n mukij yi balaj xbu'ka'tz nicy'al yi mantial, nin cho'n at cyen yi sakal tu yi oro tzak' yi balaj xbu'ka'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Yi je'n tzaj quicy'al yi e'chk takle'na'tz yi ewa'n xe yi mantial, nintzun saj chicy'al swutz Josué nin ẍchiwutz yi e' mas xonl Israel. Nin ben chicy'al swutz Kataj Ryos. ");
INSERT INTO aguBl_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Cawune'nin tzun Josué scyetz cyakil yi xonl Israel tan chibene'n tan stz'amle'n Acán, nin ben chicy'altz tuml yi sakal, tu yi mant tu yi jun piẍ oro. Ncha'tz e' tx'amxij yi e' cy'ajl, scyuch' yi e' me'l, scyuch' cyakil yi e' tawun, yi e' wacẍ, ẍchej, cneru', tu cyakil yi tetz mantial kale najlche't. Nintzun ben quicy'altz le tal joco'j yi na bi'aj Acor. ");
INSERT INTO aguBl_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Yi cyopone'n Acor, nintzun ben tlol Josué-tz tetz Acán: —Yaj, ¿nxac mawak' bis sketz? Ma jalu', stk'e' Kataj yi acaws, stzun Josué tetz. Cyoque'n tzun cyakil yi e' xonl Israel tan chibiyle'n cu'n Acán tan c'ub. Yi wi't chilo'one'n nintzun e' octz tan stz'e'se'n yi chiwankil. ");
INSERT INTO aguBl_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Ej nin tibaj kale e' tz'e't nintzun je' tenu'n jun c'oloj c'ub. Iẍnin atit yi c'uba'tz jalu'. Cha'stzun te toque'n yi bi' yi jun tal joco'ja'tz tetz Acor, yi na elepont: “Sotzaj c'u'lal”. Nin yi ama'la'tz, ite'n nin bi'a'tz jalu'. Ej nin tan yi xtxolbila'tz, qui't nchi'ch mas c'u'l Ryos scye'j yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Itzun bantz, nintzun talt Kataj tetz Josué: —Quil cxob, nin quil cẍbisun. Cy'ajwe' nin cyakil yi e' sanlar tan oyintzi' scye'j yi e' aj Hay. Swak'e' ama'l tzitetz tan ixcyewe'n scye'j tuml chireyil, scyuch' cyakil yi e' wunak yi ate'-tz. Nin itetz sbne' cyakil yi chi'ama'l. ");
INSERT INTO aguBl_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Cho'n cu'n che' itulejwok chi itulejwok yi tnum Jericó. Ntin yi chime'bi'l tuml cyakil yi cyawun itetz sbne'. Ej nin ewun cu'n chocopon cobox k'u'j sanlar wutz coc yi tnum. ");
INSERT INTO aguBl_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","I nintzun tulej Josuéja'tz. Nin e' je' xtxa'ol junaklaj mil sanlar. Ej nin lak'bal tzun chiwekol quib, nintzun e' bentz tan oyintzi' scye'j yi e' aj Hay. ");
INSERT INTO aguBl_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","Yi ntaxk chiben, nintzun cawun Josué scye'j. Itzun taltz: “Bitwok tzaj, ewwok itib wutz coc yi tnum. Nin list cuntunin axwoktz yil tz'opon oril. ");
INSERT INTO aguBl_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Ma yi o' ketz scyuch' yi e' mas sanlar, nkaben tan xuxi'n swutz yi tnum. Nin yil che'l tzaj nil tan kabiyle'n klo', kelpon ojk ẍchiwutz, chi ban yi bajx tir. ");
INSERT INTO aguBl_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Yil ke'l tzaj ojk ketz, ẍchitxume' yi ja wi't ke'l ojk junt tir ẍchiwutz. ");
INSERT INTO aguBl_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","Itzun yil chixom tzaj tan katz'amle'n ketz, ba'n tzun cxo'cwok quentz tnum tan chibiyle'n. Skaxcyek scye'j, na ja wi't tak' Kataj yi kaRyosil yi jun tnuma'tz sketz. ");
INSERT INTO aguBl_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Yil cxo'cwok tnum, ba'n tz'oc k'a'kl cyakil yi at, chi ntal Kataj sketz.” ");
INSERT INTO aguBl_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Chibene'n tzun yi e' sanlara'tz tan ew ib wutz coc yi tnum Hay tu Betel. Ma tetz Josué, nin cyaj cyentz te yi jun ak'bala'tz ẍchixo'l e' mas sanlar kale ate't nin. ");
INSERT INTO aguBl_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Itzun le junt eklok, jalchan cunin c'ase'n Josué tan chimolche'n yi e' sanlar yi ate' cyen. Yi wi't chimolxe'n, nintzun bajx cu'n Josué scyuch' yi e' wi' banl wi' ẍchiwutz. Chibene'n tzuntz tan oyintzi' scye'j yi e' aj Hay. ");
INSERT INTO aguBl_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Cho'n tzun cyopone'ntz swutz yi tnum, nin e' cyaj cyentz tibaje'n mu'ẍ yi tnuma'tz. Jalt cuntu' jun tal joco'j cyaj cyentz ẍchixo'l tu yi tnum Hay. ");
INSERT INTO aguBl_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Nsken che' tew Josué e'chk o' lo' mil sanlar txo'l Betel tu Hay. ");
INSERT INTO aguBl_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Na cob cuntu' e' el yi e' sanlar yi xomche' te Josué. At jun k'u'j yi cho'n cyewa'n quib swutz quen yi tnum. Ma yi junt k'u'j, cho'n ate' tibaje'n yi tnum. Itzun yi jun k'u'j kale xomije't Josué, yi ate' tibaje'n yi tnum, lak'bal tzun quicy'e'n junt wek. Cho'n tzun cyopone'ntz nicy'al yi tal joco'j yi at swutz yi tnum. ");
INSERT INTO aguBl_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Itzun yi tilol yi rey cwent Hay yi nsken chopon yi e' xonl Israel tan oyintzi' scye'j, nintzun e' el tzajtz tan oyintzi' scye'j yi e' yi ate' tjoco'j. Quinin tz'icy' scyetz yi ko ate' mas sanlar cwent Israel cyewa'n quib swutz quen yi tnum. ");
INSERT INTO aguBl_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Cyele'n tzun ojk cyetz Josué tane'n. Chicy'al tzun yi be' yi na ben le ama'l tz'inunin tu'. ");
INSERT INTO aguBl_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Chicyakil cu'n yi e' sanlar cwent Hay e' xomnin tan chitz'amle'n Josué scyuch' yi e' mas sanlara'tz. Nin bene'nin e' bantz joylaj te yi tnum. ");
INSERT INTO aguBl_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Nk'e'tz ntin yi sanlar cwent Hay e' xomnin tan chitz'amle'n, ma na ncha'tz yi e' sanlar cwent Betel. Tircu'n e' bene'n. Cyaj quen tu' quilol yi cyetz chitnumil ẍchuc. ");
INSERT INTO aguBl_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Bene'n tzun tlol Katajtz tetz Josué: “Banaj yi techl tan talche'n scyetz yi e' mas sanlar tan cyoque'n tnum Hay, na ja wi't wak' ama'l tan icambalwok,” stzun Kataj bantz. Toque'n tzun yi jun techla'tz tan Josué tan cyoque'n yi e' mas sanlar yi cyewa'n quib wutz coc yi tnum tan oyintzi'. ");
INSERT INTO aguBl_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Cyele'n tzaj tzun yi e' sanlar yi cyewa'n quib swutz quen yi tnum. Nintzun e' octz tul yi tnum, nin oc k'a'kltz cya'n. ");
INSERT INTO aguBl_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Itzun yi quilol yi e' sanlar cwent Hay yi na tzan k'a'kl chitnumil nintzun e' el ojk, poro cya'l nin e' aj nint, na nin e' saj yi e' xonl Israel yi nsken che'l ojk tane'n tan chibiyle'n. ");
INSERT INTO aguBl_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Ya'stzun bantz na yi bene'n quilol Josué yi na tzan k'a'kl yi tnum, nintzun e' pakxijtz tan chibiyle'n yi e' sanlar cwent Hay. ");
INSERT INTO aguBl_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Ncha'tz e' bant yi e' yi ocsan k'a'kl yi tnum, nin e' sajt tan quich'eye'n yi e' mas sanlar cwent Israel. Tircu'n tzun chiquime'n yi e' aj Hay. Cya'l nin e' aj nint na nsken chicyaj chinicy'al. ");
INSERT INTO aguBl_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Ntin cu'n yi rey cwent Hay qui quim. Ma na ntin xtx'amxe'n cya'n, nin ben chicy'al swutz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Te yi nsken chiquim chicyakil yi e' aj Hay yi e' xomnin tan chibiyle'n klo' yi e' xonl Israel tane'n, nintzun e' pakxijt yi e' xonl Israela'tz le tnum Hay tan chibiyle'n yi e' yi ate' cyentz. ");
INSERT INTO aguBl_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Te yi jun k'eja'tz e' quim coblaj mil yaj scyuch' cyakil xna'n cwent Hay. ");
INSERT INTO aguBl_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Na quinin e' tane' yi e' xonl Israel tan oyintzi', jalen cu'n yi chiquime'n tircu'n yi e' wunaka'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Ncha'tz cyetzaj yi e' xonl Israel tircu'n yi cyawun, tu yi chime'bi'l yi e' aj Hay. Na ya'stzun ca'wl ak'lij tetz Josué tan Ryos. ");
INSERT INTO aguBl_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Kalena's tzun cawune'nin Josué-tz tan stz'e'se'n tircu'n yi tnum. Nin tircu'n cwe'n woc', chi tane'n jalu'. ");
INSERT INTO aguBl_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Ncha'tz cawunin Josué tan je'n ch'imba'n yi rey cwent Hay jak' tze'. Cho'n tzun quime'ntz. Baj k'ejtz tan yi wankil jak' tze'. Jalen cwe'n k'ej cwe'n tzajtz cya'n. Nin cho'n mukxe'ntz tzi puertil yi tnum. Yi mukxe'n, nintzun je' tenu'n nicy' c'ub tibaj. Nin iẍnin tenune't yi e'chk c'uba'tz jalu'. ");
INSERT INTO aguBl_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Yi baje'n yi xtxolbila'se'j, nintzun ben Josué-tz tan banle'n jun patbil chitx'ixwatz tetz Kataj yi kaRyosil, tibaj yi ju'wtz yi na bi'aj Ebal. ");
INSERT INTO aguBl_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","Bnix cyakil, quib yi talnak Moisés, yi ẍchakum Kataj. Ncha'tz bnix yi jun altara'tz, quib yi na tal yi liwr tetz yi ley Moisés, yi na tal: “Banaj jun patbil itx'ixwatz yi c'ub cu'n tz'an, nin quil se'lij yi c'uba'tz,” stzun Ryos banak cyen. Cyoque'n tzuntz tan pate'n chitx'ixwatz tibaj. Ncha'tz cyak' cyoy yi nxcon tan chibansal quib tu Kataj. ");
INSERT INTO aguBl_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Ma tetz Josué, nintzun octz tan stz'ibe'n yi ley Moisés te e'chk c'uba'tz yi xcon tan banle'n yi patbil chitx'ixwatza'tz. Ẍchiwutz cu'n cyakil yi e' xonl Israel yi toque'n i' tan banle'n. ");
INSERT INTO aguBl_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Ma cyakil yi e' xonl Israel scyuch' yi e' yi nk'e'tz e' xonl Israel, e' oc txiclok xlajak yi caẍa' kale atit yi ca'wl Kataj. Ncha'tz ate' cyakil yi e' wi' banl wi' scyuch' yi e' mas bajxom, scyuch' yi e' pujul xtisya' yi ate' ẍchixo'l. Cho'n tzun e' xcyewe'n cu'ntz ẍchiwutz yi e' pale' yi q'uil tetz yi caẍa' tan tk'ol Kataj banl squibaj. At jun tx'akaj yi cho'n ate' xe wutz Gerizim, nin junt tx'akaj yi cho'n ate' xe wutz Ebal. Tircu'n na chixmayin tzaj te yi caẍa', chi alijt cyen tan Moisés. ");
INSERT INTO aguBl_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Toque'n tzun Josué tan si'le'n cyakil e'chk yol yi tz'iba'n le liwr tetz yi ley. Si'lej i' yi e'chk takle'n balaj yi suknak Kataj scyetz. Ncha'tz si'lej i' yi chicaws yi ko quil chixom te yi yol Ryos. ");
INSERT INTO aguBl_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Qui'c nin jun yol yi tz'iba'nt cyen tan Moisés yi qui'k si'lej Josué ẍchiwutz cyakil yi e' xonl Israel. Na ja si'lej i' yi jun liwra'tz ẍchiwutz cyakil yi e' xna'n, nin ẍchiwutz cyakil yi e' nitxa', nin ẍchiwutz cyakil yi e' yi nk'e'tz e' xonl Israel yi ate' ẍchixo'l. ");
INSERT INTO aguBl_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Itzun bantz, yi quibital cyakil yi e' ajcaw yi ate' jalajicy' tzaj yi a' Jordán, yi mbi cu'n na chitzan yi xonl Israel tan banle'n. Nintzun e' mol quibtz scyuch' yi e' yi ate' je'n tzi'n, scyuch' yi e' yi ate' naka'jil yi mar Mediterráneo, scyuch' yi e' yi ate' nintz Líbano. Yi e'a'tz yi e' mol quib, i'tz yi cyajcawil yi e' hitita, scyuch' yi e' amorreo, scyuch' e' xonl Canaán, scyuch' e' ferezeo, scyuch' yi e' heveo, nin scyuch' yi e' jebuseo. ");
INSERT INTO aguBl_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","Junit tzun ban chitxumu'n tan oyintzi' te Josué scyuch' yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Poro i tzun yi e' heveo yi najlche' Gabaón, nin quibit yi mbi cu'n ban yi tnum Jericó tu yi tnum Hay cyak'un yi xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","Cwe'n tzun chitxumul jun cyajtza'kl, nintzun e' bentz tan chisuble'n yi chibajxom yi xonl Israel. Itzun yi chibene'n, nin ben quicy'al e'chk bi'ẍ sac tetz cu'lbil be'ch cyetz. Nin ben quicy'al e'chk bi'ẍ tz'u'm tetz cu'lbil quic'a'. Cyakil yi e'chk takle'n yi ben quicy'al, nternin katznakt, nin ocnakt cha'bil te'jak. ");
INSERT INTO aguBl_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Ncha'tz ocnin e'chk be'ch cyetz yi katza'l. Nin ocnin yi e'chk chixajab yi nternin bi'ẍt. Ncha'tz ben quicy'al wotz' tetz chiwa' yi nternin ximt. Nintzun e' bentz. ");
INSERT INTO aguBl_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Yi cyopone'n Gilgal, kale chimolone't quib Josué scyuch' yi e' mas xonl Israel, nintzun cyaltz scyetz. —Yi o' ketz cho'n nkasaj joylaj. ¿Qui' polo' cyeru' nink kaban jun katrat scyuch'u'? che'ch tzun bantz scyetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","—¿Nk'e'tz pe' naka'j nchisaje'tu'? Na ko naka'j nchisaje'tu' qui'c rmeril tan bnixe'n jun katrat scyuch'u', stzun Josué scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","—Qui' ta', yi o' ketz, ja ku'l tan talche'n yi list ato't tan koque'n tetz chimosu'. Bene'n tzun jakol junt tir Josué scyetz: —¿Na' tzun scyetz e'u'? Nin cyale'u' yi bintzi yi ¿na' nchisite'tu'? ");
INSERT INTO aguBl_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","—Yi o' ketz cho'n nkasaj joylaj, nin ja ku'l tan koque'n tetz chichakumu'. Na ja kubit yi wi'nin ẍchamil yi cyeru' chiRyosilu'. Na wi'nin e'chk takle'n bnix ta'n tzone'j, nin le ama'l Egipto. ");
INSERT INTO aguBl_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","Ncha'tz ja kubit, yi ẍe'n cunin tulej i' yi cob rey cwent e' amorreo yi quimnake' jalaj cy'en yi a' Jordán, yi Sehón ajcaw cwent Hesbón, tu Og yi ajcaw cwent Basán, yi cho'n najlche' sajle'n le luwar yi na bi'aj Astarot. ");
INSERT INTO aguBl_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Nin yi kubital cyakil yi xtxolbila'se'j, nintzun bixe' cyak'un yi e' kabajxom, scyuch' yi e' kawunakil tan kasaje'n scye'ju'. Je tzun cyal sketze'j: “Quibene'nk scye'j e' xonl Israel. Cy'ajwok nin iwa'. Nin alwok quen scyetz: ‘O' chixconsbe'tzu'. Nin list kutane'n tan kabnol jun trat scyuch'u',’ che'ch bantz sketz.” ");
INSERT INTO aguBl_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Yi kele'n tzaj tan chijoyle'nu', inak cu'n bnixe'n tzaj yi kawa'. Ma jalu' nternin wotz't, nin nternin ximt. ");
INSERT INTO aguBl_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Ncha'tz yi tz'u'm kale at cu'nt yi kuc'a', chin ac'aj nin yi kasaje'n. Ma jalu' nternin bi'ẍt. Ncha'tz yi e'chk be'ch ketz tu kaxajab. Nim cunin be' mbaj kaxo'mbel tan kule'n scyuch'u', che'ch tzun yi cobox yaja'tz bantz. ");
INSERT INTO aguBl_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","E' oc tzun yi e' yaja'tz tan suke'n mu'ẍ waj scyetz chibajxom yi e' xonl Israel, nin bajtz cyak'un. Poro quinin e' jak tetz Kataj yi ko ba'n yil baj yi waja'tz cya'n nka qui'. ");
INSERT INTO aguBl_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Nintzun cujij Josué tan bnixe'n jun chitrat scyuch' yi e'a'tz, tan qui cyoque'n tan chibiyle'n yi e' wunaka'tz. Nin cyakil yi e' wi'tz cyajcawil yi xonl Israel, e' suk ite'n nin yola'tz scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Poro yi tele'n ox k'ej, kalena's tzun quibital yi e' xonl Israel. Yi e' wunaka'tz yi e' ulak scye'j, e' te'n chiwisin, na cho'n najlche' chinaka'jil. ");
INSERT INTO aguBl_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Chibene'n tzun yi xonl Israel tan chijoyle'n yi e' wunaka'tz. Jalen le toxi'n k'ej cyopone'n kale najlche't. Na e' aj Gabaón, aj Cafira, aj Beerot nin aj Quiriat-jearim. ");
INSERT INTO aguBl_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Yi chijale'n yi e' wunaka'tz cya'n, quinin e' oc tan chibiyle'n, na nsken bixe' jun chitrat scyuch' yi qui'c rmeril tan cyoque'n tan chibiyle'n. Na yi jun trata'tz cho'n bnixe'n swutz Kataj yi kaRyosil. Tan yi xtxolbile'j nintzun xe'tij yol ẍchixo'l yi e' xonl Israel, yi ploj nchiban yi chibajxom. ");
INSERT INTO aguBl_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Poro nintzun cyal yi e' bajxoma'tz scyetz yi e' mas xonl Israel: —Bintzi lo' yi na cyalu', poro ja bnix katrat scyuch'. Ej, nin swutz cunin Kataj yi kaRyosil yi nkasuk kayol scyetz. Ej nin yi kayol yi nkasuk scyetz i'tz, yi quil che' kabiy. Nin qui'c cuj tan kabnol mal scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Quil che' kabiy tan qui kajuchul kil swutz Kataj yi kaRyosil. Na ja wi't kasuk kayol. Nin kol kapaj yi mbixe' kak'un, tz'ul kacaws tan Kataj, che'ch tzun bantz. ");
INSERT INTO aguBl_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Ncha'tz e' cawun nin: “Qui'c cuj tan koque'n tan chibiyle'n yi e' wunaka'tz. Na ja chibixe' ka'n tetz kaswilum, nin tetz katz'ya'om.” Tan yi xtxolbila'se'j yi qui't e' oc tan chibiyle'n, e' el cu'n yi e' bajxoma'tz te chiyol yi chisuk scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Che' ẍchakol tzun Josué yi e' aj Gabaóna'tz. Nintzun jaktz scyetz: —¿Nxac ncxo'cwok tan kasuble'n? ¿Nxac mmitalwok sketz yi cho'n ncsajwok joylaj? Na axwok te'n kawisin. ");
INSERT INTO aguBl_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Ma jalu', tan yi iya'pl yi mmibanwok ske'j skak'e' icaws. Axwok esclaw sbne' opon tunintz. Axwok aj swilum, nin aj tz'ya'om sbne' le ca'l Ryos. ");
INSERT INTO aguBl_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Itzun cyaltz tetz Josué: —Ja kaban yi xtxolbila'tz, na ja kaxob scyeru', ko tzun kaquim cyanu', na bita'nt ka'n yi tak'nak yi chiRyosilu' cyakil yi e'chk ama'le'j scyeru'. Na ya'stzun talnak i' tetz Moisés yi ẍchakum Kataj. Ej, nin ncha'tz tal i' tetz Moisés, yi tajwe'n tan kaquime'n cyakil yi o' yi najlcho' swutz yi e'chk ama'le'j. ");
INSERT INTO aguBl_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Cha'stzun te ncu' katxumul yi jun kajtza'kla'tz. Ma jalu' bin, ja bin ko'c chicwentu'. Chibne'u' ske'j quib yi mbixe' cyanu', che'ch bantz tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Quinintzun tak' Josué ama'l scyetz yi e' mas xonl Israel tan cyoque'n tan chibiyle'n yi e' wunaka'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Poro yi cyak'un yi e' wunaka'tz ban i'tz, tan swili'n nin tan bale'n quic'a' yi e' xonl Israel. Ncha'tz e' oc tan tak'le'n cyakil yi si', tu a' yi na xcon tan banle'n chimunl swutz yi patbil chitx'ixwatz, le ama'l kale talwit Ryos yi tajwe'n tan chibnol chimunl swutz. Jetza'tz tzun cyocle'n te yi jun ak'una'tz, nin ite'n nin cyak'una'tz jalu'. ");
INSERT INTO aguBl_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","2","Itzun bantz, yi tbital Adonisedec, rey cwent Jerusalén, yi mbi cu'n bajij te yi tnum Hay tu yi chireyil, nintzun xobtz. Ncha'tz tbit i' yi mbi cu'n bajij te yi tnum Jericó tu yi chireyil. Ej nin mast cunin xobe'ntz yi tbital yi mbi nchiban yi e' aj Gabaón, yi sken cho'c jak' chica'wl yi e' xonl Israel, wech na i'tz jun chin wutzile'n tnum, nin icy'nakt cu'n swutz Hay, nin chin cham nin e' tan oyintzi'. Poro nsken chicy' xomok scye'j yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Bene'n tzun mantar tan yi rey Adonisedec te Hoham yi rey cwent Hebrón, tu Piream yi rey cwent Jarmut, tu Jafía, yi rey cwent Laquis. Ej, nin ncha'tz te Debir, yi rey cwent Eglón. Ej, nin je yol i'e'j: ");
INSERT INTO aguBl_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“Chibne'u' pawor, chisajku' tan wuch'eye'n tan oyintzi' scye'j yi e' aj Gabaón. Na ja bnix jun chitrat tu Josué scyuch' yi e' xonl Israel,” stzun i' ban nintz scyetz yi e' ajcawa'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Je'n tzun chimolol quib yi o' reya'tz tan oyintzi' scye'j yi e' aj Gabaón. Yi o' reya'tz i'tz yi rey cwent Jerusalén, tu yi rey cwent Hebrón, tu yi rey cwent Jarmut, tu yi rey cwent Laquis. Ej nin ncha'tz yi rey cwent Eglón. Nintzun e' bentz scyuch' chisanlar tan cyopone'n naka'jil Gabaón. Itzun yi cyopone'n, nintzun e' ban list quib tan oyintzi' scye'j yi e' aj Gabaóna'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Yi quilol yi e' aj Gabaón yi nsken chopon yi e' reya'tz tan oyintzi' scye'j, nintzun ben mantartz cya'n tan talche'n tetz Josué yi ate' Gilgal. Itzun cyaltz: “Chibne'u' pawor tan kuch'eye'n. Chisajku' jalcu'n tan kacolche'n, na cyakil yi e' ajcaw scye'j yi e' amorreo yi najlche' wi'wtz, ja je' chimolol quib tan oyintzi' ske'j,” che'ch tzun bantz tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Yi tbital Josué, nintzun e' bentz scyuch' yi e' tetz sanlar tan quich'eye'n. ");
INSERT INTO aguBl_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Nintzun tal Kataj tetz Josué: “Quil cxob scyetz, na ja wi't wak' ama'l tan ixcyewe'n scye'j. Nin qui'c nin jun yi nink snimsaj tib tan oyintzi' tzite'j,” stzun Kataj bantz tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Qui cunin tzun tz'icy' scyetz yi e' amorreo yi cyopone'n Josué scyuch' yi e' tetz sanlar, na baj cunin ak'bal cya'n tan xo'n tan cyopone'n. ");
INSERT INTO aguBl_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Toque'n tzun tk'ol Kataj jun chin xo'w scyetz yi e' amorreo-a'tz, na yi bene'n quilol yi sken chu'l yi e' xonl Israel tan oyintzi' scye'j, qui't e' nimsaj chic'u'l tan oyintzi'. Cha'stzun te wi'nin e', e' quim tan Josué scyuch' yi e' tetz sanlar le ama'l Gabaón. Ma yi bene'n quilol yi cyele'n ojk yi e' mas tul yi be' yi na copon Bet-horón, nintzun e' ben xomoktz tan chitz'amle'n, nin tan chiquimse'n cu'n jalen yi cyopone'n Aseca nin Maceda. ");
INSERT INTO aguBl_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Te yi cyele'n ojk yi e' amorreo ẍchiwutz yi e' xonl Israel wutz cu'nak Bet-horón, nintzun saj kojol Kataj jun chin c'ub a'bal ẍchiwi' tan chibiyle'n cu'n. Mast cu'n e' quim tan yi c'ub a'bala'tz swutz yi e' quim cyak'un yi e' xonl Israel tan spar. ");
INSERT INTO aguBl_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Ej, itzun bantz, te yi k'eja'tz yi tk'ol Kataj ama'l scyetz yi e' xonl Israel tan chixcyewe'n scye'j yi e' amorreo, nintzun jilon Josué tetz Kataj, ẍchiwutz cu'n yi e' xonl Israel. Ej, nin je yol i'e'j: “Ta', na waj yil tane' yi k'ej tibaj yi tnum Gabaón. Ma yi xaw, tibaj yi ẍk'ajlaj Ajalón.” ");
INSERT INTO aguBl_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Nintzun tane' yi k'ejtz. Ncha'tz ban yi xaw. Jalen cu'n yi quicy'sal yi e' xonl Israel chic'u'l te chicontr. ¿Iẍkaj qui tzunk tz'iba'n cyen yi xtxolbile'j tul yi liwr yi na bi'aj “Justo” nka “Jaser”? Jun lo' k'ej tane' yi ke'j tcya'j. ");
INSERT INTO aguBl_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Qui'c nin junt k'ej cho'nk banaktz, nka cho'nk sbne'-tz chi yi jun k'eja'tz. Na nin ban tane'n Kataj yi mbi njak jun yaja'tz tetz. Na Kataj te'nin oc tan oyintzi' tan quich'eye'n yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Yi stzaje'n wi' yi oyintzi' nintzun e' pakxij Josué scyuch' cyakil yi e' sanlar cwent Israel le tnum Gilgal kale e' saje't. ");
INSERT INTO aguBl_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Ma yi o' reya'tz yi je' chimolol quib tan oyintzi' scye'j yi e' aj Gabaóna'tz nin e' el ojk. Cho'n tzun cyewal quib tul jun picy le ama'l Maceda. ");
INSERT INTO aguBl_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","Poro nin a'lchij stziblaltz tetz Josué yi cho'n cyewa'n quib yi o' reya'tz le yi jun picya'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","Bene'n tzun tlol Josué scyetz yi e' yi oponsan yi stziblal: “Wekwoke'n c'ub stzi' yi jun picya'tz kale ate't yi o' reya'tz. Nin chicyajk cyen cobox sanlar ita'n stzi', tan chiq'uicy'le'n bantz quil che'l ojk. ");
INSERT INTO aguBl_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Ma ax itetz quil xtane' tan chibiyle'n kacontr, ma na xomwoknin wutz chicoc, nin biywoke' cu'n chicyakil. Quil tzitak'wok ama'l tan chipakxe'n le chitnumil, na yi Kataj ja wi't tak' i' ama'l sketz tan kaxcyewe'n scye'j,” stzun Josué bantz. ");
INSERT INTO aguBl_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Ya'stzun bantz yi chixcyewe'n Josué scyuch' yi e' xonl Israel tan chibiyle'n tircu'n yi e' chicontra'tz. Ma yi e' yi qui e' quim, cho'n tzun baj cyewal quib lak chitnumil yi at tapij te'j. ");
INSERT INTO aguBl_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Qui'c nintzun jun sanlar xonl Israel yi q'uixpnak yi chibaj pakxe'n tzaj Maceba, kale atit Josué. Ej, nin cya'l nin jun scyeri chicontr yi nink nimsaj c'u'l tan chijisle'n. ");
INSERT INTO aguBl_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Nintzun ben tlol Josué scyetz yi e' sanlar yi e' cyaj cyen tan q'uicy'le'n yi jun picya'tz: “Jakwoke'n stzi' yi picy, nin cy'ajwoke'l tzaj yi o' reya'tz yi cyewa'n quib tul.” ");
INSERT INTO aguBl_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Nintzun el tzaj quicy'al yi o' reya'tz. El tzaj yi rey cwent Jerusalén. Ncha'tz el tzaj yi rey cwent Hebrón. Ncha'tz el tzaj yi rey cwent Jarmut, tuml yi rey cwent Laquis, nin yi rey tetz Eglón. ");
INSERT INTO aguBl_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Ma yi cyopone'n ticy'le'n swutz Josué nintzun e' saj ẍchakol chicyakil yi e' yaj xonl Israel, ncha'tz ben tloltz scyetz yi cyajcawil yi e' sanlar cwent Israel: “Chiẍkank tzaj quibu'. Nin cyak'e'nu' chikanu' te chikul yi cobox reye'j.” Nintzun saj chiẍkansal quibtz, nin je' cyak'ol chikan te chikul yi o' reya'tz, yi joklche' wuxtx'otx'. ");
INSERT INTO aguBl_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Nintzun ben tlol Josué-tz scyetz yi e' sanlara'tz: “Quil cxbisun, nin quil cxobwok. Ma na quiwit, nin txiclenwok cu'n. Na cho'n nin stuleje' Kataj cyakil yi e' yi na chi'ch chic'u'l scye'ju'.” ");
INSERT INTO aguBl_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Ma yi wi't tlol Josué yi e'chk xtxolbila'tz, nin bentz tan chibiyle'n yi o' reya'tz. Yi chiquime'n, nintzun e' je' ẍch'imbaltz jak' tze'. Ate' nintz jalen cwe'n k'ej. ");
INSERT INTO aguBl_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Bene'n tlen tu' atit k'ej yi cawune'nin Josué tan chicu'se'n tzaj. Nintzun e' oc cyen junt tir le yi picy kale e' el tzit. Yi cyoque'n cyen, nintzun oc chin wutzile'n c'ubtz cya'n tan jople'n yi picya'tz. Iẍnin at e'chk c'uba'tz jalu'. ");
INSERT INTO aguBl_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Ej i tzun yi chiquime'n yi o' reya'tz ite'n nin k'eja'tz cambal Josué yi tnum Maceda. Tircu'n e' quime'n tan spar. Ncha'tz quim yi chireyil, nin cho'n cunin ban chi ban yi rey cwent Jericó. ");
INSERT INTO aguBl_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Yi ticy'e'n Josué Maceda scyuch' yi e' xonl Israel, cho'n tzun cyopone'ntz le ama'l Libna tan oyintzi'. ");
INSERT INTO aguBl_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Tk'ol tzun Kataj ama'l scyetz Josué tan chixcyewe'n scye'j yi e' wunaka'tz, yi ate' Libna tu yi chireyil. Tircu'n chiquime'n tan spar. Qui'c nin junt takle'n clax cyen. Ma yi quime'n yi rey, cho'n cunin cyulejtz chi ban yi rey cwent Jericó. ");
INSERT INTO aguBl_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Yi quicy'e'n Josué scyuch' yi e' xonl Israel Libna, cho'n tzun cyopone'ntz tan oyintzi' scye'j yi e' aj Laquis. Bajx baje'n chisutal solte'j yi tnum, nin e' octz tan oyintzi'. ");
INSERT INTO aguBl_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Tak' Kataj ama'l tan chixcyewe'n te yi junt tnuma'tz. Na le junt eklok, yi cyoque'n tan oyintzi', tircu'n chiquime'n cya'n. Tircu'n chilo'one'n tuml yi cyawun, chi cyulej yi tnum Libna. ");
INSERT INTO aguBl_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Ncha'tz Horam, yi rey cwent Gezer, tu yi e' tetz sanlar e' sajtz tan quich'eye'n klo' yi e' aj Laquis. Poro e' oc Josué tan chibiyle'n chicyakil. Nin cya'l nin jun nink clax cyen ẍchixo'l. ");
INSERT INTO aguBl_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Yi cyele'n tzaj Josué scyuch' yi e' xonl Israel Laquis, cho'n tzun cyopone'ntz naka'jil yi tnum Eglón. ");
INSERT INTO aguBl_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Ite'n nin k'eja'tz e' oc tan oyintzi' scye'j yi e' aj Eglón. Nin tircu'n chilo'one'n cya'n tan spar. Tircu'n e' quime'n chi e' ban yi e' aj Laquis. ");
INSERT INTO aguBl_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Ma cyele'n tzaj Eglón cho'n tzun cyopone'ntz Hebrón tan oyintzi'. ");
INSERT INTO aguBl_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","Yi cyopone'n le ama'l Hebrón tircu'n chiquime'n cya'n. Ncha'tz ban yi rey, scyuch' cyakil wunak tu yi e'chk tal tnum yi ate' naka'jil. Tircu'n chisotze'n. Cho'n cunin e' ban chi ban yi tnum Eglón. ");
INSERT INTO aguBl_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Chibene'n tzun Josué scyuch' yi e' xonl Israel tan oyintzi' scye'j yi e' aj Debir. Yi cyopone'n, nintzun e' octz tan oyintzi' scye'j. ");
INSERT INTO aguBl_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","Ma yi chixcyewe'n tan chibiyle'n yi e' wunaka'tz yi ate'-tz tnum Debir, tuml yi chireyil, cyetzaj yi chi'ama'l. Ncha'tz e' quim yi e' wunak yi ate' tulak e'chk mas aldey naka'jil yi tnuma'tz. Tircu'n chiquime'n cyak'un tan spar. Qui'c nin jun nink clax cyen cya'n chi cyulej yi tnum Hebrón tu Libna tuml yi chireyil. ");
INSERT INTO aguBl_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Tircu'n chilo'one'n yi e' wunak yi ate' le ama'la'tz. E' lo'on yi e' aj Néguev, tuml yi e'chk tnum yi ate' wi'ak tal ju'wtz. Tuml yi e'chk tnum yi ate' ẍk'ajlaj. Ja chisotz tircu'n tuml chireyil. Ya'stzun cyulejtz quib yi ca'wl yi tak' Kataj yi kaRyosil scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","Ya'stzun bantz yi xcyewe'n Josué tan cambaje'n cyakil yi e'chk ama'l, na e' cambaj cyakil yi ama'l cwent Cades-barnea, jalen Gaza, tu yi ama'l yi na xe'tnin Gosén jalen Gabaón. ");
INSERT INTO aguBl_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Ja chixcye' Josué scye'j yi e' reya'tz, nin ja cyetzaj cyakil chi'ama'l, na yi Kataj yi kaRyosil bajxij ẍchiwutz tan oyintzi'. ");
INSERT INTO aguBl_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Ma yi chixcyewe'n, nintzun e' pakxijt Gilgal kale e' saje't. ");
INSERT INTO aguBl_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Itzun bantz, yi tbital Jabín, rey cwent Hazor, yi mbi cu'n nchiban yi e' xonl Israel scye'j yi e' amorreo, nintzun ben ẍchakol cobox ẍchakum tan talche'n scyetz yi rey Jobab cwent yi tnum Madón, tu yi rey cwent Simrón, tu yi rey cwent Acsaf, tan je'n chimolol quib tan oyintzi' scye'j yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","Ncha'tz ben mantar tan i' scye'j cyakil yi e' rey yi ate' je'n tzi'n, scyuch' yi e' yi najlche' tjoco'j kale na icy'e't yi a' Jordán, tzak' cu'n tzaj yi jun wutzile'n lawun yi na bi'aj Cineret. Ncha'tz ben mantar scye'j cyakil yi e' ajcaw yi najlche' wi ẍk'ajlaj, swutze'l tzaj Dor, yi at toque'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","Scyuch' yi e' aj Canaán, scyuch' yi e' hitita, scyuch' e' ferezeo, scyuch' e' aj jebuseo, yi cho'n najlche' wi'wtz, ncha'tz yi e' heveo yi ate' wi'wtz Hermón, xlaj Mizpa. ");
INSERT INTO aguBl_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Chimolol tzun quib yi e' reya'tz tan oyintzi' scye'j yi e' xonl Israel. Xomche' chisanlar scye'j. At e' yi cho'n ate'e'n te'jak chej. Nin at e' yi cho'n ate' tulak care't tetz oyintzi'. Quinin ajlbe'n cyetz yi e' sanlara'tz, na cho'n cunin cyajlal chi tane'n yi samlicy' yi at tzi mar. ");
INSERT INTO aguBl_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Junit e' ban, nin cho'n cyopone'ntz stzi' a' Merom. Nin e' ban list quibtz tan oyintzi' scye'j yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Itzun tal Kataj tetz Josué: “Josué, quil cxob, na chwa'nin ek, nsken chiquim cyakil yi e' icontra'tz wa'n. Ma yi axwok itetz, ntina'tz tajwe'n tan ibnol: Wak'woke'n quikan yi chichej, nin oken k'a'kl yi chicare't ita'n,” stzun Kataj bantz tetz. ");
INSERT INTO aguBl_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Bene'n tzun Josué scyuch' yi e' tetz sanlar tan oyintzi' scye'j yi e' reya'tz. Qui cunin tz'icy' scyetz yi cyopone'n Josué tan chibiyle'n te yi ate' tzi yi a' Merom. ");
INSERT INTO aguBl_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","Na nin tak' Kataj ama'l scyetz yi e' xonl Israel tan chixcyewe'n scye'j yi e' reya'tz, e' xomnin tan chibiyle'n jalen Sidón, nin jalen Misrefot-maim. Nin at e' xonl Israel e' xomnin tan chibiyle'n jalen ẍk'ajlaj tele'n tzi'n Mizpa. Tircu'n chiquime'n yi e' chicontra'tz, na qui'c jun nink clax. ");
INSERT INTO aguBl_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Inin tulej Josué-tz chi tal Kataj. Cwe'n tzun chitz'e'sal cyakil yi chicare't nin ncha'tz baj chiwak'ul quikan chichej yi e' chicontra'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Chibene'n tzun Josué tan chibiyle'n yi e' yi ate' le tnum Hazor. Tircu'n chiquime'n, tuml yi chireyil, na i' ntxumun yi jun oyintzi'a'tz scye'j yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Tircu'n chiquime'n yi e' yi ate' le jun tnuma'tz. Nin oc k'a'kl yi tnum cyak'un yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Ite'n nin tulej Josué yi e'chk mas tnum yi xom chiwi' te yi rey cwent Hazor. Quim chireyil, nin e' quim tircu'n yi e' wunak yi ate' le yi e'chk tnuma'tz. Ban Josué yi xtxolbila'tz na ya'stzun talnak Moisés yi ẍchakum Ryos. ");
INSERT INTO aguBl_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Ntin Hazor oc k'a'kl cyak'un yi e' xonl Israel, ma yi e'chk mas tnum yi ate' wi'wtze'n, quinin oc k'a'kl cya'n. ");
INSERT INTO aguBl_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Poro tircu'n yi e' wunak yi ate'-tz tul yi e'chk tnuma'tz e' quim. Qui'c nin jun nink clax. Ma yi cyawun tu yi e'chk takle'n yi at tnum, tircu'n cyetzal. ");
INSERT INTO aguBl_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Yi e'chk ca'wl yi tak' Kataj tetz Moisés, Josué tzun bnon tane'n, na nin tal Moisés cyakil yi e'chk ca'wla'tz tetz Josué. Qui'c nin jun xtxolbil yi qui'k mban Josué chi yi tal Kataj tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Cyetzaj yi e' xonl Israel cyakil yi e'chk ama'la'tz yi at wi'wtz, tu yi jun c'oloj ama'l yi na bi'aj Néguev, tu yi ama'l Gosén, tu cyakil yi ẍk'ajlaj yi at stzi'ak yi a' Jordán, tu yi ama'l yi na bi'aj Arabá, tu cyakil e'chk mas ama'l yi at wi'wtz, tu yi e'chk joco'j yi nsken wi't oc chicwent. ");
INSERT INTO aguBl_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","Ncha'tz cyetzaj yi wi'wtz Halac yi na xe'tnin Seir, nin yi na opon jalen Baal-gad yi at jalen wi ẍk'ajlaj Líbano, yi at tzak' cu'n yi wutz Hermón. ");
INSERT INTO aguBl_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","Tircu'n chiquime'n chireyil yi e'chk tnuma'tz, na nim tiemp e' ban yi e' xonl Israel tan cambaje'n yi e'chk ama'la'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Ntin cu'n yi e' heveo, yi najlche' Gabaón, ya'stzun e' clax, na nsken bnix jun chitrat scyuch'. ");
INSERT INTO aguBl_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Tircu'n chiquime'n yi e' mas wunaka'tz, nin chin q'uixc'uj nin e' ban yi chiquime'n, na ya'stzun tajbil Kataj tan ticy'e'n pone'n yi e'chk q'uixc'uja'tz cya'n ẍchik'ab yi e' xonl Israel. Quinin el chik'ajab yi e' xonl Israela'tz scye'j, na ya'stzun alijt cyen tan Kataj Ryos tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Ncha'tz ite'n nin tiempa'tz chiquime'n yi e' xonl Anac yi najlche' wi'wtz Hebrón, nin Debir, tu Anab. Nin cyakil yi e' yi ate' wi'wtz cwent Judá, tu yi e'chk ama'l yi nsken oc chicwent yi e' xonl Israel, tircu'n chixite'n tan Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Cha'stzun te qui'c jun xonl Anac, yi e' yi nim wutz quikan, ncyaj cyen le ama'la'tz yi at ẍchik'ab yi e' xonl Israel. Poro ilenin e' cyaj cyen cobox le ama'l Gaza, tu Gat, nin Asdod. ");
INSERT INTO aguBl_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Ya'stzun ban yi chixcyewe'n yi e' xonl Israel tan cambaje'n cyakil e'chk ama'la'tz, chi yi talnak Kataj tetz Moisés. Nintzun cu' jatxij yi ama'la'tz ẍchiwutz yi e' xonl Israel, xomquen tu' te jujun k'u'j e'. Nin jetza'tz, qui'ct mas oyintzi' jal ẍchixo'l. ");
INSERT INTO aguBl_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","Yi e'chk ama'l yi cyetzaj yi e' xonl Israel i'tz: Cyakil yi ama'l yi na xe't tzaj te yi tzanla' Arnón, jalen te yi wutz Hermón, cyakil yi e'chk ama'l yi at swutz len yi tzanla' Jordán. ");
INSERT INTO aguBl_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","Yi chibi' yi e' rey yi e' quim cyak'un i'tz: Yi rey tetz Sehón, yi chireyil yi e' amorreo, yi cho'n najlij le tnum Hesbón, i' ajcaw tibaj cyakil yi ama'l yi cho'n na xe'tnin le tnum Aroer, yi at tzi tzanla' Arnón, jalen te yi tzanla' Jaboc, kale atit chimojom yi e' amonita. Ncha'tz cawunak i' tibaj jalaj te yi ama'l Galaad. ");
INSERT INTO aguBl_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","Ncha'tz cawunak i' tibaj cyakil yi ama'l yi at swutz len yi a' Jordán, yi cho'n na xe'tij tzi yi a' Cineret, jalen te yi mar yi chin c'a' nin tan atz'um nka yi C'a' Mar. Nin opon te yi tnum Bet-jesimot, nin jalen xe wutz Pisga. ");
INSERT INTO aguBl_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","Ncha'tz quim Og cyak'un yi rey cwent Basán. Yi Oga'tz i' yi wi'tzbil chixonl yi e' refaita yi cho'n najlche' le tnum Astarot, nin yi tnum Edrei. ");
INSERT INTO aguBl_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","Ej, nin yi e'chk ama'l yi at jak' ca'wl yi rey Oga'tz sajle'n, i'tz yi ama'l yi cho'n na xe't tzaj mojomil xe wutz Hermón, tuml yi ama'l Salca, nin cyakil yi ama'l cwent Basán, nin oponak yi mojom jalen Gesur tu Maaca, ncha'tz na opon nicy'al Galaad, yi cob elnak tu Sehón, rey cwent Hesbón. ");
INSERT INTO aguBl_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","Ya'stzun yi e' reya'tz yi e' quim cyak'un Moisés scyuch' yi e' xonl Israel. Nintzun cu' jatxol Moisés yi e'chk ama'la'tz ẍchiwutz ox k'u'j scyeri yi e' xonl Israel. Nin yi ox k'u'ja'tz i'tz: Yi e' xonl Rubén, yi e' xonl Gad, tu yi e' xonl Manasés yi cob cuntu' elnake'. ");
INSERT INTO aguBl_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","Ma cyakil yi ama'l yi nchicambaj Josué scyuch' yi e' xonl Israel, i'tz yi at jalajicy' tzaj yi a' Jordán. Na xe't nin Baal-gad, yi at Líbano, jalen te yi wi'wtz Halac yi at cwe'n tzi'n, swutzo'c tzaj yi wi'wtz Seir. Cwe'n tzun jatxol Josué cyakil yi e'chk ama'la'tz ẍchiwutz yi e' xonl Israel, tetz chinajbil sbne' opon tunintz. ");
INSERT INTO aguBl_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","Cu' jatxol cyakil yi e'chk ama'l yi at wi'wtz tu yi ẍk'ajlaj, tu ama'l yi at tzi a' Jordán, tu yi e'chk txala'j, tu cyakil e'chk ama'l yi tz'inunin tu', tu cyakil yi ama'l cwent Néguev. Cyakil yi e'chk ama'la'tz ya'stzun yi chi'ama'lbe'n yi e' hitita, yi e' amorreo, nin yi e' xonl Canaán, nin yi e' ferezeo, nin e' keveo, scyuch' e' jebuseo. ");
INSERT INTO aguBl_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","24","Ma jalu', je chibi' yi e' rey yi e' quim cyak'un Josué: Yi rey tetz Jericó, tetz Hay, yi at naka'jil Betel, rey tetz Jerusalén, tetz Hebrón, tetz Jarmut, tetz Laquis, tetz Eglón, tetz Gezer, tetz Debir, tetz Geder, tetz Horma, tetz Arad, tetz Libna, tetz Adulam, tetz Maceda, tetz Betel, tetz Tapúa, tetz Hefer, tetz Afec, tetz Sarón, tetz Madón, tetz Hazor, tetz Simrom-merón, tetz Acsaf, tetz Taanac, tetz Meguido, tetz Cedes, tetz Jocneam yi at Carmelo, tetz Dor yi at tzi mar, tetz Goim yi at cwent Gilgal, nin yi rey tetz Tirsa. Junak junlaj rey e' quim cyak'un Josué scyuch' yi e' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","Itzun bantz, yi tijine'n c'u'l Josué, nintzun tal Kataj tetz: “Josué, yi aẍatz ja tijin ac'u'l, poro at tzaj nin tan ixcyewe'n tan cambaje'n yi ama'l yi insuknak tzitetz. ");
INSERT INTO aguBl_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","Na txe'n itetzaj chi'ama'l yi e' filistey, tu chi'ama'l yi e' gesureo. ");
INSERT INTO aguBl_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","Ncha'tz txe'n itetzaj yi chi'ama'l yi e' aveo, yi at cwe'n tzi'n. Yi e'chk ama'la'tz, i'tz yi ama'l yi na xe't tzaj te yi tzanla' Sihor, swutze'l tzaj Egipto, nin te yi mojomil yi na opon jalen te tnum Ecrón. Ma je'n tzi'n, txe'n itetzaj yi ama'l kale ate't yi e' aj Canaán. Tul yi ama'la'tz, at o' wi'tz ajcaw yi na chicawun. Nin i'tz yi ajcaw cwent Gaza, Asdod, Ascalón, Gat nin Ecrón. ");
INSERT INTO aguBl_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","Ncha'tz txe'n itetzaj yi ama'l yi at cwe'n tzi'n, yi na xe'tnin Sidón, nin yi na opon jalen Afec, yi mojom tib scyuch' yi e' amorreo. ");
INSERT INTO aguBl_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","Ncha'tz txe'n itetzaj chi'ama'l yi e' giblita, nin yi ama'l cwent Líbano, yi na xe'tij Baal-gad, nin na opon xe wutz Hermón jalen Hamat. ");
INSERT INTO aguBl_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","Cyakil yi e'chk ama'la'tz, swak'e' tzitetz yi axwok xonl Israel. Swak'e' cyakil yi chi'ama'l yi e' aj Sidón, tu yi wi'wtz yi na xe'tij Líbano, jalen Misrefot-maim. Chelepon inlajul cyakil yi e' wunak yi ate' swutz yi e'chk ama'la'tz. Ma aẍatz Josué, ba'n tzajatx yi ama'la'tz ẍchiwutz yi e' atanum, chi walnak tzatz. ");
INSERT INTO aguBl_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","Ba'n tzajatx cu'n ẍchiwutz yi beluj k'u'j xonl Israel, tuml yi junt k'u'j xonl Manasés yi txe'n ak'lij cyetz”, stzun Ryos ban tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","Yi e' xonl Rubén, tu Gad, tu yi junt k'u'j xonl Manasés, nsken tak' Moisés yi cyetz chi'ama'l jalaj cy'en yi a' Jordán. ");
INSERT INTO aguBl_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","Na ja cyetzaj yi ama'la'tz yi na xe't nin Aroer, yi at stzi' yi a' Arnón tu yi e'chk tnum yi at ẍk'ajlaj, tuml Medeba tu Dibón. ");
INSERT INTO aguBl_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","Tuml cyakil yi e'chk tnum yi at tzaj cwent yi rey Sehón yi cyajcawil yi e' amorreo, yi cho'n najewe'n i' Hesbón. Nin ja opon cu'n stzi' yi chimojom jalen te yi chimojom yi e' amonita. ");
INSERT INTO aguBl_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","Ncha'tz ak'lij yi e'chk ama'l scyetz yi at cwent Galaad tu yi chi'ama'l yi e' gesureo, tu chi'ama'l yi e' maacateo, tu yi wi'wtz Hermón, tuml yi ama'l Basán jalen Salca. ");
INSERT INTO aguBl_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","Ncha'tz ak'lij yi ama'l yi at jak' ca'wl Og, chireyil yi e' aj Basán, yi cawunak le tnum Astarot tu Edrei. Ya'stzun yi e' refaita yi e' clax cyen, yi xcye' nak Moisés tan chibiyle'n, nin tan chilaje'n le cyetz chi'ama'l. ");
INSERT INTO aguBl_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","Ntin cu'n yi e' aj Gesur scyuch' yi e' aj Maaca qui nche'l laju'n swutz yi chi'ama'l, ma na e' cyaj cyen tu' ẍchixo'l yi e' xonl Israel. Nin ate' nintz jalu'. ");
INSERT INTO aguBl_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","Ma yi e' xonl Leví qui'c cyetz chi'ama'l ak'lij tan Moisés. Na yi cyetz chi'herens i'tz yi e'chk oy yi na opon cyak'un yi e' xonl Israel tan pat-xe'n swutz Ryos, chi yi talnak Ryos scyetz. ");
INSERT INTO aguBl_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","Ma yi e' xonl Rubén, nintzun oc Moisés tan jatxle'n cyetz chi'ama'l. Xomquen tu' te yi jujun najal. ");
INSERT INTO aguBl_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","Cho'n tzun e' cyaje'n cyen yi e' xonl Rubéna'tz le yi ama'l Aroer, stzi' yi a' Arnón tu yi tnum yi at ẍk'ajlaj, cy'anl tetz Medeba. ");
INSERT INTO aguBl_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","Nin ja opon cu'n jalen Hesbón tu cyakil yi e'chk tnum yi at ẍk'ajlaja'tz chi tane'n Dibón, Bamot-baal, Bet-baal-meón. ");
INSERT INTO aguBl_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","Ncha'tz i' njatxon yi tnum Jahaza, Cademot, nin Mefaat, ");
INSERT INTO aguBl_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","tu yi tnum Quiritaim, Sibna, Zaret-sahar yi at ẍk'ajlaj. ");
INSERT INTO aguBl_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","Ej, nin i' njatxon yi tnum Bet-peor, tuml yi e'chk txala'j Pisga, nin Bet-fesimot, ");
INSERT INTO aguBl_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","tu cyakil yi e'chk cojbil, tuml yi e'chk tnum yi at jak' ca'wl Sehón yi chireyil yi e' amorreo, yi najlij Hesbón. Ya'stzun yi rey yi quim tan Moisés scyuch' coboxt ajcaw yi na chibi'aj: Evi, Requem, Zur, Hur nin Reba. ");
INSERT INTO aguBl_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","Ncha'tz quim Balaam cyak'un yi e' xonl Israel tan spar. Yi jun Balaama'tz i' jun nachol, nin i' cy'ajl Beor. ");
INSERT INTO aguBl_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","Cyakil yi e'chk ama'la'tz, ya'stzun ak'lij scyetz xonl Rubén tan Moisés. Xomquen tu' te tajlal yi jujun k'u'j e' yi chixonl quib. Tircu'n e'chk ama'la'tz ak'lij scyetz. Nin cho'n mmopon chimojom tzi a' Jordán. ");
INSERT INTO aguBl_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","Ncha'tz tak'nak Moisés chi'ama'l yi xonl Gad. Xomquen tu' te tajlal yi jujun k'u'j e' yi chixonl quib. ");
INSERT INTO aguBl_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","Ak'lij yi ama'l cwent Jazer tu cyakil yi tnum Galaad scyetz. Nin ncha'tz cyetzaj jalaj chi'ama'l e' amonita. Nin yi mojomil yi chi'ama'l, opon jalen Aroer yi at swutz len Rabá, ");
INSERT INTO aguBl_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","tuml yi ama'l yi at xo'l Hesbón, Ramat-mispa tu Betonim, tuml yi ama'l yi at xo'l Mahanaim. Nin na opon te yi mojomil Debir. ");
INSERT INTO aguBl_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","Ncha'tz ak'lij yi ẍk'ajlaj Bet-aram Bet-nimra, tu Sucot, nin Zafón. Ya'stzun ama'l yi at tzaj jak' ca'wl Sehón yi rey tetz Hesbón. Cho'n tzun at cyakil e'chk ama'la'tz swutz len yi a' Jordán. Nin cho'n nxe't tzaj tzak' cu'n tzaj yi lawun yi na bi'aj Cineret. ");
INSERT INTO aguBl_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","Cyakil yi e'chk ama'la'tz, ya'stzun ak'lij scyetz yi e' xonl Gad tan Moisés. Xomquen tu' te yi tajlal yi jujun k'u'j e' aj Gada'tz yi chixonl quib. ");
INSERT INTO aguBl_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","Ncha'tz tak' Moisés chi'ama'l yi junt k'u'j xonl Manasés, yi e' cyaj cyen jalaj cy'en yi a' Jordán. ");
INSERT INTO aguBl_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","Yi toque'n jatxle'n yi chi'ama'l, xomquen tu' te yi tajlal yi jujun k'u'j e' yi chixonl quib. Nin ja cyetzaj cyakil yi ama'l yi at tzaj jak' ca'wl Og, yi rey tetz Basán. Cho'n xe'tnin le tnum Mahanaim, tuml yi oxc'al tnum yi at cwent yi tnum Jair. ");
INSERT INTO aguBl_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","Ncha'tz cyetzaj jalajt te yi ama'l Galaad tu yi cobt tnum yi na bi'aj Astarot tu Edrei. Ya'stzun yi ama'l yi ak'lij scyetz xonl Maquir, cy'ajl Manasés. Xomquen tu' te tajlal jujun k'u'j e' yi chixonl quib. ");
INSERT INTO aguBl_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","Ya'stzun cyakil yi ama'l yi baj jatxol Moisés scyetz yi e' xonl Rubén, Gad tu Manasés, te yi ate' wi ẍk'ajlaj cwent Moab, yi at jalaj cy'en yi a' Jordán, swutz len Jericó. ");
INSERT INTO aguBl_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","Ma yi e' xonl Leví, qui'c cyetz chi'herens ak'lij, ma na ntina'tz tal Moisés scyetz: “Yi itetz iherens i'tz yi Kataj, yi kaRyosil.” ");
INSERT INTO aguBl_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","Je chibi' yi e'chk ama'l cwent Canaán yi jatxlij ẍchik'ab yi e' xonl Israel cyak'un Eleazar yi pale', tu Josué yi cy'ajl Nun, scyuch' yi e' chibajxom yi jujun k'u'j xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","Cho'n cyulej chi talnak Kataj tetz Moisés. Na e' oc tan tx'ilu'ntz te'j tan jatxle'n cu'n ẍchiwutz yi beluj k'u'j tu ni'cy xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","Na yi cobt k'u'j tu ni'cy, yi e' xonl Rubén, nin yi e' xonl Gad, tu yi junt k'u'j xonl Manasés, nsken tak' Moisés yi cyetz chi'herens jalaj cy'en yi a' Jordán. Ma yi e' xonl Leví, quinin ak'lij cyetz chi'herens, ");
INSERT INTO aguBl_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","na yi cob cy'ajl Ẍep, yi Manasés tu Efraín, e' oc tajlal yi coblaj k'u'j xonl Israel. Poro yi e' xonl Leví qui ak'lij chi'herens, ma na ntin ak'lij mu'ẍ chi'ama'l kalel chinajewe't, nin kalel chiwane't yi cyawun. Yi mu'ẍ chi'ama'la'tz, cho'n at ẍchixo'lak yi e' mas xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","Cyakil yi xtxolbila'se'j, ja bnix chi talnak Kataj tetz Moisés. ");
INSERT INTO aguBl_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","Ej, itzun bantz, nintzun e' ben yi e' xonl Judá tan yol tetz Josué le tnum Gilgal. Yi cyopone'n swutz Josué, nintzun tal Caleb yi cy'ajl ta' Jefone yi cenezeo tetz: “Ma jalu' ta', ulk tx'akx tc'u'lu' yi xtxolbil yi talnak Kataj tetz Moisés le ama'l Cades-barnea, na alijt cyen tak'un, yi mbi sbajok ske'j ketz tuch'u'. ");
INSERT INTO aguBl_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Na yi kasaje'n ẍchakol Moisés yi ẍchakum Ryos, tan xk'uke'n yi ama'le'j, atin wetz tul ca'wunak yob. Ej, nin yi kulake'n tan xk'uke'n, ja wal yi mero bintzi quib yi nwil, na ja chinxom te yi tajbil Wajcaw yi kaRyosil. ");
INSERT INTO aguBl_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Ma yi coboxt kuch' yi xomche' ske'j, ntin ja cho'c tan chixo'wse'n yi e' mas katanum. Poro yi in wetz quinin nchinxom scye'j, ma na ntin ja imban yi tajbil Kataj yi kaRyosil. ");
INSERT INTO aguBl_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Cha'stzun te tal Moisés yi xtxolbile'j swetz: ‘Jun cu'n yol, yi ama'l kale ncxone't, atz sbne' scyuch' yi e' anitxa', na ja cxom te yi tajbil Kataj yi kaRyosil,’ stzun i' bantz swetz. ");
INSERT INTO aguBl_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","Ma jalu' bin Josué, nimix bin tiemp yi tlol Moisés yi xtxolbile'j swetz. Na ja wi't icy' ca'wunak o'ix yob yi tlol Kataj yi xtxolbila'tz tetz Moisés, nin ya'stzun yi tiemp yi na kaxon tzaj le ama'l tz'inunin tu'. Ma jalu', atin tul jun mutx' tu o' yob, ");
INSERT INTO aguBl_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","ej, nin iẍnin wutane'n wetz chi wutane'n yi insaje'n ẍchakol Moisés tan xk'uke'n yi e'chk ama'la'tz. Ncha'tz atit inwalor tan woque'n tan oyintzi'. ");
INSERT INTO aguBl_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Cha'stzun te na klo' waj yil tak'u' yi ama'la'tz yi suknak Kataj swetz. I'tz yi wi'wtz kale ate't yi e' xonl Anac, yi e' yi chin wutz quikan nin. At e' yi cho'n najlche' tulak e'chk lmak tnum, yi at chin tapij solte'jak. Tak'u' bin e'chk ama'la'tz swetz, na cho'n k'uklij inc'u'l te Kataj, yi xomok i' swe'j tan wuch'eye'n tan chilaje'n len yi e' wunaka'tz yi ate' swutz,” stzun Caleb bantz tetz Josué. ");
INSERT INTO aguBl_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Nintzun tak' Josué banl tibaj Caleb, ncha'tz tak' yi ama'l cwent Hebrón tetz herens i'. Yi Caleba'tz i' cy'ajl Jefone yi cenezeo. ");
INSERT INTO aguBl_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Ya'stzun bantz yi toque'n Hebrón tetz herens Caleb tu cyakil yi xonl i', nin cho'n najlche'-tz jalu', na nin xom i' te yi mero tajbil Kataj yi kaRyosil, yi o' xonl Israel. ");
INSERT INTO aguBl_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","Yi bi' yi ama'l Hebrón tenẍchan i'tz, Quiriat-arba. Yi bi'aj Arba i'tz bi' jun xonl Anac. Nin i'tz jun yaj yi chin wutz tkan nin, nin chin cham nin i'. Ma yi xcyewe'n Caleb tan cambaje'n e'chk ama'la'tz, qui'ct oyintzi' bajij Canaán te yi tiempa'tz. ");
INSERT INTO aguBl_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","Je yi ama'l yi jatxlij scyetz yi e' xonl Judá yi toque'n tx'ilu'n te'j. Nin je yi mojomile'j: ");
INSERT INTO aguBl_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","Te yi jalaj cwe'n tzi'n, cho'n na xe'tij stzi' yi mar yi chin c'a' nin tan atz'um, kale na icy'e't chimojom yi e' aj Edom, ");
INSERT INTO aguBl_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","nin na icy'ak ẍina'j Acrabim, nin na icy'ak le ama'l tz'inunin tu' cwent Zin. Ncha'tz na icy'ak tzak' cu'n Cades-barnea, nin na opon Hezrón, nin na je' tcu'n Adar. Kalena's tzun na ben tan tak'le'n welt jalen Carca. ");
INSERT INTO aguBl_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","Nin na xomnin le xo'mbil a' yi na bi'aj a' Tetz Egipto, jalen yi na opon tzi yi mar Mediterráneo. Ya'stzun chimojom bantz te yi jalaj cwe'n tzi'n. ");
INSERT INTO aguBl_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","Ma yi mojomil chi'ama'l tetz tele'n tzi'n i'tz cyakil tkanil yi mar yi chin c'a' nin tan atz'um, jalen te yi ama'l kale na tzajpont yi tzanla' Jordán. Ma yi mojomil chi'ama'l je'n tzi'n, cho'n na xe'tnin kale na tzajpont wi' yi tzanla' Jordána'tz stzi' yi mar yi chin c'a' nin tan atz'um. ");
INSERT INTO aguBl_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","Cho'n na je'ul Bet-hogla. Nin na je'ul Bet-arabá. Nin na ultz kale atit yi wutz c'ub tetz Bohán, jun scyeri xonl Rubén. ");
INSERT INTO aguBl_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","Kalena's tzun na je'ultz wi ẍk'ajlaj cwent Acor. Nin na ultz Debir. Cho'n tzun na cu'ultz Gilgal, swutze'l tzaj yi txala'j cwent Adumín tzak' cu'n yi xo'mbil a'. Nintzun na icy' cu'ntz kale na itz'e't yi a' En-semes, nin na xomnintz jalen En-rogel. ");
INSERT INTO aguBl_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","Nin na icy' cu'ntz le ẍk'ajlaj cwent Ben-hinom, tzak' cu'n Jebús nka Jerusalén. Nin na je' cu'ntz wi'wtz swutz cyen yi ẍk'ajlaj cwent Hinom, tibe'n yi ẍk'ajlaj Refaim. ");
INSERT INTO aguBl_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","Cho'n tzun na tak' welt jalen wi'wtz kale na itz'e't yi a' Neftoa. Kalena's tzun na icy'tz wi Efrón. Nin na icy'pon jalen Baala. Yi jun ama'la'tz ncha'tz na bi'aj Quiriat-jearim. ");
INSERT INTO aguBl_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","Kalena's tzun na ben lo'cnak tzi'n tibaj yi wi'wtz Seir. Na icy'aktz le ama'l Quesalón swutze'n yi wi'wtz Jearim. Nintzun na cu'-tz Bet-semes, nin na icy'aktz Timna. ");
INSERT INTO aguBl_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","Ncha'tz na icy'aktz txala'j tibe'n Ecrón. Kalena's tzun na stz'uy nin tibtz jalen Sicrón. Na icy' cu'ntz wi ju'wtz Baala. Kalena's tzun na opontz Jabneel, nin cho'n na tzaj pon wi' yi chimojom jalen tzi mar Mediterráneo. ");
INSERT INTO aguBl_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","Ma mojomil chi'ama'l yi e' xonl Judá te yi jalajt xlaj toque'n tzi'n, i'tz yi tzi mar Mediterráneo. Ya'stzun e'chk mojomil yi ama'l yi oc tetz cyetz yi e' xonl Judá. Nin jatxij cu'n ban ẍchiwutz yi jujun k'u'j e' yi chixonl quib. ");
INSERT INTO aguBl_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","Ncha'tz tak' Josué herens Caleb, yi cy'ajl ta' Jefone. Yi ama'la'tz i'tz Quiriat-arba, yi ncha'tz na bi'aj Hebrón, yi cho'n at cwent yi chi'ama'l yi e' xonl Judá. Nin i'tz chi'ama'lbe'n yi e' xonl yi jun chin wutzile'n yaj yi na bi'aj Anac. Ya'stzun yi ama'l yi ak'lij tetz Caleb, na ya'stzun talnak Kataj. ");
INSERT INTO aguBl_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","Bene'n tzun Caleb tan oyintzi' tan chilaje'n len yi ox xonl Anac yi ate' swutz yi ama'la'tz. Yi chibi' yi ox xonl Anaca'tz i'tz: Sesai, Ahimán, nin Talmai. ");
INSERT INTO aguBl_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","Ma yi cyele'n lajul, kalena's tzun bene'nt tan oyintzi' scye'j yi e' yi najlche' Debir. Quiriat-sefer bi' yi jun ama'la'tz tenẍchan. ");
INSERT INTO aguBl_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","Yi topone'n Caleb Debir, nintzun taltz: “Swak'e' inme'l Acsa tetz txkel yi jun yil xcye' tan cambaje'n yi ama'le'j.” ");
INSERT INTO aguBl_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","Yi jun yi xcye' tan cambaje'n yi ama'la'tz i'tz, Otoniel, yi cy'ajl Cenaz, yi titz'un Caleb. Tk'ol tzun Caleb yi me'ltz tan toque'n tetz txkel Otoniel. ");
INSERT INTO aguBl_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","Te yi ele'n tlen tu' ate't Otoniel tu Acsa xe ca'l Caleb, nintzun tal Otoniel tetz Acsa: “Ba'n tzajak junt piẍ ama'l tetz ataj kalel cwe't ujul ka'n.” Cwe'n tzaj tzun Acsa tibaj yi buru'. Nintzun bentz swutz yi taj. Bene'n tzun jakol yi taj tetz: —Aẍ jun c'oloj inme'l. ¿Mbi'tz na icy' tac'u'l? ");
INSERT INTO aguBl_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","—Ta', na klo' waj tzinjak jun pawor 