﻿USE sofia;
DROP TABLE IF EXISTS sofia.agt_vpl;
CREATE TABLE agt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES agt_vpl WRITE;
INSERT INTO agt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","A ya ngagan na ngamin kiden gingginafu ni Hesus Kristu nga simsima ni mina Dabid ikid ni mina Abraham a ikid yan: ");
INSERT INTO agt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Mamegafu te mina Abraham a intu ya dama ni mina Isak, a i mina Isak ya dama ni mina Hakob, a i mina Hakob ya dama nig mina Huda ikid na kabagis na kiden. ");
INSERT INTO agt_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","A i mina Huda ya dama nig mina Pares ikid ni Zira nga neanak ni Tamar, a i mina Pares ya dama ni mina Esron, a i mina Esron ya dama ni mina Aram, ");
INSERT INTO agt_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","a i mina Aram ya dama ni mina Aminadab, a i mina Aminadab ya dama ni mina Naason, a i mina Naason ya dama ni mina Salmon, ");
INSERT INTO agt_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","a i mina Salmon ya dama ni mina Boas nga neanak ni Rahab, a i mina Boas ya dama ni mina Obed nga neanak ni Rut, a i mina Obed ya dama ni mina Dyesi, ");
INSERT INTO agt_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","a i mina Dyesi ya dama ni Ari en Dabid. A i mina Dabid ya dama ni mina Solomun nga neanak na dana en atawa ni Urias, ");
INSERT INTO agt_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","a i mina Solomun ya dama ni mina Roboam, a i mina Roboam ya dama ni mina Abias, a i mina Abias ya dama ni mina Asa, ");
INSERT INTO agt_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","a i mina Asa ya dama ni mina Yusafat, a i mina Yusafat ya dama ni Yuram, a i mina Yuram ya dama ni mina Osyas, ");
INSERT INTO agt_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","a i mina Osyas ya dama ni mina Hwatam, a i mina Hwatam ya dama ni mina Akas, a i mina Akas ya dama ni mina Ezikias, ");
INSERT INTO agt_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","a i mina Ezikias ya dama ni mina Manasa, a i mina Manasa ya dama ni mina Amos, a i mina Amos ya dama ni mina Yosias, ");
INSERT INTO agt_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","a i mina Yosias ya dama ni mina Yekonias ikid na kabagis na kiden nga sakā nehulun ta Istralita kiden tekiden nealit petta mafukuk kid ta lugar na Babilonya. ");
INSERT INTO agt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","A ta nepagyan ni Yekonias ta lugar na Babilonya a nagbalin hapa ta dama ni Salatila, a i mina Salatila ya dama ni mina Zorubabel, ");
INSERT INTO agt_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","a i mina Zorubabel ya dama ni mina Abiyud, a i mina Abiyud ya dama ni mina Eliakim, a i mina Eliakim ya dama ni mina Azor, ");
INSERT INTO agt_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","a i mina Azor ya dama ni mina Saduk, a i mina Saduk ya dama ni mina Akim, a i mina Akim ya dama ni mina Eliyud, ");
INSERT INTO agt_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","a i mina Eliyud ya dama ni mina Elezar, a i mina Elezar ya dama ni mina Matan, a i mina Matan ya dama ni mina Hakob, ");
INSERT INTO agt_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","a i mina Hakob ya dama ni mina Hose, a i Hose ya atawa ni Mariya, a Mariya ya hina ni Hesus nga nagngagan hapa ta Kristu nga Mangikerutan. ");
INSERT INTO agt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","A itta mantu ya mafulu appat na simsima ni Hesus addet te mina Abraham addet te mina Dabid. A itta hapa ya mafulu appat na simsima na addet te mina Dabid addet ta nekafukuk na taga Istralita kiden ta lugar na Babilonya. A itta hapa ya mafulu appat na simsima na addet ta nekafukuk na Istralita kiden addet te Hesus Kristu. ");
INSERT INTO agt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","A ya pakabida na pakeanak ni Hesusen a intu yan: Te dana nagbabidan da ya pagatawa nig Mariya ikid ni Hose, ammi ta aweda para la pagdorug a dana matarun na i Mariya gafu ta nehuga na Kahalwa na Namaratu ta matarun. ");
INSERT INTO agt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ammi te Hose a pahig na ta nakikadallaw i Mariya en, a yen ta ikayat na idarum petta pagtalekudan na mina ya nagbabidan da en. Ammi gafu ta maallak hapa i Hose en a awena ikayat ta mamatan ya babbayen, a nakanonot mantu tatakday ta awena mina idarum, te pagurayān na la. ");
INSERT INTO agt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","A tentu en para la nagnononot ta kumanin a nakatarinap hapa tentu nasidug, a nakipaita kan ya anghel na Namaratu tentu ta tarinap na. “Hose O,” kunna kan na anghelen tentu, “Awem pahig ta dulay am alapam i Mariya ta atawam, te ya Kahalwa na Namaratu ya nangihuga ta nekatarun na. ");
INSERT INTO agt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A am maganak sangaw ya atawam ta lalaki a ingagan muy sangaw te Hesus, te intu sangaw ya mangikaru ta liwat na ikattolay muy kiden petta mekerutan kid,” kun na anghelen tentu. ");
INSERT INTO agt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","A tentu en nahukal a kinurug ni Hose ya uhohug na anghelen tentu. Inalap na i Mariya ta bali na en petta atawa na, ammi aweda bit nagdodorug abat ta nekeanak na abbingen, a nengagan da hapa te Hesus. A uray yen na Namaratu petta magdulot ya nepeuhohug na ta aglavunen ta idi, te ya nebar na a “Matarun sangaw ya balatang nga awan para la ta nakidorugan na ta lalaki, a maganak hala sangaw ta lalaki, a ya ibar da sangaw ta ngagan na abbingen a Imanwel,” kun na surat na aglavunen. A ya ikayat na uhohugan na ngagan na en ‘Imanwel’ a ‘Ittan ya Namaratu tekitam,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","A ta nepaganak ni Mariya te Hesus a itta kid ta ili na Betlihem ta lugar na Hudeya. A i Heruden hapa ya ari na Hudyo kiden. A ta nekeanak ni Hesusen a itta ya lālāki kiden nga dumabilbig ta bitwan nga nagafu ta pake adayu ta daya na Hudeya, a nagdulot kid hapa ta ili na Herusalem, ");
INSERT INTO agt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","te pohutan da ta tolay kiden am had agyan na bagu en ari na Hudyo kiden “Te naita min ya lattog na bitwanen nga mangibar ta nekeanak na, a yen ta itta kamin sin te emmi hapa dayawan,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","A ta nepakadamag ni Ari en Herud ta ittan ya takwan na ari nga neanak ta lugar na en a nagburung na hapa, yaga nagburung hapa ya tolay na kiden ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A pinagkakampat na mantu ya padi kiden nga Hudyo ikid na mangituldu kiden ta relisyon da, a pinohutan na tekid am had sin na lugar ya kinankanna na aglavunen ta keanakan na Ari en Kristu nga nebar na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","A ya uhohug da hapa a “Yo ten, ili kan na Betlihem ya keanakan na,” kunda, “te ya uhohug na surat na aglavunen a ");
INSERT INTO agt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Maski am ili na Betlihem ya kaassangan na ili ta lugar na Hudeya a pake madaydayawan sangaw ammi ta ngamin kiden ili ta lugar na Hudeya, te yen sangaw ya pagafun na Akkimohayan nga magtaron ta tolay ku kiden nga Istralita,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","A ta nepakadangag ni Herud ta uhohug na padi kiden ikid na mangituldu kiden a pinaayagan na hapa ya dumabilbig kiden ta bitwan, petta kabida na kid ta melemad, te damagan na tekid am kanu na araw ikid na hulan ya nelattog na bitwanen nga pakaitan da ta pakeanak na abbingen, ");
INSERT INTO agt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","a sangaw pinagdulot na kid hala ta ili na Betlihem. “E kanan ta iten Betlihem, te yen kan sangaw ya pakaitan muy ta abbingen. A sangaw am maita muy a emmuy hapa sangaw ibar ya agyan na en teyak, te e yak hapa sangaw magdayaw tentu,” kunna kampon tekid. ");
INSERT INTO agt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","A ta nekabalin da nagdangag te Herud a nagtugut kid na nga umange ta ili na Betlihem. A mappya la te netuldu na kid hapa na bitwanen nga naita da ta lattog na en, a yen ya aanungan da ta angen da abat ta nagimmang ta utun na bali en nga pagyanan na abbingen. ");
INSERT INTO agt_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","A ta pakaita dan ta nagimmang ya bitwanen a pake timoltollok ya nonot da ta talak da. ");
INSERT INTO agt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","A sangaw simarok kid hapa ta umag na bali en, a naita da hala ya abbingen Hesus ikid na hina na en Mariya. A alistu kid namalentud ta atubang ni Hesus nga nagdayaw tentu, kapye da inukadan ya kaha na agitunan da ta balituk ikid na mangina na bangog, a neuhet da ya iatad da tentu. ");
INSERT INTO agt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","A sangaw ta hiklam tekid nagkakāsidug a nakatarinap kid, a tinarinap da kan ta aweda kan mina magtoli te Herud, te itta kan ya dulay. A gafu ta kumanen a nagtatugut kid ha, ammi linillikan da ya agyan ni Ari Herud, a dumatang kid hala ta agyan da en. ");
INSERT INTO agt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","A ta gafan na dumabilbig kiden ta bitwan a nakatarinap hapa i Hose, a nakipaita kan ya anghel na Namaratu tentu. “Imivwat kanan, Hose,” kunna kan na anghelen, “te itammang mu ya abbingina ikid na hina na ina, te iangem kid ta iten lugar na Egipto. A magyan kam la ten abat ta pakauhohug ku teko, te paapag ni Herud ya abbingina petta papasin na,” kunna kan. ");
INSERT INTO agt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A imivwat kid na ta tangngan na hiklam, a umange kid na ta lugar na Egipto. ");
INSERT INTO agt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","18","Ammi ya Ari en Herud a pake nakaporay na ta dumabilbig kiden ta bitwan gafu ta aweda nagtoli tentu petta ibar da ya agyan na abbingen. A gafu ta pangayayyaw da tentu a negakkad na ta mapapasi ya ngamin kiden abbing ta ili na Betlihem ikid na paglelehut na en, talo am mesipat hapa mapapasi i Hesusen. A yen ta dinob na ya suddalu na kiden, a sa pinapasi da ya ngamin kiden lālāki na abbing nga tagdwa darun kontodu ngamin kaassangan da kiden, te nekwenta ni Herud ta ittan ya duwa na darun addet ta lalattog na bitwanen nga binida na dumabilbig kiden. A gafu ta pangpapasi da ta abbing kiden a nagdulot hapa ya kuman na binida na aglavunen mina Heremyas ta palungu araw, te ya uhohug na ta surat na en a “Pake masitang sangaw ya ngahal da ta ili na Rama, te magtatangit ya simsima ni Rakel ta anak da kiden. A awena matabtabang na damdam da te awan na haman ya anak da kiden,” kunna. Ammi teg Hose a nagyan kid la ta lugar na Egipto abat ta pasi ni Ari en Herud, kapye na kid pinatugut na Namaratu. Te yen ya uray na tekid petta magdulot sangaw ya nepeuhohug na ta aglavunen, te ya nebar na a “Pinatugut ku ya anak ken ta lugar na Egipto,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","A ta nepasi ni Ari en Herud a nagtarinap ha i Hose en ta iten Egipto, a naguhohug ha ya anghel na Namaratu tentu. “Imivwat kanan,” kunna, ");
INSERT INTO agt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“te dumatang kanan hala ta agyan muy ten Istralita, te nasin ya nangigakkad ta pasi na abbingina,” kunna kan. ");
INSERT INTO agt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","A imivwat kid na, a netugut ni Hose ya abbingen ikid na hina na en, a dumatang kid ta lugar na Istralita kiden. ");
INSERT INTO agt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ammi ta datang da ta iten a nadamag ni Hose ta intun magari i Arkelaw nga anak ni mina Heruden. A gafu ta nagtalaw hapa ig Hose ta bagu en ari a aweda nagdulot ta nagyanan da en. A tinarinap na ha ta magdulot kid ta lugar na Galileya. ");
INSERT INTO agt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A yen mantu ya nagdulotan da, a nagyan kid ta ili na Nasaret, a yen hapa ya dumakalan ni Hesus. A gafu ta kumanen a nagdulot hapa ya uhohug na aglavun kiden gafu tentu, te ya uhohug da ta surat da kiden a “Ingagan da sangaw ta Taga Nasaret,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A ta nepagpasa na addu na darun a itta ya takday lalaki nga nagngagan te Hwan, a intu hala ya nangzigut ta tolay kiden gafu ta liwat da kiden. A naglattog hapa i Hwan ta kawanan na babali ta lugar na Hudeya, te kinasaba na ya tolay kiden nga nagtalib. ");
INSERT INTO agt_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ulin muy ya gagangay muy, te ittan ya dafu tam nga nekari na Namaratu ta magturay tekitam,” pakakin tekid, ");
INSERT INTO agt_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","I Hwanen ya dana binida na aglavunen mina Isayas ta mapolu bit dumatang ammi te Afu Hesus, petta dana iparan an ya tolay kiden ta ange na. Te ya uhohug ni Isayas a intu yan: “Itta sangaw ya makipaita ta kawanan na babali, a iayayag na sangaw ya pangtabarang na ta tolay kiden, petta meparan kid mina ta datang na Dafu tamen, petta malogon mina ya iange na tekid,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A ya gagangay ni Hwan a nagbarawasi ta pinadday da en nga nagafu ta dutdut na kamelo, a sebarekas hapa ta la-las. A intu la kanan na ya dudun ikid na tahu na kalaba. ");
INSERT INTO agt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A umange tentu ya addu na tolay nga taga ili na Herusalem, ikid na ngamin kiden ili ta lugar na Hudeya, ikid na naggwadamdammang na karayan na Hurdan. ");
INSERT INTO agt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","A dana nebosag da ya liwat da kiden, kapye na kid zinigut ta karayanen. ");
INSERT INTO agt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","A ta nepakaita ni Hwan ta umange hapa magpazigut ya addu na Pariseyu ikid na Saduseyu nga mangituldu ta relisyon na Hudyo kiden a pake nagsasitangan na kid hapa. “Kuga magimmamappya kam ta pagzigut muy. Awemuy mina pahig ta melillik kam sangaw ta pama-gang na Namaratu gafu ta pagzigut muy, ");
INSERT INTO agt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","te dana ipaita muy mina ta naulin ya nonot muy, kapye muy magzigut. ");
INSERT INTO agt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","A awemuy pahig ta melillik kam sangaw gafu ta simsima kam ni mina Abraham, te ibar ku tekamuy ta itta ya pakapangwa na Namaratu nga magpabalin ta batu kidin ta simsima ni mina Abrahamen. ");
INSERT INTO agt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kuman kanan na kayu nga tokadan na Namaratu ewan, te dana neparan na ya watay na en, a awena la mabayag a tokadan na ya kayu kiden ta agyan na ramut da kiden. Te ya ngamin kiden kayu nga awan magmayan ta mappya a tokadan na kid kapye na kid iwarad ta afuy. ");
INSERT INTO agt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“A yen ta itta yak sin nga mangzigut tekamuy ta danumin, petta mepasikkal ta nauli muy ya gagangay muy. Ammi itta sangaw ya ange ta gafan ku nga pake dakdakal ya pakapangwa na ammi teyak, te maski la awek megitta nga makitagabu tentu nga mangubad ta sapatos na kiden. A intu sangaw ya mangpasinap tekamuy ta Kahalwa na Namaratu. Ammi ya awan kiden magbabawi a pa-gangan na kid sangaw ta afuy, ");
INSERT INTO agt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","te itta ya kuman na pagsap na ta tolay, a am nabalin magsap a uknudan na sangaw ya semayan, ammi apangan na sangaw ya kupat,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","A ta ye-yen kid na araw a nagganwat hapa i Hesus ta agyan na en ten Galileya, a dumatang ta karayan na Hurdan, te umange hapa pazigut te Hwan. ");
INSERT INTO agt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ammi mamat haman i Hwan nga mangzigut tentu, “Te anu haman pazigut ka teyak bakawa iyak mina ya zigutam?” kunna te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ammi ya tabbag hapa ni Hesus tentu a “Awem la igamma ya kumanin, te mappya ta sa idulot ta ya ngamin pakkwa na Namaratu tekita,” kunna. A malologon mantu i Hwan nga nangzigut tentu. ");
INSERT INTO agt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","A insigida lumattog i Hesus ta danumen, a kuman na bimangrit na hapa ya langit, a naita na ya Kahalwa na Namaratu nga nagsunak ta kuman na kalapati, a nagpotun na tentu. ");
INSERT INTO agt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","A nepagka-ma na hapa ya naguhohug ta langit. “Ye ye-yan ya Anak ku nga matakit ta nonot ku. Pake matalakanak tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","A ta nekabalin ni Hesus nagzigut a pinagtugut na Kahalwa na Namaratu petta ange tatakday ta bagbagetay kiden nga adayu ta tolay, te mappya ta attaman na hapa ya pangparuba ni Satanas tentu. ");
INSERT INTO agt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A nagyan la ten abat ta appatafulu araw ikid na hiklam, ammi awena pulus nangnangan, a sangaw pake nelunus. ");
INSERT INTO agt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","A yen hapa ya neange ni Satanas tentu, petta paruban na. “Bakkan ka hud ta Anak na Namaratu ewan? A maguhohug ka mantu ta batu kidin, petta magbalin kid ta pan, petta mangan ka,” kun ni Satanas tentu. ");
INSERT INTO agt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ammi ya tabbag hapa ni Hesus te Satanas a, “Awek O, te ya uhohug na Namaratu ta lebru na en a ‘Bakkan la ta kanan muy ya pagafun na katolay muy am awa ngamin kiden uhohug nga ibar na Dyos muy,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","A gafu ta kumanen a takwan ha ya nepangparuba ni Satanas tentu, te neange na ta ili na Herusalem ta agyan na Simbaanen, a pinatayuk na ta pingit na atap na Simbaanen. A ya nebar na ha tentu a ");
INSERT INTO agt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Bakkan ka hud ta Anak na Namaratu ewan? A maglattu kan mantu ta lutakewan, te nesurat hapa ta lebru na en ta doban na kan sangaw ya anghel na kiden nga magtaron teko, a ta-mawan da ka kan sangaw petta awem matakitan ta batu kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","A ya tabbag ha ni Hesus tentu, “Awek maglattu, te ya uhohug na takday surat na Namaratu a ‘Awemuy sangaw paruban ya pangkenga na Dafu muy Namaratu tekamuy,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","A gafu ta kumanen a neange na ha i Hesus ta pake atata-nang na bagetay, a nesaned na nepaita ya ngamin kiden lugar ta paglelehutin kontodu tolay da kiden, a “Itam ya kalalaki na lugar kidina ikid na gubyernu da,” kunna te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“A ya ngamin nepaitak teko a kwam na sangaw am makidafu ka teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","“Atsii, umadayu kan teyak, Satanas, te ya nesurat ta lebru na Namaratu a ‘Namaratu la ya dayawan muy, a intu la tatakday ya pakidafun muy,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","A ta nepagtugut ni Satanas, a umange hapa ya anghel kiden nga manguffun te Hesus nga mangpasikan tentu. ");
INSERT INTO agt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","A ta nekabalin na kumanen a nadamag ni Hesus ta nebalud dan i Hwanen nga nangzigut ta tolay kiden. A yen ta nagtugut hapa i Hesus ta lugar na Hudeya, te nagtoli ta agyan na en ta iten Galileya. ");
INSERT INTO agt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A pa nagyan bit ta ili na Nasaret, kapye na umalit hapa ta ili na Kapernayum. A ya ili na Kapernayum a nesaad ta pingit na Alug na Galileya ta lutaken nga nebingay ta tribu na Zebulun ikid na Naptali ta palungu na araw. ");
INSERT INTO agt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","A yen hala ya nagyanan ni Hesus abat ta mabayag, te sinaned na ya ngamin kiden lugar na Hudyo kiden pase Hentil kiden ta lugar na Galileya. A uray hapa yen na Namaratu petta magdulot ya inuhohug na aglavunen mina Isayas, te ya uhohug na en a ");
INSERT INTO agt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Ya Hentil kiden nga taga Zebulun ikid na Naptali a magyan kid ta sugiram ikid na ngarab na pasi, ammi nadakaran kid na, te naita dan ya masikan na zilag,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A ta neaange ni Hesus ta ili na Kapernayum a pinegafwanan na ya mangipadangag ta damag na pagturay na Namaratu ta tolay kiden, a ya nebar na hapa ta tolay kiden a “Ulin muy ya gagangay muy, te ittan ya Dafu muy nga nekari na Namaratu ta magturay tekamuy,” pakakin. ");
INSERT INTO agt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","A tentu en nagtugtugut ta pingit na Alug na Galileya a nesimmun na ya duwa na magkabagis, ig Simon nga magngagan hapa te Pedru, ikid ni Andres. A magtahukul kid na ta alugen te dumatahukul kid ta ikan, a binaran na kid. ");
INSERT INTO agt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","“Dumagdag kanan hala teyak, te ituldu ta kam petta dumatahukul kam sangaw ta tolay,” kunna tekid, ");
INSERT INTO agt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","a insigida newagak da ya tahukul da a dumagdag kid na. ");
INSERT INTO agt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A tekiden nagdulot nagtugtugut ta ba-naden a naita ni Hesus ya duwa ha na magkabagis, ig Santiago ikid ni Hwan, a nehulun kid hapa ta dama da en Zibadeyu ta barangay na en, a magpakappya kid ta tahukul da kiden. ");
INSERT INTO agt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","A binaran ni Hesus ya duwa kiden magkabagis, a insigida newagak da ya dama da en ta barangayen, a dumagdag kid na hapa. ");
INSERT INTO agt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","A sa nahahulun kid ni Hesus nga nagsaned ta ngamin kiden ili ta lugar na Galileya, te mangituldu hapa i Hesus ta kapilya na Hudyo kiden. A nepadangag na hapa ya damag na pangikerutan na Namaratu, yaga pinagmappya na hapa ya magtatākit kiden ta magdaduma na takit ikid na pagzigātān. ");
INSERT INTO agt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A alistu kumalay ya damag na pakapangwa ni Hesus addet ta lugar na Siriya ta amyanan na Galileya, a enda hapa nekarad ya ngamin kiden nagtatākit tentu. Itta ya nagtakit ta magdaduma na takit, ikid na ut-ut, ikid na seanitu, ikid na magkissiw, ikid na awan makahehit, a sa pinagmappya na kid ngamin. ");
INSERT INTO agt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A maski am had ya eyan ni Hesus a dumadagdag hapa ya awan bababang na tolay nga taga Galileya, ikid na lugar na Dikapolis, ikid na ili na Herusalem, ikid na lugar na Hudeya, ikid na dammang na karayan na Hurdan. ");
INSERT INTO agt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","A gafu ta dumadagdag hapa ya pake addu na tolay teg Hesus a gimon kid hapa ta bagetay. A ta nepagtuttud ni Hesus a enna hapa kinalihung na ituldu na kiden petta dangagan da ya ituldu na. ");
INSERT INTO agt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A ya netuldu na tekid a intu yan: ");
INSERT INTO agt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ya ngamin kiden makkamu ta itta ya pagkurangan da a nagāsāt kid, te Namaratu sangaw ya makkamu tekid,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","A ya magdamdam hapa gafu ta dulayen ta paglelehutin a nagāsāt kid hapa, te Namaratu sangaw ya manabtabang ta damdam da. ");
INSERT INTO agt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","A nagāsāt hapa ya ngamin kiden masippat, te yen kid sangaw ya makaalap ta ngamin lutakin nga pinadday na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","A nagāsāt hapa ya ngamin kiden iminam ta mappya na gagangay, te uffunan na kid hapa sangaw na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","A ya ngamin kiden makipagrikna ikid na mangikallak a nagāsāt kid hapa, te ikid hapa ya ikallak na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","A nagāsāt hapa ya tolay kiden nga matunung ya agnonotan da, te maita da sangaw ya Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","A nagāsāt hapa ya ngamin kiden mangpakappya ta magtatapil, te yen kid ya ikwenta na Namaratu ta anak na nga megitta tentu. ");
INSERT INTO agt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","A ikamuy hapa nga tapangan da gafu ta matunung ya gagangay muy a nagāsāt kam hapa, te Namaratu sangaw ya makkamu tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“A am angarigan mantu ta amāmatan da kam, ikid na tapangan da kam, ikid na padpadulayan da kam gafu ta pangurug muy teyak a nonotan muy ta nagāsāt kanan. ");
INSERT INTO agt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","A mappya ta magayayat kanan, te pake dakal sangaw ya isagolyat na Namaratu tekamuy. A awemuy la magdamdam, te nonotan muy mina ya aglavun kiden na Namaratu ta palungu na araw, te kagitta muy kid hapa nga natapangan.” ");
INSERT INTO agt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","A ya netuldu na para tekid a “Ikamuy nga mangurug teyak a kuman kam na asin nga mekikkihu ta awan kiden mangurug, te ikamuy mina ya mangatad ta pagkappyanan da. Ammi nonotan muy mina ya gagangayen asin, te am imawan ya apgad na a awan sangaw ta kapkappyan na, a mewarad sangaw ta dalan, petta kelubegan na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“A ya takday para pangiangarigan ku tekamuy a ikamuy hapa ya kuman na zilag nga magpadakar ta tolay kiden. A mappya mantu ta awemuy ilingad ya pagdakar muy, petta pake maita ta kuman na ili nga napatayuk ta toktok na bagetay. ");
INSERT INTO agt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","A am itta ya nagpagatang ta zilag na ta bali na a enna hud itagu ta umag na kalamba awa itun na haman ta kabagawan na, petta madakaran ya ngamin umag na bali en. ");
INSERT INTO agt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","A kumanen hapa mina tekamuy, te mappya ta awemuy ikamat ya pagdakar muy ta ikattolay muy kiden, petta maita da hapa ya kappyanan na tarabaku muy, a ikayat da hapa sangaw dayawan ya Namaratu ta kuman na ikamuy. ");
INSERT INTO agt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“A awemuy mina pahig ta yen ya neangek sin petta azin ku ya lintig na Namaratu ikid na nesurat na aglavun kiden, te awek kid azin awa pake ipaitak hud la ya ikayat da uhohugan, ");
INSERT INTO agt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","te ya pake ibar ku tekamuy a mapmappya ta lumitap ya langitewan pase lutakin ammi ta maazi ya maski kaassangan na letra ta lintig na en, te mappya ta sa magdulot ya ngamin nesurat ta lintig na en. ");
INSERT INTO agt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Am itta sangaw ya magsoysoy ta maski kaassangan na uhohung ta linteg na en, anna sanatan na hapa ya kadwan tolay petta magsoysoy kid hapa, a awena sangaw mesipat ta iturayan na Namaratu ewan. Ammi ya kanayun mangidulot ikid na mangituldu ta lintig na en a yen kid sangaw ya igitta na Namaratu ta kaispotan na tolay na kiden. ");
INSERT INTO agt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Te ya pake ibar ku tekamuy a mapmappya mina ta magsurok ya kappya muy ammi ta kappya na Pariseyu kiden nga kampon la mappya ya tarabakun da, te am awan a awemuy sangaw mesipat ta iturayan na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Dana nadangag muy hapa ya netuldu da ta popolu kiden dadagkal muy ta ‘Awemuy mamapasi ta tolay, te maski am inya sangaw ya mamapasi a medarum sangaw ta atubang na mangpa-gang ta makaliwat,’ kunda tekid. ");
INSERT INTO agt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ammi ya uhohug ku tekamuy ta ayanin a maski am magporay kam ta ikattolay muy a medarum kam sangaw ta atubang na Namaratu ewan. Te am ‘Awan ka ta kapkappyan,’ kummuy ta ikattolay muy a medarum kam ta atubang na mangpa-gang ta makaliwat, a mewarad kam sangaw ta pangtaguhali na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","A am angarigan mantu ta itta ka ta bali na Namaratu nga makimallak, a manonot mu ya liwat mu ta kagittam tolay, ");
INSERT INTO agt_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","a e ka bit makikoma tentu, kapyem ange ha makimallak. ");
INSERT INTO agt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","A am itta ya mangidarum teko gafu ta liwat mu tentu a mappya ta alistu ka makikoma tentu ta awena para la nepangidarum teko. Te am nedarum na kan ta kwes a igawat na ka sangaw na kwes ta polis petta ibalud da ka. ");
INSERT INTO agt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A talaga ta awem sangaw makauhet abat ta nabalin na ya pangikarum ta ngamin liwat mu. ");
INSERT INTO agt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“A dana nadangag muy hapa ya netuldu ni mina Moses ta idi ta ‘Awem mangadallaw,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ammi ya uhohug ku tekamuy ta ayanin a maski am inya ya mangit-ita ta babbay gafu ta pagattugān na a nekwenta hala ta mangadallaw ya nonot na en. ");
INSERT INTO agt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A yen ta ibar ku ta tagtakday tekamuy ta am magliwat ka mina gafu ta sanatan na ka na takday matam a mappya ta kilotam ya matamen petta iwarad mu, te mapmappya ta mewarad ya takday la na matam ammi ta sa mewarad sangaw ya ngamin barim ta pangtaguhali na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A am masanat ka magliwat gafu ta takday kamat mu a mappya ta gappakam ya kamat men petta iwarad mu, te mapmappya ta awan ya takday kamat mu ammi ta sa mewarad sangaw ya ngamin barim ta pangtaguhali na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“A ya netuldu hapa ni Moses ta idi a ‘Maski am inya ya makigungay ta atawa na a mappya ta atadan na ta papel na pakigungay na tentu,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ammi ya uhohug ku tekamuy ta ayanin a maski am inya na lalaki ya makigungay ta atawa na a ya lalaki en sangaw ya makaliwat am makiatawa ha ya negungay na en, te kuman na napersa nakikadallaw, ammi awan bale am apolu nakikadallaw ya babbayen kapye na igungay na lalaki en. A maski am inya ya mangatawa ta negungay na en a nekwenta hala ta mangadallaw. ");
INSERT INTO agt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“A dana nadangag muy hapa ya netuldu ta dadagkal muy kiden gafu ta pagpagasing muy, te ya nebar ni mina Moses a ‘Am itta ya ikarim nga ipagasingam ta Namaratu ewan a awem mantu mangilogot, te idulot mu ya nekari men,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ammi ya uhohug ku tekamuy a awemuy malat magpagasingan ta maski am anu ya ngagan na, te makaliwat kam. ‘Ampade mahunnak sangaw ya langit am tulad ya ikari kin teko,’ awemuy kumin, te pagyanan na Namaratu ya langitina. ");
INSERT INTO agt_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","‘Ampade lumitap ya lutakin am awek idulot ya kinan ken,’ awemuy hapa kumin, te ya lutakin ya pagkasoyadan na takki na Namaratu ewan. A awemuy hapa ikabat ya ili na Herusalem, te yen sangaw ya pagyanan na Ari en nga pagtogkokan na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","A awemuy hapa ikabat ya huk na ulu muy, te awan haman ta makkwa muy ta huk muy petta mauli mina. ");
INSERT INTO agt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Am itta ya onan muy a ‘On,’ kummuy la ten. A am itta ya aweyan muy a ‘Awek,’ kummuy la ten. Te am magpagasingan kam para a yen ya tarabaku ni Satanas. ");
INSERT INTO agt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“A ya takday ha nadangag muy nga netuldu ni mina Moses a ‘Am itta ya mangbattak ta matam a battakam hapa ya mata na. A am pakkan na ya ngipam a pakkam hapa ya ngipan na,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ammi ya uhohug ku tekamuy ta ayanin am itta ya mangwa ta dulay tekamuy a awemuy la ibalat. Am lappagan na ya pahingil mu a itayam hala tentu ya taakub. ");
INSERT INTO agt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A am idarum na ka petta alapan na ya barawasim a iatad mu hala kontodu kamasitam. ");
INSERT INTO agt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A am persan na ka mehulun tentu abat ta takday kilumetru a hulunam la maski abat ta duwa na kilumetru. ");
INSERT INTO agt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Am itta ya adangan na ono gubatan na teko a iatad mu la. ");
INSERT INTO agt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“A ya takday ha nga nadangag muy nga netuldu da ta idi a ‘Iddukam ya makikofun teko, ammi ya makitapil teko a awem la ikallak,’ kunda. ");
INSERT INTO agt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ammi ya uhohug ku tekamuy a iddukan muy ya makitapil tekamuy, a pakimallak muy hapa ya mangigaged tekamuy, ");
INSERT INTO agt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","pettam megitta kam ta Dama muyewan Namaratu. Te ya gagangay na Dama muyewan a paglattogan na ya bilag na en ta ngamin tolay, dulay am dulay ikid na mappya am mappya, yaga pagudanān na hapa ya agyan na magliwat pase awan magliwat. ");
INSERT INTO agt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","A mappya ta kunna ten ya tarabakun muy, te am intu la iddukan muy ya mangidduk tekamuy a itta hud sangaw ya pangsagolyat na Namaratu tekamuy, te awan haman ta pagdaduman muy na magdarogas kiden nga mangidduk ta mangidduken tekid. ");
INSERT INTO agt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A am intu la pagdulotan muy ta bali muy ya kahulun muy kiden a had kukunna mantu imaddu na tarabaku muy ammi ta tarabaku na awan kiden makkamu ta Dyos muy. ");
INSERT INTO agt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mappya mantu ta awan ta taliban muy ta pangidduk muy petta megitta kam ta Dama muyewan Namaratu, te awan ta idaduma na ta ngamin tekamuy.” ");
INSERT INTO agt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","A ya ituldu para ni Hesus tekid a “Itan muy ta ipabuya muy ya kappya muy ta atubang na tolay petta dayawan da kam, te am kunna ten ya tarabakun muy a awan sangaw ta pangsagolyat na Dama muyewan tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","A am angarigan mantu ta manglimut kam a awemuy ipadangag ya panglimut muy ta kuman na gagangay na magimmamappya kiden, te intu la pangatad da am itta kid ta umag na paggagimungan ikid na dapun, petta pahig na tolay kiden ta masikan ya pangidulot da ta lintig na Namaratu. Ammi ya pake ibar ku tekamuy a naalap dan ya sagolyat da ta pangdayaw na tolay kiden tekid. ");
INSERT INTO agt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A am angarigan mantu ta manglimut kam a awemuy la ibabar maski ta pake abikanen nga kofun muy, ");
INSERT INTO agt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","te mangatad kam hud la am awan ta makaita, a ya Dama muyewan nga makaita ta ngamin ya mangsagolyat sangaw tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“A kumanen hapa am makimallak kam ta Namaratu a awemuy la parigan ya magimmamappya kiden nga ape la magdayaw ta Namaratu. Te am makimallak yen kid a ikayat da ipaita ya pakimallak da ta umag na kapilya da ikid na ang-angen na tolay, petta pahig na tolay kiden ta abikan kid ta Namaratu, ammi naalap dan malat ya sagolyat da ta pangdayaw na tolay kiden tekid. ");
INSERT INTO agt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A am itta mantu ya mayat makimallak a ange mina tatakday ta awan ta totolay nga makaita ikid na makadangag tentu. A ya Dama na ewan nga awan maita a intu hapa la sangaw ya makaita ikid na mangsagolyat tentu. ");
INSERT INTO agt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“A kumanen hapa am makimallak kam tentu a awemuy totolin uhohugan ya takday la ta kuman na akkimallak na Hentil kiden ta dyos da kiden. Parig da ta dangagan na kid na dyos da gafu ta kaddu na uhohugan da, ");
INSERT INTO agt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ammi awemuy parigan ya akkimallak da, te ya Dama muy ta langitewan a dana amu na am anu ya masapul muy maski awemuy para la inadang tentu. ");
INSERT INTO agt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“A mappya mantu ta kumanin ya pakimallak muy: ‘Ay, Afu, nga Dama mi ta langit, ampade nonotan na ka mina na ngamin tolay sin, petta sa ikamat da ya ngagam, ");
INSERT INTO agt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ikid na makituray kid teko, petta kanayun magdulot hapa ya ngamin ikayat mu ta lutakin ta kuman na tarabakun da ta langitina. ");
INSERT INTO agt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","A atadan na kami haen, Afu, ta kanan mi ta kinanghahaw. ");
INSERT INTO agt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","A pakoman na kami hapa ta liwat mi kiden teko, te napakoma min hapa ya nagliwat tekami. ");
INSERT INTO agt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","A awena kami doban ta pagliwatan mi, am awa ikerutan na kami hud la ta pangparuba ni Satanas tekami. Amen.’ ");
INSERT INTO agt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“A mappya ta dana pakoman muy ya nagliwat tekamuy kapye muy makipakoma ta Dama muyewan, petta pakoman na kam hapa. ");
INSERT INTO agt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Te am awemuy pakoman ya ikattolay muy nga nagliwat tekamuy a awena kam mantu pakoman na Dama muyewan ta liwat muy. ");
INSERT INTO agt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“A am ngilinan muy ya arawen nga aweda pangan gafu ta damdam muy ikid na pakimallak muy a awemuy ipaita ya damdam muy ikid na bisin muy ta kuman na magimmamappya kiden nga ape magdamdam, te dana tunan da ya ulu da ikid na mukat da ta lafu, petta maita na tolay kiden ta aweda pulus mangmangan. Ammi naalap dan malat ya sagolyat da ta pangdayaw na tolay kiden tekid. ");
INSERT INTO agt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","A am awemuy mantu mangan a magamwas kam ikid na magtagetay kam ta kuman na gagangay muyen hala, ");
INSERT INTO agt_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","petta bakkan ta tolay ya makaita ta awemuy pangan am awa Dama muyewan nga awemuy maita, a intu hapa la ya makkamu ta damdam muy ikid na mangsagolyat tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“A mappya hapa ta awemuy maguknud ta pagba-nang muy ta lutakin, te perdin na sangaw na ulolag ikid na duping, yaga sarokan na sangaw na tulisan petta takawan na. ");
INSERT INTO agt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mapmappya hud la ta isaned muy ya sobra na kwa muy, petta magserbi ta kappyanan na ikattolay muy kiden. Te am kunna ten ya tarabakun muy a itta sangaw ta Namaratu ewan ya pagba-nangan muy nga awan maperdi, a awena masi-ged na tulisan. ");
INSERT INTO agt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Te am itta la ta Namaratu ewan ya pake kengan muy a yen la ya agyan na nonot muy. ");
INSERT INTO agt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ya mata muy kidina ya mangatad mina ta dakar na bari muy, a am mappya ya mata muy a sa madakaran ya ngamin bari muy. ");
INSERT INTO agt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ammi am dulay ya mata muy a sugiram hapa sangaw ya ngamin bari muy. A am sugiram mantu ya magdakar mina ta bari muy a pake sugiram kanan. ");
INSERT INTO agt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","A yen ta ibar ku hapa tekamuy ta awena mabalin ta duwa ya dafu muy, te am pake ikayat muy ya takday a kuman na ikatupag muy ya takdayen, a am sa idulot muy ya ikayat na takday a kuman na aweyan muy ya takdayen. A yen ta awemuy mapaggindan manonot ya Namaratu ikid na pagba-nang muy hapa. ");
INSERT INTO agt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“A ya pake ibar ku mantu tekamuy a awemuy mina burungan ya pagkatolay muy am anu sangaw ya kanan muy ikid na inuman muy. A awemuy hapa burungan am anu sangaw ya pagbarawasi muy, te Namaratu haman ya nangatad ta bari muy ikid na angat muy, a awena hud iatad ya magserbi ta angat muy ikid na bari muy? ");
INSERT INTO agt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Intu mina pagnonotan muy ya mamanuk kiden, te aweda haman magmula ikid na maggapas, yaga aweda haman maguknud ta kanan da, ammi mangan kid hala, te ya Dama muyewan ya makkamu ta kanan da. Ammi tekamuy a pake mesasita kam tentu ammi ta mamanuk. ");
INSERT INTO agt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A maski am magburung kam mina a itta hud ya medagga ta pagkatolay muy maski ta takday la na oras gafu ta pagburung muy? ");
INSERT INTO agt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","A annun muy hapa burungan ya pagbarawasi muy? Itan muy la ya lappaw kiden awa aweda haman magbannag magdaget ta kuman na barawasi da, ammi magispot kid hala. ");
INSERT INTO agt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pake is-ispot kid ammi ta Ari en mina Solomun, te awena haman negitta na kalalaki na nepagbarawasi na ta kalalaki na lappaw kiden. ");
INSERT INTO agt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A am kumanen mantu ya kalalaki na pabarawasi na Namaratu ta kaddat kiden nga makalimagan kapye da matongradan a awan hud ta pangkenga na tekamuy ta pagbarawasi muy? “Anu haman ta assang la ya pangikatalak muy tentu? ");
INSERT INTO agt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Awemuy mantu burungan am had ya pangalapan muy sangaw ta kanan muy ikid na inuman muy ikid na pagbarawasi muy, ");
INSERT INTO agt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","petta awemuy megitta ta awan kiden makkamu ta Dyos muy, te yen kid ya kuga mafulotan nga magburung ta pagkatolay da. Ammi ya Dama muyewan ya makkamu ta ngamin masapul muy, ");
INSERT INTO agt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","a am intu apolu karagatan muy ya ikayat na Namaratu ikid na patarabaku na tekamuy a sa medagga hapa sangaw ya ngamin masapul muy. ");
INSERT INTO agt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","A awemuy mantu burungan ya masapul muy sangaw ta lakwat, te awemuy para la amu am anu ya dumatang ta lakwat. A awemuy mina daggan ya burung muy, te gustun ya burung muy para ayanin na araw.” ");
INSERT INTO agt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","A ya ituldu para ni Hesus tekid a “Awemuy ka-ma la palpaliwatan ya ikattolay muy, talo am paliwatan na kam sangaw na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Te am anu ya pangitan muy ta kadwan a kumanen hapa sangaw ya pangitan na Namaratu tekamuy. A ya pangikwenta muy ta ikattolay muy a kumanen hapa sangaw ya pangikwenta na Namaratu tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ya ibar ku ta tagtakday tekamuy a anu haman ta ihuyam ya salasangkap ta mata na ikattolay mu, am awem maamu ta itta hapa ya tarosu ta matam. ");
INSERT INTO agt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A pa-pa-num maazi ya salasangkap na am itta para la ya tarosu ta matam? ");
INSERT INTO agt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kuga magimmamappya ka. Azim bit ta apolu ya tarosu ta matam, a sangaw magdakar ya pakaitam, pettam maazim ya salasangkap ta mata na ikattolay mu. ");
INSERT INTO agt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“A am ikayat muy bidan ya mappya nga netuldu na Namaratu tekamuy a itan muy ta awemuy bidan ta kuman na atu kiden nga malogon magporay, talo am tapilan da kam sangaw. A awemuy hapa iwarad ya mapateg teko ta atubang na awan kiden makanonot talo am ilublubeg da la sangaw ta kuman na bahuy kiden. ");
INSERT INTO agt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","“A am itta ya masapul muy a adangan muy la ta Namaratu, te iatad na hala tekamuy, te am kanayun apagan muy ya ikayat muy tentu a maapagan muy hala, a am magtoktok kam tentu a hukatan na kam. ");
INSERT INTO agt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Te maski am ikamuy ya pagadangan na anak muy ta kanan na a batu hud ya iatad muy tentu? ");
INSERT INTO agt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","A am dalag ya adangan na a ulag hud ya iatad muy? ");
INSERT INTO agt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A yen mina ya pagnonotan muy, te maski am seliwat kam a amu muy haman mangatad ta kappyanan ta anak muy kiden. A kontimas mantu ta mangatad i Dama muyewan ta kappyanan ta magadang tentu. ");
INSERT INTO agt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“A am anu ya ikayat muy ta ipaita na ikattolay muy tekamuy a mappya ta kumanen hapa ya ipaita muy tekid, te yen ya fun na ngamin patarabaku na Namaratu tekamuy nga nesurat ta lintig na en ikid na lebru na aglavun kiden. ");
INSERT INTO agt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“A am ikayat muy simarok ta pagtolayan muy a mappya ta angen muy ya mailaten sasarokan, te maski am malmalogon ya dalan ta agyan na alawa en sasarokan a yen haman ya ange ta kaperdin na kahalwa muy, a addu hapa ya kahulun muy, te yen ya angen na addu na tolay. ");
INSERT INTO agt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ammi assang la na tolay ya makadatang ta agyan na pagtolayan, te ilat ya sasarokan na, yaga mazigat hapa ya dalan na en. ");
INSERT INTO agt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“A itan muy hapa ta maayayyaw na kam sangaw na ape mangipadangag ta uhohug na Namaratu, te am e kid tekamuy a igitta da ya bari da ta kuman na mangurug, ammi ya nonot da ya kuman na nonot na atu en nga magkalong. ");
INSERT INTO agt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","A ya gagangay da ya pakaitan muy ta kaladdud da, te awena haman negitta ta uhohugan da. Am maita muy ya lanut na mawini a yen hud ya pakaitan muy ta mayan na patani? A am ambabanga a yen hud ya pakaitan muy ta mayan na anyog? ");
INSERT INTO agt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","A kumanen hapa ta kompormi na kayu, te am mappya ya fun a magmayan hud sangaw ta dulay awa mappya haman. Ammi am dulay ya fun a magmayan hud ta mappya awa dulay hapa ya mayan na en. ");
INSERT INTO agt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","“A kumanen hapa ta ange kiden mangituldu tekamuy, te ya tarabaku da ya pakkamun muy tekid am mappya kid ono am matulad kid. A ya ngamin kiden fun nga awan magmayan ta mappya a matukad kid hala sangaw petta mewarad kid ta afuy. ");
INSERT INTO agt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","A maski am ibar da ta iyak ya dafu da a bakkan ta yen kid sangaw ya pasarokan ku ta agyan na Namaratu ewan, te intu la sangaw makasarok ya mangidulot ta ikayat ni Damakewan. ");
INSERT INTO agt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“A sangaw ta araw na pama-gang na ta awan kiden mangurug a addu sangaw ya makikekallak teyak, te ‘Afu, Afu, ikallak na kami, te ikami paen ya nangipadangag ta ngagam, a ya ngagam hapa ya nepagpatugut mi ta anitu, a addu hapa ya pinadpadatu mi, Afu, gafu ta kalalaki na ngagam,’ kunda sangaw teyak. ");
INSERT INTO agt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ammi ya ibar ku sangaw tekid a ‘Umadayu kanan teyak, ikamuy nga magtarabaku ta awan kustu, te bakkan haman teyak ya nangidob tekamuy,’ kunku sangaw tekid. ");
INSERT INTO agt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“A am pake nonotan muy ya ngamin kiden netulduk tekamuy petta yen kid ya tarabakun muy a megitta kam hapa ta kuman na nakanonoten nga nagbali ta maladda na bali. Te ya nakanonoten nagbali a dana nagpili ta maladda na arigi, kapye na kid nekali ta adalam. ");
INSERT INTO agt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A tentu en nagkawan ta agyan na bali na en a pirmi ya sikan na paddaden ikid na udanen addet ta naglayus, ammi awena hala natukalit na bali na en te maladda haman ya arigi na kiden yaga adalam hapa ya kali da. ");
INSERT INTO agt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ammi ya awan kiden mangdangag ta uhohug ku kiden a megitta kid ta kuman na awanen nakanonot nga nagbali ta malogon matukalit. Te ya awanen nakanonot a nangalap ta magdalikompormi na arigi, yaga netunglak na kid ta assang la. ");
INSERT INTO agt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A tentu en nagkawan a pirmi ha ya sikan na paddaden ikid na udan ikid na layus ta agyan na bali na en, a piga la ya katukalit na, a sa nakutukutet hapa.” ");
INSERT INTO agt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","A yen bit la ya addet na netuldu ni Hesus ta tolay kiden, ammi nepagpaka-lat da hapa ya gagangay na pangituldu na, ");
INSERT INTO agt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","te nangituldu ta kuman na intu ya makkamu ta ngamin, a bakkan ta kuman na gagangay kiden nangituldu tekid. ");
INSERT INTO agt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","A gafu ta nabalin na i Hesus nangituldu a dumagut na ta bagetayen, a dimadagdag hapa ya pake addu na tolay. ");
INSERT INTO agt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A ka-ma la itta ya takday lalaki nga naggalis, a umange namalentud ta atubang ni Hesus. “Ay Afu, ikallak nak haen, te amuk ta maurum ya tabbit kin am ikayat mu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","A ya uhohug ni Hesus ta nepangisi-ged na ta lalaki en, a “Ikayat ku hapa, a itam awa malinis na ya tabbit mina,” kunna. A ka-ma la imawan ya galis na en. ");
INSERT INTO agt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","A ya uhohug para ni Hesus tentu a “Itam ta awan ta pangibibidam ta isin, ammi em ipaita ya barim ta padi en ta simbaanen petta maita na ta awan na ya galis men, a iatad mu hapa tentu ya iatang na ta kuman na nebar ni Moses ta lintigen, te yen sangaw ya mangipasikkal ta tolay kiden ta nagmappya kan,” kunna. A sangaw nagdulot hapa i Hesus ta ili na Kapernayum. ");
INSERT INTO agt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","A tentu en simarok ta ili en a itta hapa ya kapitan na suddalu nga taga Roma, a umange nangdafung tentu. ");
INSERT INTO agt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ikallak nak haen, Afu, te itta ya tagabuk ta bali nga awan makahehit, a pake mazigatan na,” kunna te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“A entanan mantu ta balim petta pagmappyan ku,” kunna hapa ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ammi ya uhohug na hapa te Hesus a “Maski awem la ange ta bali, Afu, te awek megitta ta kappyam. A ibar mu la ya kakustun na pagmappya na a amuk ta magmappya hala, ");
INSERT INTO agt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","te maski iyak, Afu, a itta ya mangituray teyak, yaga itta hapa ya suddalu nga iturayan ku. A am ‘E ka ten,’ kunku ta takday a ange hala ten. A am ‘E ka sin,’ kunku para ta takday a ange hala teyak. A am ‘Kwam yan,’ kunku ta tagabu ken a kwan na hala. A kontimas mantu ta makkwa hapa ya ngamin uhohugam,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","A pake nepagpaka-lat ni Hesus ya inuhohug na kapitanen, a dinayawan na hapa ta atubang na tolay kiden nga dumagdag tentu. “Pake masmasikan haman ya pangikatalak na kapitanen ammi ta Istralita kiden. Te maski am ikid ya pinili na Namaratu ta tolay na a awan para la ta naitak tekid nga mangikatalak tentu ta kuman na kapitanin,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“A pake ibar ku hapa tekamuy ta pake addu para sangaw ya mangurug nga taga ngamin kiden lugar ta paglelehutin. A maski am bakkan ta Istralita kid a mesipat kid hala sangaw teg mina Abraham ikid ni mina Isak ikid ni mina Hakob ta pangikerutan na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ammi ya Istralita kiden nga apolu pinili na a melogot sangaw ya pake addu tekid, te meabbang kid sangaw ta agyan sugiram, a magyan kid la ten makatangtangit ikid na magngahitam,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","A ya nebar na hapa ta kapitanen a “Dumatang kan la ta balim, te nabalin na ya inadang men teyak ta kuman na nekatalak mu,” kunna. A negindan hapa ya nepagmappya na tagabu na en ta nepaguhohug ni Hesusen. ");
INSERT INTO agt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","A ta nepagtugut nig Hesusen a kumin kid ta bali ni Pedru. A ta datang da ta bali na en a neddatangan da ya katahungan ni Pedru nga babbay nga umaidda, te nagpatu. ");
INSERT INTO agt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A enna sini-ged ni Hesus ya kamat na en, a yen hapa ya nepagkamag na patu na en. A sangaw nagtayuk hapa, a enna nepagafuy ig Hesusen. ");
INSERT INTO agt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","A sangaw ta hiklam a itta ya nagdadatang ta bali da en nga ange mangikahad ta addu na seanitu ikid na magtatākit. A pinatugut ni Hesus ya anitu na seanitu kiden ta kasikan na uhohugan na, yaga pinagmappya na hapa ya ngamin kiden nagtatākit. ");
INSERT INTO agt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A gafu ta kumanen a nagdulot hapa ya inuhohug na aglavunen mina Isayas, te ya uhohug na en a “Intu ya nangazi ta pagkafuy tam ikid na nagpamappya ta takit tam kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","A ta takday ha na araw a itta kid ta pingit na alug, a umange hapa kumalihung ya pake addu na tolay. Ammi ya uhohug ni Hesus ta ituldu na kiden a “Entanan ta dammangewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","A ka-ma la umabikan hapa tentu ya takday mangituldu ta lintig na Namaratu, a “O, Mistro,” kunna te Hesus, “Dumagdagak hapa teko, te maski had sin ya eyam,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","“A pake kakallak ka sangaw am dumagdag ka teyak, te maski am iyak ya Tolayen nga Taga Langit a awan haman ta datangan ku ta pagibannagan ku mina. A mapmappya haman ya kasasaad na mungaw ikid na mamanuk kiden, te itta haman ya pagyanan da,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A sangaw pehulun hapa ya takday para na ituldu na, te “Dumagdagak hapa sangaw teko, Afu, ammi indagan ku bit ya pasi ni damaken, te itanam ku,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ammi ya uhohug ni Hesus tentu a “Bay-am la, te ya awan kiden matolay ta Namaratu a yen kid mina ya makkamu mangitanam ta kahulun da kiden nasi, ammi teko a dumagdag kan teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","A ta nepaglugan ni Hesus ta selayagen a dumagdag hapa ya ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","A tekid para la dumakit ta alugen a nasidug na i Hesus ta selayagen, a ka-ma la nagsikan na ya paddaden ta kuman na kawan, a lima-nug na ya danum na alugen ta umag na selayag da en. ");
INSERT INTO agt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","A gafu ta nagburung na ya kahulun na kiden a enda hapa hinukal i Hesus. “Ay Afu, ikerutan na kami, te lumammad kitanan,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","“A anu haman ta magburung kam? Kuga assang la ya pangikatalak muy,” kunna hapa tekid. A tentu en nagtayuk a “Magimmang kanan,” kunna ta paddaden ikid na palung kiden, a nagimmang kid na, a nagsimpan ya danumen. ");
INSERT INTO agt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A pake nagpaka-lat hapa ya kahulun na kiden tentu, a “Anu panaw ya katolay na tolayin yan, te maski ya paddad ikid na palung a kurugan da hala ya uhohug na,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","A tekiden nakadatang ta dammang na alugen a itta kid na ta lugar na Gadareno kiden, a nepagka-ma ni Hesus ya duwa na lalaki nga pinagguyung na anitu da kiden, te bagu nagafu kid ta agyan na tanam kiden. Pake maporay kid kan ta idi addet ta magtalaw ya tolay kiden nga magtalib ta agyan da. ");
INSERT INTO agt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A ta nepakaita da te Hesus a naggihawa kid tentu, “Iko kad ya Anak na Namaratu ewan, ammi anu itta ka sin tekami? Awena kami haen pakākāllakan, te awan para la ya araw mi en,” kunda te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A gafu ta itta hapa ya addu na bahuy nga magdukdukit ta sang adayu tekid, ");
INSERT INTO agt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","a inadang na anitu da kiden ta yen kid ya pangidoban ni Hesus tekid. “Am patugutan na kami ta lalaki kidin a doban na kami mantu ta bahuy kidewan,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“A e kanan mantu,” kun ni Hesus ta anitu da kiden, a nagtugutan da ya lalaki kiden, kapye da simarok ta bahuy kiden. A ka-ma la nagadukal ya bahuy kiden bumilag, a sa nagurdak kid ta gatab na bagetayen kapye da nagkahunnak ta alugen, a sa nagkalimat kid na. ");
INSERT INTO agt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A ya nagtahon kiden ta bahuy kiden a nagbabilag kid na hapa nga ange ta ili, a nedanug da hapa ya ngamin naita da ta nepagpamappya ni Hesus ta duwa kiden lalaki. ");
INSERT INTO agt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A magananwan la a imuhet ya ngamin kiden tolay ta ili, te enda itan i Hesus. Ammi ta datang da tentu a aweda haman pinagdulot awa nebar da hud la ta umadayu ta agyan da. ");
INSERT INTO agt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","A naglalugan mantu ha ig Hesus ta selayag da en, a nagtoli kid ha ta nagafun da en ta dammang, a dumatang kid na ta ili na en. ");
INSERT INTO agt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Awena la nabayag a itta ya enda nekahad nga awan makahehit ta bali en nga nagyanan ni Hesus, a nesarok da ta bali en nga umaidda para la ta pagiddan na en. Naita ni Hesus ta itta ya pangikatalak da tentu a naguhohug hapa ta awanen makahehit. “Matalak ka la, Aleng, te pakoman kun ya liwat mu kiden ta Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ammi ya kadwan kiden nga mangituldu ta relisyon na Hudyo kiden nga gituttudan hapa ta umag na bali a linibakan da hapa ya inuhohug ni Hesus ta nonot da hapa la. “Dulay mantu yan na tolay te ugtulān na haman ya turay na Namaratu,” kun na nonot da. ");
INSERT INTO agt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ammi narikna ni Hesus ya nonot da, a “Anu haman ta libakan muy ya inuhohug ken? ");
INSERT INTO agt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Had sin hud ya malmalogon, am pakoman ku ya liwat na kiden ono am pagmappyan ku petta makatugut? ");
INSERT INTO agt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ammi itta ha ya ibar ku ta awanin makahehit, petta amu muy ta itta ya turay na Tolayen taga Langit nga mangpakoma ta liwat na tolay kiden,” kunna tekid. A ya nebar na en ta awanen makahehit a “Imivwat kan, Aleng, te alapam na ya pagiddamina a dumatang kan ta balim,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A imivwat kad, kapye na magtugut, a nagdulot hapa ta bali na. ");
INSERT INTO agt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","A ta nepakaita na tolay kiden ta nagmappyan ya lalaki en a nahigalan kid na, otturu dinayawan da ya Namaratu gafu ta inatadan na ya tolay ta kuman na turay na en. ");
INSERT INTO agt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","A ta nepagtugut nig Hesus ta iten a nasimmu na hapa ya takday agsingir ta bwis nga imatuttud ta lugar na pagpagan na tolay kiden ta bwis da, a i Matyu ya ngagan na agsingiren. A ya uhohug ni Hesus ta pagtalib na tentu a “Dumagdag kan teyak petta ituldu ta ka,” kunna tentu, a imikkat hala nga dumagdag tentu, a sa nagdulot kid ta bali ni Matyu. ");
INSERT INTO agt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","A ta datang da ta bali na en a sa magkakan kid. A sakā makikkanan hapa ya addu na agsingir ta bwis ikid na dulay kiden na tolay teg Hesus ikid na ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","A ta nepakaita na Pariseyu kiden te Hesus ta makikkanan hapa ta bali ni Matyu a linibakan da hapa, ammi ya ituldu na kiden ya nangibaran da; “Anu haman ta makikkanan ya mistro muy ta agsingir kiden ta bwis ikid na dulay na tolay?” kunda. ");
INSERT INTO agt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ammi nedangagan na kid ni Hesus, a intu ya tumabbag tekid: “A on ay, te gagangay haman ta ange ya manguru en ta agyan na magtakit kiden, te yen haman ya makaapag tentu. ");
INSERT INTO agt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","A mappya hapa ta pake nonotan muy am anu ya ikayat na Namaratu, te ya uhohug na ta suraten a ‘Bakkan ta intu ikayat ku ya pangatang muy teyak, te mapmappya ta ikallak muy ya ikattolay muy kiden,’ kunna. A bakkan ta yen ya umeyan ku sin petta padagdagan ku ya awanen ta liwat am awa seliwat kiden,” kunna ha tekid. ");
INSERT INTO agt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","A ta nekabalin na kumanen a dumatang hapa ya iduldu kiden ni Hwan, te itta ya ipohut da te Hesus. “Anu kawagan na, Afu, ta awena ngilinan na ituldum kiden ya arawen nga aweda pangan, te ikami ikid na Pariseyu kiden a ngilinan mi haman?” kunda. ");
INSERT INTO agt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A ya tabbag hapa ni Hesus tekid a “Mabalin hud ta magdamdam ya makiboda kiden am itta para la tekid ya magboda en? Itta la sangaw ya araw am metugut tekid, a yen sangaw ya pagngilin da ta arawen nga aweda pangan gafu ta damdam da tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","A ya nebar na hapa tekid, a kuman na keangarigan, “Bagu yan kid na araw,” kunna. “A am parigan tam ya awan kiden mangan a igitta tam ya agangwa tam ta kuman na magpissang ta bagu na ga-gamit petta itta ya itakup na ta dana en barawasi. A sangaw am kumbat ya bagu en takup a mapissang ha ya dana en barawasi. ");
INSERT INTO agt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“A kumanen hapa ta mamadday kiden ta basi, te aweda haman ikarga ya bagu na basi ta dana na abyat, te am bumlad ya basi en a mabattak ya abyaten, otturu meburud hapa ya basi en. Mapmappya ta mekarga ya bagu na basi ta bagu na abyat petta azo mabayag kid,” kunna ha tekid. ");
INSERT INTO agt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","A tentu en para la naguhohug tekid a itta ya takday pinakadakal na Hudyo kiden nga umange namalentud ta atubang na en ta pagadang na tentu. “Ay Afu, bagu nasi ya anak ken nga balatang, ammi em haen isi-ged ya kamat mu tentu petta matolay,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","A imivwat hapa i Hesus petta dumagdag ta lalaki en, a sakā dumagdag hapa ya ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","A tekid para la nakatugtugut ta dalan a itta ya babbay nga sumalsal ta talekud ni Hesus, te enna si-gedan ya barawasi ni Hesusen gafu kan ta pakataktakit na, te nakadagdaga abat ta mafulu duwa na darun. ");
INSERT INTO agt_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Te ya itta ta nonot na a “Maski la am masi-ged ku ya barawasi na en a magmappya yak sangaw,” kunna kan na nonot na. ");
INSERT INTO agt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","A ta nepakkamu ni Hesus ta itta ya nangsi-ged ta barawasi na a nagbalittag hapa, a “Matalak ka la, Aboy, te ya pangikatalak mu teyak ya nagmappyam,” kunna. A ye-yen hapa na oras ya nepagmappya na. ");
INSERT INTO agt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","A ta datang nig Hesus ta bali na makāanaken a neddatangan da ya addu na tolay nga masitang ikid na magtatangit ikid na magmusiko, ammi nehuya na kid ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Imuhet kanan ta isin, te awena haman nasi na abbingen awa masidug la,” kunna tekid, ammi nekakatawa da hapa. ");
INSERT INTO agt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","A tekid na nakauhet a simarok i Hesus ta agyan na abbingen a inibbalan na ya kamat na en, a imivwat na. ");
INSERT INTO agt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A nepadamag da hapa ya iningwa ni Hesus addet ta ngamin paglelehut na lugarin yen. ");
INSERT INTO agt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","A ta nepagtugut nig Hesus ta iten a tinaliban da ya duwa na lalaki nga nagdaram, ammi dumagdag kid hapa nga nagayayag te Hesus. “O, Afu, Anak ni mina Dabid, Ikallak na kami O, Afu,” pakakin kid. ");
INSERT INTO agt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","A ta nesarok nig Hesus ta pagyanan na en bali a dumagdag hapa tentu ya daram kiden, a yen ya nepaguhohug ni Hesus tekid. “Ikatalak muy hud ta mabalin ku hala ya adangan muy teyak?” kunna hapa tekid, a “On, Afu,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","“A nabalin na mantu gafu ta pangurug muy,” kunna ha tekid, otturu sini-ged na hapa ya mata da kiden. ");
INSERT INTO agt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","A yen na hapa ya pakaita da. A pake nebar ni Hesus tekid ta aweda sangaw ibabar ya pagpamappya na tekid. ");
INSERT INTO agt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ammi tekiden nagtugut a enda haman nepadangag ya kalalaki ni Hesus addet ta ngamin paglelehut na lugarin yen. ");
INSERT INTO agt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","A ta nepagtugut na duwa kiden a itta hapa ya takday lalaki nga neange da te Hesus, te umal gafu ta anitu na. ");
INSERT INTO agt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","A pinatugut ni Hesus ya anitu na en, a nakasitang na ya lalaki en. A ya uhohug na tolay kiden ta pagpaka-lat da te Hesusen a “Pake nabayag kitam haman nga Istralita a awan para la ta naita tam ta kumanin awa ayanin la,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ammi ya uhohug na Pariseyu kiden a “Namaratu hud ya nagafun na pakapangwa na awa patugutan na ya anitu gafu ta itta tentu ya dafu na anitu kiden,” kunda hud la. ");
INSERT INTO agt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","A ta kabalin na kumanen a sinaned nig Hesus ya ngamin kiden ili ikid na babali ta lugar na Istralita kiden, petta mangituldu hapa ta umag na kapilya da. A nepadangag na hapa ya damag na pangikerutan na Namaratu tekid, otturu pinagmappya na hapa ya ngamin kiden takit da ikid na zigat na bari da. ");
INSERT INTO agt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","A tentu en nakaita ta pake addu ya tolay kiden nga umange nagdangag tentu a pake timalin ya allak na tekid, te kuman na kimongkong kid ikid na nakutukutet kid ta kuman na kalneru kiden nga awan ta mangtaron tekid. ");
INSERT INTO agt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A yen hapa ya nepangibar na ta ituldu na kiden ta “Kuga alawa ya paggatabanin yan, ammi assang la garay ya maggatab. ");
INSERT INTO agt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","A te awemuy haman ibar ta Makkamu en magpagatab, petta doban na kam hapa nga manguffun maggatab?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","A gafu ta kumanen a pinaabikan ni Hesus ya mafulu duwa kiden ituldu na nga kanayun dumagdag tentu, a pinasinapan na kid ta pakapangwa na, petta itta ya mabalin da nga magpatugut ta anitu na seanitu kiden, anna magpamappya ta magtatākit anna mazigatan ta bari da. ");
INSERT INTO agt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","A ya ngagan na mafulu duwa kiden a i Simon ya patudunan da, ammi Pedru ya agngilinan da tentu, a i Andres nga kabagis ni Simon, ikid ni Santiago nga anak ni Zibadeyu, ikid ni Hwan nga kabagis ni Santiago, ");
INSERT INTO agt_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ikid ni Felipe, ikid ni Bartolome, ikid ni Tomas ikid ni Matyu nga nagsingir ta bwis ta idi, a takdayen Santiago nga anak ni Alfeyo, ikid ni Tadyo, ");
INSERT INTO agt_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","a ya takdayen Simon nga kahulun na nakitapil ta gubyernu ta idi, ikid ni Hudas Iskaryote nga mangitalaba sangaw te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","A ya uhohug ni Hesus ta mafulu duwa kidin a “Awemuy sangaw ange ta agyan na Hentil kiden ikid na Samariyano kiden, ");
INSERT INTO agt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","te yen la sangaw eyan muy ya lugar na sakā Istralita muy kiden, te kimongkong kid na ta kuman na awan ta magtaron tekid. ");
INSERT INTO agt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","A maski am had ya pagdulotān muy a ipadangag muy ya pangikerutan na Namaratu tekid. ‘Ayanin ya araw na pangikerutan na Namaratu tekamuy,’ kummuy sangaw tekid. ");
INSERT INTO agt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“A pagmappyan muy hapa ya magtatākit, ikid na tolayan muy ya nagpasi, ikid na pagmappyan muy ya maggalis, a patugutan muy ya anitu na seanitu kiden. Te ya neatad ken tekamuy a awemuy haman pinagan, a yen hapa ya iatad muy, a awemuy papaga. ");
INSERT INTO agt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","A awemuy hapa magbalun ta pirak, ikid na tali na barawasi muy, ikid na tali na sapatos muy, ikid na kanan muy, te am itta ya masapul muy a gagangay ta ikallak na kam hapa sangaw na ikallak muy kiden. ");
INSERT INTO agt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“A maski am had sin sangaw na ili ikid na fugu ya eyan muy, a magita kam bit ta mappya na tolay, a yen sangaw ya pagdulotān muy. A magyan kam hapa tentu addet ta magtugut kam. ");
INSERT INTO agt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","A am gimon kam sangaw ta bali na en a ‘Namaratu ya makkamu tekamuy,’ kummuy sangaw ta makābali kiden. ");
INSERT INTO agt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","A am kakurugan ta mappya kid a mapadatang hala ya inuhohug muy tekid. Ammi am aweda megitta ta bendisyon muy tekid a awena mantu mapadatang. ");
INSERT INTO agt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A am awan pulus ta magpadulot tekamuy ikid na magdangag ta uhohug muy a pagtugutān muy kid mantu, a azin muy ya lafu na agyan da ta takki muy kiden. ");
INSERT INTO agt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A kustu hapa ya uhohugan ku ta pake mepallat sangaw ya pama-gang na Namaratu ta isina kid ammi ta tolay kiden nga taga Sodom ikid na Gomora nga awan nagbabawi ta idi. ");
INSERT INTO agt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","17","“A pake magpalan kam, te doban ta kanan nga ange mangipadangag ta agyan na mangikatupag sangaw tekamuy. A mappya mantu ta masippat kam, a pake imugudan muy ya tolay kiden ta eyan muy, te gafutan da kam sangaw petta idarum da kam. A paligatan da kam hapa sangaw maski ta umag na kapilya da. ");
INSERT INTO agt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","A idarum da kam hapa sangaw ta atubang na gubernador da kiden ikid na ari da kiden, te ikabkabat da kam sangaw ta pangikatupagan da teyak. Ammi uray hapa yen na Namaratu petta madangag da ya ipadangag muy tekid, kumanen hapa ta Hentil kiden nga awan para nakadangag. ");
INSERT INTO agt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","A sangaw am idarum da kam a awemuy la burungan ya uhohugan muy, te sangaw am ittan ya kustu na paguhohug muy a yen na sangaw ya datang na uhohugan muy, ");
INSERT INTO agt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","te bakkan sangaw ta ikamuy ya maguhohug, te ya Kahalwa na Namaratu sangaw ya makisagapil tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“A am itta sangaw ya mangurug ta ipadangag muy a sakā mazigatan hapa sangaw ya kadwan, te papapasi na kid hala na kabagis da. A mapapasi para sangaw ya kadwan kiden gafu ta dadagkal da. A mazigatan hapa sangaw ya kadwan gafu ta anak da kiden, a papapasi da kid hapa. ");
INSERT INTO agt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","A ikatupag na kam sangaw na tolay kiden ta ngamin kiden lugar gafu ta pangurug muy teyak. Ammi ya ngamin kiden maketurad abat ta pagaddetan na pagzigātān da a yen kid sangaw ya mekerutan. ");
INSERT INTO agt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","A am tapangan da kam ta takday lugar a umalit kam mantu ta takday na lugar, te pake ibar ku tekamuy ta awemuy sangaw mesaned ya ngamin kiden ili ta lugar na Istralita addet ta dumatang ya Tolayin nga taga Langit. ");
INSERT INTO agt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“A awemuy hapa pahig ta mapmappya kam ammi ta dafu muy, te am anu ya kwan da ta mistro muy ikid na dafu muy a kumanen hapa la sangaw ya kwan da tekamuy, ");
INSERT INTO agt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","te gagangay ta mekabat ya metuldu ta nangituldu en tentu, a mekabat hapa ya daddoban ta nangidoben en tentu. A am Satanas ya nangingaganan da teyak a pake dulay hapa sangaw ya pamadakat da tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ammi awemuy sangaw magtalaw tekid, te maski am anu ya pamadakat da tekamuy a mepasikkal hala sangaw ya katunung muy, te Namaratu sangaw ya mangpalattog ta ngamin melemad ikid na natappanan. ");
INSERT INTO agt_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","A ya ngamin ibar ku tekamuy ta paghahulun tam a yen sangaw ya uhohugan muy ta ngamin tolay. A ya ngamin nadangag muy teyak a yen hapa ya ipadangag muy ta ngamin. ");
INSERT INTO agt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","(a) “A awemuy sangaw magtalaw ta makapapasi ta bari muy, te aweda haman mapapasi ya kahalwa muy. ");
INSERT INTO agt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Intu mina pagnonotan muy ya malamamanuk kiden, te maski am malogon ya paga da ta dapun a awan ta makapapasi tekid, maski ta takday la, am awena ipalubus na Dama muyewan Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ammi tekamuy a dakdakal ya pangkenga na tekamuy ammi ta malamamanuk, te dana nabilang na ya ngamin kiden huk muy, a awan sangaw ta maazi maski ta tālabāg la am bakkan ta uray na. ");
INSERT INTO agt_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","A awemuy mantu la magtalaw ikid na magburung ta dumatang tekamuy, te pake mataktakit kam ta Namaratu ammi ta addu na malamamanuk. A mapmappya hud la ta burungan muy ya pagliwat muy tentu, (v 28b) te intu haman ya makapapasi ta bari muy pase kahalwa muy ta pangtaguhali na tekamuy. A yen mina ya italaw muy. ");
INSERT INTO agt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“A maski am inya sangaw ya mangibosag ta pangurug na teyak a yen hapa sangaw ya ibosag ku te Damakewan. ");
INSERT INTO agt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ammi ya mangilemad ta pangurug na teyak a ilemad ku hapa sangaw te Damakewan. ");
INSERT INTO agt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","A awemuy mina pahig ta iyak sangaw ya gafu na kaam-ammungan na tolay kiden, te iyak hala sangaw ya gafu na pagkakattwayan da. ");
INSERT INTO agt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Te ya awan mangurug a ikatupag na sangaw ya kahulun na en mangurug, te ikatupag na takday ya dama na en, a ikatupag na takday para ya hina na, a ya takday para a ikatupag na sangaw ya katahungan na en. ");
INSERT INTO agt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","A intu sangaw katapil da ya kahulun da kiden nga awan mangurug. ");
INSERT INTO agt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ammi am dakdakal ya pangidduk da ta dadagkal da kiden, ikid na ānāk da kiden ammi teyak a aweda mantu megitta teyak. ");
INSERT INTO agt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","A ya awanen makaattam ta zigat na pangdagdag na teyak maski abat ta pakapapasi na a awena mantu megitta teyak. ");
INSERT INTO agt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Te am kengan na mina ya angat na a mawakay hala. Ammi ya mangisagapil ta angat na gafu ta dumagdag teyak a yen sangaw ya matolay nga magnayun. ");
INSERT INTO agt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“A maski am inya sangaw ya magpadulot tekamuy a mekwenta ta iyak hapa ya pagdulotan na. A gafu ta pagdulotan nak a mekwenta ta pagdulotan na hapa i Damakewan nga nangidob teyak. ");
INSERT INTO agt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Te ya magpadulot ta dinob na Namaratu ewan gafu ta Namaratu ya nangidob tentu a pagsipatān na sangaw ya itandan na Namaratu ta dinob na en. A ya magpadulot ta matunung na tolay gafu ta katunung na en a sakā mesipat hapa sangaw ta itandan na Namaratu ta matunungen tolay. ");
INSERT INTO agt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A am itta sangaw ya mangatad maski ta masanaw na inuman ta kompormi na mangurug teyak gafu ta ikallak na ya mangurug a itta hala sangaw ya itandan na Namaratu tentu,” kunna. A yen ya addet na inuhohug ni Hesus ta nepangidob na ta turin na kiden. ");
INSERT INTO agt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","A ta nekabalin ni Hesus nangituldu ta mafulu duwa kiden ituldu na a dinob na kid ta eyan da, kapye na nagtugut hapa, te umange hapa tatakday nga mangituldu ikid na mangipadangag ta kadwan kiden ili. ");
INSERT INTO agt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","A ta kabalud para la ni Hwan a nadamag na hapa ya ngamin kiden tinarabaku ni Hesus, a yen ta dinob na hapa ya kadwan kiden ituldu na petta magpohut kid te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","A ya nebar da tentu a “Damagan mi kan am iko ya Mangikerutanen nga nekari na Namaratu ewan nga indagan mi? O itta para la ya takwan nga indagan mi?” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A ta pagtabbag ni Hesus tekid a intu netabbag na ya nesurat ni mina Isayas tentu en nanglavun ta iange na Mangikerutanen. A ya nebar na mantu tekid a “Magtoli kanan te Hwan a bidan muy tentu ya ngamin nadangag muy ikid na naita muy teyak, ");
INSERT INTO agt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","te makaita haman ya daram, a makatugut hapa ya pilay, a nagmappyan ya nagkangaw, a makadangag ya bangngag, a natolay ya nagpasi, a mepadangag hapa ya mappya na damag ta pobre kiden. A yen kid mina ya pakkamun na teyak. ");
INSERT INTO agt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","A ibar muy hapa tentu ta nagāsāt hapa ya awan magtabeng gafu teyak,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","A ta nepagtugut dan a naguhohug i Hesus ta tolay kiden nga kimalihung para la tentu magdangag, te binida na tekid ya kasasaad ni Hwanen nga nangidob ta nagpohut kiden tentu. “A tekamuyen umange nangita te Hwan ta kalafukanen ta idi a anu hud ya naita muy? Intu de naita muy ya awanen ta turad ta kuman na kulang na sikal nga malogon mapakkul ta paddad? Bakkan. ");
INSERT INTO agt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ono intu de naita muy ya malapat na tolay nga mapenam magbarawasi ta kuman na maba-nang? Bakkan haman, te itta haman ta bali na ari ya magbarawasi ta ispot ikid na mangina. ");
INSERT INTO agt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","A anu mantu ya pangitan muy tentu? Nalasin muy de ta intu ya takday aglavun nga paguhohugan na Namaratu ewan? A kakurugan ta aglavun na Namaratu, ammi pake ibar ku tekamuy ta pake malmalalaki para i Hwan ammi ta gagangayen aglavun, ");
INSERT INTO agt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","te intu hala ya nebar na Namaratu nga mapmapolu ammi teyak, te ya uhohug na ta suraten a ‘Itta sangaw ya doban ku nga mapmapolu ammi teko, a intu sangaw ya mangipadangag ta iangem,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","14","A am kurugan muy ta intu ya dinob na Namaratu tekamuy a amu muy mina ta intu hala ya kagitta ni mina Eliyasen nga linavun da ta iange na. A kakurugan hapa ya ibar ku tekamuy ta awan para la ta neanak nga megitta ta kalalaki ni Hwan. Ammi ya pake al-alinnaken ta ngamin kiden iturayan na Namaratu a pake malmalalaki para ammi tentu. “A ta palungu na araw addet na neange ni Hwan a nagattam hapa ya tolay kiden nga magindag ta araw na pagturay na Namaratu ta lutakin, te dana nepasikkal na ta lebru na lintigen ikid na surat na aglavun kiden. Ammi ta neange ni Hwanen nga mangipasikkal ta pagturayan na Namaratu a ittan hapa ya masikan makitapil addet ta ayanin, te ikayat da ugtulān ya turay na en. ");
INSERT INTO agt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","A am itta ya bangbang muy a mappya mantu ta pake dangagan muy ya inuhohug kin tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ammi ya pangigittan ku hapa ta magsoysoy kiden ta tarabaku na Namaratu a negitta kid haman ta kuman na anak kiden nga magalikkad ta sakā ānāk da kiden, te ya kuman na alikkad na ānāk kiden a ikayat da matubtubbat. Ammi gafu ta takwan ya nonot na kadwan a ");
INSERT INTO agt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Anu awemuy haman magtalip am maggasa kami?’ kun na kadwan. ‘A am masi kami pon awemuy haman magtangit,’ kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“A kumanen hapa ya nonot na kadwan kiden tolay ta ayanin, te matupag kid gafu ta aweda ikayat ya gagangay na sakā tolay da kiden, te intu nonotan muy i Hwan, te awena haman uminum ta binarayang, yaga ngilinan na hapa ya arawen nga aweda pangan, a ibar da haman ta maguyung. ");
INSERT INTO agt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ammi gafu ta uminum ya Tolayin taga Langit ikid na awena ngilinan ya arawen nga aweda pangan a ibar da haman ta mellaw ikid na madugal. A ibar da para ta iyak ya kahulun na magsingir kiden nga magdarogas ikid na dulay na tolay. Ammi maski padpadulayan da kami duwa a ya kappya na tarabaku mi ya mangipasikkal ta katunung na gagangay mi,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","A tentun nabalin nagbida ta tolay kiden a pinegafwanan na paliwatan ya tolay kiden ta kadwan kiden lugar, te maski am naita da ya kalalaki na pakapangwa na a aweda la nagbabawi ta gagangay da. ");
INSERT INTO agt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Mapa-gang kam sangaw, ikamuy Hudyo nga taga Korazin ikid na Betsayda, te maski am naita muy ya tarabaku na Namaratu a awemuy haman nagbabawi ta pagliwat muy. Ammi am naita mina na Hentil kiden nga taga Tiro ikid na Sidon ya kuman na naita muy a nagbarawasi kid na hapa ta kustal gafu ta pagbabawi da. ");
INSERT INTO agt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A yen ta pake kakallak kam sangaw ammi tekid ta araw na pangpa-gang na Namaratu tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“A ikamuy hapa nga taga Kapernayum, a pahig muy ta dayawan na kam na Namaratu, ammi mewarad kam sangaw ta pangtaguhali na tekamuy, te awemuy haman magbabawi. Te am naita mina na taga Sodom kiden ya kuman na naita muy a itta la mina ya ili da abat ta ayanin. ");
INSERT INTO agt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ammi kustu hala ya ibar ku tekamuy nga taga Kapernayum ta pake kakallak kam sangaw ammi ta tolay kiden taga Sodom ta araw na pangpa-gang na Namaratu tekamuy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","A tentu en nabalin naguhohug ta kumanen tekid a nakimallak hapa ta Namaratu. “Matalakak teko, Amang, te iko ya makākwa ta ngamin langitina ikid na lutakin. A mappya hapa te nelemad mu ya gagangay na pangikerutam ta malalaki kiden ikid na seadal, ammi yen ya inukadam ta kuman na abbing kiden, petta maawatan da. ");
INSERT INTO agt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","A mappya hapa ta kunna ten, Amang, petta magdulot ya ikayat men nga kappyanan,” kunna ta pakimallak na. ");
INSERT INTO agt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","A ya uhohug na ha ta tolay kiden a “Ya ngamin kiden amu ni Damakewan a nepakamu na hapa teyak. A awan hapa ta makkamu ta amukin am awa i Damakewan la, a awan hapa ta makkamu ta amu ni Damak am awa iyak la nga anak na, ikid na tolay kiden nga ikayat ku pangipakamun tentu. ");
INSERT INTO agt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","A e kanan mantu teyak, ikamuy ngamin nga mazigatan ikid na nadammatan, te atadan ta kam ta pakabannayan muy. ");
INSERT INTO agt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","A itun muy mina ya sangul kin ta bari muy, a petuldu kam teyak, petta maapagan muy ya pakabannayan na nonot muy, ");
INSERT INTO agt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","te masippatak hala, a awek magparayag. A awemuy sangaw mazigatan ta sangul kin, te malampaw hapa ya paagtu kin tekamuy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","A sangaw ta araw na agimmang a magtugtugut ig Hesus ikid na ituldu na kiden ta tātangngan na kamaitan. A gafu ta mabisin ya ituldu na kiden a nagpusit kid na ta mait a kinan dan. ");
INSERT INTO agt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ammi gafu ta naita na kid na Pariseyu kiden a nepehuya da kid hapa te Hesus. “Itam ya ituldum kidina, anu awem kid ihuya, te magtarabaku kid haman ta araw na agimmang,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A ya tabbag na hapa tekid a “Annun ku kid ihuya, te intu la kwan da ya kuman na iningwa ni mina Dabiden ikid na kahulun na kiden ta kawan na kanan da, ");
INSERT INTO agt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","te simarok kid ta bali na Namaratu, a inalap da ya pan kiden nga nedasar ta atubang na Namaratu nga mehangat mina tekid, te kanan hala na padi kiden. Ammi maski kunna ten a bakkan haman ta nakaliwatan da yen. ");
INSERT INTO agt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“A intu mina pagnonotan muy ya gagangay na padi kiden, te gagangay ta magtarabaku kid ta kada araw na agimmang, a maski am aweda kurugan ya lintigen nga mangihangat ta pagtarabaku na tolay ta araw na agimmang a awan ta liwat da, te intu pagtarabakun da ya bali na Namaratu ewan, a dakdakal mantu ya pangdayaw da ta bali na Namaratu ammi ta araw na agimmang. ");
INSERT INTO agt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ammi ya ibar ku tekamuy a dakdakal ya dayaw na itta in sin nga maguhohug tekamuy ammi ta bali na Namaratu, ");
INSERT INTO agt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","8","a intu mantu ya makkamu ta araw na agimmang. “A ya takday para a awemuy mina paliwatan ya awanen ta liwat am dana naawatan muy mina ya ikayat na uhohugan na Namaratu, te ya uhohug na ta takday surat a ‘Bakkan ta intu ikayat ku ya pangatang muy teyak, te mapmappya ta ikallak muy ya ikattolay muy kiden,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","A ta kabalinan na kumanen a nagtatugut ig Hesusen, te e kid na ta kapilya, a simarok kid. ");
INSERT INTO agt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A gafu ta itta hapa ten ya takday lalaki nga pake nagpilay ya takday kamat na, a ape pinohutan na Pariseyu kiden te Hesus am mepalubus ta magpamappya ta tolay ta araw na agimmang. Ammi pangayayyaw da la tentu talo am itta sangaw ya pangidaruman da tentu. ");
INSERT INTO agt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A ya tabbag na hapa tekid a “Anu hapa ya uray muy, te am angarigan ta itta ya kalding muy nga neavut ta araw na agimmang a awemuy hud iagon? ");
INSERT INTO agt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A awena hud mesasita na tolay ammi ta kalakalding? A mabalin mantu ta tarabakun tam ya mappya maski am araw na agimmang,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","A ya uhohug na hapa ta pilayen ta kamat a “Uyadam la ya kamat mina,” kunna. A tentu en nanguyad a negitta hapa ta takdayen kamat na nga mappya. ");
INSERT INTO agt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A gafu ta kumanen a imuhet na ya Pariseyu kiden ta kapilya en, a nagtatahatun da am had kunna mina na pangpapasi da te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","A narikna hapa ni Hesus ta dulay ya igakkad da tentu a nagtugut hapa. A tentu en nagtugut a addu hapa ya dumagdag tentu nga nagtatākit, a sa pinagmappya na kid ngamin, ");
INSERT INTO agt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ammi ya pake nebar na tekid a “Awedak sangaw bibidan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A uray hapa yen na Namaratu petta magdulot ya uhohug na en nga linavun ni mina Isayasen ta idi, te ya nebar na a ");
INSERT INTO agt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Itan muy ya daddoban ken nga nesaad ku, te intu ya pake iddukan ku ikid na ikayat ku. A intu hapa ya pasinapān ku ta Kahalwak, te ipadangag na ya lintig ku ta Hentil kiden nga awan makkamu teyak. ");
INSERT INTO agt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A awena sangaw makitapil ikid na masitang makidibati ta kaddun na tolay. ");
INSERT INTO agt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A am itta ya natakitan a awena dahangan, a am itta ya makafuy a awena uyoyungan. Te intu la ipaita na ya mappya addet ta pake metunglak ya lintig na Namaratu ta lutakin. ");
INSERT INTO agt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","A intu sangaw ya ikatalak na ngamin tolay,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","A ta takday ha na araw a itta ya neange da te Hesus nga nagdaram ikid na umal gafu ta anitu na, a pinagmappya ni Hesus petta makaita ikid na makasitang. ");
INSERT INTO agt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A ya tolay kiden nga naggihaw a pake nepagpaka-lat da ya iningwa ni Hesus. “Mabalin de ta intu ya nebar da en nga simsima ni mina Dabid nga itun na Namaratu ta pinakadama tam,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ammi nedangagan na Pariseyu kiden ya uhohugan da, a linibakan da i Hesus ta tolay kiden. “Namaratu hud ya pangalapan na tolayina ta pakapangwa na am awa Satanas, te itta tentu i Belzibub nga mayor na anitu kiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","26","Ammi dana naamu ni Hesus ta kunna ten ya nonot da a tinabbag na hapa ya nesaned da ta tolay kiden. “Had hud kun na nonot muy, te am Satanas mina ya nangatad ta pakapatugut ku ta sakā anitu na kiden a nakikattway na mantu ya dafu da en tekid, a naperdin mina ya patarabaku na en tekid. Te am makikattway mina ya tolay kiden nga makitapil ta gubyernu a awena hud sangaw maperdi na gubyernu da? A kumanen hapa am makikattway mina ya makipagyan kiden ta takday na bali, te maperdi hapa ya pagkakahulun da. A yen ya addet na tarabakun da. ");
INSERT INTO agt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“A am uray muy ta Satanas ya nangalapan ku ta pakapatugut ku ta anitu a had sin mantu ya nangalapan na ituldu my kiden ta pakapatugut da? Ikid mantu sangaw ya mangipasikkal ta pagkilluyan na nonot muy. ");
INSERT INTO agt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","29","Te awan haman ta makagubat ta ibbalan ni Satanas am bakkan la ta masmasikanen ammi tentu, te yen sangaw ya mangabak tentu petta gubatan na ya ibbalan na en. A bakkan mantu ta kuman na inuhohug muyen, te ya kakurugan a ya Kahalwa na Namaratu ya pangalapan ku ta pakapatugut ku ta anitu, a yen mina ya pakkamun muy ta ittan tekamuy ya nesaad na Namaratu nga magturay ta ngamin. ");
INSERT INTO agt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","A ya awan makikahulun teyak a mekwenta ta ikatupag nak, a ya awan makipaguknud teyak a mekwenta ta mangkutkutet. ");
INSERT INTO agt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“A gafu ta nepagsil muy ya dafu na anitu ta Kahalwa na Namaratu nga magyan teyak, itta mantu ya ibar ku tekamuy: Te maski am anu ya liwat na tolay ikid na pamadpadulay na ta ikattolay na kiden a mabalin ta mapakoma. Ammi ya mangipagsil ta dulay ta Kahalwa na Namaratu a awena pulus mapakoma. ");
INSERT INTO agt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","A maski am inya mantu ya mamadpadulay ta Tolayin taga Langit a mapakoma, ammi ya mamadpadulay ta Kahalwa na Namaratu a awena pulus mapakoma maski am kanu, te magnayun ya liwat na addet ta addet. ");
INSERT INTO agt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“A am gagangay mantu ta mappya ya mayan na kayu awemuy mina ibar ta dulay ya kayu en, a am madi ya mayan na a awemuy mina ibar ta mappya ya kayu en, te ya mayan na ya mangibar am anu ya kasasaad na fun na en. ");
INSERT INTO agt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Negitta kam haman ta kuman na ulag, a had kukummuy mantu maguhohug ta mappya am dulay ya nonot muy, te am anu ya magyan ta nonot na tolay a yen ya iuhohug na. ");
INSERT INTO agt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A am mappya ya tolay a uknudan na hapa ya mappya na nonot, a mappya hapa sangaw ya iuhet na ta sakā tolay na kiden. Ammi am dulay ya tolay a intu sangaw iuhet na ya dulayen nga nauknud na ta nonot na. ");
INSERT INTO agt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“A pake ibar ku tekamuy ta am ittan sangaw ya araw na pangpa-gang na Namaratu ta tolay kiden a ibalat na sangaw ya ngamin kiden inuhohug da nga awan ta kapkappyan. ");
INSERT INTO agt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Te am anu ya inuhohug da a yen ta pa-gangan na kid, ono sagappyan na tekid,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","A ta nekabalin na nagbida tekid a naguhohug hapa ya kadwan kiden Pariseyu nga mangituldu ta relisyon na Hudyo kiden. “Mistro,” kunda tentu, “mappya ta itta ya ipaitam ta pakapangwam petta pakaitan mi ta Namaratu ya nangidob teko,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A ya tabbag hapa ni Hesus tekid a “Kuga awan ta kapkappyan na tolay kidin nga awan mangurug gafu ta awan ta maita da. Pake adayu kanan para la ta Namaratu, a awan sangaw ta ipaitak tekamuy am bakkan la ta kuman na nepaita na Namaratu gafu te mina Honasen nga pinaglavun na ta nabayag na araw. ");
INSERT INTO agt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Te ya kuman na nekafukuk ni mina Honasen ta sirat na dakalen ikan ta las-ud na talluhaw ikid na tallu hiklaman a kumanen hapa sangaw ta Tolayen taga Langit, te mafukukak hapa sangaw ta umag na lutak addet ta talluhaw ikid na tallu hiklaman. ");
INSERT INTO agt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“A am ittan sangaw ya araw na pama-gang na Namaratu a ya taga Ninaba kiden nga kinasaba ni mina Honas ya mangpaliwat sangaw tekamuy, te nagbabawi kid haman gafu ta nepadangag ni mina Honas tekid. Ammi ya itta in sin nga mangipadangag tekamuy a malmalalaki haman ammi te mina Honas a awemuy haman kurugan am awan ta ipaita na tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","A ya takday para sangaw nga mangpaliwat tekamuy a intu hala ya babbayen ari ta lugar na Syiba, te nagafu ta pake adayu na lugar petta enna dangagan ya amu ni mina Ari en Solomun nga neatad na Namaratu tentu, ammi ya itta in sin tekamuy a malmalalaki haman ammi te mina Solomun a awemuy la kurugan. ");
INSERT INTO agt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ammi makkwa hala sangaw tekamuy ya kuman nakkwa ta takdayen tolay nga seanitu, te ya anitu na en a nagtugut bit, a immange nakakalkalay ta bagbagetay kiden nga magapag ta pagyanan na. Ammi gafu ta awan ta maapagan na a ");
INSERT INTO agt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Asakay, paruban ku la magtoli ta nagtugutan ken,’ kunna. A tentu en nakaita ta nagmappyan ya tolayen ikid na awan ta mangihangat tentu, ");
INSERT INTO agt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","a nagtugut ha ya anitu en, te immange bit nangalap ta pitu ta sakā anitu na kiden nga pake duldulay ammi tentu, a sa simarok kid na, petta magyan kid ta tolayen. A pake nagduldulay ya kasasaad na tolayen ta pagyan na pitu kiden anitu ammi ta ketta para la na takdayen. A kumanen hapa sangaw tekamuy ikid na kagitta muy kiden nagdupal,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","A tentu para la naguhohug ta tolay kiden a dumatang hapa ya hina na en ikid na kabagis na kiden, te ikayat da magbida tentu. A magindag kid ta bagaw na bali en, te itta ya umange nangbar tentu. ");
INSERT INTO agt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","“Itta kan ta bagaw ig hinam ikid na kabagis mu kiden, a ikayat da kan makibida teko,” kunna te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ammi ya uhohug ni Hesus tentu a “On ay, ammi inya hud ig hinak ikid na kabagis ku kiden am awa yen kid hapa,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A nesaned na netuldu ya kahulun na kiden ta umag na bali. “Ye yan kid hapa ig hinak ikid na kabagis ku, ");
INSERT INTO agt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","te maski am inya ya mangidulot ta ikayat ni Damakewan a yen kid ya kabagis ku ikid ni hinak,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A sangaw ta medyo furab a imuhet i Hesus ta bali en, a umange ta pingit na alugen kapye na nagtuttud petta mangituldu ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","A magananwan la a pake imaddu ya tolay kiden nga kumalihung tentu. A gafu ta pake imaddu kid na a gimon i Hesus ta selayag kapye na ha nagtuttud, a nagyan hapa ya tolay kiden ta pingit nga magdangag. ");
INSERT INTO agt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A addu hapa ya netuldu ni Hesus tekid ta keangarigan. “Itta ya umange nagpurwak,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“A nehunnak ya kadwan kiden hukal ta dalan, ammi enna kid inafut na mamanuk kiden. ");
INSERT INTO agt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A nehunnak hapa ya kadwan kiden ta kabatunen nga nebagbagtu ya lutak na, a alistu kid nagtatuhu gafu ta awan ta pake gimafutan na ramut da. ");
INSERT INTO agt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","A ta kasikan na bilagen a nagladdag kid, te awan ta nagramutan da, a nagkatang kid na. ");
INSERT INTO agt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A ya kadwan para hukal a nehunnak kid ta natungradanen gahut. A ta pagtuhu na hukal kiden a negindan hapa ya gahut kiden, a tinappanan na ya tuhu na hukal kiden, a yen ta awedan nakapagmayan. ");
INSERT INTO agt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A ya kadwan kiden hukal a nehunnak kid ta mappya na lutak, a yen kid ya pake dumakal ikid na nakapagmayan, te itta ya nagdawa ta magatut, a ya kadwan ta annamafulu ikid na tallufulu. ");
INSERT INTO agt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“A am kakurugan ta itta ya bangbang muy a mappya mantu ta pake dangagan muy ya nabidakin tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","A tentu nabalin nagbida a umabikan hapa ya ituldu na kiden tentu, a pinohutan da ya gafu na pagbida na ta keangarigan ta tolay kiden. A ya tabbag na tekid a ");
INSERT INTO agt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","“A on ay,” kunna, “te ikamuy la bit ya nekallak na Namaratu petta amu muy ya gagangay na pangikerutan na ta tolay kiden, ammi ta kadwan kiden a melemad la tekid. ");
INSERT INTO agt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Te am itta ya mangurug ta nadangag na en a madaggan hapa sangaw ya amu na petta addu. Ammi ya awanen mangurug a maazyanan hapa ya amu na en. ");
INSERT INTO agt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","A yen ta nagbida yak tekid ta keangarigan, te maski am itta ya mata da a aweda haman maita ya mepaita tekid, a maski am itta ya bangbang da a aweda pake madangag ya mepadangag tekid, a yen ta aweda maawatan ya mebida tekid. ");
INSERT INTO agt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A ikid mantu ya pagdulotān na uhohug na Namaratu nga linavun ni mina Isayasen, te ya uhohug na en gafu tekid a ‘Kanayun madangag muy ya mebar tekamuy, ammi awemuy haman maawatan ya madangag muy, a kanayun maita muy hapa ya mepaita tekamuy, ammi awemuy haman amu am anu ya maita muy. ");
INSERT INTO agt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","A on te kuman na nagbanad na ya nonot muy, a awemuy pake ukadan ya bangbang muy ikid na mata muy petta awemuy pake makadangag ikid na makaita. A yen ta awemuy maawatan, ikid na awemuy magbabawi petta pagmappyan ta kam mina,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ammi tekamuy nga petuldu teyak a nagāsāt kanan, te amu muy ya maita muy ikid na madangag muy. ");
INSERT INTO agt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A pake ibar ku tekamuy ta itta ya addu na aglavun ikid na mappya na tolay ta idi nga nagkaragāt makaita ikid na makadangag ta kuman na maita muy ikid na madangag muy ta ayanin ammi nelogot kid, te aweda nadatang ya araw na. ");
INSERT INTO agt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“A dangagan muy mantu ya pagbalinan na keangarigan na magpurwak. ");
INSERT INTO agt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Te ya hukal kiden nga nehunnak ta dalan a yen ya keangarigan na makadangag ta uhohug na pangikerutan na Namaratu, ammi gafu ta awena itug ya madangag na a ange i Satanas tentu a tabtabangan na ya nadangag na en petta kaliwatan na. ");
INSERT INTO agt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“A ya hukal kiden nga nehunnak ta kabatunen a yen ya keangarigan na makadangag ta uhohug na Namaratu a ialistu na hapa ikatalak, ");
INSERT INTO agt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ammi gafu ta awena pake itug ya madangag na en a awena la mabayag na pangikatalak na, te am itta sangaw ya pagzigātān na ono mangikatupag tentu gafu ta uhohugen nga nekatalak na a alistu hapa magtabeng, te kuman na ikazigman na ya nekatalak na en. ");
INSERT INTO agt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“A ya hukal kiden nga nehunnak ta dana natungradanen gahut a yen hapa ya keangarigan na makadangag ta uhohug, ammi gafu ta addu hapa ya burungan da ta magmagannud, ikid na pakolangan da ya pagba-nang da a yen kid na nonot ya mangiduyat ta uhohugen, a awan na ta pagbalinan na uhohugen petta magserbi ta kappyanan da. ");
INSERT INTO agt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“A ya hukal kiden nga nehunnak ta mappya na lutak a yen ya keangarigan na makadangag ta uhohug na Namaratu, a itug na hapa ya madangag na, a yen mantu ya kuman na ammay nga makapagmayan ta pake addu, a ta kadwan a makapagmayan kid ta kustu, a ta kadwan medyo makurang la,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","A ya takday para na keangarigan nga binida na tekid a intu yan: “Ya gagangay na pangikerutan na Namaratu a meangarig hapa ta uma nga namulan ta mappya na ammay. ");
INSERT INTO agt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ammi ta pakasidug na makāuma en ta hiklam a umange ya katapil na en, a minulan na ha ya uma na en ta gahut ta lemad, kapye na nagbilag. ");
INSERT INTO agt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","A naggagindan mantu nagtatuhu ya ammayen ikid na gahuten, ammi ta pagdawa na ammayen a mapilin hapa ya gahuten, ");
INSERT INTO agt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","a enna hapa nedanug na tagabu na makāuma en, ‘O Afu, anu napannun ya umamen ta gahut? A te mapmappya hamanen ta nepagmulamen ta ammay?’ kunda kan tentu. ");
INSERT INTO agt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Kuga uyoyungan nak mantu na katapil ken,’ kunna kan hapa na makāuma en. ‘A ikayat mu de ta emmi hantudan ya gahut kiden?’ kunna kan tentu. ");
INSERT INTO agt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Awemuy la, te mesipat hapa mahantud ya ammay. ");
INSERT INTO agt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","A azo padakalan muy ya ammay ikid na gahut. Mappya yen ta makapaghuku bit ya gahuten a malogon na mapili, te ibar ku sangaw ta maggagatab kiden ta pilin da ya gahut apolu kapye da sangaw gataban ya ammay, te babbadan da hapa ya gahut kiden petta iwarad da ta afuy, a sangaw alapan da hapa ya ammay ta gitad ken,’ kunna kan na makāuma en.” ");
INSERT INTO agt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","A ya takday ha na keangarigan nga binida ni Hesus a intu yan: “A ya keangarigan na tolay kiden nga iturayan na Namaratu a kuman kid na kaassangan na hukal nga nemula ta lutak, ");
INSERT INTO agt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","te sangaw am dakal na a nagbalin ta kadakalan na ngamin kiden mula, te magge kuman na kayu, petta yen ya eyan na mamanuk kiden pagumukan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","“A meangarig hapa ya tolay kiden na Namaratu ta kuman na tāpirit na asin nga mekihu ta lappa, a yen ta sa maasinan ya ngamin lappa,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","A ya gagangay mantu ni Hesus tentu en mangituldu ta addu na tolay a intu la binida na ya keangarigan, te awan ta netuldu na tekid am awa keangarigan la. ");
INSERT INTO agt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A kunna ten ya gagangay na, te yen haman ya dana linavun na aglavunen gafu tentu. “Magbida yak sangaw ta keangarigan, te bidan ku sangaw ya nelemad na Namaratu addet ta nekapadday na paglelehutin,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","A tentu en nabalin nangituldu ta tolay kiden a nagtugutan na kid, a umange ta bali, a dumadagdag hapa ya ituldu na kiden. A ya uhohug da hapa tentu ta bali en a “Ipalawag mu haen, Afu, ya keangarigan na gahut kiden nga nemula ta uma en,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","“A ya nagmula en ta mappya na ammay,” kunna, “a intu hala ya Tolayin taga Langit. ");
INSERT INTO agt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A ya uma en nga namulan ta ammayen a yen ya keangarigan na ngamin paglelehutin, a ya ammay kiden ya tolay kiden na Namaratu, a ya gahut kiden ya tolay ni Satanas, ");
INSERT INTO agt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","te Satanas haman ya nangimula tekid. A ya araw na gatab a yen ya pagaddetan na arawin yan, a ya anghel kiden sangaw ya kuman na maggagatab kiden. ");
INSERT INTO agt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","A ya pangbadbad da en hapa ta gahut kiden petta mewarad kid ta afuy, a kumanen hapa sangaw ya makkwa ta tolay kiden ta pagaddetan na arawin yan, ");
INSERT INTO agt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","te doban ku sangaw ya anghel ku kiden, a hantudan da sangaw ya ngamin kiden mazigman ikid na mangwa ta dulay ta lugar na tolay ku kiden, ");
INSERT INTO agt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","a iabbang da kid sangaw ta lugar na pangiapangan, a yen sangaw ya pagzigātān da. ");
INSERT INTO agt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A am sa maazi sangaw ya ngamin dulay a pake magdakar sangaw ya kalalaki na mappya kiden tolay nga mesipat ta lugar na Dama da ewan Namaratu. “A am kakurugan ta itta ya bangbang muy a mappya mantu ta pake dangagan muy ya nabidakin tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","A ya kadwan kiden keangarigan nga netuldu ni Hesus a intu yan: “Ya gagangay na pangikerutan na Namaratu a meangarig hapa ta addu na balituk nga nabayag nekali ta bangkag. Ammi itta hapa ya umange nagaradu ta bangkagen a nearadun hapa ya balituken. A gafu ta talak na ta gāsāt na en a tinappanan na ha bit ya balituken, te umange bit maglaku ta ngamin kiden kwa na petta itta sangaw ya igatang na ta bangkagen, petta kwa nan hapa ya balituken. ");
INSERT INTO agt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“A ya takday ha na pangiangarigan ku ta pangikerutan na Namaratu a kuman na takday tolay nga maguknud ta magindumohuma na batu nga ispot. ");
INSERT INTO agt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","A tentu en nakaita ta takday na batu nga pake mangina a enna hapa nelaku ya ngamin kiden kwa na petta itta ya igatang na ta batu en. ");
INSERT INTO agt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“A ya takday para na pangiangarigan ku ta pangikerutan na Namaratu a kuman na sigay nga nehuklad da ta danum, a nakaalap kid hapa ta pake addu na magdaduma na ikan. ");
INSERT INTO agt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","A gafu ta pake napannu ya sigay da en a enda ginerger ta pingit, kapye da nagtuttud nagpili ta ikan kiden, te ya ikan kiden nga mappya a inuknud da, ammi newarad da hala ya madi. ");
INSERT INTO agt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","A kumanen hapa sangaw ya makkwa ta tolay kiden ta pagaddetan na arawin yan, te ange sangaw ya anghel kiden a igungay da sangaw ya dulay kiden tolay ta mappya kiden, ");
INSERT INTO agt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","a iwarad da kid sangaw ta pangiapangan, a yen sangaw ya pagzigātān da,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","A sangaw pinohutan ni Hesus ta ituldu na kiden am naawatan da ya ngamin binida na tekid, a “On,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Am itta mantu ya makkamu ta lintig na Namaratu otturu metuldu hapa ta gagangay na pangikerutan na Namaratu a imaddun mantu ya amu na petta itta ya ituldu na nga dan ikid na bagu.” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","A tentu en nabalin nangituldu ta keangarigan kiden a nagtugut ha, te ange ta lugar na en hapa la. ");
INSERT INTO agt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","A tentu en dumatang ta ili na en a umange hapa nangituldu ta kapilya. A pake nepagpaka-lat da hapa, te kalugarān da haman a papa-nun na makkamu mangituldu, a yen ta nagimpopohut kid na ta pagpaka-lat da tentu. “Inya hud ya nangalapan na ta kumanin na bida?,” kun na takday. “A anu hud ya ikayat na uhohugan?” kunna hapa na takday. “A anu kawagan na ta itta ya pakapangwa na?” kunna para na takday. ");
INSERT INTO agt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","57","A gafu ta kalugarān da ikid na kagitta da en napanglaw a aweda kinurug, a nedadula da. “Bakkan hud ta anak na kalapintero ikid ni Mariya en nga kagitta tam napanglaw? Yaga kagitta tam hapa ya kabagis na kiden Santiago ikid ni Hose, ikid ni Simon, ikid ni Hudas, ikid na wāgi na kiden nga babay nga magyan sin. A inya mantu ya nangalapan na ta ituldu na ikid na pakapangwa na?” kunda. Ammi ya uhohug ni Hesus tekid a “Kakurugan ta madayawan ya aglavun na Namaratu ta ngamin kiden lugar, ammi fwera la ta lugar na en hapa la ikid na bali na,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A gafu ta aweda kinurug a assang la ya nepaita na ta pakapangwa na ta agyan da. ");
INSERT INTO agt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A gafu ta ngamin kiden tinarabaku ni Hesus a simaned hapa ya damag na addet ta addu na lugar. A ta nepakadamag ni Gubernador Herud ta ngamin tinarabaku na a pahig na ta intu hala i Hwanen nga pinapasi na ta idi otturu natolay hala. ");
INSERT INTO agt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“Intu malat i Hwanen nga nangzigut ta tolay kiden, a yen ta itta ya pakapangwa na, te natolay hala ta pasi na en,” kunna kan ta magyan kiden tentu. ");
INSERT INTO agt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","A ya gafu na nepangpapasi ni Heruden te Hwan ta idi a nangadallaw i Heruden, te inatawa na ya ipag na en nga atawa na kabagis na en Felipe. A yen ta natotoli hapa i Hwan te Heruden petta ihuya na ya tinarabaku na en. “Nakaliwat kan ta Namaratu te ginubatam haman ya atawa na kabagis men,” kunna te Herud. A gafu ta pangihuya ni Hwan tentu a ikayat ni Herud ta papasin na mina, ammi nagtalaw hapa ta tolay kiden, te nekwenta da i Hwan ta mappya na tolay nga dinob na Namaratu. Ammi te Herodias hapa, (intu hala ya ipag ni Herud nga inatawa na,) a pake nekatupag na hapa i Hwan gafu ta pangihuya na tekid, a yen ta nepagafut ni Herud nepabalud petta matappag hapa ya atawa na en Herodias. ");
INSERT INTO agt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","A ta nekabalud para la ni Hwan a magayayat ig Herud ta araw na nekeanak na en ta idi, a umange hapa ya anak ni Herodias nga balatang, a nangayaw hapa ta atubang na sangaili kiden. ");
INSERT INTO agt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","A gafu ta pake natalakan i Herud ta pangayaw na balatangen a “Pagasingan ta Dyos, Aboy, am awek iatad teko ya kompormi na adangam teyak,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A gafu ta pangsanat na hina na en tentu a “Iatad mu mantu teyak ya ulu ni Hwan, te pedatang mu sin nga melātuk,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","A nadamdam hapa i Herud ta inadang na en, ammi gafu ta nekari na en tentu ikid na amat na hapa ta sangaili na kiden a dinob na ya ange mangputul te Hwan ta pagbaludanen, a nebilin na ta meatad ya ulu na ta balatangen. ");
INSERT INTO agt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A magananwan la a itta ya nangidatang ta ulu na en nga nelātuk da, a negawat da ta balatangen, otturu negawat na hapa te hina na en. ");
INSERT INTO agt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","A ya ituldu kiden ni Hwan a enda hapa inalap ya bari na, a netanam da kapye da nedanug te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","A ta nepakadangag ni Hesus ta pasi ni Hwan a naglugan kid ha na ituldu na kiden ta selayag da en petta umadayu kid ta lugar ni Herud, a umange kid ta awan ta totolay ta dammang na alugen. Ammi kadulayan na te nadamag na kadwan kiden tolay ya eyan da a inakkawan da kid, te inange da ya pingit na alugen. ");
INSERT INTO agt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","A ta datang nig Hesus ta datangan da en a itta hala ten ya tolay kiden nga nagapag tentu. A ta nepakaita na ta kaddu da a timalin hapa ya allak na tekid, a pinagmappya na hapa ya nagtatākit tekid. ");
INSERT INTO agt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","A tentu en marimat a nagburung na ya ituldu na kiden gafu ta tolay kiden, a enda nebar te Hesus. “Mappya, Afu, ta patugutam ya tolay kidin, petta e kid gumatang ta pamuhab da ta babali kidewan, te furab na a awan haman ta pangalapan ta isin,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","“Maski aweda mina magtugut, te ikamuy mina ya mangatad ta kanan da,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“A on ay, ammi intu la itta sin ya lima na pan ikid na dwahukal na dalag,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“A alapan muy kid mantu sin,” kunna ha, ");
INSERT INTO agt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","otturu pinagtuttud na ya tolay kiden ta kakaddatanen. A tentu en nanggawat ta lima kiden pan ikid na duwa kiden ikan a tumangad hapa ta langit petta pakimallak na ya kanan da. A sangaw ginadgadwa na ya pan kiden ikid na ikan kiden, kapye na kid negawat ta ituldu na kiden petta ikid ya mangisaned ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","A sa nagkakan kid abat ta nabattug kid. A tekid na nabalin nagkakan a pinannu da ya mafulu duwa na la-ba ta huna na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A ya kaddu na nagkakan kiden a limaribu kid na lālāki fwera ta bābāy ikid na ānāk. ");
INSERT INTO agt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","A sangaw pinaglugan ni Hesus ya ituldu na kiden ta selayag da en, petta mapolu kid ta dammang, te mapozan la bit petta patugutan na hapa ya tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","A tentun nakapatugut tekid a gimon hapa tatakday ta bagetay, te ange makimallak. A nagyan la ten tatakday nakimallak abat ta hiklam. ");
INSERT INTO agt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ammi ya ituldu na kiden a nakatangngan kid na ta alugen, a sisikbatan na kid na palung, te atubangan na kid hapa na paddad. ");
INSERT INTO agt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","A tentu en nagkarawan a umange i Hesus tekid nga nagpapa-yat ta danumen. ");
INSERT INTO agt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","A ta pakaita da tentu nga magpapa-yat ta danum a nagtalaw kid na, te pahig da ta datay, a kumahkahaw kid na. ");
INSERT INTO agt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ammi alistu hapa i Hesus nagayag tekid, “Awemuy la magtalaw te iyakin yan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","“A am kakurugan ta iko, Afu, a ayagan nak hapa sina, te magpa-yatak hapa ta danum,” kunna hapa ni Pedru. ");
INSERT INTO agt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“On, e ka mantu sin,” kunna ha ni Hesus tentu. A dumagut mantu i Pedru ta selayagen, a nagpapa-yat hapa ta danum kumin te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ammi gafu ta nagliplipay hapa ta kasikan na paddad a kima-ma la nagtalaw a namegafu lumammad, a nagayag na, “Ikerutan nak O, Afu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","A alistu tina-mak ni Hesus ta kamat na en. “Kuga assang la ya pangikatalak mu. Anu haman ta pinagduwaduwam ya nonot mu,” kunna hapa tentu. ");
INSERT INTO agt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","A tentu nangitoli ta selayagen a nagimmang hapa ya paddad. ");
INSERT INTO agt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A ya kadwan kiden hapa ta selayagen a pake dinayawan da i Hesus. “Kakurugan kad, Afu, ta iko ya Anak na Namaratu ewan,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","A ta nepakadakit dan a itta kid na ta lugar na Genesaret, ");
INSERT INTO agt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","a nalasin na kid hapa na tolay kiden, a nagbabilag kid ta babali kiden, te enda inalap ya ngamin kiden nagtatākit, a nedatang da kid te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","A nakimemallak kid ta si-gedan da la ya kayadan na barawasi na en, a nagmappya hapa ya ngamin kiden nakasi-ged tentu. ");
INSERT INTO agt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","A ta takday ha na araw a umange te Hesus ya kadwan kiden Pariseyu nga taga Herusalem, ikid na mangituldu ta relisyon na Hudyo kiden, a imbestigaran da i Hesus gafu ta ituldu na kiden. A ya nebar da tentu a ");
INSERT INTO agt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Anu awena haman dumagdag na ituldum kiden ta netuldu na dadagkal tam kiden, te am kada mangan kid a aweda bit magbaggaw ta kamat da?” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","“A itta hapa ya pohutan ku tekamuy,” kunna, “te anu kawagan na ta soysoyan muy ya lintig na Namaratu petta itali muy ya ituldu muy? ");
INSERT INTO agt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Te ya nebar na Namaratu tekitam a “‘Nonotan muy ig dama muy ikid na hina muy,’ kunna. ‘A mappya ta mapapasi hapa ya maguhohug ta dulay tekid,’ kunna ha. ");
INSERT INTO agt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ammi tekamuy a ugtulān muy haman ya uhohug na en, te ya ituldu muy ta tolay kiden a ‘Dana mangatad kam bit ta simbaan na Namaratu, a am awan na sangaw ta iuffun muy ta dadagkal muy a ibar muy tekid ta dana neatad muy na ta Namaratu,’ kummuy haman. ");
INSERT INTO agt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","A gafu ta kumanen a awemuy ipalubus ta kurugan da ya nebar na Namaratu gafu ta dadagkal da kiden. A liblibangan muy mantu ya uhohug na Namaratu petta idulot da ya ituldu muy. ");
INSERT INTO agt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ammi kuga magimmamappya kam, a kustu hapa ya nepeuhohug na Namaratu ta aglavunen Isayas gafu tekamuy, te ");
INSERT INTO agt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Dayawan nak na tolay kidin ta simuk da, ammi adayu garay ya nonot da teyak. ");
INSERT INTO agt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Awan mantu ta kapkappyan na pangdayaw da teyak, te igitta da haman ya ituldu da ta itulduk,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","A ta nepaguhohug ni Hesus ta isin a pake pinaabikan na hapa ya kadwan kiden tolay tentu petta madangag da hapa ya ibar na. “Pake dangagan muy ya uhohug ku tekamuy petta maawatan muy: ");
INSERT INTO agt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bakkan ta intu ikazigman na Namaratu ya awan magbaggaw kapye na mangan, baka ikazigman na hud ya itun muy ta simuk muy awa intu hud la ikazigman na ya dulay nga nagafu ta simuk muy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","A ta magananwan la a itta hapa ya ibar na ituldu na kiden tentu. “Awem de amu, Afu, ta pake ikatupag na ka na Pariseyu kiden gafu ta inuhohug mu tekid?” kunda. ");
INSERT INTO agt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","“Bay-an muy la yana kid, te ya awan kiden nemula ni Damakewan a mappya ta mahantud kid, te daram kid haman. A am daram ya mangituldu ta kagitta na en daram a azo meavut kid duwa,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","A ya uhohug hapa ni Pedru a “Mappya, Afu, ta pake ipasikkal mu ya ikayat mu uhohugan ta ikazigman na Namaratu, te awemi maawatan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","“Anu awemuy hapa metug ya inuhohug ken? ");
INSERT INTO agt_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","A awemuy hud manonot ta maski am itta ya duping nga mehulun ta kanan na tolay a ange hala ta sirat na kapye na sangaw mewarad. ");
INSERT INTO agt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ammi ya imuhet ta simuk na tolay a magafu hala ta nonot na, a yen ya mangatad ta pagzigmanan na. ");
INSERT INTO agt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Te ya magafu ta nonot na tolay a dulay na nonot, ikid na pangpapasi na ta ikattolay na kiden, ikid na pangadallaw na, ikid na pagtakaw na, ikid na pagladdud na, ikid na pamadpadulay na. ");
INSERT INTO agt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yen kid ya mangatad ta pagzigmanan na tolay, ammi ta awemen pagbaggaw a awan bale,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","A ta nekabalin na kumanen a nagtatugut ha ig Hesus ta nagyanan da en, te ange kid ta tagad ta lugar na Tiro ikid na Sidon. ");
INSERT INTO agt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","A tekid para la nagyan ten a umange hapa ya takday babbay nga Hentil taga Kanaan, a binaran na i Hesus, “Anak ni Dabid,” kunna, “Ikallak nak O, Afu, te pake mazigatan ya anak ken nga babbay gafu ta anitu na,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ammi awena pulus nagsitang ni Hesusen. A gafu ta pakolangan na la na babbayen a mahulat na ya ituldu na kiden. “Pagustum mina, Afu, petta magtugut, te kuga masitang ya babbayin nga dumagdag tekitam,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ammi ya tabbag hapa ni Hesus tekid a “Awek haman nedob ta isina kid na tolay, te yen la ya umeyan ku sin petta makaapagak ta Istralita kiden nga netawag ta Dyos da,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ammi umabikan hapa ya babbayen, a namalentud ta atubang ni Hesus, a “Uffunan nak kad, Afu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","“On ay, ammi dulay am meatad ta atu ya kanan na anak kidin,” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Kakurugan, Afu, ya uhohug mina, ammi awena hud mangan na atu kiden ta hugta na dafu na en nga nahunnak ta lutak?” kunna hapa na babbayen. ");
INSERT INTO agt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","A gafu ta uhohug na babbayen a “Kakurugan ta masikan ya pangikatalak mu, Aboy, magdulot hala ya kuman na inadang mu teyak,” kun ni Hesus tentu. A ye-yen hala na oras ya nepagmappya na anak na en. ");
INSERT INTO agt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","A ta nekabalin nig Hesusen ta iten a nagtatugut kid ha, a inange da ya pingit na Alug na Galileya, kapye da gimon ta bagetay, a nagtuttud i Hesus petta magibannag. ");
INSERT INTO agt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","A tentu para la nagtuttud a dumatang ya pake addu na tolay nga mangikahad ta pilay, ikid na pukul, ikid na daram, ikid na umal, ikid na addu para. A ta nepangitabnak da tekid ta atubang ni Hesus a sa pinagmappya na kid hapa. ");
INSERT INTO agt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A ta nepakaita na tolay kiden ta sa nagmappyan ya ngamin kiden neange da tentu a pake dinayawan da hapa ya Dyos na Istralita kiden. ");
INSERT INTO agt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","A ta nekabalin ni Hesus nagpamappya ta neange da kiden tentu a pinaabikan na ya ituldu na kiden petta madangag da ha ya bida na tekid. “Kuga timalin ya allak ku ta tolay kidin, te tallu araw kid na teyak, a naafut na ya balun da. A am padatangan ku kid mina ta bali da a magkafuy kid ta dalan gafu ta bisin da,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","“A onay, ammi bababang kid, Afu, a had ya pangalapan tam ta isin na lugar ta ipakan tam tekid, te adayu haman yan ta babali,” kunda hapa tentu. ");
INSERT INTO agt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“A awan hud ta huna muy nga pan?” kunna ha tekid. “A itta ay, ammi pitpitu hukal la, ikid na assang kid la na daldalag,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","A gafu ta kumanen a pinagtuttud na ya tolay kiden ta lutak, ");
INSERT INTO agt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","a ginawat na hapa ya pan kiden kontodu daldalag kiden, kapye na kid nepakimallak. A sangaw ginadgadwa na kid hapa, kapye na kid negawat ta ituldu na kiden, petta isaned da kid hapa ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","A sa nagkakan kid abat ta nabattug kid, a sangaw inuknud da hapa ya pitu na la-ba ta nehuna na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A ya kaddu na nagkakan kiden a appataribu kid na lālāki fwera ta bābāy ikid na ānāk. ");
INSERT INTO agt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","A sangaw pinatugut ni Hesus ya tolay kiden, kapye na naglugan hapa ta selayag kontodu ituldu na kiden, te ange kid na ta lugar na Magadan. ");
INSERT INTO agt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A ta ketta para la nig Hesus ta lugar na Magadan a umange ha tentu ya kadwan kiden Pariseyu ikid na Saduseyu, petta paruban da. “Mistro,” kunda, “mappya ta itta ya ipaitam ta pakapangwam petta pakaitan mi ta Namaratu ya nangidob teko,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","A ya tabbag na en hapa tekid a “Gafu ta itta ya pakaitan ta langit a amu muy am magbilag ta lakwat ono am magudan. A anu kawagan na mantu ta awemuy malasin ya pakapangwa na Namaratu am itta ya pakaitan na? ");
INSERT INTO agt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kuga awan ta kapkappyan na awan mangurug gafu ta awan ta mepaita tentu. Ammi awan sangaw ta mepaita tekamuy, te intu mina pagnonotan muy ya nakkwa ta aglavunen mina Honas,” kunna tekid, a nagtugutan na kid. A naghahulun ha ig Hesus ikid na ituldu na kiden nga ange ta dammang na alugen. ");
INSERT INTO agt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","A ta pakadatang da ta dammang a awan ta kanan da ta tangngan na araw, te naliwatan na ituldu na kiden ya nagbalun ta pan. ");
INSERT INTO agt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","A ya uhohug ni Hesus tekid a “Mappya ta palanan muy ya beking na Pariseyu kiden ikid na Saduseyu kiden, te dulay,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","A nagbabidan da am anu ya ikayat na uhohugan, te pahig na kadwan ta tabarangan na kid gafu ta naliwatan da ya magbalun ta pan. ");
INSERT INTO agt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","10","Ammi ta nepakarikna ni Hesus ta bida da a “Anu kuga pagbabidan muy ya kawan na kanan tam? Kuman na awemuy maawatan ya inuhohug ken, yaga assang la ya pangikatalak muy, te naliwatan muy de ya lima kiden pan nga nakabattugan na limaribu kiden, ikid na pitu kiden pan nga nakabattugan na appataribu kiden? A naliwatan muy hapa de am piga na la-ba ya nauknud muy ta nekabalin na limaribu kiden ikid na appataribu kiden? ");
INSERT INTO agt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Anu awemuy haman maawatan ya inuhohug ken nga ‘Palanan muy mina ya beking na Pariseyu kiden ikid na Saduseyu kiden?’ Pake nonotan muy, te bakkan ta intu bidan ku ya kanan tam,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","A gafu ta inuhohug na en a yen ya nepakanonot da ta intu papalan na tekid ya ituldu na Pariseyu kiden ikid na Saduseyu kiden, te bakkan ta kanan ya ikayat na uhohugan. ");
INSERT INTO agt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","A tekiden umabikan ta ili na Sesariya Pilipo a itta ya pinohutan ni Hesus ta ituldu na kiden; “Anu kan ya pangitan na tolay kiden teyak am inya yak?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“A pahig na kadwan ta iko i mina Hwanen nga nangzigut ta tolay kiden ta idi, te ibar da ta natolay hala. Ammi ta kadwan a pahig da ta iko ya aglavunen Eliyas nga magtoli kan ta lutakin. A ta kadwan para a pahig da ta iko ya aglavunen mina Heremyas,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“A ikamuy ay, anu hapa ya pangitan muy teyak?” kunna ha tekid. ");
INSERT INTO agt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","A i Simon Pedru ya alistu tumabbag; “A iko ya Mangikerutanen nga netun na Namaratu ta pinakadama mi, te Anak ka na sigatolay na Dyos,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Pake nagāsāt kan, Simon, te awem mina amu am inya yak am awa netuldu na ka ni Damakewan. ");
INSERT INTO agt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A gafu ta Pedru hapa ya ngagam a iko ya kuman na pundasyon na batu, te iko ya pamepegafwanan ku ta tolay ku kiden nga pagyanan ku ta lutakin, a awan sangaw ta makaperdi ta pagyanan ku maski ta pasi. ");
INSERT INTO agt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","A iko hapa ya itunglak ku ta makkamu ta pangikerutan na Namaratu ta lutakin, petta intu sangaw ihangat mu ta lutakin ya dana nehangat na Namaratu, a intu sangaw ipalubus mu ta lutakin ya dana nepalubus na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","A sangaw pake nebar ni Hesus ta aweda mina bibidan ta intu ya pinakadama da nga nekari na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A ta nekabalin na en a namegafun hapa i Hesus nga mangipadangag ta pasi na tekid. “Mappya ta e yak sangaw ta ili na Herusalem, petta pakākāllakan nak sangaw na pinakadakal na Hudyo kiden kapye dak sangaw papapasi, ammi matolayak hala sangaw am nagpasan ya talluhaw,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ammi ta nepaguhohug ni Hesus ta isin a sang neadayu ni Pedru, kapye na nehuya; “Awem mina ibar ta mapapasi ka, Afu, te Namaratu ya makkamu teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","A nagbalittag hapa i Hesus nga nangatubang te Pedru, a “Umadayu kan teyak, te itta ya Satanas teko, te sanatan nak nga magliwat, te bakkan ta uray na Namaratu ya ibar mu teyak awa uray hud la na tolay,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","A tentu en ha naguhohug ta ituldu na kiden a kumanin ya nebar na tekid: “Am itta ya mayat dumagdag teyak a mappya ta pagtalekudan na ya bari na, a attaman na ya zigat na pangurug na teyak, petta makadagdag teyak. ");
INSERT INTO agt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Te maski am inya ya mangkenga ta angat na a masi hala sangaw ta magnayun. Ammi ya mangisagapil ta angat na gafu ta pangurug na teyak a matolay hala sangaw nga magnayun. ");
INSERT INTO agt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Te maski am itta mina ya nakaalap ta ngamin kiden magmagannud ta paglelehutin a itta hud sangaw ya kappyanan na tentu am nawakay ya kahalwa na ta pasi na? A itta hud sangaw ya pangsaka na ta kahalwa na petta matolay mina? ");
INSERT INTO agt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","A yen mina ya nonotan muy, te gagangay ta magtoli sangaw sin ya Tolayin taga Langit kontodu anghel na kiden a mehulun hapa tentu ya ngamin pakapangwa na Namaratu, a yen sangaw ya pangatad na ta tagtakday tolay ta megitta ta tinarabaku na. ");
INSERT INTO agt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ammi kustu hapa ya ibar ku tekamuy ta matolay la ya kadwan kiden tekamuy petta maita muy sangaw ya Tolayen taga Langit sekadakar na en ta kuman na intu am ange sangaw sin magtogkok ta pagariyan na en,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","A ta nepagpasa na annam na araw a inalap ni Hesus ig Pedru, ikid na magkabagis kiden Santiago ikid ni Hwan, a sa naghahulun kid nga gimon ta ata-nang na bagetay. ");
INSERT INTO agt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","A ta datang da ta utun a ka-ma la nanguli ya mukat ni Hesus, te nagdakar ta kuman na dakar na bilag, a pake nagfuraw hapa ya barawasi na en ta kuman na kadakar na zilag. ");
INSERT INTO agt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","A nepagka-ma da hapa ya lalattog ni mina Moses ikid ni Eliyas, a nagbida kid te Hesus. A ya uhohug hapa ni Pedru a ");
INSERT INTO agt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","“Mappya, Afu, te itta kamin sin, te am ikayat mu a mamaddayak na ta tallu na monyumento, petta tagtakday kam ni Moses ikid ni Eliyas ta monyumento,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ammi ta paguhohug para la ni Pedru a imakban ya pake furaw na kulam a tinappanan na kid, a nadangag da ya maguhohug tekid ta umag na kulamen: “Ye-yan ya Anak kin nga pake iddukan ku, a matalakanak hapa tentu. Mappya ta dangagan muy ya ituldu na tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","A alistu nagtakab ya ituldu kiden ni Hesus, te pake nagtalaw kid na ta pakadangag da ta naguhohugen tekid. ");
INSERT INTO agt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ammi enna kid sini-ged ni Hesus, a “Imivwat kanan, a awemuy la magtalaw,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A tekid na tumangad a intu la naita da i Hesusen. ");
INSERT INTO agt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","A tekiden dumadagut ta bagetayen a nebar ni Hesus tekid ta aweda la bit bibidan ya naita da, “te mappya ta apolu masi ya Tolayin taga Langit kapye na sangaw matolay, a yen sangaw ya pangipadangag muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A ya uhohug da hapa tentu, “A am gagangay ta kunna ten sangaw ya kasasaad mu, Afu, ta iangem ta lutakin a anu mantu ya ikayat na uhohugan na mangituldu kiden? Te ibar da haman ta apolu maglattog ha i mina Eliyasen kapye na umange ya Mangikerutanen nga nekari na Namaratu. Ammi ikon haman ya napolu,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","“Kustu hala ya nebar da,” kunna hapa ni Hesus, “te kakurugan ta apolu maglattog i mina Eliyas, petta dana iparan na ya tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ammi ya ibar ku tekamuy a nabayag na haman ya nelalattog ni Eliyas, a aweda amu ta intu, a yen ta tinapangan na pinakadakal tam, a kumanen hapa sangaw ya tarabakun da teyak nga Tolayin taga Langit,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","A gafu ta nebar na en tekid a yen ya nakkamun da ta intu binida na tekid i mina Hwanen nga nangzigut ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","A tekiden nakadagut ta agyan na kadwan kiden ituldu na ta akban na bagetayen a pake umaddun ya tolay kiden nga nagindag tentu. A umange hapa ya takday nga namalentud ta atubang ni Hesus, a nakimemallak tentu. ");
INSERT INTO agt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ikallak mu haen ya anak kin, Afu, te magkiskissiw, a pake mazigatan, te mahunnak ta afuy yaga danum. ");
INSERT INTO agt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Neangek apolu ta ituldum kidin, ammi aweda haman mapagmappya,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","“Kuga awan ta kapkappyan na tolay kidin yan nga awan maketug ta pangurug da. Bababang ya kabayag na pagyan ku tekamuy nga mangitultuldu, ammi awemuy para la netug. Iange muy mantu sin ya abbingina,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","A ta nepangihuya ni Hesus ta anitu na abbingen a nealistu na nagtugutan, a yen ya nepagmappya na abbingen. ");
INSERT INTO agt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","A sangaw ta awan ta nakibidan te Hesus a umange tentu ya ituldu na kiden, a “Anu awemi napatugut ya anitu na en?” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“A on ay te awemuy pake nekatalak ta makkwa na Namaratu ya ibar muy,” kunna hapa. “Te pake ibar ku tekamuy ta am itta ya pangikatalak muy tentu maski la ta kuman na kaassangan na hukal a mabalin ta ibar muy ta bagetayin, ‘Umalit ka ta lugarewan,’ a umalit hala, te awan sangaw ta awemuy makkwa am kustu ya pangikatalak muy. ");
INSERT INTO agt_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ammi ya kuman na anitu en nga pinatugut ku ta ayanen a awena magtugut am awemuy bit pagpasān ya pangan muy ta pakimallak muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","A ta takday ha na araw tekiden nagkakampat ta iten Galileya a itta hapa i Hesus tekid, a binida na ha ya pasi na tekid. “Papasin da hala sangaw ya Tolayin taga Langit, te itta sangaw ya mangitalaba teyak, a yen sangaw ya panggafut da teyak. ");
INSERT INTO agt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ammi maski am papasin dak a matolayak hala sangaw ta mekatallu na araw,” kunna. A pake nagdamdam kid na ta inuhohug na en tekid. ");
INSERT INTO agt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","A tekiden dumatang ta ili na Kapernayum a nesimmun da ya magtuki kiden ta bwis na Simbaan. A pinohutan da hapa te Pedru am magpaga i Hesus ta bwis. “Anu, awena de magpaga na mistro muy ta bwis na Simbaan?” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Haan man,” kunna hapa ni Pedru. Ammi ta datang ni Pedru ta bali a nepagka-ma na hapa ya pohut ni Hesus tentu. “Anu ya uray mu, Simon, ta gagangay na ari kiden ta lutakin am had sin na tolay ya pagpagan da ta bwis? Intu de pagpagan da ya kagitta da kiden ono taga kadwan kiden lugar?” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“A intu pagpagan da ya taga kadwan kiden lugar,” kun ni Pedru. “A ta kumanen awena mantu magpaga na kagitta da kiden,” kun ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“Ammi mappya ta magpaga kita hala petta awan ta bida. Ara, mangalap ka mantu ta banwit, a em iparuba ta alugewan, te ya imunnan na maalap mu a itam sangaw ya pirak ta simuk na en, a yen sangaw ya iangem ta simbaanen, te kustu hala ta pagpaga ta ta bwis ta,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A ta pagyan da para la ten a itta ya ikayat na ituldu na kiden ta pohutan da te Hesus, “Afu, inya hud sangaw tekami ya pake kadakalan na makipagturay teko ta pagariyan na Namaratu ewan?” kunda. ");
INSERT INTO agt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A pinaabikan bit ni Hesus ya takday abbing, kapye na pinatayuk ta nagtatangngan da, ");
INSERT INTO agt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","a sangaw tinabbag na hapa ya pohut da. “Ya pake ibar ku tekamuy a am awemuy mauli petta negitta kam ta kuman na abbing a awemuy sangaw mesipat ta pagariyan na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Te maski am inya sangaw ya imalinnak ta nonot na ta kuman na abbingin yan a yen sangaw ya pake kadakalan na ngamin kiden tolay na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","A ya uhohug na para tekid a “Maski am inya hapa ya mangtagop ta abbing nga kumanin gafu ta pangurug na teyak a mekwenta ta iyak hapa ya pinagdulot na. ");
INSERT INTO agt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ammi am itta ya mangituldu ta dulay ta maski takday la na kaassangan kiden nga mangurug teyak a pake kakallak sangaw. A mapmappya mina en ta dana nakaddangan ya lig na en ta dappug na batu kapye na newarad ta bebay, petta awena mina nakaliwat. ");
INSERT INTO agt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kakallak ya tolay kiden gafu ta ketta na pakaayayyawan da ta pagliwat da, ammi pake kakallak para ya tolayen nga mangayayyaw tekid. ");
INSERT INTO agt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“A yen mina ya pagnonotan muy ta bari muy, te am angarigan ta kamat mu ono takkim ya gafu na pagliwat mu a awem hud gappakan kapyem iwarad, petta awem sangaw melogot? Te mapmappya ta napukulan ka mina nga magdulot ta magnayun na pagtolayam ammi ta mewarad ka ta afuyen nga awan maazap gafu ta awemen inazi. ");
INSERT INTO agt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A kumanen hapa ta matam, te am angarigan ta matam ya gafu na pagliwat mu a awem hud kilotan kapyem iwarad, petta awem melogot? Te mapmappya ta bulding ka mina nga magdulot ta magnayun na pagtolayam ammi ta mewarad ka ta afuyen gafu ta awemen inazi. ");
INSERT INTO agt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“A ya ibar ku hapa tekamuy ngamin a itan muy ta idadula muy ya maski takday la na kaassangan na mangurug kiden teyak, te itta ya anghel da nga mangtaron tekid, a mangidarum kid hapa ta atubang na Damakewan. ");
INSERT INTO agt_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","14","A intu mina pagnonotan muy ya magtaron ta kalneru. Te am angarigan ta itta ya magatut na kalneru na ammi metawag hapa ya takday, a awena hud isirak ya siyamafulu siyam kiden ta panganan da kapye na ange magapag ta takdayen nga netawag? A am naapagan nan a yen ya pake ikatalak na ammi ta awan kiden netawag. A kumanen hapa te Damakewan, te awena ikayat ta itta ya metawag maski ta takday la na kaassangan kiden nga mangurug teyak, te yen ta umange ya Tolayin taga Langit ta lutakin petta ikerutan na ya netawag,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","A ya takday para na bida ni Hesus tekid a “Am angarigan ta itta ya liwat na takday kabagis mu teko a e ka mantu tatakday makibida tentu, a tabarangam. Am ikayat na dangagan ya itabarang mu tentu a awan kad mappya, te nagmappya kanan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","“Ammi am angarigan ta awena ikayat kurugan ya uhohug mu tentu a mangalap ka mantu ta takday ono maski duwa na manguffun teko nga mangtabarang, kapye muy ha sangaw ange maguhohug tentu, pettam kumanen itta hapa sangaw ya duwa ono tallu na mangipasikkal ta ngamin uhohugan muy. ");
INSERT INTO agt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A am awena kid hapa kurugan a mappya mantu ta mebida ya liwat na ta atubang na maggagimung kiden. A am awena hapa ikayat dangagan ya tabarang na maggagimung a ikwenta muy mantu ta kuman na dulay na tolay nga awan mangurug, a awemuy na sangaw pagdulotan. ");
INSERT INTO agt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“A ya pake ibar ku ha tekamuy a intu sangaw ihangat muy ta lutakin ya dana nehangat na Namaratu ewan. A intu sangaw ipalubus muy ta lutakin ya dana nepalubus na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A ya uhohug ku para tekamuy a maski am itta ya duduwa la tekamuy nga makimallak ta Namaratu ewan, ikid na tatakday la ya nonot muy ta adangan muy tentu a kwan na hala ya ibar muy tentu. ");
INSERT INTO agt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Te maski am had sin na lugar ya agyan na duduwa ono taltallu la na maggimung gafu ta pangurug da teyak a itta yak hapa ta hebing da,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","A tentu en nabalin nagbida a umabikan hapa i Pedru nga mangpohut tentu. “A am pagliwatan nak na kabagis ku, Afu, a mamempiga mina ya pagpakomak tentu am inaman nak? Gustu de ya mamempitu?” kunna. ");
INSERT INTO agt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","A ya tabbag hapa ni Hesus tentu a “Awek ibar ta gustu ya mamempitu, te maski abat ta mamempitu fulu pitu,” kunna, ");
INSERT INTO agt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“te am ikayat muy mesipat ta iturayan na Namaratu ewan a intu mina pagnonotan muy ya keangarigan na takday ari nga nagsingir ta gagatut na tagabu na kiden. ");
INSERT INTO agt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Te ya takdayen tagabu na a niribribu ta pesuk ya gatut na, ");
INSERT INTO agt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ammi awan garay ta pagpaga na ta gatut na kiden. A gafu ta awena mapagan ya gatut na kiden a nebar na ari en ta melaku ya lalaki en, a kumanen hapa ta atawa na en kontodu ngamin kiden anak na ikid na ngamin kwa na, petta mapagan ya gatut na kiden. ");
INSERT INTO agt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ammi alistu namalentud hapa ya lalaki en ta ari en, te nakimemallak tentu. ‘Ay afu, indagam para haen ya pagpagak, te sa pagan ku ngamin gatut ku,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A gafu ta ikallak na ari en a sa inazi na ya ngamin gatut na, a pinatugut na. ");
INSERT INTO agt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","A tentu en nagtugut a nesimmun na ya sakā tagabu na en nga nakagatut tentu ta mafulu la ta idi, ammi awena para la napagan ya gatut na en. A ka-ma la ginafut na ya hul na en pattalan, a ‘Pagam na ya gatut mu,’ kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A alistu namalentud hapa ya segatuten nga nakimemallak tentu, ‘Ay indagam la bit, Kofun, petta makaapagak, te pagan ku sangaw ngamin,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ammi awena haman nekallak na takdayen awa enna hud la nedarum, petta mebalud abat ta pakapaga na mina ta ngamin gatut na. ");
INSERT INTO agt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","A gafu ta kumanen a nagdamdam hapa ya kadwan kiden sakā tagabu na, te naita da ya iningwa na awanen nangikallak, a enda nedanug ta ari da en. ");
INSERT INTO agt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","A ta nepangpaalap na ari en tentu a ‘Kuga magdupal kan na tagabu. Inazik haman ya ngamin gatut mu teyak gafu ta pakimallak mu teyak, ");
INSERT INTO agt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","a kumanen mina ya pinarigam ta sakā tagabu men ta pakimallak na en teko,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“A gafu ta pake nagporay ya ari en tentu a pinatoli na hala ya gatut na kiden, a nepebalud na hapa petta mapa-gang abat ta pakapaga na hapa ta ngamin kiden gatut na. ");
INSERT INTO agt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","A yen mina ya pagnonotan muy, te kumanen hapa sangaw ya kwan ni Damakewan tekamuy am awemuy hapa pakoman ta mappya ya nagliwat tekamuy.” ");
INSERT INTO agt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","A ta nekabalin ni Hesus nagbida a sa nagtatugut kid na ituldu na kiden ta lugar na Galileya, te ange kid ta lugar na Hudeya ta dammang na karayan na Hurdan. ");
INSERT INTO agt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ammi dumadagdag hapa ya awan bababang na tolay abat ta eyan da, a pinagmappya ni Hesus ya nagtatākit tekid. ");
INSERT INTO agt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","A umange hapa tentu ya kadwan kiden Pariseyu, te itta ya pinohutan da tentu ta pangparuba da tentu. “Mistro, had kun na pangawatam ta lintigen nga netuldu ni Moses gafu ta magatawa kiden, te mepalubus de ta igungay na lalaki ya atawa na ta kompormi la na razon?” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A ya tabbag na hapa a “Intu mina nonotan muy ya uhohug na surat na en, te ‘Pinadday na Namaratu ya napopolu kiden tolay petta itta ya lalaki ikid na babbay. ");
INSERT INTO agt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A yen ta makigungay ya lalaki ta dadagkal na kiden, te makidagga ta atawa na en, a ikwenta na Dyos ya duwa kiden ta tatakday la na tolay,’ kunna paen. ");
INSERT INTO agt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","A bakkan kid na mantu ta duwa na tolay, te tatakday kid na. A madi mantu am paggungayan tam ya pinagdagga na Namaratu ewan,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","A ya pohut da ha tentu a “Anu kawagan na mantu ta nepalubus ni Moses ta makigungay ya lalaki ta atawa na am iatad na tentu ya papel na pakigungay na?” kunda. ");
INSERT INTO agt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","“A nepalubus na ay, gafu ta pagbanad na nonot muy, ammi addet ta nepagatawa na napopolu kiden a bakkan ta kunna ten ya uray na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A yen ta ibar ku hapa tekamuy ta am itta ya makigungay ta atawa na otturu mangatawa ha ta takwan a mekwenta hala ta mangadallaw, ammi awan bale am atawa na en ya apolu nakikadallaw ta takwan na lalaki,” kunna ha tekid. ");
INSERT INTO agt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A ya uhohug hapa na ituldu na kiden tentu a “A am gagangay ta kunna ten a mapmappya mantu ta awan ta mangatawa,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ammi ya uhohug na hapa tekid a “On ay, ammi bakkan haman ta ngamin tolay ya makaattam nga awan magatawa fwera la ta maatadan kiden ta pakaattam da. ");
INSERT INTO agt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Te itta ya kadwan kiden nga awan mangatawa gafu ta dana nakapun kid ta nekeanak da. A itta hapa ya kadwan nga kinapun na sakā tolay da, a itta hapa ya kadwan nga awan mangatawa petta awan ta manabtabang ta pangidulot da ta tarabaku na Namaratu. A am itta ya makaattam nga awan mangatawa a mappya hapa am attaman na,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","A sangaw itta ya mangiange ta anak da kiden te Hesus petta ipotun na ya kamat na tekid, te ikayat da ta pakimallak na kid. Ammi nehuya na kid hapa na ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ammi ya uhohug ni Hesus tekid a “Awemuy la gamman ya anak kidin, petta e kid la teyak, te ya ngamin kiden makigitta ta abbing a yen kid ya iturayan na Namaratu ewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A nepotun na ya kamat na tekid, a nepakimallak na kid, a sangaw nagtugut kontodu ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","A magananwan la a itta ya umange nangpohut te Hesus. “Mistro, ibar mu haen teyak am anu mina ya tarabakuk nga mappya petta itta sangaw ya angat ku nga magnayun,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ammi ya tabbag ni Hesus tentu a “Anu haman ta iyak ya pangpohutam ta mappya na tarabaku, te tatakday la ya makkamu ta mappya. A am ikayat mu maatadan ta magnayun na angat a mappya ta kurugam ya lintig na kiden,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“A onay ammi had sin hud na lintig ya kurugan ku?” kunna ha na lalaki en. “A amum haman ya lintig na kiden ta awem mamapasi ta tolay, awem mangadallaw, awem magtakaw, ikid na awem magladdud. ");
INSERT INTO agt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","A dayawam hapa ig damam ikid ni hinam, a iddukam hapa ya kagittam tolay ta kuman na pangidduk mu hala ta barim,” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ammi ya tabbag ha na lalaki en, “A onay ammi kanayun kinurug ku yana kid na lintig abat ta kaabbing ku, a anu para ya pagkurangan ku?” kunna. ");
INSERT INTO agt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","“A am ikayat mu ta awan pulus ta pagkurangam a em mantu ilaku ya ngamin kiden kwam, a mangatad ka ta pobre kiden, petta itta sangaw ya pagba-nangam nga mauknud ta agyan na Namaratu ewan. A am mabalin kan a magtoli ka sangaw petta dumagdag kan teyak,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ammi ta pakadangag na lalaki en ta inuhohug ni Hesus tentu a nagtugut hapa nagdamdam, te pake addu ya kwa na. ");
INSERT INTO agt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","A ta nepagtugut na lalaki en a nagbida ha i Hesus ta ituldu na kiden: “Kakurugan ya uhohug ku tekamuy ta pake mazigat ya isassarok na maba-nang ta pangikerutan na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A pake ibar ku para tekamuy ta malmalogon ya isassarok na anwang ta hubu na dagum ammi ta isassarok na maba-nang ta pangikerutan na Namaratu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","A pake nepagpaka-lat da hapa ya inuhohug na tekid, a “Am gagangay ta kunna ten, Afu, a itta hud para ya mekerutan?” kunda. ");
INSERT INTO agt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A nesaned na bit ya mata na tekid kapye na tumabbag. “Awan pulus ta makkwa na tolay petta mekerutan mina, ammi itta ya makkwa na Namaratu, te intu ya makapangwa ta ngamin,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","A ya pohut hapa ni Pedru tentu a “Anu mantu ya maalap mi, Afu? Te amum ta sa newasa min ya ngamin kwa mi petta dumagdag kami teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A ya tabbag hapa ni Hesus tentu a “Kakurugan ya uhohug ku tekamuy ta sangaw am ittan ya bagu en paglelehut a yen hapa sangaw ya pagtogkok na Tolayin taga Langit ta pagariyan na en. A ikamuy hapa nga nagattam dumagdag teyak a maatadan kam hapa sangaw ta turay muy, petta makkamu kam ta mafulu duwa kiden tribu na Istralita kiden. ");
INSERT INTO agt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A ya ngamin kiden nagtugut ta bali da, ikid na kabagis da, ikid na dadagkal da kiden, ikid na lutak da, ikid na anak da kiden gafu ta pakesipat da teyak a maatadan kid hala sangaw ta minagmagatut ta kuman na nagtugutan da kiden, yaga maatadan kid hapa sangaw ta magnayun na angat. ");
INSERT INTO agt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ammi ya kadwan kiden nga magimpapolu ta ayanin a mapozan kid sangaw, a ya kadwan kiden nga magimpapozan ta ayanin a mapolu kid sangaw,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","A ya uhohug ha ni Hesus ta ituldu na kiden a “Ya pangiangarigan ku ta pangsagolyat na Namaratu ta tolay na kiden a kuman na tolayen nga itta ya alawa na uma na, a naggabgabi ta lalakwat, te ange magapag ta mayat mangallu ta uma na en. ");
INSERT INTO agt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A ya nagtatulagan da a tandanan na kid sangaw ta kuman na mekustu ta tangagaw, a dinob na kid ange manguma. ");
INSERT INTO agt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A sangaw ta medyo alas nwebe a umange ha ta agyan na dapunen a nasimmu na hapa ya kadwan para na tolay nga imatuttud la, te awan ta tarabaku da. ");
INSERT INTO agt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘E kanan hapa magtarabaku ta umaken, te tandanan ta kam sangaw ta kuman na mekustu ta oras muy,’ kunna tekid, a umange kid hapa. ");
INSERT INTO agt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","A kumanen ha ta alas dose, ikid na alas tres, te pinidwa na ha ya umange ta dapunen, a nangidob ha ta ange magtarabaku. ");
INSERT INTO agt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A sangaw ta alas singko a umange ha ta dapunen a itta para la ya kadwan nga awan naghehit, a ‘Annun muy haman magmalmalem ta isin nga awan magtarabaku?’ kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘A on ay te awan haman ta magpatarabaku tekami,’ kunda hapa. ‘A e kanan mantu magtarabaku ta umaken, te tandanan ta kam hapa,’ kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“A sangaw ta marimat na a dinob na makāuma en ya kapatas na en petta ayagan na ya magtarabaku kiden. ‘Em kid ayagan, te atadam kid na ta tandan da, ammi intu pangigafum ya napozan kiden,’ kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“A ta datang na napozan kiden nga umange nagtarabaku ta alas singko a inatadan na kid ta kuman na metandan ta nagmalmalem. ");
INSERT INTO agt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","A ta datang na imunnan kiden nagtarabaku a pahig da ta ad-addu sangaw ya tandan da ammi ta napolu kiden natandanan, ammi kagitta hala na metandan ta napolu kiden, ");
INSERT INTO agt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","a nagsasitangan da hapa ya nagpauma en. ‘Anu haman ta igittam tekami ya napozan kiden nga nagtarabaku awa nakaoras kid la, ammi tekami a nagmalmalem kami haman nga nagattam ta patu na bilag,’ kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","A ya uhohug na hapa ta takday tekid a ‘Anu hud ya liwat ku teko, Kofun? Awek hud netandan teko ya kuman na nagtulagan ta en? ");
INSERT INTO agt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Alapam la ya tandam a dumatang kan ta balim. Am ikayat ku iatad ta napozan kiden ya kagitta na iatad ku teko a ");
INSERT INTO agt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","awan hud ta katunungan ku petta igastuk ya pirak ku ta kuman na ikayat ku? Mappya hud ta pumassil ka gafu ta nasurok ya neatad ku ta kadwan?’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","A yen ta nebar ku tekamuy ta mapozan sangaw ya napa-polu ta ayanin, a ya napozan ta ayanin a yen sangaw ya mapolu,” kun ni Hesus ta ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","A ta nekabalin na ten a magduldulot para la ig Hesus ikid na ituldu na kiden ta ili na Herusalem, a sang neadayu na bit ya mafulu duwa kiden ta kadwan kiden tolay ta dalan, petta ikid la ya makadangag ta ibar na. ");
INSERT INTO agt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“A ta ayanin a magdulot kitanan ta ili na Herusalem,” kunna, “a yen sangaw ya panggafutan da ta Tolayin taga Langit, petta idarum dak ta atubang na padi kiden ikid na mangituldu kiden ta lintig kiden, a sa ikayat da sangaw ta masi yak. ");
INSERT INTO agt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","A am negawat dak na ta Hentil kiden nga mangibbal tekitam a amāmatan dak hapa, yaga paligatan dak kapye da sangaw pagappan ta krus. Ammi matolayak hala sangaw ta mekatallu na araw,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","A tekid na nagdulot ta dalan a himebing te Hesus ya hina nig Santiago ikid ni Hwan, a namalentud ta atubang na en ta pagadang na tentu. ");
INSERT INTO agt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Anu ya ikayat mu, Ina?” kun ni Hesus tentu. “A te ya ikayat na duwa kidin anak ku a ikid kan mina ya mesaad sangaw ta hebing mu am makatogkok kan sangaw ta pagariyam ta lutakin,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Ahu, awemuy de amu ya zigat na adangan muy,” kun ni Hesus tekid. “Makkwa muy hud sangaw ya magattam ta kagitta na neatad na Namaratu teyak ta zigat kin?” kunna. “A on ay, makkwa mi hapa,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“A kakurugan ta maparuba muy sangaw ya kagitta na zigat kin, ammi maski kunna ten a bakkan hala teyak ya magpili ta magyan ta hebing ku, te i Damakewan ya makkamu magpili,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","A ta pakadangag na kadwan kiden ta inadang na duwa kiden te Hesus a nalussaw kid hapa tekid. ");
INSERT INTO agt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ammi sa pinaabikan na kid ni Hesus petta madangag da ya ibar na tekid. “Amu muy ya gagangay na Hentil kiden ta ikwenta da ya iturayan da kiden ta kuman na tagabu da. A ya mayat magmayor ta kahulun da kiden a pagzigatan na kid. ");
INSERT INTO agt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ammi awemuy mina parigan yen kid, te ya mayat madayawan tekamuy a maguray mina makitagabu ta kadwan. ");
INSERT INTO agt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","A ya mayat metun ta mayor na ngamin a maguray hapa makitagabu tekid. ");
INSERT INTO agt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Te maski ya Tolayin nga taga Langit a bakkan ta yen ya umeyan ku ta isin petta makitagabu ya tolay kiden teyak, awa iyak ya makitagabu tekid, a isagapil ku hapa ya angat ku tekid, petta addu hapa ya masaka tekid,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","A tekiden nagtalib ta ili na Heriku a dumadagdag hapa tekid ya pake addu na tolay. ");
INSERT INTO agt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","A itta hapa ya duwa na nagdaram nga imatuttud ta pingit na kalsada en. A ta pakadangag da ta magtalib na i Hesusen a nagayayag kid na, “Ay Afu, Simsima ni mina Dabid, ikallak na kami haen, Afu,” pakakin kid. ");
INSERT INTO agt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ammi nehuya na kid na tolay kiden petta aweda mina magsitang. Ammi nepasikan da para ya iayag da, “Ay, Afu, Simsima ni mina Dabid, ikallak na kami haen, Afu,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","A nagtayuk hapa i Hesus, a binaran na kid; “Anu hapa ya pakkwa muy teyak?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Ay, Afu, ipaita mi ya awemi in pakaita,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","A gafu ta allak ni Hesus tekid a sini-ged na ya mata da kiden, a yen hapa ya nepakaita da, a dumagdag kid na hapa. ");
INSERT INTO agt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","A tekiden nakaabikan ta ili na Herusalem a pa nagimmang kid bit ta bikat na babali kiden ta Beffage ta Bagetay na Olibo, te pinaunnan ni Hesus ya duwa na ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Magdulot kanan ta babali kidewan, a maita muy sangaw ya takday kabayu nga negalut ikid na urbun na en. Ubadan muy kid te idatang muy kid hapa sin. ");
INSERT INTO agt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A am itta sangaw ya mangpohut ta pangubad muy tekid ‘A te masapul na kid la bit ni Afu,’ kummuy tentu, a ipalubus na hala tekamuy,” kunna tekid, a umange kid. ");
INSERT INTO agt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","7","A inalap da hala ya kabayu kiden ta kuman na nebar ni Hesus tekid. A ta nepangidatang da tekid a nehuklad da ya ga-gamit da ta kabayu kiden a nagtakayan ni Hesus ya urbunen. A uray hapa yen na Namaratu petta magdulot ya uhohug na en ta aglavunen, te “Ibar mu ta taga Herusalem kiden ta ittan ya ari da, te dumatang na magtakay ta urbun na kabayu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A ta nepagtakay ni Hesusen a imunnan hapa ya addu na tolay nga nangihuklad ta ulolat da kiden ta angen na en ta pangdayaw da tentu. A nangalap hapa ya kadwan ta kuman na don na anaw, a nehuklad da hapa ta angen na en. ");
INSERT INTO agt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A ya tolay kiden nga imunnan tentu ikid na itta kiden ta gafan na a nagayayag kid na. “Madaydayaw ya simsima ni mina Ari en Dabid. Bendisyonam, Afu, ya umange in sin nga pinakabarim. Madaydayaw ya Namaratu ewan,” kunda ta pagayayag da. ");
INSERT INTO agt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","A ta nepakasarok nig Hesus ta ili na Herusalem a pake masitang na ya tolay kiden ta pagpaka-lat da tentu, te “Inya hud ya tolayin yan?” kukunda. ");
INSERT INTO agt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“A i Hesus yan, ya aglavunen taga Nasaret ta iten Galileya,” kunna hapa na tolay kiden nga nakihulun te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","A ta datang ni Hesus ta ili na Herusalem a simarok hapa ta simbaan na Namaratu. A tentu nakaita ta naglaku kiden ikid na gumatang kiden a sa pinohet na kid, yaga pinagsikig na hapa ya lamesa na nagtali kiden ta pirak, ikid na pagtuttudan na naglaku kiden ta kalapati. ");
INSERT INTO agt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“Anu awemuy haman manonot ya uhohug na Namaratu ta suraten, te ‘Gagangay ta balikin yan ya eyan na tolay kiden nga pakimallakan,’ kunna haman, ammi pinagbalin muy garay ta pagkakampatan na magdarogas ikid na magswitik,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","A sangaw umange hapa te Hesus ya nagdaram kiden ikid na napilay kiden ta umag na simbaanen, a pinagmappya na kid. ");
INSERT INTO agt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","A nagayayag na ya anak kiden ta pangdayaw da tentu. “Madaydayaw ya simsima ni mina Dabiden,” pakakin kid. A ta nepakaita na padi kiden ikid na mangituldu kiden ta iningwa ni Hesus ikid na anak kiden nga magayag a nagporay kid na. ");
INSERT INTO agt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Awem hud madangag ya uhohugan na anak kiden?” kunda hapa te Hesus ta pagporay da. “A onay, a awemuy hud nabasa ya uhohug na suraten ta maski abbing ikid na asitay ya netuldu na Namaratu ta pangdayaw da tentu?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A sangaw nagtugutan na kid, a imuhet ta ili en kapye na nagdulot ta babali kiden ta Betanya. ");
INSERT INTO agt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","A ta lalakwat a nagtoli kid na ituldu na kiden ta ili na Herusalem, ammi nabisinan i Hesus ta dalan. ");
INSERT INTO agt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A tentu en nakaita ta kayu na higos ta bikat na dalan, a umange mina nagpusit ta mayan na, te negindan mina ya mayan na ta don na kiden, ammi awan haman ta mayan na. A gafu ta kumanen a “Maski awem na sangaw magmayan,” kunna ta kayu en. A awena la nabayag a namegafu magkatang ya kayu en. ");
INSERT INTO agt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","A ta nepakaita na ituldu na kiden ta kayu en a “Anu alistu nagkatang ya kayu in?” kunda ta pagpaka-lat da. ");
INSERT INTO agt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A ya uhohug ni Hesus tekid a “Kakurugan ya uhohug ku tekamuy, ta am pake ikatalak muy ya Namaratu ikid na awemuy pagduwaduwan ya nonot muy a makkwa muy hala ya kuman na nakkwak ta kayu in. A maski am ibar muy sangaw ta bagetayin ‘Umalit kan te maglattu kan ta bebay,’ kummuy, a Namaratu ya makkamu petta makkwa hala ya nebar muy. ");
INSERT INTO agt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te maski am anu ya adangan muy ta pakimallak muy a meatad hala tekamuy am kakurugan ta ikatalak muy ya pangatad na tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","A ta datang da ha ta ili na Herusalem a kuga simarok kid ha ta simbaanen, a nangituldu hapa i Hesus ta tolay kiden. A sangaw umabikan hapa tentu ya padi kiden ikid na kadwan kiden pinakadakal na tolay kiden, a pinohutan da ya gafu na tarabaku na. “Inya hud ya nangatad ta turay mu petta maguray ka la ta ngamin tinarabakum ta isin?” kunda. ");
INSERT INTO agt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","“A itta hapa ya pohut ku tekamuy,” kunna hapa tekid, “te am matabbag muy ya pohut ken a ibar ku hapa tekamuy ya gafu na turay ku ta tarabaku kin. ");
INSERT INTO agt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A ya pohut kin tekamuy a inya hud ya nangatad ta turay ni mina Hwanen petta mangzigut ta tolay, te ibar muy teyak am Namaratu, ono tolay la ya nangatad ta turay na?” kunna tekid. A gafu ta napopoyung kid na ta saludsud na en tekid a dana nagbabidan da bit ta melemad am anu mina ya tabbag da tentu; “A anu mina ya tabbag tam tentu, te am ibar tam ta Namaratu ya nangatad tentu a ‘Anu kawagan na mantu ta awemuy kinurug,’ kunna sangaw tekitam. ");
INSERT INTO agt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ammi am ‘Tolay la ya nangatad,’ kun tam a ikatupag na kitam sangaw na tolay kiden, te pake ipasikkal da haman ta Namaratu ya nangidob tentu,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","A ya tabbag da mantu te Hesus a “Awemi haman amu,” kunda. “A am awemuy mantu matabbag ya pohut ken tekamuy a awek hapa ibar tekamuy am had sin ya gafu na turay kin ta tarabaku kin,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","A ya uhohug na para tekid a “Nonotan muy mina ya keangarigan kin: Itta ya duwa na lalaki nga nagkabagis. A ya uhohug na dama da ta takdayen a ‘Aleng, e ka magtarabaku ta uma ta arawin,’ kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘O, awek ikayat O,’ kunna hapa. Ammi sangaw a nagbabawi, a umange hala. ");
INSERT INTO agt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ammi dana umangen hapa ya dama da en ta takdayen, a nebar na hapa tentu ya kuman na nebar na ta napolu en. A ‘On, Amang, eyak,’ kunna hapa, ammi awena haman umange. ");
INSERT INTO agt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","A had sin mantu ta duwa kiden ya nangurug ta dama da en?” kun ni Hesus tekid. “A ya napolu en ay,” kunda hapa. “A yen mina ya pagnonotan muy, te ta neange ni Hwanen nga nangipadangag ta katunungan tekamuy a awemuy haman kinurug. Ammi ya nagdarogas kiden nga nagsingir ta bwis ikid na nakisweldu ta pakidallaw da a kinurug da a nagbabawi kid. A maski am naita muy ya panguli na gagangay da, a usut kam la nga awan nagbabawi. A yen ta ikid sangaw ya mesipat ta pangikerutan na Namaratu, ammi tekamuy a melogot kam,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“A dangagan muy ha ya takday para na keangarigan,” kunna ha. “Itta ya takday ha na tolay nga nagmula ta addu na unas, a inaladan na hapa ya kaunasan na en. A sangaw namadday hapa ta agdapilan na ikid na ba-bali en nga pagyanan na magtaron kiden. A sangaw nepaābāng na hapa ya kaunasan na en ta kadwan, te ange bit ta takwan na lugar. ");
INSERT INTO agt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","A ta kaarawan na pagapit da a dinob na ya tagabu na kiden ta nangābāng kiden, petta alapan da mina ya ābāng na. ");
INSERT INTO agt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ammi ginafut na kid na nangābāng kiden, a pinalpaluk da ya takday, a pinapasi da hapa ya takday, yaga pinapasi da ya takday ta warad. ");
INSERT INTO agt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","A gafu ta kumanen a nangidob ha ya makāunasen ta addu para na tagabu na, ammi tinapangan da kid ha. ");
INSERT INTO agt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","A sangaw dinob na tekid ya anak na en, te nonotan na ta ‘Mamat kid sangaw ta anak kin,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ammi ta nepakaita na nangabang kiden ta anak na en a ‘Gagangay ta ye-yan sangaw ya makaalap ta ngamin kwa na makāunasen, a mappya mantu ta papasin tam hapa ya anak na in petta awan sangaw ta mangalap ta lutak na in, a kwa tanan sangaw,’ kunda. ");
INSERT INTO agt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","A ginafut da mantu ya anak na en, a neuhet da ta kaunasan kapye da pinapasi. ");
INSERT INTO agt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“A ta kuman na uray muy, a anu sangaw ya uray na makāunasen ta nangābāng kiden am dumatang sangaw tekid?” kunna. ");
INSERT INTO agt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","A ya tabbag da hapa a “Sa papasin na kid mina ay, te nagdupal kid, a ipaābāng na mina ya kaunasan na ta kadwan kiden nga makanonot ikid na mangatad tentu ta lugar na ābāng na,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","43","A ya uhohug ni Hesus tekid, “A kustu hapa ya tabbag muyen, te kakurugan ta azin na kam sangaw na Namaratu ta pangikerutan na en, a takwan na tolay sangaw ya itali na tekamuy nga mangatad tentu ta lugar na kwa na. Awemuy mantu naawatan ya binasa muyen ta surat na aglavunen, te ‘Newarad na magbali kiden ya arigi en nga nepapatayuk na Namaratu tekid. Ammi netoli na hala, a nagbalin ta kasikanan na arigi ta ngamin bali, te Namaratu ya nakkamu tentu, a dayawan tam hapa ya kalalaki na,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","A maski am inya sangaw ya medumpar ta arigi na Namaratu a intu hapa la sangaw ya matakitan, a pake nahammek na sangaw am igsilan na arigi en,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","A ta nepakadangag na padi kiden ikid na Pariseyu kiden ta keangarigan kiden ni Hesus a naawatan da ta ikid hapa la ya pagbalinan na ta kuman na nangābāng kiden ta keangarigan na kiden. ");
INSERT INTO agt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","A yen ta ikayat da gafutan petta idarum da, ammi pinalanan da hapa ya kaddu na tolay kiden, te amu da ta intu ya aglavun nga dinob na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","A ya takday para na keangarigan nga binida ni Hesus tekid a intu yan: ");
INSERT INTO agt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ya pangiangarigan ku ta pangikerutan na Namaratu ta tolay a kuman na takday na ari nga nagpamakan ta boda na anak na en,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","“A dinob na ari en ya tagabu na kiden, petta enda alapan ya ginawi na kiden ta pagpamakan na en, ammi aweda ikayat ange. ");
INSERT INTO agt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A sangaw nangidob ha ya ari en ta kadwan para tagabu na, a nebar na hapa tekid ya bidan da; ‘Ibar muy sangaw ta ginawik kiden ta dumatang kid na ta pagpamakan kin, te nabalin na haman ya pagparti mi ta baka kiden, a sa neparan na ya ngamin kanan da,’ kunna tekid, a umange kid na. ");
INSERT INTO agt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ammi ya enda kiden inalap a aweda kan matagop, te umange ya takday ta uma na en, a umange hapa ya takday ta tyenda na en. ");
INSERT INTO agt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A ya kadwan kiden para a ginafut da haman ya tagabu kiden na ari en, a pinakakallak da kid kapye da kid pinapasi. ");
INSERT INTO agt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A pirmi hapa ya poray na ari en, te dinob na ya suddalu na kiden, a enda pinapasi ya namapasi kiden ta tagabu na kiden, yaga tinungradan da hapa ya ili da. ");
INSERT INTO agt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","A sangaw nangidob ha ya ari en ta kadwan para tagabu na. A ya uhohug na tekid a ‘Sa neparan ya ngamin makan, ammi awena haman megitta na ginawik kiden. ");
INSERT INTO agt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","A emmuy mantu sanedan ya kalsada kiden, a gawin muy sangaw ya ngamin maita muy, petta e kid mangan,’ kunna tekid, a umange kid hapa. ");
INSERT INTO agt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“A sinaned da ya ngamin kiden kalsada ikid na dalan, a pinagkakampat da ya ngamin naita da nga dulay pase mappya na tolay, a napannu kid ta pagbodan na en. ");
INSERT INTO agt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“A sangaw simarok hapa ya ari en, te ange hapa makikumusta ta sangaili na kiden. Ammi neitan na hapa ya takday tolay nga awan nagbarawasi ta barawasi na magboda, ");
INSERT INTO agt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","a ‘Hoy’, kunna tentu, ‘had kukum nakasarok ta isin nga awan magbarawasi ta pakibodam?’ kun na ari en tentu. “Ammi awan ta matabbag na. ");
INSERT INTO agt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","A inayagan na ari en ya tagabu na kiden petta pohetan da ya tolayen. ‘A pake galutan muy ta mappya a iwarad muy ta agyan na sugiram, petta magyan la ten makatangtangit ta pagagayoy na,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“A yen mina ya pagnonotan muy, te maski am addu ya ayagan na Namaratu ewan a addu hapa ya umawe, a assang la mantu ya mapili,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","A ta nepakadangag na Pariseyu kiden ta bida kiden ni Hesus a nagbabidan da am had kunna mina na pangsikwat da tentu gafu ta uhohug na, petta itta mina ya pangidaruman da tentu. ");
INSERT INTO agt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","A ya iningwa da a dinob da tentu ya kadwan kiden ituldu da ikid na kahulun kiden ni Herud petta paruban da i Hesus. A ya uhohug da hapa te Hesus a “Mistro, itta ya pohut mi teko, te amu mi ta matunung ka na tolay, a matunung hapa ya ngamin ituldum ta patarabaku na Namaratu tekitam, te awem la burungan am anu ya uray na tolay, ikid na awan ta idadumam. ");
INSERT INTO agt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","A dangagan mi haen teko am ipalubus na lintig ni Moses ya pagpaga tam ta bwis ta Ari na taga Roma kiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ammi dana narikna ni Hesus ta itta ya dulay ta nonot da, a “Kuga magimmamappya kam na tolay, te parparuban dak la. ");
INSERT INTO agt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Itan ku bit ya piraken nga ipaga muy ta bwis muy,” kunna. A negawat dan hapa ya piraken tentu. ");
INSERT INTO agt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“A inya hud ya makāmukat ikid na makāngagan ta pirakin yan?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“A sinang mukat na Ari en,” kunda hapa. “A ipaita muy mantu ta gubyernu na Ari en ya mekustu ta pangurug muy tentu, a ipaita muy hapa ta Namaratu ya mekustu ta pangurug muy tentu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","A gafu ta pake nepagpaka-lat da ya tabbag na en, a awedan pakolangan, a nagtatugut kid na. ");
INSERT INTO agt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A ta arawin yen para la a umange hapa te Hesus ya Saduseyu kiden. A itta hapa ya pohut da tentu gafu ta aweda kurugan ta matolay hala sangaw ya nagpasi kiden. ");
INSERT INTO agt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Itta hapa ya pohut mi, Mistro, gafu ta lintig ni Moses,” kunda, “te am masi kan mina ya lalaki nga awan ta anak na, a mappya kan ta kabagis na en ya mangatawa ta kabalwan na en petta itta sangaw ya anak da nga lalaki nga mekwenta ta anak na nasi en. ");
INSERT INTO agt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","A ta idi ta lugar mi a itta ya pitu na lālāki nga nagkakabagis, a nangatawa hapa ya imunnanen, ammi nasi hala ta aweda para la paganak. A gafu ta netuldu ni Mosesen a ya kabagis na en ya nangatawa ta nabalu en, ammi nasi hala yen ta aweda para la paganak. ");
INSERT INTO agt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A kumanen hapa ta mekatallu en ikid na mekappaten addet ta mekapitu en. ");
INSERT INTO agt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A ta kabalinan na pasi na mekapitu en a nasi hapa ya babbayen. ");
INSERT INTO agt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","A am kakurugan ta matolay hala sangaw ya nagpasi kiden a had sin hud ta pitu kiden ya atawa sangaw na babbayen, te sa inatawa da haman?” kunda te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","A ya tabbag ni Hesus tekid a “Kuga magamamangaw kanan, te awemuy maawatan ya ikayat na uhohugan na surat kiden, yaga awemuy hapa amu ya pakapangwa na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Te am matolay sangaw ya nagpasi kiden a megitta kid sangaw ta anghel kiden ta langit, a yen ta awedan sangaw mangatawa. ");
INSERT INTO agt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A am pahig muy ta awena sangaw matolay na nagpasi kiden a had kunna mantu na pangawatan muy ta takdayen uhohug na Namaratu, te ya nebar na a ");
INSERT INTO agt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iyak ya Dyos nga dayawan ni Abraham, ikid ni Isak, ikid ni Hakob,’ kunna. “A gagangay mantu ta matolay la yen kid, te bakkan haman ta nasi ya magdayaw ta Dyos, te ya matolay ya magdayaw tentu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","A ta pakadangag na tolay kiden ta tabbag ni Hesus ta Saduseyu kiden a nepagpaka-lat da hapa ya kalalaki na netuldu na en tekid. ");
INSERT INTO agt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","A ta nepakadangag na Pariseyu kiden ta nepangabak ni Hesus ta Saduseyu kiden a naghahulun kid ha nga ange nagpohut te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","A ya takday tekid nga abugadu a intu ya nagpohut te Hesus ta pangparuba na tentu. ");
INSERT INTO agt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mistro, dangagan mi haen teko am had sin ya kadakalan na lintig ta ngamin kiden lintig na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","A ya tabbag hapa ni Hesus tentu a “Ya kadakalan na ngamin kiden lintig na a intu yan: ‘Iddukam ya Dafumewan Namaratu ta ngamin nonot mu ikid na ngamin kasikanan na barim,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A ya dagga hapa na lintigin yen a ‘Iddukam ya kagittam tolay ta kuman na pangidduk mu hala ta barim,’ kunna hapa. ");
INSERT INTO agt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","“Te ya duwa kidin lintig ya fun na ngamin kidin lintig na Namaratu nga netuldu ni mina Moses ikid na aglavun kiden ta idi,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","A ta pagkakampat para la na Pariseyu kiden a itta hapa ya pinohutan ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Anu hapa ya uray muy ta Mangikerutanen nga nekari na Namaratu tekamuy? Inya hud ya gingginafu na?” kunna tekid. “A intu gingginafu na i mina ari en Dabid,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“A ta kumanen mantu a intu hala ya simsima ni mina Dabid. Ammi anu kawagan na ta nekwenta hapa ni Dabid ta dafu na, te ya nesurat ni Dabid gafu ta Kahalwa na Namaratu a ");
INSERT INTO agt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Itta ya nebar na Namaratu ta dafu ken, te E ka sin magtogkok ta kanawan kin, te ikita ya mangabak ta katapil mu kiden, petta iko sangaw ya makkamu ta ngamin,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“A am nengagan na mantu ni mina Dabid ta ‘Dafu ken,’ kunna, a had kukunna mantu magbalin ta simsima na para?” kun ni Hesus tekid, ");
INSERT INTO agt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ammi awan ta amu da ta itabbag da tentu, a ye-yen na araw ya addet na pakidibati da tentu, te naabak kid na. ");
INSERT INTO agt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","A sangaw, nagbida ha i Hesus ta tolay kiden nangkalihung tentu kontodu ituldu na kiden gafu ta Pariseyu kiden. ");
INSERT INTO agt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","3","“Mappya ta kurugan muy ya ituldu na Pariseyu kiden ikid na mangituldu kiden ta linteg ni mina Moses, te ikid ya nesaad nga mangituldu ta lintig kiden netuldu ni Moses. Ammi awemuy parigan ya gagangay da, te aweda haman idulot ya ituldu da tekamuy, ");
INSERT INTO agt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","yaga addu hapa ya idagga da ta linteg kiden nga mazigat makkwa. Ammi tekid a aweda haman kwan ya pakkwa da ta kadwan, maski ta assang la. ");
INSERT INTO agt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","A addu hapa ya tarabakun da petta pahig na kadwan ta masikan ya pangurug da ta Namaratu. Te mamadday kid ta ibārungut da ta mukat da nga nasuratan ta lintig kiden na Namaratu, yaga ipatāpāt da kid hapa ta kamat da kiden, a sangaw pake paispotan da ya gayadan na barawasi da ta kuman na padi kiden. ");
INSERT INTO agt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","A am itta ya pabuya ono gimung a pilin da para ya pake kaispotan na agtuttudan. ");
INSERT INTO agt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","am itta kid ta lugar na addu na tolay a ikayat da dangagan ya pangdayaw na tolay kiden tekid, aglalo am ‘Ser Mistro’ itta ya kumin tekid. ");
INSERT INTO agt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ammi tekamuy a awemuy mina pagdaduman ya kabagis muy kiden, petta ‘Ser,’ kummuy ta kadwan, ono ‘Mistro,’ kummuy ta kadwan, te sa magkakabagis kam haman, a tatakday la ya mistro muy. ");
INSERT INTO agt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A awemuy mina ikwenta ya ikattolay muy ta pinakadama muy, te tatakday la ya Dama muy ta langitewan. ");
INSERT INTO agt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A awemuy hapa padayaw ta ‘Afu,’ te ya Ari en Kristu ya dana nesaad na Namaratu ta dafu muy nga makkamu tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","A am inya ya manguffun tekamuy ta kuman na tagabu a yen ya mekwenta ta kadakalan muy, ");
INSERT INTO agt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","te maski am inya sangaw ya mangpātā-nāng ta bari na a mapaākban sangaw, ammi ya imunnan magpaakban ta bari na a yen sangaw ya mapātā-nāng,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","A ya uhohug ni Hesus ta Pariseyu kiden ikid na mangituldu kiden ta lintig a “Kakallak kam sangaw nga magimmamappya, te tabtabangan muy garay ya isasarok na tolay kiden ta pangikerutan na Namaratu. Gafu ta awemuy ikayat mangurug a tabtabangan muy hapa ya mayat kinden mangurug. ");
INSERT INTO agt_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","A kakallak kam hapa sangaw, te sisteman muy ya babay kiden nabalu, petta magubatan muy ya bali da. A ikayat muy hapa pādanukan ya paklimallak muy, petta pahig na tolay kiden ta abikan kam ta Namaratu ewan, ammi pake padakalan na hapa sangaw ya pama-gang na tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","A kakallak kam sangaw, ikamuy nga Pariseyu ikid na mangituldu, te magimmamappya kam. Te pakolangan muy ya maski takday la na tolay petta ikayat na simarok tekamuy. Ammi am abalin na netuldu a nagbalin ta pake magimmamappya ammi tekmauy. ");
INSERT INTO agt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kakallak kam sangaw, te killu kam na mangituldu, te am itta ya magpagasingan ta ngagan na simbaan na Namaratu a ibar muy ta awena mekwenta na pagpagasingan na, ammi am magpagasingan ta ngagan na balituken ta simbaanen a ibar muy ta liwat na am awena idulot ya nekari na en. ");
INSERT INTO agt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Killu mantu ya nonot muy, te pahig muy ta dakdakal ya balituken ammi ta simbaanen, ammi ya simbaanen haman ya mangatad ta kwenta na balituken. ");
INSERT INTO agt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","A ta kuman na takday para uhohugan muy a ‘Ya magpagasingan ta ngagan na angiatanganen a awena mekwenta,’ kummuy. ‘Ammi ya magpagasingan ta ngagan na neatang na en a liwat na,’ kummuy, ‘am awena idulot ya nekari na en.’ ");
INSERT INTO agt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kuga killu ha ya nonot muy! Te awan mina ta kwenta na neatangen am bakkan haman ta angiatanganen ya mangatad ta kwenta na. ");
INSERT INTO agt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","A am itta mantu ya magpagasingan ta ngagan na angiatanganen a mesipat hapa ya ngamin neatang na ten. ");
INSERT INTO agt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A am itta ya magpagasingan ta ngagan na simbaanen a mesipat hapa ya ngagan na Namaratu ewan, te pagyanan na haman. ");
INSERT INTO agt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","A am itta ya magpgasingan ta langitewan a Namaratu ewan hapa ya makkamu, te ya langitewan ya pagyanan na. ");
INSERT INTO agt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kakallak kam sangaw, ikamuy Pariseyu ikid na mangituldu te magimmamappya kam. Te am iatad muy ya mekamafulu en ta Namaratu ewan a pake sukatan muy ta mappya petta awena nasurok ono makurang. Ammi ya pake mesasita en nga patarabaku na tekamuy a yen kid haman ya taliban muy. Mapmappya ta yen kid mina ya pake nedulot muy kontodu pangiatad muy ta mekamafulu ta kwa muy. ");
INSERT INTO agt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ammi killu kam haman na mangituldu, te intu masamgad muy ya alaassangen, ammi ta dappugen a awemuy masamgad. ");
INSERT INTO agt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“A pake kakallak kam sangaw, ikamuy magimmamappya, te baggawan muy ya liwan na pinggan ikid na paginuman, ammi napannu para la ya umagen ta paginggum muy ikid na pagattug muy. ");
INSERT INTO agt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Daram kam mantu na Pariseyu. Dana pakappyan muy mina ya nonot muy nga awena maita na tolay, petta ispot hapa sangaw ya maita da ta bari muy. ");
INSERT INTO agt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“A pake kakallak kam sangaw, ikamuy nga Pariseyu ikid na mangituldu, te kuman kam na tanam kiden na semyento nga pinintoran da ta furaw petta ispot. Ammi napannu haman ta tulang na nasi ikid na kompormi na matapang. ");
INSERT INTO agt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","A ta kuman na maita na tolay tekamuy a mappya kam, ammi napannu ya nonot muy ya ngamin dulay ikid na pagimmamappya muy. ");
INSERT INTO agt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","33","“A kakallak kam sangaw, ikamuy Pariseyu ikid na mangituldu, te ibosag muy ta anak na kam na dadagkal muy kiden nga namapasi ta aglavun kiden to idi. Ammi ape madamdam kanan ta pasi na aglavun kden, a yen ta pakappyanan muy ya tanan da kiden, anna tunan muy kid hapa ta magmagannud na ispot, kapye muy ape itangit ya pagdamdam muy. “‘Ay, am natolay kami mina ta araw na dadagkal mi kiden awemi nekabat tekid nga namapasi ta aglavun kiden,’ kummuy. A yen mantu ya mangibar ta pakaliwat muy hapa, te ibosag muy hala ta anak kam na namapasi kiden ta aglavun kiden. Had kukummuy mantu makalillik ta pama-gang na Namaratu tekamuy, te anak kam haman na madagat. “Aran, idulot muy la ya pinegafwanan na dadagkal muy kiden, ");
INSERT INTO agt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","te itta para sangaw ya doban ku tekamuy ta aglavun ikid na mangituldu ikid na malalaki magnonot, a amuk ta itta sangaw tekid ya papasin muy ikid na pagappan muy ikid na paligatan muy. A dadagdagan muy ya kadwan abat ta kompormi na lugar nga pagbilagan da. ");
INSERT INTO agt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","A yen ta ikamuy nga magimmamappya ya mehulun sangaw ta dadagkal muy kiden nga pa-gangan na Namaratu, te sa makaliwat kam ta pasi na mappya kiden tolay nga napapasi addet te mina Abelen nga awan nagliwat, addet te mina Zikaraya en nga anak ni Barakiya. Intu ya pinapasi muy ta hahat na simbaanen ikid na angiatanganen. ");
INSERT INTO agt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A kakurugan ya uhohug ku tekamuy ta ikamuy ngamin ya pangibalatān na Namaratu ta pasi na inin kid na tolay.” ");
INSERT INTO agt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","A gafu ta damdam ni Hesus ta sakā tolay na kiden a tinangitan na kid; “Ay, anak ku taga Herusalem; mamempiga yak mina nga nangikerutan tekamuy ta kuman na manuken nga mangukup ta piyak na kiden, ammi awemuy ikayat, awa pinapasin muy hud la ya aglavun kiden nga dinob na Namaratu ta mangaskasaba tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","A ta ayanin a iwagak na kanan na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","A ibar ku tekamuy ta awedak sangaw maita am awemuy ulin ya nonot muy, petta dayawan muy ya dinob na Namaratu nga pinakabari na tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","A ta neuhet ni Hesus ta simbaanen a nagtugut mina, ammi dinadagdag hapa na ituldu na kiden, te enda bit ipaita tentu ya ngamin kalalaki na simbaanen. ");
INSERT INTO agt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A ya uhohug hapa ni Hesus tekid a “Pake dayawan muy ya kapadday na simbaanin, ammi ibar ku tekamuy ta sa marabba sangaw ya batu na kiden abat ta awan pulus ta mesalnuk ta maski takday la na batu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","A tekiden nakadatang ta utun na bagetay na Olibo, a nagtuttud i Hesusen. A umange ha tentu ya ituldu na kiden, a pinohutan da ya nebar na en tekid. “Afu, dangagan mi haen am kanu sangaw na araw ya nebar men nga kaperdi na simbaanen. A am magtugut kan sangaw a anu hapa sangaw ya pakaitan mi ta pagtolim sangaw sin ikid na pagaddetan na arawin yan?” kunda. ");
INSERT INTO agt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","A ya tabbag na en tekid a “Mangalwad kam ta maayayyaw kam sangaw,” kunna, ");
INSERT INTO agt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","“te addu sangaw ya umange nga magingagan ta ngagan kin, te ‘Iyak ya Kristu nga Mangikerutan tekamuy,’ kunda sangaw, a addu sangaw ya mapadagdag da ta pangayayyaw da tekid. ");
INSERT INTO agt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","A itta hapa sangaw ya gubat ta agyan muy, pase adayu na lugar, ammi awemuy la malalang ta isin kid, te gagangay ta dumatang ya kumanin, kapye na idatang na pagaddetan na arawin yan. ");
INSERT INTO agt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Te pagka-ma makigubat ya takday gubyernu ta takwan, a pagka-ma magkāgubgubat ya kadwan kiden tribu, yaga magkakattway hapa ya kadwan kiden tolay nga maginggubgubat, a dumatang hapa sangaw ya addu na agbabisin ikid na lunig ta magdaduma na lugar. ");
INSERT INTO agt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ammi ye-yen kid na zigat ya pamegafwanan la na kadakalan na pagzigātān. ");
INSERT INTO agt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“A gafutan da kam hapa sangaw petta iange da kam ta mangpa-gang tekamuy. A papasin da sangaw ya kadwan tekamuy, te ikatupag na kam sangaw na tolay kiden ta ngamin kiden lugar gafu ta pangurug muy teyak. ");
INSERT INTO agt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","A gafu ta pagzigātān a addu hapa sangaw ya magtalekud ta pangurug da teyak, a ikatupag da sangaw ya kahulun da kiden mangurug, a italaba da kid. ");
INSERT INTO agt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“A imitta hapa sangaw ya addu na matulad na aglavun, a addu sangaw na tolay ya mapadagdag da ta pangayayyaw da tekid. ");
INSERT INTO agt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A gafu ta dumakal la dumakal ya kadulayan a addu sangaw ya magsanaw ta pangidduk da ta Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ammi ya maketurad sangaw abat ta kabalin na a yen sangaw ya mekerutan. ");
INSERT INTO agt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A mepadangag sangaw ya damag na pangikerutan na Namaratu abat ta ngamin kiden lugar ta paglelehutin petta madangag na ngamin tolay. A am nabalin na mepadangag ta ngamin tolay a yen sangaw ya pagaddetan na arawin yan. ");
INSERT INTO agt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Amu muy hapa ya nelavun na aglavunen mina Danyel, (aglalo ikamuy nga nakabasa ta surat ni Danyel) gafu ta ketta na sangaw na pake dulyen nga manggubat sangaw ta simbaan na Namartu te isin Herusalem. A am maita muy yen, ");
INSERT INTO agt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","a yen mina ya pagbabakwit na tolay kiden ta Hudeya petta umahat kid mina ta bagetay kiden. ");
INSERT INTO agt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","A ya itta en ta lawan na bali na en a awena mina nonotan ya kwa na kiden ta umag na bali. ");
INSERT INTO agt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","A ya magtarabaku ta uma awena mina tolin ya barawasi na en nga netabnak na ta lutak. ");
INSERT INTO agt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ammi kakallak sangaw ya matarun ikid na magpasusu ta isina kid na araw, te matalantan kid sangaw gafu ta pagdammatan da. ");
INSERT INTO agt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","A dana pakimallak muy hapa ta bakkan ta agirid ikid na araw na agimmang ya datang na dulayen, talo am mazigatan kam ta pagbakwit muy. ");
INSERT INTO agt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","“A am ittan sangaw ya dulayen nga ikatupag na Namaratu a yen sangaw ya ketta na dakal na pagzigātān nga pake dakdakal ammi ta ngamin kiden pagzigātān abat ta nekapadday na lutak abat ta ayanin. A am nagpasan a awan na ha sangaw ta kumanen maski am kanu. ");
INSERT INTO agt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","A am mabayag mina ya araw na pagzigātānen a awan mina ta makalillik ta zigaten, ammi paāssangan na sangaw na Namaratu ya kabayag na petta mekerutan ya tolay na kiden nga pinili na. ");
INSERT INTO agt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“A am madangag muy sangaw ya ‘O itan muy, itta in ya Kristu nga mangikerutan tekitam,’ kumin, ono am ‘Yo, itta tewan,’ kumin, a awemuy malat kurugan, ");
INSERT INTO agt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","te kurug ta addu hala sangaw ya matulad na mangikerutan ikid na addu na matulad na aglavun. A am itta kid na a mangwa kid hapa ta dakal na pakaitan ikid na pagpaka-latan na tolay kiden, te pangayayyaw da tekid talo am itta hapa ya mapadagdag da ta maski tolay kiden na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","A mappya ta awemuy sangaw kaliwatan yan, te dana nebar kun haman tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","A am ibar da mantu sangaw ta itta yak na ta talun, a awemuy malat magalit. A am magtagu yak kan ta umag na bali, a awemuy malat kurugan, ");
INSERT INTO agt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","28","te yen hapa sangaw ya pagdulot na bida da en ta ‘Kompormi ya agyan na malogon maayayaw a yen hapa ya eyan na mangayayaw tekid,’ kunda. Ammi am dumatang sangaw ya Tolayin taga Langit, a ka-ma la sangaw ya iange na kuman na kilaten nga magdangang. ");
INSERT INTO agt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“A am nabalin na sangaw ye-yen na pagzigātān a mavit hapa ya pagsugiram na bilag ikid na hulan, yaga makutukutet sangaw ya bitwan kiden ta langit, a magkāhunnak kid. ");
INSERT INTO agt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","A yen sangaw ya pagagayoy na ngamin kiden tolay nga awan mangurug gafu ta liwat da ta Tolayin nga taga Langit, te maita da sangaw ya lattog na en ta langitewan, te dumagut sangaw nga imatogkok ta kulam kiden, a mehulun sangaw tentu ya ngamin kasikanan ikid na kalalaki na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","A doban na hapa sangaw ya anghel na kiden ta pagsitang na masikan na amaryung petta uknudan da ya ngamin kiden napili na taga ngamin paglelehutin. ");
INSERT INTO agt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“A intu mina pagnonotan muy ya keangarigan na taggaten, te am lumattog na ya lappaw na kiden a yen ya pakaitan ta darun na. ");
INSERT INTO agt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","A kumanen hapa sangaw am dumatang na ya ngamin kiden nabidak tekamuy ta ayanin, te yen kid sangaw ya pakaitan ta tanagay na ya pagtolik. ");
INSERT INTO agt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A kakurugan ya ibar ku tekamuy ta mamegafu magdulot ya ngamin kidin nabidak tekamuy ta awena para la pagpasan na araw kidin yan. ");
INSERT INTO agt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Te gagangay ta umawan sangaw ya ngamin langitewan ikid na lutakin, ammi awena mauli na ngamin inuhohug ku tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ammi am kanu sangaw na araw ikid na oras ya pagtolik ta lutakin a awan ta makkamu, maski ta anghel kiden, a maski teyak, te intu la makkamu i Damakewan. ");
INSERT INTO agt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ammi addu sangaw ya awan nakaparan ta datang ku, te pagka-ma da sangaw ya datang ku ta kuman na nepagka-ma na tolay kiden ta layusen ta araw ni mina Nowe en, ");
INSERT INTO agt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","te aweda kurugan ta itta ya dulay awa pangākan da la, a iafura da la ya mangatawa, ikid na magboda abat ta araw na layusen. A nagkealud kid na ta danumen nga nagkalimat. ");
INSERT INTO agt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ammi teg Nowe ikid nga mamattama a dana simarok kid na ta bapor na en nga dana pinadday na, te pake dakal ya layusen abat ta nalintab ya ngamin kiden kayu ikid na bagetay. A kumanen hapa sangaw ya kelogot na kadwan kiden ta datang na Tolayin taga Langit, ");
INSERT INTO agt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","te maghebing sangaw ya duwa na lalaki nga magtarabaku ta uma, a ka-ma la sangaw maalap ya takday, a mesirak ya takdayen. ");
INSERT INTO agt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","A magkaalsud hapa sangaw ya duwa na babbay nga magbayu, a ka-ma la sangaw maalap ya takday a mesirak ya takdayen. ");
INSERT INTO agt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“A mappya mantu ta if-ifunan muy ya bari muy, te awemuy amu am kanu sangaw na araw ya pagtoli na dafu muy. ");
INSERT INTO agt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","A itan muy ta parigan muy sangaw ya natulisanen ta bali na, te am dana amu na mina ya oras na iange na tulisan a awena mina nasidug, te inifunan ya bali na en, petta awena natulisan. ");
INSERT INTO agt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","A mappya ta dana magparan kanan hapa ta datang ku, te am pahig muy sangaw ta awek para la dumatang, a yen hala sangaw ya datang ku,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","A ya takday para na keangarigan nga binida ni Hesus tekid a intu yan: “Ya mekwenta ta mekatalak ikid na makanonot a intu hala ya kuman na tagabu en nga awan mangilogot ta dafu na en, te idulot na la ya magpakan ta anak na kiden ta kuman na nebar na dafu na en tentu. ");
INSERT INTO agt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A pake magāsāt hapa sangaw yen am datangān na dafu na en, ");
INSERT INTO agt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","te intu sangaw ya pagtaronan na ta ngamin kiden kwa na. ");
INSERT INTO agt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ammi ya tagabu en nga awan makanonot, a pahig na ta ‘Oh, pake mabayag para ya datang na dafu ken,’ kunna, ");
INSERT INTO agt_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","a palpalukan na ya sakā tagabu na kiden, ikid na sakā makipaginum ikid na makipangan ta magkellaw kiden. ");
INSERT INTO agt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ammi pagka-ma na sangaw ya datang na dafu na en gafu ta awena amu ya oras na datang na. ");
INSERT INTO agt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A kattaban na sangaw na dafu na en, kapye na pehulun ta magimmamappya kiden ta lugar nga pagzigātān da ikid na pagtatangitan da,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","A sangaw binida ha ni Hesus ya takwan na keangarigan tekid; “Am magdulot sangaw ya pangikerutan na Namaratu ta pagaddetan na arawin yan a datangan na sangaw ya tolay kiden ta kuman na mafulu kiden babbalatang nga umange nakibodan ta hiklam. Tagtakday ya balatang kiden ta zilag da tekiden umange dimafung ta lalaki en nangatawa. ");
INSERT INTO agt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","A ya lima na balatang kiden a napāpāwang ya nonot da, ");
INSERT INTO agt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","te aweda haman nanonot ya nagbalun ta gās na hilag da, ");
INSERT INTO agt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ammi ya nakanonot kiden a dana neparan da gās da, a nehulun da hapa ta agzilag da. ");
INSERT INTO agt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A gafu ta nagtalantan ya lalaki en nangatawa a sa nakakasidug ya babbalatang kiden. ");
INSERT INTO agt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ammi sangaw ta tangngan na hiklam a itta ya nagayag, ‘Ittan ya lalaki en, emmuy na dafungan,’ kunda. ");
INSERT INTO agt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","A alistu imivwat ya babbalatang kiden, a padakalan da ya gatang na hilag da kiden, ammi dulay te maazap hala ya hilag na napāpāwang kiden, a magadang kid hapa ta kadwan kiden. ");
INSERT INTO agt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","‘Ay mangatad kam bit ta gās na hilag muy O, te naazap ya hilag mi kiden,’ kunda. ");
INSERT INTO agt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘A mappya ta alistu kanan ange ta maglaku kiden petta gumatang kam talo am awena sangaw makalannat na gās na hilag mi,’ kunna hapa na nakanonot kiden. ");
INSERT INTO agt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“A tekid na umange gumatang a dumatang na hapa ya lalaki en, a ya nakanonot kiden nga dana nakaparan a nehulun kid na tentu nga simarok ta bali en nga pagbabodan da, a nelitup ya bali en. ");
INSERT INTO agt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","A ta pagtoli na kadwan kiden balatang nga umange gumatang ta gās da a baran da hapa ya lalaki en ta umag na bali, ‘Afu, ihukatan na kamin O,’ kunda. ");
INSERT INTO agt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ammi netabbag na ta ‘Aweta kam aamu,’ kunna la tekid. ");
INSERT INTO agt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“A yen mina ya pagnonotan muy petta awemuy sangaw melogot awa dana nakaparan kam mina, te awemuy hapa amu am kanu ya datang na Dafu muy,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“A ya takday para keangarigan na pangikerutan na Namaratu ta tolay, a kuman na takday tolay nga umange nagpasyar ta adayu na lugar. Te dana inayagan na ya tagabu na kiden, petta isaned na ya pirak na tekid petta taronan da mina ya paganak na pirak na en. ");
INSERT INTO agt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A ya takdayen ya inatadan na ta limaribu, a ya mekaduwa en ya inatadan na hapa ta dwaribu, a ya mekatallu en ya inatadan na ta maribu la, te intu neatad na tekid ya kustu la en nga mataronan na tagtakday tekid, a sangaw nagtugut. ");
INSERT INTO agt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","A ya naatadan ta limaribu a alistu ange magapag ta pagatutan na ta pirak na en, a naba-bayag ta assang a nadaggan hapa ta limaribu ha. ");
INSERT INTO agt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kumanen hapa ta naatadanen ta dwaribu, nadaggan hapa ya pirak na en ta dwaribu ha. ");
INSERT INTO agt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ammi ya mekatallu en nga naatadan ta maribu la a enna haman nekali ya pirak na dafu na en, a netagu na haman ta umag na lutak. ");
INSERT INTO agt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“A ta nepagpasa na addu na araw a dumatang hapa ya dafu na tagabu kiden, a inayagan na kid ha petta tukin na kid ta kwa na. ");
INSERT INTO agt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Umange ya takdayen nga inatadan na ta limaribu, a ‘Limaribu ya neatad mu teyak, Afu. Ye, nadaggan kun hapa ta limaribu te mafuluribun ngamin,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘A mappya ka mantu na tagabu te awenak nelogot. A gafu ta mekatalak ka nga magtaron ta assang a paturinan ta ka hapa petta makaibbal ka ta addu. A mesipat kan mantu ta pagayayatan na dafum,’ kunna hapa na dafu na en tentu. ");
INSERT INTO agt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","A sangaw umange hapa ya naatadan ta dwaribu, a ‘Dwaribu ya neatad mu teyak, Afu, te nadaggan kun hapa ta dwaribu te appataribun ngamin,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘A mappya ka mantu na tagabu te awenak hapa nelogot. A gafu ta mekatalak ka nga magtaron ta assang a paturinan ta ka hapa petta makaibbal ka ta addu. A mesipat kan mantu ta pagayayatan na dafum,’ kunna hapa na dafu na en tentu. ");
INSERT INTO agt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","A sangaw umange hapa ya naatadan ta maribu la. A ya uhohug na hapa a ‘Ay, Afu, awek napadakal ya pirak men te nagburungak ta maabakak, a yen ta enku nekali ta lutak petta itta hala sangaw ya itolik teko ta datang mu, te amuk ta masistema ka na tolay nga makapakaddu ta maski assang la na pirak, te yaga magba-nang ka ta banbannag na kadwan. A yeh, alapam na ha, te itta ya ngamin kwam sina,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Ammi pake nagporay ya dafu na en, a ‘Kuga dupal ye-yan na tagabu nga matalakag. Am amum mantu ta magba-nangak ta banbannag na kadwan a anu awem mantu nepagatut ya pirak ku ta gumatut kiden petta madaggan mina ya pirak ku?’ kunna hapa na dafu na en tentu. ");
INSERT INTO agt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Azin muy mantu ya maribu en tentu a iatad muy ta magibbalen ta mafuluribu,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“A yen mina ya pagnonotan muy, te kunna ten sangaw ta iturayan na Namaratu ewan. Te ya mekatalak magtaron ta neatad tentu a madaggan sangaw ya kwa na petta addu, ammi ya awan mekatalak a maazi sangaw ya dana neatad tentu. ");
INSERT INTO agt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","A ya kuman na tagabu en nga awan ta serbi na a iabbang da sangaw ta agyan na sugiram, petta yen sangaw ya pakatangtangitan na ta takit na,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","A ya takday para na keangarigan nga binida ni Hesus a intu yan: “Am magtoli hala sangaw ya Tolayin taga Langit a pake mepaita ya ngamin kalalaki na, a mehulun hapa tentu ya ngamin na anghel na kiden. A am nakatogkok na ta agtuttudan na pagturay na, ");
INSERT INTO agt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","a sa pagkakampatan na hapa sangaw ya ngamin tolay ta atubang na en. A am sa nagkakampat kid na a paggungayan na kid sangaw ta kuman na magtaronen nga magpagungay ta kalneru ikid na kalding. ");
INSERT INTO agt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A ya kuman na kalneru kiden a itun na kid ta kanawan na en, a ya kuman na kalding kiden a yen sangaw ya itun na ta kanigid na en. ");
INSERT INTO agt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","A ya uhohug sangaw na Ari en ta itta kiden ta kanawan na en a ‘Ikamuy ya pasinapān ni Damakewan, a magdulot kanan mantu teyak, te mesipat kanan ta pangikerutan na Namaratu, te yen ya neparan na tekamuy abat ta nekapadday na lutakin. ");
INSERT INTO agt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Te ikamuy ya nangatad ta kanan ku teyaken nabisin, a teyaken gimtang a ikamuy ya nangatad ta inuman ku, a teyaken nakipagsil tekamuy a ikamuy hala ya nagpadulot teyak, ");
INSERT INTO agt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","yaga inatadan dak hapa ta barawasi teyaken awan ta nepagbarawasi, a kinahadan dak ta nepagtakit ken, a pinasyar dak hapa ta nekabalud ken,’ kunna sangaw na Ari en tekid. ");
INSERT INTO agt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ammi pagpaka-lat da hapa sangaw ya ibar na tekid, a ‘Kanu huden ya nepangpakan mi teko, Afu, ikid na nepangpenum mi teko? ");
INSERT INTO agt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","A kanu huden ya nepagpadulot mi ta nepakipagsil mu tekami ikid na nepangatad mi ta pagbarawasim? ");
INSERT INTO agt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","A kanu huden ya nepagpasyar mi ta nepagtakit mu pase nekabalud mu?’ kunda sangaw. ");
INSERT INTO agt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‘A kakurugan ta kunna ten, te tekamuyen nangikallak ta kaāassangan na kabagis ku kiden sin a mekwenta ta yen hapa ya nepangikallak muy teyak,’ kunna hapa sangaw na Ari en tekid. ");
INSERT INTO agt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“A ya uhohug sangaw na Ari en ta itta kiden ta kanigid na en a ‘Umadayu kanan teyak, te mataguhali kanan, a mekabat kanan ta afuyen nga awan maazap nga neparan na Namaratu teg Satanas ikid na anitu na kiden. ");
INSERT INTO agt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Te maski nabisinak a awedak inatadan ta kanan, a teyaken gimtang a awedak haman pinenum. ");
INSERT INTO agt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","A teyaken nagdulot tekamuy a awedak pinagdulot, a teyaken awan ta barawasi a awedak inatadan ta pagbarawasik. A nagtakitak, a nabaludak, ammi awedak tinagop kinahadan,’ kunna sangaw tekid. ");
INSERT INTO agt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","A pagpaka-lat da hapa sangaw ya uhohug na tekid, a ‘Kanu huden, Afu, ya nekabisim ta awemi nepangikallak teko? A kanu hud ya nepakainum mu ta awemi nepangpenum teko? A kanu hud ya nepagdulot mu tekami ta awemi nepagpadulot teko? A kanu huden ya awemi nepangatad teko ta kawan na nepagbarawasim, ikid na nepagtakit mu, ikid na nekabalud mu?’ kunda sangaw tentu. ");
INSERT INTO agt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‘A kakurugan ta kunna ten, te tekamuyen awan nangikallak ta kaāassangan na kabagis ku kidin a mekwenta hapa yen ta awemuyen nepangikallak teyak,’ kunna sangaw tekid. ");
INSERT INTO agt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","A gafu ta kumanen a medob sangaw ye-yen kid ta magnayun na kapa-gangan da, ammi ya mangurug kiden a yen kid sangaw ya mesipat ta magnayun na pagtolayan,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","A ta nekabalin ni Hesus nangituldu ta keangarigan kiden ta ituldu na kiden a takwan na ya nebar na tekid; ");
INSERT INTO agt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Amu muy ta dwangagaw para la abat ta pyesta na Simana tam, a yen sangaw ya panggafut da teyak petta pagappan dak papasin,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A ta pagbida na para la tekid a itta hapa ya miting na ngamin kiden pinakadakal na Hudyo kiden ta bali ni Kaypas nga kadakalan na padi, ");
INSERT INTO agt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","te pagbabidan da am had kunna mina na panggafut da te Hesus ta awena pakkamu na tolay kiden, petta papasin da. ");
INSERT INTO agt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Ammi awetam mina gafutan ta ketta para la na pyesta en, talo am magtatapil ya tolay kiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","A sangaw umange ig Hesus ikid na ituldu na kiden ta iten Betanya ta bali ni Simonen nga nagkangaw ta idi. ");
INSERT INTO agt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","A tekid para la nangnangan a itta hapa ya babbay nga himebing te Hesus, a ibbalan na hapa ya botelya na bangog nga pake mangina am melaku, a neburud na ta ulu ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ammi nagporay hapa ya ituldu na kiden ta babbayen, a nehuya da. “Anu haman ta isayang mu ya bangogina? ");
INSERT INTO agt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pade awa mangina mina am melaku, petta meatad mina ya paga na ta pobre kiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","A ta pakadangag ni Hesus ta uhohug da tentu a nehuya na kid hapa. “Annun muy haman ihuya ya babbayin? Awa mappya haman ya iningwa na teyak. ");
INSERT INTO agt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sigida itta haman tekamuy ya pobre kiden, ammi teyak a awek sangaw sigida tekamuy. ");
INSERT INTO agt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","A neburud na ya bangogin ta barikin petta dana meparan ya barikin ta ketanam na. ");
INSERT INTO agt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A kakurugan hapa ya uhohug ku tekamuy ta maski am had sin na lugar ya pakepadangagan na damag ku ta ngamin paglelehutin a megindan hapa mebida ya iningwa na babbayin yan, te panadamdaman da sangaw tentu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","A ta nekabalin na en a nagtugut hapa i Hudas Iskaryote nga takday ituldu ni Hesus, te umange nakitulag ta padi kiden. ");
INSERT INTO agt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","A ta datang na tekid a “Piga hud sangaw ya iatad muy teyak am uffunan ta kam manggafut te Hesus?” kunna tekid. A nagtatulagan da ya tallufulu hukal na pirak. ");
INSERT INTO agt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A yen hapa ya pamegafu ni Hudas nga magapag ta mappya na araw ta pangitalaba na te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","A ta napolu en araw ta pyesta na Simana na Hudyo kiden am mangan kid la ta panen nga awan bumlad a umange ya ituldu na kiden tentu, a pinohutan da am had sin na lugar ya pangiparanan da ta pamurab da ta Simana. A nebar na tekid ta ");
INSERT INTO agt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","“E kam ta ili ta bali na kofun ken, a ‘Dinob na kami na Mistro mi en,’ kummuy sangaw tentu, ‘te mangan kami kan ta pamurab mi ta Simana ta bali min, te abikan na ya pasi na,’ kummuy sangaw tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A enda ibalin ya nebar na en tekid, a neparan da ya pamurab da ta Simana. ");
INSERT INTO agt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","A ta furab a nakikkanan ig Hesus ikid na mafulu duwa kiden ituldu na. ");
INSERT INTO agt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","A tekid para la nagkakan a naguhohug hapa i Hesus. “Kakurugan ta itta tekamuy ya mangitalaba sangaw teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","A gafu ta nebar na en a nagdadamdam kid na, a ya tagtakday kid hapa ya nagpohut tentu, “Iyak hud ya kinamen, Afu?” kun na tagtakday tekid. ");
INSERT INTO agt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","“Intu sangaw mangitalaba teyak ya nakipagkammat teyak ta pingganin. ");
INSERT INTO agt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A gagangay ta mamapasi sangaw ya Tolayin taga Langit ta kuman na nesurat na aglavunen, ammi pake kakallak sangaw ya makaliwaten manigtalaba teyak, te mapmappya ta awena mina neanak,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","A yen hapa ya nepagpohut ni Hudasen nga manggakkad mangitalaba tentu. “A iyak hud, Afu, ya kinamen nga mangitalaba teko?” kunna. “Maski iko,” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","A tekid para la nagkakan inibalan ni Hesus ya pan nga itta ta lamesa en kapye na nepakimallak, kapye na hapa ginadgadwa, a sangaw nesaned na ta ituldu na kiden. “Yeh, kanan muy yan te megitta ta barikin,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","A sangaw inalap na hapa ya basu na inuman da en kapye na ha nepakimallak, a sangaw negawat na hapa tekid, “Yeh, sa uminum kam ta isin, ");
INSERT INTO agt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","te megitta ta dagak nga magarut sangaw, te yen sangaw ya mangipasikkal ta pakitulagan na Namaratu, petta mapakoma na ya liwat na addu na tolay. ");
INSERT INTO agt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ammi ibar ku hapa tekamuy ta awek sangaw makipaginum tekamuy abat ta panginum tam sangaw ta bagu na inuman ta pangayayat tam ta pagariyan ni Damakewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","A ta nekabalin da uminum a nagkakansyon kid nga nangdayaw ta Namaratu, kapye da umange ta Bagetay na Olibo. ");
INSERT INTO agt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","A ya takday ha na uhohug ni Hesus tekid a “Amuk ta pakigungayān dak sangaw ta hiklamin yan ta kuman na nesurat na aglavunen ta palungu araw, te ya uhohug na aglavunen a ‘Papapasi sangaw na Namaratu ya magtaron a makutkutet sangaw ya kalneru kiden,’ kunna ta surat na en. ");
INSERT INTO agt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ammi sangaw am matolayak a mapa-polu yak sangaw ammi tekamuy nga ange ta iten Galileya,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","“O maski pakigungayān na ka na kadwan, Afu, aweta ka sangaw pakigungayān,” kunna hapa ni Pedru tentu. ");
INSERT INTO agt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","“Maski ilemad nak hala sangaw ta mamillu ta hiklamin yan ta awena para la pagtareknay na manuk,” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","“Ay awan, Afu, maski ikabat dak sangaw teko papasin a aweta ka sangaw ilemad,” kunna ha ni Pedru. A kumanen hapa ya nepasikkal na kadwan kiden ituldu na. ");
INSERT INTO agt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","A ta datang da ta Bagetay na Olibo a nagdulot kid ta lugaren nga nagngagan ta Getsimani, a ya uhohug ni Hesus tekid a “Magtuttud kanan ta isin te eyak bit yo tewan makimallak,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ammi nehulun na hapa ig Pedru ikid na duwa kiden anak ni Zibadeyu. A sangaw nepagka-ma na hapa ya pagdamdam na, a pake nagburung na. ");
INSERT INTO agt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","“Kuga ipasik de ya sikan na damdam kin. Magyan kam la sin a awemuy la masidug,” kunna tekid, ");
INSERT INTO agt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","a sang imadayu tekid kapye na nagtakab ta lutak nga nakimallak. “Ikallak nak, Amang, te am mabalin mina a ilillik nak haen ta pagzigātān kin nga nekarim teyak. Ammi maski kunku a bakkan mina ta yen ya magdulot, te mappya ta ikayat men ya idulot ku,” kunna ta pakimallak na. ");
INSERT INTO agt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A tentu en nagtoli teg Pedru a masidug kid na, a “Anu hud, awemuy hud maattaman ya awan masidug ta maski takday la na oras? ");
INSERT INTO agt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Awemuy la masidug, te makimallak kam mina petta awemuy mina maayayyaw, te maski am malogon ya nonot muy a makafuy ya bari muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A umange ha nakimallak ta kuman na intu en. “Am uray mu, Amang, ta awek melillik ta iatad men teyak nga pagzigātān ku a mappya mantu ta yen ya magdulot,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A sangaw nagtoli ha ta ituldu na kiden, a masidug kid ha, te awena makaladdang na mata da. ");
INSERT INTO agt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A gafu ta kumanen a nagtugut ha ange nakimallak, a pamillun na hala ya kuman na nepakimallak na en. ");
INSERT INTO agt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","A ta nepagtoli na ha ta ituldu na kiden masidug a “Ayanin hud ya agkakasidug ikid na agibannag? Itan muy ya oras awa ayanin ya ange na mangitalaba ta Tolayin taga Langit petta igawat nak ta awan kiden mangurug ta Namaratu. ");
INSERT INTO agt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Imivwat kanan, te entanan, te ittan ya mangitalaba teyak,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","A ta pagbida para la ni Hesus ta ituldu na kiden a dumatang na i Hudasen, a nehulun hapa tentu ya awan bababang na tolay nga dinob na pinakadakal da kiden ikid na padi kiden, a nagibbal kid hapa ta kampilan ikid na paluk. ");
INSERT INTO agt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A dana nebar na mangitalaba en ya pagsenyas na sangaw ta kahulun na kiden petta amu da ya gafutan da. “Ya amuyan ku sangaw a yen ya gafutan muy, te intu yen,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A gafu ta kumanen a nagdaretyo i Hudas te Hesus a “Itta yak O, Afu,” kunna tentu, kapye na inamu. ");
INSERT INTO agt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","“A iko mantu, Kofun,” kun ni Hesus tentu, “Aran, ialistum mantu ya neangem sin,” kunna hapa tentu. A umabikan hapa ya kadwan kiden tolay, a ginafut da i Hesus. ");
INSERT INTO agt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ammi ka-ma la sinukkut na takday kahulun ni Hesus ya kampilan na en, a kinattab na ya takday tekid ta bangbang na en a newasik na. Intu kinattab na ya tagabu na kadakalan na padi. ");
INSERT INTO agt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ammi ginamman hapa ni Hesus ya nangkattaben, “Ialag mun ya kampilamina, te am inya ya imunan mangkattab a masi hapa sangaw ta kattab. ");
INSERT INTO agt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Am awek mina magafut a awek hud magadang te Damakewan, a alistu mangidob ta nasurok ta limafulu ribu na anghel petta ikerutan dak mina. ");
INSERT INTO agt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ammi am kunna ten a had kukunna sangaw magdulot na uhohug na surat kiden?” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A sangaw naguhohug hapa i Hesus ta tolay kiden nga nanggafut tentu. “Anu dulayak hud na tolay, petta endak gafutan konsu kampilan ikid na paluk ta kuman na panggafut muy ta tulisan? Kinanghahawak haman imatuttud ta simbaanen nga nangituldu, a anu bakkan ta yen ya nanggafutan muy teyak? ");
INSERT INTO agt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ammi gagangay ta kunna sin ya tinarabaku muy petta magdulot ya nesurat na aglavun kiden,” kunna. A yen hapa ya nepangiwagak na ituldu na kiden tentu, te nagbabilag kid na. ");
INSERT INTO agt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","A ya nanggafut kiden te Hesus a neange da ta bali ni Kaypas nga kadakalan na padi, te yen ya nagaammungan na mangituldu kiden ikid na pinakadakal na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ammi te Pedru a tinultulitul na kid hapa abat ta bagaw na bali en. A tentun nakasarok ta bagawen a nakipagtuttud hapa ta maggwardya kiden, petta itan na am anu ya pagbalinān na pangidarum da te Hesus. ");
INSERT INTO agt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","A ya padi kiden ikid na ngamin kiden nagkonsihal a apagan da ya pangipasikkal da ta liwat ni Hesus petta pangpapasin da mina tentu. ");
INSERT INTO agt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ammi awan ta naapagan da, te maski am addu ya nagtayuk nga nagtulad a nagimpagsil haman ya inuhohug da. A ta kapozyanan na a nagtayuk ya duwa na mangipasikkal ta tulad da, ");
INSERT INTO agt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","a ya uhohug da hapa a “Ya kuman na nadangag mi ta uhohug na inin a itta kan ya pakapangwa na nga mangkutkutet ta simbaan na Namaratu kapye na ha patayukan ta las-ud na talluhaw,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A sangaw nagtayuk hapa ya kadakalan na padi, kapye na naguhohug te Hesus. “Awan hud ta tabbag mu? Anu mantu ya uhohugam ta ipaliwat na duwa kiden teko?” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ammi awena la nagasitang ni Hesusen. A nagsitang ha ya padi en ta “Magsitang kan, a magpagasingan ka ta sigatolay na Dyos. Ibar mu mantu am iko ya Ari en nga Anak na Namaratu ewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","A ya tabbag hapa ni Hesus tentu a “A iko haman ya nangibar, ammi ibar ku hapa tekamuy ta makipaita sangaw ya Tolayin taga Langit nga makipagtuttud ta agtuttudan na Seppakapangwa ta Ngamin, te magtoli hala sangaw sin nga imatuttud ta kulam kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","“Agayaya!” kun na hapa na kadakalan na padi ta pakadangag na ta uhohug ni Hesus, kapye na pinissang ya salnuk na pagpadi na gafu ta katupag na en ta inuhohug ni Hesus. “Dulay ya uhohug na in, te igitta na haman ya bari na ta Namaratu ewan,” kunna. “A masapul hud para ya mangipasikkal ta liwat na awa ikitanan hapa la ya nakadangag ta uhohug na. ");
INSERT INTO agt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Anu mantu ya uray muy tentu?” kunna ha. “A mappya ta mapapasi!” kunda. ");
INSERT INTO agt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","A sangaw inuparan da ya mukat na en, yaga pinalpaluk da. A linaplappag na hapa na kadwan, kapye da ibar ta ");
INSERT INTO agt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“O Kristu, ibar mu am inya ya naglappag teko, te malalaki ka haman maglavun,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","A ta pagimbestigar da para la te Hesus a itta la i Pedru ta bagaw na bali en, te imatuttud la ten. A sangaw imabikan te Pedru ya takday babbay nga tagabu, a “Maski iko hapa ya takday kahulun ni Hesusen nga taga Galileya,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ammi nelemad na ta atubang na ngamin kiden nakadangag, “Amuk hud am anu ya ikayat mu uhohugan teyak,” kunna, ");
INSERT INTO agt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","kapye na sang umadayu tagad ta sasarokanen. Ammi itta hapa ten ya takday ha na babbay nga nakelasin tentu, a netuldu na i Pedru ta katayukan na kiden. “Yeyan hapa ya takday kahulun ni Hesusen taga Nasaret ta iten Galileya,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ammi nelemad na ha, “Pagasingan ta Dyos am amuk ya tolayina,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Awena para la nabayag a umabikan tentu ya kadwan kiden imatayuk ta iten, a “Talaga ta iko hapa ya takday kahulun na te italaba na ka na agbalikas mu,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","“Atsi O, pagasingan ta Dyos am tulad ya uhohug ku, awek malat amu ya tolayina,” kunna ha naglemad. A ka-ma la nagtareknay ya manuk, ");
INSERT INTO agt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","a yen hapa ya nepakanonot ni Pedru ta uhohug ni Hesus tentu, te “Mamillu ka mangilemad teyak ta awena para la pagtareknay na manuk,” kunna. A insigida nagtugut i Pedru en, a masikan nagtangit. ");
INSERT INTO agt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","A tentun araw a nagkakampat para la ya padi kiden ikid na pinakadakal na tolay kiden, a nagtatulagan da ya pasi ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","A sangaw ginalutan da kapye da neuhet, te enda idarum ta atubang ni Pilato nga gubernador nga taga Roma. ");
INSERT INTO agt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","A ta pakkamu ni Hudasen ta papasin da i Hesus a nebabawi na ya nepangitalaba na tentu, a netoli na ya piraken nga neatad na padi kiden ikid na pinakadakal kiden. ");
INSERT INTO agt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nakaliwatak, te netalabak haman ya awanen ta liwat,” kunna tekid. “A nekabat kami hud ta iningwam? Problemam yana,” kunda hapa tentu. ");
INSERT INTO agt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","A gafu ta kumanen a enna newarad ya pirak kiden ta umag na simbaanen, otturu enna ginalutan ya hul na en kapye na nagbesin. ");
INSERT INTO agt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","A ta nepakaakut dan ta pirak kiden a inalap na padi kiden, a “Anu mina ya pagserbi na inin? Te madi am metun ta pundo na simbaanin, te paga na daga na tolay,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","A tekid na nabalin nagbabida ta pangusar da ta piraken a enda negatang ta lutak na magdammili, petta itta ya ketanaman na tolay kiden nga taga adayu na lugar nga nasi ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","A gafu ta piraken nga negatang da ta lutaken a “Lutak na Daga” ya nangingaganan da ta lutaken. ");
INSERT INTO agt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","A kumanen nagdulot hapa ya nesurat na aglavunen mina Heremyas, te ya uhohug na en a “Inalap da ya tallufulu hukal na pirak nga nagtatulagan na Hudyo kiden ta gatad na angat na en, ");
INSERT INTO agt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","a negatang da ta lutak na magdammili en, te kumanen ya uray na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","A i Hesusen hapa a pinagtayuk da ta atubang na gubernadoren, petta imbestigaran na. “Anu, iko hud ya nebar da en nga Ari na Hudyo kiden?” kunna te Hesus, “A kompormi ya ibar mu,” kunna hud la ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","A addu hapa ya nepaliwat na padi kiden tentu ta gubernadoren, ammi awena pulus nagsitang ni Hesus ta pangpaliwat da tentu. A ya uhohug na gubernadoren te Hesus a ");
INSERT INTO agt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","“Anu awem hud madangag ya ngamin ipasikkal da ta liwat mu?” kunna hapa ni Pilato tentu. ");
INSERT INTO agt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ammi awena kad tumabbag maski ta takday la na uhohug, a pake nepagpaka-lat na gubernadoren. ");
INSERT INTO agt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","A ya gagangay na gubernadoren ta idi am araw na mayor na pyesta na Hudyo kiden a pohetan na ya takday mabalud nga pinili na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A ta nepangidarum da te Hesus a dana ittan ya takday nabalud nga magngagan te Barabas, a malalaki hapa namadday ta dulay ta idi. ");
INSERT INTO agt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","A gafu ta nagaammung na ya tolay kiden a pinohutan ni Pilato tekid am inya ya ikayat da mapohet. “Had sin mina ta duwa kidin ya ikayat muy ta pohetan ku? I Barabas ya ikayat muy, ono i Hesus nga magngagan hapa ta Kristu?” kunna. ");
INSERT INTO agt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","A yen ya nebar na ta tolay kiden nga nagaammung, petta damagan na tekid am inya ya ikayat da, te dana amu na ta nedarum na pinakadakal da kiden i Hesusen gafu ta katupag da tentu. ");
INSERT INTO agt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","A tentu en para la imatuttud nga magindag ta uray da a itta hapa ya enna nepadamag na atawa na en tentu. “Awem la mekabkabat ta panggakkad da ta tolayina nga awan ta liwat, te pake nazigatanak ta hiklamen gafu ta tarinap ku tentu,” kunna kan. ");
INSERT INTO agt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ammi ya padi kiden ikid na pinakadakal kiden a sinansanat da ya tolay kiden petta ipasikkal da ya pakauhet ni Barabas, petta i Hesus mina ya papasin da. ");
INSERT INTO agt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A sangaw pinidwa ni Pilato ya pohut na ta tolay kiden, “A anu ya uray muy ta duwa kidin, had sin mina tekid ya pohetan ku?” kunna ha tekid. “I Barabas!” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“A anu mantu ya uray muy te Hesusin nga magngagan te Kristu?” kunna ha ni Pilato tekid. A giaggayan kid na ta “Pagappam ta kayu,” pakakin kid. ");
INSERT INTO agt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Te anu hud, anu hud ya liwat na?” kunna hapa. Ammi pake giaggayan kid ha ta masikan ta “Pagappam ta kayu, pagappam ta kayu,” pagkin kid ha. ");
INSERT INTO agt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","A gafu ta awena mapagimmang ni Pilato ya tolay kiden, te yaga magtatapil kid na a nagpaalap ta palanggana na danum, kapye na binaggawan ya kamat na kiden ta atubang na tolay kiden. “Itan muy na, nabaggawan kun ya kamat ku kidin, petta amu muy ta awan ta liwat ku ta pasi na tolayin yan. Ikamuy hapa la ya makkamu tentu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","“Onay, ikami ikid na anak mi kiden ya makkamu ta pasi na,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","A gafu ta kumanen a pinohet na i Barabasen, a nepapaligat na i Hesus, kapye na negawat ta suddalu na kiden, petta enda pagappan ta kayu. ");
INSERT INTO agt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","A ta nepanggawat na suddalu kiden te Hesus a neange da bit ta umag na bali na gubernadoren, a sa nangkalihung hapa ya ngamin batalyon da. ");
INSERT INTO agt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","A inazi da ya salnuk ni Hesusen, kapye da nesalnuk tentu ya darag na ga-gamit nga kuman na salnuk na ari. ");
INSERT INTO agt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","A sangaw nangwa kid hapa ta sangngat na sit kapye da nesangngat ta ulu na en, yaga nepaibbal da tentu ya kulang na biraw petta kuman na baston na. A namalentud kid na ta atubang na en ta pamābānglu da tentu, a “Ihi, malalaki ya Ari na Hudyo kiden,” kun na kampon na dayaw da tentu. ");
INSERT INTO agt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","A ta nekabalin da en a inuparan da hapa, kapye da inalap ya biraw na en, a nepalpaluk da ta ulu na en. ");
INSERT INTO agt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","A tekid na nabalin a inazi da ya salnuk na en darag, kapye da ha netoli ya dana en salnuk na, a neuhet dan petta pagappan da. ");
INSERT INTO agt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","A tekiden nakauhet ta irwangan na ili a nesimmun da ya takday tolay nga nagngagan te Simon nga taga Sirene, a intun ya kinalbatan da nga pinagagtu ta pagappan ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","A ta datang da ta nengagan da en Golgota (intu hala kettayan na Balontok), ");
INSERT INTO agt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","a pinenum da i Hesusen ta binarayang nga kinihun da ta apdu, ammi tentu en nakakakkap a inawenan. ");
INSERT INTO agt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","A ta nekabalin na nepagpaappa da tentu a nagbabinunutan na suddalu kiden ya barawasi na kiden, ");
INSERT INTO agt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","a nagtuttud kid na nga naggwardya tentu. ");
INSERT INTO agt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Itta hapa ya nesurat da ta utun na ulu na en petta mebasa ya pangpapasin da tentu, “Ye-yan i Hesus nga Ari na Hudyo kiden,” kun na surat da, ");
INSERT INTO agt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","te itta hapa ya duwa na tulisan nga pinagappa da ta dwaakub ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A kada itta ya nagtalib ta nagappan ni Hesus a nelutab da ya pangidadula da tentu. ");
INSERT INTO agt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Agu ta itta ya pakapangwam nga mangkutukutet ta simbaanen kapyem ha patayukan ta las-ud na talluhaw?” kunda. “A ikerutam mantu ya barim ta pakapangwamina,” kun na kadwan. “A am gagangay ta iko ya Anak na Namaratu a dumagut kan mantu ta krusina,” kunna hapa na kadwan. ");
INSERT INTO agt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tumubbat hapa mangidadula tentu ya padi kiden ikid na mangituldu kiden ikid na kadwan kiden pinakadakal na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Intu kan ya nangikerutan ta kadwan, ammi awena mekerutan ya bari na en,” kun na kadwan. “Intu pon ya Ari na Istralita kiden, a mappya mantu ta dumagut na ta krus, petta itta mina ya pangurugan tam tentu,” kunna hapa na kadwan. ");
INSERT INTO agt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Nekatalak na kan ya Namaratu. A am itta ya pangkenga na Namaratu tentu a ikerutan nan mina, te ‘Iyak ya Anak na Namaratu,’ kunna paen,” kunna para na kadwan. ");
INSERT INTO agt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","A kumanen hapa ya pangidadula na tulisan kiden tentu nga pinagappa da ta dwaakub ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","A tentun pagtangnganan na araw a nagsugiram na ya ngamin na paglelehut da en ta kuman na hiklam abat ta tallu na oras. ");
INSERT INTO agt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A ta mekatallu en na oras a nagayag i Hesus ta masikan, “Ilay, Ilay, lama sabaktani,” kunna ta agsitang na Hudyo kiden. A ya ikayat na uhohugan na ayag na en a “Dyos ku, Dyos ku, anu haman ta nagtalekudan nak,” kunna. ");
INSERT INTO agt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","“Anu, ayagan na de i Eliyas?” kunna hapa na kadwan kiden nga nagbuya tentu. ");
INSERT INTO agt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","A alistu nagbilag ya takday tekid nga ange nangalap ta kuman na ga-gamit, kapye na tinunan ta suka, a sangaw nesukil na ta ud na biraw te Hesus petta inuman na mina. ");
INSERT INTO agt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ammi ya nebar na kadwan kiden a “Awem bit la, te itan tam la bit am enna sangaw ikerutan ni Eliyasen,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A sangaw nagayag ha i Hesus ta masikan, a yen hapa ya nepakasukkut na kahalwa na. ");
INSERT INTO agt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","A negindan hapa napissang ya zingzingen nga ga-gamit ta umag na simbaan en. Namegafu napissang ta utun abat ta akban. A naglunig hapa ya lutak abat ta nakassib ya batu kiden, ");
INSERT INTO agt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","yaga nahukatan hapa ya tanam kiden, te natolay hala ya addu na nagpasi kiden nga nangurug ta Namaratu ta palungu araw, a imuhet kid ta tanam da kiden. ");
INSERT INTO agt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","A sangaw ta nekatolay hapa ni Hesus a umange kid ta ili na Herusalem, a nakipaita kid ta addu na tolay ten. ");
INSERT INTO agt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ammi ta nepasi ni Hesus ta nagappan na en a itta hapa ya takday kapitan ikid na sakā suddalu na kiden nga nagtaron ta pasi na. A tekid na hapa nakaita ta lunigen, ikid na ngamin kiden napadatang, a pake nagtalaw kid na, “Kakurugan kad ta Anak na Namaratu yan,” kunda. ");
INSERT INTO agt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A ta medyo adayu ta nagappan ni Hesus a itta hapa ya addu na babay nga mangita tentu, te ikid ya dana kahulun na kiden tentu en nagafu ta lugar na Galileya, te inuffunan da. ");
INSERT INTO agt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","A nehulun hapa tekid i Mariya Magdalena, ikid ni Mariya nga hina nig Santiago ikid ni Hose, ikid na atawa ni Zibadeyu. ");
INSERT INTO agt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","A itta hapa ya takday ituldu ni Hesus nga naba-nang nga nagngagan te Hose, a taga ili na Arimateya. ");
INSERT INTO agt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A ta furab ta nepasi ni Hesusen a umange i Hose ta bali ni Gubernador Pilato, a inadang na ya bari ni Hesus petta itanam na, a nebar ni Pilato ta meatad hala tentu. ");
INSERT INTO agt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","A inalap na mantu ya bari na en, a finutefutan na ta bagu na furaw na ga-gamit, ");
INSERT INTO agt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","otturu enna netanam ta kababagu na tanam nga nakali ta batu ta kuman na kweba. A sangaw nadokalig na ya dakal na batu ta irwangan na tanamen petta namunitan, a sangaw nagtugut. ");
INSERT INTO agt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ammi pa nasirak bit ten ig Mariya Magdalena ikid na takdayen Mariya, te umatuttud kid ta bikat na tanamen. ");
INSERT INTO agt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A ta lalakwat ta Sabadu a umange ya padi kiden ikid na Pariseyu kiden ta bali ni Pilato gafu ta ibar da tentu. ");
INSERT INTO agt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Itta ya nanonot mi, Ser, te ya takday para na tulad na nagtuladen ta katolay na para la en, a ‘Matolayak hala sangaw ta kabalinan na talluhaw,’ kunna kan. ");
INSERT INTO agt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","A mappya mantu ta mangidob ka mina ta maggwardya ta tanam na en abat ta mekatallu araw, petta awena sangaw makaange na ituldu na kiden nga magtakaw ta bari na en. Te am ‘Natolay hala ya nasi en,’ kunda sangaw ta tolay kiden a pake dulay sangaw ya tulad da ammi ta tulad na dafu da en,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“A aran ay, mangalap kam mantu ta suddalu kiden, a paggwardyan muy kid ta kustu na paggwardya,” kun ni Pilato tekid. ");
INSERT INTO agt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","A ta nepangalap da ta suddalu kiden a umange kid ta agyan na tanamen, a dinirkatan da ya nelitupen batu ta tanamen, petta maita sangaw am maazi ya batu en, a nesirak da hapa ya suddalu kiden nga maggwardya. ");
INSERT INTO agt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","A ta nekabalin na araw na agimmang na Hudyo kiden ta pagkarawan ta Liggu a umange ig Mariya Magdalena ikid na takdayen Mariya ta tanam ni Hesusen. ");
INSERT INTO agt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ammi dana itta ya masikan na lunig, te umangen ya takday na anghel na Namaratu nga nagafu ta langit, a dinokalig na ya batu en nga nelitup ta tanamen kapye na nagtuttudan. ");
INSERT INTO agt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kuman na kaitan na kilat ya bari na anghelen, a awan ta pangiduman na furaw na barawasi na en. ");
INSERT INTO agt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","A ya suddalu kiden hapa nga nanggwardya a nagapilpilpig kid hapa ta talaw da en ta anghelen, a nagkapedda kid na ta kuman na pagpasi da. ");
INSERT INTO agt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A ta datang na babay kiden a itta para la ya anghelen a “Awemuy la magtalaw,” kunna, “te amuk ta apagan muy i Hesusen nga pinagappa da, ");
INSERT INTO agt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ammi awan na sin, te natolay hala ta kuman na nebar na en tekamuy. Maski e kanan sin, te itan muy ya nagiddan na bari na en. ");
INSERT INTO agt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","A alistu kam sangaw magtoli ta ituldu na kiden, te ibar muy sangaw tekid ta natolay hala ya nasi en, a maita da sangaw ten Galileya, te mapmapolu ammi tekid. Aranan, te yen la ya ibar ku tekamuy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","A alistu kid na nagtugut ta tanamen ta talaw da en, ammi nekihu hapa ya dakal na talak da. A nagbilag kid na ange nangipadamag ta ituldu na kiden, ");
INSERT INTO agt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ammi ka-ma la itta i Hesus ta atubang da, te nesimmun na kid ta dalanen. “O ey, itta kanan,” kunna tekid. A enda inahakupan ya takki na kiden, a dinayawan da. A ya uhohug na hapa tekid a ");
INSERT INTO agt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Awemuy la magtalaw, te emmuy ibar ta kabagis ku kiden ta e kid mina ta iten Galileya, te maita dak sangaw ten,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","A ta nepagtugut na babay kiden a nagtolin hapa ya kadwan kiden naggwardya ta ili, te enda nedanug ta padi kiden ya naita da ta agyan na tanamen tekiden naggwardya. ");
INSERT INTO agt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","A gafu ta kumanen a nagkakampat ha ya pinakadakal na Hudyo kiden kontodu naggwardya kiden, a nagbabidan da ya uray da. A nagtatulagan da ta maatadan ya naggwardya kiden ta pirak petta magtulad kid. A nebar da tekid ya bidan da sangaw ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“‘Umange ya ituldu na kiden ta hiklam, a netammang da ya bari ni Hesus tekami en nagkasidug,’ kummuy tekid. ");
INSERT INTO agt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","“A am angarigan ta madamag sangaw na gubernador ta nasidug kam ta nepaggwardya muy a ikami hala sangaw ya makkamu magbida tentu, petta awan sangaw ta dulay tekamuy,” kunda tekid. ");
INSERT INTO agt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","A inalap da mantu ya piraken a enda nepadangag ya kuman na netuldu na padi kiden tekid. A ye-yen na bida ya isansaned na Hudyo kiden ta ngamin kiden lugar na sakā Hudyo da kiden maski abat ta ayanin. ");
INSERT INTO agt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A ya mafulu takday kiden na ituldu ni Hesus a umange kid hala ta lugar na Galileya ta nebar na en bagetay nga pangdafungan na tekid. ");
INSERT INTO agt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","A tekiden nakaita tentu a namalentud kid na nga nangdayaw tentu. Ammi ta kadwan a aweda kurugan ta intu in yen. ");
INSERT INTO agt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","A ya uhohug ni Hesus tekid a “Iyak ya nagitunan na Namaratu ta ngamin makkwa ta langit ikid na lutak. ");
INSERT INTO agt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","A ta ayanin a doban ta kanan, te e kam sangaw ta ngamin tolay ta ngamin paglelehutin petta magalap kam ta dagga na itulduk kidin. Zigutan muy sangaw ya mangurug petta mesipat kid tekami ni Damakewan ikid na Kahalwa na en. ");
INSERT INTO agt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","A sage ituldu muy kid hapa petta kurugan da hapa ya ngamin nepatarabakuk tekamuy. A nonotan muy yan: sigida itta yak la tekamuy nga mehulhulun abat ta pagaddetan na arawin yan,” kunna.");
INSERT INTO agt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Ya fun na Bida ni Hesus Kristu nga Anak na Namaratu ewan a intu yan ta kuman na nesurat na aglavunen mina Isayas: “Ya uhohug na Namaratu ta Anak na en a ‘Dangagam, Anak ku, te itta sangaw ya doban ku nga mapmapolu ammi teko, te intu sangaw ya mangipadangag ta iangem,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Te ya nebar na en mapmapolu a makipaita sangaw ta kawanan na babali, a iayayag na sangaw ya tabarang na ta tolay kiden, petta makaparan kid mina ta datang na Dafu tamen, petta malogon mina ya iange na tekid,” kun na surat ni Isayas. ");
INSERT INTO agt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","A gafu ta kumanen a nakipaita hala ya binida ni Isayasen ta kawanan na babali, a intu hala i Hwan nga nangzigut ta tolay kiden, a kinasaba na kid. “Ulin muy ya gagangay muy a zigutan ta kanan, petta pakoman na Namaratu ya liwat muy kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","A umange tentu ya addu na tolay taga ili na Herusalem, ikid na ngamin kiden lugar ta Hudeya. A dana nebosag da ya liwat da kiden, kapye na kid zinigut ta karayan na Hurdan. ");
INSERT INTO agt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","A ya gagangay ni Hwan a nagbarawasi ta pinadday na en nga nagafu ta dutdut na kamelo, a sebarekas hapa ta la-las. A intu la kanan na ya dudun ikid na tahu na kalaba. ");
INSERT INTO agt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A ya nepadangag na para a “Itta sangaw ya ange ta gafan ku nga pake malmalalaki ammi teyak, te maski la awek megitta makitagabu tentu nga mangubad ta sapatos na kiden. ");
INSERT INTO agt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Te maski zinigut ta kam ta danumin, a intu sangaw ya mangpasinap tekamuy ta Kahalwa na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A ta arawin yen hapa la a nagganwat hapa i Hesus ta agyan na en ten Nasaret ta lugar na Galileya, a dumatang hapa ta karayan na Hurdan, te umange hapa pazigut te Hwan. ");
INSERT INTO agt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","A ta nepakagon ni Hesus ta danumen a naita na ta bimangrit ya langit, a nagsunak ya Kahalwa na Namaratu ta kuman na kalapati, a nagpotun na tentu. ");
INSERT INTO agt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A nepagka-ma na hapa kan ya naguhohug tentu ta langit: “Iko ya Anak ku nga matakit ta nonot ku. Pake matalakanak teko,” kunna kan. ");
INSERT INTO agt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","A ta nekabalin ni Hesus nagzigut a pinagtugut na Kahalwa na Namaratu, petta ange tatakday ta bagbagetay kiden nga adayu ta tolay. ");
INSERT INTO agt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A nagyan la ten abat ta appatafulu araw, a nekihkihu ta magdaduma na ayam nga simaron ikid na maporay. A yen hapa ya neange ni Satanas tentu, petta paruban na, ammi ta nekabalin ni Satanas tentu a umange hapa ya anghel kiden nga manguffun te Hesus petta magsikan. ");
INSERT INTO agt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","A sangaw ta nekebalud ni Hwanen a dumatang ha i Hesus ta agyan na ta iten Galileya petta mangipadangag ta damag na Namaratu; ");
INSERT INTO agt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Ayanin ya pamegafu na pangikerutan nga binida na aglavun kiden, te ittan ya dafu muy nga nekari na Namaratu. Ulin muy mantu ya gagangay muy, a kurugan muy na ya ipadangag kun tekamuy nga mappya,” pakakin. ");
INSERT INTO agt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A tentu en nagtugtugut ta pingit na Alug na Galileya a nesimmun na ig Simon ikid na kabagis na en Andres, a magtahukul kid na ta alugen te dumatahukul kid ta ikan. ");
INSERT INTO agt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","“Dumagdag kanan hala teyak, te ituldu ta kam petta dumatahukul kam sangaw ta tolay,” kun ni Hesus tekid, ");
INSERT INTO agt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","a insigida newagak da ya tahukul da, a dumagdag kid na. ");
INSERT INTO agt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A tekiden nagdulot nagtugtugut ta ba-naden a naita ni Hesus ig Santiago ikid na kabagis na en Hwan nga anak ni Zibadeyu ta barangay da en, a magpakappya kid ta tahukul da kiden. ");
INSERT INTO agt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","A insigida inayagan na kid, a newagak da ya dama da en kontodu tagabu na kiden ta barangayen, a dumagdag kid na hapa, a sa nagdulot kid na ta ili na Kapernayum. ");
INSERT INTO agt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","A tentu en araw na agimmang a umange kid nakigimung ta kapilya en, a nangituldu hapa i Hesus. ");
INSERT INTO agt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ammi nakagtut hapa ya tolay kiden ta gagangay na pangituldu na, te awena pinarigan ya mangituldu kiden ta relisyon da awa nangituldu ta kuman na intu ya makkamu ta ngamin. ");
INSERT INTO agt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","A tentu para la nangituldu a ka-ma la kimahalwan hapa ya takday lalaki ta umag na kapilya en gafu ta anitu na en; “O, Hesus taga Nasaret, anu itta ka sin tekami? Amu ta ka, te iko ya kagitta na Namaratu ewan. Yen hud ya umeyam sin petta pakākāllakan na kami?” kunna. ");
INSERT INTO agt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ammi nehuya ni Hesus ya anitu na en ta “Awem la magsitang, a pagtugutām na ya tolayina,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A nagganwatan na anitu en ya lalaki en pinagbalyad, kapye na hapa kimahalwan ta pagtugut na tentu. ");
INSERT INTO agt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A pake nakagtut ha ya tolay kiden ta iningwa ni Hesus, a “Anu panaw ye-yan O? Takwan ya ituldu na inin, te mangituldu seturay, yaga kurugan na anitu kiden am patugutan na kid,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A gafu ta kumanen a insigida sumaned ya damag ni Hesus abat ta ngamin kiden babali ta lugar na Galileya. ");
INSERT INTO agt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","A ta nepagtugut nig Hesus ta kapilya en a umange kid ta bali nig Simon ikid ni Andres, a dumagdag hapa ig Santiago ikid ni Hwan. ");
INSERT INTO agt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A ta datang da ta bali na en a neddatangan da ya katahungan ni Simon nga babbay nga imaidda, te nagpatu, a nebar da hapa te Hesus. ");
INSERT INTO agt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A enna ginafut ni Hesus ya kamat na en pinatayuk, a yen hapa ya nepagkamag na patu na en, a enna kid hapa nepagafuy. ");
INSERT INTO agt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","A ta marimaten a itta hapa ya nagdadatang ta bali da en nga ange nangikahad ta seanitu ikid na magtatākit. ");
INSERT INTO agt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A sa kumalihung ya ngamin kiden umili ta lugar na irwangan na bali en. ");
INSERT INTO agt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A addu ya pinagmappya ni Hesus ta magdaduma na takit, yaga pinatugut na hapa ya addu na anitu na seanitu kiden, ammi sinanat na kid nga maguhohug, te amu da ta intu ya Anak na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","A ta lalakwat a nagkarawan i Hesus nga imivwat, a umange la tatakday ta awan ta totolay, a pa nagyan ten nakimallak. ");
INSERT INTO agt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A ta nekahukal nig Simon a awan i Hesusen, a enda inapag. ");
INSERT INTO agt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","A tekid na nakaapag tentu a “Anu itta ka sin, Afu? Itta haman ya addu na tolay makaapag teko,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A ya tabbag na tekid a “On ay, ammi magdulot kitanan ta kadwan kiden babali, te mappya ta yen kid hapa na lugar ya pangipadangagan ku, te yen ya gafu na umeyan ku ta isin,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A gafu ta kumanen a sinaned da ya ngamin kiden babali ta lugar na Galileya, a nangipadangag i Hesus ta kapilya da kiden, yaga pinatugut na hapa ya anitu na seanitu kiden. ");
INSERT INTO agt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","A sangaw itta ya takday lalaki nga naggalis, a umange namalentud ta atubang ni Hesus; “Ay, Afu, ikallak nak haen, te amuk ta maurum ya tabbit kin am ikayat mu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","A gafu ta timalin ya allak ni Hesus tentu a neuyad na ya kamat na en nesi-ged ta lalaki en, a “Ikayat ku hapa, itam awa malinis na ya tabbit mina,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A ka-ma la imawan ya galis na en, a pake nalinis na ya tabbit na en. ");
INSERT INTO agt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","A ta nepagpatugut ni Hesus tentu a pake nebar na ta awena sangaw bidan. ");
INSERT INTO agt_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Itam ta awan ta pangibibidam ta isin, ammi em ipaita ya barim ta padi en ta simbaanen petta maita na ta awan ya galis men, a iatad mu hapa tentu ya iatang na ta kuman na nebar ni Moses ta lintigen, te yen sangaw ya mangipasikkal ta tolay kiden ta pagmappyam,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ammi tentu en nagtugut a pinegafwanan na hala nepadangag ya pagpamappya ni Hesus tentu, a yen ta awenan nakasarok ni Hesus ta ili kiden gafu ta kaddu na tolay kiden. A nagyan mantu la ta adayu ta babali kiden, ammi umange hala tentu ya tolay kiden nga taga ngamin kiden lugar. ");
INSERT INTO agt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","A naba-bayag ta assang a dumatang ha ig Hesus ta ili na Kapernayum, a nadamag na tolay kiden ta ittan ha ta nagyanan na en bali. ");
INSERT INTO agt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","A ta magananwan la a pake umaddun ya tolay kiden nga nagaammung ta umag na bali en abat ta awan ta ketunan na kadwan kiden maski ta bikat na irwangan, a nepadangag ni Hesus ya uhohug na Namaratu tekid. ");
INSERT INTO agt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","A itta hapa ya enda nekahad tentu nga awan makahehit nga inisaw na appat na lalaki, ");
INSERT INTO agt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ammi aweda garay neabikan te Hesus gafu ta kaddu na tolay, a yen ta negon da ta addanen nga ange ta atap na bali en. A sangaw inazi da ya assang la ta atapen ta annung ni Hesus, kapye da neuhiyay ya awanen makahehit ta umag na bali, a netabnak da ta bikat ni Hesusen. ");
INSERT INTO agt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","A ta nepakaita ni Hesus ta pangikatalak da tentu a naguhohug hapa ta awanen makahehit; “Aleng, pakoman kun ya liwat mu kiden ta Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ammi ya kadwan kiden nga mangituldu ta relisyon na Hudyo kiden nga gituttudan hapa ta umag na bali a linibakan da hapa ya inuhohug ni Hesus ta nonot da hapa la. ");
INSERT INTO agt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Anu haman ta uhohugan na ya kumanen bakawa Namaratu hud. Dulay mantu yan te ugtulān na haman ya turay na Namaratu,” kun na nonot da. ");
INSERT INTO agt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ammi narikna ni Hesus ya nonot da, a “Anu haman ta libakan muy ya inuhohug ken? ");
INSERT INTO agt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Had sin hud ya malmalogon, am pakoman ku ya liwat na kiden, ono am pagmappyan ku petta makatugut? ");
INSERT INTO agt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ammi itta hapa ya ibar ku ta awanin makahehit petta itta sangaw ya pakaitan muy ta itta hapa ya turay na Tolayin taga Langit nga mangpakoma ta liwat na tolay kiden,” kunna tekid, ");
INSERT INTO agt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","otturu naguhohug ha ta awanen makahehit; “Imivwat kan, Aleng, te alapam na ya pagiddamina a dumatang kan ta balim,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A imivwat kad, a inalap na ya dapan na en kapye na nagtugut ta atubang da ngamin. A pake nagpaka-lat hapa ya tolay kiden ta pagmappya na, otturu dinayawan da ya Namaratu. “Nabayag kitanan sin a ayanin la ya pakaita tam ta kumanin,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A sangaw ta mittan a umange i Hesus ta pingit na alugen, a dumadagdag hapa ya pake addu na tolay nga mangkalihung tentu, a netuldu na kid hapa. ");
INSERT INTO agt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A tentu nabalin nangituldu a nagtugut ha, a nasimmu na hapa ya takday agsingir ta bwis nga imatuttud ta lugar na pagpagan na tolay kiden ta bwis da. I Lebi anak ni Alfeyo ya ngagan na. A ta pagtalib ni Hesus tentu a “Dumagdag kan teyak, petta magbalin ka ta itulduk,” kunna tentu, a imikkat hala nga dumagdag tentu. ");
INSERT INTO agt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","A sangaw itta kid na ta bali ni Lebi en, a sa magkakan kid. A itta hapa ya addu na agsingir ta bwis ikid na dulay na tolay, a sakā makikkanan kid hapa teg Hesus kontodu ituldu na kiden, te addu kid nga imanghulun tentu. ");
INSERT INTO agt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","A ta pakaita na Pariseyu kiden ta nakikkanan hapa i Hesus ta agsingir ta bwis ikid na dulay na tolay, a linibakan da hapa, ammi ya ituldu na kiden ya nangibaran da; “Anu makikkanan hapa ya mistro muy ta agsingir kiden ta bwis ikid na dulay na tolay?” kunda. ");
INSERT INTO agt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ammi nedangagan na kid ni Hesus, a intu ya tumabbag tekid: “On ay, te gagangay haman ta ange ya manguru en ta agyan na magtakit kiden, te yen haman ya makaapag tentu. A bakkan ta yen ya umeyan ku sin petta padagdagan ku ya awanen ta liwat am awa seliwat kiden talo am magbabawi kid,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","A sangaw itta ya umange nangpohut te Hesus gafu ta ituldu na kiden. “Anu kawagan na, Afu, ta awena ngilinan na ituldum kiden ya araw na awan pangan ta kuman na Pariseyu kiden ikid na ituldu kiden ni Hwan,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A ya tabbag hapa ni Hesus tekid a “Mabalin hud ta magdamdam ya makiboda kiden am itta para la tekid ya magboda en? Gagangay ta makikkanan kid la tentu ta ketta na en para la tekid. ");
INSERT INTO agt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Itta la sangaw ya araw am metugut tekid, a yen sangaw ya pagngilin da ta araw nga aweda pangan gafu ta damdam da tentu,” kunna. A nebar na hapa ya kuman na keangarigan tekid petta aweda mina pagdadaggan ya dana kiden gagangay da ikid na ituldu na. ");
INSERT INTO agt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Am angarigan ta napispissang ya dana en barawasi muy a awemuy haman pissangan ya bagu en ga-gamit petta itta ya itakup muy ta dana en, te kenga sangaw ya bagu en, otturu mapissang ha sangaw ya dana en barawasi muy am kumbat ya takup na en,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“A kumanen hapa ta basi muy, te awemuy haman ikarga ya bagu na basi ta dana na abyat, te am bumlad ya basi en a mabattak ya abyaten, otturu meburud hapa ya basi en. Mapmappya ta mekarga ya bagu na basi ta bagu na abyat petta azo mabayag kid,” kunna ha. ");
INSERT INTO agt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","A sangaw ta mittan a magtugtugut ig Hesus ikid na ituldu na kiden ta tātangngan na kamaitan ta araw na agimmang, a nagpusit hapa ya ituldu na kiden ta angen da. ");
INSERT INTO agt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ammi gafu ta naita na kid hapa na Pariseyu kiden a ipahuya da kid hapa te Hesus. “Itam ya ituldum kidina, anu awem kid ihuya, te magtarabaku kid haman ta araw na agimmang,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A ya tabbag na hapa tekid a “Annun ku kid ihuya, te intu la kwan da ya kuman na iningwa ni mina Dabiden ikid na kahulun na kiden ta kawan na kanan da, ");
INSERT INTO agt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","te simarok kid ta bali na Namaratu ta nepagpadi ni mina Abyatar, a inalap da hapa ya pan kiden nga nedasar ta atubang na Namaratu nga mehangat mina tekid, te kanan hala na padi kiden. Ammi maski kunna ten a bakkan haman ta nakaliwatan da yen. ");
INSERT INTO agt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A ya takday para ibar ku tekamuy a netunglak na Namaratu ya araw na agimmang petta magserbi ta tolay, te bakkan ta tolay ya magserbi ta araw na agimmang. ");
INSERT INTO agt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","A ya Tolayin nga taga Langit ya makkamu ta araw na agimmang,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","A sangaw ta mittan a umange i Hesus nakigimung ta kapilya na Hudyo kiden ta araw na agimmang. A gafu ta itta hapa ten ya takday lalaki nga pake nagpilay ya takday kamat na, ");
INSERT INTO agt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","a aitan da bit i Hesus talo am pagmappyan na ya kamat na en, te am pagmappyan na ta araw na agimmang a yen sangaw ya pangidaruman da tentu. ");
INSERT INTO agt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A ya uhohug ni Hesus ta lalaki en a “Magtayuk kan ta tangnganina,” kunna, ");
INSERT INTO agt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","kapye na naguhohug hapa ta nagilalap kiden tentu; “A anu hapa ya uray muy ta ipalubus na Namaratu ta araw na agimmang? Intu ipalubus na ya mappya ono dulay? Mappya panaw ta magpamappya kitam ono magpapasi kitam?” kunna tekid. Ammi aweda la nagasitang. ");
INSERT INTO agt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A init-ita na kid la ta pagporay na tekid, te madamdam hapa gafu ta pagtuyag na nonot da, otturu naguhohug ha ta lalaki en. “Uyadam la ya kamat mina,” kunna, a tentu en nanguyad a negitta ta takdayen kamat na nga mappya. ");
INSERT INTO agt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","A gafu ta kumanen a alistu imuhet ya Pariseyu kiden ta kapilya en, te umange kid nakibidan teg Herud, petta pagtatahatun da am had kunna mina na pangpapasi da te Hesus. ");
INSERT INTO agt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","A gafu ta kumanen a nagtugut hapa i Hesus kontodu ituldu na kiden, a umange kid ta tagad ta alugen, a dinadagdag na kid hapa na pake addu na tolay nga taga Galileya. ");
INSERT INTO agt_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Umange hapa tentu ya awan bababang na tolay taga Hudeya, ikid na ili na Herusalem, ikid na Idumeya, ikid na dammang na karayan na Hurdan, ikid na lugar na Tiro ikid na Sidon, te nadamag da ya ngamin tinarabaku na. ");
INSERT INTO agt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A gafu ta kaddu na tolay kiden nga umab-abikan te Hesus a “Iparan muy bit ya barangayen talo am malipitak ta tolay kiden,” kunna ta ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","te kuga addu na tolay ya pinagmappya na, a addu para ya nagtatākit nga simalsal tentu petta si-gedan da ya bari na en. ");
INSERT INTO agt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","A ya seanitu kiden hapa a ka-ma kid la nagtakab ta atubang na en nga kimahalwan, “Iko ya Anak na Namaratu,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ammi nehuya na hapa ya anitu da kiden petta aweda ipakamu ya ngagan na. ");
INSERT INTO agt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A sangaw gimon i Hesus ta agyan na bagetay kiden, a pinahulun na hapa ya kadwan kiden tolay nga ikayat na ta kahulun na, a dumagdag kid. ");
INSERT INTO agt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A pinili na ya mafulu duwa tekid, petta kanayun magyan kid tentu, a yen kid hapa ya dinob na ange mangipadangag ta uhohug na. ");
INSERT INTO agt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","A pinasinapan na kid hapa ta pakapangwa na petta itta ya mabalin da nga magpatugut ta anitu na seanitu kiden. ");
INSERT INTO agt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A ya ngagan na mafulu duwa kiden a i Simon nga nengagan na te Pedru, ");
INSERT INTO agt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","a ig Santiago ikid ni Hwan nga anak ni Zibadeyu, ammi Bwanergis ya nangingaganan na tekid, te ikayat na uhohugan ta kuman kid na dalak. ");
INSERT INTO agt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","A itta hapa i Andres, ikid ni Felipe, ikid ni Bartolome, ikid ni Matyu, (intu hala i Lebi), a i Tomas, ikid na takday Santiago nga anak ni Alfeyo, ikid ni Tadyo, ikid ni Simon nga kahulun na nakitapil kiden ta gubyernu na taga Roma kiden, ");
INSERT INTO agt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","a i Hudas Iskaryote nga mangitalaba sangaw te Hesus. ");
INSERT INTO agt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A ta nekabalin na kumanen a dumatang ha ig Hesus ta nagyanan na en bali, a imaddu ha ya tolay kiden nga nagaammung ta bali addet ta awena matagop nig Hesus ya mangan. ");
INSERT INTO agt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","A ta pakadangag nig hina ni Hesus ta pakolangan na la ya mangituldu a naggaganwat kid nga ange tentu, petta gamman da mina, te pahig da ta magamamangaw. ");
INSERT INTO agt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","A ya uhohug na mangituldu kiden hapa nga taga Herusalem a “Itta malat ya Satanas tentu nga mayor na anitu kiden, a yen ta itta ya mabalinan na nga magpatugut ta anitu,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ammi pinaabikan na kid ni Hesus hapa petta pake madangag da ya tabbag na ta uhohug da. “Mabalin hud ta Satanas ya magpatugut ta sakā anitu na kiden?” kunna tekid, otturu nepasikkal na para ta keangarigan. ");
INSERT INTO agt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Am angarigan mina ta makikattway ya tolay kiden nga makitapil ta gubyernu a awena hud sangaw maperdi na gubyernu da? ");
INSERT INTO agt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","A am makikattway ya makipagyan kiden ta takday na bali a maperdi hapa ya pagkakahulun da. ");
INSERT INTO agt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","A kumanen hapa te Satanas, te am patugutan na ya sakā anitu na kiden a nakikattway kid na, a naperdin ya patarabaku na en tekid, te yen la ya pagaddetan na. ");
INSERT INTO agt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Killu mantu ya nonot muy, te ya kakurugan a awan ta makagubat ta ibbalan ni Satanas am bakkan la ta masmasikanen ammi tentu, te yen na sangaw ya mangabak tentu petta gubatan na ya ibbalan na en,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","A gafu ta nepagsil da ya mayor na anitu kiden ta Kahalwa na Namaratu a pake nepasikkal na ya liwat da; “Kakurugan ya uhohug ku tekamuy ta maski am anu ya liwat na tolay ikid na pamadpadulay na ta sakā tolay na kiden a mabalin mapakoma, ammi ya mamadpadulay ta Kahalwa na Namaratu a awena pulus mapakoma, te nakaliwat ta magnayun na liwat,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","A ta datang nig hina na en ikid na kabagis na kiden a nagindag kid ta bagawen, te nangidob kid ta ange magayag tentu. ");
INSERT INTO agt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A gafu ta addu ya kumalihung kiden tentu a nebar da hapa tentu; “Itta kan ta bagaw ig hinam ikid na kabagis mu kiden, te apagan da ka kan,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ammi ya tabbag na tekid a “On ay, ammi inya hud ig hinak ikid na kabagis ku kiden am bakkan ta isin kid hapa,” kunna, ");
INSERT INTO agt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","a nesaned na netuldu ya kahulun na kiden ta umag na bali, “Yeyan kid hapa ig hinak ikid na kabagis ku, ");
INSERT INTO agt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","te maski am inya ya mangidulot ta ikayat na Namaratu ewan a yen ya kabagis ku ikid ni hinak,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","A sangaw ha ta mittan a namegafu i Hesus mangituldu ta pingit na alugen, a magananwan la a itta ya pake addu na tolay kumalihung tentu. A gafu ta kaddu da a gimon na ta selayag kapye na ha nagtuttud, a nagyan hapa ya tolay kiden ta pingit na alugen magdangag. ");
INSERT INTO agt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A addu hapa ya netuldu na tekid ta keangarigan, a kumanin ya takday netuldu na: ");
INSERT INTO agt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Dangagan muy yan,” kunna, “Itta ya umange nagpurwak, ");
INSERT INTO agt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","a nehunnak ya kadwan kiden hukal ta dalan, ammi enna kid inafut na mamanuk kiden. ");
INSERT INTO agt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A nehunnak hapa ya kadwan kiden ta kabatunen nga nebagbagtu ya lutak na, a alistu kid nagtatuhu gafu ta awan ta pake gimafutan na ramut da. ");
INSERT INTO agt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","A sangaw ta kasikan na bilag a nagladdag kid te awan ta nagramutan da, a nagkatang kid na. ");
INSERT INTO agt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A ya kadwan para hukal a nehunnak kid natungradanen gahut, a negindan ya hukal kiden ta pagtuhu na gahut kiden, ammi tinappanan na gahut kiden ya tuhu na hukal kiden pettam kumanen awedan makapagmayan. ");
INSERT INTO agt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A ya kadwan kiden hukal a nehunnak kid ta mappya na lutak, a yen kid ya pake dumakal ikid na nakapagmayan, te itta ya nagdawa ta magatut, a itta hapa ya nagdawa ta annamafulu, a nagdawa hapa ya kadwan ta tallufulu. ");
INSERT INTO agt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“A am kakurugan ta itta ya bangbang muy a mappya ta pake dangagan muy ya bidan kin tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","A tentu en tatakday a umange tentu ya kadwan kiden ituldu na nga nehulun ta mafulu duwa kiden, te enda pinohutan am anu ya ikayat na uhohugan ta keangarigan na en. ");
INSERT INTO agt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A ya nebar na tekid a “Mappya te ikamuy ya pinili na Namaratu petta amu muy ya gagangay na pangikerutan na ta tolay kiden, ammi ta kadwan kiden a nelemad na tekid petta intu la madangag da ya keangarigan. ");
INSERT INTO agt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","A yen ta nagbida yak tekid ta keangarigan, te maski am itta ya mata da a aweda haman maita ya mepaita tekid, a maski am itta ya bangbang da a aweda pake maawatan ya mepadangag tekid, te am maawatan da mina a magbabawi kid mina petta pakoman na kid na Namaratu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","A ya nebar na para tekid a “Am awemuy mantu amu ya ikayat na uhohugan na keangarigan na nagpurwak a pake ipasikkal ku petta amu muy sangaw ya pagbalinan na kadwan kiden keangarigan nga mebida sangaw tekamuy. ");
INSERT INTO agt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A ya umange en nagpurwak a yen ya mangipadangag ta uhohug na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A ya dalanen nga nehunnakan na kadwan kiden hukal a yen ya keangarigan na makadangag ta uhohug na Namaratu, ammi gafu ta aweda itug ya madangag da a ange i Satanas tekid a tabtabangan na ya nadangag da en petta kaliwatan da. ");
INSERT INTO agt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","A ya kabatunen nga nagtuhun na kadwan kiden hukal a yen ya keangarigan na makadangag ta uhohug na Namaratu, a alistu kid hapa mangurug ta talak da. ");
INSERT INTO agt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ammi gafu ta aweda pake itug ya madangag da en a awena la mabayag na pangikatalak da, te sangaw am itta ya pagzigātān da ono mangikatupag tekid gafu ta uhohugen nga nekatalak da a alistu kid hapa magtabeng, te kuman na ikazigman da ya nekatalak da en. ");
INSERT INTO agt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“A ya natungradanen gahut nga nehunnakan na kadwan kiden hukal a yen hapa ya keangarigan na makadangag ta uhohug, ");
INSERT INTO agt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ammi gafu ta addu hapa ya burungan da ta magmagannud, ikid na pakolangan da ya pagba-nang da, ikid na addu ya ingguman da a yen kid na nonot ya mangiduyat ta uhohugen, a awan na ta pagbalinān na uhohugen petta magserbi ta kappyanan da. ");
INSERT INTO agt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A ya mappya en lutak nga nehunnakan na kadwan kiden hukal a yen ya keangarigan na makadangag ta uhohug na Namaratu, a itug da hapa ya madangag da, a yen mantu ya kuman na ammay nga makapagmayan ta pake addu, ikid na makapagmayan ta kustu, ikid na makapagmayan ta medyo makurang la,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","22","A ya kadwan kiden keangarigan nga binida ni Hesus tekid a intu yan: “A ta ayanin kuman na napagatangan na ya hilag ta nonot muy gafu ta keangarigan ken, a awemuy mantu ilingad ya hilag muy awa itun muy hud la ta pakaitan na kadwan kiden tolay. Te maski am anu ya melemad ta ayanin a mappya ta mepalawag ta ngamin. ");
INSERT INTO agt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","A am kakurugan ta itta ya bangbang muy a mappya ta pake dangagan muy ya uhohug kin tekamuy. ");
INSERT INTO agt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A pake itug muy hapa ya nadangag muy, te ya kaddu na metug muy a kumanen hapa sangaw ya kaddu na amu muy, a madaggan para. ");
INSERT INTO agt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Te ya mangitug ta madangag na a itta para sangaw ya medagga ta amu na, ammi ya awanen mangitug a imawan hapa sangaw ya dana en amu na,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","“A ya gagangay na pangikerutan na Namaratu ta tolay kiden,” kunna ha ni Hesus, “a meangarig ta hukal kiden nga nepurwak na tolay ta uma na en. ");
INSERT INTO agt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Te am nabalin na nagpurwak a awena la bit burungan ya nepurwak na kiden, te ange magtarabaku ta kadwan kiden tarabaku na am ahaw, a am hiklam a masidug. A ya nepurwak na kiden a magtatuhu kid la, ammi awena haman amu am had kun na pagtuhu da ikid na idakal da, ");
INSERT INTO agt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","te ya lutaken hala ya magpatuhu, a sangaw lumattog ya don na kiden, kapye na sangaw magdawa ikid na magmayan ta addu. ");
INSERT INTO agt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A sangaw am nagtuyag na ya dawa na kiden a ange hapa maggatab ya nagmula en, te dumatang na ya araw na kagatab na. A kumanen hapa sangaw ta mesipat kiden ta pangikerutan na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“A anu mina ya takday para keangarigan na tolay kiden nga iturayan na Namaratu petta amu muy? ");
INSERT INTO agt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","A kuman kid na kaassangan na hukal nga imula na tolay, ");
INSERT INTO agt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","te sangaw am dakal na ya mula na en a intu ya kadakalan na ngamin kiden mula, te magge kuman na kayu, petta yen ya eyan na mamanuk kiden pagumukan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","A addu para ya binida ni Hesus tekid ta kumanin na keangarigan, te yen ya naattaman da dangagan. ");
INSERT INTO agt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","A awan ta takwan na binida na tekid am bakkan ta keangarigan, ammi am ik-ikid la na ituldu na kiden a sa nepalawag na ya ngamin tekid. ");
INSERT INTO agt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","A sangaw ta marimat a “Entanan ta dammangewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","A nagtugutan da ya kaddu na tolay kiden ta ba-nad na alugen, te naglalugan kid na ta selayagen nga nagtuttudan ni Hesus tentu en nangituldu ta tolay kiden. Ammi ya kadwan kiden tolay a dumadagdag kid ta selayag da kiden hala. ");
INSERT INTO agt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","A nagyan la i Hesus ta huli na selayagen, a masidug na ta fungan. A tentu en nasidug ta mappya a kima-ma la umange ya masikan na paddad. A pake nagpalung na ya danumen, a lima-nug na ta umag na selayag da en addet ta tanagay kid na lumammad. A gafu ta burung da a enda hinukal i Hesus, “Magpasi kitam O, Afu, anu awan haman ta pangkengam,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","A tentu nahukal a nehuya na ya paddad, a “Magintak kan,” kunna hapa ta danumen, a nagimmang na, a nagsimpan ya danumen. A ya uhohug na hapa ta ituldu na kiden a ");
INSERT INTO agt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","“Anu haman ta magburung kam? Awan hud ta pangikatalak muy?” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","A pake nahigalan kid na tentu, a “Anu panaw ya katolay na tolayin yan, te maski ya paddad ikid na palung a kurugan da hala ya uhohug na,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","A tekiden nakadatang ta dammang na alugen a itta kid na ta lugar na Gadareno kiden, a dumagut na i Hesus ta selayagen. ");
INSERT INTO agt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","A tentun dimmagut a nepagka-ma na ya takday lalaki nga pinagguyung na anitu na kiden. ");
INSERT INTO agt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","5","Te bagu nagafu ta agyan na tanam kiden, te yen hala ya nagyanan na. A ya gagangay na hapa ta idi a pakpakataraw ikid na paghuhuklaw gimihgihawa ikid na nakakalkalasig ta agtatanamanen ikid na bagbagetay kiden, yaga kulkulsangan na ya barbari na ta batu. Namengaddu nagalutan ta idi ta kawad ta kamat na pase takki na kiden, ammi awena haman nagamman, te gasgasātan na hala ya kawad ta kamat na kiden, a pakpakkan na ya kawad ta takki na kiden, a awan ta tolay nga nakagamma tentu. ");
INSERT INTO agt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ammi tentu en nakaita te Hesus ta adayu a bumilag na hapa nga ange namalentud tentu. ");
INSERT INTO agt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","“O Hesus, Anak na Namaratu,” kunna, ammi ginamman ni Hesus ya anitu na en; “Pagtugutām na ya tolayina,” kunna. A pake pinaggihawa na anitu en, “Anu hud ya aamum teyak? Magpagasingan ka ta Dyos ta awenak pakākāllakan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","“Anu hud ya ngagam?” kunna ha ni Hesus ta anitu na en. “Armado ya ngagan ku te adaddu kami sin,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A nakikekallak para la te Hesus ta awena kid patugutan ta adayu na lugar. ");
INSERT INTO agt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","12","“Doban kami haen ta bahuy kidewan petta magyan kami la tekid,” kunna, te abikan hapa ya addu na bahuy nga magdukdukit ta hukeb na bagetay. ");
INSERT INTO agt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","“E kanan mantu,” kun ni Hesus ta anitu kiden, a nagtugutan da ya lalaki en, kapye da simarok ta bahuy kiden, a ka-ma la nagadukal ya bahuy kiden bumilag, a sa nagurdak kid ta gatab na bagetayen, kapye da nagkahunnak ta alugen. Dwaribu kid, a sa nagkalimat kid ta danumen. ");
INSERT INTO agt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","A ya nagtahon kiden ta bahuy kiden a nagbabilag kid na hapa kumin ta ili, a nesaned da nedanug ya ngamin iningwa ni Hesus, a umange hapa ya tolay kiden, te enda inita ya makkwa. ");
INSERT INTO agt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","A ta datang da ta agyan ni Hesus, a nagtalaw kid na hapa, te naita dan ya lalaki en nga nagyanan na anitu kiden, ammi awan na ya uyung na en, te nagbarawasin, a imatuttud la ten. ");
INSERT INTO agt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","A binida hapa na nagtahon kiden ya ngamin naita da ta naguyungen ikid na bahuy kiden. ");
INSERT INTO agt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","A yen ya gafu na ta pinatugut da i Hesus, te aweda ikayat ta magdulot ta lugar da. ");
INSERT INTO agt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","A nagtoli mantu ta selayagen nga nagluganan da, a paalap hapa ya lalaki en nga nagyanan na anitu kiden petta dumagdag hapa tentu, ");
INSERT INTO agt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ammi awena nepalubus ni Hesus. “Awem la ange, te dumatang kan mina ta balim ikid na kahulum kiden, te ipadangag mu sangaw tekid ya ngamin kallak na Namaratu teko,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","A nagtugut mantu ya lalaki en, a enna nepadangag ya kallak ni Hesus tentu abat ta ngamin paglelehut na mafulu kiden ili. A nepagpaka-lat da hapa ya binida na tekid. ");
INSERT INTO agt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","A ta nepakadakit nig Hesus ta dammang na alugen a enna kid kinalihung na addu na tolay ta bikat na alugen. ");
INSERT INTO agt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","A nehulun hapa tekid ya takday pinakadakal ta kapilya na Hudyo kiden nga nagngagan te Hayrus. A tentu nakaita te Hesus a umange namalentud ta atubang na nga makimallak tentu. ");
INSERT INTO agt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Masi ya anak ken, Afu. Em haen isi-ged ya kamat mu tentu petta matolay,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","A dumagdag mantu i Hesus tentu nga ange ta agyan na anak na en masi. A sakā dumadagdag hapa ya magamagaddu na tolay nga ange mangiil-ilat te Hesus. ");
INSERT INTO agt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","A nehulun hapa tekid ya takday babbay nga makataktakit, te makadagdaga kan abat ta mafulu duwa na darun. ");
INSERT INTO agt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A sa inafut na kan ya ngamin katolayan na nga netandan na ta addu na manguru, yaga addu hapa ya inattaman na ta nepanguru da tentu, ammi awena haman nagmappya awa nagkehal la. ");
INSERT INTO agt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","A mappya hapa, te nadamag na ya pakapangwa ni Hesus gafu ta bida na tolay kiden, a yen ta sumalsal ta talekud ni Hesus, petta si-gedan na ya barawasi na en. ");
INSERT INTO agt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Maski la am masi-ged ku ya barawasi na en a magmappya yak,” kunna kan na nonot na. ");
INSERT INTO agt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","A tentun nakasi-ged ta barawasi na a yen hapa ya nepagimmang na daga na en, te narikna na kan ta awan na ya takit na en. ");
INSERT INTO agt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ammi narikna hapa ni Hesus ya imuhet ta bari na en nga nagpamappya ta magtakit, a alistu nagbalittag, a “Inya ya nangsi-ged ta barawasikin?” kunna, ");
INSERT INTO agt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","“A maitam haman ya kaddu na tolay kiden nga magitaptapal nagsi-ged teko, a annum para ibar am inya ya nangsi-ged teko,” kunna hapa na ituldu na kiden tentu. ");
INSERT INTO agt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ammi nakaliplipay para la, te apagan na ya takdayen nga nangsi-ged tentu. ");
INSERT INTO agt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A gafu ta narikna na babbayen ya pagkamag na takit na en a umange hapa namalentud ta atubang ni Hesus, te yaga nagtalaw hapa tentu, a sa binida na ya ngamin tentu. A ya nebar ni Hesus tentu a ");
INSERT INTO agt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","“Itam awa nagmappya kan, Aboy, te ya pangikatalak mu teyak ya nagmappyam. Awem la sangaw magburung, te awena sangaw magtoli na takit men,” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","A tentu para la naguhohug ta babbayen a itta ya umange mangidanug tekid nga nagafu ta bali ni Hayrus. “Maski awem na pagdulotan ya Mistro ta bali, te nasin ya anak men,” kunna te Hayrus. ");
INSERT INTO agt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ammi nedangagan hapa ni Hesus ya inuhohug na, a nebar na te Hayrus ta “Awem la magburung, te itug mu la ya pangikatalak mu,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A gafu ta kumanen a nagdulot kid la ta bali na en, ammi nehangat ni Hesus ta dumagdag ya addu na tolay tekid, te ikid la inalap na ig Pedru, ikid ni Santiago, ikid na kabagis na en Hwan, kontodu dama na abbingen. ");
INSERT INTO agt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","A ta pakadatang da ta bali ni Hayrusen a neddatangan da ya tolay kiden nga gisitangan ikid na gitangitan ta masikan. ");
INSERT INTO agt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ammi tekiden gimon ta bali a “Anu masitang kam gitangitan? Nasi hud ya abbingina awa masidug la,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A nekakatawa da hapa, ammi pinohet na kid ta bali en, kapye na inalap ya dama na abbingen ikid na tallu kiden kahulun na, a simarok kid ta agyan na abbingen. ");
INSERT INTO agt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","A inibbalan na ya kamat na en kapye na binaran, “Talita kumi,” kunna la ta agsitang na Hudyo kiden. Ammi ya ikayat na uhohugan a “Aboy, imivwat kan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","A alistu kad imivwat ya abbingen, a nagpapa-yat hapa ta umag na bali en, te dakal hapa na abbing, te itta kan mafulu duwa darun na. A pake nafulotan ya pagpaka-lat nig dama na en. ");
INSERT INTO agt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","“Pakanan muy na,” kunna hapa ni Hesus tekid, otturu pake nebar na tekid ta aweda la ibabar ya iningwa na ta anak da en. ");
INSERT INTO agt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","A ta nekabalin ni Hesus ta iten a nagtatugut kid na ituldu na kiden, te umange kid ta lugar na en hapa la. ");
INSERT INTO agt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","A sangaw ta araw na agimmang a umange kid nakigimung ta kapilya, a nangituldu hapa i Hesus ta addu na tolay. A pake nepagpaka-lat da hapa, te kalugaran da haman, a papa-nun na makkamu mangituldu, a yen ta nagimpopohut kid na ta pagpaka-lat da tentu. “Inya hud ya nangalapan na ta kumanin na bida?” kun na takday. “A anu hud ya ikayat na uhohugan?” kunna hapa na takday. “A anu kawagan na ta itta ya pakapangwa na?” kunna para na takday. ");
INSERT INTO agt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A gafu ta kalugaran da ikid na kagitta da en napanglaw a aweda kinurug, a nedadula da. “Bakkan hud ta anak la na kalapintero ikid ni Mariya en nga kagitta tam napanglaw? Yaga kagitta tam hapa ya kabagis na kiden Santiago, ikid ni Hose, ikid ni Simon, ikid ni Hudas, ikid na wāgi na kiden nga babay nga magyan tekitam sin,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ammi ya uhohug ni Hesus tekid a “Kakurugan ta madayawan ya paguhohugan na Namaratu ta ngamin kiden lugar ammi fwera la ta lugar na en hapa la ikid na kahulun na kiden ta bali na,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","A pake nepagpaka-lat na hapa ya kawan na pangurug da tentu, a yen ta assang la ya nepaita na ta pakapangwa na tekid, te assang la ya pinagmappya na ta magtakit nga sini-ged na ta kamat na. A sangaw sinaned na ya kadwan kiden lugar na babali petta mangituldu ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A sangaw pinagammung ni Hesus ya mafulu duwa kiden ituldu na, a pinasinapan na kid ta pakapangwa na, petta itta ya mabalin da nga magpatugut ta anitu na seanitu kiden, a sinagduwa na kid nga ange mangipadangag. ");
INSERT INTO agt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","“Awemuy ihulun ya gamgamak muy, fwera la ta sarukud muy ikid na pagsapatos muy. A awemuy hapa magbalun ta kanan muy ikid na pirak muy ikid na tali na barawasi muy. ");
INSERT INTO agt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A maski am inya sangaw ya magpadulot tekamuy ta bali da a magyan kam ten abat ta magtugut kam. ");
INSERT INTO agt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","A am awan pulus ta magpadulot tekamuy ikid na magdangag ta uhohug muy a pagtugutān muy kid mantu, a azin muy ya lafu na agyan da ta takki muy kiden,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A nagtatugut kid na nga ange mangipadangag, a nepadangag da ta magbabawi mina ya tolay kiden ta pagliwat da. ");
INSERT INTO agt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","A addu hapa ya pinatugut da nga anitu ta seanitu kiden, a addu hapa na magtatākit ya linugudan da ta denu a nagmappya kid. ");
INSERT INTO agt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","A sangaw nadamag ni Ari en Herud ya ngamin kiden tarabaku ni Hesus, te sigida bibidan na tolay kiden ya ngagan na, a lavlavunan da am inya ya katolay na. “Intu hala i Hwanen nga nangzigut ta tolay kiden, a yen ta itta ya pakapangwa na, te natolay hala ta pasi na en,” kun na kadwan. ");
INSERT INTO agt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ammi ya uray kadwan a “Intu hala ya aglavunen Eliyas, te nagtoli hala ta lutakin,” kunda. A ta kadwan para a “Kakurugan ta aglavun ta kuman na aglavun kiden ta palungu araw,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ammi ta nepakadamag ni Herud tentu a “Intu malat i Hwanen nga pinaputulan ku ta kwa en sina, a natolay hala,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","A kunna ten ya nebar na te ta katolay para la ni Hwan a nangadallaw i Herud, te ginubatan na i Herodias nga atawa na kabagis na en Felipe. A yen ta natotoli i Hwan tentu petta ihuya na ya tinarabaku na en. “Nakaliwat kan ta Namaratu ewan te ginubatam haman ya atawa na kabagis men,” kunna te Herud. A yen ta masikan hapa ya pangikatupag ni Herodias te Hwan, a ikayat na ta napapasi mina. Ammi awan ta nabalin na, te nagtalaw i Herud nga mangpapasi tentu, te yaga amu na ta mappya na tolay na Namaratu nga awan ta liwat. A yen ta kengan ni Herud ya angat na, a nepebalud na la gafu ta atawa na en. A kanayun nagpatotoli ta agyan na kabaludan na en petta dangagan na ya bida na, ammi napopoyung hala ya nonot ni Herud gafu ta bida ni Hwan tentu. ");
INSERT INTO agt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A sangaw ta nekabalud para la ni Hwan a dumatang ya araw na panadamdaman ni Herud ta araw na nekeanak na en, a namadday hapa ta pagpamakan na ta opisyales na kiden ikid na suddalu na kiden pase naba-nang kiden tolay nga taga Galileya. ");
INSERT INTO agt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","A ye-yen hapa na araw ya pakagāsāt na babbayen petta papapasi na i Hwan, te umange nagsala ya anak na en nga balatang ta atubang ni Heruden ikid na sangaili na kiden, a pake natalakan kid ta pagsala na. A ya uhohug ni Herud tentu a, “Maski am anu ya ikayat mu, Aboy, a adangam la teyak te iatad ku hala teko. ");
INSERT INTO agt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A pagasingan ta Dyos am awek iatad teko ya ngamin adangam teyak maski abat ta gadwa na ngamin pagariyan ku,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A nagtugut la bit ya balatangen, te enna pinohutan te hina na en am anu mina ya adangan na. A ya uhohug na hina na en tentu a “Maski intu la adangam ya ulu ni Hwan en,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A alistu mantu nagtoli ya balatangen ta agyan na ari en, a “Iatad mu mantu teyak ya ulu ni Hwan en, te pedatang mun ta isin nga melātuk,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A pake nagdamdam hapa ya ari en ta inadang na en, ammi awena ikayat ilogot ya balatangen gafu ta kari na en tentu, yaga amat na hapa ta sangaili na kiden. ");
INSERT INTO agt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","A dinob na mantu ya suddalu en naggwardya petta enna papasin i Hwan, yaga nebar na ta idatang na hapa ya ulu na en. Enna mantu pinutulan ta agyan na agbaludanen, ");
INSERT INTO agt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","a magananwan la a nedatang nan ya ulu na en nga nelātuk, a negawat da ta balatangen, otturu negawat na hapa te hina na en. ");
INSERT INTO agt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","A ta nepakadamag na ituldu kiden ni Hwan ta pangpapasi da tentu a enda inalap ya bari na en, kapye da netanam. ");
INSERT INTO agt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A sangaw ta pagtoli na turin kiden ni Hesus nga dinob na ange mangipadangag, a binida da tentu ya ngamin tinarabaku da ikid na netuldu da. ");
INSERT INTO agt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A gafu ta kanayun timahud ya addu na tolay tekid a aweda matagop ya mangan, a “Mappya ta limillik kitam bit ta isin petta ik-ikitam la bit, te magibannag kitam,” kun ni Hesus ta turin na kiden. ");
INSERT INTO agt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","A naglalugan kid mantu ta selayag, te ange kid mina ta awan ta totolay ta dammang na alugen. ");
INSERT INTO agt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ammi kadulayan na te neitan na kid na kadwan kiden tolay ta nepagtugut da en. A gafu ta amu da kid a enda kid inakkawan ta lehut na alugen, a naghahulun hapa tekid ya addu na tolay nga taga ili kiden nga tinaliban da. A naunnanan da ig Hesus ta datangan da en. ");
INSERT INTO agt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","A ta datang nig Hesus a dana ittan hala ten ya tolay kiden nga nagapag tentu. A ta nepakaita ni Hesus ta kaddu da a timalin hapa ya allak na tekid, te kimongkong kid ta kuman na awan ta magtaron tekid. A namegafu ha nangituldu tekid ta addu. ");
INSERT INTO agt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","A ta furab a nagburung ya ituldu na kiden ta tolay kiden, a enda nebar te Hesus, “Mappya, Afu, ta patugutam ya tolay kidin, petta e kid gumatang ta pamuhab da ta babali kidewan, te furab na a awan haman ta pangalapan ta isin,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“A ikamuy na mina ya mangatad ta kanan da,” kunna hapa tekid. “A had mantu ya pangalapan mi ta awan bababang na pirak, petta igatang mi ta ipakan mi tekid?” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“A emmuy mantu itan am piga ya binalun na tolay kiden,” kunna ha tekid, a umange kid. A ta pagtoli dan a “Intu la itta sin ya lima na pan ikid na dwahukal na ikan,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","“A pagammungan muy mantu ya tolay kiden, a pagtuttudan muy kid ta kaddat kidina,” kunna ha tekid. ");
INSERT INTO agt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","A gafu ta kumanen a gituttudan kid nga naammungan ta taglimafulu ikid na tagmagatut, ");
INSERT INTO agt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","a inalap ni Hesus ya lima kiden na pan ikid na dwahukal na ikan, kapye na tumangad makimallak. A sangaw ginadgadwa na ya pan kiden ikid na ikan kiden, kapye na kid negawat ta ituldu na kiden petta ikid ya mangisaned ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","A sa nagkakan kid abat ta nabattug kid. ");
INSERT INTO agt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A tekid na nabalin nagkakan a pinannu da ya mafulu duwa na la-ba ta huna na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A ya kaddu na nagkakan kiden a limaribu kid na lālāki fwera ta bābāy ikid na anak. ");
INSERT INTO agt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A tekiden nabalin a pinapolu ni Hesus ya ituldu na kiden ta selayag, petta mapolu kid ta dammang ta ili na Betsayda, te mapozan la bit petta patugutan na ya tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","A tentun nakapatugut tekid a gimon hapa tatakday ta bagetay petta makimallak. ");
INSERT INTO agt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","A sangaw ta hiklam a nakatangngan ya barangay na ituldu na kiden ta alugen, a tatakday la i Hesus ta bagetayen. ");
INSERT INTO agt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ammi naita na ta nazigatan kid nagtagwan, te atubangan na kid hapa na paddad. A tentu nagkarawan a umange i Hesus tekid nga nagpapa-yat ta danumen. A taliban na kid mina, ");
INSERT INTO agt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ammi ta nepakaita da tentu nga magpapa-yat ta danum en a pahig da ta datay, a kumahkahaw kid na, ");
INSERT INTO agt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","te sa ikid nga nakaita tentu a gisatalaw kid na. Ammi alistu hapa i Hesus nga nagayag tekid, “Awemuy la magtalaw te iyakin yan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A tentu en hapa nakipaglugan tekid a ka-ma la nagimmang na ya paddaden, a pake masikan ya pagpaka-lat da tentu. ");
INSERT INTO agt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Te maski am naita dan ya pagpakaddu na ta pan kiden a aweda para la naawatan ya pakapangwa na, te aweda netug ta nonot da. ");
INSERT INTO agt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","A ta nepakadakit dan a itta kid na ta lutak na Genesaret, a negon da ya selayag da en. ");
INSERT INTO agt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","A tekiden nakadagut ta selayagen a alistu nalasin na kid na lumugar kiden. ");
INSERT INTO agt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A nagbabilag na ya tolay kiden ta babali kiden, te enda inalap ya ngamin kiden nagtatākit, a nedatang da kid giiddan ta dapan da kiden ta nagyanan ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","A maski had sin na ili ikid na lugar ya umeyan na a enda nekahad tentu ya nagtatākit kiden, a maski netabnak da kid la ta tātangngan na dapun kiden petta maita na kid. A nakimemallak kid ta si-gedan da la ya gayadan na barawasi na en. A sa nagmappya hapa ya ngamin kiden nakasi-ged tentu. ");
INSERT INTO agt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","A ta takday ha na araw a nakikkanan i Hesus ikid na kadwan kiden Pariseyu ikid na mangituldu nga taga Herusalem, ");
INSERT INTO agt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","a neitan da hapa ya kadwan kiden ituldu na ta aweda nagbaggaw kapye da nangan. ");
INSERT INTO agt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ammi tekid, kontodu ngamin kiden Hudyo a aweda bit makakan am aweda apolu makapagbaggaw ta kamat da ta kuman na agangwa na dadagkal da kiden. ");
INSERT INTO agt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","A maski am bagu nagafu kid ta dapun a aweda bit makakan am dana aweda warsin ya bari da. A addu para ya parigan da ta agangwa na dadagkal da kiden, te padeletan da ya magbaggaw ta ngamin banga da ikid na pinggan da ikid na paginuman da kiden. ");
INSERT INTO agt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A yen ta nebar da te Hesus ta “Anu awena dumagdag na ituldum kiden ta netuldu na dadagkal tam kiden? Te mangan kid hala maski aweda bit magbaggaw,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A ya tabbag hapa ni Hesus tekid a “Kuga magimmamappya kam, kustu hala ya nebar na Namaratu ta aglavunen Isayas gafu tekamuy, te ya nebar na a ‘Dayawan nak na tolay kidin ta simuk da, ammi adayu garay ya nonot da teyak. ");
INSERT INTO agt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Awan mantu ta kapkappyan na pangdayaw da teyak, te igitta da haman ya ituldu da ta itulduk,’ kunna, ");
INSERT INTO agt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“On, te baybay-an muy hapa ya lintig na Namaratu, a intu idulot muy ya gagangay na tolay. ");
INSERT INTO agt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Malalaki mantu ya sistema muy, te takwan ya ipagsil muy ta lintig na Namaratu petta idulot muy la ya agangwa muy. ");
INSERT INTO agt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Te ya lintig na Namaratu nga netuldu ni mina Moses a ‘Nonotan muy ig dama muy ikid na hina muy,’ kunna. ‘A mappya ta mapapasi ya maguhohug ta dulay tekid,’ kunna ha. ");
INSERT INTO agt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ammi tekamuy a ugtulān muy haman ya uhohug na en, te ya ituldu muy tekid a ‘Dana mangatad kam bit ta simbaan na Namaratu, a am awan na sangaw ta iuffun muy ta dadagkal muy kiden a ibar muy tekid ta dana neatad muy na ta Namaratu,’ kummuy. ");
INSERT INTO agt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","A gafu ta kumanen a awemuy ipalubus ta kurugan da ya nebar na Namaratu gafu ta dadagkal da kiden. ");
INSERT INTO agt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","A liblibangan muy mantu ya uhohug na Namaratu petta idulot da ya ituldu muy, yaga addu para ya ituldu muy ta gagangay muy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A sangaw pinaabikan ni Hesus ya tolay kiden tentu, a nebar tekid ta “Pake dangagan muy ya uhohug ku tekamuy petta maawatan muy: ");
INSERT INTO agt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bakkan ta intu ikazigman na Namaratu ya awan magbaggaw kapye na mangan, baka ikazigman na hud ya itun muy ta simuk muy? Intu hud la ikazigman na ya dulay nga nagafu ta simuk muy. ");
INSERT INTO agt_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“A am kakurugan ta itta ya bangbang muy a mappya ta dangagan muy ya bidan kin tekamuy,” kunna tekid, kapye na kid nagtugutan. ");
INSERT INTO agt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","A ta datang nig Hesus ikid na ituldu na kiden ta bali a pinohutan da tentu am anu ya ikayat na uhohugan ta ikazigman na Namaratu. A ya nebar na tekid a ");
INSERT INTO agt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“Anu awemuy hapa metug ya inuhohug ken? Awemuy hud manonot ta maski am anu ya mehulun ta kanan na tolay a bakkan haman ta yen ya mangatad ta pagzigmanan na, ");
INSERT INTO agt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","te awena haman ange ta nonot na awa ange hala ta sirat na kapye na sangaw mewarad,” kunna tekid. A gafu ta uhohug na en a nepasikkal na ta mepalubus makan ya kompormi na kanan. ");
INSERT INTO agt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A ya uhohug na para tekid a “Ya imuhet ta simuk na tolay ya mangatad ta pagzigmanan na, te magafu hala ta nonot na. ");
INSERT INTO agt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Te ya dulay na nonot, ikid na magtakaw, ikid na mangpapasi, ikid na mangadallaw, ");
INSERT INTO agt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ikid na maginggum, ikid na mangikatupag, ikid na magladdud, ikid na awan mangiguwad ta dulay na nonot, ikid na pumassil ikid na mamadpadulay, ikid na magparayag, ikid na manguyoyung, ");
INSERT INTO agt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","a yen kid na tarabaku ya magafu ta nonot na tolay a mangatad kid ta pagzigmanan na,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","A tekiden nagtatugut ta iten na lugar a umange kid ta tagad ta lugar na Tiro ikid na Sidon. A nagyan kid ta takday bali ten petta awan ta makkamu ta pagyanan da. Ammi maski kunna ten a aweda haman nakatagu, ");
INSERT INTO agt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","te magananwan la a itta ya takday babbay nga nakadangag ta itta la ten i Hesus, a umange nagtakab ta atubang na en gafu ta balatang na en nga pagzigātan na anitu. ");
INSERT INTO agt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Bakkan ta Hudyo ya babbayen, te Giregu nga taga Funisya, a ya uhohug na te Hesus a “Ikallak nak, Afu, te patugutam mina ya anitu na anak ken nga babbay,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ammi ya tabbag ni Hesus tentu a “Mappya ta apolu mangan ya kagittak kiden, te dulay am meatad ta atu ya kanan na anak kidin,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“A kakurugan, Afu, ya kinamina, ammi awena hud mangan na atu kiden ta hugta na anak kiden nga nahunnak ta lutak?” kunna hapa na babbayen. ");
INSERT INTO agt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","“A kustu hapa ya inuhohug mu, Aboy, dumatang kan mantu ta balim, te nagtugut na ya anitu na anak men,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A nagtugut mantu ya babbayen, a dinatangan na hala ya anak na en nga imaidda, a awan na ya anitu na en. ");
INSERT INTO agt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","A ta nekabalin da ta iten a nagtatugut kid ha, a inange da ya ili na Sidon ikid na lugar na Dikapolis addet ta Alug na Galileya. ");
INSERT INTO agt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A sangaw neange da tentu ya takday lalaki nga bangngag ikid na umal, a nakimemallak kid tentu ta isi-ged na ya kamat na tentu. ");
INSERT INTO agt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","A sang neadayu bit ni Hesus ya lalaki en ta kaddun na tolay kiden petta ik-ikid la, a netulpat na ya guramay na ta duwa kiden bangbang na lalaki en, kapye na hapa naglutab. A sangaw netulpaw na hapa ya guramay na ta zila na lalaki en. ");
INSERT INTO agt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","A tumangad i Hesus ta langit, a manalasigak hapa kapye na naguhohug ta lalaki en, “Efata,” kunna ta agsitang na Hudyo. “Maukadan kan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A nakadangag na ya lalaki en, yaga nalukay hapa ya zila na en, a mappya hapa ya pakauhohug na. ");
INSERT INTO agt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","A pake nebar ni Hesus ta tolay kiden ta aweda mina bibidan ya naita da. Ammi aweda garay dinangdangag ya nebar na tekid awa pake nepadangag da hud la. ");
INSERT INTO agt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","A pake nafulotan ya pagpaka-lat na ngamin kiden nakadangag ta bida da en. “Mappya kad ya ngamin ya tarabaku na, te atadan na ya bangngag ta pakadangag na, ikid na umal ta pakauhohug na,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A sangaw ha ta mittan a nagaammung ya pake addu na tolay, a gafu ta awan ta kanan da a pinaabikan ni Hesus ya ituldu na kiden petta ibar na tekid. ");
INSERT INTO agt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kuga timalin ya allak ku ta tolay kidin, te tallu araw kid na teyak, a naafut na ya balun da. ");
INSERT INTO agt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","A am padatangan ku kid mina ta bali da a magkafuy kid sangaw ta dalan gafu ta bisin da, pade awa pake adayu ya bali na kadwan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","“Ahu, had ya pangalapan tam ta isin na lugar ta ipakan tam tekid, te adayu haman yan ta babali?” kunda hapa tentu. ");
INSERT INTO agt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“A piga hud ya nehuna muy nga pan?” kunna ha, “A pitpitu hukal la,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A gafu ta kumanen a pinagtuttud na ya tolay kiden ta lutak, a ginawat na hapa ya pitu kiden pan kapye na kid nepakimallak, a sangaw ginadgadwa na kid kapye na kid negawat ta ituldu na kiden, a nesaned da kid hapa ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Itta hapa ya assang la na ikan da, a nepakimallak na kid hapa kapye na kid nepesaned. ");
INSERT INTO agt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","A sa nagkakan kid abat ta nabattug kid. A sangaw pinannu da hapa ya pitu na la-ba ta nehuna na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A ya kaddu na nagkakan kiden a nasurok ta appataribu kid, a sangaw pinadatang na kid ta bali da. ");
INSERT INTO agt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","A tekid na nagtugut a naglugan hapa i Hesus ta barangay kontodu ituldu na kiden, a umange kid ta lugar na Dalmanuta. ");
INSERT INTO agt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","A sangaw umange te Hesus ya kadwan kiden Pariseyu, a nakidibati kid tentu. “Mappya ta itta ya ipaitam ta pakapangwam, petta pakaitan mi ta Namaratu ya nangidob teko,” kunda ta pangparuba da tentu. ");
INSERT INTO agt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A nanalasigak hapa i Hesus ta pagdamdam na tekid, a “Anu ya kuga pagdaram na tolay kidin yan ta kanayun adangan da ya ipaitak tekid? Kakurugan ya uhohug ku tekamuy ta awan sangaw ta ipaitak tekamuy,” kunna tekid, ");
INSERT INTO agt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","a nagtugutan na kid. A nagbarangay ig Hesus ikid na ituldu na kiden petta e kid ta dammang na alugen. ");
INSERT INTO agt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A ta nepaglugan da ta barangayen a naliwatan na ituldu na kiden ya nagbalun ta kanan da, te tatakday la na pan ya huna da ta barangayen. ");
INSERT INTO agt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","A ya uhohug ni Hesus tekid a “Mappya ta palanan muy ya beking na Pariseyu kiden ikid na beking na kahulun ni Herud, te dulay,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A nagbabidan da am anu ya ikayat na uhohugan; “Ay On, te naliwatan tam ya nagbalun ta pan,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ammi ta nepakarikna ni Hesus ta bida da a “Anu kuga pagbabidan muy ya kawan na kanan tam?” kunna. “Awemuy hud para maawatan ya ikayat ku uhohugan tekamuy. Nagbanad hud ya nonot muy? ");
INSERT INTO agt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Itta haman ya mata muy, a anu awemuy haman makaita. A itta hapa ya bangbang muy, a anu awemuy makadangag? ");
INSERT INTO agt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Naliwatan muy de ya lima kiden pan nga nepakan ku ta limaribu kiden. A piga hud na la-ba ya pinannu muy ta huna da kiden?” kunna tekid. “A mafulu duwa,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“A ta pitu kiden pan nga nepakan ku ta appataribu kiden, a piga hapa na la-ba ya pinannu muy ten ta huna da kiden?” kunna ha. “A pitu hapa,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Ay, awemuy para la de maawatan ya ikayat ken uhohugan tekamuy ta ‘Palanan muy mina ya beking na Pariseyu kiden ikid nig Herud?’” kunna. ");
INSERT INTO agt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","A ta pakadatang da ha ta ili na Betsayda a itta ya umange nangidafung ta nagdaram te Hesus, a nebar da ta “Maski la isi-ged mu ya kamat mu tentu petta makaita,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","A inibbalan ni Hesus ya kamat na nagdaramen, kapye na ginemidan neuhet ta ada-dayu ta babali kiden. A sangaw linutaban na ya mata na kiden kapye na kid hapa sini-ged ta kamat na. “Itta de ya maitam?” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A nesaned na hapa ya mata na kiden, a “Maitak de ya tolay kiden nga magpapa-yat, ammi awan ta pagdaduman da ikid na kayu kiden,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","A gafu ta kumanen a sini-ged na ha ya mata na kiden, a tentu ha pake nagladdang a nagmappyan ya mata na kiden, a pake madakar na ya pakaita na ta ngamin. ");
INSERT INTO agt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","A pinadatang ni Hesus ta bali na, ammi dana nebar na ta “Awem la magsibsibal ta kadwan kiden babali,” kunna hapa tentu. ");
INSERT INTO agt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","A tekiden nagduldulot ta ili na Sesariya Pilipo a itta ya pinohutan ni Hesus ta ituldu na kiden; “Anu kan ya pangitan na tolay kiden teyak am inya yak?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“A pahig na kadwan ta iko i mina Hwan nga nangzigut ta tolay nga napapasi ta kwa en sina. Ammi ta kadwan a pahig da ta iko ya aglavunen Eliyas nga magtoli kan ta lutakin. A ta kadwan para a pahig da ta iko ya takday na aglavun nga nasi ta palungu araw,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“A ikamuy ay, anu hapa ya pangitan muy teyak?” kunna ha tekid. A i Simon Pedru ya alistu tumabbag; “A iko ya Mangikerutanen nga netun na Namaratu ta pinakadama mi,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","A sangaw pake nebar ni Hesus ta aweda mina bibidan yen ta kadwan kiden tolay. ");
INSERT INTO agt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A ta nekabalin na en a namegafun hapa i Hesus nga mangipadangag ta pasi na tekid. “Mappya ta pakākāllakan da sangaw ya Tolayin taga Langit, te ya kalalaklakayan kiden ikid na padi kiden ikid na mangituldu kiden, a aweyan dak sangaw, kapye dak sangaw papapasi, ammi matolayak hala sangaw am nagpasan ya talluhaw,” kunna, te awena nelemad awa pake nebar na tekid. ");
INSERT INTO agt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ammi ginamid ni Pedru ta sang adayu, a “Awem mina ibar ta mapapasi ka, Afu, te Namaratu ya makkamu teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","A nagbalittag hapa i Hesus nga nangita ta kadwan kiden ituldu na kapye na nehuya i Pedru, “Umadayu kan teyak, te itta Satanas teko, te bakkan ta uray na Namaratu ya patarabakum teyak awa uray hud la na tolay,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A sangaw pinaabikan na ya ituldu na kiden ikid na kadwan kiden tolay nga nangkalihung tentu petta madangag da ya ibar na tekid. “Am itta ya mayat dumagdag teyak a mappya ta pagtalekudan na ya bari na, a attaman na ya zigat na pangurug na teyak, petta makadagdag teyak. ");
INSERT INTO agt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Te maski am inya ya mangkenga ta angat na a masi hala sangaw ta magnayun, ammi ya mangisagapil ta angat na gafu ta pangurug na teyak ikid na damag ku a matolay hala sangaw nga magnayun. ");
INSERT INTO agt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Te maski am itta mina ya nakaalap ta ngamin kiden magmagannud ta paglelehutin a itta hud sangaw ya kappyanan na tentu am nawakay ya kahalwa na ta pasi na. ");
INSERT INTO agt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A itta hud sangaw ya pangsaka na ta kahalwa na petta matolay? ");
INSERT INTO agt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A maski am inya sangaw ya mamat mangibosag teyak ikid na uhohug ku ta atubang na awan kiden mangurug a yen hapa sangaw ya pagtalekudan ku am magtoli yak sangaw ta lutakin nga mangihulun ta pakapangwa ni Damakewan ikid na anghel na kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A ya uhohug na para tekid a “Kustu hapa ya ibar ku tekamuy ta matolay la ya kadwan kiden tekamuy petta maita muy sangaw ya Tolayen taga Langit sekadakar na en ta kuman na intu am ange sangaw sin magtogkok ta pagariyan na en,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","A ta nepagpasa na annam na araw a inalap na ig Pedru, ikid ni Santiago ikid ni Hwan, a sa naghahulun kid gimon ta ata-nang na bagetay, petta ik-ikid la. A sangaw nanguli hapa ya bari ni Hesus en, ");
INSERT INTO agt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","a pake nagfuraw ya barawasi na kiden, te awan ta kagitta na kafuraw na, te pake makatulang hapa ya dakar na en. ");
INSERT INTO agt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","A nepagka-ma da hapa ya lalattog ni mina Moses ikid ni Eliyas, a nagbida kid te Hesus. A ya uhohug ni Pedru a ");
INSERT INTO agt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","“Mappya, Afu, te itta kamin sin, te mamadday kami mina ta tallu na monyumento, petta tagtakday kam ni Moses ikid ni Eliyas ta monyumento,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ammi pagtaranyag na yen gafu ta talaw na en, te sa nagtalaw kid. ");
INSERT INTO agt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","A kima-ma la hapa ya pake furaw na kulam nga imakban tekid, a tinappanan na kid, a nadangag da hapa ya maguhohug tekid ta umag na kulamen, “Ye-yan ya Anak kin nga pake iddukan ku. A mappya ta intu ya dangagan muy ta ituldu na tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","A tekiden naglipay a awan na ta naita da am awa i Hesusen la. ");
INSERT INTO agt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","A tekiden dumadagut ta bagetayen a nebar ni Hesus tekid ta aweda la bit bibidan ya naita da, “te mappya ta apolu masi ya Tolayin taga Langit kapye na sangaw matolay, a yen sangaw ya pangipadangag muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aweda mantu binibida, ammi nagbabidan da am anu ya ikayat na uhohugan ta uhohug na en nga ‘masi kapye na sangaw matolay’. ");
INSERT INTO agt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","A ya pohut da en hapa tentu a “Am gagangay ta kumanen sangaw ya kasasaad mu, Afu, ta iangem ta lutakin a anu mantu ya ikayat na uhohugan na mangituldu kiden, te ibar da haman ta apolu maglattog i Eliyasen kapye na umange ya Mangikerutanen nga nekari na Namaratu?” kunda. ");
INSERT INTO agt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","“A kustu hala ya nebar da,” kunna hapa ni Hesus, “te kakurugan ta apolu maglattog i Eliyas, petta dana iparan na ya tolay kiden. Ammi ya ibar ku tekamuy a nabayag na haman ya nelalattog ni Eliyas ta kuman na linavun da ta suraten, ammi aweda nalasin, a yen ta tinapangan da ta kuman na nekayat da. A mappya hapa ta magdulot ya uhohug na suraten gafu ta Tolayin taga Langit, te pakākāllakan da sangaw kapye da iwarad,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","A tekid na nakadagut ta agyan na kadwan kiden ituldu na ta akban na bagetayen a itta hapa ya addu na tolay. A ya kadwan kiden mangituldu ta relisyon na Hudyo kiden a pakidibatin da ya ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A ta nepakaita na tolay kiden te Hesus a kuga nekawa kid tentu, a nagbabilag kid na nga ange magpadulot tentu. A ya nebar ni Hesus tekid a ");
INSERT INTO agt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","“Anu hud ya nagtatabbagan muy ta ayanen?” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A ya tabbag na takdayen a “Itta yak sin, Mistro, te neangek mina teko ya anak ken, te itta ya anitu na nga nagpaumal tentu. ");
INSERT INTO agt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","A am pagkissiwan na a pagdangkakan na hapa ta lutak, kapye na pagtuyagan ya bari na en, otturu pagngahitaman na, a paglukbakan na para. A nepatugut ku ya anitu na en ta ituldum kidin sin, ammi aweda haman nabalinan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","“Kuga awan ta pangikatalak na tolay kidin yan. Bababang yen kabayag na pagyan ku tekamuy nga mangitultuldu, ammi awemuy para la netug. Iange muy mantu sin ya abbingina,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","A neange da mantu tentu, ammi ta nepakaita na anitu na en te Hesus a ka-ma la pinagkissiw na ha ya abbingen, a pinagdangkak na ta lutak, a nagkakuyat, a naglukbak na hapa. ");
INSERT INTO agt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Umanu hud ya kabayag na ta kumanin?” kun ni Hesus te dama na en, a “Addet ta pake kaassang na ay,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“A ta kadwan a paglattun na ta afuy pase danum petta papasin na. Ammi am itta ya makkwam, Afu, ay ikallak kami, Afu,” kunna ha. ");
INSERT INTO agt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Annum hud ibar am itta ya makkwak? Makkwak ngamin am itta ya pangikatalak mu teyak,” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","“Ay, ikatalak ta ka, Afu, pagustum haen ya pagkurangan na pangikatalak ku,” kunna hapa nagtangit. ");
INSERT INTO agt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","A gafu ta nagbabilag na ya tolay kiden nga ange magbuya a dana nehuya ni Hesus ya anitu na abbingen. “Iko anitu nga nagpaumal ikid na nagpabangngag ta abbingina, pagtugutām na, a awem na sangaw magtoli,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","A pinaggihawa na anitu en ya abbingen kapye na ha pinagkissiw ta masikan na kissiw, a yen ya nepagtugut na. A kuman na nasin ya abbingen. “Ay e, nasin,” kun na kadwan kiden. ");
INSERT INTO agt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ammi enna inibbalan ni Hesus ya kamat na en kapye na pinagivwat, a nagtayuk na. ");
INSERT INTO agt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","A sangaw ta bali ta kawan na nakibidan te Hesus a umange tentu ya ituldu na kiden, a “Anu awemi napatugut ya anitu na en?” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A ya tabbag na hapa tekid a “Awena mapatugut na kumanin na anitu am awemuy dana makimallak petta uffunan na kam na Namaratu ewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","A ta nekabalin da ten a nagpaabagatan kid ta lugar na Galileya, ammi ikayat ni Hesus ta awan ta makkamu ta agyan da, ");
INSERT INTO agt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","petta awan ta manabtabang ta pangituldu na ta ituldu na kiden. A ya uhohug na tekid a “Papasin da hala sangaw ya Tolayin taga Langit, te itta sangaw ya mangitalaba tentu petta enda gafutan na mangikatupag kiden tentu. Ammi maski am papasin dak a matolayak hala sangaw ta mekatallu na araw,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ammi aweda para la naawatan ya ikayat na uhohugan tekid, a mamat kid nangibar. ");
INSERT INTO agt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","A ta nekabalin da ten a nagdulot kid ta ili na Kapernayum. A tekid na gimon ta bali a pinohutan ni Hesus tekid am anu ya nagbabidan da ta dalan. ");
INSERT INTO agt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ammi aweda nagasitang gafu ta amat da, te intu nagbabidan da am inya tekid ya pinakadakal da. ");
INSERT INTO agt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A tentun hapa nakatuttud a pinaabikan na ya mafulu duwa kiden, a netuldu na kid. “Am inya ya mayat mapmapolu ammi ta kahulun na kiden a mappya mantu ta intu ya kapozyanan da petta makitagabu tekid,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A ginamid na hapa ya takday abbing ta tātangngan da, kapye na sina-bil, ");
INSERT INTO agt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","a sangaw netuldu na ta mafulu duwa kiden. “Maski am inya ya mangtagop ta kumanin na abbing gafu ta pangurug na teyak a mekwenta hapa ta iyak ya tinagop na, a ya mangtagop teyak a bakkan la ta iyak ya tagopan na am awa nangidoben teyak hapa,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","A ya uhohug hapa ni Hwan tentu a “Mistro, itta ya naita mi nga magpatugut ta anitu na seanitu kiden, ammi usaran na hapa ya ngagam. A ginamman mi hapa te awena mehulun tekitam,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“Awemuy mina gamman ya kumanen,” kunna hapa ni Hesus tentu, “te maski am inya mina ya mangwa ta pagpaka-latan gafu ta ngagan ku a awenak otturu padpadulayan. ");
INSERT INTO agt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Te ya awan mangikatupag tekitam a kahulun tam kid hapa. ");
INSERT INTO agt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A kakurugan hapa ya uhohug ku tekamuy ta maski am inya ya mangatad ta inuman muy gafu ta kahulun ta kam a itta hala sangaw ya isagolyat na Namaratu tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ammi am inya ya mangituldu ta dulay ta maski takday la na kaassangan kiden nga mangurug teyak a pake kakallak sangaw, a mapmappya mina en ta dana nakaddangan ya lig na en ta dappug na batu kapye na newarad ta bebay, petta awena mina nakaliwat. ");
INSERT INTO agt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","46","A am angarigan ta kamat mu ono takkim ya gafu na pagliwat mu a awem hud gappakan kapyem iwarad petta awem sangaw melogot? Te mapmappya ta napukulan ka mina nga magdulot ta magnayun na pagtolayam ammi ta mewarad ka ta afuyen nga awan maazap gafu ta awemen inazi. ");
INSERT INTO agt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","A kumanen hapa ta matam, te am angarigan ta matam ya gafu na pagliwat mu a awem hud kilotan kapyem iwarad petta awem melogot? Te mapmappya ta bulding ka mina nga simarok ta pangikerutan na Namaratu ammi ta mewarad ka ta pangtaguhali na en gafu ta awemen inazi. ");
INSERT INTO agt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Te ya ngamin kiden magaddet ta iten a awena sangaw masi na irat da kiden, yaga awena maazap na afuyen, ");
INSERT INTO agt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","te sa mapa-gang kid ta afuy. ");
INSERT INTO agt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mappya mantu ta parigan muy ya gagangay na asin ta pagkahulun muy, te ya gagangay na asin a salsalinan na ya maglabag.” ");
INSERT INTO agt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","A ta nepagtugut nig Hesus ta nagyanan da en a umange kid ta lugar na Hudeya ta dammang na karayan na Hurdan, a nagammung ha tentu ya awan bababang na tolay, a netuldu na kid ta kuman na intu hala en. ");
INSERT INTO agt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A umange hapa tentu ya kadwan kiden Pariseyu, te itta ya pohut da ta pangparuba da tentu. “Mistro, had kun na pangawatam ta lintig ni Moses gafu ta magatawa kiden, te mepalubus de ta igungay na lalaki ya atawa na?” kunda. ");
INSERT INTO agt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A ya tabbag na hapa tekid a “Anu hud ya nebar ni mina Moses tekamuy?” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“A nepalubus na ta igungay na lalaki ya atawa na, ammi mappya ta iatad na tentu ya papel na pakigungay na,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“A onay, gafu ta pagbanad na nonot muy, ");
INSERT INTO agt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ammi addet ta nepamadday na Namaratu ta napopolu kiden a bakkan haman ta kunna ten, te ya uhohug na suraten a ‘Pinadday na kid petta itta ya lalaki ikid na babbay. ");
INSERT INTO agt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","A yen ta makigungay ya lalaki ta dakal na kiden, te makidagga ta atawa na en, ");
INSERT INTO agt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","a ikwenta na Dyos ya duwa kiden ta tatakday la na tolay,’ kunna, A bakkan kid na mantu ta duwa na tolay, te tatakday kid na. ");
INSERT INTO agt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","A madi mantu am paggungayan tam ya pinagdagga na Namaratu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","A ta datang nig Hesus ikid na ituldu na kiden ta bali a pabida da ha tentu ya kasasaad na makigungay ta atawa na. ");
INSERT INTO agt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A ya uhohug na tekid a “Am makigungay ya lalaki ta atawa na otturu mangatawa ha ta takwan a mekwenta hala ta mangadallaw. ");
INSERT INTO agt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A am makigungay hapa ya babbay ta atawa na otturu makiatawa ta takwan a mekwenta hapa yen ta makikadallaw,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A sangaw itta ya mangiange ta anak da kiden te Hesus petta ipotun na ya kamat na tekid, ammi nehuya na kid na ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ammi te Hesus a nagporayan na hapa ya ituldu na kiden. “Awemuy la gamman ya anak kiden, petta e kid la teyak, te ya ngamin kiden makigitta ta abbing a yen kid ya iturayan na Namaratu ewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“A kakurugan hapa ya uhohug ku tekamuy ta am awemuy ikatalak ya pagtaron na Namaratu ta kuman na abbing a awemuy sangaw mesipat tentu,” kunna, ");
INSERT INTO agt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","otturu sina-bil na ya tagtakday abbing, a pinasinapan na kid ta nepangipotun na ta kamat na tekid. ");
INSERT INTO agt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","A tentu en nagganwat nga ange ha magpasyar ta takwan na lugar a itta ya nagbilag nga ange namalentud ta atubang na en petta nakimemallak tentu. “Ay, Mistro, kakurugan ta mappya ka na tolay, a ibar mu haen teyak am anu mina ya tarabakuk nga mappya petta itta sangaw ya angat ku nga magnayun,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","A ya tabbag ni Hesus tentu a “Annum hud ibar ta mappya yak na tolay? Itta hud ya mappya am bakkan la ta Namaratu ewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","“Ammi am ikayat mu maatadan ta magnayun na angat a amum haman ya lintig na kiden ta awem mamapasi, ikid na awem mangadallaw, ikid na awem magtakaw, a awem hapa magladdud, ikid na awem magdarogas, a dayawam hapa ig damam ikid ni hinam,” kunna ha. ");
INSERT INTO agt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Ay, kanayun kurugan ku yen kid na lintig abat ta kaabbing ku,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A inaita la ni Hesus ta pangidduk na tentu, kapye na kinabida ta; “Itta para la ya takday pagkurangam,” kunna, “te em mina ilaku ya ngamin kiden kwam, a mangatad ka ta pobre kiden petta itta sangaw ya pagba-nangam nga mauknud ta agyan na Namaratu. A am mabalin kan a magtoli ka sangaw petta dumagdag kan teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A ta pakadangag na lalaki en ta inuhohug ni Hesus tentu a nagsugyab ya mukat na, a nagtugut hapa nagdamdam, te pake addu ya kwa na. ");
INSERT INTO agt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","A sangaw nagliplipay i Hesus kapye na ha naguhohug ta ituldu na kiden: “Kuga mazigat ya isassarok na maba-nang ta pangikerutan na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A nepagpaka-lat da hapa ya inuhohug na, ammi pinidwa na ha tekid; “Anak ku, kakurugan ta mazigat ya isassarok na tolay ta pangikerutan na Namaratu, ");
INSERT INTO agt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","te malmalogon ya isassarok na anwang ta hubu na dagum ammi ta isassarok na maba-nang ta pangikerutan na Namaratu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A pake nepagpaka-lat da ha ya inuhohug na; “A am gagangay ta kunna ten, Afu, a itta hud para ya mekerutan?” kunda. ");
INSERT INTO agt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A nangita bit tekid kapye na tumabbag. “Awan pulus ta mabalin na tolay petta mekerutan mina, ammi itta ya mabalin na Namaratu, te intu ya makapangwa ta ngamin,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","A ya uhohug ni Pedru tentu, “A itan na kamin, Afu, te sa newasa min ya ngamin kwa mi petta dumagdag kami teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","A ya tabbag hapa ni Hesus a “Kakurugan ya uhohug ku tekamuy ta maski am inya ya mangiwagak ta bali na, ikid na kabagis na, ikid na dakal na kiden, ikid na lutak na, ikid na anak na, gafu ta pakesipat na teyak ikid na pangipadangag na ta damag ku a maatadan hala sangaw yen ta minagmagatut ta katolay na sin ta kuman na natugutan na kiden, ammi medagga hapa sangaw ya mangitapang tentu. A sangaw ta ketta na pangipa-na na a maatadan hapa ta magnayun na angat. ");
INSERT INTO agt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ammi ya kadwan kiden nga mapa-polu ta ayanin a mapozan kid sangaw, a ya kadwan kiden nga mapozan ta ayanin a mapolu kid sangaw,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","A ta nekabalin na en a magtugtugut kid na ange ta ili na Herusalem, a malalang ya mafulu duwa kiden te Hesus gafu ta maaggut imunnan tekid ta dalan, yaga medyo magtalaw hapa ya kadwan kiden tolay nga dumagdag tekid. A pinaabikan ni Hesus ya mafulu duwa kiden tentu petta bidan na tekid ya makkwa sangaw tentu. ");
INSERT INTO agt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Dangagan muy ya ibar ku tekamuy, te magdulot kitanan ta ili na Herusalem, a yen sangaw ya panggafutan da ta Tolayin taga Langit, petta idarum dak ta padi kiden ikid na mangituldu kiden ta lintigen, a sa ikayat da sangaw ta masiyak. ");
INSERT INTO agt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","A am negawat dak na ta Hentil kiden nga mangibbal tekitam a amāmatan dak hapa, yaga paligatan dak kapye dak sangaw pagappan ta krus. Ammi matolayak hala sangaw ta mekatallu na araw,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A pake himebing tentu ig Santiago ikid ni Hwan nga anak ni Zibadeyu, a “Mistro, itta haen ya adangan mi teko,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“A anu hud ya ikayat muy?” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“A te ikayat mi ta makipagtogkok kami sangaw ta hebing mu am makatogkok kan sangaw ta pagariyam ta lutakin,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","“Ahu, awemuy de amu ya zigat na adangan muy. Makkwa muy hud sangaw ya magattam ta kagitta na neatad na Namaratu teyak ta zigat kin?” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“A on ay, makkwa mi,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","“A kakurugan ta paruban muy sangaw ya kagitta na zigat kin, ammi maski kunna ten a bakkan hala ta iyak ya magpili ta magyan ta hebing ku, te i Damakewan ya makkamu magpili,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","A ta pakadangag na kadwan kiden ta inadang na duwa kiden te Hesus a nalussaw kid hapa tekid, ");
INSERT INTO agt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ammi sa pinaabikan na kid ni Hesus a tinabarangan na kid. “Amu muy ya gagangay na Hentil kiden ta ikwenta da ya iturayan da kiden ta kuman na tagabu da, ");
INSERT INTO agt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ammi awemuy mina makigitta ta isina kid, te ya mayat madayawan tekamuy a maguray mina makitagabu ta kahulun na kiden. ");
INSERT INTO agt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","A ya mayat metun ta mayor na ngamin a maguray hapa makitagabu tekid. ");
INSERT INTO agt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Te maski ya Tolayin taga Langit a bakkan ta yen ya umeyan ku ta isin petta makitagabu ya tolay kiden teyak, awa iyak ya magserbi tekid, a isagapil ku hapa ya angat ku tekid petta masaka na kid,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","A tekiden nagtalib ta ili na Heriku a dumadagdag hapa tekid ya pake addu na tolay. A itta hapa ya nagdaram nga imatuttud ta pingit na kalsada en; Bartimeyo ya ngagan na nga anak ni Timeyo. ");
INSERT INTO agt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","A ta pakadangag na ta magtalib na i Hesus taga Nasaret a nagayayag na, “Ay, Hesus, Simsima ni mina Dabid, ikallak nak haen, Afu,” pakakin. ");
INSERT INTO agt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ammi nehuya na kadwan kiden tolay petta awena magsitang, ammi nepasikan na para ya iayag na, “Ay, Simsima ni mina Dabid, ikallak nak haen, Afu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","A nagtayuk hapa i Hesus a “Baran muy, petta ange hala sin,” kunna. A binaran da. “Awem la magburung, a imivwat kan, te paayagan na ka,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A alistu timollok nangiwasa ta salnuk na en, a umange te Hesus. ");
INSERT INTO agt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“A anu hapa ya pakkwam teyak?” kun ni Hesus tentu. “Ay Afu, ipaitak ya awekin pakaita,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","A ya uhohug ni Hesus tentu a “Magdulot kan la ta eyam, te nagmappya kan gafu ta pangikatalak mu teyak,” kunna, a yen hapa ya nepakaita na, a dumagdag na hapa teg Hesus ta dalan. ");
INSERT INTO agt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","A tekiden nakaabikan ta ili na Herusalem a pa nagimmang kid bit ta bikat na babali kiden ta Beffage ikid na Betanya ta Bagetay na Olibo, te pinaunnan ni Hesus ya duwa na ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Magdulot kanan ta babali kidewan, a am nakasarok kanan a maita muy sangaw ten ya urbun na kabayu nga megalut, ammi awena para la natakayan. A ubadan muy hapa, te idatang muy hapa sin. ");
INSERT INTO agt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A am itta sangaw ya mangpohut ta pangubad muy a ‘Pa masapul na bit la i Afu, te petoli na hala sangaw ta ayanin,’ kummuy.” ");
INSERT INTO agt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Umange kid mantu, a naita da hala ya kabayu en negalut ta irwangan na bali ta pingit na kalsada. A tekiden nangubad tentu a ");
INSERT INTO agt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","“Annun muy hud ubadan ya urbunina?” kunna hapa na imatayuk kiden ten. ");
INSERT INTO agt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","A nebar da hapa ya uhohug ni Hesus tekid, a nepalubus da hala. ");
INSERT INTO agt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","A ta nepangidatang da tentu a nehuklad da ya ga-gamit da ta urbunen, a nagtakay na hapa i Hesus. ");
INSERT INTO agt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","A tentu en nagtakay a imunnan hapa ya addu na tolay, a nehuklad da ya ulolat da kiden ta angen na en ta pangdayaw da tentu. A nangalap hapa ya kadwan ta kuman na don na anaw, a nehuklad da hapa ta angen na en. ");
INSERT INTO agt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A ya tolay kiden nga imunnan tentu ikid na itta kiden ta gafan na a nagayayag kid na, “Madaydayaw ya Namaratu ewan. Bendisyonam, Afu, ya umange in sin nga pinakabarim. ");
INSERT INTO agt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Bendisyonam, Afu, ya umange in nga magtogkok ta iturayan ni minakakayen Dabid. “Madaydayaw ya Namaratu nga kata-nangan na Dyos,” kunda ta pagayayag da. ");
INSERT INTO agt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","A ta datang ni Hesus ta ili na Herusalem a simarok hapa ta Simbaan na Namaratu. A tentun nabalin nangita ta ngamin ten a imuhet ha, a umange ta Betanya te furab na, a nehulun hapa ya ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A ta lalakwat tekiden ha nagtoli ta ili na Herusalem a nabisinan i Hesus ta dalan. ");
INSERT INTO agt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A tentu en nakaita ta kayu na higos ta sang adayu, a umange nagpusit ta mayan na en, te itta mina ya negindan ta don na kiden. Ammi awan haman ta mayan na, a awan para la ya kaarawan na mayor na pagmayan na. ");
INSERT INTO agt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","A gafu ta kumanen a “Maski awem na sangaw magmayan,” kunna ta kayu en, a nedangagan na hapa na ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","A ta datang da ta ili na Herusalem a simarok kid ha ta simbaanen a pinegafwanan ni Hesus pinohet ya naglaku kiden ikid na gumatang kiden, yaga pinagsikig na hapa ya lamesa na nagtali kiden ta pirak, ikid na pagtuttudan na naglaku kiden ta kalapati. ");
INSERT INTO agt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A am itta mina ya mangigadak ta agtun na ta bagaw na simbaanen a nehangat na hapa. ");
INSERT INTO agt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A pake nehuya na kid, “Anu awemuy haman manonot ya uhohug na Namaratu ta suraten, te ‘Gagangay ta balikin yan ya pakimallakan mina na ngamin tolay,’ kunna haman, ammi pinagbalin muy garay ta pagkakampatan na magdarogas ikid na magswitik,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","19","A sangaw ta marimat a nagtugut ha ikid na ituldu na kiden. Ammi ta nepakadamag na padi kiden ikid na mangituldu kiden ta iningwa ni Hesus ta simbaanen a nagbabidan da am had kunna mina na pangpapasi da tentu, te nagburung kid tentu gafu ta pangdayaw na tolay kiden ta ituldu na en tekid. ");
INSERT INTO agt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","A ta lalakwat ta pagtalib nig Hesus ta kayu en nga negaged na a nakatang na ya kayu en addet ta ramut na kiden, ");
INSERT INTO agt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","a nanonot ni Pedru ya nebar ni Hesus ta kayu en, “Itam yan, Afu, nakatang kad na ya kayu in nga negaged mu ta karabi,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","A ya uhohug ni Hesus tekid a “Yen ta pake itug muy mina ya pangikatalak muy ta Namaratu, ");
INSERT INTO agt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","te kakurugan ya uhohug ku tekamuy ta am ikatalak muy ya panguffun na tekamuy a mabalin ta ibar muy sangaw ta bagetayin ‘Umalit kan te maglattu kan ta bebay,’ a Namaratu mantu ya makkamu petta makkwa hala ya nebar muy, am kakurugan ta awemuy pagduwaduwan ya nonot muy. ");
INSERT INTO agt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“A yen ta ibar ku tekamuy ta maski am anu ya adangan muy ta pakimallak muy a ikatalak muy la ta neatad nan, a kwa muy hala sangaw. ");
INSERT INTO agt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ammi am kada makimallak kam a mappya ta pakoman muy ya nakaliwat tekamuy, petta pakoman na kam hapa na Dama muyewan Namaratu. ");
INSERT INTO agt_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ammi am awemuy pakoman ya nakaliwat tekamuy a awena kam hapa pakoman na Dama muyewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","A sangaw ta mittan a nagtoli kid ha ta ili na Herusalem a simarok kid ha ta simbaanen. A ta pagpatoyan ni Hesus ta umag na simbaanen a umange hapa tentu ya padi kiden ikid na kadwan kiden pinakadakal na tolay kiden, a pinohutan da ya gafu na tinarabaku na. ");
INSERT INTO agt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Inya hud ya nangatad ta turay mu petta maguray ka la ta ngamin tinarabakum ta isin?” kunda. ");
INSERT INTO agt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","“A itta hapa ya pohut ku tekamuy,” kunna hapa, “te am matabbag muy ya pohut ken a ibar ku hapa tekamuy ya gafu na turay ku ta tarabaku kin. ");
INSERT INTO agt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","A ya pohut kin tekamuy a inya hud ya nangatad ta turay ni mina Hwanen petta mangzigut ta tolay? Ibar muy teyak am Namaratu, ono tolay ya nangatad ta turay na?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A gafu ta napopoyung kid na ta saludsud na en tekid a dana nagbabidan da bit ta melemad am anu mina ya tabbag da tentu; “Am ibar tam ta Namaratu ya nangatad tentu a ‘Anu kawagan na mantu ta awemuy kinurug,’ kunna sangaw tekitam. ");
INSERT INTO agt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ammi am ‘Tolay la ya nangatad,’ kuntam a ikatupag na kitam sangaw na tolay kiden, te ipasikkal da haman ta Namaratu ya nangidob tentu,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","A ya tabbag da mantu te Hesus a “Awemi haman amu,” kunda. “A am awemuy mantu matabbag ya pohut ken tekamuy a awek hapa ibar tekamuy am had sin ya gafu na turay kin ta tarabaku kin,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","A nedulot na ya pagbida na tekid ta keangarigan: “Itta ya takday tolay nga nagmula ta addu na unas, a inaladan na hapa ya kaunasan na en. A sangaw namadday hapa ta agdapilan ikid na ba-bali para magtaron kiden. A sangaw nepaābāng na ya kaunasan na en, te umange bit ta takwan na lugar. ");
INSERT INTO agt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","A ta kaarawan na pagapit da a dinob na ya tagabu na en ta nangabang kiden petta alapan na mina ya abang na en. ");
INSERT INTO agt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ammi ginafut da, a pinalpaluk da kapye da pinatugut, a awan ta inalap na. ");
INSERT INTO agt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","A sangaw dinob na ha ya takday para tagabu na, a binigadan da ya ulu na yaga inamāmat da. ");
INSERT INTO agt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A sangaw dinob na ha ya takday para, a pinapasi da. A addu para ya dinob na tekid, ammi tinapangan da ya kadwan, a pinapasi da ya kadwan. ");
INSERT INTO agt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Itta para ya takday doban na ammi anak na en nga pake iddukan na, a yen ya kapozyanan na dinob na tekid, te nonotan na ta ‘Mamat kid sangaw ta anak kin,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ammi ta nepakaita na nangabang kiden ta anak na en a nagbabidan da ya pangpapasi da tentu. ‘Gagangay ta ye-yan sangaw ya makaalap ta ngamin kwa na makāunasen, a mappya mantu ta papasin tam hapa ya anak na in petta awan sangaw ta mangalap ta lutak na in, a kwa tanan sangaw,’ kunda. ");
INSERT INTO agt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","A ginafut da mantu ya anak na en, a neuhet da ta kaunasan kapye da pinapasi,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","A ya nebar ni Hesus ta kinabida na kiden a “A anu sangaw ya uray na makāunasen ta nangabang kiden, awa enna kid mantu papasin, a ipaabang na sangaw ya kaunasan na ta kadwan. ");
INSERT INTO agt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","A yen ta nonotan muy mina ya uhohug na aglavunen ta surat na en, te nebar na ta ‘Newarad na magbali kiden ya arigi en nga nepapatayuk na Namaratu tekid, ammi netoli hala, a nagbalin ta kasikanan na arigi ta ngamin bali, ");
INSERT INTO agt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","te Namaratu ya makkamu tentu, a dayawan tam hapa ya kalalaki na,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A gafu ta uhohug ni Hesus tekid a ginafut da mina petta idarum da, te naawatan da ta ikid hapa la ya pagbalinan na ta kuman na nangabang kiden ta keangarigan na en, ammi gafu ta talaw da hapa ta tolay kiden a binaybay-an da la. ");
INSERT INTO agt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","A ta nekabalin da ten a nangidob ya Hudyo kiden ta kadwan kiden Pariseyu ikid na kahulun ni Herud, petta paruban da mina i Hesus talo am masikwatan da mina ta uhohug na, petta itta mina ya pangidaruman da tentu. ");
INSERT INTO agt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","A ya uhohug da tentu a “Mistro, itta ya pohut mi teko, te amu mi ta matunung ka na tolay, a matunung hapa ya ngamin ituldum ta patarabaku na Namaratu tekitam, te awem la burungan am anu ya uray na tolay, ikid na awan ta idadumam. “A dangagan mi haen teko am ipalubus na lintig ni Moses ya pagpaga tam ta bwis ta ari na taga Roma kiden, petta amu mi am magpaga kami mina ono awan?” kunda. ");
INSERT INTO agt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ammi dana narikna ni Hesus ta yen ya pangayayyaw da mina tentu, a ya tabbag na tekid a “Annun dak hud paruban? Itan ku bit ya piraken nga ipaga muy ta bwis muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","A ta nepangigawat dan ta piraken a “A inya hud ya makāmukat ikid na makāngagan ta pirakin yan?” kunna tekid. “A sinang mukat na Ari en,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“A iatad muy mantu ta gubyernu na Ari en ya mekustu ta pangurug muy tentu, a iatad muy hapa ta Namaratu ya mekustu ta pangurug muy tentu,” kunna tekid. A nepagpaka-lat da hapa ya tabbag na en. ");
INSERT INTO agt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","A ta nekabalin na Pariseyu kiden a umange hapa tentu ya Saduseyu kiden. A itta hapa ya pohut da tentu gafu ta aweda kurugan ta matolay hala sangaw ya nagpasi kiden. ");
INSERT INTO agt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Itta hapa ya pohut mi, Mistro, gafu ta lintig ni Moses,” kunda, “te ya kinan na a am masi kan mina ya lalaki nga awan ta anak na a mappya kan ta kabagis na en ya mangatawa ta kabalwan na en petta itta kan sangaw ya anak da nga lalaki nga mekwenta ta anak na nasi en. ");
INSERT INTO agt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","A ta idi ta lugar mi a itta ya pitu na lalaki nga nagkakabagis, a nangatawa hapa ya imunnanen, ammi nasi hala ta aweda para la paganak. ");
INSERT INTO agt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A gafu ta netuldu ni mina Mosesen a ya kabagis na en ya nangatawa ta nabalu en, ammi nasi hala yen ta awena para la paganak na babbayen. A kumanen hapa ta mekatallu en. ");
INSERT INTO agt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","A sa nagpasi ya pitu kiden ta aweda para la paganak. A kabalinan na pasi na mekapitu en a nasi hapa ya babbayen. ");
INSERT INTO agt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","A am kakurugan ta matolay hala sangaw ya nagpasi kiden a had sin hud ta pitu kiden ya atawa sangaw na babbayen, te ikid ngamin ya nangatawa tentu?” kunda te Hesus. ");
INSERT INTO agt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","A ya tabbag ni Hesus tekid a “Kuga magamamangaw kanan te awemuy maawatan ya ikayat na uhohugan na surat kiden, yaga awemuy hapa amu ya pakapangwa na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Te am matolay sangaw ya nagpasi kiden a megitta kid sangaw ta anghel kiden ta langit, yen ta awedan sangaw mangatawa. ");
INSERT INTO agt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A am awemuy kurugan ta matolay hala sangaw ya nagpasi kiden a had kunna mantu na pangawatan muy ta uhohug na Namaratu te Moses ta agyan ta kalakayu en gumatgatang, te ya nebar na tentu a ‘Iyak ya Dyos nga dayawan ni Abraham, ikid ni Isak, ikid ni Hakob,’ kunna. ");
INSERT INTO agt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gagangay mantu ta matolay la yana kid, te bakkan haman ta nasi ya magdayaw ta Dyos, te ya matolay ya magdayaw tentu. A yen ta killu ya nonot muy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","A ta pagintabtabbag da para la ni Hesus ikid na Saduseyu kiden, a neddatangan na kid na takday mangituldu. A gafu ta mappya ya tabbag ni Hesus ta Saduseyu kiden a itta hapa ya pinohutan na tentu. “Mistro, ta kuman na ituldum a had sin hud ya fun na ngamin kiden lintig na Namaratu?” kunna. ");
INSERT INTO agt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","A ya neuhohug mantu ni Hesus tentu a “Ya fun na ngamin lintig na a intu yan: ‘Dangagan muy, ikamuy nga Istralita, Intu la dafu muy ya Namaratu ewan, a awan ta takwan. ");
INSERT INTO agt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A mappya mantu ta iddukan muy ta ngamin nonot muy ikid na ngamin kasikanan na bari muy.’ kunna. Yen ya kadakalan na fun na ngamin lintig na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A ya mekaduwa na fun, a intu yan: ‘Iddukam ya kagittam tolay ta kuman na pangidduk mu hala ta barim,’ kunna. A ya duwa kidin lintig ya fun na ngamin kiden lintig na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","“Kustu hapa ya tabbag mina, Mistro,” kunna hapa na takdayen, “te kakurugan ta tatakday la ya Dyos, a awan ta takwan, ");
INSERT INTO agt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","a am iddukan tam ta ngamin nonot tam ikid na kasikanan na bari tam, ikid na iddukan tam ya sakā tolay tam ta kuman na pangidduk tam ta bari tam a pake mapmappya yen ammi ta ngamin kiden iatang tam,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","A ya uhohug hapa ni Hesus tentu gafu ta mappya ya inuhohug na a “Kakurugan ta assang na la ya awena pakatolay teko na Namaratu,” kun ni Hesus tentu. A yen hapa ya abat na pagpohut da tentu, te mamat kid na. ");
INSERT INTO agt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","A ta pangituldu para la ni Hesus ta umag na simbaanen a itta hapa ya pinohutan na ta tolay kiden. “Ya kuman na ituldu na mangituldu kiden a ibar da ta simsima ni mina Dabid ya Mangikerutanen nga nekari na Namaratu. A kakurugan hapa ya ibar da, ammi had kukunna simsima na? ");
INSERT INTO agt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Te ya nesurat ni Dabid nga nepaita na Kahalwa na Namaratu tentu a ‘Itta ya nebar na Namaratu ta dafu ken, te “E ka sin magtogkok ta kanawan kin, te ikita ya mangabak ta katapil mu kiden, petta iko sangaw ya makkamu ta ngamin,” kunna.’ ");
INSERT INTO agt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“A am ‘Dafu ken,’ kun ni mina Dabid ta pagtogkokan na Namaratu a had kukunna mantu magbalin ta simsima na para?” kun ni Hesus tekid. A matalakan ya tolay kiden mangdangag ta ituldu na. ");
INSERT INTO agt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A ya kadwan kiden para netuldu na tekid a “Itan muy ta awemuy parigan ya mangituldu kiden, te ikayat da itugtugut ya barawasi na pangituldu da petta dayawan na kid na tolay. ");
INSERT INTO agt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","A am itta ya pabuya ikid na gimung a pilin da para ya pake kaispotan na agtuttudan petta malogon kid maita. Ammi magimmamappya kid la, ");
INSERT INTO agt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","te ikid hala ya mangsistema ta babay kiden nabalu ta panguffun da tekid, petta magubat da ya bali da. A am itta kid ta paggagimungan a makimallak kid ta mabayag petta pahig na kadwan kiden ta abikan kid ta Namaratu. Ammi pake dakdakal sangaw ya pama-gang na Namaratu tekid ammi ta kadwan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","A sangaw umange nagtuttud i Hesus ta batug na agila-nugan na tolay kiden ta pirak ta umag na simbaanen, a itan na la ya ange kiden mangila-nug ta pirak da. Umange hapa ya addu na naba-nang, a dakal hapa ya nela-nug da. ");
INSERT INTO agt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","A umange hapa ya takday babbay nga napanglaw, a intu la nela-nug na ya duduwa la na sinsilyu, kustu ta lugar na binting. ");
INSERT INTO agt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","A binaran ni Hesus ya ituldu na kiden petta madangag da ya ibar na gafu ta babbayen. “Itan muy ya babbay ewan, kakurugan ta ad-addu ya nela-nug na ammi ta pagdadaggan na ngamin kiden nela-nug na kadwan kiden, ");
INSERT INTO agt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","te intu neatad da ya sobra na pagba-nangan da, ammi tentu a neatad na ya magserbi mina tentu gafu ta kapanglaw na, te sa neatad na ya ngamin katolayan na,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","A ta neuhet nig Hesus ta simbaanen a makibidan kid na takday ituldu na, a “Itam, Mistro, ya batu kiden nga nepadday da ta simbaanin, awa ispot kid kontodu ngamin bali in,” kun na ituldu na en tentu, te dappug kid na batu nga nataga, a nasalsalnuk kid abat ta utun. A ya tabbag hapa ni Hesus tekid a ");
INSERT INTO agt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","“Pake dayawan muy ya kapadday na ta ayanin simbaanin, ammi ya ibar ku tekamuy a sa marabba sangaw ya ngamin bali in yan abat ta awan pulus ta mesalnuk ta maski takday la na batu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","A tentu en imatuttud ta utun na bagetay na Olibo ta batug na simbaanen a umange tentu ig Pedru, ikid ni Santiago, ikid ni Hwan, ikid ni Andres, te itta ya pohutan da tentu gafu ta binida na ta simbaanen. ");
INSERT INTO agt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Afu, damagan mi haen am kanu sangaw na araw ya nebar men nga kaperdi na simbaanen. A awan hud ta imunnan petta pakaitan mi ta tanagay na ya datang na?” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","A ya tabbag na en tekid a “Pake itan muy ta awemuy sangaw maayayyaw,” kunna, ");
INSERT INTO agt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","“te addu sangaw ya ange nga magingagan ta ngagan kin, te ‘Iyak ya Kristu nga Mangikerutan tekamuy,’ kunda sangaw, a addu sangaw ya mapadagdag da ta pangayayyaw da tekid. ");
INSERT INTO agt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","A am itta sangaw ya madamag muy ta gubat ta agyan muy ikid na gubat ta adayu a awemuy la malalang ta isin kid, te gagangay ta dumatang ya kumanin kapye na idatang na pagaddetan na arawin yan. ");
INSERT INTO agt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Te pagka-ma makigubat ya takday gubyernu ta takwan, a pagka-ma magkāgubgubat ya kadwan kiden tribu, yaga magkakattway hapa ya kadwan kiden tolay nga maginggubgubat, a dumatang hapa sangaw ya addu na agbabisin ikid na lunig ta magdaduma na lugar. Ammi ye-yen kid na zigat ya pamegafwanan la na kadakalan na pagzigātān. ");
INSERT INTO agt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“A pake imugudan muy sangaw, te gafutan da kam sangaw petta idarum da kam ta mangpa-gang tekamuy gafu ta pangurug muy teyak, a palpalukan da kam sangaw ta atubang na tolay kiden ta kapilya, a mepaatubang kam hapa sangaw ta gubernador da kiden ikid na ari da kiden, petta ipasikkal muy tekid ya gafu na tarabaku muy. ");
INSERT INTO agt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Te mappya ta mepadangag ya damag na pangikerutan na Namaratu ta ngamin tolay ta ngamin kiden lugar ta paglelehutin kapye na idatang na pagaddetan na arawin yan. ");
INSERT INTO agt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","A am idarum da kam sangaw a awemuy la burungan ya uhohugan muy, te am ittan sangaw ya kustu na paguhohug muy a yen na sangaw ya datang na uhohugan muy, te bakkan ta ikamuy ya maguhohug, te ya Kahalwa na Namaratu sangaw ya makisagapil tekamuy. ");
INSERT INTO agt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“A am itta sangaw ya mangurug ta ipadangag muy a mazigatan hapa sangaw ya kadwan, te papapasi na kid na kabagis da. A papapasi na kadwan ya anak da kiden nga mangurug, a papapasi na kadwan para ya dadagkal da kiden. ");
INSERT INTO agt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","A ikatupag na kam sangaw na tolay kiden ta ngamin kiden lugar gafu ta pangurug muy teyak. Ammi ya ngamin kiden maketurad abat ta pagaddetan na pagzigātān da a yen kid sangaw ya mekerutan. ");
INSERT INTO agt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“A am maita muy hapa sangaw ta ipatayuk dan ya pake dulayen nga ikatupag na Namaratu ta umag na simbaanen, (te yen ya nesurat ni mina Danyelen), a yen mina ya pagbabakwit na itta kiden ta Hudeya petta umahat kid mina ta bagetay kiden. ");
INSERT INTO agt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","A ya itta en ta bagaw na bali na en a awena mina nonotan ya kwa na kiden ta umag na bali. ");
INSERT INTO agt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","A ya magtarabaku ta uma awena mina tolin ya barawasi na en nga netabnak na ta lutak. ");
INSERT INTO agt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ammi kakallak sangaw ya matarun ikid na magpasusu ta isina kid na araw, te matalantan kid sangaw gafu ta pagdammatan da. ");
INSERT INTO agt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","A mappya mantu ta dana makimallak kam ta bakkan ta agirid ya datang na dulayen, talo am mazigatan kam ta pagbakwit muy. ");
INSERT INTO agt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Te am dumatang sangaw ye-yen na araw a yen sangaw ya ketta na dakal na pagzigātān nga pake dakdakal ammi ta ngamin kiden pagzigātān abat ta nekapadday na lutak abat ta ayanin. A am nagpasan a awan na ha sangaw ta kumanen maski am kanu. ");
INSERT INTO agt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","A am mabayag mina ya araw na pagzigātānen a awan mina ta makalillik ta zigaten, ammi paāssangan sangaw na Namaratu ya kabayag na petta mekerutan ya tolay na kiden nga pinili na. ");
INSERT INTO agt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“A am madangag muy sangaw ya ‘O itan muy, itta in ya Kristu nga mangikerutan tekitam,’ kumin, ono am ‘Yo, itta tewan,’ kunna, a awemuy malat kurugan, ");
INSERT INTO agt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","te itta hala sangaw ya matulad na mangikerutan ikid na matulad na aglavun. A am itta kid na a mangwa kid hapa ta dakal na pakaitan ikid na pagpaka-latan na tolay kiden, te pangayayyaw da tekid talo am itta hapa ya mapadagdag da ta maski tolay kiden na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","A mappya ta awemuy sangaw kaliwatan yan, te dana nebar kun haman tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“A am nabalin na sangaw ye-yen na pagzigātān a mavit hapa ya pagsugiram na bilag ikid na hulan, ");
INSERT INTO agt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","yaga makutukutet hapa sangaw ya bitwan kiden ta langit, a magkāhunnak kid. ");
INSERT INTO agt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","A yen sangaw ya pakaita na ngamin tolay ta lattog na Tolayin taga Langit, te dumagut sangaw nga imatogkok ta kulam kiden, a mehulun sangaw tentu ya ngamin kasikanan ikid na kalalakin na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A doban na hapa sangaw ya anghel na kiden petta uknudan da ya ngamin tolay na kiden nga mangurug tentu ta ngamin paglelehutin. ");
INSERT INTO agt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“A intu mina pagnonotan muy ya keangarigan na taggaten, te am lumattog na ya lappaw na kiden a yen ya pakaitan ta darun na. ");
INSERT INTO agt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","A kumanen hapa sangaw am dumatang na ya ngamin kiden nabidak tekamuy ta ayanin, te yen sangaw ya pakaitan ta tanagay na ya pagtolik. ");
INSERT INTO agt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A kakurugan hapa ya ibar ku tekamuy ta matolay para la ya kadwan kiden tekamuy am mamegafun ya ngamin nabidak tekamuy ta ayanin. ");
INSERT INTO agt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Te gagangay ta imawan sangaw ya ngamin langitewan ikid na lutakin, ammi awena mauli na ngamin inuhohug ku tekamuy. ");
INSERT INTO agt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ammi am kanu sangaw na araw ikid na oras ya pagtolik ta lutakin a awan ta makkamu, maski ta anghel kiden, a maski teyak, te intu la makkamu i Damakewan. ");
INSERT INTO agt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mappya mantu ta imugudan muy petta dana nakaparan kanan, te awemuy amu am kanu sangaw ya araw na. ");
INSERT INTO agt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nonotan muy ya keangarigan na nagpataron ta bali na en ta tagabu na kiden, te umange magpasyar ta adayu na lugar, a dana nebar na ya ngamin tarabaku da, yaga nebar na hapa ta imugudan ya maggwardya en ta irwangan, a sangaw nagtugut. ");
INSERT INTO agt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","A mappya mantu ta imugudan muy, te awemuy amu am kanu sangaw ya datang na makābali en, te mabalin ta furab, ono tangngan na hiklam, ono magkarawan, ono lalakwat. ");
INSERT INTO agt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","A imugudan muy talo am datangan ta kam masidug. ");
INSERT INTO agt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A ya ngamin nabidak tekamuy ta ayanin a ibar ku hapa ta ngamin tolay, imugudan muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A ta nekabalin ni Hesus nangituldu ta ituldu na kiden a itta para la ya dwangagaw abat ta pyesta na Simana na Hudyo kiden am mangan kid ta pan nga awan bumlad. A nagmamiting hapa ya padi kiden ikid na mangituldu kiden, te pagbabidan da am had kunna mina na panggafut da te Hesus ta awena pakkamu na tolay kiden, pettam papasin da. ");
INSERT INTO agt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Ammi awetam mina gafutan ta ketta na pyesta en, talo am magtatapil ya tolay kiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","A sangaw umange ig Hesus ikid na ituldu na kiden ta iten Betanya ta bali ni Simonen nga nagkangaw ta idi. A tekid para la nagkakan a itta hapa ya babbay nga himebing te Hesus, a ibbalan na hapa ya botelya na bangog nga pake mangina am melaku, a tinappok na ya hul na en kapye na neburud ya mayan na en ta ulu ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ammi nagporay ya kadwan kiden ta babbayen, a nehuya da. “Anu haman ta isayang mu ya bangogen? ");
INSERT INTO agt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pade awa mangina mina am melaku, petta meatad mina ya paga na ta pobre kiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ammi nehuya na kid hapa ni Hesus; “Bay-an muy, annun muy hud ihuya ya babbayin? awa mappya haman ya iningwa na teyak. ");
INSERT INTO agt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sigida itta haman tekamuy ya pobre kiden, petta mauffunan muy kid am ikayat muy, ammi teyak a awek sangaw sigida tekamuy. ");
INSERT INTO agt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A iningwa na babbayin ya mabalin na te linuggudan na ya barikin ta bangogin, petta dana meparan ta ketanam na. ");
INSERT INTO agt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A kakurugan hapa ya uhohug ku tekamuy ta maski am had sin na lugar ya pakepadangagan na damag ku ta ngamin paglelehutin a megindan hapa mebida ya iningwa na babbayin yan, te panadamdaman da sangaw tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","A ta nekabalin na kumanen a nagtugut i Hudas Iskaryote nga takday ituldu ni Hesus, te umange nakitulag ta padi kiden, petta italaba na i Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","A natalakan kid hapa ta bida na tekid, a nekari da tentu ya pirak. A yen hapa ya pamegafu ni Hudas nga magapag ta mappya na araw ta pangitalaba na te Hesus. ");
INSERT INTO agt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A ta napolu en araw ta pyesta na Simana na Hudyo kiden a mangan kid la ta panen nga awan bumlad, ikid na mangiatang kid ta kalneru, te panadamdaman da ta araw na nepangilillik na Namaratu ta gingginafu da kiden. A umange hapa ya ituldu kiden ni Hesus tentu, te pohutan da am had sin na lugar ya pangiparanan da mina ta pamurab da ta Simana. ");
INSERT INTO agt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A dinob na ya duwa la tekid, “E kam ta ili, te masimmu muy sangaw ya magtattun ta tākalamba na danum, a dagdagan muy la. ");
INSERT INTO agt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","A sangaw am nakasarok kanan ta bali a ibar muy ta makābali en, ‘Dinob na kami ni Mistro, te itan mi kan ya lugar na panganan mi ta pamurab mi ta Simana in ta bali min,’ kummuy, ");
INSERT INTO agt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","a ituldu na sangaw ya dakal na silid ta utun, a yen sangaw ya pangiparanan muy ta pamurab tam,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","A umange kid a naita da hala ya bali en nga nebar ni Hesus tekid, a neparan da ya pamurab da ta Simana. ");
INSERT INTO agt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A ta furab a dumatang ig Hesus ikid na mafulu duwa kiden ituldu na ta bali en. ");
INSERT INTO agt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","A tekid para la nagkakan a naguhohug i Hesus tekid. “Kakurugan ta takday tekamuy ya mangitalaba sangaw teyak,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A nagdamdam kid na hapa ta nebar na en, a ya tagtakday kid hapa ya nagpohut tentu; “Iyak hud ya kinamen, Afu?” kunda. ");
INSERT INTO agt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","“Intu sangaw mangitalaba teyak ya itta sin nga makipagkammat teyak ta pingganin,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“A gagangay ta masi sangaw ya Tolayin taga Langit ta kuman na nesurat na aglavunen, ammi maski kunna ten a kakallak hala sangaw ya mangitalaba teyak, te nagasgasat mina ta awena neanak,” kunna ha tekid. ");
INSERT INTO agt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","A tekid para la nagkakan a nangalap i Hesus ta pan kapye na nepakimallak, kapye na hapa ginadgadwa, a sangaw nesaned na ta ituldu na kiden. “Yeh, kanan muy yan te yeyan ya megitta ta barikin,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A sangaw inalap na hapa ya basu na binarayangen kapye na ha nepakimallak, a ");
INSERT INTO agt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Yeyan hapa ya megitta ta dagak nga mangipasikkal ta pakitulagan na Namaratu, te mapagarut sangaw ya dagakin petta mapakoma ya liwat na addu na tolay. ");
INSERT INTO agt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ammi ibar ku hapa tekamuy ta awek sangaw makipaginum tekamuy ta kumanin abat ta panginum tam sangaw ta bagu na inuman ta pangayayat tam ta pagariyan ni Damakewan,” kunna. A negawat na hapa tekid, a sa uminum kid hapa. ");
INSERT INTO agt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","A ta nekabalin da uminum a nagkakansyon kid, kapye da umange ta Bagetay na Olibo. ");
INSERT INTO agt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","A ya uhohug ni Hesus tekiden nagtugtugut ta dalan a “Amuk ta pakigungayān dak sangaw, te yen ya nesurat na aglavunen; ‘Papapasi sangaw na Namaratu ya magtaron a makutkutet sangaw ya kalneru kiden,’ kunna ta surat na en. ");
INSERT INTO agt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ammi am matolayak hala sangaw a mapa-polu yak sangaw ammi tekamuy nga ange ta iten Galileya,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","“O maski pakigungayān na ka na kadwan, Afu, aweta ka sangaw pakigungayān,” kunna hapa ni Pedru tentu. Ammi ya uhohug ni Hesus tentu a. ");
INSERT INTO agt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","“Maski ilemad nak hala sangaw ta mamillu ta hiklamin yan ta awena para la pagtareknay na manuk ta kapidwa na pagtareknay na,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ammi pake nepapilit na ha ni Pedru, “Ay awan, Afu, maski ikabat dak sangaw teko papasin a aweta ka sangaw ilemad,” kunna ha. A kumanen hapa ya nebar na kadwan kiden ituldu na. ");
INSERT INTO agt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","A ta datang da ta bagetayen a nagdulot kid ta lugaren nga nagngagan ta Getsimani, a ya uhohug ni Hesus tekid a “Magtuttud kanan ta isin te eyak bit yo tewan makimallak,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ammi nehulun na hapa ig Pedru ikid ni Santiago ikid ni Hwan. A sangaw nepagka-ma na hapa ya pagdamdam na, a pake nagburung na. ");
INSERT INTO agt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Kuga ipasik de ya sikan na damdam kin. Magyan kam la sin, a imugudan muy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A sang imadayu tekid kapye na nagtakab ta lutak, a nepakimallak na ta pagpasan na Namaratu ya zigat na pasi na am mabalin mina. ");
INSERT INTO agt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Amang, amuk ta mabalin ya ngamin teko, a azim haen ya zigatin yan. Ammi maski kunku a bakkan mina ta yen ya magdulot, te mappya ta ikayat men ya idulot ku,” kunna ta pakimallak na. ");
INSERT INTO agt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A tentu en nagtoli teg Pedru a masidug kid na, te hiklam, a “Anu masidug kan, Simon, awem hud maattaman ya awan masidug ta maski takday la na oras? ");
INSERT INTO agt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Awemuy la masidug, te makimallak kam mina petta awemuy mina maayayyaw, te maski am malogon ya nonot muy a makafuy ya bari muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A umange ha nakimallak ta kuman na intu en. ");
INSERT INTO agt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A sangaw nagtoli ha ta ituldu na kiden, a masidug kid ha, te awena makaladdang na mata da. A mamat kid hapa magsitang. ");
INSERT INTO agt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A ta mekatallu na neange na tekid a “Aranan, awan bale am masidug kam la ta bannag muy, te ittan ya ange na mangitalaba ta Tolayin taga Langit petta igawat na ta awan kiden mangurug ta Namaratu. ");
INSERT INTO agt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Imivwat kanan, te entanan, te ittan ya mangitalaba teyak,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","A ta pagbida para la ni Hesus tekid a dumatang na i Hudasen, a nehulun hapa tentu ya addu na tolay nga dinob na pinakadakal da kiden ikid na padi kiden, a nagibbal kid hapa ta kampilan ikid na paluk. ");
INSERT INTO agt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A dana nebar na mangitalaba en ya pagsenyas na sangaw ta kahulun na kiden petta amu da ya gafutan da. “Ya amuyan ku sangaw a yen ya gafutan muy, te intu yen, a appiyan muy ya panggafut muy tentu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","A nagdaretyo i Hudas te Hesus a “Itta yak O, Afu,” kunna tentu, kapye na inamu. ");
INSERT INTO agt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","A yen hapa ya nepanggafut da tentu. ");
INSERT INTO agt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ammi ka-ma la sinukkut na takday kahulun ni Hesus ya kampilan na en, a kinattab na ya takday tekid ta bangbang na en a newasik na. Intu kinattab na ya tagabu na kadakalan na padi. ");
INSERT INTO agt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A ya uhohug ni Hesus ta tolay kiden nanggafut tentu a “Anu dulayak hud na tolay, petta endak gafutan konsu kampilan ikid na paluk ta kuman na panggafut muy ta tulisan? ");
INSERT INTO agt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kinanghahaw itta yak haman tekamuy ta simbaanen nga nangitultuldu, anu bakkan ta yen ya nanggafutan muy teyak? Ammi gagangay ta kunna sin ya tarabaku muy petta magdulot ya nesurat na aglavun kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","A yen hapa ya nepangiwagak na ituldu na kiden tentu, a nagbabilag kid. ");
INSERT INTO agt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","A ta nepangitugut da te Hesus a dumagdag hapa ya takday babagu nga nagsalnuk para la ta ulolat na en, a nepagka-ma da hapa ginafut, ");
INSERT INTO agt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ammi newasik na ya ulolat na en, a nakabilag nauhagan. ");
INSERT INTO agt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","A ya nanggafut kiden te Hesus a neange da ta bali na kadakalan na padi, te yen ya nagaammungan na padi kiden ikid na mangituldu kiden ikid na pinakadakal na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ammi te Pedru a dana tinultulitul na kid hapa abat ta bagaw na bali en, a nakipagtuttud hapa ta maggwardya kiden, te maggukup hapa ta afuy da en. ");
INSERT INTO agt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A ya padi kiden ikid na ngamin kiden nagkonsihal a apagan da ya mangipasikkal ta liwat ni Hesus petta itta mina ya pangpapasin da tentu, ammi awan ta naapagan da, ");
INSERT INTO agt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","te maski am addu ya nagtayuk nga nagtulad tentu a nagimpagsil haman ya inuhohug da. ");
INSERT INTO agt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","A ta kapozyanan na a nagtayuk ya kadwan mangipasikkal ta tulad da, a ya uhohug da hapa a ");
INSERT INTO agt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ya kuman na nadangag mi ta uhohug na inin a itta kan ya pakapangwa na nga mangkutkutet ta simbaanen nga pinadday na tolay, te takwan kan ya patayukan na ta las-ud na talluhaw nga awena paddayan na tolay,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ammi maski kunna ten a nagimpagsil hala ya inuhohug da. ");
INSERT INTO agt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","A nagtayuk hapa ya kadakalan na padi, kapye na hapa nagpohut te Hesus. “Awan hud ta tabbag mu? Anu mantu ya uhohugam ta ipaliwat na inin kid teko?” kunna. ");
INSERT INTO agt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ammi awena la nagasitang ni Hesusen. A nagsitang ha ya padi en, “Ibar mu mantu am iko ya Ari en nga Anak na Namaratu ewan,” kunna. A ya tabbag hapa ni Hesus tentu ");
INSERT INTO agt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“A iyak ay, a ibar ku hapa tekamuy ta makipaita sangaw ya Tolayin taga Langit nga makipagtuttud ta agtuttudan na Seppakapangwa ta Ngamin, te magtoli hala sangaw sin nga imatogkok ta kulam kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","“Agayaya!” kun na hapa na kadakalan na padi ta pakadangag na ta uhohug ni Hesus, kapye na pinissang ya salnuk na pagpadi na gafu ta katupag na en ta inuhohug ni Hesus. “Dulay ya nauhohug na tolayin yan, te igitta na ya bari na ta Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","A masapul hud para ya mangipasikkal ta liwat na awa ikitanan hapa la ya nakadangag ta uhohug na. Anu mantu ya uray muy tentu?” kunna hapa ta kahulun na kiden. A sa ikayat da ta mapapasi. ");
INSERT INTO agt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","A inuparan na hapa na kadwan kiden, otturu tinappanan da hapa ya mukat na kapye da sinilsiltuk. “O, ibar mu am inya ya nagsiltuk teko, te malalaki ka haman maglavun,” kunda. A sinilsiltuk da hapa na maggwardya kiden. ");
INSERT INTO agt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","A ta pagimbestigar da para la te Hesus a itta la i Pedru ta bagaw na bali en. ");
INSERT INTO agt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","A ta pagtalib na takday babbay nga tagabu na kadakalan na padi a naita na i Pedru nga maggukup ta afuyen, a naguhohug tentu; “Maski iko hapa ya takday kahulun ni Hesusen nga taga Nasaret,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","“Amuk hud am anu ya ikayat mu uhohugan teyak,” kunna hapa, kapye na sang umadayu ta tagad ta sasarokanen. ");
INSERT INTO agt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ammi nalasin na hapa na takday ha na babbay, a netuldu na i Pedru ta katayukan na kiden. “Yeyan hapa ya takday kahulun na,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ammi nelemad na ha. Awena para la nabayag a nepasikkal da ha na kadwan kiden nga imatayuk ta iten; “Talaga ta iko hapa ya takday kahulun na, te taga Galileya ka,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","“Atsi O, pagasingan ta Dyos am tulad ya uhohug ku, awek malat amu ya tolayina,” kunna ha naglemad. A nagtareknay ha ya manuk ta pidwa na, ");
INSERT INTO agt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","a yen hapa ya nepakanonot ni Pedru ta uhohug ni Hesus tentu, te ‘Mamillu ka mangilemad teyak ta awena para pagtareknay na manuk ta kapidwa na,’ kunna. A insigida nagtangit i Pedru en. ");
INSERT INTO agt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","A tentun araw a nagkakampat para la ya padi kiden ikid na pinakadakal na tolay kiden, a nagtatulagan da ta masi mina i Hesus. A sangaw ginalutan da kapye da neuhet, te enda nedarum ta atubang ni Pilato nga gubernador taga Roma. ");
INSERT INTO agt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","A ta nepagpatayuk dan tentu ta atubang na gubernadoren a nagpohut hapa i Pilato tentu; “Anu, iko hud ya nebar da en nga ari na Hudyo kiden?” kunna te Hesus. “Iko mina ya mangibar,” kunna hud la ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A addu hapa ya nepaliwat na padi kiden tentu ta gubernadoren, ammi awena pulus nagsitang ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","“Awan hud ta tabbag mu, awem hud madangag ya ngamin ipasikkal da ta liwat mu?” kunna hapa ni Pilato tentu. ");
INSERT INTO agt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ammi awena kad tumabbag ta maski takday la na uhohug, a pake nepagpaka-lat na gubernadoren. ");
INSERT INTO agt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A ya gagangay na gubernadoren ta idi am araw na mayor na pyesta na Hudyo kiden a pohetan na ya takday mabalud nga pinili na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A ta nepangidarum da te Hesus a dana ittan ya nabalud kiden nga nakapapasi ta pakitapil da ta gubyernu na taga Roma kiden, a i Barabas ya ngagan na takday tekid. ");
INSERT INTO agt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A gafu ta nagaammung na ya tolay kiden a inadang da te Pilato ta pohetan na ya takday nabalud ta kuman na gagangay na en ta idi. A ya uhohug ni Pilato tekid a ");
INSERT INTO agt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","“Ikayat muy mantu ta pohetan ku ya ari muy in Hesus?” kunna tekid, ");
INSERT INTO agt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","te dana amu na ta nedarum na pinakadakal da kiden gafu ta katupag da tentu. ");
INSERT INTO agt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ammi ya padi kiden ikid na pinakadakal na tolay kiden a sinansanat da ya tolay kiden petta adangan da ya pangpohet na te Barabas. ");
INSERT INTO agt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","A sangaw pinidwa ni Pilato ya pohut na ta tolay kiden, “A anu mantu ya uray muy ta kinan muyin nga ari na Hudyo kiden?” kunna. ");
INSERT INTO agt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A giaggayan kid na ta “Pagappam ta kayu,” pakakin kid. ");
INSERT INTO agt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Te anu hud, anu hud ya liwat na?” kunna hapa. Ammi pake giaggayan kid ha ta masikan; “Pagappam ta kayu, pagappam ta kayu,” pakakin kid. ");
INSERT INTO agt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","A gafu ta ikayat ni Pilato nga pagustun ya tolay kiden a pinohet na mantu i Barabas, a nepapaligat na i Hesus, kapye na negawat ta suddalu kiden petta pagappan da. ");
INSERT INTO agt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","A ta nepanggawat na suddalu kiden tentu a neange da bit ta umag na bali na gubernadoren, a sa pinagkalihung da tentu ya ngamin batalyon da. ");
INSERT INTO agt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","A inazi da ya salnuk na en, kapye da nesalnuk tentu ya darag na ga-gamit nga kuman na salnuk na ari, a nangwa kid hapa ta sangngat na sit kapye da nesangngat ta ulu na en. ");
INSERT INTO agt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","A sangaw daydayawan da kampon ta “Ihi, malalaki ya Ari na Hudyo kiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A pinalpaluk da hapa ya ulu na en ta biraw kapye da inuparan. A namalentud kid hapa ta atubang na en nga ape mangdayaw tentu. ");
INSERT INTO agt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","A tekid na nabalin a inazi da ya salnuk na en darag, kapye da ha netoli ya dana en salnuk na, a neuhet dan petta pagappan da. ");
INSERT INTO agt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","A nesimmun da hapa ya takday tolay nga nagngagan ta Simon nga taga Sirene, a intu hala ya dama ni Alehandru ikid ni Rufo. A nagtalib mina, te bagu nagafu ta lawan a simarok mina ta ili, ammi kinalbatan da nga pinagagtu ta pagappan ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","A ta datang da ta nengagan da en Golgota (intu hala kettayan na Balontok), ");
INSERT INTO agt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","a pinenum da mina i Hesusen ta binarayang nga kinihun da ta apdu, ammi inawena. ");
INSERT INTO agt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","A ta nekabalin na nepagpaappa da tentu a nagbabinunutan da ya barawasi na kiden. ");
INSERT INTO agt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nwebe ta lalakwat ya nepagpaappa da tentu, ");
INSERT INTO agt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","a itta hapa ya nesurat da ta utun na ulu na en petta mebasa ya pangpapasin da tentu. “Ye-yan ya Ari na Hudyo kiden,” kun na surat da. ");
INSERT INTO agt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Itta hapa ya duwa na tulisan nga pinagappa da ta dwaakub ni Hesus, ");
INSERT INTO agt_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","petta magdulot ya dana nebar na aglavunen ta surat na en, te “Isipat da sangaw ta dulay kiden na tolay,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","A kada itta ya nagtalib ta nagappan ni Hesus a nelutab da ya pangidadula da tentu. “Agu ta itta ya pakapangwam nga mangkutukutet ta simbaanen kapyem ha patayukan ta las-ud na talluhaw? ");
INSERT INTO agt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ikerutam mantu ya barim ta pakapangwamina, a dumagut kan ta krusina,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tumubbat hapa ya padi kiden ikid na mangituldu kiden; “Intu kan ya nangikerutan ta kadwan tolay, ammi awena mekerutan ya bari na en,” kunda. ");
INSERT INTO agt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Intu pon ya Mangikerutan nga Ari na Istralita kiden, a mappya mantu ta dumagut na ta krus, petta itta mina ya pangurugan tam tentu,” kunna hapa na kadwan. A kumanen hapa ya pangidadula na tulisan kiden tentu nga pinagappa da ta dwaakub na en. ");
INSERT INTO agt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A tentun pagtangnganan na araw a nagsugiram na ya ngamin na paglelehut da en ta kuman na hiklam abat ta tallu na oras. ");
INSERT INTO agt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","A ta alas tres ta furab a nagayag i Hesus ta masikan, “Ilay, Ilay, lama sabaktani,” kunna ta agsitang na Hudyo kiden. A ya ikayat na uhohugan na ayag na en a “Dyos ku, Dyos ku, anu haman ta nagtalekudan nak,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","“Anu, ayagan na de i Eliyas?” kunna hapa na kadwan kiden nga nagbuya tentu. ");
INSERT INTO agt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","A nagbilag hapa ya takday tekid nga ange nangalap ta kuman na ga-gamit kapye na tinunan ta suka, a sangaw nesukil na ta ud na biraw te Hesus petta inuman na mina, a “Itan tam bit la am enna sangaw ikerutan ni Eliyasen,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A tentu en ha nagayag ta masikan a yen hapa ya nepakasukkut na kahalwa na en. ");
INSERT INTO agt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","A negindan hapa napissang ya zingzingen nga ga-gamit ta umag na Simbaan na Namaratu. Namegafu napissang ta utun abat ta akban. ");
INSERT INTO agt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","A ta atubang na nagappan na en a itta ya kapitan na suddalu kiden, a tentu en nakaita ta nepagaswang ni Hesus ta pasi na a “Kakurugan kad ta Anak na Namaratu yan,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","A ta medyo adayu ta nagappan ni Hesus a itta hapa ya addu na babay nga nangita tentu, a nehulun hapa tekid i Mariya Magdalena, ikid ni Mariya nga hina nig Santiago assang ikid ni Hose, ikid ni Salome, ");
INSERT INTO agt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","te ikid hapa ya kanayun nehulhulun nga nanguffun te Hesus ta idi ta lugar na Galileya. A addu kid para na babay nga dumadagdag te Hesus tentu en dumatang ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","A itta hapa ya takday lalaki nga naba-nang nga konsihal na Hudyo kiden, intu ngagan na i Hose nga taga ili na Arimateya. A nabayag na hapa nangipapa-na ta araw na pangikerutan na Namaratu. A gafu ta furab na ta kaatubangan na araw na agimmang a neturad ni Hose ya ange ta bali ni Gubernador Pilato, petta adangan na ya bari ni Hesus, petta itanam na. ");
INSERT INTO agt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ammi ta pakadangag ni Pilato ta nasin a nepagpaka-lat na hapa, te pahig na ta awena para la nasi. A pinaayagan na mantu ya kapitan na suddalu, petta damagan na am kurug ta nasin i Hesus. ");
INSERT INTO agt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","A ta nepakadamag nan ta nasin a nepalubus na hala ta alapan ni Hose ya bari na en. ");
INSERT INTO agt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","A ta nepangidagut nan ta bari na en a finutefutan na ta bagu na furaw na ga-gamit nga ginatang na, a enna netanam ta kababagu na tanam nga nakali ta batu ta kuman na kweba. A sangaw nadokalig na ya dakal na batu ta irwangan na tanamen petta namunitan. ");
INSERT INTO agt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","A ig Mariya Magdalena ikid ni Mariya nga hina na takday Hose a dana nehulun kid hapa, petta itan da ya pangitanaman na tentu. ");
INSERT INTO agt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","A ta nekabalin na araw na agimmang a ig Mariya Magdalena ikid ni Mariya nga hina ni Santiago ikid ni Salome a umange kid gumatang ta bangog, petta iluggud da mina ta bari ni Hesus. ");
INSERT INTO agt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","A tentu nagkarawan ta Liggu a naggaganwat kid, a dumatang kid ta agyan na tanam en ta lalattog na bilagen. ");
INSERT INTO agt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Ammi ya uhohug da hapa ta pakatugtugut da para la ta dalan a “Inya hud sangaw ya manguffun tekitam nga mangazi ta batu en nga nelitup da ta tanamen?” kunda, te dappug haman na batu. Ammi ta datang da a dana naazin, a simarok kid. ");
INSERT INTO agt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","A ta nepakasarok dan a neitan da ya takday babagu nga nagbarawasi ta furaw a imatuttud ta bikat na irwanganen, a nakagtut kid. ");
INSERT INTO agt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“Awemuy la magtalaw, te amuk ta apagan muy i Hesus taga Nasaret nga pinagappa da, ammi awan na sin, te natolay hala. Maski itan muy ya nagiddan na bari na en,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","“Ammi alalag muy magtoli ta ituldu na kiden, aglalo te Pedru, te ibar muy sangaw tekid ta imunnan i Hesus tekid ta iten Galileya. ‘Maita muy kan hala sangaw ten ta kuman na nebar na en tekamuy,’ kummuy sangaw tekid,” kunna. ");
INSERT INTO agt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","A tekiden nakauhet ta tanamen a bumilag kid na ta talaw da en, ammi awan ta nakibidan da ta dalan, te kuga nagtalaw kid. ");
INSERT INTO agt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","A kumanen natolay hala i Hesus ta pake nagkarawanen ta araw na Liggu, a intu apolu nakipaitan na i Mariya Magdalena nga nagpatugutan na ta pitu na anitu ta idi. ");
INSERT INTO agt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","A intu ya umange nangipadangag ta kadwan kiden kahulun ni Hesus. Nagtatangit kid para la ta pagdamdam da, ");
INSERT INTO agt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","a tekiden nakadangag ta natolay hala i Hesus, te nakipaita hapa te Mariya, a aweda kurugan. ");
INSERT INTO agt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","A ta nekabalin na kumanen a nakipaita ha i Hesus ta duwa para na ituldu na tekiden nagtugtugut ta dalan, ammi aweda bit la nalasin ta damo, te kuman na takwan ya mukat na. ");
INSERT INTO agt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","A tekiden hapa nagtoli ta kadwan kiden kahulun da a nebar da hapa tekid, ammi aweda hapa kurugan. ");
INSERT INTO agt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","A sangaw nakipaita hapa i Hesus ta mafulu takday kiden ituldu na tekiden nagkakan, a pake nehuya na kid hapa ta kawan na pangurug da ikid na katuyag na nonot da, gafu ta aweda kinurug ya uhohug na nakaita kiden tentu. ");
INSERT INTO agt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A ya takday para na uhohug nga nesirak na tekid a intu yan: “E kam sangaw ta ngamin kiden lugar ta paglelehutin, te ipadangag muy ya damag na Namaratu ta ngamin tolay. ");
INSERT INTO agt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","A ya mangurug sangaw ta ipadangag muy ikid na magzigut a mekerutan kid, ammi ya awan kiden mangurug a mekabat kid sangaw ta pangtaguhali na Namaratu. ");
INSERT INTO agt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A ya mangurug kiden sangaw teyak a mehulun hapa sangaw tekid ya pakapangwa na Namaratu petta itta ya mangipasikkal ta ipadangag da, te patugutan da sangaw ya anitu na seanitu kiden, a makauhohug kid hapa sangaw ta takwan kid na agsitang nga aweda inadal. ");
INSERT INTO agt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","A maski am keibbalan da sangaw ya madagat, ono am keinuman da ya tamay a awan sangaw ta makkwa tekid. A isi-ged da hapa sangaw ya kamat da ta magtatākit, a magmappya kid hapa,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","A ta nekabalin na naguhohug tekid a ka-ma la timullu ta langit, a nakipagtogkok ta hebing na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","A ya dinob na kiden a umange kid hapa nangipadangag ta ngamin kiden lugar, a nepehulun na Namaratu ya pakapangwa na tekid petta mangipasikkal ta ipadangag da.");
INSERT INTO agt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Kofun ku, Teyopilo. Yen ta nagsuratak teko petta amum ya kakurugan gafu te Hesus Kristu, Addu hapa ya kadwan kiden nga nagimbestigar ta naknakkwa ta agyan tamin ta ayanen na araw, a nelista da ya ngamin nepadangag na kadwan kiden nakaita ikid na nanguffun te Hesus ta ketta na en. A gafu ta pake naimbestigar ku hapa ya ngamin naknakkwa gafu te Hesus a nesurat ku ngamin ta isin petta amum ta kurug ya ngamin netuldu teko. ");
INSERT INTO agt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","A ta idi ta nepagari para la ni Herud ta lugar na Hudeya a itta ya padi na relisyon na Hudyo kiden nga nagngagan te Zikaraya, a nedagga hapa ta padi kiden ni Abias. A intu hapa atawa na i Lisabet nga simsima ni mina Aron. ");
INSERT INTO agt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","A amu hapa na Dyos ta matunung ya duwa kiden, te kanayun kurugan da ya ngamin kiden lintig na Namaratu, a awan ta pakehuyan da. ");
INSERT INTO agt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ammi intu dulay te awan ta anak da, te awena magāānak na babbayen, te yaga bakbakat na hapa, a laklakay na hapa ya atawa na en. ");
INSERT INTO agt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","A ta datang na araw na pagtarabaku na padi kiden ni Abias ta simbaan na Namaratu a nehulun hapa i Zikaraya, ");
INSERT INTO agt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","a intu ya napili nga simarok tatakday ta pake umag na simbaanen petta apangan na ya bangogen ta kuman na gagangay na tarabaku na padi kiden. ");
INSERT INTO agt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","A ta oras na pangiapang na ta bangogen a nagyan ya tolay kiden ta bagaw na simbaanen, a nakimalmallak kid la. ");
INSERT INTO agt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A sangaw nepagka-ma ni Zikaraya ya anghel na Namaratu nga nagmatakar ta kanawan na pangiapangan na en, ");
INSERT INTO agt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","a nakagtut i Zikaraya en ta talaw na en. Ammi ya uhohug na anghelen tentu a ");
INSERT INTO agt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","“Awem la magtalaw,” kunna, “te itta yak sin gafu ta dinangag na Namaratu ya pakimallak muy ikid na atawam. A pasinapān na kanan, petta maganak kam hala sangaw ta lalaki, a Hwan sangaw ingagan muy tentu. ");
INSERT INTO agt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","“A bakkan la teko ya pake matalakan ta keanak na, te sakā matalak hapa sangaw ya addu na tolay, ");
INSERT INTO agt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","te maita da sangaw ta pake malalaki na tolay na Dyos. A awena sangaw uminum ta binarayang ono kompormi na madagat na inuman. A mapasinapān sangaw ta Kahalwa na Namaratu ta maski pagyan na para la ta sirat na hina na en. ");
INSERT INTO agt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“A addu hapa sangaw ya patolin na nga Istralita kiden ta dafu da ewan Namaratu, ");
INSERT INTO agt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","te mapsinapan sangaw ta kagitta na nonot ikid na pakapangwa ni Eliyas. A intu sangaw ya mapmapolu ammi ta Dafu tamen, petta pagnonotan na ya dadagkal kiden ta kuman na nonot na abbing. “A pagbabawin na sangaw ya masoysoy kiden petta magtunung ya nonot da, petta dana makaparan ya tolay kiden ta datang na dafu da en,” kunna kan hapa na anghelen tentu. ");
INSERT INTO agt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","A ya uhohug hapa ni Zikaraya a “Anu hud ya pakkamun ku ta dumatang hala ya kuman na nebar men teyak, te laklakayak haman, a pake bakbakat hapa ya atawak?” kunna. ");
INSERT INTO agt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A ya tabbag hapa na anghelen a “Amum hala sangaw, te iyak i Gabriyel nga kanayun magyan ta atubang na Namaratu ewan. A intu hala ya nangidob teyak petta ipadangag ku teko ya kuman na nebar ken ta ayanin. ");
INSERT INTO agt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A magdulot hala sangaw ta arawen nga nekari na Namaratu, ammi gafu ta awem kinurug ya inuhohug ken a magumal kan sangaw, a awem na sangaw makasitang addet ta nagdulot na ya kuman na inuhohug ken teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A gafu ta pake nabayag i Zikaraya ta umag na simbaanen a nagburung na ya tolay kiden nga nagaindag tentu, a pahig da ta anu ya dulay. ");
INSERT INTO agt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ammi tentu en nakauhet a awena nakauhohug tekid, a yen ya nakkamun da ta itta ya nagmatakar tentu ta umag na simbaanen. A gafu ta awena nakasitang a nagsenyas la tekid. ");
INSERT INTO agt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","A ta nagaddetan na araw na pagtarabaku na ta simbaanen a dumatang hala ta bali na en. ");
INSERT INTO agt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","A ta nekabalin na en a natarun hala ya atawa na en Lisabet. A ya uhohug na en hapa a “Mappya mantu la ya Namaratu, te nekallak nak hala ta kumanin, petta awek na sangaw mamat ta sakā tolay ku kiden,” kunna kan na nonot na. ");
INSERT INTO agt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","A ta kaarawan na katarun ni Lisabet a itta ya takday balatang nga nagngagan te Mariya, a nagyan ta ili na Nasaret ta lugar na Galileya. A dana nakiatawa hapa ta takday simsima ni mina Ari en Dabid nga nagngagan ta Hose taga Nasaret hapa, ammi aweda para la nagdorug. A ta mekānnamen hulan na katarun ni Lisabeten a nagmatakar hapa ya anghelen Gabriyel te Mariya, te dinob na Namaratu tentu. ");
INSERT INTO agt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A tentu en nakipaita te Mariya a “Namaratu ya makkamu teko, Aboy, a itta hapa ya pangdayawan na teko, te iko ya pinili na,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","A nagburung hapa i Mariya en gafu ta uhohug na en, a “Anu panaw ya ikayat na uhohugan teyak?” kunna kan na nonot na. A ya uhohug ha na anghelen tentu a ");
INSERT INTO agt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","“Awem la magburung, Mariya, te dayawan na ka na Namaratu ewan, ");
INSERT INTO agt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","te matarun ka sangaw, a maganak ka sangaw ta lalaki, a ingagan muy sangaw te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","“A am dakal na sangaw ya anak mu a pake malalaki na tolay, a amu sangaw na ngamin tolay ta intu hala ya Anak na Namaratu ewan. A intu hapa sangaw ya pagbalinan na Namaratu ta ari, te intu ya ari muyen nga nekari na Namaratu nga metali ta minakakay na en Dabid. ");
INSERT INTO agt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","“A awan sangaw ta addet na pagari na, te intu hala sangaw ya makkamu ta ngamin kiden tolay na Namaratu addet ta addet,” kunna ha na anghelen tentu. ");
INSERT INTO agt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","A ya uhohug hapa ni Mariya a “Onay, ammi had kun na katarun ku, te awek para la nakidorug ta lalaki?” kunna. ");
INSERT INTO agt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","“A maski, te ange sangaw teko ya Kahalwa na Namaratu, a ihuga na sangaw ta matarun ka. A pake dayawan da sangaw ya anak men, te ibar da sangaw ta awan ta pakehuyan na, te kagitta hala na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“A em sangaw itan ya Anti men Lisabet nga awan nagan-anak ta idi, te maski am bakbakat na a ittan ya annam na hulan ta katarun na, ");
INSERT INTO agt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","te maski am anu ya ngagan na a awan ta awa makkwa na Namaratu awa makkwa na ya ngamin,” kunna ha na anghelen tentu. ");
INSERT INTO agt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","“A kwa nak mantu la na Dafu tamewan, petta dumatang hala ya kuman na inuhohug mu teyak,” kunna hapa ni Mariya. A ta nepaguhohug nan ta kumanen a nagtugut hapa ya anghelen. ");
INSERT INTO agt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A ta nekabalin na anghelen a nahukal hapa i Mariya ta pake lalakwat, a imalistu umange ta takday ili ta lugar na Hudeya, ");
INSERT INTO agt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","a nagdulot ta bali na Anti na en Lisabet. A tentu en simarok ta bali na a “Namaratu ya makkamu teko, Anti,” kun ni Mariya tentu. ");
INSERT INTO agt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","A ta nepakadangag ni Lisabet ta uhohug na en a timollok kan hapa ya asitayen ta umag na sirat na, a ka-ma la napasinapān i Lisabet ta Kahalwa na Namaratu, ");
INSERT INTO agt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","a nagsitang hapa ta masikan; “Iko, Mariya, ya pake nagāsāt ammi ta ngamin kiden bābāy, a Dyos hapa ya mangbendisyon ta anak mina. ");
INSERT INTO agt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ammi anu hud ya pangdayawan na Namaratu teyak ta doban na teyak ya magbalin ta hina na Dafu kewan? ");
INSERT INTO agt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","On, Aboy, amuk na ta iko sangaw ya maganak tentu, te teyaken nakadangag ta inuhohug men teyak ta ayanen a timollok hapa ya asitay kin ta talak na ta umag na sirat kin. ");
INSERT INTO agt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A yen ta nagāsāt kan hapa, Aboy, te kinurug mu ya uhohug na Namaratu nga nepepadangag na teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A gafu ta matalak hapa i Mariya a ka-ma la magnot hapa: “Napannu ya nonot ku ta pangdayaw ku te Afu. ");
INSERT INTO agt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","A magayayatak ta Dyos nga mangikerutan teyak, ");
INSERT INTO agt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","te maski pobre yak a pinili nak. A ta ngamin kiden tolay nga meanak sangaw, a awan sangaw ta awa makanonot ta iyak ya nagāsāt ta bendisyon na Dyos. ");
INSERT INTO agt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Te ya Namaratu ewan nga seppakapangwa na Dyos a nekallak nak hala ta dakal na bendisyon. Madaydayawan mantu ya Dafu tamewan, ");
INSERT INTO agt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","te ikallak na ikallak ya ngamin mamat tentu, a kumanen hapa ta simsima da kiden. ");
INSERT INTO agt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ammi ta ngamin kiden magparayag a nepaita na ya kasikan na kamat na, te kinutkutet na kid gafu ta pagparayag da. ");
INSERT INTO agt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A ya masikan kiden magturay a pinaakban na kid, ammi pinautun na hapa ya alinnak kiden. ");
INSERT INTO agt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A pake binattug na hapa ya mabisin kiden, ammi nagtalekudan na la ya naba-nang kiden. ");
INSERT INTO agt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A pinagdulot na la ya nekari na en ta gingginafu tam kiden, te nedulot na ya panguffun na ta tolay na kiden, ");
INSERT INTO agt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","te nanonot na i mina Abraham ikid na simsima na kiden addet ta addet,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","A nagyan i Mariya te Anti na en Lisabet addet ta tallu hulan kapye na dimmatang ta agyan na. ");
INSERT INTO agt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","A ta datang na paganak ni Lisabet a naganak hala ta lalaki, ");
INSERT INTO agt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","a enda hapa itan na kahulun na kiden ikid na karuba na kiden gafu ta kallak na Namaratu tentu, a nekokolu da hapa ya anak na en. ");
INSERT INTO agt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","A ta mekawalu en araw a nagaammung kid ha gafu ta banggitan ni Zikaraya ya anak da en, te yen ya gagangay na Hudyo ta pagbunyag da. A ikayat na kahulun na kiden ta makikanāgān ya asitayen ta dama na en Zikaraya, ");
INSERT INTO agt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ammi ya uhohug na hina na abbingen a “Bakkan, te Hwan ya ngagan na,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“A anu haman ta Hwan, bakawa itta hud ya kumanen na ngagan ta kadwan kiden kahulun muy?” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Otturu nagsenyas kid hapa ta dama na abbingen am anu ya ikayat na ta ngagan na. ");
INSERT INTO agt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A nagpaalap i Zikaraya ta pagsuratan na petta isurat na ya ngagan na, a ya nesurat na a “Hwan ya ngagan na,” kunna. A pake nepagpaka-lat na kahulun da kiden. ");
INSERT INTO agt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ammi ta nepakasurat ni Zikaraya ta ngagan na anak na en a ka-ma la nakasitang na hapa, a dinayawan na ya Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A gafu ta kumanen a nahigalan hapa ya ngamin kiden karuba da, a kanayun bibidan da ya dumatang ta agyan da addet ta sumaned ta ngamin kiden tolay taga Hudeya. ");
INSERT INTO agt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","A ya ngamin kiden nakadangag ta pakabidan da ta abbingen a pake netug da hapa ta nonot da, a “Anu panaw ya pagbalinān na abbingin yan?” kunda, te yaga naita da ta itta ya bendisyon na Namaratu tentu. ");
INSERT INTO agt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A ta nepakasitang ni Zikaraya en a napasinapān hapa ta Kahalwa na Namaratu, otturu naglavun; ");
INSERT INTO agt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Madaydayawan ya Namaratu ewan nga Dafu na Istralita kiden, te nanonot na ya tolay na kiden nga nagtalekudan na ta idi, petta ikerutan na kid ta zigat da. ");
INSERT INTO agt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","A kustu hapa ya uhohug na aglavun kiden nga nepeuhohug na Namaratu tekid ta palungu araw, te patayukan nan tekitam ya mangikerutan nga meanak ta simsima ni mina Dabid, ");
INSERT INTO agt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","petta mekerutan kitam ta mangikatupag kiden nga mangpazigat tekitam. ");
INSERT INTO agt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A nekallak na kitam hapa ta kuman na nekari na ta dadagkal tam kiden, ");
INSERT INTO agt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","te nanonot na ya tulag na en nga nepagasingan na ta gingginafu tamen Abraham. ");
INSERT INTO agt_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Te intu nebar na ta ikerutan na kitam ta mangikatupag tekitam, petta awan na sangaw ta talaw tam, am awa idulot tam la ya pangurug tam tentu, ");
INSERT INTO agt_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","petta meduma kitam hapa gafu ta matunung ya nonot tam ikid na gagangay tam addet ta awetam pasi,” kunna. A ya uhohug hapa ni Zikaraya ta anak na en nga bagu neanak a ");
INSERT INTO agt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Iko sangaw, Aleng, ya mapmapolu ammi ta Dafu tam, te paguhohugan na na ka sangaw na Namaratu ewan, petta iparam ya ange na tekitam. ");
INSERT INTO agt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Te ipadangag mu ya pangikerutan na ta tolay na kiden, ikid na pagpakoma na ta liwat da kiden. ");
INSERT INTO agt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","A gafu ta allak na Namaratu tam, ikid na idduk na tekitam, a palattogan na ya dakar na tekitam nga nagafu ta langit. ");
INSERT INTO agt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Te madakaran ya itta kiden ta sugiram, ikid na itta kiden ta ngahab na pasi. A ituldu na kitam ta dalan na kappyanan tam,” kunna. A yen ya addet na lavun na. ");
INSERT INTO agt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A dumakal la dumakal ya anak nig Zikaraya, a nagsikan hapa ya nonot na. Ammi tentu en dakal a kanayun nagyan ta kawanan na babali addet ta makipaita sangaw ta kagitta na kiden nga Istralita. ");
INSERT INTO agt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","A ta kaarawan na nekeanak ni Hwan a ya ari en nga taga Roma a namadday hapa ta bagu na lintig, petta melista ya ngamin kiden tolay nga magyan ta ngamin kiden lugar ta pagariyan na en. ");
INSERT INTO agt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","A ye-yan hapa ya napolu en pakelista na tolay kiden nga negindan ta paggubernador ni Kirinu. ");
INSERT INTO agt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A gafu ta sa melista kid mina ta lugar na gingginafu da kiden ");
INSERT INTO agt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","a masapul ta magtugut bit hapa ig Hose en ikid na atawa na en Mariya ta ili na Nasaret ta iten Galileya, te ange kid ta ili na Betlihem ta lugar na Hudeya, te yen ya ili na gingginafu da en mina Dabid ta idi. ");
INSERT INTO agt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A yen ya umeyan da nga pakelistan, ammi tanagay na hapa ya araw na paganak ni Mariya en. ");
INSERT INTO agt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","A ta datang da ta ili na Betlihem a napannu ya ili en ta tolay kiden nga ange magpalista, a awan ta pagammakan nig Hose en. ");
INSERT INTO agt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A gafu ta nadatangan i Mariya ta paganak na a umange kid ta agsigongan na baka ikid na kabayu. A yen mantu ya naganakan na ta napopolu en anak na. A dana binabbad da ta kuman na gagangay da, kapye da nepaidda la bit ta anganan na baka. ");
INSERT INTO agt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A sangaw ta hiklam ta nekeanak na abbingen a itta hapa ya lālāki kiden nga mangipastu ta kalneru da kiden ta bikat na ili en, ");
INSERT INTO agt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","a ka-ma la nagmatakar ya anghel na Namaratu tekid, a nadakaran na kid na dakar na Namaratu, a pake nagtalaw kid na. A ya uhohug na anghelen tekid a, ");
INSERT INTO agt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","“Awemuy la magtalaw O, te mappya ya ipadangag ku tekamuy. A pakatalakan hapa sangaw na ngamin tolay, ");
INSERT INTO agt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","te ittan ya mangikerutan tekamuy nga bagu neanak ta ayanin ta ili na Betlihem. A intu hala ya ari muyen Kristu nga nekari na Namaratu tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","“A itan muy sangaw awa kustu ya uhohug ku tekamuy, te am e kam ta ili ewan a maita muy hala sangaw ya bagu neanak nga nepaidda da ta anganan na baka, a bagu para la ya babbad na kiden,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A ta nekabalin na anghelen a ka-ma la umaddu ya sakā anghel na kiden ta langit, a gisakansyon kid hapa nga nagdayaw ta Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Madaydayawan ya Namaratu ewan, nga mangikallak ta tolay na kiden, te ittan ya dinob na en nga mangpakappya tekid,” kun na kansyon da. A sangaw limitap kid ha ta langitewan. ");
INSERT INTO agt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","A ya uhohug hapa na mangipastu kiden ta nepagtugut na anghel kiden a “Entanan mantu ta ili ewan, te entam itan ya abbingen nga nepadangag na Dafu tamen tekitam,” kunda. A alistu kid hapa umange. ");
INSERT INTO agt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A naita da hala ig Mariya ikid ni Hose, a itta hala ya asitayen nga imaidda ta anganan na baka. ");
INSERT INTO agt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","A binida da hapa tekid ya uhohug na anghelen gafu ta abbingen. A sangaw nesaned da hapa ya damag da en ta kadwan kiden tolay ta ili, ");
INSERT INTO agt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","a nagpaka-lat kid hapa gafu ta bida na lālāki kiden tekid. ");
INSERT INTO agt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ammi te Mariya a awena la nagsitsitang, te netatug na la ya ngamin nadangag na ikid na dumatang tentu. ");
INSERT INTO agt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A ta nepagtatugut na manaron kiden ta kalneru, a nagtoli kid ta agyan na kalneru da kiden, a nagkakansyon kid ta dalanen nga nagdaydayaw ta Namaratu gafu ta ngamin nadangag da ikid na naita da, te kustu ya ngamin inuhohug na anghelen tekid. ");
INSERT INTO agt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","A ta nepagpasa na waluhaw a binanggit da hapa ya asitayen, te yen haman ya gagangay na Hudyo kiden. A nengagan da hapa te Hesus, te yen ya nebar na anghelen te Mariya ta awena en para la natarun. ");
INSERT INTO agt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","A gafu ta lintigen nga netuldu ni Moses ta Hudyo kiden a mehangat ya bagu naganak nga simarok ta simbaan na Namaratu, te itta kan ya pagzigmanan na addet ta appatafulu araw. A ta nekabaggaw ni Mariya ta pagzigmanan na a inalap da i Hesus ta ili na Herusalem petta igawat da ta Namaratu, ");
INSERT INTO agt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","te ya takday lintig na Namaratu tekid a kwa na kan ya napolu en neanak na tagtakday pagatawan. ");
INSERT INTO agt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","A enda hapa peatang ya duwa na lummun ono duwa na kalapati, te yen hapa ya nebar na Namaratu ta lintig na en tekid. ");
INSERT INTO agt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A itta hapa ten Herusalem ya takday laklakay nga nagngagan te Simyon. A pake matunung hapa na tolay nga mamat ta Namaratu, te nabayag na hapa nagaindag ta pangikerutan na Namaratu ta Istralita kiden. A gafu ta napasinapān hapa ta Kahalwa na Namaratu, ");
INSERT INTO agt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","a dana nepakkamu na Namaratu tentu ta awena para la masi addet ta maita na bit apolu ya Ari en Kristu nga nekari na Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","A gafu ta pangwalwag na Kahalwa na Namaratu tentu a umange ta simbaanen, a yen ta dana ittan ten ta pangidatang nig Mariya te Hesus petta idulot da ya kuman na gagangay na lintig da en. ");
INSERT INTO agt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","A ta nepakaita ni Simyon ta asitayen a enna pegawat, a inahakupan na hapa nga nedayaw ta Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ay, Afu, maski masi yak na ta kuman na inuhohug mu teyak, ");
INSERT INTO agt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","te naitak na ya dinob min nga mangikerutan, a matalakanak na. ");
INSERT INTO agt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Te ye-yan na abbing ya nekari men nga umange sin, petta ikaru na ya liwat na ngamin tolay. ");
INSERT INTO agt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","“A ye-yan mantu, Afu, ya mangpadakar ta Hentil kiden hapa, petta amu da ya kakurugan na Dyos, a intu hapa sangaw ya mangatad ta pakadayaw na tolay mu kiden nga Istralita,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","A pake nakagtut hapa ig Hose en ikid ni Mariya ta uhohug ni Simyon gafu ta anak da en, a nepakimallak na kid hapa. ");
INSERT INTO agt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","A ya uhohug na para ta hina na abbingen a “Dangagam, Aboy, ya ibar kin teko, te palattogan sangaw na Namaratu ya itta ta nonot na ngamin tolay gafu ta abbingin yan, a mapaakban hapa sangaw ya addu na Istralita gafu tentu, ikid na addu hapa sangaw ya mapātā-nāng. A maski am intu ya pakaitan ta ketta na Namaratu tekitam a addu sangaw ya magsoysoy tentu. A gafu ta ikatupag da sangaw a pake matakitan hapa sangaw ya nonot mu ta kuman na takit na amuku nga mekaddug,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","A ta pagbida para la ni Simyon tekid a itta hapa ya pake bakbakat na aglavun nga nakasimmu tekid. A ya ngagan na hapa a Ana, a anak hapa ni Fanwel nga takday simsima ta tribu ni Aser. A walufulu appat ya darun na, ammi nabalun, te pitu darun bit ya pagatawa na, kapye na nasi na la-laay na en. A sigida nagyan la ya bakbakaten ta simbaanen ta araw pase hiklam, te awena bit nonotan ya mangan gafu ta pakimallak na. A ta nepakaita na hapa ta abbingen a nedayaw na hapa ta Namaratu, a binida na hapa ta kadwan kiden, te sakā indagan da hapa ya panguffun na Namaratu ta taga Herusalem kiden. ");
INSERT INTO agt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","A gafu ta nedulot nig Mariya ikid ni Hose ya ngamin nebar na Namaratu ta lintig na en gafu ta anak da en a dumatang kid hala ta ili na Nasaret ta lugar na Galileya, ");
INSERT INTO agt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","a yen hala ya dumakalan ni Hesusen. A nagsikan hapa ya bari na ikid na nonot na, a umaddu ya adal na ikid na kalalaki na, a kanayun inuffunan na Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","A ta kaassang para la ni Hesus a nagpatotoli ya dadagkal na kiden ta ili na Herusalem ta kada darun, te e kid makipagayayat ta pyesta na Hudyo kiden gafu ta panadamdaman da ta araw na nepangilillik na Namaratu ta gingginafu da kiden ta lutak na Egipto. ");
INSERT INTO agt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","A ta mekamafulu duwa na darun ni Hesus a umange kid ha ta pyesta en ta kuman na gagangay da en, a nehulun da hapa i Hesus. ");
INSERT INTO agt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","A ta kabalinan na pyesta en a nagtugut kid ha, te dumatang kid ta agyan da. Ammi intu dulay, te aweda amu nig Mariya ta nasirak i Hesus ta ili en, ");
INSERT INTO agt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","te pahig da la ta sakā nagtugut hapa nga nakihulun ta kadwan kiden kahulun da. A tekid na nakatugtugut addet ta takday araw a apagan dan i Hesusen ta kahkahulun da kiden ikid na kofun da kiden, ammi awan na, aweda naapagan. ");
INSERT INTO agt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","A gafu ta kumanen a tinoli dan apagan ta gafan da en abat ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","A ta mekatallu en araw a naita da ta umag na simbaanen, ammi nehulun haman ta mangituldu kiden nga gitogkokan nakibibida tekid. ");
INSERT INTO agt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A dinayawan da hapa ya pagtabbag na ikid na kalalaki na nonot na. ");
INSERT INTO agt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","A ta nepakaita nig Mariya tentu a nagpaka-lat kid tentu, a nehuya na hapa na hina na en; “Aleng, anu haman ta nasirak ka ta isin, te pake nagburung kami ni Damam nga nagapag teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“A annun dak haman burungan? Dana amu muy mina ta itta yak ta bali ni Damakin,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ammi aweda amu ya ikayat na uhohugan tekid. ");
INSERT INTO agt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A ta nekabalin da ten a himulun na i Hesus tekid, te nagtatugut kid ha nga ange ta agyan da en ta ili na Nasaret. A malologon hapa i Hesus ta ngamin patarabaku da tentu. Ammi te Mariya a netatug na la ta nonot na ya ngamin dumatang tekid gafu te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","A dumakal la i Hesus addet ta nagtuyag na hapa ya bari na ikid na nonot na, a mappya la mappya ya gagangay na ta kuman na ikayat na Namaratu, a kumanen hapa ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","A ta nepagpasa na addu na darun a i Sisar Tiberyo ya ari ta ngamin pagturayan na taga Roma kiden, a ittan ya mafulu lima darun na pagturay na. A i Ponsyo Pilato hapa ya gubernador ta lugar na Hudeya, a i Herud hapa ya magibbal ta lugar na Galileya, a ya kabagis na en Felipe ya magibbal ta lugar na Itureya ikid na lugar na Tarakonita. A i Lisanyas ya magibbal ta lugar na Abilena. ");
INSERT INTO agt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","A ya kadakalan na padi kiden ta ili na Herusalem a i Annas, a sangaw ya manuhang na en Kaifas. A ta kaarawan na inin kid a napasinapān i Hwanen nga anak ni Zikaraya ta uhohug na Namaratu tentu en nagyan ta kalafukanen. ");
INSERT INTO agt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","A sinaned na hapa ya ngamin kiden lugar ta naggwadamdammang na Karayan na Hurdan, a kinasaba na ya tolay kiden. “Ulin muy ya gagangay muy, a zigutan ta kanan, petta pakoman na kam hapa na Namaratu ta liwat muy,” pakakin tekid. ");
INSERT INTO agt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","A gafu ta ange ni Hwan a nagdulot ya nesurat na aglavunen mina Isayas, te ya uhohug na en a “Itta sangaw ya makipaita nga magayayag ta kalafukanen, te intu sangaw iayayag na ya tabarang na ta tolay kiden, petta magparan kid mina ta datang na Dafu tamen, petta malogon mina ya ange na tekid. ");
INSERT INTO agt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Te mapātā-nāng sangaw ya alinnak, ikid na mapaakban ya ata-nang, a mapatunung ya killu, ikid na maazi ya ketumpapan. ");
INSERT INTO agt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","A maita sangaw na ngamin tolay ya pangikerutan na Namaratu,” kunna ta surat na en. ");
INSERT INTO agt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A ya nekasaba ni Hwan ta umange kiden pazigut tentu a “Anu kuga magimmamappya kanan ta pagzigut muy. Pahig muy hud ta melillik kam sangaw ta pama-gang na Namaratu gafu ta pagzigut muy? ");
INSERT INTO agt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Dana ipaita muy mina ta naulin ya nonot muy, kapye muy magzigut. A awemuy pahig ta melillik kam sangaw gafu ta simsima kam ni mina Abrahamen, te ibar ku tekamuy ta itta ya pakapangwa na Namaratu nga magpabalin ta batu kidin ta simsima ni mina Abraham. ");
INSERT INTO agt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Negitta kanan ta kayu nga tokadan na Namaratu ewan, te dana neparan nan ya watay na en, a awena la mabayag a tokadan na ya kayu kiden ta agyan na ramut da kiden. Te ya ngamin kiden kayu nga awan magmayan ta mappya a tokadan na kid kapye na kid iwarad ta afuy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A ya pohut da hapa tentu a “A anu mina ya tarabakun mi petta mekerutan kami mina?” kunda. ");
INSERT INTO agt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A ya tabbag na hapa tekid a “Am itta ya duwa na barawasi muy a iatad muy ya takday ta awanen ta barawasi. A ya nasurok ta kanan na a isipat na hapa ya awanen ta kanan,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A umange hapa pazigut tentu ya magsingir kiden ta bwis na tolay kiden nga nesaad na gubyernu na taga Roma, a pinohutan da hapa ta “Anu mina ya tarabakun mi petta makaparan kamin hapa?” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A ya tabbag na hapa tekid a “Awemuy pagsurokan ya singiran muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Yaga suddalu hapa ya umange pazigut, a pinohutan da hapa ya tarabakun da mina, a ya tabbag na tekid a “Awemuy persan ya tolay kiden petta atadan da kam ta pirak, a awemuy kid hapa tātālawan, te matappag kanan mina ta tandan muyen,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A gafu ta ketta ni Hwan nga mangaskasaba ta tolay kiden a nekatalak da ta tanagay na de ya mangikerutanen nga nekari na Namaratu ta dadagkal da kiden, a nonotan da am intu hala i Hwanen. ");
INSERT INTO agt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ammi ya uhohug ni Hwan tekid a “Itta yak sin nga mangzigut tekamuy ta danumin gafu ta liwat muy kiden, ammi itta sangaw ya umange ta gafan ku nga pake dakdakal ya pakapangwa na ammi teyak, te maski la awek megitta makitagabu tentu ikid na mangubad ta sapatos na kiden. A intu sangaw ya mangpasinap tekamuy ta Kahalwa na Namaratu. Ammi ya awan kiden magbabawi a pa-gangan na kid sangaw ta afuy, ");
INSERT INTO agt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","te itta ya kuman na pagsap na ta tolay, a am nabalin na magsap a uknudan na sangaw ya semayan, ammi apangan na sangaw ya kupat na kiden,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","A ta nekabalin na tolay kiden nagzazigut a umange hapa i Hesus nga pazigut te Hwan. A tentu en hapa nakazigut a nakimallak, a kuman na bimangrit na ya langit, ");
INSERT INTO agt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","a nagsunak ya Kahalwa na Namaratu nagpotun tentu ta kuman na kalapati, a nepagka-ma na hapa ya naguhohug tentu ta langit; “Iko ya Anak ku nga matakit ta nonot ku. Pake matalakanak teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","A addu para ya nekasaba ni Hwan ta netabarang na tentu en nangipadangag ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Ammi te Gubernador Herud a ginubatan na ya atawa na kabagis na en, a awena dangdangagan ya tabarang ni Hwan tentu awa dinaggan na hud la ya liwat na, te nepebalud na i Hwan gafu ta pangihuya ni Hwan tentu. ");
INSERT INTO agt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","A ta nepangrugi ni Hesus ta tarabaku na en a ittan ya tallufulu darun na. A kumanin hapa ya ngagan na dadagkal na kiden: I Hose en nga atawa ni Mariya a intu ya mekwenta ta dama ni Hesus. A ya dama ni Hose a Heli nga anak ni Matat. ");
INSERT INTO agt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","A i Matat ya anak ni Lebi, A i Lebi ya anak ni Melki, a i Melki ya anak ni Hanni, ");
INSERT INTO agt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","a i Hanni ya anak ni Hose nga anak ni Matatiyas, a i Matatiyas ya anak ni Amos, a i Amos ya anak ni Nahum, a i Nahum ya anak ni Esli, a i Esli ya anak ni Nage, ");
INSERT INTO agt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","a i Nage ya anak ni Maat, a i Maat ya anak ni Matatiyas nga anak ni Semi, a i Semi ya anak ni Hose nga anak ni Huda, ");
INSERT INTO agt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","a i Huda ya anak ni Hwanan, a i Hwanan ya anak ni Resa, a i Resa ya anak ni Zorubabel, a i Zorubabel ya anak ni Saltiyel, a i Saltiyel ya anak ni Neri, ");
INSERT INTO agt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","a i Neri ya anak ni Melki nga anak ni Adi, a i Adi ya anak ni Kosam, a i Kosam ya anak ni Elmadam, a i Elmadam ya anak ni Er, ");
INSERT INTO agt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","a i Er ya anak ni Hoswe, a i Hoswe ya anak ni Elizer, a I Elizer ya anak ni Horim, a i Horim ya anak ni Matat nga anak ni Lebi nga anak ni Simyon, ");
INSERT INTO agt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","a i Simyon ya anak ni Hudas, a I Hudas ya anak ni Hose nga anak ni Honan, a i Honan ya anak ni Eliakim, ");
INSERT INTO agt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","a i Eliakim ya anak ni Meleya, a i Meleya ya anak ni Menna, a i Menna ya anak ni Matata, a i Matata ya anak ni Natan, a i Natan ya anak ni Dabid, ");
INSERT INTO agt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","a i Dabid ya anak ni Dyesi, a i Dyesi ya anak ni Obed, a i Obed ya anak ni Bowas, a i Bowas ya anak ni Sala, a i Sala ya anak ni Nasyon, ");
INSERT INTO agt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","a i Nasyon ya anak ni Aminadab, a i Aminadab ya anak ni Admin, a i Admin ya anak ni Arni, a i Arni ya anak ni Esron, a i Esron ya anak ni Peres, a i Peres ya anak ni Huda, ");
INSERT INTO agt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","a i Huda ya anak ni Hakob, a i Hakob ya anak ni Isak, a i Isak ya anak ni Abraham, a i Abraham ya anak ni Tera, a i Tera ya anak ni Nakor, ");
INSERT INTO agt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","a i Nakor ya anak ni Serug, a i Serug ya anak ni Ragaw, a i Ragaw ya anak ni Peleg, a i Peleg ya anak ni Heber, a i Heber ya anak ni Selar, ");
INSERT INTO agt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","a i Selar ya anak ni Kaynan, a i Kaynan ya anak ni Arpaksad, a i Arpaksad ya anak ni Sem, a i Sem ya anak ni Nowe, a i Nowe ya anak ni Lamek, ");
INSERT INTO agt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","a i Lamek ya anak ni Matusalem, a i Matusalem ya anak ni Enok, a i Enok ya anak ni Hared, a i Hared ya anak ni Mahalalel, a i Mahalalel ya anak ni Kaynan nga anak ni Enos, ");
INSERT INTO agt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","a i Enos ya anak ni Set, a i Set ya anak ni Adan, a i Adan ya napopolu en tolay nga anak na Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","A ta nekabalin ni Hesus nagzigut ta karayan na Hurdan a napasinapān hapa ta Kahalwa na Namaratu. A tentu en nagtugut a dumatang na mina ta agyan na, ammi pinagdulot na Kahalwa en ta bagbagetay kiden, a itta ten addet ta appatafulu araw petta attaman na hapa ya pangparuba ni Satanas tentu. ");
INSERT INTO agt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A awena pulus nangnangan addet ta appatafulu araw. ");
INSERT INTO agt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A tentu en pake melunus a yen hapa ya neange ni Satanas tentu, petta paruban na. A ya uhohug ni Satanas tentu a “Bakkan ka hud ta Anak na Namaratu ewan? A maguhohug ka mantu ta batu kidin petta magbalin kid ta pan petta mangan ka,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ammi ya tabbag hapa ni Hesus tentu a “Awek kurugan ya ibar men, te ya uhohug na surat na Namaratu a ‘Bakkan la ta kanan muy ya pagafun na katolayan muy,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","A gafu ta kumanen a neange na i Hesus ta pake atata-nang na lugar, a ta las-ud na takday minutos a nepaita na tentu ya ngamin kiden lugar ta paglelehutin kontodu tolay da kiden, ");
INSERT INTO agt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","a ya uhohug ha ni Satanas tentu a “Itam ya kalalaki na lugar kidina ikid na gubyernu da, te ya ngamin kiden nepaitak teko a kwam na sangaw am makidafu ka teyak, te neatad yan kid teyak, a iatad ku hapa ta kompormi na ikayat ku,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ammi ya tabbag ni Hesus tentu a “Iko hud ya pakidafun ku, te ya uhohug na suraten a ‘Namaratu la ya dayawan muy, a intu la tatakday ya pakidafun muy,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","A sangaw a takwan ha ya nepangparuba ni Satanas tentu, te neange na i Hesus ta ili na Herusalem ta agyan na simbaanen, a pinatayuk na ta pingit na atap na simbaanen. A ya uhohug na ha tentu a “Bakkan ka hud ta Anak na Namaratu ewan? A maglattu kan mantu ta lutakewan, ");
INSERT INTO agt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","te intu la nonotam ya nesurat ta lebru na Namaratu, te ‘Doban na ya anghel na kiden nga magtaron teko, ");
INSERT INTO agt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","a ta-mawan da ka sangaw petta awem matakitan ta batu kiden,’ kunna haman.” kun ni Satanas tentu. ");
INSERT INTO agt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A ya tabbag ha ni Hesus tentu a “Awek maglattu, te ya uhohug na takday surat na Namaratu a ‘Awemuy sangaw paruban ya pangkenga na Dafu muy Namaratu tekamuy,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","A ta nekabalin ni Satanas nga nangparuba tentu a nagtugutan na addet la ta takwan na araw. ");
INSERT INTO agt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","A nagtoli hapa i Hesus ta lugar na Galileya, a napasinapān hapa ta pakapangwa na Kahalwa na Namaratu. A sumaned hapa ya damag na pakapangwa na addet ta ngamin kiden lugar ta lehut na Galileya. ");
INSERT INTO agt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A nangituldu hapa ta umag na kapilya na Hudyo kiden, a dinayawan na ngamin tolay. ");
INSERT INTO agt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","A ta datang ni Hesus ta ili na Nasaret nga dimmakalan na, a umange hapa nakigimung ta kapilya ta araw na agimmang da ta kuman na gagangay na en ta idi. A gafu ta intu ya pinili da nga mangibasa ta arawin yen a nagtayuk hapa ta atubang na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","A negawat da hapa tentu ya lebru nga nesurat na aglavunen mina Isayas. A tentu en nangukad ta lebru en a apagan na ya lugar na ibasa na, a ya uhohug ni mina Isayas nga nebasa na tekid a intu yan: ");
INSERT INTO agt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Itta teyak ya Kahalwa na Dafu tamen, te pinasinapan nak nga ange mangipadangag ta mappya na damag ta napanglaw kiden. A dinob nak hapa nga ange mangipadangag ta pakaubad na negalut kiden, ikid na pakaladdang na daram kiden, ikid na pakabannayan na mazigatan kiden, ");
INSERT INTO agt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","a petta ipadangag ku hapa ya araw na pangikallak na Dafu tamen,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","A tentu nabalin nangibasa a kinalaban na ya lebru en kapye na netoli ta nanggawaten tentu, a sangaw nagtuttud hapa petta mangituldu. Ammi sa gahgahalangan da hapa, te indagan da ya ituldu na. A ya nebar na tekid a intu yan: ");
INSERT INTO agt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","“Ya suratin yan nga nebasak tekamuy a nagdulot na hala ta ayanin na araw ta pakadangag muy teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","A dinayawan da ya nepagbasa na en, ammi napopoyung kid gafu ta bari na en ya negitta na ta binasa na. “Pa-pa-nun na hud makauhohug ta kumanin bakawa sakā tolay tam haman la nga anak ni Hose,” kunda, ");
INSERT INTO agt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A ya uhohug para ni Hesus tekid a “Gagangay ta kummuy nga maguhohug teyak ta ‘Awem mina igitta ya barim ta doktor am awem bit urun ya barimina hapa la. A ya kuman na tinarabakum kan ta ili na Kapernayum, a ipaitam hapa ta isin lugar mi, petta itta hapa ya pangurugan mi teko,’ kummuy teyak. ");
INSERT INTO agt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ammi kakurugan ya ibar ku tekamuy ta am itta ya doban na Namaratu nga paguhohugan na a dayawan da hapa ta ngamin kiden lugar ammi fwera la ta lugar na en hapa la. ");
INSERT INTO agt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","A kumanen hapa te Eliyasen ta idi, te intu ya dinob na Namaratu nga magtabarang ta Istralita kiden ta idi, ammi gafu ta magsoysoy kid a awena nepalubus na Namaratu ta magudan addet ta tallu darun a gadwa, petta mapa-gang kid. A gafu ta agbabisinen ta ngamin kiden lugar a pake nazigatan ya addu na kagitta muy nga babbalu. ");
INSERT INTO agt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ammi maski Istralita kid a awan ta nepaita ni Eliyas ta pakapangwa na Namaratu tekid, awa intu hud la nangidoban na Namaratu tentu ya babbayen nabalu ta ili na Sarepta ta lugar na Hentil kiden taga Sidon. ");
INSERT INTO agt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“A kumanen hapa ta kaarawan ni mina Eliseyo, te addu hapa ya nagkangaw ta kagitta muy kiden Istralita ta ketta ni Eliseyo, ammi bakkan ta isina kid ya enna pinagmappya, te intu hud la pinagmappya na i Naaman nga kapitan na Hentil kiden taga Siriya,” kunna. A yen hapa ya addet na binida ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","A gafu ta inuhohug na en a nagporay kid na tentu, ");
INSERT INTO agt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","a gisatayuk kid ange nanggafut tentu. A ginerger da ta lawan na ili, te enda itulud ta ngahab na gatab nga nagyanan na ili da en, petta itu-bang da mina ta akban. ");
INSERT INTO agt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ammi awena mabalin ta itu-bang da, te nagpapa-yat la ta hahat da, a nagtugut. ");
INSERT INTO agt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A nagtoli mantu i Hesus ta ili na Kapernayum ta iten Galileya. A ta araw na agimmang a umange nakigimung ta kapilya da en, a nangituldu hapa. ");
INSERT INTO agt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ammi nakagtut ya tolay kiden ta gagangay na pangituldu na, te naguhohug ta kuman na intu ya makkamu ta ngamin. ");
INSERT INTO agt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","A ka-ma la kimahalwan hapa ya takday lalaki ta umag na kapilya en gafu ta anitu na en. ");
INSERT INTO agt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“O Hesus taga Nasaret, Amu ta ka, te iko ya kagitta na Namaratu ewan. Yen hud ya umeyam sin petta pakākāllakan na kami?” kunna. ");
INSERT INTO agt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ammi nehuya ni Hesus ya anitu en ta “Awem la magsitang, a pagtugutām na ya tolayina,” kunna. A nagganwatan na anitu en pinagbalyad ya lalaki en, kapye na nagtugutan, ammi awan ta nakaan-anun na lalaki en. ");
INSERT INTO agt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pake nagpaka-lat ya tolay kiden ta iningwa ni Hesus a “Anu masikan hapa ya uhohug na inin? Te seppakapangwa ya paguhohug na ta anitu kiden, a magtugut kid la,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A gafu ta kumanen a insigida sumaned ya damag ni Hesus abat ta ngamin kiden babali ta lugar na Galileya. ");
INSERT INTO agt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","A ta nepagtugut ni Hesus ta kapilya en a nagdulot ta bali ni Simon nga takday ituldu na. A nagtakit hapa ya katahungan ni Simon nga babbay gafu ta nagpatu a nebar da te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A umange i Hesus ta pagiddan na en, a nehuya na ya patu na, a yen hapa ya nepagkamag na patu na en. A alistu imivwat kapye na ange nagafuy petta mangan kid. ");
INSERT INTO agt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","A sangaw ta marimat a addu ya nagdadatang ta bali, te enda nekahad ya magtatākit kiden ta magdaduma na takit. A nepotun ni Hesus ya kamat na ta tagtakday tekid, a pinagmappya na kid. ");
INSERT INTO agt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","A pinatugut na hapa ya anitu na addu na seanitu kiden, a nagtugut kid kimahalwan, “Iko kad ya Anak na Namaratu ewan,” kun na ayag da. Ammi nehuya na kid nga maguhohug, te amu da ta intu ya Kristu nga Mangikerutan, a awena ikayat ta ikid ya mangipadangag tentu. ");
INSERT INTO agt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","A ta lalakwat a nagtugut ha i Hesus, te ikayat na ange tatakday ta awan ta totolay. Ammi magananwan la a enna inapag na tolay kiden, te aweda ikayat ta pagtugutan na kid. ");
INSERT INTO agt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ammi ya uhohug na tekid a “Mappya ta magdulotak ta kadwan kiden ili, petta madangag da hapa ya damag na pangikerutan na Namaratu tekid, te yen ya gafu na nepangidob na teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A gafu ta kumanen a sinaned na ya ngamin kiden babali ta lugar na Hudeya, a nangipadangag hapa ta umag na kapilya da kiden. ");
INSERT INTO agt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","A sangaw ta mittan a imatayuk la i Hesus ta pingit na Alugen Genesaret, a pake imabikan ya pake addu na tolay petta dangagan da ya uhohug na Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A naita ni Hesus ya duwa na selayag nga negalut ta pingit. Awan ta totolay da te itta kid ta danumen nga magbaggaw ta tahukul da kiden. ");
INSERT INTO agt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A gimon mantu ta takdayen nga selayag ni Simon, a nebar na te Simon ta itu-bang na bit ta sang adayu ta pingit, a sangaw nagtuttud hapa petta mangituldu ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","A tentu en nabalin nangituldu a nebar na te Simon ta “Entam bit ta adalamewan, te ihunnak muy ya tahukul kiden petta makaalap kam,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Onay, ammi paghuhuklaw kami haman, Afu, nagtahukul, a awan haman ta naalap mi. Ammi gafu ta inuhohug mu a paruban mi ay,” kunna hapa ni Simon. ");
INSERT INTO agt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","A ta nepangihunnak da ta tahukul da kiden a “Awe”, ta kaddu na ikan kiden ay nga nagkapannu ta tahukul kiden, a namegafu nagasāt ya tahukul kiden ta dammat da. ");
INSERT INTO agt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pinaypayan da ya kahulun da kiden ta takdayen selayag petta e kid hapa manguffun, a pinannu da ya duwa kiden selayag ta ikan abat ta magge lumammad kid na. ");
INSERT INTO agt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","A ta nepakaita ni Simon Pedru ta kaddu na naalap da a ka-ma la nagtakab ta atubang ni Hesus. “Ay, Afu, umadayu kan mina teyak, te pake dulayak na tolay,” kunna gafu ta amat na tentu. ");
INSERT INTO agt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A sa nakagtut kid ta kaddu na naalap da, ");
INSERT INTO agt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","kumanen hapa teg Santiago ikid ni Hwan nga anak kid ni Zibadeyu, te ikid hapa ya kahulun ni Simon. A ya uhohug ni Hesus te Simon a “Awem la mamat, te ituldu ta ka sangaw petta dumatahukul ka sangaw ta tolay, petta dumagdag kid teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","A tekiden nakadatang ta ba-nad na alugen a sa newagak da ya ngamin kiden kwa da, a dumagdag kid na te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","A sangaw ha ta mittan a itta ig Hesus ta takday ha na ili, a itta ya takday lalaki nga naggalis. A ta nepakaita na lalaki en te Hesus a umange namalentud ta atubang na en nga nakimemallak tentu. “Ay, Afu, ikallak nak haen, te amuk ta maurum ya tabbit kin am ikayat mu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","A neuyad na ya kamat na en nesi-ged ta lalaki en, a “Ikayat ku hapa, itam awa malinis na ya tabbit mina,” kun ni Hesus tentu. A ka-ma la imawan ya galis na en, a pake nalinis na ya tabbit na en. ");
INSERT INTO agt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A pake nebar ni Hesus ta awena bibidan ya nakkwa tentu, “te em ipaita ya barim ta padi en ta simbaanen petta maita na ta awan ya galis men, a iatad mu hapa tentu ya iatang na ta kuman na nebar ni Moses ta lintig kiden, te yen sangaw ya mangipasikkal ta tolay kiden ta pagmappyam,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ammi maski kunna ten a pake sumaned para ya damag ni Hesus abat ta pake imaddu ya tolay kiden nga umange magdangag tentu, petta pagmappyan na mina ya takit da kiden. ");
INSERT INTO agt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ammi kanayun nagtugut hapa i Hesus, te ange ta adayu ta babali kiden petta makimallak. ");
INSERT INTO agt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","A naba-bayag ta assang a mangituldu ha i Hesus ta takday ha na lugar, a itta hapa ya kadwan kiden Pariseyu ikid na mangituldu ta relisyon na Hudyo kiden nga taga ngamin kiden lugar ta Galileya ikid na Hudeya kontodu ili na Herusalem. A nakituttudan kid hapa magdangag. A napasinapān hapa i Hesus ta pakapangwa na Namaratu petta makapagmappya ta nagtatākit kiden. ");
INSERT INTO agt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","A sangaw ta magananwan a itta hapa ya enda nekahad nga awena makahehit, te imaidda la ta pang-isawan da en tentu, te iange da mina itabnak ta atubang ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ammi aweda garay neabikan tentu gafu ta kaddu na tolay, a yen ta negon da ta addanen nga ange ta atap na bali en. A sangaw inazi da ya assang la ta atapen ta annung ni Hesus, kapye da neuriyay ya awanen makahehit ta umag na bali, a netabnak da ta bikat ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","A ta nepakaita ni Hesus ta pangikatalak da tentu a naguhohug ta awanen makahehit, “Aleng, pakoman kun ya liwat mu kiden ta Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ammi ya Pariseyu kiden ikid na mangituldu kiden nga gituttudan hapa ta umag na bali a linibakan da hapa ya inuhohug ni Hesus ta nonot da hapa la. “Annun na haman uhohugan ya kumanen bakawa Namaratu hud. Dulay mantu yan, te ugtulān na ya Namaratu,” kun na nonot da. ");
INSERT INTO agt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ammi narikna ni Hesus ya nonot da, a “Anu haman ta libakan muy ya inuhohug ken ta nonot muy? ");
INSERT INTO agt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Had sin hud ya malmalogon, am pakoman ku ya liwat na kiden, ono am pagmappyan ku petta makatugut? ");
INSERT INTO agt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ammi itta hapa ya ibar ku ta awanin makahehit petta itta sangaw ya pakaitan muy ta itta hapa ya turay na Tolayin taga Langit nga mangpakoma ta liwat na tolay,” kunna, otturu naguhohug ha ta awanen makahehit; “Imivwat kan, Aleng, te alapam na ya pagiddamina a dumatang kan ta balim,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","A alistu kad imivwat, ta atubang na ngamin kiden imatuttud, a inakkat na ya nagiddan na en kapye na nagtugut, a kumin ta bali na nga nagdaydayaw ta Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","A nafulotan hapa ya pagpaka-lat na ngamin kiden nakaita, a pake dinayawan da ya Namaratu gafu ta nahigalan kid tentu. “Kakurugan ta takwan ya naita tam ta arawin yan,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","A ta nekabalin da ten a nagtugut ig Hesus, a nesimmun da ya takday agsingir ta bwis nga nagngagan te Lebi, a imatuttud hapa ta lugar na pagpagan na tolay kiden ta bwis da. A ya uhohug ni Hesus tentu a “Dumagdag kan teyak petta ituldu ta ka,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A imikkat hapa, a nagtugutan na ya nagtarabakun na en, petta dumagdag tentu. ");
INSERT INTO agt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","A tekiden nagtugut a inagagay na kid ni Lebi ta bali na en, te namadday ta dakal na pagpamakan ta pangdayaw na te Hesus, a dumadagdag hapa ya addu na agsingir ta bwis, ikid na kadwan kiden tolay nga nakikkanan hapa tekid. ");
INSERT INTO agt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","A ya Pariseyu kiden ikid na kahulun da kiden nga mangituldu a naita da ta umange ig Hesus nakikkanan ta bali ni Lebi, a nehuya da ya ituldu na kiden. “Anu makikkanan kam ta agsingir kiden ta bwis ikid na dulay na tolay?” kunda. ");
INSERT INTO agt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A ya tabbag hapa ni Hesus a “On ay, te gagangay haman ta ange ya manguru en ta agyan na magtakit kiden, te yen haman ya makaapag tentu. ");
INSERT INTO agt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","A bakkan ta yen ya umeyan ku sin petta padagdagan ku ya ape awanen ta liwat am awa seliwat kiden talo am magbabawi kid,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A sangaw itta ya umange nagpohut te Hesus gafu ta gagangay na ituldu na kiden; “Anu kawagan na, Afu, ta awena ngilinan na ituldum kiden ya araw na awan pangan, ammi ta ituldu na Pariseyu kiden ikid na ituldu kiden ni Hwan a kanayun ngilinan da petta makimallak kid?” kunda. ");
INSERT INTO agt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A ya tabbag hapa ni Hesus tekid a “Mabalin hud ta magdamdam ya makiboda kiden am itta para la tekid ya magboda en? ");
INSERT INTO agt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Itta la sangaw ya araw am metugut ya magboda en tekid, a yen sangaw ya pagdamdam da ikid na pagngilin da ta araw na awan pangan,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","A sangaw binida na hapa ya kuman na keangarigan tekid petta aweda mina pagdadaggan ya dana kiden gagangay da ikid na ituldu na. “Am angarigan ta napispissang ya dana en barawasi muy a pissangan muy hud ya bagu en ga-gamit petta itta ya itakup muy ta dana en, te kenga sangaw ya bagu en barawasi, yaga meduma hapa ya dana en ta bagu en. ");
INSERT INTO agt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“A kumanen hapa ta basi muy, te awemuy haman ikarga ya bagu na basi ta dana na abyat, te sangaw am bumlad ya basi en a mabattak ya abyaten otturu meburud hapa ya basi en. ");
INSERT INTO agt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mapmappya hud la ta mekarga ya bagu na basi ta bagu na abyat. ");
INSERT INTO agt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Ammi am napenam na ya tolay ta baak na basi a gagangay ta awena ikayat paruban ya bagu, te ‘Kustu ya singat na baaken,’ kunna.” A yen ya addet na bida na tekid. ");
INSERT INTO agt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","A sangaw ta mittan a magtugtugut ig Hesus ikid na ituldu na kiden ta tātangngan na kamaitan ta araw na agimmang, a nagpusit hapa ya ituldu na kiden, a inusakan da kapye da kinān. ");
INSERT INTO agt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ammi gafu ta naita na kid hapa na Pariseyu kiden a nehuya da kid. “Anu haman ta tarabakun muy ya mehangat ta araw na agimmang?” kunda. ");
INSERT INTO agt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","A netabbag hapa ni Hesus ta “Dulay hud ya iningwa da en? Intu mina pagnonotan muy ya iningwa ni mina Dabid ikid na kahulun na kiden ta kawan na kanan da, ");
INSERT INTO agt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","te simarok kid la ta bali na Namaratu, a inalap da hapa ya pan kiden nga nedasar ta atubang na Namaratu nga mehangat mina tekid, te kanan hala na padi kiden. A maski nangan kid na kahulun na kiden a bakkan haman ta nakaliwatan da yen,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A ya takday para nebar na tekid a “Ya Tolayin taga Langit ya makkamu ta araw na agimmang,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A ta takday ha na araw na agimmang a mangituldu i Hesus ta kapilya na Hudyo kiden, a itta ya takday lalaki nga pake nagpilay ya takday kamat na. ");
INSERT INTO agt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A ya Pariseyu kiden ikid na mangituldu kiden a pake aitan da hapa i Hesus talo am pagmappyan na ya kamat na en, te am pagmappyan na ta araw na agimmang a yen sangaw ya pangidaruman da tentu. ");
INSERT INTO agt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ammi dana amu ni Hesus ya nonotan da, a yen ta binaran na hapa ya nagpilay ta kamat, “E ka bit sin, te magtayuk kan ta pagtatangnganin,” kunna, ");
INSERT INTO agt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","otturu pinohutan na hapa ta nagilalap kiden tentu; “Anu hapa ya uray muy ta ipalubus na Namaratu ta araw na agimmang? Intu ipalubus na ya mappya ono dulay? Mappya panaw ta magpamappya kitam ono magpapasi kitam?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A inaita na kid la kapye na naguhohug ha ta lalaki en. “Uyadam la ya kamat mina,” kunna. A tentu en nanguyad a negitta hapa ta takdayen kamat na nga mappya. ");
INSERT INTO agt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ammi ya Pariseyu kiden a nafulotan ya pagporay da tentu, a nagbabidan da am anu mina ya pangpa-gang da te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","A sangaw gimon i Hesus ta agyan na bagetay kiden, a paghuhuklaw hapa nga nakimalmallak ta Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","A ta lalakwat a pinaabikan na ya ituldu na kiden, a nagpili ta mafulu duwa la tekid, petta yen kid ya turin na nga ange mangipadangag. ");
INSERT INTO agt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Itta i Simon nga nengagan na ta Pedru, ikid na kabagis na en Andres, ikid ni Santiago, ikid ni Hwan, ikid ni Felipe, ikid ni Bartolome, ");
INSERT INTO agt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ikid ni Matyu, (intu hala i Lebi), ikid ni Tomas, ikid na takday Santiago nga anak ni Alfeyo, ikid ni Simon nga nakitapil ta gubyernu nga taga Roma, ");
INSERT INTO agt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ikid ni Hudas nga anak ni Santiago, ikid ni Hudas Iskaryote nga mangitalaba sangaw te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","A tentu nabalin nagpili tekid a sa dumagut kid ta bagetayen, kapye da nagimmang ta palanada. Pake addu ya ituldu kiden ni Hesus, yaga dumadagdag hapa ya addu na tolay nga taga Herusalem ikid na kompormi na lugar ta Hudeya, ikid na ili na Tiro ikid na Sidon ta bikat na bebayen dakal, te umange kid magdangag ikid na magpauru ta takit da kiden. ");
INSERT INTO agt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","A ya pinagzigat na anitu da kiden a pinagmappya na kid hapa. ");
INSERT INTO agt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","A sa ikayat da ya pasi-ged tentu, te itta ya pakapangwa na nga magpamappya tekid ngamin. ");
INSERT INTO agt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","A sangaw imatubang i Hesus ta ituldu na kiden petta ituldu na kid, a ya binida na tekid a intu yan: “Ikamuy nga napanglaw a nagāsāt kanan, te Namaratu ya makkamu tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","A ikamuy nga mabisin ta ayanin a nagāsāt kanan hapa, te matappag kam hala sangaw. A ikamuy nga magdamdam ta ayanin a nagāsāt kanan sangaw, te magayayat kam sangaw. ");
INSERT INTO agt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","A maski am ikatupag na kam na ikattolay muy, ikid na dugiman da kam, ikid na amāmatan da kam, ikid na padpadulayan da kam gafu ta ituldu ta kam a nagāsāt kam la. ");
INSERT INTO agt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“A magayayat kanan mina am dumatang sangaw ya kumanin na zigat tekamuy, a timollok kam mina setalak, te pake dakal sangaw ya sagolyat muy ta langitewan. A awemuy la magdamdam, te nonotan muy mina ya aglavun kiden na Namaratu ta palungu na araw, te kagitta muy kid hapa nga nekatupag. ");
INSERT INTO agt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ammi ikamuy nga maba-nang a kakallak kam sangaw, te am maafut na sangaw ya kaba-nang muy a awan sangaw ta talak muy. ");
INSERT INTO agt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","A ikamuy nga magbattug ta ayanin a kakallak kam sangaw, te mabisin kam. A ikamuy nga magayayat ta ayanin a magtangit kam sangaw ta damdam muy. ");
INSERT INTO agt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","A kakallak kam hapa sangaw am mappya la ya bibidan na ngamin tolay gafu tekamuy, te negitta kanan hala ta matulad kiden aglavun nga dinayawan na tolay kiden ta idi. A mehulun kam sangaw tekid ta pama-gang na Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“A am madangag muy ya uhohugan ku tekamuy a iddukan muy ya mangikatupag tekamuy, a uffunan muy kid. ");
INSERT INTO agt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","A am igaged da kam a bendisyonan muy kid, a pakimallak muy ya manguyoyung tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","A am linappongan na ya pahingil muy a itayan muy hala tentu ya taakub. A am gubatan na ya barawasi muy a idagga muy hapa ya kamasita muy. ");
INSERT INTO agt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","A maski am anu ya adangan na ono gubatan na tekamuy a iatad muy la a awemuy petoli. ");
INSERT INTO agt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“A kumanen hapa am anu ya ikayat muy ta ipaita na ikattolay muy tekamuy a mappya ta kumanen hapa ya ipaita muy tekid. ");
INSERT INTO agt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Te am intu la iddukan muy ya mangidduk tekamuy a anu hud sangaw ya pangsagolyat na Namaratu tekamuy, te maski ya awan kiden mangurug a iddukan da hala ya mangidduk tekid. ");
INSERT INTO agt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A am intu la uffunan muy ya manguffun tekamuy a anu hud sangaw ya pangsagolyat na Namaratu tekamuy, te awan haman ta pagdaduman muy ta awan kiden mangurug. ");
INSERT INTO agt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A am intu la pagatutan muy ya amu muy nga magpagatut tekamuy a anu hud sangaw ya pangsagolyat na Namaratu tekamuy, te maski ya awan kiden mangurug a pagatutan da hala ya kagitta da kiden nga awan mangurug petta paggatutan da kid hapa. ");
INSERT INTO agt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Ammi bakkan mina ta kunna ten tekamuy, te iddukan muy hud la ya mangikatupag tekamuy, a uffunan muy kid anna pagatutan muy kid, a awemuy nonotan ya pagsupapak da tekamuy, te am kunna ten ya tarabakun muy a dakal sangaw ya sagolyat muy, a megitta kam ta Namaratu ewan, te maallak hapa ya Namaratu ta dulay kiden na tolay nga awan matalak tentu. ");
INSERT INTO agt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mappya mantu ta parigan muy ya pangikallak na Dama muyewan.” ");
INSERT INTO agt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“A ya ibar ku para tekamuy a awemuy ka-ma la paliwatan ya ikattolay muy talo am paliwatan na kam hapa na Namaratu ewan. A awemuy hapa mangigaged talo am igaged na kam hapa. Mappya hud la ta pakoman muy ya magliwat tekamuy, te am pakoman muy a pakoman na kam hapa na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“A am mappya ya iatad muy ta ikattolay muy a mappya hapa sangaw ya iatad na Namaratu tekamuy, te pannun na ya sabok muy, a sadsadan na, kapye na ha surokān. Te am anu ya pangsukat muy ta kadwan a kumanen hala sangaw ya pangsukat na Namaratu tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","“A kumanen hapa am itta ya pagkurangan na kabagis mu ta kuman na salasangkap ta mata na tolay a anu kawagan na ta ihuyam ta awem haman amu ta itta ya pagkurangam nga kuman na tarosu? ");
INSERT INTO agt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A am awem maita ya kuman na tarosu ta matam a annum hud ibar ta kabagis men ta ‘O, kabagis, azin ku bit ya salasangkap ta matam.’ Kuga magimmamappya ka. Azim bit apolu ya kuman na tarosu en ta matam, a sangaw magdakar ya pakaitam, pettam maazim hapa ya salasangkap ta mata na kabagis mu. ");
INSERT INTO agt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Te am daram ya tolay a mabalin hud ta itulud na ya sakā daram na en awa azo metawag kid nga meavut. ");
INSERT INTO agt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","A yen mina ya pagnonotan muy, te maski am inya ya metuldu a assang la ya amu na ammi ta mangituldu tentu, a am nabalin na metuldu a megitta hala ta mangituldu en tentu. ");
INSERT INTO agt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“A nonotan muy para ya gagangay na kayu: te am kakurugan ta mappya ya fun na kayu en a magmayan hud sangaw ta dulay awa mappya haman. A am dulay ya fun a magmayan hud ta mappya awa dulay hapa ya mayan na en. ");
INSERT INTO agt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Te ya mayan na kayu ya pakaitan am mappya ono dulay ya fun na en. A bakkan mantu ta patani ya mayan na lanut na mawini. A bakkan hapa ta anyog ya mayan na fun na ambabanga ");
INSERT INTO agt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A kumanen hapa ta tolay, te am mappya ya tolay a mappya hapa ya pohetan na ta nonot na, a am dulay ya tolay a dulay hapa ya pohetan na ta nonot na. Te am anu ya nauknud na tolay ta nonot na a yen sangaw ya iuhohug na. ");
INSERT INTO agt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ibar muy haman ta iyak ya dafu muy, ammi anu kawagan na ta awemuy idulot ya patarabakuk tekamuy? ");
INSERT INTO agt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ammi ya ngamin kiden ange teyak ikid na mangdangag ta uhohug ku ikid na mangidulot ta madangag da a ibar ku tekamuy ya keangarigan da, ");
INSERT INTO agt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","te meangarig kid ta magbali ta maladda na arigi a ikali na kid ta pake adalam. A sangaw am dumatang ya layus ikid na kasikanan na arut a awena matukalit na bali na en, te pake maladda na bali. ");
INSERT INTO agt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Ammi ya awanen mangurug ta uhohug ku a meangarig ta magbali nga awan mekali ya arigi na kiden, te am dumatang ya kasikanan na arut a matukalit ya bali na en, a mekutukutet na ta aruten,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","A ta nekabalin ni Hesus nga nangituldu ta tolay kiden a nagdulot hapa ta ili na Kapernayum. ");
INSERT INTO agt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A itta hapa ten ya kapitan na suddalu kiden nga taga Roma, a tanagay na kan masi ya tagabu na en nga pake mesasita tentu, te pake nagtakit. ");
INSERT INTO agt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","A ta nepakadamag na kapitanen te Hesus a dinob na tentu ya kadwan kiden kalalaklakayan na Hudyo kiden, petta alapan da mina i Hesus ta bali na, petta pagmappyan na hapa ya tagabu na en. ");
INSERT INTO agt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","A ta pakadatang da te Hesus a pake nakimemallak kid tentu gafu ta kapitanen; “Mappya, Afu, ta ikallak mu ya kapitanen te mappya hapa na tolay, ");
INSERT INTO agt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","te maski bakkan ta kagitta tam Hudyo a iddukan na kitam hala, te intu ya nagpapadday ta kapilya tam sin,” kunda te Hesus. A dumagdag mantu i Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","A tekid na nakaabikan ta bali na kapitanen a dinob na ya kofun na kiden nga nage mangdafung te Hesus, petta aweda pagdulotan ta bali. “Maski awem kan la magdulot ta bali na kapitan, Afu, te mamat kan teko, ");
INSERT INTO agt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","a yen kan ta takwan ya dinob na nga umange teko. Ammi ibar mu kan hala ya kakustun na pagmappya na tagabu na, a ikatalak na kan ta magmappya hala. ");
INSERT INTO agt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Te ya uhohug na hapa a ‘Itta ya mangituray teyak, yaga itta hapa ya suddalu nga iturayan ku, te am ibar ku ta takday, “E ka ten,” kunku, a ange hala ten, a am “E ka sin,” kunku para ta takday a ange hala teyak. A am “Kwam yan”, kunku ta tagabu ken a kwan na hala,’ kunna. A am gagangay kan ta kunna ten gafu ta itta ya turay na a kontimas mantu kan ta makkwa hapa ya ngamin uhohugam,” kunda te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","A ta pakadangag ni Hesus ta bida da en tentu a pake dinayawan na hapa ya kapitanen ta tolay kiden nga dumagdag tentu. “Ibar ku tekamuy ta pake masmasikan ya pangikatalak na kapitanen ammi ta Istralita kiden. Gagangay ta ikid mina ya masmasikan, te tolay na kid haman na Namaratu ewan, ammi awan para la ta naitak tekid ta masmasikan mangikatalak ta kuman na kapitanin,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","A ta pagtoli na dinob na kapitanen ta bali a naita dan ta nagmappyan hapa ya tagabu na en. ");
INSERT INTO agt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A ta takday ha na araw a umange i Hesus ta ili na Nain, a dumadagdag hapa ya ituldu na kiden kontodu addu na tolay. ");
INSERT INTO agt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","A tekiden nakaabikan ta sasarokan na ili a nesimmun da ya addu na tolay nga ange mangitanam, te enda itanam ya babagu en nasi nga mementu en anak na babbayen nabalu. ");
INSERT INTO agt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","A ta nepakaita ni Hesus ta nabalu en a maallakan hapa tentu, a “Awem la magtangit, Ina,” kunna tentu, ");
INSERT INTO agt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","otturu umabikan ta lungunen, a sini-ged na petta magimmang ya mangisaw kiden. “Aleng, imivwat kan,” kunna hapa ta nasi en, ");
INSERT INTO agt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","a natolay hala, a nagtogkok, yaga namegafu hapa nagbida. A kumanen negawat ni Hesus te hina na en. ");
INSERT INTO agt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","A sa nakagtut ya tolay kiden nga nakaita, a dinayawan da hapa ya Namaratu; “Mappya te ninonot na Namaratu ya tolay na kiden, te dinob na ya turin na en tekitam nga pake malalaki,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","A nepadamag da ya iningwa ni Hesus ta lehut na lugar na Hudeya abat ta kadwan kiden lugar ta bikat na Hudeya. ");
INSERT INTO agt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","A ta kabalud para la ni Hwanen nga nangzigut ta tolay kiden a kanayun umange tentu ya ituldu na kiden, te ipadamag da tentu ya ngamin kiden tinarabaku ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","A yen ta dinob ni Hwan ya duwa na ituldu na petta ange kid magpohut te Hesus. A ya nebar na tekid a “Damagan muy am intu hala ya Mangikerutanen nga nekari na Namaratu ewan ono mappya ta magindag kami ta takwan,” kun ni Hwan tekid, a umange kid. ");
INSERT INTO agt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","A dinatangan da i Hesus nga magpamappya para la ta addu na magtatākit, te pinatugut na ya anitu na seanitu kiden, a pinagmappya na hapa ya mata na addu na nagdaram. A sangaw nebar da hapa ya neange da tentu; “Yen ta itta kamin, Afu, te dinob na kami ni Hwan, te damagan na kan am iko ya Mangikerutanen nga nekari na Namaratu, ono itta para la ya takwan nga indagan mi?” kunda. ");
INSERT INTO agt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","A ya uhohug ni Hesus tekid a “Magtoli kanan te Hwan a bidan muy tentu ya ngamin nadangag muy ikid na naita muy ta ayanin, te makaita ya daram kiden, ikid na makatugut ya pilay kiden, a nagmappyan ya naggalis kiden, ikid na makadangag ya bangag kiden, a natolay hapa ya nagpasi kiden, a mepadangag hapa ya mappya na damag ta pobre kiden. A yen kid mina ya pakkamun na teyak. ");
INSERT INTO agt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","A ibar muy hapa tentu ta magāsāt ya tolay nga awan magtabeng gafu teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","A ta nepagtugut na duwa kiden a naguhohug i Hesus ta tolay kiden nga kumalihung tentu, te bidan na tekid ya kasasaad ni Hwanen nga nangidob ta nagpohut kiden tentu. “A tekamuyen umange nangita te Hwan ta kalafukanen ta idi a anu hud ya naita muy? Intu de naita muy ya awanen ta turad ta kuman na kulang na sikal nga malogon mapakkul ta paddad? Bakkan. ");
INSERT INTO agt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ono intu de naita muy ya malapat na tolay nga mapenam magbarawasi ta kuman na maba-nang? Bakkan haman, te itta haman ta bali na ari ya magbarawasi ta ispot ikid na mangina. ");
INSERT INTO agt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","A anu mantu ya pangitan muy tentu? Nalasin muy de ta intu ya takday aglavun nga paguhohugan na Namaratu ewan? A kakurugan ta aglavun na Namaratu, ammi pake ibar ku tekamuy ta pake malmalalaki para i Hwan ammi ta gagangayen aglavun, ");
INSERT INTO agt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","te intu hala ya nebar na Namaratu nga mapmapolu ammi teyak, te ya uhohug na ta suraten a ‘Itta sangaw ya doban ku nga mapmapolu ammi teko, a intu sangaw ya mangipadangag ta iangem,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“A kakurugan hapa ya ibar ku tekamuy ta awan para la ta neanak nga megitta ta kalalaki ni Hwan. Ammi ya pake al-alinnaken ta ngamin kiden iturayan na Namaratu a pake malmalalaki para ammi tentu.” ");
INSERT INTO agt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","A ya ngamin kiden nakadangag ta damag ni Hwan ta awena en para la nebalud a kinurug da ya nebar na, petta magdulot ya uray na Namaratu tekid, a yen ta nagbabawi kid ta liwat da kapye da pazigut te Hwan, kumanen hapa ta nagswitik kiden nga nagsingir ta bwis. ");
INSERT INTO agt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ammi ya Pariseyu kiden ikid na kahulun da kiden nga mangituldu a nagtalekudan da ya uray na Namaratu tekid, te aweda ikayat pazigut te Hwan. ");
INSERT INTO agt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","“A anu mina ya igittak ta tolay kiden nga mangawe ta uray na Namaratu? A kuman kid na anak kiden nga magalikkad ta sakā anak da kiden. Te ya kuman na alikkad na anak kiden a ikayat da matubtubbat. Ammi gafu ta takwan ya nonot na kadwan a ‘Anu awemuy haman magtalip am maggasa kami,’ kunda. ‘A am masi kami pon awemuy haman magtangit,’ kunda ha. ");
INSERT INTO agt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“A kumanen hapa ya nonot na kadwan kiden tolay ta ayanin, te matupag kid gafu ta aweda ikayat ya gagangay na sakā tolay da kiden. Ta kuman ni Hwan ta idi a awena haman uminum ta binarayang, yaga ngilinan na hapa ya araw na awan pangan, a ibar da haman ta maguyung. ");
INSERT INTO agt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ammi gafu ta uminum ya Tolayin taga Langit ikid na awena ngilinan ya araw na awan pangan a ibar da haman ta mellaw ikid na madugal. A ibar da para ta iyak ya kahulun na magsingir kiden nga magdarogas ikid na dulay na tolay. ");
INSERT INTO agt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ammi maski padpadulayan da kami ni Hwan a ya kappya na tarabaku mi ya mangipasikkal ta katunung na gagangay mi,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","A sangaw ta mittan a itta ya takday Pariseyu nga nangagagay te Hesus ta bali na petta makikkanan kid. A umange hala i Hesus ta bali na en, a nagidda kid nagsikig ta anganan da ta kuman na gagangay da en. ");
INSERT INTO agt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A namegafu kid para la nangnangan, a nepagka-ma da ya takday babbay nga umatayuk ta bikat na takki ni Hesus, a magtangit. A dulay kan hapa na babbay, te madi kan ya tarabaku na ta agyan na ili da, ammi tentu en nakadangag ta ittan i Hesus ta bali na Pariseyu en a umange hapa, a nehulun na hapa ya botelya na pake mangina na bangog. ");
INSERT INTO agt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","A tentu para la nakatangtangit a namegafu nagbaggaw ta takki ni Hesus ta zigu na mata na kiden, a sangaw finunatan na ya takki na kiden ta huk na, kapye na inamu, a sangaw linuggudan na kid ta bangogen. ");
INSERT INTO agt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","A ta nepakaita na Pariseyu en ta iningwa na babbayen a linibakan na i Hesus ta nonot na en hapa la. “Am kakurugan mina ta aglavun na Namaratu ya tolayin yan a amu na mina ya gagangay na babbayin nga mangsi-ged tentu, te dulay haman na babbay,” kun na nonot na. ");
INSERT INTO agt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ammi tinabbag hala ni Hesus ya itta en ta nonot na Pariseyu en, te ya nebar na a “Simon, itta haen ya ibar ku teko,” kunna tentu. “A anu yen, Afu?” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“A ta idi itta ya nagpagatut ta duwa na tolay, a ya gatut na takday a limagatut, ammi limafulu la ya gatut na takdayen. ");
INSERT INTO agt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ammi kadulayan na te aweda makapaga ta gatut da, ikid duwa. A gafu ta aweda mapagan ya gatut da kiden a inazi na nagpagatuten gafu ta allak na tekid. A ta kuman na uray mu, Simon, a had sin ta duwa kiden ya pake mataltalak ta nagpagatuten tekid?” kunna ha ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","A ya tabbag hapa ni Simon a “Ya dakdakalen de ta gatut ya pake matalak tentu,” kunna hapa. “A kustu kad ya tabbag mina,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","A sangaw linipay ni Hesus ya babbayen kapye na ha naguhohug te Simon. “Itam ya iningwa na babbayin, Simon, te addet ta nesarok ku ta balimin a awan haman ta nedasar mu ta pagbaggawan ku ta takkik kiden, ammi tentu a binaggawan na ya takkik kiden ta zigu na mata na, a finunatan na kid ta huk na. ");
INSERT INTO agt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A teyaken simarok ta bali min a awan haman ta pangamum teyak ta pagpadulot mu teyak, ammi tentu a awena nagimmang nangammu ta takkik kidin. ");
INSERT INTO agt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Awan hapa ta neluggud mu ta ulu kin, ammi tentu a linuggudan na ya takkik kidin ta bangog na en. ");
INSERT INTO agt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“A yen ta ibar ku teko, Simon, ta pake dakdakal ya talak na babbayen teyak ammi teko, te amu na ta dakal ya liwat na kiden nga nepakoma na Namaratu tentu. Ammi am pahig na tolay ta assang la ya liwat na nga nepakoma tentu a assang mantu la ya pangayat na ta nangpakoma en tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","A ya uhohug ha ni Hesus ta babbayen, a “Mappya, Aboy, te pinakoma na Namaratu ya liwat mu kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ammi ya kadwan kiden nga nakiatubang ta panganan da a linibakan da ya uhohug ni Hesus ta babbayen. “Anu hud ya uray na tolayin yan, bakawa itta hud ya turay na nga mangpakoma ta liwat na tolay?” kunda. ");
INSERT INTO agt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A ya uhohug para ni Hesus ta babbayen a “Nekerutan kan, Aboy, gafu ta pangikatalak mu teyak. Dumatang kan la ta bali, a Namaratu ya makkamu teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A ta nekabalin na en a sinaned nig Hesus ikid na mafulu duwa kiden ituldu na ya ngamin kiden ili ikid na lugar na babali, a nepadangag na ya damag na pangikerutan na Namaratu ta tagtakday lugar. ");
INSERT INTO agt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","A dumadagdag hapa tentu ya kadwan kiden bābāy nga pinatugut na ya anitu da ikid na takit da. Itta i Mariya Magdalena nga nagtugutan na pitu na anitu, ");
INSERT INTO agt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ikid ni Hwana nga atawa ni Kusa nga nagtaron ta bali ni Ari en Herud, ikid ni Susana, ikid na addu para. A yen kid na bābāy ya makkamu ange gumatang ta ngamin masapul nig Hesus ikid na ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","A sangaw nagaammung ya pake addu na tolay nga nagafu ta tagtakday ili a nagbida i Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Itta ya umange nagpurwak,” kunna, “a nehunnak ya kadwan kiden hukal ta matuyag na dalan a enna kid inafut na mamanuk kiden. ");
INSERT INTO agt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","A nehunnak hapa ya kadwan kiden ta kabatunen nga nebagbagtu ya lutak na. Ammi tekid na nagtatuhu a nagkatang kid, te awan ta danum ta nagtuhun da en. ");
INSERT INTO agt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A ya kadwan kiden hukal a nehunnak kid ta natungradanen gahut, a negindan ya hukal kiden ta pagtuhu na gahut kiden, ammi tinappanan na gahut kiden ya tuhu na hukal kiden pettam kumanen awedan makapagmayan. ");
INSERT INTO agt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A ya kadwan kiden hukal a nehunnak kid ta mappya na lutak, a yen kid ya pake dumakal ikid na nakapagmayan maski abat ta magatut. “A am kakurugan ta itta ya bangbang muy a mappya ta pake dangagan muy ya nabidakin tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A sangaw umange tentu ya ituldu na kiden, te pohutan da am anu ya ikayat na uhohugan ta keangarigan na en. ");
INSERT INTO agt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A ya uhohug na tekid a “Mappya te nekallak na kam na Namaratu petta amu muy ya gagangay na pangikerutan na ta tolay kiden, ammi ta kadwan kiden a nelemad tekid, te keangarigan la ya madangag da, petta maski am itta ya mata da a aweda maita ya mepaita tekid. A maski am itta ya bangbang da a aweda pake maawatan ya madangag da. ");
INSERT INTO agt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“A dangagan muy mantu ya pagbalinan na keangarigan ken: Ya hukal kiden nga nepurwak a yen kid ya uhohug na Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A ya itta kiden ta dalanen a yen ya keangarigan na makadangag ta uhohug na Namaratu, ammi gafu ta aweda itug ya madangag da a ange i Satanas tekid a tabtabangan na ya nadangag da en petta aweda kurugan, petta aweda hapa mekerutan. ");
INSERT INTO agt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A ya itta kiden ta kabatunen a yen ya keangarigan na makadangag ta uhohug na Namaratu a alistu kid hapa mangurug ta talak da, ammi gafu ta aweda pake itug ya madangag da en a awena la mabayag na pangikatalak da, te sangaw am itta ya pagzigātān da a magtabeng kid. ");
INSERT INTO agt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A ya itta kiden ta natungradanen gahut a yen hapa ya keangarigan na makadangag ta uhohug, ammi addu hapa sangaw ya burungan da ta magmagannud, ikid na pagba-nang da, ikid na ingguman da a yen kid na nonot ya mangiduyat ta uhohugen. ");
INSERT INTO agt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A ya itta kiden ta mappya en lutak a yen ya keangarigan na makadangag ta uhohug na Namaratu, a itug da hapa ya madangag da, te mappya ikid na matunung ya nonot da, a yen kid mantu ya kuman na ammay nga makapagmayan, te idulot da la idulot ya pangurug da,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“A ta ayanin kuman na napagatangan na ya hilag ta nonot muy gafu ta keangarigan ken, a awemuy mantu ilingad ya hilag muy awa itun muy hud la ta pakaitan na kadwan kiden tolay. Te maski am anu ya melemad ta ayanin a mappya ta mepalawag ta ngamin. ");
INSERT INTO agt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","A kumanen hapa mina ta keangarigan kiden, te maski am kuman na melemad ya ikayat da uhohugan a mappya ta mepalawag kid. ");
INSERT INTO agt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","A pake itug muy mantu ya nadangag muy, te ya kaddu na metug muy a kumanen hapa sangaw ya kaddu na amu muy, otturu madaggan para. Ammi ya awanen mangitug ta netulduken tentu a maazi hala sangaw ya pahig na en ta amu na,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","A ta pagbida na para la a dumatang na hapa ig hina ni Hesus ikid na kabagis na kiden, ammi aweda nakaabikan tentu gafu ta kaddu na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","A yen kid hapa ya nangibar tentu; “Itta kan ta bagaw ig hinam ikid na kabagis mu kiden, te apagan da ka kan,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ammi ya tabbag na tekid a “On ay, ammi intu hapa ig hinak ikid na kabagis ku ya mangdangag ta uhohug na Namaratu petta kurugan da,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","A sangaw ta mittan a binaran ni Hesus ya ituldu na kiden, “Entanan ta dammangewan,” kunna tekid, a naglalugan kid na ta selayag da en, a nagtugut kid. ");
INSERT INTO agt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","A ta pagtugtugut na selayag da en ta danumen a nasidug i Hesus. A kima-ma la umange ya masikan na paddad, a pake nagpalung na ya danumen abat ta lima-nug na ta umag na selayag da en, a tanagay kid na lumammad. ");
INSERT INTO agt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A gafu ta burung da a enda hinukal i Hesus. “Afu, Afu, malimat kitam O,” kunda. A ta nekahukal ni Hesus a nehuya na ya paddad ikid na danumen nga pake nagpalung na, a nagimmang kid na, a nagsimpan ya danumen. ");
INSERT INTO agt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","“Anu awan haman ta pangikatalak muy,” kunna hapa tekid. A pake nagtalaw kid na. A ya uhohug da hapa gafu ta pagpaka-lat da tentu a “Anu panaw ya katolay na tolayin yan, te maguhohug haman ta paddad ikid na palung, a kurugan da hala ya uhohug na,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","A tekiden nakadatang ta dammang na alugen a itta kid na ta lugar na Geraseno kiden ta batug na Galileya. ");
INSERT INTO agt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","A ta nedagut ni Hesus ta barangayen a nepagka-ma na ya takday lalaki taga ili, ammi nauhagan, te awena pulus nagbarbarawasi gafu ta pinaguyung na anitu na kiden. A awena kan nagyan ta bali, te nagyan la ta agyan na tanam kiden. A kankanayun pagkagtutan na kan na anitu na kiden petta papasin da. A yen ta ginalutan na kadwan kiden ya kamat na kiden ikid na takki na kiden ta kawad petta mataronan da, ammi gasgasatan na hala ya kawad kiden, a pagbilagan na anitu na kiden, petta ange ta awan ta totolay. Ammi tentu en nakaita te Hesus a pake gimihgihawa, kapye na umange nagtakab ta atubang na en, ammi ginamman ni Hesus ya anitu na en; “Pagtugutām na ya tolayina,” kunna. A ka-ma la nagayag hapa ya lalaki en ta masikan; “Anu hud ya aamum teyak, Hesus, te iko ya Anak na Namaratu ewan. Ikallak nak kad, te awenak haen pakākāllakan,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","“A anu hud ya ngagam,” kunna ha ni Hesus tentu. “Ay, Armado ya ngagan ku,” kunna hapa, te adaddu kan ya anitu na. ");
INSERT INTO agt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","A nakimemallak kid hapa te Hesus ta awena kid doban ta agyan na avuten nga pake adadalam. ");
INSERT INTO agt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","“Doban na kami haen ta bahuy kidewan petta magyan kami la tekid,” kunda, te abikan hapa ya addu na bahuy nga magdukdukit ta hukeb na bagetay. ");
INSERT INTO agt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","“A e kanan mantu,” kun ni Hesus tekid. A nagtugutan da ya lalaki en kapye da simarok ta bahuy kiden. A ka-ma la nagadukal ya bahuy kiden bumilag. A sa nagurdak kid ta gatab na bagetayen kapye da nagkahunnak ta alugen, a nagkalimat kid ta danumen. ");
INSERT INTO agt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","A ya nagtahon kiden ta bahuy kiden a nagbabilag kid na hapa nga umange ta ili, a nesaned da ya ngamin iningwa ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A umange hapa ya tolay kiden, te enda itan ya nakkwa. A ta datang da te Hesus a itta hapa ya lalaki en nga nagtugutan na anitu kiden, a imatuttud hapa ta bikat ni Hesus nga sebarawasi, a awan na ya uyung na en. A nagtalaw hapa ya tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","A ya nagtahon kiden ta bahuy nga nakaita ta iningwa ni Hesus a binida da ha ya nepagpamappya na ta nagyanan na anitu kiden. ");
INSERT INTO agt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","A gafu ta nafulotan ya talaw na ngamin kiden tolay ta lugar na Geraseno a nebar da te Hesus ta awena mina magdulot ta lugar da. A nagtoli mantu ta barangayen nagluganan da. ");
INSERT INTO agt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A paalap hapa ya lalaki en nga pinagmappya na ta anitu kiden, petta dumagdag mina tentu, ammi awena nepalubus ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mappya ta dumatang kan mina ta balim, te ipadangag mu sangaw ta kahulum kiden ya ngamin kallak na Namaratu teko,” kunna tentu. A nagtugut mantu ya lalaki en, a enna nepadangag ya kallak ni Hesus tentu ta ngamin na ili. ");
INSERT INTO agt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","A ta nepakadakit nig Hesus ta dammang na alugen a enna pinagdulot na addu na tolay, te indagan da ya pagtoli na. ");
INSERT INTO agt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","A nehulun hapa tekid ya takday lalaki nga magngagan te Hayrus nga pinakadakal ta kapilya na Hudyo kiden. A umange namalentud ta atubang ni Hesus nga nakimemallak tentu, petta ange mina i Hesus ta bali na, ");
INSERT INTO agt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","te ya anak na en balatang a mementu en anak na, a masin. A nehulun mantu i Hesus tentu, a naghahulun hapa ya magamagaddu na tolay nga ange mangiil-ilat te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A nekihu hapa tekid ya takday babbay nga makataktakit, te makadagdaga kan abat ta mafulu duwa na darun. A maski addu ya nanguru tentu a awena garay nagmappya. ");
INSERT INTO agt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A simalsal hapa ta talekud ni Hesus, a sini-ged na ya kayadan na salnuk na en, a yen hapa ya nepagkamag na pagdaga na. ");
INSERT INTO agt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ammi tentu en nangsi-ged tentu a nagtayuk hapa i Hesus, a nebar na ta “Inya hud ya nangsi-ged teyak,” kunna, “Bakkan teyak,” kunna hapa na ngamin kiden kumalihung tentu. A ya uhohug hapa ni Pedru tentu a, “Addu haman, Afu, ya magitaptapal nagsi-ged teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","“Awan, te itta ya takday nangsi-ged teyak, te nariknak ya nagafu ta barikin nga nagpamappya ta nagtakit,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A gafu ta awena nakatagu na babbayen a umange hapa namalentud ta atubang ni Hesus a nagapilpilpig hapa. A sa binida na ya ngamin nepagtakit na ikid na nepagmappya na ta nepangsi-ged na ta barawasi ni Hesus. A ya uhohug ni Hesus tentu a ");
INSERT INTO agt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","“Mappya, Aboy, te nekatalak nak, te yen ya nagmappyam. Dumatang kan la ta bali, a awem la sangaw magburung,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","A tentu para la naguhohug ta babbayen a itta ya umange nangdafung tekid nga nagafu ta bali ni Hayrus. “Maski awem na pagdulotan ya Mistro ta bali, te nasin haman ya anak men,” kunna te Hayrus. ");
INSERT INTO agt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ammi nedangagan hapa ni Hesus ya inuhohug na, a ya nebar na tentu a “Awem la magburung, te itug mu la ya pangikatalak mu a magmappya hala sangaw ya anak men,” kunna te Hayrus. ");
INSERT INTO agt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","A ta datang da ta bali a nehangat ni Hesus ta simarok ya kadwan kiden tekid, te intu la inalap na ig Pedru, ikid ni Hwan, ikid ni Santiago, kontodu dadagkal na abbingen. ");
INSERT INTO agt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A dinatangan da ya tolay kiden nga gisitangan ikid na gitangitan ta masikan gafu ta abbingen nasi. A ya uhohug ni Hesus tekid a “Awemuy mina magtangit, te nasi hud ya abbingina awa masidug la,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","A nekakatawa da hapa, te amu da haman ta nasin. ");
INSERT INTO agt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ammi inibbalan na ya kamat na abbingen kapye na binaran; “Aboy, imivwat kan,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A natolay hala ya abbingen, a mavit kad la imivwat. “Pakanan muy na,” kunna hapa ni Hesus tekid, ");
INSERT INTO agt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","a pake nepagpaka-lat na dakal na kiden ya katolay na anak da en, ammi pake nebar ni Hesus ta aweda ibabar ya nepagpamappya na ta anak da en. ");
INSERT INTO agt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A ta takday araw a pinagammung ni Hesus ya mafulu duwa kiden ituldu na, a pinasinapan na kid ta pakapangwa na, petta itta ya mabalinan da nga magpamappya ta takit ikid na magpatugut ta anitu na tolay kiden seanitu. ");
INSERT INTO agt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","A dinob na kid hapa, petta e kid mangipadangag ta pangikerutan na Namaratu, ikid na magpamappya ta nagtatākit kiden. ");
INSERT INTO agt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A ya nebar na tekid a “Awemuy pulus magbalun ta kanan muy ikid na pirak muy. A awemuy hapa mangihulun ta sarukud ikid na pagsapatos, ikid na tali na barawasi muy. ");
INSERT INTO agt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","A maski am inya sangaw ya magpadulot tekamuy ta bali da a magyan kam ten abat ta pagtugut muy. ");
INSERT INTO agt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ammi am awan pulus ta magpadulot tekamuy a pagtugutān muy kid mantu, a azin muy hapa ya lafu na agyan da ta takki muy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A nagtatugut kid mantu, a sinaned da ya ngamin kiden babali, a nepadangag da ya damag ni Hesus, yaga pinagmappya da ya nagtatākit ta ngamin kiden lugar. ");
INSERT INTO agt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","A ta nepakadamag ni Ari en Herud ta itta ya malalaki magpamappya ta nagtatākit kiden, a napopoyung hapa am inya na tolay ya gafu na, te ya binida na kadwan a natolay hala i mina Hwanen nga nepapapasi ni Herud, a yen kan ta itta ya pakapangwa na nga magpamappya ta tolay. ");
INSERT INTO agt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ammi ta bida na kadwan a nagtoli kan ya aglavunen Eliyas. A ta bida na kadwan para a natolay hala kan ya takday aglavun nga nasi ta palungu araw. ");
INSERT INTO agt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ammi ya uhohug ni Herud hapa a “Pinaputulan ku haman i Hwan, ammi inya panaw ya tolayin yan nga madamdamag ku?” kunna. A yen ta ikayat na kan itan am inya yen. ");
INSERT INTO agt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","A ta nepagtoli na turin kiden ni Hesus nga dinob na mangipadangag a binida da tentu ya ngamin tarabaku da. A sangaw inalap na kid ta ili na Betsayda. ");
INSERT INTO agt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ammi nadamag na tolay kiden ta nagtugut kid, a dinadagdag da kid hapa. A ta nepakaita ni Hesus ta tolay kiden a nehulun na kid hapa, a netuldu na kid hapa ta gagangay na pangikerutan na Namaratu, yaga pinagmappya na hapa ya nagtatākit tekid. ");
INSERT INTO agt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","A ta furab a nagburung ya ituldu na kiden ta tolay kiden, a enda nebar te Hesus. “Mappya, Afu, ta patugutam ya tolay kidin, petta e kid magammak ikid na gumatang ta pamuhab da ta babali kidewan, te awan haman ta pangalapan ta isin,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","“A ikamuy na mina ya mangatad ta kanan da,” kunna hapa tekid. “A itta hud ya ipakan mi tekid bakawa lilima haman la na pan ikid na duduwa la na ikan ya itta. Ikayat mu hud ta e kami gumatang ta ipakan mi ta ngamin tolay kidin yan?” kunda hapa, ");
INSERT INTO agt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","te itta de ya limaribu na lalaki fwera ta bābāy ikid na anak. A ya uhohug ha ni Hesus tekid a “Pagammungan muy mantu ya tolay kiden ta taglimafulu, a pagtuttudan muy kid,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A gafu ta kumanen a pinagtuttud da kid, ");
INSERT INTO agt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","a inalap ni Hesus ya lima kiden na pan ikid na dwahukal na ikan, a yen kid ya netangad na nepakimallak. A sangaw ginadgadwa na ya pan kiden ikid na ikan kiden, kapye na kid negawat ta ituldu na kiden petta ikid ya mangisaned ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","A sa nagkakan kid abat ta nabattug kid. A tekid na nabalin nagkakan a pinannu da ya mafulu duwa na la-ba ta huna na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","A ta takday araw a tatakday la i Hesus ta sang abikan ta ituldu na kiden, a itta ya pinohutan na tekid. “Anu kan ya pangitan na tolay kiden teyak am inya yak?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","“A pahig na kadwan ta iko i Hwanen nga nangzigut ta tolay nga pinapasi da ta kwa en sina. Ammi ta kadwan a pahig da ta iko ya aglavunen Eliyas nga magtoli kan ta lutakin. A pahig na kadwan para ta iko ya takday aglavun nga nasi ta palungu araw,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“A ikamuy ay, anu hapa ya pangitan muy teyak?” kunna ha tekid. A i Simon Pedru ya alistu tumabbag; “Iko ya Mangikerutanen nga netun na Namaratu ta pinakadama mi,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","A pake nebar ni Hesus tekid ta aweda mina bibidan yen ta kadwan kiden tolay, kapye na nebar ta ");
INSERT INTO agt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Mappya ta pakākāllakan da sangaw ya Tolayin taga Langit, te idadula da sangaw na kalalaklakayan kiden ikid na padi kiden ikid na mangituldu kiden, kapye da sangaw papasin, ammi matolayak hala sangaw am nagpasa ya talluhaw,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","A ya uhohug na para tekid a “Am itta ya mayat dumagdag teyak a mappya ta pagtalekudan na ya bari na. A am kada magganwat ta lalakwat a dana itug na mina ya pagattam na ta zigat na pangurug na teyak, petta dumagdag la teyak. ");
INSERT INTO agt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Te maski am inya ya mangkenga ta angat na a masi hala sangaw ta magnayun. Ammi ya mangisagapil ta angat na gafu ta pangurug na teyak a matolay hala sangaw nga magnayun. ");
INSERT INTO agt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Te maski am itta mina ya tolay nga nakaalap ta ngamin kiden magmagannud ta paglelehutin a itta hud sangaw ya kappyanan na tentu am nawakay ya kahalwa na ta pasi na? ");
INSERT INTO agt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","A maski am inya sangaw ya mamat mangibosag teyak ikid na uhohug ku a yen hapa sangaw ya ikamat ku am magtoli yak sangaw ta lutakin nga mangihulun ta pakapangwa ni Damakewan ikid na anghel na kiden. ");
INSERT INTO agt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A kustu hapa ya ibar ku tekamuy ta matolay la ya kadwan kiden tekamuy addet ta maita da sangaw ya pakaitan na pagariyan na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","A ta nepagpasa na magge walu araw a inalap na ig Pedru, ikid ni Hwan ikid ni Santiago, te umange kid ta ata-nang na bagetay petta makimallak kid. ");
INSERT INTO agt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","A tentu en nakimallak a nanguli hapa ya bari na en, a pake nagfuraw ya barawasi na en, te nagdakar ta kuman na kadakar na bilag. ");
INSERT INTO agt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","32","Dana nasidug ig Pedru ikid na kahulun na kiden, ammi nagadukal kid, a nepagka-ma da hapa ya kalalaki ni Hesus. A itta hapa ya duwa na tolay nga nagbida tentu, ig mina Moses, ikid ni Eliyas, te nagmatakar kid hapa nga sedakar. A intu bidan da ya pasi ni Hesus nga magdulot sangaw ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","A ta pagganwat na duwa kiden magtugut te Hesus a nagsitang hapa i Pedru; “Ay Afu, mappya te itta kamin sin, te mamadday kami mina ta tallu na monumento, petta tagtakday kam ni Moses ikid ni Eliyas ta monumento,” kunna. Ammi kuman na nagalimanga i Pedru, te ka-ma la naguhohug. ");
INSERT INTO agt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","A kima-ma la hapa ya kulamen nga imakban tekid, a tinappanan na kid, a sa nagtalaw ig Pedru. ");
INSERT INTO agt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","A nadangag da hapa ya maguhohug tekid ta umag na kulamen, “Ye ye-yan ya Anak kin nga pake iddukan ku. Mappya ta dangagan muy ya ituldu na tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","A ta nekabalin na naguhohug tekid a intu la naita da i Hesusen, te limitap ya duwa kiden. A sangaw nelemad da ya naita da ta kadwan kiden kahulun da, a aweda pulus binibida addet ta mabayag. ");
INSERT INTO agt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A ta lalakwat tekid na nakadagut ta bagetayen a enna kid dinafung na addu na tolay. ");
INSERT INTO agt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A ya takday lalaki tekid a binaran na i Hesus; “Mistro, ikallak mu haen ya anak kin nga mementu in anak ku, ");
INSERT INTO agt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","te itta garay ya anitu na. A am pagkagtutan na anitu na en a gimihawa. A sangaw am pagkissiwan na, a pagdangkakan na hapa ta lutak, a paglukbakan na para, a awena ibbatan. ");
INSERT INTO agt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","‘Patugutan muy haen ya anitu na in,’ kunku ta ituldum kidin sin, ammi aweda haman nabalinan,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A ya uhohug hapa ni Hesus a “Kuga awan ta kapkappyan na tolay kidin yan nga awan mangikatalak. Bababang ya kabayag ku tekamuy nga mangitultuldu, ammi awemuy para la netug. Iangem mantu sin ya anak men,” kunna ta lalaki en. ");
INSERT INTO agt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","A tentu en nangiange ta anak na en tentu a ka-ma la pinagkissiw na anitu na en. Ammi ginamman ni Hesus ya anitu en a nagmappyan ya abbingen, a “Yeh, alapam na,” kunna te dama na en. ");
INSERT INTO agt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A sa nagpaka-lat ya tolay kiden ta kalalaki na pakapangwa na Namaratu. A ta pagbabida para la na tolay kiden ta pagpaka-lat da ta iningwa ni Hesus a naguhohug hapa i Hesus ta ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Dangagan muy ya uhohugan na tolay kiden gafu teyak, te itta sangaw ya mangitalaba ta Tolayin taga Langit, petta gafutan na mangikatupag kiden tentu,” kunna tekid, ");
INSERT INTO agt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ammi aweda naawatan ya ikayat na uhohugan, te nelemad para la tekid, a mamat kid mangibar. ");
INSERT INTO agt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A sangaw nakidibati ya ituldu na kiden, te pagtatabbagan da am inya tekid ya pinakadakal da. ");
INSERT INTO agt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ammi amu ni Hesus ya itta ta nonot da, a pinahebing na tentu ya takday abbing, kapye na hapa naguhohug ta ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Maski am inya ya mangtagop ta kumanin na abbing gafu ta pangurug na teyak a mekwenta ta iyak hapa ya tinagop na, a ya mangtagop teyak a bakkan la ta iyak ya tagopan na am awa nangidoben hapa teyak. Intu mantu pinakadakal muy ya imalinnak ta nonot na ta kuman na abbing,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","A sangaw nanonot hapa ni Hwan ya ibar na te Hesus, “Afu, itta ya naita mi nga magpatugut ta anitu na seanitu kiden, ammi ngaganan na hapa ya ngagam, ammi ginamman mi te awena haman mehulun tekitam,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Awemuy mina gamman ya kumanen, te ya awan mangikatupag tekitam a kahulun tam hapa,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","A gafu ta tanagay na ya araw na pagtoli ni Hesus ta langit a sarukusukan na ya magdulot ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A dinob na ya imunnan ta lugar na Samariya, petta iparan da mina ya pagammakan da. ");
INSERT INTO agt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ammi ya tolay kiden ten a aweda ikayat pagdulotan i Hesus ta agyan da, te amu da ta ili na Herusalem ya pake datangan na. ");
INSERT INTO agt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","A ta pakadangag nig Santiago ikid ni Hwan ta nebar na taga Samariya kiden a nagporay kid, a nebar da te Hesus, “Am ikayat mu, Afu, a makimallak kami ta Namaratu petta ihunnak na mina ya afuy ta agyan da petta maapang kid,” kunda, ");
INSERT INTO agt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","ammi ginamman na kid. A nagdulot kid na ta takwan na lugar. ");
INSERT INTO agt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","A tekiden nagtugtugut ta dalanen a umabikan hapa tentu ya takday tolay, a binaran na i Hesus; “O, Mistro, dumagdagak hapa teko, te maski am had ya eyam,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","“A kakallak ka sangaw am dumagdag ka teyak, te mapmappya ya kasasaad ni mungaw ikid na mamanuk ammi teyak, te itta ya pagsigongan da, ammi teyak nga Tolayin taga Langit a awan garay ta datangan ku ta pagibannagan ku mina,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A sangaw naita ni Hesus ya takday a “Dumagdag kan teyak,” kunna tentu. Ammi ya tabbag na hapa a “Indagan ku bit ya pasi ni damaken te itanam ku,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ammi ya uhohug ni Hesus tentu a, “Bay-am la, te ya awan kiden matolay ta Namaratu ya makkamu mangitanam ta nasi, ammi teko a dumagdag kan teyak, petta ipadangag mu ya pangikerutan na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A umange ha ya takday para, a “Dumagdagak hapa, Afu, ammi eyak mina bit ibar ta kahulun ku kiden ta bali,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A ya tabbag hapa ni Hesus tentu a “Am namegafu kan nagaradu otturu magsagalipay ka ta gafam a awem megitta ta iturayan na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","A ta takday ha na araw a nagpili i Hesus ta pitufulu duwa na lalaki, te doban na ya sagduwa, petta mapmapolu kid ammi tentu nga ange mangipadangag ta uhohug na Namaratu petta dana meparan ya tagtakday lugar nga angeyan na hapa sangaw. ");
INSERT INTO agt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A ya nebar na en tekid a “Addu para ya awan nakadangag ta damag na Namaratu, te kuman kid na alawa na kāmmayān nga awan para la nagataban, ammi assang la garay ya ange maggatab. A doban ta kanan mantu, ammi magadang kam hapa ta Dafu na paggatabanen petta daggan na para ya ange maggatab ta paggataban na en. ");
INSERT INTO agt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","A imugudan muy hapa, te doban ta kanan nga ange mangipadangag ta agyan na mangikatupag tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","A awemuy magbalun ta pirak, a awemuy hapa mangihulun ta tali na sapatos muy ono kompormi na ibbalan muy. A awemuy hapa magtalantan ta dalan nga makibidan ta maski inya na tolay. ");
INSERT INTO agt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“A am gimon kam ta bali na pagdulotan muy a ‘Namaratu ya mangbendisyon tekamuy,’ kummuy tekid. ");
INSERT INTO agt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","A am itta ya mayat nga mekerutan tekid a masirak hala ya bendisyon na Namaratu tentu. Ammi ya awan kiden mayat a awan mantu ta masirak muy tekid. ");
INSERT INTO agt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","A maski am had sin na bali ya pagdulotan muy ta tagtakday lugar a awemuy magal-alit ta kadwan kiden bali, te magyan kam la ten nga mangan ikid na uminum ta iatubang da tekamuy, te gagangay ta yen ya kuman na tandan muy gafu ta tarabaku muy nga mangipadangag tekid. ");
INSERT INTO agt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","A kumanen hapa ta tagtakday lugar nga eyan muy, te am had sin na bali ya pagyanan muy a kanan muy la ya iatubang da tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","A am itta ya magtatākit ta lugar da a pagmappyan muy kid, a ipadangag muy ya pangikerutan na Namaratu tekid petta mesipat kid hapa. ");
INSERT INTO agt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Ammi am angarigan ta simarok kam ta takday na lugar, a awan ta magpadulot tekamuy a pagtugutan muy kid mantu, a ibar muy tekid, ");
INSERT INTO agt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Azin mi mantu ya lafu na lugar muy ta takki mi kiden gafu ta awemuy dangagan, petta amu muy ta liwat muy hapa la am pa-gangan na kam na Namaratu. Ammi amu muy mina ta intu nagtalekudan muy ya pangikerutan na Namaratu tekamuy,’ kummuy sangaw tekid. ");
INSERT INTO agt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Te kakurugan ta dakdakal sangaw ya pangpa-gang na Namaratu tekid ammi ta tolay kiden nga taga Sodom nga kanayun namadday ta awan ta kapkappyan ta idi,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","A ya uhohug na para tekid a “Mapa-gang sangaw ya Hudyo kiden nga taga Korazin ikid na Betsayda, te maski naita da ya tarabaku na Namaratu a aweda haman nagbabawi ta pagliwat da. Ammi am kumanen mina ya naita na Hentil kiden nga taga Tiro ikid na Sidon ta idi a nagtuttud kid mina ta kalafukan nga nagbarawasi ta kustal gafu ta pagbabawi da. ");
INSERT INTO agt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","A yen ta pake kakallak sangaw ya Hudyo kidina ammi ta Hentil kiden nga taga Tiro ikid na Sidon ta araw na pangpa-gang na Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kumanen hapa sangaw ta Hudyo kiden nga taga Kapernayum, te pahig da ta dayawan na kid sangaw na Namaratu, ammi mewarad kid sangaw ta pangtaguhali na en, te aweda haman magbabawi. ");
INSERT INTO agt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“A kumanen hapa sangaw ta eyan muy kiden nga lugar, te ya mayat mangdangag tekamuy a mekwenta ta iyak ya dangagan na, ammi ya mangawe tekamuy a mekwenta ta iyak ya inawe na. A ya mangawe teyak a mekwenta ta inawe na hapa ya nangidob teyak,” kunna tekid, a sangaw nagtatugut kid. ");
INSERT INTO agt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","A ta pagtoli na pitufulu duwa kiden nga dinob ni Hesus a pake matalakan kid. “O, Afu,” kunda tentu, “Magtalaw hapa ya anitu kiden tekami am patugutan mi kid ta pakapangwa na ngagam,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A ya uhohug na hapa tekid a “Naitak hapa ya pagtukalit na dafu da en Satanas ta kuman na pagsunak na kilat gafu ta pagpatugut muy ta daddoban na kidina. ");
INSERT INTO agt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","A yen mina ya pagnonotan muy, te neatad kun tekamuy ya pakapangwa muy, petta maabak muy ya ulag ikid na manggagama, ikid na ngamin kasikanan na katapil tam, a awan ta makkwa na tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ammi maski kunna ten a bakkan mina ta yen ya pakatalakan muy, te intu mina ikatalak muy ya pakesurat na ngagan muy ta agyan na Namaratu ewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A ta nepaguhohug ni Hesus ta kumanen a pa nakimallak hapa ta Namaratu, te natalakan hapa gafu ta Kahalwa na Namaratu tentu. “Matalakak hapa teko, Amang, nga makkamu ta ngamin langit ikid na lutak, te nelemad mu ya pakapangwam ta masirib kiden ikid na seadal kiden, a nepaitam ta kuman na abbing kidin. A mappya hapa yen, Amang, te nagdulot hala ya ikayat men,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","A ya uhohug na hapa ta tolay kiden nga nagdangag a “Nekatalak nak ni Damakewan petta iyak ya makkamu ta ngamin, a awan ta makkamu teyak am bakkan la te Damakewan. A awan hapa ta makkamu te Damakewan am bakkan la ta iyak ikid na ikayat ku pangipakkamun tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A sangaw tinubbat na ha ya ituldu na kiden nga kinabida petta ikid la ya makadangag ta ibar na, “Dakal ya gāsāt muy gafu ta ngamin kiden naita muy. ");
INSERT INTO agt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Te ya ari kiden ikid na aglavun kiden ta idi a pake karagatan da itan ya maita muy ta ayanin, a karagatan da hapa dangagan ya madangag muy, ammi nelogot kid gafu ta aweda nadatang ya araw na,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","A ta takday ha na araw a nagtayuk ya takday abugadu nga mangpohut te Hesus petta paruban na. “Mistro, ibar mu haen am anu mina ya tarabakuk petta maatadanak sangaw ta magnayun na angat,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A ya uhohug hapa ni Hesus tentu a “A amum haman ya lintig na Namaratu, a imanu hud ya binasam?” kunna. ");
INSERT INTO agt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","“A ya kuman na binasak a iddukan ku kan mina ya Dafu tam Namaratu ta ngamin nonot ku ikid na ngamin kasikan na barik. A iddukan ku kan hapa ya kagittak tolay ta kuman na pangidduk ku ta barik,” kunna ha na abugadu en. ");
INSERT INTO agt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“A kustu kad ya tabbag mina, te am yen kid ya tarabakum a matolay ka hala sangaw,” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","“A onay, ammi inya hud ya kagittak tolay?” kunna ha na abugadu en, te ial-aliki na ya awena pangidduk. ");
INSERT INTO agt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A gafu ta kumanen a takwan ya binida ni Hesus tentu: “Itta ta idi ya takday lalaki nga taga ili na Herusalem,” kunna. “A umange mina magpasyar ta ili na Heriku. Ammi kadulayan na te nelakap na tulisan kiden ta dalan, a pinalpaluk da abat ta magge nasi, kapye da ginubatan ya ngamin kwa na, kontodu barawasi na, a newagak da. ");
INSERT INTO agt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“A sangaw nagtalib hapa ya takday padi nga kalugaran na lalaki en. Ammi tentu en nakaita ta lalaki en nga imaidda ta dalan a linillikan na haman, a nagdulot ta eyan na en. ");
INSERT INTO agt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","A kumanen hapa ta takday manguffun ta padi en, te timunud ta padi en. A tentu nakaita ta lalaki en a linillikan na hapa. ");
INSERT INTO agt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","A sangaw a timunud hapa ya mekatallu na tolay, ammi nagafu ta takwan na lugar, te taga Samariya. “A tentu en nakaita ta lalaki en ta kakallak hapa a maallakan hapa tentu, ");
INSERT INTO agt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","a enna inurun ya bigad na kiden, kapye na kid binabbad. A sangaw netakay na hapa ta kabayu na en, kapye na nedatang ta agyan na takday agpadulotan, a tinaronan na ta hiklamin yen. ");
INSERT INTO agt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","A sangaw ta lalakwat a nesirak na ya pirak ta makākwa ta agpadulotanen petta taronan na bit ya lalaki en. ‘Taronam bit haen ya tolayin yan, a am magkurang sangaw ya neatad kina a iko sangaw ya makkamu ta maapag na, te pagan ku hapa sangaw teko am manoli yak sin,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“A ta kuman na uray mu ta tallu kiden nga nakaita ta Hudyo en a inya tekid ya nangikwenta tentu ta kagitta na?” kun ni Hesus ta abugadu en. ");
INSERT INTO agt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“A ya nangikallaken tentu nga taga Samariya,” kunna hapa. “A yen hapa ya parigam, a matolay ka sangaw,” kunna ha ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","A ta nekabalin na ten a nagdulot ig Hesus ikid na ituldu na kiden ta takday lugar na babali, a nagimmang kid ta bali na takday babbay nga nagngagan ta Marta, a pinagdulot na kid ta bali. ");
INSERT INTO agt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Itta hapa ya kabagis ni Marta nga babbay hapa, a Mariya ya ngagan na. A ikayat ni Mariya ya imatuttud la ta bikat ni Hesus petta dangagan ya ituldu na. ");
INSERT INTO agt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ammi te Marta a awena pake tinagop ya magdangag gafu ta addu ya kapopoyungan na ta tarabaku na en magafuy. A sangaw nebar na te Hesus, “Anu awenak ikallak, Afu, ta uffunan nak mina na kabagis kina, te tatakdayak na nga magafuy ikid na maglutu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A ya tabbag hapa ni Hesus tentu a “Kuga addu ya burungam, Marta, ikid na kapopoyungam, ");
INSERT INTO agt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ammi tatakday la ya mesasita, a pinili ni Mariya ya kappyanan nga awan sangaw maazi tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","A ta takday ha na araw a makimallak i Hesus ta takday lugar, a tentun nagimmang a umange hapa ya takday ituldu na tentu nga magpetuldu ta pakimallak na; “Mappya hapa, Afu, am ituldu na kami nga makimallak ta kuman na nepangituldu ni mina Hwanen ta ituldu na kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A ya nebar ni Hesus tekid a “Am makimallak kam ta Namaratu a kumanin ya uhohugan muy: ‘Ay, Afu, nga Dama mi ta langit, ampade madaydayawan ya ngagan to ngamin kiden lugar, petta sa ikamat da ya ngagam, ikid na makituray kid teko. ");
INSERT INTO agt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","A ikallak na kami hapa, te atadan na kami ta kanan mi ta kinanghahaw. ");
INSERT INTO agt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","A pakoman na kami haen ta liwat mi kiden, te pakoman mi hapa ya makaliwat tekami. A awena kami doban ta pagliwatan mi. Amen,’” kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","A ya netulfu na hapa ta netuldu na en nga pakimallak da a intu yan: “Am angarigan ta itta ya sangaili na takday tekamuy nga dumatang ta tangngan na hiklam, ikid na awan ta ipakan na tentu, a awena hud ange gumatut ta karuba na en? ");
INSERT INTO agt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Te ya ibar na sangaw tentu a ‘O, kofun, pagatutan nak haen ta tallu supa la, te itta ya sangailik nga bagu dumatang, a awan ta ipakan ku tentu,’ awena hud kumin tentu? ");
INSERT INTO agt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","8","A am tabbagan na hapa ta ‘O awenak tabtabangan O, te nelitup ya bali in. Awek makaatad ta ayanin, te makakasidug kamin na anak kiden,’ am kunna, a awena hud pakolangan na magadangen gafu ta magkofun kid? A maski am awena ikayat imivwat gafu ta pagkofun da, am pakolangan na la a imivwat hala sangaw petta iatad na ya masapul na gafu ta awena magimmang na magadangen. ");
INSERT INTO agt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ammi bakkan ta kunna ten na gagangay na Namaratu, te am itta ya masapul muy a adangan muy mantu la tentu, a iatad na hala tekamuy. Te am pake apagan muy ya ikayat muyen tentu a ituldu na hala tekamuy. A am intu ya pake baran muy a tabbagan na kam hapa. ");
INSERT INTO agt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Te ya magadang tentu a yen ya atadan na, a ya magapag tentu a yen ya ituldu na, a ya mangbar tentu a yen ya tabbagan na hapa. ");
INSERT INTO agt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Te am angarigan mina ta magadang ya anak muy ta daldalag a ulag hud ya iatad muy? ");
INSERT INTO agt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","A am iplug ya adangan na a manggagama hud ya iatad muy? ");
INSERT INTO agt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A yen mina ya pagnonotan muy, te ikamuy nga seliwat a amu muy haman ya mangatad ta kappyanan ta anak muy. A pake mekatalak para ya Dama muyewan Namaratu nga mangatad ta mappya ta ngamin kiden magadang tentu, te doban na ya Kahalwa na en nga manguffun tekamuy.” ");
INSERT INTO agt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","A ta takday ha na araw a patugutan ni Hesus ya anitu nga nagpaumal ta seanitu en. A ta nepagtugut na anitu en a nakauhohug na ya umalen, a pake nakagtut hapa ya tolay kiden gafu ta pakapangwa ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ammi ya uhohug na kadwan kiden a “Itta malat ya Satanas tentu nga mayor na anitu kiden, a yen ta itta ya mabalinan na nga magpatugut ta anitu,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","(-) ");
INSERT INTO agt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","18","Ammi dana amu ni Hesus ya nonot da, a tinabbag na ya uhohug da; “Am kakurugan mina ta Satanas ya nangatad ta pakapatugut ku ta sakā anitu na kiden a nakikattway mantu ya dafu da en tekid, a naperdin mina ya patarabaku na tekid. Te maski am had sin na gubyernu am makikattway ya tolay na kiden nga magtatāpil a awena hud sangaw maperdi na gubyernu da? Kumanen hapa am makikattway mina ya makipagyan kiden ta takday na bali a maperdi hapa ya pagkakahulun da. ");
INSERT INTO agt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A am uray muy ta Satanas ya pangalapan ku ta pakapatugut ku ta anitu a had sin mantu ya pangalapan na kagitta muy kiden ta pakapatugut da? Ikid mantu sangaw ya mangipasikkal ta pagkilluyan na razon muy. ");
INSERT INTO agt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","“Ammi ta kakurugan a patugutan ku ya anitu gafu ta pakapangwa na Namaratu, a yen mina ya pakkamun muy ta ittan tekamuy ya nesaad na Namaratu nga magturay ta ngamin. ");
INSERT INTO agt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","23","“A yen mina ya pagnonotan muy, te ya awan makikahulun teyak a mekwenta ta ikatupag nak, a ya awan makipagammung teyak a mekwenta ta mangkutkutet. A am itta ya nakagubat ta bali na takday gafu ta ibbalan na kiden a awena sangaw burungan ya nagubat na en bali. Ammi am ange ya masmasikan ammi tentu a perdin na ya ibbalan na kiden nga nekatalak na kapye na patugutan ya nanggubaten, a itoli na ya bali ta makabali en. ");
INSERT INTO agt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“A am angarigan ta itta ya nagtugutan na anitu a nonotan muy mina ya uray na anitu en, te ange makakalkalay ta bagbagetay kiden nga magapag ta pagyanan na, ammi gafu ta awan ta maapagan na a ‘Asakay, paruban ku la magtoli ta nagtugutan ken,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A am maita na ta nagmappyan ya tolayen, ikid na awan ta mangihangat tentu ");
INSERT INTO agt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","a ange bit mangalap ta pitu ta sakā anitu na kiden nga pake duldulay ammi tentu, a sa simarok kid na petta magyan kid ta tolayen. A pake nagduldulay ya kasasaad na tolayen ta pagyan na pitu kiden anitu ammi ta ketta para la na takdayen,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","A ta nepaguhohug nan ta isin a ka-ma la nagsitang hapa ya takday babbay nga nekihu ta tolay kiden nagdangag; “Nagāsāt kad i hinam, Aleng, nga naganak teko ikid na nagpasusu teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A ya tabbag hapa ni Hesus a “Kustu ya uhohug mina, Ina, ammi pake nagāsāt para ya mangdangag ikid na mangitug ta uhohug na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","(v 16,29) A ya uhohug hapa na kadwan kiden te Hesus a “Itta mina ya ipaitam tekami ta pakapangwam, petta pakaitan mi am Namaratu ya nangidob teko,” kunda, te pangparuba da tentu. A pake imaddun hapa ya tolay kiden ange magdangag tentu. A ya netabbag na tekid a “Kuga nagdupal ya tolay kidin ta ayanin nga kanayun magadang ta pakaitan da. Ammi awan sangaw ta mepaita tekamuy, te mappya ta intu pagnonotan muy ya nakkwa te mina Honasen. ");
INSERT INTO agt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","32","Te linintuk bit na ikanen kapye na neadwa ta mekatallu araw a natolay hala i mina Honasen, a yen ya nakaitan na taga Ninaba kiden ta Namaratu ya nangidob tentu, a nagbabawi kid hapa gafu ta nepadangag ni mina Honas tekid. Ammi ya itta in sin nga mangipadangag tekamuy a pake malmalalaki para ammi te mina Honasen, a soysoyan muy haman ya uhohug na tekamuy. Ammi am nasin sangaw ya Tolayin taga Langit a matolay hala sangaw ta kuman ni mina Honasen, a yen sangaw ya pakaitan muy ta Namaratu ya nagafun na. A sangaw ta araw na pangpa-gang na Namaratu a ya taga Ninaba kiden ya mangpaliwat tekamuy gafu ta awemuy nangurug. “A yen para sangaw ya takday mangpaliwat tekamuy ya babbayen ari ta lugar na Syiba, te nagafu haman ta pake adayu na lugar, petta dangagan na ya amu ni mina Ari en Solomun nga neatad na Namaratu tentu, ammi ya itta in sin tekamuy a pake malmalalaki para ya amu na ammi te mina Solomun, a awemuy haman kurugan. ");
INSERT INTO agt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ya inuhohug ku takamuy ta ayanin a kuman na zilag nga pinagatangan ku, a gustu ya dakar na petta maita muy ya ikayat na uhohugan. ");
INSERT INTO agt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A ya mata muy kidina ya mangatad mina ta dakar na bari muy, a am mappya ya mata muy a sa madakaran ya ngamin bari muy. Ammi am dulay ya mata muy a sugiram hapa sangaw ya ngamin bari muy. ");
INSERT INTO agt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","A imugudan muy mantu, te am kakurugan ta masugiram ya pahig muy ta madakar a melogot kam. ");
INSERT INTO agt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Te am mappya la ya ngamin nonot muy petta awan pulus ta sugiram na a kanayun madadakkaran kam ta kuman na pangdakar na zilag ta bari muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","A ta nekabalin ni Hesus nagbida a itta ya takday Pariseyu nga nangagagay tentu ta bali na en petta makikkanan kid, a umange mantu i Hesus nga nakiatubang ta kadwan kiden. ");
INSERT INTO agt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ammi nakagtut hapa ya Pariseyu en te Hesusen gafu ta awena nagbaggaw ta kuman na gagangay na Hudyo kiden kapye na mangan. A gafu ta nakagtut ya Pariseyu en a itta ya nebar ni Hesus tentu; ");
INSERT INTO agt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","“A ta kuman na ikamuy nga Pariseyu a pakappyan muy ya bari muy petta ispot ya maita na tolay, ammi ilemad muy haman ya itta ta nonot muy nga paginggum muy ikid na kompormi na dulay. ");
INSERT INTO agt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kuman na awan ta nonot muy, te ya namadday ta bari tam a pinadday na hapa ya nonot tam. A am pabaggaw na ya bari muy a awena hud pabaggaw ya nonot muy hapa? ");
INSERT INTO agt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mapmappya mantu ta dana baggawan muy ya nonot muy a sakā mabaggawan hapa sangaw ya ngamin barbari muy. ");
INSERT INTO agt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ammi mapa-gang kam sangaw nga Pariseyu, te am iatad muy ya mekamafulu en ta Namaratu ewan a pake sukatan muy ta mappya petta awena nasurok ikid na awena makurang. Ammi ya pake mesasita en nga patarabaku na tekamuy nga matunung ikid na mangidduk tentu a yen kid haman ya taliban muy. Mapmappya ta yen kid mina ya pake nedulot muy kontodu pangiatad muy ta mekamafulu ta kwa muy. ");
INSERT INTO agt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“A mapa-gang kam para nga Pariseyu, te am makigimung kam a pilin muy ya kaispotan na pagtuttudan, a am itta kam ta kaddun na tolay a karagatan muy hapa ya pangdayaw na tolay kiden tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","A mapa-gang kam para sangaw, te kuman kam na malabag nga awena maita na tolay kiden, a matapangan kid gafu ta pakihulun da tekamuy, te aweda maita ya pakatapangan da,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","A gafu ta inuhohug ni Hesus a tumabbag hapa ya takdayen mangituldu ta lintigen nga kahulun na Pariseyu kiden. “Namatan kami hapa, Mistro, gafu ta inuhohug mu ta Pariseyu kidin,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","“Mapa-gang kam hapa sangaw nga mangituldu,” kunna hapa ni Hesus tentu, “te addu ya patarabaku muy ta awena mabalinan na tolay kiden, a awemuy kid hapa uffunan ta maski assang la. ");
INSERT INTO agt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","A mapa-gang kam para sangaw, te daggan muy ya liwat na dadagkal muy kiden nga namapasi ta aglavun kiden na Namaratu, te am appiyan muy ya tatānam na aglavun kiden a tunan muy kid hapa ta magmagannud na ispot, te ape madamdam kam tekid. A mekabat kam mantu ta pagliwat na dadagkal muy kiden, te tulad la ya pagdamdam na nonot muy tekid. ");
INSERT INTO agt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","A gafu ta kumanen nonotan muy ya ibar na Namaratu ewan: a ‘Mangidobak sangaw ta kadwan para na aglavun ikid na turin ku, ammi papasin da hala sangaw ya kadwan tekid, a pagzigātan da hapa ya kadwan,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“A yen ta ikamuy nga itta ta ayanin ya datangan na kadakalan na pangpa-gang na Namaratu gafu ta pasi na aglavun na kiden addet ta nekaparatu na lutakin. ");
INSERT INTO agt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kakurugan ta ikamuy ngamin nga itta ta ayanin ya pa-gangan na Namaratu gafu ta ngamin kiden pinapasi na dadagkal muy kiden namegafu te mina Abel addet te mina Zikaraya nga pinapasi muy ta hahat na pangiatangan ikid na kapilya. ");
INSERT INTO agt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mapa-gang kam sangaw ikamuy mangituldu ta lintig na Namaratu, te newarad muy haman ya ikayat na uhohugan na lintig na en gafu ta awemuy ikayat mesipat ta nekari na en, a nelogot hapa ya mayat kiden mesipat gafu tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","A ta nepagtugut ni Hesus ta bali en a sakā nehulun hapa ya Pariseyu kiden ikid na mangituldu kiden, te pasikkalan da ya pagpohut da tentu, ");
INSERT INTO agt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","talo am itta sangaw ya ibar na nga pangidaruman da mina tentu. ");
INSERT INTO agt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","A ta pagbabida da para la ta dalan a kimalihung te Hesus ya rinibribu na tolay addet ta naginglublubeg kid, te ikayat da dangagan ya ituldu na. Ammi dana naguhohug bit i Hesus ta ituldu na kiden nga nekihu tekid. “Mappya ta palanan muy ya gagangay na Pariseyu kiden te magimmamappya kid la. ");
INSERT INTO agt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ammi maski am tappanan da ya kadulay da ta ayanin a sa maukadan hala sangaw, a mepakamu hala sangaw ya ngamin nelemad da. ");
INSERT INTO agt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","A mappya mantu ta appiyan muy hapa ya uhohugan muy, te maski am anu ya nean-anisat muy ta agyan na sugiram ikid na umag na bali muy a mepadangag hala sangaw ta dakar petta sa madangag na ngamin tolay. ");
INSERT INTO agt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“A maski am itta ya mayat mamapasi tekamuy gafu ta gagangay muy a awemuy la magtalaw tekid, te maski am papasin da kam a awan ta makkwa da ta kahalwa muy. ");
INSERT INTO agt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","7","Intu mina pagnonotan muy ya passik kiden, te maski am malogon ya paga da ta dapun a awena kid kaliwatan na Namaratu maski ta takday la. Ammi pake mesasita kam para tentu ammi ta addu na passik, te dana nabilang nan ya ngamin kiden huk muy. Awemuy mantu magtalaw ta dumatang tekamuy, te mapmappya hud la ta burungan muy ya pagliwat muy ta Namaratu, te intu haman ya makapapasi ta bari muy pase makewarad ta kahalwa muy ta pangtaguhali na tekamuy, a yen mina ya italaw muy. ");
INSERT INTO agt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“A ya uhohug ku para tekamuy a maski am inya ya mangibosag ta pangurug na teyak ta atubang na tolay a yen hapa sangaw ya ibosag ku ta atubang na anghel kiden na Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ammi ya mangilemad teyak ta atubang na tolay a ilemad ku hapa ta atubang na anghel kiden. ");
INSERT INTO agt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","A maski am itta ya maglibak ta Tolayin taga Langit a mabalin mapakoma, ammi ya mamadpadulay ta tarabaku na Kahalwa na Namaratu a awena mabalin mapakoma. ");
INSERT INTO agt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","A am angarigan ta itta ya mangpaliwat tekamuy ta umag na kapilya da, ono atubang na dafu da, ono gubernador da, a awemuy la burungan ya tabbag muy, ");
INSERT INTO agt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","te sangaw am ittan ya kustu na paguhohug muy a ituldu na kam na Kahalwa na Namaratu ta uhohugan muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","A ta pangituldu para la ni Hesus a itta ya takday lalaki nga nangbar tentu. “Mistro, ibar mu haen te kakaken ta ibingayan nak mina ta nesirak ni minamaken,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ammi ya tabbag ni Hesus tentu a “Iyak hud ya nesaad ta lugar na kwes? Bakkan haman ta iyak ya makkamu am piga mina ya kwam,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","A ya uhohug na para tekid ngamin nga magdangag a “Pake imugudan muy ta awemuy maginggum ta pagba-nang muy, te maski am piga ya kaddu na kwa muy a bakkan ta yen ya mangatad ta pagkappyanan muy,” kunna, ");
INSERT INTO agt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","otturu binida na tekid ya keangarigan na takday naba-nang. “Itta ya takday naba-nang ta idi, a nagsurok ya naalap na ta mula na kiden. ");
INSERT INTO agt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A ya uhohug na ta nonot na en hapa la a ‘Asakay, anu mina ya kwan ku ta kaddu na apit ku, te awan haman ta pangiappiyan ku,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘Mappya ta pasatsat ku ya gitad ku kiden, te magpapaddayak ta kadakalan na kamarin, petta gustun sangaw pangiappiyan ku ta ngamin irik ku ikid na kadwan kiden kwak. ");
INSERT INTO agt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A awek na sangaw magburung, te itta haman ya ngamin teyak maski abat ta addu na darun. A mappya te awek na sangaw magbannag magtarabaku, te manganak la ikid na magidda yak ta talak ku,’ kunna ha na nonot na. ");
INSERT INTO agt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ammi tumubbat hapa ya Namaratu nga naguhohug tentu. ‘Iko ya awan ta nonot, te masi kan sangaw ta hiklamin yan, a amum para sangaw am inya ya makākwa ta ngamin neappiyam,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","A kumanen hapa sangaw ta maguknud ta pagba-nang na ta katolay na sin am awan ta pagba-nang na ta Namaratu,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","A sangaw nedulot ni Hesus ya uhohugan na ta ituldu na kiden; “Yen ya uhohugan ku tekamuy ta awemuy mina burungan ya pagkatolay muy am anu sangaw ya kanan muy ikid na inuman muy, a awemuy mina burungan am anu sangaw ya pagbarawasi muy. ");
INSERT INTO agt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Te Namaratu haman ya nangatad ta bari muy ikid na angat muy, a awena hud iatad ya magserbi ta angat muy ikid na bari muy? ");
INSERT INTO agt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Intu mina pagnonotan muy ya mamanuk kiden, te aweda haman magmula ikid na maggapas, yaga aweda haman maguknud ta kanan da. Ammi mangan kid hala, te Namaratu ya makkamu ta kanan da. Ammi tekamuy a pake mesasita kam tentu ammi ta mamanuk. ");
INSERT INTO agt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A maski am magburung kam a itta hud ya medagga ta pagkatolay muy maski ta takday oras gafu ta pagburung muy? ");
INSERT INTO agt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","A am awan ta medagga muy maski ta assang la ta pagkatolay muy a annun muy mantu burungan ya dakdakal para? ");
INSERT INTO agt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Itan muy hapa ya lappaw kiden awa aweda haman magbannag magdaget ta kuman na barawasi da, ammi magispot kid hala. Te pake is-ispot kid ammi te Ari en mina Solomun, te awena haman negitta na kalalaki na pagbarawasi na ta kalalaki na lappaw kiden. ");
INSERT INTO agt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","A am kumanen mantu ya kalalaki na pabarawasi na Namaratu ta kaddat kiden nga makalimagan kapye da matongradan a awan hud ta pangkenga na tekamuy ta pagbarawasi muy? “Anu haman ta assang la ya pangikatalak muy tentu? ");
INSERT INTO agt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Awemuy mina burungan am had ya pangalapan muy sangaw ta kanan muy ikid na inuman muy, ");
INSERT INTO agt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","petta awemuy megitta ta awan kiden makkamu ta Dyos muy, te yen kid ya kuga mafulotan nga magburung ta pagkatolay da. Ammi ya Dama muy ewan ya makkamu ta ngamin masapul muy, ");
INSERT INTO agt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","a mappya mantu ta karagatan muy ya ikayat na en tekamuy, a sa medagga hala sangaw ya ngamin masapul muy. ");
INSERT INTO agt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Awemuy mantu magburung, te ikamuy ya kuman na pastorān na Dama muyewan, a ikayat na ta ikamuy ya mesipat tentu nga magturay ta ngamin. ");
INSERT INTO agt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","A mappya ta ilaku muy ya kadwan kiden kwa muy petta itta sangaw ya iuffun muy ta napanglaw kiden. Te am kunna ten ya tarabakun muy a mauknud ya ba-nang muy ta langitewan nga awan magdan ikid na awan maazi tekamuy, te awan ta magtakaw ten ikid na awan ta ulolag nga magkan ta kwa muy. ");
INSERT INTO agt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","A mappya ta kunna ten, te am itta la ta Namaratu ewan ya pake kengan muy a yen la ya nonotan muy. ");
INSERT INTO agt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“A kumanen hapa a mappya ta makigitta kam ta tagabu kiden nga awan masidug, te sigida makaparan kid talo am ka-ma la dumatang ya dafu da en nga umange nakipyesta. A dana nagpagatang kid hapa, petta alistun da ihukat. ");
INSERT INTO agt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","A nagāsāt sangaw ya awan kiden mangikasidug ta datang na dafu da, te pagtuttudan na kid hapa sangaw ta lamesa na en, kapye na kid pakanan. ");
INSERT INTO agt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","A maski am awena dumatang abat ta tangngan na hiklam ono nagkarawan a pake magāsāt kid para am dana nakaparan kid ta datang na. ");
INSERT INTO agt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“A itan muy hapa ta awemuy sangaw parigan ya natulisan ta bali na, te am dana amu na mina ya oras ya iange na tulisan a awena mina nasidug, petta awena mina natulisan na bali na en. ");
INSERT INTO agt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","A yen mina ya nonotan muy petta dana nakaparan kanan ta datang ku, te am pahig muy sangaw ta awek para la dumatang a yen hala sangaw ya datang ku,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","A gafu ta uhohug ni Hesus a nagpohut hapa i Pedru tentu, “Afu, ikami la de ya pangibaram ta keangarigan kidin, ono isipat mu hapa ya ngamin kidin kimalihung ta isin?” kunna. ");
INSERT INTO agt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","“A maski am inya na tolay nga makanonot ikid na mekatalak,” kunna hapa ni Hesus, “te yen sangaw ya patudunan na dafu na en petta magturay ta kadwan kiden tagabu na ta bali, a intu hapa sangaw ya makkamu ta kanan da. ");
INSERT INTO agt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","A am mekatalak hapa ya pinatudunan na en a pake magāsāt para, ");
INSERT INTO agt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","te intu sangaw ya paturinan na nga manaron ta ngamin kiden pagba-nangan na. ");
INSERT INTO agt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ammi am pahig na tagabu en ta mabayag para ya pagtoli na dafu na en, a intu la tarabakun na ya mangan ikid na uminum ikid na magillaw, ikid na magpalpaluk ta kadwan kiden tagabu. ");
INSERT INTO agt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","A kakallak hapa sangaw am pagka-ma na ya datang na dafu na en gafu ta awena nakaparan. A pa-gangan na sangaw na dafu na en, petta mesipat mapa-gang ta awan kiden mekatalak. ");
INSERT INTO agt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","48","“A am itta mantu ya makkamu ta patarabaku na dafu na en ta awena idulot a dakdakal sangaw ya pangpa-gang na dafu na en ammi ta awanen makkamu. Te ya naatadan ta addu a masapul ta ad-addu sangaw ya itoli na, ammi ya naatadan ta medyo assang la a assang hapa ya itoli na,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","A ya netuldu para ni Hesus tekid a intu yan: “Yen ya umeyan ku ta lutakin petta ipurwak ku ya afuy ku ta ngamin paglelehuten, a ampade gumatang na mina. ");
INSERT INTO agt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ammi mappya ta dana attaman ku bit ya takwan na zigat, a mabanta yak na addet ta awena pakabalin. ");
INSERT INTO agt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","A gafu ta neangek ta isin a pahig muy de ta iyak sangaw ya kaam-ammungan na ngamin tolay, ammi bakkan, te iyak sangaw ya kakatkattwayan da, ");
INSERT INTO agt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","te mamegafu ta ayanin am itta ya lima na tolay ta takday bali a maghahulun ya kadwan nga makikattway ta kadwan kiden, ");
INSERT INTO agt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","te ya lalaki en a makikattway sangaw ta anak na en lalaki. A ya babbay hapa a makikattway sangaw ta anak na en babbay. A ya katahungan na takday a makikattway hapa sangaw ta manuhang na en,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A ya uhohug na hapa ta kaddun na tolay kiden a “Am maita muy ta magkulam na a ‘Magudan na sangaw O,’ kummuy, a kustu magudan. ");
INSERT INTO agt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A am nagafu ta abagatan ya paddaden a ‘Mapatu sangaw O,’ kummuy hapa, a kustu magpatu. ");
INSERT INTO agt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ammi ape malalaki kam, te amu muy lavunan ya dumatang gafu ta pakaitan ta langit ikid na lutak, ammi ya ipaita na Namaratu tekamuy ta ayanin a awemuy haman malasin. ");
INSERT INTO agt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mappya mantu ta ulin muy ya nonot muy, petta mangnonot kam ta matunung na nonot. ");
INSERT INTO agt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Te am medarum ka sangaw ta atubang na kwes a mapmappya ta dana makikappya ka mina ta mangidarumen teko ta awem para nakadatang ta kwes, te am nedarum na kan a paalap na ka na kwes ta mangbalud teko, ");
INSERT INTO agt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","a kakurugan ya ibar ku teko ta awem sangaw makauhet addet ta awem pakekaru ta ngamin liwat mu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","A ta pangituldu para la ni Hesus a itta ya ange kiden nangidanug tentu, te bidan da ya taga Galileya kiden nga pinapasi na suddalu kiden ni Gubernador Pilato. “Kakallak ya nangatang kiden, te dinatangan na kid na suddalu kiden tekiden mangatang, a nagkakihu ya daga da ta daga na atang da kiden,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A ya tabbag ni Hesus tekid a “Pahig muy de ta pake dulay ya pinapasi da kiden ammi ta kadwan kiden nga taga Galileya, a yen ta nepalubus na Namaratu ya pasi da? ");
INSERT INTO agt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ammi bakkan ta kunna ten, te am awemuy magbabawi ta gagangay muy ta ketta para na angat muy a megitta kam sangaw ta napapsi kiden. ");
INSERT INTO agt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","A nonotan muy hapa ya mafulu walu kiden nga inigsilan na bali en ta iten Silowam, te pahig muy de ta nasi kid gafu ta pake dulay kid ammi ta kadwan kiden taga Herusalem, ");
INSERT INTO agt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ammi bakkan haman ta kunna ten, te am awemuy magbabawi ta gagangay muy ta ketta na para na angat muy a megitta kam hapa sangaw tekid,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","A sangaw binida na hapa ya takday keangarigan ta pangipasikkal na tekid. “Itta kan ya nagpamula ta fun na higos ta lutak na en, a ta pagdakal na higosen a enna mina alapan ya mayan na kiden, ammi awan haman ta mayan na. A kumanen la kumanen abat ta tallu darun. ");
INSERT INTO agt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","A ya uhohug na ta manaronen ta mula na kiden a ‘Nekatalak ku haman ta magmayan ya higosin abat ta tallu darun, ammi awan haman. Mapmappya ta tukadam na, te afutan na la ya taba na lutakin,’ kunna kan. ");
INSERT INTO agt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ammi ya tabbag kan na manaronen tentu a ‘Awem la bit, Afu, te indagam mina abat ta takday para darun, te lehutan ku kalin kapyek tunan ta abuno na. ");
INSERT INTO agt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","A am magmayan sangaw ta takday darun a awan kad mappya, ammi am awan a tukadan ta,’ kunna kan. A mappya ta yen hapa ya pagnonotan muy,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","A ta takday ha na araw na agimmang a nangituldu ha i Hesus ta umag na kapilya da, ");
INSERT INTO agt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","a itta hapa ten ya takday babbay nga pake nagkavub, a awena nauyad ya addag na en, te itta ya anitu na nga nangpakavub tentu abat ta mafulu walu darun. ");
INSERT INTO agt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","A ta nepakaita ni Hesus tentu a binaran na. “Ina, itam awa naubadan kan ta pagkavub mu,” kunna, ");
INSERT INTO agt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","otturu nesi-ged na hapa ya kamat na tentu, a alistu nagtunung ya addag na en, a dinayawan na ya Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ammi ya presidente na kapilya en a nakaporay na te Hesus, te awena kan nginilin ya araw na agimmang awa nagtarabaku kan ta nepagpamappya na ta babbayen, ammi ya tolay kiden ya nehuya na. “Itta haman ya annam na araw ta pagtarabaku tam, a yen kid mina na araw ya iange muy ta isin am ikayat muy magpauru ta takit muy, a bakkan mina ta araw na agimmang,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ammi tinabbag hapa ni Hesus ya uhohug na en ta “Kuga magimmamappya kam, te am ikamuy haman a awemuy hud ubadan ya anwang muy ikid na kabayu muy ta araw na agimmang, petta emmuy kid penuman. ");
INSERT INTO agt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A kumanen dulay hud am araw na agimmang ya nekaubad na kagitta muyin tolay nga nagalutan ni Satanas abat ta mafulu walu darun?” kunna. ");
INSERT INTO agt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","A gafu ta inuhohug na en a namatan na hapa ya nakitapil kiden tentu. Ammi pake natalakan ya kadwan kiden te Hesus, te malalaki ya ngamin tinarabaku na. ");
INSERT INTO agt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","“Anu mina ya pangigittan ku ta iturayan na Namaratu, a anu mina ya keangarigan na?” kun ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","“A meangarig ta pake kaassangan na hukal nga imula na tolay, te sangaw am dakal na ya mula na en a nagbalin ta kadakalan na ngamin kiden mula, te magge kuman na kayu, petta yen ya eyan na mamanuk kiden pagumukan,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","“A meangarig para ya iturayan na ta kuman na tāpirit na asin nga mekihu ta lappa, te gafu ta asinen a sa maasinan ya ngamin lappa,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","A ta nekabalin ni Hesus ta iten a nagtugut, te magdulot ta ili na Herusalem, a nangituldu hapa ta kadwan kiden ili ikid na babali nga sinaned na ta inange na en. ");
INSERT INTO agt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","A itta hapa ya takday nga umange nagpohut tentu; “Afu, assang la hud sangaw ya mekerutan ta pangpa-gang na Namaratu?” kunna. ");
INSERT INTO agt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","A ya uhohug na hapa a “Addu sangaw ya mayat simarok ta pangikerutan na Namaratu, ammi melogot kid sangaw, te nailat ya sasarokan na en. Mappya mantu ta afuran muy ya simarok, ");
INSERT INTO agt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","te am indagan muy ya kelitup na sasarokanen kapye muy mina simarok a ‘Afu, Afu, hukatan kami O,’ kummuy sangaw, ammi itabbag na sangaw ta ‘Aweta kam amu am inya kam,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","‘Atsi O, Atsi O,’ kummuy hapa sangaw, ‘awa ikami haman ya kahulum kiden nga nakikkanan teko ikid na nakipaginum teko, a ume ka haman nangituldu ta lugar mi,’ kummuy hapa sangaw. ");
INSERT INTO agt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ammi ya uhohug na sangaw tekamuy a ‘Maski kunna ten aweta kam haman amu am inya kam. Umadayu kanan mantu teyak, te dulay ya tarabaku muy,’ kunna hapa sangaw tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","A am maita muy sangaw ta madugiman kam mehulun teg Abraham ikid ni Isaac ikid ni Hakob ikid na aglavun kiden ta agyan na iturayan na Namaratu a magtatangit kam sangaw anna magngaritam ya ngipan muy ta zigat muy. ");
INSERT INTO agt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ammi addu sangaw ya makasarok ta Hentil kiden nga magafu ta ngamin paglelehutin, a makikkanan kid ta kadwan kiden ta pagariyan na Namaratu, ammi tekamuy a madugiman kam. ");
INSERT INTO agt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Te ya awan kiden mina makasarok ta uray muy a yen kid sangaw ya simarok, a ya makasarok kiden mina ta uray muy a yen kid sangaw ya madugiman,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Awena pake nabayag a umange ya kadwan kiden Pariseyu nga mangibar te Hesus. “Mappya, Afu, ta umadayu kan ta isin, te doban kan ni Ari en Herud ya mamapasi teko,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ammi ya uhohug na hapa tekid a “Kuga mangayayyaw ya ari ina. Magtoli kanan tentu a ibar muy ta awek magbilag, te idulot ku la ya tarabakuk ta isin nga magpatugut ta anitu ikid na magpamappya ta magtatākit kiden, kapyek ibalin ya gafu na umeyan ku ta isin. ");
INSERT INTO agt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yen sangaw ya ibar muy tentu, te maski am anu ya panatalaw na teyak a mappya ta idulot ku la ya umange ta ili na Herusalem. Te gagangay ta yen ya pangpapasin da ta aglavun na Namaratu,” kunna tekid, ");
INSERT INTO agt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","otturu nanalasigak hapa gafu ta damdam na ta taga Herusalem kiden. “Ay, anak ku taga Herusalem; Mamengpiga yak mina nga nangikerutan tekamuy ta kuman na manuken nga mangukup ta piyak na kiden, ammi awemuy ikayat, awa papasin muy hud la ya aglavun kiden na Namaratu nga dinob na tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","A makkamu kanan mantu ta lugar muy, te pagurayan na kam na Namaratu. A ibar ku tekamuy ta awedak sangaw maita am awemuy ulin ya nonot muy, petta dayawan muy ya dinob na Namaratu ta pinakabari na tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A ta takday ha na araw na agimmang a umange i Hesus nakikkanan ta bali na Pariseyu en nga presidente na kapilya. A ya kadwan kiden Pariseyu nga kahulun na makābali en a aitan da am anu sangaw ya kwan ni Hesus, ");
INSERT INTO agt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","te itta hapa ten ya takday lalaki nga pake nagbagbaga ya kamat na kiden ikid na takki na kiden, a umatayuk ta atubang ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","A gafu ta kumanen a itta ya pinohutan ni Hesus ta Pariseyu kiden ikid na mangituldu kiden nga mangaita tentu, “Anu ya uray muy, kustu am pagmappyan ku ya tolay ta araw na agimmang ono awan?” kunna. ");
INSERT INTO agt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ammi aweda haman nagsitang. A sini-ged na mantu ya lalaki en pinagmappya, kapye na pinatugut. ");
INSERT INTO agt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A ya uhohug ni Hesus ta nangaita kiden tentu a “Am angarigan mina ta neavut ya anwang muy ono kabayu muy, a had sin hud tekamuy ya awan mangigon tentu maski ta araw na agimmang?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ammi awan hapa ta metabbag da tentu. ");
INSERT INTO agt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","A sangaw pake itan ni Hesus ya gagangay na tolay kiden nga ginawi na Pariseyu en ta bali na, te alistu kid magpili ta agtogkokan ta bikat na magpamakanen. A yen ta tinabarangan na kid ni Hesus ta takday keangarigan. ");
INSERT INTO agt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Am angarigan ta itta ya manggawi tekamuy ta pagpamakan na magboda, a awemuy mina pagtuttudan ya kaispotan na lugar talo am yen ya dana neparan ta mapmappya en ammi tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Te awemuy amu am ange sangaw ya nanggawi en a ‘O, kofun, awem la bit magtuttud ta isin, te yan ya neparan ta sangaili tamin,’ kunna sangaw tekamuy, a namatan kam sangaw, gafu ta neakban kam. ");
INSERT INTO agt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mapmappya mina ta intu pilin muy ya pake naak-akban, te am maita na kam sangaw na magboda en a mabalin ta baran na kam sangaw. ‘O, kofun, anu haman ta magtuttud ka ta isina nga adayu teyak? E ka sin, te mappya ta makihebing ka teyak,’ kunna sangaw tekamuy, a madayawan kanan sangaw ta atubang na ngamin. ");
INSERT INTO agt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Te ya ngamin kiden mangpautun ta bari da a mapaakban kid sangaw, a ya mangpaakban ta bari na a yen sangaw ya mapautun,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","A ya uhohug na hapa ta nanggawi en tekid a “Am mamadday ka sangaw ta pagpamakan a bakkan mina ta kofum kiden, ikid na kahulum kiden, ikid na naba-nang kiden ya gawim, talo am itubbat da ka sangaw gawin ta pagpamakan da, a metoli hala teko ya kuman na nagastum tekid. ");
INSERT INTO agt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mapmappya mina ta intu sangaw gawim ya napanglaw kiden, ikid na pilay, ikid na pukul, ikid na nagdaram, ");
INSERT INTO agt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","pettam kumanen a pake magāsāt ka sangaw. Te am awan ta pagsupapak da teko a Namaratu sangaw ya makkamu nga mangsagolyat teko ta araw na pangtolay na ta matunung kiden,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","A ta nepakadangag na takdayen kahebing ni Hesus ta binida na en a “Umpa, magāsāt sangaw ya makikkanan ta pagpamakan na Namaratu ta pagtogkok na Dafu tamen,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ammi ya uhohug ni Hesus tentu a “Itta hapa ya takday nagpamakan ta idi,” kunna, “a naggawi hapa ta pake addu na tolay. ");
INSERT INTO agt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","A ta araw na pagpamakan na en a dinob na ya ange mangalap ta ginawi na kiden. ‘Em alapan ya ginawik kiden, te neparan na ya ngamin kanan da,’ kunna tentu, a umangen. ");
INSERT INTO agt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ammi intu dulay te nagpambar haman ya ngamin kiden nagawi; ‘Gummatangak garay ta lutak, a mappya bit ta eyak itan, a dispensaran nak na la,’ kun na takday. ");
INSERT INTO agt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","A ya uhohug ha na takday a ‘Gummatangak garay ta lima paris na baka, a mappya bit ta eyak kid paruban pagaradu talo mayat kid, a dispensaran nak na la,’ kunna hapa. ");
INSERT INTO agt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","A ya uhohug na takday para a ‘Bagu nabalinak nagboda, a yen ta awek makaange,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“A gafu ta kumanen la kumanen ya pagpambar da a nagtoli ya dinob na nagpamakanen, a nebar na ya ngamin pambar da tentu, a nagporay hapa ya nagpamakanen. ‘Alistum mantu ange ta kalsada kiden ikid na dalan kiden ta ili, te apam sin ya napanglaw kiden, ikid na pilay kiden ikid na daram kiden,’ kunna, a umangen ha ya daddoban na en. ");
INSERT INTO agt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nepagtoli nan a ‘Afu, nebalin kun ya nepangidob mu teyak, ammi addu para la ya pagyanan,’ kunna ta dafu na en. ");
INSERT INTO agt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","A ya uhohug na hapa tentu a ‘E kan mantu ta nahughugtuk kiden babali, a persam ya tolay kiden nga ange sin, petta mapannu ya bali kin, ");
INSERT INTO agt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","te ibar ku la tekamuy ngamin ta awena sangaw mesipat na palungu kiden ginawik ta neparan kin,’ kunna.” A yen ya addet na bida ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","A tentu en nagtugtugut ta dalan a mehulhulun hapa tentu ya pake addu na tolay. A nagtayuk bit i Hesus, kapye na nagbalittag nagbida tekid. ");
INSERT INTO agt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Am itta tekamuy ya mayat magbalin ta itulduk a mappya ta iyak ya pake ikayat na ammi ta dama na, ikid na hina na, ikid na atawa na, ikid na anak na kiden, ikid na kabagis na kiden, a maski ta angat na, te am awan a awena makapagbalin ta itulduk. ");
INSERT INTO agt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","A maski am inya mina ya dumagdag teyak am awena iwasa ya pasi na a awena mantu makapagbalin ta itulduk,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Otturu netulfu na hapa ya duwa na keangarigan, te ye-yen ya mangipasikkal ta nebar na en tekid. “Am itta mina ya magbali ta dakal,” kunna, “a dana bilangan na bit ya pirak na kiden petta amu na am makalannat addet ta kabalin na bali na en. ");
INSERT INTO agt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Te am intu la sangaw mabalin ya arigi na kiden kapye na maafut ya pirak na kiden a awena mantu sa mabalin na ngamin bali na, a ikakatawa na sangaw na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Itan muy ya parayag na magbali en mina ta dakal awa awena haman mebalin ya negafu na en,’ kunda sangaw. ");
INSERT INTO agt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“A kumanen hapa ta ari en nga ange mina makigubat, te am angarigan ta pake ad-addu ya suddalu na katapil na en ammi ta suddalu na kiden a dana itan na bit ta malmalalaki ya suddalu na kiden nga makigubat. ");
INSERT INTO agt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Te am awan ta turad da ikid na kalalaki da nga mangabak ta pake ad-addu ammi tekid a magtalaw kid na sangaw mangidulot ta pakigubat da, a masapul ta timuluk ya dafu da en ta katapil na en. ");
INSERT INTO agt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","A kumanen hapa teyak, te dana ibar ku tekamuy ta awemuy makapagbalin ta itulduk kiden am awemuy dana iwasa ya ngamin itta tekamuy, petta awek sangaw melogot gafu ta talaw muy. ");
INSERT INTO agt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mappya mantu ta kuman na asin ya dumagdagen teyak, te mappya haman ya asin. Ammi am mangilogot sangaw ya dumagdagen teyak a nagbalin mantu ta kuman na asinen nga imawan ya apgad na en, A am awan ta apgad na a itta hud sangaw ya serserbi na? ");
INSERT INTO agt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mapmappya hud la ya attay, te mabalin ta meabuno. Ammi ya asinen nga awan ta apgad na a gagangay ta mewarad. A am kakurugan ta itta ya bangbang muy a mappya ta dangagan muy ya bidan kin tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","A ta takday ha na araw itta ya addu na tolay umange magdangag ta ituldu ni Hesus, a mehulun tekid ya agsingir kiden to bwis ikid na kadwan kiden minagliwat. ");
INSERT INTO agt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","A sakā umange hapa nagdangag ya kadwan kiden Pariseyu ikid na mangituldu kiden ta lintig, ammi liniblibakan da i Hesus ta kahulun da kiden. “Anu haman ta pagdulotan na ya dulay kiden na tolay, yaga kaatubang na kid mangan?” kunda. ");
INSERT INTO agt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","A gafu ta libakan da ya gagangay ni Hesus a nagbida hapa tekid ta tallu na keangarigan: ");
INSERT INTO agt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Am angarigan mina ta itta ya takday tekamuy nga magtaron ta magatut na kalneru ta metawag ya takday, a awena hud isirak ya siyamafulu siyam, petta enna apagan ya takdayen? ");
INSERT INTO agt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A am naapagan nan a kokolun na hapa, a sa-bilan na abat ta bali. ");
INSERT INTO agt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","A am nedatang nan ta bali a awena hud baran ya kofun na kiden ikid na karuba na kiden? ‘O ey, magragsak kitanan, te naapagan kun ya kalneruken,’ awena hud kumin? ");
INSERT INTO agt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A kumanen hapa ta Namaratu ewan ikid na anghel na kiden, te am itta ya magbabawi maski ta takday la na magliwat a dakdakal ya talak da tentu ammi ta siyamafulu siyam kiden nga awan ta liwat,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“A kumanen hapa ta takday babbay am mawakay ya takday aritut na ta bali na, a awena hud magpagatang ta hilag kapye na apagan ya aritut na en ta ngamin umag na bali en abat ta naapagan nan? ");
INSERT INTO agt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A am naapagan nan a baran na hapa ya kofun na kiden ikid na karuba na kiden, ‘O ey, magragsak kitanan, te naapagan kun ya aritut ken,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","A kumanen hapa ta Namaratu ikid na anghel na kiden, te dakal hapa ya pagragsak da ta pagbabawi na maski takday nagliwat,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","A ya takday para keangarigan na a “Itta ta idi ya laklakay nga duwa ya anak na a azo lālāki kid. ");
INSERT INTO agt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A umange hapa ya assangen te dama na en gafu ta adangan na tentu. ‘Amang, mappya ta iatad mun ya lugar na iatad mu teyak, te magtugutak na,’ kunna. A ginadwa na mantu ya ngamin pagtolayan na ta duwa kiden anak na. ");
INSERT INTO agt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A ta nepagpasa na assang la na araw a inalap na assangen ya ngamin bingay na en, kapye na nagtugut, a sa nehulun na hapa ya ngamin pirak na en. A gafu ta kumanen a umange nagpasyar ta pake adayu na lugar, a sa ginasto na ya ngamin pirak na ta awan ta pakait-itan. ");
INSERT INTO agt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","A sangaw ta nekaafut na pirak na kiden a nazigatan hapa, te dinatangan na agbabisin ta lugaren nga umeyan na. ");
INSERT INTO agt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A gafu ta kumanen a umange nangallu ta takday tolay ten, a dinob na hapa nga ange magtaron ta bahuy na kiden. ");
INSERT INTO agt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A tentu nagtaron ta bahuy kiden a tagasingatan na hapa ya magbasug ta kanan na bahuy kiden, te awan haman ta nangatad ta kanan na. ");
INSERT INTO agt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","A sangaw nakanonot hapa, a ‘Asakay, mapmappya haman ya pagyan na mangallu kiden te damaken. Aweda haman maafut ya ipakan na tekid, ammi teyak a masi yak na ta bisin,’ kun na nonot na. ");
INSERT INTO agt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","‘Atsi, magtugutak na sin, te dumatangak te damaken, te makipakoma yak sangaw tentu. A “Amang,” kunku sangaw, “nakaliwatak na mantu teko ikid na Namaratu, ");
INSERT INTO agt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","a awena mabalin ta anak nak, ammi alapan nak la ta kuman na magyan la teko mangallu,” kunku sangaw tentu,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“A gafu ta kumanen a nagganwat nagtugut ya lalaki en, a dumatang ta lugar na dama na en. A tentu para la sang adayu ta bali na en a neitan ni dama na en ta dumatang na, a timalin ya allak na tentu, a bimilag hapa ya laklakayen nga ange nangdafung tentu, a inahakupan na hapa inamu. ");
INSERT INTO agt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Amang,’ kun na abbingen, ‘pake nakaliwatak teko ikid na Namaratu, a awena ta mekwenta ta anak nak,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ammi nagayag na i dama na en ta tagabu na kiden: ‘Ibilag muy sin ya kaispotan na barawasi, te pagbarawasi na anak kin, a pangalap muy hapa ta sakalang na ikid na sapatos na. ");
INSERT INTO agt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","A emmuy hapa partin ya mataba en urbun, te gagangay ta ayayatan tanan ya anak kin, ");
INSERT INTO agt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","te agu ta nasin, aya natolay hala. Imawan biten teyak, ammi mappya te ittan,’ kunna. A namegafu kid na nagayayat. ");
INSERT INTO agt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“A tekiden para la nagayayat a itta para la ta uma ya kadakalan na en nga magtarabaku. A tentu en hapa dumatang ta furab a dadangagan na ya magtatokar ikid na magsasala, a pahig na ta anu ya kwan da. ");
INSERT INTO agt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A pinohutan na ta takday na mangallu kiden am anu ya pagayayat da. ");
INSERT INTO agt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘A te nanoli ya wagi men, a nepagparti nig damam ta urbunen, te pangikatalak da ta dumatang ta kaskasikanan na bari na,’ kun na mangallu en tentu. ");
INSERT INTO agt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“A gafu ta kumanen a naglussaw ya kadakalanen, a awenan ikayat magdulot ta umag na bali. A yen ta imuhet ya dama na en petta pagdulotan na ta bali. ");
INSERT INTO agt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ammi ya uhohug na hapa a ‘Itan nak, Ama, awa bababang na darun ya pagtarabakuk teko ta kuman na tagabum, a awek la sinoysoy ya ngamin nangidobam teyak, ammi awan para la ta neatad mu teyak, maski la ta kalakalding, petta pagayayat mi hapa ikid na kofun ku kiden. ");
INSERT INTO agt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ammi ta pagtoli na anak mina nga nangafut ta pagtolayam ta nakikadallaw kiden a pagpartim haman ta urbunen,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“A ya uhohug na dama na en tentu a ‘Awem la kumin, Aleng, te kwam haman ya ngamin kwak, te sigida magyan ka teyak, ");
INSERT INTO agt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ammi gagangay haman ta ayayatan tam mina ya wagi men, te kuman na nasi tekitam, ammi natolay hala, te imawan biten tekitam, ammi mappya te ittan hala,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A ya takday hapa na bida ni Hesus ta ituldu na kiden a intu yan: “Itta ta idi ya magtaron ta pagba-nang na dafu na en, ammi itta hapa ya umange nangidanug tentu gafu ta afutan na ya ba-nang na; ‘Awem hud amu ta afutan na pinagtaromen ya ngamin kiden kwam?’ kunna kan ta naba-nangen. ");
INSERT INTO agt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","A gafu ta kumanen a pinaayagan na ya pinagtaron na en, a ‘Dulay haman ya nadangag kun gafu ta pagtarom. A mappya mantu ta iatad mun sangaw teyak ya lista na gatut na ngamin kiden nakagatut teyak, te awem na sangaw magtaron,’ kunna kan tentu. ");
INSERT INTO agt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","A nagburung na hapa ya magtaronen, ‘Ahu, dulay yan,’ kunna. ‘Am azin nak sangaw na dafu ken a had para sangaw pagapagan ku, te makafuyak haman magtarabaku ta madammat, a mamatak hapa makilimlimut,’ kunna kan. ");
INSERT INTO agt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","‘Atsi, amuk na mantu ya kwan ku O, petta ikallak nak sangaw na nakagatut kiden am azin nak sangaw ta pagtaronan kin,’ kunna kan na nonot na. ");
INSERT INTO agt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“A pinaayagan na mantu ya ngamin kiden pinagatutan na ta pirak na dafu na en, ammi tinagtakday na kid. A ya nebar na kan ta imunnanen a ‘Amum am piga ya gatut mu ta dafuken nga nelista ta isin?’ kunna kan tentu. ");
INSERT INTO agt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘A ya amuk a magatut na lata na denu,’ kunna kan hapa. ‘Yeh, alapam mantu ya pinermam a ulim ya gatut mu ta limafulu la, a alag mu hapa,’ kunna kan na magtaronen tentu. ");
INSERT INTO agt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“A sangaw dumatang hapa ya takday a ‘Amum am piga ya gatut mu ta dafuken nga nelista ta isin?’ kunna kan tentu. ‘A amuk ay, te magatut na kaban na irik,’ kunna kan hapa. ‘Yeh, alapam mantu ya pinermam a ulim ya gatut mu ta walufulu la,’ kunna kan ha na magtaronen. ");
INSERT INTO agt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“A sangaw neatad na ya lista na gatut kiden ta dafu na en, kapye na nagtugut. A ta nepakkamu na naba-nangen ta sistema na magtaronen a ‘Asakay, kuga masistema ya magtaronen O, petta itta sangaw ya mangikallak tentu am awan ta pagapagan na.’ kunna kan. A yen mina ya pagnonotan muy,” kun ni Hesus ta magdangag kiden, “te ya gagangay na awan kiden mangurug ta Namaratu a kakurugan ta pake masistema kid ammi ta mangurug kiden. ");
INSERT INTO agt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ammi ya ibar ku tekamuy a mappya hud ta kunna ten ya tarabakun muy petta itta sangaw ya mangikallak tekamuy? A itta hud sangaw ya magpadulot tekamuy ta magnayun na pagyanan gafu ta pagswitik muy? ");
INSERT INTO agt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Am kakurugan ta mekatalak kam nga magtaron ta assang la a gagangay ta mekatalak kam hapa sangaw magtaron ta addu. Ammi am madi ya pagtaron muy ta assang la a gagangay ta madi hapa sangaw ya pagtaron muy ta addu. ");
INSERT INTO agt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","A am awemuy mekatalak nga magtaron ta gagangayen kaba-nang ta lutakin a itta hud sangaw ya ipataron na Namaratu tekamuy ta magnayunen na kaba-nang muy. ");
INSERT INTO agt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","A am awemuy hapa mekatalak nga magtaron ta nepataron na tekamuy a itta hud sangaw ya iatad na tekamuy ta kabukodan na kwa muy. ");
INSERT INTO agt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","A yen ta awemuy makapagserbi ta Namaratu pase pagba-nang muy hapa, te am duwa mina ya dafu muy a ikayat muy ya takday, a kuman na ikatupag muy ya takdayen, a am idulot muy ya ikayat na takday a aweyan muy ya takdayen,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","A ya Pariseyu kiden hapa a nedangagan da ya binida ni Hesus ta ituldu na kiden a nedadula da, te pake karagatan da ya pagba-nang da. ");
INSERT INTO agt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ammi ya uhohug ni Hesus tekid a “Ikamuy ya mangsagappya ta bari muy ta atubang na tolay, ammi amu na Namaratu ta dupal ya nonot muy, te ya pagkaragāt muy ta pagba-nang muy a ikatupag na Namaratu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","18","(-) ");
INSERT INTO agt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","A ya uhohug para ni Hesus tekid a intu yan: “Itta ta idi ya naba-nang na lalaki nga kanayun nagbarawasi ta pake mangina na ga-gamit, a nesipat na ya kuman na kanan na magbaboda ta kinanghahaw. ");
INSERT INTO agt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A itta hapa ya napanglaw nga nagngagan te Lasaru nga netabnak da ta irwangan na gibaw na naba-nangen petta makilimlimut, te napilay. ");
INSERT INTO agt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A tagasingatan na hapa ya magbasug ta hugta na naba-nangen, a umange hapa ya atu kiden mangzilzil ta gurid na kiden. ");
INSERT INTO agt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","A sangaw a nasi hapa ya napanglawen, a inalap na anghel kiden ta hebing na gingginafu na en Abraham ta agyan na magpyesta kiden ta langit. A sangaw nasi hapa ya naba-nangen, a netanam da. ");
INSERT INTO agt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ammi pake nazigatan ta pangtaguhalin na Namaratu. A tentu en naglipay a nebatad na hapa ya gingginafu na en Abraham ta adayu, a itta kad i Lasaru ta hebing na en. ");
INSERT INTO agt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A nagayag mantu ya naba-nangen te Abrahamen, ‘Kakay Abraham, ikallak nak O, Kakay, te dobam haen sin i Lasaru, petta pasamnayan na ya zilakin ta danum, te kuga mazigatanak ta patu in,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","‘A yen mina ya nonotam, anak ku,’ kun ni Abraham tentu, ‘te dana naalap mun ya mappya na kwam ta katolay men, ammi te Lasaru a intu la naalap na ya dulay. A ta ayanin a newasa nan, a ikon ya mazigatan. ");
INSERT INTO agt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","A ya medagga para ta isin a itta ya dakal na avut ta naghahatan tam petta kumanen a maski am itta ya mayat a awan ta makakalasig tekitam,’ kunna hapa. ");
INSERT INTO agt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","A ya tabbag na naba-nangen hapa a ‘Am kunna ten mantu, Kakay, a iko bit ya makkamu nga mangidob te Lasaru ta bali ni damaken, ");
INSERT INTO agt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","te itta ya lima na kabagis ku, a ipasikkal na mina tekid, petta aweda sangaw makaange ta isin agyan na pagzigātān kin,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ammi ya tabbag ha ni Abraham a ‘Itta haman tekid ya uhohug na Namaratu nga nesurat nig Moses ikid na aglavun kiden, a yen mina ya pagnonotan da,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘On ay, ammi aweda haman dangagan yen kid na surat, ammi am itta mina ya umange tekid nga nagafu ta nagpasi kiden a magbabawi kid hala sangaw,’ kunna ha na naba-nangen. ");
INSERT INTO agt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","A ya napozan na uhohug ni Abraham tentu a ‘Am aweda mantu dangagan ya surat nig Moses ikid na aglavun kiden a gagangay mantu ta aweda sangaw mangurug maski am itta ya matolay ta nagpasi kiden,’ kunna. (v 16) “Takwan hapa ya nebar ni Hesus ta Pariseyu kiden, Addet ta idi a ya lintig kiden ikid na surat na aglavun kiden ya mangibar ta datang na sangaw na pangikerutan na Namaratu. Ammi ta neange ni Hwan nga nangzigut ta tolay kiden a nepadangag na ta ittan ya araw na pangikerutan na, a ipapilit na ngamin tolay ta mesipat kid na maski aweda kurugan ya lintig na kiden. (v 17) Ammi awena mabalin, te mapmappya ta lumitap ya langitewan pase lutakin ammi ta awena pa-gangan na Namaratu ya ngamin kiden nakaliwat ta maski takday la na lintig na kiden. (v 18) A yen ta ibar ku tekamuy ta am makigungay ya lalaki ta atawa na en otturu mangatawa ha ta takwan a nakaliwat ta lintig na Namaratu, te mangadallaw haman. Kumanen hapa am atawān na lalaki ya negungay na takdayen a nakaliwat hapa yen ta lintig na en, te kadallawan na hapa,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","A ya kadwan para ituldu ni Hesus ta ituldu na kiden a intu yan: “Gagangay ta itta la itta ya mamagliwat ta tolay, ammi pake mapa-gang sangaw ya mamagliwat tekid, ");
INSERT INTO agt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","te mapmappya mina ta dana nakaddangan ya lig na en ta dappug na batu kapye na newarad ta bebayen, pettam awena sangaw mapa-gang gafu ta pamagliwat na ta ikattolay na. A mappya mantu ta imugudan muy petta awemuy magliwat. ");
INSERT INTO agt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“A am angarigan ta pagliwatān na ka na kagittam tolay a ihuyam, a am magbabawi a pakomam hapa. ");
INSERT INTO agt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A maski am inaman na ka otturu makipakoma teko abat ta mamempitu ta tangagaw a mappya ta pakomam la,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A ya uhohug hapa na turin na kiden nga mafulu duwa a “Mappya, Afu, ta padakalam ya pangurug mi ta Namaratu, te kuman na assang,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","“A maski am alaassang la ya pangurug muy ta kuman na kaassangan na hukal kiden, a gustu yen pettam pahantud muy ya kayu gafu ta uhohugan muy, a mewarad ta umag na bebay,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","A ya uhohug na para tekid a “Am ikayat muy ta dumakal ya pangurug muy a intu mina nonotan muy ya gagangay na tagabu. Te am dumatang na ta bali nga nagafu ta nagtarabakun na en, a pahig na hud ta intu ya mapmapolu mangan ammi ta dafu na en awa mapolu ya dafu na en, te ibar na ta ");
INSERT INTO agt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","‘E kan magafuy te mangan kamin. Dana tunnadān na kami kapyem sangaw mangan,’ kunna haman tentu. ");
INSERT INTO agt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","A am nabalin na nagitunnād a pahig na hud ta magyaman ya dafu na en tentu awa awan haman. ");
INSERT INTO agt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","A kumanen hapa am ikayat muy ta dumakal ya pangurug muy a mappya ta umalinnak kam. A am nebalin muy ya nepatarabaku na Namaratu tekamuy a awemuy la padayaw ya bari muy, te tagabu kam la, a intu la iningwa muy ya gagangayen tarabaku na tagabu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","A ta nekabalin na en a nagdulot hala i Hesus ta dalanen nga ange ta ili na Herusalem, a inange na ya takday ili ta nagdulunan na Samariya ikid na Galileya. ");
INSERT INTO agt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","A magtalib mina, ammi tentu para la imatakkun a enna dinafung na mafulu na lalaki nga naggalis ta ngamin barbari da, ");
INSERT INTO agt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ammi nagyan kid ta ada-dayu nagbar tentu. “Afu Hesus, ikallak na kami haen, te pagmappyan na kami,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","A inita na kid bit kapye na naguhohug tekid. “Emmuy mantu ipaita ya pagmappya na bari muy ta padi kiden, petta pasikkalan da ya pagmappya muy,” kunna. A tekid para la umange ta padi kiden a yen ya nepagmappya da. ");
INSERT INTO agt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Sa Hudyo kid ngamin fwera la ta takdayen, te taga Samariya yen. A ta nepakaita na taga Samariya en ta nagmappyan a awenan bit nagdulot ta padi kiden, te alistu hud la nagtoli te Hesus, a “Haleluya, Pres da Lord, Pres da Lord,” kunna ta masikan. A datang na te Hesus a namalentud ta atubang na en, a “Matalakak teko, Afu, te pinagmappya nak,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","A ya uhohug hapa ni Hesus ta nagtayuk kiden naggiraw a “Itan muy yan, mafulu paen ya nagmappya, ammi intu la matalak ta Namaratu ya awanen ikattolay da. Anu awena makanonot na siyam kiden?” kunna. ");
INSERT INTO agt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A ya uhohug na hapa ta lalaki en nagtoli a “Magtayuk kan, a magdulot kan, te nagmappya kan gafu ta pangikatalak mu teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","A ya Pariseyu kiden hapa a pinohutan da te Hesus am kanu sangaw ya pagtogkok na ari en nga nekari na Namaratu. A ya nebar ni Hesus tekid a “Awemuy mina pahig ta itta ya pakaitan ta iange na, ");
INSERT INTO agt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","anna awemuy mina lavlavunan am had sin na lugar ya lattogan na, te ittan haman tekamuy, a awemuy haman amu,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A sangaw naguhohug hapa ta ituldu na kiden; “Sangaw am ittan ya araw na pagzigātān a ‘Ampade ta ittan ya Tolayin taga Langit maski ta takday la na araw’, kummuy, ammi awanak para la. ");
INSERT INTO agt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","A am ibar da sangaw ta itta yak na yo ten a awemuy malat umange. A am ibar da sangaw ta itta yak na ye sin a awemuy la dumagdag tekid, ");
INSERT INTO agt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","te pagka-ma muy la sangaw ya pagtolik ta kuman na pagdangāng na kilaten. ");
INSERT INTO agt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ammi mappya ta dana attaman ku bit ya addu na zigat, te papasin nak sangaw na kagittak kidin tolay. ");
INSERT INTO agt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“A am magtoli yak sangaw ta lutakin a addu sangaw ya awan nakaparan, te intu la sangaw nonotan da ya kuman na tolay kiden nga nalayus ta ketta ni mina Nowe en. ");
INSERT INTO agt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Te ya kalugarān ni Nowe a pangākan da la, ikid na keaatawa kid, yaga kebaboda kid abat ta araw na nesarok nig Nowe ta umag na baporen, a dinatangan na kid na layusen, a sa nagkalimat kid. ");
INSERT INTO agt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“A kumanen hapa ta kalugaran ni mina Lot ta idi, te pangākan da la hapa, ikid na keainum kid, ikid na kegagatang kid, ikid na kelalaku kid, kemamula kid, kebabali kid. ");
INSERT INTO agt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ammi ta neuhet nig mina Lot ta ili na Sodom a naudanan ya nasirak kiden ta afuy ikid na burbura, a sa nagkaapang kid. ");
INSERT INTO agt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“A kumanen hapa sangaw am magtoli ya Tolayin taga Langit ta pakaita na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Te am ittan sangaw ya araw na en a ya itta en ta lawan na bali na en a awena mina nonotan ya kwa na kiden ta umag na bali. A ya magtarabaku ta uma a awena mina nonotan ya ange ta bali na en, ");
INSERT INTO agt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","te nonotan muy ya atawa ni Lot nga nagbalin ta sinang tolay na asin. ");
INSERT INTO agt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","A ya mangkenga ta angat na ikid na katolay na ta lutakin a yen sangaw ya melogot, ammi ya awanen mangkenga ta angat na ikid na katolay na a yen sangaw ya magnayun. ");
INSERT INTO agt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A ya ibar ku para tekamuy a masidug sangaw ya duwa na tolay ta takday agiddan, a maalap ya takday, a masirak ya takdayen. ");
INSERT INTO agt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","A magkaalsud hapa sangaw ya duwa na babbay nga magbayu, a ka-ma la sangaw maalap ya takday a masirak ya takdayen. ");
INSERT INTO agt_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","A maghebing sangaw magtarabaku ya duwa na lalaki ta uma, a maalap ya takday a masirak ya takdayen,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","A tentu nabalin nagbida tekid a pinohutan da am had sin na lugar ya pagdulotan na sangaw ta araw na pagtoli na. A ya nebar na tekid a “Maski am had sin ya agyan na nasi en nalabag a yen hapa ya datangan na magkakan tekid. Te am pake nagdulay na ya tarabaku na tolay kiden ta lutakin a yen sangaw ya datang na pangpa-gang na Namaratu tekid,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","A sangaw nagbida i Hesus ta takday para keangarigan tekid, petta yen mina ya pagnonotan da ta aweda mahulat makimallak. ");
INSERT INTO agt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Itta ya kwes ta takday na lugar nga awan mamat ta Namaratu, yaga awan ta pangkenga na ta tolay,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“A itta hapa ten ya nabalu nga babbay, a sogawan na hapa ya kwesen nga nakimemallakan gafu ta katapil na en. ‘Uffunan nak haen nga magapag ta pakaitan ta kwak gafu ta gubatan na katapil ken,’ kunna kan. ");
INSERT INTO agt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","A awena bit la nekaskasu na kwesen, ammi gafu ta nagpatotoli ya nabalu en a nahulat na ya kwesen. ‘Kuga popoyungan nak na babbayin yan O. A maski awek mamat ta Namaratu pase tolay a mappya ta uffunan ku ya babbayin petta awenak sangaw ulangan,’ kun na nonot na kwesen. ");
INSERT INTO agt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“A nonotan muy mantu ya inuhohug na kwesen,” kun ni Hesus, “te am kunna ten ya uray na killu na kwes ");
INSERT INTO agt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","a awena hud uffunan na Namaratu ya matakit tentu nga magayayag tentu ta araw pase hiklam? ");
INSERT INTO agt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ibar ku tekamuy ta alistu sangaw ya panguffun na tekid. Ammi maski ibar ku yan tekamuy a awek amu am itta la sangaw ya madatangan ku ta mekatalak nga makimallak am magtoli yak sangaw ta lutakin,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","A itta hapa ya binida ni Hesus ta kadwan kiden nga mangiparayag ta kappya na bari da ikid na mangidadula ta kadwan. ");
INSERT INTO agt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Itta ya duwa na tolay nga umange makimallak ta agyan na simbaanen,” kunna. “Pariseyu ya takday, a ya takdayen ya magsingir ta bwis. ");
INSERT INTO agt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A imatayuk la ya Pariseyu en nga tumangad ta utun, a ‘Matalakak teko, Afu Dyos, ta bakkanak ta kuman na kadwan kiden tolay nga magswitik, ikid na magkillu, ikid na mangadallaw. A matalakak hapa ta bakkanak ta kuman na magsingirin ta bwis, ");
INSERT INTO agt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","te mamidwa yak magpasa ta pangan ku ta kada lawas ta pakimallak ku teko, yaga itolik teko ya mekamafulu na ngamin maapagan ku,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ammi ya nagsingiren ta bwis a imatayuk ta ada-dayu nga imatumag, te mamat mangiadang, a tinarmig na ya radang na ta pagdamdam na. ‘Ay, Afu, pakoman nak haen, te amuk ta dulayak na tolay,’ kunna hapa. ");
INSERT INTO agt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“A pake ibar ku tekamuy ta intu nekwenta na Namaratu ta matunung ya nagsingiren ta bwis, a awena dinangag ya takdayen, te ya ngamin mangpātā-nāng ta bari da a paakbanan na kid na Namaratu, ammi ya magpaakban ta bari na a yen ya pātā-nāngan na Namaratu,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","A sangaw itta ya mangiange ta asitay da kiden te Hesus petta ipotun na ya kamat na tekid, ammi nehuya na kid na ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ammi pinaabikan na kid hala ni Hesus, “Awemuy la gamman ya anak kidin, petta e kid la teyak, te ya ngamin kiden makigitta ta abbing a yen kid ya iturayan na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A kakurugan hapa ya uhohug ku tekamuy ta am awemuy ikatalak ya pagtaron na Namaratu ta kuman na abbing a awemuy sangaw mesipat tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","A sangaw itta ya takday pinadakal na Hudyo kiden nga umange nagpohut te Hesus; “Ay, Mistro, kakurugan ta mappya ka na tolay, a ibar mu haen am anu mina ya tarabakuk petta itta sangaw ya angat ku nga magnayun,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A ya tabbag ni Hesus tentu a “Annum hud ibar ta mappya yak na tolay? Itta hud ya mappya am bakkan la ta Namaratu ewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","“Ammi am ikayat mu maatadan ta angaten nga magnayun a amum haman ya lintig kiden ta awem mina mangadallaw, ikid na awem mamapasi, ikid na awem magtakaw, anna awem magladdud. A dayawam ig damam ikid ni hinam,” kunna ha. ");
INSERT INTO agt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","“Ay, kanayun kurugan ku yen kid na lintig abat ta kaabbing ku,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","“On ay, ammi itta para la ya takday pagkurangam,” kun ni Hesus, “te em mina ilaku ya ngamin kiden kwam, a mangatad ka ta pobre kiden petta itta sangaw ya pagba-nang mu nga mauknud ta agyan na Namaratu, a magtoli ka sangaw dumagdag teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","A ta pakadangag na lalaki en ta inuhohug ni Hesus tentu a nagsugyab ya mukat na ta pagdamdam na, te pake dakal ya pagba-nang na. ");
INSERT INTO agt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","A tentu en nagtugut a pake inaita ni Hesus kapye na nedulot ya ibar na ta ituldu na kiden; “Kuga mazigat ya isassarok na maba-nang ta pangikerutan na Namaratu, ");
INSERT INTO agt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","te malmalogon ya isassarok na anwang ta hubu na dagum ammi ta isassarok na maba-nang ta pangikerutan na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A ya tabbag hapa na nakadangag kiden tentu “A am gagangay ta kunna ten, Afu, a itta hud para ya mekerutan?” kunda. ");
INSERT INTO agt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","“A maski am awena mabalin gafu ta tolay a mabalin hala gafu ta Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","A ya uhohug ni Pedru tentu “A anu ya uray mu tekami, Afu, te sa newasa min ya ngamin bali mi petta dumagdag kami teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“A am itta ya nagtugut ta bali na, ikid na kabagis na kiden, ikid na dakal na kiden, ikid na lutak na, ikid na anak na kiden, gafu ta pangidulot na ta tarabaku na Namaratu ");
INSERT INTO agt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a maatadan hala sangaw yen ta minagmagatut ta katolay na sin ta kuman na nagtugutan na kiden. A sangaw am mapabagu ya araw a maatadan hapa ta magnayun na angat,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A ta nekabalin na ten a binaran ni Hesus ya mafulu duwa kiden turin na, a sang neadayu na kid petta ikid la ya makadangag ta ibar na. “Dangagan muy ya ibar ku tekamuy, te magdulot kitanan ta ili na Herusalem, a yen sangaw ya pagdulotān na ngamin kiden nesurat na aglavun kiden gafu ta Tolayin taga Langit, ");
INSERT INTO agt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","te gafutan da sangaw petta igawat da ta Hentil kiden nga magibbal tekitam. A amāmatan da hapa, ");
INSERT INTO agt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","te uparan da, ikid na paligatan da kapye da sangaw papasin, ammi matolay hala sangaw ta mekatallu na araw,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ammi pake napopoyung kid ta ngamin inuhohug na tekid, te aweda manonot am had kunna, a aweda naawatan. ");
INSERT INTO agt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","A tekiden umabikan ta ili na Heriku a itta hapa ya nagdaram nga imatuttud nakilimlimut ta pingit na kalsada en. ");
INSERT INTO agt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","A ta pakadangag na ta magtalib ya addu na tolay a pinohutan na ta kahebing na kiden am anu ya dulay. ");
INSERT INTO agt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“A te magtalib na i Hesusen nga taga Nasaret,” kunda hapa tentu. ");
INSERT INTO agt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A gafu ta kumanen a nagayayag na hapa ya nagdaramen, “Ay, Hesus, Simsima ni mina Dabid, ikallak nak haen, Afu,” pakakin. ");
INSERT INTO agt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ammi nehuya na kadwan kiden tolay petta awena mina magsitang, ammi nepasikan na para ya iayag na, “Ay, Simsima ni mina Dabid, ikallak nak haen, Afu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","A nagtayuk na hapa i Hesus, a pinaayagan na ya nagdaramen. Datang na ta atubang na a ");
INSERT INTO agt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Anu hapa ya pakkwam teyak?” kunna tentu. “Ay, Afu, ipaitak teko ya awekin pakaita,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","“Ara on, makaita kan mantu, te nagmappya kan gafu ta pangikatalak mu teyak,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","A yen hapa ya nepakaita na, a dumagdag na hapa teg Hesus ta dalan, a nagdaydayaw ta Namaratu. A nehulun hapa nagdayaw ya ngamin kiden nakaita ta tarabaku ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","A ta nesarok nig Hesus ta ili na Heriku a taliban da mina, ");
INSERT INTO agt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","3","ammi itta ten ya takday lalaki nga mayat makaita am inya i Hesus. Sakyo ya ngagan na, a naba-nang hapa, te intu ya netun na taga Roma kiden ta agsingir ta bwis na Hudyo kiden, a yen hapa ya nangikatupagan da tentu. A ta pagtalib ni Hesusen a apagan ni Sakyo ya panggirawan na tentu, ammi awan ta naapagan na gafu ta kaddu na tolay kiden, te alinnak hapa ya bari na en. ");
INSERT INTO agt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A gafu ta kumanen a bumilag i Sakyo ta unnan na angen ni Hesus, a imunek ta kayu, petta maidungan na i Hesus ta pagtalib na. ");
INSERT INTO agt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","A ta pakadatang ni Hesus ta agyan na kayu en a nagtayuk, a tinangad na i Sakyo, a binaran na. “Sakyo, alag mu, te dumagut kan, te mappya ta magdulotak ta bali men ta arawin,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A alistu hapa dumagut i Sakyo, a matalak hapa ta pagdulot ni Hesus ta bali na en. ");
INSERT INTO agt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ammi ya kadwan kiden tolay nga nangita a linibakan da i Hesus, gafu ta umange nagdulot ta bali na dulay na tolay. ");
INSERT INTO agt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A ta pagbida nig Hesus ikid ni Sakyo ta bali na en a nagtayuk i Sakyo, a nebosag na hapa ya pagbabawi na. “Afu, igadwak sangaw ta ayanin ya pobre kiden ta ngamin kwak. A am itta ya dinarogas ku ta pagpaga da ta bwis da a itolik hala sangaw tekid ya mamengappat ta kaddu na napasurok ku ta bwis da,” kunna te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A ya tabbag hapa ni Hesus tentu a “Iko mantu ya takday kagitta ni mina Abraham, te mangurug kan, a ayanin mantu ya pakesipat muy ikid na anak muy kiden ta pangikerutan na Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Te yen hapa ya imeyan ku ta isin petta apagan ku ya metawag, petta ikerutan ku,” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","A gafu ta bida ni Hesus te Sakyo a pahig na kadwan kiden nakadangag ta tanagay na ya pagpatayuk ni Hesus ta pagariyan na Namaratu ta ili na Herusalem, te abikan na ya ili en, a amu da ta yen pagdulotan ni Hesusen. A yen ta nagbida i Hesus ta takwan na keangarigan tekid, petta pake amu da mina ya dumatang. ");
INSERT INTO agt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Itta ta idi ya naba-nang na tolay,” kunna, “a negakkad na ange ta adayu na lugar, te yen ya enna pagadangan ta pagsaad na ta agyan na en, kapye na sangaw dumatang. ");
INSERT INTO agt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A gafu ta medyo mabayag sangaw a inayagan na ya mafulu ta tagabu na kiden, a nepataron na tekid ya kadwan kiden pirak na. ‘Pagatut muy yan petta maganak, te alapan ku sangaw am dumatangak,’ kunna kan tekid, kapye na nagtugut. ");
INSERT INTO agt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ammi ya kalugaran na kiden a nekatupag da, a pinadagdag da hapa ya kadwan kiden kahulun da ta enna en pagadangan ta saad na petta awena mina mesaad, te aweda ikayat ta intu ya magibbal tekid. ");
INSERT INTO agt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ammi maski kunna ten a nesaad hala, a nagtoli ta lugar na en. A sangaw pinaayagan na ya pinagtaron na kiden ta pirak na kiden, petta madangag na am piga ya naapagan da. ");
INSERT INTO agt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A ta datang na napolu en a ‘Mappya, Afu, te ya nepatarom teyak a imaddu ta mamengfulu,’ kunna kan. ");
INSERT INTO agt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘A mappya ka mantu na tagabu te awenak nelogot. A gafu ta mekatalak ka nga magtaron ta assang a paturinan ta ka hapa petta magibbal ka hapa ta mafulu na ili,’ kunna kan na ari en tentu. ");
INSERT INTO agt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“A sangaw umange hapa ya mekaduwa en tagabu na a ‘Mappya, Afu, te ya nepatarom teyak a imaddu ta mamenglima,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘A iko mantu sangaw ya magibbal ta lima na ili,’ kunna hapa na ari en tentu. ");
INSERT INTO agt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“A sangaw umange hapa ya takday, a ‘Yeh, Afu, ya nepatarom teyak. Pake neappiyak ta umag na panyaw kin, ");
INSERT INTO agt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","te amuk ta maporay ka na tolay, te pangalapam haman ya awem pagmulan, yaga magba-nang ka ta banbannag na kadwan, a nagtalawak ta pagporayan nak sangaw,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Kuga dupal ya tagabu in yan,’ kunna hapa na ari en tentu. ‘Ya uhohug mu hapa la ya pangpa-gang ku teko. Am pahig mu ta maporayak na tolay nga magba-nang ta banbannag na kadwan ");
INSERT INTO agt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","a anu awem mantu nepagatut ya pirak ku ta gumatut kiden petta itta mina ya nadatangan ku ta naapagan na kwak?’ kunna hapa na dafu na en tentu. ");
INSERT INTO agt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“A ya nebar na para ta gitayukan kiden a ‘Azin muy mantu ya nepataron ku tentu a iatad muy ta nagpakaddu en ta mamengfulu,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Ammi pake addun sangaw ya kwa na, Afu, te ittan haman tentu ya imaddu ta mamengfulu,’ kunda. ");
INSERT INTO agt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘A maski ay,’ kunna hapa, ‘te kakurugan ya uhohugan ku tekamuy ta madaggan sangaw ya kwa na makākwa en petta imad-addu ya kwa na, ammi ta awanen nagpakaddu ta kwa na a maazi hapa sangaw ya dana neatad tentu. ");
INSERT INTO agt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A ya mangikatupag kiden nga awan makidafu teyak, a alapan muy kid sin, te papasin muy kid ta atubang ku,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","A ta nekabalin ni Hesus nangibida ta keangarigan na en a nagdulot kid kontodu ituldu na kiden ta ili na Herusalem, ammi napa-polu i Hesus ta dalan. ");
INSERT INTO agt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","A tekiden nakadatang ta Bagetay na Olibo ta bikat na babali kiden ta Beffage ikid na Batanya a pinaunnan ni Hesus ya duwa na ituldu na. ");
INSERT INTO agt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Magdulot kanan ta babali kidewan, a am nakadatang kanan ta bikat da a maita muy sangaw ya urbun na kabayu nga awan para la natakayan, a negalut. Ubadan muy, te idatang muy hapa sin. ");
INSERT INTO agt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","A am itta sangaw ya mangpohut ta pangubad muy a ‘Pa masapul na bit la i Afu,’ kummuy,” a umange kid. ");
INSERT INTO agt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Naita da hala ya kabayu en ta kuman na nebar ni Hesus tekid, ");
INSERT INTO agt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","a tekiden nangubad tentu a “Annun muy hud ubadan ya urbunina?” kunna hapa na makākwa en. ");
INSERT INTO agt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“A te masapul na kan na dafu tamen,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","A ta nepangidatang da tentu a neimmak da ya ulolat da ta urbunen, a inuffunan da i Hesusen nagtakay. ");
INSERT INTO agt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A tentu en nakatakay a imunnan hapa ya addu na tolay, a nehuklad da ya ulolat da kiden ta angen na ta pangdayaw da tentu. ");
INSERT INTO agt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pakadatang da ta dadagutan na bagetayen a sa gimihawa ya ituldu na kiden, a neayag da ya pangdayaw da ta Namaratu gafu ta ngamin kiden naita da ta pakapangwa ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Bendisyonam, Afu, ya Ari in nga pinakabarim, petta mappya ta lutakin ta kuman na langitina, a kumanen ka hapa,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","A ya uhohug na kadwan kiden Pariseyu nga nehulun ta tolay kiden a “Anu awem ihuya ya ituldum kiden, te igitta da ka ta Namaratu,” kunda te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","“Am awena mina magsitang na inin kid a ibar ku tekamuy ta magsitang hud la ya batu kidin,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","A tentu en nakaabikan ta ili na Herusalem a pake itan na, a nagtangit hapa ta damdam na ta tolay na kiden. ");
INSERT INTO agt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Ampade amu muy mina ya mangatad ta kappyanan muy, ammi gagangay ta awemuy manonot, ");
INSERT INTO agt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","te pagka-ma muy sangaw ya iange na katapil muy kiden, a seran da sangaw ya ngamin kiden dalan muy petta awemuy makauhet. ");
INSERT INTO agt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","A rakrakan da sangaw ya alad muy ikid na ngamin kiden bali muy, a idangkak da kam sangaw ta lutak kontodu anak muy kiden. A awan sangaw ta mesalnuk maski ta takday la na batu ta bali muy kiden, te awemuy garay amu ya neange na mangikerutan mina tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","A ta datang da ta ili na Herusalem a simarok i Hesus ta simbaanen a pinegafwanan na pinohet ya naglaku kiden. ");
INSERT INTO agt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Anu awemuy haman manonot ya uhohug na Namaratu ta suraten, te ‘Balikin yan ya pakimallakan mina na ngamin tolay,’ kunna haman, ammi pinagbalin muy garay ta pagkakampatan na magdarogas ikid na magswitik,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","A kinanghahaw umange i Hesus ta simbaanen petta mangituldu ta tolay kiden, ammi ya padi kiden ikid na mangituldu kiden ta lintig ikid na kadwan kiden opisyales ta ili a apagan da am had kunna mina na pangpapasi da tentu. ");
INSERT INTO agt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ammi awan ta makkwa da tentu, te pake ikayat na tolay kiden ya magdangag tentu. ");
INSERT INTO agt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","A ta takday ha na araw a itta ha i Hesus ta simbaanen nga mangituldu ta tolay kiden, ikid na mangipadangag ta damag na Namaratu tekid. A umange hapa tentu ya padi kiden, ikid na mangituldu kiden ta lintig, ikid na kadwan kiden pinakadakal na tolay kiden, te pinohutan da ya gafu na tarabaku na. ");
INSERT INTO agt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Inya hud ya nangatad ta turay mu petta maguray ka la ta ngamin tinarabakum ta isin?” kunda. ");
INSERT INTO agt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","“A itta hapa ya pohut ku tekamuy, te ibar muy teyak am inya ya nangatad ta turay ni mina Hwanen nga mangzigut ta tolay? Namaratu, ono nonot la na tolay ya nangatad ta turay na?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A gafu ta napopoyung kid ta nebar na en tekid a nagbabidan da bit ta melemad am anu mina ya tabbag da. “Am ibar tam ta Namaratu ya nangatad tentu a ‘Anu kawagan na mantu ta awemuy kinurug,’ kunna sangaw tekitam. ");
INSERT INTO agt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ammi am ‘Tolay la ya nangdob tentu,’ kuntam a papasin na kitam na tolay kiden, te kurugan da haman ta Namaratu ya nagpauhohug tentu,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","A ya tabbag da mantu te Hesus a “Awemi haman amu,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","“A am awemuy mantu matabbag ya pohutan ken tekamuy a awek hapa ibar tekamuy am had sin ya gafu na turay kin ta tarabaku kin,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","A gafu ta kumanen a namegafu nagbida i Hesus ta tolay kiden nga umange hapa magdangag, ammi keangarigan ya binida na tekid: “Itta ya takday tolay nga nagmula ta addu na unas, a sangaw nepaābāng na ya kaunasan na ta kadwan, te umange nagpasyar ta takwan na lugar. ");
INSERT INTO agt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","A sangaw ta kaarawan na pagapit da a dinob na ya tagabu na en ta nangābāng kiden petta alapan na mina ya abang na en. Ammi ginafut da, a pinalpaluk da, kapye da pinatugut, a awan ta inalap na. ");
INSERT INTO agt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A sangaw dinob na makāunasen ya takday para tagabu na, a pinalpaluk da hapa yen, yaga inamāmat da, kapye da pinatugut awan ta inalap. ");
INSERT INTO agt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A sangaw dinob na ha ya takday para, a binigadan da hapa kapye da pinatugut. ");
INSERT INTO agt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‘Asakay, anu panaw ya kwan ku?’ kunna kan na makāunasen. ‘Mappya ta idob ku tekid ya anak kin talo am mamat kid sangaw tentu gafu ta pake abikan teyak,’ kunna kan na nonot na. ");
INSERT INTO agt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ammi ta nepakaita na nangabang kiden ta anak na en a nagbabidan da ya pangpapasi da tentu; ‘Gagangay ta ye-yan sangaw ya makaalap ta ngamin kwa na makāunasen. A mappya mantu ta papasin tam petta ikitanan sangaw ya makākwa,’ kunda kan. ");
INSERT INTO agt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","“A ginafut da mantu ya anak na en, a neuhet da ta kaunasan kapye da pinapasi.” A ya uhohug ni Hesus ta kinabida na kiden a “Anu hud sangaw ya uray na makāunasen ta nangabang kiden, ");
INSERT INTO agt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","awa enna kid sangaw papasin, a ipaabang na sangaw ya kaunasan na ta kadwan,” kunna. A gafu ta naawatan da ya kebalinan na keangarigan na en a “Bakkan mina ta kunna ten,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","A pake inita na kid ni Hesus, a “Am pahig muy ta awena sangaw pa-gangan na Namaratu ya pinagtaron na kiden ta kwa na a intu mina pagnonotan muy ya nesurat na aglavunen, te ‘Newarad na magbali kiden ya arigi en nga nepapatayuk na Namaratu tekid. Ammi netoli na hala a yen ya pinagbalin na ta kasikanan na arigi ta ngamin bali,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“A maski am inya sangaw ya medumpar ta arigi in yen a intu hapa la sangaw ya matakitan, a pake nahammek na sangaw am igsilan na arigi en,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","A ya padi kiden ikid na mangituldu kiden ta lintig a naawatan da ta ikid hapa la ya pagbalinan ni Hesus ta kuman na nangabang kiden ta keangarigan na en, a yen ta ginafut da mina, ammi aweda nagafut gafu ta talaw da ta tolay kiden nga mayat tentu. ");
INSERT INTO agt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A yen ta ilalapan da la, yaga dinob da ya kadwan kiden kahulun da tentu, petta ape makitabarang kid tentu, talo am itta ya madangag da ta pangidaruman da tentu ta gubernadoren nga taga Roma. ");
INSERT INTO agt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","A ya nebar da tentu a “Mistro, itta ya pohut mi teko, te amu mi ta matunung ka na tolay, a matunung hapa ya ngamin ituldum ta patarabaku na Namaratu tekitam, te awem la panunnutan am anu ya uray na tolay, ikid na awan ta idadumam. ");
INSERT INTO agt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","“A dangagan mi haen teko am ipalubus na lintig ni Moses ta magpaga kitam ta bwis ta Ari na taga Roma kiden?” kunda. ");
INSERT INTO agt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ammi narikna ni Hesus ta yen ya pangsikwat da tentu, ");
INSERT INTO agt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","a ya tabbag na tekid a “Itan ku bit ya piraken nga ipaga muy ta bwis muy,” kunna. A ta nepangigawat da tentu a “Inya hud ya makāmukat ikid na makāngagan ta pirakin yan?” kunna tekid. “A sinang mukat na Ari en,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Ipaita muy mantu ta gubyernu na Ari en ya mekustu ta pangurug muy tentu, a ipaita muy hapa ta Namaratu ya mekustu ta pangurug muy tentu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","A gafu ta itta ya addu na tolay nga nakadangag ta tabbag ni Hesus tekid a awan ta nabalinan da ta pangpaliwatan da tentu, yaga aweda hapa nakasitang ta pagpaka-lat da tentu. ");
INSERT INTO agt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","A ta nekabalin na Pariseyu kiden a umange hapa tentu ya Saduseyu kiden. A itta hapa ya pohut da tentu gafu ta aweda kurugan ta matolay hala sangaw ya nagpasi kiden. ");
INSERT INTO agt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Itta hapa ya pohut mi, Mistro, gafu ta lintig ni Moses,” kunda. “Te am masi kan mina ya lalaki nga awan ta anak na a mappya kan ta kabagis na en ya mangatawa ta kabalwan na en petta itta kan sangaw ya anak da nga lalaki nga mekwenta ta anak na nasi en. ");
INSERT INTO agt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A ta idi ta lugar mi itta ya pitu na lālāki nga nagkakabagis, a nangatawa hapa ya imunnanen, ammi nasi hala ta aweda para la paganak. ");
INSERT INTO agt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","A gafu ta lintigen a inatawa na mekaduwa en ya atawa na en, a sangaw timubbat ya mekatallu en, a kumanen hapa abat ta mekapitu en, te sa nagpasi kid ta pangatawa da ta babbayen, ammi awan pulus ta nesirak da ta anak da. ");
INSERT INTO agt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A kabalinan na pasi na mekapitu en a nasi hapa ya babbayen. ");
INSERT INTO agt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","A am kakurugan ta sa matolay kid hala sangaw ta araw na pagtolay na nagpasi kiden a had sin hud ta pitu kiden ya atawa sangaw na babbayen, te ikid ngamin ya nangatawa tentu,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","A ya tabbag ni Hesus tekid a “Gagangay ta mag-aatawa ya tolay kiden ta katolay da sin, ");
INSERT INTO agt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ammi ya nagpasi kiden nga gagangay matolay ta araw na pangtolay na Namaratu a awedan sangaw mangatawa, ");
INSERT INTO agt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","a awedan sangaw masi, te am tolayan na kid sangaw na Namaratu a kagitta na kid sangaw na anghel kiden ikid na Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A maski am awemuy kurugan ta matolay hala sangaw ya nagpasi kiden a yen hala ya nepasikkal ni mina Moses ta surat na en gafu ta uhohug na Namaratu tentu ta agyan ta kalakayu en nga umagātang, te ya uhohug na en te Moses a ‘Iyak ya Dyos nga dayawan ni Abraham, ikid ni Isak, ikid ni Hakob,’ kunna. ");
INSERT INTO agt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A gagangay mantu ta matolay hala yen kid, te bakkan haman ta nasi ya mangdayaw ta Dyos, te ya matolay ya mangdayaw tentu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","“Mappya hapa ya tabbag mina,” kunna hapa na kadwan kiden mangituldu ta lintig, ");
INSERT INTO agt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","a awan na ta nagpohut tentu talo am maabak kid hapa. ");
INSERT INTO agt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","A ta nekabalin na pagpohut da a itta hapa ya pinohutan ni Hesus ta tolay kiden. “Ya kuman na ituldu na mangituldu kiden ta lintig a ibar da ta simsima ni mina Dabid ya Mangikerutanen nga nekari na Namaratu. A kakurugan hapa ya ibar da, ammi had kukunna simsima na? ");
INSERT INTO agt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Te ya nesurat ni mina Dabid ta lebru na Kansyon Kiden a ");
INSERT INTO agt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","‘Itta ya nebar na Namaratu ta dafu ken, te “E ka sin magtogkok ta kanawan kin, te ikita ya mangabak ta ya katapil mu kiden, petta iko sangaw ya makkamu ta ngamin,” kunna.’ ");
INSERT INTO agt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A am ‘Dafu ken,’ kun ni mina Dabid ta Makkamu en, a had kukunna mantu magbalin ta simsima na para?” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","A ta pagdangag para la na tolay kiden a itta ya nebar ni Hesus ta ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Itan muy ta awemuy parigan ya mangituldu kiden ta lintig, te ikayat da itugtugut ya barawasi na pangituldu da petta dayawan na kid na tolay. A am itta ya pabuya ikid na gimung a pilin da para ya kaispotan na agtuttudan petta malogon kid maita. ");
INSERT INTO agt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ammi magimmamappya kid la, te ikid hala ya mangayayyaw ta bābāy kiden nabalu ta panguffun da tekid petta magubat da ya bali da. A am itta kid ta paggagimungan a makimallak kid ta mabayag petta pahig na kadwan kiden ta abikan kid ta Namaratu. Ammi pake dakdakal sangaw ya pangpa-gang na Namaratu tekid ammi ta kadwan,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","A ta pangituldu para la ni Hesus ta simbaanen a itan na ya naba-nang kiden nga umange mangila-nug ta pirak da ta agyan na agila-nugan na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A sangaw umange hapa ya napanglaw na babbay, a nela-nug na ya duduwa la na sinsilyu, kustu ta lugar na binting. ");
INSERT INTO agt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","A ya uhohug ni Hesus ta ituldu na kiden a “Itan muy ya babbay ewan, kakurugan ta ad-addu ya nela-nug na ammi ta pagdadaggan na ngamin kiden nela-nug na kadwan kiden, ");
INSERT INTO agt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","te intu neatad da ya sobra na kaba-nang da, ammi tentu a neatad na ya magserbi mina tentu gafu ta kapanglaw na, te neatad na ya ngamin katolayan na,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","A ta pagbabida na kadwan kiden a dayawan da ya kalalaki na simbaanen, te dappug haman ya batu na kiden nga nataga, ikid na addu ya neatad na tolay kiden ta pamaispot da ta simbaanen. ");
INSERT INTO agt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","A ya uhohug ni Hesus tekid a “Kakurugan ya ibar ku tekamuy ta sa marabba sangaw ya ngamin bali in yan abat ta awan pulus ta mesalnuk ta maski takday la na batu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","A ya pohut da hapa tentu a “Kanu sangaw na araw ya kaperdi na simbaanen, a anu sangaw ya pakaitan mi ta datang na,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A ya tabbag na en hapa tekid a “Pake itan muy ta maayayyaw kam sangaw,” kunna, “te addu sangaw ya umange nga mangingagan ta ngagan kin, te ‘Iyak ya Kristu nga Mangikerutan tekamuy, te dimmatang na ya araw na pangikerutan na Namaratu tekamuy,’ kunda sangaw, ammi awemuy kid kurkurugan. ");
INSERT INTO agt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","A am itta sangaw ya madamag muy ta gubat ta agyan muy ikid na gubat ta adayu a awemuy la malalang ta isin kid, te gagangay ta dumatang ya kumanin kapye na idatang na pagaddetan na arawin yan. ");
INSERT INTO agt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Te pagka-ma magkāgubgubat ya kadwan kiden tribu, yaga magkakattway hapa ya kadwan kiden tolay nga maginggubgubat. ");
INSERT INTO agt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A dumatang hapa ya addu na lunig ikid na agbabisin, ikid na takit ta magdaduma na lugar. A maita muy hapa sangaw ya kattatalawan na pakaitan ta langit. ");
INSERT INTO agt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ammi ta awena para la dumatang na inin kid na zigat a dana gafutan da kam sangaw, petta idarum da kam ta atubang na tolay kiden ta kapilya, kapye da kam ibalud. A iatubang da kam hapa sangaw ta gubernador da kiden ikid na ari da kiden gafu ta pangurug muy teyak, ");
INSERT INTO agt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","petta ipasikkal muy tekid ya gafu na tarabakun muy. ");
INSERT INTO agt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","A mappya mantu ta dana itug muy ta nonot muy ta awemuy sangaw burungan am anu ya itabbag muy tekid, ");
INSERT INTO agt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","te am ittan sangaw ya kustu na paguhohug muy a iyak sangaw ya mangatad tekamuy ta uhohugan muy ikid na pangrazonan muy. A maabak muy hapa sangaw ya katapil muy kiden, te aweda sangaw matabbag ya uhohugan muy. ");
INSERT INTO agt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A ya kadwan kiden tekamuy a italaba na kam na dakal muy kiden ikid na kabagis muy ikid na kahulun muy kiden pase kofun muy kiden, a papasin da ya kadwan tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Te ikatupag na kam sangaw na ngamin tolay gafu ta pangurug muy teyak. ");
INSERT INTO agt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ammi maski kunna ten awan pulus ta mawakay maski ta takday la na huk muy, ");
INSERT INTO agt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","te am attaman muy la ya ngamin makkwa tekamuy a maatadan kam hala sangaw ta magnayun na angat.” ");
INSERT INTO agt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“A kumanen hapa am maita muy sangaw ya armado na suddalu kiden nga manglehut ta ili na Herusalem a yen ya pakkamu muy ta tanagay na ya kaperdi na. ");
INSERT INTO agt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","A yen mina ya pagbabakwit na itta kiden ta Hudeya petta umahat kid mina ta bagetay kiden. A kumanen hapa ta itta kiden ta umag na ili. A ya itta kiden ta lawan na ili a aweda mina simarok, ");
INSERT INTO agt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","te yen sangaw ya araw na pangpa-gang na Namaratu petta magdulot ya ngamin kiden linavun na aglavun kiden ta surat kiden. ");
INSERT INTO agt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ammi kakallak sangaw ya matarun ikid na magpasusu ta isina kid na araw te pake mazigatan kid nga magbakwit, te yen ya datang na dakal na pagzigātān ikid na pangpa-gang na Namaratu ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A mapapasi ya kadwan, ikid na magafut ya kadwan petta metugut kid mebalud ta kadwan kiden lugar ta paglelehutin. A mapannu sangaw ya ili na Herusalem ta suddalu na Hentil kiden addet ta kabalin na araw na Hentil kiden.” ");
INSERT INTO agt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“A am nabalin sangaw yen kid na zigat a itta sangaw ya takwan na pakaitan ta bilag ikid na hulan ikid na bitwan kiden ta langit, a pake magtalaw sangaw ya tolay kiden gafu ta simiksikan sangaw ya palung kiden ta bebay. ");
INSERT INTO agt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A pake kumafuy sangaw ya nonot na tolay kiden gafu ta talaw da ta dumatang ta paglelehutin, te makutukutet hapa sangaw ya bitwan kiden ta langit. ");
INSERT INTO agt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A yen sangaw ya pakaitan na ngamin tolay ta lattog na Tolayin taga Langit ta langitewan, te dumagut sangaw nga imatogkok ta kulam kiden, a mehulun sangaw tentu ya ngamin kasikanan ikid na kalalakin na Namaratu. ");
INSERT INTO agt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","A am maita muy sangaw ta namegafun yan kid na pakaitan a awemuy gitumagan awa matalak kanan, te tanagay na ya pangikerutan na Namaratu tekamuy.” ");
INSERT INTO agt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","A sangaw binida ni Hesus ya takwan na keangarigan tekid. “Nonotan muy ya keangarigan na taggaten, ikid na kadwan kiden kayu, ");
INSERT INTO agt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","te am lumattog na ya bagu kiden don da a yen ya pakaitan ta darun na. ");
INSERT INTO agt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","A kumanen hapa sangaw am dumatang na ya ngamin kiden nabidak tekamuy ta ayanin, te yen sangaw ya pakaitan ta tanagay na ya pagpatogkok na Namaratu ta dafu muy. ");
INSERT INTO agt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A kakurugan hapa ya ibar ku tekamuy ta mamegafu magdulot ya ngamin kidin nabidak tekamuy ta awena para la masi na tolay kiden ta ayanin. ");
INSERT INTO agt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Te gagangay ta imawan sangaw ya ngamin langitewan pase lutakin, ammi awena sangaw mauli na ngamin inuhohug ku tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“A mappya mantu ta imugudan muy, petta awemuy maayayyaw gafu ta madugal kam ikid na magillaw kam ikid na magburung kam ta katolay muy. A sigida makaparan kam, ikid na awemuy sangaw masikwatan ta araw na zigat, ");
INSERT INTO agt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","te dumatang la dumatang ye-yen na araw ta ngamin kiden tolay ta utun na lutak. ");
INSERT INTO agt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","A mappya mantu ta hutunān muy, a sigida makimallak kam, petta itta ya pagsikan muy nga magattam ta ngamin kiden dumatang, petta awemuy sangaw mamat am mapaatubang kam sangaw ta Tolayin taga Langit ta datang na,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","A kinanghahaw nangituldu i Hesus ta umag na simbaanen, ammi ta hiklam a umange nagammak ta bagetay na Olibo. ");
INSERT INTO agt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","A kada lalakwat a naggabi hapa ya tolay kiden nga ange ta simbaanen, petta dangagan da ya ituldu na. ");
INSERT INTO agt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","A ta tanagay na ya pyesta na pan nga awan bumlad, ");
INSERT INTO agt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","a nagmamiting ya padi kiden ikid na mangituldu kiden petta pagbabidan da am had kunna mina na pangpapasi da te Hesus gafu ta tolay kiden nga dumagdag tentu. ");
INSERT INTO agt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","A tekiden para la nagmiting a itta hapa ig Hesus ikid na ituldu na kiden ta takwan na lugar, a yen hapa ya nesassarok ni Satanas ta nonot ni Hudas Iskaryote petta italaba na i Hesus, te intu ya takday na mafulu duwa kiden kahulun ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","A umange mantu i Hudasen nakitulag ta padi kiden ikid na maggwardya kiden ta simbaanen, petta italaba na i Hesus. ");
INSERT INTO agt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","A natalakan kid hapa ta bida na tekid, a nekari da tentu ya pirak. ");
INSERT INTO agt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mayat hapa i Hudas ta tulag da a yen ya pamegafu na nga magapag ta pangitalaba na te Hesus ta kawan na addu na tolay. ");
INSERT INTO agt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","A ta araw na pangan da ta panen nga awan bumlad, a yen hapa ya pangiatang da ta kalneru, te pagnonotan da ta araw na nepangilillik na Namaratu ta gingginafu da kiden. ");
INSERT INTO agt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","A dinob ni Hesus ig Pedru ikid ni Hwan petta enda iparan ya panganan da ta kalneru da. ");
INSERT INTO agt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“A had sin mina ya pangiparanan mi?” kunda hapa tentu. ");
INSERT INTO agt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","“E kam ta ili, te masimmu muy sangaw ya magtattun ta tākalamba na danum, a dagdagan muy la. A sangaw am nakasarok kanan ta bali a ibar muy ta makābali en, ");
INSERT INTO agt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","‘Dinob na kami ni Mistro, te itan mi kan ya lugar na panganan mi ta pamurab mi ta Simana in,’ kummuy, ");
INSERT INTO agt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","a ituldu na sangaw ya dakal na silid ta utun, a yen sangaw ya pangiparanan muy ta pamurab tam,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","A umange kid, a naita da hala ya kuman na nebar ni Hesus tekid, a neparan da ya pamurab da ta Simana. ");
INSERT INTO agt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A sangaw ta nekaparan na ngamin a nakiatubang ig Hesus ikid na mafulu duwa kiden ituldu na. ");
INSERT INTO agt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A tekid para la nagkakan a naguhohug i Hesus. “Pake ikayat ku ta magaatubang kitam ta ayanin, te awena para la dumatang na zigat kin. ");
INSERT INTO agt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ammi awek na sangaw makiatubang tekamuy ta isin na pamurab addet ta nakompleto ngamin ta pagariyan na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A sangaw nagibbal ta paginuman na binarayang kapye na nakimallak, a sangaw negawat na ta ituldu na kiden. “Ye, sa uminum kanan ta isin, ");
INSERT INTO agt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ammi teyak, awek sangaw uminum ta kumanin abat ta pagayayat tam sangaw ta pagariyan na Namaratu ewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kabalinan na kumanen a nagibbal hapa ta tāhukal na pan kapye na nakimallak ha. A sangaw ginadgadwa na ya pan en, a nesaned na tekid. “Kanan muy yan, te panadamdaman muy teyak, te ye-yan ya negitta ta barikin nga isagapil ku gafu tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","A ta nekabalin na nepamuhab da a inibbalan na ha ya paginuman na binarayang kapye na neatad tekid, “Ye-yan ya panadamdaman muy ta bagu en tulag na Namaratu tekamuy gafu ta dagak nga magarut sangaw ta gafu tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","A itta hapa ta lamesa in ya mangitalaba sangaw teyak, ");
INSERT INTO agt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","te mappya ta mapapasi ya Tolayin taga Langit ta kuman na nekari na Namaratu ewan, ammi kakallak sangaw ya mangitalaba in tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","A nagimpopohutan da hapa am inya panaw tekid ya mangitalaba sangaw tentu. ");
INSERT INTO agt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A sangaw nakidibati hapa ya ituldu kiden ni Hesus, te nagingfulfulatan da am inya tekid ya pinakadakal da. ");
INSERT INTO agt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ammi nedangagan na kid ni Hesus, a pake tinabarangan na kid. “Amu muy ya gagangay na ari na Hentil kiden ta ikwenta da ya iturayan da kiden ta kuman na tagabu da, a ingagan da hapa ya bari da ta mangikerutan. ");
INSERT INTO agt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ammi awemuy mina parigan yen kid, te ya kadakalan muy a magbalin mina ta kaassangan muy ikid na magserbi en tekamuy. ");
INSERT INTO agt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ta kuman na uray na tolay a intu dakdakal ya imatuttuden mangan ammi ta mangiatubang ta kanan na. Ammi mappya ta iyak ya parigan muy te itta yak sin tekamuy ta kuman na mangiatubang ta kanan. ");
INSERT INTO agt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mappya te ikamuy ya kanayun nehulhulun teyak ta ngamin kiden zigat ken. ");
INSERT INTO agt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","A ya neatad ni Damakewan teyak ta iturayan ku a yen hapa ya isipat ku tekamuy, ");
INSERT INTO agt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","petta ikamuy hapa sangaw ya makiatubang teyak ta lamesaken ta lugar na pagariyan ku. A magtogkok hapa sangaw ya tagtakday tekamuy ta kuman na agtogkokan na ari, petta magibbal kam hapa sangaw ta mafulu duwa kiden tribu na Istralita kiden. ");
INSERT INTO agt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“A iko hapa Simon, a dangagam ya ibar ku teko, te pake ikayat ni Satanas ya mangalap tekamuy ngamin, petta paruban na kam sangaw ta kuman na magsap ta aggik, ");
INSERT INTO agt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ammi iko Simon ya pake nepakimallak ku petta awena mawakay na pangurug mu teyak. Ammi sangaw am nagbabawi kan ta pagtalekud mu teyak a uffunam hapa ya kabagis mu kiden, petta magsikan hapa ya pangurug da,” kun ni Hesus te Pedru. ");
INSERT INTO agt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","“Ay, Afu, aweta ka pagtalekudan maski mehulunak teko mebalud ikid na mapapasi,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Itam sangaw awa kustu ya uhohug ku teko, Pedru,” kunna ha ni Hesus tentu, “te maski ta awena para la pagtareknay na manuk ta hiklamin yan a mamillu ka sangaw mangilemad ta pakkamum teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","A sangaw nagbida ha i Hesus tekid ngamin, “Tekamuyen immange nangipadangag ta idi ta awemuyen nepagbalun a itta de ya nagkurangan muy?” kunna. “Awan O, Afu” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","“A onay. Ammi bakkan sangaw ta kunna ten, te ya uhohug na aglavunen gafu teyak a ‘Isipat da sangaw ta dulay kiden na tolay’, kunna ta surat na en. A gafu ta magdulot hala sangaw ya nesurat na en a ikatupag da kam hapa sangaw gafu teyak. A mappya mantu ta ikamuy hapa la sangaw ya makkamu ta ngamin masapul muy nga pirak ikid na ga-gamit muy kiden. A gafu ta zigat muy sangaw a pake karkaragatan muy ya kampilan ammi ta ulat muyen,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","“A itam, Afu, duwa haman ya kampilan mi,” kunda hapa. “Bay-an muy na ya kumanina na bida,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A ta kabalin na en a imuhet kid ni Hesus ta bali, a umange kid ta Bagetayen Olibo ta kuman na gagangay ni Hesus ta idi. ");
INSERT INTO agt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","A ta datang da ta lugaren nga kanayun nakimallakan na a “Magyan kanan la sin, a makimallak kanan ta awemuy timuluk ta mamahpahuba en tekamuy,” kun ni Hesus tekid, ");
INSERT INTO agt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","kapye na sang imadayu tekid. A sangaw namalentud ta lutak, a nakimallak. ");
INSERT INTO agt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Amang, am mappya ta uray mu a azim haen ya zigatin yan. Ammi maski kunku a bakkan mina ta yen ya magdulot, te mappya ta ikayat men ya idulot ku,” kunna ta pakimallak na. ");
INSERT INTO agt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","A lumattog hapa ya anghel na Namaratu nga nangpasikan tentu. ");
INSERT INTO agt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","A gafu ta pake nazigatan a pinasikan na para ya pakimallak na addet ta neugang ya daga na en, a nagsaddu ta lutak. ");
INSERT INTO agt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A tentu en imivwat ta nakimallakan na en a nagtoli ta ituldu na kiden, ammi nakakasidug kid na gafu ta pake nabannag kid na ta pagdamdam da tentu. ");
INSERT INTO agt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Anu masidug kanan? Imivwat kanan, a makimallak kam petta awemuy mina maayayyaw,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","A ta paguhohug para la ni Hesus tekid a dumatang na i Hudasen, a nehulun hapa tentu ya addu na tolay. A umange i Hudas te Hesus petta amuyan na mina, ");
INSERT INTO agt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ammi ya uhohug ni Hesus tentu a “Anu haman ta amuyam, Hudas, ya Tolayin taga Langit ta pangitalabam tentu?” kunna. ");
INSERT INTO agt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","A ta nepakaita na kahulun ni Hesus ta gafutan da a “Mappya de, Afu, ta katkattaban mi kid na?” kunda. ");
INSERT INTO agt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","A ka-ma la kinattab na takdayen ya tagabu na kadakalanen padi, a newasik na ya takday bangbang na. ");
INSERT INTO agt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","“Awemuy na!” kunna hapa ni Hesus tekid, otturu sini-ged na ya bangbang na kinattab da en, a nagmappyan. ");
INSERT INTO agt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","A sangaw naguhohug hapa i Hesus ta ange kiden nanggafut tentu. “Anu, dulayak hud na tolay, petta endak gafutan konsu kampilan ikid na paluk ta kuman na panggafut muy ta tulisan? ");
INSERT INTO agt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kinanghahaw itta yak haman tekamuy ta simbaanen nga nangitultuldu, anu bakkan ta yen ya nanggafutan muy teyak? Ammi gagangay ta ayanin ya oras muy te sugiram ya oras na mamadday ta dulay,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","A ta nepakagafut dan tentu a netugut da neange ta bali na kadakalan na padi, a tinultulitul na kid ni Pedru. ");
INSERT INTO agt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Datang da ta bagaw na bali en a naghatung kid ta paggukupan da, a nakipagtuttud hapa i Pedru tekid. ");
INSERT INTO agt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","A ta pagtuttud para la ni Pedru ta dakar na afuyen a nagtalib ya babbayen tagabu, a pake inita na ta mappya kapye na netuldu ta kadwan kiden. “Yeyan hapa ya takday kahulun na ginafut da en,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ammi nelemad ni Pedru. “Awek amu yen O,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ammi sangaw ta magananwan a itta hapa ya takday nga nakalasin tentu a “Maski iko hapa ya takday,” kunna. “O iyak hud O,” kunna ha ni Pedru. ");
INSERT INTO agt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A sangaw ta pagtalib na kuman na takday oras a pake nepapilit para na takday ta intu. “Talaga ta iko hapa ya takday kahulun na, te taga Galileya ka,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","“Atsi O, awek para la aamu yen O!” kunna ha naglemad, a ka-ma la nagtareknay ya manuk. ");
INSERT INTO agt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A nagbalittag na hapa i Hesus nga imatubang tentu, a yen hapa ya nepakanonot ni Pedru ta uhohug ni Hesus tentu ta “Mamillu ka mangilemad teyak ta awena para la pagtareknay na manuk,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","A insigida nagtugut i Pedru, a masikan nagtangit. ");
INSERT INTO agt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","A ya tolay kiden nga naggwardya te Hesus a pinābānglu da, te tinappanan da ya mata na kiden kapye da pinalpaluk, “O, ibar mu am inya ya nagpaluk teko, te malalaki ka haman maglavun,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A addu para ya inuhohug da tentu ta pamadpadulay da tentu. ");
INSERT INTO agt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","A ta magkarawanen a nagkakampat ya padi kiden ikid na abugado kiden ikid na ngamin kiden kalalaklakayan, a neange da i Hesus ta atubang na ngamin kiden konsihal petta idarum da. A ya uhohug da te Hesus a ");
INSERT INTO agt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Am kakurugan ta iko ya Ari en Kristu nga nekari na Namaratu, a ibar mun,” kunda tentu. Ammi ya tabbag na en tekid a “Am ibar ku mina tekamuy a awemuy haman kurugan, ");
INSERT INTO agt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","a am itta ya pohut ku tekamuy a awemuy hapa tabbagan. ");
INSERT INTO agt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ammi awena la mabayag a makipagtuttud ya Tolayin taga Langit ta kanawan na Namaratu ewan nga Makapangwa ta Ngamin,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","“A ta kuman na ikayat mu uhohugan a iko ya Anak na Namaratu ewan?” kunda. “Kakurugan ta iyakin yen,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","“Itan muy yen, masapul hud para ya mangipasikkal ta liwat na, te ikitanan hapa la ya nakadangag ta uhohug na,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","A ta nekabalin dan a sa nagtayuk kid, a enda nedarum i Hesus te Gubernador Pilato. ");
INSERT INTO agt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","“Ginafut min ya tolayin yan, te sansanatan na ya tolay kiden petta makitapil kid ta gubyernu. A ibar na hapa ta aweda mina pagan ya bwis da ta gubyernu na Ari muyen Sisar, yaga ipapilit na hapa ta intu ya netun na Namaratu ta ari mi,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","A gafu ta kumanen a pinohutan hapa ni Pilato, “Kurug de ta iko ya ari na Hudyo kiden?” kunna. “Itta la teko,” kunna hapa ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","A sangaw naguhohug i Pilato ta Hudyo kiden nga ange nangidarum, “Ta kuman na uray ku a awan ta gafu na pangidarum muy tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ammi nepapilit da ya nepangidarum da tentu. “Ye-yan na tolay ya mangituldu ta ngamin paglelehutin abat ta lugar na Galileya abat ta isin Hudeya, a sansanatan na ya tolay kiden petta makitapil kid mina ta gubyernu,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","A gafu ta kumanen a pinohutan ni Pilato tekid am taga Galileya i Hesus, a “On,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“A alapan muy mantu, te iange muy te Gubernador Herud, te intu haman ya makkamu ta tolay kiden taga Galileya,” kun ni Pilato tekid, te itta hapa i Gubernador Herud ta ili na Herusalem ta arawin yen. ");
INSERT INTO agt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","A ta nepangidatang da tentu te Herud a matalakan hapa i Herud, te addu ya nadangdangag na te Hesus ta idi, a ikayat na hapa itan, talo am itta ya ipaita ni Hesus tentu ta pakapangwa na. ");
INSERT INTO agt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","A addu hapa ya pinohutan na te Hesus, ammi awena pulus tumabbag ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A ya pinakadakal na Hudyo kiden a addu hapa ya binida da ta pangidaruman da tentu, ammi awan hapa ta netabbag ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A gafu ta awena tumabbag a inuyoyungan ni Herud ikid na suddalu na kiden, a tinapangan da ta addu na uhohug. A sangaw pinagbarawasi da ta kuman na ari kapye da hala pinatoli te Pilato. ");
INSERT INTO agt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ta idi a nagkākatupag ig Herud ikid ni Pilato, ammi mappya kid na ta arawin yen gafu ta azo matupag kid na te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","A ta nepangitoli dan te Hesus te Pilato en a pinagkakampat na ya pinakadakal na Hudyo kiden petta magbida tekid. ");
INSERT INTO agt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Ye-yan na tolay ya neange muy teyak, te ibar muy haman ta sanatan na ya kagitta muy kiden petta makitapil kid mina ta gubyernu. Ammi pinohutan ku ta mappya ta atubang muy, a awan haman ta nadangag ku ta kuman na pangidaruman muy tentu. ");
INSERT INTO agt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kumanen hapa te Gubernador Herud, awan kan ta liwat na, a yen ta pinatoli na teyak. Maita muy mantu ta awan haman ta pangpapasin mi tentu. ");
INSERT INTO agt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","A mappya mantu ta papaligat ku la kapyek ibbatan,” kun ni Pilato tekid. ");
INSERT INTO agt_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","A ya gagangay da ta idi a pohetan da ya takday mabalud ta kada Pyesta na Panadamdaman, petta matalakan mina ya Hudyo kiden ta gubyernu ni Ari en Sisar. A yen ta nebar ni Pilato ta pohetan na mina i Hesus, ");
INSERT INTO agt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ammi bakkan te Hesus ya ikayat da. “Papasim yana, te Barabas mina ya pohetam,” kunda, ");
INSERT INTO agt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","te ya kinan da en Barabas a nabayag hapa nabalud gafu ta sinanat na ya tolay kiden petta makitapil kid ta gubyernu, yaga namapasi hapa ta tolay ta idi. ");
INSERT INTO agt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","A gafu ta kumanen a nakibida ha i Pilato tekid, pettam onan da mina ya pangpohet na te Hesus, ");
INSERT INTO agt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ammi nafulotan kid nagayag: “Papasim, pagappam na ta krus,” kun na ayag da. ");
INSERT INTO agt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","“Annun ku hud papasin? Anu hud ya liwat na? Awan haman ta amuk ta pakapapasi na. A mapmappya ta papaligat ku la kapyek pohetan,” kunna ha ni Pilato tekid. ");
INSERT INTO agt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ammi kuga nafulotan ha ya tolay kiden nga nagayayag ta masikan, te ipapilit da ya pasi ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","A gafu ta kumanen a timuluk i Pilato ta nebar da en, a pinohet na ya nabaluden nga namapasi ikid na nakitapil ta gubyernu ta idi, a negawat na i Hesus ta tolay kiden petta kwan da ya ikayat da kwan tentu. ");
INSERT INTO agt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","A ta nepangalap dan te Hesus a neuhet da ta ili, petta pagappan da ta krus. A tekiden dumayum ta agyan na pagpaappan da tentu a nasimmu da ya takday lalaki nga nagngagan ta Simon nga taga Sirene, te bagu nagafu ta takday na bariyo. A simarok mina ta ili, ammi kinalbatan da nga pinagagtu ta krus ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A dumadagdag hapa ya pake addu na tolay kontodu bābāy nga nakatangtangit ta pagdamdam da te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","A yen ta nagbalittag i Hesus nga naguhohug tekid. “Ikamuy bābāy, bakkan mina ta iyak ya tangitān muy, te intu mina tangitan muy ya bari muy ikid na anak muy. ");
INSERT INTO agt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Te dumatang sangaw ya pake dulay na araw, a ibar da sangaw ta nagāsāt ya bābāy kiden nga awan naganak ikid na awan kiden ta pasusu. ");
INSERT INTO agt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Te sangaw am dumatang na ye-yen na araw a magayag ya tolay kiden ta bagetay kiden, petta tappanan da kid mina, ");
INSERT INTO agt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","te am kumanin ya dumatang ta awanen ta liwat a pake duldulay para sangaw ya dumatang ta seliwat kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A nepehulun da hapa ya duwa na pake dulay na tolay te Hesus, petta igindan da i Hesus papasin ta duwa kiden. ");
INSERT INTO agt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","A tekiden nakadatang ta agyan na kinan da en Banga na Ulu, a yen ya nagpaappan na suddalu kiden tekid ta tallu na krus, a netunglak da ya kayu en nga nagappan ni Hesus ta naghatan na duwa kiden nga pake dulay. ");
INSERT INTO agt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","A ta nepagpaappa da te Hesus a nepakimallak na kid “Amang, pakomam kid te aweda amu ya kwan da,” kunna. A ya suddalu kiden hapa a nagbabinunutan da ya ga-gamit kiden ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A ya kadwan kiden tolay a umatayuk kid la naggiraw ta pinagappa da kiden, ammi ya pinakadakal da kiden a inuyoyungan da la i Hesus, “Agu ta intu mina ya mangikerutan ta ikattolay na kiden, ammi ikerutan nan mina ya bari na en am kurug ta intu ya netun na Namaratu ta mangikerutan,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","A sangaw tumubbat hapa ya suddalu kiden nanguyoyung tentu, te enda negawat ya suka ta inuman na, otturu nebar ta ");
INSERT INTO agt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Ikerutam mina ya barim, te Ari ka haman na Hudyo kiden,” kunda hapa, ");
INSERT INTO agt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","te dana netun da ya surat ta utun na ulu na en, a “Ari na Hudyo kiden,” kun na suraten. ");
INSERT INTO agt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","A ya takdayen nga pinagappa da ta hebing ni Hesus a medyo nakaporay hapa te Hesus; “Agu ta iko haman ya netun na Namaratu ta mangikerutan? A ikerutam mantu ya barim ikid na bari mi,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ammi ya takdayen ta taakub ni Hesus a nagsasitangan na hapa ya napolu en, “Anu awem haman mamat ta Namaratu maski ta pasim? ");
INSERT INTO agt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Gustu hala ya pagpapasi da tekita, te inatadan da kita ta kuman na nagliwatan ta, ammi awan haman ta liwat na tolayin yan,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","A sangaw nakimallak hapa te Hesus; “Ay Hesus, nonotan nak haen, Afu, am nakatogkok kan ta pagariyam,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","“Kakurugan ya uhohugan ku teko ta mehulun ka hapa sangaw teyak ta arawin yan ta pake ispot na lugar,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A ta tangngan na araw a nagsugiram na ya ngamin na paglelehut da en ta kuman na hiklam abat ta tallu na oras, te nagsugiram ya bilag. ");
INSERT INTO agt_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","A ka-ma la napissang hapa ya zingzingen nga ga-gamit ta umag na simbaan en. ");
INSERT INTO agt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","A ta kuman na alas tres ta furab a nagayag i Hesus ta masikan, “Amang, ikon la ya makkamu ta kahalwakin,” kunna. A yen ya nepasi na. ");
INSERT INTO agt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","A ya kapitan na suddalu nga naggwardya ta pinagappa da kiden a dinayawan na hapa ya Namaratu gafu ta naita na en. “Kakurugan kad ta mappya na tolay yan,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A ya tolay kiden nga umange naggiraw, a nagdamdam kid hapa ta naita da, a napopoyung kid na nagtugut magtoli ta bali da. ");
INSERT INTO agt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","A ya kofun kiden ni Hesus kontodu bābāy kiden taga Galileya nga dumagdag tentu ta idi a umatayuk kid la ta sang adayu, a itan da la ya ngamin nakkwa tentu. ");
INSERT INTO agt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","52","A ta nekabalin na pasi ni Hesus a itta ya takday lalaki nga umange te Pilato, petta adangan na ya bari ni Hesusen. I Hose ya ngagan na, a taga Arimateya ta lugar na Hudeya. Mappya hapa na tolay, te kurugan na ya ngamin lintig na Hudyo kiden, yaga nabayag na hapa nangipapa-na ta Mangikerutanen nga nekari na Namaratu. Intu hapa ya takday konsihal na Hudyo kiden, ammi awena kumabkabat ta nepangpapasi da te Hesus. ");
INSERT INTO agt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A ta nepangidagut ni Hose ta bari ni Hesus a inulolatan na ta furaw na ulat, kapye na neange ta pangitanaman na tentu. A netanam na ta kababagu na tanam nga kinobkob da ta batu ta kuman na kweba, ammi awan para la ta netanam. ");
INSERT INTO agt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Furab ta Byernis ya nepangitanam na tentu, a yen hapa ya pamegafu na araw na agimmang na Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","A ya bābāy kiden nga dumadagdag te Hesus tentu en nagtugut ta lugar na Galileya a naita da hapa ya tanam na ikid na nepangpaidda na ta bari na en. ");
INSERT INTO agt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","A sangaw nagtugut kid hapa nga dumatang ta bali da, petta mangiparan kid ta bangog, te iluggud da sangaw ta bari ni Hesus. Ammi nagimmang kid bit ta araw na agimmang, te pangurug da ta lintigen. ");
INSERT INTO agt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","A ta nagkahawan ta Liggu a naggabi ya bābāy kiden nga ange ta agyan na tanamen, te nehulun da ya bangogen nga neparan da ta bari ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ammi ta datang da ta tanamen a dana naazin ya batu en nga nesalin ta sasahokan na tanamen. ");
INSERT INTO agt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","A simarok kid, ammi awan na ya bari ni Hesusen! ");
INSERT INTO agt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","A gafu ta mapopoyung ya nonot da a umatayuk kid bit la ten, a ka-ma la itta ya duwa na lalaki nga pake magdakar ya barawasi da, a nagtayuk kid ta hebing ta bābāy kiden. ");
INSERT INTO agt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Alistu nagtakab ya bābāy kiden ta talaw da tekid, a sangaw naguhohug ya duwa kiden tekid, “Anu haman ta apagan muy ya natolay ta tanamin, ");
INSERT INTO agt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Awemuy de manonot ya nebar na en tekamuy ta nepagyan na en tekamuy ta iten Galileya? ");
INSERT INTO agt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mappya ta megawat ya Tolayin taga Langit ta awan kiden mangurug ta Namaratu petta pagappan da ta krus, ammi matolay hala sangaw ta mekatallu en araw,’ kunna paen tekamuy,” kunda tekid. ");
INSERT INTO agt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","A yen hapa ya nepakanonot na bābāy kiden ta uhohug ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","A gafu ta kumanen a nagtugut kid, a enda nepadangag ya naita da ikid na nadangag da ta mafulu takday turin ni Hesus kontodu kadwan kiden ituldu na. ");
INSERT INTO agt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","I Mariya taga Magdala, ikid ni Yohana, ikid ni Mariya nga hina ni Santiago, ikid na kadwan kiden sakā bābāy da, a yen kid ya umange nangibar ta turin kiden. ");
INSERT INTO agt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ammi aweda haman kinurug ya uhohug na bābāy kiden, te pahig da ta tulad. ");
INSERT INTO agt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ammi te Pedru a alistu imikkat, a bumilag ta agyan na tanamen. Datang na ta tanamen a simisirib ta umag, a naita na ya ga-gamit kiden nga nefutefut ta bari ni Hesusen, ammi awan ya bari na en. A sangaw nagtugut hapa nga dumatang ta bali na, te napopoyung hapa gafu ta awan na ya bari ni Hesus. ");
INSERT INTO agt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A ta araw na katolay ni Hesus a gimanwat hapa ya duwa na ituldu na ta ili na Herusalem, te ange kid ta iten Emawas, a kuman na mafulu takday kilumetru ya kadayu na. ");
INSERT INTO agt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","A nakatugtugut kid la nagbida, te bibidan da ya nakkwa te Hesus ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","A tekid para la nakatugtugut nagbida ikid na nagimpopohut a nepagka-ma da ya nakihebing tekid ta dalanen, ");
INSERT INTO agt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","a naita da ammi aweda nelasin am inya yen. ");
INSERT INTO agt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","“Anu hud ya kuga bidan muy ta pakatugtugut muy ta dalanin,” kunna tekid. A nagtayuk kid la ten nagdamdam. ");
INSERT INTO agt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Klopas ya ngagan na takdayen, a intu ya tumabbag ta nebar na tolayen. “Anu, iko la tatakday ya awan para la nakadangag ta iningwa da en ta ili na Herusalem ta takdayen araw?” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Anu hud ya iningwa da?” kunna hapa na tolayen tekid. “A ya iningwa da en te Hesus nga taga Nasaret,” kunda ha, “te amu haman na Namaratu ikid na ngamin tolay ta intu ya kasikanan na aglavun, te masikan ya ngamin tarabaku na ikid na uhohug na. ");
INSERT INTO agt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ammi kadulayan na te ya pinakadakal tam kiden a nepagafut da haman, a sangaw nedarum da ta taga Roma kiden nga mangibbal tekitam, petta papasin da, a pinagappa da ta kayu. ");
INSERT INTO agt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nekatalak mi ta intu ya mangikerutan tekitam nga Istralita, ammi awan na, te arawin yan haman ya mekatallu araw abat ta pasi na en. ");
INSERT INTO agt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Ammi kuman na nakagtut kami hapa gafu ta bida na kadwan kiden kahulun mi nga bābāy, te umange kid kan ta tanam na en ta nagkarawanen, ");
INSERT INTO agt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","a awan kan na ya bari na en. Ammi intu kan naita da ya anghel kiden na Namaratu, a nebar kan na anghelen ta natolay hala i Hesusen. ");
INSERT INTO agt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","A yen ta umange ya kadwan kiden kahulun mi nga lalaki ta tanam na en, petta pasikkalan da mina ya uhohug na bābāy kiden. A kustu kad ya uhohug da, te aweda kan naita ya bari na en,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","A ya uhohug hapa na tolayen tekid a, “Anu kuga makilavun kam? A anu hapa ya kabakka na nonot muy ta awemuy kurugan ya nesurat na aglavun kiden? ");
INSERT INTO agt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Te gagangay haman ta neattam na Mangikerutanen ya nepagpapasi da tentu kapye na hala matolay, petta mesaad ta pagariyan na,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A sangaw pake nepasikkal na tekid ya ngamin nesurat nig mina Moses ikid na aglavun kiden ta palungu na araw, a netuldu na tekid ya uhohug na aglavun kiden, te dana linavun da ya ngamin dumatang tentu ta awena en para la pakeanak. ");
INSERT INTO agt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","A sangaw nakaabikan kid na ta babali kiden nga datangan na duwa kiden, a kuman na magtalib mina ya tolayen, ");
INSERT INTO agt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ammi ginamman na duwa kiden. “Magyan ka la bit tekami te furab na, magge hiklam na,” kunda tentu. A gafu ta kumanen a sakā nehulun hapa tekid ta nagdulotan da en. ");
INSERT INTO agt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","A tekiden nagaatubang ta pamurab da a nangalap ya tolayen ta pan kapye na nepakimallak, a sangaw ginadgadwa na hapa ta duwa kiden. ");
INSERT INTO agt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","A ta nepangigawat na ta pan tekid a nagdakar ya mata da, a nelasin da ta intu hala i Hesus, ammi ta nepakaita da tentu a limitap hapa, a awedan naita. ");
INSERT INTO agt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","“Anggem ta kuman na naglampaw ya nonot ta tentu en naguhohug tekita ta dalanen ta nepagsaned na ta surat kiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","A gafu ta kumanen a imikkat kid ta namuraban da en, a nagtugut kid, te manoli kid na ta ili na Herusalem. A ta datang da ten a nadatangan da nagaammung ya mafulu takday ituldu ni Hesus ikid na kadwan kiden nedagga tekid. ");
INSERT INTO agt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","A tekiden simarok ta agyan na kahulun da kiden nagaammung a “O, matolay kad i Afu, a nakipaita kan te Simonin,” kun na nagaammung kiden tekid. ");
INSERT INTO agt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A yen hapa ya nepangibida na duwa kiden ta naita dan hapa ta dalanen; “A tentu en nanggadwa ta panen a naita min ta intu,” kunda. ");
INSERT INTO agt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","A tekid para la nagbabida a ka-ma la nakipaita i Hesus ta tātangngan da a nakikumusta hapa tekid, ");
INSERT INTO agt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ammi sa nakagtut kid ta talaw da tentu te pahig da ta datay. ");
INSERT INTO agt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","“Anu haman ta magtalaw kam? Kuman na awemuy ikayat mangurug ta matolayak. ");
INSERT INTO agt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Itan muy haman ya kamat ku kidin ikid na takkik kidin awa iyaken hala yan. Maski si-gedan dak petta amu muy, te awan haman ta bilsag ikid na tulang na datay ta kuman na barikin,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A pake nepaita na ya gafan na lansa kiden ta kamat na kiden ikid na takki na kiden. ");
INSERT INTO agt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","A matalak kid mina ta matolay, ammi intu nonotan da am had kunna matolay, a yen ta aweda para la pake kurugan. A gafu ta kumanen a nagadang i Hesus ta kanan na tekid; “Awan hud ta kanan muy sin? te manganak mina,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","A inatadan da mantu ta bilsag na ikan nga inasal da, ");
INSERT INTO agt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","a kinan na hapa ta nagaatubangan da. ");
INSERT INTO agt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A sangaw nagbida ha tekid, “Dana nebar ku haman tekamuy ta magdulot hala sangaw teyak ya ngamin kiden nabida da ta lebru na kansyon kiden ikid na surat kiden ni Moses ikid na aglavun kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","A pake netuldu na ya surat kiden tekid, petta maawatan da. ");
INSERT INTO agt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“Kumanen ya nesurat ta palungu araw petta amu muy mina ta mazigatan ikid na mapapasi ya Mangikerutanen tekamuy, kapye na matolay ta mekatallu na araw. ");
INSERT INTO agt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yaga nesurat da hapa ta mepadangag mina ya ngagan na en ta ngamin tolay, petta magbabawi kid mina ta liwat da, a pakoman na kid hapa na Namaratu. A mappya mantu ta yen ya ipadangag muy ta ili na Herusalem, kapye muy ipadangag ta ngamin kiden lugar abat ta ngamin paglelehutin. ");
INSERT INTO agt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","A ikamuy hapa ya makkamu mangipasikkal ta isin na damag, ");
INSERT INTO agt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","te doban ku hala sangaw ya Kahalwa na Namaratu tekamuy ta kuman na nekari ni Damaken tekamuy, petta mapasinapān kam ta kasikan na Kahalwa na en. Ammi mappya ta magyan kam la bit ta ili in yan nga magindag ta iange na,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","A ta nekabalin na en a pinohet na kid bit ni Hesus ta ili en. A tekid nakadatang ta ili na Betanya a neta-gay na ya kamat na kiden, a pinasinapan na kid. ");
INSERT INTO agt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","A tentu en nabalin nangpasinap tekid a yen hapa ya nepagtugut na en tekid, te timullu ta langit, ");
INSERT INTO agt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","a namalentud kid hapa nangdayaw tentu. A gafu ta kumanen a nagtugut kid hapa setalak, a nagtoli kid ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","A kanayun itta kid ta umag na simbaan na Hudyo kiden nga makimalmallak ikid na magdaydayaw ta Namaratu.");
INSERT INTO agt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","A ta kawan para la na ngamin kiden napadday a ittan ya naggitta ta Namaratu nga magngagan ta Uhohug, a itta la itta ta atubang na Namaratu ");
INSERT INTO agt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","abat ta gafgafu na ngamin. ");
INSERT INTO agt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Intu hapa la ya agpadday na Namaratu ta ngamin kiden napadday, te awan mina ta napadday am bakkan ta intu ya namadday tekid. A ya ngamin kiden seangat ");
INSERT INTO agt_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","a natolay kid gafu ta angat na en tekid. A ya angat na en ya kuman na zilag ta nonot na tolay kiden petta amu da ya kakurugan, ");
INSERT INTO agt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","te magyan kid la ta sugiram. A magdakar la magdakar ya zilagen ta agyan na sugiram, te awena magamma na sugiram. ");
INSERT INTO agt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","A ta tanagay pakipaita na zilagen ta paglelehuten a itta ya takday tolay nga dinob na Namaratu petta ange mangipasikkal ta zilagen. I Hwan ya ngagan na, ");
INSERT INTO agt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","a yen ta dinob na Namaratu nga ange manipasikkal, petta mangurug mina ya tolay kiden ta zilagen gafu ta pangipasikkal na. ");
INSERT INTO agt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bakkan ta intu nepasikkal ni Hwan ya bari na en hapa la, am awa zilagen nga kakurugan, ");
INSERT INTO agt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","te ye-yen na zilag ya magpadakar ta ngamin tolay, a tanagay na lumattog ta paglelehuten. ");
INSERT INTO agt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ammi dana ittan ta paglelehutin, te intu haman ya namaddayen ta ngamin, kontodu tolay kiden. Ammi maski kunna ten a aweda haman amu ya namaddayen tekid. ");
INSERT INTO agt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A tentu en dumatang ta agyan na tolay na kiden a aweda haman pinagdulot. ");
INSERT INTO agt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ammi ya kadwan kiden nga nagpadulot tentu a yen kid ya pinagbalin na Namaratu ta ānāk na kiden gafu ta pangikatalak da tentu, ");
INSERT INTO agt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","te nangurug kid ta intu ya nepeanak na Namaratu petta megitta ta tolay. A bakkan mantu ta daga na tolay ikid na uray na tolay ya gafu na nekeanak na. ");
INSERT INTO agt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A gafu ta kumanen a nagbalin ta tolay ya nagngagan ta Uhohug, a nakipagyan tekitam tolay nga malalaki nangikallak ikid na mangituldu ta kakurugan. Naita mi mantu ya kalalaki na, a yen ya nangilasinan mi ta intu ya Anak na Namaratu ewan, te itta ya kalalaki na nga negitta ta kalalaki na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","A intu hala en ya netuldu ni Hwan ta tolay kiden, te ya pake neayag na tekid a “Ye ye-yan ya nabidaken tekamuy nga umange sangaw ta gafan ku, te pumatalin sangaw teyak. A pake atata-nang ammi teyak, te dana ittan ta aweken para la nekeanak”, kunna. ");
INSERT INTO agt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","A gafu ta pake dakal ya allak na tekitam tolay a sa napasinapan kitam ta addu na bendisyon nga nagafu tentu, te daggan na la daggan ya allak na tekitam. ");
INSERT INTO agt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ta idi a amu tam ya uray na Namarrtu gafu ta lintig na kiden nga nesirak na te mina Moses. Ammi ta ayanin a amu tam ya allak na tekitam ikid na ngamin kakurugan gafu ta ange ni Hesus Kristu. ");
INSERT INTO agt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Te addet ta ayanin a awan pulus ta tolay nga nakaita ta Namaratu ewan, ammi ya mementu en anak na nga negitta tentu a intu ya nangipakamu ta Dama na ewan tekitam, te pake abikan tentu. ");
INSERT INTO agt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A gafu ta pangipadangag ni Hwan a nangidob hapa ya Hudyo kiden taga Herusalem ta kadwan kiden padi da ikid na kauffunan da kiden nga magLebi, petta imbestigaran da i Hwan. A ya uhohug da tentu a “Ikayat mi damagan am anu ya katolay mu, iko de ya Mangikerutan nga dana nebar na Namaratu ewan?” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","A awena nelemad, te pake nebar na ta “Bakkan ta iyak ya Mangikerutan,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“A anu mantu ya katolay mu? Iko de i mina Eliyasen nga magtoli kan ta lutakin,” kunda ha. A “Bakkan,” kunna hapa. “A iko mantu de ya takdayen paguhohugan na Namaratu nga nebar ni mina Moses?” kunda, a “Bakkan,” kunna ha. ");
INSERT INTO agt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“A ibar mu mantu am inya ka, petta itta ya itabbag mi ta nangidob kiden tekami. Anu hud ya katolay mu?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","“Ta kuman na nesurat ni mina Isayasen a iyak ya makangahal nga magayayag ta tolay kiden, ‘Patunungan muy ya dalan nga adayu ta ili, petta meparan ta iange na Dafu tamen,’” kunna. ");
INSERT INTO agt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A ya kadwan kiden nedob tentu a Pariseyu kid. ");
INSERT INTO agt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","A ya pohut da en hapa tentu a “Am bakkan ta iko ya Mangikerutan, ikid na Eliyas, ikid na paguhohugan na Namaratu nga binida ni mina Moses a anu kawagan na mantu ta mangzigut ka ta tolay kidin?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","A ya tabbag ni Hwan a “Iyak ya mangzigut tekamuy ta danum, petta meparan kam mina ta angen na awemuy para la amu. ");
INSERT INTO agt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Intu hala ya kinan ken nga pumatalin teyak. A awek hapa megitta nga makitagabu tentu, te pake atata-nang ammi teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","A nakkwa ye-yen ta lugar na Betanya ta dammang na karayan na Hurdan, te yen ya nangzigutan ni Hwan ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","A ta pagtalib na araw a naita ni Hwan i Hesus nga umab-abikan tentu, a netuldu na hapa ta tolay kiden; “Itan muy, ye-yan na tolay ya iatang na Namaratu ta kuman na kalneru muy kiden, te intu hala sangaw mangikaru ta liwat na ngamin tolay ta paglelehutin. ");
INSERT INTO agt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","A intu hala ya nabidaken tekamuy, te ‘Itta sangaw ya umange ta gafan ku nga pumatalin teyak. A pake atata-nang ammi teyak, te dana ittan ta aweken para la nekeanak,’ kunku. ");
INSERT INTO agt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ammi ta kuman na iyak ta idi a awek para la pake amu ya pumatalinen teyak, ammi immange yak ta isin nga mangzigut ta tolay kidin nga Istralita, te iparan ku kid ta ange na, petta am ittan a amu da sangaw,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","A pake nepasikkal para ni Hwan ya naita na, “Naitak ya Kahalwa na Namaratu nga umakban tentu ta nepangzigut ku tentu, te nagafu haman ta langitewan ta kuman na pagsunak na kalapati, a nagintak la tentu. ");
INSERT INTO agt_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","A awek mina amu ta intu ya Mangikerutan nga dana nebar na Namaratu ta dadagkal tam kiden, ammi nanonot ku ya uhohug na Namaratu ta pangidob na en teyak, te ya nebar na a ‘Maitam sangaw ya takday tolay nga pagintakān na Kahalwakin, a intu sangaw ya mangpasinap ta tolay kiden ta Kahalwa na Namaratu,’ kunna teyak. ");
INSERT INTO agt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","A gafu ta naitak ya nebar na en teyak a napasikkal kun ta intu hala ya Anak na Namaratu ewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","A ta pagtalib ha na araw a gitayukan la ig Hwan ikid na duwa na ituldu na kiden, ");
INSERT INTO agt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","a naita na i Hesus ta pagtalib na en tekid, a netuldu na tekid. “Yo ewan ya Kalneru na Namaratu nga mesagapil sangaw ta tolay kiden,” kunna ta kahebing na kiden. ");
INSERT INTO agt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","A ta pakadangag na duwa kiden ta nebar na en a nagtugutan da i Hwan, te dumagdag kid na te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","A ta nepaglipay ni Hesus a naita na ya duwa kiden dumagdag tentu, a kinabida na kid. “Itta de ya ikayat muy teyak?” kunna tekid. “Mistro, ikayat mi la dangagan am had ya pagyanam,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“A mehulun kanan mantu petta itan muy,” kunna hapa. A nehulun kid mantu tentu, a naita da ya pagyanan na, a nagammak kid hapa tentu, te kuman na alas kwatro ta furab. ");
INSERT INTO agt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andres ya ngagan na takday na duwa kiden, a itta hapa ya kabagis na en Simon, ammi Pedru ya agngilinan da tentu. ");
INSERT INTO agt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A enna mantu inapag ni Andres. A ta nepakaapag na tentu a “O, Simon, ittan hala ya Messayasen nga dana nebar na Namaratu tekitam, te nesimmun min,” kunna. (Ya ikayat na uhohugan na “Messayas” nga kinan na, a “Mangikerutan”.) ");
INSERT INTO agt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A enna mantu netulud i Simon ta agyan ni Hesus. A pake aitan na bit ni Hesus kapye na kinabida. “Iko mantu i Simon nga anak ni Hwan, ammi magngagan ka sangaw te Sepas,” kunna. (A ya ngagan na en Sepas a intu hala Pedru ta aguhohug na Giregu, ammi ya ikayat na uhohugan tekitam a “Batu”.) ");
INSERT INTO agt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A ta pagtalib ha na araw a nakanonot i Hesus nga ange ta lugar na Galileya, a nesimmun na hapa i Felipe ta dalan. A inagagay ni Hesus petta dumagdag tentu. ");
INSERT INTO agt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Intu lugar ni Felipe ya ili na Betsayda ta lugar na Galileya, a yen hapa ya nagafun ni Andres ikid ni Pedru. ");
INSERT INTO agt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","A sangaw enna inapag ni Felipe i Natanyel. “O Natanyel, ittan hala ya Messayasen nga binida nig mina Moses ta lintig na kiden ikid na aglavun kiden na Namaratu ta surat da kiden, te naita min. Intu hala i Hesus taga ili na Nasaret, a anak hapa ni Hose en,” kunna te Natanyel. ");
INSERT INTO agt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ammi ya tabbag ni Natanyel a “Taga Nasaret? Itta hud ya nagafu ten nga kappyanan tam?” kunna. “A em la itan,” kunna ha ni Felipe tentu. ");
INSERT INTO agt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","A ta nepakaita ni Hesus teg Natanyel nga umab-abikan tentu a “Itta mantu in ya Istralita nga kakurugan; awan kad ta pakaladdudan na,” kun ni Hesus te Natanyel. ");
INSERT INTO agt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","“Anu hud ya pakkamum teyak?” kunna hapa. “On, te ta awena para la nepagayag ni Felipe teko a dana naita ta ka ta balimen nga imatuttud ta addun na kayu na higos,” kunna ha ni Hesus. ");
INSERT INTO agt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Ay, Afu, kakurugan mantu ta iko ya Anak na Namaratu ewan, talaga ta iko ya Ari na Istralita kiden nga indagan mi,” kunna hapa tentu. ");
INSERT INTO agt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","A ya tabbag ni Hesus tentu a “Anu? Alistu kan de mangurug gafu ta inuhohug ken la teko nga naita ta ka ta addun na kayu na higos? Pake dakdakal sangaw ya maitam ammi ta isin. ");
INSERT INTO agt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A ya pake ibar ku tekamuy ngamin a maita muy sangaw ta nahukatan na ya langitewan gafu ta Tolayin Taga Langit, te iyak hapa la ya addanen nga tinarinap ni mina Hakoben nga imunekan na anghel kiden ta agyan na Namaratu, ikid na dimagutan da ta lutakin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A ta nepagpasa na dwangagaw itta ya boda ta ili na Kana ta lugar na Galileya. Dana ittan ten ya hina ni Hesus, ");
INSERT INTO agt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","a sangaw nagawi hapa ig Hesus ikid na ituldu na kiden ta boda en. ");
INSERT INTO agt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","A ta nekaafut na inuman na nakibodan kiden a umange ya hina ni Hesus tentu, a nebar na, “Aleng, manguffun ka haen, te awan na ta inuman da nga binarayang,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“Mappya, Ina, ta awenak la ituldu ta tarabakuk, te awan hud para ya araw na pakkamuk ta patarabaku ni Damakewan teyak?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A gafu ta kumanen umange maguhohug i hina na en ta tagabu kiden nga mangiparan ta kanan, “Am itta ya ibar na sangaw tekamuy a kwan muy la,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A dana netabnak da ten ya annam na angāng nga magserbi ta Hudyo kiden ta pangbaggaw da. A ya makarga na tagtakday a dwafulu na galon, ammi ta kadwan a tallufulu na galon. ");
INSERT INTO agt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","A ya uhohug ni Hesus ta tagabu kiden a “Pannun muy ya angāng kidina ta danum,” kunna, a pinannu da kid abat ta bibig da. ");
INSERT INTO agt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","“Aran, takday tekamuy ya magsiruk, te em bit pakakkap ta dafu na boda in,” kunna ha ni Hesus. A ta nepagsiruk na takday a enna nepakakkap. ");
INSERT INTO agt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","A ta nepakakakkap na dafu na boda en a kuman na basi na uba, te nagbalin ya danumen ta basi. Ammi awena amu am had ya nagafun na, te intu la nakkamu ya nangiparan kiden. A gafu ta kumanen a inayagan na ya lalaki en magboda, te pahig na ta intu ya nangiuhet ta basi en. ");
INSERT INTO agt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Anu haman ta neappiyam ya mappya en basi abat ta ayanin? Te gagangay ta meunnan bit mina ya mappya en, a sangaw am nakainum na ya tolay kiden a yen mina ya pangiuhet muy ta matabeng,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","A ye-yen ya napolu en pakaitan nga nehuga ni Hesus ta neange na en ta ili na Kana ta lugar na Galileya, petta maita da ya pakapangwa na. A pake nangurug na hapa ya ituldu na kiden tentu. ");
INSERT INTO agt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","A ta kabalinan na boda en a nagtatugut ig Hesus kontodu hina na, ikid na wāgi na kiden, ikid na ituldu na kiden, te kumin kid ta ili na Kapernayum, a yen bit la ya nagyanan da ta mangananwan. ");
INSERT INTO agt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","A sangaw tanagay na hapa ya Pyesta na Simana na Hudyo kiden ta ili na Herusalem, a umange hapa ig Hesus. ");
INSERT INTO agt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","A ta datang da ta ili en a simarok hapa i Hesus ta nagingumag na bagaw na simbaanen, a neddatangan na ya addu na maglaku ta baka ikid na kalneru ikid na kalapati, te yen kid ya iatang na tolay kiden ta simbaanen. A itta hapa ya magitali kiden ta pirak nga gitogkokan ta nagitalin da. ");
INSERT INTO agt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","A nangalap mantu i Hesus ta lubid kapye na pinadday ta pagpaligat na, a yen ya nepangpohet na tekid ngamin ta bagaw na simbaanen kontodu ilaku da kiden. A pinagsikig na para ya lamesa na nagitali kiden ta pirak petta meburud ya pirak da kiden. ");
INSERT INTO agt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A ya uhohug na ta naglaku kiden ta kalapati a “Iuhet muy yeyan kid, te awemuy la igitta ya bali ni Damakewan ta kuman na aglakun,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","A gafu ta poray na en ta naglaku kiden a yen ya nakanonotan na ituldu na kiden ta takday uhohug nga dana nesurat ta Bibliya na Hudyo kiden, te ya uhohug na suraten a “Pekavut nak sangaw, Afu, na pangahuguk ta balimen,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ammi ya uhohug na pinakadakal na Hudyo kiden tentu a “Itta hud ya mabalim nga neatad na Namaratu ta tinarabakum ta isin? Am kumanin ya kwam a itan mi mantu ya pakapangwam petta mepasikkal hala ya mabalim ta isin,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","A ya tabbag na hapa tekid a “Maski am perdin muy ye-yan na bali na Namaratu a patayukan ku hala sangaw ta las-ud na talluhaw,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“A had kukum hud mapatayuk ta talluhaw, bakawa appatafulu annam na darun ya nepakapatayuk na ta idi?” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ammi takwan ya ikayat na uhohugan ni Hesus, te ya kinan na en bali a bari na en hapa la, te kurug ta pinapasi da, ");
INSERT INTO agt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ammi natolay hala ta mekatallu na araw. A yen hapa ya nepakanonot na ituldu na kiden ta isin na uhohug ni Hesus ta umag na simbaanen. A yen ya nangurugan da ta intu hala ya nebida ta Bibliya na Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","A ta ketta para la ni Hesus ta ili na Herusalem ta Pyesta en a nangurug kan ya addu na tolay tentu gafu ta naita da ya pakapangwa na nga nehuga na ta kadwan kiden tolay. ");
INSERT INTO agt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ammi te Hesus, a awena nekatalak ya nangurug tentu, te dana amu na ya nonot da. ");
INSERT INTO agt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","A maski awan ta mangibar tentu ta tolay a dana amu na hala ya ngamin kiden nonot na tolay. ");
INSERT INTO agt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","A itta hapa ten ya takday laklakay nga nagngagan ta Nikodemu, a intu hapa ya takday Pariseyu nga pinakadakal na Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","A umange hapa ya laklakayen ta agyan ni Hesus ta hiklam, te makibida tentu. A ya nebar na a “Mistro, amu mi ta iko ya mangituldu nga dinob na Namaratu ewan, te awan mina ta pakapangwam ta kuman na naita mi en teko am bakkan ta Namaratu ya manguffun teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ammi tinabtabang ni Hesus ya paguhohug na, “Pake ibar ku teko ta awan sangaw ta mesipat ta pangikerutan na Namaratu ewan am awena bit mauli meanak,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Asakay, had kukunna meanak na tolay am laklakay na? Makatoli hud para ta sirat na hina na en petta mapidwa meanak?” kunna hapa ni Nikodemu tentu. ");
INSERT INTO agt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","A ya tabbag ha ni Hesus a “Pake ibar ku hala teko ta awan pulus ta mesipat ta pangikerutan na Namaratu ewan am awena bit mauli meanak gafu ta pakapangwa na Kahalwa na Namaratu ta pagzigut na ta danum. ");
INSERT INTO agt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Te ya neanak na tolay a mesigud la tentu ya gagangay na tolay, ammi ya nauli neanak ta pakapangwa na Kahalwa na Namaratu a megitta hapa ta gagangay na Kahalwa en. ");
INSERT INTO agt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","A awem mina pahig am had kukunna makkwa na nebar ken teko nga mauli ka mina meanak, te intu mina pagnonotam ya angarigan na paddad. ");
INSERT INTO agt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Te ya gagangay na paddad a ange hala ta gagangay eyan na, a awem amu am had ya namegafwanan na ikid na pagdulotan na, ammi madangag mu hala. A kumanen hapa ta tolayen nga nauli neanak ta pakapangwa na Kahalwa na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Onay, ammi awek para manonot am had kukunna makkwa,” kunna hapa ni Nikodemu. ");
INSERT INTO agt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","A ya uhohug ha ni Hesus tentu a “Anu iko haman ya kadakalanen na mangituldu nga Istralita, a awem amu ya inuhohug ken teko? ");
INSERT INTO agt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pake ibar ku ha teko ta intu la bidan mi tekamuy ya amu mi ikid na naita mi, ammi awemuy haman dangdangagan ya pasikkal mi tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","A am awemuy la kurugan ya nabidak tekamuy nga malogon maita ta lutakin a had kukummuy mantu mangurug am intu sangaw bidan ku tekamuy ya awemuy maita ta langitewan? ");
INSERT INTO agt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","A gafu ta awan ta nakaange ta langitewan ikid na nakaita ta makkwa ten a awan mantu ta takwan na makabida ta makkwa ten am bakkan la ta nagafu en ta langit. A intu hala ya Tolayin Taga Langit, ");
INSERT INTO agt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ammi mappya ta mebesin hapa sangaw ta kayu ta kuman na sinang ulagen nga nebesin ni mina Mosesen ta kayu ta agyan na kalafukanen, ");
INSERT INTO agt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","petta maski am inya sangaw ya mangikatalak tentu a maatadan sangaw ta magnayun na angat gafu tentu.” kunna. ");
INSERT INTO agt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","A kakurugan ta dakal ya idduk na Namaratu ewan ta ngamin kiden tolay ta paglelehutin, te netuluk na ta masi ya mementu en anak na gafu ta liwat tam kiden, petta am ikatalak tam a awetam sangaw melogot am awa maatadan kitam hud la ta magnayun na angat. ");
INSERT INTO agt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","A bakkan mantu ta yen ya nepangidob na ta Anak na petta ipasikkal na ya pama-gang na ta tolay kiden, am awa petta mekerutan kid hud la gafu ta pasi na Anak na en. ");
INSERT INTO agt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","A maski am inya mantu ya mangikatalak tentu a awena sangaw medarum ta atubang na Namaratu ewan, ammi ta awanen mangikatalak tentu a dana nekari ya pakedarum na, gafu ta awena haman nekatalak ya mementu en Anak na. ");
INSERT INTO agt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A yen ya gafu na pakedaruman na tolay te lumattog na ya negitta en ta zilag nga mangpadakar ta nonot na tolay kiden, ammi nekatupag da haman, te pake nekayat da hud la ya sugiram ammi ta dakaren, te dulay haman ya tarabaku da. ");
INSERT INTO agt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Te ya ngamin kiden mangwa ta dulay a ikatupag da ya dakar, a palanan da la, te aweda ikayat ta maita ya tarabakun da talo am mapaliwatan ya nonot da. ");
INSERT INTO agt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ammi ya mangwa ta katunungan a sarukusukan na la ya dakar, petta mepasikkal ya pangurug na ta pakkwa na Namaratu tentu. ");
INSERT INTO agt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","A ta nekabalin nig Hesus ikid ni Nikodemu nga nagbida a nagtugut ig Hesus ikid na ituldu na kiden, te umange kid ta kadwan kiden babali ta lugar na Hudeya. A medyo nabayag kid hapa ten nga mangzigut ta nagbabawi kiden ta liwat da. ");
INSERT INTO agt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Ammi te Hwan, ta awena en para la nekebalud, a itta para la ta iten Enon nga abikan ta Salim, te nangzigut ta umange kiden tentu, te alawa hapa ya danum ten. ");
INSERT INTO agt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","A sangaw itta ya takday Hudyo nga nakidibati ta ituldu kiden ni Hwan, te intu nakidibatin da am had sin ya mapmappya ta pangzigut ni Hwan ikid nig Hesus. ");
INSERT INTO agt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","A yen ta nagtoli ya ituldu na kiden tentu, te pohutan da hapa tentu. “Mistro,” kunda te Hwan, “Anu hud ya uray mu ta umangen nagpazigut teko ta dammang na Karayan na Hurdan? Iko paen ya nangipasikkal tentu, a ta ayanin intun ya mangzigut, a intu hapa ya eyan na ngamin tolay,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A ya tabbag ni Hwan tekid a “Bay-an muy la, te bakkan mina ta intu ya eyan na tolay kiden am awena uray na Namaratu. ");
INSERT INTO agt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ikamuy haman ya nakadangag ta inuhohug ken, te ‘Bakkan la ta iyak ya Mangikerutan,’ kunku haman, te iyak la ya pinapolu na Namaratu nga ange nangipadangag tentu. ");
INSERT INTO agt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A intu mina pagnonotan muy ya keangarigan na magboda, te ya lalaki en ya ange mangalap ta babbayen. Ammi ya kahulun na en nga nangpili ta atawa na a indagan na la ya pangdayaw na lalaki en ta atawa na en, a pake matalakan hapa am madangag na. A kumanen hapa teyak, te nagdulot na ya talak ku, ");
INSERT INTO agt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","te mappya ta intu ya imutun a iyak ya imakban,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","A ya taga langit ewan ya pake seturay ammi ta ngamin, ammi ya taga lutakin a intu la amu na bidan ya makkwa ta lutakin, te nafukuk ta lutakin. Ya taga langitewan mantu ya pake atata-nang ammi ta ngamin, ");
INSERT INTO agt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","a intu bidan na ya naita na ikid na nadangag na ta Namaratu ewan. Ammi maski kunna ten a kuman na awan ta mangurug ta ipadangag na. ");
INSERT INTO agt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ammi am itta ya mangurug tentu a ipasikkal na ta kakurugan ya Namaratu ewan, ");
INSERT INTO agt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","te ya taga langitewan nga dinob na Namaratu a iuhohug na ya uhohug na Namaratu, te awan ta kurang na Kahalwa na Namaratu tentu. ");
INSERT INTO agt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Namaratu hapa la ya Dama na dinob na en, a pake iddukan na, te Anak na. A pinatudunan na petta intu hala ya makkamu ta ngamin. ");
INSERT INTO agt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","A ya mangurug mantu ta Anak na Namaratu ewan a ittan ya angat na nga magnayun. Ammi ya awanen mangurug ta Anak na a awena sangaw mesipat ta angat na, te itta para la ya pagporay na Namaratu tentu. ");
INSERT INTO agt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","A ta pagyan nig Hesus ta agyan na Hudeya, a pake imaddun ya umange te Hesus ammi ta umange kiden te Hwan. A ya Pariseyo kiden nga nakitapil te Hwan a nadamag da ta ad-addu ya zinigut nig Hesus ammi te Hwan, a malalang kid. ");
INSERT INTO agt_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ammi bakkan te Hesus ya nangzigut ta umange kiden tentu am awa ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","A gafu ta Pariseyo kiden a nagganwat nig Hesus ta lugar na Hudeya a nagtoli kid a lugar na Galileya, ");
INSERT INTO agt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ammi mappya ta angen da ya lutak na Samariya. ");
INSERT INTO agt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","A nakatugtugut kid la nakatugtugut addet ta pingit na ili na Sikar, a nagimmang kid na ta bikat na lutaken nga neatad ni mina Hakob ta anak na en Hose ta palungu na araw. ");
INSERT INTO agt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A gafu ta nabannag na i Hesus ta inange da en, te tangnganan na araw hapa, a nagibannag hapa ta bibig na huhunen nga kinali ni mina Hakoben. ");
INSERT INTO agt_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","A ta pagibannag ni Hesus a nagdulot hala ya ituldu na kiden ta umag na ili petta gumatang kid ta kanan da. A ta kawan da para la a itta ya babbay nga taga Samariya nga umange nanagab ta huhunen. A ya uhohug ni Hesus tentu a “Ikwa nak haen ta danumina,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ammi nagpaka-lat ya babbayen ta uhohug ni Hesus, a “Anum hud magadang ta danum teyak, bakawa Hudyo ka, a Samariyano yak nga babbay?” kunna. Te ya gagangay kan na Hudyo kiden a aweda kan uminum ta paginumān na Samariyano. ");
INSERT INTO agt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","A ya tabbag ni Hesus hapa a “Awem garay amu ta itta ya iatad na Namaratu ewan teko, a awem amu am inya ya nagadang teko ta inuman, te am amu nak mina a iyak mina ya nagadangam ta inumam, a inatadan ta ka mina ta matolay na danum,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Awan haman ta pagsiruk mu, Ser, ta huhunin, yaga pake naumag ya danum na in. A had kukum mantu makaalap ta matolay na danum nga iatad mu teyak? ");
INSERT INTO agt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Dakdakal hud ya amum ammi te mina Hakoben nga nangisirak ta huhunin tekami, te maski intu hapa ya kanayun imminum ta danum na in, kontodu anak na kiden ikid na ayam na kiden,” kunna ha na babbayen. ");
INSERT INTO agt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","A ya uhohug ha ni Hesus tentu a “Onay, ammi gumtang hala sangaw ya ngamin kiden uminum ta isin na danum. ");
INSERT INTO agt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ammi ya uminum ta iatad kin na danum a awena sangaw gumtang, te ya danumin nga iatad ku a magbalin sangaw ta kuman na huhun ta umag na en, a kuman na sigida tumuhayuk tentu petta magnayun ya angat na,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“A atadan nak mantu, Ser, ta kinamina danum, petta awek na sangaw gumtang ikid na ange managab ta isin,” kun na babbayen. ");
INSERT INTO agt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“A em bit ayagan ya atawamen, te dumatang kanan sangaw ta isin,” kunna hapa ni Hesus. ");
INSERT INTO agt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Ay awanak haman ta atawa,” kunna ha. Ammi ya uhohug ni Hesus tentu a “Kustu ya uhohug men ta awan ka ta atawa, ");
INSERT INTO agt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","te nakigungay kan haman ta lima na atawa, a bakkan hapa ta atawam ya pakidaggam ta ayanin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A gafu ta nagpaka-lat ya babbayen ta uhohug ni Hesus a takwan ha ya nebar na; “Ser, ya kuman na mariknak teko a iko hala ya takday aglavun nga paguhohugan na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","A itta mantu ya damagan ku teko, te ya gagangay na gingginafu mi kiden ta pangdayaw da ta Namaratu a kanayun nakigimung kid kan ta bagetayewan. Ammi ya kagittam kiden nga Hudyo a ibar da ta awan mina ta takwan na pangdayawan tam tentu am bakkan ta ili na Herusalem. A had sin mantu ya kakurugan na pangdayawan tam?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","22","A kunna sin hapa ya tabbag ni Hesus ta nebar na en: “Mappya, Aboy, ta kurugam ya uhohug ku teko, te ikamuy Samariyano a dayawan muy hala ya Namaratu, ammi awemuy pake amu ya dayawan muy. Ammi ikami Hudyo a amu mi ya dayawan mi, te ikami ya nangipakkamun na Namaratu ta mangikerutan ta ngamin tolay. A yen ta ibar ku teko ta mauli sangaw ya pangdayaw muy, te bakkan la sangaw ta bagetayewan ono ili na Herusalem ya pangdayawan muy ta Namaratu. ");
INSERT INTO agt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Te ya kakurugan na mangdayaw a dayawan na ya Namaratu ta nonot na hapa la ta kakurugan na pangdayaw, te yen ya apagan na Namaratu ta mangdayaw tentu. ");
INSERT INTO agt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Te ya kasasaad na Namaratu a awem maita, te kuman na paddad. A mappya mantu ta dayawan muy ta kakurugan ta nonot muy hapa la,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A ya uhohug na babbayen hapa a “Intu la amuk ta ange sangaw ya kinan da en Kristu Mangikerutan, a intu sangaw ya mangipakamu ta ngamin tekitam,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","“Intu hala ya makiuhohugan teko, Aboy, te iyak haman yen,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","A ta paguhohug na para la ta babbayen a nagtoli hapa ya ituldu na kiden, a nalangga kid hapa tentu gafu ta kabida na ya babbay, ammi aweda pinohutan tentu am anu ya bidan da ikid na ikayat na ta babbayen. ");
INSERT INTO agt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A yen hapa ya nepangiwagak na babbayen ta kalamba na en nga netabnak ta huhunen, te alistu nagtoli ta umag na ili, a nagayayag na ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“E kanan sin, e kanan sin, te emmuy itan ya tolay nga nangibar ta ngamin kiden iningwak. Intu de ya Mangikerutanen nga linavun na popolu kiden aglavun,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","A matutunudan kid na mantu imuhet ta ili en nga dumadayum te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A ta ang-ange para la na tolay kiden te Hesus a agagayan na ituldu na kiden, petta mangan ta inalap da en ta ili. “E ka sin, Mistro, te mangan kitanan,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ammi ya tabbag na en hapa tekid a “Itta in ya kanan ku nga awemuy amu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","A yen ta nagimpopohut kid na. “Itta hud ya nangitulud ta kanan na?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A gafu ta kumanen a nepasikkal ni Hesus ya ikayat na uhohugan tekid; “Intu hala kanan ku ya pangidulot ku ta ikayat na nangidoben teyak petta ibalin ku ya patarabaku na en teyak. ");
INSERT INTO agt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ikamuy ya mangibar ta itta para la ya appat na hulan kapye na idatang na aggagatab. Ammi ya ibar ku tekamuy a maglipay kanan, te maita muy hapa ya takwan na agtalunan, a nalutun hapa ya kuman na dawa da kiden te makigatab na. ");
INSERT INTO agt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ya ange maggatab ta isin na aggataban a magatab na ya magbalin ta magnayun na angat. A takwan hapa ya tandan na, te matalakan sangaw mehulun ta nagmula en gafu ta pangisaned da ta magnayun na angat. ");
INSERT INTO agt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","38","A iyak paen ya nangidob tekamuy petta maggatab kam ta awemuyen nagbannagan, te takwan ya nagbanbannag. Ammi ikamuy hapa ya mesipat ta nagbanbannagan da. A yen hapa ya nagdulotan na dana en bida nga ‘Takday ya magmula, a takwan ya maggatab,’ kunna.” ");
INSERT INTO agt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A ya Samariyano kiden nga taga ili na Sikar a addu kid hapa nangurug te Hesus gafu ta bida na babbayen, te, “Nebar na haman teyak ya ngamin kiden iningwak,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","A ta datang da mantu te Hesus a inagagay da petta magdulot ta babali da kiden, a pa nagyan mantu i Hesus tekid abat ta dwangagaw. ");
INSERT INTO agt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","A imaddu para ya mangurug tentu gafu ta nepadangag na en tekid. ");
INSERT INTO agt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A ya uhohug da hapa ta babbayen a “Dana nangurug kami gafu ta uhohug mu tekami, ammi ta ayanin a mismo tekami ya nakadangag tentu a pake gustu ya amu mi ta intu ya Mangikerutan ta ngamin tolay,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","A ta nepagpasa na dwangagaw a sa nagtatugut ha ig Hesus ikid na ituldu na kiden, te dumatang kid na ta lugar da en ten Galileya. ");
INSERT INTO agt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ta idi a nepapilit ni Hesus ta madaydayawan ya aglavun ta ngamin kiden lugar fwera la ta agyan na en hapa la. ");
INSERT INTO agt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ammi tentu en dimmatang ta lugar na en Galileya a pinagdulot na hala na kalugaran na kiden, te naita da ya ngamin kiden tinarabaku na ta ili na Herusalem, te umange kid hapa ta pyesta en ten. ");
INSERT INTO agt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","A sangaw nagdulot ig Hesus ta ili na Kana. Yen hala ya lugar na boda en tentu en nangihuga ta danumen petta nagbalin ta basi. A ta datang da ta ili na Kana a itta hapa ya takday opisyal nga nagtakit ya anak na ta ili na Kapernayum. ");
INSERT INTO agt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","A tentu en nakadangag ta dumatang na i Hesus nga nagafu ten Hudeya a umange hapa nakikekallak tentu, petta enna mina pagmappyan ya anak na en, te tagtakday na ya angat na. ");
INSERT INTO agt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","A ya uhohug ni Hesus tentu “A te awemuy ikayat mangurug teyak am awan ta ipaitak ta pakapangwak tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ammi pake persan na para na lalaki en; “Ser, em haen itan ya anak ken petta awena sangaw masi,” kunna te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","“Dumatang kan mantu ta balim, te matolay hala ya anak men,” kun ni Hesus tentu. Kinurug na ya uhohug ni Hesus tentu, a sangaw nagtugut kumin ta bali na. ");
INSERT INTO agt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A tentu en para la ta dalan a nesimmun na hala ya tagabu na kiden nga umange nangdafung tentu, a nebar da hapa ya anak na en; “Matolay hala ya anak men,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","“A kanu hud na oras ya nepagmappya na?” kunna hapa tekid. “A ala una ta furaben ya nepagkamag na patu na en,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","A nanonot na hapa ta ye-yen na oras ya nepangibar ni Hesus tentu ta matolay hala ya anak na en. A yen ta pake netug na ya pangurug na, kumanen hapa ta ngamin kiden makipagyan tentu. ");
INSERT INTO agt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","A ye-yen mantu ya mekaduwa na pakaitan nga nehuga ni Hesus tentu en dimmatang ta lugar na Galileya nga nagafu ta Hudeya. ");
INSERT INTO agt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","A ta nepagpasan na piga na araw a itta ha ya pyesta na Hudyo kiden, a umange hapa i Hesus nakipyesta ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A ta hebing na kinan da en ‘Sasarokan na Kalneru’ ta ili en a itta ya takday agzigutan na tolay kiden nga nalehutan ta lima na pagsigongan, a Betsata ya ngagan na ta agsitang na Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A ta agyan na pagsigongan kiden a giiddan ya addu na nagtatākit, te itta ya nagdaram, ikid na pilay, ikid na awan nakahehit. A indagan da kan ya paghehit na danumen, ");
INSERT INTO agt_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","te itta kan ya anghel na Namaratu nga umange la umange mangpahehit ta danumen. A ya imunnanen kan nga sumabbung ta nepaghehit na danumen a yen kan ya magmappya ta takit na. ");
INSERT INTO agt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A itta hapa ya takday lalaki nga nekihu ta nagtatākit kiden, te nabayag na nagtakit hapa abat ta tallufulu walu na darun. ");
INSERT INTO agt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","A ta pagtalib ni Hesus a naita na ya lalaki en, a nadamag na ta nabayag na imaidda ta takit na en. “Ikayat mu hud magmappya?” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","“A onay, Ser,” kunna hapa, “ammi awan haman ta manguffun teyak, petta ibilag nak mina ta agzigutanen am maghehit ya danumen. Te am ang-ange yak para la tatakday a takwan haman ya imunnan teyak nga dumagut ta danumen,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","“Magtayuk kan mantu, a alapam hapa ya dapamina, a magtugut kan,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","A ka-ma la nagmappyan, a inalap na mantu ya dapan na en, kapye na nagtugut. ");
INSERT INTO agt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","A gafu ta araw na agimmang ya nepagmappya na lalaki en a ginamman na Hudyo kiden ya pangagtu na ta dapan na. “Arawin haman ya agimmang tam a mehangat ya pangagtum ta dapamina,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","“Onay, ammi ya nangpamappya en teyak ya nangpaalap teyak,” kunna tekid, te “‘Alapam ya dapamina a magtugut kan,’ kunna haman teyak,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“A inya mantu ya nangibar teko ta pangalap mu ta dapam ikid na pagtugut mu?” kunda ha. ");
INSERT INTO agt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ammi intu dulay, te awena amu ya ngagan na nangpamappya en tentu, te dana nagtugut na i Hesus gafu ta kaddun na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","A sangaw ha ta mittan a nesimmun ni Hesus ya lalaki en ta umag na dakalen simbaan, a “Itam, nagmappya kan. Awem na sangaw magliwat talo am datangan na ka sangaw na pake dulay ammi ta takit men,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","A nagtugut ya lalaki en, a enna nepadamag ya ngagan ni Hesus ta Hudyo kiden nga nangpohut tentu. ");
INSERT INTO agt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","A yen na hapa ya nangtapilan na Hudyo kiden te Hesus, te nagtarabaku kan ta araw na agimmang tentu en nagpamappya ta lalaki en. ");
INSERT INTO agt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ammi ya uhohug ni Hesus tekid “A te magtarabaku para la i Damakewan, a yen ta magtarabaku yak hapa,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","A gafu ta uhohug na en a pake negakkad dan ya pangpapasi da tentu, te duwa kan ya liwat na, te awena kan kinurug ya lintig na araw na agimmang da, yaga nakigitta kan hapa ta Namaratu ewan, te nebar na ta Namaratu ya Dama na. ");
INSERT INTO agt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A ya tabbag ni Hesus ta maggakkad kiden tentu a “Dangagan muy ya ibar ku tekamuy: Awan ta mabalin ku am magurayak la tatakday, te am anu ya mariknak ta uray ni Damak a mappya ta yen ya idulot ku, ");
INSERT INTO agt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","te ya gagangay ni Damak a iddukan nak, a ituldu nak hapa ta ngamin tarabakun na. A ituldu nak sangaw ta pake masmasikan para ammi ta nepaitak tekamuy, petta pake magpaka-lat kam. ");
INSERT INTO agt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","A gafu ta itta ya pakapangwa ni Damakewan nga mangtolay ta nagpasi kiden a kumanen hapa teyak, te tolayan ku hapa ya ngamin ikayat ku. ");
INSERT INTO agt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Te bakkan na te Damakewan ya mangnonot ta tolay kiden am awa iyak, te gafu ta Anak nak a pinatudunan nak, petta iyak ya mangnonot tekid. ");
INSERT INTO agt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","A iyak mantu ya makkamu ta tolay, petta dayawan nak na ngamin tolay maski ta kuman na pangdayaw da te Damakewan. Ammi ya awan kiden mangdayaw ta Anak na Namaratu a mekwenta mantu ta aweda dayawan ya Dama na en nga nangidob tentu. ");
INSERT INTO agt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","A yen ta dangagan muy mina ya uhohug kin tekamuy: ya mangdangag ta uhohug ku ikid na mangurug ta nangidoben teyak a ittan ya angat na nga magnayun. A awena sangaw medarum ta atubang na Namaratu ewan, te nelillik na ta pasi na petta matolay la. ");
INSERT INTO agt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“A ya takday para na ibar ku tekamuy a mamegafu ta ayanin ya araw na pakadangag na nagpasi kiden ta ngahal na Anak na Namaratu ewan, a matolay ya makadangag. ");
INSERT INTO agt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Te pinasinapan nak ni Damakewan petta itta ya angat ku nga mesigud teyak ta kuman na itta hapa tentu. ");
INSERT INTO agt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","A gafu ta iyak ya Tolay Taga Langit a pinatudunan nak para nga mangnonot ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","A awemuy mina malangga ta nebar kin, te itta hala sangaw ya araw am maayagan ya ngamin kiden nagpasi, a madangag da sangaw ya ngahal ku, ");
INSERT INTO agt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","a sa imuhet kid ta tanam da kiden. Te ya nangwa ta katunungan ta katolay da en a maatadan kid sangaw ta magnayun na angat. Ammi ya nangwa ta awan ta kapkappyan a medarum kid sangaw ta atubang na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ammi maski am iyak ya mangnonot ta tolay kiden a awek haman maguray, te dangagan ku bit ya uray ni Damakewan. A am anu mantu ya nonot ku a matunung hapa, te bakkan ta ikayat kin ya nonotan ku am awa ikayat na nangidoben teyak. ");
INSERT INTO agt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“A kumanen hapa am iyak hapa la ya mangtistigu ta barik a amuk ta awan ta kwenta na, te tatakdayak la. ");
INSERT INTO agt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ammi itta para ya takday, te i Damakewan hapa ya mangtistigu teyak. A amuk ta matunung ya pangtistigu na. ");
INSERT INTO agt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","A kumanen hapa te Hwan, te ikamuy haman ya nangidob ta ange kiden nagimbestigar tentu, a kakurugan kad ya nebosag na negafu teyak. ");
INSERT INTO agt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","35","Ammi maski kunna ten a bakkan ta intu ikatalak ku ya pangtistigu na tolay. A ibar ku la yen tekamuy petta mekerutan kam mina, te kuman na zilag hapa I Hwan, nga nangpadakar bit tekamuy, a kuman na pa matalak kam bit nga timoltollok ta dakar na en. ");
INSERT INTO agt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ammi itta ya takwan na mangtistigu teyak nga pake dakdakal ammi te Hwan, te ya ngamin kiden tarabakuk nga nepatudun ni Damakewan teyak a yen kid para la ya idulot ku. A yen kid hapa ya mangtistigu teyak, petta amu muy ta awan ta takwan na pagafun ku am bakkan la te Damakewan Namaratu, te intu ya namatudun teyak. ");
INSERT INTO agt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Addet ta ayanin a awemuy la nadangag ya ngahal ni Damakewan nga nangidob teyak, a awan hapa ta nakaitan muy tentu, ammi maski kunna ten itta hala ya pangtistigu na teyak. ");
INSERT INTO agt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","A awemuy la netug ya uhohug na en, te awemuy kurugan ya dinob na en. ");
INSERT INTO agt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pake sinanedan muy haman ya surat kiden ta Bibliya te yen kid ya ikatalak muy nga mangatad ta magnayun na angat. ");
INSERT INTO agt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ammi iyak haman ya bidan da, a awemuy haman magadang teyak petta itta mina ya angat muy nga magnayun. ");
INSERT INTO agt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“A bakkan ta intu apagan ku ya pangdayaw na tolay teyak, ");
INSERT INTO agt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ammi amuk ya awemuy pangurug teyak, a te awemuy iddukan ya Namaratu. ");
INSERT INTO agt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Imange yak la tekamuy ta ngagan ni Damakewan, ammi awedak haman kurugan. Ammi am takwan ya umange tekamuy ta ngagan na en hapa la a yen hud la ya ikayat muy kurugan. ");
INSERT INTO agt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Had kukummuy mantu mangurug, bakawa intu pakolangan muy ya pangdayaw na kagitta muyen tolay tekamuy, a awemuy la nonotan ya ikayat na Namaratu petta intu mina ya mangdayaw tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","A maski am awemuy la mangurug a awemuy pahig ta iyak sangaw ya mangidarum tekamuy ta atubang ni Damakewan, te dana ittan ya mangidarum tekamuy. Te ya lintig kiden ni mina Moses nga ikatalak muy, a yen kid ya mangipasikkal ta liwat muy. ");
INSERT INTO agt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Te am kinurug muy mina ya nebar ni mina Moses a kinurug dak hapa, te iyak haman ya binida na ta surat na kiden. ");
INSERT INTO agt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ammi am awemuy kurugan ya surat na kiden a had kummuy mantu mangurug ta uhohug ku kiden tekamuy,” kunna, a yen bit la ya addet na pagbida na tekid. ");
INSERT INTO agt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","A ta kabalinan na kumanen a nagganwat ig Hesus, te ange kid ta dammang na alugen. ");
INSERT INTO agt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A dumadagdag hapa ya pake addu na tolay tekid, te ikayat da itan ya pakapangwa ni Hesus am pagmappyan na ya nagtatākit kiden. ");
INSERT INTO agt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","A ta datang nig Hesus ta dammang a gimon kid ta bagetayen, a sangaw nagibannag kid. ");
INSERT INTO agt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tanagay na hapa ya araw na Simana na Hudyo kiden am mangan kid ta panadamdaman da ta araw na nepangilillik na Namaratu ta gingginafu da kiden. ");
INSERT INTO agt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","A ta nepaglipay ni Hesus a naita na ya awan bababang na tolay nga dumadagdag tekid, te umabikan kid na tentu. A ya uhohug na te Felipe a “Felipe, mappya ta mangan ya tolay kiden nga dumagdag tekitam, ammi anu hud ya ialap tam ta kanan da?” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ammi pangparuba na yen te Felipe, te dana nanonot na ya kwan na. ");
INSERT INTO agt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","A ya tabbag ni Felipe hapa a “Maski am itta mina tekitam ya pirak na matandanan ta lugar na annam na hulan a makalannat hud ya igatang na ta kanan petta makakakkap mina ya tagtakday tekid?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A i Andres hapa nga kabagis ni Pedru a nebar na te Hesus ya takday babagu nga nehulun ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Itta hala ya balun na babagu in ta lima na pan ikid na duwa na ikan, ammi makalannat hud yen kid ta kaddu na tolay kidin?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","“A pagtuttudan muy mantu ya tolay kidin,” kun ni Hesus. A gafu ta kakaddatan hapa ye-yen na lugar a gituttudan kid na. A ya bilang na lalaki kiden la a itta de lima ribu kid. ");
INSERT INTO agt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","A sangaw ginawat ni Hesus ya pan na babagu en, kapye na nepakimallak. A sangaw nepesaned na ta tolay kiden gituttudan, kumanen hapa ta ikan kiden. A sa nakakakan kid ta kaddu na nekayat da. ");
INSERT INTO agt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","A tekiden nabattug a “Uknudan muy ya nahuna kiden, petta aweda makenga,” kun ni Hesus ta ituldu na kiden. ");
INSERT INTO agt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","A inuknud da kid, a pinannu da ya mafulu duwa na la-ba ta nehuna na nagkakan kiden nehuna na nagkakan kiden. ");
INSERT INTO agt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","A ta nepakaita na tolay kiden ta pakapangwa ni Hesusen a “Talaga ta ye-yan na tolay ya kinan da en aglavun na Namaratu nga ange kan ta lutakin,” kun na kadwan kiden tekid. ");
INSERT INTO agt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","A narikna ni Hesus ta tanagay enda gafutan, petta pagbalinan da ta ari da, a yen ta nagtugutan na kid, a nagtoli tatakday ta utun na bagetayen. ");
INSERT INTO agt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","A sangaw ta marimat a imunnan ya ituldu na kiden nga dumagut ta alugen. ");
INSERT INTO agt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","A ta datang da ta barangay da en a gimon kid hapa, te gumanwat kid na dimakit, te dumatang kid na ta ili na Kapernayum. Ammi tentu en nagsugiram a awena para la dumatang ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A sangaw gafu ta nagsikan na ya paddaden a namegafun magpalung ya danumen, a magtagwan kid na mantu petta makatangngan kid ta alugen. ");
INSERT INTO agt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","A tekid na nakatagwan abat ta lima ono annam na kilumetru a neitan da ya magpapa-yat ta danumen, te umab-abikan ta barangay da en, a pake nakatalaw kid na hapa. ");
INSERT INTO agt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ammi intu hala i Hesus, a nagayag hapa tekid, “Awemuy la magtalaw, te iyakin yan,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","A gafu ta intu a mayat kid na mangitakay tentu. A tentun nakatakay a alistu kid na nakadatang ta lutaken nga datangan da. ");
INSERT INTO agt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","A ya tolay kiden nga pinakan ni Hesus a itta kid para la ta dammang na alugen. A ta pagtalib na araw a dumatang hapa ya kadwan kiden barangay nga taga Tiberyas ta nanganan na tolay kiden ta pan kiden nga nepakimallak ni Hesus. A ta nepakkamu na tolay kiden ta awan na i Hesusen, a amu da ta awena nehulun ta ituldu na kiden, te ikid la ya nakalugan ta barangay, a tatakday la ya barangay da. ");
INSERT INTO agt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","A gafu ta awan ig Hesus ikid na ituldu na kiden a naglalugan kid na ta barangay kiden nga bagu dumatang, te umange kid hapa ta ili na Kapernayum, te enda apagan i Hesus. ");
INSERT INTO agt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","A ta datang da ta dammangen a naapagan da hala, a binaran da; “Mistro, kanu hud ya datang mu ta isin?” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A ya uhohug na en tekid a “Kustu ya uhohug ku tekamuy ta nagbannag kam mangapag teyak gafu ta nabattug kam ta nepakakan muy ta pan kiden, ammi maski am naita muy ya pakapangwak a awemuy para la maawatan ya naita muy. ");
INSERT INTO agt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Intu para apagan muy teyak ya kanan nga mewarad sangaw ta lutak, ammi bakkan mina ta yen ya pagbannagan muy am awa kanan nga mangatad ta magnayun na angat, te ye-yen na kanan ya iatad ku tekamuy, te iyak hala ya Tolayen Taga Langit nga pinasinapan ni Damakewan Namaratu ta pakapangwa na en,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","“A am mappya ta yen ya pagbannagan mi a anu mantu ya patarabaku na Namaratu tekami petta maatadan kami ta magnayun na pagtolayan nga kinam?” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","“Awan ta patarabaku na Namaratu tekamuy am bakkan la ta pangurug muy ta dinob na en, petta intu la ya ikatalak muy,” kunna ha ni Hesus. ");
INSERT INTO agt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","A gafu ta uhohug na en tekid a nangibar kid na ta pakaitan. “Mappya mantu ta mamadday ka ta pakaitan mi ta pakapangwam ta kuman na iningwa ni mina Moses, petta itta ya pangurugan mi teko. ");
INSERT INTO agt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Te ya uhohug na Bibliya en a ‘Inatadan na kid ta kanan nga nagafu ta langit,’ kunna. A intu hala ya ‘Mana en’ nga nagtolayan na gingginafu tam kiden ta kalafukanen abat ta appatafulu na darun,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","A ya uhohug ni Hesus tekid hapa a “Kustu hala ya ibar ku tekamuy ta bakkan haman te mina Moses ya nangatad ta kanan nga nagafu ta langit am awa Damakewan. A ta ayanin intu hapa la ya mangatad ta kakurugan na kanan nga nagafu ta langit. ");
INSERT INTO agt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Te ya kanan nga iatad na Namaratu ewan a intu hala ya Tolayen Taga Langit nga umakban ta lutakin, a yen ya mangatad ta magnayun na angat ta ngamin tolay ta paglelehutin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“Mappya mantu, Ser, ta kanayun atadan na kami ta kinamen nga kanan ta kinghahaw,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","A ya uhohug ni Hesus ta nagadang kiden tentu a “Iyak hapa la ya kanan nga mangtolay. A ya ange mantu mangan teyak a awenan sangaw mabisin. A am ikatalak nak a awenan sangaw gimtang. ");
INSERT INTO agt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ammi ta kuman na uhohug ku tekamuy ta idi a naita muy ya tarabakuk a awedak haman ikatalak. ");
INSERT INTO agt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ammi ya ngamin kiden iatad ni Damakewan ta kwak a yen kid sangaw ya magdulot teyak. A maski am inya sangaw ya ange teyak a pagdulotan ku hapa. ");
INSERT INTO agt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Te yen ta nagtugutak ta langitewan ikid na dumagut ta isin petta idulot ku la ya ikayat na nangidoben teyak, te bakkan ta ikayat kin ya tarabakun ku. ");
INSERT INTO agt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A uray na hapa ta awan sangaw ta mawakay ku ta ngamin kiden neatad na ta kwak, te tolayan ku kid ta pagaddetan na arawin yan. ");
INSERT INTO agt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Te ya uray ni Damakewan ta ngamin kiden bumabilbig ta Anak na en ikid na mangikatalak tentu a maatadan kid sangaw ta magnayun na angat, te tolayan ku kid sangaw ta pagaddetan na arawin yan,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","A gafu ta ‘Iyak ya kanan nga nagafu ta langitewan,’ kunna a yen ta linibakan na Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Bakkan hud te Hesus yan nga anak ni Hose en? Amu tam haman ya dama na ikid na hina na, a had kukunna mantu nagafu ta langit?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ammi ya uhohug ni Hesus tekid a “Awemuy mina magintabtabbag gafu ta inuhohug ken, ");
INSERT INTO agt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","te maski am anu ya uray muy awan ta makaange teyak am awena gamidan ni Damakewan nga nangidob teyak. A iyak hapa sangaw ya mangtolay tentu ta pagaddetan na arawin yan. ");
INSERT INTO agt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","A dana nesurat hala yen ta lebru na pinaguhohug na en, te ya nebar na a ‘Namaratu sangaw ya mangituldu tekid,’ kunna. A ya magdangag ikid na mangitug ta ituldu ni Damakewan a yen kid mantu ya umange teyak. ");
INSERT INTO agt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ammi maski kunna ten a awan para la ta nakaita te Damakewan am bakkan la ta Anak na en nga nagafu tentu, a iyak la mantu ya nakaita tentu. ");
INSERT INTO agt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“A pake ibar ku ha yan tekamuy, ya mangurug teyak, ittan ya angat na nga magnayun, ");
INSERT INTO agt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","te iyak ya kanan nga mangtolay tentu. ");
INSERT INTO agt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ammi ta kuman na gingginafu muy kiden ta kalafukanen, a maski sigida nangan kid ta Mana en nga netabnak ta lutak a aweda hala magnayun ta kinān da en, te sa nagpasi kid hala. ");
INSERT INTO agt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ammi ya kanan nga magafu ta langit a yen ya mangatad ta magnayun na angat, petta maski am inya ya mangan tentu a awena sangaw pake masi. ");
INSERT INTO agt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","A iyak hapa la ya kanan nga mangtolay nga nagafu ta langit, a am itta ya mangan ta isin na kanan a matolay sangaw magnayun. A ya kanan nga iatad ku, intu hala ya barikin, petta matolay mina ya ngamin tolay ta paglelehutin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A gafu ta uhohug ni Hesus a yen ya nagtatapilan na Hudyo kiden, te nagtatabbagan da am had kukunna iatad ya bari na tekid petta kanan da. ");
INSERT INTO agt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","A yen ta nagbida ha i Hesus tekid. “Kakurugan ya uhohug ku tekamuy ta am awemuy mangan ta bari na Tolayin Taga Langit ikid na uminum ta daga na en a awemuy mesipat ta angat na. ");
INSERT INTO agt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ammi ya mangan ta barik ikid na uminum ta dagak a ittan ya angat na nga magnayun, a iyak sangaw ya mangtolay tentu ta pagaddetan na arawin yan. ");
INSERT INTO agt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Te ya barikin ya kakurugan na kanan, a ya dagak ya kakurugan na inuman. ");
INSERT INTO agt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","A ya mangan mantu ta barik ikid na uminum ta dagak a yen ya mesipat teyak, a iyak hapa ya mesipat tentu. ");
INSERT INTO agt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ya Damakewan nga awan sangaw masi ya nangidob teyak, a matolayak hapa gafu tentu. A kumanen hapa ta manganen teyak, te matolay hapa gafu teyak. ");
INSERT INTO agt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","A ya kanan mantu nga bidan ku tekamuy a nagafu hala ta langit, ammi bakkan ta kuman na kanan na gingginafu muy kiden, te maski nangan kid a sa nagpasi kid hala. Ammi ya mangan ta iatad kin nga kanan a matolay hala sangaw nga magnayun,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","A ye-yen na bida ya nepadangag ni Hesus ta umag na kapilya na Hudyo kiden tentu en nangituldu ta ili na Kapernayum. ");
INSERT INTO agt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","A ya tolay kiden nga dumagdag te Hesus ikid na nakadangag ta netuldu na en a addu tekid ya malussaw ta bida na en. “Kuga mazigat ye-yan na bida. Itta hud ya mayat magdangag ta kumanin?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","A maski awan ta nangibar te Hesus a amu na hala ta libakan da ya binida na en tekid, a yen ta naguhohug ha tekid. “Anu? Matampa de ya pangurug muy teyak gafu ta nabidaken tekamuy? ");
INSERT INTO agt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A anu sangaw ya pangawatan muy ta inuhohug ken am maita dak sangaw nga timullu ta langitewan ta dana nagyanan ken? ");
INSERT INTO agt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Awemuy mina pahig ta matolay kam magnayun gafu ta gagangay na kanan, te intu la mangtolay ya kanan nga sekahalwa. A ya inuhohug ku tekamuy ta ayanin a yen kid ya kanan nga sekahalwa ikid na seangat. ");
INSERT INTO agt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","Ammi ya kadwan kiden tekamuy a awemuy kurugan ya inuhohug ku tekamuy. A yen ta nebar ku tekamuy ta awan sangaw ta makaange teyak am awena uffunan ni Damakewan,” kunna. A yen ya nebar na tekid, te addet ta nepamegafu da en nga dumagdag tentu a dana amu na ya awan kiden mangurug tentu, ikid na am inya sangaw ya mangitalaba tentu. ");
INSERT INTO agt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","A gafu ta kumanen a nagtalekud na ya addu na dumagdag kiden tentu, te awedan nakihulun tentu. ");
INSERT INTO agt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ammi itta la ya mafulu duwa kiden nga sigida itultuldu na. A ya nebar na tekid a “Anu hapa ya uray muy? Ikayat muy hapa de magtugut teyak?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","A ya tabbag ni Pedru a “A itta hud ya takwan na eyan mi, Afu, petta yen hud ya dagdagan mi? Te iko la ya pakadangagan mi ta uhohug kiden nga mangatad ta magnayun na angat. ");
INSERT INTO agt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","A nangurug kamin teko, te amu min ta iko ya kagitta na Namaratu ewan nga nagafu tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","A ya uhohug ni Hesus tekid ngamin a “Nonotan muy ta iyak hapa la ya nangpili tekamuy petta mafulu duwa kam, ammi amuk ta kahulun ni Satanas ya takday tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","A intu binida na i Hudas nga anak ni Simon Iskaryote, te maski nebilang ta mafulu duwa kiden a intu hala sangaw ya mangitalaba te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","A ta nekabalin na en a awena nekayat ni Hesus magayn ta lugar na Hudeya gafu ta Hudyo kiden nga mangigakkad ta pasi na. A yen ta pinasyaran na ya kadwan kiden babali ta lugar na Galileya. ");
INSERT INTO agt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Ammi sangaw ta kaatubangan na Pyesta na Ba-bali Kiden ta iten Hudeya, a nepapilit na kabagis na kiden ta ange mina i Hesus ta pyesta en. “Mappya ta awem magaagyan ta isin, te e ka mina ta iten Hudeya, petta maita na ituldum kiden ya pakapangwam. ");
INSERT INTO agt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Te anum haman ilemad ya tarabakum? Am malalaki ya tarabakum a mappya ta ipaitam mina ta ngamin tolay,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","A yen ya inuhohug da tentu, te maski kabagis na kid a aweda mangurug tentu. ");
INSERT INTO agt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","A ya tabbag na hapa tekid a “Awek para umange, te bakkan para la ta araw ku. Ammi tekamuy a sigida itta ya araw muy, ");
INSERT INTO agt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","te awena kam ikatupag na tolay kiden. Iyak ya ikatupag da, gafu ta iyak ya mangipasikkal ta kadulay na tarabakun da. ");
INSERT INTO agt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mappya mantu ta ikamuy na ya ange ta pyesta en, te awek ange, te bakkan para la ta pake araw ku,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A yen ta nasirak la i Hesus ta lugar na Galileya. ");
INSERT INTO agt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ammi ta nepakagon na kabagis na kiden ta agyan na pyesta en a gimon na hala i Hesus, ammi awena nakihulun ta addu na tolay, petta awan ta mangibar tentu ta makipyesta kiden. ");
INSERT INTO agt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ammi ya pinakadakal na Hudyo kiden a apagan da hala i Hesus, te ikatalak da ta umange, a yen ta pinohutan da ta tolay kiden am naita da. ");
INSERT INTO agt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A addu hapa ya nean-anisat na tolay kiden gafu tentu. “Mappya na tolay yen O,” kun na kadwan. Ammi ta kadwan a “Mappya hud yeyana, te mangitawag ta tolay kiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ammi gafu ta talaw da ta pinakadakal da kiden a aweda pake bibidan i Hesus ta kaddun na tolay. ");
INSERT INTO agt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","A ta mekappat na araw na pyesta en a gimon i Hesus ta agyan na simbaanen, a namegafu nangituldu ta tolay kiden ten. ");
INSERT INTO agt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A pake nepagpaka-lat da hapa na pinakadakal na Hudyo kiden. “Anu itta ya amu na inin, bakawa awena haman nagadal ta mistro tam kiden?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ammi ya tabbag ni Hesus ta uhohug da en a intu yan: “Maski awek nagadal ta mistro muy kiden a bakkan hala ta iyak ya nagafun na itulduk tekamuy, te ya Namaratu ewan nga nangidob teyak ya nagafun na. ");
INSERT INTO agt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","A maski am inya ya mayat nga mangidulot ta patarabaku na Namaratu ewan tentu a melasin na hala am Namaratu ya pagafun na itulduk, ono am magurayak la maguhohug ta kabukodan na nonot ku. ");
INSERT INTO agt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Te ya maguray maguhohug ta kabukodan na nonot na a awan ta takwan na padayaw na am bakkan ta bari na hapa la. Ammi ya mangipadayaw ta nangidoben tentu a yen ya mekatalak nga mangituldu, te awan ta pagkilluyan na. ");
INSERT INTO agt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Pake dayawan muy hala i mina Mosesen gafu ta intu ya nangisirak ta lintig kiden tekamuy. Ammi maski kunna ten awan haman tekamuy ta mangitug ta nesirak na en tekamuy, te igakkad dak haman papasin maski am awan ta pangpapasin muy teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","A ya tabbag na tolay kiden hapa a “Itta hud ya manggakkad mamapapasi teko? Itta de ya anitum nga nagpaguyung teko,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A ya tabbag na en hapa a “Maski kustu hala ya inuhohug ken, te ka-ma kam la nakaporay gafu ta takday la na tarabakuk ta araw na agimmang. ");
INSERT INTO agt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ammi sigida magtarabaku kam hapa ta araw na agimmang, te yen haman ya pagbanggit muy ta mayaten mesipat tekamuy. A yen ya idulot muy gafu ta lintig na agbanggit nga nesirak ni mina Mosesen tekamuy. Ammi maski kunna ten a bakkan haman te Mosesen ya nagafun na am awa gingginafu muy kiden nga napopolu ammi tentu. ");
INSERT INTO agt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","A am ituluk muy mantu ta mabanggit ya tolay ta araw na agimmang petta awemuy makaliwat ta lintig ni Moses a anu haman ta magporay kam teyak ta pagpamappyak ta napilay ta araw na agimmang? ");
INSERT INTO agt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mappya ta awemuy hamhama ya pangnonot muy, te mangnonot kam mina ta katunungan na nonot,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","A gafu ta tabbag ni Hesus a tumubbat hapa naguhohug ya kadwan kiden tolay taga ili na Herusalem. “Talaga ta ye-yan na tolay ya ikayat da en papasin,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","“Ammi itan muy awa itta in magbida ta tolay kidin, a awena haman magtalaw, yaga aweda hapa pakidibatin na pinakadakal tam kiden. Nelasin dan de ta intu hala ya Mangikerutan nga ange kan tekitam?” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ammi ya uhohug na kadwan a “Awan, te am makipaita sangaw ya Mangikerutan a awan kan ta makkamu am had ya pagafun na, ammi amu tam haman ya nagafun na inin,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","A gafu ta mangituldu para la i Hesus ta umag na simbaanen a neayag na ya tabbag na ta bida na tolay kiden tentu. “Maski am amu muy ya ngagan kin ikid na lugaren nga nagafun ku a awemuy haman amu ya nangidoben teyak, ammi iyak ya makkamu tentu, te awek mina umange sin am awenak dinob. Awemuy amu ya nangidob teyak, te intu ya kettayan na ngamin kakurugan, a naggafuyak tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","A gafu ta uhohug na en a ginafut da mina ammi awan ta nakagafut tentu, te bakkan para la ta araw na en. ");
INSERT INTO agt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ammi ta kadwan kiden tolay nga nakadangag tentu a addu hapa ya nangurug ta intu hala ya Mangikerutan nga dana nebar na Namaratu, te ya uhohug da a “Talaga ta intu hala ya Mangikerutanen, te am bakkan, a awan mina ta pakapangwa na ta kuman na nepaita na tekitam,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","A ya Pariseyu kiden hapa a nedangagan da ya nean-anisat na tolay kiden gafu te Hesus, a yen ta umange kid nakibidan ta kadwan kiden padi na Hudyo, a nagbabidan da ya pangidob da ta polis kiden, petta gafutan da i Hesus. ");
INSERT INTO agt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","A ta datang na polis kiden a magbida para la i Hesus ta tolay kiden. “Assang na la ya kettakin tekamuy, kapyek sangaw magtoli ta nangidoben teyak. ");
INSERT INTO agt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A apagan muy sangaw ya Mangikerutan tekamuy, ammi awemuy sangaw maapagan, te awemuy makaange ta datangan ku,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","A nagimpopohutan na Hudyo kiden ya ikayat na uhohugan. “Had hud para ya eyan na en nga awetam sangaw maapagan?” kun na kadwan. “Ikayat na panaw ange ta Hudyo kiden nga nesansaned ta lugar na Giregu kiden petta mangituldu hapa tekid ikid na Giregu kiden?” kun na kadwan para. ");
INSERT INTO agt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A ta kadwan para a “Anu hud ya ikayat na uhohugan ta apagan tam sangaw, ammi awe tam sangaw maapagan? A had kukun na uhohug na en ta awe tam makaange ta eyan na en?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","A ta kapozyanan na araw na pyesta en a sa magkakampat ya ngamin tolay ta simbaanen, a nagtayuk i Hesus kapye na nagayag tekid ta masikan. “Am itta ya makainum a ange mina teyak petta uminum. ");
INSERT INTO agt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Te ya mangikatalak teyak a Itta hala sangaw ya kuman na karayan na danum nga magarut ta umag na en nga mangtolay tentu, te yen ya nesurat ta Bibliya en,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ammi intu bidan na ya Kahalwa na Namaratu nga iatad na sangaw ta ngamin kiden mangurug tentu. Ammi awena la bit nedob tekid te awena para la madayawan ni Hesus ta langitewan. ");
INSERT INTO agt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","A ta nepakadangag na tolay kiden ta uhohug ni Hesus a nebar na kadwan ta “Talaga ta intu hala ya paguhohugan na Namaratu nga binida ni mina Mosesen,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","A ya uhohug na kadwan a “Maski intu hala ya Mangikerutan,” kunda. Ammi awena nangurug na kadwan, te “Taga Galileya hud sangaw ya Mangikerutan tekitam? ");
INSERT INTO agt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Te ya nesurat ta Bibliya a intu sangaw ya pangpanga ni mina Dabiden, a meanak sangaw ta ili na Betlihem, te yen haman ya lugar ni mina Dabiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","A nagkakattway mantu ya nonot na tolay kiden gafu tentu, ");
INSERT INTO agt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","te ikayat na kadwan ta gafutan da mina, ammi maski kunna ten a awan haman ta nangsi-ged tentu. ");
INSERT INTO agt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","A ta pagtoli na polis kiden ta padi kiden ikid na Pariseyu kiden nga nangidob tekid a “Anu hud ta awemuy inalap?” kunda tekid. ");
INSERT INTO agt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","“A awemi ginafut, te awan ta takwan na amu mi nga makauhohug ta kuman na nadangag mi en tentu,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Anu kuga naayayyaw kam hapa ta laddud na. ");
INSERT INTO agt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Itta hud ya nangurug tentu ta pinakadakal muy ono Pariseyu?” kunna hapa na Pariseyu kiden tekid. ");
INSERT INTO agt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","“Pa-gangan na Namaratu ye-yan kid na tolay nga awan makkamu ta lintig na kiden,” kunda ha. ");
INSERT INTO agt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Ammi ya uhohug ni Nikodemu ta sakā Pariseyu na kiden a “Ta kuman na uhohug na lintig tam kiden a mehangat kitam mangpa-gang ta tolay am dana awetam bit dangagan ya bida na, petta amu tam ya liwat na,” kunna. I Nikodemu ya umange nakibidan te Hesus ta hiklam. ");
INSERT INTO agt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","A ya tabbag na kadwan kiden tentu a “Anu? Taga Galileya ka hapa, petta ikerutam ya kagittam. Pake basam mina ya surat na pinaguhohug kiden na Namaratu, te maitam sangaw ta bakkan ta Galileya ya pagafun na paguhohugan na en nga nebar na tekitam,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","A sangaw naggagungay kid, te immange ya tagtakday tekid ta bali da. ");
INSERT INTO agt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","A ta nekabalin na kumanen a nagammak i Hesus ta Bagetay na Olibo nga itta ta bikat na ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","A ta magkakarawan a dumagut ha, a nagtoli ta simbaanen. A gafu ta enna ha kinalihung na tolay kiden a nagtuttud hapa, petta mangituldu tekid. ");
INSERT INTO agt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","A tentu para la nangituldu a simarok hapa ya kadwan kiden Pariseyu ikid na Abugadu nga mangituldu ta lintig ni Moses. A nehulun da hapa ya takday babbay nga ginafut da ta pakikadallaw na en, a pinatayuk da ta pagtatangnganan na tolay kiden kapye da nebar te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Mistro, neddatangan mi ye-yan na babbay ta pakikadallaw na. ");
INSERT INTO agt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A ta lintig ni Moses a nebar na ta mapatur ya kumanin addet ta masi, ammi damagan mi hapa ya uray mu tentu.” kunda. ");
INSERT INTO agt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ammi inuhohug da yen te Hesus te pangparuba da tentu, talo am itta ya ibar na nga pangidaruman da sangaw tentu. Ammi te Hesus a nagtumag la nagkurkurnit ta lutak ta guramay na en. ");
INSERT INTO agt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","A gafu ta netotoli da ya pohut da en tentu a nagtayuk hapa ta atubang da kapye na hapa naguhohug tekid. “Am itta ya awan seliwat tekamuy a yen mina ya imunnan mangpatur ta babbayina,” kunna, ");
INSERT INTO agt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","kapye na nagtumag ha nagkurkurnit ta lutak. ");
INSERT INTO agt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ammi ta nepakadangag da ta inuhohug na en tekid a nasesenut kid na nagtatugut namegafu ta kalalaklakayan, a intu la nasirak i Hesus ikid na babbayen nga imatayuk ta atubang na en. ");
INSERT INTO agt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","A sangaw nagtayuk ha i Hesus kapye na naguhohug ta babbayen. “Anu awan kid? Awan hud ta nasirak nga mangpa-gang teko?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Awan kad, Afu,” kunna hapa. “A maski teyak, bakkan ta iyak ya mangpa-gang teko, a e kan mantu, ammi awem na sangaw magliwat,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","A sangaw ta pagbida ha ni Hesus ta Pariseyu kiden a “Iyak ya magserbi ta kuman na zilag ta tolay kiden,” kunna. “Am itta ya dumagdag teyak a awena sangaw magtugtugut ta sugiram, te itta tentu ya zilagen nga mangtolay tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ammi ya tabbag da hapa tentu a “Awan haman ta kwenta na pangtistigum, te iko la tatakday ya mangtistigu ta barim,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A ya bida ni Hesus tekid a “Maski am iyak hapa la ya mangtistigu ta barik a kakurugan hala ya pangtistiguk, te amuk haman ya nagafun ken ikid na datangan ku. Ammi tekamuy a awemuy haman amu ya nagafun ken ikid na datangan ku. ");
INSERT INTO agt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Am ikamuy ya mangnonot ta kwenta na tolay a intu la nonot muy ya gagangayen nonot na tolay, ammi teyak a awek haman nonotan am anu ya kwenta na tolay. ");
INSERT INTO agt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ammi maski am iyak mina ya mangnonot tekid a matunung hala ya pangikwentak tekid, te awek maguray mangnonot am awa duwa kami ni Damakewan nga nangidob teyak. ");
INSERT INTO agt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Intu mina pagnonotan muy ya ibar na lintigen te yen ya ikatalak muy, a am naggitta kan ya pangtistigu na duwa na tolay a matunung kan ya pangtistigu da. ");
INSERT INTO agt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","A matunung mantu ya pangtistigu mi ni Damakewan, te ya pangtistiguk ta barikin a kumanen hala ya pangtistigu ni Damakewan teyak,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","A gafu ta nekabat na ya dama na en a nebar da ta “Had sin mantu ya damam nga kinam, petta dangagan mi ya pangtistigu na teko,” kunda tentu. “Awemuy amu i Damak gafu ta awemuy amu am inya iyak. Te am amu dak mina a amu muy hapa i Damakewan,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","A ta nepaguhohug na ta kumanen tekid a itta kid ngamin ta umag na simbaanen ta bikat na nangila-nugan na tolay kiden ta kontribisyon da kiden, te yen ya nagyanan na tentu en nangituldu ta tolay kiden. Ammi maski inuhohug na yen tekid a awan ta nanggafut tentu, te bakkan para la ta araw na en. ");
INSERT INTO agt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","A gafu ta kumanen a nedulot na ya paguhohug na tekid. “Awanak sangaw tekamuy, te pagtugutān ta kam, a ‘Ampade ittan ya Mangikerutanen,’ kummuy sangaw. Ammi masi kam hala sangaw seliwat, a awemuy sangaw makaange ta eyan ku,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A gimpopohut kid ta “Anu hud ya ikayat na uhohugan ta awetam sangaw makaange ta eyan na? Papasin na de sangaw ya bari na?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","A ya tabbag na hapa tekid a “Killu ya agnonot muy ta kuman na kadwan kiden tolay taga lutakin. Bakkan ta kunna ten na agnonot ku, te iyak ya taga utunewan. ");
INSERT INTO agt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","A yen ta nebar ku tekamuy ta masi kam hala sangaw seliwat, te am awemuy mangurug ta iyak hala ya pakaitan na Namaratu ewan a kurug ta masi kam sangaw seliwat,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","26","“Agay! Parig mu hud ta iko ya kagitta na nginaganamina?” kunda tentu. A ya tabbag na hapa a “Mabalin hapa ta addu ya mauhohug ku ta pangihuyak tekamuy, ammi annun ta kam para kabida maski ta assang la. Te ya nangidoben teyak ya kettayan na ngamin kakurugan, a intu la ipadangag ku ta tolay kidin ya kuman na nadangag ku tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aweda naawatan ta intu nabida na tekid ya Dama na en nga nangidob tentu, ");
INSERT INTO agt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","a yen ta pake nebar na tekid. “Sangaw am pinagappa dak a yen sangaw ya pakkamu muy ta iyak hala ya Tolayin Taga Langit. A amu muy hapa sangaw ta awek naguray ta paguhohug ku tekamuy, te intu la uhohugan ku ya netuldu ni Damakewan teyak. ");
INSERT INTO agt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","A maski am intu ya nangidob teyak a nehulun hala teyak, a awenak sangaw pagurayān, te kanayun kwan ku ya makamamallak tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","A ta nepakauhohug ni Hesus ta isin tekid a addu hapa ya nangibar ta mangurug kid na tentu. ");
INSERT INTO agt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ammi ya uhohug ni Hesus ta mangurug kiden tentu nga Hudyo a “Am pake itug muy ya uhohug ku tekamuy a megitta kam sangaw ta kakurugan na metuldu nga awan mangilogot. ");
INSERT INTO agt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","A am pake netug muy na ya kakurugan a maubadan kam hapa ta pagtagabu muy gafu ta kakurugan nga amu muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","“A te Hudyo kami nga pangpanga ni mina Abraham, a addet ta ayanin awan kad ta nakitagabun mi. A anu mantu ya ikayat mu uhohugan ta maubadan kami sangaw ta pagtagabu mi?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","A ya uhohug ni Hesus tekid a “Pake ibar ku tekamuy ta maski am inya tekamuy ya iminam magliwat a kuman na makitagabu mantu ta mamagliwaten tentu. ");
INSERT INTO agt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A amu muy haman ta awan ta tawidan na tagabu ta kwa na dafu na en. Ammi ya anak na makābali en a yen sangaw ya makkamu ta ngamin kwa na dama na en. ");
INSERT INTO agt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","A am Anak na Namaratu mantu ya mangubad tekamuy ta pagliwat muy a kurug ta maubadan kam ta mappya. ");
INSERT INTO agt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Amuk ta ikamuy Hudyo ya pangpanga ni Abrahamen, ammi awemuy haman megitta tentu, te igakkad muy haman ya mamapasi teyak. A yen ta papasin dak gafu ta awan ta ketugan na uhohug ku tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ammi awan ta inuhohug ku tekamuy am bakkan la ta kuman na naitak te Damakewan, a intu la tarabakun muy hapa ya kuman na nadangag muy ta dama muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","A ya tabbag da hapa ta inuhohug ni Hesus a “Awan ta takwan na dama mi am bakkan la te mina Abraham,” kunda. “A am kakurugan ta ānāk kam mina ni Abrahamen a gagangay ta tarabakun muy mina ya kuman na gagangay na en. ");
INSERT INTO agt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ammi ta kuman na ikamuy a ikayat muy hud la papasin ya nangipadangag ta kakurugan nga nadangag na ta Namaratu ewan. Kunna hud ten ya tarabaku ni mina Abraham? ");
INSERT INTO agt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Takwan mantu ya dama muy a yen ya parigan muy,” kunna hapa tekid. “Atsi O, awena kami igitta ta kuman na anak na nakikadallaw, te takday la ya dama mi, a intu hala ya Namaratu ewan,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","A ya uhohug ni Hesus tekid a “Am Namaratu mina ya dama muy a gagangay ta iddukan dak mina, te Namaratu hapa la ya nagafun ku. A yen ta itta yak sin, te awek haman naguray umange am awa intu hud la ya nangidob teyak. ");
INSERT INTO agt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ammi awemuy garay maawatan ya ikayat ku uhohugan tekamuy, te awemuy ikayat dangagan ya ibar ku tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ikamuy hala ya ānāk ni Satanas, a am anu ya ikayat na dama muy a yen hapa ya tagasingatan muy. Intu hala ya minagpapasi abat ta gafu na en, a awena amu magbida ta kakurugan, te intu la gagangay na ya pagkilluyan. A am magladdud a ipaita na hala ya gagangay na, te kanayun magladdud, yaga intu hapa la ya namepegafu ta laddud. ");
INSERT INTO agt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ammi teyak a kanayun uhohugan ku ya kakurugan, ammi gafu ta kakurugan a awemuy haman kurugan, te intu la ikayat muy ya laddud. ");
INSERT INTO agt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Itta hud tekamuy ya makapasikkal ta pagliwat ku? A am kakurugan ya uhohugan ku tekamuy anu kawagan na mantu ta awedak kurugan? ");
INSERT INTO agt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Am makidama ya tolay ta Namaratu a dangagan na mantu ya ibar na Namaratu tentu, ammi yen ta awemuy dangagan ya uhohug na te bakkan ta intu ya dama muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A gafu ta uhohug ni Hesus ta Hudyo kiden a tinabbag da hapa. “Kustu hala ya uhohug mi en ta kagitta na ka na Samaritan kiden, te itta malat ya anitum nga nagpaguyung teko,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Itta hud ya anituk, bakawa padayaw ku haman ya Damakewan. Ammi tekamuy a padpadulayan muy ya mangpadayaw tentu. ");
INSERT INTO agt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Awena ta padayaw ku ya barik tekamuy, ammi itta hala ya mangpadayaw teyak, a intu hala ya makkamu ta ngamin dumatang teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A ya takday para na bida na tekid a “Pake ibar ku tekamuy ta maski am inya ya mangitug ta uhohug ku a awena sangaw masi,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","“Asakay, kuga maguyung kan malat O, te pake netug ni mina Abrahamen ya uhohug na Namaratu, ammi nasi hala, a kumanen hapa ta kadwan kiden pinaguhohug na. Ammi ibar mu haman ta awena sangaw masi na mangitug ta uhohug mu. ");
INSERT INTO agt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Dakdakal ka hud ammi te mina Abraham ikid na pinaguhohug kiden na Namaratu nga sa nagpasi? Inya hud ya pangigittam ta barim?” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","A ya uhohug na ha tekid a “Am angarigan ta iyak ya mangdayaw ta barik a awan ta kwenta na pangdayaw ku, ammi ya Damakewan ya mangdayaw teyak, a intu hala ya ibar muyen ta Namaratu muy, ");
INSERT INTO agt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ammi ta kakurugan a awemuy haman amu. Iyak hala ya makkamu tentu, a am awek mina ibosag ya pakkamuk tentu a kagitta dak mina nga magladdud. Ammi amuk haman, a itug ku hapa ya uhohug na. ");
INSERT INTO agt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","A ya gingginafu muyen Abraham nga kinan muy a pake matalak hapa gafu ta uhohug na Namaratu tentu ta maita na sangaw ya araw ku. A kuman na naita nak hapa gafu ta pangikatalak na en teyak, a pake natalakan hapa,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","“Asakay, pake nabayag na haman ya nepasi ni Abrahamen a awem para la laklakay. Mabalin hud mantu ta nagkāita kam?” kunda hapa tentu. ");
INSERT INTO agt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","“Kakurugan hala ya uhohug ku tekamuy ta dana itta yak na ta kawan para la ni mina Abrahamen,” kunna ha tekid. ");
INSERT INTO agt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","A gafu ta pake nekatupag da ya uhohug na tekid a nangalap kid na ta batu, te pangpapasi da tentu, ammi nelogot kid te nalingadan na tentu en imuhet ta simbaanen. ");
INSERT INTO agt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","A sangaw ta pagtugtugut nig Hesus ikid na ituldu na kiden ta dalan a nesimmun da ya takday lalaki nga nagdaram ta nekeanak na en. ");
INSERT INTO agt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A napopoyung hapa ya nonot na kahulun na kiden ni Hesus ta nagdaramen, te ya uhohug da te Hesus a “Mistro, Inya hud ya nagliwat tekid na daramin ono dadagkal na kiden, petta daram ta nekeanak na?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","“Bakkan ta liwat na ya nepagdaram na,” kun ni Hesus, “a bakkan hapa ta liwat na dadagkal na kiden, am awa neanak nagdaram petta intu sangaw ya pakaitan na pakapangwa na Namaratu ewan gafu ta pagpamappyak tentu. ");
INSERT INTO agt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","A mappya mantu ta idulot tam ya patarabaku na nangidoben teyak ta ketta para la na araw tam, te dumatang sangaw ya kuman na hiklam ta awetam pakatarabaku. ");
INSERT INTO agt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ammi ta kettak para la ta paglelehutin a iyak ya mangpadakar ta sugiram na tolay kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","A tentun nakauhohug ta isin a naglutab ta lutak, kapye na nelagum ya lutak ta lutab na en. A sangaw nedirkat na ya fuyaken ta mata na daramen kapye na dinob nga ange magamwas. ");
INSERT INTO agt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Aran, E kan magamwas ta kinan da en ‘Agzigutan na Siluwam’,” kunna ta daramen. (A ya ikayat na uhohugan na Siluwam a ‘Nedob’, kunna.) Umange mantu nagamwas, a tentu en dimmatang ta bali na en a makaitan. ");
INSERT INTO agt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A ta nepakaita na karuba na kiden tentu a “Intu hala de ya nakilimlimuten,” kunda. A kumanen hapa ya uhohug na nakaita kiden tentu ta nepakilimlimut na en. ");
INSERT INTO agt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","“Intu kad hala,” kun na kadwan, ammi ta kadwan a “Bakkan ta intu, am awa kagitta la na bari na en,” kunda. Ammi ya uhohug na daramen tekid a “Maski iyak haman,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","A ya uhohug da mantu tentu a “Had kukunna mantu na nepakaladdang mu?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","“A te ya nagngagan te Hesus a namadday ta fuyak, kapye na nedirkat ya fuyaken ta matak kiden. A ‘E kan magamwas ta iten Siluwam,’ kunna teyak. “A umange yak mantu nagamwas, a sangaw nakaita yak na,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“A had agyan na kinamen Hesus ta ayanin?” kunda ha tentu, ammi awena kan amu. ");
INSERT INTO agt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","A ta nepamadday ni Hesus ta fuyaken ikid na nepagpaladdang na ta mata na daramen a araw na agimmang na Hudyo kiden. A sangaw itta ya umange nangalap ta lalaki en, petta iange da ta Pariseyu kiden, ");
INSERT INTO agt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","te imbestigaran da am had kukun na nepakaladdang na mata na kiden. A ya uhohug na en tekid a “Nedirkat na ya fuyak ta matak kiden, kapyek umange nagamwas, a ta ayanin a makaita yak na,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","“On ay, ammi ye-yen na tolay nga kinam a bakkan ta kahulun na Namaratu, te awena haman ngilinan ya araw na agimmang,” kun na kadwan kiden Pariseyu. “A am kakurugan mina ta dulay na tolay a itta hud ya mabalin na ta daram petta makaita?” kunna para na kadwan. A nagkakattway mantu ya nonot da gafu tentu. ");
INSERT INTO agt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","A gafu ta kumanen a pinohutan da ha ta lalaki en. “Iko haman ya pinaladdang na ta mata, anu mantu ya uray mu tentu?” kunda. “A talaga ta paguhohugan na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ammi ya pinakadakal na Hudyo kiden nga nangikatupag te Hesus a aweda kurkurugan ya nepagdaram na lalaki en ikid na nepakaladdang na mata na kiden, a yen ta pinaayagan da bit ya dadagkal na kiden petta pohutan da tekid. ");
INSERT INTO agt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Ye-yan hud ya anak muyen nga kinan muy nagdaram ta nekeanak na? A am ‘On,’ kummuy a ipasikkal muy mantu am had kukunna makaita ta ayanin,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A ya tabbag da hapa a “Amu mi ta intu hala ya anak mi, a amu mi hapa ta daram ta nekeanak na en, ");
INSERT INTO agt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ammi awemi haman amu am anu ya gafu na pakaita na ta ayanin, ikid na am inya ya nangpaladdang ta mata na kiden. Mappya ta intu mina ya pangpohutan muy, petta intu hapa la ya pakadangagan muy, te intu hapa la ya makkamu ta bari na,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A yen ya tabbag da en gafu ta talaw da ta Hudyo kiden nga nangpohut tekid, te dana nagbabidan na pinakadakal da kiden ta am itta ya mangibosag te Hesus ta intu hala ya Mangikerutan nga dinob na Namaratu a mehangat sangaw makigimung ta kapilya da. ");
INSERT INTO agt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","A yen ya gafu na nepagtabbag da ta “Intu mina ya pangpohutan muy, te intu hapa la ya makkamu ta bari na,” pagkin. ");
INSERT INTO agt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","A gafu ta kumanen a pinaayagan da ha ya lalaki en nga nagmappya ta nepagdaram na en, a pake tinabarangan da. “Awem na mina magtulad ta atubang na Namaratu ewan, te ibosag mu hala ya kakurugan, te amu mi haman ta dulay na tolay ya kinamen nga nangidirkat ta fuyak ta matam kidina,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“A awek haman amu am dulay na tolay yen, ono awan. Intu la amuk ya nepagdaram ken, a ta ayanin a makaita yak na,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“A anu mantu ya iningwa na teko? Had kukunna hud na nepagpaladdang na ta matam kidina?” kunda ha tentu. ");
INSERT INTO agt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Asakay, nebar kun paen tekamuy, a awemuy haman dinangag. Anu haman ta damagan muy ya iningwa na teyak? Ikayat muy hud medagga ta ituldu na kiden?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ammi pake nagsasitangan da ya lalaki en. “Iko ya ituldu na tolayin yana, ammi ikami ya ituldu ni mina Moses. ");
INSERT INTO agt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Amu mi ta itta ya netuldu na Namaratu te mina Moses, ammi ta tolayin yana a awemi haman amu am had ya nagafun na,” kunna hapa na tabbag da tentu. ");
INSERT INTO agt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","“Ama! Kuga mamallaw kanan, te maski itta ya nakapaladdang ta matak kiden a ibar muy para ta awemuy amu am had ya nagafun na. ");
INSERT INTO agt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Amu haman na ngamin tolay ta awena dangagan na Namaratu ya pakimallak na minagliwat ta lintig na kiden, te intu la dangagan na ya mamat tentu ikid na mangidulot ta ikayat na en. ");
INSERT INTO agt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","A maski abat ta nepamegafu na paglelehutin itta hud ya nadamag nga makapaladdang ta mata na tolay nga neanak nagdaram am bakkan la ta ayanen. ");
INSERT INTO agt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Am bakkan mina ta kahulun na Namaratu ye-yen na tolay a itta hud mantu ya pakapangwa na nga mangpaladdang ta matak kidin,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","“Oh, iko hud ya makkamu mangituldu tekami, bakawa nekihu ya liwat mu ta nepaghukal mu,” kunda hapa tentu, kapye da newarad ta lawan. ");
INSERT INTO agt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","A sangaw nadamag ni Hesus ta dinugiman da ya nagdaramen ta kapilya da en. A tekid ha nagkasimmu a “Anu hapa ya uray mu ta Tolayen Taga Langit? Mangurug kan de tentu?” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“A inya hud yen, Ser? Ibar mu haen teyak, petta kurugan ku hapa,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","“A naitam na haman, a maski intun ya makiuhohugan teko,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Ay, mangurugak mantu, Afu,” kunna, kapye na namalentud hapa ta atubang ni Hesus nga nangdayaw tentu. ");
INSERT INTO agt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","A ya pasikkal ni Hesus ta iningwa na en ta nagdaramen a “Yen ta umange yak ta paglelehutin, petta melasin ya mangurug ikid na awan mangurug gafu teyak, pettam kumanen a makaita ya nagdaram kiden, ikid na magdaram ya makaita,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","A gafu ta nedangagan da hapa na kadwan kiden Pariseyu a “Anu hud ya ikayat mu uhohugan? Ikami de hapa ya kuman na nagdaram?” kunda te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","“Am kurug mina ta magdaram kam a awan mina ta liwat muy gafu ta awemuy maita ya itta ta atubang muy. Ammi gafu ta ‘Ikami hud ya kuman na nagdaram,’ kummuy a itta la ya liwat muy, te awemuy kurugan ya maita muy,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“A pake nonotan muy mina ya takday para uhohug ku tekamuy,” kun ni Hesus tekid. “Am itta ya simarok ta agiafunan na kalneru kiden, ammi awena simarok ta agyan na irwangan, te apagan na ya takwan na unekan na, a talaga ta tulisan yen nga ange magtakaw ta kalneru kiden. ");
INSERT INTO agt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ammi ya simarok hala ta agyan na irwangan a amu tam ta intu hala ya dafu na kalneru kiden nga magtaron tekid, ");
INSERT INTO agt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","te intu hapa la ya ihukat na maggwardya en ta irwangan. A mengahalan da hapa na kalneru na kiden, te am iuhet na kid a baran na kid ta ngagan da. ");
INSERT INTO agt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","A sangaw am sa nelattog na kid na a intu ya imunnan, te enna kid itulud ta agyan na pangipastun na tekid. A dumadagdag kid hapa, te intu ya mengahalan da. ");
INSERT INTO agt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aweda hapa dumagdag ta aweda en amu am awa pagbilagān da hud la, te aweda mengahalan ya bakkanen ta dafu da,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yen hala ya addet na keangarigan ni Hesus ta Hudyo kiden, ammi aweda nanonot am anu ya ikayat na uhohugan tekid. ");
INSERT INTO agt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","A gafu ta aweda manonot a pake nepasikkal na ha tekid. “Pake ibar ku mantu ya kustu tekamuy ta iyak ya manaron ta kalneru kiden. ");
INSERT INTO agt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","A ya ngamin kiden napopolu ammi teyak nga ape magtaron ta tolay kiden, a kuman kid na tulisan nga magtakaw ta kalneru kiden, te matulad kid na magtaron. A yen ta aweda kid dinangag na kalneruk kiden. ");
INSERT INTO agt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iyak hapa ya kuman na irwangan, a maski am inya ya mayat simarok teyak a mekerutan hala, a alawa hapa sangaw ya pagbalabalittagan na petta makaapag ta magserbi tentu. ");
INSERT INTO agt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ammi ya kuman na tulisan a ikayat na la ange magtakaw ikid na mamapapasi ikid na mangikutkutet. Ammi teyak a yen ta itta yak ta paglelehutin petta matolay la ya kuman na kalneruk kiden gafu teyak, te iatad ku la tekid ya angaten nga awan pulus ta pagaddetan. ");
INSERT INTO agt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“A iyak para ya kuman na mappya na manaron ta kalneru kiden, te ya mappya na manaron a isagapil na hala ya angat na ta taronan na kiden, petta mekerutan kid. ");
INSERT INTO agt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ammi ya gagangay na mangallu en magtaron, a am maita na ya kuman na maporay na atu nga ange mamapasi ta kalneru kiden a pakimohayan na hala ya kalneru kiden, te pagbilagān na kid, te bakkan ta intu ya makākwa tekid. A malogon sangaw ya panggafut na atu en tekid, a mekutukutet kid na. ");
INSERT INTO agt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A pagbilagān na kid hala na mangallu en, te awan ta pangkenga na ta kalneru kiden, te bakkan ta intu ya makākwa. ");
INSERT INTO agt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ammi teyak hapa la a mappya yak na manaron, te magkākofun kami na ngamin kwak ta kuman na pagkākofun mi ni Damakewan. A isagapil ku hapa sangaw ya angat ku tekid, petta mekerutan kid. ");
INSERT INTO agt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“A itta para ya kadwan kiden kalneruk nga awan nedagga ta agiafunanin yan, a mappya ta yen kid hapa ya padagdag ku. A dumadagdag kid hala sangaw am madangag da ya ngahal ku, pettam kumanen a sa magdadagga sangaw ya ngamin kiden kalneruk, a iyak la tatakday ya dafu da nga magtaron tekid. ");
INSERT INTO agt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","A yen ta iddukan nak ni Damakewan te isagapil ku hala ya angat ku tekid, ammi metoli hala sangaw teyak. ");
INSERT INTO agt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Awan ta makapapasi teyak am bakkan la ta iyak ya makāuray, te itta ya pakapangwak nga mangisagapil ta angat ku, yaga itta hapa ya pakapangwak nga mangtolay ta barikin hapa la, te yen hala ya nepatudun ni Damakewan teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","A gafu ta binida ni Hesus ta Hudyo kiden a yen ya nagkakattwayan na nonot da tentu. ");
INSERT INTO agt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","“Annun tam hud dangdangagan ya tolayin yan. Itta malat ya anitu na nga mangpaguyung tentu,” kun na kadwan. ");
INSERT INTO agt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ammi ta kadwan a “Bakkan ta kumanin ya uhohug na seanitu, te yaga makapaladdang hud ya anitu ta mata na daram?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","A sangaw ta kaarawan na agirid a itta hapa ya pyesta ta ili na Herusalem nga mangaganan ta Pyesta na Pangigawat. ");
INSERT INTO agt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","A nagpapa-yat la i Hesus ta pagsigonganen nga nepapadday ni mina Ari en Solomun ta agyan na simbaanen. ");
INSERT INTO agt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A tentu en nagpapa-yat a enna kinalihung na pinakadakal na Hudyo kiden a ya nebar da tentu a “Annun na kami biga popoyungan? Am kakurugan ta iko ya Mangikerutan nga dinob na Namaratu ewan a mappya ta pake ibar mu mina tekami,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","“A nebar kun paen tekamuy, ammi awemuy garay mangurug,” kunna. “Te ya ngamin kiden tinarabakuk gafu ta pakapangwa ni Damakewan a yen kid hala ya mangipasikkal teyak. ");
INSERT INTO agt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ammi gagangay ta awemuy mangurug te awemuy negitta ta kalneruk kiden. ");
INSERT INTO agt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Te ya tolay kiden nga negitta ta kalneruk a amu da ya ngahal ku, a kanayun dagdagan dak, te kofun dak. ");
INSERT INTO agt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A aweda hapa sangaw melogot ta pasi da, te iyak hapa ya mangiatad ta magnayun na angat da. A awan sangaw ta makagubat tekid ta kamat ku. ");
INSERT INTO agt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Te ya Damakewan ya nangipaibbal tekid teyak a masmasikan haman ammi ta ngamin, a itta hud ya makagubat tekid ta kamat na, ");
INSERT INTO agt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","te ikami ni Damak a tatakday kami,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","A ta pakadangag na Hudyo kiden ta uhohug ni Hesus a nagakut kid na ta batu, te pangpapasi da mina tentu gafu ta inuhohug na en. Ammi ya uhohug ha ni Hesus tekid a ");
INSERT INTO agt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","“Addu haman ya nepaitak tekamuy nga mappya gafu ta pakapangwa ni Damakewan, a had sin mantu tekid ya gafu na pangpapasin muy teyak?” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","“Bakkan ta mappya na tarabaku ya gafu na pangpapasin mi teko am awa panadakat mu ta Namaratu ewan, te maski tolay ka a igittam haman ya barim ta Namaratu,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","“A te awemuy de manonot ya uhohug na Namaratu ta lebru na lintig na kiden, te ya uhohug na a ‘Nebar ku paen ta kagitta na kam na Namaratu, te anak kam ngamin na Kata-nangan na Dyos,’ kunna. ");
INSERT INTO agt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","A am nengagan na mantu ta Dyos ya dadagkal tam kiden nga pinasinapan na ta uhohug na, anna awena mabalin ta mauli ya uhohug na en, ");
INSERT INTO agt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","a panadakat ku hud am ibar ku ta Anak nak na Namaratu ewan, bakawa iyak haman ya pinasinapan na ikid na pinakabari na nga nedob na ta paglelehutin. ");
INSERT INTO agt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","A am awek mina tarabakun ya kagitta na tarabaku na Namaratu a awedak mina kurugan, ");
INSERT INTO agt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ammi gafu ta yen hala ya tarabakun ku a yen mina ya pangurugan muy teyak maski am awemuy kurugan ya uhohug ku tekamuy, pettam kumanen a amu muy ikid na mapasikkal muy ta itta ya Namaratu teyak, anna intu hala ya pagtolayan ku,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","A gafu ta uhohug na en a negakkad da la gafutan, ammi nakalillik hala tekid. ");
INSERT INTO agt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","A umange ha ta dammang na Karayan na Hurdan ta agyan na nangzigutan ni Hwan ta tolay kiden ta palungu, a nagyan bit la ten, ");
INSERT INTO agt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","a umange hapa sangaw ya addu na tolay tentu. A ya uhohug na kadwan ta kahulun da kiden a “Maski am awan ta iningwa ni Hwan ta masikan na pakaitan a kakurugan hala ya ngamin binida na ta tolayin yan,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","A addu para ya nangurug te Hesus ta iten na lugar. ");
INSERT INTO agt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","A medyo nabayag ta assang a itta ya takday lalaki nga taga ili na Betanya nga nagtakit. I Lasaru ya ngagan na, a kabagis hapa ni Mariya ikid ni Marta. ");
INSERT INTO agt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","I Mariya hapa ya babbayen nga nangiluggud ta bangog ta takki kiden ni Hesus kapye na nepuhid ya huk na en tekid. ");
INSERT INTO agt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","A gafu ta takit na kabagis da en Lasaru a nangidob kid ta ange mangibar te Hesus. A ya nebar na dinob da en a “Afu, pake nagtakit kan ya kofumen,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ammi ta pakadangag ni Hesus ta damag na en a “Bakkan ta pasi na ya takit na ina, am awa pakaitan na sangaw na pakapangwa na Namaratu ewan, petta maita hapa sangaw ya pakapangwa na Anak na Namaratu gafu tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","A pake inidduk ni Hesus ig Lasaru ikid na kabagis na kiden Marta ikid ni Mariya, ");
INSERT INTO agt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","7","ammi tentu en nakadangag ta takit ni Lasaru a nagyan hala ta nagyanan na en abat ta dwangagaw. A sangaw binaran ya ituldu na kiden petta mehulun kid tentu nga ange ha ta iten Hudeya. ");
INSERT INTO agt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ammi ya uhohug da hapa tentu a “Anu haman ta magtoli kan ta iten, Afu, bakawa awena para la nabayag addet ta nepangpator da mina teko na kagittam kiden nga Hudyo,” kunda hapa tentu. ");
INSERT INTO agt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","A ya netabbag na hapa a “Awena hud kustu na oras kiden ta araw tam, petta am maghehit ya tolay ta ketta para la na araw a awena sangaw melogot, te malogon makaita ta dakaren. ");
INSERT INTO agt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ammi am indagan na ya hiklam kapye na maghehit a malogon sangaw melogot, te awan ta dakar na,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nepaguhohug na ta kumanen a “Nasidug na ya kofun tamen Lasaru, ammi e yak na hukalan,” kunna ha. ");
INSERT INTO agt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","“A am makakasidug na, Afu, a mappya yen, te magmappyan hala sangaw ta takit na en,” kunda hapa otturu. ");
INSERT INTO agt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Te pahig da ta ikayat na uhohugan ya pakasidug na ta kuman na mabannag, ammi ta kakurugan a ikayat na uhohugan ya pasi ni Lasaru. ");
INSERT INTO agt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","A gafu ta kumanen a pake nebar na ta mappya tekid: “Nasin haman i Lasaru, ");
INSERT INTO agt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","a maski am awanak tentu ta nepagtakit na en a matalakak hala gafu tekamuy, petta itta sangaw ya maita muy nga mangpasikan ta pangurug muy teyak. A aranan, te entanan la tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","A ya uhohug hapa ni Tomas ta kadwan kiden kahulun na a “Entanan mantu hulunan, petta sa mahahulun kitam magpasi,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","A ta datang nig Hesus ta iten Betanya a nadangag na ta nabalin na netanam i Lasaru abat ta appat na araw. ");
INSERT INTO agt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","A gafu ta abikan ya lugar na Betanya ta ili na Herusalem a umange hapa kumahad ya addu na Hudyo taga Herusalem teg Marta ikid ni Mariya, te petta tabtabangan da ya damdam na babay kiden ta kabagis da en nasi. ");
INSERT INTO agt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","A ta pakadangag ni Marta ta dumatang na hapa i Hesus a enna hapa dinafung, ammi nasirak hala i Mariya ta bali da en nga imatogkok. ");
INSERT INTO agt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","A ya uhohug ni Marta ta pagdafung na en te Hesus a “Ay, Afu, am dana itta kan mina sin a awena mina nasi na kabagis ken. ");
INSERT INTO agt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ammi maski kunna ten a amuk ta maski am anu ya adangam ta Namaratu a iatad na hala teko,” kunna ha. ");
INSERT INTO agt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","“Matolay hala sangaw ya kabagis men,” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“A amuk hala yen, Afu, te matolay kan hala sangaw ya ngamin kiden nagpasi ta araw na angtolay ta pagaddetan na arawin yan,” kunna ha ni Marta. ");
INSERT INTO agt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","A ya uhohug para ni Hesus tentu a “Iyak hapa la ya agtolay, te iyak la ya pagafun na angat. A maski am masi ya mangurugen teyak a matolay hala. ");
INSERT INTO agt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","A ya ngamin kiden matolay gafu ta pangurug da teyak a aweda sangaw mapidwa masi maski am kanu, te ittan ya angat da nga magnayun. Kurugam na de ya uhohug kin, Marta,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“A kurugan ku ay, Afu, te iyak la takday a dana nangurugak na ta iko ya Anak na Namaratu ewan, ikid na Mangikerutan nga umange kan ta lutakin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","A ta kabalin na nepangtabbag na en a nagtoli ta bali na, a nagan-anisat ta kabagis na en Mariya. “Ittan ya Mistro en, a paayagan na ka hapa,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","A alistu imikkat i Mariya, a umange hapa te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ammi awena para la nakadulot ig Hesus ta agyan na babali kiden, te itta kid para la ta nangdafungan ni Marta tentu. ");
INSERT INTO agt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","A ta nepagtugut ni Mariya ta bali a dumadagdag hapa ya tolay kiden nga umange manabtabang ta damdam na en, te naita da tentu en imikkat, ammi pahig da ta ange ta agyan na tanamen magtangit. ");
INSERT INTO agt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","A ta datang ni Mariya ta agyan ni Hesus a pa itan na bit kapye na umange nagtakab ta takki na kiden nagtangit. “Ay, Afu, am dana itta kan mina sin a awena mina nasi na kabagis ken,” kunna hapa tentu. ");
INSERT INTO agt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","A ta nepakaita ni Hesus ta pagtangit na en ikid na dumadagdag kiden hapa a nanalasigak ta damdam na nonot na en hapa. A ya uhohug na hapa a ");
INSERT INTO agt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Had mantu ya nangitanaman muy tentu,” kunna hapa tekid, a “E ka hala sin, Afu, te itam,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","A nagtangit na hapa i Hesus. ");
INSERT INTO agt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","“Itan muy awa dakal hapa ya idduk na ta nasi en,” kun na Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ammi ya uhohug na kadwan tekid a “Intu hala ya nakapaladdang ta mata na daramen, a anu kawagan na mantu ta awena kinahadan i Lasaru petta awena mina nasi?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","A ya lugar na nangitanaman da te Lasaru a kuman na kweba, a namunitan hapa ta dakal na batu. A ta datang da ta agyan na tanam na en a nanalasigak ha i Hesus, kapye na naguhohug. ");
INSERT INTO agt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Azin muy haen ya batu ina,” kunna. Ammi nehangat na mina ni Marta, “Dulay de, Afu, am maazi, te pake mahuyuk na de, te mekappat na araw na,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","“Awek hud nebar teko ta maitam hala sangaw ya pakapangwa na Namaratu ewan am mangurug ka?” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","A inazi da mantu ya batu en. Nekaazi na batu en a tumangad hapa i Hesus nakimallak. “Amang, matalakak teko te dana dinangag nak. ");
INSERT INTO agt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","A amuk hapa ta kanayun dangagan nak, ammi inuhohug ku yen petta madangag da hapa na tolay kidin mangkalihung ta isin, petta pangurugan da mina ta iko ya nangidob teyak,” kun na pakimallak na en. ");
INSERT INTO agt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","A tentun nakauhohug ta kumanen a pake nagayag ta masikan. “Lasaru, imuhet kan,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A limattog hala ya nasi en, ammi nafutfutan para la ta ga-gamit ta ulu na en abat ta takki na kiden, a nabadbadan hapa ya simid na ta panyaw. “Azin muy na ya nefutefut kiden, petta makatugut,” kunna hapa ni Hesus. ");
INSERT INTO agt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","A ya Hudyo kiden nga nakihulun teg Mariya a mangurug kid na hapa te Hesus gafu ta iningwa na ta nasi en nga naita da. ");
INSERT INTO agt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ammi ya kadwan tekid a umange kid ta Pariseyu kiden petta ipadamag da ya iningwa ni Hesusen. ");
INSERT INTO agt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","A ta nepakadamag na Pariseyu kiden a sa nagmamiting kid na padi kiden ikid na kadwan kiden pinakadakal na Hudyo kiden. A ya bida da hapa a “Anu awan haman ta kwan tam, te addu para ya kwan na tolayin yan nga pagpaka-latan na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","A am awetam pagimmangan ya tarabaku na in a sa mangurug sangaw ya ngamin tolay ta intu ya ari da, a magribelde kid na sangaw ta gubyernu na taga Roma kiden. A yen sangaw ya ange na suddalu kiden taga Roma petta kutkutetan da ya lugar na pangdayawan tam ta Namaratu kontodu tolay tam kiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","A sangaw naguhohug hapa i Kaypas tekid, te intu ya kadakalan na padi kiden ta darunin yen. ");
INSERT INTO agt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","“Kuga makilavun kanan ta isin, te awemuy para manonot ta kappyanan tam ta takday la mina ya masi nga metali ta tolay kiden, petta bakkan ta sa ikitam ya mapapasi,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ammi awena amu ta itta hapa ya takwan na kebalinan na inuhohug na en. A gafu ta intu ya kadakalan na padi kiden ta darunin yen a uray na Namaratu ta linavun na ya pasi ni Hesus nga mangikaru ta liwat na ngamin kiden Hudyo. ");
INSERT INTO agt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ammi bakkan la ta liwat na Hudyo kiden ya ikaru na am awa liwat na ngamin kiden tolay hapa nga bakkan ta Hudyo, petta mapatatakday ya ngamin kiden anak na Namaratu nga nesaned ta ngamin paglelehutin. ");
INSERT INTO agt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","A gafu ta uhohug na kadakalan da en nga padi ta nagkakampat kiden a yen ta nagbabidan da ya pangpapasi da te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","A yen ta awenan nakipapaita ni Hesus nga nakikihkihu ta Hudyo kiden, a nagtugut kid na ituldu na kiden ta lugar na Hudeya, te umange kid na ta ili na Eparim nga abikan ta alawa na kalafukan. A yen hala bit ya nagyanan da. ");
INSERT INTO agt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A sangaw tanagay na hapa ya Pyesta na Simana na Hudyo kiden, a naggagabi ya addu na Hudyo nga nagafu ta kadwan kiden babali, te ange kid na ta ili na Herusalem, petta dana baggawan da ya dulayen tekid ta kuman na pakkwa na lintigen kapye da makipyesta. ");
INSERT INTO agt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","A tekid gitayukan ta umag na simbaanen a angzen kid ta itan te Hesusen. “Anu ya uray muy, umange panaw i Hesus ta pyesta in?” kunda ta kahebing da kiden. ");
INSERT INTO agt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yen ya uhohug da, te ya padi kiden ikid na Pariseyu kiden a dana nangibar kid ta am itta ya makkamu ta agyan ni Hesus a ipakamu da mina tekid, petta enda gafutan. ");
INSERT INTO agt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","A ta mekannam na araw ta kaatubangan na Pyesta na Simana na Hudyo kiden a dumatang ha ig Hesus ta iten Betanya nga lugar ni Lasaru en nga tinolay na ta pasi na en. ");
INSERT INTO agt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","A gafu ta datang ni Hesusen a nangiparan ya kadwan kiden tolay ta dakal na pagpamakan ta pangdayaw da tentu. I Marta ya nangiparan ta kanan, a i Lasaru ya takday nakiatubang te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","A tekiden nagkakan a nangalap i Mariya ta garapon na pake mangina na bangog nga dipuru nardu. A enna neluggud ya bangogen ta takki kiden ni Hesus, a sangaw pinuhidan na kid ta huk na en. A nesaned hapa ya bangogen ta ngamin lagum na bali en. ");
INSERT INTO agt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Ammi i Hudas Iskaryote nga takday ituldu ni Hesus a nehuya na i Mariya. “Anu awena nelaku ya bangogina, petta meatad ya paga na ta pobre kiden nga mazigatan? Pade awa magamid na ya lugar na tandan ta tādarun,” kunna. Intu hala sangaw ya mangitalaba te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A awan haman ta pangkenga na ta pobre kiden, ammi inuhohug na yen, te intu hala ya mangifun ta sufuten nga aggiappiyan da ta pirak da en, a gafu ta mangtakaw a kanayun nangalap ta nesufut da en. ");
INSERT INTO agt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ammi ya uhohug ni Hesus tentu a “Awem la ihuya ya babbayin, te dana neappiya na yen petta iluggud na ta barikin nga meparan ta araw na ketanam ku. ");
INSERT INTO agt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sigida itta haman ya pobre kiden tekamuy, ammi teyak a awek mabayag tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","A gafu ta pyesta en ta ili na Herusalem a pake addu ya Hudyo kiden nga umange, a nadamag da ta ittan ha i Hesus ta iten Betanya. A yen ta umange kid hapa ten, te enda itan i Hesus. Ammi bakkan la te Hesus ya enda itan am awa Lasaru hapa nga tinolay ni Hesus ta pasi na en. ");
INSERT INTO agt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","A gafu ta kumanen a nagtatulag ya padi kiden nga mamapasi hapa te Lasaru, ");
INSERT INTO agt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","te i Lasaru ya gafu na pagtalekud na addu na Hudyo kiden ta padi kiden petta mangurug kid na te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","A ta pagtalib na araw a itta para la ya pake addu na tolay nga umange nakipyesta ta ili na Herusalem, a nadangag da ta ange hapa i Hesus ta pyesta en. ");
INSERT INTO agt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","A nangalap kid mantu ta addu na don na kuman na anyog, a enda kid nepaypay te Hesus ta pangdayaw da tentu. A nagayayag kid na hapa. “Madaydayaw ya Namaratu ewan. Bendisyonam, Afu, ya umange in sin ta ngagam. Bendisyonam ya Ari na Istralita kiden,” pakakin kid. ");
INSERT INTO agt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","A nagtakay hapa i Hesus ta urbun na kabayu nga nepaalap na. A yen ya nagdulotan na dana en uhohug ta Bibliya gafu tentu, te ya uhohug na suraten a ");
INSERT INTO agt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Awemuy na magburung, ikamuy taga Herusalem, te itan muy, dumatang na ya ari muy nga magtakay ta urbun na kabayu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ammi ta ituldu kiden ni Hesus a aweda bit nanonot ya suraten addet ta pagtoli ni Hesus ta langit, a yen ya nepakanonot da ta itta ya dana en surat nga nangilavun ta pagtakay ni Hesus ta kalakabayu en. ");
INSERT INTO agt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A ya tolay kiden nga nakaita te Hesus tentu en nangtolay te Lazaru, a nepadpadangag da hapa ya naita da. ");
INSERT INTO agt_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","A yen ta umange ya addu na tolay nga nangdafung te Hesus, te nadamag dan ya pakapangwa na gafu te Lasaru. ");
INSERT INTO agt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","A yen ta nagburung na hapa ya Pariseyu kiden. “Itan muy awa awan haman ta mabalin tam, te sa dumadagdag ya ngamin tolay tentu,” kunda ta sakā Pariseyu da kiden. ");
INSERT INTO agt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","A ta neange na Hudyo kiden ta pyesta en nga makimallak ta simbaan na Namaratu a nekihkihu hapa tekid ya kadwan kiden Giregu nga dana simarok ta relisyon na Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","A gafu ta ikayat da hapa makkamu te Hesus a enda bit nebar te Felipe; “Ser, ikayat mi haen makibidan ta dafu muyen Hesus,” kunda te Felipe, te intu ya takday ituldu ni Hesus nga taga Betsayda ta lugar na Galileya. ");
INSERT INTO agt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","A enna kid mantu nebar te Andres, a ig Andres ikid ni Felipe ya umange nangitulud ta Giregu kiden te Hesus, a nebar da kid tentu. ");
INSERT INTO agt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","A ya tabbag ni Hesus tekid a “Ittan mantu ya araw na pakepaita na pakedayawan na Tolayin Taga Langit, ");
INSERT INTO agt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","te ya ibar ku tekamuy a mappya ta metanamak sangaw ta lutak ta kuman na mait. Te am awena memula na maiten ta lutak a awena sangaw lumattog na angat na en, ammi am memula a magmayan hapa sangaw ta addu, a kumanen hapa teyak. ");
INSERT INTO agt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","A kumanen hapa tekamuy, te am kengan muy mina ya katolay muy sin a mawakay mantu sangaw ya katolay muy nga magnayun. Ammi am awemuy la nonotan ya katolay muy ta paglelehutin yan a meappiya hala ya katolay muy nga magnayun. ");
INSERT INTO agt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","A am itta tekamuy ya mayat makidafu teyak a mappya ta kanayun dumagdag hala teyak, petta maski am had ya eyan ku a yen hapa ya agyan na. A maski am inya tekamuy ya makidafu teyak a ya Damakewan Namaratu ya makkamu mangpadayaw tentu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","A ya uhohug na para tekid a “Kuga mapopoyung na ya nonot kin, te kuman na makimallakak mina te Damakewan petta ikerutan nak mina ta zigatin nga dumatang teyak. Ammi awek la, te yen haman ya gafu na neangek ta lutakin petta idulot ku la ya magattam ta zigatin yan,” kunna. A sangaw nakimallak hapa ta ");
INSERT INTO agt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Amang, kompormi la ya dumatang teyak petta mepaitam hapa ya pakedayawam gafu teyak,” kunna. A ka-ma la itta ya nagsitang ta langit, “Dana nepaitak na ya pakedayawan ku teko, a pidwan ku hala sangaw,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A ya tolay kiden gitayukan ta bikat nig Hesus a nedangagan da hapa ya nagsitangen, a pahig na kadwan ta nagdalak, ammi ta kadwan a “Naguhohug de ya anghel na Namaratu tentu,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ammi ya uhohug ni Hesus tekid a “Awemuy la pahig ta iyak la ya kauhohugan na nagsitangen am awa ikamuy hapa. ");
INSERT INTO agt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","A tanagay na hapa ya pangpa-gang na Namaratu ta liwat na tolay kiden. A megindan hapa ya pangabak ku ta akkimohayanen nga makkamu ta ngamin dulay ta paglelehutin. ");
INSERT INTO agt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Te sangaw am pinagappa dak ta kayu, a yen sangaw ya panggamid ku ta ngamin tolay petta mangurug kid teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","A inuhohug na ye-yen, te dana pangibar na tekid am had kunna sangaw na pasi na. ");
INSERT INTO agt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ammi tumubbat hapa ya tolay kiden nga magpohut tentu. “Annum haman ibar ta magappa sangaw ya Tolayen Taga Langit ta kayu? Te ya nadangag mi ta Bibliya a magnayun hala sangaw ya idob na Namaratu nga Mangikerutan. A am iko hala yen a inya mantu ya Tolayen Taga Langit?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","A ya tabbag hapa ni Hesus tekid a “Assang para la ya ketta na dakar tekamuy kapye na limitap. Mappya mantu ta yen ya dagdagan muy petta awena kam madatangan na sugiram. Te ya magtugut ta sugiram a awena amu am had ya eyan na. ");
INSERT INTO agt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mappya ta ikatalak muy ya dakaren ta ketta na en para la tekamuy, petta magbalin kam hapa ta kuman na anak na dakar,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","43","(-) ");
INSERT INTO agt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","A ta nepangkasaba ni Hesus ta tolay kiden a pinasikan na ye-yan na uhohug tekid: “Am itta ya mangurug teyak a bakkan la ta iyak ya kurugan na am awa nangidoben teyak hapa. ");
INSERT INTO agt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","A ya nakaita teyak a naita na hapa i Damak. ");
INSERT INTO agt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iyak hala ya kuman na dakar nga lumattog ta paglelehutin, petta am itta ya mangurug teyak a awenan sangaw magdanang ta sugiram na en. ");
INSERT INTO agt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ammi ya makadangag ta uhohug ku otturu baybay-an na la gafu ta awena itug a melogot hala sangaw ta pakapa-gangan na. Ammi bakkan ta iyak ya mangpa-gang tentu, te bakkan ta yen ya neangek isin petta mangpa-gangak ta tolay, te iyak hala ya mangikerutan tekid. ");
INSERT INTO agt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ammi ya awanen mangpadulot teyak gafu ta aweyan na ya uhohug ku a mapa-gang hala sangaw ta pagaddetan na arawin yan gafu ta inuhohug ken nga awena kinurug. ");
INSERT INTO agt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Te bakkan haman ta uhohug ku ya neuhohug ku tekamuy am awa uhohug ni Damakewan nga nangidob teyak, te intu hapa la ya nangibar teyak ta ngamin uhohugan ku ikid na bidan ku tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A amuk hapa ta itta ya pakapangwa na uhohug na kiden nga mangtolay tekamuy petta magnayun kam, am mangurug kam. A awan mantu ta uhohugan ku tekamuy am bakkan la ta kuman na nepeuhohug ni Damakewan teyak,” kunna. A tentun nakauhohug ta kumanen a nagtugutan na kid, a nagtagun na kid. (v 37) A maski addu ya iningwa ni Hesus nga pakaitan na pakapangwa na en ta atubang na Hudyo kiden a aweda la kurkurugan. (v 38) A gafu ta aweda nangurug a yen ya pagdulot na uhohug ni mina Isayasen nga nepesurat na Namaratu tentu, te ya uhohug na a “Awan haman ta mangurug, Afu, ta nepadangag mi tekid. A maski naita da ya pakapangwam a aweda la netug,” kunna. (v 39) Ammi awena mabalin ta mangurug ya Hudyo kiden, te ya uhohug ni mina Isayasen ta takday ha na surat a (v 40) “Kuman na pinagdaram na Namaratu ya mata da petta aweda makaita. A pinagtuyag na ya nonot da petta aweda makanonot ikid na magbabawi ta liwat da. Te am magbabawi kid mina a gagangay kan ta pagmappyan na kid,” kunna. (v 41) A yen ya nesurat ni mina Isayasen, te gait-itan na ya pakedayawan ni Hesus, a intu hala ya binida na. (v 42) Ammi maski kunna ten a addu hala ya nangurug ta pinakadakal na Hudyo kiden, ammi aweda la nebosag gafu ta talaw da ta Pariseyu kiden, te aweda ikayat ya madugiman ta kapilya da en, (v 43) te intu hud la ikaykayat da ya pangdayaw na tolay tekid ammi ta pangdayaw na Namaratu. ");
INSERT INTO agt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","3","A ta kaatubangan na Pyesta na Simana na Hudyo kiden a narikna ni Hesus ta tanagay na ya pagtugut na ta lutakin petta magtoli ta agyan na Dama na ewan Namaratu. A gafu ta pinagpatu ni Satanas i Judas Iskaryote a dana negakkad na ya pangitalaba na te Hesus petta enna gafutan na Hudyo kiden. A amu hapa ni Hesus ta intu ya pinaguray na Dama na en ta ngamin dumatang tentu, anna tanagay na magtoli te Dama na en nga naggafun na ta idi. A yen ta pinagammung na ya ituldu na kiden petta makikkanan kid ta pamurab na pyesta. Pake inidduk ni Hesus ya ituldu na kiden nga masirak ta paglelehuten, a ikayat na ipasikkal ya idduk na tekid kapye na gafutan na Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","A yen ta imikkat ta namuhaban da en kapye na inazi ya salnuk na en, kapye na hapa nehakkat ya tuwalya. ");
INSERT INTO agt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","A sangaw tinunan na ya palanggana ta danum, a pinegafwanan binaggawan ya takki na ituldu na kiden, otturu pinuhidan na kid hapa ta tuwalya en nga nehakkat na. ");
INSERT INTO agt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A tentu namegafu nangbaggaw ta takki kiden ni Pedru a awena ikayat; “Atsi O, Afu, iko hud mina ya mangbaggaw ta takkik kidin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","“Awem para la amu, Pedru, ya gafu na pangbaggaw ku ta takkim kiden, ammi amum hala sangaw,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","“Atsi O, Afu, awek pabaggaw ya takkik kidin teko,” kunna ha. “A am awem kid pabaggaw teyak a awan sangaw ta kesipatam teyak,” kunna ha ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","“A bakkan mantu la ta takkik, Afu, am awa ngamin kamat ku hapa, kontodu uluk,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A ya uhohug ha ni Hesus tentu a “Am dana nabalin kan nagzigut a awem na pidwan ya pazigut, te nabaggawan na ya ngamin barim. Ammi mappya ta mabaggawan ha ya takkim kiden, te matapangan kid ta dalan. A mappya te sa nabaggawan kanan, ammi fwera ta takday la tekamuy,” kunna, ");
INSERT INTO agt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","te dana amu ni Hesus am inya sangaw ya mangitalaba tentu, a yen ta “fwera ta takday la tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","A ta kabalin na nangbaggaw ta takki da kiden a nagsalnuk ha, kapye na nagtoli ta angnganan da en. A pake nepasikkal na ya nepaita na tekid; “Amu muy panaw ya gafu na pangbaggaw ku ta takki muy kidina? ");
INSERT INTO agt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ikamuy nga itulduk a ingagan dak ta ‘Mistro,’ ikid na ‘Afu,’ a kustu hapa, te kakurugan haman. ");
INSERT INTO agt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","A am dafu muy ikid na mistro muy ya nangbaggaw ta takki muy kiden a mappya ta magimbaggaw kam hapa ta takki muy kiden. ");
INSERT INTO agt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Te kuman na keangarigan ya nepaitak tekamuy, petta umalinnak ya nonot muy ta kuman na nepaitak tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A pake ibar ku mantu tekamuy ta awemuy mina pahig ta malmalalaki kam ammi ta dafu muyen nga nangidob tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Am amu muy ya ikayat ku uhohugan tekamuy, a matalakan kam sangaw am yen ya idulot muy. ");
INSERT INTO agt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ammi itta hala ya takday tekamuy nga awan mesipat ta bidan ken tekamuy, a maski am intu ya takday nepadagdag ku a dana amuk ta takwan hala ya nonot na. Ammi mappya ta kunna ten petta magdulot hala sangaw teyak ya kuman na nesurat ta Bibliya, te ya uhohug na suraten a ‘Nekuyat nak na nakikkanan teyak,’ kunna. ");
INSERT INTO agt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“A dana nebar kun yan tekamuy ta awena para la magdulot, petta sangaw am nabalin na a mangurug kam ta iyak hala ya binida na suraten. ");
INSERT INTO agt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A pake ibar ku para tekamuy ta maski am inya sangaw ya magpadulot tekamuy gafu ta doban ta kam a mekwenta ta iyak hapa ya pagdulotan na. Kumanen hapa ta magpadulot teyak a mekwenta ta pagdulotan na ya nangidoben teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","A ta nepakauhohug ni Hesus ta isin a nagkarbaw hapa, kapye na pake nepasikkal ya dumatang tentu. “Kakurugan hala ya ibar ku tekamuy ta takday sangaw tekamuy ya mangitalaba teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","A gingit-ita la ya ituldu na kiden, te aweda amu am inya tekid ya ikayat na uhohugan. ");
INSERT INTO agt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","24","A gafu ta kahebing ni Hesus ya takdayen ituldu na nga pake kofun na a yen ya pinaypayan ni Pedru. “Ibar mu bit tentu am inya tekitam ya ikayat na uhohugan,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nagtahelig mantu ta radang ni Hesus ya kahebing na en, a nebar na ta “Afu, inya hud tekami ya ikayat mu uhohugan?” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","“Intu hala ya pangigawatan ku ta tāhukal na panin yan am nesawsaw kun ta zigu in,” kun ni Hesus. A ta nepangisawsaw na ta panen a negawat na hala te Hudas Iskaryote. ");
INSERT INTO agt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","A ta nekabalin ni Hudas nga nanggawat ta panen a yen hapa ya nesarok ni Satanas tentu. A ya uhohug hapa ni Hesus tentu a “Tarabakum na ya ikayat mu tarabakun,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","30","A alistu mantu imuhet i Hudas ta bali en ta hiklam para la. Ammi ta kadwan kiden nga nasirak ta lamesa en a aweda amu am anu ya ikayat na uhohugan ni Hesus tentu. Ammi gafu te Hudas ya mangibbal ta sufut na pirak da kiden a pahig na kadwan ta intu ya dinob ni Hesus nga ange gumatang ta magserbi tekid ta pyesta en, ono ange mangatad ta pobre kiden mazigatan. ");
INSERT INTO agt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","A ta nepagtugut ni Hudasen a nagbida ha i Hesus. “Sangaw ta ayanin a mepasikkal ya kalalaki na Tolayen Taga Langit, a kumanen hapa ta kalalaki na Namaratu ewan. Te Namaratu ya mangipasikklal ta intu kalalaki na Anak na en ya kagitta na kalalaki na en hapa la, a tanagay na ya pangipasikkal na. ");
INSERT INTO agt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“A ya ibarku mantu tekamuy, ānāk ku, a mangananwanak la tekamuy kapyek magtugut. A apagan dak hapa sangaw, ammi ibar ku tekamuy ya kuman na inuhohug ku ta pinakadakal na Hudyo kiden ta awemuy makaange ta eyan ku. ");
INSERT INTO agt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","A gafu ta awedak sangaw maita a itta mantu ya bagu na bilin ku tekamuy, te ya ibilin ku tekamuy a magkaid-idduk kam ta kuman. Ta kuman na nepangidduk ku tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Te am sigida magkaid-idduk kam a yen sangaw ya pakaitan na ngamin tolay ta iyak ya dagdagan muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","A ya pohut hapa ni Pedru tentu a “Had mantu ya eyam, Afu?” kunna. “Awem la pahig ta mehulun ka, Pedru, te awem para la makaange ta eyan ku, ammi dumagdag ka hala sangaw,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“Anu awek mehulun teko maski ta ayanin, Afu, te maski isagapil ku hala ya angat ku teko,” kunna ha. ");
INSERT INTO agt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","“Pahig mu hud ta itta ya turad mu nga mangisagapil ta angat mu teyak? Pake ibar ku teko ta mamentallu ka sangaw nga mangilemad ta pakkamum teyak ta awena para la pagtareknay na manuk,” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","A ya uhohug para ni Hesus ta ituldu na kiden a “Awemuy mina pagpopoyungan ya nonot muy gafu ta pagtugut ku tekamuy, te ikatalak muy la ya Namaratu, a kuman en hapa teyak. ");
INSERT INTO agt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Te maski magtugutak a eyak mangiparan ta pagyanan rnuy ta bali ni Damakewan, te addu hapa ya pagyanan ta bali na en, a awek mina nebar tekamuy am awa kustu. ");
INSERT INTO agt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","A gafu ta eyak mangiparan ta pagyanan rnuy a tolin ta kam hapa sangaw, te alapan ta kam sangaw teyak, petta magyan kam hapa la teyak. ");
INSERT INTO agt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A mappya hapa, te amu muy hala ya eyan ku ikid na dalan,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ammi ya uhohug hapa ni Tomas a “Pa-pa-nun mi hud makkamu ta dalanina, Afu, bakawa awemi haman amu ya lugarina nga eyam,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","A ya tabbag ni Hesus a “Maski dumagdag kam teyak, te iyak ya kuman na dalan muy. Awan ta makadulot te Damakewan am awena dumagdag teyak, te iyak ya pagyanan na kakurugan ikid na pangalapn muy ta angat muy. ");
INSERT INTO agt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","A am kurug ta amu dak a amu muy mantu i Damakewan, a mamegafu ta ayanin a amu muy, te naita muy na,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","A ya uhohug hapa ni Felipe tentu a “Afu, pake ipaitam ya Damam tekami a matappag kamin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","“Anu nabayagak na haman tekamuy, Felipe, a awem para la amu am inya yak. Ya nakaita teyak a naita na hapa i Damak. Annum mantu ibar ta ipaitak i Damak tekamuy? ");
INSERT INTO agt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Awem hud mangurug, Felipe, ta itta i Damakewan teyak, a intu hala ya pagtolayan ku? A maski ya ngamin inuhohug ku tekamuy a awek haman neuroray neuhohug, te i Damakewan ya itta teyak, a ya tarabakuk a tarabaku na hapa. ");
INSERT INTO agt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","A mappya ta kurugan muy ya uhohug ken ta itta i Damakewan teyak ikid na intu hapa ya pagtolayan ku, ammi am mazigat ya mangurug ta uhohug ken tekamuy a ya tinarabakuk mina ya pangurugan muy. ");
INSERT INTO agt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“A pake ibar ku para tekamuy ta maski am inya tekamuy ya mangurug teyak a makkwa na hapa sangaw ya kuman na tinarabakuk. A maski dakdakal para ya makkwa na ammi ta iningwak, te itta yak sangaw ta agyan ni Damakewan, ");
INSERT INTO agt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","petta maski am anu ya adangan muy ta lugar na ngagan ku a iyak hala sangaw ya makkamu ta inadang muyen, petta maita hapa ya pakedayawan ni Damakewan gafu teyak. ");
INSERT INTO agt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pidwan ku: maski am anu ya adangan muy ta lugar na ngagan ku a iyak hala sangaw ya makkamu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“A am kurug ta iddukan dak a itug muy mantu ya pakkwak tekamuy, ");
INSERT INTO agt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","a magadangak hapa sangaw te Damakewan petta idob na sangaw tekamuy ya takday Manguffun nga megitta teyak, petta magnayun hala sangaw tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","A intu sangaw Kauffunan muy ya Kahalwa na Namaratu nga mangipakamu ta kakurugan tekamuy. Ammi ya awan kiden mangurug teyak a aweda ikatalak ya mangipakamu ta kakurugan tekamuy, te aweda manonot, a awan ta pakkamu da tentu. Ammi itta ya pakkamu muy tentu, te mehebing tekamuy ta ayanin, ammi itta hala sangaw ta umag na bari muy. ");
INSERT INTO agt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","19","“Ya ikayat ku uhohugan tekamuy a aweta kam iwarad, te itta yak sangaw tekamuy. Mavit la ta awenak sangaw maita na kadwan kiden tolay ta paglelehutin, ammi ikamuy sangaw ya makaita teyak, te matolayak sangaw, a matolay kam hapa gafu ta angat ku tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A sangaw am ittan ya arawin yen a yen ya pakkamu muy ta itta i Damakewan teyak, anna itta yak hapa tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","A ya mangitug ikid na mangidulot ta ngamin patarabakuk tekamuy a intu hala ya mangipasikkal ta pangidduk na teyak. A intu hapa ya pangipaitan mi ni Damakewan ta pangidduk mi tentu, a ukadan ku hapa ya nonot na petta pake amu nak,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","A ya takdayen Hudas nga bakkan ta mangitalaba en a nangpohut hapa te Hesus. “Anu kawagan na, Afu, ta ikami la sangaw ya pangipakamum ta barim, ammi awem isipat ya ngamin tolay?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","A ya tabbag ni Hesus tentu a “Maski am inya na tolay ya mangidduk teyak ikid na mangitug ta uhohug ku a yen ya iddukan ni Damakewan, a yen hapa ya emmi pakipagyanan. ");
INSERT INTO agt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ammi ya awan mangidduk teyak a awena ikayat itug ya uhohug ku. Ammi bakkan haman ta uhohug ku ya madangag muy am awa uhohug ni Damakewan nga nangidob teyak. ");
INSERT INTO agt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“A ye-yen kid na uhohug ya isirak ku tekamuy ta awek para la pagtugut tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ammi ya Kahalwa na Namaratu ya Manguffun sangaw tekamuy, te intu sangaw ya pinakabarik nga doban ni Damakewan, a ituldu na kam sangaw ta ngamin magserbi tekamuy, te pagnonotan na kam ta ngamin inuhohug ku tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“A ta ayanin a isirak ku hapa tekamuy ya pagintak na nonot muy, ammi bakkan ta kuman na pagintak na awan kiden makkamu teyak, te mesipat kanan ta pagintak na nonot ku. Awemuy mantu pagpopoyungan ikid na pagtalawan ya nonot muy. ");
INSERT INTO agt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nadangag muy paen ya uhohug ku tekamuy ta ‘Pagtugutān ta kanan, ammi pagtolin ta kam hala sangaw,’ kunku paen. A am kurug ta iddukan dak a awemuy mina magdamdam am awa makipagayayat kam mina teyak te dumatangak te Damakewan petta isipat nak ta pagturay na en. ");
INSERT INTO agt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","A nebar kun mantu yen tekamuy ta awena para la magdulot, petta sangaw am nabalin na a idulot muy la ya pangurug muy. ");
INSERT INTO agt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","A awek na makapagbayag maguhohug tekamuy, te dumatang na ya mamaddayen ta ngamin dulay ta paglelehutin, petta pagzigātan nak. ");
INSERT INTO agt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","A maski awan ta makmakkwa na teyak a ituluk ku hala ya barik tentu ta kuman na pakkwa ni Damakewan teyak, petta amu na ngamin tolay ta iddukan ku i Damak. Imikkat kanan mantu, te entanan,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","A sangaw netuldu ni Hesus ya pangituldu na tekid. “Iyak hapa la ya kakurugan na fun na kayu nga taronan ni Damakewan. ");
INSERT INTO agt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Te ya ngamin kiden pangpangak nga awan magmayan a iwasik na kid, ammi ta pangpanga kiden magmayan a palpaltungān na kid petta umaddu para ya mayan da. ");
INSERT INTO agt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","A ikamuy hapa ya kuman na pangpangak kiden, a kuman na nabalin kanan napaltungan gafu ta pangurug muy ta uhohug ku kiden tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","A mappya mantu ta kanayun medagga kam teyak, petta itta la itta ya angat muy nga nagafu teyak, te ya gagangay na pangpanga kiden na kayu a aweda makapagmayan am aweda mekamit ta fun da en nga mesipat ta angat na. A kumanen hapa tekamuy, te awemuy sangaw makapagmayan ta kuman na ikayat ni Damakewan am awemuy medagga teyak. ");
INSERT INTO agt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Iyak mantu ya kuman na fun, a ikamuy ya kuman na pangpangak kiden. A ya sigida medagga teyak petta itta la itta ya angat na nga nagafu teyak a yen ya makapagmayan ta addu ta kuman na gagangay na pangpanga kiden ta kayu. Ammi am megungay kam teyak a awan sangaw ta mabalin muy nga makamamallak te Damakewan. ");
INSERT INTO agt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","A am itta ya awan medagga teyak a mewarad sangaw yen ta kuman na panga na kayu nga awan magmayan ikid na makatang. A mauknud sangaw ya pangpanga kiden nagkatang petta mewarad kid ta afuy, a maapang kid na. ");
INSERT INTO agt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ammi am medagga kam la teyak ikid na itug muy la ya uhohugan ku tekamuy a magadang kam mantu ta kompormi ya ikayat muy, a dumatang hala sangaw tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Te am kunna ten ya tarabakun muy a kuman na magmayan kam sangaw ta addu, a yen sangaw ya pakaitan na pakapangwa ni Damakewan tekamuy, a magbalin kanan hapa ta itulduk kiden nga megitta teyak. ");
INSERT INTO agt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“A ya kuman na pangidduk ni Damakewan teyak a kumanen hapa ya pangidduk ku tekamuy. A mappya ta magintak kam la ta pangidduk ku tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Te am itug muy la ya ngamin pakkwak tekamuy a makaintak kam mantu ta pangidduk ku tekamuy ta kuman na iyak hapa, te gafu ta netug kun ya ngamin pakkwa ni Damakewan teyak a nakaintakak na hapa ta pangidduk na en teyak. ");
INSERT INTO agt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","A ye-yen ya inuhohug ku tekamuy, pettam kumanen am kurugan muy a mesipat kam hapa ta talak kin, a pake matappag kam sangaw ta talak muy. ");
INSERT INTO agt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“A ya pakkwak tekamuy ta ayanin a magkaid-idduk kam ta kuman na pangidduk ku tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","A ya pake mangidduk ta kadakalan na pangidduk a isagapil na ya angat na petta matolay ya kofun na kiden. ");
INSERT INTO agt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","A ikamuy hala ya kofun ku kiden am idulot muy ya pakkwak tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Awek na sangaw ibar ta tagabu ta kam, te kofun ta kanan. Te ya gagangay na tagabu a idulot na la ya mebar tentu, ammi awena pake ibar na dafu na en ya nonot na en tentu. Ammi gafu ta kofun ta kanan a netulduk hala tekamuy ya ngamin nadangag ku te Damakewan. ");
INSERT INTO agt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","A bakkan ta ikamuy ya nangpili teyak am awa iyak hud la ya nangpili tekamuy. A pinatudunan ta kam ange mangipadangag, petta kuman na magmayan kam hapa sangaw ta kuman na pangpanga kiden, a petta magnayun hapa ya pagbalinan na pagmayan muy. A am anu mantu ya adangan muy te Damakewan ta gafu teyak a iatad na hala tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","“A ta kuman na nebar ku paen tekamuy a magkaid-idduk kanan. ");
INSERT INTO agt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","A am ikatupag na kam sangaw na awan kiden makkamu teyak a nonotan muy ta iyak ya napolu nekatupag da. ");
INSERT INTO agt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Te am negitta kam mina tekid a kofunan da kam, ammi awemuy na negitta tekid gafu ta pinili ta kam petta meduma kam tekid, a yen ta ikatupag da kam. ");
INSERT INTO agt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nonotan muy mantu ya uhohug ken tekamuy ta ‘Awemuy mina pahig ta malmalalaki ya medob ammi ta nangidoben tentu,’ kunku paen, te am negaged dak a igaged da kam hapa sangaw. Ammi am netug da mina ya uhohug ku tekid a itug da hapa ya uhohug muy. ");
INSERT INTO agt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","A yen sangaw ya kwan da tekamuy gafu ta pangikatupag da teyak, te yaga aweda amu ya nangidoben teyak. ");
INSERT INTO agt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Am awek mina umange sin mangipasikkal ta uhohug na Namaratu tekid a awan mina ta liwat da, ammi ta ayanen gafu ta aweda mangurug a awan ta pambar da ta liwat da. ");
INSERT INTO agt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Te ya mangikatupag teyak a ikatupag nan mantu i Damakewan. ");
INSERT INTO agt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","A am awek mina nepaita tekid ya awena makkwa na kadwan kiden tolay a awan mina ta liwat da. Ammi ta ayanen a naita dan, a ikatupag da kamin hud la ni Damakewan. ");
INSERT INTO agt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ammi gagangay ta kunna ten petta magdulot teyak ya kuman na dana nesurat ta lintig kiden nga neatad na Namaratu tekid, te ya uhohug na a ‘Nekatupag dak maski awan ta liwat ku nga pangikatupagan da mina,’ kunna. ");
INSERT INTO agt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ammi maski kunna ten a pedob ku hala sangaw ya manguffun tekamuy nga magafu te Damakewan. Intu hala ya Kahalwa na Namaratu nga makkamu ta ngamin kakurugan, a intu sangaw ya doban na Namaratu tekamuy, petta am ipadangag dak sangaw ta tolay kiden a intu hapa ya mangipasikkal ta ipadangag muyen tekid. ");
INSERT INTO agt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ammi ikamuy para ya mangipasikkal, te dana nehulun kam teyak addet ta nepamegafu tamen. ");
INSERT INTO agt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ye-yen kid na bida ya isirak ku tekamuy, petta awemuy sangaw magbabawi gafu ta dumatang tekamuy, ");
INSERT INTO agt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","te ya makigimung kiden ta kapilya kiden a dugiman da kam sangaw gafu ta pangikatupag da tekamuy. A bakkan la ta yen, te papasin da kam para sangaw, te pahig da ta yen ya ikakayat na Namaratu. ");
INSERT INTO agt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A yen sangaw ya kwan da tekamuy gafu ta aweda amu ya Namaratu kontodu iyak. ");
INSERT INTO agt_vpl VALUES ("JN16_4a","073_16_4a","JHN","16","4a","4a","Ammi dana nebar kun yen tekamuy, petta am magdulot sangaw a dana nakaparan kanan, te nanonot muy na ya inuhohug kin tekamuy ta ayanin. ");
INSERT INTO agt_vpl VALUES ("JN16_4b","073_16_4b","JHN","16","4b","4b","“Ta idi a awek binida ya pangikatupag da sangaw tekamuy, te itta yak para la tekamuy, ");
INSERT INTO agt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ammi ta ayanin a magtugutak na, petta magtoli yak ta nangidoben teyak. A dana nadangag muy ta magtugutak, ammi awan haman ta nangibar teyak am had ya eyan ku, ");
INSERT INTO agt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","am awa nagdamdam kanan hud la gafu ta nabidakin tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ammi maski kunna ten a ibar ku ya kakurugan tekamuy, te pagkappyanan muy ta magtugutak, te am awek mina magtugut a awena sangaw timulyat na Manguffunen tekamuy. Ammi am magtugutak a doban ku hala sangaw tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","A am ittan sangaw tekamuy a intu ya makkamu mangipasikkal ta liwat na tolay kiden tekid, ikid na katunungan, ikid na pangpa-gang na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ipasikkal na ta itta ya liwat da gafu ta aweda mangurug teyak. ");
INSERT INTO agt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","A ipasikkal na hapa tekid ya katunungan, te itta yak na te Damakewan, a awedak sangaw maita. ");
INSERT INTO agt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A ipasikkal na para ya pangpa-gang na Namaratu tekid, te dana nekari na ya pangpa-gang na ta dafu da en nga mamadday ta ngamin dulay ta paglelehutin, a mekabat kid hapa sangaw tentu. ");
INSERT INTO agt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“A addu para mina ya itulduk tekamuy, ammi awemuy para la metug ta ayanin. ");
INSERT INTO agt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ammi am ittan sangaw ya Kahalwa en nga makkamu ta ngamin kakurugan, a intu ya timubbat nga mangituldu ta ngamin kakurugan tekamuy. A awena sangaw maguray maguhohug tekamuy, te dangagan na bit ya peuhohug ni Damakewan, a yen sangaw ya iuhohug na tekamuy, yaga ipakamu na hapa tekamuy ya dumatang sangaw ta paglelehutin. ");
INSERT INTO agt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","A maita muy hapa sangaw ya pakedayawan ku gafu tentu, te ya ngamin amu na teyak, a yen sangaw ya ipakamu na tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Te ya ngamin pakapangwa ni Damakewan a pakapangwak hapa. A yen ya nebar ku ta ipakamu na sangaw tekamuy ya ngamin amu na teyak,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","A ya uhohug na para tekid a “Mangananwan la a awetam bit magkait-ita. Ammi awek pake mabayag nga awan tekamuy, kapyek ha makipaita tekamuy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","A gafu ta nebar na en tekid a yen ta nagimpopohutan na kadwan kiden ituldu na, te aweda amu ya ikayat na uhohugan tekid. “Anu panaw ya ikayat na uhohugan, te ‘Mangananwan la a awetam sangaw magkait-ita, ammi awek pake mabayag kapyek ha makipaita tekamuy,’ kunna. A annun na haman ibar, ‘te eyak na te Damakewan’?” kunda. ");
INSERT INTO agt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“A mazigat hapa maawatan ya uhohug na en nga ‘Mangananwan la,’ te awetam haman amu,” kunna para na kadwan. ");
INSERT INTO agt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","A narikna ni Hesus ta ikayat da pohutan tentu, a dana nebar na tekid. “Anu? Magimpopohutan kanan de gafu ta uhohug ken tekamuy ta ‘Mangananwan la a awetam sangaw magkait-ita?’ ikid na ‘Awek pake mabayag kapyek ha makipaita tekamuy’? ");
INSERT INTO agt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A pake ibar ku mantu tekamuy ta magtatangit kanan sangaw ta pagdamdam muy teyak, ammi timoltollok la ya kadwan kiden nga awan mangurug. Ammi maski am madamdam kam a pimatalin hala sangaw ya talak muy ta damdam muyen. ");
INSERT INTO agt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Intu mina nonotan muy ya gagangay na babbayen maganak, te am tanagay na ya paganak na a pake mazigatan, te nadatangan na ya paganak na. Ammi am nakaanak na a awenan manonot ya zigat na en am awa matalakan hud la gafu ta limattog na ya anak na en. ");
INSERT INTO agt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","“A kumanen hapa tekamuy, te madamdam kanan ta ayanin, ammi matalakan hala sangaw ya nonot muy, te magkait-ita kitam hala sangaw, a awan ta makatampa ta talak muy. ");
INSERT INTO agt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","A am dumatang na sangaw ye-yen a awan na sangaw ta pohutan muy teyak. A pake ibar ku para tekamuy ta maski am anu ya adangan muy sangaw te Damakewan ta gafu teyak a iatad na hala tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Addet ta ayanin a awan para la ta inadang muy tentu ta gafu teyak. A magadang kanan mantu, petta maatadan kam, a madatangan sangaw ya talak muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","A ya uhohug para ni Hesus tekid a “Kuman na keangarigan ya nabidak tekamuy ta ayanin, ammi awek na sangaw maguhohug ta keangarigan, te pake ipadangag ku sangaw i Damakewan tekamuy petta malogon ya pakkamu muy. ");
INSERT INTO agt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","A am itta sangaw ya ikayat muy adangan tentu a adangan muy hala ta gafu teyak, te maski bakkan ta iyak ya mangibar ta adangan muyen tentu, ");
INSERT INTO agt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","te iddukan na kam hapa la gafu ta iddukan dak ikid na kurugan muy ta intu hala ya nagafun ken. ");
INSERT INTO agt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ya Damakewan ya nagafun ken teyaken lumattog ta lutakin. A ta ayanin a magtoli yak hala tentu, te magtugutak na ta isin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","“Ay, nalawag kad na, Afu, ye-yen na inuhohug mun, te bakkan na ta keangarigan. ");
INSERT INTO agt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","A ayanin para la ya pakkamu mi ta maski am awan ta mangibar teko a dana amum ya ikayat na pohutan teko. Yen mantu ya pangurugan min ta Namaratu hala ya nagafum,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","A ya tabbag na hapa tekid a “Mangurug kam ta ayanin, ");
INSERT INTO agt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ammi awena la mabayag a iwagak dak petta tatakdayak la, te sa magbabilag kam nga dumatang ta bali muy. Ammi maski am iwagak dak a awek tatakday, te itta la i Damakewan teyak. ");
INSERT INTO agt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“A yen ta inuhohug ku ye-yen kid na uhohug tekamuy, petta am ikatalak dak a awena sangaw makulkulaw na nonot muy am awa magintak kid la. A gafu ta ketta muy ta paglelehutin a itta la sangaw ya mangpazigat tekamuy, ammi itug muy la ya turad muy, te naabak kun ya ngamin kidin zigat ta paglelehutin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","A ta nekabalin ni Hesus nga nangituldu ta ituldu na kiden a tumangad na ta langit kapye na nakimallak ta Namaratu ewan: “Amang, ittan ya oras na zigat kin, a atadan nak ta pagattam ku, petta maita ya kalalakim gafu teyak. ");
INSERT INTO agt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","A mappya ta kunna ten, Amang, te uray mu haman ta iyak ya makkamu ta ngamin tolay, petta atadan ku hapa ya ngamin kiden neatad mu teyak ta magnayun na angat. ");
INSERT INTO agt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A ittan ya angat da nga magnayun te amu da ta iko hapa la ya kakurugan na Dyos, a iyak ya pinakabarim nga dinob mu ta paglelehutin. ");
INSERT INTO agt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“A ta kettakin ta lutakin a kanayun nepasikkal ku ya pakedayawam, a nebalin kun ya ngamin tarabakuk nga nepakkwam teyak. ");
INSERT INTO agt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","A ta ayanin, Amang, a padatangan nak haen ta hebing mina, petta maatadanak ta kalalakik nga megitta ta kalalakiken ta idi ta kawan para na paglelehutin. ");
INSERT INTO agt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“A ya lalaki kiden nga neatad mu teyak a netulduk kid ta ngamin nonot mu ikid na gagangay mu, te yen kid ya pinilim petta mesina kid ta kadwan kiden tolay ta paglelehutin. A netug da hapa ya ngamin kiden uhohug mu nga netulduk tekid. ");
INSERT INTO agt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","A ta ayanin a amu dan ta iko hala ya pake nagafun na ngamin kiden neatad mu teyak. ");
INSERT INTO agt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Te ya ngamin nepeuhohug mu teyak a yen hala ya neuhohug ku tekid, a kinurug da hapa. A pake amu dan ta iko ya nagafun ken, a mangurug kid na ta iko ya nangidob teyak. ");
INSERT INTO agt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“A yen ta makimallakak teko, Amang, te pakimallak ku kid hapa. Awek bit pakimallak ya kadwan kiden tolay ta paglelehutin, te intu bit la pakimallak ku ya neatad mu kiden teyak. A pakimallak ku kid, te anak mu kid. ");
INSERT INTO agt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Te ya ngamin tolay mu a tolay ku kid hapa, a tolay mu hapa ya ngamin tolay ku, a madayawanak hapa gafu ta pangurug da teyak. ");
INSERT INTO agt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Awanak na sangaw ta paglelehutin, te dumatangak na teko. Ammi sigida itta yan kid ta paglelehutin, a yen ta pakimallak ku kid teko, Amang, te iko la ya katununganen na Dyos. A sigida pagdadaggam kid la teko nga neatad mu teyak, petta magtatakday kid ngamin ta kuman na pagtatakday ta. ");
INSERT INTO agt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ta kettakin para la tekid a iyak hala ya nangpadagga tekid teko, a nekerutan ku kid hapa, te awan ta nelogot tekid fwera ta takdayen la nga nekari nelogot, petta magdulot ya uhohug na suraten. ");
INSERT INTO agt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ammi pagtugutān ku kid na, Amang, te dumatangak na teko, a uhohugan ku yan ta kettak para la ta paglelehutin petta madangag da hapa, petta magdulot hapa tekid ya kuman na talak na nonot kin. ");
INSERT INTO agt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nesirak kun ya uhohug mu tekid, a yen ya pangikatupagan na awan kiden mangurug tekid gafu ta aweda negitta tekid, te kumanen hapa teyak. ");
INSERT INTO agt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Awek ibar ta padayum kid ta awan kiden mangurug, ammi ikayat ku ta ilillik mu kid ta pangayayyaw ni Satanas tekid, petta aweda mangwa ta dulay, ");
INSERT INTO agt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","te aweda megitta ta kadwan kiden tolay ta paglelehutin, te kumanen hapa teyak. ");
INSERT INTO agt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ikayat ku hapa, Amang, ta pagtatakdayam ya nonot na gintatakdayan tekid, petta kanayun kwan da ya megitta ta uhohug mu, te ya uhohug men hapa la ya pakkamun da ta ngamin kakurugan. ");
INSERT INTO agt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","A ta kuman na nepangidob mu teyak ta paglelehutin a doban ku kid hapa. ");
INSERT INTO agt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","A gafu ta itulduk kid a pagtatakdayan ku hapa ya nonot ku ta patarabakum teyak, petta parigan dak hapa sangaw nga magpatatakday ta nonot da ta kakurugan. ");
INSERT INTO agt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“A bakkan la ta isin kid ya pakimallak ku, te isipat ku hapa ya mangurug sangaw teyak gafu ta pangipadangag na inin kid teyak, ");
INSERT INTO agt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","petta sa magtatakday kid ngamin nga megitta tekita ta kuman na pagtatakday ta, a petta mesipat kid hapa ta pagtatakday ta, pettam kumanen a yen sangaw ya pangurugan na kadwan kiden tolay ta iko ya nangidob teyak. ");
INSERT INTO agt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A ya pakedayawam nga nesipat mu teyak a yen hapa ya nesipat ku tekid, petta magtatakday kid nga megitta tekita. ");
INSERT INTO agt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Itta yak tekid, a itta ka hapa teyak, petta pake magtatakday kid ta mappya, pettam kumanen a yen sangaw ya pakkamun na kadwan kiden tolay ta iko ya nangidob teyak ikid na mangidduk tekid ta kuman na pangidduk mu teyak. ");
INSERT INTO agt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ikayat ku para, Amang, ta dumagdag hapa sangaw teyak ya ngamin kiden mangurug nga neatad mu teyak, petta pake maita da hapa ya kadakalan na dakar na pakedayawan ken nga neatad mu teyak ta kawan para la na lutakin gafu ta pangidduk mu teyak. ");
INSERT INTO agt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","26","Iko la, Amang, ya lugar na ngamin katunungan, ammi awena ka amu na tolay kiden nga itta ta paglelehutin. Ammi iyak ya makkamu teko, a nepakamu ta ka hapa ta itulduk kidin, a amu dan ta iko ya nangidob teyak. A ipakamu ta ka para tekid petta mesipat kid hapa ta pangidduk mu teyak gafu ta itta yak hapa tekid,” kunna. A yen ya addet na pakimallak na en. ");
INSERT INTO agt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","A ta nekabalin ni Hesus nga nakimallak a sa nagtatugut kid na ituldu na kiden, a umange kid ta dammang na Wer na Kidaron, te magdulot kid ta agyan na kakayunen nga kanayun eyan da. ");
INSERT INTO agt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Awan tekid i Hudas nga mangitalaba te Hesus, ammi dana amu na ya lugar na kakayunen, te yen ya kanayun katotolin nig Hesus ikid na ituldu na kiden nga pagaammungan. ");
INSERT INTO agt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","A gafu ta kumanen a nangihulun i Hudas ta addu na suddalu ikid na polis nga dinob na padi kiden nga Hudyo ikid na Pariseyu kiden, te enna kid netulud ta agyan ni Hesus, a nagibbal kid hapa ta hilag ikid na kampilan. ");
INSERT INTO agt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","A datang da ta agyan na kakayunen a dana amu ni Hesus ya ngamin dumatang tentu, a enna kid mantu dinafung. A ya uhohug na tekid a “Inya hud ya apagan muy?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“A ya Hesusen taga Nasaret,” kunda. “A iyak haman,” kunna hapa tekid. A nakihebing hapa tekid i Hudas nga nangitalaba tentu. ");
INSERT INTO agt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","A ta nepangtabbag ni Hesus tekid ta “Iyak haman,” nepagkin a sa nagasusunsun kid na abat ta napakayang kid, ammi pinidwa ha ni Hesus ya nebar na en tekid. ");
INSERT INTO agt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","“A te inya hud ya apagan muy?” kunna. “I Hesus la nga taga Nasaret,” kunda ha. ");
INSERT INTO agt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“A te ‘Iyak haman,’ kunku paen. A am iyak la ya apagan muy a patugutan muy mantu ya kahulun ku kidin sin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A uray na Namaratu ye-yen petta magdulot hala ya inuhohug na en ta Namaratu nga “Awan ta nelogot ta neatad mu kiden teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ammi te Pedru a dana nagibbal hapa ta kampilan na en, a ka-ma la sinukkut na kapye na nekattab ta takdayen tekid, a newasik na ya bangbang na en. I Malkus ya ngagan na kinattab na en, a intu ya takday tagabu na kadakalan na padi kiden. ");
INSERT INTO agt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ammi ta nepangkattab na a ginamman ni Hesus, “Ialag mun ya kampilamina. Pahig mu hud ta awek ituluk ya barik ta pakkwa ni Damakewan teyak?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","A gafu ta kumanen a timurad na mantu ya suddalu kiden kontodu kapitan da ikid na polis kiden, te enda ginafut i Hesus kapye da ginalutan. ");
INSERT INTO agt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","A ta nepakagalut dan tentu a neange da bit ta bali ni Annas nga katahungan ni Padi Kaypas nga kadakalan na padi ta darumin yen. ");
INSERT INTO agt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","I Kaypas ya dana nangibar ta mapapasi mina, petta bakkan ta ngamin tolay ya mapapasi. ");
INSERT INTO agt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","A ig Pedru ikid na takday para ituldu ni Hesus a tinultulitul da ya nanggafut kiden te Hesus. A gafu ta amu na padi en kadakalan ya kahulun ni Pedru a nehulun hapa teg Hesus nga simarok ta bagaw na bali na padi en, ammi nagtayuk i Pedru ta lawan na irwangan. ");
INSERT INTO agt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","A gafu ta kumanen a nagtoli ya kahulun na en ta irwangan, petta ibar na i Pedru ta babbayen nangalwad ta irwangan, a pinasarok na hapa ta bagawen. ");
INSERT INTO agt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ammi dana itta ya pinohutan na babbayen te Pedru; “Anu? Iko hapa de ya takday ituldu na ginafut da en?” kunna tentu. “Ay, awan O,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A ta nepakasarok ni Pedru a umange bit nakipaggukup ta afuy na tagabu kiden ikid na polis kiden, te dana nagpagatang kid na ta dungit gafu ta sanawen. ");
INSERT INTO agt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","A ta umag na bali na kadakalanen na padi a imbestigaran na i Hesus, gafu ta ituldu na kiden ikid na netuldu na en tekid. ");
INSERT INTO agt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","A ya tabbag ni Hesus tentu a “Sigida naguhohugak ta pakaitan na ngamin tolay, te awan haman ta ilemad ku. A kanayun nangituldu yak hapa ta kapilya na Hudyo kiden ikid na simbaanen. ");
INSERT INTO agt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Annum mantu pohutan teyak am anu ya netulduk? Kappyanan na ta pohutam mina ta nakadangag kiden teyak, te amu da am anu ya inuhohug ku tekid,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ammi ta nepagtabbag na ta kumanen a enna linappag na takdayen polis nga umatayuk ta bikat na en. “Kunna hud sina ya itabbag mu ta kadakalan na padi?” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","“A am dulay ya inuhohug ku a ipasikkal mu mantu ya kadulay na. Ammi am kustu a anu haman ta lappagan nak?” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","A sangaw nepetulud ni Annas segalut te Kaypas, te intu ya kadakalan na padi nga magturay ta darunin yen. ");
INSERT INTO agt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","A i Pedru hapa a umatayuk para la nakipaggukup ta afuyen, a ka-ma la nekabat da hapa; “A te iko hapa de ya takday ituldu na,” kunda. Ammi nelemad na ha, “Awan O,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ammi ya takdayen tagabu na kadakalan na padi a intu hapa ya takday kahulun na kinattab ni Pedru ta bangbang na en, a nekabat na hapa, “Bakkan hud ta iko ya naitak nga nehulun te Hesus ta kakayunen?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ammi nelemad na ha, a yen na hapa ya nepagtareknay na manuk nga nebar ni Hesus. ");
INSERT INTO agt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","A sangaw ta magkahkahawan a netugut da ha i Hesus ta bali ni Kaypas, te iange da ta Gubernadoren taga Roma petta ibar na mina ya pasi na. Ammi ta datang da ten a awena simarok na Hudyo kiden ta bali na en, petta aweda kan maalasigan ta dulay gafu ta awena negitta tekid, pettam kumanen a aweda kan sangaw mehangat nga makikkanan ta pamurab na simana da. ");
INSERT INTO agt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","A gafu ta kumanen a imuhet na i Gubernador Pilato tekid, a pinohutan na tekid; “Anu mantu ya nangidaruman muy ta tolayin yan?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","“A te dulay na tolay, a neange mi hud teko am awan ta liwat na,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","“Ay on, a alapan muy la mantu, te ikamuy na hapa la ya mangpa-gang tentu ta kuman na ibar na lintig muy kiden,” kunna hapa na Gubernadoren tekid. Ammi ya tabbag da hapa a “Mappya ta ikamuy, te ihangat na kami na gubyernu nga mamapasi ta makaliwat,” kunda ha. ");
INSERT INTO agt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A uray na Namaratu hala ye-yen petta magdulot hapa ya inuhohug ni Hesus ta idi, te dana kinankanna na ta magappa ta kayu ta pangpapasi da sangaw tentu. ");
INSERT INTO agt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","A gafu ta kumanen a nagtoli i Pilato ta umag na bali na en, a pinaayagan na hapa i Hesus. “Anu? Ipadangag mu hud ta iko ya Ari na Hudyo kiden?” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ammi ya pohut ni Hesus tentu a “Anu, Iko hapa la ya nakanonot ta pohut mu teyak, ono yen ya papohut na kadwan kiden tolay teko?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","“Annun ku hud ipahig am ari ka, baka Hudyo yak hud. Ya kagittam kiden ikid na pinakadakal da kiden ya nangiange teko ta isin petta iyak mina ya mangibar ta pasim. Anu mantu ya iningwam?” kunna ha ni Pilato tentu. ");
INSERT INTO agt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","“A itta hala ya pagariyan ku, ammi takwan ya pagarik, te awek parigan ya ari kiden ta paglelehutin yan. Te am kuman nak mina na inen kid a nakitapil mina ya tagabuk kiden, petta nekerutan dak mina ta Hudyo kiden, ammi awek parigan ya ari kiden ta lutakin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“A ari ka mantu ay?” kun ni Pilato tentu. “Iko ya mangibar ta ari yak, ammi ibar ku teko ya gafu na nekeanak ku, te umange yak ta lutakin petta ipasikkal ku ya kakurugan ta tolay kiden. A ya ngamin kiden mangidulot ta kakurugan a yen kid ya mayat mangdangag teyak,” kunna hapa ni Hesus. ");
INSERT INTO agt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“Anu hud ya serbi na kakurugan?” kunna ha ni Pilato tentu, kapye na imuhet ha ta agyan na Hudyo kiden. A ya uhohug na tekid a “Awan haman ta naapagan ku ta pangpapasin ku mina tentu, ");
INSERT INTO agt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ammi kada simana muy a gagangay ta ibbatan ku ya takday kagitta muy nga nabalud. A am ikayat muy a ibbatan ku hala i Hesusin nga Ari na Hudyo kiden,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ammi giaggayan kid na. “Bakkan ta isina ya ibbatam am awa Barabas mina,” kun na aggay da. Te ya kinan da en Barabas a dana nabalud gafu ta tulisan ikid na nakapapasi. ");
INSERT INTO agt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","A gafu ta kumanen a nepaalap ni Pilato i Hesus ta suddalu kiden, petta paligatan da ta dakal na paligat nga makabigad. ");
INSERT INTO agt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","A nangwa kid hapa ta sangngat na sit kapye da nesangngat ta ulu ni Hesus, kapye da ha sinalnukan ta darag ta kuman na salnuk na ari, te pamābānglu da tentu. ");
INSERT INTO agt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","A sangaw natubtubbat kid nangatubang nga nagdayaw kampon tentu. “Ihi, kuga malalaki ya Ari na Hudyo kiden,” kun na dayaw da, kapye da hapa linaplappag. ");
INSERT INTO agt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","A ta nekabalin da en a nepohet ni Pilato ta agyan na tolay kiden. “Itan muy, te iuhet kun ha tekamuy, petta amu muy mina ta awan ta naapagan ku ta pangpapasin ku tentu,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","A imuhet na i Hesus nasangngatan ta sit, ikid na nasalnukan ta kuman na ari. “Ye, itan muy ya tolayin,” kunna ha ni Pilato tekid. ");
INSERT INTO agt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","A ta nepakaita na pinakadakal da kiden tentu a giaggayan kid ha. “Pagappam na ta kayu en, pagappam na ta kayu en,” kun na aggay da. “Alapan muy mantu, te ikamuy na ya magpaappa tentu, ammi ikamuy hala sangaw ya makaliwat, te awan ta amuk ta liwat na,” kun ni Pilato tekid. ");
INSERT INTO agt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","“Onay, ammi nakaliwat ta lintig mi, te maski tolay la a negitta na ya bari na ta Anak na Namaratu ewan, a yen mina ya kapapasi na,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","A gafu ta inuhohug da en a pake nagburung na i Pilato, ");
INSERT INTO agt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","a inalap na ha i Hesus ta umag na bali en petta imbestigaran na para. “Had hud ya nagafum?” kunna tentu, ammi awena tinabbag ni Hesus. ");
INSERT INTO agt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","“Anu awem hud magsitang teyak? Awem hud amu ta iyak ya makkamu teko petta ibbatan ta ka ono pagappan ta ka?” kunna ha. ");
INSERT INTO agt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ammi ya uhohug ni Hesus tentu a “Awan mina ta pakapangwam teyak am awena neatad na Namaratu teko. Dakdakal mantu ya liwat na nangpetulud teyak teko, te pepapasi na teko ya awanen ta liwat,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","A gafu ta uhohug ni Hesus a ikayat na ibbatan ni Pilato, ammi giaggayan ha ya Hudyo kiden. “Am ibbatam mina ye-yana na tolay a awem na mantu kofun na Ari men Sisar, te igitta na haman ya bari na ta ari, a igakkad na mantu ya makigubat te Ari en Sisar,” kunna ha na aggay da. ");
INSERT INTO agt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","A gafu ta uhohug da en a neuhet na ha i Hesus, a sangaw nagtuttud i Pilato ta kinan da en Lamesa Na Batu, ammi ‘Gabata’ ya ngagan na ta Hudyo kiden, a yen ya nangipadangagan na ta uray na gafu te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Alas seis ta lalakwat ya nepagtuttud na ta araw na Byernis ta simana na Hudyo kiden. A ya nebar na tekid a “Yeh, itan muy, itta in ya ari muy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","“Atsi, itugut mun, itugut mun, te pagappam na ta kayu en,” kunna ha na pagaggay da. “Ikayat muy hud ta pagappan mi ya ari muy?” kunna ha tekid. A ya tabbag na pinakadakal da kiden nga padi a “Awan ta ari mi am awa Sisar,” kunda. ");
INSERT INTO agt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","A netuluk mantu ni Pilato ta pagappan da i Hesus ta kayu petta masi. ");
INSERT INTO agt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","A enna mantu inalap na suddalu kiden, a nepaagtu da tentu ya kayu en nga pagappan na. A enda netulud ta lawan na ili na Herusalem, te iange da ta kinan da en ‘Agyan na Tulang na Ulu’, ammi ‘Golgota’ ya ngagan na ta Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","A yen ya nagpaappan da tentu, a nesipat da hapa ya duwa para na tolay, a netun da i Hesus ta nagtangnganan na duwa kiden. ");
INSERT INTO agt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","A nepesurat ni Pilato ya ngagan ni Hesus, a nepetun na ta nagappan na en ta utun a ulu na en. “Hesus Taga Nasaret, Ari na Hudyo kiden,” kun na surat na en. ");
INSERT INTO agt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A addu hapa ya nagbasa ta suraten, te abikan hala ya nagappan na en ta ili na Herusalem, te yaga nesurat ta aguhohug na Hudyo ikid na Latin ikid na Giregu. ");
INSERT INTO agt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ammi ya nebar na pinakadakal na Hudyo kiden nga padi te Pilato a “Bakkan mina ‘Ari na Hudyo kiden’ am awa ‘Nebar na ta intu ya Ari na Hudyo kiden,’” kunda. ");
INSERT INTO agt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","“Mesirak hala ya nepesurat ku,” kunna hud la ni Pilato tekid. ");
INSERT INTO agt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","A ta nekabalin na suddalu kiden nga nagpaappa te Hesus a inalap da ya ga-gamit na kiden nga inazi da, a pinagappat da kid fwera ta nagingumagen barawasi na, petta tagtakday kid ta bingay da, te appat kid nga nagpaappa tentu. Ammi ta nagingumagen barawasi na a aweda ginadwa, te awan ta daget na, te naglayun la ta utun abat ta akban. ");
INSERT INTO agt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“Awetam pispissilan, te pagbabinunutan tam la talo am inya sangaw tekitam ya makākwa,” kunda. A uray na Namaratu ta kunna ten petta magdulot hapa ya takday uhohug ta Bibliya na Hudyo kiden, te “Nagbabingayan da ya ga-gamit ku kiden, a nagbabinunutan da ya barawasi ken,” kun na suraten. A yen mantu ya iningwa na suddalu kiden te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ammi ta pagbabingay na suddalu kiden a umatayuk hapa ya appat na babay ta bikat na nagappan ni Hesus. Itta ya hina ni Hesus, ikid na kabagis na en, ikid ni Mariya nga atawa ni Klopas, ikid ni Mariya nga taga Magdala. ");
INSERT INTO agt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","A ta nepangiddung ni Hesus ta hina na en ikid na ituldu na en nga pake kofun na nga naghebing tentu a “Ina, ya nakihebingina teko ya anak mun sangaw nga metali teyak,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","A ya uhohug na hapa ta ituldu na en gafu ta hina na en a “Aleng, ikwentam na hapa sangaw te hinam,” kunna. A ye-yen hapa na araw ya nepangalap ni Hwan ta hina ni Hesus, petta makipagyan ta bali na en. ");
INSERT INTO agt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","A ta nekabalin na kumanen a amu ni Hesus ta sa nabalin na ya ngamin nepatarabaku na Dama na en tentu, a “Makainumak,” kunna, petta magdulot ya takday hapa uhohug ta Bibliya. ");
INSERT INTO agt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","A nangalap mantu ya suddalu kiden ta kuman na kapas kapye da nesabbung ta duyug na malsut nga nesagpaw ta bikat da, a netullu da ta simuk na en petta sappilan na ya malsuten. ");
INSERT INTO agt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nepakainum na a “Nebalin kun ya tarabakuken,” kunna, kapye na nagtumag, a netuluk na ya angat na. ");
INSERT INTO agt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A ta kuman na lintig na Hudyo kiden a awena mina mesirak na bari na nasi ta kayu addet ta Sabadu, te araw na agimmang da. A gafu ta Byernis ya araw na nepangpaappa da te Hesus, anna ye-yen na Sabadu ya mayor na araw na simana da, a yen ta umange ya pinakadakal na Hudyo kiden te Pilato, te inadang da ta mapakka mina ya takki na pinagappa na suddalu kiden, petta alistu mina ya pasi da, pettam kumanen a medagut kid na mina ta nagappan da en. ");
INSERT INTO agt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","A nangidob mantu i Pilato ta suddalu kiden, a intu napolu pinakka da ya takki na duwa kiden nga nagdwaakub te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ammi ta pangitubbat da mina te Hesus a dana nasin, a aweda mantu pinakka ya takki na kiden. ");
INSERT INTO agt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ammi ya takdayen suddalu a pinika na hala ya hakbu na bari na en, a ka-ma la imuhet ya daga na kiden nga nekihu ta danum. ");
INSERT INTO agt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","37","A uray na Namaratu hapa ye-yen, petta magdulot ya nesurat ta Bibliya en ta “Awan sangaw ta mapakka ta tulang na kiden,” kunna. Kumanen hapa ta takday para nesurat, te ya uhohug na a, “Tangadan da sangaw ya kinaddug da en,” kunna. A ya pake nakaita ya nangisurat hapa ta isin, petta kurugan muy. A kakurugan hapa ya ipasikkal ku tekamuy, te amuk ta pake nakkwa ya bidan ku tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","A ta nekabalin na kumanen a umange i Hose taga Arimateya te Pilato, te inadang na ya bari ni Hesus, petta itanam na. Intu hapa ya takday ituldu ni Hesus, ammi nelemad na gafu ta talaw na ta pinakadakal na Hudyo kiden. A netuluk ni Pilato ya bari na en, a enna mantu inalap ni Hose. ");
INSERT INTO agt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Intu hapa kahulun na i Nikodemu nga umange nakibidan te Hesus ta hiklam ta idi. A nangihulun hapa i Nikodemu ta limāfulu kilu na bangog nga nekihu da, te iluggud da sangaw ta bari na nasi petta awena alistu malabag. ");
INSERT INTO agt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","A ta nepangidagut da ta bari ni Hesus a finutefutan da ta ga-gamit ikid na bangog kiden, te yen ya gagangay na Hudyo kiden am itanam da ya nasi. ");
INSERT INTO agt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","42","A gafu ta assang la na oras addet ta pamegafu na araw na agimmang da a neange da ya bari na en ta bagu na tanam nga dana nakobkob ta hukeb ta agyan na kakayunen, te abikan hala ta nagappan na en. A yen ya nangitanaman da tentu. ");
INSERT INTO agt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","A sangaw ta lalakwat ta Liggu a umange i Mariya taga Magdala ta tanam na en ta magkahkahawan para la. Ammi datang na ten a naita na ta naukadan na, te naazin ya batu en nga nemunit da ta sasarokan na en. ");
INSERT INTO agt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","A bumilag na mantu nga ange ta agyan nig Pedru ikid na kahulun na en nga pake kofun ni Hesus, a nebar na tekid. “Itta ya umange nangalap ta bari na dafu tamen, a awemi amu am had ya nangikinan da tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","A imikkat mantu ya duwa kiden, a naggindan kid nagbilag addet ta agyan na tanamen, ammi naunnanan na takdayen i Pedru, a intu ya napolu nakadatang. ");
INSERT INTO agt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A tentu en simisihib ta umag na tanamen a intu la naita na ya nefufutefuten ta bari ni Hesusen, ammi awena simarok ta umag na tanamen. ");
INSERT INTO agt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","A ta datang ni Pedru nga dumagdag ta takdayen a nagdulot hala simarok, a aitan na la ya ga-gamit kiden nga nefufutefut ikid na panyawen nga nebadbad ta ulu na en, ");
INSERT INTO agt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","a awena nehebing na panyawen ta ga-gamit kiden, te nakappil nehugtuk. ");
INSERT INTO agt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","A sangaw dumagdag hapa simarok ya takdayen nga imunnan tentu. A tentu en nakaita ta ga-gamit kiden a yen ya nangurugan na ta natolay hala i Hesus, ");
INSERT INTO agt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","te idi, aweda para la amu ya ikayat na uhohugan na surat kiden nga dana nangibar ta pasi na ikid na katolay na hala sangaw. ");
INSERT INTO agt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","A tekid na nabalin ten a dumatang kid na ta bali da. ");
INSERT INTO agt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ammi te Mariya en nga dumagdag hapa ta duwa kiden a nasirak la ta lawan na tanamen nga nakatangtangit. A tentu para la nagtangit a simisirib hapa ta umag na tanamen, ");
INSERT INTO agt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","a naita na ya duwa na anghel nga nagbarawasi ta furaw, te imatuttud kid la ta nagiddan na bari ni Hesusen, takday ta ulwanan na en, a takday ta kasoyadan na en, ");
INSERT INTO agt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","a “Anu magtangit ka?” kunda tentu. “A onay, te itta ya umange nangalap ta dafu ken, a awek amu am had ya nangikinan da tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ammi tentun nakauhohug ta isin a pa nagbalittag bit, a naita na ya umatayuk ta talekud na en, ammi awena amu ta intu hala i Hesusen. ");
INSERT INTO agt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Anu magtangit kan, aboy? Inya hud ya apagam ta isin?” kunna ta babbayen. Ammi pahig ni Mariya ta intu hala ya magtaronen ta kakayunen, a “Ser, am iko ya nangitugut ta bari na dafu ken a ibar mu haen teyak am had ya nangikinam tentu, te enku sangaw alapan,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","A “Mariya,” kunna ha ni Hesus tentu. A ta nepangngagan na ta babbayen a pake nagbalittag na nga gumafut tentu, a “Raboni, anu iko kad,” kunna, (te Raboni ya nangingaganan da ta mistro da). ");
INSERT INTO agt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","A ya uhohug ni Hesus tentu a “Awem na mina gafgafutan ya barikin, te mappya ta timullu yak para te Damakewan. A e kan mantu ta kabagis ku kiden, te ibar mu tekid ta eyak na te Damakewan Namaratu, a intu hala ya Dama muy ikid na Namaratu muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","A ta nepagtugut ni Mariya en a enna nebar ya katolay ni Hesus ta ituldu na kiden. “Naitak kad na ya Dafu tamen O, ikamuy,” kunna tekid, yaga nebar na hapa ya inuhohug ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A sangaw ta hiklam ta ye-yen para na araw, araw na Liggu, a itta ya ituldu na kiden ta takday bali, a sa nalitupan ya ngamin irwangan na bali en gafu ta talaw da ta pinakadakal da kiden nga Hudyo. Ammi ka-ma la ittan i Hesus nga nagtayuk ta nagtatangnganan da en, a “Namaratu ewan ya makkamu tekamuy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","A sangaw neuyad na ya kamat na kiden tekid petta maita da ya piglat na lansa kiden, otturu netuldu na hapa ya piglat na pika en ta hakbu na en. A tekiden nakaita ta intu hala ya dafu da en Hesus a pake nefulot ya talak da tentu. ");
INSERT INTO agt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","“Namaratu ewan ya makkamu tekamuy,” kunna ha tekid, “te doban ta kam nga ange mangipadangag ta uhohug ku ta kuman na nepangidob ni Damakewan teyak,” kunna, kapye na kid inaswangan. ");
INSERT INTO agt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","A tentu en nagaswang tekid a “Pagdulotan muy na ya Kahalwa na Namaratu nga manguffun tekamuy. ");
INSERT INTO agt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","A ya ngamin kiden pakoman muy ta liwat da kiden gafu ta pangurug da ta ipadangag muy a yen kid hala ya pinakoman na Namaratu ewan. Ammi ta awemuy kiden pakoman gafu ta aweda mangurug a itta hala tekid ya liwat da kiden,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ammi ta napolu en nepakipaita ni Hesus ta ituldu na kiden a awan i Tomas tekid, ammi Siping ya agngilinan da tentu. ");
INSERT INTO agt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","A sangaw ta ketta na en tekid a nebar da tentu, “Naita min ya dafu tamen,” kunda tentu. Ammi ya tabbag na tekid a “Awek sangaw kurugan ta intu am awek bit maita ya gafan na lansa ta kamat na kiden, te yaga iparubak ya guramay kin ta piglat na kiden ta kamat na kontodu hakbu na en,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","A sangaw ta takday Liggu a nagkakampat ha ya ituldu na kiden ta bali en, a nehulun hapa i Tomas tekid. A nalitupan da ha ya irwangan kiden gafu ta talaw da en, ammi ka-ma la nagtayuk i Hesus ta nagtatangnganan da en, a “Namaratu ya makkamu tekamuy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","A sangaw binaran na i Tomas. “E ka bit sin, Tomas, te itam ya kamat ku kidin. A iparubam hapa ya guramay mu ta palad ku kidin kontodu hakbu kin, te awem mina parigan ya awan mangurug am awa mangurugen mina,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","“Ay, Afu, iko kad hala ya dafuk ikid na Dyos ku,” kunna hapa ni Tomas. ");
INSERT INTO agt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","A ya uhohug ha ni Hesus tentu a “Mappya te mangurug kan, Tomas, gafu ta naita nak na. Ammi ta mangurugen nga awan para la nakaita teyak a pake nagāsgāsāt ammi teko,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","A addu para ya nepaita ni Hesus ta pakapangwa na ta ituldu na kiden nga awan nesurat ta lebru in yan. ");
INSERT INTO agt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ammi yen ta nesurat kun ya kadwan ta isin petta yen kid ya pangurugan muy ta intu hala ya Anak na Namaratu ewan ikid na Mangikerutanen nga nekari na tekitam, pettam kumanen am mangurug kam mina tentu a ittan ya angat muy nga magnayun gafu tentu. ");
INSERT INTO agt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","A sangaw ta mittan a nakipaita ha i Hesus ta ituldu na kiden ta ihang na Alug na Tiberyas, a kumanin ya nepakipaita na tekid. ");
INSERT INTO agt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sa nagdadagga ig Simon, (intu hala i Pedru,) ikid ni Tomas, ikid ni Natanyel nga taga Kana ta lugar na Galileya, ikid na duwa kiden anak ni Zibadeyu, ikid na duwa para na kahulun da. A ya uhohug ni Pedru ta kahulun na kiden a ");
INSERT INTO agt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","“Asakay! E yak na magsigay O, ta alugin,” kunna. “A mehulun kami mantu ay O,” kunna hapa na kadwan kiden. A nahahulun kid na nagbarangay ta agyan na pagsigayan da en. A tāhiklaman kid ta alugen, ammi awan pulus ta naalap da. ");
INSERT INTO agt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","A tentun gumāgākād na bilagen a sang adayu kid para la ta ba-naden, a itta la i Hesusen nga umatayuk ta ba-naden, ammi aweda nelasin ta intu. ");
INSERT INTO agt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","A sangaw nagayag i Hesus tekid, “O ey, itta hud ya naalap muy ta igupan tam?” kunna. “Awan O,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","“A isaruwag muy mantu ya sigay muy ta ziwanan na barangay muy, a itta hala sangaw ya maalap muy,” kunna ha tekid. A nesaruwag da mantu ta kuman na nebar na en tekid, a “Awe! ta kaddu na ikan kiden,” te awedan magamid ya sigay da en gafu ta dammat na en. ");
INSERT INTO agt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","A yen ya nepakamu ni Hwan ta nagayagen tekid, a nebar na te Pedru. “Intu hala ya dafu tamen,” kunna. A gafu ta kumanen a alistu nagbarawasi i Pedru, te magge nauhagan, a nagsilattuk na ta danumen nga naglangoy tagad te Hesus. ");
INSERT INTO agt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ammi nasirak ya kahulun na kiden ta barangay da en nga naggerger ta sigay da en, te napannu ta ikan, a aweda pake adayu ta ba-naden, te kuman na magatut na metru. ");
INSERT INTO agt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","A sangaw tekid na nakadagut ta barangay da en a dana ittan ten ya umagātang na afuy nga keasalan na ikan, a itta hapa ya pan. ");
INSERT INTO agt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","“Alapan muy hapa sin ya kadwan kidina ikan nga naalap muy,” kun ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","A nagla-nug mantu i Pedru ta barangayen, a inubadan na ya sigayen kapye da ginerger ta ba-naden. A mappya te awena napissang, te pake napannu ta dadagkal na ikan, magatut a limafulu tallu kid ngamin. A binaran na kid ha ni Hesus. ");
INSERT INTO agt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","“E kanan sin, te maggub kitanan,” kunna tekid. A pohutan da mina am pake intu, ammi mamat kid, te aitan da haman. ");
INSERT INTO agt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","A ta nepangiagon ni Hesus ta ikan ta afuyen a enna negawat tekid, kumanen hapa ta pan. ");
INSERT INTO agt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","A yen mantu ya pakapamillu na pakipaita ni Hesus ta ituldu na kiden tentu en natolay ta pasi na en. ");
INSERT INTO agt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","A tekid na nakapaggub a itta ya netotoli nebar ni Hesus te Simon. “Simon, damagan ku teko am pake ikaykayat nak ammi ta isin kid na kwam?” kunna tentu. “On, Afu, te amum haman ta ikayat ta ka,” kunna hapa. “A makkamu kan mantu ta kanan na mangurug kiden teyak, te kuman kid na kalneruk kiden,” kunna hapa ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","A sangaw ta mittan a pinidwa na ha ya nebar na en. “Simon, damagan ku ha am iddukan nak?” kunna. “On, Afu, te amum haman ta ikayat ta ka,” kunna ha. “Tahonam mantu ya tolay ku kiden nga kuman na kalneruk,” kunna ha ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","A sangaw nepamillu na ha ya nebar na en. “Simon, kurug mantu ta ikayat nak?” kunna. A nagdamdam na i Pedru gafu ta mekatallu en nebar ni Hesus tentu, te “Kurug mantu ta ikayat nak?” kunna. A ya tabbag na en tentu “Ay, Afu, iko ya makkamu ta ngamin, a amum ta ikayat ta ka,” kunna. A ya uhohug ni Hesus tentu a “Makkamu kan mantu ta kalneruk kiden. ");
INSERT INTO agt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A ya pake ibar ku para teko a kanayun nagbarbarawasi kan ta kababagu men para la, kapyem umange nagpapasyar ta kompormi na ikayat men. Ammi sangaw am laklakay kan a magappa kan hapa, a takwan sangaw ya mangbarawasi teko ta galut, a iange da ka sangaw ta awem ikayat,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","A ye-yen na uhohug ni Hesus ya pangipasikkal na ta pangpapasi da sangaw te Pedru petta Namaratu hapa sangaw ya madayawan gafu tentu. A ta nepaguhohug ni Hesus ta isin a “Dumagdag kan la teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","A sangaw naglipay i Pedru, a dumagdag hapa i Hwan nga takdayen ituldu ni Hesus nga pake kofun na. Intu hala ya kahebing ni Hesus ta nepamurab da en ikid na nangpohut tentu ta nangitalaba en tentu. ");
INSERT INTO agt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","A ta nepakaita ni Pedru tentu a nebar na hapa te Hesus. “A anu sangaw ya makkwa ta takdayin, Afu?” kunna. ");
INSERT INTO agt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","“A am ikayat ku ta matolay addet ta awek pagtoli ta lutakin a anu hud ya pakolangam? Intu la nonotam ya dumagdag teyak,” kun ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A gafu ta inuhohug ni Hesusen a simaned hala ya bida ta ngamin kiden nagkakabagis ta awena sangaw masi ni Hwan. Ammi awena haman nebar ni Hesus ta awena masi am awa “Anu hud ya pakolangam am ikayat ku ta matolay addet ta awek pagtoli ta lutakin,” kunna. ");
INSERT INTO agt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A iyak hala ya ituldu ni Hesus nga nagsurat ta isin na surat, te iyak hala ya nangipasikkal ta tarabaku na en. A amu na ngamin tolay sin ta kakurugan ya nepasikkal ku tekid. ");
INSERT INTO agt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","A addu para ya iningwa ni Hesus ta ketta na en ta isin, ammi am sa nesurat mina ya ngamin kiden iningwa na a awan de ta ketunan na ngamin kiden lebru.");
INSERT INTO agt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nagsuratak ha teko, Teyopilo, te itta ya itulfuk ta napolu en surat ku teko. Intu la nabidak ta napolu en surat ku ya tinarabaku ni Hesus ikid na netuldu na en ta nepamegafu na en addet ta araw na netattullu na en ta langit. ");
INSERT INTO agt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","A ta kuman na nesurat ken a natolay hala i Hesus ta kabalinan na nepamapasi da tentu, a kanayun nakipaita ta turin na kiden pinili na addet ta appatafulu na araw. A addu hapa ya nepaita na tekid nga mangipasikkal ta katolay na, yaga addu para ya netuldu na tekid ta gagangay na pangikerutan na Namaratu. A yen kid hapa ya pinatudunan na ta pakapangwa na Kahalwa na Namaratu, petta ange kid sangaw mangipadangag ta ngagan na. ");
INSERT INTO agt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","A ta pagaammung nig Hesus ikid na turin na kiden a nagkakakan kid. A ya uhohug ni Hesus tekid a “Awemuy bit hama magtugut ta isin ili na Herusalem, te indagan muy bit ya Kahalwa na Namaratu nga dana nekari ni Damakewan tekamuy, te doban na hala sangaw tekamuy ta kuman na nepadangag ku tekamuy ta idi. ");
INSERT INTO agt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Te maski am zinigut na kanan ni Hwan a mapasinapān kam hapa sangaw ta Kahalwa na Namaratu, petta makustu ya pagzigut na en tekamuy,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","A sangaw ta takday ha na araw a sa nagkakampat kid ta utun na bagetay na Olibo, a itta ya pinohutan da te Hesus. “Afu, damagan mi haen teko am arawin yan de ya pangpatugut mu ta taga Roma kiden nga nanggubat ta lugar tamin, petta ikitam hapa la nga Hudyo ya makkamu ta lugar tamin?” kunda. ");
INSERT INTO agt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A ya tabbag na en hapa tekid a “Namaratu hapa la ya makkamu am kanu sangaw na darun ikid na araw, ammi awena haman mebar tekamuy. ");
INSERT INTO agt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ammi am dumatang na sangaw ya Kahalwa na Namaratu tekamuy a mapasinapān kam hapa ta pakapangwa na en, petta itta ya turad muy nga mangipasikkal teyak ta tolay kiden. A mamegafu kam sangaw ta ili na Herusalem ikid na ngamin lehut na en ta lugar na Hudeya, kapye muy sangaw umange ta Samariya ikid na ngamin kiden lugar abat ta pagaddetan na lutakin,” kunna hapa tekid. ");
INSERT INTO agt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","A tentun nakauhohug ta isin a kima-ma la timullu ta langit, a tinatangad da la nga timullu abat ta limitap ta kulamen. ");
INSERT INTO agt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","A tekid para la imatangad a dimmatu ya duwa na anghel ta hebing da en nga nagbarawasi ta furaw. ");
INSERT INTO agt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","A ya uhohug na anghel kiden tekid a “Anu umatayuk kam para la nga imatangad ta langit? Nagtugut na haman i Hesusen, te ittan ta langit ewan. Ammi magtoli hala sangaw, te dumagut hala sangaw ta lutakin ta kuman na nepakaita muy ta netattullu na en,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","A ta nekabalin na a dumagut ya turin na kiden ta bagetay na Olibo, te yen ya nangtugutan ni Hesus tekid, a nanoli kid na ta umag na ili na Herusalem, te abikan la, te kuman na takday kilumetru ya kadayu na abat ta bagetayen. ");
INSERT INTO agt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","A ta datang da ta ili en a nagdulot kid hala ta bali en nga pagammakan da, a gimon kid hapa ta nagingutunen silid ta bali en. Itta i Pedru, ikid ni Hwan, a Santiago, ikid ni Andres, a Felipe, ikid nig Tomas, ikid ni Bartolome, a Matyu, ikid ni Santiago nga anak ni Alfeyo, ikid ni Simonen nga nakitapil ta idi ta gubyernu na taga Roma kiden, ikid ni Hudas nga anak na takday Santiago. ");
INSERT INTO agt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","A sa nagyan kid ten makimalmallak ta Namaratu, kontodu hina ni Hesus ikid na kadwan kiden babay ikid na kabagis kiden ni Hesus, te nagdadagga hapa ya nonot da. ");
INSERT INTO agt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","A ta pagpasan na pigahaw a nagaammung ha ya magatut a dwafulu na mangurug, a nagtayuk hapa i Pedru ta nagtatangnganan da, te magbida tekid. ");
INSERT INTO agt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Amu muy, kahkahulun ku, ya iningwa ni mina Hudasen, te intu bit ya takday kahulun tam nga nakikahulun te Hesus, a nesipat hapa ta tarabaku tamen. Ammi intu haman ya nangitalaba te Hesusen, te enna netulud ya nanggafut kiden tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ammi ta nepakaita ni Hudas ta pinapasi dan i Hesusen a nagbabawi, a enna netoli ya netandan na padi kiden tentu, a sangaw enna hapa nesagapil ya bari na en te Hesus, te kinaddangan na ya hul na, a nagbesin na. A tentun bumlad a nabattak ya sirat na en, a nekutkutet na ta lutak. Ammi ya piraken nga netoli na ta padi kiden, a yen ya negatang da ta lutak, petta ketanaman na takwan na tolay. ");
INSERT INTO agt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","A ta nepakadamag na tolay kiden taga Herusalem ta lutaken nga ginatang da a ‘Lutak na Daga’ ya nengagan da ta lutaken. Ammi ya ngagan na ta agsitang na Hudyo kiden a ‘Akeldama’.) ");
INSERT INTO agt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","(v 16a,20) A ya tulfu na uhohug ni Pedru a intu yan: “A mappya mantu, kahkahulun, ta nagdulot ya nebar na Kahalwa na Namaratu gafu te mina Hudasen, te nesurat na haman ni mina Dabiden ta lebru na Kansyon kiden, te ya nebar na a ‘Mappya ta awan sangaw ta matolay nga masirak ta bali na en, a takwan mina ya metali tentu ta saad na en,’ kunna. ");
INSERT INTO agt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","A yen ya gafu na, kahkahulun ku, ta magpili kitam mina ta tali ni mina Hudasen, petta intu sangaw ya kahulun mi nga mangipasikkal ta katolay ni Hesusen. Ammi intu mina pilin tam ya takday kahulun tam nga lalaki nga dana dumagdag te Hesusen namegafu ta nepangzigut ni Hwan te Hesus abat ta netattullu na en ta langit ewan.” kunna. ");
INSERT INTO agt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","A gafu ta uhohug ni Pedru tekid a nebar da ya ngagan ni Matyas ikid ni Hose Husto, ammi Barsabas hapa ya takday ngagan ni Hose. ");
INSERT INTO agt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","A sangaw nakimallak kid; “Ay Afu, amum ta nagtalekudan ni Hudas ya saad na en, a ittan ta lugaren nga dana neparam tentu. A gafu ta iko la ya makkamu ta nonot na ngamin tolay a ituldum mantu tekami am inya ya pinilim ta duwa kidin, ");
INSERT INTO agt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","petta metali mina te mina Hudasen anna makipagserbi ta kadwan kiden turim,” kun na pakimallak da. ");
INSERT INTO agt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","A sangaw pinagkihu da ya nakesuratan na ngagan na duwa kiden, kapye da sinukkut ya takday, a ya ngagan ni Matyas ya nesukkutan da, a intu mantu ya tali ni mina Hudasen, a nelista ya ngagan na ta kadwan kiden turin ni Hesus. ");
INSERT INTO agt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","A sangaw ta kārawān na Pyesta na Pentikostes a sa nagkakampat ya mangurug kiden ta takday na bali. ");
INSERT INTO agt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","A magananwan la a nepagka-ma da ya masikan na adug nga nagafu ta langit ta kuman na masikan na paddad, te simarok ya adugen ta umag na bali en nga nagyanan da, ");
INSERT INTO agt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","yaga itta hapa ya sinang afuy nga nagtabnak ta ulu na tagtakday tekid. ");
INSERT INTO agt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","A ka-ma la naggagindan kid maguhohug ta magdaduma na agsitang, te sa napasinapān kid na ta Kahalwa na Namaratu, a inatadan na ya tagtakday tekid ta uhohugan da. ");
INSERT INTO agt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A ta arawin yen hapa a dana ittan ten Herusalem ya pake addu na tolay nga nagafu ta magdaduma na lugar ta ngamin paglelehut, te umange kid nakipyesta ta sakā Hudyo da kiden, te dana simarok kid na ta relisyon na Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","A nepagka-ma da hapa ya sitang na naguhohug kiden ta magdaduma na agsitang, a enda kid pake dangagan. A pake nepagpaka-lat da kid hapa, te nadangag da ya kuman na tagtakday agsitang da ta bida da en. ");
INSERT INTO agt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","“Taga Galileya haman ye-yan kid na tolay, a pa-pa-nun da mantu makauhohug ta dana agsitang tam kidin?” kunda. A pake nefulot ya pagpaka-lat da nga mangdangag ta uhohugan da. ");
INSERT INTO agt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","A ya tolay kiden nga nakadangag a itta ya taga Partya, ikid na Medya, Elam, Mesopotamya, Hudeya, Kapadosya, Pontu, ikid na Asya. ");
INSERT INTO agt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","A ya kadwan kiden ya taga Parigya, Pampiliya, Egipto, ikid na kadwan kiden lugar ta iten Libya ta bikat na Sirene. A itta hapa ya kadwan kiden taga Roma nga Hudyo ikid na Hentil nga dana simarok ta relisyon na Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","A ya kadwan kiden para a taga Kareta kid ikid na Arabya, a nagdaduma hapa ya ngamin kiden agsitang da. A yen ta nagpaka-lat kid nga magdangag, te ya nebar da a “Anu haman ta bidan da ya pakapangwa na Namaratu ta agsitang na gintatakdayan tekitam?” kunda. ");
INSERT INTO agt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","A gafu ta napopoyung kid na a nagimpopohutan da para am anu ya gafu na pakauhohug da ta takwan na agsitang. ");
INSERT INTO agt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ammi ya kadwan tekid a nedadula da kid, te “Magilellaw kid malat O,” kunda. ");
INSERT INTO agt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ammi ta nepakadangag ni Pedru ta inuhohug na tolay kiden a imatubang na tekid, a pake pinasikan na ya paguhohug na, petta dangagan da ya tabbag na ta inuhohug da en, a nakihebing hapa tentu ya kagitta na kiden turin. “Ikamuy, kahkahulun, ikid na kagittak nga Hudyo,” kunna. “A dangagan muy ya uhohug ku tekamuy, kontodu ikamuy nga magpasyar ta isin Herusalem. ");
INSERT INTO agt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","A awemuy mina pahig ta nellaw kami na kahulun ku kidin ta isin, te itta hud ya mellaw am lalakwat para la. ");
INSERT INTO agt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","Intu la nagdulot tekami ya kuman na dana binida ni mina Howel nga aglavun na Namaratu ewan, te ya uhohug na en ta dadagkal tam kiden a ‘Itta ya nepadangag na Namaratu ewan teyak,’ kunna, ‘te sangaw am tanagay na kan ya pagaddetan na arawin yan a pasinapān na kan sangaw ya ngamin tolay ta Kahalwa na, a ya simsima muy kiden nga lālāki ikid na babay a manglavun kid. A itta kan sangaw ya magmatakar ta lālāki muy kiden, a makatahinap kan sangaw ya kalalaklakayan muy kiden. ");
INSERT INTO agt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","A ya ngamin kiden daddoban na Namaratu nga lalaki pase babbay a pasinapān na kid kan sangaw ta Kahalwa na, petta manglavun kid,’ kunna. ");
INSERT INTO agt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","“A ya takday para uhohug ni mina Howel a ‘Itta kan sangaw ya ipaita na Namaratu ta langitewan ikid na lutakin nga pagpaka-latan na tolay kiden, te itta kan sangaw ya daga ikid na afuy ikid na makanag na asok. ");
INSERT INTO agt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A sangaw am magsugiram kan ya bilag, ikid na magdarag ya hulan ta kuman na daga, a yen kan sangaw ya kadakalan na araw na Dafu tam nga kahighigalan, te yen kan ya araw na pangpa-gang na ta ngamin kiden nakaliwat ta utun na lutakin. ");
INSERT INTO agt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ammi maski am inya kan sangaw ya makimallak tentu a ikerutan na,’ kunna paen ni mina Howel, kahkahulun. ");
INSERT INTO agt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“A dangagan muy mantu, kahkahulun, ya ibar ku para tekamuy, te ya lalaki en Hesus nga taga Nasaret, a nepasikkal na ta intu hala ya dinob na Namaratu ewan, te dana amu muy haman ya ngamin kiden iningwa na ta atubang tam nga nagpaka-latan tam ikid na nakaitan tam ta pakapangwa na en, a yen kid ya mangipasikkal ta itta ya Namaratu tentu. ");
INSERT INTO agt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ammi gafu ta uray na Namaratu a ye-yen hala na tolay ya dinob na nga mangikaru ta liwat tam kiden, a nepalubus na mantu ta itta ya mangitalaba tentu petta idarum muy. A ye-yan na tolay ya nepapapasi muy, te emmuy haman netulud ta awan kiden makkamu ta Dyos petta pagappan da ta kayu. ");
INSERT INTO agt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ammi maski kunna ten a natolay hala, te inubadan na Namaratu ya pasi na, te awena mabalin ta iguwad na pasi na en. ");
INSERT INTO agt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“A gagangay ta natolay hala i Hesusen, kahkahulun, te ya nesurat ni mina Dabiden a nelavun na ya uhohugan na sangaw ni Hesus, te ya nebar na a ‘Kanayun mariknak ya pakihulhulun na Dafu kin, a awek na mantu magburung, te itta la ya Namaratu ta hebing ku. ");
INSERT INTO agt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","A ikansyon ku mantu ya talak na nonot kin, te maski am anu ya dumatang teyak a itta ya ikatalak ku ta matolayak hala. ");
INSERT INTO agt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Te amuk, Afu, ta awem la isirak ya kahalwakin ta agyan na nagpasi kiden, ikid na awem la ipalubus ta malabag ya barikin gafu ta takit na nonot mu teyak. ");
INSERT INTO agt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mappya hapa yen, Afu, te netuldum teyak ya dalan na katolay ku, petta magayayatak sangaw ta atubang mu,’ kun na surat ni mina Dabiden. ");
INSERT INTO agt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ammi ya pake ipasikkal ku para tekamuy, kahkahulun, a bakkan haman ta bari ni Dabiden ya ikayat na uhohugan na surat na en, te pake nabayag na haman ya nepasi na en, a itta la ya tanam na en tekitam abat ta ayanin. ");
INSERT INTO agt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ammi gafu ta aglavun i mina Dabiden a yen ya linavun na te Hesusen, te ninonot na ya nepagasingan na Namaratu tentu ta pagbalinan na sangaw ya takday simsima na ta pake atata-nang na ari nga makkamu ta ngamin. ");
INSERT INTO agt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A kuman na aitan ni mina Dabiden ya simsima na en nga magbalin sangaw ta Mangikerutan, kumanen hapa ta pasi na ikid na katolay na en. A yen ta dana inuhohug na ya uhohugan na simsima na en ta awena sangaw masirak na kahalwa na en ta agyan na nagpasi kiden, ikid na awena sangaw malabag na bari na en. ");
INSERT INTO agt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","A awan mantu ta takwan na binida ni mina Dabiden am bakkan la te Hesus, te intu hala ya tinolay na Namaratu ewan, a ikami hapa ya mangipasikkal ta katolay na, te ikami ya nakaita tentu. ");
INSERT INTO agt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","“A gafu ta pinātā-nāng na Namaratu ewan a intun ya makkamu magturay ta ngamin, a pinakimohayan na Dama na en, petta intu ya mangidob ta Kahalwa na en nga dana nebar na tekami. A i Hesus mantu ya nagafun na naita muyen tekami ikid na agsitang kiden nga nadangag muy. ");
INSERT INTO agt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","A bakkan mantu ta bari ni mina Dabiden ya ikayat na uhohugan na surat na en, te bakkan haman ta intu ya timullu ta langitewan am awa Dafu na en, te ya uhohug ha ni Dabiden ta takday para na surat a ‘Nadangag ku ya uhohug na Namaratu ta Dafu kin, te “E ka sin magtuttud ta ziwanan kin, ");
INSERT INTO agt_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","te pagbalinan ku sangaw ya katapil mu kiden ta daddobam,” kunna tentu.’ ");
INSERT INTO agt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Mappya mantu, kahkahulun, ta ikamuy ngamin nga Istralita ya pake makkamu ta iningwa na Namaratu ewan, te ya Hesusen nga pinagappa muy a intu hala ya pinagbalin na Namaratu ewan ta Dafu tam ikid na Mangikerutan tekitam,” kunna. A yen la ya abat na binida ni Pedru tekid. ");
INSERT INTO agt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","A ta nepakadangag da ta uhohug ni Pedru a pake narikna dan ya liwat da, a pinohutan da teg Pedru ikid na kagitta na kiden turin am anu mina ya kwan da petta mapakoma kid mina. ");
INSERT INTO agt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","A ya tabbag ni Pedru tekid a “Magbabawi kanan mina ta gagangay muy ikid na liwat muy, a pazigut kanan ta ngagan ni Hesus Kristu, petta pakoman na kam, a maatadan kam hapa sangaw ta Kahalwa na Namaratu. ");
INSERT INTO agt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Te yen ya nekari na Dafu tam Namaratu tekitam Hudyo ikid na anak tam kidin, kontodu ngamin kiden agagayan na nga taga adayu na lugar,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","A addu para ya nedagga ni Pedru ta nepagtabarang na tekid. “Ikerutan muy ya bari muy, petta awemuy mina mekabkabat ta kagitta muy kiden nga magnonot ta killu na nonot,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","A ya ngamin kiden nangurug ta inuhohug ni Pedru a pazigut kid hapa, a itta ya talluribu na tolay nga nedagga ta mangurug kiden ta arawin yen. ");
INSERT INTO agt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","A kinanghahaw kid nga naggagimung, te pake ikayat da ya magdangag ta ituldu na turin kiden, ikid na makimallak, ikid na magkakan ta netuldu ni Hesus tekid ta panadamdaman da ta pasi na en. ");
INSERT INTO agt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","A pake nahigalan ya ngamin tolay gafu ta mangurug kiden, aglalo teg Pedru ikid na kagitta na kiden turin, te addu ya pinadpadatu da ta pakaitan ta pakapangwa na Namaratu tekid. ");
INSERT INTO agt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A ya gagangay hapa na mangurug kiden a sa naggagitta ya ngamin nonot da, te naginsipsipat kid ta ngamin kiden kwa da. ");
INSERT INTO agt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","A am itta ya awan tekid a maglaku ya kadwan kiden ta lutak da ikid na kukwa da, otturu nesaned da ya naglakun da en ta awan kiden ta kwa. ");
INSERT INTO agt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","A naghahulun kid hapa nakigimung ta simbaan na Namaratu ta kinanghahaw, kapye da nakipagkakan ta babali da kiden. A pake nagayayat kid, ");
INSERT INTO agt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","te matalak kid nga magdayaw ta Namaratu ewan, a pake nekamat da kid hapa na kadwan kiden tolay. A dumakal la dumakal ya kaddu na mangurug kiden, te kinanghahaw itta ya nedagga na Namaratu ta bagu kiden mangurug. ");
INSERT INTO agt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","A sangaw ta takday na araw ta furab a umange ig Pedru ikid ni Hwan ta simbaanen, te yen ya oras na pakimallak na Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A tekid simarok ta kinan da en “Ispot na Irwangan” a itta ya pilay nga nagidda ta bikat na irwanganen, a nakilimlimut, te dana pilay kan abat ta nekeanak na en, a kada araw iange da ta irwangan na simbaanen, petta makilimlimut ta tolay kiden nga umange makimallak. ");
INSERT INTO agt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","A ta nepakaita na teg Pedru ikid ni Hwan nga simarok ta simbaanen a nagadang hapa ta limut na tekid. ");
INSERT INTO agt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","A itan da la bit, kapye na nebar ni Pedru ta “Tangadan na kami bit ay,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","A tinangad na kid hapa, te matalak ta itta ya igawat da tentu. ");
INSERT INTO agt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ammi ya uhohug ni Pedru tentu a “Awan haman ta pirak ku, ammi iatad ku hala teko ya itta teyak. Magtugut kan mantu gafu ta pakapangwa ni Hesusen nga Mangikerutanen taga Nasaret,” kunna ta pilayen, ");
INSERT INTO agt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","kapye na inibbalan ya kamat na en a pinatayuk na. A ka-ma la nagsikan ya nagtotopan na tulang na takki na kiden. ");
INSERT INTO agt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A timollok nagtayuk, a nagpapa-yat na. A sangaw himulun hapa teg Pedru nga simarok ta simbaanen, a netoltollok na hapa ya pakatugut na ikid na pagdayaw na ta Namaratu. ");
INSERT INTO agt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","A ya kadwan kiden tolay ta umag na simbaanen, a dinadulangan da la ya lalaki en nga magpapa-yat magdayaw ta Namaratu, ");
INSERT INTO agt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","a nabilbig da ta intu hala ya pilayen nga imatogkok nakilimlimut ta Ispot na Irwangan na simbaanen, a umagahalang kid la tentu, te anu kawagan na ta nakatugut na. ");
INSERT INTO agt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","A tekiden imuhet a gimafut para la ya lalaki en teg Pedru, a alistu hapa ya tolay kiden nga ange nangkalihung tekid ta agyan na kinan da en Pagsigongan ni Solomun ta hebing na simbaanen, te pake nepagpaka-lat da ya pilayen nga nagtayuk. ");
INSERT INTO agt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","A ta nepakaita ni Pedru ta tolay kiden nangkalihung a nagbida hapa tekid. “Anu kawagan na, kahkahulun, ta pagpaka-lat muy ya pagmappya na lalaki in? A anu haman ta umagahalang kam tekami ta kuman na ikami ya namagmappya tentu? Itta hud ya pakapangwa mi petta mapatugut mi ya pilayin? ");
INSERT INTO agt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Awan ta takwan na namagmappya ta tolayin yan am bakkan ta Namaratu ewan nga Dyos na gingginafu tam kiden Abraham, ikid ni Isak, ikid ni Hakob, te uray na ta mesipat ya ngagan na Anak na en Hesus ta pakedayawan na en petta makapagmappya ta pilayin. “A intu hala ya emmuy netulud te Gubernadoren Pilato petta papapasi muy. A inibbatan na mina ni Pilato en ammi inawe muy haman. ");
INSERT INTO agt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Inawe muy mantu ya mappya na tolay nga negitta ta Namaratu ewan, a intu hud la pinalattog muy ya nabaluden nga namapasi ta tolay. ");
INSERT INTO agt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","A ya mangataden mantu ta pagtolayan tam a yen haman ya nepapapasi muy. Ammi maski kunna ten a tinolay hala na Namaratu ewan, a ikami hapa ya nakaita ikid na mangipasikkal ta katolay na. ");
INSERT INTO agt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","A gafu ta ngagan ni Hesusen ikid na pangikatalak mi tentu a pake mappyan ya bari na lalaki in yan, te maita muy haman, a dana amu muy hapa ta pilay ta idi, ammi masikan kad na magtugut. ");
INSERT INTO agt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“A maski am nepersa muy ya pasi ni Hesusen a amuk, kahkahulun, ta awemuy amu ya iningwa muy, a kumanen hapa ta pinakadakal muy kiden. ");
INSERT INTO agt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ammi gafu ta pagkilluyan na nonot muy a nagdulot hala ya nabar na Namaratu ta aglavun kiden ta mazigatan ya dinob na en Mangikerutan. ");
INSERT INTO agt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","A mappya mantu ta magbabawi kanan, a makipakoma kam tentu petta azin na ya liwat muy kiden, a paglampawan na sangaw ya pagzigātān muy. ");
INSERT INTO agt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","A doban na ha sangaw i Hesus tekitam, te intu hala ya Mangikerutan nga dana nebar na ta dadagkal tam kiden. ");
INSERT INTO agt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ammi mappya ta magyan la bit ta langitewan abat ta pangpabagu na Namaratu ta ngamin paglelehutin, te yen ya dana nebar na aglavun na kiden ta palungu na araw. ");
INSERT INTO agt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Ya uhohug ni mina Mosesen ta dadagkal tam kiden a ‘Mangidob sangaw ya Namaratu ta takday aglavun ta kuman na nepangidob na teyak, ammi kagitta muy hala sangaw, a mappya ta dangagan muy ya ngamin ituldu na tekamuy. ");
INSERT INTO agt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ammi ya awan sangaw mangdangag ta aglavunin yen a madugiman sangaw medagga ta tolay kiden na Namaratu a mapa-gang,’ kunna. ");
INSERT INTO agt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“A maski i mina Samwel ikid na kadwan kiden aglavun na Namaratu nga timunud tentu a sa ikid haman ya dana nangibar ta dumatangen tekitam ta araw tam. ");
INSERT INTO agt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","A ikitanan mantu ya nagdulotan na ngamin binida na aglavun kiden, a sa mesipat kitam hapa ta nakitahatun na Namaratu ta dadagkal tam kiden, te yen haman ya uhohug na te mina Abrahamen: ‘Bendisyonan ku sangaw ya ngamin tolay ta paglelehutin gafu ta takday na simsimam nga magafu sangaw teko,’ kunna haman te mina Abrahamen. ");
INSERT INTO agt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","A yen ta ikitam Hudyo ya napolu nangidoban na Namaratu ta Anak na en Hesus, petta mabendisyonan kitam gafu tentu, petta pagtalekudan tam ya gagangay tam nga awan ta kapkappyan na,” kunna. A yen ha ya addet na uhohug ni Pedru tekid. ");
INSERT INTO agt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","A ta paguhohug da para la nig Pedru ta tolay kiden a neddatangan na kid na padi kiden, ikid na kapitanen ta simbaanen, ikid na Saduseyu kiden. ");
INSERT INTO agt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","A nagporay kid na teg Pedru gafu ta ituldu da ya tolay kiden, yaga aweda ikayat ya netuldu da en ta matolay sangaw ya nagpasi kiden gafu ta katolay ni Hesusen. ");
INSERT INTO agt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","A yen ta ginafut da kid, ammi gafu ta furab na a enda kid bit ibalud, petta idarum da kid sangaw ta lalakwat. ");
INSERT INTO agt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ammi maski kunna ten a dana addun ya nangurug ta uhohug nig Pedru, a pake umaddun ya bilang na ngamin kiden mangurug te Hesus, te ya bilang na lālāki la a limaribu kid. ");
INSERT INTO agt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","A sangaw ta lalakwat a nagkakampat ya ngamin kiden pinakadakal na Hudyo kiden ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","A nehulun hapa ig Annas nga mayor na padi kiden, ikid ni Kaypas, a intu hapa kahulun da ya takday na Hwan, ikid ni Alehandru, ikid na kadwan kiden para kahulun ni Annas. ");
INSERT INTO agt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","A sangaw nepaalap da ig Pedru ikid ni Hwan, a pinagtayuk da kid ta nagtatangnganan na nagkakampat kiden, kapye da kid inimbestigar. “Anu hud ya pakapangwa muy, ono inya hud ya nginaganan muy, petta magmappya ya pilayen?” kunda tekid. ");
INSERT INTO agt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","A pake napasinapān i Pedru ta Kahalwa na Namaratu ta pagtabbag na tekid: ");
INSERT INTO agt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“Apo Kadadakalan,” kunna. “Am imbestigaran da kami gafu ta mappya na tarabaku nga iningwa mi ta pilayin ");
INSERT INTO agt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","a ipadangag ku mantu ya gafu na tekamuy, kontodu ngamin kiden kagittak nga Istralita. Te ya pakapangwa na ngagan ni Hesus nga Mangikerutanen taga Nasaret a yen ya gafu na ta nagmappyan ye-yan na lalaki, petta makatayuk ta isin atubang muy. ");
INSERT INTO agt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“I Hesusen mantu ya batu en nga dana nabida ta surat na Kansyon kiden, te intu hala ya neatad na Namaratu tekamuy petta isaad muy mina ta kuman na kepundasyon na bali, ammi newarad muy haman. Ammi netoli hala na Namaratu, a pinagbalin na ta kadakalan na batu ta bali na. Te maski am pinagappa muy a tinolay hala na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","A awan ta takwan na mangikerutan am bakkan te Hesus, te awan pulus ta takwan na neatad na Namaratu ewan ta ikatalak tam mina, petta mekerutan kitam,” kun ni Pedru tekid. ");
INSERT INTO agt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","A ta nepakadangag na padi kiden ta uhohug nig Pedru ikid ni Hwan a “Anu haman ta maturad kid, bakawa gagangay kid haman la na tolay nga awan ta adal?” kunda. A sangaw ninonot da ta maturad kid gafu ta kahulun na kid ni Hesus. ");
INSERT INTO agt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ammi awan haman ta pangihuyan da tekid, te aitan da haman ya lalaki en ta nagmappyan, a umatayuk hapa ta hebing da en. ");
INSERT INTO agt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","A gafu ta kumanen a pinadayu da kid bit ta assang, te pagbabidan da bit am anu ya uray da tekid. ");
INSERT INTO agt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“A anu mantu ya kwan tam ta isin kid na tolay? Awena haman melemad ya nehuga da ta pilayen, te amu haman na ngamin tolay ta ngamin ili na Herusalem?” kunda. ");
INSERT INTO agt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ammi tekid na nakanonot a “Mappya ta pake tātālawan tam kid, petta awedan sangaw ipadangag ya ngagan ni Hesus ta tolay kiden, petta awenan sangaw dumakal na uhohug,” kunda. ");
INSERT INTO agt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","A sangaw pinaayagan da ha ig Pedru, a pake nebar da ta awedan sangaw ipadangag ya ngagan ni Hesus. ");
INSERT INTO agt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ammi ya tabbag nig Pedru tekid a “Mappya ta pake nonotan muy am anu ya ikayat na Namaratu ewan, te mapmappya hud ta ikamuy ya kurugan mi ammi tentu? ");
INSERT INTO agt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ammi am ikami a awena mabalin ta awemi ipadangag ya naita mi ikid na nadangag mi,” kunda. ");
INSERT INTO agt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","A gafu ta kumanen a pake tinatalaw da kid ha, kapye da kid pinatugut, te awan haman ta pambar da nga mangpa-gang tekid gafu ta tolay kiden, ");
INSERT INTO agt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","te sa matalak ya ngamin tolay, a dinayawan da ya Namaratu gafu ta iningwa nig Pedru ta pilayen, te nasurok ta appatafulu na darun ya kapilay na en. ");
INSERT INTO agt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","A ta nepakauhet nig Pedru ikid ni Hwan a umange kid ta agyan na kahulun da kiden mangurug, a binida da ya uhohug na padi kiden ikid na kalalaklakayan na Hudyo kiden tekid. ");
INSERT INTO agt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","A gafu ta binida da en tekid a sa nagdadagga kid na nga makimallak ta Namaratu: “Ay Afu Namaratu, iko hala ya Dyos mi nga namadday ta langit ikid na lutak ikid na bebay ikid na ngamin kiden matolay ta paglelehutin. ");
INSERT INTO agt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","A ta ayanin, Afu, nonotam ya nepeuhohug mu ta tagabumen mina Dabid nga pinasinapam ta Kahalwam, te ya uhohug na en ta takday na surat a ‘Anu haman ya pagloko na Hentil kiden ta ikatupag da ya Namaratu? Aweda hud amu ta melogot kid? ");
INSERT INTO agt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Te mangiparan haman ya ari da kiden ta gubat, petta maghahulun kid nga makitapil ta Namaratu ikid na dinob na en nga Mangikerutan,’ kunna. ");
INSERT INTO agt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","A kakurugan, Afu, ya inuhohug ni Dabiden, te nagdulot hala ya kuman na binida na en ta isin ili na Herusalem, te i Ari en Herud, ikid na Hudyo kiden, ikid ni Gubernador Pilato, ikid na Hentil kiden, a sa ikid haman ya nangigakkad ta pasi na anak men Hesus nga netunglak mu ta dafu mi. ");
INSERT INTO agt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","A maski aweda naamu a nedulot da hala ya dana negakkad mu ta nonot mu hapa la. ");
INSERT INTO agt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","A ta ayanin, Afu, a nonotam ya panatalaw da tekami, a atadan na kami hapa ta turad mi, petta awemi sangaw magtalaw nga mangipadangag ta uhohug mu, te ikami ya daddobam. ");
INSERT INTO agt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","A uyadam hapa ya kamat mu, Afu, petta magmappya ya magtatākit kiden, a mangihuga ka hapa ta pakaitan, petta mehulun hapa ya pakapangwam ta pangipadangag mi ta ngagan na anak men Hesus, Amen,” kun na pakimallak da. ");
INSERT INTO agt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","A tekid nabalin nakimallak a nawalwag hapa ya bali en nga nagāmmungan da, a sa napasinapān kid ta Kahalwa na Namaratu, a pake naturad kid nga nangipadangag ta uhohug na Namaratu. ");
INSERT INTO agt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A ya ngamin kiden mangurug nga nagyan ta ili na Herusalem a nagdadagga ya ngamin nonot da, a awan ta naginggum tekid am awa sa kwa da ngamin ya kwa na takday tekid. ");
INSERT INTO agt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","A ya turin kiden hapa a pake masikan ya pangipasikkal da ta katolay ni Hesus, a dakal hapa ya panguffun na Namaratu tekid ngamin. ");
INSERT INTO agt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","A awan hapa ta kurang na maski am takday la tekid, te ya kadwan kiden nga makākwa ta bali ono lutak a nelaku da hapa ya kwa da, ");
INSERT INTO agt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a sangaw nedatang da ya naglakun da en ta turin kiden, otturu nesaned da hapa ta tagtakday tekid ta mekustu ta masapul da. ");
INSERT INTO agt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Kumanen hapa ya iningwa ni Hose en nga taga Sipre, te nelaku na ya takday lutak na, a neange na hapa ya naglakun na en ta turin kiden petta isaned da. Ammi ya agngilinan da te Hose a Barnabas, gafu ta malalaki mangpaturad ta kahulun na kiden. ");
INSERT INTO agt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","A itta hapa ya magatawa, ig Ananayas ikid ni Sapira, nga naglaku hapa ta kadwan lutak da, ");
INSERT INTO agt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ammi nagbidan da ta magkontrabisyon kid hapa ta mazigatan kiden, ammi aweda sa ikontrabisyon ya ngamin naglakun da en, te isirak da ya kadwan. A sangaw nedatang ni Ananayas ya iatad da en ta turin kiden. A ya uhohug na tekid a “Nelaku min hapa ya takday lutak mi, a itta in ya ngamin naglakun mi,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ammi ya uhohug ni Pedru tentu a “Ananayas, anu kawagan na ta iningwam ya nepanonot ni Satanas teko? Nagtuladam mantu ya Kahalwa na Namaratu, te nesirak mu haman ya kadwan naglakun muy ta lutak muyen. ");
INSERT INTO agt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Awemuy hud lutak ta awemuyen para la pangilaku? A maski nelaku muy a inya hud ya makākwa ta naglakun muyen am bakkan ta ikamuy hapa la? Anu kawagan na mantu ta nakanonot ka nga magtulad? Bakkan haman la ta tolay ya nagtuladam, te pahig mu ta melemad mu hapa ta Namaratu ewan,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","A ta pakadangag ni Ananayas ta uhohug ni Pedru a ka-ma la natukalit nasi. A enna inulolatan na babbagu kiden ya bari na en kapye da neuhet netanam. A pake nagtalaw na hapa ya ngamin kiden nakadangag ta pasi na. ");
INSERT INTO agt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","A sangaw ta nepagpasa na kuman na tallu na oras a dumagdag hapa ya atawa na en Sapira ta agyan na turin kiden, ammi awena amu ta nasin ya atawa na en. ");
INSERT INTO agt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","A ya uhohug hapa ni Pedru tentu a “Ibar mu bit am ye-yan ya ngamin naglakun muy ta lutak muy?” kunna. “A on ay, intu la yen,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","“Anu kawagan na ta nagbidan muy na atawam ta magtulad kam ta Kahalwa na Dafu tamewan? Itam awa dumatang na ya ume kiden nangitanam ta atawamen, a ikon hapa ya itubbat da itanam ta ayanin,” kun ni Pedru tentu, ");
INSERT INTO agt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","A ka-ma la natukalit hapa nasi. A ta nesarok na babbagu kiden a neddatangan da ya babbayen nasi, a neuhet da hapa netanam ta hebing na atawa na en. ");
INSERT INTO agt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","A gafu ta kumanen a pake nagtalaw na ya ngamin kiden mangurug kontodu ngamin nakadangag ta isin. ");
INSERT INTO agt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","13","A ya gagangay na turin kiden a nagdadagga ya nonot da nga kanayun magkakampat ta Pagsigongan ni Solomun nga netulfu ta simbaanen. A pake dinayawan na kid hapa na tolay kiden nga umange nagdangag tekid, ammi ya kadwan kiden mangurug a aweda nesipat ta tarabaku da gafu ta talaw da. A addu hapa ya nehuga na turin kiden ta tolay kiden nga kimahad tekid. ");
INSERT INTO agt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","A kinanghahaw umaddu la ya mangurug te Afu Hesus nga lālāki pase bābāy. ");
INSERT INTO agt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","A gafu ta kumanen am kada magtalib i Pedru ta babali kiden nga ange ta agyan na simbaanen a alapan hapa na tolay kiden ya nagtatākit kiden ta bali da, a iange da kid itabnak kontodu agiddan da kiden ta aāngen ni Pedru petta masi-ged na kid na alinu na en am magtalib, talo am yen ya pagmappyān da. ");
INSERT INTO agt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Maski ya tolay kiden ta kadwan kiden lugar nga abikan ta ili na Herusalem a enda hapa nekahad tekid ya nagtatākit kiden ikid na pinagzigat na anitu, a sa nagmappya kid ngamin. ");
INSERT INTO agt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ammi ya mayor na padi kiden ikid na kahulun na kiden nga Saduseyu a pake pumassil kid na ta turin kiden, ");
INSERT INTO agt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","a yen ta enda kid nepagafut, a nepebalud da kid. ");
INSERT INTO agt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","A sangaw ta hiklam a umange ya takday anghel na Namaratu ta agyan na kebaludan na turin kiden, a hinukatan na ya irwangan na en a pinohet na kid, ammi awena kid hapa narikna na naggwardya kiden. ");
INSERT INTO agt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","A ya uhohug hapa na anghelen tekid a “Magtoli kam hala sangaw ta simbaanen, a idulot muy hala ituldu ya tolay kiden petta amu da hapa ya gagangay na bagu en katolay muy,” kun na anghelen tekid. ");
INSERT INTO agt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","A ta nekabalin na anghelen maguhohug tekid a nagtugut kid na. A ta lalakwat a umange kid ha ta simbaanen, a nangituldu kid ha. A ya mayor na padi kiden hapa ikid na kahulun na kiden a dana pinagmamiting da ya konsihal kiden ikid na ngamin kiden kalalaklakayan na Hudyo kiden, petta imbestigaran da ya turin kiden, te parig da ta mabalud kid para la. A dinob da mantu ya ange mangalap tekid ta agyan na agbaludan. ");
INSERT INTO agt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ammi ta datang na polis kiden ta agyan na agbaludanen a awan kid na haman, a nagtoli mantu ya polis kiden petta ibar da ta nagmamiting kiden. ");
INSERT INTO agt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Datang mi ta agbaludanen, a itta hala ya naggwardya kiden, a nekandado para la ya litup na agbaludan, ammi ta nepangihukat mi a awan haman ya nabalud kiden,” kunda. ");
INSERT INTO agt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","A pake naburungan na ya magtaronen ta simbaanen kontodu padi kiden, te nonotan da am anu ya makkwa sangaw gafu ta nakauhet ya turin kiden. ");
INSERT INTO agt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ammi magananwan la a itta ya takday umange nagdamag tekid. “Itta haman ya nebalud muy kiden ta agyan na simbaanen, a mangituldu kid ha,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","A umange ha mantu ten ya polis kiden kontodu kapitan na simbaanen, a ginafut da ha ya turin kiden. Ammi aweda kid pinalpaluk, te nagtalaw kid hapa ta tolay kiden talo am mangwarad kid ta batu. ");
INSERT INTO agt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ta nepangidatang da tekid ta agyan na nagmamiting kiden, a pinagtayuk da kid ta atubang na pinakadakal da kiden, a inimbestigar na kid na mayor na padi kiden. ");
INSERT INTO agt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Anu awemuy haman dangdangagan ya nebar mi tekamuy? Te nehangat mi haman ta mangituldu kam ta ngagan na tolayin yen, ammi pake pinannu muy hud la ya ili na Herusalem ta netuldu muyen tentu, yaga ipapilit muy para ta itta ya liwat mi gafu ta pasi na en,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","A ya tabbag nig Pedru tentu a “Awena mabalin ta magimmang kami mangituldu, te mapmappya ta Namaratu ya pake kurugan mi ammi ta sakā tolay mi,” kunda. A sangaw dinaggan ni Pedru ya tabbag na: ");
INSERT INTO agt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","“Nonotan muy mina ya iningwa na Namaratu ewan. Gafu ta intu hala ya Dyos na dadagkal tam kiden a tinolay na hala i Hesusen nga pinagappa muy. ");
INSERT INTO agt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","A intu para ya pinātā-nāng na petta makipagtogkok ta hebing na en, te pinagbalin na ta Dafu tam ikid na Mangikerutan tekitam. A ta ayanin a ibar na ta magbabawi kitam petta pakoman na kitam ta liwat tam kiden. ");
INSERT INTO agt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","A ikami na kahulun ku kidin ya mangipasikkal ta ngamin nabidak tekamuy. Ammi bakkan la ta ikami, te nehulun hapa ya pangipasikkal na Kahalwa na Namaratu nga neatad na tekami kontodu ngamin kiden mangurug tentu,” kun ni Pedru tekid. ");
INSERT INTO agt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ammi gafu ta inuhohug na en tekid a pake nagporay kid na, a negakkad da ya mamapasi tentu kontodu kahulun na kiden. ");
INSERT INTO agt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ammi nagtayuk hapa naguhohug ya takday Pariseyu nga nagngagan te Gamaliyel nga pake dayawan na tolay kiden, te malalaki mangituldu ta lintig na Hudyo kiden. A pinohet na bit ya turin kiden, kapye na naguhohug ta kahulun na kiden nga magimbestigar. ");
INSERT INTO agt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","“Mappya, kahkahulun, ta awetam mina gamman ye-yen kid na tolay talo am makaliwat kitam hapa. ");
INSERT INTO agt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","A nonotan muy i mina Teyudasen ta kwa en sina, te pinātā-nāng na ya bari na, a pinadagdag na hapa ya appatagatut na lālāki. Ammi awena haman napagbalin ya gakkad na en, te pinapasi da hala, a sangaw nekutukutet hapa ya dumagdag kiden tentu. ");
INSERT INTO agt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","A sangaw pumatalin hapa tentu i mina Hudasen nga taga Galileya ta araw na pagilista, a addu hapa ya pinadagdag na ta kahulun na. Ammi pinapasi da hapa yen, a nekutukutet hapa ya kahulun na kiden. ");
INSERT INTO agt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","A kumanen hapa sangaw ta isin kid na tolay, te am nonot da hapa la ya pagafun na tarabaku da a melogot kid hala sangaw. Ammi am angarigan ta Namaratu ewan ya mangpaturad tekid a awemuy sangaw mapagkamag ya tarabaku da. A ya tabarang ku mantu tekamuy a pagurayan muy kid la, talo am Namaratu ya nangidob tekid, a mekwenta ta Namaratu ya tapilan muy,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","A gafu ta kumanen kinurug da ya tabarang na en. A ta nepangpatoli da ta turin kiden a nepapaligat da kid la, kapye da ha nebar ta awedan sangaw ipadangag ya ngagan ni Hesus, a sangaw pinatugut da kid. ");
INSERT INTO agt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","A tekiden nagtatugut ta miting na pinakadakal kiden a nataltalakan kid hala gafu ta nekatalak na kid na Namaratu nga magattam ta keamamat da gafu ta ngagan ni Hesus. ");
INSERT INTO agt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","A ta kinanghahaw nedulot da hala ya mangituldu ta simbaanen pase babali na tolay kiden, a nepadangag da la i Hesusen nga Mangikerutan. ");
INSERT INTO agt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A ta isin kid na araw a umaddu la umaddu ya mangurug te Hesus, ammi ya naguhohug kiden ta agsitang na Giregu a nagmamulmug kid ta naguhohug kiden ta agsitang na Hebreyu, te am kada mesaned ya rasyon na balu kiden nga bābāy ta kinanghahaw a nataliban garay ya balu kiden nga Giregu. ");
INSERT INTO agt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","A yen ta pinagkakampat na turin kiden ya ngamin kiden mangurug ta ili na Herusalem, petta pagbabidan da ya problema da nga mangisaned ta rasyon. A ya uhohug da tekid a “Dulay haman am ikami ya makkamu mangisaned ta rasyon na balu kiden, te awemi sangaw matagop ya pangipadangag mi ta uhohug na Namaratu. ");
INSERT INTO agt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","A mappya mantu, kahkahulun, ta ikamuy ya magpili ta pitu na lālāki nga kahulun muy, petta yen kid sangaw ya itun mi nga mangisaned ta rasyon. Ammi mappya ta intu sangaw pilin muy ya napasikkal muyen ta makāutak ikid na napasinapān ta pakapangwa na Kahalwa na Namaratu, ");
INSERT INTO agt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","te ikami a intu la tagopan mi ya makimallak ikid na mangipadangag ta uhohug na Namaratu,” kunda. ");
INSERT INTO agt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","A mayat hapa ya ngamin kiden mangurug ta nebar da. A ya ngagan na pinili da kiden a i Esteban nga masikan mangurug ikid na mapasinapān ta Kahalwa na Namaratu, a i Felipe para, ikid ni Parukor, ikid ni Nikanor, ikid ni Timon, ikid ni Parmenas, ikid ni Nikolas nga takday na Hentil taga Antiyoka nga negitta ta Hudyo. ");
INSERT INTO agt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","A ya pitu kidin yan ya pinagtuttud da ta atubang na turin kiden, petta pakimallak da kid. A nesagpaw da hapa ya kamat da ta ulu da, petta pasinapān na kid na Namaratu. ");
INSERT INTO agt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A ta nekabalin da en a pake nesaned para ya uhohug na Namaratu addet ta pake dimmakal hapa ya kaddu na mangurug kiden ta ili na Herusalem. A nagbabawi hapa ya addu na padi kiden nga Hudyo, te mangurug kid na te Hesus. ");
INSERT INTO agt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","A ya iningwa para ni Esteban hapa a addu ya nehuga na nga nagpaka-latan na tolay kiden gafu ta panguffun na Namaratu tentu, te pake mapasinapān ta pakapangwa na. ");
INSERT INTO agt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ammi intu dulay, te ya Hudyo kiden nga makigimung ta kapilya na kinan da en Naubadan kiden, ikid na kadwan kiden nga taga Sirene, ikid na Alehandra a nakitapil kid hapa tentu. A itta hapa ya kahulun da nga taga Silisya ikid na Asya. A sa ikid ya nakidibati te Esteban, ");
INSERT INTO agt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ammi aweda maabak ya tabbag na en tekid gafu ta pakapangwa na en nga neatad na Kahalwa na Namaratu. ");
INSERT INTO agt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","A gafu ta kumanen a nagita kid ta mamadpadulay tentu, a tinandanan da kid ta melemad, petta isaned da ya pamadpadulay da tentu. A ya inuhohug da nga nesaned da a “Pake nadangag mi ya nepadangag ni Esteban, a padpadulayan na haman ya ginafu tamen Moses pase Namaratu ewan,” kunda. ");
INSERT INTO agt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","A yen ta nagpatun hapa ya tolay kiden ikid na kalalaklakayan na Hudyo kiden, a enda mantu ginafut i Estebanen kapye da nedarum ta atubang na pinakadakal da kiden. ");
INSERT INTO agt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ammi dana neparan da ya laddud kid na tistigu, petta padpadulayan da para i Estebanen. Te ya laddud da en a “Kanayun idadula na haman ya lintig na Namaratu kontodu simbaan na in ta isin Herusalem. ");
INSERT INTO agt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Te ya kinan na en Hesus nga taga Nasaret a intu kan sangaw ya mangikutkutet ta simbaanin yan, yaga talin na kan sangaw ya gagangay tam kiden nga nebilin ni Moses tekitam,” kun na laddud da. ");
INSERT INTO agt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","A ya pinakadakal kiden nga magimbestigar tentu a nilaladdangan da ya mukat ni Esteban, te pake makillat ta kuman na mukat na anghel. ");
INSERT INTO agt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","A ya pohut na mayor na padi kiden tentu a “Kakurugan hud ya nabida da en teko ta ayanen?” kunna. ");
INSERT INTO agt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A ya tabbag hapa ni Esteban a intu yan: “Kahkahulun ku ikid na am-amang ku, a attaman muy haen ya magdangag ta tabbag kin tekamuy, te ta palungu na araw a nakipaita kan ya Namaratu ewan nga seppakapangwa ta ginafu tamen Abraham ta iten Mesopotamya ta awena para la umalit ta iten Haran. ");
INSERT INTO agt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","A ya uhohug na tentu a ‘Pagtugutān muy na ya lugar muyin ikid na kahulun muy kidin, te umalit kanan ta takwan na lugar nga ipaitak sangaw teko,’ kunna kan na Namaratu tentu. ");
INSERT INTO agt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“A gafu ta kumanen a nagtugutan nig Abraham ikid nig dama na en ya lugar na kagitta da kiden taga Kaldeya, a pa nagyan kid bit ten Haran. Ammi ta pasi na dama na en a pinagdulot na Namaratu ig mina Abrahamen ta lugarin yan nga pagyanan tam ta ayanin. ");
INSERT INTO agt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ammi awan para la ten ta neatad na Namaratu tentu ta lutak na maski ta assang la, ammi nekari na hala ta intu sangaw ya makākwa ta lutakin yan kontodu anak na kiden ikid na ngamin simsima na kiden, ammi awan para la ten ta anak na. ");
INSERT INTO agt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“A sangaw ta paguhohug ha na Namaratu tentu a nebar na ta ‘Pake umaddun sangaw ya simsimam kiden, ammi magyan kid sangaw ta takwan na lugar nga pake adayu ta isin, a pagzigātan na kid sangaw na makālutak kiden ten, te persan da kid sangaw nga magtagabu tekid abat ta appatagatut na darun. ");
INSERT INTO agt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ammi am nagpasan ya appatagatut na darun a pa-gangan ku hapa ya magpatagabu kiden tekid, a makatugut hala sangaw ya simsimam kiden ta iten, petta dumatang kid hala sangaw ta isin na lugar, petta makidafu kid sangaw teyak ta isin,’ kunna kan na Namaratu tentu. ");
INSERT INTO agt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“A sangaw gafu ta pakitahatu na Namaratu te mina Abrahamen, a nebar na ta mabanggit mina kontodu ngamin kiden anak na ikid na simsima na nga lālāki, te yen kan sangaw ya pagnonotān da ta tulag na en tekid. A ta nepaganak mantu nig Abraham te Isak a binanggit na mantu ta mekawalu en araw na, a kumanen hapa ya iningwa ni Isak ta anak na en Hakob, a kumanen hapa ya iningwa ni Hakob ta mafulu duwa kiden anak na, te ikid ya napopolu kiden dadagkal tam. ");
INSERT INTO agt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ammi tekiden dimmadagkal a nekatupag da ya wagi da en Hose gafu ta passil da tentu, a yen ta ginafut da, a nelaku da ta kadwan kiden tolay, petta alapan da ta iten Egipto. Ammi nehulun hala ya Namaratu tentu, ");
INSERT INTO agt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","a nekerutan na hapa ta ngamin nagzigatan na, a inatadan na hapa ta malalaki na nonot petta amu na ya dumatang. A ta pakkamu na Ari na Egiptano kiden ta pakapangwa ni Hose en, a pinātā-nāng na hapa, te pinagbalin na ta gubernador ta ngamin lugar na Egipto, yaga nepataron na tentu ya ngamin kiden kwa na. ");
INSERT INTO agt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“A sangaw itta ya dakalen bisin ta ngamin na lugar na Egipto pase nagyanan na gingginafu tam kiden ta iten Kanaan, a pake nepallat ya zigat na tolay kiden, gafu ta awan ta maapagan da ta kanan da. ");
INSERT INTO agt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ammi ta nepakadamag ni mina Hakob ta itta ya nauknud da nga kanan ta lugar na Egipto, a dinob na mantu ten ya anak na kiden, petta gumātāng kid ta kanan da, a yen ya gafu na neange da ten. ");
INSERT INTO agt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A sangaw ta kapidwa na neange da a naggingginafu i Hose tekid, a yen la ya pakkamu da ta intu hala ya wagi da en nga nelaku da ta idi, ikid na pakkamu na ari en ta kahulun na kiden ni Hose. ");
INSERT INTO agt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","A sangaw nepaalap ni Hose ya dama na en ikid na ngamin kiden kahulun na, a dumatang kid hapa ten, a pitufulu lima kid ngamin. ");
INSERT INTO agt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","A sangaw ta kala-laay ni Hakoben a nasi hapa ta lugar na Egipto, a kumanen hapa ta anak na kiden nga gingginafu tam ta kala-laay da. ");
INSERT INTO agt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ammi neange da ya bari da ta dana agyan da en ta lugar na Kanaan, a netanam da kid ta lugar na Sikam ta kweba en nga ginatang ni mina Abrahamen ta anak ni Hamor ta idi. ");
INSERT INTO agt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“A ta kabalinan na kumanen a imaddu la imaddu ya gingginafu tam kiden ta iten Egipto abat ta magge nagpasan ya appatagatut na darun nga dana nebar na Namaratu te mina Abrahamen. ");
INSERT INTO agt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ammi intu dulay te pumatalin ya takwan na ari nga awan makkamu te Hose en, ");
INSERT INTO agt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","a inuyoyungan na ya gingginafu tam kiden, petta pake mazigatan kid, te pinersa na kid nga mangiwarad ta asitay da kiden, petta awan mina ta matolay ta anak da. ");
INSERT INTO agt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“A ye-yen hapa ya kaarawan na nekeanak ni Moses, a pake ispot na asitay. A mappya hapa te netagu na dadagkal na kiden ta umag na bali da abat ta tallu na hulan. ");
INSERT INTO agt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ammi ta nepangitagu da tentu ta pingit na karayanen a neitan na anak na ari en nga babbay, a inalap na ta bali na, a pinadakal na hapa, te nekwenta na ta anak na. ");
INSERT INTO agt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","A gafu ta kumanen a netuldu da i Moses ta ngamin kiden amu na Egiptano kiden, a nagbalin ta pake malalaki na tolay ta ngamin uhohugan na ikid na tarabaku na. ");
INSERT INTO agt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“A sangaw ta mekappatafulu darun na, a nanonot na ya ange ta kagitta na kiden nga Istralita, te ikerutan na kid mina gafu ta mazigatan kid. ");
INSERT INTO agt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A nesimmun na ya takday tekid, ammi talamanan na Egiptano, a yen ta pinapasi ni Moses ya Egiptano en, petta mekerutan ya kagitta na en nga Istralita, ");
INSERT INTO agt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","te pahig na ta amu na kagitta na kiden ta intu ya mangikerutan tekid nga dinob na Namaratu ewan. Ammi intu dulay, te aweda haman amu, ");
INSERT INTO agt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","a sangaw ta lalakwat a umange ha i Moses nakipaita ta kagitta na kiden, a neddatangan na ya duwa tekid nga nagtapil, a ginamman na kid. ‘Anu haman ya kukwan muy O, kunna hud sina ya tarabaku na magkakahulun,’ kunna kan tekid. ");
INSERT INTO agt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ammi ya namepegafu en nakitapil ta takdayen a netu-bang na hapa i Moses, a ‘Iko hud ya makkamu tekami, ");
INSERT INTO agt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","o papasin nak de ta kuman na nepagpapasim ta Egiptano en ta karabi?’ kunna hapa kan te Moses. ");
INSERT INTO agt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","A gafu ta uhohug na en a nagburung na i Mosesen, te ittan mantu ya nakaita tentu, a yen ta nagtammang na ta pake adayu. A nagyan ta lugar na Midyan, a yen hapa ya nangatawan na, a naganak kid ta duwa na lalaki. ");
INSERT INTO agt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“A sangaw ta nepagpasa ha na appatafulu na darun ta iten Midyan a itta i Mosesen ta kalafukanen ta bikat na Bagetayen Sinay, a nakipaita kan ya anghel tentu ta agyan na kalakayu en nga umagātang. ");
INSERT INTO agt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","A ta nepakaita na kan ta kalakayu en a nagpaka-lat kan hapa, te awena haman maapang na kayu en. A pake imabikan mantu, petta pake itan na ta mappya, a nadangag na kan ya ngahal na Namaratu nga maguhohug tentu. ");
INSERT INTO agt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Moses, iyak ya Dyos na gingginafum kiden mina Abraham ikid ni mina Isak, ikid ni mina Hakob,’ kunna kan tentu, ammi nagpapilpig na i Moses ta higal na, a awenan itan ya afuyen gafu ta talaw na. ");
INSERT INTO agt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","A ya uhohug kan na Namaratu tentu a ‘Moses, azim na ya sapatos mina, te lugar na Namaratu ya lutakin nga nagtayukam. ");
INSERT INTO agt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","A dangagam hapa ya ibar ku teko, te naitak na ya pagzigātān na tolay ku kiden ta iten Egipto, a nadangag kun hapa ya panalasigak da, a yen ta itta yak sin, te ikerutan ku kid. A magparan kan mantu, te doban ta kan tekid,’ kunna kan ha na Namaratu tentu. ");
INSERT INTO agt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“A maski i Moses ya inawe na kagitta na kiden, te ‘Iko hud ya makkamu tekami,’ kunda, a intu hala ya pinatoli na Namaratu tekid, petta ikerutan na kid ta lugar na dafu da. Te yen ya uhohug na anghelen nga nakipaita te Moses ta agyan na kalakayu en nga gumatang. ");
INSERT INTO agt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","A i mina Mosesen mantu ya nangitugut ta gingginafu tam kiden ta lugar na Egiptano kiden gafu ta pakapangwa na en, te addu ya nehuga na ta agyan da en, ikid na Bebayen Darag, a sangaw ha ta kalafukanen nga nagpalelehutan da abat ta appatafulu na darun. ");
INSERT INTO agt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","A intu hapa ya nanglavun tekid, ta ‘Itta sangaw ya patudunan na Namaratu ta takwan na paguhohugan na tekamuy ta kuman na nepagpatudun na teyak, ammi kagitta muy hala ya patudunan na, a intu hala sangaw ya kurugan muy,’ kunna kan tekid. ");
INSERT INTO agt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“A ta nepagaammung na gingginafu tam kiden ta fun na Bagetayen Sinay ta kalafukanen a i mina Moses hapa ya pinakasimuk da ta anghelen, a kumanen hapa ta tolay kiden, te nepadangag na tekid ya uhohug kiden mangtolay, petta ituldu na kid hapa ta dadagkal tam kiden kontodu ikitam nga simsima da. ");
INSERT INTO agt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ammi gafu ta kabayag ni Moses ta utun na bagetayen nga magdangag ta anghelen a nagtalekudan na dadagkal tam kiden, te sinoysoy da, te tagasingatan da la ya magyan ta lugar na Egipto. ");
INSERT INTO agt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","A ya nebar da te Aron nga kaka ni Mosesen a ‘Mamadday ka ta sinang dyos tam, petta ituldu na kitam ta angen tam, te awetam haman amu am anu ya nakkwa te Mosesen,’ kunda tentu. ");
INSERT INTO agt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","A ya dyos nga pinadday da a sinang baka, a yen ya atangan da, a pake nekatalak da ya pinadday da en. ");
INSERT INTO agt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","A gafu ta nagtalekudan da ya Namaratu ewan, a nagtalekudan na kid hapa, te pinaguray na kid nga magdayaw ta magmagannud kontodu bitwan kiden ta langit ewan. A ya uhohug na Namaratu ta nepangihuya na tekid a yen ya nesurat na aglavunen Amos ta kumanin: ‘O, ikamuy nga Istralita, Iyak hud ya nangiatangan muy ta baka muy kiden tekamuyen nagyan ta kalafukanen, ");
INSERT INTO agt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","te intu la nekatalak muy ikid na dinayawan muy ya sinang bali ni Moluk ikid na sinang bitwan ni Repan nga pinadday muy. A awek mantu ituluk ta pagyanan muy ya lutakin yan, te padayun ta kam sangaw ta taakub na Babilonya, petta mapa-gang kam,’ kunna kan na Namaratu tekid. ");
INSERT INTO agt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“A ta kada umalit ya gingginafu tam kiden ta kalafukanen a nehulun da hapa ya tolda en nga nakipaitan na Namaratu tekid, te yen ya nepapadday na Namaratu tekid ta kuman na plano na en nga nepaita na te Moses ta utun na Bagetayen. ");
INSERT INTO agt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","A sangaw tentu en nasi i Moses kontodu kadadagkalan na kiden a inalap na anak da kiden ya tolda na Namaratu, a netulud ni Hoswe ta lugarin yan nga pagyanan tam ta ayanin. A ginubatan da ya lutakin yan, te inuffunan na kid na Namaratu nga mangpatugut ta palungu kiden makākwa. A yen ta nedatang nig Hoswe ya tolda na en ta isin, a nagyan la sin abat ta araw na ginafu tamen Dabid. ");
INSERT INTO agt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","A gafu ta talak na Namaratu te mina Dabiden a pinalubusan na nga magpapadday ta bagu na bali na Namaratu nga ispot nga pake maladda. ");
INSERT INTO agt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ammi ya anak na en Solomun ya mayor na nangpatayuk ta bali na Namaratu ta kabalinan na pasi ni dama na en Dabid. ");
INSERT INTO agt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ammi maski kunna ten, kahkahulun, a awetam mina pahig ta pagyanan na Namaratu ewan ya pinadday na tolay, te dangagan muy ya uhohug na Namaratu nga nesurat na aglavun na en: ");
INSERT INTO agt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ya langitin ya pagtuttudan ku, a ya lutak ya ilubeg na takkik kidin. A had kukummuy mantu mamadday ta bali nga pagyanan ku? A had sin para ya pangpaddayan muy ta pagiddan ku? ");
INSERT INTO agt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Te iyak haman ya namadday ta ngamin langit ikid na lutak ikid na ngamin magyan tekid,’ kunna haman. ");
INSERT INTO agt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ammi ya dulayen tekamuy,” kun ni Esteban tekid “a maningbangngag kam garay ta uhohug na en, te matuyag haman ya ulu muy. A soysoyan muy la ya Kahalwa na Namaratu ta kuman na dadagkal tam kiden. ");
INSERT INTO agt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Itta hud ya maski takday na aglavun na Namaratu nga awena tinapil na dadagkal tam kiden ta idi, te dinugiman da kid ngamin. Yaga pinapasi da para ya kadwan nga dana nangibar ta iange na Anak na Namaratu, otturu intu hala ya pinadadakat muy ta taga Roma kiden petta papasin da. ");
INSERT INTO agt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ikitam haman ya inatadan na Namaratu ta lintig na kiden nga nedagut na anghel kiden ta dadagkal tam kiden, ammi awemuy garay netug ya nesirak da tekitam,” kun ni Esteban tekid, a nagimmang na hapa nagbida tekid. ");
INSERT INTO agt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","A ta pakadangag na Hudyo kiden ta inuhohug ni Estebanen tekid a pake nagpatu ya nonot da, a kuman na hattokan da gafu ta poray da tentu. ");
INSERT INTO agt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ammi gafu ta napasinapān ta Kahalwa na Namaratu a tumangad la ta langit, a naita na kan ya dakar na Namaratu ewan ikid ni Hesusen nga umatayuk ta hebing na. ");
INSERT INTO agt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Yo, itan muy,” kunna, “mahukatan na ya langit ewan, a umatayuk kad ya Tolayen Taga Langit ta hebing na Namaratu ewan,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ammi pake giaggayan ya tolay kiden, a tinappanan da ya bangbang da, petta aweda madangag ya uhohug na en. A sa naggagindan kid nga bumilag nga ange nanggafut tentu, ");
INSERT INTO agt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","a ginerger da ta lawan na ili petta papasin da ta batu. Ya nagladdud kiden tistigu nga nangipapilit ta liwat na a gagangay ta ikid ya mapolu mangwarad tentu, a dana inazi da mantu ya salnuk na barawasi da, petta awena magsalin na pangwarad da, a nepaibbal da ya salnuk da kiden ta takday kahulun da nga nagngagan te Salu, kapye da winarad i Esteban. ");
INSERT INTO agt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","A tekid namegafu nangwarad tentu a nakimallak hapa. “Ay Afu, alapam na ya kahalwak,” kunna, ");
INSERT INTO agt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","kapye na hapa namalentud ikid na nagayag ta masikan. “Ay Afu, awem la nonotan ya liwat da in teyak,” kunna, a nasin. ");
INSERT INTO agt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","A ta kabalinan na kumanen a umange ya kadwan lalaki na Namaratu, a enda inalap ya bari ni Esteban, petta itanam da, a pake tinangtāngitān da. Ammi te Salu a pake natalakan ta pasi na en, a yen hapa ya gafu na pakitapil na ta ngamin kiden mangurug, te maski enna kid sarokan ta bali da kiden, a gergeran na kid iuhet, ngamin lālāki pase bābāy, a enna kid pebalud. A yen hapa ya nepagtatugut na mangurug kiden ta ili na Herusalem fwera ta turin kiden, te pake pagzigātan na kid ni Salu. A naggugungay kid abat ta ngamin paglelehut ta lugar na Hudeya ikid na Samariya. ");
INSERT INTO agt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","A ya iningwa na mangurug kiden nagugungay a nepadangag da hala ya damag ni Hesus ta ngamin kiden lugar nga nagdulotan da. ");
INSERT INTO agt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","A ya takdayen tekid nga nagngagan te Felipe a umange ta takday na ili ta lugar na Samariya, a nepadangag na ya damag ni Hesus nga Mangikerutan tekid. ");
INSERT INTO agt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","A tekiden nakaita ta pakapangwa na Namaratu nga nepehuga na te Felipe a pake pakolangan da ya magdangag ta bida na en, ");
INSERT INTO agt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","te pinatugut na ya addu na anitu ta seanitu kiden, a wawwayway da nagauhet. A pinagmappya na para ya addu na awan makahehit ikid na pilay. ");
INSERT INTO agt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","A pake matalakan ya tolay kiden ta ili in yen. ");
INSERT INTO agt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ammi dana itta hapa ten ya takday lalaki nga nagngagan te Simon, a neparparayag na ya amu na, te malalaki kan magmadyik. A pake nagpaka-lat hapa ya ngamin tolay taga Samariya ta madyik na en. ");
INSERT INTO agt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","A sa mangurug bit ya ngamin pobre pase naba-nang tentu, te “Intu ya pakaitan ta Dyos nga seppakapangwa,” kunda. ");
INSERT INTO agt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A pake pakolangan da ya mangdangag tentu, te addet ta nabayag na araw a kanayun mangipaita ta pagpaka-latan. ");
INSERT INTO agt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ammi ta ange ni Felipe nga mangipadangag ta damag na pangikerutan na Namaratu ikid na ngagan ni Hesus Kristu, a addu hapa ya nagbabawi ta lālāki pase bābāy, a nazigut kid hapa gafu ta pangurug da te Hesus. ");
INSERT INTO agt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","A nangurug kan hapa i Simon, a tentun nabalin nagzigut a nehulun hapa te Felipe, a pake nagpaka-lat hapa ta ngamin kiden nehuga ni Felipe ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","A sangaw ta pakadangag na turin kiden nga nasirak ta ili na Herusalem ta mangurug na hapa ya taga Samariya kiden ta uhohug na Namaratu a dinob da hapa ig Pedru ikid ni Hwan, petta enda uffunan i Felipe. ");
INSERT INTO agt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","A ta datang da ten a nepakimallak da ya bagu kiden mangurug, petta mapasinapān kid hapa ta Kahalwa na Namaratu, ");
INSERT INTO agt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","te maski nabalin kid na nagzigut ta ngagan ni Afu Hesus a aweda para la mapasinapān ta Kahalwa na Namaratu. ");
INSERT INTO agt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","A ta nepangisagpaw hapa nig Pedru ta kamat da tekid a mapasinapān kid hapa. ");
INSERT INTO agt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","A ta pakaita ni Simon ta mapasinapān ya tolay kiden ta Kahalwa na Namaratu gafu ta pakapangwa na turin kiden, a passilan na hapa ya kuman na pakapangwa da, a enna hapa igawat ya pirak ta pangibar na en tekid. ");
INSERT INTO agt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Atadan dak haen ta kuman na pakapangwa muy, petta mapasinapān hapa ya kesagpawan na kamat ku ta Kahalwa na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ammi pake nehuya ni Pedru: “Pade la maapang ya pirak mina nga mehulun teko ta pangtaguhali na Namaratu, te pahig mu ta mapagam ya iatad na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Awan mantu ta kesipatam ta uhohug na Namaratu, te awena haman megitta na nonot mu tentu. ");
INSERT INTO agt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Magbabawi ka mantu ta liwat mu, a makimallak ka ta Namaratu ewan talo am pakoman na ka ta negakkad na nonot mu, ");
INSERT INTO agt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","te maitak ta mefulot ya passil na nonot mu, a megalut ka para la ta pagliwatam,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","“Ay Apo, pakimallak dak haen ta Namaratu ewan, petta awena sangaw magdulot na pangigaged men teyak,” kunna hapa ni Simon. ");
INSERT INTO agt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","A ta nekabalin da ten a pa nagyan bit ig Pedru ta iten, te naghahulun kid ni Hwan ikid ni Felipe nga mangipadangag para ta damag ni Hesus, ikid na mangituldu ta uhohug na Namaratu. A sangaw tekiden nagtoli ta ili na Herusalem a sage nagsibal kid ta babali na Samariyano kiden ta inange da en, petta ipadangag da ha ya damag ni Hesus tekid. ");
INSERT INTO agt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","A sangaw itta ya anghel na Namaratu nga ange maguhohug te Felipe; “Umakkat kan Felipe, te e kan ta kalsada en nga magpaabagatan ta ili na Gaza nga mangrugi ta ili na Herusalem,” kunna kan tentu. ");
INSERT INTO agt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","A kuman na awena maaange na kalsada in yen, ammi umakkat hala i Felipe nga umange ta agyan na kalsada en. A ta datang na a itta hala ya takday kalesa ta unnan na en nga dumayum ta abagatan, a itta ya lalaki nagtakay. Intu kan ya magtaron ta ngamin kaba-nang na babbayen ari ta lugar na Etiyopya ta pake abagatan para. ");
INSERT INTO agt_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ammi dana immangen ta ili na Herusalem nga nakigimung ta agyan na simbaan na Hudyo kiden, a magtolin hapa ta agyan na en, ammi nagatākay la nagbasa ta lebru ni mina Isayasen nga takday aglavun na Namaratu. ");
INSERT INTO agt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","A ta nepakaita ni Felipe ta kalesa en a naguhohug hapa ya Kahalwa na Namaratu tentu; “Umabikan kan, Felipe, ta kalesa ewan, a makitunud ka la tentu,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","33","A nagbilag mantu i Felipe addet ta pake timunud ta kalesa en, a dadangagan na la ya lalaki en magbasa ta lebru ni mina Isayas. A ya uhohug kiden nga basan na a “Timuluk la tekid ta kuman na kalneru en nga alapan da ta agyan na pangpartin da en tentu. A parigan na para ya urbun na kalneru nga awan magsitang am usipan da ya dutdut na kiden. A pake amāmatan da para, te awan haman ta pake mangibar ta katunung na. A ta ikāttolay na kiden awan haman ta pangkenga da tentu, te ituluk da la ta masi,” kun na pagbasa na en. A ya uhohug ni Felipe ta lalaki en a “Amum de ya ikayat na uhohugan na binasam?” kunna. “Awek haman amu am awan ta mangituldu teyak,” kun na hapa na lalaki en, otturu pinagtakay na hapa i Felipe, petta ituldu na ya binasa na en. ");
INSERT INTO agt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","“A inya hud na tolay ya bidan na nagsuraten, ya bari na en hapa la, ono takwan na tolay?” kunna ha te Felipe. ");
INSERT INTO agt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","A pinegafwanan ni Felipe ya suraten binasa na, petta pake ipadangag na tentu. “Ya nagsuraten ta binasamina a linavun na ya pasi ni Hesusen nga Anak na Namaratu ewan,” kunna, otturu nepadangag na hapa ya katolay na en. ");
INSERT INTO agt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","A tekiden para la nakatugtugut ta kalsada en a nadatang da ya wer, a “Itam awa itta kad danum sin, awena de dulay am zigutan nak?” kun na lalaki en tentu. ");
INSERT INTO agt_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","“Awena dulay am pake itug mu ya pangurug mu,” kun ni Felipe. “A mangurugak ay ta Anak hala na Namaratu i Hesusen nga Mangikerutan,” kunna hapa. ");
INSERT INTO agt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","A sangaw pinagimmang na ya kalesa na en, a azo dumagut kid ta danumen, kapye na zinigut ni Felipe ya lalaki en. ");
INSERT INTO agt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","A tekiden gimon a ka-ma la limmitap i Felipe, te pinalitap na Kahalwa na Namaratu, a awenan naita na lalaki en. A nagtakay la ya lalaki en ta kalesa na en, a nagayayat la dumayum ta agyan na en. ");
INSERT INTO agt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ammi te Felipe a nakipaita ha ta adayu ta ili na Azotu. A dumayum na hapa ta ili na Sesariya, ammi nedulot na la ya mangipadangag ta damag ni Hesus ta kadwan kiden ili ta inang-ange na. ");
INSERT INTO agt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A ta nepaggugungay na mangurug kiden ta pasi ni Esteban a pake pagzigātan na kid para la ni Salu, te ikayat na kid papasin. ");
INSERT INTO agt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","A yen ta umange nangpasurat ta mayor na padi kiden, te petta itta ya ipaita na ta makkamu kiden ta kapilya na Hudyo kiden ta ili na Damasku. Te am itta ya makigimung tekid nga mangurug te Hesus a gafutan na kid, kompormi am lalaki ono babbay, a idatang na kid sangaw ta agbaludan ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","A ta nepakaalap na ta surat na padi en a nagtugut hapa nga dumayum ta ili na Damasku kontodu kahulun na kiden. Ammi tekid umab-abikan ta ili a nepagka-ma ni Salu ya pake masikan na killat ta bikat na en nga nagafu ta langit, a nahunnak ta lutaken. ");
INSERT INTO agt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","A sangaw nadangag na ya nangbar tentu: “Salu, Salu, anu haman ta igakkad nak?” kunna. ");
INSERT INTO agt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“A inya ka, Afu?” kunna hapa na tabbag na. “I Hesusak, a iyak ya igakkad mu. ");
INSERT INTO agt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ammi magtayuk kan, a magdulot ka hala ta ili, a mebar sangaw teko ya kwam,” kunna tentu. ");
INSERT INTO agt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Dana nagimmang hapa ya kahulun na kiden, a aweda nakasitang gafu ta talaw da ta naguhohugen, te awan haman ta naita da ta tolay. ");
INSERT INTO agt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","A nagtayuk mantu i Salu, ammi tentu en limmaddang a awenan haman makaita. A ginemidan na mantu na takday kahulun na, a nee da ta ili na Damasku. ");
INSERT INTO agt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A nagyan la ten nagdaram abat ta talluhaw, a awena kad nangnangan ikid na uminum. ");
INSERT INTO agt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A ta ili na Damasku a itta hapa ya lalaki en mangurug nga nagngagan te Ananayas, a nagmatakar kan i Afu Hesus tentu. “Ananayas,” kunna kan tentu. “Anu yen, Afu?” kunna hapa kan. ");
INSERT INTO agt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“Umakkat kan, te e ka ta kinan da en kalsada nga matunung, a apagam ya bali ni Hudas, a damagam sangaw ya nagngagan te Salu nga taga Tarsu, te itta ten makimalmallak, ");
INSERT INTO agt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","a naita nan ya alinum nga imunnan ange mangisagpaw ta kamat mu ta ulu na, petta makaita ha,” kunna kan ni Hesus te Ananayas. ");
INSERT INTO agt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","“Ahu, pake dulay ye-yana na tolay, Afu, te ya nadamag ku tentu a pake dulay kan ya iningwa na ta tolay mu kiden ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A yen kan ta umange hapa sin, te dinob na kan na mayor na padi kiden, petta gafutan na kan ya ngamin kiden makimallak ta ngagam,” kunna hapa na tabbag ni Ananayas. ");
INSERT INTO agt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","“Maski kumanen, a e ka hala, te intu hala ya pinilik ta magserbi teyak, petta ipadangag na sangaw ya ngagan ku ta Hudyo kiden ikid na Hentil kiden pase ari da kiden. ");
INSERT INTO agt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","A dana ipakamuk hapa tentu ya ngamin attaman na ta pangipadangag na ta ngagan ku,” kunna kan ni Hesus tentu. ");
INSERT INTO agt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","A gafu ta kumanen imangen i Ananayas, a tentu en nakasarok ta bali en nga nagyanan ni Salu, a enna nesagpaw ya kamat na ta ulu na en. A ya nebar na tentu a “Kabagis Salu, yen ta itta yak sin, te i Afu Hesusen nga ange nakipaita teko ta angemen ta isin a dinob nak hapa teko, petta makaita kan ha, anna mapasinapān ka ta Kahalwa na Namaratu,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","A ka-ma la narikna ni Salu ta itta ya nahunnak ta kuman na siksik na ikan ta mata na kiden, a nakaitan ha. A sangaw nagtayuk, te enna zinigut ni Ananayas. ");
INSERT INTO agt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","A yen hapa ya nepangan na, a nagtolin ya pagsikan na bari na. A ta nekabalin na en a nedagga bit i Salu ta mangurug kiden ta ili na Damasku. ");
INSERT INTO agt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ammi umange makigimung ta kapilya na Hudyo kiden, te pake ipasikkal na tekid ta Anak na Namaratu i Hesusen. ");
INSERT INTO agt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","A ta pakadangag da ta uhohug na en tekid a napopoyung kid na ta pagpaka-lat da tentu, “Bakkan hud ta intu ya nangtapil ta makimallak kiden te Hesus ta iten Herusalem? A awena hud umange ta isin, petta gafutan na ya kahulun da kiden ta isin, petta iange na kid ta atubang na mayor na padi kiden?” kunda. ");
INSERT INTO agt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ammi pake pinasikan na para ya pangipadangag na ta ngagan ni Hesus ta Hudyo kiden ta ili na Damasku, a awan hapa ta amu da ta itabbag da ta inuhohug na, te pake nepasikkal na i Hesus ta intu hala ya Mangikerutan nga dinob na Namaratu ewan. ");
INSERT INTO agt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","A ta nepagpasa na pigahaw a nagbabidan na Hudyo kiden ya pangpapasi da te Salu. ");
INSERT INTO agt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","A sangaw nesaad da ya kadwan kiden nga mangilakap tentu ta irwangan kiden na ili en ta araw pase hiklam, petta papasin da am lumattog. Ammi mappya te nadamag na ya igakkad da tentu, ");
INSERT INTO agt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","a enna mantu inalap na ituldu na kiden ta hiklam, a netun da ta umag na kuribut, kapye da neuhiyay ta lawan na batu en alad, a nakatammang na. ");
INSERT INTO agt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","A tentu en dumatang ta ili na Herusalem a ikayat na ha makidagga ta mangurug kiden, ammi netalaw da, te aweda nekatalak ta negitta tekid nga mangurug te Hesus. ");
INSERT INTO agt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ammi ya takday tekid nga nagngagan te Barnabas a nekallak na hala i Salu, a enna netulud ta agyan na turin kiden, a binida na tekid ya pakipaita ni Hesus te Salu ikid na paguhohug na tentu ta kalsada en. A binida na para tekid ya turad ni Salu nga mangipadangag ta ngagan ni Hesus ta ili na Damasku. ");
INSERT INTO agt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","A gafu ta kumanen a pake pinagdulot da, a nakipagyan tekid. A maturad la mangipadangag ta ngagan ni Afu Hesus ta ngamin ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A nakiuhohug otturu nakitabbag hapa ta Hudyo kiden nga maguhohug ta agsitang na Giregu, ammi igakkad da hapa papasin. ");
INSERT INTO agt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","A ta nepakadangag na kabagis kiden ta igakkad na Hudyo kiden, a hinulun da abat ta ili na Sesariya, a sangaw pinalugan da ta dakal na selayag, petta magdulot ta ili na Tarsu nga dana agyan na. ");
INSERT INTO agt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","A gafu ta kumanen a nagmappyan ya kasasaad na mangurug kiden ta ngamin lugar na Hudeya ikid na Galileya ikid na Samariya, te awan na ta burungan da. A nagsikan la nagsikan ya pangurug da, yaga pake imaddu kid para ta panguffun na Kahalwa na Namaratu tekid, te kanayun lillikan da ya ikatupag ni Afu Hesus. ");
INSERT INTO agt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","A ya tarabaku ni Pedru hapa a umange magpasyar ta mangurug kiden ta tagtakday lugar. A tentu en dumatang ta mangurug kiden ta ili na Lida ");
INSERT INTO agt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","a nasimmun na ya takday lalaki nga nagngagan te Enas, ammi imaidda la ta dapan na en, te awena makahehit abat ta walu darun. ");
INSERT INTO agt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","A gafu ta kumanen a binaran ni Pedru. “Enas, pagmappyan na ka ni Hesus Kristu, magtayuk kan mantu, a appiyam ya iddamina,” kunna tentu, a insigida nagtayuk. ");
INSERT INTO agt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","A naita da hapa na ngamin kiden limugar ta ili na Lida ikid na Syaron, a yen na hapa ya gafu na pangurug da te Afu Hesus. ");
INSERT INTO agt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","A ta ketta para la ni Pedru ta ili na Lida a itta ya takday mangurug nga babbay ta ili na Hoppe, a Tabita ya ngagan na, ammi Dorkas ya pangingaganan na Giregu kiden tentu. A mappya hapa na babbay te kanayun ikallak na ya mazigatan. ");
INSERT INTO agt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ammi intu dulay te nagtakit, a sangaw nasi. A ta nekabalin da nangzigut ta bari na en a negon da bit ta nagingutun na silid, te ifunan da bit la addet ta enda pangitanam. ");
INSERT INTO agt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","A gafu ta abikan hapa ya ili na Lida, a nadamag da ta itta para ten i Pedru, a nangidob kid mantu ta duwa na lalaki nga ange mangalap tentu. A ta ange da en te Pedru a nebar da tentu; “Mangikallak ka kan, te magalistu ka umange ta lugar mi,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","A nagganwat na mantu, a nehulun hapa tekid. A ta datang da ta bali en a pinagon da i Pedru ta agyan na nasi en. Ammi dana itta hapa ya balu kiden, te enda hapa itan ya nasi en, a sa nagtatangit kid hapa. A nepaita da hapa te Pedru ya barawasi da kiden nga dinaget ni Dorkas ta katolay na en. ");
INSERT INTO agt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ammi pinohet na kid ngamin, kapye na namalentud nakimallak. A sangaw imatubang ta bari na nasi en, a “Tabita, imivwat kan,” kunna. A yen hapa ya nepagladdang na. A ta pakaita na te Pedru, a imivwat na hapa. ");
INSERT INTO agt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","A inibbalan ni Pedru ya kamat na en, kapye na pinagtayuk. A sangaw inayagan ni Pedru ya mangurug kiden kontodu balu kiden, a nepaita na i Tabita en tekid, te natolay. ");
INSERT INTO agt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","A alistu nesaned ya damag na katolay na en ta ngamin ili na Hoppe, a addu hapa ya mangurug te Afu Hesus. ");
INSERT INTO agt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","A nagyan bit hapa ten i Pedru abat ta addu na araw, ammi intu nagdulotan na ya bali ni Simonen nga agpamaga ta la-las. ");
INSERT INTO agt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","A ta ili na Sesariya hapa a itta ya takday suddalu nga nagngagan te Kornelyu nga taga ili na Roma, a intu hapa ya kapitan da ta kampo na suddalu kiden taga Itali. ");
INSERT INTO agt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","A maski bakkan ta Hudyo a mamat hala ta Dafu da ewan Namaratu, a kumanen hapa ta kahulun na kiden. A kanayun makimallak hapa i Kornelyu ta Namaratu, ikid na mangikallak ta Hudyo kiden nga mazigatan. ");
INSERT INTO agt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","A sangaw ta takday araw ta alas tres ta furab a makimallak i Kornelyu ta bali na en, a ka-ma la nagmatakar kan ya anghel na Namaratu tentu, a binaran na. “Kornelyu,” kunna kan tentu. ");
INSERT INTO agt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","A nakagayanggang i Kornelyu ta talaw na en tentu, a “Anu yen, Afu?” kunna. “Pake nonotan na ka na Namaratu ewan gafu ta pakimallak mu tentu, ikid na pangikallak mu ta ikāttolay mu kiden. ");
INSERT INTO agt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","6","A mangidob kan mantu ta ange ta ili na Hoppe ta bali ni Simonen nga agpamaga ta la-las ta pingit na bebay, te paayagam ya nagngagan te Pedru, te itta sangaw ya ibar na teko,” kunna kan na anghel tentu. ");
INSERT INTO agt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","A ta nepagtugut na anghelen a inayagan na mantu ya duwa na tagabu na ikid na daddoban na en suddalu nga mamat hapa ta Namaratu, ");
INSERT INTO agt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","a binida na tekid ya nagmatakaren tentu, kapye na kid dinob ta ili na Hoppe. ");
INSERT INTO agt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","A ta takday araw tekid para la medyo adayu ta ili en, a itta la i Pedru ta ili na Hoppe, a gimon hapa ta agpalanawan na bali ta tangngan na araw, petta tatakday la makimallak. ");
INSERT INTO agt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A sangaw nabisinan, a ikayat na mangan. Ammi tekid para la mangiparan ta kanan na a netuggad na nagmatakaren tarapal, ");
INSERT INTO agt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","te kuman na sehahukat kan ya langitewan, a nagaak-akban kan ya kuman na dakal na tarapal, a nagalutan ya kadadugu na en. ");
INSERT INTO agt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A napannu kan ya tarapalen ta magmagannud na ayam kontodu ulag ikid na mamanuk nga mehangat ta Hudyo kiden. ");
INSERT INTO agt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","A itta hapa ya nangbar tentu. “Pedru, magtayuk kan, te magparti ka ta igupam,” kunna kan. ");
INSERT INTO agt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","“Atsi, awek O, Afu, te maski abat ta kaabbing ku awek para nangigup ta kuman na mehangat kidina,” kun ni Pedru. ");
INSERT INTO agt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","“Awem ibar ta mehangat ya ituluk na Namaratu,” kunna kan ha na ngahalen. ");
INSERT INTO agt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","A namillu kan ya nepangibar na ta kumanen, a sangaw timullu ha ya tarapalen ta langit. ");
INSERT INTO agt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","A pake napopoyung i Pedru ta nagmatakaren tentu, te awena para la amu am anu ya ikayat na uhohugan. Ammi tentu en para la mangnonot a ittan ya lālāki kiden nga dinob ni Kornelyu, a nagtayuk kid na ta irwangan na bali en, ");
INSERT INTO agt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","a nangbar kid na. “O, itta de i Pedru en sin?” kunda. ");
INSERT INTO agt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","A ta ketta para la ni Pedru ta agpalanawan na bali nga mangnonot a nepagka-ma na ya uhohug na Kahalwa na Namaratu tentu. “Dumagut kan, Pedru, te itta ya tallu na tolay nga magapag teko, ");
INSERT INTO agt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","a awem magtalaw dumagdag tekid, te iyak ya nangidob tekid,” kunna kan. ");
INSERT INTO agt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Dimmagut mantu i Pedru, a “Iyak ya apagan muy. Anu mantu ya ange muy sin?” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“A yen ta itta kami, te ya dafu mi en Kornelyu a kapitan na suddalu, ammi mappya hapa na tolay, te mamat ta Namaratu, a dayawan da hapa na kagittam kiden Hudyo. A itta kan ya anghel na Namaratu nga nagmatakar tentu, a nebar na kan ta paalap na ka kan ta bali na, petta dangagan na kan ya ibar mu tentu,” kunda. ");
INSERT INTO agt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","A pinagdulot na kid mantu ni Pedru ta umag na bali, petta magammak kid. A sangaw ta kalalakwatan na a nagganwat i Pedru nga dimmagdag tekid, a nehulun na hapa ya kadwan kiden mangurug taga ili na Hoppe. ");
INSERT INTO agt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","A ta mekatallu en na araw ta datang nig Pedru ta ili na Sesariya a dana ginawi ni Kornelyu ya kahulun na kiden ikid na kofun na kiden nga mappya tentu, te ikatalak na ta yen ya araw na datang nig Pedru. ");
INSERT INTO agt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","A ta isarok ni Pedru a enna dinafung ni Kornelyu, a namalentud ta atubang na en ta kuman na mangdayaw tentu. ");
INSERT INTO agt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ammi pinatayuk na hala ni Pedru. “Awem mina mamalentud ta atubang ku, te kagitta nak haman tolay,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","A nagdulot kid na nagbida addet ta agyan na tolay kiden naammung, pake addu kid. ");
INSERT INTO agt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","A sangaw naguhohug hapa i Pedru tekid. “Dana amu muy ya gagangay mi nga Hudyo ta mehangat kami nga ange magpasyar ta bakkan ta kagitta mi, ammi itta ya nepaita na Namaratu ewan teyak, petta amuk ta awek na mina idaduma ya tolay. ");
INSERT INTO agt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","A yen ta awek nagtalaw umange ta isin tekiden nangalap teyak. A dangagan kun mantu am anu ya nangayagan muy teyak,” kunna tekid. ");
INSERT INTO agt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","A ya tabbag hapa ni Kornelyu a “Mekappat na araw ta ayanin abat ta nepakimallak ken ta alas tres ta furab a pagka-mak la nga itta ya nagtayuk nga lalaki ta atubang ku, a makatulang hapa ya barawasi na, a binaran nak. ");
INSERT INTO agt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Kornelyu,’ kunna hapa teyak, ‘Pake nonotan na ka na Namaratu ewan gafu ta pakimallak mu tentu, ikid na pangikallak mu ta ikāttolay mu kiden,’ kunna. ");
INSERT INTO agt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","A ya uhohug na en para teyak a ‘Mangidob kan mantu ta ange ta ili na Hoppe ta bali ni Simonen nga agpamaga ta la-las ta pingit na bebay, a paayagam ya magngaganen ta Pedru, te itta sangaw ya ibar na teko,’ kunna ha na anghelen teyak. ");
INSERT INTO agt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","A yen ta pinaalap ta ka ta alistu, a mappya te umange ka hapa. A dangagan mi mantu am anu ya peuhohug na Namaratu teko, te intu ya kuman na nagpakampat tekami,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","A ya bida ni Pedru tekid a “Kakurugan mantu ya nepakamu na Namaratu teyak ta awan ta idaduma na ta tolay ta ngamin paglelehut, ");
INSERT INTO agt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","am awa pagdulotan na ya ngamin mamat tentu ikid na mangwa ta mappya, te maski am anu ya katolay da. ");
INSERT INTO agt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","A ya uhohug na en nga nepepadangag na ta Istralita kiden a pakoman na kid na ta liwat da gafu ta pasi ni Hesus Kristu, ammi bakkan la ta liwat da, am awa liwat na ngamin, te intu hala ya pinagbalin na Namaratu ta dafu na ngamin tolay. ");
INSERT INTO agt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ammi dana amu muy de ya ngamin dumatang ta lugar na Hudyo kiden, te intu bit napolu i mina Hwanen nga nangipadangag ta pangzigut na ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","A sangaw dumagdag hapa i Hesusen nga taga ili na Nasaret ta iten Galileya, a pinasinapan na hapa na Namaratu ta pakapangwa na Kahalwa na en. A sinaned na hapa ya ngamin kiden lugar na Hudyo kiden, a mappya la ya ngamin tarabaku na ten, te pinagmappya na ya ngamin tolay nga pinagzigat ni Satanas, gafu ta itta ya Namaratu tentu. ");
INSERT INTO agt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“A ikami hapa ya mangipasikkal ta ngamin tarabaku na, te nehulhulun kami tentu abat ta ili na Herusalem addet ta ngamin kiden lugar na Hudyo kiden. Ammi maski kunna ten a pinagappa da hala ta kayu, a nasi. ");
INSERT INTO agt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ammi ta mekatallu en ahaw a tinolay na hala na Namaratu ewan, a netuluk na hapa ta makipaita tekami, ");
INSERT INTO agt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","te bakkan ta ngamin tolay ya nakipaitan na am awa ikami la nga pinili na Namaratu, petta itta ya mangipasikkal ta katolay na. A kakurugan ta natolay hala, te nakikkanan haman tekami ta pagtolay na en. ");
INSERT INTO agt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","A sangaw dinob na kami hapa nga ange mangipadangag ta tolay kiden, petta ipasikkal mi ta intu hala ya pinatudunan na Namaratu nga magimbestigar sangaw ta ngamin kiden natolay ikid na ngamin kiden nagpasi. ");
INSERT INTO agt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","A intu hala ya dana binida na aglavun kiden na Namaratu ta palungu na araw, te ya ngamin kiden mangurug tentu a mapakoma kan ya liwat da kiden gafu ta intu ya nangikaru,” kun ni Pedru tekid. ");
INSERT INTO agt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","46","Ammi ta paguhohug para la ni Pedru tekid a ka-ma kid la maguhohug ta magdaduma na agsitang ta pangdayaw da ta Namaratu ewan, te sa mapasinapān kid na ta Kahalwa na Namaratu. A ya mangurug kiden nga Hudyo nga nehulun te Pedru a pake nagpaka-lat kid hapa ta pakadangag da ta paguhohug na magsitang kiden, a “Anu maatadan hapa ya Hentil kiden ta Kahalwa na Namaratu?” kunda. ");
INSERT INTO agt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","A ya uhohug hapa ni Pedru ta kahulun na kiden a “Itta hud ya makehangat ta pagzigut na inin kid, bakawa naatadan kid haman ta Kahalwa na Namaratu ta kuman na ikitamen ta idi,” kunna, ");
INSERT INTO agt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","otturu nebar na hapa teg Kornelyu. “Mappya ta mazigut kanan ta danum, petta mepasikkal ya pakesipat muy ta ngagan ni Hesus Kristu,” kunna. A ya uhohug da hapa te Pedru tekid na nabalin nagzigut a “Mappya mina ta awemuy la bit magtugut, te maski magyan kam la bit sin,” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","A gafu ta pangurug nig Kornelyu ikid na sakā Hentil na kiden ta uhohug na Namaratu a nesaned ya damag na pangurug da addet ta ngamin kiden lugar na Hudyo. A yen hapa ya nepakadamag na turin kiden ikid na kadwan kiden kabagis ta iningwa ni Pedru. ");
INSERT INTO agt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","A tentu en dimmatang tekid ta ili na Herusalem a medyo nakitapil ya mangurug kiden nga Hudyo tentu, a nehuya da. ");
INSERT INTO agt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Anu haman ta nagtalekudam ya lintig tam, te simarok ka haman ta bali na Hentil nga awan nabanggit, yaga nakikkanan ka para tekid?” kunda tentu. ");
INSERT INTO agt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","A yen hapa ya pake nepangipadangag na ta nakkwa tentu abat ta gafu na en, te ya uhohug na tekid a ");
INSERT INTO agt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Dana itta yak haman ta ili na Hoppe, a makimalmallakak. A sangaw itta ya nagmatakar teyak nga kuman na dakal na tarapal, ammi nagaak-akban ta bikat ken, a nagalutan ya kadadugu na en. ");
INSERT INTO agt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","A pake itan ku ta mappya, a napannu haman ta magmagannud na ayam kontodu ulag ikid na mamanuk. ");
INSERT INTO agt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","A sangaw itta ya nangbar teyak, ‘Pedru, magtayuk kan, a magparti ka ta igupam,’ kunna haman teyak. ");
INSERT INTO agt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","‘Atsi, awek O, Afu, te maski abat ta kaabbing ku awek para nangigup ta mehangat teyak,’ kunku hapa ay. ");
INSERT INTO agt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ammi ya tabbag hapa na nangbaren teyak a ‘Awem ibar ta mehangat ya ituluk na Namaratum,’” kunna. ");
INSERT INTO agt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A namillu ya nepangibar na teyak, a sangaw timullu ha ya tarapalen ta langit. ");
INSERT INTO agt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","12","“A ta netattullu na en a ittan hapa ya tallu na lālāki nga nagafu kan ta ili na Sesariya, Ammi negindan hapa ya uhohug na Kahalwa na Namaratu teyak ta awek mina magtalaw nga dumagdag tekid, te nedob kid kan nga mangalap teyak, ammi bakkan kid ta kagitta tam nga Hudyo. A dimmagdag kami mantu na annam kidin kahulun ku nga taga Hoppe, a nagdulot kami ta bali ni Kornelyu, te intu ya nangpaalap teyak. ");
INSERT INTO agt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","A sangaw binida ni Kornelyu ya nagmatakar tentu nga anghel nga kima-ma nagtayuk ta umag na bali na en. A ya uhohug kan na anghelen a ‘Mangidob ka ta umange ta ili na Hoppe, te paayagam ya magngagan te Pedru, ");
INSERT INTO agt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","te ipadangag na sangaw ya kurugam, petta mekerutan ka, te kumanen hapa ta anak mu kiden, ikid na atawam,’ kunna kan na anghelen tentu. ");
INSERT INTO agt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“A mamegafu yak para la maguhohug tekid, a ka-ma la pinasinapan na kid haman na Kahalwa na Namaratu ta kuman na ikitamen ta palungu. ");
INSERT INTO agt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","A yen hapa ya nepakanonot ku ta uhohug ni Afu Hesus ta palungu, te ‘Maski zinigut na kanan ni Hwan a mapasinapān kam hapa sangaw ta Kahalwa na Namaratu, petta mekustu ya nepagzigut na tekamuy,’ kunna haman tekitam. ");
INSERT INTO agt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ammi ta ayanen a pinasinapan na Namaratu ya Hentil kiden hapa ta kuman na iningwa na tekitam ta nepangurug tam te Afu Hesus. A am ikayat na mantu ya Hentil kiden a anu mabalin ku? Iyak hud ya manggamma ta Namaratu,” kun ni Pedru tekid. ");
INSERT INTO agt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","A tekiden nakadangag ta bida na en a awan na ta metabbag da ta pangihuya da tentu, am awa dinayawan da hud la ya Namaratu. “A am kunna mantu ten a talaga ta Hentil kiden hapa ya pagnonotan na Namaratu petta magbabawi kid, petta maatadan kid hapa ta magnayun angat,” kunda. ");
INSERT INTO agt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","A ta pasi ni Estebanen ta idi a pake mazigatan ya mangurug kiden ta ili na Herusalem, te pake mefulot ya makitapil kiden tekid. A yen ta nagkakattway ya mangurug kiden, a pake umadayu ya kadwan kiden abat ta lugar na Funisya ta pingit na bebay, a nagaddet ya kadwan para ta fugu na Sipre, a ya ili na Antiyoka ya nagaddetan na kadwan. A maski am had ya nagdulotan da a nepadangag da hapa ya damag ni Hesus, ammi intu la nangipadangagan da ya kagitta da kiden Hudyo. ");
INSERT INTO agt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ammi ya kadwan kiden mangurug nga taga Sipre ikid na Sirene a umange kid hapa ta ili na Antiyoka nga pake dakal na ili, a nepadangag da hapa i Afu Hesus ta tolay kiden ten nga magge dipuru Hentil. ");
INSERT INTO agt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","A nehulun hapa ya pakapangwa na Namaratu ta pangipadangag da, a mangurug hapa ya addu na Hentil, petta dumagdag kid na te Afu Hesus. ");
INSERT INTO agt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","24","A gafu ta pangurug da a nadamag na mangurug kiden ta ili na Herusalem a yen ta dinob da i Barnabas ta ili na Antiyoka, petta pasikkalan na ya pangurug da, te mappya hapa na tolay, a dakal ya pangurug na, a mapasinapān hapa ta Kahalwa na Namaratu. A tentu en dimmatang a matalakan hapa, te naita na ya bendisyon na Namaratu tekid, ammi pake nebar na tekid ta idulot da la ya pangurug da te Afu Hesus, a pake imaddu para ya mangurug ta Dafu tamen ta ili da en. ");
INSERT INTO agt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","A gafu ta imaddun ya mangurug kiden ta lugar da a yen ta enna apagan ni Barnabas i Salu ta ili na Tarsu, petta itta sangaw ya kauffunan na nga mangituldu ta mangurug kiden. ");
INSERT INTO agt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","A tentu en nakaita tentu a nehulun na ta ili na Antiyoka, a kanayun makigimung kid ta mangurug kiden ten abat ta takday darun, a netuldu da ya pake addu na tolay. A ya mangurug kiden te Hesus Kristu ta ili na Antiyoka a ikid ya popolu kiden managanan ta Kristiano. ");
INSERT INTO agt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A ta pagyan para la nig Barnabas ikid ni Salu ta ili na Antiyoka a umange hapa ya kadwan na pinaguhohug na Namaratu nga taga Herusalem. ");
INSERT INTO agt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","A ya takday tekid nga nagngagan te Agabus, a pinasinapan na Kahalwa na Namaratu, petta lavunan na ya dakal na bisin ta ngamin na paglelehut. A dimmatang hala ya linavun na en bisin ta ketta ni Ari en Klawdyo. ");
INSERT INTO agt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","A gafu ta mazigatan ya mangurug kiden ta lugar na Hudeya ta bisinin yen a yen ta nakanonot ya mangurug kiden ta Antiyoka ta magpetulud kid ta iuffun da tekid. A nangatad ya tagtakday tekid ta kompormi la na meatad da. ");
INSERT INTO agt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","A ta nepakauknud da ta ngamin iuffun da a neatad da teg Barnabas ikid ni Salu, petta ikid ya ange mangitulud ta piraken ta kalalaklakayan na mangurug kiden. ");
INSERT INTO agt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","A ta araw na bisinen a nepagafut ni Ari en Herud ya kadwan kiden mangurug petta pa-gangan na kid, ");
INSERT INTO agt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","a pinaputulan na i Santiago nga kabagis ni Hwan. ");
INSERT INTO agt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","A gafu ta matalakan ya Hudyo kiden ta pasi ni Santiago, a netubbat na hapa pagafut i Pedru ta kaatubangan na Pyesta na Simana. ");
INSERT INTO agt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","A ta nepakagafut dan tentu a enda nebalud, a matubtubbat ya tag-appat na suddalu nga magtaron tentu. Te ya uray na ari en a peuhet na sangaw am nabalin na ya Pyesta na Simana, petta papasin da ta atubang na tolay kiden. ");
INSERT INTO agt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ammi ya kahulun na kiden nga mangurug ta ili na Herusalem a pake nepakimallak da hapa ta Namaratu. ");
INSERT INTO agt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A sangaw ta hiklam ta kaatubangan na pangpohet da mina te Pedru a masidug hapa sekakawad, ammi nekering na duwa kiden suddalu, a duwa para na suddalu ya magtaron ta irwangan na agbaludanen. ");
INSERT INTO agt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","A ka-ma la lumattog ya anghel na Namaratu, a pinagdakar na ya ngamin umag na nakebaludan ni Pedru en. A sini-ged na hapa ya hakbu ni Pedru petta mahukal. “Alag mu magtayuk,” kunna kan na anghelen tentu, a ka-ma la naubadan ya kawad na kiden. ");
INSERT INTO agt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","“Aran magbarawasi kan, a magsapatos kan,” kunna ha. A ta nekabalin na nagsapatos a “Magsalnuk kan, a dumagdag kan,” kunna ha. ");
INSERT INTO agt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","A imuhet na dumagdag ta anghelen, ammi kuman na awena kurugan ya iningwa na anghelen, te pahig na kan ta tarinap na yen. ");
INSERT INTO agt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","A kumanen tinaliban da ya takdayen suddalu nga magtaron ikid na mekaduwa en ta mayor na irwangan, kapye da dimmatang ta irwangan na landuk ta batug na ili, a ka-ma la mahukatan ya irwanganen, a imuhet kid. A nagtugut kid abat ta takday na kalsada, a yen ya nangtugutan na anghelen tentu. ");
INSERT INTO agt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","A yen la ya nepakamu ni Pedru ta bakkan ta tarinap na am awa kakurugan. “Kakurugan mantu ta dinob na Namaratu ya anghel na en teyak, a nekerutan nak ta igakkad nig Herud ikid na Hudyo kiden teyak,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","A ta pakarikna ni Pedru ta nakkwa tentu a umange ta bali ni Mariya nga hina ni Hwan Markus, ammi dana itta ten ya addu na tolay nga nagaammung makimallak. ");
INSERT INTO agt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","A nagtoktok i Pedru ta irwangan na bali en, a enna nepa-na ni Roda nga takday na tagabu ta bali. ");
INSERT INTO agt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nengahalan na i Pedru, ammi awena haman nehukat gafu ta talak na en, te alistu hud la nagtoli ta agyan na tolay kiden, petta ibar na ta itta hala i Pedru en nga imatayuk ta irwangan, ammi aweda hapa kinurug. ");
INSERT INTO agt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Anu maguyung ka, awem hud amu ta mabalud,” kunda, ammi ipapilit na ta itta hala i Pedru ta irwangan. A ya uhohug da ha a “Mabalin ta intu de ya anghel na en nga mangifun tentu?” kunda. ");
INSERT INTO agt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ammi imatayuk para la ten i Pedru nga nakatotoktok. A tekiden nangihukat a intu kad, a pake masitang kid na ta talak da tentu. ");
INSERT INTO agt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","A pinagkamag na kid hapa, petta pake madangag da ya ibar na, a binida na ya nepangiuhet na Namaratu tentu ta agbaludanen. “Bidan muy hapa sangaw te Santiago ikid na kadwan kiden kahulun tam,” kunna hapa, kapye na nagtugut, te umange ta takwan na lugar. ");
INSERT INTO agt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","A ta kalakwatan na a pake magburung na ya suddalu kiden nga magtaron, te awan haman i Pedru ta nakebaludan na en. ");
INSERT INTO agt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","A nepaapag na hapa ni Heruden, ammi aweda naapagan. A pinohutan na hapa ta nagtaron kiden am had kunda nga awan nakarikna te Pedru. A gafu ta aweda amu a nebar na ta mapapasi kid, a sangaw nagtugut hapa, te umange ta ili na Sesariya, a nagyan ta bali na en ten ta pigahahaw. ");
INSERT INTO agt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","A ya tolay kiden nga taga Tiro ikid na Sidon a awan ta takwan na pangalapan da ta kanan da am bakkan ta lugar ni Herud. Ammi intu dulay te itta ya pangikatupagan na tekid, a yen ta nakanonot kid nga ange makikofun tentu, ammi pinolu da kinofun i Blasto, petta bidan na hapa ya pakikofun da ta ari en, te intu ya manaron ta bali na en. ");
INSERT INTO agt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","A sangaw ta nagbabidan da en na araw a nagsalnuk i Herud ta salnuk na pagari na en, kapye na nagtuttud ta agtuttudan na en, a sangaw namegafu magbida ta tolay kiden. ");
INSERT INTO agt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","A sa giaggayan hapa ya tolay kiden: “Bakkan ta tolay ya maguhohugina, te intu haman ya takday na dyos,” kun na aggay da, te pangikin da la tentu. ");
INSERT INTO agt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","A natalakan hapa, te negitta da ta dyos. Ammi gafu ta awena kid nehuya a yen ta pinaluk na anghel na Namaratu, a nairat hapa ya ngamin na barbari na, a nasin. ");
INSERT INTO agt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ammi pake mesaned para ya uhohug na Namaratu, te awan na ta manggamma, a imaddu para ya mangurug ta uhohug na en. ");
INSERT INTO agt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","A ig Barnabas ikid ni Salu nga umange mangisaned ta iuffun na mangurug kiden taga Antiyoka a nebalin da hapa ya pangisaned da. A sangaw inalap da i Hwan Markus ta kahulun da, kapye da nagtugut ta ili na Herusalem, te magtoli kid na ta ili na Antiyoka. ");
INSERT INTO agt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","A ta mangurug kiden nga magaammung ta ili na Antiyoka a aglavun ya kadwan anna mangituldu ya kadwan. A ya ngagan na kadwan a i Barnabas, ikid ni Simyon nga magngagan hapa te Niger, ikid ni Lusyo nga taga Sirene, ikid ni Manaen nga pinadakal ni Gubernador Herud, ikid ni Salu nga magngagan hapa te Pablu. ");
INSERT INTO agt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","A ta takday araw tekiden mangdayaw ta Namaratu a aweda hapa pagkakan, te intu la nonotan da ya pakimallak da. A itta hapa ya nepeuhohug na Kahalwa na Namaratu tekid. “Igungay muy ig Barnabas ikid ni Pablu, petta tarabakun da ya pangidoban ku tekid,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","A aweda bit tagopan ya mangan, petta pakimallak da ig Barnabas ikid ni Pablu, a nesagpaw da hapa ya kamat da kiden ta ulu da, kapye da kid pinatugut. ");
INSERT INTO agt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","A gafu ta Kahalwa na Namaratu ya mangituldu tekid ta angen da a nagtugut kid la, a dimmayum kid ta ili na Selusya ta bikat na bebay, kapye da nagbapor addet ta fugu na Sipre. ");
INSERT INTO agt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","A tekiden dimmagut ta ili na Salamina a umange kid makigimung ta kapilya na Hudyo kiden, petta ipadangag da ya uhohug na Namaratu tekid, a intu hapa kahulun da i Hwan Markus, te uffunan na kid hapa. ");
INSERT INTO agt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","A sangaw nesaned da ya uhohug na Namaratu ta ngamin paglehut na fugu en addet ta ili na Pafus, A ya gubernador na fugu en a nadamag na ya tarabaku nig Barnabas ikid ni Pablu, a ikayat na dangagan ya uhohug na Namaratu nga ipadangag da, a yen ta pinaayagan na kid ta bali na. Ammi itta hapa ten ya takday Hudyo sengagan na Elimas Baresus, a tabtabangan na ya pagipadangag nig Pablu, te ikayat na sansanatan ya gubernadoren petta awena kurugan ya uhohug nig Pablu. Amu ni Elimas ya magmadyik te tulad na aglavun. ");
INSERT INTO agt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ammi i Pablu a pake napasinapān hapa ta Kahalwa na Namaratu, a nagporay ya mata na en te Elimas. ");
INSERT INTO agt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Iko ya anak na Satanas, te ikatupag mu ya ngamin katunungan. Intu la amum ya magladdud ikid na manguyoyung, te awem haman magimmang mangpakillu ta dalan na Namaratu. ");
INSERT INTO agt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ammi pa-gangan na kan, te magdaram kan, a awem sangaw maita ya dakar addet ta mabayag,” kun ni Pablu tentu. A ka-ma la nagsugiram na ya itan ni Elimas, a kamkammatan na ya pakigemidan na. ");
INSERT INTO agt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","A ta nepakaita na gubernadoren ta iningwa na Namaratu te Elimas a mangurug na hapa, te pake nagpaka-lat hapa ta netuldu nig Pablu gafu te Afu Hesus. ");
INSERT INTO agt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","A ta nekabalin da ta ili na Pafus a nagtugut ha ig Pablu ikid na kahulun na kiden, a naglugan kid ha ta selayag abat ta ili na Perga ta lugar na Pampiliya, ammi yen hapa ya nangtammangan ni Hwan Markus tekid, te magtolin ta ili na Herusalem. ");
INSERT INTO agt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","A sangaw nagtugut hapa ig Pablu ikid ni Barnabas ta ili na Perga, te magdulot kid na ta takwan na Antiyoka ta lugar na Pisidya. A ta Sabadu a umange kid makigimung ta kapilya na Hudyo kiden, a nagtuttud kid, ");
INSERT INTO agt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","te dangagan da bit ya mangibasa ta surat ni mina Moses ikid na surat na kadwan kiden aglavun na Namaratu. A ta kabalin na pangibasa na a itta ya dinob na pinakadakal kiden ta ange mangibar teg Pablu ta maguhohug kid hapa. “Mappya, kahkahulun, ta magbida kam hapa am itta ya ibar muy ta tolay kidin,” kunna. ");
INSERT INTO agt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","A nagtayuk mantu i Pablu, kapye na nagsenyas tekid, petta dangagan da ya ibar na. “Ikamuy nga Istralita, ikid na ikamuy Hentil nga mamat ta Namaratu ewan, a dangagan muy ya mabidak tekamuy. ");
INSERT INTO agt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dana amu muy haman ya iningwa na Dafu tamewan Namaratu ta palungu na araw, te pinili na ya gingginafu tam kiden, petta tolay na kid. A tekiden nagyan ta lugar na Egipto a pake pinakaddu na kid. A sangaw pina-gang na hapa ya nagpatagabu kiden tekid ta pakapangwa na en, petta patugutan da ya tolay na kiden nga pagzigātan da. A sangaw netugut na kid hapa ta lugar na Egipto, ");
INSERT INTO agt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","a inifunan na kid ta kalafukanen addet ta appatafulu na darun. ");
INSERT INTO agt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","A sangaw inuffunan na kid nga mangabak ta pitu na nasyon ta lugar na Kanaan, kapye na neatad ya lugarin yen tekid, petta kwa da. A kumanen nagpasan ya appatagatut a limafulu na darun addet ta neange na dadagkal da kiden ta lugar na Egipto. ");
INSERT INTO agt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“A ta kabalinan na a pinili na Namaratu ya tagtakday manaron tekid addet te Samwel, a intu hapa ya napolu en aglavun na Namaratu tekid. ");
INSERT INTO agt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","A tentu en naglaklakay a nagadang ya tolay kiden ta ari da, a pinili na Namaratu i Salu nga anak ni Kis, a simsima hapa ni mina Bendyamin. A i Salu mantu ya ari da abat ta appatafulu na darun. ");
INSERT INTO agt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","A ta nepangawe na Namaratu te Salu a pinili na i mina Dabiden, petta intu ya ari da, te ya uhohug na Namaratu tekid a ‘Intu la megitta ta nonot ku i Dabid nga anak ni Dyesi, te kurugan na sangaw ya ngamin patarabakuk tentu,’ kunna. ");
INSERT INTO agt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“A ya simsima kiden hapa ni mina Dabiden ya nagafun na Mangikerutanen nga nekari na Namaratu tekitam, te intu hala i Hesus. ");
INSERT INTO agt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ammi dana imunnan bit tentu i mina Hwanen, te nepadangag na ta magbabawi mina ya ngamin tolay nga Istralita ta liwat da kiden, kapye na kid zigutan. ");
INSERT INTO agt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","A ta tanagay pagaddetan na tarabaku ni Hwan a dana nepadangag na ya ange na Mangikerutan ta tolay kiden. ‘Iyak hud ya Mangikerutan nga doban na Namaratu tekamuy, am awa pumatalin hala sangaw teyak. A pake atata-nang ammi teyak, te awek haman megitta nga makitagabu tentu,’ kunna. ");
INSERT INTO agt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“A yen mina ya nonotan tam, kahkahulun,” kun ni Pablu, “te ikitam nga simsima ni mina Abraham, ikid na ikamuy Hentil nga mamat ta Namaratu, a ikitam haman ya nangipakkamun na Namaratu te Hesusen nga mangikerutan tekitam. ");
INSERT INTO agt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Te ya tolay kiden ta ili na Herusalem ikid na pinakadakal da kiden a aweda haman amu ta intu ya Mangikerutan nga nekari na Namaratu tekitam, te pinapasi da haman. Ammi aweda haman amu ta dana nalavun ya pasi na ta surat na nanglavun kiden, te maski am kanayun basan da ya surat da kiden ta kada Sabadu a aweda haman manonot ta ikid ya nangidulot ta dana nalavun ta surat kiden. ");
INSERT INTO agt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Te maski awan haman ta napasikkal da ta liwat ni Hesus a nepapilit da hala ya pasi na te Gubernador Pilato. ");
INSERT INTO agt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","A ta nepangpapasi dan tentu a nabalin na hapa ya ngamin nalavun tentu ta surat kiden, te itta ya umange nangidagut ta bari na en ta kayu en nga nagappan na, kapye da netanam. ");
INSERT INTO agt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ammi tinolay hala na Namaratu ewan, ");
INSERT INTO agt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","a kanayun nakipaita ta kahulun na kiden taga Galileya addet ta addu na araw, te dana nehulun kid tentu ta ili na Herusalem, a ikid na ya mangipasikkal ta katolay na. ");
INSERT INTO agt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“A yen ta itta kamin hapa sin, kahkahulun ku, petta madangag muy hapa ya ipadamag mi tekamuy nga mappya. Te ya Mangikerutan nga nekari na Namaratu ewan ta gingginafu tam kiden a intu hala i Hesus nga dinob nan tekitam. A gafu ta kumanen a pake nagdulot na te Hesus ya inuhohug na Namaratu te mina Dabiden nga nesurat na ta mekaduwa en Kansyon na, te ya uhohug na Namaratu tentu a ‘Iko hala ya anak ku, te nagbalinak na ta kuman na damam,’ kunna. ");
INSERT INTO agt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“A ya takday para uhohug na Namaratu ta gingginafu tam kiden nga mangibar ta katolay ni Hesus, petta awenan ha sangaw masi, a intu yan: ‘Bendisyonan ta kam hala sangaw ta magnayun na pagariyan, te awek ibabawi ya nekarik te Dabid,’ kunna. ");
INSERT INTO agt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“A ya uhohug hapa ni Dabid ta takday para kansyon na ta Namaratu a ‘Mappya hapa yen, Afu, te awem sangaw ituluk ta malabag ya ikatalak min,’ kunna. ");
INSERT INTO agt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Ammi bakkan haman ta bari ni Dabid ya nebar na en nga awan malabag, te kabalinan na nepagserbi ni Dabid ta patarabaku na Namaratu tentu a nasi hapa, kapye da netanam ta hebing na dadagkal na kiden, a malabag haman. ");
INSERT INTO agt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ammi i Hesusen ya tinolay na Namaratu ewan, a intu mantu ya nebar na en nga awan malabag. ");
INSERT INTO agt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","A yen mina ya pagnonotan muy, kahkahulun ku, te ye-yan na tolay nga awan malabag a intu hala ya gafu na pangpakoma na Namaratu ta liwat tam kiden. A intu ya mangikerutan nga ipadangag mi tekamuy. ");
INSERT INTO agt_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ammi am ikatalak muy ta mekerutan kam gafu ta pangidulot muy ta lintig kiden ni mina Mosesen a melogot kam, te awemuy kid haman sa idulot. Ammi am intu ikatalak muy ya nepangikaru ni Hesus ta liwat muy kiden a mekerutan kam. ");
INSERT INTO agt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","A mappya mantu ta pake nonotan muy yan, kahkahulun, talo am mekabat kam hapa sangaw ta pangpa-gang na Namaratu nga nepadangag na aglavun na en, te ya uhohug na Namaratu ta mangidadula kiden ta idi a ");
INSERT INTO agt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ikamuy nga mangidadula a pagka-ma muy sangaw ya dumatang tekamuy, a yen hapa sangaw ya pasin muy. Te itta sangaw ya padatangan ku ta lugar muy nga awemuy kurugan maski am dana nepadangag mina tekamuy,’ kunna.” A yen ya addet na bida ni Pablu tekid. ");
INSERT INTO agt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","A ya nebar da teg Pablu ta neuhet da ta kapilya en a “E kam hala sangaw sin mangipadangag ta takday Sabadu, te pake dangagan mi ha ta mappya,” kunna na tolay kiden tekid, kapye da hapa nagugungay. ");
INSERT INTO agt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ammi ya Hudyo kiden ikid na Hentil kiden nga dana simarok ta relisyon na Hudyo a addu kid hapa nga himulun bit teg Pablu ikid ni Barnabas, a pake nebar da ta aweda mina pagtalekudan ya allak Namaratu tekid. ");
INSERT INTO agt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","A ta takday ha na Sabadu a makipagammung hapa ya magge ngamin kiden tolay ta ili, te ikayat da dangagan ya uhohug na Namaratu nga ipadangag nig Pablu. ");
INSERT INTO agt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ammi gafu ta itta ya pake addu na Hentil a neahugu na Hudyo kiden i Pablu, a yen ta nakitapilan da ya inuhohug na en, yaga inamamat da para. ");
INSERT INTO agt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ammi pake nagturad hapa ig Pablu nga mangtabbag tekid, “Mappya ta uray na Namaratu ta ikamuy Hudyo ya mapolu pangipadangagan mi ta uhohug na, ammi gafu ta iwarad muy, ikid na dugiman muy ya bari muy ta magnayun na angat a e kami mantu ta Hentil kiden. ");
INSERT INTO agt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Te ya pakkwa na Namaratu tekami nga nesurat ni mina Isayas a ‘Isaad ta kam sangaw ta kuman na zilag nga mangpadakar ta Hentil kiden, petta mekerutan mina ya ngamin tolay addet ta ngamin paglelehutin,’” kunna. ");
INSERT INTO agt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","A ta pakadangag na Hentil kiden ta nebar ni Pablu a dinayawan da hapa ya uhohug na Namaratu, a pake natalakan kid na gafu ta isipat na kid hapa. A nangurug hapa ya ngamin kiden nekari nga maatadan ta magnayun na angat. ");
INSERT INTO agt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","A gafu ta kumanen a pake nesaned para ya uhohug na Namaratu addet ta ngamin paglelehut da en. ");
INSERT INTO agt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ammi ya magturay kiden ta ili nga lālāki ikid na naba-nang kiden babay nga makipaggimung ta kapilya da en a pinagporay na Hudyo kiden ya nonot da, petta ikatupag da ig Pablu, a yen ta pinatugut da kid ta ili. ");
INSERT INTO agt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","A gafu ta kumanen a inazi nig Pablu ya lafu na lutak da ta takki da kiden gafu ta awena kinurug na Hudyo kiden ya uhohug da, a nagdulot kid na ta ili na Ikoniya. ");
INSERT INTO agt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ammi ya mangurug kiden nga magyan ta ili en a mapasinapān kid la ta Kahalwa na Namaratu, a pake matalakan kid hapa. ");
INSERT INTO agt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","A ta datang nig Pablu ikid ni Barnabas ta ili na Ikoniya a kuga umange kid ha mangipadangag ta kapilya na Hudyo kiden, a nangurug hapa ya addu na Hudyo pase Hentil gafu ta kalalaki na paguhohug da. ");
INSERT INTO agt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ammi ya Hudyo kiden nga awan mangurug a pinagporay da ya nonot na kadwan kiden Hentil, petta ikatupag da ig Pablu. ");
INSERT INTO agt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ammi maski ikatupag da kid a mabayag kid la ten, te maturad kid la mangipadangag ta allak na Namaratu. A pinasinapan na kid hapa ta pakapangwa na, petta itta ya ihuga da ta tolay kiden, a yen ya nangipasikkal ta allak na en nga nepadangag da tekid. ");
INSERT INTO agt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ammi nagkakattway garay ya nonot na tolay kiden ta ili, te ya kadwan a nakidagga kid ta Hudyo kiden nga makitapil, a ya kadwan tekid ya nakidagga teg Pablu ikid ni Barnabas. ");
INSERT INTO agt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ammi sangaw a nahahulun ya kadwan kiden Hudyo ikid na Hentil kontodu pinakadakal da, petta pa-gangan da ig Pablu, te igakkad da ya mamapasi tekid ta batu. ");
INSERT INTO agt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Ammi ta pakadamag nig Pablu ta igakkad da en tekid, a nagtammang kid. A umange kid na mangipadangag ta damag ni Hesus ta ili na Listra ikid na Derbe ikid na kadwan kiden ili ta lugar na Likonya. ");
INSERT INTO agt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","9","A ta ange da en ta iten Listra a itta ya lalaki nga awan makatugut, te pilay kan abat ta nekeanak na en, a imatuttud la ten magdangag ta bida ni Pablu. A pake itan na hapa ni Pablu, a narikna na ta ikatalak na ya pagpamappya na Namaratu tentu, a pake magayag na i Pablu tentu. ");
INSERT INTO agt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","“Magtayuk kan sina,” kunna, a ka-ma la timollok nagtayuk, a nagpapa-yat na hapa. ");
INSERT INTO agt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","A ta pakaita na tolay kiden ta iningwa ni Pablu a naggihawa kid na: “Dyos tam yan kid nga nagbalin ta tolay,” kun na girawa da en, ammi awena naawatan nig Pablu, te negirawa da haman ta agsitang da hapa la nga agsitang na Likonya. ");
INSERT INTO agt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","A i Barnabas ya nengagan da ta Ziyus, te Ziyus ya ngagan na takday dyos da. A i Pablu kan ya dyos da en Hermes, te intu ya mayor na magbida. ");
INSERT INTO agt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","A ya padi na dyos da en Ziyus a nangalap hapa ta toro na baka nga pinagsigal na ta addu na sabong, a nedatang na ya baka en ta agyan na simbaan na tolay kiden ta pingit na ili, petta iatang da mina teg Pablu ikid ni Barnabas. ");
INSERT INTO agt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ammi ta pakadangag nig Pablu ta atangan na kid a pinispissang da ya barawasi da kiden ta pangikatupag da ta pangatang da, a magbilag kid na ta tangngan na tolay kiden, petta gamman da kid. ");
INSERT INTO agt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“An-anu haman yana O? Bakkan kami ta dyos muy, te kagitta da kami la nga tolay,” kunda. “Yen ta ipadangag mi ya damag ni Hesus tekamuy petta amu muy ya kakurugan na Dyos nga namadday ta ngamin kiden itta ta langit pase paglelehutin. Mappya mantu ta azin muy ya mangatang ikid na makimallak ta awan manguffun tekamuy. ");
INSERT INTO agt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","“Ta idi a pinagorayan na Namaratu ikamuy nga Hentil nga awan makkamu tentu, ");
INSERT INTO agt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ammi maski kunna ten itta hala ya neatad na nga mangipasikkal tentu, te intu haman ya mangatad ta ngamin udan, ikid na pagmayan na imula tam, petta matalakan kitam ta ngamin kanan tam,” kunda hapa. ");
INSERT INTO agt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ammi maski kunna ten ya netabarang nig Pablu tekid a magge aweda nagamma ya pangatang da tekid. ");
INSERT INTO agt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","A ta nepagpasan na pigpigaaraw a dimmagdag hapa ya Hudyo kiden taga Antiyoka ikid na Ikoniya, a pake pinadpadulay da i Pablu ta tolay kiden, petta ikatupag da, a winarad da mantu ta batu. A sangaw ginerger da ya bari na en neuhet ta ili, a newagak dan, te pahig da ta nasin. ");
INSERT INTO agt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","A mappya la, te dimmadagdag hapa ya kahulun na kiden mangurug, a linehut da ya bari na en. A ta mangananwan la a nagtayuk hala i Pablu en, a nagtoli hapa ikid na kahulun na kiden ta umag na ili. A ta lalakwat a nagtugut ha i Pablu ikid ni Barnabas, te magdulot kid na ta ili na Derbe. ");
INSERT INTO agt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","A tekiden nangipadangag ta damag ni Hesus ta ili na Derbe a mangurug na hapa ya addu na tolay ten. A sangaw nagtoli ha ig Pablu ikid ni Barnabas ta inange da en, a sage nagsibal kid ha ta ili na Listra ikid na Ikoniya ikid na Antiyoka na Pisidya, ");
INSERT INTO agt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","petta pagturadan da ya mangurug kiden ta isin kid na ili. A netuldu da kid ta aweda mina kaliwatan ya pangurug da. “Am ikayat tam mesipat ta pangikerutan na Namaratu a mappya ta attaman tam hapa ya zigat na pangurug tam,” kunda tekid. ");
INSERT INTO agt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","A ya iningwa da para ta tagtakday lugar a netun da ya pinakadakal na mangurug kiden nga makkamu magtaron tekid. A aweda bit mangmangan, te intu la tagopan da ya makimallak, te ipataron da ya netun da kiden te Afu Hesus. ");
INSERT INTO agt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","A tekid na ha nagtugut a ginadak da ya lugar na Pisidya addet ta dumatang kid na ta ili na Perga ta lugar na Pampiliya. ");
INSERT INTO agt_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","A yen bit ha ya nangipadangagan da ta uhohug na Namaratu, kapye da ha nagdulot ta ili na Ataliya. ");
INSERT INTO agt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","A sangaw naglugan kid ha ta selayag nga dumayum ta ili na Antiyoka ta lugar na Siriya, te nebalin dan ya nepatarabaku na Namaratu tekid. A dumatang kid na ta ili na Antiyoka, te yen ya nagganwatan da en ta nepangidob na kahulun da kiden tekid, petta idulot da ya patarabaku na Namaratu tekid. ");
INSERT INTO agt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","A tekiden dimmatang a pinagaammung da ya mangurug kiden, a binida da ya ngamin panguffun na Namaratu tekid ikid na nepanghukat na ta nonot na Hentil kiden petta mangurug kid. ");
INSERT INTO agt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","A nakipagyan kid na ta mangurug kiden ten abat ta mabayag. ");
INSERT INTO agt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","A ta ketta para la nig Pablu ikid ni Barnabas ta mangurug kiden ta ili na Antiyoka a itta ya dimmatang nga nagafu ta mangurug kiden ta Hudeya, a takwan ya netuldu da ta mangurug kiden nga Hentil. “Awena mabalin ta mekerutan kam am awemuy hapa mabanggit ta kuman na netuldu ni mina Moses,” kunda tekid. ");
INSERT INTO agt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ammi gafu ta awena ikayat nig Pablu ikid ni Barnabas ya netuldu da a makidibati kid na abat ta medyo mabayag. A gafu ta awan ta ituluk na takday a yen ta napatudunan ig Pablu ikid ni Barnabas ikid na kadwan kiden mangurug, petta medob kid ta ili na Herusalem ta agyan na turin kiden ikid na kalalaklakayan na mangurug kiden ten, petta enda pasikkalan tekid am anu ya mappya. ");
INSERT INTO agt_vpl VALUES ("A