﻿USE sofia;
DROP TABLE IF EXISTS sofia.agr_vpl;
CREATE TABLE agr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES agr_vpl WRITE;
INSERT INTO agr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Yama nagkamchakug, Apajuík nayaimpin nugkajai najanauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nugka niimeg atsau, ayatak nayants kuna, suwe ijiamu aajakui. Nuna awanken Apajuín Wakani buchitu au. ");
INSERT INTO agr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Nuadui Apajuí chichaak: “¡Tsaaptin weti!” tusa tamawaik, tsaaptin wajasui. ");
INSERT INTO agr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nuna Apajuí diis “tsaaptin aku ima pegkejai”, tusa tsaaptinun suwenmayan akankauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Duwi tsaaptinun adaikauwai “tsawai”, tuja suwen adaikauwai “kashi” juna takas ejeyuwai makichik tsawantan. ");
INSERT INTO agr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Nuigtu Apajuí chichaak: “Agkaju múun wajasti, nuniak yumin akanjati”, tiuwai. Tamawaik imanisag uminkauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Dutika Apajuí agkajun najana, yumi nugkaya atinun tuja yakiya atinjai akankauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Dutika Apajuí agkajua nuna adaikauwai “nayaim”. Juna umik kintamag tsawak jimag tsawantan ejeyuwai. ");
INSERT INTO agr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nuna ashimak Apajuí chichaak: “Nayaimpi nugkaan yumi ayá juka makichik ijunbaunmag ijunjati, nunitai buku wantinkati”, tiuwai. Tamawaik imanisag uminkauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Yumi makichik ijunbaunmak ijunjamtai buku juwakua nuna Apajuí adaikauwai “nugka”, untsu yumi piyajua nuna adaikauwai “nayants”. Nuna Apajuí shiig pegkeg diisui. ");
INSERT INTO agr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Nuna umika Apajuí chichaak: “Ashí nugkanum dekas ajak aidau, dupa nejen aidaush, nuigtush numi nejen aidaushkam tsapakti”, tiuwai. Tamawaik imanisag uminkauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nugkanmak ashí ajak aidau tsapakui, dupa nejen aidaush antsag numi nejen aidaushkam, nejenak mantamsawag ijuntsauwai. Nuna Apajuí shiig pegkeg diisui. ");
INSERT INTO agr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Juna aatus kampatum tsawanta duwi umikui. ");
INSERT INTO agr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Tuja nuigtushkam Apajuí chichaak: “Agkaju múun wigka weaja juiyash, etsantug nugkan tsaapmitkau aidau aitnume, nunú etsantak akankati tsaaptinun suwenmayan, dutikam tsawan, nantu, mijan aina nunú dekaapatain iwainau agtinun. ");
INSERT INTO agr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Nunú nayaimpin agkajujin nanamsag etsantuinak ashí nugkan tsaapmitkau agtinme”, tiuwai. Tamawaik imanisag uminkauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nuadui Apajuí dekas jimag etsantin agtinun najanauwai: Tsawai etsanjatnun ima muuntan najanak, kashi etsanjatnunak yaijan najanauwai. Nuigtushkam yaya aidaunashkam najankauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Dutika Apajuí nugkan tsawai kashijai tsaapmitkatnun, etsantin aina nuna apusauwai agkaju múun wigka weaja nuwi. Nuna Apajuí shiig pegkeg diisui. ");
INSERT INTO agr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Juna taka takakua kintamag, ipak usumta juu tsawantan ejeyuwai. ");
INSERT INTO agr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Nuna ashí umiku asa, Apajuí chichaak: “Namaka batsamsatin aidaush ditashkam yujaktinme, nuniagtai nugka awanken, nayaimpin agkajuji aina juwi yujasagtin aidaushkam, chigki wegantu aidaush yujaktinme”, tiuwai. Tamawaik imanisag uminkauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nuigtushkam Apajuí najankauwai nayantsanmaya kuntin dekas múun aina nuna, nuigtushkam tikich namak yaig aidaun nagkamas ashí najankauwai. Chigki wegantu aidaunashkam imatiksag najankauwai. Nuna Apajuí shiig pegkeg diisui. ");
INSERT INTO agr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Juna najanak Apajuí pegkegnum yumigkiak: “Yujaktajum imaniakjum nayantsanum piaktajum, tuja chigki wegantu aidautigmeshkam imanisjumek yujaktajum, imaniakjum ashí nugka jamagtajum” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Makichik uwejan amua tsawanta duwi junak najanauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Nuigtushkam Apajuí chichaak: “Nugkanmashkam yujakti kuntin maki makichik niimtin aina nunú, kuntin tagkumtai aidau, tagkumchatai aidaujai, tuja tikich kuntin japiinas yujau aidaushkam”, tiuwai. Tamawaik imanisag uminkauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Apajuí juju kuntin aidaun najankauwa nunak, ashí pegkeg diisui. ");
INSERT INTO agr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ashí juna umik chichaak: “Yamai aents iina niimejai betek najanami, nii nugkanum pujusmatai, namak nayantsanmaya aidaush, nanamtin aidaush, kuntin aidaush, kuntin japiinas yujau aina dushakam ima niinak umigtinme” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Apajuí aentsun najadauwa nunak niina niimejai betek, aishmagkun nuwajai najanauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Dutika pegkegnum yumigkiak: “Yujaktajum, nuniakjum nugkak ashí jamagtajum, tuja nayantsanmaya namak aidauk ashí atum kuitamkatajum, tuja agkajunum chigki nanamin aidaush, kuntin wegantu nugkanum yujaka dushakam ashí atumin umigtamtinme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Tusa Apajuí chichaak: “Yamai atum shiig antuktajum; ashí ajak juju nugkanmaya nejen aina nunak, numi neje yujutai aina nujai, atum yuwatnun umigkajime. ");
INSERT INTO agr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Unstu, ashí kuntin nugkanum ayá nunash, chigki wegantu aidaunashkam, japiinas yujau aina nujai, ashí pujutji ajamu aina nunak, ashí dupa samekbau aina nuna dita yuwatnujin umigkajai”, tiuwai. Tamawaik imanisag uminkauwai. ");
INSERT INTO agr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Apajuí ashí nii najankamujin ijumag diis tiki pegkeg wakejumain diisui. Juna najanak ashimak juinia uwejan makichik ijuk tsawantan ejeyuwai. ");
INSERT INTO agr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Juna Apajuí aatus nayaimpin, ashí nayaimpinum ayá nujai najana, nugkanash ashí nugkanum ayá nujai najanak ashimkauwai. ");
INSERT INTO agr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ashí najanak umik, tsawan sieteya juwi Apajuík ayamjauwai. ");
INSERT INTO agr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nuadui nunú tsawantan Apajuí etegkauwai, tsawan pegkejam tuke takashtai, ayamtai atin ati tusa. ");
INSERT INTO agr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Jujuwai Apajuí nayaimpin nugkajai najanamua nunú pachisa augbattsamu. Apajuí nayaimpin nugkajai najanauwa nunú tsawantaik, ");
INSERT INTO agr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","makichik numikesh, dupagkesh tsapaichu aajakui. Wagki eke Apajuí yumin yutumtikchau asamtai. Nuigtushkam aents nuna takai ajakmamainkesh atsujakui. ");
INSERT INTO agr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ayatak nugka initkenia yumi bukuiti jiinki nugkan ukatujakui. ");
INSERT INTO agr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Nuwiyan Apajuí, nugka yukukuntun juki aentsun najanauwai. Dutika najana aepes, dujinum umpua mayain egketuk, aents iwaku ema inankiuwai. ");
INSERT INTO agr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nuna dutika, Apajuí etsa minitaijiya atú Edén nugkanum yujagken ajatuauwai, dutika nuwi nii aents najanamujin apusauwai. ");
INSERT INTO agr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Apajuí ashí numi pegkeg aidaun yujág yutai aidaunash uyujkauwai. Untsu nuna ejapeen ajatuawai jimag ajakan. Makichik ajak nuna neje yuwakuik tuke jachatai tabaun, tikich ajakan neje yujuaik, pegkejash pegkegchaujai dekatai tabaujai. ");
INSERT INTO agr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Nunú nugka Edégnum makichik namak jiiniuwai ajak aidaun ukatkatin. Nunik nuwiya ipak usumta imajin namak tsegkejui. ");
INSERT INTO agr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Makichik tsegkeakun daaji Pisón tutai aajakui. Nunú namakak nugka Havilá tutai dekas oro pujamua nuna tentea apajakui. ");
INSERT INTO agr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Nuiya oro ima shiig pegkejai. Nuanuig ayawai numi bedelio daagtin puwaji kugkuin, tuja kaya ónice tutaishkam ayawai. ");
INSERT INTO agr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Tuja tikich tsegkeakbaun daajiyai Guihón tutai. Nunú Cus nugkan ashí tentea apajakui. ");
INSERT INTO agr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Kampatuma nunuwai namaka daaji Tigris. Duka Asiria nugka, etsa minitaiya nuni awa aatus nagkaemakui. Untsu ipak usumta nuna daajiyai namak Eufrates. ");
INSERT INTO agr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Apajuí aentsun Edégnum: “Juwi pujusam takakum ajakmata, dutikakjum kuitamkata ashí wi najankag juka”, tusa apusauwai. ");
INSERT INTO agr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Dutika chichajak: “Ashí yujág juju ajanum ayá juka yuwata. ");
INSERT INTO agr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Untsu yujág pegkeg, pegkegchaujai dekatai ajá ejapeen waja duka yuwawaipa, nunú yuwakmek dekas jakattame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Nuna tusa Apajuí chichaak: Aishmag ima nigki pujakug pegkegchauwai, dekas niijai tsanias pujusa yainimainun najanatjai, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Apajuí ashí nugkanmaya kuntin aidaun najankauwai, ashí chigki wegantu aidaunashkam najanak aentsun juki itan awajus: Ame maki makichik kuntin aina juna daajig adaijata, tusa tima nii imatiksag adaijauwai. ");
INSERT INTO agr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ashí kuntinu daaji aidaunak, chigki wegantu aina nunashkam nii adaijamua nunisag juajui. Nuna aents dutika takak pujakushkam, niijai atuesa yainimainjinak igkugchauwai. ");
INSERT INTO agr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Nuadui Apajuí aishmagkun kaján ipatuk senchi ikanag niina pagaen makichik jujukiuwai, dutika agkau tepeamtai nigki esamtikauwai. ");
INSERT INTO agr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nunú aishmagkun pagae jujukbauwai Apajuí nuwan najanauwai, dutika aishmagkun ejetiuwai. ");
INSERT INTO agr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Nuna wainak aishmag chichaak: “Juka mina iyashjuiya pagae juki najanamui, nuadui niina daajig nuwa tutai atatui, wagki Apajuí aishmagnumian juki najadau asamtai.” ");
INSERT INTO agr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Nuadui aishmag nuwenkug makichik iyashik weawai. Nuniau asa apajinak niina dukujijai ukuak ima niina nuwejaig pujumainai. ");
INSERT INTO agr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Aishmagkuk, niina nuwejai mai wisu batsamajaku ainawai, tujash nuniakush datsaamájakchaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Apajuí ashí kuntin tagkumchatai aidaun najankauwa nuwiya, dapi ima senchi kajinkachu, tsanumtan yacha asa, nuwan tajua iniak: “¿Apajuísh wajinjutpagmae, juju yujág aina duka makichkish yuwawaigpajum tujamiagmaka?” tau. ");
INSERT INTO agr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Tama nuwa ayaak: “Yujagkek ashí yumainaitji. ");
INSERT INTO agr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Untsu Apajuí iina chichagtamak, tikich yujág ejapeen waja auna nejeg yuwawaigpa, antiitkesh antigkaigpa, auna neje yuwakjumek jakattajume, tusa tujamaji” tau. ");
INSERT INTO agr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tutai dapi nuwan chichajak: “Auk wainak tujamne, jakashtatjume. ");
INSERT INTO agr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Apajuí shiig dekawai, au yujág yuwakjumek, atum wajukua ainagme nunú wainmamkajum Apajuíjai betek wajasjum, pegkeg, pegkegchaujai dekamainaitjum nuadui aunak tujabiugme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Tama nuwa yujagken diistakama shiig senchi wakejukui. Nuniak dekas yuwatjai, nunikan Apajuí wainbau yacha iman atajai tusa, akaka juki yuwauwai. Nunik aishinashkam susam, niishkam juki yuwauwai. ");
INSERT INTO agr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nuna yuwawag wajanbauwaik, mai wisu wajamun wainmamkajui, nunikag makichik ajak higuera tutaya nuna dukeen apajag itipjuawajui. ");
INSERT INTO agr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Nunikag batsatai aagkú dase dasenbaunum Apajuí wekagun antukag, waipakai tusag tupikakiag numi ijunbaunum uumkajui. ");
INSERT INTO agr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tujash Apajuí aishmagkun untsuka iniak: “¿Tuwi amesh pujame?” tau. ");
INSERT INTO agr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tama nii ayaak: “Wika ame minamun antukan ishamkajame, núnikan wisu pujau asan uumjukjame”, tau. ");
INSERT INTO agr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Tutai Apajuí aishmagkun chichajak: “¿Ya ame wisu pujamunash dekamtijamame? ¿Wagka wi amina yujág yuwawaipa timajam dusha yuwamume?” ");
INSERT INTO agr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Tama aishmag Apajuín ayaak: “Ame wijai tsaniasa pujusa yainikti tusam nuwa sujusmaum nunú yujagken sujusmatai, wika yuwamjai” tau. ");
INSERT INTO agr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tutai Apajuí nuwan iniak: “¿Amesh wagka dutikamume?” Tama nuwa ayaak: “Minak dapi tsanujamtai, yujagken yuwamjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Timatai Apajuí dapin chichajak: “Amek juju dutikau asam, ashí kuntin aidaun nagkaesau tikima shiig pegkegchau atinaitme. Yamai nagkamsamek japiintsam wekaesam nugka yukukuntu yuu wekaetinaitme. ");
INSERT INTO agr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Amek yamai nagkamsamek nuwajaig tuke shiwag atinaitme, nuadui amina uchijum wegantu agtina dusha, nuwa uchiji wegantu agtina nujaish tuke shiwajak agtinai. Nuwiya makichik amina buukmin dekenjamkatnai, tujash amek ayatak niina sagkani esattinaitme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Nuna tusa nuwan chichajak: “Amek ejapjukmesh najaimakum senchi waittsam uchigbau atinaitme. Imanika waitiakmesh tuke amina aishjumjai pujutak waketinaitme, nuniakmeshkam amina aishjum tabau tuke umigtinaitme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Tusa aishmagnashkam chichajak: “¿Wagka nuwemin chichame antugkumesh, wi juju yujág yuwawaipa tusa timajam dusha yuwamume? Ame umishtaimin yamai nagkamsag nugkak shiig pegkegchau wajastatui. Amek nuwiya waittsam ajakmam yuwatnaitme, ima imaniakuam ame jakum ukuktinaitme. ");
INSERT INTO agr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nugkanmak jagki, ashí numi, dupa jagkigtin aidaush yujaktatui. Imanikmatai ikamia ajak aidau yutinaitme. ");
INSERT INTO agr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Amina senchigmin takasa yuwa pujusam ataktu nugka najaneakum ukuktinaitme, wagki amek nugka najanamu asam. Nuadui ame jakmeshkam nugka juki najanamu asam, nunismek nugka najaneatnaitme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tusa tima Adán niina nuwe daajin adaikauwai Eva: Nii ashí aentsun dukuji atin asamtai. ");
INSERT INTO agr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Tuja Apajuí dita nugkujagtinun kuntinu duwapen najatua anujauwai. ");
INSERT INTO agr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Dutika Apajuí chichaak: “Yamaik aentsuk jutii ainag nujai betekmamtin wajasaje, iman asag ditashkam pegkejan pegkegchaujai dekainawai. Nuniau asag yamai nagkamsag yujág pujutan sukagtina auna yuwawag, tuke jatsuk pujusainum tajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nuadui Apajuí aentsun Edégnum pujaun jiiki juki yamaik nugka najanamua juwi takasa yuwa pujustinme tusa apusauwai. ");
INSERT INTO agr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Dutika jiiki ajapeak, Apajuí niina aentsjin querubin aidaun etsa minitaiya aatuni awaantauwai. Dutikak yujág pujuta sukagtina nuna waya yuwawainum tusa puyag kegaun apujtusui. Nunú Edégkan tentea apajakui. ");
INSERT INTO agr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adánka nuwe Eva ejapjukui, nunik pujus tsawanji jegajim aishmagkun uchigmakui, nunik adaikauwai Caín. Nunak: “Makichik uchin aishmagkun uchigmakjai, junak Apajuí minak sujuse”, taku tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Duwi pujus Eva tikichin uchin Abelan Caígka yachin uchigmakui. Abelak uwijan kuitamajakui, untsu Caín ajakan ajakbau aajakui. ");
INSERT INTO agr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kuashat tsawan nagkaemakiu ai, makichik tsawantai, Caín Apajuí anentag susatnun ajaka nejen juuka juki ejentauwai. ");
INSERT INTO agr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Tuja Abelchakam makichik uwig yama nagkamchak petsakbau shiig duwegman achika juki Apajuín emematak ejetiuwai. Dutikamtai Apajuí Abelnak shiig anenjauwai, nuadui Abeldaunak shiig anentus jukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Untsu Caígnak shiig anenjachui, tuja nii anentag susamunashkam shiig anentsag jujukchauwai. Dutikam Caín senchi kajekui, nunik kajekbautak wekagu. ");
INSERT INTO agr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Nunittaman Apajuí chichajak: “¿Wagka imanika kajekmesh wekaeme? ");
INSERT INTO agr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Amesh pegkeg takakmek, shiig aneasam wekaemainaitme, amek nuniatsum duwi amina tudaujum wagagtamkittak awagtamui. Tujash amek tudauwa duka depetmainaitme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Makichik tsawantai Caín yachin chichajak: “Ajanum wemi” tusa yachin juki weuwai. Nunik atushat akanak yachi Abelan mauwai. ");
INSERT INTO agr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Dutika yachin maamtai, Apajuí Caígkan chichajak: “¿Dusha amina yatsum Abelash wajukame?” tusa tama, Caín ayaak: “Achah, wikaitag mina yatsuju kuitamnun”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Tutai Apajuí chichajak: “¿Wagka yatsumesh aikaume? Ame yatsum maakum numpe nugkanum ukagbauwa nunú mina untsujui, suwimak susata tusa. ");
INSERT INTO agr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nuadui amek shiig pegkegchaunum juwaktatme, juju nugka yatsumi numpe ukagbaun uwaja nunú nugkanmak amek pujuschattame. ");
INSERT INTO agr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ajakak ajattame, tujash tsapaishtatui. Emetnaja pujamugmek atsugtamtinai, ayatak wainkam tikich nugkanum wekaetinaitme, imaniakmesh ame pujusa ayamainuk igkugchatnaitme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Tusa tama Caín Apajuín ayaak: “Mina suwimkajuk shiig katsunmainchawap atatua. ");
INSERT INTO agr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Yamaik juju nugkanmak ajapjame, nuadui wi amijai pujamunak idaikun, tikich nugkanum machikish ayamtsuk wainkan wekaetatjai, nuni wekagai mina yaki igkunkat nunú minak mantuatin ati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tutai Apajuí chichajak: “Aents amina mantamuk, sieteya imania suwimkan jukiagtinai”, tiuwai. Nuna tusa Apajuí Caígka iyashin maam amainchau apujtus akupkauwai. ");
INSERT INTO agr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Dutikam nii pujusa Apajuíjai chichasbaunak ukuak Nod nugkanum wee pujusui. Nod nugkak Edégnum wajasa diismak etsa minitaiya nuni aajakui. ");
INSERT INTO agr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caígka nuwe ejapjuk aishmagkun uchigmakui, dutika Enoc adaikauwai. Dutikamtai Caín nuwi yaaktan najana niina uchiji daajin Enoc adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Tuja Enoc akiauwai Irad. Irad akiauwai Mehujael, Mehujael akiauwai Metusael, Metusael akiauwai Lámec. ");
INSERT INTO agr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lámec jimag nuwan: Adá daagtinun, Silá daagtinjai nuwatkauwai. ");
INSERT INTO agr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adá uchigmakui Jabalan. Tuja Jabal wegantu aidauk aakchinum batsamin, tagkun kuitamin aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabala yachi aajakui Jubal. Nuna uchiji wegantu aidauk arpan awatin, pigkui umpuin aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Siláshkam uchigmakui Tubal-caín. Nigka jiju bronce, hierro aina nuna najanajaku aidaun apaji aajakui. Tubal-caígka umayi aajakui Naamá. ");
INSERT INTO agr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lámec niina nuwe aidaun chichajak: “Mina duwag aidauwah, antuktajum: Makichik aents mantuatag tusa ijutkui wi maamjai. ");
INSERT INTO agr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Caígka mauk sieteya imania suwimka jukitnai tibauwai. Tuja mina mantauk setenta y sieteya imania suwimkanak jukitnai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adánka nuwe ataktu ejapjuk uchi aishmagkun uchigmakui, dutika adaikauwai Set. Nunak: “Mina uchig Abelan Caín mauwa duwi minak juna Apajuí sujuse”, taku tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Setchakam makichik uchin akia adaikauwai Enós. Duwi nagkamas aents aidauk Apajuín emematuinak niina daajin adaitus segajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Juju ainawai Adán wegantu aidaun daaji agatkamua duka. Apajuí yama nagkamas aentsun najankug niina niimejai betekmamtinun najanauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Aishmagkun nuwajai najanauwai. Dutika yama najanbauwaik shiig yumi yumigkis juna daajig aents ainawai, tuu adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Dutikam Adán ciento treinta mijan ejeyi pujus akiauwai Set, niijai betekmamtinun. ");
INSERT INTO agr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Nuna akia pujusui ochocientos mijan, tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ashí ijumjamak novecientos treinta mijan pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set ciento cinco mijan ejeyi pujus uchiji aishmagkun Enósan akiauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Nuna akia pujusui ochocientos siete mijan, tuja nuigtushkam uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ashí ijumjamak, novecientos doce mijan pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enós noventa mijan ejeyi pujus uchiji aishmagkun Cainágkan akiauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Nuna akia pujusui ochocientos quince mijan, tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ashí ijumjamak, novecientos cinco mijan pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainán setenta mijan ejeyi pujus uchiji aishmagkun Mahalaleelan akiauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Nuna akia pujusui ochocientos cuarenta mijan, tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ashí ijumjamak novecientos diez mijan ejeyi pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel sesenta y cinco mijan ejeyi pujus uchiji aishmagkun Jéredtan akiauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Nuna akia pujusui ochocientos treinta mijan, tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ashí ijumjamak ochocientos noventa y cinco mijan ejeyi pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jéredtak ciento sesenta y dos mijan ejeyi pujus uchiji aishmagkun Enokan akiauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Nuna akia pujusui ochocientos mijan, tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ashí ijumjamak novecientos sesenta y dos mijan ejeyi pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoc sesenta y cinco mijan ejeyi pujus uchiji aishmagkun Matusalégkan akiauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Nuna akia pujus Enoc trescientos mijan Apajuí wakegamun takajak pujusui. Tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ashí ijumjamak trescientos sesenta y cinco mijan pujusui. ");
INSERT INTO agr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enokak Apajuí wakegamun takak pujau, makichik tsawantai ayatak megkaekauwai. Apajuí niinak jukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalén ciento ochenta y siete mijan ejeyi pujus uchiji aishmagkun Lámekan akiauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Nuna akia pujusui setecientos ochenta y dos mijan, tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ashí ijumjamak novecientos sesenta y nueve mijan ejeyi pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lámec ciento ochenta y dos mijan ejeyi pujus makichik uchiji aishmagkun akiauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Dutika adaikauwai Noé. Nunak: “Apajuí nugkan pegkegchaunum yumigjau asamtai, shiig senchi takainaku waituinag nunak, juju uchi ayamtijamjattawai”, taku tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noé akiinamtai nuigtushkam Lámec pujusui quinientos noventa y cinco mijan. Tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ashí ijumjamak setecientos setenta y siete mijan ejeyi pujus, jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noék niina uchiji: Sem, Cam Jafet aatus aajaku aina nunak quinientos mijanan ejeyi pujus akigkui. ");
INSERT INTO agr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Aents ashí nugkanum kuashat kaweagtai, nawanji aidaushkam akiinkauwai. ");
INSERT INTO agr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Nunú nuwa shigmauch aidaun, Apajuín uchiji aidau nuna diisag etegkeg dita wakejamun nuwatkaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Nuniagtai Apajuí chichaak: “Aentsuk ayatak tudauk asag yamai nagkamsag tuke pujuschatin ainawai, ayatak ciento veinte mijan pujusa jagtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tuja Apajuí uchiji aidau, aentsu nawanji aidaun nuwatuk uchi akiamu aidau gigante senchi maanin wajasu aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Aents aidau nugkanum batsamas senchi tunamainak, ima pegkegchaunak anentaimtus yujajuidaun Apajuí wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Imaniagtai Apajuí wake besemag anentaimak, najanmainchaunas najanawabiagtaih, tusa awake anentaimjauwai. ");
INSERT INTO agr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Nuna tusa Apajuí chichaak: “Ashí aents aidaun wi najanawaitag nunak, aentsnum nagkamsan, kuntinnash, tuja japiinas yujau aina nunash, chigkinash ashí betekmasan ijinatjai. Najanmainchaunas najanawabiagtai, tusan awake anentaimjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tujash Apajuík Noénak ima nigki puyatjusa umigbau asa, shiig anenjauwai. ");
INSERT INTO agr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Jujuwai Noé pachisa augmattsamu. Noé aajakui aents shiig pegkeg, ima Apajuí wakejamunak takajaku, tuja tikich aents batsamajakua nujai ijumjamash niig dekas pegkejam aajakui. ");
INSERT INTO agr_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé akiauwai kampatum uchiji aishmagkun, duka: Sem, Cam, Jafet aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tujash nugkanmak Apajuí diismak ayatak tudauk, pegkegchau takat aina duke piyak aajakui. ");
INSERT INTO agr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ashí aents aidauk ayatak pegkegchaunak taka batsatun Apajuí wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Nunik Apajuí Noén chichajak: “Yamaik ashí nugkanum aents batsata nunak ijinatasan anentaimtugjai. Ditá pegkegchaujin kuashat maaniamu ayawai. Duwi ditanak ashí tikich nugkanum ayá nujai ijinattajai. ");
INSERT INTO agr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Nuadui numi puwagtin aina nunú dakajam arca najanata, dutikam tesaka umikta. Tuja nuigtushkam yumi wayawai arca tuntupe, tuja initkenishkam ashí pegkaejata. ");
INSERT INTO agr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Arca najankumek jujai betek dekapam najanata: Esanti ciento treinta y cinco dekapamu atatui, untsu wegkanti veintidos dekapamu nuigtu jimaituk atatui, antsag yakintig trece dekapamu nuigtu jimaituk atatui. ");
INSERT INTO agr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tuja kampatuma imajin ekenim najanata. Untsu arcan jeega nuna nugkaan jimaituk dekapam makichik niimtai ujaittame, aikasmek nuna yantamen makichik waiti ujaita. ");
INSERT INTO agr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Wi yumin yutumtijattajai, dutika ai nunú ashí nugkanum piyagtatui, nuniak nugkanum pujutji ajamu batsataina nunak ashí ijinattawai. ");
INSERT INTO agr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tujash amejaig chichaman umiktatjai. Tuja amek, amina nuwem, uchijum aidau, uchigmi nuwe aidau, aatsajum arcanmak chimpimattagme. ");
INSERT INTO agr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Tuja kuntin ashí nugkanmaya aidau, aishmag nuwajai arcanum chimpiattame, ditashkam jinutsuk amejai betek uwemkatnume. ");
INSERT INTO agr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ashí chigki wegantu aina duka, kuntin tagkumtai wegantu aina dushakam, japiinas yujau aina nujai, jima jimagchik apatdayas amejai arcanum chimpimattawai. Ame uwemtai ditashkam uwemjatnume. ");
INSERT INTO agr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Nuigtushkam ashí yutai aidau juukam ijumjata, nuna kuntinush yuwatnume, tuja atumshakam nuwiyag yuwattagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Tusa tima Noé Apajuí tibaunak imatiksag umikui. ");
INSERT INTO agr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Apajuí Noén chichajak: “Ashí tikich aents aidaujai diismash, amek ima wi wakegamua duke umiakum pujame. Nuadui ame amina pataim uchijum aidaujai arcanum egkematajum. ");
INSERT INTO agr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Nuniakjum kuntin pegkeg aina nunú siete aishmag, siete nuwa aajam yajuakam chimpiata, untsu kuntin yuchatai aina duka makichik aishmag, makichik nuwa aajam egkeattame. ");
INSERT INTO agr_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nuigtushkam chigki wegantu aina dushakam jinaa megkaejai siete aishmag, siete nuwa aaja yajuakam chimpiata. ");
INSERT INTO agr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Siete tsawan asan yumin yutumtijattajai. Duka cuarenta tsawan, nuigtu cuarenta kashi yutugtatui. Wi najankamu aidau nugká batsata nunak ashí ijinattajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Tusa tima Apajuí tibaunak imatiksag Noé umikui. ");
INSERT INTO agr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Yumi ashí nugka utuja piyajua nunak Noénak seiscientos mijanji ajai nunikui. ");
INSERT INTO agr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tsawan yumi yutugtin jegamtai, nujagken uwemtugtasag Noé, niina nuwe, uchiji aidau, uchiji nuwe aidau aatus arcanum chimpimauwai. ");
INSERT INTO agr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Nunitai kuntin pegkeg aidaush, kuntin yuchatai aidaujai, tuja chigki aidaushkam, nugká japiinas yujau aidaujai, ");
INSERT INTO agr_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Noé egkemamtai ditashkam nunisag Apajuí tibaunak imanisag jima jimagchik arcanum aishmag nuwajai chimpimauwai. ");
INSERT INTO agr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Arcanum chimpima siete tsawan wegai, nagkamdauwai yumi yutug dujajua nugkanum pimutan. ");
INSERT INTO agr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noé seiscientos mijan ejeyu ai, jimag nantu taka, diesisiete tsawan wegai, yumi nagkamna nayaimpinmaya senchi yutau. Imaniai, initkanmaya yumi piyag teenak aushkam, ashí nugkanum pukuni shiig múun jiinjajui. ");
INSERT INTO agr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Nunik cuarenta tsawan, nuigtu cuarenta kashi tuke yutuu au. ");
INSERT INTO agr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Nunú tsawantinig Noé niina uchiji Sem, Cam, Jafet aatus aajakua nujai, tuja niina nuwe, nuigtu kampatum niina uchiji nuwe aidau aatus arcanum egkemawajui. ");
INSERT INTO agr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Nuigtushkam kuntin tagkumtai aidau, kuntin tagkumchatai aidau, japiinas yujau aidau, chigki wegantu aidau aatus ditajai betek chimpimauwai. ");
INSERT INTO agr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Tuja Noé arcanum egkemtai, ashí kuntin aina duka ditashkam jimag apa apatdayas chimpimauwai. ");
INSERT INTO agr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ashí kuntin aidauk aishmag nuwajai apatdayas chimpimamtai, Apajuí Noén dutikata tusa tibaunak imatiksag umikui. Nunik ashí chimpimamtai Apajuí arca waitijin epeniuwai. ");
INSERT INTO agr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Nunikmatai, yumi nagkamna cuarenta tsawan, cuarenta kashi mijamtsuk tuke yutuu au. Imaniau asa nujag dujajua nugkanum pimak, arca kukag tepaun inanmiuwai. ");
INSERT INTO agr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Nujagkek neetsuk ayatak dujaju au. Imanik dujajak arcanak aan yakí takuiniuwai. ");
INSERT INTO agr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Imanik dujajiu asa, ashí nugkanum muja tsakaku aidaunak yutua emegkakui. ");
INSERT INTO agr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ashí yutua emegkak, nuigtushkam sieteya imajin yakintin ewagak piyajui. ");
INSERT INTO agr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Imaniku asamtai aents nugkanum batsatuk ashí jinawajui, tuja chigki wegantu, kuntin tagkumtai wegantu, kuntin tagkumchatai aidaushkam, kuntin japiinas yujau aidaujaí ashí jinauwai. ");
INSERT INTO agr_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Pujutji ajamu aidau nugkanum batsatuk ashí jinauwai. ");
INSERT INTO agr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ima Noék, tikich niijai arcanum chimpimau aina nujaig uwemjauwai. Untsu arcanum egkemachaju aina duka ashí jinauwai. Aents, kuntin tagkumtai wegantu, chigki wegantu aidaushkam, kuntin japiinas yujau aina nujai ashí jinauwai. ");
INSERT INTO agr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Nujagkek ashí nugkanum piyag kuyutsuk ciento cincuenta tsawan asauwai. ");
INSERT INTO agr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Imanik tsawan atai, Apajuí Noén ashí kuntin niijai arcanum chimpijaidaujai wait anenjauwai. Nuadui Apajuí abau kuyuati tusa dasen nugká ajunjauwai, dutikam nunú umpuam kuyutan nagkamdauwai. ");
INSERT INTO agr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tuja nugkanum waa múun ujanjamtai, yumi initkanmaya jiinaidaushkam ashí epennajui. Antsag nayaimpinmaya yumi senchi yutaushkam ashí mijaakui. ");
INSERT INTO agr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Nunikmatai duwi diipas kuyutan nagkamdauwai. Nunik ciento cincuenta tsawan ejegak nuni senchi kuyuau. ");
INSERT INTO agr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Nunik siete nantu taka nuigtu diecisiete tsawan wegai, muja Araratnum arca patamiuwai. ");
INSERT INTO agr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tuja nujagkek tuke kuyu aig, diez nantu taka nuigtu makichik tsawan tsawaju ai, muja shiig múun aidaun titiji wantinjauwai. ");
INSERT INTO agr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Tuja cuarenta tsawan nagkaemai, arcanum egkemsa niimtain Noé ujainiuwai. ");
INSERT INTO agr_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Dutika cuervon juki akupkauwai, tujash ekemainji atsau asamtai, kuyuati tusa dakak ayatak nanaak wainak wekagu. ");
INSERT INTO agr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nuna dutika duwi pujus, kuyua buku weatsuash tusa dekatatus makichik pauman akupkauwai. ");
INSERT INTO agr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tujash nugkak eke buku wantinchau asamtai, paumak nii ekemsa ayamainjin wainkachu asa wakitki arcanum tauwai. Nunikmatai Noé uwejen awentun pauman juki arcanum awayauwai. ");
INSERT INTO agr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Dutika ataktu siete tsawan dakasui, nunik awentsag pauman akupkauwai. ");
INSERT INTO agr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Dutikamu etsa akagai, olivo dukeen tsujig apas tauwai. Nunikmatai Noé anentaimas, dekas nugkak bukuap weawa tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tuja nuigtushkam siete tsawan dakasui, nunik awentsag pauman akupkauwai; tujash paumak ataktu wakitkig tachui. ");
INSERT INTO agr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Tuja nujag kuyua buku wajasua nunak Noék mijanjinak seiscientos ejeyi nuigtu makichik mijanan achiku ai nunikui. Mijan nagkamnamu yama nagkamchak nantu taka makichik tsawan tsawaju ai, Noé arca jeen chigkainiuwai. Dutika diikma kuyua nugka buku wajasun wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tuja jimag nantua nuna achika veinti siete tsawan wegai, namakak shiig kuyua buku wajasui. ");
INSERT INTO agr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ashí kuyua buku wajasmatai Apajuí Noén chichajak: ");
INSERT INTO agr_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Arcanum ame, amina nuwem, uchijum aidau, uchigmin nuwe aidaujai chimpigjum nunú ashí jiinjatajum. ");
INSERT INTO agr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Tuja ashí kuntin: chigki aidau, kuntin tagkumtai aidau, kuntin japiinas yujau aidau amejai chimpija dushakam ashí jiigta. Dutikawamin ashí yantamnum shiyaktinme, nunik yujaktinme, nuniak ashí nugkanum piyaktinme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Tusa tima Noé jiinak niina nuwen, niina uchiji aidaun, tuja uchijin nuwe aidaun aatus ashí jiijui. ");
INSERT INTO agr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tuja ashí kuntin aidaushkam, tuja kuntin tagkumtai aidaush, tagkumchatai aidaujai, kuntin japiinas yujau aidaushkam, chigki aidaushkam ashí jiinjauwai. ");
INSERT INTO agr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noé arcanmaya jiinki kuntin patasa apeaku Apajuí ememattinun kaya ekenag najanauwai. Dutika kuntin aidaun, chigki aidaujai Apajuí diisam pegkeg aidaun yajuak nuna nejen ashí apeak Apajuín emematiuwai. ");
INSERT INTO agr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nunú Apajuín shiig awagmakui. Nuadui Apajuí chichaak: “Yamai nagkamsanuk aents aidaun tudaujinig nugkanak ataktuk pegkegchaunmak yumigjashtatjai, wagki aents aidauk yama datsameamuik pegkegchau takatnak anentaimtin ainawai. Tuja nuigtushkam ataktu awagkinuk yamai ijinag aikanuk pujutji ajamu aina nunak ijinashtinaitjai. ");
INSERT INTO agr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Juju nugka awa junisag aigkik, ajakma yutak tuke atinai, tuja nimpain, tsetsek, yumi tepeau, esat, tsawai, kashi aina duka ashí imanisag atinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Apajuí Noén niina uchiji aidaujai pegkegnum yumigkiak aatus tiuwai: “Yujaktajum, imaniakjum nugka pampankajum pimutkatajum. ");
INSERT INTO agr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ashí kuntin nugkanum batsamin aidauk atumin ishamjamainak kujaitin ainawai. Chigki wegantush, kuntin aidaush, nayantsanmaya aidaushkam atumnak ashí umigtamiagtinai. ");
INSERT INTO agr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Nuadui atumek ashí kuntin aidau, nuigtu dupa duke yujutai aina dushakam atum wakegamu yutinaitjume. Nunú aidaunak wi atumin ashí amaajime. ");
INSERT INTO agr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Untsu kuntin maa yuwakjumesh numpe yuwawaigpajum, wagki numpanum pujut au asamtai. ");
INSERT INTO agr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Aentsnak aishmagnash, tuja nuwanash wijai betekmamtinun najanauwaitjai. Nuadui makichik aentskesh tikich aentsun maunak niinashkam dutiksag maawagtinai, tuja kuntinkesh atumin mantamuk dushakam dutiksaik maam agtinai. ");
INSERT INTO agr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Tuja makichkikesh tikich aentsun maunak, niinashkam dutiksag maatin ainawai, wagki aentsuk wijai betekmamtin najanamu asamtai. ");
INSERT INTO agr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Tujash atumek uchi akigjum yujaktajum, nuniakjum ditajai ashí nugkanum piyaktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Tuja nuigtushkam Apajuí Noén niina uchiji aidaujai chichajak: ");
INSERT INTO agr_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Wi yamai atumjai chichaman umiktatag duka, atakea duish atumi uchijum wegantu agtina nujaishkam tuke asatnun umiktatjai. ");
INSERT INTO agr_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Nunak ashí kuntin atumjai arcanum chimpiju jiinjau aidau: Chigki wegantu, kuntin tagkumtai aidau, kuntin tagkumchatai aidau, ashí kuntin nugkanmaya aidaujaish umiajai. ");
INSERT INTO agr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Atumjai wi chichaman umikag duka makichkish yapajinashtinai, nuadui atak awagkinuk aentsnak, tuja kuntin aina nunashkam yumin yutumtijanuk ijinashtinaitjai. Atakea duish yumi yutujag nugkanmayanak ijinashtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Tusa Apajuí chichaak: “Jujuwai chicham tuke atinun, wi atumjai, tuja kuntin aidaujaishkam umikbau iwainamua nunú. ");
INSERT INTO agr_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Yujagminum apusajai arco iris, juju diisjum adeagtinaitjume wi chichaman nugkanmaya aidaujai umikag duka. ");
INSERT INTO agr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Wi nugkan yujagkim ematai, nuwi arco iris wantintinai. ");
INSERT INTO agr_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Nuna wainkun wi atumjai, tuja kuntin aidaujaishkam chichaman umikag nuna tuke aneetnaitjai. Nuadui ataktu awenag yumi yutug piyajag ijipachagtinai. ");
INSERT INTO agr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Nunú arco iris yujagminum wantinkui, wi waintinaitjai, nuniakun ashí aents aidaujai, tuja kuntin ashí nugkanum batsataina nujaishkam chicham tuke atinun umikag nuna tuke aneasnuke atinaitjai. ");
INSERT INTO agr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Chicham tuke atinun ashí aents aidaujai, tuja kuntin aidau nugkanum batsataina nujaishkam umikag, nunú iwainamuk arco irisa jujuwai”, tusa aatus Apajuí Noéjai chichasui. ");
INSERT INTO agr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noé uchiji arcanmaya jiinjau aina duka: Sem, Cam, Jafet aatus aajakui. Cam aajakui Canaágka apaji. ");
INSERT INTO agr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Juju kampatuma nunú aajaku ainawai Noé uchiji aidau. Juna uchiji wegantu aidau atak nagkamawag dita ashí nugkan pampantuk batsamsau ainawai. ");
INSERT INTO agr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé ataktu ajakmatan nagkama uva numijin ajakui. ");
INSERT INTO agr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Tuja makichik tsawantai, Noé uva yumiji najanamun vinon uwag nampekui. Nunik niina aakji ejapeen wisu iyan kanag tepesui. ");
INSERT INTO agr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Nunik wisu tepettaman, Cam Canaágka apaji aajakua nunú wainak ukuak, weuwai yachi jimag agá batsatun ujaktatus. Tusa ujakam, ");
INSERT INTO agr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem Jafetjai, nugkutaijin yakayin awagkek, apaji wisu tepaun wainkaig tusa, ukunmataik jegantag apajin dukukajui. ");
INSERT INTO agr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Dutika ukukim tepa tepakua nampekbaujin sakapag shintaag, niina uchiji ekeu Cam dutika ukukbaun dekauwai. ");
INSERT INTO agr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Nuna dekaa pegkegchaunum yumigkiak: “Canaágkak yachi jimaja nuna inake atinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Tusa nuigtu chichaak: “Semnak mina Apajuíjua nunú shiig anentinai. Dutikamu asa nii inatnai Canaágnak. ");
INSERT INTO agr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Apajuí Jafetan shiig kuashat nugkentin emati, dutikam nigka tajimtamea Sem aakmagbaunum pujú atatui. Untsu Canaán niina inake atinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Tuja yumi yutug aentsun ijinauwa duwi nagkamas Noé trescientos cincuenta mijan pujusui. ");
INSERT INTO agr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Aatus ashí ijumjamak novecientos cincuenta mijan pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noé uchiji, Sem, Cam, Jafet aina nunú, yumi yutug nugkanum piyag aentsun ijinauwa duwi pujus uchin akigkaju aina nuna daaji aidauk juju ainawai: ");
INSERT INTO agr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafeta uchiji aidauk: Gómer, Magog, Madai, Javán, Tubal, Mésec, Tirás, aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gómeran uchiji aidaushkam: Asquenaz, Rifat, Togarmá, aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javánka uchiji aidaushkam: Elisa, Tarsis, Quitim, Rodanim, aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Juu aajaku ainawai Jafeta uchiji wegantu aidau, juka maki makichik tikich chichaman chichaku aajakajui. Nunidau asag dita patayi aidaujaig etegdayag, nayantsa pakajin nugka muunnum, tuja ajuntainmashkam batsamsaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Cam aajakua nuna uchiji juju aajaku ainawai: Cus, Mizraim, Fut, Canaán aatus. ");
INSERT INTO agr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cus aajakua nuna uchiji aidaushkam: Sebá, Havilá, Sabta, Raamá, Sabteca aatus aajaku ainawai. Untsu Raamá uchiji aajakui Sebá, Dedán aatus. ");
INSERT INTO agr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cusak nuigtushkam uchijin Nimrotan akiauwai. Duka apu ashí nugkanum nigki wagaku aajakui. ");
INSERT INTO agr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimrotak Apajuí yayamu asa senchi kuntinu main aajakui. Nuwiya chicham jiinkiun chichainak: “Nimrod Apajuí yayasam, kuntinu main wajasu aajakua imanai”, tinu ainawai. ");
INSERT INTO agr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nii apu pujusmataig yaaktak juju aajaku ainawai: Babel, Erec, Acad, Calné aatus. Juju yaakat aina juka Sinar nugkanum aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nunú nugkanum pujau juwaki, Asiria nugkanum weuwai. Nunik jegaa nuwi yaaktan najankauwai. Nuna daaji aidauk: Nínive, Rehobot-ir, Quélah aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Nuigtushkam najanauwai yaakat dekas múun, Resen tutaya nuna. Duka yaakat Nínive Quélahjai niniaku aajakua nuna ejapeen aajakui. ");
INSERT INTO agr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Untsu Misraím aents wegantunmaya jiinjauwai: ludeo aidau, anameo aidau, lehabita aidau, naftuhíta aidau, ");
INSERT INTO agr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","patruseo aidau, casluhíta aidau, caftorita aidau. Untsu juwiya jiinjauwai filisteo aidau. ");
INSERT INTO agr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Untsu Canaán niina uchiji aishmagkun iwain Sidógkan akiauwai, duwi pujus Het aajakua nuna akiauwai. ");
INSERT INTO agr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Tuja Canaán wegantunmaya jiinjauwai: Jebús aents aidau, amorreo aidau, gergeseo aidau, ");
INSERT INTO agr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveo aidau, araceo aidau, sineo aidau, ");
INSERT INTO agr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeo aidau, semareo aidau, nuigtu amateo aidaushkam. Juju Canaán nugkanum aents aidau dita patayi aidaujai pampagkajui. ");
INSERT INTO agr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Cananeo aents aidaun nugkeg yaakat Sidón nagkamna nugka Guerar tutaya nuni juwaki, yaakat Gazanum nagkatkau aajakui. Tuja nuwi nagkamna yaakat Sodoma, Gomorra, Admá, Seboím aatus aajakua, nuni juwaki yaakat Lesa tutaya imanui nagkatkau aajakui. ");
INSERT INTO agr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Cam aajakua nuna uchiji wegantu aidauk juju ainawai. Ditak maki makichik nugkentin, nuigtushkam maki makichik chichamtin aajaku ainawai. Nuadui ditá patayi aidaujaig etegdayag batsamajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jafetan yachi iwai Sem aajakua dushakam uchijinak akigkui. Tuja Heber aajakua nuna uchiji aidauk Sem wegantu aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Seman uchiji aidauk: Elam, Asur, Arfaxad, Lud, Aram aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Araman uchiji aidauk: Us, Hul, Guéter, Mas aatus aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxad aajakui Sélah apaji, untsu Sélah aajakui Heberan apaji. ");
INSERT INTO agr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Heberak jimag uchijin akiauwai. Nuwiya makichik Péleg daagtin aajakui. Nunak nii pujusmatai, ashí aents aidau pampagkag maki makichik nugkentin wajasajua duwi tuu adaikau ainawai. Tuja niina yachig Joctán aajakui. ");
INSERT INTO agr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joctánkan uchiji aidauk: Almodad, Sélef, Hazar-Mavet, Jérah, ");
INSERT INTO agr_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diclá, ");
INSERT INTO agr_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sebá, ");
INSERT INTO agr_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havilá, Jobab aatus aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Dita batsamsamu aidauk nugka Mesá tawa nuwi nagkamnas Sefar nugka aajakua imanui nagkatkau aajakui. Duka etsa minitaiya nuni nugka múun aajakua nuwiya ainawai ");
INSERT INTO agr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Seman uchiji wegantu aidauk maki makichik nugkentin, maki makichik chichamtin aajaku ainawai. Nunidau asag ditá ditak patayi aidaujaig etegdayag batsamsaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Juju adaijag nunú ainawai Apajuí yumin yutumtikag aentsun ijinawa duwi batsamas Noé uchiji wegantu akigbau aina duka. Nuniayatak ditash kanakag tikich nugkanum pampagkag batsamsaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nunú tsawantin ashí aents batsamajaku aina duka makichik chichamnak chichajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Etsa minitaijiya nuni batsatu jiinag shima shimakua Sinar nugka pakajin wainkag nuwi batsamsajui. ");
INSERT INTO agr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Makichik tsawantai ditá ditak chichainak: “Ladrillo najanka jinum jiya inagkagmi”, tusag kayajai takamainnak idayinak ladrillon ekenag takainak, cemento pachimja takamain atsau asamtai, pegkae jukiag nujai achimtikag ekenag takaidau. ");
INSERT INTO agr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Dutikainak: “¡Kaunatajum yaakat najanawagmi, dutikaku kumpin jiika, nuwi eke ekenkawa nayaimpinum iwakmi! ¡Ibau umiku asaja, eme anentsa diitai atin amí! Tuja pampagka tikich nugkanmak shimutsuk juwig tuke batsamsatin agmi”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tujash Apajuí Tuke Pujuu nugkanum taa diikma aents aidau yaaktamawag, kumpin muuntan apujawag batsamtiagtatman wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Nunik anentaimas: “Ditak makichik wegantu ainawai, antsag chichamnash makichik chichaman chichaaku ainawai, nuadui juna nagkama ijuntujag takainawai, tuja juna idaimitkamainuk shiig atsawai, tusa, ");
INSERT INTO agr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","dekas akaetukmi, dutika ditá chichame pachimjukmi, dutika ajin pempeentunikiag antugdaimainchau wajastinme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Aatus tusa, Tuke Pujuu chichaman pachimjuk, ashí nugkanum dapampaak ishiakui. Dutikamu asag yaakat najantanak idaisaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nuadui nunú yaaktanak Babel adaikau ainawai. Wagki nunú nugkanum Tuke Pujuu aents aidaun chichaman pachimjuk dapampaak ashí nugkanum ishiaku asamtai. ");
INSERT INTO agr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Juju aajaku ainawai Sema uchiji wegantu aidau. Apajuí yumin yutumtikag aents aidaun ijinauwa nunú jimag mijan nagkaemai, Sem niina mijanjin cien ejeyi pujus akiauwai niina uchijin Arfaxad. ");
INSERT INTO agr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Nuna akia nuigtushkam quinientos mijan pujusui. Tuja nuigtushkam uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxad treinta y cinco mijanjin ejeyi pujus akiauwai Sélah. ");
INSERT INTO agr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nuna akia nuigtushkam cuatrocientos tres mijan pujusui. Tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sélah treinta mijanjin ejeyi pujus akiauwai Heber. ");
INSERT INTO agr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Nuna akia nuigtushkam cuatrocientos tres mijan pujusui. Tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Heber treinta y cuatro mijanjin ejeyi pujus akiauwai Péleg. ");
INSERT INTO agr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nuna akia nuigtushkam pujusui cuatrocientos treinta mijan. Tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Péleg treinta mijanjin ejeyi pujus akiauwai uchiji aishmagkun Reú. ");
INSERT INTO agr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Nuna akia nuigtushkam pujusui doscientos nueve mijan. Tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reú treinta y dos mijanjin ejeyi pujus akiauwai uchiji aishmagkun Serug. ");
INSERT INTO agr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Nuna akia nuigtushkam pujusui doscientos siete mijan. Tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug treinta mijanjin ejeyi pujus akiauwai uchiji aishmagkun Nacor. ");
INSERT INTO agr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nuna akia nuigtushkam pujusui doscientos mijan. Tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacor veintinueve mijanjin ejeyi pujus akiauwai uchiji aishmagkun Térah. ");
INSERT INTO agr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nuna akia nuigtushkam pujusui ciento diecinueve mijan. Tuja nuigtushkam tikich uchiji aishmag aidaun, nuwa aidaujai akigkui. ");
INSERT INTO agr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Térah uchiji aidauk: Abram, Nacor, Harán aatus aajakui. Junak sesenta mijanjin ejeyi pujus akigkui. ");
INSERT INTO agr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Juju aajaku ainawai Térah uchiji wegantu aidauk: Térah akiauwai Abram, Nacor, Harán aatus. Untsu Harán akiauwai Lotan. ");
INSERT INTO agr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harágkak Caldea nugkanum yaakat Ur tutai nii akiinamua nuwi pujus, apaji Térah eke iwaku pujaig niyá jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Untsu Abram Sarain nuwatkauwai. Tuja Nacor nuwenauwai Milcájai. Milcák Harágkan nawanji iwai, Iscá tawa nuna kai aajakui. ");
INSERT INTO agr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Untsu Saraik kaga asa uchigtuchu aajakui. ");
INSERT INTO agr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Térah caldeo aents aidau nugken yaakat Ur tutainum pujau ukuki Canaán nugkanum weuwai. Nuwi weak uchiji Abragkan, niina tijaji Lotjai ayauwai. Tuja nuigtushkam niina uchiji nuwen Sarain ayauwai. Tujash eke Canaán nugkanmak jegatsuk, yaakat Harán jegawag nuwi batsamsajui. ");
INSERT INTO agr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Nuwig batsamas Térah doscientos cinco mijanjin ejeyi pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Makichik tsawantai Apajuí Abragkan chichajak: “¡Amina nugkem, pataim aidau, apa jeshkam ukukta, nunikam wi ame pujustinun nugkan inaktustatjam nuwi wetá! ");
INSERT INTO agr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ame uchijum wegantu aidaunak wi shiig kuashat uyujkatnaitjai, dutika ai shiig kuashat agtinai. Wi aminak pegkegnum yumigsattagme, tuja nuigtush eme anentsa chichagtai atatme, nuadui aminiyan tikich aidaush pegkeg yumigkin jukiagtinai. ");
INSERT INTO agr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","¡Amina pegkegnum yumigtamaidaunak wishakam dutiksanuk pegkegnum yumigsagtinaitjai! ¡Untsu amina pegkegchaunum yumigtamunak wishakam dutiksanuk pegkegchaunum yumigjatnaitjai! Nuadui ashí nugka muunnumia aidaunash amina daagmin pegkegnum yumigsagtinaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Tusa tima nuna umiak Abragkak Harán pujau nuwi juwaki weuwai. Abram Canaán nugkanum weuwa nunak setenta y cinco mijanji ajujakui ");
INSERT INTO agr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Nunik weak niina nuwe Sarain, nuigtu niina yachi uchijin Lotan ayauwai. Nunik shimuinak ashí ditá wajiji aidaunak tagkuji aidaujai yajuakajui. Tuja aents inataiji aidau Harágnumia sumakbau aidaunashkam yajuakui. Nunik wea weakua Canaán nugkanum jegauwai. ");
INSERT INTO agr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Nunik jegaa, nuwi juwaki tikich nugkan amaka nagkagag wea weakua yaakat Siquemnum jegaa Moré tutainum numi encina ayaunum amamak, canaágnumia aents aidau batsatbaunmak niishkam nuwi pujusui. ");
INSERT INTO agr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nuwi pujaun Tuke Pujuu Abragkan wantintuk chichajak: “Amina uchijum wegantu aidaun juju nugkanak susagtinaitjai”, tiuwai. Tusa tima Abram Tuke Pujuu emematku kuntin maa patasa apeatnun kaya ekenag najanauwai, wagki nuwi Tuke Pujuu wantintukbau asa. ");
INSERT INTO agr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Nuwi juwaki muja tepaju yaakat Betel tutaya nuna yantamen etsa minitaijiya nuni shiyakajui. Nuwi jegaa niina aakjin aakmakui. Abram pujusua nuwi pujusa diyamak Betelak etsa akaetaijiya nuni aajakui, untsu yaakat Hai tawa nunú etsa jiintaijiya nuni aajakui. Tuja nuishkam kuntin maa patasa apeaku Apajuí ememattinun kaya ekenag ataktu najanauwai. Dutika Tuke Pujuu daajin adaitus untsuka segauwai. ");
INSERT INTO agr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Nunik nuwi pujau Néguev nugkanum wegak aakjin tegaja yajuak, diipas jintá kanag waja wajakua weuwai. ");
INSERT INTO agr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nunú tsawantin ashí nugkanum senchi yapajut tepeauwai. Nuadui Abram niina patayi aidaujai Egipto nugkanum pujustatus weuwai, wagki nii pujamunmag makichik yumainkesh shiig atsau asamtai. ");
INSERT INTO agr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Egipto nugkanum jegattak wesa, Abram niina nuwe Sarain chichajak: “Antukta nijah, amek nuwauch shigmauchitam nunak wika shiig dekajai, ");
INSERT INTO agr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","nuadui egiptunmaya aents waipakag chichainak: ‘Juka nuwak juna nuwegai’ tusag, mina mantuinak aminak jujamain ainawai. ");
INSERT INTO agr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Nuadui amina inimpainakuish, wait aneasam mina ubajui tujutta, amina shigmatjumin mina mantuawainum, wisha utugchat atsaunum jegatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Tusa Egipto nugkanum jegawagmatai, nuwiya aents aidau Sarai shigmauch wajaknun wainkajui. ");
INSERT INTO agr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Antsag faraógkan atuwe aidaushkam wainkajui, nunik nuwa shigmauch tae tusa faraógkan ujakagtatus wejiajui. Dutika ujakag nuadui Sarain jukiajui faraógka jeen. ");
INSERT INTO agr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sarai shigmauch asamtai, faraón wakejuk juwak Abragkan shiig awagmakui. Dutikak susauwai uwig aidaun, baka aidaun, burro aidaun, camello aidaunashkam, tuja nuigtushkam inak aishmag aidaun nuwa aidaujai susauwai. ");
INSERT INTO agr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tujash Sarai jukimunum Apajuí faraógkan ashí niina patayi aidaujai suwimkan suwak, jata ishamainun ajunjauwai. ");
INSERT INTO agr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Dutikam waitiak, faraón Abragkan untsuka itan chichajak: “¿Wagka minash jusha jutijuaume? ¿Wagka juju nuwa jusha mina duwajui tusamesh tujutchamume? ");
INSERT INTO agr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ame chichaakum mina ubajui tichamkum, tau asamin wi jukin nuwatmain awajkashjak. Jujuwai nuwemek, ¡Juju jukim wamak wetá!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Nuna aatus tusa faraón niina aentsji aidaun ishitkauwai, Abram nuwejai Egipto nugkanum puja duka, ashí niina wajiji aidaujai jiiki awematajum, weti tusa. ");
INSERT INTO agr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram niina nuwejai Egipto nugkanum pujau Néguev nugkanum wakitkiuwai. Nuwi weak ashí niina wajijinak yajuak weuwai. Nunik weak niina yachi uchijin Lotan ayauwai. ");
INSERT INTO agr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abragkak shiig wiakuch aajakui. Niinak ajujakui oro, jiju plata tutai najanamu aidau, tuja nuigtushkam niina tagkuji aidauk ¡shiig kuashat! ajujakui. ");
INSERT INTO agr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Néguev pujau wakitki diipas jintá kanag waja wajakua jegauwai yaakat Betelnum. Tuja nuwi juwaki yaunchuk nii pujujakbau yaakat Betelan nagkaiki, yaakat Hai tawa nuwi jegatsuk ejapeen aajakua nuwi weuwai. ");
INSERT INTO agr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Nunú nugkanum yaunchuk Abram Apajuín emematak kuntin maa patasa apeatnun altaran najanauwai. Nuwi Apajuí daajin adaitus segauwai. ");
INSERT INTO agr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Tuja Lotchakam antsag shiig wiakuch aajakui. Niina apaji yachi Abragjai betek ¡shiig kuashat! uwigji, bakajishkam imanisag, tuja niina inake aidaushkam ¡shiig kuashat! ajujakui. ");
INSERT INTO agr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nuadui nugka dita batsatbaunmag kuntin piyakui, nuniak yutaiji ayugmain atsau asamtai, nuwig ijunja pujumainchau aajakui. ");
INSERT INTO agr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Nuigtushkam aents Abragkan tagkujin kuitamin aidau, Lotan tagkujin kuitamin aidaujai maanijaku ainawai. Tuja canaágnumia aents aidaush, ferezeo aents aidaujai nuwig ditashkam batsamajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Nuadui makichik tsawantai, Abram Lotan chichajak: “¡Amek mina yatsujun uchijiyaitme, nuadui iik pempeentunikik kajegdaimaitsuji! Tuja amina tagkugmin kuitamin aidaush, mina tagkujun kuitamin aina nujaig kajegdaya yujamaitsui. ");
INSERT INTO agr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Juju nugka múun weaja nunú diisam ame wakegamu etegkam, wait aneasam kanakta. Ame tsumunum weakminig, wi nujinum wetajai. Untsu ame nujinum weakminig, wi tsumunum wetajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tusa tama Lot namak Jordágkan pakaji weajun diikma pegkeg yumi kuashat ayau, nugka piipich Sóar tutai aajakua imanui jegaku, nugka Edén pegkeg aajakua iman, nuigtush Egipto nugka pegkeg aajakua nujai betekmamtinun wainkauwai. (Juka iman aajakui Apajuí yaakat Sodoman Gomorrajai eke tsayatsaig) ");
INSERT INTO agr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Imanun Lot wainak ashí namak Jordágkan pakajinak nii etegkauwai. Dutikau asa dita batsatbaun ukuak etsa minitaijiya nuni weuwai. Aatus Abram Lotjai kanakajui. ");
INSERT INTO agr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abragkak Canaán nugkanum juwakui. Untsu Lot Jordágka pakajin yaakat Sodomanum jegattak pujusui. ");
INSERT INTO agr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Nunú yaakat sodomanmaya aentsuk shiig pegkegchau, Tuke Pujuu dakitamun ayatak katsek aina nuna takajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot weu ai, Apajuí Abragkan chichajak: “Ame anú wajam nuwi nagkamam nujiya aatu, tsumunma aatu, etsa minitaijiya aatu, tuja etsa akaetaiya aatushkam shiig diista. ");
INSERT INTO agr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Juju ashí nugka ame wainam junak wi amina amastatjai, juka aminu, tuja amina uchijum wegantu agtina nudau tuke atinai. ");
INSERT INTO agr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Amina uchijum wegantu aidaunak nugka yukukuntujai betek awajsattajai. Nugka yukukuntu dekapamainchawa iman amina uchijum wegantushkam dekapamainchau agtinai. ");
INSERT INTO agr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","¡Wajakim weme juju nugka juna esanti wegkantijai ashí diista, junak ashí amina amastatjame!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Tusa tima Abram aakjin tegaja yajuak makichik aents Mamre daagtindau ikam encinar tutai, yaakat Hebrógnum jegattak awa nuwi pujusui. Nuwi pujus kuntin maa apeaku Tuke Pujuu ememattinun altaran najanauwai. ");
INSERT INTO agr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nunú tsawantin Amrafel aajakui Sinar nugka apuji, untsu Arioc aajakui Elasar nugka apuji, tuja Quedorlaómer aajakui Elam nugka apuji, nuigtushkam Tidal aajakui Goím nugka apuji. ");
INSERT INTO agr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Nunú apu aidau: Bera Sodoman apuji, Birsa Gomorran apuji, Sinab Admán apuji, Seméber Seboíman apuji, Bela Sóar tuuta awagtaya nuna apuji aatus aajaku aina nujai maaniamun aepjuniawajui. ");
INSERT INTO agr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Makichik uwejan amua apu aina juju ashí dita suntaji aidaun nugka Sidiman pakajin nayants yapaku tutaiya nuwi ijumjajui. ");
INSERT INTO agr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Tuja doce mijanai, apu Quedorlaómer ditan depetuk pujuju. Tujash trece mijan wegai, makichik uweja amua apu aidau ataktu apu Quedorlaómerjai maanitan nagkamawajui. ");
INSERT INTO agr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Tikich mijanan achiak, apu Quedorlaómer niina suntajijai, nuigtu tikich kampatum apu niijai atunidau, nugka Astarot Carnaim tawa nuwi maaniawagtatus shiyakajui. Nuwi refaita aents aidaun depetuk amukajui. Tuja nuigtushkam zuzita aents yaakat Ham tutaya nuwiyan depetkau ainawai. Tuja nuigtushkam emita aents aidaun nugka paka Save-quiriataim tawa nuwi batsatun depetkau ainawai. ");
INSERT INTO agr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Untsu horeo aents aidaun muja Seírnum batsatun depetkau ainawai. Dutikawag pisagmatai pataetukag yaakat El-Parán tutai uwegshun ijus awa imanui wakajui. ");
INSERT INTO agr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Nuwiya apu Quedorlaómer nii ijunja yujamujijai waketak, yaakat En-mispat tutai Cades tuuta awagmatia nuwi jegawajui. Nunik nuwi juwakiag wenak Amalec aents aidau batsamtainian, amorreo aents aidau batsamtainian, tuja Hasesón-tamar tawa nuna batsamtaijinianashkam ashí dita wainbaunak tsaikajui. ");
INSERT INTO agr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Dutikiagtai Sodoma, Gomorra, Admá, Seboím, Bera Sóar tutaya nuwiya apu aidau ijunag chichaman umikag, Sidiman pakajin shiyakajui. ");
INSERT INTO agr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Nuwi makichik uwejan amua apu aina nunú apu Quedorlaómerjai Elam nugka apuji, Tidal Goím nugka apuji, Amrafel Sinar nugka apuji, Arioc Elasar nugka apuji aina nujai maaniau ainawai. ");
INSERT INTO agr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Dutika maaniamunum Sidima pakajin waa ayaunum nuwi pegkae pimasua weakunum Sodoman apuji Gomorran apujijai pisakma chimpimawajui. Nuniai tikich apu aidauk mujá pisajajui. ");
INSERT INTO agr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Nunikagmatai, ipak usumat apu depetmakaju aidau ditá suntaji aidaujai, Sodomanmayan, Gomorranmayajai yutaiji aidaun, wajiji aidaujai ashí yajutkag ukukiajui. ");
INSERT INTO agr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Nuninak Abragka yachi uchiji Lotnashkam Sodomanum pujuttaman achikag ashí wajijinak tagkujijai jukiag shiyakajui. ");
INSERT INTO agr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Lotan dutika jukiagmatai, makichik aents maaniamunum uwemjau Abragkan hebreo aentsua nuna jegajua ujakui. Abragkak Mamre nugke ikam encinas tutai, amorreo aentsu nugke aajakua nuwi pujujakui. Mamren yachi aidauk Escol, Aner aatus aajakui. Juju aidau Abraman atuidau. ");
INSERT INTO agr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram niina yachi uchijin achika jukiagbaun dekaa, ashí niina inake niijai yujas akiidau kajittsa anentai aidaun ipaa, trescientos dieciocho aentsun ijumjauwai. Dutika ditajai atuegak apu aidaun pataetuk yaakat Dan tawa nuwi jegawajui. ");
INSERT INTO agr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Nunikag kashi pachiachbau Abram niina aentsjijai jetekag ipisig yaakat Hobá tutai yaakat Damasco nujiin awa nuwi ejegawajui. ");
INSERT INTO agr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Dutikainak ashí waji yajuakbaujinak awagtujajui. Aatus Abram Lotan ayamjuk agkanmitkauwai, dutika ashí niina wajiji aidaunak imatiksag awagtujui. Dutikak nuwa aidaunashkam ayamjukui. Tuja aikasag niina aentsji tikich aidaunashkam ayamjukui. ");
INSERT INTO agr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram apu Quedorlaómeran tikich apu aidaujai ashí depetuk waketak, nugka paka Save tutai apu nugke tuuta awagmatia nuwi minittaman igkug kumpamatatus Sodomanmaya apu, jiintukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Dutika igkug juki inimtatman Melquisedec yaakat Saleman apuji, sacerdote niig Apajuí nayaimpinum pujuuwa nunú etegkamu pujau pagkan vinojai juki, ");
INSERT INTO agr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Abragkan igkug pegkegnum yumigkiak aatus tiuwai: “Abragkah, Apajuí nayaimpinum pujuuwa nunú pegkegnum yumigtamsatin ati. ");
INSERT INTO agr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Apajuí nayaimpinum pujuuwa nunú amina shiwajumin depetmitkagmaka nunú tuke ememattai ati”, tiuwai. Tusa tima Abram maania depetmak maki makichik waji yajuakbaunmayan diezmon susauwai. ");
INSERT INTO agr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Dutikamtai Sodomanmaya apu Abragkan chichajak: “Aents aina anka mina sujusta, untsu waji aina duka ame jukita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Tusa tama Abram niina ayaak: “Wika Tuke Pujuu yakí nayaimpinum pujuuwa nunú nayaimpin nugkajai najanauwa nuna wi dutikatnujun juni dutikattajai tusan ujakjai. ");
INSERT INTO agr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Tiu asan aminunak makichik hilonakesh, sapat jigkataichinakesh ashí amina wajijum wegantunak jukishtatjai. Atakea duikish ame mina chichagtakmek: ‘Wi Abragnak wiakchamtikawabiajai’, tusamek tujutchatnaitme. ");
INSERT INTO agr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Wika wajiinak shiig dakitajai, untsu mina inakeg aidau yutain yuwawaja duka maake, untsu mina uyuntuidau Aner, Escol, Mamre aatus yuja nunú ditanu amainun jukiagtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Nunú ashí nagkaemaju ai, Apajuí Abragkan wakanmantun wajantun chichajak: “¡Abragkah, ishamjukaipa, witjai amina kuitamnunuk! Amek shiig kuashat wajigtin atatme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Tusa tama Abram ayaak: “Apu Tuke Pujuuwah, ¿wisha nunash itugkatnunak ibaunash waketaja? Amek, mina uchig atsugta duka shiig dekame. Amek minak makichik uchikesh sujuschaume, nuadui ashí mina wajiig aidaunak, nugkajai nagkamas, wi tsakapagbau Eliezer Damasconmayaya nudau atinai” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tutai Tuke Pujuu ayaak: “Antukta nijah, juju ashí amina wajijum aina duka amina uchigminu atinai, tikich aents amina uchigmichuk jukishtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Nuna tusa Abragkan agá jiiki chichajak: “Yamai nayaim shiig diista, dutikam yaya ayá nunú ame dekapamainaitkumek dekapagta. Juju dekapamainkait, iman atinai amina uchijum wegantu aidauk”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Tusa tama Abragkak Tuke Pujuuwai kajinas anentaimu asa dekaskeap tujutua tiuwai. Nuadui Apajuí Abragnak aents ima pegkegnak takauwa iman diisui. ");
INSERT INTO agr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Tuja nuigtushkam chichajak: “Witjai Tuke Pujuunuk, wi aminak yaakat Urnum caldeo aents aidaujai pujaumin, juju nugkan ame wegantu agtina nudau tuke atinun amastasan jiikbaijame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tusa tama: “Tujash, Apu Tuke Pujuuwah ¿wisha wajuk shiijash dekamainaitja, wi wegantu aidauwap juju nugkanum batsamsatin ainawa tusanush?” tusa aatus Abram aikui. ");
INSERT INTO agr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Tusa tama nii ayaak: “Makichik baka tsakat, makichik cabra, makichik uwig aishmag, kampatum mijanji ajamu aidau, nuigtushkam makichik yampits, makichik paum tsakat aajam itagtuata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Tusa tima Abram ashí nuna yajuak Apajuín ejetuauwai, dutika jimai jimaituk dakaja igkumtikjattak batsakui, untsu chigkinak dakagchauwai. ");
INSERT INTO agr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Dutika pujai chuwag, kuntin dakaja batsasbaun kakeetiagtai, nuna yuwawai tusa Abram jiyaka ishimu. ");
INSERT INTO agr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Dutiká pujujai, etsa akaegak suwe wegau, nunitai Abram senchi kanag tepesui. Nuniaig shiig senchi suwe wajasmatai, senchi ishamkauwai. ");
INSERT INTO agr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Imanik suwe wajasbaunum Tuke Pujuu Abragkan chichajak: “Juju yamai shiig antukta, ame uchijum wegantu agtina duka nugken ukukiag, tikich nugkanum batsamas wainka inaku waitkam cuatrocientos mijan waitu batsamtin ainawai. ");
INSERT INTO agr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tujash tuu nugkanmayag nunash inakush waitkastin ainawa, nunak wi ditanashkam suwimkan susatnaitjai, duwi ame uchijum wegantu aidauk waitu batsatu agkanmagawag, shiig wiakuch wajasag jiinjagtinai. ");
INSERT INTO agr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Tuja untsu amek shiig muumpakim agkan pegkegnum jakattame. Nunikamin amina uchijum aidau ukugmasagtinai. ");
INSERT INTO agr_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tuja amina uchijum wegantu akiinak, nuna tijaji aidaush, nuigtush nuna tijaji aidaush akiinkatna nunú, juju nugka juwi waketug kaunatin ainawai. Wagki amorreo aents aidaushkam nunú tsawantinig tikima shiig katsekak achagtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Imanik suwe wajasu ai, ichinkanmaya jii bukuitau wantinkauwai, nunú wantinai shijikap ayai ekemakbauwa nunin kegak kuntin dakaja batsasbaunum ejapeena nagkaemattaman Abram wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Nunú tsawantai, Tuke Pujuu Abragjai chichaman umikui. Nunak aatus tiuwai: “Juju nugka junak amina uchijum wegantu aidaun susatnaitjai. Tuja namak Egipto nugkanum awa nuwi nagkamsan, namak múun Eufratesa aatsan susattajai. ");
INSERT INTO agr_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Tuja juju nugka juka quenita aents aidaun, quenizita aents aidaun, cadmoneo aents aidaun, ");
INSERT INTO agr_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","hitita aents aidaun, ferezeo aents aidaun, refaita aents aidaun, ");
INSERT INTO agr_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreo aents aidaun, cananeo aents aidaun, gergeseo aents aidaun, Jebús aents aidaun nugke ainawai. Tujash wi nunak ashí amastatjame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai kaga asa niina aishi Abragkan uchijin ejapjumainchau aajakui, untsu niina jeen inake Egipto nugkanmaya nuwa Agar daagtin pujujakui. ");
INSERT INTO agr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Nunik pujai Sarai Abraman chichajak: “Nijah, amek Apajuí mina uchigmachu ati tusa tujutiuwa duka shiig dekame. Nuadui wait aneasam mina inakeg Agar puja au jukita. Nunikamin nuwi uchi akiinamtai, wi nuna jukin uchijimachainjash”, tiuwai. Tusa tama Abram niina nuwe tabaun antujus, ayu, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Nunik pujus Sarai Agaran juki Abragkai sujukui. Nunak Canaán nugkanum jegawag diez mijan pujusua duwi dutikauwai. ");
INSERT INTO agr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram Agaran juki pujus ejapmitkakui, dutikam pujus, Sarai ejapjuchu asamtai, dushikiak chichaman umigchau. ");
INSERT INTO agr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Nunitai, Sarai Abragkan chichajak: “¡Mina inakeg Agar dushiktak chichaman umigtatsu duka utugchatak aminui! Wi amina nuwem ati tusan amasbaijame, dutikamaitak, yamai amina uchigmin ejapjuk mina nagkaetasu ememawai. Tujash ima Apajuíya duke tujamti, yakita juna utugchatan apujush wiyashitag, atsa ameashitam”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Tusa tama Abram ayaak: “Yamai nagkamsanuk amina inakminak amina idaitajame, ame itugkatag tame, dutikata”, tiuwai. Tusa tima Sarai Agaran shiig senchi inak waitkau, imatika waitkam Agar tupikakiuwai. ");
INSERT INTO agr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Nunik tupikaki Shur nugkanum wetainum uwegshunum jintá yumi pukuni jiinbaunum ayaumas pujuttaman, Apajuí ángela nunin wajas wantintukui. ");
INSERT INTO agr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Dutika iniak: “Agar Sarain inakegah, ¿amesh tuwiyamea miname? ¿Tuu weakmea aniame?” tau. Tama nii ayaak: “Sarain wi takagnaitag nunú dakitjugmatai tupikajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Tusa tutai, Apajuí ángel tumain chichajak: “Wakitkita amina takagtaigmin, nunika jegaam Saraiyai sumimkata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Nuna tusa nuigtushkam chichajak: “Amina uchijum wegantunash shiig kuashat ikauntuktinaitjame, dutika ai makichkish dekapamainchau atinai. ");
INSERT INTO agr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nijah, juju uchi ejapjukum nunú uchigmakam, adaikattame Ismael, wagki ame wekaesa waitiakum wake besemag anentaima wekaegam nuna wi antugkajam duwi. ");
INSERT INTO agr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tuja niig kakajus yunumtukchamin, caballo unuinakchamua iman atinai, iman asa ashí aentsjai maanitnai, nunitai niina shiwaaji aidauk ima niijaig maaniagtinai. Niina yachi aidaujaishkam shiwag atinai, nuniau asa ima niina nugkenig pujustinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Tusa tima, Apajuíjai chichasu asa, dekas amek “Apajuí wainbauwaitme” tusa puyatuk nigki anentaimas: “¡Apajuínap wainkaja, imanun wainkanush jakachjapi, iwaakjapi!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nuadui nuwi yumi piyag aajakua nuna “Iwaku pujuuwa nunú mina waita nunuwai” tuu adaikauwai. Nunú yumi piyajua duka yaakat Cades Béredjai niniaku awa nuna ejapeen awai. ");
INSERT INTO agr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agar tsawanji jegajim uchi aishmagkun Abragka uchijin uchigmakui, nunikmatai Abram uchi daajin Ismael adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Agar niina uchiji Ismaelan uchigmakua nunak Abragnak ochenta y siete mijan ajujakui. ");
INSERT INTO agr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abragkan noventa y nueve mijanji ajai, Tuke Pujuu wantintuk chichajak: “Antukta nijah, witjai Apajuí ashí senchigtinnuk. Nuadui amek mina emtijuig pegkegchau takamtsuk pujusta. ");
INSERT INTO agr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Wi amijai yamajam chichaman umiktatjai. Tuja amina uchijum wegantunak shiig kuashat ikaugkatnaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Tusa tama Abram Apajuín eme anentus tsuntsuma nijayin nugkan antig pujusmatai, Apajuí chichajak: ");
INSERT INTO agr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Jujuwai wi amejai chichaman umiag duka. Amek kuashat aents aidaun muunji atinaitme. ");
INSERT INTO agr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nuadui amek Abram tamak achattame. Tuja yamai nagkamsamek Abraham tama atatme, wagki wi aminak kuashat aents aidaun muunji awajsatnaitjame. ");
INSERT INTO agr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Amina uchijum wegantu aidaunak shiig kuashat ikaugkattajai. Nuadui ame wegantunmaya apu agtinai, tuja ame wegantu aidau kuashat aents nugka muunnum yujakagtinai. ");
INSERT INTO agr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nuadui wi amejai chichaman umikag duka ajumaya duish ame wegantu aidaujaish tuke atinai. Wika tuké amina Apajuíjum, tuja amina uchijum wegantu aidaunashkam Apajuíji atinaitjai. ");
INSERT INTO agr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Juju nugka Canaágka juwi ame pujam nunak ashí amina, nuigtu ame wegantu agtina nudaun tuke atinun amastatjai, tuja wi ditá Apajuíjig atinaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Tuja nuigtu Apajuí Abragkan chichajak: “Juna wi chichaman umikag duka imatiksamek umikta, tuja amina uchijum wegantu agtina dushakam umikagtin atinme. ");
INSERT INTO agr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Amejai chichaman umikag duka jujuwai: Ashí amina uchijum wegantu aidaush ima junak umikagtinai. Ashí aishmag aidau atumjai batsatuk tsupigkamu agtatui. ");
INSERT INTO agr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Tuja ashí atum aishmag aidautigminuk tsupimamainaitjume, nuni iwainmamkattagme wi atumjai chichaman umikag nunú. ");
INSERT INTO agr_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Yamai nagkamsagmek, ashí uchi aishmag aina duka ocho tsawan akiina wegauk katiuchiji chuchuke tsupigkattajume. Tuja amina wainka inataijum amina jemin akiinau aidaush, kuichik kayai tikich nugkanmaya sumakbaushkam tsupigkatajum. ");
INSERT INTO agr_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ashí uchi aishmag aidauk makichkish idaitsuk tsupigkamu agtatui. Wi chichaman umikag nunú iwainamu aatus atumi iyashin juwaktatui tuke atinun. ");
INSERT INTO agr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Tujash makichik aishmagkesh nuna tsupimatan dakitauk atumjai ijunjag pujumaitsui. Duka ayatak jiiki ajapeam atatui, wagki wi chicham umikbaun ajaantus diyachu asa”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Tuja nuigtushkam Apajuí Abrahaman chichajak: “Amina nuwemi daajig Sarai tamak achattawai, yamai nagkamsag niina daajig Sara atatui. ");
INSERT INTO agr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Niina pegkegnum yumigsattajai, dutikakun niyai makichik uchin amastatjai. Dekaskenum wi niinak pegkegnum yumigsattajai. Nuadui kuashat aents nugka múun aidaunmayan dukuji atinai. Tuja ame uchijum wegantushkam nugka múun aidaun apuji agtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Tusa tama Abraham tsuntsuma nijayin nugka antig pujus, niina anentainig chichas: “¿Aents cien mijanji ajamush uchinash akiimainashit? ¿Sarash noventa mijanji aja ibaush ejapjumainkait?” tusa dushiau. ");
INSERT INTO agr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Nuna tusa Abraham Apajuín chichajak: “¡Untsu utusamek Ismael kajimatjuttsuk ame pegkegnum yumigtugsam tajai!” tau. ");
INSERT INTO agr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tama Apajuí Abrahaman ayaak: “Amina nuwem Sara uchigmin uchigmaktatui tusan timagme, nunikmatai ame niina daaji Isaac adaikattame. Nunú akiinamtai wi amina anagkuajam duka uminkattawai. Tuja nii uchiji wegantu agtina nujaishkam wi chicham umikbauwa nunak tuké yapajiashtinaitjai. ");
INSERT INTO agr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ame mina Ismael pachisam tujutam nunashkam antugkajame, nuniku asan wi pegkegnum yumigsattajai. Niina uchijish kuashat atinai, tuja niina uchiji wegantunmayanash kuashat uyujkatnaitjai. Ismaelak doce apu agtina nuna apaji atinai. Aatus nugka muunnum batsamsatin ainawai. ");
INSERT INTO agr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Untsu wi chichaman umikag nunak amina nuwem Sara yamai nagkamas tikich mijan jegatta duwi Isaakan uchigmatjamkatta nujai umiktatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Nuna aatus Apajuí Abrahamjai chichas ashimak, wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Nunik Apajuí wakitkimtai, nunú tsawantinig Abraham niina uchiji Ismaelan juki, ashí niina inake niijai batsamas akiinau aidaunash, tuja kuichik kayai sumakbau aidaujai, ashí aishmag niina aakjin batsamin aidaunak betekmas yajuak tsupijauwai, Apajuí tibaun imatiksag umiak. ");
INSERT INTO agr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahamak noventa y nueve mijanji ajamu asa tsupimakui. ");
INSERT INTO agr_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Untsu Ismaelnak trece mijanji ajamun tsupigkauwai. ");
INSERT INTO agr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Aatus tsupimatai ati tibaun Abraham umiak, nunú tsawantaik niina uchiji Ismaeljai tsupimakajui. ");
INSERT INTO agr_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ashí aishmag niina aakjin akiinkau aidauk, tikich nugkanmaya kuichik kayai sumakbau aidaujaí, betekmasag tsupimajajui. ");
INSERT INTO agr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Makichik tsawantai Abraham Mamrenum ikam encinar tutainum niina aakji waitijin etsa tajiajai eketun Tuke Pujuu wantintukui. ");
INSERT INTO agr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham pagkas niimsatakama kampatum aents ijunun wainkauwai. Nunik wainmawaik wamak wejiuwai igkug jukitatus. Nunik jegantun tikishmag nijayin nugkan antig pujusa, ");
INSERT INTO agr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","chichajak: “Mina Apujuh, wi amina eme anentsan tajame, wait aneasam wamak wepa. ");
INSERT INTO agr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Atumnash shiig awajtamkuig, yumi itagtuatajum tusan dawemin dijajatjime, dutikamtai numi wakenti bikintua juwi pujusjum machik ayamjatajum. ");
INSERT INTO agr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Atumek dekas wi atumin inakmin pujag nuwi taugme. Nuniku asagmin atum yuwatnun wi amastajime. Nunú yuwajum ichichmamjajum wetajum”, tiuwai. Tama dita aínak: “Ayu, ame tame duke ati”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tusa tiagmatai Abraham niina aakjin waya nuwe Saran chichajak: “¡Harina pegkeg diisam veinte kilo jukim wamkesam pag najanata!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Tusa ukuak, tupikaki toro tsakat batsatun jegantun duwegman etegka, niina inake aidaun chichajak: “Juju maajum wamak inagtujuatajum”, tusa tima ditashkam imatiksag umikajui. ");
INSERT INTO agr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Dutikawagmatai Abraham baka muntsuji ijugbaun, kantekujai, neje inajuamun aatus juki ejeentun apujtusui. Dutikam nuna numi wakentin pujusag yuwagtai, dakak pujau. ");
INSERT INTO agr_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nuna yuwawag inagnakag Abrahaman iniinak: “¿Amina nuwem Sarash tuwi pujawa?” tama Abraham ayaak: “Au aaka awi pujawai” tau. ");
INSERT INTO agr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Tusa timatai nuwiya makichik chichaak: “Tikich mijan atata duwi ataktu tajuan ijagsattajame, tujash nunú tsawantinig amina nuwem Sara uchiji ajittawai”, tiuwai. Tusa tutai Sara aaknum Abrahaman ukujin waitinum wajasa, antu wajau. ");
INSERT INTO agr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Tuja Abrahamak Sarajaig shiig muumpakiaju ainawai, nuadui Sarak nantutin nuwauch jau aina nunash nagkankau aajakui. ");
INSERT INTO agr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Nunin asa dita chichainamun Sara antuk, nigki anentaimas dushiak: “¿Wi mina aishjujai shiig múuntuch wajasag nunash, wajuk mina aishjujaish wakejunikan pujusnuk uchigmaktaja?” tau. ");
INSERT INTO agr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tusa tabaun Tuke Pujuu antuk Abrahaman chichajak: “¿Wagka Sarash dushiawa? ¿Nigka dekaskeap tawa, tuja wi múuntuch ataish, Apajuíyap sujustatua tumainchauk dekapea? ");
INSERT INTO agr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Apajuí makichik waji tujinka dutiktsuk idaimainush awak? Tikich mijan atata duwi amina ijagsatasan ataktu tajuattajame. Nunú tsawantin Sara uchiji ajittawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Tusa tutai nuna Sara antuk senchi ishamkauwai, nuniak dekas tsanugtajai tusa chichaak: “Wika dushigchamjai”, tau. Tusa tutai Apajuí ayaak: “Wika dekajai ame dushiamunak”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Nuna tusag ijag aidau Sodomanum shimutai, Abrahamshakam ditan kumpama ishiaktatus uyuniuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nunitai Tuke Pujuu anentaimas: “Dekas wi dutikattag nuna pachisan Abrahaman ujaktajai, ");
INSERT INTO agr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","wagki niig dekas kuashat aents agtina nuna apaji atatui. Nuigtushkam wi niinak, aents ashí nugkanmaya aidaunmayash ima niinig pegkegnum yumigkiam atinme tusan anagkuawaitjai. ");
INSERT INTO agr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Wi niinak etegkauwaitjai, ashí niina uchiji wegantu aidaunash mina chichamjun jintintuati, dutikam minák umigtuktinme, nuninak ima pegkeja nunak takastinme tusan. Nuna aatus uminakui, wi anagkuawaitag nunak imatiksanuk umiktatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Nuna tusa Tuke Pujuu chichaak: “Aents yaakat Sodomanmaya, nuigtu Gomorranmaya aidauk ayatak pegkegchauk tikima shiig katsek ainawai tabaun antajai. ");
INSERT INTO agr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nuadui wi yamai wejitjai ditan, núnikan dekaatjai ditá pegkegchauji shiig múuntai tabau minai wajuta dusha dekaskeashit”, tau. ");
INSERT INTO agr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Tusa jimag aents Sodoman wejutai, Abraham Apajuíjai ukuunum juwakui. ");
INSERT INTO agr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Nunik Apajuín jegantun iniak: “¿Aents pegkegchaun takau aina nunú ijinkumesh, pegkejan takau aina nujai ijinattamek? ");
INSERT INTO agr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tuja namputchawame cincuenta aents pegkegchaun takaschau aidau yaaktanum batsatkuish, ¿nunú batsataigkik yaaktash tsaiktatam, atsa tsagkujashtatmek? ");
INSERT INTO agr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","¡Aents pegkegchaun takaschau aidauk, pegkegchau takasu aina nujai ijumjamek pegkegchaun takasua numamtukek ijinmaitsume! ¡Dekas wait aneasam dutikawaipa! Amek Apu chicham epegkin asam ashí nugkanmaya apu aina nuna Apujiyaitme, nuadui, ¿aents pegkegchaun takaschau aina duka ayamjukchattamek?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Tusa tama Tuke Pujuu Abrahaman ayaak: “Cincuenta aents pegkeg yaakat Sodomanum pujaun wainkanuk, dita tsagkujakun ashí tikich aidaunash tsagkujattajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Tusa timatai, ataktushkam Abraham Apajuín chichajak: “¡Wait aneasam tsagkugtugta! Amek Apajuíyaitme nuniaminig wika aents wainkauchitkun juna iniajame. ");
INSERT INTO agr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tujash namputchawame cuarenta y cinco aents pegkejam akuish, ¿ashí yaaktash tsaiktatmek?” tama Apajuí ayaak: “Atsa, cuarenta y cinco aents pegkejam akuishkam ijinashtatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Awentsag Abraham Apajuín iniak: “Namputchawame ¿ima cuarentak akuish itugkattame?” tau. Tusa tama Apajuí ayaak: “Atsa cuarenta pegkejam pujakuish tsaikchattajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Tujash Abraham ataktu awentsag iniak: “Apuh, wi kuashat iniimkuish, wait aneasam kajegtukaipa. Tujash ¿treinta aentskesh pegkeg akuish, itugkattame?” tau. Tama nii ayaak: “Treinta aents pegkeg yaaktanum pujakuishkam yaaktanak tsagkujattajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Tusa timatai nuigtushkam awentsag iniak: “Mina Apujuh, wika aents wainkauchitkun aajan iniajame. Tujash, ¿ayatak veinte aents pegkeg akuish itugkattame, tsaiktatmek?” tau. Tama nii ayaak: “Veinte aents pegkeg akuishkam, yaaktanak tsaikchattajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Tuja nuigtu iniak: “Mina apujuh, wait aneasam kajegtukaipa, yamaik inagnamun iniastatjame, nuigtu awagkin iniaknuk waitkaschattajame. ¿Tujash ayatak diez aents pegkeg akuish itugkattame?” tau. Tama nii ayaak: “Diez aents pegkeg akuishkam, yaaktanak tsaikchattajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Juna aatus Apajuí Abrahamjai chichas ukuak, weuwai. Nunikmatai Abrahamshakam niina aakjin wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Etsa akagai Apajuín aentsji nayaimpinmaya jimag yaakat Sodomanum jegawajui. Tuja Lotchakam yaakat tentea apakbaunum nuna waitijin, aents ijunajaku aina nuwi eketu. Nunik eketu niimsatakama jimag aents minidaun wainkauwai. Nunik wajaki wejiuwai igkugtatus. Nunik jegantun tsuntsuma nijayin nugkan antig pujusui. ");
INSERT INTO agr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Nunik chichaak: “Mina apug aidauwah, wika atumin inakegaitjai, nuadui wait aneasjum mina jegajui wayatajum, nunikagmin wi dawemin dijajatjime, dutikamtai mina jegajui kanagjum, kashin kashikmasjum wetajum” tau. Tama dita ayaak: “Atsah, nunikchattaji, juwi agá pujusa tsawagtatji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tusa tiagtaishkam: “Atsah, wait aneasjum tiigpa”, tusa imatjau niina jeen awayatatus. Tusa imatjam ayu tusag Lota jeen wayawajui. Nuwi wayawagmatai, Lot inamjamtai yutai pegkejan umikajui dita yuwatnun. Dutikak levadurajai pachimtsuk pag inajuamun yuwawajui. ");
INSERT INTO agr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Nuna yuwawag eke kajinatsaig, Sodomanmaya ashí aents aishmag aidau, datsa aidaunum nagkamas múuntuch ai aidaujai, jeganak tenteawajui. ");
INSERT INTO agr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Imanikag senchi pampaidau, imatuinak: “¿Tuwi batsatua aents amina jemin utsaanama dusha? ¡Wamak jiikta! ¡Dita aikatasa wakegaji!” wajaidau. ");
INSERT INTO agr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Tusa imatiagtai ditajai chichastatus Lot jiintuki, waitin shiig epeni tuntupek wajas, ");
INSERT INTO agr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ditan chichajak: “Mina kumpag aidauh, wait aneasjum atum anentaimjum duka dutikawaigpa, shiig pegkegchauwai. ");
INSERT INTO agr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Juwi mina nawantug jimag aentsun takashtai pujawai, auna jiigkitjime, dutikamtai atum wakegamu umiktajum. Tujash juju aents aidauk aikawaigpajum, wagki ditak wi ipaamu ainawai”, tau. ");
INSERT INTO agr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tusa tutai dita aínak: “¡Amek menasta! Ame iina apuji najaneamek juka aikawaigpa tusamek tikich nugkanmayayaitkumek tukagtumaitsume. ¡Yamaik, amina dita dutikmainaitag nuni senchi dutikattajame!” tusag Lotnak suwimaidau waitijin tegagkatag tusag. ");
INSERT INTO agr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Imatikiagtai jimag aents nayaimpinmaya Lota jeen waya pujau waitin ujainiag kuntujin etsaptiag Lotnak japiki waitin ujati awayak waitin epeniuwai. ");
INSERT INTO agr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Dutika agá ijununak ashí datsa aidaunum nagkamas múuntuch aidaujai wainmachu emakui, dutikawajam waitin wainkatatus egai egainakua yawekajui. ");
INSERT INTO agr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Nuna dutikawag, nunú ijag aidau Lotan chichajuinak: “¿Tikich pataim aidaush juwish ajutjamtsumek? Nuniakuig amina uchijum aidau, nawanjum aidau, nuigtu nawanjumin aishi atin aidaushkam, ashí aminu aidau juju yaaktanum atsuak duka ashí yajuakam atushat tupikakta. ");
INSERT INTO agr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Juju nugka juka tsaiktatji, juju yaaktanmaya aents aina juna pegkegchaujig shiig kuashtai, iman asamtai Tuke Pujuu awetamaji tsaiktajum tusa”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Tusa tima Lot niina nawanji aishi agtinun ujaktatus weuwai, nunik ditan chichajak: “¡Wamak nantagjum juju yaaktanum pujutsuk jiinjatajum, juju yaaktanak Apajuí tsaiktatui!” tau. Tusa tamaitak, wainkas tuu wekagatai tuidau asag antugkachaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Nuniaig tsawau asamtai, Apajuí aentsji ángel nayaimpinmaya aidau Lotan chichajak: “¡Wamkesam nantakim amina nuwem nuigtu jimag nawanjumea nujai jukita! Juju yaaktanmaya aidau suwimak suwaku tsayajin atumesh jakatag tachakjumek”, tau. ");
INSERT INTO agr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tusa tamaitak Lot emetnatai, ángel aidau, Tuke Pujuu niina wait anenjau asamtai, japikiag jiikiajui. Tuja nuwenashkam nawanji aidaujai jukiag jiikiajui, wagki yaaktan ukumtikiag uwemtijatag tau asag. ");
INSERT INTO agr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Dutikawag yaaktan ukumtikiag makichik ángel chichajak: “¡Wamak tupikakum uwemjata! Ukuujum diisaipa, tuja juju paka aina juigkik makichkish wajatash wajantaipa, ayatak mujanum wetá jakatasam wakegashkumek”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Tusa tama Lot chichaak: “¡Atsah, mina apug aidauwah, tikima nunak nunikchattajai, wait aneasam antugtukta! ");
INSERT INTO agr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Atum minak wait anenjugjum jakai tusajum jiigkiugme, tujash wika tikima mujanmak wemaitsujai, wagki nuni wekagai juju yaakat tsayamu minash amaintuk mantuawai tajai. ");
INSERT INTO agr_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Untsu tikijua juwi yaakat piipich awa atú tupikaumainaitjai. ¡Wait aneasam ayu tujutta, yaakat piipichia awi pujusan uwemjatjai!” tau. ");
INSERT INTO agr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Tusa tutai nuwiya makichik ángel ayaak: “Ame segatam nunak antugkajame duka imanisag uminkati. Nuadui au yaaktanak tsaikchattajai. ");
INSERT INTO agr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Tujash ¡wamak wetá! ¡Juwi pujutsuk ame tame nuwi wetá! Wagki ame eke jegatsminkik juju nugkanak tsaikchattajai”, tiuwai. Nuadui nunú yaaktan daajinak Sóar adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Tuja tsawak etsa puwau jiinai, Lot Sóarnum jegau ai, ");
INSERT INTO agr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tuke Pujuu nayaimpinmayan jii azufre tawa nujai pachimjamun yaakat Sodomanum Gomorranmashkam yutumtijauwai. ");
INSERT INTO agr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Dutika, ashí aents nunú yaaktanum batsataidaunak ijinauwai, nuigtushkam nugka paka weajunum batsatun ashí ajak aidaujai ijinauwai. ");
INSERT INTO agr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Untsu Lota nuweshkam niig wegayatak, ukujin ayampas diikma, wee najanea wajasui. ");
INSERT INTO agr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nuna Apajuí tsaiku ai kashikmas Abraham nii Tuke Pujuujai chichaaku wajasbaunum weuwai. ");
INSERT INTO agr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nunik nuwi jegan wajas Sodoman Gomorrajai diistakama ashí nugka paka aidauk yaakat aidaujai nagkamas ekemaka tsaikbau asa, senchi bukuiti jiinak yujagkim akijua atatman wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Aatus Apajuí yaakat nugka pakanum aajaku aina nuwi Lot pujujakua nunak ashí tsaikui. Tujash Apajuík Abrahamnak kajimatkichui. Nuadui niina yachi uchiji Lotan jiiki uwemtikjauwai. ");
INSERT INTO agr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot Sóarnum pujutan ishamak jiinki mai nawanjin juki mujá weuwai. Nunik nuwi waa pagkakunum kampatuma duka nunisag utsanawag batsamsauwai. ");
INSERT INTO agr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Nuwi pujus makichik tsawantai Lota nawanji emkau kai ekeun chichajak: “Iina apajig muumpakni, tuja tuke nunitai asamtai aishmag nuwan nuwatin aina dutika iina nuwatjamainuk juwig makichik aishmagkesh shiig atsawai. ");
INSERT INTO agr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Nuniau asamtai dekas iina apaji enamkami, dutika enamka niijai ankami. Nunika iina apaji uchiji jukimi”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Nuadui nunú kashia duik apajin vinon aajag enampek aepes, nawanji emkau iyanti niina apajijaig ankauwai. Tujash apajig nawanji tepesa nantaki wegaunakesh machikish dekapjachui. ");
INSERT INTO agr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nunik tsawag, kai emkau ekeun chichajak: “Wi yamai kashi iina apajijai ankamjai, tuja yamai kashia duwi ataktu enamkami, dutika ameshkam niijai ankata; aatsa mai iina apaji uchiji jukishpash”, tau. ");
INSERT INTO agr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tusag nunú kashia duwi ataktu enamkag aepes, nawanji ekeu iyanti niishkam niina apajijai anik ukukiuwai. Tujash Lotak nawanji tepes nantaki wegaunakesh machikish dekapjachui. ");
INSERT INTO agr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Nunik batsamas Lota nawanji mai ejapjukui, niina apajinunak. ");
INSERT INTO agr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Emkau uchigmakui uchi aishmagkun, dutika adaikauwai Moab. Nuwiya jiinjauwai Moab aents aina duka. ");
INSERT INTO agr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Tuja ekeushkam uchigmakui aishmagkun dutika adaikauwai Ben-amí. Nuwiya jiinjauwai Amón aents aina nunú. ");
INSERT INTO agr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham nii pujamun ukuak Néguev nugkanum weuwai. Nunik nuwi jegaa yaakat Cades, Shur nugkajai niinis awa nuwi ejapena yaakat Guerar tawa nuwi pujusui. ");
INSERT INTO agr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Nuwi jegaa pujus niina nuwen, juka mina ubajui, tiuwai. Timatai Abimelec Guerar nugkan Apuji niina aentsjin awemauwai, Sara utugtitajum wi nuwatkatjai tusa. ");
INSERT INTO agr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Tusa timatai itajuawajui, dutikawagmatai kanittaman kajanum Apajuí chichajak: “Anú nuwa jukium duka aishintin jukiume, nuadui amek jakattame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Tusa tama eke nuwajaig tsanigchau asa, chichaak: “Mina Apujuh, ¿eke wi nuwan dutikachu aigkik mantuatag tame? ");
INSERT INTO agr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham chichaak juka mina ubajui tujutmae, nuwashkam dutiksag mina ubajui timae, nuadui uyumat aneakas wika jukimjai, tujash pegkegchaunak dutikachjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Tutai Apajuí kajanmak ayaak: “Wika shiig dekajai ame pegkegchau dutikachum nunak. Nuadui ame nuwa antigkam mina emtijui tunamajaim tusan wika aminak idaitsugme. ");
INSERT INTO agr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tujash yamaik, anú nuwak awagkim aishi susata, wagki niig mina etsegtugkati tusa etegkamui. Nuniau asa amina pachipas mina segatti jatsuk pujusminum. Untsu awagtutsuk pujakmek duka dekas ashí aents amina jemin batsata nujai jinattagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Tusa Apajuí ujakam, kashikmas Abimelec nantaki niina inake aidaun untsuka ikaunman, niina kajanum tibaunak ashí ujakui. Nuna antukag senchi ishamkajui. ");
INSERT INTO agr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Nuna etsejuk Abrahaman untsuka itan chichajak: “¿Amesh wagka jutikagtame? ¿Wisha aminash wajinma pegkegchau awajkamu asamea mina jegajuish tudaush ibaush itagtuaume? Juka tikima jutikdaichatia”, tusa ");
INSERT INTO agr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","awentsag chichajak: “¿Waji anentaiyaiya jusha jutikagtame?” tau. ");
INSERT INTO agr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Tama Abraham ayaak: “Wika juiyag makichkish Apajuí nemagchaus ainawa timajai. Tau asan ishamkagtakun mina nuwajui tichamjai, wagki mina mantuinak duwajun jujutkinum tusan. ");
INSERT INTO agr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tujash auk dekas minak ubajui. Wagki niig mina apaju nawanji asa, tujash mina dukujuig akiinachui, nuadui wika nuwatkauwaitjai. ");
INSERT INTO agr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Apajuí chichagtak: ‘Amina apa jeen pujam duka jiinkim wetá’ tujutmatai, Saran chichagkun makichik yaaktanmakesh jegakuik mina ubajui tujutta tusan tiuwaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Tusa tutai, Abimelec Saran awagtuki susauwai. Dutikak nuigtushkam uwig aidaun, baka aidaun, aents wainka inatai aishmag aidaun, nuwa aidaujai susauwai. ");
INSERT INTO agr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Dutika chichajak: “Nijah, juju nugka juka ashí mina nugkajui. Tuwi ame ima shiig pujumain dekapeame, nunú etegkam nuwi pujusta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Nuna tusa Saranashkam chichajak: “Wi amina umaimin susag duka mil kuichik plata najanamu akikega imanun susajai. Nunuwai ii pegkegchau takaschamunum tikich aents aidaunmash ayamjumaktina duka. Tuja makichik aentskesh pegkegchaun chichagtamainuk atsutnai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Nuadui Abraham Abimelekan pachis Apajuín tsagkujata tusa segauwai. Tusa tima Apajuí Abimelekan etsagag, niina nuween, nuigtushkam niina inake nuwa aidau, nuwi batsatunak uchi uchigbau atinme tusa ashí etsagakui. ");
INSERT INTO agr_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Wagki Apajuí Sara jukimunum niina ayamjak, ashí nuwa Abimelekan jeen batsamin aidaunak uchin uchigmakchamin emaku asa, nunak etsagaak ataktu uchigbau emakui. ");
INSERT INTO agr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Apajuí Saran anagkuamunak imatiksag umikui. ");
INSERT INTO agr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Nuadui Sara ejapjukui. Nunik muumpatnum Abrahaman uchijin aishmagkun uchigmatkauwai. Uchik Apajuí chichaak nunú tsawantin akiinattawai tibaunak imanisag akiinauwai. ");
INSERT INTO agr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Nunikmatai Abraham uchiji daajin adaikauwai Isaac. ");
INSERT INTO agr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Nunú uchi akiina ocho tsawan ejematai, Apajuí tibaun umiak uchiji katiuchijin chuchuken tsupigkauwai. ");
INSERT INTO agr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abragnak cien mijan ajamu ai niina uchiji Isaac akiinauwai. ");
INSERT INTO agr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Nunikmatai Sara anentaimas: “Apajuí minak dushimtijuje shiig aneasti tusa, nuadui wi uchigmakbaun ashí aents aidau dekawajag shiig aneenak dushijagtin ainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Tuja nuigtushkam Sara anentaimas: “Makichik aentskesh minak Abrahamnap uchin uchigmatkattawa tusa tujutiuk atsawai. Tujash yamaik muumpatnum uchigmatkajai, niishkam múuntuch wajasu ai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaac muumpak muntsun tsujagkauwai. Nunikmatai Abraham yutain kuashat umika uchijin jiistamjuauwai. ");
INSERT INTO agr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Nuna imatikiagtai, Abragkan uchiji egiptunmaya nuwanum akiinauwa nunú Isaakan kajejak, pegkegchaun chichajun Sara antukui. ");
INSERT INTO agr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Nunik Abrahaman chichajak: “¡Juju nuwa inaka juka uchijijai jiiki awemata! wagki uchi inaknum akiinauwa duka mina uchijua jujai betekak amina wajijum aina nunak jumaitsui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Tusa tama Abraham senchi wake besemag anentaimsauwai, wagki dushakam niina uchiji asamtai. ");
INSERT INTO agr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tujash Apajuí niina chichajak: “Juju uchia nuig, tuja nuwa inaka anuishkam imanikmek anentaimsaipa. Sara tujama duke umikta, wagki amina uchijum Isaakai uchi akiinak weagtina nunú ame wegantuk agtinai. ");
INSERT INTO agr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tujash amina uchijum inaknum akiinauwa nuwiyanashkam amina uchijum asamtai, kuashat ikauntuka ai yaakat múun wajastinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Tusa tima Abraham tsawag kashikmas, pagkan juki nuigtu duwap apagbaunum yumin aimjuk Agaran susauwai. Agaran aentsek, uchiji Ismaelnashkam susa kumpama, awemauwai. Dutikam Agarchakam niina uchijijai uwejush Beersheba nugka jega atsamunum wainak wagaka wekagu. ");
INSERT INTO agr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Nuwi wekagas yumi jukimujin amuekamtai, uchijinak numi wakentin awayag aipkiuwai. ");
INSERT INTO agr_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Dutika aepeak, nigka tupaan ekemas anentaimas: Mina uchig jau waintanak dakitajai, tau. Nunik eketai uchijishkam buutu. ");
INSERT INTO agr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nunik uchi buutun Apajuí antugkauwai. Nunik Apajuí ángel tumain Agaran chichajak: “¿Wagka Agarah amesh aniame? Ishamkaipa, Apajuí uchi buutun antuke. ");
INSERT INTO agr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Nuadui wamak weme uchi jukim akuptsuk takusta, wagki anú uchia anuiyan wi kuashat aentsun uyujkatnaitjai, dutika ai shiig kuashat agtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Nuna tusa Apajuí Agaran yumi pukini jiinun iwaintukui. Dutikam Agarchakam yumi aimtai duwap apagbaun juwakug weji yumin aimak itanta, uchin aajui. ");
INSERT INTO agr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Aatus Apajuí uchinak yaigkui. Dutikamu asa tsakaja uwegshunum nugka Parán tutaya nuwi pujusui. Nunik nunú uwegshunum pujaun niina dukuji egiptunmaya nuwan egatuk nuweauwai. Tuja nigka shigki apunbaunum shigki etsakamu ekenka nagkimtain shiig yacha aajakui. ");
INSERT INTO agr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nunú tsawan aajakua duwi Abimelec niina suntaji aidaun apuji Ficol aajakua nujai uyunis Abrahamjai chichastatus weuwai. Nunik jegawag Abimelec Abrahaman chichajak: “Ame ashí takam nunak Apajuí yaimpa duka dekaji. ");
INSERT INTO agr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Nuadui, Apajuísh antugtamai minash tujutta. Juju nugka juwi mina uchig aidaush, ame uchijum wegantu aidaush wi amijai shiig awagdayag aiksamek shiig awajkatnujum pachisam tujutta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Tusa tama Abraham ayaak: “Ayu, Apajuísh shiig waitui, wika ame tujutam nunak imatiksanuk umiktatjai. ");
INSERT INTO agr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","“Dutikatin asamtai ame amina inakem aidau yumigmatan jukiu aina nunú awagtugkita”, tusa tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Tama Abimelec ayaak: “Achah, wika nunak makichkish dekatsjai, amek minak: Juka mina yumigmatjui, tusamkesh tujutchauwaitme. Wika yaki yumigmatnash jukiuwaita nunak yamaikish dekatsjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Timatai Abraham uwig aidaun, baka aidaujai juki Abimelekan susauwai. Dutika nunú tsawantinig mai chichaman umikajui. ");
INSERT INTO agr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Nuna umikag Abraham siete uwijan juki akanak awajsauwai. ");
INSERT INTO agr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Nuna dutikamtai Abimelec iniak: “¿Wagka jusha siete uwig akankam ijumjaum dusha aikaume?” tau. ");
INSERT INTO agr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Tama Abraham ayaak: “Juju siete uwijan amaajam nunú jukim dekattame wi juna yumigmatan tainiuwaitag duka”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Nuadui nunú dutikamunum nuna nugka daajin Bersheba adaikauwai, wagki nunú nugkanum chichaman umikaju asag. ");
INSERT INTO agr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Dutika chichaman bershebanum umikag, Abimelec Ficoljai filisteo aents aidaun nugken wakitkiajui. ");
INSERT INTO agr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Nunik wakitkiagmatai Abraham numi tamarisco tutain bershebanum ajauwai. Dutika nuwi Apajuí Tuke Pujuuwa nuna daajin adaitus emematiuwai. ");
INSERT INTO agr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Aatus nuwi filisteo aents aidaun nugken Abraham kuashat tsawan pujusui. ");
INSERT INTO agr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Kuashat tsawan asa, Apajuí Abrahaman niiyai kajinas anentaimak dekaskeapi tabaujin dekapsatatus niina daajin adaitus untsukui. Tusa untsuam nii ayaak: “Juwi pujajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Tutai Apajuí chichajak: “¡Amina uchijum makichkiuch asamtai, senchi aneam nunú jukim niijai Moria nugkanum wetá! Nuwi jegam wi mujan iwaintuktatjam nuwi uchijum maa apeakum mina emematjita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tusa tima tsawak shiig kashikmas nantaki, nii ekemi wetinun burronum patai umika ukuak, chigkimin jigka umik nunú burronum pataja jukiag Apajuí nuwi wetá tibaunum niina uchiji Isaakan juki, nuigtu jimag inaken juki weuwai. ");
INSERT INTO agr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Nunik we wenakua kampatuma juna tsawampag wesa diikma, atushat nii jegatnujin wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Dutika nuna wainak, Abraham niina inake aidaun chichajak: “Atumek juwi burro kuitamkujum juwaktajum. Nuniagmin wi mina uchigjai wetajai, núnikan niijai Apajuín emematin ukuakun taatjai, nunikmatai wakitkiagmi”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Nuna tusa Abraham chigkimin niina uchijin aentsek tuja ekemaktinun jii akaamun kuchiijai nii juki, niina uchijijai weuwai. ");
INSERT INTO agr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Nunik wesag, Isaac apajin iniak: “¡Apawah!” tiuwai. Tama nii ayaak: “¿Waji wakegame uchuchih?” tau. Tusa tama Isaac chichaak: “Jii juki, chigkimish umika wegaji. Tujash ¿tuwi pujawa uwig aishmag tsakat maa apeaku Apajuí ememattinush?” tau. ");
INSERT INTO agr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Tutai Abraham ayaak: “Apajuí uwig aishmag tsakatan sujamsattawai, nunú maa apeaku nigka ememattatji”, tiuwai. Aatus tusa uchijijai tsanias wegau. ");
INSERT INTO agr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Nunik Apajuí tibaunum jegantag, nuwi Abraham kaya ekenag najanauwai kuntin patasa apeaku Apajuí ememattinun. Dutika chigkimin patag nuadui niina uchiji Isaakan achika jigkag juki patainiuwai. ");
INSERT INTO agr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Dutika patai uchijin maatatus kuchiijin jutatman, ");
INSERT INTO agr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Apajuí ángel tumain nayaimpinum pujus untsuak: “¡Abraham! ¡Abraham!” Tama nii ayaak: “Juwi pujajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Tutai nii chichajak: “Uchigmek makichkish antigkaipa. Ame Apajuí ima senchi umijam nunak yamaik dekajuajame, wagki, amina uchijum makichkiuch aigkish, sujimtsuk mina sujustasam umiku asamin”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Tusa tima niimsatakama, uwig tsakat aishmag numi kanawen niina kachujin tutinak wajaun wainkauwai. Nunik uchijin maatag tabaun idayak, nuna weji achika juki maa nuna nejen ashí apeak Apajuín emematiuwai. ");
INSERT INTO agr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Nuna dutikau asa Abraham nunú nugka daajin: “Apajuík atsumamun sukagtawai” tuu adaikauwai. Nunú tibaunum yamayajuikish: “Apajuík mujanum atsumamun sukagtawai”, tinu ainawai. ");
INSERT INTO agr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Tuja awentsag Apajuí ángel tumain nayaimpinmaya Abrahaman untsuka, ");
INSERT INTO agr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","chichajak: “Tuke Pujuu chichaak juna timae: ‘Amek wi tabau umiakum amina uchijum makichkiuch aigkish sujitjukchau asamin, wiki wi chicham umiktinjun tumamjai’ tujamui. ");
INSERT INTO agr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Aminak dekas pegkegnum yumigsattajame: Ame uchijum wegantuk yaya nayaimpinum ayá iman, nuigtu kayam nayantsanum ayá iman agtinai. Ditak shiwaajinash tuke depetin agtinai. ");
INSERT INTO agr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Aents ashí nugkanmaya aidauk ame uchijum wegantu agtina nuna daajin pegkegnum yumigkiam agtinai, wagki ame wi tabau intimjuttsuk umiku asamin”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Tusa tima Abraham Isaakjai wakitkiuwai niina inake batsakbaunum. Nunik jegantag ditajai betek waketug bershebanum jegawajui. Nunik nuwi Abrahamak pujusui. ");
INSERT INTO agr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nuwi kuashat tsawan pujus, Abraham niina yachi Nacoran nuwe Milcá, niina aishinak kuashat uchin uchigmatkauwai tabaun dekauwai. ");
INSERT INTO agr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Iwaijig Us daagtinai, nuwi patatkauwai Buz, nuwi patatkauk Quemuel, tuja nunuwai Araman apaji. ");
INSERT INTO agr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Untsu Quemuelai patatkau aidauk Quésed, Hasó, Pildas, Idlaf, Betuel aatus ainawai. ");
INSERT INTO agr_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuelan nawanjiyai Rebeca. Juju ainawai Abrahaman yachi Nacor niina nuwe Milcáyai ocho uchin akiinkauwa nunú. ");
INSERT INTO agr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Tuja nuigtushkam niina ikaa nuwe Reumá aajakua nuwishkam akiauwai: Teba, Gáham, Tahas, Maacá, aatus, tusa tabaun dekauwai. ");
INSERT INTO agr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara cientoveintisiete mijan pujusui. ");
INSERT INTO agr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Nunik yaakat Quiriat-arbá, Hebrón tuuta awagmatia nuwi Canaán nugkanum pujus jakauwai. Nunikmatai Abraham Saran aneak buutiuwai, nunik kuashat tsawan anentaimak pujusui. ");
INSERT INTO agr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Nunik nuwe jakamtai aepes pujau ukuak, hitita aents aidaun apujijai chichastatus weuwai. ");
INSERT INTO agr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Nunik jegaa ditajai chichaak: “Wika atum wegantuchuitjai, nuniaigkish wait aneasjum makichik ukumatai sujustajum sumaktajai, dutikan nuwi mina duwajun ukustajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Tusa tama makichik nuwiya ayaak: ");
INSERT INTO agr_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“¡Apuh, wait aneasam antugkagtukta! Jutii ainag nuwiyamek ametme dekas Apajuí etegkamumek. Nuadui iina ukumataiji dekas pegkeg aina nuwi nuwemik ukusta. Makichkish jutii ainag juwiyag ukumatain sujitjamainuk shiig atsawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tutai Abraham wajaki hitita aents aidau emtin ditan eme anentus tsuntsuma wajas pagkainiuwai. ");
INSERT INTO agr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Nunik chichaak: “Atumesh mina duwag jaka nuna ukusti tusa wakegakjumek Efrón Sóharan uchijiya nuna ukumatai awa nunú segatjitajum. ");
INSERT INTO agr_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Tuja Macpelánum waa niina nugke nagkatkamunum awa nuna sujusti. Wi nuna akikenak ashí akiktajai. Dutikau asamtai, juju nugka juwi makichik waa ukumatai midaush ajuttí tajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Tutai Efrón hitita aents nii nuwi pachitkau asa, nii wegantu aidaush ijunbaunum, ashí aents yaaktan waitijin utsaanaidaush betek antuinamunum chichaak: ");
INSERT INTO agr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“¡Atsah, mina apujuh, wait aneasam antugtukta! Wi yamaik ashí mina pataag aidaush antuinamunum tajame: Au nugkak ame jukita amina amaajame, tuja waaya aushkam aminu ati, nuwi amina nuwem ukusta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Tusa tima Abraham aents nugkentin ijunbaunmanini ataktu tsuntsuma pagkainiuwai, ");
INSERT INTO agr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","nunik dita emtin Efrógkan chichajak: “¡Wait aneasam antugtukta! Wi kuichkin nugka akiken amaag duka wait aneasam jukita. Dutikawamin wisha anentag mina duwag jajutka nunash ukustajai”, tau. ");
INSERT INTO agr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Tama Efrón Abrahaman ayaak: ");
INSERT INTO agr_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“¡Mina apujuh antugtukta! Nugkak akikai cuatrocientos plata najanamu. Tujash juna akikega duka chichamjuk pujuchmi. Dekas nuwem jaka duka ukusta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Tima nunak antusag Abraham Efrón hitita aents aidaun emtin imaan akikai tibaunak imatiksag kuichkin juki akikmakui. ");
INSERT INTO agr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Dutikau asa, Efrógkan nugke Macpelá Mamrenum etsa minitaiya nuni awa nunak ashí niinu emauwai. Tuja nuigtushkam nunú nugkanum waa aunak, ashí numi múun aidaujai, ");
INSERT INTO agr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ashí Abrahamdauk wajasui. Tuja Abraham nugkan sumakua nunak hitita aents aidau emtin nuigtushkam tikich aents nunú yaaktanum utsanaidaush antuinamunum sumakui. ");
INSERT INTO agr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Nuna ashí umika, Abraham niina nuwe jakaun juki, Mamrenum wajasa diyam etsa minitainini Hebrón tutai Canaán nugkanum waa Macpelánum awa nuwi ukusui. ");
INSERT INTO agr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Aatus nunú nugkak, waajai, hitita aentsun nugke aajakun, Abraham sumakua duka, niina ukumatai wajasui. ");
INSERT INTO agr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahamak shiig múuntuch wajasui. Tuke Pujuu niinak ashí pegkegnum yainkui. ");
INSERT INTO agr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Makichik tsawantai Abraham niina inake chichintan, ashí niina wajiji aidaunash kuitamin atinaitme tusa tibaun untsuka chichajak: “Amina uwejum mina bakuju wakentin yununkata, wagki ame chicham umiktinjum dekaskenum tujuttin asam, ");
INSERT INTO agr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","nunikam Tuke Pujuu Apajuí nayaimpinum nugkanmashkam inamna nunú antugtamai, ame chicham umiakum mina uchig canaágnum wi pujag juwiya nuwan nuwatkai tusam kuitamkatnujum pachisam tujutta. ");
INSERT INTO agr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Juwiya nuwak egattsuk, mina nugkajui weme mina pataajuiya Isaaka nuwe atin egatkata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tusa tama niina inake ayaak: “Ayu, tujash nuwa wijai minitan dakitakuish ¿wisha utugmainaitja? ¿Amina uchigmin jukinuap ame pujaum ukukiuwaitam nuwi eman nuweattaja?” tau. ");
INSERT INTO agr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Tama Abraham ayaak: “¡Atsah, mina uchijuk awi jukimek emaipa! ");
INSERT INTO agr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Tuke Pujuu Apajuí nayaimpinmayaya nunú mina pataju nugkeen mina apaju jeen pujai jiijak, mina, tuja mina uchijun uchiji wegantu agtina nunú batsamsatnun susatjai tusa juju nugkan anagtuauwa nunú Apajuí niina aentsjin nayaimpinmayan emtikak awemattawai. Nuadui mina uchijun nuwe atinuk nii yaimpasmatai juki itaattame. ");
INSERT INTO agr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Untsu nuwa amijai minitan dakitakuig, wi tajam duka amek agkan juwaktatme. Tujash ¡makichkish mina uchijuk awi jukimek emaipa!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tusa tima nunú inak niina apuji Abrahaman bakui wakentin uwejen yununak pujus chichaak: “Dekas ame mina tujutam nunak imatiksanuk umiktajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nuna tusa niina apuji wajiji aidaunmayan, shiig pegkeg aidaun etegkeg nuwa susatnun, tuja nuwa patayi aidau susatnunashkam jukiuwai. Dutikak nuigtushkam niina apuji tagkujinian diez camellon jukiuwai. Dutika juki Mesopotamia nugkanum Nacora yaaktajin weuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Nunik wea weakua yaaktanum jegauwai, tujash eke wayatsaig etsa akagu. Nuniai nuwiya nuwa aidau yumin aimainak yumigmatnum shimuidau. Nuninai nunú inakshakam camello aidaun ayamtikak yumigmatnum ayaunas batsasui. ");
INSERT INTO agr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Dutika nuwi wajas Apajuín aujak: “Mina apujun Abrahaman ememattai Apajuí Tuke Pujuuwah, wait aneasam yamai mina apug Abraham wait anenjata, dutikakum minash shiig pegkegnum wekaegas wakitkiti tusam yainkata. ");
INSERT INTO agr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tuja juwiya nuwauch aidau yumin shikinak mininai, juju yumigmata juwi ayaumsan pujustajai. ");
INSERT INTO agr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Nunikan pujai nuwauch yumin shikika waketkui: ‘Wait aneasam anú yumi aimka juki weam nunú apusam shikisam ajampusta uwagtajai’ tai, nii aijak: ‘Pai uwagta, nuniakmin amina camellojum aidaunash aaktajai, tusa tujuttata nunú, dekas Isaaka nuwe atin ame etegkamu ati. Nunú betek uminkamtai, ame mina apug wait anentamunak shiig wika dekattajai’ ”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tusa Apajuí augbaun eke ashimtsaig, makichik nuwauch yumi aimtain yanas minaun wainkauwai. Duka Rebeca Betuela nawanji aajakui. Betuelak Abrahama yachi Nacoran uchiji Milcáyai akiamu aajakui. ");
INSERT INTO agr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebecak shigmauch, nuigtush makichik aentskesh takaschamu aajakui. Nunú nuwa yumi shikitaijin apujus yumi aimak wakitki wetatman, ");
INSERT INTO agr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Abrahama inakeshkam tupikatki jegantun chichajak: “Wait aneasam, minash yumi machik ajampusta uwagtajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Tusa tama: “Ayu uwagta apuh”, tiuwai. Nuna takug yumi aimtaijin apujus susauwai, dutikam niishkam uwajui. ");
INSERT INTO agr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nunikmatai Rebeca chichajak: “Amina camellojum aidaunash yumin shikikan susatjai dita wakegamun uwagtinme” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tusa waujus yumi aimka takakbaujinak tagku amutainum yajatua ukuak, tupikaki kuashta yumin shikika ashí tagku aidau umumainun aimjukui. ");
INSERT INTO agr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Imanitai inakak takamtak wajas dii wajau, dekas juwashit Tuke Pujuu etegkamush tusa nuna ejetatus. ");
INSERT INTO agr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Camello yumin uwakagmatai, makichik oro dujinum nenatai najanamun seis gramo kijinji ajamun juki Rebecan detuauwai. Dutika nuigtushkam jimag kuntunum patakumtain oro najanamun cien gramo kijinji ajamun juki nunashkam susauwai. ");
INSERT INTO agr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Nuna susa iniak: “Wait aneasam tujutiah ¿amesh yana nawanjiyaitpa? ¿Amina apa jenish agkanchaukai wi mina aentsug aidaujai kanumainush?” tau. ");
INSERT INTO agr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Tusa tama nii ayaak: “Wika Nacor Milcáyai Betuelan akiauwa nuna nawanjiyaitjai. ");
INSERT INTO agr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Iina jenig atum kanumainuk awai, nuigtushkam chijichi camello yumainchakam kuashat awai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Tusa timatai nii Apajuí segamunak ashí imanisag uminkamtai, tikishmag pujus Tuke Pujuun emematak: ");
INSERT INTO agr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“¡Tuke Pujuu mina apug Abrahama Apajuíjig pegkegnum chichagtai atin ati! Dekas amek mina apug wait anentau asam anagkuamugmek umitskek idaisachume. Ame minashkam jinta inaktugsam, mina apug Abrahama patayin itajuaume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Aatus inak Apajuíjai chichaak pujai, Rebeca tupikaki niina dukuji jeen jegaa nuna pachis dukujin ashí ujakui. ");
INSERT INTO agr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Tusa etsegkamtai Rebeca umayi iwai Labán nunú aents yumi aimtainum ayaumas pujaun wainkatatus tupikaki weuwai, ");
INSERT INTO agr_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","wagki niina umayi kuntunum patakumtain dujinum nenataijai ayatak orok najanamu susamun wainkau asa. Tuja nuigtushkam Rebeca chichaak: “Nunú aents minak aatus tujutmae”, tusa etsejun antuku asa, nunú aents yumi aimtainum ayaumas camellojin batsas pujaun shiig wainkatatus wejiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Nunik jegantun, chichajak: “¿Wagka agaash pujame? Amek Tuke Pujuu pegkegnum yumigjamuitme, anui pujutsuk wegajai mina jegajui wemi. ¡Wi ame kanumainnak amina camellojum batsamsatin aidaujai umikmajai!”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tusa tima ayu tusa jega weuwai. Nunik jegamtai, camellonum waji aidau pataja ejegamun ashí Labán akaja ijumag duwi camellon ayujauwai. Tuja nuigtushkam yumin shikika nunú inakan, niijai yujaujai susauwai nawen nijaktinme tusa. ");
INSERT INTO agr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Nuna dutika, yutain inajuk umika apujtusui. Dutikamtai Abrahaman inake chichaak: “Eke wi chichaman tumain ajuta nuna amina ujatskek yumaitsujai”, tiuwai. Tama: “Ayu, waji tame tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Timatai inak chichaak: “Wika Abrahaman inakegaitjai. ");
INSERT INTO agr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mina Apug Abrahamnak Tuke Pujuu shiig kuashat pegkegnum yaigkui. Dutikak uwijan, bakan, platanash, oronash, inak aishmag aidaun, inak nuwa aidaujai, nuigtu camellon, burro aidaun aatus ashí susa wiakuch awajsae. ");
INSERT INTO agr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Tuja niina nuwe Sarashkam muumpatnum uchin uchigmatkabi. Mina apujuk niina wajiji aidaunak, juka mina uchigdau agtinai tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nunú mina apug wi chicham umiktinun chichagtak: ‘Mina uchiju nuwe atinuk Canaán nugkanum wi pujag juwiya nuwak egatkaipa, ");
INSERT INTO agr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","juwiyag egattsuk dekas mina apaju patayin wetá, nunikam nuwiya mina uchiju nuwe amainuk egatkata’, tusa tujutmae. ");
INSERT INTO agr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Tujutkui wi ayaakun: ‘Mina apujuh, ¿tujash nuwa wijai minitan dakitakuish itugkattajah?’ timajai. ");
INSERT INTO agr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Tusa tai nii mina aijak: ‘¡Apajuín wi emematkun umijag nunú, niina aentsji nayaimpinmayan emtika awemattawai, wagki nii uyuntamsamtai pegkegnum wekaesamnum tusa! Duwi amek mina uchiju nuwe atinuk yupichu mina apaju patayinia jukittame. ");
INSERT INTO agr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Untsu ame mina pataajui jegaam nuwa sumamin sujitjamkagmataig, wi ame chicham umiktinun tajam duka agkan juwaktatme’, tujutmae. ");
INSERT INTO agr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Tusa tujutiu asamtai, yamai yumi aimtainum taa wajasan, Tuke Pujuu mina apujun Apajuíjiya nuna augkun: “ ‘¡Amesh dekas minash shiig pegkegnum wekagas nii dutikatag tabaunak betek umika wakitkiti tujutkumek yainkata! ");
INSERT INTO agr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tuja nunú betek uminkuig wi yamai juju yumi aimtainum wajag juwi wajasan, nuwauch yumi shikik waketkui wi chichagkun: “Wait aneasam yumi shikikam machik ajampusta, uwagtajai”, tusan tai, ");
INSERT INTO agr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","nii aijak: “Ayu, uwagta, nunikamin camellojum uwagtinnash shikigkatjai”, tusa tujuttata nunú dekas ati ame mina apujun uchiji nuwe atin egatkamuk’, tusan timajai. ");
INSERT INTO agr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Tusan Apajuíjai chichamunak eke ashimtsaig, Rebeca yumi aimtaijin yanaki midaun wainkamjai. Nunik yumi akaetuki shikika iwakmatai, wi niina chichagkun: ‘Minash wait aneasam yumi ajampusia uwagtajai’, timajai. ");
INSERT INTO agr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Tusa tai ayu tusa, yumi aimka juwamujin akaki apujus chichagtak: ‘Amea uwagta, nunikamin amina camellojum aidaunash yumin shikigkan aaktajai’, tusa mina yumin sujus idaitak, mina camellog aidaunashkam dutiksag susame, ");
INSERT INTO agr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","dutikamtai duwi wi niina iniakun: ‘¿Amesh yana nawanjiyaitpa?’ tusan tai nii aijak: ‘Wika Nacoran uchiji Betuel Milcáyai akiinauwa nuna nawanjiyaitjai’, tujutmae. Timatai niina nujiin nenatain detuamjai, tuja nuigtu jimajan kuntunum patakumtain patakuamjai. ");
INSERT INTO agr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nuna dutikan nuwig tikishmaja pujusan Tuke Pujuun emematmajai, wagki Apajuí mina apug Abrahaman ememattaiya nunú minak jintan inaktujus, mina apug Abrahama uchiji nuwe atinun niina patayi nawanji pujamunum itajuau asamtai. ");
INSERT INTO agr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nuadui yamai atumesh dekaskenum tsanumtsuk mina apug Abraham tibaun ujajim nunú tujuttajum. Untsu atsa dutikmaitsujai takugminig wi anentaimsatjai wajinak dutikatja”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Tutai Labán Betueljai niina ayaak: “Juka ashí Tuke Pujuu wakegamua nunuwai, nuadui iik ayu tusaikish, nuniachkuish atsa tusaikish tumaitsuji. ");
INSERT INTO agr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Pai nijah, juwai Rebecak, juju jukijum wetajum. Amina apugmi uchijiya nuna nuwe ati. Tuke Pujuu wakegamua nunisag uminkati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tusa tutai Abrahaman inake tikishmag nijayin nugkan antig pujusui Tuke Pujuun emematak. ");
INSERT INTO agr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Apajuín ememati idayak, kuashat waji takatai akik aidaun, plata najanamu aidaun, oro najanamu aidaun, tuja jáanch nugkutai aidaunashkam juki Rebecan susauwai. Dutika nuigtushkam niina umayin niina dukujin aatus waji aidaun susauwai. ");
INSERT INTO agr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Nuna dutikai aents niijai uyuunis yujauk betek ijuntujag yutain yuwawag, umutnash uwajag kajigkajui. Nunik tsawainak nantakiag nunú inak chichaak: “Wisha yamai wakitkitjai mina apuju pujutaijin”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tutai Rebeca umayi dukujijai chichainak: “Eke yamaikik Rebecak jukipa, dakasta jutijai diez tsawan pujusti, nunik duwi atumjai weti”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tujash inak ditan ayaak: “Nuigtuk minak emetjuawaigpajum. Tuke Pujuu minak pegkegnum wekaesati tusa tujutbaunum shiig umikjai, nuadui wika mina apuju pujutaijin wakitkitag tajai”, tau. ");
INSERT INTO agr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Tusa tutai dita aínak: “Jasta, Rebeca untsuka dekajuami wajintig”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Tusag Rebecan untsukag itan iniinak: “¿Amesh juju aentsjai wetasamesh wakegamek?” tama, nii aimak: “Ehe wetatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Tusa timatai Abrahama inake shimamunum Rebecan, tuja nuwa nii uchuch asamtai kui kuitamkawa tsakapajua nujai akupkajui. ");
INSERT INTO agr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Dutikainak, Rebecan pegkegnum yumigkinak aatus tiajui: “Iina umayi yamai akupkami: ‘Chah, ubajuh, ¡Amek shiig kuashat aentsun dukujimtai atin ata! ¡Nuigtushkam amina uchijum wegantu aidauk, ditá shiwaajin depetkatin atinme!’ tusa wakegaji”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Aatsa pegkegnum yumigjam, Rebeca niina inake nuwa aidaujai camellonum pekamiag, Abrahaman inake wetai niijai shiyakajui. Aatus Abrahama inake Rebecan juki wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Tuja Isaakak Néguev nugkanum pujujakui. Nuniayatak makichik tsawantai yumigmat “Iwaku pujuuwa nunú minak waitui” tutainum weuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Nunak nunikui wagki tuke ayamak Apajuín aujak wekaesatatus. Nuwi wekagu pagkas niimsatakama camello miniagtatman wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tuja Rebecashkam niimkama wainkauwai Isaakan, nunik camellonum eketu akaikiuwai. ");
INSERT INTO agr_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Nunik akaiki inakan iniak: “¿Aush yaita ikama awiya ii weamunmanini mina dusha?” Tusa iniam, inak ayaak: “Auk mina apujui”, tiuwai. Tima jáanchin juki dukumak yapiin ejaka wajasui. ");
INSERT INTO agr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Nuniai inak Isaakan igkug nii wekaesa dutikamujinak ashí ujakui. ");
INSERT INTO agr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Dutikam Isaac Rebecan juki niina dukuji aajakua nuna aakjin awayauwai, dutika nuwi nuwatkauwai. Aatus Isaakak dukuji jakamtai, wake besemag pujau Rebecan aneak anentain ichichiajui. ");
INSERT INTO agr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham tikich nuwa Cetura daagtinun jukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Dutika nunú nuwanum imajin uchijin akigkui: Zimrám, Jocsán, Medán, Madián, Isbac, Súah, aatus. ");
INSERT INTO agr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsán akiauwai Sebánkan Dedánjai. Untsu Dedánkan uchiji wegantu aidauk: Asureo, letuseo, leumeo aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Tuja Madiágka uchijishkam: Efá, Éfer, Hanoc, Abidá, Eldaá aatus aajakui. Ashí juju aina juka Cetura uchiji wegantu aajakui. ");
INSERT INTO agr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Tujash Abrahamak niina wajiji aidaunak ashí niina uchiji Isaakan susauwai. ");
INSERT INTO agr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Tuja tikich nuwanum akigbau aidaunak ayatak anenjauch wajichin susa, Isaac pujamun ukumtiki atushat ishiakui. Tuja nigka nuwig pujayatak nugka etsa jiintaiya nuni ishiakui. ");
INSERT INTO agr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahamak ashí ijumjamak ciento setenta y cinco mijan pujusui. ");
INSERT INTO agr_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Nunik shiig múuntuch wajas, jakauwai. Nunikmatai ukusaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Nunik jakamtai, niina uchiji aidau Isaac Ismaeljai jukiag Efrógka nugke Macpelá Mamrenum etsa minitaiya nuni awa nuwi ukusajui. ");
INSERT INTO agr_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Nunú nugkanak Abraham hitita aents aidaun nugken sumakua nuwi niina nuwe Sara ukusbaunmak ayaunas ukusajui. ");
INSERT INTO agr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham jakamtai, niina uchiji Isaac yumigmatan daaji “iwaku pujuuwa nunú minak waitui” tutainum ayaumas pujaun, Apajuí pegkegnum yumigjauwai. ");
INSERT INTO agr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Sara inake egiptunmaya nuwa Agar aajakua nuwi Abraham Ismaelan akiauwa nuna uchiji wegantu aidauk: ");
INSERT INTO agr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Nebaiot aajakui iwaiji, nuwi patatkau ainawai: Quedar, Adbeel, Mibsam, ");
INSERT INTO agr_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masá, ");
INSERT INTO agr_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Temá, Jetur, Nafis, Quedmá aatus. ");
INSERT INTO agr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Juju ainawai Ismaelan uchiji doce aajakua duka. Juju aina juka maki makichik nugkentin aakan aakmajag yaaktamkajui. Dutikawag nunú yaakta daajinashkam dita daajinak adaijau ainawai. Dutikawag maki makichik dita yaaktajin apuji wajasaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaelak ciento treinta y siete mijan pujus, jakauwai, nunik jakamtai ukusajui. ");
INSERT INTO agr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Nunikmatai nii wegantu aidauk nugka Havilá tutai, Shurjai niniaku awa nuna ejapeen, jinta asirianum juwaki Egipto wetaya nuwi ditá yachi aidau dakitamaitak batsamsajui. ");
INSERT INTO agr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Jujuwai Abrahama uchiji Isaac pachisa augmattsamu. ");
INSERT INTO agr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac cuarenta mijanji ajamu asa, Betuela nawanji Rebeca Labágka umayi arameo aents aidau, Padán-aram batsamajaku aina nuwiyan nuwatkauwai. ");
INSERT INTO agr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeca kaga asamtai, uchi akiatjai tusa Isaac Apajuín senchi segauwai. Tusa segam Apajuí Isaakan antugkauwai, nuadui Rebeca ejapjukui. ");
INSERT INTO agr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Tuja jimag uchi asa initak egkemsag maanidau. Imaniagtai Rebeca nigki anentaimas: “Juju imaninakui, wika iwaku pujutnak dakitajai. ¿Wagka minash jusha jutijawa?” tusa Apajuín iniasui. ");
INSERT INTO agr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Tusa iniam Tuke Pujuu ayaak: “Amina ampugminig jimag uchi egketui, nunú akiinawag atakea duwi yujakag maaniawagtinai. Nuadui uchik eke akiintsuk initak egkemsag maaninawai. Tikichia nuna aentsji ima kuashat agtinai. Untsu iwaiya nunú yachi awanin umigtinai. Nuni kanakagtin asag imatijamainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tusa tima pujus tsawan nii uchigmaktin jegamtai jimajan uchigmakui. ");
INSERT INTO agr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Yama nagkamchak uchi jiinkiuwa duka intashi kapantu uje wajakin akiinauwai. Nuna adaikauwai Esaú. ");
INSERT INTO agr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Nuniai tikishchakam patatkau, niina yachi Esaú sagkanin achitkau akiinauwai. Nuniku asamtai, nunak Jacob adaikauwai. Juju uchi aidaun jimagma Rebeca uchigmakua nunak, Isaakan mijanji sesenta ai uchigmakui. ");
INSERT INTO agr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nunú uchi aidauk mai muumpajajui. Esaú kuntin mautan yacha aajakui, untsu Jacob batajuch aajakui, niinak ayatak jega pujut shiig awagmajakui. ");
INSERT INTO agr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaakak Esaún ima senchi anejakui, wagki egakbaun yuu asa, untsu Rebeca Jacopan ima senchi anejakui. ");
INSERT INTO agr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Makichik tsawantai Jacob yutain inajak pujai, Esaú kuntinun maatatus weu pimpiki minau. ");
INSERT INTO agr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Nunik minis Jacob inajak pujaun wainak chichajak: “¡Wait aneasam minash anú yutai pachimjam kapantu emam inajam nunú ajamjusta, nujantai jajai!” tiuwai. Nuadui Esaú tawa nunak kapantu taku, tawai. ");
INSERT INTO agr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Tusa segam Jacob Esaún chichajak: “¡Kame amesh yapajakmek, eke yutain amatsaig ame iwai asam jumainaitam nunú mina ashí sujusta!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Tusa tama Esaú chichaak: “¡Nijah, wi iwai asan jumainaitag dusha, waji pegkegnumak yainkati! ¡Nuna sujimaknuk nujantai jakattag jama! ¡Duka dekas ame jukitin ata!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Timatai Jacob ayaak: “Dekas takumek yamaikiuchia juwik ame tame nunú umiktinjum chichaakum: ‘Duka dekas ame jukitin ata’ tusam tujutta”, tau. Tusa tama Esaú chichaak: “Nunak dekas tajai”, tiuwai. Nuni susauwai Jacopan ashí nii iwai asa jumain aidaunak. ");
INSERT INTO agr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Tusa tima Jacob, Esaún pagkan lenteja pachimja inagkamujai susauwai. Dutikam nuna yuwa, umutainashkam uwag uminak weuwai. Tuja nii iwai asa jumainjinak puyatjachu asa, dutika sujuk niig wainak juwakui. ");
INSERT INTO agr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Yaunchuk Abraham iwaku pujai, yapajut tepeauwa nuna nagkaesau, Isaac pujusmataishkam yapajut tepeauwai. Nunikmatai Isaac yaakat Guerar filisteo aents aidaun apuji, apu Abimelec pujamunum weuwai. ");
INSERT INTO agr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nuwi jegaa pujaun, Tuke Pujuu wantintuk chichajak: “Egiptunmak wepa, dekas wi amina titatjam nuwi weme pujusta. ");
INSERT INTO agr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Tuja yamaikik juju nugka juwig pujusta, wi aminak kuitamkattagme. Wi aminak pegkegnum yumigsattagme. Tuja amina uchijum wegantu aidaun ashí juju nugka aina juna susattajai. Wi amina apa Abrahaman anagkuawaitag nunak, nuni umiktatjai. ");
INSERT INTO agr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Amina uchijum wegantu aidaunak nayaimpinum yaya dekapamainchauwa iman awajsattajai. Dutikakun juju nugka junash ashí ditanak susattajai. Tuja nuigtushkam, ashí tikich nugkanmaya aidaush amina uchijum wegantu aidaunum yunumas pegkeg yumigkin jukiagtinai. ");
INSERT INTO agr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nunak dutikattajai, wagki wi Abrahaman mina chichameg, wi jintinjam jujai betek umikta tusa tibaunak imatiksag umigtuku asamtai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tusa tima Isaac Guerarnumak pujusui. ");
INSERT INTO agr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Nunik pujaun nuwiya aents aidau Rebecan pachis: “¿Jusha yaita?” tusa inidau. Tusa iniam Isaac mina nuwajui tutan ishamak: “Mina ubajui”, tiuwai. Nunak tiuwai wagki Rebecak shigmauch asamtai niina shigmatin juinak mantuawainum tusa. ");
INSERT INTO agr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Kuashat tsawan nagkaemai Abimelec makichik tsawantai niina jeen wajasa niimtainum niimkama Isaac niina nuwe Rebecan achika wasugtatman wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Dutika wainak Abimelec Isaakan untsuka itan chichajak: “Dekas au nuwa amina nuwemiapih. Nuniaish, ¿wagka mina ubajui timaume?” tau. Tama, Isaac ayaak: “Niina juinak mantuawainum tusan timajai” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Tutai Abimelec chichajak: “¿Wagka jusha jutikagtame? Mina aentsug aina nuwiya makichkikesh amina nuwemin aikauwaitkuig, amek jutiik pegkegchau takasua iman ekagtumain awajkagtukume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Nuna tusa ashí niina aentsji aidaun chichajak: “¡Juju aentsun waitkauk, tuja niina nuwenakesh waitkauk mantamnattawai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Tuja nunú mijantin Isaac Guerar nugkanum pujus ajakan ajakbauwai, dutika Apajuí yayasam ¡shiig kuashat! juukui. ");
INSERT INTO agr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Imatikau asa ¡shiig kuashat wajigtin! wiakuch wajasui. ");
INSERT INTO agr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Uwigjish, bakajish kuashat, nuigtush inake aidaush shiig kuashat ajujakui, iman asamtai, filisteo aents aidau kajejuidau. ");
INSERT INTO agr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Dutikaidau asag Abraham pujusmatai, niina inake aidau yumigmat aidaun taimu aina nuna yututkajui. ");
INSERT INTO agr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Tuja Abimelecshakam Isaakan chichajak: “¡Wetá juwi pujam duka, amek jutii nagkaekagtasu shiig wiakuch wajasume!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tusa tima Isaac jiinag Guerar nugka pakajin shiyakag nuwi batsamsauwai. ");
INSERT INTO agr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Nuwi niina apaji iwaku pujusa yumigmat aidaun tainiuwa nuna apaji jakamtai, filisteo aents aidau yutukagbaun ataktu tai iwajauwai. Dutika iwajug, nii apaji adaikamu aajakunak dutiksag niishkam adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Makichik tsawantai Isaaka inake aidau nugka pakanum yumigmatan tau batsamkamá yumi pukuni jiinun ejeyu ainawai. ");
INSERT INTO agr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tujash nuna wainkagmatai, Guerarnumia aents uwijan kuitamin aidau, Isaaka uwigjin kuitamin aidaujai: Juka yumik iinui tusag maanitkajui. Nuadui Isaac nuna adaikauwai “Esek”, wagki nuna maanitkaju asag. ");
INSERT INTO agr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Nunikag Isaaka inake aidau, tikichin yumigmatan tainiajui, dutikawagmatai nunashkam dutiksag maanitkajui. Untsu Isaac nuna adaikauwai “Sitna”. Nunak “shiwagmagat” taku tawai. ");
INSERT INTO agr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Dutika ukuak Isaac atushat weuwai, nunik nuwi tikich yumigmatan tainiajui. Tujash nunak maanitkachaju asag, adaikajui, “Rehobot”. Nunak “agkanmagamu” taku tawai. Nunak “yamaik Tuke Pujuu agkanmitkagmae juju nugka juwi takainak emkatnume” taku tuu adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Nuna ashí umika nuwi pujau, Isaac bershebanum pujustatus weuwai. ");
INSERT INTO agr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Tuja nunú kashia duik Tuke Pujuu Isaakan wantintuk chichajak: “¡Witjai amina apa Abrahama Apajuíjinuk, makichkish ishamkagtukaipa, wi aminak kuitamjame! Abraham mina chichamjun umigtukua duwi aminash aikasnuk pegkegnum yumigsan, amina uchigmin uchiji wegantu agtinashkam ikauntuktatjame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aatsa tima kuntin maa patasa apeaku Apajuí ememattinun nuwi najanauwai, dutika nuwi Apajuín niina daajin adaitus emematiuwai. Dutika nuwi aakmag pujusajui. Tuja nuwi niina inake aidau tikich yumigmatan tainiajui. ");
INSERT INTO agr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Makichik tsawantai Abimelec Guerar pujau Isaakjai chichastatus weuwai. Nuwi wetai niina kumpaji Ahuzat, Ficol suntajan apuji aajakua nujai uyuuniajui. ");
INSERT INTO agr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Nunik kaunawagmatai Isaac chichajak: “Atum mina dakitjakjum, atumin nugkemin pujai jiigkijum ajapjuamujum dusha, ¿wagka wijai chichastasagmesh minagme?” tau. ");
INSERT INTO agr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Tusa tama dita aínak: “Iik dekaji Apajuí amina kuitamjama duka, nuadui anentaimsa dekas iish amijai mai ikdaisa chicham umigdaikatna nunú chichasmi tusa minaji. Tuja ii tabauk jujuwai: ");
INSERT INTO agr_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Amesh jutiish pegkegchau awajkagtukaipa, wagki iik amek waitkatsuk, ayatak pegkegnum kuitamka apusa jiyakuish utugchat atsaunum agkan jiiki awemabiagme. Tuja aminak yamai Apajuí pegkegnum yumigtamsae”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tusa aatus chichasag, Isaac yutain umikmatai nuna yuwinak, umutain umuinak jiistamawajui. ");
INSERT INTO agr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nunik tsawajag kashikmas Isaac, ditajai mai ikdaikag chicham umigdaikagtinun chichasag umikajui. Dutika umikag Isaac ditan kumpamak awakjauwai. ");
INSERT INTO agr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tuja nunú tsawantinig Isaaka inake aidau yumigmatan tagak batsatu yumin chigkawag, yumi chigkaji tusag ujaktatus kautuawajui. ");
INSERT INTO agr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Nunikagmatai Isaac nunú yumigmata daajin Sebá adaikauwai. Nuadui nunú yaakta daajig Beersheba tama awai. ");
INSERT INTO agr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaú cuarenta mijanji ejeyi pujus, hitita aents Beerí aajakua nuna nawanjin Juditan nuwatkauwai. Nunik pujus tikich nuwa Basemat daagtin tikich hitita aents Elón aajakua nuna nawanjinashkam nuwatkauwai. ");
INSERT INTO agr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Juju jimag nuwa aina nuna pujutji pegkegchau asagmatai nuna diisag, Isaac Rebecajai shiig pujuschamin wake besemag pujujakajui. ");
INSERT INTO agr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaakak shiig muumpakiu asa wainmatnash wainmamainchau wajas pujujakui. Nunik pujau makichik tsawantai niina uchiji iwain untsuka chichajak: “¡Uchuchih!” tau. Tusa untsuam nii ayaak: “Juwi pujajai apawah, waji tame, tujutta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Tama nii ayaak: “Nijah, wika yamaik shiig muumpakjai, pachiachbaunum jamainaitjai. ");
INSERT INTO agr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","¡Nuadui kuntin mautaijum jukim ikam weme kuntin maam, ");
INSERT INTO agr_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","shiig pachimjam, mina yutaijuama nunú yutai pegkeg inagkam itagtuata, yuwatjai! Nuna yuwakun wi eke jatsug duwik amina pegkegnum yumigsatjame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Nuna aatus Isaac tabaun Rebeca antukui. Nunik Esaú apaji yuwatnun kuntinun egak wematai, ");
INSERT INTO agr_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","uchiji ekeu Jacopan chichajak: “Antukta nijah, amina apa yamai amina yatsumjai chichaak: ");
INSERT INTO agr_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Kuntin maata, dutikam yutai pegkeg pachimja inagkam itagtuata, nuna yuwan, eke jatsuk Tuke Pujuush antai amina pegkegnum yumigsatjame’ taun antukmajai. ");
INSERT INTO agr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nuadui uchuchi wi titatjam nunú shiig antukta: ");
INSERT INTO agr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Wamak tagku batsamtain weme, jimag chivo tsakat pegkeg jukim itagtuata, wi wamak maan amina apa yaitaijiyama nuna pachimjan inagtuktajai. ");
INSERT INTO agr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Dutikamtai ame jukim ejetuata nuna yuwati, nuna yuwa nii dekas iwaaka awik, amina pegkegnum yumigtamsati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tusa tama Jacob dukujin ayaak: “Tujash mina yatsug Esaún iyashig uje wajasuwe, wika aannuchuitjai. ");
INSERT INTO agr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Namputkama mina apag achigkama dekapjug, dushiktakpap jutijawa tusa, pegkegnum yumigtutsuk pegkegchaunum yumigtujai tajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Tusa tutai dukuji ayaak: “¡Uchuchi amina pegkegchaunum yumigtamjamtaish duka minai juwakti! ¡Amek ayatak wi tajam duke umikta, nuniakum wamkesam weme, jimag chivo tsakat jukim itagtuata!” tau. ");
INSERT INTO agr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tusa tima ayu tusa weji, jimag chivo tsakatan juki dukujin itajuauwai. Dutika itajuam nuna maa Isaakan yaitaijin imatiksag pachimag yutai pegkejan inagtukui. ");
INSERT INTO agr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Dutika umika, Esaú nugkutaiji jáanch dekas shiig pegkeg jegaa atatman juki, niina uchiji ekeun Jacopan anugjauwai. ");
INSERT INTO agr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Dutika nuigtushkam chivo duwapen juki, niina kuntujin pempenjauwai, dutikak, kuntujenchakam uje atsuju asamtai, nuwishkam anugjauwai. ");
INSERT INTO agr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Dutika nii yutai pachimja pegkeg inagkamun pagjai juki apajin susati tusa susauwai. ");
INSERT INTO agr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Dutikam nuna juki niina apaji pujamunum waya, chichajak: “¡Apawah!” tiuwai. Tama: “Juwi pujajai, ¿yaa uchijuitpa amesh?” tusa Isaac iniasui. ");
INSERT INTO agr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Tusa iniam Jacob ayaak: “Wika amina uchijum iwai Esaúwaitjai. Ame mina segatmaum nunak umikjai. ¡Wait aneasam nantakim juwi ekemsam yuwata wi kuntin maamua nunú, núnikam pegkegnum yumigtugta!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Tusa tama, Isaac uchijin iniak: “¿Uchuchi itugsamea kuntinush wamkesmesh wakemkaume?” tau. Tama Jacob ayaak: “¡Tuke Pujuu Apajuí ame emematnum nunú minak yainkamtai, wamak igkugmajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Tujash Isaac niina chichajak: “Ayu, ame dekas mina uchig Esaúwaitkumek adijtukta achikan dekapsatjame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Tusa tama Jacob apajin jegaantauwai, achijuk dekapjusti tusa. Nuna achika dekapes, Isaac chichajak: “Chichamjumek Jacopan chichamejai betekai, tujash untsu kuntujum Esaún kuntujiyai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Niina kuntujinig niina yachi Esaún kuntujijai betek uje wajakin asamtai, dekapjachui. Tujash pegkegnum yumigjattak, ");
INSERT INTO agr_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ataktu awena iniak: “¿Dekas amesh mina uchig Esaúkaitam?” tau. Tama nii ayaak: “Ehe witjai, Esaúwaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tusa timatai niina apaji chichajak: “¡Ayu uchuchih, ame kuntin maa inagkamu sujusta yuwatjai, nuna yuwan pegkegnum yumigsatjame!” tiuwai. Tama Jacob ayu tusa yutai umikbaun juki apajin susauwai. Dutikak nuigtushkam umutai vino uva najanamun ejetuauwai. Dutikam Isaac nuna yuwa umutainashkam uwajui. ");
INSERT INTO agr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nunik chichaak: “¡Uchuchih, juwi tantam kugkuntsata!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Tama Jacob niina apajin kugkuastatus jegaantam, Isaac niina uchiji Esaún jáanchji kugkuntin dekapjujui. Nuna dekapjug pegkegnum yumigkiak: “Juju juni kugkua juka mina uchig emkaun kugkuntiyai. Ikaman kugkuntijai betekai, Tuke Pujuu aan yumigjamu asa. ");
INSERT INTO agr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","¡Uchuchi aminak Apajuí yumi nayaimpinmayan amastí, dutijamamtai amek nugkanum ajakmamesh trigo shiig kuashat juutnaitme, tuja vinoshkam umumain kuashat ajutjamtinai! ");
INSERT INTO agr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","¡Kuashat aents aidau aminak takagtamiagtinai, nuigtushkam nugka muunnumia aidaush ima aminak antugtamainak umigtamiagtinai! ¡Ame apu wajasamin, yatsumshakam amina umigtamtinai! ¡Amina pegkegchaunum yumigtamaidauk, ditashkam dutiksaik pegkegchaunum yumigkiam agtinai! ¡Untsu amina pegkegnum yumigtamaidauk, ditashkam dutiksaik pegkegnum yumigkiam agtinai!” tuu yumigjauwai. ");
INSERT INTO agr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Tusa pegkegnum yumigjam Jacob apajin pujau jiinki wegaig, Esaúshkam kuntinun maatatus weu tauwai. ");
INSERT INTO agr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nunik niishkam apaji yaitaijin, yutai pegkejan pachimag inajuk, juki jegan apajin chichajak: “¡Apawah, nantakim, wi kuntinun maa inagtukjam nunú yuwata, núnikam pegkegnum yumigtusta!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tusa tama Isaac iniak: “¿Yaitpa amesh?” Tama: “Wika amina uchijum iwai Esaúwaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tutai, Isaac anentai jegagchauwai, nunik kujakjatun chichaak: “Tujash ¿ya minash kuntinun maa yutain umikash itagtuame? Nuna wika ame eke tatsminig ashí yuwamjai. Dutikan niina ashí pegkegnum yumigjamjai. Nuadui nii yamaik pegkegnum yumigjamu juwake”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Tusa apaji tutai Esaú antuk, kajeka buutak: “¡Apawah, minash wait aneasam pegkegnum yumigtujiah!” tau. ");
INSERT INTO agr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tusa tama Isaac ayaak: “Amina yatsum tajutua, tsanujug aminu pegkeg yumig atinuwe nunak ashí jujutjamkine”, tiu. ");
INSERT INTO agr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tutai Esaú chichaak: “¡Awis niina daajinak Jacob adaikau ainatai! ¡Aniau asa jimajá tsanumag midau amainun atanjukne! Nagkamchakush wi iwai asa jumainun atanjukmae, tuja yamaish wi pegkegnum yumignamainjun nigki atanjukne. ¿Tujash mina yumigtumainuk makichkish ukugtuschaumek?” tau. ");
INSERT INTO agr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Tama Isaac Esaún ayaak: “Antukta nijah, wi Jacopan amina apujum ati tusan tijai, dutikakun ashí niina patayi aidaushkam niina umijin atinme, timajai. Nuigtushkam trigo aidaush, umutai vino aina nujai kuashat ajiti, timajai. ¿Tujash uchuchi yamaish aminash, itugkatjamki?” tau. ");
INSERT INTO agr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Tusa tama Esaú atak awagki segaak: “¿Apawah, makichkiuchikesh mina yumigtumainuk shiig atsugtamuak? ¡Minash apawah, pegkegnum yumigtujiah!” tusa senchi buutu. ");
INSERT INTO agr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Imattai Isaac niina chichajak: “¡Antukta nijah, amek atushat weme, juju nugka pegkeja juka ukuakum, nugka pegkegchaunum yumish yutachbaunum pujustinaitme! ");
INSERT INTO agr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Amek amina puyaajumjai depetmasam pujakum amina yatsum umigtinaitme, tujash ame senchijinkum nii umiju pujaum agkanmagatnaitme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Jacob kasagkamu asa, Esaú niina senchi kajegkauwai, wagki nii yumignamainun, apaji Jacopan susau asamtai. Nunik anentaimas: “Mina apajuk jatanak namput wajaschae, nii jakamtai agkan wajasan mina yatsug Jacobnak maatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Tusa chichaman umiamun Rebeca dekaa, Jacopan untsuka itan chichajak: “Antukta nijah, amina yatsum Esaú mantamatag tawai, ame nii yumignamainji atankiu asamin. ");
INSERT INTO agr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nuadui uchuchi yamai antugtukta: Amek yamaik yaakat Harágnum tupikakta, núnikam mina ubag Labágka jeen jegata. ");
INSERT INTO agr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Nunikam amina yatsum kajegtamka nuna sakapai, nuwi niijai pujusta. ");
INSERT INTO agr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ame atankim kajegtamka nuna tsagkugmatai, duwi wi chichaman akuptuktatjame, dutikamtai nunú dekaam wakitkim taamnum. ¡Dakitajai mina uchig maaninak mai jaka megkaekai! tusan”, tau. ");
INSERT INTO agr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Nuna tii idayak, Rebeca Isaakan chichajak: “Hitita nuwa, Esaún nuwe aina nuna pegkegchaujin shiig aneasan pujumainchau, jamain dekapeajai. Tuja juju hitita nuwa aidau Canaágnum pujuina juninjai Jacob nuwenkuig, wika jakatjastai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Nuna aatus Rebeca timatai, Isaac Jacopan untsuka pegkegnum yumigkig, nii umiktinjin chichajak: “¡Juju nugka Canaágka juwiya nuwajaig makichkish nuwenatin aipa! ");
INSERT INTO agr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Dekas Padán-aram amina apachjum Betuela jeen wetá. ¡Nunikam nuwi pujusam duku umayi iwai Labágka nawanji nuwatkata! ");
INSERT INTO agr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Apajuí ashí senchigtina nunú pegkegnum yumigtamsati, dutijamak nigki ame uchijum wegantunash shiig kuashat uyujkati. Imatikam nugka múun aidaunum batsamsagtin atinme. ");
INSERT INTO agr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Nuigtushkam Abrahaman pegkegnum yumigkiak anagkuauwa nuna amina amastí, tuja amina uchijum wegantu aidaunashkam dutiksag susati. Nuadui ii yamai juju nugkanum iina nugke ukuaku kauna batsatag juwig pujustin atinme, wagki Apajuí Abrahaman juju nugkan anagkuau asamtai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aatus Isaac Jacopan chichajuk nugka Padán-aramnum akupkauwai. Dutikam Jacob niina dukuji umayi Labán pujamunum atushat weuwai. Labágkak arameo aents Betuelan uchiji aajakui. ");
INSERT INTO agr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isaac Jacopan pegkegnum yumigkiak: Makichkish canaágnumia nuwajaig nuwenatin aipa, dekas Padán-aram weme nuwenata tusa tima, ");
INSERT INTO agr_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","niina apaji dukujijai tibaun umiak Jacob Padán-aramnum webaun Esaú dekauwai. ");
INSERT INTO agr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Aatus Esaú niina apaji canaágnumia nuwan dakitamun dekauwai. ");
INSERT INTO agr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Nuadui Abrahama uchiji Ismael pujamunum weuwai. Nunik nuwi jegaa, canaágnumia nuwa aidaun jimajan ayakiatak, Ismaela nawanji Mahalat Nebaiotan umayi aajakua nuna nuwatkauwai. ");
INSERT INTO agr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob Beershebanum pujau jiinki Harán nugkanum weuwai. ");
INSERT INTO agr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nunik wesa eke jegatsuk jintá etsa akaetai kanagtatus, kaya juki nuna atamjuk tepesui. ");
INSERT INTO agr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nunik kanukma kajanum, watai jigkaka najanamu nugkanum awaja juki nayaimpinum iwakbaunum, nuwi Apajuín aentsji nayaimpinmaya aidau, nugka akagag, yaki wajag ataktu nugka akagag wajaidaun wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tuja apu Tuke Pujuushkam niiyai ayaumas wajaun wainkauwai. Nunik wajas chichajak: “¡Witjai Tuke Pujuu, Apajuínuk, amina apachjum Abraham, nuigtu amina apa Isaac emematujaku aina nunuwaitjai! ¡Juju nugka juwi ame tepam junak amina, tuja amina uchigmin uchiji wegantu agtina nudau atinun amastatjai! ");
INSERT INTO agr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Dita aidauk kuashat yujakag, nugka yukukuntu dekapamainchauwa iman agtinai. Iman asag ashí nugka pampankag etsa minitaiya aatus, etsa akaetaijiya ajashkam, tsumujiya aatus, nujinmaninishkam ashí yujakagtin ainawai. Ashí aents nugkanum batsatuk aminí, nuigtu ame uchijum aidau wegantu agtina nuwishkam, pegkeg yumigkin jukiagtinai. ");
INSERT INTO agr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Untsu wi amijaig pujajai. Nuniau asan tuwig wekaetam nuniakminish wi kuitamkattagme, dutikakun awagkin juju nugka juwi itattajame. ¡Makichkish wi amina anagkuajam nunak umitskek idaisashtatjai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Tusa Apajuí tima Jacob shintaag, anentaimas: “¡Dekas Tuke Pujuuk juimpap pujawa, nuniaigkiap wika nunak dekachmaja!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Nuna tusa senchi ishamkauwai, nunik anentaimas: “¡Juju nugka juka Apajuí etegkamu dekas shiig pegkegmai, juwi dekas Apajuí jeeg awai! ¡Juwi dekas nayaimpin waitijiya duka awai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nunik kanag tsawak kashikmas nantaki, kaya nii atamjukbaujin juki inantai apujus, aceiten juki ukatuk, juka Apajuínu atin ati, tusa ukukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Nunú nugkanum aajakui yaakat Luz daagtin, nuna Jacob yapagtua Betel adayak ukukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nunú nugkanum Jacob nii umiktinjin juna aatus tiuwai: “Apajuí mina uyuuntakug, wi yamai wetatag duwish nigki kuitamjak, wi yuwatnunash sujus, wi nugkumainnashkam sujustatui. ");
INSERT INTO agr_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Tuja wi iwaku jatsuk pegkeg ataktu wakitkin mina apaju jeen taanuk, Apajuíya nuna emematkun umigkattajai. ");
INSERT INTO agr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Wi juna kayan awajain apusag juka, atakea duwish Apajuín jee tama atinai. Tuja Apajuíjuh, ame mina sujustinaitam nuwiyanak aminu atinun diezmon tuke amasnuke atinaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob Betelnum pujau ukuki, etsa minitaiya nuni weuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Nunik wesa yumigmat taimunum ayaumas kampatum aents uwigjintin aidau, uwig nuwiyan yumin umin asagmatai, maki makichik ditá uwigji aidaun ijumag ayamainak batsatun wainkauwai. Nunú yumigmatak kaya múuntai dukukbau aajakui. ");
INSERT INTO agr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tuja nuwi ashí uwig aidau tuwakmatai, uwijan kuitamin aidau nuna kayan ujakag yumin shikik dita uwigjin aajag, nuadui ataktu kaya juki dukukag ukujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Nunú uwija kuitamin aidau nuwi batsatun Jacob wainak iniak: “¿Mina kumpag aidauh, atumesh tuwiya ainagme?” tau. Tama dita aínak: “Jutiik yaakat Harágnumia ainaji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Tiagtai Jacob ataktu ditan iniak: “¿Atumesh Labán Nacoran uchijiya dusha wainchaukujum?” tau. Tama nii ayaak: “Ehe wainnuji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Tusa tiagtai Jacob ataktu iniak: “¿Niish pegkejak puja?” tau. Tama uwija kuitamin aidau: “Ehe, Labágkak pegkeg pujawai. Nijah diisia, juwi Raquel niina nawanji uwijan yajuak minawai”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Tiagtai Jacob chichaak: “Etsa atushat awa nuniaigkik uwijak chimpia epenik ukumaitsui. ¿Wagka yumi aakjum duwi yajuakjum ataktu chijichin egakag yuwatnume tatsugme?” tau. ");
INSERT INTO agr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tama dita chichainak: “Atsa dutikmaitsuji. Eke dakaji ashí uwig tuwakmatai, nuna kuitamin aidaushkam kaunamtai, duwi yumigmat kaya múuntai dukukmawa nunú ijuntuja shitaki ekeka, uwig yumi aaka nuadui shiyaktatji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Aatus Jacob ditajai chichaak ijunai, Raquel niina apaji uwigji aidaun kuitamjin asa, uwijan saas tantauwai. ");
INSERT INTO agr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Nunik tatatman wainmawaik, Jacob yumigmatan jegantun, kaya múun apujtuam aun, shitaki eketuk, nigki yumi shikijuk niina dukuji umayi tagkujin aakui. ");
INSERT INTO agr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Nuna dutika Jacob Raquelan jegantun niina yapiin kugkuas kumpama shiig aneamunum buutiuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Tuja Jacob chichaak: “Wika Rebeca uchiji Labágka awegaitjai”, tusa Raquelan ujakui. Tusa ujakam, Raquel tupikaki weuwai niina jeen apajin ujaktatus. ");
INSERT INTO agr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Nuna Labán antuk, niina umayi Rebecan uchiji asamtai, tupikatki jiintukiuwai kumpamatatus, nunik igkug pagkuk yapinum kugkuas kumpama duwi niina jeen jukiuwai. Dutikam Jacob niina diichjin ashí nii wajukaya tupikaki wekaewa nunak betek ujakui. ");
INSERT INTO agr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Dutika ashí ujakam Labán niina chichajak: “Amek dekas minak shiig pataajuitme”, tiuwai. Jacob makichik nantu Labágkai pujusui. ");
INSERT INTO agr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Nunik pujusmatai Labán Jacopan chichajak: “Amek mina pataag akumesh, tikima wainkamek takagtuk pujumaitsume. ¿Wajupa akigkati tusamea wakegame? nunú tujutta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Tuja Labágka nawanjig jimag aajakui: iwai daajig Lea aajakui, untsu ekeu daaji Raquel aajakui. ");
INSERT INTO agr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leak imanikag shigmachu aajakui, untsu Raquel ashí niina iyashijai shigmauch aajakui. ");
INSERT INTO agr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob Raquelan senchi wakejuku asa, chichaak: “Wika amina nawanjum ekeuwa nuna jukitag tau asan, takagsatjame siete mijadai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Tusa tutai Labán niina ayaak: “Tikich aentsun sumainaitag nuna dekas amina amastajai. Amesh jutijai pujustin ata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tusa tima Jacob Raquelan jukitag tau asa siete mijan takasui. Tujash imaan mijan takakush niig Raquelan senchi wakegau asa, ujumchik tsawanta nunin diisui. ");
INSERT INTO agr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Nuna mijanan ejeyi Jacob Labágkan chichajak: “¡Yamai nawanjum sujusta, nuwatkatjai! Wi niina jukitasan imaan mijan takastajai tibaunak betek ejejai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tusa tima Labán ayu tusa, ashí aents nuwiya aidaun ipauwai nawanji aishinbaunum jiistamatag tusa. ");
INSERT INTO agr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tujash Labágkak kashi niina nawanji Lean juki ejetiuwai. Dutikam Jacob juki niijai kanajui. ");
INSERT INTO agr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Dutika nuigtushkam niina inataiji aidaun makichik Zilpá daagtinun Lean susauwai niina yaigtinun. ");
INSERT INTO agr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Nunik Jacob kanag tsawak, wainkauwai Leajai kanagbaun. Nuadui kajeka Labágkan chichajak: “¿Wagka minash jutijame? ¿Wi Raquelan jukitag tau asan amina takagsachmakjam? Dutikamu ayatkumesh ¿Wagka minash tsanujaume?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Tusa tama Labán ayaak: “Juwiya aidautik iina nawanji iwai aishintsaigkik ekeuwa duka sujuchu ainaji. ");
INSERT INTO agr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Kame ii nuwenku tuke nunitaiya nunú makichik semana ejeta. Nunikamin ame siete mijan nuigtushkam takastajai takuminig, Raquelnashkam amastajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Tusa tama Jacob ayu tusa makichik semanan ejeyuwai. Nunikmatai Labán Raquelnashkam susauwai. ");
INSERT INTO agr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Dutika nawanji Raquelan sujuk, nii inagtinun nuwa Bilhá daagtinun susauwai, niina yaigtinun. ");
INSERT INTO agr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Aatus Jacob Raquelan nuwatkauwai. Nunik niina ima senchi, Lean nagkesau aneau. Nunik pujus nuigtushkam siete mijan Raquel jukimunum Labágkan takajak pujusui. ");
INSERT INTO agr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jacob Lean imatikas aneachun Tuke Pujuu wainkauwai. Nuadui Leanak Apajuí uchi uchigbau awajsauwai, untsu Raquelan uchigmachu ema apusauwai. ");
INSERT INTO agr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Tuja Lea ejapjuk aishmagkun uchigmakui. Dutika Rubén adaikauwai, wagki nuna uchigmak chichaak: “Wi wake besemag pujamun Apajuí waitkau asa wait anenjuje. Nuadui yamaik mina aishjuk anentatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Nunik pujus ataktushkam patasag uchigmakui, dutika adaikauwai Simeón. Nuna uchigmak chichaak: “Tuke Pujuu mina dakitjuinamun dekau asa, minak tikich uchinash sujuse”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Tuja nuigtushkam ejapjuk uchigmakui, dutika adaikauwai Leví. Nunak: “Yamaik mina aishjuk wijai ijunag pujuttawai, wagki kampatum uchin uchigmatkag duwi”, taku tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nuigtushkam ipak usumta nuna ejapjuk uchigmakui, dutika adaikauwai Judá. Nuna uchigmak chichaak: “Yamaik Tuke Pujuun ememattatjai”, taku tiuwai. Tuja Leak nunák uchigmak nagkankauwai. ");
INSERT INTO agr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raquel Jacopa uchijin uchigmatchau asa, niina kai Lea uchigmatu asamtai kajejujakui, nuadui niina aishin chichajak: “Minash uchi sujusta, sujachkuminig jakattajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Tusa tama Jacob Raquelan kajejuk chichajak: “¿Wikaitag Apajuín? Apajuí aminak uchinak amatsui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Tusa tama nii ayaak: “Nijah, untsu mina inakeg Bilhá nuwatkata; dutikawamin nii uchigmakmatai, nuna wi uchigmakmawa dutikan uchijimatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tusa Raquel Jacopan niina inake Bilhájai nuweauwai, ikaa nuwe atinun. Dutikam Jacob Bilhán nuwatuk, ");
INSERT INTO agr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","pujus ejapmitkakui, dutikam pujus Jacopa uchijin uchigmakui. ");
INSERT INTO agr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Nunikmatai Raquel chichaak: “Apajuín wi segamag nuna antugtuk pegkegchau takachbaun diigtus juna uchin midau atinun sujuse. Nuadui juju uchi daajig Dan atatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tuja ataktushkam Bilhá ejapjuk jimaja juna Jacopan uchigmatkauwai. ");
INSERT INTO agr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Nunikmatai Raquel chichaak: “Mina kaijun depetkatag tusan maa maaniakuan yamaik depetkajai, nuadui juju uchik Neftalí atatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Tuja Leashkam uchin uchigbauwaitak, uchigmamainchau dekapeak, niina inake Zilpán Jacopan susauwai, niina ikaa nuwe atinun. ");
INSERT INTO agr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Dutikam pujus Zilpáshkam ejapjuk Jacopan uchigmatkauwai. ");
INSERT INTO agr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Nunikmatai Lea chichaak: “¡Yajau jukichjai! Nuadui juju uchi daajig Gad atatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nuigtushkam tikichin uchin Jacopan uchigmatkauwai. ");
INSERT INTO agr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Nunik uchigmakmatai Lea chichaak: “¡Chah, shiig aneajai! Yamaik tikich nuwa aidau chichagtuinakush, Leak shiig aneas pujawai tujutiagtinai. Nuadui juju uchi daajig Asher atatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Tsawan trigo juutai jegamunum, makichik tsawantai Rubén ikam weuwai, nunik nuwi wekagas yujág mandrágora tutain wainak juuka niina dukuji Lean itajuauwai. Nuna Raquel wainak Lean chichajak: “Minash wait aneasam uchijum mandrágoran juuka itagtama nunú ajampusta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tusa tama Lea ayaak: “Ame mina aishjuk atanjukmayum duke nagkanmainchauk, ¡yamaish mina uchig yujág mandrágoran juuka itaa dusha atanjuktag tame!” tau. Tama Raquel ayaak: “Kame amina uchijum yujág mandrágoran juuka itaa anú minash sujusta, juju kashia duwi amesh Jacobjai kanagminum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Tusa tima, nunú kashia duwi Jacob ikam weu wakitki minittaman, Lea jiintuki igkug chichajak: “Yamaik amek wijai kanagtatme, wagki mina uchig mandrágoran juuka itagtuamtai nujai sumakjame”, tiuwai. Tusa tima Jacob Leajai kanajui. ");
INSERT INTO agr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nunik nii Apajuí segamunak betek antugkamu asa ejapjuk, cinco uchia nuna uchigmakui. ");
INSERT INTO agr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Nuna uchigmak Lea chichaak: “Juju uchia juna daajig Isacar atatui, wagki wi mina aishjun mina inakjujai nuweamag, duwi minak Apajuí juju uchin sujuse”, taku tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Tuja nuigtushkam Lea Jacopan seis uchia nuna uchigmatkauwai. ");
INSERT INTO agr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Nunik chichaak: “Junak Apajuí minak shiig anenjus wainkauch sujuse. Nuadui yamai mina aishjuk ima shiig eme anenjittawai, wagki seis uchin uchigmatkag duwi. Nuadui juju uchia juka Sabulón atatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Duwi pujus Lea inagnamun makichik nuwauchin uchigmakui, dutika Dina adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tujash Apajuík Raquelnashkam kajimatkig idaisachui, nuadui nii segamunashkam antugkau asa uchin susauwai. ");
INSERT INTO agr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Dutikam uchigmachu pujau uchigmak chichaak: “Uchi uchigmachkun datsaama wekaenuweg nunak datsannak Apajuí emegkatjuke. ");
INSERT INTO agr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ataktush Tuke Pujuuk tikich uchinash sujumainapi tajai”, tau. Nuadui uchi daajin José adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raquel Josén uchigmakmatai pujus. Jacob Labágkan chichajak: “Minash wait aneasam agkan idaitusta, mina nugkajui wakitkitjai. ");
INSERT INTO agr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mina uchig aidau, tuja duwag aidaushkam sujusta, wika ditan jukitag tau asan amina takagsamjame, nuadui minash agkan idaitusta, wakitkitjai. Amek shiig dekame, wi wajuk amina takagsajame duka”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Tusa tama Labán ayaak: “Wait aneasam wetsuk jutijaig pujusta. Ame pujau asamin, Tuke Pujuu minash pegkegnum yainkae, nunak wika makichik aents anentaimas dekamin tujutmatai dekajai”, tau. ");
INSERT INTO agr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tusa nuigtu chichajak: “Untsu tujutta wajupa akigkati tusamea wakegame, nuna akiktajame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Tusa tama Jacob niina chichajak: “Wi wajuk amina takagsajame, tuja nuigtush wajuk amina kuntinjumnash kuitamjukjame dushakam amek shiig dekame. ");
INSERT INTO agr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Tuja wi juwi tatsaigkik tagkugmek kuashtachu ayi, tujash wi taa pujusa kuitamam kuashat tagkujum kawenjamkae. Tuke Pujuu aminak yaimpake; tujash ¿wajutiya wisha mina uchigdau agtinnash takastatja?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Tutai nii ayaak: “¿Tujash wajupa akigkati tusamea wakegame?” tusa ataktu awagki iniasui. Tama nii ayaak: “Minak makichkish akigkaipa. Untsu wi amina titatjam nunú ayu takuminig, wisha amina uwigjumin kuitamjuktatjame. ");
INSERT INTO agr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Dutikatin asan wi ame takagsamunum akigmainaitam nuna dekas amina uwigjum batsata nuwi yamai wenu uwig tsakat aidaun, chivo tsakat aidaujai bukusea aidaun, tuja bukusea apujtugbau aidaunashkam, nuigtu utsak aidaujai ashí ijumjan jukitjai. ");
INSERT INTO agr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tuja wi nuna uwig tsakat bukusea aidaun, nuigtu chivo tsakat utsak aidaujai ijumjamtai, nunú diisam dekaskeapi tujuttatme, untsu nunú diikman, nuninchaukesh pachitkau wainkamek kasagtukeapi tujutta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Tusa tama Labán: “Ayu, ame tame duka nunisag ati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tujash nunú tsawantaik Labán chivo painch aidaun, utsak aidaujai, nuigtushkam chivo nuwa utsak aidaunak, tuja bukusea apujtugbau aidaujai, nuigtu uwig bukusea aidaun aatus yajuak ijumag niina uchiji aidaun tinamkauwai kuitamkatajum, tusa. ");
INSERT INTO agr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nuna dutika idayak, niina uchiji aidaujai, Jacopak eke dekatsaig, ashí nuna yajuakag uumak jiinkiag, kampatum tsawan atushat shiyakajui. Nuna Labágkak dutikak wekagai, Jacopak tikich uwig Labágdau aidaun kuitamak pujau. ");
INSERT INTO agr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Nunik pujus numi álamo, almendro, castaño kanawen tsupig yajuak, saepenak ashí pakatsuk, ayatak piipichin tsentsaja yajutkauwai painch wajasti tusa. ");
INSERT INTO agr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Dutika umika kuntinun batsamtain nuwi yumi amutaiji aunum nuna ijus ajigkui. Dutikamunum nuwi entsamjunidau asagmatai, uchiji painch aidau, bukusea apujtugbau aidaujai, nuigtu utsak aidau aatus akiinaidau. ");
INSERT INTO agr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Nunik Labágka uwigji petsainamu utsak aidau, bukusea aidau aatus akiinaidaunak Jacob yajuak niinu atinun akanak ijumjauwai. Dutika yajuak niishkam kuashat kuntinjintin wajasui. Nuadui Labágdaunash akanak ijumag, niinunashkam akanak ijumjauwai. ");
INSERT INTO agr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Dutika nuigtushkam uwig dekas duwejam aidau entsamjuniagtaik, nunú entsamjuninak wainkatnume tusa Jacob payagkun juki, uwig aidau yumi umuinak ijuntaijin aepjujakui. ");
INSERT INTO agr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tujash uwig watsaju minitaik, payagnak aepjujakchauwai. Nuadui kuntin watsaku aidauk Labágdau aajaku ainawai, untsu kuntin duwejam aidau Jacobdau aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Dutika yaju yajumkawa Jacopak shiig wiakuch wajasui. Niig kuashat uwigjintin, tuja inake aishmag aidaush, nuwa aidaush shiig kuashat, tuja camellojishkam imanisag, burrojishkam ¡shiig kuashat aajakui! ");
INSERT INTO agr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Labágka uchiji aidau Jacopan pachis augmatuinak: “Jacopak, iina apajinu aajakua nuna ashí yajuaku asa, imanik shiig wiakuch wajase” tusa chichaidaun dekauwai. ");
INSERT INTO agr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Tuja Jacobshakam Labán niina yaunchuk shiig anentujakua nunak, imanis shiig awagmachbaun wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Nuadui Tuke Pujuu Jacopan chichajak: “Amina apa nugken pataim aidau batsata nuwi wakitkita, wi aminak uyuntsattajame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Tusa tima Jacob niina inaken awemauwai Raquel, Leajai ujakam itagtuatajum, wi uwija kuitamkun pujag juwi kaunatnume tusa. ");
INSERT INTO agr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Tusa timatai ujakam, nuwe aidau kaunamtai chichajak: “Atumin apa yaunchuk mina shiig anenjuya nuniachun wainjai; tujash mina apaju Apajuíjiya nunú tuke minak uyuntawai. ");
INSERT INTO agr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Atumek shiig dekajume, wi atumi apanun shiig kuitamsan pegkejan takagsauwaitag duka. ");
INSERT INTO agr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Imatika takagmaitak, nii minak imaan akiktajame tujutbaunak tsanujug, nuna yapajia midau amainnak sujatsui. Tujash nii dutijutaishkam, Apajuíya duka minak tukek idaituschae, Labán pegkegchau awajkai tusa. ");
INSERT INTO agr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nuadui Labán chichaak: aminak kuntin bukusea apujtugbau aidaun petsagtata nuna akiktajame tusa tujuttaik, ashí kuntin nuwa aidauk imanisag bukusea apujtugbaun petsagmayi; nuniagtai ataktu yapajia chichaak: yamaik dekas kuntin painchin petsagtata nuna akiktajame tusa tujuttaishkam imanisag petsagmayi. ");
INSERT INTO agr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nunak Apajuí Labágka kuntinjin atantug mina sujustatus dutikmayi. ");
INSERT INTO agr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Makichik tsawantai uwig entsamjunit jegamunum, kajanum wainkabiajai kuntin aishmag painch aidau, bukusea apujtugbau aidau, nuigtu utsak aidau aatus uwig nuwa aidaun entsamjuidaun. ");
INSERT INTO agr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Nuna dii wajai, Apajuí ángel tumain kajanum mina daajun adayak untsugkabi, tujutkui wi ayaakun: ‘Juwi pujajai’ tibaijai. ");
INSERT INTO agr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“Tusan tai nunú ángel chichagtak: ‘Yamai juu shiig diista, ashí kuntin aishmag nuwan entsamjuina duka bukusea apujtugbau aidau, painch aidau, nuigtu utsak aidau aatsam wainkattame. Wi junak amina Labán shiig akigmatsu nuna wainu asan jutikajai’, tujutmayi. Tusa nuigtu chichagtak: ");
INSERT INTO agr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","‘Witjai Apajuí, amina Betelnum wantintukmaijam nunú, nuwi ame kaya jukim juka Apajuínu ati tusa timayume. Dutikakum ame umiktin aidaushkam anagtuabiume. ¡Wamkesam juju nugka juka ukuakum ame akiinamugmia nuwi wakitkita!’ tusa tujutmae”, tiuwai Jacob. ");
INSERT INTO agr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Tusa tutai Raquel Leajai ayaak: “Iik iina apaji jakush niinu aina aunakesh juju atumdau ati tusa ukugtamkimtaig jukishtin ainaji. ");
INSERT INTO agr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Iina apajig tikich nugkanmaya nuwa amaina anin yamaik anenjamji. ¡Iina sujupakush, waji akik sujutia dutika sujupaku asa, ame takagsam niig pujawai! ");
INSERT INTO agr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Nuadui dekas Apajuí ashí iina apajinun yajutuk amina amasa auk iinu ainawai, tuja iina uchijinu aidaujai, nuadui amina Apajuí wajinjutpame duka dutiksamek ashí umikta”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Aatus nuwe aidau tiagmatai, duwi Jacob umintsauwai, niina apaji Isaac Canaán pujujakua nuwi wakitkitatus. Nunik weak niina uchiji aidaun, nuwe aidaujai, camellonum pekainiuwai, tuja wajiji aidaunashkam ashí jukiuwai, nunik Padán-aram pujusa takaku kuntin jukimu aidaun yajuak jintanum amanag ashí umikui wetatus. ");
INSERT INTO agr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Tuja Labágkak tikich yantamnum uwija ujen tsupijatatus weu ai, Raquel niina apaji apajuímtaiji dakumka najanamu atatman kasamak juki ukukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Aatus Jacopak Labán amorreo aents aajakua nuna wika tupikatsjai tusa tsanug ukukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nunik weak ashí niina wajiji aidaunak yajuak tupikakiuwai. Nunik shiig wamak, namak Eufratesan nagkaiki muja Galaad tutaya nuni weuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Nunik Jacob tupikaki kampatum tsawan wegai Labán dekauwai. ");
INSERT INTO agr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Nunik niina patayi aidaun ipaa pataetuk wea weakua siete tsawanta duwi muja Galaadnum batsamtatman amaigkauwai. ");
INSERT INTO agr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Tujash nunú kashia duwi Apajuí kajanum Labán arameo aentsua nuna wantintuk chichajak: “¡Antukta nijah, Jacob augkumesh pegkegnum ausata, wainkam pegkegchauk chichagkaipa!” tusa tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Tusa tima wea weakua muja Galaadnum aakan aakmajag batsamtatman amaigkauwai. Dutika niishkam nuanuig ashí niina patayi aidaujai aakan aakmakag pujusajui. ");
INSERT INTO agr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Nunik nuwi Labán Jacopan chichajak: “¿Wagka amesh jusha juniame? ¿Wagka minash tsanujaume? ¡Amek mina nawantug aidauk nuwa maaniaku bisatkama yajumtaya numamtuk awajkaume! ");
INSERT INTO agr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Wagka tsanujamesh uumjutkamesh mina aujtuskesh tupikakiume? Wi dekauwaitkunuk, shiig anentsan kantamjukin tampujan arpajai awatuinakui, shiig jiistamjuan akupmain awajkashjamek. ");
INSERT INTO agr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Amek minak niish nawanjinash, niina tijaji aidaujaí shiig kugkuas kumpama akupkati tusamesh dakagsachume. ¡Duka nunitsuk aents anentainkachu wajukmaina numamtuk wajakume! ");
INSERT INTO agr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nuadui wika atumnak pegkegchau awagmamainaitkun, amina apa Apajuíjiya nunú kajanum chichagtak: ‘Jacob augkumesh shiig ausata, wainkam pegkegchau chichagkaipa’ tujutma nuadui pegkegnum augjame. ");
INSERT INTO agr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Amek yaunchuk nagkamsam amina apa jeen wakitkitasam wakemaum duwi miniume, tujash nunika minakmesh ¿wagka mina apajuímtaig aidaush kasagtukmesh miniume?” tau. ");
INSERT INTO agr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Tusa tama Jacob Labágkan ayaak: “Wika amina ujamainnash, namputchawame niina nawanjin japiki emetjutuawai tusan ishamkagtakun ujakchamjame. ");
INSERT INTO agr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Untsu amina apajuímtaijum aidau kasamkaume tujutam dusha ya takakuk wainkatam, dutikawaminig duka, ¡mantamnati! Iina patayi aidau ijunas waipainai, wisha wajina aminunash jujukjame nunú egakam jukita”, tiuwai. Nunak Jacopak Raquel niina apaji apajuímtaiji kasagkamunak dekachu asa tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Aatus Jacob timatai, Labán Jacopa aakji carpa aakmakbaunum waya egaka, nuigtu Lea aakjin waya egaka, tuja jimag nuwa inak aidau aakjinchakam ashí egakui. Tujash imatika egakush wainkachui. Nunik ashí egaka wainkacha Lea aakjin pujau jiinki wayauwai Raquela aakjin. ");
INSERT INTO agr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Nunik apaji waitai, Raquel dakumka najanamu jukimujin camello tuntupen patai nuwi waka nuna ekeemtuk ekemsauwai. Nunik eketai Labágkak ashí egakui, tujash makichkish wainkachui. ");
INSERT INTO agr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Nuna egak wekagun Raquel chichajak: “Apawah, kajekaipa, wi juwi eketag nuna akaikin kumpamtsujam nunak, mina tsawanjui jau asan aniajai”, tiuwai. Tuja Labágkak imatika egakushkam niina apajuímtaijinak wainkachui. ");
INSERT INTO agr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Nunikmatai Jacob kajeka niina chichajak: “¿Wajina wisha pegkegchaunash dutikaja? ¿Tuna wisha pegkegchaunash takamsamtaiya imanikmesh wakeketash pataetugkaume? ");
INSERT INTO agr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ame mina aakjui wayam mina wajiig aidau ashí diisum duwish, ¿amina wajijum aidau jukimush tuu wainkaume? ¡Nunú wainkamek amina pataim ijuna juna emtin juwi itantam aepsata, tuja mina pataag ijuna nuna emtinishkam! Nuna wainak dita titinme yaki waitjawa, ameash waitjam, atsa wiyash waitjag nuna. ");
INSERT INTO agr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Wi amina veinte mijadai takagsamjam nuaduik, amina uwigjum aidauk tuja cabrajum aidaukesh makichkish uchijinak pegkegchaun petsakag ajapachui; tuja wikish makichik uwig tsakatchinakesh maanuk aminunak yuwachuitjai. ");
INSERT INTO agr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Nuigtushkam makichik kuntinjumnakesh ikamyawa maamunak itajuachuitjame, tuja kuntin megkaekuish, nunak wi akiyajame; tuja tsawaigkish nuniachkush kashikesh kuntinun kasamkagmataish, mina segatkumin wi akiyajame. ");
INSERT INTO agr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tsawai takaknush etsayai jamain dekapiajai; tuja kashi takaknushkam tsetsekai waitiajai, ¡imaniakun shiig aneasa kanumainchau dekapiajai! ");
INSERT INTO agr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Imanikan waitiaknush veinte mijan amina jemin takakun pujusuitag duika ¿mina jutik akijam? Amina nawanjum jimaja juna jukitasan takagsawaitjame catorce mijadai; tuja amina kuntinjumin kuitamkunchakam seis mijan takagsawaitjame. Imaniaish amek imaan akiktagme tusa anagtuawaitkum betek akigtsayume. ");
INSERT INTO agr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Abrahama Apajuíjin, mina apag Isaac emematia nunú mina yainchakuig, amek minak dekas wi takasbaunmak makichkish akigtsuk akupjumain awajtukume. Tujash wi senchi takaku wake besemag pujamun Apajuí waitjuku asa, aminak nii kajanum jiyapakume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Tusa tama Labán Jacopan ayaak: “Juju jimag nuwa aina juka mina nawantug ainawai; tuja uchi aina jushakam mina tijagkig ainawai; tuja uwig aina jushakam midau ainawai, nuadui ¡ame ashí juju wainam juka midau ainawai! Tujash ¿wisha mina nawantug ainakuish, nuigtu mina tijagkig ainakuish itugkatjaki? wika emetmaitsujai. ");
INSERT INTO agr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Nuadui amesh taata, núnikamin juwi amejai chicham umikmi, ii umigdaikatna nunú”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tusa timatai Jacob kaya juki inantai apujus, ");
INSERT INTO agr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","niina patayi aidaun chichajak: “¡Kaya juuktajum!” tusa tima kaya juukag ijumag tsakapiajui, dutikawag nunú kaya ijumja tsakapimunum ayaumas pujusag dita chicham umikbaun iwainainak yutain yuwawajui. ");
INSERT INTO agr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Nunik nagkanainak Labán nunú nugka daajin adaikauwai niina chichamen “Jegar Sahadutá”, tuja Jacobshakam niina chichamen adaikauwai “Galaad”. Nunak kaya ijumjamu taku tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Nuna dutika inagnakag Labán chichaak: “Ii yamai chicham umikag juka juju kaya ijumjamua nunú wainku tuke aneasaiki atinaitji”, tiuwai. Nuna taku nunú nugkanak Galaad adaikau ainawai. ");
INSERT INTO agr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Tusa nuigtushkam “Mispá” ati tiuwai, wagki nunak Labán chichaak: “ ‘Apajuí iina mai atushat pujajinchakam diigmaku ati’ taku tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Tuja ame mina nawantug shiig kuitamtsuk waitkamunash, nuniachkumesh dita ayakiatkum tikich nuwa aidaujai nuwenmin amina waipak etsegtugmamain atsutaish, ima Apajuíya duke nii waipau asa ame wajuk pujuttame nunak ashí nigki dekaatin ati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Nuna tusa nuigtushkam ataktu awena Jacopan chichajak: “Antukta nijah, juju kaya ijumjamu aina nunú, tuja tikichin kayan inantain apusag juju ");
INSERT INTO agr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","nagkaikimek amesh wayashtinaitme, tuja wishakam antsanuk juna nagkaikinuk wayashtinaitjai, nunú nuniakuik waitkanimain asamtai. ");
INSERT INTO agr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Amina apachjum Abrahaman Apajuíjiya nunú, nuigtu mina apachug Nacoran Apajuíjiya nunú ii umikag nunak diistin atinme”, tiuwai. Tusa Labán timatai, Jacob niina apaji Isaac Apajuín emematujakua nuna pachis nii umiktinjin niishkam dutiksag: “Aatus ati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Nuna umika, nuadui, Jacob kuntinun maa nunú mujanum nuna apeak Apajuín emematiuwai. Dutika nuna nejen ashí apeachu asa patayi aidaun ipaa ashí ijuntujag yuwawajui, nunikag nunú mujanmak kajigkajui. ");
INSERT INTO agr_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nunik kajigkag tsawamunum, Labán kashikmas nantaki, niina nawanji aidaun tijaji aidaujai yapinum kugkuas kumpamak, pegkegnum yumigkig nuadui niina nugken wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Nunik Labán wakitkimtai Jacob nuwi nagkaemaki wegau. Nunik wetatman Apajuín aentsji ángel aidau jiintujajui niina igkugtatus. ");
INSERT INTO agr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Nunik minidaun Jacob wainak chichaak: “Juka Apajuín suntaji ainawai”, tiuwai. Nuadui nunú nugka daajin adaikauwai Mahanaim. ");
INSERT INTO agr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Dutika ukuak nuwi juwaki wesa niina yachi Esaú nugka Seír tutai Edom nugkanum awa nuwi pujuttaman, yatsum minawai tusajum ujatjuktajum tusa, niina aentsji chichama etsejin aidaun ishitkauwai. ");
INSERT INTO agr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Dutika ishimak aatus akatmamjauwai: “Wika nii tabaun umiktasan, kuashat tsawan Labágkai pujaun ukukin minajai. ");
INSERT INTO agr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Tuja baka aidau, burro aidau, uwig aidau, nuigtu iinak aishmag aidau, nuwa aidaushkam kuashat ajutui, juna susatjai dutika ai mina apug wait anenjugmatai, niijai kumpamdayatjai tajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tusa akatja ishiakam chichama etsejin aidaushkam shimutuk Esaún ujaka ukuinak, waketug kaunawag, Jacopan chichajuinak: “Amina yatsum Esaúk ame akatmamjamum duka imatiksaik ujakmaji, dutika ujaka ajin, ayu igkugtajai tusa, cuatrocientos aentsun yajuak minitjamae”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Tusa ujakam Jacob senchi ishamkauwai, nunik kuashat anentaimu. Nuniak aents niijai yujaidaun jimajan akanak ijumjauwai, dutikak uwig aidaun, baka aidaun, camello aidaunashkam dutiksag akanag ijumjauwai. ");
INSERT INTO agr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Nunak nii anentaimas: “Yaja aneas Esaú jetepataish, juju aents aidau akanka ijumjamua nunú maaniaimpap, tikich aina au tupikakiag uwemain ainawa”, tusa dutikauwai. ");
INSERT INTO agr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Nuna dutika Apajuín segaak: “Tuke Pujuuwah, mina apachug Abrahaman, tuja mina apag Isaakan Apajuíjiyah, ame mina chichagtakum, amina nugkemin pataim batsata nuwi wakitkita, wi yaigtatjame tujutmaume. ");
INSERT INTO agr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Wika tikima wainkauch aig, ame minak wait anenjau asam yainkaume. Yaunchkek wika juju namak Jordágka junak ima mina ushujutaignak takusan katigkabiajai, tujash yamaik ame yaintsamin kuashat aents aidaush ajutui, tuja kuntin aidaushkam imanisag ajutui, nuadui kuashat asamtai, jimajan akankan ijumjajai. ");
INSERT INTO agr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","¡Wait aneasam agkanmitkajuata mina yatsug Esaú mantuawai! Wika ishamajai, mina jetetak ashí mina duwag aidaun, mina uchig aidaujaí amutkai tusan, tajame. ");
INSERT INTO agr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ame chichaakum, wi aminak kuitamkattagme, dutikakun amina uchijum wegantunak nayantsa kamatkaji dekapamainchauwa iman awagsatnaitjai tujutmayume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacob nuna aatus Apajuín segaa kiitai, nuwig tepes kanajui, nunik tsawag, niina tagkuji aidaunmayan akanjauwai yachi Esaú susatnun. ");
INSERT INTO agr_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Dutikak doscientos chivo nuwa aidaun, veinte chivo aishmag aidaun, doscientos uwijan, nuigtu veinte uwig tsakat aidaun, ");
INSERT INTO agr_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","treinta camello nuwa yama petsaku aidaun ashí uchijijai, cuarenta baka, diez toro aidaun, veinte burro nuwa aidaun, nuigtu diez burro aishmag aidaun aatus akanag ijumjauwai. ");
INSERT INTO agr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Dutika duwi niina inake aidaun, maki makichik kuntin akanjamun tinamkauwai, dutika chichajak: “Atum emkatajum, tujash betek ijutkau wetsuk, makichik kuntinun ujuikimtai, duwi tikich kuntin aidaushkam saaktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Nuna tusa aents eemak wetinun chichajak: “Mina yatsug Esaú amina igkumpak: ‘¿Yaita amina apugmesh? ¿Tuja tuu weakmea aniame? ¿Juju tagku yajuaka minam jusha yanau ainawa?’ ");
INSERT INTO agr_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Tusa tujamkuig ame ayaakum: “ ‘Apujuh Esaú, juju kuntin aina juka aminu ainawai, junak Jacob amina inakmea nunú awetugmame. Tuja niishkam iina ukujin minime’ tusam ujakta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Nuna tusa, tikich aidau kuntinun yajuak wedaunashkam chichajak: “Atumshakam Esaú igkumpakuig dutiksagmek chichaktajum. ");
INSERT INTO agr_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tuja nuigtushkam: ‘Amina inakem Jacob iina ukujin minime’ tusajum titajum”, tiuwai. Nuna tiuwa nunak Jacob anentaimas, dekas kuntinun emtikan ishitkatjai dutikan nii kajekbaujin etsagjan, nuadui wisha niijai wainiaktajai. Namputchawame nuna wainkash shiig anenjus jujukchaintash, tusa dutikauwai. ");
INSERT INTO agr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Aatus ashí emtika ishiak, nigka wetsuk niina aakjinig kanajui. ");
INSERT INTO agr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Nunú kashia duik, Jacob nantaki, niina nuwen mai juki tuja jimag nuwa inake aajakua nunashkam mai juki, uchiji once aajakua nujai ashí yajuak namak Jaboc tawa nuna amain ikatiajui. ");
INSERT INTO agr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Dutikak, ashí niina wajiji aidaujai ijumag ikatiajui. ");
INSERT INTO agr_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Nuna ashí ikatiag nigki juwak pujai, makichik aents tajuam niijai maa maaniakua tuke tsawampau; ");
INSERT INTO agr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","nunik tsawautai nunú aents Jacopan depetmainchau dekapeak, nantagnum awati manchamitkakui. ");
INSERT INTO agr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Dutika chichajak: “¡Akupjukta tsawawai!”, tau. Tusa tama Jacob ayaak: “¡Ame mina pegkegnum yumigtatsminigkik akupkashtatjame!” tiuwai. Tusa tama nunú aents Jacopan iniak: ");
INSERT INTO agr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","“¿Amina daagmesh yaita?” tau. Tama: “Wika Jacopaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Tutai nunú aents chichajak: “Amek yamai nagkamsamek Jacob tutaig achattame. Amina daagmek Israel atatui, wagki amek Apajuíjai maaniakmesh, tuja aentsjai maaniakmesh, depetmaku asam”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Tusa timatai Jacob niina iniak: “¿Amina daagmesh yaita?” tau. Tusa iniam nunú aents ayaak: “¿Wagka mina daag dekaatasamesh wakegame?” tau. Aatus tusa nunú aents Jacopan pegkegnum yumigjauwai. ");
INSERT INTO agr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Dutika ukukim, Jacob nunú nugka daajin Penuel adaikauwai, nunak: “Dekas Apajuínak shiig paantap wainkaja, imanun wainkanush jakachjapi iwakuap pujaja” taku tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Tusa ukuak Penuelan nagkaiki wegai etsa jiiniuwai; tujash niina nantajen najaimak shutus wegau. ");
INSERT INTO agr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Nuadui Israel wegantu aidauk yamaya juikish baku wajakbaunum neje achitka nunak yuchau ainawai, wagki nuwi Jacopan awati manchamitkakbau asamtai. ");
INSERT INTO agr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Nunik wesa Jacob wainkauwai niina yachi Esaú cuatrocientos aentsun yajuak minittaman. Nunik wainak niina uchiji aidaun yajuak, niina nuwe Leayai, Raquelai, nuigtu jimag nuwa inak aajakua nuwi aatus yununjauwai. ");
INSERT INTO agr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Dutika jimag nuwa inake aidaun uchiji aidaujai emtikauwai, dutika nuna ukuujin Lean niina uchijijai awantauwai, untsu inagnamunum Lea ukujin Raquelan Joséjai awantauwai. ");
INSERT INTO agr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nuna dutika ijumag ukuak nii eemak wajan, sieteya imania tikishmag tsuntsuma nijayin nugka antig waja wakakua yachi midaun jegantauwai. ");
INSERT INTO agr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tujash Esaúk tupikaki yachin igkug kuntujen achik kajut pagkuk kugkuasui. Nunik wajasag eganijajui. ");
INSERT INTO agr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Nunik Esaú niimkama nuwa aidau uchijijai ijunun wainak Jacopan iniak: “Jusha ¿ya ainawa?” tau. Tutai nii ayaak: “Aanka amina inakmin Apajuí uchin susauwa nunú ainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Timatai nuwa inak aidau uchijijai tikishmag tsuntsuma nijayin nugka antig pujusajui Esaún eme anentus. ");
INSERT INTO agr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Nunikagmatai Leashkam niina uchiji aidaujai Esaún jegantag ditashkam nunisag pujusajui. Nunú nuninai inagnamunum José Raqueljai jeganta ditashkam nunisag pujusajui. ");
INSERT INTO agr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Nuniagtai Esaú Jacopan iniak: “¿Wajuk anentaimsamea juju tagku aidaush emtikamesh ishiakmaume, dutikamunash wisha wai wainkawanush minaja?” tau. Tutai nii ayaak: “Juju aina juna juwak tsagkugtugti tusan ishitkamjame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tama Esaú chichaak: “¡Atsa yatsuju, minak kuashat tagkuk ajutui, aminu aina duka aantsag aminuk agtinme, sujusaipa!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Tutai Jacob ayaak: “¡Atsa, tutsuk wait aneasam jukita. Wika ame shiig aneasa jujukiu asamin, Apajuí wainka anentaimaina iman dekapeajai! ");
INSERT INTO agr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nuniau asamtai, wait aneasam wi ikautuajam juka jukita, Apajuí minak yaintsamtai wiakuch wajasjai, nuadui makichik atsumamukesh atsugtawai”, tiuwai. Tusa imatjam Esaúshkam ayu tusa jukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Nuna juki Esaú Jacopan chichajak: “Ayu wemi, wi emkatjai”, tau. ");
INSERT INTO agr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tusa tama Jacob ayaak: “Yatsuju mina aneetaijuh, amek shiig dekame uchi piipich aina juka kakakchau ainawai, tuja nuigtush uwig aidau, baka aidau yama petsaju asag uchiji piipichin saakuaske aina nuna puyatju wajajai; wagki wi senchi wetaik makichik tsawantaik uwig aidauk ashí jinumainai. ");
INSERT INTO agr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nunimain asamtai mina apujuh, amek emkata, wika diipasan mina tagkug aidaun, mina uchig aina nujai saasan mina minakuan ame pujamunum Seírnum taatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Tutai Esaú ayaak: “Ayu dekas tame, untsu wi aentsun saakag juna akankan amina yaimpaktinun ukugkitjame”, tiuwai. Tutai Jacob ayaak: “¡Atsa, wait aneasam tsagkugtugta! Yamaik imanikmek puyatjutkaipa”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tutai ayu tusa ukuak, nunú tsawantaik Esaú Seírnum wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yachi wakitkimtai Jacobshakam Seírnumak wetsuk, nugka Sucot tawa nuwi weuwai. Nunik nuwi jegaa niina jeen jegamak, nuigtushkam kuntin aidau aakjinashkam aakmatjauwai. Nuna dutikau asa nunú nugka daajin Sucot adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob Padán-aram pujau wakitki Canaán nugkanum jegauwai pegkeg, jamamtuchu utugchat atsaunum, nunik nuwi yaakat Siquem tawa nujai niinis pujusui. ");
INSERT INTO agr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Nuwi pujus Hamor Siquema apaji aajakua nuna uchiji aidaun nugken cien kuichik plata najanamun akikmak sumakui. Dutika nuwi niina jeen jegamag yaaktamauwai. ");
INSERT INTO agr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nuwi pujus, Apajuí emematku kuntin maa patasa apeatnun altaran najanauwai. Dutika adaikauwai El-elohé-Israel. Nunak Israelan Apajuíji taku tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Jacob Leayai akiamu Dina, makichik tsawantai niina jeen pujau nunú yaaktanmaya nuwauch aidaun ijagsatatus weuwai. ");
INSERT INTO agr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Nunittaman nunú yaaktan apuji Hamor heveo aents aajakua nuna uchiji Siquem wainak dakimaunak waitkas achika juki niina jeen awaya nuwi ikanak pegkegchau awajkauwai. ");
INSERT INTO agr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Dutikauwaitak senchi wakejuku asa, niina wakemitkaktatus shiig pegkegchin ausauwai. ");
INSERT INTO agr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Dutika niina apaji Hamoran chichajak: “Juju nuwan nuwatkatasan wakegajai, ame weme sumagtukta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Nuna Jacob niina nawanji Dinan Siquem pegkegchau awajkamun dekauwai. Dutika dekaayatak niina uchiji aidau tagkun kuitamainak ikam batsatu asamtai, dita kaunawagmatai chichastajai tusa pachikchauwai. ");
INSERT INTO agr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Nunik pujai, Siquema apaji Hamor Jacobjai chichastatus weuwai. ");
INSERT INTO agr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Nuniai Jacopa uchiji aidau tagkun kuitamak batsatu kaunkama, Siquem Jacopa nawanjin pegkegchau awajkae tabaun dekawajui. Nunik senchi kajekajui, wagki Israelan dushikiak Siquem makichkish nunimainchaun dutikau asamtai. ");
INSERT INTO agr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Tuja Hamor ditajai chichaak: “Mina uchig Siquem atumi umayin senchi wakejuke; nuniau asamtai segajime, wait aneasjum umaim sujimkaigpajum mina uchigjai aishinati. ");
INSERT INTO agr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nunik mina uchig nuwenamtaig atumesh jutii patayi waigtajum. Aatsa ii aidautish atumi nawanji aidaujai nuwenawagmi, tuja atumshakam iina nawanji aidaujai nuwenamnujum. ");
INSERT INTO agr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Nuniakjum atumesh jutijai batsamsatajum. Nugkak atumdau atatui, nuwi pujusjum takasjum sujuktajum, nuniakjum atumdau nugka sumaktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Tusa tutai, Siquemshakam Dina apajin, niina umayi aidaujai ijunun chichajak: “Minash wi sumamua nunú umigtuktajum, wisha atum wajig segattajum nunak imatiksanuk umigkatjime. ");
INSERT INTO agr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Atum wi nuwan juwakui wajupa akigkati tujutmainaitjume, nunashkam imatiksanuk umiktajai, untsu nuwak idaitugsatajum wijai aishinati”, tau. ");
INSERT INTO agr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tusa tutai Jacopan uchiji aidau Siqueman niina apaji Hamorjai, umayi pegkegchau awajtukbau asa tsanuinak, ");
INSERT INTO agr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","juna aatus tiajui: “Jutiik iina umayig aishmag tsupimakchau aidauk sumaitsuji, duka iniig shiig pegkegchau datsan amain asamtai. ");
INSERT INTO agr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Untsu atumesh jutijai betek atag takugmek, ashí aishmag aidautijum tsupimagtajum. ");
INSERT INTO agr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Nunikagmin duwi jutii nawanji aidaush atumjaish aishinmain ainawai, tuja ii aidautishkam atumi nawanjumjaish nuwenmain ainaji. Nunikaja dekas atumjaish nunú wegantu aidauk yaaktamawag ijunas batsamaina nunin amainaitji. ");
INSERT INTO agr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tuja atum nunú dakitakjuminig iina umayig juki yaja wetatji”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Tusa tama Hamor niina uchiji Siquemjai chichainak: “Ayu, kame duke ati” tiajui. ");
INSERT INTO agr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tusa tiajam nunú datsauchik Jacopan nawanjin senchi wakejuku asa, waugtus tsupimakui. Niina apaji jenig Siquem aajakui dekas eme anentsa diitai. ");
INSERT INTO agr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Nuna nunika niina apaji Hamorjai yaakta waitijin aents aidau ijunag chichatainum jegantag ditan chichajuinak: ");
INSERT INTO agr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Juju aents aina juka iina kumpaji ainawai, nunin asag ditak juju nugka juwi batsamas takasa nuwiyan jukiag sujiagtatui. Dita batsamainuk nugkak shiig múuntai, tuja ii aidauti dita nawanji aidau nuwatkagtatji, nuniajin ditashkam iina nawanji aidaun nuwatkagtatui. ");
INSERT INTO agr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nuigtushkam ditajai ijunja makichik yaaktakea nunin wajasa pujusmi tama ayu tuinawai. Nuniktin asajin dita chichainak ashí iinia aishmag aidauk, tsupimagtinme tujamainawai, dita wajuku ainawa nuninuk amí tusag. ");
INSERT INTO agr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Tuja ditá wajiji aidauk kuntinji aina nujai iinu agtatui. Nuadui yamaikik nii segapamua duke umigkagmi, aatus ditashkam jutijai juwakag batsamsatnume”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Tusa Hamor niina uchiji Siquemjai tiagtai, tikich aidaushkam, ayu duke ati tusag aimkajui. Tiagmatai ashí aishmag suntagbaemain aidauk tsupimajaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tujash kampatum tsawanta duwi, Jacopa uchiji Dina umayi aidau: Simeón Levíjai puyagjin jukiag yaaktanum wayawag ashí aents tsupimajaju aidau nuna najaimainak ayamjumamainchau wajas batsatun ashí kajegkajui. ");
INSERT INTO agr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Dutikainak Hamornashkam Siquemjai apatuk puyajai ijuag maawajui. Dutikawag Dina Siquema jeen pujuttaman juki ukukiajui. ");
INSERT INTO agr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Dutikawaju ai Jacopan uchiji tikich aidau kauna shimutuk aents jinaa batsatbaunum utsanawag dita umayi pegkegchau awajkamunum aents jinau aina nuna wajiji aidaunak ashí yajuakajui. ");
INSERT INTO agr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Dutikainak nuigtushkam yaaktan ukuki uwig aidaun, baka aidaun, burro aidaun aatus ashí tikich waji ayaunak yajuakajui. ");
INSERT INTO agr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Tuja nuigtushkam waji jegaya aidaunash kasamkajui, dutikainak uchi aidaun nuwa aidaujai achija yajuakajui. ");
INSERT INTO agr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Dutikawagmatai Jacob Simeógkan Levíjai chichajak: “Atum minak utugchat itagtuaugme. Nuadui yamai cananeo aents, ferezeo aents aina nunú minak kajegtukagtatui, dutijuinak mina aentsug aidauk kuashtachua duwi dita ijunag mina mantuinak mina uchig aidaujai mantumain ainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tutai dita aimainak: “Tujash ¿wagka niish iina umayinash, nuwa wainka takatai itugmaina dutikae? Nuadui iishkam aikaji”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Apajuí Jacopan chichajak: “Wetá Betelnum, núnikam nuwi jegam pujusta. Nuwi pujusam amina yatsum Esaú mantamatag takui tupikamin, Apajuí wantintugmakua nunú emematku kuntin maa patasa apeatin altar najanata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tusa tima Jacob niina nuwe aidaun, uchiji aidaun, niina aentsji aidaujaí ijumag chichajak: “Atumi apajuímtaijum dakumka najanamu ajutjamaina duka ashí utsagtajum, dutikajum maijum tikich jáanch nugkugtajum. ");
INSERT INTO agr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Nunikagmin wamak Betelnum shiyakagmi, nuwi jegaan, wi wake besemag wekagai, Apajuí mina yainkauwa nunú emematku kuntin maa patasa apeatnun altaran najanatjai. Nii mina yaja wekagaish uyuuntusmatai wekaesauwaitag nuadui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tusa tiajam ditashkam ayu tusag, dakumka najanamu apajuímtai ajuinamunak, kuishnum akiitai aidaujai yajuakag ashí Jacopan susajui. Dutikam nii juki numi Encina tutai, Siquem nugkanum jegattak wajaunum nuna wajautin yutua ukukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Dutika ukuak jiinag shimutai, nuwiya aents aidaun Apajuí senchi sapigmitkakui ditan pataetukainum tusa. Dutikamu asag Jacob niina uchiji aidaujai shimutaish pataetukchajui. ");
INSERT INTO agr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Nunik we wenakua ashí niijai aents aidau yujaunak imanisag yaakat Almendro tutai tuja Betel tuuta awagmatia nunú Canaán nugkanum awa nuwi jegawajui. ");
INSERT INTO agr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nunik nuwi jegawag kuntin maa patasa apeaku Apajuí ememattinun altaran Jacob najanauwai. Dutika nunú nugkan El-Betel adaikauwai. Yachi maatag tama tupikaki wesa kanittaman Apajuí wantintukua nuwi. ");
INSERT INTO agr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nunú nugkanum Débora Rebecan kuitamajakua nunú jakauwai. Nunikmatai Betel jegattak numi Encina wakentin ukusajui. Dutika Jacob nunú nugkan, “Encinanum buutbau” adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Tuja Jacob Padán-aram pujau wakettatman Apajuí ataktu wantintuk pegkegnum yumigjauwa nunak, ");
INSERT INTO agr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","aatus tiuwai: “Amek Jacopaitme, tujash tuke Jacob tamak achattame; yamai nagkamsamek ‘Israel’ tutai atatme”, tiuwai. Nuna tusa Jacopan daajin Apajuí yapagtua ataktushkam ");
INSERT INTO agr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","chichajak: “Witjai dekas Apajuí ashí senchigtinnuk; amek kuashat uchigtin atatme, nuadui ame wegantu aidaush imanisag agtinai. Nuadui ame wegantu aidau nugka muuntan yaaktamawag batsamsagtinai. Tuja ame uchijum wegantunmaya apu waigkagtin ainawai. ");
INSERT INTO agr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Wi Abrahaman Isaakjai nugkan susauwaitag nunak amina yamaik amaajai, untsu ame jakamin amina uchijum wegantu aidaun susatnaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Aatus Apajuí Jacobjai chichas ukuak wakitkimtai, ");
INSERT INTO agr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","nuwig Jacob kayan juki inantai apujus aceiten vinojai juki ukatkauwai, juju nugkak Apajuínu atin ati tusa. ");
INSERT INTO agr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Nuna dutika ashimak Jacob nunú nugkan Betel adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Jacob Betelnum pujau jiinki Efrata jegattak wegai, Raquel uchin najaima shiig senchi waitus uchigmakui. ");
INSERT INTO agr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Nunik uchigmak ashí jaka tepaun, uchi uchigmitkau chichajak: “Ishamkaipa, jushakam aishmag uchigmakume”, tau. ");
INSERT INTO agr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tusa tima ashí jaka tepes niina uchiji daajin Ben-oní adayak jakauwai. Dutika adaikamu aig, apaji dekas Benjamín ati tusa adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Aatus Raquelak jakauwai. Nunik jakamtai Efrata jintanum yamai yaakat Belén taji nuwi ukusajui. ");
INSERT INTO agr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob nuwen ukusa pempeenak kaya muuntan juki eketi ukukiuwai. Nunú kaya eketi ukukmawa nunuwai yamaikish, juwi Raquelak ukusbauwai tutai awa nunú. ");
INSERT INTO agr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel nuwen ukus ukuak jiinki, kumpin jiikbau Eder tawa nuna ukuki weuwai. Nunik nuwi jeen jegamag pujusui. ");
INSERT INTO agr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Nuwi Israel jegaa pujai, Rubén niina apaji awan nuwe Bilhájai ikagmakui. Nuna dekaa Israel senchi kajekui. Jacopa uchijig doce aajakui. ");
INSERT INTO agr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leayai akiamuk: Rubén aajakui iwai, nuigtu Simeón, Leví, Judá, Isacar, Sabulón aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raquelai akiamuk: José Benjamígjai aajakui. ");
INSERT INTO agr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raquela inake Bilhá aajakua nuwi akiamuk: Dan, Neftalíjai aajakui. ");
INSERT INTO agr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Untsu Lea inake Zilpá aajakua nuwi akiamuk: Gad, Asher aatus aajakui. Juju ainawai Jacopan uchiji Padán-aramnum pujusa akigbau aidauk. ");
INSERT INTO agr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Nuwi pujau niina apaji Isaakan Mamrenum yaakta daaji Arbá tuuta Hebrón tuuta awagmatia nuwi Abraham yaunchuk pujujakbaunum pujau asamtai, niina wainkatatus weuwai. ");
INSERT INTO agr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Nuwi Isaakak ciento ochenta mijan ejeyi pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Nunik shiig múuntuch wajas jakamtai, niina uchiji Esaú Jacobjai jukiag ukusajui. ");
INSERT INTO agr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Juju aajaku ainawai Esaú, Edom tutaya nuna uchiji wegantu aidauk. ");
INSERT INTO agr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú jimag nuwan Canaán nugkanmaya aidaun nuwatkauwai. Jeteke aajakui Adá, hitita aents Elón aajakua nuna nawanji, untsu awan nuwe aajakui Oholibamá, Aná nawanji heveo aents Sibón aajakua nuna tijaji. ");
INSERT INTO agr_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Nuigtushkam Ismaela nawanjin Nabaiota umayi Basemat aajakua nuna nuwatkauwai. ");
INSERT INTO agr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adá Esaún uchigmatkauwai uchi aishmagkun Elifazan, untsu Basemat uchigmatkauwai uchi aishmagkun Reuel. ");
INSERT INTO agr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Tuja Oholibamá uchigmatkauwai uchi aishmag aidaun: Jeús, Jaalam, Coré aatus. Juju aajaku ainawai Esaú uchiji nii Canaán pujusmatai akiinkaju aidau. ");
INSERT INTO agr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Canaán pujau Esaú niina nuwe aidaun, uchiji aidaun, nawanji aidaujai ashí aents niina jeen batsamin aidaunashkam imatiksag yajuak weuwai tikich nugkanum niina yachi Jacobjai pujamun ukuki kanak pujustatus. Nuigtushkam niina tagkuji aidaun Canaán pujusa uyugkamunak wajijijai ashí yajuak weuwai. ");
INSERT INTO agr_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ditak kuashat tagkugtin asag, nunú nugkanmakek mai pujumainchau aajakui; nuigtushkam nunú nugkanmak tagku ayugmainchakam atsujakui. ");
INSERT INTO agr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Nuniau asamtai, Esaú Edom tutaya duka, nugka Seír tawa nuna mujajin pujustatus weuwai. ");
INSERT INTO agr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Juju aajaku ainawai Esaú wegantu aidau, edomnumia aents aajaku aina nuna apaji. Ditak nugka Seír tawa nuna mujajin batsamajakajui. ");
INSERT INTO agr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Tuja Esaú uchiji aajaku aina nuna daaji aidauk juju ainawai: Elifaz Adáyai akiidau, Reuel Basematai akiidau. ");
INSERT INTO agr_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Tuja Elifazan uchiji aidauk: Temán, Omar, Sefó, Gatam, Quenaz aatus aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaz tikichin ikaa nuwen Timná daagtinun nuwatkauwai. Dutika nuwi akiauwai makichik uchi aishmagkun dutika adaikauwai Amalec. Juju aajaku ainawai Esaún nuwe Adá aajakua nuna uchiji wegantu aidau. ");
INSERT INTO agr_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Untsu Reuelan uchiji aidauk: Náhat, Zérah, Shamá, Misá aatus aajaku. Tuja juju aina juka Esaún nuwe Basemat aajakua nuna uchiji wegantu ainawai. ");
INSERT INTO agr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Tuja Esaún tikich nuwe Oholibamá Aná nawanji, Sibógkan tijaji aajakua nuwi uchi akiinkau aidauk: Jeús, Jaalam, Coré aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Tuja Esaún uchiji aidaunmaya apu aajaku aina duka juju ainawai: Esaú uchiji iwai Elifaza uchiji wegantu aidaunmaya apu aajaku aina duka juju ainawai: Temán, Omar, Sefón, Quenaz, ");
INSERT INTO agr_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam, Amalec aatus. Juju aajaku ainawai Elifaz wegantunum akiinau aina nuna apuji, Edom nugkanum batsamajaku aina nunú. Juju aina juka ashí Adá wegantu ainawai. ");
INSERT INTO agr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Untsu Esaún tikich uchiji Reuel aajakua nuna uchiji apu aidauk: Náhat, Zérah, Shamá, Misá, aatus aajakui. Juju ainawai Reuel wegantunum akiinau aina nuna apuji Edom nugkanmaya. Juju aina juka ashí Basemat wegantu aajakui. ");
INSERT INTO agr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Untsu Esaú nuwe Oholibamá Aná nawanji aajakua nuna uchiji aidaun apujig: Jeús, Jaalam, Coré aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Esaú Edom tutaya nuna uchiji wegantu aidaun apuji aajaku aina duka juju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Tuja Seír horeo aents aajakua nuna uchiji aidauk: Lotán, Sobal, Sibón, Aná, ");
INSERT INTO agr_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Éser, Disán aatus aajakui. Juju aajaku ainawai Seíra uchiji wegantu aidau horeo aents wegaunum akiinau aina nuna apuji aidau Edom nugkanum batsamsau aina nunú. ");
INSERT INTO agr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Tuja Lotánka uchiji aidauk: Horí, Hemamjai aajakui. Untsu Timná aajakui Lotánkan umayi. ");
INSERT INTO agr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Tuja Sobala uchiji aidauk: Alván, Manáhat, Ebal, Sefó, Onam aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibógka uchiji aidauk: Aiá, Aná aatus aajakui. Nunú Aná mujanum niina apaji Sibógka burrojin kuitamak uwegshunum wekaekama yumi pukuni initkanmaya jiinun ejeyuwai. ");
INSERT INTO agr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aná uchijishkam: Disón, nuigtu nawanji Oholibamá aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disónkan uchiji aidaushkam: Hemdán, Esbán, Itrán, Querán aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Tuja Ésera uchiji aidaushkam: Bilhán, Zaaván, Acán aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disánka uchiji aidaushkam: Us, Aránjai aajakui. ");
INSERT INTO agr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Tuja horeo aentsun apuji aidauk: Lotán, Sobal, Sibón, Aná, ");
INSERT INTO agr_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Éser, Disán aatus aajakui. Juju aajaku ainawai horeo aents aidaun apuji, maki makichik wegantu aidau Seír nugkanum batsamsau aina nunú. ");
INSERT INTO agr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Nunú apu aajaku aina nuu, inamajaku ainawai Edom nugkanum, Israel aents aidaunmayag eke apu atsau asamtai. ");
INSERT INTO agr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beoran uchiji Bela aajakui Edoma apuji. Tuja niina yaaktajig Dinhaba aajakui. ");
INSERT INTO agr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela jakamtai, Jobab Zérah uchiji yaakat Boshránmaya aajakua nunú apu wajas inamjauwai. ");
INSERT INTO agr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Untsu Jobab jakamtai, Husam Temán nugkanmaya aajakua nunú apu wajas inamjauwai. ");
INSERT INTO agr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam jakamtai, Hadad Bedatan uchiji madiágnumia aents aidaun Moabnum amukua nunú apu wajas inamjauwai. Nigka yaakat Avit tawa nuwiya aajakui. ");
INSERT INTO agr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad jakamtai, Samlá Masrecánmaya aajakua nunú apu wajas inamjauwai. ");
INSERT INTO agr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlá jakamtai, Saúl yaakat Rehobot tutai namak Eufratesa ijus awa nuwiya apu wajas inamjauwai. ");
INSERT INTO agr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saúl jakamtai, Baal-hanán Acbora uchiji aajakua nunú apu wajas inamjauwai. ");
INSERT INTO agr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Untsu Baal-hanán jakamtai, Hadad yaakat Pau tawa nuwiya apu wajas inamjauwai. Hadata nuwe aajakui Mehetabel, Matred aajakua nuna nawanji, tuja Mezaapa tijaji. ");
INSERT INTO agr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Tuja Esaú wegantu aidau maki makichik daagtin patayi aidaujai juunik ditash nugkentin batsamsaju aina duka juju ainawai: Timná, Alvá, Jetet, ");
INSERT INTO agr_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamá, Elá, Pinón, ");
INSERT INTO agr_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Quenaz, Temán, Mibsar, ");
INSERT INTO agr_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, Iram aatus. Tuja Esaún tikich daajig Edom aajakui. Juju ainawai Edoman apuji aajaku aidau, maki makichik ditash nugkentin batsamajaku aina nunisag apumeak inamjau aina nunú. ");
INSERT INTO agr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacopak niina apaji Canaán pujujakua nuwi pujusui. ");
INSERT INTO agr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Juju agagbauwa juka Jacopan patayi aidau pachisa augmattsamui. Josék diecisiete mijan ajamaitak, niina apaji ikaa nuwe aidau Bilhá Zilpájai aajakua nuwi niina yachi akiinau aidaujai ijunas uwijan kuitamajakui. Nuniau asa niina yachi aidau pegkegchau wajagtai apajin jegajua ujajakui. ");
INSERT INTO agr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Tuja Israelak Josén ima senchi tikich yachi aidaun nagkaesau anejakui, nii múuntuch wajas pujayatak akiau asa, José nugkugtinun jáanchin shiig pegkejan najatua susauwai. ");
INSERT INTO agr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tujash José yachi aidauk, iina apajig Josén ima senchi aneak iinak imatikas anempainatsji tuidau asag, kajejuinak makichkish kumpamainachu. ");
INSERT INTO agr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Dutikam pujus José kajanum kajamjauwai. Nunik wagkanuk juni kanagja tusa yachi aidaun ujakui. Dutika ujakam nuna antukag, nuni senchi kajegkajui. ");
INSERT INTO agr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Dutikainam José ditan chichajak: “¡Antuktajum, wi kajanum kajamjag nuna ujaktajime! ");
INSERT INTO agr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Kajanum ii aidauti ashí ajá ejapeen trigo tsupija jigkaka ijumku batsamaji. Nuniajin wi jigka aepsamua nunú nantaki tutupit wajasmae; nunikmatai untsu atum jigkamu aidau nantajag nunú midau wajattaman tentea apakag eme anentuinak tsuntsuma ijuntsagmae”, tau. ");
INSERT INTO agr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Tusa ujakam, yachi aidau niina chichajuinak: “¿Amekaitam iina apuji wajasam inajajatnum?” tuidau. Nuna tusag nuni senchi kajegkajui, wagki nii kajamjamujin imatiksag ujakajam. ");
INSERT INTO agr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Dutikam pujus ataktushkam tikichin kajamjauwai, nunik nunashkam yachi aidaun ujaak: “Antuktajum tikichnashkam ataktu kajamjajai. Kajanum wainkamjai etsan, nantun, nuigtu once yayan. Nunú aidau mina tententuawag eme anenjusag tsuntsumjutiagmae”, tau. ");
INSERT INTO agr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tusa niina apajin, yachi aidaujai ujakui, tusa uchiji ujaam apaji chichajak: “¿Wajimpaya dusha nunin kajabaush? ¿Wika amina dukujai, ashí yatsum aina nunú aatsan amina tikishmatjan ememattinaitjam?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nuadui niina yachi aidau senchi kajejuidau. Tujash niina apajig wajuk asag nunash nuni kajamjae tusa kuashat anentaimu. ");
INSERT INTO agr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Makichik tsawantai José yachi aidau ditá apaji uwigji ayujatnun chijichin egainak Siquemnum shiyakajui. ");
INSERT INTO agr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Nunik shiyakmatai pujusa Israel Josén chichajak: “Amina yatsum aidau uwijan kuitamainak Siquem batsata nunú wejim diista”, tiuwai. Tama José ayaak: “Ayu apawah, ame tame nunak imatiksanuk umiktajai” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Timatai Israel: “Ayu wetá, nunika jegaam yatsumesh wajuk batsatainawak nunú diista, nuniakum uwig aidaushkam diista. Dutikam ditash wajintuk chichainawa nunú minash taam ujatkata”, tiuwai. Tusa, José Hebrógka pakajin pujaun Israel akupkauwai, dutika akupkam Siquem wekama, ");
INSERT INTO agr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","wagaka wainak wekaetatman makichik aents wekagu wainak iniak: “¿Waji egakmea amesh wekaeme?” tiuwai. Tama José ayaak: ");
INSERT INTO agr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“Wika mina yatsug aidaun egajai” tiuwai. Tusa nuna iniak: “Wait aneasam minash ujatkata tuwi dekaskesh uwijan kuitamkush batsatua”, tau. ");
INSERT INTO agr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Tama nunú aents ayaak: “Amina yatsumik juwig atsuinawai, juwi batsatu ukuak shiyakmae, tuja dita chichainak, Dotágnum weagmi tuidaun antukmajai”, tiuwai. Tusa tima Joséshkam yachi aidaun egak yaakat Dotágnum jegauwai, nunik nuwi yachi aidau batsatun wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Nuwi jegattak wegaun, yachi aidau wainkag, maami tusag eke jegatsaig chichaman umigkaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Dutika umigkaju asag chichainak: “¡Diisjua au kajamkagtinuwe nunú minawai!” tuidau. ");
INSERT INTO agr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Nuna tusag: “Kaunatajum maami, dutika waanum egkea ajapami. Dutika iina apaji jegaji ujakuishkam, ikamia kuntin yuwae timi. ¡Dutika ajinish nii kajamkagtugbauji aidaush wajuk uminkatig!” tuidau. ");
INSERT INTO agr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Tusa tuidaun Rubén antuk ayamjuktajai tusa chichaak: “Dekas tikima mautak maachmi”, tau. ");
INSERT INTO agr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Nuna tusa nuigtu chichaak: “Ayatak mautsuk, juju uwegshunum waa awa juwi egkeatajum, tujash makichkish awattsuk egkeatajum”, tiuwai. Rubén juna tiuwa nunak niina yachin uwemtikag juki apajin awagkitatau asa tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Tusa imatu batsatai Joséshkam niina yachi aidau batsatbaunum jegantui, nunittaman jáanch nugkuagbaujin awituk jujukiag, ");
INSERT INTO agr_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","achika jukiag waa yumi atsamunum egkeawajui. ");
INSERT INTO agr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Dutika waanum egkea idayinak, yutain yuwinak batsatu, nunik batsatu niimsatakama Ismael aents aidau Galaad nugkanmaya camelloji aidaunum kugkuin bálsamo tutain, kugkuin mirra tutai aidaun aatus yajuakag Egipto nugkanum shimuidaun wainkajui. ");
INSERT INTO agr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Nuna wainak Judá niina yachi aidaun chichajak: “¿Waji imana jukittaji iina yachi, maa uuka idaikuish? ");
INSERT INTO agr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Dekas ayatak juki Ismael aents shima au sumakta tusa sujukmi, dutikaku tikima mautak maachmi, iina yachiya jamah”, tiuwai. Tusa tama tikich yachi aidaushkam duke ati tusag tiajui. ");
INSERT INTO agr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Nuadui Madián aents waji sujin aidau nagkaemainai, Josén yachi aidau waanmayan jiiki jukiag diitai sujukajui veinte kuichik plata najanamun juwinak. Dutikawagmatai dita sumak jukiag Egipto nugkanum ejegawajui. ");
INSERT INTO agr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Dutika sujuk awemaju ai, Rubén wakitki taa waanum José egkeamun jegantun diikma atsaun wainkauwai, nunik jáanchjin japiki ichigkui wake besemag dekapeamunum. ");
INSERT INTO agr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nunik wakitki yachi aidaun chichajak: “¡Uchik atsawai! ¿Yamaish wisha wajukatjaki?” tau. ");
INSERT INTO agr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tusa tutaish pachitsuk idayinak, José jáanchji awitka jujukbaun jukiag, chivo tsakatan maawag nuna numpejai jáanchin numpeajajui. ");
INSERT INTO agr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Nuna dutikawag ditá apajin akuptukajui, dutikamun juki ejetuawag chichajuinak: “Juju wainkaji ame shiig diista, amina uchigmi jáanchjichuashit”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Tama Jacob diistakama niina uchiji nugkutaijin wainkauwai, nunik chichaak: “¡Ehe juju jáanchia juka mina uchigdauwai!” tiuwai. Tusa chichaak: “¡Kuntin kajen pegkegchau aina nunú yuwae imatika shiig ichiajana!” tau. ");
INSERT INTO agr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Nuna tusa Jacob niina jáanchjin japiki ichigkui, nunik wake besemag dekapeaku nugkutain nugkujui. Nunik pujus uchijin aneak kuashat tsawantai tuke buutú pujau. ");
INSERT INTO agr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Imani pujutai ashí niina uchiji aidau, nawanji aidaujai anentain ichichtuinak kautuawajui. Tujash nigka dakitau anentaijun ichichtujatnume tusag. Nuniau asa: “¡Wika tuke buu buutkawa jakan niijai wainiakun, duwi wake besemag dekapeamugnak nagkaankattajai!”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Tuja Madián aents aidauk dita sumaku ainayatak, Egipto nugkanum ejegawag suntag yaaktan utuawainum tusa kuitamin aidaun apuji faraógka atuwe Potifar aajakua nuwi sujukajui. ");
INSERT INTO agr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Tikich tsawantai Judá niina yachin ukuak weuwai makichik aents Hirá daagtin yaakat adulamnumia aajakua nuna jeen pujustatus ");
INSERT INTO agr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nuwi jegaa pujus canaágnumia aents Súa aajakua nuna nawanjin wainak nujai nuwenauwai. Nunik pujusa, ");
INSERT INTO agr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ejapmitkakui, dutikam pujus tsawanji jegajim aishmagkun uchigmakui. Nunikmatai Judá uchiji daajin Er adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nuna uchigmak pujus ataktu ejapjuk uchigmakmatai nunak Onán adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nuigtushkam ataktu ejapjuk uchigmak nuna untsu Selá adaikauwai. Nunak Judák yaakat Quezib pujai uchigmakui. ");
INSERT INTO agr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Nuwi pujus Judá niina uchiji iwai Er aajakua nuna nuwa Tamar daagtinjai nuweauwai. ");
INSERT INTO agr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tujash Era pujutjig Apajuí emtinig shiig pegkegchau aajakui, nuniau asamtai, Apajuí niina pujutjinak jujukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Dutika jujukim jakamtai Judá Onágkan chichajak: “Ame yatsumin nuwe wajemea au jukim, yatsum uchi akiitsuk jaka nunú uchi akiintuata, dutikam aminiya niina uchiji wegantu aidaush yujakti”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tujash Onágkak nii uchi akiamua duka niinuchu agtinun dekau asa, yachi nuwe wajejai tsaniakush ejapmitkakaig tusa kuitamamajakui. Nunak nii akiamunmaya yachi uchiji wegantu aidau yujakai tusa dakitak nuníjakui. ");
INSERT INTO agr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nunittaman Apajuí wainak shiig pegkegchau diisui, dutikau asa niinashkam dutiksag wamak pujutin jujukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Dutikam jakamtai, Judá niina uchiji nuwe Tamar aajakua nuna chichajak: “Yamaik wajemeaume, junismek amina apa jeen weme pujusta, mina uchig Selá tsakagti”, tiuwai. Tusa tima Tamarshakam niina apaji jeen wee pujusui. Nunak Judá anentaimas tikich yachi aidau jakaja nunik jusha jakachaintash, tau asa tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Tuja kuashat tsawan nagkaemakiu ai, Judá nuwe Súa nawanji aajakua nunú jakauwai. Nunik nuwe jakamtai wake besemag pujamun sakapag niina kumpaji Hirá adulam aents uyuuntsam yaakat Timnatnum niina uwigji ujen tsupijuinak batsatbaunum weuwai. ");
INSERT INTO agr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tuja Tamarchakam niina aishi aajakua nuna apaji yaakat Timnatnum niina uwigji ujen tsupijak wee tabaun dekauwai. ");
INSERT INTO agr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Nunik dekaa waje nugkutai nugkuagbaujin awimak ukuak, waitkainum tusa jáanchin juki dukumak yapin ejak, jinta Timnat wetainum ayaumas yaakat Enaim awa nuna waitaijin ekemsauwai. Nunak Selá tsakaju aigkiap awi nemakta tusagkesh tujutchae tusa nunikui. ");
INSERT INTO agr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Nunik ekemtatman Judá wainak, yapiin dukuka eketu asamtai, juka nuwak wainka takatai aina nuwapi tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Nuadui niina uchiji nuwe aajakua nuwapi tachau asa jegantun chichajak: “¿Minash wi amijai aankatjai taish ayu tujutmainchaukaitam?” tiuwai. Tusa tama nii ayaak: “¿Tujash ame mina dutijakmesh waji minash sujustatme?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Tusa tama Judá ayaak: “Makichik chivo tsakatan awetitjame”, tau. Tama nuwa ayaak: “Ayu, dekas takumek makichik waji ukugtukta, ame nunú chivo tsakat awetujiamin nuna juwakun awagtuktagme”, tau. ");
INSERT INTO agr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Tusa tama Judá iniak: “¿Tujash wajina ukugtukti tusamea wakegame?” tau. Tama nuwa ayaak: “Ame patakumtaijum, nugkutaijum, nuigtu numi amina ushujutaigmia nunú aatsa ukugtukta”, tiuwai. Tama Judá ayu tusa ashí susa nuadui niijai tsanigkui, dutikam Judá uchijin ejapjukui. ");
INSERT INTO agr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Nunik Tamar wakitki jeen jegaa, jáanch dukumakbaujin juki ukuak, wajemea nugkutain nugkug pujusui. ");
INSERT INTO agr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Nunik pujai Judá niina kumpaji adulam aentsun chichajak: “Ame makichik chivo tsakatan amasmatai jukim nuwa ejetuam suwakum, mina wajig aidaun susan ukukmayag nunú segam itagtuata”, tusa awemauwai. Tusa tima niina kumpaji nuwan jegajua susatakama wainkachui. ");
INSERT INTO agr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Dutika wainkacha nuwiya aents aidaun iniak: “¿Tuwi pujawa nuwa wainka takatai Enaimnumia jintá ayaumas pujuma dusha?” tau. Tama dita aínak: “Juwig nuwa wainka takataig makichkish shiig atsawai”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tusa tima Judá pujamunum wakitki jegaa chichajak: “Nuwanak shiig wainkachmajai, awiya aents aidaushkam juwig nuwa wainka takataig shiig atsuwe tujutiagmae”, tau. ");
INSERT INTO agr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Tusa ujaam Judá ayaak: “Nunú waji aidauk niini juwakti, tikima shiig dushikiam aig; wika chivo tsakatan amastajai tibaugnak awetijai, tujash amesh wainkachu asam susachume”, tusa idaisauwai. ");
INSERT INTO agr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Nunik idayas pujus kampatum nantu nagkaemai, Judán kautuawag chichaman ujainak: “Tamar amina uchigmi nuwe aajakua duka wainak aentsjai takama wekaekama ejapjuke”, tiajui. Tusa tama Judá senchi untsumak chichaak: “¡Nuwak jiiki jukijum apeatajum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tusa timatai jegaji juwam, niina aishi aajaku apajin chichaman akuptak: “Wika juju wajiin takakag judaun ejapjukjai. ¿Amesh juju diisiah, jusha patakumtai, nugkutai, numi ushujutain wi takakag jusha yanawaita?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Nuna dekaa nuigtu niina wajijin wainak wajaka Judá chichaak: “Niig dekas shiig anentaimui, midauwai utugchata duka, wagki wi mina uchig Selájai nuweachbau asa junak jutijuae”, tusa ayatak idaisauwai. Nuadui ataktu awagkig nuwanak makichkish wejichui. ");
INSERT INTO agr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Duwi pujus Tamar uchigmati jegamtai, jimag uchi aishmagkun uchigmakui. ");
INSERT INTO agr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Dutika uchigmam makichik uchi uwejen eemtika jiikiuwai. Dutikamtai uchí uchigmitkau uwegnum hilo kapantun tsujig juki jigkauwai. Dutika chichaak: “Juju dekatkauk akiinae”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tujash nunú uchik niyá akiinachui ayatak kuntujin awagkiuwai, nuniai niina yachi tikich eemak akiinauwai. Nunikmatai uchí uchigmitkau chichaak: “¿Amesh wajuk eteemamea jiinkiume?” taku nuna daajin Fares adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Nunú akiinamtai uchi uwegnum jigkamushkam akiinauwai. Nunikmatai nunak Zérah adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Josén Ismael aents aidau sumakag Egipto nugkanum ejegawajui, dutikawagmatai nuwiya aents Potifar daagtin sumakui. Potifarak suntag yaakta utuawainum tusa kuitamin aidaun apuji, faraógkan atuwe aajakui. ");
INSERT INTO agr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Tujash Josénak Tuke Pujuu kuitamajakui. Dutikamu asa nii egiptunmaya aentsu jeen pujus takasua duwik pegkeg pujusui. ");
INSERT INTO agr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nuadui niina apujishkam anentaimas, Tuke Pujuuwap junak dekas yayawa dutikamu asampap takat susamash shiig umika emawa tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Nuadui Josék apu shiig anentam asauwai, duwi Josénak ame dekas mina jegajuiya aina nunú kuitamin ata tusa ashí niina wajiji aidaunak susa idaisauwai. ");
INSERT INTO agr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Apu Potifar ashí niinu aidaunak Josén ame yamaik diista tusa susamunum nagkamas, Tuke Pujuu Potifaran pegkegnum yaigkui, dutikak niina jenianash, ajajinianashkam aikasag kuashat ikauntukui. ");
INSERT INTO agr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Imatikamu asa, Potifarak shiig kajitus, Josénak ashí niinu aidaunak idaitusui. Dutikau asa niig ayatak yuwatnujinak anentaimtujakui. Josék shiig iwajamu, yantsaptin wajakin aajakui. ");
INSERT INTO agr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Iman asamtai, tikich tsawantai apu Potifaran nuwe Josén senchi wakejukui, nunik makichik tsawantai chichajak: “¡Iijai kanagmi!”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tujash Josék dakitau asa niina chichajak: “Amesh anentaimsata, mina apug shiig kajitjus ashí niina jenia aidaunak mina idaitugsau asa, nigka makichkish puyatjutsuk shiig aneas pujawai. ");
INSERT INTO agr_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Tuja juju jega juwig tikich aents mina nagkaetasuk atsawai; makichik wajigkesh wi takamainchauk atsawai, ima ameketme wi atimainchauk, wagki niina nuwe asam. Nunin aish, ¿wisha wajukeaknuk amejai kanaknush Apajuí emtinish pegkegchaunash takastaja?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tusa tamashkam nuwak Josénak antugtsuk kashi kashinig iijai kanagmi tusa waitkau. Imatjamashkam Josék nuwa chichamenak antugkachui. ");
INSERT INTO agr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tujash makichik tsawantai José niina takatji aidaun umiktatus jegaa wayauwai. Nunik wayaun makichik aentskesh nuwig atsau asamtai, ");
INSERT INTO agr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","nuwa Josén jáanchjin achika emetua chichajak: “¡Iijai kanagmi!” tau. Tujash Josék dakitau asa tupikaki jiinak, niina jáanchjin awimak ukukiuwai. ");
INSERT INTO agr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Dutika jáanchin awimak ukukmatai, nuwashkam nunú jáanchin juki wajan, ");
INSERT INTO agr_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nunú jeganum tikich inak aidau batsatun untsuka ikaunman chichajak: “¡Diistajum atumesh, mina aishug hebreo aentsun juwi itagtamama nunú, iina dushiktamak mina jutijawai! Juwi tajutua iijai kanagmi tujutkui, wi dakitakun senchi untsumajai. ");
INSERT INTO agr_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Tusa imatai ¡tupikak jáanchjin awimak ukuak jiinki wemae!” tau. ");
INSERT INTO agr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tusa ashí etsejuk idayak, José jáanchjin juki ukus pujai niina aishi, José apuji aajakua nunú tauwai. ");
INSERT INTO agr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Nunikmatai nii tikich aentsun ujaak chichakbaujinak, imatiksag aishinashkam ujaak: “Ame hebreo aents inagtajai tusam itamum nunú mina kanutaijui wainjua waitkagsae. ");
INSERT INTO agr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tujash wi senchi jiika untsumai, tupikaki jiinak niina jáanchjin awimak juwi ukukmae. ");
INSERT INTO agr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","“Juna aatus amina inakem waitkagsae”, tau. Tusa ujakam José apujishkam niina nuwe chichaak aatus waitkagsae tabaun dekaa senchi kajekui. ");
INSERT INTO agr_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Nunik kajeka Josén achik juki aents achika chimpitainum apu inake aidau achikam chimpijunum egkeauwai. ");
INSERT INTO agr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Dutika egkeawagmataishkam Tuke Pujuu Josénak tuke kuitamu, nuadui achijatka chimpitai kuitamnun apujishkam niinak shiig anenjauwai. ");
INSERT INTO agr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Dutikak aents achika chimpitainak, ashí aents achikam chimpijujai Josén ame ashí kuitamkata tusa idaitusui. Dutikamu asa nuwi chimpimas takajaku aina nunak José diijakui. ");
INSERT INTO agr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Aents achika chimpitain apujig Josén ashí idaitusu asa, nigka nunak puyatjujakchauwai. Wagki Josénak Tuke Pujuu kuitamajakui. Nuadui niina takatjig shiig pegkeg aajakui. ");
INSERT INTO agr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","José achikam pujai, faraón uwagtinun vinon shikika su aidaun apuji, pagka najanin aidaun apujijai faraógka chichamen betek umigkachajui. ");
INSERT INTO agr_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Nunikagmatai faraón uwagtinun shikika suu aidaun apujin, pagka najanin aidaun apujijai mai kajejuk, ");
INSERT INTO agr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","achika apu Potifara jeen aents achika chimpitainum, José achikam egketunum, nuwi ditanashkam chimpiauwai. ");
INSERT INTO agr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Tuja aents achika chimpitain apuji Josén chichajak: “Apu faraógkan inake aidaun achika egkeag juju ame ashí diista”, tusa niina idaitusui. Dutikamu asag kuashat tsawan nuwi pujusajui. ");
INSERT INTO agr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Nuwi pujusag, faraógkan umutain shikika suu aidaun apuji, pagka najanin aidaun apujijai mai kajamjajui maki makichik dita wajukawagtinuk ayanme nuna. ");
INSERT INTO agr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Nunik kajamag tsawajag batsatai, José kashikmas weji diikma wake besek pekajun wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Dutika wainak ditan iniak: “¿Wagka wake besekjumesh pekagjume?” tau. ");
INSERT INTO agr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Tusa tama dita aínak: “Kajamkagtugji, nunika wajukatnuk aannush kajamjaji, yaki ujapakainta tusa anentaimku pekagji”, tuidau. Tiagtai José ayaak: “¿Dekas Apajuíchukai atum aan kajamjaujum nuna ujapamainuk? Wajuk atum kajamjaugme duka mina ujatkatajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tusa tima apu uwagtinun shikika suu aidaun apuji, nii kajamjamun ujaak: “Wi kajanum makichik uva numiji uva numiji tsapai wajaun wainkamjai. ");
INSERT INTO agr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Tuja nuna kanaweg kampatum ajime. Nunú kanawe aina nuwi jeeka yagkujime, nuniak niina yagkujiya duke neje najanea tsamame. ");
INSERT INTO agr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nuniai wi faraógka umutaijin takusa wajasan uvan juukan apu shikika sutainum nuna ijujan jukin wiki apu faraógkan sumajai”, tusa ujakui. ");
INSERT INTO agr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Tusa ujakam José chichajak: “Ame kajanum kampatum kanawe wainkaum duka, kampatum tsawan atina nunú kajamjaume. ");
INSERT INTO agr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tuja kampatum tsawan asa, apu faraón atumin itugchatjumin diigtamsattawai, nunik aminak ame takataigminig ataktu awaintamattawai, dutijamamtai ame yaunchuk apu faraón niina umutaiji umigkam suyum dutiksamek sutatme. ");
INSERT INTO agr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tuja wi tajam nunú betek uminkamtaig, minash wait aneasam anenjata kajimatkim idaitutsuk, nuniakum mina pachittsamesh faraón ujakta minash jiigkiti. ");
INSERT INTO agr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Wika hebreo aentsuitjai nuniaig minak kasamjukag imajui itajuawagmayi, dutijuawagmatai pujai, makichik pegkegchaunakesh takamsachu aig, juwi egketuawagmatai pujajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Nuna aatus José tikichin betek ujakmatai, pagkan najannun apujishkam Josén nii kajamjamujin ujaak: “Wishakam kajanum kampatum chagkin yaignum pag puju aidau aimkamun yajuakan mina buukeajui ekenjamjai. ");
INSERT INTO agr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nunú chagkin kampatum mina buukjui ekenbauwa nuwiya pag shiig pegkeg yumimitu najankamu faraógdau chimpijun chigki aidau kaunak yuwagmae”, tusa ujakui. ");
INSERT INTO agr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Tusa ujakam José ayaak: “Ame kajanum kampatum chagkin yaijuch aidaun mina buukeajui ekenjai tame duka, kampatum tsawan atina nunú kajamjaume. ");
INSERT INTO agr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kampatum tsawan asa faraón amina itugchatjumin diigtamsattawai, nunik jiigmaki numi muunnum aminak jigka detama buukmin tsupigtamak mantamattawai, dutijamamtai amina iyashminak chigki aidau yuwawagtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tusa ujakajam batsamas kampatum tsawantan ejegainai, faraón nii akiinamuji tsawan tsawagmatai, ipaama yutain umika yuwinak batsamas, ashí nii ipaamu aidau emtin makichik aentsun awemauwai nii uwagtinun shikika suu aidaun apuji, pagka najanin aidaun apujijai, achikam chimpija nunú jiikjum utitajum tusa. Tusa akupkam jegajua jiiki juki itajuauwai. ");
INSERT INTO agr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Dutika itajuam nii uwagtinun shikika su aidaun apujinak ataktu yaunchuk takajakbaujinig awayauwai. Dutikam niig faraógka shikijuk suwak wekagu. ");
INSERT INTO agr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Untsu pagka najanin aidaun apujinak suwenum jigkajum numinum nenajum maatajum tusa tiuwai. Tusa timatai dutiksag maawajui, José tibaunak imatiksag. ");
INSERT INTO agr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tujash umutain shikika apun su aidaun apujig José akatjamunak kajimatki pachitsuk idaisauwai. ");
INSERT INTO agr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Faraógka umutain shikijuk su aidaun apuji achikam pujaun jiikiajua duwi nagkamas jimag mijan wegai, makichik tsawantai, faraón niishkam kajanum namak Nilonum uwet wajamujin kajamjauwai. ");
INSERT INTO agr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nunú namakia siete baka duwejam pegkeg aidau jiinag chijichi namaka tugkitkenian yuwinak ijunun kajamjauwai. ");
INSERT INTO agr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nuniai tikich siete baka aidau watsaku pegkegchau tsumain aidau jiinag, tikich baka duwejam aidau chijichin yuwinak ijunbaunum jegantatak nuna ukujin namaka tugkitken ijuntsauwai. ");
INSERT INTO agr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tuja nunú siete baka watsaku pegkegchau tsumain aidau, tikich siete baka duwejam pegkeg aidau ijuntatman shiig wamak yuwa amukajui. Nunú nunidaun faraón wainak shintajui. ");
INSERT INTO agr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nunik shintaag tepau ataktu kanukma tikichin kajamjauwai: Untsu duwi wainkauwai trigo makichik numitak sieteya imajin nejen nejeka mantamas wakemain wajas wajattaman. ");
INSERT INTO agr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Tuja nuna ukujin tikich trigo sieteya imajin nejentin tujash dase umputai asa neje tsejegkush kagaku aidau jiiniajui. ");
INSERT INTO agr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Nunik dasen umputai asa kagaku tsejegkush aidau, tikich trigo pegkeg siete nejen mantamas wajaun wamkes yuwa amukui. Dutiktatman dii pujau shintaag, kajanmap junikja tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nunik nuna kajanum wainak puyatuk ane anentaimkawa tsawag kashikmas, Egipto nugkanmaya anentaimas dekamin aidaun yacha aidaujai untsuka ashí ikaunmauwai. Nunik kaunamtai faraón nii kajamjamujin ditan ashí ujakui, tujash makichkish nunú nuniktin aan kanajume tusag ujakchaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Dutika tujinkagmatai apu uwagtinun umijuk su aina nuna apuji, faraógkan chichajak: “Yamai wi umikchamujun adeajag nuna ujaktajame. ");
INSERT INTO agr_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ame apuh, kajekam pagkan najannun apuji wijai achigkam apu Potifara jeen aents achika chimpitainum mai egkejatuawamin pujusa, ");
INSERT INTO agr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","kanamunum pagka najanin aidaun apuji kajamkagtujabi, nuniai wishakam antsanuk nunú kashia duwik kajamkagtujamiajai, nunú jimag kajamkagtugbauwa duka maki makichik nagkaemaktinji ajuyi. ");
INSERT INTO agr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Nunika kajamja, yaki ujapaka tusa pujajin nuwi makichik datsauch hebreo aents, aents achika chimpitain kuitamin aidaun apuji inaku waitkatai aajakua nunú achikam pujau waipakmatai, nii ujakabiaji. Dutika ajin wajukatnuk dusha aan kajamjabiaji nuna nii betek ujapakabi. ");
INSERT INTO agr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tuja nii tujabauk imanisag uminkabi, duwi wika ataktu mina takatug aajakunmak wayamiajai. Untsu tikichnak suwenum jigka nená maawagmayi”, tusa ujakui. ");
INSERT INTO agr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tusa ujakam faraón chichaak: “José utitajum” tusa awemauwai. Dutikam jegajua José achikam egketun wamkesag jiikiag awajajui. Dutikawag jáanch pegkejan yapagmamamtai jukiag faraógkai ejegawajui. ");
INSERT INTO agr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Dutika ejegawagmatai faraón chichajak: “Wi kajamkagtujan, wajukatnunak juni kajamkagtugja tusan ashí inimsajai, tujash makichkish ujatuinatsui. Nunika pujai amina au kajanmayan shiig etsegmayi tujamainakui untsukjame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Tusa tama José ayaak: “Apuh, wika wikik tumaitsujai, ¡Apajuí minai pujau asa nii dekaskea nuna ujapakti!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Tusa tima faraón nii kajamjamujin Josén ujaak: “Kajanum namak Nilonum uwet wajamjai, ");
INSERT INTO agr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","nuniai nunú namakia siete baka dekas pegkeg duwejam aidau jiinag namaka tugkitkenia chijichi ayaun yuwinak ijunun wainmajai. ");
INSERT INTO agr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Nuniai tikich siete baka tsumain watsaku aidau jiinag, nunú baka duwejam ijunbaunum nuna ukujin ijuntsame. ¡Wika yaunchkesh makichkish ashí Egipto nugka juwiyanak baka watsaju ibau tsumainnak wainkachuitjai! ");
INSERT INTO agr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nunú siete baka tsumain watsaku aidau, baka duwejam pegkeg aidaun wamkesag ashí yuwawag amukagmae. ");
INSERT INTO agr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Dutika yuwawajash yuwachua nunik yama jiinainak tsumain watsaku aajakbaunak nunisag ijuniagmae. “Nuna wainkan paantapi tukaman shintagmajai. ");
INSERT INTO agr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Untsu ataktu kanukman tikichin kajamkun, wainkamjai makichik trigonmayag sieteya imajin nejek nejen mantamas wakejumain wajas wajaun. ");
INSERT INTO agr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Untsu tikich nuna ukuujin dushakam sieteya imajin nejekuwe, tujash dasen umputai asa neje tsejegkush kagaku aidau jiinag asagmae. ");
INSERT INTO agr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Nunú kagaku aidau tikich dekas pegkeg nejen mantamas wajaun wamkes yuwa amukagmae. Nuna pachisan dekamin aidaun ashí ujakmajai, tujash makichkish nunú nuniktin aan kajamjaume tusag ujatkachaje”, tau. ");
INSERT INTO agr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Tusa ujaam José faraógkan ayaak: “Apuh, ame jimag kajanum kajamjaum duka makichkia duke. Nunak Apajuí nii dutikatnujin aminak iwaintugmake. ");
INSERT INTO agr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Siete baka pegkeg duwejam aidau kajamjaum duka siete mijan atin kajamjaume, tuja siete trigo pegkeg kajamjaum dushakam nunisagke. ");
INSERT INTO agr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Tuja siete baka watsaku tsumain aidau baka duwejam aidau ukujin jiinag ijuntsau wainkaum dushakam siete mijan atin kajamjaume. Tuja makichik trigonmaya sieteya imajin nejentin tujash dasen umputai asa neje kagaku aidau wainkaum dushakam siete mijana nunuwai. Juwai siete mijanai nujan tepeatta nunú. ");
INSERT INTO agr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Tuja wi amina tijam nunak betek Apajuí nii dutikatnujin amina iwaintugmake. ");
INSERT INTO agr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Siete mijanai ashí Egipto nugka juwig kuashat ajakma juwamu atatui. ");
INSERT INTO agr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Untsu nunú mijan nagkaemaig, nuigtushkam siete mijana imajin nujan tepeattawai. Nunikmatai nujantai senchi waitiamu atatui. Nuniau asamtai, ashí Egipto nugkanum tajimat batsamajaku aidaush senchi waitiagtatui, wagki ashí nugkanum yumain atsau asamtai. ");
INSERT INTO agr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Imanik shiig senchi yapajut tepeau asamtai, yaunchuk ajakma yuujakbauwa duka shiig atsuttawai. ");
INSERT INTO agr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Mina apujuh, ame mai numamtinuk kajamjaum nunak Apajuí nii umiktata nuna dekas aik iwaintugmake. ¡Duka imanisag shiig wamak uminkattawai! ");
INSERT INTO agr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Nunú nuniktin asamtai, mina apujuh, ame aents yacha shiig anentaimkau diisam etegkam Egipto nugka juwi apusata nuna diistin. ");
INSERT INTO agr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Nuadui mina apujuh, ame juju aatsa umikta: Adaijata nugká apuji aidau, dutikam dita ashí Egipto nugkanum yujasag ajak juukbaunmayan cinco saco aimkamu ataik makichik, tuja dieznumian jimajan aatus yaju yajumainakua, jeganum utuaktinme siete mijana duwi. ");
INSERT INTO agr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Trigo senchi nejet mijan atata nuadui juukag ashí yaakat aina nuwi ijumjatnume. Duka amina chichamjuminig kuitamkamu ati, yapajut tepeamtaish nuwiya juki aents aidau ayugnatin asamtai. ");
INSERT INTO agr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Aatus trigo ijumjamu asamtai, Egipto nugkanum siete mijadai yapajut tepeamtaish nuwiya juki, juju nugka juwiya aents aidau ayugnati nujantai jinawainum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Tusa José timatai, faraón niina inake aidaujai nuna antukag shiig wakejukajui. ");
INSERT INTO agr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Nunik faraón niina inake aidaun chichajak: “¿Juju aentsun Apajuín Wakani aja imajush tikich aentsush igkumainkait?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Tusa Josén chichajak: “Amina Apajuí yaimpasmatai yachaitam imanuk tikich aentsuk juwig shiig atsuinawai. ");
INSERT INTO agr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ame wi pujusa inamtaijui pujusa inamjata, nuniamin ashí mina aentsug aidauk ame tabaun umigtamkatnume. Untsu ima wiki apu ekemtaijin eketu asan amina wagagkau atatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Nuna tusa: “¡Nijah, wi amina juju nugka Egiptua juna apuji ati tusan adaijame!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Nuna tusa apu faraón niina patakumtaijin juki Josén patakuauwai. Dutika patakua chichaak: “¡Jáanch shiig pegkeg lino najanamu jukijum apegatajum!” tima dutiksag apegawajui. Dutikak nugkutai oro najanamunashkam anujajui. ");
INSERT INTO agr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Dutikawagmatai niina tikich carrojin ekeniuwai, dutika ekeni aents aidaun chichajak: “José eme anentakjum tikishmaja pujusjum senchi untsumkajum: ‘¡Yamaik iina apujig juwai!’ titajum”, tiuwai. Tusa tiajam ashí aents aidauk tikishmag pujusag untsumaidau. Aatus faraón Josénak apu adaikauwai, dutikam nii Egipto nugkanum inamjauwai. ");
INSERT INTO agr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Tuja duwi pujus faraón Josén chichajak: “Witjai dekas apu faraón chichame antugtainuk, tujash yamaik ashí Egipto nugkanmaya aidauk amina chichamjumin antugtamiagtatui, makichik aentskesh intimjutpakchagtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Tusa faraón José daajin yapagtua amek yamaik Safenat-panéah ata tusa adaikauwai. Dutika sacerdote Potifera yaakat On tawa nuwiya aajakua nuna nawanji Asenat aajakua nujai nuweauwai. Dutikam nuadui José ashí Egipto nugkanum wekagas inamjauwai. ");
INSERT INTO agr_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josén jukiag faraón pujamunum ejegawaju aina nunak treinta mijanji ajai dutikau ainawai. Dutika apu adaikam faraón pujamunum pujau jiinki, Egipto nugkanum yaakat aidaun diyak weuwai. ");
INSERT INTO agr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Tuja siete mijanai ajak aidauk shiig kuashat nejeauwai, ");
INSERT INTO agr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","imaniku asamtai, José ashí nugkanum trigo juukbau aidaun siete mijanai yaju yajumkawa maki makichik yaakat aidaunum ijumjauwai. ");
INSERT INTO agr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Josék trigonak nayantsa kamatkajijai betek ijumjauwai. Imatikamu asa dekapamainchau asamtai dekapachui. ");
INSERT INTO agr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Tuja eke yapajut nagkamnatsaig José jimag uchin niina nuwe Asenatai akiauwai. ");
INSERT INTO agr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yama nagkamchaku akiamujinak Manasés adaikauwai “wi waitiamugnak Apajuí ashí mina pataag aidaujai sakapitkajuae” taku tuu adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Untsu tikich uchiji ekeun Efraín adaikauwai. Nunak “juju nugka juwi pujusan waittsawaitag nunú nugkanmak pujaig, Apajuí minak jimag uchin sujuse” taku tuu adaikauwai. ");
INSERT INTO agr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Tuja siete mijanai Egipto nugkanum ajak aidau kuashat nejek nagkaemakiu ai, ");
INSERT INTO agr_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","nuigtu siete mijanai nujan tepeattawai tusa José tibaunak imanisag uminkauwai. Nuadui ashí nugka aidaunmak nujan tepeauwai, untsu Egipto nugkanmak yumainuk aajakui. ");
INSERT INTO agr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Tuja egiptunmaya aents aidaushkam dita yumainjin amukag faraógkan jegajiag yutain segaidau, dutikam ditan chichajak: “Joséyai wetajum, nunikjum nii wajinjutpatig duke umiktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ashí nugkanum yapajut tepeau asamtai, aents aidauk senchi waituidau, imaniagtai José trigo ijumjamun ashí ujainiuwai egiptunmaya aidau sumaktinme tusa, yapajut aan senchi tepea wegau asamtai. ");
INSERT INTO agr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Tuja ashí tikich nugkanmaya aents aidaush José trigo ijumjamu sumakmi tusag Egipto nugkanum shimujakui, wagki ashí tikich nugkanmakesh yutaig shiig atsau asamtai. ");
INSERT INTO agr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Egipto nugkanum trigo ayawai tabaun Jacob dekaa, niina uchiji aidaun chichajak: “¿Atumesh wajukeakjumea pempeentunikjumesh ayatkesh niinish batsatjume? ");
INSERT INTO agr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Mina yamai ujatkaje Egipto nugkanum trigo kuashat ayawai tusa. Aan batsamtsuk atumesh wejum trigo sumakjum utitajum, dutikawagmin nunú, iish yuwami tikima nujantai jinawaig”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tusa tima Josén yachi diez aajaku aina nunú Egipto nugkanum trigon sumakagtatus shiyakajui. ");
INSERT INTO agr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Nunik shimiagtaish Jacopak Benjamín José yachi aajakua nunak akupkachui, wagki jusha José megkaekauwa antsag megkaekai tau asa. ");
INSERT INTO agr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Tuja ashí Canaág nugkanmag nujan tepeau asamtai, Israela uchiji aidauk tikich aents aidaujai ijunag Egipto nugkanum trigon sumakagtatus shiyakajui. ");
INSERT INTO agr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Josék Egipto nugka apuji aajakui, nuniau asa aents tikich nugkanmaya trigon sumaktatus kauntaik nii sujujakui. Nuna sujak pujai, niina yachi aidaushkam jegawajui, nunikag José emtin tikishmajag nijayin nugka antig pujusajui. ");
INSERT INTO agr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Nuniagtai José diikma niina yachi aidaun wainkauwai, dutika wainkayatak dekachu utugmaina numamtuk senchi chichajuk: “¿Atumesh tuwiyatigmea minagme?” tiuwai. Tusa tama dita ainak: “Iik canaágnumiati trigo sumaktasa mininaji”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Tuja Josék niina yachi aidaunak shiig wainkauwai, untsu ditak juka mina yatsujuapita tichajui. ");
INSERT INTO agr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nuadui José niina yachi aidau emematam atinun kajamjamun adeajui, nunik chichajak: “Atumek dekamin ainagme, nunin asajum wajuk utuaik jetemainaita tusajum, dekamatasa yujagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Tama dita aínak: “¡Atsa apuh! Ii amina inakem aidautik duka nuniatsji, ayatak trigo sumaktasa yujaji”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tusag: “Ashí ii ainag jutiik makichik aishmagkuk akiamu ainaji. Iik aents pegkeg ainaji, tuja dekamati tusa awemataigkesh ainatsji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Tiagtai José chichajak: “Atsa, wainkajum tajume, atumek wajuk utuaik jetemainaita tusajum dekamatasa yujagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Tusa tama dita aimainak: “Jutii amina inakem aidautinak, iina apajig doce akimpakui, tuja iik Canaán nugkanum batsamin ainaji. Tuja makichik iina yachi ekeu iina apajijai juwakmae, untsu tikich iina yachi aajakua duka atsawai, jakauwai”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Nuna aatus tiagtai José ataktu ditan chichajak: “¡Nijah, juwi tajime! Atumek dekas dekamin ainagme, ");
INSERT INTO agr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","tuja yamai dekapsatjime atumesh dekaskeash chichajum: Junak faraógka daajin atum umiktinun tajime. Atum chichaakjum, yatsug ekeu pujawai tajum nunú tatsaigkik juwi pujajum duka shiyakchattagme. ");
INSERT INTO agr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Yamai atum ainajum anuiya makichik akupkatajum, yatsum ekeun utiti. Untsu tikich aidautigmek juwi achinkajum batsamsattajume, nuni dekajuattajime atumesh dekaskeash chichajum nunak. Untsu nunú dekaskechuitkuig, dekamin aidauwap tuu yujawa titatjime. ¡Junak dekas faraógka daajin tajai!” tau. ");
INSERT INTO agr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Nuna tusa aents achika chimpitainum chimpia kampatum tsawan batsasui. ");
INSERT INTO agr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Dutika nunú kampatum tsawan nagkaemai ditan chichajak: “Wika Apajuínak ishamajai, nuadui atumesh wi tajim nunú betek umiktajum, nunikagmin wishakam tsagkujan mautsuk idaisattajime. ");
INSERT INTO agr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Atum dekas aents pegkeg ainakjumek, makichik atumi yatsum juwi ukuktajum, untsu tikich aidautigmek trigo jukijum wetajum atumi patayi aidau yuwatnume. ");
INSERT INTO agr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Nunikjum atumi yatsum ekeu pujawai tajum nunú itagtuatajum, dutikawagmin dekaskeash chichajum nunú dekaami. Untsu nunú dekaskechuitkuig atumek mantamnattagme”, tiuwai. Tusa tama ditashkam ayu duke ati tiajui. ");
INSERT INTO agr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Nuna tusag diták pempeentunikiag chichagdayinak: “Juka iik iina yachi sujukuitag nuadui jutikam aji. Iina yachi buutak, wait anenjugtajum tusa imatjutpakuish, antugtsuk sujukuitag nuadui juju utugchata juka igkuaji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Tiagtai Rubén ditan chichajak: “Wika juna aneasan uchi maawaigpajum tusa tamaitkujum, minash antugtukchau ayugme; yamai nii maamunum jutika waitkam ainaji, nunú umiaku aatsa dekapjagmi”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nuna tusa chichainakush Josék ii chichamunak antawapi tuinachu, wagki nii chichamunak tikich aents etsegtuidau asamtai. ");
INSERT INTO agr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Aatus dita chichainamun antuk, Josék tikich yantamnum wee buutiuwai. Nunik ataktu wakitki niina yachi batsatbaunum jeganta dita wainbaunum Simeógkan etegka juki egkeatajum tima egkea emetuauwai. ");
INSERT INTO agr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Nuna dutika José niina aentsji aidaun inajui: “Tikich aina auk ditá costaljin trigo aimjugtajum, dutikakjum dita kuichkijishkam jukijum awagtukjum, dita trigo chimpia juwamujin egketuatajum. Tuja jintá wenak yuwawagtinchakam dutiksagmek susatajum”, tiuwai. Tusa inajam imatiksag umikajui. ");
INSERT INTO agr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Dutika umigkam ditá burrojin trigo aimjamun patag jukiag shiyakajui. ");
INSERT INTO agr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Nunik we wenakua dita kajigtinnum jegantag, makichik burrojin ayujatatus costaljin atia diikma wainkauwai trigo sumaku kuichik akikmakbauk imanisag awantak egkemtatman. ");
INSERT INTO agr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Dutika wainak, yachi aidaun chichajak: “¡Antuktajum, wi kuichkin akikmakmag nunak awagtugkine! ¡Nijah mina costaljui egketana!” tau. Tutai ashí wainkag senchi puyatuk kujainak pempeentunikiag tudayinak: “¿Wagka Apajuísh junash jutijamae?” tuidau. ");
INSERT INTO agr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Nuna tusag we wenakua ditá apaji Canaán pujamunum jegawajui. Nunikag dita wekaesa wainkamujinak ashí ujakajui, nuna ujakag nuadui apajin chichajuinak: ");
INSERT INTO agr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Apu Egipto nugká apuji pujuma nunú iinak shiig senchi chichagtamkame, dutijamak: ‘Atumek dekamin ainagme’, tusa tujamae. ");
INSERT INTO agr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tusa tujamkui ii ayaaku: ‘Atsa, iik aents pegkeg ainaji, dekamnukesh ainatsji’, tusa timaji. ");
INSERT INTO agr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tuja nuigtushkam chichagku: ‘Jutiik ashí ijumjamak makichik aents akigbautik doce aayaji; nuniamu makichik megkaekauwai, untsu tikich ekeuwa duka amina aujai Canaágnum pujume’, timaji. ");
INSERT INTO agr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Tusa tajin nii chichagtamak: ‘Ayu, dekas aents pegkejash ainajum dekapsatjime, juwi makichik yatsum ukuktajum nunikjum ujumak trigo jukijum atumi pataim yuwatin ejetuatajum. ");
INSERT INTO agr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Tujash nunú susa ukuakjum atumi yatsum ekeu tajum nunú itagtuatajum. Dutikawagmin duwi wisha aents pegkejap ainawa titajime. Nunú itawagmin wainkan, juju yatsum ukuajum nunashkam jiiktajai, dutikamtai atumesh shiig agkan juju nugka juwish yujasminjum’ tujamae”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Aatus apajin ujakag idayinak nuadui, maki makichik ditá costaljin atija diikma kuichik ijiamu aajakuk imanisag chimpimtatman wainkajui. Dutika kuichkin wainkag ditá apajijai senchi ishamkajui. ");
INSERT INTO agr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Nuna wainak Jacob chichaak: “Minak atumek shiig uchigtuchu ukugjume. Josésh megkaetugkauwai, Simeógshakam antsag wakitkig taache. ¡Yamai juju mina uchig Benjamín jujutkittagme! ¡Wika mina uchignak megkaejan wegag jama!” tau. ");
INSERT INTO agr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tutai Rubén apajin chichajak: “Apawa mina idaitugsata, wi Benjamígnak ayan kuitamsan awagkin itajuatjame. Untsu wi awagki itachmataig, mina uchig jimaja au maata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tusa tama Jacob ayaak: “Mina uchijuk atumjaig makichkish wechattawai. Niina yachi José jakamtai ima nigki juwake. Namputchawame jintá weagmin mina uchig megkaekamtai, wi múuntuch wajasa pujag nuna wake besemag dekapeakun buu buutkawa jakuig, duka atumi utugchatji atatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tuja aan nagkaemas nujan tepea wegau asamtai, ");
INSERT INTO agr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","yutai sumaka ikaunmamu ashí amuekamtai, Jacob niina uchiji aidaun chichajak: “Ataktu wejum trigo sumakjum utitajum, yumain atsugtamji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tutai Judá apajin ayaak: “Tujash apu iina chichagtamak: ‘Atumi yatsum ekeu tajum nunú itachiatkugmek, juwi ataktu taagmek waitkaigpa’ tujamayi. ");
INSERT INTO agr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tujabiu asamtai iina yachi ekeuwa anú jutijai akupeakminig, shiyaka trigo sumaka ikaunmamainaitji. ");
INSERT INTO agr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Untsu ame iina yachi ekeuwa anú awemashkuminig, iishkam yutai sumakuik wechattaji. Apu iina chichagtamak yatsum ekeu itachiatkugmek, juwi ataktu taagmek waitkaigpa tusa tujamayi”, tau. ");
INSERT INTO agr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Tusa tama Israel chichaak: “¿Wagka minash ibau pegkegchaush itagtuaugme? “¿Wagka nunú apush, tikich iina yachi ekeu ajutjamji tusagmesh ujakmaijume?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Tama dita ainak: “Iishkam ujamainchawaitku, nii iina patayi aidaun pachis inimpakui ujakmaiji. Dutika ajin nii inimpak: ‘¿Atumin apash pujawak? tusa ataktu inimpak, ¿tikich yatsumish pujatsuak?’ tusa inimpakui, aus yatsum ekeu itaata tujamti tachau asa ujakmaiji”, tiajui. ");
INSERT INTO agr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Nuna tusag Judá niina apaji Israelan chichajak: “Apawah, uchik mina idaitugsata nii juki wegagmi, nuniashkuik ashí iina uchiji aidaujai nuigtu, ame aatsa nujantai jinattaji. ");
INSERT INTO agr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Wi niinak kuitamkattajai. Tuja jintá weamunum utugchat nagkaemakmataish, wi nunak umiktajai. Wi juna tiuwaitkun awagkin juwi itashmataig, ashí nunú utugchatak minai juwakti. ");
INSERT INTO agr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ame sujimá pujachkuminig iik jimajakesh yutai sumaka ikaunmamain wajaji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tusa tama apaji ditan ayaak: “Ayu, duka nunisag uminkati, tuja nuniktin asamtai, iina nugkenia dekas waji shiig pegkeg aina nunú apu susatin etegja jukitajum: Ujumak bálsamo, ujumak dapa yumiji, kugkuin mirra, nueces, almendra aaja tinamjajum jukitajum. ");
INSERT INTO agr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Nuigtushkam jukitajum kuichik yama nagkamchaku jukibiujum nuni kuashat. Dutikajum kuichkin awagtugmakiagma nujai ijumjajum susatajum, namputchawame dewaka egkeachajiawash. ");
INSERT INTO agr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","¡Ayu yamaik yatsum ekeuwa dushakam jukijum ataktu wetajum nunú aentsjai chichaakjum. ");
INSERT INTO agr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Apajuí ashí senchigtina nunú atumnak yaimpaktinme, dutijamamtai apu wait anenjamag yatsumin Simeógkan agkanmitka, yatsum Benjamígnash emettsuk awagkiti. Untsu namputchawame nuna awakeachkuish, wika uchigtuchukesh juwaktin atajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Aatus timatai Jacopa uchiji aidau waji apu susatin aidaun yajuakag nuigtushkam kuichkin yaunchuk jukimun nagkaesau jukiag, Benjamígnashkam jukiag Egipto nugkanum shiyakajui. Nunikag José pujamunum jegawagmatai, ");
INSERT INTO agr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","José Benjamígkan niina yachi aidaujai wajaun wainak, aents José jenian kuitamnun chichajak: “Juju aents aina juju yajuakam mina jegajui ejegata, dutikam baka maam inagkata. Yamaik ditak etsa tutupit ai, wijai yujumkan yuwawagtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Tusa tima niina inake waji kuitamnuk imatiksag umikui. Dutika nigki aents aidaunashkam yajuak José jeen emauwai. ");
INSERT INTO agr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tuja yajuaka José jeen emam senchi ishamkajui nunik diták pempeentunikiag chichainak: “¡Junak anagtamak aikagmawai! Ii kuichik akikmakbaun awagtugmakbau egketu wainkabiag nuadui jutijamji, niina inake etami, ashí iina tagkuji aidaujai waitkagmastatus”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Nuna tusag jegaa eke waittsuk José wajijin kuitamnun jegaantajui niijai chichastatus. ");
INSERT INTO agr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Nunik jegantag chichajuinak: “¡Apujuh tsagkugtugta! Ii yaunchuk taamiag duka trigo sumaktasa taamiaji. ");
INSERT INTO agr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Tujash nunú sumaku kuichik akikmakmayag nunú ii kanagtinum jeganta costal atia diikma, kuichik ii akikmakbau aajakuk imanisag egketaidau wainkabiaji. Dutika wainkau asa yamai awagkitasa itaaji. ");
INSERT INTO agr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tuja nuigtushkam trigo sumaktasa kuichik nuni kuashat itaaji. Untsu yaki kuichkinash awagkish egketjamayawa duka dekatsji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Tiagtai nunú inak ditan ayaak: “Wainkajum puyatkaigpajum, aunak Apajuí atumi apa Apajuíjiya dutsu costaljuminig egketjamayatai, wi atum akikmakbaunak ashí jukimiajai”, tiuwai. Nuna tusa idayak Simeógkan jiiki juki dita batsatbaunum ejentauwai. ");
INSERT INTO agr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Nuna dutika ashí yajuak José jeen utsauwai, dutika yumin juki susauwai nawen dijagtinme tusa, nuigtushkam dita burroji aidaunashkam yutain juki ayugtukui. ");
INSERT INTO agr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Tuja etsa tutupit ai yujumkan yuwak José taatin asamtai, ditashkam nuwi yuwatnunak dekainau asag dakak batsamas niina anentag susatnun umikajui. ");
INSERT INTO agr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Dutikau asag José taamtai, anentag susatin itaamu aidaun jukiag susajui. Nuna suwinak tikishmatjag tsuntsumawag nijayin nugkan antig pujusajui emematuinak. ");
INSERT INTO agr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nuniagtai José ditan iniak: “¿Atumesh pegkejak yujajum?” tau. Tusa ataktu iniak: “¿Atum chichaakjum iina apajig múuntuch wajas pujawai timaijum dusha pegkejak pujuma?” tau. ");
INSERT INTO agr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Tusa iniam eme anentus tsuntsuma chichajainak: “Iina apaji amina inakmea duka eke jatsui, pegkeg pujume”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tusa tiagtai José ditan diistakama niina yachi Benjamín nunú nuwanmak akiinauwa nunú wajattaman wainak chichaak: “¿Jukait atum chichaakjum iina yachi ekeu pujawai timaijum nunú?” tau. Tusa: “¡Uchuchih, Apajuí pegkegnum yumigtamsati!” tiuwai. Juna aatus tusa, ");
INSERT INTO agr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","José niina yachin wainak senchi wake besemag buutmain dekapeak, ukuki niina kanutaijin tupikaki waya buutiuwai. ");
INSERT INTO agr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nunik buuti nagkanak yumin juki yapin niijai ataktu jegan niina wajijin kuitamnun chichajak: “¡Yutai pekastajum!” tusa inamjauwai. ");
INSERT INTO agr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Tusa timatai inak aidaushkam Josénak makichik mesanum ekettsajui, dutikak Jacopa uchiji aidau yuwatnunashkam tikich mesanum ekettsajui. Tuja egiptunmaya aents aidaushkam aantsag ditash kanakag yuwidau. Wagki egiptunmaya aentsuk Hebreo aentsjaig tsanigkag yumainchau asamtai, dutikau ainawai. ");
INSERT INTO agr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Tuja José yachi aidau mesanum pekamainakug iwaiyá ekemsamtai, ekeu aidaushkam nunisag ekemsag pekaamak tsakatnum nagkankauwai, José nuni pekamsati tibaunak imanisag. Nuwi pekamsag anentai jegashmin dekapenak pempeentunikiag niinidau. ");
INSERT INTO agr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yutai aidaunashkam dutiksag maki makichik pekattsauwai. Untsu Benjamígkan ima kuashat tikich aidaun nagkaesau aimjuk ekettsauwai. Aatus ashí ijunas shiig yuwawag, umutnashkam uwajag, dakunkut nagkankajui. ");
INSERT INTO agr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Nuna yuwawag, nuadui José niina inake niina wajijin kuitamnun juna aatus inajui: “Juju aents aidau jukiagtin dita costaljin trigo aimjugta, dutikam maki makichik ditá costaljin awantak kuichik egketuata. ");
INSERT INTO agr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nunú dutikakum mina shikika umutaig plata najanamua nunú jukim, dita yachi ekeu trigon sumak kuichkin akikmakma nujai apatkam niina costaljin awantak egketuata”, tiuwai. Tusa tima José jenia waji aidaun kuitamnushkam imatiksag umikui. ");
INSERT INTO agr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Dutika ashí umigkagmatai, wetajum tusa José tima, kashikmas etsa yama jiinai burrojin yajuak shiyakajui. ");
INSERT INTO agr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nunik yaaktan ukukiag atushat kuwagainatsaig, José niina inaken chichajak: “Aents shiyakagma nunú pataetuktajum, dutikajum amaigkajum, juju aatsa titajum: ‘¿Wagka atumesh shiig kuitamkamaitkugmesh pegkegchaunmash iikagtagme? ¿Wagka shikika umutai plata najanamush kasamkaugme ");
INSERT INTO agr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","mina apug duwi uumak dekamnuwe dusha? Juka atumek shiig pegkegchau ankaugme’, tusajum titajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Tusa tima Josén inake ditan pataetuk amainag, apu José tibaunak imatiksag tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Tusa tama dita aimainak: “¿Wagka amesh ajamesh jutiish tukagtame? ¡Iik makichkish kasamchau ainaji!” tuidau. Nuna tusag: ");
INSERT INTO agr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","“Iik kasachu asa iina costalji canaágnum jegaa ujaka diikma, kuichik chimpiju wainkaish juki awagtuki itajua sumag aikayatkuish, ¿wagkaik wainkaish iina apuji jeniash, kuichkish, orokesh kasamka jukish ukuktaji? ");
INSERT INTO agr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Untsu ame inakem ainag juwiyash yana costaljin egketuk wainkatam duka mantamnati, nunikmatai tikich aidautik apu inake wajasagmi”, tuidau. ");
INSERT INTO agr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Tusa tiagtai inak ditan chichajak: “Ayu, atum tajum duka nunisag uminkati. Tujash yana costaljin egketuk wainkatag duke mina inakjuk atatui. Untsu tikich aidautigmek agkan juwaktatjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tusa timatai maki makichik ditá costaljin nugká apusag jigkakbaun atijag ijumjajui. ");
INSERT INTO agr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Dutikawagmatai inak ditá yachi iwainum nagkama diya diyakua dekas ekeunum ejekama Benjamígka costaljin apu shikika umutaiji egketun wainkauwai. ");
INSERT INTO agr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Dutika wainkamtai, puyatkag wake besemag dekapeamunum jáanchjin japiki ichigkag ataktu dita costaljinak burrojin patag yajuakag waketug yaakat jegawajui. ");
INSERT INTO agr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Nunik Judá niina yachi aidaujai waketug José niina jeen pujai jegawajui. Nunikag tikishmatjag nijayin nugka antig pujusajui. ");
INSERT INTO agr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Nuniagtai José ditan chichajak: “¿Wagka atumesh anísh yujagme? ¿Atumek dekatsjumek aents witag juninuk anentaimas dekagmamaina duka?” tau. ");
INSERT INTO agr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Tusa tutai Judá ayaak: “¡Ii tumainuk makichkish atsugtamji! ¿Iik takamsachji takuish wajuk ejetajiki? Apajuí iina pegkegchaujinak waitjamkaji. Nuadui ii aidautik ame shikika umutaigmin takaku wainnaka nujai, ashí amina inakem waigkagtatji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Tusa tama José chichaak: “¡Atsa duka makichkish nunikchattawai, ima mina shikika umutaijun takaku wainnaka duke mina inataijuk atatui! ¡Untsu tikich aidautigmek shiig aneasjum agkan atumi apa pujamunum shiyaktatjume, makichkish atumin waitkagmamainuk atsawai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Tuja Judá Josén jegantun chichajak: “Mina apujuh, wait aneasam kajegtukaipa, wisha makichik chichaman ima amek antamin titajame. Amek dekas faraógkajai betekaitme. ");
INSERT INTO agr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ame jutii inijatkum, atumi apash pujawak, tuja tikich yatsumish atsuak tukagtakmin, ");
INSERT INTO agr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ii ayaaku, iina apajig shiig muumpakiu pujugtamji, tuja iina yachi tsakat pujawai iina apaji muumpakiu ai akiinauwa nunú. Tuja nunak iina apajig shiig senchi aneenuwe, wagki nunú nuwanmak jimag akiinau tikich jakamtai, makichik juwaku asamtai, timaiji. ");
INSERT INTO agr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tusa tajin ame chichaakum: ‘Nunú itagtuatajum wainkatjai’ tusam segajatmayume, ");
INSERT INTO agr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","tusa takumin ii ayaaku: ‘Nunú uchik apajin ukukig minimaitsui, wagki ukuamak apaji jamain asamtai’, timaiji. ");
INSERT INTO agr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tujash ame chichagkagtakum: ‘Nunú yatsum ayasam minachkugminig, makichkish awayashtatjime’, tukagtibiume. ");
INSERT INTO agr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Tusa tukagtiamin iina apaji jegajua juna aatus tujamaji tusa, ashí imatiksaik ujakmaiji. ");
INSERT INTO agr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Nunika pujajin iina apaji chichagtamak: ‘Ataktush wejum trigo sumaka utitajum’, tusa tujamaji. ");
INSERT INTO agr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tusa tujamkui ii chichaaku: ‘Apawah, iina yachi ekeuwa nunú jutijai minachkuig iikik wemaitsuji, wagki nii minichmataig, nunú apua duka makichkish jegajuaik waimaitsuji’, timaiji. ");
INSERT INTO agr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Tusa tajin iina apaji chichagtamak: ‘Atumek dekagme mina duwag jimagchik uchin uchigmakua duka; ");
INSERT INTO agr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","nuwiya tikichia duka ayatak megkaekauwai, nuniku asamtai, yamaikish waintsujai. Wika dekas kuntin ikamia kajenuap yuwawaita tiuwaitjai. ");
INSERT INTO agr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tuja juju niina yachi wijai puja nunú jukijum namputchawame megkaekamtaig duka atumi utugchatji atatui, wi muumpakin pujag nuna wake besemag anentaimkun buu buutkawan jataik’, tujutmayi. ");
INSERT INTO agr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Tusa tujutiu asamtai, juna uchin ukukin wiki jegamtaig, juju ima senchi aneetaiji asamtai, ");
INSERT INTO agr_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","iina apajig uchijin wainkachag jamainai. Nunik jakamtaig ii utugchatji amainai, wagki múuntuch wajasu asa senchi ane anentaimkawa jamain asamtai. ");
INSERT INTO agr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nuadui wi mina apajun chichagkun: ‘Apawah, wi uchinak kuitamkan itatjai, wi juna tiuwaitkun awagkin juwi itashmataig, ashí nunú utugchatak minai juwakti’, tibaijai. ");
INSERT INTO agr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Nuadui apuh wi amina tajame, wait aneasam antugtukta juju uchia nunú amina inakem amaina nuna wi juwaktajai. Nuniai nigka tikich yatsug aidaujai wakitkiti. ");
INSERT INTO agr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","¿Wagkanuk uchí ukuknush wikish mina apag pujamunmash jegatja? Wi uchí ukuki jega ai, mina apag anentaimak waitiakui diitan dakitajai”, tusa Josén tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","José ugmamá pujumainchau dekapeak, niina inake aidau emtin tumainchau asa, senchi untsumak, tikich aidautigmek ashí jiinjajum shiyaktajum tima, jiinag ukukiajui. Nunikagmatai niina yachi aidaun chichajak: “¡Wika atumi yatsum Joséyaitjai!” tusa etsegtumakui. ");
INSERT INTO agr_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Nuna tusa Josék shiig senchi jiika buutu, imatu asamtai kuashat aents egiptunmaya aidau antukajui, tuja faraógka pujusa inamtaijinchakam dekawajui. ");
INSERT INTO agr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Tuja José niina yachi aidaun chichajak: “¡Witjai Josénuk! ¿Mina apajush iwakuk puja?” tau. Tama ditak ishamkag aimkashmin wajas ijuntsajui. ");
INSERT INTO agr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Nuniagtai José ditan chichajak: “¡Aantsuk wait aneasjum juwi minai kaunatajum!” tau. Tusa tama jegantagmatai yachi aidaun chichajak: “Witjai atumi yatsum Josénuk, atum Egipto nugkanum sujutkauwaitjum nunú. ");
INSERT INTO agr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tujash wainkajum wake besemag anentaimkujum atumek pempeentunikjum kajegdaikaigpajum, mina sujutkauwaitjum duka atum dutijatsjuminig, Apajuí pujutan ayamjuktin ati tusa juni awetiuwai. ");
INSERT INTO agr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Juju nugka juwig nujan tepea jimag mijan weawai, tuja nuigtushkam cinco mijana imajin ajak ajakmamash tsapaishtatui. ");
INSERT INTO agr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nuniktin asamtai Apajuí juni akupkata tujamaidau asagmatai, minak atumek juni sujutkau ainagme. Nii yutai aidaun ijumjatin ati dutikamtai nuna yuwinak iwaku atum wegantush juju nugkanum batsamsatnume tau asa. ");
INSERT INTO agr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Atumchauwaitjume mina juju nugkanum awetiutigmek. Apajuíyai mina juwi itajua faraógka chichajin ema apujtusa duka, nuadui minak ashí niina jenia aina nunak amina chichamjumin batsasta dutikakum ashí Egipto nugkashkam amek kuitamkata tujutiuwai. ");
INSERT INTO agr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Yamaik wamkesjum mina apag pujamunum wetajum, nunika jegajum juju aatsa ujaktajum: Juna aatus amina uchijum tawai: Apajuí minak ashí egiptunmaya aentsun apuji eti apujtuse. Dutijuau asamtai megkaetsuk wamkesam juwi taam waitkata. ");
INSERT INTO agr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Núnikam nugka Gosén tutaya juwi ame uchijum aidaujai, tijajum aidau, tagkujum aidau, nuigtu ashí amina wajijum aidau yajuaka kaunam wi pujag juwi tikiju pujusta. ");
INSERT INTO agr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Juwi pujusamin wi amina pataim aidaun tuja amejai aents yujau aidaush yuwawagtinun yutain amastajai nujantai waittsaijum; nujan tepea nunak cinco mijan atatui, titajum. ");
INSERT INTO agr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Tuja wi taja nunak mina yatsug Benjamígkash atumjai wajas antamunum tajai. ");
INSERT INTO agr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Juju aatsajum mina apag wi Egipto nugkanum apu wajasan pujag nunú ujaktajum, tuja nuigtu tikich juwiya wainkaujum dushakam ujaktajum. ¡Wamak wejum mina apag utitajum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Nuna tusa yachi Benjamígkan pagkuk buutu. Nunitai Benjamígshakam Josén pagkuk wajas buutiuwai. ");
INSERT INTO agr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Nunik duwi tikich yachi aidaunashkam pagkuk yapinum kugkuak buutiuwai. Nunikag duwi José yachi aidau niijai shiig chichasajui. ");
INSERT INTO agr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Nunú José yachi aidau kaunawaje tabau faraógka pujusa inamtaijin antuekauwai, nuna antuka faraón niina atuwe aidaujai shiig aneasajui. ");
INSERT INTO agr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Nunik faraón Josén chichajak: “Amina yatsum aidau kauna nunú trigon aimjag burrojin pataja jukiag Canaán nugkanum wetinme, ");
INSERT INTO agr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","nunik jegawag dita apajin, patayi aidaujai yajuakag juwi itatnume. Dutikawagmatai wi dekas dita pujustinnak nugka pegkeg Egipto nugkanum awa nuna susatjai, dutikawajam nuwi pujusag shiig yuwawag pujustinme, tajai. ");
INSERT INTO agr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ame juwiya carreta aidau ishitkata, nuwi ditá nuwe aidaun uchiji aidaujai yajumainak, atumi apanashkam jukiag itatnume. ");
INSERT INTO agr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Dita wajiji aina nunak puyatjukainmegka, wagki egiptunmaya dekas waji pegkeg aina nunú ditanuk agtin asamtai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Tusa tima Israela uchiji aidaushkam, ayu duke ati tiajui. Tiagmatai José nii ishitkauwai carreta aidaun faraón tibaunak imatiksag, dutikak nuigtu jintá weaku yuwatnujinashkam susauwai. ");
INSERT INTO agr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nuigtushkam dita nugkugtinun maki makichik jáanchin tinamiuwai. Untsu Benjamígkan cinco jáanchin nugkutain susauwai, dutikak nuigtushkam trescientos kuichik plata najanamun susauwai. ");
INSERT INTO agr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Tuja apajinashkam waji shiig pegkeg egiptunmaya aidaun etegkeg yajuak diez burronum patag akuptukui, nuigtu tikich diez burronum yutai trigon pagjai patatug nii jintá minisa yuwatnujin ishitkauwai. ");
INSERT INTO agr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Dutika ashí susam nuna jukiag shimiagtai José niina yachi aidaun chichajak: “¡Jinta wesajum wainkajum maani yujaigpajum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tusa tima egiptunmaya jiinkiag Canaán nugkanum ditá apaji Jacob pujamunum jegawajui. ");
INSERT INTO agr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Nunik jegawag, Jacopan ujainak: “Josék yamaikish iwaku pujawai, nuniu asa nii Egipto nugkan apuji wajas pujume”, tusa ujaam puyatuk anentaimak dekaskeash tujutuina tusa dita tuinamunak antugmainchau dekapjauwai. ");
INSERT INTO agr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Nunitai dita Joséjai chichasbaunak imatiksag ujakajui. Tusa tamash utujimiatak, José carreta aidau niina jukiti tusa ishitkamun wainak shiig aneasui. ");
INSERT INTO agr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Nunik Jacob chichaak: “¡Make yamaik mina uchig José iwaku pujamun dekajai! ¡Nuniku asan wisha wenu iwaku pujag juajuik mina uchijun waipaktajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel niina wajiji aidaun niina tagkuji aidaujai yajuak wea weakua bershebanum jegauwai, nuwi jegaa Apajuí niina apaji Isaaka Apajuíjin emematak kuntinun maa nuna nejen ujumak apeauwai. ");
INSERT INTO agr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Dutika nuwi kanittaman Apajuí kajanum wantintuk niina daajin adaitus untsukui. Tusa untsuam nii ayaak: “Juwi pujajai, Apujuh”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Tutai Apajuí chichajak: “Witjai Apajuí amina apa Apajuíjinuk. Egipto nugkanum wetak ishamkaipa, awi pujusamin wi ame uchijum wegantunak shiig kuashat ikauntuktatjame. ");
INSERT INTO agr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nuadui ame Egipto weam nunak wi uyuntsattajame, tuja wiki ame wegantu aidaunashkam Egipto batsatunak jiijan awagkitnaitjai. Tuja nuigtushkam ame eke jatsminig José kuitamjamkamtai pujusam jakattame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Tusa tima kanag tsawag, Jacob bershebanmaya jiinki weuwai. Nunik wenak Israela uchiji aidau, niina apajin, ditá uchiji aidaun nuwe aidaujai aatus faraón carreta ditan yajuakti tusa ishitkamunum pekamiag shiyakajui. ");
INSERT INTO agr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Nunik shimak Jacob ashí yajumakui, nuniak nuigtushkam baka aidaunash, uwig aidaujaí Canaán pujusa uyujkamu aidaunak ashí yajuak Egipto nugkanum weuwai. ");
INSERT INTO agr_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Tuja niina uchiji aidaush, nawanji aidaush, tijaji aishmag aidaush, nuigtu tijaji nuwa aidaushkam Jacob wetai ashí shiyakajui. ");
INSERT INTO agr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Juju ainawai Israel aents aidau Egipto nugkanum shiyakajua duka: Jacob niina uchiji aidaujai. Tuja Rubén aajakui iwai. ");
INSERT INTO agr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Untsu Rubénka uchiji aidauk: Hanoc, Falú, Hesrón, Carmí aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Tuja Simeógka uchiji aidauk: Jemuel, Jamín, Ohad, Jaquín, Sóhar, nuigtu Saúl canaágnumia nuwanum akiinauwa nunú aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Untsu Leví uchiji aidauk: Guersón, Quehat, Merarí aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Tuja Judá uchiji aidauk: Er, Onán, Selá, Fares, Zérah aatus aajakui. Tuja Er Onágjai Canaán nugkanum jakauwai. Untsu Faresa uchiji aidauk, Hesrón, Hamul aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isacara uchiji aidauk: Tolá, Puvá, Job, Simrón aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Untsu Sabulógka uchiji aidauk: Séred, Elón, Jahleel aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Jacob niina nuwe Leayai Padán-aram nugkanum pujusa uchin akigkua duka, juju aajaku ainawai. Tuja niina nawanji Dinashkam. Nuwa aishmag aidaujai ashí ijumjamak, nii wegantu aidauk treinta y tres aents aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Tuja Gad uchiji aidauk: Sefón, Haguí, Esbón Suní, Erí, Arodí, Arelí aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Untsu Asera uchiji aidauk: Imná, Isvá, Ishví, Berián nuigtu ditá umayi Sérah aatus aajakui. Untsu Beriá uchiji aidauk: Heber, Malquiel, aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Tuja juju aajaku ainawai Jacob Zilpáyai uchi akigbau aina duka. Zilpá aajakui Labágka inake, nuna niina nawanji Lean susauwa nunú. Niina uchiji wegantu aidauk ashí ijumjamak dieciseis aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jacob niina nuwe Raquelai uchi akiamu aidauk: José, Benjamín aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","José niina nuwe Asenatai Egipto nugkanum pujusa uchi akiamuk: Manasés, Efraín aatus aajakui. Asenatak aajakui sacerdote Potifera Onnumia aajakua nuna nawanji. ");
INSERT INTO agr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Tuja Benjamígka uchiji aidauk: Bela, Béquer, Asbel, Guerá, Naamán, Ehi, Ros, Mupim, Hupim, Ard aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Juju aajaku ainawai Jacob Raquelai akiamu aina nuna uchiji wegantu aidauk. Ashí ijumjamak catorce aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Untsu Danka uchiji aidauk: Husim aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Tuja Neftalí uchiji aidauk: Jahseel, Guní, Jezer, Silem aatus aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Juju aajaku ainawai Jacob Bilháyai uchi akigbau aajakua duka. Bilhá aajakui Labágka inake, nuna niina nawanji Raquelan susauwa nunú. Niina uchiji wegantu aidau ashí ijumjamak, siete aents aajakui. ");
INSERT INTO agr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ashí aents Egipto nugkanum Jacobjai ijunag kaunau aina nuwiya ditá nuwe aidau dekapatsuk, aishmag aidauk dekaapamak sesenta y seis aents aajakui, ima dita wegantu aidauk. ");
INSERT INTO agr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","José Egipto nugkanum pujusa uchi akiamua duka jimagchik aajakui, tuja nujai ashí ijumjamak Jacob wegantu aidauk setenta aents Egipto nugkanmak jegawajui. ");
INSERT INTO agr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Nunik wesag Jacob, José ujakta nugka Goségnum pujai igkunkati tusa emtika Judán awemauwai. Nunik Goségnum jegawajun dekaa, ");
INSERT INTO agr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","José niina inake aidaun inajui nii egkemja wetinjin carro umiktajum mina apajun igkugtajai tusa. Tusa tima umikagmatai, nuwi egkemag weuwai, nunik niina apajin minittaman igkugkui. Dutika igkug pagkuk wajas senchi buutú wajau. ");
INSERT INTO agr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Imanitai Israel Josén chichajak: “¡Jakautskait tuwamjame, tujash iwaku pujamin paan wainkajame, nuniku asan yamaik jaknush maak anentaimsan jakatjai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Tusa tima José niina yachi aidaun niina apaji patayi aidaujai chichajak: “Wika yamaik wenu faraógka jegajuan, mina yatsug aidau nuigtu mina apag niina patayi aidaujai Canaágnum batsatu wijai pujustag tusag kaunawaje. ");
INSERT INTO agr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nunik mininak ditá uwigji aidaun baka aidaujai, ashí ditá wajiji aidaunak yajuakag kaunawaje, ditak tuke uwijan kuitamin, nuigtu baka tsakapau ainawai tusan ujaktajai. ");
INSERT INTO agr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Tusa ujaka ai faraón untsugmakag: ‘¿Atumesh waji takata takau ainagme?’ tusa inimpakuig: ");
INSERT INTO agr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","‘Ii aidautik uwig tsakapau ainaji, iina apachjishkam tagku tsakapajaku asagmatai’, titajum. Nuadui atumesh juju nugka Goségka juwi batsamsamnujum, wagki egiptunmaya aents aidauk tagkun tsakapau aina nujai ijunja pujutnak dakitin ainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Nuna tusa ukuak José faraógkan ujaktatus weuwai. Nunik jegaa faraógkan ujaak: “Mina apag mina yatsug aidaujai Canaán nugkanum batsatu uwig aidaun, baka aidaun, nuigtu ashí tikich ditá wajiji aidaunashkam yajuakag, Gosén nugkanum kaunawaje”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Tusa ujaka ukuak niina yachi aidaun cinco etegkeg juki, faraón wainkati tusa ejegauwai. ");
INSERT INTO agr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Dutikamtai faraón José yachi aidaun iniak: “¿Atumesh waji takata takau ainagme?” tau. Tusa tama dita aimainak: “Jutii amina inakem aidautik uwig kuitamin ainaji, iina apachji aajaku aidaush tuké tagkunak kuitamajaku asagmatai. ");
INSERT INTO agr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Tuja nujan tepeau asa canaágnumak chijichi uwig ayugmainush atsau asamtai, juwi batsamsatasa kaunaji”, tuidau. Nuna tusag: “¡Apuh, wait aneasam nugka Gosén tutaya au sukagtusta, iish awi batsamsagmi!” tiajui. ");
INSERT INTO agr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Tusa tiagtai faraón Josén chichajak: “Amina apa, amina yatsum aidau amejai ijunag pujusagtatus kaunawaje. ");
INSERT INTO agr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Juju Egipto nugka juka ame diyame, nuniau asam amina apa yatsum aidaujai nugka pegkeg Goségka au susata, dutikam, nuwi batsamsatnume. Tuja dita aina awiya tagku kuitamin yacha akuig, nunú jukim mina tagkuju kuitamjutuina nuna apuji adaikata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Tusa timatai, José niina apajinashkam juki faraón wainkati tusa ejentauwai. Dutikam Jocobshakam faraógkan eme anentus kumpamauwai. ");
INSERT INTO agr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Dutikam faraón Jacopan iniak: “¿Aminash wajupa mijana ajutjamua?” tau. ");
INSERT INTO agr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Tusa tama Jacob ayaak: “Wika junika wekae wekaekawan ciento treinta mijan ejejai. Mina mijanjuk ujumchiki, wika mina apag batsamajakajua imaniknuk ejechajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Nuna tusa Jacob faraógkan kumpama ukuak jiinki weuwai. ");
INSERT INTO agr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Nunikmatai José niina apajin niina yachi aidaujai faraón tibaunak imatiksag, nugka múun Ramsés tutai aajakua nuwi batsasui. Dutikam ditashkam nuwi nugkeenawag batsamsauwai. ");
INSERT INTO agr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Tuja nuigtushkam José niina apaji, niina yachi aidaujai ashí ditá patayi aidaujaí ijumag, yutai aidaun sujakui nujantai waittsainum tusa. ");
INSERT INTO agr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ashí nugka aidaunmak makichik trigokesh atsujakui, nuadui nujantak aan senchi wegau. Nuniau asamtai, egiptunmaya aents aidauk canaágnumia aidaushkam nujantai jinuidau. ");
INSERT INTO agr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Tuja Josék egiptunmaya aents, canaágnumia aents aidaujai yutain sumagtai kuichkijai yapa yapajiakua dita kuichkijinak ashí yajutuk faraógka jeen ijumjauwai. Dutika yajutuk kuichkigtinchau emakui. ");
INSERT INTO agr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Dutikamu asa Egipto nugkanmash, Canaán nugkanmash kuichik shiig atsutai, wajiyaik akikmakash yutainash sumaktinme nuninak egiptunmaya aents aidau Josén jegaji chichajuinak: “¡Wait aneasam yutai sukagtusta! ¿Kuichik atsujui nujantai jinatnume tusamek idaikagtustatam?” tuidau. ");
INSERT INTO agr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Tusa tama José ditan chichajak: “Kuichkijum atsugtamainakuig atumi tagkujum itaatajum, dutikawagmin nuna juwakun trigon amastajime”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tusa tima egiptunmaya aents aidauk ditá caballojin, uwigjin, bakajin, burrojin aatus yajuakag Josén ikautuawajui. Dutikawagmatai José nuna yajumak makichik mijadai trigon suu pujau. ");
INSERT INTO agr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tujash nunú mijan nagkaemakmatai, yutain amukag waituinak, ataktu Josén kautuawag chichajuinak: “Apujuh, iik dekas kuichkik shiig ashimkaji, tuja iina tagkuji aidaushkam ashí aminu wajase. Ii tikich sujaku yutai yapagmainuk atsugtamji, ima aentsti aidautik iina nugkejaig juwakji. ");
INSERT INTO agr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nuniau asamtai trigo sukagtakum dekas jutiishkam iina nugkejai sumajatkata, dutikagtuawamin iishkam faraógka inake wajasa iina nugkeenig nii takajainaku ajak sukagtusamin nunú ajakma nuwiya yuwawagmi. Tuja ¿amesh wagkamek jutiish dita nugken ajakma yutsuk batsamas jinaati tusamesh idaikagtustame?” tuidau. ");
INSERT INTO agr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tusa imatiagtai José nugka egiptunmaya aidaunak ashí sumakui faraógdau atinun, nunak egiptunmaya aents aidau nujantai jinak dita nugken sujukajui. Dutikamuk duka ashí faraógdau juwakui. ");
INSERT INTO agr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Nuna dutikawag egiptunmaya aents aidauk nugkenchau juwakag, apu inake wajasajui. ");
INSERT INTO agr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Untsu ima sacerdote nugkenak sumakchauwai, ditak faraón trigo susam nuna yuwa batsatu asagmatai. Nuadui ditak nugkenak sujukchajui wagki faraón susam yuwa batsatu asag. ");
INSERT INTO agr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Duwi pujus José aents aidaun chichajak: “Wi atumnak sumakjime, dutikamu asajum atumek yamaik atumi nugkejaí faraógdau wajasugme. Nuadui juju ajak ajakmatin jukitajum, dutikajum ajakmatajum. ");
INSERT INTO agr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Tujash nunú ajakma juwakjumek ujumak akankajum faraón susatajum, dutikakjum ipak usumta imajin juwaktata duka ajaatin, nuigtu atum uchijum aidaujai yuwatin, tuja atumjai batsatu aidau yuwatnujai jukitajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Tama dita aimainak: “Amek dekas jutiik shiig wait anenkagtame, nuniau asam ii nujantai jamainush uwemtikagtame. ¡Nuadui jutii aidautik faraógkan inake amí tuinaji!” tiajui. ");
INSERT INTO agr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Juna aatus José chichaman umikui. Nuadui ashí aents egiptunmaya aidauk ajakmamujinian ujumak akanak faraógka suu atinme tusa tiuwai. Nunú chicham umikbau aajakua duka yamaikish nunisag awai. Tuja untsu ima sacerdote aidauk dita nugkenak faraógkan susachaju asag, tuke akikmachu ainawai. ");
INSERT INTO agr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel aents aidauk Egipto nugka Goségnum batsamsajui. Nunik nuwi batsamas shiig kuashat yujakajui. ");
INSERT INTO agr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Tuja Jocopak Egipto nugkanum jegag diecisiete mijan pujusui, nujai ijumjamak ciento cuarenta y siete mijan ejeyuwai. ");
INSERT INTO agr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israel shiig muumpaki nii jakatnujin dekapmamag, niina uchiji Josén untsuka chichajak: “Wi titatjam nunú umigtuktinaitkumek, amina uwejum mina bakuju wakentin yununkata, dutikam dekas ame segatam nunak umiktatjai tusam tujutta. ¡Wait aneasam wi jakamtaig Egipto nugka juwigkik ukugsaipa! ");
INSERT INTO agr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Wi mina apag wegantu jinawajua núnikan jakamtaish, wi wegantu ukumasbau aina nuwig ukugsata”, tiuwai. Tusa tama, José ayaak: “¡Apawah, ame tame nunak dutiksanuk umiktajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Tama Jacob uchijin chichajak: “¡Dekas nunak umiktatjai! tusam yamaya juwik tujutta”, tiuwai. Tusa tama José ayaak: “¡Nunak dekas umiktatjai!” tiuwai. Tusa timatai Israel niina pegakji chaiken tsuntsuma tepes, Josén see tusa Apajuín emematiuwai. ");
INSERT INTO agr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nuna ti ukuki dukap tsawan pujatsaig, Josén tajuawag amina apak jamae tusag ujakajui. Tusa ujakam José weak niina uchiji Manasésan Efraígjai juki weuwai. ");
INSERT INTO agr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Nunik jegamtai uchijum José amina waipaktatus tae tusa Jacopan ujakajui, tusa ujakam niina pegakjin tepau katsuntus nantaki ekemsauwai. ");
INSERT INTO agr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Nunik ekemas Josén chichajak: “Apajuí ashí senchigtina nunú Canaán nugkanum yaakat Luz tutai awa nuwi mina wantintujuk, pegkegnum yumigtak, ");
INSERT INTO agr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","aatus tujutiabi: ‘Antukta nijah, wi aminak kuashat uchin uyujtuktatjame, dutika ai ame wegantu aidauk kuashat kawegkag nugka muunnum yaaktamak batsamsagtinai. Tuja nuigtushkam ame wegantu aidaun juju nugkanak susatnaitjai. Nuadui ajumaish tuke ditanu atinai’. ");
INSERT INTO agr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Tuja, wi eke Egipto nugkanum taatsaig, amina uchijum Efraín Manasésjai akiinau aina duka mina uchig agtatui. Ditak mina shiig uchig Rubén Simeógjai aina nujai betek agtatui. ");
INSERT INTO agr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Untsu nuwi nagkama wi juwi taa pujai akiinau aina nunú amina uchigmik agtatui, tuja dushakam Efraígkan Manasésjai yachi asag, ditashkam wajiinak nugkajai betek jukiagtin ainawai. ");
INSERT INTO agr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","“Wi Padán-aram pujaun wakitkin wegai canaágnum yaakat Efratanum jegattak amina duku Raquelak jakauwai, nunikmatai nunú jintanmak yamai Belén tutaya nuwi ukusan ukukiuwaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Tusa Israel José uchiji aidaun wainak iniak: “¿Jusha ya ainawa?” tau. Tusa iniam, ");
INSERT INTO agr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","José ayaak: “Junak wi Egipto nugkanum pujai Apajuí uchin sujusua nunú ainawai” tau. Tusa tutai niina apaji chichajak: “Wait aneasam juwi minai itanta, dutikawamin wi pegkegnum yumigsatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Tuja Israelak múuntuch wajasu asa shiig wainmachu asamtai, José niina uchiji aidaun juki apajin ejentuntui, dutikam pagkuk kugkuasui. ");
INSERT INTO agr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Nuna dutika Israel Josén chichajak: “Wika aminak jutikanus wainkatja tusankesh anentaimjachuitjai. Tujash Apajuí juni tiu asamtai wainkajame, dutikan amina uchijum aidaunashkam wainkajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tusa timatai José niina uchiji aidaun juki emenaas awajak, niina apajin eme anentus tikishmatug tsuntsuma nijayin nugka antig pujusui. ");
INSERT INTO agr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Nunik nagkanak, mai uchijin achikui. Efraígkan untsugnum achiak, Manasésan menanum achikui, dutika niina apajin ejentuntui. Dutikamu asa Efraín Jacopa menajin juwatai untsu Manasés untsugnum juwakui. ");
INSERT INTO agr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tujash Israelak niina uweje untsuja duwi Efraígka buuken achikui. Untsu menajiya duwi Manasésa buuken achikui. Nunak nigka iwai aig, makichik anentaimtugbau au asamtai dutikauwai. ");
INSERT INTO agr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Nuna dutika Josén pegkegnum yumigkiak aatus tiuwai: “Mina apachug Abraham, Isaac Apajuín umijujaku aina nunú wi yama nagkamchakun akiinawaitag duwi nagkamas yamaikish tuke kuitamja nunú, ");
INSERT INTO agr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","tuja Apajuí ángel tumain nayaimpinmaya pegkegchau aidaunmash ashí agkanmitkajuauwa dushakam, ¡juju uchi aidaunak pegkegnum yumigsati! ¡Nuadui mina daajush, mina apachug aidau, Abraham, Isaakan daajish, ditá daajin atakea duwish tuke pachitai atinme! ¡Ditak kuashat uchigtin atinme, nuninak shiig kuashat yujaktinme!” ");
INSERT INTO agr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Tusa tutai José diikma Efraín ekeuwa nuna buuken untsujin achiaun wainak makchau diisui, nuniak apaji uweje untsuja nuna achijuk juki uchiji emkau Manasésa buuken achimtikatag tiuwai, ");
INSERT INTO agr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Dutikak: “¡Atsa apawah aikawaipa! ¡Juwai emkauwa duka, juna buuken uwejum untsugmea nuadui achikta!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tusa tamashkam apajig uchijinak antugtsuk chichajak: “¡Ehe, uchuchih nunak dekajai! ¡Niishkam kuashat yujaka nugka muunnum yaaktamak batsamsatnai! ¡Tujash, niina yachi ekeuwa nunú ima senchigtin atinai! ¡Nuadui nii wegantu aidauk shiig kuashat agtinai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Nuna tusa nunú tsawantaik Jacob ditan pegkegnum yumigkiak aatus tiuwai: “Tikich aidaush pegkeg yumigkia nuna jukitag tusag atumin pachipasag: “¡Apajuí Efraígkan Manasésjai yaigkua dutika iinash yaimpakti tiagtinai!” tau. Nuna aatus tusa Israel Manasésan buuken niina uweje untsuja duwi achimainun idayak Efraígka buuken achikui. ");
INSERT INTO agr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nuna dutika Israel Josén chichajak: “¡Antukta nijah, wika jakattajai; tujash Apajuí atumjaig pujuttawai! Nuniau asa atumi apachjumi nugkeenig awagtamkiagtinai. ");
INSERT INTO agr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Tuja aminak yatsum aina nuna nagkaesau pegkeg yumigkin amaajai: Wi amorreo aents aidau depetka jujukbau, nugka Siquem tutaya nuna amaajai, nunú jukitin ata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Nuna tusa ashimak niina uchiji aidaun untsuka ikaunman chichajak: “Juwi tantatajum, nunikagmin atakesh wajukatnuk ainagme nuna pachisan ujaktajime: ");
INSERT INTO agr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","¡Jacopan uchiji aidauwah, juwi tanta ijuntsajum atumin apa Israel tawa nunú antuktajum! ");
INSERT INTO agr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rubénkah, ametme mina uchig iwaimek, wi aminak nagkamchakun datsa asan akiauwaitjame, nuadui amek ajantusa diitai senchigtin wajasuitme. ");
INSERT INTO agr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tujash imankek achatnaitme, shiig emetja anentaimchau, yumi tsukati waketama nujai betek asam, tuja mina eme anenjusa diigchau asam, mina duwagjaish ikagmakuitam nuadui. ");
INSERT INTO agr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeógkak niina yachi Levíjai betek ajankachu ishamain ainawai. ");
INSERT INTO agr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","¡Ajumaish wika atumjai ijunja pujutnak dakitajai! wagki atumi kajetinig aents aidau maakjum, kuntinu kagkajish kupijajum uku yujau aidau asagmin. ");
INSERT INTO agr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","¡Atumek pegkegchau, dekas shiig pegkegchau! Atumi kajetjumik kuntin ikamia kajena ibauwai. ¡Nuadui wi atumnak ashí Israel nugkanum dapampaaktinaitjime! ");
INSERT INTO agr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Untsu Judá aminak, yatsum aidauk pempeentugmakiag emematjamtin ainawai. Nuadui yatsumin waitkaidaush ame depetkam ayamjuktinaitme, tuja amina yatsum aidau emematjamainak tikishmatjamiagtinai. ");
INSERT INTO agr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","¡Judá, mina uchijuh! Amek leónka uchijijai betekaitme. León nejen yuwa ejemag wajas tsuntsuma ayamak múuntsukaitai tumain nugka tepegama numamtuk atinaitme. ¿Yaki aminash imanminash waitkagmasti? ");
INSERT INTO agr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Makichkish Judá senchijinak atankichagtinai, tuja nii apu wee inabaujinashkam. Untsu niina nagkaesau dekas apu taamtai, nuna ashí aents aidau niina chichamen umijuinak wedau asagmatai ukuktinaitme. ");
INSERT INTO agr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Niina burrojinash uva numijin tuja uva daekjinig jigkatnai, dutikak niina jáanchjinash ¡vino uva yumiji najanamua duwik nijatnai! ");
INSERT INTO agr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Niina jiig uva yumiji vino bukuseaya aan nagkaemas bukuseayai; tuja niina naíshkam leche pujua aan nagkaemas pujui. ");
INSERT INTO agr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sabulógkak nayantsanum uwet dekas lancha múun aidau anumtaiji aidaunum pujustinai. Tuja niina nugke nagkatkamuk Sidón nugka aatus atinai. ");
INSERT INTO agr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isacarak burro senchigtin kijinun yanau, niina wenuken waya tepesa dakimakug inanmainchawama numamtinai. ");
INSERT INTO agr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Niig nugka pegkeg ayamainjin wainak nuna tsuntsumtitnai niina tuntupen kijinun patai jukitatus, nuniak chichamjumatsuk tikima wainka tikichi inatai atinai. ");
INSERT INTO agr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dagkak Israel wegantu aidaujai betek nii wegantu aidaun apuji atinai. ");
INSERT INTO agr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dagkak dapi jintá dakamak tepes caballo minittaman sagkannum esai ajiyama iman atinai. ");
INSERT INTO agr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“¡Chah Tuke Pujuuwah, uwemtijugti tusan amina dakajame! ");
INSERT INTO agr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gaadnak shiwag aidau jetetnai, tujash nii wajantak depetuk ipistinai. ");
INSERT INTO agr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asera nugkeg shiig pegkeg asamtai, yutai aidauk pegkeg shiig kuashat ajitnai, iman asamtai nuwiyan apunashkam tuké sutinai. ");
INSERT INTO agr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Neftalík japa agkan wekagas uchijin shiig pegkejuch aidaun petsama numamtinai. ");
INSERT INTO agr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Josék numi namaka uwet wajas shiig kagkapena kanawe múun waig senchi nejegama imanai. ");
INSERT INTO agr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Nagki akenin aidau kajejuinawai, nuniak nagki aketuinawai, dutikainak tuké waitkainawai. ");
INSERT INTO agr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tujash José kuntujig senchi wajaknai, iman asa tuke depetmawai. ¡See kuashat Jacopa Apajuíji senchigtinuh! ¡Apajuí Israelan kuitamna nuna daajin see kuashat! ");
INSERT INTO agr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","¡See kuashat, Apajuí amina apa Apajuíjiya nunú yaimpakti; Apajuí dekas ashí senchigtina nunú aminak pegkegnum yumigtamsatin ati! ¡Nayaimpinmaya pegkeg jutai aina nuwiyanash! ¡Nayantsa initkenia pegkeg jutai aina nuwiyanash! Tuja ¡uchi akia shiig tsakapaktinnashkam, dutiksag yaimpakti! ");
INSERT INTO agr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mina apag pegkegnum yumigtujua nuna nagkaesan wika aminak pegkegnum yumigkiajame. Wi yumigkiajam juka, nugka nain aidau tuke megkaekashtina iman atinai. Juju pegkeg yumigkia juka Josénu atinai, wagki niyai yachi aina nuwiyan Apajuí etegkamua duka. ");
INSERT INTO agr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“¡Benjamígkak lobo kajen yukagtin kashikmas neje yuwa ajum agkuantai ampinjaun tinamkagtina imanai!” ");
INSERT INTO agr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Juju doce aina juwai Israela uchiji aidau. Juna aatus ditá apaji maki makichik yumigjauwai. ");
INSERT INTO agr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Makichik tsawantai Jacob niina uchiji aidaun juna aatus tiuwai: “Wi jakatnuk namput wajaschae. Wi jakamtaig mina apag ukusbau aina nuwi waa umikbau Efrógnum hitita aentsu nugken awa nuwi ukugsatajum. ");
INSERT INTO agr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Canaán nugkanum waa Macpelá Mamrejai niinis awa nuna mina apachug Abraham ashí Efrógka nugken sumak, juka mina pataaju ukumatai ati tiuwa nuwi ukugsatajum. ");
INSERT INTO agr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nuwi ukusajui Abrahaman niina nuwe Sarajai, nuigtushkam nuwig ukusajui mina apag Isaakan niina nuwe Rebecajai, tuja wishakam nuwig Lean ukusuitjai. ");
INSERT INTO agr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nunú nugka duka, ashí waa aidaujai hitita aentsu nugke aajaku sumakbauwai.” ");
INSERT INTO agr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Juna aatus Jacob niina uchiji aidau umikagtinun ujaka ashimak, pegajin ataktu tepesui, nunik nuwig jakauwai. ");
INSERT INTO agr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Nunik niina apaji jakamtai, José niina apajin pagkuk buutak kugkuasui. ");
INSERT INTO agr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Nuna dutika ampijatin aidaun José chichajak: Ampi iyash kaushtaiyai ukatjajum umiktajum wamak kaujai, tiuwai. Tusa timatai imatiksag José apaji Israela iyashin ukatuk umikajui. ");
INSERT INTO agr_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Dutika uka ukatuinakua cuarenta tsawan ejeyajui, nunú dutikakuik tuke imaan tsawan umitai asamtai. Tuja egiptunmaya aents aidaushkam Israel jakamtai, setenta tsawantai buutiaju ainawai. ");
INSERT INTO agr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Nunú buutbaun mijaakag, José faraógka inake aidaun chichajak: “Atumesh minash dekaskenum wait anenjakjumek faraón jegajuajum ujatjuktajum: ");
INSERT INTO agr_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Mina apag jakattak tepesa chichagtak: Juju makichkish ewaetsuk wi jakamtaig, Canaán nugkanum wi ukumastinjun waan tainiuwaitag nuwi ukugsatajum tujutiuwa nuna imatiksanuk umiktag tajai. Wait aneasam tsawan sujusta wisha nuwi wenu mina apajun ukusan ukuakun taatjai’, tujamui tusa ujaktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Tuja nuna faraón dekaa ditan ayaak: “Dekas tawai, niina apaji wajintiuwaita nunak dutiksag ukusa ukuak taati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tusa tima José weuwai apajin ukustatus. Nunik wetai faraógka atuwe chicham antugtai egiptunmaya aidauk ashí uyuniajui. ");
INSERT INTO agr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Nuniagtai José jenia aidauk ashí, tuja niina apaji jenia aidaushkam niina yachi aidaujai betekmasag shiyakajui. Nunik ashí shimak Goségnumak ima uchi aidaunak ditá tagkuji aidaujai ukukiajui. ");
INSERT INTO agr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Nuigtushkam tikich aents aidaushkam carretanum, caballonum aatus José wetai uyunainak pataetukajui. Imanidau asag shiig kuashat aentsuk aajakui. ");
INSERT INTO agr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Nunik shiyakag, namak Jordágka yantamen etsa minitaiya nuni nugka Goren-ha-atad awa nuwi jegawajui. Nuwi jegawag shiig kuashat tuwakag buutuidau, imadiagtai Joséshkam apaji jakamunum wake besemag dekapeak siete tsawan pujusui. ");
INSERT INTO agr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Nunú imatuidaun canaágnumia aents nuwi batsamin aidau wainkag chichainak: “¡Aunak egiptunmaya aents aidau jakaun ukuinak imatuinawai!” tuidau. Nuadui nunú nugka Jordágka yantamen etsa minitaiya nuni awa nunak Abel-mizraim adaikajui. ");
INSERT INTO agr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jacopa uchiji aidauk niina apaji tibaunak imatiksag umijuinak, ");
INSERT INTO agr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Canaán nugkanum ejegawag Macpelánum Efrón hitita aents aajakua nudau waa taimun Abraham sumak juka iina ukumataiji ati tibau aajakua nuwi ukusajui. Nunú nugkak waa taimu aajakua nujai mai, Mamre nugkanum etsa minitaiya nuni awai. ");
INSERT INTO agr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Dutika ukusa ukuak Josék niina yachi aidaujai, nuigtu tikich aents niina uyuniaju aidaujai ashí betek Egipto nugkanum waketjajui. ");
INSERT INTO agr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nunik Jacob jakamtai José yachi aidau diták anentaimas chichainak: “Namputchawame José kajegtamtsuash, nuniakug ii pegkegchau awajkauwaitag duwi nuna umiak iina iiktamainai”, tusag ");
INSERT INTO agr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","aentsun akateg akuptuinak: “Amina apa eke jatsuk tepesa José ujaktajum tusa, ");
INSERT INTO agr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","juna aatus iina akaatamak: ‘¡Wi amina segajame, wait aneasam amina yatsum waitkagmasu aina nuna tudauji tsagkujata! tajame’ tujamayi. Aatus iina apaji tujabiu asamtai, iishkam ataktu pataka sumaku: Iina pegkegchauji tsagkugtamjati taji, wagki iik amina apa Apajuíjiya nuna inake aidau asaja”, tiajui. Tusa akatja ishiakam, chichama etsejin aidau jegajua ujakajui dutikam José nuna antuk buutiuwai. ");
INSERT INTO agr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Nuniai niina yachi aidaushkam kautuawag, niina emtin tikishmag nugkan nijayin antig pujusag chichajuinak: “¡Juwi pujaji, yamaik iik amina inakem ainaji!” tuidau. ");
INSERT INTO agr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tujash José ditan ayaak: “Ishamkagtukaigpajum, wika Apajuíchuitjai atumin suwimkan amastinnuk. ");
INSERT INTO agr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Atumek pegkegchau awajkami tujutiuwaitjume, tujash Apajuí nunú pegkegchauwa nunak pegkegnum yapajiauwai, yamai wainag juna jutikatin asamtai, tuja aents aidau pujutjin uwemtikati tujutu asa. ");
INSERT INTO agr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Nuadui ishamkagtukaigpajum. Wi atum yuwatnunak uchijum aidau yuwatnujai amastatjime”, tiuwai. Aatus tusa anentain ichichtukui, dutikak shiig anentus ausauwai. ");
INSERT INTO agr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josék niina apaji patayi aidaujai betek ijunas Egipto nugkanum pujusui. José pujusui ciento diez mijan, ");
INSERT INTO agr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","imaan mijan pujau asa Efraín akiamua nuna uchiji akiinaunash, ama tijajinashkam wainkauwai. Manasésa uchiji Maquir aajakua nuna uchijinashkam nii yajuak tsakapakui. ");
INSERT INTO agr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Makichik tsawantai José niina yachi aidaun chichajak: “Wi jakatnuk namput wajaschae, tujash Apajuí atumnak tuke yaimpakagtatui. Dutijamak juju nugka juwi batsatjum nunashkam nigki jiigmaki Abrahaman, Isaakan, Jacopan aatus nugkan amastinaitjime tusa anagkuawa nuwi ejetamawagtin atinme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Nuna tusa José Israela uchiji aidau umikagtinun chichajak: “Dekas tajime, atumnak Apajuí yaimpakagtinai. Dutijamainakuig mina ukunchjush juwi ukugtutsuk jukitin atajum”, tusa yachi aidaun akatjauwai. ");
INSERT INTO agr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Tuja Josék ciento diez mijanji ajamu Egipto nugkanum pujus jakauwai. Nunikmatai iyashi wamak kaujai tusa kugkuinai ukatuk, aents jakau egketainum egkeawag ukusajui.");
INSERT INTO agr_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Israel, tikich daaji Jacob aajakua nuna uchiji aidau maki makichik ashí ditá uchijijai Egipto nugkanum utsanawaju aina nuna daajig juju ainawai: ");
INSERT INTO agr_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, Simeón, Leví, Judá, ");
INSERT INTO agr_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Sabulón, Benjamín, ");
INSERT INTO agr_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftalí, Gad, Asher aatus. ");
INSERT INTO agr_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jacopan uchiji wegantu aidau ashí ijumjamak setenta aents aajakui. Tuja niina uchiji Josék Egipto nugkanum pujujakui. ");
INSERT INTO agr_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Josék niina yachi aidaujai, tikich aents aidau nunú tsawantin batsamajaku aina nujai nuwi batsamas ashí jinawaju ainawai. ");
INSERT INTO agr_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Nunikagmataish dita uchiji aidauk kuashat akiinak wedau asag, shiig kuashat yujakajui. Imaanidau asag ditash senchigtin wajasag nugka dita batsatbaunmak piyakajui. ");
INSERT INTO agr_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Imanikaju ai kuashat mijan asa Egipto nugka apuji yamajam, José niina patayi aidaun ayamjak dutikauwa nuna makichkish dekachu ekemiuwai. Nunú egiptunmaya aidaun chichajak: ");
INSERT INTO agr_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“Israela uchiji aidauk iina nagkaetamsau yujakaje, tuja ditak iina nagkaetamsau senchigtin ainawai. ");
INSERT INTO agr_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Nuadui, aan kuashat yujakainum tusaish utugmainaita nunú chicham umikagmi. Wagki namputchawame maaniamukesh ataik iina shiwaajijai atuekag jutiin pempeentugmakiag depetamak, juwi batsata nuna jiinag shiyakainum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nuna tusa Israel aents aidaun takat katsugmanum takamtikainak waitkasagtinun, apu aidaun adaitujajui. Dutikamu asag, faraón yutai aidaun ijumajakua nuna jimag yaaktan, Pitón, Ramsés aatus najanawajui. ");
INSERT INTO agr_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Tujash Israel aents aidauk imatika waitkainamash nuni senchi yujak wedau. Imaaniagtai egiptunmaya aidauk senchi ishamainak kajejuinau. ");
INSERT INTO agr_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Nuninak, Israel aents aidaunak ditá inake emakag shiig senchi inainak waitkajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Imatikainak takat katsugmanum nugka namukag ladrillon najankatnume tusag batsasajui, dutikainak ajanmash imatiksag takamtikainak tikima shiig senchi waitkaidau. ");
INSERT INTO agr_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Nuigtushkam hebreo nuwa aidaun uchigmitkau, Sifrá, Fúa aajakua nujai, faraón tutai chichajak: ");
INSERT INTO agr_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“¡Atum hebreo nuwa aidau uchigmitkakjum diistajum wajukuk akiinat! ¡Tuja aishmag akiinkuig maatajum, untsu nuwaitkuig idaisatajum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Tujash uchí uchigmitkau aidauk Apajuín ishamaidau asag, faraón tutai tibaunak umikchajui. Nuadui aishmag akiintaish mautsuk idayinau. ");
INSERT INTO agr_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Nuniagtai Egipto nugka apuji ditan chichajak: “¿Wagka uchi aishmag akiinush mautskesh idaijume?” tau. ");
INSERT INTO agr_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Tama dita aínak: “¡Hebrea nuwa aidauk egiptunmaya nuwajaig betekchau ainawai, ditak senchigtin aina ibau asag, eke ii jegatsjinig diták uchigmainawai!” tuidau. ");
INSERT INTO agr_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Dutika idaibau asag, Israel aidauk kuashat akiinak wedau. Imaanidau asag aan nagkaemas senchigtin wedau. Tuja uchigmitkagtin aidauk Apajuín ishamainak uchin maachaju asagmatai, Apajuí ditanashkam kuashat uchigtin atinme tusa yaigkui. ");
INSERT INTO agr_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Imanik Israel aents aidau kawedau asagmatai, Egipto nugka apuji ashí niina aentsji aidaun chichajak: “¡Yamai nagkamsagmek hebreo aents aidaun uchiji aishmag akiinuk ashí namaka utsaitajum, untsu nuwa akiinkuig idaisatajum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Makichik aents Leví wegantunmaya, tuja nuwashkam nunú wegantunmayajaig nuwenauwai. ");
INSERT INTO agr_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Tuja uchi aishmag aidauk mantamnati tusa apu umiku ai, nuna nuwe nunú tsawantin ejapjuk uchi aishmagkun uchigmakui. Nunik uchigmak, uchi pegkejuch asamtai, dukuji uuka kampatum nantu apusauwai. ");
INSERT INTO agr_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Tujash dukap tsawan uuka pujumainchau dekapeak, chagkin kajis kanumá najanamun juki, yumi wayawai tusa pegkagag, nuwi uchin egkea dukuka namak Nilo tutainum ajug ukukiuwai. ");
INSERT INTO agr_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nuna dutika, uchish wajukatig ikaa wajasa diyaku ata tusa, niina nawanjin akupkauwai. ");
INSERT INTO agr_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Dutikau ai faraógka nawanji maitatus namaka akaikiuwai. Tuja nuwa niina inake aidauk namaka uwet yujai nii maak pujau tugkitak kajis tsapaku ayaunum chagkin kajis najanamu nanatun wainkauwai. Dutika wainak, niina inaken makichik awemauwai utita tusa. ");
INSERT INTO agr_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Tusa tima weji juki itanmatai, ujaka diikma uchi buutu egketun wainak wait anenmain diisui. Nunik chichaak: “Juka hebreo uchi”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Nuna dutiktai uchí umayi apu nawanjin jegantun chichajak: “Amesh wakegakminig, hebrea nuwa yamá uchí uchigmaku puja nuna wi ujaktajai, nunú nii amuntsuak kuitamkati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Tama nii ayaak: “¡Ayu, untsu weme nunú nuwa ujakta!” tiuwai. Tusa tima nuwauchik nunú uchí dukuji pujamunum weuwai. ");
INSERT INTO agr_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Nunik ujak itanmatai, faraógka nawanji nunú nuwan chichajak: “¡Juju uchi amina jemin jukim tsakapatjugta, wi amina uchi kuitabaunum akiktajame!” tiuwai. Tusa tima uchinak niina dukujig juki kuitamak muumpitkajui. ");
INSERT INTO agr_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Nunik muumpagmatai apu nawanjin susauwai. Dutikam juki nii uchijima niina daajin Moisés adaikauwai. Nunak: “wi yuminmayan jiikmaijai” taku tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Moisés tsakaja múun wajas pujau, makichik tsawantai nii wegantunmayan niina yachi aidaun ijagsatatus weuwai. Nunik jegakma takat shiig senchi katsugman takainak batsatun wainkauwai. Nunik diistakama egiptunmaya aents niina yachi hebreo aentsun suwimtatman wainkauwai. ");
INSERT INTO agr_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Dutika wainak ashí ayampa niimas, makichik aentskesh atsutai, egiptunmaya aentsun maa kayamnum yutua, ukukiuwai. ");
INSERT INTO agr_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Nuna dutika kashinia duwi ataktushkam weuwai, nunik jegakma jimag aents mai Israel aentsuk pempeentunikiag maanidaun wainkauwai. Nunik wainak senchi suwimkagtaun chichajak: “¿Wagka ame wegantukesh pempeentukmesh suwime?” tau. ");
INSERT INTO agr_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Tama nii ayaak: “¿Ya aminash apu chichama epegkin ati tusash adaitamkash iniish apujtamsame? ¿Egiptunmaya aents maamum dutika minash mantuatag tusamek tujutam?” tau. Tama Moisés nuna antuk senchi ishamkauwai, nunik anentaimas, dekas egiptunmaya aentsun wi maamag nunak dekawajeapi, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Tusa nii anentaimsamunak imatiksag faraón dekauwai. Nunik Moisés egakjum maatajum tusa inamjauwai. Tujash Moisésak tupikaki Madián nugkanum pujustatus weuwai. Nunik jegaa yumigmatnum ayaumas ekemsauwai. ");
INSERT INTO agr_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Nunik eketai Reuel, tikich daaji Jetro sacerdote Madiágnumia aajakua nuna nawanji siete aajaku aina nunú, ditashkam nunú tsawantin kuntin amutai aidaunum yumi shikik aimkag ditá apaji uwigji aidaun aajagtatus yumigmatnum shiyakajui. ");
INSERT INTO agr_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Nunik jegawag batsatun tikich uwija kuitamin aidau ujumak yumigmatnum kaunawag, nuwauch aidaun shiyaktajum tusa ishimiagtai, Moisés nuwi eketu asa wajatki ayamjuk yumi shikika aimak uwig aidaun aakui. ");
INSERT INTO agr_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Dutikamtai nuwauch aidau wamak waketug apaji pujamunum kaunamtai, apaji iniak: “¿Wagka yamaish imanikjumesh wamkesh waketjaugme?” tau. ");
INSERT INTO agr_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Tama dita ainak: “Uwija kuitamin aidau yumigmatnum kaunawag shiyaktajum tusa ajapjamiagtai, egiptunmaya aents nuwi eketu ayamjutpak yumin shikika uwig aidaunashkam aakmae”, tuidau. ");
INSERT INTO agr_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Tusa tiagtai Reuel niina nawanji aidaun chichajak: “¿Tuwi dusha aentsush pujume? ¿Wagka nigkish ukukmaugme? ¡Wejum ujaktajum, taa yujumkan yuwati!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Tusa timatai wejiag ujakajui, dutika ujakam jegaa taamtai, yujumak yuwamunum Jetro niina chichajak: “Juwi pujusta jutijai”, tiuwai. Tusa tama Moisés ayu tusa pujusui. Nunik pujaun Jetro niina nawanji Séforajai nuweauwai. ");
INSERT INTO agr_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nunik nuwena pujus niina nuwe Séforan ejapmitkakui, dutikam uchi aishmagkun uchigmakui, nunikmatai Moisés nunú uchi daajin Guersón adaikauwai. Nunak: “Wika juwiyachuitjai tikich nugkanmayayaitjai”, taku tuu adaikauwai. ");
INSERT INTO agr_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Tuja kuashat tsawan nagkaemai faraón jakauwai. Nunik jakamtaishkam Israel aents aidauk imanisag senchi waitu batsatu. Imaanik waituidau asa, yaki ayamjutpak agkanmitkagmawa wajaidau. Nuna tusa imatuidaun Apajuí antukui. ");
INSERT INTO agr_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nunik Abrahamjai, Isaakjai, Jacobjai, nii chichaman umikua nuna adeajui. ");
INSERT INTO agr_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nunik Israel aents aidau senchi waituinamun diijus wait anenjauwai. ");
INSERT INTO agr_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moisésak niina wegaji sacerdote Madián nugkanmaya Jetro aajakua nuna uwigjin kuitamjin aajakui. Tuja makichik tsawantai Moisés uwijan yajuak uwegshun nagkaiki weuwai, nunik muja Horeb Apajuí mujaji tutainum wakauwai. ");
INSERT INTO agr_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Nuwi Apajuí ángela nunin wajas numi piipich zarza kegamunum nuna ejapeen wantintukui. Nuna Moisés shiig diikma numi piipich kegayatak esaka amuechaun wainkauwai. ");
INSERT INTO agr_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Nunik anentaimas: “¿Aush wajig aniawa? ¡Numi piipich kegayatak esaka amuetsu dusha wagkag aniawa, wejin diistajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Tusa nuna diistatus jegantattak wegaun Tuke Pujuu wainak, numi piipich kegamunmaya untsuak: “¡Moisés! ¡Moisés!” tama, nii ayaak: “Juwi pujajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Tutai, Apajuí chichajak: “Imajuig tantaipa. Sapatjum ukuimakta, wagki ame wajam aanka dekas nugka Apajuí etegkamu pegkegmai”, ");
INSERT INTO agr_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","tusa nuigtushkam chichajak: “Witjai Apajuínuk, amina apachjum Abraham, Isaac, Jacob aidau emematujaku aina nunuwaitjai”, tiuwai. Tutai nuna antuk Moisés ishamak Apajuín diimainchau dekapeak, yapin dukukui. ");
INSERT INTO agr_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Tujash Tuke Pujuu ataktu chichajak: “Wika mina aentsug aidau Egipto nugkanum batsamas senchi waituina nunak shiig wainjai. Tuja takata apuji aidau takat katsugmanum takamtikainam waituinak pampaina nunashkam antukjai. Tuja dita waituina nunashkam shiig dekajai. ");
INSERT INTO agr_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Nuadui egiptunmaya aents aidau waitkaina nuna uwemtikatasan juwi taajai. Wi ditanak jiija yajuakan nugka múun pegkeg ajak shiig tsapau, tagkush shiig muumpau, yumi aidaush ayaunum ejegawagtatjai. Nunú nugka duka Canaán aents, hitita aents, amorreo aents, ferezeo aents, heveo aents, Jebús aents aidaun batsamtai ainawai. ");
INSERT INTO agr_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Antukta nijah: Wika mina aentsug Israel ame wegantu aidau senchi waituinak pampaina nunak shiig antukjai, tuja egiptunmaya aents aidau shiig senchi waitkaina nunashkam wainjai. ");
INSERT INTO agr_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Nuadui umintsata, wi aminak Egipto apuji pujamunum jegaam, mina aentsug ame wegantu aidau batsata nunú jiigminum tusan akupeajame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Tusa tama Moisés Apajuín ayaak: “¿Wisha wainkauchitag juninnush Egipto apuji pujamunum jeganush, Israel aents wi wegantu aidau nuwi batsata nunash jiimainkaitag?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Tutai Apajuí ayaak: “Wi aminak uyuuntsattagme. Mina aentsug ame wegantu aidau Egipto nugkanum batsata nunú jiija yajuakam, ashí atum aidautijum juju muja juwi emematjitnaitjume. Nunú betek uminkui dekattame wi amina awemajam nunú”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Tutai Moisés Apajuín ayaak: “Tujash wi jegaan ditá chichagkun: ‘Atumin apachjum Abraham, Isaac, Jacob Apajuín emematujaku aina nunú atumin agkanmitkati tusa awetime’ tai dita mina aijuinak: ‘¿Dusha yaita daajish?’ tusa tujutainakuish, wisha ditanash ¿wajintu aikagtatja?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Tutai Apajuí ayaak: “Mina daajuk: ‘Tuke Pujuuwai’ Juju mina aentsug aidau ujaakum: ‘Tuke Pujuu’ minak atuminig awetime, titatme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Tuja nuigtushkam Apajuí Moisésan chichajak: “Juju aatsa mina aentsug aidau ujakta. Wika Apajuí, Tuke Pujuun atumi apachjum Abraham, Isaac, Jacob emematujaku aina nunuwaitjai. Jujuwai mina daag yaunchkesh tuke asauwa nunú. Jujuwai mina daajun ajumaish tuke adaititin aina duka. ");
INSERT INTO agr_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Nuadui wetá nunika jegaam Israel aentsu apuji múun aidau ijumja chichagkum: ‘Apajuí, Tuke Pujuu tutaya nuna, atumi apachjum Abraham, Isaac, Jacob emematujaku aina nunú mina wantintujuk chichagtak: Wika ditanak kajimatchau asan, egiptunmaya aents aidau waitkam batsata nunak wainjai. ");
INSERT INTO agr_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nuadui Egipto nugkanum waitkam batsata nunak ankanmitkattajai dutikan Canaán aents, hitita aents, amorreo aents, ferezeo aents, Jebús aents, heveo aents aina nuna nugke nugka pegkeg ajak shiig tsapau, tagkush shiig muumpau, yumishkam imanisag ayá nuwi yajuakan ejegattajai tujamui’, titatme. ");
INSERT INTO agr_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Tusa tamin Israel aentsu apuji múun aidau antugtamkagtatui. Nunikagmatai ditajai faraón jegajua chichagkum: ‘Tuke Pujuu, Apajuí hebreo aents aidau Apajuíji jutii aidauti emematin ainag nunú wantintugmakji. Nuniku asamtai idaikagtusta kampatum tsawan mujá shiyakaja, nuwi kuntin maa apeaku Tuke Pujuu iina Apajuíjiya nunú emematmi taji’ titatme. ");
INSERT INTO agr_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“Tusa taminish, faraógkak shiyaktajum tujamchatta nunak shiig dekajai. Tujash wi niinak waitkastatjai, shiyaktajum tujamti tusan. ");
INSERT INTO agr_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Dutikakun wi mina senchigjai egiptunmaya aents aidaun suwimka suwakun wainchatai ishamain aidaun iwainagtatjai. Nuadui faraón atumnak shiyaktinme tusa idaitamsagtatui. ");
INSERT INTO agr_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Nuigtushkam wi egiptunmaya aents aidaunak ditá wajiji aidaun anentag shiig anenjamas amastinme titatjai. Nuadui atumek jiinja shimakjumesh uwegmatak shimutsuk wajiigtin wajasjum shiyaktatjume. ");
INSERT INTO agr_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Tuja Israel nuwa aina duka maki makichik egiptunmaya nuwa pujamunum ijus pujuidauk, nuniachkush pachiinak pujaushkam jiju plata tutayai dakumka najanamu aidaun, orojai najanamu aidaun, jáanch nugkutai aidaun, aatus segagtatui. Dutikawag nuna ditá uchiji aidaun nawanji aidaujai anujagtatui. Dutika ditá wajiji ashí yajutkamu asag, egiptunmaya aidauk makichkish wajigtuchu juwakagtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Tutai Moisés ayaak: “Tujash minak dekaskeap tawa tujutchagtatui, nuninak wi taishkam antugtutsuk Tuke Pujuu wantintugmakchau aig, tuu wekaeme, tujutiagtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Tutai Tuke Pujuu niina chichajak: “¿Waji aancha takakme?” tama: “Ushujutaijun takakjai”, tau. ");
INSERT INTO agr_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Tutai: “¡Nugka aepsata!” tau. Tama nugká aepsauwai. Dutikamuik dapi najaneauwai, nunikmatai Moisés nuna ishamak tupikau. ");
INSERT INTO agr_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Nunitai Tuke Pujuu Moisésan chichajak: “Ujuknum achikta” tau. Tama Moisés achikui; dutikam ataktu ushujutai wajasui. Nunikmatai chichajak: ");
INSERT INTO agr_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“¡Amesh jutiksamek iwaintukta! Juna wainkag dekas iina muunji Abraham, Isaac, Jacob aajaku aina nuna Apajuíjimpap wantintuke tujamiagtatui”, tusa ");
INSERT INTO agr_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ataktu chichajak: “¡Jáanchjum inuam detsepem achikta!” Tama Moisés inua detsepen achikui. Nunik uwejen jiiki diikma jata lepra achikam shiig puju wajasun wainkauwai. ");
INSERT INTO agr_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Nunikmatai Apajuí chichajak: “Ataktushkam dutiksamek detsepem achikta.” Tama ataktushkam inua detsepen achikui, dutika uwejen jiiki diikma yaunchuk iyashi aajakbaunak imanuk pegkeg wajasui. ");
INSERT INTO agr_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Nunikmatai Tuke Pujuu chichajak: “Yama nagkamchaku iwainamugmin dekaskeapi tusa antugtamainashkush, yamai iwaintukjam juju iwaintamin dekaskeap tawa tusag antugtamkagtatui. ");
INSERT INTO agr_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Tujash juju mai iwaintamash dekaskeapi tusa antugtamainashkuig, namakia yumi shikika jukim nugká ukagta, dutikam yumi ukagbauwa nunú numpa wajastatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Tama Moisés Tuke Pujuun ayaak: “¡Chah, Tuke Pujuuwah! Wika shiig jintiaja chichamainchau dekapnujai, junak yaunchuk nagkamsan, yamai ame augtakminish nunisnuk chichajai”, tau. ");
INSERT INTO agr_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Tutai Tuke Pujuu ayaak: “¿Ya aentsu weninash najatuawaita? ¿Ya najanauwaita chichachu, antuchu, wainmachu, wainbau aidaunash? ¿Wichaukaitag Tuke Pujuu, nuna dutiknunuk? ");
INSERT INTO agr_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Nuadui wetá, wi aminak chichamtikattajame, wiki ame anentaimja chichaktinnash jintintuattagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Tama Moisés ataktu chichaak: “¡Chah, Tuke Pujuuwah, wait aneasam dekas tikich awemata!” tau. ");
INSERT INTO agr_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Tutai Tuke Pujuu Moisésan kajejuk chichajak: “¡Awi amina yatsum Aarón Leví wegantu shiig chichau puja nuna wi wainag jamah! Nuigtushkam nii amina igkumpaktatus minawai. Tuja amina waipak shiig aneas jujamkittawai. ");
INSERT INTO agr_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Dutijamamtai niijai chichasta, nuniakum wi amina tajam nunú ashí ujakta, dutikam ame tumaina nuna nii Israel aents aidaun ujakti. Tuja wi niinak yaigtatjai, dutikakun atum dutikatnunashkam jintintuattajime. ");
INSERT INTO agr_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ame Aarógkak wi tumainaitag aikasmek tita, tuja nii ame tumainaitam dutiksag aents aidaun ujakti. ");
INSERT INTO agr_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Tuja ¡anú ushujutaijum jukim wetá, núnikam aanjai kuashat wainchatai aidau iwainagtatme!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Tusa tima Moisés wakitki niina wegaji Jetro jeen jegauwai, nunik chichaak: “Wisha mina pataag Egipto nugkanum batsata nuwi wakitkitjai. Nunikan iwakuash batsata diistajai”, tau. Tutai niina wegaji Jetro ayaak: “¡Ayu, shiig kuitamamsam wetá!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Moisés eke Madián nugkanum pujuttaman Tuke Pujuu chichajak: “¡Egipto nugkanum wakitkita, amina mantamatatus egapagmaya duka ashí jinawaje!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tusa tima Moisés niina nuwen uchiji aidaujai burronum pekai, Egipto nugkanum wakitkiuwai. Nuniak ushujutaijin Tuke Pujuu, jujai wainchatai aidaush iwainagtatme, tibaun juki weuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Nunik wetatman Tuke Pujuu Moisésan chichajak: “¡Egipto nugkanum jegamek, Wi amina iwaintukjam duka faraógka emtinish imatiksamek mina senchiju amaag nujai iwaintukta! Wi niinak antakchau emattajai, dutikamu asa kakajus wetinme tujamchagtatui. ");
INSERT INTO agr_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Nuniakuish ame nii chichagkum: ‘Juna aatus Tuke Pujuu chichaak: Israel aents aidauk mina uchig iwai amaina numamtinai. ");
INSERT INTO agr_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Nunin asamtai, agkan idaitugsata mina uchig aidau jiinjag emematjitnume timajame, tusa tamash dakitau asamin, wi amina uchijum iwaiya nuna mantuattajame’, tujamui tusam tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Tusa tima wee wenakua jintá kajittaman Tuke Pujuu Moisésan wantintuk maatag tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Nunitai Séfora kuchii kaya najanamun juki, uchiji katiuchiji chuchuken tsupigkauwai. Dutika nuna juki Moisésa nawen antigkui, dutika chichajak: “¡Amek mina uchiju numpen yamaikish mina aishjuitme!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Nuna aatus nuwe dutikamtai, Tuke Pujuushkam mautsuk weti tusa idaisauwai. Nunikmatai Séfora chichaak: Moisésak mina uchiju numpen yamaikish mina aishjui, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nuna nuniai Tuke Pujuu Aarógkan chichajak: “¡Uwegshunum weme Moisés igkugkam utita!” tiuwai. Tima niishkam weji “muja Tuke Pujuu etegkamu pegkejam” tutainum waka igkug kumpamak yapiin kugkuasui. ");
INSERT INTO agr_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Dutika igkugkam Tuke Pujuu titatme tibaunak imatiksag Moisés Aarógkan ashí ujakui. Tuja nunú dutikattame tusa Tuke Pujuu tibaunashkam imatiksag ujakui. ");
INSERT INTO agr_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Nuna dutika nuadui Moisés Aarógjai, Israel aentsu apuji múun aidau ijumjatatus wegajui. ");
INSERT INTO agr_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Dutika ijumag Tuke Pujuu Moisésan titatjume tibaunak Aarón imatiksag ashí ditan ujakui. Dutikamtai Moisés Tuke Pujuu senchijin wainchatai aidau iwainagta tibaunak imatiksag dita wainainamunum ashí iwainajui. ");
INSERT INTO agr_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Nuna wainkag Israel aents aidauk: Dekas Tuke Pujuuwap awemae tiajui. Tuja Israel aents aidau waituina nunak wainjai, tuja waitkam batsata nunashkam dekajai Tuke Pujuu timae tabaun antukag, tikishmag pujusag niina emematuidau. ");
INSERT INTO agr_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Nuna dutika ukuinak Moisés niina yachi Aarógjai faraógkan jegajuawag chichajuinak: “Israel aents aidauti emematin ainag nunú Apajuí, Tuke Pujuuwa nu chichaak: “ ‘Mina aentsug aina nunú idaitugsata, dutikam uwegshunum shiyakag, awi ijunag mina emematjuinak jiistamatnume’ tawai”, tuidau. ");
INSERT INTO agr_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Tutai faraón ayaak: “¿Yaita dusha Tuke Pujuush, wi niina chichamen antugkan, Israel aents aidaun shiyaktajum tusa idaisatnunash? ¡Wika Tuke Pujuunak wainchaujai, nuigtushkam Israel aents aidaunak shiyaktinme tusanuk idaisashtatjai!” tau. ");
INSERT INTO agr_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Tutai dita ainak: “Apajuí, Tuke Pujuu tutai, hebreo aents aidauti emematin ainag nunú wantintugmakji. Nuniku asamtai, uwegshunum kampatum tsawantai jegatainum wetatji. Nuwi jegaa kuntin maa apeaku Tuke Pujuu iina Apajuíji emematiagmi taji. Tuja nunú ii nunishtaik niina suwimke, jatakesh jutiin iyanjamainai, nuniachkush shiwagkesh maaniamunum amupamainai”, tuidau. ");
INSERT INTO agr_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Tama faraón ditan ayaak: “¿Wagka Moisésa amesh Aarógjaish aents aidau takaidaush nunú takugmesh tsawantash emegkagme? Nunú tuu yujatsuk wakitkijum takastajum”, tau. ");
INSERT INTO agr_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Tuja nuigtushkam faraón ditan chichajak: “Juju nugka juwi batsamas Israel aents aidau shiig kuashat yujakag takainak batsata nunidauk, takasaigpajum tusagmek tsawantak emegkaumaitsugme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Nuna tusa nunú tsawantaik faraón niina aentsji apu aidaun, nuigtu Israel aents aidau takata takagtai diistin adaijamu aidaujai ijumag chichajak: ");
INSERT INTO agr_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Yamai nagkamsagmek Israel aents aidauk ladrillon pachimag najanatnume tusagmek trigo numiji tsupigbauk susaigpajum, diták wejiag yajuaktinme. ");
INSERT INTO agr_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Tujash yaunchuk najanin agma imatiksag najanatnume tusajum inagtajum, machikish awagtukigpajum. Ditak daki asag mujá shiyakaja kuntin maa apeaku Tuke Pujuu emematmi tusag imatuinawai. ");
INSERT INTO agr_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Nuadui yamaik nuni senchi takamtiksatajum. Imaatikamu asag wait chicham antumainji tsawan atsugtinme”, tau. ");
INSERT INTO agr_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Tusa tiajam faraógka aentsji apu aidau, Israel aents aidau takata takagtai diistin adaijamu aidaujai jiinag Israel aents aidaun ujainak: “Faraón chichaak: ‘¡Yamai nagkamsagmek trigo tsupigbauk susaigpajum tujabiu asamtai, yamaik amaschattaji! ");
INSERT INTO agr_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Atum tuwiya jumainaitjume nunú atumek wejijum jukitajum. ¡Tujash nuniakjumesh najannujum duka imatiksagmek najanattagme!’ tujamui”, tuidau. ");
INSERT INTO agr_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Tusa tiajam Israel aents aidauk trigo tsupigmaujai pachimja ladrillo najanmain atsau asamtai, trigo tsupija yajumku ampigbau aidaun yajuakag nujai ladrillon najanatag tuidau asag Egipto nugkanak ashí pampankag egaidau. ");
INSERT INTO agr_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Tuja kashi kashinig Egipto apuji niina aentsji apu aidau Israel aents aidau takata takagtai diistin adaijamu aidaun chichajuinak: “¡Yaunchuk trigo tsupija suwamu asajum makichik tsawantaik wajupa najanmaijume duka imatiksagmek najanatajum!” tusag imatjuidau. ");
INSERT INTO agr_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Tuidau asag faraón niina aentsji apu adaijamu aidau Israel aents takata takagtai diistin adaijamu aidaun asutidau. Dutikainak: “Yaunchuk najanmaijum imatiksagmekek yaug najanachmaugme, tuja yamaishkam nunisjumek umiatsjum dusha ¿wagka aniagme?” tuidau. ");
INSERT INTO agr_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Imatikainam Israel aents takata takagtai diistinme tusa adaijamu aidau, faraógkan jegajuawag chichajuinak: “¿Wagka amina inakem ainajinish imatikagmesh waitkagkagtame? ");
INSERT INTO agr_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Nuigtushkam trigo tsupigbaunash amina aentsjum aidauk amina inakem aidautinak sukagtuinatsui, nuninayatak: ‘¡Wamak ladrillo najanatajum!’ tusa jiyajatuinawai. Nuigtushkam asutkagtuinawai. Ii wamak umiatsug duka amina aentsjum aina nuna utugchatjiyai”, tuidau. ");
INSERT INTO agr_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Tusa tiagtai nii ayaak: “Atumek daki ainagme, nunin asajum idaikagtustajum imau wee kuntin maa apeaku Tuke Pujuu emematiagmi tuu yujagme. ");
INSERT INTO agr_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Tutsuk takakjum shiyaktajum, trigo tsupigbaun amainashkuish, yaunchuk trigo suwamu asajum najanmaijum imatiksagmek ladrillok najantatjume”, tau. ");
INSERT INTO agr_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Tusa tiajam Israel aents aidau takata takaidaun diistinme tusa adaijamu aidau shiig utugchat diisajui. ");
INSERT INTO agr_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Nuna aatus faraógkan aujus jiinkama, Moisés Aarógjai agá dakamainak batsatun wainkajui. ");
INSERT INTO agr_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Nunik ditan chichajuinak: “Atumi utugchatjin ii waitiag duwi Tuke Pujuu atumnak suwimkan amastinme. Atumi tuu wekaetin faraón niina atueka takatai aidaujai shiig kajegtamkaje. Atumek tuke aneasjum egiptunmaya aidau wai waitkainakua ijinatnume tusajum jutikagtagme”, tuidau. ");
INSERT INTO agr_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Tusa tiagtai Moisés Tuke Pujuun aujak: “¿Apujuh, wagka juju amina aentsjum aidaush pegkegchaunmash waitkame? ¿Wagka minash awetibiume jutika waitkastinaitkumesh? ");
INSERT INTO agr_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Wi yama nagkamchakun amina daagmin pachisan faraógkajai chichasmayag duwi nagkamas yamaikish amina aentsjum aidaunak nuni senchi waitkainawai, ¡tujash amek amina aentsjum aidauk eke agkanmitkachume!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Tusa tama Tuke Pujuu Moisésan ayaak: “¡Yamai wi faraógkan itugkattaja nunú wainkattame! ¡Wi mina senchijun iwaintuktatjai, dutika ai nii dekas atumnak jiinjatajum tusa tujamiagtatui!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Tuja Tuke Pujuu Moisésan ataktu chichajak: “Witjai Tuke Pujuunuk. ");
INSERT INTO agr_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Wika Abrahaman, Isaakan, Jacopan wantintukuitag nuaduik: ‘Apajuí ashí senchigtinaitjai’ tuu iwainmamkauwaitjai. Tujash dekas mina daag ‘Tuke Pujuu’ tutaya nunak ujakchau ainajai. ");
INSERT INTO agr_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nuigtushkam ditajai chichama umiakun: ‘Nugka Canaágkan amastajime’ tiuwaitjai. Tujash ditak nuwig ijagka numamtin batsamsaju ainawai. ");
INSERT INTO agr_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Tuja Israel aents aidau Egipto nugkanum inaku waitkainam batsamas chichaina nuna yamai antukjai. Nunikan adeagjai ditá muunji aajaku aina nujai chichaman umikuitag nuna. ");
INSERT INTO agr_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Nuadui Israel aents aidau tita: ‘¡Witjai Tuke Pujuunuk! Nuniau asan egiptunmaya aents aidau waitkainam batsatjum nunak egiptunmaya aidaun suwimka suwakun jiigtatjime. Tuja takat katsugmanum takamtijamainakui waituinajum nunashkam dutiksanuk agkanmitkattajime. Wi mina senchigjai ayamjukan jiigtatjime. ");
INSERT INTO agr_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Dutikan mina aentsug atinme titatjai, tuja wika Tuke Pujuu atumi ememattai atatjai. Duwi dekajuawagtinai, iina Apajuíji Tuke Pujuu tutaya nunuwap egiptunmaya aents aidau inaku waitkatai batsatutin agkanmitkagbauwaita tusag. ");
INSERT INTO agr_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nuadui wi Abrahaman, Isaakan, Jacopan chichagkun: “Nugka amastajime” tusan dekas umiktinjun anagkuawaitag nuwi ejegattajime, dutikan nuna amastatjime atumdau tuke atina nuna. Wi Tuke Pujuu tutayaitag imanun nunak tajai’ tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Tusa tima Moisés dutiksag Israel aents aidaun ataktu ujakui. Tujash ditak antugkachaju ainawai, wagki Moisésa tuu wekaetin shiig senchi takamtijamainak waitkagmainawai tuidau asag. ");
INSERT INTO agr_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Dutika antugchagtai, Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“¡Wetá faraón pujamunum! núnikam Israel aents aidau Egipto batsata duka, idaisata jiinjati, tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Tama Moisés Tuke Pujuun ayaak: “Israel aents aidaukesh mina antugtuinatsu nunash ¿wajuk faraógkash antugtuktigki wi shiig jintiaja chichatsug nuniaish?” tau. ");
INSERT INTO agr_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Tutai Tuke Pujuu Moisésan Aarógjai akateak: “Israel aents aidau faraógjai chichagkujum: ‘¡Tuke Pujuu Israel aents aidaun jiigtinme!’ tujamae titajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Tuke Pujuu Moisésan Egipto nugkanum ausauwa nunak, ");
INSERT INTO agr_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","aatus tiuwai: “Witjai Tuke Pujuu tutai. Wi amina titatjam duka ashí imatiksamek faraón ujakta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Tusa tama Moisés Tuke Pujuun ayaak: “Tujash wi shiig jintiaja chichatsug nuniaish faraógkash ¿wajuk minash antugtuktigki?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Tutai Tuke Pujuu Moisésan chichajak: “Amek faraógka emtinig wijai betek atatme. Tuja amina yatsum Aarón ame chichamun etsegtugmaktatui. ");
INSERT INTO agr_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Wi titatjam nunú ame Aarón ashí ujakta; dutikam nii faraógkan chichajak: Israel aents aidau juwi batsata duka idaisata jiinjatnume tusa titatui. ");
INSERT INTO agr_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Tujash wi faraógnak antakchaujai betek emattajai, dutikakun mina senchigjai ashí Egipto nugkanmak kuashat wainchatai ishamain aidaun iwainagtatjai. ");
INSERT INTO agr_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Nuna wainkush faraógkak antugtamkachagtatui. Tujash wi mina senchigjai egiptunmaya aidaun suwimka suwakun, mina aentsug Israel aents aidau Egipto batsata nuna ayamjukan jiigtatjai. ");
INSERT INTO agr_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Dutikakun wi mina senchijun ashí Egipto nugkanum iwainakan Israel aents aidau batsata nuna jiitai, egiptunmaya aidauk, wi Apajuí Tuke Pujuu tutayaitag nuna dekajuawagtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Tusa tima Moisés Aarógjai Tuke Pujuu dutikatajum tibaunak imatiksag umikajui. ");
INSERT INTO agr_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Dita faraógjai chichasaju aina nunú tsawantaik, Moisésnak ochenta mijan ajujakui. Untsu Aarógnak ochenta y tres mijan ajujakui. ");
INSERT INTO agr_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Tuke Pujuu Moisésan, Aarógjai chichajak: ");
INSERT INTO agr_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Wainchatai iwainakta tusa faraón tujamkuig, amina ushujutaijum jukim Aarón susata, dutikawamin faraógkash wainai nugká aepsati, dutikam dapi najaneati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Tusa tima Moisés Aarógjai faraón pujamunum weajui. Nunikag Tuke Pujuu dutikatajum tibaunak imatiksag dutikawajui. Tuja faraón niina atueka takataiji aidaujai wainainamunum Aarón ushujutain juki nugká aepsauwai, dutikam dapi najaneauwai. ");
INSERT INTO agr_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Nunikmatai faraógshakam tunchi aidaun untsukui. Dutikam ditashkam dita dekamujijai dutiksag iwainakajui. ");
INSERT INTO agr_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Maki makichik ditá ushujutaijin nugká aepsajui, dutikam dushakam dapi najaneakui. Tujash Aarógka ushujutaiji dapi najaneauwa nunú ditanunak ashí yuwa amukui. ");
INSERT INTO agr_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Dutikamtaish faraógkak antakchau wajas ditanak antugkachajui, Tuke Pujuu nuniktatui tibaunak imanisag. ");
INSERT INTO agr_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Nunikmatai Tuke Pujuu Moisésan chichajak: “Faraógkak antakchau wajasu asa, Israel aents aidaunak shiyaktinme tusag idaitsui. ");
INSERT INTO agr_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Tujash kashin kashikmasam nii namaka weakui wejita, núnikam namaka uwet wajasam dakasta. Nuwi weakum ushujutaijum dapi najaneama nunú jukita. ");
INSERT INTO agr_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Nuwi wajamin taamtai chichagkum: “ ‘Hebreo aents aidauti Apajuí Tuke Pujuu tutai emematin ainag nunú amina ujakti tusa awetine. Nuniak aatus tujamui: “Mina aentsug aidau uwegshunum shiyakag mina emematjitnume agkan idaisata timagme. Tujash antugtatsme”, tujamui. ");
INSERT INTO agr_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Nuniau asamin juna aatus Tuke Pujuu chichaak: “ ‘ “Yamai dekaattame wi Apajuí Tuke Pujuuwaitag nunú”, tujamui. Nuadui wi ushujutain takakag juwi namakan awattatjai, dutika ai yumi numpa wajastatui. ");
INSERT INTO agr_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nunikmatai namak aidau jinaamtai yumi mejettawai, nunitai egiptunmaya aidauk nuna tsumainak yuminak uwagchagtatui’ tawai tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Nuna tusa ataktushkam Tuke Pujuu Moisésan chichajak: “Aarón ujakta ushujutaijin juki namak aidau, entsa aidau, kucha aidau, yumi shikika aimtai cisterna aidau Egipto nugkanum ayá nuni, tuja ashí yumi piyaju aidau ayá aatus takui awentati, dutikam yumi aidauk numpa wajasti. ¡Aatus ashí yumi shikitai numi najanamu, nuigtu kaya najanamu aidaunmashkam yumi piyag ayauk numpa waigtatui!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Tusa tima Moisés Aarógjai Tuke Pujuu dutikatajum tibaunak imatiksag dutikawajui. Tuja faraón niijai atueka takatai aidaujai wainainamunum Aarón nii ushujutaiyai yumin awatiuwai; dutikam ashí yumi aidauk numpa wajasui. ");
INSERT INTO agr_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Imanikmatai namak aidauk jinauwai, nuniku asa yumi shiig senchi mejeau asamtai, egiptunmaya aidauk yuminak umuinachu. Tuja Egipto nugkanum yumi ayauk ashí numpa wajasui. ");
INSERT INTO agr_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Tuja egiptunmaya tunchi aidaushkam dita dekamujijai yumin numpa awajsajui, nuna dutikawagmatai faraógkak nuni senchi antakchau wajasui. Nuniau asa Moisés Aarógjai tuinamunak antugchau, Tuke Pujuu nuniktatui tibaunak imanisag. ");
INSERT INTO agr_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Nuadui faraógkak puyatjusagkesh diitsuk ukuak nii pujusa inamtaijin wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Imanik namak numpa wajasu asamtai, ashí egiptunmaya aidauk yumi pegkeg piyagmatai uwagmi tusag namaka uwet yumigmatan taukajui. Wagki namakia yumik umumainchau asamtai. ");
INSERT INTO agr_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Tuke Pujuu namakan numpa emauwa nunú siete tsawan nagkaemakiu ai, ");
INSERT INTO agr_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Tuke Pujuu Moisésan chichajak: “Faraón pujamunum wetá, nunika chichagkum: “ ‘¡Mina aentsug aina nunú agkan idaitugsata, jiinag shiyakag mina emematjitnume! tujamui. ");
INSERT INTO agr_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Tusa ujamaitkum ame jiinjati tusa idaichakminig, wi suwimka amaakun ashí Egipto nugkanum takashun ishitkattagme, ");
INSERT INTO agr_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","dutika ai takash namakia jiinag ame pujusa inamtaigminig, kanutaigmin, pegakjuminish, amejai atueka takau aina nuna jenish, ashí amina aentsjum aina nuna jenishkam, tuja pag inagtaigminish, pag najanatasa namutainmash ashí utsaaniagtatui. ");
INSERT INTO agr_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Imaanidau asag amina tuja ame atueka takataijum aina nuna, nuigtu amina aentsjum aina nunashkam ashí takash pemjujag waitkasagtatui’ tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Nuna tusa Tuke Pujuu Moisésan ataktu chichajak: “Aarón ujakta ushujutaijin juki namakanini, entsa ayá nuni, kucha aidaunmanini awentati, dutikam nuwiya takash jiinag ashí Egipto nugkanak akijuati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Tusa tima Aarón egiptunmaya namak ayamunmanini awentau, dutikam takash jiinag ashí Egipto nugkanak pimutkau. ");
INSERT INTO agr_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Nunikmatai tunchi aidaushkam dutiksag dita dekamujijai takashun Egipto nugkanum ikaunmakajui. ");
INSERT INTO agr_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Imanikmatai, faraón Moisésan, Aarógjai untsuka itan chichajak: “Apajuí, Tuke Pujuu tutai, minash segatjitajum, takash mina, nuigtu mina aentsug aidaunash waitkagmaina nuna emegkagti. Dutikamtai wisha niina aentsji aidaunash kuntinu maa apeenak Tuke Pujuun ememattinme tusan idaitustajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Tusa tutai Moisés niina ayaak: “Amina, tuja amejai atuegak takau aina nuna, tuja amina aentsjum aina nujai takash aidau waitkagmaina nunú shiyakti, nunikag namaka utsaanatnume tusanush, wajutiya nunash segattatjame nunú ame tujutta”, tau. ");
INSERT INTO agr_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Tama nii ayaak: “Kashin dutikata”, tiuwai. Tutai Moisés ayaak: “Ame tame duka betek uminkattawai, nunikmatai amesh dekaata iina ememattai Apajuí, Tuke Pujuuwa, imanuk tikichik atsa nunú. ");
INSERT INTO agr_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Takash aidau amina waitkagmaina duka shiyaktatui, nunik namaka utsaanattawai. Nuadui aminak waitkagmaschattawai, tuja amejai atueka takataijum aidaunash, tuja amina aentsjum aidaunashkam ataktu awagkig waitkaschattawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Tusa Moisés Aarógjai faraógka aujus ukuinak jiinkiajui. Nunik Moisés Tuke Pujuun segauwai, takash faraón ishitkamua nuna awakeagti tusa. ");
INSERT INTO agr_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Tusa segam Tuke Pujuu Moisésan antugkauwai, nunik takash jegaa, agá, ajanum aatus ayaunak ashí ijinauwai. ");
INSERT INTO agr_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Nunikmatai aents aidau takash jinaun yajuak iju ijuma emakajui, dutikam ashí nugkanum pegkegchau mejeg akijuauwai. ");
INSERT INTO agr_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Tujash faraón nunú utugchatan agkan wajasa, ataktu antakchau wajas Israel aents aidau jiinjainum tau asa awake dakitau. Nuniau asa Moisés Aarógjai tabaunak antugkachui, Tuke Pujuu nuniktatui tibaunak imanisag. ");
INSERT INTO agr_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Tuke Pujuu Moisésan chichajak: “Aarón niina ushujutaijiya duwi nugka yukukuntu awatta tita, dutikam tetee najaneak, ashí Egipto nugkanmak piyakti”, tau. ");
INSERT INTO agr_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Tusa tima nuna uminak Aarón ushujutaiyai nugka yukukuntun awatiuwai, dutikam ashí Egipto nugkanum nugka yukukuntu aidau ayauk tetee najaneak, Egipto nugkanak akijuauwai. Imaniku asa aents aidaunak, kuntin aidaujai senchi waitkaidau. ");
INSERT INTO agr_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Nunitai tunchi aidaushkam dita dekamujin teteen najankatag tukama tujinkajui, nuninai teteek aentsnak, kuntinnak shiig kuashat waitkaidau. ");
INSERT INTO agr_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Nunik tujinkag tunchi aidau faraógkan chichajuinak: “Juka dekas Apajuí senchijiyai”, tuidau. Tamashkam faraógkak antakchau wajas Moisés Aarógjai tabaunak antugkachui, Tuke Pujuu nuniktatui tibaunak imaanisag. ");
INSERT INTO agr_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Nunitai Tuke Pujuu Moisésan chichajak: “Kashin kashikmas faraón namaka jegattawai, nuniktin asamtai, ameshkam kashikmasa nantakim jegaantata, núnikam Apajuí chichaak: ‘¡Mina aentsug aina nunak agkan idaitugsati, dutikam jiinag mina emematjitnume! ");
INSERT INTO agr_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Tuja ame mina aentsug aidau jiinjatnume tusa idaichakminig, wi aminak, amejai atuegak takau aina nuna, tuja amina aentsjum aina nunashkam anchi wegantu aidaun ishitkattagme. Dutika ai egiptunmaya aidau jenig, nugkeenish ayatak anchig piyaktatui. ");
INSERT INTO agr_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Tujash nunú imaniakuish, mina aentsug Egipto nugkanum Gosén batsata nunak wi kuitamkattajai, nuadui dita batsatbaunmak makichik anchigkesh atsuttawai. Nunú wainkum dekaattame wi Apajuí Tuke Pujuu tutain mina senchigjai juju nugka juwi dutikag nunú. ");
INSERT INTO agr_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Wi mina aentsug aidaunak agkanmitkakun, amina aentsjum aidaunak suwimka susattajai. Tuja duka kashin uminkattawai’ tujamui, tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Aatus Tuke Pujuu anchi aidaun faraógka pujusa inamtaijin, niijai atueka takatai aidau jenish ashí shiig kuashat anchin ishitkauwai, dutikam ashí Egipto nugkanmak ayatak anchig piyakmatai pegkegchau wajas asauwai. ");
INSERT INTO agr_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Imanikmatai faraón Moisésan, Aarógjai untsuka chichajak: “Wetajum, tujash atushat wetsuk atum batsatjum nuwig kuntin maa apeakjum atumin Apajuíji ememattajum”, tau. ");
INSERT INTO agr_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Tama Moisés ayaak: “Juwi pujusa dutikamuk shiig awajtamtsuji. Nunú kuntin maa apeamua duka egiptunmaya diismak shiig pegkegchauwai. Nuadui ii kuntin maa apeaku Tuke Pujuu emematjin egiptunmaya aidau waipakag, ditak kuntinu emematin asag kayai tuku tukugmainakua mantamain ainawai. ");
INSERT INTO agr_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nunin asamtai iik kampatum tsawantai weaja uwegshunum jegaa kuntin maa apeaku nii tujamauwa dutiksaik iina Apajuíji Tuke Pujuu tutaya nunú ememattag taji”, tau. ");
INSERT INTO agr_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Tusa tutai faraón chichaak: “Untsu takugmek uwegshunum wejum Tuke Pujuu atum emematin ainajum nunú kuntin maa apeakjum ememattajum. ¡Nuniakjum mina pachittsagmesh segatjitajum! Tujash shiig atushtak shiyakaigpajum”, tau. ");
INSERT INTO agr_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Tusa tama Moisés ayaak: “Israel aents aidau shiyakag kuntinun maa apeenak Tuke Pujuu ememattag tuina nunú wegpajum tusa tichatnaitkuminig, wi amijai juwi chichag nuna jiinkin, Tuke Pujuun segattatjame amina jemin, ame atueka takataijum aidau jeen nuigtu aentsjum aidau jenishkam anchi waitkagmaina duka kashin megkaejatnume tusan”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Nuna tusa Moisés faraógka jeen pujau agá jiinki Tuke Pujuun segauwai. ");
INSERT INTO agr_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Tusa segam Tuke Pujuu Moisés sumamunak imatiksag umikui. Nuadui faraógka jeen, nii atueka takataiji aidau jenish, tuja ashí niina aentsji aidau jenishkam makichik anchigkesh atsusui. ");
INSERT INTO agr_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Nunikmatai faraón antakchau wajas, Israel aents aidauk dekas jiinjashtinme tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Nunikmatai Tuke Pujuu Moisésan chichajak: “Faraón jegajua chichagkum: ‘Tuke Pujuu Apajuí, Hebreo aents aidauti emematin ainag nunú chichaak: Mina aentsug aina nuna jiigti, dutikam mina emematjitnume’, tawai. ");
INSERT INTO agr_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Tusa tamaitkum jiinjatnume tutsuk ayatak eme emeteakua wegau asamin, ");
INSERT INTO agr_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","amina tagkujum aidau ajagmin batsata nuna Tuke Pujuu niina senchijin jata ishamainun awetittawai. Dutikam caballo aidau, burro aidau, camello aidau, baka aidau, uwig aidau ashí jinattawai. ");
INSERT INTO agr_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Tujash Israel aents aidau tagkujig makichkish jakashti tusa Tuke Pujuu kuitamjuktatui, untsu egiptunmaya aidau tagkujinak ijituattawai. ");
INSERT INTO agr_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nuigtushkam Tuke Pujuu tsawantan mamikia chichaak: “ ‘¡Wi kashin nunak dutikattajai!’ tawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Nuna tusa idayas tsawamunum egiptunmaya aidaun tagkujinak Tuke Pujuu ashí ijituauwai. Tujash Israel aents aidau tagkujig makichkish jakachui. ");
INSERT INTO agr_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Nunikmatai faraón niina aentsji aidaun ishiakui Israel aents aidau tagkujish jinacheash diisa ukutajum tusa. Nunú waketug kauna Israel aents aidau tagkujig makichkish jakachmae tusa ujakajui. Nuna dekaash faraógkak antakchau wajas, Israel aents aidaunak jiinjatnume tichauwai. ");
INSERT INTO agr_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Nunikmatai Tuke Pujuu Moisésan, Aarógjai chichajak: “Pag inagtainum yuku awa nunú uwegmin atsaakijum jukitajum, dutikajum faraón wainai Moisésa ame yaki nagkimata. ");
INSERT INTO agr_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Dutikam nunú nugká iyaak yukukuntu najanea ashí Egipto nugkanum jamagti, nuniak ashí aents aidaunak tagku aidaujaí kuchap amuati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Tusa tima pag inagtainum yuku aun jukiag faraón pujamunum jegawajui, nuwi Moisés yukuun yaki nagkimauwai. Dutikam aents aidaunak, tagku aidaujai kuchap amuauwai. ");
INSERT INTO agr_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Nuna tunchi aidaushkam achiimag tikich aents aidaujai betek jinuidau asag, ataktu awagkig makichkish Moisésjaig dekapdaimainchau wajasui. ");
INSERT INTO agr_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Tujash faraógnak Tuke Pujuu antakchau emauwai, nuadui Moisés Aarógjai tabaunak makichkish antugchau, Tuke Pujuu Moisésan chichajak nuniktatui tibaunak imanisag. ");
INSERT INTO agr_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Nunikmatai Tuke Pujuu Moisésan chichajak: “Kashin kashikmasa nantakim faraón pujamunum wetá, nunika chichagkum: ‘Tuke Pujuu, Apajuí Hebreo aents aidauti emematin ainag nunú chichaak: Idaisati mina aentsug aina nuna; dutikam mina emematjitnume. ");
INSERT INTO agr_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tuja nunú dutikachkuminig yamai nagkamsanuk mina suwimkajun amina, nuigtu amejai atueka takataijum aidaun, tuja ashí amina aentsjum egiptunmaya aina nuwishkam ishitkattajame. Dutikamtai dekattame ashí nugkanmak tikich witag imajuk makichkish atsa nunú. ");
INSERT INTO agr_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Wika aminak, amina aentsjum aidaujaí suwimka amaakun mina senchigjai yaunchuk ijinan juju nugka juwig emegkaumain awajkajime. ");
INSERT INTO agr_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Tujash dutikachjime wagki mina senchijun atumin iwaintuka ai, ashí tikich nugkanmaya aidaush dekajuatnume tau asan. ");
INSERT INTO agr_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","“ ‘Dutika idaimaitkum mina aentsug aidau jiinjatnume tutsuk ayatak eme emeteakuam weame. ");
INSERT INTO agr_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Nuadui kashin kashikmasan bicha múun aidaun yaunchuk nagkamsash imanuk Egipto nugkanmag wainajakchamun yutumtijattajai. ");
INSERT INTO agr_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Imaniktin asamtai tagkujum ajanum batsatuk ashí yajuakjum jegá utsatajum, nunú dutikachaminig, bicha múun aidau kakegak ashí aents aidau ajanum batsatunak, kuntin aidaujai ijinattawai’ tawai Tuke Pujuu”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Tusa ujakam faraógka atuwe aidau Tuke Pujuu tibaun ishamaidauk, ditá inake aidaun, tagkuji aidaujai jegaa utsawajui. ");
INSERT INTO agr_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Untsu tikich aidau Tuke Pujuu tibaun puyatjus anentaimtuinachuk, ditá inake aidaunak tagkuji aidaujaig jegag utsachajui. ");
INSERT INTO agr_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Nunik batsatai Tuke Pujuu Moisésan chichajak: “¡Uwejum nayaimpinmanini takuita, dutikam bicha yutugti, nuniak ashí Egipto nugkanum kuntin aidau, aents aidau, ashí ajak aidaush ayá nuna ijinati!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Tusa tama Moisés niina kuntujin nayaimpinmanini takuiniuwai, dutikamtai Tuke Pujuu chaagpin, peeman ajunjauwai, dutikak bicha múun aidaun ashí Egipto nugkanum yutumtijauwai. ");
INSERT INTO agr_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tuja chaajip patauk, peem peetuk, bicha kakegush makichkish mijamtsuk tuke imani au; yaunchkesh Egipto nugkanmag ibau wainajakchamu wantinjauwai. ");
INSERT INTO agr_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ibau kakegu asa Egipto nugkanum ayaunak ashí tsaikui: aents aidaun, kuntin aidaun, ajak aidaujai ashí ijinauwai, dutikak numi aidau kanawenak ashí kupijauwai. ");
INSERT INTO agr_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Nunú imaniakush nugka Gosén Israel aents aidau batsatbaunmak makichik bichakesh iyaagchauwai. ");
INSERT INTO agr_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Imanitai faraón Moisésan Aarógjai untsuka chichajak: “Dekas wi pegkegchaun takasag nunak dekagmamjai. Juna imajun itugchata igkugka waitiag duka Tuke Pujuu itugchatjinigkish waitiatsjai, juka mina pegkegchaujui, nuigtu mina aentsug aina nuna pegkegchaujin waitiajai. ");
INSERT INTO agr_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Wait aneasjum jutiish Tuke Pujuu segatkagtitajum, chaajip patak ishamain waja nunú, bicha yuta nujai mijaakti. Nunikmatai wisha atumnak emettsuk shiyaktajum tusan idaisatjime”, tau. ");
INSERT INTO agr_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Tusa tama Moisés ayaak: “Wi juju yaaktanum pujag nuna jiinmawaik, mina uwejun takuin Tuke Pujuun segattajai, dutikai chaagpik megkaekattawai, tuja bicha yuta dushakam megkaekattawai. Nunikmatai dekattame nugkak dekas Apajuínuapi tusam. ");
INSERT INTO agr_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Tujash iman ishamain wainkumesh amek, amina atueka takataijum aina nujai, Tuke Pujuu yamaikish ishamatsjum nunak wika shiig dekajai”, tau. ");
INSERT INTO agr_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Tuja bicha yutak ajak lino ajakbau yagkujuku aidau, nuigtu cebada ajakbau aidau nejekunak ashí ijinauwai. ");
INSERT INTO agr_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Untsu trigo aidau, centeno aidau ajakbauk makichkish wajukachajui eke tsapainachu asag. ");
INSERT INTO agr_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moisés faraógjai chichasa yaaktanmaya jiinmawaik uwejen takui Tuke Pujuun segauwai, dutikamuik wamak chaajip ishamain wajauk, bicha yutauk, yumi yutaushkam mijaakui. ");
INSERT INTO agr_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Nunik mijakmatai faraógkak ataktushkam pegkegchaun takasui. Nuniak niijai atueka takataiji aidaujai anentainkachu wajasui. ");
INSERT INTO agr_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Nuniau asa Israel aents aidaunak jiinjatnume tusag idaisachui, Tuke Pujuu yaunchuk Moisésan ujaak nuniktatui tibaunak imaanisag. ");
INSERT INTO agr_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Tuke Pujuu Moisésan chichajak: “¡Faraón pujamunum wetá! Wi niinak, niijai atueka takataiji aina nujai antakchau emattajai, wagki mina senchigjai wainchatai ishamain aidaun iwaintuktag tau asan. ");
INSERT INTO agr_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Tuja nunú wainchatai ishamainun egiptunmaya aidaun iwaintuktatag nunú wainkau asajum, amina uchijum aidau, tijajum aidau nunú pachisa ujakminum tau asan dutikattajai. Nunú wainkau asajum wi Apajuí Tuke Pujuu tutayaitag nunú dekattagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Tusa tima Moisés Aarógjai faraógka jegajuawag chichajuinak: “Tuke Pujuu Apajuí, Hebreo aents aidauti emematin ainag nunú aatus tawai: ‘¿Wajupa asamea emematjum idaikumesh wi tabaush umiktatme? Idaisata mina aentsug aidau, jiinjag mina emematjitnume. ");
INSERT INTO agr_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Tujash emeteakminig, kashin manchin ishitkattajame amina nugkemin. ");
INSERT INTO agr_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Nunú manchi nugkanak akijuattawai, imanikmatai nugka wainmainchau wajastatui. Imanidau asag ajak bicha ijinam ujumak ampinjaunak amuktatui, tuja nuigtushkam numi aidaunashkam yuwa amuktatui. ");
INSERT INTO agr_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Imanidau asa ame pujusa inamtaigminig, amejai atueka takatai aidau jenish, ashí egiptunmaya aents aina juna jenish imanisag manchi piyaktatui. Duka amina apakesh, apachjum aidaukesh nuniachkush yamaikish imanuk wainkachbau wainkattame’ tujamui”, tusa ujaka ukuak jiinkiuwai. ");
INSERT INTO agr_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Nuna tusa waketjamtai, faraógka atueka takataiji aidau niina jegantag tuidau: “¡Au aents aina duka kuashta utugchata apujtugmas waitkagmainawai! Nuniau asamtai, dekas shiyaktajum nunikjum atumi Apajuí Tuke Pujuuwa nunú ememattajum, tita. ¿Amek waintsumek Egipto nugka tsainak patamsa duka?” tuidau. ");
INSERT INTO agr_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Tusa tima faraón Moisésan Aarógjai ataktu untsuka chichajak: “¡Wetajum, nunikjum Apajuí Tuke Pujuu atum emematin ainajum nunú ememattajum! Tujash eke wetsuk tujuttajum, ¿ya aidauwa miniagtatua?” tau. ");
INSERT INTO agr_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Tusa tama Moisés ayaak: “¡Jutii aidautik ashí iina uchiji piipich aidau, múuntuch aidau, iina nawanji aidau, iina uchiji aishmag aidau aatsa ashí yajuaka, nuigtu iina uwigji, baka aidaujaí yajuaka shiyaktatji! ¡Nunú atatui dekas jutii Tuke Pujuu emematuinaku shiig aneasa jiistamauwa nunú!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Tusa tutai faraón ditan tuke aneas dushikiak: “¿Ayu duka nuniktajum, atumi Apajuíjum Tuke Pujuuwa nunú uyuntamsatnume tusa tujutchaintash tatsugmek? ¡Waitju yujagme! ¿Wi anentainchaukaitag uchijum yajuaka shiyaktajum tusa idaisatnun? Atumek duka pegkegchau anentaiyai tuu yujagme. ");
INSERT INTO agr_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Duka nunikchattagme. Ayatak aishmag múun aidautigmek wejum Apajuí ememattajum, nunú nuniktasa wakegau asajum”, tiuwai. Nuna tusa juju wamak jiiki ishiaktajum tima jiiki ishiakajui. ");
INSERT INTO agr_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Dutikamtai Tuke Pujuu Moisésan chichajak: “Uwejum takuita dutikawamin Egipto nugka juwi manchi kaunak ajak ayá nuna, tuja bicha ijinam ampinjau aina nujai amukti”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Tima Moisés ushujutaijin juki Egipto nugkanum takuiniuwai, dutikam dase etsa minitaiya nuwiya shiig senchi tsawai, kashish dasenkau. Nunik tuke dase dasenkawa tsawak manchin ikaunmakui. ");
INSERT INTO agr_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Dutikam nunú manchi Egipto nugkanmak piyak asauwai, yaunchuk nagkamsash imanijakchamun tuja atakesh imani achatnun. ");
INSERT INTO agr_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Imanik manchik ashí nugkanum piyaku asa shuwin wajas asauwai. Imaniku asa bicha ijinam ajak ampinag juwaku aidaunak ashí amukui. Dutika ashí amukbau asa makichik numi dukendukesh Egipto nugkanmak shiig atsusui. ");
INSERT INTO agr_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Imanitai faraón puyatuk wamkes Moisésan Aarógjai untsuka chichajak: “Atum Tuke Pujuu Apajuí emematin ainajum nuna emtin, tuja atumi emtinishkam pegkegchaun takasjai. ");
INSERT INTO agr_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Tujash wait aneasjum mina tudaujush tsagkugtugtajum nuniakjum segatjitajum atumi Apajuíjum Tuke Pujuu emematin ainajum nunú, dutikam manchi ajaka amuina nunú megkaejati”, tau. ");
INSERT INTO agr_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Tusa tima Moisés faraógka jenia jiinki Tuke Pujuun segauwai. ");
INSERT INTO agr_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Tusa segam Tuke Pujuu dasen etsa akaetaiya nuwiyan awemauwai, dutikam shiig senchi dasentak manchinak tajak yajuak nayants kajis ain tutainum utsauwai. Makichik manchikesh Egipto nugkanmak juwakchauwai. ");
INSERT INTO agr_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Tujash Tuke Pujuu faraógnak antakchau awagsauwai, dutikamu asa Israel aents aidaunak jiinjati tusag idaisachui. ");
INSERT INTO agr_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Dutikamtai Tuke Pujuu Moisésan chichajak: “¡Uwejum nayaimpinmanini takuita! Dutikam ashí Egipto nugkanmak shiig kanchi achikaish dekapmain wajasti”, tau. ");
INSERT INTO agr_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Tama Moisés uwejen nayaimpinmanini takuiniuwai, dutikaig ashí Egipto nugkanmak shiig kanchi wajasui. ");
INSERT INTO agr_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Imaanikmatai, nii pujamu yantamen pujaujaish wainitsuk, nuigtush yajakesh wekaemainchau wajasag kampatum tsawan nuwig batsatu. Tujash Israel aents batsatbaunmak tsawai au. ");
INSERT INTO agr_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Nunikmatai faraón Moisésan untsuka chichajak: “Yamaik ashí uchijum aidaushkam yajuakjum wetajum, nunikjum atumi Apajuíjum Tuke Pujuu ememattajum. Tujash uwigjum, bakajum aina duka ukuktatjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Tusa tama Moisés ayaak: “Duka makichkish nunikchattawai, atumetjume tagku sukagtumaintigmek. ");
INSERT INTO agr_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tuja nuigtushkam iina tagkuji aidauk ashí yajuaktatji, makichkish juwakchattawai, wagki nuwiya etegja juki maa apeaku iina Apajuíji Tuke Pujuu emematta tuidau asaja. Tuja ii Apajuí ememattinnum eke jegaskek, Apajuí emematta takuish wajig atsumtaji duka dekamaitsui”, tau. ");
INSERT INTO agr_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Tujash Tuke Pujuu faraógnak antakchau awajsauwai, dutikamu asa Israel aents aidaunak jiinjati tusag idaisachui. ");
INSERT INTO agr_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Tuja nuigtushkam faraón kajeka Moisésan chichajak: “¡Jiinkim wetá ataktu wakitkimek tajutuawaipa! ¡Ataktu wakitki juwi takminig maattajame!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Tama Moisés ayaak: “¡Dekas tame, ataktuk makichkish tajuashtatjame!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Tuke Pujuu Moisésan chichajak: “Faraógnak, niina aentsji egiptunmaya aina nujai tikich suwimkan awetittajai. Dutika ai atumnak wetajum tusa idaitamsattawai. ¡Tuja niina nugken batsatjum nunak ajumaish wakitki taashtinun jiipag ishipaktatui! ");
INSERT INTO agr_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Nuadui Israel aents aishmag aidau, nuwa aidau ashí ujakta umintsatnume, nuninak egiptunmaya aidau ditajai ijutkau batsata nuna jiju plata tutayai nugkutai, patakumtai najanamu aidaun, tuja orojai najanamu aidaunashkam segatnume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Tuja egiptunmaya aidau Israel aents aidaun eme anentus diitnume tusa Tuke Pujuu tibau asamtai, ditanak eme anentus diidau. Tuja Moisésnashkam faraógka atuwe aidaushkam eme anentus diidau, antsag ashí egiptunmaya aidaushkam Moisésan eme anentujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Tuja Moisés faraógkan chichajak: “Tuke Pujuu aehaet ai Egipto nugkanum nagkaemaktatjai, tujamui. ");
INSERT INTO agr_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Nuniai ashí egiptunmaya uchi iwai aidau jinattawai. Faraógka uchiji iwai apu ati timauwa nuwi nagkamnas, niina inataiji ajak juukbaun dekegka najanin aina nuna iwaijishkam jinattawai. Tuja ashí kuntin yama nagkamchaku petsakbau aidaushkam jinattawai. ");
INSERT INTO agr_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Nunikmatai ashí egiptunmak yaunchkesh imanishtain, tuja ajumaish nunikchatnun senchi buutuinak pampaidiagtatui. ");
INSERT INTO agr_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Tujash Israel aents aidaun uchiji iwai aidauk makichkish jakashtatui. Tuja tagkuji yama nagkamchaku petsakbau aidaukesh jinashtatui. Nunik agkan batsatu asamtai, makichik yawá shinaukesh antuekashtatui. Duwi dekattagme Apajuí egiptunmaya aidaun suwimka suwak Israel aents aidaunak kuitama nunú. ");
INSERT INTO agr_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Juju aatus nagkaemakmatai amina atueka takataijum aina nunú ashí tajutuawag tikishmag segatuinak: ‘Aentsjum aidau ashí yajuakam wetajum’, tujutiagtatui. Untsu nuna tujutainachkuig wechattajai”, tiuwai. Nuna tusa faraógka pujusa inamtaijin pujau Moisés kajeka jiinkiuwai. ");
INSERT INTO agr_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Nunikmatai Tuke Pujuu Moisésan chichajak: “Faraógkak tusa tamash antugtamkashtatui, nuniakush wi aan senchi ishamain aidaun ashí Egipto nugkanum iwainagtatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Tuja Moisés Aarógjai faraógkan nunú ishamain aidaun ashí iwaintukui. Dutikamash faraógkak Tuke Pujuu antakchau emamu asa, Israel aents aidau Egipto batsatunak jiinjati tusag idaisachui. ");
INSERT INTO agr_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Moisés Aarógjai eke Egipto nugkanum pujaun Tuke Pujuu chichajak: ");
INSERT INTO agr_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Juju nantu taka juju atatui mijan nagkamnamu. Juju makichkish kajimattsuk puyatjusjum aneaku atatjume. ");
INSERT INTO agr_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Nuadui ashí Israel aents aidau wi yamai tajim nunú ujaktajum: Juju nantutin tsawan diez tsawagtata duwi maki makichik múun uchigtin aidau uwig aishmag tsakatan, dutikachkush chivo aishmag tsakatan achiktinme. ");
INSERT INTO agr_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Untsu ujumchik uchiji ajamu aidauk tikich múun uchiji ujumchik ajamujai ijunag makichik kuntinun maa maki makichik aentsush wajupaun yumainaita dutiksag tinamdaegak yuwatnume. ");
INSERT INTO agr_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Nunú kuntinuk makichik mijan ajamu aishmag makichkish jamamtuchu pegkeg atatui. Duka uwig tsakat, nuniashkush chivo tsakatkesh atatui. ");
INSERT INTO agr_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“Tuja nunú kuntin achikbau pujutta nunak, juju nantutin tsawan catorce tsawag agkuantai ashí Israel aents aidau maawagtatui. ");
INSERT INTO agr_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Dutika maawag nuna numpen jukiag jega dita ijunag yuwawagtata nuna waitiji atin, numi jimag ajiamua nuna, nuigtu yakí minamua nujai ashí ukatkatnume. ");
INSERT INTO agr_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Dutikawag nunú kashia nuaduik kuntinu neje pegka inajuamun dupa yapau yutai aina nujai, nuigtu pag levadurajai pachimtsuk inajuamujai yuwatnume. ");
INSERT INTO agr_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Untsu kuntin aina nuna neje uduuk, nuniachkush painka inagkamuk makichkish yuwawaigpajum, ayatak pegka inajuamu yuwatajum. Tuja buuke, nawe, anentai, akapé aina dushakam pegka inajuajum yuwatajum. ");
INSERT INTO agr_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","“Untsu tsawaja yuwatnuk ukukigpajum, tuja neje ampinjamtaig jiinum apeatajum. ");
INSERT INTO agr_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Tuja neje yuwakjumek shiig yapagmamajum, sapat wegamakjum, ushujutaijum takusa wajasjum waugsajum yuwatajum, wagki wi atumi ayamjukan uwemtikattajim nunú tsawan asamtai, mina emematjakjum tuke dutiksagmek yutinaitjume. ");
INSERT INTO agr_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Tuja nunú kashia duwi wi ashí Egipto nugkanum nagkaemakun uchi iwai egiptunmaya aidaunak ashí ijinattajai. Dutikakun kuntinu uchiji yama nagkamchaku petsakbau aidaunashkam ashí ijinattajai. Tuja egiptunmaya aidau apajuímtaiji aina nunashkam ashí tsaigkattajai. Ima wikitjai Apajuí Tuke Pujuunuk, tikichik atsawai. ");
INSERT INTO agr_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","“Tuja nunú numpai ukatkatajum duka atum tuu jeganum pujagme nuna iwainaktatui, nunú numpa wainkun atumnak agkan nagkaikittajime. Nuadui egiptunmaya aents aidaun wi ijintaish, atuminig makichik jamukesh atsuttawai. ");
INSERT INTO agr_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“¡Juju tsawantak tuke kajimatkishtin atajum! Juju tsawantin ijunjajum mina emematjakjum tuke jiistamtinaitjume. Junak uchi akiinak wedaushkam tuke dutiktin agtinme. ");
INSERT INTO agr_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Tuja tsawan catorcetin kuntin maa yuwattajum, duwi nagkamsajum siete tsawantai pag levadurajai pachimtsuk inajuamu yuwattagme. Nuadui nunú tsawantin nagkamas atumi jeminig makichkish levadurak atsuttawai. Tuja makichik aentskesh pagkan levadurajai pachimag inajua siete tsawan aina nunú tsawantin yuwauk, jiiki ajapeam atatui. Dutikamu asa Israel aents aidaujaig ijunjag pujuschatnai. ");
INSERT INTO agr_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Tuja tsawan jiista nagkamnamua duik, ashí ijunjajum mina emematjitnaitjume. Tuja jiista amuebau tsawan sieteya duwishkam nunisjumek ashí ijunjajum mina emematjitnaitjume. Nunú tsawantinig makichkish atumi takatjumek takaschattagme, untsu atum yuwatin umiktatjum duke dutikattagme. ");
INSERT INTO agr_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Nunú jiistaya duka, atum Egipto pujautigmin wi nunú tsawantai jiiktatjim nuadui tuke jiistamtin atajum. Junak uchi akiinak wedaushkam tuke dutiktin agtinme: ");
INSERT INTO agr_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Juju yama nagkamchak mijan nagkamnamu nantu taka juju atatui pag levadurajai pachimtsuk inajuamu yutai, juka tsawan catorcetin aagkú nagkamajum; veintiunotin aagkú inagnattagme. ");
INSERT INTO agr_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Siete tsawantai atumi jeminig levadura atsuttawai. Tuja siete tsawan aina nunú tsawantin pag levadurajai pachimja inajuamun yuwauk, Israel aentschaukesh, tuja Israel aents akushkam jiiki ajapeam atatui. ");
INSERT INTO agr_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Nuadui pag levadurajai pachimja inajuamuk makichkish yuwawaigpajum. ¡Atum tuwi pujuttagme! nuniakjumesh nunú jiistatinig pag levadurajai pachimtsuk inajuamu yuwatajum”, tiuwai Apajuí. ");
INSERT INTO agr_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Juna aatus Apajuí timatai, Moisés Israel aents aidau apuji múun aidaun ashí ijumag chichajak: “Wejum uwig aishmag tsakat achiktajum, tuja dutikachkugmesh chivo tsakatkesh achikjum maki makichik atumi jemin maatajum. Dutikawagmin nunú yuwaku Apajuí iina jiipag agkanmitkagmatta nunú tsawan Pascua jiistamawagmi. ");
INSERT INTO agr_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Untsu numpak pinignum jukitajum, dutikajum ajak hisopo tutaya nuna titiji kupika jukijum, numpai uchupjajum waiti nujamkatin numi ajiamu aina nunú, tuja nuna yakin minamua nujai ashí ukatkatajum. Nunú dutikagmesh eke tsawatsaigkik makichkish jiinkigpa. ");
INSERT INTO agr_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Egiptunmaya aents aidau uchiji iwai aidaun ijituatatus Tuke Pujuu nagkaemak waiti nujamtai jimag numi awa nunú, yakin minamua nujai numpai ukatkamun wainak ikaa nagkaemaktatui. Nuniak niina aentsji nayaimpinmaya magkagtina nuna atumi jeminig wayashti titatui. Nuadui atumi uchijum iwai aidauk makichkish jakachagtatui. ");
INSERT INTO agr_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Juju dutikatajum tujabi duka betek umiktin atajum, tuja atumi uchijum wegantu aidaushkam tuke dutiktin agtinme. ");
INSERT INTO agr_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Apajuí nugkan anagtabauwa nuwi jegagmesh, juka tuke jutikin atinaitjume. ");
INSERT INTO agr_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Tuja uchijum inimpainak: ‘¿Wagka jusha jutikaji?’ tusa inimpainakuig, ");
INSERT INTO agr_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","atum ayaakjum: ‘Juju kuntin tuké maag juka Apajuí niina aentsji makagtinun awemamu nagkaemak egiptunmaya aentsu uchiji iwai aidaun ijitak, Israel aents aidauti jenig waittsuk, ikaa nagkaemak ijipachua nunú anentaimtusa jutikaji’ titajum”, tiuwai. Aatus Moisés chichaka inagnakmatai, Israel aents aidauk ashí tikishmag pujusag Tuke Pujuun emematuidau. ");
INSERT INTO agr_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Nunik wakitkiag, Tuke Pujuu Moisésan Aarógjai akatjamunak imatiksag betek umikajui. ");
INSERT INTO agr_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nuniamunum aehaet Tuke Pujuu aentsji nayaimpinmaya magkagtin nagkaemak egiptunmaya uchi iwai aidaunak, faraógka uchiji iwai apu atin tibau niina apaji pujusa inamtaijin pujujakua nuwi nagkamas, aents achikam chimpijun uchiji iwai aidaunashkam, tuja kuntinu uchiji yama nagkamchaku petsakbau aidaujaí ijinauwai. ");
INSERT INTO agr_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Dutikamtai nunú kashia duwi faraón niijai atueka takataiji aidaujai, nuigtu ashí aents Egipto nugkanum batsamin aidauk nantajag shiig senchi buutuinak ashí egiptunmak pampaidau. Makichik jeganmakesh iwai iwaaku pujauk shiig atsusui. ");
INSERT INTO agr_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Nunikmatai nunú kashia duwik, faraón Moisésan Aarógjai untsuka chichajak: “¡Shiyaktajum, nuniakjum Israel aents aidau ashí yajuaktajum, nunikjum atum timaujum dutiksagmek atumi Apajuíjum Tuke Pujuu ememattajum! ");
INSERT INTO agr_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Nunika shimakjum atum mina segatmaujum duka dutiksagmek uwig aidau, baka aidau yajuakjum wetajum. ¡Nuniakjum minash Apajuí Tuke Pujuu segatjitajum!” tau. ");
INSERT INTO agr_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Tuja Israel aents aidau iina nugken batsata nuna wamak shimuinachkuig, ashí jinawaig tuidau asag, egiptunmaya aents aidau ditan waugmitkaidau wamak shiyaktinme tusag. ");
INSERT INTO agr_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Dutikainam ditashkam harina nanegbau levadurajai pachimjachbaun, harina namutaijai ijumag ditá jáanchjin pempeajag yanakiag jukiajui. ");
INSERT INTO agr_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Dutikainak Moisés ditan akatjamunak imatiksag Israel aents aidauk egiptunmaya aidau wajiji jiju plata tutayai najanamu aidaun, orojai najanamu aidaun, tuja jáanch nugkutai aidaunashkam segaidau. ");
INSERT INTO agr_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Dutikainam egiptunmaya aidauk ashí dita sumamunak imatiksag susajui, wagki Israel aents aidaun eme anentus diitnume tusa Tuke Pujuu dita anentain antinkamu asag. Dutika dita wajiji aidaunak ashí susag wajigtuchu juwakajui. ");
INSERT INTO agr_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Tuja Israel aents aidauk yaakat Ramsés batsatu jiinag shiyakajui Sucot nugkanum. Tuja nuwa aidau, uchi aidau dekapatsuk ayatak aishmag wajiu maanimain aidauk dekapamak seiscientos mil aajakui. ");
INSERT INTO agr_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Israel aents aidau jiinag shimuinakug uwig aidaun, baka aidaun, shiig kuashat yajuakajui. Nunik shimiagtai aents tikich nugkanmaya aidaushkam shiig kuashat ditajai ijunag shiyakajui. ");
INSERT INTO agr_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Nunik shimuinak, yujumak inagmain tsawan atsutai yumainun inagkachaju asag harina levadurajai pachimtsuk nanegbau egiptunmaya jukimujin nuna pagkan najanak inagkajui. ");
INSERT INTO agr_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Tuja Israel aents aidauk Egipto nugkanmak cuatrocientos treinta mijan batsamsaju ainawai. ");
INSERT INTO agr_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Tuja cuatrocientos treinta mijan jegau ai, nunú tsawantaik Egipto nugkanum batsatu ashí jiinjaju ainawai. ");
INSERT INTO agr_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Tuja Tuke Pujuu niina aentsji Israel aidaun Egipto nugkanum batsatun jiigtatus nunú kashia duwi ditan kuitamak wekaetau. Nuadui atakea duish Israela uchiji aidaush Tuke Pujuun emematuinak nunú kashia duwi kanutsuk tsawaidiagtin ainawai. ");
INSERT INTO agr_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Uchi iwai aina nunú midau agtin akaantugkata, wagki ashí Israel aents aidau uchiji aishmag iwai akiinuk, tagku yama nagkamchaku petsakbau aina nujai ¡ashí midau ainawai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Tusa tima Moisés nii wegantu Israel aents aidaun chichajak: “¡Atum Egipto nugkanum batsamsajum waitu batsatutigmin, Tuke Pujuu niina senchijijai juju tsawantin jiipaja nunú tsawan aneaku atajum! Nuniakjum nunú tsawantinig pag levadurajai pachimja inajuamuk yuwawaigpajum. ");
INSERT INTO agr_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Atumek juju tsawanta juwi, nantu Abibtin jiinjume. ");
INSERT INTO agr_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Atumi muunjum aajaku aina nuna Tuke Pujuu anagkuak: ‘Canaán aents, hitita aents, amorreo aents, heveo aents, Jebús aents aina nuna nugke shiig pegkeg, ajak shiig tsapau, tagkush shiig muumpaina nuna atumi uchijum aidaunak susagtinaitjai’ tiuwa nuwi ejetamawagmatai, batsamsagmesh juju nantua juwi ijunjajum Tuke Pujuu tuké ememattin atajum. ");
INSERT INTO agr_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Tuja siete tsawantai pag levadurajai pachimtsuk inajuajum yutinaitjume, untsu tsawan sieteya duwi ijuntsajum Tuke Pujuu emematkujum jiistamattagme. ");
INSERT INTO agr_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Siete tsawantai pag levadurajai pachimtsuk inajuamu yuwatajum, nunú tsawan aina nuaduik levadurak tuja pag levadurajai pachimja inajuamukesh atum pujamunmak shiig atsuttawai. ");
INSERT INTO agr_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Tuja nunú tsawantin uchijum aidau chichagkujum: ‘Juka ii Egipto nugkanum waitkam batsatutin Tuke Pujuu jiipajua nunú anentaimtusa jutikaji’ titinaitjume. ");
INSERT INTO agr_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Nunak Tuke Pujuu midau atinme tusa atumin uwegmin, dijaimin agatjamkau amainaitjum numamtuk asamtai, chicham umiktin agagbaun Tuke Pujuu umiktajum tujabauwa duka kajimattsuk aneaku atatjume. Wagki Egipto nugkanum waitkam batsatutigmin niina senchijin jiigmajaju asamtai. ");
INSERT INTO agr_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","¡Nuadui maki makichik mijantin tsawan mamikiamua duwi shiig aneasa ijunjajum Tuke Pujuu tuké ememattajum! ");
INSERT INTO agr_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Tuke Pujuu atumi muunjum aajaku aina nuna, tuja atumnashkam canaágnumia aents aidau nugken amastajime tusa anagtabauwa nuna amasmataig, ");
INSERT INTO agr_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ashí uchi iwai aishmag akiinaidauk, kuntinu uchiji yama nagkamchak aishmag petsakbauwa nujai Tuke Pujuu idaitustajum, wagki duka niinu asagmatai. ");
INSERT INTO agr_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tuja uwija uchiji aishmag atsugtamkuig, burro yama nagkamchaku petsakbauwa nunú maatajum. Untsu uwig tsakat ajutjamkuig, tuja chivo tsakatkesh ajutjamkuig, nunú Tuke Pujuu suwakjum burrok mautsuk idaisatajum. Tuja atumi uchijum aishmag iwai aidau Tuke Pujuu sumaina nunú tikich waji anentag Tuke Pujuu suwakum uchijum uwemtijatajum. ");
INSERT INTO agr_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Tuja tikich tsawantai uchijum inimpak: ‘¿Wagka jusha jutikame?’ tujamkuig, ame ayaakum: ‘Ii aidauti Egipto nugkanum batsamsa inaku waitkatai batsatutin Tuke Pujuu niina senchijin jiigmag agkanmitkagmauwa nunú tsawan asamtai jutikaji. ");
INSERT INTO agr_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Tuja faraón antakchau wajas iina jiipatan dakittai, Tuke Pujuu egiptunmaya uchi aishmag iwai aidaun, kuntinu uchiji yama nagkamchaku petsakbau aishmag aidaujaí ijituawa nuadui, kuntin yama nagkamchak petsakbau maa apeaku Tuke Pujuu emematji, wagki jutii uchiji aishmag iwai aidau jatsuk uwemkaju aina duwi. ");
INSERT INTO agr_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Nuadui kuntin iinu atin kuntunum, dijainum agatjamu amaina numamtuk atum kuntin maa apeamua nunú tuké anemtijamsagke atinai, atum Egipto nugkanum pujautigmin Tuke Pujuu niina senchijin jiigmajajua nunú’ ”, tiuwai Moisés. ");
INSERT INTO agr_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Faraón Israel aents aidaun shiyaktinme tusa idaisamtaish, Apajuík filisteo batsata nuni jinta tutupit jegá aatu wetinme tusag tichauwai. Wagki filisteo aents aidau jinta epetam ditajai maaninak ishamak awake anentaimag Egipto nugkanum ataktu waketjainum tau asa. ");
INSERT INTO agr_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Nuadui dekas jinta uwegshun tentea wea nuni nayants kajis ain tutaya aatus wetinme tiuwai. Nuadui Israel aents aidauk Egipto nugkanum batsatu jiinag shimak, suntag maaniatatus shimumaina imaanik shiyakajui. ");
INSERT INTO agr_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Nunik wenak Moisés José ukunchin jukiuwai. Nunak dutikauwai wagki José iwaku pujusa niina patayi Israel aents aidaun chichajak: ¡Apajuí atumnak jiigmajagtin ainawai; dutijamainakuig mina ukunchjuk ukutsuk jukitin atajum! tibau asag. ");
INSERT INTO agr_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Nunikag nugka Sucot tutainum batsatu jiinag uwegshunum jegantatak, Etam nugkanum jegawag aakmajag batsamsajui. ");
INSERT INTO agr_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Tuja tsawai dita shimamunum nuna emtin Tuke Pujuu yujagminum pachitkau eemak wejakui, untsu kashi jii kegaunum pachitkau eemak wegau, nuna diisag tsawaish, kashish shiyaktinme tusa. ");
INSERT INTO agr_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tuja tsawai shimiagtaik yujagkim awaantamu eemak wajantun wejakui, antsag kashi shimiagtaishkam jii keeka eem wajantun wejakui. ");
INSERT INTO agr_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Israel aents aidau Etam nugkanum batsatai, Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Israel aents aidau ujakta, waketug Migdol nugka nayantsajai niniaku awa nuna ejapeen yaakat Pi-hahirot tikich yaakat Baal-zefonjai awa, nujai niinis nayantsanum uwet aakmag batsamsatnume. ");
INSERT INTO agr_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Faraón anentaimas: ‘Israel aents aidauk wajuk wetinmeki nunak dekainatsui. Nuadui, auk uwegshunum wagaja yujatai’ titatui. ");
INSERT INTO agr_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Tuja atumin pataetugmaktinme tusan wi niinak ataktu antakchau awajsattajai. Dutika ai pataetugmakui, niina, tuja niina suntaji aidaujaí wi mina senchijun iwaintuktatjai. Dutika ai egiptunmaya aidauk, wi Apajuí Tuke Pujuu tutayaitag nuna dekajuawagtatui”, tiuwai. Tusa tiajam Israel aents aidauk Tuke Pujuu tibaun betek uminak nuwi aakmajag batsamsajui. ");
INSERT INTO agr_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Nuninai faraógshakam Israel aents aidauk shiyakaje tabaun dekauwai. Nunik niijai atueka takatai aidaujai awake anentaimag kajekag chichainak: “¿Wagka Israel aents aidau iina takagtamainak batsatush jiinag shiyaktinme tusaish timaji?” tuidau. ");
INSERT INTO agr_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Tusag, carro maaniaku wetai aidau umiktajum tusa faraón timatai, imatiksag umikajui, dutikawagmatai niina suntajin ijumjauwai. ");
INSERT INTO agr_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Dutika seiscientos carro dekas pegkeg aidaun yajuak, nuigtushkam egiptunmaya carro aidaunak ashí yajuakag nuwi maki makichik suntaja apuji aidau pekamiag shimutkajui. ");
INSERT INTO agr_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Tuke Pujuu faraógka shiig antakchau awagsauwai, dutikamu asa Israel aents aidauk Tuke Pujuun senchijijai jiinag shimuidaun dekainayatak pataetukajui. ");
INSERT INTO agr_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Nuninak ashí suntag aidauk, carronum, caballonum aatus pataetukag, nayantsanum uwet yaakat Pi-hahirot tikich yaakat Baal-zefonjai niinis awa nuwi aakmag batsamtatman amainaidau. ");
INSERT INTO agr_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Nuna wainkag, Israel aents aidauk shiig senchi ishamkajui, nuninak Tuke Pujuu ayamjutpakti tusag segaidau. ");
INSERT INTO agr_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Nuniayatak Moisésan chichajuinak: “¿Egipto nugkanmak ukumataig atsau asamtaig, imajui uwegshunum jinatnume tusamesh jiijatjamum? ¿Wagka jusha jutikagtame? ¿Wagka Egipto nugkanum pujajinish jiijatkimume? ");
INSERT INTO agr_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Juju aneasa Egipto batsamsa chichaaku: Idaikagtustajum waitiakuish egiptunmaya aidau takajuinaku batsamsagmi ¿tichamkaijim? ¿Nunisaik batsatkuik, imajui uwegshunum jinumainkaitag?” wajaidau. ");
INSERT INTO agr_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Imatiagtai Moisés ditan ayaak: “¡Ishamkagtutsuk anentaim ichichiagtajum! ¡Nuniakjum Tuke Pujuu iina ayamjutpak dutikatta nunú wainkatajum! Yamai atum egiptunmaya aidau wainjum duka ataktu awagkigmek wainkashtinaitjume. ");
INSERT INTO agr_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","¡Atumek uyumakaigpa, Tuke Pujuu iina ayamjutpak maaniattawai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Tusa tutai Tuke Pujuu Moisésan chichajak: “¿Wagka minash yainkata tusamesh segatme? ¡Anui wajasam mina segatú wajatsuk Israel aents aidauk weajum antsagmek wetajum tita! ");
INSERT INTO agr_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Tuja ¡ame ushujutaijum takakam nunú takuim nayantsanmanini awentata! Dutikawamin nayants jimaituk kanaka ejapeen buku wajastatui, nunikmatai Israel aents aidau bukunum katiagtinme. ");
INSERT INTO agr_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Wi egiptunmaya aidaunak antakchau ema ai pataetugmakagtatui. Nuninakui ashí nii suntaji, carroji, caballoji aidau minina nuna ijinkun mina senchijun iwainaktatjai. ");
INSERT INTO agr_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Nuna dutikamtai ¡egiptunmaya aents aidauk dekajuawagtatui dekas wi Apajuí Tuke Pujuu tutayaitag nuna!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Nuna tusa inagnaig, Apajuí ángel tumain nayaimpinmaya Israel aents aidau shimamunum yujagminum pachitkau eemak wegau ukuunum juwakui, nunitai yujagmishkam antsag ukuunum asauwai. ");
INSERT INTO agr_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Nunú yujagkim egiptunmaya suntag aidau shimamunum nuna emtin wajantui, nuniaig suwe wajasui, untsu Israel aents aidau shimamunmak yujagkim etsantug tsaaptin wajasui. Nuadui nunú kashi aajakua duik Israel aents aidaunak amaigkachaju ainawai. ");
INSERT INTO agr_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Nuninai Moisés niina uwejen nayantsanmanini awentauwai, dutikamtai etsa minitaiya nuwiyan Tuke Pujuu makichik kashi shiig senchi dasenmitkakui. Imatika umpuamu asa nayantsak jimaituk kanakui. Aatus Tuke Pujuu nayantsa ejapeen buku awagsauwai. ");
INSERT INTO agr_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Nunik nayants ejapeen buku wajasa, mai yantamenig yumik muja iman wajas ai, Israel aents aidauk utsanawag katiajajui. ");
INSERT INTO agr_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Nuniagtai faraógshakam niina suntaji aidaujai carro maanitai aidaunum, caballo maanitai aidaunum pekamiag, pataetukag nayants buku wajasbaunum utsanawag ejapeantajui. ");
INSERT INTO agr_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Tuja aents maanitan yacha aidau Israel aents aidaun pataetukag shimuidau. Nunik shimuinai tsawamunum Tuke Pujuu Israel aents shimamunum eemak yujagminum tuja jii kegamunum wejakua nunú egiptunmaya aidaun ayampatua diisui. Dutikam ishamainak utujimkag waugtuinak wechamin wajasajui. ");
INSERT INTO agr_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Tuja carro kagketaiji aidaushkam kushatuk ukuinidau. Nuniagtai juwimainchau dekapenak untsumaidau. Nuninak ditak pempeentunikiag chichainak: “¡Auk Tuke Pujuu Israel aents aidaun ayamjak jutijai maaniak jutijamui, dekas pisajagmi!”, tuidau. ");
INSERT INTO agr_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Tusa imatiagtai Tuke Pujuu Moisésan chichajak: “¡Uwejum nayantsanmanini awentata, dutikamin yumi waketak egiptunmaya aents aidaun, ditá carroji aidaun, caballoji aina nujai yutua ijinati!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Tama Moisés niina uwejen nayantsanmanini awentauwai. Dutika uwejen awentamtai, nayants ejapeen buku wajas auk, tsawak yaunchuk aajakbaunak imanisag piyag asauwai. Tuja egiptunmaya aents aidauk pisagtakama nayantsanmak egkemkajui. Aatus Tuke Pujuu egiptunmaya aidaunak nayantsanum aepá ijinauwai. ");
INSERT INTO agr_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nuadui nayants yaunchuk aajakbaunak imanisag weak faraón niina suntaji aidaujai carro aidaunum, caballo aidaunum, Israel aents aidaun pataetukag nayantsanum utsaadau aidaunak ashí yutua ijinauwai. ¡Tuja faraógkan suntaji aidaunmayag makichkikesh uwemjachui! ");
INSERT INTO agr_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Untsu Israel aents aidauk nayants buku wajasa, mai yantamen yumi muja iman wajas aunum ditá eemak, shiig katiajaju ainawai. ");
INSERT INTO agr_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Aatus Tuke Pujuu Israel aents aidaunak egiptunmaya aents waitkam batsatun ayamjuk uwemtikjauwai. Dutikamu asag nayantsa tugkitken yujakma egiptunmaya aents jinaun nayants tsukatak tugkitak anugkam batsatun wainkajui. ");
INSERT INTO agr_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Nuna Tuke Pujuu imatika niina senchijin egiptunmaya aidaun ijinamun wainkag, Tuke Pujuun eme anentus diidau. Nuadui ima Apajuíyaig kajinas anentaimainak, niina inake Moisésnashkam dutiksag kajitus anentaimtuidau. ");
INSERT INTO agr_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tuke Pujuu ayamjuka uwemtikjam, Moisés nii wegantu Israel aents aidaujai Niina emematuinak juna aatus kantamawajui: “Tuke Pujuun, eme anentsan kantamjuatjai, wagki niina senchijin ashí depetmak, shiwag caballojin entsatkau aidaun nayantsanum ijinau asamtai. ");
INSERT INTO agr_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Tuke Pujuu minak senchimtijawai, niyai mina ayamjumataijuk, nuadui wika niina kantamjajai. Niiyai dekas mina Apajuíjuk, nuadui shiig aneasan ememattatjai. Niiyai dekas mina apajun Apajuíji, nuadui wika tuke niina etsagjatnaitjai. ");
INSERT INTO agr_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Tuke Pujuuwa nunuwai dekas maanitan yachak. Niina daajig dekas Tuke Pujuu tutayai. ");
INSERT INTO agr_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“Faraógka carrojinak, ashí niina suntaji aidaujai, nuigtu suntaja apuji dekas yacha etegjamu aidaunashkam Tuke Pujuu nayantsanum aepá ijinae. ");
INSERT INTO agr_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nuadui ditak nayantsa kunajin shiig initak kayajai betek tepeawaje. ");
INSERT INTO agr_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Chah, Tuke Pujuuwah, amina senchigmijai iina shiwaajig ijinamume, ");
INSERT INTO agr_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Amina senchigmijai, shiwaajum aidauk depetnaitme. Iman asam ame kajekbaugmin chijichi kagaku apemaina numamtuk ijina emegkagmaume. ");
INSERT INTO agr_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ame dase awemamu nayantsan umpui jimaituk akankae. Dutikamu asa yaakat peejamua iman wajasmae. Nayantsa initkenish yumik buchittsuk asae. ");
INSERT INTO agr_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Iina shiwaaji anentaimas: ‘¡Pataetukagmi! Dutika amainagkaja ijinku wajiji yajutka tinamdaekagmi’ tiaje. ");
INSERT INTO agr_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tujash ame dase senchi dasenmikakam nayantsa ejapeen aepá emegkakmaume. Nuadui plomo ajugkam tepegama numamtuk tepeawagmae. ");
INSERT INTO agr_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“¡Chah, Tuke Pujuuwah! ¡Aents aidau apajuímtaiji aina duka kuashtai! ¿Tujash amejai betek amainush tikichish aintash? ¡Ima ameketme pegkejam muunmek! ¡Ameketme ashí senchigtinmek! ¡Ameketme wainchatai aidau ishamain iwainam ibaumek! ¡Ameketme ememattaimek! ");
INSERT INTO agr_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Amina senchijum iwainakume, dutikawamin nugka ujani egiptunmaya aidaunak kujag emegkaje. ");
INSERT INTO agr_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Amek amina aentsjum aidau shiig senchi aneau asam, amina senchigmin uwemtikjaume; nuadui amina senchigminig uyunkagtusam ekagtame nugka pegkeg anagkagtuawaitam nuwi jegatnume tusam. ");
INSERT INTO agr_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Juna aents tikich nugkanmaya aidau antukag senchi ishamainak kujainiagtatui; tuja filisteo aidaushkam sapigmainak najaimaku wajukmaina numamtuk tuni tunija iyainiagtatui. ");
INSERT INTO agr_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Tuja Edom nugkanmaya suntaja apuji aidauk, ishamkag wakan wajasagtatui. Tuja Moab nugka apuji aidaushkam ishamainak kujainiagtatui. Nuninai Canaán nugkanum batsamin aidaushkam ishamkag wainkauch dekapmamiagtinai. ");
INSERT INTO agr_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","¡Chah, Tuke Pujuuwah, aatus sapigmainak anentaimjatnume! Amina senchijum iwainam juna dekainak kaya buchitmainchauwa nunin wajastinme, nunikmatai amina aentsjum ame uwemtijamu aina juka ame nugka anagkuawaitam nuwi shiig utsaanatnume. ");
INSERT INTO agr_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","¡Chah, Tuke Pujuuwah, jukagtukim aminu atin muja etegkamua nuwi pujustinme tusam ejekagtuata! ¡Ame nuwi pujustinme tusam etegkauwaitme, tuja duka amina jem ame pujustin emtikam umikuitme! ");
INSERT INTO agr_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","¡Chah, Tuke Pujuuwah, amek yamaish, kashinish, ajumaya duish tuke inama pujutnaitme!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Faraógka carroji maanitai aidaunum, caballo maanitai aidaunum suntag aidau pekamiag nayants buku wajasmatai utsaanawag shimuidaun, Tuke Pujuu yumin awakeak yutua emegkajui. Tujash Israel aents aidauk bukunum shiig katiajajui. ");
INSERT INTO agr_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Nunikagmatai Tuke Pujuu chichamen etsegtin María, Aarógka umayi, panderetan juki awatak kantamtai, ashí nuwa aidauk ditashkam panderetan awaituinak nantsemaidau. ");
INSERT INTO agr_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Imaniagtai María ditajai ijunag kantamak: “¡Tuke Pujuu eme anentsajum kantamjuatajum, shiwag caballonum maanin aidau entsatkau minidaun nayantsanum aepá ijinak depetmaku asamtai!” waja wajas kantamu. ");
INSERT INTO agr_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moisés nii wegantu Israel aents aidaujai nayants kajis ain tutainum batsatu juwakiag, uwejush Shur tutainum kampatum tsawan yumi atsamunum shimu batsatu. ");
INSERT INTO agr_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Nunik shima shimakua yumi aunum jegawajui, tujash nunú yumik yapau asamtai uwagchajui. Nuadui nunú nugka daajinak “Mará” adaikajui. ");
INSERT INTO agr_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Nuadui Israel aents aidau, Moisésa kajejuk pegkegchaun chichajuinak: “¿Yamaish iish wajig uwagtaji?” tusa imatjuinau. ");
INSERT INTO agr_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Imatjuinam Moisés Tuke Pujuu yainkati tusa segauwai. Tusa segam, Tuke Pujuu Moisésan inaktusui numi uchuchiji wajaun. Nuna Moisés tsupik juki yuminum ajugkui, dutikam yumi sakam pegkeg wajasui. Tuja nunú nugkanum Tuke Pujuu ditan dekapsauwai, dutika nuadui dita chicham umikagtinun susauwai. ");
INSERT INTO agr_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Dutika chichajak: “¡Wi Tuke Pujuu atumi Apajuígmetag nunú tabau puyatjusa antukjum wi wakegamu takakjum, chicham umiktinun wi amasuitjim nunú betek umiakjuminig, egiptunmaya aidaun jata awetiuwaitag dutikanuk atumnak makichkish awetishtatjime! ¡Witjai Tuke Pujuu atumi etsagaumainnuk!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Tusa tiajam shimui shimuinakua Elim tutainum, doce yumi pukuni jiinu, nuigtu setenta palmera aidau ijununum jegawajui, nunikag pukuni jiinainamunum ayaumas aakmajag batsamsajui. ");
INSERT INTO agr_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Israel aents aidau Elimnum batsatu ashí jiinag juwakiag shima shimakua Elim muja Sinaíjai niniaku awa nuwi uwejush Sin tutainum jegawajui. Nunak egiptunmaya jiinjauwa duwi nagkamas makichik nantu asa jegawajui. ");
INSERT INTO agr_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Nunú uwegshunum Israel aents aidau Moisésan Aarógjai chichaman patatuidau. ");
INSERT INTO agr_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Tusa chichainak: “¡Atumek nujantai jinatnume tusajum juju muja juwi itajatuaugme! ¡Awi batsamsaik waitiakuish, neje ollanum bete painka inagkamu shiig yuwa ejemaja pujuyaji, dekas Egipto nugkanum pujajinig Tuke Pujuu ijipati tumainus tichayagtai!” wajaidau. ");
INSERT INTO agr_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Imatiagtai Tuke Pujuu Moisésan chichajak: “¡Dita yuwatnunak nayaimpinmayan yumijai betek wi yutumtijattajai! Dutika ai makichik tsawantai yuwatnujin juuktinme. Nuadui dekattajai yaki dekas wi dutikatajum taja nunash betekash umikat, tuja yaki umikchat nunashkam. ");
INSERT INTO agr_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Untsu tsawan seisa duwi yuwatin juwakjumek, jimag tsawantai yuwatin asamtai, makichik tsawantai yuwatin juuttajum aan kuashat juuktatjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Tusa tima Moisés Aarógjai Israel aents aidaun ujainak: “Yamai agkuantai dekattagme, atum Egipto nugkanum batsatutigmin Tuke Pujuu jiipagmaya nunú. ");
INSERT INTO agr_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Atum chicham patatjum nuna antugtamkaje. Nuadui kashin kashikmas niina imanjin iwaintugmaktata nunú wainkattagme. ¿Wagka atumesh jutiish augmatkagtagme? ¿Iikaitag atum atsumamu sumainti?” ");
INSERT INTO agr_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Tusa ataktu Moisés chichaak: “Atum yuwatnun Tuke Pujuu nejen ajum aagkú amastatui, untsu kashikmas pagkan shiig kuashat amastatui. Nunak dutikattawai atum chicham patatbaun antugtamkau asa. ¿Iish ya ainaji? Atum chicham patatkagtajum duka jutiik tukagtatsjume, Tuke Pujuu patatku tajume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Nuna tusa Moisés Aarógkan chichajak: “¡Israel aents aidau ashí ujakta Tuke Pujuu emtin ijunjatnume! Nunikag antuktinme dita chichaman pataina duwish, Tuke Pujuush wajintig”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Tusa tima Aarón Israel aents aidaun ijumag chichaak wajai, uwegshunmanini niimsatakama, yujagkim winchamtinnum Tuke Pujuu wantintatman wainkajui. ");
INSERT INTO agr_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Nunú yujagminmaya Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Israel aents aidau chichaman pataina nuna antukjai. Nuadui juju aajam dita aidau ujakta: ‘Ajum agkuantai neje yuwattagme. Untsu kashikmasjum pag shiig kuashat yuwattagme tujamui. Aatus dekawagtatui wi Apajuí Tuke Pujuu tutayaitag nuna’ tawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Tusa timatai nunú tsawantin agkuantai aakmaja batsatbaunum codorniz shiig kuashat kaunauwai. Nuniku ai kashikmas yumi sajatuk nugkan uchupkauwai. ");
INSERT INTO agr_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Nunú yumi sajatuk nagkaemakmatai jiinkiag diikma jegashik dukanum ekemag aama numamtin tujash katsujam, uwegshunum nenentu yaijuch aidau eketag weajun wainkajui. ");
INSERT INTO agr_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Nunikag nuna dekainachu asag tudayinak: “¿Jusha wajimpaya?” Tiagtai Moisés ditan ayaak: “Junak Tuke Pujuu pagkan yuwatnume tusa amasa nunuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Juna amaak aatus tujamjume: Maki makichikitijum wajupa yumainaitjume nunú betek jukitajum, tuja wajupa aents jeminish pujuinawa nunú dekaapajum maki makichik aentsdau ichinak jimag litro yajatainum aimkajum jukittagme tujamjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Tusa tima Israel aents aidauk dutiksag juukajui; tuja nii ima dukap juwai tikich ujumak juwaushkam asajui. ");
INSERT INTO agr_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Dutik jukitajum tibaunak betek jukiaju asagmatai kuashat jukiuwa nudaush ampinjachui, tuja ujumchik jukiushkam etagagchajui. Maki makichik dita wajupa yuwawagtatua nuna betek dekapa jukiajui. ");
INSERT INTO agr_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Dutikawagmatai Moisés ditan chichajak: “¡Makichkitigmekesh kashin yuwatnuk ampigjumek ukukigpajum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Tusa tibau aig Moisésnak antugtsuk, kashin yuwami tusa ampijag ukuidaushkam asajui, tujash duka aka pimutkam kauja mejedau. Nuna dutikawagmatai Moisés ditan kajegkauwai. ");
INSERT INTO agr_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Duwi nagkamas maki makichik dita yuwatnujin kashi kashinig yajumainau. Tuja etsa etsantak sukuam yumimea megkagu asamtai, kashikmas jiintujag yajumajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Untsu tsawan seistinig jimag ichinkanum aimak yajumainau. Dutikiagtai Israel aents aidaun apuji aidau Moisésan jegajuawag ujaidau. ");
INSERT INTO agr_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Tama Moisés ditan chichajak: “Aunak Tuke Pujuu dutikatnume tusa timae”, tiuwai. Nuna tusa: “Kashin tsawan ayamtai atinun, Tuke Pujuu etegkamu tsawagtin asamtai, inagmain akuig yamaik inagkatajum, tuja ukuumain akuishkam yamaik ukuukatajum. Untsu yumain ampinjatta duka kashin yuwatin ukuktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Aatus Moisés tibaunak imatiksag yutai ampinjaunak kashin yuwatnujin ukukiajui. Tujash nunak akakesh ikiachui, tuja mejetnakesh mejeachu. ");
INSERT INTO agr_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Nuadui Moisés ditan chichajak: “Atum yau ukukbaujum nunú yamai yuwatajum. Juju tsawanta juka Tuke Pujuu etegkamu ayamtai tsawaje. Nunin asamtai, ¡juju tsawanta juwi yutai agá ayauk wainkashtatjume! ");
INSERT INTO agr_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Nuadui ayatak seis tsawanta duwi atum yuwatnuk juuktatjume. Untsu tsawan ayamtai Tuke Pujuu etegkamua nunú tsawantinig yutai juwamuk atsuttawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Tusa tiu aig, tsawan ayamtai tsawagmataish jiinki egaidaush asajui, tujash makichkish wainkachajui. ");
INSERT INTO agr_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Nuniagtai Tuke Pujuu Moisésan chichajak: “Wi atumi jintinkun, juju umiktajum timajim dusha ¿wajupa chichagkama atumesh umiktatjume? ");
INSERT INTO agr_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Tsawan seistin yuwatnun kuashat amaajim nunak, tsawan sieteya duwi ayamsatin asagmin dutikajai. ¡Nunú tsawantinig makichkish jiintsuk ditá jenig batsamsagtatui!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Tibau asa Israel aents aidauk nunú tsawan jegatai ayamaidau. ");
INSERT INTO agr_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israel aents aidau yutai kakekaun juujaku aina duka shawi jigkayiya numamtin, niime puju; dapa yumiji pagjai pachimjamu yumimitu pegkejan kugkuwama iman aajakui. Nuna Israel aents aidau adaikau ainawai “maná”. ");
INSERT INTO agr_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Tuja duwi pujus Moisés tiuwai: “Tuke Pujuu juna aatus chichaak: ‘Atum Egipto nugkanum batsatutigmin wi jiija yajuakan uwegshunum yutain amasuitag nuna atak atumi uchijum akiinak wedaush wainkagtina nunú maná makichik ichinkanum aimkajum ukustajum’, tujamjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Nuna tusa Moisés Aarógkan chichajak: “Makichik ichinkanum maná aimkata, dutikam jega pegkegma nuwi awayam Tuke Pujuu emtin apusata, atak atumi uchijum wegantu agtina dusha wainkagtin atinme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Tuke Pujuu Moisésan tibaunak imatiksag Aarón maná ichinkanum chimpiamun juki, chicham umiktin agagbau arcanum egkeam aunum ejegan nujai niimtikas apusauwai. ");
INSERT INTO agr_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Israel aents aidauk ima manának yusag cuarenta mijan yujasui, ima nunak yusa yujasag jegawajui Canaán nugka nagkatkamunum. ");
INSERT INTO agr_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Israel aents aidau manán dekapainakug jimag litro dekapatai “gomer” tawa nujai dekapajaku ainawai. Tuja “efa” tawa nunú aajakui veinte litro dekapatai. ");
INSERT INTO agr_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Israel aents aidau uwejush Sin tutainum batsatu ashí jiinag diipas jintá kanui kanuinakua Tuke Pujuu chichamen antujus Refidim nugkanum jegawag aakmajag batsamsajui. Tujash yumi dita umumainuk atsujakui. ");
INSERT INTO agr_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Nuadui Moisésan jegajuawag chichajuinak: “¡Yumi sukagtusta uwajagmi!” tusa imatjuidau. Tusa imatjam Moisés ditan chichajak: “¿Wagka minash segatjume? ¿Wagka Tuke Pujuu senchigtuchua nunin chichagkugmesh ekajeagme?” tau. ");
INSERT INTO agr_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Tujash Israel aents aidauk senchi kitamaidau asag Moisésan kajejuk chichajuinak: “¿Wagka Egipto batsamsatnume tutsukesh jiijatjamiume? ¿Uchiji aidaujaí, tagkuji aidaujaí kitakai jinaati tusamek jiijatjamium?” wajaidau. ");
INSERT INTO agr_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Imatiagtai Moisés Tuke Pujuun segaak: “¿Utugkattaja juju aents imatjutuina nunash? ¡Jukea akug kayai tuku tukujuinakua mantuawagtatui!” tau. ");
INSERT INTO agr_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Tama Tuke Pujuu Moisésan ayaak: “Israel aents aidau ashí yajuaka weakum ditá apuji múun aina nunú ujumak jukim emka wetá. Nuniakum ame namak awatiuwaitam nunú ushujutaijum jukita. ");
INSERT INTO agr_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Tuja wika muja Horebnum kaya awa nuwi dakastatjame, nuwi taam ¡nunú kaya awatta! dutikamin yumi jiinkittawai. Nunikmatai ashí aents aidau uwagtinme”, tiuwai. Tusa tima Moisés Israel aentsu apuji múun aidau wainainamunum kayan awatiuwai. ");
INSERT INTO agr_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Tuja Israel aents aidau yumi atsutai Tuke Pujuu emtin kajekag Moisésan pegkegchaun chichagkaju asagmatai, nuna nugka daajin adaikauwai “Meribá”. Tuja nuigtushkam adaikauwai “Masá”. Nunak Israel aents aidau chichainak: ¿Dekas Tuke Pujuush jutijaish pujawash? tusag utujimkaju asagmatai tuu adaikauwai. ");
INSERT INTO agr_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Israel aents Refidim batsatun Amalec aents aidau ditajai maaniawagtatus shimutkajui. ");
INSERT INTO agr_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Nuniagtai Moisés Josuén chichajak: “¡Aents aidau etegjam Amalec aents aidaujai kashin maaniata! Nuniamin wi mujanum wakan ushujutain Apajuí sujusbauwa nuna takusan pujuttajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Tusa tima nuna betek umiak, Amalec aents aidaujai maaniatatus jiintukiuwai. Nuniai Moisés, Aarón, nuigtu Hur aatus muja titijin wakajui. ");
INSERT INTO agr_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Nuwi waka batsamas Moisés uwejen yakí takutai, Israel aents aidauk Amalec aents aidaun depetuidau, untsu uwejen awaktai, Amalec aents aidau Israel aents aidaun depetuinau. ");
INSERT INTO agr_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Moisés niina kuntuji yawetai awakeau asamtai, kaya jukiag apujtusam nuwi ekemsauwai. Nunikmatai Aarón, Hurjai Moisésa kuntujin mai takujiag emetjuawajui. Dutikam nunisag pujai, etsashkam akaikiuwai. ");
INSERT INTO agr_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Nuadui Josué niina aentsji aidaujai Amalec aents aidaun depetuk amukui. ");
INSERT INTO agr_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Dutikamtai Tuke Pujuu Moisésan chichajak: “¡Juju maaniamua juu pachisam papiinum agagta, ajumaish kajimatkishtin ati! Tuja Josué ujakta, Amalec aents aina nunak wi ashí ijinan emegkagtatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Tusa tima Moisés nuwi kaya yajuak ijumag altaran najana nuna daajin “Tuke Pujuu Nisi” adaikauwai. Nunak “Tuke Pujuuwai, bandera jiikbaujai betekmamtin depetmata sukagtinuk” taku tawai. ");
INSERT INTO agr_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Nuna tusa: “¡Tuke Pujuuwa nuna depetmataig jutiyai awai, nuadui Tuke Pujuu Amalec aents aidaunak ijinattawai, dutikak ditá uchiji wegantu aidaunashkam ijinatnai!” tiuwai Moisés. ");
INSERT INTO agr_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israel aents aidau Egipto nugkanum batsatu jiinjau aina duwi nagkamas, kampatum nantua nuna achiak, makichik tsawan tsawajua nunú tsawantin muja Sinaí nagkatkamu uwegshunum jegawajui. ");
INSERT INTO agr_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Tuja Sinaínum jegawajua nunak Refidim batsatu juwakiag jegawajui. Nunikag nuwi mujá ijus uwegshunum aakmajag batsamsajui. ");
INSERT INTO agr_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Nuwi pujus Moisés Apajuíjai chichastatus mujanum wakauwai. Nunikmatai Tuke Pujuu nunú mujanmaya Moisésan untsuka chichajak: “Jacob tikich daaji Israel aajakua nuna uchiji wegantu Israel aents aina nunú ujakta: ");
INSERT INTO agr_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Egiptunmaya aents aidaun wi itugkauwaitja duka atumek shiig wainkauwaitjume. Tuja wi atumin, ukukui niina nanapen uchiji aidaun pataja yajumaina numamtuk kuitamkan wi pujag juwi ikaunmajim dushakam shiig dekagme. ");
INSERT INTO agr_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","“Tuja ashí nugka aina duka ashí aents aina nujai midau ainawai. Nunin aig wi atumin mina aentsug atinme tusan etegkauwaitjime. Nuadui wi chichaman tajim nunú antukjum umiakjumek atum dekas atatjume mina aentsug tikich aents aina nuna nagkaesau. ");
INSERT INTO agr_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Atum Israel aents aidautigmek dekas sacerdote aidau ima wi wakegamunak takagtin aina nujai betek ima wi wakegamuk takau atatjume. Juna wi taja juju Israel aents aidau ujakta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Tusa tima Moisés wakitki jegaa, Israel aentsu apuji múun aidaun untsuka, ijumag ashí dita antuinamunum Tuke Pujuu tita tibaunak betek etsegkauwai. ");
INSERT INTO agr_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Tusa timatai dita shiyakag Israel aents aidau batsatun ujakajui. Dutikawajam ashí betek aimainak: “¡Tuke Pujuu tujama duka ashí umikagmi!” tuidau. Tusa tiagmatai Moisés nuna dutiksag Tuke Pujuun ujakui. ");
INSERT INTO agr_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Tusa ujakam Tuke Pujuu Moisésan chichajak: “Nijah, wi amejai chichamun aents aidau antukag, dekaskeap tawa tusag, tuké antugtamin atinme tau asan, yujagminum pachiinkan wantintuktatjame”, tiuwai. Tusa timatai, Moisés Israel aents aidau tibaunak imatiksag ataktu awagki Tuke Pujuun ujakui. ");
INSERT INTO agr_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Tusa ujakam Tuke Pujuu Moisésan chichajak: “¡Wakitki jegaam aents aidau ujakta! Yamai, tuja kashinchakam ashí shiig umintsatnume, mina emematjiagtin asag. Nuninak jáanchjin nijaktinme, ");
INSERT INTO agr_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","nunikag shiig uminas batsatai, tsawan kampatuma duwi aents aidau ashí waituinamunum muja Sinaínum akaikittajai. ");
INSERT INTO agr_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","“Nuniktin asamtai, aents aidau muja adijkainum dita ijuntsatin mamiktuata: ‘¡Mujanmak wakaigpajum, tuja nuigtush mamikiamua nuwig nagkaemakigpajum! ¡Antiitkesh antigkaigpajum! Nuna antiauk jakattawai’, tita. ");
INSERT INTO agr_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Untsu makichik aentskesh, tuja kuntinkesh nuna dajagtata duka achikaigpajum ayatak kayai tukua tukuakuajum maatajum. Untsu dutikachkugmesh nagkiikesh maatajum. Duka kuntin akush, aents akush tuké dutika maam atatui. Untsu uwija kachuji senchi umpuamun antuinak mujanmak wamain ainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Tusa tima Moisés nunú mujanmaya wakitki, Israel aents aidau batsatbaunum taa chichaak: “¡Umintsatajum Apajuí emematiagmi!” tusa tiajam, ditashkam shiig umintsajui. ");
INSERT INTO agr_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Nunikagmatai Moisés ditan chichajak: “¡Kashin pujus tsawak Tuke Pujuu wantintugmaktin asamtai, nuwemjaig tsanitsuk umintsajum dakamsatajum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Tusa tiyajam, dakamainak batsatai, tsawan kampatuma nunú tsawamunum kashikmas ipamat ishamain wajau, imaniak peemshakam senchi peetu. Imaniamunum nunú mujanum yujagkim suwe wajas aunum, uwija kachuji umpuamu shiig senchi shinaun antukag, Israel aents aidau aaknum batsatuk shiig senchi ishamak kujainau. ");
INSERT INTO agr_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Imaniagtai Moisés ditá aakjin batsatun jiija yajuak Apajuíjai igkumtikatatus muja najatamunum ijumjauwai. ");
INSERT INTO agr_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Nuninai nunú mujanum jii kegaunum pachitkau Tuke Pujuu akaikiuwai. Nunikmatai muja Sinaík ashí bukuitau. Nuadui nunú mujak aja apeam esaak bukuituwama imaniau. Imaniai nunú mujak shiig senchi uuju. ");
INSERT INTO agr_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Tuja uwija kachuji shinamushkam Apajuí mujanum taattak minitai nuni senchi shinau. Tuja Moisés aujam, Apajuí ayaamuk ipamat wajukeama imatu. ");
INSERT INTO agr_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Aatus Tuke Pujuu nayaimpinmaya muja Sinaí titijin yaki tauwai. Nunik taa Moisésan wakata tusa untsukui. Tusa untsukam Moisés wakauwai. ");
INSERT INTO agr_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Nunikmatai Tuke Pujuu chichajak: “¡Wakitkita, nunikam aents aidau ujakta dita ijuntsatin mamiktuamua nuna nagkaiki mina diigsatatus wakainmegka! Nuna nunidauk jakagtatui. ");
INSERT INTO agr_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","¡Tuja sacerdote minai tamain aina dukesh junisagkek tantainmeka, dekatkauk pegkeetnume! Nuninachkug ditashkam jinumain ainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Tusa tutai Moisés Tuke Pujuun ayaak: “Aents aidauk juju muja juwig wakachagtatui. Wagki juju muja duka aminu pegkejam asamtai, nuwi aents aidau wakainum tusam, dita ijuntsatin muja najatamunum mamiktuata timaum duka betek uminkae”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Tutai Tuke Pujuu Moisésan chichajak: “Wakitkim jegata. Nunikam Aarógjai wakata. Untsu sacerdote aina duka Israel aidaujaig nugka mamiktuamua nuna nagkaikiajag wi pujag juwig makichkish wakainmegka. Nuna nuninakug wi ¡suwimka susa ai jinawagtatui!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Tusa tima Moisés wakitki jegaa Tuke Pujuu tibaunak imatiksag Israel aents aidaun ujakui. ");
INSERT INTO agr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Apajuí chichaak juna aatus ashí tiuwai: ");
INSERT INTO agr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Witjai Tuke Pujuu atumi Apajuígminuk. Wi atumnak Egipto nugkanum inaku waitkatai batsatutigmin jiijuitjime. ");
INSERT INTO agr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Tikich aina duka makichkish apajuímawaigpajum. ");
INSERT INTO agr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Tuja yakiya, nugkaya, namaka initkenia aina duka makichkish dakumka najanagmek emematigpa. ");
INSERT INTO agr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","“Nunú aidau eme anentsajum Apajuíjai betek anentaimtu yujaigpajum. Witjai Tuke Pujuu Apajuí atum emematin ainajum duka. Wika Apajuí akasmauwaitjai. Nuniau asan aents aidau mina dakitjuinak pegkegchaun takaina nuna suwimka suwakun, nuna uchiji aidaunash, tijaji aidaunash, ama tijaji aina imanuiyanash suwimkan suwaitjai. ");
INSERT INTO agr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Tujash mina anentuinak, chichamjun betek umigtuidaunak ashí niina uchiji wegantu agtina nujai shiig anentsan tuké kuitamnaitjai. ");
INSERT INTO agr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“¡Tuja Tuke Pujuu atumi ememattaijum Apajuíya nuna daaji wainka adaya yujaigpa! Nuna núnidaunak Apajuík suwimka sutsukek idaisashtinai. ");
INSERT INTO agr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“¡Tsawan ayamtai Apajuí etegkamua nunú kajimatkitin aigpajum! ");
INSERT INTO agr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Takamain aina duka seis tsawanta duwi ashí takastajum. ");
INSERT INTO agr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Untsu tsawan sieteya duka Tuke Pujuuu, amina Apajuíjum etegkamu asamtai amina uchigmekesh, nawanjumkesh, tuja wainka inataijum aidaukesh, tagkugmekesh, tikich nugkanmaya ijagtamak taa pujaukesh, takatnak takaschagtatui. ");
INSERT INTO agr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Wagki Tuke Pujuu Apajuík seis tsawantai nayaimpin, nugkan, nayantsan tuja ashí nuwi ayá nujai najankauwai. Dutika tsawan sieteya duwi ayamjauwai. Nuadui nunú tsawanta nunak tuke ayamtai atinun Tuke Pujuu etegkauwai. ");
INSERT INTO agr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Amina apa, dukujai eme anentsam diita. Dutikakum yaigta. Nunú dutikakum Tuke Pujuu Apajuí amina nugkan amastata nuwi jegagmesh, dukap tsawan pujusminjum. ");
INSERT INTO agr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“¡Magkagtuawaipa! ");
INSERT INTO agr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“¡Ikagmakaipa! ");
INSERT INTO agr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“¡Kasamkaipa! ");
INSERT INTO agr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“¡Tikich aentsush wainka tsanumjujaipa! ");
INSERT INTO agr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Tikichi jee wakejusam diisaipa. Tuja niina nuwegkesh, nuwa wainka inataijigkesh, aishmag aidaukesh, nuigtu tagkuji baka, burro aidaush, tuja ashí tikich niinu aidau wajig ayawa dukesh wakejusmek diisaipa”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nuna aatus Apajuí chichai ipamat, peem, chaajip, nuigtu bukuitak mujanak ejakui. Nuna ashí Israel aents aidauk wainkajui. Tuja uwija kachuji shinaunashkam antuidau. Nuna ishamainak ikaa ijunas dii ijunu. ");
INSERT INTO agr_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Nuninak Moisésan chichajuinak: “Ame dekas Apajuíjai chichasam ujajatkata. Nunú antuka umikagmi. Untsu Apajuík jutijaig ataktu awagkig chichasaigka, jinawaig taji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Tiagtai Moisés ditan ayaak: “¡Ishamkaigpa! Apajuí junak niina senchijin atumi iwaintugmak juniawai. Juna wainkag ataktuk tudaunak takaschatnume tujamu asa”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Tusa tiajam nuwi ikaa ijunaig yujagkim bukusea wajas aunum Moisés jegantui Apajuí pujamunum. ");
INSERT INTO agr_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Nunikmatai Tuke Pujuu Moisésan chichajak: “Israel aents aidau ujakta: ‘Yamaik wi nayaimpinum pujusan ditan aujag nuna antukaje, ");
INSERT INTO agr_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","nuniku asag ¡mina emematjumaina numamtukek oro, plata aina nujai dakumak najanawajag emematinmeka! ");
INSERT INTO agr_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","¡Mina emematjuinakug, nugka ijumjag kuntinu maawag nuna nejen nuwi patai ashí apeenak emematjitnume! Tuja dita tsagkugnagbaunum anentag itainakush tuja uwig, baka aidaun apeenakush wi tuwi dutikatajum titatja ima nuwig dutikatnume. Nuna betek uminakuig wishakam pegkegnum yumigsagtatjai. ");
INSERT INTO agr_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","“ ‘Tuja kuntin patai apeatnun kayan ijumainakush jimaituk dakatsuk takamchaun ijumjatnume. Untsu kayan jimaituk dakainakug chichaman intimainak dutikawagtatui. ");
INSERT INTO agr_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Tuja mina emematjaku kuntin maa patai apeatin najanamua nuwi najami watai atinuk najanawaigpa. ¡Wagki nuwi waaku wisu weagmin waipakainum!’ tawai Tuke Pujuu”, tiuwai Moisés. ");
INSERT INTO agr_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Tuke Pujuu Moisésan chichajak: “Ame, Aarón, Nadab, Abiú, nuigtu Israel aents aidaun apuji múun aidau setenta aatsajum wi pujamunum wakatajum. ¡Nunikjumesh ikaag tikishmagjum pujustajum! ");
INSERT INTO agr_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Untsu ima amek mina adijtuktatme. Tikich aidauk adijtukainmegka. ¡Tuja tikich aents aidau wakeen ijuna duka makichkish amejaig wakainmegka!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Tusa tima Moisés aents aidaun Tuke Pujuu nuniktajum tibaun ujakui. Tama aents aidau ashí pampajag: “¡Duka dutiksaik umigkagmi!” tiajui. ");
INSERT INTO agr_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Tusa tiagmatai Moisés Tuke Pujuu chichamunak ashí agajui. Dutika kashin tsawamunum kashikmas nantaki kuntin maa patasa apeaku Apajuí ememattinun altaran najanauwai. Dutika doce kayan yajuak, Jacopa uchiji doce aajakua dutiksag batsakui. ");
INSERT INTO agr_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Nuna dutika Tuke Pujuu ditan ayamjuk agkanmitkamunum toro tsakatan maa ashí apeawagtinun, nuigtu tudau tsagkugtugti tusa toro tsakat aidaun maawag nuna nejen ujumak apeawagtinun Israel aents datsauch aidaun ujumak etegjauwai. ");
INSERT INTO agr_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Nuna numpen jimaituk akanak Moisés juki tsapa aidaunum yajakui, dutika tikich jimaitukea nunak kuntin patai apetai najanamun ukatkauwai. ");
INSERT INTO agr_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Dutika idayak chicham umiktin agagbaun juki, ashí Israel aents aidau antuinamunum ausauwai. Dutikamtai dita aimainak: “¡Tuke Pujuu dutikatajum tujama duka ashí imatiksaik umikagmi!” tuidau. ");
INSERT INTO agr_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Tusa tiagmatai Moisés numpa juki aents aidau ijunbaunum pegashmak: “Juju numpa juka Apajuí atumjai chichaman umika duka dekaske taku jutikaji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Nuna tusa Moisés, Aarón, Nadab, Abiú, nuigtu setenta Israel aents aidaun apuji múun aidaujai mujanum wakauwai. ");
INSERT INTO agr_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Nunikag nuwi Israel aents aidau Apajuíji: Nawe najama wajamujig kaya safiro tutai wigkaya imadai ukatkamunmas winchamtinnum wajatai tumain nayaim wigkaya iman wajas atatman wainkajui. ");
INSERT INTO agr_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Tuja Apajuík nunú apu aidaunak waitkatnume tiu asamtai wainkajui. Dutika wainkamash ditanak ijinachajui. Aatus niina emtin yutain yuwawag, umutnash uwajajui. ");
INSERT INTO agr_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Nunikagmatai Tuke Pujuu Moisésan chichajak: “¡Mujanum wi pujamunum wakam dakagsata, nuniamin kayanum chicham umiktinun wi atumin jintintuatasan agajag nuna amastajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Tusa tima Moisés niina yain Josuéjai mujá weuwai. ");
INSERT INTO agr_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Nunik weak Israel aentsu apuji múun aidaun chichajak: “¡Juwi atumek dakamsatajum nuniagmin tattaji! Tuja Aarón, Hurjai, atumjaig pujuttawai. ¡Utugchat ajutjamkujaish dita ujaktajum!” tau. ");
INSERT INTO agr_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Nuna tusa ukuak Moisésak mujanum wakauwai, nuniai yujagkim mujan ijiauwai. ");
INSERT INTO agr_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Tuke Pujuu imanji Sinaínum tauwai. Nunikmatai seis tsawanta imajin yujagkim ijia asauwai. Nunú yujagminmaya tsawan sieteya duwi Tuke Pujuu Moisésan untsukui. ");
INSERT INTO agr_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Tuke Pujuu imanji wantinbau Israel aents aidau diismak yakí mujá titijin jii kegak wajukeama iman aajakui. ");
INSERT INTO agr_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Nunú yujagkim suwe wajas aunum Moisés waigkui. Nunik nunú mujanum cuarenta tsawan, nuigtu cuarenta kashi pujusui. ");
INSERT INTO agr_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Tuke Pujuu Moisésjai muja Sinaínum chichasa ashimak, jimag kaya pakama najanamunum chicham umiktinun, nii agatug susauwai. ");
INSERT INTO agr_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Moisés muja Sinaínum wee megkaekamtai, Israel aents aidau ijunag Aarógkan chichajuinak: “¡Moisés jutiinak Egipto nugkanum batsatjin jiipajui! ¡Tujash dusha wajukaes, megkaetumkae! Nuniku asamtai dekas ¡ame ii apajuímatin najanata, nunú iina uyuntamsamtai shiyakagmi!” tuidau. ");
INSERT INTO agr_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Tusa tiagtai Aarón ditan ayaak: “¡Takugmek atumi nuwemdau, uchigminu, nawanjumdau akiitaiji oro aina nunú ukuitjajum juwi itatajum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Tusa tiajam oro najanamu ditá kuishin nenau aidauk yajuakag Aarógkan ejetuawajui. ");
INSERT INTO agr_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Dutikawagmatai Aarón nuna yajuak ukuiyag, toro tsakatan dakumak najanauwai. Dutikamtai dita chichainak: “¡Egipto nugkanum inaku waitkatai batsatjin Apajuí jiipakiuwa duka jujuwai!” tuidau. ");
INSERT INTO agr_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Nuna Aarón antuk, toro tsakat dakumka najana apusamunum, nuna yantamen ayaunas altaran najanauwai. Dutika senchi untsumak chichaak: “Kashin ijunja Tuke Pujuu emematuinaku jiistamawagtatji”, tau. ");
INSERT INTO agr_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Tusa tiu asamtai tsawainak kashikmas nantajag Apajuí agkanmitkagmauwai tusag nuna anentag suwinak kuntinun maidau, tuja tudau tsagkugnagtin tusashkam kuntinun maidau. Nuna dutikawag yujumkan yuwawag, umutan umuinak nantsemaidau. ");
INSERT INTO agr_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Nuniagtai Tuke Pujuu Moisésan chichajak: “¡Mujá pujam duka wakitkita, amina aentsjum aidau Egipto nugkanum batsatu jiigmayum duka pegkegchaun takainak wi dutikatajum tibaunak uminatsui! ");
INSERT INTO agr_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","¡Wi umigtuktajum tibaunak shiig wamak kajimatkiaje! Nuninak oro ukuijag toro tsakatan dakumak najanawag nuna emematuinak kuntinu maa apenawai. Dutikainak: “ ‘¡Egipto nugkanum inaku waitkatai batsatjin Apajuí jiipakiuwa duka jujuwai!’ tuinawai”, tau. ");
INSERT INTO agr_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Tusa Tuke Pujuu ataktu Moisésan chichajak: “Wi ditanak diyakjai, nuniau asan dekajai ditak dekas shiig antakchau ainawai. ");
INSERT INTO agr_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","¡Nuadui amek makichkish ayamjukaipa! ¡Wika shiig senchi kajekjai, nuniku asan ditanak ashí ijinattajai! Tujash ame wegantu aidaunak shiig kuashat ikauntuktatjame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Tusa tima Moisés Apajuí tsagkugti tusa chichajak: “¡Tuke Pujuu mina Apajuíjuh! ¡Imanikmek kajekaipa! Ameku amina senchigmin amina aentsjum aidau Egipto batsatu jiigmayume. ");
INSERT INTO agr_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Nuadui ame dutikawaminig egiptunmaya aents aidau chichagtamainak: ‘¡Apajuí ditanak tsanuja yajuak, mujá uyujus ijina emegkajui!’ tusa dushiktamain ainawai. Nuadui dekas ¡kajegkau akumesh tsagkujata! ");
INSERT INTO agr_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Amina inakem aidau Abraham, Isaac, Jacob aajaku aina nujai ame umiktinjum chichaakum: ‘Atumi uchijum wegantu aidaunak shiig kuashat ikauntukan, yaya nayaimpinum ayá iman awajsatnaitjai tusam, ¡juju nugka junak atumi uchijum wegantu agtina nudau tuke atinun amastatjime!’ tiuwaitam nunú adeagta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Tusa tima, Tuke Pujuu ditan kajejuk ijinatjai tiuwaitak, anentain yapajia dutikachui. ");
INSERT INTO agr_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Nunikmatai Moisés mujá pujau waketak, jimag kaya pakama najanamunum chicham umiktin mai yantamen agagbaun juki ejegauwai. ");
INSERT INTO agr_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Nunú kayanak Apajuí najanauwai, tuja nunú kayanum chicham agagbau aajakua nunashkam Apajuík agajui. ");
INSERT INTO agr_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Nunú chicham agagbaun jukimtai wakitkiag shimukma, aents aidau pampaidaun Josué antuk Moisésan chichajak: “¡Aents aidau batsata nuwimpash maaniamunum pampainak wajukeama imatuinani antajai!” tau. ");
INSERT INTO agr_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Tutai Moisés ayaak: “Nunak depetmakbaunum shiig aneenakugkesh imatainatsui. Tuja nuniachkush tikich depetkam wake besemag dekapenakugkesh imatainatsui, ¡auk nunak nampeja batsamas imat batsatui!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Imatu batsatai Moisés jegakma aents aidau nantsemainak batsatun wainkauwai. Nunik diikma toro tsakat dakumka najanamu atatman wainak, senchi kajeka chicham umiktin kayanum agagbau takakbaunak nagkima ajuag tsaikui. ");
INSERT INTO agr_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Nuna dutika toro tsakat dakumka najanamun juwakug nagkima jii kegamunum jiya tsaika yukukuntu ema yuminum chimpia pachimag, Israel aents aidaun chichajak: “Yamai juju uwagtajum” tusa aakui. ");
INSERT INTO agr_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Nuna dutika Aarógkan chichajak: “¿Juju aents aidaush itugtamkau asamtaiya, amesh ibau pegkegchau takamtikakmesh tunamitkame?” tau. ");
INSERT INTO agr_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Tutai Aarón ayaak: “¡Apujuh, minak kajegtukaipa, amek shiig dekame, juju aents aina juka ayatak pegkegchau takatnak wakeyin ainawai! ");
INSERT INTO agr_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Minak dita chichagtuinak jutii aidauti Egipto nugkanum batsatjin Moisés jiipagmaya duka wajukaes megkaekae. Nuniku asamtai, ii shimajin uyuuntamsatin makichik apajuímtai najatkagtuata tujutuinakui, ");
INSERT INTO agr_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","wi ditá ayaakun: ‘Akiitaiji oro ajamu aidauk ikaunmatnume’ ti ai, ikaunmawagmatai wi jinum jiyamjai. Dutika ai juju toro tsakat najaneame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Tuja Israel aents aidauk Aarón kuitamkacham batsamas pegkegchaun takainak, wainak yujaidau asamtai, ditá shiwaaji aidau dushikiam amainun Moisés anentaimas diisui. ");
INSERT INTO agr_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Nunik aakmaja yaaktamamunum waitainum Moisés wajas chichaak: “¡Tuke Pujuun dekaskeapi tuidauk wijai ijunjatnume!” tiuwai. Tusa timatai Leví wegantu aidau Moisésjai ashí ijunjajui. ");
INSERT INTO agr_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Nunikagmatai Moisés ditan chichajak: “Tuke Pujuu Israel aents aidaun Apajuíjiya nunú juna aatus chichaak: ‘Maki makichik puyagjin jukiag aents aidau batsata nuna shimutuk maki makichik jegan utuawag ashí aents pegkegchaun takamsau aina nuna dita yachi aidaunum nagkamas kumpaji aidaun, tuja ditajai ijunag pujuidaun aatus kajegtinme’ tujamui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Tusa tiajam Leví wegantu aidauk Moisés dutikatajum tibaun umiinak nunú tsawanta duwi tres mil aentsun ijinawajui. ");
INSERT INTO agr_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Dutikawagmatai Moisés chichaak: “¡Yamai atumnak Tuke Pujuu pegkegnum yumigtamsag chichame antugtai etamiugme! Wagki atumek Tuke Pujuu umiju asajum atumi yatsum aidau, uchijum aidau pegkegchaun takaidau ijinau asajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Tuja kashinia duwi Moisés aents aidaun chichajak: “Atumek shiig pegkegchau takasugme. Nuadui wi yamai mujá wetatjai Tuke Pujuu pujamunum, niish tsagkugtamainashit nuna dekaatag tusan”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Nuna tusa ukuak, Moisésak mujá Tuke Pujuu pujamunum wakitkiuwai. Nunik waka Tuke Pujuun chichajak: “¡Israel aents aidauk Apajuí tusag oron najanawag batsamtuidau asag dekaskenum shiig pegkegchaun takamsaje! ");
INSERT INTO agr_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","¡Wait aneasam ditá tudauji tsagkujata! tusan wi segajame. Tuja tsagkugmaichakmek, mina daag amina aentsjum aidaun daaji agatkamua nuwi agatjujuitam duka esakatjugta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Tusa tutai Tuke Pujuu ayaak: “¡Wika ima mina chichamjun intimjutuina nuna daaji aidaunak esakatjattajai! ");
INSERT INTO agr_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","¡Tuja amek wakitkim Israel aents aidau yajuakam wi nugka amastajime tusan anagkuawaitjim nuwi wetá! Mina aentsug nayaimpinmaya uyuuntamsattawai. Tujash tsawan dita suwimak jukitnuji jegakui, duwi suwimkanak susattajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Tuja Aarón toro tsakatan dakumak najanamun Israel aents aidau emamatiaju asagmatai, Apajuí suwimka suwak jata ishamainun ajunjauwai. ");
INSERT INTO agr_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Tuke Pujuu Moisésan chichajak: “Abrahaman, Isaakan, Jacopan uchiji wegantu aidaun nugka susatnaitjai tusan wi tiuwaitag nuwi Israel aents aidau Egipto nugkanum batsatu ame jiigmayum nunú yajuakam wetá. ");
INSERT INTO agr_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Amina uyuntamsatnun mina aentsug nayaimpinmayan awemattajai. Tuja Canaán aents, amorreo aents, hitita aents, ferezeo aents, heveo aents, Jebús aents aidau Canaán nugkanum batsata nunak jiijan utsagtatjai. ");
INSERT INTO agr_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","¡Nuadui nugka pegkeg, ajakash shiig tsapaun amastatjim nuwi atumek wetajum! “Tujash wika atumnak uyuntsashtatjime wagki intimkiu ainajum duwi. Nuadui kuitamamkatajum jintá weagmin shiwag amupakainum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Tusa Tuke Pujuu timatai nuna antukag, Israel aents aidauk wake besemag dekapenak iwagmamku patakumtai aidaunak patakumachaju ainawai. Tuja nugkutaiji aidaunash nugkugchaju ainawai. ");
INSERT INTO agr_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Tuja Tuke Pujuu Moisésan chichajak: “Israel aents aidau juju ujakta: Atumek antakchau ainagme. Nunin asagmin wi atumjai ijutkau pujaknuk wamak ijinan utsaumainaitjime. Nuadui atum iwagmamku nugkutaijum, patakumtai aidaujai ajutjamaina duka yamaikiuch yajuaka ukuktajum. Dutikawagmin anentaimsatjai atumnash itugkatjimki nuna”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Tusa tiajam ashí awimag ukukiaju asag, muja Horebnum nagkamas iwagmamku nugkutai aidaunak ataktuk nugkugchaju ainawai. ");
INSERT INTO agr_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Apajuí tibaun umiak Moisés carpan juki aents batsatbaun ukuki imau agkan Apajuíjai chichastasa waitain aakmakui. Dutika nuna adaikauwai “Apajuíjai igkunika chichatai”. Tuja makichik aents Tuke Pujuujai chichastatus wakegauk, nuwi waya Tuke Pujuun aujujakui. ");
INSERT INTO agr_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Nunú aaknum Moisés Apajuíjai chichastatus wetai, ashí aents aidauk maki makichik ditá aakji waitinum ijunas dii ijunaig, nunú aaknum Moisés waijakui. ");
INSERT INTO agr_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Nunik wayamtai Tuke Pujuu niijai chichai yujagkim yakiya aaka waitijin wajantun au. ");
INSERT INTO agr_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Nuna aents aidau wainainak, maki makichik dita Apajuín wajuk emamatin ainawa nunisag ditá aakjin waitinum tikishmajag pujujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Tuja nunú carpa aakmakbaunum Moisés wayamtai, Tuke Pujuu Moisésjai igkunia niina kumpajijai chichamaina imanis chichau. Nunik chichasmatai, Moisés Israel aents aidau batsatbaunum waketujakui. Untsu Nun aajakua nuna uchiji Josué Moisésa yain aajakua duka nunú aakan kuitamak jiintsuk nuwig pujujakui. ");
INSERT INTO agr_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moisés Tuke Pujuun chichajak: “Ame minak juju aents aina juju yajuakam emata tujutme. Tujutiatkum yaki minash atutkati duka eke tujuttsume. Nuniayatkum: ‘Aneajame, nuniau asan kajittsan anentaimtajame’ tujutmayume. ");
INSERT INTO agr_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nunú dekasketkuig wajina dutikatjai tusamea anentaime nunú ujatkata, wisha nuna dekaan dekas yaimpaktatuapi titajai. Ame etegkagtujuitme mina aentsug atinme tusam. Nuadui idaikagtutsuk uyunkagtusta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Tusa tama Tuke Pujuu ayaak: “¡Wi aminak uyuntsattagme, dutikakun agkan uyumat aneakas pujusti tusan kuitamkattagme!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Tusa tama Moisés ayaak: “¡Ame uyunkagtuschatnaitkumek, wetajum tusamek tukagtipa! ");
INSERT INTO agr_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","¿Ame uyunkagtushtaish itusag tikich aents aidaush amina aentsjum aina nunash tuja minash dekas Apajuíyap kuitamua tusash tujamtinme? Ame uyunkagtau asamin, tikich aents aidau diismash dita nagkaesau agtatji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Tusa tutai Tuke Pujuu Moisésan ayaak: “¡Aminak kajittsa anentaimtau asan, ame segatam nunak umiktatjai, tuja aminak shiig anentsan diyagme!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Tusa tama Moisés niina chichajak: “¡Untsu takumek dekas tikijuch paan wantintugkata!” tusa segauwai. ");
INSERT INTO agr_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Tutai Tuke Pujuu niina ayaak: “Wi ame wajamunum nagkaemaktatjai, nuniakui ame mina pegkegmajua nunú wainkamnum tusan. Nuniakun mina daag Tuke Pujuuwa nuna ujaktatjame. Wika yana wait anentasa wakegaja, nuna wait anennaitjai. ");
INSERT INTO agr_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","¡Tujash amek mina niimjuk wainkashtatme, mina waitkauk makichkish iwakuk pujumaitsui!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Tusa nuigtushkam chichaak: “Nijah, minai ayaumas buchig awa juwi wajaim wajasta. ");
INSERT INTO agr_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Nuniamin wi aminí ayaumsan nagkaemakun aminak buchig waanum egkeattagme. Dutikakun mina uwejui jiimin ejatkan nagkaemaktatjai. ");
INSERT INTO agr_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Nunikan mina uwejun jukittajai, dutikamtai ima mina tuntupjuk wainkattame. Tujash mina niimjuk wainkashtatme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Tuke Pujuu Moisésan chichajak: “¡Jimag kaya tsupikam yaunchuk aajakua nujai betek pakama najanata! Dutikawamin nuwi chicham umiktin yama nagkamchaku agagbau ame ajiaja tsaikmayum nujai betekan ataktu agagtajai. ");
INSERT INTO agr_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Tuja nuigtushkam ¡kashin kashikmasam muja Sinaínum wakatin asam umintsata! ¡Nuwi wakam dekas muja titijin mina emtijui tantata! ");
INSERT INTO agr_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Untsu makichik aentskesh mujanmak amejaig wakaigka, tuja juju muja juwi wekaguk makichkish wainnakchati, nuigtush uwig aidau, baka aidau chijichin yuwak wekagush atsuti”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Tusa tima Moisés jimag kayan tsupik yaunchuk aajakua nujai betek pakama najanauwai. Dutika najana kashinia duwi kashikmas Tuke Pujuu tibaun umiak nuna juki muja Sinaínum wakauwai. ");
INSERT INTO agr_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Nunikmatai Tuke Pujuu yujagminum pachitkau akaikiuwai, nunik nuwi Moisésjai pujus niina daajin Tuke Pujuu tutaiya nuna ujakui. ");
INSERT INTO agr_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Nunika Moisés wajamunum nagkaemak senchi jiika chichaak: “¡Witjai Apajuí TUKE PUJUU tutain, wika kakagchauch, wait anenkagtin, wamak kajechu, anenkaji múun, dekaskenum chichauwaitjai! ");
INSERT INTO agr_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Mina anenkajuk yaunchuk auwa nunisag tuke atinai, nuadui aents aidau mina dakitjuinak pegkegchaun takainak, wijai shiwagmagainakuish, tsagkugkagtinaitjai. ¡Dutikayatkun dita pegkegchau takamsamujin suwimka suwakun ditá uchiji aidaunash tijaji aidaunash, ama tijaji aidaunash suwimkan suwaitjai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Tusa timatai Moisés tikishmag tsuntsuma nijayin nugka antig pujus Tuke Pujuun emematak, ");
INSERT INTO agr_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","aatus tiuwai: “¡Tuke Pujuuwah, dekaskenum mina anenkumek uyunkagtusta! Iik dekas antakchau ainaji, tujash tsagkugkagtujam amina aentsjum ekagtita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Tuke Pujuu Moisésan chichajak: “Juju shiig antukta. Wi yamai ashí amina aentsjum aidaujai chichaman umiktatjai, dutikakun tikich nugkanmash makichkish wainchatai aidaun kuashat iwainagtatjai. Nuna tikich aents aidau atum pujamunum pujuidaush ashí wainkagtatui. ");
INSERT INTO agr_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Wi yamai juna tajim juka imatiksagmek umiktajum. Nuniakjumin wi atumesh wainbaunum amorreo aents, cananeo aents, hitita aents, ferezeo aents, heveo aents, Jebús aents aidau batsata nunak jiija utsaakun dita nugke aina nunak atumin amastatjime. ");
INSERT INTO agr_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","“Tuja nunú nugkanum jegagmesh, nuwiya aents aidaujaig makichkish chichamak umikaigpajum, tsanupajag pegkegchau takatnum ajumpawainum. ");
INSERT INTO agr_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Duka nunitsuk dekas ditá apajuímtaijin emematuinak patasa apetai altar aidau, tuja kayan emematin aina nunú, numin emematin aina nujai ¡ashí tsaikjum utsankatajum!” ");
INSERT INTO agr_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“¡Makichkish tikichik apajuímawaigpajum, ima midauk atajum! ¡Wika Tuke Pujuu akasmauwaitjai! Mina daajuk Apajuí akasmau tutayai. ");
INSERT INTO agr_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Makichkish nuwiya aents aidaujaig dutik takasmi tusagmek chichamak umikaigpajum, wagki ditá apajuímtaiji aidaun emematuinak kuntin maamun yuwami tusa ipapainakui atumesh nunú yuwawaijum. ");
INSERT INTO agr_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Tuja namputchawame atumi uchijum aidaun ditá nawanji aidaujai nuweami tusashkam tumain ainawai, dutikamak nunú nuwa aidau ditá apajuímtaijin emematuinak atumi uchijum aidaunash pegkegchaun takamtikmain ainawai. ");
INSERT INTO agr_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“¡Tuja jiju ukuijajum atum ememattin dakumkagmek makichkish najanawaigpa!” ");
INSERT INTO agr_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Pag levadurajai pachimtsuk inajuamu yutai tsawan jegakuig, wi dutikatajum tibauwa duka dutiksagmeg siete tsawantai yuwatajum. Tuja mijan achiamu marzo jimaituk nagkamna, abrilan ikak amuga nunú nantutin, tsawan mamikiamua duwi atumek duka dutikattagme, wagki nunú nantutin Egipto nugkanum batsatutijum jiinjau asajum. ");
INSERT INTO agr_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Uchi aishmag iwai akiinuk ashí midau agtatui, tuja baka, uwig, cabra aina nuna uchiji aishmag yama nagkamchaku petsakbau aidaushkam midau agtatui. ");
INSERT INTO agr_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Burro uchiji yama nagkamchaku petsakbau mina sujumaina nunú idaikum uwig tsakat, tuja chivo tsakatkesh sujustatjume. Tujash nunú dutika sujumain atsakuig, burro kuntuje kupigka maatajum. Tuja atumi uchijum aishmag iwai aina nunú anentag sujumainaitjum nunú idaikujum mina anentag sujustin tikich jukijum minitajum. Untsu mina anentag sujumain atsugbauk, makichkish wi pujamunmak tantainmeka. ");
INSERT INTO agr_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Atumek seis tsawantai takastajum. Untsu tsawan sieteya nuaduik ajakmamain akuish tuja ajak juumain akuish idaikujum ayamjatajum. ");
INSERT INTO agr_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Trigo ajakmamu yama nagkamchaku juuktatjum nuna jiista daaji ‘semana aidau’ tutaya duwi, tuja mijan amuebaunum ajak juuktatjum nuna daaji, ‘ajak juut’ tutaya duwishkam Apajuí emematkujum tuke jiistamtajum. ");
INSERT INTO agr_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Nuadui ashí aishmag múun aidauk makichik mijanai kampatuma imania wi pujamunum taawag mina emematjitnume. ¡Witjai Tuke Pujuu atumi Apajuígminuk! ");
INSERT INTO agr_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Atumesh wainjumin tikich aents aidaunak jiija utsakun, nunú nugkanak atumin amastatjime. Nuadui makichkish nugkanak atanjamkichagtin ainawai. Nuwi agkan batsamsajum wi Tuke Pujuu Israel aents aidaun Apajuíjiyaitag nunú emematjakjum maki makichik mijantin kampatuma imania ijunjajum jiistamtinaitjume. ");
INSERT INTO agr_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Mina emematjaku kuntin maa apeamua nuna numpeg, pag levadurajai pachimja inajuamujai jukigmek itagtuawaigpa. Tuja jiista pascuatin Apajuí ememattasa kuntin maamua nuna neje ampinjamtaish kashinia duwi yuwatnuk ukukigpajum. ");
INSERT INTO agr_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“¡Yujág yama nagkamchak nejeku dekas shiig pegkeg aina iman mina jegajuig itagtuatajum! ¡Tuja chivo maajum inagkugmesh dukuji muntsuji ijugbaunum egkeagmek inagkaigpajum! tawai Apajuí”, tiuwai Moisés. ");
INSERT INTO agr_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Nuna tusa Tuke Pujuu Moisésan chichajak: “¡Chicham umiktin aidaun wi yamai tajam nunú agagta! Wagki jujuwai ame Israel aents aidaujai umiktina nunú”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Aatus Moisés mujanum cuarenta tsawan, nuigtu cuarenta kashi yujumkan yutsuk, umutnash umutsuk Tuke Pujuujai pujusui. Nuwi pujus kaya tsupika pakama najanamunum diez chicham umiktinun agajui. ");
INSERT INTO agr_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Nuna dutika muja Sinaínum pujau waketak nunú chicham umiktin agagbaun juki wakitkiuwai. Tuja Tuke Pujuujai igkunia chichasu asa niina yapinig winchamtin wajasui. Tujash nunak niig wainmamchau. ");
INSERT INTO agr_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Moisés minittaman Aarón niina patayi Israel aents aidaujai diikma yapiin winchamtin wajas midaun wainkag, senchi ishamainak jegantachaju ainawai. ");
INSERT INTO agr_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Nuniagtai Moisés Israel aentsu apuji aidaun untsukui ditajai chichastatus. Dutikawajam Aarón Israel aents aidaun apuji aidaujai Moisésan jegaantajui. Nunikagmatai Moisés ditajai chichasui. ");
INSERT INTO agr_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Nunik chichas nagkanainaig aents aidauk ashí jegaantajui. Nunikagmatai chicham umiktin aidaun Tuke Pujuu Moisésan muja Sinaínum susamunak, imatiksag dita umikagtinun ashí ujakui. ");
INSERT INTO agr_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Nuna ditajai chichas ashimak, nuadui jáanchi juki niina yapiin dukumakui. ");
INSERT INTO agr_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tuja Tuke Pujuujai chichastatus weakug nunú jáanchnak ukuak waya, chichas jiinki Tuke Pujuu aents aidau ujakta tibaun betek ujajakui. ");
INSERT INTO agr_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Tuja Moisésak niina yapi winchamtinun Israel aents aidau wainainau asagmatai, jáanchi dukumak pujujakui. Untsu Tuke Pujuujai chichastatus wayakug jáanchnak juki ukujakui. ");
INSERT INTO agr_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Tuke Pujuu tibaunak Moisésak ashí betek umikui. ");
INSERT INTO agr_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Tuja Egipto nugkanum batsatu jiinjajua duwi nagkama mijan jimaja nunú achiamunum nantu yama nagkamchak taka makichik tsawan tsawaju ai, Apajuíjai chichatain carpan aakmak ashimkajui. ");
INSERT INTO agr_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Nuna Moisés aakmakug juni nagkabauwai: Yama nagkamchakug jiju dupajam taumi najanamu aidaun batsaka umikui. Dutika nunú jijunum numi dupajam dakagbau aidaun awajug umika, nuna ichichiagtinun numi tsejeg dakagbau aidaun minanjauwai. Dutika duwi aaka bakuin ajigka umikui. ");
INSERT INTO agr_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Dutika nuwi carpan aakmakui, Tuke Pujuu dutikata tibaunak imatiksag. Aatus aakmatkauwai Tuke Pujuujai chichastasa waitai pegkejam umikbau aajakua nuna. ");
INSERT INTO agr_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Dutika ashimak kaya pakama najanamunum chicham umiktin aidau agagbaun juki arcanum egkeauwai. Dutika dukutai shiig pegkeg najanamujai dukuka nunú yanaki jukitnun jimag numin wegaji apusauwai. ");
INSERT INTO agr_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Dutika Apajuíjai chichastasa waitai aakmakbaunum, tesaamu “shiig pegkejam” tutainum nunú arcan awayauwai. Dutika awaya jáanch wegkagman juki ejatuauwai, Tuke Pujuu dutikata tibaunak imatiksag. ");
INSERT INTO agr_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Nuna umika duwi mesa najanamun juki carpa aakmakbaunum, tesaamu jáanch detuamua nuwi jegatsuk, dekatkau tesaamu pegkejam tutainum awaya untsuja nuni apusauwai. ");
INSERT INTO agr_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Dutika pagkan yajuak Tuke Pujuu wainai nunú mesanum shiig pataja umikui, Tuke Pujuu dutikata tibaunak imatiksag. ");
INSERT INTO agr_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Tuja nuigtushkam jii ekemaka pekatai ayatak oro najanamu candelabron juki mesa pujaun niimtikas menanmanini apusauwai. ");
INSERT INTO agr_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Dutika aceite yajakbaun juki, nuwi pekai ekemag ukukiuwai, Tuke Pujuu dutikata tibaunak imatiksag. ");
INSERT INTO agr_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Untsu Apajuí emematku patasa apetai altar oro najanamun juki, jáanch ejamunum ejentattak apusauwai. ");
INSERT INTO agr_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Nuna dutika Tuke Pujuu tibaun umiak kugkuin incienso tutain juki nuwi patai apeauwai. ");
INSERT INTO agr_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Nuna ashí dutika inagnak, nunú aakmakbauwa nuna waitijin jáanchin detua ukukiuwai. ");
INSERT INTO agr_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Dutika ajuma duwi kuntin maa patasa apetai altar bronce najanamun juki, agá aaka waitijin igkuas apusauwai. Dutika Tuke Pujuu tibaun umiak kuntinun maa nuna nejen nuwi patai ashí apeauwai. Tuja ajak juukbaun Apajuín anentag suwak nunashkam dutiksag apeuwai. ");
INSERT INTO agr_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Nuna dutika yumi yajaa ikigmatai palangana bronce najanamu pujaun juki Apajuíjai chichatai carpa aakmakbau aajakua nujai niniaku altar pujaunum nuna ejapeen apusauwai. Dutika nuwi yumi ikigmagtinun yajauwai. ");
INSERT INTO agr_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Nuna Moisés Aarógjai tuja Aarógka uchiji aidau aatus ditá ikigmagtinun, nawe dijajagtinjin nuwiyan shikika jujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Tuja nunú aaknum wayatag tuinakug nunú yumi aimkamua nuna tuké ikigmag waijaku ainawai, Tuke Pujuu tibaunak imatiksag. ");
INSERT INTO agr_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Nuna ashí umika inagnak, aak carpa aakmakbau aajakua nuna agájin ashí tanishmag ashimak, jáanchi juki waitinum detua ukukiuwai. ");
INSERT INTO agr_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Aak pegkejam carpa aakmakbaun yujagkim ijiuwai. Nuniamunum Tuke Pujuu imanji pegkegma nunú aakan akijuauwai. ");
INSERT INTO agr_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Tuke Pujuu imanji pegkegma nunú yujagmijai betek aakan ijiau asamtai, Moisés waimainchau dekapjauwai. ");
INSERT INTO agr_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tuja nunú yujagkim aak pegkegman ijia aajakua nunú yaki takuntai, Israel aents aidauk ditá aakji aidaun tegaka jukiag shimujakui. ");
INSERT INTO agr_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Untsu yujagkim yakí takunchataik, yakí takunti tusag dakak nuwig aakmag batsamajakajui. ");
INSERT INTO agr_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Tuja aak pegkejam carpa aakmakbaun yujagkim tsawai tuke ijia aajakua nunú, kashishkam keejakua duka, Israel aents aidau shimamunmak nunisag au asamtai, dita nuna shiig wainajaku ainawai.");
INSERT INTO agr_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aarógka uchiji Nadab Abiújai kugkuin incienso chimpia apetain jukiag, nuwi jii ekemakag incienson chimpiawag Tuke Pujuu dutikatajum tichamu aig, aak pegkejam Apajuíjai chichatai aakmakbaunum wayawag nuna apeawajui. ");
INSERT INTO agr_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Dutikiagtai chicham umiktin agagbau Apajuínu egketunmaya jii keeka jiinak apeam mai jakajui. ");
INSERT INTO agr_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Nunikagmatai Moisés Aarógkan chichajak: “Juna pachis Tuke Pujuu chichaak: “ ‘Wi pujamunum taidaunak mina pegkegmajun iwaintukagtatjai. Tuja ashí Israel aents aina nunak mina imanjun iwaintukagtatjai’ tujamayi”, tiuwai. Nuna Aarón antuk, chichatsuk wajasui. ");
INSERT INTO agr_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Nuna tusa Moisés Aarógka apaji yachi Usiel aajakua nuna uchiji aidaun: Misaelan Elzafánjai untsuka chichajak: “Atumi yatsum aidau aak pegkegmanum wayawag jinawaja nunú jiikjum, ii batsatag nunú ukumtikijum imau ejeentajum ukuktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Tusa tima shimutuk jiiki jukiag Moisés tibaunak imatiksag dita batsatbaun ukumtikiag imau ejegan ukukiajui. ");
INSERT INTO agr_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Nunik Aarógka uchiji Tuke Pujuu pujamunum waikma jakagmatai, nuna pachis Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Aaknum tesaamu pegkejam tutaiya nuwi nunú tsawantai wayati tusa mamikiachbau aigkik, makichkish wayawaipa tusam amina yatsum Aarón ujakta. Wagki wika chicham umiktin agagbau arcanum egkeamu puja nuna dukutaijin pujajai, nuniau asan nuwi wi yujagminum wantintai jakai. ");
INSERT INTO agr_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Tuja Aarón nuwi wayakug apeaku tudau tsagkugnagtinun toro tsakatan juki wayati, untsu mina anentag sujamun uwig tsakat aishmagkun juki waya, nuna apeak emematjiti. ");
INSERT INTO agr_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Aarón nuwi wayatatus weakug dekatkauk maíti, nunik nuadui jáanch esajam lino apagbau sacerdote nugkutain nugkug, nuigtu wegamatai lino apagbaun wegamak, akachumtain akachuma, nuigtu atsejutai lino najanamun atsejuk wayati. Jujuwai jáanch dekas etegjamu Tuke Pujuujai chichastasa wayaku iwagmamtai aidauk. ");
INSERT INTO agr_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Tuja ashí Israel aents aina nuna tudauji tsagkugnagtinun Aarón maa apeati tusa jimag chivon susagtatui. Tuja Apajuí anentag suwamua nuna makichik uwig tsakat aishmagkun Aarón maa nuna nejen ashí apeati. ");
INSERT INTO agr_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Nuna dutika inagnak, nuadui Aarón niina tudauji nuigtu niina nuwe, uchiji aina nuna tudauji aidaujai tsagkugnagtinun toro tsakatan maa apeati. ");
INSERT INTO agr_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Tuja nunú jimag chivon aishmagkun juki aak pegkejam aakmakbauwa nuna agaaji peeja tenteamua nuwi waya aaka waitijin jegantatak Tuke Pujuu emtin ejentati. ");
INSERT INTO agr_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","“Dutikamtai chivo jimaja nuwiyash tuki midaush ati tuja Azazeldaush tuki ati nuna kaya jimajan juki nujai dekaati. ");
INSERT INTO agr_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Tuja nunú chivo midau atata nunak tudau tsagkugnagtinnum Aarón maa apeati. ");
INSERT INTO agr_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Untsu chivo Azazeldau atata nunak mautsuk iwakun juki tudaun tsagkugtamjati tusag Apajuí emtin ejentattawai. Nuna dutika nuadui jiiki uwegshunum Azazel pujamunum awemattawai. ");
INSERT INTO agr_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Nuna Aarón niina tudauji nuigtu niina nuwe, uchiji aina nuna tudaujijai tsagkugnagtinun toro tsakatan suwenum tsupik maa apeati. ");
INSERT INTO agr_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Nuna dutika Apajuíjai chichaaku waitai aak pegkejam aakmakbaunum, dekatkau wayamua nunú ‘pegkejam’ tutaya nuwi kugkuin incienso chimpia apetainum jii kaiji kuntin apetainmaya yajuaka chimpiamu eketa nuna jukiti. Dutika nuigtushkam kugkuin incienson atsaaki juki nunú aaknum tesaamu jáanch ejatuamua nunú ‘shiig pegkejam’ tutaya nuwi awayati. ");
INSERT INTO agr_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Dutika wisha wainai jii kegamunum kugkuin incienson utsaati. Dutikam nunú bukuitamu arca dukutain ijiati. Nunú bukuituk ijia ejaku asamtai, wi nuwi wantintaishkam Aarógkak jakashtatui. ");
INSERT INTO agr_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","“Tuja nuigtushkam toro tsakata numpen ujumak juki, tsajam uwejen inua, arca dukutaiji yantamen makichkia pegashmag ukatkati, dutika tikich yantame eem awa nuna sieteya imania pegashmag ukatkati. ");
INSERT INTO agr_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Nuna dutika aents aina nuna tudauji tsagkugnagtinun chivon maattawai. Dutika nuna numpen juki aak pegkejam Apajuíjai chichatainum tesaamu shiig pegkegma nuwi awayattawai. Nuwi awaya arca dukutaiji tuntupen ukatuk, nuadui eemshakam ukatkattawai, yaunchuk toro tsakata numpegai ukatkama dutiksag. ");
INSERT INTO agr_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Nuna dutika Israel aents aidau pegkegchau takamsamuji aidau tsagkugnagmatai, nuadui nunú aak pegkejam Apajuíjai chichatai aakmakbau, dita katseken pegkegchau wajas awa nuna iwajattawai. ");
INSERT INTO agr_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“Tuja tudau tsagkugnagtinnum takak, aak pegkegma nuwi Aarón waya pujau eke jiintsaigkik, makichik aentskesh aak pegkegma nuwi jegantag pujusainmegka. Nuna dutika Aarón niinu, niina nuwenu, niina uchiji aidaunu, nuigtu ashí Israel aents aina nunú pegkegchau takasbauji aidau tsagkugnagtinun ashí umika, ");
INSERT INTO agr_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","jiinki Apajuí emematku patasa apetai najanamu altar puja nuna iwajatatus wetatui. Nunik toro tsakata numpen chivo numpejai ujumak juki incienso patai apetaiya nuna tsakaji ipak usumat wagaku aina nuna ukatkattawai. ");
INSERT INTO agr_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Tuja altar puja nuna niina tsajam uwejen numpan inua sieteya imania ukatkati. Aatus Israel aents aidau pegkegchau takasbaujin altar pegkegchau wajas awa nuna iwajattawai. ");
INSERT INTO agr_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Dutika aak pegkejam Apajuíjai chichataiya nuna, altar puja nujai Aarón ashí iwajug, nuadui chivo iwaku ukukbau utitajum tima itawagmatai jukittawai. ");
INSERT INTO agr_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Dutika nuna kuntinu buuken achika pujus, Israel aents aidau pegkegchau takasbaujin tuja Apajuí antugtsuk intimjukbau aidaun aatus ashí etsegtumagtatui. Dutika ashí pegkegchau aina nunak chivo buuken utuatkattawai, dutikamtai makichik aents nuna juki uwegshunum ejegan atia akupkati. ");
INSERT INTO agr_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Dutikam nunú chivo uwejush aents atsamunum megkagak, ashí ditá pegkegchauji aidaunak yajuak ajapattawai. ");
INSERT INTO agr_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Nuna dutika nunú aak pegkejam aakmakbaunum Aarón waya jáanch lino apagbau nugkuagbaujin awimak ukuktatui. Wagki nunú jáanchik nuwi tuke ukutai asamtai. ");
INSERT INTO agr_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Dutika nuwig yuminum nijamag sacerdote nugkutai jáanch shiig iwajamun nugkuja, nuna agájin jiinki niina tudauji tsagkugnagtinnum, tuja Israel aents aidau tudauji tsagkugnagtinjai kuntinun maa nuna nejen ashí apeak emematjittawai. Nuna dutikamtai ditá tudaujig tsagkugnagtatui. ");
INSERT INTO agr_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Tudaun tsagkugtugti tusa kuntin maa apeamua nuna wiyajinak altarnum patai apeati. ");
INSERT INTO agr_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Aents chivon juki, uwegshunum akupkatatus weuwa duka aakmaja batsatbaunmak eke tatsuk, jáanchjin dijag niishkam, mai, nuadui wayati. ");
INSERT INTO agr_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“Tuja tudau tsagkugtugti tusa toro tsakat chivojai maa apeaku nuna numpe juki, aak pegkegma nuwi awayamua nunak, duwape, neje beseku aina nujai ijumag juki aents batsatbaun ukumtiki apeatnume. ");
INSERT INTO agr_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Aents nuna apeatta duka jáanchjin dijag niishkam mai, nuadui aents batsatbaunum wayati. ");
INSERT INTO agr_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Tuja jujuwai dekas atum chicham umiktin tuke atina nunú. Nantu sieteya nunú taka, tsawan diez tsawagtata nuadui, atumek ijagmajum yujumak yutsuk pujustajum, nuniakjum takatjumesh takatsuk ashí idaisatajum. Atum nuniagmin aents tikich nugkanmaya aidau atumjai pujuidauk ditashkam dutiksag umiktinme. ");
INSERT INTO agr_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Nunú tsawantai sacerdote wi pujamunum taa, atum pegkegchau takamsamunum tsagkugnagtinun segattatui, nuadui tsagkugnagjum agkan juwaktatjume. ");
INSERT INTO agr_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Juju chicham umiktina juka tuke asatnai, nuniau asamtai, nunú tsawanta nuaduik atumek ayamkujum ijagmajum yujumak yutsuk pujuttagme. ");
INSERT INTO agr_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“Tuja atumi apa sumo sacerdoteya nujai yapajinatnunak wi etegkattajai. Tuja atumi tudaujum tsagkugnagtinnumash wajina dutikattawa nunashkam betekmas umikti tusan, wi niinak inajai. Tuja nii sacerdote nugkutaiji jáanch puju lino apagbaun nugkugtatui. ");
INSERT INTO agr_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Nuna nugkuja aak pegkegmanum waya, tikich tesaamu shiig pegkegma nuna iwajug pegkeg awajsattawai. Dutikak altarnashkam iwajug pegkeg awajsattawai. Sacerdote dutikatta nunú dita pegkegchau takamsamujinak, tuja ashí Israel aents aidau pegkegchau takamsamujinashkam tsagkugnajagtatui. ");
INSERT INTO agr_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Pegkegchau takasbaunum tsagkugnagtag tuinakug, juju chicham umiktina juna umiak maki makichik mijanai makichkia dutikatnume”, tiuwai. Aatus Apajuí Moisésan tibaunak imatiksag Aarón umikui. ");
INSERT INTO agr_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Israel aents aidau juju ujakta: “¡Wika Tuke Pujuu atumi Apajuígminuk pegkegmaitjai, nuadui atumshakam pegkejam atajum! ");
INSERT INTO agr_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“Maki makichik ditá apajin, dukujijai eme anentus diitnume. “Nuigtushkam tsawan ayamtain wi etegkauwaitag nunú eme anentsajum diitajum. ¡Witjai Tuke Pujuu Apajuí atum emematin ainajum nunú! ");
INSERT INTO agr_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Dakumka najanamu aina duka emematigpa, tuja nuigtush atum apajuímatnuk jiju ukuija dakumkagmek najanawaigpa. ¡Witjai Tuke Pujuu Apajuí atum emematin ainajum nunú! ");
INSERT INTO agr_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Agkan pegkeg pujustasajum kuntin maa Apajuí anentag suwajum duka tuke dutiktajum, nunú dutikakjumek Tuke Pujuun shiig awagmamain dutikatajum. ");
INSERT INTO agr_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","“Nunú kuntin maamua duka nunú tsawantaik yuwatajum, tuja kashinia duwishkam yumainaitjume, untsu tsawan kampatuma duwi yumain ampinjatta duka apeatajum. ");
INSERT INTO agr_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Nunú kuntinu neje ampinjaun kampatum tsawan tsawaju ai yuwauk tsumain diyam atatui, nuadui nunú aentsnak Apajuí idaisattawai. ");
INSERT INTO agr_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Nuna yuwauk suwimkan ijutmamjattawai, tuja nuigtushkam ashí Israel aents aina nuwiya jiiki yaja ajapeam atatui, Tuke Pujuu tibaun intimjuki umikchau asamtai. ");
INSERT INTO agr_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Ajak juut tsawan jegamtai juwakjumesh ashí juukaigpajum, tuja ampinjau aina dukesh waketjukmek juukaigpa. ");
INSERT INTO agr_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","“Uva juukbaunmaya ampinjauk waketjuki egakmek juukaipa, nuigtush kakekaukesh yajuakaipa; duka idaisata ujudauch aidau tikich nugkanmaya aidaujai yuwatnume. ¡Witjai Tuke Pujuu, atumi Apajuígminuk!” ");
INSERT INTO agr_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Kasamkaigpajum. “Waitjuawaigpajum, atumek pempeentunikjumesh tsanunijaigpajum. ");
INSERT INTO agr_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“Umikchatnaitkum mina daag pachisa tsanumjaipa, duka amina Apajuígmin daaji dushikiakum tame. ¡Witjai Tuke Pujuunuk!” ");
INSERT INTO agr_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Tikichish wainka takamtikakum waitkasaipa, niinu aina duka kasagkaipa. Nii takasbaujinia akiktina duka kashin akiktagme tusa emetjuamek waitkasaipa. ");
INSERT INTO agr_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“Aents empeku dushikiakum pegkegchau chichagkaipa. Aents wainmachuk makichkish tsanujaipa. ¡Witjai Tuke Pujuunuk!” ");
INSERT INTO agr_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Utugchat epegkeakjumesh tsanumtsuk shiig epegkeatajum. Ujudauch akuish, wiakuch akuish, takamsamuji diigsajum suwimkak betek susatajum. ");
INSERT INTO agr_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“Wainkam amejai ijutkau batsata nuwi chicham tsuwapa wekayipa. Tikich aentsush maatnume tusamek tsanumjuja sujukaipa. ¡Witjai Tuke Pujuunuk!” ");
INSERT INTO agr_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Initak kajegkagtinuk aipa. Dekas ame chichagkatag takumek igkuam chichagkata. Nunú dutikachkumek, ameshkam pegkegchaun takasua iman wajastatme. ");
INSERT INTO agr_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“Amina pegkegchau awajtamainakuish, dutiksamkek iikaipa, tuja amina aentsjum aina dusha kajejin aipa. Duka nunitsuk amek anenmamsam tikichish aneeta. ¡Witjai Tuke Pujuunuk!” ");
INSERT INTO agr_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Chicham umiktinun wi tajim nunú ewaetsuk betek umiktajum. Atumi tagkujum aidauk tikich kuntin aidaujaig entsamtikaigpa. Ajagmin ajakmakmesh tikich ajakjai pachimjamek ajakmawaigpa. Tuja nuigtushkam jáanch pachimja najanamuk nugkujaigpa. ");
INSERT INTO agr_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Nuwa wainka inaku waitkatai makichik aentsjai aishinatatus pujaun, tikich aents nuna dekayatak nujai tsanijinuk, aents nuwatkatjai tiuwa nuna akiktatui, nii akikmak sumak niinu ema agkanmitkachu ataishkam. Tujash tikima mautnak maachagtatui ayatak suwimkan mai susagtatui. Wagki nunú nuwak eke sumaka agkanmitkachbau asamtai. ");
INSERT INTO agr_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Aents tsanijinauwa nunú nii pegkegchau takasbaunum tsagkugnagtinjin Tuke Pujuun suwakug makichik uwig tsakatan juki aak pegkejam Apajuíjai chichatai aakmakbauwa nuna waitijin ejentati. ");
INSERT INTO agr_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Nuna sacerdote maa apeak aents pegkegchau takasa nunú tsagkujata tusa mina segattatui. Nunú dutikamua duwi niina pegkegchaujig tsagkujam atatui. ");
INSERT INTO agr_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Tuja wi nugka anagkuawaitjim nuwi jegajum, yujág ajakmattajum nuna neje aidauk yutsuk kampatum mijan idaisatajum. ");
INSERT INTO agr_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Tuja mijan ipak usumta duwi yujág nejektata duka midau atatui, nuadui shiig aneasa jiistamkujum nunú yujág aidau mina sujustatjume. ");
INSERT INTO agr_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Untsu mijan cincotin nejektata duwi nagkamajum atum yuwattajume. Nunú betek umiagmin aan kuashat yujág nejektatui. ¡Witjai Tuke Pujuu, atumi Apajuígminuk!” ");
INSERT INTO agr_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Kuntin numpennukek makichkish yuwawaigpajum. Anentaimsa dekamjai tinu aina nuninuk makichkish takasaigpajum, tuja tunchi takatai aina dukesh takasaigpa. ");
INSERT INTO agr_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","28","“Aents jakamtai atumi intashim wainka tsupi yujaigpajum, tuja susugmi titijigkesh tsupikaigpa. Nuigtushkam atumi iyashinig tsupimá yujaigpajum, tuja atumi iyashinig makichkish dakumkaigpajum. ¡Witjai Tuke Pujuunuk!” ");
INSERT INTO agr_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Atumi nawanjum aina duka akika wainka takatai ati tusa inakjumek waitkasaigpajum. Dita pegkegchau takainamua nunú yujakmatai, atumi nugke shiig pegkegchau wajasai. ");
INSERT INTO agr_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Tsawan ayamtai atinun wi etegkauwaitag nunú ajaantusjum diistajum. Nuigtushkam mina pujutaig pegkejam aakmakmauwa dushakam ajaantusjum diistajum. ¡Witjai Tuke Pujuunuk!” ");
INSERT INTO agr_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Tunchinmak makichkish inamajaigpajum. Tuja anentaimsa dekamji tinu aina dushakam makichkish yujagsaigpajum. Nunin yujagkujum pegkegchau wajasaijum. ¡Witjai Tuke Pujuu atumi Apajuígminuk!” ");
INSERT INTO agr_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Aents múun aina duka ajantusjum diistajum. Duka dutikatajum mina umigtau asajum. ¡Witjai Tuke Pujuu atumi Apajuígminuk!” ");
INSERT INTO agr_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Aents tikich nugkanmaya atumjai pujau, wainka inaku waitkasaigpajum. ");
INSERT INTO agr_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Duka dutiktsuk atum wegantu kuitamainaitjum dutiksagmek kuitamkujum, atumek anenmamsajum aneetajum. Atumshakam tikich nugkanmaya ainayatkujum, Egipto nugkanum batsamajaku ainagme. ¡Witjai Tuke Pujuu atumi Apajuígminuk!” ");
INSERT INTO agr_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Dekapataiyai dekapakjumesh tsanumtsuk shiig dekapatajum, nuigtu kijin dekapataiyai dekapakjumesh, tuja yumi wegantu dekapakjumshakam kasamtsuk shiig betek dekapatajum. ");
INSERT INTO agr_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Betek ewaetsuk dekapatai balanza aina nunú, tuja kijin dekapataish, metro esajam dekapataishkam, ashí ajutjamtinme. ¡Witjai Tuke Pujuu, atumi Apajuíjum, Egipto batsatutigmin jiijuitjim nunú! ");
INSERT INTO agr_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Juju chicham umiktin aidaun wi tajim duka imatiksagmek umiktajum. ¡Witjai Tuke Pujuunuk!” ");
INSERT INTO agr_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Juju Israel aents aidau ujakta: Tsawan Apajuínu atin etegjamua duka ‘Apajuí emematku ijuntai’ tutai atatui. Duka juju ainawai: ");
INSERT INTO agr_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Atumek seis tsawantai takastatjume. Untsu tsawan sieteya nuaduik makichkish takaschattagme. Nunú tsawanta duka ayatak ijunja ayamku Apajuí ememattai atinai. Duka atum tuwi pujuttagme nuniakjumesh nunú tsawanta duik Tuke Pujuu emematkujum tuke ayamtinaitjume. ");
INSERT INTO agr_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Nunú tsawan etegjamu aina duwi atumek Tuke Pujuu emematkujum tuke ijuntinaitjume: ");
INSERT INTO agr_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Mijan nagkamnamu yama nagkamchak nantu takatta duwi tsawan catorcetin agkuantai ijunjajum, nunú tsawantak atum jiinja agkanmagamu Pascua tutaya duwi shiig aneasa jiistamkujum Tuke Pujuu ememattajum. ");
INSERT INTO agr_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“Tuja nunú nantutinig tsawan quincetin pag levadurajai pachimtsuk inajuamu tutai asamtai, Tuke Pujuu emematkujum ijunjajum jiistamatajum. Tuja siete tsawantai pag levadurajai pachimtsuk inajuamu yuwattagme. ");
INSERT INTO agr_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Jiista nagkamnamu yama nagkamchak tsawagtata nuaduik takatak takatsuk ayatak ijunjajum Tuke Pujuu ememattajum. ");
INSERT INTO agr_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Tuja siete tsawantai Apajuí anentag suwamua nunú apeattagme. Tuja tsawan sieteya nuaduik atumi takatjig makichkish takasaigpajum, ayatak ijunjajum Tuke Pujuu ememattajum.” ");
INSERT INTO agr_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Juju Israel aents aidau ujakta: Wi atumin nugká amastatjim nuwi jegajum trigo ajaktatjum nuwiya yama nagkamchaku juuktatjum nunú jigka jukijum sacerdote ejetuatajum. ");
INSERT INTO agr_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Nuna sacerdote juki tsawan ayamtain nagkaiki tsawaitta nuadui Tuke Pujuun segaak iwaintuktatui nii atumi takatjumin shiig anenjamsati tusa. ");
INSERT INTO agr_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Nunú tsawantinig uwig tsakat aishmag pegkeg makichik mijan ajamun sacerdote juki, Apajuín anentag suwak maa nuna nejen ashí apeattawai. ");
INSERT INTO agr_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Tuja nuigtushkam nunú tsawantaik Apajuí anentag suwaku apeatin kugkuin pegkeg ipak usumat nuigtu jimaituk kilo dekapamu harina aceitejai pachimja nanegbau itaattagme. Nuigtushkam ayatak ukagtina nunú vino makichik litro itaattagme. ");
INSERT INTO agr_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Atumek Apajuínua nunú eke anentag sutsukek, pag, trigo duwikbau, tuja samek juukbauk aidaukesh yuwashtatjume. Jujuwai atum tuwi pujuttagme, nuniakjumesh chicham tuke umiktina duka. Junak uchi akiinak wedaushkam tuke dutiktin ainawai. ");
INSERT INTO agr_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Tsawan ayamtai kintamag tsawagtata duwi atum mina anentag sujakjum trigo tsupija jigkamu itagtuatajum, nunú tsawantin nagkama dekapajum siete semana ejetatjume. ");
INSERT INTO agr_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Duka tsawan ayamtai tsawagmatai, kashinia duwi nagkama dekapajum tsawan cincuenta jegak, ayamtai tsawan tsawagtata duwi trigo yamá nagkamchaku juukbau anentag sujustatjume. ");
INSERT INTO agr_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Nunú Apajuí anentag suwamua duka atumi jenia yama nagkamchaku trigo juuka dekegbau harina shiig pegkeg levadurajai pachimja jimag pag maki makichik ipak usumat kilo ajamu aidau inajuamu itattajume. ");
INSERT INTO agr_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Tuja nuigtushkam ashí aents aidautijum ijunjajum siete uwig tsakat aishmag makichik mijanji ajamu pegkeg aidau, nuigtu makichik toro tsakat, jimag chivo, nuigtu trigo, cebada, vino, aatsa jukijum sacerdote susatajum. Dutikam mina emematjak nuna ashí apeati, nuna kugkunti mina shiig awajtau asamtai. ");
INSERT INTO agr_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Tuja nuigtushkam atumi tudaujum tsagkugnagtinnum makichik chivo sujustatjume. Tuja agkan pegkeg pujutan sujusti tujutkugmek, jimag uwig tsakat aishmag makichik mijanji ajamu sujustatjume. ");
INSERT INTO agr_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Nunú atum anentag mina sujamun, pagkan jimag uwig aishmag tsakat aidaujai, sacerdote juki mina itagtuattawai. Nuna sacerdote juki mina eme anenjus segatak iwaintugkattawai. Dutika nunak dita yuwawagtatui. ");
INSERT INTO agr_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","“Nunú tsawanta nuaduik atumi takatjumek makichkish takasaigpajum, ayatak ijunjajum Apajuí ememattajum. Jujuwai atum tuwi pujuttagme nuniakjumesh tuke umiktina nunú. Junak uchi akiinak wedaushkam tuke dutiktin ainawai. ");
INSERT INTO agr_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Ajak ajakmamu juut tsawan jegamtai, juwakjumesh ashí jukaigpajum, tuja ampinjau aina dukesh waketjukmek jukaigpa. Duka idaisatajum ujudauch aidau aents tikich nugkanmaya aidaujai yuwatnume. ¡Witjai Tuke Pujuu atumi Apajuígminuk!” ");
INSERT INTO agr_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Juju Israel aents aidau ujakta: Nantu sieteya nunú taka tsawan makichik tsawaitta nunú ayamtai tsawan asamtai, takatjumek takatsuk ijunjajum jiistamkujum Tuke Pujuu ememattajum. Nuniakjum Tuke Pujuu yaimpamua nunú anentaimtusjum uwija kachuji umpuagtajum. ");
INSERT INTO agr_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Tuja nunú tsawantai Apajuí eme anentsa anentag suwamua nunú apeattagme. Nunú tsawantinig makichik takatjumkesh takaschattagme”, tita tiuwai. ");
INSERT INTO agr_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Nantu sieteya duwi tsawan diez tsawaitta nunú atatui tsagkugnatai tsawan. Nunú tsawantin ijagmajum yujumak yutsuk pujusjum, Tuke Pujuu emematkujum kuntin maa apeatajum. ");
INSERT INTO agr_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Nunú tsawantinig makichkish takatjumek takaschattagme, wagki duka tsagkugnatai tsawan asamtai, Tuke Pujuu Apajuí atumi pegkegchaujin tsagkugtamjagtatui. ");
INSERT INTO agr_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Untsu nunú tsawantin makichik aentskesh ijagmatsuk yujumka yuwaunak, Israel aents aina nuna ukumtikiag yaja jiiki ajapeam atatui. ");
INSERT INTO agr_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Tuja nunú tsawantai aents takatjin takaushkam dushakam dutiksaik jiiki ajapeam atatui. ");
INSERT INTO agr_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","“Nunú tsawantinig makichik takatkesh takasaigpajum. Jujuwai atum tuwi pujuttagme nuniakjumesh tuke umiktina nunú. Junak uchi akiinak wedaushkam tuke dutiktin ainawai. ");
INSERT INTO agr_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Nunú tsawantin atum ayamkujum ijagma yujumak yutsuk pujustatjume. Duka nantu sieteya duwi tsawan nuevetin aagkú nagkamna tsawag kashinia duwi agkuantai nagkantatui.” ");
INSERT INTO agr_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Israel aents aidau juju ujakta: Yaunchuk numi kanawe aakmajag batsamsaju aina nunú anentaimtusjum, numi kanawe aakmagjum juju nantu sieteya duwi tsawan quincetin nagkamajum ijunjajum, siete tsawantai Tuke Pujuu eme anentsa ememattajum. ");
INSERT INTO agr_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Jiista nagkamnamu yama nagkamchak tsawan tsawagtata nuaduik makichik takatkesh takaschattagme. ");
INSERT INTO agr_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Untsu siete tsawantai Tuke Pujuu eme anentsajum nii anentag suwamu apeattagme. Tuja tsawan ochotin ayatak ayamku ijunjajum Apajuí anentag suwamu nii emematkujum apeatajum. Nunú tsawanta duka Apajuí tsawanji asamtai, makichik takatkesh takasaigpajum.” ");
INSERT INTO agr_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Juju tsawan aina nunuwai Apajuí emematku ijuntai atina duka. Nuadui nunú tsawan aina duka pegkejam takat takashtai, ayatak ijunja Tuke Pujuu ememattai awajsatnaitjume. Tuja nunú tsawan aina duwi atum Apajuí anentag suwamu aidau apeamu, kuntin maa nuna neje ashí apeamu, trigo cebadajai juukbau anentag suwamu, pegkeg agkan pujutan sujusti tusa kuntin maa apeamu, vino anentag suwamu aina nunú maki makichik waji tsawantin dutikati tibauwaita duka betek dutikattagme. ");
INSERT INTO agr_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Nuigtushkam tsawan ayamtain ijunja mina emematjajum duka betek dutikayatkujum, juju tsawan aina juwishkam emematjittagme. Atum mina anentag sujustatjum nunú, nuigtu midau atin anagtuawaitjum nujai sujakjum emematjittagme. ");
INSERT INTO agr_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Ajak juuka ashí ashimkajum nantu sieteya duwi tsawan quincetin Tuke Pujuu emematkujum ijunjatajum. Atumek jiista nagkamnamu tsawan tsawaitta duwi ayamjattagme. Tuja tsawan ochotinchakam nunisjumek ayamjattagme. ");
INSERT INTO agr_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Jiista nagkamnamu tsawan tsawaitta duwi yujág pegkeg aidau juukjum, palmera duke aidau, tuja tikich numi kuashat dukentin aidau, álamo namaka uwet ayá nuna dukee aidau tsupija aakmaktasajum yanaki juki shimittagme. Nunú dutikajum siete tsawantai Tuke Pujuu, atumi Apajuígmi emtin shiig aneetnaitjume. ");
INSERT INTO agr_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Duka maki makichik mijantin nantu sieteya duwi siete tsawantai Tuke Pujuu eme anentsa emematkujum ijunjattajume. Junak uchi akiinak wedaushkam tuke dutiktin ainawai. ");
INSERT INTO agr_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Nunú siete tsawan aina duwi ashí atum Israel aents wegantunum akiidau aidautigmek, numi kanawe tsupija aakmakbaunum pujustatjume. ");
INSERT INTO agr_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Juka atum Egipto nugkanum waitkam batsatutigmin wi jiija ai, numi kanawe dukentin tsupigjum aakmaja batsamsauwaitjum nuna atakea duwi atum wegantu aidau dekawagtin aina nunuwai. ¡Witjai Tuke Puju atum Apajuí emematin ainajum nunú!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Juna aatus Moisés Tuke Pujuu emematku ijuntai tsawan etegjamun pachis Israel aents aidaun ujakui.");
INSERT INTO agr_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Aarón niina uchiji aidaujai Israel aents aidaun pegkegnum yumigkiakug aatus titinme: ");
INSERT INTO agr_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘¡Atum aidautigminak Tuke Pujuu pegkegnum yumigtamsatnume, dutijamak nigki kuitamjamkatnume; ");
INSERT INTO agr_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Tuke Pujuu atumnak shiig anenjamas kuitamjamkatnume; ");
INSERT INTO agr_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Tuke Pujuu atumin anempau asa, shiig agkan pujustinme tusa kuitamjamkatin ati!’ ");
INSERT INTO agr_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Juna aatus sacerdote aidau mina daajun adayas Israel aents aidaun tiagtatui. Nuadui wi ditanak pegkegnum yumigsagtatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Chicham umiktin egkemsatnun aak pegkegman carpan aakmak ashimkaju ai, nunú tsawantaik aakan yujagkim ijiauwai. Nunik au agkuantai nagkamas jii keegama imanik aak pegkegmanum keeka au tsawak megkagajakui. ");
INSERT INTO agr_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Duka tuké nuníjakui: Tsawaig aaknak yujagkim ijia aajakui, untsu kashi jiijai betek keeka aajakui. ");
INSERT INTO agr_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Yujagkim nunú aakan ijia aajakua nunú yaki takuntai, Israel aents aidauk yajumakag shimujaku ainawai. Untsu yujagkim wegau tuwi jasa asattawa, nunitaik ditashkam nuwi aakmag batsamajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Israel aents aidauk Tuke Pujuu yujagmin emtikak ematai, nuna diisag shimujaku ainawai. Tuja yujagkim wegau jasa ataik, nuwi aakmag batsamajaku ainawai. Aak pegkejam carpa aakmakbaun yujagkim ijia au takuni wechataik dita batsatbaunmag batsamajakajui. ");
INSERT INTO agr_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Tuja yujagkim aak pegkejam aakmakbaun ijia kuashat tsawan ataik, Tuke Pujuu wetá tachamu asag, nuwi aakmajag batsamajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Tuja yujagkim ujumak tsawan ataishkam, nuwig dita batsatbaunmak batsamajakajui. Tuke Pujuu wetajum tama shimujakajui, tuja juwaktajum tutaik nuwi juwakag batsamajakajui. ");
INSERT INTO agr_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Untsu yujagkim nii nuniktatkug takuni wetsuk, nuwig jasa makichik kashi aajakui. Nunik au tsawak kashikmas takuni wetai shimujakajui. Tuja kashikesh, nuniachkush tsawaigkish yujagkim takuni wetaik, ditashkam shimujakajui. ");
INSERT INTO agr_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Aak pegkejam aakmakbaun yujagkim jimag tsawan, nuniachkush makichik nantu, atsa makichik mijankesh ataik, shimutsuk nuwig aakmajag batsamajaku ainawai. Untsu yujagkim takuni eemak wetai nuadui shimujakajui. ");
INSERT INTO agr_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Tuke Pujuu wetajum tama shimujakajui, untsu juwaktajum tutaik nuwi aakmag batsamajaku ainawai. Nunak Tuke Pujuu Moisésan akateak nunú umiktajum tibaun umiinak nuníjaku ainawai. ");
INSERT INTO agr_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Israel aents aidauk Egipto nugkanum inaku waitkatai batsatun Apajuí jiijua duwi nagkama jimag mijana nuna achikag, nantu jimaja nunú takau ai, tsawan veintetin aak pegkejam carpa aakmakbau aajakua nuna yujagkim ijia au yaki takuniuwai. ");
INSERT INTO agr_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Nunikmatai Israel aents aidau muja Sinaínum batsatu jiinag shiyakajui. Nunik shimui shimuinakua Parán nugkanum yujagkim jasa asamtai nuwi batsamsajui. ");
INSERT INTO agr_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Aatus muja Sinaínmaya juwakiag kampatum tsawan jegawajui. Nunik shimak chicham umiktin agagbau egketun arcan Leví wegantu aidau yanaki jukiag eemak wedau, tuwig yujagkim jasa asat, nuwi ayamsagtin asag. ");
INSERT INTO agr_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Kashikmas nantajag eke uminainaig yujagmik takuni dita shiyaktinnum wajantun wegau. ");
INSERT INTO agr_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Tuja chicham umiktin agagbau egketun yanaki juwagtai Moisés chichaak: “¡Tuke Pujuuwah, pai nantakta! ¡Nunikam amina shiwaajum aidau dapampaakam utsagta! ¡Dutikawamin nuna diisag amina kajegtamin aina duka ishamjamkag pisagtinme!” tau. ");
INSERT INTO agr_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Untsu nunú chicham umiktin agagbau egkeamun yanaki juki wedau apujiagtai Moisés chichaak: “¡Tuke Pujuuwah, amina aentsjum Israel aents shiig kuashat aina nunú ame taam kuitamkata!” tau. ");
INSERT INTO agr_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Makichik tsawantai Israel aents aidau senchi waituinak, Tuke Pujuun pegkegchaun chichajuidau. Nuna Tuke Pujuu antuk senchi kajeka ditan ijinatatus jii kegaun dita batsatbaun tentea ajunjauwai. ");
INSERT INTO agr_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Dutikam nuna ishamainak Moisés ayamjutpakti tusag untsuidau. Imatiagtai Moisés ditá pachis Tuke Pujuun segauwai. Dutikam jii kegau kajinkauwai. ");
INSERT INTO agr_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Nuadui nunú nugka daajig Taberá adaikamu aajakui, wagki nunú nugkanum Tuke Pujuu ditá ijinatatus jii kegaun ajunjau asamtai. ");
INSERT INTO agr_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Tuja Israel aents aidaujai tikich aents aidau pachiinak yujaidauk ayatak yutanak anentaimtujaku ainawai. Nuniagtai Israel aents aidaushkam ditajai betek buu buuttajai pegkegchaun chichainak: “¡Yaki nejenash ii yuwatnunash amastí! ");
INSERT INTO agr_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","¡Egipto batsamsaik namak akikchau yuyag nunú anentaimtaji! Nuigtushkam pepino aidau, melón aidau, puerro aidau, cebolla aidau, ajo aidau yuu ayaji. ");
INSERT INTO agr_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Tujash yamaik juwig nujantai jinaji, tikich yutaigkesh atsawai ¡ima maná yusaik yujaji!” wajaidau. ");
INSERT INTO agr_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Nunú manák culantron jigkayijai betekmamtin aajakui, untsu niimeg culantro puwaji pauja numamtin aajakui. ");
INSERT INTO agr_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Maná kugkuntig harina aceitejai pachimja torta najanamun kugkuntijai betek aajakui. Nuna Israel aents aidau agá jiinag juukag dekegkag pagjai betekmamtinun inajujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Tuja duka dita aakmaja batsatbaunum kashi yumi sajatbaunum kakegajakui. ");
INSERT INTO agr_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Israel aents aidau maki makichik uchiji aidaujai ditá jeen waitinum batsamas buutuidaun Moisés antukui. Nuniagtai Tuke Pujuu senchi kajekui. Tuja Moiséschakam chicham patatbau asa, ditá apuji atanak dakitjauwai. ");
INSERT INTO agr_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Nunik Tuke Pujuun chichajak: “¿Wisha itugkamu asamea wi amina inakmetag nunin aish, imatikamesh waitkajame? ¿Wagka juju aents aidaush minai sujuamesh ame yajuaka emata tusamesh waitkajame? ");
INSERT INTO agr_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Uchi piipich muntsuaku minaaki jutayama numamtuk jukim, dita apachji aajaku aina nunú nugka anagkuawaitam nuwi ame ejegata tujutminum tusanuk wika ditá apajigkesh, tuja ditá dukujigkesh atsujai. ");
INSERT INTO agr_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","¿Wisha tuwiyanak neje jukinush juju aents aidau yuwawagtinnash susagtaja? Mina tajutuawag buu buuttajai chichagtuinak: ‘Neje ii yuwatin sukagtusta’, tujutuinawai. ");
INSERT INTO agr_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","“Tuja wika mina senchigjaigkik juju aents aina nuna yajuaknuk wemaitsujai, wagki juka takatak shiig múuntai. ");
INSERT INTO agr_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Tuja jutika waitkaju pujutnaitkumek, waitu pujuti tujuttsuk dekaskenum minash wait anenjakmek mina pujutjuk jujutkita. Dutijuawamin waitu pujumainaitag nuna dekas ayamsatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Tusa tutai Tuke Pujuu niina ayaak: “Israel aentsu apuji múun aidau ame wainbau chichame antugtai aidau setenta aents yajuakam aak Apajuíjai chichatai carpa aakmakbauwa nuwi ikaunmam dakagsata. ");
INSERT INTO agr_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nuwi wi taan amejai chichastajai, nuniakun mina Wakanig aminí awa nuna Israel aents aidaun apuji aidaunash susatjai, dutikam dita aents aidau kuitabaunum yaimpaktinme. Nuadui amekek waittsashtatme. ");
INSERT INTO agr_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Tuja aents aidau ujakta kashin nejen yuwawagtatui, nuniktin asag yamai ditá pegkegchaujin iwagmamkatnume. Dita buu buuttajai chichainak: ¡Nejesh akuig yumainaitji! ¡Egipto nugkanum ima shiig pujuyaji! wajainawai. “Imatuidau asagmatai, nejen yuwatnume tusan kashin susagtatjai. ");
INSERT INTO agr_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Wika ditanak makichik tsawantai, jimag tsawantai, cinco tsawantai, diez tsawantai, nuniachkush veinte tsawantai yumainnakek susashtatjai. ");
INSERT INTO agr_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Ditak makichik nantu nejenak yuu batsamiagtatui, imatika yuu batsatu asag yawetug tsumiagtatui, wagki wi kuitamsam yujayatak dakitjujag mina emtijui buu buuttajai chichainak: ‘Egipto nugkanum batsatuti jiinjauwaitag duwi nagkamsa yaunchuk Egipto batsamsa waitin aayag nuni senchi waitiaji’ wajaidau asagmatai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Tusa tutai Moisés Apajuín ayaak: “Aents múun maanimain aidau wijai yuja duka seicientos mil ainawai. Imania dusha ¿Amesh itugkamea makichik nantuish nejesh ayujush pujuttame? ");
INSERT INTO agr_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","¿Tuwi ayawa uwig aidaush, baka aidaush, nunú maa aents aidau ashí ayugmainush? Nayantsanmaya namak aidau ashí yajuaka suwakuish makichkish ejemaitsu imanush”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Tutai Tuke Pujuu ayaak: “¿Amek mina senchijuk piipichik diyam? ¡Tuja wi taja dusha uminkatpash, atsa uminkashtimpash duka yamai wainkattame!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Tusa timatai Moisés agá jiinki, Tuke Pujuu tibaun imatiksag aents aidaun ujakui. Dutika nuadui Israel aentsu apuji múun aidaun setenta, aak pegkejam aakmakbaun tentea ijumjauwai. ");
INSERT INTO agr_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Dutika ijumjamtai Tuke Pujuu yujagminum pachitkau akaiki Moisésjai chichasui. Nunik duwi Wakani Pegkeji Moisésai aun ujumak juki, setenta aents Israel aentsu apuji múun aidaun tinamkauwai. Dutikam Apajuí Wakani ditai pujugsam profetajai betek chichatan nagkamawajui. Tujash duka makichkia nunik nagkaemakiuwai ataktuk nunikchauwai. ");
INSERT INTO agr_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Setenta aentsun Moisés etegkauwa nuwiya jimag Eldad daagtin Medad daagtinjai, ditak aak pegkegmanmak wetsuk, dita batsatbaunum juwakajui. Nuwi batsatunak Apajuí Wakani egkemtujam ditashkam profeta chichamaina betek chichainau. ");
INSERT INTO agr_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Nunik chichagtai makichik uchi tupikaki, Moisésan ujaktatus weuwai. Nunik ujaak: “Eldad Medadjai dita batsatbaunmak pujusag profetajai betek chichagmae”, tau. ");
INSERT INTO agr_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Tusa tutai Nun aajakua nuna uchiji Josué datsauch asag Moisésan yaijakua nunú chichaak: “¡Mina apujuh Moisésah, chichakainmegka tusam tita!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Tusa tama Moisés ayaak: “¡Minak akasmatjukaipa! Dekas itugkag ashí aents aina nuna Apajuí niina Wakanin susa, dutikawajam ashí profeta aanum tajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Nuna tusa Moisés Israel aentsu apuji múun aidaujai waketug ditá batsamtaijin shiyakajui. ");
INSERT INTO agr_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Nayantsanmayan Tuke Pujuu dasen dasenmikakui, dutikam nunú dase codornisan shiig kuashat ikaunmakui. Nunú dita aakmaja batsatbaunum tentea nuna yantamen nagkamas kakegak makichik tsawantai jegamainnum nagkankauwai. Imaniku asa makichik metro tumainun dupai asauwai. ");
INSERT INTO agr_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Imaniku asamtai nunú tsawantin nagkamawag, kashish, tsawajash codornisnak juu batsatu. Tuja ashí aents aidau juukajui. Imatikaidau asag dieza imajin ijumjag utuakajui, dutikawag dita batsatbau yantamen batsakajui jujukti tusag. ");
INSERT INTO agr_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Nuna codornisa yuwawag eke amuinachunak Tuke Pujuu ditan kajejuk suwimka susa shiig kuashat ijinauwai. ");
INSERT INTO agr_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Dutika Tuke Pujuu ijinau asamtai, nunú nugka daajin Quibrot-hataavá adaikau ainawai. Wagki aents aidau ayatak yutanak anentaimtujaku aidau jinawagmatai, nunú nugkanum ukusaju asag. ");
INSERT INTO agr_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Tuja Israel aents aidauk Quibrot-hataavá batsatu jiinag shima shimakua Hazerot jegawajui. Nunikag nuwi batsamsajui. ");
INSERT INTO agr_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moisés Etiopía nugkanmaya nuwan nuwatkauwai. Nunikmatai María Aarógjai chichaman patatuidau. ");
INSERT INTO agr_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Dutikainak: “¡Tuke Pujuuk ima Moisésjaigkik chichatsui, auk jutijaishkam chichawai!” tuidau. Tusa tiagtatman Tuke Pujuu antugkauwai. ");
INSERT INTO agr_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Tuja aents ashí nugkanmaya aidaujai apatka diismash Moisésak dekas kakagchauch ima Tuke Pujuu wakegamunak umijin aajakui. ");
INSERT INTO agr_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Nuadui Tuke Pujuu Moisésan, Aarógkan, Marían aatus chichajak: “Atum kampatumtijum aak pegkejam aakmakbauwa nuwi wetajum”, tiuwai. Tusa tima shiyakajui. ");
INSERT INTO agr_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Nunikagmatai Tuke Pujuu yujagminum pachitkau akaiki aaka waitijin wajanta Aarógkan Maríajai untsukui. Tusa untsuam ditashkam jegantajui, ");
INSERT INTO agr_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","nunik jegantagmatai Tuke Pujuu ditan chichajak: “¡Antuktajum wi titatjim nunú! Atum ainajum anuiyan wi makichik profeta apusamua nujaig wika ayatak wakanmanta wajantan, tuja kajanum aajan chichajai. ");
INSERT INTO agr_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Untsu Moisés mina inakjua nujaig aajanuk chichatsjai. Niyai dekas ashí tikich mina inakeg aina nuna nagkaesau ima minak jikatjus umigta duka. ");
INSERT INTO agr_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nuadui niijaig paan igkunian chichajai. Tuja nii mina igkuntua waita nuniaush, ¿wajukeakjumea atumesh mina inakeg Moisésash pegkegchaush chichagjume?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Tuke Pujuu Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Ujumak aents yajuakam ishiakta wi atumin Canaán nugkan amastatag nuna dekaa ukuutinme. Israela uchiji doce wegantu aina nuwiya aents wajiu, chichame antugtai aidau maki makichik etegjam ishiakta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Tusa tima Moisés Tuke Pujuu tibaun umiak, Parán nugkanum pujus aentsun ishiakui. Nunú aents aidauk wajiu chichame antugtai aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Dutika ishiakbau cuarenta tsawan yujasag nugka dekaawag waketug, Parán nugkanum uwejush aajakua nuwi ");
INSERT INTO agr_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","yaakat Cades kaunawajui. Nunikag nuwi Moisés, Aarón, ashí Israel aents aidau aatus batsatun dita yujasa wainkamu aidaun ujakajui. Dutikawag nunú nugkanmaya yujág juki ejegamunashkam iwaintukajui. ");
INSERT INTO agr_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Nuadui Moisésan chichajuinak: “Nugka dekaatajum tusa ame tukagtiamin wemaji. Nunika jegaa wainkamji. Dekas nugkak shiig pegkeje, ajakash shiig tsapagmae, tagkush shiig muumpagmae, nuwiya yujág juki itaaji”, tusa iwaintuidau. ");
INSERT INTO agr_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","“Tujash nunú nugkanum aents batsata duka senchigtin agmae. Yaakat aidaushkam shiig múun makichkish utumainchau peeja apakbau agmae. Tuja nuigtushkam gigante Anac aajakua nunú wegantu aidau batsatu wainkamji. ");
INSERT INTO agr_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Untsu Néguev nugkanum Amalec aents aidau batsaamae. Tuja hitita aents aidau, Jebús aents aidau, amorreo aents aidau mujanum batsaamae. Untsu nayantsanmanini, tuja namak Jordágnum canaágnumia aents aidau batsaamae”, tuidau. ");
INSERT INTO agr_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Nuna antukag Israel aents aidau Moisésjai ijunag batsamas pampaidaun Caleb antuk itatmikak chichajak: “¡Tutsuk dekas shiyakagmi, nunika maania depetmaka nunú nugka ii jukimi! ¡Dekas iik depetmaktatji!” tau. ");
INSERT INTO agr_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Tusa tutai niijai shiyaku aidau chichainak: “¡Atsa, iik nunú aents aina nujaig maanimaitsuji, wagki ditak iina nagkaetamsau senchigtin ainawai!” tuidau. ");
INSERT INTO agr_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Tusag Israel aents aidaun chichajuinak: “Auk ii nugka dekaami tusa shiyakmayag duka pegkegchauyi. Tuja nunú nugkanmaya aidauk nuwiya aents aidaunash main ainawai. Nuigtushkam nuwiya aents aidauk múun esajam ishamain agmayi. ");
INSERT INTO agr_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Tuja nuigtushkam gigante Anac aajakua nunú wegantu aidau batsatu wainkabiaji. Ditajai apatkamak iik manchia nunin wantinbaiji, tuja ditashkam nuninuk diijatiagmayi”, tuidau. ");
INSERT INTO agr_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Nuna antukag Israel aents aidauk untsumainak tuke buu buutainakua tsawagkajui. ");
INSERT INTO agr_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Nunikag ashí dita aidau Moisésan Aarógjai chichaman patatuinak: “¡Egipto nugkanum batsamsa jinumainus imajui uwegshunum yujasa jinaatin asa jiinjayagtai! ");
INSERT INTO agr_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","¡Tuke Pujuu imajuig itagmamainchaunas itagmayatai! ¡Ii aidautik iina shiwaajijai maaniawaja jinawagtatji! Tuja shiwag aidau iina nuwe aidaun, iina uchiji aidaujai achija yajuakagtatui. ¡Dekas Egipto nugkanum atak waketmainus aniagtai!” wajaidau. ");
INSERT INTO agr_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Nuna tusag diták pempeentunikiag chichainak: “¡Dekas iina apuji atin adaika Egipto nugkanum waketjami!” tuidau. ");
INSERT INTO agr_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Imatiagtai Moisés Aarógjai dita emtin tsuntsumawag nijayin nugka antig pujusajui. ");
INSERT INTO agr_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Nuniagtai nugka dekatatus shiyakajua nuwiya Josué Calebjai anentai inagmak jáanchjin japiki ichigkajui. ");
INSERT INTO agr_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Nunikag Israel aents aidaun chichajainak: “¡Ii nugka dekatasa wemayag duka dekas shiig pegkejayi! ");
INSERT INTO agr_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Tuja Tuke Pujuu iina wait anenjamkug nii yaimpasmatai, nunú nugkanmak wayattaji. Tuja nunú nugkak dekas shiig pegkejayi, ajak aidaush shiig tsapagmayi. ");
INSERT INTO agr_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Nuadui Tuke Pujuujaig dekas shiwagmagawaigpa, nuwiya aents aina dusha ishamkaigpajum, wagki ditak jutijaig shiig wainkaush ainawai. Dita yaimainuk shiig atsawai, untsu iinak Tuke Pujuu yaimpawai. ¡Nuniau asamtai ishamkaigpajum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Tusa tamaitak aents aidauk kayai tukua tukuakua maatag tuidau. Nuninai Tuke Pujuu imanjiya nunú Apajuíjai chichatai carpa aakmakbaunum wantinkauwai Israel aents aidaush ashí wainainamunum. ");
INSERT INTO agr_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Nunik Moisésan chichajak: “¿Juju aents aina dusha wajupa kuashta intimjutush yujagtatua? Waji wainchatai aidaun kuashat wi iwaintukajan kuitamka emamash juju aents aina duka dekaskeapi tujutuinatsui. ");
INSERT INTO agr_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nunin asagmatai wi ditanak jata ishamainun awetittajai, dutika ai jinawag wi nugka pegkejan anagkuawaitag nuwig wayashtinme tusan. Tujash aminiyanak kuashat aentsun uyujkatnaitjai, dutika ai Israel aents aidaun nagkaesau kuashat, senchigtin agtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Tusa tutai Moisés Tuke Pujuun ayaak: “Juju aents aidauk Egipto nugkanum batsatu amina senchigmin jiigmayum nuna egiptunmaya aidauk dekainawai. Nuadui ame kuitamtsuk idaisaminig, egiptunmaya aidau nuna dekawagtatui. ");
INSERT INTO agr_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Nunikag Canaán nugkanum aents batsamin aina nuna ujakagtatui. Wagki ditashkam ame jutijai pujam nunak dekawaju ainawai. Tuja wishakam ame paan waitkati tujutiu asamin wainkajame, nuadui ame jutijaig tuke pujame. Tuja ame jutii uyunkagtakum tsawai yujagkim wajanbaunum, kashi jii keeka wajanbaunum emka weam nunashkam dita aidauk shiig dekainawai. ");
INSERT INTO agr_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Nuadui juju aents aidau wamak ijinawaminig, aents tikich nugkanmaya ame imanjumin dekagtamin aidau chichainak: ");
INSERT INTO agr_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“ ‘Tuke Pujuu Israel aents aidaun nugka amastajime tusa anagkuawa nuwi ejemainchau dekapeak, uwegshunum ijinae’, tujamiagtatui. ");
INSERT INTO agr_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Nuadui ame anagkuakum dutikatjai tiuwaitam nunú umiakum senchijum iwainakta. Tuja ame chichaakum: ");
INSERT INTO agr_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Wika wamkek kajechuitjai. Aents aidaunak senchi aneajai, nuniau asan dita pegkegchaun takainak mina shiwagmatuinakuish tsagkujajai, untsu dita pegkegchaujinig tuké suwimkan suwajai dutikakun ditá uchijinash, tijajinash, ama tijajinash ditá apaji pegkegchau takamsamunum suwimkan suwajai’, tame. ");
INSERT INTO agr_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Nuadui amina anenkagmek múunta ibau asamtai, juju aents aina nuna pegkegchaujig tsagkujata, wagki ditak Egipto nugkanum batsatu jiija yajuakam ame kuitamsam imajui ikaunbau asam”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Tusa tama Tuke Pujuu Moisésan ayaak: “Ayu, ame segatam nunak imatiksanuk tsagkujattajai. ");
INSERT INTO agr_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Wika dekas tuke pujuuwaitjai. Mina imanjunak dekas ashí nugkanum dekainawai. Au aents aidauk wi dita muunji aidaun nugka anagkuawaitag nunak dekas wainkachagtinai. ");
INSERT INTO agr_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Wagki wi mina imanjui wainchatai ishamain aidaun Egipto nugkanum tuja uwegshunmashkam iwainamun wainkau ainayatak, dekapjustasag mina umigtutan dakitjau aina nuadui. ");
INSERT INTO agr_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Tuja wi ditá muunji aajaku aina nuna nugka amastajime tusan anagkuawaitag nunak ditak wainkachagtatui. Mina dakitjujaju aina dushakam makichkish nunú nugkanak wainkachagtinai. ");
INSERT INTO agr_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","“Untsu Caleb mina inakjua duka tikich aina nujaig betekchauwai, wagki nigka ima minak umigtau asa. Nuadui nii nugká dekatatus weuwa nuwi niinak awayattajai. Dutika ai nii wegantu aidaushkam nuwi batsamsagtin ainawai. ");
INSERT INTO agr_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Tuja Amalec aents aidauk canaágnumia aents aidaujai nugka pakanum batsatui. Nuadui atumek kashin kashikmasjum uwejush atum kaunamua nuni waketjajum nayants kapantu tutaya aatsajum shiyaktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Tusa Tuke Pujuu Moisésan Aarógjai chichajak: ");
INSERT INTO agr_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Israel aents aidau pegkegchau asag, wainak chichá yuja nunash ¿wajupa kuashtak tsagkujatja? Dita mina pegkegchau chichagtuinamun antukjai. ");
INSERT INTO agr_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Nuniku asan wi yamai atumin titatjim nunú ujaktajum: ‘Atum aidautijum chichamugmin antugkajim duka nunisag uminkati, junak dekas uminkatnun Wi Tuke Pujuun tajai. ");
INSERT INTO agr_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Tuja ashí aents veinte mijanji ajamu daaji agatkamu aidau mina pegkegchaun chichagtukajuk ashí jinawagtatui, nunikagmatai ditá iyashig juju uwegshunum utsankattawai. ");
INSERT INTO agr_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Wi nugkan amastajime tusa anagkuawaitjim nuwig atumek makichkish wayashtatjume. Untsu ima Caleb Josuéjaig wayawagtatui. ");
INSERT INTO agr_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","“ ‘Tuja atum chichaakjum: Iina shiwaaji aidau mantamainak iina uchiji aidaun yajuakagtatui tusajum timaujum duka nunikchattawai. Wi atumi uchijum aidaunak yajuakan atum nugka dakitjaujum nuwi ejegawagtatjai, dutika ai ditak nuwi ajakmawag yuwinak shiig aneas batsamsagtin ainawai. ");
INSERT INTO agr_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Tuja atumi iyashig uwegshunum utsankattawai. ");
INSERT INTO agr_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Untsu atumi uchijum aidau atum pegkegchau takasbaun umiinak uwija kuitamin waigkag uwegshunum cuarenta mijan waitu yujagtinai, atum aidau jinaati tusa. ");
INSERT INTO agr_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","“ ‘Atum nugka dekaatag tusajum cuarenta tsawan yujasuitjum antsag, ditashkam cuarenta mijan dita pegkegchau takasbaujin umiinak yujasagtatui. Makichik tsawanta nuna makichik mijan yujagtatui. Aatus mina pegkegchau chichagtukbaunum yujasag waituinak dekawagtatui. ");
INSERT INTO agr_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Juju aents pegkegchau aina nunak mina pegkegchau chichagtukaju asagmatai dutikattajai. ¡Nuadui ditak juju uwegshunum yujasag jinawagtatui! ¡Witjai Tuke Pujuunuk, nunak dekas uminkatnun tajai!’ Tusa Apajuí tujamui”, tiuwai Moisés. ");
INSERT INTO agr_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Nugka dekaatnume tusa Moisés aents aidaun ishiakua nunú waketug kaunawag, nugkak pegkegchauwe tusag Israel aents aidaun ujakajam nuna antukag Moisésan chichaman patatuidau. ");
INSERT INTO agr_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Tuja nugkak pegkegchauwe tusa tiaju aina nunak Apajuí suwimka susa ijinauwai. ");
INSERT INTO agr_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Untsu Caleb ima Josuéjaig jakachajui. ");
INSERT INTO agr_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Tuke Pujuu tibaun Moisés Israel aents aidaun ujakui. Dutikawajam nuna dekawag wake besemag dekapjajui. ");
INSERT INTO agr_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Nunikag kashinia duwi kashikmas jiinag ataktu waketug mujá shiyakajui, nunik nuwi wakag chichainak: “¡Yamaik imajui kaunaji! Ii Tuke Pujuu intimjuki pegkegchau wajakag duka shiig dekaji, nuniku akuish Tuke Pujuu iina nugka anagtabauwa nuwi shiyakagmi”, tuidau. ");
INSERT INTO agr_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Tusa tiagtai Moisés ditan chichajak: “¿Wagka tujash atumesh Tuke Pujuu chichamesh intimjagme? ¡Atum tajum duka tuké umikchattagme! ");
INSERT INTO agr_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Nuadui shiyakaigpajum, wagki yamaik atumnak Tuke Pujuuk uyuuntamainatsui. Nuniau asamtai atumnak shiwag aidau amupakagtatui. ");
INSERT INTO agr_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Atum weajum nuwi Amalec aents aidau, canaágnumia aents aidaujai dakagmainawai atumin amupakagtatus. Tuke Pujuuk atum idaisamu asa yamaik atumnak uyuuntamainatsui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Tusa tamashkam nunak antutsuk dekas mujá wakami tusag shiyakajui. Nunik shimakush arcanak jukichajui, tuja Moiséschakam wechauwai, ayatak dita batsatbaunmak juwakajui. ");
INSERT INTO agr_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Nunik jiinag shimittaman nunú nugkanum batsamin Amalec aents aidau canaágnumia aents aidaujai jiintujag pataetukag Hormá nugkanum amainagkag nuwi Israel aents aidaun depetuk amukajui. ");
INSERT INTO agr_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Mijan nagkamnamu makichik nantu takau ai, uwejush Sin tutainum Israel aents aidau jegawajui. Nunikag nuwi Cadesnum ujumak tsawan pujusajui. Nuwi batsatai María jakauwai, nunikmatai nuwig ukusajui. ");
INSERT INTO agr_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Tuja nuwi yumi umumain atsau asamtai, Moisésan jiyakagtatus aents aidau ashí ijunjajui. ");
INSERT INTO agr_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Nunik ijunag Moisésan Aarógjai chichajuinak: “¡Tuke Pujuu tikich Israel aents aidaun ijinawabia nunú nugkanmak iinash ijipamainnas aikagmayatai! ");
INSERT INTO agr_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","¿Wagka atumesh Tuke Pujuu aentsji aidautish imajuish uwegshunmash itajatuaugme? ¿Tagkuji aidaujaí ashí jinatnume tukagtatsjumek? ");
INSERT INTO agr_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","¿Wagka Egipto nugkanmaya jiijatkigmesh, juju nugka shiig pegkegchauwa imagnumash itajatuaugme? Juju nugka juwig makichkish ajakmamaitsui. Tuja higuerakesh, uvakesh, munchigkesh juwig shiig atsawai. Nuigtush ¡yumi umumainush shiig atsawai!” wajaidau. ");
INSERT INTO agr_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Imatiagtai Moisés Aarógjai aents aidaun ukukiag Apajuíjai chichatai aak aakmakbaunum nuna waitijin jegantag nuwi tsuntsumawag nijayin nugka antig pujusajui. Nunik pujuinai Tuke Pujuu niina imanjijai wantinkauwai. ");
INSERT INTO agr_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Nunik Moisésan chichajak: ");
INSERT INTO agr_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ushujutaijum jukim Aarón yaimpasmatai aents aidau ijumjata. Dutika ijumjam ditá emtin kaya chichagkum: Yumi sukagtusta tita. Tusa tamin nunú kayanmaya yumi jiinkittawai, nunikmatai dita umuinak tagkujinash agtinme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Tusa tima nuna betek umiak, Moisés niina ushujutaiji Tuke Pujuu emtin atatman jukiuwai. ");
INSERT INTO agr_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Dutika juki Aarógjai aents aidaun kayanum ijumag chichajak: “Antuktajum, chichama intimkiu aidauwah: ¿Juju kaya juwiyan yumin jiikiag amasmatai, uwajagmi tusagmeka imatjum?” ");
INSERT INTO agr_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Tusa Moisés niina ushujutaijin juki kayan jimajá awatiuwai. Dutikam kuashat yumi jiinkiuwai. Nunikmatai Israel aents aidauk nuna umuinak ditá tagkujinash aakajui. ");
INSERT INTO agr_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Tujash Tuke Pujuu Moisésan Aarógjai chichajak: “Atumek minai kajintsa anentaimtsuk, tuja mina pegkegmajua dushakam Israel aents aidaunum iwainakchau asajum, wi nugka anagkuawaitjim nuwig juju aents aidau yajuakjumek wechattagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Nuadui nunú nugka daajin Meribá adaikajui. Nuwi Israel aents aidau Apajuín yumi sukagtusta tusa chichamjukaju asagmatai. Tusa segam Tuke Pujuu niina pegkegmajin ditan iwaintukui. ");
INSERT INTO agr_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Cadesnum batsamas Moisés aents chichama etsejin aidaun Edoma apuji pujamunum ishimak, juna aatus akatmamtujui: “Amina yatsum Israel aents aidau juna aatus tujamainawai: Amek shiig dekame ii utugchatnum batsatuti jiinja yujag duka. ");
INSERT INTO agr_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Iina apachji aidau Egipto nugkanum shiyakag awi kuashat tsawan batsamsajui, tujash egiptunmaya aidau iina apachjin waitkasu aina dutiksag jutinashkam waitkagmayanume. ");
INSERT INTO agr_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Imatijamainakui Tuke Pujuu yaimpakti tusa segabiaji. Dutika ajin ii sumamun antugtamak, niina aentsji nayaimpinmaya ángel makichik awetugmabi, dutikam nunú Egipto nugkanum batsatutin jiipaju asamtai, yamai juju amina nugkem nagkatkamunum yaakat Cadesnum kauna batsatji. ");
INSERT INTO agr_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","“Nuniau asa wait anenkagtugta, amina nugkemea nuni nagkaemakiagmi tusa taji. Nunika nagkaemakuish, ajak ajakmamunmak, tuja uva ayamunmash nagkaemakchattaji, tuja ame yumi umutaigmekesh uwagchattaji. Jinta wetaya duke yajash tsegketsuk amina nugkem nagkaikitasa wetatji tujamui”, tiajui. ");
INSERT INTO agr_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Tusa ujaam Edoma apuji ditan ayaak: “¡Mina nugkajua junig makichkish nagkaemakigpa, tuja antutsuk nagkaemakjuminig, mina suntajujai jiintuktatjime atumjai maaniatasan!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Tusa tutai chichama etsejin aidau ataktu awena shiig ujainak: “Jinta wetaya duke wetatji, untsu nuniamunum iikish atsa nuniashkush iina tagkujigkesh yumi amina umutaigmin umuinakuig nunak akiktajame. Iik ayatak nagkaemaktasa wakegaji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Tusa tiagtai, Edoma apuji chichaak: “¡Tujash junig nagkaemakchattagme!” tiuwai. Nuna tusa Israel aents aidaujai maaniatatus niina suntaji maanitan yacha aidaujai shiig uminas jiintukiuwai. ");
INSERT INTO agr_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Dutika nagkaemamainchau emam, Israel aents aidauk pempeenag yaja tikich yantamnum shiyakajui. ");
INSERT INTO agr_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Israel aents aidauk Cades batsatu ashí jiinag muja Hor tutainum shiyakajui. ");
INSERT INTO agr_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Nunikag Edoma nugke nagkatkamunum jegawagmatai, nuwi Tuke Pujuu Moisésan Aarógjai chichajak: ");
INSERT INTO agr_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aarógkak jakattawai, nuniktin asa wi Israel aents aidaun nugka anagkuawaitag nuwig wayashtatui, wagki atumek Meribánum yumi awa nuwi wi umikta tibau umikchau ainagme. ");
INSERT INTO agr_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Tuja Moisésah, ame Aarón niina uchiji Eleazarjai jukim, muja Hornum nuna titijin wakata. ");
INSERT INTO agr_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Nuwi wakam Aarón sacerdote nugkutaijin nugkuaja nunú awitka jukim niina uchiji Eleazar apegata. Nuwi Aarógkak jakattawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Tusa tima Moisés Tuke Pujuu tibaunak imatiksag umikui. Nunak ashí Israel aents aidau wainbaunum muja Hornum weuwai. ");
INSERT INTO agr_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Nunik waka nuwi Moisés Aarógka jáanchjin awituk jujuki Eleazaran apegauwai. Tuja Aarógkak nunú mujá titijiya nuwi jakauwai. Nunikmatai Moisés Eleazarjai mujanum batsatu waketug kaunauwai. ");
INSERT INTO agr_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Tuja Aarón jakamun Israel aents aidau dekawag, treinta tsawantai buutiaju ainawai. ");
INSERT INTO agr_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Canaágnumia aents aidaun apuji yaakat Arad tawa nuwiya Néguev nugkanum pujujakua nunú Atarim jinta nuni Israel aents aidau mininawai tabaun dekauwai. Nunik ditajai maaniatatus niina suntaji aidaujai jiintujajui. Nunik maaninak Israel aents aidaun ujumak achika yajuakui. ");
INSERT INTO agr_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Dutikawajam Israel aents aidau Tuke Pujuun segainak: “Ame yaijatkamin nugka utuakuik, nuwi batsamin aina duka ashí ijinku yaaktajijai tsaikmi taji”, tiajui. ");
INSERT INTO agr_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Tusa tiagtai, kame dutikatajum tusa Tuke Pujuu tiuwai. Nuadui Israel aents aidau canaágnumia aents aidaun amuktinme tusa Tuke Pujuu yaigkui. Dutikamu asa nuna amuinak yaaktajijai tsaikajui. Nuadui nunú nugka daajin Hormá adaikau ainawai. ");
INSERT INTO agr_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Israel aents aidauk muja Hornum batsatu jiinag Edoma nugke utuawaig tusag, nuna tentea nayants kapantu tutaya nuni shiyakajui. Nunik jintá shimamunum atsanmainchau dekapenak waugkamin anentaimtan jukiajui. ");
INSERT INTO agr_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Nuadui Apajuín Moisésjai chichaman patatuinak: “¿Wajukatnume tusagmea Egipto nugkanum batsatjinish jiijatkimiugme? ¿Imajui uwegshunum jinaati tusagmek jiijatkimiujum? Yumi umumainush atsawai, tuja yumainush shiig atsugtamji. ¡Tuja nuigtush yutai junin yuwi yuwinakua yawetkaji!” tuidau. ");
INSERT INTO agr_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Imatiagtai, Israel aents aidaun esaitnume tusa Tuke Pujuu dapin ishitkauwai. Nuadui nunú dapi esaim kuashat jinawaju ainawai. ");
INSERT INTO agr_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Nunik jinuinak Moisésan jegajuawag chichajuinak: “¡Tuke Pujuu chicham patatku, ameshkam chicham patatkau asaja pegkegchau wajasji! ¡Apajuí segata dapi iina waitkagma nuna yaja ishiakti!” tuidau. Tusa tiagtai, Moisés Apajuín segauwai ditan tsagkujati tusa. ");
INSERT INTO agr_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Tusa segam Tuke Pujuu Moisésan chichajak: “Anú dapi aina nunin dakumka makichik najanata. Dutikam numi esajam ajiam nuna titijin pempegka Dutikam numi esajam ajiam nuna titijin pempeajam yakí jiikta. Tuja makichik aentskesh dapi esaimak, nunú dapi najanamua nuna diistinme, nuninak tsagajagtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Tusa tima Moisés broncen juki, dapi dakumak najanauwai. Dutika numin ajia nuwi pempeg awagkek yakí jiika ukukiuwai. Tuja dapi esaimak nuna diisag tsagajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Tuja Israel aents aidauk shima shimakua Moab nugka pakaji namak Jordágka tsumujin yaakat Jericójai niniaku awa nuwi jegawag batsamsajui. ");
INSERT INTO agr_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Israel aents aidau amorreo aents aidaun depetuk amuke tabaun Siporan uchiji Balac Moab nugka apuji antukui. ");
INSERT INTO agr_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Tuja moabnumia aents aidaushkam Israel aents aidau shiig kuashat asagmatai, nuna wainkag senchi ishamkajui. ");
INSERT INTO agr_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Nunikag moabnumia aidau madiágnumia apu aidaun chichajuinak: “Au aents aina duka baka chijichin yuwa amuwama numamtuk iinak iina nugkejaí amupakagtatui”, tuidau. Tuja nunú tsawantinig Balac aajakui Moab nugka apuji. ");
INSERT INTO agr_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Balac nigki maaniakug Israel aents aidaunak depetmainchau asa, Balaam Beora uchiji yaakat Petor tutainum namak eufratesnum ijus nugka Amav tutainum pujaun untsukui. Balac chichama etsejin aidaun Balaam ujaktajum tusa ishimak, juna aatus akatmamak: “Egiptunmaya aents aidau kaunawag juju nugka junak ashí batsamtukaje, nuninak tikima wi pujamunmash kaunawaje. Imaniku asamtai, ");
INSERT INTO agr_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","wamak taata, nunikam juju aents aidau pegkegchaunum yumigjata, wagki ditak iina nagkaetamsau kuashat, senchigtin ainawai. Ame pegkegchaunum yumigjamin, wi depetkan juju nugka juwi batsata nuna jiijan ishiakchainjash, wagki ame pegkegnum yumigkiamuk tuja pegkegchaunum yumigkiamushkam betek uminna nuna wika dekau asan tajai, tujamui titajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Tusa akatjam moabnumia apu aidau madiágnumia aidaujai Israel aents aidau yumigkiamunum akikmaktinun kuichki jukiag shiyakajui. Nunik Balaam pujamunum jegawag Balac akatmamjamun ujakajui. ");
INSERT INTO agr_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Tusa ujakam Balaam ditan chichajak: “Juwi kajigtajum nuniagmin Tuke Pujuush wajinjuttig nuna dekaan ujaktajime”, tiuwai. Tusa tiyajam moabnumia apu aidauk nuwi niijai juwakajui. ");
INSERT INTO agr_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Nunik batsatai Apajuí Balaaman wantintuk iniak: “¿Anú aents amejai batsata dusha ya ainawa?” tau. ");
INSERT INTO agr_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Tusa tama Balaam Apajuín ayaak: “Balac Sipora uchiji Moab nugkan apuji aents aidaun ishiake, mina chichaman ujatkatnume tusa. ");
INSERT INTO agr_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Kuashat aents egiptunmaya jiinag ashí nugkanum pampagke. Imaniku asamtai, Balac wakegawai mina awi wamak jegaa nunú aents aina nuna pegkegchaunum yumigjati tusa. Dutika ai niina nugken batsata nuna nii depetuk jiija ishiaktag tau asa”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Tusa tutai Apajuí Balaaman chichajak: “Anú aents aina nujaig wepa, tuja nunú aents aina dushakam pegkegchaunmak yumigjaipa, wagki ditak wi pegkegnum yumigjamu ainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Tusa tima tsawak kashikmas nantaki, Balac ishiakbau apu aidaun chichajak: “Tuke Pujuu wakegatsui atumjai weti tusag, nuniau asamtai, atumi nugkemin waketjatajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Tusa tiyajam apu moabnumia aidauk waketug Balac pujamunum jegawag ujainak: “Balaamak jutijai minitnak dakitmae”, tuidau. ");
INSERT INTO agr_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Tusa ujakmashkam antutsuk yama nagkamchak ishiakua nuni kuashat dekas apu chichame antugtai aidaun ataktu ishiakui. ");
INSERT INTO agr_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Dutika ishiakam Balaaman jegajuawag ujainak: “Balac Sipora uchijiya nunú chichagtamak: ‘Wait aneasam juwi minitak dakiajaipa. ");
INSERT INTO agr_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Wi aminak shiig kuashat akiktatjame. Tuja nuigtushkam ame segatbaunak imatiksanuk umigkatjame. Nuadui wait aneasam juju aents aina nunú pegkegchaunum yumigjata’ tujamae”, tiajui. ");
INSERT INTO agr_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Tusa ujamashkam Balaam ditan ayaak: “Balac niina pujusa inamtaijin oro aidau, plata aidau piyak atsuash nuna ashí sujakuish, wika makichkish imannak tuja imanchaunakesh Tuke Pujuu Apajuí dutikawaipa tujutbaunak dutikmaitsujai. ");
INSERT INTO agr_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Untsu wainkagmekesh juwi pujusjum kanagtajum, tuja yamaish Tuke Pujuush wajinjuttig, nuna dekaan ujaktajime”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Tuja nunú kashia duwi Apajuí Balaaman wantintuk chichajak: “¡Anú aents aidau amina jujamkitatus kaunawaja nujaig wetá! Tujash nunika wemesh wi amina wajintatjame duke umiktatme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Tusa tima tsawag nii ekemsa wetinjin burro tuntupen patai umika, nuwi ekemi moabnumia apu aidaujai weuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Nunik ekemi wetai aents nii tsakapakbau aidau jimag uyuniajui. Tuja Balaam wetai Apajuí kajejuk, nii weamun jintanum ángelchawashit tumaina wee wajasui. ");
INSERT INTO agr_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Nunik nunú ángel jinta ejapeen akijua puyaja takus wajaun burro wainkauwai. Nuna wainak tsegkeki ikamnum akumkauwai. Nunik akumtai Balaam jintanum awagkitatus asutiauwai. ");
INSERT INTO agr_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Dutika asuttai nunú ángel ukuki uva ajakbaunum jinta menaku mai yantamen kaya peejamunum wajasui. ");
INSERT INTO agr_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Nuwi ángel wajaun burro wainak, jinta kaya peejamunum atuumi tepak Balaama bakuin chanuntua tepesui. Nunitai Balaam ataktu burron asutiauwai. ");
INSERT INTO agr_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Dutiktai nunú ángel ukuki niyá eemak jinta shiig menaku makichkish ayampa waketmainchaunum wajasui. ");
INSERT INTO agr_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Nunik wajaun burro wainak nugká tepesui, nunikmatai Balaam kajeka numi juki asutiauwai. ");
INSERT INTO agr_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Dutiktai Tuke Pujuu burron chichamtikauwai. Dutikam burro Balaaman chichajak: “¿Wisha aminash itujeagme? ¿Tsuwah, kampatuma imania asuutam jama?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Tusa tama Balaam ayaak: “¡Amek mina dushiktakum tujutme! ¡Kuchiin takakkunuk yamaikiuch maumainaitjame!” tau. ");
INSERT INTO agr_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Tusa tama burro ayaak: “Wika burruitjai, ame tuké entsamka wekaetaigmetjai. Wi amina chichaman intimjuchuitjam duka amek shiig dekame”, tiuwai. Tusa tama Balaam ayaak: “Duka dekas tame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Tusa timatai Tuke Pujuu nunú ángel puyaja takusa jintá waja nuna Balaam wainkati tiuwai. Nuna Balaam wainak eme anentus tsuntsuma nijayin nugka antig pujusui. ");
INSERT INTO agr_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Nunitai Apajuí ángel tumain wajas chichajak: “¿Wagka amina burrogmesh kampatuma imanish asutiaume? Ame weam nunú mina shiig awajtachu asamtai, wi jintanak akigtagme. ");
INSERT INTO agr_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Amina burrojum mina waituk kampatuma tsegkeki menanjuse. Nunikchauwaitkuig burronak iwaku akupeakun aminak maumain awajkajame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Tusa tama Balaam ayaak: “Niints awi pujusa jinta akigtujua tachau asan pegkegchaun takasjai. Tuja wi weag nunú amina shiig awagtamchakuig dekas wakitkitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Tusa tutai Apajuí ángel tumain wajas ayaak: “¡Anú aents aina nujai weam duka wetá! ¡Tujash amek ayatak wi titatag duke chichaktatme!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaam minawai tabaun Balac dekaa Moapa nugke nagkatkamunum namak Arnón tutainum makichik yaakat awa nuwi jegajua igkug jukitatus wejiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Dutika igkug chichajak: “Kuashta untsuakun waitkasjame. ¿Wagka juwi minitash dakitmaume? ¿Wi amina shiig kuashat akimainaitjam duka dekatsmek?” tau. ");
INSERT INTO agr_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Tusa tama Balaam ayaak: “Kame yamaik juwi taajai amejai chichastasan. Tujash wika mina senchigjaikik chichamaitsujai, Apajuí wajinjuttig nuna wika titatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Nuna tusa Balaam Balacjai yaakat Quiriat-husot weuwai. ");
INSERT INTO agr_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Nuwi jegamtai Balac Apajuín anentag suwak baka aidaun, uwig aidaun kajegkui. Nuna nejen Balaam niina uyunainak apu yujaidaujai yuwawajui. ");
INSERT INTO agr_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Nuna dutika kashinia duwi kashikmas Balac Balaaman juki muja Bamot-baal tutainum wajasa diyam Israel aents aidau batsatbau shiig waindau asamtai, nuna iwaintuktatus weuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Nuwi waka Balaam Balakan chichajak: “Juwi kuntin maa patasa apeaku Apajuí ememattin sieteya imajin najatjuata. Dutikam siete toro tsakat, nuigtu siete uwig tsakat aishmag aidau umigtukta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Tusa tima Balac imatiksag umikui. Dutikamtai jimagtukag siete toro tsakat aidaun, siete uwig tsakat aishmag aidaujai maawajui, dutika kuntin patai apetai siete najanamunum nuwi maki makichik patajag apeawajui. ");
INSERT INTO agr_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Tuja Balaam Balakan chichajak: “Kuntin maa patagbauwa juwi pujumata, nuniamin Tuke Pujuush wajinjuttig nuna dekaan ujaktajame”, tusa ukuak muja naintin weuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Nuwi waka pujaun Apajuí wantintukam Balaam Apajuín chichajak: “Kuntinu maa patasa apeakun amina ememattasan sieteya imajin najanajai. Dutikan nuwi makichik toro tsakatan, nuigtu makichik uwig aishmag tsakatan aatsa patajan umikjai”, tau. ");
INSERT INTO agr_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Tusa tima Balaam chichaktinjin Tuke Pujuu ujakui. Dutika chichajak: “Wakitkita Balac pujamunum, nunikam wi amina tajam nunú betek tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Tusa tima Balaam wakitki, Balakak apu moabnumia aidaujai kuntin maa patagbaunum nuna yantamen ijunai jegantui. ");
INSERT INTO agr_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Nunik jeganta Apajuí tibaun etsejak: “Etsa minitainmanini muja ayá nuwi, Aram nugkanum pujai, Moabnumia aents aidaun apuji Balac chichama akuptujak: ‘Taata, nunikam Jacopa uchiji wegantu aidau pegkegchaunum yumigjata’, tujutmae. ");
INSERT INTO agr_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Tujash wisha Apajuí pegkegnum yumigjamunash ¿wajuk pegkegchaunmash yumigjatjaki? ¿Wisha itugkanuk Apajuí dakitamunash, utugchat ajiti tusanush ditanash titaja? ");
INSERT INTO agr_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Au aents aina duka, tikich aents aina nuna pujutjijaig betekchau, ditash kanakag batsamin ainawai. Nunú aidaun juju mujanum wajasan wainjai. ");
INSERT INTO agr_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Dita aidauk shiig kuashat nugka yukukuntu dekapamainchauwa iman ainawai. ¿Ibau kuashta nunash yaki dekapajainta? Ditak pegkeg asag jainakush, shiig aneas jau aina nujai betek wishakam shiig aneasan jakatasan wakegajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Nuna antuk, Balac kajeka Balaaman chichajak: “¿Wajuk takumea tame? Wika aminak mina shiwag aina nuna pegkegchaunum yumigjati tusan itaamjame. ¡Dutikamaitkum amek pegkegnum yumigkiame!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Tusa tama Balaam ayaak: “Wika amejai chichaakun, Tuke Pujuush tunak tujutit nuna wika titatjai timagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Tusa tamashkam Balac ataktu chichajak: “Wegajai, tikich yantama awi wemi, nunika awi diyam Israel aents aidau ujumak kanaka batsata nunú pegkegchaunum yumigtujata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Tusa Balac Balaaman juki muja Pisgá nainti Sofim tutainum ejegauwai. Dutika nuwi kuntin maa patasa apeatnun sieteya imajin najana nuwi toro tsakat aidaun, uwig aishmag tsakat aidaujai kajegka maki makichik pataja umikui. Dutikamtai nuna Balaam apeak Apajuín emematiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Nuwi Balaam Balakan chichajak: “Juju kuntin maa patagbauwa juwi pujumata, nuniamin wi wenu Tuke Pujuujai chichastajai niish wajinjuttig”, tusa ukuak weuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Nunik jeganmatai Tuke Pujuu Balaama wantintuk nii chichaktinjin ujakui, dutika chichajak: “Wakitkita Balac pujamunum, nunikam wi amina tajam nunú betek ujakta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Tusa tima Balaam wakitki kuntin maa patagbaunum nuna yantamen Balac apu moabnumia aidaujai ijunai jegantui. Nunik jeganmatai Balac iniak: “¿Tuke Pujuush wajinjutpame?” tau. ");
INSERT INTO agr_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Tusa iniam, Balaam Apajuí tibaun etsejak aatus tiuwai: “Balac Sipora uchijiyah, wi amina titatjam nunú shiig antukta. ");
INSERT INTO agr_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Apajuík aentschauwa nunin asa nigka waitjuchui, tuja chichakbaujinash yapajichui. Nii nuna dutikatjai takug imatiksag uminai, tuja nii anagkagtuamunashkam imatiksag uminai. ");
INSERT INTO agr_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Nuniau asa Israel aents aidau pegkegnum yumigjata tusa Apajuí tujutne. Nuadui Apajuí pegkegnum yumigkiamunak wika pegkegchaunmak yumigmaitsujai. ");
INSERT INTO agr_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Tuja nuigtush makichik aentskesh Israel aents aidau waitjutaijinak dekagchau ainawai, pegkegchau takamtaijinakesh dekauk shiig atsawai. Tuja ditanak Tuke Pujuu ditá Apajuíjiya nunú kuitamui. Tuja ditashkam: ‘¡Jujuwai iina apujig!’ tuinawai. ");
INSERT INTO agr_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Nuadui búfalo niina kachujin ayamjumama numamtuk Israel aents aidau ayamjumataijig Apajuí dita Egipto nugkanum batsatun jiijua nunuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Jacopa uchiji wegantu aina nuna wi pegkegchaunum yumigkiaknush, wainka dutikmainaitjai. Israel aents aina nunak tunchikesh wawemaitsui. Wi yamai Israel aents aidaun tajai: ‘¡Apajuí atumnak dekas shiig pegkegnum yaimpakaje!’ ");
INSERT INTO agr_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Juju aents aina duka, Leónjai betek nantaki niina shiwaaji aidaun jeteakug, ayamtsuk ashí amuka, nuna numpen uwag duwi shiig ayamak tepena iman ainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Tusa tutai Balac Balaaman chichajak: “¡Au aents aina nunú pegkegchaunum yumigmainchau dekapeau asam, pegkegnumak yumigjaipa!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Tusa tutai Balaam ayaak: “¿Wi amina chichagkug, Tuke Pujuush tunak tujutit nuna titatjame tichamkajam?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Tusa timatai Balac chichajak: “Wegajai tikich yantama awi wemi. Awi jegantaminish, Apajuísh Israel aents aidau pegkegchaunum yumigjata tujamchaintash”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Tusa Balac Balaaman juki muja Peor tutai naintin emauwai. Nuwi wajasa diyam ashí uwejush aidau waintainum emauwai. ");
INSERT INTO agr_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Nuwi jeganta Balaam Balakan chichajak: “Juwi kuntin maa patasa apeaku Apajuí ememattin sieteya imajin najatjuata. Dutikam siete toro tsakat, nuigtu siete uwig tsakat aishmag aidau juki umigtukta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Tusa tima Balac imatiksag umikui. Dutika umikmatai Balaam toro tsakat aidaun, uwig aishmag tsakat aidaujai kajegka kuntin patai apetai sieteya imajin najanamunum maki makichik pataja apeak Apajuín emematiuwai. ");
INSERT INTO agr_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaamak Apajuí Israel aents aidaun pegkegnum yumigkiau asamtai, nuigtu awagkig Israel aents aidau pegkegchaunum yumigmainun dekaatasag wakekachui. Tuja yaunchuk Tuke Pujuu segajakbaujinak idayak uwegshunum Israel aents aidau batsatbaunmanini ayampa niimsauwai. ");
INSERT INTO agr_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Nuniak Israel aents aidau maki makichik wegantu doce aajakua nunú batsatun diittaman Apajuí Wakani ekemtujui. ");
INSERT INTO agr_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Dutika egkemtujam atakea duwi atinun juna aatus tiuwai: “Witjai Balaam Beoran uchiji, wika Apajuí wakega nunak shiig dekajai. Wi chicham etsegbau antuktajum. ");
INSERT INTO agr_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Wika Apajuí Wakani egkemjutjamtai tikishmaja pujusan, paan wainjai. Tuja Apajuí ashí senchigtina nunú mina nii wakegamujin iwaintujak, chicham etsegkatnun suja nuna ima shiig paan dekajai. ");
INSERT INTO agr_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","¡Jacopa uchiji wegantu aidauwah, atumi aakjum aidauk shiig pegkeg ainawai! ¡Israel aents aidauwah, atum batsatjum duka shiig pegkejai! ");
INSERT INTO agr_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Palmera shiig kuashat tepajua imanai, ajak ajakbau namaka uwet aiyama imanai, ajak Apajuí ajakbau aiyama iman, ¡setug namaka uwet ayau shiig pegkejama imanaitme! ");
INSERT INTO agr_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Israel aents aidau uwagtinuk yumi shiig kuashat aitnai. Tuja dita ajak ajakma ukatkatnushkam imanisag aittawai. Ditá apujig tikich apu Agag daagtinun depetkatnai. Tuja ditá senchijig shiig múun atinai. ");
INSERT INTO agr_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Apajuí Israel aents aidau Egipto nugkanum batsatun jiijua nunuwai búfalo ayamjumatai kachujiya numamtin. Nuadui Israel aents aidauk ditá shiwaaji aidaunash amuktinai. Dutikak nagkí iju mainak, ukunchin kupijagtinai. ");
INSERT INTO agr_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Israel aents aidau ayamak tepakug, león tepegama nujai betek tepenawai. Iman asamtai, jegaantag ishintaumainchau dekapenawai. ¡Amina pegkegchaunum yumigtamaidauk, ditashkam dutiksaik pegkegchaunum yumigkiam agtinai, untsu amina pegkegnum yumigtamaidauk, ditashkam dutiksaik pegkegnum yumigkiam agtinai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Nuna antuk Balac Balaaman senchi kajegkauwai. Nunik uwejen awati chichaak: “Wika aminak mina shiwag aina nunú pegkegchaunum yumigjata tusa untsukmagme, dutikamaitkum amek au aents aina nunú kampatuma imania pegkegnum yumigkiame. ");
INSERT INTO agr_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Nuniau asam ¡dekas jemin wakitkita! Wika aminak shiig kuashat akiktagme timajai. Tujash Tuke Pujuu dakittin, amek wainka juwakume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Tusa tama Balaam Balakan ayaak: “Wika amina aentsjum chichama etsejin aidaun ujaakun, ");
INSERT INTO agr_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","ame pujusa inamtaigmin oro aidau, plata aidau piyak atsuash nunú mina ashí sujakminish, wika Apajuí tujutbaun intimjuknuk makichkish imannak tuja imanchaunakesh mina senchigjaig dutikmaitsujai. Ayatak Tuke Pujuu tujutbaunak tumainaitjai, tibaijai. ");
INSERT INTO agr_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Untsu dekas mina nugkajui wakitkitjai. Tujash eke wetsuk, au aents aina dusha amina aentsjum aidaunash atakea duwish itugkatnuk ainawa nuna ujaktajame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Nuna tusa Balaam juna atak atinun etsejak aatus tiuwai: “Witjai Balaam Beoran uchijinuk, wika shiig dekajai Apajuí wakegamua nunak. Tuja wi chicham etsegbau antuktajum. ");
INSERT INTO agr_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Wika Apajuí Wakani egkemjutjamtai tikishmaja pujusan, shiig paan wainjai Tuke Pujuu ashí senchigtina nunú nii wakegamujin mina iwaintujak, chichaman etsegkatnun sujawai. ");
INSERT INTO agr_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Makichik aentsun atushat wainjai. Tuja makichik waji atushat aun wainjai: Duka Jacob wegantunmaya makichik yaya wantinui, nunuwai Israel aents aidaun apujig. Nunú apua duka Moab aents aidaun depetuk amuka, nuigtushkam Set wegantu aidaunash dutiksag amuktinai. ");
INSERT INTO agr_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Tuja Edom aents aidaunashkam depetkatnai. Seír nugkanum ditá shiwaaji batsata nunash depetuk, nugken atankiag dita jukiagtinai. Israel aents aidauk Edom aents aidaun depetuk dita senchijin iwainmamkagtinai. ");
INSERT INTO agr_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Jacob wegantunmaya makichik senchigtin depetbau atinai, nunú yaakat aidaunum ujumak juwakag pujuidaun amuktinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Nuna tusa Balaam Amalec aents aidau nugken ayampa wajas chichaak: “Amalec aents aidauk senchigtin ajantusa diitai ainawai. Tujash ashí tsaika emegkam atinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Nuna tusa idayak Balaam quenita aents aidau nugken diisa chichaak: “Atum Caín wegantu aidautigmek ayamjumataijum shiig umikbau akuish, tuja kaya múun aidaunum pishak pasugken ekenag kuitamama numamtuk umikuitkugmesh, ");
INSERT INTO agr_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","suntag asirianmaya aidau, achigmajag yajupainak nunú pasugkem aina nunak tsaika jiiyai apeawag utsagkagtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Tuja inagnak Balaam atak tikich tsawantai nagkaemagtinun pachis juna aatus tiuwai: “¡Chah! ¿Apajuí nuna dutiktata duwish, yaki eke iwakush pujustinaita? ");
INSERT INTO agr_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Chiprenmaya lancha nayantsanum suntajan yajuak minawai. Nunú asirianmaya aidaun, Hebernumia aidaujai amukagtinai, dutikawag ditashkam jinawagtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Nuna tusa ashí etsejuk Balaam jiinki weuwai niina jeen waketak. Nunikmatai Balakshakam niina pujusa inamtaijin wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Nunik kuashat tsawan nagkaemakiu ai, Tuke Pujuu Moisésan chichajak: “Juju muja Abarim tutaya juwi wakata, nunikam Israel aents aidaun wi nugka susatjai tusa anagkuawaitag nunú diista. ");
INSERT INTO agr_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Nunú nugka wainkam, duwi amina yatsum Aarón jakauwa nunismek, ameshkam jakattame. ");
INSERT INTO agr_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Atumek yumi umumain atsutai, Israel aents aidau chichamjuinakui, wi nunú dutikatajum tusan uwejush Sin tutainum tiuwaitjim nunú umikchauwaitjume. Nuwi Israel aents aidau yumi sumainakui, atum ditá emtin mina eme anenjuschauwaitjume”, tiuwai. Tuja nunak uwejush Sin tutainum yaakat Cades awa nuwi yumi pukuni jiinu Meribá tutaya nuna pachis tawai. ");
INSERT INTO agr_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Tusa tama Moisés Tuke Pujuun chichajak: ");
INSERT INTO agr_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Ashí aents aina nuna Apajuíji Tuke Pujuuwah, ame amina aentsjum aina nuna apuji atin makichik apu adaikata, ");
INSERT INTO agr_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","nunú yajuak emati, uwig kuitamkachbau wainak yujama nunikainum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Tusa tutai Tuke Pujuu Moisésan ayaak: “Josué Nun tutain uchijiya nunuwai wi etegkamu, wajiu, mina umigtau. Nunú untsuka jukim amina uwegmin niina buuken achikta. ");
INSERT INTO agr_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Dutikam sacerdote Eleazar pujamunum ejegam, nuadui ashí Israel aents aidau wainbaunum apu adaikata. ");
INSERT INTO agr_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Dutikam nuadui ame takasuitam dutika takastinji ujakta. Dutikamu asamtai, ashí Israel aents aidauk niina chichamen umigkatnume. ");
INSERT INTO agr_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Untsu Josué nigki sacerdote Eleazarai weti. Nuwi jegamtai Eleazar mina inintsattawai. Tusa ininkui wi Urimnum wajuk iwainaktatja nuna Josuén ujaktatui. Dutikamu asa nii Israel aents aidau apuji wajasa Israel aents aidaun yajuak emati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Tusa tima Moisés Tuke Pujuu timaunak imatiksag umikui. Dutikak Josuén juki sacerdote Eleazar pujamunum ejegauwai, tuja nuigtushkam ashí Israel aents aidau batsatbaunmashkam ejega iwainakui. ");
INSERT INTO agr_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Nuna dutika Moisés Tuke Pujuu tibaun umiak, Josué buuken achika Apajuín segati apu emauwai.");
INSERT INTO agr_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Juna Moisés namak Jordágka amain etsa minitaiya nuni uwejush awa nuwi pujus, Israel aents aidaun ujakui. Nunú uwegshuk Arabá nugkanum awai. Tuja duka yaakat Suf tawa nujai niniaku nugka Parán, Tótel, Labán, Haserot, Dizahab aatus aajaku aina nuwi awai. ");
INSERT INTO agr_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Tuja Cades-barnea jegamuk Horebnum juwaki jinta Seírnum wetaya duke wea weakua once tsawanta imajin jegawai. ");
INSERT INTO agr_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Tuke Pujuu Moisésan Israel aents aidau ujakta tusa tima ujakua nunak, ");
INSERT INTO agr_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","amorreo aents aidaun apuji Sejón Hesbón nugkanum pujaun, tuja Basán nugka apuji Og aajakua nujai depetuk amuka, nuigtu Astarot nugkanum yaakat Edrei tawa nuwiyanashkam depetuk amukua duwi pujus, cuarenta mijan jegá, once nantu taka makichik tsawan tsawaju ai, Moisés Apajuí tibaunak imatiksag Israel aents aidaun ujakui. ");
INSERT INTO agr_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Nunak Israel aents aidauk namak Jordágka tsumujin Moab nugkanum batsatun, Moisés dita umikagtinun juna aatus chichajak: ");
INSERT INTO agr_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Muja Horebnum batsatjin Tuke Pujuu iina Apajuíji juna aatus chichagtamak: ‘Atumek juju muja juwig kuashat tsawan batsamsaugme. ");
INSERT INTO agr_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Nuadui aakjum aidau tegakjum, wajijum yajuakjum amorreo aents aidau batsatbaunum mujá wetajum. Nunikjum nuna yantamen tikich nugka ayá nuwi batsamsatajum. Duka nugkak juju ainawai: Arabá nugka, ikam tepaju, nugka paka weaju, Néguev nugká, nugka nayantsa pakaji, canaágnumia aents aidau nugke, nuigtu Líbano nugka, namak shiig múun Eufratesa aatus jegawai. ");
INSERT INTO agr_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Wi nunú nugka aina nunak atumin amaajime. Wetajum nunikjum nunú nugka jukitajum, nunak atumi apachjum Abraham, Isaac, Jacob aajaku aina nuna uchiji wegantu aidaun susatnaitjai tusan anagkuawaitjai’, tujutmayi” tiuwai Moisés. ");
INSERT INTO agr_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“Mina pataag Israel aents aidauwah, chicham umiktina nuna wi jintintuawaitjim nunú yamai antukjum betek umiktajum. Nuniakjum iwaku pujusjum Tuke Pujuu atumi apachjum aajaku aidaun Apajuíji, nugka amastajime tusa anagtamauwa nunú nugkanum jegajum batsamsamnujum. ");
INSERT INTO agr_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Chicham umiktina nuna wi tajim duka makichkish ewaetsuk, tuja esakagjumkesh emegkautsuk betek umiktajum. Tuke Pujuu atumi Apajuíjiya nuna chichame umiktin agagbauwa nuna wi tajim nunú betek umiktajum. ");
INSERT INTO agr_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Atumek shiig dekagme iina patayi aidau muja Baal-peor tutainum batsamas, nuwiya aents aidau apajuímtaiji Baal aajakua nuna emematu yujatai, Tuke Pujuu kajejuk ijinauwai. ");
INSERT INTO agr_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Tujash atum aidautijum Tuke Pujuu atumi Apajuíjiya nunú eme anentsajum niina chichame umigkau aidautigmek yamai juwi ashí iwaku pujagme. ");
INSERT INTO agr_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“Tuja Tuke Pujuu mina Apajuíg atumin nugka amasua nuwi atum pujusjum, chicham umiktinun nii tujutbaunak imatiksanuk ashí jintintuajime. ");
INSERT INTO agr_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Nunú chichama duka ashí betek umiktajum. Nuniagmin aents nunú nugkanmaya aidaush, yachamet unuimatjai atumin awa nuna dekawagtatui. Nunú atum betek umiamugmin wainkag, dita chichainak: ‘¡Israel aents aidauk shiig yacha ainawai!’ tujamiagtinai. ");
INSERT INTO agr_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Wagki aents tikich nugkanmaya aina duka ditá apajuímtaiji yayachbau asag, iina Apajuíji Tuke Pujuu ii segamak betek yaimpau asamtai, senchigtin ainag imanuk makichkish atsawai. ");
INSERT INTO agr_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Tuja nuigtushkam iinu chicham umiktin aidau shiig pegkeg ajutjamu asamtai, senchigtin ainag ibauk makichkish tikich aents aidauk atsuinawai. Wagki ditanuk iinu chicham pegkeg umiktin aidau ajutjama nunin atsugbau asag. Nunú chichaman wi atumin jintintuan yamai amaajime. ");
INSERT INTO agr_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Nuadui kuitamamkatajum Apajuí atumin yaimpau asa, kuashat waji wainchatai aidaun iwainamu wainkauwaitjum nunú kajimatkijum. Tuja wi atumin jintinjim dushakam makichkish kajimatkigpa. Kajimattsuk atumi uchijum aidau, tijajum aidau, nunú pachisjum jintintuatajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","“Atum aidautijum muja Horebnum Tuke Pujuu atumi Apajuíji emtin pujuyujum nuadui Tuke Pujuu chichagtak: ‘Israel aents aidau ijumjata mina chichamjun antukag unuimagtinme. Nunikag mina tuké umigtuktinme, nuninak dita uchiji aidaunash jintintuatnume. Dutikam ditashkam dutiksag umiktin atinme’, tujutiabi. ");
INSERT INTO agr_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","“Tusa tujutai atumek muja najatamunum ijunjabiugme. Nunika ijunjajumin nunú mujanmaya jii kegak bukuiti yaki takuni yujagkim najanea shiig suwe wajasabi. ");
INSERT INTO agr_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Nunú kegamunmaya Tuke Pujuu Apajuí atumin chichagtamu antukuitjume. Tujash atumek chichame antakjumesh niina niimeg makichkish wainkachuitjume. ");
INSERT INTO agr_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Tuja nunú mujanum jimag kaya pakama najanamunum diez chicham umiktin aidau agagbaun Tuke Pujuu amasabi. Dutika amaak juju ashí betek umiktajum tusa tujabiuwai. ");
INSERT INTO agr_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Nuadui Apajuí nugka amastata nuwi batsamsajum nunú chicham umiktina nuna atumin jintintuati tusa Tuke Pujuu mina inatjauwai. ");
INSERT INTO agr_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“Muja Horebnum jii kegamunum Tuke Pujuu atumjai chichasua duwikish atumek makichkish niina niimeg wainkachuitjume. Nuadui kuitamamkatajum, ");
INSERT INTO agr_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","wainkajum dakumka najana ememattai aina nunú aishmagkesh, nuwakesh dakumka najanagmek emematigpa pegkegchau wajasaijum. ");
INSERT INTO agr_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","Tuja kuntinkesh, chigkikesh, ");
INSERT INTO agr_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","japiinas yujau aina dukesh, namakia aina dukesh ememattinuk dakumkagmek makichkish najanawaigpa. ");
INSERT INTO agr_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Tuja nayaim diyakjumesh, etsa, nantu, yaya aidau, nuigtu tikich agkajunum etsantin ayá dukesh wakemain diyakjum emematigpa. Wagki nunú aidaunak juju nugkanum tikich aents aidau batsata nunú ememattinme, tusa Tuke Pujuu tiuwai. Tujash ii Israel aents aidautik Tuke Pujuu Apajuí ii emematin ainag ima duke emematiagmi. ");
INSERT INTO agr_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","“Atumnak jiju ukuijatasa hornonum jitayama numamtuk Egipto nugkanum waitkam batsatutigmin Tuke Pujuu jiipag niinu etamiuwai. ");
INSERT INTO agr_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Dutijamawaitak atumi pegkegchaujin Tuke Pujuu mina kajegtuke. Nuadui amek namak Jordágkak katitkashtatme tujutne. Tuja nuigtushkam nugka atumdau atinun amastata nuwig jegashtatme tusa tujutne. ");
INSERT INTO agr_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Tujutiu asamtai wika namak Jordágnak katittsuk juu nugka juwig pujusan jakattajai. “Untsu atum aidautijum Jordán katitkajum nugka pegkeja nunú jukittagme. ");
INSERT INTO agr_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Tujash kuitamamkatajum atum chicham umiktinum Tuke Pujuu atumi Apajuíjum amasua nunú kajimatkijum. Nuadui dakumka najana apajuímtai aidaun, Tuke Pujuu Apajuí dutikawaigpa tusa tujabiuwa duka makichkish dutikawaigpa. ");
INSERT INTO agr_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Wagki Tuke Pujuu atumi Apajuíjiya duka dekas, Apajuí akasmauwai. Iman asa niig jii kegak apea emegkaina imanai. ");
INSERT INTO agr_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“Tuja nunú nugkanum batsamsajum uchijinkajum, tijajinkajum múuntuch wajasa pujakjumesh, Apajuí emematut idaikujum dakumka najana ememattai aina nuninuk emematigpajum, Tuke Pujuu atumi Apajuíjum kajegtamkainum. ");
INSERT INTO agr_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Tuja atum Jordágka amain katigjum Apajuí nugka amasua nuwi pujusjum dakumkamu emematu yujakjumek, nunú nugkanmak dukap tsawan pujutsuk ijina emegkam atinaitjume. Duka tuke uminkatta nuna wi yamai nayaimpin nugkajai adaisan tajai. ");
INSERT INTO agr_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","“Tuja nuigtushkam Tuke Pujuu jiipag ashí nugkanum utsampaktatjume, dutijamawagmatai nunú nugkanmak ujumchik juwakag pujusagtinai. ");
INSERT INTO agr_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Dutika utsampakmatai tikich nugkanum yujasjum nuwiya aidaun apajuímtaiji numi najanamu, kaya najanamu antuchu, wainmachu, yuchau, mayatchau aina nunú ememattinaitjume. ");
INSERT INTO agr_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Nunika tikich nugkanum batsamsajum waitiakjum, Tuke Pujuu atumi Apajuíjiya nunú, ashí anentaimijai, wakanmijai segaakjum antujam atinaitjume. ");
INSERT INTO agr_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Atum tikich nugkanum batsamsajum dakumkamu emematkujum waitu pujautijum idaikujum, ataktu Tuke Pujuu atumi Apajuíjum umigjuminig, ");
INSERT INTO agr_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","niig wait anenkagtina iman asa atumnakek idaitamsashtinai. Ijipatnash ijipashtinai, nuigtushkam nii atumi muunjum aidaujai chichaman umikua nunak kajimatkishtinai, wagki nunak tuké umiktinaitjai tiu asa. ");
INSERT INTO agr_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“Atumesh anentaimsatajum: Apajuí yama nagkamchak aentsun najanauwa duwi nagkamsash, tuja ashí nugka najatawa imanuish, Apajuí iina yaimpau asa pegkeg aidaun yamai iwaina aika iwainakui tabaush makichkish antukukaitjum. ");
INSERT INTO agr_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","¿Jii kegamunum Apajuí atumin chichagtabau antakjumesh, jinachuitjum nuninush tikich aents aidaush ainawash? ");
INSERT INTO agr_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Ii aidautinak Apajuí etegtamjauwai. Dutijabau asa iina ayamjutpak, jutii makichkish wainajakchamun ishamain aidaun Tuke Pujuu iwainag egiptunmaya aidaun senchi sapigmitkakua nunú atumek shiig wainkauwaitjume. Tuja tikich apajuímtai aina duka makichkish imanun iwainamainuk shiig atsawai. ");
INSERT INTO agr_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Nunak dutikauwai Tuke Pujuu senchigtina imanuk, tikich Apajuík shiig atsa nuna ashí aents aidau dekatnume tusa. ");
INSERT INTO agr_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Apajuí atumi pujutjumin esetamatag tau asa, nayaimpinum pujusa chichagtamkauwai. Tuja nugkaashkam jii kegaun iwaintugmakui. Nunú jii kegamunmaya niina chichame antukuitjume. ");
INSERT INTO agr_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Tuja atumi apachjum aajaku aina nunashkam Apajuí aneau asa dita wegantunmayan etegjauwai. Dutikau asa Egipto nugkanum waitkam batsatun niina senchijijai jiija agkanmitkauwai. ");
INSERT INTO agr_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","“Nuadui tikich aents atumi nagkaetamsau kuashat, nuigtush senchigtin aidaun atumesh wainjumin Apajuí jiija utsagke, wagki yamai atum juju nugka jukitin asagmin. ");
INSERT INTO agr_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","“Nuniau asamtai Tuke Pujuu Apajuí nayaimpinash, nugkanash apujiya nunú shiig antukjum kajimattsuk aneaku atajum. Wagki Apajuíya imanuk tikichik atsawai. ");
INSERT INTO agr_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Nuadui niina chichame umiktajum tibauwa nuna wi yamai juju tsawanta juwi amaajim nunú betek umiktin atajum. Nunú betek umiakjumek, Tuke Pujuu Apajuí atumdau nugka tuke atinun amastata nuwi kuashat mijan pujustinaitjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Moisés Israel aents aidaun chichajak: “Tuke Pujuu atumi Apajuíjum nugka anagtabauwa nuwi jegajum pujusjum, chicham agagbauwa nunú atum umiktin aidaun jintintuati tusa, Apajuí mina inatjauwa duka jujuwai: ");
INSERT INTO agr_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","‘Tuke Pujuu Atumi Apajuíjiya duke ememattajum. Dutikakjum niina chichame umiktin aidau agagbauwa nunú atum, atumi uchijum aidau, tijajum aidau aatus umiktinun wi jintinjim nunú betek umiktajum. Nuniakjum kuashat mijan iwaku pujustinaitjume. ");
INSERT INTO agr_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Nuadui Israel aents aidauwah, chicham umiktin aina nunú betek umiktajum. Nunú betek umiakjumek, nugka pegkeg ajak shiig tsapaun amastinaitjime tusa Tuke Pujuu atumi Apajuíjum atumi apachjum aidaun anagkuawa nuwi pujusjum shiig kuashat yujaktinaitjume.’ ");
INSERT INTO agr_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“Antuktajum Israel aents aidauwah: Tuke Pujuuwa nunuwai iina Apajuíjig; Tuke Pujuuk ima makichkiuchi. ");
INSERT INTO agr_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Tuke Pujuu amina Apajuígmea nunú amina anentaimijai, wakanmijai, senchigmijai aneeta. ");
INSERT INTO agr_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Nuniakum wi yamai tajim nunú shiig atukjum kajimattsuk aneaku atajum. ");
INSERT INTO agr_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Nunikjum atumi uchijum aidau kashi kashinig jintintajum. Dutikakjum atumi jeminish, tuja jintá wekaekugmesh, kashi kanakjumesh, tsawaku nantakjumesh, chicham umiktin aina nunú uchijum aidau jintintuatajum. ");
INSERT INTO agr_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Atumek Apajuí etegkamu ainajum nunú iwainmamkujum chicham agagbau umiktin aina nunú kuntugmin patakumajum, atsejukjum yujastajum. ");
INSERT INTO agr_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Tuja nuigtushkam shugku aidaunum, nuigtu atumi jee aina nuna waitijinchakam agaja anujkatajum. ");
INSERT INTO agr_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“Atumi apachjum Abraham, Isaac, Jacob aajaku aina nuna nugka amastajime tusa Tuke Pujuu atumi Apajuíjum anagkuawa nuwi atumnak ejetamawagtatui. Nunú nugka nuwig yaakat múun shiig pegkeg aidau atumkesh yaaktamkachbau, ");
INSERT INTO agr_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","jega aidaunum waji pegkeg aidau pimasua weaku atum ipiakchamu, yumigmat aidaush atum taichbau yaunchuk tai umikbau aidau, tuja uva ajakbau aidau, aceituna ajakbau atum ajakmachbau aidau, yaunchuk ajaka umikbau aina nuwiya shiig yuwajum pujustinaitjume. ");
INSERT INTO agr_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","Nunú iman ayaunum jegagmesh, Tuke Pujuu Apajuí atum Egipto nugkanum inaku waitkatai batsatutigmin agkanmitkagmauwa nunú kajimatkigpa. ");
INSERT INTO agr_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","¡Tuke Pujuu atumi Apajuíjiya duke ememattajum! ¡Nuniakjum ima nigki eme anentsajum umigkatajum! ¡Tuja atum umiktin dekas takugmek ima Apajuí daajinig titajum! ");
INSERT INTO agr_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","“Tuja tikich aents aidau apajuímtaiji aina duka emematigpa, ");
INSERT INTO agr_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","wagki Tuke Pujuu atumi Apajuíjiya duka, dekas Apajuí akasmauwa, nuniau asa atum wainka apajuímtai aina nunú emematu yujataik, nii kajegtamak ashí ijipamainai. ");
INSERT INTO agr_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","“Tuja Masá nugkanum pujusjum Tuke Pujuu atumi Apajuíjum dekapsauwaitjum numamtuk ataktu dekapsatasagmek wakeyigpajum. ");
INSERT INTO agr_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","¡Tuke Pujuu atumi Apajuíjiya nuna chichame umiktin agagbauwa nunú umiktajum tusa tujamauwa duka ewaetsuk betek umiktajum! ");
INSERT INTO agr_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Atumi apachjum aajaku aina nunú umikagtinun Tuke Pujuu anagkuawa nuwi jegajum shiig pujustag takugmek Tuke Pujuu wakegamu pegkeg aina duke takastajum. ");
INSERT INTO agr_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Nuniagmin nii tibauwa nuna imatiksag atumi shiwaajum aidaunak atumjai maaniawai tusa uwakek ipisjattawai. ");
INSERT INTO agr_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“Tuja atakea duwi atumi uchijum aidau inimpainak: ‘¿Juju chicham umiktin agagbau aina nuna Tuke Pujuu iina Apajuíji umiktajum tujabiuwa nunash wajina taku tiuwaita?’ ");
INSERT INTO agr_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Tujamainakuig atum ayaakjum: ‘Ii aidautik Egipto nugkanum batsamsa faraógka inaku waitkatai ayaji. Nuni batsatjin Tuke Pujuu niina senchijijai jiipagmayi. ");
INSERT INTO agr_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Tuja faraógkan, niina nuwen, niina uchijin aatus Tuke Pujuu suwimka suwak wainchatai ishamain aidaun iwainajua nunú ii wainkauwaitji. ");
INSERT INTO agr_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Untsu jutiinak nuwi batsatutin nii jiipag jujamki iina apachji aajaku aina nuna anagkuak nugka amastajame tiuwa nuwi itagmae. Dutijama nunú nugkan iina amase. ");
INSERT INTO agr_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Dutika amasu asa Tuke Pujuu iina Apajuíji chichagtamak: Juju chicham umiktin aidau agagbauwa nunú umiktajum, nuniakjum ajaantusjum diitajum, tusa tujamui. Wagki nunú betek uminaku yamai iwaku shiig batsatag junika batsamsatag tau asaja. ");
INSERT INTO agr_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Tuja chicham umiktin agagbauwa nunú umiktajum tusa Tuke Pujuu iina Apajuíji tujabiuwa nunú betek umiajinig, dekas atumek pegkeg takagme tujamtatji’ titatjum”, tiuwai Moisés. ");
INSERT INTO agr_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“Tuke Pujuu atumi Apajuíjum, atum batsamsatnun nugka amastata nuwi ejetamawagtatui. Dutijama nuwiya aents aidau siete nugka múun aidaunmaya maki makichik chichamtin, atumi nagkaetamsau senchigtin, shiig kuashat batsamin: hitita aents aidau, gergeseo aents aidau, amorreo aents aidau, cananeo aents aidau, ferezeo aents aidau, heveo aents aidau, Jebús aents aidau batsata nunak atumesh wainjumin Tuke Pujuu jiija utsagtatui. ");
INSERT INTO agr_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Tuja nunú aents aina nuna depetkatnume tusa Tuke Pujuu atumi Apajuíjum senchimtijamamtai, depetkajum utuagmek wait anenjaigpajum, tuja nuigtush ditajaigkish chichamak umikaigpajum, ayatak ijina utsagtajum. ");
INSERT INTO agr_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Tuja nuigtushkam atumek nuwiya nuwa aidaujaig nuwenawaigpajum, atumi uchijum aidaush, nawanjum aidaushkam nuwiya aents aidaujaig nuweawaigpajum. ");
INSERT INTO agr_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Wagki ditá aishin umijuinak aishi apajuímtaiji aidaun uchijum aidau, nawanjum aidau emematuinak Tuke Pujuu ememattan kajimatkinum. Dita nuniagtai Tuke Pujuu atumin kajegtamak shiig wamak ijipamain asamtai. ");
INSERT INTO agr_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","“Nuadui dita apajuímtaijin emematuinak kuntinun patasa apetai aidau najankamu ajuina duka tsaigkatajum. Dutikakjum dita apajuímtai kaya aidau, numi kampujam tsupikbau, Asherá daagtin aidaun aatus dita emematuina duka ashí tsaigkatajum. Tuja nuigtushkam ashí tikich dakumka najanamu aina dushakam dutiksagmek tsaigka apeajum utsankatajum. ");
INSERT INTO agr_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Wagki atumek ima Apajuí Tuke Pujuu tutaya nudau atinme tusa etegjamu ainagme. Nuadui atumnak ima niinuk atinun ashí aents nugkanmaya aina nuwiyan etegtamjauwai.” ");
INSERT INTO agr_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","“Tuke Pujuu atumi Apajuíjiya nunú etegtamjauwa nunak, aents tikich nugkanmaya aina nuna nagkaesau ima kuashat asagminigkish etegtamjachui. Atumek dekas tikich aina nujai apatkamak imanchaush ainagme, nunin ajuminig etegtamjauwai. ");
INSERT INTO agr_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Tujash ¿wagkag nunash etegtamjabi? Nunak Tuke Pujuu atumin anempau asa, atumi apachjum aajaku aidaun anagkuawa nuna umiktag tau asa, Egipto nugkanum batsamsajum faraógka inaku waitkatai batsatutigmin niina senchijijai jiigmajui. ");
INSERT INTO agr_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Nuadui Tuke Pujuu atumi Apajuíjiya duka aents aidau niina aneak umijuinamak, nii umiktajai tibaujinak ewaetsuk, ditá uchiji wegantu aidaunmashkam tuke umina nunú dekaskeapi titajum. ");
INSERT INTO agr_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Tuja niina betek umigtsuk kajejuina nunak nii suwimka susa wamak ijina utsainai. Nunin aina nunak kuashat tsawannakesh sutsuk shiig wamak ijina utsainai. ");
INSERT INTO agr_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Nuniau asamtai yamai wi atum aidautigmin chicham umiktin agagbau aidaun umiktajum tajim duka betek umiktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“Juju chicham umiktin aidau agagbauwa nunú antukjum betek umiagminig, atumi apachjum aidaun Tuke Pujuu atumi Apajuíjum ditan anagkuawa nuna betek umiktatui. ");
INSERT INTO agr_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Dutikak ima atumnak anempatnai. Nuadui pegkegnum yumigtamag atumi uchijum aidaunash pegkegnum yumigkig kuashat ikauntugmaktinai. Tuja ajakma juutnumash, trigogminash, vino, nuigtu aceite aidaunash, tuja baka aidau, uwig aidau tsakapatnumash atumi apachjum aidaun anagkuauwa nunak imatiksag amasagtatui. ");
INSERT INTO agr_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","“Atum atinaitjume dekas tikich aents aidaun nagkaesau pegkegnum yumigsamu. Nuadui nuwa kaga aidaush atsutnai. Tuja aishmag aidaushkam uchi akiichuk atsutnai. Tagkujum nuwa aidau petsachuk, tuja aishmag uchi akiichush atsutnai. ");
INSERT INTO agr_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Egiptunmaya aents aidaun jata ishamainun Tuke Pujuu ajuntug atumesh wainjumin ijinauwa annuk atum batsatmaunmak shiig atsutnai. Apajuí nunak emegkaktinai. Iman jata aina duka atumnak waitkagmaschagtinai, untsu tikich aents atumi shiwaajum aina nuna waitkasagtinai. ");
INSERT INTO agr_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","“Tuja tikich aents aina nunú ijinatajum tusa Tuke Pujuu atumi Apajuíjum tujamkuig, wait anentsuk ijinatajum. Tuja ditá apajuímtaijiya dukesh emematigpajum. Nunú nuniakjumek waitut igkugjum suugtatjume. ");
INSERT INTO agr_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“Tuja namputchawame, atum anentaimsajum, juju aents aina nunú iina nagkaetamsau kuashat aina imajush ¿itugkaik jiijaish utsagtaji? tumainaitjume. ");
INSERT INTO agr_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","¡Tujash ishamkaigpajum! Tuke Pujuu atumi Apajuíjum faraógkan egiptunmaya aents aidaujai itujuk ijinauwaita nunú adeagtajum. ");
INSERT INTO agr_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Atum Egipto nugkanum batsatutigmin Tuke Pujuu atumi Apajuíjum niina senchijin kuashat wainchatai aidaun atumesh wainjumin iwainag jiipajajua nunú anentaimtustajum. Tuja atumi shiwaajum kuashat asamtai ishamajum nunashkam Tuke Pujuu ijinattawai. ");
INSERT INTO agr_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","“Tuja nunú aents aidau atum ijinjumin ujumak uwemjau, tuja tupikaki uumkaju aina nunashkam ijinati tusa Tuke Pujuu ete múun aidaun ishitkattawai. ");
INSERT INTO agr_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Nuadui nunú aents aina duka ishamkaigpajum. Atumnak Tuke Pujuu atumi Apajuíjum senchigtina nunú uyuntamjume. ");
INSERT INTO agr_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Nunú aents aina nunak Tuke Pujuu diipas utsa utsakua emegkagtatui. Atumek juu tamawaikik, waamkek utsagkaigpa, dutika ajuminig nugka ankan wajasmatai, kuntin ikamia aina nunú yujaka waitkagmasainum. ");
INSERT INTO agr_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Tujash Tuke Pujuu atumi Apajuígmia nunú aents aina nunak atumin idaitugmastatui. Dutikau asa diipas utsa utsakua ashí emegkagtatui. ");
INSERT INTO agr_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Dutika utsagkam ditá apuji aina duka atumin yunumjagtatui, nuninakui atum ashí ijinajum emegkaktinaitjume. Dutikamu asa makichkish ayamjumainjig shiig atsujiagtinai. Nuadui atum ashí amuktinaitjume. ");
INSERT INTO agr_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","“Tuja ditá apajuímtaiji aina dushakam apea utsankatajum. Untsu nunú tsayakjumesh wainkajum oro aidau, plata aidau ayá nunú wakejukjum jukigpajum, nunú atumin waittan itagtamamtai waittsaijum. Wagki nunú aina nunak Tuke Pujuuk tsuumawai. ");
INSERT INTO agr_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Nuniau asamtai, Apajuí diisam, waji pegkegchau aina nuninuk atumi jeminig awayawaigpa, Apajuí atumnashkam ijipawainum. Wagki nunú waji aina duka shiig pegkegchau asamtai, tsaika utsagbau atatui.” ");
INSERT INTO agr_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“Tuja wi atum aidautigmin chicham umiktin agagbauwa nunú umiktajum tusan yamai tajim duka betek umiktajum. Nunú umiakjum iwaku batsamsajum kuashat yujaktinaitjume. Nuniakjum atumi apachjum aidaun Tuke Pujuu nugka amastajime tusa anagkuawa nuwi jegajum batsamsamnujum. ");
INSERT INTO agr_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","“Atum Egipto nugkanum batsatutigmin Tuke Pujuu atumi Apajuíjum jiipag jujamki cuarenta mijan uwegshunum awekapasua nunú makichkish kajimatkigpajum. Imaan mijan awekapasua nunak, ememataiji aidaun idaisatnume tusa, tuja nuigtu imanik waituinakush dekas mina chichamjunash umigtumainash aina tusa dekapjamak, dutijamauwai. ");
INSERT INTO agr_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Tuja kuashat tsawan nujantai waitiagminish, maná atumi wainchatain tuja atumi apachjum aajaku aina dukesh wainajakchamun Tuke Pujuu ayugtamauwai. Nunak dutikauwai wagki aentsuk ima yujumkanak yusagkek iwaku pujutsuk, Tuke Pujuu chichamejai pujumaina nuna jintinjamak. ");
INSERT INTO agr_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Cuarenta mijan yujasuitjum duwikish atumi jaanchjumek mamukchajui. Tuja atumi nawe aidaukesh iyagchajui. ");
INSERT INTO agr_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","“Nuadui Tuke Pujuu atumi Apajuíjum makichik múun niina uchijin jintintama numamtuk jintinjamawajua nunú anentaimtusjum diistajum. ");
INSERT INTO agr_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Nuniakjum niina chichame umiktin agagbauwa nunú betek umiakjum, Apajuí eme anentsajum diitajum. Tuja nii jintinjamamua dushakam imatiksagmek umiktajum. ");
INSERT INTO agr_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","“Wagki atumnak Tuke Pujuu atumi Apajuíjum jujamki nugka pegkeg paka tepetpetu ikamnum, entsa aidau, yumi pukuni jiinaidau, yumi initkanmaya aidau shiig kuashat ayaunum ejetamawagtatui. ");
INSERT INTO agr_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Nunú nugkanmak trigo, cebada, uva ajakbau, higuera aidau, munchi aidau, olivo aidau, dapa yumiji aidau aatus ayawai. ");
INSERT INTO agr_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Nunú nugkanmak atumek wajinak yuwatja tusagmek puyatchattagme. Tuja tikich waji aina dukesh puyatjukchattagme. Kaya aidaunmaya wainkatnaitjume hierro aidau, nuigtushkam mujanmaya taijum jiju cobre yajumtinaitjume. ");
INSERT INTO agr_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Tuja yutai yuwajum ejemagjum shiig aneasa pujakjumek, Tuke Pujuu atumi Apajuíjum kajimattsuk see titajum, nii nugka pegkejan amasu asamtai.” ");
INSERT INTO agr_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“Kuitamamkatajum Tuke Pujuu atumi Apajuíjiya nunú kajimatkijum. Niina chichame umiktin agagbauwa nuna wi jintintuajim nunú umitsuk idaisaigpajum. ");
INSERT INTO agr_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Tuja yutai yuwajum ejemagjum shiig aneasjum jega pegkeg jegamkamunum pujakjumesh, ");
INSERT INTO agr_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","nuigtu uwigjum aidau, bakajum aidau, oro aidau, plata aidau, nuigtu tikich wajijum aidau aatus kuashat kawegku wainkugmesh, ");
INSERT INTO agr_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ememakjum Tuke Pujuu atumi Apajuíjiya nunú atum Egipto nugkanum inaku waitkatai batsatutigmin jiipag, ");
INSERT INTO agr_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","jujamkiag uwejush ishamain dapi aidau, titig aidau ayaunum kuitamjamak, yumi atsutaish nii kayanmayan yumi jiiki uwagtinme tusa amasajua nunú kajimatkigpajum. ");
INSERT INTO agr_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Tuja nuigtushkam atumi ememataigmin idaimitkagmastatus, tuja nuigtu dekas mina chichamjunash umigtumainash aina tusa dekapjamak atumi wainchatain, tuja atumi muunjum aajaku aina dukesh wainajakchamun uwegshunum manán ayugtabauwai. Nunak nii dekapjamas pegkegnum yaimpaktag tau asa dutijamawajui. ");
INSERT INTO agr_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","“Wainka anentaimsajum: ‘¡Juju waji aina junak mina senchigjai imatikatsjash!’ tiigpajum. ");
INSERT INTO agr_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Nunak Tuke Pujuu atumi Apajuíjum atumi muunjum aajaku aina nuna anagkuamun umiak, jamamtuchu pegkeg batsamas takastinme tujabiu asamtai, pegkeg pujusa takakjum wajijinau asajum. Nuadui Tuke Pujuu atumi Apajuíjiya duka kajimatkigpajum. ");
INSERT INTO agr_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","“Untsu atum Tuke Pujuu atumi Apajuíjiya nunú umigtsuk, tikich apajuímtai aina nunú emematkugmek, duka ashí ijina utsam atatjume. Junak dekas uminkatnun tajime. ");
INSERT INTO agr_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Atum Tuke Pujuu atumi Apajuígmin chichame umigtsugminig, nii atumi shiwaajum aidaun ijinatta dutiksag atumnashkam ijipattawai.” ");
INSERT INTO agr_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","“Israel aents aidauwah, antuktajum: Namak Jordán katitkajum atumi shiwaajum aidau senchigtin, atum ainajum aan kuashat, yaaktajish múun peeja apakbau utumainchau aina nunú utuajum depetkatnuk tsawantak jegawai. ");
INSERT INTO agr_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Nuwiya aents aidauk múun esajam gigante Anac aajakua nunú wegantujai betek aidau batsatui. Tuja atumek dekagme yaunchuk aaja timauwa nunú: ¿Gigante Anac aajakua iman aents aina nunash yaki depetkainta? ");
INSERT INTO agr_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","“Tujash atumnak Tuke Pujuu atumi Apajuíjiya nunú kuitamjamsamtai shimajum nunú shiig dekau amainaitjume. Niig jii kegak ikagnamainchau ashí apeka weama iman asa, nunú aents aina nunak atumesh wainjumin ijinattawai. Tuke Pujuu atumi Apajuíjum tujabiuwa duka imatiksagmek utugchat atsau, nunú aents aidauk shiig wamak jiija utsaakjum ijinattagme. ");
INSERT INTO agr_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","“Tuke Pujuu atumi Apajuíjiya nunú atumi shiwaajum aidaun jiija utsaak nugka amasmataish: ‘See kuashat, ii ima pegkeg ainag duwi Tuke Pujuu juna nugkan amase’, tiigpajum. Wagki Tuke Pujuuk nunú aents aidaunak ditá pegkegchaujin utsagtatui. ");
INSERT INTO agr_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Tuja atum ima pegkeg asagminkish, atsa nuniachkush atum dekas ima shiig takau asagminkish wait anenjamu asag, nunú aents aina nunak jiijag utsagchattawai. Nunak ditá pegkegchaujin, nuigtushkam atumin apachjum Abraham, Isaac, Jacob aajaku aidaun anagkuawa nuna umiak dutikattawai. ");
INSERT INTO agr_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Juju shiig dekatajum: ¡Tuke Pujuu atumi Apajuíjiya nunú nugka pegkejan amastata nunak, atum ima pegkeg takau asagminkish amaschattawai! Atumek dekas chicham umichu intimkiu ainagme.” ");
INSERT INTO agr_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","“Uwegshunum batsamsajum Tuke Pujuu atumi Apajuíjiya nuna chichame intimjukiu ainajum nunú kajimatkitin aigpajum. Atumek Egipto nugkanum batsatutigmin Tuke Pujuu jiipajajua duwi nagkamsajum yamaishkam tuke intimjakjum ikaje yujagme. ");
INSERT INTO agr_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Nuigtushkam muja Horeb pujusjumesh pegkegchau takakjum Tuke Pujuu ikajkauwaitjume. Nuadui Tuke Pujuu atumin senchi kajegtamak ijipamain awagtamkabi. ");
INSERT INTO agr_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Tuja chicham umiktin agagbaun jukitasan wi mujá weamiajai. Nunikan yujumka yutsuk, umutnash umutsuk cuarenta tsawan nuigtu cuarenta kashi pujuyajai. ");
INSERT INTO agr_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","“Nunika pujai, atumesh ijunjajum diyagmin jii kegamunmaya atum chicham umiktinun Tuke Pujuu ujapakabi. Nunú chichaman jimag kaya pakamamunum nii agagbaun juki sujusabi. ");
INSERT INTO agr_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Nuwi cuarenta tsawan nuigtu cuarenta kashi ejeyi ai, Tuke Pujuu jimag kaya pakama najanamunum chicham umiktin aidau agagbaun sujusami. ");
INSERT INTO agr_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Nuna sujusa chichagtak: ‘Amina aentsjum aidau Egipto nugkanum batsatu jiigmayum duka wainak yujawai. Nuniau asamtai wamak wakitkita, wi dita aidaun juju umiktajum tusa tibaunak kajimatkiag idayinak jiju ukuijag nujai dita ememattinum najanawag batsamtuinawai’, tujutiabi. ");
INSERT INTO agr_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Tuja nuigtu chichagtak: ‘Juju aents aina junak shiig wainkagjai, ditak dekas chichaman shiig intimkiu ainawai. ");
INSERT INTO agr_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Nunin asagmatai amek dita aidauk chichamjukaipa, wi ditanak ijinan utsagtatjai. Dutika ai nugkanmak makichkish juwakchatnai. Tujash aminiyanak dita aina nuna nagkaesau kuashat aentsun ikaugkattajai’, tujutiabi. ");
INSERT INTO agr_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","“Tujutmatai jii kegamunum mujá pujaun waketkun, chicham umiktin agagbaun jukiamiajai. ");
INSERT INTO agr_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Nunika atum batsatbaunum jegakman, Tuke Pujuu umiktajum tujabau umitsuk wamak kajimatki idaikujum, jiju ukuijajum nujai toro tsakat dakumka najanajum batsamtautigmin wainkabiajime. ");
INSERT INTO agr_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Nunika kajekan, jimag kaya pakama najanamunum chicham umiktin aidau agagbau takakbaujun atumesh wainjumin nagkima ajiajan tsaikamiajai. ");
INSERT INTO agr_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","“Nuna dutikan atum yaunchuk pegkegchau takakjum Tuke Pujuu ikajkagmin, wi niina segaakun cuarenta tsawan nuigtu cuarenta kashi yujumka yutsuk umutnash umutsuk pujuyag imanisnuk ataktushkam Tuke Pujuu segaaku pujuyajai. ");
INSERT INTO agr_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Nuniakun atum aidautigmin nii senchi kajegtamak ijipatag takui puyatiajai. “Tujash Tuke Pujuu wi ataktu segamun antugtuku asa ijipachabi. ");
INSERT INTO agr_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Tuja Aarógnashkam Tuke Pujuu kajejuk maatag takui, wait aneasam maawaipa tusan ayamjukamiajai. ");
INSERT INTO agr_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Nuna dutikan nuadui, atum pegkegchau takakjum toro tsakat dakumka najanamugmin jukin jii kegamunum nagkiman patakamiajai. Dutika ai kuwigmatai, dekegka tsaika yukukuntu eman, nunú mujanmaya entsa akagunum ajugka ajapawamiajai. ");
INSERT INTO agr_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","“Tuja nuigtushkam Taberá nugka, Masá nugka, Quibrot-hataavá nugka aina nuwi pujusjumeshkam pegkegchau takakjum Tuke Pujuu ikajkauwaitjume. ");
INSERT INTO agr_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Atum Cades-barnea pujagmin Tuke Pujuu chichagtamak: ‘Wi nugka amasuitjim nuwi wetajum’, tusa tujamkuish atumek antugtsuk, nuigtush niiyai kajintsa anentaimchau asajum, nii tujabau umigkachuitjume. ");
INSERT INTO agr_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","¡Atumek yaunchuk nagkamsagmesh intimkiu, Tuke Pujuu umigchau ainajum nunak wika dekajime! ");
INSERT INTO agr_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","“Nunin asagmin Tuke Pujuu ijipatag takui, wi cuarenta tsawan nuigtu cuarenta kashi makichkish ayamtsuk shiig senchi Tuke Pujuu segaakun pujusamiajai. ");
INSERT INTO agr_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Nuwi pujusan niina senchi segaakun: ‘Tuke Pujuu Apajuíyah, ame tujinmainuk makichkish atsawai. ¡Nuadui juju amina aentsjum aidau, Egipto nugkanum batsatu amina senchigmijai jiijuitam duka, wait aneasam ijinawaipa! ");
INSERT INTO agr_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Tuja adeagta amina inakem Abraham, Isaac, Jacob aatus aajaku aina nunú. Nuniakum juju aents aina nuna umishtaiji, tuja dita pegkegchauji aina nujai tsagkujam wait anenjata. ");
INSERT INTO agr_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Wagki Israel aents aina juju ame ijinawaminig, egiptunmaya aents aidau chichagtamainak: “Apajuí Israel aents aidaun kajejau asa Egipto nugkanum batsatun jiija yajuak, nii nugka anagkuawa nuwi ejetsuk jintá uwegshunum ijina utsagke”, tujamain ainawai. ");
INSERT INTO agr_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","¡Tujash Israel aents aidauk amina aentsjum ainawai! Nuniau asamtai amina senchigmin Egipto nugkanum batsatu jiigmayume’, tusan tiyamiajai” tiuwai Moisés. ");
INSERT INTO agr_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","Tusa tai Tuke Pujuu chichagtak: “Jimag kaya pakamamu yama nagkamchak aajakua nujai betek tsupika umikta. Dutikam nuigtushkam chicham umiktin agagbau egkeatin arca najanata. Dutika nunú jukim mujá wakata wijai chichastasam, ");
INSERT INTO agr_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","nunikamin wi nunú kaya pakama najanamua nuwi chicham umiktin yama nagkamchaku agagbau ame ajiaja tsaikabium nujai betekan agagtajai. Dutikamtai arca numi najanamunum egkeam kuitamkattame”, tujutiabi. ");
INSERT INTO agr_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Tusa tujutmatai numi acacia tutaiyai arcan najanawabiajai. Tuja nuigtushkam jimag kaya pakamamun tsupika jukin mujá weamiajai. ");
INSERT INTO agr_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Nunika waka ai Tuke Pujuu nunú kaya pakama najanamunum diez chicham umiktin aidaun yama nagkamchak atumesh wainjumin ashí tuwaka ijunbaunum jii kegamunum tujabiuwa nuna imatiksag agag sujusabi. ");
INSERT INTO agr_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Dutika sujusmatai nuna jukin mujá pujaun wakitkiamiajai. Nunika jegaan arca najanamunum Tuke Pujuu dutikata tujutbaunak imatiksanuk egkeawabiajai. Duka yamaikish nuwi awai. ");
INSERT INTO agr_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Tuja wi yama nagkamchaku pujusamiag imanisnuk mujá cuarenta tsawan, nuigtu cuarenta kashi pujusamiajai, nunika pujusan Tuke Pujuu segabiajai, ijinawaipa tusan. Tusa sega ai yaunchuk antugtukua nunisag ataktushkam Tuke Pujuu mina antugtuku asa ijipachabi. ");
INSERT INTO agr_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Untsu ayatak mina chichagtak: “¡Wamak wakitkita, nunikam umintsam Israel aents aidau yajuakam, wi ditá apachji aajaku aina nuna nugka anagkuawaitag nuwi emata!” tujutmayi. ");
INSERT INTO agr_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Israel aents aidauwah, atumnash Tuke Pujuu atumi Apajuígmish yamaish ¿wajina segapainawa? Ima nigki eme anentsajum nii tabau betek umiktajum, dutikakjum aneetajum, nuniakjum atumi anentaimijai, wakanmijai ememattajum. ");
INSERT INTO agr_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Apajuí wakegawai chicham umiktin agagbauwa nuna umiktinme, nuninak shiig batsamsatnume tusa. ");
INSERT INTO agr_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Tuja nayaim aina duka, nayaimpi yakintin ayá dushakam, nuigtu nugka, tuja nugkanum ayá nujai ashí Tuke Pujuu atumi Apajuíjiya nudau aina nunú dekaatajum. ");
INSERT INTO agr_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Nunú imanuk ayaig, nuna etegmainaitak, atumi apachjum aajaku aina nuna aneau asa etegkauwai. Nuigtushkam kuashat aents tikich nugkanum ayau dekag nuwiyan etegmainaitak, atumi apachjum wegantunmaya aidautigmin mina aentsug atinme tusa etegtamjauwai. ");
INSERT INTO agr_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Nuniau asamtai anentainkachu atsuk, Tuke Pujuu atumjai chichaman umikua nunú shiig antukjum kajimattsuk aneaku atajum. ");
INSERT INTO agr_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Wagki Tuke Pujuu atumi Apajuíjiya duka tikich apajuímtai aina nuna nagkaesau, ashí apu aidaun Apujiyai. Niig dekas Apajuí múuntai, senchigtinai, tuja ishamainai, niig aents aidaunak etegka idaitsuk ashí betek kuitamnai, nuigtushkam wait anenjugti tusa akiamkesh amaitsui. ");
INSERT INTO agr_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Niig bitaik aidaun, waje aidaun wait anentau asa kuitamui, tuja nuigtushkam tikich nugkanmaya aidau atum batsatbaunum pujuina nunashkam aneau asa, yutain, nugkutaijai suwawai. ");
INSERT INTO agr_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Nuadui atumek aents tikich nugkanmaya aina nunú aneetajum, wagki atumshakam egiptunmayachuitkujum Egipto nugkanum batsamajakuitjume. ");
INSERT INTO agr_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Tuke Pujuu atumi Apajuígmia duke ememattajum, nuniakjum ima nigki umigkatajum. Tuja atum umiktina nunú dekas takugmek ima Niina daajinig titajum. ");
INSERT INTO agr_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Wagki Apajuík dekas múuntai. Iman asamtai, ima nigki emematuinaji. Niyai atumi Apajuíjig, nuniau asa atum aidautigmin ayamjutpak, wainchatai ishamain aidaun iwainajua nunú wainkauwaitjume. ");
INSERT INTO agr_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Atumi apachjum aidau Egipto nugkanum jegawaju aina duka setenta aentsuk aajaku ainawai. Tujash yamaik, Tuke Pujuu atumi Apajuíjiya nunú shiig kuashat ikauntamak, yaya nayaimpinum ayá ibau kuashat awajtamsaugme. ");
INSERT INTO agr_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","“Atumi apachjum aajaku aina nuna nugken Tuke Pujuu atumi Apajuíjum amastata nuwi jegá pujusjum, chicham tuke umiktina duka juju ainawai. ");
INSERT INTO agr_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","“Nunú nugkanmaya aents aidau atum utuajum depetkattajum nuna ememattaiji aidau muja aidaunum, nain aidaunum, nuigtu numi múun dukentin aidaun wakentin ayá nujai ashí tsaigkajum utsankatajum. ");
INSERT INTO agr_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Tuja dita apajuímtaijin emematuinak kuntin maa patasa apetai dita najankamu aina duka tsaigkatajum. Nuigtu kaya aidau, numi múun kampujam tsupikbau aidaun aatus dita emematuina duka ashí tsaigkatajum. Tuja nuigtushkam dakumka najanamu ditá apajuímtaiji aina dushakam dutiksagmek tsaika utsankatajum. Dutikamu asa makichkish atsusti. ");
INSERT INTO agr_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Tikich aents aidau ditá apajuímtaijin emematuinak wajina dutikin ainawa, nujai betekak atumek Tuke Pujuu atumi Apajuíjum emematkugmek dutikawaigpa. ");
INSERT INTO agr_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","“Tuja atum maki makichik wegantu ainajum nuna nugke aina nuwiyan Tuke Pujuu makichik etegkattawai nii pujustinun. Dutikamtai nuwi wejum Apajuí ememattajume. ");
INSERT INTO agr_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Nuwi kuntin maajum nuna neje ashí apeakjum Apajuí ememattatjume. Tuja nuwi weakjumek, diezmo, tuja atum Apajuí susatasa anagkuamu, tuja atumek anentaimsajum anentag Apajuí suwamu, nuigtu baka uchiji yama nagkamchaku petsakbau, uwija uchiji yama nagkamchaku petsakbau aatus jukijum wetajum. ");
INSERT INTO agr_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","“Nunika nuwi jegajum Tuke Pujuu atumi Apajuígmi emtin yutai yuwattagme. Tuja Tuke Pujuu atumi Apajuíjum yaimpasmatai atumi ajakjum aidaush, tagkujum aidaush kuashat kawegku asamtai, nunú yuwakjum pataim aidaujai ijunjajum shiig aneastinaitjume. ");
INSERT INTO agr_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","“Tuja Tuke Pujuu makichik nugká etegkatta nuanuig, yamai atum wakegamu takajum duka dutikashtatjume. ");
INSERT INTO agr_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Tujash Tuke Pujuu atumi Apajuíjum nugka pegkeg agkan atum pujustinun amastata nuwig eke jegatsjume. ");
INSERT INTO agr_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Tuke Pujuu atumi Apajuíjum nugkan amastata nuwi namak Jordán katitki jegajum pujuttajum nuwig, atumi shiwaajum yamai waitkagmaina dutika waitkamak achattagme. Nuadui atumek ishamkagtutsuk pujutnaitjume. ");
INSERT INTO agr_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","Nuniau asamtai wi Apajuí tibaun yamai tajim juka jega pegkejam jegamkatnun Tuke Pujuu atumi Apajuíjum nugka etegkatta nuwi betek umiktatjum duka juju ainawai: Apajuí emematku kuntin maa nuna neje ashí apeamu, diezmo aidau, tuja Tuke Pujuun susatjai tusa etegjamu aidau aatus. ");
INSERT INTO agr_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Nunú umiakjum Tuke Pujuu atumi Apajuígmia nuna emtin atumi uchijum aidaujai, inakem aidaujai, Leví wegantu aidau nugkenchau atumjai batsata nujai ijunjajum shiig aneakjum dakujustajum. ");
INSERT INTO agr_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","“Kuitamamkatajum, tikich yantamnum yujasjum Apajuí emematji tusajum kuntin maa apé yujaijum. ");
INSERT INTO agr_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Duka nunitsuk Apajuí atum wegantu aina nuna nugkenian makichik etegkatta nuwi, wi yamai atumi tajim duka dutikattagme. ");
INSERT INTO agr_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Untsu atumi yaaktajin pujusjum neje yuwatag tusa wakegakjumek, kuntin atumdau aina nunú maajum japa nejejai betek yumainaitjume. Apajuí atum aidautigmin kuntin ikamian, nuniachkush tagkumtai aidaun amastata duka sacerdote Apajuín sega pegkemtijuamtai yuwatjai tusajum dakatsuk, pegkemtikachbau akugmesh, atum wakegakjumek maajum yuwatajum. ");
INSERT INTO agr_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Untsu kuntinu numpe aina duka yuwawaigpajum, ayatak yumi ukaja ajaptayama dutika ajapatajum. ");
INSERT INTO agr_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","“Untsu trigo, vino, aceite aina nuwiya diezmo Apajuí susatin jukimu aina duka atumi yaaktagmin pujusjumek yuwawaigpajum, nuigtushkam baka aidau, uwig aidau yama nagkamchaku petsakbau aina dushakam yuwawaigpajum. Tuja Apajuí anagkuamu aidau nuniachkush Apajuín anentag susatjai timau aina atumi yaaktagmin pujusjumek dushakam yuwawaigpajum. ");
INSERT INTO agr_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Untsu Tuke Pujuu atumi Apajuíjum nugka etegkatta nuwi niina emtin atumi uchijum aidaujai, inakem aidaujai, Leví wegantu atumjai batsata nujai aatus ijunjajum nunú yuwattajume. Tuja Apajuí yaimpasmatai atumi ajakjum aidaush, tagkujum aidaush kuashat kawegku asamtai, shiig aneasjum dakujustajum. ");
INSERT INTO agr_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Apajuí nugkan amastata nuwi batsamsagmesh, Leví wegantu aidau makichkish kajimatki idaisaigpajum. ");
INSERT INTO agr_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","“Tuke Pujuu atumi Apajuíjum nugka muuntan amastinaitjime tusa tujabiuwa nuna imatiksag amasmatai pujusjum, neje yuwatag tusa wakegakjumek, puyatjutsuk atum wakegamu yuwatajum. ");
INSERT INTO agr_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Tuja Tuke Pujuu atumi Apajuíjum emematku ijuntai atinun nii nugkan etegkatta nunú atushtaitkuig, atumdau baka aidau, uwig aidau, Apajuí amasbau aina duka atum batsatbaunmak maajum nuwig pujusjum, wi atumin timajim dutiksagmek atum wakegamu yuwatajum. ");
INSERT INTO agr_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Sacerdote Apajuín sega pegkeemtijuamtai yuwatjai tusajum dakatsuk, dutikachbau akugmesh japa neje yumaina dutiksagmek yuwattagme. ");
INSERT INTO agr_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Untsu kuntinu numpe aina duka makichkish yuwawaigpajum, wagki numpanum pujut au asamtai. Nunin asamtai, pujuta duka nejejai apatkaik yumaitsui. ");
INSERT INTO agr_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Nuadui yumi nugká ukaja ajaptayama dutika ukaja ajapatajum. ");
INSERT INTO agr_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Nunú numpa yutsuk idaikugmek, Apajuí emtin pegkeg takau asajum, atumi uchijum aidaujaí shiig pujustinaitjume. ");
INSERT INTO agr_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","“Tuja Apajuín anentag susatjai tusa anentaimtugbau aina nunú, nii susatin anagkuamu aina nujai jukijum Apajuí emematku ijuntai etegkamua nuwi ejegatajum. ");
INSERT INTO agr_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Dutika ejegajum nuwi kuntin maajum nuna neje altarnum pataijum ashí apeakjum Apajuí ememattajum. Kuntin aidaun numpega duka altar ukatkatajum. Untsu nuna nejega duka yuwatajum. ");
INSERT INTO agr_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","“¡Wi atumin inajim nunú shiig antukjum betek umiktajum, nunú nuniakjum Apajuí emtin pegkeg takau asajum, atumi uchijum aidaujaí shiig pujusminjum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Moisés Israel aents aidaun ataktu chichajak: “Tuke Pujuu atumi Apajuíjum nugkan amastata nuwiya aents aidaun ijina nugkan amasmatai jegajum pujusjumesh, ");
INSERT INTO agr_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","nuwiya aents aidau ditá apajuímtaijin wajuk emematin ainawa nunú dekatag tusagmek ¡atumek makichkish inima yujaigpajum! Nuní yujasjum atumshakam nunú emematijum. ");
INSERT INTO agr_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Tikich aidau apajuí emematji tusag dakumak najanawag emematuina dutikagmek Tuke Pujuu atumi Apajuíjiya duka emematigpa, wagki nunin aina duka ditá apajuímtaijin emematuinak, ditá uchiji aidaun maawag jinum apen ainawai. Nunú dutikamua duka Apajuí diismak shiig pegkegchauwai. ");
INSERT INTO agr_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","“Wi juna tajim duka atumek nuwi ekekjumkesh ematsuk, tuja nuigtush esakagjumkesh emegkautsuk, betek umiktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","“Namputchawame atum ainajum anuiya makichik aentskesh Apajuí chichamen etsegjai tusa kajanmayan dekau wekagas chichagtamak: ‘Wika dekajai wainchatai aidau atak nagkaemagtata nunak’ tusa tujabauwa, ");
INSERT INTO agr_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","nunú betek imaanisag umintai chichagtamak: ‘Atumi wainchatai, tikich apajuí aina nunú emematmi’, tusa tujamainakuish, ");
INSERT INTO agr_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","duka antugkaigpajum. Wagki nunak Tuke Pujuu atumi Apajuíjiya nunú, dekas minash ashí ditá anentaijijai, wakanijai anentuinawash tusa dekapjamsatatus dutijamawagtatui. ");
INSERT INTO agr_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Tuke Pujuu atumi Apajuíjiya duke nemagkujum ajaantusjum diitajum. Nuniakjum chicham umiktajum tusa tujamauwa nunú betek umigkatajum. Niina chichame antugkajum umigkatajum, nuniakjum ima niiyaig sumitkau atajum. ");
INSERT INTO agr_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Tuja nunú aents Apajuí chichamen etsegjai tusa, kajanmayan dekau wekaga duka maatajum, wagki atum Egipto nugkanum waitkam batsatutigmin Tuke Pujuu atumi Apajuíjum agkanmitkagmawajua nujai shiwagmitkagmatatus wakegau asamtai. Nunú aentsua duka Tuke Pujuu atumi Apajuíjum chicham umiktajum tujamauwa nuna datumtijamatag tiuwai. Nunin asamtai nunú aents pegkegchau aidau atumjai batsata duka ijina emegkagtajum. ");
INSERT INTO agr_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","“Amina yatsumkesh, amina uchigmekesh, nawanjumkesh, atsa amina nuwem aneetaigmekesh, nuniachkush amina shiig kumpagmekesh wakenmataik chichagtamak: ‘Apajuímtai tikich aidau ame wainchatain, tuja amina apakesh wainajakchamun emematmi’ tusa, ");
INSERT INTO agr_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","nuwiya aents aina nuna apajuímtaiji aidau atum pujamunum tikiju, nuniachkush atushat ashí tikich nugka aidaunmash ayá nuninun pachis wakenmataik tujamainakui, ");
INSERT INTO agr_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","nunú antugkajum umigkaigpajum. Duka makichkish wait anenjaigpajum. Tuja waittsai tusagmesh puyatjukaigpajum, nuigtush uukaigpajum. ");
INSERT INTO agr_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Duka dutiktsuk maatajum. Tuja dekatkauk, amea kayai tukua tukuakua maattame. Dutikawamin tikich aidaushkam dutiksag maawagtatui. ");
INSERT INTO agr_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Apajuí Egipto nugkanum inaku waitkatai batsatutigmin jiigmajajua nujai datumtamain awagtamkau asamtai, duka kayai tukua tukuakuajum maatajum. ");
INSERT INTO agr_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","¡Nunú dutika ajumin ashí Israel aents aidauk nuna dekawag ishamkagtatui, nunikag ataktu awagkig nunin pegkegchau aina nunak takaschagtatui!” ");
INSERT INTO agr_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Moisés Israel aents aidaun chichajak: “Atum nugka jukittajum nuwiya aents aina duka anentaimsa atak atinun dekajai tinu aina nuna antuju yujau ainawai. Tujash atumnak Apajuík nuninun takasainum tusa dakitawai. ");
INSERT INTO agr_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Nuadui Tuke Pujuu atumi Apajuíjiya nunú atum wegantu ainajum nuwiyan makichik profeta witag imajun etegkattawai. Dutikamtai nunú umigkattagme. ");
INSERT INTO agr_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Atum aidautijum muja Horebnum ijunja batsamsajum Tuke Pujuu segaakjum: ‘Tuke Pujuu iina Apajuíji ataktu chichaakui antutak ishamaji, nuigtushkam jii kega ibau waintash dakitaji jinawaig tuidau asa’ tuyugme. ");
INSERT INTO agr_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Tusa tajumin Tuke Pujuu mina chichagtak: ‘Dita tuina duka dekas pegkejai. ");
INSERT INTO agr_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","“ ‘Wi dita aina nuwiyan makichik mina chichamjun etsejin amejai betekan dita wegantunmayan etegkattajai. Dutikan wiki nii chichaktinnak jintintuattajai. Nuadui wi tabaun juki etsegtatui. ");
INSERT INTO agr_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Tuja nuna chichamen antugkachaju aidaunak wi suwimkan susattajai. ");
INSERT INTO agr_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","“ ‘Tuja chichama etsejin wi inagchamaitak, wainak mina daajun pachis chichaushkam, mantamnattawai. Tuja tikich apajuímtai aina nuna daajin wekagas chichaman etsejushkam nunisag mantamnattawai.’ ");
INSERT INTO agr_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","“Atum anentaimsajum: ‘Tujash dekas Tuke Pujuu tibaunash etseja tusaish ¿wajuk dekamainaita?’ tusa takugmek juju dekatin atajum. ");
INSERT INTO agr_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Nunú wekagas atak atinun etsegkatta nunú betek uminchakuig, dekas Tuke Pujuu awemachmawaitkumpap ememak tuu wekaewa tusajum dekattagme. Nuadui nunú aina duka ishamkaigpajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","“Makichik aents wi wainkamjai takuig dekaskeapi tiigpajum. Untsu jimagkesh, nuniachkush kampatumkesh, ii pegkegchaun takau wainkamji tusa tuinakui, nuadui nunú aents pegkegchau takamsauwa duka suwimak sumainaitjume. ");
INSERT INTO agr_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","“Makichik aents wait wekagas, tikichin chichajak: ‘Juju aents pegkegchaun takase’ tusa tsanumjakuig, ");
INSERT INTO agr_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","duka mai jukijum aak Apajuíjai chichatainum sacerdote aidau, apu chichama epegkin aidau aatus batsata nuwi ejegatajum. ");
INSERT INTO agr_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","Dutika ajumin, chichama epegkin aidau emamkemas shiig dekajuawagtatui. Dutika dekajam dekaskenum jegachmataig, ");
INSERT INTO agr_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","tsanumjuja ai suwimka susatnume tukama tsanumjauwa nunú nigki suwimkanak jukittawai. Aatsa dutikakjum aents pegkegchau aidau atumjai batsata duka ijina emegkagtajum. ");
INSERT INTO agr_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","Nuna dekaawag tikich aidaushkam ishamainak tsanumat pegkegchau aina nunak idaisagtatui. ");
INSERT INTO agr_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Nunú aents aina duka atumek wait anenjaigpajum. Aents magkagtauk atumshakam dutiksagmek maatajum. Aents tikichi jiin emestauk atumshakam dutiksagmek emestugtajum. Aents tikichi naín emestauk atumshakam dutiksagmek emestugtajum. Aents tikichi uwejen tsupijuk atumshakam dutiksagmek tsupigkatajum. Aents tikichi nawen tsupijuk atumshakam dutiksagmek tsupigkatajum” tawai Apajuí. ");
INSERT INTO agr_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","“Makichik aents nuwena pujau niina nuwe shiig pujachbaun dekajua ajapatag takug, ajapdayatag tusa umitain papii umika nuwen susa idaimainai. ");
INSERT INTO agr_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","“Dutika ajapamak tikich aentsjai aishinmainai. ");
INSERT INTO agr_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","Tuja tikich aents nuna juki pujau dakitak ajapatag takug, dakitajai tusa, papiin umika susa idaimainai. Untsu nunú aishi jakamtaig, ");
INSERT INTO agr_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","yama nagkamchak nuwatkauwa duka ataktu awagkig nuwatmaitsui, wagki nuwa pegkegmachu asamtai. Nunú nuniamua nunak Tuke Pujuu dakitawai. Nuniau asamtai atum aidautigmek nuninuk takasaigpajum. Atum nuniakjum Tuke Pujuu atumi Apajuíjum nugka amastata nunú pegkegchau emaijum.” ");
INSERT INTO agr_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","“Makichik aents yama nuwena pujauk maaniamunmak wechattawai. Nuigtushkam tikich takat aina nunashkam takatsuk makichik mijan pujustatui. Aatus niina nuwejai shiig aneas, yainiak shiig agkan niina jeen pujuttawai. ");
INSERT INTO agr_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","“Atumin diwimjamkatag takuish, trigo chimpia dekeetai kaya ajutjama nunú sujusta, akigkumin awagtuktagme tusagmek jujukigpajum. Nunú dutikakjumek niina pujutji atanmaina numamtin asamtai. ");
INSERT INTO agr_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","“Makichik aents Israel aentskesh nii wegantunak pempeentuki achika juki, niina inaku waitkataiji ematatus, nuniachkush tikich nugkanum sujuktatus wekagu wainkugmek, duka maatajum. Dutikajum aents nuninun takau aidau atumjai batsata duka ijina emegkagtajum. ");
INSERT INTO agr_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","“Tuja lepra achiimakjum jakjumek, sacerdote Leví wegantu aidau wajinjutpatig nunú betek umiktajum. Nuniakjum wi atum umiktinun jintintuawaitjim duka ashí betek umiktajum. ");
INSERT INTO agr_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","Atum Egipto nugkanum waitkam batsatutijum jiinjajum shimagmin, jintá Tuke Pujuu atumi Apajuíjum Marían suwimka suwak itugkauwaita nunú aneaku atajum: Niig Apajuíjai shiwagmagau asa, suwimkan juwak lepran achiimakui. ");
INSERT INTO agr_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","“Tuja atum ijutkamunmaya kuichik tsagkatkugmesh, wi kuichkin tsagkatjam nunú akigkumin awagtuktagme tusajum niina jeen wayagmek niina wajijig jujukigpajum. ");
INSERT INTO agr_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","Ayatak agá wajasjum dakastajum, nuniagmin nii juki amastí. ");
INSERT INTO agr_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","“Tuja aents ujudauch kuichik tsagkatjukta tusa niina jáanchjin amastata duka kashin awagtuktagme tusagmek emetjuawaigpa. ");
INSERT INTO agr_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","Duka dutiktsuk nunú tsawantaik etsa akagai wamak awagtuktajum. Dutikam nuna asepak kanagti. Nuniak nii Apajuín segatjamtatui atumin yaimpakti tusa, aatsa atum dutikamua nunú Apajuín shiig awagbau asamtai. ");
INSERT INTO agr_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","“Aents ujudauch aidau, atumi pataim aidaukesh, nuniachkush tikich nugkanmaya atumi yaaktaji aina nuwi pujuidauk wainka akitsuk takamtikkujum waitkasaigpa. ");
INSERT INTO agr_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","Duka dutiktsuk nunú tsawantaik nii takasbaujiniag akiktajum, wagki niig ujudauch asa sumak yuwatatus atsumawai. Untsu nunú betek umiatsjuminig, nii Tuke Pujuun segattawai atumin suwimkan amastinme tusa. ");
INSERT INTO agr_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","“Múun uchigtin aina duka, niina uchiji aidau pegkegchau takamsamujinig maamak amaitsui, tuja uchi aina dushakam ditá apaji aidau pegkegchau takamsamujinig maamak amaitsui, ayatak maki makichik dita pegkegchau takasbaujin maam agtatui. ");
INSERT INTO agr_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","“Bitaik aidaush, tikich nugkanmaya aidaush wainka waitkasaigpajum. Duka dutiktsuk dita atsumainakuig yaigtajum. “Tuja waje kuichik tsagkatkugmesh, akigkumin awagtuktagme tusagmek niina jáanchjig jujukigpajum. ");
INSERT INTO agr_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","“Atum Egipto nugkanum makichkish ayamjumamainchau inaku waitkatai batsatutigmin Tuke Pujuu atumi Apajuíjum jiipajua nunú kajimattsuk aneaku atajum. Nuadui wi atum aidautigminak juju ashí umiktajum tusan tajime. ");
INSERT INTO agr_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","“Tuja trigo juwamunum makichik trigo jigkamu kajimatkigmesh waketjukmek jukigpajum. Duka idaisatajum aents tikich nugkanmaya aidau, waje aidau, bitaik aidau nuna juki yuwatnume. Aatsa dutikagmin Tuke Pujuu atumi Apajuíjum takatjumin pegkegnum yumigtamsattawai. ");
INSERT INTO agr_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","Olivon neje juwaakjumesh, kanawen ampinjau juwaktata duka waketjukmek juukaigpajum. Duka idaisatajum aents tikich nugkanmaya aidau, waje aidau, bitaik aidau nuna juuká yuwatnume. ");
INSERT INTO agr_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","Uva ajakbaunmaya nuna neje uva juwaakjumesh, ampinjau juwaktata duka waketjukmek juukaigpajum. Duka idaisatajum aents tikich nugkanmaya aidau, waje aidau, bitaik aidau nuna juuká yuwatnume. ");
INSERT INTO agr_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","Wagki atumshakam Egipto nugkanum inaku waitkatai batsamajakuitjum nunú aneaku atajum. Nuadui wi atum aidautigminak juju chicham ashí umiktajum tusan tajime.” ");
INSERT INTO agr_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","“Aents utugchatjin diták epegmainchau dekapenakug, chicham epegkeaku ijuntainum suwimka jukiagtatus weagtatui, nunikmatai chichama epegkin shiig dekajua, yakita utugchatjinnush nuna suwimka suwak tikichnak akupkattawai. ");
INSERT INTO agr_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","Aents utugchatji aja nunú asutnati takug, chichama epegkin aidau nugká aepsatajum tusa tima aepsagmatai, nii pegkegchau takamsamujin diijus suwimka suwinak asutiawagtatui. ");
INSERT INTO agr_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","Tujash nunú aents utugchatji aja nunak cuarentaya nuna ewaekag asutiachagtatui, wagki imatika asutiamak suwimak shiig múun asamtai, atumi pataim datsan diimain asajum. ");
INSERT INTO agr_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","“Tuja toro trigon dajag akaak wekaeta nuna wenig jigkatuawaigpa yuwati.” ");
INSERT INTO agr_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","Jimag uchi akiamu makichik nugkanmak pujuidau niina yachi nuweena uchin akiitsuk jakamtaig, wajea duka tikich aentsjaig aishinmaitsui, ima niina wajejiya duke niinak nuwatmainai. Dutika nuwatuk uchin akia, niina yachi uchijiya nunin emattawai. ");
INSERT INTO agr_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","Nuadui yama nagkamchak nuwa uchi aishmagkun uchigmaktata nunak niina yachi daaji aajakua nuna adaikattawai, wagki nuna daaji Israel aents aidaunum megkaekai tau asa. ");
INSERT INTO agr_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","Untsu nuwatkashtatjame tusa niina wajeji dakitamak, chicham epegkeaku ijuntainum jeganta Israel aents aidaun apuji aidaun chichajak: “Mina wajejuk niina yachi daajiya nunú Israel aents aidaunum megkaekai tutan dakitawai. Nuniau asa mina nuwatjutan dakitawai”, tumainai. ");
INSERT INTO agr_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","Tusa timatai apu aidau nuna untsukag, niijai chichamain ainawai. Untsu tusa tama, nii chichaak: “Wika niinak nuwatkashtatjai”, tusa tutaik, ");
INSERT INTO agr_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","Israel aents aidaun apuji aidau wainbaunum, nuwa niina wajejin jegantun sapat wegamakbaujin makichik jujuktatui, dutika yapinum usukia chichajak: “¡Aaja jutiktaya aents wajejin juki niina yachi uchiji atinun akiitan dakitauk!” titatui. ");
INSERT INTO agr_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","Dutikamu asamtai nuna patayi niina jeen batsata duka Israel aents aidaunmak “sapatji atankimu” tutai agtinai. ");
INSERT INTO agr_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","Tuke Pujuu atumi Apajuíjum nugka atumdau atinun amasagtata nuwi jegajum pujusjum, ");
INSERT INTO agr_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","ajak ajakmattajum nunú nejekmatai, yama nagkamchaku juuktatjum nunú makichik chagkinnum chimpia jukijum Apajuí ememattai atinun nii etegkauwa nuwi ejegatajum. ");
INSERT INTO agr_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","Dutikajum sacerdote puja nunú chichagkujum: “Wi mina Apajuíju emtin titatag nuna ashí tikich aidaush antuktinme: wika yamaik mina apachug aajaku aina nuna Tuke Pujuu Apajuí chichajak: Ame wegantu aidaun nugka susatnaitjai tusa anagkuawa nuwi taa pujajai”, titatme. ");
INSERT INTO agr_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","Tusa tiyamin nunú chagkinnum aimka ejeentamun sacerdote juki altarnum ejeenta nuna niimtika apusattawai. ");
INSERT INTO agr_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","Dutikamtai Tuke Pujuu amina Apajuígmi emtin ame chichaakum: “Mina apachug arameo aents aajaku aina duka kuashtachu, nuigtush nugkenchau yujajaku ainawai. Nunik yuja yujakua Egipto nugkanum shiyakag nuwi batsamsajui. Nuwi kuashat tsawan batsamas shiig kuashat yujakag senchigtin wajasajui. ");
INSERT INTO agr_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","Tujash egiptunmaya aents aidau shiig kuashat waitkagmasu ainawai. Dutijamainak wainka inatai etamiag waitkagmasajui. ");
INSERT INTO agr_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","Imatijamainakui Tuke Pujuu iina apachji aajaku aina nuna Apajuíji yaimpakti tusa segayaji. Nunú ii sumamun antugtamak, nuigtushkam inapainakui takainaku kuashat waituinamun waipaku asa, ");
INSERT INTO agr_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","niina senchijijai ishamain wainchatai aidaun iwainag, Egipto nugkanum batsatutin jiipagmayi. ");
INSERT INTO agr_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","Dutika jiipag jujamki imajui itagmauwai. Dutika itagma juju nugka pegkeg ajak shiig tsapaa imajun amase. ");
INSERT INTO agr_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","Nunú nugkan Tuke Pujuu Apajuí sujusua nuwi ajakmamunmayan yama nagkamchaku juukbaun juki itaajai”, titatme. Tusa tamawaik chagkinnum ajak juuka aimkamu pujau jukim altarnum ejeentam apusattame. Dutikam nuwi Tuke Pujuu amina Apajuígmi emtin tikishmaja pujustatme nii emematkum. ");
INSERT INTO agr_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","Nunika emematim, amina pataim aidaujai, Tuke Pujuu amina Apajuíjum atumin amasbau aina nunú anentaimtusam shiig aneakum jiistamata. Nuniamin Leví aents aidau, tuja aents tikich nugkanmaya atumjai batsata dushakam, atumjai ijunag jiistamatnume. ");
INSERT INTO agr_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","“Mijan kampatuma nunú jegamunum Tuke Pujuu susatin diezmo jukitajum tusa timauwa duka, ashí ame ajak ajakmamua nuwiya akanja umikta. Dutikam Leví wegantu aidau, aents tikich nugkanmaya aidau atumjai batsatu, tuja bitaik aidau, waje aidau aatus atumi yaaktaji aidaunum batsamas, dita wakegamun yuwatnume tusam ashí susata. ");
INSERT INTO agr_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","Dutikam Tuke Pujuu amina Apajuígmi emtin chichaakum: ‘Wi ajakmamu aina nuwiya juuka ijumjamunmayanak, diezmo Tuke Pujuu susatnun akankajai. Nuna Leví wegantu aidaun, tikich nugkanmaya jutijai batsata nuna, bitaik aidaun, waje aidaun aatsan ashí tinamkajai, ame umikta tujutbauwa nunak ewaetsuk, nuigtush makichkish kajimattsuk. ");
INSERT INTO agr_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","Tuja nunú diezmo akankamua nunak jakamunum buutku pujaknush, pegkegchau wajasa pujusnukesh, makichkish yuwachmajai. Tuja jakau aina nunakesh anagkuachmajai. Tuke Pujuu mina Apajuíjuh, wika ame umikta tujutbaunak betek ashí umikjai. ");
INSERT INTO agr_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","Amek nayaimpinum amina pujutaijum pegkegma nuwi pujusam, amina aentsjum Israel aents aidau ame nugka pegkeg shiig ajak tsapau susamua nuwi batsata nunú pegkegnum yumigkiakum, iina apachji aajaku aina nunú anagkuawaitam dutiksamek kuitamkagtukta’ titatme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","“Tuke Pujuu atumi Apajuíjiya nunú chicham umiktin aina nuna umiktajum tusa yamai tujamainawai. Nunú betek atumi anentaimjai, wakanmijai umiktajum. ");
INSERT INTO agr_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","Apajuík dekas iina Apajuíjiyai. Nuadui atum chichaakjum: ‘Nii tujabauwa duka betek umikagmi, nuniaku niina chichame umiktin agagbauwa dushakam tuke umiktin agmi’, tusajum yamai tiugme. ");
INSERT INTO agr_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","Nuadui Tuke Pujuushkam nii anagtamauwa nunak imatiksag yamai chichaak: ‘Israel aents aidauk tikichdauk amaitsui, ima mina aentsjuk ainawai’, tujamui. Nuadui niina chichame umiktin agagbauwa duka betek umiktajum ");
INSERT INTO agr_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","Tuja atum ima nigki umigkugmek, tikich aents aidau nii najankamu batsata nuna nagkaesau shiig kuashat, senchigtin, ajaantusa diitai atatjume, tusa Tuke Pujuu atumi Apajuíjum tujamui.” ");
INSERT INTO agr_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","Moisés Israel aents aidaun chichajak: “Atum Tuke Pujuu atumi Apajuíjum umigjuminig, nii pegkegnum yumigtamsagtinai. Untsu atum nii umigtsugminig, pegkegchaunum yumigtamjagtatui. Tuja atum betek umigtsugminig, atumi nugken ukumtijamki atushat tikich nugkanum ajapjamawagtatui. Dutijamawagmatai nuwi pujusjumesh, wi yaunchuk tibaijim nunú yamai tajim nujai adeagtin atajum. Nuniakjum, ");
INSERT INTO agr_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","pegkegchau takatak idaikujum wi tajim dutiksagmek, atum aidautijum uchijum aidaujai betek ataktu Tuke Pujuu atumi anentaimijai, wakanmijai umigkatajum. ");
INSERT INTO agr_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","Nuniagmin Tuke Pujuu atumi Apajuíjiya nunú suwimka amamainun wait anenjamag pegkegnum yaimpakagtinai. Nuadui Apajuí atumin suwimkan amaak, shiwag depetuk yajuaktinme tibau umintai, depetamak yajupakagmatai, tikich nugkanum batsatutigminash Tuke Pujuu awagtamkiag nii nugkan amasua nuwi itagmawagtinai. ");
INSERT INTO agr_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","Tuja atumi shiwaajum aidau depetamak yajupakagmatai pampagjum, tikich nugkanum shiig atushat batsatutigminash, Tuke Pujuu atumi Apajuíjiya nunú yajupak, ");
INSERT INTO agr_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","atumi apachjum batsamajakua nuwi ataktu awagtamki itagmawagtinai. Dutijamawagmatai atum yaunchuk batsamajakuitjum nuwig batsamsatnaitjume. Nuwi batsamsajum Tuke Pujuu yaimpasmatai, takatjumin emkatnaitjume. Nuniakjum atumi apachjum uchigtin aajaku aina nuna nagkaesau kuashat uchigtin atinaitjume. ");
INSERT INTO agr_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Tuke Pujuu atumi Apajuíjum atumjai, tuja atum wegantu agtinjai chichaman umikua nunú kajimattsuk aneaku atajum. Nuniakjum atumi anentaimijai, wakanmijai Apajuí aneau asajum iwaku pujusminjum. ");
INSERT INTO agr_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","“Tuja atumi shiwaajum aidau kajegtamainak, aintamiagtina nunú waittsatnume tusa Tuke Pujuu atumi Apajuíjum ditan pegkegchaunum yumigjatnai. ");
INSERT INTO agr_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","Dutikamtai atumek Tuke Pujuuwai ataktu wakitkijum nii umigkatnaitjume. Nuniakjum chicham umiktin agagbauwa nuna wi yamai umiktajum tajim nunú ashí umiktin atajum. ");
INSERT INTO agr_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","Nuniagmin Apajuí atumi takatjumnash, uchigminash, tagku tsakapatnumash, ajak ajakma juutnumash kuashat ikauntugmaktinai. Nuna Tuke Pujuu atumi Apajuíjum diisa shiig aneastinai, wagki yaunchuk atumi apachjum aajaku aina nuna yaigkua dutiksag atumnashkam yaimpau asa. ");
INSERT INTO agr_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","Aatus shiig anenjusti takugmek, Tuke Pujuu atumi Apajuíjum nemagkujum niina chichame umiktin papiinum agagbauwa nunú umiktajum. Nunú umiakjum atumi anentaimijai, wakanmijai ima nigki ememattajum. ");
INSERT INTO agr_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","“Juju chicham umiktin agagbauwa juna yamai wi amaajim duka, atuminig imanikag utugchatchauwai. Nuniau asamtai, shiig antuka umimainchaukesh atsui, wagki atushtakesh achau asa. ");
INSERT INTO agr_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","Tuja chicham umiktin agagbauwa duka nayaimpinmakesh atsui. Nuadui atumek: ‘¿Yaki nayaimpinum waka, chicham umiktin agagbauwa nuna juki itaa ujapakui antuka umikag?’ tumaitsugme. ");
INSERT INTO agr_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","Nuniachkush nayantsa amainigkish atsui. Atum chichaakjum: ‘¿Yaki nayantsa amain chicham umiktin agagbau awa nuna katituk juki itaa ujapakui antuka umikag?’ tumaitsugme. ");
INSERT INTO agr_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","Chicham umiktin agagbauwa duka atumin awai. Nuadui wi atumin umiktajum tiuwaitjim nunú antukjum unuimaju asajum, utugchat akuish betek umiktajum. ");
INSERT INTO agr_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“Tuja yamai atum etegkatajum tuu wakegagme nunú. Shiig pujutak wakegajum, atsa waitiamua duka wakegajum. Iwaku pujuta duka wakegajum, atsa jaka megkaetak wakegajum. ");
INSERT INTO agr_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Wi yamai atum aidautigmin umiktajum tusan tajim duka Tuke Pujuu atumi Apajuíjum aneau asajum betek umiakjum, nii nemagkujum chicham umiktajum tusa agagbauwa nunú betek umiakjumek, iwaaku pujusjum, uchi uyujkattagme. Nuigtushkam Tuke Pujuu atumi Apajuíjum pegkegnum yumigtamsagtinai, nii nugka amasua nuwi shiig pujustinme tusa. ");
INSERT INTO agr_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","Untsu atum nunú ashí umitsuk idaikujum wainka apajuímtai aidau tikishmatjajum emematu yujakjumek, ");
INSERT INTO agr_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","namak Jordán katitkajum Apajuí nugkan amastata nuwi jegagmesh, kuashat tsawan pujutsuk jinaatin ainagme, wi tajim duka ewaetsuk. ");
INSERT INTO agr_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","“Wi atumin chichagkun: ‘Shiig pujutak wakegajum, atsa waitiamua duka wakegajum, tuja iwaku pujutak wakegajum, atsa jaka megkaetak wakegajum, nunú atum etegkatajum’ timajim nunú tuké uminkatnun yamai wi taja nunak nayaim nugkajai antamunum tajime. Duka dekas etegkatajum iwaku pujuta nunú, atum wegantu agtina dushakam iwaku pujustin atinme. ");
INSERT INTO agr_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","Tuke Pujuu atumi Apajuíjiya nunú ima aneetajum. Nuniakjum nii umigkatajum. Tuja nii tabauwa nunú betek umigkatajum. Nunú betek umiakjumek, atumi apachjum Abraham, Isaac, Jacob aatus aajaku aina nuna Tuke Pujuu atumi Apajuíjum nugkan amastinaitjime tusa anagkuawa nuwi jegajum kuashat tsawan pujustinaitjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Moisés Israel aents aidaun ataktu chichajak, juna aatus tiuwai: ");
INSERT INTO agr_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“Wika yamaik ciento veinte mijan ejejai, nuniku asan atushat wetag takunush kakaumainchau dekapeajai. Nuigtushkam minak Tuke Pujuu chichagtak, amek namak Jordágkak katitkashtatme tusa tujutmayi. ");
INSERT INTO agr_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Tujash atumek Tuke Pujuu atumi Apajuíjiya nunú eemak wegak uyuuntamsamtai wetatjume. Tuja atum shimamunum shiwaajum ayaunashkam nii depetuk ijinattawai. Dutikamtai dita nugke aina duka atum jukittagme. Atumnak Josué apu wajasu asa, nii yajupak etamtatui Tuke Pujuu atumi Apajuíjum tibauwa nunak dutiksag. ");
INSERT INTO agr_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","“Atumi shiwaajum aidaunak Tuke Pujuu yaunchuk amorreo aents aidau apuji, Sihón, Og, aatus ashí dita aentsjijai ijinauwa dutiksag ijinattawai. ");
INSERT INTO agr_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Nunú aents aina nuna depetkatnume tusa nii tujamatai depeteakjumek, wi dutikatajum tusan tajim duka dutiksagmek umiktajum. ");
INSERT INTO agr_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Mijamtsuk wajiu wajastajum. Atumi shiwaajum aina nujai maaniakjumesh ishamkagtukaigpa, wagki Tuke Pujuu atumi Apajuíjum atumnak kuitamjamui, nuniau asa ima atumnakek kajimatjamkig idaitamsashtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Nuna tusa Josuén untsuka Israel aents aidau antuinamunum chichajak: “Amek mijamtsuk wajiu wajasta, ametme juju aents aina nunú yajuakam Tuke Pujuu nugka amastinaitjime tusa amina apachjum aajaku aina nuna anagkuawa nuwi ejegatnumek. Nuadui Israel aents aina duka ame yajuakam nunú nugka nuwig utsattame. ");
INSERT INTO agr_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Tuke Pujuu aminak uyuuntamak, nigki kuitamjamkattawai. Nuniau asa ima aminakek kajimatjamkig idaitamsashtatui. Nuadui amek ishamkagtukaipa tuja sapigmatash sapigmakaipa”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","Juju chicham umiktin aina nunak Moisés agajui. Tuja sacerdote Leví wegantu aidau Tuke Pujuu chichame umiktin agagbau egkeamun arcan yanakiag shimujakajua nuna ashí Israel aents aidau dita apuji aidaujai kuitamkatnume tusa susauwai. ");
INSERT INTO agr_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","Nuna susa chichajak: “Mijan sieteya nunú diwimdaikamu aidau tsagkugdaitai jegatta duwi, ashí Israel aents aidautijum ijunjajum tsawan numi kanawe tsupija aakmaja batsamsamua nunú tsawantin jiistamatajum. ");
INSERT INTO agr_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","Nuadui ashí Israel aents aidau Apajuíjai chichatai aak pegkejam carpa aakmakbauwa nuwi tuwakag antuinamunum chicham umiktin agagbauwa nuna ausattawai. ");
INSERT INTO agr_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","Ashí aents aidau: Aishmag, nuwa, uchi, aents tikich nugkanmaya atumjai batsatu aidaushkam ijunjatnume. Nunikag chicham umiktin agagbauwa nunú augbaun antukag Tuke Pujuu Apajuí eme anentsa diitan unuimagtinme. Nuninak wajintu agagbauwaita nuna ashí betek umiktinme. ");
INSERT INTO agr_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","Atumi uchijum aidau juju chicham umiktina nuna dekachu aidaush antukag, Apajuí nugkan amasagtata nuwi namak Jordán katitkajum batsamsattajum, nuwi batsamsash kajimattsuk Tuke Pujuu Apajuí eme anentsa diitan unuimagtinme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","Nuna tusa inagnaku ai, Tuke Pujuu Moisésan chichajak: “Ame jakatnuk tsawantak jegawai. Nuniau asamtai Josué untsukam niijai aak pegkejam aakmakbauwa nuwi tantatajum. Nunikagmin wi atum dutikatnun jintintuatjime”, tiuwai. Tusa tima Moisés Josuéjai aak pegkejam Apajuíjai chichatai aakmakbaunum weajui. ");
INSERT INTO agr_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","Nunik jegawagmatai Tuke Pujuu nuwi yujagminum pachitkau wantintuk, nunú aak pegkejam aakmakbau waitijin wajantun asauwai. ");
INSERT INTO agr_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","Nuwi Apajuí Moisésan chichajak: “Ame jakatnuk namput wajaschae. Nunika jakamin juju aents aina duka nugkan jukiagtata nuwi jegawag, nuwa aishin ukuak tikichjai weama numamtuk nuwiya aents aidau apajuímtai aina nuna emematuinak minak kajimatjukiag, wi ditajai chichaman umikuitag nunashkam umikchagtinai. ");
INSERT INTO agr_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","Nunidau asagmatai wishakam senchi kajegkan makichkish puyatjutsuk idaisagtinaitjai. Dutika ai shiig senchi waitu batsatu asa makichik tsawantai chichainak: ‘Ii senchi waituinag duka Tuke Pujuu iina Apajuíji idaitamsa nuadui imanika waituinaji’, tiagtinai. ");
INSERT INTO agr_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","Nuna tusa tuinakuish, wika ditanak antugtsuk idaisagtinaitjai, wagki pegkegchaun takainak tikich apajuímtai aidaun ememetiaju asagmatai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","Nuna tusa Moisésan chichajak: “Juju kantamtaiya nunú yamai agagta. Dutikam Israel aents aidau jintintuata. Nuna unuimajag, kantamainak chicham umiachkugminig, wi suwimka amastinaitjime, tusa tiuwaitag nuna tuke adeagtin atinme. ");
INSERT INTO agr_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","Wagki wi dita apachji aajaku aina nuna anagkuakun, nugka pegkeg ajak shiig tsapaun amastinaitjime tusa tiuwaitag nuwi yajuakan ejegawaja ai batsamas, shiig yuwawag ejemakag duwekag tikich apajuímtai aidaun emematuinak mina kajimatjukiag, wi ditajai chichaman umikuitag nunak umikchagtinai. ");
INSERT INTO agr_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","Nunik batsamas kuashat waituinak, juju kantamtainum agagbau chichaak: ‘Atum mina umigtachkugminig tuke suwimkan amastinaitjime’ tiuwaitag nuna adeagtin atinme. Tuja dita wegantu aidaushkam nunú kantamtaiya nunak kajimattsuk kantamtin ainawai. Wi nugka amastajime tusa tiuwaitag nuwi eke ejetsaig, nuwi jegawag dita pegkegchau takastinjinak emtika anentaimtuina nunak wika shiig dekajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","Tusa tima, nunú tsawantaik, Moisés kantamtain agajui. Dutika agag Israel aents aidaun jintintuauwai unuimagtinme tusa. ");
INSERT INTO agr_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","Tuja Josuén Tuke Pujuu juna aatus chichajak: “Mijamtsuk wajiu wajasta, ametme juju aents aina nunú yajuakam wi nugka amastinaitjime tusan anagkuawaitjim nuwi ejegatnumek. Tuja wi aminak kuitamkattagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","Tuja chicham umiktin aidaun Moisés papiinum agag ashimak, ");
INSERT INTO agr_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","sacerdote Leví wegantu aidau Tuke Pujuu chichame umiktin agagbau egketun arcan yanakiag shimujakajua nuna chichajak: ");
INSERT INTO agr_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“Juju chicham umiktin agagbauwa nunú jukijum Apajuí chichaman atumjai umikua nunú agagbau egkeamu arca puja nuwi ayauntsa apusatajum. Juju agagbauwa nunú atum Tuke Pujuu atumi Apajuíjum umigchakjum waittsatnaitjum nuna anemtijamjatnai. ");
INSERT INTO agr_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","Wagki atumek aents antakchau intimkiu ainajum nunak wika shiig dekajai. Wi atumjai iwaku pujag duikish atumek Tuke Pujuujai shiwagmaejume. Nunin aidautigmesh ¿wajukatnuk ainagme wi jakamtaish? ");
INSERT INTO agr_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","“Leví aents aidautijum, Israel aents aidaun apuji aina nunú, tuja nuigtu maki makichik wegantu aina nuna apuji múun aidaujai, ashí untsukjum ijumjatajum. Dutikawagmin wi atum aidautigmin jintintuajim dutiksanuk ditanash shiig ujakagtajai. Dutikakun nayaimpin nugkajai pachisan dita antuinamunum dekas uminkatna nuna titajai. ");
INSERT INTO agr_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","Wagki wi jakamtaig pegkegchaun takainak wi dutikatajum tiuwaitag nuna idaisagtina nunak wika dekajai. Nuigtush atak tikich tsawan atina duwi Apajuí emtin pegkegchaun taka batsamas Tuke Pujuu kajegka suwimak susam kuashat waittsagtina nunashkam dekajai”, tiuwai Moisés. ");
INSERT INTO agr_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","Nuna tusa Israel aents aidau ashí tuwakag antuinamunum yama nagkamchaku agagbaunum nagkama juna aatus Moisés kantamauwai: ");
INSERT INTO agr_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","“¡Nayaimpih, nugkah, wi chichaktatag nunú shiig antuktajum! ");
INSERT INTO agr_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","Wi jintinkagtamua duka yumijai betek yutugtatui, Mina chichamjuk yumi sajatama nujai betek atatui. Yumi ujumak yutug chijichin uchupiama nujai betek atatui. Yumi senchi yutak dupan uchupiama nujai betekai. ");
INSERT INTO agr_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","Tuke Pujuu daaji pachisan nigka pegkejai, múuntai tusan etsegkatjai. ¡Atumshakam, iina Apajuíjiya duka dekas múuntai titajum! ");
INSERT INTO agr_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","Niyai iina kuitamjamnuk. Nii takamujiya duka betek uminnai. Niig Apajuí dekaskenum chichauwai. Niig pegkegchaunak takachui. ¡Niig pegkegmai, tuja nuigtush waitjuchui! ");
INSERT INTO agr_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","“Israel aents aidauwah, atumek pegkegchau ainagme. Pegkegchau takakjum Apajuí ikajin ainagme. Nunin asajum Apajuí uchijig amaitsugme. ");
INSERT INTO agr_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","Tuke Pujuu atumin kuitamjama duwika ¿aan iikuajum? Atumek yachachu, anentainkachu ainagme. ¿Apajuíchukai atumi apa najapauwa nunú? ¡Apajuíyai amina najapa uyujtamak senchimtijamauwa duka! ");
INSERT INTO agr_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","Ataktu awagkijum anentaimsatajum, nuniakjum adeagtajum yaunchuk aajakua nunú. Tuja atumi apaji aidau, tikich múun aidaujai yaunchkesh pujutash wajuku ayi tusajum iniastajum. ");
INSERT INTO agr_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","Apajuí aents aidaunak akanag maki makichik chichamtin, nugkentin emak batsasui; tujash atum Israel aents aidautigminak Apajuí makichik nugkanmak ijupag kuitamjamui. ");
INSERT INTO agr_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","Apajuík Jacopa uchiji wegantunmaya aidautin etegtamjauwai niinu agtinun. ");
INSERT INTO agr_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","“Nuadui, uwejush nugka buku, yumi atsau, dase umputainum batsatjin, nii kuitamjamak jintinjamauwai. Dutijamak makichik aents niina jiin shiig kuitamama imatikas kuitamjamkauwai. ");
INSERT INTO agr_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","Apajuík ukukui niina nanapen uchijin dukuka kuitamama numamtuk iinak kuitamjamnai. Apajuík, ukukui niina uchijin kuitamak niina nanapen pataja juwama numamtuk kuitamjamak ishamainnumian uwemtijamjauwai. ");
INSERT INTO agr_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","“Tuke Pujuuwa nunuwai iina uyuntamsauwa duka, tikichik atsawai. ¡Tikich wainka apajuímtai aina duka makichkish yaimpakchauwai! ");
INSERT INTO agr_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","Apajuí depetmitkagmak jujamki nugka pegkeg ajak shiig tsapau, nain aidaun sujamsaje. Nuwiya dapa yumiji buchignum ayaun amasaje uwagtinme tusa. Nuwiya ajak aina nunashkam amasaje yuwatnume tusa. Tuja nugka kuashat kayagkamunum olivo ayá nuna aceitejinchakam amasaje. ");
INSERT INTO agr_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","Tuja baka aidau muntsuji ijugbau kantemtikamu aidau, tuja uwija muntsuji ijugbau aidau kuashat ajutjamiugme. Tuja uwig duwejam aidau, uwig tsakat duwejam aidau, nuigtu cabra shiig kuashat Basán nugkanum aijakua nuna neje yuuyugme. Nuigtushkam trigo shiig pegkeg yuuyugme, niniakjum uva yumiji ijugbau kapantu umuyugme. ");
INSERT INTO agr_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","“Tujash Jesurún aidautigmek kuashat tagkugtin, kuashat ajakjintin wajasjum nunú yuwakjum duwekugme. Imanika duweku asajum, kuntin uduejam niina ujen winchamtin wajas pempeentuki niina kuitamnun tukumama numamtuk Apajuí shiwagmauwaitjume. Apajuíyai atumi najapauwa duka. Nunin aig atum dakitakjum idaisauwaitjume. Apajuíyai atumin kuitamjamak uwemtijamjauwa duka. Nunin aig atumek kajegkauwaitjume. ");
INSERT INTO agr_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","Atumek dakumka najanamu aidaun Apajuí dakita nunú emematkujum, Apajuí senchi ikajkauwaitjume. ");
INSERT INTO agr_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","Nuadui Apajuí emematmaina nunú idaikujum, wainka apajuímtai aina nunú ememattag tusajum kuntin maajum apejakuitjume. Atumi apachjum aajaku aina dukesh wainajakchamu, tuja ememattanakesh emematchaju aina nunú, atumek yama wainmawaik emematjume. ");
INSERT INTO agr_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","Israel aents aidauwah, atumek atumi Apajuíjum kuitamjamna duka kajimatkiugme. Apajuí pujutan amasua nunú kajimatkiugme. ");
INSERT INTO agr_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","Nuadui Tuke Pujuu atumnak, niina uchiji nawanji ajuminig idaitamsaje.” ");
INSERT INTO agr_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","Nuadui Apajuí chichaak: “Atumek aents pegkegchau ainagme. Atumnak kajittsa diimainchau dekapeajime. Nunin asagmin atumnak nuigtuk yaigchattajime. Wajukatagmek nuna dakastajime. ");
INSERT INTO agr_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","“Atum aidautijum wainka apajuímtai kakakchau, dekachu aina nunú emematkujum mina kajemtijakjum akasmau etagme. Nuadui Israel aentschau aidau chichagmash makichkish antakchau aina nuna wi yayaakui, atumek kajeakjum waittsattagme. ");
INSERT INTO agr_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","Mina kajetjua duka jiijai betek kegawai. Iman asa ashí nugka najatamunum kegak nugkanak ajak aidaujai apea emegkaktatui. Nuniak muja aidaunmashkam keettawai. ");
INSERT INTO agr_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","Wi atum aidautigminak ashí pegkegchau aina nuna ishitkattajime waittsatnume tusan. ");
INSERT INTO agr_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","Dutika ai nujantai, nuigtu tsuweakjum jinattagme. Tuja jata ishamain iyanjamag ijipattawai. Nuigtushkam kuntin kajen aidaun, dapi aidaun ishitkattajime. ");
INSERT INTO agr_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","Atumi uchijum aidauk jintá maa aepeam agtinai. Tuja atumi jeminia aidaushkam senchi sapigmagtinai. Imaaninak uchi tsakat aidau, nuwauch tsakat aidau, múuntuch aidau, uchi muntsu muntsuaku aidaush jinawagtinai. ");
INSERT INTO agr_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","“Tuja wi anentaimsan, tikich nugkanum dapampaakan utsagtajai, dutika ai dita wegantu aidau megkaejamtai, pachisaish augmatchatai juwaktin ati tusan anentaimsabiajai. ");
INSERT INTO agr_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","Tujash nuna dutika ai shiwag aidau mina pegkegchau chichagtuinakui, antutan dakitakun dutikachmaijai. Wi dutika ai mina shiwag aidau ememas chichainak: ‘Tuke Pujuu Israel aents aidaunak jiijag utsagchabi, jutii aidauti iina senchijijai jiija utsagmaiji’, tumain asagmatai idaisabiajai. ");
INSERT INTO agr_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","Israel aents aidauk pegkegchau shiig anentainkachu ainawai. ");
INSERT INTO agr_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","Atumesh shiig anentaimkau ainakjumek, wi suwimkan amastinaitjime tusan tiuwaitjim nunú shiig dekau amainaitjume. ");
INSERT INTO agr_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","Atumesh anentaimsagmesh diyagmek, ¿atumi shiwaajum aina nuwiya suntag ima makichkitak mil suntag Israel aents aidaun ipisig ishiakua dusha? ¿Tuja atumi shiwaajum jimagchik suntajaitak, diez mil suntag Israel aents aidaun ipisjauwa dusha? Nunak Tuke Pujuu atumi kuitamjamna nunú, shiwag aidau depetuk amuktinme tusa tiu asamtai dutijamau ainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","Iina shiwaaji aina nuna apajuímtaiji aina duka iina Apajuíjiya nujaig betekchauwa nunak ditak shiig dekainawai. ");
INSERT INTO agr_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","Dita aidauk sodomanmaya aents, gomorranmaya aents aajaku aina nujai betek ainawai, nuadui dita aidauk uva pegkegchau yapau yuwa jamainun nejemaina nujai betek ainawai. ");
INSERT INTO agr_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","Nunú vino dita umutaiji aina dushakam dapi tsagke magkagtina nujai betek ainawai. ");
INSERT INTO agr_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","Tuja Apajuí chichaak: “Wi Israel aents aidaun ayamjakun dita shiwaaji aidaun tsaiktinaitag nunak etsegkashtatjai. Duka makichik waji akik uukam egkemama numamtinai. ");
INSERT INTO agr_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","Witjai suwimka sukagtinnuk, nuniau asan tsawan jegakui, wi suwimkanak susatnaitjai, wagki nii waittsatna duka tsawantak jegawai. Tuja nii suwimak jukitnuji umigkamua duka tsawantak uminui”, tiuwai Apajuí. ");
INSERT INTO agr_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","Tuke Pujuu niina aentsji aidau kakaag ayamjumamainchaun wainu asa ayamjuktatui. Ditan ashí amuinak aents inaku waitkatai, tuja agkan batsamin aina nujai amukam kakaumainchau dekapeagtai, Apajuí wait anentug, ");
INSERT INTO agr_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","chichajak: “¿Ii apajuímtaiji aina juju ayamjutpaktatui tusajum, ");
INSERT INTO agr_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","nunú emematkujum kuntin maa apeamua nuna wiyaji yuwakjum, umutai vino nii anagkuamu umuyujum dusha tuwi batsatua? ¡Nunú nantajag atum waitiajum nuna ayamjutpaktinme! ¡Nunú kaunawag kuitamjamkatnume! ");
INSERT INTO agr_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","Ima Wikitjai Apajuínuk. Tikich Apajuík makichkish atsawai. Witjai pujuta sukagtinnuk, tuja wikitjai pujuta ataínnuk. Witjai suwimka sukagtinnuk, tuja wikitjai tsagkugkagtinnuk. ¡Mina suwimkajua nuna uwemtumainuk makichkish atsawai! ");
INSERT INTO agr_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","Mina uwejun nayaimpinum takuajai, nunikan wika Tuke Pujuu asan, wi dutikatnujun pachisan tajai. ");
INSERT INTO agr_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","Mina puyagjun winchamtinun etsaka jukin, ya aidauwa pegkegchaun takainak mina shiwagmatuinak kajegtuinawa nuna ijinatasan nagkamattajai. ");
INSERT INTO agr_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","Dutikan kuashat aentsun ijinkun mina puyagjunak numpeagtatjai. ¡Makichkish uwemjachagtatui! ¡Shiwag ijinku nuna apuji aidau achija yajuakbau aina nunashkam ashí ijinattajai! ");
INSERT INTO agr_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","“Nuadui ashí tikich aents judíochu aidautigmesh Apajuí aentsji aina nujai ijunjajum dakujustajum. Apajuí niina takajin aidau ijituamunum atumi shiwaajum aidaunak ijinattawai. Dutikak niina aentsji aidaunak wait anentug ditá tudaujinak tsagkujattawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","Moisés Josuéjai Israel aents aidau batsatbaunum jeganta dita antuinamunum yama nagkamchak agagbaunum nagkama kantama amukui. ");
INSERT INTO agr_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","Nuna ashí kantama inagnak, ");
INSERT INTO agr_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","nuadui Israel aents aidaun chichajak: “Wi atumin jintintuajim nunú shiig antuka jukitajum. Nunikjum atumi uchijum aidau jintintuatajum, dutikawajam ditashkam chicham umiktin agagbauwa nuna ashí betek umiktinme. ");
INSERT INTO agr_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","Tuja juju chicham umiktin agagbauwa nunú wainkaya nunin diyakjum umitsuk idaisaigpajum. Juju chicham umiktina nunú atumnak pujutan amawai. Nuniau asamtai, Apajuí nugka anagtamauwa nunú namak Jordágka amain awa nuwi jegagmesh, nunú umiakjum kuashat tsawan pujustinaitjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","Nunú tsawantin Tuke Pujuu Moisésan wantintuk chichajak: ");
INSERT INTO agr_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“Muja Abarim tutaya nuwi wetá, nunikam muja Nebo tutai Moab aents aidau nugken yaakat Jericójai niinis awa nuwi wakata. Nunikam, nuwi wajasam Canaán nugkan wi Israel aents aidaun susattag nunú diista. ");
INSERT INTO agr_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","“Nunú mujanum wakattam nuwi amek amina yatsum Aarón Hor nugkanum jakauwa nunismek jakattame. ");
INSERT INTO agr_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","Atumek yumi pukuni jiinbau Meribá-cades tutaya nuwi Israel aents aidau yumi umumain atsutai chichamjuinakui, wi nunú dutikatajum tusan uwejush Sin tutainum tiuwaitjim nunú umikchauwaitjume. Nunú nugkanum Israel aents aidau yumin sumainakui atum mina eme anenjamu ditá emtin iwainakchau ainagme. ");
INSERT INTO agr_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","Nuadui wi Israel aents aidaun nugka susattag duka amek ayatak ikaa wajasam wainkattame. Tujash amek nuwig wayashtatme”, tiuwai Apajuí. ");
INSERT INTO agr_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","Apajuí inake Moisés, nii jakatnuji jegamtai pujusa, Israel aents aidaun pegkegnum yumigkiak, ");
INSERT INTO agr_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","juna aatus tiuwai: “Tuke Pujuu jutijai pujustatus muja Sinaínum tauwai, tuja nugka Seírnum nagkamas niina tsaaptinjig etsanjabi. Nunik etsantug yaakat Parágnum nagkamas uyuuntamsabi, tuja diez mil ángel aidaujai weak, niina uweje untsujiya duwi chicham umiktin agagbaun takakuyi. ");
INSERT INTO agr_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","Tuke Pujuuk niina aentsji aidaunak aneawai, tuja niinu etegjamu aidaunak kuitamui, nunú aidau Apajuín emematuinawai, nuninak nii umiktajum tibaun uminawai. ");
INSERT INTO agr_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","Moisés chicham umiktin Jacob wegantunum tuke asatna nuna Apajuí susamun juki amasajui. ");
INSERT INTO agr_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","Apajuík Jesurúnkan apuji wajasui. Apajuík Israel aents aidaun apuji aidaun apuji, tuja Israela uchiji maki makichik wegantu aidau ijunjajua nuna apuji wajasui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","Tuja Rubén wegantun pachis Moisés juna aatus chichajak: “¡Rubén wegantu aidauk tuke batsamsatin agtinai! ¡Aishmag ujumak ataish, jinaa megkaejashtin ainawai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","Tuja Judá wegantun pachis Moisés juna aatus chichajak: “Tuke Pujuuwah, Judá wegantu aidau amina segapainakuig antugkata. Ataktu awagkim tikich aents Israel wegantu aidau batsatbaunum ijumjata. Amina senchigmijai ayamjukta, dutikakum yaigta niina shiwaajinish ayamjumakti tusam”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","Tuja Leví wegantu aidaun pachis Moisés juna aatus chichajak: “Tumim Urim aina duka aminu ainawai. Nunú Leví wegantu amina sacerdotejum aidau ame tabaun betek umigtamin aina nunú susauwaitme. Tuja Masá nugkanum ame dita dekapsauwaitme, dutikakum Meribá nugkanmashkam amina aentsjum aidau yumi susauwaitam nuwi senchi jiyakuitme. ");
INSERT INTO agr_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","Leví wegantu aina duka ame chicham umiktajum tiuwaitam nuna puyatjus uminawai, nuninak kakanmamainawai ame chicham tibauwa nuna betek umikagtatus. Nuna ima senchi dita patayin nagkaesau eme anentuinawai. Nunidau asag ditá apaji aidaun dukuji aidaujai chichajuinak: ‘Atumnak wika dekatsjime’ tuinawai; tuja dita yachi iwai aidaun, umayi iwai aidaun, tsakat aidaunashkam chichajuinak: ‘Wika atumnak dekatsjime’ tuinawai; tuja ditá uchiji aidaun nawanji aidaujai chichajuinak: ‘Dekatsjime yatsu ainajum’ tuinawai, wagki ditak ashí Apajuí umigtan idaisaju asagmatai. ");
INSERT INTO agr_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","Dita ainawai amina chichamem umiktin agagbau aina nuna Jacob wegantun jintintuina duka. Dita ainawai kugkuin incienson kuntin maa apeamujai jukiag, aak pegkejam aakmakbaunum nunú patasa apetai puja nuwi pataina nunú. ");
INSERT INTO agr_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","Nuadui Tuke Pujuuwah, dita amina umigtamainak puyatjusag takaina nunú pegkegnum yumigsata. Dutikakum dita shiwaaji aina dushakam ame ijinata, tuja ditan kajejin aina dushakam ataktu wakitkig waitkaschatin atinme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","Tuja Benjamín wegantun pachis Moisés juna aatus chichajak: “Tuke Pujuuwah, amek Benjamín wegantu aina duka aneame. Nuadui ditak shiig aneasag batsatui. Amek múun ashí senchigtinaitam ibau asam tuke kuitamtinaitme. ¡Nuadui ame kuitamsam batsamsagtinai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","Tuja José wegantu aidaun pachis Moisés juna aatus chichajak: “Tuke Pujuu niina nugkenak pegkegnum yumigsatin ati, dutikamu asamtai, nayaimpinmaya yumi yutak, tuja nugka initkeniash yumi pukuni jiinainak niina nugkenak tuke uchupsagke atinai. ");
INSERT INTO agr_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","José wegantu aidauk dita ajakmamujinian maki makichik mijantin ajak juut nantu jegatai, shiig kuashat juuka yuwagtinai. ");
INSERT INTO agr_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","Dita wegantu aidau ajakmamujig, ikam aidau, muja aidau ayá iman aidaun juwagtinai. Tuja muja makichkish megkaechauwa iman tuke atinai dita ajakmamu aina duka. ");
INSERT INTO agr_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","Dita nugkenig yujág shiig pegkeg aidau piyaktinai. Nuadui nii wegantu agtina nudaushkam imanisag ajiti tusam yaigta. Wagki ame mina zarza kegamunmaya wantintugkam, amina aentsjum aidaun yajuak emati tusam etegtuawaitam, dutiksamek ame Josék niina yachi iwai aidaun, ekeu aidaun apuji ati tusam etegkauwaitme. ");
INSERT INTO agr_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","Tuja Efraín wegantunmayag suntajak shiig kuashat agtinai, tuja Manasésnumiashkam aents maanin aidauk shiig kuashat agtinai. Nunú aina duka toro uchiji yama nagkamchak petsakbau pegkejama iman, búfalo senchigtinama iman agtinai. Iman asag ashí aents tikich nugkanmaya aidaunash, ditá senchijijai depetkatin ainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","Tuja Sabulón wegantun Isacar wegantujai pachis Moisés juna aatus chichajak: “Sabulón wegantu aidautigmek shiig aneastajum, atumek nayantsanum yujasjum tikich nugkanum waji sujitin asajum. Untsu Isacar wegantu aidautigmek aakchinmak batsamsajum, kuntin tagkumajum shiig kuashat uyugkajum shiig aneasjum batsamsagtinaitjume. ");
INSERT INTO agr_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","Nunik batsamas tikich Israel aents aidaun ipaa mujanum yajuak iwajagtinai. Dutikawag nuwi batsamas, ame dutikatajum tusa timauwa nuna uminak kuntinun maawag apeagtinai. Tuja nayantsanum waji pegkeg kuashat ayá nuna tikich nugkanum yujasag sujiagtinai. Nuninak nayantsanmaya yutai aidaun yuwagtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","Tuja Gad wegantun juna aatus Moisés chichajak: “¡Apajuíyah, ame Gad wegantu aidauk nugka múun susatnaitme, nuadui amina see tujamainak emematjamtin ainawai! Gad wegantunmaya aidauk león dakamama numamtuk dakamak aentsun maakug kuntujin tsupijug, buuken tsupijug ukutnai. ");
INSERT INTO agr_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","Israela uchiji aidau maki makichik wegantu aina nuna apuji aidau Canaán nugkan tesagdayagtaish, Gad wegantu aidau ima muuntan jukitnai apu aidau juinamujai betekak. Dita aidauk ame dutikata timauwa nuna umikagtin ainawai. Dita aidauk pegkegnum chichajam agtinai, wagki ame Israel aents aidau umiktajum timauwa nuna umidau asag”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","Tuja Dan wegantun Moisés juna aatus chichajak: “Dan wegantu aidauk león tsakat kuntinu tsekentama nujai betekai, iman asa niina shiwaajin jeteakug, nugka Basánnum nagkamas tsekenti jiintawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","Tuja Neftalí wegantu aidaun Moisés juna aatus chichajak: “Neftalí wegantu aidaunak Tuke Pujuu shiig anentus diyawai, Ame Apajuíyah, ditak kuashat pegkeg aidaunum yumigsauwaitme. ¡Nuadui kucha múun Galilea tutaya duka nujinum nagkamas tsumujiya aatus ditanu atinai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","Tuja Asher wegantu aidaun Moisés juna aatus chichajak: “Apajuíyah, ame Aserak Jacopa uchiji tikich aina nuna nagkaesau pegkegnum yumigsata. Dutikamu asamtai, niina yachi aidau eme anentsa diitai ati. Tuja kuashat olivogtin asa aceitejishkam imanisag ajitin ati. ");
INSERT INTO agr_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","Niina yaaktaji aidauk, tuja jee aidaushkam kuashat waitigtin atinai. Tuja nunú waiti aidauk jiju hierro, bronce aina nujai najanamu asamtai, niina shiwaajish kakajus utumainchau atinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","“Jesurúman Apajuíji atumin yaimpaktatus niina senchijijai yujagminum egkemak minina imanuk tikichik atsawai. ");
INSERT INTO agr_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","Apajuí Tuke Pujuuwa nunuwai amina ayamjumataigmek. Niig tuke senchigtina iman asa amina yaimpawai. Ame wainminig amina shiwajumnak uwakek ipisiak ijinata tusa amina inapawai. ");
INSERT INTO agr_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","Israelak ishamkagtutsuk kajinas pujustinai. Nii wegantu aidaushkam agkan utugchat atsaunum batsamsatin ainawai. Niina nugke aidaunmash trigo aidauk shiig kuashat aitnai, tuja uva ajakmaushkam imanisag aitnai, tuja yumishkam tuke yutitnai, nuniau asamtai, yuminak atsumchatnai. ");
INSERT INTO agr_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","¡Israel aents aidautigmek shiig aneastajum, wagki atum kuashat asajum eme anentai ainajum imanuk tikich aents aidauk atsawai! Atumnak Tuke Pujuuwa nunú uwemtijamjaugme. Nii atumnak kuitamjamui. Tuja nigki ayamjutpaktatui. Atumi shiwaajum aidaujai maaniagminish, niyai depetmitkagbauk. Nuadui shiwag aidauk atumiin yunumjagtinai. Nuninakui atum wagagkijum ijinatin ainagme”, tiuwai Moisés. ");
INSERT INTO agr_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Nuna tusa inagnak, nuadui Moisésak uwejush Moab nugkanum pujau juwaki, muja Pisgá tutai Jericójai niinis awa nuna titijin Nebo tutainum wakauwai. Nuwi wakamtai Galaad nugka múunta nuna wainkati tusa Tuke Pujuu iwaintukui. Tuja Danka nugkenashkam iwaintukui. ");
INSERT INTO agr_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","Nuigtushkam Neftalí, Efraín, Manasés aina nuna nugke aidaun iwaintukui. Dutikak Judá nugke nayants Mediterraneo tutaya aatus awa nunashkam ashí iwaintukui. ");
INSERT INTO agr_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Tuja nuigtushkam Néguev nugkan, Jordágka pakajin, yaakat Jericó palmera ain tuuta awagmatia nuna, tuja yaakat Sóar tutaya imanui iwaintukui. ");
INSERT INTO agr_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Dutika duwi, Tuke Pujuu Moisésan chichajak: “Au nugka auwai, wi Abraham, Isaac, Jacob aajaku aina nuna, atum wegantu aidaun nugkan susatnaitjai tusa tiuwaitag duka. Wi aminak au nugka awi wayashtinaitkush, wainkati tusan wakegau asan iwaintukjame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Aatus Moisés Apajuín inakega duka Moab nugkanum jakauwai, Tuke Pujuu tibaunak imatiksag. ");
INSERT INTO agr_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Nunik jakamtai Moab nugka pakaji, Bet-peor tutaya nujai niinis awa nuwi ukusbauwai. Tujash dekas tuwig ukusbauwaita nunak yamaikish dekainatsui. ");
INSERT INTO agr_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Moisésak ciento veinte mijan ajamu, wajiu, wainmatnash shiig wainbau, jamantuchu pujayatak jakauwai. ");
INSERT INTO agr_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Moisés jakamtai Israel aents aidau Moab nugkanum uwejush batsamas treinta tsawantai buutiaju ainawai. Aatus nii jakamtai buutuinak, aents jakamtai buutku iman tsawan pujutainak betek ejeyajui. ");
INSERT INTO agr_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Moisés eke iwaku pujusa Josué buuken achika Apajuín segatiuwai, Israel aents aidaun yajuakash wajuk ematki nuna Apajuí dekamtikati tusa. Dutikamu asamtai Tuke Pujuu Josuén antugkatnume tusa Moisésan tibauwa nunak imatiksag Israel aents aidauk Josué tabaun umikajui. ");
INSERT INTO agr_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Tujash Tuke Pujuu Moisésjai igkunia chichajakua imanuk tikichik Israel aents aidaunmaya Apajuí chichamen etsejin profetak makichkish atsujakui. ");
INSERT INTO agr_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Tuja wainchatai ishamain aidaun iwainagti tusa Tuke Pujuu tibau asa, Moisés Egipto nugkanum faraógka emtin niina atuwe aidaush wainainai iwainajua imanuk tikich aentsuk makichkish atsujakui. ");
INSERT INTO agr_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Tuja Moisésak senchigtin asa, wainchatai ishamain aidaun atum Israel aents aidautijum wainjumin iwainajua imatika iwainamainuk tikichik makichkish atsujakui.");
INSERT INTO agr_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Tuke Pujuun takajin Moisés jakamtai, Nun aajakua nuna uchiji Josué Moisésan yaijakua nujai Tuke Pujuu chichaak: ");
INSERT INTO agr_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Mina inakeg Moisésak jakae. Nuniku asamtai, ame yamaik Israel aents aidau ashí yajuakam, wi atumin nugkan amastatjim nuwi weakum namak Jordágnum ikatiagtatme. ");
INSERT INTO agr_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Wi nugka amastinaitjime tusan Moisésan anagkuawaitag nunak, imatiksanuk nugkanak ashí amastatjime. ");
INSERT INTO agr_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Nunú nugkak muja Néguev tutaya nuwi nagkamas, muja Líbano tutaya aatus, namak shiig múun Eufratesa imanui nagkamas, hitita aents aidaun nugkega nuna ashí, tuja nayants Mediterraneo tutai etsa akaetaiya nuni awa imanuishkam ashí atumin amastatjime. ");
INSERT INTO agr_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Aminak makichkish depetamkashtin ainawai. Moisésan kuitamajakuitag dutiksanuk wi aminak kajimatki idaitsuk tuke kuitamkattagme. ");
INSERT INTO agr_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Nuadui kakajam, wajiu wajasta, wagki wi atumi muunjum aajaku aina nuna anagkuakun nugkan amastajime tiuwaitag duka ame Israel aents aidauk tinamkattame. ");
INSERT INTO agr_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Wika aminak, ¡wajiu kakajam ata! tusan ima nunak segajame. ¡Nuniakum chicham umiktinun mina inakeg Moisés amasua nunú ashí betek umikta! ¡Nunú wajintu agagbauwaita duka imatiksamek ashí umikta! ¡Nunú ashí umiau asamin, ame takamugmesh ashí pegkeg atatui! ");
INSERT INTO agr_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Chicham umiktin agagbauwa duka tuke ausamke ata. Nuniakum tsawaish, kashish tuke ima nuwig anentaimta, wajintu agagbauwaita nunú umiktag tau asam. ¡Nunú betek umiakmek, ame takamugmesh ashí pegkeg atatui! ");
INSERT INTO agr_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","“¡Aishmag wajasta! Wi aminak inajan awemagme. ¡Ishamkagtukaipa, awakesh anentaimjaipa, wagki witjai Tuke Pujuu amina Apajuígminuk! Tuja ame tuwi wekaetatme nuwi wika amejai pujuttajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Tusa tima Josué Israel aentsu apuji aidaun chichajak: ");
INSERT INTO agr_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Aents aidau batsata nuwi shiyakjum, ashí etsegkatajum, jintá weaku yuwatnun umiktinme. Tuke Pujuu iina Apajuíjiya nunú nugka amastata nuwi weaku kashin pujusa tsawaku namak Jordán katitkattaji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Aatus akateg ishimak nuigtushkam Rubén wegantu aidaun, Gad wegantu aidaun, Manasés wegantu jimaituk aidaun akatmamtak: ");
INSERT INTO agr_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Atumesh nugkentin agkan batsamsatnun, Tuke Pujuu atumin Apajuígmia nunú juju nugka juna amastatjume tusa Apajuín inake Moisés tiuwa nuna aneaku atinme, tujamui. ");
INSERT INTO agr_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Nuadui juju nugka namak Jordágka amain ii pujag juna Moisés atumin amasua juwi, atumi nuwe aidau, uchijum aidau, tagkujum aidaujai batsaktajum. Untsu ashí aents maanimain aidautigmek maaniaku jutai aidaun yajuaka umintsajum, Jordágka amain katiagjum atumi yatsum aidau maaninakui atuktajum. ");
INSERT INTO agr_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Dutika atukjum, Apajuí atumin nugkan amasua dutiksag, ditanashkam agkan batsamsatnum nugkan susatta nuna shiig emetjagmatai, waketjajum juju nugka Jordágka juni awa juna, Moisés atumin amasua juwi kaunajum tuke batsamsatnaitjume, tawai tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Tusa tima ditashkam imatiksag ujakajui. Nuna antukag dita aimainak: “Ame tame duka imatiksaik ashí umikagmi. Tuja ame tuwi wetajum tukagtittame nuwi shiyakagmi. ");
INSERT INTO agr_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Yaunchuk Moisés tujamkui umijujakuitag, dutiksaik ame tabaushkam tuké umiktinaitji. Tuja iik wakegaji: ¡Apajuí Moisésan kuitamajakua dutiksag aminash kuitamjamkati! tusa. ");
INSERT INTO agr_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Tuja ashí aents amina chichamjumin intimki umigtamchauk mantamnati. ¡Iik wakegaji ame kakajam, wajiu ati! tusa” tiajui. ");
INSERT INTO agr_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Sitim nugkanum batsamas, aents uumak yujas dekamatin aidaun jimag aentsun etegka Josué ishimak: “¡Wetajum, nunikjum nugkash wajukukita nunú yaakat Jericójai diistajum!” tiuwai. Tusa tima shiyakag Jericónum jegawajui. Nunikag nuwa akika dutiktai Rahab pujaunum nuna jeen jegawajui, nuwi kajigkagtatus. ");
INSERT INTO agr_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Nunikagmatai aents nuna wainkau Jericó apujin jegajua ujaak: “Ujumak aents Israel aents aidau dekamatatus yamai kashi kaunawagmae”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Tusa ujakam Jericó apuji niina suntaji aidaun Rahab ujaktajum tusa ishimak: “¡Aents aidau amina ijagtamainak amina jemin kauna batsata nunú jiija ishiakta, wagki ditak iina nugken dekatatus yujawai!” tusa akatmamtujui. Tusa tima shiyakag imatiksag ujakajui. ");
INSERT INTO agr_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Tusa ujakmash jiija ishimtsuk uuka batsas chichaak: “Nunú aents aidauk dekas mina ijagtuinak kaunawagmae. Tujash dekachmajai tuwiyas agma. ");
INSERT INTO agr_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Juwi batsatu kiitai jiinag shiyakagmae. Wagki nuniai yaaktanum waitain waitin epenin agma duwi. Tujash tutsu wegagma nunak dekachmajai. Yamaik pataetakjumek amainamain ainagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Tujash nunak niina jeen tuntupe pakamamunum, lino juuka jigkaka ujugkatasa ijumjamunum nuwi, yakí uuka batsasuitak tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Nuwi batsataig, apu ishiakbau aidauk shiyakeapi tuidau asag, pataetukag namak Jordágnumanini shimutuk katitainum jegawajui. Nunik suntag jiinag shimaig, yaakta waitijinak epeniu ainawai. ");
INSERT INTO agr_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Nunik pataetuk shiyakagmatai, nunú aents dekamatatus yujau eke kanuinatsaig, Rahab wajuka ditan chichajak: ");
INSERT INTO agr_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","“Tuke Pujuu atum aidautigmin juna nugka amasaja nunak wika dekajai, wagki atumin senchi ishamjamkatnume tusa Apajuí tine. Nuadui ashí aents juju nugkanmaya aidauk atumin ishamjamainak sapijai jinuinawai. ");
INSERT INTO agr_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Atum Egipto nugkanum batsatutijum jiinjagmin nayantsa amain katiagtinme tusa Tuke Pujuu nayants kapantun ukuyuauwa nunú iik dekaji. Tuja nuigtushkam atum aidautijum amorreo nugkanmayaapu aidau Sijón, Og aatus Jordágka amain batsatu ashí ijinawaitjum dushakam shiig dekaji. ");
INSERT INTO agr_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Nunú dekau asaja, shiig senchi ishamkagtuinaji. Tuja atumjai maaniatjai tumainuk makichkish shiig atsawai. Wagki Tuke Pujuu atumi Apajuíjum atum emematjum nunuwai nayaimpinash, nugkanash ima nigki Apajuíjiya duka. ");
INSERT INTO agr_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Nuadui wi atumin wait anenjan kuitamkajim, dutiksagmek mina pataag aidaush wait anenjatnaitkugmek dekaskenum wait anenjattaji tusajum Tuke Pujuu daajin tujuttajum. ");
INSERT INTO agr_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Tuja atum maania depetmakjum juju nugka atumdau emakjumesh minash, mina apag, mina dukug, mina ubag, mina kaig aina duka ashí dita patayi aidaujai ijijattsuk kuitamkagtuktajum. ¡Nunuwai dekas pegkegnum yainiamua duka!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Tusa tama dita chichajuinak: “Juju nugka juwi kauna maaniamunum amina pataim aidau jakamtaig, Apajuí iina suwimkan amastí. Tujash ameshkam juju pachismek makichkish etsegkaipa. Tuke Pujuu juju nugkan iina amasmataig, amek amina pataim aidaujai shiig kuitamnaktatme”, tiajui. ");
INSERT INTO agr_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Tusa tiagmatai yaakat peegmaja apakbaunum nuna ejapeen jega jegamkamunum pujau asa, nunú aents jiinaidaun wainkainum tusa niimtai ujaimunum daekan aganini detua nuni jiig ishiakui. ");
INSERT INTO agr_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Dutika ishimak: “¡Suntag aidau egapainak yujaina nunú waipakainum mujá wetajum! ¡Nunikjum nuwi kampatum tsawan uumkajum pujagmin, suntag aidau atumi egapainak shiyaka nunú waketug kaunamtai duwi shiyaktajum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Tusa tama dita chichainak: “Ame segajatkumin, ii umiktin dekas umiktatji tusa Apajuí daajin timag duka imatiksaik umiktatji. ");
INSERT INTO agr_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Untsu ii juju nugka juwi wayamu wainkumek, juju daek kapantua juwi ii akaikittag nunú aganini nenata. Dutikam nuadui juju amina jemea juwi amina apa, duku, umaim aidau, kaim aidau, amina apa patayi aidaujai utsaatajum. ");
INSERT INTO agr_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Tuja makichik aentskesh amina jemin pujayatak, jiinki wekaekama mantamnakug duka niinu atatui. Untsu amina jemin pujaunak utua mainakuig duka utugchatak iinu atatui. ");
INSERT INTO agr_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Tuja ii chichag nunú ame etsegkaminig, ii umiktin Apajuí daajin taji duka umikchattaji”, tiajui. ");
INSERT INTO agr_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Tusa tama: “¡Ayu, atum tajum duke ati!” tiuwai. Aatus ashí ditajai chichas ishiakui. Dutikam shiyakmatai nuadui niimtai ujaimunum aganini daek kapantun nená idaisauwai. ");
INSERT INTO agr_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Tuja nunú aents dekamin aidauk mujá shiyakag kampatum tsawan uumak batsamsajui. Nunik batsatai suntag aidauk ashí yantamnum egai egainakua wainkachag waketug Jericó jegawajui. ");
INSERT INTO agr_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Nunik waketjamtai, ditashkam mujá batsatu akaejag Jordágkan katitkiag Josué pujamunum jegawajui. Nunik jegawag dita yujasbaun pachis niina ashí ujakajui. ");
INSERT INTO agr_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Tusa ujainak: “Au nugkanak Tuke Pujuu ashí iinu atinun idaitugmase. Dutikamu asamtai nuwiya aents aidauk iina ishamjamainak sapijai jinime”, tiajui. ");
INSERT INTO agr_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Aents uumak yujas nugka dekatatus shiyaku waketug kaunawag etsegkagmatai, kashinia duwi shiig kashikmas Josué Israel aents aidaujai Sitim nugkanum batsatu ashí jiinag shiyakajui. Nunik shimui shimuinakua jegawajui namak Jordágnum. Nunikag eke atú amain katitsuk nuwi aakmag batsamsajui. ");
INSERT INTO agr_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Nuwi batsamas kampatum tsawan nagkaemai, suntaja apuji aidau Israel aents aidau batsatun shimutkag ");
INSERT INTO agr_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","ujainak aatus tuidau: “Leví wegantu aina nunú chicham umiktin agagbau egkeamun arcan yanaki juki wedau wainkugmek, atumi aakjum aidau tegaka jukijum wetajum. ");
INSERT INTO agr_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Nuniakjum dekattagme itug wetatjume nunú, wagki atumek yaunchkesh juju nugkanmak wekaechau ainajum duwi wajuk wetaigkita duka dekatsjume. Tujash chicham umiktin agagbau egkeamun arcan yanaki juki wena nunú ijusa wetsuk makichik kilómetro tumain ukuunum wetajum”, tiajui. ");
INSERT INTO agr_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Tusa ujakagmatai Josué ditan chichajak: “Tuke Pujuu iina yaimpaktin asa kashin wainchatain iwainaktatui. Nuniktin asamtai, ¡pegkeejum umintsa dakamsatajum!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Nuna tusa sacerdote aidaun chichajak: “¡Chicham umiktin agagbau egkeamu arca yanaki jukijum emka wetajum!” tiuwai. Tusa tiajam nuna yanaki jukiag eemak wegajui. ");
INSERT INTO agr_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Nunik shimai, Tuke Pujuu Josuén chichajak: “Wi yamai dutikattag nuna wainkag, Israel aents aina duka dekaskeap Apajuí jutii apuji atinun etegkauwaita tujamiagtatui. Aatus dekawagtatui wi Moisésan kuitamajakuitag dutiksanuk aminashkam kuitamja nuna. ");
INSERT INTO agr_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Untsu sacerdote aidau chicham umiktin agagbau egketun arcan juki wena nunú ame chichagkum: ‘Namak Jordágnum jegagmek wajaajum ijuntsatajum’ tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Tusa tima Josué Israel aents aidaun chichajak: “Juwi kaunatajum, nunikagmin Tuke Pujuu iina Apajuíji ii emematin ainag nunú mina tujuti nuna ujaktajime. ");
INSERT INTO agr_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Apajuí Tuke Pujuu tutaya nunú iina kuitamjamsamtai shimag duka, hitita aents aidau, heveo aents aidau, ferezeo aents aidau, gergeseo aents aidau, amorreo aents aidau, Jebús aents aidau aatus, Canaán nugkanum batsamin aina nunú ii shimaku Apajuí senchijin depetka ijina wetatag duwi dekattaji. ");
INSERT INTO agr_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Antuktajum nijah, Tuke Pujuu ashí aents aidaun Apajuíjiya nuna chichame umiktin agagbau egkeamu arcan sacerdote aidau yanaki jukiag atum wainjumin namak Jordágkan katitkiagtatui. ");
INSERT INTO agr_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Nunikagmatai Israel aents aidautijum maki makichik wegantu ainajum nuwiya doce aents etegjatajum. ");
INSERT INTO agr_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Tuja Tuke Pujuu ashí aents aidaun Apajuíjiya nuna chichame umiktin agagbau egkeamu arcan sacerdote aidau yanaki jukiag yuminum wajawagtatui. Nuniagtai, namakak jimaituk tesana buku wajas katigtatui. Nunitai yumi nujinmaya minaush, jasa muja iman wajas asattawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Tusa timatai Israel aents aidau namak Jordágka katitkagtatus jiinag shimai, sacerdote aidau chicham umiktin agagbau egketun arcan yanaki juki eemak wedau. ");
INSERT INTO agr_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Tuja ajak juutai tsawan jegataik, namak shiig senchi dujajin asa namakak dujajua piyag aajakui. Imanik ai sacerdote aidau namaka jegawag tugkitak wajawajui. ");
INSERT INTO agr_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","Nuninaig namakak kuyua buku wajas asauwai. Duka peegmagbau Saretag tutai awa nujai niiniaku yaakat Adam tutai awa imanui nagkamas namak tsujina yumi nujinum pimutai, tsumujin namak juwakuk sae saekawa nayants jakau tutainum nagkankauwai. Aatus Apajuí namakan akanak ukuyuamtai, Israel aents aidauk yaakat Jericón igkuas katiajajui. ");
INSERT INTO agr_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Sacerdote aidau chicham umiktin agagbau egkeamun arcan yanaki juki wedauk nuna yanasag namak Jordán kuyua buku wajasbaunum ejapeen ijunai, Israel aents aidauk bukunum shiig katiajaju ainawai. ");
INSERT INTO agr_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Ashí Israel aents aidau namak Jordágnum katiajagmatai, Tuke Pujuu Josuén chichajak: ");
INSERT INTO agr_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Israel wegantu aina nuwiya maki makichik etegjam doce aents yajuakta. ");
INSERT INTO agr_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Dutikam ishiakta namaka ejapeen, sacerdote ijuna nuwiyan doce kayan yajuaktinme. Dutikawag yamai dita tuwi kajigtatua nuwi ijumjatnume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Tusa tima Josué doce aents etegjamu aidaun untsuka ijumag ");
INSERT INTO agr_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","chichajak: “Namak kuyua buku wajasa nuna ejapeen Tuke Pujuu atumi Apajuíjiya nuna chichame umiktin agagbau egkeamu puja nuwi wetajum. Nunikjum maki makichik kaya jukitajum. Tuja ashí ijumjamak doce kaya atatui. ");
INSERT INTO agr_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Nunú kaya ijumjattajum nunú atatui atumi uchijum aidau atakea duwi inimpainak: ‘¿Wagka jusha kayash jutikaish ijumjamuita?’ tujamainakui, ");
INSERT INTO agr_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","atum ayaakjum: ‘¡Chicham umiktin agagbau egketun arcan sacerdote aidau yanaki jukiag namak Jordágnum wajawagmatai, namak jimaituk kanaka buku wajasbaunum ii katiajuitag nuna anemtijamjatin auk ijumjamui!’ titinaitjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Tusa tima Josué tibaunak imatiksag umikajui. Dutikainak Israel wegantu doce aajakua dutiksag doce kaya jukiag dita batsatbaunum ejegawajui. Dutikawag Tuke Pujuu Josuén chichajak, dutikatnume tibaunak imatiksag doce kayan ijumjajui. ");
INSERT INTO agr_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Tuja Josué niishkam dutiksag namak kuyua buku wajasbaunum, nuna ejapeen sacerdote aidau chicham umiktin egkeamun arcan yanasa ijunbaunum, nuwi doce kayan yajuak ijumjauwai. Duka yamaikish awai. ");
INSERT INTO agr_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Tuja sacerdote aidau chicham umiktin agagbau egketun arcan yanaki jukiag wedauk namak Jordán kuyua buku wajasmatai nuna ejapeen ijunai, Israel aents aidauk Tuke Pujuu Josuén akateak juna umiktinme tibaunak imatiksag umikajui. Tuja Josuéshkam Moisés akatjamunak imatiksag umikui. Nunikmatai aents aidauk shiig wamak katiajajui. ");
INSERT INTO agr_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Nunik ashí katiajagmatai, nuadui sacerdote aidau chicham umiktin agagbau egketun yanaki ijunu ditashkam katiajajui, nunikag dita emkajui. ");
INSERT INTO agr_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Tuja nuigtushkam maanitan yacha Rubén wegantu aidau, Gad wegantu aidau, Manasés wegantu jimaituk maaniaku jutai aidaun yajuakag uminas tikich Israel wegantu aidau shimamunum eemak, Moisés nuniktajum tibaunak imanisag shimuidau. ");
INSERT INTO agr_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Nunú aidauk shiig uminas cuarenta mil aents tumain jiinjag chicham umiktin agagbau egketun juki wegagtai nuwi ichichmamjag, nugka paka tepajunum yaakat Jericónmanini shiyakajui. ");
INSERT INTO agr_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Tuja nunú tsawantai Tuke Pujuu ashí Israel aents aidaun, Josuén eme anentus diitnume tiu asamtai, Moisés iwaku pujusmatai, eme anentus diijaku aina dutiksag Josuénashkam eme anentus diidau. ");
INSERT INTO agr_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Nuadui Apajuí Josuén chichajak: ");
INSERT INTO agr_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“Sacerdote aidau chicham umiktin agagbau egketun arcan yanaki ijuna nunú katiagtajum tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Tusa timatai, katigtajum tusa tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Tusa tiyajam ditashkam katiajag kukag jiinainaig, namakak bete wajas yaunchuk aajakbaunak imanisag asauwai. ");
INSERT INTO agr_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Israel aents aidau Jordágnum katiaju aina nunak mijan nagkamnamu yama nagkamchak nantu taka tsawan diez tsawaju ai katiajajui. Nunikag yaakat Jericó yantamen etsa minitaiya nuni nugka Guilgal tutainum aakmajag batsamsajui. ");
INSERT INTO agr_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Nunik batsamas doce kaya Jordágnumia yajuakbaun Josué nuwi ijumjauwai. ");
INSERT INTO agr_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Dutika ijumag Israel aents aidaun chichajak: “Atakea duwi atumi uchijum aidau inimpainak: ‘¿Wagka jusha kayash ijumjamuita?’ tusa tujamainakuig: ");
INSERT INTO agr_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","‘Israel aents aidauti namak Jordán kuyua buku wajasmatai ii katiajag’, nunú pachisjum ujaktajum. ");
INSERT INTO agr_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Tuja nuigtushkam Tuke Pujuu atumi Apajuíjum yaunchuk nayants kapantun katitkatnume tusa ukuyuauwa dutiksag, yamaishkam namak Jordágkan katitkatnume tusa ukuyua buku awajsamtai katiajujum nunú pachisjum ujaktajum. ");
INSERT INTO agr_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Nuna aatus ashí nugkanmaya aents aidau Apajuí senchigtina nuna dekawagtinai. Untsu atumek Tuke Pujuu atumi Apajuígmia nunú tuke ememattinaitjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Israel aents aidau katiagtinme tusa Tuke Pujuu namak Jordágkan ukuyua buku awajsae tabaun amorreo aents aidaun apuji aidau Jordágka amain etsa akaetaiya nuni batsamin aidau dekawajui. Tuja canaágnumia aents aidaun apuji aidau nayants Mediterraneonum batsamin aidaushkam dekawajui. Nunikag senchi ishamkag Israel aents aidaujaig kakaja maaniachmin dekapedau. ");
INSERT INTO agr_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Nuninai Tuke Pujuu Josuén chichajak: “Kaya aina anú ujumak kuchii najankata. Dutikam nuadui Israel aents aishmag aina nuna kati chuchuke ashí tsupijata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Tusa tima Josué kuchiin najankauwai. Dutika Israel aents aishmag aidaun ashí tsupijauwai. Nunak muja Aralot tutaya nuwi dutikauwai. ");
INSERT INTO agr_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Nunak dutikauwai wagki ashí aishmag wajiu maanimain aidau Egipto nugkanum batsatu jiinjau aina duka uwegshunum yujas jinawaju asagmatai. ");
INSERT INTO agr_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Tuja Israel aents aishmag aidau Egipto nugkanum batsamajaku aina duka, nuwi batsatuk ashí tsupijamu aajaku ainawai. Dutikamu ainaig Egipto nugkanum batsatu jiinag shimak, uwegshunum cuarenta mijan yujasu aina duwi uchi aishmag akiinkau aina nunú eke tsupijashbau asamtai, dutikauwai. ");
INSERT INTO agr_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Tuja aishmag wajiu maanimain aidau Egipto batsatu jiinjau aina duka cuarenta mijan uwegshunum yujasu aina duwi ashí jinawajui. Nunú aents aidauk Apajuín chichamen umigkachaju ainawai. Nuadui Apajuí ditan chichajak: “Atumi muunjum aajaku aina nuna anagkuakun, atum wegantun nugka pegkeg ajak shiig tsapaun, tagkush shiig muumpaina nuna susatnaitjai, tusan anagkuawaitag duka atumek wainkashtinaitjume”, tiuwai. Nunik jinawaju asagmatai, namak Jordágnum katiajaju aina duka tsupimakchau aajaku ainawai ");
INSERT INTO agr_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Nuadui Josué nunú aents aidaun uchiji aajaku aina nuna tsupijauwai. Wagki, ditá apaji jinawaju asagmatai, Tuke Pujuu atum nugka jukitajum tibau asa waujus shimuinak tsupimagchaju asagmatai. ");
INSERT INTO agr_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Dutika ashí tsupijajam nuna esamawagtatus dita batsatbaunmak juwakajui. Nunik batsamas ashí tsagagkajui. ");
INSERT INTO agr_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Nuwi batsataig Tuke Pujuu Josuén chichajak: “Israel aents aidau Egipto nugkanum wainka inaku waitkatai asag datsaamajaku aina nunak, yamai nagkamsan dita datsantinak emegkatjajai”, tiuwai. Nuadui nunú nugka daajiya duka Guilgal tibau aajakui. Duka yamaikish tuu daagtinai. ");
INSERT INTO agr_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Israel aents aidauk Guilgal nugka yaakat Jericónmanini awa nuwi batsamsauwai. Nuwi batsamas mijan nagkamnamu yama nagkamchak nantu taka, tsawan catorcetin Pascua pag levadurajai pachimtsuk inajuamu yutai tsawan asamtai, agkuantai ijunag jiistamaidau. ");
INSERT INTO agr_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Nunú tsawantai pag levadurajai pachimtsuk inajuamun trigo duwikbaujai yuwawajui. Untsu kashinia duwi nunú nugkanmaya ajak aidaun juukag yuwawajui. ");
INSERT INTO agr_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Nuna yuwidau asagmatai, maná kakebaunak nunú tsawantin megkaekauwai. Nuniku asamtai ataktu awagkig, Israel aents aidauk manának yuwachaju ainawai. Tuja nunú mijantinig Canaán nugkanmaya ajak aidaun juukag yuujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Makichik tsawantai Josué yaakat Jericónum jegattak pujusa aents puyajan takus wajattaman wainkauwai. Nunik jegantun iniak: “¿Amesh ii ainag nuwiyagkaitam, atsa iina shiwaaji aina nuwiyachukaitam?” tau. ");
INSERT INTO agr_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Tusa iniam nii ayaak: “Ame jimag adayam nuwiyagkesh atsujai. Wika Tuke Pujuun suntaji aina nuna apujiyaitjai”, tiuwai. Tusa tutai Josué niina eme anentus tsuntsuma nijayin nugka antig pujusa iniak: “Wajina dutikati tame nunú tujutta, nuna betek umiktajai”, tau. ");
INSERT INTO agr_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Tusa tutai nii ayaak: “¡Sapatjum ukuimakta, wagki ame wajam aanka dekas nugka Apajuí etegkamu shiig pegkegmai!”, tiuwai. Tusa tama Josué sapatjin ukuimakui. ");
INSERT INTO agr_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Israel aents aidau utsaantugmawag amupakainum ayamjumakmi tuidau asag, yaakat Jericó waitiji aidaunak shiig epenjaju ainawai. Dutikamu asamtai makichik aentskesh waimainchau, tuja agaagkesh jiinmainchau aajakui. ");
INSERT INTO agr_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Tujash Tuke Pujuu Josuén chichajak: “Jericó apujin niina suntaji aidaujaí depetuk ijinati tusan amina idaitusjame. ");
INSERT INTO agr_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Tuja atum suntag Israel aents aidautijum ¡makichik tsawantai makichkia Jericó tentea ukutajum! Duti dutikakuajum seis tsawan ejetajum. ");
INSERT INTO agr_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Tuja yama nagkamchakug siete sacerdote aidau maki makichik umputai uwig aishmagku kachuji najanamun takus emkatnume. Nunikag tikich sacerdote aidau chicham umiktin agagbau egketun arcan jukiag ukunum wenai dita eemak shimittawai. Nuninai suntag aidauk nuna ukujin shimittawai. Untsu tsawan sietetin sieteya imania yaakat tenteattagme. Tuja siete sacerdote aidau uwija kachujin takakuina nunú yaaktan tentea shimuinak umpuiniagtatui. ");
INSERT INTO agr_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Nunú uwija kachuji umpuamun yapajia nuni senchi umpuinakui senchi untsumkatajum. Imatjumin yaakat peejamua nunú kupinak iyattawai. Nunikmatai pisajajum yaakat Jericó utsantuattagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Tusa tima Josué sacerdote aidaun untsuka ijumag chichajak: “Atum chicham umiktinun Tuke Pujuu amasbau egkeamu arca yanaki jukijum Jericó tenteajum wetajum. Untsu atuminia siete aents aidau maki makichik uwija kachujin takus emkatnume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Aatus tusa ukuak, suntag Israel aents aidaun ashí ijumag chichajak: “Atum aidautigmeshkam wetajum. Nunikjum yaakat tenteatajum. Tuja aents maanitan yacha aina nunú sacerdote aidau arcan yanaki juki wena nuna emtin shimiagtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Tusa timatai imatiksag umikajui. Nuadui siete sacerdote aidau maki makichik uwija kachujin jukiag umpui umpuinakua shimuidau. Nunik shimuinai nuna ukujin tikich sacerdote aidau arcan yanaki jukiag shimuidau. ");
INSERT INTO agr_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Tuja aents maanitan yacha aidauk sacerdote aidau shimamu emtin shimuidau. Nuninai untsu tikich suntag aidauk, sacerdote chicham umiktin agagbau egketun juki wena nuna ukujin shimuidau. Nuninai sacerdote uwija kachujin takaku aidauk umpui umpuinakua shimuidau. ");
INSERT INTO agr_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Israel aents suntag aidau eke jiinag shimatsaig Josué ditan chichajak: “¡Makichkish chichatsuk takamtak wetajum, wi untsumkatajum takui shiig senchi untsumkatin asajum!”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Sacerdote aidau arcan yanaki juki wena nunú yaaktan makichkia tenteatnume tusa Josué tiuwai. Tusa tima shiyakag makichkia tenteawag ukuinak waketug ditá batsatbaunum kaunawag nuwi kajigkajui. ");
INSERT INTO agr_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Nunikag kashinia duwi Josué kashikmas nantakmatai, Israel aents aidaushkam ashí nantajajui. Nunikagmatai sacerdote aidau arcan yanaki jukiajui. ");
INSERT INTO agr_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Nunik shimiagtai aents maanitan yacha aidau eemag shimuidau. Untsu ditá ukujin sacerdote aidau uwija kachujin makichkish ayamtsuk umpui umpuinakua shimujakajui. Tuja nuna ukujin sacerdote arcan yanaki jukiag shimuinai, nuna ukujin inagnamunum suntag aidau shimuidau. Tuja kachu umpuamuk tuke shinu au. ");
INSERT INTO agr_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Kashinia duishkam dutiksag yaaktan tenteawag ukuinak dita batsatbaunum waketjajui. Duti dutikainakua seis tsawantan ejeyajui. ");
INSERT INTO agr_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Untsu tsawan sieteya duwi sacerdote aidau suntag aidaujai ejampek nantajag yaunchuk dutikamunak betek yaaktan tenteawag shimuidau. Untsu nunú tsawantin sieteya imania tenteawajui. ");
INSERT INTO agr_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Tuja sacerdote aidau sieteya imania uwija kachujin umpuiniagtai, Josué aents aidaun chichajak: “¡Senchi untsumkatajum! ¡Wagki Tuke Pujuu juju yaaktanak depetuk tsaiktinme tusa iina idaitugmase! ");
INSERT INTO agr_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Au yaakta duka ashí nuwi wajig ayawa nujai tsainkattawai, wagki Tuke Pujuu nunikti tiu asamtai. Untsu nuwa akika dutiktai Rahab ashí tikich aidaujai niina jeen batsamiagtata duka makichkish maawaigpa, wagki aents dekamatnume tusa wi ishiakbau aidaun nii uuka ayamjuku asamtai. ");
INSERT INTO agr_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Tuja atumshakam kuitamamkatajum, wainka nuwiya waji aina duka makichkish jukigpa. Nuigtush achitkesh achikaigpa, wagki nunú aidaunak Apajuí ashí tsaiktinme tujabiuwai. Untsu nunú atum umishtaik, Apajuí iina yaaktajin tsaigtamainai. Nuna dutikamtaig utugchatak iinu amainai. ");
INSERT INTO agr_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Untsu oro, plata, tuja ashí waji bronce, hierro aatus najankamu aina duka Tuke Pujuu anagkuamu atatui. Nunú aina duka yajuaka, waji akik Apajuínu aidau egketainum egkenattawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Nuna aatus Josué Israel aents aidaun ujaka inagnakmatai, sacerdote aidau uwija kachujin umpuajajui. Nuna antuinamuik Israel aents suntag aidauk senchi untsumaidau. Imatuinai yaakat peejamu kupinak iyauwai. Nunikmatai pisajug yaaktan utuawajui. Nunikag yaaktan utsantuawag aents aidaun depetuk ijinawag, yaaktanak dita atainiajui. ");
INSERT INTO agr_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Dutikawag nuadui aents aishmag aidaun, nuwa aidaun, datsauch aidaun, múuntuch aidaun, ashí ijinawajui. Dutikainak buey aidaun, uwig aidaun, burro aidaunashkam ashí ijinawajui. ");
INSERT INTO agr_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Dutikawag nuadui aents nugka dekatatus yujasu aidaun Josué chichajak: “¡Nuwa akika dutiktai puja nuna jeen wetajum. Nunikjum nii jiyakjum tikich aidau niijai batsatushkam ashí jiigtajum, atum wajintu nii anagkuawaitjume dutiksagmek!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Tusa tiajam wayawag Rahab, niina apaji, dukuji, umayi aidau, kai aidau, nuigtu niina patayi aidaujai batsatun ashí jiijajui. Dutikawag ditá batsamtaijin ukumtikiag agkan ishamain atsaunum batsasu ainawai. ");
INSERT INTO agr_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Nuna dutikainai suntag aidau yaaktanak ekemakag ashí apeawajui. Untsu oro, plata, tuja waji bronce, hierro najankamu aidaunak apeachajui. Nunak ayatak jukiag waji akik Tuke Pujuunu aidau egketainum egkeawajui. ");
INSERT INTO agr_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Nuna imatika ashí ijinkush, Josuék Rahabnak niina patayi aidaujai maachui, wagki aents nugkan dekatnume tusa Jericó ishiakbau aidaun maawainum tusa uuka uwemtikjau asamtai. Dutika maachbau asag, Rahab wegantu aidauk yamaikish Israel wegantu aidaujai batsamin ainawai. ");
INSERT INTO agr_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Nuna ashí dutika atakea duish tuke uminkatnun pachis Josué juna aatus tiuwai: “Makichik aentskesh yaakat Jericó tsaikbauwa nuna ataktu jegamjatjai tusa takug, niina uchiji iwai mantamnattawai. Nunikmatai takatan takau aidau nuna iyashin aepawag nuwi ekeniag jegamjagtinai. Tuja niina uchiji ekeushkam nunisag mantamnattawai. Nunikmatai nuna iyashinashkam aepawag nuwi ekeniag yaakta waitijin najanawagtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Josuénak Apajuí yaigkui, nuadui ashí aents tikich nugkanum batsamin aidaush niina wajiujinak shiig dekajujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Josué Israel aents aidaujai Jericón tsaikajua dutiksag tikich yaakat Ai tutainashkam tsaikajui. Dutikawagmatai yaakat Gabaógnumia aidauk ishamainak Israel aents aidaujaig maaniachmi tusag chichaman umikaju asag, ditajai ijunag batsatui tabaun Adonisédec Jerusalégkan apuji dekauwai. ");
INSERT INTO agr_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Nunik dekaa yaakat Gabaógkak tikich yaakat Ai tutain Israel aents aidau tsaikajua nuna nagkaesau múun, kuashat apugtin tuja nuigtushkam suntag aidaush maanitan yacha aidau asagmatai, niina aentsji aidaujai shiig senchi ishamkajui. ");
INSERT INTO agr_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Nuadui Adonisédec yaakat Hebrógka apujin Hohaman, yaakat Jarmutan apujin Piraman, yaakat Laquisha apujin Jafían, yaakat Eglógka apujin Debiran aatus chichaman akuptukui. Dutikawajam chichama etsejin aidau ditan ujainak: ");
INSERT INTO agr_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“Apu Adonisédec chichaak: ‘Gabaón aents aidauk maanitsuk agkan batsamsagmi tusag Josuéjai, tuja Israel aents aidaujaishkam chichaman umikaje. Nuniku asagmatai ipajime kaunatajum. Nunikjum Gabaón aents aidaujai maaniamu atutkatajum’ ”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Tusa tiajam cinco apu amorreo aents aidaun apuji aidau: Yaakat Jerusalégnumia, Hebrógnumia, Jarmutnumia, Laquishnumia, Eglógnumia aatus ijunag dita suntaji aidaujai Gabaón jetekmi tusag shiyakajui. ");
INSERT INTO agr_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Nuna Gabaón aents aidau dekawag ditashkam Josué Guilgal pujaun chichaman akuptuinak aatus tiajui: “Ii atumjai chicham umiaku: ‘atumi inake agmi’, timaiji. Nuniau asamtai atum jutiik ayamkagtumainaitjume. Nuadui amina suntajum aidaujai kaunajum ayamkagtuktajum, wagki amorreo aents aina nuna apuji aidau mujanum batsamin aina duka ashí ijunjaje jetepakagtatus”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Nuna antuk Josué Guilgal pujau niina suntaji maanitan yacha wajiu aidaun yajuak ijumjauwai. ");
INSERT INTO agr_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Dutika umikmatai eke wegachunak Tuke Pujuu Josuén chichajak: “Amorreo aents aina duka ishamkaipa, amina idaitusjame, nii depetuk ijinati tusan. Nuadui makichik aentskesh dita aina nuwiyag amejai igkunia maanimainuk shiig atsuttawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Tusa tima Josué Guilgal pujau Israel aents aidaujai jiinag kashi shima shimakua jegawajui. Nunik amorreo aents aidau gabaógnumia aidaun jetektatus anutujag batsamtaun pachiachbaunum jetekajui. ");
INSERT INTO agr_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Tuja amorreo aents aidaunak Tuke Pujuu Israel aents aidau jetenam ishamkatnume tiuwai. Tusa tibau asamtai Josué amorreo aents aidaun Gabaógnum shiig kuashat amukui. Dutika amuam jinta Bet-horón wetainum pisatai pataetukag mai mainakua, yaakat Azecá yaakat Maquedájai aajakua imanui jegawajui. ");
INSERT INTO agr_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Tuja tikich aents amorreo aidauk Israel aents aidaun ishamak yaakat Bet-horón jegattak shimittaman, Tuke Pujuu bichan kayajai betek akaketuk Israel aents aidau puyajai ijinau aina nuna nagkaesau ijinauwai. ");
INSERT INTO agr_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Tuke Pujuu amorreo aents aidaunak Israel aents aidau amuktinme tibau asag amukajua nunú tsawantin Josué niina suntaji aidau emtin Tuke Pujuun segaak aatus tiuwai: “¡Etsayah, Gabaón mamiksam jasa ekemsata! ¡Nantuh, ameshkam nain ségaju Aialón tutaya nunú mamiksam jasa ekemsata!” ");
INSERT INTO agr_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Tusa tima etsa nantujai jasa asauwai, nunikmatai Israel aents aidau dita shiwaajinak ashí depetuk amukajui. Tuja Israel aents aidaush wajuk nunash yujasajamkiyi duka imatiksaik papii Jasher tawa nuwi agagbau aajakui. Tuja etsak akaetsuk makichik tsawan tumain jasa asauwai. ");
INSERT INTO agr_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Nunak yaunchuk aents aidau Tuke Pujuun segajaku aina duikish dutikashbaun nunú tsawantin dutikauwai. Nunú tsawantai Tuke Pujuu Israel aents aidaun ayamjak shiig paan maaniauwai. ");
INSERT INTO agr_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Tuja Josuék nunik depetmak Israel aents aidaujai dita batsamtaijin Guilgalnum wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Yaakat Siquemnum Josué Israel aents aidaun ashí ijumjauwai. Nuwi Israel aentsu apuji múun aidau, apu chichama epegkin aidau, suntaja apuji aidau aatus, aak pegkejam Apajuíjai chichatai aakmakbaunum niinis ijunjajui. ");
INSERT INTO agr_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Nunik ashí ijunjamtai Josué chichajak: “Tuke Pujuu atumi Apajuíjum juna aatus tujamainawai: ‘Yaunchuk atumi muunjum aajaku aidau: Térah niina uchiji Abraham, Nacor, aatus namak Eufratesa amain batsamas dita apajuímtaijin emematujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Nuni batsatun wi Abrahaman jiiki jukin juju Canaán nugka juwi itaan awekasuitjai. Tuja nuigtushkam nii wegantun kuashat ikauntukuitjai. Yama nagkamchaknuk susauwaitjai niina uchijin, Isaakan. ");
INSERT INTO agr_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Tuja Isaakan susauwaitjai jimag uchijin: Jacopan, Esaújai. Tuja Esaún susauwaitjai muja ikam tepau Seír tutain. Untsu Jacob niina uchiji aidaun yajuak Egipto nugkanum weuwai. ");
INSERT INTO agr_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","“ ‘Nunika nuwi kuashat mijan batsatai, wi Moisésan Aarógjai akuptukuitjai ditan yaigtinme tusan. Dutikan egiptunmaya aents aidaunak shiig senchi suwimka susan waitkasan atumi muunjum aidau nuwi batsatun jiijuitjai. ");
INSERT INTO agr_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Tuja atumi muunjum aidau Egipto nugkanum batsatu jiinjamtai, nuwiya aents aidau carro maanitai aidaun caballo aidaujai yajuakag pataetukag nayants kapantunum ejegawajui. ");
INSERT INTO agr_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Dutikainam, yainkata tusag mina untsugkajabi. Tujutuinakui egiptunmaya aidau shimamu emtin, tuja Israel aents aidau batsatbau ukujin suwe awajsamiajai. Tuja nayants buku wajasbaunum katidaun yumi pimak ijinati tusa ti ai, egiptunmaya aidau nayants yutuam jinawabi. Wi nuna Egipto nugkanum dutikauwaitag duka atumek shiig wainkauwaitjume. “ ‘Nunikjum kuashat mijan uwegshunum yujasuitjume, ");
INSERT INTO agr_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","nunika yujautigmin yajuakan namak Jordágka amain etsa minitaiya nuni amorreo aents aidau batsamtaijin ikaunmawaitjime. Dutika ai amorreo aents aidau atumjai maaniawajabi. Tujash wi ditan ijinatnume tiu asamtai, atum depetkajum ijinauwaitjume. Dutikajum dita nugke aidauk atum jukiuwaitjume. ");
INSERT INTO agr_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","“ ‘Tuja tikich tsawantai Balac Sipora uchiji Moab aents aidau apuji atumjai maaniatatus kautjamkajui. Nunik chichama etsejin aidaun akateg Balaam Beora uchiji ujaktajum, dutikam nii atumin pegkegchaunum yumigtamjatnume tusa tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Tujash Balaam pegkegnum yumigtamjatnume tusan wi ti ai, pegkegnum yumigtamjajabi. Dutikan ayamjukuitjime. ");
INSERT INTO agr_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Dutika ayamjukbau asajum namak Jordán katitkajum Jericó kaunawaitjume. Tuja Jericónum batsamin amorreo aents aidau, Canaán aents aidau, hitita aents aidau, gergeseo aents aidau, heveo aents aidau, Jebús aents aidau aatus atumjai maaniawajui. Tujash wi ditanak atumin idaitusuitjime. Nuadui atum depetka amukuitjume. ");
INSERT INTO agr_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Tuja atum aidautijum amorreo aents aidaun apuji jimag aajakua nunú dita aentsji aidaujai depetkauwaitjume. Tujash duka atum ima senchigtin asagmekesh, atsa atum maanit ima yacha asagmekesh dutikachuitjume. Nunú depetkauwaitjum nunak wi atumin ishamjamkatnume tibau asag, ishamjamaidau asagmatai depetkauwaitjume. Nuadui atumek eke jegatsjuminig, ishamjamak pisaju aina nunak nuniku ainawai. ");
INSERT INTO agr_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Nuadui yamai atumek tikich aents aidau jegamjamunum batsatjume. Tuja uva aidau, oliva aidau ajakmakbau juuka yuwajum dushakam dita ajakbaunmaya yuwagme. Wagki wi juju nugkanum ayá nunak ashí nugkajai atumin amasuitjime’, tawai Apajuí”, tusa Josué tiuwai. Tuja nuigtu Josué chichaak: ");
INSERT INTO agr_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“Nunú ashí anentaimtusjum Tuke Pujuu eme anentsa emematkujum dekaskenum umigkatajum. Tuja yaunchuk atumi muunjum aidau namak Eufratesa amain etsa minitaiya nuni batsamas ditá apajuímtai aidaun emematujaku aina duka idaisatajum. ¡Nunikjum ima Tuke Pujuuk umigkatajum! ");
INSERT INTO agr_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Tuja atum Tuke Pujuu umigkatasa wakegashkugmek, yamai titajum ya umigkatag tajume nunú. Yaunchuk atumi muunjum aidau namak eufratesnum batsamas dita apajuímtaiji aidaun emematujaku aina duka ememattag tajum, atsa nuniachkugmesh amorreo aents juju nugkanum batsamin aina nuna ememattai aina duka ememattag tajum, nunú titajum. Tuja atum Tuke Pujuu emematut dakitakjuminish, ¡wika mina pataag aidaujai Tuke Pujuun umigkun ememattatjai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Tusa tutai Israel aents aidau chichainak: “¡Wainka apajuímtai aina duka ememattsuk ima Tuke Pujuuwa duke emematuinaku umigkagmi taji! ");
INSERT INTO agr_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Ii aidautin iina muunji aajaku aina nujai Egipto nugkanum inaku waitkatai batsatutin jiipajua duka Tuke Pujuu iina Apajuíjiyai. Niiyai wainchatai aidaun iish wainjin iwainajua nunú. Tuja nuigtushkam jiinja shimaku kuashat aents aidau batsatbaunum shimajinish nii kuitamjamu asa ayamjutpakui. ");
INSERT INTO agr_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Ii shimamunum tikich aents aidau ayaunash nii jiija ishiakui. Amorreo aents aidau juju nugka juwi batsamin aajaku aina nunashkam nigki jiija utsagkui. Nunú anentaimtusa ¡Tuke Pujuu umigkagmi taji, wagki niyai iina Apajuíjiya duka!”, tuidau. ");
INSERT INTO agr_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Tusa tiagtai Josué ditan chichajak: “Atumek Tuke Pujuuk kakajus umigmain dekapeatsjume, wagki Apajuík pegkegmai, akasmatnash akasmauwai. Iman asa atum niijai shiwagmaekujum pegkegchau takamugminak atsanjagkesh idaitugmamaitsui. ");
INSERT INTO agr_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","“Atum aidautijum nii umigtsuk kajimatki idaikujum, tikich wainka apajuímtai aina nunú emematu yujagminig, wait anenjamag ayamjutpak uwemtijamjau akush, tuke suwimkanak amasagtinai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Tusa tutai Israel aents aidau chichainak: “¡Duka nunikchattawai, iik ima Tuke Pujuuk umigkagmi taji!” tuidau. ");
INSERT INTO agr_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Tusa tiagtai Josué chichaak: “Tuke Pujuu umigkagmi tusa tajum duka kame atumesh dekas umigmain asagmes tajumtai”, tiuwai. Tusa tama dita aimainak: “¡Iishkam ame tame dutiksaik anentaimji!” tiajui. ");
INSERT INTO agr_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Tusa tiagtai Josué ditan chichajak: “Nunú takugmek anú wainka apajuímtai aidau atum pujamunum ayá nunú utsagtajum. Dutikajum Tuke Pujuu atumi Apajuíjum, atumi anentaimijai ememattajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Tusa timatai Israel aents aidau aimainak: “¡Ii aidautik Tuke Pujuu iina Apajuíjiya duke emematku, nii tujabauwa duke umigkami taji!” tuidau. ");
INSERT INTO agr_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Tusa tiagmatai yaunchuk Apajuí Moisésjai chichaman umikua dutiksag, Josué ashí Israel aents aidaujai nunú tsawantinig yaakat Siquemnum Apajuíjai chichaman umikajui. Nunú chicham umikbaun ditan susauwai umiktinme tusa. ");
INSERT INTO agr_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Dutika nuadui Apajuí chichame umiktin agatainum agajui. Duwi kaya muuntan juki aak pegkejam Apajuíjai chichatai aakmakbau aajakua nuna yantamen numi encina tutai wajaunum nuna wakentin apusauwai. ");
INSERT INTO agr_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Dutika apujus ashí Israel aents aidaun chichajak: “Atumek dekagme ii umiktin pachisa chicham taji nuna makichik tuké anta nunú. Nunú chicham ii umiamun aents wajas antauwa numamtin atata duka juju kaya nunuwai, wagki yamaya juwi atum aidautigmin Tuke Pujuu tujamiaja nunú umiktin pachisjum titin asagmin. Juju wainkujum Tuke Pujuu umijin amí tusa tajum nunú tuke aneasjumke atinaitjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Nuna ashí tusa inagnak Josué Israel aents aidaun waketjatajum tusa maki makichik dita nugken ishiakui. ");
INSERT INTO agr_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Dutika ishiak kuashat tsawan weatsaig, Josué Tuke Pujuun inake aajakua duka ciento diez mijanan ejeyi pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Nunikmatai muja Gaash tutai awa nuwi niina nugke Timnat-Sérah daagtin Efraígka nugken awa nuwi ukusajui. ");
INSERT INTO agr_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Tuja Josué pujusmataig Israel aents aidauk ima Tuke Pujuunak umijujaku ainawai. Tuja Israel aents aidaun yayaak kuashat waji wainchatai aidaun Apajuí iwainajua nuna apu múun aidau wainkau aina nunú batsamsamtaishkam ima Israel aents aidauk Apajuínak umijujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Israel aents aidau Egipto nugkanum batsatu jiinag shimak José ukunchin jukiaju aina nuna yaakat Siquemnum ukusajui. Nunak Hamor Siquem aajakua nuna apaji nugken Jacob cien kuichik jiju plata tutai najanamui akikmak sumakua nuwi ukusajui. Nunú nugkanak José wegantu aidau jukiu ainawai. ");
INSERT INTO agr_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Eleazar Arónka uchiji jakamtai, Efraín nugkanum niina uchiji Fineesa nugke mujá aajakua nuwi ukusajui.");
INSERT INTO agr_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","Apajuí ángel tumain Guilgalnumia juwaki Boquimnum weuwai. Nunik jegaa Israel aents aidaun chichajak: “Atumnak Egipto nugkanum batsatutigmin wi jiigmaijime. Dutikan juju nugka juna atumi muunjum aidaun anagkuakun, atumi uchijum wegantu aidaun susatnaitjai, tiuwaitag nuwi itajime. Ditan chichajuinakun: ‘Wi atumjai chichaman umikag nunak tuké umiktinaitjai’, tiuwaitjai. ");
INSERT INTO agr_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","“ ‘Tuja untsu atum aidautigmek juju nugkanmaya aents aina nujaig makichkish chichamak umikaigpa. Ayatak dita apajuímtaiji dakumkamu aina nunú tsaigka utsankatajum’, tiuwaitjime. Tujash atumek duka umigtukchauwaitjume. ¡Yamaikish juju umikugmek, aniau asajum umigtukchau ainagme! ");
INSERT INTO agr_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Nuadui yamai tajime: ‘Au aents aidau atumjai batsata nunak jiignuk utsagchattajai. Nuadui dita apajuímtai aidaujai atumin tsanupajagtatui’ ”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","Tusa nunú Apajuí ángel tumain chichaka inagnakmatai, ashí Israel aents aidauk shiig senchi buutuidau. ");
INSERT INTO agr_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","Nuadui nunú nugka daajin Boquim adaikau ainawai. Tuja nuwi kuntinun maawag apeenak Tuke Pujuun emematiajui. ");
INSERT INTO agr_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Nuna Josué tusa inagnakmatai, Israel aents aidau maki makichik ditá nugken waketjajui. ");
INSERT INTO agr_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Tuja Josué pujusmataig Israel aents aidauk ima Tuke Pujuunak umijujaku ainawai. Nuigtushkam Israel aentsu apuji múun aidau Tuke Pujuu ditan yayaak kuashat dutikauwa nuna wainajaku aidau batsamsamtaishkam, ima Apajuínak umijujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Tuja Josuék ciento diez mijan ejeyi pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Nunik jakamtai, muja Gaash tutainum, Efraígka nugken niina nugke Timnat-Sérah tutai awa, nuwi ukusajui. ");
INSERT INTO agr_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Tuja Josuéjai betek batsamajaku aina dushakam múun waigkag jinawajui. Nunú jinawaju ai batsamas akiinkau aidauk Tuke Pujuunak dekajakchau ainawai. Tuja Apajuí ditan ayamjak wainchatai aidaun kuashat iwainajua nunakesh dekachaju ainawai. ");
INSERT INTO agr_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Israel aents aidaun uchiji aidauk Tuke Pujuu diismak shiig pegkegchaun takajaku ainawai. Nuniau asag wainka apajuímtai Baal aajakua nuna emematujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Nuninak ditá muunji aidau Egipto nugkanum batsatun Tuke Pujuu jiijua nunak kajimatki idaisajui. Nuninak nuwiya aentsu apajuímtai aidaun emematuidau. Nuniagtai Tuke Pujuu ditan senchi kajegkauwai. ");
INSERT INTO agr_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Aatus Israel aents aidauk Baal, Astartéjai dakumka najanamu aidaun emematuinak Apajuí ememattanak kajimatki idaisajui. ");
INSERT INTO agr_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Nuadui Tuke Pujuu Israel aents aidaun kajejuk dita wajiji aidaun shiwag aidau kasajug yajutkatnume tusa idaisauwai. Nuigtushkam Israel aents aidau batsatbaunum nuna yantamen ditá shiwaaji aidau batsata nunú jetekag depetuk amuktinme tusa idaisauwai. Nuadui Israel aents aidauk ayamjumamainchau wajasui. ");
INSERT INTO agr_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Tuja maaniawagtatus shimiagtaish, Tuke Pujuu ditanak yaijakchauwai. Dutika yayachbau asag maaninakush depetmajakchau ainawai, Apajuí tibaunak imatiksag. Tuke Pujuu ditanak maaninakush kakaag iikmamainchau awajsauwai, ");
INSERT INTO agr_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","nuna dutikakush Israel aents aidaun kasajuidaun ayamjuktinun apu chichama epegkin aidaun adaitujui. ");
INSERT INTO agr_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Tujash Israel aents aidauk apu chichama epegkin aidau adaijamunash umigkachaju ainawai. Nunidau asag Apajuínak umigtsuk tikich wainka apajuímtai aidaun emematujaku ainawai. Untsu ditá muunji aajaku aina duka Apajuí chichamen umijujaku ainawai. Tujash ditak Tuke Pujuu chichame umigtanak dakitug idaisau ainawai. ");
INSERT INTO agr_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Tuke Pujuu apu chichama epegkin atinun adaikag tuké yaijakui. Nunú apu aidau batsamsamtaig, Israel aents aidaunak ditá shiwaaji waitkagtaish Tuke Pujuu ayamjujakui, wagki waituinak chichainamun antuju asa. ");
INSERT INTO agr_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Untsu nunú apu adaikamu aidau jakamtaig, ataktushkam nunisag Apajuí ememattan kajimatkiag wainka apajuímtai aidaun emematujaku ainawai. Ditak yaunchuk ditá apachji aajaku aina nuna nagkaesau pegkegchau aajaku ainawai. Nunidau asag aents antakchaujai betek ima pegkegchaunak takajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Nuadui Tuke Pujuu ditan kajejuk chichajak: “Juju aents aina juka wi yaunchuk ditá apachji aidaujai chichaman umikuitag nunak uminatsui. Nunidau asag minak umigtuinatsui. ");
INSERT INTO agr_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","Nuadui juju nugkanmaya aents aidaun Josué jiija utsag emau nii jak ukukbau batsata nunak wishakam jiignuk utsagchattajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Nuna tiuwa nunak: “Juna antukajash yaunchuk ditá muunji aidau Tuke Pujuun emematujaku aina nunisag ditash Tuke Pujuun emematchajaintash tusa dekapsatatus”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Nuna tau asa nuwiya aents aidaun Josué eke jiigchauwa nunak Tuke Pujuushkam jiigchauwai, ayatak idaisauwai batsamsatnume tusa. ");
INSERT INTO agr_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Ehud jakamtai pujusag Israel aents aidauk Tuke Pujuun umigtsuk ataktushkam pegkegchaun takaidau. ");
INSERT INTO agr_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Nuniagtai Jabín canaágnumia aents aidaun apuji, yaakat Hasornum inamajakua nunú, Israel aents aidaun depetuk amuktinme tusa Tuke Pujuu idaisauwai. Jabígkan suntaji aidaun apuji aajakui Sísara. Duka Haróset-goím tutainum pujujakui. ");
INSERT INTO agr_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Jabígnak ajujakui novecientos carro hierro najanamu aidau. Nuadui Israel aents aidaunak veinte mijanai waitka batsamtuidau. Imatika waitka batsamtam ditashkam Tuke Pujuu yaimpakti tusag senchi segau ainawai. ");
INSERT INTO agr_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Tuja Israel aents aidaun waitkajaku aina nunú tsawantinig Lapidot aajakua nuna nuwe Débora, Apajuí chichamen etsejujakua nunú, apu chichama epegkin aajakui Israel aents aidaunum. ");
INSERT INTO agr_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Déborak palmera wajautin tuké ekemajakui. Nuadui aents aidau nunú palmeran “Débora palmeraji” tiu ainawai. Duka Efraígka mujaji tutainum yaakat Ramá Beteljai niniaku aajakua nuna ejapeen aajakui. Nuwi Débora pujau asamtai, Israel aents aidau shimutujaku ainawai, chichaman epegtujuati tusag. ");
INSERT INTO agr_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Tuja makichik tsawantai Abinoáma uchiji Barac Neftalí wegantu aidau nugken yaakat Quedesnum pujuttaman, ujaka utitajum tusa Débora makichik aentsun akuptukui. Dutika ujakam taamtai chichajak: “Tuke Pujuu Israel aents aidau emematin aina nunú Apajuí juna aatus chichaak: ‘Muja Tabornum weti. Nunik nuwi Neftalí wegantu aidaun Sabulón wegantu aidaujai ipaa diez mil aentsun ijumjati. ");
INSERT INTO agr_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Tuja Jabígka suntaji aina nuna apuji Sísara, atumin jetepaktatus niina carroji aidaunum namak Quisónnum kaunatnume titatjai. Nunikmatai wi atumin idaitustatjime depetuk ijinatnume’, tusa Tuke Pujuu tujamui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Tutai nii ayaak: “Wika amejai wetatjai. Untsu ame minachkuminig wikik wechattajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Tutai Débora ayaak: “Wika amejai wetatjai. Wagki Tuke Pujuu Sísaranak nuwa maati titatui. Nuadui juju maaniamunum ame nagkamatin akumesh Barac maania depetmake, tamak achattame”, tiuwai. Nuna tusa Baracjai yaakat Quedesnum weuwai. ");
INSERT INTO agr_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Nuwi Barac jegaa Sabulón wegantu aidaun Neftalí wegantu aidaujai untsuka diez mil aentsun ijumjauwai. Nunik wetai Déborashkam Baracjai weuwai. ");
INSERT INTO agr_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Untsu Moisésa wegaji Hobab aajakua nunú wegantu quenita aents aajaku aina nuwiya makichik Heber daagtin niish kanak, yaakat Quedes jegattak nugka Saanaim numi encina ayamunum pujujakui. ");
INSERT INTO agr_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Tuja Barac niina suntaji aidaujai muja Tabornum wakae tabaun Sísara dekauwai. ");
INSERT INTO agr_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","Nunik novecientos carro hierro najanamu aidaun yajuak niina suntaji aidaujai ijunjauwai. Dutika ditajai yaakat Haróset-goím batsatu jiinag shima shimakua jegawajui entsa Quisónnum. ");
INSERT INTO agr_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Nunikagmatai Débora Barakan chichajak: “¡Pai, yamai maaniata, Tuke Pujuu Sísaranak amina idaitugmase! ¡Amina suntajum aidau shimamunmak Tuke Pujuu eemak weawai!” tiuwai. Tusa tima Barac muja Tabor pujau niina suntaji aidaun diez mil yajuak akaikiuwai. ");
INSERT INTO agr_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Nunikag igkuniawag maaninamunum Sísara suntaji aidauk carronum yujas maanin aidaujai Baraka puyagjin ishamkajui. Nunak Tuke Pujuu nuniktinme tiu asamtai, imanisag ishamak maanimainchau dekapenak pisajajui. Tuja niina suntaji aidau pisagtai, Sísarashkam niina carrojin egketu akaiki tupikakiuwai. ");
INSERT INTO agr_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Nunik Sísara tupikakmatai, suntag aidauk tikich suntag carronum yujas maanin aidaujai pisaidau. Nunittaman Barac niina suntaji aidaujai pataetuk ma maakua Haróset-goím ejegawajui. Nuna maaniawajua nuaduik Sísara suntaji aidauk ashí ijinamu asa makichik iwakukesh juwakchauwai. ");
INSERT INTO agr_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Tuja Jabín, Hasoran apuji aajakua duka, quenita aents Heberan patayi aidaujaig maaninachu asagmatai, nuwi Sísarak Hebera nuwe Jael pujamunum tupikaki jegauwai. ");
INSERT INTO agr_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Nunikmatai Jael jiintuki igkug chichajak: “¡Mina apujuh, ishamkagtutsuk juwi wayata!” tiuwai. Tusa tima wayamtai, jáanch dupagman juki dukuka uukui. ");
INSERT INTO agr_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","Dutikam pujusa senchi kitamak yumin uwagtatus Jaelan segauwai. Tusa segam duwap apagbaunum leche yajaa ukukbaun ujaka juki susauwai. Dutika susam nuna uwagmatai, ataktu dukuk idaisauwai. ");
INSERT INTO agr_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Dutikam Sísara niina chichajak: “Waitinum pujusta, nuniamin makichik aentskesh inimpak juwi pujatsuak tujamkuig, atsawai tita”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Nuna tusa Sísarak yaweju asa, shiig senchi kanag tepesui. Nunikmatai Jael martillon juki aak jigkatasa numi tsupija etsakamun juki, takamtak jegantun kajashkinum iju nugkajai ijumag achiauwai. Dutikam Sísarak jakauwai. ");
INSERT INTO agr_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Tuja Baracshakam Sísaran egá egakua Jaela jeen jegauwai. Nunikmatai Jael jiintuki igkug chichajak: “¡Wayata, ame egaku wekaetam nuna iwaintuktagme!” tau. Tusa tama waya diikma, Sísarak yaunchuk buuknum iju chigkam jaka tepaun wainkauwai. ");
INSERT INTO agr_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Aatus Apajuí Israel aents aidau wainainamunum, Jabín canaágnumia aents aidaun apuji aajakua nunak niina suntaji aidaujai depetkauwai. ");
INSERT INTO agr_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Duwi nagkamas Israel aents aidau Jabígnak nuni senchi jetedau. Ima imatikainakua ashí ijinawag idaisajui. ");
INSERT INTO agr_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","Nunú tsawantin Débora, Baracjai juna aatus kantamau ainawai: ");
INSERT INTO agr_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","“Tuke Pujuu ashí ememattajum, wagki Israel aents aidaunmak aents maaniatatus wakeyin aidaush ayawai. Tuja nuigtushkam ditá apuji aidau maaniawagmi tusa tamak utujimkas, ayu tinu aidau batsatui. ");
INSERT INTO agr_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","¡Apu aidauwah, yamai wi taja nunú antuktajum! ¡Apu atuwe aidauwah, antugtuktajum! ¡Wi yamai Tuke Pujuun kantamjuattajai! ¡Israel aents aidau Tuke Pujuun emematin aina nuna kantamjuattajai! ");
INSERT INTO agr_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","“Tuke Pujuuwah, Seír Edom nugkanum aajakua nuwi ame kuitamkagtusamin yujajin, nugka uugmayi, tuja yumishkam senchi yutujabi. ");
INSERT INTO agr_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","Tuke Pujuu Israel aents aidaun Apajuíji ememattayah, ame wainmin muja aidau uujiagmayi. Tuja muja Sinaíshkam senchi uugkauwai. ");
INSERT INTO agr_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","Samgar Anatan uchiji pujujakua nuaduik, tuja Jael pujujakua duishkam, jinta aidaunmak ishamain wekaemainchau asamtai, ditá shiwaaji aidau mantuawainum tau asag, yaja menantag jintachunum yujajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","Nunidau asag Israel aents aidauk kanajag batsamas apugtuchu kajimatkim batsatun, wi Déboran ditá ayamjuktasan, makichik nuwa uchijin ayamjuwama numamtuk wejibiajai. ");
INSERT INTO agr_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","Ashí Israel aents aidauk wainka apajuímtai aidaun emematiagmayi, nuniau asamtai, ame ditá maaniatnume tusam dita shiwaaji aidau ishitkabiume. Tujash ditak cuarenta mil suntag nagkigtin, tantaajintin ainakush sapigmaidau asag, maanimainji atsugbau wajukmaina nuniagmayi. ");
INSERT INTO agr_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","See tajame amina Tuke Pujuuwah, tuja Israel aents aidaun apuji aina nunashkam shiig anentuinajai, wagki ujumak wajiu aina nunú maaniawaju asagmatai. ¡Nuadui Tuke Pujuu ashí ememattajum! ");
INSERT INTO agr_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","Atum wiakuch aidautijum burro nuwa pujunum entsamka yujau aidautigmesh, tuja ujudauch dawenum yujau aidautigmesh, Apajuí kantamjuatajum, wagki nii depetmatan amasu asamtai. ");
INSERT INTO agr_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","¡Tagku kuitamin aidautigmesh, tuja ujudauch yaaktanum batsamchau aidautigmesh, Tuke Pujuu, Israel aents aidaun ayamjuk agkanmitkau asamtai, platillo aidau awatkujum Tuke Pujuu kantamjuatajum! ");
INSERT INTO agr_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","“¡Débora mijaakaipa! ¡Wajiu wajasta! ¡Nuniakum kantamata! ¡Barac Abinoáma uchijiyah, ameshkam mijamtsuk, aents maaniaku achigbau aidau yajuakam chimpiata! ");
INSERT INTO agr_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","“Tusa kantaman inagnai, Israel aents aidauk wi ipaamu asag, shiwag maanitan yacha aidaujai, maaniawagtatus shiyakajui. ");
INSERT INTO agr_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","Tuja Efraín wegantu ujumak aents Amalec aents aidaun nugkenia juwakiag akaejabi. Untsu Benjamín wegantu aidau nuna ukuujin shiyakagmayi. Tuja Maquir wegantun- mayashkam apu aidau shimutkabi. Tuja Sabulón wegantu aidaushkam apu aidau shimutkabi. ");
INSERT INTO agr_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","Nuninai Déboranashkam apu Isacar wegantu aidau uyuniagmayi. Nuigtushkam Barakan Isacar wegantu aidau uyuniagmayi. Untsu Rubén wegantu aidauk apu wajiu ainayatak, ");
INSERT INTO agr_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","ditá uwigji aidaun puyatjuinak batsamas: ¿Maaniatjiash, atsa maaniashtajiash? waja batsatui. Rubén wegantu aidauk múun ainayatak sapig ainawai. ");
INSERT INTO agr_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","Tuja Galaad wegantu aidauk Jordágka amain yaaktamak batsamsaje. Untsu Dan wegantu aidauk Asher wegantu aidaujai, nayantsa pakaji wegajunum lanchagtin waigkag batsamsaje. ");
INSERT INTO agr_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","Untsu Sabulón wegantu aidau, Neftalí wegantu aidaujai maaninak ishamainnum yujasu ainawai. ");
INSERT INTO agr_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","“Tuja Canaán nugkanmaya apu aidau yaakat Meguidon ijus namak awa nuwi yaakat Taanac kaunawajui, nunikag nuwi maaniawajui, tujash depetmakchajui. Nunikaju asag makichik wajinakesh jutsuk waketkiajui. ");
INSERT INTO agr_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","Israel aents aidau Sísarajai maaninakug, yaya nayaimpinum ayá nujai ijunjas maaninatai tumainun maaniawagmayi. ");
INSERT INTO agr_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","Iina shiwaaji aidau entsa Quisónkan katitkatag titatman, yumi yutug dujajak tajaka utsagke. ¡Ame shiwag senchigtin aidau depetkam, iikmak chichakchamin awajsattame! ");
INSERT INTO agr_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","¡Caballo aidau ishamkagtukag shiig senchi pisainak tutugtau antuewai! ");
INSERT INTO agr_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","Apajuí ángeltsukaita tumain chichaman etsejak: ‘¡Yaakat Meroznum aents batsata nuwi suwimak iyagti tajai!’ tiuwai. Nunak tiuwai wagki dita aidauk wajiu ainayatak, Israel aents aidau maaniagtai yaigchaju asagmatai. ");
INSERT INTO agr_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","“¡Heberan nuwe Jael quenita nuwa duka, tikich nuwa Israel aents aina nuna nagkaesau pegkegnum chichagtai atinai! Tuja nuigtushkam nii pujamunum nuwa aidau pujuina nuna nagkaesau shiig anentam atinai. ");
INSERT INTO agr_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","Sísara kitamak yumi segam, Jael lechen juki susauwai. ¡Leche kanteku shiig pegkejan pinignum yajaa juki susauwai! ");
INSERT INTO agr_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","Dutikam nuna uwag kanag tepesmatai, numi etsakamun juki martillowai kajashkinum iju nugkajai ijumag achia maabi. ");
INSERT INTO agr_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","Dutika ijum tadae tadaekawa nuwig jaka tepesmayi. ");
INSERT INTO agr_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","“Tuja Sísara dukujig uchiji megkaekamtai puyatki, jeganum niimtai ujaimunum tsapui niimas atsutai chichaak: ‘¿Wagka mina uchijush imanikash megkaekae? ¿Wagka mina uchiju carroji maanitai agma dusha megkaejae?’ timayi. ");
INSERT INTO agr_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","Tuja niina inake nuwa yacha aidau chichagtai, Sísara dukujishkam dutiksag chichaak: ");
INSERT INTO agr_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","‘Maaniawag depetmakajas, nuwa inak aidau achigbaun, suntag aidau maki makichik, atsa nuniachkush jimagnakesh akantunikag yajumainak megkaejatai. Tuja Sísaranun jáanch pegkeg agatkamu aidaun: makichik jáanchin, tuja nuigtu jimag jáanch agatka apijamu aents depetmakun kuntujen anugtai aidaun aatus yajumainakus batsatatai’, tuidau. ");
INSERT INTO agr_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","“Tuke Pujuuwah, amina shiwaajum aina duka ame ashí ijinata. ¡Untsu amina anempaina duka etsa tajiag etsantama iman atinme!” aatus tusa Débora Baracjai kantama inagnakui. Nuna maaniau aina duwi nagkamas cuarenta mijan maanitsuk batsamsau ainawai. ");
INSERT INTO agr_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Tuja Israel aents aidauk Tuke Pujuun intimjukiag ataktushkam pegkegchaun takajaku ainawai. Nuniagtai nii madiágnumia aents aidau siete mijanai waitkastinme tusa idaisauwai. ");
INSERT INTO agr_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Imatika waitkainamu asag ishamainak mujá waa aidaunum uumak kakajus wainmainchau batsamajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Nunik batsatai Madián aents aidau, Amalec aents aidau, nuigtu aents etsa minitaiya nuni batsamin aidau aatus Israel aents aidau ajajin utsantuawag kasajuidau. ");
INSERT INTO agr_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Nunikag nuwi Israel aents aidau nugken aakmajag batsamas, ajak ajakmamu aidaunak Israel aents aidau yumainnak makichkish ukugtsuk ashí ijituinak, nuigtushkam uwigji aidaun, buey aidaun, burro aidaun aatus ashí yajutuidau. Dutikainak Israel aents aidau yumainnak makichkish ukujainachu. ");
INSERT INTO agr_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Nunú shiwag aidauk, ditá aakjin tagkuji aidaujai yajuakag, Israel aents aidau nugken utsanawag piyakag nunú nugkanum ayaunak ashí tsaikag ijituinau. Imaaninak camellojijai shiig kuashat manchi ajaka amuktatus miniyama imanik minituidau. ");
INSERT INTO agr_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","Imatika waitkamu asag ditá yumainji atsujam shiig senchi waituidau. Imanik waituinak Tuke Pujuun segau ainawai yaijatkata tusag. ");
INSERT INTO agr_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Nuna Tuke Pujuu antujuk, ");
INSERT INTO agr_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","makichik profetan awetiuwai. Dutikamu nunú ditan chichajak: “Tuke Pujuu Apajuí Israel aents aidau emematin aina nunú juna aatus tawai: Atumi muunjum aidau Egipto nugkanum inaku waitkatai batsatun wi jiijabiajai. ");
INSERT INTO agr_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Tuja Egipto nugkanum batsatutigmin agkanmitkauwaitjim nunakek dutikachuitjime, tikich aents aidau waitkagmaidaunashkam atumesh wainjuminig jiija utsagkan dita nugke aidaun atumin amasbaijime. ");
INSERT INTO agr_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Nuadui atumi chichagkun: ‘Witjai Tuke Pujuu Apajuí atum emematin ainajum duka. Nuniau asamtai, amorreo aents aina nuna ememattai aidau dakumka najanamu aina duka ishamkaigpajum’, tiuwaitjime. Tujash atumek minak umigtukchaugme tawai Apajuí”, tusa profeta tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Nuna tiu ai Apajuí ángel tumain yaakat Ofránum taa numi encina wajaunum nuna wajautin ekemsauwai. Nunú numik Joás Abiezer wegantu aajakua nudau aajakui. Tuja nunú tsawantinig Gedeón Joása uchiji Madián aents aidau waitkainum tusa, uumak vino najanatasa uva najatainum pujus trigon awatug akaak pujau. ");
INSERT INTO agr_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Nuna pujujun Apajuí ángeltsukaita tumain wantintuk chichajak: “¡Aents wajiu senchigtinuh, Apajuí amejaig pujawai!” tau. ");
INSERT INTO agr_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Tusa tama Gedeón ayaak: “Tsagkugtugta Apujuh, tujash Apajuí jutijai pujaish, ¿wagka imanikaish waituinaji? Iina muunji aidau ujapainak, Apajuí wainchatai ishamain aidaun iwainag Egipto nugkanum batsatutin jiipajui tusa tujamin agma dusha ¿wajukauwaita? Apajuí iinak idaitamsau asamtai, madiágnumia aents aidau waitkagmainawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Tusa tutai Tuke Pujuu niina pempeentuki chichajak: “Israel aents aidaun Madián aents waitkaina duka ame ayamjuktatme. Wi aminak awemajame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Tusa tamashkam ataktu Gedeón ayaak: “Chah Apujuh, wait aneasam tsagkugtugta. Wisha Israel aents aidaunash ¿wajuk ayamjuktajaki? Mina patag wegantu aina duka Manasés wegantu aidaujai apatkamak wainkauch kakakchau ainawai. Tuja mina yatsug aina nujai ijumjamash wika shiig wainkauchitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Tusa tutai Tuke Pujuu ayaak: “Wi amejai pujau asamtai, duka dutikattame. Nuadui Madián aents aidauk makichik aents depetmaina numamtuk depetkam ijinattame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Tusa tama Gedeón chichaak: “Dekaskenum minash Apajuíya ame aujtakmek wainchatai iwaintugkata, nuna wainkan dekas Apajuíyap tujutua titagme. ");
INSERT INTO agr_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Tuja wait aneasam wepa, juwi pujumata nuniamin amina ajamsatnun utitjai”, tiuwai. Tusa tama nii ayaak: “Ayu juwi dakastajame, nuniai weme taata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Timatai ukuak, niina jeen weuwai. Nunik makichik chivo tsakatan maa inagkauwai. Nuigtu veinte kilo harinan juki pagkan levadurajai pachimtsuk inajuauwai. Dutika neje inajuamun chagkinnum egkea nuna yumijin ollanum yajaa juki numi encina tutai wajamunum ejentauwai. ");
INSERT INTO agr_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Dutikamtai: “Anú neje inajuamua nunú pagjai kayanum patagta. Dutikam nuna yumijiyai ukatkata”, tusa nunú ángel tiuwai. Tusa tima imatiksag umikmatai, ");
INSERT INTO agr_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","neje pagjai patagbaun ushujutai takakbauwai nuna titijin nunú ángel antigkui. Dutikam nunú kayanmaya jii kegak nuna apea emegkakui. Nuna dutika Gedeógkan iwaintuk ayatak megkaekauwai. Nunikmatai ataktu awagkig Gedeógkak wainkachui. ");
INSERT INTO agr_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Nunik megkaekamtai anentaimas, dekas Tuke Pujuu ángeljai betek wantinkaujaimpap chichasja tiuwai. Nunik chichaak: “¡Chah, Tuke Pujuuwah, amina ángeljai betek paan wainkajam duwish jakashtajash!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Tutai Tuke Pujuu ayaak: “¡Ishamkaipa, jakashtatme! Wi aminak agkan pujutan amastasan tajuagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Tusa tima Gedeón Tuke Pujuu emematak nuwi kaya ekenag najanauwai. Dutika nuna “Apajuí agkan pujutan sukagtin” tuu adaikauwai. Duka yamaikish Abiezeran patayi aidaun batsamtai yaakat Ofrá tutaya nuwi awai. ");
INSERT INTO agr_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Tuja nunú kashia duwik Tuke Pujuu Gedeógkan chichajak: “Amina apa toroji jimaja nuwiya makichik siete mijan ajamu jukita. Dutikam amina apa ememattai Baal dakumka najanamu awa nunú tsaigkata. Dutikakum nuna yantamen wainka apajuímtai Asherá dakumka najanamu numi waja dushakam tsaigkata. ");
INSERT INTO agr_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Nunú dutikam Tuke Pujuu amina Apajuíjum emematku kuntin maa patai apetai kaya aidau ekenjam yakí jiikam najanata. Dutika umikam toro maam nuna neje nuwi patai ashí apeakum emematjita. Tuja nunú apeakmek numi Asherá dakumka najanamu tsaiktatam nujai apeattame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Tusa tima Gedeón niina inake aidaun diez yajuak, Tuke Pujuu dutikata tibaunak imatiksag ashí umikui. Tujash nunak tsawai dutikachui, kashi dutikauwai, wagki niina apaji patayi aidaun, tikich aents nunú yaaktanum batsamin aidaunashkam ishamau asa. ");
INSERT INTO agr_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Nuna dutikau ai tsawak nunú yaaktanmaya aents aidau nantajag diikma, Baal dakumka najanamu numi Asherá dakumka najanamujai mai tsaikbaun wainkajui. Tuja nuigtushkam yamajam altar kaya ekenja najanamunum kuntin maa ashí apeamun wainkajui. ");
INSERT INTO agr_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Nuna wainkag pempeentunikiag iniininak: ¿Yaki junash jutikame? tusag, nuna ejetatus kuashta egakag, inimtanashkam imanisag inim yujakma, Gedeón Joása uchiji dutikau tabaun dekawajui. Nunik Joásan jegajuawag chichajuinak: ");
INSERT INTO agr_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","“¡Amina uchijum jiikta, maami! ¡Wagki Baal dakumka najanamuwe nuna, tuja tikich nuna yantamen numi Asherá dakumka najanamu wajama nujai nii tsaike!” tuidau. ");
INSERT INTO agr_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Tusa tiagtai Joás ditan ayaak: “¡Atumek Baal ayamjakjumek maanimaitsugme! ¡Tuja Baala ayamjauk eke tsawatsaig mantamnati! Tuu yujatsuk idaisatajum. Baal dekas Apajuíyaitkug, niina niime dakumka najanamua duka niinu asamtai nigki ayamjumakti”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Aatus Gedeón Baal dakumka najanamu ememattai wajattaman tsaiku asamtai, Israel aents aidau niina daajin yapagtuawag Jerubaal adaikau ainawai, wagki Joás chichaak: Baalak nigki ayamjumakti tiu asamtai. ");
INSERT INTO agr_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Nunú nagkaemakiu ai Madián aents aidau, Amalec aents aidau, nuigtu aents etsa minitaiya nuni batsamin aidaujai ijunag namak Jordágka amain katiajajui. Nunikag nuwi Jezreela nugke ségaju weajunum aakmajag batsamsajui. ");
INSERT INTO agr_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Tujash Gedeógkak Apajuí Wakani egkemtujam Abiezera patayi aidau wijai ijunjatnume tusa uwig aishmagku kachujin umpuajui. ");
INSERT INTO agr_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Tuja nuigtushkam Manasés wegantu aidau ujaktajum ijunag atujatkatnume tusa, chichama etsejin aidaun ishiakui. Nuigtushkam Asher wegantu aidau, Sabulón wegantu aidau, Neftalí wegantu aidau ujaktajum tusa ishiakui. Dutikamu nunú ujakajam ditashkam Gedeógjai atuniktatus shiyakajui. ");
INSERT INTO agr_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Nunik ijunjamtai Gedeón Apajuín chichajak: “Israel aents aidau ayamjukta tusa tujutmaum nuna umikti tusa yainkatnaitkumek, ");
INSERT INTO agr_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","uwija duwape uje wajasun trigo akatainum aipkittag nunú kashikmas nugkak buku aig nunú duwap chupijun wainkatjai. Nuna wainkan dekaattajai dekas ame Israel aents aidaun ayamjukti tujutbaunak. Nunikan dekaskeap Apajuí yainkattawa titatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Nunú tibauk imanisag uminkauwai. Nuadui Gedeón kashikmas duwapen diikma chupig aun wainak juki ijuja makichik pinignum yumin aimkauwai. ");
INSERT INTO agr_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Nuna wainkau ayatak ataktushkam Gedeón Apajuín chichajak: “Wait aneasam wi ataktu iniimkuish kajegtukaipa. Yamaik ima junak segajame. Ataktush tikich iwainakta. Yamai duwap chupitna juju buku wetai nugka chupigti”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Gedeón tusa tibaunak nunú kashi aajakua duwi Apajuí betek dutikauwai. Nuadui kashinia duwi diyam duwapek buku aig nugka chupika asauwai. ");
INSERT INTO agr_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Gedeón tikich daajin Israel aents aidau Jerubaal adaikau aina nunú kashikmas nantakmatai, suntag niijai yujau aidaushkam ashí nantajajui. Nunikag shima shimakua yumi pukuni jiinu Harot tutainum jegawajui. Nunikag nuwi aakmajag batsamsajui. Nuwi pujusmak Madián aents aidauk nujinum muja Moré tutai najatamunum batsamajakui. ");
INSERT INTO agr_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Tuja Tuke Pujuu Gedeógkan chichajak: “Aents kuashat yajuaka wegam duwi dita Madián aents aidaun depetkajag, Apajuí yaimpasmatai depetmakji tutsuk, kuashat ainag duwi depetmakji tumain ainawai. ");
INSERT INTO agr_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Nuadui aents aidau ishamkagtuidauk jemin waketjatajum tita”, tiuwai. Tusa tima Gedeón aents aidaun: ¡Ya ishamkagtawa duka dita jeen waketjati! tusa iniasui. Tusa iniam veintidos mil aents waketjajui. Nunikagmatai diez mil aents juwakajui. ");
INSERT INTO agr_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Nunikmataishkam Tuke Pujuu ataktu Gedeógkan chichajak: “Anú juwakaja dushakam shiig kuashtai. Nuniau asamtai namaka yajuaka emata, dutikawamin wi awi dekapsattajai. Dutika dekapsan duwi ujaktagme, wajupak amejaish shiyaktinme nuna”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Tusa tima Gedeón aents aidaun yajuak namaka yumin uwagtinme tusa ejegauwai. Dutikamtai Tuke Pujuu chichajak: “Tikishmatug tekemtuawag yumi umuinai, tikich aidau uwejen shikikag yawá umau wajagtata nunú etegjata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Tuja uwejen yumi shikikag yawajai betek umuidauk trescientos aents aajakui. Tuja tikich aidauk tikishmatug tekemtuawag uwajaju ainawai. ");
INSERT INTO agr_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Nunikagmatai Tuke Pujuu Gedeógkan chichajak: “Juju trescientos aents aina jujaig Madián aents aidaunak ijinattajai atumi ayamjakun. Untsu tikich aina duka ashí waketjatnume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Tusa timatai Gedeón tikich aidaunak waketjatajum tusa awakjauwai. Untsu eke waketuinatsaig dita uwagtin yajaka jukimu aidaun kachu aidaujai ashí atanjauwai. Nunú waketjamtai ayatak trescientos aents etegjamu aidaujaig Madián aents aidau tsumunum batsatai nuna nujiin jegajuawajui. ");
INSERT INTO agr_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Nunikagmatai nunú kashia duwi Tuke Pujuu Gedeógkan chichajak: “Nantakim jetekta, wi ame depetkati tusan idaitustatjame. ");
INSERT INTO agr_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Untsu jetet ishamakmek, amina inakem Purájai atuekam shiwag batsata nunú anutukta. ");
INSERT INTO agr_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","Nuwi jeganta pujusam wajintuk chichakajat nunú antukta. Nunú antukam ichichmamjam jetektatme”, tiuwai. Tusa tima niina inake Purájai weuwai. Nunik jegauwai nunú shiwag aakmag batsatbaunum. ");
INSERT INTO agr_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Tuja Madián aents aidaushkam Amalec aents aidaujai, nuigtu tikich aents etsa minitaiya nuni batsamin aidaujai aatus ijunag nugka dita batsatbaun pampantuk, manchi ajaka ijinatatus wajukmaina imanidau. Tuja dita camellojishkam shiig kuashat nayantsa kamatkajijai betek aajakui. ");
INSERT INTO agr_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Tuja Gedeógkak Purájai nunú shiwag batsatbaunum anumak pujus antukui makichik suntag kumpajin nii kajamjamujin pachis ujaak: “Kajanmash makichik pag sebada najanamu kagkegak, ii batsatag juwi taak makichik aakan tukume. Dutikak aaknak tegaka ajuime”, tau. ");
INSERT INTO agr_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Tusa ujaam, niina kumpaji ayaak: “Auk duka tikichkesh aan kajamjachume. Duka Joása uchiji Gedeón suntag Israel aents aidaun apujiya nunú aan kajamjaume. Apajuí senchijin Gedeón iina depetamkatta nunú aan kajamjaume”, tau. ");
INSERT INTO agr_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Nunú dekas uminkatnun niina kumpaji ujaun Gedeón antuk Tuke Pujuun emematiuwai. Nunik wakitkiuwai dita batsatbaunum. Nuwi jegaa Israel aents aidaun chichajak: “¡Umintsatajum maaniawagmi, Madián aents aidaunak depetuk amuktinme tusa Tuke Pujuu iina idaitugmastatui!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Nuna tusa trescientos aents aina nuwiyan kampatuma imajin betek akanag ijumjauwai. Dutika uwija kachuji aidaun tinamak, nuigtushkam yumi aimtainum nuwi ekematain yajaka ekemag tinamkauwai. ");
INSERT INTO agr_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","Dutika chichajak: “Mina diigkau atajum, wi shiwag batsata nuna yantamen jegakun wajukattaja nuniakuig atumshakam betek nuniktajum. ");
INSERT INTO agr_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Tuja wi mina uyuntuina nujai kachu umpuakuig, atumshakam dutiksagmek shiwag batsata nunú tenteajum umpuagtajum. Dutika umpuakjum senchi untsumkajum: ‘¡Tuke Pujuu daajin, Gedeógka daajin!’ titajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Nuna tusa Gedeógkak cien aentsun yajuak, shiwag aidau jinta niimainak batsatu, kashi aehaet tikich aidaujai yapajinatatus uminainai jegantauwai. Nunik jegantun kachun umpuinak, cántaro yumi yajaa jutai takakbau aidaun tsaikajui. ");
INSERT INTO agr_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Dita umpuiniagtai tikich akanka ishiakbau aidaushkam betek umpuajajui. Nuninak yumi aimtai takakbaunashkam dutiksag tsaikajui. Jii ekemakbaunak menajin takusag, tuja kachunak untsujin takus ijunas untsumainak: “¡Tuke Pujuu daajin, Gedeógka daajin! ¡Jetektajum!” wajaidau. ");
INSERT INTO agr_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Tuja Israel aents aidauk Madián aents aidau batsatun tenteawag jasa batsatu. Nunik batsataig senchi untsumaidaun antukag ishamak, eke jeteachmaitak sapigmakag pisainak pampaidau. ");
INSERT INTO agr_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Tuja trescientos Israel aents aidauk kachun umpú batsataig, Madián aents aidauk ditak pempeentunikiag maaniatnume, nuninak pisajag yaakat Sererá wetaiya nuni shiyakag yaakat Bet-sitá jegatnume. Nuninai tikich aidauk yaakat Abel-meholá yaakat Tabatnum ijus awa imanui jegatnume, tiuwai Tuke Pujuu. ");
INSERT INTO agr_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Timau asag pisajagmatai, Neftalí wegantu aidaun, Asher wegantu aidaun, Manasés wegantu aidaun aatus Gedeón ashí untsukui, Madián aents aidau pisaja nuna pataetuktinme tusa. ");
INSERT INTO agr_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Nuna tusa Efraígka nugke muja ikam weajunum batsamin aina nunú ujaktajum tusa chichama etsejin aidaun Gedeón ishimak: “Kaunawag Madián aents aidaujai maaniatnume. Nunikag Madián aents aidau eke nugka agkannum yujasag namak Jordágkan katitkag yaakat Bet-bará tutaya nuwi jegainatsaig, nunú nugkan dita batsamtuk akijuatnume”, tusa akatmamjauwai. Tusa tiajam Efraín wegantu aidaushkam Gedeón tibaunak imatiksag umikajui. ");
INSERT INTO agr_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Dutikainak nuigtushkam Madián aents aidaun apuji Oreb, Zeeb aatus achikajui. Dutikawag Orebnak yamai kaya Oreb tutai awa nuwi maawajui. Untsu Zeeb aajakua nunak vino najanatasa uva chimpia najatai aajakua nunú yamai Zeeb tutaya nuwi maawajui. Nuadui nunú uva chimpia najatai aajakua duka niina daajin namkauwai. Aatus Madián aents aidaun ai aintuinakua Jordágka amain Gedeón pujaunum waketuinak, Orepa buuken Zeepa buukejai tsupijuk jujukiajui. ");
INSERT INTO agr_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","Gedeón Madián aents aidaujai maaniatatus, tikich Israel aents aidaunak chichama akuptuk ujayatak, Efraín wegantu aidaunak ujakchauwai. Dutikayatak imapam ujakui shiwajan pataetuktinme tusa. Nuadui kajekag Gedeógjai jiyaniku ainawai. ");
INSERT INTO agr_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","Tusa tiagtai Gedeón ditan ayaak: “¿Atum dekas mina nagkaetasu dutikaujum duka dekatsjumek? Atum aidautijum ujumak dutikaujum duka ii aidauti kuashat dutikamua nuna nagkaesauwai. ");
INSERT INTO agr_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","Apajuí atumnak Madián aents aidaun apuji aidau Orepan, Zeebjai achiktinme tujabiu asamtai achikugme. Tuja wika atum dutikaujum imannakesh dutikachjai”, tiuwai Gedeón. Aatus timatai nuna Efraín wegantu aidau antukag kajekbaujin tsagkujajui. ");
INSERT INTO agr_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","Nunikagmatai Gedeógkak niina suntaji trescientos aidaujai shiwajan aintuinak pimpikiaju ainayatak, namak Jordágnum jegawag atú amain katiaju ainawai. ");
INSERT INTO agr_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","Nunikag yaakat Sucot tutainum jegawag, Gedeón nuwiya aents aidaun chichajak: “Wait aneasjum aents wijai yuja nunú yutai ajamjuttsatajum, ditak pimpiki yawekag mininawai. Iik Madiágnumia apu aidau Zébah Salmunájai achiktasa ainku yujaji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","Tutai Sucotnumia apu aidau chichajuinak: “Amina aentsjum aina duka yujumkak ajamsashtatji, wagki eke Zébah Salmunájaig achikchaugme”, tuidau. ");
INSERT INTO agr_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","Tusa tiagtai Gedeón ditan ayaak: “¡Apajuí yaintsamtai Zébah Salmunájai achika waketkun, numi jagkigtin aidaun zarza aidaujai uwegshunum ayá nuna yajuakan atumnak asutkattajime!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","Aatus tusa nuwiya juwakiag jegawajui yaakat Penuelnum. Nunikag nuwishkam yaakat Sucotnum sumakbaunak dutiksag yutain sumakui. Tujash Penuelnumia aidaushkam Sucotnumiajai betek tiajui. ");
INSERT INTO agr_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","Nuadui Gedeón ditan chichajak: “¡Juju yaaktanum kumpin jiikbau waja junak wi depetmaka waketkun ajaka ajuattajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","Zébah Salmunájai yaakat Carcornum atú amain etsa minitaiya nuni quince mil suntag aidaujai batsatu, wagki ciento veinte mil suntag maaniamunum jinawaju asamtai. ");
INSERT INTO agr_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","Nunik batsatai Gedeógkak niina suntaji aidaujai jinta uwegshunmanini wegaunum yaakat Nóvah nuigtu Jogbehá aatus aajakua nuna yantamen etsa akaetaiya nuni shimutkauwai. Nunik jegajuawag anenjas batsatun jetekajui. ");
INSERT INTO agr_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","Dutika jeteam Zébah Salmunájai jiinki tupikakiajui. Nunikmatai Gedeón pataetuk amayag mai achikui. Nuna dutikamtai shiwag aidauk shiig senchi ishamkajui. ");
INSERT INTO agr_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","Nunik Gedeón maania depetmak nugka yaijuch Heres tutai aajakua nuni wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","Nunik wenak nunú nugkanum makichik datsauch yaakat Sucotnumia pujaun achika juki kuashat iniasui. Tusa iniam Sucotnumia apu setenta y siete aajaku aina nuna daajin ashí adaitujui. ");
INSERT INTO agr_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","Tusa ujakam Gedeón nuna dekaa Sucotnum weuwai. Nunik jegaa nuwiya aents aidaun chichajak: “¿Atumesh aneakjumek Zébah Salmunájai achikchaugme tusajum dushiktibiujum dusha? Tuja ¿atumesh aneakjumek Zébah Salmunájai achikchaugme tusajum mina aentsug aidau yaweja pimpiki minidau dekayaitkujum yutai ajamsachbaijum dusha? ¡Pai yamaik achikan juwi itaajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","Nuna tusa Gedeón apu Sucotnumia aidaun suwimka suwak jagki aidau, zarza aidaujai uwegshunmaya yajuakbauwai asutkauwai. ");
INSERT INTO agr_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","Tuja nuigtushkam kumpin jiikbau yaakat Penuelnum wajattaman ajak ajuauwai. Nuwiya aents aidaunashkam kajegkui. ");
INSERT INTO agr_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","Dutika Zéban Salmunájai iniak: “¿Atum muja Tabornumia aents aidau amukuitjum dusha wajuku aajabi?” tau. Tusa tama dita aimainak: “Amejai betek agmayi. Maki makichik aents aidauk apu tumain agmayi”, tuidau. ");
INSERT INTO agr_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","Tusa tiagtai Gedeón senchi untsumak: “¡Mina yatsug emkau aidau! ¡Dekas mina yatsug emkau aidau kajegkuitjume! Nuadui Tuke Pujuu daajin tajime, atum dita maachuitkugminig, wisha atumnak yamaik maubaitsujime”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","Nuna tusa inagnamuik niina uchiji emkau Jéter aajakua nuna ame maata tusa inajui. Tujash Jéterak eke tsakatuch asa ishamak maumainchau dekapjauwai. ");
INSERT INTO agr_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","Nunitai Zébah Salmunájai Gedeógkan chichajak: “¡Amek dekas mai mantuata! ¡Aentsuk niina wajiujin dekatia!” tuidau. Tiagtai Gedeón jegantun mauwai. Dutika Zébah camelloji Salmuná camellojijai kuntujen waji pegkeg apeekamu aidaun yajutkauwai. ");
INSERT INTO agr_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","Dutikamtai Israel aents aidau Gedeógkan chichajuinak: “Madián aents aidau waitkagmaidau ame ayamkagtukam agkanmitkagtuau asam ame, tuja ame wegantu aidaujai iina apuji atajum”, tiajui. ");
INSERT INTO agr_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Tusa tama Gedeón ditan ayaak: “Wika atumi apujig achattajai. Tuja mina uchigkesh atumi apujig achattawai. Atumin apujig Tuke Pujuu atatui. ");
INSERT INTO agr_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","“Untsu atum shiwag aidau maakjum ditá patakumtaiji aidau yajutkaujum nuna segajime mina sujustinme tusan”, tiuwai. Tuja nunú suntag aidauk uwegshunum batsamin asag patakumtai oro najanamun tuke patakumajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","Tusa timatai Israel aents aidauk jáanchin nugká ainak nuwi patakumtai yajuakbaun batsasajui. Dutikawag Gedeógkan chichajuinak: “Pai, juju jukita”, tiajui. ");
INSERT INTO agr_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","Nunú patakumtai oro najanamu aidauk diecinueve kilo tumain aajakui. Untsu apu aidaun iwagmamtaiji, nugkutaiji nuigtu jáanch yamakaitkau aidau aatus duka dekapachbau aajakui. Tuja camello anujamu aidaushkam dekapachbau aajakui. ");
INSERT INTO agr_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","Nunú oro yajuakbauwai Gedeón sacerdote nugkutain dakumak najanauwai. Dutika niina yaaktajin Ofrá ejegauwai. Nuna Israel aents aidau ashí emematuinak Tuke Pujuu ememattan idaisau ainawai. Tuja Gedeógkak pegkegnap dutikaja tukama, nuna niina patayi aidaushkam emematuidau asamtai, niinishkam pegkegchau aajakui. ");
INSERT INTO agr_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","Dutika depetkamu asag Madián aents aidauk Israel aents aidaunum yunumag batsamajaku ainawai. Nuadui yaunchuk aajakbaunak betekchau tiki wainkauch juwakajui. Tuja Gedeón iwaku pujusmataig, nunú nugkanmak cuarenta mijan maanitsuk batsamsau ainawai. ");
INSERT INTO agr_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","30","Gedeón Jerubaal tuuta awagmatai aajakua duka niina jeen wakitki pujusui. Nuwi pujus setenta uchin akigkui, tuja niina nuweshkam kuashat aajakui. ");
INSERT INTO agr_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","Tuja niina ikaa nuwe Siquem pujujakua dushakam makichik uchin uchigmakui. Dutikamtai Gedeón nunú uchi daajin Abimelec adaikauwai. ");
INSERT INTO agr_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","Gedeógkak shiig muumpaki jakauwai. Nunik jakamtai, niina apaji Joása ukumataiji Abiesel wegantu aidau batsamtai yaakat Ofrá aajakua nuwi ukusajui. ");
INSERT INTO agr_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","Gedeón jakamtai batsamas Israel aents aidauk Baal dakumka najanamu aidaun emematuinak Apajuí ememattanak ataktu idaisajui. Tuja dita apajuímawagtinnak Baal-berit aajakua nuna etegkawag nuna emematujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","Nunidau asag ditan shiwag waitkagtai Tuke Pujuu Apajuí ayamjukua nunak kajimatki idaisajui. ");
INSERT INTO agr_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","Gedeón tikich daaji Jerubaal aajakua nunú ditan ayamjak kuashat takasu aig, niina patayi aidaunash wait anenjachu ainawai. ");
INSERT INTO agr_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","Jerubaalan uchiji Abimelec niina dukuji wegantu aidau Siquemnum batsatu asamtai, ditajai chichastatus weuwai. Nunik jegaa ditan chichajak: ");
INSERT INTO agr_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","“Iik pataa ainaji, nuadui tajime. Jerubaala uchiji setenta aina duka ashí apu amain ainatsui, ima makichik apu amainai tajai. Nuniau asamtai juwi tikich aents aidau batsata nujai nunú pachisjum shiig chichasjum antumtikatajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","Tusa timatai Abimelekan patayi asag, niina atuinak, Siquemnumia aidaujai chichastatus shiyakajui. ");
INSERT INTO agr_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","Nuigtushkam apajuímtai Baal-berit dakumka najanamu jegamjukbaunum kuichik plata najanamu atatman setenta jukiajui. Dutika Abimelekan susajui. Dutikam nuna akikmak, Abimelec aents magkagtin aidaun yajuakui. Dutika nunú aents aidaujai, ");
INSERT INTO agr_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","yaakat Ofrá niina apaji Jerubaal pujujakbaunum weuwai. Nunik wegak niina yachi setenta aajaku aina nuna makichik kaya múun pujaunum nuwi ashí kajegkui. Untsu niina yachi Jotam awan aajakua nunú uumkau asa, ima nigki uwemjauwai. ");
INSERT INTO agr_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","Dutika niina yachi aidaun ashí amukmatai, Siquemnumia aents aidau, nuna yantamen Bet-miló aajakua nuwi batsamin aidaujai Siquemnum numi encina tutai wajaunum kaya pegkejam tutai pujaunum nuwi ijunjajui. Nunikag nuwi Abimelekan apu adaikajui. ");
INSERT INTO agr_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","Abimelec apu wajase tabaun Jotam dekaa, muja Guerizim tutainum wakauwai. Nunik nuwi wajas Siquemnumia atuktinme tusa senchi untsumak chichaak: “¡Siquemnumia aidauwah, wi titatag nunú shiig antuktajum! ¡Atumnash Apajuí antugtamkachajaintash! ");
INSERT INTO agr_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","“Makichik tsawantai numi aidau apugtin amí tusag wakekajui. Nuadui olivon chichajuinak: ‘¡Ame iina apuji ata!’ tiajui. ");
INSERT INTO agr_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","Tusa tama: ‘Wika tikich numi aidaun apuji atag takunuk, aents aidau Apajuín emematuinak mina aceitejun juki takau aina nuna, tuja ditanu atinnashkam mina aceitignak juki takau aina nuna idaikun apu amainaitjai’, tusa dakitjauwai. ");
INSERT INTO agr_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","“Tusa timatai higueran chichajuinak: ‘¡Untsu ame iina apuji ata!’ tusag segajui. ");
INSERT INTO agr_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","Tusa tama higuera chichaak: ‘Wika numi aina nuna apuji atag takunuk, mina yujagkeg higo shiig pegkeg yumimitun nejenaitag nuna idaikun apu amainaitjai’, tusa dakitjauwai. ");
INSERT INTO agr_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","“Tusa timatai numi aidau uva numijin chichajuinak: ‘¡Untsu ame iina apuji ata!’ tusag segajui. ");
INSERT INTO agr_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","Tusa tama uva numiji chichaak: ‘Wika numi aina nuna apuji atag takunuk, Apajuín emematuinak tuja dita aidaushkam minaiya vino najanamun umuinak shiig aneen aina nuna idaikun apu amainaitjai’, tusa dakitjauwai. ");
INSERT INTO agr_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","“Tusa timatai inagnamua nuna numi jagkigtinun chichajuinak: ‘¡Untsu ame iina apuji ata!’ tusa segaidau. ");
INSERT INTO agr_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","Tusa tama jagki chichaak: ‘Dekaskenum atumi apuji ati tusajum wakegakjumek, wi dukuka ijiam nuna wakentin batsamsatajum. Untsu atum dakitakjuminig, minaiya jii keeka muja Líbano tutainum setug múun ayá nuna apea ijinattawai’ tiuwai jagki”, tiuwai Jotam. ");
INSERT INTO agr_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","Nuna tusa inagnak: “Tuja yamai wi atumin tajime: ¿Atum Abimelec apu adaikabiujum dusha pegkejak dutikaujum? ¿Tuja mina apag Jerubaal atum aidautigmin shiig kuitamjamkau aina dutikagmek, atumesh niina patayi aidaush shiig kuitamkaujum? ");
INSERT INTO agr_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","Atumek Madián aents aidau waitkatai batsatutigmin, mina apag atumi ayamjutpak maaniak jamain wajakui. ");
INSERT INTO agr_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","Tujash atumek duka aneetsuk, mina apaju patayi aidaujai shiwagmagajum niina uchiji setenta aajakua nunú makichik kayanmak ijinaugme. Tujash ima dukek dutikachugme, nuigtush Abimelec atumi patayi asamtai, Siquema apuji ati tusajum adaikaugme. ");
INSERT INTO agr_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","Tujash yamai wi tajime: Atum aidautijum mina apag Jerubaal aajakua nunú niina patayi aidaujai pegkeg anentaiyai kuitamkau ainakjumek, Abimelecjai shiig aneasjum pujustajum. Nuniagmin niishkam atumin shiig anenjamsatnume. ");
INSERT INTO agr_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","Untsu atum shiig kuitamkachu ataik, Abimelecnumia jii kegak Siquemnumia aidaun Bet-milónnumia aidaujai apea ijinati. ¡Tuja nunú jimag yaakta nuwiya jii kegak Abimelekan apea maati!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","Nuna Jotam aatus tusa ukuak, tupikaki yaakat Beernum wee pujusui. Nunak nunikui wagki niina yachi Abimelekan ishamak. ");
INSERT INTO agr_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","Tuja Abimelekak Israel aents aidaun apuji wajas kampatum mijan inamjauwai. ");
INSERT INTO agr_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","24","Tuja nuadui Jotam tibaunak imanisag umigkauwai. Nuadui ashí aents aidaunum shiig pegkegchau, senchi waitiamu ati tusa Apajuí tiuwai. Nunú umintai, pempeentunikig tsainika ainawai. ");
INSERT INTO agr_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Israel aents aidauk Tuke Pujuu umigtan kajimatkiag ataktushkam pegkegchaun takaidau. Nuniagtai Tuke Pujuu ditan idaisauwai. Dutikamtai filisteo aidau cuarenta mijan waitkasu ainawai. ");
INSERT INTO agr_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Tuja nunú tsawantin makichik aents Dan wegantu Manoa daagtin yaakat Soránum pujujakui. Niina nuweg uchi uchigmachu asamtai uchijig atsujakui. ");
INSERT INTO agr_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Makichik tsawantai Apajuí ángeltsukaita tumain nayaimpinmaya nunú nuwan wantintuk chichajak: “Amek yaunchuk nagkamsam uchigmachuitme. Tujash yamai ejapjuktatme, nunikam uchi aishmag uchigmaktatme. ");
INSERT INTO agr_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Nuadui umutai vino nuniachkush tikich uwaja nampetai aidauk makichkish uwajaipa. Tuja Tuke Pujuu dakitamu aina dushakam yuwawaipa, ");
INSERT INTO agr_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","wagki uchi aishmag uchigmaktatam duka atatui Nazareo. Nunú uchi intashig awagchamu atatui, wagki nii múun wajasa filisteo aidau Israel aents aidaun waitkaina nuna ayamjuk agkanmitkattawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Tusa tima aishin ujaktatus wejiuwai. Nunik jegaa ujaak: “Apajuí ángeljai betek wi pujamunum tajutuame. Nuniakui senchi puyatkamjai, wagki Apajuí ángeljai betek asamtai. Yaitpa tusanuk wikish iniaschamjai, tuja niishkam niina daajinak tujutchame. ");
INSERT INTO agr_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Untsu uchi uchigmaktatme tusa tujutmae. Nuna tusa, yamai nagkamsamek vino uwajaipa, tuja tikich uwaja nampetai aina dukesh uwajaipa, tujutmae. Nuigtush pegkegchau aina duka yuwawaipa. Tuja ame uchi uchigmaktatam duka uchi eke akiintsaig Apajuínu etegkamu asa, wika pegkegchau aina nunak takaschatjai tumamiu asa pegkegchaunak takatsuk, jau aina numamtin uchik atatui, tujutmae”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Tusa ujakam Manoa Tuke Pujuun segaak aatus tiuwai: “Apujuh, ame aents awemaum nunú ataktu awekagtita tusan segajame, nunú taa uchi akiinkuish itugkattaji nuna ujapakti taji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Tusa segam Apajuí Manoa sumamunak betek umikui. Nuniak nuwa ajanum wekaetatman Apajuí ángeljai betek ataktu wantintukui. Tuja Manoa niijai wekaechau asamtai, ");
INSERT INTO agr_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","tupikaki weuwai ujaktatus. Nunik ujaak: “¡Aentsun wi wainkabiag nunú ataktu wantintugkae!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Tusa ujakam Manoa niina nuwejai nunú aents pujamunum weuwai. Nunik jegantun iniak: “¿Ameka tikich tsawantin mina duwagjai chichasmayum?” Tusa tama nii ayaak: “Ehe, witjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Tusa tutai Manoa chichajak: “Ame mina duwag tium nunú uminkuish ¿wajuk uchish kuitamainaitji? ¿Tuja uchish itugkattaji?” tau. ");
INSERT INTO agr_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Tusa tutai ángel tumain wantinkauwa nunú Manoan ayaak: “Wi amina nuwemin timag nunak imatiksag umikti. ");
INSERT INTO agr_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Vino najanamun uwajaigka. Tuja tikich umutai uvanmaya najanamu aidaunash uwajaigka, nuigtushkam tikich umutai kajiau aidaunashkam uwajaigka. Tuja tikich yutai aidaun Apajuí dakita nunak yuwawaigka. Wi tibaunak Imatiksag umikti”, tau. ");
INSERT INTO agr_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","16","Tusa tama, Apajuíyap ángeljai betek wantintujuk tujutua tachau asa chichajak: “Wait aneasam juwi jutijai juwakta, nunikamin chivo tsakatan maa inajuamtai yuwami”, tau. Tusa tama nunú ángeljai beteka nunú niina ayaak: “Wi juwi juwaknush amina yutaigminak amejai jimagtuknuk yumaitsujai. Untsu chivo tsakat maam nuna neje ashí apeakum Tuke Pujuu emematta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Tusa tama Manoa niina chichajak: “Untsu amina daagmesh yaita dukesh ujajatkata, nuna dekau asan ame tukagtam nunú uminkui see kuashat titagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Tutai Apajuí ángeljai betek wantinkauwa nunú niina ayaak: “¿Wagka mina daajush dekatasamesh wakegame? Mina daajuk shiig pegkeja ibau asa kakajus dekamaitsui. Nuadui uukbaujai betekai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Tusa timatai chivo tsakatan, ajak aidaun neje juukbaujai ijumag juki, kayanum patai nuna ashí apeak Tuke Pujuun emematiuwai. Nuna dutikamtai Tuke Pujuu Manoan niina nuwejai wainchatai pegkeg aidaun iwaintukui. ");
INSERT INTO agr_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","Tuja Manoa niina nuwejai chivon maa apeauwa nunú bukuitamunum Apajuí ángeljai betek nuwi pachitkau yaki waun wainkajui. Nuna wainkag tsuntsumawag nijayin nugka antig pujusajui. ");
INSERT INTO agr_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Nuna Manoa wainak anentaimjauwai, dekas Tuke Pujuuwap ángeljai betek wantinkaun wainkaja tiuwai. Duwi nagkamsag niinak tuja niina nuwenakesh ataktuk wantintukchauwai. ");
INSERT INTO agr_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Nuna wainkau asa niina nuwen chichajak: “Iik dekas Apajuí wainkau asa jakattaji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Tutai niina nuwe ayaak: “Tuke Pujuu iina mantamatag takug, ii kuntin maa nuna neje ashí apeaku, ajak juukbaujai apeag nuna dakitmain wajake. Tuja iina iwaintugmaka nunashkam iwaintugmamainchau awajtamkae. Nuigtushkam iina ujapaka nunash ujapamainchau awajtamkae”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Duwi pujus niina nuwe ejapjuk uchi aishmagkun uchigmakui. Nunikmatai adaikauwai Sansón. Nunú uchi muumpatai Tuke Pujuu pegkegnum yaijakui. ");
INSERT INTO agr_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Tuja makichik tsawantai yaakat Sorá Estaoljai niiniaku aajakua nuna ejapeen Danka nugke aajakua nuwi Sansón pujaun Apajuín Wakani egkemtujui. ");
INSERT INTO agr_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Makichik tsawantai Sansón weuwai yaakat Timnat. Nunik nuwi filisteo nuwa pujuttaman wainak wakejukui. ");
INSERT INTO agr_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Nunik niina jeen wakitki apajin dukujijai ujaak: “Yaakat Timnatnum filisteo nuwa pujaun wainkamag nujai nuwenatag tajai. Nuadui wait aneasjum nuwenatasa umitai aina nunú ashí umiktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Tusa tutai niina apaji dukujijai ayaak: “¿Wagkamek filisteo aents Apajuín umigchau aina nuninjaish nuwenatame? ¿Iina patayi aina nuwiyag nuwak atsawak? atsa nuniachkush ¿ashí Israel aents aina nuwiya nuwak makichkish atsawak?” tiuwai. Tusa tama Sansón ayaak: “Wika nuna nuwan wakegajai. Dekas nunú nuwa sumagtuktajum nujai nuwenatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","Tuja Tuke Pujuu yaunchuk emtika nuniktin ati tusa tibaunak niina apajig dukujijaig dekajakchau ainawai. Tuja nunú tsawantin Israel aents aidaun filisteo aidau waitkaidau asamtai, wajuk waintuanuk filisteo aents aidaun ijinkun Israel aents aidaun agkanmitkawag tau asa tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Nuadui Sansógkak niina apaji, dukuji aatus yaakat Timnat weuwai. Nunik wegau niina apajin dukujijai ukuak tsegkeki uvan egak weuwai. Nunik wegaun león yama tsakaju senchi kajeau jetekui. ");
INSERT INTO agr_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Dutiktai Apajuí Wakani Sansógkan egkemtujui. Dutikam leónkan achika chivo tsakatuch maumaina dutika mauwai. Nuna dutikash apajinak dukujijaig ujakchauwai. ");
INSERT INTO agr_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Tuja Timnatnum jegawag Sansógkak nii nuwa wakejukbau pujaunum weuwai. Nunik niijai chichasui. ");
INSERT INTO agr_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Nunik dukap tsawan pujusa nii nuwenatnuji tsawan jegamtai, wenak yaunchuk nii león maamujin diistatus tsegkeki weuwai. Nunik jegan diikma leónka iyashi sakajunum dapa jegamak yumijina egketun wainkauwai. ");
INSERT INTO agr_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Dutika wainak ashí juki duka dukakua weuwai. Nunik niina apaji dukujijai pujaunum jegan, ditanashkam akaantuk susauwai, dutikam ditashkam nuna dukawajui. Tujash Sansógkak león maa ukukbaunmayan jukimjai tusag ujakchauwai. ");
INSERT INTO agr_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Nunik jegawag Sansógka apajig uchiji nuwe atinun wainkatatus wejiuwai. Tuja datsauch nuwenuk nuna dutikin ati tibaun umiak Sansón nii nuwenbaunum jiistamatatus ipamauwai. ");
INSERT INTO agr_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Tujash filisteo aidauk ishamkagtuidau asag, treinta datsauchin ipauwai, Sansón nuwentai uyunainak batsamsatin aidaun. ");
INSERT INTO agr_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Nunú treinta aents aidaun Sansón chichajak: “Makichik anentaimsa aimtain iniastajime. Dutikamtai nuwenbau siete tsawan asa atata duwi ujatkatajum wajina takunua taja nunú. Nunú betek ujatkagminig maki makichik jáanch shiig pegkeg lino najanamun, nuigtu nuwenbaunum weaku nugkutai aidaujai amastajime. ");
INSERT INTO agr_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Untsu nunú betek aimkachjumek, jáanch shiig pegkeg lino najanamu, nuigtu jáanch nuwenbaunum weaku nugkutai aidaujai mina sujustatjume”, tiuwai. Tusa tama dita aimainak: “Ame waji tame nunú tita antukmi nunika aimkagmi”, tuidau. ");
INSERT INTO agr_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Tusa tiagmatai Sansón aatus tiuwai: “Yukagtinnumia yutai pegkeg jiinkiuwai, senchigtinnumia yumimitu jiinkiuwai”, tiuwai. Timatai, nunash wajina takug tawa tusa kampatum tsawan batsamtakush ejechajui. ");
INSERT INTO agr_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Tuja ejechamin dekapenak tsawan ipak usumta duwi Sansógka nuwen chichajuinak: “Iina tujabi nunash wajina takug timae nunú aishjum dekajuata. Nunikam amina ujapakmatai ujajatkata. Unstu nunú dekajuachaminig, aminak, amina apa patayi aidaujai apeattajime. ¡Wagki atumek dekas iina jáanchji aina nunú atankimi tusajum ipajatuaugme!” tiajui. ");
INSERT INTO agr_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Tusa tiagmatai Sansógjai chichastatus weuwai. Nunik jegajua buutki chichajak: “¡Amek minak anentsume! ¡Amek minak kajegtame! Nuniau asam mina pataag aina nunú anentaimsa aimtai iniasume, tujash amek minak dusha waji takumea tiume duka ujattsume”, tiuwai. Tusa tama Sansón ayaak: “Mina apagnakesh, tuja mina dukugnakesh ujatsug nunash aminash wagkanuk ujaktagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Tusa tamashkam ujatkati tusa niyai ayaumas pujus nii nuwenku jiistabau siete tsawan aajakua imanisag siete tsawan buutú pujau. Imatika waitka pujujam tsawan sieteya duwi nunash wajina takug tiyawa nuna ujakui. Tusa ujakam niina patayi aidau batsatun jegajua niishkam ujakui. ");
INSERT INTO agr_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Dutika ujakajam tsawan sieteya duwi eke etsa akaetsaig Sansógka jegajuawag chichajuinak: “Dapa yumiji yumimitun nagkaesauk tikichik atsawai. Tuja Leónka nagkaesau senchigtinuk tikichik atsawai”, tuidau. Tusa tiagmatai Sansón ditan chichajak: “Mina duwag ujapakchamtaig, atumek nunap tawa tusagmek ejemainchau ainagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Nuna taig Tuke Pujuu Wakani egkemtug Sansógkan senchimtikauwai. Dutikam weuwai yaakat Ascalón, nunik nuwi treinta filisteo aidaun mauwai. Dutika nuna jáanchji aidaun yajutuk akikmakui. Nuna dutika senchi kajeka niina apaji jeen wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Nunikmatai Sansón nuwenbaunum aents aidau pujusu aina nuwiyajai Sansógka nuwen tikich aentsnum sujutkajui. ");
INSERT INTO agr_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Tuja kuashat tsawan nagkaemakiu ai, trigo juut jegamunum Sansón niina nuwen ijagsatatus wegak chivo tsakatan juki weuwai. Nunik jegaa chichaak: “Mina kanutaijui wayan mina duwagjai chichastajai” tusa wayatag titatman niina wegaji dakitjauwai. ");
INSERT INTO agr_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Nunik chichajak: “Wika dakitakus idaisayatai tibaijai. Tau asan amina kumpagmín nuwemnak sujukmaijai. Tujash tikich mina nawantug ekeu niina nagkaesau shigmauch puja nunú nuwatkata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Tusa tama Sansón ayaak: “Yamai atum filisteo aidautigminak wi ijinattajime. Dutika ai wagka aikae tujutmainuk atsuttawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Nuna tusa ukuak niina nuwe sujutkamunum iikmaktatus, trescientos amich nuwa aidaun achika ijumjauwai. Dutika apa apatuk ujuknum jigkakui. Dutika jimag amich apatka jigkakbaunum nuna ujuken ekematain anug jigkakui. ");
INSERT INTO agr_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","Dutika nuna ekemak amichan atia filisteo aidau ajaji aidaunum ishiakui. Nunú shimak trigo juuka ijumjamu aidaun eke juukchamu aidaujai ashí apekui. Dutikak nuigtushkam uva ajakbaun, olivo ajakbaujai ashí apeka ijinauwai. ");
INSERT INTO agr_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Dutika ijituam filisteo aidauk: ¿Yaki aikae? tusa inimainak yujakma: Auk Sansógka wegaji niina nuwen atanki, niina kumpajinig sujutkam, nuna iikmak aikae tabaun dekawajui. Nunik dekawag nuna shimutuk nunú nuwanak apajijai apeawag maawajui. ");
INSERT INTO agr_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Dutikawagmatai Sansón chichaak: “Atum aniau asagmin, nuna iikmakun makichkish idaitsuk ashí amuktatjime. ¡Nunak dekas wi umiktinjun tajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Tusa senchi kajeku asa filisteo aidaun jeteka shiig kuashat ijinauwai. Dutika ukuak Etamnum kaya múun waa au asamtai, nuwi uumak pujustatus weuwai. ");
INSERT INTO agr_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Nunik weu ai filisteo aidaushkam Sansógkan egainak Judá nugken shiyakajui. Nunikag jegawag nuwi nagkamas batsamak nugka Lehi tutaiya imanui jegantajui. ");
INSERT INTO agr_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Imanikagmatai Judá wegantu aidau ditan iniinak: “¿Wagka jutijai maaniatasagmesh atumesh kaunaugme?” tuidau. Tusa tama dita aimainak: “Sansón iina pegkegchau awagtamkau asamtai, achika juki iishkam dutiksaik iikami tusa yujaji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Tusa tiagmatai nuna antukag, tres mil aents Judá wegantu aidau Etamnum kaya múun waa aunum nuwi Sansón pujau asamtai shimutkauwai. Nunik jegawag nuwi pujuttaman wainkag chichajuinak: “¿Amek dekatsmek filisteo aents aidau iina nagkaetamsau senchigtin aina duka? ¿Wagka jutikamesh utugchatash itagkagtuaume?” tuidau. Tusa tama Sansón ditan ayaak: “Wika dita pegkegchau takasbaujin dutiksanuk iikamjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Tusa timatai dita chichajuinak: “Iik ame achika juki filisteo aidaunum sujukmi tusa kaunaji”, tuidau. Tusa tama Sansón ayaak: “Atum mantuashtinaitkugmek, dekas mashtatjame tusa tujuttajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Tusa tutai dita ainak: “Atsa, ii aidautik mashtatjame, ayatak achika juki filisteo aidau susami tusa taji”, tuidau. Aatus tusag jimag soga yamagmai jigkajajui. Dutikawag uumak pujaun jiikiag jukiajui. ");
INSERT INTO agr_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Dutikawag we wenakua Lehin nugkanum jegawajui. Nunikagmatai filisteo aidauk shiig aneenak untsumkiag jiintujajui. Dutikiagtai Apajuí Wakani Sansógkan senchimtikauwai. Dutikam sogayai niina kuntujin, uwejen jigkagbaunak hilo lino najanamu apeamu tsujinmaina numamtuk tsujiajui. ");
INSERT INTO agr_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Dutika nuadui burro jagke eke shiig sakamchau atatman juki, duwi awatug mil filisteo aidaun kajegkui. ");
INSERT INTO agr_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Dutika chichaak: “Makichik burro jagkenig mil aentsun kajegkan ijumsawa emakjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Nuna tusa burro jagke takakbaun nagkima ajapauwai. Nuadui nunú nugka daajig Ramat-lehi adaikamui. ");
INSERT INTO agr_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Tuja Sansón senchi kitaag Tuke Pujuun segaak: “¡Ame minak shiwag shiig kuashat aina nuna depetkati tusam yainkaume! Nuadui ¡yumi umumain atsutai juju aents amina umigtamchau batsata nuwi kitakai jakati, nunikmatai niina iyashin dushikjatnume tusamek idaitumaitsume!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Tusa timatai Apajuí yumi initkanmayan jiikiuwai. Dutikamtai Sansón nuna uwajui. Nuna uwag ataktu wajiu wajasui. Nuadui nunú yumi pukuni jiinkiuwa nuna daajin adaikauwai En-acore. Duka yamaikish nugka Lehin tutainum awai. ");
INSERT INTO agr_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Sansógkak veinte mijan Israel aents aidaun yaigkui. Nunak filisteo aidau nunú tsawantin Israel aents aidaun ashí depetuk waitkajaku aina nunú tsawantin niig takasui. ");
INSERT INTO agr_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Makichik tsawantai Sansón yaakat Gazanum weuwai. Nunik nuwi makichik nuwa akiaku dutiktai pujuttaman wainak, nuna jeen waya niijai kanajui. ");
INSERT INTO agr_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Nuwi pujai filisteo aidaushkam Sansón tae tabaun antukag, nunú yaaktanmaya aidau Sansón pujamun tenteawajui. Dutikawag yaakta waitijin kuitamainak makichik tsawan batsamtau asa, kiitai kashin tsawaku maami tusag dakainak jasa takamtak batsatu. ");
INSERT INTO agr_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Tujash Sansógkak ejampek shintaag waiti aidaunak numijijaí tegajui. Dutika jiju minantuamunashkam ukuinag ashí yanaki yajuak, yaakat Hebrógjai niiniaku muja jiitkaunum iwaka nagkimak utsagkui. ");
INSERT INTO agr_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Duwi pujus, nuwa Dalila daagtin Sorec nugka pakajin pujuttaman jukitatus ausauwai. ");
INSERT INTO agr_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Dutikamtai filisteon apuji aidau Dalilajai chichastatus shiyakajui. Nunik jegajuawag chichajuinak: “Sansógkash wagkag ibau senchigtinaita tsanuja dekajuata. Dutikawamin itugkaik depetmainaitji nunú ejemi. Nunú dekajua achika jigkaja apusami. Tuja ame dekajuawaminig, ii aidauti maki makichik mil cien kuichik plata najanamu amastatji”, tiajui. ");
INSERT INTO agr_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Tusa tima Dalila Sansógkan chichajak: “Wagka ibau senchigtinaitme nunú minash wait aneasam ujatkata. ¿Wajigmin jigkapajagmataiya ayamjumainchaush amainaitme?” tau. ");
INSERT INTO agr_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Tusa tama nii ayaak: “Siete daek samek aidauwai jigkatjagmataig, tikich aents aina nujai betek senchigtuchu amainaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Tusa timatai Dalila filisteo apuji aidaun ujakui. Tusa ujakajam daek samek aidaun siete jukiag Dalilan susajui. Dutikam nuna juki Sansógkan jigkajui. ");
INSERT INTO agr_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","Dutika jigkaja, aents aidaun yaunchuk niina kanutaijin uuka batsasu asa, untsumak: “¡Sansógka, filisteo aidau jetepainawai!” tau. Tusa tutai Sansón nantak nunú daeknak apeamujai betek tsujiajui. Dutikamtai filisteo aidauk wagkag ibau senchigtinaita nunak dekamainchau dekapjajui. ");
INSERT INTO agr_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Tuja Dalila Sansógkan chichajak: “¡Tsanujaume! ¡Amek minak dushiktakum tujutiume! Tujash dekas yamaik wait aneasam tujutta, itugkaya emetmainush amainaitme nunú”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Tusa tutai Sansón ayaak: “Soga yamajam makichkish takashtaiyai jigkatjagmataig, tikich aents senchigtuchu aina nujai betek amainaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Tusa timatai yaunchuk aents aidaun niina kanutaijin uuka batsasua dutiksag batsasu asa, Dalila soga yamagman juki Sansógkan jigkaja, untsumak: “¡Sansógka, filisteo aidau jetepainawai!” tau. Tusa tama Sansón nantak, hilo tsejegkush tsujimaina imatika soganak tsujiajui. ");
INSERT INTO agr_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Dutikamtai Dalila niina chichajak: “¿Wagka ima tsanugme? ¡Amek minak tuke tsanugme! ¡Itugkaya emetmainush amainaitme nunú tujutta!” tau. Tusa tama Sansón ayaak: “Kakaumainchau wajasti tujutkumek, mina intashig siete chapikmagmawa nunú jáanchjai ijumjam jáanch apataiyai apijam, nuadui numi ajiam nuwi jigkamainaitme. Dutikawamin tikich aents senchigtuchu aina nujai betek amainaitjai”, tiuwai. Tusa timatai Dalila Sansógkan ikanag aepes intashi siete chapikmagbaun ijumag jáanch apataiyai apijauwai. ");
INSERT INTO agr_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","Dutika numi juki ajia jigka emetua untsumak: “¡Sansógka, filisteo aidau jetepainawai!” tau. Tusa tama nantak intashi jigkatuamunak japiki juwak jáanch apigtainak numi ajiamujai tsujiajui. ");
INSERT INTO agr_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Dutikamtai Dalila chichajak: “¡Amek waitaitme! Nuniayatkum aneajame tusa tujutmaume. Amek mina dushiktau asam, kampatuma imania tsanujaume. Tujash tuwi senchigmesh ajutjamua duka eke ujattsume”, tau. ");
INSERT INTO agr_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Tusa kashi kashinig iniak waitkamu asa yawetug dakitak, dekas jakatjai tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Tau asa, wagkag ibau senchigtinush ayi nuna Dalilan ujaak: “Wika nazareowaitjai. Mina intashjunak makichkish tsupigtuchu ainawai, wagki minak eke akiintsaig Apajuínu ati tusa etegkamu asan, pegkegchaun takaschati tibauwaitjai. Tuja mina intashjun tsupigtukagmataig, tikich aents senchigtuchu aina nujai betek amainaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Tusa etsegtumakmatai, yamaik dekas ujatkae tusa filisteo apuji aidaun ujaktajum tusa chichaman akuptak: “¡Yamaik Sansógkak wagkag ibau senchigtinaita nunak ashí ujatkae, nuniau asamtai kaunatajum!” tiuwai. Tusa timatai ame dekajuawaminig, akiktatjame tiu asag, kuichki jukiag Dalila pujamunum wegajui. ");
INSERT INTO agr_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Dalilak niina bakuin Sansógkan patas ikanjauwai. Nunik kanagmatai niina intashi siete chapikmagbaun tsupijati tusa makichik aentsun untsukui. Nunú jegantun ashí tsupijauwai. ");
INSERT INTO agr_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Dutika tsupijamtai Dalila untsumak: “¡Sansógka, filisteo aidau jetepainawai!” tau. Tusa tama Sansógkak Tuke Pujuu niina idaisamunak dekachu asa, kanag tepau nantak tuke ayamjubau asa nuniktakama nunimainchau wajasui. ");
INSERT INTO agr_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Nunik kakaumainchau wajasmatai, filisteo aidau achikag jiin mai ukuitkajui. Dutikawag yaakat Gazanum emajui. Dutika nuwi ejegawag cadena bronce najanamui jigkajag, aents achika chimpitainum trigon dekeak pujusti tusa apusajui. ");
INSERT INTO agr_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Dutikam pujai niina intashi ataktu tsakajauwai. ");
INSERT INTO agr_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Filisteo aents aidaun apuji aidau Sansógka achiku asag depetmakji tusag, shiig aneenak ditá apajuímtaiji Dagón aajakua nuna emematuinak, kuntinun maawag apeawagtatus ijunjajui. Nunik batsamas kantamainak: “Iina apajuíji yaimpasmatai, iina shiwaaji Sansón depetkaji” wajaidau. ");
INSERT INTO agr_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","Tuja tikich aents filisteo aidaushkam nuna wainkag dita apajuímtaijin emematus kantamainak: “Iina apajuíji yaimpasmatai, iina shiwaaji Sansón ii ajakmamu aidaun ijitjamak aents aidaun kuashat ijinnuwe nunú depetkaji”, wajaidau. ");
INSERT INTO agr_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Imatuidau asag shiig aneenak Sansón achikam egketa nunú jiiki itatajum tima, jiiki itawagmatai senchi dushikinau. Dutikainak jega jegamku ajigbau jimag wajaunum nuna ejapeen awajsajui. ");
INSERT INTO agr_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Dutikam wajasa uchi niina egkesa ejeentaun chichajak: “Juju jega jegamku ajigbau aina nunú jimag atsuak nuwi ejentunta, achimka wajasan ayamjatjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Tuja filisteo aidaun apuji aidauk nunú jeganum ashí nuwa nuwajaima ijunag piyak batsatu. Nuninai tikich aidaushkam nuna yakin ekenja jegamkamunum tres mil aents tumain Sansógkan dushikiagtai nuna diinak batsatu. ");
INSERT INTO agr_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Imatu batsatai Sansón senchi untsumak Tuke Pujuun segaak: “¡Tuke Pujuu Apajuí ashí senchigtinuh, wait aneasam ima juke inagnamu yainkata! Filisteo aidau mina jiijun mai ukuitjukajag dushiktuina nuna iikmaktajai. ¡Senchijum sujusta!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","Nuna tusa jega jegamku ajiamu ejapeen jimag wajaun nuna mai achikui. ");
INSERT INTO agr_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","Nunik achika wajas untsumak: “¡Filisteo aidautigmek yamai wijai jinaattagme!” tiuwai. Tusa tamawaik ashí niina senchijijai shitakiuwai, dutikam kupinak jega iyak filisteo apuji aidaunak, tikich nuwi batsatujai ashí yutua ijinauwai. Nii iwaku pujusa aentsun ijinauwa nuni kuashat nii jak ijinauwai. ");
INSERT INTO agr_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Nunik Sansón jakamtai, niina yachi aidau patayi aidaujai kaunawag iyashin jukiag, yaakat Sorá Estaoljai awa nuwi niina apaji Manoa ukusbaunum ukusajui. Sansógkak Israel aents aidaun yayaak veinte mijan takasui.");
INSERT INTO agr_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Israel aents aidaunmak eke apu adaijachbau asamtai, ayatak makichik aents Apajuí etegkamu ayamjukam batsamajaku aina, nunú tsawantin ditá nugken ashí nujan tepeauwai. Nunikmatai makichik aents Elimélec daagtin, Judá nugken yaakat Belégnum pujau, Moab nugkanum ujumak tsawan pujustatus weuwai. Nunik wegak niina nuwe Noemí nuigtu niina uchiji jimag: Mahlón, Quilión aatus juki weuwai. Dita aidauk Belégkanmaya ainayatak, Belégkan tikich daaji Efrata tutai asamtai, Efrata aents tutai aajaku ainawai. Nunik shiyakag Moab nugkanum jegawag nuwi batsamsajui. ");
INSERT INTO agr_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Nuwi batsatai Noemí aishi Elimélec jakauwai. Nunikmatai niina uchiji jimag aajakua nujai Noemí juwakui. ");
INSERT INTO agr_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Nunik batsamas nunú uchi aidauk Moabnumia nuwa aidaujai mai nuwenawajui. Nunú nuwa aidaun daajig Orfa, Rut aatus aajakui. Nunik nuwenawag diez mijan tumain batsamas ");
INSERT INTO agr_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","ditashkam mai jakauwai. Nunik uchiji jinaamtai, Noemík uchigtuchu, nuigtush aishinchau nigkiuch juwakui. ");
INSERT INTO agr_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Nunik pujus Tuke Pujuu niina aentsji Israel aents aidaunak wait anenjae, dutikau asamtai, ajak ajakmamuji aidauk shiig tsapai kuashat nejenawai. Nuadui yamaik nujantaik waituinatsui tabaun Noemí Moab nugkanum pujus dekauwai. ");
INSERT INTO agr_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Nunik dekaa Judá nugkanum waketak, niina uchiji nuwe aajaku aidaujai uminas jiinkiuwai. ");
INSERT INTO agr_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Nunik jintá wesag Noemí ditan chichajak: “Atumi duku pujamunum wakitkitajum, atum mina, tuja mina uchig aidaujai shiig kuitamkagtukuitjum dutiksag atumnash Tuke Pujuu kuitamjamkatnume. ");
INSERT INTO agr_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Tuja nuigtush ataktu aishinawag shiig batsamsatnume tusa yaimpaktinme”, tiuwai. Aatus tusa yapinum kugkuasui kumpama ishiaktatus. Dutikam dita buutuidau. ");
INSERT INTO agr_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Nuninak: “¡Atsa wakitkishtatji! ¡Iik amejai amina nugkemin minittaji!” tuidau. ");
INSERT INTO agr_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Tusa tiagtai Noemí ditan ataktu chichajak: “¡Nawantug aidauh, tutsuk shiyaktajum! ¿Wagka wijaish wetag tajume? wika muumpakiu asan, atum aishinmainnak uchi aishmagnak nuigtuk uchigmamaitsujai. ");
INSERT INTO agr_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","13","Tutsuk atumi jemin waketjatajum. Wika shiig múuntuch wajasjai, ataktuk aishinmaitsujai. Tuja yamai kashia duik aishinan uchi aishmagkun uchigmakaintagtaih, ¡nunikmataish atumek tsakagmatai, aishinatjai tusa dakakjumek pujumaitsugme! ¡Nunú tsakagti tusajum dakakjumek, aishintsuk jamain ainagme! Nawantug aidauh, atumek wijaig pujumaitsugme. Minak Tuke Pujuu waittsati tusa tujutmatai waitiag, nuna nagkaesau atum waitiamun diisan atumin wait anentakun waitmainaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Tusa tutai ataktushkam buutuidau. Tusa jimajá timatai, Orfak niina tsatsajin kumpama kugkuas ukuak wakitkiuwai. Untsu Rutak tsatsajijai juwakui. ");
INSERT INTO agr_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nunik juwakmatai Noemí niina chichajak: “Antukta nijah, amina wajegmi nuwe niina nugken, niina apajuímtaiji ayá nuwi waketui. Nuniau asamtai, ¡ameshkam niijai wetá!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Tusa tama Rut ayaak: “¡Ukugkita tusamek tujutipa! Ame tuwi wetatme nuwi wishakam minittajai. Tuja ame tuwi pujuttame, nuwi wishakam amejai pujuttajai. Ame wegantu aina duka wi wegantu agtatui. Tuja amina Apajuígmeshkam mina Apajuíg atatui. ");
INSERT INTO agr_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ame tuwi jakatnaitme nuwig wisha jakatnaitjai, nunika ai nuwig ukugsagtin atinme tajai. ¡Jaka megkaechayatkun, wi amina ukuakun yaja wetaik, Tuke Pujuu suwimkan sujustin ati tajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Tusa imattai, Noemí anentaimas, dekas mina uyuuntus wekaesatasampap tawa tusa ataktu awagkig wakitkita tusag tichauwai. ");
INSERT INTO agr_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Nunik mai juwakag we wenakua Belén jegawajui. Nunik jegawagmatai aents aidauk senchi pampaidau shiig aneenak. Imatiagtai nuwa aidauk: “¡Noemí tae, Noemí tae!” wajaidau. ");
INSERT INTO agr_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Tusa imatiagtai Noemí ditan chichajak: “¡Noemí tujutigpajum, Mará tujuttajum! Wagki, minak Tuke Pujuu ashí senchigtina nunú kajegtuk waittsati tujutmatai waittsajai. ");
INSERT INTO agr_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Wi juwi pujaun weuwaitag nunak kuashat yajumakan wegabiajai. Tujash yamaik wainkan uwegmatak wakitkijai, wagki Tuke Pujuu aatus wakekau asamtai. Nuadui minak Noemí tujutigpa, wagki Tuke Pujuu ashí senchigtina nunú minak waittsati tujutmatai waittsajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Aatus Noemí Moab nugkanum pujau, Rut niina uchiji nuwe Moabnumia aentsu nawanji aajakua nujai wakitki, cebada ajakbau juutai tsawan jegamunum, Belén jegauwai. ");
INSERT INTO agr_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Noemí aishi Elimélec aajakua nuna patayi Booz daagtin shiig wiakuch eme anentsa diitai, nunú tsawantin nuwi pujujakui. ");
INSERT INTO agr_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Makichik tsawantai Rut Noemín chichajak: “Wisha aja aina nuwi wetajai. Nunikan nuwi wekaesa takakun ajagtin juwaak nagkaejamu aidaun ukunum wekaetusan juukchainjash”, tiuwai. Tutai Noemí ayaak: “¡Ayu, wetá nawanta!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Tusa tima ajanum jeganta nagkaejamu aidaun juwaak wekagu. Niig tikichi ajajinis wekaeja tukama, dekas Noemí aishi Elimélec aajakua nuna patayi Booza ajajin wekagu. ");
INSERT INTO agr_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Nunik juwaak wekagai Booz Belén pujau niina ajajin weuwai. Nunik jeganta ajaka juu aidaun kumpamak aatus tiuwai: “¡Tuke Pujuu atumnash kuitamjamkatnume!” tiuwai. Tusa tama dita ainak: “¡Tuke Pujuu aminashkam pegkegnum yumigtamsati!” tiajui. ");
INSERT INTO agr_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Tusa tiagmatai, Booz ajaka juu aidau apujin iniak: “¿Juju nuwauch wekaga jusha yana patayimpaita?” tau. ");
INSERT INTO agr_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Tutai nii ayaak: “Juka Moabnumia nuwa Noemíjai taama nunuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Nunú juwi taa, wisha ajaka juwaak yuja nunú nagkaikimu aidaun ukunum wekaesan juuktajai tusa mina segatkui ayu timajai. Tuja yama nagkamchak taama duwi nagkamas yamaikish taka wekagu, ame taum duwi machik ayamui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Tusa timatai Booz Rutan jegantun chichajak: “Nawanta, wi tajam nunú shiig antukta. Wainka tikich aja aina nuwi wekeasamek makichkish juukaipa. Nuwa mina tsakatkeg aidau ajaka juwaak juwi batsata nujai pujusta. ");
INSERT INTO agr_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Nunika pujusam ajaka juu aidau tuwi takagtatua nuniakui nuwi ameshkam wetá. Tuja mina tsakatkeg aina nunak amina waitkagmasainum tusan shiig ujakagjai. Tuja ame kitamakmek, yumi aimjamu batsata nuna dita umuina nuwiya uwagta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Tusa tama Rut niina eme anentus tsuntsuma nugkanum nijayin antig pujusa Boozan iniak: “¿Wagka wi tikich nugkanmayayaitag nunin aish, imatika puyatjuttsamesh waitash anenjujume?” tau. ");
INSERT INTO agr_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Tusa tama Booz ayaak: “Amina aishjum jakamtai nagkamsam, niina dukuji wajuk kuitamkaume nuna wika shiig dekajai. Tuja nuigtushkam amina apa, amina duku, amina nugkem aaja ukukim ii amina wainchatai aidautijai ijunja pujustasa taum nunashkam shiig dekajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Nuna tusa ataktu chichajak: “¡Atashu uchiji dukuji nanapen waigka ayamjumama numamtuk, amina kuitamjamkatna nunú Tuke Pujuu Apajuí Israel aents aidaun Apajuíjiya nuwi yunumkaume! ¡Nuadui wi niina segajai, ame kuashat takasum nuna akigmakti tusan!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Tusa tama nii ayaak: “Apujuh, ame minak wait anenjujume. Ame tujutam nunú mina anentaignak ichichtujui. Wika amina tsakatkem aina nujaig makichkish betekchauwaitjai, nuniaig ame minak shiig anenjusam aujtusume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Tusa timatai yujumak yuwamunum Booz Rutan untsuka itan chichajak: “¡Juwi tantam, juju pag puuka jukim ayaka yutai chujuin umikbauwa nuwi uchupjata!” tiuwai. Tusa tima ajaka juu aidau pekagbaunum jeganta ekemsauwai. Nunikmatai Booz cebada duwikbaun juki susauwai. Dutikam nuna yuwa ejemag nuigtushkam ampijui. ");
INSERT INTO agr_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Nuna dutika ukuak ataktu ajakan juuktatus wetai, Booz ajaka juu aidaun chichajak: “Cebada tsupija jigkaka ijumjamu aina nunú sujittsut susatajum, jukiti. ");
INSERT INTO agr_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Tuja atum cebada juuka jigkaka ijumjamunmaya akagag kakeguk duka idaitustajum nii yajuakti”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Tuja Rutak Booza ajajinian ajakan juwaak wekagai, etsa akaetai nii juukbaujin akaja ijumag dekapa diikma veinte kilo amainun nagkagas jukiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Nuna yanaki juki Belén niina tsatsaji Noemí pujamunum jegauwai. Nunik cebada juukbaujin, nuigtu yutai ampija jukimujijai Noemín susauwai. ");
INSERT INTO agr_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Dutikam Noemí Rutan iniak: “¿Tuwi yamaish takasume? ¿Tuwiya imatikamesh juukume? ¡Amina yaimpaka nunak Apajuí pegkegnum yumigsati!” tiuwai. Tusa timatai, yana ajajinig takasabi, nuna Rut niina tsatsajin ujaak: “Wika aents Booz daagtinu ajajin takasmajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Tusa timatai Noemí ayaak: “¡Tuke Pujuu niinash pegkegnum yumigsati! Tuja nii iinashkam yaunchuk aents batsamajaku aina nuna yaigkua dutiksag yamai yaimpawai. Nunú aentsua duka mina aishug ayá nuna patayiyai. Nuadui iinak nii kuitamjamainai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Tusa timatai Rut ataktu chichaak: “Nuigtushkam nunú aents chichagtak, mina tsakatkeg aidau takaina nujai takasta, nunikam ajak ashí juunkamtai idaisata tusa tujutmae”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Tusa timatai Noemí Rutan chichajak: “Ayu nawanta, nunikta, wainka tikichi ajajin wekaemin waitkagmasainum, dekas niina tsakatke aina nujai takasta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Tusa tima Rutak Booza tsakatke aidau cebadan trigojai juwagtai, niishkam nuna juwa juwakua ashí ashimdaekamtai idaisauwai. Nunak niina tsatsajijai uyunis pujusa takajakui. ");
INSERT INTO agr_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Makichik tsawantai Noemí Rutan chichajak: “Nawantah, ame aishina shiig pujumainun egatkatjame”, tiuwai. Tusa chichajak: ");
INSERT INTO agr_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","“Nijah nawantah, Booz mina aishju patayiya nuna tsakatke aidaujai ame ijunja takasmaum nunú, trigon cebadajai akagtatus yamai kashi niina ajajin wetatui. ");
INSERT INTO agr_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Nuniktin asamtai, yamai wi titatjam nunú umikta: ¡Maita, nunikam kugkuin ukatmamkam jáanch pegkeg nugkugta! Nunikam Booz niina ajajin takak pujamunum wetá. Tujash eke yujumkan yuwa umutnash uwag umintsaigkik wantintukaipa. ");
INSERT INTO agr_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ayatak uumka pujusam tuwig kanajat nunú diyaku ata. Nunikam nii kanagmatai jegantam, nawenia jáanch pajantukam nuwi ayaumsam tepesta. Nunika tepamin, ame wajukattame nuna nii tujamtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Tusa tama Rut ayaak: “Ayu, ame tujutam nunak imatiksanuk umiktajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Aatus tusa Rut ajanum weuwai. Nunik jeganta niina aishi aajakun dukuji tibaunak imatiksag umikui. ");
INSERT INTO agr_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Tuja Boozak yujumkan yuwa, umutnash uwag shiig aneasui. Nunik nuadui kanagtatus ajak juuka ijumjamunum ayaumas tepesui. Nuwi kanak tepai Rutak takamtak jeganta Booza nawen ayaumas tepesui. ");
INSERT INTO agr_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Tuja Boozak kanag tepau ejampek shintaag ayanteagtakama, dekapjauwai makichik nuwa niina nawen ayaumas kanag tepaun. ");
INSERT INTO agr_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Nunik iniak: “¿Yaitpa amesh?” tau. Tusa tama nii ayaak: “Wika amina inakem Rutaitjai. Amek mina aishug ayá nuna shiig patayiyaitme, nuniau asam ame minak kuitamjumainaitme. Nuadui ame nuwatjukta tajame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Tusa tama Booz ayaak: “¡Nawanjuh, Tuke Pujuu pegkegnum yumigtamsati! Amek dekas amina aishjum aajakua duka shiig umigme. Nuadui tikich aents datsauch, ujunakesh nuniachkush wiakchakesh mina nagkaetasu aidau egamainaitkum, mina egatkaume. ");
INSERT INTO agr_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Nuadui nawanta ishamkagtukaipa, ame nuwa pegkejaitam nunak mina yaaktajuig ashí dekainawai. Nuadui ame segatam nunak imatiksanuk umiktajai. ");
INSERT INTO agr_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","“Tujash wika amina aishjum aajakua nuna patayiyaitkunush, tikima shiig patayichuitjai, dekas niina shiig patayi aidauk batsatui. ");
INSERT INTO agr_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Tuja yamaikik juwi kanagta, kashin amina aishjum aajakua nuna shiig patayi puja dusha, wi kuitamkatjai tujamtimpash nunú dekaami. Untsu nii dakitakuig, wi kuitamkatjame. Nunak Tuke Pujuu daajin umiktinjun tajai. ¡Tuja yamaik juwi shiig kanaja tsawagta!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Tusa tima Rutak Boozai ayaumas tepes kanajui. Nunik tsawak eke shiig pan weatsaig nantakiuwai, wagki Booz chichaak: “Juju nuwa ajanum tanta nunak makichkish wainkashtinme”, tiu asamtai. ");
INSERT INTO agr_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Nunik pujuttaman Booz chichajak: “Jáanchjum atiam wegkukam shiig emetuata.” Tusa tima achika emetuamtai, cebadan cuarenta kilo nagkagas yajatuauwai. Dutika jigkatua aenskam Belén wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Nunik niina tsatsaji pujamunum jegamtai, iniak: “¡Nawanta wajuk wekaesaume!” tau. Tama Rut Booz tibaun imatiksag ashí ujakui. ");
INSERT INTO agr_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Tuja ataktushkam chichaak: “Juna cebadan sujusa chichagtak: ‘Amina aishjumi dukuji puja nuwig uwegmatkek waketmaitsume’ tujutmae”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Tusa timatai Noemí niina chichajak: “¡Nawanta waugtutsuk pujusam dakasta wajukatig! Auk niig kajimatkig idaisashtatui, tuké wamak chichas epegkea idaisattawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Etsa agkuantai Booz yaakta waitijin aents aidau ijunajaku aina nuwi weuwai. Nunik nuwi jegan eketu. Nunik eketu Rutan aishi aajakua nuna shiig patayi nagkaemattaman wainak untsuka chichajak: “Juwi tanta ekemsata, chicham awa nunú chichasmi”, tiuwai. Tusa tima jegan ekemsauwai. ");
INSERT INTO agr_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Nunikmatai nunú yaaktanmaya apu eme anentsa diitai aidaun diez ipauwai. Dutikam ditashkam nuwi jegantag ekemsajui. Nunikagmatai, ");
INSERT INTO agr_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","dita antuinamunum Booz niina patayin chichajak: “Noemí Moab nugkanum pujau wakitki tae. Nunik iina patayi Elimélecka nugke aajakua nuna sujuktag tawai. ");
INSERT INTO agr_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Nuniau asamtai, amina nii dekati, nunik sumaktag takug yamaikiuch juju apu aina dusha antuinai, sumaktajai tusa titi tajame. Ame Eliméleckan shiig patayi asam, niina nugkega duka dekas sumamainaitme. Untsu ame sumakchatnaitkumek ujatkata. Ame dakitakminig, wi sumaktajai”, tiuwai. Tusa tama nii ayaak: “Nugkanak wi sumaktajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Tusa tutai Booz niina chichajak: “Shiig anentaimsata nijah, ame nunú nugka sumakmek, waje Moabnumia nuwa puja nujai nuwenattame. Wagki, nunú nugka yanau aajakuita duka nunisag niina daaji megkaetsuk asati tusam”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Tusa tama nii chichaak: “Nuninaitkuig wika nunú nugkanak sumamaitsujai, wagki mina uchig aidau nugkenchau wainak juwamain asagmatai. Untsu ame sumaktag takumek dekas ame sumakta, wi sumamainun amina idaitajame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Tuja nunú tsawantinig Israel aents aidauk makichik aentskesh niinu amainun tikichi suwakug, niina sapatjin juinia yantamen ukuimak nunú aents sumaun sujaku ainawai. Nuna betek umiak, ");
INSERT INTO agr_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","niina sapatjin ukuimak Boozan susauwai. Dutika chichaak: “Ame nugkak sumakta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Tusa tima Booz apu aidau, nuigtu tikich Israel aents aidau aatus nuwi batsatun chichajak: “Wi Noemí aishi Elimélec tuja uchiji Quilión, Mahlón aatus aajaku aina nuna nugkenak yamai atum antagmin sumajai. ");
INSERT INTO agr_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Tuja wi Rut Moabnumia nuwa wajea nuna nuwatkattag dushakam dekagme. Nunak dutikattajai, wagki niina aishi Mahlón aajakua nuna daaji megkaekai tau asan. Nuadui Mahlónka daajig, tuja nii wegantu aidaushkam juju yaaktanmak megkaekashtinai. Atum dekamunum junak tajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Tusa timatai apu múun aidau tikich aents aidaujai nuwi batsatu chichainak: “¡Ehe, duka dekas iishkam wakegaji! ¡Nunú nuwa amina jemin wayatta nunak Tuke Pujuu yaigti, dutikam Raquel Leajai iina dukuji aajaku aina nujai betek atin ati! ¡Untsu amek Efrata, tikich daaji Belén tuuta awagmatia nuanuig, eme anentsa ajantusa diitai atatme! ");
INSERT INTO agr_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","¡Tuke Pujuu yaimpasmatai, juju nuwa jujai kuashat uchijinatin ata! Tuja wakegaji Judá Tamarai akiamu Fares shiig kuashat uchigtin aajakua, iman ati tusa”, tiajui. ");
INSERT INTO agr_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Aatus Booz Rutjai nuwenauwai. Nunik pujaun Apajuí Rutan ejapjukti tima, ejapjuk uchi aishmagkun uchigmakui. ");
INSERT INTO agr_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Nunik uchigmakmatai, nuwiya nuwa aidau Noemín chichajuinak: “¡Tuke Pujuu emematiagmi, wagki nii yamai amina kuitamjamkatnun tijajumin amasu asamtai! ¡Itusag amina tijajumek Israel wegantu aidaunmak eme anentsa diitai ah! taji. ");
INSERT INTO agr_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ame muumpakiaminish nii shiig anemtijamsatnai, wagki amina uchigmi nuwe amina senchi anempa nuna uchiji asa. Nuadui Rutak, amina uchijum siete amaina, nuna nagkaesau atinai”, tiajui. ");
INSERT INTO agr_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Tusa tiajam Noemí uchin juki tsakapajui. ");
INSERT INTO agr_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Nunú uchin Noemí pagkus wajaun nuwa aidau wainkag chichainak: “¡Noemís uchigmakatai tumain anentaji!” tuidau. Nuna tuidau asag uchi daajin adaikajui Obed. Nunú aajakui Jesé apaji Davitan apachji aajakua nunú. ");
INSERT INTO agr_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Juju aajaku ainawai Fares wegantu aidau: Fares aajakui Hesrógka apaji. ");
INSERT INTO agr_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesrón aajakui Ramá apaji. Ram aajakui Aminadapa apaji. ");
INSERT INTO agr_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab aajakui Nahasógka apaji. Nahasón aajakui Salmónka apaji. ");
INSERT INTO agr_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmón aajakui Booza apaji. Booz aajakui Obeta apaji. ");
INSERT INTO agr_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed aajakui Jesé apaji. Tuja Jesé aajakui Davita apaji.");
INSERT INTO agr_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Efraígka mujajin yaakat Ramánum makichik aents Elcaná daagtin, Jerohama uchiji Eliú tijaji pujujakui. Duka Suf Efraín wegantu aajakua nuna uchiji Tohu aajakua nuna ama tijaji aajakui. ");
INSERT INTO agr_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Elcanák jimag nuwentin aajakui: Jeteke daajig Ana aajakui, untsu awan nuwe daaji Peniná aajakui. Peniná aajakui uchigtin, untsu Ana uchigtuchu aajakui. ");
INSERT INTO agr_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Maki makichik mijantin Elcaná nii pujamujin ukuki yaakat Silónum wejakui, nuwi kuntinu maa apeak Tuke Pujuu ashí senchigtina nuna ememattatus. Tuja sacerdote Elí uchiji jimag: Hofní Fineesjai, ditashkam sacerdote asag, Tuke Pujuun takajuinak nuwi batsamajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Tuja Elcaná kuntinun maa apea Apajuín emematkug nuna nejenak niina nuwe Peninán, niina uchiji aidaun, nawanji aidaujai aatus betek akanag tinamajakui. ");
INSERT INTO agr_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Untsu Ananak Tuke Pujuu uchigmakchatin ati tibau aigkishkam senchi aneau asa, neje dekas pegkejan juki sujakui. ");
INSERT INTO agr_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Dutiktai Peniná Anan kajejin asa, Tuke Pujuu uchin uchigmachu ati tibau asamtai, pegkegchaun chichajak dushikiak waitkau. ");
INSERT INTO agr_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Maki makichik mijantin Tuke Pujuu jeen Niina ememattatus shimujakua duik Peniná Anan tuke dushikijakui. Imatika waitkamu asa yujumkan yutsuk pujus ayatak buutujakui. ");
INSERT INTO agr_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Nunitai niina aishi chichajak: “¿Wagka buutme Ana? ¿Wagka yujumak yutsukesh wake besekmesh pujame? Wichaukaitag amina uchijum diez amaina nuna nagkaesau”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Tusa tima Ana Silónum pujus yujumkan yuwa umutnash uwag nuadui Apajuí jee pegkegmanum nuna waitijin sacerdote Elí eketbaunum jegantui. ");
INSERT INTO agr_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Nunik jeganta nii kajekbaujin buutki Tuke Pujuun segaak, ");
INSERT INTO agr_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","juna aatus nii umiktinjin tiuwai: “Tuke Pujuu ashí senchigtinuh, wika amina inakmetjai. Wi wake besemag wekagag duka amek dekame. Minash kajimatjuki idaitutsuk wait anenjakmek uchi sujusta. Dutijuawaminig wika amina takagtamin ati titinaitjai. Dutikau asan, nuna betek umiakun makichkish uchi intashinak tsupigkashtinaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Aatus Ana Tuke Pujuun initkak segaak wenin umuchiaun Elí diistakama wainkauwai. ");
INSERT INTO agr_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Tuja Anak initkak Apajuín segau asa wenin umuchiau asamtai, Elí antukchauwai. Nuadui Elí anentaimas nampekampas aan eketatai tusa, ");
INSERT INTO agr_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","chichajak: “¿Wagka ima nampetash wekaetame? ¡Nampet wekaetutsuk idaisata!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Tusa tama nii ayaak: “Vinonakesh, tuja tikich uwaja nampetainakesh uwagchamjai. Shiig senchi wake besemag dekapeamu ajutu asamtai, wi waitiamujun pachisan ashí Tuke Pujuun ujaakun eketjai. ");
INSERT INTO agr_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Wainkam nuwa pegkegchauwa nunin diigsaipa, wika uyumamu ajutu asamtai, wake besemag dekapeakun nuna pachisan Tuke Pujuun augkun eketjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Tusa tutai Elí ayaak: “¡Agkan, shiig aneasam wetá! Ame waji segaume nunak, Israel aents aidau Apajuín emematin aina nunú amastatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Tusa tima ayu tusa ukuak, niina jeen shiig aneas wakitkiuwai. Nunik jegaa yujumkan yuwauwai. Duwi nagkamsag wake besemag pujamujig atsugsauwai. ");
INSERT INTO agr_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Tuja kashinia duwi kashikmas Elcaná niina nuwe aidaun yajuak Apajuín jee pegkejam aajakua nuwi Tuke Pujuun ememattatus weuwai. Nunik nuwi jegaa Tuke Pujuun ememati ukuak, niina jeen yaakat Ramá wakitkiuwai. Nunik wakitki jegaa Elcaná niina nuwe Anajai kanajui. Aatus Tuke Pujuu Anan wait anenjauwai. ");
INSERT INTO agr_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Nuadui Ana ejapjuk pujus tsawanji jegamtai, uchi aishmagkun uchigmakui. Dutika adaikauwai Samuel. Nunak “Apajuí segamu” taku tawai. ");
INSERT INTO agr_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Duwi pujus Tuke Pujuu ememattai mijan jegamtai, Elcaná niina nuwe Peninán niina uchiji aidaujai yajuak, nii Tuke Pujuu anagkuamun umiak kuntinun maa apeak Tuke Pujuun ememattatus yaakat Silónum weuwai. ");
INSERT INTO agr_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Untsu Anak ditajaig wechauwai, ayatak aishin chichajak: “Wika minishtatjai, uchi yujumkan nigki yumain wajasmatai, niina jukin, jega pegkegmanum Apajuín ejetuattajai, nuwi tuke pujustin ati tusan”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Tusa tutai niina aishi ayaak: “¡Ame wajuk wakegame nunú umikta! ¡Amejai uchik pujus muntsun tsujakti! Ame tame nunak Tuke Pujuu umikti”, tiuwai. Tusa timatai Anak niina uchijijai juwakui. Nunik pujai uchi muntsu tsujaka yujumkan nigki yumain wajasui. ");
INSERT INTO agr_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Nunikmatai Ana uchijin juki yaakat Silónum Apajuí jee pegkegmanum emauwai. Tuja nuigtushkam makichik toro tsakatan kampatum mijan ajamun, trigo veinti dos kilo, nuigtu duwap apagbaunum vinon yajaa aimak, aatus yajuak weuwai. ");
INSERT INTO agr_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Dutika ejegamtai Elcaná niina nuwe Anajai nuna apeak Tuke Pujuun emematiajui. Dutikawag uchí jukiag sacerdote Elí pujamunum ejeentajui. ");
INSERT INTO agr_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Dutika Ana chichaak: “Mina apujuh, wait aneasam antugtukta. Yaunchuk juwi wi aminí ayaumsa pujusan Tuke Pujuun segaakun pujubiajai, ");
INSERT INTO agr_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","juna uchin sujusti tusan. Nuadui Tuke Pujuu juna uchin sujuse. ");
INSERT INTO agr_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Nuadui yamaik wishakam Tuke Pujuunu ati tusan niina idaitajai, ima niinak takagsatin ati tusan”, tiuwai. Tusa timatai, Elí Tuke Pujuun emematak tsuntsuma nijayin nugka antig pujusui. ");
INSERT INTO agr_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Ana kantamak aatus Apajuín tiuwai: “Tuke Pujuuwah, wika aminí shiig aneajai, wagki ame senchimtijau asamin. Yamaik mina shiwag aidaujaish ainikan tudaimain wajasjai, wagki ame yainkau asamin. ¡Yamaik shiig aneasan pujujai! ");
INSERT INTO agr_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","¡Tuke Pujuuwah, ame pegkegmaitam imanuk tikichik atsawai! ¡Ame jutii Apajuíji asam kuitamkagtam, imatikas kuitamkagtauk tikichik makichkish atsawai! ¡Amina nagkaetamsauk tikichik atsawai! ");
INSERT INTO agr_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Makichkish ememasag chichamain ainatsui. Tuja ima nigki eme anenmamuk makichkish atsuti. Tuke Pujuuwai ashí yacha duka. Tuja Tuke Pujuuwai maki makichik aents pegkegchau takasbaujin diijus suwimkan suwa duka. ");
INSERT INTO agr_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Apajuíyai aents senchigtin aina nuna senchigtuchu emak, aents senchigtuchu aina nuna senchimtiknuk. ");
INSERT INTO agr_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","“Yaunchuk yumainji kuashat ajujakbauk, yamai makichik pag yuwatag tabaunum takak waituinawai. Tuja yaunchuk nujantai waitujaku aidau, yamai waituinatsui. Nuwa uchigmachu aajakushkam, nuwa uchigbau aidaun nagkaesau sieteya imagnia uchigmainawai. Untsu yaunchuk uchiji kuashat ajujakagbauk, uchigmamainchau wajasaje. ");
INSERT INTO agr_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Tuke Pujuuwai pujutan sukagtinuk. Ima nigki jakati tusashkam tukagtauk. Nunika jaka ajin iina patayi aidau ukumatainum ukugmasagmataish, ataktu inantamki pujutan amastina nunú. ");
INSERT INTO agr_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","“Tuke Pujuuwa nunuwai ujuuna ekagtinuk. Tuke Pujuuwai wiakuch ekagtinuk. Nii amasbaun atanjamkish, nigki ataktushkam imatiksag sukagtinai. ");
INSERT INTO agr_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Nii aents ujunauchin wiakchamtiknai. Tuja aents yumainji atsugbaun, egaka yuu wekagun juki, aents eme anentai aidaujai betek emauwai, dutika nunú aents eme anentsa diitai aidaun ekemtain ekentsatatus. Tuke Pujuuwai ashí nugka aina nuna najanak, nugka patami asatnunashkam umikua duka. ");
INSERT INTO agr_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Tuke Pujuuk ya niina shiig umijua nuna kuitamui. Untsu aents pegkegchau aidauk jinuinawai, nunikag suwimkanum shimuinawai. Wagki makichik aentsuk niina senchijinigkik ayamjumamaitsui. ");
INSERT INTO agr_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Tuke Pujuuk nayaimpinum pujus niina shiwaaji aidaun chaagpin ajuntug ijinattawai. Ashí aents nugkanum batsata nunak Tuke Pujuu dita takasbaujin diijus suwimkan susattawai. Untsu apu atinun nii etegkamunak aan nagkaemas senchigtin emattawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Tusa kantama inagnakmatai, Elcaná Anajai niina jeen yaakat Ramá wakitkiuwai. Tuja uchik Tuke Pujuun takagsatatus sacerdote Elíjai juwakui. ");
INSERT INTO agr_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Elí uchiji aidauk pegkegchau aidau asag, Tuke Pujuunak ajantus diijakchau ainawai. ");
INSERT INTO agr_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Nunidau asag makichik aentskesh Apajuín emematak kuntinun maa apeamun antukajag dita inaken akupejaku ainawai. Dutikamu nunú tenedor múun wajaknun takaku jegawag ajantsuk kuntinun neje yama najaunak, ");
INSERT INTO agr_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","nunú tenedorai iju jiijag yajumaidau. Dutikainak Israel aents aidau yaakat Siló jegawag Apajuín ememattag tuidaunak waitkaidau. ");
INSERT INTO agr_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Tuja kuntinu wiyajin eke apeatatus pujugtatmanash sacerdote inake jegantun chichajak: “¡Sacerdotenu neje atinuk uduu mina sujusta wi jukin inagtuatjai, wagki sacerdotek neje inajuamunak dakitawai!” tau. ");
INSERT INTO agr_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Tusa tama aents ayaak: “Jasta, dekatkauk kuntinu wiyajin apeatjai. Dutikamtai ame wakegamu jukita.” Tama nii chichajak: “¡Tutsuk yamaikiuch sujusta! ¡Sujachkuminig wiki atankittagme!” tau. ");
INSERT INTO agr_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Elí uchiji aidauk shiig pegkegchau Tuke Pujuunash umijujakchau ainawai. Nunin asag Tuke Pujuu anentag suwamunash ajaantus diitsuk dita wakegamun takajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Untsu uchi Samuelak Tuke Pujuunak shiig umijujakui. Nuniau asa nigka sacerdote nugkutai lino apagbau efod tutain nugkujakui. ");
INSERT INTO agr_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Tuja maki makichik mijantin niina dukuji apajijai Apajuí jee pegkegmanum jegawag kuntinun maa apeenak Apajuín ememattatus weakug niina uchiji Samuel nugkugtin jáanch apagbaujin juki wejakui. ");
INSERT INTO agr_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Nuniau asamtai Elí, Elcanán Anajai pegkegnum yumigkiak: “Juju uchin Ana Tuke Pujuun anentag susa duwi, Tuke Pujuu Anayai nuni kuashat uchijum aidaun amastí”, tiuwai. Tusa tima dita jeen waketjajui. ");
INSERT INTO agr_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Nuadui Anak Tuke Pujuu pegkegnum yumigkiamu asa, kampatum uchi aishmagkun, jimag nuwan aatus uchigmakui. Tuja Samuelak Tuke Pujuu kuitabau asa, nuwig niina takajak pujusa tsakau. ");
INSERT INTO agr_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Tuja Elík múuntuch aajakui, tujash niina uchiji aidau Israel aents aidaun waitkainawai tabaun ashí dekauwai. Tuja Apajuíjai chichatai jega pegkejam jegamkamua nuna waitijin nuwa aidau kuitamin aina nujaishkam kanuinawai tabaun dekauwai. ");
INSERT INTO agr_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Nunik dekaa ditan chichajak: “Atum pegkegchau takainamun ashí aents aidau ujatkaje. ¿Wagka dusha anísh batsatjume? ");
INSERT INTO agr_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Mina uchig aidauwah, atum aniajum duka shiig pegkegchauwai. Atum aniakjum tikich aents Tuke Pujuun nemajin aidau bakuagme, wagki atum pegkegchau dutikamun tikich aents aidau nuna augmatu yujaidaun antukjai. ");
INSERT INTO agr_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Makichik aents tikichin kajejaunak, Apajuí diisa ayamjumainai. Untsu aents Tuke Pujuun kajejaun ayamjumainuk makichkish atsawai”, tiuwai. Tusa tamash, ditak apaji chichamenak antugkachajui, wagki Tuke Pujuu ditanak jinaati tibau asag. ");
INSERT INTO agr_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Untsu Samuelak nuni senchi muumpau. Nunitai Tuke Pujuu shiig anentau, tuja aents aidaushkam shiig anentuidau. ");
INSERT INTO agr_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Tuja nunú tsawantin Apajuí chichame etsejin Elín ijagsatatus jegajuauwai. Nunik jegajua chichajak: “Amina apachjum aidau Egipto nugkanum faraógka inaku waitkatai batsatun wi mina senchijun ditan iwaintukuitag nuna dekati Tuke Pujuu tujamui. ");
INSERT INTO agr_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Israel aents aina nuwiyan Leví wegantu aidaun etegkauwaitjai mina sacerdoteg agtinme tusan. Dutika ai mina emematjuinak kuntinu maawag nuna nejen ashí apeatnume, tuja kugkuin incienson apeatnume, jáanch sacerdote nugkutainashkam nugkugtinme tusan. Tuja Israel aents aidau anentag sujusbau aidaun mina emematjuinak apeena nunashkam yuwatnume tusan amina apachjum aajaku aina nuna tiuwaitjai. ");
INSERT INTO agr_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Nunin aish, ¿wagka wi dutikatajum timawa nunú dutiktsukesh dakitjagmesh idaisaugme? Amek amina uchijum aidau mina nagkaetasu puyatjau asam, Israel aents aidau mina anentag sujuinamua nunú jukim ayu ayugkawam uduekume. ");
INSERT INTO agr_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","“Dutikau asamin Tuke Pujuu Israel aents aidaun Apajuíji mina takagtin atinme tusa tujabiuwa nunú chichaak: ‘Wi atumnak mina takagtustinme tusan etegkauwaitjime. Tujash duka yamaik makichkish uminkashtatui. Wika mina eme anenjuina nuna eme anentatjai. Untsu mina dakitjuina nunak wishakam dutiksanuk dakitjattajai. ");
INSERT INTO agr_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Amina uchijum aina duka yamai nagkamsag sacerdote achagtatui. Nuadui ame wegantu aina duka múuntuch wetsuk datsaitak jinawagtatui. ");
INSERT INTO agr_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Untsu amek tikich Israel aents aina nuna wi yayaakui nunú diisam ame waitiakum dita kajegtinaitme. ");
INSERT INTO agr_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Tuja ame wegantu aina nuwiyan sacerdote atinme tusan wi ujumak apusamu akushkam, duka wainmachujai betek tikich aidau takagtai nuna diisag kajenak wake besemag dekapenak buutiagtinai. Tuja ame wegantu aidauk múuntuch wetsuk datsaitak jinawagtatui. ");
INSERT INTO agr_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","“ ‘Tuja amina uchijum aidau Hofní, Fineesjai makichik tsawantaik mai jakattawai. Nunikmatai dekaattame dekaskeap tujutne tusam. ");
INSERT INTO agr_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","“ ‘Nuadui tikich wegantunmayan wi kajittsa anentamujun, tuja mina chichamjun betek umiktinun, sacerdote atinun makichik etegkattajai. Dutikan niina uchiji wegantu aidaunash megkaejainum tusan kuitamkattajai. Nuadui ditak wamak jinutsuk kuashat tsawan batsatu asa apu wi etegkamua nunú tabaun umigkatnume titatjai. ");
INSERT INTO agr_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","“ ‘Nuadui ame wegantu jinaachu aidauk nunú sacerdoten jegajuawag ujumak kuichkin, yutaijai segainak tikishmatiagtinai. Nuninak, minash takat sujusta wisha takasan yumainun sumapaktajai wajagtinai’, tujamui Apajuí”, tusa tiuwai. ");
INSERT INTO agr_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Samuelak tsakataitak nagkamas sacerdote Elí takatai yayaak pujus Apajuín umijujakui. Nunú tsawantinig Tuke Pujuuk kakajus aentsnak wantintujakchauwai. Nuadui makichik aentsnakesh chichama etsegtugkati tusag ujajakchauwai. ");
INSERT INTO agr_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Elík muumpakiu asa shiig wainmamainchau dekapeak niina kanutaijin kanak tepejakui. ");
INSERT INTO agr_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Nuniai Samuelak Apajuí jee pegkegmanum chicham umiktin agagbau egkeamu arca pujujakua nuwi niishkam kanak tepai, nunú jeganum jii ekemakbauk eke kajintsaig, ");
INSERT INTO agr_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Tuke Pujuu niina untsuak: “¡Samuel, Samuel!” tama nii ayaak: “Juwi pujajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Tusa nantaki tupikaki Elí pujamunum jegantui. Nunik jeganta chichajak: “Pai taajai, ¿wagka untsugme?” tau. Tama Elí ayaak: “Wika aminak untsuatsjame, wakitkim kanagta”, tiuwai. Tusa tima wakitki tepesui. ");
INSERT INTO agr_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Nunik tepaun Tuke Pujuu ataktu untsuak: “¡Samuel, Samuel!” tusa untsuam, nantaki Elí pujamunum jeganta chichajak: “Pai taajai, ¿wagka untsugme?” tau. Tama Elí ayaak: “Wika uchuchi aminak untsuatsjame, weme kanagta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Samuelak Tuke Pujuunak makichkish wainchau tuja niina chichamenash antuchu asa yaki untsujua, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Tujash Tuke Pujuu ataktu kampatuma juna untsukui. Tusa untsuam nantaki Elí pujamunum jeganta chichajak: “Juwi taajai, ¿wagka untsugme?” tau. Tutai Elí anentaimas dekas Tuke Pujuu untsuamap tawa tiuwai. ");
INSERT INTO agr_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Nuadui chichajak: “Wakitkim tepesta, nuniamin ataktu untsugmakuig: ‘Mina Apujuh, amina inakminuk juwi pujajai, waji tame tujutta’ tita”, tiuwai. Tusa tima Samuel wakitki tepesui. ");
INSERT INTO agr_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Nunik tepettaman, Tuke Pujuu ataktu jegantun yaunchuk untsukbaunak dutiksag untsuak: “¡Samuel! ¡Samuel!” tama nii ayaak: “¡Mina Apujuh, waji tame tujutta, amina inakminuk juwi pujajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Tusa tama Tuke Pujuu niina chichajak: “Israel aents aidaunum makichik ishamainun iwainaktatjai. Nuna aents aidau wainkag ishamainak kujaidiagtatui. ");
INSERT INTO agr_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Tuja wi Elí patayi aidaun pachisa timag nunak nunú tsawantin makichkish ewaetsuk umiktatjai. ");
INSERT INTO agr_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Wi niina ujaakun, amina uchijum aidauk mina umigtutsuk pegkegchaun takasaju asagmatai, suwimkan susattajai timag nunak nigka shiig dekawai. Wagki, niina uchiji aidau mina pegkegchaun chichagtiagtaish, makichkish jintintuachu asamtai. ");
INSERT INTO agr_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Nuadui Elí patayi aidauk Apajuí tudaun tsagkugtamjati tusag kuntinu maa apenakush, makichkish dita tudaujig tsagkujam achagtatui. ¡Wi nunak dekas nuniktinun tajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Tusa tima Samuel ataktu tepesui, nunik kanag tsawag, kashikmas nantaki Apajuí jee pegkegma nuna waitijin ujainiuwai. Tujash Samuelak Tuke Pujuu tibauwa nuna Elí ujatan ishamau. ");
INSERT INTO agr_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Nunitai Elí untsuka chichajak: “¡Uchuchi Samuela!” tau. Tama nii ayaak: “¡Juwi pujajai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Timatai Elí niina iniak: “¿Tuke Pujuush wajinjutpame? ¡Wait aneasam ugtukaipa! ¡Apajuí tujamauwa nunú ame mina ugtutaik nii suwimkan amastatui!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Tusa tama Samuel Apajuí tibaunak uugtsuk ashí niina ujakui. Tusa ujakam Elí senchi untsumak: “¡Aminak dekas Tuke Pujuu tujamne! ¡Nii tawa nunak imatiksag umikti!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Samuelak nuwig pujus tsakajui. Tuja Tuke Pujuu niinak yaigkui, nuadui Apajuí tibaun nii etsegkauwa duka imanisag ashí uminkauwai. ");
INSERT INTO agr_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Tuke Pujuu mina chichamjun etsegtugkati tusa Samuelan etegkae tabaun Israel aents aidauk, Dan wegantu aidau nugken nagkamas, yaakat Beersheba tutaya imanui ashí dekawajui. ");
INSERT INTO agr_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Tuja Samuelak yaakat Silónum Apajuí jee pegkejam aajakua nuwi pujau asamtai, Tuke Pujuu nuwi tuke niijai chichau asa ataktushkam chichaman ujakui. ");
INSERT INTO agr_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Dutika ujakam Samuel ashí Israel aents aidaun Apajuí tibaunak imatiksag ujajakui. Nunú mijan aajaku aina nuadui makichik tsawantai filisteo suntag aidau Israel aents aidaujai maaniawagtatus ijunjajui. Nunik shimutkag nugka segau Afec tutainum nuwi aakmajag batsamsajui. Nuninai Israel aents aidaushkam ditajai maaniawagtatus jiinjag nugka segau Eben-ézer tutainum jegattak aakmag batsamsajui. ");
INSERT INTO agr_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Nuwi batsamas filisteo suntag aidau Israel aents aidaun jetekajui. Dutikawag maaninamunum filisteo aidau Israel aents aidaun depetuk cuatro mil aentsun ijinawajui. ");
INSERT INTO agr_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Dutikam Israel aents aidau waketug ditá aakjin jegawagmatai, apu aidau ditan iniinak: “¿Wagka Tuke Pujuush iinash filisteo aents aidau ijinatnume tusash idaitamsae? Dekas yaakat Siló shiyakagmi, nunikaja arcanum chicham umiktin agagbau egketa nunú utiagmi. Dutika ajin Tuke Pujuu iinash ayamjutpakti”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Nuna tusag ujumak suntag aidaun ishiakajui yaakat Silónum arca utitnume tusa. Dutikam shiyakag arcan juki itawajui. Nunú arca dukutaijin jimag ángel querubin dakumkamu aunum nuwi Apajuí ashí senchigtina nunú pujujakui. Tuja Elí uchiji aidaushkam, Hofní Fineesjai nuwi takaidau asag ditashkam kaunawajui. ");
INSERT INTO agr_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Arcan juki dita batsatbaunum itawagmatai, ashí Israel aents aidauk shiig aneenak senchi untsumaidau. Nunú imatuinamu nugkan umuchkauwai. ");
INSERT INTO agr_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Imatuidaun filisteo aidau antukag inimainak: “¿Israel aents aidau batsata nuwish wagka imanikash pampainawa?” tuidau. Tukama dekawajui Israel aents aidau arcan dita batsatbaunum itawaje tabaun. ");
INSERT INTO agr_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","Nuna dekawag senchi ishamak chichainak: “¡Apajuí Israel aents aidau batsamtain tae! ¡Jaucha iish yamaish wajukatjiki, yaunchkesh anijakchamun yamai Apajuí iina shiwaaji nugken tae!” wajaidau. ");
INSERT INTO agr_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","“¡Apajuí ashí senchigtina nunú iina suwimka amataish, yaki iinash ayamjutpakti! ¡Niyai egiptunmaya aidaun jata ishamain aidauwai suwimkan susa ijinauwa duka! ");
INSERT INTO agr_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","¡Nuniau asamtai, hebreo aidau atumi inake aajaku aina nujai betek ditá inake atumesh atag tachakjumek, suntag filisteo aidautijum umintsatajum, nunikjum aishmag wajasjum senchi maaniatajum!” tuidau. ");
INSERT INTO agr_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Tusa tiajam Israel aents aidaun jetekag maaniawag depetkajui. Dutikainak dawé yujasag maanin aina nuna treinta mil suntag aidaun amukajui. ");
INSERT INTO agr_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Tuja nuigtushkam arcanum chicham umiktinun Apajuí Israel aents aidaun susauwa nunú egketun jukiajui. Dutikainak Elí uchiji Hofnín, Fineesjai mai maawajui. ");
INSERT INTO agr_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Untsu makichik suntag Benjamín wegantunmaya maaniamunum wekagu tupikaki nunú tsawantaik yaakat Siló jegauwai. Nunik tupikak wake besemag dekapeamunum jáanchjin japiki ichigka, niina buukenishkam nugkan yukumag ayatak nugkak wajas weuwai. ");
INSERT INTO agr_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Nunik jegakma, chicham umiktin agagbau egketun jukiaju asagmatai, Elí nuna puyatjak waitinum ayaumas ekemas jintanum niimak eketai jegauwai. Nunik jegá yaaktanum waya, nuwi aents batsatunum chichama etsegkauwai. Nuna antukag ashí aents aidauk senchi buutuidau. ");
INSERT INTO agr_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Imatuidaun Elí antuk iniimak: “Nunash ¿wagka imatuinawa?” tau. Tusa tai suntag tupikaki jegauwa nunú waujus Elí pujamunum jeganta, ashí chichaman ujakui. ");
INSERT INTO agr_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","Tuja Elík noventa y ocho mijan ajamu asa múuntuch wainmamainchau wajas pujau. ");
INSERT INTO agr_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Nuna jegantun chichajak: “Maaniamunum wekagun tupikakin yamai taajai”, tau. Tama Elí iniak: “¿Wajukawagmae tujash, uchuchih?” tau. ");
INSERT INTO agr_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Tusa tama nii ayaak: “Filisteo suntag aidau, jutii aidautin depetamak, chicham umiktin agagbau egketunak atanjamkiagmae, nuigtu kuashat suntag aidaun ijinawagmae. Tuja amina uchigminashkam mai maawagmae”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Elík shiig múuntuch kakaumainchau wajasu asa, chicham umiktin agagbaun Apajuí amasua nunak jukiagmae tusa ujakam, nuna antuk puyatuk sillanum eketu dakagá iyaak kuntujen akagak jakauwai. Elík Israel aents aidaunmak cuarenta mijan takasui. ");
INSERT INTO agr_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Tuja Elí uchiji nuweshkam ejamtin uchigmatnak wajas pujau asa, filisteo aents aidau chicham umiktin agagbau egketun arcan jukiagmae, tuja amina aishjumnash maawagmae, nuigtushkam amina aishjumi apajish jakae tabaun antukui. Nunik puyatuk uchin najaima uchigmakui. ");
INSERT INTO agr_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Nunik uchigmak jakauwai. Nunik eke jatsaig uchi uchigmitkau aidau chichajuinak: “Ishamkaipa, uchik aishmag uchigmakume”, tiajui. Tusa tamash nigka chichakchauwai, wagki jakau asa. ");
INSERT INTO agr_vpl VALUES ("S14_21","010_4_21","1SA","4","21","22","Untsu eke jatsuk uchiji daajin Icabod adaikauwai. Nunak: “Israel aents aidauk chicham umiktin atankimu asag yamaik shiig wainak juwakaje”, taku tawai. Nunak niina aishi jakau, tuja aishi apajishkam jakau asamtai, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Chicham umiktin egketun arcan filisteo aidau jukiag muja Eben-ézer tutaya nuni akaikiag ditá yaaktajin Ashdod ejegawajui. ");
INSERT INTO agr_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Dutikawag ditá apajuímtaiji dakumka najanamu Dagón tutai aajakua nunú jegamjukbaunum awayawag, Dagónkan ayaunas ekentsajui. ");
INSERT INTO agr_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Dutikawaju ai kashinia duwi kashikmasag Ashdodnumia aents aidau waya diikma, dita apajuímtaiji dakumka najanamu Dagón nagkima nugká ajiajam, chicham umiktin Apajuínu arca eketu emtin tepaun wainkajui. Dutika wainkag inanki jukiag yaunchuk aajakbaunmak ukukiajui. ");
INSERT INTO agr_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Dutikawag tsawainak kashikmas nantakiag wayawag diikma, ataktushkam nagkima ajuajam tepaun wainkajui. Tujash ayatak iyajag tepachu, buuke akagak uweje aidauk kupinag, ima iyashig takamchau tepaun wainkajui. ");
INSERT INTO agr_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Nuadui sacerdote Dagónkan emematin aidauk nunú jeganum wainakug, Dagónkan buuke kuntujejai kupinag batsamsauwa nunak najatsuk chikai nagkayin ainawai. ");
INSERT INTO agr_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Tuja duwi pujus filisteo aents aidau yaakat Ashdodnum batsamin aidaunak Tuke Pujuu suwimkan suwak jata tumor tutain ajunjauwai. Antsag tikich yaakat nuwi ayaumas aushkam nunú jatai shiig senchi waituidau. ");
INSERT INTO agr_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Imanik waituidau asag Ashdodnumia aents aidau chichainak: “Israel aents aidaun Apajuíjiya nunú iinak Dagón iina apajuímtaijiya nujai ijumag senchi suwimkan amase. Nuadui juju chicham umiktin agagbau Israel aents aidaun Apajuíjinua duka juwig jutiyaig amaitsui”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Nuna tuidau asag, filisteo apuji aidaun untsuka itantag iniinak: “¿Israel aents aidaun Apajuíjiya nuna chichame umiktin agagbau egketa dusha itugkattaji?” tuidau. Tama dita aimainak: “Yaakat Gadnum jukijum ejegatajum”, tiajui. Tusa tiajam ditashkam dutiksag juki ejegawajui. ");
INSERT INTO agr_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Tujash dutika juki ejegawaju ai, yaakat Gadnumia aidaun Tuke Pujuu suwimka suwak imum ishamainun ajunjauwai. Dutikam múun aidauk, uchi aidauk, nuna utsumajag senchi waituidau. ");
INSERT INTO agr_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Imaniagtai, chicham umiktin egkeamu arca Gadnum ejegamun filisteo aidau jukiag tikich yaakat Ecrón tutainum ejegawajui. Dutika ejegawagmatai nuwiya aents aidau untsumainak: “¡Jinatnume tusa Israel aents aidaun Apajuíjiya nuna chichame umiktin agagbau egketun arcan juki itagtamawaje!” wajaidau. ");
INSERT INTO agr_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Gadnumia aents aidaun Apajuí suwimka suwak jata ishamainun ajunjae tabaun ashí tikich yaaktanmaya aidau antukajui. Nunikag filisteo apuji aidaun untsuka ijumag chichajuinak: “¡Juju chicham umiktin Israel aents aidaunu arcanum egkeamua nunú jukijum itaujum duka, tuwi au jukimugme dutiksagmek wamak awagkitajum! Wagki Apajuí ashí ijipawai taji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Tusa imatuinak untsumainamuk nayaimpinmash antuegu. Tuja aents iwaku batsatuk imum amuam shiig senchi waituidau. ");
INSERT INTO agr_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Filisteo aidau arcan jukiajua duka siete nantu dita nugken asauwai. ");
INSERT INTO agr_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","Nuwi aig sacerdote aidaun, anentaimas dekamin aidaujai iniasagtatus untsukag ijumjajui. Dutika iniinak: “¿Chicham umiktin arcanum egketa dusha itugkattaji? Tuja wajuk awagkittaji nunú titajum”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Tusa tama dita aimainak: “Chicham umiktin egketa nunú arca awakeakjumek, Apajuí tsagkugtugti tusajum waji anentag awetitajum. Nunú dutikajum atum jata achiimagjum waitiajum duka tsagagtatjume. Nunikjum duwi dekattagme wagkag suwimkanash Apajuísh amasaje nunú”, tiajui. ");
INSERT INTO agr_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Tusa tiajam dita aimainak: “Tujash ¿ii pegkegchau takamsamunum kajegtamak suwimka amasai tusaish wajig sumainaitji?” tuidau. Tusa tiagtai sacerdote aidau aimainak: “Atumi apujum cinco aina dutiksagmek oro jukijum imumjai betek dakumkajum cinco najanatajum. Tuja nuigtu cinco katip dakumkajum dushakam orojai najanamu awetitajum, wagki atumek atumi apuji aina nujai jinuidau asajum. ");
INSERT INTO agr_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Nuadui imum katipjai dakumkajum najanatajum, wagki nunú aidau iina nugken emestugbau asamtai. Dutik etsagjatajum Israel aents aidau Apajuíji. Dutikawagminish tsagkugtamag suwimkan amatsuk, atumi apajuímtaiji aina nunash tuja atumi nugke aidaunash agkan idaisachaintash”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Nuna tusag: “¿Wagkamek atumesh egiptunmaya aents aidau ditá apuji aidaujai antakchau asag, Israel aents aidaun jiija ishimain aig dutikchagtai, Apajuí suwimak susam waituinak jiija ishiakua numamtinush atagme? ");
INSERT INTO agr_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","“Duka nunitsuk makichik carreta yamajam najanatajum. Dutikajum atumdau jimag baka makichkish takamtikchatai yama petsaku aidau jukijum carretanum jigkajum ukuktajum, dutikakjum dita uchiji aidauk jujuki ukuktajum, dita wenak carretan japiki jukitnume. ");
INSERT INTO agr_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Dutikajum nuadui chicham umiktin egkeamu arca jukijum carretanum juinia yantamen egkeatajum. Dutikajum atum Apajuí tsagkugtugti tusajum anentag susatin orojai najanamu aidau nuna yantamen chimpiatajum. Dutikawagmin nunú baka wenak carretan japiki juki wetinme. ");
INSERT INTO agr_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","“Tujash diyaku atajum baka aidaush nuna japikish itug wegagtig. Tuja Israel aentsu batsamtai yaakat Bet-shemesh iina nugke nagkatkamunum awa nuwi chicham umiktin agagbau egkeamu arca nuni weakuig, duwi dekattaji dekas Apajuíyap suwimkanak amasaje tusaja. Untsu baka uchiji batsata nuni japiki shimakuig, Apajuí suwimkechuapi shiig jatap aikagmawa, titatji” tuidau. ");
INSERT INTO agr_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Tusa tiajam imatiksag betek umikajui. Nuadui jimag baka yama petsakun jukiag, daekai anawag carretanum jigkawajui. Untsu uchiji aidaunak baka egketai peejamunum egkeauwai. ");
INSERT INTO agr_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Dutikawag arcan jukiag, imum dakumka najanamu aidaun, katip dakumka najanamu aidaujai carretanum chimpiawajui. ");
INSERT INTO agr_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Dutikawagmatai baka aidau shimak carretan japiki juki, makichkish yaja wetsuk tutupit shinukmaikia yaakat Bet-shemesh wetainum wegajui. Nunik shimutai filisteo apuji aidaushkam pataetukag yaakat Bet-shemesh nagkatkamunum jegantajui. ");
INSERT INTO agr_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Tuja Israel aents aidauk nunú yaaktanum batsamin aidau yaakat jegattak waken ditá ajajin trigon juwak yujaidau. Nunik yujaidau niimsatakama arca carretanum egkeamun baka japiki inimaidaun wainkajui. Nunik wainak shiig aneasajui. ");
INSERT INTO agr_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","Nunú jimag baka carretan japiki we wenakua Josué Bet-shemesh pujujakua nuna ajajin jeganta nuwi ijuntsauwai. Nunikmatai carretan dakajag kaya shiig múun pujaunum nuwi patajag bakan mai maawag nuna nejen ashí apeenak Tuke Pujuun emematiajui. ");
INSERT INTO agr_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","Nuna dutikainatsaig Leví wegantu aidau arcanak jiiki jukiajui. Dutikainak tikich waji orojai najanamu aidaunashkam jiikiajui. Dutikawag nunú kaya shiig múun pujaunum patajajui. Tuja nunú tsawantin aents Bet-shemesh batsamin aidauk Tuke Pujuun emematuinak baka aidaun maawag nuna nejen ashí apeawajui. Dutikainak tikich kuntin aidaunashkam apeawajui. ");
INSERT INTO agr_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Tuja filisteo aidaun apuji cinco aajakua duka nuna dutikaidaun diisag ukuinak nunú tsawantaik yaakat Ecrón waketjauwai. ");
INSERT INTO agr_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Tuke Pujuu ii pegkegchau takasbaunum tsagkugtamjati tusa filisteo aidau imuman dakumak cinco orojai najadau aina nunak, dita yaaktaji aidau: Ashdod, Gaza, Ascalón, Gad, Ecrón aatus aajakua nuna daajin maki makichik najadau ainawai. ");
INSERT INTO agr_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Tuja katip dakumka orojai najadau aidauk filisteon yaaktaji aidau peeja apakbau, nuigtu peejachbaujai ijumjam cinco aajakua dutiksaik najanamu aajakui. Tuja chicham umiktin egketun arcan kaya shiig múun pujaunum ekentsaju aina duka yamaikish nunú kajak Josué ajaji yaakat Bet-shemesh aajakua nuwi awai. ");
INSERT INTO agr_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Untsu Israel aents yaakat Bet-shemesh batsamin aidau arca initken diisu aidaunak Apajuí ijinauwai. Ashí ijumjamak setenta aentsun ijinauwai. Imatika Tuke Pujuu ijinamtai, nuwiya aents aidauk kuashat buutiaju ainawai. ");
INSERT INTO agr_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Nuna wainkaju asag chichainak: “¿Tuke Pujuu Apajuí pegkejam ashí senchigtina nuna emtinish yaki nigkish ayamjumakainta? Dekas Apajuí kajegtamak ijipawai tikich yaaktanum awemami”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Nuna tuidau asag Israel aents aidau yaakat Quiriat-jearim batsamin aidaun chichaman aatus akatmamtug akuptukajui: “Filisteo aents aidau chicham umiktin egketun arcan jukiajua nunak awagkiag itawaje. ¡Dutikawaju asamtai nunú taajum jukitajum!” tusa tiajui. ");
INSERT INTO agr_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Tusa ujakajam Quiriat-jearimnumia aents aidau wejiag arcan juki itawajui. Dutikawag Abinadapa jee nainnum aajakua nuwi awayag, nuna kuitamkatnun Abinadapa uchiji Eleazaran etegkawag Tuke Pujuun segatiajui. ");
INSERT INTO agr_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Arcan jukiag Quiriat-jearimnum ejegawajua duwi nagkamas Israel aents aidauk veinte mijanai Tuke Pujuun segainak buutú batsatu, shiwag waitkagmaina nuna agkanmitkagmati tusag. ");
INSERT INTO agr_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Imaniagtai Samuel ditan chichajak: “Atum dekas Tuke Pujuu atumi anentaimijai emematkujum ima nigki umigkatag takugmek, ¡tikich nugkanmaya apajuímtai aina duka Astarté dakumka najanamua nujai utsagtajum! ¡Dutikajum ima Tuke Pujuu takagsatajum! ¡Nuniakjum ima nigki ememattajum! Dutikagmin nii filisteo waitkagmaina nunak agkanmitkagmawagtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Tusa tiajam Israel aents aidauk Baal dakumka najanamu aidaunak, Astarté dakumka najanamu aidaujaí ashí utsagkajui. Dutikawag ima Tuke Pujuunak emematuidau. ");
INSERT INTO agr_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Nunik batsatun Samuel ditan chichajak: “Ashí Israel aents aidautijum yaakat Mispá ijunjatajum. Nunikagmin wi atumin pachisan Tuke Pujuun segattajime”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Tusa tiajam nunú yaaktanum ashí ijunjajui. Nunikag wake besemag pujamujin iwainainak yumi shikikag Tuke Pujuun anentag suwinak ukajajui. Dutikawag yujumka yutsuk batsamas, Tuke Pujuu emtin pegkegchau takamsamujin etsegtumakajui. Tuja nunú nugkanum Samuel Israel aents aidaun utugchatjin epegtin wajasui. Nunik duwi nii takamujin nagkamauwai. ");
INSERT INTO agr_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Israel aents aidau Mispá ijunag batsatui tabaun filisteo aidau dekawajui. Nunikag apu aidau dita suntaji aidaun yajuakag shimutkajui. Nuna dekawag Israel aents aidauk senchi ishamaidau. ");
INSERT INTO agr_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Nuadui Samuelan chichajuinak: “¡Amek mijamtsuk Tuke Pujuu iina Apajuíji segaa pujuta, nii ayamjutpakti filisteo aidau amupakainum!” tuidau. ");
INSERT INTO agr_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Tusa imatiagtai Samuel uwig tsakat aishmagkun juki takamchaun patai ashí apeak Tuke Pujuun emematiuwai. Nuna dutika Tuke Pujuun segauwai Israel aents aidau kuitamkata tusa. Tusa segam Tuke Pujuu ayu tiuwai. ");
INSERT INTO agr_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Samuel uwig aishmag tsakatan maa nuna nejen ashí apeak pujai, filisteo aidauk Israel aents aidaun jetekagtatus jegajuawajui. Nuniagtai Tuke Pujuu ipamtan shiig senchi ajuntug uwakauwai. Dutikamtai Israel aents aidau filisteo aidaun depetuk amuku ainawai. ");
INSERT INTO agr_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Dutikawag tikich aidau pisagmatai, Mispánmaya juwakiag pataetuk shima shimakua, amaigkag mai mainakua yaakat Bet-car tutaya nuna tsumujin jegawajui. ");
INSERT INTO agr_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Tuja nunú ashí nagkaankamtai, Samuel makichik kaya múunta juki Mispá, Sen aatus awa nuna ejapeen apusauwai. Dutika nuna adaikauwai Eben-ézer. Nuna adayak chichaak: “Tuke Pujuuk yamaikish yaimpawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Dutika depetkamu asag filisteo aidauk ataktu awagkig Israel aents aidau nugken waintuag waitkaschau ainawai. Tuja Samuel iwaku pujusmataig, Apajuík filisteo aidaunak tuké ijinajakui. ");
INSERT INTO agr_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Nuadui Israel aentsu nugken filisteo aidau Ecrógnum nagkama Gatan nugke aajakua aatus jujukiu aina duka ataktu ditá nugke wajasui. Aatus Israel aents aidauk, filisteo aidau ditá nugken jujukiu aina nunak ataktu awagkiajui. Nuadui ditak amorreo aents aidaujaig maanitsuk agkan batsamajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Tuja Samuelak Israel aents aidaun utugchatjin epegtin aajakua nunisag pujus jakauwai. ");
INSERT INTO agr_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Nii pujus Israel aents aidau utugchatjin epegtak maki makichik mijadai yaakat Betel, Guilgal, Mispá aatus wekagajakui. ");
INSERT INTO agr_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Nunik wekae wekaekawa nii pujutaijin yaakat Ramá waketujakui. Nunik nuwi pujus Israel aents aidaunak yaijakui. Tuja nuigtushkam nunú yaaktanum Tuke Pujuu emematku kuntin maa patai apetain altaran najanauwai. ");
INSERT INTO agr_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Samuelak múuntuch wajasu asa, niina uchiji aidaun Israel aentsu apuji atinme tusa adaijauwai. ");
INSERT INTO agr_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Niina uchiji iwai Joel, tuja nuwi patatkau Abías aajakua nujai yaakat Beersheban apuji aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Tujash ditá apaji Samuel shiig takasua nujai betekak takaschajui. Tikich aidaunak wait anentsuk ima ditanunak anenmamajaku ainawai. Nunin asagmatai aents aidauk suwimkan sujusainum tuidau asag kuichkin akijaku ainawai. ");
INSERT INTO agr_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Nuniagtai Israel aentsu apuji múun aidau ashí ijunjag Samuel Ramá pujau asamtai, niijai chichastasag shimutkajui. ");
INSERT INTO agr_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Nunik jegawag chichajuinak: “Amek yamaik múuntuch wajasume. Tuja amina uchijum aidaushkam ame shiig takasuitam nujai betekak takainatsui. Nuniau asamtai ¡tikich aents aidau apugtin aina nujai betek iina apuji atin, ame adaikata!” tiajui. ");
INSERT INTO agr_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Tujash nunú Samuelan shiig awagmakchauwai. Nuadui nuna pachis nii Tuke Pujuu segauwai. ");
INSERT INTO agr_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Tusa segam Tuke Pujuu niina chichajak: “Dita wajina segapagtatua duka betek umigkata. Nunak amina dakitjamak tujamainatsui, ¡wi dita apuji atinun etegkeag duwi mina dakitjuinak tuinawai! ");
INSERT INTO agr_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Yamai amina tujamaina antsag wi ditan egiptunmayan jiijuitag duwi nagkamas yamaikish minak tuke tujutin ainawai. Aanidau asag wainka apajuímtai aidaun emematuinak minak kajimatjukiaje. ");
INSERT INTO agr_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","¡Nuadui amina segapaina duka umigkata! Untsu ditá apuji atata dusha ditajaish wajuk takastigki nunú shiig ujakta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Tusa tima nuna imatiksag Samuel ditan ujakui. ");
INSERT INTO agr_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Dutika chichajak: “Atumi apujum atin sumajum duka juna dutikattawai: Atumi uchijum aidaun yajuak carronum yujas maaniatin aidaun, caballonum entsamak yujas maaniatin aidaun, tuja niina kuitamkagtin aidaun, aatus akanjattawai. ");
INSERT INTO agr_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Dutikak nuigtushkam mil suntag aidaun apuji agtinun, nuigtu cincuenta suntag aidaun apuji agtinnashkam adaijattawai. Tuja tikich aidaunak ajaka ajakbau emaktinai. Untsu tikich aidauk nunú apu yuwatnun ajakan juu agtinai. Untsu tikich aidauk apu carroji maanitai aidaun najanin agtinai. ");
INSERT INTO agr_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","“Tuja atumi nawanjum aidaunashkam niina inake emaktinai. Dutikam kugkuin aidaun najanin, yujumka inajin, pagka najanin agtinai. ");
INSERT INTO agr_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Tuja nuigtushkam nugka pegkeg aidaun yajuak ashí niinu emaktatui. Dutikak uva ajakbau, olivo ajakbaujai atumdau shiig pegkeg aina nunashkam niinu emaktatui. Nuna yajuak niijai atueka takatai aidaun tinamkattawai. ");
INSERT INTO agr_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Tuja atumdau ajak juukbau aidaunashkam, uva juukbau aidaujai ujumak akanak juki niijai atueka takataiji aidaun, suntaja apuji aidaujai tinamtinai. ");
INSERT INTO agr_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Tuja nuigtushkam atumi tsakatke aishmag aidaun, nuwa aidaun, buey aidaun, burro aidaun atanjamag niinu emak takamtiktinai. ");
INSERT INTO agr_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Nuigtushkam atumi tagkujum aidaun akanak yajutjamkatnai. Atumshakam niina inake atatjume. ");
INSERT INTO agr_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Atum apu etegkamua nunú imatika waitkagmainakui chichagminish, Tuke Pujuuk antugtamkashtatui”, tusa ujakui. ");
INSERT INTO agr_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Tusa ujamashkam aents aidauk dekaskeapi tutsuk aimainak: “Iik duka puyatjatsji, ayatak apugtin atag tusa wakegaji. ");
INSERT INTO agr_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Tikich aents aidau apugtin aina nujai betek agmi taji. Nunú iina apuji etegkamu asa, iina nugken inamak iina shiwaaji aidaujai maaniamunmash nii chichamjutpakti, taji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Tusa tiagtai nuna ashí antujuk imatiksag Samuel Tuke Pujuun ujakui. ");
INSERT INTO agr_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Tusa ujakam Tuke Pujuu ayaak: “¡Dita sumamua duka ayu tusam apu adaitukta!” tiuwai. Tusa tima Samuel Israel aents aidaun chichajak: “¡Maki makichik atumi yaaktagmin waketjatajum!” tusa ishiakui. ");
INSERT INTO agr_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Makichik aents Quish daagtin Abiela uchiji, Zerora tijaji Benjamín wegantunmaya aajakui. Niina apajin apachjig Afíah uchiji Becorat aajakui. Quishak eme anentsa diitai aajakui. ");
INSERT INTO agr_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Niina uchiji datsa makichik yantsaptin shiijam Saúl daagtin aajakui. Tuja nii shiijam aajakua imanuk tikichik Israel aentsuk makichkish atsujakui, nuigtush niina esantijai betekak tikichik atsujakui. ");
INSERT INTO agr_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Tuja makichik tsawantai Quisha burroji aidau megkaejauwai. Nunikmatai niina uchiji Saúlan chichajak: “Makichik inak juki weme, burro megkaeja nunú egakta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Tusa tima Saúl inaka juki burro egak Efraígka nugken mujanum weuwai. Nunik jegauwai Salisá nugkanum; tujash burronak wainkachui. Nuwi nagkaemaki weuwai Saalim nugkanum, nunik Benjamígka nugkenishkam jegauwai, tujash burro megkaejaunak wainkachui. ");
INSERT INTO agr_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Nunik wainkacha ukuak Suf nugkanum jegaa inakan chichajak: “Wakitkimi mina apajuk burro megkaeja nuna nagkaesaus iina puyatjutpatai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Tusa tama nunú inak ayaak: “Juju yaakta juwi makichik aents Apajuí chichame etsejin pujawai, nunak nii tibau betek uminu asamtai, ashí aents aidau eme anentus diin ainawai. Nunú jegajua iniasmi, tuwig burrosh batsatua nuna ujapakchaintash”, tau. ");
INSERT INTO agr_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Tusa tama Saúl ayaak: “Ayu untsu wemi, ¿tujash nii iniakuish wajig susatji? Makichik pagkesh nii sumainuk shiig atsugtamji”, tau. ");
INSERT INTO agr_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Tusa tutai inak ayaak: “Wi takakjai plata piipichin, nunú Apajuí chichame etsejin suwaku dekajuami, burrosh itug batsatuaki nuna ujapakti”, tau. ");
INSERT INTO agr_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","(Initaikik makichik Israel aentskesh Apajuín inias dekatag takug: “Aents anentaimas ejenun iniasan dekatjai” tujaku ainawai. Nunak yamai ii profeta taji nuna taku tujaku ainawai.) ");
INSERT INTO agr_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Tusa tutai, ayu wemi tusa mai juwakiag yaaktanum Apajuí chichame etsejin pujamunum weajui. ");
INSERT INTO agr_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Nunik yaakat jegattak wekama nuwauch aidau yumi shikiktatus shimuidaun igkugkag iniinak: “¿Aents anentaimas dekamnush juwig puja?” tuidau. ");
INSERT INTO agr_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Tutai ditá ainak: “Ehe, tujash imau yaakta nagkaiki pujawai. Wamak wejitajum, kuntinu maa, Apajuí emematak nainnum apeatatus yamai yaaktanum wakame. ");
INSERT INTO agr_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Nuwi yujumka yuwatatus eke weatsaig wejitajum. Wagki Apajuí emematku kuntin maamua nuna nii jegaa Apajuí segamtai yuwami tusa aents aidau dakainawai. Nuadui wamak wetajum, nuniakjum igkugtatjume”, tiajui. ");
INSERT INTO agr_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Tusa tiajam ditashkam yaaktanum shiyakajui. Nunik jegattak wenai, Samuelchakam kuntinu maa apeatatus wegak dita shimamunmanini jiinki minaun wainkajui. ");
INSERT INTO agr_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Tuja Saúl kashinia duwi jegatin ai Tuke Pujuu Samuelan ujaak: ");
INSERT INTO agr_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Kashin, yamai etsa eketa juniai Benjamígka nugkenian makichik aentsun awetittajame, nunú mina aentsug Israel aents aina nuna apuji atin asamtai. Ame aceiteyai buuken nijaktatme. Nii mina aentsug Israel aents aidaun filisteo aidau waitkaina nuna ayamjuk agkanmitkattawai, wagki dita waituinak mina segatuinamunak wi antugkau asamtai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Nuadui Samuel Saúlan wainkamtai, Tuke Pujuu chichajak: “Wi makichik aentsu pachisan amina timajam duka anuwai. Anú mina aentsug Israel aents aina nuna apuji atatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Nuniai Saúl Samuelan jegantun chichajak: “¿Tuwi awa anentaimas dekamnu jeesh? nunú minash wait aneasam inaktugsata”, tau. ");
INSERT INTO agr_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Tusa tama nii ayaak: “Witjai anentaimas dekamnunuk. Wegajai Apajuí jee pegkegmanum, awi wijai yujumak yuwata. Tuja ame waji dekaatag tusa wakegame nunak kashin kashikmasan ujaktagme, dutikamtai duwi wakitkita. ");
INSERT INTO agr_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Tuja burrojum megkagag kampatum tsawan wega duka puyatjukaipa, nunak wainkaje. Tuja nuigtushkam Israel aents aidaun nugken waji pegkeg ayá duka ashí aminu nuigtu amina pataiminujai atatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Tusa tama Saúl ayaak: “¡Tujash wika tikich Israel aents wegantu kuashat aina imanchau Benjamín wegantunmaya ujumchik aina nuwiyayaitjai! Nuigtushkam Benjamín wegantu aina nunú ashí ijumjamash mina pataajuk tiki wainkauch ainawai. ¿Nunin aish wagka minash dusha tujutme?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Tusa timatai, Samuel Saúlan niina inakejai juki yujumak yuwaku ijuntainum awayauwai. Dutika treinta aents eme anentsa diitai aidau pekagbaun nagkaesau dekas shiig pegkegnum ekentsauwai. ");
INSERT INTO agr_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Dutika Samuel yujumka inagnun chichajak: “Wi neje amaakun juka akanka ukukta timajam nunú itaata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Tusa tima ayu tusa kuntinu bakuin juki Samuelan ekettsauwai. Dutikamtai Samuel Saúlan chichajak: “Wi aents aidaun ipau asan, ditajai ijunag yuwati tusan anna akankan amina ukugkimjame, anú yuwata”, tiuwai. Tusa tima nunú tsawanta duwi Saúl Samueljai jimagtuk yuwawajui. ");
INSERT INTO agr_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Nunikag Apajuí jee pegkegmanum batsatu juwakiag, Samuela jeen yaakat jegamtai, Saúl kanagtinun jega tuntupen pegakan umigkajui. ");
INSERT INTO agr_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Dutikam nuwi kanajui. Nunikmatai kashinia duwi Samuel Saúl yakí pujaun untsuka chichajak: “Nantakim wakitkita”, tau. Tusa tima nantaki wetatus uminas Samueljai agá jiinkiajui. ");
INSERT INTO agr_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Nunikag yaakta ukukiag Samuel Saúlan chichajak: “Inakem amejai wekaga nunú emtikam awemata. Untsu amek machik ukuunum juwakta, nunikamin Apajuí tujutma nuna ujaktagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Samuel aceite juki Saúla buuken nijakui. Dutika yapinum kugkuak aatus tiuwai: “Tuke Pujuu amina Israel aents aidaun apuji ati tusa yamai etegtamae. Ame pujusam inamkum shiwag waitkaina nunú agkanmitkattame. Tuja amina Apajuí etegtama duka juju aidau wainkum dekaskeapi titatme. ");
INSERT INTO agr_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Tuja yamai weakum Benjamígka nugken yaakat Selsah Raquel ukusbaunum jegantatak, jimag aents minidau igkugtatme. Nunú inimpak: ‘¿Burro megkaejamtai egaku wemaum dusha wainkaumek? Amina apak burronak puyatjichmae, amina ima senchi puyatjupame, nuniak mina uchijush inakjaish wajukawagmaki tusa dekatatus iniimak wekaemae’, tujamiagtatui. ");
INSERT INTO agr_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","“Nunú nagkaiki weakum, numi encina tutai yaakat Tabornum waja nuwi jegakum, kampatum aentsua nuwiya, makichkia nunú kampatum chivon jukimtai, tikichik kampatum pagkan juki, tuja tikich duwap apagbaunum vino aimkamun jukiag Apajuín ememattatus yaakat Betelnum shimuidau igkugtatme. ");
INSERT INTO agr_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Dutikawagmin kumpamjamawag jimag pagkan amainakuig dakittsuk jukita. ");
INSERT INTO agr_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","“Nunika wea weakum, yaakat Guibeá Apajuínu tutainum filisteo suntag aidau batsamtai awa nuwi jegattame. Nunika jegakmam wainkattame aents kantamin aidau: pandero aidaun, arpa aidaun awatkiag, pigkui aidaun umpukmaikia, nuna ukujin profeta aidau Apajuí jee pegkegma nuwiya jiinjag Apajuí tibaun etsegkamaikia akagaidau wainkattame. ");
INSERT INTO agr_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","“Nuniamin Tuke Pujuu Wakani amina wainjamattawai, nuniakui profeta chichagtata nujai betek ameshkam chichattame. Duwi nagkamas amina pujutjumek yapajinattawai. ");
INSERT INTO agr_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Tuja nunú ashí uminkamtai, ame waji takasta tame nunú dutikata. Apajuí aminak yaimpaktatui. ");
INSERT INTO agr_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","“Tuja amek emkam yaakat Guilgal wetá. Nunikam awi siete tsawan dakagmin wi tattajai. Nunikan Apajuí daajin kuntinu maan nuna nejen ashí apeakun, nuigtu agkan pujutan Apajuí amastí tusan niina anentag susattajai. Dutikan duwi ujaktatjame ame wajuk takastatme nuna”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Tusa tima nunú tsawantaik Samuel tibauk imanisag uminkauwai. Nuadui Saúl Samuelan kumpama ukuak weuwai. Aatus Apajuí Saúla pujutjin yapagtuauwai. ");
INSERT INTO agr_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Nunik Saúl niina inakejai yaakat Guibeá jegawajui. Nunik jegattaman profeta aidau untsumkiag jiinjajui Saúlan igkuinak. Nuninai Apajuí Wakani Saúlan egkemtujui. Dutikam niishkam profeta aidaujai betek wajasui. ");
INSERT INTO agr_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Nuniagtai yaunchuk Saúla wainin aidau pempeentunikiag tudayinak: “¿Quisha uchijish wagka aniawa? ¿Tuja au profeta aina dusha tuwiya jiinjae? ¡Tsuwah, Saúlash profeta wajasu diyajai!” tuidau. ");
INSERT INTO agr_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Tiagtai nuwiya makichik chichaak: “¿Yana jintintai ainawa aush?” tau. Nuna aatus tiaju asagmatai, nuwiya chicham jiinak: “¡Saúlchakam profeta wajase!” tibau juwakui. ");
INSERT INTO agr_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Nuna nunik nagkaanak Saúl niina inakejai nuwi nagkaemaki, we wenakua Apajuí emematku kuntin maa apetai nain aajakua nuwi wakauwai. ");
INSERT INTO agr_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Nunikmatai niina apaji yachi Saúlan niina inakejai iniak: “¿Tuu wemaijume?” tau. Tusa iniam Saúl ayaak: “Burro megkaejamtai egaku wemaiji. Nunika wainkacha Samuel pujamunum wemaiji”, tau. ");
INSERT INTO agr_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Tusa tama Saúla apaji yachi niina ayaak: “¿Samuelash wajinjutpame? nunú minash wait aneasam ujatkata”, tau. ");
INSERT INTO agr_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Tutai Saúl niina apaji yachin ayaak: “Burro aidau megkaejaunak wainkaje, tusa ujapakmae”, tiuwai. Tujash Samuel niina chichajak: “Ame Israel aents aidaun apuji atatme”, tusa tibaunak ujakchauwai. ");
INSERT INTO agr_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Duwi pujus Samuel Israel aents aidaun untsuka, yaakat Mispá ijumjauwai, Tuke Pujuu emematiagmi tusa. ");
INSERT INTO agr_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Dutika ijumag chichajak: “Tuke Pujuu Israel aents aidaun Apajuíjiya nunú chichaak: ‘Atum Israel aents aidautijum Egipto nugkanum batsamsajum waitkam batsatutigmin wi jiijan agkanmitkawabiajime. ");
INSERT INTO agr_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Tuja wi atumi Apajuíjum asan yayajim duka dekayaitkujum, mina idaitakjum iish apugtin amí tusajum sumagme. Tujash nunak puyatjatsjai. Atum sumajum nunak betek umiktatjai, nuadui mina emtijui maki makichik wegantu ainajum duka ashí ijunjatajum’ tusa Tuke Pujuu tujamui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Tusa tiajam maki makichik wegantu aidau ashí ijunjauwai. Nunikmatai Samuel kaya juki yana daajig jiinkiti tusa diyam Benjamín wegantunmaya jiinkiuwai. ");
INSERT INTO agr_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Nunikmatai Benjamígkan patayi aina nuwiyash yana daajig jiinkit tusa dekapsauwai. Dutika diyam Matrí patayinia jiinkiuwai. Nunikmatai ataktu awagkiag dekapsajui, dutikam Saúla daaji jiinkiuwai. Nunikmatai Saúlan wainkatakama emegkakajui. ");
INSERT INTO agr_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Nunikmatai Tuke Pujuun iniasajui Saúlash juwig puja tusa. Tusa iniam Tuke Pujuu ayaak: “Waji ijumjamu aina nuwi uumak pujawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Tusa timatai uumak pujaun jukitatus shimutkajui. Dutika jukim Israel aents aidau ijunag batsatbaunum wegajui. Nunik jegamtai diikma tikich niina nagkaekauk esagmak atsaun wainkajui. ");
INSERT INTO agr_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Nunikmatai Samuel Israel aents aidaun ashí ijumag chichajak: “¡Tuke Pujuu juna atumi apuji atinun etegka nunú ashí diistajum! ¡Niijai betek amainuk tikichik Israel aentsuk atsawai!” tiuwai. Tusa timatai dita shiig aneas aimainak: “¡Nii iina apujig ati tusa wakegaji!” tuidau. ");
INSERT INTO agr_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Tusa tiagmatai, Samuel apu takatjish wajuk atatua nuna pachis Israel aents aidaun ujakui. Nuna ujaka papiinum agag juki Apajuí jee pegkegmanum awayauwai. Dutika nuadui ashí aents aidaun jemin waketjatajum tusa ishiakui. ");
INSERT INTO agr_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Dutikamtai Saúlchakam yaakat Guibeánum niina jeen wakitkiuwai. Nunik wetai Apajuí niina uyuntsatnun ujumak aents wajiu aidaun etegtujui. ");
INSERT INTO agr_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Nunik wematai aents pegkegchau aidau chichaman patatuinak: “¡Aush annush iinash ayamjutpaktatuak!”, tusa tuidau asag apu wajasmataish makichik wajinakesh susachajui. Dutikamashkam Saúlak nuna chichamjutan dakitak idaisauwai. ");
INSERT INTO agr_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Galaad nugkanum yaakat Jabes aajakua nuna jetektatus amonita aents aidaun apuji Nahas aajakua nunú shiig uminas suntaja yajuak weuwai. Nuna dekawag nuwiya aents aidau Nahasan chichama akuptuinak: “Jutijaig maaniawaipa, ayatak chicham umikmi, nunika amina inakem agmi taji” tuidau. ");
INSERT INTO agr_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Tusa tiagmatai Nahas ditan ayaak: “Ayu, untsu chicham umikmi takugminig, wi atumi jii untsuja nuna ashí ukuitjatjime. Dutika ai atum Israel aents aidautijum dushiktai datsan juwakminjum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Tusa timatai Jabesnumia apu aidau chichainak: “Kame siete tsawan sukagtusta, tikich Israel aents aidau batsata nunú chicham akuptuka dekanati. Untsu iina yaimpamain atsakuig, ame tame duke ati”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Nuna tusa chichama etsejin aidaun yaakat Guibeánum Saúl pujujakua nuwi ishiakui. Dutikam jegawag Nahas tibaunak imatiksag nuwiya aents aidaun ujakui. Nuna antukag kajekag buutiajui. ");
INSERT INTO agr_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Nuninai Saúl niina ajajinia buey aidaun yajuak minikma buutuidaun antuk iniimak: “¿Wagka imatuinawa? ¿Wagka buutuinawa?” Tutai: “Jabesnumia aents aidau kaunawag chichama etsegkamtai nuna antukag buutuinawai”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Tiagtai Saúl nuna antak wajai, Apajuí Wakani niina egkemtujui, dutikam shiig senchi kajekui. ");
INSERT INTO agr_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Nunik jimag bueyen achika juki tsupig mauwai. Dutika nunú aents yujaun tinamak Israel aents aidau batsatbaunum ashí ishiakui. Dutika ishimak juju etsegkatajum tusa chichama etsejin aidaun akateak: “Aents wijai, tuja Samueljai ijunag maanitan dakituidauk, tagkuji buey aidauk jutiksaik tsupija ijitam agtinme”, tiuwai. Tusa timatai nuna antukag Israel aents aidauk shiig senchi ishamkajui. Nuninak Saúljai atuniktatus makichik aents amaina numamtuk jiinjajui. ");
INSERT INTO agr_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Nunik shiyakag ijunjajui yaakat Bézec. Nunikmatai Saúl dekapajui, dutikam Israel aents aidauk trescientos mil aents ijunjauwai. Tuja Judá wegantunmaya aidau treinta mil aents ijunjauwai. ");
INSERT INTO agr_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Nunik ijunjamtai Saúl chichama etsejin aidaun chichajak: “Waketjajum Jabesnumia aents aidau ujaktajum, kashin etsa tajimai agkanmitkawagtatjai”, tiuwai. Tusa tima jegawag Jabesnumia aents aidaun nuna ashí ujakajui. Nuna antukag shiig aneasajui. ");
INSERT INTO agr_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Nunikag Nahas ujaktajum tusa chichama etsejin aidaun akuptuinak: “Kashin ame wakegamu umikta tusa minittaji”, tiajui. ");
INSERT INTO agr_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Tuja kashinia duwi Saúl niina suntaji aidaun akanag kampatum ijumjauwai. Dutika eke etsa jiintsaig shimutuk shiwag amonita aents aidau batsatbaunum jegawajui. Nunikag mai mainakua etsan tajipiajui. Dutika amuam iwaku juwaku aidauk maki makichik pisaja megkaejauwai. ");
INSERT INTO agr_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Nunikagmatai nuwi aents yujau aidau Samuelan chichajuinak: “¡Israel aents aidau Saúlak iina apujig amaitsui tusa tiagma duka kajegmi!” tiajui. Tuidau asag, nunú aents aidauk idaisatajum ii kajegmi tusa sumaidau. ");
INSERT INTO agr_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Tusa tiagtai Saúl chichaak: “Yamai tsawanta duik makichik aentskesh jakashtatui, wagki Tuke Pujuu yamai Israel aents aidaun ayamjuku asamtai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Tusa timatai Samuel ashí aents aidaun chichajak: “Yaakat Guilgalnum shiyakagmi, awi Saúl apu wajas inabaun nagkamati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Timatai aents aidauk ashí yaakat Guilgal shiyakajui. Nuwi jegawag Apajuí emtin Saúlan apu adaikajui, dutika chichainak: “¡Saúlai iina apujig!” tuidau. Nuna ashí umikag nuadui agkan maanitsuk pujustinun Tuke Pujuu amastí tusag kuntinu maa apeenak Tuke Pujuun emamatiajui. Nuadui Saúl Israel aents aidaujai ashí ijunag shiig aneasajui. ");
INSERT INTO agr_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Nunú nagkaemakmatai Samuel ashí Israel aents aidau antamunum chichaak: “Antuktajum nijah, wika atum aidautijum segatbaunak ashí umigkajime. Dutikau asan atumi apujinash adaitukjime. ");
INSERT INTO agr_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Nuadui yamai nagkamsag juju apu atuminig inamjattawai. Tuja wika yamaik múuntuch intashi puju wajasjai. Atumek dekagme mina uchig aidau atumjai batsatainawai. “Wika datsauch asanuk atumi yayaakun taka takakuan yamai tsawantan ejejai. ");
INSERT INTO agr_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Nuadui wisha wajuk atumjaish takasja nunú namputchawame wi atumdau buey aidaunakesh, nuniachkunush atumi burrojum aidaunakesh atankimu akugmek, tuja tikichnakesh waitkasu akuig tujuttajum. Tuja chichama iwagtujati tusagmekesh akigkau akugmeshkam, yamai Tuke Pujuu emtin, juju apu Apajuí etegkamua nuna emtinchakam tujuttajum. Nunú tujutiagmin nuna akikmaktajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Tusa tutai dita aimainak: “Amek makichkish kasagkagtukchauwaitme, nuigtush tsanujatjachuitme, nuigtush chichama iwagtugtagme tusamkesh makichkish kuichkik segajatchauwaitme”, tiajui. ");
INSERT INTO agr_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Tusa tiagtai Samuel chichaak: “Tuke Pujuu emtinish, tuja apu aina nuna emtinish mina utugchatjuk makichkish ejetugchaugme”, tiuwai. Tusa tutai ditá ainak: “Ame tame duka dekaske”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Tusa tiagmatai Samuel Israel aents aidaun chichajak: “Atumi apachjum aidau Egipto nugkanum waitkam batsatun, jiija yajuak, juju nugka juwi ikaunmati tusa Tuke Pujuu Moisésan Aarógjai awetiuwai. ");
INSERT INTO agr_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Nuadui umintsatajum, wagki wi yamai atumin iwaintuktatjime, atum aidautijum ima Tuke Pujuuwaig kajintsa anentaimtsuk, apugtin amí tusa sumakjum pegkegchau takamsaujum nuna. Tuja atumi apachjum aajaku aina nuna uwemtikatatus Apajuí dutikauwa nuna yamai dekamtikattajime. ");
INSERT INTO agr_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","“Atumi apachjum aajaku aina nunú Jacob niina uchiji wegantu aidaujai Egipto nugkanum shiyakag batsatun, nuwiya aents waitkasu ainawai. Imatika waitkainam Tuke Pujuu yaimpakti tusag segajaku ainawai. Nuna antujuk Tuke Pujuu Moisésan Aarógjai awetiuwai. Dutikam iina apachji aidaun jiija yajuak juju nugka juwi ikaunmauwai. ");
INSERT INTO agr_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","“Dutika ikaunmam batsamsash ima Tuke Pujuu dita Apajuíjinak umigtsuk kajimatkiu ainawai. Nunidau asagmatai dita shiwaaji aidau depetkatnume tusa Tuke Pujuu timatai, Hasornumia suntag aidaun apuji Sísara aajakua nunú niina suntaji aidaujai depetuk amukajui. Tuja nuigtushkam filisteo aidau, moabnumia aents aidau aatus ditanak depetuk amuku ainawai. ");
INSERT INTO agr_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","“Dutika depetkam wajantag nuadui Apajuín adeajag segainak: ‘Dekas iik Baal dakumkamu Astartéjai emematku tunamagji’, tiu ainawai. Nuna tusag iina shiwaaji waitkagmaina nuna ayamjutpakti tusa Tuke Pujuun segainak: ‘Ame ayamkagtukaminig, ima amek emematiagmi taji’ tiajui. ");
INSERT INTO agr_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","“Nuna antujuk Tuke Pujuu Jerubaalan Barakan, Jefté aajakua nuna, tuja minashkam aatus awetugmauwai, atumin shiwaajum aidau waitkagmaina nuna ayamjutpakti tusa. Aatus iina apachji aajaku aina duka dita ayamjukam shiig batsamsau ainawai. Tuja yamai atumshakam kuashat tsawantai atumi shiwaajum waitkascham shiig batsatjume. ");
INSERT INTO agr_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","“Tujash atumek amonita aidaun apuji Nahas aajakua nunú jetepaktag tabau antukjum, iish apugtin amí, nunú iinash yaimpakti tusajum, Tuke Pujuu atumi Apajuíjiya nunú dekayaitkujum sumakmaijume. ");
INSERT INTO agr_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","“Nuadui atum apu sumakbaujum duka jujuwai. Juna Tuke Pujuu atum sumakbaun amasaje. ");
INSERT INTO agr_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Nuadui atumek atumi apujijai yamai juju umiktatjume: Tuke Pujuu eme anentsajum nigki ememattajum, dutikakjum nii tabau umiktajum. Nii dutikata tujabau takastajum, tuja nii wakegamu umigkujum pujustajum. Nunú dutikakjum shiig pujustatjume. ");
INSERT INTO agr_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Untsu nii umiktajum tabau umitsuk idaijuminig, Tuke Pujuu atumnak atumi apugmijai suwimkan amastatjume. ");
INSERT INTO agr_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","“Nuniau asamtai titu batsamsatajum, Tuke Pujuu atum aidautigmin wainchatai aidaun iwaintugmakagtata nunú wainkamnujum. ");
INSERT INTO agr_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Tuja yamai tsawan aina duka trigo juut asamtai, yumi yutatsu nunú wainjume. Nunik aun wi Tuke Pujuu sega ai, nii ipa ipamtajai yumin yutumtijattawai. Dutikamtai atum aidautijum apu sumakujum duka Tuke Pujuu diismak pegkegchau dutikaujum nunú dekattagme”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Nuna tusa inagnamuik Samuel Tuke Pujuu segauwai. Dutikamuik Tuke Pujuu ipamtan yumijai ajunjauwai. Dutikamtai ashí aents aidauk Tuke Pujuun Samueljai ishamkajui. ");
INSERT INTO agr_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Nuadui aents aidau Samuelan chichajuinak: “Amina aentsjum aidauti pachijattsam Tuke Pujuu amina Apajuíjum segata, wagki jinawaig tusa ishamaji. Iik apu sumá yujasa nuni senchi iina tudauji ikauntumakji”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Imatiagtai Samuel ditan chichajak: “Ishamkaigpa, Tuke Pujuuk mantamachagtatui. Dekaske atum pegkegchau takasujum duka. Tujash nuniku akugmesh Tuke Pujuuwaig kanakaigpa. Duka nunitsuk ima nigki atumi anentaimijai ememattajum. ");
INSERT INTO agr_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Tuja tikich apajuímtai aina nunú atumi ayamjutpak uwemtijamainchau aina nuninuk yujagsaigpa. Duka wainak ainawai. ");
INSERT INTO agr_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","“Atum aidautijum ima nigki eme anentsajum emematjuminig atumnakek idaitamsashtatui, wagki niig mina aentsug atinme tusa etegtamjau asa. ");
INSERT INTO agr_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","“Untsu wika atumnak mijattsuk Tuke Pujuun segattatjime, nuna dutikashkunuk pegkegchaun takakun nunimainaitjai. Nuigtushkam aents pegkeg atinme tusan jintintuattajime. Duka juju ainawai: ");
INSERT INTO agr_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","“Atumek ima Tuke Pujuuwa duke ajantusjum diitajum, dutikakjum nii umigkujum dekaskenum atumi anentaimijai ememattajum. Tuja Apajuí atumi yaimpak kuashat dutikauwa nunú aneaku atajum. ");
INSERT INTO agr_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Untsu pegkegchau takat aidau idaitsuk duke pujugkugmek, atumek atumi apugmijaí ijina utsam atatjume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Saúl apu wajas Israel aents aidaunum inabaun nagkamauwa nunak tsakaja pujus nagkamauwai. Nunik apu wajas inamak ujumak mijan pujau, ");
INSERT INTO agr_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","makichik tsawantai tres mil suntag Israel aents aidaun etegjauwai. Nuwiya dos mil suntag niijai Betelnum jegattak mujanum yaakat Micmas juwakajui. Nuninai tikich aidauk Benjamígka nugken yaakat Guibeá Jonatágjai juwakajui. Untsu tikich aidaunak jemin waketjatajum tusa Saúl ishiakui. ");
INSERT INTO agr_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Tuja suntag filisteo aidau ditá nugken Guibeánum batsatunak, Jonatán niina suntajijai amukui. Dutika amuke tabaun tikich filisteo aidau dekawajui. Tuja Saúlchakam dekauwai. Nunik inamjauwai Israel aents aina nuna nugken ashí uwija kachujin umpuagtinme, nuna antukag umintsagmatai maaniawagmi tusa. ");
INSERT INTO agr_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Tuja Guibeánum suntag batsatunak Saúl amuke, dutikamtai filisteo aidau Israel aents aidaun kajegkaje tabaun ashí Israel aents aidau dekawajui. Nuadui suntag aidau yaakat Guilgalnum Saúljai ijunjajui. ");
INSERT INTO agr_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Nuninai filisteo aidaushkam Israel aents aidaujai maaniawagtatus ijunjajui. Tuja filisteo aidaunuk treinta mil carro maanitai aidau, seis mil suntag caballonum maanitan yacha aidau, nuigtu dawenum yujas maanitan yacha aidau aatus nayantsa kamatkajijai betek tumain aajakui. Imaanik ijunag shiyakag yaakat Bet-avén jegawag, nujai niinis yaakat Micmas aakmajag batsamsajui. ");
INSERT INTO agr_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Ibau kuashat jetenam ishamainak Israel aents aidauk waa aidaunum, japagau initak aidaunum, kaya pagkaku aidaunum, nugka taimu aidaunum, yumigmat taimu aidaunum uumjajui. ");
INSERT INTO agr_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Nuninai nuigtushkam kuashat aents pisajag, Jordágkan katitkag Gad nugkanum, tuja Galaad nugkanmashkam shiyakajui. Untsu Saúlak yaakat Guilgalnum juwakui. Nunikmatai suntag niijai yujauk ishamainak senchi kujaidau. ");
INSERT INTO agr_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Tuja Saúlak nuwi pujus siete tsawan Samuelan dakasui, imaan tsawan dakagsattame tibau asa. Samuel tachatai daka daka aents aidauk wakettan nagkamaidau. ");
INSERT INTO agr_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Nuniagtai Saúl chichaak: “Apajuí daajin kuntin maa nuna neje ashí apeatnuwe nunú, tuja agkan pujutan Apajuí amastí tusa anentag susatnuwe nujai itagtuatajum”, tiuwai. Tusa timatai juki ejetuam nii nuna maa apeak Apajuín emematiuwai. ");
INSERT INTO agr_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Nuna dutika inagnai Samuel tauwai. Nunik taamtai Saúl jiintukiuwai igkug kumpamatatus. ");
INSERT INTO agr_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Tujash Samuelak eke Saúlan kumpamtsuk chichajak: “¿Wagka amesh dutikata tichamaitkumesh, kuntin maamesh apeaume?” tau. Tusa tama Saúl ayaak: “Ame taatin tsawan nagkaemaki wetai aents aidau waketuinakui, tuja nuigtushkam filisteo aidau Micmas jutijai maaniatatus batsatu asamtai, ");
INSERT INTO agr_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","eke wi Tuke Pujuun segan umintsaig, filisteo aidau kauna jetepakchajaintash tusan, kuntinu maan nuna nejen ashí apeakun Tuke Pujuu ememattajai tusan jutikajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Tusa timatai Samuel ayaak: “Ame aikaum duka makichkish dutikmainchau aikaume. ¡Tuke Pujuu amina Apajuíjum dutikata tujamauwa nunú betek umikaminig, Israel aents aidaun apuji tuke atin ati tusa Tuke Pujuu tujamain awajtamkae! ");
INSERT INTO agr_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Tujash yamaik ame apu wajasa inabaugmek tuke achattawai. Yamaik Tuke Pujuu nii wakegamun betek umiaun makichik etegkattawai. Dutika Israel aents aidaun apuji ati tusa adaikattawai, wagki amek Tuke Pujuu tujabau umigkachume”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Nuna tusa ukuak Guilgal pujau jiinki weuwai. Nunikmatai suntag nuwi juwakaju aidauk Saúljai shiyakajui, filisteo aidaujai igkunia maaniawagtatus. Guilgalnumia shiyakag Benjamígka nugken yaakat Guibeá jegawajui. Nunik jegawag nuwi Saúl seiscientos suntajan ijumjauwai. ");
INSERT INTO agr_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Dutika Saúlak niina uchiji Jonatágjai, nuigtu suntag niijai yujau aidaujai aatus filisteo aidauk Micmas batsatai, ditak yaakaat Guibeánum Benjamígka nugken juwakajui. ");
INSERT INTO agr_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Nuwi batsatai filisteo aents maanitan yacha emak shimin kampatum akanka ijumjamu aidau, dita batsatbaunmaya makichik eemak wegak tikich aidaun yajuakui. Nunik yaakat Ofránmanini Shual aajakua nuna nugkeen shiyakajui. ");
INSERT INTO agr_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","Untsu tikich aidauk yaakat Bet-horón aajakua nuni shiyakajui. Nuniagtai kampatuma nunú Seboíma mujajin uwegshunum shiyakajui. ");
INSERT INTO agr_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Tuja Israel aents aidauk makichik aentskesh nagki aidaun jiju hierrojai najannuk atsujakui, wagki filisteo aidau dekainayatak jintintuachbau asag. Nunak jintintuachajui wagki unuimajag puyajan, nagkin aatus najankag jutijai maaniawainum tuidau asag. ");
INSERT INTO agr_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Nuadui Israel aents aidauk kuchii, jacha, azadón, pico aidau etsakmainkesh atsugbau asag filisteo aents aidaun segajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Dutika segam nunú etsakeamunum jimag kuichkin akikmajaku ainawai. Tuja jacha etsakeamunmak, jiju etsaktai aguijada aidau iwagbaujai makichik kuichkin segajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Nuadui suntag aidau Saúlan Jonatágjai uyunajaku aina duka puyaajinchau, nagkigtinchau aajaku ainawai. Untsu ima Saúlak Jonatágjai takaku aajaku ainawai. ");
INSERT INTO agr_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Nuninai filisteo aidauk Israel aents aidaun yaakat Micmasnumanini shimutkajui. ");
INSERT INTO agr_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Makichik tsawantai Saúla uchiji Jonatán nii maaniaku jutaijin niina kumpaji takujus wekagajakua nuna chichajak: “Namak katitka suntag filisteo aidau batsata nunú jetekmi”, tiuwai. Tusa weakush niina apajinak ujakchauwai. ");
INSERT INTO agr_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Niina apaji Saúlak Gabaanum yaakat Migrón aajakua nuwi munchi ayaunum nuna wakentin niina suntaji seiscientos aidaujai batsatai nunikui. ");
INSERT INTO agr_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Tuja makichik sacerdote yaakat Silónum pujus Tuke Pujuun umijujakua dushakam Saúljai pujau. Nuna daajig Ahías aajakui. Nunú sacerdote nugkutai lino apagbau efod tutain takujakui. Tuja Ahíasak Icabotan yachi Ahitub aajakua nuna uchiji aajakui. Untsu niina apachjig Elí uchiji Finees aajakui. Tikich Israel aents aidaushkam Jonatán niina kumpajijai webaunak dekachaju ainawai. ");
INSERT INTO agr_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Jonatágkak niina kumpajijai filisteo aidau batsatbaunum jegatatus wedau. Dita shimamunmanini jimag kaya múun Bosés daagtin Senéjai aajakui. ");
INSERT INTO agr_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","Tikichia nunú nujinmanini yaakat Micmasjai niniaku aajakui. Untsu tikichia nunú tsumunmanini yaakat Guibeájai niniaku aajakui. ");
INSERT INTO agr_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Nuwi wesag Jonatán niina kumpajin, chichajak: “Weajai au nagkaiki atú amainia awi aents pegkegchaun takau aidau batsata nunú jegajua Tuke Pujuu yaimpasmatai maaniami, wagki kuashat akuish, nuniachkuish ujumchik akuish, iik Tuke Pujuu yaimpasmatai depetmainaitji”, tau. ");
INSERT INTO agr_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Tusa tutai niina kumpaji ayaak: “Ayu, ame anentaimam duka betek umikta. Wika ame tujutbaun umiktasa wekaejai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Timatai Jonatán niina chichajak: “Weajai atú amainia awi filisteo aidau batsata nunú jegajua wantintukmi. ");
INSERT INTO agr_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Dutika wantintuka ajin dita chichainak: ‘Anuig wajastajum, nuniagmin ii kaunawagmi’ tuinakuig wejutsuk nuwig wajasa dakasmi. ");
INSERT INTO agr_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Untsu ‘wakatajum’ tujamkuig wajukmi. Nuni dekaattaji Tuke Pujuu ditan depetkatnume tusa tujabau”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Nuadui mai juwakiag filisteo aidau batsatbaunum jegantag wantintukajui. Nuniagtai ditan wainak chichainak: “Nijah, au hebreo aents aidau waanum uumak batsatu jiinjajana”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Tusa tuinai aents aidau Jonatán niina kumpajijai wajattaman untsuinak: “¡Juwi wakatajum, nunikagmin wajuk maanitaimpaita nuna jintintuatjime!”, tuidau. Tusa tiagtai Jonatán niina kumpajin chichajak: “Wi emka weakui mina ukujui minita, auk Tuke Pujuu iina amase, depetuk amuktinme tusa”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Nuna tusa Jonatágkak nunú kayanum achimki, achimki, niina kumpajijai mai wakauwai. Nunik waka suntag filisteo aidaunak achika nagki nagkima ajiau. Dutiktai niina kumpaji patagas wegak nuna iju iju kajeau. ");
INSERT INTO agr_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Dutika yama nagkamchak Jonatán niina kumpajijai jetekajua nuaduik juu tamawaik veinte aentsun kajegkajui. ");
INSERT INTO agr_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Nuna antukag suntag filisteo aidau aaknum batsatuk tuja suntag ujumak maanitan yacha eemak shimin aidaushkam senchi ishamkajui. Tuja nuigtushkam nugka senchi uujak filisteo aidaunak shiig senchi uwakauwai. ");
INSERT INTO agr_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Nuna ishamkag wakan wajasag pisainak pachimdagaidau. Imanidaun Saúla suntaji yaakta kuitamin aidau Benjamígka nugken Guibeánum pujuidau wainkajui. ");
INSERT INTO agr_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Imaniagtai suntag niijai yujaun Saúl chichajak: “Ashí diistajum betekash batsatag nunú dekaami”, tau. Tusa tiajam, ashí diikma Jonatán niina kumpajijai megkaekauwai. ");
INSERT INTO agr_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Nunikmatai Saúl Ahíasan chichajak: “Chicham umiktinun Apajuí amasbau egketa nunú arca itaata”, tiuwai. Nunak tiuwai wagki chicham umiktinuk tikich yantamnum au asamtai. ");
INSERT INTO agr_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Tusa Saúl sacerdote Ahíasjai eke chichaak wajai, filisteo aidauk aan nagkaemas waugtukag pachimdagainak senchi chajuatuinau. Imaniagtai Saúl Ahíasan chichajak: “Dekas arcak itawaipa”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Tusa ukuak Saúlak niina suntaji aidaujai ijunjauwai filisteo aidaujai maaniatatus. Nunik diikma filisteo aidauk shiwagtsukaita tusa dita ditak pempeentunikiag maanidaun wainkauwai. ");
INSERT INTO agr_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Nuniagtai untsu hebreo aidau yaunchuk nagkamas filisteo inatai batsamin aidaushkam Israel aents aidaujai maaniatajum tima uminas batsatiatak, jiinag ukukiag Israel aents aidau Saúljai, Jonatágjai aatus ijunag batsatbaunum nuwi ditajai ijunjajui. ");
INSERT INTO agr_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Tuja tikich Israel aents ishamkagtuinak Efraígka nugken uumkaju aidaunashkam, filisteo aidau pisainawai tabaun antukag ditashkam jiinag maaniawagtatus pataetukajui. ");
INSERT INTO agr_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Nunik pataetukag mai mainakua Bet-avén jegawajui. Aatus nunú tsawantin Tuke Pujuu Israel aents aidaun ayamjuk agkanmitkauwai. ");
INSERT INTO agr_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Israel aents aidauk yujumkan yutsuk maaniawaju asag, shiig senchi pimpikiajui. Nunak Saúl chichaak: “Shiwag aidau eke depeteatsjinig, yutain yuwauk mantamnati” tusa chichaman umiku asamtai, nuna umiinak nunikajui. ");
INSERT INTO agr_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Tujash nunú tsawantin aents aidau maaninak yujasag dapa ayaunum jegantajui. ");
INSERT INTO agr_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Nunik ikam akumak diikma dapa yumiji shiig kuashat ayaun wainkajui. Dutika wainkajash piipichinakesh dukachajui, wagki nuna nuniauk mantamnati tibau asamtai, nuna ishamainau asag. ");
INSERT INTO agr_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Untsu Jonatágkak niina apaji chicham umiamun dekachu asa, numi takakbauwai nuna titijin, dapa yumiji saegun antig dukauwai. Dutika pimpiki wekaebaun ichichmamjauwai. ");
INSERT INTO agr_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Nunikmatai suntag aidaunmaya makichik niina chichajak: “Amina apa chichama umiak: ‘Makichik aentskesh juju tsawanta duwi yutain yuwauk mantamnati’ tiu asamtai, iik senchi pimpikiatku makichik yutaigkesh yuwatsji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Tusa tutai Jonatán chichaak: “Mina apag chichaman umika nunak tumainchaun tine. Wika dapa yumijin dukaan pimpiki wekaebaujun ichichmamjajai. ");
INSERT INTO agr_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Tuja tikich Israel aents aidaush iina shiwaaji aidau depetka, yutai atankimua nuna yuwawajag, ditash aan nagkaemas senchigtin wemain wajakaje. ¡Nunikagmatai filisteo aidauk wamak amumain awajkaji!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Tuja Israel aents aidauk nunú tsawantin filisteo aidaunak, yaakat Micmas nagkamas mai mainakua yaakat Aialón ejegawajui. Tujash Israel aents aidauk shiig senchi pimpikiajui. ");
INSERT INTO agr_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Imanik pimpikiaju asag, yapajuinak uwig aidau, baka aidau, toro tsakat aidau, filisteo yajutkamu aidaun maawag neje numpemtin uduunak yuwawajui. ");
INSERT INTO agr_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Nuna nuniagtai nuwiya makichik Saúlan jegajua chichajak: “Tuke Pujuu: Neje numpemtin yuwawaigpajum, tusa tujamiuwa nuna umitsuk, neje uduun numpejai yuwinak tunamainawai”, tau. Tusa ujakam Saúl chichaak: “¡Atumek Apajuí tujabauwa duka umitsuk intimjukiugme! Nuniku asajum kaya múun jukijum juwi itagtuatajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Nuna tusa, tikich Israel aents aina dushakam ashí ujaktajum: “Maki makichik toron, nuniachkush uwijan itaatnume. Dutikawag juju kaya múun puja juwi patai maatnume, dutikam nuna numpe saeki utsankamtai, duwi shiig numpe atsaun yuwatnume. Nuna nuninak tunamagchagtatui”, tiuwai. Tusa tima nunú kashia duik maki makichik toro jukiag kaya múun pujamunum ejegawag, nuwi pataidiag maawajui. ");
INSERT INTO agr_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Dutikawagmatai Saúl kuntin maa patasa apeaku Apajuí ememattinun makichkish najanchauwaitak najanauwai. ");
INSERT INTO agr_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Nuna dutika Israel aents aidaun Saúl chichajak: “Filisteo aidau kashi jeteka mai mainakua tsawampaku ashí amukmi”, tau. Tusa tutai dita aimainak: “Ame wakegamua duka imanisag uminkati”, tuidau. Tusa tiagtai sacerdote chichaak: “Tujash dekatkauk Apajuí iniasmi”, tau. ");
INSERT INTO agr_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Tusa timatai Saúl Apajuín iniak: “¿Filisteo aidaunash jetemainkaitag? ¿Tuja filisteo aidaun amuktinme tusamesh yaijatkattamek?” tau. Tusa tamash Tuke Pujuuk nunú tsawantinig aikchauwai. ");
INSERT INTO agr_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Dutikam Saúl suntaja apuji aidaun chichajak: “Apajuí mina aigkacha nunash ya pegkegchau takamsamunmak ankae nunú ejetajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Nuna tusa: “Tuke Pujuu Israel aents aidaun ayamjina nuna daajin uminkatnun tajai: ¡Mina uchig Jonatán pegkegchaun takasu akushkam mantamnattawai!” tiuwai. Tutai suntag aidauk makichkish aimkachajui. ");
INSERT INTO agr_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Nuadui Saúl Israel aents aidaun chichajak: “Kaunajum juwi ijunjatajum, nuniagmin wi mina uchig Jonatágjai atú yantam wajastajai”, tiuwai. Tusa tutai suntag aidau chichainak: “Ame tame nunisag uminkati”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Tusa tiagmatai Saúl senchi untsumak Tuke Pujuun aujak: “Israel aents aidaun Apajuíjiyah, ¿wagka amina inakem segapamush yamaish aikchaume? Mina pegkegchaug, nuniachkush mina uchig Jonatágka pegkegchauji akug Urim jiinkittawai, untsu Israel aents aidaun pegkegchauji ataik Tumim jiinkittawai”, tiuwai. Dutika dekam Jonatágka daaji Saúldaujai jiinkiuwai. Nunikmatai Israel aents aidauk agkan utugchatjinchau juwakajui. ");
INSERT INTO agr_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Nunikmatai Saúl chichaak: “Mina uchig Jonatán wijai dekapsatajum, yana daajig jiinkit”, tiuwai. Dutika dekapeam Jonatágka daaji jiinkiuwai. ");
INSERT INTO agr_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Nunikmatai Saúl Joinatágkan chichajak: “Amesh waji dutikamume nunú ujatkata” tiuwai. Tusa tama Jonatán chichaak: “Ima dapa yumijinak numi takakbau titijin antigka jukin dukamjai. ¿Tujash nunú dutikamuikik mantamnattag?” tau. ");
INSERT INTO agr_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Tutai Saúl untsumak: “¡Jonatágkah, ame mantamnashtaik Apajuí mina mantuati!” tau. ");
INSERT INTO agr_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Tutai Israel aents aidau Saúlan chichajuinak: “Jonatán iina ayamjutpak filisteo aidaujai maania depetmaka nuniaush ¿wagkag mantamnati? Apajuí Tuke Pujuuwa nuna daajin makichik niina intashigkesh ukuiniakag nugkag iyagchattawai, wagki Apajuí yayasam depetmaku asamtai”, tiajui. Aatus Israel aents aidau Jonatán mantamnamainun ayamjukajui. ");
INSERT INTO agr_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Tuja Saúlchakam filisteo aidaujai maanitnak idaisauwai. Dutikam filisteo aidauk ditá nugken waketjauwai. ");
INSERT INTO agr_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Aatus depetmak Saúl Israel aents aidaun apuji wajas inamjauwai. Tuja Israel aents aidau nugken ditá shiwaaji Moab aents aidau, Amón aents aidau, Edom aents aidaunash ayamjuk agkanmitkauwai. Tuja Sobá nugka apujinash, filisteo aidaun aatus ashí depetkauwai. Saúl niina suntaji aidaujai shiwajan jeteakug tuke depetmajakui. ");
INSERT INTO agr_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","Niina suntaji aidaujai ijunag maania Amalec aents aidaun depetuk ijinauwai. Dutika Israel aents aidaun kasajuinak waitkaidaun agkanmitkauwai. ");
INSERT INTO agr_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Saúla uchiji aidauk: Jonatán, Ishví, Malquisúa aatus aajakui. Tuja niina nawanji iwai aajakui Merab, untsu Mical aajakui ekeu. ");
INSERT INTO agr_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Saúla nuweg Ahinóam Ahimaasa nawanji aajakui. Tuja niina suntaji aidaun apujig Abner niina apaji yachi Neran uchiji aajakui. ");
INSERT INTO agr_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Saúla apaji Quish aajakua duka Abneran apaji Ner aajakua nujai Abielan uchiji aajakui. ");
INSERT INTO agr_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Saúl apu wajas pujusua nuaduik, Israel aents aidauk filisteo aidaujai shiig senchi maaniau ainawai. Nuadui Saúlak suntag maanitan yacha aidaun etegkeg yajuak ijumag uminas pujujakui. ");
INSERT INTO agr_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Makichik tsawantai Samuel Saúlan chichajak: “Tuke Pujuu niina aentsji Israel aents aina nuna apuji atinun amina adaikati tusa awetine. Nuadui Tuke Pujuu tujama nunú shiig antukta. ");
INSERT INTO agr_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Tuke Pujuu ashí senchigtina nunú juna aatus tujamui: ‘Israel aents aidau egiptunmaya jiinag minidaun Amalec aents aidau jetenak waitkasaju aina duwi, wi ditanak suwimka susagtatjai. ");
INSERT INTO agr_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Nuadui amina suntajum aidaujai jetekjum ijinkujum dita wajiji aidaujaí ashí tsaigkatajum. Tuja makichkish wait anenjaigpa. Aents aishmag aidau, nuwa aidau, uchi aidau, yama uchi akiinau aidau, tuja nuigtushkam toro, uwig, camello, burro aatsajum ashí ijinatajum’ tujamui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Tusa tima Saúl suntag aidaun chichama ishitkauwai. Nuna dekaawag Telaimnum ijunjamtai ashí dekapajui. Dutikam dawé yujasag maanin aidauk doscientos mil aents aajakui. Tuja Judá wegantunmaya aidaushkam diez mil suntag aajakui. ");
INSERT INTO agr_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Dutika dekapag nuna yajuak, yaakat múun Amalec nugkanum aajakua nuwi weuwai. Nunik nuwi jegattak entsa aunum nuna ijusag uumak batsamsajui, nuwi batsamsag pachiachbau jetekagtatus. ");
INSERT INTO agr_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Nuwi batsamas Saúl quenita aents aidaun chichama akatmamtug akuptak: “¡Amalec aents aidau batsatbaunum pujajum duka jiinja yaja shiyaktajum! ditajai ijumja amukaijim. Wagki atum wegantutigmek Israel aents aidau egiptunmaya jiinag minidau wait anenjau ainagme”, tiuwai. Tusa ujakajam quenita aents aidauk Amalecjai ijunag batsatu jiinag yaja shiyakajui. ");
INSERT INTO agr_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Nunikagmatai Saúl Amalec aents aidaun nugka Havilánum nagkama jeteka ipisig, Shur nugka Egipto nugke nagkatkamunum awa imanui ejegawajui, dutikawag nuwi amukui. ");
INSERT INTO agr_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Dutika amuak nuna apuji Agag aajakua nuna achikui, dutikak niina suntaji aidaunak ashí ijituauwai. ");
INSERT INTO agr_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Dutika ijiniatak Agagnak maachajui. Tuja nuigtushkam tikich waji imanchau aidaunak tsainayatak, uwig pegkeg aidaunak ijinachajui, dutikainak toro aidaunak, toro tsakat duwejam aidaunak, cabra tsakat aidaunashkam ijinachajui. Dutiksag waji akik pegkeg aidaunashkam tsaikchajui. ");
INSERT INTO agr_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Dutikawagmatai Tuke Pujuu Samuelan chichajak: ");
INSERT INTO agr_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Saúlnak apu adaimainchaunas adaikayagtai, mina chichamjun umigtutsuk nii wakegamun takawai”, tiuwai. Tusa timatai, Samuel kajeka Saúl tsagkujata tusa Apajuín sega segaakua tuke tsawajui. ");
INSERT INTO agr_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Nunik tsawag kashikmas Saúljai igkunik chichastatus weuwai. Nunik eke wegaun igkug ujainak: “Auk Saúlak yaakat Carmel wemae, nunik nuwi kaya esagman awajame, nuna diisag emematjitnume tusa. Dutika ukuak yaakat Guilgal wemae”, tusa ujakajui. ");
INSERT INTO agr_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Tusa ujakam Samuel Saúlan egak weuwai. Nunik jegamtai Saúl Samuelan chichajak: “Apajuí pegkegnum yumigtamsati. Apajuí dutikata tujutma nunak betek umikjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Tutai Samuel ayaak: “¿Tujash dutika betek umiku aminish, uwig aidau, baka aidau pampaina dusha tuwiya ainawa?” tau. ");
INSERT INTO agr_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Tusa tama Saúl ayaak: “Aunak mina aentsug aidau Amalec aents aidaun amuinak uwig duwejam pegkeg aidaun, toro duwejam pegkeg aidaujai etegkeg yajuakag itawagmae, wagki nunú maa apeaku Tuke Pujuu amina Apajuíjum emematmi tusag. Untsu tikich aidauk ashí ijinamji”, tau. ");
INSERT INTO agr_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Tusa tutai Samuel ayaak: “¡Takamtak wajasta! Tuke Pujuu yamai kashi tujutma nuna ujaktagme”, tiuwai. Tama Saúl ayaak: “Ayu ujatkata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Timatai Samuel chichajak: “Yaunchkek amek wainkauch ayume, nunin aminig Tuke Pujuu Israel aents aidaun apuji ati tusa etegtamabi. ");
INSERT INTO agr_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Dutijamau asa Amalec aents pegkegchaun takau aina nunú amukta tusa Tuke Pujuu tujabiu aish, ");
INSERT INTO agr_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","¿wagka Tuke Pujuu tujabau intimjukmesh amina suntajum aidau kuntin aidaun yajumainakuish, yajuaktajum tusamesh timaume?” tau. ");
INSERT INTO agr_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Tusa tama Saúl ayaak: “Wika Tuke Pujuun umiju asan, nii dutikata tujutbaunak betek umiakun, Amalec aents aidau apuji Agag achikan itaajai. Tuja nuigtushkam Amalec aents aidaunak ashí ijinamji. ");
INSERT INTO agr_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Untsu suntag aidau uwig duwejam aidaun, toro duwejam aidaujai ijinami tibau aig, yaakat Guilgalnum maa apeaku Tuke Pujuu amina Apajuíjum emematmi tusa yajuakagmae”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Tusa timatai Samuel chichaak: “Kuntin maa, nuna neje ashí apeamua nuna nagkaesau, Tuke Pujuu tabau shiig antuka umigbauwa nunú niinak shiig awagmawai. Tuja nuigtushkam anentag dekas shiig pegkeg aidau Apajuí suwamua nuna nagkaesauwa duka nii umigbauwa nunuwai. ");
INSERT INTO agr_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Nuadui amek anentaimsam dutikaum duka aents anentaimas dekamin aina nunin wajasume. Tuja kaya esajam inantai apusam, juna diis emematjitnume tau asam, dakumkamun emematin aidau Apajuí diisam pegkegchau aina nunin wajasume. Nuadui Tuke Pujuu amina Israel aents aidaun apuji ati tusa etegtabauwa nunak, ame nii tibau kajimatkiu asamin, niishkam kajimatjamkittawai, tuja niina chichame umitsuk idaisau asamin, niishkam dutiksag idaitamsattawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Tusa tima Saúl Samuelan chichajak: “Dekas tame, Tuke Pujuu dutikata tujutbaun kajimatkin pegkegchaun takasjai, tuja ame tujutbaunashkam kajimatkijai. Aents aidaun ishamakun dita segatuinamun umigkajai. ");
INSERT INTO agr_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Tujash wait aneasam mina pegkegchaujush tsagkugtugta, nunikamin iijai wee Tuke Pujuu emematmi”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Tusa tama Samuel ayaak: “Wika amejaig wakitkishtatjai, wagki amek Tuke Pujuu umikta tujabau intimjukim umikchaum nuadui, yamaik Israel aents aidaun apujig achati tusa Tuke Pujuu tujamne”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Aatus tusa wetatman Saúl Samuela jáanchjin achika emetuawai. Dutikak jáanchjin ichiinkauwai. ");
INSERT INTO agr_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Dutikam Samuel Saúlan chichajak: “Ame mina jáanchug ichinjukum dutiksag, ame Israel aentsu apuji wajasa pujam nunak Tuke Pujuu ichinjamkattawai. Dutika atanjamki, Israel aents tikich amina nagkaetamsau pegkeg puja nuna apu emattawai. ");
INSERT INTO agr_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Wagki Apajuí Israel aents aidaun depetmatan suwa duka aents nii chichakbaujin yapajin aina nuninchauwai, nii tibaunak betek uminai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Tusa tima Saúl ataktu chichaak: “Wika dekas tunamagjai. Nuniku akuish wait aneasam Israel aents aidaun apuji aina nuna emtinig, tuja Israel aents aina nuna emtinchakam eme anenjusam diigsata. Nuadui iijai Guilgalnum wemi, nunika awi Tuke Pujuu amina Apajuíjum emematmi”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Tusa tima Samuel Saúljai wakitkiuwai. Nunik jegawag nuwi Saúl Tuke Pujuun emematiuwai. ");
INSERT INTO agr_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Dutikamtai Samuel chichaak: “Agag Amalec aents aidau apuji achikam puja nunú itagtuatajum”, tiuwai. Tuja Agagkak yaunchuk mantumainnap mantuachaje yamaik mantuachagtatuapi tusa puyattsuk shiig aneas Samuel pujamunum jegantui. ");
INSERT INTO agr_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Nunikmatai Samuel chichajak: “Amina puyagjumin uchi aidau kajegkamin, kuashat nuwa aidau uchigtuchu juwakajua nunisag, amina dukushkam uchigtuchu juwaktatui”, tiuwai. Tusa tamawaik puyajan juwakug Tuke Pujuu dutikata tibaun umiak asaag mauwai. Nunak dutikauwai yaakat Guilgalnum. ");
INSERT INTO agr_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Nuna dutika Samuelak yaakat Ramá niina jeen wakitkiuwai. Nunikmatai Saúlchakam yaakat Guibeánum niina jeen wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Duwi nagkamas Samuel Saúlan anentaimtus wake besemag anentaimkush ataktu awagkig wainikchauwai. Tuja Tuke Pujuushkam nii Israel aents aidaun apuji emau asa wake besemag anentaimjauwai. ");
INSERT INTO agr_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Tuke Pujuu Samuelan chichajak: “¡Saúla utugchatji anentaimtusam wake besemag dekapeakum waitu pujutsuk idaisata! Yamai nagkamsag Israel aents aidaun apujig achati tajai. Aní pujutsuk aminu kuntinu kachuji awa nuwi aceite yajaa jukim Belégkanmaya aents Jesé daagtin puja nuna jeen wetá. Niina uchiji aina nuwiyan makichik Israel aents aidaun apuji atinun etegkajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Tusa tama nii ayaak: “¿Tujash nunash wajuk uuknuk dutikatja? ¡Nuna Saúl dekag minak mantuattawai!” tiuwai. Tusa tutai Tuke Pujuu ayaak: “Kuntinu maa apeakun Tuke Pujuun ememattasan wegajai tusam makichik toro tsakatuch jukim wetá. ");
INSERT INTO agr_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Nunika jegaam Jesé ipaata ame kuntin maa apeamin uyuuntamsati. Tuja ame dutikatnunak wi jintintuattagme. Tuja apu atinnashkam wi iwaintuktatjame. Dutikamtai nunú aceiteyai buuknum nijakta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Nuna Samuel imatiksag umikui. Tuja Samuel Belén jegamtai, nuwiya apu múun aidau niina wainkag kautuawajui. Nunikag igkug iniinak: “¿Wagka taume, utugchat atsuak?” tuidau. ");
INSERT INTO agr_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Tusa tama nii ayaak: “Utugchatak atsawai, ayatak kuntinu maa apeakun Tuke Pujuu ememattasan taajai”, tiuwai. Nuna tusa: “Umintsatajum, nunikjum wi kuntinu maa apeakun Tuke Pujuun emematkui uyuntustajum”, tiuwai. Aatus tusa eke kuntin maa apeatnunum wetsuk Samuel Jesén niina uchiji aidaujai dita pegkegchau takamsamujin iwagmitkak pegkeg emakui. Dutika nuadui ditajai kuntinu maa apeak Apajuín ememattatus weuwai. ");
INSERT INTO agr_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Nuwi ashí jegantag Samuel Eliabpan diisa anentaimas: “Junap dekas Tuke Pujuuk apu atinnak etegkae”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Tujash Tuke Pujuu niina chichajak: “Niina niimeg esantijaig diigsaipa, wagki nunak wika dakitajai. Aents niimen diijus etegkin aina nuninchauwaitjai, wika anentaimtajin diigsan etegkeajai” tusa nunak dakitjauwai. ");
INSERT INTO agr_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Dutikamtai Jesé niina uchiji Abinadapan untsuka Samuelai ejentauwai. Dutikamtai Samuel chichaak: “Junashkam Tuke Pujuuk etegkache”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Tusa timatai Jesé tikich uchiji Shamá aajakua nuna ejentauwai. Dutikamtai: “Junashkam Tuke Pujuuk etegkache”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Duti dutikakua niina uchiji siete aidaunak ashí Samuelai ejentauwai. Tujash Samuel niina chichajak: “Juju aina juwiyanak Tuke Pujuuk makichkish etegkache”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Tuja inagnamun Samuel Jesén iniak: “¿Uchijum tikichik atsugtamuak?” tau. Tusa iniam, Jesé ayaak: “Inagnamu makichik datsauch uwija kuitamak pujawai”, tau. Tutai Samuel niina chichajak: “Makichik aents awemata ujaka utiti, wagki kuntin maa apeamua nuna nejeg nii tatsaigkik yuwashtatji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Tusa timatai, ujaka utitajum tusa Jesé aentsun awemauwai. Nunú uchik jegkemtin, pegkeg iwajamu wakejumain aajakui. Nunú jeganmatai Tuke Pujuu Samuelan chichajak: “Anuwai wi etegkamua duka, nuadui aceite jukim buuknum nijakta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Tusa tima aceiten juki Davitan niina yachi aidaush wainbaunum buuknum nijakui, Israel aents aidaun apuji atin asamtai. Nunú tsawantin nagkamas Apajuí Wakani Davitan egkemtujui. Tuja Samuelak nuna dutika ukuak, yaakat Ramá niina jeen wakitkiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Apajuí Wakani Saúlai pujaun Tuke Pujuu jujukiuwai. Dutikak wakan pegkegchaun awetiuwai. Dutikam nunú Saúlan senchi waitkau. ");
INSERT INTO agr_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Nuadui niina takajin aidau chichajuinak: “Apajuí aminak wakan pegkegchaun awetugma nunú senchi waitkagmawai. ");
INSERT INTO agr_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Nuadui amina inakem aina nunú ishiakta, aents arpa shiig awatnun egaka utitnume. Tuja amina wakan pegkegchau waitkagmataish, nunú arpan awatkui maak anentaimsa pujusminum”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Tusa tama nii ayaak: “Takugmek wejum arpa shiig awatin egakjum itagtuatajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Tusa tutai niina inake aina nuwiya makichik Saúlan chichajak: “Jesé Belégnumiaya nuna uchiji aina nuwiya makichik arpan shiig awatun wi wainkamjai. Nuigtushkam duka wajiu maanitan yacha, chichamesh pegkeg, niimesh iwajamui. Tuja niinak nuigtushkam Tuke Pujuu yayawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Tusa tima Saúl Jesén chichaman akuptak: “Uchijum David uwija kuitamna nunú awetugta”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Nuna antuk Jesé niina uchiji Davitan awetiuwai. Dutikak makichik burronum pagka pataja, vino aimkamun, nuigtu chivo tsakatan aatus ishitkauwai. ");
INSERT INTO agr_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Nuna David yajuak Saúla pujusa inamtaijin jegauwai. Nunik jegamtai Saúl shiig anentus jukiuwai. Dutika niina atuwe ati tusa adaikauwai. ");
INSERT INTO agr_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Tuja Saúl Jesén chichama akuptak: “Amina uchijum Davidjai shiig pujajai, nuniau asan segajame wait aneasam idaitugsata mina yaintak pujusti”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Tusa tima pujus wakan pegkegchau Apajuí awemamu Saúlan waitkatai, David arpan juki awatujakui. Nuna awattai wakan pegkegchau Saúlan waitkau ukukim mijaak shiig pujujakui. ");
INSERT INTO agr_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Filisteo aidau Israel aents aidaun jetektatus ditá suntaji aidaun yajuak, Judá wegantu aidau nugken yaakat Soco ijunjajui. Nunik Azecá Socojai niniaku awa nuna ejapeen nugka Efes-damim tutainum aakmajag batsamsajui. ");
INSERT INTO agr_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Nuninai Saúlchakam Israel aents aidaujai Elá nugkanum ijunjajui, nuwi uminas juwakiag filisteo aidaujai maaniawagtatus. ");
INSERT INTO agr_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Tuja muja segau asamtai, filisteo aidauk atú amain batsatai, Israel aents aidauk tikich yantamnum batsatu. ");
INSERT INTO agr_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Nuninai filisteo suntag aidaunmaya makichik aents Gad wegantunmaya maanitan yacha Goliat daagtin, esanti kampatum metro aajakua nunú jiinkiuwai. ");
INSERT INTO agr_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Niina atsejutaijig bronce najanamu tuja iyashi ejaktinji jiju najanamu cincuenta y cinco kilo ajamun nugkuaju aajakui. ");
INSERT INTO agr_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Niina bakuin ejaktatus apujujakua dushakam bronce najanamu aajakui. Tuja nagkijishkam bronce najanamu aajakui. ");
INSERT INTO agr_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Tuja nagki numijishkam kampujam nuna titijig jiju hierro eketkamu seis kilo aajakui. Niina emtin maanitai aidaun yajuak niina uyunajakua nunú eemak wejakui. ");
INSERT INTO agr_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Goliat Israel aents aidau batsatbaunum jegantatak wajanta untsumak: “¿Wagka maaniatasa umintayama imanikjumesh uminjume? Wika makichkitjai filisteonuk, tuja atumek Saúla inake ainagme. Tujash dekas atum ainajum anuiya makichik wijai maanimain etegkajum awematajum wijai maanikti. ");
INSERT INTO agr_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Nii mina depeetuk mantakuig atumi inake waigtatji, untsu wi niina maamtaig, atumek iina inake wajastatjume. ");
INSERT INTO agr_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","“Yamai wi Israel aents aidautigmin segajime: ¡Makichik aents awematajum wijai maanikti!”, tau. ");
INSERT INTO agr_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Nuna Saúl Israel aents aidaujai antukag senchi ishamainak awake anentaimaidau. ");
INSERT INTO agr_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Saúl apu aajakua nunú tsawantin makichik aents múuntuch Belégkanmaya Jesé daagtin pujujakui. Nuna uchijig ocho ajujakui. Nuwiya aajakui David. ");
INSERT INTO agr_vpl VALUES ("S117_13","010_17_13","1SA","17","13","14","Nunú muunta uchiji kampatum: Eliab, Abinadab, Shamá, aatus iwai aidau maaniamunum Saúljai shiyakajui. Untsu Jesé uchiji tsakat David aajakua duka, ");
INSERT INTO agr_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Saúl niina suntaji aidaujai batsatbaunum chichama etsejak yutain juki ejega ukuak, atak wakitki niina apaji uwigjin kuitamak pujujakui. ");
INSERT INTO agr_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Nunik pujai Goliatak kashikmas, agkuantai aatus kashi kashinig untsuak: Makichik aents wijai maanimain etegkajum awematajum, tusa Israel aents aidaun cuarenta tsawan waitka pujuju. ");
INSERT INTO agr_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Imatju pujai makichik tsawantai Jesé niina uchiji Davitan chichajak: “Trigo duwikbauwa nunú veinte kilo jukim, nuigtu diez pag jukim, yatsum aidau maaniamunum batsata nunú ejetuata. ");
INSERT INTO agr_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Dutikakum baka muntsuji inanja nanegbau suntaja apuji susatin diez jukita. Nunika jegaam yatsumesh pegkejash batsata nunú dekaata. Tuja pegkeg batsatkuig, ame minakum ditá takataiji jukim itagtuata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Eke Davitak uminak pujai Saúlak Davita yachi aidaujai, nuigtu ashí Israel aents aidaujai aatus nugka Elá tutainum filisteo aidaujai maaninak yujau. ");
INSERT INTO agr_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Nuninai David uminas tsawak kashikmas tikich aentsun, ame uwig aidau kuitamamata tusa ukuak, niina apaji yutai aidau susamun juki weuwai. Nunik jegakma maaniatatus uminas, untsumainak pampainai jegauwai. ");
INSERT INTO agr_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Nunik jegau ai Israel aents aidauk filisteo aidaujai maaniawagtatus igkuniawajui. ");
INSERT INTO agr_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Nuniagtai David aents maaniaku jutai aidaun kuitamak pujaun nii yutai jukimujin ame kuitamkata tusa ukuak, yachi aidaun pegkejash yuja tusa iniastatus tupikaki weuwai. ");
INSERT INTO agr_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Nunik jeganta niina yachi aidaujai chichaak wajai, Goliat yaakat Gadnumia aajakua nunú filisteo aidau ijunbaunmaya jiinki wajan, yaunchuk nagkamas tuu pujuju asa, Israel aents aidaun atsaneau. Tusa imatjittaman David antukui. ");
INSERT INTO agr_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Nunú aents ibaun, wainkag Israel aents aidauk senchi ishamak pisainak: ");
INSERT INTO agr_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","“¿Atumesh aents maanitan yacha jiinki dusha wainkaugmek? Au aentsuk Israel aents aidaun atsaneak tantae. Makichik aents auna depetuk maamtaig, kuashat waji akik aidaun apu susattawai. Dutikak niina nawanjijai nuweattawai. Tuja nuigtushkam niina patayi aidauk apu akitai aina nunash akikmakchagtatui”, tuidau. ");
INSERT INTO agr_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Tusa tuinamun David shiig antukchau asa niijai ijunun iniak: “Au filisteo, Israel aentsun atsaneak waitka nuna makichik aents maa agkan emamtaish ¿wajina apush sumainai tawa? Filisteo pegkegchaun takauwa dusha niish ¿ya asaya aannush Apajuí suntaji aidaunash pegkegchaun chichajush wekaewa?” tau. ");
INSERT INTO agr_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Tusa tutai dita yaunchuk tibaunak dutiksag chichajuinak: Goliata maunak waji aidaun apu susattawai tibaunak betek ujakajui. ");
INSERT INTO agr_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Aatus nunú aents aidaujai David chichaun yachi emkau Eliab antujuk senchi kajejuk chichajak: “¿Amesh juwish waji minitmaume? ¿Uwig ujumak uwegshunum batsama dusha ya kuitamkati tusamea ukukmaume? Wika ame setakchauwaitam nunak dekajai, tuja pegkegchau anentaiyai aní wekagam nunashkam dekajai. Amek iina shiwaaji aidaujaish wajuk maaniaji nunú wainkatasa wekaeme”, tau. ");
INSERT INTO agr_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Tutai David ayaak: “Wi ayatak inimag nunash ¿wajina pegkegchaunash dutikaja?” tau. ");
INSERT INTO agr_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Nuna tusa David niina yachi iwai aidaun ukuki, tikich aidaun iniau. Tuja ditashkam yaunchuk tibaunak dutiksag ujakajui. ");
INSERT INTO agr_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Nunik iniimak wekagun antugkaju aidau Saúlan jegajuawag ujakajui. Nuna Saúl dekaa, ujaka utitajum tusa inamjauwai. ");
INSERT INTO agr_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Tusa timatai ujakam David jegaa Saúlan chichajak: “¡Apuh, amek makichkish puyatjukaipa, auk wi niinak maattajai!” tau. ");
INSERT INTO agr_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Tutai Saúl ayaak: “Amek makichkish maumaitsume. Nuigtushkam amek tsakatchitme, tuja niig yaunchuk datsa asag maanitnak yachai”, tau. ");
INSERT INTO agr_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Tama David ayaak: “Apuh, wika mina apaju uwigjin kuitamnaitjai. Tujash ikamyawa, nuniachkush chayukesh uwija maa juki tupikakuig, ");
INSERT INTO agr_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","pataetukan niina weninian atannujai. Dutikai mina esattag takuig, jagkeen achikan awatjan mainujai. ");
INSERT INTO agr_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Dutiksanuk au filisteo aents Apajuí Tuke Pujuuwa nuna aentsji aidaun dushikiak atsanea nunak maattajai. ");
INSERT INTO agr_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Ikamyawa chayujai maawai tusa Tuke Pujuu ayamjutkauwa nunú minak yamaishkam filisteo maawai tusa ayamjutkattawai”, tau. Tutai Saúl chichajak: “Kame takumek wetá, Tuke Pujuu kuitamjamkati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Nuna tusa nii maaniaku nugkutaijin anugkug, atsejutai bronce najanamun atsemitkak, nuigtu iyash ejatai jiju najanamun anugjauwai. ");
INSERT INTO agr_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Dutika anugjam David puyaja juki akachumtaijin nenauwai. Dutika wekagas dekapes, unuimatchau asa, shiig wekaemainchau atai, Saúlan chichajak: “Wika junika wekaetanak unuimatjachu asan, shiig wekaemainchau dekapeajai”, tusa ashí nii nugkuagbaujinak awimag ukukiuwai. ");
INSERT INTO agr_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Dutika ushujutaijin juki cinco kaya entsanmayan yajuak wampachjin chimpia kaya egkea nagkimtaijin juki, Goliat pujamunum jegantatus weuwai. ");
INSERT INTO agr_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Nuniai Goliatchakam maaniaku ejamatain takaku Davitan jegaantatatus wegau. Nuniai niina uyunin maanitai aidaun yajuak eemak wedau. ");
INSERT INTO agr_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Tuja Goliat Davitan diikma tsakatuch shigmauch jegkemtin wajaknun wainkauwai. Nunik wainak puyatjusagkesh diischauwai. ");
INSERT INTO agr_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Tuja Davitak ushujutaijin takus wajau asamtai, dushikis chichajak: “¿Wi yawakaitag numi jujuki minitam atinnush?” Tusa tamawaik niina apajuímtaiji daajin pachis Davitan pegkegchaunum yumigjauwai. ");
INSERT INTO agr_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Tusa nuigtushkam chichajak: “¡Juwi tantata maatjame, dutikan amina iyashminak chuwag aidaun, kuntin yukagtin aidaujai ayujatjai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Tusa tama David ayaak: “Amek wijai maaniatasam puyag, nagki, nuigtu akentai imaan jukim miname. Tujash wika aminak minitjame Tuke Pujuu ashí senchigtin Israel aents aidauti emematin ainag nuna daajin. Nuadui ame niina aentsji aidau wainkaush diyakum dushikiam nunak nii kuitamkattawai. ");
INSERT INTO agr_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Yamai Tuke Pujuu mina yainkattawai amina maati tusa. Nuadui amina maan buukmin tsupigkattagme. Dutika ai amina iyashminak amina suntajum filisteo aidau jinaatta nujai chuwag aidau, kuntin yukagtin aidaujai yuwawagtatui. Dutika ai ashí tikich nugkanmaya aidauk dekawagtatui, Israel aents aidauti ememattaig Apajuí ima makichkia nuna”, tau. ");
INSERT INTO agr_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Nuna tusa filisteo aidaun chichajak: “Yamai juwi tuwaka ijunutijum, Tuke Pujuuk puyagjaig, nagkijaig uwemtikagtuchua nunú ashí dekattagme. Juju maaniamua juka Tuke Pujuunui. Nii inak yaimpaktatui, atum aidautigmin depetuk ijinatnume tusa”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Tusa tama Goliat Davidjai maaniatatus jiintukiuwai. Nunitai Davidchakam tupikatkiuwai igkunia maaniatatus. ");
INSERT INTO agr_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Nunik wegak wampachjinian makichik kaya juki kaya nagkimtainum egkea nagkia Goliatan nijayin tukuwai. Dutika tukum nijayinig kayan awajau, shushum iyaag tepesui. ");
INSERT INTO agr_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Aatus David Goliatan depetkauwai. Kaya egkea nagkimtaichijinig kaya egkea nagkia tuku mauwai. Dutika maa puyaja takakchau asa, ");
INSERT INTO agr_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","tupikaki jegantun niina puyagjinak ukuinak jujuki awena mauwai. Dutika maa buuken tsupijuk jujukiuwai. Nunú maanitan yacha etegtua mantuam, filisteo suntag aidauk pisajajui. ");
INSERT INTO agr_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Nuniagtai Israel aents aidau Judá wegantu aidaujai maaniami tusag senchi untsumkag pataetukag, filisteo aentsu yaaktaji aidau Gad Ecrógjai aajakua imanui mai mainakua jegawajui. Dutika ijinamu asa Shaaraim uwaki, yaakat Gad wetainum, nuigtu yaakat Ecrón wetainum aatus filisteo suntag jinauk tepetag jegauwai. ");
INSERT INTO agr_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Israel aents aidauk filisteo aidaun pataetukag shiyaku waketug filisteo batsamtaijin kaunawag dita wajiji aidaunak ashí yajutkajui. ");
INSERT INTO agr_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Dutikawagmatai David Goliata buuken juki Jerusalén ejegauwai. Untsu maaniaku jutaiji aidaunak niina aakjin jukiuwai. ");
INSERT INTO agr_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Eke David Goliatjai maaniatatus wegai, Saúl suntaja apuji Abner aajakua nuna iniak: “¿Aush yana uchijimpaita?” tau. ");
INSERT INTO agr_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Tusa iniam Abner ayaak: “Mina apujuh, wika shiig dekatsjai”, tiuwai. Tusa tama apu Saúl chichajak: “Kame inimsam dekata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Dutika David Goliata maa buuken tsupijuk juki minittaman, Abner igkug juki Saúlai ejentauwai. ");
INSERT INTO agr_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Dutikamtai Saúl iniak: “¿Amesh yana uchijiyaitpa? ujatkata”, tau. Tama David ayaak: “Wika amina inakem Jesé Belégnumiaya nuna uchijiyaitjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","David Saúljai chichas inagnakmatai, Jonatán Davitan shiig kumpauchiji wajasui. Nuadui Davitan senchi anejakui niina iyashin aneemaina imatikas. ");
INSERT INTO agr_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Tuja Saúlchakam nunú tsawantaik mina takagtin ati tusa apusauwai. Dutikau asa niina apaji jenig awagkichui. ");
INSERT INTO agr_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Tuja Jonatán Davidjai dita umiktinjin tudayinak: “Dekas iik atakea duwish tuke kumpaji amí”, tiajui, wagki Davitan niina iyashin aneemaina imatikas aneau asa. ");
INSERT INTO agr_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Nuigtushkam Jonatán jáanchin nii nugkuagbaujin awimak, puyagjin, flecha nagkimtaijin, akachumtaijin aatus Davitan susauwai. ");
INSERT INTO agr_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Davitak filisteo aidaujai maaniati tusa awemam maaniakug tuke depetmau asamtai, Saúl suntag aidaun apuji adaikauwai. Dutikamtai suntag aidauk ashí shiig aneasajui, nunisag suntaja apuji aidaushkam shiig anentuidau. ");
INSERT INTO agr_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Dutika David Goliatan maamtai suntag aidau waketug miniagtai, tuké nunin asag Israel aentsu yaaktaji aidaunmaya nuwa aidauk apu Saúlan igkugtasag ashí jiinjajui. Nuninak shiig aneasag kantamainak, nantsemainak, pandero aidaun, platillo aidaun aatus awatuidau. ");
INSERT INTO agr_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Imatuinak: “Saúl mil aentsun kajegke, untsu David kajegke diez mil aentsun”, wajaidau. ");
INSERT INTO agr_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Nunú Saúlan shiig awajkachui. Nuadui senchi kajeka chichaak: “David diez mil aentsun mae tusag ima senchi eme anentuinawai. Tuja minak ayatak mil aentsnak mae tujutuinawai. ¡Ima apu adaitanak awajsaje!” tau. ");
INSERT INTO agr_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Duwi nagkamas Saúl Davitan kajejujakui. ");
INSERT INTO agr_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Tuja kashinia nuadui Apajuí awemamu wakan pegkegchau Saúlan egkemtujui. Dutikam niina pujusa inamtaijin pujus imaanjaujai betek wajas pujau. Tuja David nuwi niijai pujus tuke arpan awatin asa awatak eketu. Nuniai Saúl nagkin takus eketu. ");
INSERT INTO agr_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","Nunik eketu Davitan tanishjai ijumjan achia maatjai tusa aketkauwai. Dutikam tsuntsumun jimajá uwetjauwai. ");
INSERT INTO agr_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Dutika maachu asa Saúl Davitan ishamau, wagki Tuke Pujuuk niina yaitsuk Davitan yayau asamtai. ");
INSERT INTO agr_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Nuadui niijai pujaun jiikiuwai. Dutika mil suntag aidaun apuji adaikauwai. Dutika ai ditajai ijunjag yujas maaniak wekaesati tusa. Dutikamu asa Davitak Saúla pujusa inamtaijinig pujujakchauwai, tuké maaniak wekagajakui. ");
INSERT INTO agr_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Tuja Tuke Pujuu yayamu asa nii takamujia duka ashí pegkeg aajakui. ");
INSERT INTO agr_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Nuadui Saúl Davitan ishamau, wagki Davitak Tuke Pujuu yayamu asa shiig takau asamtai. ");
INSERT INTO agr_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Nuadui Israel aents aidau Judá aents aidaujai Davitan ashí wakegaidau. Wagki maaniamu ataik, nii chichakmatai maaniawag depetmak kaunaidau asag. ");
INSERT INTO agr_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Makichik tsawantai Saúl Davitan chichajak: “Mina nawantug emkau Merab puja nujai nuweatjame. Tuja nunú jukitag takumek Tuke Pujuu daajin filisteo aidaujai maaniam depetmakta”, tiuwai. Nunak nigkik maumainchau dekapeak filisteo aidau maatnume tusa tiuwai. ");
INSERT INTO agr_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Tusa tama David ayaak: “Wika wainkauchitjai, mina pataag aidaushkam wainkauch ainawai. Wisha nuninnush ame apuitam ibaumin nawanjinash jumainkaitag”, tau. ");
INSERT INTO agr_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Tuja David nuwenatin tsawan jegamtai, nii anagkuayatak Davita sumainun yapajia, tikich aents Adriel yaakat Meholánmaya aajakua nuwi nawanjin sujukui. ");
INSERT INTO agr_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Untsu Saúla tikich nawanji Mical Davitan wakekauwai. Nuna Saúl dekaa shiig aneasui, ");
INSERT INTO agr_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","wagki nii anentaimas: “Dekas auna susatjai, dutikan ame tsanugta tusan inagtajai. Dutika ai tsanugmatai, filisteo aidau Davitan maatnume”, tau asa tiuwai. Nuadui ataktu Davitan chichajak: “Yamaik dekas mina nawantug jukittame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Nuna tusa Saúl niina inake aidaun chichajak: “Davitai wetajum nunikjum tikich antuinachbaunum ima niijaig chichaakjum: ‘Mina nawanjun jukiti tusa apu shiig senchi wakejutpawai, nuniau asamtai ayu tita, tuja niina inake aidautishkam ame eme anentaji’ titajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Tusa tima shimutka ujainam nii ayaak: “Atumesh anentaimsakjuah, ¿wi wainkauch ujunauchitag juninnush apu nawanjinash jumainkaitag? Kame nii taunash itugkatjaki, ayu titajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Tusa timatai Saúla inake aidau waketug jegawag nuna Saúlan ujakajui. ");
INSERT INTO agr_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","Nuna dekaa Saúl filisteo aidau Davitan maatnume tau asa: “Nuwa juamunum aishmag tuke akikbau aina nuna akikmamainun filisteo aidau kati chuchuken cien tsupijug yajuak sujusti. Dutik iikmaktag tajai filisteo aidau iina amupakua nuna iikatag tau asan, tawai tusajum David ujaktajum”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Tusa timatai Saúla inake aidau nuna Davitan ujakajui. Tusa ujakam Davidchakam nuna dutikan apu nawanjin jukitjai tau asa shiig aneasui. Nunú tsawan nuwenatin jegatsaig, ");
INSERT INTO agr_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","David niina suntaji aidaun yajuak wee doscientos filisteo aidaun kajegkajui. Dutika tsupijug yajuak apun ejetuauwai, niina nawanjin jukitag tau asa. Dutikamtai niina nawanji Micaljai nuweauwai. ");
INSERT INTO agr_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Tujash Tuke Pujuu Davitan yayau asamtai, niina nawanji Micalchakam senchi aneau. ");
INSERT INTO agr_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","Nuna diis Saúl Davitan yaunchuk ishamajakbaunak nagkaesau senchi ishamau. Nuadui tuke niina shiwaaji wajasui. ");
INSERT INTO agr_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Filisteo aents aidaun apuji aidau, dita suntaji aidaujai Israel aents aidaun jeteagtaik, Saúla suntaji apuji aidaun nagkaesau David ima senchi depetmajakui. Nuadui Israel aents aidauk eme anentujaku ainawai. ");
INSERT INTO agr_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Saúl niina uchiji Jonatágkan ashí suntaja apuji aidaujai inajui David maatajum tusa. Tujash Jonatágkak Davitan senchi aneau asa, ");
INSERT INTO agr_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","niina apaji tibaun Davitan ujaak: “Mina apag Saúl mantamatag tawai, nuniau asamtai, kashin kashikmasam waipainatsaig ikam uumkata. ");
INSERT INTO agr_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Tuja wi mina apagjai ame uumka pujuttam nuwi ijusan minittajai. Nunikan mina apajun ausattajai mantamawai tusan. Tusa taish wajinjuttig nunikmatai ujaktajame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Aatus tusa ukuak Jonatán Davitan ayamjak niina apaji Saúljai chichaak aatus tiuwai: “Apuh, amek amina inakem Davitak pegkegchau dutikatasamek wakemaitsume, wagki niig aminak makichkish pegkegchauk awajtamtsui, ayatak ame tabaunak betek uminuwe. ");
INSERT INTO agr_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","David nii mantamnamain wajak Goliatan maabi. Duwi nagkamas Tuke Pujuu yaimpasmatai, filisteo aidau depetkamji. Nuna David maamtai ame shiig aneemium dusha, ¿wagka yamaish David pegkegchaun takamchaush maatagtame?” tiuwai. ");
INSERT INTO agr_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Tusa tama Saúl Jonatágkan chichajak: “Apajuí daajin umiktinun tajame, makichkish pegkegchauk awajkashtatjai”, tau. ");
INSERT INTO agr_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Tusa tima Jonatán niina apajijai chichasbaunak imatiksag Davitan ujakui. Nuadui Saúl pujamunum ejegauwai, dutikam Davitak yaunchuk Saúlan takajak pujujakbaunak nunisag takak pujau. ");
INSERT INTO agr_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Nunik kuashat tsawan pujau filisteo aidaujai ataktu maaniamu jegamtai, David maania depetuk ijinam tikich aidauk pisajajui. ");
INSERT INTO agr_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Nuna dutika David apu Saúla pujusa inamtaijin wakitkiuwai. Nunik pujai makichik tsawantai Saúlan wakan pegkegchau Tuke Pujuu awemamu ataktu egkemtujui. Dutikam nagki takus, David arpa awattai antak eketu, ");
INSERT INTO agr_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Davitan nagkin aketkau tanishjai ijumag achia maatatus. Tujash David menaun uwetjauwai. Dutikam nagkik tanishnum wajauwai. Dutikam nunú kashia nuaduik David tupikaki niina jeen weuwai. ");
INSERT INTO agr_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Nunik tupikakmatai Saúl niina aentsji aidaun Davita jeen shimutkag nuwi batsamtus tsawampainak maatnume tusa ishiakui. Tujash Davita nuwe Mical niina emtika ujaak: “Yamai kashia duwi tupikakchaminig, kashin mantamawagtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Nuna tusa Mical Davitan jeganum niimtai ujaimunum nuni jiiki awemauwai. Aatus David tupikakiuwai. ");
INSERT INTO agr_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Dutika awema Mical apajuímtai dakumka najanamun juki, niina pegakjin aepsauwai. Dutika chivo tsakata ujen juki, intashin apujtus jáanchi pempeag aepsauwai. ");
INSERT INTO agr_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Dutika pujai Saúl niina aentsji aidaun David achiktajum tusa ishiakbau, tsawajag David jiinchatai utuawag achikagtatus waitin ijutuidau. Nuniagtai Mical waiti ujai jiinki ditan chichajak: “Davitak jak tepawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Nuna Saúl dekaa niina aentsji aidaun David wejitajum tusa ishimak aatus akatjauwai: “¡Jak tepakuish ukukigpajum jiiki jukijum itagtuatajum maatjai!” tiuwai. ");
INSERT INTO agr_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Tusa tima shimutuk Davita jeen utsanawajui. Nunik diikma apajuímtai dakumka najanamu chivo tsakata ujegai intashi buuken apujtusbau pempeajam tepaun wainkajui. Nunik waketug Saúlan ujakajui. ");
INSERT INTO agr_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Nuna Saúl antuk niina inaken makichik awemauwai Mical utitajum tusa. Dutikam juki itaamtai, apaji chichajak: “¿Wagka mina shiwag jiiki awemakmesh aajamesh tsanujaume?” tau. Tama Mical ayaak: “Nii minak chichagtak, tupikakta tujutchakminig, maattagme tujutkui tupikamtikimjai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Aatus David tupikaki uwemjauwai. Nunik Samueljai chichastatus yaakat Ramá weuwai. Nuwi jegaa Saúl niina maatag tibaun ashí Samuelan ujakui. Tusa ujaka Samueljai yaakat Naiot Ramá awa nuwi pujustatus weuwai. ");
INSERT INTO agr_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Davitak yaakat Naiot Ramá jegattak pujawai tabaun Saúl dekauwai. ");
INSERT INTO agr_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","Nunik dekaa Davitan achiktinme tusa niina aentsji aidaun ishitkauwai. Nunik jegakma, profeta aidau ijunag Apajuí chichamen etsejiagtai shiig etsegkatnume tusa nuna diyak pujaun wainkajui. Nuniai ditanashkam Apajuí Wakani egkemtujajui. Dutikam ditashkam Apajuín pachis etsejuidau. ");
INSERT INTO agr_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Nuna Saúl dekaa tikich niina aentsji aidaun David achiktajum tusa ishiakui. Tusa ishiakam jegattaman, Apajuí Wakani egkemtujam ditashkam nunisag etsejuidau. Nunikagmatai kampatuma duwi ataktu aents aidaun ishitkauwai. Dutikamu ditashkam tikich aidaujai betek núnidau. ");
INSERT INTO agr_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Nuniagtai Saúl nii jiintuki yaakat Ramá weuwai. Nunik yaakat Secú tutainum yumi pimutai múun aunum jegaa, Samuelash Davitjaish tuwi pujawa tusa iniimu. Tusa inimtai makichik aents auk yaakat Naiot Ramá jegattak pujawai tusa ujakui. ");
INSERT INTO agr_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Tusa ujakam nuwi Saúl weuwai. Nunik wetatman Apajuí Wakani egkemtujui. Dutikam chichá chichaakua yaakat Naiot Ramá jegattak awa nuwi jegauwai. ");
INSERT INTO agr_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Nunik Samuel pujamunum jega jáanch nii nugkuagbaujinak awimag, maaniaku jutaijinashkam utsag wisu tsawai, kashishkam tuke Apajuí tita tibaun chichá wekagu. Saúl nuniku asamtai: “Saúlaske profeta wajase”, tiaju ainawai. ");
INSERT INTO agr_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Yaakat Naiot Ramá jegattak awa nuwi pujau David Jonatán pujamunum weuwai. Nunik jegaa iniak: “¿Wisha wajina takamsaja? ¿Tuwiya mina utugchatjush? Amina apa mina mantuatatus egatak wekaga nunash wisha ¿wajina pegkegchaunash takagsaja?” tau. ");
INSERT INTO agr_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Tusa tama Jonatán ayaak: “¡Apajuí dakitawai mina apag mantamawai tusa! ¡Nuadui aminak mantamashtatui! Ame dekame mina apajuk nii dutikatag tabau ataik, nigkik dutikchauwe tuké ujatnuwe, nuadui makichkish mina ujattsukek dutikashtatui”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Tama David ataktu chichajak: “Amina apa shiig dekawai ame mina kumpajuitam nuna. Nuniau asa anentaimas dekas Jonatágnak ujakchatjai, ujaka ai wake besemag anentaimjai titatui, tuja Tuke Pujuu daajin amina daagminchakam tajame, wi mantamnatnuk namput wajatsui”, tau. ");
INSERT INTO agr_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Tusa tama Jonatán iniak: “Wajina dutikati tusamea wakegame nunú tujutta, nuna umigkatjame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Tama David ayaak: “Kashin atatui tsawan nantu yama takau jiistamtai. Nunú jiistatin wi apujai ekemsan tuké yujumkan yuujai. Tujash nunikchattajai. Wait aneasa etsegtugkaipa ajanum uumkan pujuttajai, nunikan kashin pujusa tsawakun agkuantai tatjai. ");
INSERT INTO agr_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Tuja amina apa mina pachitus inimpakuig: ‘Maki makichik mijantin kuntin maa apeaku Apajuí ememattai jegau asamtai, wisha mina pataag aidau Belén batsata nujai ijunjan jiistamatjai tusa segatkui awemamjai’, tita. ");
INSERT INTO agr_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Tusa tamin ayu timataig shiig aneasan juwaktajai. Untsu nii kajeakui dekaattame dekas maatag tawapi tusam. ");
INSERT INTO agr_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Nuadui wait aneasam wi segajam nunú umigtukta. Wagki wika yainikmi tau asan ame mina kumpag ata tujutkumin, Tuke Pujuu daajin chicham umikmaiji. Tuja dekas mina utugchatjuitkuig, amina apai ejetutsuk amek dekas mantuata”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Tusa tutai Jonatán ayaak: “Wainka tuu anentaimipa, mina apag mantamatag takuig wi ujaktatjame”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Tusa tama David niina iniak: “Tujash ¿ya minash ujatkattawa amina apash ame ujaamash wajintigki nunash?” tau. ");
INSERT INTO agr_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Tutai Jonatán ayaak: “Weajai ajanum wemi nunika awi ujaktagme”, tiuwai. Tusa ajanum weajui. ");
INSERT INTO agr_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Nuwi jeganta Jonatán Davitan chichajak: “Tuke Pujuu Israel aents aidauti Apajuí emematin ainag nuna daajin tajame. Kashin, nuniashkunuk kashin pujusa tsawakun mina apajush wajintig nuna dekaatjai. Tuja mantamatag tutsuk pegkegnum chichakuig, chichaman akuptuktatjame ujapaktinme tusan. ");
INSERT INTO agr_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Untsu mantamatag taun dekayatkun, wi amina agkan utugchat atsaunum tupikak uwemjati tusan ujakchamtaig, Tuke Pujuu suwimkan sujusti. ¡Tuke Pujuu mina apajun yaigkua dutiksag aminash yaimpakti! ");
INSERT INTO agr_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Nunak wika Tuke Pujuu daajin umiktinjun tajame. Tuja wi iwaku pujakuig wi amina yayajam dutiksamek, minash wait aneasam yainkatin ata. Tuja wi jakamtaishkam, ");
INSERT INTO agr_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","Tuke Pujuu amina shiwaajum aidaun ashí ijinamtaish mina uchig aidauk tuke wait anenjatin ata. ");
INSERT INTO agr_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Ame nunú umishtaik, Tuke Pujuu amina pataim aidaujai suwimkan amastinai”, tau. Aatus tusa Jonatán Davidjai chichaman umikajui. ");
INSERT INTO agr_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Nuadui Jonatán niina iyashi aneemaina imatikas Davitan aneau asa ataktu awagki niijai chichaman umikui. ");
INSERT INTO agr_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Nuna umika Jonatán Davitan chichajak: “Kashin nantu yama takau jiistamtai tsawan asamtai, ame ekemsa yuum duka agkan juwaktatui, nunikmatai wajukamki tujamiagtatui. ");
INSERT INTO agr_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Tuja kampatum tsawan wetai, wagkag imanikash megkaekae tusag, aminí senchi anentamiagtatui. Nuniktin asamtai ame yaunchuk uumkabium nuwi wetá nunikam kaya múun batsata nuna awin uumkam pujusta. ");
INSERT INTO agr_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Nuwi pujamin flechanash shiijash akenag taunig wajakin ame pujamunmanini kampatum flechan akenkattajai. ");
INSERT INTO agr_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","Dutikan mina inakjun chichagkun: ‘Flecha nagkimamu tikiju batsata nunú utita’, takui dekattame. Nunikam anenjas jiinkita, wagki nunak utugchat atsutin asamtai titatjai. Nunak Tuke Pujuu tutaya nuna daajin umiktinjun tajame. ");
INSERT INTO agr_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Untsu wi niina chichagkun: ‘Flecha nagkimamu imau kakeka nunú diista’, takuig dekaattame Tuke Pujuuwap weti tujutua tusam, nuniakum ¡tupikakta! ");
INSERT INTO agr_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Juju chicham umikag duka Tuke Pujuu ii emematin ainag nuna daajin tuke atin umikji”, tiajui. ");
INSERT INTO agr_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Aatus tusag Jonatán niina apaji pujusa inamtaijin wakettai, Davitak ikam kaya múun ayaunum nuna awin uumkatatus weuwai. Nuwi uumak pujai jiista jegamtai apu yujumka yuwatatus mesanum jeganta ekemsauwai. ");
INSERT INTO agr_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","Nii tuké ekemsa yutaijin tanisha tuntupek ekemsauwai. Nunikmatai Jonatán niina apajijai niinis ekemsauwai. Untsu Abner niina apajijai tsanias ekemsauwai. Tuja Davita ekemtaiji agkan juwakui. ");
INSERT INTO agr_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Nunú tsawantinig apuk Davidnak pachikchauwai, wagki pegkegchau takamsas eke iwagmamchau asa, sacerdote yuwinamunum pachiinak yumainchau asa, megkaekatai tau asa pachitsuk idaisauwai. ");
INSERT INTO agr_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Tuja kashinia duwi jiistabaunmashkam Davita ekemsa yutaijig nunisag agkan au. Nunitai Saúl niina uchiji Jonatágkan iniak: “¿Wagka Jesé uchijish yau yujumak yuwamunum tachma nunisagkesh yamaish tache?” tau. ");
INSERT INTO agr_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Tusa iniam Jonatán ayaak: “Davitak Belén wetajai tusa, wait aneasam tsawan sujusta tusa segatkui, ayu timajai. ");
INSERT INTO agr_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","Nuna segatak aatus tujutmae: ‘Mina pataag kuntinu maa apeak Apajuín emematiagtin asamtai, mina yatsug taata tusa untsugkae’, tujutmae. Nuadui juwi jiistamainun niina yachi emkau aidaujai Belégnum jiistamatjai tusa segatkui, ayu wetá timajai. Nuwi weu asa, jutijai ijunag yujumka yuwatsu nunak aniawai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Tusa tutai Saúl Jonatágkan shiig senchi kajejuk chichajak: “¡Dukuji detsetkauwa! ¿Wi dekatsjak Jesé uchiji amina shiig kumpagmia nuna? amek amina kumpajum yayau asam dukujai datsanmain juwakugme. ");
INSERT INTO agr_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Nuadui Jesé uchiji eke iwaku pujaigkik, amek makichkish Israel aents aidau apujig achattame. ¡Nunikaig tachakmek aents ishiakam David achika itagtuata maatjai!”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Tama Jonatán ayaak: “¿Tujash wagkag niish mantamnati? ¿Niish wajina pegkegchaunash dutikae mantamnatag tusash?” tau. ");
INSERT INTO agr_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Tujash Saúlak Jonatágnak aitsuk wajaakug nagki jukiuwai niina maatatus. Dutikam nii anentaimas dekas mina apag Davita maatag tawapi tiuwai. ");
INSERT INTO agr_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Nunik kajeka jimag tsawanta nunú jiista tsawagbaunum yujumkan yuwatatus mesanum eketu wajaki yujumkanak yutsuk ukukiuwai, wagki niina apaji Davitan maatatus datsantan chichaju asamtai. ");
INSERT INTO agr_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Tuja Davitak chichama ujatkachagtimpash tusa dakamak pujai, kashin tsawag Jonatán niina inake datsauchijai David uumak pujamunum weuwai. ");
INSERT INTO agr_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","Nunik jegantag niina inaken chichajak: “Tupikaki weme flecha aidaun akenkamag nunú egakta”, tiuwai. Tusa tima nunú uchi tupikaki wegau, nuniai Jonatán flechan nunú uchi weamun emtika atushat nagkimauwai. ");
INSERT INTO agr_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Nunú flecha nagkimamu tepaunum niina inake jeganmatai shiig senchi untsuka chichajak: “¡Flecha nagkimamag duka ame wajam nuna nagkaiki tepawai!” tau. ");
INSERT INTO agr_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Nuna tusa ataktushkam untsuak: “¡Wamak tupikakta, makichkish wajasaipa!” tau. Tuja nunú inakak flecha nagkimamun juki, niina apuji Jonatágkan itajuauwai. ");
INSERT INTO agr_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Tujash inakak Jonatán tuke aneas Davita ujaak tabaunak makichkish dekachui, wagki nunak Jonatán ima Davidjaig dekajakui. Nuadui nunú inakak mina apug nagkimtan unuimagtasampap nagkimua, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Nuna ashí dutika Jonatán nagkimtaiji aidaun jegá ejegata tusa niina inaken susauwai. ");
INSERT INTO agr_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Dutika susam wakitkimtai, David kaya ayaunum uumak pujau jiinki Jonatán wajamunum jeganta, niina eme anentus tsuntsuma kampatuma imania nijayin nugkan antigkui. Nuadui pagkunik kumpamdayinak egaanidau, nunik David buutbaun mijaakui. ");
INSERT INTO agr_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Nunikmatai, Jonatán Davitan chichajak: “Ii chicham umikuitag duka Tuke Pujuu daajin umikmaiji, nuniau asamtai puyattsuk wetá. Tuke Pujuu amina, tuja mina, nuigtu ii uchiji wegantu aidaunash kuitamkatin ati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Saúl maatag tama David tupikaki sacerdote Ahimélec pujamunum weuwai. Nunik minittaman sacerdote wainak puyatuk iniak: “¿Wagka ima amekesh miname?” tau. ");
INSERT INTO agr_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Tama David ayaak: “Chicham dekaata tusa apu tujutmatai minajai. Tujash wagkag minash awetime nunak makichik aentskesh dekamainchau ainawai. Nuigtushkam wajina dutikata tusag akuptukmae nunashkam dekamainchau ainawai. Untsu mina aentsug aidaunak yaja batsakmajai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Nuna tusa sacerdoten iniak: “Namputchawame ¿aminush yumainush atsugtamuak? Ajutjamkuig cinco pag ajamjusta, untsu pag atsakuig waji awa dukesh sujusta”, tau. ");
INSERT INTO agr_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Tusa tama sacerdote ayaak: “Pag wainka yutai aina duka atsugtawai, ayatak Apajuí anagkuamu sacerdote yutaya duke awai. Untsu atumesh ijagmajum yujakjuminig nuna amamainaitjime”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Tutai David ayaak: “Maaniatasa shimakuik nuwajaig tsanichu ainaji. Tuja yamaishkam nunisaik maaniatasa yujachiatku, ii jeen pujauti jiinjamiag duwi nagkamsa ijagma yujaji”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Tusa timatai pag yama najanamu Apajuí anagkuamu aidaun nunú tsawantin jega pegkegmanum sacerdote awaya ukuak, pag yaunchuk najanamu aidau atatman yajuaka ukukbaujin tikich yumainuk atsau asamtai, nuna juki Davitan susauwai. ");
INSERT INTO agr_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Makichik tsawantin Saúl filisteo aidaun pataetuk wejiuwai. Nunik wejiu waketkama Davitak En-gadi nugkanum uwejush pujawai tabaun dekauwai. ");
INSERT INTO agr_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Nunik dekaa ashí Israel aents aidaunmayan etegkeg tres mil suntaja yajuak, David niina aentsji aidaujai chivo batsamtaiji kaya múun pagkaju weajunum pujau asamtai wejiuwai. ");
INSERT INTO agr_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Nunik wea weakua uwija wenuken ijus waa aunum David niina aentsji aidaujai uumak pujamunum jegantui. Nunik juwimpap uumak pujawa tachau asa, wakenum wetatus nunú waanum waigkui, ");
INSERT INTO agr_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","nunik waittaman Davita aentsji aidau wainkag Davitan ashishmas chichajuinak: “Tuke Pujuu amina chichagtamak: ‘Shiwajumnak amina idaitustatjame’, tujabauwa nunú betek uminui. Nuadui ame itugkatagtame dutikata”, tuidau. Tusa tama David wajaki diipas jegantun Saúla jáanchji jawajin tsupijuk jujukiuwai. ");
INSERT INTO agr_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Nuna dutikashkam dekas aikmainchaunap aikaja tusa awake anentaimjauwai. ");
INSERT INTO agr_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","Nuniak niina aentsji aidaun ashishmas chichajak: “Wika apunak maumaitsujai, wagki niinak Tuke Pujuu apu ati tusa etegkamu asamtai”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Tau asa niina aentsji aidaun, Saúl maawaigpa, tusa tiuwai. Tusa mautsuk idaisam nunú waanmaya jiinki weuwai. ");
INSERT INTO agr_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Nunik jiinki wegaig, David nunú waanmaya jiinki untsumak: “¡Apuh, mina apujuh!” tau. Tutai Saúl ayampa diyau, dutikam David niina eme anentus tikishmag nijayin nugka antig pujusui. ");
INSERT INTO agr_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Nunik pujus chichajak: “¿Wagka apuju tikich aents ujapainak, David pegkegchau awajtamkatag tawai tusa ujapainakuish dusha antugme? ");
INSERT INTO agr_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Amesh yamai dekaume Tuke Pujuu aminak wi pujamunum awetabiu aig, amina mautan dakitau asan tsagkujamjame. Wi anentaimsan Tuke Pujuuwap apu ati tusa etegkauwaita tau asan idaisajame. ");
INSERT INTO agr_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","“Juju wi takakag juju diista. Juka ame jáanchjum nugkuajam nuna jawajin tsupika jukimjai. Nuna tsupikmag nuaduik aminak maumain awajkamjame, tujash dutikashmajame. Nuadui dekamainaitme, wi amina pegkegchau awagmatan dakitag nunú. Tuja nuigtush pegkegchaunak takagchauwaitjame, dutikamaitkum mantuatasam aintame. ");
INSERT INTO agr_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Dekas Tuke Pujuu diigmas, yakita pegkegchaush nuna tujamti. Untsu wika aminak makichkish maashtatjame. ");
INSERT INTO agr_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Yaunchuk tibau awai: ‘Aents pegkegchauk pegkegchaunak takawai’, nuadui wika aminak tuke maumaitsugme. ");
INSERT INTO agr_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","Nuigtushkam wika eme anentsa diitaigkesh atsujai. Nuninaitag nunin aish, amesh ya pataetukmea ibau apumesh pujusa inamtaijum ukuakmesh, imajui uwegshunmash taume. ¡Amek auk yawá nujantai jau, nuniachkush sugku maatasa ainmaina numamtin pataetugkum tsawan megkaeme! Makichkish aan wekaemainchau aniame. ");
INSERT INTO agr_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Nuadui wika: ‘Yakita pegkegchaush nuna diis Tuke Pujuu tujamti’, tajai. Tuja nii mina takatjun diigtus duwi ame mantuatag tame nunashkam ayamjutkati”, tiuwai. ");
INSERT INTO agr_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Tusa inagnakmatai Saúl untsumak: “¡Amekaitam Davitah, mina uchijuh, ya minash tujutua!” tusa Saúl buutu. ");
INSERT INTO agr_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Nunik buutki chichajak: “Ame tame duka dekaske, wi amina maatasa ainmaitkum, ame mina pegkegnum iiktukume. ");
INSERT INTO agr_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Yamai dekamtijuaume ame mina pegkegnum yaintam nunú. Wagki Tuke Pujuu maati tujabiu aig, ame mina mantuachume. ");
INSERT INTO agr_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Makichik aents niina shiwaajin igkuakug, tuke pegkegchau awajkatatus wakenai. Tuja amek nuninchau asam mina mantumain ayatkum, wait anenjuju asamin, ¡Tuke Pujuu aminash yaimpakti tajame! ");
INSERT INTO agr_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Yamaik shiig dekajai ame dekas apu 