﻿USE sofia;
DROP TABLE IF EXISTS sofia.agn_vpl;
CREATE TABLE agn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES agn_vpl WRITE;
INSERT INTO agn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yay narin tang listan tang mga kamepet-mepetan ang pinagalinan ni Jesu-Cristo, ang inampo ni David ang yay ang inampo ni Abraham. ");
INSERT INTO agn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham tatay ni Isaac, si Isaac tatay ni Jacob, ig si Jacob yay ang tatay ni Juda may ang mga logod na. ");
INSERT INTO agn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda nangatawa ong ni Tamar ig doroa tang ana nira, si Fares ig si Zara. Si Fares tang tatay ni Esrom, ig si Esrom tang tatay ni Aram. ");
INSERT INTO agn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram tatay ni Aminadab, si Aminadab tatay ni Naason, ig si Naason tang tatay ni Salmon. ");
INSERT INTO agn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon nangatawa ong ni Rahab ig si Boaz tang ana nira. Si Boaz tang tatay ni Obed ig ang nanay ni Obed si Ruth. Si Obed ang na tatay ni Jesse, ");
INSERT INTO agn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ig si Jesse tang tatay ni Ading David. Si David tatay ni Solomon, ig ang dating katawa ni Urias yay ang nanay ni Solomon. ");
INSERT INTO agn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon tang tatay ni Rehoboam, si Rehoboam tatay ni Abias, ig si Abias tatay ni Asa. ");
INSERT INTO agn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa tatay ni Jehoshafat, si Jehoshafat tatay ni Joram, ig si Joram tatay ni Ozias. ");
INSERT INTO agn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Ozias tang tatay ni Jotam, ig si Jotam tatay ni Acaz ang yay ang tatay ni Ezequias. ");
INSERT INTO agn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Ezequias tatay ni Manases, si Manases tatay ni Amos, ig si Amos tatay ni Josias. ");
INSERT INTO agn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josias ang na tatay ni Jeconias may ang mga logod na. Yay asi tang timpo nga ang mga Israelita biniag tang mga taga Babilonia ig ingkelan don ong banoa nira. ");
INSERT INTO agn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pagatapos ang ingkelan tanira ong Babilonia, nagkatinir si Jeconias tang ana nang si Salatiel. Si Salatiel tang tatay ni Zerubabel. ");
INSERT INTO agn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Zerubabel tatay ni Abiud, si Abiud tatay ni Eliakim, ig si Eliakim tatay ni Azor. ");
INSERT INTO agn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Azor tatay ni Sadoc, si Sadoc tatay ni Aquim, ig si Aquim tatay ni Eliud. ");
INSERT INTO agn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud tang tatay ni Eleazar, ig si Eleazar tatay ni Matan ang yay ang tatay ni Jacob. ");
INSERT INTO agn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jacob tang tatay ni Jose ang nagimong katawa ni Maria. Ig si Mariang narin yay ang nanay ni Jesus ang aggoyan ta Cristo. ");
INSERT INTO agn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Animan, magalin ong ni Abraham sa-sad ong ni David katorsing hinirasion tang namagdalalaton. Ig magalin ka ong ni David asta ong timpong ingkelan tang mga Israelita ong Babilonia, katorsi si kang hinirasion tang namagdalalaton. Ig magalin ka don sa-sad ong pagpangana ong ni Cristo, katorsing hinirasion ka. ");
INSERT INTO agn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maning ta na tang nainabo asing pinangana si Jesu-Cristo. Si Mariang nanay na karasalen da lamang ong ni Jose. Piro asing indi pa tanira paga-pen, nata-wanan ang pagabdet pala si Maria. Piro ong matod, nainabo narin tenged ong gaem tang Ispirito Santo. ");
INSERT INTO agn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mandian si Jose, ang magimong katawa na, mato-lid ang taw. Animan naisipan nang belagan na ra lamang si Maria. Piro boaten na narin ong sikrito tenged indi ka galiag ang mapaeyak tang babay. ");
INSERT INTO agn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mintras aggisipen ni Jose tang boaten na, may tatang anghil tang Gino ang napaita ong ni Jose ong talakinep na ig ganing ong nandia, “Jose, inampo ni David, india magdoadoa ang katawaen mo si Maria. Tanandia nagabdet ong gaem tang Ispirito Santo. ");
INSERT INTO agn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mangana tanandia ta tatang lali, ig paranan mo ta Jesus, tenged tanandia tang maglibri ong mga kasimanoa na ong mga kasalanan nira.” ");
INSERT INTO agn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nainabo tang tanan ang na agod magmatod tang inaning tang Dios ig pinatako tang propita na asing tokaw pa ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Magabdet tang tatang soltiras ang indi pa galengetan ta lali ig mangana ta tatang lali. Ig goyan tanandiang Emmanuel” (ang maliag nang yaning, “Ka-pen ta tang Dios”). ");
INSERT INTO agn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Animan asing pagapoaw ni Jose, sinoman na tang tobol tang anghil tang Gino ig dayon ang pinakasalan na si Maria. ");
INSERT INTO agn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Piro inding pisan nalenget si Jose ong ni Maria mintras indi pa gapangana ong inabdet nang asi. Ig pagapangana ni Maria, pinaranan ni Jose tang mola ta Jesus. ");
INSERT INTO agn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Si Jesus don pinangana ong Betlehem, sakep tang probinsia tang Judea, asing timpo tang ading si Herodes. Ong timpong asi, may pirapang taw ang kiminabot ong siodad tang Jerusalem nagalin ong Tere-lan. Ang mga laling narin morosay ig gatako tang maliag yaning tang mga bitokon, ");
INSERT INTO agn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","animan namane-ma te-ma ong mga taw ang ganing, “Ong aripa dilemen amen tang molang pinangana, ang adi tang mga Judio? Inita amen tang bitokon don ong Tere-lan ang yay pagpasinial ang tanandia pinangana ra. Animan napaning ami tarin para lomod ong talongan na ig towan amen tanandia.” ");
INSERT INTO agn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pagabasi ni Ading Herodes ang may ba-long adi ono, pisan tanandiang naborido, asta ang tanan ang taw ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Animan pinagoy ni Herodes tang tanan ang mga pangolokolo ong mga padi tang mga Judio ig ang mga manigtoldok tang Katobolan ni Moises. Nane-ma tanandia ong nira mga ong aripa ono ipangana tang Cristo. ");
INSERT INTO agn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ganing tanirang siminabat, “Ong banoa tang Betlehem, tarin ong Judea. Tenged maning ta na tang sinolat tang propita tang Dios asing tokaw ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yamong mga taga Betlehem ang pamansistar ong probinsia tang Judea, ang banoa mi indi enged maori ong mga banoa ang pamanokaw-tokawan ong Judea. Tenged atan ong nindio magalin tang mangolokolo ang magekel ong yen ang banoa, ang yay ang mga inampo ni Israel.’ ” ");
INSERT INTO agn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pagabasi ta asi ni Herodes, dayon ang pinagoy na ong sikrito tang mga bisitang asing nagalin ong Tere-lan. Pinane-ma na tanira ta mo-ya mga tanopa enged limindoa tang bitokon ang agganingen nirang inita nira. ");
INSERT INTO agn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Oman pinapaning na ra tanira ong Betlehem pagatapos ang sinoyonan na ta maning ta na: “Panaw amo ra. Dilemen mi ta mo-ya tang molang asi. Ig mga itaen mi, patakono nindio, agod asta yo mapaningo ka don para towano tanandia.” ");
INSERT INTO agn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Pagabitala tang adi, namampanaw da tanira. Mintras pamansipanaw, inita si nirang oman tang bitokon ang asing inita rang lagi nira ong Tere-lan. Pinangambengan tanira ta mo-ya ong pagaita nira tang bitokon! To-kaw ong nira tang bitokon asta siminareng don ong toga tang balay ang don tang mola. ");
INSERT INTO agn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Oman, paga-led nira ong balay, inita nira tang mola ig ang nanay nang si Maria. Dayon tanirang namansilod ong talongan tang mola ig tinowan nira tanandia. Inabrian nira tang mga ekel nira, ig rinigaloan nira ta bolawan, insinso, ig pabanglong aggoyan ta mira. ");
INSERT INTO agn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Asing pabalik da tanira ong sadiling logar nira, parti rang dalan tang pinanawan nira, tenged pinamanan tanira tang Dios ong talakinep ang indi ra tanira magbalik don ong ni Herodes. ");
INSERT INTO agn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Asing pagapagalin da tang mga bisita, napaita ong ni Jose tang tatang anghil tang Gino ong talakinep na ig ganing ong nandia, “Bangon! E-lan mong lagi mandian tang mola may ang nanay na don ong Ehipto. Don amo kang lagi magtinir mintras indio pa pagordin ang magbalik amo ra. Agpadilem ni Herodes tang mola para patayen.” ");
INSERT INTO agn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Animan dali-daling nambangon si Jose, ig ong labing asi mismo ingkelan na tang magnanay ig namampanaw da paning ong Ehipto. ");
INSERT INTO agn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Don tanira nagtinir asta napatay da lamang si Herodes. Nainabo narin agod magmatod tang inaning tang Dios ig pinasolat na ong propita na ang ganing, “Ginoyano tang anao ang magalin ong Ehipto.” ");
INSERT INTO agn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Dorong kasisilagen ni Ading Herodes asing mata-wanan nang linoko tanandia tang mga bisitang asing nagalin ong Tere-lan. Animan nagpapanaw tanandia ta ordin ang pamatayen tang tanan ang mamolang lali ong Betlehem asta ong tanan ang mga kababarioan ang alenget don, magalin ong doroang takon tang idad nira pababak. Tenged sigon ong nata-wanan na ong mga bisitang namagalin ong Tere-lan, doroa rang takon tang nagta-lib mimpisang limindoa tang bitokon. ");
INSERT INTO agn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ong nainabong asi, nagmatod tang inaning tang propitang si Jeremias asing tokaw ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“May gaba-yan ang mga i-yak ig pagdayag ong bario tang Rama. Aggi-yakan ni Raquel tang mga ana na. Indi enged mapalipay ong sobrang kapongawan na tenged ong mga ana nang patay da.” ");
INSERT INTO agn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mandian, pagapatay ni Herodes, napaita sing oman tang tatang anghil tang Gino ong ni Jose ong tatang talakinep, asing don pa tanira ong Ehipto. ");
INSERT INTO agn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ganing tang anghil, “Ta ra! E-lan mo tang mola may ang nanay na ig magbalik amo ra don ong Israel, tenged patay da tang mga namagplanong patayen tang mola.” ");
INSERT INTO agn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Animan nagsimpan si Jose ig ingkelan na tang mola may ang nanay na pabalik ong Israel. ");
INSERT INTO agn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Piro pagabasi ni Jose ang si Arquelao ya ray siminlet ong tatay nang si Herodes bilang adi ong probinsia tang Judea, inledan tanandiang molik don. Animan asing pinamanan sing oman tanandia tang Dios ong tatang talakinep, nagdayon tanira ong probinsia tang Galilea. ");
INSERT INTO agn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ig don tanira ministar ong banoa tang Nazaret. Nainabo narin agod magmatod tang inaning tang Dios ig pinatako tang mga propita na asing tokaw ang ganing, “Goyan tanandiang Nazareno.” ");
INSERT INTO agn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mandian, pagata-lib tang mga takon, kiminabot tang timpong si Juan ang Manigboniag napaning don ong kabobokidan tang Judea ig nagimpisang nagtoldok ong mga taw ang agpaning ong nandia ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Magtogat amo ig bo-wanan mi ra tang mga kasalanan mi, tenged alenget dang maggaem tang Dios tarin ong kalibotan!” ");
INSERT INTO agn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan ya ray ang agganingen tang propitang si Isaias asing minaning tanandia, “May paginiteg don ong logar ang anday gistar ang taw ang ganing, ‘Simpanen mi tang paranawan tang Gino! To-liden mi tang mga dalan ang panawan na!’ ” ");
INSERT INTO agn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Si Juan, ang lambong na bindoat ong bolbol tang kamilio ig ang a-ket na olit ka ta ayep. Ang pamangan na poros siba-la may lanaw. ");
INSERT INTO agn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kadoro-doroan tang mga taw ang namansipaning don ong nandia. Namagalin tanira ong Jerusalem, ong tanan ang mga banoa tang probinsia tang Judea, ig ong mga kababarioan ang alenget ong soba ang aggoyan ta Jordan. ");
INSERT INTO agn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Aggaminen nira tang mga talak nira oman agboniagan tanira ni Juan ong soba. ");
INSERT INTO agn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Piro asing itaen ni Juan tang yading mga Pariseo ig mga Saduseo ang pamansilenget ong nandia para magpaboniag, ganing tanandia ong nira, “Mga ma-kal amo! Angay kaisip mi ang palibri amo ong silot ang ipakabot tang Dios? Sinopay naganing ta maning ta si ong nindio? ");
INSERT INTO agn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mga matod ang pamagtogat amo ra ong mga talak mi, ipaita mi ong mga boat mi. ");
INSERT INTO agn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Indi amo manalig ang indi amo silotan tenged lamang mga inampo amo ni Abraham. Agganingo ong nindio, maski ngani ang mga batong na, poiding boaten tang Dios ang magimong mga ana ni Abraham, mga galiliag lamang tanandia. ");
INSERT INTO agn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Alenget dang silotan tang mga taw! Ang kaparioan nira mga papa ta ayong alenget dang pe-peten. Tenged ang kada papa ta ayo, mga indi pamorak ta masinlo, pe-peten lamang ig sirokon. ");
INSERT INTO agn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Agboniagan amo yen ong wi bilang tanda ang namagtogat amo ra. Piro may komabot ang domaton ong yen ang magboniag ong nindio ong Ispirito Santo ig ong apoy. Mas alawig tang dengeg na ong yen, ig belago ta bagay ang magsirbi ong nandia maski ngani magekel tang rapak na. ");
INSERT INTO agn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Listo ra tanandiang ipabelag tang moro-ya ong malalain, pario tang pagpakolay ta paray. Simeten tang simlat ig i-tang ong dispinsa. Piro sirokon tang kepa ong apoy ang indi mapatay-patay asta ong tanopa.” ");
INSERT INTO agn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Asing timpong asi, kiminabot da kaman si Jesus don ong soba tang Jordan, nagalin ong probinsia tang Galilea. Napalenget tanandia ong ni Juan para magpaboniag, ");
INSERT INTO agn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","piro indi rin maliag si Juan tenged ganing tanandia, “Angay yaway magpaboniag ong yen? Dapat yo tang magpaboniag ong nio!” ");
INSERT INTO agn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Piro ganing si Jesus, “Paoyona ra lamang, tenged maning ta na tang dapat boaten ta agod matoman tang tanan ang kaliliagan tang Dios.” Animan napaoyon da si Juan ig binoniagan na si Jesus. ");
INSERT INTO agn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pagatapos ang maboniagan si Jesus, siminakat ang lagi tanandia magalin ong soba. Dayon ang laging nagabri tang langit, ig inita ni Jesus tang Ispirito tang Dios ang agpababak ang maga lare, ig siminogpo ong nandia. ");
INSERT INTO agn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ig may tatang bosis ang nagalin ong langit ang ganing, “Na tang agmalenong Anao. Galipayo ta mo-ya ong nandia.” ");
INSERT INTO agn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pagatapos ta si, ingkelan si Jesus tang Ispirito Santo don ong tokawan, don ong logar ang anday tataw na, para tokson tanandia ni Satanas. ");
INSERT INTO agn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ong teled tang epat ang polok ang kaldaw ig epat ang polok ang labi, inding pisan pamangan si Jesus, animan linetem tanandia. ");
INSERT INTO agn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Oman kiminabot tang Manigtokso ig ganing, “Mga yawa ka kaman tang Ana tang Dios, tobolon mo tang mga batong na ang magimong tinapay.” ");
INSERT INTO agn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Piro siminabat si Jesus, “Na-tang ong Sagradong Kasolatan, ‘Belag lamang ta ong pamangan gaboi tang taw. Kaministiran na ka tang tanan ang mga bitala tang Dios.’ ” ");
INSERT INTO agn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pagatapos ingkelan ni Satanas si Jesus don ong Sagradong Siodad tang Jerusalem, ong talibobongan tang Timplo. ");
INSERT INTO agn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ganing si Satanas ong nandia, “Mga yawa ka kaman tang Ana tang Dios, abir, pabo-loga atan! Tenged na-tang ong Kasolatan, ‘Tobolon tang Dios tang mga anghil na para bantayana nira. Biotana nira agod maski ang kakay mo inding pisan masigbak ong bato.’ ” ");
INSERT INTO agn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Piro siminabat sing oman si Jesus, “Na-tang ka ong Kasolatan ang ganing, ‘Indi sobokan mi tang Ampoan ming Dios.’ ” ");
INSERT INTO agn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Oman dayon sing ingkelan ni Satanas si Jesus ong tatang bokid ang dorog kalawig. Pinaita na ong ni Jesus tang tanan ang mga nasion ig mga inadian ong kalibotan, asta ang mga manggad nira. ");
INSERT INTO agn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Oman ganing si si Satanas ong ni Jesus, “Ang tanan ang narin i-dolo ong nio, mga lomoda ong talongano ig ilalaeno nio bilang Dios mo.” ");
INSERT INTO agn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Siminabat si Jesus, “Lomayasa tarin, Satanas! Tenged na-tang ong Kasolatan, ‘Ang Ampoan mong Dios lamang tang ilalaen mong Dios. Tanandia lamang tang sirbian mo.’ ” ");
INSERT INTO agn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ig dayon ang nagalin si Satanas, ig ang mga anghil tang Dios namansikabot ig namagasikaso ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pagatako ni Jesus ang agprison da si Juan ang Manigboniag, minolik tanandia ong probinsia tang Galilea. ");
INSERT INTO agn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Piro indi ra tanandia ministar ong Nazaret, kondi don da nagtinir ong Capernaum. Ang banoang na ong binit tang baybay tang Talsi tang Galilea, alenget ong mga tiritorio tang Zabulon ig Neftali. ");
INSERT INTO agn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Don si Jesus nagtinir agod mainabo tang inaning tang propitang si Isaias asing tokaw ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ang mga tiritorio tang Zabulon may ang Neftali ang alenget ong Talsi, don ong dobali tang soba tang Jordan, ig yay ang mga logar tang Galilea ang gistaran tang yading mga belag ta Judio— ");
INSERT INTO agn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ang mga taw ang pamansistar ong mga logar ang na, gangabo-wan ong maki-lep ig ong gaem tang kamatayen. Piro mangaita tanira ta sinag ang dorog kayag, ang yay ang magtorol ta kayagan ong mga kinaisipan nira.” ");
INSERT INTO agn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Animan asing oras ang asi, don nagimpisa rang nagtoldok si Jesus. Ganing tanandia, “Magtogat amo ig bo-wanan mi ra tang mga kasalanan mi, tenged alenget dang maggaem tang Dios tarin ong kalibotan.” ");
INSERT INTO agn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tatang kaldaw, mintras papanaw si Jesus ong binit tang baybay tang Galilea, may inita nang doroang manigyan ang pamana-tak ta lambat. Tanira ay si Simon, ang aggoyan ka ta Pedro, ig ang logod nang si Andres. ");
INSERT INTO agn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ganing si Jesus ong nira, “Tomabid amo ong yen, agod imbis ang magyan amo, toldokan amo yen para maekelan mi tang mga taw agod mamagparet tanira ong Dios.” ");
INSERT INTO agn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ig lagi-lagi bino-wanan nira tang lambat nira ig siminabid da ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pagatokaw-tokawan nira ta ge-ley, inita ka ni Jesus tang doroa sing maglogod ang da Santiago ni Juan, ang mga ana ni Zebedeo. Don tanira ong bilog nira, aroman tang tatay nira, ang pamagsinsay tang lambat nira. Ginoyan ni Jesus tang doroang maglogod ");
INSERT INTO agn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ig dayon ang laging bino-wanan nira tang bilog asta ang tatay nira, ig siminabid ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Linibot-libot ni Jesus tang bilog ang probinsia tang Galilea ang pagtoldok ong mga simban tang mga Judio. Pinatako na tang Mo-yang Balita natetenged ong paggaraemen tang Dios bilang adi, ig pinao-ya na tang mga taw ong tanan ang mga masit nira ig maski onopay agba-yagen nira. ");
INSERT INTO agn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nabantog tanandia asta don ong bilog ang logar tang Siria, animan pinangekelan tang mga taw ong nandia tang tanan ang pamagmasit ig ang mga agpanliwagan da ong mga masit nira. May atan kang mga aggaeman ta mga malalain ang ispirito, may mga paralisado, asta ang may masit nirang kere. Tanirang tanan pinao-ya ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tenged tarin kadoro-doroan tang mga taw ang namansitabid ong nandia. Namagalin tanira ong probinsia tang Galilea ig don ong Decapolis, ong siodad tang Jerusalem, ig ong domang mga banoang sakep tang probinsia tang Judea. May atan kang namagalin ong dobali tang soba tang Jordan. ");
INSERT INTO agn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Asing pagaita ni Jesus ang kadoro-doroan tang mga taw, napanaw tanandia ig siminakat ong tatang bokid. Pagakarong na don, namampalenget ong nandia tang mga sinagpan na, ");
INSERT INTO agn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ig pinanoldokan na tanira ta maning ta na: ");
INSERT INTO agn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Masoirti tang mga taw ang aggakon nira ang kaministiran nira tang Dios, tenged tanira tang mabilang ong inadian tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Masoirti tang mga pamagsinti, tenged lipayen tanira tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Masoirti tang mga dibabak ta nem, tenged tanira tang marisibi tang tanan ang pinangako tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Masoirti tang mga taw ang dorong prosigir nirang tomanen tang kaliagan tang Dios, tenged tabangan na tanira agod bogos ang maboat nira si. ");
INSERT INTO agn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Masoirti tang mga masine-bekanen, tenged tanira ate-bekan ka tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Masoirti tang mga taw ang limpio tang mga popotokon nira, tenged tanira tang maita ong Dios. ");
INSERT INTO agn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Masoirti tang mga pamagayos ta mga soroayen, tenged tanira tang ibilang tang Dios ang mga ana na. ");
INSERT INTO agn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Masoirti tang mga taw ang aggakigan ig agpaliwagan tenged lamang ong pagtoman nira ong kaliagan tang Dios, tenged tanira tang mabilang ong inadian na. ");
INSERT INTO agn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Masoirti amo mga agginsolton amo ta mga taw natetenged ong yen, ig mga agpaliwagan amo ig agbandanan tang tanan ang klasi ta kalainan ang poros bo-li. ");
INSERT INTO agn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dapat mangalipay amo ta mo-ya, tenged dorog kasinlo tang balet ang marisibi mi don ong langit. Demdemen mi, ang agboaten nirang asia ong nindio, pario ka tang bindoat tang mga taw ong mga propita asing tokaw.” ");
INSERT INTO agn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yamong mga sinagpano, ang kalimbawan mi midio kasin amo para ong mga taw tarin ong kalibotan. Piro mga ang kasin manlasay da, indi ra poiding mapakasin pang moman. Animan anda ray pakinabang na, kondi i-lek da lamang ig maliked-likedan ta mga taw. ");
INSERT INTO agn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ang kalimbawan mi pario ka ong tolok ang pagtorol ta kayagan ong mga taw tarin ong kalibotan. Demdemen mi, mga may siodad ang pina-deng ong ta-paw tang bokid sia indi enged matalok. ");
INSERT INTO agn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ya ka, anday pagsindi ta kingki oman dapan na ta gantangan, kondi i-tang na lamang ong borondoan ta pa-kal agod masinagan tang tanan ong teled tang balay. ");
INSERT INTO agn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Animan maning ka atan tang boaten mi. Payagen mi tang pa-kal mi ong talongan tang mga taw, agod itaen nira tang mga mo-yang boat mi ig dayawen nira tang Tatay mi ong langit.” ");
INSERT INTO agn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ganing pa si Jesus, “Indi enged isipen mi ang napaningo tarin para lipateno tang Katobolan ni Moises ig ang mga pinatako tang mga propita. Napaningo tarin belag ta maning para lipaten kondi agod mainabo enged tang tanan ang sinolat nira. ");
INSERT INTO agn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tandan mi na: Mintras atan pa tang langit may ang tanek, anda enged ay parti tang Katobolan ang poiding baliwalaen. Maski pa ang kage-leyan ang korit ong tanga bitalan na, inding pisan malipatan ta importansia na mintras indi pa gainabo tang tanan ang kaliliagan tang Dios ang ga-tang ong Katobolan. ");
INSERT INTO agn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Animan ang sinopay magbaliwala maski tatang malakan ang tobol tang Dios, ig magtoldok ong doma ang maski indi ra ka tomanen nira, ang taw ang asi ipabetang ang kadibabakan ong tanan ong inadian tang Dios. Piro ang sinopay magtoman tang mga tobol tang Dios, ig magtoldok ong doma ang magtoman tang tobol na, tanandia oldan ta kadengegan ong inadian tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Animan agganingo ong nindio: Kaministiran ang pagtoman mi ong kaliagan tang Dios somobra pa ong pagtoman tang mga Pariseo ig manigtoldok tang Katobolan. Tenged mga belag, indi amo enged ma-pen ong inadian tang Dios.” ");
INSERT INTO agn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ganing pa si Jesus, “Gata-wanan ming asing tokaw ang yaten ang mga kamepet-mepetan sindolan tang tobol tang Dios ang ganing indi tanira mamatay ta taw, tenged maski sinopay mamatay manabat ong osgado. ");
INSERT INTO agn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Piro mandian agganingo ong nindio: Maski gasilag lamang tang tatang taw ong masig ka taw na, manabat da tanandia ong osgado. Ig ang maski sinopay manginsolto ong masig ka taw na, tomalonga ka ong kalawigan ang korti. Ig ang taw ang maganing ong masig ka taw na ang ‘Anday kointa mo!’ alenget dang sintinsian ong apoy ang indi enged mapatay-patay, don ong impirno. ");
INSERT INTO agn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Animan maski dona ra ong altar ong Timplo ang pagekel tang ibolontad mo ong Dios, oman mga mademdeman mo ang may galainan ta nem ong nio tang logod mo, ");
INSERT INTO agn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ibo-wan mo kang lagi tang bolontad mo don ong may altar, paningan mo kang lagi tang taw ang asi agod magigtomboya ong nandia. Pagatapos ba-loa magbalik ong Timplo ig magtorol tang bolontad mo ong Dios. ");
INSERT INTO agn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Pabetang ta, mga yawa dinimanda ta tatang taw, magigayosa ang lagi ong nandia mintras indi amo pa gakabot ong korti. Tenged mga don amo ra ong osgado, itaben yintrigā tang osgado ong goardia ig dayona rang prison. ");
INSERT INTO agn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ong matod, india enged maloa don asta indi malobot mong mabayadan tang molta mo.” ");
INSERT INTO agn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Gata-wanan mi ka tang tobol asing tokaw ang ganing, ‘Indi amo mangombabay obin mangonlali.’ ");
INSERT INTO agn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Piro mandian agganingo ong nindio: Mga ang tatang lali maski ong pama-dek na lamang ong babay may malain ang aggisipen na, sia pario ra ka ang pangombabay tanandia. ");
INSERT INTO agn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Animan mga ang mata mong to yay ang gagikanan ang yawa pagkatalak, koaten mo ig ibanggil! Tenged mas mo-ya pang maski malipatana tang tanga partian tang sinangoni mo, belag lamang tang bilog ang sinangoni mo tang i-lek ong impirno. ");
INSERT INTO agn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ig mga ang kalima mong to ya kay ang pagekel ong nio ang magkatalak, potolon mo ig ibanggil! Mo-ya pang maski malipatana tang tanga partian tang sinangoni mo, belag lamang tang bilog ang sinangoni mo tang i-lek ong impirno.” ");
INSERT INTO agn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Asing tokaw may katobolan ka ang ganing, mga ang lali ono galiliagan nang belagan tang katawa na, kaministiran oldan na tang babay ta kasolatan bilang ka-telan ang tanandia binelagan na ra. ");
INSERT INTO agn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Piro mandian agganingo ong nindio, mga belagan tang lali tang katawa na tenged ong maski onopay dailan, poira lamang mga nangonlali tanandia, ang lali mismo tang pagtolmon ong katawa na ang magkatalak. Tenged mga pakatawa si tang babay ong doma, magigdolog tanandia ong belag ta matod ang katawa na. Ig ang maski sinopay mangatawa ong nandia, loloang pangombabay ka tanandia.” ");
INSERT INTO agn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ganing pa si Jesus, “Gata-wanan mi ka, asing tokaw ang mga kamepet-mepetan ta pinamanan ang mga may pinangako nira ig sinompan nira pa ong aran tang Gino, kaministiran ang boaten nira enged. ");
INSERT INTO agn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Piro mandian yo, agganingo ong nindio: Mga mangako amo, indi amo enged manompa ang gamiten tang aran tang Dios obin maski onopang bagayay. Indi amo maganing, ‘Pa-dek tang langit!’ tenged don kakarong tang Dios ong trono na. ");
INSERT INTO agn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Obin maning, ‘Pa-dek tang tanek!’ tenged yay ang borondoan tang kakay na. Indi amo ka maganing, ‘Pa-dek tang Jerusalem!’ tenged yay ang siodad tang makagagaem ang Adi. ");
INSERT INTO agn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Indi amo ka maganing ang, ‘Sompano! Mapatayo pa!’ Tenged ang Dios tang pagbiot tang kaboi mo. Maski ngani tang naet ang boa tang kolo mi, indi maboat ming magimong koban obin indi. ");
INSERT INTO agn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Animan mga may boaten mo, mo-ya pa maning amo ra lamang, ‘Ee’ mga ee, ig ‘Indi’ mga indi. Tenged mga dolangan mi pa ta mga panompa-sompa, sia pagalin ong ni Satanas.” ");
INSERT INTO agn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Gata-wanan mi ka tang katobolan asing tokaw ang ganing, ‘Ang sinopay nagkoat tang mata tang kapario na, kaministiran ang koaten ka tang mata na. Ig ang sinopay nagbingaw tang isi tang kapario na, dapat bingawen ka tang isi na.’ ");
INSERT INTO agn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Piro mandian agganingo ong nindio, mga may taw ang nagboat ta malain ong nio, india ra melet. Pabetang ta, mga tampalingena ong emet mong to, ipatalonga mo pa tang dobali. ");
INSERT INTO agn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ig mga may magdimanda kontra ong nio agod makomit na tang lambong mo, i-dol mo asta ang takol mo. ");
INSERT INTO agn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mga paregesena ta tatang sondalo ang papagtakanen tang karga na ta tang kilomitro, takanen mo narin sa-sad pa ong doroang kilomitro. ");
INSERT INTO agn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Oldan mi tang mga pamama-dol ong nindio, ig palbeten mi tang mga mamanlet ong nindio.” ");
INSERT INTO agn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Gata-wanan mi ra tang toldok asing tokaw ang ganing, ‘Gegman mo tang tangay mo piro asilagan mo tang kasoay mo.’ ");
INSERT INTO agn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Piro mandian agganingo ong nindio: Gegman mi tang mga kasoay mi, ig ipangadi mi tang mga pamagpaliwag ong nindio ");
INSERT INTO agn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","agod magimo among matod ang mga ana tang Tatay mi ong langit. Tenged belag lamang ta ong mga mo-yang taw agpasingkalen na tang kaldaw, kondi asta ong mga malain ang taw. Ig belag ka lamang ta ong mga mato-lid agto-dol na tang koran, kondi asta ra ka ong mga belag ta mato-lid. ");
INSERT INTO agn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Indi amo magisip ang may elaten ming balet mga ang mga taw ang pagmal ong nindio ya lamang ay agmalen mi. Tenged maski ngani ang mga manigtokot ta bois, ang agbibilang ming malain ang mga taw, agmalen ka nira tang mga pamagmal ong nira. ");
INSERT INTO agn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ig mga ang tangay mo lamang tang agsapeten mo, onopa enged tang agboaten mo ang sobra pa ong doma? Maski ngani ang mga taw ang indi gailala ong Dios, pamanapet ka ong mga tangay nira. ");
INSERT INTO agn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Animan, prosigiran ming anday kakorangan ong pagkataw mi, pario tang Tatay mi ong langit, ang anda enged ay kakorangan ong nandia.” ");
INSERT INTO agn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ganing pa si Jesus, “Bantayan mi tang sadili mi, itaben lamang ang pagboat mi ta mo-ya tata lamang paita-ita ong mga taw. Tenged mga maning atan tang agboaten mi, anda enged ay marisibi ming balet ang magalin ong Tatay mi ong langit. ");
INSERT INTO agn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Animan mga pagtabang amo ong mga malilised, indi ra ibalita mi narin, pario tang agboaten tang doma ang pamagpabonayag lamang ong mga simban asta ong mga dalan. Maning atan tang agboaten nira para lamang dayawen tanira tang mga taw. Ong matod, narisibi ra nira tang balet nira. ");
INSERT INTO agn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Piro yamo, mga tomabang amo ong mga malilised, indi ra ipatako mi maski ong tangay mo pang pisan, ");
INSERT INTO agn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","agod indi enged mata-wanan ta doma tang pagtabang mi. Oman ang Tatay mi don ong langit, ang gaita ong bindoat mi, ya ray ang magbalet ong nindio.” ");
INSERT INTO agn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mga mangadi amo, indi amo magpatolad ong mga taw ang pamagpaita tang agboaten nira para lamang dayawen tanira tang mga taw. Dorong kaliliag nirang mangadi ang ke-deng ong teled tang mga simban asta ong mga kanto tang mga karsada, agod itaen tanira tang tanan. Ong matod, narisibi ra nira tang balet nira. ");
INSERT INTO agn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Piro yamo, mga mangadi amo, tenleda ong koarto mo ang tambiloga lamang ig manirado. Don amo magampo ong Tatay mi ong langit, ang indi gitaen. Tenged ang Tatay mi gaita ong agboaten mi, ig tanandia magbalet ong masinlong boat mi. ");
INSERT INTO agn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Mga magampo amo, indi amo maggamit ta dorong bitalang paolit-olit, ang anda ka lamang ay data na, pario tang agboaten tang mga taw ang indi gailala ong Dios. Ang kalaom nira pama-yan tanira tang Dios tenged lamang māboat tang mga pangadi nira. ");
INSERT INTO agn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Indi enged patoladan mi tang agboaten nira. Tenged gatako rang lagi tang Tatay mi mga onopa tang kaministiran mi, maski indi pa agpa-dolon mi. ");
INSERT INTO agn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Animan maning ta na tang pangadien mi: ‘Tatay amen ong langit, dayawen ig galangen tang aran mo. ");
INSERT INTO agn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Balampa yawa ra tang maggaem ong tanan-tanan, agod tomanen tang kaliagan mo ong tanek, pario kang agtomanen atan ong langit. ");
INSERT INTO agn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Olday ami ka nio ta pamangan ang kaministiran amen ong kaldaw ang na. ");
INSERT INTO agn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ig patawaden ami nio ong mga talak amen, pario ka ang agpatawaden amen tang mga pamagkatalak ong yamen. ");
INSERT INTO agn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tabangan ami kay nio agod indi ami degen tang tokso, ig ipalawid ami nio ong Malain. Tenged ong nio tang inadian, ig ang tanan ang kagaeman ig ang kadengegan, asta ong tanopa! Amen.’ ” ");
INSERT INTO agn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ig ganing pa si Jesus, “Mga agpatawaden mi kaman tang mga taw ang pamagkatalak ong nindio, patawaden amo ka tang Tatay mi ong langit. ");
INSERT INTO agn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Piro mga indi patawaden mi tang namagkatalak ong nindio, indi amo ka patawaden tang Tatay mi.” ");
INSERT INTO agn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mga pamagpaletem amo para mangadi, indi amo magpatolad ong mga taw ang pagpaita ang tanira pagpaletem para lamang dayawen tang mga taw. Pamagalig tanirang indi pamandamot ig indi pamanganloy agod ong mga emet nirang mapongaw mata-wanan tang mga taw ang tanira pamagpaletem. Ong matod, narisibi ra nira tang pagdayaw tang mga taw, animan anda ray balet pa nirang magalin ong Dios. ");
INSERT INTO agn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Animan mga magpaletem amo, mandamot amo ig manganloy amo tang boa mi, ");
INSERT INTO agn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","agod anday matako ang yamo pamagpaletem, poira lamang ang Tatay ming indi gitaen. Ig tanandiang gaita ig gatako ong nindio ong agboaten mi, yay ang magbalet ong nindio.” ");
INSERT INTO agn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Indi amo magsimet ta manggad tarin ong kalibotan ang na, tenged ang manggad tarin ong kalibotan madaling anayen obin kalaten. Obin, itaben telden ta takawan tang balay mi ig takawen. ");
INSERT INTO agn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ang boaten mi, magsimet amo ta manggad ong langit, tenged ang manggad ang asi indi anayen, indi kalaten, ig indi poiding takawen. ");
INSERT INTO agn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tenged mga ong aypa tang manggad mi, don ka tang nem mi.” ");
INSERT INTO agn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ang kalimbawan tang mata ta, midio pa-kal tang sinangoni ta. Animan mga mayag tang mata ta, gayagan ka tang bilog ang kaboi ta. ");
INSERT INTO agn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Piro mga maki-lep tang mata ta, gaki-lepan ka tang bilog ang kaboi ta. Animan mga maki-lep tang mata mi ang anda enged ay mayag don, dorong pisan agkaki-lep tang pagkabetang mi!” ");
INSERT INTO agn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ganing pa si Jesus, “Ang tatang taw, indi poiding doroa tang agalen na. Tenged asilagan na tang tambilog ig gegman na tang yadoa. Obin, bogos ang sirbian na tang tata, ig ang tambilog baliwalaen na. Pario ka ta si, indi amo mapagsirbi ta dengan ong manggad ig ong Dios. ");
INSERT INTO agn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Animan agganingo ong nindio: Indi amo magpaborido tang kolo mi natetenged ong pamangan ig inemen ang kaministiran mi para maboi, asta ong mga pangabel tang sinangoni mi. Tenged ang kaboi ta mas importanti pa enged ong pamangan ta, ig ang sinangoni ta mas importanti pa ong lambong ta! ");
INSERT INTO agn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Telekan mi ra lamang tang mga lamlam. Indi tanira pagloak, indi pangayeg, ig indi ka pamagsimet ong mga bodiga ta anen nira. Piro agtoldan tanira tang Tatay mi ong langit ta pamangan nira. Yamo pa bato? Mas importanti amo pa ong mga lamlam! ");
INSERT INTO agn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sinopa ong nindio tang poiding pāboaten na tang kaboi na, maski tang oras lamang, tenged ong pagpaborido na? Anda! ");
INSERT INTO agn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ig angay pamagpaborido amo ka natetenged ong mga panlambong mi? Isipen mi ra lamang tang mga rosas ong kabokidan. Pamansibabael tanirang indi pagobra ig indi pagboat ta lambong. ");
INSERT INTO agn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Piro ong matod, ang adi mismong si Solomon, maski monopag kamanggad, indi ngani napaglambong ta pario kasinlo tang maski tata ong mga rosas ang asi. ");
INSERT INTO agn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ang mga ibabawen ong kabokidan, mandian asia pa ig ong damal sirokon da. Piro maski maning ta si, agpalambongan tanira tang Dios ta dorog kasinlo. Yamo pa bato? Indi amo ka palambongan na? Korang pa tang pagtalig mi! ");
INSERT INTO agn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Animan indi amo magpaborido mga ong ari amo pa mangomit ta panganen mi ig inemen, asta lambongon mi. ");
INSERT INTO agn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tenged ang mga bagay lamang ang narin tang pirming agdemdemen tang mga taw ang anday talig nira ong Dios. Gata-wanan tang Tatay mi ong langit ang kaministiran mi kaman tang tanan ang asia. ");
INSERT INTO agn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ang boaten mi, tokawen mi kang lagi ong tanan ang maggaem tang Dios ong kaboi mi, ig mangaboi amo sigon ong kaliagan na. Sia, i-dol na tang tanan ang kaministiran mi. ");
INSERT INTO agn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Animan indi amo magpaborido tang natetenged tang ong damal. Poiding talongaen si mga nakabot da. Bastanti ra tang mga problima ta kada kaldaw.” ");
INSERT INTO agn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ganing pa si Jesus, “Indi amo magosgar ong aroman ming taw, agod indi amo ka osgaran tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tenged mga maning among nagkatalak tang aroman mo, maning ka don tang yaning tang Dios natetenged ong nindio. Mga monopag kabelat tang pagorosgaren mi ong doma, maning ka don tang pagorosgaren tang Dios ong nindio. ");
INSERT INTO agn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Angay aggitaen mo tang poling tang logod mo, piro indi gitaen mo tang sadiling poling mo ang midio ra troso ong mata mo? ");
INSERT INTO agn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Monopa maning mo ong logod mo, ‘Abir, komiten ta tang poling mo,’ mga atan ngani mismo ong mata mo may troso? ");
INSERT INTO agn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sinoa ra ka enged? Komiten mo kang lagi tang troso ong mata mo, agod maitā ta mo-ya ig matabangan mo tang logod mong komiten tang poling na.” ");
INSERT INTO agn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ig ganing pa si Jesus ong tatang sarabien, “Indi i-dol mi ong mga kiro tang mga bagay ang sagrado. Itaben pagatapos, balieden amo pa nira ig alaten. Indi ka i-lek mi tang mga pirlas mi ong mga baboy, tenged liked-likedan lamang nira.” ");
INSERT INTO agn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pirmi among mama-dol ong Dios ig oldan amo. Magprosigir among magdilem tang agdilemen mi, sia itaen mi ka. Sigi lamang tang panagbalay mi ig padayonon amo. ");
INSERT INTO agn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tenged garisibi tang kada pama-dol. Gaita tang pagdilem. Ig agpadayonon tang panagbalay. ");
INSERT INTO agn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Yamong mga tatay, mga pama-dol tang mga ana mi ta tinapay, oldan mi bato ta bato? ");
INSERT INTO agn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Obin, mga pama-dol tanira ta yan oldan mi bato ta ma-kal? ");
INSERT INTO agn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mga yamong mapinagtalaken gatakong magtorol ta mga mo-yang bagay ong mga ana mi, ang Tatay mi pa bato ong langit? Indi bato magtorol tanandia ta mga mo-yang bagay ong mga taw ang pama-dol ong nandia? ");
INSERT INTO agn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Animan boaten mi ong masig ka taw mi tang onopay galiliagan ming boaten ka nira ong nindio. Tenged tarin ong tanga tobolan ang na, katabid tang tanan ang Katobolan ni Moises asta ang mga sinoldok tang mga propita.” ");
INSERT INTO agn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Tenled amo ong mapiet ang portan, tenged mawayang tang portan ig madali tang dalan ang paning ong impirno, ig yay ang agpanawan tang kayadian. ");
INSERT INTO agn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Piro mapiet tang portan ig maliwag tang dalan ang paning ong kaboing anday kataposan, animan malaka lamang tang gatoman tang dalan ang asi.” ");
INSERT INTO agn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Magandam amo ong mga taw ang pamagtoldok ta mali. Magigtangay tanira ong nindio ang magpaita-ita ang tanira moro-ya ang pario ong mga karniro. Piro ong matod, ang ogali nira malalain ig manloloko, pario ong mga ayep ang pamangkeb. ");
INSERT INTO agn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mailala mi tanira ong mga boat nira. Tenged ang papa ta bantol-bantol indi mamorak ta obas, ig ang mga katenekan indi ka mamorak ta igos. ");
INSERT INTO agn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pamorak ta mo-yang borak tang tanan ang masisinlong papa ta ayo, piro pamorak ta anday kointa na tang mga anday sasayod. ");
INSERT INTO agn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Anday masinlong papa ta ayong pamorak ta anday sayod, ig anda kay malain ang pamorak ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ang kada papa ta ayong indi pamorak ta masinlong borak, agpe-peten ig agdadapog ong apoy. ");
INSERT INTO agn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Animan, pario ka ta si, mailala mi tang mga bo-lien ang mga manigtoldok tenged ong mga boat nira.” ");
INSERT INTO agn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ganing pa si Jesus, “Dorong mga taw ang gogoy ong yen ang ganing ‘Gino! Gino!’ Piro belag ta maliag yaning ang tanan ma-led ong inadian tang Dios. Ang ma-led lamang ay ang mga taw ang pamagtoman tang kaliagan tang yen ang Tatay ong langit. ");
INSERT INTO agn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ong oring kaldaw, mga osgaran da tang mga taw, doro tang maning ong yen, ‘Gino, aran mo tang ginamit amen ong pagpakabot tang bitala mo ig ong pagboat ta mga makabebereng ang mga bagay, asta ong pagpalayas ta mga malalain ang ispirito!’ ");
INSERT INTO agn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Piro aningeno tanira, ‘Indiong pisan gailala ong nindio! Palawid amo tarin, yamong tanan ang pamagboat ta malain!’ ” ");
INSERT INTO agn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ig ganing si Jesus, “Animan mandian, ang maski sinopay pamasi ig pagtoman ong mga agtotoldokong narin, ang kaparioan na tatang taw ang maosay ta kinaisipan ang nagpa-deng ta balay na ong pondasion ang bato. ");
INSERT INTO agn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ig maski kiminoran ta ma-leg, namā ig pinanawan ta mapoirsang mageyep, indi enged natomba tang balay ang asi tenged ang pondasion na bato. ");
INSERT INTO agn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Piro ang pamasi ong yen ang mga bitala ig pagatapos indi agboaten na, tanandia pario ta tatang taw ang anday ostong isip na ang nagpa-deng tang balay na ong kenay. ");
INSERT INTO agn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kiminoran ta ma-leg, namā ig pinanawan ta dorog kapoirsang mageyep. Dayon ang siminomba tang balay ang asi, ig lobot ang nangabola-tak.” ");
INSERT INTO agn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagatapos ang nagtoldok si Jesus tang tanan ang mga bagay ang asia, nangabereng ta mo-ya tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tenged gitaen ong pagtoroldokon na may sadiling aotoridad na, belag ta pario tang nirang mga manigtoldok tang Katobolan ni Moises. ");
INSERT INTO agn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Asing pagatoldak ni Jesus nagalin ong bokid, dorong mga taw ang namansidaton ong nandia. ");
INSERT INTO agn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mandian, napalenget ong ni Jesus tang tatang taw ang may masit nang liproso. Liminod ong talongan na ig minaning, “Magino, gata-wananong mapao-yao nio mga galiliaga lamang.” ");
INSERT INTO agn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Bindiotan ni Jesus tang liprosong asi ig minaning, “Galiliago! Mago-yā ra.” Ig lagi-lagi nago-ya tang masit na ig nanlimpio ra tang olit na. ");
INSERT INTO agn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Piro sinoyonan tanandia ta maelet ni Jesus ang ganing, “India enged mamalita maski ong ninopa. Paninga lamang ong padi ong Timplo ig ipaita mo ang yawa mo-yā ra. Oman magtorola tang bolontad ang sigon ong Katobolan ni Moises bilang pamatod ong mga taw ang nago-ya ra tang masit mo ig limpioa ra.” ");
INSERT INTO agn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mandian, asing te-led da si Jesus ong lansangan tang Capernaum, binagat tanandia tang tatang kapitan tang mga sondalo ang taga Roma. Nagpakiloy ong ni Jesus tang kapitan ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Magino, ang torobolono don ong balay pagmasit! Indi ra makaliek ig agliwagan da ong masit na!” ");
INSERT INTO agn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Animan ganing si Jesus, “Paningano ra ig pao-yaeno tanandia.” ");
INSERT INTO agn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Piro siminabat tang kapitan, “Magino, belago ta bagay ang magrisibi ong nio ong balay amen. Piro maski mitalā ra lamang, mago-ya ra tang torobolono. ");
INSERT INTO agn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gata-wanano, tenged maski yo, pagpasakepo ong mga alalawig ang pangolokolo. Ig may gasakepano kang mga sondalo. Mga aningeno tang tata, ‘Panawa!’ panaw ka tanandia. Ig ong tata, ‘Tania!’ lelenget ka tanandia. Ig mga ong kirepeno, ‘Boaten mo na!’ maning ka don tang agboaten na.” ");
INSERT INTO agn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nabereng si Jesus asing pagabasi na tang bitala tang kapitan, ig minaning ong mga taw ang pamansitabid ong nandia, “Ong matod, maski ngani ong yaten ang mga Israelita, indio pa gabagat ta taw ang maning ta na kabael tang pagtalig na. ");
INSERT INTO agn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tandan mi na: Yading mga taw tang mamansikabot ang mamagalin ong tere-lan ig gako-pan, ig mamangombida don ong inadian tang Dios, aroman tang mga kamepet-mepetan tang da Abraham, Isaac, ig Jacob. ");
INSERT INTO agn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Piro yading mga Israelita, ang ya rin tang dapat ma-led don, tang i-lek tang Dios ong maki-lep don ong loa. Ig don tanira mamagini-yak ig mamansikayeget tang mga isi nira.” ");
INSERT INTO agn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Oman minaning si Jesus ong kapitan, “Molika ra. Mainabo tang agpa-dolon mo sigon ong pagtalig mo.” Ig ong oras kang laging asi, nago-ya tang torobolon na. ");
INSERT INTO agn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Napaning si Jesus ong balay ni Pedro. Pagakabot na don, inita na tang panogangan ang babay ni Pedro ang lolbog lamang tenged agkinten tanandia. ");
INSERT INTO agn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bindiotan ni Jesus tang kalima tang mepet ig nagpoas ang lagi tang kinit na. Oman dayon dang nambangon ig nagasikaso ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Asing pagakorop tang kaldaw, ingkelan ong ni Jesus tang dorong taw ang sinled ta mga malalain ang ispirito para pao-yaen na. Ong tanga bitalan lamang ni Jesus, namansilayas tang mga malalain ang ispirito, ig pinao-ya na ka tang tanan ang may mga masit nira. ");
INSERT INTO agn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Bindoat na narin agod magmatod tang inaning tang propitang si Isaias asing tokaw ang ganing, “Tanandia tang nagpao-ya tang mga masit ta, ig nagkomit tang mga kalobayan ta.” ");
INSERT INTO agn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","May tatang kaldaw, pagaita ni Jesus tang dorong taw ong palibot na, nagordin tanandia ong mga sinagpan na ang magsimpan tanirang loma-ted ong dobaling baybay. ");
INSERT INTO agn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Asing magalin da tanira, may tatang manigtoldok tang Katobolan ni Moises ang napalenget ong ni Jesus ig minaning, “Maistro, tomabido ong nio, maski ong ariapa paning.” ");
INSERT INTO agn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Piro ganing si Jesus ong nandia, “Ang mga kirong lōg, may galoang ang agbalayan nira. Ig ang mga lamlam, may poyad ka nira. Piro yo, ang Ana ta Taw, andang pisan ay mapenayano.” ");
INSERT INTO agn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tata ka ong mga pamansitabid tang minaning, “Gino, pagnano kang lagi niong molik, para ipalbengo tang tatayo.” ");
INSERT INTO agn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Piro siminabat si Jesus, “Pabayan mo lamang ang mga patay tang maglebeng ong mga patay nira. Yawa, tomabida ong yen.” ");
INSERT INTO agn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Oman, dayon dang siminay si Jesus ong tatang bilog ang mabael, aroman tang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Asing don da tanira ong laod, golpi tanirang kinabotan ta tampo ig ge-ley da lamang ma-mokan tang bilog ang agtayan nira. Piro si Jesus gapoyat asing oras ang asi. ");
INSERT INTO agn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Animan pinalengetan tanandia tang mga sinagpan na ig pinoaw. Ganing tanira, “Gino, tabang! Mapatay ita ra!” ");
INSERT INTO agn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ganing si Jesus ong nira, “Angay pamansieled amo? Korang pa enged tang pagtalig mi!” Nambangon tanandia, sinambleng na tang mageyep asta ang langeb ig golpi rang naglinaw. ");
INSERT INTO agn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Pisan ang nangabereng tang mga sinagpan na ig ganing tanira, “Onopang klasiay na ta taw? Maski ang mageyep may ang langeb pagtoman ong nandia!” ");
INSERT INTO agn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pagakabot da Jesus ong dobaling baybay ang sakep tang mga Gadareno, binagat tanandia ta doroang taw ang aggaeman ta mga malalain ang ispirito. Ang mga taw ang na, don ong simintirio namagalin ig dorog karaiteg, animan gengeldan tang mga taw ang toma-lib don. ");
INSERT INTO agn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pagaita ong ni Jesus tang doroang asi, namansiteg ang lagi tanira ang ganing, “Aroy! Ana tang Dios, onopay boaten mo ong yamen ang mga malain ang ispirito? Napaninga tarin para papagpinitinsiaen ami nio, maski belag pa ta oras?” ");
INSERT INTO agn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mandian, don ong alawid-lawid dorong mga baboy ang pamanoliad. ");
INSERT INTO agn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Namagpakiloy tang mga malalain ang ispirito ong ni Jesus ang ganing, “Mga palayasen ami nio ong taw ang na, pagnan ami ra lamang nio ang tenled ong mga baboy ang asi.” ");
INSERT INTO agn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ganing si Jesus ong nira, “Ala sigi, don amo!” Limindoa ong doroang taw tang mga dimonio ig namansi-led da ong mga baboy. Oman ang mga baboy diritsong namagsinikad ong pangpang ig nangabo-log ong talsi asta nangalmet ang tanan. ");
INSERT INTO agn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ang mga mamanigsagod tang mga baboy namagsinikad ong lansangan, ig don binalita nira tang nainabo ong mga baboy ig ong doroang taw ang dating aggaeman tang mga dimonio. ");
INSERT INTO agn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Animan ang tanan ang mga taw ong banoang asi namampaning don ong ni Jesus, ig namagpakiloy ong nandia ang magalin da tanandia don ong logar nira. ");
INSERT INTO agn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pagatapos ta si, siminay da Jesus ong bilog nirang mabael para magbalik ong dobaling baybay. Pagakabot nira, dayon ang minolik si Jesus. ");
INSERT INTO agn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Asing don da tanandia, may mga taw ang kiminabot ang pamagtoang ta tatang taw ang paralisado ang lolbog lamang ong bayan-bayan. Asing itaen ni Jesus ang mapoirsa tang pagtalig nira ong nandia, ganing tanandia ong paralisado, “Anao, india ra magsinti, pinatawad da tang mga kasalanan mo.” ");
INSERT INTO agn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mandian, may don kang mga manigtoldok tang Katobolan ni Moises, ig pagabasi nira tang inaning ni Jesus, namagena-ena ong sadili nira ang ganing, “Aroy! Gakon na tang gaem ang para lamang ong Dios! Dorog kabelat tang kasalanan ang na!” ");
INSERT INTO agn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Piro gata-wanan ni Jesus tang aggisipen nira. Animan ganing tanandia, “Angay pamagisip amo ta malain? ");
INSERT INTO agn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ong aypa tang mas madaling yaning? ‘Pinatawad da tang mga kasalanan mo,’ obin ang maning, ‘Kendenga ig panaw.’? ");
INSERT INTO agn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Animan mandian, pao-yaeno rang lagi tanandia para mapamatodano ong nindio ang yo, ang Ana ta Taw, may gaemo kaman tarin ong kalibotan para magpatawad tang mga kasalanan.” Oman ganing si Jesus ong paralisado, “Kendenga! Takanen mo tang aglolbogan mo ig molika ra.” ");
INSERT INTO agn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ig dayon dang kimindeng tang taw ang asi ig napanaw dang minolik. ");
INSERT INTO agn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pagaita tang mga taw, pinangeldan tanira ta mo-ya ig namagdayaw ong Dios tenged nagtorol tanandia ong taw ta gaem ang maning ta si. ");
INSERT INTO agn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nagalin si Jesus don, ig mintras papanaw inita na tang tatang manigtokot ta bois, ang aran na si Mateo. Don tanandia kakarong ong paragtokotan ta bois. Ganing ong nandia si Jesus, “Impisa mandian, tomabida ra ong yen.” Ig dayon ang kimindeng si Mateo ig siminabid ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mandian, asing pamamangan da Jesus may ang mga sinagpan na ong balay ni Mateo, yading kiminabot ang mga manigtokot ta bois ig mga mapinagtalaken ig na-pen ka tanira don ang namamangan. ");
INSERT INTO agn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pagaita tang mga Pariseo, sine-ma nira tang mga sinagpan ni Jesus ang ganing, “Angay ga-pen tang maistro mi ang pamangan ong mga manigtokot ta bois ig ong domang mga mapinagtalaken?” ");
INSERT INTO agn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Naba-yan tanira ni Jesus animan tanandia tang siminabat. Ganing tanandia, “Ang mga taw ang anday masit nira, anday kaministiran ta doktor. Ang may mga masit lamang tang kaministiran ang bolongon. ");
INSERT INTO agn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pario ka ta si, yo, indio napaning tarin para goyano tang mga taw ang ganing anday talak nira. Napaningo ta para goyano tang mga taw ang aggakon nirang tanira mapinagtalaken. Magalin amo ra ig intindien mi ta mo-ya tang maliag yaning tang nasolat ong Kasolatan ang ganing, ‘Belag tang mga bolontad mi tang pagtorol ta kalipayan ong yen, kondi ang kate-bek mi ong tata may tata.’ ” ");
INSERT INTO agn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Oman, kiminabot da tang mga sinagpan ni Juan ang Manigboniag ig nane-ma ong ni Jesus, “Yami ig ang mga Pariseo madagmit aming pamagpaletem. Piro angay ang mga sinagpan mo anda enged?” ");
INSERT INTO agn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ganing ang siminabat si Jesus, “Pabetang ta may kasalan. Onopa? Mamagsebe ig mamagpaletem bato tang mga tangay tang laling ba-long kinasal mintras aroman pa nira? Indi ka enged! Piro komabot tang kaldaw ang komiten ong nira tang laling kinasal, ig ya ray ang oras ang tanira mamagpaletem.” ");
INSERT INTO agn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ganing pa si Jesus, “Indi poiding itambel tang ba-long abel ong loma rang lambong. Tenged mga matalpoan da tang lambong ang sinambelan, kemere tang ba-long abel ang sinambel, asta mabegtat ig mas mambael pa tang lasik na. ");
INSERT INTO agn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ya ka ong ba-long bino. Indi poiding ibetang ong lomang tereldan ang olit ta ayep ang indi ra maonat. Tenged lompok tang tereldan tenged ong ba-long bino. Oman, mailat tang bino ig indi ra mapakinabangan tang tereldan ang asi. Animan kaministiran ang enged, ang ba-long bino ibetang ong ba-lo kang tereldan agod pario tanirang magtinir ta maboay.” ");
INSERT INTO agn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mintras pagbitala pa si Jesus ong mga taw, kiminabot tang tatang pangolokolong Judio. Diminagpa ong talongan ni Jesus ig nagpakiloy ang ganing, “Ang anao ang sosoltiras ba-lo lamang napatay! Piro tomabida kay ong yen! Maski ibondo mo lamang tang kalima mo ong nandia, maboi tanandiang moman.” ");
INSERT INTO agn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Animan kimindeng si Jesus ig siminabid ong nandia. Asta ang mga sinagpan na namansitabid ka. ");
INSERT INTO agn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mintras papanaw tanira, may dadaton ka ang tatang babay ang pagdogo-dogo ong teled da ta tampolok may doroang takon. Napalenget tang babay ong boko-boko ni Jesus ig sine-lek na tang kapotan tang lambong na, ");
INSERT INTO agn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","tenged ganing ong sadili na, “Maski mate-leko lamang tang lambong na, mago-yao ra.” ");
INSERT INTO agn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Minalied ang lagi si Jesus ig pagaita na ong babay ganing tanandia, “Babay, india ra magsinti. Ang pagtalig mo tang nagpao-ya ong nio.” Ig lagi-lagi nago-ya kaman tang babay. ");
INSERT INTO agn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Oman nagdayon da da Jesus ong balay tang pangolokolong Judio, ig pagakabot nira, inita nirang don da tang mga mamanigtogtog ong lebeng ig ang mga taw ang pamagkagolo. ");
INSERT INTO agn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ganing si Jesus ong mga taw, “Magalin amo ra lamang. Belag ta patay tang mola. Gapoyat lamang.” Piro inimodan lamang nira si Jesus. ");
INSERT INTO agn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Animan pinaloa na tanirang tanan. Dayon tanandiang siminled ong koarto tang mola, bindiotan na tang kalima na ig nambangon ang lagi tang mola. ");
INSERT INTO agn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ig indi naboay, ang nainabong na nabantog da ong bilog ang logar ang asi. ");
INSERT INTO agn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pagalin ni Jesus don, agdatonon tanandia ta doroang taw ang boray. Pamansiteg tanira ang ganing, “Inampo ni David! Mate-beka ong yamen!” ");
INSERT INTO agn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Paga-led ni Jesus ong balay ang agdayonan na, namansi-led ka tang mga boray. Sine-ma tanira ni Jesus ang ganing, “Pamagparet amo enged ang mapao-ya amo yen?” “Ee, pagparet ami, Gino,” ganing tanirang siminabat. ");
INSERT INTO agn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Inapap ni Jesus tang mga mata nira ig minaning, “Mainabo tang agpa-dolon mi, sigon ong pagtalig mi.” ");
INSERT INTO agn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ig lagi-lagi nangaita ra tanira. Oman sinoyonan tanira ta maelet ni Jesus ang indi enged ibeg nira maski ong ninopa. ");
INSERT INTO agn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Piro pagapagalin nira, namagpanaw ig binalita nira ong bilog ang logar ang asi tang bindoat ni Jesus ong nira. ");
INSERT INTO agn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pagapagalin tang doroang taw ang asi, may ingkelan si ong ni Jesus ang tatang boyon ang aggaeman ta malain ang ispirito. ");
INSERT INTO agn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pinalayas ni Jesus tang malain ang ispirito ig dayon ang laging nabitala tang boyon. Nangabereng ta mo-ya tang mga taw ig ganing tanira, “Ya ra lamang ay kaboay indi itang pisan gaita ta maning ta na ong bilog ang Israel!” ");
INSERT INTO agn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Piro ganing tang mga Pariseo, “Si Satanas, ang pangolokolo ong mga dimonio, yay ang pagtorol ong nandia ta gaem ang magpalayas ta mga malalain ang ispirito.” ");
INSERT INTO agn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pagatapos ta si, naglibot si Jesus ong mga lansangan asta ong mga kababarioan ang pagtoldok ong mga simban tang mga Judio. Pinatako na tang Mo-yang Balita natetenged ong paggaraemen tang Dios bilang adi, ig pinao-ya na tang mga taw ong tanan ang mga masit nira ig maski onopay agba-yagen nira. ");
INSERT INTO agn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pagaita na tang dorong mga taw, dorong katete-beken na ong nira tenged gaborido tanira ig agliwagan. Pario tanira ong mga karniro ang pinabayan da lamang tang manigbadbad, ig anday pagsagod ong nira. ");
INSERT INTO agn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Animan ganing si Jesus ong mga sinagpan na, “Dorong arayegen, piro korang tang mga manigayeg. ");
INSERT INTO agn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Animan mama-dol amo ong may nandia tang arayegen ang magpekel pa enged tanandia ta mga manigayeg.” ");
INSERT INTO agn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pagatapos ta si, sinimet ni Jesus tang tampolok may doroang mga sinagpan na ig sindolan na tanira ta gaem ang magpalayas ta mga malalain ang ispirito, ig magpao-ya ta maski onopang klasiay ta masit. ");
INSERT INTO agn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Narin tang mga aran tang tampolok may doroang apostolis: Primiro si Simon ang aggoyan ta Pedro, oman si Andres ang logod na; si Santiago may ang logod nang si Juan, ang mga ana ni Zebedeo; ");
INSERT INTO agn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","si Felipe ig si Bartolome; si Tomas ig si Mateo ang manigtokot ta bois; si Santiagong ana ni Alfeo, si Tadeo, ");
INSERT INTO agn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon ang pagmal ta mo-ya tang banoa nang Israel, ig si Judas Iscariote ang yay ang nagtraidor ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Oman sinobol ni Jesus tang tampolok may doroang narin ig sinoyonan na ang ganing, “Indi amo paning ong mga logar tang mga belag ta Judio obin ong mga logar tang mga Samaritano. ");
INSERT INTO agn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ang mga kasimanoa ta ang mga Israelita ya lamang ay paningan mi. Ang kalimbawan nira pario ong mga karnirong ganga-ngi ta dalan. ");
INSERT INTO agn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Panaw amo ig liboton mi tang mga logar nira. Ipatako mi ong nira ang alenget dang maggaem tang Dios tarin ong kalibotan. ");
INSERT INTO agn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pao-yaen mi tang mga pamagmasit ig ang mga liproso. Boien mi tang mga patay ig palayasen mi tang mga dimonio ong mga taw ang sinledan nira. Rinisibi mi narin ong Dios ang anday bayad, animan i-dol mi ka narin ang anday bayad. ");
INSERT INTO agn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ong pagpanaw mi indi amo mamagekel ta koarta maski pirapang sintabos lamang. ");
INSERT INTO agn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Indi amo ka magekel ta binagteng, maski lambong ang irimaran, obin maski rapak, obin baston. Tenged ang mga taw ang pamangabedlay dapat ang enged ang oldan tang mga kaministiran nira. ");
INSERT INTO agn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mga komabot amo ong tatang lansangan obin bario, magdilem amo ta taw ang mo-yang dayonan mi. Ig don amo lamang magtinir mintras indi amo pa pagalin ong logar ang asi. ");
INSERT INTO agn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pagteled mi ong balay nira, bindisionan mi tanira ang maning, ‘Balampa magkatinir tang kao-yan tang Dios ong teled tang pamalay-balay ang narin.’ ");
INSERT INTO agn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mandian, mga moro-yang taw tang pamansistar don, magkatinir ka enged tanira ta kao-yan ang magalin ong Dios. Piro mga belag, indi ka marisibi ta sia. ");
INSERT INTO agn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mga may pamalay-balay obin banoang indi enged magrisibi ong nindio, obin indi enged mamasi ong mga agtotoldok mi, magalin among lagi ig tapokon mi tang kolapok ong mga kakay mi, para ipaita ang anda ray sarabaten mi ong nira. ");
INSERT INTO agn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ong matod, ong kaldaw ang osgaran tang Dios tang tanan, ang silot ang i-dol ong nira mas sobra pa ong silot ang i-dol ong mga taga Sodoma ig taga Gomorra.” ");
INSERT INTO agn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ganing pa si Jesus ong mga apostolis na, “Tandan mi na! Ang kalimbawan mi pario ong mga karnirong agtobolono ong mga ayep ang pamangkeb. Animan kaministiran magimong ansiano amo, ig pirming bantayan mi tang sadili mi agod anday maning tang mga taw ong nindio. ");
INSERT INTO agn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Magandam amo ong nira, tenged depen amo nira ig e-lan amo ong korti, oman patakan amo tang palo ong mga pagsirimetan nira. ");
INSERT INTO agn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ig natetenged ka ong pagto mi ong yen, patalongaen amo ka nira ong mga gobirnador ig ong mga adi. Ig don ya ray ang oras ang mapagpamatod amo ong nira, asta ong mga tawan nirang belag ta Judio, tang natetenged ong yen. ");
INSERT INTO agn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mga imbistigaren amo ra nira, indi amo magpalibeg tang mga kolo mi mga onopa tang ibitala mi obin mga onopay isabat mi. Tenged ong oras ang asi, oldan amo tang isabat mi. ");
INSERT INTO agn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tenged ang ibitala mi indi magalin ong sadiling isip mi. Sia magalin ong Ispirito tang Dios ang Tatay mi don ong langit. ");
INSERT INTO agn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ong mga kaldaw ang asi, ang mga taw traidoron nira tang maski sadiling logod nira ig yintriga ong osgado para ipapatay. Ig ya kay boaten tang mga tatay ong mga ana nira, asta ang mga ana batokan ka nira tang mga ginikanan nira ig ipapatay. ");
INSERT INTO agn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ig yamo, asilagan amo tang tanan tenged ong pagto mi ong yen. Piro ang magagoanta ig magpadayon ang magtoman ong yen asta matapos tang tanan ang kaliwagan, tanandia yay ang malibri. ");
INSERT INTO agn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mga agpaliwagan amo ong tatang banoa, maglayas amo ang paning ong dadaton ang banoa. Ong kamatodan, indi amo pa matapos ang magtoldok ong tanan ang mga banoa tang Israel, komaboto ra, yo, ang Ana ta Taw. ");
INSERT INTO agn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Demdemen mi, anday manigadal ang mas matako ong maistro na, ig anday torobolon ang mas alawig ong agalen na. ");
INSERT INTO agn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Animan dapat risibien tang manigadal mga ang mapasaran na pario tang gapasaran tang maistro na. Ya ka ang torobolon mga mapasaran na tang pario ka tang agalen na. Animan mga yo, bilang tatay ong pamalay-balay, aggoyan tang mga taw ta Satanas, mas pakalainen amo pa nira tenged mga sakep amo yen.” ");
INSERT INTO agn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Piro indi amo meled ong nira. Tenged anday gatalok ang indi ipaita, ig anday sikritong indi mata-wanan. ");
INSERT INTO agn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Maski onopay agbebego ong nindio ong talok, ibeg mi ong doma. Ig maski onopay lalalato ong nindio, ipatako mi ong tanan ang taw. ");
INSERT INTO agn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Indi amo meled ong mga pamamatay ta taw, sia indi mapagpatay tang kalag mi. Ang Dios tang dapat eldan mi, tenged tanandia tang may gaem na para magsilot tang sinangoni asta kalag mi ang i-lek don ong impirno. ");
INSERT INTO agn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Piro demdemen mi ka narin: Ang mga aloma-wit, gata-wanan ta ang gabakal ta tang sintabos lamang kada doroang bilog. Asia, maski dorog kabarato, piro anda enged ay aloma-wit ang gapatay ig gabo-log ong tanek mga belag ta kaliagan tang Tatay mi don ong langit. ");
INSERT INTO agn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ig yamo, maski ngani ang mga naet tang boa mi, gata-wanan na ang pirapang tanan. ");
INSERT INTO agn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Animan indi amo mamansieled, tenged mas agmalen amo tang Dios kaysa ong kadoro-doroan ang mga aloma-wit.” ");
INSERT INTO agn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ganing pa si Jesus, “Ang maski sinopay mangilala ong yen ong talongan tang mga taw, ilalaeno ka tanandia ong talongan tang yen ang Tatay ong langit. ");
INSERT INTO agn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Piro ang ganing indi ono gailala ong yen, indi ka tanandia ilalaeno ong talongan tang yen ang Tatay ong langit.” ");
INSERT INTO agn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Indi amo mamagisip ang napaningo tarin para magekel ta kaosayan ong kalibotan. Belag ta kaosayan tang aggekelano kondi soroayen. ");
INSERT INTO agn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Animan tenged ong yen, ang mga anang lali mamagigsoay ong mga tatay nira, ang mga anang babay ong mga nanay nira, asta ang mga minagad ang babay mamangontra ka ong panogangan nirang babay natetenged ong yen. ");
INSERT INTO agn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ig ang magimong kasoay tang tatang taw ay ang sadiling kapamilia na mismo. ");
INSERT INTO agn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Indi poiding magimong sinagpano tang pagmal ong tatay na obin ong nanay na sobra pa ong paggegma na ong yen. Ya ka ang pagmal ong ana na ang sobra pa ong yen, indi poiding magimong sinagpano. ");
INSERT INTO agn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ig ang maski sinopa, mga indi magosoy ong yen ang tomalonga ong kaliwagan ig kamatayen, ang taw ang asi indi poiding magimong sinagpano. ");
INSERT INTO agn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tenged ang taw ang agpalabien na tang kaboi na tarin ong ta-paw tang kalibotan, tanandia tang malipatan ta sia. Piro ang taw ang magbolontad tang kaboi na para ong yen, tanandia tang marisibi ta kaboing anday kataposan.” ");
INSERT INTO agn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ang magrisibi ong nindio, pagrisibi ka ong yen. Ig ang pagrisibi ong yen, sia pagrisibi ka ong Dios, tenged tanandia tang nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ang taw ang magrisibi ong tatang propita tenged propita tanandia, marisibi ka ta balet ang pario tang to-dol tang Dios ong propitang asi. Ig ang magrisibi ong tatang taw ang mato-lid tenged mato-lid tanandia, marisibi ka ta balet pario tang risibien tang taw ang asing mato-lid. ");
INSERT INTO agn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ig ang sinopay magtorol ta maski tang baso lamang ang wing malamig ong tatang pobring sinagpano, tenged tanandia sinagpano, ang taw ang asi indi maimong indi balten tang Dios.” ");
INSERT INTO agn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagatapos ang toyonan ni Jesus tang tampolok may doroang sinagpan na, napanaw da ka tanandia para magtoldok ig magpatako tang Mo-yang Balita ong mga banoang alelenget don. ");
INSERT INTO agn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mandian, asing don pang agprison si Juan ang Manigboniag, nabalitan na tang mga agboaten ni Cristo. Animan nanobol tanandia ong mga sinagpan na para mane-ma ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ganing tanira ong ni Jesus, “Pagpate-ma si Juan mga yawa ra kaman tang aggelaten ang komabot, obin magelat ami pa ta doma.” ");
INSERT INTO agn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Siminabat si Jesus ang ganing, “Magbalik amo ong ni Juan ig ibalita mi tang tanan ang naba-yan mi ig inita mi. Ibeg mi ong nandia nga ");
INSERT INTO agn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ang mga boray gangaita ra, ang mga pilay gangapanaw da, ang mga bengel gangabasi ra, ang mga liproso mo-ya ra, asta ang mga patay nangaboi rang oman. Ig ang Mo-yang Balita agpatako ra ong mga malilised. ");
INSERT INTO agn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Masoirti tang taw ang indi pagdoadoa tang nem na ong yen!” ");
INSERT INTO agn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pagapagalin tang mga sinobol ni Juan, minitala si Jesus ong mga taw natetenged ong ni Juan ang ganing, “Asing napaning amo don ong logar ang anday gistar ang taw, onopay galiliagan ming itaen don? Tatang kirib ang aggeyepen ta mageyep? Belag! ");
INSERT INTO agn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Piro onopa enged tang galiliagan ming itaen don? Tatang taw ang pagtok ta masinlong lambong? Belag ka! Tenged ang mga pamagtok ta masisinlong lambong don pamansistar ong palasio tang mga adi. ");
INSERT INTO agn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Animan onopa enged tang galiliagan ming itaen? Tatang propita? Ee. Propita ka kaman. Ig begen amo yen, sobra pa ong propita tang inita mi don. ");
INSERT INTO agn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tenged si Juan yay ang agsambiten tang Dios ong Sagradong Kasolatan, ang ganing: ‘Tobolono tang yen ang torobolon ang tongkaw ong nio, para simpanen na tang paranawan mo.’ ");
INSERT INTO agn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ong kamatodan, anday nataw ong ta-paw tang kalibotan ang gilalaen ang mas alawig pa ong ni Juan ang Manigboniag. Piro ang maski sinopay gasakepan da tang inadian tang Dios, maski tanandia tang ipabetang ang kadibabakan ong tanan, mas alawig pa ka enged tang pagkabetang na ong ni Juan. ");
INSERT INTO agn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mimpisa pa asing primirong magtoldok si Juan asta mandian, dorong pamangontra ong paggaraemen tang Dios, ig may atan kang dorong reges nirang tenled ong inadian na. ");
INSERT INTO agn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tenged ang mga sinolat tang mga propita asing tokaw, asta ang Katobolan ni Moises, napagpatako rang lagi tang natetenged ong inadian tang Dios, tegka ong pagkabot ni Juan. ");
INSERT INTO agn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ig mga mamagparet amo, si Juan mismo tang Elias ang pinatakong komabot. ");
INSERT INTO agn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Animan mamasi tang may talinga! ");
INSERT INTO agn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Yamong mga taw ong timpong na! Ang kaparioan mi mga mamolang pamansikarong ong plasa ig pamansiteg ong mga kakayam nira ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Sinogtogan amo yamen ta tipano piro indi amo mamagtayaw! Namagkanta ami ta mapongaw piro indi amo ka mamagini-yak!’ ");
INSERT INTO agn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Maning amo enged atan. Tenged pagkabot ni Juan ang Manigboniag, inita ming pagpaletem tanandia ig indi panginem ta irinemen, piro ganing amo, ‘Aggaeman tanandia ta malain ang ispirito!’ ");
INSERT INTO agn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Oman yo, ang Ana ta Taw, kiminabot ang pamangan ig panginem, ig ganing amo ka, ‘Telekan mi tang taw ang na! Takaban ig manigpabaleng! Ang mga tangay na poros manigtokot ta bois ig domang mga mapinagtalaken!’ Piro maski maning ta sia tang agganing mi, ang kinata-wanan tang Dios itaen pa ka enged ang matod ong mga boat na.” ");
INSERT INTO agn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Oman, dayon ang sinambleng ni Jesus tang mga pamansistar ong mga banoang bindoatan na ta dorong mga milagro, tenged indi enged tanira mamagtogat ong mga talak nira. ");
INSERT INTO agn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ganing si Jesus, “Kailo amo ka, yamong mga taga Corazin ig taga Betsaida! Dorong milagrong bindoato atan ong nindio, piro indi amo enged namagtogat! Piro mga bindoato lamang tang mga bagay ang asi don ong Tiro ig ong Sidon, ang mga taw don, naboay da ka rin ang namaglambong ta sako ig namansikarong ong kabo para ipaitang pamagtogat da tanira. ");
INSERT INTO agn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Animan agganingo ong nindio, ong kaldaw ang osgaran tang Dios tang tanan, mas malakan tang silot ang i-dol ong mga taga Tiro may Sidon kaysa ong nindio. ");
INSERT INTO agn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ig yamong mga taga Capernaum, galiliag among manlawig tegka ong langit. Piro mabo-log amo lamang ong impirno, tenged indi amo ka enged namagtogat! Piro mga ang mga milagrong bindoato atan ong nindio, bindoato rin don ong Sodoma, dapat asta mandian atan pa ka rin tang Sodoma! ");
INSERT INTO agn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Animan agganingo ong nindio, ong Kaldaw tang Pagosgar, mas malakan tang silot ang i-dol ong mga taga Sodoma kaysa ong nindio.” ");
INSERT INTO agn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Asing oras ang asi nagampo si Jesus ang ganing, “Tatayo, yawa tang paggaem tang langit may ang tanek. Pagpasalamato ong nio tenged sinalok mo tang mga kamatodan ang na ong mga matatakong taw ig alalawig tang inadalan nira. Piro pinatako mo ong mga taw ang dibabak ta nem ig anday adal nira. ");
INSERT INTO agn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Salamat, Tatay, tenged maning ta sia tang kaliliagan mo.” ");
INSERT INTO agn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Oman ganing si Jesus ong mga taw don, “Ang tanan ang bagay, inintriga ong yen tang Tatayo. Ang Tatay lamang enged tang gailala ong Ana na, ig ang Ana lamang tang gailala ong Tatay na, asta ang mga taw ang galiliagan tang Ana ang mailala ong Tatay na. ");
INSERT INTO agn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Lemenget amo ong yen, yamong tanan ang agbelatan ig agpilayan, agod palinawaen amo yen. ");
INSERT INTO agn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Magtoman amo ong mga tobolo ig magadal amo ong yen, tenged yo mapinasinsiaeno ig dibabak ta nem. Ong maning don, maenayan amo enged. ");
INSERT INTO agn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tenged madali lamang tomanen tang mga tobolo, ig malakan lamang tang tarakanen ang i-dolo ong nindio.” ");
INSERT INTO agn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","May tatang Kaldaw ang Igperenay, tata-lib da Jesus ong mga kakoman ang arayegen da lamang. Agle-men da tang mga sinagpan na, animan namanlantok tanira ta pirapang koay na oman aggeyeben nira. ");
INSERT INTO agn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pagaita tang mga Pariseo, ganing tanira ong ni Jesus, “Telekan mo tang agboaten tang mga sinagpan mo! Mandian Kaldaw ang Igperenay. Kontra ong Katobolan tang agboaten nirang asia.” ");
INSERT INTO agn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ganing si Jesus ang siminabat, “Angay? Indi gabasa mi ong Sagradong Kasolatan tang bindoat ni David asing linetem da tanandia may ang mga karomanan na? ");
INSERT INTO agn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Siminled tanandia ong balay tang Dios ig namangan tang sagradong tinapay ang nabolontad da ong Dios. Sindolan na pa tang mga karomanan na, maski sigon ong Katobolan, ang mga padi lamang tang poiding mamangan ta si. ");
INSERT INTO agn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ig indi pa gabasa mi ong Katobolan ni Moises? Ang mga padi mismong pamangontra ka ong Kaldaw ang Igperenay kada magsirbi ig magbolontad tanira ong Timplo imbis ang penay lamang tanira. Piro indi si agbibilang ang talak nira. ");
INSERT INTO agn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Agganingo ong nindio, may nakabot da tarin ang mas importanti pa ong Timplo. ");
INSERT INTO agn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","May inaning tang Dios ong Kasolatan ang ganing, ‘Belag tang mga bolontad mi tang pagtorol ta kalipayan ong yen, kondi ang kate-bek mi ong tata may tata.’ Mandian, mga naintindian mi rin tang maliag yaning tang mga bitalang asia, indi ra rin inosgaran mi tang mga taw ang anday mga talak nira. ");
INSERT INTO agn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yo, ang Ana ta Taw, yo tang may gaem ang maganing mga onopay poiding boaten mga Kaldaw ang Igperenay.” ");
INSERT INTO agn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pagatapos ta si, nagalin da si Jesus ig napaning ong tatang simban tang mga Judio. ");
INSERT INTO agn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","May tatang lali don ang pilay tang kalima na. Ig may mga taw ka don ang pamagdilem ta dailan agod madimanda nira si Jesus ong mga agboaten na. Animan namane-ma tanira ong ni Jesus ang ganing, “Bato, ga-tang ong Katobolan ang poiding magpao-ya ta may masit na mga Kaldaw ang Igperenay?” ");
INSERT INTO agn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ganing si Jesus ong nira, “Pabetang ta, may tatang karniro ming nabo-log ong adalem ang galoang ig naton ang Kaldaw ang Igperenay. Onopa bato, pabayan mi ra lamang tenged Kaldaw ang Igperenay? Indi enged! ");
INSERT INTO agn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Piro ang taw mas importanti pa ong karniro. Animan indi agkontraen ta tang Katobolan mga pagboat ita ta mo-ya ong Kaldaw ang Igperenay.” ");
INSERT INTO agn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Oman minaning si Jesus ong taw ang asing pilay, “Abir, yonat mo tang kalima mo.” Inonat na tang kalima na ig nago-ya ka kaman. ");
INSERT INTO agn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Animan namagalin ang lagi tang mga Pariseo ig namagampang-ampang mga monopa mapapatay nira si Jesus. ");
INSERT INTO agn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Gata-wanan ni Jesus tang onopay aggisipen tang mga Pariseo, animan nagalin tanandia don. Dorong mga taw tang namansidaton ong nandia ig pinao-ya na tang tanan ang may masit nira. ");
INSERT INTO agn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Piro sinoyonan na tanira ta maelet ang indi mamagbeg mga sinopa enged tanandia. ");
INSERT INTO agn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Si Jesus nagpao-ya agod magmatod tang inaning dang lagi tang Dios natetenged ong nandia, ig yay ang pinatako tang propitang si Isaias ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Na yay ang torobolono, ang pinilikong magsirbi ong yen. Agmaleno tanandia ig galipayo ta mo-ya ong nandia. I-dolo ong nandia tang yen ang Ispirito, agod ipatako na ong mga taw ong tanan ang logar tang natetenged ong mato-lid ang pagorosgaren. ");
INSERT INTO agn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Indi tanandia magigdiskosion, maloay lamang mga magigampang, ig indi ka magpabael tang bosis na ong karsada. ");
INSERT INTO agn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ate-bekan na tang mga taw ang panlobay da tang pagto nira, ig indi pabayan na tang mga malobay ta nem. Indi tanandia penay asta indi mandeg tang mato-lid ang pagorosgaren tang Dios ong kalibotan. ");
INSERT INTO agn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ig tanandia lamang tang taligan tang tanan ang taw ang maglibri ong nira.” ");
INSERT INTO agn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mandian may ingkelan ong ni Jesus ang tatang laling boray ig boyon ang aggaeman ta malain ang ispirito. Pinao-ya ni Jesus tang taw ang asi ig lagi-lagi nabitala ig naita ra. ");
INSERT INTO agn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nangabereng tang tanan animan namagtere-ma te-man tanira ang ganing, “Onopa bato? Ya ray na tang aggelaten ta, ang Inampo ni David?” ");
INSERT INTO agn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Piro pagabasi tang mga Pariseo, ganing tanira, “Belag! Si Satanas, ang pangolokolo ong mga dimonio, yay ang pagtorol ong nandia ta gaem ang magpalayas ta mga malain ang ispirito.” ");
INSERT INTO agn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Piro gata-wanan ni Jesus tang aggisipen nira. Animan ganing tanandia, “Pabetang ta, mga ang mga taw ong tatang inadian, tanira mismo tang pamagkorontran, mamagbereblag ang enged tang inadian ang asi. Pario ka ta si tang mainabo ong tanga banoan obin tanga balayan. Mga tanira mismo tang pamagsoroayan, indi maboay mamagbereblag ang enged. ");
INSERT INTO agn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mandian, mga si Satanas mismo tang pagpalayas tang mga sinakepan na, maliag yaning agkontraen na tang sadili na! Mga maning don, monopa madayon tang inadian na? ");
INSERT INTO agn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ig mga matod ang si Satanas tang pagtorol ta gaem ong yen para magpalayas ta mga dimonio, sinopa ka tang pagtorol ta gaem ong mga tawan mi para magpalayas ta mga dimonio? Tanira ka mismo tang magpamatod ang nagkamali amo! ");
INSERT INTO agn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tenged ong kamatodan, ang Ispirito tang Dios tang pagtorol ong yen ta gaem ang magpalayas ta mga dimonio. Animan maliag yaning, ang Dios ya ray paggaem mandian tarin ong nindio. ");
INSERT INTO agn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Si Satanas, ang kalimbawan na pario ong tatang taw ang mapoirsa. Tenged anday taw ang ma-led ong balay na para mangomit tang mga kagamitan na mga indi kang lagi lapoton tanandia. Piro mga nalapot da ngani, ya ray ang oras ang mapanakaw ong teled tang balay na.” ");
INSERT INTO agn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ig ganing pa si Jesus, “Ang indi kakampi ong yen, kokontra ong yen. Ig ang indi pagtabang ong yen ang pagsimet ta mga taw, pagwasag lamang. ");
INSERT INTO agn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tandan mi na ta mo-ya: Patawaden tang Dios tang tanan ang mga talak tang mga taw asta ang tanan ang malain ang bibitala nira. Piro ang sinopay magbitala ta malain kontra ong Ispirito Santo indi enged mapatawad. ");
INSERT INTO agn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mapatawad tang maski sinopay magbitala ta malain kontra ong yen, ang Ana ta Taw. Piro mga ang Ispirito Santo tang pakalainen na, inding pisan tanandia patawaden mandian asta tanopa.” ");
INSERT INTO agn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mapaganing itang masinlo tang tatang papa ta ayo mga itaen ta ang masinlo tang borak na, ig anday sayod tang ayo mga itaen ta ang anda kay sayod tang borak na. Tenged mailala tang kada papa ta ayo ong borak na. ");
INSERT INTO agn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kalalain tang mga ogali mi! Ig tenged poros amo malalain, mono amo pa bato mapagbitala ta mo-ya? Tenged mga onopa tang ga-tang ong popotokon ta, sia ya kay ang loloa ong anga ta. ");
INSERT INTO agn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ang taw ang mo-ya, poros mo-ya tang bibitala na, tenged mo-ya tang ga-tang ong popotokon na. Piro ang taw ang anday sasayod ta ogali, poros malain tang agbibitala na, tenged anda kay sasayod tang ga-tang ong popotokon na. ");
INSERT INTO agn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Tandan mi na: Ong kaldaw ang magosgar tang Dios, manabat ang enged tang taw ong tanan ang mga bitala nang anday kointa na. ");
INSERT INTO agn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ig dipindi ong mga binitala mo mga yaway sintinsian ang silotan obin ibilang ang mato-lid.” ");
INSERT INTO agn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Oman may mga manigtoldok tang Katobolan ig mga Pariseo tang minaning ong ni Jesus ang ganing, “Maistro, abir, magpaitā kay ong yamen ta milagro bilang tanda ang yawa matod ang nagalin ong Dios.” ");
INSERT INTO agn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ganing ang siminabat si Jesus, “Yamong mga traidor amo! Kalalain tang ogali mi! Pamagdilem amo ta milagro ba-lo amo magparet. Piro anday ipaita ong nindio, poira lamang ong tatang makabebereng ang bagay ang pario tang nainabo ong propitang si Jonas asing tokaw. ");
INSERT INTO agn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mga monopa si Jonas tolong kaldaw ig tolong labi ong teled tang sian tang mabael ang yan, maning ka atan tang mainabo ong yen, ang Ana ta Taw. Tenged magtiniro ta tolong kaldaw ig tolong labi ong adalem tang tanek. ");
INSERT INTO agn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pag kabot tang kaldaw ang magosgar da tang Dios, ang mga taga Ninive tomalonga don ig magpamatod ang yamo dapat ang silotan. Tenged asing si Jonas nagtoldok ong nira, namagtogat tanira tang mga kasalanan nira. Piro yamo, maski may tarin da mandian ang sobra pa ong ni Jonas, indi amo pa enged mamagparet ong toldok na. ");
INSERT INTO agn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ong kaldaw kang asi, tomalonga ka don tang Rayna tang Abagat ig maning ka ang yamo dapat kaman ang silotan. Tenged asing tokaw nagalin pa tanandia ong logar ang dorog kalawid para lamang mamasi ong kinata-wanan tang ading si Solomon. Piro telekan mi, may nakabot da tarin ang sobra pa ong ni Solomon!” ");
INSERT INTO agn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ganing pa si Jesus, “Pabetang ta, mga may malain ang ispirito ang lomboa ong taw ang sinledan na, ang boaten na magalig-alig ong logar ang anday wi na ig magdilem ta logar ang mapenayan na. Mga anday itaen nang mapenayan na, ");
INSERT INTO agn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","maning ong sadili na, ‘Magbaliko ra lamang ong taw ang inistarano tanopa sia.’ Ig ong pagbalik na, kabotan na tang taw ang midio tatang balay ang anday gistar don, limpio ra ig ariglado pa. ");
INSERT INTO agn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Animan magpanaw si tanandia ig mangimbitar pa enged ta pitong ispiritong mas malalain pa ong nandia. Oman tenled ang lagi tanira ig mistar si don. Animan ang taw ang asing lindoan tanopa sia ta malain ang ispirito, mas maliwag tang pagkabetang ang kaboton na mandian. Sia maning ka atan tang mainabo ong malalain ang mga taw mandian, magimong mas makaeled pa tang mabetangan nira.” ");
INSERT INTO agn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mintras pagbitala pa si Jesus ong mga taw, kiminabot tang nanay na ig mga logod na. Pinagoy lamang nira si Jesus ong teled tang balay ig don tanira pamagelat ong loa. ");
INSERT INTO agn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ganing tang tatang taw ong ni Jesus, “Asia ong loa tang nanay mo ig mga logod mo. Agdilemena nira.” ");
INSERT INTO agn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Siminabat si Jesus ang ganing, “Piro sinopa bato tang nanayo may ang mga logodo?” ");
INSERT INTO agn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Oman sinoldok na tang mga sinagpan na ig ganing, “Na yay ang nanayo ig ang mga logodo! ");
INSERT INTO agn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tenged ang sinopay pagtoman tang kaliagan tang Tatayo don ong langit, tanira yay ang agbibilango ang nanayo ig mga logodo.” ");
INSERT INTO agn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ong kaldaw kang asi, limindoa si Jesus ong balay ig napaning ong binit tang baybay. Don tanandia kiminarong para magtoldok. ");
INSERT INTO agn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Indi naboay, tiniripo-pokan da tanandia ta kadoro-doroan ang mga taw, animan ang bindoat na siminay tanandia ong tatang bilog ong dalay-dalayan tang talsi ig don si kiminarong. Ang mga taw don lamang ong takat. ");
INSERT INTO agn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sinoldokan tanira ni Jesus ta yading mga bagay, ang paggamit ta mga palimbawa. Ong tatang palimbawa na ganing tanandia, “May tatang taw ang napanaw ong koma na para magta-bol ta binik. ");
INSERT INTO agn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ong pagtara-bolon na, may mga binik ang nabo-log ong dalan. Siminogpo tang mga lamlam ig dayon ang laging sinompit nira. ");
INSERT INTO agn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","May mga binik kang nabo-log ong kabatoan ig manipit lamang tang tanek don. Animan namansilongay ang lagi. ");
INSERT INTO agn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Piro asing makintan tang kaldaw, nangalanet ang lagi tenged dibabaw lamang tang lamot na. ");
INSERT INTO agn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ang domang binik nala-sik ong kaibabawenan ang tenekan. Namanrabong tang mga ibabawen ig dineg na tang ba-long namansilongay. ");
INSERT INTO agn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","May doma pa enged ang binik ang nabo-log ong matambek ang tanek. Pagalongay, namambael ig namorak ta doro. Ang doma, tang gatos ang pasi kada koay na, may enem ang polok, ig may talo-long polok. ");
INSERT INTO agn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mamasi tang may talinga!” ");
INSERT INTO agn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Namampalenget ong ni Jesus tang mga sinagpan na ig namane-ma ang ganing, “Angay paggamita ta mga palimbawa mga pagtoldoka ong mga taw?” ");
INSERT INTO agn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ganing si Jesus ong nira, “Ang mga sikrito natetenged ong inadian tang Dios, agbebego ra ong nindio mandian para maintindian mi. Piro ong doma, indi tanira agbegen ta diritso. ");
INSERT INTO agn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ang taw ang may gaintindian na natetenged ong Dios, dolangan pa, ig doro pa enged tang maintindian na. Piro ang taw ang anday gaintindian na, maski ang ge-ley lamang ang gaintindian na, sia komiten pa ka enged ong nandia. ");
INSERT INTO agn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Animan pagbitalao ong mga taw ong mga palimbawa tenged maski pamansipa-dek tanira, indi tanira gangaita. Ig maski pamamasi, indi ka gangaintindi. ");
INSERT INTO agn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Animan mandian da nagmatod ong nira tang inaning tang propitang si Isaias asing tokaw pa ang ganing, ‘Mamasi amo man ang mamasi, indi amo ka mangaintindi. Ig maski pa-dek amo man tang pa-dek, indi amo ka mangaita. ");
INSERT INTO agn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tenged ang mga taw ang na, matetegat tang mga kolo nira. Ang mga talinga nira pamandamel da lamang tang pamasi, ig pineyeng da lamang nira tang mga mata nira para indi tanira mangaita ig indi mangabasi. Itaben mangaintindi pa tanira, magbalik pa tang nem nira ong yen, ig pao-yaeno tanira,’ ganing tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Piro yamo, masoirti amo tenged gangaita ig gangabasi amo. ");
INSERT INTO agn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ong kamatodan, dorong mga propita ig mga mato-lid ang taw asing tokaw ang gangaliliag din ang mangaita tang mga bagay ang gitaen mi mandian ig mangabasi tang gaba-yan mi ra. Piro sia indi nakabotan nira ong timpo nira.” ");
INSERT INTO agn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mandian, mamasi amo tang maliag yaning tang palimbawa natetenged ong manigta-bol. ");
INSERT INTO agn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ang mga binik ang nailat ong dalan, yay ang mga taw ang pamamasi tang bitala natetenged ong inadian tang Dios, piro indi gangaintindi. Dadaton ang lagi si Satanas ig agkomiten na tang bitala ang naloak da ong popotokon nira. ");
INSERT INTO agn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Ang mga binik ang nabo-log ong kabatoan, yay ang mga taw ang pamamasi tang bitala ig agrisibien ang lagi nira ang may kalipay. ");
INSERT INTO agn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Piro tenged belag ta de-dek ong popotokon nira, indi lamang maboay tang pagto nira. Mga agliwagan tanira obin aggakigan tenged ong pagtoman nira tang bitala tang Dios, dayon ang laging bo-wanan nira tang pagto nira. ");
INSERT INTO agn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Ang mga binik ang nangala-sik ong kaibabawenan, pario ka mga may mga taw ang pamamasi tang bitala tang Dios, piro pamagpaborido ong yading irintindien nira ig gaekelan ong manggad nira. Animan ang bitala tang Dios andang pisan ay borak na ong kaboi nira. ");
INSERT INTO agn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Piro ang binik ang nabo-log ong matambek ang tanek, yay ang mga taw ang pamamasi ig gangaintindi enged tang bitala tang Dios. Animan ang bitala may masinlong borak na ong kaboi nira. Ang doma kadoro-doroan, ang doma doro ka, ig ang doma kasarangan lamang.” ");
INSERT INTO agn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Inistorian ka tanira ni Jesus tang palimbawang na. Ganing tanandia, “Ang paggaraemen tang Dios bilang adi pario ong bindoat tang tatang taw asing nagloak ta masinlong binik ong koma na. ");
INSERT INTO agn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pagatapos ang nagloak, may tatang labi mintras gapoyat tang mga taw, napaning ong koma na tang kasoay na ig don nagta-bol ka ta ibabawen. ");
INSERT INTO agn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mandian, asing pamorak da tang paray, ba-lo inita ig nailala tang mga ibabawen. ");
INSERT INTO agn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Animan ang mga torobolon namampaning ong may nandia ig ganing, ‘Masinlong binik tang lindoak ta ong tanek mo. Angay dorong ibabawen na, ong aypa bato nagalin?’ ");
INSERT INTO agn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ganing tang may nandia, ‘Ang taw ang kasoayo yay ang nagboat ta sia!’ Animan nane-ma tang mga torobolon na ang ganing, ‘Onopa, bonlokon amen si?’ ");
INSERT INTO agn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ganing tanandia, ‘Indi ra, itaben mabonlok pa asta ang mga paray. ");
INSERT INTO agn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabayan mi ra lamang asta komabot tang pangangayeg. Ong pangangayeg da lamang tobolono tang mamanigayeg ang pamonlokon kang lagi nira tang mga ibabawen ig pame-ket be-keten para sirokon. Oman ba-lo ipasimeto ong nira tang pa-bat ong bodiga.’ ” ");
INSERT INTO agn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nagpadayon si Jesus ong pagbitala na ong mga taw ong tata sing palimbawa. Ganing tanandia, “Ang inadian tang Dios pario ong tatang alibotod ta mostasa ang lindoak ta tatang taw ong tanek na. ");
INSERT INTO agn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Na kage-ley ge-leyan ong tanan ang mga alibotod ang poiding iloak. Piro mga maloak da ngani, pambael asta mas mabael pa ong domang mga iloloak, ig midio papa ra ta ayo tang kalawig na. Maski ang mga lamlam poidi rang magboat ta poyad don ong mga tanga na.” ");
INSERT INTO agn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nagistoria pa si Jesus ta tata pang palimbawa. Ganing tanandia, “Ang inadian tang Dios pario ong pampalsa ta tinapay ang sinampora ta tatang babay ong tolong gantang ang arina. Maski ge-ley tang pampalsa, minalsa tang bilog ang minasa.” ");
INSERT INTO agn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Animan, ang tanan ang asia binitala ni Jesus ong mga taw ong mga palimbawa. Ig anday sinoldok na ong nira ang indi tanandia naggamit ta palimbawa. ");
INSERT INTO agn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bindoat na narin agod mainabo tang inaning tang Dios ong propita na asing tokaw ang ganing, “Mitalao ong nira ong mga palimbawa, Ibego ong nira tang mga bagay ang gatalok mimpisa pang bindoat tang kalibotan.” ");
INSERT INTO agn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pagatapos ta si, bino-wanan ni Jesus tang mga taw ig siminled ong balay. Namansidaton tang mga sinagpan na ig nagigampang ong nandia ang ganing, “Ipaintindi mo kay ong yamen tang maliag yaning tang palimbawa natetenged ong mga ibabawen.” ");
INSERT INTO agn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ganing si Jesus, “Ang taw ang asing nagloak tang masinlong binik anday doma kondi yo, ang Ana ta Taw. ");
INSERT INTO agn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ang tanek ang lindoakan yay ang kalibotan. Ang masinlong mga binik anday doma kondi ang mga taw ang gasakepan tang gaem tang Dios. Ig ang mga ibabawen yay ang mga taw ang gasakepan tang gaem ni Satanas. ");
INSERT INTO agn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Si Satanas tang taw ang kasoay ang yay nagta-bol ta ibabawen. Ang pangangayeg, ya ray ang kataposan tang kalibotan, ig ang mga mamanigayeg anday doma kondi ang mga anghil. ");
INSERT INTO agn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mga monopa agbonlokon tang mga ibabawen ig dayon ang sirokon, maning ka don tang mainabo ong kataposan tang kalibotan. ");
INSERT INTO agn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yo, ang Ana ta Taw, manobolo ong mga anghilo ang simeten ig palinen ong inadiano tang tanan ang taw ang yay ang gagikanan ang pamagkatalak tang mga karomanan nira, asta ang tanan ang pamagboat ta malain. ");
INSERT INTO agn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Oman dayon tanirang i-lek ong impirno, don ong apoy ang indi enged mapatay-patay asta ong tanopa. Ig don tanira mamagini-yak ig mamansikayeget tang mga isi nira. ");
INSERT INTO agn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Piro ang mga taw ang mato-lid mamansisinggat ang midio ra kaldaw don ong inadian tang Tatay nira. Mamasi tang may talinga!” ");
INSERT INTO agn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ang inadian tang Dios pario ong manggad ang limbeng ong tanek ig nāli ta tatang taw. Ang bindoat tang taw ang asi sinampekan na sing oman, ig ong sobrang kalipay na minolik ig pinabakal na tang tanan ang pagkabetang na. Oman dayon ang binakal na tang tanek ang asi.” ");
INSERT INTO agn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ya ka ang inadian tang Dios, pario ka ong maralen ang pirlas ang yay ang agdilemen ta tatang nigosianti. ");
INSERT INTO agn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Asing pagaita na tang tatang maralen ang enged, minolik tanandia ig pinabakal na tang tanan ang pagkabetang na, ig dayon ang binakal na tang pirlas ang asi.” ");
INSERT INTO agn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ang mainabo ong inadian tang Dios mapapario ong nainabo asing may lambat ang tina-tak ong talsi ig sari-saring yan tang nakomit na. ");
INSERT INTO agn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Asing ponok da tang lambat ta yan, pinatakat da ong baybay. Oman dayon dang namansikarong tang mga taw para belag-belagan tang mga yan. Ang masisinlo bintang nira ong tiklis ig ang mga anday sasayod pinlek lamang nira. ");
INSERT INTO agn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Maning ka atan tang mainabo ong kataposan tang kalibotan. Ang mga anghil komabot para ipabelag tang mga taw ang malalain ong mga taw ang moro-ya. ");
INSERT INTO agn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Oman ang mga malalain i-lek ong impirno, don ong apoy ang indi enged mapatay-patay asta ong tanopa. Ig don tanira mamagini-yak ig mamansikayeget tang mga isi nira.” ");
INSERT INTO agn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pagatapos, nane-ma si Jesus ong nira ang ganing, “Onopa? Naintindian mi ra tang tanan ang inaningo ong nindio?” “Ee, naintindian amen,” ganing tanira. ");
INSERT INTO agn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ig ganing si Jesus, “Animan mandian, ang kada manigtoldok tang Katobolan, mga may gata-wanan na ka natetenged ong paggaraemen tang Dios bilang adi, ang taw ang asi pario ka ong may nandia ta balay ang dorong kagamitan na. Ig belag lamang tang dating mga gamit tang agpaloa na ong bodiga na, kondi asta ra ka ang mga ba-lo.” ");
INSERT INTO agn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Asing pagatapos ni Jesus ang nagtoldok tang mga palimbawang na, dayon tanandiang nagalin don. ");
INSERT INTO agn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Minolik ong sadiling logar na, ig don nagtoldok ong simban nira. Nangabereng tang tanan ang nangabasi tang mga agtotoldok na. Animan pamagtere-ma te-man tanira ang ganing, “Ong aypa bato nakomit tang taw ang na tang kinata-wanan na? Angay gapagboat tanandia ta mga milagro? ");
INSERT INTO agn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Gailala ta tang taw ang na! Ana ka lamang tanandia tang karpintiro! Ang nanay na si Maria ig ang mga logod na da Santiago, Jose, Simon ig Judas. ");
INSERT INTO agn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Asta ang mga logod nang mga babay tarin ka pamansistar. Ta, ong aypa bato nakomit na tang mga abilidad nang na?” ");
INSERT INTO agn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ig tenged ong kaerep nira, indi enged ilalaen nira. Animan ganing si Jesus ong nira, “Ang tatang propita aggilalaen tang tanan ang taw, poira lamang ong mga kasimanoa na ig ong pamalay-balay na.” ");
INSERT INTO agn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ig tenged indi tanira mamagparet, indi tanandia napagboat ta yading milagro don. ");
INSERT INTO agn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mandian si Herodes, ang pangolokolo ong Galilea, naba-yan na tang natetenged ong mga agboaten ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Animan ganing si Herodes ong mga opisialis na, “Aroy! Sia si Juan ang Manigboniag ang naboing oman! Animan sia may gaem nang magboat ta mga makabebereng ang mga bagay!” ");
INSERT INTO agn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Na yay ang kaisip ni Herodes tenged tanopa sia tanandia tang nagpadep ong ni Juan, oman pinalapot na ig pinapriso. Bindoat narin ni Herodes tenged pirming agsamblengen tanandia ni Juan tenged ong pagiga-pen a-pen na ong babay ang si Herodias, ang katawa tang logod nang si Felipe. Narin tang pirming agganing ni Juan, “Kontra ong Katobolan ta ang magkatawan amo tang katawa tang logod mo!” ");
INSERT INTO agn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tenged tarin, galiliag din si Herodes ang ipapatay na si Juan, piro geldan tanandia ong mga taw, tenged si Juan aggilalaen nirang propita tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Oman, asing kiminabot tang kakaldawan ni Herodes, ang anang babay ni Herodias nagtayaw ong talongan tang mga bisita. Ig nalipay ang pisan tang ading si Herodes. ");
INSERT INTO agn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Animan ganing ang nanompa tang adi ong soltiras, “Mama-dola ong yen maski onopay galiagan mo, ig i-dolo ong nio.” ");
INSERT INTO agn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ong solsol tang nanay na siminabat tang soltiras ang ganing, “I-dol mo kay ong yen mandian ang lagi tang kolo ni Juan ang Manigboniag, ang agbe-tang ong tatang bandiha.” ");
INSERT INTO agn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pagabasi tang adi, pinongawan tanandia ta mo-ya. Piro tenged ong pangako na ong soltiras ang naba-yan mismo tang mga bisita, pinaboat na ra lamang tang pina-dol tang soltiras. ");
INSERT INTO agn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Pinapotolan na ta likel si Juan don ong prisoan. ");
INSERT INTO agn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Oman bintang tang kolo ong tatang bandiha ig ingkelan ong soltiras. Ig narin dayon kang inintriga tang soltiras ong nanay na. ");
INSERT INTO agn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Animan pinaningan don tang mga sinagpan ni Juan, kinomit nira tang sinangoni na ig limbeng. Pagatapos, napaning tanira ong ni Jesus ig binalita nira tang nainabo. ");
INSERT INTO agn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pagabasi ta si ni Jesus, siminay tanandia ong bilog ig tambilog lamang tanandiang napaning ong logar ang anday gistar ang taw. Piro asing pagatako tang mga taw ang napagalin da tanandia, namagalin ka tanira ong mga kababarioan nira ig namagpanaw ang pangobay tang baybay paning ong logar ang agrombon na. ");
INSERT INTO agn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pagataboan ni Jesus, inita na tang kadoro-doroan ang mga taw ang asi. Dorong katete-beken na ong nira, animan pinao-ya na tang mga pamagmasit ang ingkelan nira don. ");
INSERT INTO agn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Asing apon da, namampalenget ong nandia tang mga sinagpan na ig minaning, “Madali rang makorop tang kaldaw, ig anda paman ay mga taw ang gistar ong logar ang na. Mo-ya pa sigoro, papaningen mo ra tang mga taw ong mga bario para mapamakal tanira ta mapangan nira.” ");
INSERT INTO agn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Piro siminabat si Jesus, “Maski indi ra papagalinen ta tanira. Yamo tang magtorol ta mapangan nira.” ");
INSERT INTO agn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ganing ka tang mga sinagpan na, “Aroy, monora bato? Lima ka lamang bilog ang tinapay ig doroa ka lamang bilog ang yan tang ekel ta!” ");
INSERT INTO agn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ganing si Jesus ong nira, “Abir, e-lan mi sia tani.” ");
INSERT INTO agn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Oman pinakarong na tang mga taw ong kaibabawenan. Kinomit na tang limang bilog ang tinapay may ang doroang bilog ang yan. Siminingara tanandia ong langit ig nagpasalamat ong Dios. Oman pinisi-pisi na tang mga tinapay ig sindol ong mga sinagpan na para itagtag ong mga taw. ");
INSERT INTO agn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nangapamangan tang tanan ang taw ig poros nangaelen. Pagatapos, sinimet tang mga sinagpan na tang nanga-da, ig nanga-mok pa tanira ta tampolok may doroang tiklis. ");
INSERT INTO agn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ang mga laling namamangan bali limang ribo rang lagi, poira pa tang mga babay ig ang mga mola. ");
INSERT INTO agn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pagatapos ta si, dayon ang laging sinobol ni Jesus tang mga sinagpan na ang tomay da ong bilog nirang mabael agod tongkaw da ong dobaling baybay mintras agpaoliken na pa tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pagapagalin tang mga taw, siminakat si Jesus ong tatang bokid ang tanandia lamang para mangadi. Nalabian tanandia don. ");
INSERT INTO agn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Piro ong oras kang asi, don da ong laod tang bilog ang agtayan tang mga sinagpan na ang agtampok-tampokon tang mga langeb tenged panongtong ong mageyep. ");
INSERT INTO agn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ig asing garamal da, diminaton da si Jesus ong nira ang papanaw ong ta-paw tang talsi. ");
INSERT INTO agn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pagaita tang mga sinagpan na ang may papanaw ong ta-paw tang talsi, pisan tanirang namangelel ig ong sobrang karaelden nira nangaiteg pa ang ganing, “May peled!” ");
INSERT INTO agn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Piro minitalang lagi si Jesus ong nira ang ganing, “Indi amo meled. Yo na, si Jesus!” ");
INSERT INTO agn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Oman minaning si Pedro, “Gino! Mga yawa kaman sia, papaningeno nio atan ong ta-paw tang talsi ang papanaw.” ");
INSERT INTO agn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ganing si Jesus, “Tania!” Minabak si Pedro ong bilog ig napanaw ong ta-paw tang talsi, ang agpaning ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Piro asing pagaita ni Pedro ang mapoirsa tang mageyep, inledan tanandia ig tatalmed da rin. Animan miniteg tanandia ang ganing, “Gino, tabang!” ");
INSERT INTO agn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ig kinirabot ang lagi ni Jesus. Oman ganing si Jesus ong ni Pedro, “Angay nagdoadoā? Korang pa ka enged tang pagtalig mo!” ");
INSERT INTO agn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pagatay lamang nira ong bilog, dayon ang laging nagpoas tang mageyep. ");
INSERT INTO agn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ig tinowan si Jesus tang mga aroman nira don ong bilog ang ganing, “Matod ka kaman ang yawa tang Ana tang Dios!” ");
INSERT INTO agn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pagakabot nira ong dobaling baybay, don tanira siminampet ong Genesaret. ");
INSERT INTO agn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nailalang lagi si Jesus tang mga taga don, animan binalitang lagi nira ong tanan ang logar ang gasakep don ang kiminabot da si Jesus. Animan ingkelan tang mga taw ong nandia tang tanan ang mga pamagmasit nira. ");
INSERT INTO agn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Namagpakiloy tanira ong ni Jesus ang maski mate-lek da lamang tang mga pamagmasit tang kapotan tang lambong na. Ig ang tanan ang nangate-lek, namago-ya. ");
INSERT INTO agn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tatang kaldaw may mga Pariseo ig mga manigtoldok tang Katobolan ang nagalin ong Jerusalem ang namansipalenget ong ni Jesus. Sine-ma nira ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Angay agkontraen tang mga sinagpan mo tang mga toromanen ang pinanoblian ta ong mga kamepet-mepetan ta? Pamamangan lamang ang indi pamamanaw tang mga kalima nira sigon ong kaogalian ta!” ");
INSERT INTO agn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ganing si Jesus ang siminabat, “Angay yamo, agkontraen mi ka tang tobol tang Dios para lamang matoman mi tang toromanen mi? ");
INSERT INTO agn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ganing tang tobol tang Dios, ‘Galangen mo tang tatay mo may ang nanay mo,’ ig ‘Ang sinopay magbitala ta malain kontra ong tatay obin ong nanay na, dapat patayen.’ ");
INSERT INTO agn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Piro yamo, parti tang agtotoldok mi. Tenged ganing amo, mga ang taw may matabang na rin ong mga ginikanan na, poiding maning ong nira, ‘May itabango rin ong nindio, piro indi ra ma-dolo tenged nangakō ra ang i-dolo ong Dios.’ ");
INSERT INTO agn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ig ganing among mga maning don, anda ray kaministiran ang tabangan na pa tang mga ginikanan na. Animan, agboaten ming anday kointa na tang tobol tang Dios tenged ong kaogalian ming asia. ");
INSERT INTO agn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mga manloloko amo ig mga traidor! Ang pagto mi ong Dios paita-ita lamang! Animan tama kaman tang inaning tang Dios natetenged ong nindio ang pinasolat na ong propitang si Isaias ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ang mga taw ang na aggalangeno nira ong anga lamang. Piro ong kamatodan, ang popotokon nira alawid ong yen. ");
INSERT INTO agn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Anday data na tang pagto nira ong yen, tenged ang mga agtotoldok nirang ganing mga tobol tang Dios, toromanen ang boat-boat lamang ta taw.’ ” ");
INSERT INTO agn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ginoyan ni Jesus tang mga taw ang palenget ong nandia ig minaning ong nira, “Mamasi amo ta mo-ya agod maintindian mi tang ibitalao ong nindio. ");
INSERT INTO agn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Belag tang agte-led ong sinangoni ta taw tang pagpaboling ong nandia ong pama-dek tang Dios, kondi ang mga malalain ang loloa ong anga na.” ");
INSERT INTO agn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Maboay-boay ta ge-ley, namansipalenget tang mga sinagpan na ang ganing, “Nata-wanan mo ka? Nasilag tang mga Pariseo ong binitala mong asi.” ");
INSERT INTO agn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Siminabat si Jesus, “Ang kada iloloak ang indi lindoak tang Tatayong asi ong langit, bonlokon ang enged. ");
INSERT INTO agn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabayan mi lamang tanira. Mga boray tanirang pamagantabay ong kapario nirang mga boray. Ig mga ang boray yay ang magantabay ong kapario nang boray, pario tanirang mabo-log ong adalem ang galoang.” ");
INSERT INTO agn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Oman ganing si Pedro ong nandia, “Ipaintindi mo kay ong yamen tang maliag yaning tang palimbawang asi nongaina.” ");
INSERT INTO agn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ganing si Jesus ong nira, “Asta yamo, indi amo pa gangaintindi? ");
INSERT INTO agn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Indi gata-wanan mi? Ang maski onopay te-led ong anga pagdiritso ong sian, oman loloa ong sinangoni. ");
INSERT INTO agn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Piro ang loloa ong anga, pagalin mismo ong popotokon, ig sia yay ang pagpaboling ong taw ong pama-dek tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tenged don mismo ong popotokon ta taw pagalin tang anday sasayod ang mga pagirisipen ig ang mga boat ang malalain, pario tang pamatay ta taw, ang pangombabay obin pangonlali, ang pagiga-pen a-pen ong belag ta katawa na, panakaw, pamirdi ta dengeg tang masig ka taw na, ig ang pagtistigo ta bo-li. ");
INSERT INTO agn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Animan ang tanan ang asia tang pagpaboling ong taw, ig belag tang mga indi tanandia pagosoy ong tamang pagpamanaw tang kalima na ba-lo mamangan.” ");
INSERT INTO agn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Namagalin da Jesus don ig namansipaning ong mga logar ang sakep tang mga siodad tang Tiro ig Sidon. ");
INSERT INTO agn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mandian, may tatang babay ang Cananea, ang belag ta Israelita, ang gistar ong logar ang asi. Napalenget tanandia ong ni Jesus ig nagpakiloy ang ganing, “Gino, Inampo ni David, mate-beka ong anao ang babay! Sinled tanandia ta dimonio ig pagpinitinsia ra ta mo-ya.” ");
INSERT INTO agn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Piro indi nagintindi si Jesus. Animan ang mga sinagpan na napalenget ong nandia ig ganing, “Paoyona ra lamang agod magalin da. Sigi lamang tang daton-daton na ong yaten ig dorog kaingal!” ");
INSERT INTO agn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Piro siminabat si Jesus, “Yo, sinobolo para tabangan tang mga Israelita lamang, tenged pario ra tanira ong mga karnirong ganga-ngi ta dalan.” ");
INSERT INTO agn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Piro napalenget pa ka enged tang babay ong ni Jesus, liminod ong talongan na ig minaning, “Gino, tabangay ka!” ");
INSERT INTO agn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Piro siminabat si Jesus ong tatang sarabien ang ganing, “Belag ono ta tama ang komiten tang pamangan tang mga mola oman i-dol ong mga kiro.” ");
INSERT INTO agn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Siminabat si tang babay, “Matod ka kaman, Gino. Piro maski ngani ang mga kiro, gapamangan tang namek ang gangabo-log ong lamisan tang agalen nira.” ");
INSERT INTO agn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Animan ganing si Jesus, “Dorog kabael tang pagtalig mo! Mainabo enged tang agpa-dolon mo.” Ig ong oras kang laging asi nago-ya tang ana na. ");
INSERT INTO agn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nagalin si Jesus don ong logar ang asi ig nagbalik ong binit tang baybay tang Galilea. Siminakat tanandia ong tatang bokid ig don kiminarong. ");
INSERT INTO agn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Dorong mga taw tang namansipaning don ong nandia. Ingkelan nira tang mga piang, ang mga pingkaw, ang mga boray, mga boyon ig doro pa enged ang may mga masit nira. Aggekelan nira ong talongan ni Jesus ig pinao-ya na tanirang tanan. ");
INSERT INTO agn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nangabereng ta mo-ya tang mga taw tenged inita nirang bibitala ra tang mga boyon, mo-ya ra tang mga kalima tang mga pingkaw, ang mga piang gangapanaw da ig ang mga boray gangaita ra. Ig ang tanan ang mga taw don namagdayaw ong Dios tang Israel. ");
INSERT INTO agn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Asing don pa tanira ong bokid, ginoyan ni Jesus tang mga sinagpan na ang palenget ig minaning, “Gate-beko ong mga taw ang na, tenged tolo rang kaldaw tanirang ka-pen ta, ig mandian anda ray mapangan nira. Indio galiliag ang paoliken tanirang indi gangapamangan, itaben tomomba tanira ong dalan.” ");
INSERT INTO agn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ganing tang mga sinagpan na, “Ong ari ita pa bato makomit ta pamangan tarin ong logar ang na ang anday gistar ang taw ang magigo ong nang kadoro-doroan ang taw?” ");
INSERT INTO agn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nane-ma si Jesus, “Pirapa pang bilog tang tinapay mi atan?” “Pito ra lamang bilog ang tinapay ig pirapang bilog ang yan ang gege-ley,” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Oman pinakarong ni Jesus tang mga taw ong tanek. ");
INSERT INTO agn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kinomit na tang pitong bilog ang tinapay ig ang yan ang gege-ley ig nagpasalamat ong Dios. Pinisi-pisi na si ig sindol ong mga sinagpan na, oman sinagtag nira ong mga taw. ");
INSERT INTO agn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nangapamangan tang tanan ang taw ig poros nangaelen. Pagatapos, sinimet tang mga sinagpan na tang nanga-da, ig nanga-mok pa tanira ta pitong tiklis. ");
INSERT INTO agn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mga epat ang ribo rang lagi tang mga laling namamangan poira pa ong mga babay ig mga mola. ");
INSERT INTO agn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pagatapos ta si, dayon dang pinaolik ni Jesus tang mga taw, ba-lo tanandia siminay ong tatang bilog ang mabael, aroman na tang mga sinagpan na, para paning ong logar ang Magadan. ");
INSERT INTO agn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","May mga Pariseo ig mga Saduseo ang namampalenget ong ni Jesus para sobokan nira. Ganing tanira, “Abir, magpaitā kay ong yamen ta milagro bilang tanda ang yawa matod ang nagalin ong Dios.” ");
INSERT INTO agn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ganing si Jesus ang siminabat, “Mga gakorop da tang kaldaw ig ang langit masinggi, ganing amo, ‘Masinlo tang timpo ong damal.’ ");
INSERT INTO agn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ig mga ba-lo tenla tang kaldaw, mga ang langit masinggi ig pangi-lep, ganing amo ka, ‘Komoran mandian.’ Gatako among manaid mga onopa tang maliag yaning tang mga pasinial ang gitaen mi ong langit may ong tanek. Piro angay indi gata-wanan mi tang maliag yaning tang mga tanda ang agpaita mandian ang mga timpo? ");
INSERT INTO agn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yamong mga traidor amo! Kalalain tang ogali mi! Pamagdilem amo ta milagro ba-lo amo magparet. Piro anday ipaita ong nindio, poira lamang ong tatang makabebereng ang bagay ang pario tang nainabo ong propitang si Jonas asing tokaw.” Pagabitala na ta si, nagalin ang lagi tanandia. ");
INSERT INTO agn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Asing siminay da Jesus para loma-ted ong dobaling baybay, nangalipat pala tang mga sinagpan na ang namagbalon ta pamangan. ");
INSERT INTO agn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mintras lalayag tanira, ganing si Jesus ong nira, “Magandam amo ong pampalsa ta tinapay tang mga Pariseo ig mga Saduseo.” ");
INSERT INTO agn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tenged don, namagampang-ampang tang mga sinagpan na, “Sigoro maning ta si tang inaning na tenged indi ita napamagbalon ta tinapay.” ");
INSERT INTO agn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gata-wanan ni Jesus tang agpagampangan nira, animan ganing ong nira, “Korang pa enged tang pagtalig mi! Angay pamagpalibeg amo tang mga kolo mi ang anday ekel ming tinapay? ");
INSERT INTO agn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Indi amo pa enged gangaintindi? Onopa? Nalipatan mi ra asing pagpisi-pisio tang limang bilog ang tinapay para mangapamangan tang sobra ong limang ribong taw? Pirapang tiklis tang nasimet mi ong nanga-da? ");
INSERT INTO agn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Asta ang pagpisi-pisio tang pitong bilog ang tinapay para ong sobra ong epat ang ribong taw, pirapa kang tiklis tang nasimet mi? ");
INSERT INTO agn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Animan angay indi amo nangaintindi ang belag ta tinapay tang maliagong yaning asing paganingo ang ‘Magandam amo ong pampalsa ta tinapay tang mga Pariseo ig mga Saduseo.’ ” ");
INSERT INTO agn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ig don ba-lo pa nata-wanan nira ang belag pala tang pampalsa ang aggamiten ong tinapay tang dapat andaman nira, kondi ang mga agtotoldok tang mga Pariseo ig mga Saduseo. ");
INSERT INTO agn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mandian, asing da Jesus don da ong logar tang siodad ang aggoyan ta Cesarea ni Filipos, sine-ma na tang mga sinagpan na ang ganing, “Gonopa tang mga taw natetenged ong yen, ang Ana ta Taw? Yo, sinōpa ono?” ");
INSERT INTO agn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Siminabat tanira, “Ganing tang doma, yawa ono si Juan ang Manigboniag. Ang doma ganing ka, yawa ono si Elias. Ig ganing pa ka tang doma, yawa ono si Jeremias ig mga belag, tata pa ong mga propita asing tokaw.” ");
INSERT INTO agn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ig ganing si Jesus ong nira, “Piro mga ong nindio, yo sinōpa?” ");
INSERT INTO agn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ang siminabat si Simon Pedro, “Yawa tang Cristo, ang Ana tang Dios ang boi!” ");
INSERT INTO agn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dayon ang minaning si Jesus ong ni Simon, “Simon, ana ni Jonas, masoirtia tenged belag ta taw tang nagbeg ta narin ong nio, kondi ang Tatayo don ong langit. ");
INSERT INTO agn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ig mandian, ang igoyo ra ong nio ay Pedro, maliag yaning tatang bato. Ig ong pondasion ang nang bato, ipa-dengo tang yen ang simban, ang yay ang tanan ang mga taw ang magto ong yen. Maski kamatayen pa, anday gaem nang mandeg ong nira. ");
INSERT INTO agn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","I-dolo ong nio tang katengdanan ang pa-penen tang mga taw ong inadian tang Dios ig magekel ong nira. Ang maski onopay bawalen mo tarin ong ta-paw tang kalibotan, bawalen ka tang Dios ong langit. Ig ang maski onopay ipagna mo, ya kay ang ipagna tang Dios ong langit.” ");
INSERT INTO agn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Oman maelet ang sinoyonan ni Jesus tang mga sinagpan na ang indi enged mamagbeg maski ong ninopa ang tanandia tang Cristo. ");
INSERT INTO agn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mimpisa don, nagimpisa ra si Jesus ang nagsaysay ong mga sinagpan na mga onopa tang mainabo ong nandia. Ganing tanandia, “Kaministiran ang paningo ong Jerusalem agod don mapasarano tang tanan ang kaliwagan ang boaten ong yen tang mga mepet tang banoa, ang mga pangolokolo ong mga padi, ig ang mga manigtoldok tang Katobolan. Kaministiran ang patayeno, piro ong ya-long kaldaw maboiong moman.” ");
INSERT INTO agn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pagabitala lamang ni Jesus ta si, ingkelan tanandia ni Pedro ong alawid-lawid ig agsamblengen na rin. Ganing si Pedro ong ni Jesus, “Palawid lamang tang inaning mong asia! Indi dapat mainabo ong nio.” ");
INSERT INTO agn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Minalied si Jesus, siminalonga ong ni Pedro, ig sinabat nang lagi, “Lomayasa tarin, Satanas! Pagsambera lamang ong yen! Belag ta kaliagan tang Dios tang aggisipen mo, kondi kaliagan ta taw!” ");
INSERT INTO agn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Oman ganing si Jesus ong mga sinagpan na, “Ang sinopay galiliag ang tomabid ong yen, kaministiran ang lipatan na tang sadili na ig magosoy ong yen, maski kamatayen pa tang talongaen na ong pagtoman na ong yen. ");
INSERT INTO agn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tenged ang taw ang agpalabien na tang kaboi na tarin ong ta-paw tang kalibotan, tanandia tang malipatan tang kaboi na. Piro ang sinopay magbolontad tang kaboi na para ong yen, tanandia tang marisibi ta kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Onopa enged ay mapakinabangan ta tatang taw maski magimong nandia ra tang tanan ang bagay tarin ong kalibotan, piro malipat ka ong nandia tang kaboi na? Anda! Tenged andang pisan ay mabayad ta taw para igawad na ong kaboi na. ");
INSERT INTO agn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tenged yo, ang Ana ta Taw, magbaliko tarin ong kalibotan ang pagekelo tang gaem ig kayagan tang Tatayo ong langit, ig aromano ka tang mga anghil na. Ig ong oras ang asi balteno tang tanan ang taw sigon ong mga bindoatan nira. ");
INSERT INTO agn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tandan mi narin: Ang doma tarin ong nindio mandian, kabotan pa nira tang kaldaw ig itaeno nira, ang Ana ta Taw, ang pagbalik tarin bilang Adi.” ");
INSERT INTO agn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagata-lib tang enem ang kaldaw, ingkelan ni Jesus si Pedro ig ang doroang maglogod ang da Santiago ni Juan para koma-yat ong alawig ang bokid. Tanira-tanira lamang tang napaning don. ");
INSERT INTO agn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Oman don ong talongan tang mga sinagpan na, nagoman tang itsora ni Jesus. Nangayag tang emet na ang midio ra kaldaw, ig naningolit tang lambong na ang pisan ang sisinggat. ");
INSERT INTO agn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Oman golping napaita ong tolong sinagpan si Moises may si Elias ang pamagigampang ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Animan minitala si Pedro ang ganing, “Gino, masinlong narin ami! Mga maliaga, magboat ami ta tolo nga payag-payagan. Tata para ong nio, tata ong ni Moises, ig tata ong ni Elias.” ");
INSERT INTO agn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Asing bibitala pa si Pedro, golpi tanirang binongot ta makilaw ang onom ig may tatang bosis ang naba-yan nirang nagalin don ong onom ang ganing, “Na tang agmalenong Anao. Galipayo ta mo-ya ong nandia! Mamasi amo ong nandia!” ");
INSERT INTO agn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagabasi ta si da Pedro, dayon tanirang diminagpa ong sobrang eled nira. ");
INSERT INTO agn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Oman pinalengetan tanira ni Jesus ig sinandeg ang ganing, “Kendeng amo! Indi amo meled!” ");
INSERT INTO agn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pagpa-dek nira, anda ray inita nirang domang taw, si Jesus da lamang. ");
INSERT INTO agn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Asing totoldak da tanira ong bokid, maelet tang toyon ni Jesus ong nira ang ganing, “Indi enged ibeg mi tang inita mi maski ong ninopa mintras yo, ang Ana ta Taw, indio pa gaboing oman.” ");
INSERT INTO agn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Oman nane-ma tanira ong ni Jesus, “Angay ganing tang mga manigtoldok tang Katobolan, kaministiran ono ma-kaw ang komabot si Elias ba-lo pa tang Cristo?” ");
INSERT INTO agn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Siminabat si Jesus, “Matod kaman kaministiran ang tongkaw si Elias para magsimpan tang tanan ang bagay. ");
INSERT INTO agn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Piro begen amo yen, kiminabot da si Elias. Piro indi tanandia nailala tang mga taw, kondi bindoat nira ong nandia tang tanan ang kaliagan nirang boaten. Ig maning ka ta si tang boaten nira ong yen, ang Ana ta Taw. Paliwagano ka nira.” ");
INSERT INTO agn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ig don ba-lo pa naintindian tang mga sinagpan ni Jesus ang si Juan ang Manigboniag yay ang agganingen na ong pagsambit na ong ni Elias. ");
INSERT INTO agn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pagatoldak da Jesus, kinabotan nira tang dorong mga taw. May tatang lali don ang napalenget ong ni Jesus ig liminod ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Magino, mate-beka ong anao ang lali! Agkeren tanandia ig mga agkaboton ngani, pisan ang agliwagan. Teta gatomba ong apoy ig teta gabo-log ong wi. ");
INSERT INTO agn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ingkelano ra tanandia ong mga sinagpan mo, piro indi mapao-ya nira.” ");
INSERT INTO agn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Siminabat si Jesus, “Ay, yamong mga taw amo! Andang pisan ay pagtalig mi ig matetegat tang kolo mi! Asta tanopa tang agoantao ig tiniro ong nindio? Abir, ekelan mi tani tang molang asia.” ");
INSERT INTO agn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Oman dayon ang sinambleng ni Jesus tang malain ang ispirito ang don ong mola ig limindoang lagi. Ig ong oras kang laging asi nago-ya tang mola. ");
INSERT INTO agn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Asing tanira-tanira ra lamang, namansipalenget ong ni Jesus tang mga sinagpan na ig nane-ma ang ganing, “Angay yami, indi mapalayas amen tang malain ang ispirito ong molang asi?” ");
INSERT INTO agn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ganing si Jesus ang siminabat, “Tenged korang tang pagtalig mi. Piro agganingo ong nindio, mga may pagtalig mi ang maski pario ra lamang ong alibotod tang mostasa tang kabael na, poidi amo rang maning ong bokid ang asi, ‘Loma-teda ra don!’ ig sia loma-ted ka kaman. Anda enged ay bagay ang indi maboat mi. ");
INSERT INTO agn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Piro ang malain ang ispiritong maning atan, indi basta-basta mapalayas mga indi amo mangadi ig magpaletem.” ");
INSERT INTO agn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Asing mamagsimet tang mga sinagpan na don ong Galilea, ganing si Jesus ong nira, “Yo, ang Ana ta Taw, traidorono ig yintrigao ong gaem tang mga taw ");
INSERT INTO agn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ang yay mamamatay ong yen. Piro ong ya-long kaldaw maboiong moman.” Pagabasi tang mga sinagpan na, pinongawan tanira ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pagakabot da Jesus ong Capernaum, pinalengetan si Pedro tang mga manigtokot ta bois ong Timplo ig sine-ma, “Onopa? Indi pagbayad tang Maistro mi ta bois ang para ong Timplo tang Dios?” ");
INSERT INTO agn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Siminabat si Pedro ang ganing, “Pagbayad ngani tanandia!” Paga-led ni Pedro ong balay, sine-mang lagi tanandia ni Jesus ang ganing, “Simon, mga ong nio lamang, sinopa tang agpapagbayaden ta bois obin podintis tang mga adi tarin ong kalibotan? Ang mga ana nira obin ang mga belag?” ");
INSERT INTO agn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ganing ang siminabat si Pedro, “Simpri ang mga belag.” Ganing si Jesus, “Mga maning ta si, maliag yaning ang mga ana nira anday kaministiran ang magbayad. ");
INSERT INTO agn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Piro mga indi ita magbayad, itaben ang domang taw maglain tang nem nira ong yaten. Animan paninga ra lamang ong talsi ig magpatondia don. Ang primirong yan ang matondi mo bo-kaden mo tang anga na, ig don itaen mo tang tatang koartang silber. Komiten mo, ig ibayad mo ong mga manigtokot ta bois para ong yaten ang doroa.” ");
INSERT INTO agn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ong oras ang asi, napalenget ong ni Jesus tang mga sinagpan na ig nane-ma ang ganing, “Sinopa ong yamen tang kaimportantian ong inadian tang Dios?” ");
INSERT INTO agn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ginoyan ni Jesus tang tatang mola don ig pina-deng na ong ka-ngan nira. ");
INSERT INTO agn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Oman ganing tanandia ong mga sinagpan na, “Ong matod, mga indi amo magba-lo ig magimong pario ong tatang mola, indi amo enged mabilang ong inadian tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tenged ang taw ang gatakong magpababak tang sadili na pario ong molang na, tanandia yay ang agbibilang ang kaimportantian ong inadian tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ig ang maski sinopa, mga natetenged ong pagto na ong yen, magrisibi ong tatang mola ang pario ta narin, sia pagrisibi ka ong yen.” ");
INSERT INTO agn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Piro mga may taw ang magtokso agod magkatalak tang maski tata ong mga molang narin ang pamagtalig ong yen, mo-ya pa ta-ketan da lamang tang likel na ta mabael ang bato, oman bontogan ong laod. ");
INSERT INTO agn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kailo ka tang mga taw tarin ong kalibotan! Tenged pirming kakabot tang mga bagay ang pagtokso ong nira ang magkatalak. Ang mga bagay ang na mainabong enged. Piro mas kailo ka tang taw ang agpagalinan ta na. ");
INSERT INTO agn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Animan mga ang kalima mo obin ang kakay mo yay ang pagekel ong nio ang magkatalak, potolon mo ig ibanggil! Tenged mas mo-ya pang maski potol tang tambilog ang kalima mo obin kakay mo, ma-leda pa ong langit, kaysa komplito tang mga kalima ig kakay mo piro i-leka ka don ong impirno, ong apoy ang indi enged mapatay-patay. ");
INSERT INTO agn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ig mga ang mata mo ya kay ang gagikanan ang yawa pagkatalak, koaten mo ig ibanggil! Mo-ya pang maski tambilog lamang tang mata mo, basta ma-leda ong langit, kaysa doroa tang mata mo oman i-leka ka don ong apoy ong impirno.” ");
INSERT INTO agn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Magandam amo ang indi enged ge-ley ge-leyen mi maski tata ong mga molang narin. Tenged ong matod, ang mga anghil nira ay pirmi ong talongan tang yen ang Tatay ong langit para tomabang ong nira. ");
INSERT INTO agn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Yo, ang Ana ta Taw, napaningo tarin ong kalibotan para dilemen ig ilibri tang mga taw ang ganga-ngi ta dalan. ");
INSERT INTO agn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Pabetang ta, mga may taw ang tang gatos tang karniro na ig galipat tang tambilog. Onopa bato tang boaten na? Sigorado enged ang bo-wanan na tang siam ang polok may siam don ong kamayagan ig dilemen na tang galipat. ");
INSERT INTO agn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mga matoman na ra ngani, malipay ang enged tanandia ta mo-ya, sobra pa ong kalipay na ong siam ang polok may siam ang indi nalipat. ");
INSERT INTO agn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Maning ka ta sia tang Tatay mi don ong langit. Tenged indi enged tanandia galiliag ang may malbag ong nandia ig silotan asta ong anday kataposan, maski tata ong mga molang narin.” ");
INSERT INTO agn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mga magkatalak ong nio tang tatang logod mo, paningan mo tanandia ig kampangen. Piro boaten mo narin ang doroa-doroa amo lamang. Mga mamasi tanandia ong nio, maginolikan si tang nem mi ig mapabalik mo tanandia ong Dios. ");
INSERT INTO agn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piro mga indi tanandia magigo-ya ong nio, magekela ta tata obin doroa ong mga aroman mo agod ang tanan ang pagampangan mi mapamatodan ta doroa obin tolong tistigos. ");
INSERT INTO agn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Piro mga indi pa enged tanandia mamasi ong nindio, ibeg mo ong tanan ang karomanan mi ong tarabidan mi. Ig mga indi pa ka enged tanandia mamasi ong nira, indi ra sapeten mi kondi ibilang mi ra lamang pario ong taw ang indi gailala ong Dios, obin pario ka ong tatang dayador ang manigtokot ta bois.” ");
INSERT INTO agn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ganing pa si Jesus, “Ang maski onopay bawalen mi tarin ong ta-paw tang kalibotan, bawalen ka tang Dios ong langit. Ig ang maski onopay ipagna mi, ya kay ang ipagna tang Dios ong langit. ");
INSERT INTO agn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Agganingo ka ong nindio, mga may doroa ong nindio ang magoyonan tarin ong tanek natetenged ong maski onopay agpa-dolon mi ong Tatayo ong langit, asia boaten na enged para ong nindio. ");
INSERT INTO agn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tenged maski aripa ang may doroa obin tolo ang pamagsimet ong arano, ka-peno ka nira.” ");
INSERT INTO agn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Oman napalenget si Pedro ong ni Jesus ig nane-ma ang ganing, “Gino, mga ang tatang logod pirming pagkatalak ong yen, pirapang bisis tanandiang patawadeno? Asta ong pitong bisis bato?” ");
INSERT INTO agn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ganing si Jesus ong nandia, “Belag lamang ta pitong bisis, kondi ang pitong bisis ang asi oliten mo ta pitong polok ang bisis. ");
INSERT INTO agn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tenged ang paggaraemen tang Dios bilang adi pario ong bindoat tang tatang adi asing nanokot tang otang tang mga opisialis na ong nandia. ");
INSERT INTO agn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mintras panokot tanandia tang mga paotang na, may ingkelan ong nandia ang tatang opisialis na, ang may mabael ang otang nang tampolok ang ribong koartang talinto. ");
INSERT INTO agn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ig tenged indi tanandia mabayad, nagordin tang adi ang ipabakal tang tanan ang pagkabetang na. Asta tanandia mismo, ang katawa na may ang mga ana na, ipabakal ka tanira ong domang taw para magimong kirepen, agod bayad da ong tanan ang otang na. ");
INSERT INTO agn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tenged tarin, liminod tang opisialis ang asi ong talongan tang adi ig nagpakiloy ang ganing, ‘Maginong Adi! Mate-beka ong yen! Magelat-elata kanay mandian, tenged sia bayadano kang tanan ong nio!’ ");
INSERT INTO agn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nate-bek ong nandia tang adi, animan pinatawad na tang opisialis ig indi ra pinabayad na tang otang na. Oman pinaolik na ra lamang. ");
INSERT INTO agn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Mintras golik tang taw ang asi, nabagat na tang tatang kapario nang opisialis ang may otang na ong nandia ang tang gatos ang koartang dinario. Dinep na tang opisialis ang asi ang may otang na ig dayon ang singkel na ang ganing, ‘Bayadan mo ra tang otang mo ong yen!’ ");
INSERT INTO agn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Liminod ong talongan na tang kapario nang opisialis ig nagpakiloy ong nandia ang ganing, ‘Magelat-elata kanay mandian! Sia bayadano ka ong nio!’ ");
INSERT INTO agn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Piro indi enged tanandia napaoyon. Imbis, pinaprisoan na tang kapario nang asing opisialis asta indi mabayad. ");
INSERT INTO agn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Pagaita ta si tang doma pang mga opisialis, namagsinti tanira ta mo-ya. Animan pinaningan nira tang adi ig bineg nira tang natetenged ong nainabong asi. ");
INSERT INTO agn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Oman pinagoy tang adi tang opisialis ang asi ig minaning, ‘Yawa, kalain tang ogali mo! Pinatawada yen ong mga otang mo tenged nagpakiloya ong yen. ");
INSERT INTO agn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Piro angay india nate-bek ong kapario mo, pario tang yo nate-beko ong nio?’ ");
INSERT INTO agn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dorong pisan ang kasisilagen tang adi ong opisialis ang asi. Pinaprisoan na para papagpinitinsiaen asta indi mabayadan na tang tanan ang otang na ong adi. ");
INSERT INTO agn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Animan, maning ka ta si tang boaten tang Tatayo ong langit ong kada tata ong nindio, mga indi amo magpatawad ong kapario mi ang de-dek ong popotokon mi.” ");
INSERT INTO agn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagatapos ang nagtoldok si Jesus tang mga bagay ang asi, nagalin tanandia ong Galilea ig napaning ong mga logar ang sakep tang Judea, don ong dobali tang soba tang Jordan. ");
INSERT INTO agn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dorong mga taw tang namansidaton ong nandia, ig pinao-ya na tanira ong mga masit nira. ");
INSERT INTO agn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mandian, may mga Pariseo kang namansipaning don ong ni Jesus para depdepen nira tanandia ong mga pamitala na. Animan sine-ma nira ang ganing, “Mga ong nio, sigon ong Katobolan, agpagnan bato ang belagan tang tatang lali tang katawa na, maski onopa lamang ay dailan?” ");
INSERT INTO agn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ganing si Jesus ang siminabat, “Indi gabasa mi ong Kasolatan ang asing pagboat tang Dios tang taw, bindoat na tanirang lali may babay? ");
INSERT INTO agn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Pagatapos ganing tang Dios, ‘Tenged tarin, pabelag da tang lali ong mga ginikanan na, oman maga-penan da tanira tang katawa na, ig magimong tata ra lamang tanira.’ ");
INSERT INTO agn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ang maliag yaning, belag da tanira ta doroa kondi tata. Animan ang pinapaga-pen tang Dios indi dapat ang papagbelagen ta taw.” ");
INSERT INTO agn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nane-ma sing oman tang mga Pariseo, “Mga maning atan, angay nagordin si Moises ang ganing ba-lo ono belagan tang lali tang katawa na, kaministiran oldan na tang babay ta kasolatan bilang ka-telan ang tanandia belagan na ra?” ");
INSERT INTO agn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ganing ang siminabat si Jesus, “Tenged lamang matetegat tang mga kolo mi, animan napaoyon da lamang si Moises ang belagan mi tang mga katawa mi. Piro belag ta sia tang plano tang Dios mimpisa pa asing primiro. ");
INSERT INTO agn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Animan mandian, agganingo ong nindio, mga belagan tang lali tang katawa na tenged ong maski onopay dailan, poira lamang mga nangonlali tanandia, oman mangatawa si tanandia ta doma, loloang pangombabay tanandia. Ig ang mangatawa ong babay ang binelagan, pangombabay ka.” ");
INSERT INTO agn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ganing tang mga sinagpan ni Jesus, “Mga maning don tang may katawa, mo-ya pa maski indi ra lamang mangatawa!” ");
INSERT INTO agn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ganing ang siminabat si Jesus, “Belag ta tanan marisibi tang binitala ming asia. Piro may atan kaman ang sindolan tang Dios tang poirsa ta nem ang indi mangatawa. ");
INSERT INTO agn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sari-saring rason ang angay may mga laling indi mapangatawa. Ang doma nataw ang may dipirinsia ong pagkalali na. Ang doma, inenged ang kinapon ta domang taw. Ig ang doma, disidido ang indi mangatawa para bogos ang mapagsirbi ong Dios ong inadian na. Ang marisibi na ong sadili na ang indi mangatawa, maski indi ra mangatawa.” ");
INSERT INTO agn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tatang kaldaw may mga taw ang pamagekel ta mamola ong ni Jesus para ibondo na tang kalima na ong kolo nira ig iampo. Asing itaen narin tang mga sinagpan na, sinambleng nira tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Piro ganing si Jesus ong mga sinagpan na, “Pabayan mi lamang ang palenget ong yen tang mga mola. Indi bawalen mi. Tenged ang mga taw ang pario ong mamolang narin, yay ang mabilang ong inadian tang Dios.” ");
INSERT INTO agn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Oman dayon ang binondo ni Jesus tang kalima na ong kolo tang mga mola ig binindisionan na tanira. Ig pagatapos ta si, dayon da tanandiang napanaw. ");
INSERT INTO agn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","May tatang taw ang napalenget ong ni Jesus ig nane-ma ang ganing, “Maistro, onopay mo-yang boateno para marisibio tang kaboing anday kataposan?” ");
INSERT INTO agn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ganing si Jesus ang siminabat, “Angay agte-maeno nio mga onopa tang mo-ya? Anday domang mo-ya kondi ang Dios lamang. Mga galiliagang marisibi ta kaboing anday kataposan, tomanen mo tang mga tobol na.” ");
INSERT INTO agn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nane-ma si tang taw ang asi ang ganing, “Onopang mga tobolay?” Ganing si Jesus, “India mamatay ta taw, india mangombabay, india manakaw, india magtistigo ta bo-li, ");
INSERT INTO agn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","galangen mo tang tatay may ang nanay mo, ig gegman mo tang masig ka taw mo pario tang paggegma mo ong sadili mo.” ");
INSERT INTO agn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ganing tang soltiros, “Ang tanan ang asia agtomaneno ra ka. Onopa pa tang dapat boateno?” ");
INSERT INTO agn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ganing si Jesus ang siminabat, “Mga galiliagang anda ra enged ay korang ong pagtoman mo ong Dios, molika ig ipabakal mo tang tanan ang pagkabetang mo, oman ang bayad na i-dol mo ong mga malilised. Mga boaten mo sia, magkatinira ta manggad ang tinagana tang Dios don ong langit. Pagatapos, magbalika ig tomabida ong yen.” ");
INSERT INTO agn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Piro pagabasi ta si tang soltiros, pinongawan tanandia ig nagalin don tenged dorong manggad na. ");
INSERT INTO agn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Animan ganing si Jesus ong mga sinagpan na, “Ong kamatodan, maliwag ang ma-led ong inadian tang Dios tang taw ang manggaden! ");
INSERT INTO agn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mas madali pa nganing tenled tang tatang kamilio ong boloat tang singgoay, kaysa tatang taw ang manggaden ang tenled ong inadian tang Dios.” ");
INSERT INTO agn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pagabasi ta na tang mga sinagpan na, nangabereng tanira ta mo-ya ig nane-ma ang ganing, “Mga maning don, sinopa enged tang malibri?” ");
INSERT INTO agn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pina-dekan tanira ni Jesus ig minaning, “Na indi maboat ta taw, piro belag ta maliwag ong Dios. Tenged anday imposibli ong Dios.” ");
INSERT INTO agn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Minitala si Pedro, “Yami, bino-wanan amen tang tanan para tomabid ong nio. Onopa tang marisibi amen ang balet?” ");
INSERT INTO agn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ganing si Jesus ong nira, “Ong matod, komabot tang kaldaw ang ba-lon tang Dios tang kalibotan ang na, ig yo, ang Ana ta Taw, komarongo ra ong yen ang trono para maggaem ong tanan. Ong kaldaw ang asi yamong mga sinagpano komarong amo ka ong tampolok may doroang trono para magekel ig magosgar ong tampolok may doroang tribo ang nagalin ong dogo ni Israel. ");
INSERT INTO agn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ig ang maski sinopay nagbo-wan tang balay na, ang mga logod na, mga ginikanan na, mga ana na obin ang tanek na tenged ong pagto na ong yen, ang taw ang asi sigoradong mas doro pa enged tang risibien nang balet, sobra pa ong bino-wanan na. Ig oldan pa ta kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yading mga taw ang ganga-kaw mandian ang mangaori ong oring kaldaw. Ig ang mga gangaori mandian yay ang manga-kaw.” ");
INSERT INTO agn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ganing si Jesus, “Ang paggaraemen tang Dios bilang adi pario ong bindoat tang tatang taw ang may mala-bang ang tanek na. Kāga-agan pang pisan tanandiang napanaw para magdilem ta mga taw ang magobra ong tanek nang lindoakan ta obas. ");
INSERT INTO agn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","May inita na ig namaginigoan tanirang laging ang kinaldaw nira tanga koartan ang dinario, ba-lo pinapaning na tanira ong kaobasan na. ");
INSERT INTO agn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Asing alas noibi ra tang kaldaw, nagpanaw si tang may nandia tang tanek ong lansangan ig don may inita na kang mga taw pamagkereng-kereng lamang tenged anday obra nira. ");
INSERT INTO agn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ganing tanandia ong nira, ‘Mga galiag among magobra don ong kaobasano, sia solan amo ka yen ta osto.’ ");
INSERT INTO agn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Animan napaning tanira don ig nagobra. Pagako-to, nagbalik si tang may nandia tang tanek ong lansangan. May inita na si kang mga taw ig pinapagobra na ka. Ig pagkabot tang alas tris, maning si ka don tang bindoat na. ");
INSERT INTO agn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Oman asing alas singko ra nagbalik si ong lansangan ig may inita na pa ka enged ang mga taw ang pamagkereng-kereng. Ganing tanandia ong nira, ‘Angay namagapon amo lamang tang kereng-kereng atan?’ ");
INSERT INTO agn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ganing tanirang siminabat, ‘Mando ami pa? Anda kay pagpaobra ong yamen.’ Animan ganing tanandia, ‘Ala, paning amo don ong kaobasano para magobra.’ ");
INSERT INTO agn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Asing alikarem da, ganing tang may nandia tang tanek ong gataligan na, ‘Goyan mo ra tang mga pamagobra ig solan mo. Tokawen mong bayadan tang nangaoring dimino-tol, oman ang yadoang nangaori, asta ra ong nanga-kaw.’ ");
INSERT INTO agn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mandian, ang mga dimino-tol ang alas singko tang apon sinolan tanira ta talele-ta nirang dinario. ");
INSERT INTO agn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Animan asing solan da tang mga dimino-tol ang māga pang pisan, pamanalig tanira ang mas mabael tang risibien nira ong nangaoring namagobra. Piro ang kada tata ong nira sinolan ka lamang ta tagle-ta nirang dinario. ");
INSERT INTO agn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagarisibi nira tang sol nira, namagriklamo tanira ong may nandia tang tanek. ");
INSERT INTO agn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ganing tanira, ‘Ang mga nangaori, tang oras lamang tang obra nira. Piro yami, nagapon ami enged tang painang amen ig agoanta tang kinit, oman pario lamang tang sol mo ong yamen?’ ");
INSERT INTO agn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ganing tang may nandia ong tata ong nira, ‘Tangay, indi amo agdayaen ta. Napaoyon amo kang kinaldaw mi tang dinario. ");
INSERT INTO agn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Risibien mi lamang tang sol mi ig molik amo ra. Onopay nindio mga solano tang nangaoring namagobra pario ka tang agto-dolo ong nindio? ");
INSERT INTO agn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yoy gatako mga onopay boateno ong koartao tenged yen. Obin sigoro gaibeg amo lamang tenged masine-bekaneno?’ ” ");
INSERT INTO agn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ig ganing pa si Jesus, “Maning ka ta sia ong inadian tang Dios. Ang ganga-kaw mandian yay ang mangaori, ig ang gangaori mandian yay ang manga-kaw.” ");
INSERT INTO agn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mintras papanaw da Jesus ang tatakat ong siodad tang Jerusalem, pinabelag na ta ge-ley tang tampolok may doroang sinagpan na ong mga taw tenged may ibeg na si ong nira. ");
INSERT INTO agn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ganing si Jesus, “Tandan mi. Mandian agpaning ita ra ong Jerusalem. Pag kabot ta don, yo, ang Ana ta Taw, traidorono ig yintrigao ong gaem tang mga pangolokolong padi ig ong mga manigtoldok tang Katobolan. Sintinsiano nira ta kamatayen, ");
INSERT INTO agn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","oman ekelano nira ong mga belag ta Judio agod insoltono nira, latigono, ba-lō ilansang nira ong kros. Piro ong ya-long kaldaw maboiong moman.” ");
INSERT INTO agn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Napalenget ong ni Jesus tang katawa ni Zebedeo, aroman na tang doroang ana nang lali. Liminod tanandia ong talongan ni Jesus ang ganing, “Maistro, may pa-dolono rin ong nio.” ");
INSERT INTO agn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ganing si Jesus, “Onopa si?” Siminabat tang babay, “Mga maimo, mga maggaema ra ngani ong niong inadian, pakarongon mo kay ong tepad mo tang doroang anao ang na, ang tata ong to, ig ang tata ong wala.” ");
INSERT INTO agn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Piro ganing si Jesus ong doroang sinagpan nang asi, “Indi gata-wanan mi mga onopa tang agpa-dolon mi. Onopa, māgoanta mi tang kaliwagan ang mapasarano?” “Ee, māgoanta amen,” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ig ganing si Jesus, “Ang kaliwagan ang agoantaeno, agoantaen mi ka kaman. Piro mga natetenged ong sinopay komarong ong yen ang to ig ong walao, belag ta yo tang maning mga sinopa. Tenged ang mga logar ang agpa-dolon mi, natagana rang lagi ong mga taw ang pinilik da tang Tatayo.” ");
INSERT INTO agn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Asing mata-wanan tang tampolok ang aroman nira mga onopa tang agpa-dolon tang doroang maglogod, namaglain tang nem nira. ");
INSERT INTO agn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Animan ginoyan tanirang tanan ni Jesus ang palenget ig minaning, “Gata-wanan mi ra ka, ang mga pangolokolo tang mga belag ta Judio pamagadi-adi ong mga sinakepan nira. Ig ang mga alalawig ta katengdanan, agdegdegen nira tang mga tawan nira. ");
INSERT INTO agn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Piro indi amo magogali ta maning ta sia. Ang sinopa ong nindio tang galiliag ang mangolokolo, dapat magimong torobolon ong tanan. ");
INSERT INTO agn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ig ang galiliag ang magimong alawig, kaministiran magpababak ig magsirbi ong mga aroman na. ");
INSERT INTO agn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tenged maski yo, ang Ana ta Taw, indio napaning tarin para magpasirbio kondi para magsirbio ig i-dolo tang yen ang kaboi agod yading taw tang magawad ong mga kasalanan nira.” ");
INSERT INTO agn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Asing loloa ra da Jesus ong lansangan tang Jerico, dorong mga taw tang namansidaton ong nira. ");
INSERT INTO agn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mandian, may doroang taw ang boray ang pamansilopa-pak don ong binit tang dalan. Asing pagabasi nirang asia ra ono si Jesus ang tata-lib, dayon tanirang namansiteg ang ganing, “Gino, Inampo ni David! Mate-beka ong yamen!” ");
INSERT INTO agn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Sinambleng tanira tang mga taw ang mamagipes. Piro mas sinodoan pa enged nira tang iteg ang ganing, “Gino, Inampo ni David! Mate-beka ong yamen!” ");
INSERT INTO agn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Siminareng si Jesus, ginoyan na tanira ang palenget ig minaning, “Onopa tang galiliagan ming boateno ong nindio?” ");
INSERT INTO agn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Gino, galiliag ami rin ang maita!” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nate-bek si Jesus ong nira, animan inapap na tang mga mata nira, ig nangaitang lagi tanira. Oman dayon tanirang siminabid ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Asing alenget da tanira ong Jerusalem, ig gingabot pa lamang ong bario tang Betfage, ong Bokid tang Kaoliboan, pina-kaw ni Jesus tang doroang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ganing tanandia ong nira, “Paning amo don ong dadaton ang bario. Ong pagteled mi, asia itaen ming lagi don tang tatang asnong agkeke-ked aroman tang ana na. Obaden mi ig e-lan mi tarin ong yen. ");
INSERT INTO agn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mga may mane-ma ong nindio natetenged tarin, aningen ming kaministiran tang Magino mi, ig sia ipekel ang lagi nira ong nindio.” ");
INSERT INTO agn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nainabo tang mga bagay ang narin agod magmatod tang inaning dang lagi tang propita asing tokaw pa ang ganing: ");
INSERT INTO agn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Aningen mi tang mga taga Sion: ‘Telekan mi! Narin da tang adi ming kakabot! Dibabak ta nem ig pagtay ta tatang asnong mola pa!’ ” ");
INSERT INTO agn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Animan namampanaw da tang doroang sinagpan ni Jesus ig bindoat nira tang tobol na. ");
INSERT INTO agn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ingkelan nira ong ni Jesus tang asnong belkan asta ang ana na, ig ang boko-boko nira dinamdaman tang mga sinagpan tang mga ge-leb nirang lambong, ba-lo siminay si Jesus. ");
INSERT INTO agn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yadi kang mga taw ang namaglatag tang mga lambong nira ong dalan para panawan na. Ang doma, namamotol tang mga kapotan ta ayong marabong tang daon na oman linatag ka ong dalan bilang padengeg ong ni Jesus pario ta tatang adi. ");
INSERT INTO agn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ang mga taw ong tokawan ni Jesus asta ang mga taw ang pamansidaton ong nandia, sigi tang initeg nira ang ganing, “Dayawen tang Inampo ni David! Aloyan ang enged tang Dios tang sinobol na ang kiminabot mandian! Dayawen tang Dios ong kalawig-lawigan ang langit!” ");
INSERT INTO agn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pagakabot da Jesus don ong Jerusalem, namagkagolo tang tanan ang mga taw ang pamansistar don. Ganing tanira, “Sinopa enged tang taw ang na?” ");
INSERT INTO agn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ganing tang dorong mga taw ang pamansitabid ong ni Jesus, “Tanandia si Jesus, ang propitang taga Nazaret, sakep tang Galilea.” ");
INSERT INTO agn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Oman, napaning si Jesus ong Timplo. Don ong teled tang solar may mga pamagpabakal ta mga ayep ang igsaragda ig mga pamamakal. Pinalayas na tanirang tanan ig pinampakalintoad na tang mga lamisan tang mamanigbailo ta koarta asta ang mga kalarongan tang mga pamagpabakal ta mga marapating igborolontad. ");
INSERT INTO agn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ganing si Jesus ong nira, “Ga-tang ong Sagradong Kasolatan, ang balay tang Dios logar ang parangadian. Piro yamo, bindoat mi rang paragsirimetan ta mga takawan!” ");
INSERT INTO agn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ong oras kang asi, may mga boray ig mga pilay ang namansipalenget ong ni Jesus don ong Timplo ig pinao-ya na tanirang tanan. ");
INSERT INTO agn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nangasilag tang mga pangolokolong padi ig ang mga manigtoldok tang Katobolan asing pagaita nira tang mga makabebereng ang bagay ang bindoat ni Jesus, ig pagabasi nira tang aggiteg tang mga mola ong solar tang Timplo ang ganing, “Dayawen tang Inampo ni David!” ");
INSERT INTO agn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Animan ganing ong ni Jesus tang mga pangolokolong asi, “Indi gaba-yan mo tang agganing nira?” “Gaba-yano,” ganing ang siminabat si Jesus. “Angay? Indi gabasa mi ong Kasolatan ang ganing, maski ang mga molang gege-ley agtoldokan tang Dios ang magdayaw ong nandia?” ");
INSERT INTO agn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Oman dayon tanirang binayan ni Jesus. Limindoa tanandia ong Jerusalem ig napaning ong bario tang Betania, ig don tanandia napoyat. ");
INSERT INTO agn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagaramal, asing papanaw si Jesus pabalik si ong Jerusalem, linetem da tanandia. ");
INSERT INTO agn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","May inita nang tang papang ayong igos ong binit tang dalan. Animan pinalengetan na si, piro andang pisan ay inita nang borak na, kondi poros lamang mga daon. Animan minaning si Jesus ong ayong asi, “Mimpisa mandian, india ra enged mamorak!” Ig dayon ang laging nalanet tang igos. ");
INSERT INTO agn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Asing pagaita tang mga sinagpan na, nangabereng tanira ta mo-ya ig minaning, “Aroy! Angay golpi lamang nalanet tang igos?” ");
INSERT INTO agn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ganing si Jesus ong nira, “Ong kamatodan, mga magparet amo ong Dios ig indi amo magdoadoa, maboat mi ka tang bindoato ong papa tang igos ang na. Ig belag lamang ta sia, kondi maski maning amo ong bokid ang asi, ‘Magalina atan ig loma-teda don ong talsi,’ sia mainabo ka enged. ");
INSERT INTO agn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ang maski onopay pa-dolon mi ong pagpangadi mi, marisibi mi basta magparet amo lamang.” ");
INSERT INTO agn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Siminled ang oman si Jesus ong Timplo. Mintras pagtoldok tanandia ong mga taw don, pinalengetan tanandia tang mga pangolokolong padi, aroman ka nira tang mga mepet tang banoa. Ganing tanira ong ni Jesus, “Yaning mo ong yamen onopay podir mong magboat tang mga bagay ang na tarin ong Timplo. Sinopa tang nagtorol ong nio tang podir ang asia?” ");
INSERT INTO agn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ganing si Jesus ang siminabat, “Te-maen amo ka yen. Sabateno kang lagi nindio, ba-lo amo begen ta mga ong aripa nagalin tang podiro para magboat tang mga bagay ang na. ");
INSERT INTO agn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nani tang te-mao: Ong aypa nagalin tang podir ni Juan para magboniag? Ong Dios obin ong taw?” Ig namagampang-ampang tanira mga onopay isabat nira. Ganing tanira, “Mga maning ita ‘nagalin ong Dios,’ maning ka tanandia ong yaten ‘Oman, angay indi amo namagparet ong ni Juan?’ ");
INSERT INTO agn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Piro mga maning ita ‘nagalin ong taw,’ itaben onoray boaten tang mga taw ong yaten, tenged si Juan aggilalaen nirang propita tang Dios.” ");
INSERT INTO agn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Animan siminabat lamang tanira ang ganing, “Indi ami gatako.” Ig ganing si Jesus ong nira, “Mga maning don, indio ka magbeg ong nindio mga ong aripa pagalin tang yen ang podir ang magboat tang mga bagay ang na.” ");
INSERT INTO agn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ganing pa si Jesus ong mga pangolokolong Judio, “Mga ong nindio, onopa bato na? May tatang taw ang doroa tang ana nang lali. Pinaningan na tang aka ig ganing, ‘A-oy, panawa mandian ong bokid ig magobrā ong kaobasan ta.’ ");
INSERT INTO agn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ganing tang ana na, ‘Indio!’ Piro asing ori ra nagoman tang isip na, napaning tanandia ong kaobasan ig nagobra. ");
INSERT INTO agn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Napaning ka tang tatay ong karian ig sinobol na ka tang pario tang inaning na ong aka. Ganing tang ari ang siminabat, ‘Ee, Tatay. Paningo.’ Piro ong matod, indi tanandia nagparet. ");
INSERT INTO agn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mandian, sinopa ong doroang ana nang lali tang nagtoman tang tobol tang tatay nira?” Ganing tanirang siminabat, “Ang aka.” Ig ganing si Jesus ong nira, “Tama kaman. Ig ong matod, ganga-kaw da ong nindio ang pagpasakep ong gaem tang Dios tang mga taw ang mapinagtalaken, pario tang mga manigtokot ta bois ang pamagdaya ong mga taw, ig ang mga babay ang bisiosa ang pamagpabakal tang dengeg nira. ");
INSERT INTO agn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tenged napaning tarin si Juan ang Manigboniag ig nagtoldok ong nindio tang tamang boaten mi para magimong mato-lid amo ong pama-dek tang Dios. Piro yamo, indi amo namagparet ong nandia. Ang mga manigtokot ta bois ig ang mga babay ang bisiosa yay ang namagparet ong ni Juan. Ig maski inita mi mismo ang pamagtoman da tanira ong toldok na, indi amo pa enged namagtogat ong mga talak mi ig namagparet.” ");
INSERT INTO agn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ganing si Jesus ong nira, “Magistoriao ta tata pang palimbawa, mamasi amo. May tatang taw ang nagloak ta mga obas ong tanek na, oman pinakodal na. Nagpaboat ta mabael ang boloat ong mabael ang bato ang boaten ang palagremekan tang mga obas. Nagpa-deng ka ta alawig ang balay-balay ang paragbantayan. Pagatapos, inintriga na tang kaobasan na ong mga agsador na, ba-lo tanandia nagbiahi ong alawid ang logar. ");
INSERT INTO agn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Asing timpo rang igparangalap, nanobol tanandia tang mga torobolon na para mangomit tang parti na. ");
INSERT INTO agn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Piro pagkabot don, binagat ang lagi tanira tang mga agsador. Linaban nira tang tambilog, pinatay tang yadoa ig ang ya-lo binanggil nira ta bato. ");
INSERT INTO agn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Oman nanobol si tang may nandia ta doma pang mga torobolon na ang mas doro pa enged ong nanga-kaw. Piro maning ka don tang bindoat tang mga agsador ang asi ong nira. ");
INSERT INTO agn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Asing ori ra, ang ana na ra mismo tang sinobol na, tenged ganing tanandia ong sadili na, ‘Indi maimong indi galangen nira tang anao.’ ");
INSERT INTO agn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Piro asing itaen tang mga agsador tang ana nang gingabot da, ganing tanirang namagampang-ampang, ‘Asia ra tang manonobli! Patayen ta tanandia agod magimong yaten da tang kaobasan ang na.’ ");
INSERT INTO agn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Animan dinep ang lagi nira tanandia, ginoyodan ong loa tang kaobasan ig don pinatay. ");
INSERT INTO agn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Mandian,” ganing si Jesus ang nane-ma ong mga pangolokolo, “monopa bato mga ong pagbalik tang may nandia tang kaobasan? Onopay boaten na ong mga agsador ang asi?” ");
INSERT INTO agn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ganing tanirang siminabat, “Pamatayen na ka ang anday kate-bek tang mga taw ang asing dorog kalalain! Oman yintriga na si tang kaobasan na ong domang mga taw ang mataligan ang magtorol ong nandia tang parti na kada timpong igparangalap.” ");
INSERT INTO agn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ganing si Jesus ong nira, “Tama kaman. Piro angay midio indi gabasa mi tang ga-tang ong Sagradong Kasolatan ang ganing, ‘Ang batong pinlek tang mga manigpa-deng tang balay, yay ang ginamit tang Dios ig nagimong kaimportantian ong tanan ang batong pagpabaked tang balay. Ang Dios tang nagboat ta na, ig makabebereng ang enged ong pama-dek ta!’ ");
INSERT INTO agn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Animan agganingo ong nindio, ang inadian tang Dios komiten ong nindio ig i-dol ong mga taw ang pamagtoman ong kaliliagan na. ");
INSERT INTO agn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ang mabegtak ong batong narin, malapik-lapik. Ig ang mabegtakan ta sia, maremek-remek ang enged!” ");
INSERT INTO agn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pagabasi tang mga Pariseo ig ang mga pangolokolong padi tang mga palimbawang na ni Jesus, naintindian nirang tanira tang agpataman na. ");
INSERT INTO agn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Animan gangaliliag da rin ang depen nira, piro gengeldan ong mga taw tenged aggilalaen nirang propita si Jesus. ");
INSERT INTO agn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nagtoldok sing oman si Jesus ang paggamit ta mga palimbawa. ");
INSERT INTO agn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ganing tanandia, “Ang paggaraemen tang Dios bilang adi pario ong bindoat ta tatang adi asing nagsimpan tanandia ta mabael ang kombida para ong kasal tang ana nang lali. ");
INSERT INTO agn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Asing kakaldawan da tang kasal ig simpan da tang tanan, nanobol tang adi ong mga torobolon na ang goyan da tang mga taw ang pinangimbitar na. Piro indi maliliag ang paning tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Animan sinobol na pa enged tang doma pang mga torobolon na. Ganing tang adi, ‘Aningen mi tang mga pinangimbitaro ang napagpatay da tang mga bakang sodo may ang doma pang mga ayep ang pinatambek, ig mandian simpan da tang tanan. Animan paning da tanira tarin para mamangombida.’ ");
INSERT INTO agn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Piro ang mga taw ang pinangimbitar indi enged mamagintindi. Namagpadayon lamang ong mga boroaten nira. Ang doma napaning ong koma, ang doma nagintindi tang nigosio nira. ");
INSERT INTO agn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ig ang doma, dinep nira tang mga torobolon tang adi, pinanlaban ig pinamatay nira. ");
INSERT INTO agn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Dorong kasisilagen tang adi! Ang bindoat na, sinobol na tang mga sondalo na ang pamatayen tang mga namamatay ong mga torobolon na ig sirokon tang bilog ang siodad nira. ");
INSERT INTO agn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pagatapos, ginoyan na tang doma sing mga torobolon na ig ganing, ‘Ang kombida ong kasal tang anao listo ra, piro ang mga pinangimbitar belag ta bagay ang magpasakep. ");
INSERT INTO agn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Animan paning amo ong mga karsada ang doro tang mga pamansita-lib, oman imbitaren mi tanirang tanan tarin.’ ");
INSERT INTO agn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ig napanaw tang mga torobolon. Napaning tanira ong mga karsada, ig ang tanan ang nabagat nira, mo-ya man obin malain, inimbitar nira. Ig ang kombidan na-mok ta taw. ");
INSERT INTO agn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Indi naboay, siminled tang adi tenged galiliag ang itaen na tang mga bisita. Mandian, may tatang taw ang inita na don ang indi nanimara tang lambong na ang para ong kombida. ");
INSERT INTO agn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ganing tang adi ong nandia, ‘Tangay, angay siminleda tarin ang india nanimara?’ Piro ang taw ang asi indi enged minibek-ibek, tenged anday masabat na. ");
INSERT INTO agn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Animan ganing tang adi ong mga torobolon na, ‘Lapoton mi tang mga kalima na asta kakay na ig ibanggil mi don ong loa ong maki-lep! Magini-yak tanandia don ig komayeget tang mga isi na.’ ” ");
INSERT INTO agn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Oman dayon ang minaning si Jesus, “Doro tang aggoyan tang Dios ang magpasakep ong inadian na, piro ge-ley lamang tang agpiliken ang manga-led.” ");
INSERT INTO agn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Namagalin tang mga Pariseo don ig namagampang-ampang tanira mga monopa depdepen nira si Jesus ong mga pamitala na. ");
INSERT INTO agn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Animan pinapaning nira ong ni Jesus tang mga sinagpan nira aroman ka tang mga tawan ni Herodes. Pagakabot tang mga sinobol ang asi ong ni Jesus, ganing tanira, “Maistro, gata-wanan amen yawa india pagbo-li, ig pario tang pagpama-dek mo ong tanan. India pagpaekel-ekel ong kaliagan ta taw maski sinopa tanira, kondi agtotoldok mo lamang tang kamatodan natetenged ong kaliliagan tang Dios ang boaten tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Animan, mga ong nio, sigon ong Katobolan ta, tama ka bato ang itang mga Judio magbayad ta bois ong Adi tang Roma obin indi?” ");
INSERT INTO agn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Piro gata-wanan ni Jesus tang aggisipen nirang malain. Animan ganing ong nira, “Mga traidor amo! Angay agsobokano nindiong depdepen ong te-ma ming asia? ");
INSERT INTO agn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Abir, ipaita mi ong yen tang koartang aggamiten ong pagbayad ta bois.” Ig dinawatan ka nira. ");
INSERT INTO agn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“Ninopang itsora na ig ninopang aran tang nasolat tarin?” tang te-ma ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Ang Adi tang Roma,” tang sabat nira. Ig ganing si Jesus, “Mga maning don, i-dol mi ong adi tang para ong adi, ig i-dol mi ong Dios tang para ong Dios.” ");
INSERT INTO agn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagabasi nira ta si, pisan tanirang nangabereng. Animan namagalin da lamang tanira. ");
INSERT INTO agn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ong kaldaw kang asi, may atan kang mga Saduseo ang namampaning ong ni Jesus para mane-ma. Tanira tatang sikta tang mga Judio ang indi pamagparet ang maboing moman tang mga patay. ");
INSERT INTO agn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ganing tanira ong ni Jesus, “Maistro, ganing tang tobol ni Moises, mga mapatay tang lali ang anday ana nira tang katawa na, ang logod tang lali dapat katawaen na tang babay ang asing nabalo, agod magkatinir tanira ta ana para ong laling napatay. ");
INSERT INTO agn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mandian, asing tokaw may pitong mamaglogod ang poros lali. Napangatawa tang kakan ig napatay ang anday ana nira. Oman ang yadoang logod nangatawa ong babay ang nabalo, ");
INSERT INTO agn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","piro napatay si kang anday ana nira. Maning ka ta si tang nainabo ong ya-lo, sa-sad ong yapito. ");
INSERT INTO agn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ang pitong mamaglogod, napangatawa ong babay ig poros nangapatay ang anday ana nira. Asing ori ra, ang babay napatay ka. ");
INSERT INTO agn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mandian, ong oring kaldaw, mga boien ang moman tang mga patay, sinopa ong nirang pito tang magimo sing katawa tang babay? Tenged tanirang tanan nagimong katawa na.” ");
INSERT INTO agn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ganing si Jesus ang siminabat, “Doro amo ka kamali, tenged indi amo gangaintindi tang ga-tang ong Sagradong Kasolatan. Ig indi amo ka gangaintindi mga monopag kamakagagaem tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tenged ong kaldaw ang boien ang moman tang mga patay, indi ra tanira mamagkaratawan tenged pario ra tanira ong mga anghil ong langit. ");
INSERT INTO agn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ig mga natetenged ka ong pagboing oman ong mga patay, midio indi enged gabasa mi ong Kasolatan tang inaning tang Dios ong nindio ");
INSERT INTO agn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ang ganing, ‘Yo tang Dios ni Abraham, ni Isaac, ig ni Jacob.’ Piro ang Dios, belag ta Dios tang mga patay. Tanandia Dios tang mga boi.” ");
INSERT INTO agn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pagabasi ta si tang mga taw, pisan tanirang nangabereng ong mga agtotoldok ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Asing pagatako tang mga Pariseo ang pirdi tang mga Saduseo ong mga bitala ni Jesus, namagsimet sing oman tanira ba-lo si namampaning ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tatang manigtoldok ang dorong gata-wanan na ong Katobolan ni Moises, ya ray ang nane-ma ong ni Jesus para sobokan na. ");
INSERT INTO agn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ganing tang manigtoldok ang na ong ni Jesus, “Maistro, ong tanan ang Katobolan, aypa tang kaimportantian?” ");
INSERT INTO agn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ganing si Jesus ang siminabat, “ ‘Gegman mo tang Ampoan mong Dios ang de-dek ong popotokon mo, bogos ong nem mo, ig bogos ong kinaisipan mo.’ ");
INSERT INTO agn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sia tang kaimportantian ang tobol ong tanan. ");
INSERT INTO agn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Maning ka ta si tang yadoa, ‘Gegman mo tang masig ka taw mo pario tang paggegma mo ong sadili mo.’ ");
INSERT INTO agn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ang doroang tobol ang narin, yay ang agpagalinan tang tanan-tanan ang Katobolan ni Moises asta ang mga sinoldok tang mga propita asing tokaw.” ");
INSERT INTO agn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Asing pamagsirimet-simet pa tang mga Pariseo don ong ni Jesus, sine-ma na tanira ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Sigon ong gata-wanan mi natetenged ong Cristo, sinopa tang kamepet-mepetan ang pinagalinan na? Ninopa tanandiang inampo?” “Inampo tanandia ni Ading David,” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Oman ganing si Jesus, “Mga maning don, angay ‘Gino’ tang ginoy ni David ong nandia? Tenged asing ginaeman si David tang Ispirito Santo, maning ta na tang binitala na: ");
INSERT INTO agn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ganing tang Ginong Dios ong yen ang Gino: Komaronga ong yen ang to, asta ra lamang pasokono ong nio tang tanan ang kasoay mo.’ ");
INSERT INTO agn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mandian, mga ‘Gino’ tang ginoy ni David ong Cristo, monopa maning mi ang tanandia inampo ni David?” ");
INSERT INTO agn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Anday nasabat maski tata ong nira tang te-mang asi ni Jesus. Ig mimpisa don anda ray mangas ang mane-ma pa ong nandia. ");
INSERT INTO agn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pagatapos ta si, minitala si Jesus ong mga taw ig ong mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ganing tanandia, “Ang mga manigtoldok tang Katobolan ig ang mga Pariseo yay ang sinaligan ang magpaintindi tang Katobolan ni Moises. ");
INSERT INTO agn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Animan tomanen mi tang agtotoldok nira ong nindio. Piro indi patoladan mi tang agboaten nira, tenged indi agtomanen nira tang agbibitala nira. ");
INSERT INTO agn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Agpabelatan nira tang mga taw ong dorong mga toromanen nira, piro indi enged agboinan nira tang tarakanen ang asi agod makayan nira tang kabelatan. ");
INSERT INTO agn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ang tanan ang agboaten nira ong pagtoman ong Katobolan, paita-ita lamang ong mga taw agod dayawen tanira. Agpabaelen nira tang mga pilaktiria nira ang agbebe-ket ong toto ig ong kabala nira, ig agpāboaten nira tang mga rambay-rambay ong sidsidan tang mga lambong nira agod aningen ka madinioson tanira. ");
INSERT INTO agn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mga ong simban ig ong mga kombida, ang kaliliagan ang enged nira, komarong ong masisinlong kalarongan ang para ong mga importanting taw. ");
INSERT INTO agn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ig mga don ong plasa, ang kaliliagan nira, salodoan tang mga taw ig goyan ta ‘Maistro.’ ");
INSERT INTO agn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Piro yamo, indi amo magpagoy ta maistro ong aroman mi, tenged mamaglogod amo ig tambilog lamang tang Maistro mi— yo. ");
INSERT INTO agn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Indi amo maggoy maski ong ninopa ta ‘Tatay’ tarin ong tanek, tenged tambilog lamang tang Tatay mi— ang Tatay ang asi ong langit. ");
INSERT INTO agn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ig indi amo magpagoy ta ‘Magino,’ tenged tambilog lamang tang Magino mi— yo, ang Cristo. ");
INSERT INTO agn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ang ga-tang ang alawig ong nindio, dapat tanandia tang magsirbi ong mga aroman na. ");
INSERT INTO agn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ang pagpalawig tang sadili na, ipababak. Ig ang pagpababak, tanandia tang ipalawig.” ");
INSERT INTO agn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kailo amo kang manigtoldok tang Katobolan ig yamong mga Pariseo! Makaeled tang kaboton mi, tenged ang pagto mi ong Dios paita-ita lamang! Agsagangen mi tang mga taw agod indi tanira ma-pen ong inadian tang Dios. Indi amo maliag ang pasakep ong nandia, ig aggawidan mi pa tang mga taw ang gangaliliag ang magpasakep. ");
INSERT INTO agn_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kailo amo kang mga manigtoldok tang Katobolan ig yamong mga Pariseo! Ang pagto mi ong Dios paita-ita lamang! Agkalawen mi tang mga pagkabetang tang mga babay ang balo, asta ang balay nira. Oman pamagpaita-ita amo ang moro-ya amo ong pagpangadi mi ta dorog kaboat ong talongan tang mga taw. Animan magimong mas mabelat pa tang silot ong nindio! ");
INSERT INTO agn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kailo amo kang manigtoldok tang Katobolan ig mga Pariseo! Tenged ang pagto mi ong Dios paita-ita kaman! Pagalig-alig amo ong bilog ang kalibotan para makombinsir amo maski tanga tawan lamang agod magparet ong mga toldok mi. Piro mga makombinsir mi ra ngani, agboaten mi tanandiang sobra pa ong nindio agkalain ig ang tegkan na i-lek lamang ong impirno. ");
INSERT INTO agn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kailo amo ka kaman, yamong mga boray ang pamagantabay ong mga taw! Tenged pamagtoldok amo ang ganing, mga ang taw mangako ig manompa pa ang ganing, ‘Pa-dek tang Timplo!’ maski indi ra tomanen na tang pangako na. Piro mga manompa tanandia ig ang bolawan ang don ong Timplo yay ang boaten nang tistigos, ganing amo ka, kaministiran ang tomanen na enged tang sinompan nang asi. ");
INSERT INTO agn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mga beyeg amo ig mga boray! Ong aypa tang mas importanti— ang bolawan obin ang Timplong pagpasagrado ong bolawan ang asi? ");
INSERT INTO agn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ig pamagtoldok amo ka, mga ang taw manompa ig boaten nang tistigos tang altar, maski indi ra tomanen na tang sinompan na. Piro mga manompa tanandia ong bolontad ang agbe-tang ong altar, ganing amo ka, kaministiran ang tomanen na enged tang sinompan na. ");
INSERT INTO agn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mga boray amo! Aypa tang mas importanti— ang agbobolontad obin ang altar ang pagpasagrado ong bolontad? Ang altar! ");
INSERT INTO agn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Animan mga ang taw manompa ong altar, panompa tanandia ong altar asta ra ong tanan ang agbobolontad don. ");
INSERT INTO agn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ig mga ang taw manompa ang ganing ‘Pa-dek tang Timplo!’ maliag yaning agboaten na kang tistigos tang Dios, tenged don gistar tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ya ka, mga ang taw manompa ang ganing ‘Pa-dek tang langit!’ maliag yaning panompa tanandia asta ra ong trono tang Dios, ig ong Dios ang mismong kakarong don. ");
INSERT INTO agn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kailo amo kang manigtoldok tang Katobolan ig yamong mga Pariseo! Ang pagto mi ong Dios paita-ita lamang! Maderep amo ong pagtorol ong Dios ta tampolok ang porsinto tang pa-bat mi asta ang mga daon ang pagpasabor ong pamangan. Piro ong dobali ta sia, indi amo enged pamagintinding magboat tang mas importanting mga tobol tang Dios ang ganing dapat ita magboat ta mato-lid ong masig kataw ta, magimong masine-bekanen ig mataligan ong tanan ang bagay. Dapat magtorol amo ka kaman tang tampolok ang porsinto, piro indi lipatan mi tang mas importanting mga tobol. ");
INSERT INTO agn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Boray amo ka kaman, yamong mga pamagantabay ong mga taw! Ang agboaten ming asia midio agsaraen mi tang mga ayep-ayep ang gege-ley ong irinemen mi, piro agte-len mi pa tang mababael ang ayep pario ong kamilio. ");
INSERT INTO agn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kailo amo kang mga manigtoldok tang Katobolan ig mga Pariseo! Ang pagto mi paita-ita lamang! Aglimpion mi ta mo-ya tang loa tang mga baso ig mga platon mi, piro ang teled ay maboling pario ka ong mga popotokon mi tenged ponok ta katakab ig kalainan. ");
INSERT INTO agn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Boray amo, yamong mga Pariseo! Limpion mi kang lagi tang teled tang baso mi, ig ong maning don magimong limpio ra ka tang loa na. ");
INSERT INTO agn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kailo amo ka kaman ang manigtoldok tang Katobolan ig yamong mga Pariseo! Ang pagto mi ong Dios paita-ita lamang! Ang kalimbawan mi pario amo ong mga pantion ang pinintoran ta kolit ig masinlong pa-dekan ong loa, piro ong teled dorog kakalpot ig poros doli ta patay. ");
INSERT INTO agn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Maning atan amo enged tenged mga pa-dekan amo tang mga taw, mato-lid tang agboaten mi, piro ong matod poros lamang paita-ita, tenged ong teled tang mga popotokon mi doro amo kalain ang mga taw.” ");
INSERT INTO agn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kailo amo kang mga manigtoldok tang Katobolan ig yamong mga Pariseo! Makaeled tang kaboton mi, tenged ang pagto mi ong Dios paita-ita lamang! Agpaobra mi tang mga pantion tang mga propita ang nangapatay asing tokaw, ig agpasinlon mi tang lebengan tang mga taw ang nangaboi ang mato-lid. ");
INSERT INTO agn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ig agganing amo, ‘Mga taw ami ra rin asing timpo tang mga kamepet-mepetan amen, indi ka enged patayen amen tang mga propita tang Dios, pario tang bindoat nira.’ ");
INSERT INTO agn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Piro ong inaning ming asia, agrisibien mi ang mga inampo amo ka kaman tang mga taw ang namamatay ong mga propita! ");
INSERT INTO agn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ala, taposon mi tang kalainan ang inimpisan tang mga kamepet-mepetan mi! ");
INSERT INTO agn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mga traidor amo, mga irinsia amo ta mga ma-kal ang dalitan! Indi maimong indi amo sintinsian ang silotan ong impirno! ");
INSERT INTO agn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tenged manobolo pa ong nindio ta mga propita, mga taw ang dorong inadalan nira, ig mga maosay ang mga manigtoldok tang bitala tang Dios. Ang mainabo, patayen mi tang doma, ig ang doma ilansang mi ong kros. Ang doma patakan mi tang palo ong mga simban mi ig maski ong aypa tanira mamanikad, rotoson mi ig paliwagan. ");
INSERT INTO agn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yay sia ang yamo tang manabat ong kamatayen tang tanan ang mga taw ang mato-lid ang pinamatay tarin ong kalibotan, mimpisa pa ong pagpatay ong ni Abel ang binilang dang mato-lid, sa-sad ong pagpatay ka ong ni Zacarias, ang ana ni Baraquias. Pinatay mismo tanandia tang mga kamepet-mepetan mi ong Timplo, don ong pagtetengan tang altar ig ang logar ang agganingen sagrado. ");
INSERT INTO agn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ong matod, yamong mga taw ong timpong na, yamo tang silotan tenged ong tanan ang bindoat nirang asi.” ");
INSERT INTO agn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Dayon ang minaning si Jesus, “Ay yamong mga taga Jerusalem! Angay agpatayen mi tang mga propita ig agbanggilen mi tang mga agtobolon tang Dios ong nindio? Kaboay da tang andemong imesen amo ig sagodon, pario ong manong lo-lokan ang pagimes tang mga boto na ong adalem tang kalipapa na, piro indi amo maliag. ");
INSERT INTO agn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mandian bāla amo ra lamang ong mga sadili mi. Pabayan da lamang tang logar ming mapegnak. ");
INSERT INTO agn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tandan mi narin: Indio ra enged itaen mi asta indi komabot tang kaldaw ig mamaganing amo, ‘Dayawen tang kakabot ang sinobol tang Dios!’ ” ");
INSERT INTO agn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Oman dayon ang limindoa si Jesus ong Timplo ig asing papanaw da, napalenget ong nandia tang mga sinagpan na. Sinoldok nira ong nandia tang Timplo asta ang domang mga pina-deng don. ");
INSERT INTO agn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Oman ganing si Jesus ong nira, “Gitaen ta ka kaman tang tanan ang asia. Piro tandan mi na: Komabot tang kaldaw ang anda enged ay mabo-wan ong mga batong pamagtara-paw ta-pawan ang asia. Mangapegnak ang tanan!” ");
INSERT INTO agn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Siminakat si Jesus ong Bokid tang Kaoliboan ig don kiminarong. Napalenget ong nandia tang mga sinagpan na ang tanira-tanira lamang ig ganing, “Begay ami ka nio mga tanopa mainabo tang inaning mong mapegnak tang Timplo, ig onopay mga pasinial mga alenget da tang pagbalik mo ig mga kataposan da tang kalibotan.” ");
INSERT INTO agn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Siminabat si Jesus ang ganing, “Magandam amo agod indi amo maloko ta maski sinopa. ");
INSERT INTO agn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tenged yading mamansikabot ang magekel tang arano, ig kada tata magpailala ang tanira ono tang Cristo. Ig dorong maloko nira. ");
INSERT INTO agn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Animan indi amo mangelba mga mabasi amo ta pamaggiran ong alenget, ig mga mabalita amo kang may gira ono ong domang banoa. Ang mga bagay ang na kaministiran ang mainabo, piro belag pa ta sia tang kataposan tang kalibotan. ");
INSERT INTO agn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mamaggiran tang mga nasion ig mamagkorontran tang mga inadian. Manlinog ong sari-saring mga logar ig magkatinir ta grabing letem. ");
INSERT INTO agn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Piro ang tanan ang narin, impisa pa lamang tang mga kaliwagan ang komabot, pario ong tatang babay ang palanganaen ang ba-lo pa lamang pagpasit. ");
INSERT INTO agn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ong mga kaldaw ang asi, asilagan amo tang tanan ang taw ong tanan ang mga nasion tenged ong pagto mi ong yen. Depen amo nira ig yintriga amo ong mga taw ang mamagsilot ong nindio, ig ang doma ong nindio pamatayen ang enged. ");
INSERT INTO agn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ong timpo kang asi, doro rang mga taw ang taliodan da nira tang pagto nira ong yen tenged ong dorong mga kaliwagan ang gapasaran nira. Oman asilagan ig traidoron nira tang mga kapario nirang pamagto. ");
INSERT INTO agn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yading lomboang bo-lien ang mga propita ig dorong maloko nira. ");
INSERT INTO agn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Maski ong aypang logaray, dorong magboat ta kalainan, animan ang paggegma tang kayadian ong masig ka taw nira manlasay da. ");
INSERT INTO agn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Piro ang magagoanta ig magpadayon ang magtoman ong yen asta matapos tang tanan ang kaliwagan, tanandia yay ang malibri. ");
INSERT INTO agn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ig mapatako ra ong bilog ang kalibotan tang Mo-yang Balita natetenged ong paggaraemen tang Dios bilang adi, agod sia maba-yan tang tanan ang nasion, ba-lo komabot tang kataposan.” ");
INSERT INTO agn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ganing pa si Jesus, “Asing tokaw ang propitang si Daniel nagpatako ang ganing, ong parakaboton may tenled ong Sagradong Logar ang dorog kalain, ang aggoyan ta Maniglangga ang Sobrang Manginsolto ong Dios. (Yamong mga pamagbasa, intindien mi ta mo-ya tang maliag yaning ta na.) ");
INSERT INTO agn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Animan mga itaen mi ra narin ang don da ong Timplo, ang mga taw ang pamansistar tarin ong Judea, kaministiran ang mamanikad dang lagi ong kabobokidan. ");
INSERT INTO agn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ang taw ang don ong loa tang balay na, dapat indi ra tenled ong balay na para mangomit ta maski onopa. ");
INSERT INTO agn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ya ka mga may taw don ong bokid, dapat indi ra molik para mangomit tang takol na. ");
INSERT INTO agn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ong mga kaldaw ang asi, kailo ka tang mga pamagabdet asta ang mga pamagpatiti, tenged liwagan tanira ");
INSERT INTO agn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ong pagpantalok nira. Magampo amo ong Dios ang balampa indi māton ong timpong malamig obin ong Kaldaw ang Igperenay. ");
INSERT INTO agn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tenged ong mga kaldaw ang asi, ang mga taw mapasar ta sobrang kaliwagan. Anda pang pisan ay nainabo ong kalibotan tang pario ong kaliwagan ang na. Ig anda ra kay mainabo pang pario ta sia asta tanopa. ");
INSERT INTO agn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ong matod, mga indi rin padipoton tang Dios tang timpong asi ta kaliwagan, anda enged ay mabo-wan maski tanga tawan. Piro tenged ong mabael ang kate-bek na ong mga taw ang pinilik na, padipoton tang Dios tang timpong asi. ");
INSERT INTO agn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ong mga kaldaw ang asi, mga may maganing ong nindio ang, ‘Asia ra tang Cristo!’ obin may maning, ‘Way, asia ka!’ indi amo magparet. ");
INSERT INTO agn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tenged may mamansiloa atan ang mga taw ang maganing tanira ono tang Cristo, ig may atan kang maganing tanira ono propita ang sinobol tang Dios. Magpaita tanira ta mga milagro ig makabebereng ang mga bagay ong kaliliagan nirang maloko tang mga taw, mga poidi lamang asta ang mga pinilik tang Dios. ");
INSERT INTO agn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Animan tandan mi na! Agbebego rang lagi tang mga bagay ang na mintras indi pa gainabo. ");
INSERT INTO agn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Animan mga may maganing ong nindio nga ang Cristo asi ono ong bokid, indi amo enged paning don. Ig mga may maning, asia tanandia ong teled tang balay, indi amo enged magparet. ");
INSERT INTO agn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tenged mga yo, ang Ana ta Taw, magbalik da, ang itaen mi don midio koldap ang golpi ra lamang mangayag magalin ong tere-lan tegka ong gako-pan. ");
INSERT INTO agn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pario tang sarabien ang ganing, ‘Mga aripa tang mga ogak pamagolag, don toga tang ayep ang patay.’ ” ");
INSERT INTO agn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ganing pa si Jesus, “Matapos lamang tang sobrang kaliwagan ong timpong asi, mangi-lep tang kaldaw ig ang bolan indi ra mangayag. Mangabo-log tang mga bitokon ig pakedegen tang tanan ang aggitaen ong langit. ");
INSERT INTO agn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ig itaen ong langit tang pasinial ang yo, ang Ana ta Taw, alenget dang magbalik, ig ang tanan ang mga taw ong kalibotan mamagini-yak ong sobrang eled nira. Tenged itaeno nira ang tatabid ong mga onom, ang pagekelo tang makabebereng ang gaem ig kadengegan. ");
INSERT INTO agn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ong mapoirsang tonog ta torotot, tobolono ra tang yen ang mga anghil ang magsimet da tang tanan ang taw ang piniliko, magalin ong tanan ang parti tang kalibotan.” ");
INSERT INTO agn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Intindien mi tang adal ang nagalin ong papa tang igos: Mga itaen mi narin ang pangolbot da, gata-wanan ming alenget da tang koarisma. ");
INSERT INTO agn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pario ka ta si, mga itaen mi ra nganing gainabo ra tang mga bagay ang inaningo ong nindio, mata-wanan ming indi ra maboay, komabot da tang timpong asi ig madalio rang magbalik. ");
INSERT INTO agn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tandan mi: May doma ong mga taw ang gangaboi mandian ang kabotan pa nira tang tanan ang mga bagay ang nang mainabo. ");
INSERT INTO agn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Malipat tang langit may ang tanek, piro ang yen ang mga bitala magpadayon ang anday kataposan.” ");
INSERT INTO agn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Piro anday taw ang gatako mga tanopa komabot tang kaldaw ang asi obin oras. Maski ang mga anghil ong langit, maski yo, ang Ana mismo tang Dios, indio ka gatako. Ang Dios ang Tatay lamang tang gatako ta sia. ");
INSERT INTO agn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ang agboaten tang mga taw ong timpong magbaliko, magkapario tang asing timpo pa ni Noe. ");
INSERT INTO agn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ong timpong asi, ba-lo kiminabot tang bonaw, anday domang aggintindien tang mga taw kondi pamamangan ig pamanginem, pamangatawa ig agpakatawa, asta ra lamang ong kaldaw ang siminay da Noe ong mabael ang barko ang aggoyan ta arka. ");
INSERT INTO agn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Oman kiminabot tang bā ang anday kalaom nira ig nangapatay tang tanan ang nangabo-wan. Maning ka ta si ong timpong magbaliko. Ang mga taw, anda kay kalaom nira ang komaboto ra. ");
INSERT INTO agn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ong oras ang asi, mga may doroang laling pamagobra ong bokid, ang tambilog e-lan ong langit ig ang tambilog bo-wanan. ");
INSERT INTO agn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Obin mga may doroa nga babayan ang pagkatodan ang panlebek, e-lan ong langit tang tambilog ig ang tambilog bo-wanan ka. ");
INSERT INTO agn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Animan magimong listo amo ig pirming simpan, tenged indi amo gatako mga tanopa komabot tang Gino mi. ");
INSERT INTO agn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Isipen mi narin: Mga gata-wanan lamang tang may nandia tang balay mga onopang orasay komabot tang takawan, bantayan na enged agod indi ma-led tang balay na. ");
INSERT INTO agn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Animan yamo, kaministiran ang magbantay amo ig pirming listo. Tenged yo, ang Ana ta Taw, komaboto ong oras ang indi gelaten mi.” ");
INSERT INTO agn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nagistoria pa si Jesus ong nira ong palimbawang na. Ganing tanandia, “Ang mataligan ig matakong torobolon, yay ang boaten tang may nandia tang balay ang ingkargado ong domang mga torobolon na, ig ya kay ang magtorol ong nira ta pamangan ong tamang oras. ");
INSERT INTO agn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Masoirti tang torobolon ang asi mga kabotan tanandiang pagboat tang katengdanan na ong pagbalik tang agalen na. ");
INSERT INTO agn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sigoradong boaten da enged tanandiang ingkargado ong tanan ang pagkabetang tang agalen na. ");
INSERT INTO agn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Piro mga malain tang torobolon ang asi, maning ong sadili na, ‘Maboay-boay pa ba-lo magbalik tang agaleno.’ ");
INSERT INTO agn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ig impisan na rang bogbogon tang aroman nang mga torobolon, asta magiga-pen da ang mamangan ig manginem ong mga manigpabaleng. ");
INSERT INTO agn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Oman komabot tang agalen na ong kaldaw ang indi enged gelaten na, ig ong oras ang indi gata-wanan na. ");
INSERT INTO agn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dayon da tanandiang kastigon tang agalen na ta dorog kaliwag, ba-lo ibanggil ong logar ang para ong mga taw ang paita-ita lamang tang pagto nira. Don tanandia magini-yak ang aroman nira ig komayeget tang mga isi na.” ");
INSERT INTO agn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Pag kabot tang kaldaw ang asi, ang mainabo ong inadian tang Dios mapapario ong istoriang natetenged ong tampolok ang soltiras asing may kasalan. Sigon ong kaogalian nira, ang mga soltiras ang asi namagekel ta mga kingki nira ig namansipanaw da para mamansibagat ong laling karasalen. ");
INSERT INTO agn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ang lima ong nira anday isip nira, piro ang lima maorosay ta kinaisipan. ");
INSERT INTO agn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ang limang asing anday isip nira, namagekel ta mga kingki nira, piro indi tanira namagekel ta langis ang pangrisirba. ");
INSERT INTO agn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Piro ang mga soltiras ang morosay, namagekel ang lagi ta bastanting langis nira. ");
INSERT INTO agn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mandian ang nainabo, nātrasong kiminabot tang laling karasalen, animan pinoyat da tanira ig nangapoyat ang tanan. ");
INSERT INTO agn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Asing tenganan da, may miniteg ang ganing, ‘Asia ra tang laling karasalen! Dalien mi, bagaten mi ra!’ ");
INSERT INTO agn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nangapoaw tang tampolok ang asing soltiras ig linisto nira tang mga kingki nira. ");
INSERT INTO agn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ganing tang mga soltiras ang anday isip nira ong mga soltiras ang morosay, ‘Olday ami ka nindio ta langis, maski ge-ley lamang. Way, ang mga kingki amen madali rang mapatay!’ ");
INSERT INTO agn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Piro ganing tang mga soltiras ang may isip nira, ‘Indi poidi, tenged mga oldan amo pa yamen, parario itang mangalo-tan. Paning amo ra lamang ong mga manigpabakal ig mamakal amo ta para ong nindio.’ ");
INSERT INTO agn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Animan namansipanaw da tang limang soltiras ang asi para mamakal ta langis. Pagapagalin lamang nira, ya kay ang pagkabot tang laling karasalen. Ig ang limang simpan ang lagi, nangatabid ong nandia ang napaning ong kombida. Paga-led nira ong kombidan, dayon dang siniradoan tang portan. ");
INSERT INTO agn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Maboay-boay ta ge-ley, kiminabot da tang aroman nirang mga soltiras ang namamakal ta langis, ig namansigoy tanira ong loa ang ganing, ‘Magino, pa-leday ami ka!’ ");
INSERT INTO agn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Piro ganing tang lali, ‘Indio gailala ong nindio.’ ” ");
INSERT INTO agn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Oman dayon ang minaning si Jesus, “Yay sia ang kaministiran ang magimong listo amo ig pirming simpan, tenged indi amo matako mga tanopa obin onopang kaldaway obin oras tang pagkaboto.” ");
INSERT INTO agn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nagistoria pa si Jesus ong nira ong tata pang palimbawa ang ganing, “Ang paggaraemen tang Dios bilang adi pario ong bindoat tang tatang taw ba-lo tanandia nagbiahi ong alawid ang logar. Ginoyan na tang mga torobolon na ig inintrigan na tanira tang mga manggad na para ipapanaw nira ong nigosio. ");
INSERT INTO agn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ang kada tata ong nira, sindolan na sigon ong abilidad na ong pagnigosio. Ang tata sindolan na ta 5,000 ang pidasong koartang bolawan; ang tata 2,000 ang pidaso, ig ang tata pa sindolan na ka ta 1,000. Oman dayon da tanandiang nagalin. ");
INSERT INTO agn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ang torobolon ang sindolan ta 5,000 ay nagnigosiong lagi ig naganansia tanandia ta 5,000 ka. ");
INSERT INTO agn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ya kay ang bindoat tang sindolan ta 2,000, ig naganansia ka tanandia ta 2,000. ");
INSERT INTO agn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Piro ang inintrigan ta 1,000, napanaw ig nagali ong tanek, oman limbeng na tang koartang sindol ong nandia tang agalen na ang dapat inigosio na rin. ");
INSERT INTO agn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pagata-lib tang naboay ang timpo, nagbalik tang agalen nira. Pinampagoy na tang mga torobolon na para mata-wanan na mga pirapa tang naganansia nira ong koartang inintriga na. ");
INSERT INTO agn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ang torobolon ang sindolan ta 5,000 yay na-kaw ang napalenget ong agalen na ig ganing, ‘Magino, inintrigano nio ta 5,000. Nani tang 5,000 ang sindol mo ong yen ig ang 5,000 kang ganansiao.’ ");
INSERT INTO agn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“ ‘Mo-ya!’ ganing tang agalen na, ‘Mo-yāng torobolon! Yawa, nataligana ong ge-ley ang kantidad. Animan mandian intrigana ra yen ta mas mabael ang kantidad. Mangalipaya ka ang aromano!’ ");
INSERT INTO agn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Oman ang torobolon ang sindolan ta 2,000 napalenget ka. Ganing tanandia ong agalen na, ‘Magino, inintrigano nio ta 2,000. Nani tang sindol mo ong yen ang 2,000 asta ang 2,000 kang ganansiao.’ ");
INSERT INTO agn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“ ‘Mo-ya!’ ganing tang agalen na ong nandia, ‘Mo-yāng torobolon! Yawa, nataligana ong ge-ley ang kantidad. Animan mandian intrigana ra yen ta mas mabael ang kantidad. Mangalipaya ka ang aromano!’ ");
INSERT INTO agn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ig napalenget ka tang ya-lo ang inintrigan na ta 1,000. Ganing tang torobolon ang na, ‘Gata-wanano ang yawa maigpit ang taw. Agkomiten mo tang ganansia tang binedlayan ta doma, ig maski belag ta yawa tang nagloak, aggayegen mo. ");
INSERT INTO agn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Geldano ong nio, animan limbengo lamang tang koarta mo ong tanek agod indi malipat. Ya, nani tang 1,000 mo.’ ");
INSERT INTO agn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ganing tang agalen na, ‘Anday kointa mong torobolon! Tamadana! Gata-wanan mo palang agkomiteno tang ganansia ig ang pa-bat maski belag ta yo tang nagbedlay? ");
INSERT INTO agn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Angay indi bino-log mo ong bangko tang koartao, agod mga mabaliko, makomito asta ang tobo na?’ ");
INSERT INTO agn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Oman ganing tang agalen ong domang mga torobolon, ‘Komiten mi ong nandia tang koartang 1,000 ig i-dol mi ong torobolon ang may 10,000 na. ");
INSERT INTO agn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tenged ang kada tatang mataligan, oldan pa asta mandoro tang nandia. Piro ang indi mataligan, maski ang ge-ley lamang ang inintriga ong nandia, sia komiten pa ka enged ong nandia. ");
INSERT INTO agn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ala, ang torobolon ang asiang anday kointa na, i-lek mi don ong loa ong maki-lep. Don tanandia magini-yak ig komayeget tang isi na.’ ” ");
INSERT INTO agn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nagpadayon si Jesus ong pagbitala na ang ganing, “Mga yo, ang Ana ta Taw, komabot ong mabael ang kayagano ig aromano tang tanan ang mga anghil, ya ray ang oras ang komarongo bilang adi ong yen ang trono, para maggaem ong tanan. ");
INSERT INTO agn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ong kaldaw ang asi simeten tang tanan ang taw tang tanan ang mga nasion ong talongano. Oman belageno tanira ong doroang gropo pario tang pagpalbag tang manigbadbad tang mga karniro ong mga kambing. ");
INSERT INTO agn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ang mato-lid ang mga taw, ang kaparioan nira mga karniro ig ibetango ong yen ang to. Ig ang mga taw nga ang kaparioan nira mga kambing ibetango ka ong yen ang wala. ");
INSERT INTO agn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Oman, bilang Adi, maningo ong mga taw ang gampir ong yen ang to, ‘Inaloyan amo tang Dios ang Tatayo! Tenled amo ig mistar ong inadian ang tinagana na ong nindio mimpisa pa asing boaten tang kalibotan. ");
INSERT INTO agn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aggaloyan amo enged tang Dios, tenged asing agle-meno, pinapano nindio. Ig asing agkoaweno, pinainemo nindio. Asing dono ong logar mi bilang dayoan, pinadayono nindio ong balay mi. ");
INSERT INTO agn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ig asing anday lambongo, pinalambongano nindio. Asing pagmasito, sinagodo nindio. Ig ang pagaprisō, binisitao nindio ig linipay.’ ");
INSERT INTO agn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Somabat tang mga taw ang mato-lid, ‘Gino, tanoapa inita amen ang naletem ig pinapana yamen, obin kinoawa ang pinainema yamen? ");
INSERT INTO agn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tanoapa inita amen ang anday madayonan mo ig pinadayona yamen ong balay amen, obin anday lambong mo ang pinalambongana yamen? ");
INSERT INTO agn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ya ka tanoapa inita amen ang nagmasit obin napriso ig binisitā yamen?’ ");
INSERT INTO agn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Oman yo, ang Adi, somabato ong nira ang maning, ‘Ong matod, asing bindoat mi tang maning atan ong mga logodo, maski ang kadibabakan ong pama-dek tang mga taw, pario ra ka ang sia bindoat mi ong yen.’ ");
INSERT INTO agn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Oman yaningo ka ong mga taw ang gampir ong walao, ‘Palawid amo tarin, yamong mga sinompa tang Dios! Don amo ra lamang ong apoy ang indi enged mapatay-patay, ang yay ang logar ang natagana ong ni Satanas may ong mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tenged asing agle-meno, indio enged pinapan mi. Asing agkoaweno, indio pinainem mi. ");
INSERT INTO agn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Asing dono ong logar mi ang anday madayonano, indio enged pinadayon mi ong balay mi. Ya ka asing anday lambongo, indio ka sindolan mi. Ig asing pagmasito ig pagapriso indio ka binisita mi.’ ");
INSERT INTO agn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ig somabat ka tanira ang maning, ‘Gino, tanoapa inita amen ang naletem ig kinoaw, obin anday madayonan mo, obin anday lambong mo, obin nagmasit, obin napriso ang indi ami nagtabang ong nio?’ ");
INSERT INTO agn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Yo, ang Adi, somabato ka ong nira, ‘Ong matod, asing indi sinabangan mi tang mga logodo, maski ang kadibabakan ong pama-dek ta taw, midio yo ra ka tang indi sinabangan mi.’ ");
INSERT INTO agn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Animan sia tanira pālinen ig silotan asta ong tanopa. Piro ang mga mato-lid yay ang oldan ta kaboing anday kataposan.” ");
INSERT INTO agn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pagatapos ang nagtoldok si Jesus tang tanan ang na, ganing tanandia ong mga sinagpan na, ");
INSERT INTO agn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Gata-wanan ming doroa ra lamang kaldaw, Pista ra tang Pagta-lib tang Anghil, ig yo, ang Ana ta Taw, traidorono ig yintrigao ra ong mga taw para ilansang ong kros.” ");
INSERT INTO agn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mandian, asing oras kang asi, ang mga mepet tang banoa may ang mga pangolokolo ong mga padi pamagsimet da don ong palasio ni Caifas, ang yay ang kalawigan ang padi nira. ");
INSERT INTO agn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Namagampang-ampang tanira mga monopa madep nira si Jesus ong talok, oman ipapatay. ");
INSERT INTO agn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ganing tanira, “Indi itōn ta ong kasagsagan tang pista, itaben magkagolo tang mga taw.” ");
INSERT INTO agn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mandian, asing don si Jesus ong bario tang Betania, napaning tanandia ong balay ni Simon ang dating liproso. ");
INSERT INTO agn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mintras pamangan tanira, pinalengetan si Jesus tang tatang babay. May aggekelan nang tereldan ang boat ong batong midio marmol. Ang teled na tatang klasi ta pabanglo ang dorog kamal, ig sia bino-bok tang babay ong kolo ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Asing itaen tang mga sinagpan na, pinangerepan tanira ig namagmoro-moro ang ganing, “Aroy! Arangan da tang pabanglong asia! ");
INSERT INTO agn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mga pinabakal pa sia, ang bayad na mabael ang kantidad, ig malimos pa rin ong mga malilised.” ");
INSERT INTO agn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Piro gata-wanan ni Jesus tang agpagampangan nira, animan ganing tanandia ong nira, “Angay pagpalabet amo ong babay ang na? Pabayan mi lamang. Ang bindoat nang na ong yen dorog kasinlo. ");
INSERT INTO agn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ang mga malilised pirming ka-pen mi ig poidi pang matabangan mi. Piro yo, indio ra maka-pen mi ong maboay ang timpo. ");
INSERT INTO agn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Anda pa ngani, bino-bokano ra nandia ta pabanglo agod magimong simpan da tang sinangonio mga ilbengo ra. ");
INSERT INTO agn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Agganingo ong nindio, maski ong aripa ipatako tang Mo-yang Balita tarin ong bilog ang kalibotan, ang bindoat tang babay ang na ong yen magapil ka enged bilang pagdemdem ong nandia.” ");
INSERT INTO agn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pagatapos ta si, si Judas Iscariote, ang tata ong tampolok may doroang apostolis ni Jesus, napaning ong mga pangolokolo ong mga padi. ");
INSERT INTO agn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nagigampang si Judas ong nira ang ganing, “Pirapa tang isol mi ong yen mga tabangan amo yen ang depen si Jesus?” Binilangan ang lagi nira si Judas ta tolompolok ang pidasong koartang silber. ");
INSERT INTO agn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Animan nagimpisa ra tanandiang nagelat ta tamang oras para maintriga na si Jesus ong nira. ");
INSERT INTO agn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Asing kiminabot tang primirong kaldaw tang Pista tang Tinapay ang Anday Pampalsa na, napalenget ong ni Jesus tang mga sinagpan na ig nane-ma ang ganing, “Ong ari ami pa magsimpan ta yapon ta para ong Pista tang Pagta-lib tang Anghil?” ");
INSERT INTO agn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Siminabat si Jesus, “Paning amo don ong lansangan, ong balay tang taw ang inaningo ra ong nindio. Aningen mi tanandia ang, ‘Nagtoyon tang Maistro ang ganing, kiminabot da tang oras na. Tarin ono tanandia magsilibra tang Pista tang Pagta-lib tang Anghil ong balay mo, aroman na tang mga sinagpan na.’ ” ");
INSERT INTO agn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Animan napanaw da tang mga sinagpan ni Jesus ig nagsimpan tanira tang panapon nira para ong pista, sigon ong tobol na ong nira. ");
INSERT INTO agn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Asing alikarem da, kiminarong da si Jesus para manapon, aroman na tang tampolok may doroang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mintras pamamangan tanira, ganing si Jesus ong nira, “Begen amo yen tang kamatodan, yo, traidorono tang tata ong nindio tarin.” ");
INSERT INTO agn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pagabasi ta si tang mga sinagpan na, namagsinti tanira ig nane-ma tang kada tata ong ni Jesus ang ganing, “Gino, yo ra bato?” ");
INSERT INTO agn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ganing si Jesus ong nira, “Agganingo, tata ong nindio ang yen ang mga kasaro, ang nagte-me ta tinapay ong mangkok ang na, yay ang magtraidor ong yen. ");
INSERT INTO agn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yo, ang Ana ta Taw, mapatay sigon ong na-tang dang lagi ong Sagradong Kasolatan. Piro kailo ka tang taw ang magtraidor ong yen! Mas mo-ya pa ong nandia, indi ra lamang nataw.” ");
INSERT INTO agn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Dayon ang minaning tang traidor ang si Judas, “Maistro, yo ra bato?” Ganing si Jesus ong nandia, “Yawa ra ka tang naganing ta sia.” ");
INSERT INTO agn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mintras pamamangan pa tanira, namisik si Jesus ta tinapay ig binindisionan na. Oman pinisi-pisi na ig sindol na ong mga sinagpan na ang ganing, “Risibien mi narin ig panganen. Na tang yen ang sinangoni.” ");
INSERT INTO agn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pagatapos, bindiotan na tang tatang kopang bino ig nagpasalamat ong Dios, oman sindol na ong nira ig ganing, “Manginem among tanan ta narin. ");
INSERT INTO agn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Na tang dogo tang ba-long inigoan ang agboaten tang Dios para ong mga taw. Ang yen ang dogong na mailat agod yading mapatawad ong mga kasalanan nira. ");
INSERT INTO agn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Agganingo ong nindio, indio ra moman ang manginem ta binong maning ta na ang pagalin ong obas, asta indi komabot tang kaldaw ang mamaga-pen ita sing manginem tang ba-long bino ong inadian tang yen ang Tatay.” ");
INSERT INTO agn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pagabitala ni Jesus ta si, namagkanta tanira ta tatang kantang pagdayaw ong Dios, ba-lo tanira namansipaning ong Bokid tang Kaoliboan. ");
INSERT INTO agn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ganing si Jesus ong mga sinagpan na, “Ong matod, mandian ang labi, bo-wanano nindiong tanan, tenged na-tang dang lagi ong Kasolatan, ‘Ipagna tang Dios ang patayen tang manigbadbad, ig ang mga karniro mamagwasag.’ ");
INSERT INTO agn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Piro matapos ang boieno rang moman tang Dios, tongkawo ong nindio don ong Galilea.” ");
INSERT INTO agn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ganing si Pedro ong ni Jesus, “Bo-wanana pa nirang tanan, piro india ka enged bo-wanan ta!” ");
INSERT INTO agn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Siminabat si Jesus, “Tandan mo na, Pedro: Ba-lo manolōk tang mano mandian ang garamal, ma-long bisisang magbo-li ang maning india gailala ong yen.” ");
INSERT INTO agn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piro ganing si Pedro ang nagpareges, “Maski patayeno pang aroman mo, indio ka enged maning ang india gailala ta!” Ig ya kay ang inaning tang tanan ang mga sinagpan ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Oman ingkelan tanira ni Jesus ong logar ang aggoyan ta Getsemani. Pagakabot don, ganing si Jesus ong mga sinagpan na, “Atan amo kay lagi komarong mintras pangadio don ong tokawan.” ");
INSERT INTO agn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Piro pinatabid na si Pedro may ang doroang ana ni Zebedeo. Naborido ra tang isip na ig dorog kabelat tang panemdeman na tenged ong agtalongaen na. ");
INSERT INTO agn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ganing si Jesus ong tolo, “Midio mapatayo ra ong sobrang sintio! Atan amo lamang ig magpolaw amo ang aromano.” ");
INSERT INTO agn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pagatokaw-tokawan na ta ge-ley, diminagpa tanandia ig nagampo ong Dios ang ganing, “Tatay, mga maimo lamang, indio ra papasaren mo ong kaliwagan ang na. Piro belag tang yen ang kaliagan tang dapat ang matoman, kondi ang kaliagan mo.” ");
INSERT INTO agn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pagabalik na don ong tolong mga sinagpan na, kinabotan na tanirang gangapoyat. Ganing tanandia ong ni Pedro, “Onora ka? Indi amo ka enged mapagpapoyat ang aromano, maski tang oras lamang? ");
INSERT INTO agn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Indi amo mapoyat. Mangadi amo agod indi amo madeg ta tokso. Galiliag amo ka rin ang magboat ta mo-ya, piro agdegen amo tang sinangoni ming malolobay.” ");
INSERT INTO agn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Napalawid sing oman si Jesus ig nagampo si ang ganing, “Tatay, mga kaministiran ang enged ang takaneno tang kaliwagan ang narin, risibieno, agod matoman tang kaliliagan mo.” ");
INSERT INTO agn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pagabalik na don ong tolo, kinabotan na sing gangapoyat tenged pisan dang agkapoyon ta poyat. ");
INSERT INTO agn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Animan bino-wanan na si tanira ig napalawid sing oman. Nangadi tanandia ong ya-long bisis ig ang pinangadi na pario si ka tang primiro. ");
INSERT INTO agn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pagatapos, nagbalik sing oman ong mga sinagpan na ig ganing, “Gangapoyat amo pa ka enged? Telekan mi! Kiminabot da tang oras ang yo, ang Ana ta Taw, yintriga ra ong kalima tang mga taw ang mapinagtalaken. ");
INSERT INTO agn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Maytara! Asia ra tang taw ang magtraidor ong yen!” ");
INSERT INTO agn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Asing bibitala pa si Jesus, kiminabot da kaman si Judas, ang tata ong tampolok may doroang apostolis na. Tang paneng tang aroman nang mga taw ang pamagekel ta mga ispada may pamalo. Ang mga taw ang na sinobol tang mga pangolokolong padi ig mga mepet tang banoa. ");
INSERT INTO agn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Minaning dang lagi ong nira tang traidor ang si Judas tang onopay sinial na. Ang inaning na, “Ang taw ang itongano yay ang depen mi.” ");
INSERT INTO agn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Animan mandian, napalenget ang lagi si Judas ong ni Jesus ig minaning, “Mo-yang labi, Maistro.” Oman dayon ang initongan na. ");
INSERT INTO agn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ganing si Jesus ong ni Judas, “Tangay, boaten mo ra tang onopay boaten mo.” Ig dayon ang laging pinalengetan si Jesus tang mga taw ig dinep nira. ");
INSERT INTO agn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Piro tata ong mga aroman ni Jesus nagbonlok tang ispada na ig dayon ang tinagpas na tang kirepen tang kalawigan ang padi. Nalampong tang talinga na. ");
INSERT INTO agn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ganing si Jesus ong nanibat, “Ibalik mo ong tageban na tang ispada mo! Ang paggamit ta ispada, ong ispada ka mapatay. ");
INSERT INTO agn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","India gatako? Poidiong magpatabang ong Tatayo ig paekelanong lagi nandia ta rinibo-ribong mga anghil. ");
INSERT INTO agn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Piro mga maning ta sia tang boateno, monopa matoman tang inaning dang lagi ong Sagradong Kasolatan ang kaministiran maning ta na tang mainabo?” ");
INSERT INTO agn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Oman ganing si Jesus ong dorong taw don, “Angay? Yo, kriminalo ang pamagekel amo ta mga ispada may pamalo para depeno? Kaldaw-kaldaw pagtoldoko ong Timplo, angay indiong lagi dinep mi don? ");
INSERT INTO agn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Piro ang tanan ang narin gainabo agod magmatod tang sinolat tang mga propita ong Kasolatan natetenged ong yen.” Pagabitala na lamang ta si, bino-wanan si Jesus tang mga sinagpan na ig namansilayas tanirang tanan. ");
INSERT INTO agn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ingkelan si Jesus tang namagdep ong nandia ong palasio ni Caifas, ang yay ang kalawigan ang padi tang mga Judio. Don ka pamagsimet tang mga manigtoldok tang Katobolan ig ang mga mepet tang banoa. ");
INSERT INTO agn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Si Pedro pala dadaton ong nira, piro don lamang ong alawid-lawid. Pagakabot nira ong palasio tang kalawigan ang padi, siminled ka si Pedro ong kodal ig kiminarong tanandia ong loa, aroman tang mga goardia, agod itaen na mga onopa tang mainabo ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mandian, ang mga pangolokolo ong mga padi ig ang tanan ang mga opisialis tang banoa, pamagdilem ta ibidinsia kontra ong ni Jesus, maski belag ta matod, agod masintinsian nira ta kamatayen. ");
INSERT INTO agn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Piro maski dorong namansitalonga para magtistigo ta kabo-lian kontra ong ni Jesus, anda enged ay inita nirang ibidinsia para masintinsian nira. Asing ori ra, may doroang taw ang nagprisintar ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Ganing tang taw ang na, kaya na onong gebaen tang Timplo tang Dios, ig ong teled ono ta tolong kaldaw, ipa-deng na sing oman.” ");
INSERT INTO agn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Animan kimindeng tang kalawigan ang padi ig nane-ma ong ni Jesus, “Angay india sasabat? Onopay maning mo ong mga riklamo nirang na kontra ong nio?” ");
INSERT INTO agn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Piro inding pisan minibek-ibek si Jesus. Animan ganing si ong nandia tang kalawigan ang padi, “Magbega ra ong yamen ong talongan tang Dios ang boi! Yawa ra tang Cristo, ang Ana tang Dios?” ");
INSERT INTO agn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ganing si Jesus, “Yawa ra ka tang naganing. Ig agganingo ong nindio, indi ra lamang maboay, itaeno nindio, yo, ang Ana ta Taw, ang kakarong gampir ong to tang Makagagaem. Ig itaeno ka nindio ang tatabid ong mga onom ang pagbalik tarin ong kalibotan.” ");
INSERT INTO agn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pagabasi ta si tang kalawigan ang padi, linasik na tang lambong na ong sobrang kasisilagen na ig minaning, “Pangambong tanandia tang Dios! Anda ray kaministiran ta mga tistigos! Naba-yan mi ra mismo tang inaning na! Dorog kabelat tang kasalanan ang na! ");
INSERT INTO agn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mandian, onopay lalang mi?” Ganing tanirang siminabat, “Dapat ong nandia patayen!” ");
INSERT INTO agn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Oman inolakan nira si Jesus ong emet na ig sinalalabangan pa nira tang sontok. Ig ang doma nanampaling ong nandia ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Mga yawa kaman tang Cristo, abir! Pinton mo mga sinopay panampaling ong nio!” ");
INSERT INTO agn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mandian, asing oras kang asi, si Pedro don pang kakarong ong loa ong ge-ley ang plasa. Pinalengetan tanandia ta tatang babay ang torobolon tang kalawigan ang padi. Ganing tang babay ong ni Pedro, “Midio yawa aromana ka tang Jesus ang asing taga Galilea.” ");
INSERT INTO agn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piro nagbo-li si Pedro ong talongan tang tanan ang mga taw don. Ganing tanandia, “Way inayo— indio gatako mga onopay agbibitala mo!” ");
INSERT INTO agn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Oman napalawid-lawid tanandia don ong may portan tang kodal. Don inita si tanandia tang tata sing torobolon ang babay, ig ganing ong mga taw ang pamansi-deng don, “Ang taw ang na aroman ni Jesus ang taga Nazaret.” ");
INSERT INTO agn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nagbo-li si si Pedro ang ganing, “Sompano pa! Indio enged gailala ong taw ang asing agganingen mo!” ");
INSERT INTO agn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Maboay-boay ta ge-ley, namansipalenget ong nandia tang mga taw ang asing ke-deng don ig ganing ka, “Yawa, tata kaman ong mga aroman ni Jesus! Gata-wanan sia tenged pario tang ponto tang pamitala mi.” ");
INSERT INTO agn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piro nanompa pa enged si Pedro ang ganing, “Mapatayo pa! Indio baya gailala ong taw ang asi!” Ig ya ray ang pagpanolōk tang mano. ");
INSERT INTO agn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Oman nademdeman da ni Pedro tang inaning ni Jesus ong nandia ang ganing, “Ba-lo manolōk tang mano, ma-long bisisang maning ang india gailala ong yen.” Ig nagalin si Pedro ang dorong i-yak na. ");
INSERT INTO agn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pagaramal, māga pang pisan namagbaragat-bagat tang mga pangolokolong padi may ang mga mepet tang banoa ig namagpaigo mga onopay boaten nira agod mapapatay nira si Jesus. ");
INSERT INTO agn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Oman dayon dang linapot nira ig ingkelan ong ni Pilato, ang gobirnador, ig inintriga nira don ong nandia. ");
INSERT INTO agn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Asing pagatako tang traidor ang si Judas ang nasintinsian da si Jesus ang patayen, nagtogat tanandia ong bindoat na. Animan napaning tanandia ong mga pangolokolong padi may ong mga mepet tang banoa, para ibalik na tang sinol ong nandia ang tolompolok ang pidasong koartang silber. ");
INSERT INTO agn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ganing si Judas ong nira, “Nagkatalakong enged ang tinraidoro tang tatang taw ang andang pisan ay talak na.” Piro ganing tang mga pangolokolo ang namansisabat, “Balā! Yawa tang manabat!” ");
INSERT INTO agn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Oman ang bindoat ni Judas, sina-bol na tang koarta don ong teled tang Timplo, ig pagatapos dayon tanandiang limindoa ig binitay na tang sadili na. ");
INSERT INTO agn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ang koartang sina-bol ni Judas, pinisik tang mga pangolokolong padi. Ganing tanira, “Ang koartang narin indi ra poiding igapil ong koarta tang Timplo. Sia kontra ong Katobolan ta tenged ang koartang na binayad agod ipapatay tang tatang taw.” ");
INSERT INTO agn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Asing ori ra, namagoyonan tanira nga ang koartang asi ibakal tang tanek tang manigboat ta oron agod boaten ang lebengan para ong mga dayoan. ");
INSERT INTO agn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Animan asta mandian ang tanek ang asi aggoyan ta “Tanek ang binayadan ta dogo.” ");
INSERT INTO agn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ong nainabong asi, nagmatod tang inaning tang propitang si Jeremias ang ganing, “Ang tolompolok ang pidasong koartang silber ang yay ang kantidad ang pinaginigoan tang mga Israelita ang bayad para ong kaboi na, kinomit nira ong ori ig ");
INSERT INTO agn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","binayad ong tanek tang manigboat ta oron, sigon ong tobol tang Dios ong yen.” ");
INSERT INTO agn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mandian, asing si Jesus don da ong talongan ni Pilato, sine-ma tanandia ni Pilato ang ganing, “Onopa? Matod ang yawa tang adi tang mga Judio?” Siminabat si Jesus, “Yawa ra ka tang naganing.” ");
INSERT INTO agn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Piro asing agbandanan tanandia tang mga pangolokolo ong mga padi ig ang mga mepet tang banoa, inding pisan tanandia minibek-ibek. ");
INSERT INTO agn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Animan minaning ong nandia si Pilato, “Indi gaba-yan mo tang yading agbabandan nira kontra ong nio? Angay india sasabat?” ");
INSERT INTO agn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Piro inding pisan siminabat si Jesus, maski ong tata ong mga riklamo nira. Animan nabereng ta mo-ya tang gobirnador. ");
INSERT INTO agn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kada Pista tang Pagta-lib tang Anghil, nakaogalian da tang gobirnador ang pagpalpat ta tatang priso, mga sinopay pa-dolon ong nandia tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mandian, nāton ong takon ang asi may tatang bantog ang priso, ang aran na si Barabbas. ");
INSERT INTO agn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Animan asing pamagsimet da tang mga taw, nane-ma si Pilato ong nira ang ganing, “Sinopa tang galiagan ming palpatano, si Barabbas obin si Jesus ang aggoyan ta Cristo?” ");
INSERT INTO agn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Maning don tang te-ma ni Pilato tenged gata-wanan nang gangaibeg lamang ong ni Jesus tang mga pangolokolong padi, ig yay sia animan ingkelan nira si Jesus ong nandia. ");
INSERT INTO agn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ig belag lamang ta sia, mintras kakarong si Pilato don ong palagosgaran, nagpatobol tang katawa na ong nandia ang ganing, “Indi enged palabetan mo tang taw ang asia ang anday kasalanan na. Tenged talabi pinaliwagano ta mo-ya tang talakinepo natetenged ong nandia.” ");
INSERT INTO agn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Piro ang bindoat tang mga pangolokolong padi ig ang mga mepet tang banoa, sinolsolan nira tang mga taw ang si Barabbas tang pa-dolon nirang palpatan ig si Jesus ipapatay. ");
INSERT INTO agn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Animan nane-ma sing oman tang gobirnador ong mga taw, “Sinopa ong doroang narin tang galiliagan ming palpatano?” “Si Barabbas,” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ganing sing oman si Pilato, “Mga maning don, onopay boateno ong ni Jesus ang aggoyan ta Cristo?” Namansisabat tanirang tanan, “Ilansang ong kros!” ");
INSERT INTO agn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ganing si Pilato, “Angay? Onopay bindoat nang malain?” Mas sinodoan pa tang mga taw tang iteg nira, “Basta ilansang ong kros!” ");
INSERT INTO agn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Asing itaen ni Pilato ang anda ra enged ay maimo na tenged ang mga taw mamagkagolo ra, nagpakomit tanandia ta wi ig namanaw ong talongan mismo tang mga taw. Ganing si Pilato, “Anda ray sarabateno ong kamatayen tang taw ang na. Bāla amo!” ");
INSERT INTO agn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Namansisabat tang mga taw, “Sigi, yami asta ang mga ana amen yay balang manabat ong kamatayen na!” ");
INSERT INTO agn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Animan ong ori, pinalpatan ni Pilato si Barabbas. Piro si Jesus pinalatigo na, ig pagatapos inintriga na ong mga sondalo na para ilansang ong kros. ");
INSERT INTO agn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ingkelan si Jesus tang mga sondalo ong palasio tang gobirnador, ig namagsimet don ong palibot na tang yading mga sondalo. ");
INSERT INTO agn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Lindoatan nira si Jesus tang lambong na, oman pinatokan nira ta kapang granati bilang intirimis. ");
INSERT INTO agn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Namagboat tanira ta korona-koronang poros tenek oman bintang nira ong kolo na. Pinabiotan ka nira ta bi-lak ong kalima nang to, bilang baston ta adi. Oman aglod-lodan nira ang ganing, “Biba ong adi tang mga Judio!” ");
INSERT INTO agn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Inolakan pa nira tanandia, oman kinomit nira tang agbiotan nang baston ang bi-lak ig pinatakan nira tang po-pok tang kolo na. ");
INSERT INTO agn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagatapos nirang insolton, lindoatan nira tang kapang granati ig pinatokan si nira tang sadiling lambong na, ba-lo ingkelan da nira ong loa tang siodad para ilansang ong kros. ");
INSERT INTO agn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Asing loloa ra tanira ong siodad, may nabagat nirang tatang taw ang taga Cirene, ang aran na si Simon. Rineges tanandia tang mga sondalo ang magtakan tang kros ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Oman namagdayon tanirang paning ong logar ang aggoyan ta Golgota, ang maliag yaning, logar ang pa-dekan ang midio doli ta kolo ta taw. ");
INSERT INTO agn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pagakabot nira don, agpainemen din nira si Jesus ta bino ang may sampora nang mapakit. Piro pagadimdim na ta si, indi tanandia manginem. ");
INSERT INTO agn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ig dayon dang linansang nira ong kros. Asing pagalansang da nira, namagparabonlokan tanira para parti-partien nira tang mga lambong na. ");
INSERT INTO agn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pagatapos ta si, namansikarong tanira para magbantay ong nandia. ");
INSERT INTO agn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ong may kokoloan na, nagbetang tanira ta karatola ong kros. Sinolatan narin tang riklamo kontra ong nandia ang ganing, “Na si Jesus, ang Adi tang mga Judio.” ");
INSERT INTO agn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","May doroang kriminal kang pinadengan nira ong ni Jesus ang linansang. Ang kros tang tambilog gampir ong to ni Jesus, ig ang tata gampir ong wala. ");
INSERT INTO agn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Agileng-ilengan tanandia tang mga taw ang pamansita-lib ig agginsolton nira ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Hoy, ganinga laglagen mo tang Timplo ig ong teled ta tolong kaldaw ipa-deng mo sing moman! Mga yawa tang Ana tang Dios, abir! Tomaboana atan ong kros ig ilibri mo tang sadili mo!” ");
INSERT INTO agn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Maning ka don tang bindoat tang mga pangolokolong padi ig ang mga manigtoldok tang Katobolan asta ang mga mepet tang banoa. Linibak nira si Jesus ang ganing, ");
INSERT INTO agn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Linibri na tang doma, piro indi malibri na tang sadili na! Ta, tanandia ono tang adi tang Israel. Itaen ta lamang bomabak ong kros na, magparet ita ong nandia! ");
INSERT INTO agn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ganing tanandia pagtalig ono ong Dios, ig Ana ono mismo tang Dios! Telekan ta— mga matod ang agmalen tanandia tang Dios, ilibri na enged tanandia!” ");
INSERT INTO agn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Asta ang mga kriminal ang linansang ang aroman na, maning ka don tang panginsolto nira ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Asing ko-to ra ang magalas dosi ra, nangi-lep tang kalibotan tegka alas tris tang apon. ");
INSERT INTO agn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ig asing alas tris da, miniteg si Jesus ta mapoirsa ang ganing, “Eli, Eli, lama sabachthani?” ang maliag yaning, “Ampoanong Dios, Ampoanong Dios, angay pinabayano nio?” ");
INSERT INTO agn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Naba-yan narin tang domang mga taw ang pamansi-deng don ig ganing tanira, “Aggoyan na si Elias!” ");
INSERT INTO agn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","May tata ong nira ang nanikad ang nangomit ta ispongha oman sine-me na ong binong maka-lem. Pagatapos, bintang na ong kapotan tang bi-lak oman dinoydoy na para ipasepsep ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Piro ganing tang doma, “Pabayan mo! Telekan ta mga komabot kaman si Elias para ilibri tanandia.” ");
INSERT INTO agn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Miniteg si si Jesus. Oman inintriga na ra tang ispirito na ong Dios ig nabontok da tang linawa na. ");
INSERT INTO agn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ong oras kang asi, ya kay ang golping pagaba-bak tang ka-ngan tang kortinang dorog kabael ang don ong Timplo, magalin ong dibabaw sa-sad ong babakan. Nanlinog ta mapoirsa ig nangabelak tang mababael ang mga bato. ");
INSERT INTO agn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Golping nagabri tang mga lebengan ig binoing oman tang dorong mga sinakepan tang Dios ang nangapatay da asing tokaw. ");
INSERT INTO agn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Limindoa tanira ong mga lebengan nira, ig asing naboi rang oman si Jesus, ba-lo namansipaning ong sagradong siodad tang Jerusalem, ig dorong mga taw tang nangaita ong nira. ");
INSERT INTO agn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pagaita tang kapitan ig ang mga goardiang pamagbantay ong ni Jesus asing pagpanlinog ig inita nira mismo tang tanan ang nainabo, pinangelban tanira ta mo-ya. Ganing tanira, “Matod ka kaman ang Ana tang Dios tang taw ang na!” ");
INSERT INTO agn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Don ong alawid-lawid yadi kang mga babay ang pamanorong. Tanira tang namansitabid ong ni Jesus nagalin ong Galilea ang pamagasikaso ong nandia. ");
INSERT INTO agn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Katabid da don si Maria Magdalena, si Mariang nanay ni Santiago may ni Jose, ig ang katawa ni Zebedeo. ");
INSERT INTO agn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Asing apon da, may kiminabot ang tatang manggaden ang taga Arimatea, ang aran na si Jose. Tanandia tata ka ong mga sinagpan ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mandian, napaning si Jose ong ni Pilato para maglisinsia mga poiding komiten na tang sinangoni ni Jesus ong kros. Ig nagordin si Pilato ang i-dol ong nandia. ");
INSERT INTO agn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pagakomit ni Jose tang sinangoni ni Jesus, binongot na ta ba-long abel ang kolit. ");
INSERT INTO agn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Oman bintang na ong sadiling lebengan ang para rin ong nandia. Ang lebengan ang asi midio koiba, ang ba-lo lamang pinaboat na ong pagsinsil ta bato. Pagabetang na tang sinangoni ni Jesus ong koiba, nagpaligid-ligid tanandia ta mabael ang bato ang dinapa na don ong anga tang koiba, oman minolik da. ");
INSERT INTO agn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Si Maria Magdalena ig ang tata pa enged ang Maria don kang pamansikarong ong toga tang lebengan. ");
INSERT INTO agn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ang kaldaw ang asi ay Biyernes ig ya kay ang Kaldaw ang Palagsimpan tang mga Judio. Animan pagaramal, ang ya ray ang Kaldaw ang Igperenay nira, namansipaning ong ni Pilato tang mga pangolokolong padi, aroman nira tang mga Pariseo. ");
INSERT INTO agn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ganing tanira, “Garalangen ang gobirnador, gademdeman amen, asing boi pa tang taw ang asing manloloko, minaning ang maboi ono tanandiang moman, pagata-lib tang tolong kaldaw. ");
INSERT INTO agn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Animan mo-ya pa sigoro, pabantayan mo tang limbengan ong nandia ong teled ta tolong kaldaw. Itaben komiten tang sinangoni na tang mga sinagpan na, oman mamamalita tanira ong mga taw ang maning naboi ra ono tanandiang oman. Mga maning don tang boaten nira, lomboang mas sobra pa tang panloko nira ong dati.” ");
INSERT INTO agn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ganing si Pilato ong nira, “Sigi, magekel amo ta mga goardia. Pabantayan mi ta mo-ya tang lebengan.” ");
INSERT INTO agn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Animan dayon dang namampaning tanira ong koiba. Minarkan nira tang mabael ang batong agdadapa agod mata-wanan mga may magabri, oman pinabantayan da nira tang lebengan ong mga goardia. ");
INSERT INTO agn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pagata-lib tang Kaldaw ang Igperenay, asing garamal pa lamang kaldaw ang Dominggo, namansipaning da Maria Magdalena ig ang tata pang Maria ong lebengan ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Golping nanlinog ta mapoirsa ig napababak ta tatang anghil tang Gino ang nagalin ong langit. Pinaigod na tang batong agdadapa ong anga tang koiba, ig don tanandia kiminarong. ");
INSERT INTO agn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ang emet na pisan ang sisinggat ang midio koldap, ig ang lambong na pisan ang kakolit-kolitan. ");
INSERT INTO agn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ang mga goardia ang pamagbantay don, namangelel pa ong sobrang karaelden nira ig nangatomba ang midio ra patay asing pagaita nira tang anghil. ");
INSERT INTO agn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Piro ganing tang anghil ong mga babay, “Indi amo meled! Gata-wanano ang agdilemen mi si Jesus ang linansang ong kros. ");
INSERT INTO agn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Anda ra tarin. Naboi rang oman tanandia, pario tang inaning na rang lagi ong nindio tanopa sia pa. Tani amo, telekan mi tang logar ang bintangan ong nandia.” ");
INSERT INTO agn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pagatapos, ganing tang anghil ong nira, “Dalien mi, magbalik amo ra ig aningen mi tang mga sinagpan na ang naboi rang oman tanandia, ig tongkaw da ong nindio don ong Galilea. Itaen mi tanandia don. Indi lipatan mi tang inaningong na ong nindio.” ");
INSERT INTO agn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Animan dali-daling nagalin don ong lebengan tang mga babay. Pinangeldan tanira piro gangalipay mintras pamagsinikad para mamalita ong mga sinagpan ni Jesus tang nainabo. ");
INSERT INTO agn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Asing pamagsinikad pa tanira, golpi tanirang binagat ni Jesus ong dalan ig pinakomostan na tanira. Dayon ang laging namansilod tanira ong talongan na, kineget nira tang mga kakay na ig tinowan. ");
INSERT INTO agn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ganing si Jesus ong mga babay, “Indi amo meled. Paningan mi tang mga logodo ig aningen ming kaministiran paning ang lagi tanira don ong Galilea. Dono itaen nira.” ");
INSERT INTO agn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pagapagalin tang mga babay ong lebengan, ang doma ong mga goardia namansipaning da ka ong lansangan, ig binalita nira ong mga pangolokolo ong mga padi tang tanan ang nainabo don ong lebengan. ");
INSERT INTO agn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Animan namagbaragat-bagat ang lagi tang mga pangolokolo ong mga padi may ang mga mepet tang banoa. Namagpaigo tanira ang oldan nira ta mabael ang koarta tang mga goardia agod indi tanira mamamalita tang onopay matod ang nainabo. ");
INSERT INTO agn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Sinoldokan nira tang mga goardia tang onopay ibalita nira ong mga taw. Ganing tanira, “Maning amo ong mga taw ang mintras gangapoyat amo talabi, kiminabot tang mga sinagpan ni Jesus ig tinakaw nira tang sinangoni na. ");
INSERT INTO agn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ig mga komabot ong gobirnador tang balitang na, yami tang balang manabat ong nandia.” ");
INSERT INTO agn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Rinisibi tang mga goardia tang koarta ig namagtoman tang sinoyon ong nira. Animan asta mandian ya pa ka enged tang istoriang agpabantog tang mga Judio. ");
INSERT INTO agn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mandian, ang tampolok may tatang sinagpan ni Jesus namansipaning don ong Galilea ong tatang bokid, pario tang sinoyon na rang lagi ong nira. ");
INSERT INTO agn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pagaita nira ong ni Jesus, dayon tanirang namansilod ong talongan na ig namagto ong nandia. Piro may doma ang namagdoadoa. ");
INSERT INTO agn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Oman napalenget si Jesus ong nira ig minaning, “Sindol da ong yen tang tanan ang gaem ong langit asta ong tanek. ");
INSERT INTO agn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Panaw amo ig paningan mi tang tanan ang taw ong tanan ang mga nasion ig boaten mi tanirang mga sinagpano. Boniagan mi tanira ong aran tang Tatay, ang Ana, may ang Ispirito Santo. ");
INSERT INTO agn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Toldokan mi tanira ang tomanen nira tang tanan ang sinoldoko ong nindio. Ig demdemen mi ang yo pirmiong aroman mi asta ong kataposan tang kalibotan.”");
INSERT INTO agn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Na yay ang impisa tang Mo-yang Balita natetenged ong ni Jesu-Cristo, ang Ana tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Asing tokaw pa, sinolat tang propitang si Isaias tang bitala tang Dios ong nandiang Ana ang ganing, “Tobolono tang yen ang torobolon ang tongkaw ong nio, para simpanen na tang paranawan mo. ");
INSERT INTO agn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Don ong logar ang anday gistar ang taw, maginiteg tanandia ang maning, ‘Simpanen mi tang paranawan tang Gino! To-liden mi tang mga dalan ang panawan na!’ ” ");
INSERT INTO agn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Animan narin nagmatod kaman asing pagkabot ni Juan ang Manigboniag don ong logar ang anday gistar ang taw. Don tanandia nagtoldok ong mga taw ang agpaning ong nandia ang ganing, “Magtogat amo ong mga kasalanan mi ig magpaboniag agod patawaden amo tang Dios.” ");
INSERT INTO agn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kadoro-doroan tang mga taw ang namansipaning don ong ni Juan para mamasi ong bitala na. Namagalin tanira ong siodad tang Jerusalem ig ong tanan ang mga logar tang probinsia tang Judea. Aggaminen nira tang mga talak nira oman agboniagan tanira ni Juan ong soba tang Jordan. ");
INSERT INTO agn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Si Juan, ang lambong na bindoat ong bolbol tang kamilio ig ang a-ket na olit ka ta ayep. Ang pamangan na mga siba-la may lanaw. ");
INSERT INTO agn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mga pagtoldok ong mga taw, maning ta na tang pirming agbibitala na: “May komabot ang domaton ong yen piro mas alawig tang dengeg na ong yen. Ig maski ngani tomokok ig magobad tang kordon tang rapak na, belago ta bagay. ");
INSERT INTO agn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yo, pagboniago ong nindio ong wi lamang, piro tanandia magboniag ong nindio ong Ispirito Santo.” ");
INSERT INTO agn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Asing timpong asi, kiminabot da kaman si Jesus don ong soba tang Jordan, nagalin ong Nazaret ang sakep tang probinsia tang Galilea. Nagpaboniag ka tanandia ong ni Juan. ");
INSERT INTO agn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Asing tatakat da si Jesus magalin ong soba, lagi-lagi inita na tang langit ang nagabri ig inita na ka tang Ispirito Santo ang napababak ong nandia ang maga lare. ");
INSERT INTO agn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ig may tatang bosis ang nagalin ong langit ang ganing, “Yawa tang agmalenong Anao. Galipayo ta mo-ya ong nio.” ");
INSERT INTO agn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pagatapos ta si, dayon ang laging pinapaning si Jesus tang Ispirito Santo don ong tokawan, don ong logar ang anday tataw na. ");
INSERT INTO agn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ig don tanandia nagtinir ta epat ang polok ang kaldaw ang agtokson ni Satanas. May don kang mga maraiteg ang mga ayep. Ig inasikaso si Jesus tang mga anghil. ");
INSERT INTO agn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mandian, asing agprison da si Juan ang Manigboniag, nagbalik si Jesus ong probinsia tang Galilea ig don nagpatako tang Mo-yang Balita ang nagalin ong Dios. ");
INSERT INTO agn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ganing tanandia ong mga taw, “Kiminabot da tang tamang oras ig alenget dang maggaem tang Dios tarin ong kalibotan. Animan magtogat amo ig magparet ong Mo-yang Balitang na.” ");
INSERT INTO agn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tatang kaldaw, mintras papanaw si Jesus ong binit tang baybay tang Galilea, may inita nang doroang manigyan ang pamana-tak ta lambat. Tanira ay si Simon ig ang logod nang si Andres. ");
INSERT INTO agn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ganing si Jesus ong nira, “Tomabid amo ong yen, agod imbis ang magyan amo, toldokan amo yen para maekelan mi tang mga taw agod mamagparet tanira ong Dios.” ");
INSERT INTO agn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ig lagi-lagi bino-wanan nira tang lambat nira ig siminabid da ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pagatokaw-tokawan nira ta ge-ley, inita ka ni Jesus tang doroa sing maglogod ang da Santiago ni Juan, ang mga ana ni Zebedeo. Don tanira ong bilog nira ang pamagsinsay tang lambat nira. ");
INSERT INTO agn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ginoyan ka tanira ni Jesus ig dayon ang laging bino-wanan nira tang tatay nira don ong bilog, aroman tang mga tawan nira, ig siminabid ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Oman, namansipaning da Jesus ong lansangan tang Capernaum ig pagkabot tang Kaldaw ang Igperenay tang mga Judio, siminled si Jesus ong simban nira ig nagtoldok. ");
INSERT INTO agn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nangabereng ta mo-ya tang mga taw, tenged gitaen ong pagtoroldokon na ang may sadiling aotoridad na, belag ta pario tang nirang mga manigtoldok tang Katobolan ni Moises. ");
INSERT INTO agn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Maboay-boay ta ge-ley, golping siminled ong simban tang tatang taw ang aggaeman ta malain ang ispirito, ");
INSERT INTO agn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ig miniteg ang ganing, “Aroy! Jesus ang taga Nazaret! Angay pagpalabeta ong yen? Onopa? Napaninga tarin para langgaen aming mga malain ang ispirito? Gailalā yen! Yawa tang Sagradong nagalin ong Dios!” ");
INSERT INTO agn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sinambleng ni Jesus tang malain ang ispirito ang ganing, “Magipesa! Lomboā atan ong taw ang asia!” ");
INSERT INTO agn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dayon ang pinapeleg-peleg tang dimonio tang taw, oman naginiwik tang dimonio ta dorog kapoirsa ba-lo limindoa. ");
INSERT INTO agn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nangabereng tang tanan ig namagtere-ma te-man ang ganing, “Onopa bato na? Ba-long klasing toldok? Maski ang mga dimonio ordinan na lamang, pamagtoman ang lagi ong nandia!” ");
INSERT INTO agn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ig indi naboay, nabantog tang balitang natetenged ong ni Jesus ong bilog ang probinsia tang Galilea. ");
INSERT INTO agn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pagaloa ni Jesus ong simban, nagdiritso tanandia ong balay da Simon ni Andres. Siminabid ka si Santiago may si Juan. ");
INSERT INTO agn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na pala, ang panogangan ang babay ni Simon agkinten ig lolbog lamang. Animan pagkabot ni Jesus, bineg ang lagi nira ig ");
INSERT INTO agn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","napalenget tanandia ong mepet. Bindiotan na ong kalima na oman binangon na. Nago-yang lagi tang mepet ig nagasikaso ong nira. ");
INSERT INTO agn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Asing pagakorop tang kaldaw, ingkelan tang mga taw ong ni Jesus tang mga pamagmasit ig ang mga aggaeman ta malalain ang ispirito para pao-yaen na. ");
INSERT INTO agn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Animan alos ang tanan ang taw ang taga lansangan namagsirimet-simet don ong loa tang balay. ");
INSERT INTO agn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pinao-ya ni Jesus tang yading mga may masit nira, maski onopang klasiay ta masit, ig pinalayas na tang yading mga dimoniong siminled ong mga taw. Piro indi enged pinagnan ni Jesus tang mga dimoniong asi ang mamagbitala, tenged gailala nira mga sinopa enged tanandia. ");
INSERT INTO agn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Garamal pa lamang, nambangon da si Jesus ig napaning ong tatang logar ang anday gistar ang taw para mangadi. ");
INSERT INTO agn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Asing kaldaw da, dinilem tanandia ta mo-ya ni Simon may ang mga karomanan na, ");
INSERT INTO agn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ig pagatoman nira ong nandia ganing tanira, “Agdilemena ta dorong mga taw.” ");
INSERT INTO agn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Piro siminabat si Jesus ang ganing, “Kaman din, piro kaministiran ang paningan ta pa tang domang mga logar ang alelenget tarin, agod mapagtoldoko ka ong nira. Sia tang dailan animan napaningo tarin.” ");
INSERT INTO agn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Animan linibot nira tang tanan ang logar ong probinsia tang Galilea. Nagtoldok si Jesus ong mga simban tang mga Judio ig pinalayas na tang mga malalain ang ispirito ang pamaggaem ong mga taw. ");
INSERT INTO agn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tatang kaldaw, napaning ong ni Jesus tang tatang taw ang may masit nang liproso. Liminod ong talongan na ig nagpakiloy ang ganing, “Gata-wananong mapao-yao nio mga galiliaga lamang.” ");
INSERT INTO agn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dorong kate-bek ni Jesus ong liprosong asi, animan bindiotan na ig minaning, “Galiliago! Mago-yā ra.” ");
INSERT INTO agn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ig lagi-lagi nago-ya tang masit na ig nanlimpio ra tang olit na. ");
INSERT INTO agn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Oman, pinaolik ang lagi ni Jesus matapos ang sinoyonan na ta maelet ang ganing, ");
INSERT INTO agn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“India enged mamalita maski ong ninopa. Paninga lamang ong padi ong Timplo ig ipaita mo ang yawa mo-yā ra. Oman magtorola tang bolontad ang sigon ong Katobolan ni Moises bilang pamatod ong mga taw ang nago-ya ra tang masit mo ig limpioa ra.” ");
INSERT INTO agn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Piro ang bindoat tang taw ang asi, nagpanaw ig namalita ong tanan ang gangabagat na tang bindoat ni Jesus ong nandia. Tenged tarin, indi ra madali-daling ma-led si Jesus ong mga lansangan, tenged tompok-tompokan si tanandia ta dorong mga taw. Animan don da lamang tanandia nagtinir ong kabokidan. Piro maski maning don, sigi pa ka enged tang paning tang mga taw ong nandia, pagalin ong tanan ang mga logar. ");
INSERT INTO agn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pagata-lib tang pirapang kaldaw, nagbalik si Jesus ong lansangan tang Capernaum. Nabantog ang lagi tang balita ang tanandia kiminabot da, ");
INSERT INTO agn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","animan doro sing mga taw tang namagsirimet-simet don ong balay ang aggistaran na. Ponok da tang balay, asta ong loa tang porta siek-siekan da, animan anda ray ma-led ang doma. Mintras pagtoldok si Jesus tang bitala tang Dios, ");
INSERT INTO agn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","may kiminabot ang epat ang taw ang pamagtoang ta tatang taw ang paralisado. ");
INSERT INTO agn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Indi tanira malenget ong ni Jesus tenged ong dorong taw. Animan ang bindoat nira, kimina-yat tanira ong dibabaw tang balay ig binoloat nira tang katep don ong toga ni Jesus. Oman don sinonton nira tang paralisado, ang lolbog lamang ong bayan-bayan, ong talongan ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Asing itaen ni Jesus ang mapoirsa tang pagtalig nira ong nandia, ganing tanandia ong paralisado, “Anao, pinatawad da tang mga kasalanan mo.” ");
INSERT INTO agn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mandian, may don kang mga manigtoldok tang Katobolan ni Moises ang kakarong. Ig pagabasi nira tang inaning ni Jesus, namagena-ena ong sadili nira ang ganing, ");
INSERT INTO agn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Aroy! Angay maning atan tang bitala tang taw ang na? Dorog kabelat tang kasalanan ang na! Anday domang mapagpatawad tang mga kasalanan ta, ang Dios lamang!” ");
INSERT INTO agn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Piro gata-wanan ang lagi ni Jesus tang aggisipen nira. Animan ganing tanandia, “Angay pamagisip amo ta maning atan? ");
INSERT INTO agn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ong aypa tang mas madaling yaning ong tatang paralisado? ‘Pinatawad da tang mga kasalanan mo’? Obin ang maning ong nandia, ‘Kendenga! Takanen mo tang aglolbogan mo ig panawa ra.’ ");
INSERT INTO agn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Animan mandian, pao-yaeno rang lagi tanandia para mapamatodano ong nindio ang yo, ang Ana ta Taw, may gaemo kaman tarin ong kalibotan para magpatawad tang mga kasalanan.” Oman ganing si Jesus ong paralisado, ");
INSERT INTO agn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kendenga! Takanen mo tang aglolbogan mo ig molika ra.” ");
INSERT INTO agn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ig mintras agpa-dekan tang mga taw, kimindeng da tang taw ang asi. Sinakan na ra tang bayan-bayan na ig napanaw dang minolik. Belag lamang ta ge-ley tang kabeberengen tang mga taw ig dorong pagdayaw nira ong Dios ang ganing, “Ya ra lamang ay kaboay indi aming pisan gaita ta maning ta na!” ");
INSERT INTO agn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pagatapos ta si, napaning sing oman si Jesus ong binit tang baybay tang Galilea. Dorong taw tang namansipaning ong nandia ig don tanandia nagtoldok ong nira. ");
INSERT INTO agn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Asing nagdayon da tanandiang napanaw, inita na tang tatang manigtokot ta bois, ang aran na si Levi, ana ni Alpeo. Don tanandia kakarong ong paragtokotan ta bois. Ganing ong nandia si Jesus, “Impisa mandian, tomabida ra ong yen.” Ig dayon ang kimindeng si Levi ig siminabid ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mandian, asing pamamangan da Jesus may ang mga sinagpan na ong balay ni Levi, yadi kang aroman nirang pamamangan ang manigtokot ta bois ig mga taw ang mapinagtalaken, tenged pirmi tanirang pamansitabid-tabid ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mintras pamangan si Jesus aroman na tang mga taw ang asi, inita tanandia tang domang mga Pariseong manigtoldok tang Katobolan. Animan sine-ma nira tang mga sinagpan ni Jesus ang ganing, “Angay ga-pen tanandia ang pamangan ong mga manigtokot ta bois ig ong domang mga mapinagtalaken?” ");
INSERT INTO agn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Naba-yan tanira ni Jesus animan tanandia tang siminabat. Ganing tanandia, “Ang mga taw ang anday masit nira, anday kaministiran ta doktor. Ang may mga masit lamang tang kaministiran ang bolongon. Pario ka ta si, yo, indio napaning tarin para goyano tang mga taw ang ganing anday talak nira. Napaningo ta para goyano tang mga taw ang aggakon nirang tanira mapinagtalaken.” ");
INSERT INTO agn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tatang kaldaw pamagpaletem tang mga sinagpan ni Juan ang Manigboniag ig ang mga Pariseo. May mga taw ang liminenget ig nane-ma ong ni Jesus ang ganing, “Ang mga sinagpan ni Juan ig ang mga sinagpan tang mga Pariseo, madagmit ang pamagpaletem. Piro angay ang mga sinagpan mo anda enged?” ");
INSERT INTO agn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ganing ang siminabat si Jesus, “Pabetang ta may kasalan. Onopa? Mamagpaletem bato tang mga tangay tang laling ba-long kinasal mintras aroman pa nira tanandia? Indi ka enged! Mintras aroman pa nira tang laling kinasal, indi ka enged mamagpaletem tang mga tangay na. ");
INSERT INTO agn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Piro komabot tang kaldaw ang komiten ong nira tang laling kinasal, ig ya ray ang oras ang tanira mamagpaletem.” ");
INSERT INTO agn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ganing pa si Jesus, “Indi poiding itambel tang ba-long abel ong loma rang lambong. Tenged mga matalpoan da tang lambong ang sinambelan, kemere tang ba-long abel ang sinambel, asta mabegtat ig mas mambael pa tang lasik na. ");
INSERT INTO agn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ya ka ong ba-long bino. Indi poiding ibetang ong lomang tereldan ang olit ta ayep ang indi ra maonat. Tenged lompok ig arangan tang bino asta ang tereldan. Ang tamang boaten, ang ba-long bino ibetang ong ba-lo kang tereldan.” ");
INSERT INTO agn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","May tatang Kaldaw ang Igperenay, tata-lib da Jesus ong mga kakoman ang arayegen da lamang. Mintras tata-lib tanira, ang mga sinagpan na pamanlantok ta pirapang koay na oman aggeyeben nira. ");
INSERT INTO agn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pagaita tang mga Pariseo, ganing tanira ong ni Jesus, “Telekan mo tang agboaten tang mga sinagpan mo! Mandian Kaldaw ang Igperenay. Kontra ong Katobolan tang agboaten nirang asia.” ");
INSERT INTO agn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ganing si Jesus ang siminabat, “Angay? Indi gabasa mi ong Sagradong Kasolatan tang bindoat ni David asing linetem da tanandia may ang mga karomanan na asing anda ray mapangan nira? ");
INSERT INTO agn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nainabo narin asing timpo pang si Abiatar tang pangolokolo ong mga padi. Ang bindoat ni David, siminled ong balay tang Dios ig namangan tang sagradong tinapay ang nabolontad da ong Dios. Sindolan na pa tang mga karomanan na, maski sigon ong Katobolan, ang mga padi lamang tang poiding mamangan ta si.” ");
INSERT INTO agn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ig ganing pa si Jesus ong nira, “Ang taw indi bindoat para ong Kaldaw ang Igperenay. Ang Kaldaw ang Igperenay yay ang bindoat para ong ikakao-ya tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Animan yo, ang Ana ta Taw, yo tang may gaem ang maganing mga onopay poiding boaten, maski ong Kaldaw ang Igperenay.” ");
INSERT INTO agn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Siminled sing oman si Jesus ong simban tang mga Judio. May tatang lali don ang pilay tang kalima na. ");
INSERT INTO agn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ig may mga taw ka don ang pamagdilem ta dailan agod madimanda nira si Jesus ong mga agboaten na. Animan pamagbantay tanira mga pao-yaen na tang taw ang asi maski Kaldaw ang Igperenay. ");
INSERT INTO agn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mandian, ganing si Jesus ong taw ang asing pilay tang kalima na, “Tania kang lagi ong tokawan.” ");
INSERT INTO agn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Oman nane-ma si Jesus ong mga taw ong palibot na, “Onopay agpagnan ong Katobolan ang poiding boaten mga Kaldaw ang Igperenay? Ang magboat ta mo-ya obin ang magboat ta malain? Magsalbar ta masig ka taw ta obin mamatay?” Piro indi tanira minibek-ibek. ");
INSERT INTO agn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pina-dekan tanira ni Jesus ang may kasisilagen ig kapongawan na tenged mga matetegat ta popotokon. Oman minaning tanandia ong taw ang asing pilay, “Abir, yonat mo tang kalima mo.” Inonat na tang kalima na ig nago-ya ka kaman. ");
INSERT INTO agn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Animan namagalin ang lagi tang mga Pariseo ong simban ig namagdiritso ong mga tawan tang Ading si Herodes, para mamagampang-ampang mga monopa mapapatay nira si Jesus. ");
INSERT INTO agn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pagatapos ta si, namagalin da Jesus may ang mga sinagpan na ig namansipaning ong baybay tang Galilea. Dorong mga taw tang namansidaton ong nandia ang namagalin ong probinsia tang Galilea. Doro kang namansikabot ang namagalin ong probinsia tang Judea, ");
INSERT INTO agn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ong siodad tang Jerusalem, ong mga logar ang sakep tang Idumea, ong mga logar ong dobali tang Soba tang Jordan, ig ong mga logar ong palibot tang mga siodad tang Tiro ig Sidon. Namansipaning tanira ong ni Jesus tenged naba-yan da nira tang tanan ang bindoat na. ");
INSERT INTO agn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tenged ong kadodoron tang mga taw, nagtobol si Jesus ong mga sinagpan na ang mangomit ta bilog agod karongan na para indi tanandia makapit. ");
INSERT INTO agn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yadi rang napao-ya na, animan pamagpara-kawan tang tanan ang may masit nira ang malenget ong nandia, maski mate-lek da lamang ong lambong na. ");
INSERT INTO agn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Asta ang mga taw ang aggaeman ta mga malalain ang ispirito, maita lamang ong ni Jesus, dayon ang laging dadagpa ong kakayan na ang pamansiteg, “Yawa tang Ana tang Dios!” ");
INSERT INTO agn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Piro maelet tang toyon ni Jesus ong mga ispiritong asi ang indi tanira magbeg ong mga taw mga sinopa enged tanandia. ");
INSERT INTO agn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pagatapos ta si, siminakat si Jesus ong tatang bokid. Pinatabid na tang mga taw ang galiliagan nang patabiden. ");
INSERT INTO agn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Oman namilik tanandia ta tampolok may doroa ong nira, ang ginoyan nang mga apostolis na, agod magimong aroman na ig matobol nang magtoldok ong mga taw. ");
INSERT INTO agn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Sindolan na tanira ta gaem ang magpalayas ta mga dimonio. ");
INSERT INTO agn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ang tampolok may doroang apostolis ang pinilik ni Jesus yay na: Si Simon ang pinaranan na ra ta Pedro; ");
INSERT INTO agn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Santiago may ang logod nang si Juan, ang mga ana ni Zebedeo. Tanira ginoyan na ta “Boanerges” ang maliag yaning “mga ana tang doldol.” ");
INSERT INTO agn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Domaton da Andres, Felipe, Bartolome, Mateo, Tomas, Santiagong ana ni Alfeo, may si Tadeo; si Simon ang pagmal ta mo-ya ong banoa nang Israel, ");
INSERT INTO agn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ig si Judas Iscariote ang yay ang nagtraidor ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pagatapos ta si, minolik si Jesus ong balay ang aggistaran na. Doro sing mga taw ang namagsirimet-simet don, animan maski pagpamangan da Jesus may ang mga sinagpan na, indi ra mangatalonga. ");
INSERT INTO agn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pagabalita tang mga kalogodan ni Jesus, namampaning da don para mangosil ong nandia, tenged ganing tang mga taw, gabariado ra ono tanandia. ");
INSERT INTO agn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","May don kang mga manigtoldok tang Katobolan ni Moises ang namagalin ong Jerusalem ang ganing ang si Jesus ono aggaeman da ni Satanas, ang yay ang pangolokolo ong mga dimonio. Ig si Satanas ono tang pagtorol ta gaem ong ni Jesus ang magpalayas ta mga malain ang ispirito. ");
INSERT INTO agn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tenged tarin, ginoyan ni Jesus tang mga taw ang palenget ong nandia ig nagbitala ong nira ong mga palimbawa ang ganing, “Onopa bato? Mapagpalayas si Satanas ong sadili na? ");
INSERT INTO agn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pabetang ta, mga ang mga taw ong tatang inadian, tanira mismo tang pamagkorontran, mamagbereblag ang enged tang inadian ang asi. ");
INSERT INTO agn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ig maski ong tanga balayan, mga tanira mismo tang pamagsoroayan, indi maboay mamagbereblag ang enged. ");
INSERT INTO agn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mandian, mga si Satanas mismo tang pagpalayas tang mga sinakepan na, maliag yaning agkontraen na tang sadili na! Mga maning don, monopa madayon tang inadian na? Mamagbereblag ka enged lamang! ");
INSERT INTO agn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Si Satanas, ang kalimbawan na pario ong tatang taw ang mapoirsa. Tenged anday taw ang ma-led ong balay na para mangomit tang mga kagamitan na mga indi kang lagi lapoton tanandia. Piro mga nalapot da ngani, ya ray ang oras ang mapanakaw ong teled tang balay na. ");
INSERT INTO agn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Tandan mi na ta mo-ya: Mapatawad tang tanan ang mga talak tang mga taw asta ang tanan ang malain ang bibitala nira kontra ong Dios. ");
INSERT INTO agn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Piro ang sinopay magbitala ta malain kontra ong Ispirito Santo, inding pisan mapatawad maski ong tanopa. Ekelan na tang talak nang asi ong anday kataposan.” ");
INSERT INTO agn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Minitala si Jesus ta maning ta na tenged ganing tang doma, “Aggaeman tanandia ta dimonio.” ");
INSERT INTO agn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Maboay-boay ta ge-ley, kiminabot tang nanay ni Jesus may ang mga logod na. Pinagoy lamang nira si Jesus ong teled tang balay ig don tanira pamagelat ong loa. ");
INSERT INTO agn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Asing oras ang asi, yading mga taw ang kakarong ong palibot ni Jesus ig may minaning ong nandia, “Asia ong loa tang nanay mo ig mga logod mo. Agdilemena nira.” ");
INSERT INTO agn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Siminabat si Jesus ang ganing, “Piro sinopa bato tang nanayo may ang mga logodo?” ");
INSERT INTO agn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Oman pina-dekan na tang mga taw ang kakarong ong palibot na ig ganing, “Na yay ang nanayo ig ang mga logodo! ");
INSERT INTO agn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tenged ang sinopay pagtoman tang kaliagan tang Dios, tanira yay ang agbibilango ang nanayo ig mga logodo.” ");
INSERT INTO agn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tatang kaldaw, nagtoldok si si Jesus ong mga taw don ong binit tang baybay tang Galilea. Tiniripo-pokan tanandia ta kadoro-doroan ang mga taw, animan ang bindoat na siminay tanandia ong tatang bilog ong dalay-dalayan tang talsi ig don kiminarong. Ang mga taw don lamang ong takat. ");
INSERT INTO agn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sinoldokan tanira ni Jesus ta yading mga bagay, ang paggamit ta mga palimbawa. Ong tatang palimbawa na ganing tanandia, ");
INSERT INTO agn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mamasi amo. May tatang taw ang napanaw ong koma na para magta-bol ta binik. ");
INSERT INTO agn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ong pagtara-bolon na, may mga binik ang nabo-log ong dalan. Siminogpo tang mga lamlam ig dayon ang laging sinompit nira. ");
INSERT INTO agn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","May mga binik kang nabo-log ong kabatoan ig manipit lamang tang tanek don. Animan namansilongay ang lagi. ");
INSERT INTO agn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Piro asing makintan tang kaldaw, nangalanet ang lagi tenged dibabaw lamang tang lamot na. ");
INSERT INTO agn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ang domang binik nala-sik ong kaibabawenan ang tenekan. Namanrabong tang mga ibabawen ig dineg na tang ba-long namansilongay, animan indi namamorak. ");
INSERT INTO agn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","May doma pa enged ang binik ang nabo-log ong matambek ang tanek. Liminongay, namambael ig namorak ta doro. Ang doma, tolong polok ang pasi kada koay na, may enem ang polok, ig may tale-tang gatos.” ");
INSERT INTO agn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pagatapos, ganing si Jesus, “Mamasi tang may talinga!” ");
INSERT INTO agn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Asing pagapagalin tang mga taw, namampalenget ong ni Jesus tang tampolok may doroang apostolis na may ang domang mga taw ang pirming pamansitabid ong nandia. Namane-ma tanira mga onopa tang maliag yaning tang mga palimbawa na. ");
INSERT INTO agn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ganing si Jesus ang siminabat, “Ang mga sikrito natetenged ong inadian tang Dios, agbebego ra ong nindio mandian para maintindian mi. Piro ong doma, ang agtotoldoko poros lamang ong palimbawa, ");
INSERT INTO agn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","agod magmatod tang na-tang ong Sagradong Kasolatan ang ganing, ‘Maski pa-dek man tanira tang pa-dek, indi tanira mangaita. Maski mamasi man tanirang mamasi, indi tanira mangaintindi. Tenged mga mangaintindi tanira, itaben magbalik pa tang nem nira ong Dios ig patawaden pa tang mga kasalanan nira.’ ” ");
INSERT INTO agn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Oman, ganing si Jesus ong nira, “Onopa? Indi naintindian mi tang palimbawang inistoriao ong nindio? Mga anda, mono amo pa bato maintindi tang doma pang palimbawao? ");
INSERT INTO agn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Maning ta na tang maliag yaning ta si: Ang mga binik ang sina-bol tang manigkoma, yay ang bitala tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ang mga binik ang nailat ong dalan, yay ang mga taw ang pamamasi tang bitala tang Dios, piro dadaton ang lagi si Satanas ig agkomiten na tang bitala ang naloak da ong popotokon nira. ");
INSERT INTO agn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Ang mga binik ang nabo-log ong kabatoan, yay ang mga taw ang pamamasi tang bitala ig agrisibien ang lagi nira ang may kalipay. ");
INSERT INTO agn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Piro tenged belag ta de-dek ong popotokon nira, indi lamang maboay tang pagto nira. Mga agliwagan tanira obin aggakigan tenged ong pagtoman nira ong bitala tang Dios, dayon ang laging bo-wanan nira tang pagto nira. ");
INSERT INTO agn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Ang mga binik ang nangala-sik ong kaibabawenan, pario ka mga may mga taw ang pamamasi tang bitala tang Dios, ");
INSERT INTO agn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","piro pamagpaborido ong yading irintindien nira ig gaekelan ong manggad nira asta ang doma pang mga bagay ang galiagan nirang magimong nira. Animan ang bitala tang Dios andang pisan ay borak na ong kaboi nira. ");
INSERT INTO agn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Piro ang binik ang nabo-log ong matambek ang tanek, yay ang mga taw ang pagabasi nira tang bitala tang Dios, agloloak ang lagi nira ong popotokon nira ig agpareten. Animan ang bitala may masinlong borak na ong kaboi nira. Ang doma kasarangan lamang, ang doma doro, ig ang doma kadoro-doroan.” ");
INSERT INTO agn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ganing pa si Jesus, “Sinopa lamang ay magsindi ta kingki oman dapan na ta gantangan, obin i-tang na ong adalem tang katri? Simpri ang kingki don ka enged ibetang ong borondoan na. ");
INSERT INTO agn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anday gatalok ang indi ipaita, ig anday sikritong indi mata-wanan ong ori ig maintindian ka enged. ");
INSERT INTO agn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Animan mamasi tang may talinga!” ");
INSERT INTO agn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ganing sing oman si Jesus, “Pama-yan mi ta mo-ya tang agbibitalao. Tenged oldan amo tang Dios ta kinata-wanan kompormi ong pagprosigir mi ang maintindi, ig sobra pa ngani. ");
INSERT INTO agn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ang taw ang may gata-wanan na natetenged ong Dios, dolangan pa. Piro ang taw ang anday gata-wanan na, maski ang ge-ley lamang ang gata-wanan na, sia komiten pa ka enged ong nandia.” ");
INSERT INTO agn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ganing pa si Jesus, “Ang gainabo ong inadian tang Dios pario ka asing nagloak tang tatang taw ta binik ong koma na. ");
INSERT INTO agn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mga labi gapoyat tanandia. Pagtela tang kaldaw, bangon si. Ig mintras tata-lib tang mga kaldaw, pamansilongay ig pambabael tang mga lindoak na. Piro indi gaintindian tang taw ang asi mga monopa tang paglolongayen na. ");
INSERT INTO agn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ang tanek mismo yay ang pagpabael ig pagpatambek tang mga iloloak. Primiro mandaon. Mga mabael da, mamorak da ig lomboa ra tang mga koay na. ");
INSERT INTO agn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mga lotok da ngani, dayon dang gapasen tenged arayegen da.” ");
INSERT INTO agn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“Ong aypa pa ikompara ta tang inadian tang Dios? Onopa pay domang palimbawa ang poiding gamiteno agod madaling maintindian? ");
INSERT INTO agn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ang inadian tang Dios pario ong tatang alibotod ta mostasa. Na kage-ley ge-leyan ong tanan ang mga alibotod ang poiding iloak. ");
INSERT INTO agn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Piro mga maloak da ngani, pambael asta mas mabael pa ong domang mga iloloak. Panrabong tang mga tanga na ig poiding magboat ta poyad don tang mga lamlam.” ");
INSERT INTO agn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yadi pang palimbawang pario ta na tang ginamit ni Jesus ong pagtoldok na tang bitala tang Dios ong mga taw, ig kompormi ong nirang masarangan ang maintindian. ");
INSERT INTO agn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ong karakelan, indi tanandia nagtoldok ang indi paggamit ta palimbawa. Piro mga tanira-tanira ra lamang tang mga sinagpan na, agpaintindi na ong nira tang maliag yaning tang mga palimbawa na. ");
INSERT INTO agn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ang kaldaw ang asi, asing gakorop da tang kaldaw, ganing si Jesus ong mga sinagpan na, “Maytara! Paning ita ra ong dobaling baybay.” ");
INSERT INTO agn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Animan bino-wanan lamang nira tang mga taw ong takat ig namansitay ang lagi ong bilog nirang mabael ang don dang lagi si Jesus, ba-lo namansilarga. May mga domang bilog ang namansidengan ong nira. ");
INSERT INTO agn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mandian, asing don da tanira ong laod, golpi tanirang kinabotan ta tampo ig agtampekan tang bilog ta mababael ang langeb asta ge-ley da lamang ma-mokan. ");
INSERT INTO agn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Piro si Jesus don ong boli tang bilog, agtatandig ong moala ig gapoyat da. Animan pinoaw ang lagi tang mga sinagpan na. “Magino!” ganing tanira, “Angay baliwala ong nio maski mapatay ita ra?” ");
INSERT INTO agn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nambangon si Jesus ig sinambleng na tang mageyep ang ganing, “Maglinawa ra!” ig ganing ka ong langeb, “Magpoasa ra!” Dayon kaman ang laging nagpoas tang mageyep ig golping naglinaw tang kalibotan. ");
INSERT INTO agn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Oman ganing si Jesus ong mga sinagpan na, “Angay pamansieled amo? Asta mandian anda pay pagtalig mi ong yen?” ");
INSERT INTO agn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Piro pisan tanirang pinangeldan ig nangabereng ta mo-ya, animan namagtere-ma te-man ang ganing, “Sinopa enged bato tang taw ang na? Maski ang mageyep may ang langeb pagtoman ong nandia!” ");
INSERT INTO agn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kiminabot da tanira ong dobaling baybay ong logar tang mga Geraseno. ");
INSERT INTO agn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagataboan ni Jesus, binagat ang lagi tanandia ta tatang taw ang nagalin ong simintirio. Ang taw ang na aggaeman ta malain ang ispirito, ");
INSERT INTO agn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ig don tanandia gistar ong mga pantion. Indi kayang lapoton ta maski talikala. ");
INSERT INTO agn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pira rang bisis ang linapot ta talikala may posas. Piro kada lapoton, ang posas aglalampak na asta mabelak, ig agbontok-bontokon na tang mga talikala. Andang pisan ay taw ang madeg ang magawid ong nandia. ");
INSERT INTO agn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kaldaw may labi pagalig-alig lamang ong mga lebengan ig ong kabokidan ang paginiteg. Aggigadan na pa tang sinangoni na ta matarem ang bato. ");
INSERT INTO agn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mandian, alawid pa inita na ra si Jesus, animan nagsinikad ang napalenget ong nandia ig liminod ong talongan na. ");
INSERT INTO agn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Miniteg ta mapoirsa ang ganing, “Jesus, Ana tang Kalawig-lawigan ang Dios! Onopay boaten mo ong yen? Mate-beka kay ong yen. Indio ka papagpinitinsiaen mo!” ");
INSERT INTO agn_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Maning ta si tang bitala tang malain ang ispirito tenged sinobol da ni Jesus ang ganing, “Malain ang ispirito, lomboā atan ong taw ang asia!” ");
INSERT INTO agn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Animan mandian sine-ma ni Jesus tang dimonio, “Sinopay aran mo?” Siminabat tang dimonio, “Ang arano si Rinibo, tenged rinibo aming siminled ong sinangoni tang taw ang na.” ");
INSERT INTO agn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ig sigi lamang tang pakiloy tang mga dimonio ong ni Jesus ang indi pālinen na tanira ong logar ang asi. ");
INSERT INTO agn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mandian, don ong takatan tang bokid ang alenget-lenget, dorong mga baboy ang pamanoliad. ");
INSERT INTO agn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Animan namagpakiloy tang mga malalain ang ispirito ong ni Jesus ang ganing, “Don ami ra lamang pa-leden mo ong mga baboy ang asi.” ");
INSERT INTO agn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ganing si Jesus, “Ala sigi, don amo!” Limindoa ong taw tang mga dimonio ig sinled da nira tang mga baboy. Oman ang mga baboy diritsong namagsinikad ong pangpang ig nangabo-log ong talsi asta nangalmet ang tanan. Ang mga baboy ang asi mga doroang ribo. ");
INSERT INTO agn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ang mga mamanigsagod tang mga baboy dayon ang namagsinikad ig binalita nira ong lansangan asta ong kababarioan tang nainabong na. Animan namansipaning tang mga taw don para telekan mga onopa enged ay nainabo. ");
INSERT INTO agn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pagakabot nira don ong ni Jesus, kinabotan nira tang taw ang dating aggaeman tang mga dimonio, ang kakarong da, paglambong da ig mo-ya ra tang isip na. Animan pinangeldan tanira. ");
INSERT INTO agn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Inistoria si ong nira tang mga nangaita mga monopa nago-ya tang taw ang dating aggaeman tang mga dimonio asta ang nainabo ong mga baboy. ");
INSERT INTO agn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tenged tarin, ang mga taw namagpakiloy ong ni Jesus ang magalin da tanandia don ong logar nira. ");
INSERT INTO agn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Asing tomay da si Jesus ong bilog ang mabael, napalenget tang taw ang asing dating sinled tang mga dimonio. Nagpakiloy ong ni Jesus ang patabiden na kay. ");
INSERT INTO agn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Piro indi pinatabid ni Jesus, ig ganing, “Molika ra ong nindio. Ibalita mo ong mga kalogodan mo tang bindoat ong nio tang Dios ig monoapa inate-bekan na.” ");
INSERT INTO agn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Animan napanaw da tang taw ig ang bindoat ni Jesus ong nandia binalita na ong tanan ang mga siodad tang Decapolis. Ig ang tanan ang nangabasi belag lamang ta ge-ley tang kabeberengen nira. ");
INSERT INTO agn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nagbalik si da Jesus ong dobaling baybay ig pagataboan lamang nira, tinompok-tompokan sing lagi tanandia ta kadoro-doroan ang mga taw. ");
INSERT INTO agn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kiminabot ka tang tatang lali, ang aran na si Jairo, tatang pangolokolo ong simban tang mga Judio. Pagaita na ong ni Jesus, diminagpa ong talongan na ");
INSERT INTO agn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ig nagpakiloy ang ganing, “Agpakamo-kamo ra tang anao ang sosoltiras! Tomabida kay ong yen! Maski ibondo mo lamang tang kalima mo ong nandia, maolikan pa tang kaboi na.” ");
INSERT INTO agn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Siminabid ong nandia si Jesus. Kadoro-doroan ang mga taw tang pamansitabid ong nira ang pamagsagesean. ");
INSERT INTO agn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","May tata kang babay don ong mga taw ang pagdogo-dogo ong teled da ta tampolok may doroang takon. ");
INSERT INTO agn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Doro rang pinitinsia na tenged ong dorong manigbolong ang napatelekan na. Lobot da tang tanan ang koarta na asta ang mga pagkabetang na ong pagpabolong lamang, piro indi ka enged nago-ya, mas kiminasag pa. ");
INSERT INTO agn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Naba-yan na ra tang balita tang mga taw natetenged ong ni Jesus. Animan mandian gimine-get tang babay ong mga taw asta nakabot ong boko-boko ni Jesus, oman sine-lek na tang lambong na, ");
INSERT INTO agn_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","tenged ganing ong sadili na, “Maski mate-leko lamang tang lambong na, mago-yao ra.” ");
INSERT INTO agn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Animan, pagate-lek na ong lambong ni Jesus, nagpoas ang lagi tang pagdogo-dogo na ig naba-yagan nang mo-ya ra tanandia. ");
INSERT INTO agn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ya kay ang pagaba-yag ni Jesus ang may poirsang limindoa ong nandia, animan minalied ig nane-ma ong mga taw, “Sinopay simine-lek ong lambongo?” ");
INSERT INTO agn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Siminabat tang mga sinagpan na, “Magino, agsagesen ita ta dorong taw! Mono ita pa matako mga sinopay simine-lek ong nio?” ");
INSERT INTO agn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Piro sigi pa tang lipara ni Jesus ang pagdilem tang nagte-lek ong nandia. ");
INSERT INTO agn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ig tenged gata-wanan tang babay tang nainabo ong sadili na, ong sobrang eled na napalenget ong ni Jesus ang pangelel. Liminod ong talongan na ig nagbeg tang kamatodan. ");
INSERT INTO agn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Oman minaning si Jesus ong nandia, “Babay, ang pagtalig mo tang nagpao-ya ong nio. Molika ra ig india ra magsinti, tenged mo-yā rang pisan.” ");
INSERT INTO agn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Asing bibitala pa si Jesus, may mga taw ang kiminabot ang nagalin ong balay tang pangolokolo ang si Jairo, ig ganing tanira ong nandia, “Maski indi ra bedlayen ta tang Maistro. Ang ana mo anda ra.” ");
INSERT INTO agn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Piro indi inintindi ni Jesus tang binalita nirang asi ong ni Jairo. Ganing tanandia, “India magsinti. Magtaliga lamang ong yen.” ");
INSERT INTO agn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nagdayon tanira tang panaw. Piro anday domang pinatabid ni Jesus, si Pedro lamang ig ang doroang maglogod ang si Santiago may si Juan. ");
INSERT INTO agn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pagakabot nira ong balay ni Jairo, inita ni Jesus ang pamagkagolo ra tang mga taw don. May pamagini-yak, ang doma pamagdayag. ");
INSERT INTO agn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Siminled si Jesus ong balay ig minaning ong mga taw, “Onopay aggimaloan mi? Angay pamagini-yak amo? Belag ta patay tang mola. Gapoyat lamang.” ");
INSERT INTO agn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Piro inimodan lamang nira si Jesus. Animan pinaloa na tanirang tanan. Oman ingkelan na tang mga ginikanan tang mola, asta ang tolong sinagpan na, ig siminled tanira ong koartong aglolbogan tang mola. ");
INSERT INTO agn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bindiotan ni Jesus tang kalima na ig minaning, “Talita komi,” ang maliag yaning, “A-ing, mambangona ra.” ");
INSERT INTO agn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dayon ang laging nambangon tang mola ig nagpanaw-panaw. Ang molang asi ba-long tampolok may doroang takon. Ang pamansipa-dek pisan ang nangabereng. ");
INSERT INTO agn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Piro sinoyonan tanira ta maelet ni Jesus ang indi mamalita maski ong ninopa tang nainabo. Oman ganing pa si Jesus, “Papanen mi ra tang mola.” ");
INSERT INTO agn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pagatapos ta si, nagalin si Jesus don ig minolik ong sadiling logar na. Siminabid ka tang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pag kabot tang Kaldaw ang Igperenay, nagtoldok si Jesus ong simban tang mga Judio. Dorong mga taw ang pamamasi ong nandia ig pisan tanirang gangabereng. Ganing tanira ang pamagtere-ma te-man, “Ong aypa bato nakomit tang taw ang na tang tanan ang agtotoldok na? Onora kang kinata-wanan ay tang sindol ong nandia? Angay gapagboat ta mga milagro? ");
INSERT INTO agn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Gailala ta tang taw ang na! Tanandia tang karpintiro ka lamang, ang ana ni Maria ig logod da Santiago, Jose, Judas may ni Simon. Asta ang mga logod nang mga babay tarin ka pamansistar!” Ig tenged ong kaerep nira, indi enged ilalaen nira. ");
INSERT INTO agn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Animan ganing si Jesus ong nira, “Ang tatang propita aggilalaen tang tanan ang taw, poira lamang ong mga kasimanoa na, mga kaparintian na, asta ong pamalay-balay na.” ");
INSERT INTO agn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Animan indi tanandia napagboat ta yading milagro don, poira lamang ong pirapang taw ang pamagmasit ang pinao-ya na ong pagbondo na tang kalima na ong nira. ");
INSERT INTO agn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ig nabereng tanandia ta mo-ya tenged ang mga kasimanoa na indi pamagparet ong nandia. Pagatapos ta si, naglibot si Jesus ong mga kababarioan ang pagtoldok. ");
INSERT INTO agn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Oman ginoyan na tang tampolok may doroang mga apostolis na ig sinobol na tanira ang panaw ang tagtalodoa para magtoldok. Sindolan na tanira ta gaem ang magpalayas ta mga malalain ang ispirito. ");
INSERT INTO agn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Sinoyonan na ka tanira ang ganing, “Ong pagpanaw mi indi amo mamagekel ta maski onopa— baston lamang tang ekelan mi. Indi amo ka magbalon ta pamangan obin magekel ta binagteng, obin maski koarta. ");
INSERT INTO agn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Magtok amo ta rapak, piro indi amo mage-leb tang lambong mi. ");
INSERT INTO agn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Mga komabot amo ong tatang logar ig mga padayonon amo ong tatang balay, don amo lamang magtinir mintras indi amo pa pagalin ong logar ang asi. ");
INSERT INTO agn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Piro mga maning amo ong tatang logar ang indi amo risibien ig indi amo pama-yan tang mga taw don, magalin among lagi ig tapokon mi tang kolapok ong mga kakay mi, para ipaita ming anda ray sarabaten mi ong nira.” ");
INSERT INTO agn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Oman namansipanaw da tang tampolok may doroang apostolis. Namagtoldok ong mga taw ang dapat tanirang magtogat ig bo-wanan nira tang mga kasalanan nira. ");
INSERT INTO agn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yading malalain ang ispirito tang pinalayas nira ong mga taw ang sinledan nira, ig doro kang pamagmasit ang binaniosan nira ta langis ig namago-yang tanan. ");
INSERT INTO agn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Naba-yan da tang Ading si Herodes tang natetenged ong ni Jesus, tenged bantog da tang aran na maski ong aypa. May pamaganing ang si Jesus ono ya kay si Juan ang Manigboniag ang naboing oman, animan sia may gaem nang magboat ta makabebereng ang mga bagay. ");
INSERT INTO agn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Piro ang doma ganing, “Tanandia sigoro tang Propitang si Elias.” Ig ang doma ganing ka, “Tanandia tata kang propita pario tang mga propita asing tokaw.” ");
INSERT INTO agn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Piro pagabasi tang Ading si Herodes, ganing tanandia, “Sia si Juan kaman ang pinapotolano tang likel na! Naboi ra pala!” ");
INSERT INTO agn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Na yay ang kaisip ni Herodes tenged tanopa sia tanandia tang nagpadep ong ni Juan, oman pinalapot na ig pinapriso. Bindoat narin ni Herodes tenged pirming agsamblengen tanandia ni Juan tenged ong pagiga-pen a-pen na ong babay ang si Herodias, ang katawa tang logod nang si Felipe. ");
INSERT INTO agn_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Narin tang pirming agganing ni Juan, “Kontra ong Katobolan ta ang magkatawan amo tang katawa tang logod mo!” ");
INSERT INTO agn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tenged tarin, ang babay ang si Herodias pisan ang gasilagan na si Juan, animan galiliagan na rin ang ipapatay, piro indi paoyon si Ading Herodes. ");
INSERT INTO agn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Geldan si Ading Herodes ong ni Juan tenged gata-wanan nang mato-lid si Juan ig alenget tang nem na ong Dios. Animan si Juan agtabangan ka rin ni Ading Herodes ig agtatalok na lamang ong prisoan. Ong kamatodan, ang adi dorong kaliag nang mamasi ong mga bitala ni Juan maski galibeg tang kinaisipan na ong mga gaba-yan na. ");
INSERT INTO agn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Piro ong ori, kiminabot ka enged tang oras ang gelat-elaten ni Herodias. Nainabo na asing kakaldawan ni Ading Herodes. Nagkombida tang adi ig inimbitar na tang tanan ang mga opisialis na, ang mga pangolokolo ong mga sondalo, ig ang mga alalawig ang mga taw ong probinsia tang Galilea. ");
INSERT INTO agn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mandian, asing pamangalipay da tanira, siminled tang anang babay ni Herodias ig nagtayaw ong talongan tang mga bisita. Dorong kalipay ni Ading Herodes asta ang mga bisita na. Animan ganing tang adi ong soltiras, “Mama-dola tang onopay galiliagan mo, i-dolo ong nio.” ");
INSERT INTO agn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ig nanompa pa tang adi ang ganing, “I-dolo ong nio maski onopay pa-dolon mo, maski ang katengan pa tang inadiano.” ");
INSERT INTO agn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dayon ang limindoa tang soltiras ig nane-ma ong ni nanay na, “Nay, onopay pa-dolono?” Siminabat si Herodias, “Maninga, ‘Ang kolo ni Juan ang Manigboniag.’ ” ");
INSERT INTO agn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dali-daling nagbalik tang soltiras ong ni Ading Herodes ang ganing, “Ang galiliagano, i-dol mo kay ong yen mandian ang lagi tang kolo ni Juan ang Manigboniag, ang agbe-tang ong tatang bandiha.” ");
INSERT INTO agn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pagabasi tang adi, pinongawan tanandia ta mo-ya. Piro gaeyak ang bawien na tang nabitalan na ong soltiras tenged yading mga bisitang nangabasi ong pangako na. ");
INSERT INTO agn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Animan nagordin ang lagi si Herodes ong tatang sondalo na ang paning ong prisoan para potolon tang likel ni Juan, oman e-lan nang magbalik. Diritsong napaning tang sondalo ong prisoan ig pinotol na kaman tang likel ni Juan. ");
INSERT INTO agn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Oman bintang na tang kolo ong tatang bandiha ig ingkelan ong soltiras. Ig narin dayon kang inintriga tang soltiras ong nanay na. ");
INSERT INTO agn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Asing pagatako tang mga sinagpan ni Juan, dayon tanirang napaning don. Kinomit nira tang sinangoni na, oman limbeng nira ong tatang pantion. ");
INSERT INTO agn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mandian, ang mga apostolis ang sinobol ni Jesus namagbalik da ong nandia, ig binalita nira tang tanan ang bindoat nira asta ang sinoldok nira ong mga taw. ");
INSERT INTO agn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pagatapos, ganing si Jesus ong nira, “Ta ra, paning ita ong logar ang alawid-lawid ong mga taw, agod mga ita-ita lamang maenayan amo ka ta ge-ley.” Inaning narin ni Jesus tenged sigi-sigi tang kabot may alin tang mga taw, animan indi ra tanira mangatalongang mamamangan. ");
INSERT INTO agn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Animan dayon tanirang namansitay ong bilog nirang mabael ig namansipaning ong logar ang anday gistar ang taw. ");
INSERT INTO agn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Piro yadi kang nangaita asing pagalin nira ig nailala ka nira ang asi yay da Jesus. Animan namagalin ka tanira ong mga kababarioan nira ig namagsinikad ang pangobay tang baybay. Nanga-kaw pang nangakabot ong logar ang agrombon da Jesus. ");
INSERT INTO agn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagatampet da Jesus ig pagataboan nira, inita na tang kadoro-doroan ang mga taw ang asi ang don da. Dorong katete-beken na ong nira tenged mga pa-dekan na, midio mga karniro ang pinabayan da lamang tang manigbadbad. Animan sinoldokan na tanira ta yading mga bagay. ");
INSERT INTO agn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Asing apon da, namampalenget ong nandia tang mga sinagpan na ig minaning, “Madali rang makorop tang kaldaw, ig anda paman ay mga taw ang gistar tarin ong logar ang na. ");
INSERT INTO agn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mo-ya pa sigoro, papaningen mo ra tang mga taw ong mga bario ig mga sitio ang alenget-lenget para mapamakal tanira ta mapangan nira.” ");
INSERT INTO agn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Piro siminabat si Jesus, “Yamo tang magtorol ta mapangan nira.” Ganing ka tang mga sinagpan na, “Aroy! Panaw ami ig mamakal ta tinapay ang kantidad nang rinibo para ipapan ong nirang tanan?” ");
INSERT INTO agn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nane-ma si Jesus, “Pirapang bilog tang tinapay mi atan? Abir, telekan mi.” Asing matelekan nira, ganing tanira ong ni Jesus, “Limang tinapay ig doroang yan.” ");
INSERT INTO agn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Oman inordinan ni Jesus tang mga sinagpan na ang pakarongon tang mga taw ta gropo-gropo ong kaibabawenan. ");
INSERT INTO agn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Animan ang mga taw namansikarong ta gropo-gropo. May mga gropong tag tale-tang gatos ig may atan ang taglilimampolok. ");
INSERT INTO agn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kinomit ni Jesus tang limang bilog ang tinapay may ang doroang bilog ang yan. Siminingara tanandia ong langit ig nagpasalamat ong Dios. Oman pinisi-pisi na tang mga tinapay ig sindol ong mga sinagpan na para itagtag ong mga taw. Maning ka ta si tang bindoat na ong doroang bilog ang yan. ");
INSERT INTO agn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nangapamangan tang tanan ang taw ig poros nangaelen. ");
INSERT INTO agn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagatapos, sinimet tang mga sinagpan na tang nanga-dang tinapay may yan, ig nanga-mok pa tanira ta tampolok may doroang tiklis. ");
INSERT INTO agn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ang tanan ang mga namamangan, ang mga lali lamang limang ribo rang lagi. ");
INSERT INTO agn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pagatapos ta si, dayon ang laging sinobol ni Jesus tang mga sinagpan na ang tomay da ong bilog nirang mabael agod tongkaw dang paning ong Betsaida, mintras agpaoliken na pa tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pagapagalin tang mga taw, siminakat si Jesus ong tatang bokid para mangadi. ");
INSERT INTO agn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Asing labi ra, ang bilog ang agtayan tang mga sinagpan na don da ong laod, piro si Jesus don pa ong bokid. ");
INSERT INTO agn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Inita nang agliwagan dang panongtong tenged kontra tang mageyep. Ig asing garamal da, diminaton da si Jesus ong nira ang papanaw ong ta-paw tang talsi. Ta-liban na rin lamang tanira, ");
INSERT INTO agn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","piro inita tanandia tang mga sinagpan na ang papanaw ong ta-paw tang talsi. Kalaom nira ang gitaen nira peled, animan ong sobrang eled nira pisan tanirang namangelel ");
INSERT INTO agn_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ig nangaiteg pa. Piro minitalang lagi si Jesus ong nira ang ganing, “Indi amo meled. Yo na, si Jesus!” ");
INSERT INTO agn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Oman siminay si Jesus ong bilog ig dayon ang laging nagpoas tang mageyep. Sia pa tang kabeberengen tang mga sinagpan na, ");
INSERT INTO agn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tenged maski inita ra nira asing pagpapan ni Jesus tang kadoro-doroan ang taw tang pirapang bilog ang tinapay, indi pa ka enged gaintindian nira, tenged midio gangaki-lepan pa tang mga kinaisipan nira. ");
INSERT INTO agn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pagakabot nira ong dobaling baybay, don tanira siminampet ong Genesaret. ");
INSERT INTO agn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagataboan lamang nira, nailalang lagi si Jesus tang mga taga don. ");
INSERT INTO agn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Animan dali-daling lagi tang mga taw ang namaglibot ong mga kababarioan ang pagpatako ang ekelan tang mga pamagmasit, maski lolbog da lamang ong bayan-bayan, maski ong aypang logaray ang naba-yan nira ang don si Jesus. ");
INSERT INTO agn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Animan maski ong aripa agpaning si Jesus, ong lansangan obin ong mga bario, agtakanen nira tang mga pamagmasit nira ong mga plasa nira. Ig namagpakiloy tanira ong ni Jesus ang maski mate-lek da lamang tang mga pamagmasit tang kapotan tang lambong na. Ig ang tanan ang nangate-lek, namago-ya. ");
INSERT INTO agn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tatang kaldaw may mga Pariseo ig mga manigtoldok tang Katobolan ang kiminabot nagalin ong Jerusalem ig namagsimet don ong da Jesus. ");
INSERT INTO agn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Inita nira tang doma ong mga sinagpan ni Jesus pamamangan lamang ang indi namanaw tang mga kalima nira sigon ong toromanen nirang mga Judio. ");
INSERT INTO agn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tenged ang kaogalian tang mga Judio, labi ra enged tang mga Pariseo, maning ta na: Indi tanira mamangan mintras indi pa gapamanaw tang kalima nira sigon ong mga toromanen ang pinanoblian nira ong mga kamepet-mepetan nira. ");
INSERT INTO agn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ig mga maolik tanirang magalin ong palingki, indi ka tanira mamangan tang binakal nira mintras indi pa gaogatan sigon ong kaogalian nira. Ig yadi pang mga pinanoblian nirang mga toromanen pario tang pagpangogat tang mga baso, mga pitsil, ig mga kaldirong saway ba-lo gamiten. ");
INSERT INTO agn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Animan mandian sine-ma si Jesus tang mga Pariseo may ang mga manigtoldok tang Katobolan ang ganing, “Angay indi pamagtoman tang mga sinagpan mo ong mga toromanen tang mga kamepet-mepetan ta? Pamamangan lamang ang indi pamamanaw tang mga kalima nira sigon ong kaogalian ta!” ");
INSERT INTO agn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ganing si Jesus ang siminabat, “Yamong mga taw! Pagpaosto-osto amo piro paita-ita ka lamang! Animan tama kaman tang inaning tang Dios natetenged ong nindio ang pinasolat na ong propitang si Isaias ang ganing, ‘Ang mga taw ang na aggalangeno nira ong anga lamang. Piro ong kamatodan, ang popotokon nira alawid ong yen. ");
INSERT INTO agn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Anday data na tang pagto nira ong yen, Tenged ang mga agtotoldok nirang ganing mga tobol tang Dios, toromanen ang boat-boat lamang ta taw.’ ” ");
INSERT INTO agn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ig ganing si Jesus ong nira, “Maderep amo kaman ong pagosoy tang mga toromanen ang boat-boat lamang ta mga taw, piro ang mga tobol tang Dios agpabayan mi lamang.” ");
INSERT INTO agn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ganing pa tanandia, “Maosay among magboat ta midios para pabayan tang Katobolan tang Dios agod ang mga toromanen mi ya lamang ay matoman! ");
INSERT INTO agn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pario ta narin: Ganing tang tobol tang Dios ang pinasolat na ong ni Moises, ‘Galangen mo tang tatay mo may ang nanay mo,’ ig ‘Ang sinopay magbitala ta malain kontra ong tatay obin ong nanay na, dapat patayen.’ ");
INSERT INTO agn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Piro yamo, parti tang agtotoldok mi. Tenged ganing amo, mga ang taw may matabang na rin ong mga ginikanan na, poiding maning ong nira, ‘May itabango rin ong nindio, piro indi ra ma-dolo tenged “Corban,” maliag yaning, nangakō ra ang i-dol si ong Dios.’ ");
INSERT INTO agn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ong maning don, midio agsagangen mi tanandia ang tomabang ong mga ginikanan na. ");
INSERT INTO agn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Animan, agboaten ming anday kointa na tang tobol tang Dios tenged ong kaogalian ming asia ang agpatobli mi pa ong doma. Ig belag lamang ta sia, yadi pang agboaten ming pario ta sia.” ");
INSERT INTO agn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ginoyan ni Jesus tang mga taw ang palenget ong nandia ig minaning ong nira, “Mamasi among tanan agod maintindian mi tang ibitalao ong nindio. ");
INSERT INTO agn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Belag tang agte-led ong sinangoni ta taw tang pagpaboling ong nandia ong pama-dek tang Dios, kondi ang mga malalain ang loloa ong nandia. ");
INSERT INTO agn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mamasi tang may talinga!” ");
INSERT INTO agn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pagatapos, bino-wanan ni Jesus tang mga taw ig siminled ong balay. Nane-ma ong nandia tang mga sinagpan na mga onopay maliag yaning tang palimbawang asi. ");
INSERT INTO agn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ganing si Jesus ong nira, “Asta yamo, indi amo pa gangaintindi? Indi gata-wanan mi? Belag tang agpanganen ta taw tang pagpaboling ong nandia ong pama-dek tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tenged ang agpanganen na indi agpaning ong popotokon na. Sia diritso ong sian na, oman loloa ong sinangoni na.” Ong pagbitala ni Jesus ta na, pinaintindi na nga maski onopang pamanganay poiding panganen. ");
INSERT INTO agn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Oman ganing pa si Jesus, “Ang loloa ong taw ang pagalin ong popotokon na yay ang pagpaboling ong nandia ong pama-dek tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tenged don mismo ong popotokon ta taw pagalin tang anday sasayod ang mga pagirisipen ig ang mga boat ang malalain, pario tang pagiga-pen a-pen ong belag ta katawa na, ang panakaw, pamatay ta taw, ");
INSERT INTO agn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pangombabay obin pangonlali, gaibeg ig pagboat ta tanan ang kalainan pario tang pagdaya, pagboat ta kabastosan, pangimon, pamirdi ta dengeg tang masig ka taw na, kambogan, ig ang tanan ang kalokoan. ");
INSERT INTO agn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ang tanan ang asia pagalin ong popotokon ta taw, ig sia tang pagpaboling ong nandia.” ");
INSERT INTO agn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Namagalin da Jesus don ig namansipaning ong mga logar ang sakep tang siodad tang Tiro. Pagakabot don, nagdayon si Jesus ong tatang balay. Indi rin galiliag ang mata-wanan tang mga taw ang don tanandia, piro indi ka enged matalok tang balita. ");
INSERT INTO agn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mandian, may tatang babay ang gistar ong logar ang asi, ang may ana nang babay ang ge-ley pa, ang sinled ta malain ang ispirito. Animan pagabasi nang don si Jesus, lagi-lagi napaning ong nandia ig liminod ong talongan na. ");
INSERT INTO agn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ang babay ang na pinangana ong Fenicia ang sakep tang Siria, ig ang bitala na Grigo. Belag tanandia ta Judio. Piro nagpakiloy pa ka enged ong ni Jesus ang palayasen na kay tang dimoniong siminled ong ana na. ");
INSERT INTO agn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Piro siminabat si Jesus ong nandia ong tatang sarabien, “Kaministiran ono ang papanen kang lagi tang mga mola, tenged belag ta tama ang komiten tang pamangan tang mga mola oman i-dol ong mga kiro.” ");
INSERT INTO agn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Siminabat si tang babay, “Matod ka kaman, Magino. Piro maski ngani ang mga kirong pagbantay ong sirong tang lamisan, gapamangan tang mga namek ang gangabo-log ong mga mola.” ");
INSERT INTO agn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Animan ganing si Jesus, “Tama kaman tang sabat mo! Molika ra. Limindoa ra tang dimonio ong ana mo.” ");
INSERT INTO agn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dayon ang minolik tang babay ig kinabotan na tang ana nang agpenay da ta mo-ya ong katri. Ang dimonio nagalin da ka kaman ong mola. ");
INSERT INTO agn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pagalin da Jesus ong Tiro, simina-lib tanira don ong siodad tang Sidon, asta ong probinsia tang Decapolis, ba-lo komabot ong baybay tang Galilea. ");
INSERT INTO agn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","May tatang taw don ang bengel ig boyon ang ingkelan ta mga taw ong ni Jesus. Namagpakiloy tanira ong nandia ang ibondo na kay tang kalima na ong taw ang asi agod mago-ya. ");
INSERT INTO agn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ingkelan ni Jesus ong alawid-lawid tang taw ang bengel, oman sino-sok na tang doroa nga toldokan na ong mga talinga tang taw ang asi. Pagatapos, inolakan ni Jesus tang kalima na ig sine-lek na ong dilak tang taw. ");
INSERT INTO agn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Siminingara si Jesus ong langit ig limininawa ta alawig. Oman minaning ong bengel, “Effata,” ang maliag yaning, “Magabri amo ra!” ");
INSERT INTO agn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ig lagi-lagi nagabri tang talinga na ig nabasi ra kaman. Nakomit da ka tang kaboyon na ig nabitala ra ta osto. ");
INSERT INTO agn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Oman sinoyonan ni Jesus tang mga taw ang indi mamamalita maski ong ninopa tang bindoat na. Piro ong aypa sing agbawalen tanira ni Jesus ang indi mamalita ya kay ang balita nira tang nainabo. ");
INSERT INTO agn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tenged pisan tanirang nangabereng ta mo-ya ig ganing, “Dorog kasinlo tang tanan ang agboaten na! Maski ang mga bengel ig ang mga boyon gapao-ya na!” ");
INSERT INTO agn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","May tatang kaldaw, doro sing mga taw ang namagsimet-simet ong ni Jesus. Asing nalo-tan da tanira tang ekel nirang pamangan, ginoyan ni Jesus tang mga sinagpan na ig minaning, ");
INSERT INTO agn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Gate-beko ong mga taw ang na, tenged tolo rang kaldaw tanirang ka-pen ta, ig mandian anda ray mapangan nira. ");
INSERT INTO agn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mga paolikeno tanirang indi gangapamangan, itaben tomomba tanira ong dalan. Ang doma paman ong nira kalawid tang pinagalinan nira.” ");
INSERT INTO agn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ganing tang mga sinagpan na, “Ong ari ita pa bato makomit ta pamangan tarin ong logar ang na ang anday gistar ang taw ang magigo ong nirang tanan?” ");
INSERT INTO agn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nane-ma si Jesus, “Pirapa pang bilog tang tinapay mi atan?” “Pito ra lamang,” ganing tanira. ");
INSERT INTO agn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Oman pinakarong ni Jesus tang mga taw ong tanek. Kinomit na tang pitong bilog ang tinapay ig nagpasalamat ong Dios. Pinisi-pisi na si ig sindol na ong mga sinagpan na para itagtag ong mga taw. ");
INSERT INTO agn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","May pirapa kang bilog ang yan ang gege-ley. Nagpasalamat sing oman si Jesus ong Dios, ba-lo sinobol na si tang mga sinagpan nang itagtag ong mga taw. ");
INSERT INTO agn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nangapamangan tang tanan ang taw ig poros nangaelen. Pagatapos, sinimet tang mga sinagpan na tang nanga-da, ig nanga-mok pa tanira ta pitong tiklis. ");
INSERT INTO agn_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ang mga taw ang namamangan mga epat ang ribo. ");
INSERT INTO agn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pagatapos ta si, dayon dang pinaolik ni Jesus tang mga taw, ba-lo tanandia siminay ong tatang bilog ang mabael, aroman na tang mga sinagpan na, para paning ong logar ang Dalmanuta. ");
INSERT INTO agn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","May mga Pariseo ang namampalenget ong ni Jesus ang namagigdiskosion. Sobokan din nira tanandia animan ganing tanira, “Abir, magpaitā kay ong yamen ta milagro bilang tanda ang yawa matod ang nagalin ong Dios.” ");
INSERT INTO agn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Limininawa ta alawig si Jesus ig minaning, “Ay, yamong mga taw ong timpong na! Angay pirmi among pamagdilem ta mga milagro? Ong kamatodan, andang pisan ay milagrong ipaita ong nindio.” ");
INSERT INTO agn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pagabitala na ta si, nagalin ang lagi tanandia. Siminay si, aroman tang mga sinagpan na, para loma-ted ong dobaling baybay. ");
INSERT INTO agn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Asi pala nangalipat ang namagbalon ta pamangan tang mga sinagpan ni Jesus. Tambilog lamang tang ekel nirang tinapay asing paglarga nira. ");
INSERT INTO agn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mintras lalayag tanira, ganing si Jesus ong nira, “Magandam amo ong pampalsa ta tinapay tang mga Pariseo may ang pampalsa ni Herodes.” ");
INSERT INTO agn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tenged don, namagampang-ampang tang mga sinagpan na, “Sigoro maning ta si tang inaning na tenged indi ita napamagbalon ta tinapay.” ");
INSERT INTO agn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Gata-wanan ni Jesus tang agpagampangan nira, animan ganing ong nira, “Angay pamagpalibeg amo tang mga kolo mi ang anday ekel ming tinapay? Indi amo pa gangaintindi? Angay dorog kalobay tang pagirisipen mi? ");
INSERT INTO agn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","May mga mata mi, indi amo gangaita? May mga talinga mi, indi amo gangabasi? Onopa? Nalipatan mi ra ");
INSERT INTO agn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","asing pagpisi-pisio tang limang bilog ang tinapay para mangapamangan tang sobra ong limang ribong taw? Pirapang tiklis tang nasimet mi ong nanga-da?” “Tampolok may doroa,” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Asta ang pagpisi-pisio tang pitong bilog ang tinapay para ong epat ang ribong taw, pirapa kang tiklis tang nasimet mi?” “Pitong tiklis,” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ig ganing si Jesus ong nira, “Oman indi amo pa enged gangaintindi?” ");
INSERT INTO agn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pagakabot nira ong Betsaida, may mga taw ang namagekel ong ni Jesus ta tatang taw ang boray. Namagpakiloy tanira ang apapen na kay tanandia para mago-ya. ");
INSERT INTO agn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bindiotan ni Jesus tang boray ong kalima na ig ingkelan na ong loa tang bario. Bintangan na tang olak na tang mga mata tang taw ang asi ig inapap na. Pagatapos, ganing si Jesus, “May gitaen mo ra?” ");
INSERT INTO agn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Napa-dek tang boray ig minaning, “Ee, gitaeno ra tang mga taw, piro ong pama-deko magang mga papa ta ayong papanaw.” ");
INSERT INTO agn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Inapap sing oman ni Jesus tang mata tang boray. Nagprosigir ang napa-dek. Pagpa-dek na, naolikan da tang mga mata na ig mayag da tang pama-dek na. ");
INSERT INTO agn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pagatapos, ganing si Jesus ong nandia, “Molika ra, piro india ra mana-loy ong bario.” ");
INSERT INTO agn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Namansipaning da Jesus may ang mga sinagpan na ong mga kababarioan ang sakep tang siodad ang aggoyan ta Cesarea ni Filipos. Mintras papanaw tanira, nane-ma si Jesus ong mga sinagpan na ang ganing, “Gonopa tang mga taw natetenged ong yen. Yo, sinōpa ono?” ");
INSERT INTO agn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Siminabat tanira, “Ganing tang doma, yawa ono si Juan ang Manigboniag. Ang doma ganing ka, yawa ono si Elias. Ig ganing pa ka tang doma, yawa ono tata pa ong mga propita asing tokaw.” ");
INSERT INTO agn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ig ganing si Jesus ong nira, “Piro mga ong nindio, yo sinōpa?” Ang siminabat si Pedro, “Yawa tang Cristo, ang aggelaten ang komabot!” ");
INSERT INTO agn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Piro maelet tang toyon ong nira ni Jesus ang indi enged mamagbeg ta narin, maski ong ninopa. ");
INSERT INTO agn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mimpisa don, nagimpisa ra si Jesus ang nagsaysay ong mga sinagpan na mga onopa tang mainabo ong nandia. Ganing tanandia, “Yo, ang Ana ta Taw, kaministiran ang mapasarano tang tanan ang kaliwagan ang boaten ong yen tang mga taw. Indio ilalaen tang mga mepet tang banoa, ang mga pangolokolo ong mga padi, ig ang mga manigtoldok tang Katobolan. Kaministiran ang patayeno, piro mata-lib tang tolong kaldaw, maboiong moman.” ");
INSERT INTO agn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sinayod ni Jesus ta mo-ya ong nira. Animan ingkelan tanandia ni Pedro ong alawid-lawid ig agsamblengen na rin tenged ong inaning nang asi. ");
INSERT INTO agn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Piro nanaliod si Jesus, siminalonga ong mga sinagpan na ig dayon kang sinambleng na si Pedro ang ganing, “Lomayasa tarin, Satanas! Belag ta kaliagan tang Dios tang aggisipen mo, kondi kaliagan ta taw!” ");
INSERT INTO agn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Oman ginoyan ni Jesus tang mga taw, asta ang mga sinagpan na, ang palenget ong nandia ig minaning ong nira, “Ang sinopay galiliag ang tomabid ong yen, kaministiran ang lipatan na tang sadili na ig magosoy ong yen, maski kamatayen pa tang talongaen na ong pagtoman na ong yen. ");
INSERT INTO agn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tenged ang taw ang agpalabien na tang kaboi na tarin ong ta-paw tang kalibotan, tanandia tang malipatan tang kaboi na. Piro ang sinopay magbolontad tang kaboi na para ong yen may ong Mo-yang Balita, tanandia tang marisibi ta kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Onopa enged ay mapakinabangan ta tatang taw maski magimong nandia ra tang tanan ang bagay tarin ong kalibotan, piro malipat ka ong nandia tang kaboi na? ");
INSERT INTO agn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Anda! Tenged andang pisan ay mabayad ta taw para igawad na ong kaboi na. ");
INSERT INTO agn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Animan ang taw, mga agkakaeyako nandia ig ang yen ang mga bitala ong talongan tang mga malalain ang taw mandian ang agtaliodan nira tang Dios, ang taw ang asi ikaeyako ka ong pagbaliko tarin. Tenged yo, ang Ana ta Taw, magbaliko tarin ong kalibotan, ang pagekelo tang gaem ig kayagan tang Tatayo ong langit, ig aromano ka tang mga sagradong anghil.” ");
INSERT INTO agn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ganing pa si Jesus, “Tandan mi narin: Ang doma tarin ong nindio mandian, kabotan pa nira tang kaldaw ig itaen nira ang paggaem da tang Dios bilang adi ang may kagaeman ong tanan.” ");
INSERT INTO agn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagata-lib tang enem ang kaldaw, ingkelan ni Jesus si Pedro ig ang doroang maglogod ang da Santiago ni Juan para koma-yat ong alawig ang bokid. Tanira-tanira lamang tang napaning don. Asing don da tanira, mintras agpa-dekan tang mga sinagpan na, inita nirang nagoman tang itsora ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sisinggat-singgat tang lambong na ig pisan ang kakolit-kolitan. Andang pisan ay madeg tang kakolit na. ");
INSERT INTO agn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Oman napaita ong tolong sinagpan si Elias may si Moises ang pamagigampang ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nabitala si Pedro ang ganing ong ni Jesus, “Magino, masinlong narin ami! Magboat ami ta tolo nga payag-payagan. Tata para ong nio, tata ong ni Moises, ig tata ong ni Elias.” ");
INSERT INTO agn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Dorong eled nirang tolo animan indi ra matako si Pedro tang onopay ibitala na. ");
INSERT INTO agn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ya kay ang golpi tanirang binongot ta tatang onom ig may tatang bosis ang naba-yan nirang nagalin don ong onom ang ganing, “Na tang agmalenong Anao. Mamasi amo ong nandia!” ");
INSERT INTO agn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dayon ang namanelek-telek tang tolong sinagpan ong palibot nira piro anda ray inita nirang domang taw, si Jesus da lamang. ");
INSERT INTO agn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Asing totoldak da tanira ong bokid, maelet tang toyon ni Jesus ong nira ang ganing, “Indi enged ibeg mi tang inita mi maski ong ninopa mintras yo, ang Ana ta Taw, indio pa gaboing oman.” ");
INSERT INTO agn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sinalok lamang nira ong sadili nira, piro namagtere-ma te-man mga onopay maliag yaning tang bitala na ang tanandia ono maboing moman. ");
INSERT INTO agn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Oman sine-ma nira si Jesus ang ganing, “Angay ganing tang mga manigtoldok tang Katobolan, kaministiran ono ma-kaw ang komabot si Elias ba-lo pa tang Cristo?” ");
INSERT INTO agn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Siminabat si Jesus, “Matod kaman kaministiran ang tongkaw si Elias para magsimpan tang tanan ang bagay. Ig may atan kang na-tang ong Sagradong Kasolatan ang ganing ang Ana ta Taw kaministiran mapasaran na tang dorong kaliwagan ig pakalainen tanandia tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Piro begen amo yen, kiminabot da si Elias, ig bindoat tang mga taw ong nandia tang tanan ang kaliagan nirang boaten pario tang inaning tang Kasolatan ang mainabo ong nandia.” ");
INSERT INTO agn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Asing pagbalik da Jesus ong mga nabo-wan ang mga sinagpan na, inita nirang agtompok-tompokan ta dorong mga taw. May don kang mga manigtoldok tang Katobolan ni Moises ang pamagigdiskosion ong mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pagaita tang mga taw ang asia ra si Jesus ang gingabot, nangakibot tanira ig namagsinikad ang namansibagat ong nandia. ");
INSERT INTO agn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Oman sine-ma ni Jesus tang mga sinagpan na, “Onopay agpagdiskosionan mi tang mga manigtoldok ang asia?” ");
INSERT INTO agn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","May tatang lali don ong kayadian tang siminabat. Ganing tanandia, “Maistro, aggekelano rin ong nio tang anao ang lali tenged aggaeman tanandia ta malain ang ispirito, ig indi tanandia gabitala. ");
INSERT INTO agn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kada kaboton, golpi lamang tanandia aglalampak tang malain ang ispirito ong tanek. Bobokal tang anga na, kakayeget tang mga isi na, oman dayon dang kentel tang sinangoni na. Nagpakiloyo ra ong mga sinagpan mong palayasen kay nira tang ispirito, piro indi mapalayas nira.” ");
INSERT INTO agn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Siminabat si Jesus, “Ay, yamong mga taw amo! Andang pisan ay pagtalig mi! Asta tanopa tang agoantao ig tiniro ong nindio? Abir, ekelan mi tani tang molang asia.” ");
INSERT INTO agn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ig ingkelan nira tang mola ong ni Jesus. Pagaita tang malain ang ispirito ong ni Jesus, dayon ang laging pinapeleg-peleg na tang mola asta natomba ong tanek, bobolid-bolid ang bobokal tang anga na. ");
INSERT INTO agn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ganing si Jesus ong tatay tang mola, “Monorag kaboay ang maning ta na?” Ganing ang siminabat tang tatay, “Asi pang ge-ley pa tanandia. ");
INSERT INTO agn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pirarang bisis galiagan din ang patayen tang dimonio. Teta agpe-lek na pa ong apoy, teta galiagan nang lemeten din ong wi. Animan mate-beka ong yamen, tabangay ami ka mga kaya mo.” ");
INSERT INTO agn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ganing si Jesus ang siminabat, “Onopay maliag mong yaning tang mga kayao? Ang tanan maboato ong taw ang pagparet ig pagtalig ong yen.” ");
INSERT INTO agn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Oman pinoirsan tang tatay tang bosis na ig nagpakiloy si, “Pagpareto, piro korang pa ka enged! Tabangay kang mamoirsa tang pagtaligo!” ");
INSERT INTO agn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Asing pagaita ni Jesus ang yadi pang mga taw ang pamagsinikad ang agpalenget ong nandia, dayon ang binitalan na tang malain ang ispirito ang ganing, “Yawang dimonioa, agboaten mong bengel may boyon tang taw! Tobolo ong nio, lomboā atan ong molang asia! India ra moman ang magbalik-balik ong nandia!” ");
INSERT INTO agn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Naginiwik tang dimonio ig pinapeleg-peleg na ta todo-todo tang mola ba-lo limindoa. Ang mola indi rang pisan kakaliek, ang midio ra patay. Animan ganing tang mga taw, “Aroy! Patay da!” ");
INSERT INTO agn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Piro bindiotan ni Jesus tang kalima tang mola, oman binangon na ig dayon ang kimindeng. ");
INSERT INTO agn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Paga-led da Jesus ong balay, asing tanira-tanira ra lamang, nane-ma tang mga sinagpan na ong nandia, “Angay yami, indi mapalayas amen tang malain ang ispirito ong molang asi?” ");
INSERT INTO agn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ganing si Jesus ang siminabat, “Ang malain ang ispiritong maning atan, indi basta-basta mapalayas mga indi amo mangadi ig magpaletem. Asia lamang tang midios.” ");
INSERT INTO agn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Namagalin da Jesus don ig namansita-lib si ong Galilea. Indi galiliag si Jesus ang mata-wanan tang mga taw mga ong aypa tanandia, ");
INSERT INTO agn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tenged ang oras ang asi, pagtoldok tanandia ong mga sinagpan na lamang. Ganing si Jesus ong nira, “Yo, ang Ana ta Taw, traidorono ig yintrigao ong gaem tang mga taw ang yay mamamatay ong yen. Piro mata-lib tang tolong kaldaw maboiong moman.” ");
INSERT INTO agn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Indi naintindian tang mga sinagpan na tang mga bitala nang na, piro gengeldan tanirang mane-ma pa ong nandia. ");
INSERT INTO agn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kiminabot da tanira ong Capernaum. Paga-led nira ong balay, sine-ma ni Jesus tang mga sinagpan na ang ganing, “Onopay agpagdiskosionan mi ong dalan?” ");
INSERT INTO agn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Piro indi tanira minibek-ibek tenged ang agpagdiskosionan nira mga sinopa ong nira tang kaimportantian. ");
INSERT INTO agn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Animan kiminarong si Jesus ig pinalenget na tang tampolok may doroang sinagpan na ong nandia ig minaning, “Ang sinopay galiliag ang magimong importanti, kaministiran magpababak ig magsirbi ong tanan.” ");
INSERT INTO agn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Oman ginoyan na tang tatang mola don ig pina-deng na ong ka-ngan nira. Kineget na tang mola ig minaning ong mga sinagpan na, ");
INSERT INTO agn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ang maski sinopa, mga natetenged ong pagto na ong yen, magrisibi ong tatang mola ang pario ta narin, sia pagrisibi ka ong yen. Ig ang pagrisibi ong yen, belag lamang ta yo tang agrisibien na, kondi asta ang nanobol ong yen.” ");
INSERT INTO agn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pagatapos, ganing si Juan ong ni Jesus, “Maistro, may inita amen ang tatang taw ang pagpalayas ta mga malalain ang ispirito ig aggamiten na tang aran mo. Binawalan amen tenged belag ta karomanan ta.” ");
INSERT INTO agn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Piro ganing si Jesus, “Indi bawalen mi. Tenged ang taw ang pagboat ta milagro ang paggamit tang arano, inding lagi mabitala ta malain kontra ong yen. ");
INSERT INTO agn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tenged ang taw ang indi kokontra ong yaten, maliag yaning tanandia kakampi ta. ");
INSERT INTO agn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Agganingo ong nindio, ang sinopay magtorol ong nindio ta maski tang baso lamang ang wi tenged yamo mga sinagpano, ang taw ang asi indi maimong indi balten tang Dios.” ");
INSERT INTO agn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Piro mga may taw ang magtokso agod magkatalak tang maski tata ong mga gege-ley ang narin ang pamagtalig ong yen, mo-ya pa ta-ketan da lamang tang likel na ta mabael ang bato, oman bontogan ong laod. ");
INSERT INTO agn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Animan mga ang kalima mo tang gagikanan ang yawa pagkatalak, potolon mo! Tenged mas mo-ya pang maski potol tang tambilog ang kalima mo, ma-leda pa ong langit, kaysa komplito tang mga kalima mo piro i-leka ka don ong impirno, ong apoy ang indi enged mapatay-patay. ");
INSERT INTO agn_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Don tang mga kolod ang indi mapatay ang pamangan ong mga taw, ig ang apoy ang indi mapatay-patay. ");
INSERT INTO agn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Ig mga ang kakay mo ya kay ang pagekel ong nio ang magkatalak, potolon mo! Mo-ya pang maski potol tang tambilog ang kakay mo, basta ma-leda ong langit, kaysa komplito tang mga kakay mo oman i-leka ka ong impirno. ");
INSERT INTO agn_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Don tang mga kolod ang indi mapatay ang pamangan ong mga taw, ig ang apoy ang indi mapatay-patay. ");
INSERT INTO agn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Ig mga ang mata mo ya kay ang gagikanan ang yawa pagkatalak, koaten mo! Mo-ya pang maski tambilog lamang tang mata mo, ma-leda pa ong inadian tang Dios, kaysa doroa tang mata mo oman i-leka ka ong impirno. ");
INSERT INTO agn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Don tang mga kolod ang indi mapatay ang pamangan ong mga taw, ig ang apoy ang indi mapatay-patay. ");
INSERT INTO agn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kada tata kasinan ta apoy. ");
INSERT INTO agn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mabael tang pakinabang tang kasin. Piro mga manlasay da, indi ra poiding mapakasin pang moman. Animan ekelan ming pirmi tang kao-yan tang kasin ong kaboi mi agod masinlo tang pagtarabidan mi.” ");
INSERT INTO agn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nagalin don si Jesus ig napaning ong mga logar ang sakep tang Judea ba-lo loma-ted ong dobali tang soba tang Jordan. Don doro sing mga taw ang namagsimet ong nandia, ig pario tang pirming agboaten na, nagtoldok tanandia ong nira. ");
INSERT INTO agn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mandian, may mga Pariseo kang namansipaning don ong ni Jesus para depdepen nira tanandia ong mga pamitala na. Animan sine-ma nira ang ganing, “Mga ong nio, sigon ong Katobolan, agpagnan bato ang belagan tang tatang lali tang katawa na?” ");
INSERT INTO agn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Binalik ni Jesus ong nira tang te-ma nira, “Onopay tobol ang sindol ni Moises ong nindio natetenged ong pagberelagen tang magkatawa?” ");
INSERT INTO agn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ganing tanirang siminabat, “Nagpagna si Moises ang belagan tang tatang lali tang katawa na basta oldan na tang babay ta kasolatan bilang ka-telan ang tanandia belagan na ra.” ");
INSERT INTO agn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Piro ganing si Jesus, “Tenged lamang matetegat tang mga kolo mi, animan napaoyon da lamang si Moises ang belagan mi tang mga katawa mi. ");
INSERT INTO agn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Piro asing primiro pa, ang pagboat tang Dios tang kalibotan: ‘Ang bindoat nang taw lali may babay. ");
INSERT INTO agn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tenged tarin, pabelag da tang lali ong mga ginikanan na, oman maga-penan da tanira tang katawa na, ");
INSERT INTO agn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ig magimong tata ra lamang tanira.’ Ang maliag yaning, belag da tanira ta doroa kondi tata. ");
INSERT INTO agn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Animan ang pinapaga-pen tang Dios indi dapat ang papagbelagen ta taw.” ");
INSERT INTO agn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Asing paga-led nira ong balay, nane-ma si ong ni Jesus tang mga sinagpan na natetenged ong inaning nang asi. ");
INSERT INTO agn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ganing si Jesus ong nira, “Mga belagan tang lali tang katawa na, oman mangatawa si tanandia ta doma, loloang pangombabay tanandia ig pagkatalak ong dating katawa na. ");
INSERT INTO agn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ig mga ang babay ya kay magigbelag ong katawa na, oman pakatawa si ka ong doma, pangonlali ka tanandia.” ");
INSERT INTO agn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tatang kaldaw may mga taw ang pamagekel ta mamola ong ni Jesus para pabindisionan nira. Piro sinambleng tang mga sinagpan ni Jesus tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Asing itaen ni Jesus tang agboaten tang mga sinagpan na, nasilag tanandia ig minaning ong nira, “Pabayan mi lamang ang palenget ong yen tang mga mola. Indi bawalen mi. Tenged ang mga taw ang pario ong mamolang narin, yay ang mabilang ong inadian tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tandan mi narin: Ang maski sinopa, mga indi tanandia magpasakep ong gaem tang Dios pario ta tatang mola, asia indi enged tanandia mabilang ong inadian na.” ");
INSERT INTO agn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tapos, dayon ang sinalili ni Jesus tang kada tata ong mga mola, oman binondo na tang kalima na ong kolo nira ig binindisionan. ");
INSERT INTO agn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Asing magalin da rin si Jesus, may tatang taw ang nagsinikad ang agpalenget ong nandia. Liminod ong talongan na ig minaning, “Maistro, yawa mo-yang taw. Onopay masinlong boateno para marisibio tang kaboing anday kataposan?” ");
INSERT INTO agn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ganing si Jesus ang siminabat, “Angay aggoyano nio ta mo-ya? Ang Dios lamang tang mo-ya. ");
INSERT INTO agn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gata-wanan mo ra tang ga-tang ong Katobolan: ‘India mamatay ta taw, india mangombabay, india manakaw, india magtistigo ta bo-li, india magdaya, ig galangen mo tang tatay may ang nanay mo.’ ” ");
INSERT INTO agn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ganing tang lali, “Maistro, ang tanan ang asia agtomaneno ra ka mimpisang ge-leyo pa.” ");
INSERT INTO agn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Pina-dekan ni Jesus tang taw ang asi ig ginegman na. Oman ganing tanandia, “Tanga bagayan da lamang tang korang ong nio. Molika ra, ipabakal mo tang tanan ang pagkabetang mo, oman ang bayad na i-dol mo ong mga malilised. Mga boaten mo sia, magkatinira ta manggad ang tinagana tang Dios don ong langit. Pagatapos, magbalika ig tomabida ong yen.” ");
INSERT INTO agn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Piro pagabasi ta si tang lali, pinongawan tanandia ig minolik ang mabelat tang nem na, tenged dorong manggad na. ");
INSERT INTO agn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Animan pina-dekan ni Jesus tang mga sinagpan na ig minaning ong nira, “Kaliwag ang ma-led ong inadian tang Dios tang taw ang manggaden!” ");
INSERT INTO agn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nangabereng ta mo-ya tang mga sinagpan na ong binitala nang asi. Piro minaning si tanandia, “Mga anao, doro kaman agkaliwag ang ma-led ong inadian tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas madali pa nganing tenled tang tatang kamilio ong boloat tang singgoay, kaysa tatang taw ang manggaden ang tenled ong inadian tang Dios.” ");
INSERT INTO agn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mas nagdolang tang kabeberengen tang mga sinagpan na, animan namane-ma ang ganing, “Mga maning don, sinopa enged tang malibri?” ");
INSERT INTO agn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Pina-dekan tanira ni Jesus ig minaning, “Na indi maboat ta taw, piro belag ta maliwag ong Dios. Tenged anday imposibli ong Dios.” ");
INSERT INTO agn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Minitala si Pedro, “Yami, bino-wanan amen tang tanan para tomabid ong nio.” ");
INSERT INTO agn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Ee, kaman,” ganing si Jesus, “ig narin tang matod: Ang sinopay nagbo-wan tang balay na, ang mga logod na, mga ginikanan na, mga ana na obin ang tanek na natetenged ong yen ig ong Mo-yang Balita, ");
INSERT INTO agn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ang taw ang asi marisibi mandian ong kaboi na tarin ta mas doro pa ong bino-wanan na: dorong mga balay, dorong mga logod, mga nanay, mga ana asta tanek. Piro akigan ka tanandia ig paliwagan ta mga taw tenged ong pagto na ong yen. Ig ong dobaling kaboi, oldan ka tanandia ta kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yading mga taw ang ganga-kaw mandian ang mangaori ong oring kaldaw. Ig ang mga gangaori mandian yay ang manga-kaw.” ");
INSERT INTO agn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mintras papanaw tanirang tatakat ong siodad tang Jerusalem, to-kaw si Jesus ong mga sinagpan na. Agkelban tang mga sinagpan na ig ang mga taw ang dadaton ong orian agpangeldan. Maboay-boay ta ge-ley, pinabelag ta ge-ley ni Jesus tang tampolok may doroang sinagpan na ong mga taw, ig sinaysay na si ong nira tang onopay mainabo ong nandia. ");
INSERT INTO agn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ganing si Jesus, “Tandan mi. Mandian agpaning ita ra ong Jerusalem. Pag kabot ta don, yo, ang Ana ta Taw, traidorono ig yintrigao ong gaem tang mga pangolokolong padi ig ong mga manigtoldok tang Katobolan. Sintinsiano nira ta kamatayen, oman ekelano ong mga belag ta Judio. ");
INSERT INTO agn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Insoltono nira, olakan, latigon, ba-lō patayen nira. Piro mata-lib tang tolong kaldaw, maboiong moman.” ");
INSERT INTO agn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Napalenget ong ni Jesus si Santiago may si Juan, ang mga ana ni Zebedeo, ig minaning tanira, “Maistro, may pa-dolon amen din ong nio.” ");
INSERT INTO agn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ganing si Jesus, “Onopa si?” ");
INSERT INTO agn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ganing tanirang siminabat, “Ang galiagan amen, mga maggaema ra ngani ong niong inadian, yami kay tang pakarongon mo ong tepad mo, ang tata ong to, ig ang tata ong wala.” ");
INSERT INTO agn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Piro ganing si Jesus ong nira, “Indi gata-wanan mi mga onopa tang agpa-dolon mi. Onopa, māgoanta mi tang kaliwagan ang mapasarano? Māgoanta mi ka tang kamatayen ang pario tang mapasarano?” ");
INSERT INTO agn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Ee, māgoanta amen,” tang sabat nira. Ig ganing si Jesus, “Ang kaliwagan ang agoantaeno, agoantaen mi ka kaman. Ig mapasaran mi ka tang kamatayen ang mapasarano. ");
INSERT INTO agn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Piro mga natetenged ong sinopay komarong ong yen ang to ig ong walao, belag ta yo tang maning mga sinopa. Tenged ang mga logar ang agpa-dolon mi, natagana rang lagi ong mga taw ang pinilik da tang Tatayo.” ");
INSERT INTO agn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Asing mata-wanan tang tampolok ang aroman nira mga onopa tang agpa-dolon da Santiago may ni Juan, namaglain tang nem nira. ");
INSERT INTO agn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Animan ginoyan tanirang tanan ni Jesus ang palenget ig minaning, “Gata-wanan mi ra ka, ang mga aggilalaen ang pangolokolo tarin ong kalibotan, pamagadi-adi ong mga sinakepan nira. Ig ang mga alalawig ta katengdanan, agdegdegen nira tang mga tawan nira. ");
INSERT INTO agn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Piro indi amo magogali ta maning ta sia. Ang sinopa ong nindio tang galiliag ang mangolokolo, dapat magimong torobolon ong tanan. ");
INSERT INTO agn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ig ang galiliag ang magimong alawig, kaministiran magpababak ig magsirbi ong mga aroman na. ");
INSERT INTO agn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tenged maski yo, ang Ana ta Taw, indio napaning tarin para magpasirbio kondi para magsirbio ig i-dolo tang yen ang kaboi agod yading taw tang magawad ong mga kasalanan nira.” ");
INSERT INTO agn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Namana-loy si Jesus may ang mga sinagpan na ong siodad tang Jerico, ig asing pagalin nira don, dorong taw tang namansitabid ong nira. May nata-liban nirang tatang boray ang lolopa-pak ong binit tang dalan ang pagpalimos. Ang aran na si Bartimeo, ang ana ni Timeo. ");
INSERT INTO agn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Asing pagabasi nang si Jesus ang taga Nazaret tang tata-lib, dayon tanandiang miniteg ang ganing, “Jesus, Inampo ni David! Mate-beka ong yen!” ");
INSERT INTO agn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sinambleng tanandia tang mga taw ang magipes. Piro mas sinodoan na pa enged tang iteg na ang ganing, “Inampo ni David! Mate-beka ong yen!” ");
INSERT INTO agn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Siminareng si Jesus ig minaning ong mga taw, “Papaningen mi tani ong yen.” Ig ginoyan nira tang boray ang ganing, “Papoirsaen mo tang nem mo! Kendenga ra, aggoyana nandia!” ");
INSERT INTO agn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pagabasi lamang ta asi ni Bartimeo, pinlek nang lagi tang agkopoton na, limino-to pang kimindeng ig napalenget ong ni Jesus. Ganing si Jesus, ");
INSERT INTO agn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Onopa tang galiliagan mong boateno ong nio?” “Magino, galiliago rin ang maita!” tang sabat na. ");
INSERT INTO agn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ig ganing si Jesus ong nandia, “Ala, molika ra. Ang pagtalig mo tang nagpao-ya ong nio.” Ig lagi-lagi naita ra si Bartimeo. Oman dayon ang siminabid ong da Jesus ong pagpanaw nira. ");
INSERT INTO agn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Asing alenget da tanira ong Jerusalem, ig gingabot pa lamang ong mga bario tang Betfage may Betania, ong Bokid tang Kaoliboan, pina-kaw ni Jesus tang doroang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ganing tanandia ong nira, “Paning amo don ong dadaton ang bario. Ong pagteled mi, asia itaen ming lagi don tang tatang asnong agkeke-ked. Ang asnong asi mola pa, indi pa gatayan ta taw. Obaden mi ig e-lan mi tarin ong yen. ");
INSERT INTO agn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mga may mane-ma ong nindio ang angay aggobaden mi, aningen mi lamang, ‘Na kaministiran tang Gino. Mga matapos ipabalik na kang lagi tarin.’ ” ");
INSERT INTO agn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Animan namampanaw da tang doroang sinagpan na ig kinabotan ka kaman nira tang asno don ong binit tang dalan, ang agkeke-ked ong loa tang porta tang tatang balay. Asing aggobaden da nira, ");
INSERT INTO agn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","sine-ma tanira tang mga taw ang pamansi-deng don, “Hoy! Angay aggobaden mi sia?” ");
INSERT INTO agn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Siminabat tang doroa pario ka tang toyon ong nira ni Jesus. Animan pinabayan da lamang tanira tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ingkelan nira ong ni Jesus tang asno ig matapos ang dinamdaman nira tang boko-boko na tang mga ge-leb nirang lambong, siminay da si Jesus. ");
INSERT INTO agn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yadi kang mga taw ang namaglatag tang mga lambong nira ong dalan para panawan na. Ang doma, namamotol tang mga kapotan ta ayong marabong tang daon na oman linatag ka ong dalan bilang padengeg ong ni Jesus pario ta tatang adi. ");
INSERT INTO agn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ang mga taw ong tokawan ni Jesus asta ang mga taw ang pamansidaton ong nandia, sigi tang initeg nira ang ganing, “Hosanna! Dayawen tang kiminabot mandian ang sinobol tang Dios! ");
INSERT INTO agn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bindisionan tang Dios tang inadian tang yaten ang kamepet-mepetan ang si David ang boaten sing oman. Dayawen tang Dios ong kalawig-lawigan ang langit!” ");
INSERT INTO agn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pagakabot nira don ong Jerusalem, napaning si Jesus ong Timplo. Siminled ig naglibot ang nanelek-telek ong tanan ang mga bagay don. Oman limindoa tanandia ig tenged galabi ra, nagbalik da ong Betania, aroman na tang tampolok may doroang mga apostolis na. ");
INSERT INTO agn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagaramal, pagapagalin nira ong Betania pabalik si ong Jerusalem, linetem da si Jesus. ");
INSERT INTO agn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","May natorongan nang tang papang ayong igos ang dorog karabong. Animan pinaningan na ig sinelekan mga may borak nang poiding alapen. Piro andang pisan ay inita nang borak na, kondi poros lamang mga daon, tenged belag pa ta timpo na. ");
INSERT INTO agn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Animan minaning si Jesus ong ayong asi, “Mimpisa mandian, india ra enged mamorak!” Ig ang binitala nang na naba-yan tang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pagakabot nira ong Jerusalem, siminled sing oman si Jesus ong Timplo. Don ong teled tang solar may mga pamagpabakal ta mga ayep ang igsaragda ig mga pamamakal. Pinalayas na tanirang tanan ig pinampakalintoad na tang mga lamisan tang mamanigbailo ta koarta asta ang mga kalarongan tang mga pamagpabakal ta mga marapating igborolontad. ");
INSERT INTO agn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Binawal na ka ang toma-lib ong teled tang solar tang Timplo tang maski sinopay pagekel ta mga tinda. ");
INSERT INTO agn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pagatapos, nagtoldok tanandia ong mga taw don ang ganing, “Ga-tang ong Sagradong Kasolatan, ang balay tang Dios goyan ta logar ang parangadian para ong tanan ang mga nasion. Piro yamo, bindoat mi rang paragsimetan ta mga takawan!” ");
INSERT INTO agn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nabalitan tang mga manigtoldok tang Katobolan asta ang mga pangolokolo ong mga padi tang bindoat ni Jesus ong teled tang Timplo. Animan mimpisa don, pamagdilem da tanira ta midios agod mapapatay nira si Jesus, tenged aggeldan tanira ong nandia komo ang tanan ang mga taw agsinloan ta mo-ya ong mga agtotoldok na. ");
INSERT INTO agn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ig asing galikarem da, si Jesus may ang mga sinagpan na namansiloa si don ong siodad. ");
INSERT INTO agn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagaramal, asing pamagbalik si tanira ong siodad, nata-liban si nira tang papa tang ayong igos. Lanet da magalin ong daon na sa-sad ong lamot na. ");
INSERT INTO agn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nademdeman ni Pedro tang binitala ni Jesus ong ayo, animan minaning tanandia, “Magino, way! Pa-dekan mo tang ayong sinompa mo! Patay da!” ");
INSERT INTO agn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ganing si Jesus ong nira, “Magparet ig magtalig amo ong Dios. ");
INSERT INTO agn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ong kamatodan, mga magparet amo ang de-dek ong popotokon mi ang mainabo tang yaning mi, ig indi amo magdoadoa, poidi amo rang maning ong bokid ang asi, ‘Magalina atan ig loma-teda don ong talsi!’ ig sia boaten ka enged tang Dios para ong nindio. ");
INSERT INTO agn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Animan agganingo ong nindio, maski onopay agpa-dolon mi ong pagpangadi mi, magparet among narisibi mi ra si, ig sia marisibi mi ka enged. ");
INSERT INTO agn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ig mga pangadi amo, patawaden mi kang lagi tang maski sinopay galainan tang nem mi, agod ang mga talak mi patawaden ka tang Dios ang Tatay mi ong langit. ");
INSERT INTO agn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mga indi amo magpatawad tang masig ka taw mi, indi amo ka patawaden tang Tatay mi ong langit.” ");
INSERT INTO agn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pagakabot da Jesus ong Jerusalem, nagbalik si tanira ong Timplo. Mintras pagpanaw-panaw si Jesus don ong teled tang solar tang Timplo, pinalengetan tanandia tang mga pangolokolong padi may ang mga manigtoldok tang Katobolan, aroman ka nira tang mga mepet tang banoa. ");
INSERT INTO agn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ganing tanira ong ni Jesus, “Yaning mo ong yamen onopay podir mong magboat tang mga bagay ang na tarin ong Timplo. Sinopa tang nagtorol ong nio tang podir ang asia?” ");
INSERT INTO agn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ganing si Jesus ang siminabat, “Te-maen amo ka yen. Sabateno kang lagi nindio, ba-lo amo begen ta mga ong aripa nagalin tang podiro para magboat tang mga bagay ang na. ");
INSERT INTO agn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nani tang te-mao: Ong aypa nagalin tang podir ni Juan para magboniag? Ong Dios obin ong taw? Abir, sabateno nindio!” ");
INSERT INTO agn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Namagampang-ampang tanira mga onopay isabat nira. Ganing tanira, “Mga maning ita ‘nagalin ong Dios,’ maning ka tanandia ong yaten ‘Oman, angay indi amo namagparet ong ni Juan?’ ");
INSERT INTO agn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Piro mga maning ita ‘nagalin ong taw,’ monora bato?” Maning ta si tang isip nira tenged gengeldan tanira ang itaben onoray boaten tang mga taw ong nira, tenged si Juan aggilalaen tang mga taw ang matod ang propita. ");
INSERT INTO agn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Animan siminabat lamang tanira ang ganing, “Indi ami gatako.” Ig ganing si Jesus ong nira, “Mga maning don, indio ka magbeg ong nindio mga ong aripa pagalin tang yen ang podir ang magboat tang mga bagay ang na.” ");
INSERT INTO agn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nagpadayon ang nagistoria si Jesus ong nira ong mga palimbawa. Ganing tanandia, “May tatang taw ang nagloak ta mga obas ong tanek na, oman pinakodal na. Nagpaboat ta mabael ang boloat ong mabael ang bato ang boaten ang palagremekan tang mga obas. Nagpa-deng ka ta alawig ang balay-balay ang paragbantayan. Pagatapos, inintriga na tang kaobasan na ong mga agsador na, ba-lo tanandia nagbiahi ong alawid ang logar. ");
INSERT INTO agn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Asing timpo rang igparangalap, sinobol na tang tatang torobolon na para mangomit tang parti na. ");
INSERT INTO agn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Piro pagkabot don, binogbog tang mga agsador tang torobolon ang asi ig pinaolik nirang anday ekel na. ");
INSERT INTO agn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Oman nanobol si tang may nandia ong tata pang torobolon na. Piro ang torobolon ang na, pino-pok nira tang kolo na ig naigadan asta pinaeyak. ");
INSERT INTO agn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mandian, nanobol si tang may nandia tang tata pa enged ang torobolon na, piro na pinatay nira. Yadi pang mga torobolon ang sinobol tang may nandia, piro maning ka don tang bindoat tang mga agsador ong nira. Ang doma pinamalo, ang doma pinamatay. ");
INSERT INTO agn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Tang taw da lamang tang gabo-wan don ang poiding papaningen na ong mga agsador. Na ang ana na ra mismong agmalen na ta mo-ya. Ig asing ori ra, ya ray ang sinobol na tenged ganing tanandia ong sadili na, ‘Indi maimong indi galangen nira tang anao.’ ");
INSERT INTO agn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Piro asing itaen tang mga agsador tang ana nang gingabot da, ganing tanirang namagampang-ampang, ‘Asia ra tang manonobli! Patayen ta tanandia agod magimong yaten da tang kaobasan ang na.’ ");
INSERT INTO agn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ig dayon ang laging pinatay nira tanandia, ba-lo pinlek nira ong loa tang kaobasan. ");
INSERT INTO agn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Mandian,” ganing si Jesus, “onopa bato tang boaten tang may nandia tang kaobasan? Ang boaten na, molik tanandia ig pamatayen na ka tang mga agsador ang asi! Oman yintriga na si ong doma tang kaobasan na. ");
INSERT INTO agn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Onopa? Indi gabasa mi tang ga-tang ong Sagradong Kasolatan ang ganing, ‘Ang batong pinlek tang mga manigpa-deng tang balay, yay ang ginamit tang Dios ig nagimong kaimportantian ong tanan ang batong pagpabaked tang balay. ");
INSERT INTO agn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ang Dios tang nagboat ta na, ig makabebereng ang enged ong pama-dek ta!’ ” ");
INSERT INTO agn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Naintindian tang mga pangolokolong Judio ang tanira tang agpataman ni Jesus ong palimbawang asi. Animan gangaliliag da rin ang depen nira, piro gengeldan ong mga taw. Animan pinabayan da lamang nira si Jesus ig namagalin da. ");
INSERT INTO agn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Oman, may mga Pariseo ig mga tawan ni Herodes ang sinobol don ong ni Jesus para depdepen nira tanandia ong mga pamitala na. ");
INSERT INTO agn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pagakabot nira don, ganing tanira, “Maistro, gata-wanan amen yawa india pagbo-li, ig pario tang pagpama-dek mo ong tanan. India pagpaekel-ekel ong kaliagan ta taw maski sinopa tanira, kondi agtotoldok mo lamang tang kamatodan natetenged ong kaliliagan tang Dios ang boaten tang mga taw. Animan mga ong nio, sigon ong Katobolan ta, tama ka bato ang itang mga Judio magbayad ta bois ong Adi tang Roma? Dapat ang magbayad ita obin indi?” ");
INSERT INTO agn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Piro gata-wanan ni Jesus nga ang te-ma nirang asi belag ta matod ang te-ma. Animan ganing ong nira, “Angay agsobokano nindiong depdepen ong te-ma ming asia? Abir, ipaita mi ong yen tang tanga koartan, telekano.” ");
INSERT INTO agn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ig dinawatan ka nira. “Ninopang itsora na ig ninopang aran tang nasolat tarin?” tang te-ma ni Jesus. “Ang Adi tang Roma,” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ig ganing si Jesus, “Mga maning don, i-dol mi ong adi tang para ong adi, ig i-dol mi ong Dios tang para ong Dios.” Pagabasi nira ta si, pisan tanirang nangabereng ong nandia. ");
INSERT INTO agn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Oman may atan kang mga Saduseo ang namampaning ong ni Jesus para mane-ma. Tanira tatang sikta tang mga Judio ang indi pamagparet ang maboing moman tang mga patay. ");
INSERT INTO agn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ganing tanira ong ni Jesus, “Maistro, may tobol ang sinolat ni Moises para ong yaten ang ganing, mga mapatay tang lali ang anday ana nira tang katawa na, ang logod tang lali dapat katawaen na tang babay ang asing nabalo, agod magkatinir tanira ta ana para ong laling napatay. ");
INSERT INTO agn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mandian, may pitong mamaglogod ang poros lali. Nangatawa tang kakan ig napatay ang anday ana nira. ");
INSERT INTO agn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Oman ang yadoang logod nangatawa ong babay ang nabalo, piro napatay si kang anday ana nira. Maning ka ta si tang nainabo ong ya-lo, sa-sad ong yapito. ");
INSERT INTO agn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ang pitong mamaglogod, napangatawa ong babay ig poros nangapatay ang anday ana nira. Asing ori ra, ang babay napatay ka. ");
INSERT INTO agn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mandian, ong oring kaldaw, mga boien ang moman tang mga patay, sinopa ong nirang pito tang magimo sing katawa tang babay? Tenged tanirang tanan nagimong katawa na.” ");
INSERT INTO agn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ganing si Jesus ang siminabat, “Doro amo ka kamali! Gata-wanan mi mga angay? Tenged indi amo gangaintindi tang ga-tang ong Sagradong Kasolatan. Ig indi amo ka gangaintindi mga monopag kamakagagaem tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tenged ong kaldaw ang boien ang moman tang mga patay, indi ra tanira mamagkaratawan tenged pario ra tanira ong mga anghil ong langit. ");
INSERT INTO agn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ig mga natetenged ka ong pagboing oman ong mga patay, midio indi enged gabasa mi ong libro ni Moises tang istoriang natetenged ong dibabak ang papa ta ayo. Maning ta na tang inaning tang Dios ong ni Moises ang sinolat na: ‘Yo tang Dios ni Abraham, ni Isaac, ig ni Jacob.’ ");
INSERT INTO agn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Piro ang Dios, belag ta Dios tang mga patay. Tanandia Dios tang mga boi. Animan mali enged tang aggisipen ming indi moman ang maboi tang mga patay!” ");
INSERT INTO agn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","May don kang tatang manigtoldok tang Katobolan ni Moises ang naba-yan na si Jesus may ang mga Saduseo ang pamagdiskosionan. Napanaidan nang maosay si Jesus ong pagsarabaten na ong nira, animan napalenget ong ni Jesus ig nane-ma, “Ong tanan ang Katobolan, aypa tang kaimportantian?” ");
INSERT INTO agn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ganing si Jesus ang siminabat, “Na tang kaimportantian ong tanan ang tobol ang sinolat ni Moises: ‘Pama-yan mi, yamong mga inampo ni Israel! Ang Ampoan tang Dios, tanandia lamang tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Animan gegman mo tang Ampoan mong Dios ang de-dek ong popotokon mo, bogos ong nem mo, bogos ong kinaisipan mo, ig bogos ong poirsa mo.’ ");
INSERT INTO agn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ang yadoang kaimportantian ang tobol ay na: ‘Gegman mo tang masig ka taw mo pario tang paggegma mo ong sadili mo.’ Anda ray domang tobol ang mas importanti pa ong doroang na.” ");
INSERT INTO agn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ganing tang manigtoldok tang Katobolan, “Tama tang sabat mo, Maistro. Matod kaman tang inaning mong tambilog lamang tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ig dapat kaman ang gegman ta tanandia ang de-dek ong popotokon ta, bogos ong kinaisipan ta, ig bogos ong poirsa ta. Ig gegman ta ka tang masig ka taw ta pario tang paggegma ta ong sadili ta. Mas importanti pa nganing magtoman ita ong doroang tobol ang na kaysa magtorol ita ta mga ayep ang sirokon ong altar bilang sagda ong Dios, may ang doma pang klasi ta bolontad.” ");
INSERT INTO agn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Napanaidan ni Jesus ang maosay tang sabat tang manigtoldok ang asi, animan ganing tanandia, “Alengeta rang mabilang ong inadian tang Dios.” Ig mimpisa don, anda ray mangas ang mane-ma pa ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mintras pagtoldok si Jesus ong Timplo, ganing tanandiang nane-ma, “Monopa maning tang mga manigtoldok tang Katobolan nga ang Cristo Inampo ni Ading David? ");
INSERT INTO agn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Si David mismo tang naganing ta na, asing ginaeman tang Ispirito Santo: ‘Ganing tang Ginong Dios ong yen ang Gino: Komaronga ong yen ang to, asta ra lamang pasokono ong nio tang tanan ang kasoay mo.’ ");
INSERT INTO agn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mandian, mga ‘Gino’ tang ginoy ni David ong Cristo, monopa tanandia nagimong inampo ni David?” Dorong mga taw don ig pisan ang gambengan tanirang pamamasi ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ganing pa si Jesus ong pagtoldok na ong nira, “Magandam amo ong mga manigtoldok tang Katobolan ni Moises. Dorong kalipay nirang magpanaw-panaw ang paglambong ta marimaboat. Ig doro kang kaliliag nirang salodoan tang mga taw ong plasa. ");
INSERT INTO agn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mga ong simban ig ong mga kombida, ang kaliliagan nira, komarong ong masisinlong kalarongan ang para ong mga importanting taw. ");
INSERT INTO agn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Agkalawen nira tang mga pagkabetang tang mga babay ang balo, asta ang balay nira. Oman pamagpaita-ita ang tanira moro-ya ong pagpangadi nira ta dorog kaboat ong talongan tang mga taw. Animan magimong mas mabelat pa tang silot ong nira!” ");
INSERT INTO agn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Asing don pa si Jesus ong Timplo, kiminarong tanandia ong toga tang mga beretangan ang agbo-logan ta koarta. Agpanaidan na tang mga taw ang pamagbo-log tang mga bolontad nira. Yading mga manggaden ang pamagbo-log ta doro-dorong koarta. ");
INSERT INTO agn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Maboay-boay ta ge-ley, may siminled ang tatang babay ang balo ang dorog kalised, ig nagbolontad ta doroang sinsilio bali tang piso. ");
INSERT INTO agn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Oman ginoyan ni Jesus tang mga sinagpan na ig minaning ong nira, “Ong kamatodan, ang babay ang asia tang nagbolontad ta mas mabael pa ong nirang tanan. ");
INSERT INTO agn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tenged tanira, ang sindol nira ang gasobra ra lamang ong kaministiran nira. Piro ang balong na, maski malised lamang, sindol na pa tang tanan ang para ong pangaboian na.” ");
INSERT INTO agn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Asing loloa ra da Jesus ong Timplo, ganing ong nandia tang tata ong mga sinagpan na, “Maistro, way, pa-dekan mo! Kababael tang mga batong ginamit ong Timplo ig kasisinlong pa-dekan, asta ang domang mga pina-deng atan.” ");
INSERT INTO agn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ganing si Jesus ong nira, “Gitaen ta ka kaman tang Timplo ang nang dorog kabael. Piro komabot tang kaldaw ang anda enged ay mabo-wan ong mga batong pamagtara-paw ta-pawan ang asia. Mangapegnak ang tanan!” ");
INSERT INTO agn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mintras kakarong don si Jesus ong Bokid tang Kaoliboan ang tatalonga ong Timplo, namampalenget ong nandia da Pedro, Santiago, Juan may si Andres. Namane-ma tanira ang anday gabasi. ");
INSERT INTO agn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ganing tanira, “Tanopa mainabo tang inaning mong mapegnak tang Timplo, ig onopay mga pasinial mga alenget dang mainabo tang mga bagay ang asia?” ");
INSERT INTO agn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Siminabat si Jesus ang ganing, “Magandam amo agod indi amo maloko ta maski sinopa. ");
INSERT INTO agn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tenged yading mamansikabot ang magekel tang arano, ig kada tata magpailala ang tanira ono tang Cristo. Ig dorong maloko nira. ");
INSERT INTO agn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Animan indi amo mangelba mga mabasi amo ta pamaggiran ong alenget, ig mga mabalita amo kang may gira ono ong domang banoa. Ang mga bagay ang na kaministiran ang mainabo ka enged, piro belag pa ta sia tang kataposan tang kalibotan. ");
INSERT INTO agn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mamaggiran tang mga nasion ig mamagkorontran tang mga inadian. Manlinog ong sari-saring mga logar ig magkatinir ta grabing letem. Piro ang tanan ang narin, impisa pa lamang tang kaliwagan ang komabot, pario ong tatang babay ang palanganaen ang ba-lo pa lamang pagpasit. ");
INSERT INTO agn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Animan andaman mi tang sadili mi, tenged depen amo ig e-lan ong korti, oman patakan amo tang palo ong pagsirimetan tang mga Judio. Ig natetenged ka ong pagto mi ong yen, patalongaen amo ka nira ong mga gobirnador ig ong mga adi. Ig don ya ray ang oras ang mapagpamatod amo ong nira tang natetenged ong yen. ");
INSERT INTO agn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tenged ba-lo komabot tang kataposan tang kalibotan, ang Mo-yang Balita kaministiran mapatako ong tanan ang mga nasion. ");
INSERT INTO agn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mga depen amo ra ngani ig patalongaen amo ra ong mga osgado, indi amo magpalibeg tang mga kolo mi mga onopay isabat mi. Tenged ong oras ang asi, oldan amo tang isabat mi. Tenged ang ibitala mi indi magalin ong sadiling isip mi. Sia magalin ong Ispirito tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ong mga kaldaw ang asi, ang mga taw traidoron nira tang maski sadiling logod nira ig yintriga ong osgado para ipapatay. Ig ya kay boaten tang mga tatay ong mga ana nira, asta ang mga ana batokan ka nira tang mga ginikanan nira ig ipapatay. ");
INSERT INTO agn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ig yamo, asilagan amo tang tanan tenged ong pagto mi ong yen. Piro ang magagoanta ig magpadayon ang magtoman ong yen asta matapos tang tanan ang kaliwagan, tanandia yay ang malibri.” ");
INSERT INTO agn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ganing pa si Jesus, “Komabot tang kaldaw ang itaen mi tang aggoyan ta Maniglangga ang Sobrang Manginsolto ong Dios ang ke-deng da ong logar ang belag ta dapat ang don tanandia. (Yamong mga pamagbasa, intindien mi ta mo-ya tang maliag yaning ta na.) Mga itaen mi ra sia, ang mga taw ang pamansistar tarin ong Judea, kaministiran ang mamanikad dang lagi ong kabobokidan. ");
INSERT INTO agn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ang taw ang don ong loa tang balay na, dapat indi ra tenled ong balay na para mangomit ta ekelan na. ");
INSERT INTO agn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ya ka mga may taw don ong bokid, dapat indi ra ka molik para mangomit tang takol na. ");
INSERT INTO agn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ong mga kaldaw ang asi, kailo ka tang pamagabdet asta ang mga pamagpatiti! ");
INSERT INTO agn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Magampo amo ong Dios ang balampa indi māton ong timpong malamig tang mga bagay ang na. ");
INSERT INTO agn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tenged ong mga kaldaw ang asi, ang mga taw mapasar ta sobrang kaliwagan. Mimpisa asing bindoat tang Dios tang kalibotan, anda pang pisan ay nainabo ang pario ong kaliwagan ang na. Ig anda ra kay mainabo pang pario ta sia asta tanopa. ");
INSERT INTO agn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ong matod, mga indi rin padipoton tang Dios tang timpong asi ta kaliwagan, anda enged ay mabo-wan maski tanga tawan. Piro tenged ong mabael ang kate-bek na ong mga taw ang pinilik na, padipoton tang Dios tang timpong asi. ");
INSERT INTO agn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ong mga kaldaw ang asi, mga may maganing ong nindio ang, ‘Asia ra tang Cristo!’ obin may maning, ‘Way, asia ka!’ indi amo magparet. ");
INSERT INTO agn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tenged may mamansiloa atan ang mga taw ang maganing tanira ono tang Cristo, ig may atan kang maganing tanira ono propita ang sinobol tang Dios. Magpaita tanira ta mga milagro ig makabebereng ang mga bagay ong kaliliagan nirang maloko tang mga taw, mga poidi lamang asta ang mga pinilik tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Animan tandan mi na! Agbebego rang lagi tang mga bagay ang na mintras indi pa gainabo.” ");
INSERT INTO agn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ganing pa si Jesus, “Matapos lamang tang sobrang kaliwagan ong timpong asi, mangi-lep tang kaldaw ig ang bolan indi ra mangayag. ");
INSERT INTO agn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mangabo-log tang mga bitokon ig pakedegen tang tanan ang aggitaen ong langit. ");
INSERT INTO agn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ig yo, ang Ana ta Taw, itaeno ang tatabid ong mga onom ang pabalik ong kalibotan, ang pagekelo tang makabebereng ang gaem ig kadengegan. ");
INSERT INTO agn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Oman tobolono ra tang yen ang mga anghil ang magsimet da tang tanan ang taw ang piniliko, magalin ong tanan ang parti tang kalibotan.” ");
INSERT INTO agn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Intindien mi tang adal ang nagalin ong papa tang igos: Mga itaen mi ra ngani narin ang pangolbot da, gata-wanan ming alenget da tang koarisma. ");
INSERT INTO agn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pario ka ta si, mga itaen mi ra nganing gainabo ra tang mga bagay ang inaningo ra ong nindio, mata-wanan ming indi ra maboay, komabot da tang timpong asi ig madalio rang magbalik. ");
INSERT INTO agn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tandan mi: May doma ong mga taw ang gangaboi mandian ang kabotan pa nira tang tanan ang mga bagay ang nang mainabo. ");
INSERT INTO agn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Malipat tang langit may ang tanek, piro ang yen ang mga bitala magpadayon ang anday kataposan.” ");
INSERT INTO agn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Piro anday taw ang gatako mga tanopa komabot tang kaldaw ang asi obin oras. Maski ang mga anghil ong langit, maski yo, ang Ana mismo tang Dios, indio ka gatako. Ang Dios ang Tatay lamang tang gatako ta sia. ");
INSERT INTO agn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Animan magimong listo amo ig pirming simpan, tenged indi amo gatako mga tanopa komabot tang oras ang asi. ");
INSERT INTO agn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ang kalimbawan ta na pario ka asing nagbiahi tang tatang taw ong alawid ang logar. Ba-lo tanandia nagalin, inintriga na tang balay na ong mga torobolon na, ig kada tata ong nira sindolan na ta sadiling orobraen na. Ig ang manigbantay ong porta inordinan na kang pirming listo ong pagbalik na. ");
INSERT INTO agn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Animan kaministiran maning amo ka ta sia. Magbantay among pirmi, tenged indi amo gatako mga tanopa magbalik tang Gino mi. Itaben komabot tanandia ong alikarem, obin ong tenganan, ong garamal, obin ong damal-damal. ");
INSERT INTO agn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ig mga golpi tanandiang komabot, dapat indi amo kabotan na ang gapoyat. ");
INSERT INTO agn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ang agganingo ong nindio, agganingo ong tanan: Magimong listo among pirmi!” ");
INSERT INTO agn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Doroa ra lamang kaldaw, Pista ra tang Pagta-lib tang Anghil may ang Pista tang Tinapay ang Anday Pampalsa na. Ang mga pangolokolo ong mga padi may ang mga manigtoldok tang Katobolan, pamagisip ta midios para madep nira si Jesus ong talok, oman ipapatay. ");
INSERT INTO agn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ganing tanira, “Indi itōn ta ong kasagsagan tang pista, itaben magkagolo tang mga taw.” ");
INSERT INTO agn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mandian, asing don si Jesus ong bario tang Betania ang pamangan ong balay ni Simon ang dating liproso, may tatang babay ang kiminabot. May aggekelan nang tereldan ang boat ong batong midio marmol. Ang teled na ay pabanglo ang dorog kamal ang aggoyan ta nardo ig andang pisan ay sampora na. Pintek tang babay tang likel tang tereldan ig bino-bok na tang pabanglo ong kolo ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Asing itaen tang domang mga taw don, pinangerepan tanira ig namagmoro-moro ang ganing, “Aroy! Arangan da tang pabanglong asia! ");
INSERT INTO agn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mga pinabakal pa sia, ang bayad na sobra pa rin ong sol ta tang taw ong teled ta magpatakon, ig sia malimos pa rin ong mga malilised.” Oman binasol nira tang babay. ");
INSERT INTO agn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Piro ganing si Jesus ong nira, “Angay pagpalabet amo ong babay ang na? Pabayan mi lamang. Ang bindoat nang na ong yen dorog kasinlo. ");
INSERT INTO agn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ang mga malilised pirming ka-pen mi ig poidi pang matabangan mi. Piro yo, indio ra maka-pen mi ong maboay ang timpo. ");
INSERT INTO agn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ang babay ang na bindoat na tang kasinloan ang nasarangan na. Anda pa ngani, bino-bokano ra nandia ta pabanglo agod magimong simpan da tang sinangonio mga ilbengo ra. ");
INSERT INTO agn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Agganingo ong nindio, maski ong aripa ipatako tang Mo-yang Balita tarin ong bilog ang kalibotan, ang bindoat tang babay ang na ong yen magapil ka enged bilang pagdemdem ong nandia.” ");
INSERT INTO agn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pagatapos ta si, si Judas Iscariote, ang tata ong tampolok may doroang apostolis ni Jesus, napaning ong mga pangolokolo ong mga padi para magprisintar ang traidoron na si Jesus ig yintriga na ong nira. ");
INSERT INTO agn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pagabasi tang mga padi ong plano ni Judas, nangalipay tanira ta mo-ya ig nangako ang oldan nira ta koarta. Animan nagimpisa ra tanandiang nagelat ta tamang oras para maintriga na si Jesus ong nira. ");
INSERT INTO agn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kiminabot da tang primirong kaldaw tang Pista tang Tinapay ang Anday Pampalsa na, kaldaw ang pagpatay ta mga karniro para ong Pista tang Pagta-lib tang Anghil. Animan nane-ma ong ni Jesus tang mga sinagpan na ang ganing, “Ong ari ami pa magsimpan ta yapon ta para ong pista?” ");
INSERT INTO agn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Oman sinobol ni Jesus tang doroa ong mga sinagpan na ig ganing ong nira, “Paning amo don ong lansangan. Don may mabagat ming tatang laling pagtakan ta tatang bangang may wi na. Datonon mi tanandia, ");
INSERT INTO agn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ig don ong balay ang teldan na, aningen mi tang may nandia tang balay, ‘Pagpate-ma tang Maistro mga aripa tang koartong panaponan na mandian ang pista, aroman na tang mga sinagpan na.’ ");
INSERT INTO agn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Asia itoldok na ong nindio tang tatang marogal ang koarto ong dibabaw ang may mga garamiten dang lagi don. Don amo magsimpan.” ");
INSERT INTO agn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Animan napanaw da tang doroang sinagpan nang napaning ong lansangan, ig ang onopay inaning ni Jesus ya kay ang kinabotan nira. Ig nagsimpan tanira tang panapon nira para ong pista. ");
INSERT INTO agn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Alikarem dang napaning don si Jesus, aroman na tang tampolok may doroang apostolis na. ");
INSERT INTO agn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mintras pamamangan tanira, ganing si Jesus ong nira, “Begen amo yen tang kamatodan, yo, traidorono tang tata ong nindio tarin ang ka-peno mandian ang pamangan.” ");
INSERT INTO agn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pagabasi ta si tang mga sinagpan na, namagsinti tanira ig nane-ma tang kada tata ong ni Jesus ang ganing, “Gino, yo ra bato?” ");
INSERT INTO agn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ganing si Jesus ong nira, “Agganingo, tata ong nindiong tampolok may doroa, ang yen ang kasaro ang pagte-me ta tinapay ong mangkok ang na, yay ang magtraidor ong yen. ");
INSERT INTO agn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yo, ang Ana ta Taw, mapatay sigon ong na-tang dang lagi ong Sagradong Kasolatan. Piro kailo ka tang taw ang magtraidor ong yen! Mas mo-ya pa ong nandia, indi ra lamang nataw.” ");
INSERT INTO agn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mintras pamamangan pa tanira, namisik si Jesus ta tinapay ig binindisionan na. Oman pinisi-pisi na ig sindol na ong mga sinagpan na ang ganing, “Risibien mi narin. Na tang yen ang sinangoni.” ");
INSERT INTO agn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pagatapos, bindiotan na tang tatang kopang bino ig nagpasalamat ong Dios. Oman sindol na ong nira ig namansinem tanirang tanan. ");
INSERT INTO agn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ganing si Jesus ong nira, “Na tang dogo tang ba-long inigoan ang agboaten tang Dios para ong mga taw. Ang yen ang dogong na mailat agod yading mapatawad ong mga kasalanan nira. ");
INSERT INTO agn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Agganingo ong nindio, indio ra moman ang manginem ta binong maning ta na ang pagalin ong obas, asta indi komabot tang kaldaw ang manginemo si tang ba-long bino ong inadian tang Dios.” ");
INSERT INTO agn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pagabitala ni Jesus ta si, namagkanta tanira ta tatang kantang pagdayaw ong Dios, ba-lo tanira namansipaning ong Bokid tang Kaoliboan. ");
INSERT INTO agn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ganing si Jesus ong mga sinagpan na, “Ong matod, bo-wanano nindiong tanan, tenged na-tang dang lagi ong Kasolatan, ‘Ipagna tang Dios ang patayen tang manigbadbad, ig ang mga karniro mamagwasag.’ ");
INSERT INTO agn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Piro matapos ang boieno rang moman tang Dios, tongkawo ong nindio don ong Galilea.” ");
INSERT INTO agn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ganing si Pedro ong ni Jesus, “Bo-wanana pa nirang tanan, piro india ka enged bo-wanan ta!” ");
INSERT INTO agn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Siminabat si Jesus, “Tandan mo na, Pedro: Ba-lo tomolok tang mano ta madoa mandian ang garamal, ma-long bisisang magbo-li ang maning india gailala ong yen.” ");
INSERT INTO agn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piro ganing si Pedro ang nagpareges, “Maski patayeno pang aroman mo, indio ka enged maning ang india gailala ta!” Ig ya kay ang inaning tang tanan ang mga sinagpan ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Oman namansipaning tanira ong logar ang aggoyan ta Getsemani. Pagakabot don, ganing si Jesus ong mga sinagpan na, “Atan amo kay lagi komarong mintras pangadio don ong tokawan.” ");
INSERT INTO agn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Piro pinatabid na si Pedro, si Santiago may si Juan. Naborido ra tang isip na ig dorog kabelat tang nem na tenged ong agtalongaen na. ");
INSERT INTO agn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ganing si Jesus ong tolo, “Midio mapatayo ra ong sobrang sintio! Atan amo lamang ig magpolaw amo.” ");
INSERT INTO agn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pagatokaw-tokawan na ta ge-ley, diminagpa tanandia ig nagampo ong Dios mga maimo, indi ra komabot ong nandia tang kaliwagan ang agtalongaen na. ");
INSERT INTO agn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ganing tanandia, “Tatay, Tatayo! Gata-wananong andang pisan ay bagay ang indi maboat mo. Animan mga maimo lamang, indio ra papasaren mo ong kaliwagan ang na. Piro belag tang yen ang kaliagan tang dapat ang matoman, kondi ang kaliagan mo.” ");
INSERT INTO agn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pagabalik na don ong tolong mga sinagpan na, kinabotan na tanirang gangapoyat. Ganing tanandia ong ni Pedro, “Simon, yawa pala gapoyata? Onora ka? India ka enged mapagpapoyat, maski tang oras lamang? ");
INSERT INTO agn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Indi amo mapoyat. Mangadi amo agod indi amo madeg ta tokso. Galiliag amo ka rin ang magboat ta mo-ya, piro agdegen amo tang sinangoni ming malolobay.” ");
INSERT INTO agn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Napalawid sing oman si Jesus ig nangadi si. Ang pinangadi na pario si ka tang primiro. ");
INSERT INTO agn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pagabalik na don ong tolo, kinabotan na sing gangapoyat tenged pisan dang agkapoyon ta poyat. Ig indi ra mangatako mga onopay isabat nira ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ong ya-long pagbalik na, ganing tanandia ong nira, “Gangapoyat amo pa ka enged? Telekan mi! Kiminabot da tang oras ang yo, ang Ana ta Taw, yintriga ra ong kalima tang mga taw ang mapinagtalaken. ");
INSERT INTO agn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Maytara! Asia ra tang taw ang magtraidor ong yen!” ");
INSERT INTO agn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Asing bibitala pa si Jesus, kiminabot da kaman si Judas, ang tata ong mga tampolok may doroang apostolis na. Tang paneng tang aroman nang mga taw ang pamagekel ta mga ispada may pamalo. Ang mga taw ang asi sinobol tang mga pangolokolong mga padi, ang mga manigtoldok tang Katobolan ig mga mepet tang banoa. ");
INSERT INTO agn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Minaning dang lagi ong nira tang traidor ang si Judas tang onopay sinial na. Ang inaning na, “Ang taw ang itongano ya ray sia. Depen ming lagi ig ekelan, piro bantayan mi ta mo-ya.” ");
INSERT INTO agn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Animan mandian, napalenget ang lagi si Judas ong ni Jesus ig minaning, “Maistro!” Oman dayon ang initongan na. ");
INSERT INTO agn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pinalengetan ang lagi si Jesus tang mga taw ig dinep nira. ");
INSERT INTO agn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Piro tata ong mga pamansi-deng don nagbonlok tang ispada na ig dayon ang tinagpas na tang kirepen tang kalawigan ang padi. Nalampong tang talinga na. ");
INSERT INTO agn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Oman ganing si Jesus ong dorong taw don, “Angay? Yo, kriminalo ang pamagekel amo ta mga ispada may pamalo para depeno? ");
INSERT INTO agn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kaldaw-kaldaw pagtoldoko ong Timplo ig don amo ka, piro angay indiong lagi dinep mi? Piro ang tanan ang narin kaministiran ang mainabo agod magmatod tang ga-tang ong Sagradong Kasolatan natetenged ong yen.” ");
INSERT INTO agn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pagabitala na lamang ta si, bino-wanan si Jesus tang mga sinagpan na ig namansilayas tanirang tanan. ");
INSERT INTO agn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","May tatang soltiros don ang dadaton-daton ang lagi ong ni Jesus. Pangampit lamang ta abel ig ya lamang tang dapa ong sinangoni na. Agdepen da ka rin tanandia tang mga taw, ");
INSERT INTO agn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","piro napo-lot tenged ang abel ang aggampiten na yay ang nawidan nira. Animan naglayas lamang ang anday ameng-ameng na. ");
INSERT INTO agn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pagatapos ta si, ingkelan nira si Jesus ong palasio tang kalawigan ang padi tang mga Judio. Don ka pamagsimet tang tanan ang pangolokolo ong mga padi, asta ang mga mepet tang banoa ig ang mga manigtoldok tang Katobolan. ");
INSERT INTO agn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Si Pedro pala dadaton ong nira, piro don lamang ong alawid-lawid, asta na-led ong kodal tang palasio tang kalawigan ang padi. Don minimbeng tanandia ong mga goardia ang kakarong ig pamagpakinit-kinit ong apoy. ");
INSERT INTO agn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mandian, ang mga pangolokolo ong mga padi ig ang tanan ang mga opisialis tang banoa, pamagdilem ta ibidinsia kontra ong ni Jesus agod masintinsian nira ta kamatayen. Piro andang pisan ay inita nira, ");
INSERT INTO agn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","tenged maski dorong namagtistigo ta kabo-lian kontra ong ni Jesus, indi namagpararioan tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Oman may doma pang mga taw ang namansitalonga ig namagtistigo ka ta kabo-lian kontra ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ganing tanira, “Yami mismo, nabasi ami ang ganing tanandia gebaen na ono tang Timplong narin ang bindoat ta taw, ig ong teled ono ta tolong kaldaw magpa-deng si tanandia ta Timplo ang belag ta taw tang magboat.” ");
INSERT INTO agn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Piro indi pa ka enged namagpararioan tang pamatod tang mga taw ang asi. ");
INSERT INTO agn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Animan kimindeng tang kalawigan ang padi ong talongan tang tanan ig nane-ma ong ni Jesus, “Angay india sasabat? Onopay maning mo ong mga riklamo nirang na kontra ong nio?” ");
INSERT INTO agn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Piro inding pisan minibek-ibek si Jesus, nagipes lamang tanandia. Animan sine-ma si tanandia tang kalawigan ang padi ang ganing, “Onopa? Yawa ra tang Cristo, ang Ana tang Dalayawen ang Dios?” ");
INSERT INTO agn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ganing si Jesus, “Ee, yo ka kaman. Ig itaeno nindio, yo, ang Ana ta Taw, ang kakarong gampir ong to tang Makagagaem. Ig itaeno ka nindio ang tatabid ong mga onom ang pagbalik tarin ong kalibotan.” ");
INSERT INTO agn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pagabasi ta si tang kalawigan ang padi, linasik na tang lambong na ong sobrang kasisilagen na ig minaning, “Anda ray kaministiran ta mga tistigos! ");
INSERT INTO agn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Naba-yan mi ra mismo tang inaning na! Pangambong tanandia tang Dios! Dorog kabelat tang kasalanan ang na! Mandian, onopay lalang mi?” Tanirang tanan parario tang sabat nira ang dapat ono ong nandia patayen. ");
INSERT INTO agn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ig ang doma ong nira inolakan nira si Jesus, oman pinedengan nira ig pinatakan tang sontok. Ganing tanira ong nandia, “Abir, pinton mo mga sinopay panontok ong nio!” Ig sinalalabangan pa tanandiang sinampaling tang mga goardia. ");
INSERT INTO agn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mandian, asing don pa si Pedro ong babakan, ong ge-ley ang plasa, simina-lib tang tatang babay ang torobolon tang kalawigan ang padi. ");
INSERT INTO agn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pagaita tang babay ong ni Pedro ang pagpakinit-kinit ong apoy, pinanengnengan na ta mo-ya ig minaning, “Yawa, aromana ka tang Jesus ang asing taga Nazaret!” ");
INSERT INTO agn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piro nagbo-li si Pedro. Ganing tanandia, “Way inayo— indio gatako mga onopay agbibitala mo!” Oman napalawid-lawid tanandia don ong may portan tang kodal. Ig golping timinolok tang mano. ");
INSERT INTO agn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Indi naboay, inita si tanandia tang babay ang torobolon ig ganing ong mga taw ang pamansi-deng don, “Ang taw bayang na tata ong mga aroman ni Jesus!” ");
INSERT INTO agn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piro nagbo-li si si Pedro. Maboay-boay ta ge-ley, ganing ka ong ni Pedro tang mga taw ang asing ke-deng don, “Yawa tata kaman ong mga aroman na, yawa taga Galileā ka!” ");
INSERT INTO agn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piro siminabat si Pedro, “Sompano pa! Maski doldolano pa! Indio baya gailala ong taw ang asing agganingen mi!” ");
INSERT INTO agn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ig ya ray ang pagtolok tang mano ang yadoang bisis. Oman nademdeman da ni Pedro tang inaning ni Jesus ong nandia ang ganing, “Ba-lo tomolok tang mano ta madoa, ma-long bisisang maning ang india gailala ong yen.” Ig indi nawidan ni Pedro tang sadili na ig dorong i-yak na. ");
INSERT INTO agn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pagaramal, māga pang pisan namagbaragat-bagat ang lagi tang mga pangolokolong padi, ang mga mepet tang banoa, ang mga manigtoldok tang Katobolan, may ang tanan ang opisialis tang mga Judio para mamagboat tang plano nira. Oman dayon dang linapot nira si Jesus ig ingkelan ong ni Pilato, ang gobirnador, ig inintriga nira don ong nandia. ");
INSERT INTO agn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sine-ma ni Pilato si Jesus ang ganing, “Onopa? Matod ang yawa tang adi tang mga Judio?” Siminabat si Jesus, “Yawa ra ka tang naganing.” ");
INSERT INTO agn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yading mga riklamo ang pinrisintar tang mga pangolokolong padi kontra ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Animan ganing si Pilato ong nandia, “Ta, naba-yan mo ra tang yading riklamo nira kontra ong nio. Mandian, onopay masabat mo atan?” ");
INSERT INTO agn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Piro inding pisan minibek-ibek si Jesus, animan nabereng ta mo-ya si Pilato. ");
INSERT INTO agn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kada Pista tang Pagta-lib tang Anghil, nakaogalian da ni Pilato ang pagpalpat ta tatang priso, mga sinopay pa-dolon ong nandia tang mga taw. ");
INSERT INTO agn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nāton ong takon ang asi ang may mga agprison ang mga ribildi ang namamatay ta mga taw asing namaggolo ong Jerusalem. Ang tata ong nira, ang aran na si Barabbas. ");
INSERT INTO agn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Animan mandian, dorong mga taw ang pamagsimet da don ong ni Pilato ig pamama-dol ang palpatan na ra tang tatang priso, kompormi ong agboaten na kada takon. ");
INSERT INTO agn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nane-ma si Pilato ong nira, “Galiliag among palpatano para ong nindio tang adi tang mga Judio?” ");
INSERT INTO agn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Maning don tang te-ma ni Pilato tenged gata-wanan nang gangaibeg lamang ong ni Jesus tang mga pangolokolong padi, ig yay sia animan ingkelan nira si Jesus ong nandia. ");
INSERT INTO agn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Piro ang bindoat tang mga pangolokolong padi, sinolsolan nira tang mga taw ang si Barabbas tang pa-dolon nirang palpatan, belag ta si Jesus. ");
INSERT INTO agn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Animan nane-ma sing oman si Pilato ong mga taw, “Mga maning don, onopay boateno ong taw ang na, ang aggoyan ming adi tang mga Judio?” ");
INSERT INTO agn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Namansisabat tanirang pamaginiteg, “Ilansang ong kros!” ");
INSERT INTO agn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ganing si Pilato, “Angay? Onopay bindoat nang malain?” Mas sinodoan pa tang mga taw tang iteg nira, “Basta ilansang ong kros!” ");
INSERT INTO agn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Animan tenged galiliag si Pilato ang malipay tang mga taw, pinalpatan na si Barabbas. Piro si Jesus pinalatigo na, ig pagatapos inintriga na ong mga sondalo na para ilansang ong kros. ");
INSERT INTO agn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ingkelan si Jesus tang mga sondalo ong palasio tang gobirnador, ang aggoyan ang pritorio. Don namagsimet ong palibot na tang tang batalion ang mga sondalo. ");
INSERT INTO agn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pinatokan nira si Jesus ta kapang granati bilang intirimis. Namagboat tanira ta korona-koronang poros tenek oman bintang nira ong kolo na. ");
INSERT INTO agn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Agsalod-salodoan nira tanandia ig ganing, “Biba ong adi tang mga Judio!” ");
INSERT INTO agn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Siay po-pokon nira tang kolo na ta bi-lak, ig aggolakan pa nira. Aglod-lodan ka nira ang midio pagtorol ta kagalangan ong nandia. ");
INSERT INTO agn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pagatapos nirang insolton, lindoatan nira tang kapang granati ig pinatokan si nira tang sadiling lambong na, ba-lo ingkelan da nira ong loa tang siodad para ilansang ong kros. ");
INSERT INTO agn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","May nabagat nira ong dalan ang tatang taw ang nagalin ong bokid. Na si Simon ang taga Cirene, tatay ni Alejandro may ni Rufo. Rineges si Simon tang mga sondalo ang magtakan tang kros ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Oman ingkelan da nira si Jesus ong logar ang aggoyan ta Golgota, ang maliag yaning, logar ang pa-dekan ang midio doli ta kolo ta taw. ");
INSERT INTO agn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pagakabot nira don, agtoldan din nira si Jesus ta bino ang may sampora nang bolong ang mira. Piro indi tanandia manginem. ");
INSERT INTO agn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ig dayon dang linansang nira ong kros. Pagatapos, pinarti-parti nira tang mga lambong na. Namagparabonlokan pa tanira para mata-wanan nira mga aypang lambong ay tang makomit tang kada tata ong nira. ");
INSERT INTO agn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mga alas noibi ong damal-damal tang paglansang nira ong ni Jesus ong kros. ");
INSERT INTO agn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Don ong may kokoloan na, may karatola ang sinolatan tang riklamo kontra ong nandia. Ganing don, “Na tang Adi tang mga Judio.” ");
INSERT INTO agn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","May doroang kriminal kang pinadengan nira ong ni Jesus ang linansang. Ang kros tang tambilog gampir ong to ni Jesus, ig ang tata gampir ong wala. ");
INSERT INTO agn_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ong maning don nagmatod tang na-tang dang lagi ong Kasolatan ang ganing, “Tanandia nabilang ang tata kang kriminal.” ");
INSERT INTO agn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Agileng-ilengan tanandia tang mga taw ang pamansita-lib ig agginsolton nira ang ganing, “Hoy, ganinga laglagen mo tang Timplo ig ong teled ta tolong kaldaw ipa-deng mo sing moman! ");
INSERT INTO agn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ta mandian, abir, tomaboana atan ong kros ig ilibri mo tang sadili mo!” ");
INSERT INTO agn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Maning ka don tang bindoat tang mga pangolokolong padi asta ang mga manigtoldok tang Katobolan. Linibak nira si Jesus ang ganing, “Linibri na tang doma, piro indi malibri na tang sadili na! ");
INSERT INTO agn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Itaen ta lamang bomabak ong kros tang Cristong na, ang adi ono tang Israel, magparet ita ong nandia!” Asta ang doroang aroman nang linansang ka ong kros, namaginsolto ka ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Asing ko-to ra ang magalas dosi ra, nangi-lep tang kalibotan tegka alas tris tang apon. ");
INSERT INTO agn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ig asing alas tris da, miniteg si Jesus ta mapoirsa ang ganing, “Eloi, Eloi, lama sabachthani?” ang maliag yaning, “Ampoanong Dios, Ampoanong Dios, angay pinabayano nio?” ");
INSERT INTO agn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Naba-yan narin tang domang mga taw ang pamansi-deng don ig ganing tanira, “Pama-yan mi! Aggoyan na si Elias!” ");
INSERT INTO agn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","May tata ong nira ang nanikad ang nangomit ta ispongha ig sine-me na ong binong maka-lem. Pagatapos, sina-ket na ong kapotan tang bi-lak oman dinoydoy na para ipasepsep ong ni Jesus. Ganing tang taw ang asi, “Elaten ta, telekan ta ngani mga komabot kaman si Elias para ipababak na tanandia ong kros.” ");
INSERT INTO agn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Miniteg si si Jesus. Oman inintriga na ra tang ispirito na ong Dios ig nabontok da tang linawa na. ");
INSERT INTO agn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ong oras kang asi, ya kay ang golping pagaba-bak tang ka-ngan tang kortinang dorog kabael ang don ong Timplo, magalin ong dibabaw sa-sad ong babakan. ");
INSERT INTO agn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mandian, ang kapitan tang mga goardia ke-deng don ong talongan tang kros ni Jesus, ig inita na ang monopa tanandia napatay. Animan ganing tang kapitan, “Matod ka kaman ang Ana tang Dios tang taw ang na!” ");
INSERT INTO agn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Don ong alawid-lawid may mga babay kang pamanorong. Katabid da don si Maria Magdalena, si Salome, may si Mariang nanay ni Santiagong mola may ni Jose. ");
INSERT INTO agn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ang mga babay ang na tang pamansitabid ig pamagasikaso ong ni Jesus mimpisa asing don pa tanira ong Galilea. Ig yadi pa kang mga babay don ang namansitabid ong nandia ong pagpaning na ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Asing apon da, may kiminabot ang tatang taw ang taga Arimatea, ang aran na si Jose. Tanandia tatang aggalangen ang opisialis tang mga Judio ig tata ka ong mga pamagelat tang kaldaw ang maggaem tang Dios bilang adi. Ig tenged ang kaldaw ang asi Kaldaw ang Palagsimpan ig ang domaton ang kaldaw ya ray ang Kaldaw ang Igperenay, nangiteg si Jose tang nem na ang napaning ong ni Pilato para maglisinsia mga poiding komiten na tang sinangoni ni Jesus ong kros. ");
INSERT INTO agn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nabereng si Pilato asing pagabasi na ang si Jesus patay da. Animan pinagoy na tang kapitan tang mga goardia ig sine-ma na mga matod kaman ang patay da si Jesus. ");
INSERT INTO agn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Asing mata-wanan ni Pilato ong kapitan ang matod ang patay da, pinagnan na si Jose ang komiten na tang sinangoni ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Animan namakal si Jose ta abel ang kolit, oman dayon ang kinomit na tang sinangoni ni Jesus ong kros. Binongot na tang abel ang asi ba-lo bintang na ong lebengan ang midio koiba ang bindoat ong pagsinsil ta bato. Pagabetang na tang sinangoni ni Jesus ong koiba, nagpaligid-ligid tanandia ta mabael ang bato ang dinapa na don ong anga tang koiba. ");
INSERT INTO agn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pamansipa-dek ka don si Maria Magdalena may si Mariang nanay ni Jose, animan inita nira mga ong aypa limbeng tang sinangoni ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Asing pagata-lib tang Kaldaw ang Igperenay, si Maria Magdalena, si Salome may si Mariang nanay ni Santiago namakal ta pabanglong para ong patay agod ipid ong sinangoni ni Jesus. ");
INSERT INTO agn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Animan pagaramal, kaldaw ang Dominggo, ba-lo pa lamang te-la tang kaldaw, namansipaning da tanira ong lebengan. ");
INSERT INTO agn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ong dalan pa lamang pamagampang-ampang da tang mga babay ang ganing, “Sinopa bato tang matobol ta ang magpaligid-ligid tang bato ang dadapa ong lebengan?” ");
INSERT INTO agn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Maning don tang bitala nira tenged dorog kabael tang batong asi. Piro asing pagatorong nira tang koiba, inita nira tang batong agdadapa naigod da! ");
INSERT INTO agn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dayon tanirang siminled ong koiba ig don inita nira tang tatang soltiros ang pagtok ta maboat ang lambong ang kolit ig kakarong don gampir ong to. Inledan ta mo-ya tang mga babay. ");
INSERT INTO agn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Animan ganing tang lali ong nira, “Indi amo meled! Gata-wanano ang agdilemen mi si Jesus ang taga Nazaret, ang linansang ong kros. Anda ra tarin. Naboi rang oman tanandia. Telekan mi, nani ka tang logar ang bintangan ong nandia.” ");
INSERT INTO agn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pagatapos, ganing tang lali ong nira, “Magbalik amo ra lamang ig aningen mi tang mga sinagpan na, labi pa ong ni Pedro, ang tongkaw da si Jesus ong nindio don ong Galilea. Itaen mi tanandia don, pario tang inaning na ong nindio tanopa sia.” ");
INSERT INTO agn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pagaloa lamang tang mga babay ong lebengan, dorong sinikad nira. Pamangelel pa tang mga sinangoni nira ong sobrang karaelden nira. Ig tenged geldan tanira, inding pisan namansibek-ibek maski ong ninopa. ");
INSERT INTO agn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Si Jesus naboing oman ong kaldaw ang Dominggo ang māga pang pisan. Napaita tanandia primiro ong ni Maria Magdalena, ang dating pinalinan na ta pitong dimonio. ");
INSERT INTO agn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Oman pinaningan ni Maria tang mga sinagpan ni Jesus ang pamagsinti ig pamagini-yak ig binalita na tang inita na. ");
INSERT INTO agn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Piro indi tanira namagparet ong inaning na ang si Jesus boi ra ono ig napaita ong nandia. ");
INSERT INTO agn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pagatapos ta si, napaita ka si Jesus ong doroa ong mga sinagpan na asing totongol tanira ong bario, piro ang itsora na midio belag ta tanandia. ");
INSERT INTO agn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Namagbalik tang doroang asi ong Jerusalem ig namamalita ong mga karomanan nira tang inita nira, piro indi ka tanira pinaret. ");
INSERT INTO agn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Asing ori ra, napaita ra ka enged si Jesus ong tampolok may tatang mga sinagpan na mintras pamamangan tanira. Binitalan na tanira ang korang pa tang pagtalig nira ong nandia ig matetegat tang mga kolo nira, tenged asing binalitan tanira tang nangaita ang boi ra tanandia, indi enged tanira namagparet. ");
INSERT INTO agn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Oman minaning si Jesus ong nira, “Liboton mi tang bilog ang kalibotan ig ipatako mi ong tanan ang mga taw tang Mo-yang Balitang natetenged ong yen. ");
INSERT INTO agn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ang sinopay magparet ig magpaboniag, malibri. Piro ang indi magparet, silotan tang Dios. ");
INSERT INTO agn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ang mga mamagto ong yen oldan tang Dios ta gaem ang itaen ong pagboat nira ta mga makabebereng ang mga bagay ang pario ta na: Ong paggamit nira tang arano, mapalayas nira tang mga dimoniong siminled ong sinangoni ta taw; mabitala tanira ta domang klasing bitalang indi nadalan nira; ");
INSERT INTO agn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","mga magbiot tanira ta ma-kal, obin mga mainem ta makalalason ang bagay, indi tanira maonopa; ig ong pagbondo lamang tang kalima nira ong sinangoni tang pamagmasit, mamago-yang lagi.” ");
INSERT INTO agn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagatapos ang minitala si Ginong Jesus ong mga sinagpan na, dayon da tanandiang ingkelan ong langit, ig don kiminarong gampir ong to tang Dios ang Tatay. ");
INSERT INTO agn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ang mga sinagpan na, dayon da kang namansipanaw ig namagpatako tang Mo-yang Balita ong tanan ang mga logar. Sinabangan tanira tang Gino ig sindolan na tanira ta gaem ang magboat ta mga milagro para mapamatodan ong mga taw nga ang agtotoldok nira yay ang kamatodan. 9>Ang tolong babay ang asi namansipaning ong da Pedro may ang mga karomanan na ig binalita nira tang tanan ang inaning ong nira tang laling don ong lebengan. 10Pagatapos ta si, si Jesus mismo nanobol ong mga sinagpan na ang ipatako nira ong bilog ang kalibotan tang sagradong balitang inding pisan magoman asta ong tanopa, ang yay ang balitang natetenged ong kalibrian ang anday kataposan na.");
INSERT INTO agn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Aggalangenong Teofilo: Doro rang mga taw ang napamagsolat natetenged ong mga nainabo tani ong yamen asing tokaw. ");
INSERT INTO agn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tanira namagsolat sigon ong mga bagay ang sinayod ong yamen tang mga taw ang mismong nangaita ta asia ig ang nagimong mga manigtoldok tang balitang na. ");
INSERT INTO agn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Ang tanan ang balitang na, napagadalano ra ka ta mo-ya tanopa sia pa. Animan, para masigoroa kang matod ka kaman tang mga bagay ang sinoldok ong nio, naisipo kang isolat ta dalalaton tang tanan ang na para ong nio. ");
INSERT INTO agn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Asing tokaw ang si Herodes pa tang adi tang probinsia tang Judea, may tatang padi tang mga Judio ang aran na si Zacarias. Si Zacarias ang na tata ka ong gropo tang mga pading inampo ni Abias. Asta ang katawa ni Zacarias ang si Elisabet, nagalin ka ong dogo ni Aaron. ");
INSERT INTO agn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ang magkatawang na, pario tanirang mato-lid ong pama-dek tang Dios. Agtomanen nira ta mo-ya tang tanan ang katobolan na. ");
INSERT INTO agn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Piro anday ana nira, tenged bog si Elisabet, ig mepet da tanirang doroa. ");
INSERT INTO agn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ong mga kaldaw ang asi, belet da tang gropo ni Zacarias ang magboat tang mga katengdanan bilang mga padi ong Timplo tang Gino. Animan pagsirbi si Zacarias don. ");
INSERT INTO agn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Asing namagparabonlokan tang mga padi, sigon ong naogalian nira, si Zacarias tang natengedan ang magsirok tang insinso. Animan siminled tanandia don ong teled tang Timplo ");
INSERT INTO agn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","para magsirok tang insinso, mintras pamangadi ong loa tang kadoro-doroan ang taw. ");
INSERT INTO agn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Asing don pa ong teled si Zacarias, may tatang anghil tang Gino ang napaita ong nandia. Ke-deng tang anghil don ong parting to tang altar ang agsirokan ta insinso. ");
INSERT INTO agn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nakibot si Zacarias asing pagaita na tang anghil ig inledan ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Piro ganing ong nandia tang anghil, “India meled, Zacarias. Pinama-yan tang Dios tang pangadi mo. Magkatinira ta ana mong lali. Tenged mangana tang katawa mong si Elisabet, ig paranan mo tang mola ta Juan. ");
INSERT INTO agn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Malipaya ig ambengana ta mo-ya tenged ong nandia. Ig yadi kang malipay ang tanandia pinangana. ");
INSERT INTO agn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tenged magimong alawig tanandia ong pama-dek tang Dios. Indi tanandia manginem ta bino obin maski onopang irinemen ang pamaleng. Ong sian pa lamang tanandia tang nanay na, gaeman tanandia tang Ispirito Santo. ");
INSERT INTO agn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dorong mga kasimanoa ming mga inampo ni Israel ang pabaliken na ong Ampoan nirang Dios. ");
INSERT INTO agn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tongkaw tanandia ong Gino, ig ong nandia tang gaem ig mapoirsang nem, pario tang propitang si Elias asing tokaw. Papagoliken na tang mga nalanggang nem tang mga tatay ong mga ana nira. Toldokan na ta mo-yang pagirisipen tang mga taw ang indi pamagtoman tang mga tobol tang Dios agod maintindian nira tang natetenged ong mato-lid ang pangaboi. Ong maning ta si, simpan da tang mga taw ong pagkabot tang Gino.” ");
INSERT INTO agn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ganing si Zacarias ong anghil, “Monopa masigorō tang agganing mong asia? Tenged yami tang katawao mga mepet ami ra.” ");
INSERT INTO agn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Siminabat tang anghil, “Yo si Gabriel. Pagsirbio ong talongan tang Dios. Sinobolo nandia para ipatako tang masinlong balitang inaningo ra ong nio. ");
INSERT INTO agn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Piro tandan mo: Maboyona ang lagi mandian, tenged india nagparet ong yen ang bitala. India ra mabitala mintras indi pa gainabo tang mga bagay ang na. Piro sia mainabo enged pagkabot tang oras.” ");
INSERT INTO agn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mandian, pamagelat pa tang mga taw ong ni Zacarias, ig nangabereng tanira angay naboay da tanandia ong teled tang Timplo. ");
INSERT INTO agn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pagaloa na, indi ra tanandia mabitala. Mga sinial da lamang tang aggamiten na ong nira. Animan naisip nirang may napaitang makabebereng sigoro ong nandia don ong teled tang Timplo. ");
INSERT INTO agn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Asing natapos da tang belet ni Zacarias ang magsirbi ong Timplo, minolik da tanandia. ");
INSERT INTO agn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Indi naboay, nanangken da tang katawa nang si Elisabet. Ig indi naloa-loa ong balay ong teled ta limang bolan. ");
INSERT INTO agn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ganing si Elisabet, “Ay! Nate-bek da ong yen tang Ampoanong Dios. Nakomit da tang kaeyakano ong talongan tang mga taw.” ");
INSERT INTO agn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Asing yanem dang bolan ang pagabdet si Elisabet, ang anghil ang si Gabriel sinobol tang Dios ang paning ong Nazaret, sakep tang Galilea, ");
INSERT INTO agn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ong tatang soltiras ang indi pa galengetan ta lali, ang aran na si Maria. Si Maria, karasalen da lamang ong ni Jose, tatang laling nagalin ong dogo tang Ading si David. ");
INSERT INTO agn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Napaita tang anghil ong ni Maria ig minaning, “Malipaya, Maria! Yawa, inaloyana tang Dios, ig ang Ampoan asia ong nio.” ");
INSERT INTO agn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nalibeg tang isip ni Maria ong inaning tang anghil, ig agpaino-inon na pa ta mo-ya tang binitala nang asi. ");
INSERT INTO agn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Animan ganing ong nandia tang anghil, “India meled, Maria, galipay ong nio tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yawa, magabdeta ig manganā ta tatang lali ig paranan mo ta Jesus. ");
INSERT INTO agn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Magimong alawig tang dengeg na ong pama-dek tang mga taw, ig goyan tanandia ta Ana tang Kalawig-lawigan ang Dios. I-dol ong nandia tang Dios tang inadian tang nandiang kamepet-mepetan ang si David, ");
INSERT INTO agn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ig maggaem tanandia ong mga inampo ni Jacob ang anday kataposan. Inding pisan matapos-tapos tang paggaraemen na bilang adi.” ");
INSERT INTO agn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Oman ganing si Maria ong anghil, “Monopa yo magabdet? Tenged anda pay laling nalenget ong yen!” ");
INSERT INTO agn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ganing ang siminabat tang anghil, “Pababak ong nio tang Ispirito Santo, ig magtinir ong nio tang kagaeman tang Kalawig-lawigan. Animan sagrado tang molang ipangana mo, ig goyan tanandia ta Ana tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Onopa? Gademdeman mo tang pinagari mong si Elisabet? Ganing tang mga taw, bog tanandia. Piro mandian pagabdet da, maski mepet da tanandia. Enem dang bolan tang aggekel-ekelan na ong sian na. ");
INSERT INTO agn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tenged anday imposibli ong Dios.” ");
INSERT INTO agn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Siminabat si Maria, “Torobolono tang Gino. Balampa mainabo ong yen tang inaning mo.” Ig nagalin da tang anghil. ");
INSERT INTO agn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pagatapos ta si, nagapora si Maria ang napaning ong tatang lansangan don ong kabobokidan tang probinsia tang Judea. ");
INSERT INTO agn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pagakabot na ong balay da Zacarias, kinomosta na si Elisabet. ");
INSERT INTO agn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Asing pagabasi ni Elisabet tang bosis ni Maria, pisan ang kiminaliek tang mola ong sian na. Ginaeman si Elisabet tang Ispirito Santo, ");
INSERT INTO agn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ig ong sobrang kalipay na naiteg tanandiang ganing, “Yawa Maria, inaloyana tang Dios, sobra pa ong tanan ang babay, ig inaloyan na ka tang aggekel-ekelan mo ong sian mo. ");
INSERT INTO agn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Angay bato ong yen sindol tang dengeg ang na, ang yo bisitaeno tang nanay tang yen ang Gino? ");
INSERT INTO agn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gata-wanan mo, pagabasio lamang tang bosis mo, pisan ang kiminaliek tang mola ong siano ong sobrang kalipay na. ");
INSERT INTO agn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ig yawa masoirtia mandian tenged nagparetang mainabo tang inaning ong nio tang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dayon ang minaning si Maria, “Agdayaweno tang Dios ong popotokono, ");
INSERT INTO agn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ig galipay ta mo-ya tang nemo ong Dios, ang yen ang Maniglibri. ");
INSERT INTO agn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tenged yo tang pinilik nang inaloyan, maski yo, torobolono lamang nandia. Ig mimpisa mandian, maning tang tanan ang taw ang yo, masoirtio ");
INSERT INTO agn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tenged makabebereng tang mga bagay ang bindoat ong yen tang Dios ang Makagagaem. Sagrado tang aran na! ");
INSERT INTO agn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Gate-bekan na tang tanan ang pamaggalang ong nandia mimpisa pa asing tokaw, mandian ig asta ong parakaboton. ");
INSERT INTO agn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pinaita na tang gaem ig poirsa na, ig pinalin na tang mga taw ang alawig tang pabetang nira ong sadili nira. ");
INSERT INTO agn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pinababak na tang mga taw ang alalawig tang katengdanan nira, ig pinalawig na tang mga taw ang dibabak tang pagkabetang nira. ");
INSERT INTO agn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pinaelen na ta mga mo-yang bagay tang mga gangaletem, piro pinalayas na tang mga manggaden ang anday nae-lan nira. ");
INSERT INTO agn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Sinabangan na itang mga inampo ni Israel, itang mga torobolon na, sigon ong pangako na ong mga kamepet-mepetan ta. ");
INSERT INTO agn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Inate-bekan na si Abraham, asta itang mga inampo ni Abraham ang anday kataposan!” Asia tang pagdayaw ni Maria ong Dios. ");
INSERT INTO agn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mga tolong bolan ang nagtinir si Maria ong da Elisabet ba-lo tanandia minolik. ");
INSERT INTO agn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kiminabot tang oras ang mangana ra si Elisabet, ig nangana tanandia ta tatang molang lali. ");
INSERT INTO agn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pagabalita tang mga kamalay ig mga kaparintian na ang inate-bekan tanandia ta mo-ya tang Dios, nangalipay ka tanirang aroman ni Elisabet. ");
INSERT INTO agn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Asing yawalo rang kaldaw, namansipaning tang mga taw ong balay, tenged torian da tang mola, sigon ong kaogalian nira. Zacarias din tang iparan nira ong mola, pario tang aran tang tatay na. ");
INSERT INTO agn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Piro ganing tang nanay na, “Indi! Juan tang iparan ong nandia.” ");
INSERT INTO agn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ganing tanira, “Yamo, anday kaparintian ming maning atan tang aran na!” ");
INSERT INTO agn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Animan sininiasan nira si Zacarias, ig sine-ma mga onopa tang galiliagan nang iparan ong mola. ");
INSERT INTO agn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nama-dol tanandia ta masolatan, ig nagsolat ta maning ta na, “Juan tang aran na.” Ig nangabereng tanirang tanan. ");
INSERT INTO agn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Oman, golping nabitala si Zacarias, ig nagdayaw ong Dios. ");
INSERT INTO agn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nangabereng ang pisan tang tanan ang kamalay nira ong nainabo, ig indi naboay nabantog tang mga bagay ang na ong bilog ang kabobokidan tang Judea. ");
INSERT INTO agn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ang tanan ang nangabalita, dorong isip nira ig namagampang-ampang ang ganing, “Onopa bato tang loan tang molang na?” Tenged aggitaen nira nga ong nandia tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Si Zacarias, ang tatay ni Juan, ginaeman tang Ispirito Santo, ig dayon ang minitala natetenged ong parakabotan ang ganing, ");
INSERT INTO agn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dayawen tang Gino, ang Dios tang Israel! Tenged dinemdem na ig ginawad tang banoa na. ");
INSERT INTO agn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Sindolan ita ra nandia ta tatang makagagaem ang Maniglibri, tata ong mga inampo ni David, ang torobolon tang Dios asing tokaw. ");
INSERT INTO agn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sinobol tang Dios tang mga sagradong propita na asing tokaw pa para magpatako ong yaten ");
INSERT INTO agn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ang ilibri ita nandia ong mga kasoay ta, ig ong gaem tang tanan ang mga pamandegdeg ong yaten. ");
INSERT INTO agn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Minaning tang Dios ang ate-bekan na tang mga kamepet-mepetan ta, ig tomanen na tang sagradong inigoan ");
INSERT INTO agn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ang bindoat na ong kamepet-mepetan tang si Abraham. ");
INSERT INTO agn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nangako tanandia ang ilibri ita nandia ong mga kasoay ta agod mapagsirbi ita ong nandia ang anday eled ta, ");
INSERT INTO agn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ig para magimong sagrado ig mato-lid ita ong pama-dek na, mintras gaboi ita pa. ");
INSERT INTO agn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ig yawa, anao, goyana ta propita tang Kalawig-lawigan ang Dios tenged tongkawa ong Gino para simpanen tang dalan ang panawan na. ");
INSERT INTO agn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yawa tang magpatako ong banoa tang Dios ang patawaden na tang mga kasalanan nira, ig ong maning ta si malibri tanira. ");
INSERT INTO agn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tenged masine-bekanen ang enged tang Ampoan tang Dios. Papaningen na ong yaten tang Maniglibri ang magalin ong langit, ig ang pagkabot na magkapario ong kaldaw mga te-la ra ");
INSERT INTO agn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tenged magtorol tanandia ta kayagan ong mga taw ang gangabo-wan ong maki-lep ig ong gaem tang kamatayen. Ig antabayen ita nandia ong dalan tang kao-yan.” Asia tang binitala ni Zacarias. ");
INSERT INTO agn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nambael tang molang si Juan ig namoirsa tang sinangoni na ig pinabaked tang Gino tang nem na. Ministar tanandia ong kabobokidan, ong logar ang anday gistar ang taw, asta ong kaldaw ang magpaita ra tanandia ong mga inampo ni Israel para magtoldok ong nira. ");
INSERT INTO agn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ong mga timpong asi, nagpapanaw ta ordin tang alawig ang ading si Agosto ang magpalista tang tanan ang taw ong mga banoang gasakepan tang Roma. ");
INSERT INTO agn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Narin tang primirong palista, ig nainabo asing si Cirenio tang gobirnador tang Siria. ");
INSERT INTO agn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Animan namansiolik tang kada tata ong sadiling logar nira para magpalista. ");
INSERT INTO agn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ig nagalin ong banoa tang Nazaret sakep tang probinsia tang Galilea, nagbiahi si Jose ong Betlehem sakep tang Judea, don ong banoang pinanganan tang Ading si David. Napaning don si Jose tenged tanandia tata ong mga inampo ni David. ");
INSERT INTO agn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aroman nang minolik para magpalista si Maria, ang pinagampangan dang magimong katawa na. Asing oras ang asi, palanganaen da si Maria, ");
INSERT INTO agn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ig asing don da tanira ong Betlehem, kiminabot tang oras ang mangana ra. ");
INSERT INTO agn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nangana tanandia tang kakan ang ana na, tatang molang lali. Binongot na ta ga-net ig pinalbog na ra lamang ong tatang palamanganan ta ayep, tenged anda ray logar para ong nira ong balay ang agpabayadan. ");
INSERT INTO agn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Don ong logar ang asi may mga taw ong patag, ang pamagpolaw ig pamagbantay tang mga karniro nira. ");
INSERT INTO agn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mintras don tanira, may tatang anghil tang Gino ang golping napaita ong talongan nira, ig nangayag ta mo-ya tang sinag tang Gino ong palibot nira. Animan pisan ang pinangeldan tang mga manigbadbad. ");
INSERT INTO agn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Piro ganing tang anghil ong nira, “Indi amo meled. Mamasi amo! Yo, may ibalitao ong nindio ang dorog kasinlo, ang magtorol ta kambengan ong tanan ang taw. ");
INSERT INTO agn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tenged pinangana mandian ang labi ong banoa ni David tang Maniglibri mi. Tanandia tang Gino ig ang Cristong aggelaten. ");
INSERT INTO agn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Don itaen mi tang tatang molang agbongoton ta ga-net ig pinalbog ong palamanganan ta ayep. Asia tang magimong tanda para mata-wanan ming matod tang bibitalao.” ");
INSERT INTO agn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pagabitala lamang tang anghil, golping napaita tang kadoro-doroan pang anghil ang namagalin ong langit. Pamagdayaw tanirang tanan ong Dios ang ganing, ");
INSERT INTO agn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dayawen tang Dios ong kalawig-lawigan ang langit, ig tarin ong tanek magkatinir ta kao-yan tang mga taw ang galiliagan na.” ");
INSERT INTO agn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Asing nangapamagalin da tang mga anghil ang namansibalik ong langit, namagampang-ampang tang mga manigbadbad, “Maytara ong Betlehem! Telekan ta tang mga nainabong nang pinatako ong yaten tang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Animan nagdali-dali tanirang napaning ong Betlehem. Don kinabotan nira si Maria may si Jose, ig inita nira tang molang lolbog ka kaman ong palamanganan ta ayep. ");
INSERT INTO agn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Oman sinayod nira tang inaning tang anghil ong nira natetenged ong mola. ");
INSERT INTO agn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nangabereng tang tanan ang nangabasi tang inaning tang mga manigbadbad. ");
INSERT INTO agn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Piro si Maria, lindoak nang lagi ong isip na tang tanan ang mga bagay ang na, ig pirming agpaino-inon na. ");
INSERT INTO agn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ang mga manigbadbad namagbalik ong obra nira, ig dorong pasalamat nira ig pagdayaw ong Dios tenged ong tanan ang inita nira. Tenged mga onopa tang inaning ong nira tang anghil, ya ka enged tang inita nira. ");
INSERT INTO agn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Asing yawalo rang kaldaw, pinatorian da tang mola ig pinaranan ta Jesus. Narin tang aran ang sindol tang anghil asing anda pa tanandia ong sian ni Maria. ");
INSERT INTO agn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Oman, kiminabot da tang kaldaw ang magboat tanira tang sirimoniang sigon ong Katobolan ni Moises para magimong limpio tang nanay. Animan napaning da Jose ong Jerusalem ig ingkelan nira tang mola para iprisintar ong Dios. ");
INSERT INTO agn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tenged ganing ong Katobolan tang Dios, “Kada kakan ang lali kaministiran ang itagana para ong Dios.” ");
INSERT INTO agn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Animan asing don da tanira ong Timplo, nagbolontad tanira sigon ong Katobolan para ong sirimonia tang pagpalimpio. Ang agpa-dolon don ay magkatawang lare obin doroang marapating mola pa. ");
INSERT INTO agn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mandian don ong Jerusalem may tatang mepet ang aran na si Simeon. Madinioson tanandia ig masinomanen ong mga tobol tang Dios. Pagelat tanandia ong kaldaw ang maglibri tang Dios ong Israel. Ig pirmi ong nandia tang Ispirito Santo. ");
INSERT INTO agn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pinatako rang lagi tang Ispirito Santo ong ni Simeon ang indi tanandia mapatay asta indi itaen na tang Cristong pinangako tang Dios ang komabot. ");
INSERT INTO agn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mandian, aggekelan si Simeon tang Ispirito Santo ang tenled ong Timplo. Ig asing e-lan don si Jesus tang mga ginikanan na para boaten tang agpa-dolon ong Katobolan, ");
INSERT INTO agn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","sinapopo ni Simeon tang mola, ig nagdayaw ong Dios ang ganing, ");
INSERT INTO agn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mandian Gino, maski bawieno ra nio, yo ang torobolon mo, kontintō ra. Tenged sigon ong pangako mo, ");
INSERT INTO agn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","initao ra ong yen ang mga mata tang Maniglibri ang sinobol mo. ");
INSERT INTO agn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Sinimpan mo tanandia ong talongan tang tanan ang taw. ");
INSERT INTO agn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tolok tanandiang magtorol ta kayagan ong domang mga nasion, ig magtorol ta mabael ang dengeg ong banoa mong Israel.” ");
INSERT INTO agn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nabereng ta mo-ya tang mga ginikanan ni Jesus ong inaning ni Simeon natetenged ong mola. ");
INSERT INTO agn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Oman binindisionan tanira ni Simeon ig ganing ong ni Maria, “Maria, tandan mo na. Ang molang na pinilik tang Dios. Yading mga inampo ni Israel ang madagpa natetenged ong nandia, ig yadi kang kendeng agod malibri. Tanda tanandiang nagalin ong Dios, piro dorong mamangontra ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ong maning ta si mata-wanan tang aggisipen nira. Ig yawa, Maria, midio sa-saken ta ta-bat tang popotokon mo ong sobrang pagsinti.” ");
INSERT INTO agn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mandian may tatang propitang babay ang don ka ong Timplo, ang aran na si Ana. Tanandia ana ni Fanuel, ig tata ka ong mga inampo tang tribo ni Aser. Doro ra kamepet si Ana. Pitong takon lamang tanirang naga-pen tang katawa na, ");
INSERT INTO agn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","nabalo tanandia. Ig mandian walompolok may epat dang takon tang idad na. Pirmi tanandia ong Timplo, kaldaw may labi, ang pagdayaw ong Dios ig pagpaletem mintras pangadi. ");
INSERT INTO agn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ong oras kang asi ang don pa da Jose, napalenget tang mepet ig nagpasalamat ong Dios. Ig mimpisa don, pirmi tanandiang pagsayod natetenged ong molang si Jesus ong tanan ang taw ang pamagelat kang maglibri tang Dios ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Asing naboat da ni Jose may ni Maria tang tanan ang dapat boaten nira sigon ong Katobolan tang Dios, minolik tanira ong banoa nira, ong Nazaret sakep tang Galilea. ");
INSERT INTO agn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Don nambael ig namoirsa tang mola. Ponok tanandia ta kinata-wanan ig inaloyan tanandia tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Takon-takon, kada Pista tang Pagta-lib tang Anghil, ang mga ginikanan ni Jesus pamamista ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Animan asing tampolok may doroa rang takon si Jesus, namista ka tanira sigon ong naogalian nira. ");
INSERT INTO agn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagatapos tang pista, asing pamansiolik da tanira, napabo-wan si Jesus ong Jerusalem, ang indi nata-wanan tang mga ginikanan na. ");
INSERT INTO agn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ang kalaom nira, tatabid lamang tanandia ong domang mga karomanan nira. Animan, diritso ka tang panaw nira asta kinabotan ta nagapon ba-lo nata-wanan nira ang belag pala ta aroman nira. Dinilem nira si Jesus ong mga kaparintian ig kailala nira. ");
INSERT INTO agn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Asing indi inita nira, nagbalik tanira ong Jerusalem para dilemen don. ");
INSERT INTO agn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pagata-lib tang tolong kaldaw ba-lo natoman nira don ong Timplo. Kakarong tanandia aroman tang mga manigtoldok, ang pamasi ig pane-ma ong nira. ");
INSERT INTO agn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Gangabereng tang tanan ang taw ang gangabasi ong nandia tenged ong kinata-wanan na ig ong mga sabat na. ");
INSERT INTO agn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Asta si Maria may si Jose, nangabereng ka asing itaen nira tanandia don. Ganing ong nandia tang nanay na, “Anao, angay maning ta na tang bindoat mo ong yamen? Doro rang ka-tekan tang kolo amen ni tatay mo ang pagdilem ong nio!” ");
INSERT INTO agn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Piro siminabat si Jesus, “Angay agdilemeno nindio? Indi amo gatako ang dapat tarino ong balay tang Tatayo?” ");
INSERT INTO agn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Piro indi naintindian nira tang maliag nang yaning. ");
INSERT INTO agn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Oman, siminabid da si Jesus ong nirang minolik ong Nazaret, ig pirming masinomanen tanandia ong mga ginikanan na. Piro agpaino-inon ang pirmi tang nanay na tang tanan ang mga bagay ang na. ");
INSERT INTO agn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Diritso tang pagbaraelen ni Jesus. Mas nagdolang tang kinata-wanan na, ig mintras gaboay mas galipay ong nandia tang Dios asta ang mga taw. ");
INSERT INTO agn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yatampolok may lima rang takon ang kakarong si Tiberio, ang alawig ang adi tang Roma. Si Poncio Pilato ka tang gobirnador tang Judea. Si Herodes tang adi ong probinsia tang Galilea, ig ang logod nang si Felipe ong mga tiritorio tang Iturea ig Traconite. Si Lisanias tang adi ong Abilinia. ");
INSERT INTO agn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Da Anas ig Caifas pa ka tang mga kalawigan ang pangolokolo ong mga padi. Mandian, asing timpong asi, don pagtinir si Juan ang ana ni Zacarias ong logar ang anday gistar ang taw. Ig kiminabot ong nandia tang bitala tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Animan linibot-libot ni Juan tang mga logar ong magdobali-dobali tang sobang aggoyan ta Jordan. Pagtoldok tanandiang ganing, “Magtogat amo ong mga kasalanan mi ig magpaboniag agod patawaden amo tang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ong pagboat ni Juan ta maning ta sia, nagmatod tang sinolat tang propitang si Isaias asing tokaw pa, ang ganing: “May paginiteg don ong logar ang anday gistar ang taw ang ganing, ‘Simpanen mi tang paranawan tang Gino! To-liden mi tang mga dalan ang panawan na! ");
INSERT INTO agn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tambakan tang kada dibabak ang logar, ig pegnaken tang kada bolod ig bokid. To-liden tang kada liko-likong dalan, ig tampayen tang mga lobak-lobak, ");
INSERT INTO agn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","agod itaen da tang tanan ang taw tang pagrilibrien tang Dios ong nira.’ ” ");
INSERT INTO agn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yading mga taw ang namansipaning don ong ni Juan para magpaboniag. Piro ganing tanandia ong nira, “Mga ma-kal amo! Angay kaisip mi ang palibri amo ong silot ang ipakabot tang Dios? Sinopay naganing ta maning ta si ong nindio? ");
INSERT INTO agn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mga matod ang pamagtogat amo ra ong mga talak mi, ipaita mi ong mga boat mi. Indi amo manalig ang indi amo silotan tenged lamang mga inampo amo ni Abraham. Agganingo ong nindio, maski ngani ang mga batong na, poiding boaten tang Dios ang magimong ana ni Abraham, mga galiliag lamang tanandia. ");
INSERT INTO agn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Alenget dang silotan tang mga taw! Ang kaparioan nira mga papa ta ayong alenget dang pe-peten. Tenged ang kada papa ta ayo, mga indi pamorak ta masinlo, pe-peten lamang ig idapog ong apoy.” ");
INSERT INTO agn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Animan nane-ma tang mga taw ong ni Juan, “Mga maning ta si, onopay dapat boaten amen?” ");
INSERT INTO agn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Siminabat si Juan, “Maning ta na tang boaten mi. Mga ang lambong mi doroa, i-dol mi tang tata ong anday lambong na. Maning ka atan mga bastanti tang pamangan mi, partian mi ka tang anday mapangan na.” ");
INSERT INTO agn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","May atan kang mga manigtokot ta bois ang namansipaning ong ni Juan para magpaboniag. Nane-ma tanira, “Maistro, yami, onopay dapat boaten amen?” ");
INSERT INTO agn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Siminabat tanandia, “Indi amo manokot ta sobra ong dapat ang tokoton mi.” ");
INSERT INTO agn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nane-ma ka ong nandia tang mga sondalo, “Ig yami, onopa kay dapat boaten amen?” Siminabat ka si Juan, “Indi amo mandegdeg ig magbandan ta belag ta matod ong mga taw para mapangoarta amo. Magkontinto amo lamang ong soildo mi.” ");
INSERT INTO agn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Asing mga timpong asi, pamaglangkag da tang mga taw ong pagkabot tang Cristong pinangako tang Dios. Animan pamane-ma ra ong mga sadili nira mga si Juan ang na ya ray ang aggelaten nira. ");
INSERT INTO agn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Animan ganing si Juan ong nira, “Yo, pagboniago ong nindio ong wi lamang. Piro may komabot ang domaton ong yen ang magboniag ong nindio ong Ispirito Santo ig ong apoy. Mas alawig tang dengeg na ong yen, ig maski ngani tomokok ig magobad tang kordon tang rapak na, belago ta bagay. ");
INSERT INTO agn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Listo ra tanandiang ipabelag tang moro-ya ong malalain, pario tang pagpakolay ta paray. Simeten tang simlat ig i-tang ong dispinsa. Piro sirokon tang kepa ong apoy ang indi mapatay-patay asta ong tanopa.” ");
INSERT INTO agn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Doro pang mga bagay ig pandam ang pinatako ni Juan ong mga taw ong pagtoldok na tang Mo-yang Balita. ");
INSERT INTO agn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sinambleng na tang ading si Herodes natetenged ong bayaw nang babay ang si Herodias ang ga-pen a-penan na, ig ong doma pang bindoat nang malalain. ");
INSERT INTO agn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tenged don, pinapriso ni Herodes si Juan, ig ong bindoat nang asi mas nadolangan pa enged tang kasalanan na. ");
INSERT INTO agn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Asing agboniagan ni Juan tang dorong taw don, nagpaboniag ka ong nandia si Jesus. Pagatapos ta si, mintras pangadi si Jesus, nagabri tang langit ig ");
INSERT INTO agn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","napababak ong nandia tang Ispirito Santo ang magang lare. Ig may tatang bosis nagalin ong langit ang ganing, “Yawa tang agmalenong Anao. Galipayo ta mo-ya ong nio.” ");
INSERT INTO agn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mga tolompolok ang takon tang idad ni Jesus asing magimpisa tanandiang magtoldok. Ong pabetang tang mga taw, tanandia ana ni Jose. Mandian si Jose ana ni Eli. ");
INSERT INTO agn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Eli ana ni Matat. Si Matat ana ni Levi. Si Levi ana ni Melqui. Si Melqui ana ni Janai. Si Janai ana ni Jose. ");
INSERT INTO agn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Jose ana ni Matatias. Si Matatias ana ni Amos. Si Amos ana ni Nahum. Si Nahum ana ni Esli. Si Esli ana ni Nagai. ");
INSERT INTO agn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagai ana ni Maat. Si Maat ana ni Matatias. Si Matatais ana ni Semei. Si Semei ana ni Josec. Si Josec ana ni Joda. ");
INSERT INTO agn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Joda ana ni Joanan. Si Joanan ana ni Resa. Si Resa ana ni Zerubabel. Si Zerubabel ana ni Salatiel. Si Salatiel ana ni Neri. ");
INSERT INTO agn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri ana ni Melqui. Si Melqui ana ni Adi. Si Adi ana ni Cosam. Si Cosam ana ni Elmadam. Si Elmadam ana ni Er. ");
INSERT INTO agn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er ana ni Josue. Si Josue ana ni Eliezer. Si Eliezer ana ni Jorim. Si Jorim ana ni Matat. Si Matat ana ni Levi. ");
INSERT INTO agn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Levi ana ni Simeon. Si Simeon ana ni Juda. Si Juda ana ni Jose. Si Jose ana ni Jonan. Si Jonan ana ni Eliakim. ");
INSERT INTO agn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliakim ana ni Melea. Si Melea ana ni Menna. Si Menna ana ni Matata. Si Matata ana ni Natan. Si Natan ana ni David. ");
INSERT INTO agn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David ana ni Jesse. Si Jesse ana ni Obed. Si Obed ana ni Boaz. Si Boaz ana ni Salmon. Si Salmon ana ni Naason. ");
INSERT INTO agn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Naason ana ni Aminadab. Si Aminadab ana ni Admin. Si Admin ana ni Arni. Si Arni ana ni Esrom. Si Esrom ana ni Farez. Si Farez ana ni Juda. ");
INSERT INTO agn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Juda ana ni Jacob. Si Jacob ana ni Isaac. Si Isaac ana ni Abraham. Si Abraham ana ni Terah. Si Terah ana ni Nahor. ");
INSERT INTO agn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor ana ni Serug. Si Serug ana ni Rehu. Si Rehu ana ni Peleg. Si Peleg ana ni Eber. Si Eber ana ni Sala. ");
INSERT INTO agn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sala ana ni Cainan. Si Cainan ana ni Arfaxad. Si Arfaxad ana ni Shem. Si Shem ana ni Noe. Si Noe ana ni Lamec. ");
INSERT INTO agn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamec ana ni Matusalem. Si Matusalem ana ni Enoc. Si Enoc ana ni Jared. Si Jared ana ni Mahalaleel. Si Mahalaleel ana ni Kenan. ");
INSERT INTO agn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Kenan ana ni Enos. Si Enos ana ni Set. Si Set ana ni Adan. Si Adan ana tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Asing pagalin ni Jesus ong soba tang Jordan, ginaeman da tanandia tang Ispirito Santo. Ingkelan si Jesus tang Ispirito don ong logar ang anday tataw na. ");
INSERT INTO agn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ig don tanandia nagtinir ta epat ang polok ang kaldaw ang agtokson ni Satanas. Ong mga kaldaw ang asi, inding pisan pamangan si Jesus tenged nagpaletem. Ig ong kaboayan linetem da tanandia. ");
INSERT INTO agn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ganing si Satanas ong nandia, “Mga yawa ka kaman tang Ana tang Dios, tobolon mo tang mga batong na ang magimong tinapay.” ");
INSERT INTO agn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Piro siminabat si Jesus, “Na-tang ong Sagradong Kasolatan, ‘Belag lamang ta ong pamangan gaboi tang taw. Kaministiran na ka tang tanan ang mga bitala tang Dios.’ ” ");
INSERT INTO agn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pagatapos ingkelan ni Satanas si Jesus ong tatang logar ang dorog kalawig, ig ong tanga papa-dek pinaita na ong ni Jesus tang tanan ang mga nasion ig mga inadian ong kalibotan. ");
INSERT INTO agn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Oman ganing si Satanas, “I-dolo ong nio tang tanan ang kagaeman ig manggad tang mga inadian ang na. Tenged ang tanan ang narin inintriga ra ong yen, ig i-dolo ong maski sinopay galiagano. ");
INSERT INTO agn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Animan ang tanan ang na magimong nio, mga lomoda ong talongano ig ilalaeno nio bilang Dios mo.” ");
INSERT INTO agn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Siminabat si Jesus, “Na-tang ong Kasolatan, ‘Ang Ampoan mong Dios lamang tang ilalaen mong Dios. Tanandia lamang tang sirbian mo.’ ” ");
INSERT INTO agn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Oman dayon sing ingkelan ni Satanas si Jesus don ong siodad tang Jerusalem, ong talibobongan tang Timplo. Ganing si si Satanas ong nandia, “Mga yawa ka kaman tang Ana tang Dios, abir, pabo-loga atan! ");
INSERT INTO agn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tenged na-tang ong Kasolatan, ‘Tobolon tang Dios tang mga anghil na para bantayana nira. ");
INSERT INTO agn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Biotana nira agod maski ang kakay mo inding pisan masigbak ong bato.’ ” ");
INSERT INTO agn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Piro siminabat sing oman si Jesus, “Na-tang ka ong Kasolatan ang ganing, ‘Indi sobokan mi tang Ampoan ming Dios.’ ” ");
INSERT INTO agn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pagatapos ang tokson din tanandia ni Satanas ong tanan ang klasi ta tokso, nagalin da lamang si Satanas ig nagelat si ta domang oras. ");
INSERT INTO agn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nagbalik si Jesus ong Galilea, ig ong nandia tang gaem tang Ispirito tang Dios. Nabantog ong tanan ang logar don tang balitang natetenged ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nagtoldok tanandia ong mga simban tang mga Judio, ig namagdayaw tang tanan ang taw ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Minolik si Jesus ong Nazaret, ang logar ang pinambaelan na. Pario tang naogalian na, asing Kaldaw dang Igperenay napaning tanandia ong simban nira. Kimindeng tanandia para magbasa tang Sagradong Kasolatan, ");
INSERT INTO agn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ig sindol ong nandia tang sinolat tang propitang si Isaias. Bino-kad na ong parting gasolatan ta maning ta na: ");
INSERT INTO agn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ong yen tang Ispirito tang Dios, tenged yo tang pinilik na para magpatako tang Mo-yang Balita ong mga malilised. Sinobolo nandia para magpatako ong mga priso ang librien da tanira, ig ong mga boray ang mangaita ra tanira. Sinobolo ka para librien tang mga agdegdegen, ");
INSERT INTO agn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ig para ipatako ang kiminabot da tang oras ang tabangan tang Dios tang banoa na!” ");
INSERT INTO agn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Oman linolon nang moman tang sinolatan, binalik na ong manigtabang ong simban, ig kiminarong tanandia para magtoldok. Dorong pa-dek ong nandia tang tanan ang taw don ong simban. ");
INSERT INTO agn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ganing si Jesus ong nira, “Ang naba-yan ming nang kasolatan, gainabo ra mandian.” ");
INSERT INTO agn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dinayaw tanandia tang tanan, ig nangabereng tanira ong mga maosay ang pamitala na. Piro ganing ka tanira, “Elat kanay! Gailala ta tang taw ang na! Ana ka lamang tanandia ni Jose!” ");
INSERT INTO agn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Animan ganing si Jesus, “Sigoradong aningen mi ong yen tang sarabien ang na, ‘Doktor, bolongon mo tang sadili mo.’ Ig aningen mi pa ka ong yen, ‘Boaten mo ka tarin ong sadiling logar mo tang pario tang nabalitan amen ang bindoat mo ong Capernaum.’ ");
INSERT INTO agn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Piro ang kamatodan, anday propitang aggilalaen ong sadiling logar na. ");
INSERT INTO agn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pario ta narin: Asing timpo tang propitang si Elias, indi kiminoran ong teled ta tolong takon may tenga, ig nagkatinir ta grabing tagletem ong bilog ang banoa. Ong timpong asi, doro kang babay ang balo tarin ong Israel. ");
INSERT INTO agn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Piro indi enged sinobol tang Dios si Elias ong nira para tomabang. Don lamang tanandia sinobol ong tatang babay ang balo ang belag ta Israelita, don ong Sarepta sakep tang Sidon. ");
INSERT INTO agn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Maning ka ta si asing timpo tang propitang si Eliseo. Doro kang may masit nirang liproso tarin ong Israel. Piro anda enged ay pinao-ya ong nira maski tambilog. Si Naaman lamang, ang taga Siria, tang pinao-ya.” ");
INSERT INTO agn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Dorong kasisilagen tang mga taw don ong simban asing pagabasi nira tang inaning ang asi ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Namansi-deng tanirang tanan ig sinolmon nira tanandia asta maloa ong lansangan. Ang lansangan nira, ga-tang ong dibabaw tang tatang bokid, ig ingkelan nira si Jesus ong binit na para ibo-log ong pangpang. ");
INSERT INTO agn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Piro nagpanaw si Jesus ong ka-ngan nira ig nagalin. ");
INSERT INTO agn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Magalin don, napaning si Jesus ong banoa tang Capernaum, sakep tang Galilea. Don si tanandia nagtoldok ong mga taw ong Kaldaw ang Igperenay. ");
INSERT INTO agn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ig nangabereng tanira ta mo-ya, tenged gitaen ong pagtoroldokon na ang may sadiling aotoridad na. ");
INSERT INTO agn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Don ka ong simban ang asi, may tatang taw ang aggaeman ta dimonio, obin malain ang ispirito. Giteg tang taw ang asi ta mapoirsa ang ganing, ");
INSERT INTO agn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aroy! Jesus ang taga Nazaret! Angay pagpalabeta ong yen? Onopa? Napaninga tarin para langgaen aming mga dimonio? Gailalā yen! Yawa tang Sagradong nagalin ong Dios!” ");
INSERT INTO agn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sinambleng ni Jesus tang malain ang ispirito ang ganing “Magipesa! Lomboā atan ong taw ang asia!” Ig ong talongan tang tanan, pinabegtak tang dimonio tang taw, oman limindoa ang indi pinasitan na. ");
INSERT INTO agn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nangabereng tang tanan ig namagampang-ampang ang ganing, “Onopa na? May aotoridad ig gaem tang bitala na! Aggordinan na lamang tang mga dimonio ang lomboa, pamagtoman ang lagi!” ");
INSERT INTO agn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ig indi naboay nabantog tang balitang natetenged ong ni Jesus ong bilog ang logar ang asi. ");
INSERT INTO agn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nagalin si Jesus ong simban ig napaning ong balay ni Simon. Na pala, ang panogangan ang babay ni Simon agkinten ta doro. Animan nagigampang tanira ong ni Jesus ang pao-yaen na kay. ");
INSERT INTO agn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Napalenget si Jesus ong silid tang aglolbogan tang mepet ig inordinan na tang kinit ang magpoas. Ig nagpoas ka kaman tang kinit na. Oman dayon dang nambangon tang mepet ig nagasikaso ong nira. ");
INSERT INTO agn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Asing gakorop da tang kaldaw, ang tanan ang may mga masit nira, maski onopang klasiay ta masit, ingkelan tang mga tangay nira ong ni Jesus. Binondo na tang kalima na ong kada tata ig pinao-ya na tanira. ");
INSERT INTO agn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Namansiloa ong kayadian tang mga dimonio. Pagaloa nira, namansiteg tang mga dimonio ang ganing, “Yawa tang Ana tang Dios!” Piro sinambleng tanira ni Jesus ig indi pinagnan ang mamagbitala, tenged gailala nirang tanandia tang Cristo. ");
INSERT INTO agn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pagaramal, nagalin si Jesus ig napaning ong tatang logar ang anday gistar ang taw. Dinilem tanandia tang mga taw, ig pagatoman nira nagpakiloy tanira ang indi kang lagi tanandia magalin. ");
INSERT INTO agn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Piro ganing si Jesus ong nira, “Kaministiran kang magtoldoko ong domang mga logar tang Mo-yang Balitang natetenged ong paggaraemen tang Dios bilang adi. Sia tang dailan animan sinobolo tarin.” ");
INSERT INTO agn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Animan nagpadayon tanandiang nagtoldok ong mga simban tang mga Judio don ong probinsia tang Judea. ");
INSERT INTO agn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tatang kaldaw napaning si Jesus ong binit tang baybay tang Talsi tang Genesaret. Dorong taw ang pamagsiriek-siekan don ong nandia, tenged gangaliliag ang mamasi tang agtotoldok nang nagalin ong Dios. ");
INSERT INTO agn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","May doroa nga bilogan ang inita ni Jesus ong dalay-dalayan tang talsi. Ang mga manigyan minabak da ig pamagbonlaw tang mga lambat nira. ");
INSERT INTO agn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ig tenged ong dorong taw, siminay si Jesus ong tatang bilog ang may nandia si Simon. Nagigampang si Jesus ang ipadistansia na kay ta ge-ley ong dalay-dalayan tang talsi. Oman kiminarong da tanandia ong bilog para magtoldok ong mga taw. ");
INSERT INTO agn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagatapos ang nagtoldok si Jesus, ganing tanandia ong ni Simon, “Palaod ita ig ita-tak mi tang mga lambat mi.” ");
INSERT INTO agn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Piro ganing si Simon, “Magino, nagdamal aming nagpatikaseg, andang pisan ay nakomit amen. Piro tenged inaning mo, sigi, palaod ita, ita-tak amen tang lambat.” ");
INSERT INTO agn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Maning ta si tang bindoat nira ig doro-dorong yan tang nakomit nira, asta alos malasik da tang lambat! ");
INSERT INTO agn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Animan linambay nira tang mga karomanan nira ang don ong domang bilog para tomabang, ig napalenget ka tang mga karomanan nira. Asing na-mok da tang doroa nga bilogan ta yan, midio tomalmed da. ");
INSERT INTO agn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pagaita ni Simon Pedro, liminod tanandia ong talongan ni Jesus ig nabitalang ganing, “Magino, palawida ong yen, tenged yo mapinagtalakeno!” ");
INSERT INTO agn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Maning ta si tang nabitala na tenged nagolpian tanandia asta ang mga karomanan na ong doro-dorong nakomit nira. ");
INSERT INTO agn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Maning ka ta si da Santiago may si Juan, ang mga ana ni Zebedeo ig kasosio ni Simon. Oman ganing si Jesus ong ni Simon, “India meled. Impisa mandian, imbis ang magyana, maekelan mo ra tang mga taw agod mamagparet tanira ong Dios.” ");
INSERT INTO agn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Animan asing napatakat da nira tang mga bilog, bino-wanan nira tang tanan ig siminabid da ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Asing don si Jesus ong tatang lansangan, napalenget tang tatang taw ang may masit nang liproso. Pagaita na ong ni Jesus, diminagpa tanandia ong talongan na ig nagpakiloy ang ganing, “Magino, gata-wananong mapao-yao nio mga galiliaga lamang.” ");
INSERT INTO agn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Bindiotan ni Jesus tang liprosong asi ig minaning, “Galiliago! Mago-yā ra!” Ig lagi-lagi nago-ya tang masit na ig nanlimpio ra tang olit na. ");
INSERT INTO agn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Piro sinoyonan tanandia ni Jesus ang ganing, “India enged mamalita maski ong ninopa. Paninga lamang ong padi ong Timplo ig ipaita mo ang yawa mo-yā ra. Oman magtorola tang bolontad ang sigon ong Katobolan ni Moises bilang pamatod ong mga taw ang nago-ya ra tang masit mo ig limpioa ra.” ");
INSERT INTO agn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Piro mas nabantog pa ka enged tang balitang natetenged ong ni Jesus. Animan mas nagdolang tang mga taw ang agpaning ong nandia para mamasi ig agod pao-yaen tang mga masit nira. ");
INSERT INTO agn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Piro madagmit si Jesus ang agpaning ong mga logar ang anday gistar ang taw para mangadi. ");
INSERT INTO agn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tatang kaldaw, asing pagtoldok si Jesus ong tatang balay, may kakarong ka don ang mga Pariseo ig mga manigtoldok tang Katobolan ni Moises. Ang mga taw ang narin namagalin ong tanan ang mga banoang sakep tang mga probinsia tang Galilea may Judea, asta ong siodad tang Jerusalem. Ig ong ni Jesus tang gaem tang Dios para magpao-ya tang may mga masit. ");
INSERT INTO agn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mintras pagtoldok si Jesus, may mga taw ang kiminabot ang pamagtoang ta tatang taw ang paralisado ang lolbog lamang ong bayan-bayan. Pagprosigir din tanirang ma-led ong balay para mapalenget nira ong ni Jesus tang taw ang asing paralisado. ");
INSERT INTO agn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Piro anday mata-liban nira tenged dorong taw don. Animan ang bindoat nira, kimina-yat tanira ong dibabaw tang balay ig binoloat nira tang katep don ong toga ni Jesus. Oman don sinonton nira tang paralisado, ang lolbog lamang ong bayan-bayan, ong talongan ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Asing itaen ni Jesus ang mapoirsa tang pagtalig nira ong nandia, ganing tanandia ong paralisado, “Tangay, pinatawad da tang mga kasalanan mo.” ");
INSERT INTO agn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pagabasi ta si tang mga manigtoldok tang Katobolan may ang mga Pariseo, namagena-ena ong sadili nira ang ganing, “Aroy! Sinopa nang panginsolto ong Dios? Dorog kabelat tang kasalanan ang na! Anday domang mapagpatawad tang mga kasalanan ta, ang Dios lamang!” ");
INSERT INTO agn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Piro gata-wanan ni Jesus tang aggisipen nira. Animan ganing tanandia, “Angay pamagisip amo ta maning atan? ");
INSERT INTO agn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ong aypa tang mas madaling yaning? ‘Pinatawad da tang mga kasalanan mo,’ obin ang maning, ‘Kendenga ig panaw’? ");
INSERT INTO agn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Animan mandian, pao-yaeno rang lagi tanandia para mapamatodano ong nindio ang yo, ang Ana ta Taw, may gaemo kaman tarin ong kalibotan para magpatawad tang mga kasalanan.” Oman ganing si Jesus ong paralisado, “Kendenga! Takanen mo tang aglolbogan mo ig molika ra.” ");
INSERT INTO agn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Oman kimindeng ang lagi tang taw ang asi ong talongan tang tanan. Sinakan na ra tang bayan-bayan na ig minolik ang pagdayaw ong Dios. ");
INSERT INTO agn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pisan ang nangabereng ig pinangeldan tang mga taw. Animan namagdayaw tanira ong Dios ang ganing, “Makabebereng tang mga bagay ang inita ta mandian!” ");
INSERT INTO agn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagatapos ta si, nagpanaw si Jesus. Inita na tang tatang manigtokot ta bois, ang aran na si Levi. Don tanandia kakarong ong paragtokotan ta bois. Ganing ong nandia si Jesus, “Impisa mandian, tomabida ra ong yen.” ");
INSERT INTO agn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ig kimindeng si Levi, bino-wanan na tang tanan ig siminabid ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nagsimpan si Levi ta mabael ang kombida ong balay na para ong ni Jesus. Yadi kang aroman nirang pamamangan ang mga manigtokot ta bois ig domang mga taw. ");
INSERT INTO agn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pagaita tang mga Pariseo may ang mga karomanan nirang manigtoldok, namagriklamo tanira ig ganing ong mga sinagpan ni Jesus, “Angay ga-pen amo ang pamangan ig panginem ong mga manigtokot ta bois ig ong domang mga mapinagtalaken?” ");
INSERT INTO agn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Piro si Jesus tang siminabat ong nira, “Ang mga taw ang anday masit nira, anday kaministiran ta doktor. Ang may mga masit lamang tang kaministiran ang bolongon. ");
INSERT INTO agn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pario ka ta si, yo, indio napaning tarin para goyano tang mga taw ang ganing anday talak nira. Napaningo ta para goyano tang mga taw ang aggakon nirang tanira mapinagtalaken agod mamagtogat tanira.” ");
INSERT INTO agn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","May mga taw ang nane-ma ong ni Jesus, “Ang mga sinagpan ni Juan, madagmit ang pamagpaletem ig pamangadi. Maning ka ta si tang mga sinagpan tang mga Pariseo. Piro ang mga sinagpan mo, angay pirmi tanirang pamamangan ig pamanginem?” ");
INSERT INTO agn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ganing ang siminabat si Jesus, “Pabetang ta may kasalan. Onopa? Maimo bato ang indi mamangan tang mga tangay tang laling ba-long kinasal mintras aroman pa nira? Mamangan ka enged tanira! ");
INSERT INTO agn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Piro komabot tang kaldaw ang komiten ong nira tang laling kinasal, ig ya ray ang oras ang tanira mamagpaletem.” ");
INSERT INTO agn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nagtorol si Jesus ong nira ta tata pang palimbawa. “Anday paglasik ta ba-long lambong para itambel na ong lomang lambong. Mga maning ta si tang boaten na, malangga lamang tang ba-long lambong, ig ang itambel ang asing ba-lo belag ka ta bagay ong lomang lambong. ");
INSERT INTO agn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ya ka, anda kay pagbetang ta ba-long bino ong lomang tereldan ang olit ta ayep ang indi ra maonat. Tenged lompok tang tereldan tenged ong ba-long bino. Oman, mailat tang bino ig indi ra mapakinabangan tang tereldan ang asi. ");
INSERT INTO agn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Animan kaministiran ang enged, ang ba-long bino ibetang ong ba-lo kang tereldan. ");
INSERT INTO agn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ig anday galiliag ang manginem ta ba-long bino mga sanay dang manginem tang naboay da, tenged yaning na, ‘Mas masabor tang naboay da.’ ” ");
INSERT INTO agn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","May tatang Kaldaw ang Igperenay, tata-lib da Jesus ong mga kakoman ang arayegen da lamang. Mintras tata-lib tanira, ang mga sinagpan na pamanlantok ta pirapang koay na oman aggeyeben nira. ");
INSERT INTO agn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pagaita tang mga Pariseo, ganing tanira, “Hoy! Mandian Kaldaw ang Igperenay. Kontra ong Katobolan tang agboaten ming asia.” ");
INSERT INTO agn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ganing si Jesus ang siminabat, “Angay? Indi gabasa mi ong Sagradong Kasolatan tang bindoat ni David asing linetem da tanandia may ang mga karomanan na? ");
INSERT INTO agn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Siminled tanandia ong balay tang Dios, nangomit tang sagradong tinapay ang nabolontad da ong Dios, ig namangan. Sindolan na pa tang mga karomanan na, maski sigon ong Katobolan, ang mga padi lamang tang poiding mamangan ta si.” ");
INSERT INTO agn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ig ganing pa si Jesus ong nira, “Yo, ang Ana ta Taw, yo tang may gaem ang maganing mga onopay poiding boaten mga Kaldaw ang Igperenay.” ");
INSERT INTO agn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","May tata sing Kaldaw ang Igperenay napaning si Jesus ong simban tang mga Judio ig nagtoldok. May tatang lali don ang pilay tang kalima nang to. ");
INSERT INTO agn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ang mga Pariseo ig ang mga manigtoldok tang Katobolan, pamagdilem ta dailan agod madimanda nira si Jesus ong mga agboaten na. Animan pamagbantay tanira mga pao-yaen na tang taw ang asi maski Kaldaw ang Igperenay. ");
INSERT INTO agn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Piro gata-wanan ni Jesus tang aggisipen nira. Animan ganing tanandia ong taw ang asing pilay tang kalima na, “Tania kay! Kendenga tani ong tokawan.” Ig liminenget ka tang lali. ");
INSERT INTO agn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Oman ganing si Jesus ong nira, “Te-maen amo yen, onopay agpagnan ong Katobolan ang poiding boaten mga Kaldaw ang Igperenay? Ang magboat ta mo-ya obin ang magboat ta malain? Magsalbar ta masig ka taw ta obin mamatay?” ");
INSERT INTO agn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pina-dekan ni Jesus tanirang tanan ong palibot na, oman minaning ong taw ang asing pilay, “Abir, yonat mo tang kalima mo.” Inonat na tang kalima na ig nago-ya ka kaman. ");
INSERT INTO agn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Piro pisan ang pinangerepan tang mga Pariseo ig ang mga manigtoldok, animan namagampang-ampang mga onopay dapat ang boaten nira ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pagatapos ta si, may kaldaw ang siminakat si Jesus ong tatang bokid. Nagdamal tanandia don ang nangadi. ");
INSERT INTO agn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagaramal, ginoyan na tang mga sinagpan na ig namilik tanandia ta tampolok may doroa ong nira, ang ginoyan nang mga apostolis na. ");
INSERT INTO agn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Narin tang mga aran nira: Si Simon ang pinaranan na ra ta Pedro, ig si Andres ang logod ni Pedro; da Santiago, Juan, Felipe, Bartolome, ");
INSERT INTO agn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, ig Santiagong ana ni Alfeo; si Simon ang pagmal ta mo-ya ong banoa nang Israel; ");
INSERT INTO agn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas ang ana ni Santiago, ig si Judas kang Iscariote ang nagimong traidor. ");
INSERT INTO agn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Siminoldak si Jesus, aroman na tang mga apostolis na, asta kiminabot ong tatang patag ang logar ang mala-bang. Don ka tang yading mga sinagpan na ig ang doro-dorong taw ang namagalin ong bilog ang Judea ig siodad tang Jerusalem, asta ong mga siodad tang Tiro ig Sidon, ang alenget ong baybay. ");
INSERT INTO agn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Namansipaning tanira don para mamasi ong ni Jesus, ig agod pao-yaen tang mga masit nira. Maski ang mga taw ang agpaliwagan ta mga malalain ang ispirito napao-ya na ka. ");
INSERT INTO agn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Animan ang tanan ang taw don pamagprosigir ang mate-lek ong nandia, tenged may gaem ang pagalin ong nandia ig namago-ya tang tanan. ");
INSERT INTO agn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pina-dekan ni Jesus tang yading mga sinagpan na ig minaning, “Masoirti among mga malilised, tenged yamo tang mabilang ong inadian tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Masoirti among mga gangaletem mandian, tenged paelenen amo. Masoirti among mga pamagini-yak mandian, tenged mangalipay amo. ");
INSERT INTO agn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Masoirti amo mga aggakigan ig agpalayasen amo ta mga taw, agginsolton ig agpakalainen natetenged ong yen, ang Ana ta Taw. ");
INSERT INTO agn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Dapat mangalipay amo ig lomo-to ong sobrang kalipay mga narin ay mainabo. Tenged dorog kasinlo tang balet ang marisibi mi don ong langit. Demdemen mi, ang agboaten nirang asia ong nindio, pario ka tang bindoat tang mga kamepet-mepetan nira ong mga propita asing tokaw. ");
INSERT INTO agn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Piro yamong mga manggaden mandian, kailo amo ka! Tenged napasaran mi ra tang kambengan mi. ");
INSERT INTO agn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ig yamong mga pamagpagosto mandian, kailo amo ka! Tenged komabot tang timpong mangaletem amo. Ig yamong gangalipay mandian, kailo amo ka! Komabot tang kaldaw ang mangapongaw amo ig mamagini-yak. ");
INSERT INTO agn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kailo amo ka mga dayawen amo tang tanan ang taw! Tenged maning ka ta si tang bindoat tang mga kamepet-mepetan nira ong mga pangambong tanira propita asing tokaw.” ");
INSERT INTO agn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Piro ganingo ong nindiong mga pamamasi, gegman mi tang mga kasoay mi. Magboat amo ta mo-ya ong mga gangasilag ong nindio. ");
INSERT INTO agn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ipangadi ming pangaloyan tang Dios tang mga pamagsompa ong nindio, ig ipangadi mi ka tang mga pamandegdeg ong nindio. ");
INSERT INTO agn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pabetang ta, mga tampalingena ong emet mo, ipatalonga mo pa tang dobali. Mga kinalaw ong nio tang takol mo, india magriklamo. I-dol mo pa tang lambong mong doma. ");
INSERT INTO agn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Oldan mi ka tang mga pama-dol ong nindio, ig mga komiten tang domang taw tang maski onopang gamit mi, indi ra bawien mi. ");
INSERT INTO agn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Boaten mi ong masig ka taw mi tang onopay galiliagan ming boaten ka nira ong nindio. ");
INSERT INTO agn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mga pagmal amo lamang ong mga taw ang pagmal ong nindio, onopa pay elaten ming balet? Tenged maski ngani ang mga mapinagtalaken pamagmal ka ong mga pamagmal ong nira. ");
INSERT INTO agn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ig mga pamagboat amo lamang ta mo-ya ong mga pamagboat ta mo-ya ong nindio, onopa kay elaten ming balet? Maski ngani ang mga mapinagtalaken pamagboat ka ta maning ta sia. ");
INSERT INTO agn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ig mga pagpaotang amo lamang ong mga taw ang gangabayad ong nindio, onopa ka tang elaten ming balet? Maski ngani ang mga mapinagtalaken ay pagpaotang ka ong kapario nirang mapinagtalaken, tenged pamanigoro ang mangabayad tanira. ");
INSERT INTO agn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Piro maning ta na tang boaten mi. Gegman mi tang mga kasoay mi ig magboat amo ta mo-ya ong nira. Magpaotang amo ig indi amo magelat ta bayad. Ong maning ta sia, dorog kabael tang risibien ming balet, ig mabilang among mga ana tang Kalawig-lawigan ang Dios. Tenged mo-ya tang Dios maski ong mga taw ang anday sasayod ta ogali ig indi gangatakong magdemdem ta otang ang nem ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Animan, magimong masine-bekanen amo, pario tang Tatay mi ong langit, ang masine-bekanen.” ");
INSERT INTO agn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Indi amo magosgar ong aroman ming taw, agod indi amo ka osgaran tang Dios. Indi amo maning ang dapat tanira silotan, agod indi amo ka silotan. Magpatawad amo ong kapario mi, agod patawaden amo tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Magtorol amo ong doma, ig oldan amo ka tang Dios. Ostong sekeb, banet, eyeg-eyegen, ig bobolik pa tang i-dol ong nindio. Tenged ang serekeban ang gamiten mi ong doma, sia ya kay ang gamiten tang Dios ong nindio.” ");
INSERT INTO agn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nagistoria pa si Jesus ong mga palimbawa. Ganing tanandia, “Poiding magantabay tang boray ong kapario nang boray? Indi! Tenged pario tanirang mabo-log ong adalem ang galoang. ");
INSERT INTO agn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Anday manigadal ang mas matako ong maistro na. Piro mga natoldokan da ngani tanandia, kapario ra ka tanandia tang maistro na. ");
INSERT INTO agn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Angay aggitaen mo tang poling tang logod mo, piro indi gitaen mo tang sadiling poling mo ang midio ra troso ong mata mo? ");
INSERT INTO agn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Monopa maning mo ong logod mo, ‘Abir, komiten ta tang poling mo.’ Piro atan ngani ong mata mo indi gitaen mo tang troso. Sinoa ra ka enged? Komiten mo kang lagi tang troso ong mata mo, agod maitā ta mo-ya ig matabangan mo tang logod mong komiten tang poling na.” ");
INSERT INTO agn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Anday masinlong papa ta ayong pamorak ta anday sayod, ig anda kay malain ang pamorak ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mailala tang kada papa ta ayo ong borak na. Tenged ang mga katenekan indi mamorak ta igos, ig ang papa ta bantol-bantol indi ka mamorak ta obas. ");
INSERT INTO agn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ang mga taw pario ra ka ta si. Ang taw ang mo-ya, poros mo-ya tang bibitala na, tenged mo-ya tang ga-tang ong popotokon na. Piro ang taw ang anday sasayod ta ogali, poros malain tang agbibitala na, tenged anda kay sasayod tang ga-tang ong popotokon na. Tenged mga onopa tang ga-tang ong popotokon ta, sia ya kay ang loloa ong anga ta.” ");
INSERT INTO agn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ganing pa si Jesus, “Angay gogoy amo ong yen ang ganing ‘Gino! Gino!’ Piro indi ka agtomanen mi tang agtotobolo ong nindio? ");
INSERT INTO agn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ang taw ang agpalenget ong yen, pamasi ig pagtoman tang agganingo ong nandia, begen amo yen mga onopay kaparioan na. ");
INSERT INTO agn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tanandia pario ta tatang taw ang nagpa-deng ta balay ang may masinlong pondasion na. Nagali tanandia ta adalem asta nakabot na tang batong pa-dengan na ta adili. Namā ig dinalanan tang balay na ta mapoirsang wi, piro indi napakedeg tang balay ang asi, tenged mabaked tang pagkaboat na. ");
INSERT INTO agn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Piro ang taw ang pamasi ong yen ang mga bitala ig pagatapos indi agboaten na, tanandia pario ta tatang taw ang nagpa-deng ta balay ang anday pondasion na. Namā ig dinalanan tang balay na ta mapoirsang wi. Dayon ang siminomba ig lobot ang nangabola-tak.” ");
INSERT INTO agn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pagatapos ni Jesus ang nagtoldok ong mga taw tang tanan ang na, napaning tanandia ong lansangan tang Capernaum. ");
INSERT INTO agn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Don may tatang kapitan tang mga sondalo ang taga Roma, ang may torobolon nang agmalen na ta mo-ya. Pagmasit tang torobolon nang narin ig agpakamo-kamo ra. ");
INSERT INTO agn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Asing mabalitan tang kapitan tang natetenged ong ni Jesus, nanobol tanandia ta pirapang mga mepet tang mga Judio para ampangan nira si Jesus ang paningan na kay ig pao-yaen na tang torobolon na. ");
INSERT INTO agn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pagakabot tang mga sinobol ong ni Jesus, dorong pakiloy nira ong nandia ig ganing tanira, “Doro kao-ya tang kapitan ang asi. Mga maimo lamang, tabangan mo kay tanandia. ");
INSERT INTO agn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tenged itang mga Judio, agmalen ita ka nandia. Pinaboatan ita pa nandia ta tatang simban.” ");
INSERT INTO agn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Animan siminabid si Jesus ong nira. Ang asing alenget da tanira ong balay tang kapitan, nanobol tang kapitan ong mga tangay na ang bagaten kay nira si Jesus. Sinoyonan na tanira ang ganing, “Aningen mi patigayon ang indi ra magpabedlay tanandia. Belago ta bagay ang magrisibi ong nandia ong balay amen. ");
INSERT INTO agn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ig belago ka ta bagay ang tomalonga ong nandia. Piro maski mitala ra lamang tanandia, mago-ya ra tang torobolono. ");
INSERT INTO agn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gata-wanano, tenged maski yo, pagpasakepo ong mga alalawig ang pangolokolo. Ig may gasakepano kang mga sondalo. Mga aningeno tang tata, ‘Panawa!’ panaw ka tanandia. Ig ong tata, ‘Tania!’ lelenget ka tanandia. Ig mga ong kirepeno, ‘Boaten mo na!’ maning ka don tang agboaten na.” ");
INSERT INTO agn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nabereng si Jesus asing pagabasi na tang sinoyon tang kapitan. Ig siminalonga ong doro-dorong taw ang pamansitabid ong nandia ig minaning, “Ong matod, maski ngani ong yaten ang mga Israelita, indio pa gabagat ta taw ang maning ta na kabael tang pagtalig na.” ");
INSERT INTO agn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pagaolik tang mga sinobol tang kapitan, inita nirang mo-ya ra tang torobolon. ");
INSERT INTO agn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pagatapos ta si, napaning si Jesus ong tatang banoa ang aggoyan ta Nain. Siminabid ong nandia tang mga sinagpan na ig ang doro-dorong taw. ");
INSERT INTO agn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Asing gingabot da tanira ong lansangan, nabagat nira tang dorong taw ang loloa ang pamaglebeng ta patay. Na bogtong ang anang lali tang tatang babay ang balo. ");
INSERT INTO agn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pagaita tang Gino ong nanay tang napatay, dorong katete-beken na ig ganing ong babay, “India ra magini-yak.” ");
INSERT INTO agn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Napalenget si Jesus ig bindiotan na tang bayan-bayan ang agbe-tangan tang patay ig siminareng ka tang mga pamagtakan. Oman ganing si Jesus ong patay, “Mambangona ra.” ");
INSERT INTO agn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nambangon kaman tang patay ig minitala. Oman ganing si Jesus ong nanay, “Nani ra tang ana mo.” ");
INSERT INTO agn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pisan ang pinangeldan tanirang tanan ig namagdayaw tanira ong Dios ang ganing, “Indi enged galipatan tang Dios tang banoa na. Pinapaning na ong yaten tang tatang makagagaem ang propita!” ");
INSERT INTO agn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ig ang balitang narin ang natetenged ong ni Jesus nabantog ong bilog ang Judea asta ong mga logar ang alelenget don. ");
INSERT INTO agn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ang tanan ang nang gainabo, agbebeg ong ni Juan tang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Animan ginoyan na tang doroa ong nira ig pinapaning na ong Gino para te-maen nira mga tanandia ra kaman tang aggelaten ang komabot, obin mga may domang komabot ang dapat elaten pa. ");
INSERT INTO agn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pagakabot nira ong ni Jesus, ganing tanira, “Agtobolon ami ni Juan ang Manigboniag para mane-ma ong nio mga yawa ra tang aggelaten, obin magelat ami pa ta doma.” ");
INSERT INTO agn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mandian, naton ong oras ang asi dorong pinao-ya ni Jesus ang mga pamagmasit, ang mga agpanliwagan ong mga masit nira, ig ang mga aggaeman ta malalain ang ispirito. Pinao-ya na ka tang mga boray. ");
INSERT INTO agn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Animan ganing si Jesus ong mga sinobol, “Magbalik amo ong ni Juan ig ibalita mi tang tanan ang inita mi ig naba-yan mi. Ibeg mi ong nandia nga ang mga boray gangaita ra, ang mga pilay gangapanaw da, ang mga bengel gangabasi ra, ang mga liproso mo-ya ra, asta ang mga patay nangaboi rang oman. Ig agpatako ra ong mga malilised tang Mo-yang Balita. ");
INSERT INTO agn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Masoirti tang taw ang indi pagdoadoa tang nem na ong yen!” ");
INSERT INTO agn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pagapagalin tang mga sinobol ni Juan, minitala si Jesus ong mga taw natetenged ong ni Juan ang ganing, “Asing napaning amo don ong logar ang anday gistar ang taw, onopay galiliagan ming itaen don? Tatang kirib ang aggeyepen ta mageyep? Belag! ");
INSERT INTO agn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Piro onopa enged tang galiliagan ming itaen don? Tatang taw ang pagtok ta masinlong lambong? Belag ka! Tenged ang mga pamagtok ta masisinlong lambong ig pamagpagosto tang tanan ang kaliagan nira, don pamansistar ong mga palasio tang mga adi. ");
INSERT INTO agn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Animan onopa enged tang galiliagan ming itaen? Tatang propita? Ee. Propita ka kaman. Ig begen amo yen, sobra pa ong propita tang inita mi don. ");
INSERT INTO agn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tenged si Juan yay ang agsambiten tang Dios ong Sagradong Kasolatan, ang ganing: ‘Tobolono tang yen ang torobolon ang tongkaw ong nio, para simpanen na tang paranawan mo.’ ");
INSERT INTO agn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Agganingo ong nindio, anday nataw ong ta-paw tang kalibotan ang gilalaen ang mas alawig pa ong ni Juan ang Manigboniag. Piro ang maski sinopay gasakepan da tang inadian tang Dios, maski tanandia tang ipabetang ang kadibabakan ong tanan, mas alawig pa ka enged tang pagkabetang na ong ni Juan.” ");
INSERT INTO agn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Dorong mga taw ig maski ngani ang mga manigtokot ta bois namamasi ong mga bitala ni Jesus. Tanirang tanan namagtoman ong tobol tang Dios ang asing namagpaboniag tanira ong ni Juan. ");
INSERT INTO agn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Piro ang mga Pariseo ig ang mga manigtoldok tang Katobolan, indi maliag ang magtoman tang kaliagan tang Dios. Indi tanira magpaboniag ong ni Juan. ");
INSERT INTO agn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Oman ganing si Jesus, “Yamong mga taw ong timpong na! Onopa tang kaparioan mi? ");
INSERT INTO agn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ang kaparioan mi mga mamolang pamansikarong ong plasa ig pamansiteg ong mga kakayam nira ang ganing, ‘Sinogtogan amo yamen ta tipano piro indi amo mamagtayaw! Namagkanta ami ta mapongaw piro indi amo ka mamagini-yak!’ ");
INSERT INTO agn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Maning amo enged atan. Tenged pagkabot ni Juan ang Manigboniag, inita ming pagpaletem tanandia ig indi panginem ta irinemen, piro ganing amo, ‘Aggaeman tanandia ta malain ang ispirito!’ ");
INSERT INTO agn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Oman yo, ang Ana ta Taw, kiminabot ang pamangan ig panginem, ig ganing amo ka, ‘Telekan mi tang taw ang na! Takaban ig manigpabaleng! Ang mga tangay na poros manigtokot ta bois ig domang mga mapinagtalaken!’ ");
INSERT INTO agn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Piro maski maning ta sia tang agganing mi, ang kinata-wanan tang Dios itaen pa ka enged ang matod ong kaboi tang mga taw ang pamagtoman ong nandia.” ");
INSERT INTO agn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mandian may tatang Pariseong nangimbitar ong ni Jesus para mamangan ong balay na. Animan napaning si Jesus don ig liminopa-pak ong silid tang lamisan, sigon ong naogalian nira mga mamangan. ");
INSERT INTO agn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ong lansangan kang asi, may tatang babay ang bantog ang bisiosa. Nabalitan nang si Jesus don mamangan ong balay tang Pariseo. Animan napaning tang babay don ang pagekel ta pabanglo ang agbe-tang ong tatang tereldan ang boat ong batong midio marmol. ");
INSERT INTO agn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Liminenget tanandia ong boko-boko ni Jesus ong parting kakayan na. Pagini-yak tang babay ig nalbay tang lok na tang mga kakay ni Jesus. Oman sinrapoan na tang mga kakay ni Jesus tang boa na. Pagatapos, initongan na tang kakay na ig binaniosan na tang pabanglong ekel na. ");
INSERT INTO agn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Asing itaen tang Pariseong nangimbitar ong ni Jesus, ganing tanandia ong sadili na, “Mga matod ang propita tang taw ang na, nata-wanan nang lagi mga onopang klasiay ta babay tang pagapros ong nandia. Tatang mapinagtalaken!” ");
INSERT INTO agn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Piro gata-wanan ni Jesus tang aggisipen tang Pariseo animan ganing ong nandia, “Simon, may istoriao rin ong nio.” Siminabat si Simon, “Onopa si, Maistro?” ");
INSERT INTO agn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ganing si Jesus, “May doroang taw ang nangotang ong manigpaotang. Ang tata, 500 koartang dinario tang naotang na, ig ang tata, 50 dinario lamang. ");
INSERT INTO agn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Asing indi tanira mabayad, pinasinsia ra tanira tang nagpaotang. Mandian, sinopa ong nirang doroa tang mas mabael ang gegma ong nagpaotang?” ");
INSERT INTO agn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Siminabat si Simon, “Ong yen lamang, ang pinasinsia na ang mas mabael ta otang.” Siminabat ka si Jesus, “Tama kaman tang inaning mo.” ");
INSERT INTO agn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Oman minalied si Jesus ong babay ig ganing ong ni Simon, “Gitaen mo ka tang babay ang na? Siminledo ong balay mi ig indio sindolan mo ta wi para yogato ong kakayo. Piro tanandia limbay na tang lok na tang kakayo, ig sinrapoan na pa tang boa na. ");
INSERT INTO agn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Indio ka initongan mo bilang pakomosta ong yen, piro impisa asing kiminabot tanandia, indi napenay tang pagitong na ong mga kakayo. ");
INSERT INTO agn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Indi bino-bokan mo ta langis tang yen ang kolo, piro tanandia bino-bokan na ta pabanglo tang mga kakayo. ");
INSERT INTO agn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Animan, agganingo ong nio, ang mabael ang paggegma ang pinaita na ong yen pagpamatod ang pinatawad da tanandia tang yading kasalanan na. Piro ang taw ang pinatawad ong mga talak nang ge-ley lamang, ge-ley ka tang paggegma ang ipaita na.” ");
INSERT INTO agn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Oman ganing si Jesus ong babay, “Pinatawad da tang mga talak mo.” ");
INSERT INTO agn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Animan ang mga aroman nang pamamangan namane-ma ong sadili nira, “Sinopa enged tang taw ang na, ang pagpatawad ta mga talak!” ");
INSERT INTO agn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ig ganing si Jesus ong babay, “Nalibria tenged ong pagtalig mo. Molika ra ig aloyana enged tang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pagatapos ta si, naglibot si Jesus ong mga lansangan asta ong mga kababarioan ang pagpatako tang Mo-yang Balita natetenged ong paggaraemen tang Dios bilang adi. Aroman na tang tampolok may doroang apostolis na, ");
INSERT INTO agn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","asta ang pirapang mga babay ang pinao-ya na ong mga masit nira tanopa sia ig pinalinan na tang malalain ang ispirito. Tata ong nira si Maria ang aggoyan ta Magdalena, ang pinalinan na ta pitong dimonio. ");
INSERT INTO agn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tata ka si Juana, ang katawa ni Cusa, ang agtaligan ong pamalay-balay tang ading si Herodes. Asta si Susana, ig yadi pa. Ang mga babay ang na, aggamiten nira tang sadiling koarta nira para ong mga kaministiran da Jesus may ang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Masigkabotay tang mga taw ang pamagalin ong kada logar nira ang pamansipaning ong ni Jesus. Asing namagirimbeng-imbeng da tang doro-dorong taw, nagistoria ra si Jesus ong nira tang palimbawang na. Ganing tanandia, ");
INSERT INTO agn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“May tatang taw ang napanaw ong koma na para magta-bol ta binik. Ong pagtara-bolon na, may mga binik ang nabo-log ong dalan. Galiked-likedan ta taw ig sinompit ta lamlam tang mga binik ang asi. ");
INSERT INTO agn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","May mga binik kang nabo-log ong kabatoan. Pagalongay na, nangalanet ang lagi tenged marang lagi tang tanek. ");
INSERT INTO agn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ang domang binik nala-sik ong kaibabawenan ang tenekan. Pario tanirang nambael ig dineg tang mga ibabawen tang ba-long namansilongay. ");
INSERT INTO agn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","May doma pa enged ang binik ang nabo-log ong matambek ang tanek. Liminongay ig namorak ta tang gatos ang pasi kada koay na.” Oman pinabael ni Jesus tang bosis na ig minaning, “Mamasi tang may talinga!” ");
INSERT INTO agn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pagatapos ta si, nane-ma ong ni Jesus tang mga sinagpan na mga onopa tang maliag yaning tang palimbawa nang asi. ");
INSERT INTO agn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ganing si Jesus ang siminabat, “Ang mga sikrito natetenged ong inadian tang Dios, agbebego ra ong nindio mandian para maintindian mi. Piro ong doma, ang agtotoldoko poros lamang ong palimbawa, agod maski mamansipa-dek tanira, indi ka mangaita. Ig maski mamamasi, indi ka mangaintindi.” ");
INSERT INTO agn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Narin tang maliag yaning tang istoria. Ang binik, yay ang bitala tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mandian, ang mga binik ang nailat ong dalan, yay ang mga taw ang pamamasi tang bitala tang Dios, piro dadaton ang lagi si Satanas ig agkomiten na tang bitala ang naloak da ong popotokon nira agod indi tanira mamagparet ig indi mangalibri. ");
INSERT INTO agn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ang mga binik ang nabo-log ong kabatoan, yay ang mga taw ang pamamasi tang bitala ig agrisibien ang lagi nira ang may kalipay. Piro tenged belag ta de-dek ong popotokon nira, indi lamang maboay tang pagto nira. Mga komabot tang kaliwagan ig pagsobok, dayon ang laging bo-wanan nira tang pagto nira. ");
INSERT INTO agn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ang mga binik ang nangala-sik ong kaibabawenan, pario ka mga may taw ang pamamasi tang bitala tang Dios, piro mintras gaboay, pamagpaborido ong yading irintindien nira ig gaekelan ong manggad nira may bisio. Animan ang bitala tang Dios andang pisan ay borak na ong kaboi nira. ");
INSERT INTO agn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Piro ang binik ang nabo-log ong matambek ang tanek, yay ang mga taw ang pagabasi nira tang bitala tang Dios, agloloak ang lagi nira ong nirang limpiong popotokon. Animan pamagpadayon tanira ong pagto nira asta ang bitala may masinlong borak na ong kaboi nira.” ");
INSERT INTO agn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ganing pa si Jesus, “Anday pagsindi ta kingki oman dapan na ta gantangan, obin i-tang na ong adalem tang katri. Kondi don lamang ong borondoan na para mga tenled tang mga taw, mayag ang lagi. ");
INSERT INTO agn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Anday gatalok ang indi ipaita, ig anda kay sikritong indi mata-wanan ong ori ig maintindian ka enged. ");
INSERT INTO agn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Mamasi amo ta mo-ya. Tenged ang sinopay may gata-wanan na natetenged ong Dios, dolangan pa. Piro ang sinopay anday gata-wanan na, maski gisipen nang may gata-wanan na, sia komiten pa ka enged ong nandia.” ");
INSERT INTO agn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Maboay-boay ta ge-ley, kiminabot tang nanay ni Jesus may ang mga logod na. Piro indi tanira mangalenget tenged dorong taw. ");
INSERT INTO agn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oman may minaning ong ni Jesus, “Asia ong loa tang nanay mo ig mga logod mo. Agdilemena nira.” ");
INSERT INTO agn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Piro siminabat si Jesus ang ganing, “Ang sinopay pamamasi ig pamagtoman tang bitala tang Dios, tanira yay ang agbibilango ang nanayo ig mga logodo.” ");
INSERT INTO agn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tatang kaldaw ganing si Jesus ong mga sinagpan na, “Maytara! Paning ita ra ong dobaling baybay.” Animan namansitay tanira ong bilog nirang mabael ig namansilarga. ");
INSERT INTO agn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mintras lalayag da tanira, napoyat si Jesus. Golpi tanirang kinabotan ta tampo ig ge-ley da lamang ma-mokan tang bilog ang agtayan nira. Dilikado ra tang pagkabetang nira. ");
INSERT INTO agn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Animan pinalengetan si Jesus tang mga sinagpan na ig pinoaw. Ganing tanira, “Magino, magino! Mapatay ita ra!” Nambangon si Jesus, ig sinambleng na tang mageyep asta ang mababael ang langeb. Ig dayon ang nagpoas tang tampo ig golpi rang naglinaw. ");
INSERT INTO agn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Oman ganing si Jesus ong mga sinagpan na, “Ong ayra tang pagtalig mi?” Piro pisan tanirang pinangeldan ig nangabereng ta mo-ya, animan namagtere-ma te-man ang ganing, “Sinopa enged bato tang taw ang na? Gatobol na tang mageyep asta ang langeb, ig pagtoman ong nandia!” ");
INSERT INTO agn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kiminabot da tanira ong logar tang mga Geraseno, ong dobali tang Galilea. ");
INSERT INTO agn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pagataboan ni Jesus, binagat ang lagi tanandia ta tatang taga lansangan ang aggaeman ta malain ang ispirito. Naboay dang indi ra pagto-tok ta lambong ig indi ra gistar ong balay nira. Don da lamang gistar ong mga pantion ong simintirio. ");
INSERT INTO agn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pagaita na ong ni Jesus, liminod ong talongan na ig miniteg ta mapoirsa ang ganing, “Jesus, Ana tang Kalawig-lawigan ang Dios! Onopay boaten mo ong yen? Mate-beka kay ong yen. Indio ka papagpinitinsiaen mo!” ");
INSERT INTO agn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Maning ta si tang bitala tang malain ang ispirito tenged sinobol da ni Jesus ang lomboa ra ong taw. Ang taw pirming aggawidan tang malain ang ispirito. Maski talikalan tang kalima na may kakay na ig bantayan, gabontok na ka enged tang mga talikala, ig agge-lan tanandia tang dimonio ong mga logar ang anday tataw na. ");
INSERT INTO agn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mandian, sine-ma ni Jesus tang malain ang ispirito, “Sinopay aran mo?” Siminabat tang malain ang ispirito, “Ang arano si Rinibo.” Tenged rinibo tang mga dimoniong siminled ong taw ang asi. ");
INSERT INTO agn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ig sigi lamang tang pakiloy tang mga dimonio ong ni Jesus ang indi tanira tobolon nang paning ong kaidaleman ang anday kataposan. ");
INSERT INTO agn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mandian, don ong takatan tang tatang bokid ang alenget-lenget, dorong mga baboy ang pamanoliad. Animan namagpakiloy tang mga malalain ang ispirito ong ni Jesus ang pa-leden na ra lamang don ong mga baboy ang asi. Ig pinagnan na tanira. ");
INSERT INTO agn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Limindoa ong taw tang mga dimonio ig namansi-led da ong mga baboy. Oman ang mga baboy diritsong namagsinikad ong pangpang ig nangabo-log ong talsi asta nangalmet ang tanan. ");
INSERT INTO agn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pagaita tang mga mamanigsagod tang baboy tang nainabo, namagsinikad tanira ig binalita nira ong lansangan asta ong mga kababarioan. ");
INSERT INTO agn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Animan namansipaning tang mga taw don para telekan mga onopa enged ay nainabo. Pagakabot nira don ong ni Jesus, kinabotan nira tang taw ang dating aggaeman tang mga dimonio. Kakarong tanandia ong may kakayan ni Jesus, paglambong da ig mo-ya ra tang isip na. Animan pinangeldan tanira. ");
INSERT INTO agn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Inistoria si ong nira tang mga nangaita mga monopa nago-ya tang taw ang dating aggaeman tang mga dimonio. ");
INSERT INTO agn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Oman ang tanan ang mga Geraseno namagpakiloy ong ni Jesus ang magalin da tanandia don ong logar nira, tenged pangeldan dang pisan tanira. Animan siminay da si Jesus ong bilog nirang mabael para magalin. ");
INSERT INTO agn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nagpakiloy tang taw ang dating sinled tang mga dimonio ang patabiden na kay, piro pinaolik tanandia ni Jesus ang ganing, ");
INSERT INTO agn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Molika ra ong nindio, ig ibalita mo tang bindoat tang Dios ong nio.” Animan minolik da tang taw ig binalita na ong tanan ang taw ong lansangan tang bindoat ong nandia ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mandian, nagbalik si Jesus ong Capernaum. Binagat ig rinisibi tanandia ta masinlo ta doro-dorong taw ang pamagelat ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kiminabot ka tang tatang lali, ang aran na si Jairo, tatang pangolokolo ong simban tang mga Judio. Diminagpa ong talongan ni Jesus ig nagpakiloy ang paning kay si Jesus don ong balay nira, ");
INSERT INTO agn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tenged agpakamo-kamo ra tang bogtong ang ana nang babay, ang magdosi anios pa lamang tang idad na. Mandian, asing agpaning da don si Jesus, agsagesen tanandia tang dorong taw ang pamansitabid. ");
INSERT INTO agn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","May tata kang babay don ong mga taw ang pagdogo-dogo ong teled da ta tampolok may doroang takon. Anday nabolong ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Napalenget tang babay ong boko-boko ni Jesus ig sine-lek na tang kapotan tang lambong na. Nagpoas ang lagi tang pagdogo-dogo na. ");
INSERT INTO agn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nane-ma si Jesus, “Sinopay simine-lek ong yen?” Asing anday nagbeg, ganing si Pedro, “Magino, galibotan ita ig agsagesen ita ta dorong taw!” ");
INSERT INTO agn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Piro ganing si Jesus, “May simine-lek ong yen. Naba-yagano ang may poirsang limindoa ong yen.” ");
INSERT INTO agn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Asing mata-wanan tang babay ang indi pala matalok tang bindoat na, pangelel ang napalenget ong ni Jesus. Diminagpa ong may kakayan na ig don ong talongan tang tanan ang taw bineg nang angay sine-lek na si Jesus, ig monopa tanandia nago-yang lagi. ");
INSERT INTO agn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Oman minaning si Jesus ong nandia, “Babay, ang pagtalig mo tang nagpao-ya ong nio. Molika ra ig aloyana enged tang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Asing bibitala pa si Jesus, may kiminabot ang nagalin ong balay tang pangolokolo ang si Jairo, ig ganing ong nandia, “Maski indi ra bedlayen ta tang Maistro. Ang ana mo anda ra.” ");
INSERT INTO agn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pagabasi ni Jesus, ganing tanandia ong ni Jairo, “India magsinti. Magtaliga lamang ong yen ig mago-ya tanandia.” ");
INSERT INTO agn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Oman nagdayon da da Jesus ong balay ni Jairo. Pagakabot nira don, anday pina-led ni Jesus kondi si Pedro, si Juan, si Santiago ig ang mga ginikanan tang mola. ");
INSERT INTO agn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pamagini-yak tang tanan don ig agdayagan da nira tang mola. Ganing si Jesus, “Indi amo mamagini-yak. Belag tanandia ta patay. Gapoyat lamang.” ");
INSERT INTO agn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Piro inimodan lamang nira si Jesus, tenged ang gata-wanan nira, patay da tang mola. ");
INSERT INTO agn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Animan pinaloa na tanirang tanan. Oman bindiotan na tang kalima tang mola ig ganing, “A-ing, mambangona ra.” ");
INSERT INTO agn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nagbalik tang linawa na ig nambangon ang lagi. Oman ganing si Jesus, “Papanen mi ra tang mola.” ");
INSERT INTO agn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pisan ang nabereng tang mga ginikanan tang mola, piro sinoyonan tanira ni Jesus ang indi mamalita maski ong ninopa tang nainabo. ");
INSERT INTO agn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tatang kaldaw, sinimet ni Jesus tang tampolok may doroang apostolis na ig sindolan na tanira ta gaem ig podir ang magpalayas tang tanan ang mga dimonio ig magpao-ya ta mga masit. ");
INSERT INTO agn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Oman sinobol na tanira para magpatako tang natetenged ong paggaraemen tang Dios bilang adi, ig para magpao-ya tang may mga masit nira. ");
INSERT INTO agn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Sinoyonan na ka tanira ang ganing, “Ong pagpanaw mi indi amo mamagekel ta maski onopa. Maski baston, maski binagteng, maski pamangan, maski koarta, ig maski lambong ang irimaran. ");
INSERT INTO agn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mga komabot amo ong tatang logar ig mga padayonon amo ong tatang balay, don amo lamang magtinir mintras indi amo pa pagalin ong logar ang asi. ");
INSERT INTO agn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Piro mga maning amo ong tatang logar ang indi amo risibien tang mga taw don, magalin among lagi ig tapokon mi tang kolapok ong mga kakay mi, para ipaita ming anda ray sarabaten mi ong nira.” ");
INSERT INTO agn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Oman namansipanaw da tang tampolok may doroang apostolis. Linibot-libot nira tang mga kababarioan ang pamagpatako tang Mo-yang Balita ig pamagpao-ya tang may mga masit maski ong aypa. ");
INSERT INTO agn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mandian si Herodes, ang pangolokolo ong Galilea, nabalitan na tang tanan ang gainabo, animan nagoloan tang pagirisipen na. Tenged may pamaganing ang naboing oman ono si Juan ang Manigboniag. ");
INSERT INTO agn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","May pamaganing kang napaita si Elias, ig may pamaganing pa kang binoi ono tang tata ong mga propita asing tokaw. ");
INSERT INTO agn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Animan ganing si Herodes, “Pinapotolano ta likel si Juan. Oman sinopa bato tang taw ang na? Dorong gaba-yano natetenged ong nandia!” Ig dorong prosigir ni Herodes ang itaen na si Jesus. ");
INSERT INTO agn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pagabalik tang mga apostolis ni Jesus, binalita nira ong nandia tang tanan ang mga bindoat nira. Pagatapos, ingkelan tanira ni Jesus ong tatang logar ang anday gistar ang taw, sakep tang banoang aggoyan ta Betsaida. Anday domang pinatabid na. ");
INSERT INTO agn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Piro asing pagatako tang mga taw, dinaton si nira da Jesus. Ig masinlo tang pagrisibi na ong nira. Sinoldokan na tanira natetenged ong paggaraemen tang Dios bilang adi, ig pinao-ya na tang mga pamagmasit ong nira. ");
INSERT INTO agn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Asing gakorop da tang kaldaw, namampalenget ong nandia tang tampolok may doroang mga apostolis na, ig ganing tanira, “Narin ita ong tatang logar ang anday gistar ang taw. Mo-ya pa sigoro, papaningen mo ra tang mga taw ong mga bario ig mga sitio ang alenget-lenget para mamandilem ta mapangan ig madayonan nira.” ");
INSERT INTO agn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Piro siminabat si Jesus, “Yamo tang magtorol ta mapangan nira.” Ganing ka tang mga sinagpan na, “Aroy, monora bato? Lima ka lamang bilog ang tinapay ig doroa ka lamang bilog ang yan tang ekel ta! Poira mga panaw aming mamakal ta mga pamangan para ong tanan ang taw ang na.” ");
INSERT INTO agn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Maning ta na tang inaning nira tenged ang mga lali don limang ribo rang lagi. Oman, ganing si Jesus ong mga sinagpan na, “Pakarongon mi tanira ta gropo-gropo ig taglilimampolok.” ");
INSERT INTO agn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Maning ka ta si tang bindoat nira, ig pinakarong nira tang tanan. ");
INSERT INTO agn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kinomit ni Jesus tang limang bilog ang tinapay may ang doroang bilog ang yan. Siminingara tanandia ong langit ig nagpasalamat ong Dios. Oman pinisi-pisi na si ig sindol na ong mga sinagpan na para itagtag ong mga taw. ");
INSERT INTO agn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nangapamangan tang tanan ang taw ig poros nangaelen. Pagatapos, sinimet tang mga sinagpan na tang nanga-dang tinapay may yan, ig nanga-mok pa tanira ta tampolok may doroang tiklis. ");
INSERT INTO agn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tatang kaldaw, asing si Jesus pangadi ang tanandia lamang, ang mga sinagpan na don kang alenget. Oman nane-ma ong nira si Jesus ang ganing, “Gonopa tang mga taw natetenged ong yen? Yo, sinōpa ono?” ");
INSERT INTO agn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Siminabat tanira, “Ganing tang doma, yawa ono si Juan ang Manigboniag. Ang doma ganing ka, yawa ono si Elias. Ig ganing pa ka tang doma, yawa ono tatang propita asing tokaw ang naboi mandian.” ");
INSERT INTO agn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ig ganing si Jesus ong nira, “Piro mga ong nindio, yo sinōpa?” Ang siminabat si Pedro, “Yawa tang Cristo, ang pinilik tang Dios para maggaem ong tanan!” ");
INSERT INTO agn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Oman maelet ang sinoyonan ni Jesus tang mga sinagpan na ang indi enged mamagbeg maski ong ninopa ang tanandia tang Cristo. ");
INSERT INTO agn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ig ganing pa tanandia ong nira, “Yo, ang Ana ta Taw, kaministiran ang mapasarano tang tanan ang kaliwagan ang boaten ong yen tang mga taw. Indio ilalaen tang mga mepet tang banoa, ang mga pangolokolo ong mga padi, ig ang mga manigtoldok tang Katobolan. Kaministiran ang patayeno, piro ong ya-long kaldaw maboiong moman.” ");
INSERT INTO agn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Oman ganing tanandia ong nirang tanan, “Ang sinopay galiliag ang tomabid ong yen, kaministiran ang lipatan na tang sadili na ig magosoy ong yen kaldaw-kaldaw, maski kamatayen pa tang talongaen na ong pagtoman na ong yen. ");
INSERT INTO agn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tenged ang taw ang agpalabien na tang kaboi na tarin ong ta-paw tang kalibotan, tanandia tang malipatan tang kaboi na. Piro ang sinopay magbolontad tang kaboi na para ong yen, tanandia tang marisibi ta kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Onopa enged ay mapakinabangan ta tatang taw maski magimong nandia ra tang tanan ang bagay tarin ong kalibotan, piro malipat ka ong nandia tang kaboi na? Anda! ");
INSERT INTO agn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Animan ang taw mga agkakaeyako nandia ig ang yen ang mga bitala, tanandia ikaeyako ka ong pagbaliko tarin. Tenged yo, ang Ana ta Taw, magbaliko tarin ong kalibotan ong mabael ang kayagano, ig ong kayagan tang yen ang Tatay, asta ang kayagan ka tang mga sagradong anghil. ");
INSERT INTO agn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tandan mi narin: Ang doma tarin ong nindio mandian, kabotan pa nira tang kaldaw ig itaen nira ang paggaem da tang Dios bilang Adi ong tanan.” ");
INSERT INTO agn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mga walong kaldaw da pagatapos ang inaning ni Jesus tang mga bagay ang na, kimina-yat tanandia ong tatang bokid para mangadi. Pinatabid na da Pedro, Juan ig Santiago. ");
INSERT INTO agn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mintras pangadi tanandia, nagoman tang itsora na ig naningolit tang lambong na ang pisan ang sisinggat. ");
INSERT INTO agn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Oman golping may napaita ang doroang taw ang pamagigampang ong ni Jesus. Asi pala, si Moises ig si Elias. ");
INSERT INTO agn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pisan ka tanirang sisinggat. Pinagampangan nira tang galenget dang kamatayen ni Jesus ang mainabo ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ang oras ang asi, manek tang poyat ni Pedro may ang mga karomanan na. Piro pagapoaw nira, inita nira tang kayagan ni Jesus ig ang doroang taw ang ke-deng ong tepad na. ");
INSERT INTO agn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Asing magalin da ong ni Jesus tang doroang taw, ganing si Pedro ong nandia, “Magino, masinlong narin ami! Magboat ami ta tolo nga payag-payagan. Tata para ong nio, tata ong ni Moises ig tata ong ni Elias.” Ong matod, indi gata-wanan ni Pedro tang agbibitala na. ");
INSERT INTO agn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Asing bibitala pa si Pedro, may tatang onom ang golping napababak ig binongot tanira tang onom ang asi. Animan ang mga sinagpan pisan ang pinangeldan. ");
INSERT INTO agn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Oman may tatang bosis ang naba-yan nirang nagalin don ong onom ang ganing, “Na tang yen ang Ana, ang yen ang pinilik. Mamasi amo ong nandia!” ");
INSERT INTO agn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Asing napenay da tang bosis, anda ray inita nirang domang taw, si Jesus da lamang. Ig mintras aroman pa nira si Jesus, indi kang lagi bineg nira ong maski ninopa tang inita nira don ong bokid. ");
INSERT INTO agn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pagaramal, pagatoldak da Jesus, binagat tanira ta doro-dorong taw. ");
INSERT INTO agn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","May tatang lali don ong kayadian ang miniteg ta maning ta na, “Maistro, mate-beka kay! Telekan mo kay tang anao ang lali. Ya ka lamang paman ay anao! ");
INSERT INTO agn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Aggaeman tanandia ta malain ang ispirito, ig kada kaboton, golpi ra lamang giteg. Agpapeleg-pelegen tanandia asta bomokal da tang anga na. Agpaliwagan da ta mo-ya tang malain ang ispirito ig alos indi ra bo-wanan na. ");
INSERT INTO agn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nagpakiloyo ra ong mga sinagpan mong palayasen kay nira tang dimonio, piro indi mapalayas nira.” ");
INSERT INTO agn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Siminabat si Jesus, “Ay, yamong mga taw amo! Andang pisan ay pagtalig mi ig matetegat tang kolo mi! Asta tanopa tang agoantao ig tiniro ong nindio? Abir, ekelan mo tani tang ana mo.” ");
INSERT INTO agn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Asing agpalenget tang mola, pinabegtak tanandia ong tanek ig pinapeleg-peleg tang malain ang ispirito. Oman dayon ang sinambleng ni Jesus tang ispirito. Pinao-ya na tang mola ig inintriga na ong tatay na. ");
INSERT INTO agn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ig nangabereng tang tanan ang taw ong gaem tang Dios. Asing gangabereng pa tang mga taw ong tanan ang bindoat ni Jesus, ganing tanandia ong mga sinagpan na, ");
INSERT INTO agn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tandan mi enged tang mga bitalao ang na. Yo, ang Ana ta Taw, traidorono ig yintrigao ong gaem tang mga taw.” ");
INSERT INTO agn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Piro indi naintindian tang mga sinagpan na tang mga bitala nang na. Tenged midio may pagdapa pa ong mga kinaisipan nira agod indi mangaintindi. Ig pangelba ka tanirang mane-ma ong ni Jesus tang maliag nang yaning. ");
INSERT INTO agn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pamagdiskosionan tang mga sinagpan ni Jesus mga sinopa ong nira tang kaimportantian. ");
INSERT INTO agn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Gata-wanan ni Jesus tang aggisipen nira, animan ginoyan na tang tatang mola don ig pina-deng na ong silid na. ");
INSERT INTO agn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Oman ganing tanandia ong mga sinagpan na, “Ang magrisibi ong molang na tenged ong yen, pagrisibi ka ong yen. Ig ang pagrisibi ong yen, sia pagrisibi ka ong nanobol ong yen. Ang kadibabakan ong nindiong tanan, tanandia tang kaimportantian.” ");
INSERT INTO agn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pagatapos, ganing si Juan ong ni Jesus, “Magino, may inita amen ang tatang taw ang pagpalayas ta mga malalain ang ispirito ig aggamiten na tang aran mo. Binawalan amen tenged belag ta karomanan ta.” ");
INSERT INTO agn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Piro ganing si Jesus, “Indi bawalen mi. Tenged ang taw ang indi kokontra ong yaten, maliag yaning tanandia kakampi ta.” ");
INSERT INTO agn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Asing galenget da tang timpong ekelan da si Jesus ong langit, nagdisision tanandiang paning ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ta-liban na pa tang Samaria, animan nanobol tanandia ta pirapang taw ang tongkaw da don ong tatang bario tang Samaria para magsimpan ta madayonan na. ");
INSERT INTO agn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Piro indi tanandia rinisibi tang mga taga Samaria, tenged gata-wanan nira ang distino na Jerusalem, ang siodad tang mga Judio. ");
INSERT INTO agn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Asing itaen da Santiago may ni Juan, ganing tanira ong ni Jesus, “Magino, galiliagang mama-dol ami ta apoy magalin ong langit para pogdawen tanira?” ");
INSERT INTO agn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Piro minalied si Jesus ig sinambleng na tanira. “Indi amo gatako tang onopang klasiay ta ispirito tang atan ong nindio,” ganing tanandia. “Tenged yo, ang Ana ta Taw, indio napaning tarin para distroson tang mga taw, kondi para ilibri.” ");
INSERT INTO agn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ig nagdayon da lamang tanira ong domang bario. ");
INSERT INTO agn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Asing pamansipanaw si tanira, may tatang taw ang naganing ong ni Jesus, “Tomabido ong nio, maski ong ariapa paning.” ");
INSERT INTO agn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Piro ganing si Jesus ong nandia, “Ang mga kirong lōg, may galoang ang agbalayan nira. Ig ang mga lamlam, may poyad ka nira. Piro yo, ang Ana ta Taw, andang pisan ay mapenayano.” ");
INSERT INTO agn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ig ganing pa si Jesus ong tata, “Tomabida ong yen.” Piro ganing tang taw, “Magino, pagnano kang lagi niong molik, para ipalbengo tang tatayo.” ");
INSERT INTO agn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Piro siminabat si Jesus, “Pabayan mo lamang ang mga patay tang maglebeng ong mga patay nira. Piro yawa, panawa ra ig ipatako mo tang natetenged ong inadian tang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ganing pa ka tang tata, “Magino, tomabido ong nio, piro ba-lo kay, maglisinsiao kang lagi ong pamiliao.” ");
INSERT INTO agn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ganing si Jesus ong nandia, “Ang pagarado ang pirming babalied, belag ta bagay ong inadian tang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagatapos ta si, namilik pa tang Gino ta pitompolok may doroang sinagpan na. Pina-kaw na tanira ta tag talodoa ong kada lansangan ig kada logar ang paningan na. ");
INSERT INTO agn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","3","Ganing si Jesus ong nira, “Agtobolon amo yen ang midio mamanigayeg among agpaning ong koma. Dorong arayegen, piro korang tang mga manigayeg. Animan mama-dol amo ong may nandia tang arayegen ang magpekel pa enged tanandia ta mga manigayeg. Panaw amo ra! Piro magandam amo. Ang kalimbawan mi pario ong mga karnirong agpaning ong mga ayep ang pamangkeb. ");
INSERT INTO agn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Indi amo magekel ta poyo-poyo, binagteng asta rapak. Indi amo magtareng ong dalan para magigampang ong maski ninopa. ");
INSERT INTO agn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Paga-led mi ong maski ninopang balay, maning amo kang lagi, ‘Balampa magkatinir tang kao-yan tang Dios ong teled tang pamalay-balay ang narin.’ ");
INSERT INTO agn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mandian, mga kao-yan kaman tang agdilemen ta tatang taw ang gistar don, magkatinir ka enged tanandia ta kao-yan ang magalin ong Dios. Piro mga belag, indi ka marisibi ta sia. ");
INSERT INTO agn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mga padayonon amo ong tatang balay, don amo lamang magtinir. Indi amo magla-ted la-ted ong domang mga balay. Indi amo maeyak ang mamangan ig manginem ta maski onopay agsisirbi ong nindio, tenged ang mga taw ang pamangabedlay, dapat ang solan ka kaman. ");
INSERT INTO agn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Animan maski ong aypang logaray tang kaboton mi, mga risibien amo don, panganen mi tang maski onopa lamang ay sisirbi nira ong nindio. ");
INSERT INTO agn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pao-yaen mi tang mga pamagmasit nira ig aningen mi tang mga taw ang pamansistar don, ‘Galenget da ong nindio tang paggaraemen tang Dios bilang adi!’ ");
INSERT INTO agn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Piro mga maning amo ong tatang logar ang indi amo risibien nira, paning amo ong karsada ig aningen ming, ‘Tapokon amen tang kolapok ang pandepet ong mga kakay amen ang nagalin ong logar mi! Tanda ang anda ray sarabaten amen ong nindio! ");
INSERT INTO agn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ig tandan mi ka na, galenget da tang paggaraemen tang Dios bilang adi!’ ");
INSERT INTO agn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Asia tang yaning mi ong nira. Tenged ong kamatodan, ong kaldaw ang osgaran tang Dios tang tanan, ang silot ang i-dol ong mga taw ong logar ang asi sobra pa ong silot ang i-dol ong mga taga Sodoma.” ");
INSERT INTO agn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Oman ganing pa si Jesus, “Kailo amo ka, yamong mga taga Corazin ig taga Betsaida! Dorong milagrong bindoato atan ong nindio, piro indi amo enged namagtogat ong mga talak mi! Piro mga bindoato lamang tang mga bagay ang asi don ong Tiro ig ong Sidon, ang mga taw don, naboay da ka rin ang namaglambong ta sako ig namansikarong ong kabo para ipaitang pamagtogat da tanira. ");
INSERT INTO agn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Animan ong Kaldaw tang Pagosgar, mas malakan tang silot ang i-dol ong mga taga Tiro may Sidon kaysa ong nindio. ");
INSERT INTO agn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ig yamong mga taga Capernaum, galiliag among manlawig tegka ong langit. Piro mabo-log amo lamang ong impirno, tenged indi amo ka enged namagtogat!” ");
INSERT INTO agn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Oman ganing si Jesus ong mga agtobolon na, “Ang mamasi ong nindio, pamasi ka ong yen. Ang indi magrisibi ong nindio, indi ka magrisibi ong yen. Ig ang indi magrisibi ong yen, sia indi ka pagrisibi ong Dios, tenged tanandia tang nanobol ong yen.” ");
INSERT INTO agn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Asing pagbalik tang pitompolok may doroang sinobol ni Jesus, dorong kalipay nira ig ganing tanira, “Magino, maski ngani mga dimonio, pamagparet ka mga agtobolon amen ong paggamit amen tang aran mo!” ");
INSERT INTO agn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Siminabat ka si Jesus, “Initao ka kaman si Satanas, ang asing golpi tanandiang nabo-log ong langit, ang midio koldap. ");
INSERT INTO agn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Telekan mi, sindolan amo yen ta gaem para likedan tang mga ma-kal ig mga anono-siok, ig agod degen mi tang gaem tang kasoay ta ang si Satanas. Indi amo maonopa. ");
INSERT INTO agn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Animan mangalipay amo, belag ta tenged gadeg mi tang mga malalain ang ispirito, kondi tenged nasolat da tang aran mi don ong langit.” ");
INSERT INTO agn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Asing oras ang asi, pinalipay si Jesus ta mo-ya tang Ispirito Santo, ig ganing, “Tatayo, yawa tang paggaem tang langit may ang tanek. Pagpasalamato ong nio tenged sinalok mo tang mga kamatodan ang na ong mga matatakong taw ig alalawig tang inadalan nira. Piro pinatako mo ong mga taw ang dibabak ta nem ig anday adal nira. Salamat, Tatay, tenged maning ta sia tang kaliliagan mo.” ");
INSERT INTO agn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Oman ganing si Jesus ong mga taw don, “Ang tanan ang bagay, inintriga ong yen tang Tatayo. Ang Tatay lamang enged tang gailala ong Ana na, ig ang Ana lamang tang gailala ong Tatay na, asta ang mga taw ang galiliagan tang Ana ang mailala ong Tatay na.” ");
INSERT INTO agn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Oman siminalonga si Jesus ong mga sinagpan na ig minitala ong nira lamang ang ganing, “Masoirti amo tenged inita mi tang mga bagay ang gitaen mi mandian. ");
INSERT INTO agn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ganingo ong nindio, dorong propita ig mga adi asing tokaw ang gangaliliag din ang mangaita tang gitaen mi, piro indi inita nira. Ig gangaliliag din ang mangabasi tang gaba-yan mi, piro indi ka naba-yan nira.” ");
INSERT INTO agn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tatang kaldaw may tatang manigtoldok tang Katobolan tang mga Judio ang napalenget para sobokan na si Jesus. Ganing tanandia, “Maistro, onopa tang masinlong boateno para marisibio tang kaboing anday kataposan?” ");
INSERT INTO agn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ganing si Jesus ang siminabat, “Onopa tang gasolat ong Katobolan? Onopa tang gabasa mo don?” ");
INSERT INTO agn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Siminabat tang manigtoldok, “ ‘Gegman mo tang Ampoan mong Dios ang de-dek ong popotokon mo, bogos ong nem mo, bogos ong poirsa mo ig bogos ong kinaisipan mo,’ ig ‘Gegman mo tang masig ka taw mo pario tang paggegma mo ong sadili mo.’ ” ");
INSERT INTO agn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Tama tang sabat mo,” ganing si Jesus. “Boaten mo sia ig yawa marisibia ta kaboing anday kataposan.” ");
INSERT INTO agn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Piro ang kaliagan tang manigtoldok, masigoro nang tama tang boaten na agod indi tanandia mapaeyak, animan nane-ma si ong ni Jesus, “Piro Gino, sinopa tang yen ang masig ka taw?” ");
INSERT INTO agn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Siminabat si Jesus ong nandia ong tatang istoria. “May tatang taw ang napanaw nagalin ong Jerusalem paning don ong Jerico. Mintras papanaw, ina-lawan tanandia ta mga tolisan. Kinomit nira tang ekel na asta ang aglambongon na. Sinalalabangan nira tang sontok oman bino-wanan nirang lipeng. ");
INSERT INTO agn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nāton ang nata-lib don ong dalan ang asi tang tatang padi. Pagaita na ong taw ang asing binogbog ig gibok ong binit tang dalan, don tanandia nagpanaw ong dobaling binit. ");
INSERT INTO agn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Oman may tatang manigtabang ong Timplo, ang simina-lib ka don. Asing itaen na tang taw ang asi, indi ka inintindi na kondi nagpadayon lamang ong pagpanaw na ong dobaling binit. ");
INSERT INTO agn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ong ori, may tatang taga Samaria ang belag ta kasimanoa nira ang pagbiahi ig nata-lib ka don. Pagaita na ong taw ang asing binogbog, nate-bek ang lagi tanandia. ");
INSERT INTO agn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pinalengetan na ig binolong na ta langis may bino tang mga igad na ba-lo bine-ketan na. Oman, kinarga na don ong ayep ang agtayan na. Ingkelan na ong balay ang agpabayadan ig don inasikaso na. ");
INSERT INTO agn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagaramal, nagtorol tang Samaritano ta koarta ong may nandia tang balay ang ganing, ‘Patigayon mo kang asikason tang taw ang na. Mga pirapa tang korang, sia dolangano ra lamang ong pagbaliko.’ ” ");
INSERT INTO agn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Oman ganing si Jesus ong manigtoldok, “Mandian, ong nio lamang, sinopa ong nirang tolo tang nagpaita ang tanandia masig ka taw ta sing taw ang binogbog tang mga tolisan?” ");
INSERT INTO agn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Siminabat tang manigtoldok, “Ang nate-bek ong nandia.” Ig ganing si Jesus, “Panawa ra ig maning ka don tang boaten mo.” ");
INSERT INTO agn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nagpadayon da si Jesus may ang mga sinagpan na ong pagpanaw nira asta kiminabot tanira ong tatang bario. May tatang babay don, ang aran na si Marta, ig mo-ya tang pagrisibi na ong da Jesus ong balay na. ");
INSERT INTO agn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mandian ang babay ang na, may logod na ka, ang aran na si Maria. Si Maria, kiminarong lamang ong may kakayan tang Gino ig pamasi tang agtotoldok na. ");
INSERT INTO agn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Piro gaborido si Marta tenged dorong aggasikason na. Animan napalenget si Marta ong ni Jesus ig ganing, “Gino, anday kaso ong nio ang agpabayano ra lamang tang logodo? Tambilogo ka lamang ang pagsimpan. Aningen mo kay patigayon ang tabangano ka nandia.” ");
INSERT INTO agn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Piro siminabat si Jesus, “Yawa, Marta, pisana lamang gaborido ong yading irintindien mo. ");
INSERT INTO agn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Piro tata ka enged lamang tang importanti. Sia yay ang pinilik ni Maria. Indi bawalen ta tanandia.” ");
INSERT INTO agn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tatang kaldaw pangadi si Jesus ong tatang logar. Pagatapos na, ganing tang tatang sinagpan na ong nandia, “Magino, toldokay ami ka niong mangadi, pario tang bindoat ni Juan ang Manigboniag ong mga sinagpan na.” ");
INSERT INTO agn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ganing si Jesus ong nira, “Mga mangadi amo, maning ta na tang pangadien mi: ‘Tatay amen, dayawen ig galangen tang aran mo. Balampa yawa ra tang maggaem ong tanan-tanan. ");
INSERT INTO agn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Olday ami ka nio ta yamen ang pamangan ong kaldaw-kaldaw. ");
INSERT INTO agn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Patawaden ami nio ong mga talak amen, tenged agpatawaden amen ka tang mga pamagkatalak ong yamen. Ig tabangan ami kay nio agod indi ami degen tang tokso.’ ” ");
INSERT INTO agn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ganing pa ka si Jesus ong nira, “Pabetang ta, may tata ong nindio ang napaning ong balay tang tangay na, maski tenganan da, ig ganing, ‘Tangay! Oldayo kang lagi nio ta mapangan! ");
INSERT INTO agn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ba-long kiminabot tang tatang tangayong nagbiahi, ig anday mapapano ong nandia.’ ");
INSERT INTO agn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Piro maning ta na tang sabat tang tangay na: ‘India magdistorbo ong yen! Way, telekan mo! Sirado ra tang portan amen ig lolbog ami ra tang pamiliao! Tamadano rang mambangon para magtorol tang kaministiran mo.’ ");
INSERT INTO agn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Piro ganingo ong nindio, ang taw ang asi mambangon ka enged para magtorol tang agpa-dolon tang tangay na. Belag tang maning tenged ong pagtangayan nira, kondi tenged sigi tang reges nang pama-dol. ");
INSERT INTO agn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Animan agganingo ong nindio, pirmi among mama-dol ong Dios ig oldan amo. Magprosigir among magdilem tang agdilemen mi, sia itaen mi ka. Sigi lamang tang panagbalay mi ig padayonon amo. ");
INSERT INTO agn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tenged garisibi tang kada pama-dol. Gaita tang pagdilem. Ig agpadayonon tang panagbalay. ");
INSERT INTO agn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Yamong mga tatay, mga pama-dol tang mga ana mi ta yan, oldan mi bato ta ma-kal? ");
INSERT INTO agn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Obin, mga pama-dol tanira ta ki-yoy, oldan mi bato ta anono-siok? ");
INSERT INTO agn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mga yamong mapinagtalaken gatakong magtorol ta mo-yang bagay ong mga ana mi, ang Tatay mi pa bato ong langit? Indi bato magtorol tanandia tang Ispirito Santo ong mga taw ang pama-dol ong nandia?” ");
INSERT INTO agn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tatang kaldaw nagpalayas si Jesus ta dimoniong boyon ong tatang taw. Tenged ong dimonio, naboyon da ka tang taw, piro asing pagaloa tang dimonio, nabitala ra tang taw ang dating boyon. Nangabereng tang mga taw don, ");
INSERT INTO agn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","piro ganing tang doma, “Si Satanas, ang pangolokolo ong mga dimonio, yay ang pagtorol ong nandia ta gaem ang magpalayas ta mga malain ang ispirito.” ");
INSERT INTO agn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","May doma kang galiliag ang sobokan nira si Jesus, animan ganing tanira ong nandia, “Abir, magpaitā kay ong yamen ta milagro bilang tanda ang yawa matod ang nagalin ong Dios.” ");
INSERT INTO agn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Piro gata-wanan ni Jesus tang aggisipen nira. Animan ganing tanandia, “Pabetang ta, mga ang mga taw ong tatang inadian, tanira mismo tang pamagkorontran, mamagbereblag ang enged tang inadian ang asi. Ig maski ong tanga balayan, mga tanira mismo tang pamagsoroayan, indi maboay mamagbereblag ang enged. ");
INSERT INTO agn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mandian, mga si Satanas mismo tang mangontra ong mga sinakepan na, monopa madayon tang inadian na? Ganing amo, yo pagpalayaso ta mga dimonio, tenged sindolano ni Satanas tang gaem ang na. ");
INSERT INTO agn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Piro mga matod ang si Satanas tang nagtorol ta gaem ong yen para magpalayas ta mga dimonio, sinopa ka tang pagtorol ta gaem ong mga tawan mi para magpalayas ta mga dimonio? Tanira ka mismo tang magpamatod ang nagkamali amo! ");
INSERT INTO agn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tenged ong kamatodan, ang Dios tang pagtorol ong yen ta gaem ang magpalayas ta mga diminio. Animan maliag yaning, ang Dios ya ray paggaem mandian tarin ong nindio.” ");
INSERT INTO agn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Si Satanas, ang kalimbawan na pario ong tatang taw ang mapoirsa ig may armas na. Ig mintras pagbantay tanandia tang balay na, anday ma-led para manakaw tang mga kagamitan na. ");
INSERT INTO agn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Piro mga toloson tanandia ig pirdien ta tatang taw ang mas mapoirsa ong nandia, komiten tang mga armas nang agtaligan na. Pagatapos, ang mga kagamitan na parti-partien da tang taw ang nanolos may ang mga karomanan na.” ");
INSERT INTO agn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ig ganing pa si Jesus, “Ang indi kakampi ong yen, kokontra ong yen. Ig ang indi pagtabang ong yen ang pagsimet ta mga taw, pagwasag lamang.” ");
INSERT INTO agn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ganing pa si Jesus, “Pabetang ta, mga may malain ang ispirito ang lomboa ong taw ang sinledan na, ang boaten na magalig-alig ong logar ang anday wi na ig magdilem ta logar ang mapenayan na. Mga anday itaen nang mapenayan na, maning ong sadili na, ‘Magbaliko ra lamang ong taw ang inistarano tanopa sia.’ ");
INSERT INTO agn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ig ong pagbalik na, kabotan na tang taw ang midio tatang balay ang limpio ra ig ariglado pa. ");
INSERT INTO agn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Animan magpanaw si tanandia ig mangimbitar pa enged ta pitong ispiritong mas malalain pa ong nandia. Oman tenled ang lagi tanira ig mistar si don. Animan ang taw ang asing lindoan tanopa sia ta malain ang ispirito, mas maliwag tang pagkabetang ang kaboton na mandian.” ");
INSERT INTO agn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Asing bibitala pa si Jesus, may tatang babay don ong kayadian ang miniteg ang ganing, “Masoirti tang babay ang nangana ong nio ig nagpatiti!” ");
INSERT INTO agn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Piro ganing si Jesus ang siminabat, “Mas masoirti pa tang pamamasi ig pamagtoman tang bitala tang Dios!” ");
INSERT INTO agn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Asing pangyadi ra tang mga taw, ganing si Jesus, “Ang mga taw ong timpong na, dorog kalalain! Pamagdilem ta milagro bilang tanda ba-lo tanira magparet. Piro anday ipaita ong nira, poira lamang ong tatang makabebereng ang bagay ang pario tang nainabo ong propitang si Jonas asing tokaw. ");
INSERT INTO agn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mga monopa si Jonas nagimong tanda para ong mga taga Ninive asing tokaw, maning ka ta si magimong tanda tang Ana ta Taw ong mga taw mandian. ");
INSERT INTO agn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pag kabot tang kaldaw ang magosgar da tang Dios, tomalonga don tang Rayna tang Abagat ig maning nga yamong mga taw ong timpong na dapat ang enged ang silotan. Tenged asing tokaw nagalin pa tanandia ong logar ang dorog kalawid para lamang mamasi ong kinata-wanan tang ading si Solomon. Piro telekan mi, may nakabot da tarin ang sobra pa ong ni Solomon! ");
INSERT INTO agn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ong kaldaw kang asi, asta ang mga laling taga Ninive tomalonga ka don ig magpamatod ang yamo dapat kaman ang silotan. Tenged asing si Jonas nagtoldok ong nira, namagtogat tanira tang mga kasalanan nira. Piro yamo, maski may tarin da mandian ang sobra pa ong ni Jonas, indi amo pa enged mamagparet ong toldok na.” ");
INSERT INTO agn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ganing si Jesus, “Anday pagsindi ta kingki oman italok obin dapan na ta gantangan. Kondi don lamang i-tang ong borondoan na para mga tenled tang mga taw, mayag ang lagi. ");
INSERT INTO agn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ang kalimbawan tang mata ta, midio pa-kal tang sinangoni ta. Animan mga mayag tang mata ta, gayagan ka tang bilog ang kaboi ta. Piro mga maki-lep tang mata ta, gaki-lepan ka tang bilog ang kaboi ta. ");
INSERT INTO agn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Animan sigoron ming mayag tang mata mi, ang belag ta maki-lep. ");
INSERT INTO agn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tenged mga mayag tang mata ta ang andang pisan ay maki-lep don, mayag ka kaman tang bilog ang kaboi ta, ig midio gasinagan ita ta tatang kayag-ayagan ang pa-kal.” ");
INSERT INTO agn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagatapos ang nagbitala si Jesus, inimbitar tanandia ta tatang Pariseo para mamangan ong balay na. Animan napaning si Jesus ong balay tang Pariseo ig namangan. ");
INSERT INTO agn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nabereng tang Pariseo asing pagaita nang si Jesus pamangan ang indi namanaw sigon ong kaogalian nira. ");
INSERT INTO agn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Animan ganing tang Gino ong nandia, “Yamong mga Pariseo! Aglimpion mi ta mo-ya tang loa tang mga baso ig mga platon mi, piro ang teled ay maboling pario ka ong mga popotokon mi tenged ponok ta katakab ig kalainan. ");
INSERT INTO agn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Anday isip mi! Ang Dios tang nagboat tang mga bagay ong loa ang aggitaen. Bato belag ka ta tanandia tang nagboat tang ga-tang ong teled, ang indi gitaen ta taw? ");
INSERT INTO agn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ang boaten mi, oldan mi kang lagi tang mga malilised maski onopa atan ong platon may ong tasa mi. Asia magimong limpio tang tanan para ong nindio. ");
INSERT INTO agn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kailo amo kang mga Pariseo! Maderep amo ong pagtorol ong Dios ta tampolok ang porsinto tang pa-bat mi asta ang mga daon ang pagpasabor ong pamangan. Piro ong dobali ta sia, indi amo enged pamagintindi ang magboat ta mato-lid ig maggegma ong Dios. Dapat magtorol amo ka kaman tang tampolok ang porsinto, piro indi lipatan mi tang mas importanting mga tobol. ");
INSERT INTO agn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kailo amo ka kaman, yamong mga Pariseo! Mga don amo ong mga simban mi, ang kaliliagan mi enged, mga kalarongan ang masisinlo. Ig mga don amo ong plasa, ang kaliliagan mi, ang salodoan amo tang mga taw. ");
INSERT INTO agn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kailo amo ka! Ang kalimbawan mi pario amo ong mga lebengan ang anda ray tanda na, ig gapanaw-panawan ta mga taw ang indi gangatakong poros anday sasayod tang ga-tang ong adalem.” ");
INSERT INTO agn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ganing ong ni Jesus tang tatang manigtoldok tang Katobolan, “Maistro, ong inaning mong asia, agpaeyaken ami ka nio.” ");
INSERT INTO agn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Siminabat si Jesus ang ganing, “Kailo amo ka, yamong mga manigtoldok tang Katobolan! Tenged agpabelatan mi tang mga taw ong dorong mga toromanen mi, piro indi enged agboinan mi tang tarakanen ang asi agod makayan nira tang kabelatan. ");
INSERT INTO agn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kailo amo ka! Agpaobra mi tang mga pantion tang mga propitang pinatay tang mga kamepet-mepetan mi asing tokaw. ");
INSERT INTO agn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ong agboaten ming asia, maliag yaning agpaoyon amo ong bindoat tang mga kamepet-mepetan mi. Tenged tanira tang namamatay tang mga propita, ig yamo ka tang pamagpaobra tang mga pantion nira! ");
INSERT INTO agn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Animan ganing tang kinata-wanan tang Dios, ‘Manobolo ong nira ta mga propita ig mga apostolis. Patayen nira tang doma, ig ang doma paliwagan ka nira.’ ");
INSERT INTO agn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Animan yamong mga taw mandian, yamo tang manabat ong kamatayen tang tanan ang mga propita, mimpisa pa asing boaten tang kalibotan, ");
INSERT INTO agn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mimpisa pa ong pagpatay ong ni Abel, sa-sad ong pagpatay ka ong ni Zacarias don ong teled tang solar tang Timplo. Pinatay mismo tanandia don ong pagtetengan tang altar ig ang sagradong logar. Ong matod, yamong mga taw ong timpong na, yamo tang silotan tenged ong tanan ang bindoat nirang asi. ");
INSERT INTO agn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kailo amo kang mga manigtoldok tang Katobolan! Sinalok mi ra tang pagtorol ta kinata-wanan. Indi amo ngani gangaintindi tang kamatodan, ig agsagangen mi pa tang doma ang gangaliliag ang mangaintindi.” ");
INSERT INTO agn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pagatapos ang nagbitala si Jesus, nagalin da tanandia. Impisa don, pirmi rang agkontraen tanandia tang mga manigtoldok tang Katobolan ig ang mga Pariseo. Dorong bagay tang agte-maen nira ong ni Jesus, ");
INSERT INTO agn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ig agbantayan nira ta mo-ya para madep nira ong mga sabat na. ");
INSERT INTO agn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Asing pamansikabot pa tang ribo-ribong mga taw, asta pamagtalapayan da tang doma, minaning kang lagi si Jesus ong mga sinagpan na, “Magandam amo. Itaben matalidan amo tang mga Pariseo ong mga boat nirang poros paita-ita lamang. Asia, ang ogali nira midio pario ong pampalsa ta tinapay ang madaling magwasag ong agmasaen. ");
INSERT INTO agn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Anday gatalok ang indi ipaita, ig anda kay sikritong indi mata-wanan. ");
INSERT INTO agn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Maski onopay inampang ming labi, ba-yen ka enged mga kaldaw da. Ig maski onopay lalalat mi don ong koartong sirado, narin ipatako ka enged don ong loa.” ");
INSERT INTO agn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ganing pa si Jesus, “Agganingo ong nindio mga tangay, indi amo meled ong mga pamamatay ta taw, sia sa-sad lamang don tang gaem nira. ");
INSERT INTO agn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Begen amo yen mga sinopa tang dapat eldan mi: Ang Dios lamang tang dapat eldan mi, tenged pagatapos nang komiten tang kaboi mi, may gaem na pang magsilot ang i-lek ong impirno. Agganingo si, tanandia tang dapat eldan mi. ");
INSERT INTO agn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Piro demdemen mi ka narin: Ang mga aloma-wit, gata-wanan ta ang gabakal ta doroang sintabos lamang kada limang bilog. Asia, maski dorog kabarato, piro indi ka agpabayan tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ig yamo, maski ngani ang mga naet tang boa mi, gata-wanan na ang pirapang tanan. Animan indi amo mamansieled, tenged mas agmalen amo tang Dios kaysa ong kadoro-doroan ang mga aloma-wit.” ");
INSERT INTO agn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ganing pa si Jesus, “Agganingo ong nindio, ang sinopay mangilala ong yen, ang Ana ta Taw, ong talongan tang mga taw, ilalaeno ka tanandia ong talongan tang mga anghil tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Piro ang ganing indi ono gailala ong yen, indi ka tanandia ilalaeno ong talongan tang mga anghil tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mapatawad tang maski sinopay magbitala ta malain kontra ong yen, ang Ana ta Taw. Piro mga ang Ispirito Santo tang pakalainen na, inding pisan tanandia patawaden. ");
INSERT INTO agn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mga ekelan amo ong mga simban tang mga Judio, obin ong talongan tang mga opisialis ig ong mga may aotoridad para imbistigaren natetenged ong pagto mi ong yen, indi amo magpalibeg tang mga kolo mi mga onopa tang isabat mi obin mga onopay ibitala mi. ");
INSERT INTO agn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tenged ong oras ang asi, toldokan amo tang Ispirito Santo tang dapat isabat mi.” ");
INSERT INTO agn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ganing ong ni Jesus tang tatang taw don, “Maistro, aningen mo kay patigayon tang logodo ang partiano kay nandia tang toroblien amen.” ");
INSERT INTO agn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Siminabat si Jesus, “Tangay, sinopa tang nagbetang ong yen para magosgar ong nindio, obin magtenga tang mga toroblien mi?” ");
INSERT INTO agn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ig ganing pa tanandia ong nirang tanan, “Magdan amo ong tanan ang klasi ta katakab. Tenged ang kaboi ta taw indi na-tang ong kabael tang manggad na.” ");
INSERT INTO agn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pagatapos, inistoria ni Jesus tang palimbawang na: “May tatang manggaden ang napagpa-bat ta mabael. ");
INSERT INTO agn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Animan ganing tanandia ong sadili na, ‘Onopa tang masinlong boateno? Anda ray mabetangano tang napa-bato. ");
INSERT INTO agn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A, gata-wanano ra tang boateno. Ipalaglago ra lamang tang mga bodigao ig magpa-dengo si ta mas mababael. Ig don i-tango tang mga napa-bato ig ang doma pang mga kagamitano. ");
INSERT INTO agn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tapos, yaningo ong sadilio, Asia! Bastanti ra tang mga pagkabetango! Indio ra korangen ong teled ta dorong takon ang komabot! Penayo ra lamang. Mamangan, manginem, ig mangalipay.’ ");
INSERT INTO agn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Piro maning tang Dios ong nandia, ‘Anday isip mo! Mandian mismong labing na, mapataya ra. Oman, sinopay magpakinabang tang mga agtatalok mo?’ ” ");
INSERT INTO agn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ig ganing pa si Jesus, “Maning ta sia tang mainabo ong taw ang pagsimet ta manggad para ong sadili na lamang, piro ong pama-dek tang Dios malised pa ka enged tanandia.” ");
INSERT INTO agn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ganing pa si Jesus ong mga sinagpan na, “Animan agganingo ong nindio: Indi amo magpaborido tang kolo mi natetenged ong pamangan ang kaministiran mi para maboi, asta ong mga pangabel tang sinangoni mi. ");
INSERT INTO agn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tenged ang kaboi ta mas importanti pa enged ong pamangan ta, ig ang sinangoni ta mas importanti pa ong lambong ta! ");
INSERT INTO agn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Telekan mi ra lamang tang mga ogak. Indi tanira pagloak ig indi ka pangayeg. Anday bodiga nira ig maski payag anda. Piro agtoldan tanira tang Dios ta pamangan nira. Yamo pa bato? Mas importanti amo pa ong mga lamlam! ");
INSERT INTO agn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sinopa ong nindio tang poiding pāboaten na tang kaboi na, maski tang oras lamang, tenged ong pagpaborido na? Anda! ");
INSERT INTO agn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Animan mga anday maimo mi para mapāboat tang kaboi mi maski ge-ley lamang, angay pamagpaborido amo pa natetenged ong domang mga bagay? ");
INSERT INTO agn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Isipen mi ra lamang tang mga rosas ong kabokidan. Pamansibabael tanirang indi pagobra ig indi pagboat ta lambong. Piro ong matod, ang adi mismong si Solomon, maski monopag kamanggad, indi ngani napaglambong ta pario kasinlo tang maski tata ong mga rosas ang asi. ");
INSERT INTO agn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ang mga ibabawen ong kabokidan, mandian asia pa ig ong damal sirokon da. Piro maski maning ta si, agpalambongan tang Dios ta dorog kasinlo. Yamo pa bato? Indi amo ka palambongan na? Korang pa tang pagtalig mi! ");
INSERT INTO agn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Animan indi amo magpaborido mga ong ari amo pa mangomit ta panganen mi ig inemen ");
INSERT INTO agn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tenged ang mga bagay lamang ang narin tang pirming agdemdemen tang mga taw ang anday talig nira ong Dios. Gata-wanan tang Tatay mi don ong langit ang kaministiran mi kaman tang tanan ang asia. ");
INSERT INTO agn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ang boaten mi, tokawen mi kang lagi ong tanan ang maggaem tang Dios ong kaboi mi. Sia, i-dol na tang tanan ang kaministiran mi.” ");
INSERT INTO agn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Indi amo mamansieled, mga agmaleno, maski pira amo pa lamang bilog. Galiliag tang Dios ang pa-penen amo nandia ong inadian na. ");
INSERT INTO agn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ipabakal mi tang mga pagkabetang mi, oman ang bayad na i-dol mi ong mga malilised. Ong maning ta sia, midio magboat amo ta mga poyo-poyong indi malagi ig magsimet amo ta manggad ong langit. Ang manggad ang asi indi malangga ig indi enged makorangan, tenged anday anay don ig anda kay malenget ang mga takawan. ");
INSERT INTO agn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tenged mga ong aypa tang manggad mi, don ka tang nem mi.” ");
INSERT INTO agn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Magimong simpan amo. Patoladan mi tang mga torobolon ang pamagelat ong agalen nirang molik da magalin ong kasalan. Indi tanira mapoyat ig indi agpabayan nirang mapatay tang mga tolok agod pag kabot ig tomo-tok tang agalen nira, mabrian ang lagi nira tang portan. ");
INSERT INTO agn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Masoirti tang mga torobolon mga ong pagbalik tang agalen nira, kabotan tanirang pamagbantay. Agganingo ong nindio, manimara tang agalen tang lambong na, pakarongon na tang mga torobolon na don ong nandiang lamisan ig tanandia mismo tang magsirbi ong nira. ");
INSERT INTO agn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Masoirti ka kaman tang mga torobolon mga kabotan tanira tang agalen nirang pamagelat pa. Maski molik ang tenganan obin garamal da. ");
INSERT INTO agn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Isipen mi narin: Mga gata-wanan lamang tang may nandia tang balay mga onopang orasay komabot tang takawan, indi enged pabayan nang telden tang balay na. ");
INSERT INTO agn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Animan yamo, kaministiran ang magbantay amo ig pirming simpan. Tenged yo, ang Ana ta Taw, komaboto ong oras ang indi gelaten mi.” ");
INSERT INTO agn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nane-ma si Pedro, “Magino, ang inistoria mong asia, para ong yamen lamang obin para ka ong tanan?” ");
INSERT INTO agn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Siminabat si Jesus ang ganing, “Ang mataligan ig matakong torobolon, yay ang boaten tang may nandia tang balay ang ingkargado ong domang mga torobolon na, ig ya kay ang magtorol ong nira ta pamangan ong tamang oras. ");
INSERT INTO agn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Masoirti tang torobolon ang asi mga kabotan tanandiang pagboat tang katengdanan na ong pagbalik tang agalen na. ");
INSERT INTO agn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sigoradong boaten da enged tanandiang ingkargado ong tanan ang pagkabetang tang agalen na. ");
INSERT INTO agn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Piro pabetang ta, mga maning tang torobolon ang asi ong sadili na, ‘Maboay-boay pa ba-lo magbalik tang agaleno.’ Ig impisan na rang bogbogon tang aroman nang mga torobolon ang lali asta ang mga babay. Ig pagatapos mamangan, manginem ig magpabaleng da. ");
INSERT INTO agn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Oman komabot tang agalen na ong kaldaw ang indi enged gelaten na, ig ong oras ang indi gata-wanan na. Dayon da tanandiang kastigon tang agalen na ta dorog kaliwag, ba-lo ibanggil ong logar ang para ong mga taw ang indi pamagto ig pamagparet ong Dios. ");
INSERT INTO agn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ang torobolon ang gatako tang galiliagan tang agalen na, piro indi kakaliek ig indi pagboat ta si, palon ang enged tanandia ta osto. ");
INSERT INTO agn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Piro ang torobolon ang indi gatako tang galiliagan tang agalen na, kondi pagboat ta bagay ang tanandia mapalo, palon ka kaman piro ge-ley lamang. Ang sinaligan ta dorong mga bagay, dileman ka tanandia ta dorong mga bagay. Ig ang sinaligan ta mas dorong mga bagay, mas doro pa enged tang dilemen ong nandia.” ");
INSERT INTO agn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ganing pa si Jesus, “Napaningo tarin para magekel ta apoy ong kalibotan, ig galiliaganong naparetan da. ");
INSERT INTO agn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Piro may kaliwagan pang dapat risibieno, ig indi matareng tang isipo asta indi mainabo. ");
INSERT INTO agn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kalaom mi sigoro, napaningo tarin para magekel ta kaosayan ong kalibotan. Piro ong matod, belag ta kaosayan tang aggekelano kondi soroayen. ");
INSERT INTO agn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Impisa mandian, mamagkarampi-kampian tang mamagana natetenged ong yen. Pabetang ta, mga lima tanira, ang tolo kontra ong doroa, ig ang doroa komontra ong tolo. ");
INSERT INTO agn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mamagkorontran ka tang tatay ig mga ana nang lali, asta ang nanay ig mga ana nang babay. Maning ka ta si tang panogangan ang babay ig minagad nang babay.” ");
INSERT INTO agn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ganing ka si Jesus ong mga taw, “Mga gitaen ming pangi-lep da ong gako-pan, ganing amo, ‘Komoran da!’ Ig komoran ka kaman. ");
INSERT INTO agn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ig mga geyep tang mageyep ong abagat, ganing amo ka, ‘Maringet si!’ Ig magringet ka kaman. ");
INSERT INTO agn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yamong mga taw! Pagpaita-ita amo lamang ang may kinata-wanan mi! Gatako among manaid mga onopa tang maliag yaning tang mga pasinial ang gitaen mi ong langit may ong tanek. Piro angay indi gata-wanan mi tang maliag yaning tang gangainabo mandian ang timpo?” ");
INSERT INTO agn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ganing pa si Jesus, “Angay midio indi amo mapagisip para ong sadili mi mga onopa tang tamang boaten mi? ");
INSERT INTO agn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pabetang ta, mga yawa dinimanda ta tatang taw, prosigiran mong magigayosa ang lagi ong nandia mintras indi amo pa gakabot ong korti. Tenged mga don amo ra ong osgado, itaben yintrigā tang osgado ong goardia ig dayona rang prison. ");
INSERT INTO agn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ong matod, india enged maloa don asta indi malobot mong mabayadan tang molta mo.” ");
INSERT INTO agn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","May mga taw ang kiminabot don ig binalita nira ong ni Jesus tang nainabo. Pinapatay ni Pilato tang pirapang mga taga Galilea mintras pamagbolontad tanira ong Dios. ");
INSERT INTO agn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ganing si Jesus ong namamalita, “Onopa tang isip mi natetetenged ong kinabot nirang asi? Maliag yaning bato mas mapinagtalaken tanira kaysa ong domang taga Galilea? ");
INSERT INTO agn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Belag! Piro agganingo ong nindio, mga indi amo magtogat ig magbo-wan tang mga talak mi, mangapatay amo kang tanan ang pario nira. ");
INSERT INTO agn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Isipen ta ka tang tampolok may walong taw ang napatay asing nabegtakan tanira tang alawig ang tori don ong Siloe. Onopa ong nindio? Maliag yaning bato tanira mas mapinagtalaken kaysa ong domang pamansistar ong Jerusalem? ");
INSERT INTO agn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Belag! Piro agganingo ong nindio, mga indi amo magtogat ig magbo-wan tang mga talak mi, mangapatay amo kang tanan.” ");
INSERT INTO agn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Oman inistoria ong nira ni Jesus tang palimbawang na. “May tatang taw ang may papa ta ayong igos ong kodal na. Pinaningan na ig sinelekan na mga may borak na ra, piro andang pisan ay inita na. ");
INSERT INTO agn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Animan ganing tang taw ong manigasikaso na, ‘Tolong takono rang pagbalik-balik ang agtelekano mga pamorak da tang ayong asia. Piro asta mandian andang pisan. Pe-peten mo ra lamang. Paglinget lamang atan.’ ");
INSERT INTO agn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Piro siminabat tang manigasikaso na, ‘Indi kang lagi pe-peten ta mandian ang takon ang na. Aliano kang lagi tang binit na ig betangan ta abono. ");
INSERT INTO agn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mga mamorak ong moman ang takon, mo-ya. Piro mga indi pa, pe-peten ta ra ka enged.’ ” ");
INSERT INTO agn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tatang Kaldaw ang Igperenay pagtoldok si Jesus ong simban tang mga Judio. ");
INSERT INTO agn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","May tatang babay don ang bogtot dang pisan. Narin boat tang malain ang ispirito ong nandia, ig tampolok may walong takon da ang maning ta na ig indi ra maonat tang sinangoni na. ");
INSERT INTO agn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Asing itaen ni Jesus tang babay ang na, ginoyan na ig minaning ong nandia, “Babay, nago-yā ra ong masit mo.” ");
INSERT INTO agn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Oman binondo ni Jesus ong babay tang kalima na. Kimindeng ta mato-lid ig nagdayaw ong Dios. ");
INSERT INTO agn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Piro nasilag tang pangolokolo tang simban nira tenged nagpao-ya si Jesus ong Kaldaw ang Igperenay. Ganing tang pangolokolo ong mga taw don, “Enem tang mga kaldaw ang sindol ong yaten para magobra. Paning amo tarin ong mga kaldaw ang asia para magpabolong, ig belag ta ong Kaldaw ang Igperenay.” ");
INSERT INTO agn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Piro sinabat tanandia tang Gino ang ganing, “Yamong pamangambong madinioson! Maski Kaldaw ka ang Igperenay, aggobaden mi tang mga baka may ang kabayo mi ig agpalpatan para manginem ta wi. ");
INSERT INTO agn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Piro telekan mi tang babay ang na. Tanandia nagalin ka ong dogo ni Abraham ang pario mi. Piro tenged ong kabogtot na, midio linapot tanandia ni Satanas ong teled da ta tampolok may walong takon. Indi bato dapat obadan da tanandia ig pao-yaen, maski Kaldaw ang Igperenay?” ");
INSERT INTO agn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Napaeyak tang mga pamangontra ong ni Jesus ong sinabat na. Piro nangalipay tang mga taw tenged ong tanan ang mga makabebereng ang mga bagay ang agboaten na. ");
INSERT INTO agn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ganing si Jesus, “Onopay kapario tang inadian tang Dios? Ong aypa ikompara ta? ");
INSERT INTO agn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kapario na tang tatang alibotod ta mostasang lindoak ta tatang taw ong tanek na. Nambael narin asta nagimong papa ta ayo, ig nagboat ta poyad tang mga lamlam ong mga tanga na.” ");
INSERT INTO agn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ganing pa si Jesus, “Ong aypa pa ikompara ta tang inadian tang Dios? ");
INSERT INTO agn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kapario na tang pampalsa ta tinapay ang sinampora ta tatang babay ong tolong gantang ang arina. Maski ge-ley tang pampalsa, minalsa tang bilog ang minasa.” ");
INSERT INTO agn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nagpadayon da Jesus ong pagparanawen nira. Pagtoldok tanandia ong kada lansangan ig bariong gata-liban nira paning ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mandian, may tatang taw ang nane-ma ong nandia, “Magino, ge-ley lamang tang mangalibri?” Siminabat si Jesus ang ganing, ");
INSERT INTO agn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Prosigiran ming tenled ong portan ang mapiet. Agganingo ong nindio, yadi rin ang galiliag ang tenled, piro indi manga-led. ");
INSERT INTO agn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Mga siniradoan da tang may nandia tang balay tang portan na, mabo-wan amo ong loa. Maski mano-tok amo ig maning, ‘Magino, pa-leden ami kay nio!’ piro sabaten amo nandia, ‘Indio gailala ong nindio mga taga ariamo pa!’ ");
INSERT INTO agn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Oman maning amo, ‘Yami, namangan ami ig nanginem ang ka-pen mo. Nagtoldoka pa ngani ong logar amen!’ ");
INSERT INTO agn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Piro sabaten amo ka nandia, ‘Indiong pisan gailala ong nindio! Palawid amo tarin, yamong tanan ang pamagboat ta malain!’ ");
INSERT INTO agn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ig mamagini-yak amo ig mamansikayeget tang isi mi mga itaen ming don da ong inadian tang Dios da Abraham, Isaac, ig Jacob, ig ang tanan ang mga propita, piro yamo don amo ong loa ang agtaboyon. ");
INSERT INTO agn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ig may doma pa enged ang mga taw ang mamansikabot ang mamagalin ong tere-lan, ong gako-pan, ong kambian asta ong abagat ig mamangombida ka don ong inadian tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pama-yan mi, may mga taw ang gangaori mandian, piro manga-kaw tanira ong kaldaw ang asi. Ig may atan kang ganga-kaw mandian, piro mangaori tanira.” ");
INSERT INTO agn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Asing oras ang asi, kiminabot tang pirapang mga Pariseo ig ganing ong ni Jesus, “Magalina ra tarin tenged galiliag si Herodes ang ipapataya nandia.” ");
INSERT INTO agn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Piro siminabat si Jesus, “Aningen mi tang ma-kal ang asing si Herodes, ang magpalayaso pa ta mga malalain ang ispirito ig magpao-yao pa ta mga taw mandian asta ong damal, ig ong ya-long kaldaw ba-lo taposono tang agboateno. ");
INSERT INTO agn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Piro kaministiran ang magpadayono ong pagpanawo mandian, ong damal, asta ong tatang kaldaw. Tenged indi maimong mapatay tang tatang propita ong loa tang Jerusalem. ");
INSERT INTO agn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ay yamong mga taga Jerusalem! Angay agpatayen mi tang mga propita ig agbanggilen mi tang mga agtobolon tang Dios ong nindio? Kaboay da tang andemong imesen amo ig sagodon, pario ong manong lo-lokan ang pagimes tang mga boto na ong adalem tang kalipapa na, piro indi amo maliag. ");
INSERT INTO agn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Animan pabayan amo ra lamang atan. Tandan mi narin: Indio ra enged itaen mi asta indi komabot tang kaldaw ig mamaganing amo, ‘Dayawen tang kakabot ang sinobol tang Dios!’ ” ");
INSERT INTO agn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tatang Kaldaw ang Igperenay inimbitar si Jesus tang tatang pangolokolo ong mga Pariseo para mamangan don ong balay nira. Ig agbantayan nira ta mo-ya tang onopay boaten ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mandian, napalenget ong ni Jesus tang tatang taw ang panimpeng tang sinangoni na. ");
INSERT INTO agn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Animan sine-ma ni Jesus tang mga Pariseo ig ang mga manigtoldok tang Katobolan, “Bato, ga-tang ong Katobolan ang poiding magpao-ya ta may masit na mga Kaldaw ang Igperenay obin anda?” ");
INSERT INTO agn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Piro indi tanira minibek-ibek. Animan bindiotan ni Jesus tang taw ang asing panimpeng tang sinangoni na. Pinao-ya na ig pagatapos dayon dang pinaolik na. ");
INSERT INTO agn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Oman ganing si Jesus ong nira, “Pabetang ta, may ana mi obin bakang nabo-log ong wi ig naton ang Kaldaw ang Igperenay. Onopa bato, pabayan mi ra lamang tenged Kaldaw ang Igperenay?” ");
INSERT INTO agn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Piro anday nasabat nira ong te-ma nang na. ");
INSERT INTO agn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Napanaidan ni Jesus tang mga bisita don, ang mga agpiliken nira ay ang mga kalarongan ang para ong mga taw ang importanti. Animan ganing si Jesus ong mga bisita, ");
INSERT INTO agn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Pabetang ta, mga inimbitara tang maski sinopa ong tatang kasalan ig dona ra ong kombida, india mamilik ta kalarongan ang para ong mga taw ang importanti. Itaben may inimbitar nirang mas gilalaen kaysa ong nio. ");
INSERT INTO agn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Oman ang mainabo, palenget tang nangimbitar ong nindiong doroa, ig aningena nandia, ‘Ipalobot ta kang lagi tang kalarongan mo ong taw ang na.’ Ong maning don, mapaeyaka ig ma-tanga don ong kalarongan ong binit. ");
INSERT INTO agn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mo-ya pa, mga aggimbitarena, dona kang lagi komarong ong kalarongan ang belag ta masinlo. Tenged mga malenget tang nangimbitar ong nio, maning tanandia, ‘Tangay, tania ra lamang komarong ong tokawan!’ Ong maning ta na, mabael tang dengeg mo ong talongan tang domang mga bisita. ");
INSERT INTO agn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tenged ang pagpalawig tang sadili na, ipababak. Ig ang pagpababak, tanandia tang ipalawig.” ");
INSERT INTO agn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ganing ka si Jesus ong nangimbitar ong nandia, “Mga magsimpana ta kombida ig mangimbitara ta taw, belag tang mga tangay mo, mga logod mo, mga parinti mo, obin mga kamalay mong manggaden tang imbitaren mo. Tenged baltena ka nirang imbitaren ig ong maning don, narisibi mo ra tang balet mo. ");
INSERT INTO agn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Animan mga magsimpana ta kombida, ang mga pobri, mga pingkaw, mga pilay ig mga boray tang imbitaren mo. ");
INSERT INTO agn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tenged tanira indi mabalet ong nio, ig sia aloyana tang Dios. Tenged ang Dios mismo tang magbalet ong nio pag kabot tang kaldaw ang moman ang boien tang mga taw ang namagboat ta mato-lid.” ");
INSERT INTO agn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pagabasi ta si tang tatang inimbitar, ganing tanandia ong ni Jesus, “Masoirti tang mga taw ang ma-pen ong kombida don ong inadian tang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Siminabat si Jesus ong tatang palimbawa. Ganing tanandia, “May tatang taw ang nagsimpan ta mabael ang kombida ig dorong pinangimbitar na. ");
INSERT INTO agn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Asing kiminabot tang oras tang kombida, nanobol tanandia ong torobolon na ang paningan tang mga pinangimbitar ig aningen, ‘Maytara! Simpan da tang tanan!’ ");
INSERT INTO agn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Piro namagbalibad tanirang tanan ang indi ono mangapaning. Ang primiro naganing, ‘Nabakalo ta koromaen, ig dapat paningano kang lagi ig telekan. Yamo ra lamang tang balang magpasinsia ong yen.’ ");
INSERT INTO agn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ig ganing ka tang yadoa, ‘Nabakalo ta tampolok ang nga bakan para yarado. Dapat betangano kang lagi ta singkaw para masobokano. Yamo ra lamang tang balang magpasinsia ong yen.’ ");
INSERT INTO agn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ganing pa ka tang ya-lo, ‘Ba-lo ami lamang kinasal tang katawao. Animan indio mapangombida.’ ");
INSERT INTO agn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Nagbalik tang torobolon ig bineg na ong agalen na. Nasilag tang agalen na ig ganing, ‘Dalien mo, paninga ong mababael asta ong gege-ley ang mga karsada. E-lan mo tarin tang mga pobri, mga pingkaw, mga boray ig mga pilay.’ ");
INSERT INTO agn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pagabalik tang torobolon, ganing tanandia ong agalen na, ‘Magino, naboato ra tang ordin mo, piro marogal pa tang kombidan!’ ");
INSERT INTO agn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Animan ganing si tang agalen, ‘Panawa ong mga karsada ig ong mga dalan ang paning ong bokid. Regesen mong paning tarin tang mga taw agod ma-mok tang balayo ta mga bisita. ");
INSERT INTO agn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Agganingo ong nindio, anday maski tambilog ong mga nanga-kaw ang inimbitaro ang ma-bo tang sinimpano.’ ” ");
INSERT INTO agn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Dorong taw tang pamansitabid ong ni Jesus ong pagpanaw na ong Jerusalem. Animan siminareng tanandia ig siminalonga ong nira ig minaning, ");
INSERT INTO agn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Indi poiding magimong sinagpano tang pagmal ong tatay na obin ong nanay na, katawa na, mga ana na, mga logod na, obin ong sadiling kaboi na ang sobra pa ong paggegma na ong yen. ");
INSERT INTO agn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ig ang maski sinopa, mga belag ka lamang ta disidido ang magosoy ong yen ang tomalonga ong kaliwagan ig kamatayen, ang taw ang asi indi poiding magimong sinagpano. ");
INSERT INTO agn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Pabetang ta, mga ang tata ong nindio pagplanong magpa-deng ta tori, bato indi kang lagi tanandia komarong ig somadaen na mga pirapa tang magastos na ig mga bastanti tang koarta nang para matapos? ");
INSERT INTO agn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Itaben na-deng da tang adili piro indi ka matapos. Oman libaken tanandia tang tanan ang mangaita ta si. ");
INSERT INTO agn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Maning tanira, ‘Ang taw ang na! Nagimpisang nagpa-deng, oman indi ka natapos na!’ ");
INSERT INTO agn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Obin pabetang ta, may tatang adi. Mga may plano nang magiggira ong kapario nang adi, bato indi kang lagi tanandia komarong ig pagadalan na ta mo-ya mga tanandia may ang tampolok ang ribong sondalo na masarangan nira tang doroampolok ang ribong kabatok nira? ");
INSERT INTO agn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Piro mga indi masarangan nira, magtobol da lamang tanandia ta tawan na para magigayos mintras alawid pa tang kabatok nira. ");
INSERT INTO agn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Animan, maning ka ta si, isipen mi kang lagi ta mo-ya. Tenged ang maski sinopay indi magbo-wan tang tanan ang agpalabien na ong kaboi na, indi poiding magimong sinagpano.” ");
INSERT INTO agn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ganing pa si Jesus, “Mabael tang pakinabang tang kasin. Piro mga manlasay da, indi ra poiding mapakasin pang moman. ");
INSERT INTO agn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Anda ray pakinabang na, maski ong tanek obin maski gamiten pa ong abono. Narin i-lek da lamang. Animan mamasi tang may talinga!” ");
INSERT INTO agn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pamansilenget tang mga manigtokot ta bois may ang mga mapinagtalaken para mamasi ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Animan pamagmoro-moro tang mga Pariseo ig mga manigtoldok tang Katobolan ang ganing, “Telekan mi tang taw ang na! Pagiga-pen ong mga mapinagtalaken ig ga-pen ka ong nira ang pamangan.” ");
INSERT INTO agn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Animan nagistoria ong nira si Jesus tang palimbawang na. ");
INSERT INTO agn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ganing si Jesus, “Pabetang ta, tata ong nindio may tang gatos ang karniro na, ig galipat tang tambilog. Onopa bato tang boaten na? Sigorado enged ang bo-wanan na tang siam ang polok may siam don ong kamayagan ig dilemen na tang galipat asta indi matoman na. ");
INSERT INTO agn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mga matoman na ra ngani, mambeng tanandiang agtakanen nang golik. ");
INSERT INTO agn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pag kabot ong balay nira, imbitaren na tang mga tangay na ig ang mga kamalay na ig maning tanandia, ‘Mangalipay ita! Initao ra tang karnirong nalipat.’ ");
INSERT INTO agn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Animan maning ka ta si ong langit. Mas mabael tang kalipay nira tenged ong tatang mapinagtalaken ang pagtogat tang mga kasalanan na kaysa ong siam ang polok may siam ang mato-lid ang anday kaministiran ang magtogat.” ");
INSERT INTO agn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ganing pa si Jesus, “Pabetang ta, may tatang babay ang may tampolok ang pidasong koarta nang silber, ig nalipat tang tambilog. Onopa bato tang boaten na? Sindian na enged tang kingki ig siligan na tang balay nira. Dilemen na ta mo-ya asta indi matoman na. ");
INSERT INTO agn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mga matoman na ra ngani, imbitaren na tang mga tangay na ig mga kamalay na, ig maning tanandia, ‘Mangalipay ita! Initao ra tang koartao ang nalipat!’ ");
INSERT INTO agn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Agganingo ong nindio, maning ka ta si tang kalipay tang mga anghil tang Dios mga may tatang mapinagtalaken ang magtogat tang mga kasalanan na.” ");
INSERT INTO agn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ganing pa si Jesus, “May tatang taw ang doroa tang ana nang lali. ");
INSERT INTO agn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mandian ganing tang karian, ‘Tatay, i-dol mo ra ong yen mandian tang mga toroblieno.’ Ig inelay tang tatay ong nirang doroa tang mga pagkabetang na. ");
INSERT INTO agn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pagata-lib tang pirapang kaldaw, pinabakal tang ana nang karian tang parti na, oman nagbiahi ong alawid ang logar. Don ginasta na tang tanan ang koarta na ong anday sayod ang pagparangaboien. ");
INSERT INTO agn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Asing lobot na ra tang tanan, nāton ang nagkatinir ta mabael ang tagletem ong banoang asi. Ig liniwagan tanandia ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Animan nagpatorobolon da lamang tanandia ong tatang taw ang taga don. Pinapaning tanandia ong bokid para magsagod tang mga baboy. ");
INSERT INTO agn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ong sobrang letem na, galiliag ka rin ang mamangan maski ang mga borak da lamang ta ayong agpapan ong mga baboy, piro anday magtorol ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Asing naisip na ra tang bindoat na, ganing ong sadili na, ‘Mo-ya pa don ong yamen, ang tanan ang agsolan ni Tatay bastanti tang pamangan nira. Ang yen tarin, mapatayo ra ong letem! ");
INSERT INTO agn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Magbaliko ra lamang ong ni Tatay, ig aningeno, “Tatay, nagkatalako ong Dios asta ong nio. ");
INSERT INTO agn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Belago ra ta bagay ang ilalaen mong ana mo. Ibilango ra lamang nio ang tatang torobolon mo.” ’ ");
INSERT INTO agn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Oman dayon da tanandiang napanaw ig minolik ong logar nira. “Alawid pa lamang, natorongan da tanandia tang tatay na. Dorong katete-beken tang tatay na ong nandia. Animan nanikad ang minagat ong ana na. Kineget na ig initongan na. ");
INSERT INTO agn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Piro ganing tang ana na, ‘Tatay! Nagkatalako ra ong Dios ig ong nio. Belago ra ta bagay ang ilalaen mong ana mo.’ ");
INSERT INTO agn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Piro ganing tang tatay na ong mga torobolon, ‘Dalien mi! E-lan mi tarin tang kasinloan ang lambongo ig ipatok mi ong nandia. Patokan mi ka ta sising ig rapak. ");
INSERT INTO agn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Komiten mi tang katambekan ang tirnidang baka ig patayen. Mamangan ita ig mangalipay! ");
INSERT INTO agn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tenged midio napatay da tang anao ang na, piro mandian naboing moman. Nalipat, piro natoman si.’ Ig namagimpisa ra tanirang namangalipay. ");
INSERT INTO agn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Piro ang ana nang kakan don pa ong koma. Asing golik da tanandia ig gingabot da ong balay nira, nabasi tanandia ta mga togtogan ig tayawan. ");
INSERT INTO agn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Animan ginoyan na tang tata ong mga torobolon nira ig sine-ma na, ‘Angay? Onopa don ong yaten?’ ");
INSERT INTO agn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Siminabat tang torobolon, ‘Minolik da tang logod mo. Pinapatay tang tatay mo tang katambekan ang tirnidang baka, tenged nagbalik ono tanandiang boi ig indi naonopa.’ ");
INSERT INTO agn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Piro nasilag tang kakan ong logod na ig indi siminled ong balay nira. Animan limindoa tang tatay na ig inalam-alam na. ");
INSERT INTO agn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Piro ganing ong tatay na, ‘Sinirbiana yen ong teled ta yading takon, ig maski minta lamang indiong pisan minatok ong nio. Piro ni maski minta, indio sindolan mo maski tanga kambingan para mangalipay ami tang mga tangayo. ");
INSERT INTO agn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Piro mandian minolik tang ana mong asia. Nagporawas tang manggad mo ong mga babay ang bisiosa. Oman pinapatayan mo pa tanandia tang katambekan ang baka?’ ");
INSERT INTO agn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Siminabat tang tatay, ‘Anao, pirmiang ka-pen ta. Ang tanan ang pagkabetango ong nio ka. ");
INSERT INTO agn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dapat ang mangalipay ita, tenged ong isip ta patay da tang logod mo, animan pario ra ka ang tanandia naboing moman. Nalipat, piro natoman si.’ ” ");
INSERT INTO agn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pagatapos, nagistoria si si Jesus ong mga sinagpan na. Ganing tanandia, “May tatang manggaden ang may agtaligan na. May nagbeg ong nandia ang aggastaen tang agtaligan ang asi tang mga manggad na. ");
INSERT INTO agn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Animan pinagoy na ig sine-ma na, ‘Onopa tang gaba-yano natetenged ong nio? I-dol mo ong yen tang komplitong listan tang pagarawiden mo tang manggado. Ig impisa mandian belag da ta yawa tang taligano.’ ");
INSERT INTO agn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ganing tang agtaligan ong sadili na, ‘Tanggaleno ra tang agaleno ong obrao. Onopa bato tang masinlong boateno? Indi kayao ang magornal. Gaeyako kang magpalimos. ");
INSERT INTO agn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, gata-wanano ra tang boateno agod mga palineno ra tang agaleno ong obrao, risibieno ka tang mga taw ong pamalay-balay nira.’ ");
INSERT INTO agn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Animan, ang bindoat na, talele-tang pinagoy na tang mga may otang nira ong agalen na. Sine-ma na tang primiro, ‘Pirapa tang otang mo ong agaleno?’ ");
INSERT INTO agn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ganing tanandiang siminabat, ‘Tang gatos ang bangang mantika.’ Ig ganing tang agtaligan, ‘Nani tang listan tang mga otang mo. Dali! Komaronga. Boaten ta ang limampolok da lamang.’ ");
INSERT INTO agn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ig sine-ma na ka tang yadoa, ‘Yawa, pirapa ka tang otang mo?’ Siminabat ka tang yadoa, ‘Tang gatos ang pasong ang trigo.’ Ig ganing ka tang agtaligan, ‘Nani tang listan tang mga otang mo.’ ‘Isolat ta walompolok da lamang.’ ");
INSERT INTO agn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mandian, asing pagatako tang agalen tang pagpandaya tang agtaligan na, dinayaw na pa tenged ong kaosayan ang pinaita na ong pagboat na ta midios agod maski komiten da ong obra na, maboi pa tanandia. Tenged ong matod, ang mga taw ang indi gailala ong Dios, mas morosay ang mamagboat ta midios kaysa ong mga taw ang gailala ong nandia.” ");
INSERT INTO agn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ganing pa si Jesus, “Animan, agganingo ong nindio, gamiten mi tang manggad tarin ong kalibotan para magigtangay ong doma, agod pag kabot tang oras ang indi ra magamit mi, risibien amo ka don ong balay ang anday kataposan. ");
INSERT INTO agn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ang mapiaran ong ge-ley ang bagay, mapiaran ka ong mabael. Ig ang mandaya ong ge-ley ang bagay, mandaya ka ong mabael. ");
INSERT INTO agn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mga indi amo mapiaran ong mga manggad tarin ong kalibotan ang na, mono amo pa bato intrigan tang manggad ang matod? ");
INSERT INTO agn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ig mga indi amo mapiaran ong mga kagamitan ta doma, sinopay magtorol ong nindio ta para ong sadili mi?” ");
INSERT INTO agn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ganing pa si Jesus, “Ang tatang taw, indi poiding doroa tang agalen na. Tenged asilagan na tang tambilog ig gegman na tang yadoa. Obin, bogos ang sirbian na tang tata, ig ang tambilog baliwalaen na. Pario ka ta si, indi amo mapagsirbi ta dengan ong manggad ig ong Dios.” ");
INSERT INTO agn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Asing pagabasi tang mga Pariseo tang inaning ni Jesus, linibak nira tanandia tenged mga ingganioso tanira ta koarta. ");
INSERT INTO agn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Animan ganing si Jesus ong nira, “Yamo tang pamagpaita-itang mato-lid ong talongan tang mga taw, piro gata-wanan tang Dios tang ga-tang ong popotokon mi. Animan bantayan mi tang mga sadili mi, tenged ang importanti ong pama-dek tang mga taw, makaerep ong pama-dek tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ang Katobolan ni Moises ig ang mga sinolat tang mga propita, yay ang agtomanen tang mga taw tegka ong pagkabot ni Juan ang Manigboniag. Impisa don, gatoldok da tang Mo-yang Balitang natetenged ong inadian tang Dios. Ig ang tanan ang mga taw dorong reges nirang tenled. ");
INSERT INTO agn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Piro belag ta maning ang linipat da tang Katobolan. Maski malipat tang langit may ang tanek, inding pisan malipat tang kage-leyan ang parti tang Katobolan.” ");
INSERT INTO agn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ganing pa si Jesus, “Mga belagan tang lali tang katawa na, oman mangatawa si tanandia ta doma, loloang pangombabay tanandia. Ig ang mangatawa ong babay ang binelagan, pangombabay ka.” ");
INSERT INTO agn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nagpadayon si Jesus ong pagbitala na, “May tatang manggaden ang paglambong ta maralen ang lambong, ig yading masabor ang pamangan na kaldaw-kaldaw. ");
INSERT INTO agn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","May tata kang malised ang aran na si Lazaro, ig romog ta igad tang sinangoni na. Si Lazaro, lolopa-pak lamang ong may portan tang balay tang manggaden ");
INSERT INTO agn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","para mapamangan maski ang inogat da lamang ang agpe-lek nira. Belag lamang ta maning don, agpalengetan pa tanandia ta mga kiro, ig agsilakan nira tang mga igad na. ");
INSERT INTO agn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mandian, napatay si Lazaro. Kinomit tanandia tang mga anghil ig ingkelan ang pinatepad ong ni Abraham, don ong langit. Oman, napatay ka tang manggaden ig limbeng ka. ");
INSERT INTO agn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Don ong logar ang paragsilotan tang mga patay, pagpinitinsia ta mo-ya tang taw ang asing manggaden. Siminingara tanandia ig don ong alawid natorongan na si Abraham ig si Lazaro ang pagtepadan. ");
INSERT INTO agn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Oman miniteg tang manggaden ang ganing, ‘Tatay ang Abraham! Mate-beka ong yen! Tobolon mo kay si Lazaro ang ite-me na kay ong wi tang toldok na, pabawen na kay tang dilako. Agliwaganong pisan ong apoy ang na!’ ");
INSERT INTO agn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Piro ganing ong nandia si Abraham, ‘Anao, demdemen mong nagpagostoa ra ong kaboi mo ong ta-paw tang kalibotan, ig si Lazaro poros kaliwagan tang nata-liban na. Piro mandian, tanandia pangalipay tani, ig yawa atan pagpinitinsia. ");
INSERT INTO agn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Belag lamang ta sia, may bintang ang dorog kadalem ang galoang tarin ong pagtetengan ta, agod ang tani indi ra mapaning atan ong nio, ig ang atan indi ra ka mapaning tani ong yamen.’ ");
INSERT INTO agn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Animan ganing tang manggaden, ‘Mga maning ta si, Tatay ang Abraham, pagpakiloyo ong nio, papaningen mo kay si Lazaro ong balay tang tatayo. ");
INSERT INTO agn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tenged may lima pang mga logodong poros lali. Tobolon mo kay patigayon si Lazaro para pamanan na kay tanira. Itaben mapaning ka tanira tani ong logar ang nang poros kaliwagan.’ ");
INSERT INTO agn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Piro ganing ong nandia si Abraham, ‘Ong nira ra tang mga sinolat ni Moises ig mga sinolat tang mga propita. Don da lamang tanira mamasi.’ ");
INSERT INTO agn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ganing tang manggaden, ‘Tatay ang Abraham, indi tanira mamasi don. Piro mga may patay ang mambangon ig paning don ong nira, asia mamagtogat tanira tang mga talak nira.’ ");
INSERT INTO agn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Piro ganing si Abraham, ‘Mga indi tanira magparet ong mga sinolat ni Moises ig ong sinolat tang mga propita, indi ka tanira magparet maski ong tatang patay ang naboing moman.’ ” ");
INSERT INTO agn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ganing si Jesus ong mga sinagpan na, “Indi maimong indi komabot tang mga bagay ang pagtokso ong mga taw ang magkatalak. Piro kailo ka tang taw ang agpagalinan ta na. ");
INSERT INTO agn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mga may taw ang magtokso agod magkatalak tang maski tata ong mga gege-ley ang narin, mo-ya pa ta-ketan da lamang tang likel na ta mabael ang bato, oman bontogan ong laod. ");
INSERT INTO agn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Animan bantayan mi tang sadili mi! “Mga magkatalak tang logod mo, samblengen mo. Ig mga magtogat tanandia, patawaden mo. ");
INSERT INTO agn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mga ong teled ta tang kaldaw pitong bisis tanandiang magkatalak ong nio, ig pitong bisis kang magbalik ig mama-dol ta patawad, patawaden mo ka tanandia.” ");
INSERT INTO agn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ganing tang mga apostolis ong Gino, “Papoirsaen mo kay tang pagtalig amen ong Dios.” ");
INSERT INTO agn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ig siminabat tang Gino, “Mga may pagtalig mi ang maski pario ra lamang ong alibotod tang mostasa tang kabael na, poidi amo rang maning ong mabael ang papa ta ayong na, ‘Bonlokon mo tang sadili mo ig loma-teda ong talsi,’ ig sia magtoman ong nindio.” ");
INSERT INTO agn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ganing pa si Jesus, “Pabetang ta, tata ong nindio may torobolon nang pagarado ong bokid, obin pagsagod tang mga karniro. Mandian, pag olik tang torobolon mo magalin ong bokid, aningen mo bato, ‘Tania ra! Mamangana kang lagi!’ ");
INSERT INTO agn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Simpri, aningen mo, ‘Simpanen mo tang yapono! Oman, mapanimarā, sirbiano nio tani mintras pamangano. Ba-loa ra mamangan mga mataposo.’ ");
INSERT INTO agn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bato, pasalamatan mo pa tang torobolon mo tenged nagparet tanandia ong nio? Indi! ");
INSERT INTO agn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Maning ka ta si ong nindio, matoman mi ngani tang tanan ang sinobol ong nindio, maning amo, ‘Yami, mga torobolon ami lamang. Bindoat amen lamang tang mga obligasion amen.’ ” ");
INSERT INTO agn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ong pagpanaw da Jesus paning ong Jerusalem, don tanira simina-lib ong lindiroan tang Samaria ig Galilea. ");
INSERT INTO agn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Asing te-led da tanira ong tatang bario, binagat si Jesus ta tampolok ang taw ang may masit nirang liproso. Ig tenged ong masit nira, siminareng tanira ong alawid. ");
INSERT INTO agn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Namansiteg tanirang ganing, “Maginong Jesus! Mate-beka ong yamen!” ");
INSERT INTO agn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Asing itaen tanira ni Jesus, ganing tanandia, “Panaw amo ra ig ipaita mi tang sinangoni mi ong mga padi.” Ig mintras papanaw pa tanira, namago-ya ra ig nanlimpio ra tang olit nira. ");
INSERT INTO agn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pagaita tang tata ang nago-ya ra tanandia, nagbalik tanandiang giteg ang pagdayaw ong Dios. ");
INSERT INTO agn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Diminagpa ong may kakayan ni Jesus ig nagpasalamat. Mandian, ang taw ang na taga Samaria. ");
INSERT INTO agn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Oman ganing si Jesus ong mga aroman na, “Tampolok tang pinao-yao. Ang siam ong ayra ta? ");
INSERT INTO agn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Angay anday domang nagbalik ig nagdayaw ong Dios, poira lamang ong taw ang nang belag ta Judio?” ");
INSERT INTO agn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Oman ganing si Jesus ong nandia, “Kendenga ig panawa ra. Ang pagtalig mo tang nagpao-ya ong nio.” ");
INSERT INTO agn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tatang kaldaw sine-ma si Jesus tang mga Pariseo mga tanopa magimpisang maggaem tang Dios ong kalibotan bilang adi. Siminabat si Jesus ang ganing, “Mga magimpisa rang maggaem tang Dios ong kalibotan, anday pasinial ang itaen tang mga mata ta. ");
INSERT INTO agn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Anda kay maganing, ‘Telekan mi! Asia ra!’ obin ‘Asi ka!’ Tenged ong kamatodan, nagimpisa rang paggaem tang Dios ong mga popotokon tang mga taw ang pamagtalig ong nandia.” ");
INSERT INTO agn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Oman ganing tanandia ong mga sinagpan na, “Komabot tang timpo ang maildaw among maita maski tata ong mga kaldaw ang yo, ang Ana ta Taw, paggaem da bilang adi. Piro indi itaen mi sia. ");
INSERT INTO agn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Animan mga may maganing ong nindio, ‘Telekan mi! Asia ra tanandia!’ obin ‘Way! asi ka!’ indi amo paning don. Indi amo tomabid. ");
INSERT INTO agn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tenged mga yo, ang Ana ta Taw, magbalik da, ang itaen mi don midio koldap ang golpi ra lamang mangayag magalin ong tatang dobali tang langit tegka ka ong dobali. ");
INSERT INTO agn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Piro ba-lo mainabo narin, kaministiran ang magpinitinsiao kang lagi ta dorog kaliwag ig pangindiano tang mga taw ong timpong na. ");
INSERT INTO agn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ang agboaten tang mga taw ong timpong magbaliko, magkapario tang asing timpo pa ni Noe. ");
INSERT INTO agn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ong timpong asi, anday domang aggintindien tang mga taw kondi pamamangan ig pamanginem, pamangatawa ig agpakatawa, asta ra lamang ong kaldaw ang siminay da Noe ong mabael ang barko ang aggoyan ta arka. Pagatay nira don, namā ig nangapatay tang tanan ang nangabo-wan. ");
INSERT INTO agn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Maning ka ta si asing timpo pa ni Lot. Pamamangan tang mga taw, pamanginem, pamamakal, pamagpabakal, pamagloak ig pamagpa-deng ta balay. ");
INSERT INTO agn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Piro asing kaldaw ang da Lot nagalin da ong Sodoma, kiminoran ta apoy ig mga batong makinit, ig lobot ang nangasirok tang tanan ang nangabo-wan. ");
INSERT INTO agn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Maning ka ta si ong timpong magbaliko. Ang mga taw, anda enged ay kalaom nira ang komaboto ra. ");
INSERT INTO agn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ong oras ang asi, mga may taw don ong loa tang balay na, dapat indi ra tenled ong balay na para komiten tang mga kagamitan na. Ya ka mga may taw don ong bokid, dapat indi ra ka molik para mangomit ta maski onopa. ");
INSERT INTO agn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Demdemen mi tang makaeled ang nainabo ong katawa ni Lot asing minalied tanandia. ");
INSERT INTO agn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ang taw ang agpalabien na tang kaboi na tarin ong ta-paw tang kalibotan, tanandia tang malipatan tang kaboi na. Piro ang taw ang simpan dang malipat tang kaboi na, tanandia tang marisibi ta kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Agganingo ong nindio, mga māton ang labi tang pagbaliko, ig mga may doroang taw ang lolbog ong tanga katrian, ang tambilog e-lan ong langit ig ang tambilog bo-wanan. ");
INSERT INTO agn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Obin mga may doroa nga babayan ang pagkatodan ang panlebek, e-lan ong langit tang tambilog ig ang tambilog bo-wanan ka. ");
INSERT INTO agn_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Obin mga may doroang laling pamagobra ong bokid, ang tambilog e-lan ong langit, ig ang tambilog bo-wanan ka.” ");
INSERT INTO agn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Piro ganing tang mga sinagpan ni Jesus, ang nane-ma ong nandia, “Ong aypa mainabo, Gino?” Siminabat si Jesus ong tatang sarabien. Ganing tanandia, “Mga aripa tang mga ogak pamagolag, don toga tang ayep ang patay.” ");
INSERT INTO agn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Oman inistoria ni Jesus tang palimbawang na ong mga sinagpan na para magtoldok ong nira ang dapat pirming mangadi ig indi manlobay tang nem nira. ");
INSERT INTO agn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ganing si Jesus, “Ong tatang lansangan may osgado ang anday eled na ong Dios ig anday taw ang aggalangen na. ");
INSERT INTO agn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ong lansangan kang asi may tatang babay ang balo ang pirming balik-balik ong osgadong asi ang pama-dol ta tabang tenged pandegdeg ono ong nandia tang kakontra na. ");
INSERT INTO agn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Primiro, indi galiliag ang tomabang tang osgado, piro ong kaboayan, ganing tanandia ong sadili na, ‘Maski indio geldan ong Dios ig indio paggalang ong mga taw, ");
INSERT INTO agn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mo-ya pa tabangano ra lamang tang babay ang na ong kaso na. Magamo! Pirming pagbalik-balik ta! Madalio rang mabeyeg.’ ” ");
INSERT INTO agn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ig ganing tang Gino, “Ta, naba-yan mi ra tang inaning tang malain ang osgado, ang tabangan na tang balo. ");
INSERT INTO agn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mandian, ang Dios pa bato tang indi tomabang ong mga pinilik na? Mga gogoy tanira ong nandia kaldaw may labi, pabaya-bayan na bato tanira? ");
INSERT INTO agn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ganingo ong nindio, tabangan nang lagi tanira ong problima nira. Piro pag baliko tarin ong kalibotan, may itaeno batong mga taw ang pamagtalig pa ong yen, ang Ana ta Taw?” ");
INSERT INTO agn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mandian, may mga taw don ang pabetang nira ong sadili nira tanira ono mato-lid, ig ang pama-dek nira ong doma dorog kadibabak. Animan inistoria ong nira ni Jesus tang palimbawang na. ");
INSERT INTO agn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“May doroang taw ang napaning ong Timplo para mangadi. Ang tata Pariseo ig ang tata manigtokot ta bois. ");
INSERT INTO agn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ke-deng tang Pariseo ig memene-mene ang pangadi ang ganing, ‘Dios, pagpasalamato ong nio ang yo belago ta pario ta domang taw ang takawan, dayador ig pangombabay, ig belago ta pario tang manigtokot ta bois ang asi. ");
INSERT INTO agn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pagpaletemo ta madoa ong teled ta tang dominggo, ig pagbolontado ta tampolok ang porsinto ong tanan ang gitaeno.’ ");
INSERT INTO agn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Piro ang manigtokot ta bois, ke-deng lamang ong alawid-lawid. Inding pisan sisingara ong dibabaw, kondi agdēnan na lamang tang debdeb na ig pangadi ang ganing, ‘Ampoanong Dios, mate-beka ong yen ang tatang mapinagtalaken.’ ” ");
INSERT INTO agn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ig ganing pa si Jesus, “Agganingo ong nindio, ang manigtokot ta bois ang asi, yay ang minolik ang binilang dang mato-lid ong pama-dek tang Dios, ig belag tang Pariseo. Tenged ang pagpalawig tang sadili na, ipababak. Ig ang pagpababak, tanandia tang ipalawig.” ");
INSERT INTO agn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tatang kaldaw may mga taw ang pamagekel tang mga ana nirang gege-ley ong ni Jesus para pabindisionan nira. Asing itaen narin tang mga sinagpan na, sinambleng nira tang mga taw. ");
INSERT INTO agn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Piro pinalenget ni Jesus ong nandia tang mga sinagpan na ig ganing, “Pabayan mi lamang ang palenget ong yen tang mga mola. Indi bawalen mi. Tenged ang mga taw ang pario ong mamolang narin, yay ang mabilang ong inadian tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tandan mi narin: Ang maski sinopa, mga indi tanandia magpasakep ong gaem tang Dios pario ta tatang mola, asia indi enged tanandia mabilang ong inadian na.” ");
INSERT INTO agn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","May tatang pangolokolong Judio ang nane-ma ong ni Jesus ang ganing, “Maistro, yawa mo-yang taw. Onopay masinlong boateno para marisibio tang kaboing anday kataposan?” ");
INSERT INTO agn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ganing si Jesus ang siminabat, “Angay aggoyano nio ta mo-ya? Ang Dios lamang tang mo-ya. ");
INSERT INTO agn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gata-wanan mo ra tang ga-tang ong Katobolan: ‘India mangombabay, india mamatay ta taw, india manakaw, india magtistigo ta bo-li, ig galangen mo tang tatay may ang nanay mo.’ ” ");
INSERT INTO agn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ganing ka tang lali, “Ang tanan ang asia agtomaneno ra ka mimpisang ge-leyo pa.” ");
INSERT INTO agn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pagabasi ta si ni Jesus, ganing tanandia, “Tanga bagayan da lamang tang korang ong nio. Ipabakal mo tang tanan ang pagkabetang mo, oman ang bayad na i-dol mo ong mga malilised. Mga boaten mo sia, magkatinira ta manggad ang tinagana tang Dios don ong langit. Pagatapos, magbalika ig tomabida ong yen.” ");
INSERT INTO agn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Piro pagabasi ta si tang lali, pinongawan tanandia ta mo-ya tenged dorong manggad na. ");
INSERT INTO agn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Asing itaen ni Jesus ang dorog kapongaw tang taw ang asing manggaden, ganing tanandia, “Kaliwag ang ma-led ong inadian tang Dios tang taw ang manggaden! ");
INSERT INTO agn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas madali pa nganing tenled tang tatang kamilio ong boloat tang singgoay kaysa tatang taw ang manggaden ang tenled ong inadian tang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nane-ma tang mga nangabasi tang binitala ni Jesus, “Mga maning don, sinopa enged tang malibri?” ");
INSERT INTO agn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Siminabat si Jesus, “Na indi maboat ta taw, piro belag ta maliwag ong Dios. Tenged anday imposibli ong Dios.” ");
INSERT INTO agn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Minitala si Pedro, “Yami, bino-wanan amen tang mga pamalay-balay amen para tomabid ong nio.” ");
INSERT INTO agn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Ee, kaman,” ganing si Jesus, “ig narin tang matod: Ang sinopay nagbo-wan tang balay na, ang katawa na, mga logod na, mga ginikanan na obin mga ana na para mapagsirbi ong Dios ong inadian na, ");
INSERT INTO agn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ang taw ang asi indi maimong indi oldan ta doro-dorong balet mandian ong kaboi na tarin, ig ong dobaling kaboi oldan pa ta kaboing anday kataposan.” ");
INSERT INTO agn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Oman pinabelag ta ge-ley ni Jesus tang tampolok may doroang apostolis na ong mga taw tenged may ibeg na si ong nira. Ganing si Jesus, “Tandan mi. Mandian agpaning ita ra ong Jerusalem, ig mainabo ra don tang mga bagay ang sinolat tang mga propita asing tokaw natetenged ong yen, ang Ana ta Taw. ");
INSERT INTO agn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yintrigao ong gaem tang mga belag ta Judio. Insoltono nira, paeyakeno ig olakan. ");
INSERT INTO agn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Latigono pa nira ba-lō patayen. Piro ong ya-long kaldaw maboiong moman.” ");
INSERT INTO agn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Piro indi naintindian tang mga sinagpan na. Andang pisan ay kalibotan nira tang maliag nang yaning, tenged midio may pagdapa pa ong mga kinaisipan nira. ");
INSERT INTO agn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Asing gingabot da si Jesus ong siodad tang Jerico, may tatang taw ang boray ang lolopa-pak don ong binit tang dalan ang pagpalimos. ");
INSERT INTO agn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Asing ba-yen nang pamansita-lib tang dorong taw, nane-ma tanandia mga onopa tang gainabo. ");
INSERT INTO agn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Tata-lib si Jesus ang taga Nazaret,” ganing tanira. ");
INSERT INTO agn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ig dayon ang miniteg tang boray, “Jesus, Inampo ni David! Mate-beka ong yen!” ");
INSERT INTO agn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sinambleng tanandia tang mga taw ang don ong tokawan, piro mas sinodoan na pa enged tang iteg na ang ganing, “Inampo ni David! Mate-beka ong yen!” ");
INSERT INTO agn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Siminareng si Jesus ig nanobol ang e-lan tang boray ong nandia. Pagalenget tang boray, sine-ma tanandia ni Jesus, ");
INSERT INTO agn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Onopa tang galiliagan mong boateno ong nio?” Siminabat tanandia, “Magino, galiliago rin ang maita!” ");
INSERT INTO agn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ig ganing si Jesus ong nandia, “Yawa, maitā ra! Ang pagtalig mo tang nagpao-ya ong nio.” ");
INSERT INTO agn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lagi-lagi naita ra tang boray. Oman siminabid tanandia ong ni Jesus ang dorong pasalamat na ig pagdayaw ong Dios. Asing itaen narin tang mga taw, namagdayaw da ka tanirang tanan ong Dios. ");
INSERT INTO agn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na-led da si Jesus ong lansangan tang Jerico ig nagpadayon tang panaw na. ");
INSERT INTO agn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Don may tatang manggaden ang pangolokolo ong mga manigtokot ta bois, ang aran na si Zaqueo. ");
INSERT INTO agn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Si Zaqueo, dorong kaliag nang itaen si Jesus mga sinopa tanandia. Piro indi itaen na tenged ong kadodoron ta taw, ig tanandia dibabak ang taw. ");
INSERT INTO agn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Animan ang bindoat na, nanikad tanandiang napatokawan ig kimina-yat ong tatang mabael ang ayong aggoyan ta sikomoro para itaen na si Jesus mga toma-lib don. ");
INSERT INTO agn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pagakabot ni Jesus ong toga tang ayong asi, siminingara tanandia ig ganing, “Zaqueo, tomaboana kang lagi. Kaministiran dono domayon ong balay mo mandian.” ");
INSERT INTO agn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nagaporang siminaboan si Zaqueo ig dorong kalipay nang nagrisibi ong ni Jesus ong balay na. ");
INSERT INTO agn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Piro namagmoro-moro tang tanan ang nangaita. Ganing tanira, “Angay don tanandia dadayon ong balay ta tatang mapinagtalaken?” ");
INSERT INTO agn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mandian, asing don tanira ong balay, kimindeng si Zaqueo ig ganing ong Gino, “Magino, maning ta na tang boateno. Ang katengan tang manggado i-dolo ong mga malilised. Ig mga may atan ang nadayano, doblieno ta epat tang ibaliko ong nira.” ");
INSERT INTO agn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ig ganing ong nandia si Jesus, “Nalibri ra mandian tang mga taw tarin ong pamalay-balay ang na. Tenged ang taw ang na, tata ka ong mga inampo ni Abraham ang midio ganga-ngi ta dalan. ");
INSERT INTO agn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ig yo, ang Ana ta Taw, napaningo tarin ong kalibotan para dilemeno ig ilibri tang mga taw ang ganga-ngi ta dalan.” ");
INSERT INTO agn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nagpadayon si Jesus ong pagbitala na, ig inistoria na tang tata pang palimbawa ong mga nangabasi ong na-kaw ang mga binitala na. Sinayod na narin tenged alenget da tanira ong Jerusalem, ig ang kalaom tang mga taw magimpisa ra tang paggaem tang Dios bilang adi. ");
INSERT INTO agn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ganing si Jesus, “May tatang prinsipi ang nagbiahi ong alawid ang banoa para boaten tanandiang adi tang pinagalinan na. Oman dayon ang molik ong banoa na. ");
INSERT INTO agn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Piro ba-lo tanandia nagalin, ginoyan na tang tampolok ong mga torobolon na, ig inintrigan na ta tag talele-ta nirang koartang bolawan. Ganing tang prinsipi ong mga torobolon na, ‘Ipapanaw mi sia ong nigosio mintras andao tarin.’ ");
INSERT INTO agn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mandian, ang prinsiping asi inding pisan maliliagan tang mga kasimanoa na. Animan pinapaning kang lagi nira tang domang mga kasimanoa nira don ong paningan tang prinsipi para aningen nira tang kalawigan ang adi don ang indi tanira maliag ang magimong adi nira tang prinsiping asi. ");
INSERT INTO agn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Piro bindoat ka enged tanandiang adi nira, oman minolik da tanandia. Pagakabot na, pinampagoy na tang mga torobolon ang inintrigan na tang mga koartang bolawan para mata-wanan na mga pirapa tang naganansia tang kada tata. ");
INSERT INTO agn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Napalenget tang primirong sindolan na ig ganing, ‘Magino, ang koartang inintriga mo ong yen, nagimo rang tampolok.’ ");
INSERT INTO agn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“ ‘Mo-ya!’ ganing tang ba-long adi. ‘Mo-yāng torobolon! Yawa, nataligana ong ge-ley ang bagay. Mandian boatena ra yen ang gobirnador ong tampolok ang siodad.’ ");
INSERT INTO agn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Napalenget ka tang yadoang torobolon ig ganing, ‘Magino, ang koartang inintriga mo ong yen, nagimo rang lima.’ ");
INSERT INTO agn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ganing tang adi, ‘Mo-ya! Yawa, boatena ka yen ang gobirnador ong lima nga siodad.’ ");
INSERT INTO agn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Oman napalenget tang tata pang torobolon ig ganing, ‘Magino, nani tang koarta mong bolawan. Binongoto ta ta-leng ig sinaloko ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Geldano ong nio tenged yawa maigpit ang taw. Agkomiten mo tang ganansia tang binedlayan ta doma, ig maski belag ta yawa tang nagloak, aggayegen mo.’ ");
INSERT INTO agn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ganing tang adi ong nandia, ‘Anday kointa mong torobolon! Ang inaning mong asia, yay ang magosgar ong nio! Gata-wanan mo palang maigpito, ig ganinga agkomiteno tang ganansia ig ang pa-bat maski belag ta yo tang nagbedlay. ");
INSERT INTO agn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Angay indi bino-log mo ong bangko tang koartao, agod mga mabaliko, makomito asta ang tobo na?’ ");
INSERT INTO agn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Oman ganing tang adi ong mga pamansi-deng don, ‘Komiten mi ong nandia tang koartang bolawan ig i-dol mi ong torobolon ang naganansia ta tampolok.’ ");
INSERT INTO agn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Magino,’ ganing tanira. ‘Tanandia may tampolok na rang koartang bolawan!’ ");
INSERT INTO agn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Siminabat tang adi, ‘Agganingo ong nindio, ang kada tata ang mataligan, oldan pa. Piro ang indi mataligan, maski ang ge-ley lamang ang inintriga ong nandia, sia komiten pa ka enged ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ig natetenged pa ka ong mga taw ang indi nangaliliag ang yo tang magimong adi nira, e-lan mi tarin ig pamatayen mi ong talongano.’ ” ");
INSERT INTO agn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Asing pagatapos ni Jesus ang nagistoria tang palimbawang asi, napatokawan tanandia ong pagpanaw nira tomakat ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Asing gingabot pa lamang tanira ong mga bario tang Betfage may Betania, ong bokid ang aggoyan ta Bokid tang Kaoliboan, pina-kaw ni Jesus tang doroang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ganing tanandia ong nira, “Paning amo don ong dadaton ang bario. Ong pagteled mi, asia itaen ming lagi don tang tatang asnong agkeke-ked. Ang asnong asi mola pa, indi pa gatayan ta taw. Obaden mi ig e-lan mi tarin ong yen ");
INSERT INTO agn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mga may mane-ma ong nindio ang angay aggobaden mi, aningen mi lamang, ‘Na kaministiran tang Gino.’ ” ");
INSERT INTO agn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Animan namampanaw da tang doroang sinagpan na ig kinabotan ka kaman nira tang asnong asi, pario ong inaning ong nira ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Asing aggobaden da nira, sine-ma tanira tang may nandia, “Hoy! Angay aggobaden mi sia?” ");
INSERT INTO agn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Siminabat tang doroa, “Kaministiran tang Gino.” ");
INSERT INTO agn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ingkelan nira ong ni Jesus tang asno ig matapos ang dinamdaman nira tang boko-boko na tang mga lambong nirang panta-paw, siminay da si Jesus. ");
INSERT INTO agn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mintras tata-lib si Jesus ang tatay ong asno, pamaglatag ka tang mga taw tang mga lambong nirang panta-paw ong dalan para panawan na, bilang padengeg ong nandia pario ta tatang adi. ");
INSERT INTO agn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Asing alenget da si Jesus ong Jerusalem, ong dalan ang pababak ong Bokid tang Kaoliboan, kadoro-doroan da tang mga sinagpan na. Dorong pisan ang kalipay nira ig pamansiteg tanirang tanan ang pamagdayaw ong Dios tenged ong mga makabebereng ang mga bagay ang inita ra nira. ");
INSERT INTO agn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ganing tanira, “Dayawen tang ading kiminabot mandian ang sinobol tang Dios! Kao-yan ong langit! Dayawen tang Dios!” ");
INSERT INTO agn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ganing ong ni Jesus tang pirapang Pariseong don ong kayadian, “Maistro, samblengen mo tang mga sinagpan mo!” ");
INSERT INTO agn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Piro siminabat si Jesus, “Agganingo ong nindio, mga magipes tanira, maski ang mga bato ya ray mamansiteg ang mamagdayaw ong yen.” ");
INSERT INTO agn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Asing alenget da si Jesus ong siodad ig gatorongan na ra, ini-yakan na tang Jerusalem. ");
INSERT INTO agn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ig ganing tanandia, “Ay yamong mga taga Jerusalem! Mga nata-wanan mi ka rin lamang ong kaldaw ang na mga onopa tang mapagtorol ta kao-yan ong banoa mi! Piro impisa mandian midio may pagdapa ong mga kinaisipan mi agod indi amo ra mangaintindi. ");
INSERT INTO agn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Komabot tang kaldaw nga ang logar mi palibotan tang mga kasoay mi, ig a-lawan amo nira ong dobali may dobali agod anda rang pisan ay malapotan mi. ");
INSERT INTO agn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Yamong tanan atan ong teled, patayen amo nira ig lobot nirang gebaen tang siodad mi may ang alalawig ang mga padir na. Anda enged ay mabo-wan ong mga batong pamagtara-paw ta-pawan ang asia. Tenged indi inintindi mi tang pagkabot tang Dios para ilibri amo.” ");
INSERT INTO agn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pagakabot nira ong Jerusalem, siminled si Jesus ong Timplo ig pinalayas na tang tanan ang pamagpabakal ta mga ayep ang igsaragda don. ");
INSERT INTO agn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ganing tanandia ong nira, “Ga-tang ong Sagradong Kasolatan, ang balay tang Dios logar ang parangadian. Piro yamo, bindoat mi rang paragsirimetan ta mga takawan!” ");
INSERT INTO agn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kaldaw-kaldaw, pagtoldok si Jesus ong Timplo. Ang mga pangolokolo ong mga padi, ang mga manigtoldok tang Katobolan, asta ang mga pangolokolo ong banoa, pamagdilem ta midios agod mapapatay nira si Jesus. ");
INSERT INTO agn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Piro anday naboat nira tenged pisan ang gangawili tang tanan ang taw ang mamasi ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tatang kaldaw, mintras pagtoldok si Jesus ong mga taw don ong Timplo ig pagpatako tang Mo-yang Balitang nagalin ong Dios, pinalengetan tanandia tang mga pangolokolong padi may ang mga manigtoldok tang Katobolan, aroman ka nira tang mga mepet tang banoa. ");
INSERT INTO agn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ganing tanira ong ni Jesus, “Yaning mo ong yamen onopay podir mong magboat tang mga bagay ang na tarin ong Timplo. Sinopa tang nagtorol ong nio tang podir ang asia?” ");
INSERT INTO agn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ganing si Jesus ang siminabat, “Te-maen amo ka yen. Sabateno nindio. ");
INSERT INTO agn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ong aypa nagalin tang podir ni Juan para magboniag? Ong Dios bato obin ong taw?” ");
INSERT INTO agn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ig namagampang-ampang tanira mga onopay isabat nira. Ganing tanira, “Mga maning ita ‘nagalin ong Dios,’ maning ka tanandia ong yaten ‘Oman, angay indi amo namagparet ong ni Juan?’ ");
INSERT INTO agn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Piro mga maning ita ‘nagalin ong taw,’ banggilen ita tang tanan ang taw. Tenged pamagparet tanirang si Juan propita tang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Animan siminabat lamang tanira ang ganing, “Indi ami gatako.” ");
INSERT INTO agn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ig ganing si Jesus ong nira, “Mga maning don, indio ka magbeg ong nindio mga ong aripa pagalin tang yen ang podir ang magboat tang mga bagay ang na.” ");
INSERT INTO agn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Oman inistoria ni Jesus ong mga taw tang palimbawang na. “May tatang taw ang nagloak ta mga obas ong tanek na. Pagatapos, inintriga na tang kaobasan ong mga agsador, ba-lo tanandia nagbiahi ong alawid ang logar ig nagboay don. ");
INSERT INTO agn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Asing timpo rang igparangalap, sinobol na tang tatang torobolon na para mangomit tang parti na. Piro pagkabot don, binogbog tang mga agsador tang torobolon ang asi ig pinaolik nirang anday ekel na. ");
INSERT INTO agn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Oman nanobol si tang may nandia ong tata pang torobolon na. Piro binogbog si ka nira tang torobolon ang na, pinaeyak ig pinaolik kang anday ekel na. ");
INSERT INTO agn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mandian, nanobol pa ka enged tang may nandia ong ya-long torobolon na. Narin sinibatan nira, tapos sinolmon ong loa tang kaobasan. ");
INSERT INTO agn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Oman ganing tang may nandia ong sadili na, ‘Onopa bato tang boateno? Mo-ya pa sigoro, ang palanggao ang anao ra lamang mismo tang tobolono don. Balampa galangen nira tanandia.’ ");
INSERT INTO agn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Piro asing itaen tang mga agsador tang ana nang gingabot da, ganing tanirang namagampang-ampang, ‘Asia ra tang manonobli! Patayen ta tanandia agod magimong yaten da tang kaobasan ang na.’ ");
INSERT INTO agn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Animan dinep ang lagi nira tanandia, ginoyodan ong loa tang kaobasan ig don pinatay. “Mandian,” ganing si Jesus, “onopa bato tang boaten tang may nandia tang kaobasan ong mga agsador ang asi? ");
INSERT INTO agn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ang boaten na, molik tanandia ig pamatayen na ka tanira! Oman yintriga na si ong doma tang kaobasan na.” Pagabasi tang mga taw, ganing tanira, “Balampa ra lamang anda kay mainabong maning ta si!” ");
INSERT INTO agn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pina-dekan tanira ni Jesus ig ganing, “Mga maning don tang agganing mi, onopa bato tang maliag yaning tang ga-tang ang narin ong Sagradong Kasolatan: ‘Ang batong pinlek tang mga manigpa-deng tang balay, yay ang ginamit tang Dios ig nagimong kaimportantian ong tanan ang batong pagpabaked tang balay.’ ");
INSERT INTO agn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ang mabegtak ong batong narin, malapik-lapik. Ig ang mabegtakan ta sia, maremek-remek ang enged!” ");
INSERT INTO agn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ang kaliliagan tang mga manigtoldok tang Katobolan ig ang mga pangolokolo ong mga padi, don ang lagi depen da nira si Jesus, tenged naintindian nirang tanira tang agpataman tang palimbawang asi. Piro gengeldan tanira ong mga taw. ");
INSERT INTO agn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Animan namagelat kang lagi tanira ta timpo. Nanol tanira ta pirapang taw ang magpaita-itang pamagdilem ta kamatodan, agod depdepen nira si Jesus ong mga pamitala na, oman dayon dang idimanda nira ong gobirnador. ");
INSERT INTO agn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ganing tang mga sinolan ang asi ong ni Jesus, “Maistro, gata-wanan amen ang poros matod tang agbibitala mo ig agtotoldok mo. Pario tang pagpama-dek mo ong tanan, ig agtotoldok mo lamang tang kamatodan natetenged ong kaliagan tang Dios ang boaten tang mga taw. ");
INSERT INTO agn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Animan, mga ong nio, sigon ong Katobolan ta, tama ka bato ang itang mga Judio magbayad ta bois ong Adi tang Roma obin indi?” ");
INSERT INTO agn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Piro gata-wanan ni Jesus tang aggisipen nirang malain. Animan ganing ong nira, ");
INSERT INTO agn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ipaita mi ong yen tang tanga koartan. Ninopang itsora ig aran tang nasolat atan?” “Ang Adi tang Roma,” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ig ganing si Jesus, “Mga maning don, i-dol mi ong adi tang para ong adi, ig i-dol mi ong Dios tang para ong Dios.” ");
INSERT INTO agn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Animan indi nadep nira si Jesus ong mga pamitala na ong talongan tang mga taw. Ig ong kabereng nira ong sabat ni Jesus, nagipes da lamang tanira. ");
INSERT INTO agn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Oman, may atan kang mga Saduseo ang namampaning ong ni Jesus para mane-ma. Tanira tatang sikta tang mga Judio ang indi pamagparet ang maboing moman tang mga patay. ");
INSERT INTO agn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ganing tanira ong ni Jesus, “Maistro, may tobol ang sinolat ni Moises para ong yaten ang ganing, mga mapatay tang lali ang anday ana nira tang katawa na, ang logod tang lali dapat katawaen na tang babay ang asing nabalo, agod magkatinir tanira ta ana para ong laling napatay. ");
INSERT INTO agn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mandian, may pitong mamaglogod ang poros lali. Nangatawa tang kakan ig napatay ang anday ana nira. ");
INSERT INTO agn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Oman ang yadoang logod nangatawa ong babay ang nabalo, piro napatay si kang anday ana nira. ");
INSERT INTO agn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Maning ka ta si tang nainabo ong ya-lo, sa-sad ong yapito. Ang pitong mamaglogod, napangatawa ong babay ig poros nangapatay ang anday ana nira. ");
INSERT INTO agn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Asing ori ra, ang babay napatay ka. ");
INSERT INTO agn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mandian, ong oring kaldaw, mga boien ang moman tang mga patay, sinopa ong nirang pito tang magimo sing katawa tang babay? Tenged tanirang tanan nagimong katawa na.” ");
INSERT INTO agn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ganing si Jesus ang siminabat, “Tarin ong kalibotan ang na, pangatawa ig agkatawaen tang mga taw. ");
INSERT INTO agn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Piro ang mga lali ig mga babay ang magapil ong mga dapat ang boien ang moman agod e-lan ong dobaling kaboi, indi ra tanira mamagkaratawan. ");
INSERT INTO agn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Indi ra ka tanira mangapatay tenged pario ra tanira ong mga anghil. Tanira mga ana tang Dios, tenged binoi tanirang moman. ");
INSERT INTO agn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Si Moises mismo nagpamatod nga ang mga patay agboien ang oman. Tenged ong istoria nang natetenged ong dibabak ang papa ta ayo, ginoyan na tang Gino ta ‘Dios ni Abraham, Dios ni Isaac, ig Dios ni Jacob.’ ");
INSERT INTO agn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Piro ang Dios, belag ta Dios tang mga patay. Tanandia Dios tang mga boi. Ig ong pama-dek tang Dios boi tang tanan ang taw.” ");
INSERT INTO agn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ganing tang domang mga manigtoldok tang Katobolan don, “Maistro, kasinlo tang sabat mong asia!” ");
INSERT INTO agn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ig anda ray mangas ang mane-mang moman ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ganing ong nira si Jesus, “Monopa maning tang mga taw nga ang Cristo Inampo ni Ading David? ");
INSERT INTO agn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Si David mismo tang naganing ong libro tang mga Salmo, ‘Ganing tang Ginong Dios ong yen ang Gino: Komaronga ong yen ang to, ");
INSERT INTO agn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asta ra lamang pasokono ong nio tang tanan ang kasoay mo.’ ");
INSERT INTO agn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mandian, mga ‘Gino’ tang ginoy ni David ong Cristo, monopa maning tang mga taw ang tanandia inampo ni David?” ");
INSERT INTO agn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mintras pamamasi pa tang dorong taw ong ni Jesus, ganing tanandia ong mga sinagpan na, ");
INSERT INTO agn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Magandam amo ong mga manigtoldok tang Katobolan ni Moises. Dorong kalipay nirang magpanaw-panaw ang paglambong ta marimaboat. Ig doro kang kaliliag nirang salodoan tang mga taw ong plasa. Mga ong simban ig ong mga kombida, ang kaliliagan nira, komarong ong masisinlong kalarongan ang para ong mga importanting taw. ");
INSERT INTO agn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Agkalawen nira tang mga pagkabetang tang mga babay ang balo, asta ang balay nira. Oman pamagpaita-ita ang tanira moro-ya ong pagpangadi nira ta dorog kaboat ong talongan tang mga taw. Animan magimong mas mabelat pa tang silot ong nira!” ");
INSERT INTO agn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Don pa ka si Jesus ong Timplo. Pagpa-dek na, inita na tang mga manggaden ang pamagbo-log tang mga bolontad nira ong beretangan ta koarta. ");
INSERT INTO agn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","May inita na kang tatang babay ang balo ang dorog kalised ang nagbolontad ta doroang sinsilio. ");
INSERT INTO agn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ganing si Jesus, “Ong kamatodan, ang babay ang asia tang nagbolontad ta mas mabael pa ong nirang tanan. ");
INSERT INTO agn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tenged tanira, ang sindol nira ang gasobra ra lamang ong kaministiran nira. Piro ang balong na, maski malised lamang, sindol na pa tang tanan ang para ong pangaboian na.” ");
INSERT INTO agn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Agpagampangan tang doma ong mga sinagpan ni Jesus tang Timplo. Kasisinlo ono tang mga mababael ang batong ginamit don, asta ang mga dikorasion na ang sindol tang mga taw. Animan ganing si Jesus, ");
INSERT INTO agn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ang mga gitaen ming asia, komabot tang timpong anda enged ay mabo-wan ong mga batong pamagtara-paw ta-pawan ang asia. Mangapegnak ang tanan!” ");
INSERT INTO agn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nane-ma tanira ong ni Jesus, “Maistro, tanopa mainabo tang inaning mong mapegnak tang Timplo? Ig onopay mga pasinial mga alenget dang mainabo tang mga bagay ang asia?” ");
INSERT INTO agn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Siminabat si Jesus ang ganing, “Magandam amo agod indi amo maloko ta maski sinopa. Tenged yading mamansikabot ang magekel tang arano, ig kada tata magpailala ang maning, ‘Yo tang Cristo!’ ig ‘Kiminabot da tang oras!’ Indi amo enged mamagparet ong nira. ");
INSERT INTO agn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Indi amo mangelba mga mabalita amo ta mga gira ig mga golo. Ang mga bagay ang na kaministiran ang mainabo, piro belag pa ta sia tang kataposan tang kalibotan.” ");
INSERT INTO agn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ig ganing pa tanandia, “Mamaggiran tang mga nasion ig mamagkorontran tang mga inadian. ");
INSERT INTO agn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Manlinog ta dorog kapoirsa, ig mangapatay tang mga taw ong kada logar tenged ong letem ig ong mga masit. May makaeled ang mga bagay ig makabebereng ang mga pasinial ang itaen ong langit. ");
INSERT INTO agn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Piro ba-lo mainabo tang tanan ang asi, depen amo ig papagpinitinsiaen tenged lamang ong pagto mi ong yen. E-lan amo ong mga osgado ig prison amo nira. Ig natetenged ka ong pagto mi ong yen, patalongaen amo ka nira ong mga adi ig ong mga gobirnador. ");
INSERT INTO agn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ig don ya ray ang oras ang mapagpamatod amo ong nira tang natetenged ong yen. ");
INSERT INTO agn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Piro i-tang ming lagi ong isip mi ang indi amo magpalibeg tang kolo mi mga monopa tang pagdipinsa mi ong sadili mi. ");
INSERT INTO agn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tenged yo tang magtorol ong nindio ta kinata-wanan ig kaosayan ang somabat ong nira, agod indi amo kontraen obin soplaken ta maski sinopa ong mga kasoay mi. ");
INSERT INTO agn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ang mga ginikanan mi, mga logod, mga kaparintian ig mga tangay mi, yay ang magtraidor ong nindio ig magintriga ong osgado. Ig ang doma ong nindio ipapatay ang enged. ");
INSERT INTO agn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Asilagan amo tang tanan tenged ong pagto mi ong yen. ");
INSERT INTO agn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Piro maski maning don, ta-lingan amo pa enged tang Dios agod maski ang tang naet ong boa mi indi ma-lek. ");
INSERT INTO agn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Animan agoantaen mi lamang tang tanan ang asia agod marisibi mi tang kaboing anday kataposan.” ");
INSERT INTO agn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ganing pa si Jesus, “Mga itaen mi ra nganing agpalibotan da ta mga sondalo tang siodad tang Jerusalem, mata-wanan mi rang alenget dang distroson. ");
INSERT INTO agn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ong kaldaw ang asi, ang mga taw ang pamansistar tarin ong Judea kaministiran mamanikad dang lagi ong kabobokidan. Ig ang asi ong teled tang Jerusalem, dapat mamansiloa rang lagi, ig ang mga asi ong mga koma, indi ra mamansi-led ong siodad. ");
INSERT INTO agn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tenged asi ya ray ang mga kaldaw tang pagsiriloton, para mainabo tang tanan ang ga-tang ong Sagradong Kasolatan. ");
INSERT INTO agn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ong mga kaldaw ang asi, kailo ka tang mga pamagabdet asta ang mga pamagpatiti! Tenged komabot tang sobrang kaliwagan ong logar ang na. Ig matalapoan da tang mga inampo ni Israel tang kasisilagen tang Dios. ");
INSERT INTO agn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mangapatay tang doma ong gira, ig ang doma biagen, oman e-lan ong sari-saring mga banoa. Ig ang Jerusalem ma-mok ta mga taw ang belag ta Judio ang mandegdeg ig maggaem ong mga gangabo-wan don, asta matapos tang timpong tinirmino tang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ganing pa si Jesus, “May mga pasinial ang itaen mi ong kaldaw, ong bolan, asta ong mga bitokon. Ig tarin ong tanek, mamansieled ig mangataranta tang mga taw ong kada logar tenged ong lampak tang mababael ang langeb. ");
INSERT INTO agn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kentang tang mga taw ong sobrang eled nira ang onoray mainabo tarin ong kalibotan. Tenged pakedegen tang tanan ang bagay ang aggitaen ong langit. ");
INSERT INTO agn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ig yo, ang Ana ta Taw, itaeno ang tatabid ong tatang onom ang pabalik ong kalibotan, ang pagekelo tang makabebereng ang gaem ig kadengegan. ");
INSERT INTO agn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mga magimpisa rang mainabo tang mga bagay ang na, mangalipay amo ra ig magelat-elat, tenged alenget da tang pagrilibrien tang Dios ong nindio.” ");
INSERT INTO agn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Inistoria pa ni Jesus tang palimbawang na. “Telekan mi tang papa tang igos, ig ang domang papa ta ayo. ");
INSERT INTO agn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mga itaen mi ra ngani narin ang pangolbot da, gata-wanan ming alenget da tang koarisma. ");
INSERT INTO agn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pario ka ta si, mga itaen mi ra nganing gainabo ra tang mga bagay ang inaningo ong nindio, mata-wanan ming alenget dang maggaem tang Dios bilang adi. ");
INSERT INTO agn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tandan mi: May doma ong mga taw ang gangaboi mandian ang kabotan pa nira tang tanan ang mga bagay ang nang mainabo. ");
INSERT INTO agn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Malipat tang langit may ang tanek, piro ang yen ang mga bitala magpadayon ang anday kataposan.” ");
INSERT INTO agn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ganing si Jesus ong nira, “Bantayan mi tang mga sadili mi, itaben ya ra lamang ay maboat mi ang magpagosto amo tang malain ang kalipay, magpabaleng ig magpaborido natetenged ong mga irintindien mi ong kaboi mi tarin ong kalibotan. Oman golpi among kabotan tang kaldaw ang asi ang indi amo nabantay. ");
INSERT INTO agn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tenged ang tanan ang taw ong ta-paw tang kalibotan, kabotan ang enged tang kaldaw ang asi. ");
INSERT INTO agn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Animan magbantay amo ong tanan ang oras. Mangadi among pirmi para oldan amo ta mapoirsang nem ong pagtaralongaen mi tang tanan ang kaliwagan ang komabot. Ig mga mata-liban mi si, indi amo maeyak ang tomalonga ong yen, ang Ana ta Taw.” ");
INSERT INTO agn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kaldaw-kaldaw pagtoldok si Jesus ong Timplo. Mga apon da, pagalin tanandia ong siodad ig don gapoyat ong Bokid tang Kaoliboan. ");
INSERT INTO agn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Māga pa ong damal-damal, pamansipaning da tang mga taw don ong Timplo para mamamasi ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Galenget da tang bispiras tang Pista tang Tinapay ang Anday Pampalsa na. Ang bispiras ang na yay ang aggoyan Pista tang Pagta-lib tang Anghil. ");
INSERT INTO agn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ang mga pangolokolo ong mga padi may ang mga manigtoldok tang Katobolan, pirming pamagdilem ta midios para mapapatay nira si Jesus ang indi magkagolo, tenged gengeldan tanira ong mga taw. ");
INSERT INTO agn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Oman, ginaeman da ni Satanas si Judas ang aggoyan ta Iscariote, tata ong tampolok may doroang apostolis. ");
INSERT INTO agn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nagpanaw si Judas ig nagigampang ong mga pangolokolo ong mga padi may ong mga kapitan tang mga goardia tang Timplo mga monopa yintriga na si Jesus ong nira. ");
INSERT INTO agn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nangalipay tanira ta mo-ya ig naganing tanirang oldan nira ono si Judas ta koarta. ");
INSERT INTO agn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Napaoyon tanandia, ig nagimpisa rang nagelat ta tamang timpo para maintriga na si Jesus ang anday matako. ");
INSERT INTO agn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kiminabot da tang bispiras tang Pista tang Tinapay ang Anday Pampalsa na, kaldaw ang pagpatay ta mga karniro para ong Pista tang Pagta-lib tang Anghil. ");
INSERT INTO agn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sinobol ni Jesus si Pedro may si Juan ig ganing ong nira, “Panaw amo ig magsimpan amo ta yapon ta para ong pista.” ");
INSERT INTO agn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Ong ari ami pa magsimpan tang yapon ta?” tang te-ma nira ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Siminabat si Jesus, “Paning amo ong lansangan. Don may mabagat ming tatang laling pagtakan ta tang bangang wi. Datonon mi tanandia, ig don ong balay ang teldan na, ");
INSERT INTO agn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","aningen mi tang may nandia tang balay, ‘Pagpate-ma tang Maistro mga aripa tang koartong panaponan na mandian ang pista, aroman na tang mga sinagpan na.’ ");
INSERT INTO agn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Asia itoldok na ong nindio tang tatang marogal ang koarto ong dibabaw ang may mga garamiten dang lagi don. Don amo magsimpan.” ");
INSERT INTO agn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Animan napanaw da tanira ig ang onopay inaning ni Jesus ya kay ang kinabotan nira. Ig nagsimpan tanira tang panapon nira para ong pista. ");
INSERT INTO agn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Asing kiminabot tang oras, kiminarong da si Jesus para manapon aroman na tang mga apostolis na. ");
INSERT INTO agn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ganing si Jesus ong nira, “Naboayo rang gaildaw ang maka-pen amo yen mandian ong panapon tang Pista tang Pagta-lib tang Anghil, ba-lō magpinitinsia. ");
INSERT INTO agn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Agganingo ong nindio, indio ra moman ang mamangan ta na asta indi mainabo don ong inadian tang Dios tang matod ang maliag yaning tang pistang na.” ");
INSERT INTO agn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Oman bindiotan na tang tatang kopang bino ig pagatapos ang nagpasalamat ong Dios, sindol na ong mga sinagpan na. Ganing tanandia, “Risibien mi narin, ig pagparti-partian mi. ");
INSERT INTO agn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Agganingo ong nindio, mimpisa mandian, indio ra moman ang manginem ta binong maning ta na ang pagalin ong obas, asta indi komabot tang kaldaw ang maggaem da tang Dios bilang adi.” ");
INSERT INTO agn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Oman, namisik tanandia ta tinapay ig nagpasalamat si. Pinisi-pisi na ig sindol na si ong nira ang ganing, “Na tang yen ang sinangoni ang agbobolontad para ong nindio. Boaten mi narin bilang pagdemdem ong yen.” ");
INSERT INTO agn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pagatapos nirang nanapon, maning si ka don tang bindoat na ong bino. Bindiotan na si tang kopa ig minaning, “Na tang ba-long inigoan tang Dios ang agpabakeden tang yen ang dogo, ang mailat para ong nindio. ");
INSERT INTO agn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Piro tandan mi. Ka-pen ta tarin ang pamangan tang magtraidor ong yen. ");
INSERT INTO agn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yo, ang Ana ta Taw, mapatay sigon ong plano tang Dios. Piro kailo ka tang taw ang magtraidor ong yen!” ");
INSERT INTO agn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ig namagtere-ma te-man tanira mga sinopa ong nira tang magboat ta maning ta si. ");
INSERT INTO agn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pagatapos ta si, namagdiskosionan tang mga sinagpan na mga sinopa ong nira tang kaimportantian. ");
INSERT INTO agn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ganing si Jesus ong nira, “Ang mga adi tarin ong kalibotan mareges ang manobol ong mga sinakepan nira. Ig ang mga pamaggaem, galiliag pa tanirang goyan ‘tangay tang banoa.’ ");
INSERT INTO agn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Piro indi amo magogali ta maning ta sia. Ang ga-tang ong alawig, dapat tanandia tang magpababak, ang midio ogali ta tatang karian. Ig ang pangolokolo, dapat tanandia tang magsirbi ong mga aroman na. ");
INSERT INTO agn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sinopa bato tang taw ang mas alawig tang dengeg na? Ang kakarong ong lamisan obin ang pagsirbi ong nandia? Belag bato ta asing kakarong? Piro ang yen ang ogali tarin ong nindio, ogali ta tatang torobolon. ");
INSERT INTO agn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yamo, pirmi among aromano ong tanan ang mga pagsobok ong yen, ig indio bino-wanan mi. ");
INSERT INTO agn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ig tenged sindolano tang yen ang Tatay ta podir ang maggaem, oldan amo ka yen ta podir ang maggaem. ");
INSERT INTO agn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mamangan amo ig manginem ang ka-peno ong yen ang Inadian, ig komarong amo ong mga trono para magekel ig magosgar ong tampolok may doroang tribo ang nagalin ong dogo ni Israel.” ");
INSERT INTO agn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Oman minaning si Jesus ong ni Simon, “Yawa, Simon, mamasia! Pina-dol ni Satanas ig pinagnan tanandia ang sobokan amo nandiang tanan. ");
INSERT INTO agn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Piro pinangadiong indi malipat tang pagtalig mo ong yen. Ig mga nagbalik da tang nem mo ong yen, papoirsaen mo ka tang nem tang mga logod mo.” ");
INSERT INTO agn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Siminabat si Pedro, “Magino, simpano rang mapriso ig mapatay ang aroman mo.” ");
INSERT INTO agn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ganing si Jesus, “Tandan mo na, Pedro. Ba-lo manolōk tang mano mandian ang garamal, ma-long bisisang magbo-li ang maning india gailala ong yen.” ");
INSERT INTO agn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pagatapos, sine-ma tanira ni Jesus, “Asing sinobol amo yen ang anday ekel ming binagteng, poyo-poyo ig rapak, kinorang amo ta maski onopa?” “Anda, Magino,” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ganing ka si Jesus, “Piro mandian, mga may binagteng obin poyo-poyo, e-lan mi. Ang anday ispada, dapat ipabakal na tang lambong na ig mamakal. ");
INSERT INTO agn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tenged agganingo ong nindio, kaministiran mainabo ong yen tang nasolat ong Kasolatan, ang ganing, ‘Binilang tanandia ong mga kriminal.’ Tenged gainabo ra tang tanan ang nasolat natetenged ong yen!” ");
INSERT INTO agn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Oman ganing tang mga sinagpan na, “Gino, nani ra tang doroa nga ispadan!” Ig ganing si Jesus, “Sigi! Tama ra sia!” ");
INSERT INTO agn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pagatapos ta si, nagalin si Jesus ig napaning ong Bokid tang Kaoliboan, pario tang agboaten nang pirmi. Siminabid ka tang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pagakabot don, ganing si Jesus ong nira, “Mangadi amo ang indi amo madeg ta tokso.” ");
INSERT INTO agn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Oman napaning tanandia ong tokawan don ong alawid-lawid. ");
INSERT INTO agn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Dayon ang liminod ig nagampo ong Dios ang ganing, “Tatay, mga maimo lamang, indio ra papasaren mo ong kaliwagan ang na. Piro belag tang yen ang kaliagan tang dapat ang matoman, kondi ang kaliagan mo.” ");
INSERT INTO agn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Napaita ong nandia tang tatang anghil ang nagalin ong langit, ig pinapoirsa tang nem na. ");
INSERT INTO agn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Agliwagan tanandia ta mo-ya, animan nangadi pa enged bogos ong nem na. Totorok ong tanek tang inang na, ang midio mababael ang patak ta dogo. ");
INSERT INTO agn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kimindeng tanandia pagatapos nang nangadi ig nagbalik ong mga sinagpan na. Kinabotan na tanirang gangapoyat tenged ong sobrang pagsinti nira. ");
INSERT INTO agn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ganing si Jesus, “Angay gangapoyat amo? Mambangon amo ig mangadi agod indi amo madeg ta tokso.” ");
INSERT INTO agn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Asing bibitala pa si Jesus, kiminabot da tang dorong taw. Ang panokaw-tokawan si Judas, ang tata ong tampolok may doroang apostolis na. Napalenget si Judas para itongan na si Jesus. ");
INSERT INTO agn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Piro ganing ong nandia si Jesus, “Traidorono pala nio, yo, ang Ana ta Taw, ong tatang itong?” ");
INSERT INTO agn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Asing itaen tang mga sinagpan na ang aroman na mga onopa tang mainabo, ganing tanira, “Magino, bomatok ami ra ong ispada?” ");
INSERT INTO agn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ig dayon ang laging tinagpas tang tata ong mga aroman na tang kirepen tang kalawigan ang padi, ig nalampong tang talinga nang to. ");
INSERT INTO agn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Piro ganing si Jesus, “Tama ra sia!” Tapos inapap ni Jesus tang talinga tang kirepen ig nago-ya. ");
INSERT INTO agn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Oman minitala si Jesus ong mga pangolokolo ong mga padi ig ong mga kapitan tang mga goardia tang Timplo, asta ong mga mepet tang banoa. Tenged tanirang tanan namansipaning don para depen tanandia. Ganing si Jesus ong nira, “Angay? Yo, kriminalo ang pamagekel amo ta mga ispada may pamalo? ");
INSERT INTO agn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kaldaw-kaldaw pagtoldoko ong Timplo, ig don amo ka, piro angay indiong lagi dinep mi? Piro timpo mi ra mandian, ig paggaem da tang kalainan.” ");
INSERT INTO agn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Oman dayon dang dinep nira si Jesus ig ingkelan nira ong palasio tang kalawigan ang padi tang mga Judio. Si Pedro pala dadaton ong nira, piro don lamang ong alawid-lawid, asta na-led ong kodal. ");
INSERT INTO agn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Asing napadet da tang apoy ong ka-ngan tang ge-ley ang plasa, kiminarong tang mga taw ong binit na, ig minimbeng da ka si Pedro ong nira. ");
INSERT INTO agn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Inita tanandia ta tatang torobolon ang babay don. Pinanengnengan na si Pedro ta mo-ya ig minaning ong mga taw don, “Ang taw ang na aroman ka ni Jesus!” ");
INSERT INTO agn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Piro nagbo-li si Pedro. Ganing tanandia, “Abaw, indio ngani gailala ong taw ang asing agganingen mo!” ");
INSERT INTO agn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Indi naboay, inita si ka tanandia tang tatang lali ig ganing, “Yawa tata ka ong mga aroman na!” Piro siminabat si Pedro, “Yawang tawa! Belago baya ta aroman tang taw ang asi!” ");
INSERT INTO agn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pagata-lib ta mga tang oras, rineges pa ka enged tang tatang taw, “Ang taw ang na, aroman ang enged ni Jesus! Tata kang taga Galilea!” ");
INSERT INTO agn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piro siminabat si Pedro, “Way inayo! Anday kalibotano tang onopay agbibitala mo!” Indi pa gatapos tang bibitala na, golping timinolok tang mano. ");
INSERT INTO agn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Minalied tang Gino ig pina-dekan na si Pedro, ig nademdeman da ni Pedro tang inaning tang Gino ang ganing, “Ba-lo manolōk tang mano mandian ang garamal, ma-long bisisang maning ang india gailala ong yen.” ");
INSERT INTO agn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ig nagalin si Pedro ang dorong i-yak na. ");
INSERT INTO agn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mandian, asing oras kang asi, si Jesus agginsolton ig agpatakan tang palo tang mga pamagbantay ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pinedengan nira ig ganing ong nandia, “Abir, pinton mo mga sinopay pamalo ong nio!” ");
INSERT INTO agn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ig yadi pang mga malalain ang bitala tang agganing nira ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagaramal, namagbaragat-bagat tang mga mepet tang mga Judio ig ang tanan ang mga opisialis tang banoa, aroman nira tang mga pangolokolong padi ig ang mga manigtoldok tang Katobolan. Oman pinatalonga si Jesus ong nirang tanan ig sine-ma nira ang ganing, ");
INSERT INTO agn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Magbega ra ong yamen! Yawa ra tang Cristo?” Siminabat si Jesus, “Begen amo man yen, indi amo ka magparet. ");
INSERT INTO agn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ig mga te-maen amo man yen, indi amo ka somabat. ");
INSERT INTO agn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Piro mimpisa mandian, yo, ang Ana ta Taw, komarongo ra ong to tang Makagagaem ang Dios.” ");
INSERT INTO agn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ig ganing si tanirang tanan ang nane-ma, “Maliag mong yaning, yawa tang Ana tang Dios?” Ganing si Jesus, “Yamo ra ka tang naganing ang yo ka kaman.” ");
INSERT INTO agn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Oman ganing tanira, “Onopa pay domang pamatod pang dilemen ta? Binasi ta rang nagalin ong sadiling anga na!” ");
INSERT INTO agn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Oman namansi-deng da tang tanan ang mga pangolokolong Judio ig ingkelan nira si Jesus ong talongan ni Pilato. ");
INSERT INTO agn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Don masigbegay tanira tang mga riklamo nirang kontra ong ni Jesus. Ganing tanira, “Ang taw ang na, nadep amen ang pagdolo-dolo ta bitala ong yamen ang masig ka Judio. Kokontra tanandiang magbayad ta bois ong Adi tang Roma, ig pagpailala pa ong mga taw ang tanandia ono tang Cristo, maliag yaning tatang adi.” ");
INSERT INTO agn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sine-ma ni Pilato si Jesus, “Onopa? Matod ang yawa tang adi tang mga Judio?” Siminabat si Jesus, “Yawa ra ka tang naganing.” ");
INSERT INTO agn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Oman ganing si Pilato ong mga pangolokolong padi ig ong mga taw, “Anday itaenong kakamalian tang taw ang na para sintinsian tanandia.” ");
INSERT INTO agn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Piro namagreges pa ka enged tanira ang ganing, “Ong agtotoldok na, agsolsolan na tang mga taw ong bilog ang Judea. Inimpisan na ong Galilea ig mandian tarin da.” ");
INSERT INTO agn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pagabasi ta narin ni Pilato ang nagalin ong Galilea si Jesus, sine-ma na mga taga Galilea kaman. ");
INSERT INTO agn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ig asing mata-wanan nang si Jesus gasakepan pala ni Herodes, ang pangolokolo ong Galilea, pinekel na ong taw ang asi. Tenged ong oras ang asi, nāton ang don ka si Herodes ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nalipay ang pisan si Herodes asing pagaita na ong ni Jesus. Doro rang gabalitan na natetenged ong nandia, ig naboay da tang andem nang itaen na. Dorong kaliag nang magboat si Jesus ta mga milagro agod itaen na. ");
INSERT INTO agn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Animan nane-ma tanandiang nane-ma ong ni Jesus, piro inding pisan siminabat si Jesus maski ge-ley lamang. ");
INSERT INTO agn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Don ka tang mga pangolokolo ong mga padi asta ang mga manigtoldok tang Katobolan. Sigi lamang tang pagbandan nira ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Gine-ley ge-ley pa ni Herodes si Jesus ig inintirimis, aroman na tang mga goardia na. Ong ori, pinatokan nira si Jesus ta masinlong lambong ta adi ig binalik nira ong ni Pilato. ");
INSERT INTO agn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ong kaldaw kang asi, nagimo rang magtangay da Herodes ni Pilato, ang dati pagsoayan. ");
INSERT INTO agn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pinagoy ni Pilato tang mga pangolokolo ong mga padi ig ang mga pangolokolo ong banoa, asta ang mga taw. ");
INSERT INTO agn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ganing si Pilato ong nira, “Ingkelan mi tang taw ang na ong yen ong talak nang ganing amo initeg-iteg na tang mga taw ang mamanggolo. Inimbistigaro ong talongan mi, ig initao ang anday kamatodan tang mga agbabandan mi ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Maski si Herodes, maning ka ta si. Animan pinabalik na ong yaten. Ang taw ang na, indi dapat sintinsian ta kamatayen tenged anday talak na. ");
INSERT INTO agn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Animan, palon da lamang tanandia ba-lo palpatan.” ");
INSERT INTO agn_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Maning ta si tang binitala ni Pilato, tenged kada Pista tang Pagta-lib tang Anghil, kaministiran ang magpalpat tanandia ta tatang priso para ong mga taw. ");
INSERT INTO agn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Piro delelengan ang namansiteg tang mga taw, “Patayen tang taw ang asia! Si Barabbas tang palpatan!” ");
INSERT INTO agn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Si Barabbas ang na napriso tenged aroman tanandia tang mga ribildi asing namanggolo ong Jerusalem, ig namatay pa ta taw. ");
INSERT INTO agn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mandian, minitala sing oman si Pilato ong mga taw, tenged ang kaliliagan na si Jesus tang palpatan. ");
INSERT INTO agn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Piro namansiteg si tang mga taw, “Ilansang ong kros! Ilansang ong kros!” ");
INSERT INTO agn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ya-long bisis dang minaning si Pilato ong nira, “Angay? Onopay bindoat nang malain? Anda kay initao ang talak na ang dapat tanandia patayen. Palon da lamang ba-lo palpatan.” ");
INSERT INTO agn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Piro mas sinodoan pa tang mga taw tang iteg nira, ig namagpareges tanirang dapat ilansang si Jesus ong kros. Ig ong kaboayan, napanonot da lamang si Pilato ong kaliagan tang mga taw ang pamansiteg. ");
INSERT INTO agn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Animan sinintinsian na si Jesus sigon ong kaliliagan nira. ");
INSERT INTO agn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ig sigon ong agpa-dolon nira, pinalpatan na si Barabbas, ang taw ang nanggolo ig namatay pa ta taw. Oman inintriga ong nira si Jesus para boaten tang galiliagan nira. ");
INSERT INTO agn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Asing ekel da nira si Jesus para ilansang, may nabagat nirang tatang taw ang nagalin ong bokid. Na si Simon ang taga Cirene. Inawidan nira tanandia, ig pinatakan ong nandia tang kros ang dadaton ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Agdatonon si Jesus ta dorong taw, katabid da don tang mga babay ang pamagini-yak ig pamagdayag tenged ong nandia. ");
INSERT INTO agn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Binalied tanira ni Jesus, ig minaning ong nira, “Yamong mga babay ang taga Jerusalem! Indio ra i-yakan mi. Ang mga sadili mi ra lamang tang i-yakan mi asta ang mga ana mi. ");
INSERT INTO agn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tandan mi. Komabot tang kaldaw ig maganing tang mga taw, ‘Masoirti tang mga bog ig ang mga indi pamagabdet, asta ang mga indi pamagpatiti.’ ");
INSERT INTO agn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ong mga kaldaw ang asi, aningen tang mga taw, ‘Balampa mapegnak tang mga bokid ong yamen, ig tampekan ami tang mga bolod!’ ");
INSERT INTO agn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tenged mga maning ta na tang bindoat nira ong yen, ang anday talako, onopa enged tang mainabo ong mga taw ang may mga talak nira?” ");
INSERT INTO agn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","May ingkelan pa nirang doroang kriminal para patayen ang ipadengan ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Asing kiminabot tanira don ong logar ang aggoyan ta Doli ta Kolo, dayon dang linansang nira si Jesus ong kros. Linansang ka nira tang doroang kriminal, ang kros tang tambilog gampir ong to ni Jesus ig ang tata gampir ong wala. ");
INSERT INTO agn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ganing si Jesus, “Tatay, patawaden mo tanira tenged indi gata-wanan nira tang agboaten nira.” Namagparabonlokan tang mga goardia para parti-partien nira tang mga lambong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pamansi-deng don ig pamansitelek tang mga taw mintras aglibaken pa si Jesus tang mga pangolokolong Judio. Ganing tanira, “Linibri na tang doma, mandian, telekan ta mga malibri na tang sadili na. Tanandia ono tang Cristo, ang ading pinilik tang Dios!” ");
INSERT INTO agn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Agginsolton ka tanandia tang mga goardia. Pinalengetan nira tanandia ig agdoydoyan nira ta binong maka-lem. ");
INSERT INTO agn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ganing tanira, “Mga yawa tang adi tang mga Judio, abir, ilibri mo tang sadili mo!” ");
INSERT INTO agn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ig don ong may kokoloan na may karatolang sinolatan ong bitalang Grigo, Latin may Hebreo, “Na tang Adi tang mga Judio.” ");
INSERT INTO agn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Asta ang tata ong mga kriminal ang linansang don ang aroman ni Jesus, nanginsolto ka ong nandia ig ganing tanandia, “Ganinga, yawa tang Cristo! Abir, ilibri mo tang sadili mo asta yami!” ");
INSERT INTO agn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Piro sinambleng tanandia tang aroman nang kriminal ang ganing, “India geldan ong Dios? Sinintinsian ita kang pario tang taw ang na! ");
INSERT INTO agn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tama lamang ang sintinsian itang doroa ta maning ta na, tenged ong bindoat ta. Piro tanandia, anday talak na.” ");
INSERT INTO agn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ig ganing pa tang kriminal, “Jesus, demdemeno nio mga paggaema ra bilang adi.” ");
INSERT INTO agn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Siminabat si Jesus, “Agganingo ong nio, mandian ang lagi e-lana yen ong Paraiso.” ");
INSERT INTO agn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Asing ko-to ra ang magalas dosi ra, nalipat tang kaldaw ig nangi-lep tang kalibotan tegka alas tris tang apon. ");
INSERT INTO agn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ig ya kay ang golping pagaba-bak tang ka-ngan tang kortinang dorog kabael ang don ong Timplo. ");
INSERT INTO agn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Miniteg si Jesus ta mapoirsa ang ganing, “Tatay, gintrigao ra ong nio tang yen ang ispirito.” Ig pagabitala na ta si, nabontok da tang linawa na. ");
INSERT INTO agn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Asing itaen tang kapitan tang mga goardia tang nainabo, nagdayaw tanandia ong Dios ang ganing, “Matod ka kaman ang anday talak na tang taw ang na!” ");
INSERT INTO agn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ig ang nainabong narin, inita ka tang tanan ang taw ang pamagtompok ig pamansitelek don. Namansiolik tanirang tanan ang agdēnan nira tang mga debdeb nira, ong sobrang sinti nira. ");
INSERT INTO agn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pamansi-deng ka don ong alawid-lawid tang tanan ang mga tangay ni Jesus, asta ang mga babay ang namansitabid ong nandia nagalin ong Galilea. Ig inita ka nira tang nainabo. ");
INSERT INTO agn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mandian, may tatang taw don ang aran na si Jose, ang taga Arimatea, tatang logar tang mga Judio. Mo-ya ig mato-lid tang taw ang na, ig kabilang ong mga pamagelat tang kaldaw ang maggaem tang Dios bilang adi. Tata ka tanandia ong mga opisialis tang mga Judio, piro indi napaoyon ong disision nira ang ipapatay si Jesus. ");
INSERT INTO agn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mandian, napaning si Jose ong ni Pilato ig linisinsia na mga poiding komiten na tang sinangoni ni Jesus ong kros. ");
INSERT INTO agn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pagakomit na, binongot na ta abel ang kolit. Oman bintang na ong lebengan ang midio koiba ang bindoat ong pagsinsil ta bato, ig indi pa galbengan ta patay. ");
INSERT INTO agn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ang kaldaw ang asi, Kaldaw ang Palagsimpan ig magimpisa ra tang Kaldaw ang Igperenay. ");
INSERT INTO agn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Diminaton ong ni Jose tang mga babay ang namansitabid ong ni Jesus nagalin ong Galilea, animan inita nira tang limbengan ong nandia asta ang pagkabetang don tang sinangoni na. ");
INSERT INTO agn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pagatapos, namansiolik tanira ong balay ang agdayonan nira don ong Jerusalem ig nagsimpan ta mga pabanglo ig bolong ang para ong patay agod ipid ong sinangoni na. Piro namansipenay kang lagi tanira, sigon ong Katobolan, tenged Kaldaw dang Igperenay. ");
INSERT INTO agn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Garamal pa lamang kaldaw ang Dominggo, namansipaning da tang mga babay don ong lebengan, ekel nira tang mga pabanglong sinimpan nira. ");
INSERT INTO agn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pagakabot nira don, kinabotan nirang naigod da tang batong agdadapa ong anga tang koiba. ");
INSERT INTO agn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Piro asing siminled tanira, inita nirang anda ra don tang sinangoni tang Ginong Jesus. ");
INSERT INTO agn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Asing galibeg pa tang pagirisipen nira tenged tarin, golping napaita ong binit nira tang doroang lali ig pisan ang sisinggat tang mga lambong nira. ");
INSERT INTO agn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ong sobrang karaelden tang mga babay, liminod tanira ig siminokok sa-sad ong tanek. Ganing ong nira tang doroang lali, “Angay agdilemen mi tang boi tani ong logar tang mga patay? ");
INSERT INTO agn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Anda ra tarin. Naboi rang moman. Demdemen mi tang inaning na ong nindio asing don pa tanandia ong Galilea. ");
INSERT INTO agn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ganing tanandia, kaministiran ang yintriga tang Ana ta Taw ong mga mapinagtalaken ig ilansang ong kros. Piro ong ya-long kaldaw maboing moman.” ");
INSERT INTO agn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ig nademdeman da tang mga babay tang inaning ni Jesus. ");
INSERT INTO agn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Oman minolik da tanira ig sinayod nira tang tanan ang na ong tampolok may tatang apostolis asta ong doma pang mga aroman nira. ");
INSERT INTO agn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ang mga babay ang na, da Maria Magdalena, Juana, ig si Mariang nanay ni Santiago. Tanira ig ang doma pang mga babay ang aroman nira tang namagsayod ong mga apostolis tang nainabo don ong lebengan. ");
INSERT INTO agn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Piro kalaom tang mga apostolis, kalokoan lamang tang inaning tang mga babay. Animan indi tanira namagparet. ");
INSERT INTO agn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piro kimindeng si Pedro ig nagsinikad ang napaning ong lebengan. Simininek tanandia ig linipara na ong teled, piro anday inita na poira lamang ong mga abel ang binongot ong sinangoni ni Jesus. Animan minolik tanandiang gabereng ong nainabo. ");
INSERT INTO agn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Asing kaldaw kang asi, may doroa ong mga sinagpan ni Jesus ang totongol ong tatang bario ang aggoyan ta Emaus. Ang bariong na, mga tampolok may tatang kilomitro tang kalawid na ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Agpagampangan nira tang tanan ang nainabo. ");
INSERT INTO agn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ig mintras pagampang tanira ig pagte-man, liminenget si Jesus ig siminabid da ong nira. ");
INSERT INTO agn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Inita nira tanandia piro indi nailala nira tenged midio agdapan tang pama-dek nira. ");
INSERT INTO agn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sine-ma tanira ni Jesus, “Onopa tang agpagampangan mi?” Siminareng tanirang doroa, ang itsora nira pagpaitang gangapongaw. ");
INSERT INTO agn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ang tata ong nira, ang aran na si Cleopas, siminabat ang ganing, “Onora enged ang india gatako? Sigoro yawa lamang tang pagtinir ong Jerusalem ang indi gatako tang nainabo ong mga kaldaw ang narin!” ");
INSERT INTO agn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ganing si Jesus, “Angay? Onopa si?” Siminabat tanira, “Ang nainabo ong ni Jesus ang taga Nazaret, tatang propita. Makagagaem tanandia ong mga bindoat na ig ong mga binitala na, maging ong pama-dek tang Dios asta ong pama-dek tang mga taw. ");
INSERT INTO agn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Piro ang yamen ang mga pangolokolong padi asta ang mga pangolokolo ong banoa, dinimanda nira tanandia para sintinsian ta kamatayen ig ilansang ong kros. ");
INSERT INTO agn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tanandia paman tang aglaoman amen din ang maglibri tang banoa amen ang Israel. Piro ya-long kaldaw da mandian tanandiang napatay. ");
INSERT INTO agn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ig mandian nagolpian ami ong binalita ong yamen tang domang mga babay ang aroman amen. Garamal pa ono napaning tanira ong lebengan, ");
INSERT INTO agn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ig indi ono inita nira tang sinangoni ni Jesus. Nagbalik tanirang ganing may napaita ono ong nira ang doroang anghil ig nagpatako ang naboi si Jesus. ");
INSERT INTO agn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Napaning ka ong lebengan tang doma pang mga aroman amen ig maning ka ta si tang kinabotan nira. Indi inita nira si Jesus.” ");
INSERT INTO agn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Oman ganing ong nira si Jesus, “Ay yamong mga taw! Kalobay tang pagirisipen mi! Angay maliwag ong nindio ang magparet tang tanan ang inaning tang mga propita? ");
INSERT INTO agn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Belag bato tang inaning nirang kaministiran ang magpinitinsia kang lagi tang Cristo ba-lo tanandia mabalik ong paladengegan ang katengdanan na don ong langit?” ");
INSERT INTO agn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Oman pinaintindi ni Jesus ong nira tang tanan ang na-tang ong Sagradong Kasolatan natetenged ong sadili na, impisa ong mga libro ni Moises sa-sad ong mga sinolat tang mga propita. ");
INSERT INTO agn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mandian, alenget da tanira ong bariong paningan nira, ig midio magpadayon pa si Jesus ong pagparanawen na. ");
INSERT INTO agn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Piro inawidan nira tanandia. Ganing tanira, “Tania ra lamang domayon ong yamen. Gakorop da tang kaldaw.” Animan napawid si Jesus ong nira. ");
INSERT INTO agn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Asing ka-pen da nira si Jesus ong lamisan ang panapon, namisik tanandia ta tinapay ig binindisionan na. Oman pinisi-pisi na ig sindol ong nira. ");
INSERT INTO agn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ya ray ang pagabri tang pama-dek nira ig don nailala ra nira si Jesus. Piro golpi rang nalipat si Jesus ong pama-dek nira. ");
INSERT INTO agn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ganing tang doroa, “Animan pala midio lompok tang popotokon ta ong sobrang kalipay asing pagigampang tanandia ong yaten ong dalan, ig pagpaintindi ong yaten tang Sagradong Kasolatan!” ");
INSERT INTO agn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dayon da tanirang kimindeng ig nagbalik ong Jerusalem. Kinabotan nirang pamagsirimet-simet tang tampolok may tatang apostolis ig ang domang mga karomanan nira. ");
INSERT INTO agn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Pamagampang tanira ang ganing, “Matod ka kaman ang naboing oman tang Gino! Napaita tanandia ong ni Simon!” ");
INSERT INTO agn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ig sinayod ka tang doroa tang nainabo ong nira don ong dalan, ig monopa nailala nira si Jesus asing pagpisi-pisi na tang tinapay. ");
INSERT INTO agn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Asing pamagampang pa tanira tang mga bagay ang na, inita nirang ke-deng da si Jesus ong ka-ngan nira. Ganing tanandia, “Asia ong nindio tang kao-yan tang Dios!” ");
INSERT INTO agn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Piro nangakibot tanira ig pinangeldan tenged ang kalaom nira, peled tang napaitang asia ong nira. ");
INSERT INTO agn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Animan ganing ong nira si Jesus, “Angay gaborido amo? Angay pagdoadoa amo? ");
INSERT INTO agn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Telekan mi tang mga kalimao ig kakayo. Yo na! Apapeno nindio ig telekan. Ang peled, anday isi na ig anday doli na. Piro yo, may atan! Pario tang gitaen mi.” ");
INSERT INTO agn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Oman, pinaita na ong nira tang mga kalima na ig mga kakay na. ");
INSERT INTO agn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Asing midio indi pareten nira ong sobrang kalipay nira ig kabereng, nane-ma si Jesus ong nira, “Anday mapangan mi atan?” ");
INSERT INTO agn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ig sindolan nira ta tang potol ang yan ang kindiaw. ");
INSERT INTO agn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kinomit na ig pinangan na ong talongan nira. ");
INSERT INTO agn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Oman minitala si Jesus ong mga sinagpan na ang ganing, “Narin tang inaningo rang lagi ong nindio tanopa asia asing aromano pa nindio: Kaministiran ang mainabo tang tanan ang sinolat natetenged ong yen ong Katobolan ni Moises, ong mga libro tang mga propita, ig ong libro tang mga Salmo.” ");
INSERT INTO agn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ig inabrian na tang pagirisipen nira agod maintindian nira tang mga Sagradong Kasolatan. ");
INSERT INTO agn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ganing pa tanandia, “Maning ta na tang nasolat don: Ang Cristo kaministiran magpinitinsia ig mapatay, ig moman ang maboi ong ya-long kaldaw. ");
INSERT INTO agn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ig kaministiran ang itoldok da ong tanan ang mga logar, mimpisa ong Jerusalem: Mga ang mga taw mamagtogat ong mga talak nira, patawaden tanira tang Dios tenged ong yen. ");
INSERT INTO agn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yamo mismo tang nangaita ig mapagpamatod tang mga bagay ang na. ");
INSERT INTO agn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tandan mi. Ipekelo ong nindio tang Ispirito Santong pinangako tang yen ang Tatay. Animan, indi amo magalin ong siodad mintras indi pa garisibi mi tang gaem ang magalin ong langit.” ");
INSERT INTO agn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pagatapos, ingkelan tanira ni Jesus ong loa tang siodad tang Jerusalem. Pagakabot nira ong Betania, linawig na tang mga kalima na ig binindisionan na tanira. ");
INSERT INTO agn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mintras agbindisionan na tanira, napabelag da tanandia ong nira ig amat-amat dang ingkelan ong dibabaw, don ong langit. ");
INSERT INTO agn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Don ang lagi tinowan ig dinayaw nira tanandia. Pagatapos, namagbalik tanira ong Jerusalem ang dorong kalipay nira. ");
INSERT INTO agn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ig pirmi ra tanira ong Timplo ang pamagdayaw ong Dios.");
INSERT INTO agn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Asing primiro pa lamang, ba-lo bindoat tang kalibotan, atan dang lagi tang Bitala. Ang Bitalang na aroman tang Dios ig ang Bitalang na yay ang Dios. ");
INSERT INTO agn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tanandia aroman dang lagi tang Dios impisa pa asing primiro. ");
INSERT INTO agn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tenged ong nandia, naboat tang tanan ang bagay, ig anda enged ay naboat mga belag ta tanandia. ");
INSERT INTO agn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ang Bitalang na yay ang pinagalinan tang kaboi, ig ang kaboing na pario ta tatang tolok ang pagtorol ta kayagan ong mga taw. ");
INSERT INTO agn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ang tolok ang na pisan ang sisinag ong maki-lep, ig ang kayag na maski tanopa indi enged agdegen tang kaki-lepan. ");
INSERT INTO agn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mandian, may tatang taw ang sinobol tang Dios, ang aran na si Juan. ");
INSERT INTO agn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Sinobol si Juan para magpatako ong mga taw natetenged ong tolok agod ang tanan mamagto ong tolok tenged ong pagpamatod na. ");
INSERT INTO agn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Belag ta si Juan tang tolok, kondi napaning tanandia para lamang magpamatod natetenged ong tolok. ");
INSERT INTO agn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Si Jesus tang matod ang tolok ang kiminabot tarin ong kalibotan para magtorol ta kayagan ong kinaisipan tang mga taw. ");
INSERT INTO agn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Piro asing tarin da tanandia ong kalibotan, ig maski ang tanan ang bagay naboat tenged ong nandia, ang mga taw indi ka enged nangailala ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Napaning mismo tanandia ong sadiling banoa na, piro indi tanandia rinisibi tang mga kasimanoa na. ");
INSERT INTO agn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Piro ang tanan ang namagrisibi ig namagto ong nandia, tanira tang sindolan na ta podir ang magimong mga ana tang Dios. ");
INSERT INTO agn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nagimo tanirang mga ana tang Dios belag ta maning ong ogaling pagpangana sigon ong kaliliagan tang magkatawa ang magkatinir ta ana nira, obin ong kaliagan ta tatang lali. Ang pagimong ana nira tenged lamang ong gaem ig ong kaliagan tang Dios. ");
INSERT INTO agn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ang Bitala nagimong taw ig minimbeng ong yaten tarin ong kalibotan. Ponok tanandia ta kaloy ig kamatodan. Inita amen tang makabebereng ang gaem ig dengeg na bilang bogtong ang Ana ang nagalin ong Dios ang Tatay. ");
INSERT INTO agn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Si Juan nagpamatod natetenged ong nandia ig naginiteg ang ganing, “Tanandia tang agganingeno rang lagi ong nindio, ang komabot ang domaton ong yen piro mas alawig tang dengeg na ong yen. Tenged indio pa gataw, atan dang lagi tanandia.” ");
INSERT INTO agn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tenged bogos tang kaloy na, animan indi malobot-lobot tang mga grasiang agto-dol na ong yaten. ");
INSERT INTO agn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tenged ang Katobolan, sindol ong yaten ong tabang ni Moises asing tokaw. Piro ang kaloy tang Dios ig ang kamatodan natetenged ong nandia, yay ang pinakabot ong yaten ni Jesu-Cristo. ");
INSERT INTO agn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Maski tanopa, anda enged ay taw ang naita ong Dios. Piro pinailala tanandia tang bogtong ang Ana na ang yay ang Dios mismo ig aroman ang pirmi tang Tatay na. ");
INSERT INTO agn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","May tatang kaldaw, ang mga pangolokolong Judio ong Jerusalem nanobol ta mga padi ig mga manigtabang ong Timplo ang paning ong ni Juan para te-maen nira mga sinopa enged tanandia. ");
INSERT INTO agn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Piro indi nagbo-li si Juan kondi minaning, “Belag ta yo tang Cristo ang aggelaten mi.” ");
INSERT INTO agn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ganing tang mga sinobol ang nane-ma, “Mga belaga tang Cristo, sinoapa? Yawa si Elias ang propita?” Siminabat si Juan, “Belag!” Animan minaning si tanira, “Sigoro yawa tang propitang aggelaten amen!” Piro siminabat si si Juan, “Belag ka!” ");
INSERT INTO agn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Minaning sing oman tanira, “Mga maning don, sinoapa enged? Yaning mo ngani ong yamen agod may mabalita amen ong mga namagtobol ong yamen. Onopa tang maning mo natetenged ong sadili mo?” ");
INSERT INTO agn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ig dayon ang minaning si Juan, “Yo ya ray ang agganingen tang propitang si Isaias asing tokaw ang ganing, ‘May paginiteg don ong logar ang anday gistar ang taw ang ganing, To-liden mi tang mga dalan ang panawan tang Gino.’ ” ");
INSERT INTO agn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mandian, tenged ang mga pamane-mang narin agtobolon tang mga Pariseo, ");
INSERT INTO agn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","animan sine-ma si nirang oman si Juan. Ganing tanira, “Mga yawa belaga tang Cristo, obin si Elias, obin ang propitang aggelaten, angay pagboniaga ong mga taw?” ");
INSERT INTO agn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Siminabat si Juan, “Yo pagboniago ong wi lamang, piro may atan ong nindio ang indi gailala mi. ");
INSERT INTO agn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tanandia tang komabot ang domaton ong yen. Piro maski ngani tomokok ig magobad tang kordon tang rapak na, belago ta bagay.” ");
INSERT INTO agn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nainabo narin ong Betania, ong dobali tang soba tang Jordan, don ong logar ang pinagboniagan ni Juan. ");
INSERT INTO agn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pagaramal, inita ni Juan si Jesus ang agpalenget ong nandia. Ganing si Juan ong mga taw, “Asia ra tang Karniro tang Dios! Tanandia isagda para makomit tang mga kasalanan tang mga taw ong kalibotan. ");
INSERT INTO agn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tanandia tang inaningo rang lagi ong nindio, ang komabot ang domaton ong yen piro mas alawig tang dengeg na ong yen. Tenged indio pa gataw, atan dang lagi tanandia. ");
INSERT INTO agn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Asing primiro maski yo, indio ngani gatako mga sinopa sing komabot. Piro napaningo tarin ang magboniag ong mga taw agod ipailala tanandia ong yaten ang mga Israelita. ");
INSERT INTO agn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","“Tenged asing pagboniago, maning ta na tang nainabo: Initao tang Ispirito Santo ang agpababak ang nagalin ong langit, ang magang lare, ig siminareng ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Asing primiro pa, indio pa gatako mga sinopa enged tanandia. Piro ang Dios ang nanobol ong yen ang magboniag ong nindio ong wi, yay ang minaning ong yen ang ganing, ‘Mga itaen mo tang Ispirito Santo ang agpababak ig magtinir ong tatang taw, ang taw ang asia yay ang magboniag ong mga taw ong Ispirito Santo.’ ");
INSERT INTO agn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ig sia initao ang enged. Animan pagpamatodo ong nindio ang si Jesus yay ang Ana tang Dios.” ");
INSERT INTO agn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pagaramal, don si oman si Juan, aroman na tang doroa ong mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Asing itaen ni Juan si Jesus ang tata-lib, ganing tanandia, “Asia ra tang Karniro tang Dios!” ");
INSERT INTO agn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pagabasi tang doroa, dayon ang laging namansidaton ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pagabalied ni Jesus, inita nang dadaton da tanira ong nandia, animan sine-ma na tanira, “Sinopay agdilemen mi?” Siminabat tanira, “Rabi, ong ariapa pagdayon?” (Ang maliag yaning tang Rabi ay Maistro.) ");
INSERT INTO agn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ganing si Jesus, “Tomabid amo agod itaen mi.” Siminabid tanira ig inita nira tang aggistaran na. Ang oras ang asi mga alas koatro ra tang apon. Ig don tanira nagtinir ong nandia asta nalabi. ");
INSERT INTO agn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ang tata ong doroang asing nabasi ong inaning ni Juan oman diminaton ong ni Jesus ay si Andres, ang logod ni Simon Pedro. ");
INSERT INTO agn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Animan dinilem ang lagi ni Andres tang logod nang si Simon ig binalitan na ang ganing, “Inita amen tang Mesiyas!” (Ang maliag yaning tang Mesiyas ay Cristo.) ");
INSERT INTO agn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ig dayon ang ingkelan na si Simon ong ni Jesus. Pagakabot nira ong ni Jesus, pina-dekan ni Jesus si Simon ig minaning, “Yawa si Simon ang ana ni Juan. Piro mandian Cefas da tang igoyo ong nio.” (Ang Cefas pario ka tang aran ang Pedro, ang maliag yaning “tatang bato.”) ");
INSERT INTO agn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pagaramal, naisipan ni Jesus ang paning ong probinsia tang Galilea. Inita na si Felipe ig minaning ong nandia, “Impisa mandian tomabida ra ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Felipeng narin kasimanoa da Andres ni Pedro ang mga taga Betsaida. ");
INSERT INTO agn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Dinilem ni Felipe si Natanael, ig pagaita na ganing, “Inita amen da tang taw ang inaning ni Moises ong Katobolan ig nasambit ka tang mga propita ong mga sinolat nira. Tanandia pala si Jesus ang taga Nazaret, ang ana ni Jose!” ");
INSERT INTO agn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ganing si Natanael, “Onora? May magalin batong mo-ya ong Nazaret?” Ganing si Felipe ong nandia, “Ta ra, tomabida agod itaen mo.” ");
INSERT INTO agn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Asing itaen ni Jesus si Natanael ang agpalenget ong nandia, ganing si Jesus, “Na tatang matod ang Israelita ig indi panloko.” ");
INSERT INTO agn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Piro ganing si Natanael, “Angay gailalao nio?” Siminabat si Jesus, “Ong matod, india pa gagoyan ni Felipe, initā rang lagi yen asing dona ong sirong tang ayong igos.” ");
INSERT INTO agn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Pagabasi ni Natanael ta na, dayon ang minaning, “Rabi, yawa kaman tang Ana tang Dios! Yawa tang aggelaten ang Adi tang Israel!” ");
INSERT INTO agn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ganing si Jesus, “Natanael, yawa nagtoa ra ong yen tenged lamang minaningo ong nio ang initā yen ong sirong tang igos. Piro mas sobra pa atan tang mga makabebereng ang mga bagay tang itaen mo.” ");
INSERT INTO agn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ig ganing pa si Jesus ong nirang tanan, “Tandan mi: Komabot tang kaldaw ang itaen ming abri tang langit, ig itaen mi tang mga anghil tang Dios ang pamampadibabaw ig pamampababak ong yen, ang Ana ta Taw.” ");
INSERT INTO agn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pagata-lib tang doroang kaldaw, may kasal don ong Cana, ong probinsia tang Galilea. Don tang nanay ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Si Jesus may ang mga sinagpan na don ka. ");
INSERT INTO agn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mandian, naton ang kinorang tang irinemen ang bino don ong kombida. Animan ganing ong ni Jesus tang nanay na, “Nalo-tan da tanira ta irinemen.” ");
INSERT INTO agn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Piro siminabat si Jesus, “Sigoro maski indio ra aningen mo tang onopay boateno. Tenged indi pa kakabot tang yen ang oras.” ");
INSERT INTO agn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Oman minaning tang nanay ni Jesus ong mga torobolon don, “Tomanen mi lamang tang maski onopay itobol na ong nindio.” ");
INSERT INTO agn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mandian, don ong kasalan may enem ang mababael ang tapayan. Narin tereldan ta wing aggamiten tang mga Judio ong pagpamanaw tang mga kalima ig ong pagpangogat tang mga garamiten ba-lo tanira mamangan, sigon ong kaogalian nira. Ang kada tapayan poiding mateldan ta mga doroang polok asta tolong polok ang galon ang wi. ");
INSERT INTO agn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Mandian, ganing si Jesus ong mga torobolon, “Ponokon mi ta wi tang mga tapayan.” Ig pinonok ka kaman nira. ");
INSERT INTO agn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pagatapos ganing si Jesus ong nira, “Mana-lot amo ra ig ekelan mi ong agtaligan tang kombida.” Ig bindoat kaman nira. ");
INSERT INTO agn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Sinamitan tang agtaligan tang wing asi ang nagimo rang bino. Indi gata-wanan na mga ong aypa nagalin tang binong asi, piro ang mga torobolon ang namana-lot ong tapayan gangatako. Animan pagasamit tang agtaligan, ginoyan na tang laling kinasal ");
INSERT INTO agn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ig ganing ong nandia, “Ang gata-wanano, ang masabor ang klasi ta bino tang agto-kaw ang agsisirbi, agod mga yadi rang mainem tang mga bisita, ba-lo pa ipaloa tang malasay ang klasi. Piro yawa, pinaori mo pala ang pinaloa tang masabor ang bino!” ");
INSERT INTO agn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nainabo narin don ong Cana ang sakep tang Galilea, ig yay ang primirong milagrong bindoat ni Jesus. Ig ong bindoat nang asi pinaita na tang makabebereng ang gaem na ang pagalin ong Dios, ig ang mga sinagpan na namagto ra ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagatapos tang kasal, napaning si Jesus ong Capernaum, aroman tang nanay na, ang mga logod na, asta ang mga sinagpan na. Ig don tanira namagtinir ta pirapang kaldaw. ");
INSERT INTO agn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pira ra lamang kaldaw, pista ra tang mga Judio ang aggoyan ta Pista tang Pagta-lib tang Anghil. Animan napaning si Jesus ong Jerusalem para mamista. ");
INSERT INTO agn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Don ong Timplo inita na tang mga pamagpabakal ta mga ayep ang igsaragda, pario tang mga baka, karniro, ig mga marapati. May don kang mga pamamailo ta koarta ong mga poisto nira. ");
INSERT INTO agn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pagaita ni Jesus ong mga agboaten nira, nangomit tanandia ta tali ig bindoat nang latigo. Oman dayon ang pinampalayas na tang mga pamagpabakal. Asta ang mga baka ig mga karniro, pinanaboy na ang pinampaloa ong Timplo. Pinangwasag na tang mga koarta tang mga pamamailo ta koarta ig pinampakalintoad na tang mga lamisan nira. ");
INSERT INTO agn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Oman inordinan na tang mga pamagpabakal ta marapati ang ganing, “Komiten mi ra sia tarin! Indi boaten ming palingki tang balay tang Tatayo!” ");
INSERT INTO agn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pagaita tang mga sinagpan na, nademdeman nira tang na-tang ong Kasolatan ang ganing, “Dorog kabael tang pagmalo ong balay tang Tatayo, ig ang te-kan na ay ang kamatayeno.” ");
INSERT INTO agn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Oman, tenged ong bindoat ni Jesus ong Timplo, sine-ma tanandia tang mga pangolokolong Judio. Ganing tanira, “Sinoapa ang magboat ta maning ta na? Abir, magpaitā ong yamen ta milagro bilang pamatod ang yawa may aotoridad mo!” ");
INSERT INTO agn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Siminabat si Jesus, “Gebaen mi tang timplong na ig ong teled ta tolong kaldaw, ipa-dengo sing oman.” ");
INSERT INTO agn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ganing tang mga pangolokolo, “Abaw! Inayo lamang! Epat ang polok may enem ang takon tang boat tang Timplong na! Oman ganinga ipa-deng mo si ong teled ta tolong kaldaw lamang?” ");
INSERT INTO agn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Piro ang timplong nang agganingen ni Jesus anday doma kondi ang sinangoni na. ");
INSERT INTO agn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Animan asing pagaboi nang oman, don nademdeman tang mga sinagpan na tang inaning nang asi. Ig namagparet tanira ang matod kaman tang na-tang ong Kasolatan ig ang inaning na mismo tenged ong sadili na. ");
INSERT INTO agn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mintras don pa si Jesus ong Jerusalem asing Pista tang Pagta-lib tang Anghil, yading mga taw ang namagto ra ong nandia asing pagaita nira tang mga milagrong agboaten na. ");
INSERT INTO agn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Piro si Jesus indi nagtalig ong nira, tenged gata-wanan na ta mo-ya tang ogali tang tanan ang mga taw. ");
INSERT INTO agn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Belag ta kaministiran ang begen pa tanandia natetenged ong maski sinopa, tenged gata-wanan na tang onopay ga-tang ong mga popotokon nira. ");
INSERT INTO agn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","May tatang pangolokolo ong mga Judio ang aran na si Nicodemo. Mimbro tanandia tang gropong aggoyan ta Pariseo. ");
INSERT INTO agn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tatang labi, napaning tanandia ong ni Jesus ig minaning, “Rabi, gata-wanan amen ang yawa tatang maistro ang nagalin ong Dios, tenged anday taw ang mapagboat tang mga milagrong agboaten mo mga ang Dios anda ong nandia.” ");
INSERT INTO agn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Siminabat si Jesus, “Ong kamatodan, anday taw ang poiding ma-pen ong inadian tang Dios mga indi tanandia ipanganang moman.” ");
INSERT INTO agn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Piro ganing si Nicodemo, “Monopa ipanganang moman tang tatang taw mga mabael da? Mabalik bato ong sian tang nanay na para ipangana sing moman?” ");
INSERT INTO agn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ganing si si Jesus, “Agganingo ong nio tang kamatodan: Mga ang tatang taw indi ipangana ong wi ig ong Ispirito Santo, indi tanandia ma-pen ong inadian tang Dios. ");
INSERT INTO agn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ang kaboi ta pagalin ong mga ginikanan ta, piro ang kaboing ispiritoal pagalin ong Ispirito tang Dios. ");
INSERT INTO agn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Animan dapat india mabereng ong inaningo ong nio ang yamo kaministiran ang ipanganang moman. ");
INSERT INTO agn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ang Ispirito tang Dios pario tang mageyep. Tenged ang mageyep geyep maski ong aypa galiag ang meyep. Gaba-yan ta ang geyep, piro indi ita gatako mga ong aripa pagalin obin ong aripa paning. Maning ka atan tang tanan ang agtoldan tang kaboing pagalin ong Ispirito. Matod ang gainabo, maski indi gaintindian ta.” ");
INSERT INTO agn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ganing si Nicodemo, “Monopa si?” ");
INSERT INTO agn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ganing ka si Jesus, “Angay? Yawa, ilaladoang manigtoldok ong mga Israelita, oman indi gaintindian mo tang mga bagay ang na? ");
INSERT INTO agn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Agganingo ong nio, ang mga bagay ang agpatako amen ong nindio yay ang mga bagay ang gata-wanan amen ig inita amen mismo. Piro yamo, indi amo pamagparet ong mga agbabalita amen. ");
INSERT INTO agn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mandian, mga indi pareten mi tang mga inaningo ong nindio natetenged ong gainabo tarin ong kalibotan, mono amo pa bato magparet mga begen amo yen tang natetenged tang don ong langit? ");
INSERT INTO agn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Anda enged ay naka-yat ong langit poira lamang ong napababak ang nagalin ong langit, ang yay yo, ang Ana ta Taw.” ");
INSERT INTO agn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ig mga monopa pinalawig ni Moises ong posti tang magang ma-kal ang bindoat na ong saway, asing don tanira ong logar ang anday gistar ang taw, maning ka ta si kaministiran ang ipalawig tang Ana ta Taw ong kros, ");
INSERT INTO agn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","agod ang maski sinopay magto ig magtalig ong nandia, magkatinir ta kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Animan, tenged lamang ong mabael ang paggegma tang Dios ong mga taw ong kalibotan, sindol na tang bogtong ang Ana na, agod ang maski sinopay magto ig magtalig ong nandia indi malbag ong Dios para silotan asta ong tanopa, kondi magkatinir ta kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tenged indi pinapaning tang Dios tang Ana na tarin ong kalibotan para sintinsian na tang mga taw, kondi sinobol tanandia agod tenged ong kamatayen na, malibri tang mga taw ong silot ang para ong mga kasalanan nira. ");
INSERT INTO agn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Animan ang taw ang pagto ong Ana tang Dios, indi ra sintinsian ang silotan ang anday kataposan. Piro ang indi magto ong nandia, nasintinsian dang lagi ang silotan ta maning ta si tenged indi tanandia nagto ong bogtong ang Ana tang Dios. ");
INSERT INTO agn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Silotan tanira tenged napaning tarin ong kalibotan tang tolok, piro pinalabi nira tang kaboi ong maki-lep mas pa ong mayag, tenged anday sasayod tang mga boat nira. ");
INSERT INTO agn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ang taw ang pagboat ta malain indi galiag ong mayag. Agpalawid tanandia ong tolok agod indi mabisto tang mga boat nang malain. ");
INSERT INTO agn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Piro ang taw ang pangaboi ang pagosoy ong kamatodan, agpalenget ong tolok agod itaen ong mga agboaten na ang tanandia pagtoman ong Dios. ");
INSERT INTO agn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagatapos ta si, namansipaning da Jesus may ang mga sinagpan na ong probinsia tang Judea. Don tanira nagtinir ta pirapang kaldaw ang pamagboniag ong mga taw. ");
INSERT INTO agn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Si Juan, pagboniag ka ong Enon, tatang logar ang alenget ong Salim, tenged yading wi don. Sigi lamang tang paning tang mga taw ong ni Juan para magpaboniag ");
INSERT INTO agn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Na asing si Juan indi pa gapriso. ");
INSERT INTO agn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mandian, ang mga sinagpan ni Juan pagigdiskosion da ong tatang masig ka Judio nira don natetenged mga monopa tang tamang pagrilimpion agod magimong limpio tang tatang taw ong pama-dek tang Dios. ");
INSERT INTO agn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Animan namansipaning tanira ong ni Juan ig minaning ong nandia, “Rabi, gademdeman mo tang taw ang aroman mo asing dona ong dobali tang soba tang Jordan? Ang taw ang pinatako mo ong mga taw? Pagboniag ka tanandia ig ang tanan ang mga taw don da ong nandia pamansipaning!” ");
INSERT INTO agn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Siminabat ka si Juan, “Maski sinopang taway, anda enged ay podir na mga belag tang Dios tang magtorol ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mga tistigos amo mismo ong inaningo ang belag ta yo tang Cristo, kondi yo tang sinobol tang Dios ang tongkaw ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pario mga may karasalen. Ang babay ang karasalen para lamang ong laling pakasalan na. Ang abay ang lali ke-deng ang pamasi lamang ig dorong kalipay na ang gaba-yan na tang bosis tang tangay nang agkasalen. Yo, maningo ka ta si mandian ang bogos tang kalipayo. ");
INSERT INTO agn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ig mandian kaministiran ang mas ilalaen tanandia ig yo dapat ipababak da.” ");
INSERT INTO agn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ang nagalin ong dibabaw makagagaem ong tanan. Ang nagalin ong tanek taga tanek ka enged ig pamalita tang natetenged lamang ong mga bagay tarin ong tanek. Piro tanandia ang nagalin ong dibabaw, yay ang makagagaem ong tanan. ");
INSERT INTO agn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pagpamatod tanandia natetenged ong inita na ig naba-yan na don, piro anday magparet ong mga agbibitala na. ");
INSERT INTO agn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Piro ang sinopay pagparet ong mga bitala na, pagpamatod nga ang Dios mataligan. ");
INSERT INTO agn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tenged ang sinobol tang Dios, poros bitala tang Dios mismo tang agsasayod na. Tenged bogos tang pagtorol tang Dios tang Ispirito na ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ang Tatay, aggegman na ta mo-ya tang Ana na ig inintriga na ong kalima na tang tanan ang bagay. ");
INSERT INTO agn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ang taw ang pagto ong Ana tang Dios, ong nandia ra tang kaboing anday kataposan. Piro ang indi magtoman ong Ana tang Dios indi enged magkatinir tang kaboing asi, kondi silotan tanandia tang Dios asta ong tanopa. ");
INSERT INTO agn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mandian nabalitan tang mga Pariseo ang mas yadi ra tang mga taw ang pamagosoy ig pamagpaboniag ong ni Jesus kaysa ong ni Juan. ");
INSERT INTO agn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Piro ong matod belag ta si Jesus mismo tang pagboniag kondi ang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Animan asing pagatako da Jesus ang naba-yan da tang mga Pariseo, namagalin tanira ong Judea para magbalik ong Galilea. ");
INSERT INTO agn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ong pagbalik nira don, kaministiran ang toma-lib tanira ong probinsia tang Samaria. ");
INSERT INTO agn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Asing tata-lib da tanira ong Samaria, gingabot da tanira ong tatang banoang aggoyan ta Sicar. Ang logar ang na alenget ong tanek ang pinatobli ni Jacob ong ana nang si Jose asing tokaw. ");
INSERT INTO agn_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tarin ong tanek ang na itaen tang bobon ni Jacob. Mandian, tenged ko-to ra tang kaldaw ig agpilayan da si Jesus ong pagpanaw na, kiminarong tanandia ong binit tang bobon ang asi. ");
INSERT INTO agn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mintras kakarong don, may tatang babay ang Samaritana ang kiminabot para manoro ta wi. Ganing si Jesus ong babay, “Poidio kang mainem ta wi?” ");
INSERT INTO agn_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ang oras ang asi, ang mga sinagpan na don da ong lansangan ang pamamakal ta mapangan nira. ");
INSERT INTO agn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Oman, ganing tang babay ang siminabat, “Angay pama-dola ta wi ong yen? Yawa tatang Judio, ig yo Samaritanao!” Maning ta si tang sabat na tenged ang mga Judio indi pamanapet ong mga Samaritano. ");
INSERT INTO agn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ganing si oman si Jesus ong babay, “Mga gata-wanan mo rin lamang mga onopa tang agto-dol tang Dios, ig mga sinopa nang pama-dol ong nio ta wi, yawa pa rin tang mama-dol ong yen, ig oldana yen ta wing pagtorol ta kaboi.” ");
INSERT INTO agn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Siminabat tang babay, “Magino, dorog kadalem tang wing na ig anday garong mo. Ong aria pa mangomit tang wing agganingen mo pagtorol ta kaboi? ");
INSERT INTO agn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Maliag mong yaning, yawa sobrā pa ong kamepet-mepetan tang si Jacob? Tanandia tang nagpatobli tang bobon ang na ong yamen, ig tanandia mismo nanginem tarin, asta ang mga ana na ig mga ayep na.” ");
INSERT INTO agn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ganing si Jesus ang siminabat, “Ang maski sinopay manginem ong wing na, koawen ang oman. ");
INSERT INTO agn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Piro ang manginem tang wing i-dolo, indi ra moman ang koawen. Tenged ang wing i-dolo magimong pario ong wing ma-bod ang bobolik ong nandia ig magtorol ta kaboing anday kataposan.” ");
INSERT INTO agn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Animan minaning tang babay ong ni Jesus, “Magino, mga maning don, olday ka tang wing agganingen mo, agod indio ra koawen, ig agod indio ra magbalik-balik tarin ang manoro.” ");
INSERT INTO agn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ganing si Jesus, “Molika ra, komiten mo tang katawa mo, ig e-lan mo tarin.” ");
INSERT INTO agn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Piro ganing tang babay, “Anday katawao.” Ganing ka si Jesus, “Tama kaman tang inaning mong anday katawa mo. ");
INSERT INTO agn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tenged lima ra tang nagimong katawa mo, ig ang ka-pen mo mandian belag ta matod ang katawa mo. Animan matod kaman tang inaning mong asia.” ");
INSERT INTO agn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ganing tang babay, “Magino, yawa sigoro tatang propita! Mane-mao kay ong nio. ");
INSERT INTO agn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ang mga kamepet-mepetan amen namagdayaw tanira ong Dios ig namagtorol tang mga bolontad nira tarin ong bokid ang na. Piro yamong mga Judio, ganing amo ang mga taw dapat mamagdayaw ig mamagbolontad ong Dios don lamang ong Jerusalem.” ");
INSERT INTO agn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ganing si Jesus, “Magpareta ong agganingo, babay. Komabot tang oras ang indi amo ra mamagdayaw ig mamagbolontad ong Dios ang Tatay tarin ong bokid ang na obin maski ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yamong mga Samaritano, indi gailala mi tang Dios ang agtowan mi. Piro yaming mga Judio gailala amen tanandia, tenged ang maglibri ong tanan ang taw magalin ong mga Judio. ");
INSERT INTO agn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Piro kakabot da tang oras ig ya ray na nga ang matod ang pamagto ong Dios ang Tatay mamagdayaw ong nandia ong tabang tang ispirito ig sigon ong kamatodan. Tenged maning atan tang galiagan ang itaen na ong mga pamagto ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ang Dios ay ispirito, animan ang mga pamagto ong nandia kaministiran mamagto ig mamagdayaw ong tabang tang ispirito ig sigon ong kamatodan.” ");
INSERT INTO agn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ganing tang babay ong ni Jesus, “Ang gata-wanano, komabot tang Mesiyas ang aggoyan ta Cristo. Ong pagkabot na, tanandia tang magpaintindi ong yaten tang tanan ang mga bagay.” ");
INSERT INTO agn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ganing si Jesus, “Yo, ang pagigampang ong nio, yay ang ganingen mong komabot.” ");
INSERT INTO agn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pagabitala lamang ni Jesus ta si, ya kay ang pagkabot tang mga sinagpan na nagalin ong lansangan. Pisan tanirang nangabereng asing itaen nira si Jesus ang pagigampang ong tatang babay. Piro maski tata ong nira anday nane-ma mga onopay kaministiran na obin angay pagigampang si Jesus ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Animan dayon ang bino-wanan tang babay tang tereldan na ta wi, ig dali-daling nagbalik ong lansangan. Ganing ong mga taw don, ");
INSERT INTO agn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dalien mi, tomabid amo ong yen! May taw baya don ang gata-wanan na tang tanan ang naboatano. Tanandia ra bato tang Cristo?” ");
INSERT INTO agn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Animan ang mga taw namansipanaw da paning ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mandian, ang mga sinagpan ni Jesus sigi tang reges ong nandia ang ganing, “Maistro, mamangana ra.” ");
INSERT INTO agn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Piro siminabat si Jesus, “Yo may pamanganong indi gata-wanan mi.” ");
INSERT INTO agn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Animan namagtere-ma te-man tang mga sinagpan na ang ganing, “Onopa bato, may nagtorol ong nandia ta pamangan?” ");
INSERT INTO agn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Piro ganing si Jesus ong nira, “Ang pamangano anday doma, tomaneno tang kaliagan tang Dios ang nanobol ong yen ig taposono tang agpaboat na ong yen. ");
INSERT INTO agn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Ganing amo mismo, ‘Epat pang bolan ba-lo tang pangangayeg.’ Piro agganingo ong nindio, pangangayeg da mandian. Torongan mi tang dorong mga taw ang pamansikabot! Mga ong arayegen pa, lotok dang pisan ig listo rang ayegen. ");
INSERT INTO agn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ang mga manigayeg solan da tang Dios, ig ang mga taw ang yay ang aggayegen nira oldan na ta kaboing anday kataposan. Ong maning don, ang mga pamagloak tang bitala tang Dios ig ang pamangayeg tang borak na delelengan ang mamagkalipay. ");
INSERT INTO agn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Animan matod kaman tang agganingen nga ‘Ang doma manigloak, ang doma manigayeg.’ ");
INSERT INTO agn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Sinobol amo yen ang mangayeg ta belag ta lindoak mi. Doma tang nagbedlay, piro yamo tang pangayeg tang binedlayan nira.” ");
INSERT INTO agn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mandian, yading mga Samaritano ong logar ang asi tang namagto ong ni Jesus tenged ong pamatod tang babay ong nira ang ganing, “Bineg na ong yen tang tanan ang naboatano.” ");
INSERT INTO agn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ig pagakabot tang mga Samaritano don ong ni Jesus, inawidan nira tanandia ang magtinir kang lagi don ong logar nira. Animan nagtinir si Jesus don ta doroang kaldaw. ");
INSERT INTO agn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ig mas yadi pang namagto ong nandia tenged ong pagtoldok na ong nira. ");
INSERT INTO agn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Asing ori ra, ganing tanira ong babay, “Mandian pamagto ami ra ong nandia belag lamang ta tenged ong binalita mo, kondi nabasi ami ra mismo ong mga bitala na. Ig gata-wanan amen da ang tanandia kaman tang Maniglibri tang mga taw ong kalibotan.” ");
INSERT INTO agn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagata-lib tang doroang kaldaw, nagalin da don si Jesus ig napaning ong probinsia tang Galilea. ");
INSERT INTO agn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tenged si Jesus mismo minaning dang lagi nga ang tatang propita indi aggilalaen tang mga kasimanoa na. ");
INSERT INTO agn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Asing pagakabot na ong Galilea, ang mga taw don masinlo tang pagrisibi nira ong nandia. Tenged asing Pista tang Pagta-lib tang Anghil, don ka tanira ong Jerusalem ig inita nira tang tanan ang bindoat na don. ");
INSERT INTO agn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Oman, napaning sing oman si Jesus ong Cana, sakep tang Galilea, ong logar ang don bindoat nang bino tang wi tanopa sia. Mandian, don ong Capernaum, ang sakep ka tang Galilea, may tatang opisialis tang gobirno tang Roma, ang ana nang lali pagmasit. ");
INSERT INTO agn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Asing mabalitan nang si Jesus nabalik da ong Galilea ang nagalin ong Judea, dayon ang pinaningan na. Nagpakiloy tanandia ang paningan kay ni Jesus tang ana na para pao-yaen, tenged agpakamo-kamo ra. ");
INSERT INTO agn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ganing si Jesus, “Mintras indi amo gaita ta milagro ig mga makabebereng ang mga bagay, indi amo mamagto ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Piro ganing tang opisialis, “Magino, maytara! Mapatay da tang anao!” ");
INSERT INTO agn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Siminabat si Jesus ong nandia, “Molika ra. Nago-ya ra tang ana mo.” Nagparet tang opisialis ang matod tang inaning ni Jesus, animan dayon dang napanaw ang molik ong Capernaum. ");
INSERT INTO agn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Pagaramal, asing don pa lamang ong dalan, binagat da tanandia tang mga torobolon na ig binalitan nira ang mo-ya ra tang ana na. ");
INSERT INTO agn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Animan nane-ma tanandia mga onopang orasay nago-ya. Ganing tanirang siminabat, “Nongapon pang ala ona tang apon pinoasan tang kinit na.” ");
INSERT INTO agn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ig nademdeman nang asing oras kang asi mismo ya kay ang paganing ong nandia ni Jesus, “Mo-ya ra tang ana mo.” Animan tanandia ig ang tanan ong pamalay-balay na namagto ra ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na yay ang yadoang milagrong bindoat ni Jesus ong Galilea, pagapagalin na ong probinsia tang Judea. ");
INSERT INTO agn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pagatapos ta si, pista si tang mga Judio, animan napaning sing oman si Jesus ong siodad tang Jerusalem. ");
INSERT INTO agn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Don ong Jerusalem, may parandigoan tang mga taw ang aggoyan ta Betesda mga ong bitala tang mga Judio. Ang parandigoan ang na, alenget ong tatang porta tang padir ang lomboa ong siodad. Ang goy ong portang asi ay Porta tang Karniro. Ong palibot tang parandigoan ang na, may lima nga balay-balayan ang palasirongan. ");
INSERT INTO agn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Dorong mga taw ang sari-saring masit nira tang pamaglobog-lobog lamang tarin, pario tang mga boray, mga piang, ig mga paralisado. Pamagelat tanirang komaliek tang wi ");
INSERT INTO agn_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","tenged teta may anghil tang Dios ang tataboan ig pagkalo-kalo tang wi. Ang ma-kaw ang tomogbo ong wi mga matapos ang kalo-kalon tang anghil ay mago-ya ono maski onopay masit na. ");
INSERT INTO agn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mandian, don may tatang lali ang tolong polok may walo rang takon tang masit na. ");
INSERT INTO agn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Inita ni Jesus tang laling asi ang lolbog da lamang ig gata-wanan nang lagi ang doro rag kaboay tang masit na. Animan sine-ma tanandia ni Jesus ang ganing, “Onopa? Galiliagang mago-ya?” ");
INSERT INTO agn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Siminabat tang lali, “Ee, Magino, galiliago ka rin. Piro mga makalo-kalo ra tang wi anda kay magalsa ong yen ang pababak. Pira rang bisis ang pagprosigiro ra rin ang paning ong wi piro may ga-kaw kang pirmi ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ganing si Jesus ong nandia, “Kendenga, takanen mo tang aglolbogan mo, ig panawa.” ");
INSERT INTO agn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lagi-lagi nago-ya tang taw ig dayon dang sinakan na tang lolbogan na ig napanaw. Ang kaldaw ang asi Kaldaw ang Igperenay. ");
INSERT INTO agn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Animan ganing tang mga pangolokolong Judio ong taw ang asing pinao-ya, “Hoy! Kaldaw ang Igperenay mandian! Kontra ong Katobolan ang magtakana tang lolbogan mong asia!” ");
INSERT INTO agn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Piro siminabat tang taw, “Ang taw ang nagpao-ya ong yen yay ang minaning ong yen ang takaneno tang lolbogano ig pomanaw.” ");
INSERT INTO agn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Sine-ma nira tanandia, “Sinopa tang taw ang asing nagtobol ong nio?” ");
INSERT INTO agn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Piro indi nailala tang taw mga sinopa sing nagpao-ya ong nandia tenged napalipat da si Jesus ong kadodoron ta taw. ");
INSERT INTO agn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pagata-lib ta na, inita ni Jesus ong Timplo tang taw ang pinao-ya na ig ganing ong nandia, “Mandian mo-yā ra. Animan india ra magboat ta kasalanan, itaben mas grabi pa tang mainabo ong nio.” ");
INSERT INTO agn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Oman dayon dang nagalin tang taw ig napaning ong mga pangolokolo ong mga Judio. Bineg na tanira ang si Jesus tang nagpao-ya ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tenged tarin, inimpisan dang inakigan ig pinaliwagan nira si Jesus tenged nagpao-ya tanandia ong Kaldaw ang Igperenay. ");
INSERT INTO agn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Piro siminabat si Jesus ong nira, “Ang Tatayo indi agpenay ong mga agboaten na, animan yo pagpadayono ka ong mga agboateno.” ");
INSERT INTO agn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tenged ong binitalang asi ni Jesus, mas namagprosigir tang mga pangolokolong Judio ang ipapatay tanandia, belag lamang ta tenged agkontraen na tang agbawalen nira mga Kaldaw ang Igperenay, kondi ganing pa tanandia nga ang Dios ay Tatay na. Ig ong maning don agpatepeng na tang sadili na ong Dios. ");
INSERT INTO agn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Animan ganing si Jesus ong mga pangolokolo ong mga Judio, “Ong kamatodan, yo, ang Ana tang Dios, anday maboato mga ong sadilio lamang. Ang agboateno lamang ay ang aggitaenong agboaten tang Tatayo. Ang onopay agboaten tang Dios ang Tatay, ya kay ang agboaten tang Ana. ");
INSERT INTO agn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tenged yo, agmaleno ta mo-ya tang Tatayo, ig agpaita na ong yen tang tanan ang agboaten na. Ig mas sobra pa ong mga bagay ang nang inita mi ra tang ipaboat na ong yen, agod pisan among mangabereng. ");
INSERT INTO agn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ang Dios ang Tatay pagboi ong mga patay, ig yo, ang Ana na, maning ka ta si boieno ka tang maski sinopa ang galiliaganong boien. ");
INSERT INTO agn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Belag lamang ta sia, ang Tatayo indi pagosgar ong maski sinopa, kondi yo tang sindolan na ta podir ang magosgar, ");
INSERT INTO agn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","agod yo, ang Ana na, galangeno tang tanan ang taw, pario tang paggalang nira ong nandia. Ang indi paggalang ong Ana tang Dios, indi ka paggalang ong Dios ang Tatay ang yay ang nanobol ong Ana na. ");
INSERT INTO agn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Agganingo ong nindio, ang sinopay pamasi ong yen ang mga bitala ig pagparet ong nanobol ong yen, ong nandia ra tang kaboing anday kataposan. Indi ra tanandia sintinsian tang Dios ta kamatayen tenged nalibri ra tanandia ong gaem tang kamatayen ig nasakepan da tang kaboi. ");
INSERT INTO agn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Piro tandan mi na: Komabot tang oras, ig ya ray na, ang mga taw ang midio patay ong pama-dek tang Dios, maba-yan nira tang bosis tang Ana tang Dios. Ig ang magparet maboi ka enged. ");
INSERT INTO agn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ang Dios ang Tatay may gaem na ang magtorol ta kaboi. Ig yo, ang Ana na, sindolano ka nandia ta gaem ang magtorol ta kaboi ong mga taw. ");
INSERT INTO agn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sindolano ka nandia ta podir ang magosgar ong tanan, tenged yo tang nagimong Ana ta Taw. ");
INSERT INTO agn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Dapat indi amo mangabereng ong agganingo, tenged komabot ka enged tang oras ang maba-yan tang mga patay tang bosiso ");
INSERT INTO agn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ig mamambangon ang magalin ong mga limbengan ong nira. Ang tanan ang namagboat ta mo-ya oldan ta kaboing anday kataposan, ig ang tanan ang namagboat ta malain silotan asta ong tanopa.” ");
INSERT INTO agn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ganing pa si Jesus, “Mga ong sadilio lamang anday maboato. Pagosgaro kaman piro sigon ong agtotoldok tang Tatayo ong yen. Animan mato-lid tang pagorosgareno, tenged belag ta sadiling kaliagano tang agboateno, kondi ang kaliagan tang Dios ang yay ang nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Mga yo lamang tang pagpamatod natetenged ong sadilio, dapat indi pareten mi. ");
INSERT INTO agn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Piro may domang pagpamatod natetenged ong yen, ig gata-wananong matod tang agganing na. ");
INSERT INTO agn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yamo mismo tang nanobol ta mga taw ong ni Juan, ig tanandia nagbeg tang kamatodan natetenged ong yen. ");
INSERT INTO agn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Belag ta maning ang kaministirano pa tang pagtistigo ta taw. Agpademdemo lamang ong nindio tang inaning ni Juan tenged ong yen. Balampa pareten mi agod malibri amo. ");
INSERT INTO agn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan, ang kalimbawan na midio tatang tolok ang de-kal ig nagtorol ta kayagan. Ig maski indi lamang naboay, inambengan amo ta mo-ya ong pagpāyag na ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Piro may pamatod pa enged natetenged ong yen ang mas pa ong pamatod ni Juan, ig ya ray na: Ang mga bagay mismong agboateno ang agpaboat ong yen tang Dios ang Tatay. Sia ya enged tang pagpamatod ang tanandia tang nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ig ang Dios ang Tatay ang nanobol ong yen, tanandia mismo pagpamatod ka natetenged ong yen. Maski tanopa indi enged inita mi tanandia ig indi naba-yan mi tang bosis na. ");
INSERT INTO agn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Indi ka ga-tang ong kinaisipan mi tang mga bitala na, tenged indi amo pamagparet ong yen, ang yay ang sinobol na. ");
INSERT INTO agn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ang agboaten mi lamang, aggosisaen mi ta mo-ya tang Sagradong Kasolatan tenged kalaom mi don mata-wanan mi mga mono amo pa magkatinir ta kaboing anday kataposan. Ong kamatodan, ang Kasolatan mismo pagpamatod natetenged ong yen, ");
INSERT INTO agn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","piro indi amo pa ka enged galiliag ang palenget ong yen agod marisibi mi tang kaboing asi. ");
INSERT INTO agn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Indio galiliag ang dayaweno ta taw. ");
INSERT INTO agn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Gailala amo yen ta mo-ya, ig gata-wananong anday paggegma mi ong Dios. ");
INSERT INTO agn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yo, napaningo tarin bilang tatang sinobol tang Tatayo, piro indio rinisibi mi. Piro mga may domang komabot ang indi sinobol na, yay ang risibien mi! ");
INSERT INTO agn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sigoradong indi amo mamagto ong yen! Tenged agpalabien mi tang pagdayaw tang kada tata may tata, imbis ang prosigiran mi agod ang tambilog lamang ang Dios tang magdayaw ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Indi amo magisip ang yo tang magtistigo kontra ong nindio ong talongan tang Dios ang Tatay. Belag! Si Moises ang agtaligan mi mismo yay ang magtistigo kontra ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tenged mga matod ang pamagparet amo ong sinolat ni Moises, dapat mamagparet amo ka rin ong yen, tenged ang mga sinolat ni Moises natetenged ka ong yen. ");
INSERT INTO agn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Piro indi agpareten mi tang mga sinolat na! Animan sigoradong indi ka pareten mi tang mga agganingo.” ");
INSERT INTO agn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pagatapos ta si, limina-ted si Jesus ong dobaling baybay tang Talsi tang Galilea ang aggoyan ka ta Talsi tang Tiberias. ");
INSERT INTO agn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kadoro-doroan ang mga taw tang namansidaton ong nandia tenged inita nira tang mga milagrong bindoat na ong pagpao-ya na ong mga pamagmasit. ");
INSERT INTO agn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Oman, siminakat si Jesus ong tatang bokid, aroman na tang mga sinagpan na, ig don tanira namansikarong. ");
INSERT INTO agn_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ang oras ang asi galenget da tang pista tang mga Judio ang aggoyan ta Pagta-lib tang Anghil. ");
INSERT INTO agn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mandian, pagpanorong ni Jesus, inita na tang kadoro-doroan ang mga taw ang agpapaning ong nira. Animan sine-ma na si Felipe, “Ong ari ita pa bato mabakal ta pamangan para ong mga taw ang asia?” ");
INSERT INTO agn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Maning ta si tang te-ma ni Jesus ong ni Felipe para lamang sobokan na mga onopa tang sabat na. Piro si Jesus may plano na rang lagi tang onopay boaten na. ");
INSERT INTO agn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Mandian siminabat si Felipe, “Kadoro! Maski mamakal ita pa ta tinapay ang kantidad nang rinibo indi ka enged magigo, maski tanga lolotad lamang.” ");
INSERT INTO agn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Oman si Andres, tata ka ong mga sinagpan ni Jesus ig logod ni Simon Pedro, tang naganing, ");
INSERT INTO agn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nani may tatang mola ang may balon nang limang tinapay may doroang yan. Piro pirara ka enged ong kadodoron ang na ta mga taw?” ");
INSERT INTO agn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ganing si Jesus ong mga sinagpan na, “Pakarongon mi tang mga taw.” Marabong tang ibabawen don, animan namansikarong tang tanan ang taw. Ang mga lali lamang limang ribo rang lagi. ");
INSERT INTO agn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Oman kinomit ni Jesus tang tinapay ang asi ong mola ig pagapagpasalamat na ong Dios, pinatagtag na ong mga taw ang pamansikarong don. Maning ka ta si tang bindoat na ong yan, ig ang tanan ang mga taw namagpagosto tang pangan. ");
INSERT INTO agn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Asing nangaelen dang tanan, ganing si Jesus ong mga sinagpan na, “Simeten mi tang nanga-da para indi masayang.” ");
INSERT INTO agn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dayon ang sinimet nira, ig nagalin ong limang bilog ang tinapay ang pinapan nira ong mga taw, nanga-mok pa tanira ta tampolok may doroang tiklis. ");
INSERT INTO agn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Asing pagaita tang mga taw ong nang makabebereng ang bagay ang bindoat ni Jesus, ganing tanira, “Na ya ray enged tang Propita ang pinatako asing tokaw ang komabot tarin ong kalibotan.” ");
INSERT INTO agn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ig tenged gata-wanan dang lagi ni Jesus ang galiliagan nirang boaten tanandia ang adi, nagalin tanandia don ig napaning ong kabobokidan ang tanandia lamang. ");
INSERT INTO agn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Asing alikarem da, ang mga sinagpan ni Jesus namansipaning ong binit tang baybay. ");
INSERT INTO agn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Namansitay tanira ong bilog nirang mabael para paning ong Capernaum, don ong dobaling baybay. Labi ra ig indi pa gabalik si Jesus ong nira. ");
INSERT INTO agn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Asing don da tanira ong laod, namoirsa ra tang mageyep ig namambabael da tang mga langeb. ");
INSERT INTO agn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pagabeltay nira ta lima obin enem ang kilomitro, inita nira si Jesus ang papanaw ong ta-paw tang talsi, ang agpalenget ong bilog ang agtayan nira. Animan pinangeldan tanira ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Piro minitala si Jesus ang ganing, “Indi amo meled. Yo na, si Jesus!” ");
INSERT INTO agn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dorong kalipay nirang matay da si Jesus ong agtayan nira. Ig pagatay lamang ni Jesus, golpi tanirang nangatampet ong distino nira. ");
INSERT INTO agn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pagaramal, don pa ong baybay tang kadoro-doroan ang taw. Gata-wanan dang lagi nira ang si Jesus indi siminabid ong mga sinagpan na asing pagalin nira, tenged inita nira ang tanira lamang tang siminay ong bilog. Ig gademdeman ka nirang ang labing asi anday domang matayan don. ");
INSERT INTO agn_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mandian, may mga bilog ang nagalin ong Tiberias ang namansitampet da don, alenget ong logar ang pinamanganan nira tang tinapay matapos ang nagpasalamat si Jesus ong Dios. ");
INSERT INTO agn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Animan asing pagatako tang mga taw ang anda ka don si Jesus asta ang mga sinagpan na, dayon tanirang namansitay ong mga bilog ang asi ig namansipaning ong Capernaum para dilemen nira si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pagakabot nira ong dobaling baybay, initang lagi nira si Jesus ig sine-ma nira, “Maistro, tanoapa pa tarin?” ");
INSERT INTO agn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Siminabat si Jesus ang ganing, “Ong matod, agdilemeno nindio belag ta maning naintindian mi tang mga milagrong inita mi, kondi tenged pinapan amo yen tang tinapay ig nangaelen among tanan. ");
INSERT INTO agn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Piro belag tang pamangan ang galangga lamang tang dapat dilemen mi. Ang prosigiran ming dilemen ang pamangan ang indi galangga ang yay pagtorol ta kaboing anday kataposan. Yo, ang Ana ta Taw, tang magtorol ta sia ong nindio, tenged pinamatodan da tang Dios ang Tatay ang yo tang naliliagan na.” ");
INSERT INTO agn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Animan namane-ma tang mga taw ong ni Jesus ang ganing, “Onopay boaten amen para matoman amen tang boroaten ang galiliagan tang Dios?” ");
INSERT INTO agn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Siminabat si Jesus, “Na ya ang galiliagan tang Dios ang boaten mi: Magto amo ong yen, ang sinobol na tarin.” ");
INSERT INTO agn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Piro ganing sing oman tang mga taw, “Animan onopay maboat mong milagro ang mapaita mo ong yamen agod magparet ami ong nio? ");
INSERT INTO agn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Asing tokaw ang timpo ni Moises, ang mga kamepet-mepetan ta namamangan ta tatang pamangan ang aggoyan ta ‘manna’ asing don tanira ong logar ang anday gistar ang taw. Pario tang na-tang ong Kasolatan ang ganing, ‘Sindolan na tanira ta pamangan ang nagalin ong langit.’ Ta mandian, yawa onopay niong boaten?” ");
INSERT INTO agn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Siminabat si Jesus, “Ong matod, belag ta si Moises tang nagtorol ong nira tang pamangan ang asing nagalin ong langit, kondi ang Tatayo. Ig mandian tanandia ya kay ang pagtorol ong nindio tang matod ang pamangan ang nagalin ong langit. ");
INSERT INTO agn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tenged ang matod ang pamangan ang agto-dol tang Dios, anday doma kondi tanandiang siminaboan ang nagalin ong langit ig pagtorol ta kaboi ong mga taw tarin ong kalibotan.” ");
INSERT INTO agn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Animan ganing tang mga taw ong ni Jesus, “Magino, olday ami ka niong pirmi tang pamangan ang asing agganingen mo!” ");
INSERT INTO agn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Siminabat si Jesus, “Yo mismo tang pamangan ang asing pagtorol ta kaboi. Tenged ang sinopay lemenget ong yen para magto ong yen, indi ra enged le-men ig indi ra koawen asta ong tanopa. ");
INSERT INTO agn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Piro yamo, pario tang inaningo rang lagi, maski initao ra nindio indi amo pa ka enged mamagto ong yen. ");
INSERT INTO agn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Lemenget enged ong yen tang tanan ang mga taw ang yintriga ong yen tang Dios ang Tatay. Ig ang maski sinopay lemenget ong yen, indi enged palayaseno. ");
INSERT INTO agn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tenged yo siminaboano nagalin ong langit, belag ta maning para boateno tang sadiling kaliagano, kondi ang kaliagan tang nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ig ang kaliagan na yay na: Ta-lingano tang mga taw ang inintriga na ong yen agod anday malipat maski tambilog, kondi boieno tanirang tanan ong oring kaldaw. ");
INSERT INTO agn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tenged ang galiliagan tang Tatayo, magkatinir ta kaboing anday kataposan tang tanan ang mailala ig magto ong yen, ang Ana na. Ig boieno tanirang moman ong oring kaldaw.” ");
INSERT INTO agn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mandian, ang mga Judio pamagmoro-moro tenged ong inaning ni Jesus ang tanandia ono tang pamangan ang nagalin ong langit. ");
INSERT INTO agn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ganing tanira, “Onora? Si Jesus ka lamang asia, ang ana ni Jose! Gailala ta ka ngani tang mga ginikanan na! Angay ganing tanandia mandian nagalin ono tanandia ong langit?” ");
INSERT INTO agn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Sinabat tanira ni Jesus ang ganing, “Indi amo ra mamagmoro-moro atan. ");
INSERT INTO agn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Anday taw ang malenget ong yen poira lamang mga e-lan tanandia tang Tatay ang yay ang nanobol ong yen. Ig ang mga lemenget ig magto ong yen, tanira tang boieno ong oring kaldaw. ");
INSERT INTO agn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nasolat ong libro tang mga propita ang ganing, ‘Ang tanan ang taw toldokan tang Dios.’ Animan ang tanan ang mamamasi ig mamagadal ong Tatay mamansilenget ong yen. ");
INSERT INTO agn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Indio ganing ang may taw ang naita ra ong Dios ang Tatay. Yo ang nagalin ong Dios, yo lamang tang naita ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Ong kamatodan, ang taw ang pagto ong yen, ong nandia ra tang kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Tenged yo tang pamangan ang pagtorol ta kaboi. ");
INSERT INTO agn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ang mga kamepet-mepetan mi namamangan tang pamangan ang aggoyan ta ‘manna’ asing don tanira ong logar ang anday gistar ang taw, piro nangapatay pa ka enged tanira. ");
INSERT INTO agn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Piro ang pamangan ang agganingeno mandian, sia yay ang matod ang pamangan ang napababak nagalin ong langit, ig ang maski sinopay mamangan ta narin indi enged mapatay. ");
INSERT INTO agn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yo yay ang pamangan ang asing pagtorol ta kaboi ang napababak nagalin ong langit. Ang maski sinopay mamangan ta narin, maboi asta ong tanopa. Ang pamangan ang narin anday doma kondi ang yen ang sinangoni, ig na ibolontado agod magkatinir ta kaboi tang mga taw tarin ong kalibotan.” ");
INSERT INTO agn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Pagabasi ta narin tang mga Judio, dayon dang namagdiskosionan ta mo-ya. Ganing tanira, “Onora ka? Monopa bato i-dol tang taw ang na tang sinangoni na ong yaten para panganen ta?” ");
INSERT INTO agn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Animan siminabat si Jesus, “Yo, ang Ana ta Taw, ganingo ong nindio: Mga indi amo mamangan tang yen ang sinangoni ig indi manginem tang yen ang dogo, indi amo enged magkatinir ta kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Piro ang maski sinopay pamangan tang yen ang sinangoni ig panginem tang yen ang dogo, yay ang may kaboi nang anday kataposan, ig boieno ong oring kaldaw. ");
INSERT INTO agn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tenged ang yen ang sinangoni ig ang yen ang dogo yay ang matod ang pamangan ig irinemen. ");
INSERT INTO agn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ang maski sinopay pamangan tang sinangonio ig panginem tang yen ang dogo, na-pen da ig pagtinir ong yen, ig yo ya ka ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ang Dios ang Tatayo ang nanobol ong yen yay ang agpagalinan tang kaboi, ig gaboio tenged ong nandia. Maning ka ta si, ang sinopay pamangan tang yen ang sinangoni, maboi ka tanandia tenged ong yen. ");
INSERT INTO agn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yo tang matod ang pamangan ang napababak nagalin ong langit. Ang pamangan ang na belag ta pario tang manna ang pinangan tang mga kamepet-mepetan mi asing tokaw. Namamangan tanira ta si piro nangapatay pa ka enged. Piro ang maski sinopay mamangan ong yen, maboing anday kataposan.” ");
INSERT INTO agn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ang mga bagay ang narin inaning ni Jesus asing pagtoldok tanandia ong simban tang mga Judio don ong Capernaum. ");
INSERT INTO agn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Naba-yan narin tang mga taw ang pirming pamansitabid ong ni Jesus, ig yadi ong nira tang ganing, “Kaparti ka tang mga agbibitala nang na! Sinopa lamang ay magparet ong nandia?” ");
INSERT INTO agn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Maski anday nagbeg ong ni Jesus, gata-wanan na ang pamagmoro-moro tang mga sinagpan na. Animan ganing tanandia, “Angay? Taliodano ra nindio tenged ong inaningong asia? ");
INSERT INTO agn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mono amo pa bato mga itaen mi tang Ana ta Taw ang agpadibabaw pabalik ong pinagalinan na? ");
INSERT INTO agn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ang Ispirito tang Dios yay ang pagtorol ta kaboi, belag ta sinangoni ta taw, tenged sia anday gaem na. Ang mga agbibitalao ong nindio pagalin ong Ispirito ig mapagekel ong nindio ong kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Piro ang doma ong nindio indi pamagto ong yen.” Minaning si Jesus ta si tenged gata-wanan nang lagi, mimpisa pa asing primiro, mga sinopay indi mamagto ig mga sinopa tang magtraidor ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ig ganing pa tanandia, “Yay sia animan minaningo ong nindio, anday taw ang malenget ong yen poira lamang mga sia tang kaliagan tang Dios ang Tatay.” ");
INSERT INTO agn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Impisa don yadi ra ong mga sinagpan ni Jesus tang namampabelag ig indi ra namansitabid ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Animan sine-ma ni Jesus tang tampolok may doroang apostolis na, “Yamo, galiag amo ra kang magalin?” ");
INSERT INTO agn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ang siminabat si Simon Pedro, “Gino, ong nino ami pa oman paning? Yawa lamang tang pagtoldok tang mga bitalang pagtorol ta kaboi. ");
INSERT INTO agn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Pamagto ami ra ong nio ig gata-wanan amen da ang yawa tang Sagradong Ana tang Dios.” ");
INSERT INTO agn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ganing si Jesus, “Matod ang yamong tampolok may doroa tang piniliko. Piro ang tata ong nindio ay dimonio!” ");
INSERT INTO agn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ang agpataman ni Jesus ay si Judas, ang ana ni Simon Iscariote. Tenged maski kabilang si Judas ong tampolok may doroang sinagpan na, tanandia yay ang magtraidor ong ni Jesus ong ori. ");
INSERT INTO agn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagatapos ta si, linibot-libot ni Jesus tang bilog ang probinsia tang Galilea. Indi naliag ang paning ong probinsia tang Judea tenged don tang mga pangolokolong Judio ig agplanoan nirang patayen tanandia. ");
INSERT INTO agn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mandian, asing galenget da tang pista tang mga Judio ang aggoyan ta Pista tang mga Payag-payag, ");
INSERT INTO agn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ganing ong ni Jesus tang mga logod nang lali, “Angay india magalin tarin ig mamistā don ong Judea, agod itaen tang mga sinagpan mo don tang agboaten mong mga milagro? ");
INSERT INTO agn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ang taw ang galiliag ang mabantog ong tanan, indi panalok-talok tang mga agboaten na. Pagboata ra ka lamang tang mga bagay ang na, angay india magpaita ong bilog ang kalibotan?” ");
INSERT INTO agn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Maning ta si tang inaning tang mga logod ni Jesus tenged maski ngani tanira indi ka pamagto ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ganing ang siminabat si Jesus, “Yamo, maski onopay oras poiding boaten mi tang onopay galiliagan ming boaten. Piro yo, indi pa kakabot tang yen ang oras. ");
INSERT INTO agn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Indi amo asilagan tang mga taw tarin ong kalibotan ang indi pangilala ong yen. Piro yo gasilagano nira tenged agpaitao ang malalain tang mga agboaten nira. ");
INSERT INTO agn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ala, mamista amo ra don. Yo, indio paning, tenged indi pa kakabot tang yen ang oras.” ");
INSERT INTO agn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Maning ta na tang sabat ni Jesus, oman napabo-wan tanandia ong Galilea. ");
INSERT INTO agn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pagapagalin tang mga logod ni Jesus para mamista, diminaton ka tanandia piro talok lamang. ");
INSERT INTO agn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Don ong pista agdilemen tanandia tang mga pangolokolong Judio ig pamane-ma te-ma ang ganing, “Ong arira tang taw ang asi?” ");
INSERT INTO agn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ig ang mga taw, sigi lamang tang arampang-ampang nira natetenged ong ni Jesus. Ganing tang doma, “Mo-yang taw tanandia!” Ang doma ganing ka, “Belag! Aglokon na lamang tang mga taw.” ");
INSERT INTO agn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Piro maloay lamang tang ampang nira natetenged ong ni Jesus tenged agpangeldan tanira ong mga pangolokolo ong nira. ");
INSERT INTO agn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Asing panenga-tengan da tang pista, siminled si Jesus ong Timplo ig nagtoldok. ");
INSERT INTO agn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nangabereng ta mo-ya tang mga pangolokolong Judio. Ganing tanira, “Ong aripa bato nakomit tang kinata-wanan na tang taw ang na? Indi ngani napagadal!” ");
INSERT INTO agn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ganing si Jesus ong nira, “Ang agtotoldoko ong nindio indi nagalin ong sadilio, sia ong Dios ang yay ang nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ang maski sinopay galiliag ang magtoman tang kaliagan tang Dios, asia mata-wanan na enged mga ang totoldoko nagalin ong Dios obin ong sadilio lamang. ");
INSERT INTO agn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ang taw ang pagtoldok ong sadiling kaliagan na, galiliag lamang ang dayawen tanandia ta doma. Piro ang taw ang pagtoldok agod dayawen tang nanobol ong nandia, yay ang taw ang palareten ig belag ta bo-lien. ");
INSERT INTO agn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Matod ang sindolan amo ni Moises tang Katobolan asing tokaw. Piro maski tata ong nindio anda enged ay pagtoman ta sia. Tenged mga pamagtoman amo, angay galiliag amo pang patayeno nindio?” ");
INSERT INTO agn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Siminabat tang mga taw, “Sigoro sinleda ra ta dimonio! Sinopay galiag ang mamatay ong nio?” ");
INSERT INTO agn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ganing si Jesus, “Nangabereng amo asing nagpao-yao tang tatang taw ong Kaldaw ang Igperenay. ");
INSERT INTO agn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Piro isipen mi lamang narin: Asing tokaw may kaogalian tang mga kamepet-mepetan ta natetenged ong pagtori ong mga mola. Sia pinanoblian ni Moises ig sindol na ka ong nindio. Animan pamagtori amo tang mga ana ming lali ong yawalong kaldaw sigon ong kaogalian ang asi, maski māton ong Kaldaw ang Igperenay. ");
INSERT INTO agn_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mandian, mga pamagtori amo maski Kaldaw ang Igperenay para lamang matoman tang tobol ni Moises natetenged ong pagtori, angay gangasilag amo pa ong yen ang nagpao-yao tang tatang taw ong Kaldaw kang Igperenay? ");
INSERT INTO agn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Magosgar amo ta mato-lid, belag ta sigon ong gitaen mi lamang.” ");
INSERT INTO agn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mandian, may mga taga Jerusalem ang ganing, “Belag bato ta na tang taw ang galiagan ang patayen tang mga pangolokolo ong yaten? ");
INSERT INTO agn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Piro asia tanandiang bibitala ong talongan tang tanan, ig ang mga pangolokolo anday ibek-ibek nira kontra ong nandia. Sigoro naisip da nirang tanandia ka kaman tang Cristo. ");
INSERT INTO agn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Piro indi ka poidi, tenged ganing tanira mismo, mga komabot ono tang Cristo, anday matako mga ong aripa tanandia nagalin. Piro ang taw ang na, gata-wanan ta rang lagi mga ong aripa tanandia nagalin.” ");
INSERT INTO agn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Animan pinabael ni Jesus tang bosis na asing pagtoldok don ong Timplo ig minaning, “Onopa? Gailala amo ra ong yen? Gata-wanan mi ka mga ong ariopa nagalin? Anda! Tenged ong kamatodan, indio napaning tarin ong yen ang sadiling kaliagan. Ang matod ang Dios yay ang nanobol ong yen. Indi tanandia gailala mi, ");
INSERT INTO agn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","piro yo, gailalao ong nandia. Tenged dono nagalin ong nandia, ig tanandia mismo tang nanobol ong yen tarin.” ");
INSERT INTO agn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Animan tenged ong mga binitalang asi ni Jesus, depen da rin tanandia tang mga pangolokolong Judio, piro anday nandep ong nandia tenged belag pa ta oras na. ");
INSERT INTO agn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Piro ong dobali ta sia, yading namagto ong nandia. Ganing tanira, “Sigoro ya ray na tang Cristo! Tenged anda enged ay madeg ong nandia ong mga makabebereng ang bagay ang agboaten na.” ");
INSERT INTO agn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Naba-yan tang mga Pariseo tang arampang-ampang tang mga taw natetenged ong ni Jesus. Animan tanira may ang mga pangolokolo ong mga padi nanobol ong mga goardia tang Timplo para depen nira si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Piro ganing si Jesus, “Indi ra lamang maboay tang a-peno ong nindio, oman magbaliko ra ong nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Dilemeno nindio, piro indio ra itaen mi. Tenged indi amo mapaning ong logar ang paningano.” ");
INSERT INTO agn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Namagtere-ma te-man tang mga pangolokolong Judio ang ganing, “Ong ayra bato paning tang taw ang na ang indi ra ono tanandia itaen? Onopa? Paning bato tanandia ong mga kasimanoa ta ang pamansistar ong domang mga banoa para magtoldok ka ong mga belag ta Judio? ");
INSERT INTO agn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ganing dilemen ta ono tanandia, piro indi ra itaen ta, ig indi ita ka ono mapaning ong paningan na. Onopa bato tang maliag nang yaning?” ");
INSERT INTO agn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Asing kataposan dang kaldaw tang pista ang yay ang kapistan dang enged, kimindeng si Jesus ig minitala ta dorog kapoirsa ang ganing, “Ang sinopay agkoawen palenget ong yen ig manginem. ");
INSERT INTO agn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tenged ganing ong Kasolatan, ang taw ang magto ong yen ‘magtinir ong nandia tang pagtorol ta kaboi ang pario ong wing ma-bod ang sigi lamang tang tobod na.’ ” ");
INSERT INTO agn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ang agganingen ni Jesus tarin anday doma, ang Ispirito Santong i-dol na ong mga taw ang pamagto ra ong nandia. Ang mga oras ang asi indi pa ga-dol tang Ispirito Santo, tenged indi pa gabalik si Jesus ong langit. ");
INSERT INTO agn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Dorong taw tang nangabasi ong mga inaning ang asi ni Jesus, ig ganing tang doma, “Matod ka kaman! Ya ray na tang Propitang aggelaten ta!” ");
INSERT INTO agn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ang doma ganing ka, “Na ya ray ang Cristo!” Piro ang doma ganing pa ka enged, “Indi poidi! Ang Cristo belag ta taga Galilea! ");
INSERT INTO agn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na-tang mismo ong Kasolatan, ang Cristo magalin ong dogo ni Ading David ig don ipangana ong Betlehem, ang banoa ni David.” ");
INSERT INTO agn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Animan indi mamaginigoan tang mga taw ong pabetang nira ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ang doma ong nira galiliag din ang depen nira, piro anda enged ay nangas ang magdep ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mandian, namagbalik da tang mga goardia tang Timplo ong mga pangolokolong padi ig mga Pariseo. Sine-ma tanira tang mga pangolokolo ang ganing, “Angay indi ingkelan mi si Jesus tarin?” ");
INSERT INTO agn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Siminabat tang mga goardia, “Mandian ami lamang nabasi ta taw ang bibitala ta maning ta naka!” ");
INSERT INTO agn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ganing tang mga Pariseo, “Oy, yamong taw amo! Maliag yaning asta yamo naloko amo ra ka nandia? ");
INSERT INTO agn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Onopa? May inita mi ang maski tata ong yamen ang mga Pariseo obin mga pangolokolo ang nagparet da ong nandia? Anda! ");
INSERT INTO agn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ang mga taw lamang ang asiang indi gangatako tang Katobolan ni Moises tang pamagparet ong nandia. Isompa tanira tang Dios!” ");
INSERT INTO agn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Mandian, tata ka don ong mga Pariseo si Nicodemo, ang napaning ong ni Jesus tanopa sia. ");
INSERT INTO agn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ganing si Nicodemo ong mga karomanan nang Pariseo, “Kontra ong Katobolan ta ang sintinsian tang tatang taw ang indi pa tanandia gaimbistigar para mata-wanan mga onopay bindoat nang kasalanan.” ");
INSERT INTO agn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Siminabat tanira, “Sigoro yawa taga Galileā ka! Osisaen mo ong Kasolatan, ig don mata-wanan mo ang anda enged ay propita tang Dios ang magalin ong Galilea.” ");
INSERT INTO agn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Oman, namansiolik da tanirang tanan. ");
INSERT INTO agn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Piro si Jesus napaning pa don ong Bokid tang Kaoliboan. ");
INSERT INTO agn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pagaramal, maga pang pisan, nagbalik si tanandia ong Timplo. Pagakabot na don, dorong mga taw ang namansipalenget ong nandia, animan kiminarong tanandia ig nagimpisang nagtoldok. ");
INSERT INTO agn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Maboay-boay ta ge-ley, atan da tang mga manigtoldok tang Katobolan ig ang mga Pariseo. May aggekelan nirang tatang babay ang nadep nirang pangonlali. Pina-deng nira ong talongan tang tanan, ");
INSERT INTO agn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","oman ganing tanira ong ni Jesus, “Maistro, ang babay ang na nadep amen ang pangonlali ong akto. ");
INSERT INTO agn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Sigon ong Katobolan ni Moises, ang mga babay ang maning ta na kaministiran banggilen ta bato asta mapatay. Piro onopa ong nio?” ");
INSERT INTO agn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Maning ta si tang te-ma nira para depdepen nira Jesus ong sabat na agod madimanda nira tanandia. Piro ang bindoat ni Jesus, naningkolong tanandia ig nagsolat-solat tang toldok na ong tanek. ");
INSERT INTO agn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sigi pa enged tang te-ma nira ong ni Jesus, animan kimindeng si tanandia ig minaning, “Ang sinopa ong nindio tang anday kasalanan na yay tongkaw ang mamanggil ong babay ang na.” ");
INSERT INTO agn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Oman dayon sing naningkolong si Jesus ig nagsolat-solat si ong tanek. ");
INSERT INTO agn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pagabasi nira tang inaning nang asi, namagalin tang kada tata impisa ong kamepetan. Anday nabo-wan poira ong ni Jesus ig ang babay ang ke-deng pa ong talongan na. ");
INSERT INTO agn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kimindeng si si Jesus ig pina-dekan na tang babay. Sine-ma na, “Ong arira tanira, babay? Onopa? Anday nagosgar ig namanggil ong nio?” ");
INSERT INTO agn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Anda, Magino,” tang sabat tang babay. Ig ganing si Jesus ong nandia. “Maski yo, indio ka magsilot ong nio. Molika ra ig india ra moman ang magboat ta kasalanan.” ");
INSERT INTO agn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nagtoldok sing oman si Jesus ong mga taw. Ganing tanandia, “Yo tang tolok ang pagtorol ta kayagan ong mga kinaisipan tang mga taw ong kalibotan. Ang magosoy ong yen indi ra maki-lepan, kondi mayagan tang kinaisipan na tang tolok ang yay ang magekel ong nandia ong kaboi.” ");
INSERT INTO agn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pagabasi tang mga Pariseo, ganing tanira, “Yawa ka lamang tang pagpamatod natetenged ong sadili mo, animan belag ta palareten tang pamatod mo.” ");
INSERT INTO agn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Siminabat si Jesus, “Maski yo lamang tang pagpamatod tenged ong sadilio, matod tang agganingo, tenged yo gatako tang pinagalinano ig ang paningano. Piro yamo, indi amo gatako. ");
INSERT INTO agn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pamagosgar amo sigon lamang ong isip ta taw, animan belag ta tama tang pagorosgaren mi. Yo, indio pagosgar maski ong ninopa. ");
INSERT INTO agn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Piro mga yo ra enged ay magosgar, tama tang pagorosgareno. Tenged belag lamang ta yo tang magosgar. Doroa aming magosgar— yo may ang Dios ang Tatay ang nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ga-tang mismo ong Kasolatan mi ang dapat pareten tang pamatod ta doroang tistigos basta magparioan tang pamatod nira. ");
INSERT INTO agn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yo tatang pagpamatod natetenged ong sadilio. Ig ang yadoa ang Tatayo, ang yay ang nanobol ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ganing tang mga Pariseong nane-ma, “Ong aripa tang tatay mo?” Siminabat si Jesus, “Indi amo gailala ong yen asta ong Tatayo. Mga nailalao ra rin nindio, mailala mi ka asta ang Tatayo.” ");
INSERT INTO agn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ang tanan ang narin binitala ni Jesus asing pagtoldok tanandia don mismo ong Timplo, alenget ong mga beretangan ta bolontad. Piro anday nangas ang magdep ong nandia, tenged belag pa ta oras na. ");
INSERT INTO agn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ganing sing oman si Jesus ong mga pangolokolo ong mga Judio, “Indi ra lamang maboay, yo magalino ra tarin. Dilemeno nindio, piro mangapatay amo lamang ang mga kasalanan mi indi napatawad. Indi amo mapaning ong paningano.” ");
INSERT INTO agn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Animan ganing tang mga pangolokolo ang pamagarampang-ampang, “Onopa bato, magbigti tanandia animan ganing indi ita ono mapaning ong paningan na?” ");
INSERT INTO agn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ganing si Jesus ong nira, “Yamo, taga tarin amo ong tanek. Piro yo taga dono ong dibabaw. Yamo, taga tarin ong kalibotan ang na. Yo belag. ");
INSERT INTO agn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yay sia animan inaningo ong nindio ang mangapatay among ang mga kasalanan mi indi napatawad. Tenged ya enged ay mainabo ong nindio mga indi amo magparet ang yo tang agganingeno.” ");
INSERT INTO agn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ganing tanirang nane-ma, “Angay? Sinoapa enged?” Siminabat si Jesus, “Yo tang agganingeno rang lagi ong nindio mimpisa pa asing tokaw asta mandian da lamang. ");
INSERT INTO agn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yadi rin ang maningo kontra ong nindio. Piro ang agbibitalao lamang mandian ong tanan ang mga taw, anday doma kondi ang mga bagay ang gaba-yano ong nanobol ong yen. Ig ang tanan ang bitala na matod ig mataligan.” ");
INSERT INTO agn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Piro indi nangaintindi tang mga Judio nga ang agsambiten nang nanobol ay ang Dios ang Tatay mismo. ");
INSERT INTO agn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Animan ganing si Jesus ong nira, “Pag kabot tang oras ang yo, ang Ana ta Taw, pinalawig mi ra ong ayo, asia mata-wanan mi ra ang yo ka kaman tang inaningo rang lagi ong nindio. Mata-wanan mi kang anday agboateno ong yen ang sadiling aotoridad lamang. Ang onopay agbibitalao, ang Tatay tang nagtoldok ta si. ");
INSERT INTO agn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tanandia tang nanobol ong yen tarin ong kalibotan, ig tanandia pirmi kang aromano. Indio enged agbayan na, tenged ang onopay pagtorol ong nandia ta kalipayan, sia yay ang agboateno.” ");
INSERT INTO agn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pagabasi tang mga taw ong mga inaning ang na ni Jesus, yadi ong nira tang namagto ra ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Dayon ang minitala si Jesus ong mga Judiong pamagto ra ong nandia. Ganing tanandia, “Mga magpadayon among magtoman ong mga totoldoko, maliag yaning matod ka kaman ang yamo mga sinagpano. ");
INSERT INTO agn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Oman mata-wanan mi tang kamatodan, ig ang kamatodan yay ang maglibri ong nindio.” ");
INSERT INTO agn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Piro siminabat tang mga Judio, “Yami, mga inampo ami ni Abraham! Ig libri ami rang lagi tenged maski tanopa indi ami agboaten ang kirepen tang maski sinopa. Angay ganinga mangalibri ami?” ");
INSERT INTO agn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Siminabat si Jesus, “Agganingo ong nindio, ang tanan ang pamagboat ta kasalanan, midio kirepen tang kasalanan. ");
INSERT INTO agn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mandian, ang tatang kirepen indi agbibilang ang pirmaninting mimbro tang pamalay-balay. Piro ang ana mimbro pa ka enged tang pamalay-balay asta ong tanopa. ");
INSERT INTO agn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Animan mga yo, ang Ana tang Dios, tang maglibri ong nindio, maliag yaning malibri amo ka enged. ");
INSERT INTO agn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Gata-wananong mga inampo amo ka kaman ni Abraham. Piro ong dobali ta sia, pamagprosigir amo pa ka enged ang patayeno nindio tenged indi maliagan mi tang agtotoldoko. ");
INSERT INTO agn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ang agganingo ong nindio anday doma kondi ang mga bagay ang gitaeno ong Tatayo. Ig yamo, maning ka ta si, tenged ang onopay nadalan mi ong tatay mi, ya kay ang agboaten mi.” ");
INSERT INTO agn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nagpareges tang mga Judiong siminabat, “Si Abraham tang tatay amen!” Piro ganing si Jesus, “Mga yamo mga ana ni Abraham, dapat patoladan mi ka rin tang mga bindoat na. ");
INSERT INTO agn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Piro ang agprosigiran mi ay patayeno nindio, maski pagbego lamang tang kamatodan ang inaning tang Dios ong yen. Si Abraham indi enged napagboat tang pario tang agboaten mi! ");
INSERT INTO agn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ang agboaten mi pario tang agboaten tang matod ang tatay mi.” Siminabat tanira, “Belag ami ta mga ana ong poira! Ang Dios lamang tang tatay amen! Anday doma!” ");
INSERT INTO agn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ganing si Jesus, “Mga matod nga ang Dios tang tatay mi, gegmano ka rin nindio tenged yo nagalino ong nandia. Indio napaning tarin ong yen ang sadiling kaliagan lamang. Ang Dios tang nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Angay indi amo mangaintindi tang agganingo? Tenged sigoro indi marisibi mi tang agtotoldoko. ");
INSERT INTO agn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Si Satanas tang tatay mi, ig dorong kaliag ming magboat tang onopay galiliagan na! Tanandia manigpatay ta taw impisa pa asing tokaw. Anday kointa na ong nandia tang kamatodan tenged anda enged ay kamatodan ong nandia. Ogali na tang magbo-li, tenged tanandia bo-lien ig ya kay ang tatay tang tanan ang kabo-lian. ");
INSERT INTO agn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Piro yo, ang agbibitalao ay poros kamatodan, ig yay sia tang dailan animan indi amo pamagparet ong yen. ");
INSERT INTO agn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sinopa ong nindio tang mapaganing ang yo nagkatalak? Anda enged! Piro mga pagbego tang kamatodan, angay indi amo mamagparet ong yen? ");
INSERT INTO agn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ang mga ana tang Dios, pamamasi ong mga bitala na. Piro tenged belag amo ta mga ana tang Dios, yay sia animan indi amo mamamasi ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Pagabasi ta narin tang mga pangolokolong Judio, ganing tanira ong ni Jesus, “Oy! Matod kaman pala tang agganing amen ang yawa tatang Samaritano ig sinleda ta dimonio!” ");
INSERT INTO agn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Siminabat si Jesus, “Indio sinled ta dimonio. Pagtorolo ta mabael ang dengeg ong Tatayo, piro yamo, pamanlangga amo ong yen. ");
INSERT INTO agn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Indio pagdilem tang pagdayaw ta mga taw. Piro may atan ang galiliag ang yo dayawen, ig tanandia tang gatakong magosgar ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tandan mi na: Ang maski sinopay magtoman ong mga toldoko indi mapasar tang kamatayen ang anday kataposan na.” ");
INSERT INTO agn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ganing sing oman tang mga Judio, “Mandian gasigoro amen da enged ang sinleda ka kaman ta dimonio! Napatay si Abraham, ig ang mga propita nangapatay ka. Piro ganinga ang sinopay magtoman ong mga toldok mo, indi enged mapatay maski tanopa. ");
INSERT INTO agn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Angay? Maliag mong yaning, yawa sobrā pa ong kamepet-mepetan amen ang si Abraham? Napatay ngani tanandia, asta ang mga propita ya ka. Ay yawa sinoapa?” ");
INSERT INTO agn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ganing si Jesus ang siminabat, “Mga pagpalawigo tang sadilio, sia anday kointa na. Ang Tatayo, ang ganing amo yay ang Dios mi, tanandia tang pagpalawig ong yen. ");
INSERT INTO agn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ong matod, indi tanandia gailala mi. Piro yo, gailalao ong nandia. Mga maningo ang indio gailala ong nandia, lomboao ang bo-lien ang pario mi. Piro ang kamatodan, gailalao tanandia ig agtomaneno tang mga agganing na. ");
INSERT INTO agn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ang kamepet-mepetan ming si Abraham mismo, dorong kalipay na asing maba-yan nang itaen na tang kaldaw ang paningo tarin ong kalibotan. Sia inita na kaman ig inambengan tanandia ta mo-ya.” ");
INSERT INTO agn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tenged tarin ganing tang mga pangolokolong Judio ong ni Jesus, “Onora ka? Anda pa ngani ay limampolok ang takon tang idad mo, inita mo ra si Abraham?” ");
INSERT INTO agn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ganing ang siminabat si Jesus, “Agganingo ong nindio, indi pa gataw si Abraham, yo, atano rang lagi.” ");
INSERT INTO agn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ig dayon tanirang namamisik ta mga bato para patayen nira tanandia ong banggil. Piro napalipat si Jesus ig limindoa ong Timplo. ");
INSERT INTO agn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mintras papanaw si Jesus, may inita nang tatang taw ang boray ang lagi mimpisa pa asing pagataw na. ");
INSERT INTO agn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mandian nane-ma ong ni Jesus tang mga sinagpan na, “Maistro, angay ang taw ang asia pinanganang boray ang lagi? Sinopa bato tang nagkatalak, tanandia obin ang mga ginikanan na?” ");
INSERT INTO agn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Siminabat si Jesus, “Pinangana tanandiang boray belag tang maning tanandia nagkatalak obin ang mga ginikanan na. Sia nainabo agod itaen tang gaem tang Dios ong kaboi na. ");
INSERT INTO agn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mintras kaldaw pa, kaministiran boaten ta tang mga agpaboat ong yaten tang nanobol ong yen. Tenged mga labi ra, indi ita ra mapagboat ta si. ");
INSERT INTO agn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mintras tarino pa ong kalibotan, yo tang tolok ang pagtorol ta kayagan ong tanan.” ");
INSERT INTO agn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pagabitala ta na ni Jesus, dayon ang nangolak ong tanek. Sinampora na tang tanek may ang olak na. Oman sinampel na ong mata tang boray ");
INSERT INTO agn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ig minaning, “Ala! Mandian paninga don ong parandigoan don ong logar tang Siloam. Mandamota don.” (Ang maliag yaning tang Siloam, “Sinobol.”) Ig maning ka don tang bindoat tang boray ig pagaolik na, gaita ra. ");
INSERT INTO agn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Animan namagampang-ampang tang mga kamalay na ig ang mga nangaita ong nandia tanopa sia asing tanandia pagpalimos pa. Ganing tanira, “Belag bato ta na tang laling dating pagpalimos?” ");
INSERT INTO agn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Siminabat tang doma, “Ya ka kaman!” Piro ang doma ganing, “Belag! Magkaning-aning lamang.” Animan dayon ang siminabat tang lali, “Yo ka kaman.” ");
INSERT INTO agn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ganing tang mga taw ang nane-ma, “Angay gaitā ra mandian?” ");
INSERT INTO agn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Siminabat tang lali, “Ang taw ang aggoyan ta Jesus, sinampora na tang olak na ong tanek oman sinampel na ong matao. Pagatapos ganing ong yen, ‘Paninga don ong Siloam ig mandamota.’ Napaningo don ig pagapandamoto, naitao ra ka.” ");
INSERT INTO agn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ganing tanira, “Ong ayra ta tang taw ang asi?” Siminabat tanandia, “Inayo lamang mga ong ayra.” ");
INSERT INTO agn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Oman, dayon ang ingkelan nira tang dating boray don ong mga Pariseo. ");
INSERT INTO agn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tenged asing pagsampora ni Jesus tang olak na may ang tanek, ig pinao-ya na tang boray, Kaldaw ang Igperenay. ");
INSERT INTO agn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Animan mandian ang boray sine-ma si ka tang mga Pariseo mga monopa nago-ya tang mga mata na. Ganing tanandia, “Sinampelan ni Jesus tang matao ta tanek ang sinamporan na tang olak na. Pagatapos nandamoto, ig mandian gaitao ra.” ");
INSERT INTO agn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ang domang mga Pariseo ganing, “Ang taw ang asing si Jesus indi nagalin ong Dios, tenged pagkatalak ong pagpangontra na ong Katobolan mga Kaldaw ang Igperenay!” Piro ganing tang doma, “Angay? Ang taw ang mapinagtalaken mapagboat bato ta mga milagrong maning ta na?” Animan indi tanira namaginigoan. ");
INSERT INTO agn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Animan sine-ma si nirang oman tang dating boray. “Yawa, tenged pinao-yā ono ni Jesus tang mga mata mo, onopay maning mo natetenged ong nandia?” Siminabat tang dating boray, “Tatang propita tanandia.” ");
INSERT INTO agn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Piro indi mamagparet tang mga pangolokolong Judio mga ang taw ang na ay dating boray ig mandian lamang gaita. Animan pinagoy nira tang mga ginikanan na ");
INSERT INTO agn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ig sine-ma, “Na ana mi? Onopa? Matod ang tanandia pinanganang boray ang lagi? Mga maning don, angay gaita ra tanandia mandian?” ");
INSERT INTO agn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Siminabat tang mga ginikanan na, “Ana amen tanandia ig matod ang pagataw na boray ang lagi. ");
INSERT INTO agn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Piro indi ami gatako mga angay gaita ra tanandia mandian, obin mga sinopay nagpao-ya ong nandia. Tanandia kay tang te-maen mi. May idad na ra ig gatako rang magbeg natetenged ong sadili na.” ");
INSERT INTO agn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Maning don tang sabat tang mga ginikanan na tenged geldan tanira ong mga pangolokolong Judio. Tenged namaginigoan dang lagi tang mga pangolokolo nga ang maski sinopay mangilala ong ni Jesus ang tanandia yay ang Cristo, bawalen da nirang ma-pen ong mga masig ka Judio nira maski tenled ong mga simban nira. ");
INSERT INTO agn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yay asia animan minaning tang mga ginikanan na, “Tanandia lamang tang te-maen mi, may idad na ra.” ");
INSERT INTO agn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mandian pinagoy si nirang oman tang dating boray ig minaning ong nandia, “Ala! Pa-dek tang Dios! Magbega ong yamen tang matod natetenged ong taw ang asi, tenged gata-wanan amen ang tanandia tatang mapinagtalaken.” ");
INSERT INTO agn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Siminabat tang taw, “Indio matako mga mapinagtalaken tanandia obin belag. Ang gata-wanano lamang, yo dati borayo, piro mandian gaitao ra.” ");
INSERT INTO agn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pareges pa tang te-ma nirang ganing, “Piro monopa napao-ya na tang mga mata mo? Onopa enged ay bindoat na ong nio?” ");
INSERT INTO agn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Siminabat tang taw, “Bineg amo ra yen, piro indi amo mamasi. Angay galiliag among ibego sing oman ong nindio? Sigoro galiliag amo kang magimong sinagpan na!” ");
INSERT INTO agn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tenged tarin, pisan ang nangasilag tang mga pangolokolo ong dating boray ig ininsolto pa nira ang ganing, “Yawa tang sinagpan na! Yami mga sinagpan ami ni Moises! ");
INSERT INTO agn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Gata-wanan amen ang nagigampang tang Dios ong ni Moises. Piro mga natetenged ong taw ang asi, indi ami gatako mga ong aypa tanandia nagalin.” ");
INSERT INTO agn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Siminabat tang lali, “Sia yay ang makabebereng! Indi amo gatako mga ong aripa tanandia nagalin, maski tanandia tang nagpao-ya ong yen. ");
INSERT INTO agn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Gata-wanan ta ang indi agpama-yan tang Dios tang taw ang mapinagtalaken. Piro agpama-yan na tang taw ang madinioson ig pagtoman ong kaliagan na. ");
INSERT INTO agn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Gata-wanan ta ka, mimpisa pa asing primiro, andang pisan ay taw ang gapagpao-ya ta taw ang boray ang lagi asing pinangana. ");
INSERT INTO agn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mandian, mga ang taw ang asi indi nagalin ong Dios, indi ka rin mapagboat ta maning ta nang bindoat na ong yen!” ");
INSERT INTO agn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Piro siminabat tang mga pangolokolo, “Yawa, mapinagtalakena mimpisang natawa! Yawa ray magtoldok ong yamen?” Oman dayon dang pinalayas nira ig binawal dang tenled ong mga simban nira. ");
INSERT INTO agn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nabalitan ni Jesus ang pinalayas tang mga Pariseo tang boray ang pinao-ya na. Animan dinilem na ig pagatoman na, sine-ma na ang ganing, “Onopa? Yawa pagtoa ong Ana ta Taw?” ");
INSERT INTO agn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ganing tang laling siminabat, “Sinopa tanandia, Magino? Ibeg mo kay ong yen, agod magtō ong nandia.” ");
INSERT INTO agn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ganing si Jesus, “Inita mo ra. Yo mismo, ang pagigampang ong nio, yay ang tanandia.” ");
INSERT INTO agn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ig dayon ang laging minaning tang lali, “Pagtō ong nio, Gino!” Oman dayon ang liminod ig nagdayaw ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ganing pa si Jesus, “Napaningo tarin ong kalibotan para osisaen ig osgaran tang mga taw, agod ang mga boray mangaita, ig ang mga gangaita, tanira yay si ang lomboang boray.” ");
INSERT INTO agn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mandian may mga Pariseo don ang alenget ang nangabasi tang binitala ni Jesus. Ganing tanira, “Angay? Maliag mong yaning asta yami boray ami ka?” ");
INSERT INTO agn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Siminabat si Jesus, “Mga yamo boray ka rin, poidi pang patawaden tang mga talak mi ig anday sarabaten mi. Piro tenged ganing amo ang gangaita amo, sia tang pagpamatod ang may talak mi pa ka enged.” ");
INSERT INTO agn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ganing pa si Jesus ong tatang palimbawa, “Agganingo ong nindio, ang sinopay tenled ong kolongan tang mga karniro ang indi pagpanaw ong portan na, kondi kaka-yat ong belag ta dapat ang palanawan na, ang taw ang asi traidor ig takawan. ");
INSERT INTO agn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Piro ang pagpanaw ong portan tang kodal yay ang manigbadbad tang mga karniro. ");
INSERT INTO agn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Agpa-leden tanandia tang goardia ong portan, ig ang mga karniro pamamasi ong nandia. Aggoyan na tang mga karniro na ong mga aran nira ig aggekelan na ong loa. ");
INSERT INTO agn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mga mapaloa na ra nganing tanan, to-kaw tanandia ong nira ig ang mga karniro pamansidaton ong nandia tenged gailala nira tang bosis na. ");
INSERT INTO agn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Piro indi tanira mamansidaton ong taw ang indi gailala nira. Mamagsinikad pa tanirang palawid, tenged indi gailala nira tang bosis na.” ");
INSERT INTO agn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ginamit ni Jesus tang palimbawang na, piro indi naintindian tang pamamasi tang maliag nang yaning. ");
INSERT INTO agn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Animan nagtorol si Jesus ta tata sing palimbawa ang ganing, “Yo tang pagsirbing portan tang kodal agod ma-led tang yen ang mga karniro. ");
INSERT INTO agn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ang mga manigtoldok ang nanga-kaw ang kiminabot ong yen, ang kalimbawan nira mga traidor ig takawan, piro ang mga karniro indi namamasi ong nira. ");
INSERT INTO agn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yo tang portan. Maliag yaning, ang sinopay lemenget ong yen para ma-led ay malibri. Pario ra tanandia ong tatang karniro ang te-led ig loloa ig gaita ta mapamanganan na. ");
INSERT INTO agn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ang takawan te-led ong kodal tang karniro para lamang manakaw, mamatay, ig manlangga. Piro yo, napaningo tarin para oldan tang mga karniro ta kaboing masinlo ig anda enged ay korang na. ");
INSERT INTO agn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Yo tang mo-yang manigbadbad tang mga karniro. Ang mo-yang manigbadbad listong mapatay para tomabang ong mga karniro na. ");
INSERT INTO agn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Piro ang taw ang agsolan lamang ang pamadbad tang mga karniro, maita ngani ta kirong boang ang gingabot, dayon ang laging bo-wanan na tang mga karniro ig magsinikad. Tenged belag ta tanandia tang matod ang manigbadbad ig belag ta nandia tang mga karniro. Oman dayon dang rotoson tang kirong boang tang mga karniro ig mamagwasag ang tanan. ");
INSERT INTO agn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ang taw ang asi magsinikad tenged agsolan lamang, animan baliwala ong nandia maski onopay mainabo ong mga karniro. ");
INSERT INTO agn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Piro yo tang mo-yang manigbadbad. Gailalao tang yen ang mga karniro, ig tanira gangailala ka ong yen. ");
INSERT INTO agn_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Pario tang Dios ang Tatayo gailala ong yen, ig yo gailalao ong nandia. Ig yo, listōng magbolontad tang kaboio para ong yen ang mga karniro. ");
INSERT INTO agn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","May doma pang karnirō ang anda pa ong teled tang kodal ang na. Kaministiran pa-ledeno ka tanira. Mamamasi ka tanira ong yen, ig ong maning don, ang tanan ang pamamasi ong yen magimong tang paneng da lamang ang may tatang manigbadbad ong nira. ");
INSERT INTO agn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Animan ang Tatayo paggegma ong yen tenged agbobolontado tang yen ang kaboi agod maboio sing moman. ");
INSERT INTO agn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Anday mapagpatay ong yen mga belag ta kaliagano, kondi bolontad ang to-dolo tang yen ang kaboi. May gaemo ang i-dolo tang kaboio ig may gaemo kang bawieno. Yay na tang tobol tang Tatayo ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tenged ong mga binitalang na ni Jesus, indi si mamaginigoan tang mga pangolokolong Judio. ");
INSERT INTO agn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yadi ong nira tang ganing, “Sinled ta dimonio tang taw ang na, animan gabeyeg da! Angay pamamasi amo pa ong nandia?” ");
INSERT INTO agn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Piro ang doma ganing ka, “Ang taw ang sinled ta dimonio indi mapagbitala ta maning atan ang kasinlo. Ang mga dimonio indi enged mapagpao-ya ta boray!” ");
INSERT INTO agn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mandian, timpo rang taglalamig ig pista ra ong Jerusalem, pista tang pagdemdem ong pagbindision tang Timplo tang Dios asing tokaw. ");
INSERT INTO agn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ang oras ang asi pagpanaw-panaw si Jesus don ong solar tang Timplo, don ong logar ang aggoyan ta Balkon ni Solomon. ");
INSERT INTO agn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Maboay-boay ta ge-ley, pinalibotan tanandia tang mga Judio ig ganing tanira ang nane-ma, “Angay pagtalok-taloka pa enged ong yamen mga sinoapa? Mga yawa tang Cristo, magbega ta osto.” ");
INSERT INTO agn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Siminabat si Jesus, “Bineg amo ra yen, piro indi amo ka mamagparet. Ang mga milagrong agboateno ong gaem tang Tatayo, yay ang pagpamatod ong sadilio. ");
INSERT INTO agn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Piro indi amo mamagparet ong yen, tenged belag amo ta kabilang ong yen ang mga karniro. ");
INSERT INTO agn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ang yen ang mga karniro pamamasi ong yen. Gailalao ong nira ig tanira pamagosoy ong yen. ");
INSERT INTO agn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Agtoldano tanira ta kaboing anday kataposan, animan indi enged tanira malbag ong Dios para silotan asta ong tanopa; indi tanira makalaw ong yen ta maski sinopa. ");
INSERT INTO agn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ang Tatayo tang nagtorol ong nira ong yen, ig tanandia makagagaem ong tanan. Animan anda enged ay mapagkalaw ong nira ong kalima na. ");
INSERT INTO agn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yo ig ang Tatay tata lamang.” ");
INSERT INTO agn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pagabasi ta na tang mga Judio, dayon sing namamisik ta mga bato para banggilen nira si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Piro ganing si Jesus ong nira, “Yadi rang mga mo-yang boat ang nagalin ong Tatay tang pinaitao ong nindio. Ong aypa don ong mga bindoatong asi tang dailan ang angay banggileno nindio?” ");
INSERT INTO agn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Sinabat tanandia tang mga Judio, “Belag tang maning ong mga mo-yang boat mo ang yawa banggilena yamen, kondi tenged yawa tawa ka lamang, piro pangamboa ang yawa Dios! Dorog kabelat tang kasalanan ang na!” ");
INSERT INTO agn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Siminabat si Jesus, “Ga-tang ong Katobolan mi mismo tang inaning tang Dios ang ganing, ‘Yamo mga dios.’ ");
INSERT INTO agn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ig gata-wanan ta kang maski onopay ga-tang ong Kasolatan, sia matod enged asta ong tanopa. Animan mandian, mga ‘dios’ tang goy tang Katobolan ong mga taw ang sindolan tang bitala tang Dios asing tokaw, ");
INSERT INTO agn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","monopa maning ming yo pagkatalako kontra ong Dios ong paganingo ang yo tang Ana tang Dios? Yo tang mismong pinilik ig sinobol tang Tatay tarin ong kalibotan. ");
INSERT INTO agn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mga indi agboateno tang agpaboat tang Tatayo ong yen, maski indi amo magparet ong yen. ");
INSERT INTO agn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Piro ong matod, yay ang agboateno, agod maski indi amo maliag ang magparet ong yen, kaministiran pa ka enged ang magparet amo ong mga agboateno. Ong maning don, mata-wanan ming ang Dios ang Tatay nani ong yen ig yo ong nandia.” ");
INSERT INTO agn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tenged tarin, namagprosigir tanirang oman ang depen din si Jesus, piro napalipat tanandia ong nira. ");
INSERT INTO agn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Pagatapos ta si, limina-ted ang oman si Jesus ong soba tang Jordan, don ong logar ang pinagboniagan ni Juan tanopa sia. Ig don tanandia nagtinir. ");
INSERT INTO agn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Dorong mga taw ang pamansipaning don ong nandia. Ganing tanira. “Si Juan anday bindoat nang mga milagro, piro ang tanan ang inaning na natetenged ong taw ang na matod ang enged.” ");
INSERT INTO agn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Animan yading mga taw don tang namagto ra ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","May tatang taw ang aran na si Lazaro. Gistar tanandia ong bario tang Betania, sakep tang probinsia tang Judea, aroman tang mga logod nang da Maria ni Marta. (Ang Mariang narin ong ori yay ang nagbo-bok ta pabanglo ong kakay ni Ginong Jesus oman tinrapoan na tang boa na.) Mandian, pagmasit si Lazaro. ");
INSERT INTO agn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Animan nagpatobol tang maglogod ong ni Jesus ang ganing, “Gino, ang agmalen mong tangay pagmasit.” ");
INSERT INTO agn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Piro asing pagabasi ni Jesus ganing tanandia, “Ang masit ang asi belag ta kamatayen tang tegkan na. Nainabo na agod itaen tang gaem tang Dios ig ong maning don dayawen tanandia asta yo, ang Ana na, dayawen ka.” ");
INSERT INTO agn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Agmalen ta mo-ya ni Jesus tang mamaglogod ang da Marta, Maria ig Lazaro. ");
INSERT INTO agn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Piro pagatako nang pagmasit si Lazaro, pinata-lib na pa tang doroang kaldaw, ");
INSERT INTO agn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ba-lo minaning ong mga sinagpan na, “Maytara, magbalik ita don ong Judea.” ");
INSERT INTO agn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ganing tang mga sinagpan nang siminabat, “Maistro, tanopa sia ka lamang ang banggilena ra rin tang mga Judio don! Mandian magbalika si don?” ");
INSERT INTO agn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Siminabat si Jesus, “Anday kaso sia. Gata-wanan mi ka, tampolok may doroang oras tang magapon. Indi matampok tang papanaw mga may kaldaw pa, tenged mayag pa. ");
INSERT INTO agn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Piro mga magpanaw tanandiang labi ra, matampok enged tenged anda ray kaldaw.” ");
INSERT INTO agn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Oman ganing pa si Jesus, “Gapoyat tang tangay tang si Lazaro. Paningano don agod poaweno.” ");
INSERT INTO agn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Siminabat tang mga sinagpan na, “Gino, mga gapoyat tanandia, maliag yaning mago-ya ra.” ");
INSERT INTO agn_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ang kalaom nira gapoyat lamang si Lazaro, piro ang maliag yaning ni Jesus patay da. ");
INSERT INTO agn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Animan bineg da ni Jesus ong nira ta osto, “Si Lazaro patay da, ");
INSERT INTO agn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","piro mo-ya lamang andao don asing pagapatay na, agod mas mamoirsa pa tang pagtalig mi ong yen. Na para ka ong ikakao-ya mi. Ta ra! Paningan ta si Lazaro.” ");
INSERT INTO agn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ig si Tomas ang aggoyan ta Kambal ganing ka ong mga karomanan na, “Ala, tomabid ita agod mapatay ita ka ang aroman na.” ");
INSERT INTO agn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pagakabot da Jesus ong Betania, nabalitan nirang epat dang kaldaw ang limbeng si Lazaro. ");
INSERT INTO agn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mga tolong kilomitro lamang tang kalawid tang Jerusalem ong Betania. ");
INSERT INTO agn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Animan dorong mga Judio ang taga Jerusalem tang namamisita ong da Marta ni Maria para lipayen tanira. ");
INSERT INTO agn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Asing mabalitan ni Marta ang kakabot da si Jesus, binagat nang lagi, piro si Maria napabo-wan ong balay. ");
INSERT INTO agn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ganing si Marta ong ni Jesus, “Gino, mga tarina lamang, indi rin napatay tang logod amen. ");
INSERT INTO agn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Piro gata-wanano ang maski mandian, mga onopay pa-dolon mo ong Dios, boaten na para ong nio.” ");
INSERT INTO agn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ganing si Jesus ang siminabat, “Maboing oman tang logod mi.” ");
INSERT INTO agn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Siminabat ka si Marta, “Gata-wanano ang maboi tanandia ong oring kaldaw, mga boien ang moman tang mga patay.” ");
INSERT INTO agn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ganing si Jesus, “Yo tang pagboi ong mga patay ig yo tang pagtorol ta kaboi. Ang pagto ong yen, maski mapatay, maboi tanandiang moman. ");
INSERT INTO agn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ig ang sinopay gaboi ang pagto ong yen indi enged mapatay asta ong tanopa. Onopa? Pagpareta ta na?” ");
INSERT INTO agn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ganing si Marta, “Ee, pagpareto, Gino! Pagpareto ra ang yawa tang Cristo, ang Ana tang Dios, ang aggelaten amen ang komabot ong kalibotan.” ");
INSERT INTO agn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pagabitala ta si ni Marta, dayon da tanandiang minolik. Ginoyan na si Maria ig liminalat ang ganing, “Asia ra tang Maistro, agpagoya nandia.” ");
INSERT INTO agn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagabasi ni Maria, dali-daling kimindeng ig napaning don ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Si Jesus indi pa ga-led ong bario, don pa tanandia ong logar ang don binagat tanandia ni Marta. ");
INSERT INTO agn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Namansidaton ong ni Maria tang mga bisita nirang Judio ang pamaglipay ong nira, tenged asing pagaita nira ong nandiang nagdali-daling kimindeng ang nagalin ong balay, ang kalaom nira paning ong lebengan ni Lazaro para magini-yak don. ");
INSERT INTO agn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pagakabot ni Maria ong ni Jesus, liminod tanandia ong kakayan na ig minaning, “Gino, mga tarina lamang, indi ka rin napatay tang logod amen.” ");
INSERT INTO agn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pagaita ni Jesus ang pagini-yak si Maria asta ang mga Judiong aroman na, nagsinti tanandia ta mo-ya ig dorog kabelat tang nem na. ");
INSERT INTO agn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Oman ganing si Jesus, “Ong aripa limbeng mi si Lazaro?” Ganing tanira, “Gino, maytara! Aromanana yamen.” ");
INSERT INTO agn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ig nagini-yak si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Animan ganing tang mga Judio, “Telekan mi, pisan kaman agmalen na si Lazaro.” ");
INSERT INTO agn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Piro ang domang mga Judio don ganing, “Napao-ya na tang taw ang boray, angay bato indi inawidan na tang kamatayen ni Lazaro?” ");
INSERT INTO agn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Doro sing pagsinti ni Jesus pagakabot na ong lebengan ni Lazaro. Ang lebengan ang na tatang koiba ang anga na agdapan ta bato. ");
INSERT INTO agn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ganing si Jesus ong nira, “Komiten mi ra tang batong agdadapa.” Piro ganing si Marta, “Gino, sia epat dang kaldaw ang limbeng, mandian makalpot da.” ");
INSERT INTO agn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ganing si Jesus ang siminabat, “Demdemen mo tang inaningo ong nio, Marta. Mga magtaliga ong yen, itaen mo tang gaem tang Dios.” ");
INSERT INTO agn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Oman pinaigod da nira tang bato. Dayon ang siminingara si Jesus ong langit ig minaning, “Tatayo, pagpasalamato ong nio, tenged pinama-yano nio. ");
INSERT INTO agn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Gata-wanano ang pirmiong agpama-yan mo, piro na agganingo mandian para ba-yen tang mga taw ang nani ong paliboto, agod mamagparet tanira ang yawa tang nanobol ong yen tarin ong kalibotan.” ");
INSERT INTO agn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pagabitala na ta si, dayon ang miniteg ta mapoirsa ang ganing, “Lazaro, lomboā atan!” ");
INSERT INTO agn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Limindoa ka kaman si Lazaro. Ang mga kakay na ig kalima na agtabed-tabedan pa tang abel ang panlebeng, asta ang emet na agbongoton ta mala-bang ang ta-leng. Oman ganing si Jesus ong nira, “Obadan mi tanandia agod mapanaw.” ");
INSERT INTO agn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yadi ong mga Judiong namamisita ong da Maria tang namagto ra ong ni Jesus pagaita nira ong bindoat na. ");
INSERT INTO agn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Piro ang doma, pagapagalin nira ong da Maria, don namagdiritso ong mga Pariseo ig bineg nira tang bindoat ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Animan ang mga Pariseo ig ang mga pangolokolong padi nagpagoy tang tanan ang mga opisialis tang banoa. Ganing tanira, “Onoray boaten ta? Doro rang makabebereng ang mga bagay ang bindoat tang taw ang na! ");
INSERT INTO agn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mga pabayan ta ra lamang tanandia, itaben ang tanan ang kasimanoa ta mamagto ra ong nandia. Oman ang mainabo, papaningen tarin tang adi tang Roma tang mga sondalo na. Langgaen nira tang Timplo ta asta ang bilog ang nasion ta!” ");
INSERT INTO agn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mandian, tata ka ong napasakep don si Caifas. Tanandia tang kalawigan ang pangolokolo ong mga padi asing takon ang asi, ig ganing ong nira, “Indi amo pa pamagisip? ");
INSERT INTO agn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mas mo-ya para ong yaten mga tanga tawan lamang tang mapatay, kaysa ang bilog ang nasion.” ");
INSERT INTO agn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ang binitala nang na indi nagalin ong sadiling kinaisipan na lamang. Sia, bilang kalawigan ang padi, pinabitala tanandia tang Dios mismo ig ang maliag yaning mapatay si Jesus para ong kasimanoa nang mga Judio. ");
INSERT INTO agn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ig belag lamang ta para ong nira, kondi para ong tanan ang mga ana tang Dios ang gingistar ong sari-saring banoa ong kalibotan, agod boaten tanira ang magimong tatang pamilia. ");
INSERT INTO agn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Impisa don, ang mga pangolokolo ong mga Judio pamagdilem da ta midios mga monopa ipapatay nira si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Animan indi ra naglinibot-libot si Jesus ong Judea. Ang bindoat na, nagalin tanandia don ig napaning ong bario tang Efraim, don alenget ong logar ang anday gistar ang taw. Ig don tanandia nagtinir aroman na tang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mandian, galenget da tang Pista tang Pagta-lib tang Anghil. Animan yadi rang mga taw ang namagalin ong mga kababarioan ang namansipaning ong Jerusalem agod ba-lo komabot tang pista, mapamanlimpio ra tanira tang sadili nira sigon ong kaogalian tang rilihion nira. ");
INSERT INTO agn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dinilem nira si Jesus don, piro indi inita nira. Animan mintras pamagsirimet-simet tanira ong Timplo, pamagtere-ma te-man tanira ang ganing, “Onopa bato, paning pa tanandia mandian ang pista obin indi?” ");
INSERT INTO agn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pamagtere-ma te-man tanira tenged gangatako rang lagi ang nagordin da tang mga pangolokolong padi ig ang mga Pariseo nga ang maski sinopay gatako mga ong aripa si Jesus, dapat ang magbeg ong nira agod ipadep nira tanandia. ");
INSERT INTO agn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mandian, enem da lamang kaldaw ba-lo komabot tang Pista tang Pagta-lib tang Anghil. Si Jesus napaning si ong Betania, don ong logar ni Lazaro, ang taw ang binoi nang oman. ");
INSERT INTO agn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sinimpanan tanandia don ta kombida. Si Lazaro tata ka ong mga aroman ni Jesus ang pamamangan, ig si Marta tang manigsirbi ong nira. ");
INSERT INTO agn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mandian, nangomit si Maria ta tengang litrong pabanglo ang aggoyan ta nardo. Ang pabanglong na andang pisan ay sampora na ig kamal-malan. Na dayon ang bino-bok ni Maria ong kakay ni Jesus. Pagatapos, tinrapoan na tang boa na. Ig minongaw ta pabanglo tang bilog ang balay. ");
INSERT INTO agn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ang tata ong mga sinagpan don ay si Judas Iscariote ang yay magtraidor ong ni Jesus ong ori. ");
INSERT INTO agn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ganing si Judas, “Aroy! Angay indi lamang pinabakal tang pabanglong asia? Ang bayad na kapario ra tang sol ta tang taw ong teled ta magpatakon ig sia malimos pa rin ong mga malilised.” ");
INSERT INTO agn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Belag tang maning gate-bek si Judas ong mga malilised animan inaning na si, kondi ong kamatodan takawan tanandia. Tanandia tang manigbiot tang koarta nira ig pirming agkomit-komitan na. ");
INSERT INTO agn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mandian ganing si Jesus, “Angay pagpalabet amo ong ni Maria? Pabayan mi lamang ang gamiten na tang pabanglo na. Sinalok na para ibanios na ong sinangonio mga ilbengo ra. ");
INSERT INTO agn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ang mga malilised pirming ka-pen mi ig poidi pang matabangan mi. Piro yo, indio ra maka-pen mi ong maboay ang timpo.” ");
INSERT INTO agn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ang oras ang asi yading mga Judio tang nangabalita ang si Jesus don ong Betania. Namansipaning tanira don belag lamang ta tenged ong nandia, kondi gangaliliag kang itaen nira si Lazaro ang binoi nang oman. ");
INSERT INTO agn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Animan ang mga pangolokolo ong mga padi namagplano ang patayen nira asta si Lazaro. ");
INSERT INTO agn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Komo natetenged ong ni Lazaro, yadi rang mga masig ka Judio nira tang namampabelag da ig pamagto ra ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pagaramal, nangabalita tang dorong mga taw ang pamamista ang si Jesus komabot da ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Animan namangomit tanira ta mga paloa ta nioy ig namansipanaw da tanira para bagaten nira si Jesus. Ganing tanira ang pamansiteg, “Hosanna! Aloyan ang enged tang Dios tang sinobol na ang kiminabot mandian! Dayawen tang Adi tang Israel!” ");
INSERT INTO agn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","May inita ni Jesus ang tatang asno ang mola pa, ig yay ang sinayan na. Ang bindoat nang na, pario enged tang na-tang dang lagi ong Kasolatan ang ganing: ");
INSERT INTO agn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Indi amo meled, yamong mga taga Sion! Telekan mi! Narin da tang adi ming kakabot, ang pagtay ta tatang asnong mola pa!” ");
INSERT INTO agn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ang oras ang asi, indi pa gaintindian tang mga sinagpan ni Jesus tang mga gangainabong na. Piro pagatapos ang si Jesus naboing oman ig ingkelan ong langit, ba-lo nademdeman nira nga ang mga bagay ang na na-tang dang lagi ong Kasolatan natetenged ong ni Jesus, ig ya enged kaman tang nainabo ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mandian, ang mga taw ang nangaita ong paggoy ig pagboi ni Jesus ong ni Lazaro don ong lebengan, sigi lamang tang balita nira natetenged ong inita nirang asi. ");
INSERT INTO agn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yay sia animan si Jesus binagat ta kadoro-doroan ang mga taw, tenged nabalitan dang lagi nira tang bindoat nang asing milagro. ");
INSERT INTO agn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ig tenged tarin namagampang-ampang tang mga Pariseo ang ganing, “Ta, mandian telekan mi! Ang mga taw pamagosoy dang tanan ong nandia! Anda ray maimo ta!” ");
INSERT INTO agn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","May mga Grigo kang namansipaning ong pista para magsimba ong Timplo. ");
INSERT INTO agn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Namansipalenget tanira ong ni Felipe ang taga Betsaida, ang sakep tang probinsia tang Galilea. Ganing tanira, “Magino, galiliag ami rin ang magigbagat ong ni Jesus.” ");
INSERT INTO agn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Bineg narin ni Felipe ong ni Andres, ig namansipalenget tanirang doroa ong ni Jesus para ipatako ang agdilemen tanandia tang mga taw ang asi. ");
INSERT INTO agn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ganing si Jesus ong nira, “Kiminabot da tang oras, ig itaen da tang makabebereng ang dengeg tang Ana ta Taw! ");
INSERT INTO agn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ang kalimbawano midio tang legat ang trigo. Ong matod, ang binik mga indi iloak ong tanek, indi lomongay ig indi ka mamorak. Narin tegka ka enged lamang ong tang legat. Piro mga maloak da ngani, midio mapatay tenged lengkag. Ig pagatapos, lomongay da ig mamorak ta kadoro-doroan pang mga binik. ");
INSERT INTO agn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ang taw ang agpalabien na tang kaboi na tarin ong ta-paw tang kalibotan, tanandia tang malipatan tang kaboi na. Piro ang taw ang indi palabien na tang kaboi na tarin ong kalibotan, tanandia tang marisibi ta kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ang maski sinopay galiag ang magsirbi ong yen, kaministiran ang magosoy ong yen agod maski ong ariopa, don ka tanandia. Ig ang taw ang magsirbi ong yen dayawen ang enged tang Tatayo.” ");
INSERT INTO agn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Pagatapos, ganing si Jesus, “Mandian gaborido ra tang isipo. Mga maimo lamang, pa-dolono rin ong Tatayo ang ilibrio nandia ong kaliwagan ang nang agtalongaeno. Piro indi poidi! Tenged napaningo tarin ong kalibotan para mapasarano tang kaliwagan ang na.” ");
INSERT INTO agn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Oman minaning tanandia, “Tatayo, ipaita mo kay tang gaem mo agod dayawen tang aran mo.” Yay asi may naba-yan ang tatang bosis ang nagalin ong langit ang ganing, “Pinaitao ra, ig ipaitao pang oman.” ");
INSERT INTO agn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Naba-yan tang kadoro-doroan ang mga taw don tang bosis ang narin animan ganing tanira, “Dodoldol!” Ang doma ganing, “May anghil ang pagigampang ong nandia!” ");
INSERT INTO agn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Piro ganing si Jesus ong nira, “Ang bosis ang asia pinabasi tang Dios belag ta para ong yen. Sia para ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kiminabot da tang oras ang osgaran da tang tanan ang taw ang indi pangilala ong yen, ig pirdien da si Satanas ang yay ang paggaem tarin ong kalibotan ang na. ");
INSERT INTO agn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ig yo, mga ipalawigo ra ngani ong kros, palengeteno tang tanan ang taw ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Inaning narin ni Jesus para ipatako na mga monopa tanandia mapatay. ");
INSERT INTO agn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Piro siminabat tang mga taw, “Onora ka? Sigon ong Kasolatan, ang Cristo anday kamatayen na! Angay ganinga ang Ana ta Taw kaministiran mapatay? Sinopa enged sing agsambiten mong Ana ta Taw?” ");
INSERT INTO agn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ganing si Jesus ong nira, “Indi ra lamang maboay malipat da ong nindio tang tolok. Animan osoyon mi tang tamang dalan mintras tarin pa ong nindio tang tolok agod indi amo kabotan tang maki-lep. Tenged ang papanaw ong maki-lep, indi matako ta paningan na. ");
INSERT INTO agn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Animan mintras aroman mi pa tang tolok, mamagtalig amo ong tolok agod magimo among mga taw ang gistar da ong sinag tang tolok.” Pagabitala ni Jesus ta si, nagalin da tanandia don ig nantalok. ");
INSERT INTO agn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Maski yadi rang mga makabebereng ang bagay ang inita tang mga Judio ong ni Jesus, indi pa ka enged tanira mamagto ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Indi tanira namagto agod magmatod tang inaning tang propitang si Isaias asing tokaw pa ang ganing, “Gino, sinopa lamay nagparet tang binalita amen? Maski pinaita mo ra ong nira tang gaem mo, indi pa enged tanira mamagto ong nio.” ");
INSERT INTO agn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pario tang inaning pa ni Isaias, indi tanira mamagto tenged: ");
INSERT INTO agn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Binoray tanira tang Dios ig pinategat na tang kolo nira, agod indi tanira mangaita ig indi tanira mangaintindi, itaben magbalik pa tang nem nira ong Dios agod pao-yaen na tanira.” ");
INSERT INTO agn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ang mga bitala ang narin, binitala ni Isaias natetenged ong ni Jesus, tenged asing tokaw pa, inita na rang lagi tang gaem ig pagkadios na. ");
INSERT INTO agn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Piro maski maning don tang binitala ni Isaias, may atan pa ka enged ang namagto ong ni Jesus, asta ang mga pangolokolong Judio yadi kang namagto. Piro indi agbebeg nira maski ong ninopa ang pamagto tanira ong ni Jesus, itaben palayasen tanira ong mga simban nira. ");
INSERT INTO agn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tenged mas agpalabien pa nirang dayawen tanira ta taw kaysa ang Dios tang magdayaw ong nira. ");
INSERT INTO agn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pagatapos, minitala si Jesus ta mapoirsa ang ganing, “Mga ang tatang taw pagto ong yen, belag lamang ta yo tang agtowan na, kondi asta ang nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ig ang naita ong yen, naita ra ka ong nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yo, napaningo tarin bilang tolok para ong kalibotan, agod ang mamagto ong yen indi ra mangabo-wan ong maki-lep. ");
INSERT INTO agn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mga may taw ang nabasi tang mga toldoko piro indi ka agtomanen na, belag ta yo tang magosgar ong nandia. Tenged indio napaning tarin ong kalibotan para sintinsian tang mga taw. Napaningo ta para ilibri tanira ong silot ang para ong mga kasalanan. ");
INSERT INTO agn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Piro may atan enged ang magosgar ong mga taw ang indi mangilala ong yen ig indi ka magtoman ong yen mga bitala; ang mga bitalang nang mismong sinoldoko yay ang magosgar ong nira ong oring kaldaw. ");
INSERT INTO agn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tenged indio bibitala ong yen ang sadiling kaliagan. Ang Dios ang Tatay ang nanobol ong yen yay ang pagtoldok ong yen tang onopay ibitalao ig itoldoko. ");
INSERT INTO agn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ig gata-wananong ang mga bitala na pagtorol tang kaboing anday kataposan. Animan ang tanan ang agganing tang Tatay ong yen ya kay ang agganingo ong nindio.” ");
INSERT INTO agn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mandian galenget da tang Pista tang Pagta-lib tang Anghil. Gata-wanan ni Jesus ang kiminabot da tang oras ang magalin da tanandia ong kalibotan ang na agod magbalik da ong Tatay na ong langit. Impisa ong primiro ginegman nang pisan tang mga sinagpan na tarin ong kalibotan, ig mandian pinaita na ra mga monopag kabael tang pagmal na ong nira. ");
INSERT INTO agn_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ang labing asi, pamanapon da Jesus aroman na tang mga sinagpan na. Si Judas, ang ana ni Simon Iscariote, pinaisip dang lagi ni Satanas ang traidoron na si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Mandian, gata-wanan ni Jesus ang sindol da ong nandia tang Dios ang Tatay tang tanan ang gaem. Ig gata-wanan na kang nagalin tanandia ong Dios ig ong Dios ka magbalik. ");
INSERT INTO agn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Animan asing pamanapon tanira, dayon ang kimindeng si Jesus, oman nagloat tang lambong nang panta-paw ig nangampit ta toalia ong awa na. ");
INSERT INTO agn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nagtayon tanandia ta wi ong planggana, ig nagimpisang nagogat tang mga kakay tang mga sinagpan na. Kada maogatan na, agtrapoan na tang toaliang aggampiten na ong awa na. ");
INSERT INTO agn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pagalenget ni Jesus ong ni Simon Pedro, ganing si Pedro, “Gino, angay yawa ray magogat tang kakayo?” ");
INSERT INTO agn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Siminabat si Jesus, “India pa gaintindi mandian tang agboateno, piro maintindian mo ka enged may pirapang kaldaw.” ");
INSERT INTO agn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ganing ong nandia si Pedro, “India ka enged papagogaten ta tang kakayo!” Piro ganing si Jesus, “Mga india magpaogat tang kakay mo ong yen, maliag yaning india enged ma-pen ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Animan ganing si Pedro, “Gino, mga maning atan, belag lamang tang kakayo tang ogatan mo, asta ra ka ang kalimao may ang kolō!” ");
INSERT INTO agn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Siminabat si Jesus, “Ang napandigo ra, limpio ra tang bilog ang sinangoni na, ig anda ray kaministiran ang ogatan poira lamang ong kakay na. Limpio amo ra, piro belag ta yamong tanan.” ");
INSERT INTO agn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Minaning si Jesus ang belag ta limpio tanirang tanan tenged gata-wanan na rang lagi mga sinopa tang magtraidor ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pagapagogat ni Jesus tang mga kakay nira, nagtok sing oman tang lambong na ig nagbalik ong lamisan. Ganing tanandia ong mga sinagpan na, “Onopa? Gaintindian mi mga onopay maliag yaning tang bindoatong na ong nindio? ");
INSERT INTO agn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Aggoyano nindio ta Maistro ig Gino, ig tama amo, tenged yo Maistro ig Gino mi ka kaman. ");
INSERT INTO agn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mandian, mga yo, ang Maistro mi ig Gino, nagogat tang kakay mi, dapat mamagogat amo ka tang kakay tang kada tata may tata. ");
INSERT INTO agn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Bindoato narin bilang alimbawa agod sia tang patoladan mi. ");
INSERT INTO agn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Agganingo ong nindio, anday torobolon ang mas alawig ong agalen na, ig anda kay sinobol ang alawig ong nanobol ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mandian gaintindian mi ra tang mga bagay ang na, animan mga boaten mi, masoirti amo. ");
INSERT INTO agn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Belag ta yamong tanan tang agganingeno, tenged gailalao tang tanan ang mga piniliko. Ig kaministiran mainabo tang na-tang ong Kasolatan ang ganing, ‘Ang taw ang sasaro ong yen yay ang magtraidor ong yen.’ ");
INSERT INTO agn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Narin agbebego ra mandian ong nindio mintras indi pa gainabo, agod mga mainabo ra, mamagparet amo ang yo yay ang Cristo. ");
INSERT INTO agn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tandan mi na: Ang magrisibi ong maski sinopang agtobolono, pagrisibi ka ong yen. Ig ang pagrisibi ong yen, sia pagrisibi ka ong nanobol ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pagatapos ang minitala si Jesus, nagsinti tanandia ta mo-ya, ig nagbeg da ta osto ong mga sinagpan na ang ganing, “Ong matod, traidorono tang tata ong nindio.” ");
INSERT INTO agn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Namagpina-dekan da lamang tang mga sinagpan ni Jesus ang pamagisip, tenged indi gangatako mga sinopa ong nira tang agganingen na. ");
INSERT INTO agn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mandian, ang katepad ni Jesus don ang pamangan ay ang sinagpan nang agmalen na ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sininiasan narin ni Simon Pedro ang ganing, “Te-maen mo mga sinopay agganingen na.” ");
INSERT INTO agn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Animan siminandig tang tatang sinagpan ang asi ong debdeb ni Jesus ig nane-ma, “Gino, sinopa tang magtraidor ang asi ong nio?” ");
INSERT INTO agn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Siminabat si Jesus, “Ite-meo tang tinapay ang na ong mangkok, ig ang dawatano yay ang magtraidor ong yen.” Pagate-me na tang tinapay, dayon ang dinawat na ong ni Judas, ang ana ni Simon Iscariote. ");
INSERT INTO agn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pagarisibi ni Judas tang tinapay, ya ray asi sinled da tanandia ni Satanas. Ig minaning si Jesus ong ni Judas, “Ala, boaten mo rang lagi tang boaten mo.” ");
INSERT INTO agn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Piro maski tata ong mga aroman nira ang pamangan, indi gatako mga angay maning ta si tang inaning ni Jesus ong ni Judas. ");
INSERT INTO agn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Si Judas tang manigbiot tang koarta nira, animan ang kalaom tang doma ong nira, agpapamakalen tanandia ni Jesus ta kaministiran pa nira ong pista, obin sigoro papaglimoson na ong mga pobri. ");
INSERT INTO agn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ig pagapamangan ni Judas tang tinapay, dayon da tanandiang nagalin. Labi ra asing oras ang asi. ");
INSERT INTO agn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pagapagalin ni Judas, ganing si Jesus, “Indi ra lamang maboay, yo, ang Ana ta Taw, padengegan ong mainabo ong yen. Ig tenged ong yen, ang Dios padengegan ka. ");
INSERT INTO agn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ig mga ang Dios padengegan tenged ong yen, yo padengegano ka nandia. Ig narin boaten nang lagi. ");
INSERT INTO agn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mga anao, indi ra lamang maboay tang pagtarabidan ta. Dilemeno nindio piro pario tang inaningo ong mga pangolokolong Judio, sia tang agganingo ra ong nindio mandian: indi amo mapaning ong paningano. ");
INSERT INTO agn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Animan mandian may ba-long tobol ang agto-dolo ong nindio ig yay na: Mamaggeregman amo. Mga monopa tang paggegmao ong nindio, dapat maning ka ta si tang paggegma mi ong kada tata may tata. ");
INSERT INTO agn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mga mamaggeregman amo, asia mata-wanan tang tanan ang yamo mga sinagpano.” ");
INSERT INTO agn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ganing si Simon Pedro, “Gino, ong ariapa paning?” Siminabat si Jesus, “Mandian india pa matabid ong paningano, piro ong ori domatona ka ong yen don.” ");
INSERT INTO agn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piro ganing pa si Pedro, “Gino, angay indio pa matabid ong nio mandian? Listō kang magbolontad tang kaboio para ong nio!” ");
INSERT INTO agn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Siminabat si Jesus, “Onopa, listoang enged ang mapatay para ong yen? Tandan mo na, Pedro: Ba-lo manolōk tang mano mandian ang garamal, ma-long bisisang magbo-li ang maning india gailala ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Oman, ganing si Jesus ong mga sinagpan na, “Indi amo magpalibeg tang kolo mi. Magtalig amo ong Dios ig magtalig amo ka ong yen. ");
INSERT INTO agn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Don ong balay tang Tatayo yading maistaran. Tongkawo don para magsimpan ta logar para ong nindio. Indio magbeg ta narin ong nindio mga belag ta matod. ");
INSERT INTO agn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ig mga dono ra ig nasimpanan amo ra yen ta istaran mi, magbaliko si tarin para komiten amo, agod mga ong ariopa, don amo ka. ");
INSERT INTO agn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ig gata-wanan mi ra tang dalan ang paning ong paningano.” ");
INSERT INTO agn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ganing ong nandia si Tomas, “Gino, indi ami gatako mga ong ariapa paning, monopa mata-wanan amen tang dalan?” ");
INSERT INTO agn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ganing si Jesus, “Yo tang dalan, ang kamatodan ig ang kaboi. Anday mapaning ong Dios ang Tatay mga belag ta yo tang dalan ang osoyon na. ");
INSERT INTO agn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mga matod ang gailalao nindio, maliag yaning gailala mi ra ka asta ang Tatayo. Ig mimpisa mandian gailala mi ra enged tanandia ig inita mi ra ka.” ");
INSERT INTO agn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ganing ong nandia si Felipe, “Gino, ipaita mo kay ong yamen tang Tatay agod magkontinto ami ra.” ");
INSERT INTO agn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Siminabat si Jesus, “Felipe, kaboay da tang pagtarabidan ta! Indio pa enged gailala mo? Ang naita ong yen, naita ra ka ong Dios ang Tatay. Angay ganinga pa, ‘Ipaita mo ong yamen tang Tatay’? ");
INSERT INTO agn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Onopa? India pagparet ang yo ong Tatay ig ang Tatay nani ka ong yen? Ang mga bitalang agtotoldoko indi pagalin ong sadilio. Ang Dios ang Tatay ang nani ong yen, tanandia mismo tang pagboat tang mga bagay ang agboateno. ");
INSERT INTO agn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Animan magparet amo ong agganingo nga ang Tatay nani ong yen ig yo ong nandia. Piro maski indi amo maliag ang magparet ong agganingong na, dapat magparet amo ka enged tenged ong mga milagrong inita mi. ");
INSERT INTO agn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tandan mi na: Ang pagto ong yen mapagboat ka tang pario tang agboateno, ig mas sobra pa ngani, tenged yo magbaliko ra ong Dios ang Tatay. ");
INSERT INTO agn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ig maski onopay pa-dolon mi ong nandia ong arano, sia boateno, agod dayawen tang Tatayo tenged ong yen, ang Ana na. ");
INSERT INTO agn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Maski onopay pa-dolon mi ong arano, sia boateno ka kaman.” ");
INSERT INTO agn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ganing pa si Jesus, “Mga matod ang agmaleno nindio, tomanen mi tang mga tobolo. ");
INSERT INTO agn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pa-dolono ong Tatayo ang oldan amo nandia tang Manigtabang ang tenlet ong yen, agod magimo rang aroman mi asta ong tanopa. ");
INSERT INTO agn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Na anday doma, ang Ispirito Santo ang yay ang magtoldok ong nindio tang kamatodan natetenged ong Dios. Ang mga taw ang indi pangilala ong yen, indi marisibi tang Ispirito tenged indi tanira gaita ig indi ka gailala ong nandia. Piro yamo, gailala mi tanandia, tenged asia ra tanandia ang aroman mi mandian, ig magtinir ong nindio asta ong tanopa. ");
INSERT INTO agn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Indi amo bo-wanan ta ang anday aroman mi. Magbaliko ka ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Indi ra lamang maboay, indio ra itaen tang mga taw ang sakep tang kalibotan ang na. Piro yamo, itaeno pa nindio tenged maboio sing oman. Ig tenged yo maboio, maliag yaning asta yamo maboi amo ka. ");
INSERT INTO agn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ong kaldaw ang asi, don mata-wanan mi enged ang yo ong Tatay, ig yamo nani ka ong yen, ig yo atano ka ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ang sinopay pagrisibi ig pagtoman ong mga tobolo, tanandia yay ang paggegma ong yen. Ig ang taw ang paggegma ong yen, gegman ka tanandia tang Tatayo. Asta yo, gegmano ka tanandia, ig bogos ang ipailalao tang sadilio ong nandia.” ");
INSERT INTO agn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mandian, ang tata pang Judas, ang belag ta Judas ang Iscariote, nane-ma ong ni Jesus ang ganing, “Gino, angay ong yamen lamang agpailala mo tang sadili mo? Angay india magpailala ong tanan?” ");
INSERT INTO agn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Siminabat si Jesus, “Asia tenged ang taw ang paggegma ong yen, tanandia tang magtoman ong mga bitalao. Gegman tanandia tang Tatayo, ig yo may ang Tatayo ma-pen ami ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Piro ang indi paggegma ong yen, indi magtoman tang mga bitalao. Ang mga bitalang gaba-yan mi ong yen, indi pagalin ong sadilio. Sia pagalin ong Dios ang Tatay ang yay ang nanobol ong yen tarin ong kalibotan. ");
INSERT INTO agn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ang mga bagay ang na agpatakō rang lagi ong nindio mintras aromano pa nindio. ");
INSERT INTO agn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Piro mga mapagalino ra ngani, ipekel tang Tatayo tang Manigtabang, ang yay ang Ispirito Santo, bilang kateleto. Tanandia tang magtoldok ong nindio tang tanan ang bagay ig magpademdem ong nindio tang tanan ang inaningo. ");
INSERT INTO agn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Kao-yan tang agbobo-wano ong nindio. Ang kao-yan ang nang agto-dolo ong nindio pagalin ong yen, ig belag ta pario tang kao-yan ang pagalin ong kalibotan ang na. Animan indi amo magpalibeg tang kolo mi ig indi amo mageled. ");
INSERT INTO agn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Naba-yan mi ra tang inaningo ong nindio: Magalino ra piro magbaliko si. Mga matod ang aggegmano nindio, mangalipay amo rin ang mapaningo ra ong Tatayo, tenged ang Tatay mas makagagaem pa ong yen. ");
INSERT INTO agn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Na agpatakō rang lagi ong nindio mintras indi pa gainabo, agod mga mainabo ra ngani, mamagparet amo. ");
INSERT INTO agn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Indi ra paboateno tang bitalao tenged komabot da tang pangolokolo ong kalibotan ang na. Anda enged ay gaem na ong yen. ");
INSERT INTO agn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Piro tomaneno tang agtotobol tang Tatayo ong yen, agod mata-wanan tang tanan ang taw ang aggegmano kaman tanandia. Animan, maytara! Panaw ita ra!” ");
INSERT INTO agn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nagtoldok si Jesus ong mga sinagpan na ta tatang palimbawa ang ganing, “Yo tang matod ang papa ta obas, ig ang Tatayo tang manigsagod. ");
INSERT INTO agn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Agpotolon na tang yen ang mga tanga ang indi pamorak. Piro ang kada tanga ang pamorak, aglimpioan na agod manaringsing ig mas manyadi pa tang borak na. ");
INSERT INTO agn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yamo tang mga tanga ang nalimpioan da tenged ong mga bitalao ang sinoldoko ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Animan indi amo palbag ong yen, ig yo indio ka palbag ong nindio. Indi ra mapamorak tang tangang indi ra toto-pat ong papa na. Maning amo ka don, mga palbag amo ong yen, indi amo ra mapamorak. ");
INSERT INTO agn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Animan ganingo, yo tang papa ta obas ig yamo tang mga tanga na. Ang taw mga indi tanandia palbag ong yen, ig yo indio ka palbag ong nandia, tanandia yay ang mamorak ta doro. Tenged mga yo andao ong nindio, anda enged ay maboat mi. ");
INSERT INTO agn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Piro ang taw ang agpalbag ong yen igpere-lek lamang, pario tang mga tangang pinlek ig lango ra, simeten oman tolpokan da. ");
INSERT INTO agn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Piro mga indi amo palbag ong yen, ig mga iloak mi ong mga popotokon mi tang mga bitalao, mama-dol amo tang maski onopay galiagan mi, sia oldan amo. ");
INSERT INTO agn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mga magpadayon among mamorak ta doro, maliag yaning yamo mga sinagpano, ig ong maning don mapagtorol amo ta mabael ang dengeg ong Tatayo. ");
INSERT INTO agn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mga monopa tang paggegma tang Tatay ong yen, maning ka don tang paggegmao ong nindio. Indi amo magpabelag ong paggegmao. ");
INSERT INTO agn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mga tomanen mi tang mga tobolo, indi amo kaman malbag ong paggegmao ong nindio. Pario ka ong yen, ang agtomaneno tang mga tobol tang Tatayo, animan indio galbag ong paggegma na. ");
INSERT INTO agn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Agganingo ong nindio tang mga bagay ang na agod mangalipay amo pario ong yen, ig agod magimong bogos tang kalipay mi. ");
INSERT INTO agn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na tang tobolo ong nindio: mamaggeregman amo pario tang paggegmao ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Anda enged ay kapario na tang paggegma ta tatang taw ang magbolontad tang kaboi na para ong mga tangay na. ");
INSERT INTO agn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tangay amo yen mga agtomanen mi tang mga tobolo. ");
INSERT INTO agn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Indi amo ra agkabigen ta ang mga torobolon, tenged ang torobolon indi gatako tang tanan ang agboaten tang agalen na. Agkabigen amo ra yen ang mga tangayo, tenged ang onopay naba-yano ong Tatayo, ya kay ang agganingo ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Belag ta yamo tang namilik ong yen. Yo tang namilik ig nanobol ong nindio agod magkatinir amo ta borak ong pagtoldok mi. Ig ang mga borak ang asi indi malipat asta ong tanopa. Ong maning don, maski onopay pa-dolon mi ong Dios ang Tatay ong arano, sia i-dol na ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Animan agganingo si ong nindio: mamaggeregman amo.” ");
INSERT INTO agn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ganing pa si Jesus, “Mga asilagan amo ra tang mga taw ang sakep tang kalibotan ang na, demdemen ming yo tang primirong inasilagan nira ba-lo yamo. ");
INSERT INTO agn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mga kapario amo rin tang mga taw ang asi, ginegman amo ka rin nira tenged aroman amo nira. Piro ong matod, belag amo ra ta aroman nira, tenged pinilik amo ra yen agod pabelag amo ong nira ig yay sia animan gangasilag tanira ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Demdemen mi tang inaningo ong nindio ang anday torobolon ang mas alawig ong agalen na. Maliag yaning, tenged yo agpaliwagano tang mga taw, indi maimong indi amo ka paliwagan nira. Ya ka mga may atan ang namagparet ong toldoko, pareten ka nira tang itoldok mi. ");
INSERT INTO agn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Piro paliwagan amo enged tang mga taw tenged mga sinagpan amo yen ig indi tanira gangailala ong nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mga indio rin napaning tarin ong kalibotan para begen tanira tang natetenged ong sadilio, indi ka rin namagkatalak tanirang indi namagto ong yen. Piro mandian ang napaningo ra tarin, indi ra tanira mapagbalibad ong talak nirang asi. ");
INSERT INTO agn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ang taw ang anday gegma na ong yen, anda kay gegma na asta ong Tatayo. ");
INSERT INTO agn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mga indio ka nagboat ig nagpaita ta mga milagrong indi enged maboat ta taw, anda ka rin ay kasalanan nira maski indi mamangilala ong yen. Piro maski inita ra nira tang mga bindoato, ong dobali ta sia gangasilag pa ka enged tanira ong yen asta ong Tatayo. ");
INSERT INTO agn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Piro dapat dang mainabo na agod magmatod tang na-tang ong Katobolan nira ang ganing, ‘Gangasilag tanira ong yen ang anda kay dailan.’ ");
INSERT INTO agn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Piro magpekelo ong nindio tang Manigtabang, ang yay ang Ispirito Santo ang magalin ong Tatayo. Tanandia tang Manigtoldok tang kamatodan, ig mga komabot magpamatod tang natetenged ong yen. ");
INSERT INTO agn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ig yamo kaministiran kang magpamatod ong mga taw natetenged ong yen, tenged aroman amo rang lagi yen impisa ong primiro.” ");
INSERT INTO agn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ganing pa si Jesus ong mga sinagpan na, “Ang tanan ang narin agpatakō rang lagi ong nindio agod maski onopay mainabo, indi malipat tang pagto mi ong yen. ");
INSERT INTO agn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tenged palayasen amo tang mga masig ka Judio mi ong mga simban mi. Ig komabot tang oras nga ang doma mamamatay ong nindio ang kalaom nira tama tang agboaten nirang asi ong pagsirbi nira ong Dios. ");
INSERT INTO agn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Maning ta sia tang boaten nira ong nindio tenged indi tanira gangailala ong yen asta ong Dios ang Tatay. ");
INSERT INTO agn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Agbebego narin mandian agod mga mainabo ra, mademdeman ming pinatakō rang lagi ong nindio tang natetenged ong nira.” “Ang mga bagay ang nang mainabo ong nindio, indi pang lagi binego tanopa sia tenged ka-peno pa nindio. ");
INSERT INTO agn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mandian agbebego ra tenged magbaliko ra ong nanobol ong yen. Piro angay bato maski tata ong nindio anda enged ay pane-ma mga ong ariopa paning? ");
INSERT INTO agn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Asia tenged sigoro pamagsinti amo ta mo-ya natetenged ong mga bagay ang ba-lo lamang binego ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Piro dapat mata-wanan mi, ang pagalino tarin ong kalibotan ay para ong ikakao-ya mi. Tenged mga indio magalin, ang Manigtabang, ang yay ang Ispirito Santo, indi paning ong nindio. Piro mga magalino, ipekelo tanandia tarin agod tomabang ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mga komabot tanandia, ipaita na ong mga taw ang sakep tang kalibotan ang na nga mali tang aggisipen nira natetenged ong onopa enged tang kasalanan ig mga sinopay mato-lid, ig mga monopa tang pagorosgaren tang Dios. ");
INSERT INTO agn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ipaita na ong nira nga pamagkatalak tanira tenged indi tanira pamagto ong yen. ");
INSERT INTO agn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ipaita na mga sinopa tang mato-lid tenged yo magbaliko ra ong Dios ang Tatay, ig indio ra itaen ming moman. ");
INSERT INTO agn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ipaita ka tang Ispirito mga monopa tang pagorosgaren tang Dios, tenged nasintinsian dang silotan si Satanas, ang yay ang pangolokolo ong mga taw ang sakep tang kalibotan ang na. ");
INSERT INTO agn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Doro pa rin tang yaningo ong nindio, piro belag pa ta kaya mi. ");
INSERT INTO agn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Piro mga komabot da tang Ispirito Santo, ang yay ang Ispirito tang kamatodan, tanandia tang magtoldok ong nindio tang tanan ang kamatodan natetenged ong Dios. Indi tanandia magbitala ong sadiling kaliagan na, kondi ang onopay gaba-yan na ong Dios ang Tatay, ya kay ang yaning na ong nindio. Ig ipatako na tang onopay mainabo ong parakaboton. ");
INSERT INTO agn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ang Ispirito magtorol ta mabael ang dengeg ong yen, tenged ang mga bitalao mismo tang yaning na ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ganingo ang mga bitalao yay ang yaning tang Ispirito ong nindio, tenged mga onopa tang bitala tang Tatayo, ya kay ang yen.” ");
INSERT INTO agn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ganing pa si Jesus ong mga sinagpan na, “Indi ra lamang maboay, indio ra itaen mi. Piro mata-lib tang indi ka lamang maboay ang timpo, itaeno si nindiong moman.” ");
INSERT INTO agn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Animan ang doma ong mga sinagpan ni Jesus namagtere-ma te-man ang ganing, “Onopa bato tang maliag nang yaning? Angay bato ganing tanandia indi ra lamang maboay, indi ra itaen ta tanandia, piro mata-lib tang indi lamang maboay ang timpo, itaen ta si ka onong oman? Ig ganing pa, tenged magbalik ono ong Tatay na. ");
INSERT INTO agn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Onopa bato tang maliag nang yaning, ‘Indi ra lamang maboay’? Indi ita baya maintindi!” ");
INSERT INTO agn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Gata-wanan ni Jesus ang gangaliliag ka rin tanirang mamane-ma ong nandia, animan ganing tanandia ong nira, “Pamagtere-ma te-man amo atan natetenged ong inaningo ang indi ra lamang maboay indio ra itaen mi, piro mata-lib tang indi lamang maboay ang timpo, itaeno si nindiong moman. ");
INSERT INTO agn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ong matod, ang mga taw ong kalibotan ang indi pangilala ong yen, mangalipay ta mo-ya ong mainabo ong yen. Piro yamo, mamagini-yak amo tenged ong sobrang sinti mi. Piro indi lamang maboay, ang kapongawan ming asia malipat ig teltan ta kalipayan. ");
INSERT INTO agn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pario ong babay ang pagpasit. Aggagoantaen na tang kasitan tenged mangana ra. Piro mga maloa ngani tang mola, malipatan na ra tang napasaran nang kasitan. Galipay da tanandia tenged nataw da tang ana na. ");
INSERT INTO agn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Pario ka ong nindio, pamagsinti amo ka mandian, piro mga mamaginitan ita sing moman, mangalipay amo ta mo-ya. Ig indi enged makalaw ong nindio ta maski sinopa tang kalipayan ang asi. ");
INSERT INTO agn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ong kaldaw ang asi, anda ray kaministiran ang mane-ma amo pa ong yen. Ong matod, maski onopay pa-dolon mi ong Tatayo ong arano, asia i-dol na ong nindio. ");
INSERT INTO agn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Asta mandian, indi amo pa pama-dol ta maski onopa ong arano. Mama-dol amo, ig sia marisibi amo, agod magimong bogos tang kalipay mi.” ");
INSERT INTO agn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ganing pa si Jesus, “Ang mga bagay ang na agganingo ong nindio ong paggamito ta mga palimbawa. Piro komabot tang kaldaw ang indio ra maggamit ta mga palimbawa. Idiritsō ra lamang ipatako ong nindio tang natetenged ong Tatayo. ");
INSERT INTO agn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ong kaldaw ang asi, yamo ra mismo tang mama-dol ong Dios ang Tatay ong arano. Belag da ta kaministiran ang yo pa tang mama-dol para ong nindio, ");
INSERT INTO agn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","tenged ang Tatay paggegma ong nindio. Aggegman amo tang Tatay tenged aggegmano nindio, ig pamagparet amo ang yo nagalino ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nagalino ka kaman ong Dios ang Tatay ig napaningo tarin ong kalibotan. Ig mandian magalino ra tarin ig magbalik ong nandia.” ");
INSERT INTO agn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dayon ang minaning tang mga sinagpan ni Jesus, “Asia, mayag da tang mga pamitala mo! Tenged diritso lamang ang india ra paggamit ta palimbawa. ");
INSERT INTO agn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mandian gasigoro amen dang gata-wanan mo tang tanan ang bagay. Maski indi pa gapane-ma ong nio tang tatang taw, gata-wanan mo rang lagi tang onopay gisipen na. Animan pamagparet ami ra ang yawa nagalina ong Dios.” ");
INSERT INTO agn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Siminabat si Jesus, “Onopa, pamagto amo ra ong yen mandian? ");
INSERT INTO agn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Piro tandan mi: Komabot tang oras, ig kiminabot da mandian, ang yamong tanan mamagbelag-belag. Mamansiolik amo ig bo-wanano nindio. Piro maski bo-wanano nindio, may aromano pa ka enged tenged ang Dios ang Tatay aromanong pirmi. ");
INSERT INTO agn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Animan mandian ang tanan ang narin sinayodo ra ong nindio agod indi magoloan tang isip mi, tenged na-pen amo ra ong yen. Mapasar amo ta kaliwagan ong kalibotan ang na, piro papoirsaen mi tang nem mi! Ang tanan ang kalainan tang kalibotan dinego ra.” ");
INSERT INTO agn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagatapos ang minitala si Jesus, siminingara tanandia ong langit ig minaning, “Tatayo, kiminabot da tang oras. Padengegan mo kay tang Ana mo, agod ang Ana mo mapagtorol ka ta dengeg ong nio. ");
INSERT INTO agn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tenged sindolano nio ta podir ang maggaem ong tanan ang taw, agod magtorolo ta kaboing anday kataposan ong tanan ang mga taw ang sindol mo ong yen. ");
INSERT INTO agn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Magkatinir tanira tang kaboing anday kataposan mga mangilala tanira ong nio, ang matod ig tambilog lamang ang Dios, ig mga mangilala ka ong yen, ang sinobol mo. ");
INSERT INTO agn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mandian nataposo ra tang tanan ang pinaboat mo ong yen, ig ong maning don napagtorolo ra ta mabael ang dengeg ong nio tani ong tanek. ");
INSERT INTO agn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Animan mandian, Tatay, padengegano si nio atan ong podir mo, pario asing aromano pa nio ba-lo bindoat tang kalibotan. ");
INSERT INTO agn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Pinailalā ra yen ong mga taw ang nang pinilik mo ong kalibotan ig sindol mo ong yen. Tanira nio ig inintriga mo tanira ong yen. Sinoman nira tang mga bitala mo, ");
INSERT INTO agn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ig mandian gangatako ra tanirang ang tanan ang sindol mo ong yen, ong nio enged nagalin. ");
INSERT INTO agn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tenged mga onopa tang inaning mo ong yen, ya kay ang sinoldoko ong nira, ig rinisibi ka nira. Ig mandian gangatako ra enged ang yawa mismo tang pinagalinano ig yawa ka tang nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Animan, Tatay, pangadio para ong mga sinagpanong narin. Belag ta maning ang pangadio para ong tanan ang taw ong kalibotan. Ang agpangadio lamang ay ang mga taw ang sindol mo ong yen tenged tanira nio. ");
INSERT INTO agn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ang tanan ang nio ay yen. Ig ang tanan ang yen ay nio. Ig yo agpadengegano tenged ong nira. ");
INSERT INTO agn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Indi ra lamang maboay, magalino ra ong kalibotan ang na ig magbaliko ra atan ong nio. Piro tanira mangabo-wan pa tani. O, Tatay ang Sagrado, bantayan mo kay tang mga taw ang na ong gaem mong mismo ang sindol mo ong yen, agod magimong tata ra lamang tanira, pario tang ita tata lamang. ");
INSERT INTO agn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Asing aromano pa nira, binantayano tanira ong gaem mong sindol mo ong yen. Binantayano tanira ta mo-ya, ig maski tata ong nira anday nalipat, poira lamang ong tambilog ang i-lek ong impirno para silotan ang anday kataposan agod magmatod tang na-tang dang lagi ong Kasolatan. ");
INSERT INTO agn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Indi ra lamang maboay, magbaliko ra atan ong nio, Tatay. Animan mintras tanio pa ong kalibotan, agpangadio tang mga bagay ang na para ong mga sinagpano agod bogos ang marisibi nira tang kalipayan ang magalin ong yen. ");
INSERT INTO agn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Sindolo ra ong nira tang mga bitala mo ig yay sia animan gasilagan tanira tang mga taw ang sakep tang kalibotan ang na. Gasilagan tanira tenged belag da tanira ta pario tang mga taw ang asi, pario ong yen ang belago ka ta pario nira. ");
INSERT INTO agn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Indio pagampo ang komiten mo tanira ong kalibotan, kondi ilibri mo kay tanira ong ni Satanas. ");
INSERT INTO agn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Belag tanira ta pario tang mga taw ang sakep tang kalibotan ang na, pario ang yo belago ka ta pario nira. ");
INSERT INTO agn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Animan boaten mo kay tanirang mga sagradong sinakepan mo ong tabang tang bitala mo, ang yay ang kamatodan. ");
INSERT INTO agn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Na agpa-dolono ong nio tenged mga monopa yo sinobolo nio tani ong kalibotan, ya kay mandian tobolono ra ka tanira ong mga taw ong kalibotan. ");
INSERT INTO agn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ig para ong nira, agbobolontado ra tang sadilio ong nio, agod bogos tanirang magimong mga sagradong sinakepan mo. ");
INSERT INTO agn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Belag lamang tanira tang agpangadio, kondi asta ang tanan ang taw ang mamagto ong yen tenged ong pagtoldok nira. ");
INSERT INTO agn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tatayo, agpa-dolono ong nio ang magimong tata lamang tanirang tanan. Mga monopa yawa tani ong yen ig yo atano ong nio, balampa magimong tata lamang tanira ong yaten, agod mamagparet tang mga taw ong kalibotan ang yawa tang nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ang dengeg ang sindol mo ong yen, sindolo ka ong nira agod magimong tata lamang tanira pario tang ita tata lamang. ");
INSERT INTO agn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Maliag yaning mga monopa yawa tani ong yen, yo ya ka ong nira agod magimong tata lamang enged tanira. Ong maning don, mata-wanan tang mga taw ong kalibotan ang yawa tang nanobol ong yen ig aggegman mo tanira pario tang paggegma mo ong yen. ");
INSERT INTO agn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O Tatay, galiagano ang ma-pen ka ong yen atan mismo ong langit tang mga taw ang inintriga mo ong yen, agod itaen ka nira tang mabael ang dengeg ang sindol mo ong yen. Sindolano nio tang dengeg ang na tenged asing indi pa gaboat tang kalibotan, ginegmanong lagi nio. ");
INSERT INTO agn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tatayong mato-lid, ang mga taw ang sakep tang kalibotan ang na, indi gailala ong nio. Piro yo gailalao ong nio. Ig gata-wanan tang mga aromanong na ang yawa tang nanobol ong yen. ");
INSERT INTO agn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pinailalā yen ong nira, ig ipailalā pa ka enged yen agod bogos ang mapasaran nira tang paggegma mo ong yen, ig agod yo mismo atano kang pirmi ong nira.” ");
INSERT INTO agn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pagatapos ni Jesus ang nangadi, napanaw tanandia aroman na tang mga sinagpan na. Namansila-ted tanira ong dobali tang toro-bodan tang Kidron ig don tanira namansipaning ong tatang logar ang lindoakan ta mga ayong olibo. ");
INSERT INTO agn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ang logar ang narin gatoman ka tang traidor ang si Judas tenged pirming pamansipaning don da Jesus may ang mga sinagpan na. ");
INSERT INTO agn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Animan napaning ka don si Judas, pagated tang mga sondalong taga Roma asta ang mga goardia tang Timplo ang sinobol tang mga Pariseo ig ang mga pangolokolong padi. May ekel nirang mga tolok, mga lampara asta mga armas. ");
INSERT INTO agn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Gata-wanan dang lagi ni Jesus tang tanan ang mainabo ong nandia, animan binagat nang lagi tang mga taw ang asi ig minaning, “Sinopay agdilemen mi?” ");
INSERT INTO agn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Siminabat tanira, “Si Jesus ang taga Nazaret.” Ganing si Jesus ong nira, “Yo si Jesus.” Mandian, si Judas, ang nagtraidor ong nandia, don kang aroman tang mga taw ang asi. ");
INSERT INTO agn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pagabitala ni Jesus ang ganing, “Yo si Jesus,” golping nangatras tang mga taw ig nangatomba ong tanek. ");
INSERT INTO agn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Oman sine-ma si tanira ni Jesus, “Sinopa enged tang agdilemen mi?” “Si Jesus ang taga Nazaret,” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Siminabat si Jesus, “Ganingo ra ong nindio, yo si Jesus. Mga yo tang agdilemen mi, pabayan mi lamang mapagalin tang mga aromanong na.” ");
INSERT INTO agn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Maning ta na tang bitala ni Jesus agod magmatod tang inaning na rang lagi tanopa sia ong Dios ang ganing, “Tatayo, anda enged ay nalipat maski tambilog ong mga taw ang inintriga mo ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mandian, na pala si Simon Pedro may ekel nang ispada. Golping binonlok na ig dayon ang tinagpas na tang kirepen tang kalawigan ang padi ig nalampong tang talinga nang to. Ang aran tang kirepen ang asi ay si Malco. ");
INSERT INTO agn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Oman ganing si Jesus ong ni Pedro, “Itageb mo sia! India gatako? Kaministiran ang mapasarano tang kaliwagan ang na ang agto-dol tang Tatayo ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Oman dayon dang dinep si Jesus ig linapot tang mga sondalo ong pagpangolokolo tang kapitan nira, aroman ka tang mga goardiang Judio. ");
INSERT INTO agn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Primiro, don ingkelan nira ong ni Anas ang panogangan ang lali ni Caifas. Si Caifas ang na yay ang kalawigan ang padi tang mga Judio asing takon ang asi. ");
INSERT INTO agn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tanandia ka tang naglaygay tanopa sia ong mga pangolokolo ong mga Judio ang ganing mas mo-ya ono para ong nira mga tanga tawan lamang tang mapatay kaysa ang bilog ang nasion. ");
INSERT INTO agn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Si Simon Pedro asta ang tata pang sinagpan ni Jesus diminaton ka don. Ang sinagpan ang asi, gailala tang kalawigan ang padi, animan na-led tanandiang aroman ni Jesus ong kodal tang palasio tang padi. ");
INSERT INTO agn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piro si Pedro nabo-wan don ong loa tang kodal. Animan indi naboay, nagbalik don tang aroman nang sinagpan ang gailala tang kalawigan ang padi, ig nagigampang ong babay ang manigbantay ong portan, oman pina-led na si Pedro. ");
INSERT INTO agn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ganing tang babay ong ni Pedro, “Belag bato ta yawa tata ong mga sinagpan tang taw ang asi?” “Belag!” tang sabat ni Pedro. ");
INSERT INTO agn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tenged malamig asing labing asi, ang mga torobolon ig ang mga goardia namagpadet ta koring ig namansi-deng ong palibot na para magpakinit-kinit. Don minimbeng ka si Pedro ong nira ang nagpakinit-kinit. ");
INSERT INTO agn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mandian, inimbistigar si Jesus tang kalawigan ang padi natetenged ong mga sinagpan na ig ong mga agtotoldok na. ");
INSERT INTO agn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Siminabat si Jesus ang ganing, “Yo indio pagtoldok ong talok. Pirmiong bibitala ong talongan tang tanan. Tenged pagtoldoko mismo ong mga simban ig ong Timplo, ang yay ang mga pagsirimetan tang tanan ang mga Judio. ");
INSERT INTO agn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Angay yo tang agte-maen mi? Ang mga taw ang nangabasi ong yen tang dapat te-maen mi. Sia gata-wanan nira tang onopay sinoldoko.” ");
INSERT INTO agn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pagabitala ni Jesus ta na, sinampaling tanandia tang tata ong mga goardia ang ke-deng alenget ong nandia. “Angay maning atan tang pagsarabaten mo ong kalawigan ang padi?” ganing tang goardia. ");
INSERT INTO agn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Siminabat si Jesus, “Mga may inaningong malain, isayod mo. Piro mga anda, angay sinampalingo nio?” ");
INSERT INTO agn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Oman, asing aglapoton pa si Jesus, pinekel da tanandia ni Anas don ong ni Caifas, ang yay enged ang kalawigan ang padi asing takon ang asi. ");
INSERT INTO agn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Asing oras kang asi, don pa si Simon Pedro ong loa ang pagpakinit-kinit ong apoy. Sine-ma tanandia tang mga taw don ang ganing, “Belag bato ta yawa tata ong mga sinagpan tang taw ang asi?” Nagbo-li si si Pedro ang ganing, “Belag baya!” ");
INSERT INTO agn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mandian may don ka ang tatang kirepen tang kalawigan ang padi ig parinti tang taw ang asing tinagpas ni Pedro tang talinga na. Ganing tanandia ong ni Pedro, “Midio yawa ka kaman tang initao ang aroman ni Jesus don ong kaoliboan!” ");
INSERT INTO agn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piro nagbo-li sing oman si Pedro. Ig ya kay ang pagpanolōk tang mano. ");
INSERT INTO agn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Magalin ong ni Caifas, ingkelan si Jesus tang mga pangolokolong Judio don ong palasio tang gobirnador. Maga pang pisan asing oras ang asi. Pagakabot nira don ong palasio, ang mga Judio indi maliag ang tenled tenged galenget da tang Pista tang Pagta-lib tang Anghil, ig sigon ong toromanen nira, mga tenled tanira ong balay ta belag ta Judio, bawal da ong nira ang ma-pen ang mamangan ong pista nira. ");
INSERT INTO agn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Animan si Pilato tang limindoa ong nira ig minaning, “Onopa tang riklamo mi kontra ong taw ang na?” ");
INSERT INTO agn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Siminabat tang mga Judio ang ganing, “Mga indi nagboat ta malain, indi ingkelan amen tarin ong nio!” ");
INSERT INTO agn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ganing si Pilato ong nira, “Ala, bāla amo ang magosgar ong nandia sigon ong katobolan mi.” Piro siminabat tanirang ganing, “Yaming mga Judio, anday podir amen ang magsintinsia ta kamatayen ong maski sinopa.” ");
INSERT INTO agn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Maning ta na tang binitala nira agod ong ori magmatod tang inaning ni Jesus mga monopa tanandia mapatay. ");
INSERT INTO agn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Animan dayon ang siminled si Pilato ong palasio. Pinagoy na si Jesus ig sine-ma na ang ganing, “Onopa? Matod ang yawa tang adi tang mga Judio?” ");
INSERT INTO agn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Siminabat si Jesus, “Onopa? May nagbeg ong nio natetenged ong yen? Obin sia sadiling isip mo lamang?” ");
INSERT INTO agn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ganing si Pilato, “Angay? Pabetang mo ong yen tatang Judio? Ang mga kasimanoa mong Judio ig ang mga pangolokolong padi mi mismo tang namagekel ong nio tarin ong yen! Angay? Onopay bindoat mo?” ");
INSERT INTO agn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ganing si Jesus ang siminabat, “Ang yen ang inadian anda tarin ong kalibotan, tenged mga tarino paggaem bilang adi, magigbatok ka rin tang mga tawano agod indio madep tang mga pangolokolong Judio. Piro ong matod, ang yen ang inadian anda tarin ong kalibotan ang na.” ");
INSERT INTO agn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Animan ganing si Pilato, “Maliag yaning adia ka kaman!” Siminabat si Jesus, “Yawa ra ka tang naganing! Ig yo napaningo tarin ong kalibotan ig nagimong taw para magpatako ong mga taw natetenged ong kamatodan. Ig ang maski sinopay galiliag ang matako tang kamatodan, pamamasi ong yen ang mga bitala.” ");
INSERT INTO agn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ganing si Pilato, “Onopa enged tang kamatodan?” Pagabitala ta si ni Pilato, dayon sing oman ang limindoa don ong mga Judio ig ganing ong nira, “Anda kay initao ang kakamalian ong taw ang na para sintinsian. ");
INSERT INTO agn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Piro sigon ong kaogalian mi, kada Pista tang Pagta-lib tang Anghil, dapat magpalpato ta tatang priso. Onopa? Palpatano para ong nindiong mga Judio tang adi ming narin?” ");
INSERT INTO agn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Namansisabat tang mga taw ang pamaginiteg, “Indi! Belag ta tanandia! Si Barabbas tang palpatan mo!” Si Barabbas ang na tatang ribildi. ");
INSERT INTO agn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Animan pinakomit ni Pilato si Jesus ig pinalatigo. ");
INSERT INTO agn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Namagboat tang mga sondalo ta korona-koronang poros tenek oman pinakorona nira ong ni Jesus. Pinatokan nira ta kapang granati bilang intirimis, ");
INSERT INTO agn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","oman kada tata agpalenget ong nandia ang ganing “Biba ong adi tang mga Judio!” Ig agtampalingen pa nira. ");
INSERT INTO agn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Limindoa sing oman si Pilato don ong mga Judio ig minaning, “Ipaloao ra tanandia tarin ong nindio agod itaen ming anda enged ay kakamalian ang initao ong nandia.” ");
INSERT INTO agn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Animan pinaloa si Jesus ang pagkorona ra ta tenek ig pagtok ta sing kapang granati. Ganing si Pilato ong mga Judio, “Telekan mi! Nani ra tang taw!” ");
INSERT INTO agn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pagaita ong ni Jesus tang mga pangolokolo ong mga padi ig ang mga goardia tang Timplo, dayon ang namansiteg ang ganing, “Ilansang tanandia ong kros! Ilansang ong kros!” Ganing si Pilato ong nira, “Ala, komiten mi tanandia! Yamo tang balang maglansang ong kros! Yo, anda enged ay initao ang talak na para sintinsian.” ");
INSERT INTO agn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Siminabat tang mga Judio, “Piro sigon ong yamen ang katobolan, ang taw ang na dapat ang patayen, tenged pangambong tanandia tang Ana tang Dios.” ");
INSERT INTO agn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pagabasi ta si ni Pilato, mas inledan da tanandiang sintinsian na si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Animan ingkelan na sing oman si Jesus ong teled tang palasio ig sine-ma na si, “Taga ariapa enged?” Piro indi siminabat si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Animan ganing si si Pilato, “Angay india somabat ong yen? India gatako ang may kagaemano ang palpatana yen obin ipalansang ong kros?” ");
INSERT INTO agn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ganing si Jesus ong nandia, “Yawa, anda enged ay maboat mo ong yen mga india sindolan tang Dios ta gaem. Animan mas mabelat tang kasalanan tang nagekel ong yen tarin ong nio.” ");
INSERT INTO agn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pagabasi ni Pilato ta asi, nagdilem pa enged tanandia ta midios para malibri na si Jesus. Piro ang mga Judio namaginiteg ang ganing, “Mga palpatan mo tang taw ang asia, maliag yaning yawa pangontrā ong Adi tang Roma! Tenged ang maski sinopay pangambo ang tanandia adi ay kasoay tang Adi tang Roma.” ");
INSERT INTO agn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pagabasi ni Pilato tang inaning nirang asi, dayon ang laging ingkelan na si Jesus ong loa. Oman kiminarong si Pilato don ong palagosgaran, don ong logar ang aggoyan “Ang Platapormang Bato.” (Mga ong bitala tang mga Judio, “Gabata.”) ");
INSERT INTO agn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ang kaldaw ang asi Kaldaw ang Palagsimpan para ong pista nira ig ko-to ra. Mandian ganing si Pilato ong mga Judio, “Telekan mi! Nani ra tang adi mi!” ");
INSERT INTO agn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Piro sigi lamang tang initeg nira ang ganing, “Patayen tanandia! Patayen tanandia! Ilansang ong kros!” Ganing si Pilato, “Onopa? Ipalansango ong kros tang adi mi?” Ganing tang mga pangolokolong padi ang siminabat, “Anday domang adi amen poira ong Adi tang Roma!” ");
INSERT INTO agn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Animan ong ori, si Jesus inintriga ni Pilato ong nira para ilansang ong kros. Kinomit da si Jesus tang mga sondalo ");
INSERT INTO agn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ig limindoa tanira ong siodad. Pinatakan nira ong nandia tang kros na paning don ong logar ang aggoyan ta “Logar tang Doli ta Kolo.” (Mga ong bitala tang mga Judio, “Golgota.”) ");
INSERT INTO agn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pagakabot don, dayon ang linansang nira si Jesus ong kros. May doroa kang taw ang pinadengan nira ong nandia ang linansang. Ang kros tang tambilog gampir ong to ni Jesus, ig ang tata gampir ong wala. Si Jesus ong pagtetengan nira. ");
INSERT INTO agn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nagpaboat si Pilato ta karatola ig pinakabit na ong kros ni Jesus. Maning ta na tang nasolat don: “Si Jesus ang taga Nazaret, ang Adi tang mga Judio.” ");
INSERT INTO agn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sinolat narin ong bitala tang mga Judio, ong Latin, may ong Grigo, ig dorong mga Judio tang nangabasa tenged ang logar ang pinaglansangan ong ni Jesus alenget lamang ong siodad. ");
INSERT INTO agn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Animan, pagabasa ta na tang mga pangolokolong padi, namansipaning don ong ni Pilato ig namagriklamo ang ganing, “Belag ta ‘Adi tang mga Judio’ tang isolat mo, kondi ‘Ang taw ang na ganing tanandia ono tang Adi tang mga Judio.’ ” ");
INSERT INTO agn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Piro siminabat si Pilato. “Ang onopay sinolato don, nasolat da!” ");
INSERT INTO agn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mandian, asing si Jesus nalansang da tang mga sondalo, kinomit nira tang mga lambong na ig pinarti-parti nira ta epat, kada sondalo tang parti. Pagatapos, kinomit ka nira tang lambong nang maboat ang pandalem. Na anday sino-patan na, tenged diritso tang pangabel. ");
INSERT INTO agn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Animan namagarampang-ampang tang mga sondalo ang ganing, “Indi ra lasiken ta na. Mamagparabonlokan ita ra lamang agod mata-wanan ta mga sinopay makomit.” Maning ta sia tang nainabo agod magmatod tang na-tang ong Kasolatan ang ganing, “Pinagparti-partian nira tang lambongong agtotoko, ig namagpabonlokan pa tanira para ong lambongong maboat.” Ig maning kaman don tang bindoat tang mga sondalo. ");
INSERT INTO agn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mandian, don ong binit tang kros ni Jesus ke-deng tang nanay na may ang logod ang babay tang nanay na, asta si Mariang katawa ni Cleopas. Don ka si Maria Magdalena. ");
INSERT INTO agn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pagaita ni Jesus ong ni nanay na ig ong sinagpan nang agmalen na ta mo-ya ang ke-deng ka don, ganing tanandia ong nanay na, “Nay, asia tang ana mo.” ");
INSERT INTO agn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Oman ganing ka ong sinagpan nang asi, “Asia tang nanay mo.” Ig mimpisa don, si Maria don da ministar ong balay tang sinagpan nang asi. ");
INSERT INTO agn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pagatapos ta si, gata-wanan ni Jesus ang tapos da tang tanan ang bagay, animan agod magmatod tang na-tang dang lagi ong Kasolatan, ganing tanandia, “Agkoaweno ra.” ");
INSERT INTO agn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","May tatang tereldan don ang may teled nang maka-lem ang bino. Nangomit tanira ta ispongha ig sine-me nira ong irinemen ang asi. Pagatapos, sina-ket nira ong kapotan tang tanga ta iloloak ang isopo, oman dinoydoy nira ong anga ni Jesus para ipasepsep. ");
INSERT INTO agn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pagase-sep na ta si, ganing tanandia, “Tapos da!” Oman siminokok tanandia, inintriga na ra tang ispirito na ong Dios ig nabontok da tang linawa na. ");
INSERT INTO agn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ang kaldaw ang asi, Kaldaw ang Palagsimpan. Ang mga Judio indi gangaliag mga ang sinangoni tang mga linansang ong kros mangabo-wan don, tenged maramal Kaldaw ang Igperenay ig pista kang dorog kaimportanti ong nira. Animan namagigampang tanira ong ni Pilato mga poiding panlapiken tang mga bisit tang mga taw ang linansang, agod madaling mangapatay ig makomit da tang mga sinangoni nira ong kros. ");
INSERT INTO agn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Animan pinaningan tang mga sondalo ig pinanlapik nira tang mga bisit tang doroang taw ang linansang ang kadengan ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Piro pagakabot nira ong ni Jesus, inita nira ang patay da pala. Animan indi ra linapik nira tang mga bisit na. ");
INSERT INTO agn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Piro ang bindoat tang tata ong mga sondalo don, sina-sak na ta bangkaw tang silid ni Jesus ig golping limindoa tang dogo may wi. ");
INSERT INTO agn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ang mismong naita yay ang pagpamatod natetenged ong mga bagay ang na agod mamagparet amo. Tama tang pagpamatod na, ig gata-wanan nang poros matod tang agbabalita na. ");
INSERT INTO agn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ig ang mga bagay ang na nainabo enged agod magmatod tang na-tang ong Kasolatan ang ganing, “Anda enged ay malapik maski tata ong mga doli na.” ");
INSERT INTO agn_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ig may na-tang pa ong Kasolatan ang ganing, “Pa-dekan nira tang taw ang sina-sak nira.” ");
INSERT INTO agn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pagatapos ta si, napaning si Jose ang taga Arimatea don ong ni Pilato para maglisinsia mga poiding komiten na tang sinangoni ni Jesus ong kros. Si Jose ang na tata ka ong mga sinagpan ni Jesus, piro talok lamang tenged geldan tanandia ong mga pangolokolong Judio. Pinagnan ni Pilato si Jose, animan dayon ang kinomit na tang sinangoni ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Siminabid ong nandia si Nicodemo, ang yay ang napaning may tatang labi ong ni Jesus. Si Nicodemo, may ekel nang mabanglong bolong ang pambalsamo ang pinagsamporang mira may alo vera. Ang simbang na mga tolong polok may epat ang kilo. ");
INSERT INTO agn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Animan pagakomit nira tang sinangoni ni Jesus, tinabed-tabedan nira ta mga abel ang kolit ang bintangan tang bolong ang asi, sigon ong kaogalian tang mga Judio ong mga patay nira. ");
INSERT INTO agn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mandian, don alenget ong logar ang pinaglansangan ong ni Jesus, may tatang logar ang lindoakan ta mga ayo, ig don may ba-long bindoat ang lebengan ang midio koiba ang indi pa galbengan. ");
INSERT INTO agn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Animan tenged Kaldaw ang Palagsimpan tang mga Judio ig alenget lamang tang koibang asi, don da lamang limbeng nira si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pagkabot tang kaldaw ang Dominggo, asing maki-lep ki-lep pa, napaning da si Maria Magdalena ong lebengan ni Jesus. Kinabotan nang nakomit da pala tang mabael ang batong agdadapa ong portan tang lebengan. ");
INSERT INTO agn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pagaita na, dayon tanandiang nanikad ig napaning ong ni Simon Pedro may ong sinagpan ang agmalen ni Jesus ta mo-ya. Ganing si Maria ong nirang doroa, “Dali! Kinomit tang Gino ong lebengan! Indi mata-wanan amen mga ong aripa ingkelan!” ");
INSERT INTO agn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Animan pagabasi ni Pedro may ang sinagpan ang asi, dayon ang laging namansipaning don ong lebengan. ");
INSERT INTO agn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Namagsinikad tanirang doroa, piro tenged mas madasig tang tatang sinagpan, tanandia tang na-kaw ang nakabot. ");
INSERT INTO agn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dayon tanandiang siminokok ig simininek ong teled tang lebengan ang asing midio koiba. Inita na don tang mga abel ang kolit ang ginamit ong paglebeng ong ni Jesus, piro indi tanandia siminled. ");
INSERT INTO agn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Oman kiminabot da ka si Simon Pedro ig nagdiritso tanandiang siminled ong lebengan. Inita na ka tang abel ang kolit ");
INSERT INTO agn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","asta ang ta-leng ang binongot ong kolo ni Jesus. Ang ta-leng ang asi sinipig ig na-tang ong tatang binit, galbag ong domang mga abel. ");
INSERT INTO agn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Siminled da ka tang tatang asi ang na-kaw ang kiminabot, ig pagaita na, nagparet ang lagi ang naboi rang oman si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Piro maski maning don, indi pa gaintindian nira tang maliag yaning tang na-tang ong Kasolatan ang ganing kaministiran maboing oman si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Oman namansiolik ang lagi tang doroang mga sinagpan ang asi. ");
INSERT INTO agn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mandian, si Maria Magdalena ke-deng pa don ong loa tang lebengan ang pagini-yak. Mintras pagini-yak, siminokok tanandia ig simininek ong teled. ");
INSERT INTO agn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","May inita na don ang doroang anghil ang pamaglambong ta kolit. Don tanira kakarong ong bintangan tang sinangoni ni Jesus, ang tata gampir ong may kokoloan ig ang tata gampir ong kakayan. ");
INSERT INTO agn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ganing tang mga anghil ong ni Maria, “Babay, angay pagini-yaka?” Siminabat si Maria, “May nangomit tang sinangoni tang yen ang Gino ig indio gatako mga ong aripa ingkelan.” ");
INSERT INTO agn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pagabitala ni Maria ta si, minalied tanandia ig may inita nang tatang lali ang ke-deng don, piro indi nailala na ang asi pala si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Animan nane-ma ong ni Maria si Jesus ang ganing, “Angay pagini-yaka? Sinopay agdilemen mo?” Piro ang kalaom ni Maria ang laling narin yay ang manigsagod tang mga papa ta ayo don. Animan ganing tanandiang siminabat, “Mga yawa tang nangomit tang sinangoni na, itoldok mo kay ong yen mga ong aripa ingkelan mo agod komiteno.” ");
INSERT INTO agn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ganing si Jesus, “Maria!” Lagi-lagi siminalonga si Maria ong ni Jesus ig nabitala ong bitala tang mga Judio, “Raboni!” (Ang maliag yaning, “Maistro.”) ");
INSERT INTO agn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ganing si Jesus, “Indio kang lagi biotan mo! Tenged indio pa gabalik ong Tatayo. Ang boaten mo, paningan mo tang mga logodo ig begen mo ang yo magbaliko ra ong Tatayo ang ya kay ang Tatay mi, ong yen ang Dios ang ya kay ang Dios mi.” ");
INSERT INTO agn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Animan pinaningan ni Maria Magdalena tang mga sinagpan ni Jesus ig binalitan na ang inita na tang Gino. Ig bineg na ka ong nira tang sinoyon ni Jesus ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pagalabi, ang kaldaw kang asing Dominggo, namagsirimet-simet tang mga sinagpan ni Jesus ong tatang balay. Agtrangkan tang mga porta tenged dorong eled nira ong mga pangolokolong Judio. Ya kay ang pagkabot ni Jesus ig kimindeng ong ka-ngan nira. Ganing tanandia, “Asia ong nindio tang kao-yan tang Dios!” ");
INSERT INTO agn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Oman pinaita na ong nira tang mga boloat ong kalima na ig ong silid na. Dorong kalipay tang mga sinagpan pagaita nira ong Gino. ");
INSERT INTO agn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ig minaning sing oman si Jesus, “Asia ong nindio tang kao-yan tang Dios. Mga monopa yo sinobolo tang Tatayo, ya kay mandian agtobolon amo ka yen.” ");
INSERT INTO agn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Oman lininawan na tanira ig minaning, “Risibien mi tang Ispirito Santo, ");
INSERT INTO agn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","agod mga maning among napatawad da tang mga talak ta tatang taw, maliag yaning pinatawad ka kaman tang Dios. Piro mga maning among indi gapatawad tang mga talak na, maliag yaning indi ka pinatawad tang Dios.” ");
INSERT INTO agn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mandian si Tomas, ang aggoyan ta Kambal, tata ka ong tampolok may doroang sinagpan ni Jesus, piro anda don asing napaita si Jesus ong nira. ");
INSERT INTO agn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Animan binalitan tanandia tang mga karomanan nang sinagpan ang ganing, “Inita amen tang Gino!” Piro ganing si Tomas ong nira, “Indio enged magparet, asta indi itaeno tang boloat tang mga lansang ong kalima na ig igolō tang toldoko don, ig asta indi ka gagolō tang kalimao ong silid nang sina-sak.” ");
INSERT INTO agn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Oman, pagata-lib tang walong kaldaw, don si tanirang namagsirimet-simet ong balay ang asi ig mandian aroman da nira si Tomas. Maski agtrangkan si tang mga porta piro golpi sing siminled si Jesus ig kimindeng ong ka-ngan nira ig minaning, “Asia ong nindio tang kao-yan tang Dios.” ");
INSERT INTO agn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ig minaning ong ni Tomas, “Telekan mo tang mga kalimao ig igolo mo tang toldok mo tani. Igolo mo ka tang kalima mo tani ong silido. India ra magdoadoa, magpareta ra.” ");
INSERT INTO agn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dayon ang laging minaning si Tomas ong ni Jesus, “Yawa tang yen ang Gino ig Dioso!” ");
INSERT INTO agn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ganing si Jesus ong nandia, “Yawa, Tomas, pagtoa ra ong yen tenged initao ra nio mandian. Piro mas masoirti tang mga taw ang pamagto ong yen maski indi nangaita ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yadi pa enged ang makabebereng ang mga bagay ang bindoat ni Jesus ang inita mismo tang mga sinagpan na ang indi nagapil ang sinolat ong librong na. ");
INSERT INTO agn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Piro ang mga nasolat tarin, sinolat agod mamagparet amo ang si Jesus yay ang Cristo, ang Ana tang Dios, ig agod tenged ong pagto mi ong nandia, magkatinir amo ta kaboing anday kataposan. ");
INSERT INTO agn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pagata-lib tang pirapang kaldaw, napaita sing oman si Jesus ong mga sinagpan na, don ong binit tang baybay tang Talsi tang Tiberias. Maning ta na tang nainabo: ");
INSERT INTO agn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Pamagtabid da Simon Pedro, Tomas ang aggoyan ta Kambal, si Natanael ang taga Cana ang sakep tang Galilea, asta ang mga ana ni Zebedeo, ig doroa pang sinagpan ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mandian ganing si Simon Pedro ong mga aroman na, “Yo manilawo.” Ganing tanirang siminabat, “Ta ra! Tomabid ami.” Animan namansitay tanira ong bilog nirang mabael ig namampalaod. Piro maski namagdamal da ong laod, andang pisan ay nakomit nira. ");
INSERT INTO agn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Asing pangayag-ayag da, may inita nirang ke-deng ong binit tang baybay, piro indi nailala nira ang asi pala si Jesus. ");
INSERT INTO agn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ini-gan tanira ni Jesus ang ganing, “Mga tangay, yading nakomit mi?” “Andang pisan!” tang sabat nira. ");
INSERT INTO agn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Oman minaning si Jesus ong nira, “Ibo-log mi tang lambat mi atan mampir ong to tang bilog mi, ig sia may makomit mi.” Animan bino-log nira tang lambat don, ig asing bataken da nira, indi ra mangadeg tenged kadoro-doroan ang yan tang nakomit nira. ");
INSERT INTO agn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Animan ang sinagpan ang agmalen ni Jesus ta mo-ya tang minaning ong ni Pedro, “Ang Gino si!” Pagabasi lamang ni Pedro, dayon ang nagtok tang lambong na, tenged pagloat tanandia, ig limino-bo ong talsi para paning ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ang mga aroman nang sinagpan namampabaybay da ka ang pamagtay tang bilog ig pamagbeteng tang lambat ang ponok ta yan. Alenget lamang tanira ong baybay, sigoro mga siam ang polok ang mitro lamang tang kalawid nira. ");
INSERT INTO agn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pagatampet nira ong baybay, inita nirang may koring ang nagbala ra ig may yan ang agkiawen, ig may tinapay ka. ");
INSERT INTO agn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ganing si Jesus ong nira, “Magekel amo tani ta pirapang bilog ang yan ang nakomit mi.” ");
INSERT INTO agn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Animan siminay si Simon Pedro ong bilog ig bineteng na tang lambat ong binit tang baybay, ang ponok ta yan ang mababael. Na bali tang gatos may limampolok may tolong tanan. Piro indi enged nalasik tang lambat maski maning da don agkayadi. ");
INSERT INTO agn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Oman minaning si Jesus ong nira, “Tani amo, mamamaw ita ra.” Piro gangaeyak tanira ang mane-ma mga sinopa enged tanandia, tenged gata-wanan nira ang tanandia tang Gino. ");
INSERT INTO agn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Oman kinomit ni Jesus tang tinapay ig sindol na ong nira, asta ang yan ang kindiaw. ");
INSERT INTO agn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na ya-lo rang bisis ang napaita si Jesus ong mga sinagpan na pagatapos ang tanandia naboing oman. ");
INSERT INTO agn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pagatapos nirang namamangan, sine-ma ni Jesus si Simon Pedro ang ganing, “Simon, ana ni Juan, aggegmano nio sobra pa ong mga aroman mong narin?” Siminabat si Pedro, “Ee, Gino, gata-wanan mong aggegmana yen.” Ganing si Jesus, “Animan papanen mo tang yen ang mga karniro.” ");
INSERT INTO agn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ig sine-ma na si si Pedro ang ganing, “Simon, ana ni Juan, aggegmano nio?” Ganing si ka si Pedro, “Ee, Gino, gata-wanan mong aggegmana yen.” Minaning si si Jesus, “Sagodon mo tang yen ang mga karniro.” ");
INSERT INTO agn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ong ya-lo rang bisis ang te-ma ni Jesus, ganing sing oman, “Simon, ana ni Juan, aggegmano enged nio?” Nagsinti ra si Pedro tenged tolo rang bisis ang sine-ma tanandia ni Jesus mga aggegman na. Animan ganing si Pedro, “Gino, gata-wanan mo tang tanan ang bagay! Gata-wanan mong agmalena yen!” Siminabat ka si Jesus, “Papanen mo tang yen ang mga karniro.” ");
INSERT INTO agn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ig ganing pa, “Asing molā pa, yawa tang panimara tang lambong mo ong sadili mo ig pagpanawa maski ong ariapa galiag ang paning. Piro tandan mo: Mga mepeta ra, yonat mo tang mga kalima mo, may maglapot ong nio ig ekelana nira ong logar ang india galiag ang paning.” ");
INSERT INTO agn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Maning ta na tang bitala ni Jesus para ipatako na mga monopa mapatay si Pedro, ig ong kamatayen nang asi, mapagtorol tanandia ta mabael ang dengeg ong Dios. Pagatapos ta si, ganing si Jesus ong ni Pedro, “Magosoya ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Minalied si Pedro ig inita nang dadaton ong nira tang sinagpan ang agmalen ni Jesus ta mo-ya. Narin yay ang siminandig ong debdeb ni Jesus asing pamanapon tanira ig nane-ma mga sinopa tang magtraidor ong nandia. ");
INSERT INTO agn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Animan pagaita ni Pedro, ganing tanandia ong ni Jesus, “Gino, ang taw ang asia, onopay nandiang mapasaran?” ");
INSERT INTO agn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Piro siminabat si Jesus, “Mga galiliago ang indi tanandia mapatay asta magbaliko tarin ong kalibotan, onoray nio? Basta yawa, magosoya lamang ong yen.” ");
INSERT INTO agn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Animan tenged ong inaning ang asi ni Jesus, nabantog tang balita ong mga pamagto ang indi ono mapatay tang sinagpan nang asi. Piro si Jesus indi minaning ta maning don, kondi ganing lamang, “Mga galiliagong indi tanandia mapatay asta ong pagbaliko, onoray nio?” ");
INSERT INTO agn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yo tang sinagpan nang asi. Ig yo tang pagpamatod natetenged ong mga bagay ang na, ig yo mismo tang nagsolat ta narin. Ig gata-wanan amen ang tanan ang sinolato matod. ");
INSERT INTO agn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Doro pang mga bagay ang bindoat ni Jesus ig mga isolat tang tanan, sigoro indi magigo ong bilog ang kalibotan tang tanan ang librong boaten.");
INSERT INTO agn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Agmalenong Teofilo, ong yen ang primirong libro nasayodo ra tang tanan ang bindoat ig sinoldok ni Jesus impisa asing tokaw ");
INSERT INTO agn_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","asta ong kaldaw ang ingkelan tanandia ong langit. Ba-lo tanandia ingkelan ong langit, ang mga pinilik nang mga apostolis sinoyonan na ong gaem tang Ispirito Santo. ");
INSERT INTO agn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pagatapos tang pagpinitinsia ni Jesus ong kros, dorong bisis ang tanandia napaita ong mga apostolis na ig dorong bindoat na agod masigoro enged tanira ang binoi ra tanandiang oman. Napaita tanandia ong teled ta epat ang polok ang kaldaw ig nagtoldok tang natetenged ong paggaraemen tang Dios bilang adi. ");
INSERT INTO agn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","May naminta, asing aroman pa si Jesus tang mga apostolis, nagordin tanandia ong nira ang ganing, “Indi amo kang lagi magalin ong Jerusalem, kondi elaten mi tang Ispirito Santong pinangako tang Dios ang Tatay, ang asing inaningo ra ong nindio asing tokaw pa. ");
INSERT INTO agn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Si Juan nagboniag ong mga taw ta wi, piro yamo pirapang kaldaw boniagan amo ra ta Ispirito Santo.” ");
INSERT INTO agn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Asing namagsirimet-simet si Jesus ig ang mga apostolis na, sine-ma nira tanandia ang ganing, “Gino, boaten mo rang moman mandian tang inadian tang Israel?” ");
INSERT INTO agn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ganing tanandiang siminabat, “Ang mga timpo ig mga takon inariglo ra tang Tatay ong sadiling aotoridad ig kaliliagan na. Belag ta kaministiran ang mata-wanan mi pa. ");
INSERT INTO agn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Piro pag kabot tang Ispirito Santo ong nindio, oldan amo nandia ta gaem, ig magpamatod amo natetenged ong yen ong siodad tang Jerusalem, ong bilog ang mga probinsia tang Judea ig Samaria, asta ra lamang ong kataliposposan tang kalibotan.” ");
INSERT INTO agn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagabitala na ta si, ingkelan da tanandia ong langit mintras pamansipa-dek ong nandia tang mga sinagpan na, asta nampilan tanandia ta onom. ");
INSERT INTO agn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mintras pamansipa-dek pa tanira ong langit, may doroang laling paglambong ta kolit ang golping napaita ong binit nira. ");
INSERT INTO agn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ganing tanira, “Yamong mga taga Galilea, angay atan amo pang pamansipa-dek ong langit? Ang Jesus ang nang kinomit ong nindio ig ingkelan ong langit, magbalik pa tarin. Inita mi mandian mga monopa tanandia ingkelan ong langit. Maning atan ka tang pagbaraliken na.” ");
INSERT INTO agn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mandian, namagbalik tang mga apostolis ong Jerusalem ang namagalin ong Bokid tang Kaoliboan, mga tatang kilomitro tang kalawid na ong siodad. ");
INSERT INTO agn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pagakabot nira ong siodad, nagdiritso tanira ong koarto ong dibabaw tang balay ang agdayonan nira. Ang mga taw ang na ay da Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, si Santiago ang ana ni Alfeo, si Simon ang Makabanoa, ig si Judas ang ana ni Santiago. ");
INSERT INTO agn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tanirang tanan pirming pamagsirimet-simet para mamangadi, aroman nira tang mga babay ig si Maria ang nanay ni Jesus, asta ang mga logod ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pagata-lib tang pirapang kaldaw, namagsimet-simet tang mga pamagto ong ni Jesus. Mga tang gatos may doroang polok tanirang tanan. Dayon ang kimindeng si Pedro ong tokawan nira ig minitala. ");
INSERT INTO agn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ganing tanandia, “Mga logod, kaministiran ang mainabo tang ga-tang ong Sagradong Kasolatan, ang pinabitala tang Ispirito Santo ong ni David asing tokaw natetenged ong ni Judas, ang yay ang nagated ong mga namagdep ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tanandia tata ka ong yamen ang pinilik ni Jesus, ig aroman amen ong obra amen.” ");
INSERT INTO agn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mandian, ang koartang binayad ong ni Judas ong bindoat nang anday sayod ay binakal na ta tanek, ig don tanandia nabo-log ang pake-keb. Nabo-dik tang sian na ig limindoa tang bi-wa na. ");
INSERT INTO agn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ang nainabong na nabalitan tang tanan ang mga taw ong Jerusalem. Animan ong sadiling bitala nira pinaranan nira tang tanek ang asi ta Akeldama, ang maliag yaning “Tanek ang binayadan ta dogo.” ");
INSERT INTO agn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ganing pa si Pedro, “Tenged narin tang inaning ni David ang na-tang ong libro tang mga Salmo, ‘Pabayan da lamang malangga tang inistaran na, ig anday paistaren don ang maski sinopa.’ Ig ganing pa, ‘I-dol da lamang ong doma tang obligasion na.’ ");
INSERT INTO agn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Animan dapat mamilik ita ta tanga tawan ang māroman amen ang magpamatod natetenged ong pagaboing moman ni Ginong Jesus. Kaministiran tanandia tata ka ong mga taw ang pirming tatabid ong yamen ong mga kaldaw ang si Ginong Jesus tarin pa ong tanek ang paglibot-libot ang pagtoldok, impisa asing binoniagan tanandia ni Juan asta ra lamang ingkelan ong langit.” ");
INSERT INTO agn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Animan namilik tanira ta doroang lali— si Matias ig si Jose ang aggoyan ta Barsabas (ang aggoyan ka ta Justo). ");
INSERT INTO agn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Namangadi tanirang ganing, “Gino, yaway gatako tang mga popotokon tang tanan ang mga taw. Ipaita mo ong yamen mga sinopa ong nirang doroa tang piliken mo ");
INSERT INTO agn_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ang magimong apostolis bilang katelet ni Judas. Tenged si Judas, bino-wanan na tang obra na asing napaning tanandia don ong logar ang dapat para ong nandia.” ");
INSERT INTO agn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tapos namagpabonlokan tanira, ig ang aran ni Matias tang nabonlok. Animan si Matias na-pen da ong tampolok may tatang mga apostolis. ");
INSERT INTO agn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Asing kiminabot tang kakaldawan tang Pentecostes, namagsirimet-simet ong tanga balayan tanirang tanan ang pamagto ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Golping may ingal ang pagalin ong langit, ig mga pama-yan nira midio mageyep ang babagrong. Poro ra lamang lago-lot tang naba-yan nira ong intirong balay ang agpagsimet-simetan nira. ");
INSERT INTO agn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","May inita pa nirang midio mga dilak ta apoy ang agpababak ong kada tata ong nira. ");
INSERT INTO agn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ig tanirang tanan ginaeman tang Ispirito Santo ig dayon ang namagbitala ta sari-saring mga bitala, sigon ong gaem ang sindol ong nira tang Ispirito Santo. ");
INSERT INTO agn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mandian, don ong Jerusalem may mga Judiong rilihioso ang namagalin ong sari-saring mga logar ong bilog ang kalibotan. ");
INSERT INTO agn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pagabasi nira tang ingal ang asi, namagsimet-simet da tang mga taw. Doro tang pagkabereng nira tenged ang kada tata gangabasi tang sadiling mga bitala nira ang agbibitala tang mga sinagpan ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ong kabeberengen nira ganing tanira, “Belag bato ta taga Galilea tang tanan ang asiang pamansibitala? ");
INSERT INTO agn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Piro angay? Kada tata ong yaten, ang gaba-yan ta ong nira mga sadiling bitala ta! ");
INSERT INTO agn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ang doma ong yaten mga taga Partia, mga taga Media, mga taga Elam, mga gingistar ong Mesopotamia, ong Judea ig ong Capadocia, ong Ponto ig ong Asia, ");
INSERT INTO agn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ong Frigia ig ong Pamfilia, ong Ehipto ig ong mga parting Libia ang sakep tang Cirene. May mga gingistar ong Roma, mga kapario tang mga Judio asta mga belag ta Judio ang nala-ted ong rilihion ta. ");
INSERT INTO agn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","May mga taga Creta ig taga Arabia. Onora ka enged ang gaba-yan ta ong mga taw ang narin ong yaten ang sadiling mga bitala tang natetenged ong mga makabebereng ang mga bindoatan tang Dios?” ");
INSERT INTO agn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nangagolpian tanirang tanan ig belag lamang ta ge-ley tang kabeberengen nira. Namagte-ma te-man tanira, “Onopa enged tang maliag yaning tang gainabong narin?” ");
INSERT INTO agn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Piro namanginsolto tang doma ang ganing, “Baleng tang mga taw ang asia!” ");
INSERT INTO agn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mandian, kimindeng si Pedro ig ang tampolok may tatang mga aroman na, ig minitala tanandia ong mga taw ta dorog kapoirsa. Ganing, “Mga kasimanoao ang mga Judio ig yamong tanan ang pamansistar tarin ong Jerusalem! Pama-yan mi ta mo-ya tang yaningo ong nindio. ");
INSERT INTO agn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Belag ta baleng tang mga taw ang narin, pario tang kalaom mi. Alas noibi pa lamang tang damal-damal! ");
INSERT INTO agn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ang gainabo mandian, yay ang binitala tang propitang si Joel asing tokaw ang ganing, ");
INSERT INTO agn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Narin tang boateno ong mga oring kaldaw,’ ganing tang Dios. ‘Bogos ang i-dolo tang yen ang Ispirito ong tanan ang taw. Ang mga ana ming mga lali ig mga babay ay mamagpakabot tang yen ang bitala. Ang mga soltiros mi mangaita tang mga ipaitao ong nira. Ig ang mga mepet ming mga lali mamanalakinep. ");
INSERT INTO agn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Komabot kaman tang mga kaldaw ang bogos ang i-dolo tang yen ang Ispirito ong tanan ang mga torobolono, mga lali ig mga babay. Ig mamagpakabot tanira tang yen ang bitala. ");
INSERT INTO agn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Magpaitao ta mga makabebereng ang mga bagay ong langit, ig mga pasinial tarin ong tanek, pario ta dogo, apoy ig madamel ang kato. ");
INSERT INTO agn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mangi-lep tang kaldaw, ig manisinggi tang bolan ang midio dogo, ba-lo komabot tang makaeled ig makabebereng ang kaldaw ang magosgar tang Gino. ");
INSERT INTO agn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ig mangalibri tang maski sinopay gomoy ong Gino.’ ” ");
INSERT INTO agn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ganing pa si Pedro, “Mga kasimanoao ang mga taga Israel, pama-yan mi tang ibitalao. Si Jesus ang taga Nazaret ay sinobol tang Dios. Pinamatodan tang Dios narin ong nindio ong mga milagro, mga makabebereng ang bagay ig mga pasinial ang pinaboat na ong nandia. Gata-wanan mi na, tenged ang tanan nainabo tarin ong nindio. ");
INSERT INTO agn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Gata-wanan ang lagi tang Dios asing tokaw pa ang si Jesus yintriga ong nindio tenged yay ang lagi tang plano na. Ig ang bindoat mi, pinapatay mi tanandia ong mga mapinagtalaken ang naglansang ong nandia ong kros. ");
INSERT INTO agn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Piro tanandia binoing oman tang Dios ig linibri ong gaem tang kamatayen. Tenged maski kamatayen pa, anday gaem nang magawid ong nandia. ");
INSERT INTO agn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Narin tang inaning ni David asing tokaw natetenged ong nandia: ‘Gata-wananong pirming tatabid ong yen tang Gino, ig indio agbo-wanan na, animan indio agkelban. ");
INSERT INTO agn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Narin tang dailan ang galipayo ta mo-ya, ig pagdayawo ong Dios! Ig panalig tang nemo ang maski mapatayo, may masinlong parakaboton pa tang sinangonio. ");
INSERT INTO agn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tenged ang kalago indi pabayan mo ong logar tang mga patay, ig indi ka pabayan mong maronot tang sinangonio, yo tang niong sagradong torobolon. ");
INSERT INTO agn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sinoldok mo ra ong yen tang mga dalan ang paning ong kaboi. Ig tenged pirmiang ka-peno, galipayo ta mo-ya.’ ");
INSERT INTO agn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mga kasimanoao,” ganing pa si Pedro, “Mga natetenged ong yaten ang kamepet-mepetan ang si David, maningo ta mayag ong nindio, ang tanandia napatay ig limbeng. Ig gata-wanan ta ang asta mandian ang lebengan na atan pa ka. ");
INSERT INTO agn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tanandia propita ig gata-wanan na tang pinangako ong nandia tang Dios, nga ang tata ong mga inampo na magimong ading kapario na. ");
INSERT INTO agn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Gata-wanan nang lagi tang natetenged ong pagaboing moman tang Cristo. Animan ganing tanandia ang indi ono pabayan tang kalag na ong logar tang mga patay, ig indi maronot tang sinangoni na. ");
INSERT INTO agn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Si Jesus, yay ang binoi tang Dios. Ig yaming tanan mapagpamatod ong mga bagay ang narin tenged mismong inita amen. ");
INSERT INTO agn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Asing pinalawig si Jesus ig pinakarong ong to tang Dios, rinisibi na tang Ispirito Santong pinangako tang Tatay na ang i-dol ong nandia. Ig narin bogos ang sindol na ong yamen, pario tang gitaen ig gaba-yan mi mandian. ");
INSERT INTO agn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tenged belag ta si David tang kimina-yat ong langit, kondi tanandia tang minaning, ‘Ganing tang Ginong Dios ong yen ang Gino: “Komaronga ong yen ang to, ");
INSERT INTO agn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta ra lamang pasokono ong nio tang tanan ang kasoay mo.” ’ ");
INSERT INTO agn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Animan, dapat ang enged ang mata-wanan tang tanan ang taw ong banoang Israel ang nang si Jesus ang linansang mi ong kros, yay ang bindoat tang Dios ang Gino ig Cristo.” ");
INSERT INTO agn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Asing naba-yan narin tang mga taw, natandeg tang mga popotokon nira, ig ganing tanira ong ni Pedro ig ong domang mga apostolis, “Mga logod, onopa tang boaten amen?” ");
INSERT INTO agn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Siminabat si Pedro, “Magtogat amo ig bo-wanan mi tang mga kasalanan mi, ig magpaboniag tang kada tata ong nindio agod ipaita ang nagpasakep amo ong ni Jesu-Cristo. Maning ta si, patawaden amo ig marisibi mi tang i-dol tang Dios ong nindio, ang yay ang Ispirito Santo. ");
INSERT INTO agn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tenged ang pangakong na ay para ong nindio ig ong mga ana mi, asta ong tanan ang mga taw ang alawid ong yaten, ang maski sinopay goyan tang Ampoan tang Dios ang palenget ong nandia.” ");
INSERT INTO agn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Doro pang inaning ni Pedro ang pagpamatod ong mga binitala na. Ig pinandaman na tanira ang ganing, “Palawid amo ong mga malalain ig mapinagtalaken ang taw agod malibri amo.” ");
INSERT INTO agn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Animan, ang namagparet ong mga binitala na ay namagpaboniag. Ig ong kaldaw ang asi nadolangan ta tolong ribong taw tang mga pamagto ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Padayon tanirang pamagadal tang mga agtotoldok ong nira tang mga apostolis, pamagsirimet-simet bilang mamaglogod ong Gino, pamagsaro ig pamangadi. ");
INSERT INTO agn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Dorong mga milagro ig mga makabebereng ang mga bagay ang pinaboat tang Dios ong mga apostolis, animan ang mga taw nagkatinir ta paggalang ig eled ong Dios. ");
INSERT INTO agn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Masinlo tang pagtarabidan tang mga pamagto ong ni Jesus, ig maski onopay pagkabetang nira pamagparti-parti tanirang tanan. ");
INSERT INTO agn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Agpabakal nira tang mga pagkabetang nira, ig ang bayad na agparti-partien nira sigon ong kaministiran tang kada tata. ");
INSERT INTO agn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kaldaw-kaldaw pamagsirimet-simet tanirang tanan ong Timplo. Pamagsaro tanira bilang mamaglogod ong Gino ong mga balay nira ig pamamangan tanira ang mambeng tang popotokon nira. ");
INSERT INTO agn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pamagdayaw tanira ong Dios ig gangalipay ka ong nira tang mga taw, ig kaldaw-kaldaw agdodolang tang Gino ong nira tang mga taw ang aglilibri na. ");
INSERT INTO agn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","May naminta alas tris tang apon, oras dang igparangadi, napaning si Pedro doroa ni Juan ong Timplo. ");
INSERT INTO agn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mandian, don ong Timplo ong portan ang aggoyan ta “Masinlo,” may tatang taw ang pilay tanandia mimpisang ipangana. Kaldaw-kaldaw agge-lan tanandia don agod magpalimos ong mga taw ang pamansi-led ong Timplo. ");
INSERT INTO agn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Asing itaen na si Pedro ig si Juan ang te-led don ong Timplo, nagpalimos tanandia ong nira. ");
INSERT INTO agn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pina-dekan tanandia tang doroa, ig ganing si Pedro ong nandia, “Pa-deka ong yamen!” ");
INSERT INTO agn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ang kalaom tang taw, limosan nira ra tanandia, animan dayon ka tanandiang napa-dek ong nira. ");
INSERT INTO agn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ganing si Pedro ong nandia, “Anday koartao ang ma-dolo ong nio. Piro may domang i-dolo ong nio. Ong gaem ni Jesu-Cristong taga Nazaret, panawa!” ");
INSERT INTO agn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tapos bindiotan ni Pedro tang kalimang to tang taw ig sinabangan nang kendeng. Lagi-lagi namoirsa tang mga kakay ig mga pokol-pokolan na. ");
INSERT INTO agn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Golpi tanandiang limino-tong kimindeng ig nagpanaw-panaw. Pagatapos, siminabid tanandiang siminled ong Timplo ang papanaw-panaw ig lolo-to lo-to ig pagdayaw ong Dios. ");
INSERT INTO agn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Inita tanandia tang mga taw ang papanaw-panaw tanandia ig pagdayaw ong Dios. ");
INSERT INTO agn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ig asing mata-wanan nirang tanandia pala tang pirming kakarong ig pagpalimos ong Masinlong Portan tang Timplo, pisan ang nangabereng tanira ong nainabong asi. ");
INSERT INTO agn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Asing pambiot pa tang taw ang asi ong ni Pedro ig ni Juan don ong logar ang aggoyan ta Alalan ni Solomon, pamansisikad dang agpalenget tang mga taw ong sobrang kabeberengen nira. ");
INSERT INTO agn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pagaita ni Pedro ong mga taw, ganing tanandia, “Mga kasimanoao ang mga Israelita, angay gangabereng amo ta mo-ya? Angay pa-dek amo ta maning atan? Itaben maning amo ang yami tang nagpapanaw ong nandia ong sadiling gaem amen, obin bato ong yamen ang pagkamadinioson. ");
INSERT INTO agn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Belag ang enged! Ang Dios ang agtowan ni Abraham, ni Isaac ig ni Jacob, ang yay ang Dios tang yaten ang kamepet-mepetan, tanandia tang nagboat ta narin agod padengegan na tang Torobolon nang si Jesus. Si Jesus tang inintriga mi ong mga aotoridad ig pinangindian mi ong talongan ni Pilato maski nadisisionan na rang palpatan tanandia. ");
INSERT INTO agn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Sinaliodan mi tang Sagrado ig Mato-lid, ig ang pina-dol ming palpatan tatang manigpatay ta taw. ");
INSERT INTO agn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pinatay mi tang manigtorol ta kaboi. Piro tanandia binoing oman tang Dios, ig mga tistigos ami ta asia. ");
INSERT INTO agn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ang gaem ni Jesus tang nagpao-ya ong taw ang nang gailala mi ig agpa-dekan mi. Nainabo narin tenged ong pagtalig ong aran ni Jesus. Pagtalig ka kaman ong ni Jesus tang bogos ang nagpao-ya ong nandia, pario tang gitaen mi. ");
INSERT INTO agn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mandian, mga logod, gata-wananong indi naintindian mi tang mga bindoat mi. Maning ka ta si tang mga pangolokolo ong nindio. ");
INSERT INTO agn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Piro ong bindoat ming asia, nagmatod tang pinabalita tang Dios ong mga propita asing tokaw pa, ang kaministiran ang magpinitinsia tang Cristo. ");
INSERT INTO agn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Animan magtogat amo ong mga talak mi ig magbalik amo ong Dios agod komiten na tang mga talak mi, ");
INSERT INTO agn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ig komabot tang mga kaldaw ang oldan amo nandia ta ba-long poirsa. Ig tobolon na ong nindio si Jesus ang Cristong pinilik na asing tokaw pa. ");
INSERT INTO agn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Piro si Jesus don kang lagi ong langit asta komabot tang timpong ba-lon tang Dios tang tanan ang bagay, sigon ong inaning na ong mga sagradong propita na impisa asing tokaw pa. ");
INSERT INTO agn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pario tang inaning ni Moises, ‘Ang Ampoan ming Dios mamilik ta tata ong nindio ang boaten nang propita pario ong yen. Kaministiran ang pama-yan mi tang tanan ang yaning na ong nindio. ");
INSERT INTO agn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ig ang tanan ang indi mamasi ong propitang asi, ipalbag tanira ong mga tawan tang Dios ig patayen ang enged.’ ");
INSERT INTO agn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Animan ang tanan ang mga propita, magimpisa ong ni Samuel asta ong mga diminaton ong nandia, namagpatako tanirang tanan tang natetenged ong mga gangainabo ong mga kaldaw ang narin. ");
INSERT INTO agn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ang pangako tang Dios ong mga propita ay para ong yaten ang mga Judio, ig gapil ita ong sagradong pinaginigoan ang bindoat tang Dios ong mga kamepet-mepetan ta asing inaning na ong ni Abraham ang, ‘Gamiteno tang mga inampo mo agod aloyan tang tanan ang mga taw.’ ");
INSERT INTO agn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Animan sindol tang Dios tang Torobolon na, ig primiro ong yaten pinapaning na agod aloyan ita ig tabangan itang tanan ang bo-wanan tang mga boat ta ang anday sasayod.” ");
INSERT INTO agn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Asing bibitala pa si Pedro ig si Juan ong mga taw, namansikabot da tang mga padi, ang kapitan tang mga goardia ong Timplo, asta ang mga Saduseo. ");
INSERT INTO agn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gengerepan tanira tenged pagtoldok si Pedro ig si Juan ong mga taw ang si Jesus binoi ong kamatayen, ig asia ono pagpamatod ang maboing moman tang mga patay. ");
INSERT INTO agn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Animan dayon ang dinep nira tang doroa ig pina-led ong prisoan. Ig tenged alikarem da, bino-wanan da lamang tanirang doroa don ong prisoan asta naramal. ");
INSERT INTO agn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Piro dorong nangabasi ong sinoldok nira tang namagparet. Ang mga lali lamang mga limang ribo rang lagi. ");
INSERT INTO agn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pagaramal namagbaragat-bagat ong Jerusalem tang mga pangolokolo ong mga Judio, ang mga mepet, ig ang mga manigtoldok tang Katobolan. ");
INSERT INTO agn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Don ka tang pangolokolo ong mga padi ang si Anas doroa ni Caifas, asta si Juan ig si Alejandro, ig ang domang mga mimbro tang pamilia tang pangolokolo ong padi. ");
INSERT INTO agn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pinatalonga nira tang doroang apostolis ig sine-ma nira ang ganing, “Onopang gaemay tang aggamiten mi? Ong ninopang aran agboaten mi tang mga bagay ang asia?” ");
INSERT INTO agn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Siminabat si Pedrong aggaeman tang Ispirito Santo, “Yamong pangolokolo ong banoa ig mga mepet, ");
INSERT INTO agn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mga agte-maen ami nindio mandian natetenged ong kao-yan ang naboat amen ong taw ang pilay ang narin ig mga monopa tanandia nago-ya, nani tang maning amen. ");
INSERT INTO agn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Dapat mata-wanan ming tanan ig ang tanan ang mga taga Israel, ang taw ang nang ke-deng ong talongan mi, mo-ya ra tenged ong gaem ni Jesu-Cristong taga Nazaret, ang linansang mi ong kros piro binoing oman tang Dios. ");
INSERT INTO agn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ang Jesus ang narin yay ang agsambiten ong Kasolatan ang ganing, ‘Ang batong pinlek mi, yamong mga manigpa-deng ta balay, yay ang ginamit tang Dios ig nagimong kaimportantian ong tanan ang batong pagpabaked tang balay.’ ");
INSERT INTO agn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Poira ong ni Jesus, anda ra enged ay maski sinopang mapaglibri ong yaten. Tenged tanandia enged lamang tang sindol tang Dios tarin ong ta-paw tang kalibotan agod malibri ita ong mga talak ta.” ");
INSERT INTO agn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nangabereng tang mga namagimbistigar ang si Pedro ig si Juan dorog kaiteg tang nem nirang magbitala, ig labi pa enged asing mata-wanan nirang mga ordinariong taw ka lamang ig indi napamagadal. Oman nata-wanan nira tang doroang narin mga aroman pala ni Jesus asing tokaw. ");
INSERT INTO agn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Piro tenged inita nira tang taw ang nago-ya ang ke-deng ong tepad ni Pedro doroa ni Juan, anday maning nira kontra ong nirang doroa. ");
INSERT INTO agn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Animan pinaloa nira tang doroa, ig namagampang-ampang tang mga opisialis ang ganing, ");
INSERT INTO agn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Onopa tang boaten ta ong doroang asia? Tenged nabantog da tarin ong bilog ang Jerusalem tang makabebereng ang milagrong nang bindoat nira, ig indi ita mapaganing ang na bo-li. ");
INSERT INTO agn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ang boaten ta para indi ra magwasag tang agtotoldok nira, pamanan ta tanira ang indi ra enged mamansibitala maski ong ninopa tang natetenged ong ni Jesus ang asi.” ");
INSERT INTO agn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Animan ginoyan nirang oman si Pedro ig si Juan ang magbalik ong teled, ig inordinan nira ang indi ra enged mamansibitala obin mamagtoldok natetenged ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piro siminabat si Pedro ig si Juan ang ganing, “Ong aypa tang mato-lid ong pama-dek tang Dios, ang magtoman ami ong nindio obin ong nandia? Yamo tang magosgar. ");
INSERT INTO agn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mga ong yamen, indi maimong indi ami mamagbitala natetenged ong inita ig naba-yan amen.” ");
INSERT INTO agn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Piro pinamanan pa enged tanirang oman tang mga pangolokolo, ig pagatapos dayon da tanirang pinalpatan. Maski gangaliliag pang kastigon nira tang doroa, anda enged ay maisip nirang midios tenged ang tanan ang mga taw pamagdayaw ong Dios ong nainabo. ");
INSERT INTO agn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tenged ang taw ang nago-ya ong milagrong narin sobra ra ong epat ang polok ang takon tang idad na. ");
INSERT INTO agn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Asing napalpatan da si Pedro ig si Juan, namagbalik da tanira ong mga karomanan nira ig binalita nira tang inaning tang mga pangolokolong padi ig ang mga mepet. ");
INSERT INTO agn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ig pagabasi nira ta na, boliog tanirang tanan ang nangadi ong Dios ang ganing, “Ampoan amen ang makagagaem ong tanan, yawa tang nagboat tang langit ig tanek, asta ang talsi ig ang tanan ang na-tang tarin. ");
INSERT INTO agn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yawa tang nagpabitala ong torobolon mong si David asing tokaw ong gaem tang Ispirito Santo ang ganing, ‘Angay dorong kasisilagen tang mga belag ta Judio? Ig angay ang mga taw pamagisip ta planong anday kointa na? ");
INSERT INTO agn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ang mga adi ong tanek pamagsimpan ang mamansibatok, ig ang mga pangolokolo pamagsirimet-simet para kontraen nira tang Gino ig ang nandiang Cristo.’ ");
INSERT INTO agn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Maning ang enged ta si tang bindoat ni Herodes ig ni Poncio Pilato. Namagbaragat-bagatan tanira tarin ong siodad, aroman tang domang mga belag ta Judio ig asta ka ang mga Judio, agod kontraen tang sagradong Torobolon mo, ang yay si Jesus ang pinilik mong magimong adi. ");
INSERT INTO agn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ong bindoat nirang asi, nainabo tang pinlano mo rang lagi asing tokaw sigon ong gaem ig ong kaliliagan mo. ");
INSERT INTO agn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ig mandian, Ampoan amen, pama-yan mo tang mga paeled-eled nira ong yamen. Tabangay ami ka nio, yaming mga torobolon mo, ang bogos ang mangiteg tang nem amen para mitala tang bitala mo. ");
INSERT INTO agn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipaita mo tang gaem mo ong pagpao-ya tang mga taw ang may masit, ig pagnan mong may mga milagro ig mga makabebereng ang mangaimo ong aran tang sagradong Torobolon mong si Jesus.” ");
INSERT INTO agn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagatapos tang pangadi nira, kiminedeg tang logar ang agpagsimetan nira. Tanirang tanan ginaeman tang Ispirito Santo ig nangiteg tang nem nirang namagbitala tang bitala tang Dios. ");
INSERT INTO agn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ang mga pamagto ong ni Jesus pamaginigoan ig tanga isipan lamang tanira. Maski sinopa ong nira, anday ganing ang pagkabetang nira ong nira lamang, kondi koromon tanira ong tanan ang bagay. ");
INSERT INTO agn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ang mga apostolis nagkatinir ta mabael ang gaem ong pagpamatod natetenged ong moman ang pagaboi ni Ginong Jesus. Ig tanirang tanan inaloyan ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Anda enged ay maski sinopa ong nira tang nalisedan. Tenged ang mga may tanek obin mga may balay agpabakal nira ig ang koarta agge-lan nira ");
INSERT INTO agn_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ang aggintriga ong mga apostolis agod narin ma-dol ong mga karomanan nira kompormi ong kaministiran tang kada tata. ");
INSERT INTO agn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Maning ta si tang bindoat ni Jose ang tatang manigtabang ong Timplo ang taga Cyprus. Animan “Bernabe” tang ginoy ong nandia tang mga apostolis, tenged ang maliag nang yaning “Masinabangen.” ");
INSERT INTO agn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ang bindoat na, pinabakal na tang koma na ig ang bayad ingkelan na ig inintriga ong mga apostolis. ");
INSERT INTO agn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Piro don may magkatawa kang nagpabakal tang tanek nira. Ananias tang aran tang lali ig Safira tang aran tang babay. ");
INSERT INTO agn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ig gata-wanan ka tang katawa nang binoinan ni Ananias tang bayad na ba-lo ingkelan ong mga apostolis. ");
INSERT INTO agn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ganing si Pedro ong nandia, “Ananias, angay napadeg-dega ong ni Satanas ig nagbo-lia ong Ispirito Santo? Angay binoinan mo tang bayad tang tanek mo? ");
INSERT INTO agn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ang tanek, belag bato ta nio ba-lo pinabakal mo? Ig asing binakal da, belag pa bato ta yawa tang may podir mga ondion mo pa tang bayad na? Angay naisipan mong magboat ta maning ta sia? India nagbo-li ong taw, kondi ong Dios.” ");
INSERT INTO agn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pagabasi ni Ananias tang inaning ni Pedro, natomba tanandia ig napatay. Ig ang tanan ang nangabasi tang nainabong asi pinangeldan ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ang mga soltiros dayon ang napalenget, binongot nira tang sinangoni ni Ananias, ingkelan nira ong loa ig limbeng. ");
INSERT INTO agn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pagatapos tang tolong oras siminled tang katawa ni Ananias ang anday kalibotan na tang nainabo. ");
INSERT INTO agn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Dayon tanandiang sine-ma ni Pedro, “Magbega ong yen, narin lamang ka kaman tang kantidad tang tanek mi?” Siminabat si Safira, “Ee, ong kantidad lamang kaman ang asia.” ");
INSERT INTO agn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ganing si Pedro ong nandia, “Angay naginigoan among magkatawa ang sobokan mi tang Ispirito tang Gino? Telekan mo, asia ra ong portan tang mga naglebeng ong katawa mo, ig yawa idatona ka nirang ilbeng.” ");
INSERT INTO agn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ig golping natomba si Safira ong may kakayan ni Pedro ig napatay. Paga-led tang mga soltiros, inita nirang patay da tanandia. Dayon ang ingkelan nira tang sinangoni ni Safira ig limbeng ong tepad tang katawa na. ");
INSERT INTO agn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ig ang tanan ang pamagto ong Gino asta ang tanan ang nangabasi ta na, pisan ang pinangeldan. ");
INSERT INTO agn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Dorong mga milagro ig makabebereng ang bagay ang naboat tang mga apostolis ang inita tang mga taw. Ang tanan ang pamagto ong Gino pamagsirimet-simet don ong parti tang Timplo ang aggoyan ta Alalan ni Solomon. ");
INSERT INTO agn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ang domang mga taw indi namangas ang namagiga-pen ong nira. Piro mabael tang paggalang tang mga taw ong nira. ");
INSERT INTO agn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ig mintras gaboay, mas doro tang gadolang ong nira tenged dorong mga lali asta mga babay ang pamagto ong Gino. ");
INSERT INTO agn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tenged ong mga milagrong bindoat tang mga apostolis, ang mga pamagmasit ingkelan ong mga karsada ig agbe-tang ong mga bayan-bayan ig mga aglolbogan, agod mga toma-lib da ono si Pedro, maski ang pirapa ong nira makaninoan da lamang. ");
INSERT INTO agn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Belag lamang ta sia, doro rang mga taw ong mga bario ong palibot tang Jerusalem tang namansipaning ang pamagekel tang mga may masit ig ang mga taw ang agpaliwagan ta mga malain ang ispirito. Ig tanirang tanan poros namago-ya. ");
INSERT INTO agn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ang pangolokolo ong mga padi asta ang mga karomanan nang mimbro tang siktang Saduseo, dorong kaibeg nira. ");
INSERT INTO agn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Animan pinadep nira tang mga apostolis ig pina-led ong prisoan. ");
INSERT INTO agn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Piro asing labi ra, may tatang anghil ang sinobol tang Gino ang nagabri ong portan tang kolongan, ig pinaloa na tang mga apostolis ang ganing, ");
INSERT INTO agn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Paning amo don ong Timplo. Itoldok mi ong mga taw tang natetenged ong kaboing narin ang agto-dol tang Gino.” ");
INSERT INTO agn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Namagtoman tanira, ig asing garamal da napaning tanira ong Timplo, ig namagimpisa rang namagtoldok ong mga taw. Mandian ong pagkabot tang kalawigan ang padi ig ang mga karomanan na, pinagoy nira tang tanan ang mga opisialis, ang yay ang mga mepet tang banoa, agod magbaragat-bagat tanirang tanan. Pagatapos, nanobol tanirang komiten tang mga apostolis ong prisoan agod patalongaen ong nira. ");
INSERT INTO agn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Piro asing pagkabot tang mga goardia don ong prisoan, anda ra don tang mga apostolis, animan namagbalik tanira ig namagbalita ong mga opisialis ang ganing, ");
INSERT INTO agn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Asing pagkabot amen don maelet ka tang pagkatrangka tang prisoan. Ig ang mga goardia, don kang pamagbantay ong portan. Piro pag abri amen, anday inita amen ang taw don ong teled!” ");
INSERT INTO agn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Asing maba-yan narin tang mga pangolokolo ong mga padi may ang kapitan tang mga goardia ong Timplo, nagoloan tanira ig indi maisip nira mga onopa bato tang nainabo ong mga apostolis. ");
INSERT INTO agn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lagat-lagat ta ge-ley kiminabot tang tatang taw ang nagbalita ong nira ang ganing, “Telekan mi! Ang mga taw ang kinolong mi, asi ong Timplo ang pamagtoldok ong mga taw!” ");
INSERT INTO agn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Animan ang kapitan may ang mga goardia na namansipaning ong Timplo, ig kinomit nira tang mga apostolis. Piro indi pinapanawan nira ta poirsa tenged gengeldan itaben banggilen tanira tang mga taw. ");
INSERT INTO agn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ingkelan nira tang mga apostolis ig pinatalonga ong opisialis tang banoa. Ganing ong nira tang kalawigan ang padi, ");
INSERT INTO agn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Inordinan amo ra yamen ta maelet ang indi amo ra magtoldok ong aran tang Jesus ang asi. Piro telekan mi tang bindoat mi! Nagwasag da ong bilog ang Jerusalem tang toldok mi, ig yami pa tang agpabandanan mi ong kamatayen na!” ");
INSERT INTO agn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piro siminabat si Pedro ig ang mga karomanan nang apostolis ang ganing, “Ang Dios tang dapat ang pareten amen, belag tang mga taw. ");
INSERT INTO agn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ang Dios ang agtowan tang mga kamepet-mepetan ta yay ang nagboing oman ong ni Jesus ang pinalansang mi ong kros ig pinatay. ");
INSERT INTO agn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ig mandian si Jesus pinalawig tang Dios ong langit ig pinakarong na ong to na, ig sindolan ta alawig ang dengeg bilang Mangolokolo ig Maniglibri, agod itang mga Israelita mapamagtogat ig mapatawad ong mga talak ta. ");
INSERT INTO agn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ig yami, mga tistigos ami ong mga bagay ang narin, aroman tang Ispirito Santo ang sindol ong tanan ang pamagtoman ong Dios.” ");
INSERT INTO agn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Asing maba-yan narin tang mga opisialis, dorong kasisilagen nira ig ang kaliliagan nira patayen din nira tang mga apostolis. ");
INSERT INTO agn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Piro kimindeng tang tata ong nira, ang aran na si Gamaliel, tata ong mga Pariseo. Manigtoldok tanandia tang Katobolan ig aggalangen tang tanan ang mga taw. Nagordin tanandiang paloaen kang lagi tang mga apostolis ta indi lamang maboay. ");
INSERT INTO agn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Oman, minitala tanandia ang ganing, “Mga kasimanoao ang taga Israel, isipen mi ta mo-ya tang boaten mi ong mga taw ang narin. ");
INSERT INTO agn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tanopa sia may tatang taw ang aran na si Teudas, ang pagpambog ong sadili nang midio sino ra ka enged tanandia. Ig nakombinsi tanandia ta epat ang gatos ang mga taw ang minimbeng ong nandia. Piro pinatay tanandia ig ang mga karomanan na namagbereblag lamang ang anday lindoan na. ");
INSERT INTO agn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pagatapos, asing mga kaldaw tang pagpalista, si Judas sing taga Galilea tang nakombinsi ta mga taw ang ma-pen ong nandia. Napatay ka tanandia, ig namagbereblag ka tang mga namagosoy ong nandia. ");
INSERT INTO agn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Animan narin tang maningo ong nindio mandian— indi palabetan mi tang mga taw ang na. Pabayan mi lamang tanira. Mga ong taw lamang nagalin tang aggisipen nira ig ang mga agboaten nira, malipat lamang sia. ");
INSERT INTO agn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Piro mga ang Dios yay ang nagtobol ong nira, indi degen mi tanira, ig lomboa pang pamangontra amo ong Dios.” Namamasi ka tanira ong inaning ang asi ni Gamaliel. ");
INSERT INTO agn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pina-led sing oman tang mga apostolis, pagatapos pinatakan tang palo ig inordinan ang indi ra moman ang mamansibitala ong aran ni Jesus, ba-lo pa pinalpatan nira. ");
INSERT INTO agn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ig namagalin tanira ong talongan tang mga opisialis tang banoa ang dorog kambeng tanira tenged pinagnan tang Dios ang paeyaken tanira tenged lamang ong pagto nira ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kaldaw-kaldaw pamansipaning tanira ong Timplo ig ong mga kababalayan ig sigi tang toldok ig patako ong mga taw ang si Jesus yay ang Cristo. ");
INSERT INTO agn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ong mga kaldaw ang asi, asing pamandoro ra ta mo-ya tang mga sinagpan tang Gino, namagriklamo tang mga Judio ang bitala nira Grigo kontra ong mga Judio ang bitala nira Hebreo. Ganing tanira, ang mga aroman nirang mga babay ang mga balo, gapabayan da ono ang ga-dolan tang pangaboi nira ong kaldaw-kaldaw. ");
INSERT INTO agn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Animan sinimet tang tampolok may doroang mga apostolis tang tanan ang mga sinagpan tang Gino. Ganing tanira, “Belag ta tama ang pabayan amen tang pagtoroldokon tang bitala tang Dios para lamang asikason amen tang pagtororolon ta pamangan ong mga malised. ");
INSERT INTO agn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ang masinlo, mga logod, mamilik amo ong mga karomanan mi ta pitong laling ilaladong mga mo-yang taw, matako ig aggaeman tang Ispirito Santo, ig oldan amen tanira tang obrang narin. ");
INSERT INTO agn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ig yami, bogos ang gamiten amen tang timpo amen ong pagpangadi ig ong pagtoldok tang bitala tang Dios.” ");
INSERT INTO agn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nangalipay tang tanan ang taw ang namagsimet ong inaning tang mga apostolis. Animan pinilik nira si Esteban, tatang laling dorog kaelet tang pagtalig na ong Dios ig aggaeman tang Ispirito Santo. Pinilik ka nira da Felipe, Procoro, Nicanor, Timon, Parmenas, ig Nicolas ang taga Antioquia, tatang belag ta Judio ang nala-ted da ong rilihion tang mga Judio. ");
INSERT INTO agn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ang mga narin pinrisintar ong mga apostolis. Ig ang mga apostolis namagbondo tang mga kalima nira ong nira ig namangadi para ong nira. ");
INSERT INTO agn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ig ang bitala tang Dios mas nagwasag pa enged ig don ong Jerusalem sigi tang dolang tang mga sinagpan tang Gino. Maski ang mga padi, doro ka ong nira tang namagto. ");
INSERT INTO agn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Si Esteban ang narin, tenged tanandia inaloyan ta mo-ya tang Dios ig sindolan ta gaem, napagboat tanandia ta mga milagro ig mga makabebereng ang bagay ong mga taw. ");
INSERT INTO agn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Piro may mga taw ang limindoang kiminontra ong nandia. Mga mimbro tanira tang tatang sikta tang mga Judio ang agganingen “mga Linibri.” Tanira mga Judiong taga Cirene ig Alejandria, Cilicia ig Asia. Nagigdiskosion tanira ong ni Esteban, ");
INSERT INTO agn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","piro tenged ong kinata-wanan ang sindol ong nandia tang Ispirito Santo, anday madeg ong mga pamitala na. ");
INSERT INTO agn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Animan nagsol tanira ta pirapang mga lali agod maning ang naba-yan nira si Esteban ang agpakalainen na ono si Moises ig ang Dios. ");
INSERT INTO agn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ong inaning ang asi tang mga lali, nasilag tang mga taw, asta ang mga mepet ig ang mga manigtoldok tang Katobolan. Animan si Esteban pinadep nira, ig ingkelan ang pinatalonga ong mga opisialis tang banoa. ");
INSERT INTO agn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nangomit tanira ta mga taw para magtistigo ta bo-li kontra ong nandia. Ganing tang mga tistigos, “Ang taw ang na indi agtatareng ang pagbitala ta anday sayod kontra ong sagradong Timplo ta asta ong Katobolan ni Moises. ");
INSERT INTO agn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Naba-yan amen tanandia ang ganing ang gebaen ono ni Jesus ang taga Nazaret tang Timplo ig omanen na ka tang kinaogalian ang sindol ong yaten ni Moises.” ");
INSERT INTO agn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pina-dekan si Esteban tang tanan ang mga opisialis, ig inita nira tang emet na magang emet ta anghil. ");
INSERT INTO agn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mandian, nane-ma tang kalawigan ang padi ong ni Esteban ang ganing, “Matod ka kaman tang tanan ang narin?” ");
INSERT INTO agn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Siminabat si Esteban, “Mga logod ig mga ginikanan, pama-yan mi tang yaningo. Ang dalayawen ig makagagaem ang Dios napaita asing tokaw ong yaten ang kamepet-mepetan ang si Abraham asing tanandia don ong Mesopotamia ba-lo tanandia limina-ted ong Haran. ");
INSERT INTO agn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ganing tang Dios ong ni Abraham, ‘Magalina ong banoa mong narin, bo-wanan mo tang mga kaparintian mo, ig paninga ong banoang itoldoko ong nio.’ ");
INSERT INTO agn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Animan nagalin si Abraham ong banoa nang asi tang mga Caldeo ig napaning don ong Haran. Don napatay tang tatay na, ba-lo pa si Abraham pinapagalin tang Dios ig pinapaning ong banoang nang aggistaran ta mandian. ");
INSERT INTO agn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ang timpong asi, si Abraham indi sindolan tang Dios maski midio palad ang tanek ang makabig nang nandia. Piro nangako tang Dios ang i-dol na ong nandia ig ong mga inampo na, maski ong oras ang asi si Abraham anda pay ana na. ");
INSERT INTO agn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Maning ta na tang inaning tang Dios, ‘Ang mga inampo mo mamansistar ong domang logar ang belag ta sadiling banoa nira. Boaten tanira don ang mga kirepen, ig degdegen tanira tang mga taga don ong teled ta epat ang gatos ang takon. ");
INSERT INTO agn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Piro silotano tang nasion ang magkirepen ong nira. Pagatapos, mamagalin si tang mga inampo mo ong banoang asi, ig magbalik ong logar ang na, ig tarin tanira magto ong yen.’ ");
INSERT INTO agn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ig para mademdeman ni Abraham tang pinangako tang Dios ong nandia, ang pagtori yay ang tandang ginamit tang Dios. Animan asing pinangana tang ana nang si Isaac, tinorian na tanandia ong pagkabot tang yawalong kaldaw. Ig maning ka don tang bindoat ni Isaac ong ana nang si Jacob. Ig ya ka tang bindoat ni Jacob ong tampolok may doroang ana nang lali, ang yay ang mga kamepet-mepetan ta.” ");
INSERT INTO agn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ganing pa si Esteban, “Ang yaten ang mga kamepet-mepetan ang asi nangaibeg ong logod nirang si Jose. Animan pinabakal nira tanandia ig tanandia nagimong tatang kirepen don ong Ehipto. Piro tenged aroman na tang Dios, ");
INSERT INTO agn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","sinabangan tanandia ong tanan ang kaliwagan ang gapasaran na. Sindolan na ka tanandia ta kinata-wanan. Animan naliagan tanandia ni Faraon ang adi tang Ehipto, ig bindoat na tanandiang gobirnador ang mangolokolo ong Ehipto, ig ong tanan ang mga taw don ong palasio na. ");
INSERT INTO agn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mandian, nagkatinir ta tagletem ong bilog ang banoang Ehipto asta ong banoang Canaan, ig liniwagan ta mo-ya tang mga taw. Ang yaten ang mga kamepet-mepetan, anda rang pisan ay itaen nirang pamangan. ");
INSERT INTO agn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Animan, asing mabalitan ni Jacob ang don ong Ehipto may pamangan, pinapaning na don tang mga ana na, ang yay ang mga kamepet-mepetan ta. ");
INSERT INTO agn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Asing yadoa rang pagpaning nira don, nagpailala ra si Jose ong mga logod na, ig nata-wanan ka ni Faraon tang natetenged ong pamilia na. ");
INSERT INTO agn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dayon ang pinakomit ni Jose tang tatay nang si Jacob, ig ang tanan ang mga kaparintian na. Pitong polok may limang taw tanirang tanan. ");
INSERT INTO agn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Animan si Jacob may ang mga kamepet-mepetan ta namampaning don ong Ehipto, ig don tanira namansistar asta nangapatay. ");
INSERT INTO agn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ang mga sinangoni nira ingkelan don ong Siquem ig don limbeng ong lebengan ang binakal ni Abraham ong mga inampo ni Hamor. ");
INSERT INTO agn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Asing galenget dang mainabo tang pinangako tang Dios ong ni Abraham, mintras gaboay mas pandoro pa tang mga kasimanoa ta don ong Ehipto. ");
INSERT INTO agn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Asta ra lamang kiminabot tang kaldaw ang doma rang adi tang kakarong ong Ehipto, ang anday gata-wanan na natetenged ong ni Jose. ");
INSERT INTO agn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Linoko tang ading narin tang mga kamepet-mepetan ta, ig dinegdeg na tanira. Rineges na tanira ang ipanlek nira tang mga mamolang gege-ley agod mangapatay. ");
INSERT INTO agn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ong timpong asi, pinangana si Moises ig dorog kasinlong mola. Inasikaso tanandia tang mga ginikanan na ong teled ta tolong bolan. ");
INSERT INTO agn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ig asing bino-wanan nira tanandia ong loa, sinagod tanandia tang anang babay tang Faraon, ig pinabael na ang midio sadiling ana na. ");
INSERT INTO agn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Sinoldokan si Moises tang tanan ang kinata-wanan ong Ehipto, ig nagimo tanandiang dorog kaosay ong pamitala ig ong tanan ang mga boat na.” ");
INSERT INTO agn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ganing pa si Esteban, “Asing si Moises pagidad da ta koarinta anios, napagisip tanandiang mamisita ong mga kapario nang mga Israelita. ");
INSERT INTO agn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ig inita na don tang tata ong nira ang agsigbaken ta tatang taga Ehipto. Dayon ang sinabangan na tang kapario nang Israelita, ig bilang balet pinatay na tang taga Ehipto. ");
INSERT INTO agn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kalaom ni Moises, maintindian tang mga Israelita ang tanandia yay ang gamiten tang Dios ang maglibri ong nira ong mga kaliwagan ang gapasaran nira. Piro asi pala indi naintindian nira. ");
INSERT INTO agn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pagaramal may inita nang doroang Israelita ang pagsoayan, ig pinrosigiran na rin ang papagtomboyon tang doroa. Ganing si Moises ong nira, ‘Mga tangay, pario among mga Israelita! Angay pagsoayan amo?’ ");
INSERT INTO agn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Piro kinalieg si Moises tang tatang laling pagsigbak ong aroman na ang ganing, ‘Sinopay nagboat ong niong mangolokolo ig manigosgar ong yamen? ");
INSERT INTO agn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Onopa? Patayeno ka nio pario tang bindoat mo nongapon ong taga Ehipto?’ ");
INSERT INTO agn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Asing naba-yan narin ni Moises, naglayas ang lagi tanandia ong Ehipto, ig napaning ong Midian ig don ministar. Nangatawa tanandia don ig nagkatinir ta doroang anang lali. ");
INSERT INTO agn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Pagata-lib tang epat ang polok ang takon, napaita tang tatang anghil ong ni Moises ong tatang dibabak ang papa ta ayong dadaba-daba, don ong logar ang anday taw na alenget ong bokid tang Sinai. ");
INSERT INTO agn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nabereng ta mo-ya si Moises ong inita nang asi, ig asing palengetan na para telekan, naba-yan nang minitala tang Gino ang ganing, ");
INSERT INTO agn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yo tang Dios ang agtowan tang mga kamepet-mepetan mo, ang Dios ni Abraham, ni Isaac, ig ni Jacob.’ Nangelel si Moises ong sobrang karaelden na ig indi ra galiliag ang pa-dek. ");
INSERT INTO agn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ganing tang Gino ong nandia, ‘Loaten mo tang rapak mo tenged sagradong logar tang agke-dengan mo. ");
INSERT INTO agn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Initao tang mga kaliwagan ang gapasaran tang mga tawano ong Ehipto. Naba-yano ka tang mga tangit nira. Animan napababako tarin para ilibrio tanira. Animan mandian magsimpana. Tania, tobolona yen don ong Ehipto.’ ");
INSERT INTO agn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ang Moises ang na yay ang indi rinisibi tang mga kapario nang Israelita asing ganing tanira ong nandia ang, ‘Sinopay nagboat ong niong mangolokolo ig manigosgar ong yamen?’ Piro si Moises kang narin tang sinobol tang Dios ang mangolokolo ig maglibri ong mga Israelita, ong tabang tang anghil ang napaita ong nandia ong dibabak ang papa ta ayo. ");
INSERT INTO agn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Si Moises tang nagekel ong mga Israelita ong paglayas nira ong Ehipto. Nagboat tanandia ta mga milagro ig makabebereng ang bagay ong Ehipto, ig don ong talsing aggingaranan ta Masinggi, ig ong mga logar ang anday gistar ang taw ang agpanawan nira ong teled tang epat ang polok ang takon. ");
INSERT INTO agn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Tanandia ka tang Moises ang minitala ong mga Israelita ang ganing, ‘Ang Dios mamilik ta tata ong nindio ig boaten ang propitang pario ong yen.’ ");
INSERT INTO agn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ig asing don namagsimet-simet tang mga kamepet-mepetan tang mga Israelita ong logar ang anday gistar ang taw, si Moises tang nagpatenga ong nira ig ong anghil ang nagigampang ong nandia ong bokid tang Sinai. Ig don tanandia nagrisibi ong Dios ta mga bitalang pagtorol ta kaboi para ipakabot ong yaten.” ");
INSERT INTO agn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ganing pa si Esteban, “Piro ang mga kamepet-mepetan ta, indi naliliag ang magtoman ong ni Moises. Sinaliodan nira tanandia ig gangaliag tanirang mamagbalik ong Ehipto. ");
INSERT INTO agn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Animan ganing tanira ong ni Aaron, ‘Magboata kay ta mga dios amen ang manokaw-tokaw ong yamen, tenged indi gata-wanan amen ang naonora si Moises ang asi ang nagekel ong yaten ang limindoa ong Ehipto.’ ");
INSERT INTO agn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ig ang timpong asi namagboat tanira ta dios-diosan ang itsora na midio bakang ge-ley. Namagpista tanira ig namagsagda ta ayep para ong dios-diosan ang asing sadiling bindoatan nira. ");
INSERT INTO agn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Animan sinaliodan tanira tang Dios ig pinabayan da lamang tanirang magto ong mga de-kal ong langit. Pario enged tang na-tang ong libro tang mga propita asing ganing tang Dios: ‘Yamong mga inampo ni Israel, namagsagda amo don ong logar ang anday gistar ang taw ong teled ta epat ang polok ang takon. Piro belag ta yo tang matod ang binolontadan mi tang mga torol mi ig mga ayep ang pinatay mi. ");
INSERT INTO agn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Aggekel-ekelan mi pa tang torda tang dios-diosan ming si Moloc, ig ang bitokon-bitokon tang dios-diosan ming si Renfan. Namagboat amo tang mga riboltong narin agod towan mi. Animan i-lek amo yen asta ong dobali pa tang Babilonia.’ ” ");
INSERT INTO agn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ganing pa si Esteban, “Don ong logar ang anday gistar ang taw, ang mga kamepet-mepetan ta may torda nirang pagsirbing pamatod nga ang Dios aroman nira. Sinobol tang Dios ong ni Moises ang boaten nira narin, ig inosoy nira tang plano ang pinaita tang Dios ong nandia. ");
INSERT INTO agn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Oman ang mga ana nira nanoblian tang torda. Ig asing si Josue tang panokaw-tokawan ong mga kamepet-mepetan ta, ingkelan ka nira asing sinakep nira tang mga logar tang domang mga banoa ang pinalayas tang Dios para ong nira. Ang tordang na, si pa ong mga Israelita asta asing nagimong adi si David. ");
INSERT INTO agn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Si David, naliagan ta mo-ya tang Dios, ig nagampo tanandiang pagnan ang magpa-deng ta balay para ong Dios, ang yay ang Dios ang agtowan ni Jacob asing tokaw. ");
INSERT INTO agn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Piro si Solomon yay ang nagboat tang balay ang agpagtowan ong Dios. ");
INSERT INTO agn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Piro ang Dios ang Makagagaem ong tanan, indi gistar ong balay ang bindoat lamang ta taw, sigon ong inaning tang propita asing tokaw: ");
INSERT INTO agn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ang langit tang yen ang trono,’ ganing tang Gino. ‘Ig ang tanek tang borondoan tang kakayo. Onopang klasi ta balay tang boaten mi ong yen, obin bato logar ang perenayano? ");
INSERT INTO agn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ong kamatodan, yo tang nagboat tang tanan ang bagay.’ ” ");
INSERT INTO agn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ganing pa si Esteban, “Katetegat tang mga kolo mi! Indi amo mamagparet ig indi amo ka mamamasi tang kamatodan! Ang mga boat mi, pario tang bindoat tang mga ginikanan mi— pamangontra among pirmi ong Ispirito Santo. ");
INSERT INTO agn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sinopa lamang ong mga propita asing tokaw tang indi pinaliwagan nira? Pinatay nira tang mga pamagpatako tang natetenged ong pagkabot tang Mato-lid ang Torobolon tang Dios. Ig asing tarin da tanandia, yamo ra ka tang nagtraidor ig nagpatay ong nandia. ");
INSERT INTO agn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yamo tang namagrisibi tang Katobolan ang sindol tang Dios ong tabang tang mga anghil asing tokaw, piro yamo ka mismo tang indi pamagtoman ta si!” ");
INSERT INTO agn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Asing naba-yan tang mga opisialis tang inaning ni Esteban, dorong kasisilagen nira, ig kakayeget pa tang mga isi nira ong sobrang kaerep nira ong nandia. ");
INSERT INTO agn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Piro si Esteban ginaeman tang Ispirito Santo. Napa-dek tanandia ong langit ig inita na tang kayagan tang Dios, ig si Jesus ang ke-deng ong to tang Dios. ");
INSERT INTO agn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ganing si Esteban, “Telekan mi! Aggitaenong abri tang langit, ig ang Ana ta Taw ke-deng ong to tang Dios.” ");
INSERT INTO agn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Piro ang mga opisialis namaginiteg ig agtengtengen nira tang mga talinga nira, ig delelengan ang kinolokoboan nira si Esteban. ");
INSERT INTO agn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ginoyodan nira ong loa tang siodad ig sinalalabangan ang binanggil. Ang mga namagtistigo kontra ong ni Esteban, namagloat tang mga lambong nirang panta-paw ig bino-wanan ong tatang soltiros don ang aran na si Saulo. ");
INSERT INTO agn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ig mintras agbanggilen nira si Esteban, pangadi tanandia ong Gino ang ganing, “Ginong Jesus, risibien mo tang yen ang ispirito.” ");
INSERT INTO agn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dayon tanandiang liminod ig miniteg ta mapoirsa, “Gino,” ganing tanandia, “indi ra tanira papanabaten mo ong kasalanan ang na!” ");
INSERT INTO agn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ig napaoyon si Saulo ong pagpatay nira ong ni Esteban. Ong kaldaw ang asi don ong Jerusalem, inimpisan dang pinaliwagan ta mo-ya tang tanan ang mga pamagto ong ni Cristo. Ig poira lamang ong mga apostolis, namagwasag tanirang tanan ig nangakabot ong mga logar ang gasakepan tang Judea ig Samaria. ");
INSERT INTO agn_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ig mga natetenged ong ni Esteban, may mga laling madinioson ang namaglebeng tang sinangoni na, ig ini-yakan nira tanandia ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mandian, dorong prosigir ni Saulong lipaten tang mga pamagto ong ni Cristo. Agpaningan na ong mga kababalayan nira ig agpoirsaen nang agge-lan ig agpa-led ong prisoan, belag lamang tang mga lali kondi asta mga babay. ");
INSERT INTO agn_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Asing namagwasag tang mga pamagto ong ni Jesus, namagpatako tanira tang Mo-yang Balita maski ong ayra lamang tanira nangakabot. ");
INSERT INTO agn_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Felipe napaning ong siodad tang Samaria ig nagtoldok don ong mga taw tang natetenged ong Cristo. ");
INSERT INTO agn_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Asing pagabasi tang mga taw tang agganing na ig itaen nira tang mga makabebereng ang agboaten na, pinama-yan nira ta mo-ya. ");
INSERT INTO agn_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tenged dorong mga taw ang sinled ta mga malain ang ispirito, ig pamansiteg tang mga narin mintras loloa ong sinangoni tang mga taw. Doro kang mga pilay ig mga piang tang pinao-ya ni Felipe. ");
INSERT INTO agn_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Animan ang mga taw ang taga don doro kang kalipay nira. ");
INSERT INTO agn_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mandian, don ong siodad ang asi may taw ang aran na si Simon. Naboay da tanandiang pagmadyikiro ig ang mga taw gangabereng ta mo-ya ong agboaten na. Pagpambog tanandiang maga sinora ka enged. ");
INSERT INTO agn_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Animan ang tanan ang klasi ta taw, maski may dengeg maski anda, pamamasi ong nandia. Ganing tanira, “Ang taw ang na ay ang mismong gaem tang Dios, ang aggoyan ta Makagagaem.” ");
INSERT INTO agn_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Naboay dang timpong pinabereng na tang mga taw ong pagmadyikiro na, animan pamamasi tanira ta mo-ya ong nandia. ");
INSERT INTO agn_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Piro asing nagpatako si Felipe ong nira tang Mo-yang Balita natetenged ong paggaraemen tang Dios bilang adi ig natetenged ong ni Jesu-Cristo, namagparet tanira ig namagpaboniag ong ni Felipe, mga lali ig mga babay. ");
INSERT INTO agn_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Asta si Simon mismo nagparet ka. Ig pagaboniagan na, pirmi ra tanandiang tatabid ong ni Felipe. Mandian si Simon da tang nabereng ong mga milagro ig makabebereng ang bagay ang inita nang agboaten ni Felipe. ");
INSERT INTO agn_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Asing nabalitan tang mga apostolis ong Jerusalem ang namagparet tang mga taga Samaria ong bitala tang Dios, dayon ang pinapaning nira don si Pedro ig si Juan. ");
INSERT INTO agn_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pagakabot nira ong Samaria, pinangadi nira tang mga ba-long pamagto don agod marisibi nira tang Ispirito Santo. ");
INSERT INTO agn_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tenged ang oras ang asi, maski sinopa ong nira indi pa gangarisibi tang Ispirito Santo. Tanira naboniagan lamang ong aran ni Ginong Jesus. ");
INSERT INTO agn_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Dayon ang binondo ni Pedro ig ni Juan tang mga kalima nira ong mga pamagto ig narisibi ra nira tang Ispirito Santo. ");
INSERT INTO agn_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pagaita ni Simon ang garisibi pala tang Ispirito Santo ong pagbondo tang kalima tang mga apostolis, dinoydoyan na si Pedro ig si Juan ta koarta, ");
INSERT INTO agn_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ang ganing, “Oldayo ka nindio ta gaem ang maning atan agod maski sinopay bondoano tang kalimao, marisibi ka nira tang Ispirito Santo.” ");
INSERT INTO agn_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Siminabat si Pedro, “I-leka ra lamang ong impirno, yawa asta ang koarta mo! Kalaom mo, mabakal mo ta koarta tang rigalo tang Dios? ");
INSERT INTO agn_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Andang pisan ay parti mo ong agpaboat tang Dios ong yamen tenged anday sayod tang pagirisipen mo ong pama-dek na. ");
INSERT INTO agn_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Magtogata ig bo-wanan mo tang kalainan mong na, ig magpakiloya ong Gino ang balampa patawadena nandia ong gaisip mong anday sayod. ");
INSERT INTO agn_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tenged initao ang masiadoang gaibeg ig aglapotona pa tang kasalanan mo.” ");
INSERT INTO agn_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ganing si Simon, “Ipangadio kay nindio ong Gino ang inding pisan mainabo ong yen tang inaning ming asia!” ");
INSERT INTO agn_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pagatapos ang namagpamatod ig namagpatako tang bitala tang Gino don, namagbalik da Pedro ni Juan ong Jerusalem. Ig namagpatako tanira tang Mo-yang Balita natetenged ong ni Jesu-Cristo ong dorong kababarioan tang Samaria ang napanawan nira. ");
INSERT INTO agn_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mandian may anghil ang sinobol tang Gino ang minitala ong ni Felipe ang ganing, “Panawa. Paninga ong abagat, osoyon mo tang dalan magalin ong Jerusalem paning ong Gaza.” Mandian, ang dalan ang asi indi ra agpanawan ta taw. ");
INSERT INTO agn_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Dayon ang napanaw si Felipe paning don. Tarin pala ong dalan ang na may tatang taga Etiopia. Ang laling na tatang kinapon, ig opisialis tanandia ong inadian tang Candace, ang yay ang rayna tang Etiopia. Agtaligan tanandia ong tanan ang manggad tang rayna. Napaning tanandia ong Jerusalem para magsimba ong Timplo, ");
INSERT INTO agn_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ig mintras golik, kakarong tanandia ong karo nang pagbasa tang librong sinolat tang propitang si Isaias. ");
INSERT INTO agn_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Oman ganing tang Ispirito Santo ong ni Felipe, “Palengeta don ig demengana ong karo na.” ");
INSERT INTO agn_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nanikad si Felipeng agpaning don ong karo, ig naba-yan nang pagbasa tang opisialis tang librong sinolat tang propitang si Isaias. Nane-ma si Felipe ong opisialis ang ganing, “Gaintindian mo ka tang agbasaen mong asia?” ");
INSERT INTO agn_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“Indi kaman,” ganing tang opisialis. “Monopa maintindiano mga anday magpaintindi ong yen?” Dayon ang inaning na si Felipeng tomay da lamang ong karo ig tempad ong nandia. ");
INSERT INTO agn_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ang parti tang Kasolatan ang agbasaen na ganing, “Anda enged ay riklamo na. Pario ta tatang karnirong agge-lan para patayen, obin ang karnirong ge-ley ang agtopian tang bolbol na, inding pisan tanandia naginingal. ");
INSERT INTO agn_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pinaeyak tanandia ig pinangindian ta ostisia. Anday mapagbalita natetenged ong mga inampo na, tenged komiten da tang kaboi na tarin ong kalibotan.” ");
INSERT INTO agn_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ganing tang opisialis ang nane-ma ong ni Felipe, “Begay ka, sinopa tang agsambiten tang propitang narin? Ang sadili na bato obin domang taw?” ");
INSERT INTO agn_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Impisa ong Kasolatan ang narin, sinayod ong nandia ni Felipe tang Mo-yang Balita natetenged ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Asing pagbiahi pa tanira ong dalan, may nata-liban nirang wi. Ganing tang opisialis, “Telekan mo! May wi tarin! Yo bato, indio maboniagan mo?” ");
INSERT INTO agn_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Siminabat si Felipe, “Poidi, mga magpareta lamang ang de-dek ong popotokon mo.” Ganing tang taw, “Ee, pagpareto ang si Jesus Ana tang Dios.” ");
INSERT INTO agn_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dayon ang pinapara tang opisialis tang karo. Tanirang doroa siminaboan don ong wi ig ang opisialis binoniagan ni Felipe. ");
INSERT INTO agn_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pagatakat nira ong wi, dayon ang kinomit si Felipe tang Ispirito tang Gino, ig indi ra tanandia initang oman tang opisialis. Nagpadayon tanandiang minolik ang dorong kalipay na. ");
INSERT INTO agn_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nata-wanan da lamang ni Felipe ang tanandia pala asi ra ong Azoto. Impisa don, nagpatako tanandia tang Mo-yang Balita natetenged ong ni Jesus ong tanan ang mga logar ang nata-liban na asta ra lamang ang nakabot tanandia ong siodad tang Cesarea. ");
INSERT INTO agn_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mandian, si Saulo indi agpenay ang pagpaeled-eled ang pamatayen na ono tang mga sinagpan tang Gino. Animan napaning tanandia ong kalawigan ang padi, ");
INSERT INTO agn_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ig nama-dol ta solat ang magtorol ta aotoridad ong nandia ig para magpailala tanandia ong mga simban tang mga Judio ong siodad tang Damasco. Tenged ang galiliagan na panlapoton ig e-lan na ong Jerusalem tang maski sinopay itaen na don ong Damasco, babay man obin lali ang pamagosoy ong Gino. ");
INSERT INTO agn_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Asing gingabot da si Saulo ong siodad tang Damasco, golping nangayag ong palibot na tang dorog kakilaw ang sinag ang pagalin ong langit. ");
INSERT INTO agn_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Natomba tanandia ong tanek, ig may bosis ang naba-yan nang ganing, “Saulo, Saulo, angay agpaliwagano nio?” ");
INSERT INTO agn_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Siminabat si Saulo, “Sinoapa, Gino?” Ganing tang bosis ang siminabat, “Yo si Jesus, ang agpaliwagan mo. ");
INSERT INTO agn_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kendenga atan ig padayon ang tenled ong siodad tang Damasco. Don may maganing ong nio mga onopay dapat boaten mo.” ");
INSERT INTO agn_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ang mga taw ang tatabid ong ni Saulo, namansi-deng da lamang don ang anday nangaibek-ibek ong nira. May naba-yan nirang bosis piro anday taw ang inita nira. ");
INSERT INTO agn_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kimindeng si Saulo, ig pagabo-kad tang mata na indi ra tanandia maita. Animan bindiotan da lamang nira si Saulo ig inantabay asta ong Damasco. ");
INSERT INTO agn_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tolong kaldaw tanandiang indi maita ig indi pamangan obin panginem. ");
INSERT INTO agn_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mandian, don ong Damasco may tatang sinagpan tang Gino ang aran na si Ananias. Ginoyan tanandia tang Gino ong midio talakinep, ig ganing, “Ananias!” Siminabat ka si Ananias, “Onopa si, Gino?” ");
INSERT INTO agn_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ganing tang Gino ong nandia, “Paninga ra don ong karsadang aggoyan ta Mato-lid. Dilemen mo don ong balay ni Judas tang tatang laling taga Tarso ang aran na si Saulo. Asia pangadi mandian tanandia, ");
INSERT INTO agn_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ig ong midio talakinep may inita nang taw ang aran na si Ananias ang siminled ong balay na ig binondoan tanandia tang kalima na para maitang moman.” ");
INSERT INTO agn_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Siminabat si Ananias, “Piro, Gino, doro rang gabalitano natetenged ong laling asi ang agpaliwagan na ono ta mo-ya tang mga sinakepan mo ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Animan napaning tanandia tarin ong Damasco tenged may gaem nang nagalin ong mga pangolokolo ong mga padi, para pandepen na tang tanan ang pamaggoy ong nio.” ");
INSERT INTO agn_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Piro ganing ong nandia tang Gino, “Paninga don. Ang taw ang asi piniliko agod ipatako na tang natetenged ong yen ong mga belag ta Judio ig ong mga adi, ig asta ong nindiong mga inampo ni Israel. ");
INSERT INTO agn_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ipaitao ong nandia tang tanan ang kaliwagan ang dapat mapasaran na para ong yen.” ");
INSERT INTO agn_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Dayon dang napanaw si Ananias ig paga-led na ong balay ang asi, binondo na tang kalima na ong ni Saulo ang ganing, “Saulo, logodo, yo sinobolo ni Ginong Jesus tarin ong nio. Tanandia tang napaita ong nio ong dalan ang pagpaning mo tarin. Sinobolo nandia para maitā sing moman, ig para gaemana tang Ispirito Santo.” ");
INSERT INTO agn_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Lagi-lagi may midio mga sisi ta yan ang nangabo-log nagalin ong mga mata ni Saulo ig naita ra tanandia. Pagatapos, dayon tanandiang kimindeng ig nagpaboniag. ");
INSERT INTO agn_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Namangan tanandia ig namoirsang oman tang sinangoni na. Don ong Damasco si Saulo minimbeng ta pirapang kaldaw ong domang mga sinagpan tang Gino. ");
INSERT INTO agn_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dayon tanandiang napaning ong mga simban tang mga Judio ig sinoldok na don ong mga taw tang natetenged ong ni Jesus. Ganing tanandia, “Si Jesus yay ang Ana tang Dios!” ");
INSERT INTO agn_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ang tanan ang nangabasi ong nandia nangabereng ta mo-ya. Ganing tanira, “Ang taw ang narin! Belag bato ta tanandia tang don ong Jerusalem tanopa siang manigpatay tang mga pamagto ong ni Jesus? Napaning tanandia tarin para lamang depen na tang mga taw ang pamagto ong ni Jesus, ig e-lan ong mga pangolokolo ong mga padi!” ");
INSERT INTO agn_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Piro mintras gaboay, mas nagimong maosay si Saulo ong pagtoroldokon na. Ig ang mga Judiong pamansistar ong Damasco, anday nasabat ong pagpamatod na ang si Jesus tang Cristo. ");
INSERT INTO agn_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pagata-lib tang dorong mga kaldaw, namagplano tang mga Judiong patayen si Saulo, ");
INSERT INTO agn_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","piro nabalitan ni Saulo tang mga plano nira. Kaldaw may labi pamagbantay tang mga Judio ong portan tang siodad agod patayen nira tanandia. ");
INSERT INTO agn_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Animan tatang labi kinomit si Saulo tang mga sinakepan na ig bintang nira tanandia ong teled tang tatang tiklis ig sinonton ong loa tang padir. ");
INSERT INTO agn_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Dayon ang napaning si Saulo ong Jerusalem. Pagakabot na don, galiliag din tanandiang mimbeng ong mga pamagsimet-simet ang mga sinagpan tang Gino. Piro geldan tanira ong ni Saulo tenged indi tanira mamagparet ang si Saulo nagpasakep da ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Piro si Bernabe, inated na si Saulo ong mga apostolis ig nagsaysay ong nira mga monopa tang Gino napaita ong ni Saulo ong dalan ig minitala ong nandia. Ig sinayod na ka ang si Saulo maiteg tang nem nang nagtoldok ong Damasco tang natetenged ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pagatapos, naimbeng da si Saulo ong nira, ig maski ong aypa ong Jerusalem maiteg tang nem nang magtoldok tang natetenged ong Gino. ");
INSERT INTO agn_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nagigampang ka tanandia ig nagigdibati ong mga Judiong bitala nira Grigo. Animan naliliag ka tanirang patayen tanandia. ");
INSERT INTO agn_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Asing nata-wanan narin tang mga pamagto, kinomit nira si Saulo, inated ong Cesarea ig pinaolik ong Tarso. ");
INSERT INTO agn_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ig ong mga timpong asi anda ray paggolo ong mga pamagto ong ni Cristo maski ong aypa ong mga logar tang Judea, Galilea, ig Samaria. Ong tabang tang Ispirito Santo, mas nambaked tang pagto nira, ig mas nandoro tanira. Ig nagpadayon tanira ang mabael tang paggalang nira ong Gino. ");
INSERT INTO agn_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Si Pedro pirming pagbiahi agod mamisita ong mga pamagto, ig may naminta napaning tanandia don ong Lida agod bisitaen na tang mga sinakepan tang Dios don. ");
INSERT INTO agn_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Asing don da tanandia, inita na tang tatang taw ang aran na si Eneas. Si Eneas ang narin, walo rang takon ang lolbog tenged ang sinangoni na paralisado ra. ");
INSERT INTO agn_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ganing si Pedro ong nandia, “Eneas, pinao-yā ra ni Jesu-Cristo. Mambangona ra ig imesen mo ra tang lolbogan mo.” Ig golpi tanandiang nambangon. ");
INSERT INTO agn_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Inita narin tang mga taw ang taga Lida ig taga Saron, ig namagto ra ka tanira ong Gino. ");
INSERT INTO agn_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mandian don ong Jope, may tatang babay ang sinagpan tang Gino, ang aran na si Tabita. (Ong bitalang Grigo Dorcas tang aran na, ang maliag yaning osa.) Si Tabitang narin dorog kaderep ang magboat ta mo-ya ong domang mga taw ig tomabang ong malilised. ");
INSERT INTO agn_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Naton ong mga kaldaw ang asi ang nagmasit tanandia ig dayon ang napatay. Ig asing natrapoan da nira tang sinangoni na, pinalbog nira don ong koarto ong dibabaw. ");
INSERT INTO agn_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mandian ang Lida, alenget lamang ong Jope. Animan asing naba-yan tang mga sinagpan tang Gino don ong Jope ang si Pedro don ong Lida, nanobol tanira ta doroa nga lalian ang paning ong nandia ig aningen mga maimo paning kay ang lagi tanandia don ong nira ong Jope. ");
INSERT INTO agn_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Siminabid si Pedro ong nira. Pagakabot nira don, ingkelan ang lagi nira tanandia don ong koarto ong dibabaw. Pinalibotan ang lagi tanandia tang mga babay ang balong pamagini-yak ang pamagpaita ong nandia tang mga lambong ig mga bistidang binedbed ni Dorcas asing boi pa tanandia. ");
INSERT INTO agn_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pinaloa ni Pedro tanirang tanan ong koarto. Dayon tanandiang liminod ig nangadi. Pagatapos, siminalonga tanandia ong patay ig ganing, “Tabita, mambangona!” Dayon ang nabo-kad tang mata ni Tabita, ig pagaita na ong ni Pedro, kiminarong da tanandia. ");
INSERT INTO agn_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bindiotan tanandia ni Pedro ig sinabangan nang kimindeng. Pagatapos, ginoyan ni Pedro tang mga sinakepan tang Dios don, gapil tang mga balo, ig pinaita na ong nira si Tabitang boi ra. ");
INSERT INTO agn_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ang nainabong narin nabalitan tang tanan ang taw ong bilog ang Jope ig dorong namagto ong Gino. ");
INSERT INTO agn_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ig naboay-boay pa tang tinir ni Pedro don ong Jope, ong balay ni Simon ang manigkanit ta olit ta ayep. ");
INSERT INTO agn_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Don ong Cesarea may taw ang aran na si Cornelio. Kapitan tanandia ong batalion tang mga sondalong Romano ang aggoyan ta Batalion Italiano. ");
INSERT INTO agn_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ang taw ang narin madinioson, ig tanandia asta ang pamalay-balay na may eled nira ong Dios. Pirmi tanandiang pagtabang ong mga Judiong malilised, ig pirming pangadi. ");
INSERT INTO agn_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tatang kaldaw, asing magalas tris tang apon, may inita na ong tatang midio talakinep ang tatang anghil ang sinobol tang Dios ang agpalenget ong nandia ig nagigampang ang ganing, “Cornelio.” ");
INSERT INTO agn_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pinanengnengan na ig dorong eled nang siminabat, “Onopa si, Gino?” Ganing tang anghil ong nandia, “Pinama-yan tang Dios tang pangadi mo ig galipay tanandia ong mga boat mong pagtabang ong mga malilised. ");
INSERT INTO agn_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mandian, manobola ta pirapang taw ong Jope ig ipakomit mo don tang taw ang aran na Simon, ang aggoyan ka ta Pedro. ");
INSERT INTO agn_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tanandia don pagdayon ong balay ni Simon ang manigkanit ta olit ta ayep, ong binit tang baybay.” ");
INSERT INTO agn_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Animan asing nagalin da tang anghil, dayon ang ginoyan ni Cornelio tang doroang torobolon na ig tanga sondaloan ang madinioson, tata ong nandiang gatobol-tobol. ");
INSERT INTO agn_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Sinayod na ong nira tang tanan ang nainabo, ig sinobol na tanira ang paning ong Jope. ");
INSERT INTO agn_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pagaramal, asing alenget da ong Jope tang mga sinobol ni Cornelio, kimina-yat si Pedro ong patag ang katep tang balay para mangadi. Ang oras ang asi ko-to tang kaldaw. ");
INSERT INTO agn_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Agle-men da tanandia, ig galiliag da rin tanandiang mamangan. Piro mintras agsimpanen pa tang pamangan, may pinaita tang Dios ong ni Pedro. ");
INSERT INTO agn_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Inita na ang inabrian tang langit ig may midio mala-bang ang kolton ang agpababak ong kalibotan ang agtotonton ong epat ang potod na. ");
INSERT INTO agn_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ig ang na-tang ong kolton ang asi ay ang tanan ang klasi ta mga ayep ang papanaw ig kakandoang ong tanek, asta ang mga lalayog ong dibabaw. ");
INSERT INTO agn_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ig may naba-yan nang tatang bosis ang ganing, “Kendenga, Pedro. Magpataya ta ayep ig mamangan.” ");
INSERT INTO agn_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Siminabat si Pedro, “Indi enged maboato, Gino. Maski tanopa, indio pa gapamangan ta maski onopang bagay ang poiding maning ta maboling ig belag ta paranganen sigon ong Katobolan.” ");
INSERT INTO agn_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Minitala sing oman tang bosis ang asi ong ni Pedro ang ganing, “Indi aningen mong maboling tang mga bagay ang linimpio ra tang Dios.” ");
INSERT INTO agn_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tolong bisis ang nainabo narin. Pagatapos, dayon dang binatak tang kolton ong langit. ");
INSERT INTO agn_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Mintras aggisipen ni Pedro tang maliag yaning tang inita nang asi, kiminabot da tang mga taw ang sinobol ni Cornelio. Tenged asing nata-wanan nira tang balay ni Simon, nagdiritso tanira don. ");
INSERT INTO agn_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Giminoy tanira ig namane-ma mga don ka kaman dadayon tang taw ang aran na si Simon ang aggoyan ka ta Pedro. ");
INSERT INTO agn_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Mintras pagpaino-ino si Pedro ong inita na, ganing tang Ispirito Santo ong nandia, “May tolong laling pagdilem ong nio. ");
INSERT INTO agn_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tomaboana don ig tomabida ang anday doadoa. Tenged yo tang nanobol ong nira.” ");
INSERT INTO agn_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Animan dayon ang siminaboan si Pedro, ig ganing tanandia ong mga taw, “Yo tang agdilemen mi. Onopa rin tang kaministiran mi?” ");
INSERT INTO agn_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ganing tanirang siminabat, “Sinobol ami ong nio tang Kapitan ang si Cornelio. Mo-yang taw tanandia ig may eled na ong Dios. Aggalangen tanandia tang tanan ang mga Judio. Inaning tanandia ta tatang anghil ang nagalin ong Dios ang ipakomita agod maba-yan na tang onopay yaning mo.” ");
INSERT INTO agn_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Oman pinadayon tanira ni Pedro ig don tanira nangapoyat ang labing asi. Pagaramal, nagsimpan si Pedro ig siminabid da ong nira. Ang domang mga pamagto don ong Jope namansitabid ka ong nira. ");
INSERT INTO agn_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ang domaton ang kaldaw kiminabot tanira ong Cesarea. Pagelat ong nira si Cornelio, aroman tang mga kaparintian ig mga masesebek ang tangay ang pinangimbitar na. ");
INSERT INTO agn_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Asing te-led da si Pedro, binagat tanandia ni Cornelio. Ig liminod ong kakayan ni Pedro agod towan na tanandia. ");
INSERT INTO agn_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Piro pina-deng tanandia ni Pedro ig ganing, “Ayaw. Kendenga. Yo pario mi kang taw.” ");
INSERT INTO agn_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mintras te-led tanira ong balay, sigi tang pagigampang ni Pedro ong ni Cornelio. Ig inita nang doro rang mga taw ang namagimes don. ");
INSERT INTO agn_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ganing si Pedro ong nira, “Gata-wanan mi mismo ang yaming mga Judio agbawalen tang rilihion amen ang magigtabid obin mamisita ong mga belag ta Judio. Piro pinaita tang Dios ong yen ang indi dapat aningen ta maboling obin belag ta sarapeten tang maski sinopang taw. ");
INSERT INTO agn_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Animan asing pinakomito nio, siminabidong lagi ang anday riklamo. Mandian, mane-mao kay ang lagi, angay pinakomito nindio?” ");
INSERT INTO agn_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Siminabat si Cornelio, “Maning ta na sia. Tolo rang kaldaw ang nagta-lib, midio maning ka ta nang magalas tris tang apon ang pangadio tarin ong balay. Golping napaita tang tatang lali ong talongano ig makilaw ang pa-dekan tang lambong na. ");
INSERT INTO agn_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ganing tanandia ong yen, ‘Cornelio, pinama-yan da tang Dios tang pangadi mo ig galipay tanandia ong mga agboaten mong tabang ong mga malilised. ");
INSERT INTO agn_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Manobola ta taw don ong Jope ig ipakomit mo tang taw ang aran na si Simon ang aggoyan ka ta Pedro. Gistar tanandia don ong balay ni Simon ang manigkanit ta olit ta ayep. Ig ong binit tang baybay tang balay na.’ ");
INSERT INTO agn_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Animan pinakomitang lagi yen ig pagpasalamato ta mo-ya ang nakabota ra ka. Mandian narin aming tanan ong talongan tang Dios para mamasi mga onopa tang ipabitala ong nio tang Gino.” ");
INSERT INTO agn_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Animan nagimpisa rang minitala si Pedro, “Gata-wanano ra enged, ang Dios anday pinilikan na. ");
INSERT INTO agn_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Galipay tang Dios ong maski sinopang taw ang may eled ong nandia ig pagboat ta mato-lid, maski ong aypa pang nasion tanandia nagalin. ");
INSERT INTO agn_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gata-wanan mi ang mga inampo ni Israel, sindolan tang Dios tang mga bitala na, ig pinatako na ong nira tang Mo-yang Balita ang mabalik ita ong Dios ong tabang ni Jesu-Cristo, ang yay ang Gino tang tanan. ");
INSERT INTO agn_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nabalitan mi ka tang nainabo ong bilog ang Judea, impisa don ong Galilea pagatapos tang pagtoldok ig pagboniag ni Juan. ");
INSERT INTO agn_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ang agsambiteno yay si Jesus ang taga Nazaret, ang sindolan tang Dios ta Ispirito Santo ig gaem. Tenged ong nandia tang Dios, napagboat tanandia ta kao-yan ig napagpao-ya ong tanan ang agpaliwagan ta mga malain ang ispirito maski ong aypa tanandia napaning. ");
INSERT INTO agn_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yami mismo nangaita tang tanan ang bindoat ni Jesus don ong siodad tang Jerusalem ig ong domang mga logar tang mga Judio. Piro ang bindoat tang mga taw, pinatay nira ang pinalansang ong kros. ");
INSERT INTO agn_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Piro si Jesus binoing oman tang Dios ang ya-long kaldaw, oman pinaita na tanandia ong yamen. ");
INSERT INTO agn_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Indi tanandia inita tang tanan ang taw, kondi yami lamang ang pinilik tang Dios ang magtistigo ong doma natetenged ong nandia. Namagigsaro ami pa ong nandia asing naboi rang oman tanandia. ");
INSERT INTO agn_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Si Jesus tang nagtobol ong yamen ang magpatako tang Mo-yang Balita ong mga taw, ig magpamatod ang tanandia tang bindoat tang Dios ang manigosgar ong tanan ang mga taw, maging boi obin patay. ");
INSERT INTO agn_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ig tanandia tang sinambit tang mga propita asing tokaw ang ganing, ‘Maski sinopay magto ong nandia patawaden ong mga kasalanan nira, mga gomoy lamang ong aran na.’ ” ");
INSERT INTO agn_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bibitala pa si Pedro asing napababak tang Ispirito Santo ong tanan ang pamamasi tang bitala na. ");
INSERT INTO agn_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nangabereng ta mo-ya tang mga aroman ni Pedro ang namagalin ong Jope ang yay ang mga Judiong pamagto ra ong Gino. Tenged inita nira nga ang Ispirito Santo sindol ka tang Dios ong mga belag ta Judio. ");
INSERT INTO agn_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Naba-yan nirang pamansibitala ong sari-saring mga bitala ang pamagdayaw ong Dios. Animan ganing si Pedro ong nira, ");
INSERT INTO agn_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Pario ta, ang mga taw ang narin sindolan ka tang Ispirito Santo. Indi poiding maning ang indi ka maboniagan ong wi!” ");
INSERT INTO agn_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ig dayon tanandiang nagordin ang boniagan tanirang tanan ong aran ni Jesu-Cristo. Pagatapos, inimbitar nira si Pedro ang magtinir kang lagi tanandia ong nira ta pirapang kaldaw. ");
INSERT INTO agn_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mandian nabalitan tang mga apostolis may ang mga pamagto ong bilog ang Judea ang namagparet da tang belag ta mga Judio ong bitala tang Dios. ");
INSERT INTO agn_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Animan, pagabalik ni Pedro ong Jerusalem binasol tanandia tang mga Judio ang pamagto ra ka ong ni Cristo piro pamagtoldok ang ganing kaministiran ono magpatori tang mga lali agod magtoman ong Katobolan. ");
INSERT INTO agn_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ganing tanira, “Angay napaninga ong balay tang mga belag ta Judio ig nagigsaroa pa ong nira?” ");
INSERT INTO agn_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dayon ang sinayod ni Pedro ong nira tang nainabo magimpisa ong primiro. ");
INSERT INTO agn_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ganing tanandia, “Asing yo dono ong Jope ang pangadi, may pinaita tang Dios ong yen ong tatang midio talakinep. Initao ang may tatang bagay ang agpababak ig mga telekano midio kolton ang mala-bang. Agtotonton magalin ong langit ong epat ang potod na, ig ong silido siminareng. ");
INSERT INTO agn_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Liniparao ta mo-ya ig initao ang mga teled na sari-saring klasi ta mga ayep. May mga ayep ang papanaw, ayep ang talonanen, ayep ang kakandoang ig mga ayep ang lalayog. ");
INSERT INTO agn_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ig naba-yano tang tatang bosis ang ganing, ‘Kendenga, Pedro. Magpataya ig mamangan!’ ");
INSERT INTO agn_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Piro siminabato ang ganing, ‘Indi enged maboato, Gino! Maski tanopa, indio pa gapamangan ta maski onopang bagay ang poiding maning ta ang maboling ig belag ta paranganen sigon ong Katobolan.’ ");
INSERT INTO agn_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Dayon sing minitala tang bosis ang nagalin ong langit, ‘Indi aningen mong maboling tang linimpio ra tang Dios.’ ");
INSERT INTO agn_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tolong bisis ang nainabo narin, ig pagatapos ta si dayon dang binatak ong langit. ");
INSERT INTO agn_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ong mismo kang oras ang asi, kiminabot ka ong balay ang agdayonano tang tolong laling sinobol ong yen nagalin ong Cesarea. ");
INSERT INTO agn_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Inaningo tang Ispirito Santo ang tomabido ong nira ang anday doadoa. Napanaw ami ig siminabid ka ong yen tang enem ang nang mga logod, ig siminled aming tanan ong balay ni Cornelio ong Cesarea. ");
INSERT INTO agn_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Sinayod na ong yamen ang may inita nang anghil ang ke-deng ong teled tang balay na ig ganing ong nandia, ‘Manobola ta taw ong Jope ig ipakomit mo tang taw ang aran na si Simon ang aggoyan ka ta Pedro. ");
INSERT INTO agn_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","May ibalita na ong nio ang gamiten tang Dios agod malibria asta ang tanan ang pamalay-balay mo.’ ");
INSERT INTO agn_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Mandian asing ba-lo lamang ang nagimpisao ang mitala, napababak da ong nira tang Ispirito Santo pario tang pagpababak na ong yaten asing tokaw. ");
INSERT INTO agn_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ig nademdemano tang bitala tang Gino, ang ganing, ‘Si Juan, nagboniag ta wi piro yamo, boniagan amo ra ta Ispirito Santo.’ ");
INSERT INTO agn_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mandian, mga ang belag ta Judio sindolan ka tang Dios tang Ispirito Santo pario tang bindoat na ong yaten asing nagto ita ong ni Ginong Jesu-Cristo, sinopa yo ang masagang ong Dios?” ");
INSERT INTO agn_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Asing pagabasi nira tang inaning ang na ni Pedro, siminareng da tanirang nagbasol. Ig namagdayaw tanira ong Dios ang ganing, “Mga maning ta si, ang mga belag ta Judio agtoldan ka ta timpong mapagtogat ig magba-lo agod maboing anday kataposan!” ");
INSERT INTO agn_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ang mga pamagto ong ni Jesus namagwasag tenged ong pagpaliwag ang nagimpisa asing patayen si Esteban. Ang doma ong nira nangakabot ong Fenicia, ong Cyprus ig ong Antioquia ang sigi tang toldok nira tang bitala tang Dios, piro belag ta ong tanan ang taw kondi ong mga Judio lamang. ");
INSERT INTO agn_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Piro ang doma ong nira ang mga taga Cyprus ig taga Cirene, ong pagkabot nira ong Antioquia nagigampang ka tanira ong mga belag ta Judio ig nagpatako ong nira tang Mo-yang Balita natetenged ong ni Ginong Jesus. ");
INSERT INTO agn_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ong nira tang gaem tang Gino, animan dorong mga taw ang namagto ig namagosoy ong Gino. ");
INSERT INTO agn_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ang nainabong narin nabalitan tang mga pamagto ong ni Cristo don ong Jerusalem. Animan dayon ang sinobol nira si Bernabe ang paning ong Antioquia. ");
INSERT INTO agn_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Asing pagkabot na don ig inita nang aggaloyan tanira tang Dios, nalipay tanandia ta mo-ya ig linaygayan na tanirang paeleten nira tang pagosoy nira ong Gino, ang de-dek ong mga popotokon nira. ");
INSERT INTO agn_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tenged mo-yang taw si Bernabe. Aggaeman tanandia tang Ispirito Santo ig maelet tang pagto na ong Dios. Ig dorong mga taw tang nae-lan nang magparet ong Gino. ");
INSERT INTO agn_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Dayon ang napaning si Bernabe ong Tarso para dilemen na si Saulo. ");
INSERT INTO agn_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Asing inita na ra si Saulo, ingkelan nang nagbalik ong Antioquia. Nagpatakon enged tanira don ang nagigimbeng ong mga pamagto ong ni Jesus, ig dorong mga taw tang sinoldokan nira. Ig don ka ong Antioquia, tokaw ang ginoyan ta “Cristiano” tang mga sinagpan tang Gino. ");
INSERT INTO agn_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ang mga kaldaw ang asi may mga manigpakabot tang bitala tang Dios ang kiminabot ong Antioquia nagalin ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kimindeng tang tata ong nira ang aran na si Agabo, ig ong gaem tang Ispirito Santo nagpatako tanandia ang magkatinir ta mabael ang tagletem ong bilog ang kalibotan. (Ang tagletem ang asi nainabo ka kaman asing timpong si Claudio tang Adi tang Roma.) ");
INSERT INTO agn_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ig ang mga sinagpan tang Gino don ong Antioquia, namaginigoan tanirang mamagpaekel ta tabang ong mga pamagto don ong Judea, sigon ong masarangan tang kada tata ong nira. ");
INSERT INTO agn_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Maning ta don ka kaman tang bindoat nira. Pinaekel nira ong da Bernabe ni Saulo tang mga tabang nira para i-dol ong mga mepet ang pangolokolo ong mga pamagto ong ni Cristo don ong Judea. ");
INSERT INTO agn_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ang mga timpong asi, pinadep ni Ading Herodes tang domang mga pamagto ong ni Cristo, agod paliwagan na tanira. ");
INSERT INTO agn_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Si Santiagong logod ni Juan pinapatay na ong ispada. ");
INSERT INTO agn_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ig asing itaen nang nalipay tang mga Judio ong bindoat nang asi, si Pedro si tang pinadep na. Nainabo na asing Pista tang Tinapay ang Anday Pampalsa na. ");
INSERT INTO agn_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pagadep ong ni Pedro, dayon ang pinriso ig pinabantayan ong epat ang gropo ta mga sondalo ig tagepat-epat tang kada gropo. Ang plano ni Herodes, ipatalonga tanandia ong mga Judio pagatapos tang Pista tang Pagta-lib tang Anghil. ");
INSERT INTO agn_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Animan agprison pa si Pedro. Piro ang mga pamagto ong ni Cristo bogos ang pamagampo ong Dios para ong ni Pedro. ");
INSERT INTO agn_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ong domaton ang kaldaw, ipatalonga ra rin ni Herodes si Pedro ong mga taw. Ang labing asi, gapoyat si Pedro ong ka-ngan tang doroang sondalo, ig agkadinan ta doroang kadina. May pamaggoardia pa ong portan tang prisoan. ");
INSERT INTO agn_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Lagat-lagat ta ge-ley, golping napaita don ang tatang anghil tang Gino, ig nangayag ta mo-ya tang teled tang prisoan. Kinalbit tang anghil si Pedro ong silid na ig pinoaw ang ganing, “Mambangona, dali!” Ig golping naokas tang mga kadina ong mga kalima na. ");
INSERT INTO agn_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ganing ka tang anghil ong ni Pedro, “Maglambonga ra! Tokon mo tang rapak mo.” Nagtoman ka si Pedro, ig ganing si tang anghil, “Tokon mo tang lambong mong panta-paw ig domatona ong yen.” ");
INSERT INTO agn_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Dayon ang limindoa si Pedro ig diminaton ong anghil. Piro indi gata-wanan na mga matod tang gainabo. Ang kalaom na, panalakinep lamang tanandia. ");
INSERT INTO agn_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nata-liban nira tang primiro ig ang yadoang goardia. Pagakabot nira ong portan ang taltalen ang paning ong siodad, nagabri narin ong sadili na, ig dayon ang limindoa tanira. Pagapanaw nirang pagosoy tang karsada, golping bino-wanan tang anghil si Pedro. ");
INSERT INTO agn_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ba-lo pa nata-wanan ni Pedro ang belag pala ta talakinep tang nainabo ong nandia. Ganing tanandia ong sadili na, “Mandian nata-wanano! Matod ka kaman ang sinobol tang Dios tang anghil ig linibrio nandia ong kalima ni Herodes, ig ong aggelaten tang mga Judiong boaten ong yen.” ");
INSERT INTO agn_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Asing nata-wanan ni Pedro ang nalibri ka kaman tanandia, napaning tanandia ong balay ni Mariang nanay ni Juan ang aggoyan ka ta Marcos. Don ong nira dorong mga taw ang pamagimes ig pamangadi. ");
INSERT INTO agn_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nano-tok si Pedro ong portan ong loa, ig ang torobolon ang si Roda tang liminenget para telekan mga sinopa si. ");
INSERT INTO agn_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nailala na tang bosis ni Pedro ig ong kalipay na imbis ang abrian na tang portan, nanikad tanandia ong teled ig nagbalita ong nira ang si Pedro asia ong loa. ");
INSERT INTO agn_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Gabeyega ra sigoro?” ganing tanira. Piro pagpareges si Rodang asi ono si Pedro. Animan ganing tanira, “Taben anghil na si!” ");
INSERT INTO agn_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Sigi pa tang pano-tok ni Pedro, ig asing inabrian nira tang portan, midio indi tanira mamagparet ang si Pedro ka kaman tang inita nira. ");
INSERT INTO agn_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Sininiasan tanira ni Pedro ang indi mamaginingal. Dayon ang sinaysay na mga monopa tanandia pinaloa tang Gino ong prisoan. Ig ganing pa tanandia, “Ibalita mi kay narin ong ni Santiago ig ong domang mga logod.” Pagatapos ta si, dayon dang nagalin si Pedro ig napaning ong domang logar. ");
INSERT INTO agn_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pagaramal, nangataranta ta mo-ya tang mga goardia tenged ong pagalipat ni Pedro. Ig indi mata-wanan nira mga onora tang nainabo ong nandia. ");
INSERT INTO agn_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Dayon ang nagordin si Herodes ang dilemen si Pedro, piro indi inita nira. Animan pinaimbistigar na tang mga goardia ig pinapatay. Pagatapos nagalin si Herodes ong Judea napaning ong Cesarea, ig don da nagtinir. ");
INSERT INTO agn_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Mandian si Herodes naboay dang gasilag ong mga taga Tiro ig taga Sidon. Animan namagampang-ampang tanirang lemenget ong nandia, tenged ang pamangan tang mga banoa nira agkomiten nira ong banoa ni Herodes. Primiro nagigtangay tanira ong ni Blasto para matabangan na tanira, tenged tanandia tang agtaligan tang adi ong palasio. Pagatapos, napaning tanira ong adi para magigosay ong nandia. ");
INSERT INTO agn_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Animan ang adi nagtirmino ta kaldaw para tomalonga ong mga taw. Ig pagakabot tang kaldaw ang asi, sinok na tang lambong na bilang adi, ig kiminarong ong trono ig nagdiskorso ong mga taw. ");
INSERT INTO agn_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Dayon ang namaginiteg tang mga taw ang ganing, “Belag ta taw tang bibitalang asia! Dios da!” ");
INSERT INTO agn_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ig don ang lagi sinilotan si Herodes tang tatang anghil ang nagalin ong Gino tenged sinadili na tang dengeg ang dapat para ong Dios lamang. Pinangan tanandia ta kolod asta ra lamang napatay. ");
INSERT INTO agn_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Piro ang bitala tang Dios mas nagsaboag pa ig dorong namagparet. ");
INSERT INTO agn_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Mandian, asing natapos da ni Bernabe ig ni Saulo tang obra nira ong Jerusalem, namagbalik da tanirang doroa ong Antioquia, ang aroman nira si Juan Marcos. ");
INSERT INTO agn_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ong mga pamagto ong ni Cristo don ong Antioquia, may mga manigtoldok ig mga manigpakabot tang bitala tang Gino. Kabilang don si Bernabe, si Simeon ang aggoyan ta Negro, si Luciong taga Cirene, si Saulo ig si Manaen ang tangay tang gobirnador ang si Herodes impisa asing ge-ley pa tanira. ");
INSERT INTO agn_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Asing pamagpaletem ig pamangadi ang mga narin, ganing ong nira tang Ispirito Santo, “Ipalbag mi si Bernabe ig si Saulo. Piniliko tanira para ong tatang obra ang nataganao ong nira.” ");
INSERT INTO agn_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Animan asing pagatapos nirang magpaletem ig mangadi, binondo nira tang mga kalima nira ong da Bernabe ni Saulo. Pagatapos pinapanaw da nira tang doroa. ");
INSERT INTO agn_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mandian si Bernabe ig si Saulo, ang sinobol da tang Ispirito Santo, dayon ang napaning ong Seleucia. Magalin don nagbiahi tanira paning ong isla tang Cyprus. ");
INSERT INTO agn_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Don ong Cyprus napatampet tanira ong Salamina, ig don namagtoldok tanira tang bitala tang Dios ong mga simban tang mga Judio. Pinatabid ka nira si Juan Marcos para tomabang. ");
INSERT INTO agn_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Linibot nira tang bilog ang isla asta nangakabot tanira ong lansangan tang Pafos. Nabagat nira don tang tatang madyikirong Judio ang pangambo ang tanandia propita. Si Bar-Jesus tang aran na. ");
INSERT INTO agn_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Pagtangayan tanandia ni Sergio Paulo, ang gobirnador tang islang narin. Ang gobirnador ang na dorog katakong taw. Pinagoy na si Bernabe ig si Saulo tenged galiliag tanandiang mamasi tang bitala tang Dios. ");
INSERT INTO agn_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Piro kinontra tanira tang madyikirong si Elimas, ang yay ang aran ni Bar-Jesus ong bitalang Grigo. Aggawidan na tang gobirnador ang itaben magto ra ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mandian si Saulo, ang aggoyan ka ta Pablo, ginaeman da tang Ispirito Santo. Pina-dekan na si Elimas, ");
INSERT INTO agn_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ig ganing tanandia, “Yawang ana ni Satanas! Dayadora ig manloloko! Kasoay mo tang tanan ang mo-ya! Doroa kabo-li ig doroa kalain! Tanoapa magtareng ang magbali-kad tang kamatodan natetenged ong Gino? ");
INSERT INTO agn_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mandian silotana ra tang Dios! Maboraya ra. Ig maboay-boaya ang india maita ta kayagan tang kaldaw!” Lagi-lagi nangorabo ig nangi-lep tang pama-dek ni Elimas asta indi ra tanandia maita. Nangarap-karap da lamang tanandia ta taw ang magantabay ong nandia. ");
INSERT INTO agn_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Asing inita tang gobirnador tang nainabong narin, nagto ra tanandia ong Gino, ig dorong kabeberengen na ong mga toldok da Pablo natetenged ong Gino. ");
INSERT INTO agn_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pagalin nira ong Pafos, nagbiahi da Pablo ig ang mga karomanan na tegka ong Perga, tatang siodad don ong Pamfilia. Asing don da tanira, binayan tanira ni Juan Marcos ig nagbalik tanandia ong Jerusalem. ");
INSERT INTO agn_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Magalin ong Perga, nagpadayon tanira ig kiminabot ong siodad tang Antioquia, sakep tang Pisidia. Pagakabot tang Kaldaw ang Igperenay, dayon tanirang napaning ong simban tang mga Judio ig kiminarong tanira don. ");
INSERT INTO agn_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pagatapos ang basaen tang Katobolan ni Moises, asta ang mga sinolat tang mga propita, nagpatobol ong nira tang mga pangolokolo ong simban ang ganing, “Mga logod, mga may bitala ming matabang ong mga taw, mibek-ibek amo atan.” ");
INSERT INTO agn_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Animan kimindeng si Pablo, ig sininiasan na tang mga taw tang kalima na ang indi ra mamaginingal. Ganing tanandia, “Mga kasimanoao ang mga Israelita, asta yamong mga belag ta Judiong may eled ong Dios, mamasi amo ong yen! ");
INSERT INTO agn_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ang Dios ang agtowan tang mga Israelita yay ang namilik ong yaten ang mga kamepet-mepetan asing tokaw. Asing don tanira gingistar ong Ehipto, bindoat tanira tang Dios ang tatang mapoirsang nasion ig ong nandiang makabebereng ang gaem ingkelan na tanira ang magalin ong Ehipto. ");
INSERT INTO agn_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ong teled ta epat ang polok ang takon ang tanira don ong logar ang anday gistar ang taw, inagoanta tang Dios tang katetegaten tang mga kolo nira. ");
INSERT INTO agn_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pagatapos ta si, linangga na tang pitong nasion ong logar tang Canaan, ig sindol na ong mga inampo ni Israel tang mga tanek agod magimong mga sadiling banoa nira. ");
INSERT INTO agn_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ang tanan ang na bindoat tang Dios ong teled tang epat ang gatos ig limang polok ang takon. “Pagatapos, sindolan tanira tang Dios ta mga osgado ang mangolokolo ong nira, asta ong timpo tang propitang si Samuel. ");
INSERT INTO agn_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Asing mama-dol tanira ta sadiling adi nira, sindol ong nira tang Dios si Saulong ana ni Cis, tatang laling nagalin ong tribo ni Benjamin. Naggaem si Saulo bilang adi ong teled ta epat ang polok ang takon. ");
INSERT INTO agn_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ig asing tanggalen da tang Dios si Saulo, si David yay ang sinlet na ong nandia. Maning ta narin tang inaning tang Dios natetenged ong ni David, ‘Initao ang si David, ang ana ni Jesse, tatang taw ang galiliagano ta mo-ya. Magtoman tanandia tang tanan ang galiliagano.’ ");
INSERT INTO agn_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ig tarin ong dogo ni David nagalin si Jesus, ang Maniglibri ang pinangako tang Dios ong Israel. ");
INSERT INTO agn_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ba-lo kiminabot si Jesus, si Juan ang Manigboniag nagtoldok dang lagi ong mga Israelita ang mamagtogat ong mga kasalanan nira ig mamagpaboniag. ");
INSERT INTO agn_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ig asing natapos da ni Juan tang obra na, ganing tanandia ong mga taw, ‘Sinopa yo ong pabetang mi? Begen amo yen, belago tang aggelaten ming komabot. Piro pama-yan mi, komabot tanandiang domaton ong yen, ig belago ta bagay ang magsirbi ong nandia maski ngani magobad tang kordon tang rapak na.’ ” ");
INSERT INTO agn_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ganing pa si Pablo, “Mga logod ang mga inampo ni Abraham, asta yamong mga belag ta Judiong may eled ong Dios, ong yaten mismo pinatako tang balitang nang ganing ilibri ita tang Dios. ");
INSERT INTO agn_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ang mga taga Jerusalem may ang mga pangolokolo ong nira indi gangatakong si Jesus yay ang Maniglibri. Indi ka naintindian nira tang mga sinolat tang mga propita asing tokaw, ang agbasaen kada Kaldaw ang Igperenay. Piro tanira ya ka tang nagboat tang inaning dang lagi tang mga propita asing sinintinsian nira si Jesus ta kamatayen. ");
INSERT INTO agn_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Maski anday itaen nirang ibidinsia ang dapat patayen si Jesus, pina-dol pa ka nira ong ni Pilatong ipapatay tanandia. ");
INSERT INTO agn_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ig pagatapos ang boaten nira ong ni Jesus tang tanan ang inaning tang Kasolatan ang mainabo ong nandia, kinomit nira tang sinangoni na ong kros ig limbeng. ");
INSERT INTO agn_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Piro si Jesus binoing oman tang Dios. ");
INSERT INTO agn_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ig ong teled ta dorong kaldaw, napaita tanandia ong mga taw ang namansitabid ong nandia asing nagalin tanandia ong Galilea asta nakabot ong Jerusalem. Ang mga taw ang na ya ray pamagpamatod mandian ong mga Israelita natetenged ong ni Jesus. ");
INSERT INTO agn_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ig mandian, nani ami ra kang pagbalita ong nindio tang Mo-yang Balitang na: Ang pangako tang Dios asing tokaw ong mga kamepet-mepetan ta ");
INSERT INTO agn_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ay naboat na ra ong yaten ang mga inampo nira asing si Jesus binoing oman. Maning ta na enged tang ga-tang ong yadoang Salmo, ang ganing, ‘Yawa tang Anao, ig mandian agpaitao ang yo tang Tatay mo!’ ");
INSERT INTO agn_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Si Jesus binoi ka kaman tang Dios, ig indi pinabayan nang maronot tang sinangoni na, kompormi ong pangako na asing tokaw ang ganing, ‘I-dolo ong nindio tang mga sagrado ig sigoradong mga bindision ang pinangakō ong ni David.’ ");
INSERT INTO agn_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ig ganing pa ka don ong domang salmo, ‘Tenged indi pabayan mong maronot tang sinangoni tang sagradong torobolon mo!’ ");
INSERT INTO agn_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Asing timpo pa ni David, bindoat na tang tanan ang pinaboat tang Dios ong nandia. Oman pagapatay na, limbeng tanandia ong lebengan tang mga kamepet-mepetan na, ig naronot tang sinangoni na. ");
INSERT INTO agn_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Piro si Jesus ang binoing oman tang Dios, ang sinangoni na indi enged naronot. ");
INSERT INTO agn_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Animan dapat ang mata-wanan mi, mga logod, ang narin tang agpatako amen ong nindio tenged ong bindoat ni Jesus— ang mapatawad ita ong mga talak ta. ");
INSERT INTO agn_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ig ang tanan ang pamagtalig ong nandia pinatawad da ong mga talak nira, maski ong mga talak ang indi mapatawad mga nagtoman ita lamang ong Katobolan ni Moises. ");
INSERT INTO agn_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Animan magandam amo! Itaben mainabo ong nindio tang inaning tang mga propita asing tokaw ang ganing, ");
INSERT INTO agn_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Telekan mi, yamong mga masiadong mamanlibak! Mangabereng amo ig mangapatay! Tenged magboato ta mga makabebereng ang bagay ong timpo mi, ang indi amo magparet, m