﻿USE sofia;
DROP TABLE IF EXISTS sofia.agm_vpl;
CREATE TABLE agm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES agm_vpl WRITE;
INSERT INTO agm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kɨmiya Jisasɨ Kɨraisihomɨ saisatoyaare. Iyataatɨ Jisaasiho so Daawitɨhomɨ jɨtɨpatɨ napipatetapɨ noaipahore. Aihɨ amɨ Daawitɨho soaisangi Abɨraahamɨhomɨ jɨtɨpatɨ napipatetapɨ noaipahore. ");
INSERT INTO agm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aihɨ Abɨraahamɨho so Aisaakɨhomɨ sapɨhore. Aihɨ Aisaakɨho so Jekopɨhomɨ sapɨhore. Aihɨ Jekopɨho so Judaahomunɨ komɨ saingo saahoyaamunɨ sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iyataatɨ Judaaho so Peresiyɨ Jeraayaamɨ sapɨhore. Aihɨ kuramɨ sanaatɨ Tamaarɨhaate. Aihɨ Peresiho so Esɨronɨhomɨ sapɨhore. Aihɨ Esɨronɨho so Ramɨhomɨ sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aihɨ Ramɨho so Aminataapɨhomɨ sapɨhore. Aihɨ Aminadaapɨho so Naasonɨhomɨ sapɨhore. Aihɨ Naasonɨho so Sarɨmonɨhomɨ sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Aihɨ Sarɨmonɨho so Boaasihomɨ sapɨhore. Boaasihomɨ sanaatɨ Rehepɨhaate. Aihɨ Boaasiho so Obetɨhomɨ sapɨhore. Obetɨhomɨ sanaatɨ Rutɨhaate. Aihɨ Obetɨho so Jesihomɨ sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Aihɨ Jesiho so awaisɨho Daawitɨhomɨ sapɨhore. Aihɨ Daawitɨho so Sorɨmonɨhomɨ sapɨhore. Iyataatɨ Sorɨmonɨhomɨ sanaatɨ jɨhura Yuraiyaahomɨ apwaataatimatahaate. ");
INSERT INTO agm_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Iyataatɨ Sorɨmonɨho so Reoboaamɨhomɨ sapɨhore. Aihɨ Reoboaamɨho so Abaisaahomɨ sapɨhore. Aihɨ Abaisaaho so Asaahomɨ sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aihɨ Asaaho so Jehosapatɨhomɨ sapɨhore. Aihɨ Jehosapatɨho so Joramɨhomɨ sapɨhore. Aihɨ Joramɨho so Usaiyaahomɨ sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Aihɨ Usaiyaaho so Jotamɨhomɨ sapɨhore. Aihɨ Jotamɨho so Ahaisɨhomɨ sapɨhore. Aihɨ Ahaisɨho so Esikaiyaahomɨ sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Aihɨ Esikaiyaaho so Manasehomɨ sapɨhore. Aihɨ Manaseho so Emonɨhomɨ sapɨhore. Aihɨ Emonɨho so Josaiyaahomɨ sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Aihɨ Josaiyaaho Jekonaiyaahomunɨ komɨ saingosaahoyaamunɨ sapɨhore. Isɨmiya siya awaisawɨhiyaimatɨwɨ kiyaamɨ isɨhiya Judaahiyai winjaawɨ bimaamɨ napɨwɨ ipotaataatɨho iwinja bimihɨ isɨhiya Babironɨhiya napɨwɨ Judaahiyaamɨ aunahɨpatɨ niyapɨ tipɨ numwaasi kaanɨhɨ wapɨhɨ nuwɨ yapɨpatɨ Babironɨhanda napuhohurandaise. ");
INSERT INTO agm_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Aihɨ Isɨraherɨhiya Babironɨhanda napwɨtɨwɨ bimohuraapɨ isɨhiya siya saiwɨ namoyaatɨmɨ nowaayopo. Namoyaatɨmɨ nowaawɨ Jekonaiyaaho so Siyaarɨtiyerɨhomɨ sapɨhoematataise. Aihɨ Siyaarɨtiyerɨho so Serapaperɨhomɨ sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Aihɨ Serapaperɨho so Abaiyaatɨhomɨ sapɨhore. Aihɨ Abaiyaatɨho so Eraiyakimɨhomɨ Sapɨhore. Aihɨ Eraiyakimɨho so Asorɨhomɨ (Esorɨhomɨ) sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aihɨ Asorɨho so Satokɨhomɨ sapɨhore. Aihɨ Satokɨho so Akimɨhomɨ (Ekimɨhomɨ) sapɨhore. Aihɨ Akimɨho so Eraiyaatɨhomɨ sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aihɨ Eraiyaatɨho Eriyeserɨhomɨ sapɨhore. Aihɨ Eriyeserɨho so Matanɨhomɨ sapɨhore. Aihɨ Matanɨho so Jekopɨhomɨ sapɨhore. ");
INSERT INTO agm_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Aihɨ Jekopɨho so Josepɨhomɨ sapɨhore. Aihɨ Josepɨho so Mariyaahaatamɨ warɨhore. Aihɨ Mariyaahaatɨ Jisaasihoai namoyataise. Iyataatɨ nyahɨ Judaahiyaanɨnɨ kopɨ Isɨhiyai Japɨhɨ Numwaitandɨ Autaahaatɨho Ahɨwisɨhore taatɨ ambɨhɨtɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aihɨ Abɨraahamɨhoaapɨhapɨ isɨhiya sapiyaunɨ mwaayaunɨ ikwɨ maindɨmwɨtihɨ auhɨramɨ murɨtihɨ murɨtihɨ 14 kaiwɨ siyahaiwaara namoyaatɨmɨ napɨwɨ Daawitɨhoaapɨhɨ noaipawaayopo. Aihɨ amɨ Daawitɨhoaapɨhapɨ sapiyaunɨ mwaayaunɨ ikwɨ maindɨmwɨtihɨ auhɨramɨ murɨtihɨ murɨtɨhaiwaara 14 kaiwɨ namoyatɨmɨ nasauhɨ isɨhiya Babironɨhiya Isɨraherɨhiyai tipɨ numwaasi nuwɨ Babironɨhanda napuhauhɨ napwɨtohura noaipawaayopo. Aihɨ amɨ sura napwɨtɨwɨ bimohuraapɨ sapiyaunɨ amɨ mwaayaunɨ ikwɨ maindɨmwɨtihɨ auhɨramɨ murɨtihɨ murɨtɨhaiwaara 14 kaiwɨ namoyaatɨmɨ napɨwɨ Kɨraisiho Isɨhiyai Japɨhɨ Numwaitandɨ Autaahaatɨho Ahɨwisɨho noaipasurandaise. ");
INSERT INTO agm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisasɨ Kɨraisiho noaipasɨtɨhandapɨ pɨwɨha siyate. Jisaasihomɨ sanaatɨ Mariyaahaatɨ apwaimaamaatɨtihɨhura Josepɨhoai namaatɨto tɨwɨ aimɨ katɨwosauhɨhaate. Aihɨ kaatɨ Mariyaahaatɨ sangɨ Josepɨhoaisatɨ nanotɨ nehɨ bindataahandɨ kandɨ Autaahaatɨhomɨ Itɨpɨhoraahɨ kaatɨ aimɨ gwɨsɨndaise. ");
INSERT INTO agm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aihɨ kaatamɨ warɨho Josepɨho sandapɨ mmonataatɨ amɨ utaaho gaahosɨ Mariyaahaati mawɨhandɨ namunyatɨ bɨpi noaasatɨ kaatisɨnɨhɨ namaitotatɨ gwɨnyaataise. Aihɨ Josepɨho Mariyaahaati bɨpi namaitotatɨ taatɨ siyatɨ gwɨnyaataise. ");
INSERT INTO agm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Gwɨnyaasɨhɨ yapepataahɨ Autaahaatɨhomɨ enjerɨho otɨpɨpatɨho yamɨhapataatɨhɨ bimisɨho nehɨ koai wo Josepɨhoaapɨhɨ noaipatɨ koai saundataase. “Josepo Daawitɨhomɨhoŋe, kɨnyɨ Mariyaahaatapɨ netɨ wɨmiraitaano tɨpɨ wɨndɨ gɨmunyaape. Aimbɨ atime. Kɨmonjɨ metɨmonjɨ gwɨsɨhaatɨhɨ aimɨ kɨpwɨndisonyɨmonjɨ Autaahaatɨhomɨ Itɨpɨho kɨpotosihɨhonje. ");
INSERT INTO agm_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Isɨ Mariyaahaatɨ maaha woho namwɨtaise. Namwonɨhɨ ko noaipatɨ komɨ isɨhiyaamɨ maipɨhaiwa nemwatɨ japɨhɨ numwaitandɨhosɨ kɨnyɨ kɨretɨ saundɨpɨ Jisaasihoe tɨpɨ ambɨhunde,” undatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sɨmaiwa siyatɨ noaipasɨtɨmandɨ jɨhura Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨhoai Awaisɨho netɨ gɨwunyaasɨhɨ pɨwɨha wa katisɨha akaaha tɨtɨhɨ noaipaitandɨ sandɨ kiyataise. Aihɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho pɨwɨha wa sata kandaase. ");
INSERT INTO agm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Atime apwaimaamaatɨ waatɨ wohoaisatɨ wɨndɨ namohaatɨ gwɨsɨtatɨ maaha woho wo namwɨtaise. Namwonɨhɨ kiya Imaanuherɨhoe tɨwɨ ambɨhɨtɨtaapo,” tatɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho katatɨ ahaisɨhaare. Iyataatɨ satɨ ambɨhitamɨ tanyaahaarɨ, “Autaahaatɨho nyangisatɨndaise,” tawaawɨ “Imaanuherɨhoe,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aihɨ Josepɨho nanomatatɨ nepatɨ Autaahaatɨhomɨ enjeriho otɨpɨpatɨho yamɨhapataatɨhɨ bimisɨho nehɨ koai wo kaundimumwaaŋɨ kamwaaŋɨ tɨtɨhɨ kiyataise. Tɨtɨhɨ kiyatɨ Josepɨho komɨ apwaataati numwaataise. ");
INSERT INTO agm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Siyatɨ numwaataahandɨ kandɨ Josepɨho kaatisatɨ wɨndɨ maasɨ dahomaise. Nehɨ koai yandɨhɨ bimaamɨ notɨ kaatɨ maaha namwihɨhurandaise. Siyatɨ kaatɨ maaha woho namwihɨ Josepɨho ambɨpatɨ Jisaasihoe tatɨ ambɨpatɨ nusoaasataise. ");
INSERT INTO agm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aihɨ sura Erotɨho awaisɨhoematatɨ bimihɨ Mariyaahaatɨ Jisaasihoai Pɨropinjɨhandɨ Judiyaahandamɨ aunahɨpatɨ Betɨrehemɨhanda namotaise. Aimɨ namotɨ bimihɨhura isɨhiya usa ipɨho noaipasɨpɨpɨhapɨhiya kaumbwaatɨ noaipatɨ tɨhoaasɨhɨ mmonɨwɨ nepɨ awɨtohiyɨhiya (amɨ kaumbwaatɨ asaamaatɨ waatɨ noaipatɨ tɨhoaasɨhɨ iwinjamapɨ) Jerusaremɨhanda nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Napɨwɨ kiya satawaatopo, “Metɨhonjɨ wonjɨ kɨmbɨhɨ noaipasonyonjɨ sonjɨ Judaahiyaamɨ awaisɨhoematɨtandɨhosɨ maahapɨhe kaumbwaatɨ waatɨ konjapɨ noaipase tatɨ nanyisisaamaatɨ mɨhapɨhɨ ipɨho noaipasɨpɨpɨhapɨ nyahɨ usonaamapɨ iwinjawaatewainjamɨ nasahaayono konjapɨ atotɨpɨwesaatɨ gaapundaatɨ mepɨ autaahemwaitɨhaawo,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Satɨwɨ katauhɨ awaisɨho Erotɨho pɨwɨha atisataatɨ sata gwɨnyaataise wo awaisɨho wanɨho nisɨ aunahɨpatɨ nanaitaiso tatɨ aungwohandɨ yayataise. Aihɨ isɨhiya Jerusaremɨhandaahiyaisangi Erotɨhomataiwɨ aungwohandɨ yaiwɨmawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aihɨ awaisɨho Erotɨho namatɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ awaisawɨhiya pɨrisihiyaisunɨ amɨ isɨhiya usa wɨnɨhapɨpa katɨwunjohiyɨhiyaisunɨ numwaatɨ ahoyataise. Numwaatɨ ahoyatɨ kiyaisɨ sata nunjenataise. “Utaaho Isɨhiyai Japɨhɨ Numwaatɨ Iwinjatɨtandɨ Autaahaatɨho ahɨwisɨho aunahɨpatɨ maahɨwɨta noaipaitaise?” tatɨ kiyai nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nunjesɨhɨ kiya satɨwɨ kaundawaatopo, “Kɨmatɨ yapɨpatɨ Judiyaahandamɨ aunahɨpatɨ Betɨrehemɨhanda noaipaitaise. Iyataatɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho pɨropetɨho wo pɨwɨha wa satatɨ jɨpatɨpiyatɨ ahaisɨhaare. ");
INSERT INTO agm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sahɨ yapɨpatɨ Judiyaahandamɨ aunahɨpatɨ Betɨrehemɨhanda bimohiyɨhiyaate samɨ aunahɨpatɨ gwɨharaahatɨndaahandɨ kandɨ katɨ kapɨhata autaahɨtɨtaise. O amɨ apaapɨmaato amɨ samɨhatɨhapɨ awaisɨho wo noaipatɨ nisɨ isɨhiya Isɨraherɨhiyai iwinjaatɨ bimɨtaise,’ tatɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho katatɨ ahaisɨhaare,” undɨwɨ Erotɨhoai kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aihɨ awaisɨho Erotɨho bɨpi noaasa isɨhiya ipɨho noaipasɨpɨpɨhapɨhiyai gaatatɨ numwaatɨ kaumbwaatapɨ maahɨwuraanɨhɨ noaipasɨhɨ mmonawaayopo? Undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nunjesɨhɨ kiya wihoaaŋɨha kaundauhɨ amɨ ko kiyai jaiwɨta saundataase. “Nɨngimaawɨ nundɨ kopɨ gaapundɨtɨ mepɨ autaahemwaitaano. Isɨ sahɨ nuwɨ baiwɨ sonjɨ metonjapɨ daapɨ mmonɨwɨ kaiwɨse. Aiwɨ sonjɨ metonji daapɨ usonɨwɨmapɨ nɨngi napɨwɨ kandɨtaatɨwe,” undatɨ kiyai Betɨrehemɨhandaahapɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Natausaasihɨ kiya nowaayopo. Taawɨ nowaawɨ kaumbwaatɨ mɨhapɨhɨ ipɨho noaipasɨpɨpɨhɨ usonɨhohaamaatɨ kaati usonawaayopo. Aihɨ kaatɨ kaumbwaatɨ kiyaamɨ jɨhɨ naihɨ iwinjapepinjamɨ numbwɨwɨ kaatɨ kaumbwaatɨ notɨ metɨhonjɨ nanototimbɨpɨhɨ namɨhaataise. ");
INSERT INTO agm_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Siyatɨ kaumbwaatɨ namotɨ metɨhonjɨ nanototimbɨpɨhɨ notɨ namɨhaasɨhɨ kiya kaumbwaati usonawaawɨ aungwohandɨ asakaiwɨ maaritawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aihɨ kiya aŋaaŋɨ mɨhatɨhɨ nandaapɨ metɨhonjisunɨ sanaatɨ Mariyaahaatisunɨ usonawaayopo. Usonɨwɨ kapɨhɨ atotɨpɨwesawɨ bindawaawɨ metɨhonji mepɨ autaahɨwiwawaayopo. Aiwɨ kiyaamɨ ikihɨ naahepihaahapɨ wapa nawɨho awaisɨhotahapa anaahɨpɨpa gorɨhandunɨ amɨ wapa biyatɨ waamainjotahaiwa tausotɨpatɨ sameŋaihɨramatiyahapa amɨ wapa waahunɨho tapaipɨhomatiyahapa niyaapɨ Jisaasihoai nunyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aihɨ yapepataahɨ Autaahaatɨho kiyaisɨ Erotɨhoenda japɨhɨ namuwɨse undatɨ kaundataase. Kaundihɨ kiya namapɨ kiyaamɨ aŋɨpɨpɨhapɨ japɨhɨ daihɨra niyohɨrɨhɨra namɨhaapɨ wɨra nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aihɨ isɨhiya ipɨho noaipasɨpɨpɨhapɨhiya aimɨ niyauhɨ Autaahaatɨhomɨ enjerɨho otɨpɨpatɨho yamɨhapataatɨhɨ bimisɨho nehɨ koai wo yapepataahɨ Josepɨhoaapɨhɨ noaipatɨ saundataase: “Kɨnyɨ ketɨ dosisɨ metɨhonjisunɨ sanaatisunɨ numwaasisɨ yanɨhɨmapɨ yapɨpatɨ wɨtɨ Isipɨhandaahapɨ numwe. Numbwɨ bimambɨpɨ nɨwahonɨnɨ kahɨtisanɨhura japɨhɨ napɨtaapo amɨ Erotɨho metɨhonji tiwɨtandɨ daitaiso,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aihɨ Josepɨho atisatɨ dosi metɨhonjisunɨ sanaatisunɨ apatɨhɨ numwaasi yanɨhɨmatɨ kaanɨhɨ Isipɨhandaahapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Siyatɨ Josepɨho notɨ Isipɨhanda bimaamɨ notɨ Erotɨho napwisurandaise. Aihɨ Awaisɨho Autaahaatɨhomɨ pɨwɨha jɨhura komɨ pɨwɨha atisatɨ netɨ ausaasɨhomɨhetapɨ katisɨha ka akaaha tɨtɨhɨ noaipataise. Iyataatɨ Autaahaatɨho sandaase, “Nisɨ Maasɨhɨho Isipɨhanda bimihɨ nɨnɨ gandɨ japɨhɨ numwaataayo,” tatɨ katisɨha akaaha noaipataise. ");
INSERT INTO agm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aihɨ isɨhiya ipɨho noaipasɨpɨpɨhapɨhiya Erotɨhoai jaiwundohɨtɨhandapɨ koai apɨpaahɨ apousataise. Apowihɨ namatɨ ko tingaatɨhaisahiyai natausaasihɨ kiya nuwɨ Betɨrehemɨhandaahunɨ aunahɨpɨhaiwa kapɨhɨ detɨ ahetiwaiwaaraahunɨ metɨhonya wohonya kɨnaungwɨha yatɨwaapɨhapɨ yatɨhɨtahonya nahatonyai tiwawaayopo. Iyatɨ Erotɨho ipɨho noaipasɨpɨpɨhapɨhiyai nunjesɨhɨ kaumbwaatɨ noaipasuraapɨ kɨnaungwɨha siyatɨ aimɨ sanotaiso tatɨ gwɨnyaataatɨ ko sandɨ kiyataise. ");
INSERT INTO agm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aihɨ pɨwɨha wa Autaahaatɨho komɨ pɨwɨha atisa netɨ ausaasɨhomɨhetapɨ katisɨha akaaha noaipataise. Iyataatɨ sa pɨwa sata kandaase. ");
INSERT INTO agm_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Maarɨho asɨpaiwɨ aungwohandɨ gohɨtɨhandamɨ ŋuŋaaha aunahɨpatɨ Ramaahanda noaipasɨhɨ isɨhiya atisawaayopo. Sandɨ Reserɨhaatɨ kaatamɨ metɨhonya konyaanɨhɨ napopɨ apɨpaahonya owetauhɨ gotaasɨ kaatisɨ isɨhiya wɨndɨ nepɨ napaisaatumaamaitaapo,” tatɨ Autaahaatɨhomɨ pɨwɨha atisa netɨ ausaasɨho Jeremiyaahomɨ maahomwaaŋapɨ katisɨhaare. ");
INSERT INTO agm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aihɨ ipotɨhura Erotɨho aimɨ napwihɨ Isipɨhanda Autaahaatɨhomɨ enjerɨho otɨpɨpatɨho yamɨhapataatɨhɨ bimisɨho wo nasatɨ Josepɨhoaapɨhɨ noaipatɨ yapepataahɨ Josepɨhoai saundataase. ");
INSERT INTO agm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Isɨhiya metɨhonji tiwɨtaatɨwiyohiyɨhiya aimɨ napopo. Isɨ kɨnyɨ metɨhonjisunɨ sanaatisunɨ numwaasi yapɨpatɨ Isɨraherɨhandaahapɨ dosi naiwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aihɨ Josepɨho atisa dosi metɨhonjisunɨ sanaatisunɨ numwaasi yapɨpatɨ Isɨraherɨhandaahapɨ japɨhɨ nasataise. ");
INSERT INTO agm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nasatɨ Akeriyaasihopɨ sapɨho Erotɨhomɨ aunahɨpatɨ netɨ Judiyaahanda awaisɨhoematatɨ jaatɨ bindataise tauhɨ Josepɨho atisataatɨ namatɨ kapɨhɨ naitandɨ yayataise. Yaihɨ Autaahaatɨho yapepataahɨ pɨwɨha jɨhaatɨ Josepɨhoai kaundihɨ namatɨ Josepɨho kindari numwaasi yapɨpatɨ Pɨropinjɨhandɨ Garirihandaahapɨ niyataise. ");
INSERT INTO agm_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Niyatɨ yapɨpatɨ Garirihandamɨ aunahɨpatɨ taunɨhandɨ maipɨhonjɨ Nasaretɨhando tɨwɨ ambɨhɨtohɨpata bindataise. Iyataatɨ isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya jɨhura pɨwɨha satɨwɨ katohɨha akaaha noaipataise. Kiya kopɨ satawaatopo: “Ko Nasaretɨhandaahapɨhore, tɨwɨ ambɨhɨtɨtaapo,” tɨwɨ kiya katawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Aihɨ Jisaasiho Nasaretɨhanda aimɨ gwɨnyanatɨ bimisura Jonɨho Isɨhiyai Baawusɨtandɨho noaipataise. Noaipatɨ Judiyaahandamɨ yapɨpatɨ ipatɨ iwɨwɨrɨho owehapɨhɨ bindataatɨ Autaahaatɨhomɨ pɨwɨha sata ausaatɨ isɨhiyai saundataase. ");
INSERT INTO agm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Sahɨ samɨ maipɨhaiwa namapɨ nepemaitɨwɨ Autaahaatɨhoenda napɨwɨse amɨ Autaahaatɨho isɨhiyaanɨ nahatiyaanangi osamatɨ nyainjaatɨ bimɨtandɨhura aimɨ nasatɨ detɨndaiso,” tatɨ pɨwɨha ausaataise. ");
INSERT INTO agm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Iyataatɨ Jonɨho so jɨhura Autaahaatɨhomɨ pɨwɨha atisa netɨ ausaasɨho Aisaiyaahomɨhetapɨ Autaahaatɨho katisɨhore. Iyataatɨ Autaahaatɨho Aisaiyaahomɨhetapɨ satatɨ kandaase: “Isɨhiya iwɨwɨrɨho owehapɨhapɨ utaaho wo pɨwɨha satatɨ gandaase. ‘Awaisɨhopɨ daihɨra daawupwɨ tɨtɨhepumapɨse. Tɨtɨhepumapɨ baiwɨse’” ndaase tatɨ Aisaiyaaho kandaase. ");
INSERT INTO agm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jonɨho so maasapɨho kamerɨhandamɨ atɨha gwɨnɨwɨha niyohore. Niyotɨ yamepatɨ komɨ bwandɨpataapɨhɨ wɨsasanahore. Iyatɨ ko nandapa nainjɨpɨpa tapaatɨpɨhounɨ ipataatɨhapɨ apɨpaamɨ mwaahounɨ nanataise. ");
INSERT INTO agm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Aihɨ sura isɨhiya Jerusaremɨhandaahapɨhiyaunɨ amɨ yapɨpatɨ Judiyaahandaahapɨhiyaunɨ amɨ aunahɨpɨhaiwa kapɨhɨ waapɨhaatɨ Jorɨtaanɨhaatainapɨhiyaunɨ nuwɨ Jonɨhoaapɨhɨ noaipawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jonɨhoaapɨhɨ noaipapɨ kiyaamɨ maipɨhaiwa ausaapɨ nemɨhauhɨ Jonɨho kiyaisɨ waapɨhaatɨ Jorɨtaanɨhaata baawusataise. ");
INSERT INTO agm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aihɨ isɨhiya taahiyɨhiya Parisihiyaunɨ amɨ Satiyusihiyaunɨ waapoho naitaatɨwɨ nasauhɨ Jonɨho kiyai usonataise. Aihɨ Jonɨho kiyai usonataatɨ ko kiyai saundataase. “Sahɨ akwɨranɨho tataapwɨnɨhomɨ mwaayaatisɨ sapɨ Autaahaatɨhoai apowindɨhandɨ nemapɨ yanɨhɨmaitɨhaawo tɨwɨ sandɨ sahɨ kaitaawɨ owetise. ");
INSERT INTO agm_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Isɨ sahɨ saiwɨ satɨwɨ, ‘Nyahɨ nyamɨ maipɨhaiwa aimɨ namawaatɨ akɨtɨnɨhɨ nepemaitaatɨ Autaahaatɨhoenda aimɨ akɨtɨnɨhɨ nasɨhaayo,’ tɨwɨ isɨhiyai nunjawɨ akɨpɨpa kaiwɨ tɨtɨhɨ daiwɨse. ");
INSERT INTO agm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Isɨ sahɨ samɨ maarɨhoaatɨhapɨ satɨwɨ, ‘Nyahɨ Abɨraahamɨhomɨ mwaayaanɨ maatiyaanɨ saisatoyaanisɨ Autaahaatɨhomɨhiyaanɨne. Isɨ Autaahaatɨho nga nyangi nehɨ nanɨhiyatɨ nanyamaitaise,’ maatɨwɨse amɨ sahɨhɨmetisɨ Autaahaatɨhohɨ kɨmaiwa nawɨmaiwa netɨ nga Abɨraahamɨhopɨ komɨ saisatoyematɨ kiyatɨ ahaitaise. ");
INSERT INTO agm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Iyataatɨ mwɨsɨha ipatamɨ tambɨpɨhɨ aimɨ ahondaise. Isɨ ipatɨ nahatepɨ yandɨpɨho biyatɨ gaaho wɨndɨ namingohonɨhati Autaahaatɨho tisatatɨ sisɨhaapɨhɨ tɨhoaitaise,” undatɨ Jonɨho Parisihiyaisunɨ amɨ isɨhiya Satiyusihiyaisunɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Iyatɨ isɨhiya nahatiyaisɨ saundataase, “Nɨnɨ sahɨ nepemaitotɨhandapɨ gwɨnyaataatɨ sahɨ nepemaitotɨhandɨ nasisatɨ nehɨ waapohoraahɨ baasusataayo. Isɨ amɨ utaaho nisɨ ipotɨ napisɨho so Itɨpɨho Gaahoraahunɨ amɨ Itɨpɨho komɨ sisɨha watɨpɨhaaraahunɨ otɨhatɨsema yutɨhɨraahamatiyatɨ nasamaasaitaise. Iyatɨ ko nɨngi nanɨtipɨhaatɨ apɨpaahɨ awaisɨhore. Isɨ nɨnɨ komɨ asuipatɨ nehɨ otɨpɨpatɨho kaipatamataindɨ nga nambɨndɨ nɨwusohaitandɨ awaisɨhonɨnɨ gaahonɨnɨmaahe. ");
INSERT INTO agm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iyatɨ nisɨ ipotɨ napisɨho isɨhiya nahatiyai netɨ tipɨtapaatɨ usondandɨ komɨ ikwɨrɨ tɨmendaisɨ amɨ utaaho nandapa akɨpɨpa kɨpotaatɨ maipɨhapa napɨpatɨ nemasɨpatamatiyatɨ kaitando. Nematɨ nandapa akɨpɨpa aŋɨhandɨ nandapaapɨ aŋɨmatindɨhandaapɨhɨ netɨ ahaitaise. Ahiyataatɨ nandapa maipɨtihɨ nemasɨpɨpa netɨ sisɨha kaanɨhɨ namaayotatɨ tɨhisɨhaapɨhɨ tɨhoaitaise. Isɨ amɨ sahɨ nepemaitɨwɨ Autaahaatɨhoenda napɨwɨse ko sangi japɨhɨ nasamaito,” undatɨ Jonɨho isɨhiya koenda nasohiyɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aihɨ suraanɨhɨ Jisaasiho Jonɨhomɨ ikwɨraatapɨ waapoho naitotatɨ Garirihanda namasi Jonɨhoaapɨhɨ nasatɨ waapɨhaatɨ Jorɨtaanɨhaatainɨ noaipataise. ");
INSERT INTO agm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aihɨ Jonɨho Jisaasihoai nɨwisapuwɨtotatɨ saundataase. “Kɨnyɨ nɨngisɨ waapohora baanusɨtaapɨsɨ amɨ nɨnɨ gisɨ baahusɨtandɨ kɨnyɨ nisenda napaapɨ napise?” undataase. ");
INSERT INTO agm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Undihɨ Jisaasihomɨha saundataase. “Gaasɨ nɨnɨ katohɨmumwaaŋɨ kamwaaŋɨ kɨnyɨ kaime. Amɨ siyaha kiyahaawɨ Autaahaatɨho tɨtɨhɨ maaritatɨ gwɨnyaasɨmumwaaŋɨ kaitɨhaawo,” undataase. Undihɨ Jonɨho namatɨ Jisaasiho kaundimumwaaŋɨ kamwaaŋɨ kiyatɨ Jisaasihoai baawusataise. ");
INSERT INTO agm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aihɨ Jisaasiho osetetɨ waapoho nesi nehɨhaatɨ notataise. Notatɨ bitosɨhɨ yamɨhapatɨ kopɨ tɨwɨtawamataise. Tɨwɨtawamasɨhɨ ko jataise. Jataatɨ Autaahaatɨhomɨ Itɨpɨho koho dɨpɨhomatiyaho yamɨhapataatɨhɨraapɨ Jisaasihomɨhasɨnɨ nasataise. ");
INSERT INTO agm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aihɨ yamɨhapataatɨhapɨ Autaahaatɨho pɨwɨha wa sata kandaase. “Kɨmo nisɨ Maasɨhɨho akohoe. Maasɨhɨhotihɨ Koaisɨ nɨnɨ maarɨho aungwohandɨ nunyatɨ maarɨho koai wɨwitɨhore,” tatɨ pɨwandaase. ");
INSERT INTO agm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aihɨ sura Bwaasɨrɨhɨrɨ Jisaasihoai nunjendotatɨ Autaahaatɨhomɨ Itɨpɨho Gaaho numwaasi isɨhiya iwɨwɨrɨho owehapɨhɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Notɨ apatɨhɨ otapɨhaatɨ nandapa onaayatɨ namaanatɨ bimaamɨ naihɨ waatɨho wo napotɨ wo nusoaipataise. Nusoaipasɨhɨ asisɨha 40 kiyahaiwa sanawihɨ Jisaasihoai apɨpaahɨ aungwohandɨ jaumanamataise. ");
INSERT INTO agm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aihɨ Bwaasɨrɨhɨrɨ nasataise. Nasatɨ Autaahaatɨhomɨ pɨwɨha nemasotatɨ Jisaasihoai saundataase: “Kɨnyɨ apɨpaahɨ akɨtɨnɨhɨ Autaahaatɨhomɨ mwaahoŋɨtapaapaahɨ ye nɨnɨ kɨmɨkonɨne tɨpɨ nɨngi nepɨ nanisapɨ kɨmaiwa nawɨmaiwa noaipatɨ nandapa bɨretɨhandimatonɨhɨ kɨnyɨ nepɨ nandaapɨ kaunde,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Undihɨ Jisaasihomɨha saundataase, “Owe! Amɨ Autaahaatɨhomɨ pɨwɨha sandaase. ‘Nehɨ nandapa bɨretɨhandɨhɨhɨ isɨhiyai kiya asɨyaimatɨwɨ bimɨtaatɨwɨhandɨ wɨndɨ nunyataamaise. Owetise. Autaahaatɨhomɨ pɨwɨha nahatewa komɨ maahomwaaŋapɨ katiwaiwa atiwɨ nepɨ japepihɨrauhɨ isɨhiyai kiya asɨyaimatɨwɨ bimɨtaatɨwɨhandɨ nunyataise,’ ndaase,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Saundatɨ Jisaasiho kaundihɨ namatɨ Bwaasɨrɨhɨrɨ Jisaasihoai numwaasi aunahɨpatɨ apɨpaahɨ awaipatɨ Jerusaremɨhandaahapɨ notaise. Notɨ aŋɨ awaindɨhandamɨ mɨhaatɨ nɨwaataatɨ aundetɨhoaasɨnɨ ahɨwisataise. ");
INSERT INTO agm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ahɨwisatosatɨ Bwaasɨrɨhɨrɨ Jisaasihoai saundataase, “Kɨnyɨ apɨpaahɨ akɨtɨnɨhɨ Autaahaatɨhomɨ mwaahoŋɨtapaapaahɨ kɨmasɨnapɨ mɨhaapɨ naapwaate. Amɨ Autaahaatɨhomɨ pɨwɨha satatɨ jɨpatɨpindiso. ‘Nɨnɨ kinyapɨ nisɨ enjerɨhiya otɨpɨpatɨhiya yamɨhapataatɨhɨ bimohiyɨhiyai nandusoaasisanɨhɨ kiya kiyaamɨ ikwɨraatɨhɨ gi giwasaihɨ nawɨhaara kɨnyɨ auhɨrɨa sundɨpɨhoaisangi wɨndɨ asundɨmusoaitaise,’ tatɨ pɨwɨha aimɨ jɨpatɨpindisɨ naapwaate,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Undihɨ Jisaasiho komɨha saundataase. “Autaahaatɨhomɨ pɨwɨha wa sandaase. ‘Kɨnyɨ kinyɨ Awaisɨho Autaahaatɨhoai napitaise tɨpɨ namunjenɨme,’ daase,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aihɨ Bwaasɨrɨhɨrɨ amɨ Jisaasihoai numwaasi sisɨho wo apɨpaahɨ utaarɨhoaasɨnɨ niyataise. Niyatɨ autaahɨ mɨhasɨnɨ bitondaatɨ isɨhiya kahatamatɨponjawɨhiyaamɨ yapɨpatɨ aunahɨpatɨ gaahaiwa nahatewa maarɨho dotɨ amɨ ambɨpatɨ pɨwɨha gɨmunyaatɨhaiwa nahatewa gaamatɨ nunjataise. ");
INSERT INTO agm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nunjatosatɨ Jisaasihoai saundataase, “Kɨnyɨ nisapɨ maarɨnitɨpɨ atotɨpɨnɨwesapɨ mepɨ autaahepɨnɨmasamaahɨ saiwa nahatewa gi nahɨmɨto amɨ kaiwa kɨnyɨ jatɨtaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Undihɨ Jisaasiho Bwaasɨrɨhɨri saundataase. “Bwaasɨrɨhɨraŋe kɨnyɨ ahe. Kɨraŋɨnɨhɨ numbɨmape. Autaahaatɨhomɨ pɨwɨha wa sataha yaha ahondaise. ‘Kɨnyɨ kinyɨ Awaisɨho Autaahaatɨho naasoaisaahɨhɨ nepɨ mepɨ autaahemape. Aimbɨ otɨpɨpatɨ naasohɨ komɨhatɨhɨhɨ kawime,’ tatɨ ahondaise,” tatɨ Jisaasiho Bwaasɨrɨhɨri kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aihɨ Bwaasɨrɨhɨrɨ Jisaasihoai namasi notaise. Naihɨ Autaahaatɨhomɨ enjerɨhiya usa napɨwɨ Jisaasihoai andɨtɨwiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisaasiho Jonɨhopɨ atisataatɨ Jonɨhoai Erotɨho maipɨhandɨ kaihɨ itɨhundindɨhandapɨ aimɨ isɨpɨ nepɨ wɨrapɨ napuhopo tauhɨ yapɨpatɨ Garirihandaahapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Iyataatɨ ko Jisaasiho Nasaretɨhanda namasi notɨ yapɨhaurɨ Sepɨyuraanɨhomɨhiyaamɨhataahunɨ Napɨtaaraihomɨhiyaamɨhataahunɨ aunahɨpa wɨtɨ Kapaniyaamɨhandamɨ detɨ durɨhɨrɨ Garirihandainɨ ahetihɨhata notɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aihɨ Autaahaatɨhomɨ pɨwɨha wa Komɨ pɨwɨha atisa netɨ ausaasɨho Aisaiyaahomɨ maahomwaaŋapɨ katisɨha Jisaasihomɨ otɨpɨpatɨ kaiwaiwaara akaaha noaipataise. Iyataatɨ Aisaiyaaho sata kandaase. ");
INSERT INTO agm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Yapɨpatɨ Sepɨyuraanɨhomɨhiyaamɨhatamunɨ yapɨpatɨ Napɨtaaraihomɨhiyaamɨhataahɨ durɨhɨramɨhihoaaŋɨ waapɨhaatɨ Jorɨtaanɨhaatɨ nahaitɨwɨ wihɨnɨ mɨhihɨnunɨ amɨ Judaahiyaamɨ dawaataatɨ bimohiyɨhiyaamɨ yapɨpatɨ Garirihandamɨ wihoaaŋɨhata noaipasɨhɨ aimɨ mmonawaayopo. Iyataatɨ isɨhiya napwɨtaatɨwɨhandamɨ asɨhatindɨhandaatɨhɨ bimohiyɨhiyaapɨhɨ nausainjɨtɨhandɨ aimɨ noaipataise. ");
INSERT INTO agm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kapɨhɨ isɨhiya asɨhatindɨhandaatɨhɨ bimohiyɨhiya nausainjɨtɨhandɨ awaindɨhandɨ noaipasɨhɨ aimɨ mmonɨhohɨpatamataiwɨ isɨhiya Judaahiyaamɨ dawaapɨpɨhiya Autaahaatɨhomɨ pɨwɨha akɨtɨha atɨhomisohiyɨhiya atiwɨ mmonɨwɨ naitaapo. Iyataatɨ siya isiya napwɨtaatɨwɨhandamɨ asɨhatindɨhandaatɨhɨ bimohiyɨhiyaapɨhɨ nausainjɨtɨhandɨ aimɨ noaipataise,” tatɨ Aisaiyaaho katisɨha Jisaasiho kapɨhɨ otɨpɨpatɨ kiyatɨ bindata akaahemataise. ");
INSERT INTO agm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aihɨ suraapɨ Jisaasiho komɨ otɨpɨpatɨ namasatɨ pɨwɨha ausaataise. Ausaataatɨ satatɨ ausaataise, “Autaahaatɨho isɨhiyai iwinja bimɨtandɨhura aimɨ nasatɨ detɨndaisɨ sahɨ maipɨhaiwa kiyohɨwaiwa namapɨ nepemaitɨwɨ Autaahaatɨhopɨ gɨwunyaapɨse,” tatɨ Jisaasiho pɨwɨha ausaataise. ");
INSERT INTO agm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Aihɨ Jisaasiho durɨhɨrɨ Garirihandainɨ taatɨ daimɨ notaatɨ utaahurɨ wurɨ saingɨho saaho bitosɨhɨ usonataise. Kuramɨ womɨ ambɨpatɨ Saimonɨhore. Iyataatɨ komɨ ambɨpatɨ wɨtɨ Pitaahoe tɨwɨ ambɨhɨtɨwɨhore. Iyataatɨ komɨ saingɨhomɨ ambɨpatɨ Endɨruhore. Iyataatɨ surɨ utaasurɨ kuramɨ otɨpɨpatɨ araiho noaitaatɨmɨhatɨ kaimɨ bindamaahure. Isɨ kurɨ taamɨ durɨhɨraatɨhɨ araihopɨ ikihɨ tɨmasɨhɨ usonataise. ");
INSERT INTO agm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aihɨ kuri Jisaasiho saundataase, “Sahuraahɨ nɨngi nanipinjai namɨse Autaahaatɨhomɨ isɨhiyaimatɨtaatɨwɨhiyai numwaitaatɨmɨ nɨnɨ kaindɨsasɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Undihɨ ketɨ kuraanɨhɨ kurɨ kuramɨ ikihɨ araihopɨhihɨ namasi Jisaasihoai nuwipinjai niyamaise. ");
INSERT INTO agm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Aihɨ Jisaasiho kapɨhɨ namasi notɨ utaahurɨ wurɨ saaho saingɨho bimihɨ usonataise. Kuramɨ ambɨpatɨ Jemɨsiyɨ Joniyaare. Aihɨ kuramɨ sapɨho Jepetihore. Aihɨ kurɨtihɨ sapɨho Jepetihotihɨ mausasɨ kopuhotɨ bindawa taawɨ kusasamɨ ikihɨ araiho nohohihihɨ tɨtɨhemɨhauhɨ Jisaasiho kurapɨ gandaase. ");
INSERT INTO agm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aihɨ kurɨ ketɨ komɨ pɨwɨha atimɨmapɨ sapɨhoaisunɨ kopuhoaisunɨ namasi Jisaasihoai nuwipinjai niyamaise. ");
INSERT INTO agm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iyatɨ Jisaasiho yapɨpatɨ Garirihandamɨ aunahɨpatɨ nahatewaara daayatɨ kiyaamɨ aŋaaŋɨ pɨwɨhaapɨ ahoyanohɨwaiwaapɨhɨ nandaatɨ isɨhiyai Autaahaatɨhomɨ pɨwɨha kataunjataise. Iyatɨ ko Autaahaatɨho isɨhiyai iwinjaatɨ bimindɨhandamɨ pɨwɨha gaaha wanɨha ausaatɨ kaundatɨ amɨ isɨhiya timbɨpa kahatamatɨpetahapa netɨ kiyaamɨ ambɨpatɨ nusopɨsasisawɨhiyai netɨ tɨtɨhɨwiwataise. ");
INSERT INTO agm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Aihɨ Jisaasiho siyatɨ otɨpɨpatɨ kaindɨhandapɨ pɨwɨha yapɨpatɨ Siriyaahanda notɨ gaamataise. Aihɨ kiya atisawaawɨ namapɨ isɨhiya ambɨpatɨ aungwohandɨ ikɨtɨhɨtisa nɨwɨnatɨ yaawindɨhandisawɨ bimohiyɨhiyaisunɨ itɨpɨho maipɨhaiwa kiyaamɨ omaŋɨtɨtɨhɨ nɨwɨndaatɨ iwiwatahiyaisunɨ amɨ isɨhiya tɨmahiyawɨ kwaapanɨmaasapɨ ahotawa itihohiyɨhiyaisunɨ isɨhiya ikwauhɨrɨ namɨhatatɨ bɨwatesawɨhiyaisunɨ siya timbɨpa kahatamatɨpetahapa numwaasawɨhiyai numwaasi Jisaasihoaapɨhɨ nasawaayopo. Numwaasi nasauhɨ kiyai Jisaasiho tɨtɨhɨwiwataise. ");
INSERT INTO agm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Aihɨ isɨhiya tɨtaahiyɨhiya Garirihandaahapɨhiyaunɨ mihoaaŋɨ Dekaporisihandaahapɨhiyaunɨ aunahɨpa Jerusaremɨhandaahapɨhiyaunɨ yapɨhɨ nahandɨ Judiyaahandaahapɨhiyaunɨ wihɨnɨ mɨhihɨnɨ waapɨhaatɨ Jorɨtaanɨhaatainapɨhiyaunɨ Jisaasihoaapɨhɨ nuwɨ noaipawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aihɨ Jisaasiho jata isɨhiya wɨrɨsandɨhandɨ tɨtaahiyɨhiyaatihiyata namatɨ sisɨhoaasɨnɨ nasaamanataise tamangɨpɨpɨhapɨ isɨhiyai daahepihɨwatɨ iwinjatataatɨ pɨwɨha kataunjɨtando. Nasaamanatɨ mɨhasɨnɨ bimihɨ amɨ komɨ otɨpɨpatɨ mmowɨ nepɨ kaiwɨ nɨwipinjohiyɨhiyaisangi kapɨhɨ naiwɨ komɨhinɨ detɨ koaisawɨ maasɨ bindawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Aihɨ Jisaasiho namasatɨ kiyai pɨwɨha sata kataunjataise. ");
INSERT INTO agm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Isɨhiya usa Autaahaatɨhomɨhaiwaapɨ maarɨhoaatɨhɨ nenoaahɨtɨwɨ sangɨ waatɨ neho tɨwɨ bɨpi napaisaatɨ ipatisanɨwɨ gwɨnyaahohiyɨhiya gaasɨ maaritɨwɨse, amɨ Autaahaatɨho kiyai gaahatɨ kawɨsatɨ amɨ winja bindataiso. ");
INSERT INTO agm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Iyataatɨ isɨhiya usa sawanaunɨ amɨ isɨhiya usaunɨ maipɨhaiwa kaiwɨ tɨmahiyawɨ nopɨsasɨnohɨwaiwaapɨ maarɨho asɨpaiwɨ ngohiyɨhiyai Autaahaatɨho kwɨtipatɨ nɨwɨndiwa nurɨpɨpaiwatɨ gaahatɨ kawitaisɨ gaasɨ kiya maaritɨwɨ kiyaamɨ maarɨho wɨwitane. ");
INSERT INTO agm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Iyataatɨ amɨ isɨhiya usa ipatisanɨwɨ Autaahaatɨho maaritirɨhɨretɨ kiyawaawaahɨ kiyaisɨ Sapɨho gaahaiwa nahatewa tɨmaŋa ahɨwiwaiwa numwɨtaisɨ maaritɨwɨ kiyaamɨ maarɨho wɨwitane. ");
INSERT INTO agm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Isɨhiya usa Autaahaatɨho tɨtɨhaiwa gwɨnyaatɨ maaritiwaiwa ko maaritirɨhɨretɨ kaitaatɨwɨ maaritɨwɨmahohiyɨhiya gaasɨ kiya maaritɨwɨ kiyaamɨ maarɨho wɨwitane, amɨ Autaahaatɨho kiyaisɨ gaahaiwa waatɨ tisaahɨwa gaamatɨ numwɨtaiso. ");
INSERT INTO agm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Iyataatɨ amɨ isɨhiya usa isɨhiya usaapɨ maarɨho tundatɨ asɨpɨwisohiyɨhiya gaasɨ maaritɨwɨse amɨ Autaahaatɨhoai kiyaapɨ maarɨho tundonɨhɨ kiyai maarɨho asɨpɨwitaiso. ");
INSERT INTO agm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Iyataatɨ isɨhiya usa kiyaamɨ amɨtɨha amɨ maarɨhoaatɨhɨ gwɨnyaahotɨhandɨ saasanotatɨ tɨtɨhɨtatɨ amɨ maarɨho naasohɨtihɨ Autaahaatɨhomɨhaiwaapaahɨhɨ andɨtatɨ napamahohiyɨhiya siya Autaahaatɨhoai usowɨ komɨ utatototɨ detɨ bimɨtaatɨwɨhiyaasɨ maaritɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Iyataatɨ isɨhiya usa itɨhɨnnɨwɨ tɨmunɨwɨ bɨpi maarɨho namɨnɨwɨ napaisaatɨ bimɨtaatɨwɨhandapɨ andɨtitɨwɨ isɨhiyaamɨ otɨhapɨhɨ otɨpɨpatɨ kiyohiyɨhiya siya Autaahaatɨhomɨ metɨhonyaimatawaawɨsɨ gaasɨ maaritɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Iyataatɨ amɨ isɨhiya usa tɨtɨhɨ Autaahaatɨhomɨ gwɨnyaasɨrɨhɨretɨ japepihɨrɨwɨ kaisaihɨ kandapɨ isɨhiya usa naaŋɨhandɨ numwisaihaahɨ gaasɨ kiya maaritɨwɨse amɨ Autaahaatɨho aimɨ kiyai iwinja bindataiso. ");
INSERT INTO agm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Iyataatɨ sahɨ nisɨhiyaatɨtɨwɨ amɨ nisɨhɨretɨ japepihɨrɨwɨ kaisaihɨ isɨhiya usa sangi jasonawaawɨ nisapɨsatɨwɨ pɨwɨha ainjotaha maahoaipɨsaupwɨ kasatɨwɨ naaŋɨhandɨ nasanyawɨ pɨwɨha maipɨhaiwa jaiwɨtɨwɨhaiwa kasatisaihaahɨ gaasɨ nehɨ maaritɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Iyataatɨ amɨ jɨhura nisɨ pɨwɨha atiwɨ nepɨ anusaahohiyɨhiyaisangi saiwɨ sangi kasisohɨtɨmandamataiwɨ yaawatɨ naaŋɨhaiwa nunyawɨhiyaare. Iyataatɨ samɨ gaahaiwa awaiwaiwa naitaatɨwɨhaiwa Autaahaatɨho tɨmaŋiwaiwa yamɨhapataatɨhɨ ahondaise. Ahondaisɨ asakaiwɨ maaritɨwɨ sisɨwɨ aunɨhaiwɨse,” undatɨ Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Sata kaundatosa amɨ pɨwɨha wa sɨwipatɨ namɨhana saundataase. “Sahɨ kɨmaapɨ yapɨpatambɨhiyaapɨ sapɨpaamataiwɨhiyaate. Isɨ sapɨpaamɨ jɨpaindɨhandɨ owetonɨhɨ nyahɨ napitiyaatɨ kaisaihɨ sapa sapɨpa noaipatɨ japɨhɨ jɨpaitaise? Sapɨpa siyatɨ maipɨtahapa namaanɨwɨ namasaihɨ isɨhiya itɨpapɨ nopɨsasɨwɨ daitaapo. ");
INSERT INTO agm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Aiwɨ amɨ sahɨ yapɨpatambɨhiyaapɨ sisɨha nausainjɨhaamataiwɨhiyaate. Isɨ aunahɨpatɨ wɨtɨ sisɨhaisahatɨ sisɨhoaasɨnɨ ahendaahatɨ wɨndɨ noaatatɨ ahɨmetɨtaise, nehɨ auta ahetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Iyataatɨ isɨhiya norɨhɨrɨ wɨrɨ tɨpopɨ yutɨhɨrɨ namaasapɨ ahiyawaamaayopo, owetise. Nehɨ norɨhɨrɨ tɨpopɨ autaahiwawaayopo isɨhiya nahatiya aŋɨtɨtɨhɨ bimohiyɨhiyai nɨwusoaatɨtando. ");
INSERT INTO agm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Isɨ sɨkaiwɨ samɨ kiyohɨtɨhandɨ isɨhiya usaisɨ nɨwusoaatane. Nɨwusoaatonɨhɨ samɨ kiyohɨwaiwa gaahaiwaatanɨhɨ mmonawaawɨ samɨ Japɨho yamɨhapataatɨhɨ bimisɨhomɨ ambɨpatɨ nɨwimaitaatɨwo. ");
INSERT INTO agm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Iyataatɨ sahɨ nisapɨ ko wɨnɨhapɨpaunɨ Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaamɨ pɨwɨha katohɨwaiwaunɨ netɨ nemaitandɨ nasataise tɨwɨ wɨndɨ gɨmunyaapɨse, owe. Nɨnɨ saiwa nemaitandɨ nasataamaayo, owe. Nɨnɨ nehɨ kaiwa netɨ akɨwaiwemaitandɨ nasataayo. ");
INSERT INTO agm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nɨnɨ pɨwɨha apɨpaahɨ akɨtɨha kɨma kasatɨtandiyonɨ baiwɨ atiwɨse. Yapɨpatɨ amɨ yamɨhapatɨ ahotɨmɨ niyonɨhɨ Autaahaatɨhomɨ wɨnɨhapɨpaisangi ahotɨmɨ notɨ Autaahaatɨho komɨ pɨwɨha kahapaamapɨpa kaitandɨ kata wɨsasa ahaiwaiwa akɨwaiwa noaipahonɨhura owetɨtandɨhapaare. ");
INSERT INTO agm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Isɨ amɨ utaaho wo Autaahaatɨhomɨ wɨnɨhapɨpaamɨ pɨwɨha wonjɨ maipɨhonjɨ tipɨtapa nematɨ isɨhiya usaisɨ saiwɨ kaiwɨse undatɨ kaundonaahɨ Autaahaatɨho komɨ isɨhiyai iwinja bimindɨhandamɨ utaaso soai dawaataatema kopɨ nanɨpimatɨtaise. O utaaho wo wɨnɨhapɨpa kapa biyatɨ japepihɨratɨ amɨ isɨhiyai sahɨ saiwɨ kaiwɨ wɨnɨhapɨpetɨ japepihɨrɨwɨse undatɨ kaundonaahɨ koai Autaahaatɨho sawahomɨ isɨhiyai winja bimindɨhandaatɨhɨ otɨhatɨhemwa ndɨmaahomwaaŋɨ netɨ ahɨwitaise. ");
INSERT INTO agm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aihɨ nɨnɨ sangi akɨtɨnɨhɨ sandɨ kasatataato, sahɨ Autaahaatɨhomɨ gwɨnyapesɨrɨhɨretɨ tɨtɨhɨ nga dahomaiwɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaamunɨ amɨ Parisihiyaamunɨ daayohɨmumwaaŋɨ yatɨhemapɨ autaahɨ wamwaaŋɨ dahomaayawaawaahɨ Autaahaatɨho wɨndɨ sangi wanɨ kɨmbɨhunɨ amɨ ipotunɨ jainja bɨmimɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Iyataatɨ wɨnɨhapɨpa isɨhiyaisɨ timaamape tɨwɨhapa aimɨ samɨ jaasoya nehopo. Nepɨ sangi wɨnɨhapɨpa kapa katɨwɨsasauhɨ sahɨ aimɨ atiwɨ gwɨnyaapɨhiyaate. Iyatɨ amɨ pɨwɨha andɨtɨwiwɨha sataha aimɨ atiwɨhiyaate: ‘Utaaho wo isɨhiyai tiwamataataahɨ so pɨwɨha tipɨtapaatɨ mmondandɨhoaapɨhɨ noaipaitaise,’ tɨwɨha atiwɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amɨ nɨnɨhɨ sangi sandɨ kasatataato, utaaho wo komɨ naisoho saingo saahoemainjɨhopɨ apousataataahɨ so pɨwɨha tipɨtapaatɨ mmondandɨhoaapɨhɨ noaipaitaise. Iyatɨ amɨ utaaho wo komɨ naisoho saingo saahoemainjɨhoai sisɨpɨhunda tɨhanyohoŋe undataataahɨ so isɨhiya pɨwɨha tipɨtapaapɨ mmondaatɨwɨhiyaapɨhɨ noaipaitaise. Iyatɨ amɨ utaaho wo komɨ naisoho saingo saahoemainjɨhoai kɨnyɨ apɨpaahɨ naharimbɨ amɨtɨha owehoŋe undataataahɨ so sisɨha maipɨha tɨhoaatɨtandɨhaamɨ petetɨ aimɨ bindataatɨsɨ kaapɨhɨ nutaise. ");
INSERT INTO agm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Isɨ kɨnyɨ Autaahaatɨhopɨ gaapundɨpɨ komɨ ambɨpatɨ nuwimaitaapiyapaapɨ kinyɨ naisoho wo kinyapɨ pɨwɨha ahotanɨho bimonɨhɨ gwɨnyapenapaapaahɨ nehɨ namasi numwe. Numbwɨ koaisapɨ pɨwɨha tɨtɨhemapɨ napaisaatɨnɨmapɨ kɨnyɨ jahɨra naimbɨ Autaahaatɨhomɨ ambɨpa mepɨ autaahemwapɨ numwɨtaapɨ nesi naingɨpɨpa koai nunye. ");
INSERT INTO agm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Iyataatɨ amɨ utaaho wo gisɨ pɨwɨha pɨwaatɨtaatɨwɨhapɨhapɨ nangɨmaasi niyonaaraahɨ nangɨmaasi naisɨhoai pɨwɨha napaisɨha kaundɨpɨ maarɨho naasohɨtanɨhɨ ketɨ pɨwɨha pɨwanɨmɨ tɨtɨhemapɨse. O kɨnyɨ saimbɨ kamaayapaapaahɨ ko nangɨmaasi niyatɨ pɨwɨha atisatɨ tipɨtapa mmondandɨhoaapɨhɨmahonɨhɨ amɨ ko netatɨ tingaatɨhaisahiyaamɨ ikwɨraatɨmahonɨhɨ amɨ tingaatɨhaisahiya nepawɨ napwɨtohɨtɨhandaatɨhɨmaitaawo. ");
INSERT INTO agm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sahisaihɨ kɨnyɨ napwɨtohɨtɨhandaatɨhɨ bimaamɨ numbwɨ kinyɨ maipɨhaiwa owemaitaapɨ nawɨho wɨndɨ namunyapaapaahɨ kɨnyɨ wɨndɨ namasi namoaipaitaise, hɨtɨtɨ akɨtɨnɨhɨ waapɨhɨndɨ kahɨtataato,” undatɨ Jisaasiho isɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kaundatosa pɨwɨha kɨma kaamɨ wa sata kaundataase, “Pɨwɨha waisangi sataha jɨhura noaipasɨhɨ aimɨ atiwɨhiyaate: ‘Kɨnyɨ usɨhiya asɨhiya usaamɨhiyai ikomaawɨnɨme,’ tatɨ pɨwɨha aimɨ ahotihɨ atiwɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amɨ nɨnɨhɨ sangi bapaindɨ kasatataato: Utaaho apopaatɨ waati usonataatɨ aunɨhɨwisatɨ komɨ maarɨho kaatapɨ wɨndotɨ nurɨtɨmanataataahɨ so saatɨ apopaati ikonatɨ Autaahaatɨhomɨ ndɨhetɨ maipɨhandɨ aimɨ kiyataise. ");
INSERT INTO agm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Iyataatɨ kinyɨ ndɨha ikwɨrɨ gaahɨraihoaaŋɨha maipɨhaiwa kaitaapɨhaiwaatɨhɨ nangɨmaasi niyonaahɨ ka namwaapɨ yotɨme. Yotisamɨhɨ kɨnyɨ utaahoŋɨ nahatongi nepɨ sisɨha tumwipɨhaapɨhɨ wɨndɨ yamaahotɨto. ");
INSERT INTO agm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Iyataatɨ amɨ kinyɨ ikwɨrɨ gaatɨhɨrɨ maipɨhaiwa kaitaapɨhaiwaapɨhɨ gisi niyonaahɨ kɨrɨ otipapɨ yotɨme. Yotisamɨhɨ kɨnyɨ utaahoŋɨ nahatongi nepɨ sisɨha tumwipɨhaapɨhɨ wɨndɨ yamaahotɨtaatɨwo. ");
INSERT INTO agm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Iyataatɨ pɨwɨha jɨhura siyaha noaipataise. ‘Utaaho wo komɨ apwaataati namataataahɨ gaasɨ nehɨ nanɨhiya utɨpɨhandɨ wɨndɨ namaatɨnohɨtɨhandɨ nasɨpatɨtaatɨwɨhandɨ nunyatɨ natausaasane,’ taha pɨwɨha jɨhura noaipataise. ");
INSERT INTO agm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aihɨ amɨ nɨnɨhɨ pɨwɨha sandɨ kasatataato apopaatɨ waatɨ kɨhiyaisatɨ maasɨ dahomaayahaati warɨho namataataahɨ amɨ ko apopaatɨ saati maipɨhandɨ kɨhiyaisa kaitandɨhandaatɨhemwataise. Iyataatɨ amɨ saatɨ apopaatɨ warɨho jɨho namasaamaati wo netɨ wɨrataataahɨ maipɨhandɨ saatisa kiyatɨ baiwɨ namaatɨnɨwɨ bimɨtaatɨwɨhandɨ netɨ nopɨsasataise. ");
INSERT INTO agm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Iyataatɨ amɨ pɨwɨha waisangi samɨ jaasoya aimɨ nepɨ kasatauhɨ aimɨ atiwɨhiyaate. Iyataatɨ sa pɨwa siyate: ‘Wapa kaitaapɨ Autaahaatɨhomɨ ambɨpataahapɨto tɨpɨ katɨpɨ ahaingɨpɨpa nanɨpimatɨpɨ nepɨ namopɨsasɨpɨ akɨpɨpa kaime,’ taha aimɨ jɨhura noaipasɨhɨ sahɨ atiwɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Atisauhɨhandɨ kandɨ nɨnɨ sangi sandɨ kasatataato, ‘Ahomunɨ ahapaamunɨ ambɨpata sapa saitaano,’ tɨpɨ pɨwɨha katɨpɨ wɨmisase, owetane. Nehɨ akɨpɨpaahɨ kaime. Iyapaapɨ ‘yamɨhapataatɨhapɨto maatɨme.’ Amɨ sapɨhɨ Autaahaatɨhomɨ mɨtɨhomasɨpɨpɨhiso. ");
INSERT INTO agm_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Iyapaapɨ amɨ ‘yapɨpataahapɨto maatɨme,’ amɨ sapɨhɨ Autaahaatɨhomɨ auhɨrɨmasɨpɨpɨhiso. Iyapaapɨ amɨ ‘aunahɨpatɨ Jerusaremɨhandaahapɨto maatɨme,’ satɨ isɨhiyaamɨ Kiŋɨho Mɨtɨho Awaisɨhomɨ aunahɨpatiso. ");
INSERT INTO agm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Iyapaapɨ amɨ ‘kɨnyɨ nisɨ mɨtɨhoaatɨhapɨto,’ tɨpɨ pɨwɨha katɨpɨ wɨmisase kɨnyɨ kinyɨ mɨsisɨha wɨndɨ kɨhoepɨhemapɨ asɨhahemaamaitaise. Owetise. Autaahaatɨho sawahomɨhande. ");
INSERT INTO agm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kɨnyɨ utaahoŋɨ ainahɨhoŋɨtapaapaahɨ kɨnyɨ pɨwɨha katisamɨha isɨhiya akɨte tɨwɨ naitaapo. Isɨ kɨnyɨ kinyɨ pɨwɨha ‘aye kaitaano,’ tɨpɨ ‘owe kamaitaano,’ te. O amɨ kaamɨ tiwatɨhaatɨ bipinjapɨ pɨwɨha wa katapaapaahɨ sa kinyɨ maarɨho jahɨho maipɨhomɨhaare. Iyatɨ amɨ Bwaasɨrɨhɨrɨ kɨramɨha bihɨwainjataise. ");
INSERT INTO agm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Iyataatɨ pɨwɨha wa jɨhura siyaha aimɨ noaipasɨhɨ atiwɨhiyaate. Iyataatɨ sa pɨwa siyate: ‘Utaaho wo ndɨha nangumwaahonɨhoai amɨ komɨha wihoaaŋɨ namwaape. Amɨ wo mangɨrɨ tiwa nangɨwonaahɨ amɨ komɨhɨrɨ wihoaaŋɨ tipɨ nawe,’ tɨwɨ pɨwɨha katauhɨ atiwɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Aihɨ amɨ nɨnɨhɨ naasoŋɨ naasangi sandɨ kasatataato, usa maipɨhaiwa kasisaihaahɨ sahɨ wihoaaŋɨhaiwa kamaawiwɨse. Owe. O utaaho wo pahaapɨpatɨ tɨsawihonaahɨ amɨ wihoaaŋɨhatisangi tɨsawihɨwɨta nunyawɨse. ");
INSERT INTO agm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Iyataatɨ amɨ utaaho wo kinyɨ apotɨhɨrɨ jahɨrɨhɨrɨ nangaitandɨ pɨwɨha pɨwaatɨtaatɨwɨhapɨhapɨ nangɨmaasi naitandiyonaahɨ kɨnyɨ kinyɨ apotɨhɨrɨ asɨrɨhɨrimaawɨ tɨmaamaipɨ koai nunye. ");
INSERT INTO agm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Iyataatɨ amɨ utaaho wo apɨpaahɨ gi pohɨtaho tarɨwɨhɨta nisɨ ikɨpɨpa nesaimbɨ yametɨ sisɨmoaasɨnapɨ naninyamɨ napɨtaapo hɨtonaahɨ ko siso nusatipapɨ kaanɨhɨ wapɨhapɨ nesumbunye. ");
INSERT INTO agm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Iyataatɨ amɨ utaaho wo wapaapɨ naninye hɨta nasehonaahɨ bɨpi kapa nahɨsesɨpɨpa napaisaatɨ nunye. Iyatɨ amɨ utaaho wo gisɨ nisɨhapa ipotɨ nahɨmɨtaanɨ wapa naninye hɨtonaahɨ komɨ pɨwɨha nepumaamapɨ bɨpi nunye. ");
INSERT INTO agm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Iyataatɨ pɨwɨha wa jɨhura aimɨ noaipasɨhɨ sahɨ aimɨ atiwɨhiyaate. Iyataatɨ pɨwɨha sa siyahaare, Kinyɨ naisɨhiyai maarɨho nunyapaapɨ amɨ tiworisai maarɨho namunye, taha jɨhura noaipasɨhɨ atiwɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aihɨ nɨnɨhɨ sangisɨ sandɨ kasatataato samɨ tiworisa isɨhiya samɨhiyaametahiyai maarɨho nunyawɨse. Aiwɨ isɨhiya usa sangi kahapaamapɨpa gɨmunyaatɨhapa naaŋatɨ yaasɨhaiwa nasanyohiyɨhiyaapɨ gaapundɨwɨse Autaahaatɨho sawaho kiyaisɨ tɨtɨhemwaito. ");
INSERT INTO agm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Sahɨ saiwɨ kiyawaawaahɨ Japɨho yamɨhapataatɨhɨ bimisɨho sawahomɨhɨretɨ japepihɨrɨwɨ taawɨ kaimɨ nowaayopo. O sandɨ apaapɨmaato, amɨ Autaahaatɨho komɨ ipɨho netɨ isɨhiya maipɨhiyaamɨhetunɨ gaahiyaamɨhetunɨ yaawutaataise. Iyatɨ amɨ komɨ wipatɨ netɨ gaahiyaamɨhetunɨ maipɨhiyaamɨhetunɨ ahoya wipɨpasɨhɨ wipurɨwataiso. ");
INSERT INTO agm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sahɨ sandɨ saiwɨ isɨhiya maarɨho nasanyohiyɨhiyaisaahɨhɨ maarɨho nunyohɨtɨmandɨ wapa kahapaamapɨpa asakaiwɨ naitotɨwo? Owetise. Amɨ sandɨ isɨhiya gamanɨhopɨ nawɨho takisihandɨ nusehohiyɨhiya nusewaawɨ tiwatɨhaatɨ sawanaapɨho ikonɨwɨ nehohiyɨhiyaisangi satɨ katɨ kiyawaayopo. Iyawaayowɨ sahɨ maarɨho nasanyohiyɨhiyaisaahɨhɨhɨ nunyohɨtɨmandɨ gaahatɨ kiyawaayowo? Akɨpɨpa napitetahapa naitaatɨwe? ");
INSERT INTO agm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Iyataatɨ amɨ sahɨ nehɨ samɨ naisɨhiya japɨ jaatingoyaisaahɨhɨ nɨwipaapɨ pɨwaundawaawaahɨ isɨhiya usa apɨpaahɨ saiwɨ wɨndɨ kamaiwɨhatɨ sahɨ kiyawaayowo? Autaahaatɨhopɨ atɨhomiwɨ nanɨpimatɨwɨ samɨ dawaataatɨ bimohiyɨhiyaisangi satɨ katɨ kaiwɨ maarɨho namɨnawaayowo? ");
INSERT INTO agm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Isɨ samɨ Japɨho yamɨhapataatɨhɨ bimisɨho tɨtɨhɨ gaaho ainahɨho saasanotahosɨ sangisangi katɨ nepɨ tɨtɨhɨ kaiwɨ gaahiyaatɨ ainahiyɨhiyaatɨ saasanotahiyaatimatɨwɨse,” undatɨ Jisaasiho isɨhiyaisɨ saiwa kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisaasiho satatɨ kaundatosatɨ amɨ pɨwɨha wiwa saundataase. “Isɨhiya usaapɨ nyangi nyainjaitotɨwɨ wiwa gaahaiwa kiyaamɨ ndɨhetɨ kamaiwɨse. O isɨhiyaamɨ ndɨhetɨ saiwa kiyawaawaahɨ samɨ Japɨho yamɨhapataatɨhɨ bimisɨho sapɨ gaahaiwa tɨmaŋa ahɨsiwaiwa wɨndɨ kandapɨ namaasamɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Iyataatɨ isɨhiya kahapaamapɨpa owehiyaisɨ wapa kiyaisɨ andɨtɨwiwɨtandɨhapa numwɨtaatɨwaahɨ bɨpi napaisaatɨ nunyawɨse. Iyataatɨ isɨhiya usa otaatapɨhiya isɨhiya nyainjawaawɨ nyamɨ ambɨpatɨ nepɨ autaahɨ awaindepɨnyamaitotɨwɨ asakaiwɨ auta aŋaaŋɨ pɨwɨhaapɨ ahoyanohɨwaiwaatɨhunɨ daihɨraunɨ isɨhiya usaisɨ andɨtɨwiwɨtandɨhaiwa nunyawaayopo. Aisɨ sahɨ kiyaamɨ kiyohɨrɨhɨretɨ kamaiwɨse. Iyawaawɨ sahɨ baiwɨ gwɨnyaapɨse kiya kiyaamɨ isɨhiyaamɨhetapɨ naitaatɨwɨ kiyohɨwaiwa aimɨ nesihiyaasɨ Autaahaatɨho wɨndɨ ipotɨhura wapa namumwɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Isɨ kɨnyɨ isɨhiya ikɨpɨpa nandapa owehiyai wapa andɨtɨwiwɨtandɨhapa nunyapaapaahɨ kinyɨ gapɨ gaatingoya kɨnaimwaayai saiwa siyataayo mundɨpɨ nehɨ noaatɨpɨ nunye. ");
INSERT INTO agm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Isɨ kinyɨ isɨhiyaapɨ maarɨho asɨpiyapaapɨ kaingɨtɨhandɨ noaasandane. Noaasandanɨhɨ Gapɨho noaasandihɨhaiwa mmonahosɨ mmonataatɨ kandapɨ wihoaaŋɨhapa nahɨmɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Iyataatɨ kɨnyɨ kɨwahoŋɨ gaapundapaahura isɨhiya otaatapɨhiyaamataimbɨ gaapɨmundɨme. Siya otaatapɨhiya gaapundawaahura isɨhiya nyainjaitotɨwɨ aŋaaŋɨ pɨwɨhaapɨ ahoyanohɨwaiwaatɨhunɨ isɨhiya ahoyanɨhauhɨhapɨhunɨ maaritɨwɨ auta dopɨ bitotawa Autaahaatɨhopɨ gaapundɨwɨhiyaare. Sahɨ baiwɨ atiwɨ gwɨnyaapɨse kiya aimɨ kiyaamɨ kiyohɨwiwaapɨ wihoaaŋɨhapa nesihiyaasɨ Autaahaatɨho ipotɨhura kiyai wapa namumwɨtaise, apɨpaahɨ owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Isɨ kɨnyɨ gapundɨtaapɨhura kɨnyɨ baimbɨ isɨhiya ŋuŋaaha kɨrɨhɨrupa owehapɨhɨ numbwɨ noaatɨpɨ Gapɨho noaata bimisɨhopɨ gaapunde. Aisamɨhɨ noaatɨpɨ kaingɨwaiwa mmonahosɨ wihoaaŋɨ gaahaiwa nahɨmɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Iyataatɨ sahɨ Autaahaatɨhopɨ gaapundawaahura isɨhiya Autaahaatɨhopɨ gɨmunyaahohiyɨhiyaamatɨmaiwɨse. Kiya gaapundawaahura nyahɨ utaarɨhandɨ pɨhɨta gaapundɨmɨ naisaihɨ atɨnyitotɨwɨ utaarɨhaiwa gaapundɨwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Samɨ Japɨho Autaahaatɨhoai sahɨ sangɨ nunjesaihɨ samɨ nenoaahɨtiwaiwa nahatewa jɨhɨ aimɨ mmondaise. Isɨ sahɨ Autaahaatɨhopɨ gɨmunyaapɨ nehɨhiyaamɨhatɨ nepɨ kɨretɨ kamaiwɨse. ");
INSERT INTO agm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Isɨ sahɨ saiwɨ kɨmɨretɨ gaapundɨwɨse ‘Nyamɨ Apɨhoŋɨ yamɨhapataatɨhɨ Bimingɨhonye, kinyɨ ambɨpatɨ nyahɨ naimawa awaindewaama onaahɨtewaamaitaano. ");
INSERT INTO agm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kɨnyɨ nyangi nyainjaapɨ bime. Nyainjaapɨ bimisamɨhɨ nyahɨ kinyɨ maaritingɨrɨhɨretɨ mɨhaatɨ autaahɨ yamɨhapataatɨhɨ japepihɨrohɨpatamatiyaatɨ maapɨ yapɨmbataapɨhɨsangi japepihɨrɨtaano. ");
INSERT INTO agm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nandapa wanɨ ipɨmo kɨmoetapɨhapa nyangi nanyɨnye. ");
INSERT INTO agm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aimbɨ isɨhiya maipɨhaiwa nyangi kanyisauhɨ kaiwa nyahɨ aimɨ nemwahohɨpatamataimbɨ nyamɨ maipɨhaiwa nepɨnyamape. ");
INSERT INTO agm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Aimbɨ kɨnyɨ nyangisɨ wapa nanyisenatɨ nyapatitandɨhaiwaatɨhɨ nanyamaasi namumwe. Kaiwaatɨhapɨ nyangi nanyamaape. Iyapaapɨ kɨnyɨ nyangi nyainjaapɨ bindapaise. Kɨnyɨ watɨpɨhoŋe. Kɨnyɨ saasanotahoŋe. Koŋɨnɨhɨ saimbɨ bindapaise. Akɨte.’ ");
INSERT INTO agm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Baiwɨ atiwɨse. Isɨhiya usa sangi maipɨhaiwa kasisohɨwaiwa nepumwawaawaahɨ samɨ Japɨho yamɨhapataatɨhɨ Bimisɨho amɨ samɨ maipɨhaiwa nesamaitaise. ");
INSERT INTO agm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","O amɨ isɨhiya usa sangi maipɨhaiwa kasisohɨwaiwa nepumaamawaawaahɨ amɨ samɨ Japɨho samɨ maipɨhaiwa wɨndɨ nesamaamaitaise. ");
INSERT INTO agm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Iyataatɨ sahɨ nandapa namaanɨwɨ onaiwɨ bindawaahura isɨhiya otaatapɨhiya isɨhiya usa nyangi nyasondotɨwɨ kiyohɨpatamataiwɨ isemetɨwɨse. Akɨtɨnɨhɨ sandɨ kasatataato isɨhiya siyohiyɨhiya kiyaamɨ sandɨ siyohɨtɨndamɨ wihoaaŋɨhapa aimɨ nesihiyaare. ");
INSERT INTO agm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","O kɨnyɨ nandapa namaanɨpɨ onaayapaapaahɨ kinyɨ ndɨmaahomwaaŋɨ itatamanɨpɨ bausanɨpɨ mɨsisɨha tɨwɨhaatɨpɨ napɨpatɨpɨ nanɨhaimbɨ bime. ");
INSERT INTO agm_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Saimbɨ nanɨhaimbɨ jahomaahɨmasɨhonyamataimbɨ bimisamɨhɨ isɨhiya kinyapɨ ko nandapa onaayatɨ bindataise tɨwɨ wɨndɨ gɨmunyaitaatɨwo. Iyonɨhɨ kinyɨ Gapɨho noaatatɨ bimisɨho kohɨhɨ sawaho gɨsonatɨ gwɨnyaitaise. Iyatɨ Gapɨho ko noaasandihɨhaiwa mmonahosɨ kɨnyɨ noaasapɨ kaingɨwaiwaapɨ wihoaaŋɨhapa nahɨmɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kɨmaapɨ yapɨpataapɨhɨ sawanaatapɨ kahapaamapɨpa ikɨpɨpa gaahaiwa nepɨ ahomaayawɨse. O saiwa nepɨ ahoyawaawaahɨ kahɨho naapɨho nanatunɨ yosoaamatatunɨ amɨ aŋaaŋɨ nawɨtapɨ ikonjaihɨ samɨ ikɨpɨpa kahapaamapɨpa gaahaiwa nopɨsasɨna owetɨtaise. Iyonɨhɨ samɨ maarɨhoaisangi kaiwaisa maawɨ ahoyatɨ owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Isɨ samɨ ikɨpɨpa kahapaamapɨpa sawanaatapɨ yamɨhapataatɨhapaahɨhɨ nepɨ ahoyawɨ sapa kapa komɨ otɨpɨpatapɨ Autaahaatɨhoai nunyawɨse. O saisaihaahɨ samɨhaiwa kahɨho naapɨho namaanatɨ yosoaamaamatatɨ isɨhiya aŋaaŋɨ nawatapɨ ikomaanɨwɨ nga biyatɨ ahɨsɨsotɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Isɨ amɨ samɨ maarɨhoaisangi samɨ kahapaamapɨpa gaahaiwa ahiyohɨpɨpɨhɨ sapɨhɨ kapɨhɨ maawɨ ahɨsɨsotɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Iyataatɨ ndɨha ambɨpati daihɨra nunjɨtandɨ sisɨhaamatiyahaare. Isɨ amɨ kinyɨ ndɨha saasanotahandaataahɨ kinyɨ ambɨpatisangi nga biyatɨ saasanotɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","O amɨ kinyɨ ndɨha sisɨha niyotisɨhaamatiya maipɨta niyotataataahɨ kinyɨ ambɨpatisangi apɨpaahɨ asɨhatamaitaise. Isɨ kinyɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhɨsangi setɨtaise. Kɨnyɨ kɨmambɨhaiwaisaahɨhɨ maarɨho nunyamahingɨtɨnda yamɨhapataatɨhapɨhaiwai kɨnyɨ wɨndɨ mmonɨpɨ amɨ wɨndɨ kamaitaise. ");
INSERT INTO agm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Iyataatɨ utaaho wo awaisururɨ yahuramɨ otɨpɨpatɨ ahoyatɨ isɨwatataatɨ otɨpɨpatɨ kamaitaise, owetɨtaise. Nehɨ woaisaahɨhɨ maarɨho nunyataatɨ woaisɨ maarɨho namumwɨtaise. Iyatɨ woaisɨ biya anɨtisa isɨwatata woai namatɨ pohipɨwisamaitaise. Isɨ sahɨ saiwɨ noaipapɨ Autaahaatɨhomunɨ kahapaamapɨpa nawɨhomunɨ otɨpɨpatɨhiyaatimaamatɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Aihɨ nɨnɨ sandɨ kasatataato samɨ ambɨpatapɨhapa nandapa waapoho apotɨhɨrɨ napa newa nana niyoaitɨhaawe tɨwɨ waatɨ pɨhɨtɨwɨ wɨndɨ gɨmunyaapɨse. Autaahaatɨho samɨ ambɨpatɨsangi nasamihɨhatisɨ ko kati nunyawɨ andɨtɨwiwɨtaatɨwɨhapa nandapa namaasamɨtaiso? Iyatɨ amɨ ko samɨ ambɨpati namaasapɨ nɨwusoaitaatɨwɨhapa yutɨhɨrɨ apotɨhɨrɨ namaasamɨtaiso? E nasamɨtaiso? ");
INSERT INTO agm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Isɨ sahɨ kohoai usonɨwewɨse. Koho nandapa niyaama kɨpo nimana nandapaamɨ aŋɨpɨpɨhɨ ahoya nanahomaahe. Owetise. Samɨ Japɨho yamɨhapataatɨhɨ bimisɨho koho nehɨ nanɨhiyahoai sawaho komɨ ikwɨraatɨhɨ anɨtisa isɨwatɨ iwinjatataise. Isɨ sahɨ kohoai namusatipɨhaapɨ samɨ Japɨhomɨ kɨrɨwipatotapɨhiyaato? E owetiso? ");
INSERT INTO agm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Iyataatɨ samɨ wo komɨ wonjɨ utaarɨ biya bimɨtandɨhandapɨ gwɨnyapenatoandaatɨ kɨnaungwɨha wa netɨ bihɨwainjɨtaiso? Owetise. Autaahaatɨho sawahomɨhande. ");
INSERT INTO agm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Aisɨ sahɨ napaapɨ apotɨhɨrɨ owetiso tɨwɨ pɨhɨtɨwɨ gwɨnyaahopo? Tandɨpɨho napitiyatɨ nawataise tɨwɨ usonɨwewɨse. Tandɨpɨho otɨpɨpatɨ kiyatɨ apotɨhɨrɨ nasatɨ niyotaiso tɨwɨ usowɨse. ");
INSERT INTO agm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Isɨ nɨnɨ sangi sandɨ kasatataato jɨhura Soromonɨho apotɨhɨrɨ otiwa kaumbwaahapaisahondaahandɨ kandɨ ko wɨndɨ tandɨpɨmomatiya namaayose. Autaahaatɨho Soromonɨhoai nusatipɨha autaahɨ tandɨpɨhoai netɨ itatamanatɨ yundanyaawɨsataise. ");
INSERT INTO agm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iyataatɨ tandɨpɨho woyɨha wanɨ ahendaise. Bousonɨhɨ tisatɨwɨ tɨhoaitaapo. Tandɨpɨho woyɨha saiwaisɨ Autaahaatɨho iwinjatataise. Isɨ Autaahaatɨhopɨ maipɨhonjɨ gɨwunyaahohiyɨhiyaate, Autaahaatɨho sangi biyatɨ jainja bɨmimɨtaiso? ");
INSERT INTO agm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Isɨ samɨ nanɨwɨ niyoaitaatɨwɨhapaapɨ pɨhɨtɨwɨ gwɨnyapenawaawɨ pɨwɨha wɨndɨ samaatɨwɨse: ‘Nyahɨ nandapa waapoho maahapa nandɨhaawe? Iyaatɨ apotɨhɨrɨ maahapa niyowaatɨ nipaatɨtɨhaawe?’ tɨwɨ pɨhɨtɨwɨ gɨmunyaapɨse. ");
INSERT INTO agm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Samɨ Japɨho yamɨhapataatɨhɨ bimisɨho sapɨ kiya saiwaapɨ nenoaahɨndaise tatɨ aimɨ mmonatɨ gwɨnyaahore. Iyataatɨ saiwa isɨhiya Autaahaatɨhopɨ atɨhomiwɨ gɨmunyaapɨhiya kaiwai kiyaamɨ Autaahaatɨhoemapɨ gwɨnyaitaatɨwɨhaiwe. ");
INSERT INTO agm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Isɨ sahɨ saiwaapɨ nanɨpimatɨwɨ jɨhɨ yeye tɨwɨ Autaahaatɨhoai nehɨ iwinjasaihɨ amɨ ko sangisɨ jainja bimone. Jainjatonɨhɨ amɨ sahɨ koai andɨtitɨwɨ isɨwatɨwɨ amɨ tɨtɨhɨtirɨhɨretɨ ko maaritatɨ gwɨnyapesɨrɨhɨretapɨhapaapaahɨhɨ jasamana nasonɨhɨ kɨretɨ japepihɨrɨwɨse. Aisaihɨ Autaahaatɨho kaiwa japepihɨrohɨwaiwaamɨ tiwatɨhaatɨ samɨ nenoaahɨtiwaiwa nahatewa nasamɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Isɨ asisɨha bousonɨhapɨhaiwa aipɨ nepɨ wanɨ kɨmura pɨhɨtɨwɨ maarɨho naaŋonɨhɨ gɨmunyaapɨse. Bousonɨhapɨhaiwa nehɨ kuraapɨhaiwaasɨ asisɨha wanɨmetapɨhaiwa baiwɨ gwɨnyaapɨ kaiwɨse. Asisɨha naasɨ naasaahɨ tɨtɨhɨ ketapɨhaiwa naaŋɨhaiwa tisaitataise,” tatɨ Jisaasiho isɨhiyai kataunjataise. ");
INSERT INTO agm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iyatosatɨ Jisaasiho pɨwɨha wa sata kataunjataise. “Sahɨ isɨhiya usaapɨ saiwɨhiye saiwɨhiye tɨwɨ topɨtaata wonamaatɨhɨ tipɨtapaapɨ wɨndɨ mausowɨse amɨ Autaahaatɨhoaisangi wɨndɨ siyatɨ sangi kamaasito. ");
INSERT INTO agm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","O sandɨ apaapɨmaasato, amɨ Autaahaatɨho sahɨ isɨhiya usaisɨ tipɨtapaapɨ usohohɨrɨhɨrɨ kɨretɨ tipɨtapa jasondaihɨhandapɨsato. Wapa wamwaaŋɨ usaisɨ nunyawaawaahɨ amɨ kamwaaŋɨ jahɨra nasamɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Isɨ amɨ ndɨha kɨwahonyɨhaatɨhɨ matoaatɨpatɨ nangɨmaasandipatapɨ kɨnyɨ wɨndɨ baimbɨ motɨnɨpɨ kɨsaahomɨ ndɨhaatɨhɨ ikwaatɨpɨhonjɨ ahotisonyonjapɨ kɨnyɨ napaapɨ baahaimbɨ usohise? ");
INSERT INTO agm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Siyatɨ ndɨha kɨwahonyɨhotɨ matoaatɨpatɨ nangɨmaasandihɨhandɨ kandɨ kɨsaahoaisɨ nisaahoŋe, kinyɨ ndɨhotɨ yaiho ikwaatɨpɨho ahɨngotihɨ nehɨmaitandiyo undɨpɨ napitundɨpɨ kaundɨtaise? ");
INSERT INTO agm_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kɨnyɨ jaipɨmwɨndiso atime. Kɨnyɨ kinyɨ ndɨhotɨ matoaatɨpatɨ nangɨmaasandipatɨ jɨhɨ nemape. Nemaposapɨ ipotɨ nga baimbɨ japaapɨ sura kɨsaahomɨ ndɨhotɨ ikwaatɨpɨho ahotisɨho baimbɨ mmonɨpɨ nepumaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Iyataatɨ sahɨ samɨ maarɨho apohɨpataatɨhapɨ nasɨtɨmana apɨpaahɨ gaahaiwa ainjɨhariwɨ isɨhiya kɨhiya kɨhiyai namunyawɨse. O nunyawawaahɨ suhɨrɨ isɨhiya nandapa nunyauhɨhiyai ikwipatamataiwɨ nunyohiyɨhiya sangi aposahaiwa maahoaipupwɨsamapɨ sisɨpɨsatɨtaapo. Aisaihɨ samɨ maarɨho nasɨtɨmana ipotɨsawaitaise. Aiwɨ Autaahaatɨhomɨ pɨwɨha gaahaiwa anaahɨwaiwa isɨhiya kɨhiyai osamapɨ kamundɨwɨse. O saiwɨ kaundawaawaahɨ kiya maasapɨhoai nandapa nunyauhɨ netɨ biya namaanatɨ komɨ auhɨraapɨhɨ netɨ itɨpɨwa isehamasɨpatamataiwɨ samɨ pɨwɨha atɨhomaasiwɨ sisɨpɨsatɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Sahɨ wapa nausetɨtonɨhapaapɨ Autaahaatɨhoaisɨ nunjenawaawaahɨ ko kapa nasamɨtaise. Aiwɨ amɨ sahɨ wapa nihɨrɨna noaasandonɨhapaapɨ pɨhɨtɨwɨ daawaawaahɨ kapa Autaahaatɨho nasisɨtaise. Aiwɨ amɨ wapa maasomwaaŋɨ napwɨtonɨhapaapɨ sahɨ maasomwaaŋɨ tiwisaihaahɨ Autaahaatɨho nuwatɨ kapa nesamɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Isɨ isɨhiya nahatiya wowaatɨ Autaahaatɨhoaisɨ wapaapɨ nanyɨnye undɨwɨ pɨhɨtɨwɨ nunjenɨhohiyɨhiyai kapa nunjenohɨpɨpa Autaahaatɨho numwɨtaise. Isɨ utaaho wo wapaapɨ pɨhɨtatɨ daataataahɨ Autaahaatɨho kɨmbaare unda nunjɨtaise. Isɨ amɨ utaaho wo maasomwaaŋɨ tiwataataahɨ amɨ Autaahaatɨho nɨwuwɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Isɨ samɨ womɨ metɨhonjɨ sapɨhoai nandapa bɨretɨhandapɨ nunjenɨhonɨhɨ nawɨha nemwɨtaiso? Owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Iyataatɨ amɨ metɨhonjɨ wonjɨ sapɨhoaisɨ araiho napopɨhopɨ nunjehonɨhɨ akwɨranɨho nemwɨtaiso? Sandisangi owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Iyataatɨ sahɨ isɨhiyaatɨ samɨ omaŋɨtɨtɨhɨ maipɨhaiwaisahiyaatisɨ samɨ metɨhonyai nasɨsehohɨpɨpa gaahaiwa numwɨtaatɨwɨ gwɨnyaapɨhiyaate. Sahisɨ siyowɨ samɨ Japɨho yamɨhapataatɨhɨ bimisɨhohɨ isɨhiya wapaapɨ koai nunjehohiyɨhiyai tɨtɨhɨ kaiwa gaahaiwa amɨ pɨhɨtatɨ waatɨ numwɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Isɨ amɨ sahɨ isɨhiya usaapɨ kiya saiwɨ kanyitotɨwɨ gwɨnyaahohɨpatamataiwɨ isɨhiya usaisɨ naasaipitɨ katɨ kawiwɨse. Saiwɨ kiyawaawaahɨ sandɨ tɨtɨhɨ wɨnɨhapɨpa sapɨ Autaahaatɨho Mosesihoai numwimbɨpaamunɨ Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaamɨ pɨwɨhaamunɨ akɨpɨpa kiyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Naaŋɨhandɨ apɨpaahandɨ naitaatɨwɨ nutaatɨwɨhapɨhapɨ onepatunɨ daihɨraunɨ taapwɨnɨ awaiwaure. Aihɨ isɨhiya tɨtaahiyɨhiya nanɨhaiwɨ nandaapɨ taawɨ daihɨra kɨra nowaayopo. Isɨ sahɨ baiwɨ onepatɨ maipɨhinjaatɨhɨ nandaapɨ daihɨra maipɨhinjaatɨhɨ naiwɨse. ");
INSERT INTO agm_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Iyataatɨ isɨhiya asɨyɨhiyaimatɨwɨ jinjapɨhɨ bimɨtaatɨwɨhandɨ naitaatɨwɨ onepatɨ nandaitaatɨwɨhatɨ apɨpaahɨ maipehinje. Iyataatɨ sɨra daahira jinjapɨhɨ bimɨtaatɨwɨhandɨ naitaatɨwɨhɨra apɨpaahɨ naaŋɨhɨraare. Aisɨ isɨhiya nɨnaasiyaahɨhɨ onepatɨ maipɨhinjaatɨhɨ mmonawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Isɨhiya pɨwɨha jaiwɨtɨwɨha ausaahohiyɨhiyaapɨ sahɨ baiwɨ jaawo. Isɨhiya siya jaipɨsatɨwɨ Autaahaatɨhomɨ pɨwɨha atisawa newaahaare tɨwɨ kasatɨtaapo. Saiwɨ jaipɨsatɨwɨ samɨhatɨhɨ maasapɨho sipɨsipɨhandamataiwɨ napaisaatɨ aŋɨnɨ napɨtaapo. Nasaihɨ gaahiye tɨwaitaawɨ owetise. Siya isiya suhɨrɨ ainjɨhɨrɨhɨrɨ iko niyatɨ tahamasɨrɨhɨramataiwɨ kiyaamɨ omaŋɨtɨtɨhɨ isɨhiyai nepɨ nopɨsasɨwɨ tahamanɨtaatɨwɨhaiwa kɨpwɨndahiyaare. ");
INSERT INTO agm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Iyataatɨ sahɨ kiyaamɨ pɨwaatɨwɨ daiwɨ bitohohɨrɨhɨretɨ usonawaawɨ siyaatawaawe tɨwɨ mmondaapo. Iyataatɨ wainɨhandamɨ yandɨpɨho dawipatetapɨ ningotɨ ahotihɨ nandawaayowo? Owetise. Iyataatɨ amɨ ipatɨ pɨhoaipɨhomɨ yandɨpɨho woyɨha nahaapatohetɨ ningotɨ ahotihɨ nandawaayowo? Owetise. ");
INSERT INTO agm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Isɨ siyate ipatɨ gaahatɨ yandɨpɨho gaaho ningoaitaise. O amɨ ipatɨ maipɨhatɨ yandɨpɨho amɨ maipɨho ningoaitaise. ");
INSERT INTO agm_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Iyataatɨ ipatɨ gaahatɨ yandɨpɨho maipɨho wɨndɨ namingoaitaise. Iyonɨhɨ amɨ ipatɨ maipɨhatɨ yandɨpɨho gaaho wɨndɨ namingoaitaise. Owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Isɨ ipatɨ nahatepɨ yandɨpɨho wɨndɨ biyatɨ namingosɨpatɨ tisatɨwɨ sisɨhaapɨhɨ tɨhoaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Isɨ amɨ ipatamɨ yandɨpɨho mmonawaawɨ ipa setahatɨndaate tohɨpatamataiwɨ isɨhiya pɨwɨha jaiwɨtɨwɨhaiwa ausaahohiyɨhiyai setahiyaatawaawe tɨwɨ sahɨ usondaapo. ");
INSERT INTO agm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Iyataatɨ isɨhiya jinjapɨhɨ nɨngisɨ Awaisɨhoŋe ndɨwɨ kandohiyɨhiya nahatiya yamɨhapataatɨhɨ nisɨ Apɨho Autaahaatɨho isɨhiyai iwinja bimindɨhandaatɨhɨ wɨndɨ namɨndaitaapo. Apɨpaahɨ owetɨtaise. Nehɨ isɨhiya Apɨho yamɨhapataatɨhɨ bimisɨhomɨ maaritatɨ gwɨnyapesɨrɨhɨretɨ baiwɨ japepihɨrohiyɨhiya siyaahɨhɨ nisɨ Apɨho isɨhiyai iwinja bimindɨhandaatɨhɨ nandaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Iyataatɨ asisɨha ipotɨhetɨ isɨhiya taahiyɨhiya usɨhiya asɨhiya nɨngi sandɨtaapo. ‘Awaisɨhoŋe, Awaisɨhoŋe, kinyɨ ambɨpataahɨ Autaahaatɨhomɨ pɨwɨha atisa newaatɨ ausaahaayo. Iyaatɨ kinyɨ ambɨpataahɨ itɨpɨho maipɨhaiwaisɨ nemahaayo. Iyaatɨ amɨ kinyɨ ambɨpataahɨ watɨpɨhaiwa kahatamatɨpetahaiwa kiyahaayo,’ ndɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ndɨwɨ kandisaihɨ sura nɨnɨ kiyaisɨ ausaatɨ tɨtɨhɨ saundɨto. ‘Sangisɨ nɨnɨ apɨpaahɨ maipɨhonjisangi wɨndɨ maasɨsotɨhiyaate. Sahɨ maipɨhaiwaahɨhɨ kaiwɨhiyaate. Isɨ sahɨ nɨngi nanɨmasi nawɨsawitɨwɨ nuwɨse,’ undɨto. ");
INSERT INTO agm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Isɨ isɨhiya usa nɨnɨ sangi nisɨ pɨwɨha kandɨsasohɨwɨmaiwa baiwɨ atiwɨ japepihɨrawaawaahɨ siya utaaho wo komɨ aŋaaŋɨ aŋɨmatɨtandɨ biyatɨ gwɨnyaatɨ kiyatosa mmonatɨ yapɨpatɨ watɨpɨhatetɨ yasɨha baahɨ mɨhaapɨ anɨtisatɨ mɨhotatɨ aŋɨmatipatamataiwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iyataatɨ aŋaaŋɨ saaŋɨ anɨtiwɨ yasɨha baahɨ mɨhaapɨ mɨhotɨwɨ watɨpɨhaaŋɨ aŋɨmatauhɨ wipatɨ aungwohandɨ wipɨwatɨ waapɨhaatɨ awaindɨhandɨ usepuwatɨ itɨnambɨtɨhɨrɨ aungwohandɨ noaipataatɨ saiwa kwɨtɨwatɨ pimbapoya ikɨpɨndihɨ aŋaaŋɨ saaŋɨ wɨndɨ namaayase. Owetise. ");
INSERT INTO agm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Iyataatɨ amɨ isɨhiya usa nisɨ pɨwɨha kɨma katotɨma atisawaahandɨ kandɨ baiwɨ minjapepihɨrohiyɨhiya siya utaaho wo biyatɨ gɨmunyaatɨ naharisaho aŋaaŋɨ aripatɨ napaipataatɨhɨ aŋɨmatisɨhomataiwɨhiye. ");
INSERT INTO agm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iyataatɨ naharisaho aŋaaŋɨ siyatɨ aripatɨ napaipataatɨhɨ aŋɨmatihɨ wipatɨ aungwohandɨ wipɨwatɨ usepuwatɨ itɨnambɨtɨhɨrɨ napoyaatɨ saiwa saaŋɨ aŋaangi netɨ kwɨtɨwa pimbapoya ikɨpɨndamasɨhɨ niyatɨ noaatɨwotɨ kɨrɨtoandahinjɨ tɨmahiyataise,” undatɨ Jisaasiho isɨhiyai kataunja osasepɨhaataise. ");
INSERT INTO agm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Siyatɨ Jisaasiho pɨwɨha kataunjatɨ osasepɨhaasɨhɨ isɨhiya wɨrisandɨhandɨ kiyaamɨ maarɨho wɨndotaise. ");
INSERT INTO agm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Siyatɨ kiyaamɨ maarɨho wɨndosɨtɨmandɨ apaapɨmaahe, amɨ Jisaasiho pɨwɨha ausaatɨ kataunjimumwaaŋɨ isɨhiya wɨnɨhapɨpa katɨwunjohiyɨhiyaamɨ pɨwɨha ausaapɨ katɨwunjohɨmumwaaŋɨ amusaatɨ komɨ watɨpɨhandisatɨ kataunjihɨ kandapɨ kiyaamɨ maarɨho wɨndotaise. ");
INSERT INTO agm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aihɨ Jisaasiho sisɨhoaasɨnɨ namasi noaatɨpasɨhɨ isɨhiya apɨpaahɨ awaindɨ wɨrisandɨhandɨ nɨwipinjai nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aihɨ utaaho wo asaaha pɨsapɨpaisaho nasatɨ detɨ Jisaasihomɨhinɨ atotɨpɨwesatɨ bindataatɨ Jisaasihoai saundataase. “Awaisɨhoŋe, kɨnyɨ nisɨ asaaha pisapɨmaiwa nepɨnɨmaitaapɨ maaritapaapaahɨ nepɨnɨmape, nɨnɨ noaipatɨ gaahonɨnɨtɨtaano?” tatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aihɨ Jisaasiho asaaha pɨsapɨpaisahoai ikwɨrɨ ahɨwisataatɨ saundataase. “Kinyɨ noaipapɨ gaahoŋimatɨtaapɨ nɨnɨ maaritataayonɨ kinyɨ pisapɨpa owetanɨhɨ kɨnyɨ noaipapɨ gaahoŋimate,” undataase. Undihɨ ketɨ kuraanɨhɨ komɨ asaaha pisapɨpa owetihɨ ko noaipatɨ gaaho popɨtɨhoematataise. ");
INSERT INTO agm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aihɨ ko noaipatɨ gaahotisɨhoai Jisaasiho saundataase, kɨnyɨ baimbɨ atime. “Kinyɨ asaaha pisapɨpa nɨnɨ nehɨmahohɨtɨmandapɨ isɨhiya nehɨhiyai ausaapɨ kamundɨme. Owetise. Nehɨ tɨtɨhɨ koŋɨnɨhɨ numbwɨ pɨrisihiya isɨhiyaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai nunyohiyɨhiyaapɨhɨ noaipape. Numbwɨ noaipasamɨhɨ kiya kinyɨ pisapɨpa akɨtɨnɨhɨ owendaiso tɨwɨ baiwɨ gisopɨ nangɨsapɨse. Aiwɨ kinyɨ asaaha pisapɨpa akɨtɨnɨhɨ owendaise hɨtisaihaahɨ namapɨ Autaahaatɨho nisɨ asaaha timbɨpa nenɨmataise undɨpɨ nunjɨtaapɨhapa kiyai nunye. Numwisamɨhɨ kiya kapa nepɨ Mosesihomɨ wɨnɨhapɨpa katimumwaaŋɨ kamwaaŋɨ kinyapɨ tɨhɨwɨ Autaahaatɨhoai numwɨto,” undatɨ Jisaasiho koai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Aihɨ Jisaasiho niyatɨ aunahɨpatɨ Kapaniyamɨhanda noaipasɨhɨ utaaho wo isɨhiya Romɨhiyaamɨho tunnɨwɨ yahwɨnohiyɨhiya 100 kaiwɨhiyaamɨ mɨtɨho nasataise. Nasatɨ Jisaasihoai nunjenatɨ saundataase. ");
INSERT INTO agm_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Awaisɨhoŋe, nisɨ otɨpɨpatɨho komɨ ikwauhɨrɨ bɨwatetɨ apɨpaahɨ aungwohandɨ yaawihɨ konɨhɨ nanototihɨ kahɨtataato,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Undihɨ Jisaasiho koai saundataase, “Gaasɨ nɨnɨ nundɨ koai tɨtɨhɨwiwɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Undihɨ tunnɨwɨ yahwɨnohiyɨhiyaamɨ mɨtɨho Jisaasihoai saundataase. “Awaisɨhonye, kɨnyɨ nisɨ aŋɨpɨpɨhɨ nambɨ nandaitaapɨ nɨnɨ gaahonɨnɨmaahe. Gaasɨ nehɨ pɨwɨha katisamɨhɨ nisɨ otɨpɨpatɨhomɨ timbɨpa owetɨto. ");
INSERT INTO agm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iyataatɨ nɨnɨsangi isɨhiya usa awaisawɨhiya ninjaawɨ bimauhɨ kiyaamɨ otɨtɨhɨ bindataahonɨne. Iyataatɨ amɨ tunnɨwɨ yahwɨnohiyɨhiya usa nisɨ otɨtɨhɨ bimauhɨ nɨnɨ kiyai iwinjaatɨ bindataayo. Iyataatɨ nɨnɨ utaaho woaisɨ, ‘kɨnyɨ numwe!’ undonaahɨ atisa notaise. Aihɨ amɨ utaaho woaisɨ, ‘kɨnyɨ namme!’ undonaahɨ atisatɨ ko nasataise. Aindɨ amɨ nisɨ otɨpɨpatɨhoai ‘kɨnyɨ kɨmatɨ otɨpɨpatɨ kaime,’ undonaahɨ amɨ atisatɨ kiyataise. Saindɨhonɨnisɨ amɨ kɨnyɨ pɨwɨha katɨpɨ timbɨpa nemaitaapɨ watɨpɨhandisahoŋɨtihɨ nɨnɨ aimɨ gwɨnyaataayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Undatɨ kaundihɨ Jisaasiho atisataatɨ pɨwɨha sa kaundihiyataatɨ yayamatɨ mɨtaahɨ gwɨnyapenataise. Siyatɨ gwɨnyapenataatɨ namatɨ isɨhiya koaisawɨ maasɨ daiwɨ bitohoyɨhiyai saundataase. “Isɨhiya usa utaamo kɨmo biyatɨ gɨwunyaasɨpatamataiwɨ baiwɨ gɨwunyaapɨhiya tɨtɨhɨ akɨtɨnɨhɨ Isɨraherɨhiyai nɨnɨ wɨndɨ akɨtɨnɨhɨ mausoho owetise. ");
INSERT INTO agm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Isɨ nɨnɨ sangisɨ sandɨ kasatataato, yamɨhapataatɨhɨ isɨhiya taahiyɨhiya yapɨhɨ nahandahapɨhiya Abɨraahamɨho, Isaakɨho amɨ Jekopɨho siyaisawɨ maasɨ nandapa nanɨwɨ nahoaiwɨ pɨwaatinjaihɨ Autaahaatɨho kiyaisaahɨhɨ iwinja bimɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Iyatɨ Autaahaatɨho jɨhura isɨhiyai iwinja bimɨtota tɨmaŋa ahɨwisawɨhiyai netɨ ipaahaapɨ asɨhatindɨhandaatɨhemahonɨhɨ gwɨwɨ mangɨrɨ gitɨpaitaapo,” tatɨ kiyaisɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iyatosa tunnɨwɨ yahwɨnohiyɨhiyai tɨhaapundisɨhoai saundataase. “Gaasɨ kinyɨ aŋɨpɨpɨhapɨ numwe, kinyɨ gɨwunyapehingɨtɨhandɨ kandɨ naitaino,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aihɨ Jisaasiho Pitaahomɨ aŋɨpɨpɨhɨ nasatɨ noaipataise. Iyatɨ aŋaaŋɨ nandaatɨ mmonataatɨ Pitaahomɨ sanohaamaatɨ sisɨha nusoaipatɨ yaawihɨ nanotondaise. ");
INSERT INTO agm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aihɨ Jisaasiho kaati ikwɨrɨ ahɨwisa sisɨha timbɨpa nemwa tɨtɨhɨwiwataise. Aihɨ kaatɨ nepatɨ Jisaasihopɨ nandapa turɨhatɨ koai yainjɨraawisataise. ");
INSERT INTO agm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aihɨ asɨhataahura isɨhiya taahiyɨhiya itɨpɨho maipɨhaiwa bimohiyai numwaasi Jisaasihoaapɨhɨ nasawaayopo. Aihɨ Jisaasiho nehɨ komɨ pɨwɨhaaraahɨ itɨpɨho maipɨhaiwaisɨ nemataise. Iyatɨ amɨ isɨhiya nahatiya timbɨpaisahiyai japɨhɨ tɨtɨhɨwiwataise. ");
INSERT INTO agm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Saiwa siyatɨ noaipaitaihɨ Autaahaatɨho komɨ pɨwɨha atisatɨ netɨ ausaasɨho Aisaiyaahoai kaundihɨ ko atisatɨ netɨ sata katisɨha wanɨ akaaha noaipataise. “Ko nyamɨ andɨtatɨ kunyapetotɨhandɨ sawahomɨhetema nyamɨ timbɨpa netɨ awɨnyɨtɨmatɨ nenyamataise,” tatɨ Aisaiyaaho katisɨhaare. ");
INSERT INTO agm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Aihɨ Jisaasiho mmonata isɨhiya durɨhɨramataiwɨ nimaanɨwɨ komɨhinɨ ahoyanɨmɨ nasauhɨ amɨ komɨ otɨpɨpatɨ mmowɨ nepɨ kaiwɨ nuwipinjohiyɨhiyai sata kaundataase. “Durɨhɨrɨ Garirihandamɨ wihɨnapɨ nutɨhaawo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aihɨ utaaho wɨnɨhapɨpa kataunjisɨho nasatɨ Jisaasihoai saundataase, “katɨpunjingɨhonye, wapɨhɨ naisamɨhapɨhɨ nɨnɨ gi nahipinjɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Saundihɨ Jisaasiho koai wihoaaŋɨha saundataase. “Suhɨrɨ ainjɨhɨrɨhɨrɨ kɨramɨ akosɨha yomumwaaŋɨ nanoaitandɨhapɨhɨ ausetahɨre. Iyataatɨ amɨ kohoaisangi nanoaitandɨha itɨha ausetahore. Iyataahandɨ kandɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ nehɨhaatɨ maatɨmaatɨ nanotɨ daayataahonɨnisɨ aŋaaŋɨ owehonɨne,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aihɨ utaaho wo Jisaasihomɨ pɨwɨha atisa neho Jisaasihoai saundataase. “Awaisɨhonye, nɨnɨ gi nangipinjɨtandɨhandɨ kandɨ apɨho napwonɨhɨ yamwaatosamapɨhuraapɨ jatɨtaanɨ kɨnyɨ gaare dɨtaino?” undataase. ");
INSERT INTO agm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Saundihɨ Jisaasiho koai saundataase. “Isɨhiya asɨyɨhiyaimatɨwɨ jinjapɨhɨ jinjapɨhɨ bimɨtaatɨwɨhandɨ owehiya kiyaamɨ napohiyɨhiyai sawana nepɨ yamwaapɨse. Aisaihɨ kɨnyɨ nɨngi nanipinje,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aihɨ Jisaasihoaisawɨ komɨ otɨpɨpatɨ mmonɨwɨ nepɨ kaiwɨ nuwipinjohiyɨhiyaisawɨ kopuhotɨ yamwaasi nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Taawɨ niyauhɨ nuwisaataatapɨ itɨnambɨtɨhɨrɨ apɨpaahɨ aungwohandɨ durɨhɨraatɨhɨ noaipataise. Noaipatɨ itɨnambɨtɨhɨrɨ durɨhɨri tiwayaasɨhɨ waapɨhaatɨ sisɨho dotɨ kopuhotɨ tiraamataise. Sandɨ taatɨ saihɨ Jisaasihohɨ ahomaaya nanomataise. ");
INSERT INTO agm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nanomasɨhɨ komɨ otɨpɨpatɨhiya Jisaasihoenda nuwɨ koai ahowimawaayopo. Ahowimapɨ kiya koai saundawaatopo. “Awaisɨhoŋe, nyangi nanyamaape, nyahɨ aimɨ detɨ waapoho nana owetɨtɨhaawiyono,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Undauhɨ Jisaasiho nepatɨ kiyai saundataase, “Sahɨ napindapɨ yayopo? Sahɨ nisapɨ gɨnunyaahohɨtɨhandɨ maahɨtihe?” undataase. Saundatosatɨ Jisaasiho dotatɨ itɨnambɨtɨhɨrisunɨ durɨhɨrisunɨ yatɨhitɨpɨ owete undihɨ amɨ itɨnambɨtɨhɨrunɨ durɨhɨrɨ sisɨhaiwaamatiyatɨ dosi napiwaiwa Jisaasihomɨ maahomwaaŋɨ atɨwisa kandɨnɨhɨ apɨpaahɨ yatɨhita owendaise. ");
INSERT INTO agm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Saiwa saihɨ Jisaasihomɨ otɨpɨpatɨhiya ese tɨwɨ ikwɨrɨ mangɨra ikwɨnawaayopo. Ikwɨnɨwɨ sanawaatopo. “Kɨmo utaamo napimahoe? Amɨ itɨnambɨtɨhɨrɨ waapɨhaatɨ sisɨhomatiyahaiwaisangi komɨ maahomwaaŋɨ atɨwisa asɨmwaatɨtɨhɨ sanaindɨmando?” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aihɨ Jisaasihoaisawɨ komɨ otɨpɨpatɨhiyaisawɨ durɨhɨrɨ nahaitɨwɨ wihɨnɨ mɨhihɨnɨ yapɨpatɨ Gataraahanda nuwɨ noaipawaayopo. Nuwɨ noaipɨhauhɨ utaahurɨ yahurɨ itɨpɨho maipɨhaiwa nɨwɨndaapɨ bimauhɨhurɨ akosɨha isɨhiya napohiyɨhiyai ahiyohɨpɨpɨhɨ bindamaahurɨ kɨraapɨ napihɨ Jisaasihoaisawɨ nutanawaayopo. Iyataatɨ utaasurɨ surɨ apɨpaahɨ watɨpɨhurɨtihɨ isɨhiya yaiwɨ wɨndɨ dahomaiwɨhɨraare. ");
INSERT INTO agm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aihɨ surɨ utaasuramɨhatɨhapɨ itɨpɨho maipɨhaiwa Jisaasihoai saundɨwɨ kaahaundawaatopo. “Autaahaatɨhomɨ Mwaahonye, kɨnyɨ nyangi napitɨnyitaape? Nyamɨ asisɨha kɨnyɨ nyangi nyapɨ mwɨnyapɨ yaasɨhandɨ nanyamɨtaapɨha sangɨ noaipasɨ napaapɨ nambɨhoŋe?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aihɨ sapɨhɨ onɨhɨ wonjɨ maasapɨho asakiyatɨ taahɨwaiwa nandapa nanɨwɨ bitotawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aihɨ itɨpɨho maipɨhaiwa Jisaasihoai saundɨwi gɨwusewaayopo. “Amɨ kɨnyɨ nyangi utaamurɨ kɨmuramɨmatɨhapɨ nepɨnyamaitaapaahɨ maasamaiwaatɨhɨ nowa nandaitaanɨ natɨpɨnyoaase,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Undauhɨ Jisaasiho itɨpɨho maipiwai sata kaundataase, “Kiyonaahɨ nuwɨse,” undataase. Jisaasiho saunda nuwɨse undihɨ itɨpɨho maipiwai kurɨ utaasuraatɨhapɨ noaipasi kapɨhɨ maasapɨhaiwa asakiyatɨ bitosɨwaiwaatɨhɨ nandaawaayopo. Itɨpɨho maipiwai maasapɨhaiwaatɨhɨ nuwɨ nandaahauhɨ maasapiwa nehoaatetetɨ ainjɨhariwɨ namaŋɨndi nuwɨ durɨhɨraatɨhɨ naapwaatɨwɨ waapoho nanɨwɨ nawatisawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aihɨ isɨhiya maasapɨhaiwa jaawɨ bitohohiyɨhiya sandɨ mmowɨmapɨ aunahɨpataahapɨ yanɨhɨmapɨ nowaayopo. Nuwɨ Jisaasiho kaiwaiwa nahatewa ausaapɨ kaundawaatopo. Kaundawaawɨ amɨ Jisaasiho utaahuramɨhatɨhapɨ itɨpɨho maipɨhaiwa nemwasɨhɨ kurɨ noaipapɨ gaahurimatindɨhandapimaawɨ kaundɨwɨ gaamawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Saiwa Jisaasiho kaiwaiwaapɨ satɨwɨ kaundauhɨ atiwɨmapɨ isɨhiya aunahɨpatɨ nahandɨ nupwɨsasɨwesi Jisaasihoaisunɨ utaahurɨ kuramɨhatɨhapɨ itɨpɨho maipɨhaiwa nemwaasururisunɨ iwinjaitaatɨwɨ nasawaayopo. Napɨwɨ Jisaasihoaisunɨ utaahurɨ kuramɨhatɨhapɨ itɨpɨho maipɨhaiwa nemwasururisunɨ baiwɨ usonɨwɨ gaamawaayopo. Usowɨ kaiwosawɨ Jisaasihoai isɨhiya aunahɨpataahapɨhiya gɨwusepɨ napaisaatundɨwɨ nyamɨ yapɨpatɨ namasi wɨtaahapɨ numwe undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Saundauhɨ Jisaasiho kopuhotɨ yamwaasi jahɨra durɨhɨraatɨhɨra nahaita komɨ aunahɨpatɨ Kapaniyamɨhandaahapɨ nasataise. ");
INSERT INTO agm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nasa noaipasɨhɨ isɨhiya usa Jisaasiho tɨtɨhɨwiwɨtotɨwɨ gwɨnyapenawaawɨ utaaho wo komɨ ikwauhɨrɨ apɨpaahɨ bɨwatesɨhɨ wɨndɨ dosi dahomaayaho gwɨtɨhotɨ autaahɨ nanototihɨhoai numwaasi nasawaayopo. Siyauhɨ Jisaasiho kiyaamɨ sawahopɨ gɨwunyaahohɨtɨhandɨ usonataise. Usonatosatɨ utaaho komɨ ikwauhɨrɨ bɨwatesɨhoai saundataase. “Nisɨ maasɨho andɨtitɨpɨ maarɨho wɨhitane. Nɨnɨ kinyɨ maipɨhaiwa nehɨmataayono,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aihɨ isɨhiya usa wɨnɨhapɨpa katɨwunjohiyɨhiya kiyaamɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhapɨ sawana sanawaatopo. “Utaamo kɨmo isɨhiyaamɨ maipɨhaiwa nemwatɨhonɨne tatɨ Autaahaatɨhopɨ sisɨpɨhɨndaase,” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sanɨhauhɨ Jisaasiho kiyaamɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhɨ usonatosatɨ kiyai saundataase. “Sahɨ saiwa maipɨmaiwa napindapɨ taawɨ gwɨnyapehopo? ");
INSERT INTO agm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pɨwɨha kɨmairamɨ maahɨwaanɨhɨ usaayataise? Nɨnɨ satɨtandɨmaaro? ‘Nɨnɨ kinyɨ maipɨhaiwa nehɨmataayo tɨtandɨmaaro e kinyɨ timbɨpa nehɨmataayonɨ dosi numwe,’ tɨtandɨmaaro? ");
INSERT INTO agm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Isɨ amɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonisapɨ ko yapɨpataapɨhɨ isɨhiyaamɨ maipɨhaiwa nemwaitandɨ kɨmaapɨ Autaahaatɨhomɨ watɨpɨhandisahore tɨwɨ sahɨ mmondaatɨwɨ nɨnɨ sangi saindɨ nasisɨtaano,” undatɨ isɨhiyaisɨ kaundataase. Saundatosatɨ utaaho komɨ ikwauhɨrɨ bɨwatesɨhoai saundataase. “Nepapɨ dopɨ kinyɨ yutɨhɨrɨ gwaasɨha nesi kinyɨ aŋɨpɨpɨhapɨ numwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Saundihɨ utaaho komɨ ikwauhɨrɨ bɨwatetɨ andɨtɨmitisɨho nepatɨ dosi komɨ aŋɨpɨpɨhapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Saiwa siya Jisaasiho utaaho komɨ ikwauhɨrɨ bɨwatetɨ napwisɨhoai tɨtɨhemwasɨtɨmandɨ isɨhiya mmonawa Autaahaatɨhopɨ yaiwɨ siyatɨ Autaahaatɨho isɨhiya yapɨpataapɨhiyai watɨpɨhandɨ numwindɨhandapɨ maaritɨwɨ komɨ ambɨpatɨ nɨwimaapɨ mepɨ autaahemwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisaasiho sapɨhɨ aŋɨpɨpɨhɨ namasi taatɨ daihɨra notaatɨ nɨnɨ Matiyuhonɨnɨ Romɨhandaahapɨ gamanɨhopɨ nawɨho isɨhiya nahatiyaamɨ nehohɨhonɨnɨ aŋaaŋɨ nisɨ opisihandaapɨhɨ bimonɨhɨ ninjataise. Ninjatosatɨ Jisaasiho nɨngi sandataase. “Kɨnyɨ nambɨ nɨngi nanipinje,” ndihɨ nɨnɨ dosi Jisaasihoai nɨwipinjataayo. ");
INSERT INTO agm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Aihɨ Jisaasiho nisɨ aŋɨpɨpɨhɨ taatɨ nandapa nainjɨhɨ isɨhiya taahiyɨhiya nawɨho takisihandɨ ikonɨwɨ nehohiyɨhiyaunɨ isɨhiya maipɨhiya maasaimaarɨhiyaunɨ napɨwɨ Jisaasihoaisawunɨ amɨ komɨ otɨpɨpatɨhiyaisawunɨ nandapa maawɨ nanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Aihɨ saiwɨ nanɨhauhɨ isɨhiya usa Parisihiya Jisaasiho isɨhiya nawɨho takisihandɨ ikonɨwɨ nehohiyɨhiyaisatunɨ isɨhiya maatɨmaatapɨ maipɨhiya maasaimaarɨhiyaisatɨ nandapa nainjɨhɨ iwinjawaayopo. Winjaposawɨ Parisihiya Jisaasihomɨ otɨpɨpatɨhiya nuwipinjohiyɨhiyai satɨwɨ nunjenawaayopo. “Sangi kiyasisisɨho nawɨho takisihandɨ ikonɨwɨ nehohiyɨhiyaisatunɨ isɨhiya maipɨhiya maasaimaarɨhiyaisatunɨ napaapɨ nandapa nainje?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kiya satauhɨ Jisaasiho atɨwisatosatɨ kiyaamɨ pɨwɨha netɨ saundataase. “Isɨhiya ainahiyɨhiyaanɨnɨ timbɨmaayaahiyaanɨne tɨwɨhiya siya dokɨtaahoaapɨhɨ nowaamaayopo. Isɨhiya mmotɨnɨwɨ timbiyaahiyaanɨne tɨwɨhiyaahɨhɨ dokɨtaahoenda nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Autaahaatɨhomɨ pɨwɨha jɨpatɨpindisɨha nɨnɨ kasatɨtandiyohɨmaamɨ tanyaaha napondaase tɨwɨ nepɨ tipɨtapaapɨ mmonɨwɨse. ‘Sahɨ nɨngi maarɨho naninyawɨ isɨhiyai iwɨtatamanɨwɨ maarɨho wɨwihohɨtɨhandapaanyise samɨ kohasɨpɨho nandapa tɨhɨwɨ sisandɨpapɨ nanɨmɨtaatɨwɨhapaapɨmaanyise,’ tisɨhaapɨto. Iyataatɨ nɨnɨ isɨhiya satɨwɨ nyahɨ maipɨhaiwa oweta tɨtɨhɨ gaahiyaanɨne tohiyɨhiyai gandɨ numwaitandɨ napɨtɨhonɨnɨmaahe. Owetise. Isɨhiya satɨwɨ nyahɨ maipɨhaiwa kiyaatɨ maipɨhiyaanɨne tohiyɨhiyai gandɨ numwaitandɨ napɨtɨhonɨne,” undatɨ Parisihiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kaihɨ Jonɨho isɨhiyai waapohora baawusisɨhoai nuwipinjohiyɨhiya Jisaasihoenda napɨwɨ sawana kiyaunɨ Parisihiyaunɨ asisɨha waiwaara nandapa namaanɨwɨ onaayohɨtɨhandapɨ Jisaasihoai saundɨwɨ nunjenawaayopo. “Nyahunɨ Parisihiyaunɨ nyamɨhatɨ siyaahiyaane, Autaahaatɨhopɨ gaapundaatɨ koaisa pɨwaatɨndaahura asisɨha waiwaara nandapa namaanaatɨ onaayahaayo. Nyahɨ siyahaayonɨ amɨ gi nangipinjawɨ kinyɨ otɨpɨpatɨ mmonɨwɨ nepɨ kiyohiyɨmiya napaapɨ nandapa wonjɨ masɨhonjɨsangi apɨpaahɨ onaamaayopo?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Saundauhɨ amɨ Jisaasiho kiyai saundataase. “Nɨnɨ wonɨnɨmesanɨhura nandapa namaanɨwɨ onaiwɨ maarɨho asɨpaitaatɨwɨhiyaasɨ wanɨ nɨnɨ kiyaisatɨ maasɨ bindataayonɨ nisɨ otɨpɨpatɨ kaiwɨ nanipinjoyɨmiya nandapa onaamaiwɨ nanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Iyataatɨ Utaaho wo yutɨhɨrɨ asɨrɨhɨrɨ namandipatɨ jahɨrɨhɨrɨ napwɨrɨnɨhonɨhɨretɨ tɨmaamahɨwatɨ wɨndɨ ngɨmundaise. Amɨ tɨmaamahɨwatɨ gwɨnɨhonaahɨ yutɨhɨrɨ jahɨrɨhɨrɨ napwɨrinjɨpɨpɨhɨ mɨtaahɨ awaindɨhandɨ napwɨrɨndaise tatɨ kandaase. ");
INSERT INTO agm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Iyataatɨ amɨ pɨwɨha waisangi siyate: waapoho wainɨhandɨ asɨtɨhandɨ wipatɨ jahɨpatɨ pusatɨ namasaatɨhatopɨ isɨhiya wɨndɨ nuhaapɨ wɨmiwɨtaapo. O amɨ nuhaapɨ wiwawaawaahɨ wainɨhandɨ wipatetɨ namanatɨ nipitotayata nawatandɨwa nehɨhaatɨ nuhandɨwa owetanɨhɨ amɨ wipatisangi nawatata nopɨsasɨndaise. O amɨ wainɨhandɨ asɨtɨhandɨ wipatɨ asɨpata nuhaapɨ wiwawaawaahɨ maiwɨ wainɨhandunɨ wipatunɨ biyatɨ nga ahotɨtaise,” tatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisaasiho taatɨ sandɨ saundihɨ Judaahiyaamɨ aŋaaŋɨ pɨwɨhaapɨ ahoyanohaaŋaaŋɨ ja bimisɨho mɨtɨho Jisaasihoenda nasatɨ komɨ auhɨraapɨhɨ atotɨpɨwesatɨ bindata saundataase. “Nisɨ maasɨhaama wanɨ kaatɨnɨhɨ napwise. Napwisɨ amɨ kɨnyɨ nambɨ ikwɨrɨ ahɨwisapɨ ahowimasamɨhɨ nepa jahɨra asaamaatimatatɨ bimɨtaisɨ namme,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aihɨ Jisaasiho dosi Judaahiya kapɨhapɨhiyaamɨ mɨtɨhoaisamɨ komɨ aŋɨpɨpɨhapɨ naihɨ Jisaasihomɨ otɨpɨpatɨhiyaanangisangi maawɨ nohaayo. ");
INSERT INTO agm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Taawa daihɨra niyonɨhɨ apopaatɨ waatɨ jɨtɨpatɨ apɨpaahɨ namandarisatɨ kɨnaungwɨha ikwɨ maindɨmwɨtihɨ auhɨramɨ yahurɨ 12 kiya sanawihɨ jɨtɨmainjɨhaatɨ dawaataatapɨ nasatɨ Jisaasihomɨ utɨ apotɨhɨramɨ otasaaha iwiwataise. ");
INSERT INTO agm_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sandɨ apopaatɨ Jisaasihomɨ utɨ apotɨhɨrɨ iwisɨtɨndɨ sawahaatɨ kaatamɨ maarɨhoaatɨhɨ sata gwɨnyaataate. “Amɨ nɨnɨ nehɨ Jisaasihomɨ utɨ apotɨhɨrɨ iwiwataataahɨ nisɨ timbɨmba jɨtɨmahohɨtɨmandɨ owenetɨtaise,” tate. ");
INSERT INTO agm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Siya iwisɨhɨ Jisaasiho nepemaita kaati iwinjata saundataase. “Itapo kɨnyɨ andɨtitɨpɨ kinyɨ maarɨho wɨhitane. Nisapɨ kɨnyɨ gɨnunyaahingɨtɨhanda kinyɨ timbɨpa jɨtɨmahingɨtɨhandɨ owesendaiso,” undataase. Aihɨ ketɨ kuraanɨhɨ saatɨ apopaatamɨ timbɨpa timbiya jɨtɨmasɨpɨpa gausendaise. ");
INSERT INTO agm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aihɨ Jisaasiho utaaho awaisɨhomɨ aŋaaŋɨ nandaataise. Nandaatɨ aŋaaŋɨ mmonata isɨhiya maarɨho tundihɨ awirɨhɨrɨ taawɨ awirɨtɨwɨ ŋuŋaatɨwɨ gwauhɨ usonataise. ");
INSERT INTO agm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Iwinjatosa saundataase, “Kɨmaatɨ apopɨ metɨmaatɨ napotaamaise. Owe. Kaatɨhɨ nehɨ nanotondaise. Nanototihɨ ahowimatandiyonɨ sahɨ noaipapɨse,” undataase. Saundihɨ kiya isɨhiya nahatiya awirɨtɨwɨ gwɨwɨ bimohiyɨhiya dopɨ Jisaasihoai kɨnyɨ akɨtatɨnno undɨwɨ sisɨpundawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aihɨ isɨhiya awirɨtɨwɨ ŋuŋaatɨwɨ gwohiyɨhiyai aipɨ nepɨ nipinjawɨ ipaahaapemahauhɨ noaipasi nawɨsawitauhɨ kura Jisaasiho apopa metɨhaatɨ napotɨ nanototirɨhɨrotɨ aŋaaŋɨ nandaatɨ kaatamɨ ikwɨrɨ iwiwa ahowimasɨhɨ napomasaama jahɨra nepataise. ");
INSERT INTO agm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aihɨ sandɨ Jisaasiho apopɨ metɨmaatɨ napomasɨhɨ jahɨra gaata ahowimasɨhɨ nepasɨtɨmandapɨ pɨwɨha sa nesi aunahɨpɨhaiwaara kanɨwɨ gaamawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iyataatɨ Jisaasiho sapɨhɨ aŋɨpɨpɨhɨ taatɨ naihɨ utaahurɨ yahurɨ kuramɨ ndɨha maipɨta asɨhatihɨ wɨndɨ baimɨ minjapɨhurɨ koai nuwipinjai nomaise. Nuwipinjai nomaamɨ Jisaasihoai saundamaase. “Daawitɨhomɨ mwaahoŋɨ awaisɨhoŋe, yɨhoaanyangi kinyɨ maarɨho asɨpɨnyime,” undɨmɨ kaahaundamaise. ");
INSERT INTO agm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aihɨ Jisaasiho aimɨ notɨ aŋɨtɨtɨhɨ nandaatɨ bimihɨhura kurɨ ndɨha maipɨhurɨ nandaapɨ koai iwinjamaise. Nandaapɨ iwinjasɨhɨ kuri Jisaasiho saunda nunjenataise. “Sɨhoaahɨ nɨnɨ sɨhoaasamɨ ndɨha asɨhatisɨma nga nasorɨhaitandɨ akɨtɨnɨhɨ baimɨ nisapɨ gɨnunyaamaiso?” unda nunjenataise. Siyatɨ nunjesɨhɨ amɨ kurɨ Jisaasihoai saundamaase. “Ye Awaisɨhonye, yɨhoaaŋɨ siyaha gɨhunyaahaayo,” undamaase. ");
INSERT INTO agm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aihɨ Jisaasiho kuramɨ ndɨhotɨ iwiwatɨ saundataase. “Sɨhoaahɨ nisapɨ gɨnunyaasɨrɨhɨretɨ sɨhoaasamɨ ndɨha nasorɨhaatonɨhɨ jasamɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Saundihɨ kuramɨ ndɨha jahɨra nusorɨhaatihɨ jamaise. Jasɨhɨ Jisaasiho kuri pɨwɨha watɨpɨha nunya saundataase. “Sɨhoaahɨ nɨnɨ sɨhoaasamɨ ndɨha nasorɨhaahotɨmandapɨ isɨhiyai ausaapɨ wɨndɨ kamundɨmise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iyatɨ Jisaasiho saunda kamundɨmise undihɨhandɨ kandɨ kurɨhɨ numwɨ sapɨhɨ yapita gaamapɨ Jisaasihopɨ pɨwɨha ausaapɨ isɨhiyai kaundɨmɨ gaamamaise. ");
INSERT INTO agm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aihɨ utaahurɨ kuramɨ ndɨha Jisaasiho nusorɨhaasururɨ taamɨ naihɨ isɨhiya usa utaaho wo itɨpɨho maipɨho isɨhiyaamɨ pɨwɨha nema kiyaamɨ maahomwaaŋɨ nɨwisapusɨhɨ pɨwaamaatɨwɨho nɨwɨndaasɨhɨ pɨwaamaatahoai numwaasi Jisaasihoenda nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Numwaasi nasauhɨ utaaso so komɨ maahomwaaŋɨ napupwasɨhomɨ omaŋɨtɨtɨhapɨ Jisaasiho itɨpɨho maipɨho isɨhiyaamɨ pɨwɨha nema kiyaamɨ maahomwaaŋɨ nɨwisapusɨhɨ pɨwaamaatɨwɨhoai netɨ ipaahaapɨ natausaasihɨ noaipasi naihɨ utaaso so pɨwɨha namasatɨ pɨwandaase. Siyatɨ komɨ maahomwaaŋɨ nɨwusainjɨhɨ pɨwaatihɨ isɨhiya Jisaasiho nɨwusoaasɨhɨ iwinjahohiyɨhiya awaindɨhandɨ mɨtaahɨ gwɨnyapepɨ satawaatopo. “Nyahɨ siyaahandɨ jɨhɨ wɨndɨ yapɨpatɨ Isɨraherɨhanda namoaipasɨhɨ monaahiyaanɨne,” tɨwɨ ese tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aihɨ amɨ Parisihiya saiwa Jisaasimo kaiwɨmaiwaapɨ wipɨtɨwɨ satawaatopo. “Itɨpɨho maipɨhaiwaamɨ awaisɨho Bwaasɨrɨhɨrɨ Jisaasihoai watɨpɨhandɨ numwihɨ ko saiwa itɨpɨho maipɨmaiwa nemataise,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Aihɨ Jisaasiho notɨ nesɨwesɨwa aunahɨpa awaiwaiwaaraahunɨ gwɨharaahaiwaaraahunɨ japepihɨra daaya isɨhiyai usonataise. Iyatɨ ko kiyaamɨ aŋaaŋɨ pɨwɨhaapɨ ahoyanohɨwaiwaatɨhɨ kataunjataise. Iyatɨ ko Autaahaatɨho nyainja bimindɨhandɨ isɨhiyaanamɨ otɨhatɨhɨ nesisa mɨhotɨtandɨhandapɨ pɨwɨha gaaha wanɨha ausaatɨ kaundataase. Siyatɨ ausa kaundatɨ isɨhiya timbɨpa gɨmunyaata kahatamatɨpetɨhaiwa kiyaamɨ ambɨpatetɨ wɨrapɨ isɨpɨ daayohɨwaiwa nemwa tɨtɨhɨwiwataise. ");
INSERT INTO agm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Otɨpɨpatɨ saiwa kiyatɨ daayatɨ usonata isɨhiya taahiyɨhiyai isɨhiyaunɨ itɨpɨho maipɨhaiwaunɨ naaŋɨhaiwa nunyawɨ iwɨtaatisauhɨ kiya tihɨrɨ usaaha nawapwaahomataiwɨ naaŋɨhaiwa wɨrapɨ isɨpɨ daiwɨ bindawaayopo. Iyataatɨ amɨ kiyai isɨhiya usa ikwɨrɨ numwɨtaatɨwɨhiya owetihɨ maasapɨho sipɨsipɨhandɨ satɨho owehandamataiwɨ daiwɨ bitotawaayopo. Iyauhɨ kiyaapɨ Jisaasiho komɨ maarɨho awaindɨhandɨ asɨpiyatɨ tundataise. ");
INSERT INTO agm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Siyatɨ kiyaapɨ maarɨho tundihɨ Jisaasiho komɨ otɨpɨpatɨ mmonɨwɨ nepɨ kaiwɨ maawɨ nuwipinjauhɨ daisawɨhiyai saundataase. “Nandapa osaataatɨ kɨpwɨtaatɨwɨhapa aimɨ asakiyatɨ tɨmendaahandɨ kandɨ kɨpwɨwɨ nepɨ ahoaitaatɨwɨhiya yahingwaasɨhɨhe. ");
INSERT INTO agm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Isɨ nandapa kɨpwɨtaatɨwɨhapa tɨmetimbɨpaamɨ Satɨho Awaisɨho daatɨ otɨpɨpatɨhiya kɨpwɨtaatɨwɨhiyai sawaho natausaasɨta sahɨ kopɨ gaapundɨwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisaasiho komɨ otɨpɨpatɨ mmona newa kiyaatɨ koai nuwipinja maawɨ daayohiyɨhiyaanɨ ikwɨmaindɨmwɨtihɨ auhɨramɨ yahurɨta 12 kiyahiyaanangi gaata nanyamaatɨ Autaahaatɨhomɨ watɨpɨhandɨ itɨpɨho maipɨhaiwa nehɨhaatɨ newa yota timbɨpa kahatamatɨpetahapa isɨhiyaamɨhetapɨ newaamaatɨ tɨtɨhɨwiwɨtɨhaawɨ nyangi nanyinyataise. ");
INSERT INTO agm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iyataatɨ Jisaasiho natanyoaasɨtandɨ gaatatɨ nanyamaasawɨhiyaanɨ aposerɨhiyo tohiyɨhiyaanɨ nyamɨ ambɨpatɨ siyaane: Saimonɨho komɨ ambɨpatɨ wɨtɨ Pitaahotihɨ komɨ saingɨho Endɨruhotihɨ Sepetihomɨ mwaahurɨ saahosaingɨho Jemɨsiyɨ Joniye. ");
INSERT INTO agm_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Aihɨ Piripɨhotihɨ, Batoromiyuhotihɨ, Tomaasihotihɨ amɨ nɨnɨ Matiyuhonɨnɨ nawɨho takisihandɨ jɨhura nehohɨhonɨnɨtihɨ, Arɨpiyaasihomɨ mwaaho Jemɨsihotihɨ amɨ Tatiyaasihotihe. ");
INSERT INTO agm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Aihɨ amɨ Saimonɨho wo Judaahiyaanɨ Romɨhandaahiyaamɨ otɨtɨhɨ bimɨtɨhaawɨ pohipiyohiyɨhiyaanamɨhotihɨ amɨ Judaasiho aunahɨpatɨ Kariyotɨhandaahapɨho Jisaasihoai ipotɨhura ahosumwa tiwɨtaatɨwɨhiyai nusepaasɨhotihɨ siyaane. ");
INSERT INTO agm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aihɨ Jisaasiho komɨ aposerɨhiyaanɨ ikwɨmaitɨmwɨtihɨ auhɨramɨ yahurɨta 12 kiyahiyaanangi pɨwɨha wɨnɨhapɨpa sata kanyatatɨ sawahomɨ otɨpɨpatɨ kaitɨhaawɨ natanyoaasataise. “Sahɨ wuwanɨnɨhɨ namasawɨ kiyawaawɨ Isɨraherɨhiyaanamɨ ipaahaapɨ dawaataatɨ bimohiyɨhiyaamɨhatɨhunɨ amɨ isɨhiya Samariyaahandaahiyaamɨ aunahɨpɨhaiwaara wɨndɨ namuwɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Siyawaawɨ sahɨ nehɨ isɨhiyaatɨ Isɨraherɨhiyaatamɨ yapɨpatɨ aunahɨpata nuwɨ samɨ isɨhiya Isɨraherɨhiya maasapɨho sipɨsipɨhandamataiwɨ owetohiyɨhiyaapɨhɨ nuwɨse. Nuwɨ daapɨ numwaapɨ nepɨ ahoyawɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Saiwɨ nuwɨ pɨwɨha sahɨ satɨwɨ ausaapɨse: ‘Autaahaatɨho sangi jainja bimindɨhandɨ aimɨ samɨhatɨhɨ nasatɨ kɨmandɨ detɨndaise,’ undɨwɨ kaundɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Aiwɨ isɨhiyaamɨ timbɨpa nemwapɨ ipatisawɨ napohiyɨhiyai ahowimapɨ numwaapɨ asaaha pɨsapɨpaisahiyai kiyaamɨ pisapɨpa nepumapɨ isɨhiyaamɨhatɨhɨ itɨpɨho maipɨhaiwa nɨwɨndaasɨwaiwa nepumapɨse. Iyawaawɨ saiwɨ nawɨho namunyawɨ nehɨhaiwa nepɨhaiwaasɨ saiwa sahɨ nehɨhaiwa nehohɨwiwa nawɨho namepɨ isɨhiyai nehɨ nunyawɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Saiwɨ nowaawɨ nawɨho wo mipɨ jisɨho tuhwɨnɨpɨhoaisangi apɨpaahɨ owehiyaatɨ taanahiyɨhiyaatɨ nuwɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Iyawaawɨ amɨ ikihɨsangi oweta wɨndɨ mipɨse. Aiwɨ yutɨ apotɨhɨrɨ asuipatɨ ngɨrɨhɨrɨ isɨpɨpaisangi wɨndɨ mipɨ nehɨ niyopɨ isɨhohɨpɨpa sapa kapaahɨtanɨhɨ nuwɨse. Wo otɨpɨpatɨhoaisangi komɨ otɨpɨpatɨ kaipatapɨ nandapa nunyauhɨ netɨ nainjɨtɨhandɨsɨ amɨ sangisangi otɨpɨpatɨhiyaatɨsɨ samɨ otɨpɨpatɨ kiyohɨwaiwaapɨ aunahɨpataahɨsɨ nandapa nasanyawɨ tɨhɨngwaasɨsitaawɨ nehɨ taanahiyaatɨ nuwɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Aunahɨpa wɨtɨ awaipataahisangi amɨ gwɨharaahataahisangi sahɨ nuwɨ noaipapɨ pɨwɨha ausaawaahura katɨ aunahɨpita utaaho wo gaaho samɨ pɨwɨha biyatɨ maaritatɨ atisonɨhopɨ mmonɨwɨse. Mmowɨ siyatɨ samɨ pɨwɨha maaritatɨ atisataatɨ komɨ aŋɨpɨpɨhɨ sangi nasamaahonaahɨ koai nɨwipaapɨse. Koai nɨwipaapɨ sapɨhɨ koaisawaahɨ bimambɨwɨ nutaatɨwɨhura komɨ aŋaaŋapɨ noaipasi satɨ aunahɨpatɨ namasi nuwɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Amɨ sahɨ aŋaaŋɨ wɨndaapɨhɨ nuwɨ nandaawaahura kaaŋamɨ saisa satoyai saundɨwɨse. ‘Autaahaatɨhomɨ asisɨha gaahure. Komɨ napaindɨhandɨ samɨ omaŋɨtɨtɨhɨ napaisaatɨsamaitandɨhandɨ sangisatɨ maawe,’ undɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Iyataatɨ amɨ isɨhiya sandɨ aŋɨndaapɨhapɨhiya sangi nasamaasaihaahɨ samɨ pɨwɨha kiyai saundohɨha Autaahaatɨhomɨ asisɨha gaahure. Komɨ napaindɨhandɨ sangisatɨ maawe undohɨtɨhandamɨ akɨtɨhandɨ sawaho Autaahaatɨho netɨ numwɨtaise. O amɨ sangi kiyaamɨ aŋɨpɨpɨhɨ namaasamaasaihaahɨ samɨ kiyai saundohɨtɨhandamɨ akɨtɨhandɨ napaindɨhandɨ Autaahaatɨho jahɨra kiyaamɨhetapɨ netɨ sawanaatangi nasamɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Iyataatɨ isɨhiya usa sangi namaasamaapɨ pɨwɨha atɨhomaasisaihaahɨ sapɨhɨ kapɨhɨ samɨ auhɨretɨ ikwaatɨpɨho asisotisɨho tuwɨhaapɨ nemapɨse Autaahaatɨho sahɨ namepemaitohɨtɨhandapɨ sangisɨ siyatɨ ahosɨsamaitaise undɨwo. ");
INSERT INTO agm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iyawaawɨ kɨmandɨ baiwɨ gwɨnyapenɨwɨse. Sɨhɨ asisɨha isɨhiyai Autaahaatɨho netɨ tipɨtapaitandɨhura isɨhiya aunahɨpatɨ Sotomɨhandaahiyaisunɨ Gomoraahandaahiyaisunɨ Autaahaatɨho kiyaamɨ maipɨhaiwa kiyohɨwaiwaapɨ wɨndɨ awaindɨhandɨ ahosumwa mandɨtɨmaawitaise. Iyataatɨ amɨ isɨhiya aunahɨpiwa sangi wɨndɨ namaasamaapɨ samɨ pɨwɨha atɨhomaasiwɨ ahosɨsamahohɨwaiwai Autaahaatɨho naaŋɨhaiwa jɨhɨ Sotomɨhiyaisunɨ Gomoraahiyaisunɨ numwiwaiwai daahemwahaiwa mɨtaahɨ aungwohandɨ nunyatɨ mandɨtɨwitaise,” nyatatɨ Jisaasiho ko natanyoaasisawɨhiyaanɨ aposerɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kanyatatosa Jisaasiho pɨwɨha bihɨwainja sanyatataase. “Atiwɨse. Nɨnɨ sangi maasapɨho sipɨsipɨhandamataiwɨ andɨtɨmitɨwɨ napaisaatɨ nanɨhaiwɨhiyaatangi isɨhiya suhɨrɨ ainjɨhɨrɨramataiwɨ tipɨ ikɨwɨ tahamanɨwɨ nopɨsasɨwɨhiyaamɨhatɨhɨ nandɨsoaasataayo. Siyataayonɨ sahɨ baiwɨ akwɨranɨhomataiwɨ mɨhopɨ mɨhaapɨ japepinjawɨ gwɨnyaapɨ mmotɨnɨwɨ amɨ koho dɨpɨhomataiwɨ nehɨ aŋɨnɨ napaisaatɨ otɨpɨpatɨ kaiwɨ daiwɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Iyawaawɨ baiwɨ jaawɨ bitosawɨse sahɨ kaisaihɨhaiwaapɨ isɨhiya pɨwɨha samɨhetemapɨ itɨhɨsatɨwɨ kiyaamɨ aŋaaŋɨ pɨwɨhaapɨ ahoyanohɨwaiwaatɨhɨ wɨrɨhɨrɨ gupwata yasupwaitaawo. ");
INSERT INTO agm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Saiwa sangi isɨhiya kiyaamɨ awaisawɨhiyaapɨhɨ kahapɨhepɨsamapɨ nasamaasi nuwɨ nisɨ ambɨpatapɨsatɨwɨ naaŋatɨ yaasɨhaiwa nasanyawɨ tɨsapɨ mwɨsawɨtaapo. Saiwɨ sasisaihɨ kiya Judaahiyaisunɨ isɨhiya kiyaamɨ dawaataatapɨ Autaahaatɨhopɨ atɨhomiwɨ gɨmunyaapɨhiyaamɨ awaisawɨhiyaisunɨ sahɨ nɨnɨ kaindɨ kaindunjatɨ kiyohɨwaiwaapɨ ausaapɨ kaundɨtaatɨwo. ");
INSERT INTO agm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Saiwɨ kiya sangi nasamaasi nuwɨ itɨhɨsatɨwɨ nasapuwɨtaatɨwɨ pɨwɨha waapɨhɨsasaihɨ sahɨ pɨwɨha maahɨwa napitɨtaatɨ kaundɨtɨhaawe tɨwɨ awaindɨhandɨ wɨndɨ gɨmunyaapɨse. Sahɨ katɨtaatɨwɨhura tɨmetanɨhɨ pɨwɨha katɨtaatɨwɨha samɨ Japɨho Autaahaatɨho netɨ gɨsunyaitaise. ");
INSERT INTO agm_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Iyataatɨ pɨwɨha samɨ maahomwaaŋapɨ katɨtaatɨwɨha samɨhaametɨtaise. Owetise. Samɨ Japɨhomɨ Itɨpɨho samɨ maahomwaaŋɨ netɨ pɨwɨha sapɨ nanɨpimatɨ katɨtaise. Isɨ sahɨ awaindɨhandɨ yaiwɨ wɨndɨ gɨmunyaapɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Iyataatɨ nɨngi maarɨho naninyawɨ nisɨ otɨpɨpatɨ kaniwɨ nanipinjohiyɨhiyai sawanaamɨ naisɨhiya sawitaapo. Isɨhiya sawanaamɨ saahosaingoyai usa isɨhiya timaitaatɨwɨ nusepaitaapo. Aisaihɨ amɨ saniya sapiya kiyaamɨ mwaayamaatiyai satɨ katɨ naasaipitɨ kawitaapo. Aisaihɨ amɨ nisapɨ gɨnunyaahohiyɨhiya saniyasapiyai mwaayamaatiya mandɨtɨwiwɨ ahosumwapɨ isɨhiya usa tiworisai nusepaapɨ kiyaamɨ ikwɨraatɨhɨ numwisaihɨ timaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Saiwɨ nisapɨ satɨwɨ isɨhiya nahatiya sangi mandɨtɨpɨsitaapo. Amɨ saiwa kasisaihɨhandɨ kandɨ samɨ wowaatɨ biya andɨtita bitopɨ notaataahɨ asisɨha ipotɨhetɨ biya jinjahɨra bimɨtandɨhandɨ naitaise. ");
INSERT INTO agm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nɨnɨ akɨtɨnɨhɨ sangi kasatataato, sahɨ Isɨraherɨhiyaamɨ aunahɨpɨhaiwaara wɨndɨ gaamapɨ otɨpɨpatɨ kaimɨ nuwɨ sangɨ owemasaihɨhura Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ jahɨra napɨto. Nisɨ napɨtandɨhura detɨsɨ aunahɨpatɨ wuwanɨnɨhɨ nuwɨ nandaahohɨpata mɨhotɨwɨmapɨ bɨmisotɨwɨse. Aunahɨpitɨ sataahiya sangi tɨsapɨ mwɨsapɨ naaŋɨhaiwa nasamisaihaahɨ kapɨhɨ namasi amɨ wɨtaahapɨ sahɨ yanɨhɨmapɨ nisɨ pɨwɨha nanesi kaundɨtaatɨwɨ nuwɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Iyataatɨ utaaho wo komɨ kataunjisɨhomɨhatɨhɨ asɨmwaatɨtɨhɨ bindata mmona nesɨho komɨ kataunjisɨhoai wɨndɨ nusatipɨha daahemwahomaahe. Amɨ utaaho woaisangi wo awaisɨhomɨ otɨpɨpatɨ nawɨho owehandɨ nehɨ kawisataaho komɨ awaisɨhoai wɨndɨ daahemwa namusatipɨhaahoe. ");
INSERT INTO agm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Saisɨ kiya mmona nesɨho komɨ kataunjisɨhomatiya noaipaitandɨ maarɨho biya witane. Iyonɨhɨ amɨ utaaho awaisɨhomɨ otɨpɨpatɨhoaisangi komɨ awaisɨhomɨhamwaaŋɨ noaipataataahɨ gaare. Aisɨ amɨ nɨnɨ samɨ awaisɨhonɨhi itɨpɨho maipɨhaiwaamɨ awaisɨhomɨ ambɨpatɨ Bwaasɨrɨhɨraŋe ndawaatowɨ amɨ sangisaahɨ apɨpaahɨ ambɨpa maipɨhaiwa nasoaasawɨ kasatɨtaapo,” nyatatɨ Jisaasiho komɨ aposerɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Sanyatatosa nyangi sanyatataase, “Nisɨ otɨpɨpatɨ kaiwɨ nisɨ pɨwɨha gaahaiwa isɨhiyai sahɨ kaundohɨwaiwa sɨhɨhura Autaahaatɨhomɨ ndɨhetɨ ausaimanɨndaise. Iyatɨ isɨhiya maipɨhaiwa sangi kasisohɨwaiwaisangi amɨ sɨhɨhura Autaahaatɨhomɨ ndɨhetɨ ausaimanɨndaise. Isɨ sahɨ kiyaapɨ yamaiwɨ nisɨ otɨpɨpatɨ nanɨhaiwɨ kaiwɨ daiwɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pɨwɨha nehɨ sawanaatangisaahɨ isɨhiyaapɨ noaatɨtɨ kasatonɨhɨ atiwɨ nehohɨwaiwa isɨhiya nahatiyai ausaapɨ otɨhaatɨ ndɨhetɨ kaundɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Iyawaawɨ sahɨ isɨhiya samɨ maarɨhoai wɨndɨ tɨmapɨ nehɨ samɨ ambɨpatisaahɨ tiwɨtaatɨwɨhiyaapɨ sahɨ wɨndɨ yamaiwɨse. Nehɨ Autaahaatɨho samɨ ambɨpatunɨ maarɨhounɨ ahoya maawɨ tiwa netɨ sisɨhaapɨhɨ tɨhoaitandɨhopaahɨhɨ yaiwɨse. ");
INSERT INTO agm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Iyataatɨ koho apɨpaahɨ gwɨharaahasɨnya isɨhiya wɨndɨ napaitɨwɨ tusɨhanɨwɨ namaitaapo. O tusɨhanɨwɨ yahurɨ newaawaahɨ surapɨ nawɨho nehɨ njisɨho tɨhwɨnɨpɨhohɨhɨ naitaapo. Isɨhiya siyauhɨhandɨ kandɨ amɨ Autaahaatɨho sasɨnya koho gwɨharaahasɨnyai biya wisatataise. Siyatɨ iwinjaatɨ bindataisɨ kohɨsɨnyaamɨ wo nehɨ nɨwipɨhandɨ wɨndɨ yapɨpataapɨhɨ tɨmaamɨhaitaise. Autaahaatɨho sawaho tɨmahiyane tonaahɨhɨ tɨmɨhaitaise. ");
INSERT INTO agm_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Iyataatɨ koho gwɨharaahasɨnyaisɨsɨ iwinja bimisɨ amɨ sangisaahɨ autaahɨ wamwaaŋɨ komɨ apohɨpataatesama jainja bindataise. Isɨ sahɨ yamaiwɨse. Iyataatɨ amɨ sahɨhɨ samɨ mɨsisɨhaisangi napitiyatɨ ahendaise tatɨ Autaahaatɨho awɨtatɨ aimɨ jasose. ");
INSERT INTO agm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Utaaho itapaatɨ wowaatɨ komɨ kaatamɨ maahomwaaŋɨ nausaatɨ isɨhiyaamɨ ndɨhetɨ ausaatɨ nɨnɨ Kɨraisihomɨhonɨne nɨnɨ Kɨraisihomɨhaanɨne tisɨhoai tisaamaati amɨ nisangi nisɨ Apɨho yamɨhapataatɨhɨ bimisɨhomɨ ndɨmaahomwaaŋɨ koai kaati awusaito. Saindɨ so nisɨhoe saatɨ nisɨhaate undɨtɨ nisɨ Apɨhoai kaundɨto. ");
INSERT INTO agm_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amɨ utaaho itapaatɨ wowaatɨ komɨ kaatamɨ maahomwaaŋapɨ nausaatɨ nɨnɨ Kɨraisihomɨhonɨne maata Kɨraisihomɨhaanɨne maatisaamaati amɨ nisangi satɨ katɨ kaindɨ nisɨ Apɨhomɨ ndɨmaahomwaaŋɨ wɨndɨ amaawusaito. Saindɨ nisɨ Apɨhoai so nisɨhoe saatɨ nisɨhaate undɨtɨ wɨndɨ kamundɨto. ");
INSERT INTO agm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Sahɨ wɨndɨ nisapɨ saiwɨ gɨmunyaapɨse, ko nyahɨ napaisaatɨ pɨwanna tɨmuna bimɨtɨhaahandɨ yapɨpataapɨhɨ nesi nasahoe tɨwɨ gɨmunyaapɨse. Owe. Nɨnɨ sahɨ napaisaatɨ pɨwannɨwɨ bimɨtaatɨwɨhandɨ nesi napɨtɨhonɨnɨmaahe. Namatana pwɨsɨpɨyaipa nesi napɨtɨhonɨne. ");
INSERT INTO agm_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Iyataatɨ nɨnɨ mwaaya sapiya maatiya saniya saisa saisatoya ahosɨmatɨwɨ itɨhɨnnɨwɨ tunnɨwɨ tipɨtapaatɨwɨ nopɨsasɨndaatɨwɨhandɨ nesi napɨtɨhonɨne. ");
INSERT INTO agm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Iyataatɨ utaaho wo nɨngi komɨ maarɨho naninya nanipinjisɨhoai sawahomɨhiya saniya sapiya saingosaahoya sanaanisa sanaapwɨsa apɨpaahɨ awaindɨhandɨ mɨmaipɨwiwɨ ahosumwaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Amɨ utaaho wo saniya sapiyaisaahɨhɨ komɨ maarɨho awaindɨhandɨ nunyataatɨ nɨngi wɨndɨ biyatɨ namaanɨmiso so nisɨ maarɨho wɨwihohɨtɨhandunɨ gaahaiwaunɨ namaitaise. Iyataatɨ amɨ utaaho wo komɨ mwaaya maatiyaisaahɨhɨ maarɨho awaindɨhandɨ nunyataatɨ nɨngi wɨndɨ biyatɨ namaanɨmiso so nisɨ maarɨho wɨwihohɨtɨhandunɨ gaahaiwaunɨ namaitaise. ");
INSERT INTO agm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iyatɨ amɨ utaaho wo satatɨ naaŋɨhaiwa wɨndɨ nametɨ wɨndɨ namaapwɨtaano tatunyaatɨ saiwa ipɨ tɨtɨhɨ atawɨhatamatiya netɨ tɨmaapwɨtatɨ nisɨ kaindɨ daayohɨrɨhɨretɨ maaninjapepihɨrataataahɨ soai nisɨ otɨpɨpatɨ kanisatɨ nanetɨ nanipinjɨtandɨ nɨnɨ wɨndɨ namumwaito. Owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Iyataatɨ amɨ utaaho wo maapɨ komɨ ambɨpatapɨhaiwaapaahɨhɨ andɨtatɨ napamasɨho ko nɨngisatɨ jinjapɨhɨ bɨsotɨtandɨhandɨ ko wɨndɨ namaitaise. O amɨ utaaho wo maapɨ komɨ ambɨpatapɨhaiwai ahosumwa nisɨhaiwaapaahɨhɨ andɨtatɨ napamasɨho so nɨngisa biya jinjapɨhɨ bimɨtandɨhandɨ ko naitaise. ");
INSERT INTO agm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Iyataatɨ isɨhiya usa sangi napaitɨwɨ maarɨho wɨsaipɨ nasamaapɨ nisɨ pɨwɨha sahɨ ausaahohɨha atɨsisaihaahɨ nisangi satɨ katɨ kanisawaayopo. Iyawaawɨ amɨ saiwɨ napaitɨwɨ maarɨho wɨnipɨ nanɨmaawaawaahɨ satɨ katɨ kaiwɨ nɨngi natanoaasisɨhoaisangi numwaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Iyataatɨ utaaho wo Autaahaatɨhomɨ pɨwɨha atisa nesi napisɨho pɨropetɨhoai Autaahaatɨhomɨ pɨwɨha nesi nasahoso tatɨ komɨ aŋaaŋɨ numwaatɨ nandapa nunyatɨ iwɨtatamanataataahɨ amɨ Autaahaatɨho komɨ pɨwɨha atisatɨ nusesi napisɨho pɨropetɨhoai numwiwaiwaamɨhaiwa koaisangi naitaise. Iyataatɨ amɨ utaaho wo utaaho tɨtɨhɨ gaaho woai tɨtɨhɨ gaahoso tatɨ komɨ aŋaaŋɨ numwaatɨ nandapa nunya iwɨtatamanataataahɨ amɨ Autaahaatɨho utaaho tɨtɨhɨ gaahoai numwiwaiwaamɨhaiwa utaaso soai Autaahaatɨho numwɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Isɨ kɨmandɨ baiwɨ gwɨnyaapɨse, utaaho wo nisɨ isɨhiya nɨngi nanipinjohiyɨhiya usa ambɨpatɨ owehiyaamɨ woai nisapɨ gɨwunyaataatɨ so Jisaasihomɨhiyaamɨhoso tatɨ gaahandɨ apɨpaahɨ turɨkaarehonjisangi kawisataataahɨ soaisangi amɨ Autaahaatɨho siyohiyɨhiyaapɨ gaahaiwa tɨmaŋa ahɨwiwaiwa kopɨhapa apɨpaahɨ akɨtɨnɨhɨ naitaise,” nyatatɨ Jisaasiho komɨ otɨpɨpatɨhiyaanangi kanyatatɨ osasepɨhaataise. ");
INSERT INTO agm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aihɨ Jisaasiho komɨ otɨpɨpatɨhiyaanɨ aposerɨhiyaanangi pɨwɨha wɨnɨhɨnyata kanyatiwaiwa katatɨ owematosatɨ otɨpɨpatɨ kaitɨhaawɨ nyangisɨ natanyoaasataise. Natanyoaasamapɨ sapɨhɨ namasi kapɨhɨ aunahɨpɨhaiwa detɨ ahetiwaiwaara isɨhiyai kataunja pɨwɨha ausaitandɨ daimɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aihɨ Jonɨho Isɨhiyai Baawusisɨho ko napwɨtatɨ bimimbɨpɨhapɨ Kɨraisiho otɨpɨpatɨ kaiwaiwaapɨ atisataise. Atisataatɨ komɨ otɨpɨpatɨhiyai Kɨraisihoenda koai wa nunjendaatɨwɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Natausaasihɨ nuwɨ noaipapɨ Jisaasihoai saundɨwɨ nunjenawaayopo. “Kɨnyɨ Jonɨho satatɨ Autaahaatɨhomɨ gaahaiwa watɨpɨhaiwa isɨhiyai iwɨtatamaŋɨtandɨhaiwa nesi napɨtaise tisɨhoŋɨ koŋo? E wopɨ nyahɨ jatɨtɨhaawo?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Saundɨwɨ nunjenɨhauhɨ Jisaasiho komɨha sata kaundataase, “Kahapaamapɨpa nɨnɨ kandɨ kiyonɨhɨ sahɨ taawɨ atiwɨ mmonɨhowɨmaiwa kɨmaiwaapɨ jahɨra nuwɨ Jonɨhoai kaundɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Isɨhiya ndɨha maipɨta asɨhatahiyai nɨnɨ nusorɨhaahonɨhɨ jahɨra nga jawaayopo. Aindɨ isɨhiya ikwauhɨrɨ ambɨpatɨ bɨwatetɨ napohiyai nisɨ watɨpɨhandɨ nunyatɨ andɨtɨwihonɨhɨ gaawimainjɨhɨ jahɨra dosi daayawaayopo. Aindɨ isɨhiya asaaha pɨsapɨpaisahiyai kapa nemwahonɨhɨ ambɨpatɨ gaahatɨ nusoaipataise. Aindɨ isɨhiya atihɨrɨ nɨwisapwinjɨhɨ atɨhomisohiyɨhiyai nurɨwatahonɨhɨ atisawaayopo. Aindɨ amɨ isɨhiya aimɨ napomahohiyɨhiyai anɨmwaahɨpatombɨ jahɨra gandɨ numwaatɨ nisɨ maarɨho dɨtɨhɨrɨ nunyonɨhɨ nepawaayopo. Aindɨ amɨ isɨhiya jamaamaŋɨnɨwɨ taanahiyɨhiyai kiyaisɨ Autaahaatɨho kahapaamapɨpa gaahaiwa kawitandɨhaiwaapɨ pɨwɨha ausaatɨ kaundataato. ");
INSERT INTO agm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Iyataatɨ utaaho itapa wowaatɨ nisɨ kiyohɨwaiwaapɨ atisa mmonataatɨ ko kaatɨ gwɨnyapesɨrɨhɨretɨ kamaisanɨhandɨ kandɨ ko kaatɨ nisapɨ gɨnunyaasɨtɨhandɨ namaamataataahɨ gaasɨ maaritane,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aihɨ Jonɨhomɨ otɨpɨpatɨhiya atiwɨmapɨ sapɨhɨ namasi taawɨ niyauhɨ isɨhiya wɨrisandiwɨ niyohiyɨhyai Jisaasiho Jonɨhopunda saundataase. “Sahɨ isɨhiya iwɨwɨrɨho owehapɨhɨ Jonɨhoenda niyohɨtɨndɨ napaamapa mmondaatɨwɨ niyopo? Utaaho wo komɨ maarɨho kɨpwɨnatɨ pɨwɨha sawaho gwɨnyapesɨha kamaatatɨ nehɨ isɨhiya atitaatɨwɨ maaritohɨrɨhɨretɨ awaatɨpɨho itɨpɨho netɨ ahoaihɨ notɨ nasataisɨhomatiya pɨwɨha katatɨ notɨ nasataihɨhoai iwinjaita nowaayowo? Owetise. ");
INSERT INTO agm_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Owetanaahɨ napaamapaapɨ niyopo? Utaaho apotɨhɨrɨ gaahɨrɨ watɨpɨhɨrɨ otiwa kaumbwaahɨrɨ niyotɨ bitosɨhoai iwinjaitaatɨwɨ nowaayowo? Owetise. Isɨhiya saiwɨ apotɨhɨrɨ watɨpɨhɨrɨ gaahɨrɨ otiwa kambwaahɨrɨ niyopɨhiyaahɨ awaisawɨhiyaisawɨ awaisawɨhiyaamɨ aŋɨpɨpɨhɨ bimopo. ");
INSERT INTO agm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","O sapaisangi owetanaahɨ akɨpɨpa napa mmondaatɨwɨ niyopo? Autaahaatɨhomɨ pɨwɨha atisa netɨ ausaasɨho pɨropetɨho wo sapɨhɨ bitosɨhɨ koai iwinjaitaatɨwɨ nowaayowo? Ye akɨtɨnɨhe. Akɨtɨnɨhɨndaatɨ Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya pɨropetɨhiyai nusatipɨhaatɨ sawahopɨ kiya katohɨwaiwa akɨwaiwema kiyatɨ mmonatɨ amɨ sawahoaisangi noaipatɨ Autaahaatɨhomɨ pɨwɨha atisa netɨ ausaasɨho pɨropetɨhoematataise. ");
INSERT INTO agm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iyataatɨ pɨwɨha kaiwa kiya katohɨwiwaamɨ netɨ akaahemasɨha Jonɨho sawahopɨ wa sata jɨpatɨpindataise. Iyataatɨ Autaahaatɨho sandaase: ‘Nisɨ pɨwɨha nisiho kɨmbɨhɨ kɨmore. Kɨmosɨ kinyɨ daihɨra daahuwatɨ nuwa gisapwaitandɨ kinyɨ jɨhɨ koaisɨ nɨnɨ netɨ nandusaasɨto,’ tatɨ Autaahaatɨho kandaase tatɨ jɨpatɨpindataise. ");
INSERT INTO agm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Isɨ kɨmandɨ nɨnɨ kasatɨtandiyonɨ baiwɨ gwɨnyaapɨse. Jonɨho Isɨhiyai Baawusisɨho nɨnɨ otɨpɨpatɨ kaitandɨhura tɨmetihɨ noaipatɨ nisɨ daihɨra daanusɨhondaatɨ isɨhiya yapɨpatambɨhiya nahatiyai nusatipɨhaahore. Siyatɨ isɨhiya nahatiyai nusatipɨhaahotihɨhandɨ kandɨ isɨhiya nisɨhetapɨ Autaahaatɨho iwinjatisawɨhiyaamɨ utaaho wo yatɨhɨ otɨtɨhapɨho Autaahaatɨhomɨ gaahaiwa asakiyatɨ mmonatɨ netaatɨ kandaahɨ Jonɨhoai nusatipɨhaahore. ");
INSERT INTO agm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Aihɨ Jonɨho dotɨ komɨ otɨpɨpatɨ namasatɨ isɨhiyai saundatɨ, ‘Autaahaatɨho komɨ Mwaahoetapɨ sangi jainja bimɨtandɨ kɨmo nasatɨ detɨndaise,’ undisuraapɨ Autaahaatɨho isɨhiyai iwinjatindɨhandɨ watɨpɨtatɨ waatɨ topɨtaata noaipatɨ awaindɨ gwɨnyanɨmɨ napinjatɨ wanɨ kɨmuraisangi taatɨ gwɨnyanɨmɨ notaise. Aihɨ isɨhiya watɨpɨhiya mwɨtetɨwɨ tipɨndɨnanɨwɨ nipinjanɨwɨ Autaahaatɨho isɨhiyai iwinjatindɨhandaatɨhɨ nandaapɨ kandi maaritɨwɨ namaŋɨndɨwɨ newaayopo. ");
INSERT INTO agm_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Iyataatɨ amɨ Mosesihomɨ pɨwɨha wɨnɨhapɨpaunɨ amɨ Autaahaatɨhomɨ pɨropetɨhiya komɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaamɨhaunɨ Autaahaatɨho nasatɨ nisɨhetapɨ iwinja bimɨtandɨ gwɨnyaatɨ tɨmaniwaiwaapɨ jatataatɨ ausaataise. Ausaatɨ katɨmɨ nasatɨ Jonɨho noaipatɨ otɨpɨpatɨ kiyataatɨ kaiwaisɨ netɨ namasatɨ akɨwaiwematɨ ausaasurandaise. ");
INSERT INTO agm_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Isɨ Mosesihomɨ pɨwɨhaunɨ Autaahaatɨhomɨ pɨropetɨhiya pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaamɨ pɨwɨhaunɨ sahɨ atɨwitaatɨwaahɨ pɨwɨha satatɨ, ‘Awaisɨho napɨtandɨ asisɨha detɨtanɨhɨ Eraijaaho jahɨra jɨhɨ nasatɨ komɨ daihɨra daawuwɨtaise,’ tisɨha atitaapo. Atisawaawɨ Jonɨhopɨ Eraisaahomatiyahore tɨwɨ sahɨ gwɨnyapendaapo. ");
INSERT INTO agm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sahɨ samɨhandisɨ pɨwɨha kɨma atiwɨ naitaatɨwaahɨ atiwɨ nepɨse ");
INSERT INTO agm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Amɨ isɨmiya baiwɨ atɨhomiwɨ gɨmunyaapɨ wanɨ kɨmuraapɨmiyaapɨ nɨnɨ napitɨtɨtande? Gaasɨ namatɨ satɨtaano. Kiya manyinya nanɨhaiwɨ bindawaawɨ ikwaatɨpɨhoaatɨhɨ isohiyɨhiyaamataiwɨhiye. Iyawaawɨ usa sasaahoya usai saundohiyɨhiyaamatiyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nyahɨ apwɨtɨhɨrɨ etɨtaatiyaatɨ ipohaayo. Siyaatɨ ipohonɨhɨ sahɨ nyangisawɨ maaritɨwɨ wɨndɨ waipwaapɨ namaawesɨnɨhopo. Iyaatɨ amɨ nyahɨ etɨtaatɨtaatɨ awirɨhɨrɨ awirɨtonɨhɨ sahɨ nyangisawɨ maarɨho asɨpaiwɨ wɨndɨ gomaatopo,’ nnɨwɨ kanohiyɨhiyaamataiwɨhiye. ");
INSERT INTO agm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Siyatɨ sɨrɨ kɨretɨ Jonɨho Isɨhiyai Baawusisɨhoaisangi noaipatɨ jinjahɨra nandapa namaanatɨ onaaya amɨ waapoho watɨpɨho wainɨhandɨ wɨndɨ namaanataise. Namainjɨhɨ isɨhiya kopɨ satawaatopo, ‘Ese utaamo kɨmo koai apɨpaahɨ wipetahosɨ wapa itɨpɨho maipɨhapa nɨwɨndaataise,’ tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Iyawaawɨ amɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ noaipatɨ nandapa onaamaindɨ jinjahɨra nandapa waapoho wainɨhandɨ nanɨhonɨhɨ isɨhiya nisapɨ satawaatopo: ‘Ese utamo kɨmoai iwinjasapewɨse. Nandapa gwɨsɨha taupwɨmatɨ nipinja nanatɨ waapoho watɨpɨho naharitaatɨwɨho pɨhɨta nanahore. Iyatɨ isɨhiya apɨpaahɨ maipɨhiya nawɨho takisihandɨ newaawɨ katɨhapɨ sawanaapɨho nawɨho ikonɨhohiyɨhiyaisatunɨ amɨ isɨhiya kiyaamɨ usaisa ahoyana pɨwanna daaya bitondaise,’ tawaatopo. Satɨwɨ sahɨ saiwɨ manyinya nɨnɨ katohiyɨhiyaamataiwɨhiyaate. Iyawaahandɨ kandɨ ipotɨhura sahɨ mmonawaawɨ yɨhoaanyamɨ otɨpɨpatɨ kiyohɨwaiwetapɨ akɨpɨpa noaipahonɨhura sahɨ yɨhoaanyapɨ satɨtaapo: ‘Kurɨ kuramɨ otɨpɨpatɨ kaiwaiwa tɨtɨhɨ Autaahaatɨhomɨ gwɨnyapesɨrɨhɨretɨ akɨtɨnɨhɨ kiyamaise,’ tɨwɨ mmondaapo,” undatɨ Jisaasiho isɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Saundatosatɨ Jisaasiho isɨhiya aunahɨpɨhaiwa komɨ watɨpɨhaiwa taahɨwaiwa kaihɨ kapɨhɨ kiyaamɨ maipɨhaiwaatɨhapɨ jahɨra Namepemaitohiyɨhiyaapɨ itɨhɨndaase. ");
INSERT INTO agm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Itɨhɨtatɨ sata kandaase, “Ese, Korasinɨhiyaatɨ amɨ Betɨsaitaahiyaate, sahɨ apɨpaahɨ maipɨhandɨ yaasatɨ naaŋɨhandɨ watɨpɨhandɨ naitaapo. O amɨ apaapɨmaato. Amɨ watɨpɨhaiwa taahɨwaiwa samɨhapɨhɨ samɨhatɨhɨ nɨnɨ kiyohɨwaiwa isɨhiya aunahɨpatɨ Tayaahandaahiya Saitonɨhandaahiyaamɨhapɨhɨ kiyaamɨhatɨhɨ saiwa kaisanaahɨ kiya jɨhɨ aimɨ ketɨ waatɨpatɨ tɨhoaamwɨtɨpatɨ nopɨ jaatɨwɨ yutɨha niyopɨ gwɨwɨ maarɨho asɨpaiwɨ kiyaamɨ maipɨhaiwaatɨhapɨ jahɨra nepemaitɨtauhe. ");
INSERT INTO agm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Isɨ sahɨ baiwɨ kɨmandɨ gwɨnyaapɨse. Asisɨha isɨhiyai netɨ tipɨtapaitandɨhura Autaahaatɨho isɨhiya Tayaahiyaisunɨ Saitonɨhiyaisunɨ yaawatɨ naaŋɨhandɨ yatɨhɨ wamwaaŋɨ nunyataatɨ amɨ sangisɨ apɨpaahɨ awaindɨhandɨ nasamɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Amɨ sahɨ Kapaniyamɨhandaahiyaate, sangi Autaahaatɨho maarita autaahesamaitaiso? Owetɨtaise. Kohɨ sisɨhaapɨhɨ netɨ yasotɨtaise. O napaapono? Amɨ watɨpɨhaiwa nɨnɨ samɨhapɨhɨ kiyohɨwaiwa isɨhiya aunahɨpatɨ Sotomɨhiyaamɨhapɨhɨ kaisanaahɨ kiya kiyaamɨ maipɨhaiwaatɨhapɨ jahɨra nepemaitɨwɨ wɨndɨ owemetɨwɨ wanɨ kɨmura bimɨtauhe. ");
INSERT INTO agm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Isɨ sahɨ baiwɨ kɨmandɨ gwɨnyaapɨse. Asisɨha isɨhiyai netɨ tipɨtapaitandɨhura Autaahaatɨho isɨhiya Sotomɨhiyai yaawatɨ naaŋɨhandɨ yatɨhɨ wamwaaŋɨ nunyataatɨ amɨ sangisɨ apɨpaahɨ awaindɨhandɨ nasamɨtaise,” tatɨ Jisaasiho isɨhiyaapɨ itɨhɨndaase. ");
INSERT INTO agm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Isɨhiyai saundatɨ namɨhaatosatɨ Jisaasiho sandaase. “Apore, yamɨhapatɨ yapɨpatamɨ Awaisɨhonye, kinyɨ gwɨnyapehingɨwaiwa isɨhiya yapɨpatambɨ amɨtɨha awaisɨhaisahiyaapɨ nepɨ noaasapɨ isɨhiya manyinyaamataiwɨ nanɨhaiwɨhiyai nepɨ nunjinɨhɨ kandapɨ nɨnɨ gisɨ, ‘gaare, gaahoŋe,’ hɨtataato. ");
INSERT INTO agm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ye, akɨte apore, sandɨ saingɨtɨmandɨ kɨwahonyɨ gwɨnyapepɨ saitaano tɨpɨ maaritingɨtɨhanda kiyapaise,” ndaase. ");
INSERT INTO agm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Satatosatɨ amɨ sandaase, “Apɨho komɨ gwɨnyapesɨwaiwa nahatewa nanɨsatɨ aimɨ nɨngi naninyataise. Utaaho wo mambɨho Autaahaatɨhomɨ Mwaahonɨnɨhi wɨndɨ biyatɨ maanose. Nehɨ nisɨ Apɨho Sawahohɨhe. Iyataatɨ amɨ utaaho wo mambɨho nisɨ Apɨhoai wɨndɨ biyatɨ mausose. Nehɨ nɨnɨ Komɨ Mwaahonɨnɨ nɨwahonɨnɨhe. Nɨwahonɨnɨndaatɨ amɨ isɨhiya usaisɨ nɨwahonɨnɨ maaritɨtɨ gwɨnyaahohɨtɨhanda nisɨ Apɨhoai kiyaisɨ netɨ nunjisanɨhiyaahɨhɨ usondaapo. ");
INSERT INTO agm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Isɨhiyaatɨ sahɨ wapa kahapaamapɨpa naaŋɨhapa wɨrapɨ isɨpɨ daayawaawɨ samɨ gwɨnyaahohɨtɨhandɨ maarɨho ambɨpatɨ nepɨ nopɨsasɨnɨwɨ naaŋasisa nasɨrapetisawɨhiyaate, nɨnɨ sangi ikɨndaatɨwɨhandɨ nasamɨtaanɨ sahɨ nahatiyaatɨ nɨngisenda napɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Napɨwɨ nisɨ kandɨsasohɨwaiwa otɨpɨpatɨ nepɨ sawanaatamɨhetemapɨ amɨ nisɨhetapɨ kaiwa mmowɨ kaiwɨ nepɨse. O napaapono? Amɨ nɨnɨ utaahonɨnɨ napaisɨhonɨnɨ nisɨ maarɨhoaatɨhɨ yatɨhɨ ipatisanɨtɨhonɨnisɨ amɨ sahɨ nisɨhetapɨ ikɨndaatɨwɨhandɨ naitaapo. ");
INSERT INTO agm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Amɨ nɨnɨ kandisasohɨpɨpa sapa usaayɨhapaasɨ sahɨ nga samɨ ikotɨhaasɨnɨ tɨpwɨtɨtaapo, amɨ sahɨ isɨwɨtaatɨwɨ nasanyohɨpɨpa usaayatɨ wɨndɨ naahomaaŋɨhapaasɨ sahɨ nanɨhaiwɨ nga isɨwɨtaapo,” ndaase. ");
INSERT INTO agm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Aihɨ asisɨha wanya sanaihɨ Judaahiyaamɨ asisɨha ikɨndaatɨwɨha Sapaatɨhandetɨ (Saararehura) Jisaasiho komɨ otɨpɨpatɨ mmowɨ nepɨ kaiwɨ nuwipinjohiyɨhiyaisatɨ osaataatɨhɨra taawɨ nowaawɨ komɨ otɨpɨpatɨhiyai jaumanataise. Siyatɨ jaumwasɨhɨ kiya kapɨhɨ osaataatɨ witɨhandɨ nandapa kɨpwɨwɨ iwatopɨ nepɨ nanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iyauhɨ Parisihiya kiyai iwinjaposawɨ Jisaasihoai saundawaatopo. “Jasapeme! Kɨmandɨ kinyɨ otɨpɨpatɨhiya kiyohɨtɨmandɨ nyahɨ Judaahiyaanamɨ wɨnɨhapɨpa sehɨmwaapɨ asisɨha ikɨndɨhaaha Sapaatɨhandɨ nepɨ nanyopɨsasɨwɨhandɨ kiyawaayopo,” undɨwɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Saundauhɨ amɨ Jisaasiho Parisihiyai komɨha sata kaundataase. “Amɨ sahɨ Daawitɨhounɨ komɨ isɨhiya naisɨhiyaunɨ jaumwasɨhɨ kaindɨhandapɨ apɨpaahɨ wɨndɨ awɨmɨtɨwɨhiyaatɨtamatɨtawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jaumwasɨhɨ Daawitɨho komɨ isɨhiyaisa Autaahaatɨhomɨ aŋɨ awaindɨhandaatɨhɨ nandaatɨ nandapa bɨretɨhandɨ Autaahaatɨhomɨ ndɨhetɨ ahotɨtandɨ ahiyohɨha pɨrisihiyaamɨ mɨtɨho pɨrisiho nemwihɨ ko netatɨ komɨ isɨhiyai neunyatɨ nainje. Iyataatɨ sapa nandapa bɨretɨndapɨ wɨnɨhapɨpa watɨpɨhapa satatɨ, ‘Nehɨ pɨrisihiyaahɨhɨ nandaatɨwɨhande,’ tatɨ ahotahande. Siyatɨ wɨnɨhapɨpa ahotihɨhandɨ kandɨ jaumwasɨhiyataatɨ kapa netɨ nopɨsasatɨ Daawitɨho nandapa bɨretɨhandɨ komɨ isɨhiyai neunyatɨ nainje. ");
INSERT INTO agm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Aisɨ amɨ pɨwɨha waisangi Mosesihomɨ wɨnɨhapɨpaatɨhɨ ahotisɨha sahɨ apɨpaahɨ awɨmɨtɨwɨhiyaato? Pɨwɨha siyahaapɨto, asisɨha ikɨndaatɨwɨ Sapaatɨhaiwa nahatewetɨ pɨrisihiya Autaahaatɨhomɨ aŋɨ awaindɨhandaatɨhɨ otɨpɨpatɨ kiyawaawɨ asisɨha ikɨndaatɨwɨha (Saararehura) Sapaatɨhandamɨ wɨnɨhapɨpa nepɨ nopɨsasopo. Nopɨsasawaahandɨ kandɨ pɨwɨha naaŋɨha kiya wɨndɨ namehopo. Autaahaatɨho kiyaisɨ nehɨ nanɨhiyatɨ iwinjase. ");
INSERT INTO agm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Siyauhɨ amɨ wanɨ kɨmbɨhɨ samɨhatɨhɨ nɨnɨ utaahonɨnɨ aŋɨ awaindɨhandisunɨ kandamɨ pɨrisihiya isɨhiyaapɨ otɨpɨpatɨ kiyohɨpatisunɨ awaindɨhandɨ daahemwatɨ nusatipɨhaatɨhonɨnɨ kɨmbɨhɨ kɨmonɨnɨ bitondaayo. ");
INSERT INTO agm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Iyataatɨ Autaahaatɨho komɨ pɨwɨha jɨpatɨpindisɨhaatɨhapɨ sandaase: ‘Nɨnɨ sahɨ isɨhiyai pɨhɨtɨwɨ iwɨtatamanɨwɨ maarɨho asɨpɨwitaatɨwɨhandapɨ pɨhɨndɨ maaritɨtɨ gwɨnyaataayo, amɨ sahɨ samɨ maasapɨho sipɨsipɨhandɨ kohasɨpɨho tipɨ jɨtɨpa nuhaapɨ sisandɨpapɨ gaarehandɨ nɨngi naninyohɨtɨhandapɨ wɨndɨ pɨhɨndɨ maaritɨtɨ gɨmunyaaho,’ ndaase. Isɨ amɨ sahɨ pɨwɨma kɨmaamɨ tanyaaha mmonawaawaahɨ isɨhiya ainahiyɨhiyai sahɨ wɨndɨ mɨmaipɨmaawitaapo. ");
INSERT INTO agm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sandɨ apaapɨmaato, nɨnɨ nɨwahonɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ asisɨha ikɨndaatɨwɨha Sapaatɨhandɨ ahiyohɨhonɨnisɨ kandamɨ Awaisɨhonɨne. Saindɨ nɨwahonɨnɨ Awaisɨhonɨnisɨ asisɨha Sapaatɨhandetɨ isɨhiya wapa kaitaatɨwɨhapa nɨnɨ nɨwahonɨnɨ jatataayo,” undatɨ Parisihiyai Kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sapɨhɨ Parisihiyai saundamapɨ Jisaasiho kiyaamɨ (sinekokɨhandɨ) aŋaaŋɨ pɨwɨhaapɨ ahoyanohɨtɨhandaatɨhɨ notɨ nandaataise. ");
INSERT INTO agm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aihɨ utaaho wo komɨ ikwɨrɨ bɨwateho sapɨhɨ bindataise. Bimihɨ Parisihiya Jisaasihoai saundɨwɨ nunjenawaayopo. “Judaahiyaanamɨ asisɨha ikɨnaatɨ awaindewaamaitɨhaahandɨ Sapaatɨhandetɨ (Saararehura) isɨhiya timbɨpaisahiyai tɨtɨhɨwiwawaawaahɨ wɨnɨhapɨpa Mosesiho Autaahaatɨhomɨ netɨ nanyamimbɨpa nepɨ nopɨsasawaayowo e owetiso?” undɨwɨ nunjenawaayopo. Sandɨ Parisihiya Jisaasihoai saundɨwɨ nunjenɨhohɨtɨndɨ komɨhetɨ pɨwɨha nepɨ yawutaapɨ ko siyahoe siyahoe tɨtaatɨwɨhapaapɨ daawaawe. ");
INSERT INTO agm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Saiwɨ nunjenɨhauhɨ amɨ kiyai Jisaasiho saundataase. “Amɨ samɨ woŋɨ kinyɨ maasapɨho sipɨsipɨhandɨ bitohoŋɨ amɨ kandɨ asisɨha ikɨndaatɨwɨha Sapaatɨhandetɨ anɨmwaahɨpatopɨ witonaahɨ noaitaino e owetɨtaiso? ");
INSERT INTO agm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Isɨ amɨ utaahohɨ Autaahaatɨhomɨ ndɨmaahomwaaŋɨ nehosɨ maasapɨho sipɨsipɨhandi daahemwahoe. Isɨ nyamɨ wɨnɨhapɨpa daihɨra wɨndɨ namaanyisapuse utaawo itapɨ waatɨ asisɨha ikɨndaatɨwɨha Sapaatɨhandetɨ netɨ nopɨsasɨnɨhonɨhɨ nyahɨ koai kaati newa iwɨtatamaŋɨtɨhaahandapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Saundatosa amɨ utaaho komɨ ikwɨrɨ bɨwatesɨhoai Jisaasiho saundataase. “Kɨnyɨ kinyɨ ikwɨrɨ mbapɨ dɨhumwaŋɨme,” undataase. Undihɨ amɨ ikwɨrɨ bɨwatesɨho komɨ ikwɨrɨ mbatɨ dɨhumwasɨhɨ kɨrɨ ikwɨrɨ bɨwatesɨrɨhɨrɨ noaipatɨ gaahɨrɨta wihoaaŋɨhɨrɨ ainahɨhɨramatiya nonasayataise. ");
INSERT INTO agm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Siyatɨ sandɨ Jisaasiho gaahandɨ watɨpɨhandɨ kaihɨhandɨ kandɨ amɨ Parisihiya sapɨhɨ namasi nuwɨ Jisaasihoai sohoai tiwɨtaatɨwɨhandapɨ pɨwɨha tɨmanɨwɨ wɨsasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Koai sohoai tiwɨtaatɨwɨ pɨwɨha kanɨwɨ wɨsasohɨtɨndapɨ Jisaasiho mmonamapɨ sapɨhɨ aunahɨpita namasi notaise. Namasi naihɨ isɨhiya wɨrɨsandɨhandɨ timbɨpaisahiyaunɨ ainahiyɨhiyaunɨ koai nuwipinjawɨ komɨ pɨwɨha atɨwisawaayopo. Iyauhɨ timbɨpaisahiya koenda nasohiyɨhiya nahatiyai kiyaamɨ timbɨpa nemwa tɨtɨhɨwiwataise. ");
INSERT INTO agm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Iyatɨ isɨhiya wɨrɨsandimɨ koenda nasauhɨ kiyaamɨ timbɨpa nemwa tɨtɨhɨwisawɨhiyai saundataase. “Sahɨ nɨnɨ saiwa sangi kasɨsohɨwɨmaiwaapɨ isɨhiyai wɨndɨ ausaapɨ kamundɨwɨse,” unda bapiya kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Sandɨ Jisaasiho isɨhiyai tɨtɨhɨwisɨtɨhandapunɨ nisapunɨ ausaapɨ isɨhiyai kamundɨwɨse undindɨmandɨ apaapɨmaahe, jɨhura Autaahaatɨho komɨ pɨwɨha atisa netɨ ausaasɨho pɨropetɨ Aisaiyaahomɨ maahomwaaŋapɨ Jisaasiho sawahopɨ saitaise tatɨ katisɨha akaahemaitande. Iyataatɨ sa pɨwɨha Aisaiyaahomɨ maahomwaaŋapɨ Autaahaatɨho sata kandaase: ");
INSERT INTO agm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kɨmbɨhɨ kɨmo nisɨ otɨpɨpatɨhore. Nɨwahonɨnɨ ahɨwisonɨhore. Aindɨ utaaso so koai nɨnɨ maarɨho nunyatɨ amɨ nɨnɨ koai baindɨ maarɨho wɨwitɨhore. Maarɨho wɨwitɨhosɨ nɨnɨ koai andɨtɨwihonɨhɨ kaitandɨho nisɨ Itɨpɨho nesipɨtɨ numwaasaito. Numwaasasanɨhɨ amɨ ko isɨhiya nisapɨ atɨhomiwɨ gɨmunyaapɨ nisɨhiyaamɨ dawaataatɨ bimohiyɨhiyai kiyaamɨ maipɨhaiwaatɨhapɨ japɨhɨ nepemaitɨwɨ nisenda napɨwɨ gɨnunyaapɨ tɨtɨhɨ gaahiya noaipaitaatɨwɨhɨra daihɨra nanunjɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Iyataatɨ amɨ ko pɨwɨha utaarɨhandɨ isɨhiyaisatɨ pwɨsɨpataahamatiyatɨ tunatɨ wɨndɨ notɨ nasaya kamaatatɨ amɨ wɨndɨ kaahaamaatatɨ amɨ wɨndɨ pɨwɨha waapɨhɨta aunahɨpatamɨ daihɨra isɨhiya nasisoaarɨ ahoyanɨhohɨppɨpɨhɨ wɨndɨ nonasaya ngotɨ otita kaahaamaatɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Iyataatɨ isɨhiya apwɨtɨramɨ detɨho apɨpaahɨ tɨwatainjɨhomataiwɨ kiya wɨndɨ andɨtɨmitɨwɨ isɨhiya usa kiyaamɨ tiworisaunɨ utaaho yapɨpatambɨ maipɨhounɨ kiyai nepɨ nusopɨsasɨwɨ tipɨ urɨpatisauhɨ kiyaamɨ maarɨho owetihɨ napwɨtaatɨwiyohiyɨhiyai nisɨ otɨpɨpatɨho kiyaamɨ maarɨho jahɨra netɨ tɨtɨhɨwiwɨtaise. Iyatɨ amɨ isɨhiya usa sisɨha norɨhɨrɨ tɨha tɨhwɨtimɨ notɨ otasaahanda niyotɨtandɨ nehɨmasɨhaamataiwɨ kiyaamɨ maarɨho nipɨtihɨ napwɨtaatɨwɨ nahɨriwɨ bimohiyɨhiyai nisɨ otɨpɨpatɨho kiyaamɨ maarɨho jahɨra netɨ wɨwiwatɨ tɨtɨhɨwiwɨtaise. Iyatɨ ko apɨpaahɨ andɨtitatɨ watɨpɨtatɨ nɨnɨ isɨhiya nahatiya tɨtɨhɨ gaahiya nisɨhiyaimatɨtaatɨwunɨ maipɨhaiwa nahatewa yapɨpatambɨ nematɨ ipɨhatindɨmaitandɨ gwɨnyaahohɨwaiwa akɨwaiwa noaipaitandɨ kaimɨ notɨ kaiwa noaipahonɨhuraatɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iyonɨhɨ isɨhiya yapɨhɨ nahatewaaraahiya nisɨ otɨpɨpatɨho atɨnisahopɨ ko nyangi japɨhɨ apɨpaahiyaanangi nanyamaito tɨwɨ kopaahɨhɨ gɨwunyaapɨ nammopɨ andɨtitɨwɨ jatɨtaapo,’ tatɨ Autaahaatɨho Aisaiyaahomɨ maahomwaaŋapɨ kandaase. ");
INSERT INTO agm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Aihɨ isɨhiya usa utaaho wo koai itɨpɨho maipɨho numwaatɨ komɨ ndɨha nɨwɨsotisɨhɨ wɨndɨ minja komɨ maahomwaaŋɨ netɨ nɨwisapusɨhɨ wɨndɨ pɨwaamaatahoai Jisaasihoenda numwaasi nasawaayopo. Iyauhɨ Jisaasiho so utaasometapɨ itɨpɨho maipɨhoai netɨ yota utaasomɨ ndɨha nusorɨhaatɨ maahomwaaŋɨ nɨwusaatɨ tɨtɨhɨwisɨhɨ ko jahɨra pɨwaatatɨ jataise. ");
INSERT INTO agm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aihɨ kapɨhɨ isɨhiya wɨrɨsandɨhandɨ ahoyanɨhohiyɨhiya sandɨ mmonawaawɨ apɨpaahɨ yaiwɨmapɨ Jisaasihopɨ satɨwɨ nasenawaayopo. “Ese, utamo kɨmo kɨmandɨ kaisɨ Daawitɨhomɨ Mwaaho Nyainja Bimɨtandɨhondaatete? Amɨ kometanaahɨ diyaamahotɨtaisono?” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Sanɨhauhɨ Parisihiya sandɨ atiwosawɨ kiya Jisaasihopɨ satawaatopo. “Ko itɨpɨho maipɨhaiwa netɨ yotindɨmandɨ nehɨ amɨ itɨpɨho maipɨhaiwaamɨ awaisɨho Bwaasɨrɨhɨrɨ koai watɨpɨhandɨ nunya andɨtɨwisɨhɨ saiwa kiyataise,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Satauhɨ Jisaasiho Parisihiyaamɨ gwɨnyaahohɨtɨhandɨ usonatosa kiyai saundataase. “Isɨhiya usa yapɨpatɨ naasaipitɨ kataahapɨhiya yapɨpatɨ namandipapɨ tipɨtapaatɨwɨ tunnɨwɨ kahapɨhɨ kahapɨhɨ ahoyanawaawaahɨ wɨndɨ kiya otɨhɨ bɨmimɨtaapo. Iyataatɨ amɨ aunahɨpatɨ wɨtɨsangi amɨ kɨretɨhiya nususasɨ wusasɨsangi nepɨ tipɨtapaatɨwɨ itɨhɨnnɨwɨ sawanaahandɨ tunawaawaahɨ wɨndɨ kiya tɨmaamaamaitɨwɨ nopɨsasɨnɨwɨ tɨmɨhaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Isɨ amɨ sɨrɨ kɨretɨ Bwaasɨrɨhɨrɨ iwinja bimisawɨhiya dopawɨ nepɨ yahwɨnɨwɨ tunawaawaahɨ nasɨpatawaayopo. Siyawaawɨ kiya wɨndɨ andɨtiwɨtɨ bɨmitoaitaapo. Owetɨtaise. Apɨpaahɨ tɨmahaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Iyataatɨ sahɨ nisapɨ satawaatopo, ‘Ko itɨpɨho maipɨhaiwa nemasɨtɨmandɨ Bwaasɨrɨhɨrɨ koai watɨpɨhandɨ numwihɨ saiwa kiyataise,’ tawaatopo. Isɨ amɨ kiyonaahɨ nɨnɨ sangi nasɨsendaano. Samɨ otɨpɨpatɨ mmowɨ nepɨ kaiwɨ nasipinjohiyɨhya itɨpɨho maipɨhaiwa nepɨ yotohɨtɨndɨ kiyai watɨpɨhandɨ ndɨ numwihɨ kiyawaayopo? Amɨ sangi nasipinjohiyɨhiya watɨpɨhandɨ nɨnɨ netɨ kiyohɨtɨmandɨ kandaahɨ kiya itɨpɨho maipɨhaiwa nemawaayowɨ samɨ pɨwɨha nisapɨ katohɨha sawanaatamɨhetɨ yasamwaitaise. ");
INSERT INTO agm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Autaahaatɨhomɨ Itɨpɨhohɨhɨ nɨngi watɨpɨhandɨ nanɨmihɨ kandaahɨ itɨpɨho maipɨhaiwa isɨhiyaamɨhetapɨ tahamanɨtɨ nemataayo. Saiwa saindɨ itɨpɨho maipɨhaiwa nɨnɨ nemahohɨtɨmandɨ Autaahaatɨho sangi jainjaatɨ bimɨtandɨhandɨ aimɨ nasatɨ samɨhatɨndaise satatɨ nasisataise. ");
INSERT INTO agm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Utaaho wo amɨ utaaho apɨpaahɨ watɨpɨhomɨ aŋaaŋɨ nehɨ nanɨhiya nawatatɨ nandaatɨ komɨ ikɨpɨpa wɨndɨ namusaitaise. Owetɨtaise. Nehɨ koai wɨrɨhɨra anɨtisa jɨhɨ wɨsasatosataahɨhɨ komɨ aŋaaŋɨ nawatatɨ ikɨpɨpa naitaise. Isɨ nɨnɨ Bwaasɨrɨhɨri daahemwa apɨpaahɨ watɨpɨhonɨnisɨ Autaahaatɨhomɨ watɨpɨhandaahɨ kɨrisɨ netɨ wɨsasatosatɨ kɨramɨ itɨpɨho maipɨhaiwai netɨ yondaayo. ");
INSERT INTO agm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Iyataatɨ utaaho wo nɨngisa tɨmaamaitɨha bɨmitondaataahɨ so nɨngi netɨ nipɨndataise. Iyatɨ amɨ utaaho wo nɨngi komɨ ikwɨrɨ naninya isɨhiyai nisenda numwaasi namaasataataahɨ so nisɨhiyaimatɨtaatɨwɨhiyai netɨ tahamana torɨwamataise. ");
INSERT INTO agm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Isɨ sahɨ baiwɨ atiwɨse. Isɨhiya kiyaamɨ maipɨhaiwa gɨmunyaatahaiwaunɨ maahomwaaŋapɨ sisɨpɨhɨtɨwɨ katohɨwaiwaunɨ nahatewa Autaahaatɨho nemwaitaise. Iyataahandɨ kandɨ amɨ isɨhiya usa Autaahaatɨhomɨ Itɨpɨhopɨ maipɨhaiwa gwɨnyapepɨ sisɨpɨhɨtɨwɨ pɨwɨha maipɨhaiwa katohɨwaiwa kaiwa Autaahaatɨho apɨpaahɨ wɨndɨ nemwaamaitaise. Owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Iyataatɨ amɨ isɨhiya usa nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonisapɨ maipɨhaiwa gwɨnyapepɨ sisɨpɨhɨtɨwɨ katohɨwaiwa Autaahaatɨho nemwaitaise. Iyataahandɨ kandɨ kiya Autaahaatɨhomɨ Itɨpɨhopɨ sisɨpɨhɨtohɨwaiwa Autaahaatɨho wanunɨ asisɨha ipotɨhetunɨ kaiwa wɨndɨ nemwaamahonɨhɨ kaiwaanɨhɨ ahotɨmɨ nutaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Undatosatɨ wa pɨwɨha saundataase. “Iyataatɨ isɨhiya ipatamɨ yandɨpɨho mmonɨwosawɨ ipatɨ satɨ gaahate satɨ maipɨhate tɨtaapo. Isɨ ipatɨ gaahatɨ yandɨpɨho gaaho ningotaise. Ipatɨ maipɨhatɨ yandɨpɨho maipɨho ningotaise. ");
INSERT INTO agm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Apɨpaahɨ akwɨranɨ tataapwɨnɨhomɨ mwaahatɨmaate sahɨ baiwɨ atiwɨse. Samɨ omaŋɨtɨtɨhɨ apɨpaahɨ maipɨhaiwaahɨhɨ tisaindahiyaatisɨ saiwa kaiwaahɨhɨ sahɨ katɨtaapo. O amɨ napaapono isɨhiya kiyaamɨ omaŋɨtɨtɨhɨ kɨpwɨndiwaiwa kaiwaahɨhɨ kiyaamɨ maahomwaaŋapɨ katɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Iyataatɨ amɨ uta ngaawo komɨ omaŋɨtɨtɨhɨ kahapaamapɨpa gaahaiwaahɨ gwɨnyapenatɨ netɨ osaiwaiwa kaiwaahɨhɨ kata kaitaise. Iyonɨhɨ amɨ utaaho maipɨho wo komɨ omaŋɨtɨtɨhɨ kahapaamapɨpa maipɨhaiwaahɨhɨ gwɨnyapenatɨ netɨ osaiwaiwa kaiwaahɨhɨ kata kaitaise. ");
INSERT INTO agm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Iyataatɨ nɨnɨ akɨtɨ kɨma sangi kasatataato ipotɨhura Autaahaatɨho asisɨha isɨhiyai netɨ tipɨtapaitandɨhetɨ isɨhiya nahatiya naasohɨ naasaamɨhɨ pɨwɨha nahata tanauhɨha kiyaamɨ katohɨhaapɨ naasa naasaahɨ awɨtɨwɨ Autaahaatɨhoai sa sata sataatɨ kato undɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Iyataatɨ amɨ sura Autaahaatɨho sawanaatamɨ pɨwɨha katohɨwaiwa kaiwa netɨ mmonatesi sasatɨtaise. ‘Sahɨ ainahiyɨhiyaate amɨ sahɨ maipɨhaiwaisawɨhiyaate satɨtaise,’” unda Jisaasiho Parisihiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Aihɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaamunɨ Parisihiyaamunɨ nehɨ usaahɨhɨ Jisaasihoai saundawaatopo. “Katɨpunjingɨhonye, nyahɨ kɨnyapɨ ko Autaahaatɨhoaapɨhapɨ nasahoe taatɨ gwɨnyaitaanɨ wɨtɨ sɨwipatɨ watɨpɨhatɨ nepɨ nanyise?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Undauhɨ Jisaasiho komɨha kiyai saundataase, “Sahɨ nisɨ kiyohɨwaiwa jinjahɨra mmonawaahandɨ kandɨ apɨpaahɨ maipɨhiyaatɨ Autaahaatɨhopɨ baiwɨ gɨmunyaapɨhiyaate. Saiwɨhiyaatisɨ sahɨ nɨngi sɨwipatɨ watɨpɨhatɨ nehɨ sawanaatamɨ ambɨpatapaahɨhɨ maaritɨwɨ mmowɨ namaitaatɨwɨhatapɨ nanyise ndɨwɨ nanɨsenawaayopo. Isɨ nanɨsehohɨpitɨ wɨndɨ sangi namaasasɨto. Nehɨ Autaahaatɨho komɨ pɨwɨha atisa netɨ ausaasɨho pɨropetɨ Jonaahoai kawɨsatɨ isɨhiyai sɨwipatɨ nunjipatamataindɨhatɨhɨ nasɨsɨto. ");
INSERT INTO agm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Saindɨ Jonaaho araiho awaisɨhomɨ gwɨsɨhaatɨhɨ asisɨha mairɨmaara nanotɨ nepasɨpatamataindɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨsangi saindɨ kaindɨ mɨhatɨhɨ apɨpaahɨ yapɨpatamɨ nyepepɨ nundɨ noaatɨpatɨ bimisanɨhɨ asisɨha mairɨma sananisonɨhɨ jahɨra nepaito. ");
INSERT INTO agm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Iyataatɨ Jonaaho isɨhiya Niniwehandaahiyai kiyaamɨ maipɨhaiwaapɨ Autaahaatɨho ahosumwa mandɨtɨwiwɨtandaihɨ ausaatɨ kaundihɨ namapɨ kiya jahɨra maipɨhaiwaatɨhapɨ nepemaitopo. Iyauhɨ amɨ nɨnɨ utaahonɨnɨ Jonaahoai nusatipɨhaatɨhonɨnɨ wanɨ samɨmatɨhɨ bindataayo. Saindɨ bimonɨhandɨ kandɨ sahɨ atiwɨ jahɨra wɨndɨ namepemaitopo. Isɨ sandɨ sahɨ namepemaitohɨtɨndapɨ jɨhura Niniwehandaahiya Jonaahomɨ pɨwɨha atɨwiwɨ nepemaitohiyɨhiya Autaahaatɨho asisɨha isɨhiyai netɨ tipɨtapaitandɨhura komɨ ndɨhetɨ samɨ maipɨhaiwa nepɨ ausaapɨ nasisɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Iyataatɨ amɨ jɨhura apopaatɨ isɨhiyai iwinja bindataahaatɨ yapɨpatɨ kaanɨhɨ wɨtaahapɨhaatɨ Soromonɨhomɨ amɨtɨha awaindɨhandɨ gwɨnyapenatɨ kataunjindɨhandɨ atitandɨ napise. Aihɨ amɨ nɨnɨ utaahonɨnɨ Soromonɨhoai daahemwatɨhonɨnɨ wanɨ samɨmatɨhɨ bindataayo. Isɨ sahɨ siyohɨtɨndapɨ Autaahaatɨho isɨhiya yapɨpatɨ nahandaahiyai netɨ tipɨtapaitandɨhura sahɨ baiwɨ atɨhomisohɨwɨmaiwaapɨ apopaatɨ saatɨ dotɨ Autaahaatɨhomɨ ndɨhetɨ sangi mandɨtɨpɨsitaise,” undatɨ Jisaasiho isɨhiya komɨ pɨwɨha atɨhomisohiyɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kaundatosatɨ wa pɨwɨha namɨhana saundataase. “Iyataatɨ itɨpɨho maipɨho utaahomɨhatɨhapɨ noaipasi notaahura ko yapɨpatɨ awasatɨ waapɨhaatɨ iwɨwɨrɨho ahɨmetatɨ owehapɨhɨ notɨ daayatɨ ko mbɨpa netɨ maarɨho witɨtandɨhapɨhapɨ daataise. Daataatɨ amɨ ko ikɨndandɨhapɨhɨ wɨndɨ monataise. ");
INSERT INTO agm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Monataatɨ ko sawaho sanataase. ‘Nɨnɨ nisɨ aŋɨpɨpɨhɨ namasi nasohɨpɨpɨhapɨ jahɨra naitaano,’ ndaase. Satamapɨ jahɨra jɨhura namasi naimbɨpɨhɨ aŋɨpɨpɨhɨ niyatɨ mmonataise. Niyatɨ mmonataatɨ kaaŋɨ aŋaaŋɨ nipɨtatɨ naihoanda sanahɨwiya itatamanɨndataise. ");
INSERT INTO agm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Setihɨ mmonamapɨ notɨ itɨpɨho maipɨhaiwa ikwɨrɨ naasairɨhɨtihɨ wihɨnɨramɨ yahurɨtahaiwa 7 kiyatɨ koai nusatipɨhaapɨ apɨpaahɨ maipɨhaiwai numwaasi nasataise. Numwaasi nasatɨ koaisawɨ maawɨ aŋɨndaatɨhɨ utaahomɨ omaŋɨtɨtɨhɨ nandaapɨ bindawaayopo. Nandaapɨ bindawa utaaso soai apɨpaahɨ nepɨ nusopɨsasawaayopo. Nusopɨsasauhɨ ko daahɨ apɨpaahɨ maipɨtatɨ wuwanɨ kaimumwaaŋɨ nusatipɨhaatɨ nopɨsasɨnataise. Saisɨ sɨrɨ kɨretɨ isɨhiya maipɨhiya nisɨ kiyohɨwaiwa mmonɨwɨ baiwɨ akɨtɨnɨhɨ kiyaamɨ maipɨhaiwaatɨhapɨ namepemaitohiyɨhiya awaindɨhandɨ apɨpaahɨ maipɨhaiwaatɨhɨ nandaapɨ nepɨ nopɨsasɨndaapo,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iyatɨ Jisaasiho taatɨ isɨhiya wɨrɨsandɨhiyai pɨwɨha konɨhɨ kaundɨmɨ naihɨ kura komɨ sanaatunɨ saingoyaunɨ koenda napɨwɨ noaipawaayopo. Noaipapɨ ipaahaapɨ bitotawa koaisawɨ pɨwaatɨndotɨwɨ nasenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pɨwaatɨndaanɨ maahe tɨwɨ nasenɨhauhɨ kapɨhɨ isɨhiyaamɨ wo Jisaasihoai saundataase, “Jasapeme, kinyɨ kɨnaatunɨ kwɨnyɨhoyaunɨ wanɨ kɨmiya ipaahaapɨ bitotawaawɨ pɨwaahɨtɨtaatɨwɨtopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Undihɨ amɨ Jisaasiho komɨha wihoaaŋɨha sandaase, “Diyaamɨhaatɨ nisɨ naate? Diyaamahiya nisɨ nɨhoaarɨse?” ndaase. ");
INSERT INTO agm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Satatosa Jisaasiho komɨ otɨpɨpatɨ mmowɨ nepɨ kaiwɨ nuwipinjohiyɨhiyai ikuwɨsatɨ sandaase. “Jasawewɨse, kɨmiya nisɨ naatɨ nisɨ nɨhoaarɨsaare. ");
INSERT INTO agm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Isɨhiya wowaatɨ nisɨ Apɨho yamɨhapataatɨhɨ bimisɨho ko kaatɨ saito saito tatɨ kiyaapɨ gɨwunyaasɨrɨhɨretɨ japepihɨrɨwɨ kiyohiyɨhiya siyaahɨhɨ nisɨ nɨhoaarɨho nisɨ naapwɨraatɨ nisɨ naate,” undatɨ Jisaasiho isɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Saundamapɨ asisɨha sɨketɨ Jisaasiho aŋaaŋɨ namasi noaipasi durɨhɨrɨ Garirihandainapɨ notaise. Notɨ sapɨhɨ durɨhɨrainɨ bindata isɨhiyai kataunjataise. ");
INSERT INTO agm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Aihɨ isɨhiya apɨpaahɨ wɨrɨsandɨhandɨ komɨhinɨ detɨ ahoyanɨmɨ nasauhɨ bimɨtandɨhapɨhɨ owetihɨ namatɨ Jisaasiho kopuhotɨ yamwaataise. Yamwaatɨ kopuhotɨ bindata isɨhiya durɨhɨramɨ mangɨrainɨ bitohauhɨ kataunjataise. ");
INSERT INTO agm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Iyatɨ Autaahaatɨhomɨhaiwaapɨ sɨwipatɨ namɨhanatɨ kiyaisɨ pɨhɨtatɨ taahɨwaiwa kataunjataise. Kataunjataatɨ sɨwipatɨ wɨtɨ satahatɨ namɨhana saundataase. “Asisɨha waaraahɨ utaawo noaipasisotɨ isapɨpa kwɨtaaho isoho osaataatɨ tuwɨhaataise. ");
INSERT INTO agm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tɨwɨhaasɨhɨ kapaamɨ wapa daihɨra tɨmahaihɨ koho satetɨ nanataise. ");
INSERT INTO agm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Iyatɨ kapaamɨ wapa nawɨhaasɨnɨ yapɨpatɨ yaataatɨtɨhapɨhɨ tɨmahiyataise. Iyatɨ yapɨpatɨ yaataatɨhatɨndaatɨ ipɨho yahutaatɨ dimaatataatɨ kwɨtaaho ketɨ nutataise. ");
INSERT INTO agm_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ketɨ nutatatɨho ko amɨ ipɨho noaipatɨ watɨpɨndaatɨ nawɨhai winjasɨhɨ nawɨha tahaŋataatɨ kwɨtaaho sangɨhapa taatɨ nutimbɨpai tɨhatɨ tɨpoyamataise. Tɨpoyamasɨhɨ amɨ yapɨpatɨ yaataatɨndaatɨ tambatɨhɨrɨ biyatɨ wɨndɨ mɨhaapɨ baahɨ namohapaasɨ awasatɨ owendaise. ");
INSERT INTO agm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Iyatɨ kapaamɨ kwɨtaaho wapa kɨtɨha nahaapatohapaamɨ tambatɨhɨrɨ kwɨtaahomɨhatɨhɨ tɨmahaihɨ kwɨtaaho nahaapatoho nutataatɨ nandapai netɨ daahemwa tiwa namaasataise. ");
INSERT INTO agm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amɨ kapaamɨ kwɨtaaho wapa yapɨpatɨ gaahata tɨmahiyataise. Iyatɨ nutatɨ gwɨnyanatɨ wuwanɨ tɨwɨhaahohɨpɨpai nusatipɨhaatɨ akɨpɨpa ningotɨ ahondaise. Iyatɨ akɨpɨpa wapa apɨpaahɨ taahɨwaiwa 100 kiyatɨ ningotɨ amɨ wapa kapɨhata taahɨpɨpa 60 kiya ningotɨ amɨ wapa 30 kiyatɨ ningotaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Satɨ sɨwipatɨ pɨwɨha namɨhanatɨ Jisaasiho katatɨ owemataatɨ sandaase. “Sahɨ samɨhandɨsɨ atiwɨ naitaatɨwaahɨ baiwɨ atiwɨ nepɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aihɨ komɨ otɨpɨpatɨ mmona newa kiyaatɨ nuwipinjohiyɨhiyaanɨnɨ nasawa Jisaasihoai saunda nunjenɨhaayo. “Isɨhiyai Autaahaatɨhomɨhaiwaapɨ katɨpunjapaahura kɨnyɨ wapaapɨ nepemaipɨ napaapɨ kaundapoaatise?” undaatɨ nunjenɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Undonɨhɨ Jisaasiho komɨha nyahɨ komɨ otɨpɨpatɨhiyaanangi sanyatataase. “O amɨ sangisaahɨ Autaahaatɨho isɨhiyai iwinja bimɨtandɨ jɨhɨ gwɨnyapena tɨmaŋiwaiwa sahɨ mmonɨwɨ naitaatɨwɨhandɨ aimɨ netɨ gɨsunyaasɨhiyaate. Sangisɨ sasisataatɨ amɨ isɨhiya otaatapɨhiyaisaahɨ owetise. ");
INSERT INTO agm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sandɨ apaapɨmaato, isɨhiya usa Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ isɨwatohiyɨhiya kaamɨ tiwatɨhaatɨ asakaiwɨ mɨtaahɨ atiwɨ naitaapo. Aisaihɨ amɨ isɨhiya usa Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ miwasohiyɨhiya wonya masɨhonya atisohonyonyaisangi nemasaihɨ nanɨpimatɨwɨmaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nɨnɨ Autaahaatɨhomɨhaiwa netɨ mambɨ wapaapɨ nepemaitɨ kiyaisɨ kaundohɨtɨndɨ apaapɨmundo, kɨmandɨ isɨmiya siyohɨtɨmandape. Kiya pɨhɨtɨwɨ jawaahandɨ kandɨ wapa mmonɨhopo. Kiya pɨhɨtɨwɨ atisawaahandɨ kandɨ wapa atiwɨ nepɨ kɨmwaamopo. ");
INSERT INTO agm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isɨ kiya siyohɨtɨmandɨ Autaahaatɨho Aisaiyaahomɨ maahomwaaŋapɨ pɨwɨha jɨhɨ tɨmanatɨ katisɨha akaaha noaipataise. Iyataatɨ Autaahaatɨho Aisaiyaahomɨhetapɨ sandaase, ‘Kiya pɨhɨtɨwɨ atisawaahandɨ kandɨ kaamɨ tanyaahaapɨ wɨndɨ baiwɨ gɨmunyaitaapo. Aiwɨ kiya pɨhɨtɨwɨ jawaahandɨ kandɨ baiwɨ akɨtɨhandɨ wɨndɨ mondaapo. ");
INSERT INTO agm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","O napaapono, isɨmiya kɨmiya kiyaamɨ amɨtɨha namɨhatatɨ asɨhatahiyaare. Aiwɨ amɨ kiyaamɨ atɨhomwaaŋɨ napwɨndatɨ atɨhomiwɨhiyaare. Aiwɨ kiyaamɨ ndɨha namaimapɨ minjapɨhiyaare. O amɨ wiwa kiya saiwa kamaiwɨ baiwɨ mmonɨwɨ baiwɨ atiwɨ baiwɨ itatamanɨnɨwɨ gwɨnyaapɨ nɨngisenda nepemaitɨwɨ napisaihɨ amɨ wiwa nɨnɨ kiyaamɨ maipɨhaiwa nemwatɨ amɨ kiyai netɨ tɨtɨhemwatɨ gaawimatɨpano,’ tatɨ Autaahaatɨho kandaase. ");
INSERT INTO agm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amɨ sangisaahɨ Autaahaatɨho apɨpaahɨ biyatɨ maarɨho wɨsaiwatɨ jasonataise. Aihɨ samɨ ndɨha nasorɨhainjɨhɨ Autahaatɨhomɨhaiwa mmonɨwɨ newaayopo. Aiwɨ amɨ samɨ atihɨrɨ nasawatainjɨhɨ Autaahaatɨhomɨhaiwa atiwɨ taawɨ gwɨnyapenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kɨmandɨ baiwɨ gwɨnyaapɨse. Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya pɨropetɨhiyaunɨ amɨ usa isɨhiya Autaahaatɨhopɨ baiwɨ gɨwunyaahohiyɨhiyaunɨ taahiyɨhiya wanɨ nɨnɨ kiyonɨhɨ sahɨ mmohohɨwɨmaiwa mmondotɨwɨ maaritɨwɨ jaawɨ bɨsotɨmbɨwɨhiya amɨ wɨndɨ mohopo. Aiwɨ wanɨ nɨnɨ kandɨsasonɨhɨ sahɨ atisohɨwɨmaiwa atitotɨwɨ jaawɨ bɨsotɨmbɨwɨhiya amɨ wɨndɨ atɨhomisopo. Isɨ sahɨ wanɨ mmonɨwɨ atisohɨwɨmaiwaapɨ baiwɨ maaritɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Isɨ sahɨ isapɨpa kwɨtaaho tɨwɨhaasɨhopɨ nepemaitɨ nɨnɨ katohɨhaapɨ napondaase tɨwɨ atiwɨ mmonɨwɨ nepɨse ausaatɨ kasatɨtaano. ");
INSERT INTO agm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Isɨhiya usa isɨhiyaisɨ iwinjaatɨ bimɨtandɨ Autaahaatɨho gwɨnyapenatɨ netɨ tɨmaniwaiwaapɨ pɨwɨha atisawaawɨ wɨndɨ gɨmunyaahauhɨ yapɨpatambɨ Utaaho Maipɨho atisohɨha nasatɨ nemataise. Saisawiya siya daihɨra kwɨtaaho tɨmahaisɨhomataiwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Amɨ isɨhiya usa Autaahaatɨhomɨ pɨwɨha atisawaawɨ ketɨ kuraanɨhɨ maaritɨwɨ newaayopo. Siyohiyɨhiya yapɨpatɨ nawɨhaamɨ tiwatɨhaatɨ yaataatɨhata kwɨtaaho tɨmahaipatetamataiwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amɨ saiwɨ yapɨpatɨ yaataatɨhatamatetahiyaasɨ pɨwɨha atisohɨha baahɨ mɨhatɨhɨ kɨmwaurɨmwɨndihɨ kiya wɨndɨ otɨhɨ andɨtitɨwɨ bɨmitohopo. Iyauhɨ kiya Autaahaatɨhomɨ pɨwɨha atiwɨ maaritɨwɨ japepihɨrohɨtɨhandapɨ isɨhiya kiyai naaŋɨhaiwa numwisaihɨ Autaahaatɨhopɨ kiya gɨwunyaahohɨtɨhandɨ namaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Amɨ isɨhiya usa Autaahaatɨhomɨ pɨwɨha taawɨ atimɨ nowaawɨ amɨ mambɨhaiwaapɨ pɨhɨtɨwɨ gwɨnyapepɨ ikɨpɨpa pɨhɨtɨwɨ nepɨ ahoaitaatɨwɨ maaritohɨtɨhanda pɨwɨha atisohɨha kai netɨ tiwa itaatisa namaasataise. Namaasasɨhɨ pɨwɨha atisohɨhaamɨ akɨpɨpa kiyaamɨhetapɨ wapa namoaipase. Isɨhiya siyohiyɨhiya yapɨpatɨ kɨtɨha nahaapatohapa nandapaisatɨ ahoya nawasɨpataahamataiwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Amɨ isɨhiya usa Autaahaatɨhomɨ pɨwɨha atiwɨ mmonɨwɨ nepɨ baiwɨ kɨpowaayopo. Iyauhɨ kiyaamɨhetapɨ pɨwɨha atisohɨhaamɨ nandapa akɨpɨpa noaipataise. Noaipataatɨ akɨpɨpa wapa apɨpaahɨ pɨhɨtatɨ noaipatɨ amɨ wapa kapɨhata pɨhɨta noaipatɨ amɨ wapa pɨhɨtatɨ noaipataise. Siyohiyɨhiya isiya kwɨtaaho yapɨpatɨ gaahata tɨmahiyatɨ nutatɨ gwɨnyanatɨ nandapa akɨpɨpa pɨhɨtatɨ noaipasɨpatamataiwɨhiyaare,” nyatatɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Aihɨ Jisaasiho pɨwɨha wa namɨhana isɨhiyaisɨ saundataase, “Autaahaatɨho isɨhiyai taatɨ iwinjaatɨ bimaamɨ naindɨmandɨ utaaho wo osaataatɨ nandapa kwɨtaaho gaahapa niyaamatɨ tɨwɨhaasɨtɨhandamatiyahande. ");
INSERT INTO agm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aihɨ waara isɨhiya nanomɨhauhɨhura apatindɨtɨhɨ utaaso nandapa gaahapa yamasomɨ tiworɨho nasatɨ kɨtɨha maipɨha maasaworɨhɨrɨ osaataatɨ nandapaamɨhatɨhɨ tɨwɨhaamapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aihɨ nandapa nimaatatɨ taatɨ kwɨtaihɨhura kɨtɨha maasaworɨhɨrɨ ausaimanɨnataise. ");
INSERT INTO agm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aihɨ komɨ otɨpɨpatɨhiya napɨwɨ osaataatɨ nandapaamɨ satɨhoai saundawaatopo, ‘awaisɨhoŋe, nandapa gaahapaahɨhɨ yamahɨninjahonɨ kɨtɨma maipɨma maahɨraapɨ nasahaare?’ undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Undauhɨ osaataatamɨ satɨho kiyaisɨ saundataase. ‘Nisɨ tiworɨho wo sandɨ kiyataise,’ undihɨ komɨ otɨpɨpatɨhiya koai saundawaatopo. ‘Nyahɨ nowa kɨtɨha otɨpiya nawowaamaitaanɨ kɨnyɨ gaare tɨtaino?’ undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Undauhɨ ko kiyai saundataase. ‘Owetise amɨ wiwa kɨtɨha otɨpaiwɨ nawomawaawɨ nandapaisawɨ ahoyawɨ nawomaitaawo. ");
INSERT INTO agm_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Isɨ nehɨ namɨhaapɨ iwinjasawɨse. Nandapaisa Kɨtɨha gaasɨ ahoya nawa ahetane wanɨhapaahɨho. Iyonɨhɨ nandapa nimaŋɨtandɨhura tɨmetanɨhɨ isɨhiya kapa nimaŋɨtaatɨwɨhiyai kaundisanɨhɨ kiya jɨhɨ kɨtɨha maasaworɨhɨrɨ nawopɨ ahoyawɨ usaamapɨ wɨsasawɨ tɨhoaaposawɨ amɨ kasɨnɨ ipotɨ nandapa akɨpɨpa kɨpɨwɨ ahoyawɨ aŋɨpɨpɨhɨ kapaapɨhapɨhɨ ahaito,’ undataase,” tatɨ Jisaasiho namɨhana katisɨha katatɨ owemaitaise. ");
INSERT INTO agm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Aihɨ Jisaasiho pɨwɨha wa namɨhana isɨhiyai saundataase. “Autaahaatɨho isɨhiyaisɨ iwinja bimindɨhandɨ ipatɨ kati wɨtamɨ yandɨpɨho kwɨtaaho apɨpaahɨ turɨkaarehonjɨ utaaho yamasɨhɨ nuta gwɨnyainjɨpatamatiyahande. ");
INSERT INTO agm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iyatɨ so kwɨtaaso nandapa kwɨtaaho wapa osaataatɨ yamahohɨpɨpai apɨpaahɨ namusatipɨhaatɨ turɨkaarehonje. Siyahonjɨndaahandɨ kandɨ aimɨ gwɨnyanataahura osaataatɨ nandapa wapai apɨpaahɨ daahemwatɨ awaisɨhondaise. Iyatɨ ipatamatiya gwɨnyanatɨ awaisɨhotihɨ amɨ koho nasatɨ isɨtɨtɨ satɨtɨhora bindataise,” undatɨ namɨhanatɨ isɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Aihɨ Jisaasiho kiyaisɨ pɨwɨha wa namɨhana saundataase. “Autaahaatɨho isɨhiyai iwinja bimindɨhandɨ bɨretɨhandɨ tɨhɨtaatɨwɨ waatɨpatɨ pɨraawaaho namasawɨ ahiyohɨhoai netɨ nipindɨhandamatiyahande. Iyatɨ netɨ nipitandɨhandɨ yisɨhandɨ apopaatɨ waatɨ netɨ pɨraawaaho waatɨpatisa ahoya tiwa nauhɨwa naumbwaihɨratɨ waapohoaisa namasa isehamanɨmɨ naihɨ netɨ nipitandɨhandɨ yisɨhandɨ bɨretɨhandɨ tɨhɨtandɨ isehamasɨhetɨ gaama nandaapɨ notaise,” undatɨ Jisaasiho isɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iyataatɨ Jisaasiho pɨwɨma kɨmaiwa nahatewa nehɨ namɨhanahaiwaahɨhɨ isɨhiya wɨrɨsandiwɨhiyai kaundataase. Amɨ nehaahɨ wɨndɨ kamundise. ");
INSERT INTO agm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ko Jisaasiho kɨmandɨ kaindɨmandɨ Autaahaatɨho komɨ pɨwɨha atisa netɨ ausaasɨhomɨ maahomwaaŋapɨ jɨhura satisɨha netɨ akaahemataise: “Nɨnɨ isɨhiyaisɨ kaundataatɨ wapaapɨ namɨhandɨ kaundɨto. Aindɨ nɨnɨ wuwanɨhura yamɨhapatɨ yapɨpatɨ kaindɨ ahiyohururaapɨ noaasandɨmɨ napimbɨpaapɨ wanɨ kiyaisɨ ausaatɨ kaundɨto,” ndaase. ");
INSERT INTO agm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Aihɨ Jisaasiho isɨ wɨrɨsandɨhandi numwasi aŋɨpɨpɨhapɨ niyatɨ aŋaaŋɨ nandaataise. Nandaasɨhɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨ koenda nasawa saundɨhaato. “Kɨnyɨ pɨwɨha kɨtɨha maipɨha osaataatɨ nawasɨhaapɨ nepemaipɨ katingɨtɨhandamɨ tanyaaha ausaapɨ kanyate,” undɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Undonɨhɨ Jisaasiho komɨha nyangi sanyatataase. “Pɨwɨha kaamɨ tanyaaha saasɨ sahɨ atiwɨse. Utaaho nandapaamɨ kwɨtaaho gaaho tɨwɨhaaso so nɨnɨ nɨwahonɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨne. ");
INSERT INTO agm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Iyatɨ amɨ osaataatɨ saatɨ yapɨhɨ nahande. Nandapaamɨ kwɨta gaaso isɨhiya Autaahaatɨho iwinja bimisawɨhiyaare. Amɨ kɨtɨ maipa isɨhiya mambɨ Utaaho Maipɨho iwinja bimisawɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iyataatɨ uta tiworɨho kɨtɨha maipɨha tuwɨhaaso so Bwaasɨrɨhɨre. Nandapa nimanɨwɨ kɨpɨwɨ ahoyohurura wanɨ isɨmiyaamɨ bimaamɨ niyohurɨmura Autaahaatɨho satetɨ owematɨ isɨhiyai netɨ tipɨtapaitandɨhandɨ namasatɨ taatɨ tɨmanisuraare. Iyatɨ amɨ isɨhiya nandapa nimanɨtaatɨwɨhiya siya Autaahaatɨhomɨ otɨpɨpatɨhiya yamɨhapataatɨhapɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Iyataatɨ amɨ kɨtɨ maipa nawopɨ ahoyawɨ tɨhoaahohɨpatamataiwɨ isɨmiya wanɨ bimaamɨ niyohurɨmura Autaahaatɨho netɨ owemaitandɨhura sɨrɨ kɨretɨ saiwɨ kaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ nisɨ enjerɨhiya otɨpɨpatɨhiya yamɨhapataatɨhapɨhiyai nandusoaasisanɨhɨ nuwɨ nisɨ isɨhiyai winja bimohiyɨhiyaamɨhatɨhapɨ kahapaamapɨpa maipɨhaiwa namoyaasɨpɨpaisunɨ isɨhiya nahatiya maipɨhaiwa kiyohiyɨhiyaisunɨ numwaapɨ ahoaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aiwɨ kiyaisɨ sisɨha maipɨha watɨpɨhaapɨhɨ nepɨ yotisaihɨ kapɨhɨ kiya gwɨwɨ ese no no tɨwɨ kiyaamɨ mangɨrɨ gitɨpaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iyonɨhɨ suraanɨhɨ Autaahaatɨhomɨ isɨhiya tɨtɨhiya kiyaamɨ Sapɨho iwinja bimonɨhɨ ipɨhomataiwɨ jaitaapo. Isɨ samɨhandɨsɨ atiwɨ naitaatɨwaahɨ baiwɨ atiwɨ nepɨse,” nyatatɨ Jisaasiho komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kaundatosa Jisaasiho wa pɨwɨha namɨhana komɨ otɨpɨpatɨ mmona newa kiyaatɨ nuwipinjohiyɨhiyaanangi sanyatataase. “Autaahaatɨho isɨhiyai iwinja bimindɨhandɨ nawɨho ikihɨ sanaatɨ apɨpaahɨ aungwohandɨ wapɨhɨ osaataatɨ noaasandisɨhomatiyahande. Aihɨ utaaho wo sandɨ nawomɨ ikɨ sanɨndɨ mmonataise. Iyatɨ amɨ ko kandɨ daahɨ jahɨra netɨ noaasatosamɨ asakiyatɨ maaritɨmɨ notɨ komɨ ikɨpɨpa nahataapa usai neunya kapaapɨ nawɨho netaise. Kapaapɨ nawɨho nesɨhora nawɨho ikihɨ sanaatɨ noaasandisɨho komɨhotɨtandɨ yapitɨ nawɨho noaasandipitɨ katamɨ satɨhoai nawɨho nunya netaatɨ maaritindɨhandamatiyahande,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Iyatosatɨ amɨ wa pɨwɨha komɨ otɨpɨpatɨhiyaanangi namɨhana sanyatataase. “Amɨ Autaahaatɨho isɨhiyai iwinja bimindɨhandapɨ isɨhiya usa napaitɨwɨ maaritɨwɨ daapɨ nehohiyɨhiya utaaho wo napaitatɨ maaritatɨ konaarapɨho netɨ ahoyataaho konaarapɨho kiwaanyɨhopɨ pɨhɨtatɨ daasɨhomataiwɨhiye. ");
INSERT INTO agm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iyataatɨ konaarapɨho kiwaanyɨho koai wo apɨpaahɨ wipetaho isɨhiya maaritɨwɨho mmonataahura utaaso notɨ komɨhaiwa nahatewa neunya nawɨho nesisa kiwaanyɨho apɨpaahɨ koai wipiya otiwa kaumbwaaho nunya netaise,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Iyatosa Jisaasiho wa pɨwɨha namɨhana komɨ otɨpɨpatɨhiyaanangi sanyatataase. “Amɨ Autaahaatɨho isɨhiyai iwinja bindata komɨ pɨwɨha ausaasɨho amɨ isɨhiya kahatamatɨpetahiya Autaahaatɨhomɨhatɨhɨ napɨwɨ ahoyanɨwɨ nandaapɨ bimohɨtɨhandɨ durɨhɨrɨ awairɨhɨraatɨhɨ ikihɨ awaihihɨ tɨmapɨ aipɨ araiho nanɨwɨho namaanɨwɨho nohohɨpatamatiyahande. ");
INSERT INTO agm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ikihɨ awaihihɨ tɨmapɨ aihauhɨ araiho satotɨ ikiha tisainjɨhura ikihɨ aisi mangɨrainɨ aripataatɨhɨ nuwɨ notawaayopo. Notɨwɨ bindawaawɨ araiho nepɨ napɨpapɨ gaaho akorɨpɨhoaatɨhɨ ahiyawɨ amɨ maipɨhotihɨ poundaho nepɨ tɨmawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Isɨ isɨmiya wanɨ bimaamɨ niyohurɨmura Autaahaatɨho netɨ owemaitandɨhura sɨrɨ kɨretɨ siyatɨ noaipaitaise. Autaahaatɨhomɨ enjerɨhiya otɨpɨpatɨhiya yamɨhapataatɨhapɨhiya napɨwɨ isɨhiya maipɨhiyai isɨhiya gaahiyaamɨ otɨhatɨhapɨ aipɨ nepɨ ahoaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Aiwɨ isɨhiya maipɨhiya kiyaisɨ sisɨha maipɨha watɨpɨhaapɨhɨ nepɨ yotisaihɨ kapɨhɨ kiya gwɨwɨ ese no no tɨwɨ kiyaamɨ mangɨrɨ gitɨpaitaapo,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nyatatosatɨ Jisaasiho komɨ otɨpɨpatɨhiyaanangi sanyata nanyisenataise. “Pɨwɨha kɨmaiwa kasatohɨwɨmaiwaamɨ tanyaaha mmonɨwɨ gwɨnyapenawaayowo e owetiso?” nyatataase. Sanyatihɨ amɨ nyahɨ koai saundɨhaato. “Ye, mmonaatɨ gwɨnyapenahaayo,” undɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Undonɨhɨ ko netɨ sanyatataase, “Isɨhiya wɨnɨhapɨpa isɨhiyai katɨwunjohiyɨhiya Autaahaatɨho isɨhiyai iwinja bimindɨhandapɨhaiwa nɨnɨ kandunjanɨhɨ nepɨhiya kiya jɨhapa Mosesihomɨ wɨnɨhapɨpa gwɨnyaapɨ nehohɨpɨpaisawɨ amɨ wanɨhapa nga gwɨnyaapɨ isɨhiyai nga katɨwunjɨtaatɨwɨhiyaimatɨtaapo,” nyatatɨ Jisaasiho komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Aihɨ Jisaasiho maipɨhaiwaapɨ namɨhana Autaahaatɨho isɨhiyai winja bimindɨhandapɨ komɨ otɨpɨpatɨhiyaanangi katanyasiwaiwa saiwa katatɨ owemamapɨhura sapɨhɨ namasi notaise. ");
INSERT INTO agm_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Sapɨhɨ namasi sawahomɨ aunahɨpatɨ Nasaretɨhandaahapɨ notaise. Notɨ noaipatɨ komɨ aunahɨpataahɨ bindataatɨ isɨhiya kapɨhapɨhiyai kiyaamɨ aŋaaŋɨ pɨwɨhaapɨ ahoyanohɨpɨpɨhɨ kataunjataise. Kataunjihɨ isɨhiya atɨwisohiyɨhiya komɨ watɨpɨhandisa kataunjiwaiwaapɨ apɨpaahɨ awaindɨhandɨ yaiwɨmawaayopo. Yaiwɨmapɨ satawaatopo, “Ese utaamo komɨ amɨtɨha gaahandɨ gwɨnyapendandɨmandɨ napitiyatɨ maahapɨhapɨ nehande? Iyatɨ amɨ watɨpɨhaiwa kaitandɨhandisangi napitiyatɨ maahapɨhapɨ nehande? ");
INSERT INTO agm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Utaaho kɨmo nehɨ aŋaaŋɨ aŋɨmatisɨhomɨ mwaahosɨ awɨtɨwɨ jɨpatɨpaiwɨ kaiwɨ mmowɨ naitaatɨwɨhapɨhɨ wɨndɨ utaarɨhandɨ namohore. Amɨ komɨ sanaatɨ Mariyaahaatɨmetindɨho? Iyatɨ amɨ komɨ saingoya Jemɨsiho Josepɨho Saimonɨho Judaasiho siyaametindɨho? ");
INSERT INTO agm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aiwɨ amɨ komɨ sanaapwɨsa nyangisawɨ kɨmbɨhɨ bɨmindawaayondɨho? Isɨ ko saiwa komɨ watɨpɨhaiwa napitiyatɨ maahapɨhapɨ nehaiwaatindɨho? Nyahɨ apɨpaahɨ wɨndɨ moho,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Satɨwɨ mɨmaipaiwɨ usowɨ Jisaasihoai sawahomɨhiya kiya ahosumwawaayopo. Sawisauhɨ Jisaasiho kiyai saundataase. “Autaahaatɨhomɨ pɨwɨha atisa netɨ ausaasɨho isɨhiya usaamɨ aunahɨpata wapɨhɨ wapɨhɨ naihɨhapɨhɨ kapɨhapɨhiya ko autaahɨ awaisɨho gaahoe tɨwɨ kopɨ gɨwunyaapɨ numwaawaayopo. Nehɨ isɨhiya usaahɨhɨ koai sawisauhɨhandɨ kandɨ sawahomɨ aunahɨpataahapɨ isɨhiya sawahomɨhiya wɨndɨ baiwɨ samaawisopo. Owetise. Iyataatɨ sahɨ nɨwahonisɨhiyaatɨ nɨngi satɨ katɨ kaniwɨ ahosɨnɨmawaayopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Saiwɨ kopɨ wɨndɨ baiwɨ gɨmaawunyaapɨ namumwaahauhiyata kandapɨ kapɨhɨ sawahomɨ aunahɨpata watɨpɨhaiwa taahɨwaiwa wɨndɨ kamaise. Owetise. ");
INSERT INTO agm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aihɨ sura Erotɨho awaisɨho isɨhiya Garirihandaahiyai iwinja bimisɨho Jisaasihopɨ komɨ watɨpɨhaiwa kaiwaiwaapɨ atisataise. ");
INSERT INTO agm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Atisatosatɨ saundataase, “Ese so akɨtɨnɨhɨ Jonɨho isɨhiyai baawusisɨho ko jahɨra anɨmwaahɨpatombɨ nepate. Siyataatɨ komɨhatɨhɨ watɨpɨhaiwa ahotihɨ kaiwetapɨ ko watɨpɨmaiwa kiyataise,” Daase. ");
INSERT INTO agm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Iyataatɨ sandɨ ko apaapɨmaase, jɨhura Jonɨhoai Erotɨho sawahomɨ pɨwɨhaara tiwauhɨ napwindɨhandapɨ gwɨnyapenataatɨse. Iyataatɨ Jonɨhomɨ daihɨra napwirɨhɨra siyate. Erotɨho komɨ saaho Piripɨho sangɨ napotɨ bimihɨhomɨ apwaataatɨ Erotiyaasihaati aunɨwɨsataatɨ kaati ikonatɨ netɨ wɨrataise. Aihɨ Jonɨho Erotɨhoai saundataase, “Gaatɨho sangɨ napwihɨhandɨ kandɨ kɨnyɨ wɨndɨ satɨ gaahatɨ kaimbɨ komɨ apwaataatɨ Erotiyaasihaati nepɨ wɨrapaamaise,” undatɨ mausahaiwa kaunda itɨhundataase. Saundihɨ Erotiyaasihaati Jonɨhopɨ apɨpaahɨ kaatamɨ mandɨha nusoaatatɨ apousamasɨhɨ kandapɨ Erotɨhoai nususepaipatɨ jinjahɨra Jonɨhoai nemape undatoaatihɨ namatɨ kaatapimainjɨhiyata ko Jonɨhoai netɨ wɨratɨ napuwataise. ");
INSERT INTO agm_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ko saiwa saundindɨmandapɨ Erotɨho Jonɨhoai wɨratɨ napuwatosatɨ sohoai tiwamaitotatɨ gwɨnyapenɨmɨ notoandaise. Iyatoandaahandɨ kandɨ isɨhiya Jonɨhopɨ Autaahaatɨhomɨ pɨwɨha atisa netɨ ausaasɨhoe tɨwɨ koai autaahɨ nepɨ isɨwatauhiyata Erotɨho satatɨ nɨnɨ Jonɨhoai tiwisanɨhɨ isɨhiya dopawɨ nisɨ awaisɨhonɨnimandɨ iwinja bimohɨtɨhandɨ nepɨ nopɨsasɨwɨ maatɨmaatitaawo tatɨ gwɨnyaataatɨ isɨhiyaapɨ yayatɨ Jonɨhoai ketɨ wɨndɨ tɨmaawise. ");
INSERT INTO agm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aihɨ amɨ asisɨha Erotɨhoai sanaatɨ namwisuraatihɨ kuraapɨ gwɨnyapendaatɨwɨ isɨhiya napɨwɨ ahoyanawaayopo. Ahoyanɨwɨ bimauhɨ kiyaamɨ ndɨhetɨ Erotiyaasihaatamɨ maataatɨ nonasaya waipwaasɨtɨhandapɨ Erotɨho maarɨho tundatɨ apɨpaahɨ awaindɨhandɨ maaritataise. ");
INSERT INTO agm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Siya maaritataatɨ kaati pɨwɨha wa tɨmana saundataase, “Nɨnɨ akɨtɨnɨhɨ sahɨtataato wapaapɨ nanɨsesamaahɨ tɨtɨhɨ kɨnyɨ nanɨsehingɨpɨpa nahɨmɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Undihɨ apwaimaamaati sanaatɨ kaundisɨha japepihɨra Erotɨhoai saundatɨ nunjenataise. “Wanɨ kɨmura kuraanɨhɨ kɨmbɨhɨ ketɨ Jonɨho Isɨhiyai Baawusisɨhomɨ nahwɨtarɨhɨrɨ namandipapɨ mɨtɨho pɨretɨho nehoaatɨpɨhoaatɨhɨ nesɨmbo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Erotiyaasihaatamɨ maataatɨ awaisɨho Erotɨhoai saundihɨ amɨ Erotɨhomɨ maarɨho yaawatɨ naaŋawisataise. Komɨ maarɨho yaawa naaŋawihɨhandɨ kandɨ amɨ komɨ pɨwɨha kaati wapaapɨ nanɨsesamɨhapa kapa akɨtɨnɨhɨ nahɨmɨto undatɨ isɨhiyaamɨ ndɨhetɨ kaundindɨhandapimainjɨhɨ namatɨ ko kaatamɨ nasesɨpɨpa nepunyawɨse undatɨ tunnɨwɨ yahwɨnohiyɨhiyaamɨ woai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kaundihɨ niyatɨ napwɨta bimimbɨpɨhɨ Jonɨhoai nahwɨtarɨhɨrɨ namandipatɨ komɨ mɨtɨho nisatataise. ");
INSERT INTO agm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Iyatɨ mɨtɨho nesisatɨ apwaimaamaati numwihɨ amɨ kaatɨ nesi notɨ kaatamɨ sanaatɨ Erotiyaasihaati nunyataise. ");
INSERT INTO agm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aihɨ Jonɨhomɨ otɨpɨpatɨ mmowɨ nepɨ kaiwɨ nuwipinjohiyɨhiya kandapɨ atisawaawɨ napɨwɨ komɨ ambɨpatɨ nesisuwɨ yamwaawaayopo. Yamwaaposamɨ kiya nuwɨ Jisaasihoai Erotɨho Jonɨhoai nemasɨtɨhandapɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Satɨwɨ kaundauhɨ atisamapɨ Jisaasiho sapɨhɨ namasi kopuhotɨ yamwaatɨ isɨhiya owehapɨhapɨ nehɨ nyahɨ komɨ otɨpɨpatɨhiyaanangisataahɨhɨ nohaayo. Aihɨ isɨhiya Jisaasiho sapɨhapɨ naise tauhɨ atiwɨmapɨ kiyaamɨ aunahɨpɨhaiwa namasi nyangi nyahamasi auhɨraapɨhɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nuwɨ noaipɨhauhɨ Jisaasiho kopuho namasi noaatɨpa nehɨhaatɨ notataise. Iyatɨ isɨhiya awaindɨhandɨ wɨrɨsandɨhandi iwinjataatɨ kiyaapɨ komɨ maarɨho asɨpiyatɨ tundataise. Siyatɨ kiyaapɨ maarɨho tundihɨ kiyaamɨ timbɨpaisahiyaisɨ tɨtɨhɨwiwataise. ");
INSERT INTO agm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aihɨ asɨhataahura aimɨ ipɨho yaataatisɨhɨ komɨ otɨpɨpatɨ mmonaatɨ newa kiyawa nuwipinjohiyɨhiyaanɨ nasawa Jisaasihoai saundɨhaato. “Aimɨ asisɨha napandotaisɨ amɨ isɨhiya owehapɨhɨsɨ nandapa owetise. Isɨ isɨmiyai natɨpusoaase kiyaisɨ aunahɨpɨhaiwaara nuwɨ nandapa daapɨ nepɨ nando,” undɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Undonɨhɨ Jisaasiho komɨha nyangisɨ sanyatataase. “Owe, kiya kɨmbɨhɨ wɨndɨ namasi namuwɨse. Sawanaatɨ wapa kiya nandaatɨwɨhapa nunyawɨse,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nyatihɨ amɨ nyamɨha saundɨhaato, “Nyahɨhɨ nandapa bɨretɨhandɨ ikwɨ naasairɨtihɨ amɨ araiho 2 kiyatɨ yahurisahiyaane,” undɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Undonɨhɨ Jisaasiho sanyatataase, “Gaasɨ kapa nɨngi kɨmbɨhɨ nesɨpɨwɨ naninyawɨse,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nyatatosatɨ isɨhiyai yatɨhɨ bimaawɨse undihɨ bindawaayopo. Iyauhɨ ko nandapa bɨretɨhandɨ 5 kiyatɨ ikwɨ wihɨtɨrɨtihɨ amɨ araiho yahurɨtihɨ netɨ isɨwatata naingaatɨ yamɨhapataatɨhɨ jatɨ Autaahaatɨhoai nandapaapɨ kɨnyɨ gaahoŋe gaare undataase. Undatosatɨ nandapa bɨretɨhandɨ naumbotɨ komɨ otɨpɨpatɨhiyaanangi nanyamihɨ amɨ nyahɨ newaatɨ isɨhiyai nesɨwesɨwa gaamawa nunyahaayo. ");
INSERT INTO agm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nunyonɨhɨ nepɨ isiya nahatiya pɨhɨtɨwɨ nanɨwɨ amɨ gwɨsɨmowaayopo. Iyauhɨ amɨ nawɨpɨpa nyahouna ahotimbɨpa Jisaasihomɨ otɨpɨpatɨhiyaanɨnɨ newa ahoyawa ikihɨ ikwɨmaindɨmwɨtihɨ auhɨramɨ yahura tisaahɨwa kɨpohaayo. ");
INSERT INTO agm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iyataatɨ isɨhiya nandapa nanɨhohiyɨhiya nehɨ usɨhiyaahɨhɨ asɨhiya manyinyai awɨmɨtɨwɨ 5,000 kaiwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aihɨ Jisaasiho komɨ Otɨpɨpatɨhiyaanangi sanyatataase. “Sahɨ jɨhɨ kopuho nesi durɨhɨrɨ nahaitɨwɨ wihɨnapɨ taawɨ naawɨse nɨnɨ isɨhiyai nɨwahonɨnɨ netɨ nandusaasɨtaano,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aihɨ isɨhiyai netɨ kiyaisɨnɨhɨ natausosamapɨhura nehɨ sawahohɨhɨ Autaahaatɨhopɨ gaapundɨtandɨ sisɨhoaasɨnɨ nasaamaanataise. Iyatɨ sawahohɨhɨ sisɨhoaasɨnɨ nasaamana bimihɨ aimɨ asɨhatamataise. ");
INSERT INTO agm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Aihɨ suraanɨhɨ kopuho aimɨ notɨ durɨhɨramɨ otɨhaatɨndaise. Aihɨ itɨpɨho kopuhoai netɨ tiwanda itɨpinnatɨ durɨhɨrɨ sisɨho dotɨ kihihoaaŋemataise. ");
INSERT INTO agm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aihɨ bousetetɨ Jisaasiho durɨhɨraatɨhɨ autaahɨ taatɨ itɨpatɨ daimɨ nasataise. ");
INSERT INTO agm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Daimɨ napihɨ komɨ otɨpɨpatɨhiyaanɨ iwinjaatosatɨ apɨpaahɨ maarɨho owenyetihɨ yayawaamɨhaayo. Yayawaamawa satahaato, “Ese waapɨhaatetapɨ matapɨhiya maipɨhiye,” taatɨ kaahaatɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yayonɨhiyata ketɨ kuraanɨhɨ Jisaasiho nyangi sanyatataase, “Maarɨho wɨsaitane. Nɨne. Nɨnisɨ wɨndɨ yamaiwɨse,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nyatihɨ Pitaaho Jisaasihoai sata kaundataase, “Awaisɨhonye o amɨ kɨnyɨtapaapaahɨ namme nde. Nɨnɨ gisenda durɨhɨraatɨhɨ autaahɨ itɨpatɨ daimɨ napɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Undihɨ amɨ Jisaasiho Pitaahoai, “Gaasɨ namme,” undataase. Undihɨ Pitaaho kopuho namasi noaatɨpatɨ durɨhɨraatɨhɨ autaahɨ itɨpatɨ daimɨ Jisaasihoenda notaise. ");
INSERT INTO agm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Notaatɨ itɨpɨho itɨpinataatɨ durɨhɨrɨ tiwayaasɨhɨ iwinjatɨ yayataise. Siyatɨ komɨ yaindɨhandaahɨ taatɨ nawatisataatɨ Jisaasihopɨ sata gandaase, “Awaisɨhonye nɨngi nanimaapɨ nanɨmaape,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Undihɨ ketɨ namaŋɨnda Jisaasiho satotɨ ahɨwa numwaataise. Numwaatosatɨ sata kaundataase. “Ese, uta kɨmoŋɨ kɨnyɨ apɨpaahɨ nisapɨ maipɨhonjɨ masehonjɨ gɨnunyaapɨhoŋe. Kɨnyɨ napaapɨ maarɨho yahwɨ gwɨnyaahise?” undataase. ");
INSERT INTO agm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Saundihɨ kurɨ maisahurɨ durɨhɨraatɨhapɨ notɨmɨ kopuhotɨ nasaamasɨhɨ itɨpɨho napotɨ yatɨhitataise. ");
INSERT INTO agm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aihɨ komɨ otɨpɨpatɨhiyaanɨnɨ kopuhotɨ bimohiyɨhiyaanɨ Jisaasihoai saundawa, ‘Kɨnyɨ akɨtɨnɨhɨ Autaahaatɨhomɨ mwaahoŋɨ akohoŋe,’ undaatɨ mepɨ autaahewaumwahaayo. ");
INSERT INTO agm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Aihɨ Jisaasiho komɨ otɨpɨpatɨhiyaanangisa durɨhɨrɨ nahaitawa nonji yapɨpatɨ Genesaretɨhanda noaipɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Noaipahonɨhɨ isɨhiya kapɨhapɨhiya Jisaasihoai usowosawɨ aimɨ kɨmo koso nɨwɨ kapɨhɨ yapita gaamapɨ pɨwɨha katɨwepinjanɨwɨ kiyaamɨ timbɨpaahiyai Jisaasihoenda numwaasi nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Aiwɨ numwaasi nasohiyɨhiya Jisaasihoai saundɨwɨ nunjenawaayopo. “Isɨmiya kɨmiyai kɨnyɨ ikwɨrɨ ahɨwitaapɨ gandaahandɨ kandɨ isɨhiya taahiyɨhiyaasɨ namapɨ nehɨ iwinjasamɨhɨ kinyɨ apotɨhɨramɨ mangɨrainɨ otasaahaapɨ giwɨta gaaro?” undawaatopo. Saundauhɨ Jisaasiho kiyaisɨ nehɨ iwinjasɨhɨ komɨ apotɨhɨrɨ wiwawaayopo. Aiwɨ isɨhiya timbɨpaahiya komɨ apotɨhɨramɨ otasaaha wihohiyɨhiya nahatiya gaawimatatɨ tɨtɨhitawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aihɨ isɨhiya Parisihiyaunɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ Jerusaremɨhandaahɨraapɨ napɨwɨ koai saundɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kinyɨ otɨpɨpatɨ mmonɨwɨ nepɨ kaiwɨ nangipinjohiyɨhiya nyamɨ asoya asisaamɨ mɨtɨhiyaamɨ wɨnɨhapɨpa nanyinyohɨpɨpa napaapɨ baiwɨ nepɨ minjapepihɨropo? Aiwɨ nyamɨ asoya asisa aimapɨ kaiwɨnyasauhɨ kiyohɨrɨhɨretɨ tɨtɨhɨ japepihɨrɨwɨ nandapa nandaatɨwɨhura kiyaamɨ ikwɨrɨ jɨhɨ bahomusopo?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Undauhɨ Jisaasiho komɨha kiyai saunda nunjenataise. “Amɨ sahɨ sawanaatɨsangi jaasoya jaasisaamɨ wɨnɨhapɨpa baiwɨ isɨwatawa Autaahaatɨhomɨ wɨnɨhapɨpa napindapɨ miwatɨwɨ amɨ nepɨ nopɨsasopo? ");
INSERT INTO agm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Iyataatɨ amɨ Autaahaatɨho sata katise. ‘Kɨnyɨ kinyɨ gapiyɨ kɨniyai baimbɨ atɨwimbɨ maarɨwitɨpɨ gɨwunyaape,’ ndaase. Iyatɨ ‘amɨ metɨho metɨhaatɨ wo waatɨ komɨ kaatamɨ saniyɨ sapiyaapɨ maarɨho mɨmaipiya gɨwunyapenatɨ atɨhomaawisa wɨretɨtatɨ maipɨhaiwa kaundataataahɨ soho saamaati timasaihɨ napone,’ tatɨ Autaahaatɨho wɨnɨhɨndaase. ");
INSERT INTO agm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Sata wɨnɨhɨtihɨhandɨ kandɨ sahɨ isɨhiyai satɨwɨ katɨwunjawaayopo, ‘Utaaho wo saniyɨ sapiya iwɨtatamanɨtandɨhapa kasanyuri numwɨtandɨhapa wapa ahotanɨhapaapɨ ko sata kɨmba Autaahaatɨhomɨhape tatɨ kandaataahɨ, gaasɨ ko saniyɨ sapiyai wɨndɨ maawɨtatamanɨtando,’ tɨwɨ sahɨ isɨhiyai katɨwunjawaayopo. Sahɨ sandɨ samɨ jaasoyaamɨ amɨ mɨtɨhiyaamɨ wɨnɨhapɨpaapimainjɨhɨ kapaahɨhɨ awaindemawaawɨ Autaahaatɨhomɨ pɨwɨha watɨpɨha yatɨhɨ ipatisamawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Sahɨ apɨpaahɨ utaatɨ otaatapɨhatɨmaate, apɨpaahɨ tɨtɨhɨ akɨtɨnɨhɨ Aisaiyaaho Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaatɨ jɨhura sapɨ sata katihɨhiyaate: ");
INSERT INTO agm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Isɨmiya kɨmiya kiyaamɨ maahomwaaŋapaahɨhɨ nepɨ mepɨ autaahepɨnɨmapɨ autaahɨ niwatawaayopo. Niwataahandɨ kandɨ kiyaamɨ maarɨho omaŋɨtɨtɨhapɨ kiyawaamaayopo. Owetise. Kiyaamɨ maarɨho omaŋɨtɨtɨhɨ kaanɨhɨ yandɨhɨ ahotatɨ nisapɨ wɨndɨ gɨmaanunyaahopo. ");
INSERT INTO agm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Aiwɨ kiya isɨhiyaamɨ nehɨ pɨwɨha nepɨ ausaapɨ kɨma Autaahaatɨhomɨ wɨnɨhapɨpe tɨwɨ katɨwɨsanawaayopo. Siyawaawɨ kiya nisapɨ nehɨ jaipɨtɨwɨhaiwa aunɨhɨhɨrɨ katɨwɨ gaapundawaatopo,’ tatɨ Aisaiyaaho kandaase,” undatɨ Jisaasiho isɨhiya Parisihiyaisunɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaisunɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kaundatosatɨ Jisaasiho isɨhiya usaisɨ gaata numwaatɨ detɨ komɨhinɨ nasauhɨ kiyai saundataase. “Sahɨ kɨma pɨwɨma baiwɨ atiwɨ nepɨ samɨ omaŋɨtɨtɨhɨ baiwɨ kɨpɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Utaaho komɨ maahomwaaŋapɨ nandapa ikisatɨ nanaapwɨtimbɨpa kapa netɨ komɨ ambɨpatɨ maarɨho omaŋɨtɨtɨhɨ maipɨtatɨ ainjotatɨ nusopɨsasataamaise. Iyatɨ daihɨra ko Autaahaatɨhoaisatɨ nahoyatɨ sisatɨ pɨwaatɨndandɨhɨra netɨ nɨwisapuwataamaise. Owetise. Nehɨ amɨ komɨ maarɨho omaŋɨtɨtɨhɨ amɨtɨhaatɨhɨ gwɨnyapenatɨ amɨ komɨ maahomwaaŋɨ nausaatɨ maipɨhaiwa katimbɨpa sapaahɨhɨ ko daihɨra Autaahaatɨhoaisatɨ pɨwaatɨndandɨhɨra netɨ nɨwisapuwatɨ nuwipɨndaise,” undatɨ isɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aihɨ Jisaasihomɨ otɨpɨpatɨhiyaanɨnɨ nasaatɨ koai saundɨhaato. “Kɨnyɨ mmohɨno e mohɨno kinyɨ pɨwɨha katingɨhaapɨ atisawaawɨ Parisihiya kiyaamɨ maarɨho omaŋɨtɨtɨhɨ mɨmaipaiwunyaapɨ apowindɨmandapo?” undɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Undonɨhɨ Jisaasiho nyamɨha netɨ wihoaaŋɨha wa namɨhana sanyatataase. “Nandapa nahataapa osaataatɨ nisɨ Apɨho yamɨhapataatɨhɨ bimisɨho wapa wɨndɨ yamaamasɨpɨpa ko tambatɨhɨrɨ ahɨwa nawotɨ yamotɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aisɨ sahɨ kiyaapɨ awaindɨhandɨ gɨmaawunyaapɨ nehɨ iwinjasawɨse. Kiya ndɨha asɨhatahiya daihɨra isɨhiya usa ndɨha asɨhatahiyai nunjawaahiyaare. Nunjawaahiyaasɨ sawanaatɨ aimɨ mmohohɨtɨhande amɨ utaaho wo ndɨha asɨhataho daihɨra utaaho ndɨha asɨhataho woai ikwɨrɨ wisi nunjamɨ notaataahɨ maisahurɨ anɨmwaahɨpatopɨ witɨtaise,” nyatatɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Aihɨ Pitaaho dotɨ Jisaasihoai saundataase, “Pɨwɨha satɨpɨ utaaho komɨ ikwɨrɨ bahomusa nehɨ nandapa nainjɨtɨhanda komɨ maarɨho omaŋɨtɨtɨhɨ gwɨnyapesɨtɨhandɨ netɨ nusopɨsasataamaise tingɨtɨmandamɨ tanyaaha ausaapɨ kɨnyɨ nyangi kanyatɨme,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Undihɨ Jisaasiho kiyai saundataase, “Ese, isɨmiyaatɨ sangisangi sangɨ akɨtɨnɨhɨ monawaawɨtowo? ");
INSERT INTO agm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aiwɨ sahɨ nɨnɨ pɨwɨha kasatohɨhaamɨ tanyaaha monawaawɨtowo? Nandapa utaaho nainjɨpɨpa maahomwaaŋɨhɨra notɨ kosahaara kɨpwɨnataise. Iyatɨ kapɨhapɨ nehɨhaatɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aihɨ amɨ kahapaamapɨpa Maipɨhapa utaaho komɨ maarɨho omaŋɨtɨtɨhɨ netɨ gwɨnyapenatɨ osaimbɨpa maahomwaaŋapɨ nehɨhaatɨ noaipataise. Iyatɨ saiwaahɨhɨ utaaho Autaahaatɨhoaisa pɨwaatɨndandɨhɨra daihɨra asɨhata nɨwisapuwatɨ nuwipɨndaise. ");
INSERT INTO agm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Iyatɨ amɨ utaaho komɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhapɨ saiwa siyataise, apɨpaahɨ gɨmunyaatɨhaiwa maipɨhaiwa gwɨnyapenatɨ isɨhiyai tiwamatɨ asɨhiya warɨsaisahiyai iwiwatɨ iwinjatɨ usɨhiya asɨhiya kɨhiyaisatɨ nanotɨ daayatɨ isɨhiya usaamɨhapa ikonatɨ pɨwɨha kahatamatɨpɨta jaiwɨtatɨ usaamɨ ambɨpatɨ ambɨpatɨ komɨ pɨwɨhaara netɨ nopɨsasataise. ");
INSERT INTO agm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iyatɨ saiwaahɨhɨ utaahomɨ maarɨho omaŋɨtɨtɨhɨ nusopɨsasatɨ daihɨra Autaahaatɨhoaisa pɨwaatɨndandɨhɨra netɨ nɨwisapuwataise. O amɨ utaaho wo komɨ saisatoyaamɨ wɨnɨhapɨpa japepihɨra ikwɨrɨ jɨhɨ bahomusa nandapa nehɨ nanɨhonɨhɨ sandɨ komɨ omaŋɨtɨtɨhɨ wɨndɨ netɨ namausopɨsasɨtaise. Owetise,” nyatatɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Aihɨ Jisaasiho sapɨhɨ namasi yanɨhɨma isɨhiyaapɨ yapɨpatɨ wɨtɨ aunahɨpatɨ awaiwaurɨ Tayaahandamunɨ Saitonɨhandamunɨ detɨ ahetihɨhata notaise. ");
INSERT INTO agm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Notɨ noaipatɨ bimihɨhura apopaatɨ yapɨpatɨ Kanaanɨhandaahapɨ Isɨraherɨhiyaamɨ dawaataatapɨhiyaamɨhaatɨ sapɨhɨ bindataahaatɨ Jisaasihoenda nasatɨ koai saundatɨ gousoetaise. “Daawitɨhomɨ Mwaahoŋɨ Isɨraherɨhiyai Iwinjaapɨ Bimɨtaapɨ Awaisɨhoŋe nɨngi kɨnyɨ maarɨho asɨpɨnime. Nisɨ maasɨhaamaati itɨpɨho maipɨho nɨwɨndaatɨ netɨ nusopɨsasihɨ kaatɨ apɨpaahɨ maipɨtatɨ ahondaise,” undatɨ koai gousoetaise. ");
INSERT INTO agm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Siyatɨ gousoesɨhandɨ kandɨ Jisaasiho kaati pɨwɨha wa wihoaaŋɨha kamundise. Kamundihɨ namawa komɨ otɨpɨpatɨhiyaanɨnɨ koai saundaatɨ tarɨwundaatɨ nunjenɨhaayo. “Apopaatɨ kɨmaatɨ pohɨrɨnyatatɨ ŋuŋaatatɨ taatɨ nyamɨ ipotɨ nanyipinjisɨ kaati kɨnyɨ nepɨ tarɨwaimbɨ natɨpusoaase,” undɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Undonɨhɨ Jisaasiho komɨ maahomwaaŋɨ nausaatɨ waapɨhɨtatɨ sandaase. “Nehɨ isɨhiya Isɨraherɨhiya maasapɨho sipɨsipɨhandɨ nihɨrɨnatɨ owetindɨhandamataiwɨ nihɨrɨnɨwɨ owetohiyɨhiyai jɨhɨ gandɨ numwaatɨ netɨ ahoaindɨ iwɨtatamanɨtandɨ Autaahaatɨho nɨngi natanoaasihɨ napɨtɨhonɨne,” ndaase. ");
INSERT INTO agm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sa satihɨhandɨ kandɨ apopaatɨ mwɨtetatɨ mɨtɨho nusoaasamɨ nasatɨ Jisaasihomɨ auhɨraapɨhɨ tɨmahiya atotɨpɨwesatɨ bindataatɨ koai saundataase. “Kɨnyɨ nɨngi maarɨho asɨpɨnimbɨ nahɨsetɨ kahɨtohɨpɨpa kanime,” undatɨ gousoetaise. ");
INSERT INTO agm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aihɨ Autaahaatɨho jɨhɨ kahapaamapɨpa gaahaiwa Isɨraherɨhiyai nunjatɨ nunyatɨ kawɨsatosatɨ ipotɨ isɨhiya kiyaamɨ dawaataatɨ bimohiyɨhiyai kawitandɨ sawahoai natausaasindɨhandapɨ Jisaasiho namɨhanatɨ apopaati saundataase. “Itapo, manyinyaamɨ nandapa nepɨ suhɨri tumwaitaapɨ sandɨ gaamaahe, owe,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Saundihɨ amɨ kaatamɨha koai satatɨ kaundatase. “Ye, Awaisɨhoŋe kɨnyɨ sa akɨtɨha katapaase. Akɨtɨha katapaahandɨ kandɨ nandapa otasaaha gwɨtɨtɨho naumbwɨnatɨ suhɨramɨ satɨhomɨ ganɨhoaasɨnapɨ yatɨhɨ tɨmahaihɨhapa suhɨrɨ netɨ nanataise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Undihɨ Jisaasiho kaati komɨha saundataase. “Ese itapo, kɨnyɨ apopaaŋɨ nisapɨ apɨpaahɨ awaindɨhandɨ gɨnunyaapɨhaaŋe. Isɨ kɨnyɨ ngɨpwɨ nɨngi nanɨsehingɨpɨpa kapa kɨretɨ nɨnɨ kahito,” undataase. Aihɨ sa saundisura kuraanɨhɨ kaatamɨ maataati tɨtɨhɨwitataise. ");
INSERT INTO agm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Aihɨ Jisaasiho sapɨhɨ namasi notɨ durɨhɨrɨ Garirihandainɨ noaipataise. Noaipatɨ aripatainɨ daayatɨ bitopɨ niyatɨ sisɨhoaasɨnɨ nasaamanatɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bimihɨ isɨhiya wɨrɨsandɨhandɨ isɨhiya auhɨrɨ bɨwatetɨ andɨtatɨ namahatatɨ ndɨha niyotatɨ maahomwaaŋɨ napupwasɨhɨ pɨwɨha pɨwaamaatɨwɨhiyaunɨ amɨ usa taahiyɨhiya timbɨpaisahiyai numwaasi napɨwɨ komɨ asɨmwaapɨpɨhɨ ahɨwisawaayopo. Ahɨwisauhɨ Jisaasiho kiyaamɨ timbɨpa nemwatɨ tɨtɨhɨwiwataise. ");
INSERT INTO agm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nemwatɨ tɨtɨhɨwisɨhɨ auhɨrɨ bɨwatesawɨhiya dosi daiwɨ amɨ andɨtatɨ namɨhatisawɨhiya nuwɨ napɨwaiwɨ amɨ ndɨha niyotisawɨhiya japɨhɨ japɨ maahomwaaŋɨ napupwasawɨhiya pɨwaatauhɨ isɨhiya kiyaisɨ winjawaawɨ maarɨho wɨndotɨ apɨpaahɨ yaiwɨmawaayopo. Yaiwɨmapɨ Isɨraherɨhiyaanamɨ Autaahaatɨhopɨ kiya maaritɨwɨ komɨ ambɨpatɨ mepɨ autaahepumawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Aihɨ Jisaasiho nyahɨ komɨ otɨpɨpatɨhiyaanangi gaata nanyamaatɨ sanyatataase. “Isɨhiya kɨmiya nɨngisawɨ asisɨha mairɨmaara bimauhɨ kiya nandapa nandaatɨwɨhapa owetise. Owetihɨ nɨnɨ kiyaapɨ maarɨho asɨpiyataayo. Asɨpiyataatɨ kiyaisɨ nandapa namunyatɨ aŋɨpɨpɨhapɨ nandusoaasɨtandɨ ponje amɨ aunahɨpatɨ kaanɨhɨsɨ wiwa kiya kiyaamɨ andɨtatɨ owetanɨhɨ daihɨra wonɨwoniwɨ tɨmahaitaawo,” nyatatɨ kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Sanyatihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ saundaatɨ nunjenɨhaayo. “Kɨmbɨhɨ iwɨwɨrɨho isɨhiya oweta aunahɨpa kaanɨhɨsɨ nyahɨ nandapa maahapɨhapɨ taahɨpɨpa nga newaatɨ isɨ wɨrɨsandɨmiyai numwɨtɨhaawe,” undaatɨ nunjenɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nunjenɨhonɨhɨ Jisaasiho nyangi sanyatatɨ nanyisenataise. “Sahɨ nandapa bɨretɨhandɨ napitaiwɨ isɨpɨhiyaate?” nyatataase. Aihɨ nyahɨ koai saundɨhaato. “Nandapa bɨretɨhandɨ 7 kiyatɨtihɨ amɨ araiho maipɨhasɨnya naasonyaisahiyaanɨne,” undɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Saundonɨhɨ namatɨ Jisaasiho isɨhiyaisɨ yatɨhɨ bimaawɨse undihɨ kiya yatɨhɨ bindawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bimauhɨ Jisaasiho nandapa bɨretɨhandɨ ikwɨrɨ naasairɨtihɨ wihɨnɨramɨ yahurisatɨ araihonya netɨ isɨwatata kapaapɨ Autaahaatɨhoai, “Kɨnyɨ gaahoŋe gaare,” undataase. Gaare undatosatɨ kapa naumbotɨ nasɨpatɨ komɨ otɨpɨpatɨhiyaanangi nanyamihɨ amɨ nyahɨ newaatɨ isɨhiyaisɨ gaamawa nesɨwesɨwa newaunyɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Newaunyonɨhɨ kiya nahatiya nanɨwɨ kiyaamɨ gwɨsɨha tisaitataise. Tisaitihɨ nawɨpɨpa kanaahɨpa ahotimbɨpa nyahɨ asawa newaatɨ ikɨhaiwa awaiwaiwa 7 kiyahaiwa tisaahɨwaatɨ kɨpohaayo. ");
INSERT INTO agm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iyataatɨ isɨhiya nandapa nanɨhohiyɨhiya asɨhiya manyinyai awɨmɨtɨwɨ nehɨ gwɨnyaahiya usɨhiyaahɨhɨ 4,000 kaiwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aihɨ Jisaasiho isɨhiyaisɨ natausaasamapɨ kopuhotɨ yamwaatɨ nasaamana durɨhɨraatɨhɨra aunahɨpatɨ Makataanɨhandamɨ yapɨpataahapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aihɨ isɨhiya usa Parisihiya amɨ Satiyusihiya Jisaasihoenda nasawaayopo. Napɨwɨ wɨndɨ kamaayonaahɨ koai nepɨ nusopɨsasɨto tɨwɨ iwinjatawaawɨ Jisaasihoai saundɨwɨ nunjenawaayopo. “Nyahɨ kinyapɨ ko Autaahaatɨhoaapɨhapɨ nasahoe taatɨ gwɨnyaitaanɨ watɨpɨhandɨ wɨndɨ nepɨ kaimbɨ nanyise,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Undauhɨ Jisaasiho komɨha saundataase. “Asɨhataahura ipɨho nipatataatɨ yamɨhapatɨ jɨtɨpitihɨ sahɨ satawaatopo, ‘Apatɨhunɨ amɨ bousonɨhunɨ baahɨnyitande,’ tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aiwɨ asisɨhaatɨhɨ yamɨhapatɨ tɨwipa napapatɨ asɨhatihɨ sahɨ satawaatopo. ‘Ese wipɨwɨtande,’ tawaatopo. Saiwɨ yamɨhapati iwinjawaawɨ baahaitaise wipɨwɨtaise tɨwɨ gwɨnyaapɨhiyaate. Gwɨnyaapɨhiyaatɨtawaahandɨ kandɨ Autaahaatɨho nisɨhetapɨ isɨhiyai kawitandɨ gwɨnyapesɨwaiwa wanɨ kɨmura samɨmatɨhɨ nasatɨ taatɨ kaihɨhandɨ kaiwa sahɨ wɨndɨ mohopo. ");
INSERT INTO agm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wanɨ kɨmura namɨwiyaatohiyɨhiyaatɨ apɨpaahɨ maipɨhiyaatɨ Autaahaatɨho akoho naasopaahɨ gɨmunyaapɨ kɨho kɨhopɨ gwɨnyapepɨhiyaate. Saiwɨhiyaatisɨ sahɨ nɨngi sɨwipatɨ watɨpɨhatɨ wɨtɨ nyangi nanyise ndɨwɨ nanɨsenawaayopo. Isɨ nanɨsehohɨpitɨ wɨndɨ sangi namaasasɨto. Nehɨ Autaahaatɨho komɨ pɨwɨha atisa netɨ ausaasɨho Jonaahoai kawɨsatɨ isɨhiyai sɨwipatɨ nunjipatamataindɨhatɨhɨhɨ nasɨsɨto,” undamapɨ kiyaisɨ numwasi notaise. ");
INSERT INTO agm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Naihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ Jisaasihoaisa maasɨ nohaayo. Iyaatɨ durɨhɨrɨ Garirihandɨ nahaitaatɨ wihɨnɨ mɨhihɨnɨ noaipɨhaayo. Iyaatɨ nyahɨ otɨpɨpatɨhiyaanɨnɨ nandapa bɨretɨhandɨ wapa miwaatɨ nanɨpimataatɨ nehɨ dosi taanahiyɨhiyaanɨnɨ nowaatɨ noaipɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nowaatɨ noaipawaatɨ bindɨhaawɨ Parisihiya Satiyusihiya isɨhiyaisɨ katɨwunjawɨ kiyauhɨ kaiwa isɨhiyaisɨ numwanɨmɨ naihɨ kaiwa awaindɨtɨtaiso tatɨ kandapɨ awaindɨhandɨ gwɨnyapenataatɨ Jisaasiho nyangi sanyatataase. “Parisihiya Satiyusihiyaamɨ nandapa bɨretɨhandɨ netɨ nipitandɨhandɨ yisihandɨ samɨhetɨ yasamwaatɨ nasamanɨtaisɨ sahɨ bapaiwɨ jatɨnɨwo,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ko nyangi sanyatihɨ amɨ nyahɨ yawanaanɨnɨ sanɨhaato. “Ko nyangi sandɨ kanyatindɨmandɨ apaapɨmaanyase, amɨ nyahɨ nandapa bɨretɨhandɨ wapa miwaatɨ nehɨ nasonɨhɨ kandapɨ nyase,” nnɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Komɨ pɨwɨha kanyatisɨhaapɨ taawa sanɨhonɨhɨ Jisaasiho nyangi nyasonatosatɨ sata nanyisenataise. “Nandapa bɨretɨhandɨ owesɨ maahɨwapɨhapɨ naitɨhaawe nɨwɨ napaapɨ awaindɨhandɨ taawɨ gwɨnyapehopo? Ese sandɨmaatɨ nisapɨ sahɨ apɨpaahɨ maipɨhonjɨ gɨnunyaapɨhiyaate! ");
INSERT INTO agm_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Sahɨ siyohɨtɨmandɨ nɨngi sangɨ maanowaawo? Isɨhiya usɨhiya gwɨnyaahiya 5,000 kaiwɨhiyai nandapa bɨretɨhandɨ 5 kiyahandamɨ naumbwɨtɨ nunyonɨhɨ nga gwɨsɨha tisaipɨ nanɨhauhɨ nawɨpɨpa ahotindɨhandapɨ sahɨ wɨndɨ gɨmunyaahowo? Nawɨpɨpa ahotimbɨpa ikihɨ napitaiwɨhihɨ tisaipɨ nepɨ kɨpopo? Sahɨ nanɨpimatowo? ");
INSERT INTO agm_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Amɨ nandapa bɨretɨhandɨ 7 kiyatɨ ikwɨrɨ naasairɨtihɨ wihɨnɨramɨ yahurɨtahandɨ isɨhiya usɨhiya gwɨnyaahiya 4,000 kaiwɨhiyai nunyohɨtɨhandapɨsangi sahɨ apɨpaahɨ wɨndɨ gɨmunyapenawaayowo? Ikihɨ awaihihɨ napitaiwɨhihɨ nawɨpɨpa tisaipɨ nepɨ kɨpopo? Sahɨ gwɨnyapehowo e nanɨpimatawaayowo? ");
INSERT INTO agm_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nɨnɨ Parisihiya Satiyusihiya isɨhiyai katɨwunjawɨ kiyohɨwaiwaapɨ kasatonɨhandɨ kandɨ sahɨ kiyaamataiwɨ samɨ ambɨpatapɨhaiwaapaahɨhɨ gwɨnyapepɨ nisapɨ baiwɨ gɨmaanunyaapɨ nyahɨ nandapa bɨretɨhandɨ nenamaasotɨhandapɨ awaindɨ gwɨnyaataatise nnɨwɨ napaapɨ gwɨnyapehopo? Isɨ sahɨ Parisihiya Satiyusihiya isɨhiyaisɨ katɨwunjawɨ kiyohɨwaiwa nandapa bɨretɨhandɨ netɨ nipindɨhandɨ yisihandamatiyahaiwaasɨ samɨhetɨ yasamwaatɨ nasamanɨtaisɨ yaiwɨ jatɨnɨwɨhiyaatɨ bitosawɨse,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kanyatihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ siyaatɨ gwɨnyapenaatɨ mmonɨhaayo ko nandapa bɨretɨhandɨ netɨ nipindɨhandapɨ maanyase. Nehɨ Parisihiya Satiyusihiya isɨhiyai katɨwunjawɨ kiyohɨwaiwaapɨ nyatiso taato. ");
INSERT INTO agm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Aihɨ Jisaasihoaisaatɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ aunahɨpatɨ Sisariya Piripaihandamɨ yapɨpataahapɨ niyahaayo. Sapɨhɨ niyaatɨ bindɨhaawɨ Jisaasiho sata nyangi nanyisenataise. “Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonisapɨ isɨhiya diyaamahoe tawaatopo?” tatɨ nanyisenataise. ");
INSERT INTO agm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sata nanyisesɨhɨ nyamɨha koai wihoaaŋɨha saundɨhaato. “Isɨhiya usa kinyapɨ satawaatopo, ‘Ko Jonɨho Isɨhiyai Baawusisɨho anɨmwaahɨpatombɨ japɨhɨ nepate,’ tawaatopo. Tɨwɨ amɨ usa satawaatopo, ‘Ko aimehura Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho Eraijaahore,’ tawaatopo. Tɨwɨ amɨ usa ‘Ko aimehura Autaahaatɨhomɨ pɨwɨha atisa netɨ ausaasɨho Jeremiyaahore,’ tawaatopo. Tɨwɨ amɨ usa ‘Ko aimehura Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaamɨ wore,’ tawaatopo,” undaatɨ Jisaasihoai kaundɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Saundonɨhɨ ko nyangi sata nanyisenataise. “O amɨ sahɨho? Sahɨ nisapɨ ko diyaamahoe tɨwɨ gwɨnyapenawaayopo?” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sanyatihɨ Saimonɨ Pitaaho dotɨ Jisaasihoai saundataase. “Kɨnyɨ Kɨraisihoŋɨ Isɨhiyai Japɨhɨ Numwaapɨ Iwinjatɨtaapɨ Autaahaatɨho Ahɨngisɨhoŋɨ Autaahaatɨho asohomɨ Mwaahoŋe,” undatɨ awusaatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Saundihɨ Jisaasiho komɨha wihoaaŋɨha Pitaahoai sata kaundataase. “Saimonɨhoŋɨ Jonɨhomɨ mwaahonye, Autaahaatɨho gisɨ gaahandɨ kahisataisɨ maarɨho wite. Ko nisɨ Apɨho yamɨhapataatɨhɨ bimisɨho nisapɨ pɨwɨha sa netɨ nangɨsihɨ kɨnyɨ nisapɨ ausaapɨ katapaase. Nehɨ kɨwahonyɨ maarɨhora gwɨnyaapehingɨtɨhanda katapaamaase, owetise. ");
INSERT INTO agm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Isɨ nɨnɨ gi sandɨ kahɨtataato. Kɨnyɨ watɨpɨhoŋɨ nawɨhaaraŋe. Nawɨhaarangisɨ kinyɨhetapɨ gisatɨ isɨhiya wanɨ nisapɨ gɨnunyaahohiyɨhiyaisunɨ ipotɨ ipotɨhura nisapɨ gɨnunyaitaatɨwɨhiyaisunɨ netɨ ahoyatɨ andɨtɨwiwɨto. Andɨtɨwisanɨhɨ nisapɨ gɨnunyaahohɨtɨhanda nawɨhiyaimatɨwɨ bitopɨ naisaihɨ Bwaasɨrɨhɨrunɨ komɨhiya watɨpɨhiyaunɨ nisɨ isɨhiyaisɨ wɨndɨ nepɨ tipɨ tipɨndɨwɨ maurɨpatitaapo. ");
INSERT INTO agm_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iyataatɨ nɨngi Apɨho yapɨpatambɨ natanoaasataatɨ komɨ watɨpɨhandɨ isɨhiya gɨnunyaahohiyɨhiyaisɨ iwinja bimɨtandɨ nɨngi nanɨmindɨhandɨ gi ipotɨ kinyɨ ikwɨraatɨhɨ nahɨmɨto. Nahɨmisanɨhɨ maapɨ yapɨpataapɨhɨ kahapaamapɨpa wapaamɨ daihɨra maasomwaaŋɨ nisɨ watɨpɨndɨ nɨnɨ gi nahɨnyohɨtɨndaahɨ nepɨ nisapupwɨ napuwapaapaahɨ amɨ mɨhaatɨ yamɨhapataatɨhɨ Autaahaatɨhoaisangi netɨ satɨ katɨ kaitaise. Aimbɨ kahapaamapɨpa wapaamɨ daihɨra maasomwaaŋɨ kɨnyɨ nepɨ maapɨ yapɨpataapɨhɨ dauta nutane tɨpɨ daupwɨ nuwapaapaahɨ mɨhaatɨ yamɨhapataatɨhɨ Autaahaatɨhoaisangi netɨ satɨ katɨ kaitaise,” undatɨ Pitaahoai Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Saundatosatɨ Jisaasiho nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ nahatiyaanangi sanyatataase. “Sahɨ isɨhiyaisɨ nisapɨ ko Isɨhiyaisɨ Japɨhɨ Numwaatɨ Winjatɨtandɨ Autaahaatɨho Ahɨwisɨhore undɨwɨ kamundɨwɨse,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Aihɨ suraapɨ Jisaasiho namasatɨ nyahɨ komɨ otɨpɨpatɨhiyaanangi satatɨ kanyatatɨ nanyisataise. “Nɨnɨ Jerusaremɨhanda naitaano. Naindɨ noaipasanɨhɨ isɨhiya gwɨnyaahiya jɨhiyaunɨ amɨ pɨrisihiya isɨhiyaapɨ nandapa kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai nunyohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ isɨhiya wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ nɨngi yaasatɨ naaŋɨhaiwa nanɨmɨtaapo. Yaasatɨ naaŋɨhaiwa naninyawɨ sohonɨhi nɨwɨtaapo. Sohonɨhi nɨwisaihɨ napotɨ ahotɨmbɨtɨ asisɨha yatairɨ sananisonɨhɨ asisɨha netɨ mairɨ ma kanisɨhetɨ Autaahaatɨho jahɨra ahonimatɨ nanɨmaahonɨhɨ nepaito,” nyatatɨ nyangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aihɨ Pitaaho Jisaasihoai numwaatɨ yandɨhema saunda itɨhundataase. “Awaisɨhoŋe, sandɨ nyangi kanyatingɨtɨndapɨ Autaahaatɨho maarɨho asɨpɨhisatɨ nehɨmahonɨhɨ kandɨ gi namangoaipane,” undatɨ itɨhundataase. ");
INSERT INTO agm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Saundihɨ Jisaasiho Pitaahoai dawaatumwatɨ saundataase. “Kɨnyɨ gwɨnyapehingɨwiwa saiwa nehɨ kɨwahonyɨ isɨhiyaamɨ gwɨnyapehohɨwaiwa gwɨnyapenapaise. Autaahaatɨho gwɨnyapesɨtɨhandɨmaahe. Owetise. Kɨnyɨ saimbɨ nisɨ daihɨra gwɨnyapenɨhohɨrɨhɨra nepɨ nanɨsapuwapaise. Isɨ Bwaasɨrɨhɨraŋe, kɨnyɨ nisɨmbɨhapɨ nawɨsapitɨpɨ kɨraŋɨnɨhɨ numbwɨmape,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pitaahoai saundatosatɨ Jisaasiho nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ nahatiyaanangi sanyatataase. “Isɨhiya usa nɨngi napɨwɨ nanipinjawɨ nɨnɨ daahɨmɨra daayohɨrɨmɨra daitaatɨwaahɨ sawanaamɨ ambɨpatapɨ gwɨnyaapɨ maaritohɨwaiwai namapɨ nanɨpimatɨwɨ nisaputɨwɨ kiyaisɨ isɨhiya naaŋa yaawɨhaiwa numwisaihɨhaiwa kaiwa nepɨ isɨpɨ nɨngi andɨtitɨwɨ nanipinjawɨse. ");
INSERT INTO agm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iyataatɨ amɨ isɨhiya usa maapɨ kiyaamɨ ambɨpatapɨhaiwaapaahɨhɨ andɨtatɨ napamawaawaahɨ kiya nɨngisawɨ jinjapɨhɨ bɨsotɨtaatɨwɨhandɨ wɨndɨ namaitaapo. O isɨhiya usa maapɨ kiyaamɨ ambɨpatapɨhaiwai ahosumwapɨ nisɨhaiwaapaahɨhɨ andɨtatɨ napamawaawaahɨ kiya nɨngisawɨ baiwɨ jinjapɨhɨ bɨsotɨtaatɨwɨhandɨ naitaapo. ");
INSERT INTO agm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Amɨ Isɨhiya usa kahapaamapɨpa yapɨpatambɨhaiwa nahatewa nunyawɨ nepɨ kiyaamɨhaiwemapɨ ahoyawaahandɨ kandɨ nɨngisawɨ kiya jinjapɨhɨ bimɨtaatɨwɨhandɨ nihɨrɨwɨ owetonɨhɨ kaiwetapɨ akɨpɨpa napaamapa naitaapo? Apɨpaahɨ owetɨtaise. Nɨngisawɨ jinjapɨhɨ bimɨtaatɨwɨhandɨ wapa nunyawɨ jahɨra namaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sandɨ sangi apaapɨmaasato, amɨ nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ nisɨ Apɨhomɨ watɨpɨhandɨ saasanotindɨhandaatɨhɨ nisɨ enjerɨhiya itɨpɨhiya otɨpɨpatɨhiya yamɨhapataatɨhapɨhiyaisatɨ napɨtɨ isɨhiyaisɨ netɨ tipɨtapaitandɨhura detɨtihɨ kasato. Aindɨ nɨnɨ isɨhiya nahatiya naasiya naasiyaisaahɨ maapɨ kiyaamɨ kiyohɨwaiwaapɨ wihoaaŋɨhapa kamwaaŋɨ numwɨtandɨhandapɨsato. ");
INSERT INTO agm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Isɨ kɨmandɨ sahɨ baiwɨ gwɨnyaapɨse. Isɨhiya usa wanɨ kɨmbɨhɨ bimohiyɨmiya wɨndɨ ketɨ namwaapɨwɨ bimambɨwɨ nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ napɨtɨ Awaisɨhonɨnimandɨ isɨhiyai iwinjaatɨ bimisanɨhɨ ninjaitaapo,” nyatatɨ komɨ otɨpɨpatɨhiyaanangi pɨwɨha gwɨnyaitɨhaaha kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Aihɨ asisɨha ikwɨrɨ naasairɨtihɨ wihɨnɨramɨ naasaahɨ 6 kiyatɨ sanotɨ namɨhaasɨhɨ Jisaasiho Pitaahoaisunɨ saaho saingɨho Jemɨsiyɨ Joniyai numwaasi sisɨho utaarɨhoaasɨnapɨ sawanaahɨhɨ niyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Naiwɨ sawingwaasɨhɨ bindawaawɨ komɨ otɨpɨpatɨhingwaasamɨ ndɨhetɨ Jisaasihomɨ ambɨpatɨ ketɨ netɨ wipendaise. Netɨ wipendaatɨ komɨ ndɨmaahomwaaŋɨ ipɨhomatiya apɨpaahɨ nausaatatɨ saasanotatɨ amɨ komɨ apotɨhɨrɨ noaipatɨ kɨhoepɨtatɨ apɨpaahɨ amɨnaahɨ taanahɨtɨtatɨ urahurɨhɨrɨ nuramataise. ");
INSERT INTO agm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Aihɨ nehɨ ketɨ kuraanɨhɨ noaipapɨ Mosesiyɨ Eraijaaya Jisaasihoaisamɨ pɨwaatinjɨhɨ komɨ otɨpɨpatɨhingwaasɨ iwinjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sandɨ saimainjɨhɨ Pitaaho Jisaasihoai saundataase. “Awaisɨhoŋe, nyahɨ gaanɨhɨ kɨmbɨhɨ bindɨhaayo. Gaanɨhɨ bindɨhaayonɨ kɨnyɨ gaasɨ kaime disamaahɨ nɨnɨ aŋaaŋɨ nausarɨhaiwa maurɨ maaŋɨ aŋɨmatɨtaano, waaŋɨ kinyapɨtanɨhɨ waaŋɨ Mosesihopɨtanɨhɨ amɨ waaŋɨ Eraijaahopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pitaaho taatɨ satatɨ Jisaasihoai kaundihɨ tɨwipatɨ apɨpaahɨ saasanotatɨ nausaatahatɨ ketɨ nihɨtisa kiyaisɨ numwaasataise. Numwaasatɨ amɨ pɨwɨha wa tɨwipataatɨhapɨ satatɨ noaipataise. “Kɨmo nisɨ apohɨpataatɨhapɨ maasɨhɨho akohore. Nɨnɨ koaisɨ nisɨ maarɨho apɨpaahɨ awaindɨhandɨ nunyatɨ wɨwitɨhore. Isɨ sahɨ koaisɨ baiwɨ atɨwiwɨse,” ndaase. ");
INSERT INTO agm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aihɨ otɨpɨpatɨhingwaasɨ pɨwɨha sa atisawaawɨ apɨpaahɨ awaindɨhandɨ yaiwɨ kiyaamɨ ndɨmaahomwaaŋɨ yapɨpatetɨmapɨ yatɨhɨ tɨmahiyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Siyauhɨ Jisaasiho nasatɨ kingwaasi wiwatɨ saundataase. “Saingwaasaatɨ wɨndɨ yamaiwɨ naingaatɨwɨ nepapɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Saundihɨ kingwaasɨ nepapɨ naingaapɨ jawa isɨhiya usai wɨndɨ maawinjapɨ nehɨ Jisaasiho sawahoaisaahɨ usonawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Saiwa saimainjɨhɨ mmowɨmapɨ kingwaasɨ komɨ otɨpɨpatɨhingwaasɨ Jisaasihoaisawɨ sisɨhoaasɨnɨ taawɨ noaatɨpapɨ nowaayopo. Noaatɨpapɨ nowaawɨ Jisaasiho kingwaasi saundataase. “Saingwaasaatɨ sisɨhoaasɨnɨ noaipasɨhɨ mmohohɨtɨmandapɨ isɨhiyaisɨ ausaapɨ apɨpaahɨ wɨndɨ kamundɨwɨmapɨse. Kamundɨwɨmapɨ nehɨ sawanaatamɨhetɨhɨ kɨsamwɨndinja Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ napomatatɨ japɨhɨ nepasanɨhuraapo,” undatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aihɨ kingwaasɨ sisɨhoaasɨnɨ Eraijaaho noaipatɨ Jisaasihoai pɨwaundihɨ iwinjahohɨtɨhandapɨ gwɨnyapenawaawɨ Jisaasihoai saundɨwɨ nunjenawaayopo. “Isɨhiya wɨnɨhapɨpa katɨwunjohiyɨhiya satɨwɨ katohɨtɨndɨ Isɨhiyai Japɨhɨ Numwaatɨ Iwinjatɨtandɨ Autaahaatɨho Ahɨwisɨho napɨtandɨ detɨtanɨhɨ komɨ jɨhɨ Eraijaaho napɨtaise tohɨtɨndɨ napaapɨ topo?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nunjenɨhauhɨ amɨ Jisaasiho komɨha kingwaasi saundataase. “Ye, sa akaahaare. Akaahaasɨ Autaahaatɨho jɨhɨ Eraijaahoai natausaasonɨhɨ nasatɨ komɨ Utaaho ipotɨ natausaasɨtandɨhopɨ kahapaamapɨpa netɨ tɨtɨhemwaitandɨ gwɨnyaatɨ katihɨhaapɨ topo.” ");
INSERT INTO agm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sata katihɨhaapɨ towɨ amɨ nɨnɨ sangi wanɨ kɨmandɨ kasatataato. “Utaaho wo Eraijaahopɨ nanɨpimatɨ aimɨ napise. Aimɨ napihɨ isɨhiya koaisɨ wɨndɨ baiwɨ usowɨ namumwaapɨ nehɨ kiya sawanaamɨ gwɨnyapehohɨrɨhɨretɨ nepɨ mɨmaipɨwiwɨ kawisopo. Koai saiwɨ mɨmaipɨwisowɨ sɨrɨ kɨretɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonisangi isɨhiya katɨ kanitaapo,” undatɨ komɨ otɨpɨpatɨhingwaasi kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Saundihɨ komɨ otɨpɨpatɨhingwaasɨ kingwaasɨ Jisaasiho nyangi sanyatindɨmandɨ Jonɨho Isɨhiyai Baawusisɨhopɨ nyatise tɨwɨ gwɨnyaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aihɨ Jisaasiho komɨ otɨpɨpatɨhingwaasisatɨ mɨhaapɨ sisɨhomɨ auhɨraapɨhɨ noaatɨpapɨ nuwɨ noaipawaayopo. Nuwɨ noaipapɨ isɨhiya wɨrɨsandɨhandɨ sapɨhɨ bitohauhɨ iwinjawaayopo. Iwinjahauhɨ utaaho wo nasatɨ Jisaasihomɨ utatototɨ tɨmahiyatɨ atotɨpɨwesataise. ");
INSERT INTO agm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Iyatɨ Jisaasihoai saundataase, “Awaisɨhoŋe, kɨnyɨ nisɨ metɨhoai maarɨho asɨpɨnɨwime. Ko apɨpaahɨ naharisa taatɨ tɨmahiya nepatɨ asisɨha wiwetɨ sisɨhaapɨhɨ tɨmahiya tɨhoaatatɨ amɨ wiwetɨ osetetɨ tɨmahiya tɨmandaatatoandaahoso. ");
INSERT INTO agm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aihɨ nɨnɨ kinyɨ otɨpɨpatɨhiya nepɨ tɨtɨhɨwiwɨtondɨ koai numwaasi niyonɨhɨ kiya wɨndɨ nepɨ tɨtɨhɨmaawihowo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Undihɨ Jisaasiho komɨha isɨhiya atitaatɨwɨ saundataase. “Sahɨ isɨhiyaatɨ nisapɨ apɨpaahɨ maipɨhonjɨsangi gɨmaanunyaapɨ asɨretɨ gwɨnyapepɨhiyaate. Sangisatɨ nɨnɨ asisɨha kɨnaungwɨha napitaindɨhaiwaara bimaamɨ naisanɨhɨ sahɨ nisɨ watɨpɨhaiwaapɨ gɨnunyaitaatɨwe? Sahɨ siyohɨtɨmandapɨ nehɨ jainjaatɨ nɨnɨ sangisatɨ konɨnɨhɨ bimaamɨ nutando? Metɨhoai kɨmbɨhɨ nɨngi numwaasipɨwɨninyawɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Undihɨ metɨhoai numwaasi koaapɨhɨ nasawaayopo. Iyauhɨ Jisaasiho itɨpɨho maipɨho metɨhomɨhatɨhɨ bimisɨhoai nehɨhaatɨ noaipasi pɨnumwe undihɨ itɨpɨho metɨhomɨhatɨhapɨ noaipasi nehɨhaatɨ notaise. Noaipasi naihɨ nehɨ ketɨ kuraanɨhɨ metɨho tɨtɨhitataise. ");
INSERT INTO agm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ yawanaanɨnɨ Jisaasihoaisaatɨ bindɨhaawɨ koai saundaatɨ nunjenɨhaayo. “Itɨpɨho soai nyahɨ napindapɨ nehɨhaatɨ wɨndɨ newa yamoto?” undɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Saundaatɨ nunjenɨhonɨhɨ ko nyangi sanyatataase. “Sahɨ itɨpɨho nemaamahohɨtɨndɨ sandɨ apaapɨmaahe, samɨ nisapɨ gɨnunyaahohɨtɨhandɨ maipɨhonjɨ masɨhonjɨndaate. Isɨ kɨmandɨ kasatɨtaanɨ baiwɨ gwɨnyaapɨse sahɨ nisapɨ gɨnunyaahohɨtɨhandɨ ipatamɨ yandɨpɨho apɨpaahɨ turɨkaarehonjɨ nutatɨ ipatɨ awaipatɨtipatamataiwɨ awaindemawaawaahɨ watɨpɨhaiwa kaitaapo. Aiwɨ sahɨ kɨmo sisɨmoai saundɨwɨ nga kaundɨtaapo. ‘Sisɨmoŋɨ kɨmbɨhɨ namasi sapɨhapɨ numwe,’ undisaihɨ amɨ ko atɨsisatɨ dosi nutaise. Aiwɨ amɨ sahɨ kahapaamapɨpa watɨpɨhaiwa nahatewa nga kaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Iyataatɨ itɨpɨho maipɨho siyahoai nehɨ pɨwɨha wɨndɨ nemaamaitaise. Gaapɨpatɨ waatɨ andɨtitɨwɨ gaapundɨwɨ amɨ nandapa onaiwɨ Autaahaatɨhoai gɨwusehohɨtɨhandaahɨhɨ nemaitaise,” nyatatɨ Jisaasiho komɨ otɨpɨpatɨhiyaanangi kanyatataase). ");
INSERT INTO agm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Aihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ Jisaasihoaisaatɨ yapɨpatɨ Garirihanda daayaatɨ bitotɨhaawɨ Jisaasiho nyangi sanyatataase. “Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨhi nɨwahonisɨ isɨhiya Judaahiya nepɨ wɨnirapɨ nanɨmaasi nuwɨ isɨhiya usa Romɨhandaahapɨhiyaamɨ ikwɨraatɨhɨ ahɨnitaapo. ");
INSERT INTO agm_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Aisaihɨ isɨhiya Romɨhandaahapɨhiya nɨngi sohonɨnɨhi nɨwɨtaapo. Sohonɨnɨhi nɨwisaihɨ napomatatɨhonɨnɨ konɨnɨ amɨ asisɨha mairɨ metɨ Autaahaatɨho ahonimatɨ japɨhɨ nanɨmaahonɨhɨ nepaito,” nyatataase. Sanyatihɨ nyahɨ komɨ otɨpɨpatɨhiyaanangi maarɨho apɨpaahɨ yaasanyisatɨ nyatataise. ");
INSERT INTO agm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ Jisaasihoaisaatɨ aunahɨpatɨ Kapaniyaamɨhanda nasawaatɨ noaipɨhaayo. Nasawa noaipahonɨhɨ aŋɨ awaindɨhandi nawɨho kɨnaungwɨha nɨnaasetɨ iwinjatɨtandɨho nehohiyɨhiya noaipapɨ Pitaahoai saundɨwɨ nunjenawaayopo. “Sangi katasɨsisɨho aŋɨ awaindɨhandamɨ otɨpɨpati nawɨho nunyahonaahoesɨ akɨto?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nunjenɨhauhɨ Pitaaho kiyai saundataase. “Ye nunyahore,” undatɨ kiyai kaundataase. Kiyai saundamapɨ aŋɨpɨpɨhɨ Jisaasiho bimimbɨpɨhapɨ notaise. Notɨ nandaasɨhɨ Jisaasiho Pitaaho nunjendandɨ gwɨnyaapɨ napisɨha aimɨ mmonatosatɨ jɨhɨ tɨpwɨhɨwatɨ Pitaahoai saundatɨ nunjenataise. “Saimonɨhoŋe, kɨnyɨ napitaimbɨ gwɨnyaapaise? Mambɨ isɨhiya awaisawɨhiya gamanɨhiyai isɨhiya dɨndiyaanɨhɨ nawɨho takisihandɨ tɨmapɨ nunyawaayopo? Isɨhiya awaisawɨhiya gamanɨhiyaamɨ yapɨpataahapɨ sawanaamɨ isɨhiyaaro e isɨhiya wɨtaahapɨhiya kiya urɨpatiwɨ iwinjaawɨ bimohiyɨhiyaaro?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aihɨ Pitaaho komɨha saundataase. “Isɨhiya yapɨpatɨ wɨtaahapɨhiyaahɨhɨ isɨhiya usa awaisawɨhiya gamanɨhiyaimatɨwɨ kiyaisɨ urɨpatiwɨ winjaawɨ bimohiyɨhiyai nawɨho takisihandɨ nunyawaayopo,” undatɨ Pitaaho Jisaasihoai kaundataase. Undihɨ amɨ Jisaasiho Pitaahoai saundataase. “O amɨ isɨhiya awaisawɨhiya gamanɨhiyaamɨ yapɨpataahapɨhiya nawɨho takisihandɨ wɨndɨ gamanɨhiyai tɨmapɨ namumwisaihaahɨ yahuraaŋɨ Autaahaatɨhomɨ mwaahuraaŋɨsɨ nawɨho nanyɨsehohɨho wɨndɨ namumwɨtɨhaawono? ");
INSERT INTO agm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Namumwɨtɨhatɨ katɨ yɨhoaaŋɨ wiwa saisaihɨ kiyai yɨhoaanyapɨ apowɨtaisɨ gaasɨ numwɨtɨhaawo. Isɨ kɨnyɨ durɨhɨrainɨ numbwɨ araihopɨ wɨrɨhɨrɨ ukɨhɨrɨ wɨrapɨ tɨmape. Tɨmapɨ yeye tɨpɨ araiho nohingomɨ maahomwaaŋɨ nawɨho windɨtaise. Windisɨho so kɨnyɨ noaapɨ maisɨhoaanyapɨ gaatɨtaisɨ ko nesi naimbɨ aŋɨ awaindɨhandapɨ nawɨho nehohiyɨhiyai nanyunye,” undatɨ Jisaasiho Pitaahoai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aihɨ sura kuraanɨhɨ nyahɨ komɨ otɨpɨpatɨ mmona newaatɨ kiyaatɨ nuwipinjohiyɨhiyaanɨnɨ usaanɨnɨ nasaatɨ Jisaasihoai saundaatɨ nunjenɨhaayo. “Autaahaatɨho isɨhiyaanangi nyainja bimindɨmandaatɨhɨ dɨndiyaanɨhɨ awaisawɨhiyaimatɨtondɨho?” undaatɨ nunjenɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Saundaatɨ nunjehonɨhɨ Jisaasiho metɨwonji gaata numwaatɨ nyamɨ ndɨmaahomwaaŋɨ netɨ ahɨwihɨ bitondaise. ");
INSERT INTO agm_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Aihɨ Jisaasiho nyangi sanyatataase. “Nɨnɨ sangi kɨmandɨ akɨtɨnɨhɨ kasatataatonɨ sahɨ baiwɨ gwɨnyaapɨse. Sahɨ samɨ omaŋɨtɨtɨhapɨ sawanaatapaahɨhɨ genanɨwɨ gwɨnyaahohɨwaiwa wɨndɨ namemapɨ manyinyaamataiwɨ ipatisanɨwɨ gwɨnyaapɨ kamaayawaawaahɨ Autaahaatɨho wɨndɨ sangisɨ jainjaatɨ bɨmimɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Iyataatɨ isɨhiya usa kɨmonjɨ metɨmonjamataiwɨ yatɨhɨ ipatisanɨwɨ gwɨnyaapɨ kiyohiyɨhiya siya Autaahaatɨho isɨhiyai iwinja bimindɨhandaatɨhɨ awaisawɨhiyaimatɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Iyataatɨ isɨhiya usa nɨngisɨ maarɨho naninyawaawɨ kɨmonjɨ metɨmonjamataiwɨ yatɨhɨ ipatisanɨwɨ nisapɨ gɨnunyaahohiyɨhiya usai numwaapɨ iwɨtatamanawaawaahɨ nɨngi nanɨmaawaayopo,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Sanyatatosa Jisaasiho pɨwɨha wa satatɨ kanyatataase. “Isɨhiya nisapɨ manyinyaamataiwɨ nanɨhaiwɨ gɨnunyaahohiyɨhiyai isɨhiya usai daihɨra asɨra maipɨhaiwaatɨhɨ kaiwa kaitaatɨwɨhɨra numwaasi nowaawɨ siyohiyɨhiya Autaahaatɨho kiyai sisɨhaapɨhɨ netɨ tɨhoaitandɨhandɨ naitaawɨ kiyaisɨ jɨhɨ nawɨha apɨpaahɨ aungwohandɨ nahwɨtarɨhɨraapɨhɨ wɨrapusosawɨ nahusaapanɨwɨ osetetɨ bomaitaatɨwɨ ngaatɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Ese isɨhiya yapɨpatambɨhiya kahapaamapɨpa maipɨhaiwa kiyohiyɨhiya apɨpaahɨ yaawɨhaiwa maipɨhaiwa naitaapo. Iyataatɨ isɨhiya mambɨhiya andɨtatɨ napamapɨ maipɨhaiwaatɨhɨ jinjahɨra isɨhiya usaisɨ numwaasi nuwɨ kaitaapo. Kiya saiwɨ kaisaihɨhandɨ kandɨ sahɨ kiyaamɨhɨretɨ winjapepihɨrɨwɨ isɨhiya usaisɨ maipɨhaiwaatɨhɨ numwaasi namuwɨse. O numwaasi nowaawaahɨ sahɨ apɨpaahɨ maipɨhaiwa yaasɨhaiwa naitaapo. ");
INSERT INTO agm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Iyataatɨ kinyɨ ikwɨrɨ auhɨrɨ wɨrɨ maipɨhaiwa kaitaapɨhɨra daihɨra gisɨ nangɨmaasi niyonaahɨ kɨrɨ otipapɨ yotɨme. Saimbɨ ikwauhatɨmurɨ wɨtɨmurɨ otipapɨ yotapaapɨ nehɨ wɨtɨmurisapaahɨhɨ jinjapɨhɨ bimɨtaapɨhandɨ baimbɨ nga naitaapo. O saimbɨ otipapɨ yamotɨpɨ ikwauhɨrɨ nahatewa isɨpɨ maipɨhaiwa kiyapaapɨ apɨpaahɨ yaasɨhaiwa maipɨhaiwa nepɨ sisɨha kaanɨhɨ tɨhatoaatisɨhaapɨhɨ nutaino. ");
INSERT INTO agm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Iyataatɨ amɨ kinyɨ ndɨha wa daihɨra maipɨhaiwa kaitaapɨhɨra nangɨsamɨ niyonaahɨ ka namwaapɨ yotɨme. Saimbɨ ndɨha wa namwaapɨ yotapaapɨ nehɨ wa naasaisapaahɨhɨ jinjapɨhɨ bimɨtaapɨhandɨ baimbɨ nga naitaapo. O saimbɨ ndɨha daihɨra maipɨhɨra nangɨmaasi naisɨha namwaapɨ yamotɨpɨ mairɨ isɨpɨ maipɨhaiwa kiyapaapɨ apɨpaahɨ yaasɨhaiwa maipɨhaiwa nepɨ sisɨha kaanɨhɨ tɨhatoaatisɨhaapɨhɨ nutaino. ");
INSERT INTO agm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Isɨ isɨhiya manyinyaamataiwɨ nanɨhaiwɨ napaisaatɨ gɨnunyaahohiyɨhiyai sahɨ wɨndɨ tipɨ gwamwaapɨwɨse. Amɨ Nisɨ Apɨho komɨ yamɨhapataatɨhapɨ otɨpɨpatɨhiyai natausaasihɨ nuwɨ napɨwaiwɨ kiyaisɨ iwinjaawɨ bitotawaayopo. Winjaawɨ bitotawaawɨ kiyaisɨ wapa nusoaipasɨhapaapɨ Autaahaatɨhoai dɨndaahaiwɨ kaundawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Iyataatɨ amɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ isɨhiya maipɨhaiwaatɨhɨ nihɨrɨnɨwɨ owetohiyɨhiyai japɨhɨ numwaitandɨ napɨtɨhonɨne). ");
INSERT INTO agm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Sahɨ napitaiwɨ gwɨnyaawaayopo? Utaaho wo komɨ maasapɨho sipɨsipɨhandɨ taahɨtɨhandɨ 100 kiyatɨ bitohonɨho kandamɨ naasaindɨhɨ nihɨrɨnatɨ owetanɨhɨ ko napitaitaise? Sipɨsipɨhandɨ owemetatɨ 99 kiyatɨ bitosɨtɨhandi namasi sisɨhoaasɨnɨ woyɨha nanatɨ bitohonɨhɨ naasaindɨhɨ owetindɨhandapɨ ko daitandɨ nutaise. ");
INSERT INTO agm_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Daatɨ owetindɨhandi numwaataataahɨ kandɨ owetihɨ jahɨra daatɨ numwaasɨtɨndɨ sipɨsipɨhandapɨ owemetatɨ 99 kiyatɨ nga bitosɨtɨhandapɨ maaritindɨhandi nusatipɨhaatɨ apɨpaahɨ awaindɨhandɨ ko maaritɨtaise satɨtɨ akɨtɨnɨhɨ kasatataato. ");
INSERT INTO agm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sɨrɨ kɨretɨ samɨ Japɨho yamɨhapataatɨhɨ bimisɨho isɨhiya manyinyaamataiwɨ nanɨhaiwɨ napaisaatɨ gɨnunyaahohiyɨhiyaapɨ kiya apɨpaahɨ wɨndɨ nihɨrɨnɨwɨ owemetɨto tatɨ gwɨnyaataise. ");
INSERT INTO agm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Iyataatɨ amɨ utaaho wo gɨsamɨ tɨmaamaitɨmɨ nisapɨ gɨnunyaasɨho gi wapa maipɨhandɨ kahisonaahɨ kɨnyɨ koenda numbwɨ maipɨndɨ kahindɨndɨ ausaapɨ nunje. Nehɨ sawahoaahɨhɨ bindamaamɨ sandɨ kaime. Saimbɨ komɨ maipɨhandɨ ausaapɨ kaundɨpɨ nunjisamɨhɨ amɨ ko atisatɨ maarɨho asɨpiyatɨ japɨhɨ nepemaitonaahɨ kɨnyɨ kinyɨ naisohoai japɨhɨ numwaapɨ maasɨ tɨmaamaitɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","O amɨ ko kinyɨ pɨwɨha atɨhomaahisatɨ maarɨho asɨpiyatɨ komɨ maipɨhandɨ kahindɨhandɨ ausaatɨ namepemaitonaahɨ namapɨ Mosesihomɨ wɨnɨhapɨpa netɨ katirɨhɨretɨ japepihɨrɨpɨ utaaho naasohɨsangi amɨ yahurɨsangi numwaasi koenda numwe. Saimbɨ numwaasi numbwɨ bindawaawɨ kuramɨ ndɨhetɨ gi maipɨhandɨ kahisɨhoaisamɨ pɨwɨha siyaha siyahaapɨto tɨmɨ jɨhaatɨ katisaihɨ numwaasi naingururɨ atimɨ gi maipɨhandɨ kahisɨhoai maarɨho asɨpiyatɨ nepemaitɨtandɨ pɨwɨha napaisaatɨ kaundɨmɨse. ");
INSERT INTO agm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kaundisaihɨhandɨ kandɨ ko kuramɨ pɨwɨha wɨndɨ atɨhomaawisatɨ gi maipɨhandɨ kahisono hɨtatɨ wɨndɨ namepemaitonaahɨ namapɨ maipɨhandɨ kahisɨhoai numwaasi isɨhiya nisapɨ gɨnunyaahohiyɨhiya detɨ sɨhoaasangisawɨ ahoyanɨwɨ bimohiyɨhiyaamɨ ndɨhetɨ noaipapɨse. Noaipapɨ kiya nahatiya atɨsiwɨ nepɨ tipɨtapaapɨ mmowɨ tɨtɨhepɨsamaitaatɨwɨ sɨhoaasamɨ pɨwɨha ausaapɨ kaundɨmɨse. Saimɨ isɨhiya nahatiyaisɨ kaundisaihɨ maipɨhandɨ kahisɨhoai maarɨho asɨpaimbɨ nepemaite undisaihɨ namepemaitatɨ gisatunɨ kiyaisatunɨ wɨndɨ tɨmaamaamaitonaahɨ namapɨ kɨnyunɨ isɨhiya nisapɨ gɨnunyaahohiyɨhiyaunɨ kopɨ satɨwɨ gwɨnyaapɨse. “Kɨmo utaamo nyamɨhomaahe. Owetise. Koai wapɨhapɨho Autaahaatɨhopɨ wɨndɨ mmonatɨ utaaho apɨpaahɨ maipɨhoe,” tɨwɨ koaisɨnɨhɨ samɨ dawaataatemapɨse. ");
INSERT INTO agm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Iyataatɨ nɨnɨ pɨwɨha kɨma sangi kasatataatonɨ baiwɨ atiwɨse. Maapɨ yapɨpataapɨhɨ kahapaamapɨpa wapaamɨ daihɨra maasomwaaŋɨ sahɨ nepɨ nisapupwɨ napuwawaawaahɨ amɨ mɨhaatɨ yamɨhapataatɨhɨ Autaahaatɨhoaisangi netɨ satɨ katɨ kaitaise. Aiwɨ kahapaamapɨpa wapaamɨ daihɨra maasomwaaŋɨ dauta nutane tɨwɨ sahɨ nepɨ maapɨ yapɨpataapɨhɨ daupwɨ nuwawaawaahɨ mɨhaatɨ yamɨhapataatɨhɨ Autaahaatɨhoaisangi netɨ satɨ katɨ kaitaise. ");
INSERT INTO agm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Amɨ jɨhaatɨ kasatataatonɨ sahɨ atiwɨse. Samɨ utaahurɨ wurɨ maapɨ yapɨpataapɨhɨ wapa nepɨ amɨ kaitaatɨmɨhapaapɨ gwɨnyapenamaamɨ maarɨho naasohɨtanɨhɨ tɨmaamaitɨmɨ gaapundamaamaahɨ nisɨ Apɨho yamɨhapataatɨhɨ bimisɨho kurisɨ kapa nunyatɨ kawitaise. ");
INSERT INTO agm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","O amɨ sandɨ apaapɨmaato amɨ utaahurɨ nehɨ yahurisangi amɨ murɨmoaisangi ahoyanɨwɨ nisapɨ gɨnunyaapɨ nisɨ ambɨpatɨ ambɨhɨtohiyɨhiyaamɨhatɨhɨ kiyaisatɨ maasɨ nɨnɨ bindataayo,” nyatatɨ nyahɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Aihɨ Pitaaho dotɨ Jisaasihoai saunda nunjenataise, “Awaisɨhoŋe utaaho wo nisatiyatɨ Kɨraisihopɨ gɨwunyaaho nɨngi maipɨhaiwa napitiyahaiwaara kanisonɨhɨ amɨ nɨnɨ komɨ maipɨhaiwa nemwaitande? 7 kiyatɨ ikwɨrɨ wihɨtɨrɨtanɨhɨ wihɨnɨhɨramɨ yatairaaho?” undataase. ");
INSERT INTO agm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Undatɨ nunjesɨhɨ Jisaasiho komɨha Pitaahoai saundataase, “Owetise. Nehɨ 7 kiyatɨ ikwɨ wihɨtɨrɨtanɨhɨ wihɨnɨhɨramɨ yatairaahɨmaahe. Nasisoaarɨ gɨmunyaatahaiwaara kɨnyɨ komɨ maipɨhaiwa nepumwape. ");
INSERT INTO agm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Iyataatɨ pɨwɨha sa katohɨhaapɨ nesɨpatɨ mambɨhaiwaapɨ namɨhanɨtɨ katɨtandiyo. Autaahaatɨho nisɨhetapɨ isɨhiyai iwinja bimindɨhandɨ siyahande. Utaaho wo awaisɨho isɨhiyai iwinja bimisɨho isɨhiya awaisawɨhiya usa komɨ otɨtɨhɨ otɨpɨpatɨ kawisohiyɨhiya nawɨho otɨpɨpatɨ kaitaatɨwɨ nehohɨhopɨ nunjendandɨ kiyaisɨ gaata numwaataise. ");
INSERT INTO agm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nunjendandɨ wanɨ konɨhɨ taatɨ sandɨ siyataatɨ utaaho wo nawɨho ikihɨ apɨpaahɨ taahɨwaiwa ambɨpatɨ gɨmunyaata awɨmɨtɨwɨhaiwa nusesɨhoai gaata numwaataise. ");
INSERT INTO agm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Gaata numwaatɨ nunjesɨhɨ nawɨho ikihɨ nusesɨmumwaaŋɨ kamwaaŋɨ wɨndɨ nesi nasa namunyataise. Saihɨ komɨ awaisɨho namatɨ utaaso soai komɨ apwaataatɨ manyinyaisatɨ ahoyatɨ utaaho awaisɨho womɨ otɨpɨpatɨ nawɨho owehandɨ kaitaatɨwɨ kusasi koaisɨ nunyatɨ nawɨho naitaano ndaase. Satatɨ kusasamɨ ikɨpɨpa kahapaamapɨpa netɨ usaisɨ nunyatɨ nawɨho naitaano ndaase. Nisɨ nawɨho jahɨra naitandɨ sandɨ kaitaano ndaase. ");
INSERT INTO agm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Satatɨ katihɨ utaaso utaaho awaisɨhomɨ nawɨho ikihɨ ambɨpatɨ owehaiwa netɨ nainjɨho atisataise. Atisataatɨ komɨ awaisɨhomɨ utatototɨ tɨmahiya atotɨpɨwesatɨ gousetɨ saundataase. ‘Kɨnyɨ nisapɨ aposindɨhandɨ yatɨhitɨpɨ kinyɨ maarɨho asɨpɨnimbɨ nehɨ ninjase. Nehɨ ninjasamɨhɨ kinyɨ nawɨho netɨ nangɨnɨhohɨho otɨpɨpatɨ kaindɨ nehɨnyamɨ nundɨ owemaitaano,’ undatɨ gousetaise. ");
INSERT INTO agm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Saunda gousesɨhɨ komɨ awaisɨho maarɨho asɨpɨwisa nehɨ iwinjatɨ nawɨho ikihɨ taahɨwaiwa netɨ nɨwinjɨhopɨ saundatɨ, ‘gaasɨ kɨnyɨ namaanɨmɨtaapɨ nanɨpimatɨtɨ namaitaano,’ undataase. ");
INSERT INTO agm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Saundatɨ maarɨho asɨpɨwisataatɨ nehɨ iwinjasɨhɨ notaise. Notɨ komɨ sasaaho otɨpɨpatɨho woai iwinjataise. Iyataatɨ utaaso winjaso komɨ nawɨho sisɨwaahaipɨhandɨ naasaindɨhɨ, ‘sɨhɨ japɨhɨ nahɨmɨtaano,’ undatɨ netɨ nɨwɨnahore. Aihɨ awaisɨho maarɨho asɨpɨwisa nehɨ iwinjasɨhɨ naisoho komɨ sasaaho nawɨho maipɨhonjɨ netɨ niwinjɨhoai siyatɨ iwinjaataatɨ komɨ nahutarɨhɨrɨ netɨ nahusapanatɨ saundataase. ‘Nawɨho nanɨhingɨpɨpa jahɨra ketɨ naninye,’ undataase. ");
INSERT INTO agm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Saundihɨ komɨ sasaaho otɨpɨpatɨho namatɨ maarɨho asɨpɨnitotatɨ kaundisɨhomɨ asɨmwatɨtɨhɨ tɨmahiya saundatɨ gousetaise. ‘Ese kohɨ uta gaahonye kɨnyɨ aposindɨhandɨ yatɨhitɨpɨ maarɨho asɨpɨnime. Saimbɨ nehɨ ninjasamɨhɨ kinyɨ nawɨho nangɨnɨhohɨho jahɨra nehɨmɨtaano?’ undatɨ komɨ sasaahoai gousetaise. ");
INSERT INTO agm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Gousesɨhandɨ kandɨ jatɨtandɨ poundihɨ sasaahoai maarɨho asɨpɨmaawisatɨ daahɨ komɨ pɨwɨha nematɨ napwɨtohɨtɨhandaatɨhɨ napuwataise. Siyatɨ netɨ napusɨhɨ napwɨtatɨ otɨpɨpatɨ kaimɨ notɨ nawɨho netɨ nɨwinjɨho netɨ tiwatɨ owetanɨhura noaipasi nutando. ");
INSERT INTO agm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Aihɨ awaisɨho maarɨho asɨpɨwisatɨ nehɨ iwinjasɨho sandɨ topɨtaata sasaahoai maipɨhandɨ kawihɨ sasaahoya usa otɨpɨpatɨhiya winjawaayopo. Iwinjawaawɨ sandɨ sawindindapɨ kiyaisɨ apɨpaahɨ apousatɨ maarɨho tundaise. Siyatɨ maarɨho tundihɨ naiwɨ kiyaamɨ awaisɨhoai nahataapa noaipasɨhɨ mmohohɨpɨpaapɨ ausaapɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sandapɨ kaundauhɨ atisatosatɨ awaisɨho komɨ otɨpɨpatɨho maarɨho asɨpɨwisatɨ nehɨ iwinjasɨhoai gaata numwaatɨ saundataase. ‘Kɨnyɨ utaahoŋɨ otɨpɨpatɨhoŋɨ apɨpaahɨ maipɨhoŋe. Amɨ kɨnyɨ nehɨ ngɨpwɨnehinɨhiyataatɨ nawɨho aungwohandɨ nepɨ nanɨnɨpɨ jahɨra namaanɨmingɨhopɨ nanɨpimatɨtɨ nangɨmɨhaahonɨhoŋe. ");
INSERT INTO agm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Saindɨ gi maarɨho asɨpɨhindɨ nehɨ nangɨmɨhaahonɨhoŋɨsɨ kɨnyɨ sɨrɨ kɨretɨ kaimbɨ kinyɨ kɨsaahɨmoai maarɨho asɨpɨwimbɨ namumwɨhaapo?’ undataase. ");
INSERT INTO agm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Saundatɨ awaisɨho komɨ otɨpɨpatɨhopɨ apowihɨ isɨhiya koaisɨ ambɨpatɨ maarɨho yausahaiwa numwɨtaatɨwɨ napwɨtohɨpɨpɨhapɨ natausaasataise. Sapɨhɨ napupwɨ ambɨpatɨ yausahaiwa numwisaihɨ netɨ kaimɨ nunjatɨ awaisɨhomɨ nawɨho netɨ nɨwinjɨho netɨ tiwa owemataahuraatɨtande,” tatɨ Jisaasiho namɨhanatɨ kandaase. ");
INSERT INTO agm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Satatɨ namɨhana kata owemataatɨ kandapɨ nesɨpatɨ sanyatataase. “Amɨ sahɨ isɨhiya maipɨhaiwa sangi kasisohɨwaiwa samɨ omaŋɨtɨtɨhapɨ nepumwaamawaawaahɨ nisɨ Apɨho yamɨhapataatɨhɨ bimisɨho sangisɨ utaaho awaisɨho komɨ otɨpɨpatɨhoai kawindɨhandamatiyatɨ kɨretɨ kasitaise,” tatɨ Jisaasiho nyahɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Aihɨ Jisaasiho saiwa katatɨ owemapɨ sapɨhɨ yapɨpatɨ Garirihanda namasi yapɨpatɨ Judiyaahandamɨhatɨ waapɨhaatɨ Jorɨtanɨhaatamɨ wihɨnɨ mɨhihɨnɨ ahetipataahapɨ notaise. Naihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ maawɨ nohaayo. ");
INSERT INTO agm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nowaatɨ daayonɨhɨ isɨhiya wɨrɨsandɨhandɨ Jisaasihoenda nasauhɨ kiyaamɨ timbɨpaisahiyai tɨtɨhɨwiwataise. ");
INSERT INTO agm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Siyatɨ tɨtɨhɨwisɨhɨ daayaatɨ bitohonɨhɨ isɨhiya Parisihiya usa Jisaasihoai wapaapɨ nunjendaatɨwɨ nasawaayopo. Napɨwɨ wihoaaŋɨha ko tɨtɨhɨ kiyaisɨ wɨndɨ biyatɨ kamundonaahɨ koai nepɨ nusopɨsasɨtotɨwɨ winjatawaawɨ Jisaasihoai saundɨwɨ nunjenawaayopo. “Kahapaamapɨpa nahataapa wapa gwɨnyapenataahapaapɨ utaaho wo komɨ apwaataati apɨpaahɨ namatɨ kaatisɨnɨhɨ netɨ natausaasɨtandɨ gaaro e owetiso?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Saundɨwɨ nunjenɨhauhɨ Jisaasiho komɨha sata kaundataase. “Autaahaatɨhomɨ pɨwɨha sataha awɨtɨwɨhiyaatɨsɨ sahɨ wɨndɨ gɨmunyaahowo? ‘Jɨhɨ aimehura yeyetatɨ isɨhiyaisɨ kiyatɨ namasisɨho wohoaisɨ apopaatapɨ kiyatɨ ahɨwisatɨ apopaatisɨ wohopɨ kiyatɨ ahɨwisataise’. ");
INSERT INTO agm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Iyatɨ amɨ sandɨ siyatɨ woho apopaati ahɨwindɨmandapɨ Autaahaatɨho sandaase. ‘Wohorɨ saniyɨ sapiyai namasisɨ apopaati nɨwipaahonɨhɨ namaatɨmɨ tɨmaamaitɨtaise.’ ");
INSERT INTO agm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Isɨ kasanyurɨ yasasanyurɨmaahe, owetise. Kasanyurɨ tɨmaamaitɨmɨ noaipapɨ kasanyuramɨ maarɨho ambɨpatɨ naasaipɨhɨndaise. Isɨ amɨ Autaahaatɨho aimɨ woho apopaati netɨ tɨmaamaisɨtɨhandɨ isɨhiya wɨndɨ nepɨ namaasɨpapɨse,” undatɨ Jisaasiho Parisihiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jisaasiho kiyaisɨ saundihɨ Parisihiya koaisɨ saundɨwɨ nunjenawaayopo. “O siyonaahɨ Mosesiho jɨhura wɨnɨhapɨpa napindapɨ satatɨ katise?” Utaaho wo komɨ apwaataati namaitandaahɨ ko utɨpɨho apwaataati namaitandɨ kaati nanɨmasi numwe undaho jɨpatɨpiya nunya kaati netɨ natausaasane tatɨ katise?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Saundɨwɨ nunjenɨhauhɨ Jisaasiho komɨha kiyai saundataase. “Sandɨ Mosesiho wɨnɨhapɨpa watɨpɨhapa kandaamaase, owetise. Nehɨ sawanaatamɨ atihɨrɨ nawaatɨmapɨ maatɨmaatisohɨtɨhanda gaasɨ sɨwaasisai utɨpɨho nunyawɨ namapɨse tatɨ katise. Iyataatɨ sahɨ siyohɨtɨndɨ jɨhɨ aimehura woho apopaati ahɨwisataatɨ Autaahaatɨho gwɨnyapenatɨ ahaihɨ ahotɨmɨ napindɨhandɨmaahe. Owetise. ");
INSERT INTO agm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Isɨ sangi kɨmandɨ nɨnɨ kasatataatonɨ atiwɨse. Utaaho wo komɨ apwaataatɨ utaaho woaisatɨ namohaati namatɨ waatisɨ netɨ wɨrataataahɨ so komɨ apwaataatɨ jɨhaatisamɨ tɨmaamaitɨmɨ maarɨho ambɨpatɨ naasaindɨtindɨhandɨ netɨ nasɨpataise,” undatɨ Parisihiyai Jisaasiho saundihɨ kiya pɨwɨha owetihɨ namasi nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Namasi niyauhɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ saundɨhaato. “O amɨ utaaho wo apopaatisamɨ tɨmaamaitɨtaatɨmɨhapa sapa wɨnɨhapɨpa watɨpɨhapa ahotanaahɨ gaasɨ isɨhiya wɨndɨ namaamaatɨto,” undɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Undonɨhɨ Jisaasiho nyangi sanyatataase. “Nisɨ pɨwɨha woho apopaatɨ andɨtitɨmɨ tɨmaamaitɨtaatɨmɨhandapɨ kandɨsasohɨma isɨhiya nahatiya atiwɨ nepɨ kamaitaapo. Nehɨ isɨhiya Autaahaatɨho kiyaamɨ maarɨho ambɨpatɨ napaisaatumwatɨ andɨtɨwihonɨhiyaahɨhɨ atiwɨ nepɨ kaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Iyataatɨ isɨhiya usa namaamaatohɨtɨndɨ apaapɨmaahe, amɨ isɨhiya usa saniyaamɨ gwɨsɨhaatɨhapɨ namaatɨwɨ sɨhɨmwaamoyaitaatɨwɨ waapoho owehiya napɨwɨhiyaare. Amɨ usa kiyaisɨ isɨhiya usa nepɨ paatonɨho napaapɨ nusopɨsasauhɨ kandapɨ namaamaatawaayopo. Aiwɨ amɨ isɨhiya usa sawanaamɨ maarɨhoraahɨ nehɨ Autaahaatɨho iwinja bimonɨhɨ komɨ otɨpɨpatapaahɨhɨ jinjapɨhɨ asisɨha nahatewetɨ andɨtitɨwɨ gwɨnyaitaatɨwɨ namaamaatawaayopo. Isɨ utaaho wo andɨtatisahondaataahɨ nisɨ pɨwɨma sangi kandɨsasohɨma isɨwatɨ japepihɨrane,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Aihɨ isɨhiya usa manyɨnyai Jisaasiho ikwɨrɨ ahɨwisa gaapɨwundonɨhɨ Autaahaatɨho kiyaisɨ maarɨho wɨwisɨtɨhandɨ naitotɨwɨ Jisaasihoenda numwaasi nasawaayopo. Numwaasi nasauhɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ itɨhundaatɨ nɨwisapuwɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Siyaatɨ itɨhundonɨhɨ Jisaasiho sandaase, “Manyɨnyai wɨndɨ namaawisapupwɨ kiya nisenda napɨtaatɨwɨ nehɨ iwinjasawɨse. Isɨhiya manyɨnya kɨmiyaamataiwɨ nisapɨ nanɨhaiwɨ gɨnunyaahohiyɨhiya Autaahaatɨho isɨhiyai iwinja bindataatɨ gaahaiwa kawiwaiwa kiyaamɨhaiwaatɨtaiso,” daase. ");
INSERT INTO agm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sata katatosatɨ manyɨnyaisɨ ikwɨrɨ ahɨwisa Autaahaatɨho maarɨho wɨwisɨtɨhandɨ nunyataise. Nunyamapɨ sapɨhɨ namasi notaise. ");
INSERT INTO agm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aihɨ asisɨha waara utaaho wo nasatɨ Jisaasihoai saunda nunjenataise. “Katɨpunjingɨhonye, gaahandɨ napindɨ kiyataatɨ nɨnɨ Autaahaatɨhoaisatɨ bimɨtandɨhandɨ naitande?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Saundatɨ nunjesɨhɨ Jisaasiho koaisɨ saundataase. “Kɨnyɨ nɨngi gaahandapɨ napindapɨ nanɨsehise? Nehɨ Autaahaatɨho sawaho naasohɨ sohɨhɨ gaahore. Isɨ kɨnyɨ Autaahaatɨhoaisapɨ jinjapɨhɨ bimɨtaapɨhandɨ naitaapaahɨ Autaahaatɨhomɨ wɨnɨhapɨpa baimbɨ gwɨnyaapɨ japepihɨrɨme,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Undihɨ amɨ utaaso Jisaasihoai “wɨnɨhapɨpa maahɨwapaare?” undatɨ nunjenataise. Saundatɨ nunjesɨhɨ Jisaasiho komɨha koaisɨ saundataase, “Wɨnɨhapɨpa kɨmbaapɨto: ‘isɨhiyai timaamape. Asɨhiyai ikomaanɨme. Wapa isɨhiya usaamɨhapa ikomaawɨnɨme. Isɨhiya usaapɨ jaipɨmaatɨme. ");
INSERT INTO agm_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kɨniyɨ gapiyai baimbɨ atɨwimbɨ maarɨwitɨpɨ gaahaiwa gɨwunyaapɨ kawime. Aimbɨ kɨwahonyapɨ maaritɨpɨ maarɨho namɨnɨhingɨpatamataimbɨ kinyɨ naisohopɨ maaritɨpɨ koaisɨ maarɨho nunye,’ timbɨpaapɨto,” undatɨ Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jisaasiho saundihɨ uta waimwaaso koaisɨ saundataase. “Wɨnɨhapɨpa saiwaahɨ aimɨ taatɨ japepihɨrataahonɨne. Japepihɨrataahonɨnisɨ wapa napaapɨ nausetɨndaayo?” undataase. ");
INSERT INTO agm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Saundihɨ Jisaasiho koai saundataase, “Amɨ kɨnyɨ jinjapɨhɨ bimɨtaapɨhandɨ nenoaahɨtindɨhandɨ nepɨ watɨpɨtɨpɨ isɨwatɨtaapaahɨ kɨnyɨ kinyɨ ikɨpɨpa usaisɨ nepunyapɨ nawɨho nepe. Aimbɨ nawɨho nehingɨho isɨhiya ikɨpɨpa owehiya taanahiyɨhiyai nunye. Saimbɨ nunyapaapɨ kɨnyɨ yamɨhapataatɨhɨ ikɨpɨpa nepɨ ahoaitaapo. Saiwa saimbɨ nɨngi kɨnyɨ nambɨ nanipinje,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jisaasiho saundihɨ uta waimwaaso atisataatɨ komɨ maarɨho apɨpaahɨ naaŋawisaho notaise amɨ ikɨpɨpa taahɨwaiwaisahondaato. ");
INSERT INTO agm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Naihɨ Jisaasiho nyahɨ komɨ Otɨpɨpatɨhiyaanangi sata kanyatataase. “Nɨnɨ sangi akɨtɨnɨhɨ kasatataato, isɨhiya ikɨpɨpa taahɨpɨpaisahiya kapaisaahɨhɨ maarɨho nunyawɨ anɨtiwɨ isɨwatohiyɨhiyai Autaahaatɨho winja bimonɨhɨ noaipapɨ komɨhiyaimatɨtaatɨwɨ naaŋamaitaise. ");
INSERT INTO agm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iyataatɨ amɨ sawanaatɨ aimɨ mmohohɨtɨhande, maasapɨho awaisɨho kamerɨhandɨ amɨ kauhoaisangi onepatɨ maipɨhinjaatɨhɨ nandaitotatɨ dinanataatɨ apɨpaahɨ watɨpɨtihɨ wɨndɨ namɨndaasɨtɨhande. Nandaitandɨ watɨpɨtindɨhandisɨ isɨhiya ikɨpɨpa taahɨpɨpaisahiya kapaisaahɨhɨ maarɨho nunyawɨ anɨtiwɨ isɨwatohiyɨhiyaisɨ Autaahaatɨho iwinja bimonɨhɨ noaipapɨ komɨhiyaimatɨtaatɨwɨ apɨpaahɨ awaindɨhandɨ watɨpɨtamaitaise,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jisaasiho sa sanyatihɨ atisɨhaawɨ nyahɨ mangɨrɨ ikwɨnaatɨ yayahaawɨ satɨhaato. “Ese siyonaahɨ isɨhiya diyaanɨhɨ jinjapɨhɨ bimɨtaatɨwɨhandɨ nga naitaapo?” tahaato. ");
INSERT INTO agm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sataatɨ katonɨhɨ Jisaasiho yatɨwatɨ nyainjatataatɨ sanyatataase, “Isɨhiya mambɨhiya sawanaamɨ watɨpɨhandɨ gwɨnyaahohɨtɨhanda jinjapɨhɨ bimɨtaatɨwɨhandɨ naitaatɨwɨ apɨpaahɨ naaŋa watɨpɨtatɨ owendaise. O amɨ Autaahaatɨho sawahohɨ nahatewa tɨtɨhɨ nga kaitaise,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sanyatihɨ Pitaaho Jisaasihoai saunda nunjenataise, “Mmonɨpeme, nyahɨ kahapaamapɨpa nahandɨ namasisɨ gisɨ nahipinjɨhaayo. Nahipinjɨhaayonɨ nyahɨ napindɨ naito?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Saundatɨ nunjesɨhɨ Jisaasiho nyangi sanyatataase. “Kɨmandɨ akɨtɨnɨhɨ nɨnɨ sangi kasatataato, kahapaamapɨpa nahataapa Autaahaatɨho netɨ japɨhɨ asɨpɨpemaitandɨhura Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ nisɨ saasanotindɨhandɨ watɨpɨhandisatɨ Autaahaatɨhomɨ isɨhiyai winja bimisanɨhɨ sahɨ nɨngi nanipinjohiyɨhiyaatɨ nɨngisawɨ maawɨ Autaahaatɨhomɨ isɨhiyaisɨ iwinjaawɨ bimɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Iyataatɨ isɨhiya nahatiya usa naasohɨ naasaamɨhɨ nisapimatonɨhɨ kiyaamɨ aŋaaŋɨ saaho saingoya sanaanɨ sanaapwɨsa saniyɨ sapiya mwaaya maatiya yapɨpatɨ kahapaamapɨpa namatɨ kapaisɨ dawaatumwataataahɨ kokaati nɨnɨ kapaapɨ nanɨpimatɨ asakaindɨ tiwatɨ nyepaindɨ numwisanɨhɨ amɨ kokaatɨ jinjapɨhɨ bimɨtandɨhandɨ naitaise. ");
INSERT INTO agm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Iyataatɨ amɨ ipotɨhura Autaahaatɨho nisɨhetapɨ komɨ isɨhiyai winjaatɨ bimonɨhura isɨhiya taahiyɨhiya wanɨmura noaipapɨ ambɨpatisahiya apɨpaahɨ awaisawɨhiyaimatɨwɨ jɨhɨtohiyɨhiya sɨhɨhura noaipapɨ ipotɨtisaihɨ amɨ isɨhiya taahiyɨhiya wanɨmura noaipapɨ apɨpaahɨ nehɨhatɨma ambɨpatɨ owetatɨ ipotɨtohiyɨhiya sɨhɨhura noaipapɨ jɨhɨtɨtaapo,” tatɨ komɨ Otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Aihɨ Jisaasiho nyahɨ koaisɨ nɨwipinjaatɨ komɨ otɨpɨpatɨ mmona kiyaatɨ nehohiyɨhiyaanangi pɨwɨha wa namɨhana sanyatataase. “Autaahaatɨho nisɨhetapɨ isɨhiyai iwinja bimindɨhandɨ siyahande: utaaho wo wainɨhandamɨ osaataatɨ asakiyatɨ taahɨwaiwaisahomatiyahande. Iyatɨ ko osaataatɨ wanɨhandamɨ satɨho asisɨhaatɨhɨ koho koaisatɨ nepasi notɨ komɨ osaataatɨ otɨpɨpatɨ kawitaatɨwɨhiyaisɨ daatɨ numwaataise. ");
INSERT INTO agm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Numwaatɨ pɨwɨha kiyaisatɨ wɨsasatɨ saundataase, ‘Nawɨho ipɨho naasoetɨ nunyohɨmumwaaŋɨ nasamɨtaanɨ sahɨ nuwɨ nisɨ wainɨhandamɨ osaataatɨ otɨpɨpatɨ kaniwɨse,’ undatɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Iyatɨ amɨ ipɨho nasatɨ wonjɨ otɨhɨtihɨ ko isɨhiya ahoyanɨwɨ nahoaiwɨ pɨwanɨwɨ otɨpɨpatapɨ daahopɨpɨhɨ notaise. Notɨ isɨhiya usa maanɨmaanaiwɨ nehɨ bitohauhɨhiyai iwinjataise. ");
INSERT INTO agm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Iwinjataatɨ kiyaisɨ saundataase, ‘Sangisangi nisɨ wainɨhandamɨ osaataatɨ otɨpɨpatɨ kanitaatɨwɨ nuwɨse. Nawɨho tɨtɨhɨ nga nasamɨtaano,’ undataase. ");
INSERT INTO agm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Saundihɨ kiya atiwɨ nowaayopo. Aihɨ ipɨho otɨhasɨnɨtihɨhuraunɨ amɨ yaataatiwatɨ kwaatanaipatɨ koho nainjura ko naasaipitɨ katɨ kiyatɨ isɨhiya usaisɨ numwaatɨ komɨ osaataatapɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Aihɨ ipɨho kwaatanaipatɨ koho nanatɨ aimɨ satotɨ mɨhepɨ nipatɨtandɨhepɨtihɨhura ko isɨhiya ahoyanɨwɨ kahapaamapɨpa nunyawɨ nehohɨpɨpɨhɨ jahɨra notaise. Jahɨra notɨ isɨhiya usa kapɨhɨ kiyaanɨhɨ bitohauhɨ iwinjataise. Winjataatɨ kiyaisɨ saundatɨ nunjenataise. ‘Sahɨ ipɨmo pɨtɨtaatɨwapɨ kɨmbɨhɨ nehɨ napindapɨ bitohopo?’ undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Saundatɨ nunjesɨhɨ kiya koai kiyaamɨha saundawaatopo. ‘Utaaho wo nyangisɨ otɨpɨpatapɨ namaanyamaasɨhiyahaawɨ nehɨ bitotɨhaayo,’ undawaatopo. Saundauhɨ komɨha kiyaisɨ saundataase, ‘O kiyonaahɨ sangisangi nisɨ osaataatɨ otɨpɨpa kanitaatɨwɨ nuwɨse,’ undatɨ netɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Aihɨ ipɨho aimɨ tipatetɨ nipatihɨhura osaataatamɨ satɨho utaaho wo komɨhapai iwinja bimisɨhoai saundataase. ‘Otɨpɨpatɨ kanisohiyɨhiyaisɨ gaatɨpɨ numwaapɨ nawɨho nunye. Nunyapaapɨ saimbɨ nunye namasapɨ isɨhiya ipotɨnɨhɨ numwaahohiyɨhiyai nawɨho jɨhɨ nunyapɨ nunyamɨ numbwɨ jɨhɨnɨhɨ numwaahohiyɨhiyai nawɨho ipotaataatɨ nunyapɨ namɨhaape,’ undataase. ");
INSERT INTO agm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aihɨ isɨhiya ipɨho kwaatanaipatɨ koho nanatɨ owetihɨ mɨhepɨ satotɨ nipatɨtandɨhepɨtihɨ numwaasawɨhiya naasohɨ naasohɨ nawɨho ipɨ naasoetɨ nehohɨho newaayopo. Saiwɨ isɨhiya wura wura numwaasawɨhiyaisangi nehɨ naasaimumwaaŋɨ newaayopo. ");
INSERT INTO agm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aihɨ isɨhiya jɨhɨnɨhɨ asisɨhaatɨhɨ koho koaisa numwaasawɨhiya nawɨho naitaatɨwɨ nasawaawɨ awaisɨho wamwaaŋɨ naitotɨwɨ gwɨnyaapɨ nasawaayopo. Saiwɨ gwɨnyaapɨ napɨwɨhandɨ kandɨ kiyaisangi nehɨ kamwaaŋɨ isɨhiya kiyaamɨ ipotɨnɨhɨ nasohiyɨhiyaamataiwɨ nawɨho ipɨho naasoetɨ nehohɨho nɨnaasohɨ nɨnaasohɨ newaayopo. ");
INSERT INTO agm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Saiwɨ nawɨho newaawɨ isɨhiya jɨnɨhɨ koho koaisa numwaasawɨhiya nawɨho awaisɨho namehono tɨwɨ osaataatamɨ satɨhoai mehundɨwɨ saundɨwɨ itɨhundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Isɨhiya kɨmiya ipotɨnɨhɨ asɨhataahura numwaahɨnɨhɨ otɨpɨpatɨ masehonjɨ etɨtaatiyauhɨhiyai nyahɨ ipɨho pɨtɨtaatɨmawaatɨ dawaarɨhɨretɨ ipɨho nyatihɨ otɨpɨpatɨ awaindɨhandɨ kiyohiyɨhiyaanangi nawɨho nauratɨhaimbɨ naninyapaise,’ undɨwɨ itɨhundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Saundɨwɨ itɨhundauhɨ kiyaamɨ woaisɨ osaataatamɨ satɨho saundataase. ‘Uto atime nɨnɨ gisɨ wɨndɨ mɨmaipɨmaahiso. Amɨ kɨnyɨ nawɨho ipɨho naasoetapɨhopɨ otɨpɨpatɨ ipɨho naasohɨ kaitaano tɨpɨ aaye tingɨtɨhande. ");
INSERT INTO agm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Isɨ kɨnyɨ nawɨho nesi aŋɨpɨpɨhapɨ numwe. Nehɨ nɨngisunyaatɨ utaaho ipotɨnɨhɨ numwaahohɨhoaisangi nawɨho gi nahinyohɨpatamataindɨ naurataindɨ numwɨtandiyo. ");
INSERT INTO agm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nisɨhandɨ nɨwahonisɨhandisɨ nisɨ watɨpɨhandaahɨ gwɨnyapenɨtɨ nisɨ nawɨhora kahapaamapɨpa kaito. Nɨnɨ gaahandɨ baindɨ kiyataayonɨ kɨnyɨ mandɨtaimbɨ wɨndɨ apomaasane,’ undatɨ osaataatamɨ satɨho koaisɨ kaundataase,” tatɨ namɨhanatɨ Jisaasiho kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Satatɨ namɨhana kanyatatosatɨ Jisaasiho sanyatataase. “Isɨ sɨhɨhura Autaahaatɨho nisɨhetapɨ komɨ isɨhiyai iwinja bimonɨhura siyatɨ noaipaitaise: isɨhiya wanɨmura ambɨpatɨ awaipatisahiya jɨhɨtohiyɨhiya sɨhɨhura noaipapɨ ipotɨtisaihɨ amɨ isɨhiya wanɨmura ambɨpatɨ awaipatɨ owehiya ipotɨtohiyɨhiya sɨhɨhura ambɨpatɨ awaipatɨ nepɨ noaipapɨ jɨhɨtɨtaapo,” nyatatɨ Jisaasiho nyahɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Aihɨ Jisaasiho Jerusaremɨhandaahapɨ taatɨ naihɨ maawɨ niyahaawɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ 12 kiyaatɨ ikwɨmaindɨmwɨtihɨ auhɨramɨ yahurɨtahiyaanangi isɨhiyaamɨhatɨhapɨ mɨhinenyamatɨ taawa niyahaahetɨ sanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Sahɨ atiwɨse. Nyahɨ Jerusaremɨhanda niyaatɨ noaipaitɨhaawɨhiyaanɨnɨ taawaatɨ daayaatɨ bitopɨ niyahaayo. Niyaatɨ noaipasaihɨ kapɨhɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨhi isɨhiya nepɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai dɨpumanɨwɨ waamaindumwapɨ nunyohiyɨhiyaamɨ mɨtɨhiyaamunɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaamunɨ ikwɨraatɨhɨ wɨrapɨnitaapo. Aisaihɨ kiya nɨngi kɨnyɨ napwɨtaahunyaatahoŋisɨ napwɨtaapo ndɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sandɨwɨ kiya nepɨ nɨngi isɨhiya kiyaamɨ dawaataatɨ bimohiyɨhiyaamɨ ikwɨraatɨhɨ wɨrapɨnitaapo. Aisaihɨ kiya Romɨhandaahapɨhiya nɨngi sisɨpɨhɨndɨwɨ wɨrɨhɨra nepɨ yanupapɨ amɨ ipɨ tɨtɨhɨ atawɨhatetɨ nipɨmandaapɨ nɨwisaihɨ napwɨto. Napomasanɨhɨ asisɨha mairɨma saniyonɨhɨ Autaahaatɨho nɨngi ahonimatɨ nanɨmaahonɨhɨ nɨnɨ japɨhɨ nepaito,” nyatatɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Aihɨ Sepetihomɨ apwaataatɨ kaatamɨ mwaahurɨ Jemɨsiyɨ Joniyaisatɨ maasɨ Jisaasihoenda nasataise. Nasatɨ mwaahurapɨ wapaapɨ nunjendandɨ komɨ utatototɨ nambɨtatɨ atotɨpɨwesataise. Iyatɨ ko wapa kaitandɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kaatɨ saihɨ Jisaasiho kaati saunda nunjenataise. “Kɨnyɨ napindape?” undataase. Undihɨ kaatamɨha saundataase, “Kɨnyɨ Awaisɨhoŋimatɨpɨ isɨhiyai iwinjaapɨ bindapaahura katisamɨhɨ nisɨ metɨmurɨ awaisururimatɨmɨ kinyɨ yatɨhɨ isɨhiyai iwinjatɨtaatɨmo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Saundihɨ Jisaasiho kusasi komɨha saundataase. “Sausasaatɨ nanɨsehohɨtɨmandapɨ wɨndɨ mowɨhusasaate,” undataase. Undatosa Jemɨsiyɨ Joniyai saundataase, “Waapoho ipɨho yahutaatɨ pusahomataindɨ nɨnɨ yaasɨhaiwa netɨ awɨtɨmatɨ nainjanɨhaiwa sɨhoaahɨ nɨngi nanipinjamɨ kaiwa nepɨ awɨtɨmapɨ nandaiso?” undatɨ nunjenataise. Aihɨ kuramɨha Jisaasihoai saundamaase, “Yɨhoaanyangisangi nga saito,” undamaase. ");
INSERT INTO agm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Undihɨ Jisaasiho komɨha kuri saundataase. “Akɨtɨsɨ sɨhoaasangisangi waapoho ipɨho yahotɨ pusahomataimɨ yaasɨhaiwa nepɨ awɨtɨmapɨ nandaatɨmɨhuraahe. Sɨhoaahɨ saitaise satɨtɨ kasatataahandɨ kandɨ nɨnɨ isɨhiyai kɨnyɨ soŋɨ soŋɨ nisɨ yatɨhɨ awaisɨhoŋimatɨpɨ isɨhiyai iwinjaapɨ bime undɨtandɨhandɨ nisɨhandɨmaahe. Owetise. Saiwa nisɨ Apɨho isɨhiya aunahɨpatɨ nepɨ isɨhiyaisɨ iwinjaawɨ bimɨtaatɨwɨhiyaapɨ aimɨ tɨmanatɨ ahɨwihɨhaiwaasɨ kiyaahɨhɨ naitaapo,” undatɨ Jisaasiho Jemɨsiyɨ Joniyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aihɨ nyahɨ 10 kiyaatɨ ikwɨ maindɨmwɨtahiyaanɨnɨ Jisaasihomɨ otɨpɨpatɨhiyaanɨnɨ usaanɨnɨ kurɨ Jisaasihoai nunjesɨtɨndapɨ atisɨhaawɨ kurapɨ nyangi aponyataise. ");
INSERT INTO agm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Siyatɨ aponyihɨ namatɨ Jisaasiho nahatiyaanangi gaata nanyamaatɨ sanyatataase. “Sahɨ mmowɨ gwɨnyaapɨhiyaate, isɨhiya wapɨhapɨhiya Autaahaatɨhopɨ atɨhomiwɨ gɨmunyaahohiyɨhiyaamɨ awaisawɨhiya kiyaamɨ isɨhiyaisɨ topɨtaata sawanaamɨ gwɨnyapehohɨtɨhanda iwinjatauho. Aiwɨ kiyaamɨ isɨhiyai awaisawɨhiya waatɨ pɨhɨtɨwɨ urɨpatiwɨ otɨpɨpatɨ watɨpɨhaiwa ambɨpatɨ yaawɨhaiwa nunyauho. ");
INSERT INTO agm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kiyaamɨ kiyohɨwaiwa sahɨ wɨndɨ namepɨse apɨpaahɨ owetane. Amɨ samɨ woŋɨ usaamɨ awaisɨhoŋimatɨtaapaahɨ soŋɨ nahatiyaamɨ otɨpɨpatɨhoŋimate. ");
INSERT INTO agm_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aiwɨ amɨ samɨ woŋɨ noaipapɨ usaamɨ mɨtɨhoŋɨ jɨhoŋimatɨtaapaahɨ amɨ nehɨ yatɨhɨ isɨhiyaamɨ otɨtɨhɨ otɨpɨpatɨhoŋimate. ");
INSERT INTO agm_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sahɨ siyawaawaahɨ nisɨ kiyohɨrɨhɨretɨ kaitaapo. Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ isɨhiya otɨpɨpatɨ kaniwɨ nɨngi nɨtatamanɨtaatɨwɨ napɨtɨhonɨnɨmaahe. Owetise. Nɨnɨ isɨhiyaapɨ otɨpɨpatɨ kawindɨ netɨ iwɨtatamanɨtɨ kiyaisɨ nisɨ ambɨpatɨ nunyandɨ kiyaamɨ maipɨhaiwaatɨhapɨ japɨhɨ numwaitandɨ napɨtɨhonɨne,” nyatatɨ komɨ otɨpɨpatɨhiyaanɨnɨ nahatiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aihɨ nyahɨ Jisaasihoaisaatɨ aunahɨpa Jerikohandɨ namasi wapɨhapɨ taawaatɨ niyonɨhɨ isɨhiya wɨrɨsandimɨ Jisaasihomɨhinɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Iyauhɨ utaahurɨ wurɨ ndɨha maipɨtahurɨ kapɨhɨ daihɨraamɨhinɨ bindamaahurɨ Jisaasiho yamo taatɨ nasataise tauhɨ atisamaise. Atisamaamɨ namasamɨ satɨmɨ kaahaatamaase. “Daawitɨhomɨ Mwaahoŋɨ nyahɨ Isɨraherɨhiyaanangi nyainjaapɨ bimɨtaapɨ awaisɨhonye yɨhoaanyangi kɨnyɨ kinyɨ maarɨho asɨpɨnyime,” tɨmɨ kaahaatamaase. ");
INSERT INTO agm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Satɨmɨ kaahaatihɨ isɨhiya wɨrɨsandimɨ nasohiyɨhiya kurisɨ itɨhundɨwɨ, “Sɨhoaahɨ wɨndɨ kaahaamaatɨmɨse,” undawaatopo. Saundauhɨhandɨ kandɨ kurɨhɨ mɨtaahɨ mwɨtetɨmɨ satɨmɨ kaahaatamaase. “Daawitɨhomɨ Mwaahoŋɨ nyahɨ Isɨraherɨhiyaanangi nyainjaapɨ bimɨtaapɨ awaisɨhoŋe yɨhoaanyangi kɨnyɨ maarɨho asɨpɨnyime,” tɨmɨ kaahaatamaase. ");
INSERT INTO agm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Satɨmɨ kaahaatihɨ Jisaasiho nasatɨ bitondaatɨ gaata numwaatɨ saundataase. “Nɨnɨ sɨhoaasangi napitɨsitande?” undatɨ kuri nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Saundatɨ nunjesɨhɨ amɨ kuramɨha Jisaasihoai saundamaase. “Awaisɨhoŋe kɨnyɨ yɨhoaanyamɨ ndɨha nanyorɨhaitaapɨto,” undamaase. ");
INSERT INTO agm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Saundihɨ Jisaasiho kurisɨ maarɨho asɨpɨwisatɨ kuramɨ ndɨhaatɨhɨ ikwɨrɨ ahɨwisataise. Ahɨwihɨ nehɨ ketɨ kuraanɨhɨ ndɨha norɨhaapɨ japɨ amɨ Jisaasihoai nɨwipinjai nomaise. ");
INSERT INTO agm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aihɨ nyahɨ Jisaasihoaisaatɨ komɨ otɨpɨpatɨhiyaanɨnɨ Jerikohandaahɨraapɨ nasaatɨ Jerusaremɨhanda detɨtihɨ aunahɨpatɨ Betɨpakihanda sisɨho wo komɨ ambɨpatɨ Oripɨhandamɨ sɨhoaarɨhɨretɨ ahetihɨhata noaipɨhaayo. Sapɨhɨ Jisaasiho nyamɨ wuri sata kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Sɨhoaahɨ aunahɨpatɨ nyamɨ naitɨhaamihoaaŋɨ ahetimata naimɨse. Naimɨ sapɨhɨ noaipapɨ ketɨ kuraanɨhɨ maasapɨho dongiho wo wɨraposisaihɨ komɨ mwaaho sɨpɨpɨhohoaisatɨ bitohonɨhɨ sɨhoaahɨ mmondaise. Mmonamaamɨ so koaisɨ sanaati mwaasoaisamɨ ahoyamɨ nesɨpapɨ numwaasi kɨmbɨhɨ nammɨse. ");
INSERT INTO agm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Amɨ isɨhiya usa sɨhoaahɨ napitiyamaise satɨwɨ nasɨsesaihaahɨ kiyai saundɨmɨse. ‘Awaisɨho wapa kaitandɨ numwaapɨse nyatihe,’ undɨmɨse. Saundisaihɨ kiya namapɨ nehɨ jainjasaihɨ maasapɨho dongihindari numwaasi napɨtaatɨmo,” undatɨ Jisaasiho wɨnɨhundatɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iyataatɨ sandɨ saimatindɨmandɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho pɨwɨha wa jɨhura satisɨhaamɨ akɨtɨhandɨ noaipaitande. Iyataatɨ ko pɨwɨha sandaase, ");
INSERT INTO agm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sahɨ isɨhiya Sisɨho Saiyonɨhandɨ Jerusaremɨhandaahiyai saundɨwɨ kaundɨwɨse. ‘Wanɨ samɨ awaisɨho jainjatɨtandɨho sangisenda yaho taatɨ nasataise. Ko utaaho aŋɨnɨ napaisaatɨhosɨ amɨ maasapɨho dongihomɨ mwaahoaasɨnɨ yamwaasi yatɨhɨ napaisaatɨ yaho taatɨ nasataise,’ tatɨ kandaase.” ");
INSERT INTO agm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aihɨ nyahɨ otɨpɨpatɨhiyaanamɨ kurɨ Jisaasiho kaunda natausaasimbɨpa naimɨ kɨretɨ kiyamaise. ");
INSERT INTO agm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Aimɨ kurɨ maasapɨho dongiho sanaatɨ mwaahoaisunɨ numwaasi namɨ kuramɨ apotɨhɨrɨ tiwatɨhaatapɨhɨrɨ nausohaapɨ dongiho sɨpɨpɨhohomɨ dawaarɨhɨretɨ ahaihɨ kasɨnɨ Jisaasiho yamwaatɨ bimotɨ Jerusaremɨhandaahapɨ dongiho koaasɨnɨ taatɨ niyataise. ");
INSERT INTO agm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Taatɨ naihɨ isɨhiya wɨrɨsandɨhandɨ Jisaasiho awaisɨhoso tɨwɨ maaritɨwɨ usa kiyaamɨ utɨ apotɨhɨrɨ tiwatɨhaatɨhapa nausohaapɨ daihɨra tusapaapanɨwɨ gwaapwɨwɨ amɨ usa isaaha totɨpatɨ tisatɨwɨ daihɨra nusapaapɨ mɨhopɨ mɨhinɨ gwaapowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aiwɨ isɨhiya Jisaasihomɨ usa jɨhɨ usa ipotɨ niyawaawɨ maaritɨwɨ satɨwɨ konyahɨtawaatopo: “Daawitɨhomɨ Mwaahoŋe nyahɨ gisɨ mepɨ autaahehɨwaamɨhaayo. Autaahaatɨho Gisɨ anɨtisatɨ giwasonɨhɨ nyamɨ Awaisɨhoŋimatɨpɨ nyainjatɨme. Kɨnyɨ Awaisɨho Autaahaatɨhomɨ watɨpɨhandisapɨ nasapainɨ ko sawaho komɨ gaahaiwa nahɨnyatɨ nangɨmaasane. Kɨnyɨ nyamɨ Awaisɨhoŋimatɨpɨ napingɨtɨmandapɨ Autaahaatɨhoai mɨhaatɨ yamɨhapataatɨhɨ mepɨ autaahewaumwɨhaayo,” tɨwɨ konyahɨtawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aihɨ Jisaasiho niyatɨ Jerusaremɨhanda nandaasɨhɨ isɨhiya nahatiya dopɨ wɨndɨ biyatɨ gɨmaawunyainjɨhɨ satɨwɨ nasenawaayopo. “Utaaso so diyaamahore?” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Satɨwɨ nasenɨhauhɨ isɨhiya wɨrɨsandɨhandɨ nasenɨhohiyɨhiyai saundawaatopo. “Kɨmo utaamo yapɨpatɨ disɨtɨrikɨhandɨ Garirihandamɨ aunahɨpatɨ taunɨhandɨ Nasaretɨhandaahapɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho pɨropetɨho Jisaasihore,” undɨwɨ wihoaaŋɨha kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Aihɨ Jisaasiho Autaahaatɨhomɨ aŋɨ Awaindɨhandaatɨhɨ nandaatɨ isɨhiya usa kahapaamapɨpa namɨnɨwɨ nunyawɨ nehohiyɨhiyai netɨ ipaahaapema tahamanataise. Iyatɨ isɨhiya nawɨho yapɨpatɨ wɨtaahapɨho Judaahiyaamɨhoetemapɨ nehohiyɨhiyaamɨ gwɨtɨho bwɨnanaatɨ nepihotɨ amɨ koho pɨpɨhopa Autaahaatɨhopɨ tɨhɨwɨ sɨsandɨpaitaatɨwɨho nunyawɨ nehohiyɨhiyaamɨ ganɨho gwɨtɨho netɨ nepihotɨ tipɨndatɨ isɨhiyai tahamanataise. ");
INSERT INTO agm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tahamanatɨ kiyai saundataase, “Autaahaatɨho komɨ pɨwɨha jɨpatɨpindisɨhaatɨhapɨ sandaase: ‘Nisɨ aŋaaŋɨ isɨhiya nisapɨ gaapundɨtaatɨwɨhaane,’ ndaase. Autaahaatɨho satihɨhandɨ kandɨ sahɨ kaaŋɨ nepɨ anɨmwaasɨha isɨhiya ikohiya ikondaatɨwɨ noaatohɨpɨpɨhamataiwɨ sahɨ kiyawaayopo,” undatɨ tahamanatɨ itɨhundataase. ");
INSERT INTO agm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aihɨ isɨhiya usa ndɨha niyotahiyaunɨ amɨ usa ikwauhɨrɨ ambɨpatɨ bɨwatetɨ namɨhatahiya aŋɨ Awaindɨhandaatɨhɨ Jisaasihoenda nasauhɨ kiyai ko netɨ tɨtɨhɨwiwataise. ");
INSERT INTO agm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aihɨ sapɨhɨ aŋɨndaatɨhɨ manyinya maaritɨwɨ konyahɨtɨwɨ aunɨhɨtɨwɨ satawaatopo. “Daawitɨhomɨ Mwaahoŋe, nyahɨ gisɨ mepɨ autaahewaahɨmɨhaayo,” tɨwɨ aunɨhɨtawaatopo. Aihɨ pɨrisihiya isɨhiyaapɨ nandapa kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai dɨpumanɨwɨ waamaindumwapɨ nunyohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ Jisaasiho isɨhiyai gaahaiwa watɨpɨhaiwa kawiwaiwa mmowɨ manyinya Jisaasihoaisɨ mepɨ autaahepumwahohɨtɨhandɨ atiwɨ mmonawaawɨ kiyaisɨ apɨpaahɨ apousataise. ");
INSERT INTO agm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Apowihɨ namapɨ Jisaasihoai kiya saundɨwɨ nunjenawaayopo, “Uto manyinya konyahɨtɨwɨ aunɨhɨtohɨtɨmandɨ tɨtɨhɨmetisɨ kɨnyɨ atino?” undɨwɨ nunjenawaayopo. Satɨwɨ nunjenɨhauhɨ Jisaasiho komɨha saundataase. “Ye baindɨ atisataayo. Sahɨ Autaahaatɨhomɨ pɨwɨha sata jɨpatɨpindihɨ awɨtohɨhaamɨ tanyaaha wɨndɨ mohowo? Satisɨhaapɨto, ‘Autaahaatɨhonye, kɨnyɨ manyinyaamunɨ amɨ sangɨhiya amwɨtɨhɨrɨ ikwɨhandahiyaamɨ maahomwaaŋɨ aimɨ nɨwusaahɨnɨhɨ kɨwahongi tɨtɨhɨ baiwɨ mepɨ autaahepɨhɨmawaayopo,’ tatɨ jɨpatɨpindɨsɨhaaro,” undatɨ Jisaasiho awaisawɨhiya koai nunjenɨhohiyɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Saundatɨ Jisaasiho kiyai numwasisɨ amɨ Jerusaremɨhanda namatɨ noaipasi aunahɨpatɨ Betanihandaahapɨ notɨ sapɨhɨ nanotaise. ");
INSERT INTO agm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Aihɨ bowihɨ asisɨhaatɨhɨ koho koaisaatɨ Jisaasiho Jerusaremɨhandaahapɨ jahɨra naihɨ niyahaawɨ koaisɨ jaumanataise. ");
INSERT INTO agm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jaumasɨhɨ daihɨraamɨhinɨ ipatɨ wɨtɨ pwɨhoaipɨhomatiyahatɨ yandɨpɨho ningosɨhɨ isɨhiya nandɨwɨ nanɨwɨhatɨ ahetihɨ Jisaasiho kati iwinjataise. Iwinjatosa kataapɨhɨ notɨ yandɨpɨho ningoaitaiso tatɨ nepihɨra jata yandɨpɨho owetihɨ nehɨ isaahaahɨhɨ iwinjataise. Winjataatɨ namatɨ katisɨ saundataase. “Kɨnyɨ kɨmatɨ immataŋɨ apɨpaahɨ awaipɨtɨpɨ yandɨpɨho jahɨra wɨndɨ namingope,” undataase. Undihɨ ketɨ kuraanɨhɨ ipitɨ satɨ awaipɨtamataise. ");
INSERT INTO agm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Siyatɨ awaipɨtamasɨhɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ mmonɨhaawɨ yayaatɨ maarɨho nanɨpimainjɨhɨ sataatɨ nasenɨhaayo. “Ese immatɨ kɨmatɨ napitiyatɨ ketɨ awaipɨtamase?” taatɨ nasenɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Sataatɨ nasenɨhonɨhɨ Jisaasiho sata kanyatataase. “Pɨwɨma kɨma watɨpɨha nɨnɨ sangi tɨtɨhɨ akɨtɨnɨhɨ kasatataato. Sahɨ Autaahaatɨhomɨ watɨpɨhandapɨ andɨtitɨwɨ gɨwunyaapɨ amɨ maarɨho yɨyatɨwɨ gɨmunyaawaawaahɨ sahɨ wapa nɨnɨ immatɨ kɨmati kawisohɨtɨmandamataiwɨ nga kaitaapo. Aiwɨ amɨ sahɨ nehɨ wapa saiwɨhapaahɨhɨ kamaitaapo. Amɨ sahɨ kɨmo sisɨmoaisangi nga saundɨtaapo, ‘ndopɨ noaatɨwopesi kɨnyɨ durɨhɨraatɨhɨ pɨnumbwɨ tɨmahiye,’ undisaihɨ ko sangi atɨsisatɨ kaitaise. ");
INSERT INTO agm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Aiwɨ amɨ sahɨ wapa naitaatɨwɨhapaapɨ maarɨho naasohɨtanɨhɨ gɨwunyaawaawɨ Autaahaatɨhoai nunjenawaawaahɨ kapa nunjehohɨpɨpa naitaapo,” nyatatɨ kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Aihɨ Jisaasiho Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ jahɨra niyatɨ isɨhiyai taatɨ kataunjataise. Taatɨ kataunjihɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai nunyohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ Judaahiyaanamɨ gwɨnyaahiya isɨhiyaunɨ Jisaasihoenda napɨwɨ saundɨwɨ koaisɨ nunjenawaayopo. “Kɨnyɨ watɨpɨhandɨ maahapɨhapɨ nepɨhandaahɨ watɨpɨmaiwa kaise? Gisɨ watɨpɨndɨ diyaamaho nahɨmihɨhande?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Saundɨwɨ nunjenɨhauhɨ Jisaasiho komɨha saundataase, “Nisangi sangi naasaindɨhɨ wɨndɨ nasɨsendaano. Amɨ sahɨ wihoaaŋɨ nepɨ tɨtɨhɨ kandisaihaahɨ nisangi watɨpɨhandɨ sandaahɨ kɨmaiwa kiyo satɨtɨ kasatɨtaano. ");
INSERT INTO agm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jonɨho Isɨhiyaisɨ Baawusisɨho watɨpɨhandɨ ndɨ numwihɨ isɨhiyaisɨ pɨwɨha ausaatɨ kaundatɨ baawusise? Autaahaatɨho numwihɨhandaaho e isɨhiya nunyauhɨhandaaho?” undatɨ nunjenataise. Saundatɨ nunjesɨhɨ kiya sawana sanawaatopo. “Pɨwɨha napitɨtaatɨ kaundɨtɨhaawe? Amɨ nyahɨ koaisɨ Autaahaatɨho numwihɨhandaahe undisaihɨ wiwa ko sanyatɨtaiso amɨ Jonɨho isɨhiyai pɨwɨha ausaatɨ kaundatɨ baawusindɨhandɨ nisɨ kandɨ kiyohɨtɨmandisawɨ napindapɨ sahɨ mmowɨ nepɨ gwɨnyaahopo? Nyatɨtaiso. ");
INSERT INTO agm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","O amɨ nyahɨ sataatɨ isɨhiya nunyauhɨhandaahe tɨtɨhaawɨhandapɨ nyahɨ yayahaayo wiwa isɨhiya ahoyanɨwɨ wapa wipɨnyitauho. Amɨ kiya Jonɨhopɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨhoe tɨwɨ waatɨ andɨtitɨwɨ gɨwunyaapɨhiyaatiho,” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sawana sanɨwɨ wɨsasawesi Jisaasihoai saundawaatopo. “Kɨnyɨ nanyisehingɨtɨndapɨ nyahɨ wɨndɨ moho,” undawaatopo. Saundauhɨ amɨ Jisaasiho komɨha kiyai saundataase. “O kiyonaahɨ nisangi sangisɨ watɨpɨhandɨ sandaahɨ kɨmaiwa nɨnɨ kiyo satɨtɨ wɨndɨ kamaasatɨtaano,” undatɨ isɨhiya awaisawɨhiya nunjehohiyɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Aihɨ Jisaasiho Judaahiyaanamɨ awaisawɨhiya koai napɨwɨ nunjehohiyɨhiyai pɨwɨha wa saundataase. “Pɨwɨha kɨma namɨhandɨ nɨnɨ sangi kasatɨtandiyohɨmaapɨ sahɨ napitaiwɨ gwɨnyaawaayopo? Utaaho wo komɨ mwaahurɨ yahurisaho kurisɨ osaataatɨ otɨpɨpatɨ kaitaatɨmɨ numwɨtandɨ gwɨnyaataise. Gwɨnyaatɨ komɨ mwaaho woai jɨhɨ notɨ saundataase. ‘Maasɨho wanɨ asisɨma kɨmetɨ kɨnyɨ numbwɨ osaataatɨ otɨpɨpatɨ kaime,’ undataase. ");
INSERT INTO agm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","30","Saundihɨ ko sapɨhoai komɨha wihoaaŋɨha saundataase. ‘Nɨnɨhɨ pondihiyo,’ undataase. Undihɨ namatɨ sapɨho mwaaho woenda notaise. Notɨ woai jɨhɨ kaundipatɨ naasaipitɨ katɨ kaundataase. Kaundihɨ meto sapɨhoai saundataase. ‘Ye, aaye kaitaano apore,’ undataase. Sapɨhoai saundatɨ aaye undamapɨho ko amɨ wɨndɨ notɨ osaataatɨ otɨpɨpatɨ kamaise. Amɨ metɨho sapɨho jɨhɨ nunjesɨho nehɨ sawahounyaatɨ bapiyatɨ gwɨnyaataatɨ namatɨ ipotɨ osaataatɨ notɨ otɨpɨpatɨ kiyataise. ");
INSERT INTO agm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Aisɨ meturɨ suramɨ maahonɨhɨ sapɨho maaritatɨ gwɨnyapesɨrɨhɨretɨ japepihɨratɨ kiyataise?” undatɨ Jisaasiho isɨhiya Judaahiyaanamɨ Autaahaatɨhomɨ aŋɨ Awaindɨhandɨ jatohiyɨhiya awaisawɨhiyai nunjenataise. Saundatɨ nunjesɨhɨ kiya Jisaasihoai kiyaamɨha saundawaatopo. “Metɨho jɨhɨ nunjesɨho sapɨho maaritatɨ gwɨnyaasɨrɨhɨretɨ japepihɨratɨ kiyataise,” undawaatopo. Saundauhɨ Jisaasiho kiyai saundataase. “Kɨmandɨ sangisɨ akɨtɨnɨhɨ nɨnɨ kasatataato sahɨ baiwɨ atiwɨse. Isɨhiya usɨhiya asɨhiya apɨpaahɨ maipɨhiya sahɨ apɨpaahɨ maipɨhiye tɨwɨ samɨ mandɨha kaanɨhɨ naingaapɨ usomapɨ kahɨtɨwɨ noaamahohiyɨhiya samataiwɨ wɨndɨ watɨpɨtɨwɨ namoaasawɨ napaisaatɨ kiyaamɨ maipɨhaiwaatɨhapɨ nepemaitisaihɨ Autaahaatɨho kiyai iwinjatɨtandɨhandɨ sangi nasɨtipatɨ detɨ detɨ ahondaise. ");
INSERT INTO agm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sandɨ apaapɨmaato amɨ Jonɨho Isɨhiyai Baawusisɨho nasatɨ daihɨra tɨtɨhɨ kɨmɨraare tatɨ nasɨsihɨ amɨ sahɨ koaisɨ wɨndɨ baiwɨ usopɨ gɨmaawunyaahopo. Sahɨ siyauhɨhandɨ kandɨ isɨhiya usɨhiya asɨhiya apɨpaahɨ maipɨhiyaahɨhɨ Jonɨhoai komɨ pɨwɨha atɨwiwɨ kiyaamɨ maipɨhaiwaatɨhapɨ japɨhɨ nepemaitawaayopo. Isɨhiya maipɨhiya saiwɨ Jonɨhomɨ pɨwɨha atɨwiwɨ gɨwunyaahauhɨ sahɨ iwinjawaahandɨ kandɨ sahɨ samɨ amɨtɨha nepemaipɨ komɨ pɨwɨha wɨndɨ gɨmaawunyaahopo?” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iyatosatɨ Jisaasiho isɨhiya Judaahiyaanamɨ Autaahaatɨhomɨ aŋɨ awaindɨhandɨ jatohiyɨhiya awaisawɨhiyai saundataase. “Pɨwɨha kɨma wa namɨhanɨtɨ kasatɨtaanɨ atiwɨse. Utaaho wo yapɨpatɨ asakiyatɨ ahusetaho osaataatɨ wɨrɨhɨrɨ wainɨhandɨ niyaamatɨ naaporɨhɨrɨ nesɨwesɨwatɨ nisatɨ nisapuwatɨ anɨmwaahɨpatɨ wainɨhandamɨ yandɨpɨho katopɨ ikisiwatɨ waapoho namoaitandɨhatɨ yamwaatɨ amɨ isɨhiya ikondaatɨwɨhiyaapɨ jaatɨ bitoaitandɨhopɨ aŋaaŋɨ bwɨnanaatɨ nuwataatɨ kiyatɨ aŋɨmatataise. Kiyatɨ ko isɨhiya usa komɨ osaataatɨ wainɨhandɨ jatɨwɨ nimanɨwɨ nanɨwɨ amɨ sawahoai nawɨhounɨ wainɨhandunɨ numwɨtaatɨwɨhiyai nunyamapɨ aunahɨpa namasi wapɨhɨ utarɨhandɨ daaya bitoaitandɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Iyatɨ notɨ bindataatɨ wɨrɨhɨrɨ wainɨhandɨ aimɨ yandɨpɨho ningotɨ akuraihɨ nandɨwɨ ahoaitaatɨwɨhura tɨmetihɨ yapɨpatɨ osaataatamɨ satɨho komɨ otɨpɨpatɨhiya kopɨhapa nimanɨwunyaihɨ nusaitaatɨwɨ netɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Siyatɨ netɨ natausaasihɨ nuwɨ osaataatɨ wainɨhandɨ jaawɨ bitohohiyɨhiyai iwinjawaayopo. Winjɨhauhɨ osaataatɨ jaawɨ bitohohiyɨhiya osaataatɨ wainɨhandamɨ satɨho otɨpɨpatɨhiya natausaasisawɨhiyai nepɨ anɨtiwɨ isɨwatawa woaisɨ komɨ ambɨpatɨ tipɨ nausopɨ asohoai gotɨ tipɨ amɨ woaisɨ apɨpaahɨ sohoaisɨ timapɨ amɨ woaisɨ nawɨhaara yahuwɨ sohoai timawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sawiwɨ tiwauhɨ amɨ osaataatamɨ satɨho jɨhaatɨ komɨ otɨpɨpatɨhiya usa jɨhiyai nusatipɨhaapɨ taahiyɨhiyai natausaasataise. Natausaasihɨ amɨ osaataatɨ jaawɨ bitohohiyɨhiya kiyai naasaipitɨ katɨ kawisawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Komɨ otɨpɨpatɨhiyai isɨhiya osaataatɨ iwinjaawɨ bitohohiyɨhiya saiwɨ tiwauhɨ namatɨ osaataatamɨ satɨho sawahomɨ mwaahoai asɨtɨha napuwatɨ ipotɨnɨhɨ kiyenda natausaasataise. Natausaasataatɨ ko sandaase, ‘Nisɨ maasɨhɨhoai osaataatamɨ satɨhomɨ mwaahoso tɨwɨ akɨtɨnɨhɨ kiya koaisɨ mepɨ autaahemwapɨ atɨwitaapo,’ tatɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Satatɨ nisɨ maasɨhɨhoai atɨnɨwitaawo tatɨ natausaasihɨhandɨ kandɨ ko taatɨ napihɨ iwinjaposawɨ sawana sanawaatopo. ‘Kɨmo utaamo osaataatamɨ satɨhomɨ mwaahosɨ osaataatɨ naitandɨhosɨ namatɨ osaataatɨ komɨhapa nyamɨhapaimatɨta naitɨhaawɨ koai ketɨ tiwɨtɨhaawo,’ nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sanɨwɨ nehɨhaatemapɨ koaisɨ nepɨ aisi noaipapɨ osaataatɨ naaporɨhɨramɨ ipaahaapɨ sohoai tiwawaayopo,” undatɨ Jisaasiho Judaahiyaanamɨ isɨhiya awaisawɨhiyai pɨwɨha sa namɨhana kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Saundatosa Jisaasiho kiyai saundatɨ nunjenataise. “Osaataatɨ wainɨhandamɨ satɨho nasataahura isɨhiya siya komɨ osaataatɨ iwinjaawɨ bitohohiyɨhiyai napitɨwitaise?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Saundatɨ nunjesɨhɨ kiyaamɨha koai saundawaatopo. “Isɨhiya siya maatɨmaatiwɨ maipiyai osaataatamɨ satɨho siyɨhiyai tiwa nematɨ komɨ osaataatɨ wainɨhandɨ yandɨpɨho ningotɨ mimohonɨhɨ nandɨwɨ nanawaahura tɨtɨhɨ kopɨhapa numwɨtaatɨwɨhiyai iwinjatɨtaatɨwɨ nemwɨtaise,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Saundauhɨ Jisaasiho kiyai saundataase, “Autaahaatɨhomɨ pɨwɨha satatɨ jɨpatɨpindisɨha sahɨ aimɨ mmowɨ akɨtɨnɨhɨ awɨtɨwɨhiyaatɨtawaahandɨ kandɨ kaamɨ tanyaaha sahɨ wɨndɨ mohowɨ kasatɨtaanɨ atiwɨse. ‘Yasɨha kɨma isɨhiya aŋaaŋɨ aŋɨmatohiyɨhiya ponyatise tɨwɨ namahotɨha ka wanɨ noaipatɨ mɨhotɨrɨhɨrɨ yasɨha anaahɨhaimatihɨ isɨhiya usa nyamɨ yasɨha aundetɨhopɨ yaŋatɨhaatane tawaatopo. Iyatɨ sandɨ Awaisɨho Autaahaatɨho yasɨhaisɨ netɨ andɨtiwatɨ watɨpɨtatɨ mɨhondaise. Ko nyamɨ ndɨhetɨ sandɨ saihɨ nyahɨ awaindɨhandɨ yayawaamawaatɨ maaritɨhaayo,’ tatɨ jɨpatɨpindataise. ");
INSERT INTO agm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Sandɨ apaapɨmaato amɨ Autaahaatɨho sangi komɨ jainjatindɨhandɨ namatɨ nematɨ isɨhiya usa kiyaamɨ dahopa otɨpɨpatetapɨ akɨpɨpa namwɨyaitaatɨwɨhiyai neunyatɨ kiyaisɨ iwinjatɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Iyataatɨ nɨnɨ aŋaaŋamɨ yasɨha anaahɨha mɨhotɨrɨhɨranɨne. Mɨhotɨrɨhɨranɨnisɨ utaaho wo nɨnɨ napaisɨhonɨnɨ maipɨhonɨnisɨ yasɨha watɨpɨha mɨhotɨrɨhɨri nundɨ isɨwatɨtaano tatɨ nisenda komɨ maarɨho ipatisana nasataataahɨ nɨnɨ komɨ maipɨhaiwa nemwatɨ andɨtɨwiwɨto. Andɨtɨwisanɨhɨ aŋaaŋɨ yasɨha anaahɨha mɨhotɨrɨhɨrisɨhaanamatiyatɨ andɨtita bitoaitaise. O amɨ utaaho wo nɨnɨ watɨpɨhonɨnɨ gaahonɨniso tatɨ genanatɨ nisenda namaasataataahɨ aŋaaŋɨ yasɨha mɨhotɨrɨhɨrɨ owehaaŋɨ niyatɨ nopɨsasinjɨtɨhandamatiyatɨ ko tɨmahiya nopɨsasɨnatɨ owetɨtaise,” undatɨ Jisaasiho Judaahiyaanamɨ awaisawɨhiyai kaundataase.) ");
INSERT INTO agm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Saundihɨ amɨ pɨrisihiya isɨhiyaapɨ nandapa kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai dɨpumanɨwɨ waamaindumwapɨ nunyohiyɨhiyaamɨ awaisawɨhiya mɨtɨhiyaunɨ amɨ Parisihiyaunɨ sandɨ Jisaasiho sɨwipatɨ namɨhanatɨ kaundindɨndɨ atisawaayopo. Atisawa sandɨ ko nyahɨ yawanaanapiso tɨwɨ gwɨnyaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sandɨ saiwɨ yawanaanapiso tɨwɨ mmonawaawɨ koai nepɨ wɨraitaatɨwɨ kiyaamɨ maarɨho nonasayataise. Kiyai sawimataataahandɨ kandɨ Jisaasihopɨ isɨhiya wɨrɨsandɨhandɨ ko Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨhoe tɨwɨ gɨwunyaapɨhotihɨ amɨ kiya isɨhiya wɨrɨsandɨhiya wiwa nyangi wipɨnyitaawo tɨwɨ yayawaawɨ koai wɨndɨ kiya nepɨ wɨmirahopo. ");
INSERT INTO agm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Aihɨ Jisaasiho jahɨra pɨwɨha wa namɨhana kiya awaisawɨhiyai sata kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Autaahaatɨho isɨhiyai iwinjatihɨ wiwa taatɨ siyatɨ noaipapɨ notaise. Utaaho awaisɨho wo komɨ mwaaho apopaatɨ netɨ wɨraitandɨ nandapa awaimbɨpa netɨ tɨhatɨ tɨmanataise. ");
INSERT INTO agm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tɨhatɨ tɨmanataatɨ isɨhiya aimɨ jɨhɨ nandapaapɨ napɨtaatɨwɨ kaundatɨ nunjesawɨhiyai nuwɨ gaatɨwɨ numwaitaatɨwɨ komɨ otɨpɨpatɨhiyai netɨ natausaasataise. Natausaasihɨ nuwɨ kaundauhɨ kiya atisawaahandɨ kandɨ poundihɨ namaasopo. ");
INSERT INTO agm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Namaasauhɨ namatɨ uta awaiso komɨ otɨpɨpatɨhiya usaisɨ saundataase. “Sahɨ nuwɨ isɨhiya nisɨ nandapaapɨ napɨwɨse undɨtɨ aimɨ gaatohiyɨhiyai saundɨwɨ awaisɨho gaatisɨho sandaase undɨwɨse. ‘Nisɨ nandapa awaimbɨpa aimɨ tɨhɨtɨ wanɨ tɨmendaise. Nandapa amɨ sɨpɨpɨhoho mwaaho napaisɨho titɨ tɨhɨtɨ nahataapa aimɨ tɨmendaise. Nisɨ maasɨhɨho apopaatɨ netɨ wɨrahonɨhɨ iwinjapɨ maaritɨwɨ nandapa tɨhɨtɨ tɨmanɨhohɨpɨpa nandaatɨwɨ napɨwɨse,’ undɨwɨ kaundɨwɨse,” undatɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Saundatɨ natausaasihɨ nowaayopo. Nuwɨ awaisɨho kaundirɨhɨrɨ kɨretɨ komɨ otɨpɨpatɨhiya isɨhiya kiyaisɨ tɨtɨhɨ kaundawaatopo. Tɨtɨhɨ saiwɨ kaundauhɨhandɨ kandɨ awaisɨho gaatisawɨhiya atɨhomiwɨ pohipaiwɨ wɨndɨ namaasopo. Namaapɨwɨ kiyaamɨ otɨpɨpatɨ kaitaatɨwɨ kɨhɨra nandawaayopo. Kɨhɨra nandɨwɨ wo komɨ osaataatapɨ naihɨ amɨ wo asɨharisatɨ nandapa maahoaipatɨ kohasɨpɨho netɨ ahoya naasaimbɨpɨhemaitandɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Amɨ usa otɨpɨpatɨhiyaisɨ isɨwatawa ambɨpatɨ tipɨ isuriwɨ tipɨ amɨ usa sɨyɨhiyai timawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Komɨ otɨpɨpatɨhiyai sawiwɨ komɨ nandapaapɨ namaasauhɨ uta awaisɨho apɨpaahɨ apousataise. Apowihɨ komɨ isɨhiya tunnɨwɨyahwɨndaatɨwɨhiyai natausaasihɨ nuwɨ isɨhiya komɨ pɨwɨha gapɨpa atɨhomaawiwɨ maatɨmaatiwɨ komɨ otɨpɨpatɨhiyai tiwohiyɨhiyai tipɨ kiyaamɨ aunahɨpa niyapɨ tɨpowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Iyatɨ amɨ ko komɨ otɨpɨpatɨhiyai gaatatɨ numwaatɨ saundataase. ‘Nisɨ maasɨhɨho apopaatɨ netɨ wɨraitandɨ nandapa awaimbɨpa tɨhɨtɨ aimɨ tɨmetihɨhandɨ kandɨ isɨhiyai napɨwɨse undɨtɨ gaatohiyɨhiya nɨngi ahosɨnɨmawaawɨ wɨndɨ namaasowɨ kiyaahɨmaahe. ");
INSERT INTO agm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kiyaahɨmetisɨ namapɨ daihɨra awaiwaiwaatɨhɨ isɨhiya ahoyanɨwɨ dɨndaayohɨpɨpɨhɨ nuwɨ isɨhiya usaapɨ daapɨse. Daapɨ usonawaahiyai pɨhɨtɨwɨ taahiyɨhiyai nisɨ nandapaapɨ numwaasi napɨwɨse,’ undatɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Saundihɨ komɨ otɨpɨpatɨhiya daihɨra awaiwaiwaamɨ ururaatɨhapɨhɨ nuwɨ daapɨ isɨhiya usonawaahiya kiyaisɨnɨhɨ gaatɨwɨ numwaapɨ nepɨ ahoaiwɨ numwaasi nandapa awaimbɨpaapɨ napɨwɨ katɨhɨ bindawaayopo. Bimauhɨ awaisɨho nandapa awaimbɨpa tɨhatɨ tɨmasɨhomɨ aŋaaŋɨ isɨhiyaapɨ tisaitamataise. ");
INSERT INTO agm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tɨsaitamasɨhɨ utaaho awaisɨho isɨhiya komɨ mwaaho apopaatɨ netɨ wɨrahonɨhɨ iwinjapɨ maaritɨwɨ nandapa nandaatɨwɨ nasohiyɨhiyai usondandɨ nandaataise. Nandaatɨ usonataatɨ isɨhiya nahatiya apotɨhɨrɨ namatɨtaatɨwɨhuraapɨhɨrɨ awaisɨho sawahomɨhɨrɨ komɨ otɨpɨpatɨhiya maasomwaaŋɨ nepɨ nunyohɨrɨhɨrɨ niyowaayopo. Nahatiya siyauhɨhandɨ kandɨ utaaho wo naasohɨ nisɨ apotɨhɨrisangi awaisɨhomɨhɨramatiya gaahɨriso tatɨ niyotɨ nandaatɨ bimihɨ awaisɨho koai usonataise. ");
INSERT INTO agm_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Usonatosatɨ awaisɨho koai saundataase. ‘Uto kɨnyɨ apotɨhɨrɨ kɨmura usɨpɨmbaapɨmuraapɨhɨrɨ namaayopɨhoŋisɨ napitaimbɨ nandaapɨhoŋe?’ undatɨ nunjenataise. Saundatɨ nunjesɨhɨ utaaso wihoaaŋɨha wɨndɨ awaisɨhoai kamunje. ");
INSERT INTO agm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aihɨ utaaho awaisɨho komɨ otɨpɨpatɨhiyai saundataase. ‘Kɨmo utaamoai sahɨ nepɨ komɨ ikwauhɨrɨ wɨsasawɨ ipaahaapɨ apɨpaahɨ asɨhatindɨtɨhɨ yotɨwɨse. Nepɨ yotisaihɨ sapɨhɨ ko ngotɨ amɨ komɨ mangɨrɨ gitɨpaitando,’ undataase,” undatɨ Jisaasiho isɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Satatɨ kaundataatɨ amɨ wa kɨma kiyai namɨhanatɨ kaundisɨmaapɨ nusesɨpatɨtandɨ kaundataase. Iyatɨ ka satatɨ kaundataase, “Autaahaatɨho siyatɨ isɨhiya taahiyɨhiyai iwinjatɨtotatɨ nunjenatɨ gaatihɨhandɨ kandɨ kiya wɨndɨ atiwɨ namaasopo. Namaasauhɨ nehɨ yahingwaasɨhɨhɨ numwaatɨ iwinjatataise,” undatɨ kaundatɨ owemataise. ");
INSERT INTO agm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Aihɨ Jisaasiho satatɨ kaundihɨ Parisihiya atiwɨmapɨ nuwɨ ko pɨwɨha kiyaamɨ nunjehohɨha tɨtɨhɨ kamundonaahɨ wipɨwitaatɨwɨ winjatawa nunjendaatɨwɨha kanɨwɨ wɨsasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kanɨwɨ wɨsasawesi Parisihiya sawana katɨwunjohiyɨhiyaunɨ amɨ awaisɨho Erotɨhomɨhiyaunɨ ahoyawɨ nehɨ waimwaayaisaahɨhɨ napɨpapɨ pɨwɨha Jisaasihoai nunjendaatɨwɨ apɨpaahɨ tɨmanɨwɨ kaundɨwɨ nusesɨpapɨ saundɨwɨ nunjepɨse undɨwɨ natɨwusaasawaayopo. Natɨwusaasauhɨ nuwɨ Jisaasihoai saundawaatopo. “Katɨpunjingɨhonye kinyɨ otɨpɨpatɨ kaingɨrɨhɨretɨ mmonaahiyaanɨne. Kɨnyɨ pɨwɨha tɨtɨhɨ akaahaahɨhɨ katɨpɨ katɨpunjapɨhoŋe. Aimbɨ kɨnyɨ isɨhiyai wɨndɨ usopɨ nepɨmusosapɨ osamapɨ nahatiyai naasaipitɨ kawimbɨ amɨ isɨhiya usa gwɨnyaahohɨwaiwaapɨ yaimbɨ waatɨ wɨndɨ gɨmunyaapɨhoŋe. Gɨmunyaapɨ nehɨ nanɨhaimbɨ pɨwɨha tɨtɨhɨ akaaha katɨpɨ amɨ Autaahaatɨhomɨhɨretapɨ pɨwɨha akaahaahɨhɨ katɨpɨ katɨpunjapɨhoŋe. ");
INSERT INTO agm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Saimbɨhoŋɨsɨ kɨmandɨ wɨndɨ nahɨsendɨhaawiyonɨ kɨnyɨ kandapɨ wipaimbɨ gwɨnyaapaapaahɨ kanyatɨtaape. Romɨhandaahapɨ awaisɨho Sisaaho nyangisɨ nyainjatisɨho nawɨho takisihandɨ naninyawɨse nyatataase. Ko sanyatihɨ amɨ wɨnɨhapɨpa Mosesiho Autaahaatɨhomɨ netɨ jɨhura Judaahiyaanangi nanyamimbɨpa satise. ‘Autaahaatɨho sangi jainja bindataisɨ komɨ otɨpɨpatapɨ nawɨho koai nunyawɨse,’ tise. Satisɨ nyahɨ Sisaahoai nawɨho takisihandɨ nunyahaawaahɨ nyamɨ wɨnɨhapɨpa newa nopɨsasɨhaayono e owetiso?” undɨwɨ napitɨnyatise tɨwɨ iwinjatawaawɨ Jisaasihoai nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Saundɨwɨ nunjehauhɨ kiya koai maipɨhandɨ kawitaatɨwɨ gwɨnyaahohɨtɨhandɨ usonatosa Jisaasiho kiyai saundataase. “Sahɨ utaatɨmatɨmaatɨ pɨwɨha otaatapɨ jɨnjaipɨpaisahatɨmaate sahɨ nɨngi jaipɨndɨwɨ napindapɨ nanɨsehopo? ");
INSERT INTO agm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nawɨho taanauhɨho takisihandapɨ tɨmaitaatɨwo nɨngi nepɨ nanɨsawewɨse,” undataase. Undihɨ kiya nawɨho taanauhɨho koai nesi napɨwɨ nunjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nesipɨwunyauhɨ netɨ isɨwatata kiyai saundatɨ nunjenataise. “Dɨyaamɨ ndɨmaahomwaaŋɨ sɨwipatɨ amɨ ambɨpatɨ kɨmaiwa nawɨmoaatɨhɨ ahotise?” undatɨ kiyai nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Saundatɨ nunjesɨhɨ kiyaamɨha Jisaasihoai nepɨ saundawaatopo. “Sisaaho awaisɨhomɨ ndɨmaahomwaaŋɨ sɨwipate,” undawaatopo. Saundauhɨ amɨ Jisaasiho kiyai saundataase, “Kiyonaahɨ Sisaahoai komɨhapa tɨtɨhɨ nunyawɨ amɨ Autaahaatɨhoai komɨhapa tɨtɨhɨ nunyawɨse,” undatɨ kiyaamɨ gwɨnyaahohɨtɨhandi ipatisamatɨ kiyaamɨ maahomwaaŋɨ netɨ nɨwisapuwatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jisaasiho siyatɨ kiyaamɨ maahomwaaŋɨ nɨwisapuwatɨ satatɨ tɨtɨhɨ kaundihɨ amɨ kiya ese tɨwɨ yaiwɨ mɨtaahɨ awaindɨhandɨ gwɨnyaapɨ koai sapɨhɨ numwɨhaapɨ kiyaanɨhɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aihɨ ketɨ kura Satiyusihiya Jisaasihoenda nasawaayopo. Siya Satiyusimiya isɨhiya napohiyɨhiya wɨndɨ japɨhɨ namepaitaapo tɨwɨ gwɨnyaapɨhiyaare. Satɨwɨ isɨhiya napohiyɨhiya japɨhɨ wɨndɨ namepaitaapo tɨwɨhiyaasɨ kandapɨ Jisaasihoai nunjendaatɨwɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Napɨwɨ kiya Jisaasihoai saundɨwɨ nunjenawaayopo. “Katɨpunjingɨhonye, wɨnɨhapɨpa Mosesiho Autaahaatɨhomɨ netɨ jɨpatɨpaimbɨpa nyahɨ Judaahiyaanapɨ satise: ‘Utaaho wo apopaati netɨ wɨratɨ bimainjatɨ maaha oweho naponaahɨ komɨ saingɨho osɨnɨhaati netɨ wɨrane. Netɨ wɨratɨ saahopɨ nanɨpimapɨ ambɨpatɨ ahotɨmɨ nutandɨhiya metɨhonyai namoyane,’ tatɨ Mosesiho katise. ");
INSERT INTO agm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aihɨ kɨmbɨhɨ nyangisawɨ isɨhiya usa saahosaingoya 7 kaiwɨ ikwɨrɨ wihɨtɨrɨtihɨ wihɨnɨramɨ yahurɨtahiya bimambɨwɨ nahatiya owetise. Kiyaamɨ saaho jɨho apopaati netɨ wɨratɨ bimainjatɨ maaha oweho napotaise. Napwihɨ saingɨho ipotɨho netɨ saaho jɨhomɨ osɨnɨhaati netɨ wɨrataise. ");
INSERT INTO agm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Netɨ wɨratɨ bimainjatɨ amɨ saingo ipotɨhoaisangi maaha oweho apopaati ahɨwisamɨ napotaise. Saiwɨ naasaipitɨ kaiwɨ saingoya nahatiya apopaati nepɨ wɨrapɨ maaha owehiya napopɨ nuwɨ owetamataise. ");
INSERT INTO agm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Saiwɨ usɨhiya napopɨ owetihɨ ipotaataatɨnɨhɨ apopaatɨ napotaise. ");
INSERT INTO agm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Saiwɨ kaati nahatiya nepɨ wɨrapɨhaatisɨ isɨhiya napohiyɨhiya japɨhɨ nepawaahura apopaatɨ saatɨ dɨyaamɨ apwaataatɨtɨtaise?” undɨwɨ Jisaasihoai Satiyusihiya nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nunjenɨhauhɨ Jisaasiho komɨha kiyai saundataase. “Autaahaatɨhomɨ pɨwɨha jɨpatɨpindisɨhaamɨ tanyaaha sahɨ wɨndɨ mopɨ amɨ Autaahaatɨho isɨhiya napohiyɨhiyai jahɨra ahowimatɨ numwaitandɨhandɨ watɨpɨhandɨ wɨndɨ mowɨhiyaate. Saiwɨ wɨndɨ mowɨhiyaatisɨ sahɨ asɨretɨ naharɨtɨwɨ nɨngi nanɨsenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Iyataatɨ isɨhiya jahɨra nepawaahura Autaahaatɨhomɨ yamɨhapataatɨhapɨ enjerɨhiya otɨpɨpatɨhiya namaamaatohɨpatamataiwɨ usɨhiya asɨhiya nepɨ wɨndɨ namaamaatɨndaapo. Owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Amɨ isɨhiya napohiyɨhiya jahɨra nepaitaatɨwɨhandapɨ Autaahaatɨho komɨ pɨwɨha jɨpatɨpindisɨhaatɨhapɨ sangi kasatihɨ awɨtohɨhaamɨ tanyaaha sahɨ wɨndɨ monɨhowo? ");
INSERT INTO agm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Autaahaatɨho satisɨhaapɨto, ‘Nɨnɨ Abɨraahamɨho Aisaakɨho Jekopɨhoai ahoya iwinjatataayo,’ tatɨ katisɨhaapɨto. Iyataatɨ singwaasɨ napomahohingingwaasamɨ maarɨho ambɨpatisatɨ ahiyatɨ bindataatɨse. Isɨ isɨhiya kopɨ baiwɨ andɨtitɨwɨ gɨwunyaahohiyɨhiyai ambɨpatɨ asɨpatɨ neunyonɨhɨ jinjapɨhɨ asɨyɨhiyaimatisaihɨ kiyaamɨ Autaahaatɨhoematatɨ ahiya bimɨtaise,” undatɨ Jisaasiho Satiyusihiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jisaasiho satatɨ kaundindɨndapɨ isɨhiya wɨrɨsandɨhandɨ atisawaawɨ apɨpaahɨ awaindɨhandɨ yaiwɨmapɨ ko isɨhiyai kataunjiwaiwaapɨ gwɨnyapenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aihɨ Parisihiya Jisaasiho Satiyusihiyaamɨ maahomwaaŋɨ netɨ nɨwisapuse tauhɨ atisawaayopo. Atisawaawɨ ahoyanɨwɨ pɨwɨha iwinjatawa nunjendaatɨwɨha kanɨwɨ wɨsasawesi Jisaasihoenda nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nuwɨ kiyaamɨ wo wɨnɨhapɨpa kataunjisɨho pɨwɨha wɨsasawesi nasohɨha Jisaasihoai saundatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Katɨpunjingɨhonye wɨnɨhapɨpa jɨhura Mosesiho Autaahaatɨhomɨ nyapɨ netɨ jɨpatɨpiyatɨ ahaimbɨpaamɨ maahɨwapaanɨhɨ wiwa nahatewai daahemwa jɨhɨ noaipatɨ awaimbɨpandaise?’ undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Saunda nunjesɨhɨ Jisaasihomɨha koaisɨ saunda kaundataase. “Wɨnɨhapɨpa jɨhɨ awaimbɨpa kɨmbaasɨ kahɨtɨtaanɨ atime. ‘Kɨnyɨ apɨpaahɨ akɨtɨnɨhɨ Awaisɨho kinyɨ Autaahaatɨhoai kinyɨ maarɨho omaŋɨtɨtɨhɨ dotɨ nangɨtɨmasɨtɨhandɨ nahandɨ kinyɨ ambɨpatɨ amɨ kinyɨ amɨtɨha gwɨnyapehingɨtɨhandɨ nahandɨ nunyapɨ maarɨwitɨme,’ tatɨ jɨpatɨpindise. ");
INSERT INTO agm_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wɨnɨhapɨpa sapa kahɨtohɨpɨmba wɨnɨhapɨpa wiwai nusatipɨhaatɨ jɨhɨ awaimbɨpaare. ");
INSERT INTO agm_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Iyataatɨ kasɨnɨhapa awaimbɨpa jɨhɨ kahɨtohɨpɨmbaamatiyahapaare. Iyatɨ kapa sandaase, ‘Kɨnyɨ kɨwahoŋɨ maarɨho namɨnɨpɨ kɨwahonyapɨ maaritingɨpatamataimbɨ isɨhiya usaisɨ maarɨho nunyapɨ kiyaapɨ kɨnyɨ maarɨwitɨme,’ tatɨ jɨpatɨpindise. Iyataatɨ pɨwɨha wɨnɨhapɨmaurɨ kɨmaurɨ pɨwɨha wɨnɨhapɨpa Mosesiho nyapɨ Autaahaatɨhomɨ netɨ kata jɨpatɨpaimbɨpa nahataapaamunɨ amɨ Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaamunɨ pɨwɨhaamɨ tanyaahaure. ");
INSERT INTO agm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Iyatɨ wɨnɨhapɨmaurɨ kɨmaurɨ kaurɨ Autaahaatɨhomɨ pɨwɨhaisɨ andɨtɨwiwatɨ anɨtisatɨ isɨwatataise,” undatɨ Jisaasiho Parisihiyaamɨ wo nunjesɨhoai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Aihɨ Parisihiya sangɨ nuwɨ ahoyanohiyɨhiya kiyaanɨhɨ sapɨhɨ bitohauhɨ Jisaasiho kiyai saundatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Autaahaatɨho Isɨhiyai Japɨhɨ Numwaitandɨ Ahɨwisɨhopɨ sahɨ napitaiwɨ gwɨnyaawaayopo? Isɨhiyai Japɨhɨ Numwaitandɨ Ahɨwisɨho Kɨraisiho dɨyaamɨ mwaahore?” undatɨ Parisihiyai Jisaasiho nunjenataise. Saundatɨ nunjesɨhɨ kiyaamɨha koai saundawaatopo, “Daawitɨhomɨ mwaahore,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Saundauhɨ Jisaasiho kiyai saundatɨ nunjenataise. “O kiyonaahɨ Itɨpɨho netɨ gwɨnyausosihɨ jɨhura samɨ jaasoya jaasisai iwinjatisɨho awaisɨho Daawitɨho napaapɨ Kɨraisiho, ‘Nisɨ Awaisɨhoe,’ tise? Daawitɨho Kɨraisihopɨ satatɨ katisɨhaapɨto, ");
INSERT INTO agm_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Awaisɨho Autaahaatɨho nisɨ Awaisɨho Ninjatisɨhoai saundataase. “Kɨnyɨ nɨngisapɨ maawɨ isɨhiyai iwinjaapɨ bimaamɨ numwe. Iwinjaapɨ bimaamɨ naisamɨhɨ nɨnɨ kinyɨ tiworisai sɨhɨ netɨ kinyɨ ikwɨraatɨhɨmasanɨhɨ kɨnyɨ nepɨ kiyai kinyɨ asɨmwaatɨtɨhemapɨ itɨpapɨ ipatisapɨ tipɨ nemaitaapo,’ undataase tatɨ Daawitɨho Kɨraisihopɨ katisɨhaapɨto. ");
INSERT INTO agm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Amɨ siyatɨ Daawitɨho Kɨraisihopɨ, ‘Nisɨ Awaisɨhoe,’ tonaahɨ Kɨraisiho nɨnapitiyatɨ Daawitɨhomɨ mwaahotɨtaise? Amɨ Kɨraisihoaisangi Daawitɨhomɨ Awaisɨho koai Iwinjaatɨ Bimisɨhometiso?” undatɨ Jisaasiho Parisihiyai nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Saunda nunjesɨhɨ kiyaamɨha apɨpaahɨ masɨhonjisangi wɨndɨ koai kamundopo. Aiwɨ asisɨha suraapɨ Judaahiyaanamɨ awaisawɨhiya yaiwɨ Jisaasihoai wapaapɨ apɨpaahɨ wɨndɨ namunjenɨwɨmawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aihɨ sura Jisaasiho isɨhiya wɨrɨsandɨhandisunɨ nyahɨ komɨ Otɨpɨpatɨhiyaanangisunɨ sata kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Isɨhiya wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ amɨ Parisihiyaunɨ wɨnɨhapɨpa Mosesiho Autaahaatɨhomɨ netɨ jɨpatɨpiya ahaimbɨpaamɨ tanyaaha mmowɨ nepɨ ausaawaahiyaare. ");
INSERT INTO agm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ausaawaahiyaasɨ nahataapa Mosesihomɨ wɨnɨhapɨpaatɨhɨ tɨtɨhɨ ahotimbɨpa kasatisaihɨhapa sahɨ baiwɨ atiwɨ japepihɨrɨwise. Saiwɨ japepihɨrawaahandɨ kandɨ kiyaamɨ daiwɨ bitopɨ kiyohɨrɨhɨretɨ sahɨ wɨndɨ nuwipinjawɨ kamaiwɨse. Amɨ kiya isɨhiyai saiwɨ kaiwɨse undɨwɨ katɨwunjohɨrɨhɨretɨ kamaiwɨhiyaaso. ");
INSERT INTO agm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Aiwɨ Autaahaatɨhomɨ wɨnɨhapɨpa akɨpɨpaamɨ tiwatɨhaatɨ wɨnɨhapɨpa sawanaamɨ gwɨnyapehohɨwaiwa ikɨpɨpa naaŋatɨ apɨpaahɨ namimaatahaiwaamatiyahaiwa isɨhiyaamɨ dawaarɨhɨrɨ ikotɨhaasɨnɨ wɨrapɨ awurɨtɨmapɨ tɨpwɨtɨwusosauhɨ nesi nipinjanawaayopo. Nesi nipinjanɨwɨ wɨnɨhapɨpa japepihɨrauhɨhandɨ kandɨ sawana katɨwunjohiyɨhiya isɨhiyai nunjawɨ andɨtɨwipɨ minjapepihɨrɨwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Iyawaawɨ isɨhiya usa iwinjapɨ kiyaapɨ kiya Autaahaatɨhomɨ wɨnɨhapɨpa baiwɨ andɨtitɨwɨ japepihɨrɨwɨhiye tɨtotɨwɨ nahatewa kiya kiyohɨwaiwa nehɨ otaatapɨhaiwa kiyawaayopo. Aiwɨ Autaahaatɨhomɨ pɨwɨha utɨpɨhoaatɨhɨ jɨpatɨpaiwɨha isɨhiya gaapundɨtaatɨwɨhura amɨtɨhetunɨ ikwɨretunɨ wɨsasanohɨha Parisihiyaunɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ isɨhiya nyainjaitotɨwɨ nepɨ awaiwaiwa jɨpatɨpaiwɨ wɨsasanawaayopo. Aiwɨ amɨ kiyaamɨ apotɨhɨrɨ tiwatɨhaatɨ niyohohɨrɨhɨramɨ otasaahepɨ akɨmetatetɨ wihɨwihoaaŋɨ Autaahaatɨho kaundihɨ isɨhiya nahatiya kiyohɨmumwaaŋɨ nusatipɨhaapɨ isɨhiya nyangi nyainjaitotɨwɨ wɨrapananahaiwa mmwɨrɨhɨrɨ gwɨnɨwɨ wɨramawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aiwɨ usɨpɨpaapɨ isɨhiya ahoyanɨwɨ nandapa awaimbɨpa tɨhɨwɨ nanɨhauhɨhapɨhɨ nyangi isɨhiya nyainjapɨ nandapa jɨhɨ nanyamɨtotɨwɨ gwɨnyaapɨ tɨpwɨnanɨwɨ auta detɨ bitopɨhiyaare. Aiwɨ amɨ aŋaaŋɨ pɨwɨhaapɨ isɨhiya ahoyanohɨpɨpɨhɨ isɨhiya nyangi nyainjaitotɨwɨ isɨhiyai mandusosawɨ mɨtaahoaahapaahaiwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aiwɨ isɨhiya ahoyanohɨpɨpɨhɨ isɨhiya nyangi nyainjapɨ mepɨ autaahepɨnyamapɨ awaisɨhoŋe ipɨhɨretɨ gaahuraare nyatɨtotɨwɨ maaritɨwɨhiyaare. Aiwɨ amɨ kiya Autaahaatɨhomɨ pɨwɨha baiwɨ mmowɨ nepɨ amɨtɨha awaindɨhandɨ gwɨnyaahohɨtɨhandapɨ isɨhiya nyangi katɨpunjingɨhonye nyatɨtotɨwɨ maaritɨwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Amɨ sahɨhɨ nyangisɨ isɨhiya katɨpunjingɨhonye nyatɨtotɨwɨ maaritɨwɨ wɨndɨ gɨmunyaapɨse. Autaahaatɨhomɨ ndɨhetɨ woŋɨ woai namusatipɨhaapɨ nahatiyaatɨ nauratɨhetahiyaatiso. Iyataatɨ amɨ nɨnɨ nɨwahonɨnɨ naasonɨnɨhɨ sangisɨ kandɨsasohɨhonɨnɨtihɨto. ");
INSERT INTO agm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Iyawaawɨ isɨhiya yapɨpatambɨhiyaamɨ woaisɨ sahɨ maarɨho awaindɨhandɨ nunyawɨ mepɨ autaahemwapɨ apore mundɨwɨse. Sahɨ maaritɨwɨ mepɨ autaahemwaitaatɨwɨho samɨ Japɨho Autaahaatɨho nehɨ naasohɨso. ");
INSERT INTO agm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Iyawaawɨ sahɨ isɨhiya nyangisɨ mepɨ autaahepɨnyamapɨ awaisɨhoŋe nyatɨtotɨwɨ maaritɨwɨ gɨmunyaapɨse. Amɨ Autaahaatɨho isɨhiyai Japɨhɨ Numwaatɨ Iwinjatɨtandɨ Ahɨnisɨhonɨnɨ nɨnɨ nɨwahonɨnɨ samɨ awaisɨhonɨnɨ naasonɨnɨhiso. ");
INSERT INTO agm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Iyataatɨ samɨ woŋɨ noaipapɨ sahɨ nahatiyaatamɨ otɨpɨpatɨhoŋimatapaapaahɨ soŋɨ Autaahaatɨhomɨ ndɨhetɨ noaipapɨ sahɨ nahatiyaatamɨ awaisɨhoŋimatitaise. ");
INSERT INTO agm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Samɨ woŋɨ satɨpɨ nɨnɨ utaahonɨnɨ tɨtɨhɨ gaahonɨnɨ awaisɨhonɨnɨ usaisɨ nusatipɨhaatɨhonɨne tɨpɨ genanɨpɨ gwɨnyaapaapaahɨ songi Autaahaatɨho netɨ gwaasɨhaaraŋehɨmaitaise. Amɨ samɨ woŋɨ satɨpɨ nɨnɨ utaahonɨnɨ maipɨhonɨnɨ gwaasɨhaaranɨne tɨpɨ yatɨhɨ ipatisanapaapaahɨ amɨ songi Autaahaatɨho netɨ autaahehɨmaitaise,” nyatatɨ Jisaasiho nyahɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nyahɨ komɨ Otɨpɨpatɨhiyaanangi sanyatatosatɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaisunɨ amɨ Parisihiyaisunɨ Jisaasiho saundataase. “Wɨnɨhapɨpa katɨwunjohiyɨhiyaatɨ amɨ Parisihiyaatɨ sahɨ apɨpaahɨ jɨnjaipɨpaisawɨ otaatapɨhiyaate. Daihɨra maasomwaaŋɨ isɨhiyai Autaahaatɨho nisɨhetapɨ iwinjatɨtandɨhɨra sahɨ nepɨ nuwisapuwawaayopo. Sandɨ apaapɨmaato amɨ sahɨ isɨhiyai jɨnjaipɨtɨwɨ otaatapɨhaiwa kaundɨwɨ katɨwunjawɨ nunjawaawɨ kaiwaaraahɨ Autaahaatɨho nisɨhetapɨ isɨhiyai iwinja bimindɨhandaatɨhɨ sahɨ sawanaatɨ wɨndɨ namɨndaapɨ amɨ isɨhiya kandaatɨhɨ nandaitotɨwɨ nasauhɨhiyai nepɨ nuwisapupwɨhiyaate. Isɨ sahɨ sandɨ siyohɨtɨndapɨ Autaahaatɨho yaasɨhandɨ apɨpaahɨ awaindɨhandɨ sangi nasamɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Wɨnɨhapɨpa katɨwunjohiyɨhiyaatɨ amɨ Parisihiyaatɨ jɨnjaipɨtɨwɨ otaatapɨhiyaate sangi awaindɨhandɨ yaasɨhandɨ Autaahaatɨho nasanyonɨhɨ sahɨ naitaapo. Amɨ asɨhiya osɨnɨhiyai sahɨ nepɨ nusopɨsasɨwɨ kiyaamɨ aŋaaŋɨ ikowɨnɨwɨ amɨ isɨhiya usa nyainjapɨ kiya gaahiya Autaahaatɨhopɨ baiwɨ gɨwunyaapɨhiye tɨtotɨwɨ gaapɨpatɨ utaarɨhaiwa gaapundɨwɨhiyaate. Amɨ sahɨ sandɨ siyohɨtɨndapɨ Autaahaatɨho sangi yaasɨhandɨ apɨpaahɨ awaindɨhandɨ nasamɨtaise.) ");
INSERT INTO agm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Wɨnɨhapɨpa katɨwunjohiyɨhiyaatɨ amɨ Parisihiyaatɨ sahɨ apɨpaahɨ jɨnjaipɨtɨwɨ otaatapɨhiyaate Autaahaatɨho yaasɨhandɨ awaindɨhandɨ sangi nasamɨtaise. Sahɨ apɨpaahɨ maaritɨwɨ andɨtatɨ napamapɨ utaaho wo naasoaisangi numwaapɨ samɨ gwɨnyaapɨ kiyohɨwaiwa nunjawɨ katɨwunjisaihɨ noaipatɨ sahɨ sawanaatamatiyatɨ kaiwa japepihɨratɨ isiwatɨtandɨ nandapa namaanɨwɨ amɨ naapɨpa namopɨ daapɨhiyaate. Aiwɨ woai sahɨ numwaapɨ samɨ gwɨnyaapɨ kiyohɨwaiwa koai nunjawɨ katɨwunjauhɨ sangi nasɨtipɨhaatɨ samɨ jɨnjaipɨpa otaatapɨhaiwa biyatɨ maaritatɨ amɨ anɨtisatɨ isɨwatatɨ japepihɨrataise. Japepihɨrihɨ sahɨ koai Autaahaatɨho isɨhiyai netɨ sisɨhaapɨhɨ tɨhoaitandɨhaapɨhɨ sahɨ sawanaatamataiwɨ detɨ nepɨ ahɨwisawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Wɨnɨhapɨpa katɨwunjohiyɨhiyaatɨ amɨ Parisihiyaate, samɨ ndɨha niyotatɨ asɨhatahiyaatisɨ isɨhiyai daihɨra asɨra numwaasi maipɨhaiwa kaitaatɨwɨhɨra nunjohɨtɨndapɨ Autaahaatɨho sangi yaasɨhandɨ nasamɨtaise. Sahɨ isɨhiyai satɨwɨ katɨwunjohɨtɨndapo, ‘Amɨ utaaho wo wapa kaitandɨ gwɨnyaataahapaapɨ Autaahaatɨhomɨ aŋɨ Awaindɨhandapɨ ambɨhɨtatɨ sapa kaitandɨ akɨtɨnɨhɨ kandaato tatɨ katamapɨho amɨ kandɨ katimbɨpa wɨndɨ kamaayataataahɨ gaasɨ namane. O amɨ kahapaamapɨpa Autaahaatɨhomɨ otɨpɨpatapɨhapa gaahaiwa Autaahaatɨhomɨ aŋɨ awaindɨhandaatɨhɨ ahotimbɨpaapɨ ambɨhɨtatɨ sapa akɨtɨnɨhɨ kaitande tatɨ kandaataahɨ komɨ kaitandɨ katimbɨpa ko tɨtɨhɨ kiyane,’ tɨwɨ sahɨ isɨhiyai katɨwunjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sahɨ apɨpaahɨ ndɨha niyotatɨ nahariwɨhiyaate. Napaanɨhɨ jɨhɨ noaipatɨ awaindɨndaise. Kahapaamapɨpa Autaahaatɨhomɨ otɨpɨpatapɨhapa gaahaiwa aŋɨ awaindɨhandaatɨhɨ ahotimbɨpaaro e aŋɨ awaindɨhandɨ kaiwai netɨ anaahɨpɨpa nehɨ Autaahaatɨhomɨhapemasɨtɨndo? ");
INSERT INTO agm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aiwɨ sahɨ isɨhiyai satɨwɨ katɨwunjawaayopo. ‘Amɨ utaaho wapa kaitandɨ gwɨnyaataahapaapɨ nandapa tɨhɨwɨ sisandɨpapɨ waamaitumapɨ Autaahaatɨhoai nunyohɨpɨpɨhɨ arɨtaahandapɨ ambɨhɨtatɨ sapa kaitandɨ akɨtɨnɨhɨ kandaato,’ tatɨ katamapɨho amɨ kaitandɨ katimbɨpa kamaayataataahɨ sandɨ awaindɨhandɨmetisɨ namane. O amɨ ko sapa kaitande tatɨ nandapa tɨhɨwɨ Autaahaatɨhoai nunyohɨpɨpɨhɨ arɨtaahandaasɨnɨ nandapa ahotimbɨpaapɨ ambɨhɨtatɨ kandaataahɨ katimbɨpa kapa tɨtɨhɨ akɨpɨpa kiyane tɨwɨ sahɨ isɨhiyai katɨwunjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sahɨ isɨhiyaatɨ ndɨha niyotahiyaate. Sahɨ ndɨha niyotahiyaatisɨ wɨndɨ mohopo. Napaanɨhɨ noaipatɨ jɨhɨ awaindɨndaise. Nandapa Autaahaatɨhoai numwɨtaatɨwɨhapaaro e nandapa tɨhɨwɨ Autaahaatɨhoai nunyohɨpɨpɨhɨ arɨtaahandɨ nandapa kapai netɨ yandɨhɨ anaahɨpɨpa nehɨ Autaahaatɨhomɨhapemasɨpɨpɨho? ");
INSERT INTO agm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Iyataatɨ nandapa tɨhɨwɨ sisandɨpapɨ waamaindumapɨ Autaahaatɨhoai nunyohɨpɨpɨhɨ arɨtaahandɨ jɨhɨ awaindɨhandisɨ utaaho wapa kaitandɨ gwɨnyaataahapaapɨ kapɨhapɨ ambɨhɨtatɨ sapa kaitandɨ akɨtɨnɨhɨ kandaato ndaataahɨ kapɨhapunɨ amɨ nahataapa kapɨhɨ arɨtaahandaasɨnɨ ahotimbɨpaapɨ ahoyatɨ ambɨhɨndaase. ");
INSERT INTO agm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Iyataatɨ Autaahaatɨhomɨ Aŋɨ Awaindɨhandɨ jɨhɨ awaindɨhandisɨ utaaho wapa kaitandɨ gwɨnyaataahapaapɨ kandapɨ ambɨhɨtatɨ sapa kaitandɨ akɨtɨnɨhɨ kandaato ndaataahɨ sandɨ aŋɨ awaindɨndapunɨ Autaahaatɨho kandaatɨhɨ bindataatɨ kandisɨ netɨ tɨtɨhɨ nehɨ sawahomɨhandemasɨhopunɨ ahoyatɨ ambɨhɨndaase. ");
INSERT INTO agm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Iyataatɨ yamɨhapataatɨhɨ Autaahaatɨho bindataatɨ isɨhiyaisunɨ amɨ kahapaamapɨpaisunɨ iwinjatimbɨpɨhe. Iwinjatimbɨpɨhɨsɨ utaaho wo wapa kaitandɨ gwɨnyaataahapaapɨ sapa akɨtɨnɨhɨ kaito tatɨ yamɨhapataatɨhapɨ ambɨhɨndaataahɨ Autaahaatɨho sapɨhɨ bimisɨhopɨ ambɨhɨndaase. ");
INSERT INTO agm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Sahɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaatɨ Parisihiyaate, sahɨ isɨhiyaatɨ jɨnjaipɨtɨwɨ otaatapɨhiyaate. Sahɨ noaipahosɨha ikosɨha atuhwɨrɨpatɨ akwandɨhɨrɨ mataapɨhapa nimanɨwɨ kɨpwɨwɨ napɨpapɨ awɨtɨwɨ gaahapaisawɨ Autaahaatɨhoai nunyawaayopo. Saiwɨ mataapɨhapa sahɨ andɨta napamapɨ nunyawaawɨ Autaahaatɨhomɨ wɨnɨhapɨpaamɨ pɨwɨha watɨpɨhaiwa nepɨ sehɨmwaawaayopo. Iyataatɨ wɨnɨhapɨpaamɨ pɨwɨha watɨpɨhaiwa satiwaiwaapɨto: ‘Isɨhiya usaisɨ aŋɨnɨ nepusosawɨ nauratɨhaiwɨ usowɨ mmotɨnɨwɨ amɨ maarɨho asɨpɨwiwɨ asɨpainɨwɨ amɨ Autaahaatɨhopɨ ko gaahandɨ nyangi jinjapɨhɨ kainjahoso tɨwɨ gɨwunyaapɨ amɨ yawanaanɨnɨ gaahandɨ kaindɨhaawo tɨwɨ gwɨnyapepɨse,’ tatɨ katiwaiwa sahɨ sehɨmwaahauhɨhaiwaapɨto. Saiwa sehɨmwaahohɨwiwa baiwɨ napaitɨwɨ japepihɨrɨwɨ amɨ Autaahaatɨhomɨ wɨnɨhapɨpa kahapaamapɨpa wapa Autaahaatɨhoai samwaaŋɨ nunyawɨse timumwaaŋɨ kamwaaŋɨ nunyawɨ ahoyawɨ nahataapa isɨwatɨwɨhiyaatɨtihɨto. Saiwɨhiyaatɨtihɨtonɨ sahɨ ahoyawɨ kamaayohɨtɨhandapɨ Autaahaatɨho yaasɨhandɨ sangi nasamɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sahɨ ndɨha niyotatɨ asɨhatahiyaatisɨ isɨhiyai daihɨra wɨndɨ baiwɨ namunjɨtaapo. Samɨ ndɨha niyotahiyaatisɨ nehɨ isɨhiyaatɨ sawanaatamɨ wɨnɨhapɨpa turɨkaare mataapɨhapaahɨhɨ watɨpɨtɨwɨ andɨtatɨ napamapɨ dɨpɨpataasɨnɨ dawaaho kɨsɨmwɨnɨwɨ isɨwatawaahandɨ kandɨ Autaahaatɨhomɨ wɨnɨhapɨpaamɨ tanyaaha watɨpɨhapa awaimbɨpa sahɨ nepɨ sehɨmwaapɨ nanɨpimatawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Wɨnɨhapɨpa katɨwunjohiyɨhiyaatɨ amɨ Parisihiyaatɨ sahɨ jɨnjaipɨtɨwɨ otaatapɨhiyaatisɨ Autaahaatɨho sangi naaŋatɨ yaasɨhandɨ nasamɨtandɨhiyaate. Sahɨ samɨ wipatɨ kaapɨho amɨ nyaihandɨ pɨretɨho ikwaatɨho kipatɨ sanahɨwaiwɨ bausawaahandɨ kandɨ samɨ omaŋɨtɨtɨhɨ kipotɨ ainjotatɨ asɨhatatɨ maipɨhaiwa maatɨmaatɨhɨrɨ amɨ sawanaatamɨ ambɨpatapɨhaiwa ikopaahɨhɨ tɨsaindahiyaate. ");
INSERT INTO agm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ese Parisi ndɨ niyotiso kahapaamapɨpa maipɨhaiwa kinyɨ omaŋɨtɨtɨhɨ gwɨnyaapɨ isɨwatingɨwaiwa namapɨ nepemaite. Nepemaitɨpɨ tɨtɨhɨ kinyɨ omaŋɨtɨtɨhɨ saasanotahoŋɨ daimbɨ bitoaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Wɨnɨhapɨpa katɨwunjohiyɨhiyaatɨ Parisihiyaatɨ sahɨ jɨnjaipɨtɨwɨ otaatapɨhiyaate. Autaahaatɨho naaŋatɨ yaasɨhandɨ sangi nasamɨtaise. Sahɨ isɨhiyaatɨ itapɨpaamɨ anɨmwaahɨpatamatetahiyaate. Iyataatɨ itapɨpaamɨ anɨmwaahɨpatɨ yamaatɨ tiwatɨhaatɨ isɨhiya naihoaapɨ aripa nopɨ nehaapɨ maipɨ amwepatɨ tandɨpɨho tisarɨpɨ yamahauhɨ sanahɨwendaahandɨ kandɨ mɨhatɨhɨ nyepepɨ isɨhiya napohiyɨhiyaamɨ andɨtatɨ amɨ kahapaamapɨpa namasaatahapaapɨ tɨsaindataise. ");
INSERT INTO agm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sahɨ sɨrɨ kɨretɨ yamaatɨ nehɨhaatɨ isɨhiya nahatiyai gaahiyaatamataiwɨ nasoaanawaayopo. Saiwɨ nasoaanawaahandɨ kandɨ sahɨ samɨ omaŋɨtɨtɨhɨ jɨnjaipɨpa otaatapɨhaiwa amɨ maipɨhaiwa kahapaamapɨpa tɨsaindahiyaate. ");
INSERT INTO agm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Wɨnɨhapɨpa katɨwunjohiyɨhiyaatɨ amɨ Parisihiyaatɨ sahɨ jɨnjaipɨtɨwɨ otaatapɨhiyaate. Autaahaatɨho naaŋatɨ yaasɨhandɨ sangi nasamɨtaise. O amɨ apaapɨmaato. Amɨ sahɨ gaahatɨ kiyahaayono tɨwɨ Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya napohiyɨhiyaamɨ anɨmwaahɨpɨhaiwa jinjahɨra naihoaapɨ sanahɨwaiwɨ isɨhiya kiya gaahiyaaso tɨwɨ sahɨ jinjahɨra kiyaapɨ gɨwunyaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Gɨwunyaapɨ amɨ sahɨ satawaatopo, ‘Amɨ nyahɨ jɨhɨ aimehura asoya asisa bimohura bindɨhaawaahɨ kiya kiyohɨpatamatiyaatɨ Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyai wɨndɨ tɨmaawɨtaanɨhe,’ tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sahɨ satawaawaahɨ sahɨ isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyai tiwohiyɨhiyaamɨ saisatoyaatisɨ kiyaamɨ jɨtɨpatɨ samɨhetɨ wɨsaindihɨ kɨretɨ kaitaatɨwɨ sa pɨwa katawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kiyonaahɨ sahɨ jaasoya jaasisa Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyai tiwohɨpatamataiwɨ kiyaatɨnɨ kaimɨ nuwɨse. ");
INSERT INTO agm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sahɨ akwɨranɨhatɨmaatɨ akwɨranɨhomɨ mwaahatɨmaate. Autaahaatɨho sisɨhaapɨhɨ sangisɨ netɨ tɨsɨhoaitandɨhandɨ sahɨ napitaiwɨ nemapɨ yanɨhɨmaitaapo. Owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Isɨ isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaisunɨ amɨ komɨ amɨtɨha gaaha gwɨnyaitandɨhandɨ mmowɨ nepɨhiyaisunɨ amɨ komɨ pɨwɨha katɨwunjɨtaatɨwɨhiyai nɨnɨ netɨ sangisenda nandusaasɨto. Nandusoaasisanɨhɨ kiyaamɨ usaisɨ sɨyɨhiyai sahɨ timmapɨ amɨ usaisɨ ipɨ tɨtɨhɨ atawɨhatetɨ tipɨmandaapɨ sɨyɨhiyai timaapɨ amɨ kiyaamɨ usaisɨ samɨ Autaahaatɨhomɨ aŋɨ awaindɨhandaatɨhɨ nepɨ yupwapɨ tahamanɨwɨ aunahɨpatɨ kahatɨ kahataahemapɨ naaŋatɨ yaawɨhaiwa numwɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Isɨ Autaahaatɨhomɨ isɨhiya tɨtɨhɨ gaahiya ainahiyɨhiyai jɨhɨ aimehura Aberɨhoai timmapɨ koaapɨhapɨ tipɨ napɨmbɨwɨ Berekaiyaahomɨ mwaaho Sekaaraiyaahoai aŋɨ awaindɨhandaatɨhɨ tipɨ tiwohɨwaiwa nahatewaapɨ samɨ jaasoya jaasisai nusatipɨhaapɨ naaŋatɨ yaasɨhandɨ apɨpaahɨ awaindɨhandɨ sahɨ naitaatɨwɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nɨnɨ apɨpaahɨ akɨtɨnɨhɨ sangi kasatataato saiwa nahatewa Autaahaatɨhomɨ isɨhiya ainahiyɨhiyai timmahohɨwiwaapɨ sahɨ isɨhiyaatɨ nisɨ pɨwɨha atiwɨ nisɨ otɨpɨpatɨ kiyohɨwaiwa mmohohiyɨhiyaatɨ nahatiyaatɨ naaŋatɨ yaasɨhandɨ apɨpaahɨ awaindɨhandɨnɨhɨ naitaatɨwɨhiyaate,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Saundatosatɨ Jisaasiho maarɨho asɨpiyatɨ sandaase. “Ese isɨhiyaatɨ Jerusaremɨhandaahapɨhiyaate, Autaahaatɨho isɨhiya komɨ pɨwɨha atiwɨ nepɨ awusaahohiyɨhiya sangisenda natausaasihɨhiyai sahɨ nawɨhaara yahuwɨ sɨyɨhiyai timmapɨhiyaate. Otɨpwɨsɨpaatɨ kaatamɨ mwaahonya sangɨhonyai ditatotɨ netɨ ahoyatɨ iwinjatindɨhandamataindɨ nɨnɨ sangi maarɨho nasanyataatɨ nasamaatɨ ahosisatɨ jainjatɨtondiyonɨhandɨ sahɨ pohipaiwɨ nisenda wɨndɨ namaasopo. ");
INSERT INTO agm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Namaasauhɨ sahɨ isɨhiyaatangisatɨ samɨ aunahɨpatɨ nasamatɨ nehɨ sawanaatamɨ ikwɨraatɨhɨ ahɨsisataayonɨ sahunɨ amɨ samɨ aunahɨpɨhaiwa noaipa netɨ nopɨsasɨnatɨ itɨpɨtɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Iyataatɨ nɨnɨ sangi akɨtɨnɨhɨ kasatataato wanɨ kɨmuraapɨ sahɨ nɨngi jahɨra wɨndɨ apɨpaahɨ maanondaapo. Aiwɨ sahɨ nɨngi nanɨmaitaatɨwɨ tɨmetisaihɨhura napisanɨhɨ sahɨ nisapɨ satɨtaapo. ‘Ko Awaisɨho Autaahaatɨhomɨ watɨpɨhandisa nasataisɨ Autaahaatɨho komɨ gaahaiwa nunyatɨ numwaasane,’ tɨtaapo,” tatɨ Jisaasiho komɨ maarɨho asɨpaindɨhandapɨ katatɨ namɨhaataise. ");
INSERT INTO agm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Aihɨ Jisaasiho Autaahaatɨhomɨ aŋɨ Awaindɨhandɨ namasi notaise. Namasi taatɨ naihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ komɨhinɨ detɨ nasaatɨ koai saundɨhaato, “Aŋɨ Awaindɨmandɨ aŋaaŋɨ apɨpaahɨ sanahɨweta gaahandɨsɨ kɨnyɨ baimbɨ japɨ mmome,” undaatɨ koai nunjɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Saundonɨhɨ amɨ komɨha nyangi sanyatataase. “Ye, akɨtɨsɨ gaahaaŋɨsɨ wanɨmuraahɨhɨ sahɨ baiwɨ kandisɨ iwinjapɨ mmowɨse. Saiwa mmohohɨwiwaapɨ akɨtɨnɨhɨ nɨnɨ sangi kasatɨtaanɨ atiwɨse. Nawɨmaiwa tiwatɨnyepiyatɨ ahotiwɨmaiwa sasaahohaamɨhasɨnɨ apɨpaahɨ naasaahɨsangi tiwatɨnyepiyatɨ wanɨ ahotimbɨpɨhɨ ahɨmotɨtaise. Isɨhiya nepɨ nupwɨsasɨwɨ nahataisɨ noaatɨwopɨ napapɨ yatɨhemaitaapo,” tatɨ nyangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aihɨ Jisaasiho sisɨho Oripɨhoaasɨnɨ niyatɨ bimihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ nehɨ yawanaanɨnɨhɨ koenda niyaatɨ noaipahaayo. Niyaatɨ noaipawa koai saundaatɨ nunjenɨhaayo. “Kɨnyɨ nyangi kanyate, aŋɨ awaindɨmandɨ maahɨwuraanɨhɨ isɨhiya nepɨ niyapɨ nupwɨsasɨwɨ nopɨsasɨtaapo? Aisaihɨ amɨ kɨnyɨ jahɨra napɨtaapɨhandapunɨ amɨ napisamɨhɨ Autaahaatɨho kahapaamapɨpa ahotatɨ isɨhiyaanɨ bimaamɨ niyohurɨmura netɨ owemaitandɨhuraapɨ wapa napaanɨhɨ napitimatataatɨ nyangi nanyɨsɨtaise?” undaatɨ nunjenɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Undaatɨ nunjenɨhonɨhɨ Jisaasiho komɨha nyangi sanyatataase. “Sahɨ bapaiwɨ jatɨnɨwɨhiyaato, wiwa isɨhiya usa jɨnjaipɨsatɨtaawo. ");
INSERT INTO agm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sandɨ apaapɨmaasato amɨ isɨhiya taahiyɨhiya noaipapɨ satɨwɨ, ‘Nɨnɨ kɨmonɨnɨ Isɨhiyai Japɨhɨ Numwaatɨ Iwinjatɨtandɨ Autaahaatɨho Ahɨnisɨhonɨne,’ tɨwɨ isɨhiya taahiyɨhiyaisɨ jɨnjaipundɨtauhɨhandapɨto. ");
INSERT INTO agm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Amɨ sahɨ isɨhiya akɨtɨnɨhɨ nupwɨ nesi tunnɨwɨ yawinjaihɨhaiwaapɨ atiwɨ amɨ nehɨ maatapɨ itɨpɨhora usa tunnɨwɨ yahwɨnɨhopo tɨwɨ atɨhomɨsamasaihɨhaiwaapɨ atitaapo. Sahɨ saiwa atisawaahandɨ kandɨ tunnɨwɨ yahwɨnohɨwaiwaapɨ yaiwɨ samɨ maarɨho jandotɨ wɨsirandɨtaisɨ baiwɨ jatɨnɨwɨhiyaato. Amɨ saiwaahɨ noaipaitaise. Saiwa noaipataahandɨ kandɨ asisɨha ipotɨha Autaahaatɨho kahapaamapɨpa netɨ owematɨ asɨpɨpa ahaitandɨha sangɨ napise. ");
INSERT INTO agm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Iyataatɨ isɨhiya aunahɨpatɨ wɨtaahapɨhiya nupwɨ nesi wɨtaahiyaisawɨ tunnɨwɨ yahwɨndaapo. Aisaihɨ amɨ isɨhiya yapɨpatɨ awaipatɨ wɨtaahapɨhiya nupwɨ nesi amɨ yapɨpatɨ awaipatɨ wɨtaahapɨhiyaisawɨ tunnɨwɨ yahwɨndaapo. Iyataatɨ amɨ yapɨpatɨ taahɨpɨpɨhɨ jahɨro awaiwaiwa noaipatɨ amɨ ipɨpatɨpatɨ asakiyatɨ ipɨpatɨpindaise. ");
INSERT INTO agm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iyataatɨ saiwa naaŋiwaiwa nahatewa isɨhiya nahatiyaamɨ maarɨho apɨpaahɨ awaindɨhandɨ yaawɨtandɨhaiwa napɨtandɨhaiwaamɨ jɨhɨ namasatɨ daihɨra daahɨwataise. ");
INSERT INTO agm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Amɨ saiwa taatɨ siyatɨ noaipapɨ niyonɨhɨ sangisɨ isɨhiya nisapɨsatɨwɨ nepɨ wɨsairapɨ nasamaasi nuwɨ mambɨ isɨhiya awaisawɨhiyaamɨ ikwɨraatɨhɨ ahɨsisaihɨ amɨ kiya sangisɨ yaasɨhaiwa nasanyawɨ amɨ siyɨhiyaatangi tipɨsamaitaapo. Tɨsapɨ sahɨ nisapɨ baiwɨ gɨnunyaapɨ tɨtɨhɨ daiwɨ bimisaihɨ kandapɨ yapɨhɨ nahatewaaraahɨ isɨhiya sangisɨ mandɨtɨsiwɨ ahosɨsamaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Saiwɨ isɨhiya sangisunɨ isɨhiya nisapɨ ipotɨ ipotɨ gɨnunyaasaihɨhiyaisunɨ yaasɨhaiwa nasanyawɨ mandɨtɨsisaihɨ samɨ usa taahiyɨhiya kiya nisapɨ gɨnunyaahotɨhandɨ namapɨ sura kiya tɨmɨhaitaapo. Aiwɨ sahɨ samɨ usaisɨ isɨhiya tiworisa tɨsawɨtaatɨwɨhiyai nusepaitaapo. Saiwɨ nusepaapɨ amɨ sahɨ pohipinɨwɨ ahosɨmatɨwɨ mandɨtindaapo. ");
INSERT INTO agm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Amɨ sura isɨhiya taahiyɨhiya jɨnjaipɨtɨwɨhiya satɨwɨ, ‘Nyahɨ Autaahaatɨhomɨ pɨwɨha atisaatɨ newaatɨ ausaahohiyɨhiyaanɨ pɨropetɨhiyaane,’ tɨwɨ isɨhiya nisapɨ gɨnunyaahohiyɨhiyai jɨnjaipundɨwɨ daihɨra asɨra numwaasi nutaapo. ");
INSERT INTO agm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sura isɨhiya maipɨhaiwa asakaiwɨ kaisaihɨ amɨ isɨhiya kaiwaapɨ yaiwɨ kiyaamɨ maarɨho namɨndaatɨwɨhandɨ namapɨ bwaitaise. ");
INSERT INTO agm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sura kahapaamapɨpa maipɨhaiwa isɨhiya asakaiwɨ kaimɨ naisaihɨhandɨ kandɨ utaaho itapaatɨ wowaatɨ kaiwaapɨ yayatɨ tɨmaamahiyatɨ andɨtitatɨ nisapɨ gɨnunyaatɨ bitopɨ notɨ ipotɨ otasaahaapɨhɨndaataahɨ Autaahaatɨho so saati numwaahonɨhɨ asoho asaamaatimatatɨ jinjapɨhɨ bimɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iyataatɨ Pɨwɨha Gaaha Wanɨha Autaahaatɨho nisɨhetapɨ isɨhiyaisɨ numwaatɨ iwinjatɨtandɨhandapɨ nɨnɨ nesipɨtɨ maapɨ ahiyohɨma sahɨ nesi isɨhiya nahatiya yapɨhɨ nahandaahiyai gaamapɨ ausaapɨ kaundɨtaatɨwe. Saiwɨ kaundɨwɨ gaamasaihɨhura Autaahaatɨho kahapaamapɨpa netɨ owematɨ amɨ asɨpɨpa ahaitaise,” tatɨ Jisaasiho nyahɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Sanyatatosatɨ amɨ pɨwɨha kɨma kaamɨ bihɨwainjatɨ wa nyahɨ komɨ otɨpɨpatɨhiyaanangi Jisaasiho sanyatataase. “Wɨndɨ isɨhiyaamɨ ndɨmaahomwaaŋɨ apɨpaahɨ yaurɨmaahanahandɨ maipɨhandɨ Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ isɨhiya usa nesipɨwɨ ahaisaihɨ kandɨ aŋɨndi netɨ nopɨsasatɨ ahotanɨhɨ tɨtɨhɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho pɨropetɨ Daniyerɨho jɨhɨ katirɨhɨrɨ kɨretɨ sahɨ mmondaapo,” ndaase. Jisaasiho satisɨ Daniyerɨho katisɨha woŋɨ waaŋɨ awɨtohiyɨhiyaatɨ kaapɨ baiwɨ mmowɨ amɨ gwɨnyaapɨse. ");
INSERT INTO agm_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Satatosatɨ Jisaasiho netɨ bihɨwainjatɨ satɨmɨ notaise. “Isɨ sura isɨhiya usa aŋɨ Awaindɨhandɨ nepɨ nopɨsasisaihɨhura yapɨpatɨ Judiyaahanda Jerusaremɨhandɨ ahetimbɨpɨhɨ isɨhiya bindawaahiya sisɨhaiwaasɨnɨ noaatɨtaatɨwɨhapɨhɨ kaanɨhɨ isɨhiya kiyai tiwɨtaatɨwɨhiya tiworisaapɨ yanɨhɨmapɨ naiwɨse. ");
INSERT INTO agm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Saiwɨ yanɨhɨmasaihɨ amɨ utaaho wo komɨ masapɨpɨhɨ itɨpɨho netɨ ikɨnatɨ bitosɨho komɨ aŋaaŋɨ nandaatɨ komɨ ikɨpɨpa wɨndɨ asa namene. Nehɨ konɨhɨ isɨhiyaapɨ yanɨhɨmane. ");
INSERT INTO agm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Iyataatɨ amɨ utaaho wo komɨ osaataatɨ otɨpɨpatɨ kiyatɨ bitosɨho komɨ apotɨhɨrɨ naitandɨ komɨ aŋɨpɨpɨhapɨ nepemaitatɨ jahɨra wɨndɨ namone. Nehɨ konɨhɨ isɨhiyaapɨ yanɨhɨmane. ");
INSERT INTO agm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","‘Ese nisɨ maarɨho tɨndataise asɨhiya maahaapɨ gwɨsɨtɨwɨ amɨ maaha sangɨha amwɨtɨhɨrɨ nunyohiyɨhiya usɨhiyaamataiwɨ nawɨhaiwɨ nihɨtɨwɨ wɨndɨ yamaanɨhɨmasaihɨ isɨhiya yaawɨhaiwa apɨpaahɨ awaiwaiwa kiyaisɨ sura numwɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Isɨ saiwa naaŋɨhaiwa asisɨha wipɨwatɨ itɨnambɨtɨrisatɨ mbwaahonɨhura amɨ asisɨha ikɨndaatɨwɨha Sapaatɨhandetɨ wɨndɨ sangi namaasoaipaitandɨ Autaahaatɨhopɨ baiwɨ kiyaatɨnɨhɨ gaapundɨmɨ nuwɨse. Amɨ wɨnɨhapɨpa asisɨha Sapaatɨhandetɨ kaanɨhɨ wɨndɨ dahomaiwɨse tahuraaso. ");
INSERT INTO agm_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Iyataatɨ saiwa naaŋa yaasɨhaiwa awaiwaiwa asakiyatɨ sura noaipasɨwiwa jɨhura wuwanɨ yeyetatɨ yamɨhapa yapɨpatɨ kahapaamapɨpa Autaahaatɨho ahaisururaapɨ noaipapɨ napiwaiwai apɨpaahɨ awaindɨhandɨ nusatipɨhaatɨ noaipaitaise. Iyatɨ amɨ ipotɨ ipotɨsangi siyatɨ naaŋɨhaiwa awaiwaiwa wiwa sura noaipasɨwiwaamatiyahaiwa wɨndɨ namoaipaitaise. Owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Iyataatɨ amɨ Autaahaatɨho sura asisɨha kaiwetɨ naaŋɨhaiwa noaipaitandɨha netɨ namandipatɨ wɨndɨ nuhɨmaamahonaahɨ amɨ isɨhiya nahatiya kiyaanɨhɨ owetamaitaihe. Saiwɨ owetɨtɨhandɨ kandɨ komɨ isɨhiya sawahopɨ baiwɨ andɨtitɨwɨ gɨwunyaahohiyɨhiyaapimatonɨhɨ namatɨ Autaahaatɨho asisɨha kaiwetɨ naaŋɨhaiwa noaipaitandɨha netɨ namandipatɨ nuhɨmaitaise. ");
INSERT INTO agm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Iyataatɨ amɨ sura utaaho wo sangisɨ sasatatɨ, ‘Jasawewɨse! Isɨhiyaisɨ Japɨhɨ Numwatɨ Iwinjatɨtandɨ Autaahaatɨho Namɨhanatɨ Ahɨwisɨho kɨmbɨhɨ kɨmore,’ tatɨ amɨ wo, ‘mɨhapɨhɨ sore,’ tatɨ kasatonaahɨ sahɨ koaisɨ wɨndɨ atɨhomaawiwɨse. ");
INSERT INTO agm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Iyataatɨ amɨ sura isɨhiya noaipapɨ sangisɨ jɨnjaipɨsatɨwɨ usa satɨtaapo. ‘Nɨnɨ Isɨhiyaisɨ Japɨhɨ Numwaatɨ Iwinjatɨtandɨ Autaahaatɨho Nanɨmahanatɨ Ahɨnisɨhonɨne,’ tɨwɨ tɨtɨhɨ akɨtɨhiyaamataiwɨ noaipaitaapo. Noaipapɨ isɨhiya Autaahaatɨhopɨ baiwɨ andɨtitɨwɨ gɨwunyaapɨ niyohiyɨhiyai jɨnjaipundɨwɨ daihɨra owetɨtaatɨwɨhɨra numwaasi nutaatɨwɨ kahapaamapɨpa sɨwipatɨ watɨpɨhaiwa isɨhiya ese akɨte tɨwɨ mmondaatɨwɨhaiwa kaitaapo. Saisaihɨhandɨ kandɨ Autaahaatɨhopɨ baiwɨ gɨwunyaahohiyɨhiya kiyaisɨ wɨndɨ atɨhomaawitaapo. ");
INSERT INTO agm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Saiwa siyatɨ noaipaitaihɨ jɨhɨ aimɨ tɨmanɨtɨ nɨnɨ sangisɨ kasatataato amɨ sahɨ baiwɨ jaawɨ atiwɨ gwɨnyaitaatɨwo. ");
INSERT INTO agm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Isɨ amɨ isɨhiya sangisɨ nisapɨ jaipɨsatɨwɨ ‘Jasawise ko isɨhiya iwɨwɨrɨho owehapɨhɨ mɨhore tɨwɨ kasatisaihaahɨ sahɨ kiyaisɨ wɨndɨ atɨhomaawiwɨse.’ Aiwɨ amɨ kiya satɨwɨ, ‘Jasawise ko kɨmbɨhɨ kɨmore,’ tisaihɨhandɨ kandɨ sahɨ kiyai wɨndɨ atɨhomaawiwɨse. Owetane. ");
INSERT INTO agm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sandɨ nɨnɨ apaapɨmaasato amɨ nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ nasataahura kɨnapɨpa kɨnapinatɨ ipɨho noaipasɨpɨpɨhapɨ yamɨhapatɨ nahandɨ nahɨraapɨ ipɨho nipainjɨpɨpɨhɨ naihɨ isɨhiya iwinjahohɨpatamataindɨ auta isɨhiya nahatiyaamɨ ndɨhetɨ napɨto. ");
INSERT INTO agm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sahɨ mmonɨwɨhiyaate itapɨpa namasaatatɨ ainjotatɨ ahotihɨhapɨhɨ jurɨho noaipatɨ ahoyanatɨ netɨ nanatɨ owemasɨho. Isɨ nɨnɨ napisanɨhura sɨrɨ kɨretɨ maapɨ yapɨpataapɨhɨ noaipaitaise,” tatɨ Jisaasiho kandaase. ");
INSERT INTO agm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Sanyatatosatɨ kɨma kaamɨ bihɨwainjatɨ Jisaasiho sandaase: Naaŋɨhaiwa sura noaipasɨwaiwa owetanɨhɨ nehɨ ketɨ kuraanɨhɨ, ‘Ipɨho noaipataaho ko wɨndɨ yahomutaatɨ apɨpaahɨ asɨhatamatɨ waatɨho noaipatɨ wɨndɨ tɨhomwaatɨ amɨ kaumbwaatɨ yamɨhapataatɨhapɨ tɨmahiyatɨ amɨ kahapaamapɨpa watɨpɨhaiwa mɨhaatɨ autaahapɨhaiwa kapaamɨ tɨtɨhɨ daihɨra daayatɨ bitotɨ ahotimbɨpɨhɨ namasi tɨmɨhaitaise.’ ");
INSERT INTO agm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Iyonɨhɨ sura nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ mɨhaatɨ yamɨhapataatɨhɨ noaipasanɨhɨ amɨ isɨhiya pɨwɨha kaha kaha katohiyɨhiya nahatiya maarɨho asɨpaiwɨ gwɨwɨ ninjasaihɨ nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ yamɨhapataatɨhɨ tɨwipataatɨhɨ nisɨ watɨpɨhandɨ saasanotindɨhandisatɨ napɨto. ");
INSERT INTO agm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Napisanɨhɨ otɨpɨho kapaparɨhɨrɨ ipopɨ ganɨhonɨhɨ nisɨhiya nahatiya atitaapo. Atisaihɨ nɨnɨ nisɨ yamɨhapataatɨhapɨ enjerɨhiya otɨpɨpatɨhiyai netɨ yapɨpataapɨhɨ aunahɨpatɨ nahatewaara gaamatɨ nandusoaasisanɨhɨ nuwɨ nisɨ isɨhiya nahatiyai nepɨ ahonitaapo,” ndaase. ");
INSERT INTO agm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jisaasiho satatosatɨ nyahɨ komɨ otɨpɨpatɨhiyaanangi pɨwɨha kɨma kaamɨ bihɨwainjatɨ kanyatɨmɨ notaatɨ ko sandaase: “Sahɨ awaatɨpɨhoai baiwɨ mmonɨwɨ iwinjapɨ gwɨnyaapɨse wapa noaipaitandɨhuraapɨ nasisatɨ kasatɨtaiso. Sawanaatɨ aimɨ mmonɨhohɨtɨhande, awaatɨpɨho kupwɨratɨ tɨwɨhaasɨhɨ sahɨ mmonawaawɨ satohɨtɨhande, ‘kimbapɨho kɨmo ipɨhopɨhondaatisɨ ipɨho nga ipɨtatɨ yatitande,’ tɨwɨ gwɨnyaahohɨtɨhande. ");
INSERT INTO agm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Isɨ sahɨ awaatɨpɨhoai iwinjapɨ gwɨnyaahohɨtɨhandisɨ kahapaamapɨpa naaŋɨhaiwa amɨ maipɨhaiwa noaipaitaise satɨtɨ kasatohɨwɨmaiwa noaipahonɨhɨ sahɨ mmonawaawɨ nisapɨ komɨ napɨtandɨhura detɨtatɨ tɨmendaatiso tɨwɨ sahɨ gwɨnyaapɨse. ");
INSERT INTO agm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Isɨ kɨmandɨ akɨtɨnɨhɨ nɨnɨ sangisɨ kasatɨtaanɨ atiwɨse. Saiwa noaipaitaise satɨtɨ kasatɨmɨ nasohɨwaiwa katohɨrɨhɨrɨ kɨretɨ isɨhiya kɨmiya wɨndɨ owemetɨwɨ binyaihɨ noaipaitaise. ");
INSERT INTO agm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Iyataatɨ yamɨhapatɨ amɨ yapɨpatɨ kahapaamapɨpa owetanɨhandɨ kandɨ nisɨ pɨwɨha wɨndɨ apɨpaahɨ owemetatɨ nahata kaanɨhɨ ahotɨmɨ notaatɨ kaamɨ akɨpɨpa nɨnɨ katohɨrɨhɨretɨ tɨtɨhɨ noaipaitaise,” tatɨ nyahɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Sanyatatosatɨ amɨ kɨma kaamɨ wa ko sandaase. “Nɨnɨ jahɨra napɨtandɨhura asisɨha amɨ ipɨhomɨ sɨwipatɨ ahura sura ko napɨtaiso tɨwɨ mambɨ isɨhiya nahatiya apɨpaahɨ wɨndɨ mohopo. Amɨ yamɨhapataatɨhapɨ Autaahaatɨhomɨ enjerɨhiya itɨpɨhiyaisangi wɨndɨ mohopo. Owe. Nehɨ Apɨho Autaahaatɨho sawahohɨ nɨnɨ jahɨra napɨtandɨhura asisɨha ipɨhomɨ sɨwipatɨ mmonatɨ gwɨnyaahore. ");
INSERT INTO agm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Iyataatɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ napɨtandɨhura isɨhiya Nuwaahomɨhura kahapaamapɨpa kiyohɨwaiwaamatiyahaiwa isɨhiya kaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Saiwɨ jɨhɨ sura Nuwaahohura wipatɨ wipɨwatɨ usepatɨ usepuwatɨ durɨhɨrɨ sangɨ nimainjɨhura isɨhiya nanɨhaiwɨ kiyaamɨ nasɨsoaarɨ kiyohɨpatɨ kaiwɨ nandapa wɨrapɨ nepɨ tɨhɨwɨ nanɨwɨ amɨ usɨhiya asɨhiya nepɨ nusoaasawɨ nusoaasanɨwɨ wɨrapɨ namaatɨnɨmɨ nuwɨ asisɨha Nuwaaho kopuhotɨ nandaasuraisangi katɨ taawɨ kiyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Aiwɨ nuwaahoai kiyaahɨ wɨndɨ naingaapɨ maawinjapɨ wipɨwatɨ usepuwɨtaiso tɨwɨ wɨndɨ gɨmunyaapɨ kiyaamɨ kiyohɨwaiwaapaahɨhɨ nambɨtɨwɨmɨhauhɨ Autaahaatɨho wipɨpasɨhɨ wipɨwatɨ usepatɨ awaindɨhandɨ usepuwatɨ durɨhɨrɨ awairɨhɨrɨ nimaanatɨ dotɨ ketɨ kiya kiyaanɨhɨ nahatiyaisɨ netɨ nawatisatɨ nainje. Isɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ napɨtandɨhura sɨkiyatɨtɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Iyataatɨ sura nɨnɨ napɨtɨ isɨhiya usaisɨ numwaataatɨ usai nemaito. Aindɨ sura utaahurɨ yahurɨ kuramɨ osaataatɨ taamɨ otɨpɨpatɨ kaitaise. Kaisaihɨ kuramɨ woai numwaataatɨ amɨ woai nemaito. ");
INSERT INTO agm_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Iyataatɨ sura apopɨpurɨ yapurɨ taamɨ napaihɨrɨ nawenɨtaise. Taamɨ nawesaihɨ kapuramɨ waati numwaataatɨ amɨ waati nemaito. ");
INSERT INTO agm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Isɨ Nɨnɨ samɨ Awaisɨhonɨnɨ napɨtandɨhura asisɨha sahɨ wɨndɨ mohowɨ baiwɨ namopɨ samɨ ndɨha naingaapɨ jatɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Iyawaawɨ kɨmandɨ nɨnɨ akɨtɨnɨhɨ sangisɨ kasatɨtandiyonɨ sahɨ baiwɨ gwɨnyaapɨse amɨ utaaho wo aŋaaŋamɨ satɨho utaaho wo komɨ aŋaaŋɨ nawatatɨ ikɨpɨpa ikowɨndandɨho napɨtandɨhuraapɨ mmonahondaataahɨ ko wɨndɨ namotɨ konɨhɨ jaatɨ bimonɨhɨ ikowɨndandɨho wɨndɨ nandaatɨ komɨ aŋaaŋɨ nurɨwatatɨ ikɨpɨpa wɨndɨ namusaitaise. ");
INSERT INTO agm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Isɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ sahɨ ko napɨtaiso tɨwɨ wɨndɨ minjatɨwɨ nehɨ sangi nanɨhaiwɨ maanɨmaanaisaihɨhura napɨtɨpanɨ sandapɨ sahɨ baiwɨ kiyaatɨnɨhɨ asisɨha nahatewetɨ wɨndɨ namopɨ jatɨmɨ nuwɨse,” ndaase. ");
INSERT INTO agm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","46","Jisaasiho satatɨ katatosatɨ kɨma ka katisɨmaapɨ namɨhanatɨ wa sandaase: “Utaaho wo awaisɨho ikɨpɨpa kahapaamapɨpa taahɨpɨpa amɨ otɨpɨpatɨhiya taahiyɨhiyaisaho wapɨhapɨ notaahura komɨ otɨpɨpatɨhiyaamɨ woaisɨ kiyaamɨ awaisɨhoematatɨ iwinja bitotɨ nandapa kapaapɨhura kiyaisɨ nemwɨtandɨ ahɨwisataise. Utaaho napitiyatɨ napitetahoaisɨ komɨ otɨpɨpatɨhiyai iwinja bitoaitandɨ ahɨwitaise? Utaaho amɨtɨha biyatɨ gwɨnyaatɨ amɨ napaitatɨ komɨ awaisɨho napɨtandɨhuraapɨ jatataatɨ otɨpɨpatɨ nunyamɨ naipatɨ konɨhɨ kaimɨ nutandɨhoaisɨ ahɨwitaise. Isɨ utaaso siyatɨ amɨtɨha gaaha biyatɨ gwɨnyaatɨ napaitatɨ otɨpɨpatɨ kaimɨ naiso komɨ awaisɨho nasatɨ usohonɨhura biyatɨ nga maaritɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nɨnɨ sangisɨ akɨtɨnɨhɨ kasatataato. Otɨpɨpato somɨ asɨmwaatɨtɨhɨ komɨ awaisɨho komɨ ikɨpɨpa kahapaamapɨpa nahataapa netɨ ahiyonɨhɨ winjatɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","O amɨ otɨpɨpato so komɨ amɨtɨha gaaha gwɨnyaitandɨhandɨ owetatɨ amɨ biyatɨ komɨ awaisɨho napɨtandɨhuraapɨ wɨndɨ minjatahondaataahɨ komɨ omaŋɨtɨtɨhapɨ sawaho satɨndaise: ‘Nisɨ awaisɨho ketɨ jahɨra wɨndɨ namaasatɨ utaarɨhandɨ bɨsotɨtaise tɨtaise’. ");
INSERT INTO agm_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Satatɨ komɨ sasaahoya otɨpɨpatɨhiyai netɨ ipatisatɨ tiwatɨ nusopɨsasatɨ amɨ isɨhiya waapoho watɨpɨho nanɨwɨ naharisohiyɨhiyaisatɨ nandapa awaimbɨpa wɨratɨ netɨ tɨhatɨ waapoho watɨpɨho naharitaatɨwɨho netɨ nanatɨ naharisatɨ bimɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Siyatɨ bimonɨhɨ komɨ awaisɨho asisɨha wiwetɨ otɨpɨpato naharisatɨ nisɨ awaisɨho sura napɨtaisomaatatɨ nehɨ koaisɨ nanɨhiyatɨ monatɨ bimonɨhura napɨtaise. ");
INSERT INTO agm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nasatɨ awaisɨho so otɨpɨpatɨhoaisɨ netɨ ambɨpatɨ maarɨho yaawɨhandɨ neunyonɨhɨ amɨ isɨhiya otaatapɨhiya yaawɨhaiwa nehohɨwaiwa kiyaisatɨ naitaise. Iyatɨ sapɨhɨ ko ngotɨ amɨ komɨ mangɨrɨ gitɨpaitaise,” tatɨ Jisaasiho nyahɨ komɨ Otɨpɨpatɨhiyaanangi namɨhanatɨ kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Sanyatatosatɨ kɨma kaamɨ pɨwɨha wa japepihɨratɨ nyahɨ koai nɨwipinjaatɨ komɨ otɨpɨpatɨ mmonaatɨ newaatɨ kiyaatɨ daayohiyɨhiyaanangi sanyatataase. “Asisɨha sura nɨnɨ jahɨra napɨtandɨhura Autaahaatɨho nisɨhetapɨ isɨhiyaisɨ iwinjatindɨhandaatɨhɨ wapa siyatɨ noaipaitaise. Asɨhiya apwainyɨhiya ikwɨ maindɨmwɨ utaaho wo wanɨ konɨhɨ namaatahoaisɨ winjapɨ nutanɨwɨ numwaitaatɨwɨ apatindɨtɨhɨ nowaayopo. Nowaawɨ kiyaamɨ norɨhɨrɨ nasorɨhɨrɨ raamɨhandɨ nepɨ tɨpopɨ isɨsi nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Iyawaawɨ kinyaamɨ winya 5 kaiwɨ ikwɨ wihɨtɨrɨtahinya amɨtɨha gaahandɨ gwɨnyaitaatɨwɨhandɨ owetatɨ nahɨriwɨ nanɨpimatɨwɨhinyaare. Aiwɨ amɨ kiyaamɨ winya ikwɨrɨ wihoaaŋɨhɨrɨ 5 kaiwɨhinya amɨtɨha gaahandɨ gwɨnyaitaatɨwɨhandisahinyaare. ");
INSERT INTO agm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aiwɨ nahɨriwɨ amɨtɨha gaahandɨ gwɨnyaitaatɨwɨhandɨ owesinya kinyaamɨ norɨhɨrɨ raamɨhandɨ waapoho sisɨha tɨpoaitaatɨwɨho windahandɨ nepɨ isɨwawaahandɨ kandɨ waapoho isoho wɨndɨ nepɨ mihopo. ");
INSERT INTO agm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nahariwɨhinya siyauhɨ amɨ amɨtɨha gaahandɨ gwɨnyaitaatɨwɨhandisahinya kinyaamɨ norɨhɨrɨ raamɨhandɨ waapoho tisaitahaiwa nepɨ amɨ raamɨhandɨ nipɨtonɨhapɨho waapoho isohoaisawɨ nepɨ isɨsi utaaho apopaati wanɨ konɨhɨ netɨ wɨrasɨhopɨ jatɨtaatɨwɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nuwɨ kiyaamɨ raamɨhandɨ tɨpopɨ ahiyawosawɨ jatauhɨ utaaho apopaatɨ wanɨ konɨhɨ netɨ wɨrasɨho wɨndɨ namaasataise. Namaapihɨ apopɨ apwaimaaminyinyaamɨ ndɨha yaawatɨ naawihɨ mɨtɨho tɨmahiyawɨ nepɨ amɨ namapɨ apɨpaahɨ nanomawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Saiwɨ kinya nanomɨhauhɨ notɨ konɨmosohura apwɨtetetɨnɨhɨ isɨhiya usa satɨwɨ kaahaatawaatopo. ‘Utaaho wanɨ konɨhɨ apopaati netɨ wɨrasɨho kɨmo napisɨ napɨwɨ nuwipaapɨ iwinjasawɨse,’ tɨwɨ kaahaatawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Satɨwɨ kaahaatauhɨ asɨ apwainyɨhiya nanomahohiyɨhiya kaahaapa kapetɨ nepapɨ kiyaamɨ raamɨhandɨ nepɨ tɨpoaitaatɨwɨ waapoho kɨsɨhɨsiwɨ mmonɨwɨ wɨrɨhɨrɨ tɨhwɨtitandɨhɨrɨ tɨwɨhaapɨ tɨtɨhemawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Saiwɨ kɨsɨhɨsiwɨ tɨtɨhemapɨ mmonɨwosawɨ nahɨriwɨ amɨtɨha gaahandɨ gwɨnyaitaatɨwɨhandɨ owehinya amɨtɨha gaahandɨ gwɨnyaitaatɨwɨhandisahinyai saundawaatopo. ‘Yainyaanamɨ raamɨhandɨ waapoho owetatɨ nipɨnda nehɨmanisɨ sainyaatamɨ waapoho wo nanyinyawɨse,’ undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Saundɨwɨ nunjenɨhauhɨ amɨtɨha gwɨnyaitaatɨwɨhandisahinya amɨtɨha owehinyai saundawaatopo. ‘Owe. Waapoho sapunɨ nyapunɨ nausetɨtɨtaise. Yainyaanamɨ waapoho sainyaatangi apɨpaahɨ akɨtɨnɨhɨ wɨndɨ namaasamɨto. Namaasamɨtaanɨ namapɨ sainyaatɨ komɨ anɨhaiwaapɨhɨ isɨhiya jatohɨpɨpɨhɨ nuwɨ nunyawɨ nepɨse,’ undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Saundauhɨ namapɨ apopɨ apwaimaaminyinya amɨtɨha gaahandɨ gwɨnyaitaatɨwɨhandɨ owehinya waapoho kinyaapɨho nunyawɨ naitaatɨwɨ nuwɨmawaayopo. Nuwɨmɨhauhɨhura utaaho apopaati wanɨ konɨhɨ netɨ wɨrasɨho nasatɨ noaipataise. Nasatɨ noaipasɨhɨ apopɨ apwaimaaminyinya tɨmetɨwɨ jatohinyinya koaisawɨ nutasi ko namaatindɨhandapɨ isɨhiya ahoyanɨwɨ maaritɨwɨ nandaatɨwɨ nandapa tɨhɨwɨ tɨmesohɨpɨpɨhɨ aŋɨpɨpɨhɨ nuwɨ nandawaayopo. Nuwɨ nandaahauhɨ maasomwaaŋɨ nepɨ napuwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Saiwɨ maasomwaaŋɨ nepɨ napwɨtɨwɨ bimauhɨ ipotɨ apopɨ apwaimaaminyinya waapoho nunyawɨ naita niyohinyinya napɨwɨ ipaahaapɨ bitotawa satawaatopo. ‘Ese awaisɨhonye, maasomwaaŋɨ nanyupwe nyahɨ nandaitaano,’ tɨwɨ gɨwusewaayopo. ");
INSERT INTO agm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Satɨwɨ kinya maasomwaaŋapɨ gɨwusehauhɨ utaaho wanɨ konɨhɨ apopaati netɨ wɨrasɨho kinyai saundataase. ‘Nɨnɨ sainyaatangi apɨpaahɨ wɨndɨ maasɨsonɨtɨhinyaate,’ undataase,” tatɨ Jisaasiho nyahɨ komɨ otɨpɨpatɨhiyaanangi sa pɨwɨha namɨhanatɨ kanyatatɨ owemataise. ");
INSERT INTO agm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Sanyatatɨ owemataatɨ nyahɨ gwɨnyaitɨhaaha sanyatataase. “Isɨ amɨ asisɨha amɨ ipɨhomɨ sɨwipatɨ nɨnɨ jahɨra napɨtandɨhuraapɨ sahɨ wɨndɨ mohowɨ namopɨ kiyaatɨnɨhɨ tɨmetɨwɨse,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sanyatatosatɨ kɨma kaamɨ wa namɨhanatɨ Jisaasiho sandaase. “Autaahaatɨho nisɨhetapɨ isɨhiyaisɨ iwinjaatɨ bimaamɨ notɨ amɨ nɨngi jahɨra natanoaasonɨhɨ napɨtɨ isɨhiyaisɨ netɨ tipɨtapaitandɨhandɨ siyatɨ ahondaise. Utaaho awaisɨho ikɨpɨpa nawɨho asakausetaho kaanɨhɨ wapɨhɨ daayatɨ bitoaitandɨ nutandɨ detɨtihɨ komɨ otɨpɨpatɨhiyai komɨ ikɨpɨpa iwinjatawa amɨ otɨpɨpatɨ kaitaatɨwɨho nawɨho numwɨtandɨ gaatatɨ numwaataise. ");
INSERT INTO agm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Gaatatɨ numwaatɨ kiya nasauhɨ kiyaamɨ gwɨnyaapɨ otɨpɨpatɨ kiyauhɨ sawaho iwinjasɨrɨhɨretɨ mmonatɨ nawɨho kiya otɨpɨpatɨ kora nesi kaitaatɨwɨho nunyataise. Iyatɨ jɨhɨ woaisɨ 5,000 Kina kiyatɨ nunya amɨ kapɨhɨ woaisɨ 2,000 Kina kiyatɨ nunya amɨ ipotaataatɨ woaisɨ 1,000 Kina kiyatɨ nunyataise. Siyatɨ komɨ otɨpɨpatɨhiya murɨmoai nawɨho sapa nunyatɨ kiyamapɨ kaanɨhɨ wapɨhɨ daayatɨ bitotɨ bimɨtandɨhapɨhapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Aihɨ otɨpɨpatɨ komɨ awaisɨho nawɨho 5,000 kiyatɨ numwisɨho ketɨ kuraanɨhɨ dotɨ nawo so nesi koraahɨ otɨpɨpatɨ kiyataise. Nesi kiyatɨ nawɨho koetapɨ nawɨho wo 5,000 Kina kiyatɨ namoyaatɨ ahɨwatɨ netaise. Nesɨhɨ nahato notɨ 10,000 Kina kiyataise. ");
INSERT INTO agm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Amɨ naasaipitɨ kiyatɨ otɨpɨpatɨho komɨ awaisɨho nawɨho 2,000 Kina kiyatɨ numwisɨhoaisangi nawɨho wo jɨhomɨ tiwatɨhaatɨ 2,000 Kina kiyatɨ nesɨhɨ nahato notɨ 4,000 Kina kiyatɨ noaipataise. ");
INSERT INTO agm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aihɨ amɨ otɨpɨpatɨho nawɨho 1,000 Kina kiyatɨ komɨ awaisɨho numwisɨho nesi koraahɨ otɨpɨpatɨ kamaayatɨ amɨ anɨmwaahɨpatɨ yamwaatɨ katopɨ komɨ awaisɨhomɨ nawɨho wiwatɨ noaasatosataise. ");
INSERT INTO agm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Otɨpɨpatɨhiyaamɨ awaisɨho notɨ utaarɨhandɨ kaanɨhɨ bɨsotinjatɨ komɨ nawɨho otɨpɨpatɨhiyaisɨ nesi otɨpɨpatɨ kaiwɨse undatɨ numwisɨho netɨ tɨtɨhematɨ mmondandɨ jahɨra nasatɨ noaipataise. ");
INSERT INTO agm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nasatɨ noaipatɨ komɨ otɨpɨpatɨhiyaapɨ gaatihɨ kiya noaipawaayopo. Noaipapɨ otɨpɨpatɨho komɨ awaisɨho nawɨho ikihɨ sanaatɨ 5,000 Kina kiyatɨ numwihɨ nesi otɨpɨpatɨ kaisɨho nesi nasatɨ komɨ awaisɨhoai nunyataatɨ saundataase. ‘Nawɨho kɨmo kɨnyɨ mmonɨpeme. Kɨnyɨ nɨngi 5,000 Kina kaimbɨ nanɨminɨhɨ nesi kora otɨpɨpatɨ kiyataatɨ komɨ tiwatɨhaatɨ nehohɨho 5,000 Kina kiyatɨ kɨmore. Iyatɨ nahato notɨ 10,000 kina kiyatɨ kɨmo noaipataise,’ undatɨ nesisaunyataise. ");
INSERT INTO agm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Saundatɨ nesisaumwihɨ komɨ awaisɨho koai saundataase. ‘Kɨnyɨ nga nawɨhaimbɨ napaitɨpɨ otɨpɨpatɨ kiyapaise. Kɨnyɨ otɨpɨpatɨhoŋɨ napaitarɨhoŋɨ otɨpɨpatɨ baimbɨ itatamanɨpɨ kiyapaise. Nawɨho gwɨharaahonya itatamanɨpɨ baimbɨ isɨpɨ jatapainɨ nɨnɨ gisɨ wapa taahɨpɨpa asakaindɨ nahɨmisanɨhɨ jatɨtaapo. Kɨmaiwa jatɨtaapɨ nahɨmɨtandɨ nɨnɨ maaritohɨtɨmandapɨ kɨnyɨ nɨngisapɨ maasɨ maaritɨme,’ undataase. ");
INSERT INTO agm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Aihɨ otɨpɨpatɨ komɨ awaisɨho nawɨho 2,000 kina kiyatɨ numwisɨho nasatɨ komɨ awaisɨhoai saundataase. ‘Awaisɨhonye nawɨho kɨmosɨ nepɨ mmonɨpeme. Kɨnyɨ nɨngisɨ 2,000 kina kaimbɨ nanɨmingɨho nesi otɨpɨpatɨ kaindɨ kinyɨhomɨ tiwatɨhaatɨ 2,000 kina kaindɨ nisɨho nehohɨho kɨmore,’ undatɨ komɨ awaisɨhoai nesisaunyataise. ");
INSERT INTO agm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Saundatɨ nesisaumwihɨ komɨ awaisɨho koaisɨ saundataase. ‘Kɨnyɨ nga napaitɨpɨ otɨpɨpatɨ kiyapaise. Kɨnyɨ otɨpɨpatɨhoŋɨ gaahoŋɨ napaitarɨhoŋe. Nawɨho naasonyaahɨhɨ nahɨnyonɨhɨ kɨnyɨ baimbɨ itatamanɨpɨ jatapainɨ namatɨ wapa taahɨpɨpa asakaindɨ kɨmaiwa jatɨtaapɨ nahɨmɨtandɨmandapi maaritataayonɨ kɨnyɨ nɨngisapɨ maasɨ maaritɨme,’ undataase. ");
INSERT INTO agm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Aihɨ otɨpɨpatɨ komɨ awaisɨho nawɨho 1,000 kina kiyatɨ numwisɨho nasatɨ nehɨ koaisunyaatɨ awaisɨhoai saundataase. ‘Awaisɨhoŋe nɨnɨ kɨnyɨ kaingɨwaiwa mmonɨtɨhonɨne. Kɨnyɨ utaahoŋɨ apɨpaahɨ watɨpɨhoŋɨ isɨhiya kinyɨ otɨpɨpatɨ kahiwɨ kinyɨ nawɨho ginjasohiyɨhiyaapɨ wɨndɨ baimbɨ gɨmaawunyaapɨhoŋe. Aimbɨ kɨnyɨ nawɨho nesi otɨpɨpatɨ kaiwɨ asoho kiya nepɨ ahiyauhɨhapa kiyaapɨhapa nepɨmunyapɨ nahataapa nehɨ kɨwahoŋɨhɨ nepɨ nanɨpɨhoŋe. ");
INSERT INTO agm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Saimbɨhoŋɨtihɨ nɨnɨ yaindɨ wiwa nɨnɨ kinyɨ nawɨho nesisɨ otɨpɨpatɨ kaindɨ kinyɨhomɨ tiwatɨhaatɨ netɨ ahaisanɨho nisapɨho nepɨmaaninyapɨ kɨwahoŋɨ nepɨ nandainɨhɨ namatɨ kinyɨ nawɨho anɨmwaahɨpatɨ yamwaatɨ katopɨ witɨ noaasahisosataayo. Noaasahisosatatɨhosɨ konɨhɨ nahato kɨmosɨ nepe,’ undatɨ nesisaunyataise. ");
INSERT INTO agm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Saundihɨ komɨ awaisiho koaisɨ komɨha saundataase. ‘Kɨnyɨ otɨpɨpatɨhoŋɨ apɨpaahɨ maipɨhoŋɨ pohipaimbɨ tɨhautɨpɨhoŋɨ tɨhaanyohoŋe. Ye, kɨnyɨ saimbɨ nisapɨ mmonɨpɨ gwɨnyaapɨ katapaase. Akɨte. ");
INSERT INTO agm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","O amɨ kɨnyɨ nisapɨ saimbɨ mmonɨpɨ gwɨnyaapɨ satapaapaahɨ nisɨ nawɨho nawɨhomɨ aŋɨpɨpɨhɨ asoho nanɨmoyaita kɨnyɨ ahɨnitahande. Ahɨnisamɨhɨ asoho nanɨmoyaatɨ ahɨnotanɨhɨ jahɨra nasataahura nɨnɨ naitando,’ undataase. ");
INSERT INTO agm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Otɨpɨpatɨho tɨhautɨpɨhoai saundatosatɨ kapɨhɨ komɨ otɨpɨpatɨhiya usaisɨ saundataase. ‘Kɨmo uta tɨhautɨpɨmomɨ 1,000 kinaamandɨ nepɨ otɨpɨpatɨho nawɨho 10,000 kinaahandisahoai nunyawɨse. ");
INSERT INTO agm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","O amɨ apaapɨmaasato, amɨ nisɨ otɨpɨpatɨho woai nɨnɨ wapa amɨ nawɨhoaisangi numwisanɨhapa biyatɨ itatamanatɨ isɨwatatɨ jatisɨhoai amɨ wapa taahɨpɨpa numwisanɨhɨ ko asakiyatɨ netɨ isɨwatɨtaise. Aindɨ amɨ nisɨ otɨpɨpatɨho woaisɨ wapa naasonyaahɨ nawɨhoaisangi numwisanɨhapa wɨndɨ biyatɨ itatamanatɨ minjasonaahɨ amɨ naasonyaahɨ nunyohonyaisangi komɨhetapɨ nɨnɨ nemaito. ");
INSERT INTO agm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Isɨ amɨ otɨpɨpato tɨhaanyosoaisaahɨ sisɨha kaanɨhɨ tɨhatoaatisɨhaapɨhɨ nepɨ yotɨwɨse. Yotisaihɨ sapɨhɨ konɨhɨ ngotɨ nehotatɨ komɨ mangɨrɨ gitɨpatoaatɨtando,’ undatɨ awaisɨho komɨ otɨpɨpatɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sawaho nasatɨ isɨhiyai netɨ tipɨtapaitandɨhuraapɨ nyahɨ komɨ otɨpɨpatɨhiyaanangi Jisaasiho sanyatataase. “Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ Awaisɨhonɨnimatɨtɨ isɨhiya nahatiya yapɨhɨ nahandaahiyai netɨ tipɨtapaitandɨ napɨto. Saindɨ napisanɨhura enjerɨhiya itɨpɨhiya nisɨ otɨpɨpatɨhiya yamɨhapataatɨhapɨhiya nahatiya nɨngisawɨ maawɨ napɨtaapo. Saindɨ napɨtɨ yamɨhapataatɨhapɨ nisɨ watɨpɨhandɨ saasanotindɨhandaatɨhɨ bindataatɨ isɨhiya nahatiyaisɨ netɨ tipɨtapaito. ");
INSERT INTO agm_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Aindɨ enjerɨhiya nisɨ yamɨhapataatɨhapɨ otɨpɨpatɨhiyai nandusaasisanɨhɨ yapɨpatɨ nahandaahapɨ isɨhiya nahatiyaisɨ wɨrapɨ numwaapɨ nepɨ detɨ nisɨhinɨ ahoaitaapo. Ahoaisaihɨ isɨhiya nahatiya nisɨ ndɨmaahomwaaŋɨ bitoaitaapo. Napɨwɨ ahoyainjaihɨ maasapɨhomɨ satɨho maasapɨho wɨrɨsandɨhaiwa netɨ tipɨtapaatɨ maasapɨho sipɨsipɨhandi wapɨhɨ nematɨ amɨ maasapɨho memetɨhɨri wapɨhemasɨpatamataindɨ isɨhiyai nɨnɨ netɨ tipɨtapaatɨ yɨyatɨwaapɨhɨ ahoaito. ");
INSERT INTO agm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Aindɨ isɨhiya nisɨhiya tɨtɨhɨ gaahiyai nisɨ ikwɨrɨ gaatɨhɨraihoaaŋematɨ amɨ isɨhiya maipɨhiya nisɨ tiworisai nisɨ ikwɨrɨ konaamohɨraihoaaŋematɨ tipɨtapaatɨ netɨ napɨpatɨ ahoaito. ");
INSERT INTO agm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Aindɨ Nɨnɨ Awaisɨhonɨnɨ Isɨhiyaisɨ Iwinjatohɨhonɨnɨ isɨhiya nisɨhiya nisɨ ikwɨrɨ gaatɨhɨraihoaaŋɨ bitohohiyɨhiyai saundɨto. ‘Sahɨ isɨhiyaatɨ nisɨ Apɨho biyatɨ maarɨho nasanyatɨ wɨsaiwatɨ biyatɨ jasosawɨhiyaatɨ nisenda napɨwɨse. Napɨwɨ wuwanɨ yamɨhapatɨ yapɨpatɨ kahapaamapɨpa ahaisuraapɨ Autaahaatɨho sangisɨ jainjaatɨ bindata nasamɨtandɨ ahɨsimbɨpa nepɨse. ");
INSERT INTO agm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kɨmandɨ sangisɨ nasamaatɨ nisɨhiyaatimatohɨtɨmandɨ apaapɨmaahe, amɨ nisɨ Apɨho sangisɨ biyatɨ jasonatɨ maarɨho nasanyatɨ wɨsaisɨhɨ amɨ sahɨ nɨngisɨ maarɨho naninyawɨ wɨnipɨ nanɨmaahohɨtɨhandape. Nanɨmaapɨ nɨngisɨ janɨmasɨhɨ nandapa naninyawɨ amɨ waapohopɨ nainyatɨ naahwɨtarɨhɨrɨ awanɨsihɨ sahɨ nɨngi waapoho naninyawɨ amɨ nɨngisɨ sahɨ wɨndɨ maanowɨhonɨnɨ yapɨpatɨ amɨ aunahɨpatɨ nɨngi wɨtaahapɨhonɨnɨ samɨ yapɨpatɨ aunahɨpata nasonɨhɨ sahɨ nɨngi maarɨho naninyawɨ wɨnipɨ samɨ aunahɨpata aŋɨpɨpɨhɨ nanɨmaapɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Aiwɨ amɨ nɨnɨ yutɨhɨrɨ apotɨhɨrɨ owehonɨnɨ nehɨ napwɨrɨndɨhapa niyotɨ namaasatɨtɨ amɨ taanahɨhonɨnɨ napɨtɨ jainjahonɨhɨ apotɨhɨrɨ sahɨ naninyawɨ amɨ nɨngi yaasihɨ timbiyonɨhɨ sahɨ nɨngi nɨtatamanɨwɨ sisɨha tɨhoaapɨnosawɨ amɨ aŋaaŋɨ napwɨtohɨwaiwaapɨhɨ isɨhiya nepɨ nanɨpuhauhɨ napwɨtɨtɨ bimonɨhɨ sahɨ napɨwɨ nɨsopɨ nanɨhoniwɨ pɨwandɨwɨhiyaate,’ undɨtɨ sura kiyaisɨ nɨnɨ saundɨto. ");
INSERT INTO agm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Saundisanɨhɨ amɨ isiya siya tɨtɨhɨ gaasiya kiyaamɨha nɨngi sandɨtaapo. ‘Awaisɨhonye saiwa kɨnyɨ katingɨwɨmaiwa maahɨwura nyahɨ gisɨ kahisonɨhɨse? Gisɨ jahɨmasɨhɨ maahɨwura nandapa nahɨnyaatɨ amɨ waapohopɨ nasihɨ nyahɨ waapoho gisɨ nahɨnyonɨhɨse? ");
INSERT INTO agm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Iyaatɨ kɨnyɨ nyamɨ yapɨpatɨ amɨ aunahɨpata napinɨhɨ nyahɨ nyamɨ aŋɨpɨpɨhɨ maahɨwura gisɨ nangɨmaahonɨhɨse? Iyaatɨ kɨnyɨ yutɨhɨrɨ amɨ apotɨhɨrɨ jahɨpɨpa yutɨha napwɨrɨnɨhapa niyopɨ somaahɨhoŋɨ naimbɨ nyainjahɨnɨhɨ nyahɨ gisɨ maahɨwura gisonaatɨ yutɨhɨrɨ apotɨhɨrɨ newaatɨ nangɨmaasawaatɨ nangɨsohonɨhɨse? ");
INSERT INTO agm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Iyaatɨ amɨ kɨnyɨ timbaimbɨ amɨ isɨhiya nepɨ aŋaaŋɨ napwɨtohɨwaiwaatɨhɨ nangɨpwɨhauhɨ biminɨhɨ nyahɨ maahɨwura sisɨha tɨhoaawaasosaatɨ nangipaawaatɨ pɨwaahɨtonɨhɨse?’ ndɨwɨ kiyaamɨha nɨngi sandɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Sandisaihɨ nɨnɨ kiyaamɨ Awaisɨhonɨnɨ kiyai nisɨha wihoaaŋɨ saundɨto. ‘Nɨnɨ sangisɨ akɨtɨnɨhɨ kasatataato. Isɨhiya nisapɨ gɨnunyaapɨ nɨngisɨ nanipinjohiyɨhiya nisɨ naapwɨrisa nɨhoaarɨsaamɨ wowaatɨ komɨ kaatamɨ ambɨpatɨ auta waatɨ namoaipahoai namoaipɨhaati iwɨtatamanɨwɨ sahɨ kawɨsohɨwiwa nɨngisɨ sahɨ kanisawaayopo,’ undɨto. ");
INSERT INTO agm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Saundɨtosatɨ amɨ isɨhiya nisɨ ikwɨrɨ konaamohɨraihoaaŋɨ netɨ ahoyohiyɨhiyai saundɨto. ‘Sahɨ nisɨ ndɨmaahomwaaŋɨ maanɨsopɨ kiyaatɨnɨhɨ nanɨmasi nawɨsapitɨwɨse. Autaahaatɨho sangisɨ mɨmaipiyatɨ jasonatɨ sangi maarɨho wɨndɨ namaasamihɨhiyaatisɨ ahawɨse. Nanɨmasi kiyaatɨnɨhɨ sisɨha kaanɨhɨ namaayotatɨ tɨhatoaatisɨha Bwaasɨrɨhɨrapunɨ komɨ otɨpɨpatɨhiya maipɨhiyaapɨ Autaahaatɨho netɨ aimɨ tɨmanisɨhaapɨhɨ sahɨ nuwɨse,’ undɨtɨ netɨ nandusaasɨto. ");
INSERT INTO agm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Saundɨtɨ netɨ nandusaasatɨ kiyaisɨ saundɨto. ‘Nɨngisɨ janɨmasɨhɨ jainjahonɨhɨ sahɨ nandapa wɨndɨ namaaninyawɨ amɨ waapohopɨ nainyatɨ nisɨ nahutarɨhɨrɨ awanɨsihɨ sahɨ waapoho nɨngi wɨndɨ namaaninyawɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aiwɨ nɨnɨ nehɨ nɨngi wonɨnɨhɨ samɨ yapɨpatɨ aunahɨpata nasonɨhɨ sahɨ wɨndɨ samɨ aŋɨpɨpɨhɨ napaitɨwɨ maarɨho wɨnipɨ namaanɨmaapɨ amɨ yutɨhɨrɨ apotɨhɨrɨ owehonɨnɨ nehɨ somaahɨhonɨnɨ napwɨrɨndatɨ yutɨha niyotɨ jainjahonɨhɨ sahɨ asɨpɨpa yutɨhɨrɨ apotɨhɨrɨ wapa nepɨ nanɨmaasapɨ namaanisopɨhiyaate. Aiwɨ amɨ nɨngi yaasihɨ timbaindɨ amɨ isɨhiya aŋaaŋɨ napwɨtohɨpɨpɨhɨ nepɨ nanɨpuhauhɨ napwɨtɨtɨ bimonɨhɨ sahɨ nɨngi wɨndɨ nɨtatamanɨwɨ nisowɨ pɨwandɨwɨ ninjaawɨ bɨmimaawɨhiyaate,’ undɨtɨ kiyai saundɨto. ");
INSERT INTO agm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Saundisanɨhɨ kiyaamɨha nɨngisɨ sandɨtaapo. ‘Awaisɨhonye kɨnyɨ jahɨmanatɨ waapohopɨ nahɨsatɨ nahwɨtarɨhɨrɨ awangisatɨ amɨ nehɨ gi woŋɨ nyahɨ maahɨsonaahoŋɨ nyamɨ yapɨpatɨ aunahɨpata nambɨ amɨ yutɨhɨrɨ apotɨhɨrɨ owehoŋɨ somahɨhoŋɨ nyainjapɨ amɨ timbaimbɨ ami isɨhiya nepɨ aŋaaŋɨ napwɨtohɨwaiwaapɨhɨ nangɨpwɨhauhɨ napwɨtɨpɨ biminɨhɨ nyahɨ gisɨ maahɨwura wɨndɨ maahɨsonaatɨ maahɨtatamanɨhonɨhɨse,’ ndɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Sandisaihɨ Nɨnɨ Awaisɨhonɨnɨ isɨhiyaisɨ netɨ tipɨtapaatɨ usondandɨhonɨnɨ kiyai saundɨto. ‘Isɨhiya nisapɨ gɨnunyaapɨ amɨ nɨngi nanipinjohiyɨhiya ambɨpatɨ awaipatɨ owehiyai sahɨ wɨndɨ namumwaapɨ amɨ maawɨtatamanɨwɨ amɨ wapa namunyohɨtɨndɨ nɨngi sahɨ kanisawaayopo,’ undɨtɨ kiyai nɨnɨ wɨndɨ namumwaito. ");
INSERT INTO agm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Saundɨtɨ kiyai netɨ sisɨha kaanɨhɨ namaayotatɨ tɨhatoaatisɨhaapɨhɨ nandusaasisanɨhɨ kiya sapɨhɨ yaawɨhandɨ kiyaanɨhɨ nepɨ nutaapo. Aisaihɨ amɨ nisɨ isɨhiya gaahiya nɨngisawɨ asɨtimatɨtaatɨwɨhandɨ nepɨ kiyaanɨhɨ jinjapɨhɨ jinjapɨhɨ bimaamɨ nutaapo,” tatɨ Jisaasiho nyahɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Satatɨ saiwa katatɨ owematosatɨ nyahɨ komɨ otɨpɨpatɨhiyaanangi Jisaasiho sanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Sahɨ aimɨ mmonawaayopo. Asisɨha yatairɨ saniyonɨhɨ Isɨraherɨhiyaanamɨ asisɨha awaisɨha kimbapɨho jɨhura Autaahaatɨho nyapundatɨ Isipɨhiyaisɨ tiwataatɨ nyamɨ asoya asisaisɨ tɨmaawatɨ nusatipasɨtɨhandapɨ gwɨnyaitɨhaahura noaipaitaise. Noaipahonɨhɨ sura kura nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨhi nɨwahonisɨ isɨhiya nanɨmaasi nuwɨ isɨhiya mambɨ awaisawɨhiyaamɨ ikwɨraatɨhɨ nanumwɨtaapo kiya nɨngi ipɨ tɨtɨhɨ atawɨhatetɨ nipɨmandaapɨ sohonɨhi nɨwɨtaatɨwo,” nyatatɨ nyahɨ komɨ otɨpɨpatɨhiyaanangi Jisaasiho kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aihɨ sura Jisaasiho nyangisɨ taatɨ sanyatihɨ amɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai nunyohiyɨhiyaamɨ mɨtɨhiyaunɨ Judaahiyaanamɨ gwɨnyaahiya jɨhiya usaunɨ kiyaamɨ jɨhɨ mɨtɨho awaisɨho komɨ ambɨpatɨ Kaiyapaasihomɨ aŋɨpɨpɨhɨ ahoyanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ahoyanɨwɨ Jisaasiho sohoai tiwɨtaatɨwɨ noaatɨwɨ isɨpɨ numwaitaatɨwɨhɨra daihɨraapɨ daapɨ nepaatɨnɨwɨ pɨwɨha kanɨwɨ wɨsasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Saiwɨ pɨwɨha kanɨwɨ wɨsasawaawɨ namapɨ sawana sanawaatopo. “Owe. Nyahɨ sandɨ kɨma asisɨma awaisɨma kimbapɨmo Pasopaamandetɨ kamaitɨhaawo. Amɨ isɨhiya ahoyanawaahuraasɨ kiyaamɨhatɨhapɨ Jisaasiho gaahoso tɨwɨ gɨwunyaapɨhiya nepɨ nyangi nyapɨ amɨ nepɨ sawana tunnɨwɨ aunahɨpatɨ nepɨ nopɨsasɨtaawo,” nɨwɨ sɨhɨ wuraapɨ namɨhaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jɨhɨ awaisɨhoematatɨ Jerusaremɨhanda sangɨ nandaasura Jisaasiho Betanihandaahapɨ naihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨhɨ maawɨ nohaayo. Nowaatɨ Betanihanda akɨpwepɨho Saimonɨhomɨ aŋɨpɨpɨhɨ noaipawa bindɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Bindɨhaawɨ Jisaasiho taatɨ nandapa nainjɨhɨ apopaatɨ waatɨ atɨpatɨ werɨhandɨ nga biyatɨ waatɨ waamainjotɨhandɨ nawɨho apɨpaahɨ aungwohandɨ nunyatɨ nehatɨ katamɨ wipatɨ nehɨ usɨpɨpaapɨhatɨ katopɨ werɨhandɨ windhatɨ nesi Jisaasihoenda nasataise. Nasatɨ saatɨ apopa atɨpatɨ werɨhandɨ komɨ mɨtɨhaatɨhɨ nɨwuhaatɨ iwinjaataise. ");
INSERT INTO agm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kaatɨ Jisaasihoai sawihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ sandɨ mmonɨhaawɨ kandapɨ apɨpaahɨ itɨhɨtaatɨ yawanaanɨnɨ sanɨhaato. “Ese kɨmaatɨ apomaatɨ atɨpatɨ werɨhandɨ apɨpaahɨ gaahatɨ napindapɨ nopɨsasatɨ tɨmase? ");
INSERT INTO agm_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kɨmatɨ atɨpatɨ werɨhandɨ biyatɨ nga waamainjotɨhatɨ nawɨho awaisɨho katapɨ nga nepɨ isɨhiya ikɨpɨpa owehiyai numwɨtɨhatiso,” nnaatɨ yawanaanɨnɨ kanɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nyahɨ sanɨhonɨhɨ Jisaasiho mmonataatɨ nyangisɨ sanyatataase. “Sahɨ kɨmaatɨ apomaati nɨngi atɨpatɨ werɨhandɨ waamainjotɨhandɨ nuhaatɨ ninjaasɨtɨmandapɨ pohɨrundɨwɨ namaawisapupwɨse. Sandɨ nɨngi apɨpaahɨ gaahandɨ kanisatɨ nanɨsihɨ nɨnɨ maarɨho witɨtɨ netaayo. ");
INSERT INTO agm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Isɨhiya ikɨpɨpa owehiyaahɨ sangisawɨ kɨmbɨhɨ kɨmaapɨ jinjapɨhɨ bɨsotisaihɨ sahɨ kiyaisɨ gaahaiwa kawɨsawaatɨtaapo. Amɨ sahɨ nɨngi gaahaiwa kanitaatɨwɨ nɨnɨ sangisatɨ nisɨ ambɨpatɨ ndɨmaahomwaaŋɨ isɨtɨ wɨndɨ nasisoaarɨ konɨnɨhɨ bɨmimɨto. ");
INSERT INTO agm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kɨmaatɨ apomaatɨ atɨpatɨ werɨhandɨ apɨpaahɨ awaindɨhandɨ waamainjotɨhandɨ wipatɨ nehɨ naasuraahɨ tuwatapɨ noaapɨ jaatɨwɨ namaitaatɨwɨhatɨ nisɨ mɨtɨhaatɨhɨ nanuhaatɨ ninjaasɨtɨmandɨ nyahɨ Judaahiyaanɨhɨ isɨhiya napwauhɨhiyai atɨpatɨ werɨhandɨ waamainjotɨhatɨ nuhaawaatɨ jaawa yamwaahohɨpatamatiyatɨ nisɨ ambɨpatɨ netɨ nɨmanataise nɨnɨ napotɨ yamwaatɨtandɨhuraapo. ");
INSERT INTO agm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nɨnɨ sangisɨ akɨtɨnɨhɨ kasatataato, sahɨ baiwɨ gwɨnyaapɨse. Autaahaatɨhomɨ pɨwɨha gaaha wanɨha isɨhiyai japɨhɨ numwaitandɨ nɨnɨ napwohɨtɨhandapɨha isɨhiya nesi yapɨpatɨ nahanda isɨhiya usaisɨ ausaapɨ kaundisaihɨhapɨhɨ apomaatɨ kɨmaatɨ nɨngi atɨpatɨ werɨhandɨ nuhaatɨ ninjaasɨtɨmandɨ nesi kanɨwɨ Autaahaatɨhomɨ pɨwɨhaatɨhɨ atiwɨ saatɨ Jisaasihoai gaahandɨ kawɨsataise tɨwɨ gɨwunyaitaapo,” nyatatɨ nyahɨ komɨ otɨpɨpatɨhiyaanangi kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Aihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ 12 kiyaatɨ ikwɨ maindɨmwɨtihɨ auhɨramɨ yahurɨtahiyaanamɨ wo komɨ ambɨpatɨ Judaasiho aunahɨpatɨ Kariyotɨhandaahapɨho pɨrisihiya isɨhiya isɨhiyaapɨ nandapa kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai nunyohiyɨhiyaamɨ mɨtɨhiyai Jisaasihopɨ nusepaitandɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nusepaitandɨ notɨ kiyaisɨ ko saundataase. “Nɨnɨ Jisaasihoai sangi nasepaatɨ samɨ ikwɨraatɨhɨ ahɨsisanaahɨ sahɨ nɨngi nawɨho napitaiwɨ nanɨmɨtaapo?” undataase. Saundihɨ kiya atiwosawɨ nawɨho taanauhɨho nepɨ awɨtɨwɨ mmonɨwɨ 30 kaiwɨho koai nunyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nunyauhɨ netɨ isɨwatata daihɨra wɨra Jisaasiho kɨmore undatɨ tiworisaisɨ netɨ nunjɨtandɨhɨraapɨ sura nawo nesuraapɨ Judaasiho daatɨ mmonɨmɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Aihɨ asisɨha wiwa kɨnaungwɨha nahatewetɨ nyahɨ Judaahiyaanɨnɨ kaiwai newaatɨ awaiwaiwemawaatɨ bɨretɨhandɨ nipindɨhandɨ yisɨhandɨ owehandɨ tɨhawa nanɨhohɨwaiwa aimɨ detɨndaise. Iyataatɨ saiwa asisɨha awaiwaiwa Pasopaahandamɨhaiwaare. Iyataatɨ jɨhura Isipɨhanda nyamɨ asoya asisa sipɨsipɨhandɨ tipɨ kandamɨ jɨtɨpatɨ kiyaamɨ aŋaaŋɨ jaahauhɨ Autaahaatɨho katɨ mmonataatɨ kiyaisɨ nusatipatɨ isɨhiya Isipɨhiya sɨyɨhiyaisɨ tiwamataise. Aihɨ sandapɨ nyahɨ Judaahiyaanɨnɨ asisɨha saiwaamɨ jɨhetɨ gwɨnyaawaatɨ sipɨsipɨhandɨ tiwaatɨ tɨhawaatɨ nanahaayo. Saitɨhaahuraatihɨ asisɨha jɨha aimɨ detɨtihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ Jisaasihoai saundaatɨ nunjenɨhaayo. “Nandapa asisɨ kɨma awaisɨmetɨ kinyapɨ maahɨwapɨhɨ newaatɨ tɨngɨmaŋɨtɨhaawe?” undaatɨ nunjenɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Saundaatɨ nunjenɨhonɨhɨ Jisaasiho nyangi sanyatataase. “Aunahɨpata utaaho wo setahoenda naiwɨse satohɨhoenda naiwɨ koai sahɨ saundɨwɨse. ‘Kataunjisɨho satise, ‘nɨnɨ otɨpɨpatɨ Autaahaatɨho naninyatɨ natanoaasihɨ nesi napɨtɨ kiyohɨpatɨ kaindɨ owemaitandɨhura aimɨ detɨndaise. Iyatɨ detɨsɨ nɨnɨ nisɨ otɨpɨpatɨ mmowɨ nepɨ kaiwɨ nanipinjohiyɨhiyaisatɨ Judaahiyaanamɨ asisɨha awaisɨmetɨ maasapɨho sipɨsipɨhandɨ sɨpɨpɨhoho sapɨhomɨ gwɨtɨtɨhoaisatɨ nandapa bɨretɨhandɨ nipindɨhandɨ yisɨhandɨ owehandɨ kinyɨ aŋɨpɨpɨhɨ nandaano tihe,’ undɨwɨse,’ nyatataase.” ");
INSERT INTO agm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sanyatihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ Jisaasiho kanyatirɨhɨrɨ kɨretɨ japepihɨraatɨ nandapa newaatɨ tɨhaatɨ tɨmanɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tɨhawaatɨ tɨmanɨhonɨhɨ ipɨho notɨ asɨhatahurandaise. Asɨhataahuraatihɨ Jisaasihotihɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ 12 kiyaatɨ ikwɨ maindɨmwɨtihɨ auhɨramɨ yahurɨtahiyaanɨnɨ bindɨhaawɨ nandapa nanahaayo. ");
INSERT INTO agm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nandapa taawaatɨ nanahaawɨ Jisaasiho sandaase, “Nɨnɨ akɨtɨnɨhɨ sangi kasatɨtaanɨ atiwɨse, samɨ woŋɨ nɨngi nipɨ nɨwɨtaatɨwɨhiyai nusepaapɨ kɨmore undɨwɨ nɨngi nepɨ nunjɨtaapo,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sanyatihɨ nyahɨ atisɨhaawɨ nyamɨ maarɨho omaŋɨtɨtɨhɨ apɨpaahɨ yaasatɨ nyatatɨ naaŋanyihɨ nɨnaasonɨnɨhɨ napɨpananaatɨ Jisaasihoai saundaatɨ nunjenɨhaayo. “Awaisɨhoŋe, akɨtɨnɨhɨ nɨno? Kɨnyɨ nisapɨno?” undaatɨ Jisaasihoai nunjenɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Saundaatɨ nunjenɨhonɨhɨ Jisaasiho komɨha nyangi sanyatataase. “Samɨ wo nandapa bɨretɨhandɨ nisɨ nyaihandɨ pɨretɨho naasɨkoaatɨhɨ wiwatɨ tɨmandaatɨ nainjɨho nɨngi nipɨ nɨwɨtaatɨwɨhiyai kɨmore undatɨ netɨ anusaitaise. ");
INSERT INTO agm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Anusaahonɨhɨ nisɨ tiworisa sohonɨngi nɨwisaihɨ Autaahaatɨhomɨ pɨwɨha nisapɨ ko siyatɨ napwɨtaise tatɨ jɨpatɨpindisɨha japepihɨrɨtɨ kɨretɨ nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ napwɨto. Nɨnɨ saindɨ napwisanɨhandɨ kandɨ utaaso nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨngi isɨhiya tiworisaamɨ ikwɨraatɨhɨ netɨ anusaaso naaŋatɨ yaawɨhandɨ apɨpaahɨ awaindɨhandɨ naitaise. Naitaisɨ ese koai sanaatɨ namaamotaataahɨ sandɨ ko wɨndɨ namaitaihe,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sanyatihɨ Judaasiho Jisaasihoai netɨ nusepaatɨ kɨmore undɨtandɨho Jisaasihoai saundatɨ nunjenataise. “Katɨpunjingɨhonye, kɨnyɨ akɨtɨnɨhɨ nisapɨno e owetiso?” undatɨ nunjenataise. Saundihɨ Jisaasiho Judaasihoai komɨha saundataase, “Ye, kɨwahoŋɨ sa ka aimɨ katapaase,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Aihɨ nyahɨ nandapa taawaatɨ nanahaawɨ Jisaasiho nandapa bɨretɨhandɨ netɨ isɨwatata Autaahaatɨhoai gaahoŋe gaare undatɨ gaapundatɨ naumbotɨ nyahɨ komɨ otɨpɨpatɨhiyaanangi nanyinyataise. Nanyinyataatɨ sanyatataase, “Kɨmandɨ bɨretɨmandɨ nisɨ ambɨpatapɨ namɨhanahandɨsɨ sahɨ nepɨ nanɨwɨse,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Sanyatatosatɨ amɨ waapoho wainɨhandɨ wipatɨ kaapɨhopɨ netɨ isɨwatataatɨ Autaahaatɨhoai kɨnyɨ gaahoŋe gaare undatɨ nyangi nanyinyataatɨ sanyatataase: “Kɨmo waapomo wainɨmandɨ nisɨ jɨtɨpatapɨ namɨhanahande. Isɨhiya nɨngi nɨwisaihɨ nisɨ jɨtɨpatɨ nuhaatonɨhɨ jɨhura Autaahaatɨho pɨwɨha katatɨ tɨmanatɨ wɨsasirɨhɨretɨ nisɨ jɨtɨpatɨ nuhainjɨpatɨ mmonataatɨ isɨhiya nisapɨ gɨnunyaahohiyɨhiyaamɨ maipɨhaiwa nemwahonɨhɨ kiya noaipapɨ Autaahaatɨho sawahoaisawunɨ isɨhiya sawanaunɨ naasiyaimatɨwɨ bimɨtaatɨwɨhate. Isɨ sahɨ nahatiyaatɨ nepɨ nanɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nɨnɨ sangi akɨtɨnɨhɨ kasatataato, kɨmo waapoho waindɨhandɨ nɨnɨ apɨpaahɨ wɨndɨ namandɨmatatɨ sɨhɨ nisɨ Apɨho Autaahaatɨho nisɨhetapɨ isɨhiya nisɨhiyai iwinjatonɨhura waapoho wainɨhandɨ asɨtɨhandɨ japɨhɨ sangisatɨ maasɨ nando,” nyatatɨ kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jisaasiho nyangisɨ sanyatatɨ owemasɨhɨ sapɨhɨ aŋɨpɨpɨhɨ bindɨha nandapa nanɨhohɨpɨpɨhɨ aunɨhɨhɨrɨ wɨrɨ katawaamapɨ Jerusaremɨhanda namasi noaatɨpawaatɨ wihɨnɨ sisɨho Oripɨhoaasɨnapɨ nasaamanɨhaayo. ");
INSERT INTO agm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Aihɨ daihɨra taawaatɨ noaatɨpawa niyahaawɨ nyangi Jisaasiho sanyatataase. “Kɨmura wanɨ apatindɨmatɨhɨ sahɨ nahatiyaatɨ kiyaatɨnɨhɨ nɨngi nanɨmasi jɨhura Autaahaatɨhomɨ pɨwɨha nisapɨ katatɨ jɨpatɨpindirɨhɨrɨ kɨretɨ tɨtɨhɨ yanɨhɨmaitaapo. Yanɨhɨmapɨ nisapɨ gɨnunyaahohɨtɨhandɨ bwaitaise. Iyataatɨ Autaahaatɨho komɨ pɨwɨha jɨpatɨpindisɨhaatɨhapɨ nisapɨ namɨhanatɨ satise: ‘Nɨnɨ Autaahaatɨhonɨnɨ utaaho maasapɨho sipɨsipɨhandɨ jaatɨ bitosɨho satɨhoai sohoai tiwisanɨhɨ komɨ maasapɨho sipɨsipɨhandɨ usonamapɨ numwasi kɨhɨra nandatɨ torɨwatamaitaise,’ tatɨ jɨpatɨpindɨse. ");
INSERT INTO agm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Satatɨ jɨpatɨpindisɨ kɨretɨ nɨnɨ napomatatɨhandɨ kandɨ Autaahaatɨho jahɨra nɨngisɨ ahonimatɨ nanɨmaahonɨhɨ sangisɨ jahɨra nasamaatɨ netɨ ahosindɨ jainjaitandɨ samɨ jɨhɨ Garirihandaahapɨ taatɨ nɨnɨ naito,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Sanyatihɨ atisahaawɨ Pitaaho Jisaasihoai saundataase. “Amɨ nisaahoyɨmiya gi nangɨmapɨ gɨsesi yanɨhɨmasaihɨsangi nɨnɨ gi wɨndɨ nangɨmasi yamaanɨhɨmaito,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Saundihɨ amɨ Jisaasiho komɨha Pitaahoai saundataase. “Kɨnyɨ kɨmandɨ baimbɨ atimbɨ gwɨnyaape. Kɨmura apatindɨmatɨhɨ bousetetɨ isɨhiya gi sahɨtɨwɨ, ‘Kɨnyɨ Jisaasihomɨ naisohoŋe,’ hɨtɨwɨ nahɨsesaihɨ kɨnyɨ yaimbɨ otɨpwɨsɨpaatɨ sangɨ gaatonɨhura kɨnyɨ isɨhiya nahɨsehohiyɨhiyai nisapɨ saundɨtaise. ‘Owe. Nɨnɨ Jisaasiho soai wɨndɨ mausotɨhonɨne,’ undɨpɨ mairɨ maara nisɨ ambɨpatɨ kɨnyɨ nepɨ nanoaasɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Saundihɨ Pitaaho Jisaasihoai komɨha saundataase. “Amɨ tiworisa nɨngi gisawɨ maisɨhoaanyangi nyawɨtaatɨwɨsangi nɨnɨ kiyai apɨpaahɨ wɨndɨ kinyapɨ samundɨto, ‘Nɨnɨ Jisaasihoai wɨndɨ apɨpaahɨ mausotɨhonɨne,’ mundɨto. Owetɨtaise,” undataase. Jisaasihoai Pitaaho saundihɨ amɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ usaanɨnɨ naasaipitɨ katɨ Pitaahoai nuwipinjaatɨ Jisaasihoai kaundɨhaato. ");
INSERT INTO agm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Aihɨ Jisaasiho nyahɨ komɨ otɨpɨpatɨhiyaanangi nanyamaasi sisɨhoaasɨnɨ nasaamanatɨ naihɨ niyaatɨ wapɨhɨ ambɨpatɨ Getɨsemanihanda noaipɨhaayo. Siyaatɨ sapɨhɨ niyawaatɨ noaipawaatɨ nyahɨ usaanangi Jisaasiho sanyatataase. “Sahɨ kɨmbɨhɨ bimaawɨse nɨnɨ onɨhɨ mɨhapɨhɨ naindɨ gaapundɨtaano,” nyatataase. ");
INSERT INTO agm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Sanyatamapɨ Pitaahoaisunɨ Sepetihomɨ mwaahurɨ Jemɨsiyɨ Joniyai numwaasi Jisaasiho gaapundɨtandɨ onehɨ mɨhapɨhɨ niyataise. Komɨ maarɨho omaŋɨtɨtɨhɨ ambɨpatɨ osamatɨ apɨpaahɨ awaindɨhandɨ tiwatɨ iwɨtaatisatɨ naaŋawisatɨ yaawataise. ");
INSERT INTO agm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sawimainjɨhɨ mmotɨnataatɨ namatɨ Jisaasiho komɨ otɨpɨpatɨhingwaasɨ Pitaaho Jemɨsiho Jonɨhoai saundataase. “Maingwaase, utaahonɨnɨ kɨmonɨnɨ nahatonɨnɨ nisɨ maarɨho apɨpaahɨ awaindɨhandɨ naaŋanisatɨ yaasatɨ nisɨ omaŋɨtɨtɨhɨ ambɨpatɨ gaanɨmatɨ netɨ mɨmaipɨnimatatɨ nanopɨsasɨnatɨ tiwatɨ nanosatɨ nɨtaatihiyo. Sanimainjɨhiyonɨ saingwaasaatɨ kɨmbɨhɨ namopɨ jaawɨ bitotawa nɨngi andɨtɨnipɨ gaapundɨwɨse. Nɨnɨ onɨhɨ masɨwonjaapɨhɨ nundɨ gaapundɨtaano,” undatɨ kingwaasi kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kingwaasi saundamapɨ Jisaasiho onɨhɨ kaanɨhɨ masɨwonjɨ notɨ komɨ ndɨmaahomwaaŋɨ yapɨpatetɨmatɨ tɨmahiyatɨ gaapundataise. Gaapundataatɨ komɨ Sapɨho Autaahaatɨhopɨ satatɨ gaapundataase. “Ese nisɨ Apore kɨmaiwa naaŋatɨ yaasamaiwa netɨ ipɨ tɨtɨhɨ atawɨhatetɨ nɨpɨ nipɨmandaasaihɨ nɨnɨ napwɨtandiyohɨtɨmandɨ nɨnɨ wɨndɨ namwaapwɨtandɨ kɨnyɨ gaaso tɨpɨ nepɨnɨmaitaapaahɨ kaiwa nepɨnɨmape. Saimbɨ nepɨnɨmaitaapɨhandɨ kandɨ nɨnɨ maaritɨtɨ nisɨ gwɨnyaatɨ katohɨrɨhɨretɨ kɨnyɨ wɨndɨ japepihɨrɨpɨ kamaime. Owetane. Nehɨ kɨnyɨ kɨwahonyɨ gwɨnyaapɨ maaritingɨrɨhɨretɨ japepihɨrɨpɨ kaime,” undatɨ Autaahaatɨhoai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Saundatɨ Autaahaatɨho Sapɨhoai Jisaasiho pɨwaundatɨ gaapundatɨ gousemapɨ komɨ otɨpɨpatɨhingwaasenda jahɨra nasataise. Nasatɨ usonataatɨ kingwaasɨhɨ apɨpaahɨ ahominɨwɨ nanomawaayopo. Nanomɨhauhɨ Jisaasiho Pitaahoai saundataase, “Pitaahoŋe, saingwaasaatɨ nɨngi andɨtɨnipɨ jatawaawɨ apɨpaahɨ masɨhonjɨsangi gaapɨmundɨwɨ napindapɨ nanomahopo? ");
INSERT INTO agm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sangi nasɨsendandɨhaiwa noaipatɨ nasɨsehonɨhɨ tɨmɨhaitaawɨ sahɨ baiwɨ jatɨnɨwɨ bitotawa andɨtitɨwɨ gaapundɨwɨse. Samɨ maarɨho nga biyatɨ gaapundatɨ jatɨtandɨ maaritataahandɨ kandɨ samɨ ambɨpatɨ wɨndɨ andɨtɨminje,” undatɨ Jisaasiho Pitaaho Jemɨsiho Jonɨmohingwaasi kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kingwaasi saundamapɨ Jisaasiho jahɨra gaapundɨtandɨ notaise. Notɨ Autaahaatɨhoai saundatɨ gaapundataase. “Ese nisɨ Apore, kɨmaiwa naaŋatɨ yaasamaiwa nɨnɨ naitandɨ apɨpaahɨ pondataahandɨ kandɨ nisɨ gwɨnyaahohɨrɨhɨretɨ wɨndɨ namutaano. Amɨ nɨnɨ sandɨ kaitandɨhɨra daihɨra nehɨ kɨrahɨtanaaho. Nehɨ kɨnyɨ kɨwahoŋɨ maaritɨpɨ gwɨnyaahingɨrɨhɨretɨ japepihɨrɨtɨ kaitaano daihɨra kɨmɨ kɨraaso,” undatɨ gaapundataase. ");
INSERT INTO agm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Autaahaatɨhoai saundatɨ gaapundatɨ gousemapɨ jahɨra komɨ otɨpɨpatɨhingwaasenda Jisaasiho nasataise. Nasatɨ usonata kingwaasɨ ndɨha norɨhaapɨ jatawa andɨtitɨwɨ wɨndɨ gaapɨmundɨwɨ kingwaasɨhɨ ndɨha naawihɨ tingaitɨwotawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Saiwɨ komɨ otɨpɨpatɨhingwaasɨ wɨndɨ jatawa gaapɨmundɨwɨ tingaitɨwosauhɨ namatɨ Jisaasiho amɨ jahɨra niyatɨ ipotɨhandɨ gaapundataase. Gaapundataatɨ jɨhɨ Autaahaatɨhoai pɨwaundatɨ gaapundatɨ gousesɨrɨhɨrɨ kɨretɨ japepihɨratɨ gaapundatɨ Autaahaatɨhoai gousetaise. ");
INSERT INTO agm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Niyatɨ ipotɨhandɨ gaapundatɨ owemamapɨ komɨ otɨpɨpatɨhingwaasenda jahɨra nasatɨ kiya gwɨnyaitaatɨwɨhandɨ kiyai saundataase. “Sahɨ akɨtɨnɨhɨ gaahatɨ kaiwɨ ikɨnɨwɨ itɨpɨho nepɨ nanopotawaayopo. Gaasɨ saingwaasaatɨ nanopotɨwɨsono. Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨhi isɨhiya nepɨ wɨnisasawɨ isɨhiya nyamɨ dawaataatapɨhiyai nanumwisaihɨ kiya nepɨ nɨpɨ ipɨ tɨtɨhɨ atawɨhatetɨ nipɨmandaasaihɨ napwɨtandɨha asisɨha wanɨ kɨma ka noaipataisɨ saingwaasaatɨ mmonawaayowo e owetiso? ");
INSERT INTO agm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Saingwaasaatɨ tarɨwaiwɨ ketɨ nepapɨse nutɨhaawo. Nepapɨ jasawewɨse utaaho nɨngi netɨ nisɨ tiworisaamɨ ikwɨraatɨhɨ anusaatɨ nanumwɨtandɨho aimɨ kɨmbɨhɨ kɨmo nasatɨ noaipataisɨ koaisaatɨ nutandɨhaawɨ nutɨhaawo,” undatɨ kingwaasɨ komɨ otɨpɨpatɨhingwaasi Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisaasiho taatɨ konɨhɨ kingwaasi pɨwaundɨmɨ naihɨ Judaasiho nyahɨ Jisaasihomɨ otɨpɨpatɨ mmonaatɨ newaatɨ kiyaatɨ nuwipinjohiyɨhiyaanamɨ wo isɨhiya Jisaasihoai nepɨ isɨpɨ wɨraitaatɨwɨhiyai numwaasi nasatɨ noaipataise. Judaasihoaisawɨ isɨhiya apɨpaahɨ taahiyɨhiya wɨrɨsandɨhandi pɨrisihiya isɨhiya isɨhiyaapɨ nandapa maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai waamaitumapɨ nunyohiyɨhiyaamɨ mɨtɨhiyaunɨ Judaahiyaanamɨ gwɨnyaahiya jɨhiya awaisawɨhiyaunɨ natɨwusaasauhɨ pwɨsɨpatɨ namatanaatɨ kosasaihɨrɨ amɨ pwɨsɨpatɨ turaipatɨ pɨhɨtɨwɨ isɨsi nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Iyataatɨ jɨhɨ tɨmanatɨ Judaasiho Jisaasihoai tiworisaamɨ ikwɨraatɨhɨ netɨ numwisɨho tiworisa wɨrɨsandɨhandi saundataase. “Utaaho nɨnɨ naindɨ koai naahipaumwatɨ gerundisanɨhɨ ninjahoto so kosɨ sahɨ nepɨ isɨpɨ wɨrapɨse,” undatɨ kiyai numwaasi nasataise. ");
INSERT INTO agm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iyatɨ Judaasiho nasatɨ noaipatɨ tɨtɨhɨ konɨhɨ Jisaasihoenda niyatɨ saundataase. “Katɨpunjingɨhonye apatɨhe. Gaahuraasɨ kinyɨ maarɨho wɨngitatɨ napaisaatɨtane,” undatɨ naisɨhiya kainɨhohɨrɨhɨretɨ kiyatɨ naahipaumwatɨ gerundataise. ");
INSERT INTO agm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Siyatɨ gerundihɨ Jisaasiho Judaasihoai saundataase. “Kwɨhoe, kaitaapɨ napingɨpɨpa tarɨwaimbɨ ketɨ kaime,” undataase. Aihɨ isɨhiya tiworisa wɨrɨsandɨhandɨ nasohiyɨhiya Jisaasihoai nepɨ anɨtiwɨ isɨpɨ wɨrawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Saiwɨ nepɨ wɨrahauhɨ ketɨ kɨnapaahoya nyahɨ Jisaasihoai nuwipinjohiyɨhiyaanamɨ Jisaasihomɨhinɨ detɨ bitohohiyɨhiyaamɨ wo komɨ namatanaatɨ kosasaihɨrɨ napatesi pɨrisihiya isɨhiya isɨhiyaapɨ nandapa maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai waamaitumapɨ dɨpumanɨwɨ nunyohiyɨhiyaamɨ mɨtɨho awaisɨhomɨ otɨpɨpatɨhomɨ atihɨrɨ tisatamasɨhɨ mɨhaapɨ yiyandɨhɨ timahiyataise. ");
INSERT INTO agm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aihɨ nyamɨ koai Jisaasiho saundataase, “Kɨnyɨ pwɨsɨpatɨ kosasaihɨrɨ namatanaatɨ kanaatamɨ anɨhandopɨ jahopɨ wipe. Amɨ usa maatɨmaatiwɨ pwɨsɨpatɨ nepɨ timbiyohiyɨhiya amɨ isɨhiya pwɨsɨpatɨ kataahɨ nepɨ tiwisaihɨ napwɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kɨnyɨ gwɨnyaapaino e wɨndɨ gɨmunyaahɨno? Nɨnɨ nisɨ Apɨhoai nunjesanɨhɨ komɨ enjerɨhiya otɨpɨpatɨhiya yamɨhapataatɨhapɨhiyai tiwaatɨhɨrɨ kɨhɨrɨ asakiyatɨ natausaasonɨhɨ napɨwɨ tinjaapɨnaitaapo. ");
INSERT INTO agm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","O amɨ saiwɨ enjerɨhiya yamɨhapataatɨhapɨhiya nɨngi nga tinjaapɨnesaihaahɨ Autaahaatɨhomɨ kɨmaiwa nɨngi wanɨ nanoaipasɨwɨmaiwaapɨ siyatɨ sɨrɨ sɨretɨ noaipaitaise tatɨ jɨhɨ jɨpatɨpindisɨhaamɨ akɨwaiwa napitiyatɨ noaipaitaise?” undatɨ koai nyahɨ nahatiyaanɨ gwɨnyaitɨhaaha kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Koai saundatosatɨ isɨ tiworisa wɨrɨsandɨhandi Jisaasiho saundataase. “Isɨhiyaato sahɨ wɨrɨsandiwɨ pwɨsɨpatɨ kosasaihɨrɨ namatanaatɨ turaipatɨ isɨpɨ gwɨsitɨwɨ tɨpwinji utaaho wo maatɨmaatisatɨ timbiyahoai nepɨ tipɨ wɨraitaatɨwɨ napɨwɨhiyaato? Nɨnɨ ipɨho nahatewetɨ Autaahaatɨhomɨ aŋɨ Awaindɨhandaatɨhɨ isɨhiyai kandunjatoaasohurura sahɨ nɨngi nepɨ nipɨ wɨmaanirapɨhiyaatiso. ");
INSERT INTO agm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sahɨ nɨngi wɨndɨ samaaniwɨhiyaatɨtawaahandɨ kandɨ kɨmaiwa sahɨ nɨngi nepɨ wɨnirapɨ kiyohɨwɨmaiwa jɨhura isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaamɨ pɨwɨha jɨpatɨpiyohɨwaiwaamɨ akɨpɨpa tɨtɨhɨ noaipaitandɨ sahɨ kiyawaayopo,” undatɨ Jisaasiho isɨhiya komɨ tiworisai kaundataase. Aihɨ Jisaasihoai saiwɨ isɨhiya komɨ tiworisa nepɨ isɨpɨ wɨrahauhɨ nyahɨ Jisaasihoai numwasi nyahɨ 11 kiyaatɨ ikwɨmaindɨmwɨtihɨ auhɨramɨ naasohɨtahiyaanɨnɨ yanɨhɨmahaayo. ");
INSERT INTO agm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Aihɨ isɨhiya Jisaasihoai isɨpɨ nepɨ wɨrahohiyɨhiya koai numwaasi pɨrisihiya isɨhiya isɨhiyaapɨ nandapa maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai waamaindumapɨ dɨpumanɨwɨ nunyohiyɨhiyaamɨ mɨtɨho awaisɨho Kaiyapaasihomɨ aŋɨpɨpɨhɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ amɨ gwɨnyaahiya jɨhiya mɨtɨhiyaunɨ ahoyanɨwɨ bimauhɨhapɨhɨ nuwɨ noaipawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Saiwɨ Jisaasihoai wɨrapɨ numwaasi niyauhɨ Pitaaho Jisaasihoai nuwipinjai ipotɨ bɨpi notɨ Kaiyapaasihomɨ masaataatamɨ onepataapɨhɨ noaipataise. Noaipatɨ Jisaasihoai napitɨwɨsopo tatɨ iwinjaitandɨ nandaatɨ mɨhatɨhɨ Kaiyapaasihomɨ aŋaaŋɨ iwinjatohiyɨhiyaisatɨ maasɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aihɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai waamaindumapɨ dɨpumanɨwɨ nunyohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ usa gwɨnyaahiya jɨhiyaunɨ amɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ nahatiya pɨwɨha jaiwɨtɨhaiwa Jisaasihopɨ isɨhiya ko siyahoe siyahoe tisaihɨ sohoai tiwɨtaatɨwɨhandapɨ mmonɨwɨ pɨhɨtɨwɨ daawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Saiwɨ daapɨ isɨhiya taahiyɨhiyai numwaahauhɨ napɨwɨ Jisaasihopɨ ko siyahoe tɨwɨ jaipɨtɨwɨ katauhɨhandɨ kandɨ pɨwɨha komɨhetɨ nepɨ yawutaitaatɨwɨha kiya wɨndɨ monɨhopo. Monɨhauhɨ ipotaataatɨnɨhɨ utaahurɨ wurɨ Jisaasiho jɨhɨ pɨwɨha wa katihɨ atɨwimɨhurɨ nammɨ pɨwɨha isɨhiyaamɨ ndɨhetɨ ausaamaise. ");
INSERT INTO agm_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nammɨ ausaamaamɨ kurɨ isɨhiya pɨwɨha atiwɨ nepɨ tipɨtapaahohiyɨhiyai asɨretɨ saundamaase. “Kɨmo utaamo jɨhɨ yɨhoaaŋɨ atɨwisonɨhɨ satise, ‘Autaahaatɨhomɨ aŋaaŋɨ awaindɨhandɨ nɨnɨ netɨ nga nupwɨsasɨtɨ nopɨsasɨtɨmatɨ amɨ jahɨra asisɨha mairɨmetɨ netɨ mɨhondɨ aŋɨmatɨtɨ owemaito,’ tahore,” undɨmɨ kaundamaase. ");
INSERT INTO agm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kurɨ saundihɨ atiwosawɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai waamaindumapɨ dɨpumanɨwɨ nunyohiyɨhiyaamɨ mɨtɨho awaisɨho dotɨ Jisaasihoai saundatɨ nunjenataise. “Pɨwɨha kɨma utaamurɨ kinyapɨ ko satise tɨmɨ katisɨmaapɨ wihoaaŋɨha owetiso?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Saundihɨ Jisaasiho apɨhɨmandaise. Apɨhɨmaatihɨ namatɨ utaaho awaisɨho nunjesɨho Jisaasihoai jɨhaatɨ saundataase. “Autaahaatɨho asoho akɨtɨho konɨhɨ jinjapɨhɨ bimisɨhomɨ ambɨpata amɨ komɨ ndɨhetɨ nɨnɨ gi kɨnyɨ akɨtɨ akɨtɨnɨhɨ sanahaahonɨne ndɨtaapɨ nahɨsenataayonɨ wanɨ tɨtɨhɨ kanyate? Kɨnyɨ Isɨhiyai Japɨhɨ Numwaapɨ Iwinjatɨtaapɨ Autaahaatɨho Ahɨngisɨhoŋɨ Autaahaatɨhomɨ Mwaahoŋɨtapaapaaho?” undataase. ");
INSERT INTO agm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Saundihɨ Jisaasiho koai saundataase. “Ye, kɨwahoŋɨ sa ka katingaare. Nɨnɨ sɨkonɨne. Sɨkonɨnisɨ nɨnɨ sahɨ nahatiyaatangi akɨtɨnɨhɨ kasatataato, wanɨ naaŋatɨ yaasɨhaiwa nehohurɨmuraapɨ namasatɨ Autaahaatɨho apɨpaahɨ watɨpɨho komɨ watɨpɨhaiwa nahatewa nɨngi naninyonɨhɨ awaisɨhonɨnimandɨ yamɨhapataatɨhapɨ isɨhiyai winjatɨmɨ naisanɨhɨ sahɨ ninjapɨ mmondaapo. Aindɨ ipotɨ jahɨra isɨhiyai netɨ tipɨtapaitandɨ enjerɨhiya nisɨ yamɨhapataatɨhapɨ itɨpɨhiya otɨpɨpatɨhiyaisatɨ tɨwipataatɨhɨ Autaahaatɨhomɨ watɨpɨhandisatɨ nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ napisanɨhɨ sahɨ ninjaitaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisaasiho saundihɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai waamaindumapɨ nunyohiyɨhiyaamɨ mɨtɨho awaisɨho Kaiyapaasiho Jisaasiho katisɨhaapɨ satatɨ, “ko Autaahaatɨhoai netɨ nopɨsasatɨ sisɨpɨhɨtihɨ nɨngi aponyise,” undatɨ isɨhiyai nunjɨtandɨ komɨ apotɨhɨrɨ tiwatɨhaatɨhɨrɨ napwɨratɨ sandaase. “Utaaho kɨmo, ‘nɨnɨ Autaahaatɨhomɨ Mwaahonɨne,’ ndaatɨ ko noaipatɨ Autaahaatɨhoematatɨ amɨ Autaahaatɨhopɨ sisɨpɨhɨndaase. Satatɨ sisɨpɨhɨtihɨ aimɨ kɨma nyahɨ atisɨhaayonɨ napaapɨ jatɨtɨhaawe? ");
INSERT INTO agm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sahɨ napitaiwɨ gwɨnyaawaayopo?” undatɨ isɨhiya nahatiyai nunjenataise. Kaiyapaasiho saundatɨ nunjesɨhɨ isɨhiya nahatiya pɨwɨha naasaahɨ koai saundawaatopo. “Jisaasiho pɨwa komɨ katisaapɨ napone?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Satɨwɨ isɨhiya Jisaasihoai komɨ ndɨmaahomwaaŋɨ maahoaipurɨpwɨ komɨ ndɨha nɨwisapupwɨ namaasapɨ tipɨ asanapatɨ pɨhaapɨpatɨ turɨwipɨ tiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Sawiwɨ Jisaasihoai sisɨpɨhundɨwɨ saundawaatopo. “Isɨhiyai Japɨhɨ Numwaapɨ Iwinjatɨtaapɨ Autaahaatɨho Ahɨngisɨhoŋɨtapaapaahɨ saiwa ndɨ kiyatɨ tɨhuse tɨpɨ Autaahaatɨho netɨ gi nahɨsonɨhɨ nyangi ausaapɨ kanyate?” undɨwɨ maatɨmaatiwɨ mɨmaipɨwɨsawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jisaasihoai mɨhatɨhɨ aŋɨtɨtɨhɨ taawɨ sawɨsauhɨ Pitaaho yamaapɨ ipaahaapɨ isɨhiya usaisa bindataise. Bimihɨ Kaiyapaasihomɨ asɨhiya otɨpɨpatɨhiyaamɨ waatɨ nasatɨ Pitaahoai usonatosatɨ saundataase. “Kɨnyɨ gisangi utaamoŋɨ Jisaasiho aunahɨpatɨ Garirihandaahapɨhoaisapɨ maasɨ bitohɨnɨhɨ gɨsotɨhoŋe,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Saundihɨ Pitaaho kɨmɨ konɨne mundatɨ isɨhiya nahatiyaamɨ otɨhaatɨ ndɨhetɨ noaasatɨ saundataase. “Utaaso pɨwa kɨnyɨ katingo soai nɨnɨ wɨndɨ mausotɨhonɨnisɨ kɨnyɨ nehɨ nuwipɨhandɨ katapaase,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Saundamapɨ Pitaaho isɨhiya ahoyanohiyɨhiyaamɨ ndɨhaapɨ yayatɨ dosi nawɨsaitatɨ notɨ onepatamɨ maasomwaaŋetetɨ bitondaise. Bitosɨhɨ Kaiyapaasihomɨ asɨhiya otɨpɨpatɨhiyaamɨ apopaatɨ amɨ waatɨ Pitaahoai iwinjataise. Iwinjataatɨ kapɨhɨ isɨhiya bitohohiyɨhiyai saundataase. “Utaamo kɨmo Jisaasiho Nasaretɨhandaahapɨhoaisatɨ maasɨ bitosɨhɨ iwinjahonɨhoe,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Saundihɨ Pitaaho, “Ye, kɨmɨ konɨne,” mundatɨ daahɨ jahɨra noaasatɨ komɨha saundataase. “Apɨpaahɨ akɨtɨ akɨtɨnɨhɨ Autaahaatɨhomɨ ndɨhetɨ nɨnɨ utaaso soai wɨndɨ mausotɨhonɨne ndaato,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Saundatosatɨ bitosɨhɨ kapɨhata masɨwonjɨ sanaihɨ kapɨhɨ isɨhiya usɨhiya bitotawaahiya napɨwɨ Pitaahoai saundawaatopo. “Akɨtɨsɨ uto nyahɨ gi aimɨ gɨsohonɨ kɨnyɨ pɨwaatɨpɨ kaingɨrɨhɨretɨ aimɨ mmoho kɨnyɨ Jisaasihoaisawɨ daiwɨ bitohohiyɨhiyaamɨ woŋe,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aiwɨ saundɨwɨ mwɨtetauhɨ Pitaaho yayatɨ nuwinatɨ namatɨ Autaahaatɨhomɨ ambɨpatɨ katatɨ sandaase. “Amɨ nɨnɨ pɨwɨma kɨma katohɨma akaaha kamaatisanaahɨ gaasɨ Autaahaatɨho nɨngi naaŋatɨ yaasahandɨ nanɨmɨto. Nɨnɨ apɨpaahɨ akɨtɨ akɨtɨnɨhɨ utaaso so Jisaasihoai wɨndɨ mausotɨhonɨne ndaato,” undatɨ isɨhiya nunjehohiyɨhiyai kaundataase. Kiyai saundatɨ osasepɨhaasɨhɨ nehɨ ketɨ kuraanɨhɨ otɨpwɨsɨpaatɨ gandaase. ");
INSERT INTO agm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aihɨ ketɨ Pitaaho Jisaasiho pɨwɨha jɨhɨ koai tɨmanatɨ saundatɨ kaundisɨhaapɨ gwɨnyaataise. Iyatɨ Pitaaho Jisaasihomɨ pɨwɨha kaundisɨha sura gwɨnyaasɨha kɨmaare: “Otɨpwɨsɨpaatɨ sangɨ gaatonɨhɨ isɨhiya gi kɨnyɨ komɨhoŋe hɨsaihɨ amɨ kɨnyɨ kiyai saundɨpɨ, ‘Owe, nɨnɨ utaaso soai wɨndɨ mausotɨhonɨne,’ undɨpɨ nisɨ ambɨpatɨ nepɨ nanoaasɨtaise,” undisɨha gwɨnyaataise. Siyatɨ gwɨnyaataatɨ namatɨ komɨ maarɨho tundihɨ onepatamɨ mɨhapaahɨ noaipatɨ awaindɨhandɨ ngotɨ maipiyamataise. ");
INSERT INTO agm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Aihɨ bowihɨ asisɨhaatɨhɨ kohokoaisawɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa kohasɨpɨho maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai waamaindumapɨ dɨpumanɨwɨ nunyohiyɨhiyaamɨ mɨtɨhiya nahatiya amɨ Judaahiyaanamɨ gwɨnyaahiya jɨhiya pɨwɨha apatindɨtɨhɨ kanɨwɨ sanɨhohɨha Jisaasiho nɨnɨ Autaahaatɨhomɨ Mwaahonɨne ndaatɨ Autaahaatɨhopɨ sisɨpɨhɨndaasɨ sandapɨ ko napwɨto nɨwɨ aimɨ kanɨhohɨha nepɨ tɨtɨhemapɨ Jisaasiho gaasɨ napwɨto nɨwɨ tipɨtapaapɨ mmonɨwɨ andɨtipɨ nepɨ kanɨwɨ wɨsasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sanɨwɨ tɨmanɨwɨ apɨpaahɨ wɨsasawɨ isɨsi Jisaasihoai nepɨ wɨrɨhɨrɨ watɨpɨhɨrɨ senɨhanda wɨsasawɨ numwaasi Romɨhandaahapɨ gamanɨhomɨ utaaho wo kiyapɨho komɨ ambɨpatɨ Pairotɨhoenda nowaayopo. Gamanɨho Romɨhandaahapɨho Jisaasihomɨ pɨwɨha tipɨtapaatɨ mmonatosatɨ awaisawɨhiyai aaye undatɨ Jisaasihoai tiwɨtandɨ sandɨ Pairotɨhoenda numwaasi nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jisaasiho sohoai tiwɨtaatɨwɨ saiwɨ pɨwɨha kanɨwɨ wɨsasauhɨ Judaasiho Jisaasihoai komɨ tiworisaamɨ ikwɨraatɨhɨ awusaatɨ numwisɨho sandɨ mmonataatɨ namatɨ koai ipotɨwausesɨhɨ nɨnɨ maipɨhandɨ kiyono tatɨ maarɨho naaŋawihɨ gwɨnyaataise. Iyatɨ nawɨho taanauhɨho 30 kaiwɨ siriwaaho Jisaasihomɨ tiworisa Judaasiho nusepaasɨtɨhandapɨ nunyotɨho jahɨra nesi notɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai waamaindumapɨ nunyohiyɨhiyaamɨ mɨtɨhiyaisunɨ Judaahiyaanamɨ gwɨnyaahiya jɨhiyaisunɨ nunyataise. ");
INSERT INTO agm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nesi notɨ nunyataatɨ kiyai ko saundataase, “Nɨnɨ utaahonɨnɨ apɨpaahɨ maipɨhandɨ kaindɨ Jisaasiho utaaho tɨtɨhɨ ainahɨhoai sangi nasepaatɨ samɨ ikwɨraatɨhɨsamahonɨhɨ sohoai sahɨ tiwɨtaatɨwɨ pɨwɨha kanɨwɨ aimɨ wɨsasauhɨ samɨ nawɨho jahɨra kɨmo nasesi nasonɨ nepɨse,” undatɨ kiyaamɨ nawɨho jahɨra nunyataise. Saundatɨ numwihɨ kiyaamɨha Judaasihoai saundawaatopo. “Sandɨ kɨnyɨ Jisaasihoai kawingɨtɨndapɨ nyahɨ wɨndɨ apɨpaahɨ gɨmunyaitaanɨ kɨnyɨ kɨwahonyɨhandisɨ wɨrapɨ isɨpɨ bitose,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Saundauhɨ Judaasiho nawɨho Autaahaatɨhomɨ aŋɨ awaindɨhandaatɨhɨ sapɨhɨ yotamapɨ notɨ wɨratamataise. ");
INSERT INTO agm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Aihɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai nunyohiyɨhiyaamɨ mɨtɨhiya nawɨho Judaasiho tɨmasɨho nepɨ sanawaatopo. “Kɨmo nawɨmo itapɨpa tiwaatɨ jɨtɨpatɨ newaatɨ nuhaitɨhaawɨ nunyaahosɨ amɨ nyamɨ wɨnɨhapɨpa itɨhɨtɨhapa ahotahosɨ Autaahaatɨhomɨ aŋɨ awaindɨhandamɨ otɨpɨpatapɨ wɨndɨ ahɨmaitɨhaawo,” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Sanɨwɨ pɨwɨha naasaahɨ kanɨwɨ wɨsasawesi nawɨho ko nepɨ koraahɨ kapɨhɨ yapɨpatɨ wɨtɨ isɨhiya kaanɨhapɨhiya napwisaihɨhiyai kata yamwaitaatɨwɨ nunyawɨ newaayopo. Iyataatɨ satɨ yapitɨ sisɨwaahaipatɨ kwaatɨhaihaatɨ isɨhiya nopɨ jɨhura onɨha yapɨpatɨ kaimbɨwɨhatɨ nehɨ ahotihɨhatɨ nunyawɨ newaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Saiwɨ nawɨho itapɨpa tipɨ jɨtɨpatɨ nepɨ nuhaitaatɨwɨ nunyawɨhora namapɨ satɨ yapitɨ nunyawɨ nepɨhatɨtihɨ isɨhiya satɨ yapiti Jɨtɨpataapɨhe tɨwɨ ambɨhɨtɨwɨ wanɨ kɨmuraisangi satɨwɨ katɨwɨ ambɨhɨtawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iyataatɨ sandɨ jɨhura utaaho Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho Jeremiyaaho pɨwɨha wa satatɨ katɨsɨha tɨtɨhɨ akaaha noaipataise. Iyataatɨ pɨwa sandaase: “Kiya nawɨho taanauhɨho 30 kaiwɨ isɨhiya Isɨraherɨhiya kopɨ nusepaasɨhoai numwɨtaatɨwɨ pɨwɨha wɨsasawɨ aaye tohɨho kamwaaŋɨ tɨtɨhɨ newaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nepɨ nawɨho kora kapɨhɨ yapɨpatɨ onɨha kiyohiyɨhiya yapɨpatɨ sisɨwaahaipatɨ nopɨ namasawɨ onɨha kaiwɨ tɨhohiyɨhiyaamɨhatɨ nunyawɨ newaayopo nɨngi Awaisɨho nunyapɨ nepe dindɨhandamataiwo,” ndaase. ");
INSERT INTO agm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Aihɨ komɨ tiworisa numwaasi niyauhɨ notɨ Jisaasiho Pairotɨhoaapɨhɨ noaipataise. Noaipatɨ Pairotɨhomɨ ndɨmaahomwaaŋɨ bitosɨhɨ Jisaasihoai Pairotɨho saundatɨ nunjenataise. “Kɨnyɨ Judaahiyai iwinjatingɨhoŋɨ awaisɨhoŋo?” undatɨ nunjenataise. Saundatɨ nunjesɨhɨ Jisaasiho komɨha Pairotɨhoai saundataase. “Ye, kɨnyɨ sa ka tɨtɨhɨ katapaase,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Iyatɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa maahoaipa tɨhɨwɨ Autaahaatɨhoai nunyohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ Judaahiyaanamɨ gwɨnyaahiya jɨhiyaunɨ pɨwɨha jaipɨtɨwɨhaiwa Jisaasihomɨhetɨ nepɨ yawutaapɨ Pairotɨhoai ko siyahoe siyahoe undohɨwaiwaapɨ Jisaasiho utaaho ainahɨhondaahandɨ kandɨ wihoaaŋɨha ko wɨndɨ kamaatɨtandɨ kamaatise. ");
INSERT INTO agm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ko siyatɨ kopɨ jaipɨtɨwɨ pɨwɨha katohiyɨhiyai wihoaaŋɨha wɨndɨ kamundihɨ Pairotɨho Jisaasihoai saundataase. “Isɨmiya kɨmiya pɨwɨha kɨmaiwa kinyɨmetemapɨ katohɨwɨmaiwaapɨ wihoaaŋɨha kaundɨtaapɨha owetiso?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pairotɨho saundatɨ nunjesɨhɨhandɨ kandɨ Jisaasiho wihoaaŋɨha koai apɨpaahɨ masɨhonjɨsangi wɨndɨ kamundise. Siyatɨ apɨpaahɨ wɨndɨ kamundihɨ Pairotɨho namatɨ apɨpaahɨ awaindɨhandɨ yayatɨ gwɨnyaataise. ");
INSERT INTO agm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Iyataatɨ Judaahiyaanɨnɨ Autaahaatɨho jɨhura nyapundatɨ isɨhiya yapɨpatɨ Isipɨhandaahiyai tiwatɨ netɨ nopɨsasamatɨ kiyaamɨ ikwɨraatɨhapɨ nyamɨ asoya asisai waatɨho asisɨha numwaasuraapɨ kɨnaungwɨha nahatewetɨ gwɨnyaahaayo. Siyahaahura nyamɨ isɨhiya maatɨmaatiwɨ maipɨhiyai gamanɨho netɨ napusawɨhiyaamɨ woai nupusoaase undaatɨ Judaahiyaanɨnɨ yawanaanɨnɨ kaundonɨhoai Pairotɨho nyamɨ kiyapɨho nuwausoaasahore. ");
INSERT INTO agm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aihɨ sura utaaho wo apɨpaahɨ maipɨho maatɨmaatisatɨ ikonatɨ isɨhiyai tiwamatɨ aunahɨpatɨ yapɨpatɨ nopɨsasaho amɨ isɨhiya nahatiya kopɨ siyahoe tɨwɨ usowɨho komɨ ambɨpatɨ Barapaasihoai nepɨ napuhauhɨ napwɨtatɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aihɨ isɨhiya wɨrɨsandɨhandɨ Pairotɨhomɨ aŋɨpɨpɨhɨ masaataatɨ noaipapɨ ahoyanɨhauhɨhura Pairotɨho kiyai saundatɨ nunjenataise. “Nɨnɨ utaamurɨ kɨmuramɨ wo maahoaisɨnɨhɨ nutusoaasɨtandɨ sahɨ samɨ maarɨho gwɨnyaawaayopo? Barapaasihoro e Jisaasiho Kɨraisihoro tohɨhoro?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sandɨ apaapɨ kiyai nunjenataamaaise amɨ Pairotɨho Jisaasiho utaaho ainahɨhosɨ nehɨ iwinjatɨ nandusoaasɨtando tatɨ gwɨnyaatɨ amɨ aimɨ biyatɨ mmonataatɨ isɨhiya nehɨhiya Jisaasihoai utaaho gaahoso tɨwɨ usohauhɨ amɨ Judaahiyaanamɨ awaisawɨhiya tanyaaha owehandɨ nehɨ nuwipɨhandɨ isɨhiya taahiyɨhiya Jisaasihoai maaritɨwɨ nuwipinjauhɨ kandapɨ kiyai apowihɨ Jisaasihoai numwaasi nasauhɨ sandapɨ isɨhiya nahatiyai nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Saundatɨ nunjenatosatɨ kiyaamɨha pɨwɨha wihoaaŋɨhaapɨ taatɨ jatihɨ komɨ apwaataatɨ Pairotɨhopɨ pɨwɨha wa nusoaasataatɨ saundataase. “Kɨnyɨ utaaso so apɨpaahɨ aŋɨnɨ tɨtɨhɨ ainahɨhoaisɨ wapa kamaawimbɨ owetane. Sandɨ gi nɨnɨ apaapɨmaahɨto, amɨ utaaso sopɨ nɨnɨ wanɨ bousetɨmetɨ kopɨ yapepatɨ nisɨ maarɨho ambɨpatɨ yainyahandɨ jataatɨhɨto. Isɨ uta soaisɨ wapa apɨpaahɨ wɨndɨ kamaawimbɨ kinyɨ ikwɨrɨ nepɨ nasɨhasɨne,” undatɨ pɨwɨha nusoaasataise. Nusoaasihɨ netɨ awɨtatɨ amɨ sandapimaawɨ Pairotɨho namatɨ Jisaasihoai netɨ nehɨ iwinjatɨ nandusoaasɨtando tatɨ gwɨnyaataise. ");
INSERT INTO agm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Aihɨ Pairotɨho kiyaamɨha wihoaaŋɨha koai kaundɨtaatɨwɨ jatataatɨ komɨ apwaataatɨ pɨwɨha nusoaasisɨha biyatɨ mmonatɨ gwɨnyaataise. Ko taatɨ saihɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa kohasɨpɨho maahoaipa tɨhɨwɨ waamaindumapɨ Autaahaatɨhoai nunyohiyɨhiyaamɨ mɨtɨhiyaunɨ Judaahiyaanamɨ gwɨnyaahiya jɨhiya isɨhiya wɨrɨsandɨhiyai nɨwusepaipapɨ saundawaatopo. “Sahɨ Pairotɨhoai saundɨwɨse. ‘Barapaasihoai nupusoaasapɨ Jisaasiho daahɨ napone,’ undɨwɨse,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aihɨ Pairotɨho kiyai bapiyatɨ jɨhaatɨ saundatɨ nunjenataise. “Utaamurɨ kɨmuramɨ maahoaisɨnɨhɨ nutusoaasɨtandɨ sahɨ maarɨho gwɨnyaawaayopo?” undatɨ nunjenataise. Saundatɨ nunjesɨhɨ kiya aimɨ gwɨnyaapɨ bitombɨwɨhiyaasɨ kaahaatɨwɨ koai saundawaatopo. “Barapaasihoai nupusoaase,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Saundauhɨ Pairotɨho kiyai komɨha saundatɨ nunjenataise. “Kiyonaahɨ Jisaasiho Isɨhiyai Japɨhɨ Numwaatɨ Iwinjatɨtandɨ Autaahaatɨho Ahɨwisɨhoe tohɨhoai nɨnɨ napitɨwitandono?” undatɨ nunjenataise. Saundatɨ nunjesɨhɨ isɨhiya nahatiya kiyaamɨ maahomwaaŋɨ nausaapɨ kaahaatɨwɨ Pairotɨhoai saundawaatopo. “Ipɨ tɨtɨhɨ atawɨhatetɨ nepɨ tipɨmandaapɨ sohoai timmape,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Saundɨwɨ kaahaatauhɨ amɨ Pairotɨho kiyai saundatɨ nunjenataise. “Kɨmo utaamo maipɨhapa maatɨmaatɨhɨrɨ napindɨnɨhɨ kaisono?” undatɨ nunjenataise. Ko kiyai saundihɨ amɨ kiya kiyaamɨ maahomwaaŋɨ norɨpatɨwɨ kaahaatɨwɨ koai saundawaatopo. “Ipɨ tɨtɨhɨ atawɨhatetɨ sohoai nepɨ tipɨmandaapɨ timmape,” undɨwɨ kaahaatawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Isɨhiya saiwɨ kaahaatɨwɨ komɨ pɨwɨha wɨndɨ atɨhomaawisauhɨ Pairotɨho mmonataatɨ wiwa maatɨmatɨhɨrɨ noaipatɨ isɨhiya nepɨ tunnɨwɨ nopɨsasɨndaawo tatɨ gwɨnyaataise. Siyatɨ gwɨnyaataatɨ namatɨ ko isɨhiya wɨrɨsandɨhiyaamɨ ndɨhetɨ otɨhaatɨ waapoho netɨ komɨ ikwɨrɨ bausataise. Bausatɨ kiyai saundataase, “Utaamo kɨmoai sahɨ sohoai tipe tɨwɨ kaahaatohɨrɨhɨretɨ japepihɨrɨwɨ tiwisaihɨ napotaataahɨ sandɨ nisɨhandɨmaahe. Owetise. Kɨmo utaamoai sahɨ tiwawaawaahɨ sawanaatamɨ gwɨnyaahohɨtɨhanda kiyawaayopo satɨtɨ nasisatɨ nisɨ ikwɨrɨ kɨmɨrɨ sahɨ ninjahauhɨ samɨ ndɨhetɨ bausataayo. Isɨ sahɨ utaamo kɨmoai tiwawaawaahɨ nehɨ sawanaatamɨhande. Sawanaatamɨhandisɨ sahɨ pɨwɨha naitaapo,” undatɨ Pairotɨho komɨ ikwɨrɨ bausataise. ");
INSERT INTO agm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pairotɨho kiyai saundihɨ kiya isɨ wɨrɨsandɨhiya nahatiya koai wihoaaŋɨha saundawaatopo. “Koai sohoai tiwaatɨ komɨ jɨtɨpatɨ newaatɨ nuhaahohɨtɨhandapɨ gaasɨ Autaahaatɨho naaŋatɨ yaasahandɨ nyangisunɨ nyamɨ manyinya asoya asisa ipotɨ ipotɨhiyai nanyamɨto,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aihɨ Pairotɨho Barapaasihoai nuwausoaasihɨ naihɨ Jisaasihoai netɨ komɨ tunnɨwɨ yahwɨnohiyɨhiyaamɨ ikwɨraatɨhematɨ saundataase. “Koai wɨrɨhɨra nepɨ yupwapɨ nupwɨ numwaasi nuwɨ tipɨmandaapɨ tipɨse,” undataase. Saundihɨ kiya wɨrɨhɨrɨ otasaahepɨ ainɨhɨrɨ dawipatamatiyahɨrɨ nainaametahɨra Jisaasihoai nepɨ yupwapɨ nuwawaayopo. Yupwapɨ nuposawɨ numwaasi nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Aihɨ Pairotɨhomɨ isɨhiya tunnɨwɨ yahwɨnohiyɨhiya Jisaasihoai numwaasi nuwɨ awaisɨho Pairotɨhomɨ aŋɨpɨpɨhɨ masaataatɨ sasaahoya usa bimohɨpɨpɨhɨ noaipawaayopo. Aiwɨ amɨ kiya nahatiyai gaatɨwɨ numwaahauhɨ kiyaisawɨ maawɨ Jisaasihomɨhinɨ napɨwɨ ahoyanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ahoyanɨwɨ Jisaasihomɨ apotɨhɨrɨ niyosɨrɨhɨrɨ nesɨpamapɨ kiya apotɨhɨrɨ isɨhiya awaisawɨhiya gamanɨhiya kiŋɨhiyaahɨhɨ niyohohɨrɨhɨrɨ nepɨ Jisaasihoai nɨwusoaitaatɨwɨhapa newaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Aiwɨ kiya kaarɨha kɨsɨhɨsumbɨpa niyapɨ jaipaiwɨ namɨhanɨwɨ tingaatɨha awaisawɨhiya gamanɨhiya kiŋɨhiyaahɨhɨ nipaatohɨha kaiwɨ Jisaasihoai komɨ mɨtɨhoaasɨnɨ nɨwipaapɨ amɨ irɨhɨrɨ awaisawɨhiya gamanɨhiya kiŋɨhiyaamɨ watɨpɨhandɨ nunjahɨrɨ komɨ ikwɨrɨ gaahɨretɨ isɨpusosawaayopo. Aiwɨ kiya komɨ utatototɨ atotɨpɨwesawɨ ko kiyaamɨ ipɨpaatihɨhandaamataiwɨ maatɨmaatɨwiwɨ sisɨpɨhundawaayopo. Sawiwɨ koai saundawaatopo, “Sɨkoŋe. Sɨkoŋɨ Judaahiyai koŋɨnɨhɨ kiŋɨhoŋimatɨpɨ winjatɨmɨ numwe!” undɨwɨ maatɨmaatundɨwɨ sisɨpɨhundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Saundɨwɨ maatɨmaatundɨwɨ sisɨpɨhundɨwɨ Jisaasihoai maahoaipurupwɨ amɨ irɨhɨrɨ kiya isɨpusosohɨrɨhɨrɨ nepɨ kɨraahɨ komɨ mɨtɨhaatɨhɨ jinjɨhaatɨ tiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kiya koai saiwa sawiwɨ owemaposawɨ apotɨhɨrɨ isɨhiya awaisawɨhiya isɨhiyai iwinjatohiyɨhiya niyohohɨrɨhɨrɨ Jisaasihoai nepɨ maatɨmaatɨwiwɨ nɨwɨsohohɨrɨhɨrɨ nesɨpapɨ sawahomɨhɨrɨ nepɨ nɨwɨsoposawaayopo. Aiwɨ kiya ipɨ tɨtɨhɨ atawɨhatetɨ tipɨmandaapɨ sohoai tiwɨtaatɨwɨ Jisaasihoai numwaasi nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Saiwɨ aunahɨpatɨ namasi Jisaasihoai numwaasi taawɨ daihɨra nowaawɨ utaaho wo aunahɨpatɨ Sairinihandaahapɨho komɨ ambɨpatɨ Saimonɨhoaisawɨ nutanawaayopo. Nutanɨwɨ koai Jisaasihomɨ ipɨ tɨtɨhɨ atawɨhatɨ tunnɨwɨ yahwɨnohiyɨhiya nehɨ sawanaunyaapɨ tarɨwundɨwɨ nepɨ tɨpwɨtɨwusosauhɨ ko turɨpwɨtataise. ");
INSERT INTO agm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aiwɨ Jisaasihoai numwaasi kiya nuwɨ aunahɨpatamɨ nawɨsapɨ ipaahaapɨ wapɨhɨ ambɨpatɨ Gorɨkataahanda noaipawaayopo. Iyataatɨ satɨ ambitɨ Gorɨkataahando tohɨtɨndɨ tanyaaha itapɨpaamɨ mɨtɨhomɨ andɨtatamatetahapɨho tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sapɨhɨ noaipapɨ komɨ ambɨpatɨ yatɨhɨ yaawonɨhɨ tipɨmandaitaatɨwɨ Jisaasihoai waapoho wainɨhandɨ waapoho watɨpɨho ikɨrɨhoaisawɨ tɨmaamaipɨ nuhaapɨ kɨsɨhɨsiwɨ nandotɨwɨ tunnɨwɨ yahwɨnohiyɨhiya nunyawaayopo. Nunyauhɨ netɨ nanatɨ mmonata ikonatɨ nurɨtɨmasɨhɨ amɨ ko wɨndɨ namainje. ");
INSERT INTO agm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aihɨ sapɨhɨ Gorɨkataahanda Jisaasihoai ipɨ tɨtɨhɨ atawɨhatetɨ tipɨmandaahauhɨ napwɨtandɨ nimandataise. Tipɨmandaaposawɨ tunnɨwɨ yahwɨnohiyɨhiya Jisaasihomɨ apotɨhɨrɨ wɨrɨ tipɨtapaapɨ newaawɨ wɨrɨ nahatohɨrɨtihɨ namapɨ kɨrɨ diyaamaho nese tɨwɨ ipɨpa wapa isawaayopo. Isawaawɨ apotɨhɨrɨ nahatohɨrɨ kiyaamɨ wo netaise. ");
INSERT INTO agm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Saiwɨ ipɨpa isɨwɨ Jisaasihomɨ apotɨhɨrɨ neposawɨ kiya kapɨhɨ daahɨ bindawa Jisaasihoai wiwa komɨ naisɨhiya tinjaapɨ numwaitaawo tɨwɨ jaawɨ bitotawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aiwɨ Jisaasihomɨ mɨtɨhomɨ autaahɨ ipatetɨ komɨ tiworisa pɨwɨha kaapɨ napone tohɨha utɨpɨhoaatɨhɨ jɨpatɨpaiwɨ tipɨmandaaposawaayopo. Iyawaawɨ sa pɨwa satɨwɨ jɨpatɨpiyawaayopo. Kɨmo Jisaasiho Judaahiyai Iwinjatisɨho Kiŋɨho Awaisɨhore, tɨwɨ jɨpatɨpaiwɨ tipɨmandaaposawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aihɨ utaahurɨ wurɨ maatɨmaatimɨ ikopaisahuri Jisaasihoaisawɨ maawɨ ipɨ tɨtɨhɨ atawɨhatɨ yatɨwetɨ woai gaahɨraihoaaŋɨ amɨ woai konaamohihoaaŋɨ tipɨmandaahauhɨ napwɨtaatɨmɨ nimandamaise. ");
INSERT INTO agm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Isɨhiyaamɨ daihɨra detɨ saiwɨ tipɨmandaaposauhɨ isɨhiya daiwɨ nuwɨ napɨwɨyawaahiya iwinjawaawɨ Jisaasiho ipatetɨ tipɨmandandihɨ kiyaamɨ mɨtɨho tunniwɨ ikwɨwiwɨ pɨwɨha maipɨhaiwa kaundɨwɨ sisɨpɨhundawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Sisɨpɨhundɨwɨ saundawaatopo, “Ese! Uto kɨnyɨ satɨpɨhoŋɨsɨ Autaahaatɨhomɨ aŋɨ awaindɨhandɨ nɨnɨ otinjaatɨ napapatɨ nupwɨsasɨtɨ amɨ asisɨha mairɨ ma saniyonɨhɨ jahɨra netɨ mɨhondɨ aŋɨmatɨto tingɨhoŋɨ sɨkoŋo. Kɨnyɨ Autaahaatɨhomɨ Mwaahoŋɨtapaapaahɨ immatɨ nemapɨ namaapopɨ asohoŋimate,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sɨrɨ kɨretɨ naasaipitɨ kawiwɨ pɨrisihiya isɨhiya isɨhiyaapɨ nandapa kohasipɨho maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai waamaindumapɨ nunyohiyɨhiyaamɨ mɨtɨhiyaunɨ katɨwunjohiyɨhiyaunɨ amɨ gwɨnyaahiya jɨhiyaunɨ Jisaasihoai nepɨ nusopɨsasɨwɨ mɨmaipɨwiwɨ sisɨpɨhundawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kiya sawiwɨ Jisaasihopɨ satawaatopo, “Kɨmo utamo isɨhiya usaisɨ tɨtɨhemwahosɨ amɨ katɨ kiyatɨ sawaho wɨndɨ tɨtɨhematatɨ ipatetapɨ namoaatɨpase. Iyatɨ ko Isɨraherɨhiyai Iwinjatisɨho Awaisɨho sɨkosɨ ipɨ tɨtɨhɨ atawɨhatɨ nemapɨ noaatɨpane. Noaatɨpahonɨhɨ nyahɨ mmonaatɨ akɨtɨ koso taatɨ kopɨ gɨwunyaitaano. ");
INSERT INTO agm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iyatɨ amɨ ko Autaahaatɨhopɨ biyatɨ gɨwunyaatɨ amɨ ko Autaahaatɨhomɨ Mwaahonɨne tahore. Satahosɨ wanɨ Autaahaatɨho koaisɨ maarɨho nunyataatɨ nasatɨ koai tinjausetɨ numwaaso taatɨ nyahɨ iwinjaitɨhaawo,” nɨwɨ kiya Jisaasihopɨ sisɨpɨhɨtawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iyauhɨ amɨ utaahurɨ maatɨmaatɨhɨrɨ ikopaapɨ nepɨ tipɨmandaahohururisangi Jisaasihoai naasaipitɨ katɨ kawimɨ sisɨpɨhundamaase. ");
INSERT INTO agm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Aihɨ ipɨho saniyatɨ otɨhasɨnɨtatɨ sɨwipatɨ auhɨraapɨhɨ itɨpunohuraatihɨ kapɨhɨ yapɨpatɨ nahatepɨ gaamatɨ nehɨ nɨwipɨhandɨ ipɨho asɨhataise. Siyatɨ asɨhatɨmɨ notɨ ipɨho sɨwipatɨ japɨhɨ saasɨnataise. ");
INSERT INTO agm_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Iyatɨ sura ipɨho mɨhepɨ yaataatisuraatihɨ Jisaasiho nehotatɨ kaahaata sandaase. “Eri Eri rama sapakɨtani?” tatɨ kaamɨ tanyaaha sandaase, “Ese, nisɨ Autaahaatɨhoŋe kɨnyɨ nɨngi napindapɨ apɨpaahɨ nanɨmamahise?” tatɨ komɨ Sapɨho Autaahaatɨhopɨ kaahandaase. ");
INSERT INTO agm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Satihɨ isɨhiya usa sapɨhɨ bitotawaahiya koai atɨwisawaawɨ satawaatopo. “Ko Eraijaahopɨ gandaase nasatɨ tinjausaitando,” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sanɨwɨ kiyaamɨ wo atisamapɨ nihɨti notɨ wɨndɨ yutɨpɨhandɨ waapoho isɨwatɨtandɨhandɨ netɨ waapoho wainɨhandɨ biyatɨ jɨmaayahandɨ tɨmandaatɨ notɨ irɨhɨrɨ asatɨpatetɨ ningahɨwatɨ nesi niyatɨ Jisaasiho nandotatɨ komɨ maahomwaaŋɨ ahɨwisatɨ nunyataise. ");
INSERT INTO agm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wo Jisaasihoai sawihɨ amɨ usa satawaatopo, “Eraijaahopɨ gandaasɨ koai Eraijaaho nasatɨ tinjausetɨ numwaaso taatɨ iwinjaitɨhaawo,” tɨwɨ Jisaasihopɨ maatɨmaatɨtɨwɨ sisɨpɨhɨtawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aihɨ Jisaasiho jahɨra Autaahaatɨhopɨ kaahaatatɨ sawahomɨ gwɨnyaasɨtɨhanda komɨ maarɨho Autaahaatɨhoai numwihɨ numwaasɨhɨ napomataise. ");
INSERT INTO agm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Aihɨ sura Jisaasiho maarɨho nusoaasisururaanɨhɨ apotɨhɨrɨ utaarɨhɨrɨ Autaahaatɨhomɨ aŋɨ awaindɨhandaatɨhɨ nimandirɨhɨrɨ otɨhutaatɨ mɨhasɨnapɨ napwɨrɨnɨmɨ kɨrɨnɨhɨ mɨhaapɨ notɨ yatɨwɨndaise. Aihɨ yapɨpatɨ ahoainatɨ ipɨpatɨpatɨ ipɨpatɨpinatɨ amɨ nawɨha awaiwaiwa nutatɨ nawatataise. ");
INSERT INTO agm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Iyatɨ kapɨhɨ isɨhiya itapɨpaamɨ anɨmwaasɨha ipwɨrɨndɨwatɨ nutatɨ nuwatɨ japwainjɨhɨ isɨhiya Autaahaatɨhopɨ gɨwunyaahohiyɨhiya napwauhɨ yamwaahohiyɨhiya jahɨra taahiyɨhiya nepawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aiwɨ Jisaasiho anɨmwaahɨpatombɨ aimɨ nepasɨhura kiyaamɨ anɨmwaahɨpatɨ namasi aunahɨpɨ Awaipatɨ Autaahaatɨho satɨ nisɨhate tatɨ maaritimbɨpɨhɨ Jerusaremɨhandaahapɨ niyawaayopo. Niyauhɨ isɨhiya taahiyɨhiya kiyai iwinjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yapɨpatɨ siyatɨ ipɨpatɨpinatɨ kahapaamapɨpa nahataapa noaipasɨpɨpa tunnɨwɨ yawɨnohiyɨhiyaamɨ saaho tɨhaapundisɨhounɨ tunnɨwɨ yahwɨnohiyɨhiya koaisawɨ Jisaasihoai iwinjatohiyɨhiya mmonɨwɨ apɨpaahɨ awaindɨhandɨ yayawaayopo. Yaiwɨ kiya Jisaasihopɨ satawaatopo. “Ese, uta kɨmo apɨpaahɨ akɨtɨnɨhɨ Autaahaatɨhomɨ Mwaahore!” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Iyataatɨ asɨhiya taahiyɨhiya Jisaasihoai iwɨtatamanɨwɨ tɨhɨngwaasɨwiwɨhiya koai Garirihandaahapɨ nuwipinjai napɨwɨhiya sapɨhɨ nawɨsawɨ kaanɨhɨ bitotawa mmonɨwɨ japepinjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Aiwɨ siya asɨyaamɨhatɨhapɨ winyaamɨ ambɨpatɨ sinyaare: Mariyaahaatɨ aunahɨpatɨ Makɨtaraahandaahapɨhaatɨtihɨ amɨ waatɨ Maariyaahaatɨ Jemɨsiyɨ Josepiyaamɨ sanaatɨ amɨ waatɨ Sepetihomɨ mwaahuramɨ sanaatɨ siyaare. ");
INSERT INTO agm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aihɨ ipɨho sangɨ nipatatɨ asɨhatahuraatihɨ utaaho wo komɨ ambɨpatɨ Josepɨho kapɨhɨ nasatɨ noaipataise. Iyataatɨ so aunahɨpatɨ Arimatiyaahandaahapɨho ikɨpɨpa nawɨho taahɨpɨpaisahore. Iyatɨ ko Jisaasihomɨ pɨwɨha biyatɨ atisatɨ netɨ japepihɨratɨ amɨ Jisaasihoai maarɨho biyatɨ nunyahore. ");
INSERT INTO agm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Iyatɨ ko Pairotɨhoenda notɨ Jisaasihomɨ ambɨpatɨ netɨ yamwaitandɨ nunjenataise. Netɨ yamwaitandɨ nunjesɨhɨ Pairotɨho komɨ tunnɨwɨ yahwɨnohiyɨhiyai Jisaasihomɨ ambɨpatɨ Josepɨhoai nepumwɨtaatɨwɨ pɨwɨha kaundataase. ");
INSERT INTO agm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kaundihɨ nuwɨ Jisaasihomɨ ambɨpatɨ Josepɨhoai nepunyauhɨ Josepɨho Jisaasihomɨ ambɨpatɨ netɨ apotɨhɨrɨ kɨhoepɨhɨrɨ asɨrɨhɨraapɨhɨ mmataise. ");
INSERT INTO agm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Mmatɨ anɨmwaahɨpatɨ akosɨha wanɨ asɨpatɨ itapɨpa wɨndɨ ahɨmaayawɨhatɨ sawahomɨhatɨ koai nawɨhetɨ nisatoaapatɨ yamwaahatopɨ Jisaasihomɨ ambɨpatɨ nesi notɨ wiwatɨ ahiyataise. Siyatɨ wiwatɨ ahiyatɨ anɨmwaahɨpatamɨ maahomwaaŋɨ mipatetɨ nawɨha awaisɨha nawapwaaho netɨ nisapuwatɨ napuwatosamɨ sapɨhɨ namasi notaise. ");
INSERT INTO agm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aihɨ Mariyaaha Makɨtaraahandaahapɨhaatunɨ Mariyaahaatɨ waatɨ sapɨhɨ anɨmwaahɨpɨ akosaamɨ wihɨnɨ mandosamɨ bindamaise. ");
INSERT INTO agm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Aihɨ bowihɨ Judaahiyaanamɨ asisɨha awaisɨha Sapaatɨhandetɨ pɨrisihiya isɨhiyaapɨ nandapa maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai waamaindumapɨ nunyohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ Parisihiya napɨwɨ pairotɨhoai iwinjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Iwinjapɨ Jisaasihopɨ koai saundawaatopo. “Awaisɨhoŋe, uta jaipɨmundisɨho sangɨ napotɨ asoho bindataahura pɨwɨha wa ko katisɨhaapɨ nyahɨ gwɨnyaahaawɨ gi kaapɨ kahɨtisaihɨ kɨnyɨ wapa kaitaapɨ nahɨsendɨhaawɨ nasahaayo. Iyataatɨ uta jaipɨmwɨndisɨho pɨwɨha satɨmɨhore. ‘Asisɨha mairɨ ma saniyonɨhura jahɨra nɨnɨ anɨmwaahɨpatombɨ nepaito,’ tatɨ katɨmɨhore. ");
INSERT INTO agm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Satɨmɨhosɨ wiwa komɨ otɨpɨpatɨ kaiwɨ mmowɨ nepɨ nuwipinjohiyɨhiya noaatɨwɨ apatindɨtɨhɨ napɨwɨ komɨ ambɨpatɨ ikonɨwɨ neposawɨ isɨhiyai wiwa kiya satɨwɨ, “Ko anɨmwaahɨpatombɨ aimɨ nepase,” undɨwɨ jaipundɨtaapo. Saundisaihɨ jaipɨpa kɨmba ipotɨhapa jɨhapai nusatipɨhaatɨ awaimbɨpaatɨtaise. Iyataatɨ sandɨ nyahɨ gi apaapɨmaahɨto kɨmba jaipɨmba nepɨ atiwɨ gwɨnyaapɨ isɨhiya taahiyɨhiyai kataunjiwaiwa japepihɨrɨtauhɨhandapɨto. Isɨ sandapɨ kɨnyɨ tunnɨwɨ yahwɨnohiyɨhiyai kaundisamɨhɨ kiya Jisaasihomɨ anɨmwaahɨpatetɨ asisɨha mairɨ ma sanotɨ owetanɨhapɨ jaawɨ bitoaito. Jaawɨ bitosaihɨ komɨ otɨpɨpatɨhiya komɨ ambɨpatɨ wɨndɨ napɨwɨ ikomando,” undɨwɨ Pairotɨhoai kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Saundauhɨ Pairotɨho kiyai komɨha saundataase, “Gaasɨ tunnɨwɨ yahwɨnohiyɨhiya usai numwaasi nuwɨ anɨmwaahɨpatamɨ maahomwaaŋɨ mipatɨ anɨtiwɨ nepɨ napupwɨ kaiwosawɨ kiyai ahɨwisaihɨ jatɨwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Saundihɨ kiya nuwɨ anɨmwaahɨpatɨ anɨtiwɨ nepɨ napupwɨ amɨ nawɨha mipatetɨ napwɨndisɨha isɨhiya usa nupwɨ nemaamaito tɨwɨ itɨhɨtɨwɨ asɨtɨha napupwɨ wapa mipatetɨ namasawaayopo isɨhiya wapa wipaisaihɨ mmondaatɨwo. Aiwɨ tunnɨwɨ yahwɨnohiyɨhiyai ahɨwisauhɨ kapɨhɨ jaawɨ bitotawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Aihɨ Judaahiyaanamɨ asisɨha awaisɨha Sapaatɨhandɨ mmonɨhoaasohɨha aimɨ sanotɨ owetihɨ asisɨha Sandehura taatɨ bowataise. Taatɨ bowihɨ asisɨhaatɨhɨ koho koaisamɨ apopɨpurɨ Mariyaaha Makɨtaraahandaahapɨhaatɨtihɨ amɨ Mariyaahaatɨ waatɨtihɨ Jisaasihomɨ akosɨha anɨmwaahɨpatɨ mmondaatɨmɨ nomaise. ");
INSERT INTO agm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aihɨ sapɨhɨ ketɨ nɨwisaataatapɨhandɨ wonamaatɨ topɨtaata yapɨpatɨ ipɨpatɨpinataise amɨ Autaahaatɨho Awaisɨhomɨ enjerɨho itɨpɨho yamɨhapataatɨhapɨ otɨpɨpatɨho yamɨhapatɨ namasi maapɨ yapɨpataapɨhɨ noaatɨpasɨho. Noaatɨpatɨ nawɨha nawapwaaho aungwohandɨ anɨmwaahɨpatamɨ maahomwaaŋɨ mipatetɨ napwɨndisɨha nuwatɨ netɨ nepehaasatɨ kaanɨhɨ nawɨsatɨ ahiyatosatɨ kasɨnɨ ko bindataise. ");
INSERT INTO agm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Iyataatɨ komɨ ambɨpatɨ ndɨmaahomwaaŋɨ nahato sisɨha kɨnapɨpaamatiya nausaatatɨ otiwatɨ kaumbwaatɨ amɨ komɨ apotɨhɨrɨ amɨnaihɨrɨ apɨpaahɨ kɨhoepɨ taanahɨndaise. ");
INSERT INTO agm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ko Setaho sapɨhɨ noaipatɨ Autaahaatɨhomɨ watɨpɨhaiwa saasanotɨhaiwaisatɨ bitosɨhɨ tunnɨwɨ yahwɨnohiyɨhiya Jisaasihomɨ anɨmwaahɨpatɨ jaawɨ bitohohiyɨhiya koai usonɨwɨmapɨ apɨpaahɨ awaindɨhandɨ yaiwɨ itipɨ kwaapanɨmaasapɨ yapɨpataapɨhɨ tɨmahiyawɨ apɨpaahɨ isɨhiya napowaahiyaamatiyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aihɨ amɨ enjerɨho yamɨhapataatɨhapɨho apopɨpurisɨ saundataase. “Amɨ sainjaahɨhɨ wɨndɨ yamaimɨse. Nɨnɨ aimɨ jasohonɨ Jisaasiho ipɨ tɨtɨhɨ atawɨhatetɨ tipɨmandaapɨ tiwohɨhopɨ taamɨ daamaise. ");
INSERT INTO agm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kohɨ kɨmbɨhɨ wometɨse. Wometatɨ aimɨ jahɨra asohoematatɨ nepase sawaho jɨhɨ nepaito tatɨ katirɨhɨrɨ kɨreto. Koai ahiyauhɨ nanototimbɨpɨhɨ kɨmbɨhɨsɨ wometɨsɨ sainjaahɨ nammɨ baimɨ mmonɨmɨse. ");
INSERT INTO agm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mmonɨmapɨ nehɨ ketɨ nihɨti naimɨ komɨ otɨpɨpatɨhiyai saundɨmɨ kaundɨmɨse. ‘Jisaasiho aimɨ anɨmwaahɨpatombɨ asohoematatɨ jahɨra nepase. Nepasi samɨ jɨhɨ Garirihandaahapɨ mɨho naise. Sapɨhɨ sangi nasamaatɨ ahositandɨ naisɨ sahɨ koai usondaatɨwɨ naiwɨse,’ undɨmɨ kaundɨmɨse. Pɨwɨha kɨma sainjaasangi nɨnɨ akaaha akɨtɨnɨhɨ kasatataato. Kasatataatonɨ sainjaahɨ gwɨnyaapɨ ketɨ naimɨse,” undatɨ yamɨhapataatɨhapɨho apopɨpuri tarɨwundatɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aihɨ apopɨpurɨ kapɨhɨ anɨmwaahɨpatɨ tarɨwaimɨ namasi yayamaahandɨ amɨ kapuramɨ omaŋɨtɨtɨhɨ nga maaritɨmɨ Jisaasihomɨ otɨpɨpatɨhiyai Jisaasiho nepasɨtɨhandapɨ kaundɨtaatɨmɨ naupwasi niyamaise. ");
INSERT INTO agm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Taamɨ naupwasi naihɨ nɨwisaataatapɨ akohɨhɨ Jisaasiho noaipatɨ kapurisatɨ nutana iwinjatɨ saundataase. “Maimbure asisɨhaatɨhe,” undataase. Saundihɨ nammɨ tɨmahiyamɨ Jisaasihomɨ auhɨrɨ iwipɨ maaritɨmɨ koai mepɨ autaahepumamaise. ");
INSERT INTO agm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Sawihɨ kapuri Jisaasiho saundataase, “Sainjaahɨ wɨndɨ yamaimɨse. Yamaimɨ naimɨ nisɨ nɨhoaarɨsa nisɨ otɨpɨpatɨhiya Garirihanda nɨngi nisonda naitaanɨ kapɨhapɨ kiya naita sainjaahɨ kaundɨtaatɨmɨ naimɨse,” undatɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Apopɨpurɨ taamɨ daihɨra naihɨ tunnɨwɨ yahwɨnohiyɨhiya anɨmwaahɨpatetɨ jaawɨ bitohohiyɨhiyaamɨ usa aunahɨpata jahɨra naiwɨ kahapaamapɨpa noaipasɨpɨpaapɨ nahatewa ausaapɨ pɨrisihiya isɨhiyaapɨ nandapa maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai waamaindumapɨ nunyohiyɨhiyaamɨ mɨtɨhiyai kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Saiwaapɨ kaundauhɨ atiwosawɨ kiya Judaahiyaanamɨ mɨtɨhiya gwɨnyaahiyaisawɨ ahoyanɨwɨ pɨwɨha wa kanɨwɨ wɨsasawaayopo. Kanɨwɨ wɨsasawɨ satawaatopo. “Jisaasiho anɨmwaahɨpatombɨ asohoematatɨ jahɨra nepase,” nyatɨwɨ kanyatohɨtɨhandɨ nesi isɨhiyai tunnɨwɨ yahwɨnohiyɨhiya wɨndɨ ausaapɨ kamundɨto nɨwɨ nawɨho apɨpaahɨ awaisɨho ikihɨ awaihihɨ nunyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nawɨho awaisɨho nunyawɨ kiya tunnɨwɨ yahwɨnohiyɨhiyai saundawaatopo. “Jisaasiho jahɨra nepasɨtɨhandapɨ isɨhiya nasesaihɨ sahɨ satɨtaatɨwe, ‘Nyahɨ nanowaamahonɨhɨ komɨ otɨpɨpatɨhiya apatɨhɨ napɨwɨ komɨ ambɨpatɨ nehopo tɨtaatɨwe. ");
INSERT INTO agm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Amɨ gamanɨhomɨ kiyapɨho Pairotɨho sandapɨ atisataatɨ sangi sasatatɨ sandɨ sahɨ wɨndɨ namoaitɨhiyaatɨsɨ akɨtɨnɨhɨ nanomɨhauhɨ Jisaasihomɨ ambɨpatɨ komɨ otɨpɨpatɨhiya newaayowo?’ satatɨ nasɨsehonaahɨ nyahɨ daihɨra wɨra mmonaatɨ koai newaatɨ napaisaatumwaitaano. Napaisaatumwasaihɨ ko sangi wapa kamaasisonɨhɨ amɨ sahɨ samɨ ambɨpatapɨ awaindɨhandɨ yaiwɨ wɨndɨ mɨtaahɨ gɨmunyaitaatɨwo,” undɨwɨ atɨpatisawɨ nawɨho awaisɨho kiyai nunyawɨ kiyaamɨ maahomwaaŋɨ nepɨ nɨwisapuwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Iyauhɨ tunnɨwɨ yahwɨnohiyɨhiya namapɨ nawɨho nepɨ kiyai Judaahiyaanamɨ awaisawɨhiya satɨwɨ katɨwɨse undɨwɨ kaundohɨwaiwa kɨretɨ nesi isɨhiyai kaundawaatopo. Satɨwɨ Jisaasihomɨ ambɨpatɨ komɨ otɨpɨpatɨhiya nehopo tɨwɨ tunnɨwɨ yahwɨnohiyɨhiya pɨwɨha katohɨha Judaahiyaanamɨhatɨhɨ kaanɨhɨ daayatɨ nɨnɨ jɨpatɨpiyohurɨmura ahondaise. ");
INSERT INTO agm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aihɨ nyahɨ komɨ otɨpɨpatɨ mmonaatɨ newaatɨ kiyaatɨ nɨwipinjohiyɨhiyanɨnɨ 11 kiyaatɨ ikwɨmaindɨmwɨtihɨ auhɨramɨ naasohɨtahiyaanɨnɨ sisɨho woaasɨnɨ sapɨhɨ naiwɨse nyatatɨ Jisaasiho kanyatisɨhoaasɨnɨ yapɨpatɨ Garirihanda niyahaayo. ");
INSERT INTO agm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Niyaatɨ sapɨhɨ sisɨhoaasɨnɨ Jisaasihoai iwinjahaayo. Iwinjaatɨ maarɨho yatɨhitaatɨ waatɨ gwɨnyaawaatɨ yatɨhɨ tɨmahiyaatɨ koai nyahɨ mepɨ autaahewaumahaayo. Siyaatɨ mepɨ autaahewaumɨhaawɨ nyamɨ usa kiyaamɨ omaŋɨtɨtɨhɨ satɨwɨ, “Ese kɨmo akɨtɨnɨhɨ Jisaasiho asohoematatɨ anɨmwaahɨpatombɨ nepasɨhotindɨho e koai wotindɨho?” tɨwɨ kiyaamɨ maarɨho yɨyatɨwɨ gwɨnyaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aihɨ Jisaasiho nasatɨ detɨ nyamɨ otɨhaatɨ bitondaatɨ pɨwɨha wa sanyatataase. “Autaahaatɨho komɨ watɨpɨhandɨ nahandɨ kahapaamapɨpa yamɨhapataatɨhunɨ yapɨpataapɨhunɨ ahotimbɨpa isɨhiyai maawɨ jaatɨ bimɨtandɨ nɨngi aimɨ naninyataise. Nanɨmihɨ nahataapa nisɨ ikwɨraatɨhɨ ahotihɨ nɨnɨ iwinjatataayo. ");
INSERT INTO agm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Isɨ sangi nisɨ watɨpɨhanda andɨtisaiwɨtaanɨ Autaahaatɨhomɨ pɨwɨha nesi yapɨpatɨ nahatewaara gaamapɨ isɨhiya nahatiyenda sahɨ nuwɨse. Nuwɨ isɨhiyai numwaapɨ nepɨ ahoyawɨ nisapɨ sahɨ ausaapɨ kaundɨwɨ katɨwunjisaihɨ kiya nisapɨ gɨnunyaapɨ nɨngisɨ napɨwɨ nanipinjɨto. Aiwɨ Apɨhomunɨ amɨ nɨnɨ komɨ Mwaahonisunɨ amɨ Itɨpɨho Gaahomunɨ ambɨpatɨ watɨpɨhanda isɨhiya nisapɨ gɨnunyaahohiyɨhiyai baawusawɨse. ");
INSERT INTO agm_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aiwɨ nisɨ pɨwɨha nahatewa isɨhiyai katɨwunjawɨse satɨtɨ kandisasohɨwaiwa kiya baiwɨ atiwɨ gwɨnyaapɨ japepihɨrɨwɨ nɨngi napɨwɨ nanipinjɨtaatɨwɨ sahɨ baiwɨ kiyai katɨwunjawɨse. Siyawaawɨ kɨmandɨ baiwɨ gwɨnyaapɨse. Nɨnɨ sangi andɨtɨsitɨ sangisatɨ konɨnɨhɨ jinjapɨhɨ bitopɨ nundɨ ipotɨhura Autaahaatɨho nisɨhetapɨ isɨhiyai netɨ tipɨtapaahonɨhuraatɨtaise,” nyatatɨ nyahɨ komɨ otɨpɨpatɨhiyaanangi Jisaasiho kanyatataase. ");
INSERT INTO agm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kɨma Pɨwɨma Gaaha Wanɨha Autaahaatɨhomɨ Mwaaho Jisasɨ Kɨraisiho katatɨ kataunjatɨ kaiwaiwaapɨhaare. ");
INSERT INTO agm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Iyataatɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho Pɨropetɨho Aisaiyaaho sata katatɨ ahairɨhɨretɨ namasatɨ noaipataise: “Atime utaaho woaisɨ Nɨnɨ Nisɨ pɨwɨha nunyatɨ amɨ netɨ nandusaasɨto. Nandusaasisanɨhɨ pɨwɨha ausaatɨ daihɨra tɨtɨhehɨma daahuwɨtaise.” ");
INSERT INTO agm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Isɨhiya iwɨwɨrɨho owehapɨhɨ utaaho wo bindata isɨhiyai gaata numwaatɨ pɨwɨha ausaatɨ sata kaundɨtaise. ‘Awaisɨho napɨtandɨhɨra daihɨra tɨtɨhepumapɨ daawupɨse,’ undɨtaise,” tatɨ Autaahaatɨho Aisaiyaahomɨhetapɨ katatɨ ahaisɨhaare. ");
INSERT INTO agm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aihɨ ipotɨhura utaaho wo komɨ ambɨpatɨ Jonɨho isɨhiya iwɨwɨrɨho owehapɨhɨ noaipatɨ bindataise. Noaipatɨ bindata isɨhiyai gaata numwaatɨ pɨwɨha ausaatɨ kaundatɨ waapohora baawusataise. So Jono Autaahaatɨho Aisaiyaahomɨhetapɨ katisɨhore. Isɨ ko Jonɨho isɨhiyai pɨwɨha ausaatɨ sata kaundataase. “Samɨ maipɨhaiwa kiyohɨwaiwa namamapɨ sahɨ Autaahaatɨhomɨhiyaatimatɨtaatɨwɨ namɨhanɨwɨ waapoho nepɨse. Aiwɨ baiwɨ akɨtɨnɨhɨ nepemaitɨwɨ waapoho nesaihɨ amɨ Autaahaatɨho sahɨ maipɨhaiwa kiyohɨwaiwa nesamaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aihɨ sura isɨhiya yapɨpatɨ Judiyaahandamɨ aunahɨpɨhaiwa nahatewaaraahapɨhiyaunɨ amɨ Jerusaremɨhanda bimohiyɨhiya nahatiyaunɨ Jonɨhoaapɨhɨ komɨ pɨwɨha atitaatɨwɨ niyawaayopo. Naiwɨ Jonɨhomɨ pɨwɨha atisawaawɨ kiyaamɨ maipɨhaiwa ausaahauhɨ Jonɨho waapɨhaatɨ Jorɨtanɨhaata baawusataise. ");
INSERT INTO agm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jonɨho sura maasapɨho kamerɨhandamɨ atɨtatɨ nausohaatɨ niyohore. Iyatɨ tapaatɨpɨhounɨ apɨpaamɨ mwaahounɨ nanataise. Iyatɨ Jonɨho yamepatɨ autaahɨ komɨ bwandɨpataapɨhɨ wɨsasanahore. ");
INSERT INTO agm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Iyatɨ isɨhiyai pɨwɨha ausaatɨ satatɨ kaundataase. “Utaaho wo nɨngi nanɨtipɨhaatɨ apɨpaahɨ awaisɨho nisɨ ipotɨ napɨtaise. Iyataatɨ nɨnɨ awaisɨhonɨnɨndaahandɨ kandɨ ko nɨngi nanɨtipɨhaatɨ apɨpaahɨ awaisɨhore. Iyataatɨ nɨnɨ komɨ otɨpɨpatɨhonɨnɨndaahandɨ kandɨ otɨpɨpatɨhiyaamɨ kiyohɨpatɨ kaindɨ nambɨtɨtɨ komɨ asuipatɨ nausohaumaamaito. Amɨ nɨnɨhɨ nehɨ waapohora sangi baasusataayonɨ amɨ Jisaasihohɨ sangisɨ Autaahaatɨhomɨ Itɨpɨhora baasusonɨhɨ sahɨ noaipapɨ ko Autaahaatɨhomɨhiyaatimatɨtaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Aihɨ suraanɨhɨ Jisaasiho yapɨpatɨ Garirihandamɨ aunahɨpatɨ Nasaretɨhanda namasi nasatɨ Jonɨhoaapɨhɨ noaipasɨhɨ Jonɨho waapɨhaatɨ Jorɨtanɨhaata baawusataise. ");
INSERT INTO agm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Siyatɨ Jonɨho Jisaasihoai baawusihɨ Jisaasiho nehɨhaatɨ notataahetɨ jata yamɨhapatɨ tɨwatawamasɨhɨ jataise. Aihɨ Autaahaatɨhomɨ Itɨpɨho koho dɨpɨhomatiyatɨ autaahapɨ pɨrɨruti nasatɨ Jisaasihomɨhetɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aihɨ pɨwɨha wa yamɨhapataatɨhapɨ Autaahaatɨho Jisaasihoai saundataase. “Kɨnyɨ nisɨ Maasɨhɨhoŋɨtinɨhɨ maarɨho nahɨnyatɨ amɨ gi maarɨho wɨhiwataatɨ kinyapɨ nɨnɨ maaritataayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aihɨ sura ketɨnɨhɨ Autaahaatɨhomɨ Itɨpɨho Jisaasihoai numwaasi yapɨpatɨ isɨhiya iwɨwɨrɨho owehata notaise. ");
INSERT INTO agm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Siyatɨ notɨ isɨhiya iwɨwɨrɨho owehapɨhɨ bimihɨ waatɨho wo sanawihɨ wo nusaipataise. Siyatɨ asisɨha utaarɨhandetɨ bimihɨ Bwaasɨrɨhɨrɨ Jisaasiho Autaahaatɨhomɨ pɨwɨha nemaso amɨ napitaise tatɨ nunjenataise. Siyatɨ Jisaasiho kohasɨpɨhoaisataahɨhɨ bimihɨ Autaahaatɨhomɨ otɨpɨpatɨhiya yamɨhapataatɨhapɨhiya napɨwɨ koai andɨtɨwipɨ iwɨtatamanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jonɨho isɨhiyai waapohora baawusisɨho aimɨ napwinjɨhɨ Jisaasiho Garirihanda niyataise. Niyatɨ Autaahaatɨhomɨ pɨwɨha isɨhiyai iwɨtatamanɨtandɨha ausaatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ausaatɨ Isɨhiya usɨhiya asɨhiyai saundataase. “Autaahaatɨho isɨhiyai iwinjaatɨ bimindɨhandɨ ausaimanɨnatɨ waatɨ noaipaitandɨ wanɨ kɨmura akururandaatɨ aimɨ nasatɨ detɨndaise. Isɨ sahɨ maipɨhaiwa kiyohɨwaiwa namasi japɨhɨ nepemaitɨwɨ Autaahaatɨhomɨ pɨwɨha gaaha wanɨha baiwɨ gɨwunyaapɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisaasiho sata kaundamapɨ durɨhɨrɨ Garirihandainapɨ niyataise. Niyatɨ utaahurɨ wurɨ saingɨho saaho ikihɨ araiho kɨpwɨnɨhonɨhɨ noaitaatɨwɨhihɨ durɨhɨraatɨhɨ taamɨ tɨmasɨhɨ kuri usonataise. Saahomɨ ambɨpatɨ Saimonɨhore. O saingɨhomɨ ambɨpatɨ Endɨruhore. Kuramɨ otɨpɨpatɨ kaimɨ bimipatɨ araiho noaitaatɨwɨhatɨ kaimɨ bindamaahure. ");
INSERT INTO agm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Aihɨ Jisaasiho kuri saundataase. “Isɨhiya nisɨhiyaimatɨtaatɨwɨhiyai numwaitaatɨmɨhandapɨ nɨnɨ sahuraasangi kaindɨsasɨtaanɨ nɨngi nanipinjai namɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Uta kuri kaundihɨ ketɨ kuraanɨhɨ kurɨ atimɨ ikihɨ araiho nosihihɨ kapɨhɨ ahotihɨ namasi Jisaasihoai nuwipinjai niyamaise. ");
INSERT INTO agm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Aihɨ Jisaasiho wonjɨ niyatosatɨ jata Jemɨsihotihɨ saingɨho Jonɨhotihɨ kurɨ kopuhotɨ bindama taamɨ ikihɨ gwɨnɨmɨ tɨtɨhemasɨhɨ winjataise. Surɨ utaasurɨ Sepetihomɨ mwaahure. ");
INSERT INTO agm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aihɨ Jisaasiho kuri iwinjatosa gaatihɨ kurɨ kuramɨ sapɨhoaisunɨ otɨpɨpatɨhiyaisunɨ namasi Jisaasihoai nuwipinjai niyamaise. ");
INSERT INTO agm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisaasihotihɨ kingwaasɨtihɨ naiwɨ aunahɨpa wɨtɨ katamɨ ambɨpatɨ Kapaniyamɨhanda bimauhɨ asisɨha waiwa sanausotaise. Sanawihɨ Judaahiyaanamɨ Sapaatɨhandetɨ Jisaasiho aŋaaŋɨ pɨwɨhaapɨ (Autaahaatɨhopɨ gɨwunyaapɨ) isɨhiya ahoyanohaaŋaaŋɨ nandaatɨ isɨhiyai pɨwɨha ausaatɨ kataunjataise. ");
INSERT INTO agm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kataunjihɨ pɨwɨha atɨwisohiyɨhiya komɨ kataunjindɨhandapɨ waatɨ yaiwɨmawaapo. Isɨhiya amɨtɨha gaahaiwaisahiya Judaahiya sawanaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaamatiyatɨ kataunjataamaise. Owetise. Kohɨ Autaahaatɨhomɨ watɨpɨhandisahosɨ kandɨ watɨpɨhandaahɨ kataunjataise. ");
INSERT INTO agm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sura utaaho wo komɨhatɨhɨ itɨpɨho maipɨho bindata amɨ iwinjatihɨho sandɨ anɨndaatɨhɨ bindataise. Bindata sata gandaase. ");
INSERT INTO agm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasaretɨhandaahapɨ Jisaasihoŋe kɨnyɨ nehɨ Autaahaatɨho maaritimbɨpaahɨhɨ kaimbɨhoŋɨtihɨ nyahɨ aimɨ gisonaahiyaane. Isɨ kɨnyɨ nyangi nanyopɨsasɨtaapɨ napaapɨ napise? Nehɨ nyainjase?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Saundauhɨ Jisaasiho itɨpɨho maipɨhapai waapɨhɨta saundataase. “Sahɨ utaamoai namasi kaahaamaatɨwɨ nehɨ bɨpi noaipasi nuwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sata kaundihɨ itɨpɨho maipɨhapa utaahoai nepɨ waatɨ ahowiwɨ kɨsɨhɨsiwɨ waatɨ kaahaatɨmɨ noaipasi nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Itɨpɨho maipɨhapa Jisaasihomɨ pɨwɨha atɨwiwɨ bɨpi noaipasi niyauhɨ isɨhiya sandɨ mmonawa nahatiya yaiwɨmapɨ maarɨho owesuetihɨ sawana sanawaatopo. “Kɨmandɨ wanɨ napindɨ noaipasɨtɨho? Kɨmomɨ kanyatindɨmandɨ wanɨhandɨ wipetahandɨ watɨpɨhande. Iyatɨ amɨ itɨpɨho maipɨhapai waapɨhɨta kaundihɨ bɨpi atɨwiwɨ utaahomɨhetapɨ noaipasi nowaayopo,” tɨwɨ kanawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Siyatɨ Jisaasiho kaindɨhandapɨ pɨwɨha yapɨpatɨ Garirihandamɨ aunahɨpa nahatewaara nesi kanɨwɨ gaamawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Siyatɨ Jisaasiho itɨpɨho maipɨhapai nemwasɨhɨ amɨ kandɨ aŋɨndɨ namasi noaipasi tɨtɨhɨ Saimoniyɨ Endɨruyaamɨ aŋaaŋɨ nandaawaayopo. Aihɨ amɨ Jemɨsiyɨ Joniyaisangi maasɨ nomaise. ");
INSERT INTO agm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sura Saimonɨhomɨ sanohaamaatɨ sisɨha nusoaipatɨ yaawihɨ nanototihɨhuraasɨ kaatapɨ ketɨ apaipɨ Jisaasihoai kaundawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kaundauhɨ Jisaasiho kaatɨ nanototimbɨpɨhɨ niya ikwɨrɨ iwiwatɨ tɨtɨhɨwisɨhɨ kaati sisɨha nusoaipasɨtɨhandɨ busoaatɨ owesuendaise. Aihɨ kaatɨ Saimonɨhomɨ sanohaamaatɨ kiyaapɨ nandapa turɨhatɨ turɨmanataise. ");
INSERT INTO agm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aihɨ kura asahataahura ipɨho aimɨ namaatipatɨ asisɨha napandosɨhɨ isɨhiya timbɨpaisahiyaisunɨ amɨ isɨhiya itɨpɨho maipɨhapa netɨ daahɨ ipɨhatisa bimisawɨhiyaisunɨ numwaasi Jisaasihoaapɨhɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aunahɨpa sataahapɨhiya nahatiya aŋaaŋamɨ maasometetɨ masapɨpɨhɨ ahoyanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Isɨhiya timbɨpa kahapa kahapaisawɨhiyai nemwa tɨtɨhɨwiwa itɨpɨho maipɨhapai netɨ natausaasataise. Iyataatɨ itɨpɨho maipɨhapa Jisaasihopɨ Autaahaatɨhomɨ Mwaahoso tɨwɨ usonɨwɨ gwɨnyaahauhɨ Jisaasiho, “itɨpɨhoŋɨ maipɨhoŋɨ kaahaamaatɨme,” undatɨ maahomwaaŋɨ netɨ nuwisapuwataise. ");
INSERT INTO agm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Asisɨhaatɨhɨ bowɨtandɨ asisepasɨhɨ Jisaasiho nanosɨpɨpɨhɨ namasi niyatɨ isɨhiya oweta watɨminɨhapɨhɨ Autaahaatɨhoai pɨwaundatɨ gaapundataase. ");
INSERT INTO agm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Siyatɨ gaapundatɨ bimihɨ Saimonɨhounɨ komɨ naisɨhiyaunɨ Jisaasihopɨ daapɨ naiwɨ Jisaasihoai usonawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Usonɨwɨ Jisaasihoai saundawaatopo, “Isɨhiya nahatiya kinyapɨ maahapɨhe?” tɨwɨ daawaayopo undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Undauhɨ Jisaasihomɨha pɨwɨha wihoaaŋɨha kiyai saundataase. “Nɨnɨ pɨwɨha ausaitandɨ napɨtɨhonɨnisɨ amɨ aunahɨpɨhaiwa detɨ ahetiwaiwaaraahapɨ nutɨhaawo nɨnɨ pɨwɨha ausaatɨ isɨhiyai kaundɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sata Jisaasiho kaundamapaahɨ yapɨpatɨ Garirihandamɨ aunahɨpɨ nahatewaara gaamatɨ daayatɨ kiyaamɨ aŋɨhaiwa kaiwaapɨhɨ pɨwɨhaapɨ ahoyanohɨpɨpɨhɨ Autaahaatɨhomɨ pɨwɨha ausaatɨ kaundataase. Ausaatɨ kaundatɨ isɨhiyaamɨhetɨ itɨpɨho maipɨhapa bimimbɨpai netɨ tahamanausoaasatɨ nemwataise. ");
INSERT INTO agm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Utaaho wo asaaha pisapɨpaisaho nasatɨ Jisaasihomɨ utatototɨ atotɨpɨwesatɨ bindataatɨ Jisaasihoai sata nunjenataise. “Kɨnyɨ nisɨ asaaha pisapɨmba nepɨnɨmaitaapaahɨ kinyɨhandisɨ nepɨnɨmape?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Siyatɨ nunjesɨhɨ Jisaasiho kopɨ maarɨho asɨpɨwihɨ namatɨ ikwɨrɨ komɨhetɨ ahɨwisataatɨ saundataase. “Kinyɨ asaaha pisapɨmba nehɨmaitandɨ gaare. Isɨ kɨnyɨ noaipapɨ yaumbwimanɨnɨpɨ gaahoŋimate,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jisaasiho sata kaundihɨ ketɨ kuraanɨhɨ komɨ asaaha pisapɨpa owetihɨ noaipatɨ gaahondaise. ");
INSERT INTO agm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Aihɨ Jisaasiho koai pɨwɨha watɨpɨha sata kaunda natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kɨnyɨ baimbɨ atime. Isɨhiya usaisɨ kinyɨ asaaha pisapɨpa nehɨmahohɨtɨhandapɨ aho nenɨmasɨhe tɨpɨ usaisɨ apɨpaahɨ wɨndɨ kamundɨme. Nehɨ tɨtɨhɨ koŋɨnɨhɨ numbwɨ utaaho pɨrisiho isɨhiyaamɨ maipɨhaiwaapɨ Autaahaatɨhoai dɨpumanɨtandɨ nandapa tɨhisɨhoaapɨhɨ noaipape. Koaapɨhɨ noaipapɨ kinyɨ ambɨpatɨ nunjapɨ nandapa wapa nunye. Nunyamɨhɨ Autaahaatɨhoai dɨpumanɨtandɨ ko tahane Mosesiho katatɨ ahaisɨhetɨ japepihɨrato. Saimbɨ kaisamɨhɨ isɨhiya gi gisonawa komɨ pisapɨpa aimɨ owesuendaise tɨwɨ gisondaatɨwo,” undatɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sata Jisaasiho kaundihɨhandɨ kandɨ kohɨ notɨ isɨhiya nahatiyai ausaatɨ nahataapɨpɨhɨ kaundatɨ gaamataise. Aihɨ Jisaasiho sandapɨ namatɨ aunahɨpɨhaiwaara isɨhiyaamɨ ndɨhetɨ namoaipase. Owe. Nehɨhapɨhɨ isɨhiya owehapɨhɨ bimihɨ isɨhiyaahɨhɨ mɨhopɨ mɨhinapɨhiya koaapɨhɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Asisɨha aimɨ waiwa sanaihɨ Jisaasiho japɨhɨ Kapaniyamɨhandaahapɨ nasataise. Japɨhɨ napihɨ isɨhiya Jisaasihopɨ aimɨ japɨhɨ nasataise tɨwɨ kanɨwɨ gaamatawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Saiwɨ Jisaasiho aimɨ yamore tɨwɨ atisawaawɨ isɨhiya taahiyɨhiya napɨwɨ ahoyanawaayopo. Isɨhiya aŋaaŋamɨ detɨ maasomwaaŋɨsangi tisaitɨwɨ sɨsipa yondaise isɨhiya nandaitɨhɨra daihɨra apɨpaahɨ owetato. Aihɨ Jisaasiho Autaahaatɨhomɨ pɨwɨha kiyai ausaatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Aihɨ isɨhiya murɨmurɨ utaaho wo komɨ ikwauhɨrɨ namɨhata bɨwatehoai gwɨtɨhotɨ ahiyawɨ tɨpwinji Jisaasihoaapɨhɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tɨpwinji napɨwɨ Jisaasihoaapɨhɨ nandaito tɨwɨ mmonawa isɨhiya tisaitataatɨ nandaitɨhɨra daihɨra apɨpaahɨ owetihɨ namapɨ aŋɨhandamɨ aŋɨtaupwataatɨhɨ koai nesi yamwaawaayopo. Nesi yamwaapɨ mɨhasɨnɨ aŋɨtaupwataatɨhɨ bitotawa tɨtɨhɨ Jisaasiho bitosɨsɨsɨnɨ aŋɨtaupwa nawatawaayopo. Nawataposawɨ utaaho gwɨtɨhotɨ kiyatɨ nanototihɨ wɨrɨhɨretɨ mɨhatɨhɨ Jisaasiho bitosɨpɨpɨhɨ nusoaasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Isɨhiya siya Jisaasihopɨ utaaho watɨpɨhosɨ nga utaamo kɨmoai tɨtɨhemwaitaise tɨwɨ gɨwunyaahohɨtɨhandɨ Jisaasiho usonataise. Usonataatɨ utaaho ikwauhɨrɨ namɨhatisɨhoai Jisaasiho saundataase. “Nisɨ maasɨho kinyɨ maipɨhaiwa nahatewa nɨnɨ aimɨ nehɨmataayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sata Jisaasiho kaundihɨ isɨhiya usa Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiya sa pɨwa atisawaawɨ kiyaamɨ maarɨhoaatɨhapɨ saiwɨ gwɨnyaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kɨmo satindɨmandɨ, ‘Maasɨho kinyɨ maipɨhandɨ nɨnɨ aimɨ nehɨmataayo,’ tindɨmandɨ napaapɨse? Autaahaatɨhohɨhɨ nga maipɨhaiwa nemwaitaise. Isɨ kɨmo utaamo nɨnɨ Autaahaatɨhonɨniso tatɨ Autaahaatɨhopɨ sisɨpɨhɨndaase,” tɨwɨ kiyaamɨ maarɨhoaatɨhɨ omaŋɨtɨtɨhapɨ gwɨnyapenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Saiwɨ kiya mɨmaipaiwɨ gwɨnyapenɨhauhɨ Jisaasiho ketɨ usonataise. Usonatosa kiyai saundataase. “Sahɨ samɨ omaŋɨtɨtɨhapɨ napaapɨ saiwɨ gwɨnyapenɨhopo? ");
INSERT INTO agm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Pɨwaamairɨ kɨmairamɨ maahɨwa nga napaisɨhaatɨtaise? Nɨnɨ utaahoai saundɨtɨ, ‘Kinyɨ maipɨhaiwa nehɨmataayo,’ undɨtandɨhaaro e ‘Kinyɨ yutɨhɨrɨ gwaumbwɨ nanopotingɨrɨhɨrɨ dopɨ nawopɨ isɨsi numwe,’ undɨtandɨhaaro? ");
INSERT INTO agm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Isɨhiya Autaahaatɨhomɨhiyaimatɨtaatɨwɨhiyaamɨ saaho Awaisɨho jɨho isɨhiya nahatiyaamɨ maipɨhaiwa nemaitandɨhoe tɨwɨ mmonɨwɨ gwɨnyaitaatɨwɨ nɨnɨ nasɨsɨtaanɨ jasawise,” undataase. Saundatosatɨ Jisaasiho ikwauhɨrɨ bɨwatetɨ namɨhatisɨhoai saundataase. ");
INSERT INTO agm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nɨnɨ gisɨ kinyɨ yutɨhɨrɨ gwaumbwɨ nanopotingɨpɨpa dopɨ bitotapa nawopɨ isɨsi numwe hɨtataato,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aihɨ isɨhiya ikwauhɨrɨ bɨwatetɨ namɨhatisɨhoai baiwɨ iwinjasauhɨ ko dotɨ nga itɨpɨwatɨ bitonda komɨ yutɨhɨrɨ nawotɨ isɨsi kiyaamɨ ndɨhetɨ aimɨ ketɨ naihɨ usonawaayopo. Aihɨ isɨhiya sandɨ mmonawaawɨ aungwohandɨ waatɨ yaiwɨmawaayopo. Yaiwɨmapɨ Autaahaatɨhomɨ ambɨpatɨ mepɨ autaahepumwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisaasiho jɨhara durɨhɨrɨ Garirihandainɨ taatɨ naihɨ isɨhiya taahiyɨhiya iwinjaposawɨ napɨwɨ Jisaasihoaapɨhɨ ahoyanɨhauhɨ Jisaasiho Autaahaatɨhomɨ pɨwɨha kataunjataise. ");
INSERT INTO agm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Siyatɨ pɨwɨha kataunjamapɨ notɨ aŋɨ wɨndaapɨhɨ mmonata utaaho wo komɨ ambɨpatɨ Ripaiho Arɨpiyaasihomɨ mwaaho bimihɨ usonataise. So Ripaiso Romɨhanda Gamanɨhomɨ otɨpɨpatɨ kaitandɨho nawɨho taakisihandɨ nesɨhore. Isɨ koai Jisaasiho saundataase, “Kɨnyɨ dosisɨ nɨngi nanipinje,” undataase. Undihɨ Ripaiho Jisaasihomɨ pɨwɨha atɨwisatɨ ketɨ dosi Jisaasihoai nuwipinjataise. ");
INSERT INTO agm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aihɨ Jisaasiho Ripaihomɨ aŋaaŋɨ nandaatɨ maasɨ Ripaihoaisatɨ nandapa nanataise. Romɨhanda Gamanɨhomɨ otɨpɨpatɨ kaitandɨho nawɨho nehohiyɨhiyaatihɨ amɨ isɨhiya maipɨhatɨma isɨhiya usonɨwɨ namahohɨtɨmatɨmaatihɨ Jisaasihoai nuwipinjai taahiyɨhiya niyohiyɨhiyaatihɨ Jisaasihotihɨ amɨ komɨ otɨpɨpatɨhiyaatihɨ bindawa nandapa nanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Saiwɨ Jisaasihoaisawɨ maasɨ nandapa taawɨ nanɨhauhɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiya Parisihiya usonawaayopo. Usonawa Jisaasihomɨ otɨpɨpatɨhiyai saundawaatopo. “Kɨmo Jisaasimo isɨhiya maipɨhiya gamanɨhomɨ otɨpɨpatɨ kaitandɨho nawɨho nehohiyɨhiyaunɨ amɨ isɨhiya maipɨhatɨma isɨhiya mmonɨwɨmahohɨtɨmatɨmaisa nandapa napaapɨ nainje?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aihɨ Jisaasiho pɨwɨha sa atisataatɨ namatɨ wihoaaŋɨha sata kaundataase. “Isɨhiya timbɨpa owehiya ainahiyɨhiya dokɨtaahoaapɨhɨ nowaamaayopo. Iyataatɨ isɨhiya satɨwɨ, ‘Nyahɨ maipɨhaiwa kamaayaatɨ gaahiyaanɨne,’ tɨwɨ genanɨhohiyɨhiyai japɨhɨ gandɨ numwaitandɨ napɨtɨhonɨnɨmaahe. Sɨkatɨma maipɨhatɨma isɨhiya mɨmaipaiwɨ usonɨmahohɨtɨmatɨmaamɨ maipɨhaiwa nemwatɨ japɨhɨ gandɨ numwaitandɨ napɨtɨhonɨne,” undatɨ Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aihɨ asisɨha waara Jonɨho Isɨhiyai Baawusisɨhoai nuwipinjawɨ ko kaiwaiwa mmonɨwɨ nepɨ kaiwɨ nuwipinjohiyɨhiyaatihɨ amɨ isɨhiya Parisihiyaatihɨ Autaahaatɨhopɨ gaapundɨtaatɨwɨ nandapa onaayawaayopo. Aihɨ isɨhiya usa Jisaasihoaapɨhɨ naiwɨ noaipapɨ koai satɨwɨ nunjenawaayopo. “Isɨhiya Jonɨhomɨ otɨpɨpatɨ mmonɨwɨ nepɨ kaiwɨ koai nuwipinjohiyɨhiyaatihɨ amɨ Parisihiyaamɨ otɨpɨpatɨ mmonɨwɨ nepɨ kaiwɨ nuwipinjohiyɨhiyaatihɨ Autaahaatɨhopɨ gaapundɨtaatɨwɨ nandapa onaayawaayopo. Onaayauhɨhandɨ kandɨ amɨ gi nangipinjawɨ kinyɨ otɨpɨpatɨ mmonɨwɨ nehohiyɨmiya napaapɨ onaamaayopo?” undɨwɨ Jisaasihoai nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aihɨ Jisaasiho kiyai wihoaaŋɨha pɨwɨha sata kaundataase. “Utaaho apopaati netɨ wɨraitandɨ tɨmetisɨho komɨhiyaisatɨ maasɨ bimonɨhɨ komɨhiya nandapa wɨndɨ onaamaitaapo. Owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amɨ ko apopaati netɨ wɨraitandɨ tɨmetisɨhoai isɨhiya numwaasi naisaihɨ amɨ ko komɨ naisɨhiyaisatɨ wɨndɨ bɨmimonɨhɨ sura komɨ naisɨhiya nandapa onaitaapo. ");
INSERT INTO agm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Utaaho wo yutɨhɨrɨ napwɨrɨnɨhonɨhura gwɨndandɨ asɨrɨhɨrɨ ahiyatɨ namɨhawatɨ wɨndɨ gɨmwɨndaise. O siyatɨ jahɨrɨhɨrisatɨ namɨhawatɨ gwɨnɨhonaahɨ asɨrɨhɨrɨ watɨpɨndaatɨ jahɨrɨhɨrɨ jɨhɨ napwɨrinjonyonji nusatipɨhaatɨ waahɨwatɨ awaindɨ napwɨrɨndaise. ");
INSERT INTO agm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Utaaho wo waapoho niwɨtandɨhura wipatɨ pusa napuwahata waapoho asoho niwataamaise. Owetise. O amɨ wipatɨ siyatɨ pusa aimɨ napuwahatɨ maipɨhata nihonaahɨ wɨndɨ biyatɨ jɨmaitaise. O utaaho wo wipatɨ asɨpata waapoho asoho niwataataahɨ wɨndɨ aŋumaawatɨ biyatɨ jɨpiyonɨhɨ nga maarɨho witatɨ nandaise,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Asisɨha wa Sapaatɨhandetɨ Jisaasihotihɨ komɨ otɨpɨpatɨhiyaatihɨ osaataatɨ maasɨ daiwɨ bitopɨ nowaawɨ komɨ otɨpɨpatɨhiya nandapa wapa witɨhandɨ kɨpowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Saiwɨ kɨpwauhɨ isɨhiya Parisihiya usonawa Jisaasihoai saundawaatopo. “Kɨma asisɨha ikɨndɨhaaha Sapaatɨhandetɨ kɨmiya isɨmiya gi nangipinjawɨ kɨnyɨ kaingɨwaiwa mmonɨwɨ nehohiyɨmiya nyamɨ wɨnɨhapɨpa Sapaatɨhandetɨ otɨpɨpatɨ isɨhiya wɨndɨ kamaiwɨse timbɨpa nepɨ nopɨsasɨwɨ nandapa napaapɨ kɨpwopo?” undɨwɨ Jisaasihoai kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Aihɨ Jisaasiho wihoaaŋɨha kiyai sata kaundataase. “Jɨhura Daawitɨho nandapa nandandɨhapa owetihɨ komɨhiyaisa jaumasɨhɨ kaindɨhandapɨ sahɨ pɨwɨha awɨtɨwɨ mmonɨwɨ gwɨnyaapɨhiyaato? ");
INSERT INTO agm_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Siyatɨ Daawitɨhounɨ komɨhiyaunɨ jɨhura jaumasɨhɨ niyatɨ Abaiyataahoai bɨretɨhandɨ nepo undihɨ amɨ Abaiyataaho nandaatɨ nandapa bɨretɨhandɨ Autaahaatɨhomɨ ndɨhetɨ ahotɨtandɨ ahiyohɨtɨhandɨ netɨ numwihɨ ko nanataise. Sura pɨrisiho Abaiyataaho bimihɨhuraare. Sapa nandapa bɨretɨhandɨ isɨhiya nehɨhiya nepɨ nandaatɨwɨhapaamaahe. Owe. Nehɨ Pɨrisihiyaahɨhɨ nandaatɨwɨhapaare. Saitaatɨwɨhapaatihɨhandɨ kandɨ Daawitɨho netɨ nanatɨ amɨ komɨ isɨhiya koaisawɨtohohiyɨhiyai numwihɨ nanɨhopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Saundatosatɨ amɨ wa saundataase. “Asisɨha Sapaatɨhandi isɨhiya nepɨ itatamanɨtaatɨwɨ Autaahaatɨho kiyatɨ ahiyataamaise. Owetise. Asisɨha Sapaatɨhandɨ isɨhiyai netɨ iwɨtatamanɨtandɨ Autaahaatɨho kiyatɨ ahiyataise. ");
INSERT INTO agm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Isɨ Nɨnɨ Autaahaatɨhomɨ Isɨhiyaamɨ Saahonɨnɨ Awaisɨhonɨnɨ Jɨhonɨnɨ asisɨha sa Sapaatɨhandɨ kaindɨ ahiyohɨhonɨnisɨ amɨ nɨnɨ nɨwahonɨnɨ asisɨha sa Sapaatɨhandamɨ awaisɨhonɨne,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Aihɨ Jisaasiho japɨhɨ aŋaaŋɨ pɨwɨhaapɨ isɨhiya ahoyanɨwɨ amɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundohɨpɨpɨhapɨ niyataise. Niyatɨ nandaatɨ mmonata utaaho wo komɨ ikwɨrɨ namɨhatatɨ bɨwateho sapɨhɨ bimihɨ usonataise. ");
INSERT INTO agm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aihɨ isɨhiya usa Jisaasihoai iwinjatawaayopo amɨ uta ikwɨ bɨwatesoai Jisaasiho asisɨha Sapaatɨhandetɨ tɨtɨhemwaso tɨwo. Amɨ Jisaasiho koai tɨtɨhemwahonaahɨ kɨnyɨ sandɨ asisɨha ikɨnaatɨ Autaahaatɨhopɨ gɨwunyaitɨhaaha Sapaatɨhandɨ nepɨ nopɨsasɨpɨ kiyapaise undɨwɨ kaundɨto tɨwo. ");
INSERT INTO agm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aihɨ Jisaasiho ikwɨrɨ namɨhatatɨ bɨwatesɨhoai saundataase. “Kɨnyɨ dopɨ kɨmbɨhɨ isɨhiyaamɨ ndɨhetɨ nambɨ bitose,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Saundatosa isɨhiya nahatiyai ko sata nunjenataise. “Asisɨha Sapaatɨhandetɨ gaahatɨ kaitɨhaawo e maipɨhatɨ kaitɨhaawo? Isɨhiya yaawatɨ naaŋɨhaiwa nehohiyɨhiya itatamanɨnɨwɨ nga bimɨtaatɨwɨ nyahɨ kiyai iwɨtatamanɨtɨhaawo e daahɨ yaawɨhaiwa nunyaatɨ siyɨhiyai tiwaamaitɨhaawo?” undataase. Aihɨ kiya wihoaaŋɨha wa kamundɨwɨ kaundɨtɨha owetihɨ nehɨ jatawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Aihɨ Jisaasiho nahatiyai iwinjataatɨ apousataise. Apowindɨmandɨ kiya Sapaatɨhandapɨ waatɨ gwɨnyaawaawɨ utaahopɨ wɨndɨ maarɨho asɨpɨmaawisauhɨ usonataate. Aihɨ Jisaasiho ikwɨrɨ bɨwatetɨ namɨhatatɨ maipɨtisɨhoai saundataase. “Kɨnyɨ kinyɨ ikwɨrɨ tɨtɨhipɨ mbape,” undataase. Undihɨ ko atisatɨ komɨ ikwɨrɨ tɨtɨhiwatɨ mbasɨhɨ ketɨ kuraanɨhɨ noaipatɨ gaatatɨ sawanyɨnjapɨhɨrɨndaise. ");
INSERT INTO agm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Siyatɨ Jisaasiho kaihɨ isɨhiya Parisihiya usonɨwɨmapɨ nuwɨ ketɨ awaisɨho Erotɨhomɨhiyaisawɨ Jisaasihoai tiwɨtaatɨwɨhandapɨ pɨwɨha kanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Aihɨ Jisaasihotihɨ komɨ otɨpɨpatɨhiya komɨ otɨpɨpatɨ mmonɨwɨ nepɨ kaiwɨ nɨwipinjohiyɨhiyaatihɨ durɨhɨrɨ Garirihandainapɨ kapɨhɨ namasi nowaayopo. Niyauhɨ amɨ isɨhiya taahiyɨhiya wɨrɨsandɨhandɨ Garirihandaahapɨhiya Jisaasihoai nɨwipinjai nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Isɨhiya Jisaasiho kaiwaiwaapɨ pɨwɨha atiwɨ newaawɨ yapɨpatɨ Judiyaahandaahapɨhiyaatihɨ amɨ aunahɨpatɨ awaipatɨ Jerusaremɨhandaahapɨhiyaatihɨ amɨ yapɨpatɨ Itumeyaahandaahapɨhiyaatihɨ amɨ yapɨhaiwa waapɨhaatɨ Jorɨtaanɨhaataihoaaŋɨ ahetiwaiwaaraahapɨhiyaatihɨ amɨ yapɨpatɨ Taiyaahandaahapɨhiyaatihɨ amɨ yapɨpatɨ Saitonɨhandaahapɨhiyaatihɨ taahiyɨhiya wɨrɨsandɨhandɨ Jisaasihoaapɨhɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nasauhɨ Jisaasiho usonata isɨhiya taahiyɨhiya wɨrɨsandɨhandɨ ahoyanɨhauhɨ namatɨ komɨ otɨpɨpatɨhiyai saundataase. “Isɨhiya taahiyɨhiya waatɨ ahoyanawaayowɨ nisɨhinɨ waatɨ nasawaawɨ nepɨ nɨhipɨ nɨhawɨtaawɨ kopuhotɨ yandɨhɨ durɨhɨraatɨhɨ bindata pɨwɨha ausaatɨ kaundɨtaanɨ kopuho wo nepɨ nɨmanɨwɨse amɨ isɨhiya nɨngi wɨndɨ nepɨ nɨhipɨ maanɨhiwɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jɨhɨ isɨhiya usai kiyaamɨ timbɨpa nemwatɨ tɨtɨhemwasɨhɨ usopɨhiyaasɨ kandapɨ amɨ usa timbɨpaisahiya koai numwɨhatɨwɨ uwiwɨtaatɨwɨ komɨhinɨ detɨ detɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aihɨ itɨpɨho maipɨhapaisawɨhiyaisangi nuwɨ detɨ Jisaasihomɨhinɨ tɨmahiyawɨ ahosauhɨ itɨpɨho maipɨho isɨhiyai timbɨpa nunya bimisɨho kiyaamɨhetapɨ waatɨ kaahaata Jisaasihoai saundataase. “Kɨnyɨ Autaahaatɨhomɨ Mwaahoŋe,” undatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sata itɨpɨho maipɨho kaundihɨ Jisaasiho itɨpɨho maipɨhapai, saundataase. “Itɨpɨhoŋɨ maipɨhapaaraŋɨ nisɨ ambɨpatɨ isɨhiya nahatiyaamɨ ndɨhetɨ ausaapɨ kamaatɨme,” undatɨ watɨpɨtatɨ nɨwisapuwatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisaasiho niyatɨ nasaamana sisɨhoaasɨnɨ bindata komɨ gwɨnyaatɨ maaritatɨ numwaasawɨhiyaapɨ gandaase. Gaatihɨ kiya nuwɨ Koai winjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jisaasiho isɨhiya koaisawɨ maasɨtɨtaatɨwunɨ amɨ Autaahaatɨhomɨ pɨwɨha awusaitaatɨwɨ gaata numwaasawɨhiya 12 kaiwɨ ikwɨmaindɨmwɨtihɨ auhɨramɨ yahurɨtahiyaare. Isɨ kiyai Jisaasiho ambɨpatɨ wɨtɨ asɨpatɨ satatɨ, “aposerɨhiyaate,” unda ambɨhundataase. ");
INSERT INTO agm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Amɨ ko kiyai itɨpɨho maipɨhapa isɨhiyaamɨhetapɨ nemaitaatɨwɨ watɨpɨhandɨ numwɨtandɨ gaatatɨ numwaataise. ");
INSERT INTO agm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iyataatɨ Jisaasiho komɨ otɨpɨpatɨhiya ikwɨrɨ maindɨmwɨtihɨ amɨ auhɨramɨ yahurɨtahiya 12 kaiwɨhiyai namɨhainjawɨhiyaamɨ ambɨpatɨ kɨmate: Wo Saimonɨhoe. Amɨ koai Jisaasiho ambɨpatɨ wɨtɨ Pita unda nusoaasataise. ");
INSERT INTO agm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Aihɨ amɨ wurɨ Jemɨsiyɨ Joniye. Surɨ Sepetihomɨ mwaahure. Amɨ kuri Jisaasiho ambɨpatɨ wɨtɨ Boaanesesihuraahe undatɨ ambɨhundataase. Satɨ ambitamɨ tanyaaha “asoaahaamataimɨhuraahe,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Aihɨ amɨ usa kɨmiyaare: Endɨruho Piripɨho Batɨromiyuho Matiyuho Tomaasiho Arɨpiyaasihomɨ mwaaho Jemɨsiho Taatiyaasiho Saimonɨho isɨhiya Jerotɨhiyaamɨhotihɨ, ");
INSERT INTO agm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","amɨ Judaasiho aunahɨpatɨ Kariyotɨhandaahapɨhotihɨ siyaare. Judaasiho so Jisaasihoai ipotɨhura komɨ tiworisaamɨ ikwɨraatɨmasɨhore. ");
INSERT INTO agm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Aihɨ Jisaasiho kaundatɨ kiyamapɨ aŋaaŋɨ nandaasɨhɨ amɨ isɨhiya taahiyɨhiya waatɨ ahoyanɨhauhɨ Jisaasihounɨ komɨ otɨpɨpatɨhiyaunɨ nandapa nandaatɨwɨhandɨ owe. ");
INSERT INTO agm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aihɨ Jisaasihopɨ isɨhiya satɨwɨ, “Ko nandapa wɨndɨ nandandɨhandɨ owetauhɨ,” amɨ komɨ saingoya sanaapwɨsa amɨ sanaatɨ atisawaayopo. Saiwɨ atisawaawɨ, “Ko naharisataise,” tɨwɨ gwɨnyaapɨ koai numwaitaatɨwɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aihɨ isɨhiya Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiya Jerusaremɨhandaahapɨ napɨwɨ Jisaasihopɨ satawaatopo. “Kɨmo utaamo Berɨsepurɨho Bwaasɨrɨhɨrisahore. Iyatɨ Berɨsepurɨho itɨpɨho maipɨhapaamɨ mɨtɨhomɨ watɨpɨhanda Jisaasiho itɨpɨho maipɨhapai nemataise,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Satauhɨ amɨ Jisaasiho isɨhiyai numwaatɨ netɨ ahoyatɨ pɨwɨha netɨ sɨwipatɨ sɨtorihandɨ nepemaahɨwatɨ kataunjataise. Iyatɨ saundataase, “Bwaasɨrɨhɨrɨ amɨ Bwaasɨrɨhɨri napitiyatɨ nemaitaise? ");
INSERT INTO agm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Iyataatɨ amɨ isɨhiya yapɨpatɨ naasaipitaahapɨhiya tunnawaawaahɨ baiwɨ wɨndɨ bɨmimɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Iyataatɨ amɨ wusasɨ nususasɨ sawusasɨ tunnawaawaahɨ tunnɨwɨ natapaatɨwɨ wɨndɨ nga bɨmimɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Iyataatɨ Bwaasɨrɨhɨrɨ wihɨwihoaaŋɨ natapaatatesi sawandɨrɨ tunnataataahɨ wɨndɨ andɨtɨmitɨtaise. Andɨtɨmitatɨ netɨ nopɨsasɨnatɨ owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Iyataatɨ utaaho wo watɨpɨhomɨ aŋaaŋɨ amɨ utaaho wo topɨtaata nandaatɨ ikɨpɨpa ikona namaitaise. Owetɨtaise. Nehɨ jɨhɨ aŋaaŋamɨ satɨhoai anɨtisa wɨrɨhɨra wɨsasatɨ ahiyatosataahɨ nga komɨhapa ikona naitaise. ");
INSERT INTO agm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nɨnɨ kɨmandɨ akɨtɨnɨhɨ sangi kasatɨtaano maipɨhaiwa nahatewa isɨhiya katɨwɨ kiyohɨwaiwa Autaahaatɨho nga nemwaitaise. ");
INSERT INTO agm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","O amɨ isɨhiya Autaahaatɨhomɨ Itɨpɨho Gaahopɨ maipɨhaiwa katɨwɨ sisɨpɨtawaawaahɨ sandɨ kiya sisɨpɨtotɨhandɨ Autaahaatɨho wɨndɨ nemaamahonɨhɨ kandɨnɨhɨ ahotɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisaasiho sata kaundindɨmandɨ isɨhiya usa kopɨ itɨpɨho maipɨhoaisahore tauhɨ kandapunje. ");
INSERT INTO agm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Aihɨ Jisaasihomɨ sanaatunɨ amɨ saingoya sanaapwɨsaunɨ napɨwɨ ipaahaapɨ bitotawa Jisaasihopɨ noaipasi nasane tɨwɨ pɨwɨha nusoaasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iyauhɨ isɨhiya taahiyɨhiya Jisaasihoaisawɨ maasɨ mɨhatɨhɨ aŋɨtɨtɨhɨ koai otaatemapɨ bindawa saundawaatopo. “Kinyɨ kɨnaatɨ kwɨnyɨhoya kɨnaapwɨsa kɨmiya ipaahaapɨ bitotawa kinyapɨ taawɨ gaatawaayopo,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Saundauhɨ Jisaasiho komɨha wihoaaŋɨha kiyai saundataase. “Nisɨ naatɨ nisɨ nɨhoaarɨsa naapwɨrisa diye?” undataase. ");
INSERT INTO agm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Saundatosa kaaŋɨ aŋaaŋɨ maasɨ Jisaasiho sawɨhoaisawɨ bimohiyɨhiyai winjataise. Iwinjatataatɨ saundataase. “Kɨmiya nisɨ niya nisɨ nɨhoaarɨsa amɨ nisɨ naapwɨrise. ");
INSERT INTO agm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Isɨhiya Autaahaatɨho maaritatɨ gwɨnyaasɨrɨhɨretɨ japepihɨrohiyɨhiya siyaahɨhɨ tɨtɨhɨ nisɨhiya akɨyɨhiya nisɨ nɨhoaarɨsa amɨ nisɨ naapwɨrisa amɨ nisɨ naatɨ siyaare,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisaasiho jahɨra namasatɨ durɨhɨrɨ Garirihandainɨ isɨhiyai Autaahaatɨhomɨ pɨwɨha kataunjataise. Aihɨ isɨhiya apɨpaahɨ wɨrɨsandɨhandɨ komɨhinɨ ahoyanɨhauhɨ amɨ ko wo kopuhoaasɨnɨ yamwaatɨ durɨhɨraatɨhɨ detɨ aripatamɨhinɨ bindataise. Aihɨ isɨhiya durɨhɨrainɨ detɨ aripataatɨhɨ bindawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jisaasiho kiyai pɨwɨha sɨwipatɨ nepemaahɨwa taahɨwaiwa kataunjataise. Iyatɨ ko saundataase. ");
INSERT INTO agm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Atiwɨse. Utaaho wo komɨ osaataatɨ nandapaamɨ kwɨtaaho tɨwɨhaitandɨ netɨ isɨsi notaise. ");
INSERT INTO agm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Isɨsi notɨ kwɨtaaho osaataatɨ tɨwɨhaataise. Tɨwɨhaasɨhɨ nandapaamɨ kwɨtaaho wapa daihɨra tɨmahiyataise. Tɨmɨhaihɨ koho nasatɨ netɨ nanataise. ");
INSERT INTO agm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aihɨ amɨ wapa kwɨtaaho nawɨhetɨ autaahɨ yapɨhonya yahonyaahɨ ahotihɨhapɨhɨ tɨmahiyataise. Siyatɨ yapɨhonya tiwatɨhaatɨ yahonyaahɨhɨ ahotihɨhapɨhɨ tɨmahiyataatɨ amɨ yapɨpatɨ nehɨ yaataatɨndaatɨ ketɨ kuraanɨhɨ nutataise. ");
INSERT INTO agm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nutatɨ taatɨ sanaihɨ ipɨho ipɨndaatɨ nawɨhetisɨ tɨhihɨ tambatɨhɨrɨ baahɨ namotaatɨ awaipɨndaise. ");
INSERT INTO agm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aihɨ amɨ wapa kwɨtaaho anɨpɨho kaarɨha mwɨtoaipataatɨhɨ tɨmahiyataise. Aihɨ anɨpɨho kaarɨha mwɨtoaipatɨ waatɨ nawataatɨ nandapaamɨ kwɨtaaho nutisɨhoai netɨ namaasatɨ itaatihɨ gɨpwɨpwitatɨ nehaayataise. Siyataatɨ kapa nandapa biyatɨ nga nawatɨ amɨ nandapa yandɨpɨho wɨndɨ namingose. Owetise. ");
INSERT INTO agm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aihɨ amɨ isapɨpa kwɨtaaho wapa yapɨpatɨ gaahata tɨmɨhaimbɨpa nga nutatɨ nga saniyatɨ gwɨnyanatɨ yandɨpɨho akoho ningotaise. Siyatɨ nga nawasɨpɨpaamɨ wapa pɨhɨtatɨ 30 kiyatɨ nandapa yandɨpɨho ningotaise. Aihɨ amɨ yandɨpɨho wapa nandapa pɨhɨtatɨ 60 kiyatɨ ningotaise. Aihɨ amɨ wapa pɨhɨtatɨ 100 kiyatɨ ningotaise.” ");
INSERT INTO agm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aihɨ amɨ Jisaasiho satatosatɨ isɨhiya koai atɨwinjatohiyɨhiyai saundataase. “Sahɨ nisɨ pɨwɨha atɨnisohiyɨhiyaatɨ pɨwɨha sa sahɨ baiwɨ atiwɨ nepise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ipotɨ wura Jisaasiho nehɨ sawahohɨhɨ bimihɨ komɨ aposerɨhiya 12 kaiwɨhiyaatihɨ amɨ isɨhiya usa detɨ komɨhinɨtohiyɨhiyaatihɨ nuwɨ Jisaasihoai satɨwɨ nunjenawaayopo. “Kɨnyɨ sɨwipatɨ nepemaipɨ kanyatingɨhaamɨ tanyaaha ausaapɨ kanyate?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aihɨ Jisaasiho wihoaaŋɨha sata kaundataase. “Sangisaahɨ Autaahaatɨho komɨ isɨhiyai iwinjatindɨhandapɨ noaasandimbɨpa aimɨ netɨ nasisa gisunyaasɨhɨ sahɨ aimɨ mmonɨwɨ nehopo. Amɨ isɨhiya ipaahaapɨhiyaahɨ pɨwɨha nahatewa nehɨ sɨwipatɨ nepemaipɨhaiwaahɨhɨ atisawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Amɨ sandɨ tanyaaha siyate: ‘Kiya nisapɨ pɨhɨtɨwɨ jambɨwɨ wɨndɨ akɨpɨpa mmonɨwɨ namaitaatɨwo. Aiwɨ kiya atiwɨ pɨhɨtɨwɨ atimbɨwɨ amɨ akɨpɨpa wɨndɨ gɨmaawunyaata namusesapatɨtando. Amɨ kiya nga mmonɨwɨ nepɨ amɨ gɨwunyaatatɨ nusesɨpatonɨhɨ nisenda japɨhɨ nepemaitɨwɨ napisaihɨ nɨnɨ kiyaamɨ maipɨhaiwa nemwatɨpane,’ ndɨ pɨwɨha sɨwipatɨ namɨhandɨ kandaato,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aihɨ Jisaasiho komɨ otɨpɨpatɨhiyai saundataase. “Pɨwɨha nepemaitɨ sɨwipatɨ namɨhandɨ kasatohɨmaapɨ sangi gɨmaasunyainjo? Gɨmaasunyaatonaahɨ amɨ nɨnɨ pɨwɨha sɨwipatɨ namɨhandɨ kasatohɨwaiwa nahatewa napitiyatɨ gɨsunyaatɨtaise? ");
INSERT INTO agm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Utaaso isapɨpa kwɨtaaho tɨwɨhaaso so siyatɨ utaaho Autaahaatɨhomɨ pɨwɨha isɨhiyaamɨ omaŋɨtɨtɨhɨ isapɨpa kwɨtaahomatiyatɨ tɨwɨhaatɨ yamasɨhore. ");
INSERT INTO agm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Isapɨpa kwɨtaaho daihɨra tɨmɨhaihɨ koho netɨ nainjɨtɨmandɨ sandɨ isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ kiyaamɨ omaŋɨtɨtɨhɨ ahiyauhɨ Bwaasɨrɨhɨrɨ ketɨ kuraanɨhɨ nasatɨ Autaahaatɨho komɨ pɨwɨha kiyaamɨ omaŋɨtɨtɨhɨ yamatosisɨha nemasɨtɨhandapɨ namɨhanahaare. ");
INSERT INTO agm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Amɨ isɨhiya usa isapɨpa kwɨtaaho nawɨhetɨ yapɨhonya nehɨ yaataatɨ yahonya ahotihɨhapɨhɨ tɨmɨhaisɨhomataiwɨhiye. Kiya Autaahaatɨhomɨ pɨwɨha kiyai katɨwunjohɨha ketɨ maaritɨwɨ atiwɨ nepɨ isɨwatawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nepɨ isɨwatawaahandɨ kandɨ ka pɨwɨha kiya atiwɨ nehotɨha kiyaamɨ omaŋɨtɨtɨhɨ pɨwɨha dahopetɨ gaamatɨ baahɨ kiyai wɨndɨ namusese. Aihɨ kiya pɨwɨha ka nehɨ masɨhonjapɨ isɨwatawaayopo. Aihɨ isɨhiya usa Autaahaatɨhomɨ pɨwɨhaapɨ pohipaiwɨhiya kiyai nepɨ urɨpatitaatɨwɨ itɨhundɨwɨ tiwauhɨ yaiwɨ ketɨ kuraanɨhɨ pɨwɨha namawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Amɨ isɨhiya usa isapɨpa kwɨtaaho anɨpɨho kaarɨha mwɨtaipataatɨhɨ tɨmɨhaihɨ anɨpɨho kaarɨha netɨ itaatihɨ wɨndɨ nga gɨmunyana gɨpwɨpwitatɨ nehaisɨhomataiwɨhiye. Siya Autaahaatɨhomɨ pɨwɨha isɨhiya kiyai katɨwunjohɨha atiwɨ newaayopo. ");
INSERT INTO agm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Siya atiwɨ newaahandɨ kandɨ kiya mambɨhaiwa kiya baiwɨ nga bimɨtaatɨwɨhaiwaapɨ pɨhɨtɨwɨ gwɨnyapenɨhotɨhandɨ amɨ nawɨho ikɨpɨpa nepɨ ahoyotɨhandɨ amɨ wiwa wiwa nehɨ maipɨhaiwaapaahɨhɨ maarɨho nusoaasawɨmahohɨtɨhandɨ tisaitatɨ Autaahaatɨhomɨ pɨwɨhai netɨ itaatisataise. Aihɨ ka pɨwɨha kiyaamɨ pɨwɨha dahopa bimohɨrɨhɨretapɨ isapɨpa kwɨtaahomatiyatɨ gwɨnyanatɨ akɨpɨpa yandɨpɨho nandapa wɨndɨ nimaatatɨ namingose. ");
INSERT INTO agm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Iyataatɨ amɨ isɨhiya usa isapɨpa yandɨpɨho yapɨpatɨ gaahata tɨmahiyatɨ biya nga nuta saniya akɨpɨpa ahotatɨ ningosɨpatamataiwɨhiye. Siya isiya Autaahaatɨhomɨ pɨwɨha kiyai katɨwunjohɨha atiwɨ nepɨ anɨtiwɨ isɨwatohiyɨhiye. Isɨ kiya pɨwɨha atisohɨhaamɨ nandapa akɨpɨpa kiyaamɨhetapɨ noaipataise. Usaamɨhetapɨ nandapa akɨpɨpa pɨhɨtatɨ 30 kiyatɨ ningotaise. Aihɨ amɨ usaamɨhetapɨ pɨhɨtatɨ 60 kiyatɨ ningotaise. Aihɨ amɨ usaamɨhetapɨ pɨhɨtatɨ 100 kiyatɨ ningotaise,” undatɨ Jisaasiho kiyai tanyaaha nesɨpa ausaatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Aihɨ amɨ Jisaasiho kiyai saundataase. “Utaaho wo norɨhɨrɨ asatɨpatɨ (ramɨhandɨ) tɨpotɨ yutɨhɨraatɨhɨ napapɨhatɨ noaasatɨ ahaitaiso? Owetɨtaise. Ko wɨndɨ siyatɨ kamaitaise. Ko tɨpotɨ autaahiwatɨ aupwɨpɨhɨ ahaitaise. ");
INSERT INTO agm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Siyatɨ tɨpotɨ autaahihonɨhɨ wapa nahataapa asɨhatindɨtɨhɨ noaasandimbɨpa ausaimanɨtaise. Iyonɨhɨ amɨ wapa noaasandimbɨpa ausaimanɨnɨhonɨhɨ isɨhiya mmondaapo. ");
INSERT INTO agm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sahɨ isɨhiyaatɨ nɨngi nga atɨnisohiyɨhiyaatɨ baiwɨ atiwɨ nepɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Saundatosa amɨ Jisaasiho pɨwɨha wa kiyai saundataase. “Pɨwɨha wanɨ nɨnɨ kasatonɨhɨ atisohɨmaapɨ sahɨ baiwɨ gwɨnyaapɨse. Sahɨ isɨhiya usaisɨ wapa nunyohɨrɨhɨrɨ kɨretɨ japepihɨratɨ Autaahaatɨho amɨ sangi nasamɨtaise. Nasanyatɨ amɨ waatɨ pɨhɨtatɨ tɨsaahɨwatɨ nasamɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Iyataatɨ amɨ isɨhiya usa Autaahaatɨhomɨhaiwa waatɨ nga mmonɨwɨ nehohiyɨhiyai Autaahaatɨho amɨ waatɨ pɨhɨtatɨ kiyai numwɨtaise. Amɨ usa Autaahaatɨhomɨhaiwa wɨndɨ waatɨ nga mmonɨwɨ namehohiyɨhiyai amɨ nehɨ masɨhonya kiya mmonɨwɨ nepɨ gwɨnyaahonyonya kiyaamɨhetapɨ ko nemaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisaasiho sata kaunda owematosa amɨ pɨwɨha wa namɨhanaha kiyai saundataase. “Autaahaatɨho komɨ isɨhiyai iwinjatindɨhandɨ siyate. Utaaho wo isapɨpa kwɨtaaho yapɨpataatɨhɨ niyaamatɨ tɨwɨhaasɨhomatiyahande. ");
INSERT INTO agm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tɨwɨhaatosatɨ apatɨhɨ amɨ otapɨhaatɨ nanɨhiyatɨ utaaho nanotɨ nepatɨ daaya bindataatɨ isapɨpa kwɨtaaho ko tɨwɨhaasɨhopɨ napitiya nutatɨ gwɨnyanatɨ nandapa akɨpɨpa ningotɨ ahotise tatɨ wɨndɨ mmonatɨ gɨmunyaase. ");
INSERT INTO agm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yapɨpatamɨhandɨsɨ yapɨpatɨ sawandɨpɨ waapoho atɨpatɨ numwihɨ isapɨpa nutatɨ nawataise. Iyatɨ yanisa saniyatɨ kwɨtaaya nandawisa nandapa akɨpɨpa yandɨpɨho ningotɨ ahondaise. ");
INSERT INTO agm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Iyatɨ nandapa akɨpɨpa akuraahaihɨ kapa kɨpwɨtaatɨwɨ tɨmetihɨhura mba niyaamatɨ tɨwɨhaasɨho namatanaatɨ netɨ kanaata tisatatɨ kɨpotaise,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisaasiho sata kaundatosa amɨ wa saundataase. “Autaahaatɨho isɨhiyai iwinjaatɨ bindata komɨ kaindɨhandapɨ napitiya namɨhanaatɨ katɨtɨhaawe? Nyahɨ Autaahaatɨho komɨ isɨhiyai wɨnjatindɨhandapɨ sɨwipatɨ maahɨwɨtɨ namɨhana nepemahɨwa katɨtɨhaawe? ");
INSERT INTO agm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Autaahaatɨho komɨ isɨhiyai iwinjatindɨhandɨ nandapa isapɨpaamɨ kwɨtaaho apɨpaahɨ turɨkaarehonjɨ maasɨtetɨhandamatiyahande. Iyataatɨ maasɨtetɨhandamɨ kwɨtaaho apɨpaahɨ turɨkaarehonjɨ osaataatɨ yamapɨ tɨwɨhaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tɨwɨhaahauhɨ ko kwɨtaaho nutatɨ nawatɨ amɨ osaataatamɨ wapa ipɨ yandɨpɨho kwɨtaaho yamahohɨpɨpai nusatipɨhaatɨ ketɨ gwɨnyana saniya apɨpaahɨ awaipatɨtatɨ amɨ katɨ isɨtɨtɨ saatɨtɨpiyataise. Amɨ katamɨ isɨtɨtɨ saatɨtɨhoetɨ koho ainjɨhɨpɨpa nasatɨ nga katɨhɨ sɨhwihatɨhɨ itɨha itaayatɨ bimɨtaise,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisaasiho pɨwɨha saiwaamatiyahaiwa pɨhɨtatɨ sɨwipatɨ namɨhana nepemaahɨwa isɨ wɨrɨsandɨhiyai kiya nga mmonɨwɨ nepɨ gwɨnyaitɨwɨhamwaaŋɨ kataunjataise. ");
INSERT INTO agm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ko siyatɨ nasisoaarɨ pɨwɨha sɨwipatɨ nepemahɨwa namɨhana kataunjataise. Iyataahandɨ kandɨ amɨ kounɨ komɨ otɨpɨpatɨhiya koai nɨwipinjohiyɨhiyaunɨ nehɨ sawanaahɨ bindawaahura kaiwa pɨwɨha nepemaahɨwa namɨhana katiwaiwaamɨ tanyaaha nesɨpatɨ iwinjapwaatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jisaasiho saiwa pɨwɨha kataunjamapɨ sura asisɨha napandosura koai nɨwipinjohiyɨhiya otɨpɨpatɨhiyai saundataase. “Durɨhɨramɨ mɨhihɨnapɨ kopuhotɨ nutɨhaawo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sata nutɨhaawo undihɨ kiya atiwɨ kopuho Jisaasiho aimɨ bimisɨhotɨ naapwaatawaayopo. Naapwaatɨwɨ kapɨhɨ isɨhiya wɨrɨsandɨhiyai namasi Jisaasihoaisawɨ nowaayopo. Niyauhɨ amɨ kopuho wiwaisangi maasɨ kiyaisa notaise. ");
INSERT INTO agm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Saiwɨ taawɨ niyauhɨ mbɨpa watɨpɨhapa durɨhɨraatɨhɨ dotaise. Iyatɨ durɨhɨri netɨ ahoyatɨ tiwayaasɨhɨ amɨ nausɨha kopuhomɨ bopininɨ tiwayaatɨ naweta amɨ mɨhatɨhɨ kopuhoaatɨhɨ waapɨhaatɨ nandaatɨ tisaitataise. ");
INSERT INTO agm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Aihɨ sura Jisaasiho kopuhomɨ ahosɨhopɨ dawaapɨpɨhɨ yutɨhɨrɨ (kusinɨhandɨ) mɨtaapaitaatɨwɨhɨrɨ mɨtaapa nanotondaise. Siyatɨ nanototihɨ komɨ otɨpɨpatɨhiya owetɨtɨhaahatɨ kendaisɨ waapoho nanaatɨ nawatisaanɨpanɨ kɨnyɨ nyangi nyasonɨpɨ gɨnyunyaapaino?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Saiwɨ Jisaasihoai ahowimɨhauhɨ ko nepatɨ mbɨpaisunɨ durɨhɨrisunɨ itɨhunda saundataase. “Mbɨpaaraŋe mbɨmwaapɨ bɨpi namɨhaape. Amɨ durɨhɨrangisangi waatɨ tɨmipiyaapɨ bɨpi yatɨhitɨpɨ ahomaimbɨ nimande,” undataase. Sata Jisaasiho kaundihɨ mbɨpaunɨ durɨhɨrunɨ yatɨhitatɨ owendaise. ");
INSERT INTO agm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aihɨ ko koai nɨwipinjohiyɨhiya otɨpɨpatɨhiyai saundataase. “Sahɨ napindapɨ yayopo. Nisapɨ sahɨ wɨndɨ gɨmaanunyaahowo?” undataase. ");
INSERT INTO agm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aihɨ kiya sandɨ mmonawaawɨ apɨpaahɨ aungwohandɨ yaiwɨ sawana sanawaatopo. “Utaamo kɨmo napitetahondaatɨtindɨho amɨ mbɨpa itɨpɨho itɨpinjɨtɨhandunɨ durɨhɨrɨ tiwayaasɨtɨhandunɨ komɨ pɨwɨha atɨwisatɨ bɨpi ketɨ owendaiso?” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Aihɨ kiya Jisaasihotihɨ komɨ otɨpɨpatɨhiyaatihɨ saiwɨ durɨhɨrɨ Garirihandɨ nahaitɨwɨ mɨhihɨnɨ nuwɨ yapɨpatɨ amɨ aunahɨpatɨ taunɨhandɨ Geraasahiyaamɨhata noaipawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Notɨwɨ Jisaasiho kopuho aimɨ namasi taatɨ naihɨ ketɨ utaaho wo itɨpɨho maipɨhapa bimoho Jisaasihoai iwinjatosatɨ napihɨ nutanamaise. So utaaso itapɨpa ahiyohɨpɨpɨhɨ jomaahɨpatɨ nawɨhaatɨhɨ nanotɨ bimainjaho katɨhɨ nasisoaarɨ bisotimbɨpɨhɨ jomaahɨpataatɨhapɨ noaipasi nasataise. ");
INSERT INTO agm_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","So utaaso itɨpɨho maipɨhapaisaho nahatewetɨ itapɨpa ahiyohɨpɨpɨhɨ jomaahɨpataatɨhɨ nanotɨ bisondaahore. Iyataatɨ isɨhiyaisangi ipipatɨ gwɨhɨrɨ watɨpɨhapaaraahisangi wɨndɨ andɨtitɨwɨ wɨmisasawɨhore. ");
INSERT INTO agm_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Isɨhiya ipipatɨ gwɨhɨra anɨtiwɨ wɨsasawɨ ahiyauhisangi nehɨ bɨpi nainjaatɨ ahiyamɨ nahatewetɨ konɨhɨ notoaatihɨ isɨhiya andɨtitɨtaatɨwɨhandɨ owetihɨ kaimbɨwɨ namɨhaahauhɨhore. ");
INSERT INTO agm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Iyataatɨ apatɨhɨ otapɨhaatɨ jomaahɨpatɨ itapɨpa ahiyohɨwaiwaatɨhɨ nanda noaipa sisɨho sɨhoaarɨhɨrɨ gaamatɨ konyahata nawɨhaara sawaho tunna namautahore. ");
INSERT INTO agm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Isɨ ko jata Jisaasiho kaanɨhɨ wonjɨ taatɨ napihɨ ketɨ ŋuhɨti niyatɨ Jisaasihomɨ utatototɨ tɨmahiyatɨ komɨ atotɨpatɨ Jisaasihomɨ auhɨraapɨhɨ detɨ atotɨpɨwesatɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Atotɨpɨwesatɨ bindataatɨ Jisaasihoai waatɨ kaahaata saundataase. “Jisaasihoŋe, Autaahaatɨho nahatewai ipatisamatɨ autaahɨ yamɨhapataatɨhɨ bimisɨhomɨ Mwaahoŋe, kɨnyɨ nɨngi napitɨnitaape? Nɨnɨ Autaahaatɨhomɨ ambɨpataahɨ watɨpɨndɨ waatɨ kahɨtataatonɨ kɨnyɨ nɨngisɨ yaasɨhandɨ wɨndɨ namaaninye,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Itɨpɨho maipɨho sata kaundindɨmandɨ Jisaasiho amɨ aimɨ saundatɨ, “Kɨnyɨ itɨpɨhoŋɨ maipɨhoŋe, utaamo kɨmoai namasi noaipasi numwe,” undatɨ kaundihɨ kandapɨse. ");
INSERT INTO agm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aihɨ Jisaasiho koai saundatɨ, “Kinyɨ ambɨpatɨ napimahoŋe?” undatɨ nunjenataise. Nunjesɨhɨ ko saundataase. “Nisɨ ambɨpatɨ Taahɨhonɨne. Sandɨ Taahɨhonɨne hɨtohɨtɨmandɨ amɨ itɨpɨ maipɨhiyaanɨ taahiyɨhiyaanɨnɨ bindɨhaawɨhɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Iyatɨ itɨpɨho maipɨhapa Jisaasihoai saundɨwɨ, “Nyahɨ kɨmbɨhɨ bimɨtɨhaawiyonɨ nepɨ natɨpɨnyoaasɨtainɨ, owe,” undɨwɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aihɨ kapɨhɨ maasapɨho taahɨho sisɨhonjamɨhinɨ detɨ bitotawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aihɨ itɨpɨho maipɨhapa Jisaasihoai waatɨ kaahaatɨwɨ saundawaatopo. “Jisaasihoŋe, nyahɨ nowa kɨmaiwa maasapɨmaiwaamɨhetɨ nandaitaanɨ nepɨ natɨpɨnyoaase,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Satɨwɨ itɨpɨ maipɨhatɨma kaundauhɨ amɨ Jisaasiho, “gaasɨ nuwɨ maasapɨho soetɨ nandaapɨse,” undataase. Satatɨ kaundihɨ itɨpɨ maipɨhatɨma utaahomɨhetapɨ noaipasi nuwɨ maasapɨhoetɨ nandaawaayopo. Nandaahauhɨ maasapɨho so taahɨho ambɨpatɨ owehandisɨ 2,000 kiyaho nahato mɨhetapɨ ŋuhɨti notɨ mɨhopɨ durɨhɨraatɨhɨ nahandɨ witamataise. Siyatɨ nahato 2,000 kiyaho durɨhɨraatɨhɨ witatɨ waapoho nanatɨ nahato konɨhɨ napomataise. ");
INSERT INTO agm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aihɨ isɨhiya maasapɨho yamanɨwɨ jaawɨ bitohohiyɨhiya sandɨ mmonɨwɨmapɨ ŋuhɨti nuwɨ isɨhiya osaataatɨ bitohohiyɨhiyaisunɨ amɨ aunahɨpata bimohiyɨhiyaisunɨ kaundɨwɨ gaamawaayopo. Aihɨ isɨhiya kiyaamɨ pɨwɨha atiwɨmapɨ mmondaatɨwɨ ŋuhɨti nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kiya ŋuhɨti napɨwɨ mmonawa utaaho itɨpɨho maipɨhapa komɨhetɨ bimihɨ konyahɨta naharisa daayatoaatisɨho naharindɨhandɨ owetatɨ komɨ amɨtɨha biyatɨ iwinjapwaatihɨ nanɨhiyatɨ utɨ apotina nanɨhiya bimihɨ napɨwɨ usonawaayopo. Kiya koai saiwɨ usonawaawɨ aungwohandɨ waatɨ yayawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aihɨ kiya utaaho itɨpɨho maipɨhapaisaho Jisaasiho tɨtɨhemwasɨhoaisunɨ amɨ maasapɨho nahato durɨhɨraatɨhɨ witatɨ waapoho nanatɨ napwindɨhandunɨ mmonɨwɨ pɨwɨha nesi nuwɨ isɨhiya nahatiyai kaundɨwɨ gaamawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aihɨ kiya saiwa atiwɨ mmonawaawɨ Jisaasihoai kiya namasawɨ saundawaatopo. “Kɨnyɨ nyamɨ yapɨpatɨ kɨmatɨ namasi wapɨhapɨ ketɨ kɨmɨkuraanɨhɨ dosisɨ numwe,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisaasiho aimɨ japɨhɨ nutandɨ kopuhotɨ nasaamasɨhɨ amɨ utaaho itɨpɨho maipɨhaiwa komɨhetɨ bimihɨ tɨtɨhemwasɨho Jisaasihoai nunjenatɨ saundataase. “Nɨnɨ gisatɨ maasɨ nutaanɨ kɨnyɨ gaare nde?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sata ko nunjesɨhɨ Jisaasihomɨha wihoaaŋɨha sata kaundataase. “Kɨnyɨ nɨngisapɨ wɨndɨ namutaise. Owe. Isɨ nehɨ kinyɨ aŋɨpɨpɨhapɨ numwe. Numbwɨ amɨ kɨnyɨ kɨwahonyɨhiya nahatiyai Awaisɨho gisɨ gɨtatamanɨtandɨ maarɨho wɨhiwatɨ amɨ gaahatɨ kahisatɨ amɨ itɨpɨho maipɨhapa kinyɨhetapɨ nemasɨtɨhandapɨ pɨwɨha ausaapɨ kaunde,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Sata Jisaasiho kaundihɨ ko ketɨ kuraanɨhɨ kapɨhɨ namasi notɨ aunahɨpa wɨtɨ katamɨ ambɨpatɨ aunahɨpa awaipatɨ taunɨhandɨ Dekaporisihandɨ Ikwɨmaitɨmohata noaipataise. Sapɨhɨ noaipatɨ ko satatɨ, “Jisaasiho itɨpɨho maipɨhapa nisɨhetɨ bimimbɨpa nenɨmasɨhɨ nɨnɨ noaipatɨ wanɨ gaahonɨne,” undatɨ komɨhiyai pɨwɨha ausaatɨ kaundataase. Kaundihɨ isɨhiya komɨ pɨwɨha atisawaawɨ ese tɨwɨ maarɨho owetihɨ yaiwɨmapɨ aatɨmawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Aihɨ Jisaasiho japɨhɨ kopuho nesi Garirihɨrɨ durɨhɨraatɨhɨ nahaita mɨhihɨnɨ notataise. Notatɨ durɨhɨrainɨ aripataatɨhɨ bitosɨhɨ isɨhiya koai iwinjaposawɨ taahiyɨhiya koaapɨhɨ napɨwɨ koai otaatemapɨ ahoyanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aihɨ sura utaaho wo Judaahiyaamɨ aŋaaŋɨ pɨwɨhaapɨ ahoyanohaaŋaaŋɨ jatisɨho komɨ ambɨpatɨ Jairaasiho Jisaasihoai usonatosatɨ notɨ komɨ utatototɨ tɨmahiya ahondaise. Tɨmahiyatɨ Jisaasihomɨ auhɨraapɨhɨ ko atotɨpɨwesataise. ");
INSERT INTO agm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tɨmahiya atotɨpɨwesatɨ ahondaatɨ Jisaasihoai gousetɨ saundatɨ nunjenataise. “Nisɨ maasɨhaama metɨhaatɨ aimɨ napwɨtandɨ detɨsɨ amɨ kɨnyɨ kinyɨ ikwɨrɨ kaati ahɨwitaapɨ namme. Ahɨwisamɨhɨ kaatɨ japɨhɨ nepatɨ nga bimɨtando,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sata Jairaasiho kaundatɨ nunjesɨhɨ amɨ Jisaasiho komɨ nunjesɨha atɨwisatɨ koaisatɨ maasɨ komɨ aŋɨpɨpɨhapɨ notaise. Siyatɨ koaisatɨ maasɨ naihɨ isɨhiya taahiyɨhiya wɨrɨsandiwɨ komɨhinɨ numwɨhatɨwɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aihɨ kiyaamɨ otɨhatɨhapɨ apopaatɨ waatɨ kɨnaungwɨha pɨhɨtatɨ 12 kiyahaiwetɨ jɨtɨmainjɨhaatɨ kiyaisatɨ maasɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Saatɨ apopaatɨ dokɨtaahiya taahiyɨhiyai iwinjasɨhɨ kiya kaati yaawɨhandɨ pɨhɨtɨwɨ nunyauhɨ nenjɨhaate. Iyatɨ kaatamɨ nawɨho aungwohandɨ kiyai nunyainjɨhaate. Iyataahandɨ kandɨ wɨndɨ gaamausetatɨ daahɨ maipɨtatɨ jɨtɨmainjɨhaate. ");
INSERT INTO agm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Siyatɨ jɨtɨmatɨ ketinjɨhaatisɨ Jisaasiho kaiwaiwaapɨ atisataatɨ koenda nasataise. Nasatɨ Jisaasihomɨ ipotɨ dawaataatɨ notaatɨ Jisaasiho apotɨhɨrɨ nipata niyosɨrɨhɨrɨ isɨwataise. ");
INSERT INTO agm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kaatɨ Jisaasihomɨ apotɨhɨrɨ isɨwatɨ numwɨhatindɨmandɨ kaatɨ siyatɨ gwɨnyaataate. “Nɨnɨ Jisaasiho apotɨhɨrɨ niyotɨ nipaatirɨhɨrɨ numwɨhatɨtɨ amɨ iwisanɨhisangi nisɨ timbɨpa jɨtɨmatoaasohɨtɨhandɨ nga owetɨtaise,” tatɨ andɨtitatɨ gɨwunyaasɨtɨhandaahe. ");
INSERT INTO agm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Siyatɨ kaatɨ Jisaasihoai numwɨhatihɨ kaatamɨ jɨtɨmatoaatindɨhandɨ ketɨ kuraanɨhɨ owetatɨ jɨtɨpa dɨhɨwatɨ niyaipasɨhɨ mmotɨnataatɨ aimɨ noaipatɨ gaahaanɨne tatɨ gwɨnyapenataise. ");
INSERT INTO agm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Siyatɨ apopaatɨ Jisaasihomɨ apotɨhɨrɨ isɨwihɨ komɨ watɨpɨhandɨ wɨndɨ aimɨ apopaatamɨhetɨ naihɨ mmotɨnata ketɨ kuraanɨhɨ nepemaitatɨ kapɨhɨ isɨ wɨrɨsandɨhiyai saundataase. “Utaatɨndɨ ndɨ nisɨ apotɨhɨrɨ nise,” tatɨ nasenataise. ");
INSERT INTO agm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aihɨ komɨ otɨpɨpatɨhiya Jisaasihoai saundawaatopo. “Isɨmiya metatɨ kinyɨhinɨ napɨwɨ nangɨmatɨwɨ mɨpanɨndisaatɨmaatɨ nasenɨpɨ ndɨ nanɨmɨhatatɨ nise tɨpɨ namaasenɨme,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Satɨwɨ komɨ otɨpɨpatɨhiya kaundauhɨhandɨ kandɨ wiwatɨ numwɨhatindɨhandɨ nde tatɨ usondandɨ nepemainana mɨhinɨ mɨhinɨ jataise. ");
INSERT INTO agm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aihɨ kaatɨ apopaatɨ kaatamɨ jɨtɨmasɨtɨhandɨ owetihɨ mmotɨnata aungwohandɨ yayatɨ itipɨ nasatɨ Jisaasihomɨ utatototɨ tɨmahiyataise. Siyatɨ kaatɨ komɨ auhɨraapɨhɨ atotɨpɨwesatɨ bindata kaatamɨ timbɨpa jɨtɨmatoaatindɨhandɨ Jisaasihomɨ apotɨhɨrɨ iwisura dɨhɨwatɨ nipiyaipasɨtɨhandapɨ tɨtɨhɨ ausaatɨ koai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aihɨ Jisaasihomɨha kaati saundataase. “Maasɨhaamo nisapɨ kɨnyɨ satɨpɨ, ‘Koai nɨnɨ numwɨhatɨtɨ wisanaahɨ nisɨ jɨtɨmahohɨtɨhandɨ nga owenetɨtaise,’ tɨpɨ kɨnyɨ gɨnunyaahingɨtɨhanda kɨnyɨ jɨtɨmapoaatingɨtɨhandɨ owesendaise. Isɨ kɨnyɨ jɨtɨmahingɨtɨhandɨ owendaisɨ kinyɨ maarɨho wɨhita napaisatɨtonɨhɨ numwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Siyatɨ Jisaasiho kaati taatɨ kaundihɨ Jairaasihomɨ aŋɨpɨpɨhapɨhiya pɨwɨha isɨsi noaipapɨ Jairaasihoai saundawaatopo. “Kinyɨ kimaamaatɨ aimɨ napwisɨ napaapɨ nehɨhandɨ kataunjisɨhoai pohɨrundɨpɨ kaundise?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Amɨ Jisaasihohɨ kiya Jairaasihoai kaundohɨha wɨndɨ atɨhomaawise. Nehɨ metɨhaatamɨ sapɨhoai saundataase. “Kɨnyɨ wɨndɨ yamaime. Owe. Nisapɨ ko nga nisɨ metɨhaati tɨtɨhɨwiwɨtaise tɨpɨ nehɨ gɨnunyaape,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aihɨ taahiyɨhiya nɨwipinjai niyohiyɨhiyai saundataase. “Sahɨ nahatiyaatɨ nanipinjai namaapɨwɨse,” undataase. Saundatosatɨ nehɨ Pitaahoaisunɨ Jemɨsihoaisunɨ amɨ Jemɨsihomɨ saingɨho Jonɨhoaisunɨ numwaasi nehɨ kingwaasisataahɨhɨ Jairaasihomɨ aŋɨpɨpɨhɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jisaasihotihɨ kiyaatihɨ nuwɨ Jairaasihomɨ aŋɨpɨpɨhɨ noaipawaayopo. Noaipapɨ Jisaasiho mmonata isɨhiya pɨhɨtɨwɨ ŋuŋa tɨwɨ gwɨwɨ nehotauhɨ usonataise. ");
INSERT INTO agm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aihɨ Jisaasiho nandaatɨ kaaŋɨ taawɨ gwɨwɨ nehotohiyɨhiyai saundataase. “Kɨmaatɨ metɨmaatɨ napotaamaise. Owe. Nehɨ nanotondaise. Isɨ sahɨ napaapɨ taawɨ gwopo?” undataase. ");
INSERT INTO agm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sata Jisaasiho kaundihɨ kiya ko kaundisɨhaapɨ etɨtaatɨndaase tɨwɨ sisawaayopo. Aihɨ kiya nahatiyai netɨ ipaahaapɨ natausaasatosatɨ metɨhaatɨ kaatamɨ saniyɨ sapiyaisunɨ komɨ otɨpɨpatɨhingwaasisunɨ numwaasi maasɨ metɨhaatɨ napotɨ ahotimbɨpɨhɨ nandaataise. ");
INSERT INTO agm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nandaapɨ bitotawa Jisaasiho metɨhaatɨ napomasaamaatamɨ ikwɨrɨ netɨ iwiwatata pɨwɨha sawanaamɨhaara saundataase, ‘Tarita Kumwɨ,’ undataase. Sandɨ Tarita Kumwɨ, undindɨmandɨ saundataase. “Metɨhaaŋe, Nɨnɨ gi kahɨtataatonɨ kɨnyɨ nepapɨ dopɨ bitose,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sata Jisaasiho kaundihɨ kaatɨ ketɨ kuraanɨhɨ Komɨ pɨwɨhetɨ nepasi daayataise. Saatɨ metaatamɨ kɨnaungwɨha 12 kiyahaate. Aihɨ isɨhiya aŋaaŋɨ Jisaasihoaisawɨ nandaahohiyɨhiya sandɨ mmonawaawɨ apɨpaahɨ aungwohandɨ waatɨ yaiwɨmawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yaiwɨmɨhauhɨ Jisaasiho kiyai saundataase. “Kɨmaatɨ metɨmaati tɨtɨhɨwihonɨhɨ nepasɨtɨmandapɨ isɨhiyai ausaapɨ apɨpaahɨ wɨndɨ kamundɨmapɨse,” undatɨ watɨpɨtatɨ kaundataase. Iyatosatɨ amɨ saundataase, “Metɨhaati nandapa wapa nanda nunyawɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Satɨ aunahɨpita Jisaasiho metɨhaati tɨtɨhɨwiwa kiyamapɨ kapɨhɨ namasi tɨtɨhɨ komɨ aunahɨpataahapɨ notaise. Naihɨ amɨ komɨ otɨpɨpatɨhiya maasɨ Jisaasihoaisawɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nuwɨ noaipapɨ asisɨha Sapaatɨhandetɨ Judaahiyaamɨ aŋaaŋɨ pɨwɨhaapɨ ahoyanotɨhandaatɨhɨ Jisaasiho nandaatɨ namasatɨ Autaahaatɨhomɨ pɨwɨha kataunjataise. Kataunjihɨ isɨhiya nahatiya Jisaasihomɨ pɨwɨha atisawaawɨ aungwohandɨ yaiwɨmaposawɨ satawaatopo. “Kɨmo utaamo amɨtɨha gaahandɨ gwɨnyaasɨtɨhandɨ maahapɨhapɨ nehande? Iyatɨ ko pɨwɨha maahapɨhapɨ atisa nehe? Iyatɨ amɨ watɨpɨhandɨ napitiya mmonatɨ netɨ gɨwunyainjɨhɨ watɨpɨhaiwa kaindɨho? ");
INSERT INTO agm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kɨmo utaamo Maariyaahaatamɨ mwaahoro? Komɨ saingoya Jemɨsiho Josesiho (komɨ ambɨpatɨ wɨtɨ Josepɨho) Judaasiho Saimonɨho amɨ sanasɨhiya kɨmbɨhɨ nyangisawɨ maasɨ bimohiyɨmiyaamɨ saahoro? Iyatɨ ko jɨhɨ otɨpɨpatɨ aŋaaŋɨ aŋɨmatɨtaatɨwɨhatɨ kiyatɨ bimisɨhoro?” tɨwɨ katɨwɨ mɨmaipaiwɨ usonawaawɨ kopɨ wɨndɨ maarɨmitɨwɨ Jisaasihoai ahosumwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kiya saiwɨ kiyauhɨ Jisaasiho kiyai saundataase. “Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho aunahɨpatɨ tɨtɨhɨ nehɨ ko sawahomɨhataahunɨ amɨ ko nehɨ sawahomɨhiyaamɨhatɨhɨhunɨ amɨ ko nehɨ sawahomɨ aŋɨpɨpɨhɨ saniya sapiya saingosaahoya sanaanisa sanaapwɨsaamɨhatɨhunɨ ko ambɨpatɨ awaipatɨ owehore. O amɨ ko komɨ aunahɨpatɨ namasi notɨ aunahɨpa wɨta amɨ isɨhiya nehɨ kiyai usaapɨhɨ Autaahaatɨhomɨ pɨwɨha ausaataataahɨ amɨ kapɨhɨ ko ambɨpatɨ awaipatɨ netaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Saiwɨ kiya Jisaasihoaisunɨ komɨ pɨwɨhaisunɨ ahosumwahauhɨ ko watɨpɨhaiwa komɨ aunahɨpata kiyaamɨ ndɨhetɨ wɨndɨ kamaise. Owe. Nehɨ nɨnaasiyaisaahɨhɨ ikwɨrɨ ahɨwisatɨ kiyaamɨ timbɨpa nemwataise. ");
INSERT INTO agm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Komɨhiya Autaahaatɨhomɨ pɨwɨhaapɨ baiwɨ wɨndɨ gɨmunyaahauhɨ sandapɨ Jisaasiho waatɨ aungwohandɨ gwɨnyaataise. Aihɨ Jisaasiho kapɨhɨ namasi aunahɨpatɨ kahatɨ kahataahɨma notɨ daayatɨ Autaahaatɨhomɨ pɨwɨha isɨhiyai kataunjataise. ");
INSERT INTO agm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisaasihomɨ otɨpɨpatɨhiya 12 kaiwɨhiyaasɨ kiyai ko numwaatɨ detematosatɨ itɨpɨho maipɨhapa isɨhiyaamɨhetɨ bimonɨhapai nepumwaitaatɨwɨ ko kiyai komɨ watɨpɨhandɨ nunyataise. Komɨ watɨpɨhandɨ nunyatɨ netɨ tipɨtapaatɨ yahurɨ yahuri wapɨhɨ wapɨhapɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Siyatɨ natausaasataatɨ pɨwɨha wa watɨpɨha sata nunyataise. “Nɨnɨ sangi nandɨsoaasisanɨhɨ sahɨ nowaawɨ kahapaamapɨpa wapa mipɨ nehɨ taanahiyaatɨ nuwɨse. Nehɨ samɨ ngɨrɨhɨrɨhɨhɨ mwɨtɨpisawɨ daayohɨrɨhɨrɨhɨhɨ isɨsi nuwɨse. Ikihɨ amɨ nandapa bɨretɨhandɨ amɨ nawɨho ikiha kɨpɨwɨ wɨndɨ mipɨ nehɨ taanahiyaatɨ nuwɨse. ");
INSERT INTO agm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Iyataatɨ amɨ sahɨ asuipatɨhɨ gaasɨ nipaatɨwɨse. Aiwɨ amɨ apotɨhɨrɨ nehɨ samɨ ambɨpatetɨ niyopɨ nipaatohɨpɨpaahɨtane. Iyawaahandɨ kandɨ amɨ apotɨhɨrɨ wapa isɨpɨpa wɨndɨ mipɨse. Owetane. ");
INSERT INTO agm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sahɨ nuwɨ aunahɨpatɨ wɨta noaipapɨ amɨ aŋaaŋɨ wangaapɨhɨ nandaawaawaahɨ sapɨhɨ kapɨhɨ bimambɨwɨ aunahɨpatɨ namasi nowaahura aŋaaŋɨ saaŋɨ namasi kapɨhɨ noaipasi nuwɨse. ");
INSERT INTO agm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","O amɨ sahɨ nuwɨ aunahɨpatɨ wɨta noaipasaihɨ isɨhiya wɨndɨ sapɨ maaritɨwɨ namaasamaapɨ pɨwaamaasatɨwɨ amɨ samɨ pɨwɨha atɨhomaasisaihaahɨ kandɨ kiyaamɨ maipɨhandapɨ, ‘nyamɨhandɨmaahe samɨhande. Isɨ kandapɨ Autaahaatɨho wihoaaŋɨhandɨ nasamɨtaise,’ undɨwɨ nunjɨtaatɨwɨ samɨ auhɨramɨ atasɨhaapɨhɨ ikwaatɨpɨho namaasandimbɨpa kapɨhɨ tɨwɨhaapɨ nemapɨ nuwɨse,” undatɨ pɨwɨha itatamanatɨ wɨnɨhundatɨ kaundatɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Siyatɨ Jisaasiho natausaasihɨ nuwɨ isɨhiyai saundɨwɨ, “Sahɨ samɨ maipɨhaiwa kiyohɨwaiwa namapɨ nepemaitɨwɨ amɨ Autaahaatɨhoenda napɨwɨse,” undɨwɨ Autaahaatɨhomɨ pɨwɨha ausaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Aiwɨ kiya Jisaasiho watɨpɨhandɨ numwindɨhanda itɨpɨho maipɨhapa taahɨwaiwa isɨhiyai timbɨpa nunyatɨ bimiwaiwai nepɨ tahamanɨwusoaasawɨ nemawaayopo. Aiwɨ amɨ atɨpatɨ oripɨhatɨ noaapɨ isɨhiya taahiyɨhiya timbɨpaisahiyai iwinjaahauhɨ kiyai gausoendaise. ");
INSERT INTO agm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jisaasiho komɨ otɨpɨpatɨhiyaisatɨ otɨpɨpatɨ kaindɨhandɨ nga auta noaipasɨhɨ amɨ isɨhiya nahatiya mmonawa gaatihɨ kandapɨ aunahɨpatɨ nahatewaara kanɨwɨ gaamatawayopo. Aihɨ amɨ sandapɨ isɨhiya pɨwɨha nesi kanɨwɨ daayohiyɨhiyaamɨ usa satawaatopo. “Jonɨho Isɨhiyai Baawusisɨho so anɨmwaahɨpatombɨ saiwa kaitandɨ watɨpɨhandisa nepasi isɨhiya kamaitaahetahaiwa watɨpɨhaiwa kiyataise,” tɨwɨ katawaatopo. Satauhɨ amɨ awaisɨho Kiŋɨ Erotɨho pɨwɨha sa atisatɨ netaise. ");
INSERT INTO agm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aihɨ amɨ usa satawaatopo. “Kɨmo utaamo Eraijaahoe,” tawaatopo. Aihɨ amɨ usa satawaatopo. “Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ jɨhura ausaapɨ isɨhiyai kaundohiyɨhiyaamatiyaho wo noaipa watɨpɨhaiwa aungwohaiwa kiyataise,” tɨwɨ Jisaasihopɨ katawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Satɨwɨ isɨhiya katauhɨ awaisɨho Erotɨho pɨwɨha sa kaahɨhɨ atisa netaise. Siyatɨ kaahɨhɨ atisataatɨ ko awaisɨho Erotɨho sandaase. “So Jonɨhoai nɨnɨ naahutarɨhɨrɨ nisatonɨhɨ aimɨ napwisɨhosɨ amɨ ko japɨhɨ anɨmwaahɨpatombɨ nepatete,” tatɨ kandaase. ");
INSERT INTO agm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Apopaatɨ waatɨ kaatamɨ ambɨpatɨ Erotiyaasihaate. Amɨ saatɨ Erotɨhomɨ saingɨho Piripɨhomɨ apwaataate. Piripɨhomɨ apwaataatɨtihɨhandɨ kandɨ awaisɨho Erotɨho kaati aunɨhɨwisatɨ netɨ wɨrataise. Siyatɨ netɨ wɨrasɨhɨ kandapɨ Jonɨho Isɨhiyai Baawusisɨho konɨhɨ jinjɨhaatɨ awaisɨho Erotɨhoai saundataase. “Kunyɨhɨho Piripɨhomɨ apwaataati nepɨ wɨrahingɨtɨmandɨ wɨnɨhapɨpa nepɨ nopɨsasɨpɨ kiyapainɨ sandɨ tɨtɨhɨmaahe maipɨhandɨ kiyapaise,” undatɨ itɨhundataase. Siyatɨ Jonɨho Isɨhiyai Baawusisɨho Erotɨhoai kaundihɨ kandapɨ awaisɨho Erotɨhoai apowihɨ namatɨ tingaatɨhaisahiyai natausaasihɨ nuwɨ Jonɨho Isɨhiyai Baawusisɨhoai isɨpɨ numwaasi nuwɨ isɨhiya napwɨtohɨpɨpɨhɨ ipipatɨ watɨpɨhata wɨsasawɨ napuwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erotiyaasihaatɨ Jonɨho Isɨhiyai Baawusisɨhopɨ apɨpaahɨ aungwohandɨ apowihɨ Jonɨho sohoai timapɨse undɨtɨhatɨ katɨ Erotɨho awaisɨhopimainjɨhɨ wɨndɨ kaundatɨ kamaise. Owe. ");
INSERT INTO agm_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Amɨ Erotɨho Jonɨhopɨ yayatɨ amɨ koai Erotɨho biyatɨ iwinjatiho. Iyatɨ amɨ Jonɨho Autaahaatɨhomɨ ndɨhetɨ utaaho apɨpaahɨ gaaho tɨtɨhotihɨ Erotɨho yayatɨ gwɨnyaataato. Iyatɨ amɨ Jonɨho pɨwɨha ausaasɨwaiwa Erotɨhomɨ omaŋɨtɨtɨhɨ netɨ nusopɨsasinjɨhandɨ kandɨ amɨ Erotɨho Jonɨhopɨ maaritatɨ komɨ pɨwɨha atɨwisataise. ");
INSERT INTO agm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Siyatɨ nitana Erotiyaasihaatɨ bimainjɨhaatisɨ kaatamɨ maarɨhopɨ asisɨha Erotɨhoai sanaatɨ namwisɨha noaipataise. Siyatɨ Erotɨhoai asisɨha sanaatɨ namwisɨha noaipasɨhɨ Erotɨhomɨ yatɨhɨ otɨtɨhɨ otɨpɨpatɨ awaiwaiwa isɨpɨ kaiwɨ bimohiyɨhiyaisunɨ amɨ pwɨsɨpɨ yaipatɨ kiyohiyɨhiyai tahaapundɨwɨ iwinjatohiyɨhiyaisunɨ amɨ isɨhiya usa awaisawɨhiya Garirihandaahapɨhiyaisunɨ numwaatɨ ahoyatɨ kiyaisa maasɨ nandandɨ nandapa aungwohandɨ tɨhataise. ");
INSERT INTO agm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aihɨ Erotiyaasihaatamɨ maataatɨ nasa nandaatɨ awaisɨho Erotɨhomunɨ isɨhiya ko gaata numwaasɨhɨ nandapa maasɨ nainjawɨhiyaamɨ ndɨhetɨ waipatɨ sanahɨwiya waipwaasɨhɨ kiya kaatapɨ aungwohandɨ maaritawaayopo. Saiwɨ kaatapɨ kiya aungwohandɨ maaritawaawɨ awaisɨho Erotɨho kaatɨ apwaimaamaati saundataase. “Gisɨ wapaapɨhisonaahɨ satɨpɨ nɨngisɨ sapaapɨnyisɨ naninye ndɨpɨ kande amɨ nɨnɨ kapa gisɨ nahɨmɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ko awaisɨho Erotɨho pɨwɨha watɨpɨha kaatɨ apwaimaamaati saundataase. “Kɨnyɨ nɨngi wapaapɨ nanɨsesamaahɨ nahɨmɨto. Nisɨ otɨpɨpatɨ awaisɨhonɨnimandɨ isɨhiyai iwinjaatɨ bimohɨpatisangi tipɨtapaatɨ wihoaaŋɨhatɨ kɨnyɨ kaimbɨ jatɨtaapɨ nahɨmɨto nanɨsesamaaho,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Saundihɨ kaatɨ sanaatenda ŋuhɨti notɨ saundataase. “Nore nɨnɨ awaisɨho Erotɨhoai ko nɨngi napindɨ nanɨmɨtandɨ nunjendande?” undataase. Sata nunjesɨhɨ sanaatɨ maataati satɨpɨ kaunde undatɨ saundataase. “Jonɨho Isɨhiyai Baawusisɨhomɨ mɨtɨho nisatɨpɨ nesɨmbo undɨpɨ kaunde,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sata sanaatɨ maataati kaundihɨ kaatɨ atisamapɨ ketɨ ŋuhɨti niya awaisɨho Erotɨhoai saundataase. “Wanɨ kɨmura kuraanɨhɨ Jonɨho Isɨhiyai Baawusisɨhomɨ mɨtɨho nisatɨpɨ nyaihandaapɨhɨ ahiyapɨ nesɨmbɨnɨmɨtaape,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sata apwaimaama Jonɨhomɨ mɨtɨhopundihɨ awaisɨho Erotɨho apɨpaahɨ awaindɨhandɨ komɨ maarɨho yaawatɨ naaŋawisataise. Siyatɨ awaisɨhomɨ maarɨho yaawihɨhandɨ kandɨ amɨ ko pɨwɨha apɨpaahɨ watɨpɨha isɨhiya maasɨ nandapa nanɨhohiyɨhiyaamɨ ndɨhetɨ apwaimaamaati kaundisɨhaapɨ gwɨnyapenataatɨ sandɨ utaahomɨ mɨtɨhopɨndɨnɨ owe undɨtandɨhandɨ owendaise. ");
INSERT INTO agm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aihɨ ako komɨ pɨwɨha watɨpɨha watɨpɨta katisɨhaapimainjɨhɨ namatɨ tingaatɨhaisaho woai saundataase. “Kɨnyɨ aŋɨhandɨ napwɨtohɨtɨhandaatɨhɨ numbwɨ nandaapɨ Jonɨho Isɨhiyai Baawusisɨhomɨ mɨtɨho nisatɨpɨ nesi nambɨ apwaimaamaati numwɨta numwe,” undataase. Numwe undihɨ ko tingaatɨhaisaho ketɨ kuraanɨhɨ atisatɨ aŋɨhandɨ napwɨtotɨhandaatɨhɨ notɨ nandaatɨ Jonɨho Isɨhiyai Baawusisɨhomɨ mɨtɨho nisatataise. ");
INSERT INTO agm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mɨtɨho nisatatɨ nyaihandaapɨhɨ isɨsi nasatɨ apwaimaamaati nunyataise. Apwaimaamaati numwihɨ kaatɨ netatɨ sanaati nunyataise. ");
INSERT INTO agm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Saiwɨ Jonɨho Isɨhiyai Baawusisɨhomɨ mɨtɨho nisatauhɨ aimɨ sore tauhɨ komɨ otɨpɨpatɨhiya atisawaayopo. Atiwɨmapɨ napɨwɨ Jonɨhomɨ ambɨpatɨ nesisuwɨ jomaahɨpataatɨhɨ akosɨhaara ahiyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Isɨhiya Autaahaatɨhomɨ pɨwɨha ausaapɨ kaundɨtaatɨwɨ Jisaasiho natausaasisawɨhiya aposerɨhiya japɨhɨ napɨwɨ kiya kiyohɨwaiwaapunɨ amɨ katɨwunjohɨwaiwaapɨ Jisaasihoai kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aihɨ isɨhiya wɨrɨsandɨhandɨ Jisaasihoaapɨhɨ nuwɨ napɨwɨyawaasauhɨ amɨ Jisaasihounɨ komɨ otɨpɨpatɨhiyaunɨ ikɨnɨwɨ nandapa nandaatɨwɨhura apɨpaahɨ owendaise. Saimainjɨhɨ namatɨ Jisaasiho komɨ otɨpɨpatɨhiyai saundataase. “Isɨhiya owehapɨhɨ apɨpaahɨ watɨminɨhapɨhapɨ nehɨ tɨtɨhɨ yawanaanɨ nutɨhaawo amɨ sahɨ mbɨpa baiwɨ nepɨ maarɨho witɨwɨ ikɨndaatɨwo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sata Jisaasiho kaundihɨ kiya atiwɨ nehɨ sawanaahɨ kopuho wotɨ Jisaasihoaisawɨ wapɨhɨ isɨhiya owetatɨ apɨpaahɨ watɨminɨhapɨhapɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Saiwɨ kopuhotɨ niyauhɨ amɨ isɨhiya taahiyɨhiya kiyai iwinjawaayopo. Saiwɨ iwinjaposawɨ isɨhiya taahiyɨhiya aunahɨpɨhaiwa nahatewaaraahapɨhiya Jisaasihoaisawɨhiya niyohɨpɨpɨhapɨ auhɨraapɨhɨ durɨhɨrainɨ wihoaaŋɨ nowaayopo. Numbɨwɨ Jisaasihoaisawɨhiya mehiyauhɨ kiya jɨhɨ nuwɨ noaipapɨ tɨmanɨnɨwɨ bindawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aihɨ Jisaasiho komɨ otɨpɨpatɨhiyaisatɨ kopuhotɨ ipotɨ notɨ tɨmahiyataise. Tɨmahiyatɨ kopuho namasi ko isɨhiya wɨrɨsandɨhandi usonata kiyaapɨ maarɨho aungwohandɨ tundataise amɨ kiya sipɨsipɨhandɨ satɨho owehandamataiwɨhiyaatiho. Aihɨ amɨ ko namasatɨ pɨwɨha taahɨwaiwa kiyai kataunjataise. ");
INSERT INTO agm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Siyatɨ Jisaasiho kataunjihɨ aimɨ ipɨho tipatetɨ namaatipaitandaihɨ komɨ otɨpɨpatɨhiya napɨwɨ koai saundawaatopo. “Kɨmbɨhɨ isɨhiya wɨndɨ bɨmimaawɨ owehapɨhisɨ aimɨ ipɨho notɨ napwɨhataise. ");
INSERT INTO agm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Isɨmiya kɨmiyai nepɨ natɨpusoaase kiya nuwɨ sawana osaataatɨ nandapa niyamahohɨpɨpɨhunɨ amɨ aunahɨpɨhaiwaara yahapɨhɨ detɨ nandapa mmonɨwɨ nawɨho nunyawɨ nepɨ nando,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aihɨ Jisaasiho wihoaaŋɨha komɨ otɨpɨpatɨhiyai saundataase. “Sahɨ sawanaatɨ isɨmiya kɨmiyai nandaatɨwɨhapa nunyawɨse,” undataase. Ko saundihɨ amɨ kiyaamɨha koai saundawaatopo. “O amɨ nyahɨ kiyai napindɨ numwɨtɨhaawe? Kɨnyɨ nyangi natɨpɨnyoaasisamɨhɨ nyahɨ nowa nawɨho ikɨhurɨ yahura nandapa bɨretɨhandɨ nga newa kɨmiya isɨmiyai nga nunya gaamaitaano?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aihɨ Jisaasiho kiyai saundatɨ nunjenataise. “Nandapa bɨretɨhandɨ sahɨ napitaiwɨ isɨpɨhiyaate? Nuwɨ mmonɨwɨse,” undataase. Aihɨ komɨ otɨpɨpatɨhiya nuwɨ kiyaamɨ nandapa bɨretɨhandɨ awɨtɨwɨ mmonawaayopo. Mmonawa bɨretɨhandɨ 5 kiyatɨ ikwɨrɨ naasairɨtihɨ amɨ araiho 2 kiyatɨ yahurɨtihɨ kɨpwɨndihɨ mmonɨwɨmapɨ Jisaasihoai saundawaatopo. “Bɨretɨhandɨ 5 kiyatɨ ikwɨrɨ wihɨtɨhɨrɨtihɨ amɨ araihurɨ 2 kiyatɨ yahurɨtihɨ kɨpwɨndataise,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Saundauhɨ amɨ Jisaasiho komɨ otɨpɨpatɨhiyai saundataase. “Sahɨ isɨmiyai nepɨ tipɨtapaapɨ kɨtarɨhɨraatɨhɨ yatɨhɨ bimɨta kɨhonjɨ kɨhonjaapɨhɨ ahoaiwɨ ahɨwisai nuwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Saiwɨ nepɨ kɨhonjɨ kɨhonjaapɨhɨ ahoyauhɨ amɨ isɨhiya 50 kaiwɨsangi amɨ 100 kaiwɨsangi kɨhonjɨ kɨhonjaapɨhɨ bimai nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Saiwɨ bimauhɨ Jisaasiho nandapa bɨretɨhandɨ 5 kiyatɨ ikwɨ wihɨtɨhɨrɨtihɨ amɨ araihurɨ 2 kiyatɨ yahurɨtihɨ netaise. Netɨ isɨwatata autaahɨ yamɨhapataatɨhɨ jatata sapa nandapaapɨ Autaahaatɨhoai, “Kɨnyɨ gaahoŋe gaare,” undataase. Sata gaare undatosatɨ Jisaasiho bɨretɨhandɨ netɨ naumbotɨ araihoaisatɨ ahoyatɨ komɨ otɨpɨpatɨhiyai nunyataise amɨ kiya nepɨ isɨhiyai nunyawɨ gaamaitaatɨwo. ");
INSERT INTO agm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Nunyawɨ gaamɨhauhɨ isɨhiya siyatɨ ahoyainjɨtɨhandɨ kiyaamɨ maaritohɨrɨhɨretɨ nanɨmbɨwɨ gaata gwɨsɨha yaawihɨ nawɨpɨpa bɨretɨhandɨ araiho kanaahɨpa ahotimbɨpa otɨpɨpatɨhiya asɨwɨ nepɨ ikɨhaiwa 12 kiyahaiwa tisaipɨ kɨpowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sandɨ nandapa bɨretɨhandunɨ amɨ araihounɨ isɨhiya nanɨhohiyɨhiyaamɨ nehɨ usɨhiyaahɨhɨ awɨtauhɨ 5,000 kaiwɨhiyaare. Amɨ asɨhiyaunɨ amɨ manyinyaunɨ wɨndɨ awɨmɨtopo, owetise. ");
INSERT INTO agm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Saiwɨ nandapa nanɨwɨ owetihɨ ketɨ kuraanɨhɨ Jisaasiho komɨ otɨpɨpatɨhiyai tarɨwundatɨ kopuhotɨ yamwaasi durɨhɨraatɨhɨ wihɨnɨ nahaitɨwɨ aunahɨpatɨ Betɨsaitaahandaahapɨ jɨhɨ taawɨ nutaatɨwɨ kaundataase. Iyatɨ ko isɨhiyai kiyaamɨ aunahɨpataahapɨ netɨ natausaasɨtandɨ kapɨhɨ daahɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Siyatɨ isɨhiya nahatiyai natausaasamapɨ Jisaasiho nehɨ sawahohɨhɨ Autaahaatɨhoai pɨwaundatɨ gaapundɨtandɨ sisɨhoaasɨnɨ nasaamanataise. ");
INSERT INTO agm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Aihɨ aimɨ asɨhananaataatɨhɨ Jisaasiho ko taatɨ gaapundimbɨpɨhɨ ikatɨhaatɨ bitonda jata komɨ otɨpɨpatɨhiya aimɨ durɨhɨramɨ otɨhaatɨ kopuhotɨ taawɨ niyauhɨ iwinjataise. ");
INSERT INTO agm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iyatɨ Jisaasiho komɨ otɨpɨpatɨhiyai iwinjata mbɨpa waatɨ mbwaatɨ kiyaisunɨ amɨ kiyaamɨ kopuhoai netɨ kwɨtɨwa ikɨpɨnda tiwandihɨ kiyai bɨpi ahiyawɨ nepɨ taawɨ saihɨra kopuho aisi niyauhɨ iwinjataise. Siyatɨ ko kiyai iwinjatosa kapɨhɨ ikatɨhaatɨ bitonjatɨ aimɨ bowɨtandɨ detɨtihɨ 3 kirokɨhandamunɨ amɨ 6 kirokɨhandamunɨ otɨhamwaaŋɨ Jisaasiho durɨhɨraatɨhɨ itɨpatɨ daimɨ autaahɨ nasataise. Iyatɨ ko kiyai bɨpi nusatipaito tatɨ taatɨ nasataise. ");
INSERT INTO agm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Siyatɨ kiyai nusatipaito tatɨ durɨhɨraatɨhɨ autaahɨ daimɨ napihɨ komɨ otɨpɨpatɨhiya koai ketɨ iwinjawaayopo. Saiwɨ iwinjaposawɨ kiya kopɨ naahɨrisa panaahaise tɨwɨ gwɨnyaawaawɨ kiya yaiwɨ kaahaatawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kiya koai iwinjawaawɨ yayawaayopo. Yayauhɨhandɨ kandɨ amɨ ketɨ kiyai Jisaasiho pɨwaundatɨ saundataase. “Sahɨ wɨndɨ yamaiwɨse. Nɨnɨ Jisaasihonɨnisɨ sahɨ nepɨ andɨtitɨwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Saundamapɨ Jisaasiho kopuhotɨ yamwaatɨ komɨ otɨpɨpatɨhiyaisatɨ maasɨ bindataise. Aihɨ amɨ mbɨpa waatɨ mbwaatɨ itɨpinjɨtɨhandɨ yatɨhitatɨ owendaise. Aihɨ komɨ otɨpɨpatɨhiya apɨpaahɨ awaindɨhandɨ maaroamapɨ yaiwɨmawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Saiwɨ kiya aungwohandɨ maaroamapɨ yaiwɨmahohɨtɨmandɨ amɨ kiyai Jisaasihopɨ wɨndɨ namausesɨpainjɨhe. Iyatɨ amɨ ko watɨpɨhandɨ kiyatɨ bɨretɨhandɨ 5 kiyahandɨ isɨhiya taahiyɨhiyai naumbotɨ numwindɨhandapɨ kiya wɨndɨ gɨmunyaawaawe amɨ Jisaasiho wapa wapa nga kaitaiso tɨwɨ kopɨ wɨndɨ gɨmaawunyaatatɨ namausesɨpainjɨtɨmandɨ kiyaamɨ maarɨho daahɨ nimbɨputawaawe. ");
INSERT INTO agm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Aihɨ kiya durɨhɨraatɨhɨ napɨwɨ yapɨpatɨ Genesaretɨhanda durɨhɨramɨ wihɨnɨ notawaayopo. Notɨwɨ kapɨhɨ kiyaamɨ kopuho yamepata wɨraposawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Saiwɨ Jisaasihotihɨ komɨ otɨpɨpatɨhiyaatihɨ kopuhotapɨ noaatɨpɨhauhɨ isɨhiya taahiyɨhiya aimɨ ketɨ kuraanɨhɨ Jisaasihoai usowɨ iwinjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Saiwɨ iwinjamapɨ yapɨpatɨ Genesaretɨhandamɨ aunahɨpatɨ nahatewaara gaamapɨ ŋihɨti nuwɨ isɨhiya timbɨpa kahatamatɨpetahapaisahiyai gwɨtɨhoaatɨhɨ ahiyawɨ isɨsi wapɨhɨ wapɨhɨ Jisaasiho sapɨhɨ sore tauhɨhapɨhɨ kapɨhɨ numwaasi nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aihɨ nahataapɨpɨhɨ Jisaasiho daimɨ naimbɨpɨhɨ aunahɨpatɨ awaipatɨ taunɨhandaatɨhɨ amɨ gwɨharaahonyaara amɨ osaataatɨ isɨhiya kiyaamɨ naisɨhiya timbɨpaisawɨhiyai aunahɨpa isɨhiya ahoyanɨwɨ nandapa amɨ wapa nunyawɨ nehohɨpɨpɨhɨ maaketɨhandaatɨhɨ numwaasi nasawaayopo. Numwaasi napɨwɨ ahɨwisawosawɨ Jisaasihoai saundawaatopo. “Jisaasihoŋe, isɨhiya timbɨpaisahiya kinyɨ apotɨhɨrɨ giwɨta nehɨ winjase,” undawaatopo. Aihɨ isɨhiya timbɨpaisahiya saiwɨ Jisaasihomɨ apotɨhɨrɨ numwɨhatɨwɨ iwihohiyɨhiya kiyaamɨ timbɨpa owetihɨ noaipapɨ gaahiyaatawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Isɨhiya usa Parisihiyaunɨ amɨ usa Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ Jerusaremɨhandaahapɨ napɨwɨ Jisaasihoai otaatemapɨ ahoyanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bindawa Jisaasihomɨ otɨpɨpatɨhiya usa kiyaamɨ ikwɨrɨ jɨhɨ waapohora bahomusawɨ nehɨ nandapa nanɨhauhɨ kiya usonawaayopo. Saiwɨ kiya kiyaamɨ satoya kiyohɨrɨhɨretɨ japepihɨrɨwɨ ikwɨrɨ nehɨ nɨwipɨhaiwaimaawɨ bausawɨhiyaare. Isɨ Parisihiya kɨretɨ japepihɨrɨwɨ katawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisihiyaunɨ amɨ isɨhiya nahatiya Judaahiyaisangi satoyaamɨ wɨnɨhapɨpa katɨwunjauhɨ nehohɨpɨpa namaamapɨ anɨtiwɨ isɨwatawaayopo. Saiwɨ anɨtiwɨ wɨnɨhapɨpa isɨwatawaahiyaasɨ nandapa nandaatɨwɨhura jɨhɨ ikwɨrɨ bausawosawɨ ipotɨ nandapa isɨpɨ nanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Iyataatɨ amɨ wiwa saiwɨ kaiwɨhiyaare isɨhiya ahoyanɨwɨ nandapa nunyawɨ nawɨho nehohɨpɨpɨhapɨ wapa nawɨho nunyawɨ newaawaahɨ amɨ ikwɨrɨ nandapa ahoyawɨ bausawɨhiyaare. Ikwɨrɨ jɨhɨ bausawosawɨ nandapa nanawaayopo. Iyataatɨ wɨnɨhapɨpa kɨmbaahɨmaahe. Kiya satoyaamɨ wɨnɨhapɨpa nehohɨpɨpa taahɨpɨpaare. Saiwɨ kiya kiyohɨwɨmaiwa saiwa nyaihandɨ onɨha maasanaihɨrɨ kopuho gwaasɨha nawopɨ itatamanɨwɨ tɨwɨhaapɨ bausohɨpatamataiwɨ napaitɨwɨ nɨwipɨhaiwaimaawɨ bausawɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Saiwɨ kaiwɨhiyaasɨ kaiwaapɨ gɨwunyainjɨhɨ kandapɨ namapɨ Jisaasihoai Parisihiyaunɨ amɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ satɨwɨ nunjenawaayopo. “Kinyɨ otɨpɨpatɨmiya asoyaamɨ wɨnɨhapɨpa katɨwɨnyasauhɨ atisa newa japepihɨrohɨpɨpa napaapɨ minjapepihɨropo? Kiya napaapɨ ikwɨrɨ bahomusawɨ kipatisawɨ nandapa nanɨhopo?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aihɨ Jisaasiho wihoaaŋɨha kiyai sata kaundataase. “Sahɨ apɨpaahɨ jaipɨmundatɨ otaatapɨhiyaatapɨ Aisaiyaaho tɨtɨhɨ katise. Iyatɨ ko sapɨ satatɨ jɨpatɨpaise: ‘Isɨmiya kɨmiya nɨngi nehɨ maahomwaaŋapaahɨhunɨ nehɨ pɨwɨhaaraahunɨ nanimaapɨ mepɨ autaahepɨnɨmawaayopo. O amɨ kiyaamɨ maarɨhohɨ nisɨhoaisatɨ nasatɨ wɨndɨ maasɨ tɨmaamaamaitise. Owe. Nehɨ kaanɨhɨ nisapɨ nawisatɨ koai yandɨhɨ ahondaise. Nehɨ isɨhiyaamɨ gwɨnyaahohɨwaiwa nisɨ wɨnɨhapɨpa pɨwɨhaamataiwɨ isɨhiyai katɨwunjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kiya nehɨ sawanaamɨ wɨnɨhapɨpaapɨ kɨmba Autaahaatɨhomɨ wɨnɨhapɨpe tɨwɨ isɨhiyai katɨwunjawaayopo. Saiwɨ kaiwɨhiyaasɨ kiya nisapɨ nehɨ jaiwaiwɨ otaatapɨhaiwa gaapundɨwɨ mepɨ autaahepɨnɨmawaayopo,’ tatɨ Autaahaatɨho Aisaiyaahoai netɨ gɨwunyaasɨhɨ amɨ Aisaiyaaho satatɨ katatɨ jɨpatɨpiyatɨ ahiyataise. ");
INSERT INTO agm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Sahɨ Autaahaatɨhomɨ wɨnɨhapɨpa nepɨ nawisapipɨ nehɨhinemaposawɨ nehɨ isɨhiya gwɨnyaapɨ katɨwunjohɨwaiwa kaiwɨ amɨ kaiwaahɨhɨ japepihɨrɨwɨhiyaate. Aiwɨ amɨ sahɨ isɨhiyai saundɨwɨhiyaate: Kɨmba Autaahaatɨhomɨ wɨnɨhapɨpe undɨwɨhiyaate,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sata kaundatosatɨ amɨ wa saundataase. “Sahɨ nawɨhaiwɨ Autaahaatɨhomɨ wɨnɨhapɨpa nepɨ nehɨhaatemaposawɨ sahɨ isɨhiyai sawanaatamɨ katɨwunjohɨwaiwaahɨhɨ isɨwatɨwɨ kaiwaahɨhɨ japepihɨrɨwɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Autaahaatɨhomɨ wɨnɨhapɨpa Mosesiho jɨpatɨpiyatɨ ahaimbɨpaisangi sahɨ nepɨ asɨretɨ ahiyawɨhiyaate. Mosesiho wɨnɨhapɨpa siyahapa jɨpatɨpiyatɨ ahaimbɨpaapɨto. ‘Kɨniya gapiyaamɨ ambɨpatɨ nɨwimape.’ Aimbɨ amɨ, ‘Kɨniyɨ gapiyai wɨretundɨpɨ maipɨhaiwa kaundapaapaahɨ tɨhɨwisaihɨ napwɨtaape,’ tatɨ ahaihɨhandɨ kandɨ sahɨ satɨwɨ ahiyawɨ katɨwunjawɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Utaaho wo ikɨpɨpa amɨ nawɨho wapa saniyɨ sapiyai numwɨto tatɨ ahaimbɨpaapɨ, ‘Autaahaatɨhoai aimɨ nunyonɨ gaasɨ sainjaahɨ namapɨ owetane,’ undane tɨwɨ katɨwunjawɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Sahɨ saiwɨ wɨnɨhapɨpa asɨretɨ ahiyawɨ katɨwunjauhɨ amɨ utaaho saniyɨ sapiyai nawɨho wapa iwɨtatamanatɨ andɨtɨwiwɨtandɨ numwɨtotahandɨ kandɨ samɨ pɨwɨhaara namumwise. Owe. ");
INSERT INTO agm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sahɨ nehɨ sawanaatamɨ wɨnɨhapɨpa isɨhiyai katɨwunjawaawɨ kandaahɨ Autaahaatɨho pɨwɨha wɨnɨhapɨpa watɨpɨtatɨ katimbɨpa nemawaayopo. Aiwɨ amɨ sahɨ wiwa taahɨwaiwa sɨkiyahaiwa kaiwɨhiyaate,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aihɨ Jisaasiho isɨhiyai japɨhɨ netɨ ahoyatɨ pɨwɨha saundataase. “Isɨhiyaatɨ kɨmiyaatɨ nisɨ pɨwɨha baiwɨ atiwɨ nepɨ gwɨnyaapɨse. ");
INSERT INTO agm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nandapa nehɨhaatapɨ kumbwɨ nepɨ nanɨhingɨpɨpaara kinyɨ omaŋɨtɨtɨhɨ netɨ nangopɨsasatɨ ainjotatɨ maipɨndaamaise. Owetise. Nehɨ isɨhiya kiyaamɨ omaŋɨtɨtɨhɨ mɨmaipaiwɨ maipɨhaiwa gwɨnyapenɨwɨ kiyohɨwaiwaahɨhɨ kiyaamɨ omaŋɨtɨtɨhapɨ ainjotatɨ maipɨhaiwa noaipataise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“Isɨ sahɨ atihɨrisahiyaatisɨ pɨwɨha sa baiwɨ atiwɨ nepɨse” undataase. ");
INSERT INTO agm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Aihɨ Jisaasiho isɨhiyai namasi niyatɨ aŋaaŋɨ nandaasɨhɨ amɨ komɨ otɨpɨpatɨhiya komɨ pɨwɨha sɨwipatɨ katisaapɨ kaamɨ tanyaahaapɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nunjenɨhauhɨ Jisaasiho wihoaaŋɨha kiyai saundataase. “Sahɨ isɨmiya kɨmiyaamataiwɨ wɨndɨ gɨmunyaahowo? Sahɨ wɨndɨ monɨwɨhiyaato? Nehɨ nandapa nanɨhingɨpɨpa kinyɨ maarɨho omaŋɨtɨtɨhɨ netɨ maipɨtatɨ ainjɨmotɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sandɨ kasatotɨmandɨ apaapɨmaasato amɨ nandapaahɨ nainjamɨhɨ notɨ witataatɨhɨ kɨpwɨndisa ahorɨmaitaise. Nandapa kɨnyɨ nanɨhingɨpɨpa kinyɨ maarɨhoaatɨhɨ netɨ maipɨtɨtandɨhandɨ owe.” Amɨ Jisaasiho sandaatɨ, nandapa nahataapa nehɨ gaahapaare wapa isɨhiya wɨndɨ namandaatɨwɨhapa wɨndɨ ahɨmotise. Owe, tatɨ kandaase. ");
INSERT INTO agm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iyatɨ Jisaasiho pɨwɨha onɨhiwatɨ jɨhaatɨ kiyai saundataase. “Isɨhiyaamɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhɨ ainjotatɨ maipɨhaiwa gwɨnyapenɨhohɨwaiwa nehɨhaatɨ ausaimanɨhauhɨ kaiwa isɨhiyaamɨhetɨ ainjotatɨ maipɨndaise. ");
INSERT INTO agm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","23","Isɨhiyaamɨ maarɨhoaatɨhɨ maipɨtatɨ maipɨhaiwa ahotiwaiwa siyahaiwaapɨto: Woho amɨ apopaatɨ usɨhiya amɨ asɨhiya kɨhiya kɨhiyaisawɨ ambɨpatɨ tɨmaamaitɨwɨ amɨ usaamɨhapa ikonɨwɨ amɨ isɨhiya siyɨhiyai timapɨ amɨ woho apopaatɨ komɨ kaatamɨ warɨhoai apwaataati namasi namaatɨnotɨhandɨ nepɨ nopɨsasɨwɨ kɨhaatɨ kɨhoaisawɨ ambɨpatɨ tɨmaamaitɨwɨ amɨ ikɨpɨpa amɨ wapa usaamɨhapaapɨ, ‘Ese sapa nyamɨhapaatane,’ tɨwɨ maaritɨmapɨ amɨ apɨpaahɨ maipɨhaiwa kɨhaiwa kaiwɨ amɨ jaipɨpa kɨpɨwɨ isɨpɨ katɨwɨ amɨ mamaawisawiya maipɨhapa ainjotahapa maaritɨwɨmapɨ kaiwɨ amɨ isɨhiya usaapɨ apousatɨ mandɨtɨpaiwɨ amɨ isɨhiya usaapɨ pɨwɨha maipɨha jaipɨtɨwɨha katɨwɨ amɨ kiya nepɨ sawana genanɨwɨ naimaatɨwɨ amɨ naharimatɨhapa kaiwɨ naharimatahɨretɨ bimaawɨ, saiwa apɨpaahɨ maipɨmaiwa isɨhiyaamɨ maarɨho omaŋɨtɨtɨhapɨ noaipasɨwaiwa kiyai netɨ maipiyausoaasihɨ Autaahaatɨhomɨ ndɨhetɨ kiya noaipapɨ maipɨhiya ainjotahiyaimatawaayopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisaasiho pɨwɨha sata kaundamapɨ aunahɨpatɨ katɨ namasi aunahɨpatɨ awaipatɨ Taiyaahandamɨ amɨ yapɨpata notaise. Notɨ noaipatɨ isɨhiya kopɨ yaho napise nɨwɨ maanondotatɨ aŋɨhandɨ wɨndaapɨhɨ nandaatɨ bɨpi bindataise. Iyataahandɨ kandɨ ko isɨhiyaapɨ wɨndɨ nga namoaatise. Owe. ");
INSERT INTO agm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aihɨ apopaatɨ waatɨ Judaahiyaamɨ dawaapɨpɨhapɨhaatɨ kaatamɨ maataati itɨpɨho maipɨhapa netɨ daahɨ ipɨhatisa timbɨpa numwihɨ bimihɨhaatamɨ sanaatɨ Jisaasihopɨ isɨhiya aimɨ yaho napise tauhɨ atisataise. Atisamapɨ ketɨ ŋihɨti nasatɨ Jisaasihomɨ auhɨraapɨhɨ utatototɨ tɨmahiyataise. ");
INSERT INTO agm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Iyataatɨ saatɨ apopaatɨ Judaahiyaamɨ dawaapɨpɨhapɨhiyaamɨhaatɨ amɨ isɨhiya Pinisiyaahiya Romɨhandamɨ Pɨropinjɨhandɨ Siriyaahanda bimohiyɨhiyaamɨhaate. Isɨ kaatɨ Jisaasihoai gousetɨ kaatamɨ maataatamɨhetɨ itɨpɨho maipɨho bimisɨhoai nematɨ tahamanausoaasɨtandɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aihɨ Jisaasiho kaati wihoaaŋɨha saundataase. “Manyinyaamɨ nandapa bɨretɨhandɨ newaatɨ suhɨri numwɨtɨhaawɨ sandɨ tɨtɨhɨmaahe. Owe. Jɨhɨ manyinya kiyaamɨ maaritɨwɨ gwɨnyaahohɨrɨhɨretɨ nanɨwɨ ngaatɨtande,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ko saundihɨhandɨ kandɨ amɨ apopaatɨ kaatamɨha Jisaasihoai saundataase. “Ye, Awaisɨhoŋe, amɨ suhɨrɨsangi nandapa bɨretɨhandɨ manyinya nanawaawɨ naumbwɨwɨmɨhauhɨ mwɨtisɨha nawɨpɨpa ganɨhomɨ otɨtɨhɨ tɨmɨhaimbɨpa netɨ nanataise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aihɨ Jisaasiho kaati saundataase. “Amɨ kɨnyɨ pɨwɨha wihoaaŋɨha gaaha kandinga sɨkaasɨ gaasɨ numwe. Amɨ kinyɨ metɨhaatamɨhetɨ itɨpɨho maipɨho bimisɨho aimɨ kaati numwasi naise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jisaasiho kaati sata kaundihɨ kaatɨ atisamapɨ japɨhɨ kaatamɨ aŋɨpɨpɨhapɨ notaise. Notɨ mmonata kaatamɨ maataati itɨpɨho maipɨho netɨ ipɨhatisa bimisɨho aimɨ noaipasi naihɨ metɨhaatɨ gaahaatɨ betɨhɨretɨ nanototihɨ sanaatɨ usonataise. ");
INSERT INTO agm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Aihɨ Jisaasiho kapɨhɨ Taiyaahanda namasi aunahɨpatɨ Saitonɨhandaahihoaaŋɨ notaise. Notɨ aunahɨpatɨ Ikwɨ Maindɨmohata (Dekaporisihanda) noaipasi durɨhɨrɨ Garirihandainɨhɨra notaise. ");
INSERT INTO agm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aihɨ isɨhiya utaaho wo komɨ atihɨrɨ naputatɨ amɨ biyatɨ pɨwaamaatatɨ mehɨtatɨ pɨwaatahoai numwasi nasawaayopo. Numwaasi napɨwɨ Jisaasiho utaasoai ikwɨrɨ ahɨwisatɨ atihɨrɨ amɨ maahomwaaŋɨ tɨtɨhemwaitandɨ gɨwusoepɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aihɨ Jisaasiho koai numwasi isɨhiya taahiyɨhiyaapɨ yandɨhɨ nawisatɨ wapɨhɨ notɨ bitotama atɨhomaahɨpɨhomɨ atihatɨmuropɨ isundɨpɨho ahɨwisatɨ amɨ komɨ isundɨpɨho maahoairisatesi komɨ omasɨhetɨ iwiwataise. ");
INSERT INTO agm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Siyatɨ utaamopɨ maarɨho asɨpiyataatɨ awaindɨhandɨ maarisatɨ komɨ omasɨhai numwɨhatatɨ iwiwatataatɨ yamɨhapataatɨhɨ jatata awaindɨ mbɨpa netɨ maarisatɨ sandaase, “Epata,” ndaase. Sandɨ tanyaaha satatise, “nawatahatɨpɨ nutɨpɨ nausaate,” ndaase. ");
INSERT INTO agm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sata Jisaasiho kaundihɨ ketɨ kuraanɨhɨ utaasomɨ atihɨrɨ nurɨwatatatɨ amɨ komɨ omasɨha usaayatɨ gaatihɨ nga atisatɨ amɨ pɨwɨha nga biyatɨ pɨwandaase. ");
INSERT INTO agm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aihɨ kapɨhɨ isɨhiya ahoyanɨhohiyɨhiyai Jisaasiho saundataase. “Kɨmandɨ nɨnɨ kiyonɨhɨ sahɨ mmonɨhohɨtɨmandapɨ isɨhiya usaisɨ sahɨ wɨndɨ apɨpaahɨ kamundɨmapɨse. Apɨpaahɨ owetane,” undatɨ kiyai kaundataase. Sata mɨtaahɨ bapiya kaundihɨhandɨ kandɨ amɨ kiya mwɨtetɨwɨ pɨwɨha ka nesi mɨtaahɨ kanɨwɨ gaamawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Isɨhiya kapɨhɨ Jisaasiho kaiwaiwa mmonɨhohiyɨhiya satawaatopo. “Kamaitaahetahaiwaisangi Jisaasiho nahataapa nga kiyataise. Kiyatɨ isɨhiya atɨhomaahɨpɨhiyaamɨ atihɨrɨ nurɨwatasɨhɨ nga atiwɨ amɨ pɨwaamaatisohiyai maahomwaaŋɨ nɨwusoaasɨhɨ nga pɨwaatawaayopo,” tɨwɨ apɨpaahɨ awaindɨhandɨ aatɨwɨmawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Aihɨ amɨ sura isɨhiya wɨrɨsandɨhandɨ napɨwɨ Jisaasihoaisawɨ maasɨtawaawɨ amɨ kiya nandapa nandaatɨwɨhapa owehiyaare. Saimainjɨhɨ namatɨ Jisaasiho komɨ otɨpɨpatɨhiyai gaatatɨ numwaatɨ saundataase. ");
INSERT INTO agm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kɨmiya isɨmiyaapɨ nɨnɨ maarɨho asɨpiyataayo amɨ kiya nɨngisawɨ maasɨ kɨmbɨhɨ asisɨha 3 kiyatɨ mairɨ manyetɨ bimauho. Aiwɨ amɨ kiya nandapa nandaatɨwɨhapa wapa mipɨ owehiya nehɨ taanahiyɨhiya napɨwɨhiyaaso. ");
INSERT INTO agm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Amɨ nɨnɨ kiya japarɨhiyai kiyaamɨ aŋɨpɨpɨhapɨ nandusoaasisanaahɨ amɨ daihɨra itipɨ wonɨwonɨwinɨhonɨhɨ tɨmɨhaitaapo. Amɨ kiyaamɨ usa apɨpaahɨ kaanɨhapɨ napɨwɨhiyaaso,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aihɨ komɨ otɨpɨpatɨhiya Jisaasihoai saundawaatopo. “Nyahɨ aunahɨpa awaiwaiwa taunɨhandamɨ apɨpaahɨ kaanɨhɨ bindɨhaayonɨ isɨmiya kɨmiya taahiyɨmiyai nandapa bɨretɨhandɨ napitiyaatɨ maahapɨhapɨ newaatɨ numwɨtɨhaawe?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aihɨ Jisaasiho komɨ otɨpɨpatɨhiyai saundatɨ nunjenataise. “Sahɨ nandapa bɨretɨhandɨ napitaiwɨhandɨ isɨpɨhiyaate?” undataase. Siyatɨ nunjesɨhɨ amɨ kiya koai saundawaatopo. “Bɨretɨhandɨ 7 kiyahandɨ isɨwaahiyaane,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aihɨ Jisaasiho isɨhiya nahatiya woyɨhaatɨhɨ yatɨhɨ yapɨpatetɨ bimɨtaatɨwɨ kaundataase. Siyatɨ kaundatosatɨ ko bɨretɨhandɨ 7 kiyahandɨ netɨ isɨwatata Autaahaatɨhoai, “Kɨnyɨ gaahoŋɨ iparɨhoŋe gaare,” undatɨ bɨretɨhandɨ naumbwotɨ tipɨtapaataise. Siyatɨ naumbwisonyonya komɨ otɨpɨpatɨhiyai nunyataise amɨ kiya nepawɨ isɨhiyai nunyawɨ gaamaitaatɨwo. Aihɨ amɨ kiya nesi isɨhiya nahatiyai gaamapɨ nunyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aiwɨ amɨ Jisaasihomɨ otɨpɨpatɨhiya araiho wonya isɨpɨhiyaare. Aihɨ Jisaasiho araihonyaapɨ Autaahaatɨhoai, “kɨnyɨ gaahoŋɨ iparɨhoŋisɨ gaare,” undatosatɨ komɨ otɨpɨpatɨhiyai numwihɨ amɨ kiya nepawɨ isɨhiyai nunyawɨ gaamawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kaihɨ isɨhiya nahatiya nandapa sapa nanɨwɨ gwɨsɨmwɨwɨ gandaise. Saiwɨ nanɨwɨ gaatihɨ nawɨpɨpa ahotimbɨpa otɨpɨpatɨhiya koai nɨwipinjawɨ ko kaiwaiwa mmonɨwɨ nepɨ kiyohiyɨhiya asɨwɨ nepɨ ikɨhaiwa 7 kiyahaiwaara kɨpɨwɨ tisaahɨwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Isɨhiya nandapa sapa nanɨhohiyɨhiya nahatiya 4,000 kaiwɨhiyaare. Aihɨ kiya nandapa nanɨwɨ owetihɨhura Jisaasiho kiyai kiyaamɨ aŋɨpɨpɨhapɨ netɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Natausaasamapɨ ketɨ kuraanɨhɨ Jisaasiho komɨ otɨpɨpatɨhiyaisatɨ kopuhotɨ yamwaasi aunahɨpatɨ Darɨmanutaahandaahapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Notɨ noaipasɨhɨ Parisihiya usa napɨwɨ Jisaasihoaisawɨ pɨwɨhaara pwɨsɨpataahamataiwɨ nepɨ tunnɨwɨ kanɨwɨ pɨwanawaatopo. Pɨwanɨwɨ kiya koai saundawaatopo. “Nyahɨ kinyapɨ koai akɨtɨnɨhɨ Autaahaatɨho natausaasihɨ nasahoe taatɨ mmonaatɨ gwɨnyaitaanɨ kɨnyɨ watɨpɨhandɨ wɨndɨ nyamɨ ndɨhetɨ kaime,” undɨwɨ nunjenawaayopo. Sandɨ tɨtɨhɨ akɨtɨnɨhɨ kiya nunjenawaamaayopo. Owetise. Nehɨ jaiwaiwɨ amɨ ko wipiyonaahɨ amɨ kiya koai wapa kawitaatɨwɨ jatawa jaiwaiwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Saiwɨ nunjenɨhauhɨ Jisaasiho komɨ maarɨho apɨpaahɨ naaŋawihɨ maarɨho dɨtɨhɨrɨ aungwohandɨ maarisatɨ noaamatɨ sandaase. “Sahɨ napaapɨ watɨpɨtɨwɨmapɨ nɨngi sandɨwɨ, ‘Kɨnyɨ watɨpɨhandɨ kaime, nyahɨ mmondaano,’ ndɨwɨ nanɨsenɨhopo? Nɨnɨ sangisɨ apɨpaahɨ akɨtɨnɨhɨ sandɨ kasatataato. Sahɨ mmondaatɨwɨ watɨpɨhandɨ nɨnɨ wɨndɨ kamaito owetɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sata kaundamapɨ Jisaasiho komɨ otɨpɨpatɨhiyai numwasi kopuhotɨ yamwasi durɨhɨrɨ nahaitatɨ wihɨnapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jisaasihomɨ otɨpɨpatɨhiya nandapa wapa mmonɨwɨ nepɨ isɨpɨ namuwɨ kiya nanɨpimatɨwɨ nehɨ taanahiya nowaayopo. Aiwɨ bɨretɨhandɨ nehɨ naasaindɨhɨ isɨsi nuwɨhandisɨ kopuhotɨ kandɨhɨ ahotihɨ mmonawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aihɨ Jisaasiho komɨ otɨpɨpatɨhiyai pɨwɨha watɨpɨha sata kaundataase. “Sahɨ baiwɨ jaawo. Parisihiyaamunɨ Erotɨhomunɨ kiyohɨwaiwaapɨ jaawo amɨ kaiwa yisɨhandamatiyahaiwaaso. Kiya kiyohɨwaiwa nandapa bɨretɨhandɨ nipitandɨhandɨ ahiyauhɨ nandapa bɨretɨhandɨ kaitaatɨwɨ dohandi waatɨ netɨ nipindɨhandamatiyahaiwaasɨ kaiwa samɨhetɨ nasatɨ osamatɨ nasamanɨtaisɨ sahɨ baiwɨ jaawo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aihɨ Jisaasihomɨ otɨpɨpatɨhiya sawana sanawaatopo. “Nyahɨ bɨretɨhandɨ owetihɨ kandapɨ sandɨ Jisaasiho nyangi kanyatataase,” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aihɨ Jisaasiho kiya kanɨwɨ gwɨnyaahohɨtɨhandɨ usonataatɨ kiyai saundataase. “Nyahɨ bɨretɨhandɨ owetihɨnyase tɨwɨ sahɨ saiwa napaapɨ gwɨnyapenɨhopo? Sahɨ sangɨ wɨndɨ mmonɨwɨ gɨmaasunyainjo? Samɨ amɨtɨha maasinjapwaatatɨ nisaputamaso? ");
INSERT INTO agm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Sahɨ ndɨhaisahiyaatɨndaahandɨ kandɨ baiwɨ wɨndɨ mohopo. Sahɨ atihɨrisahiyaatɨtawaahandɨ kandɨ sahɨ wɨndɨ atiwɨ namehopo. Sahɨ baiwɨ gwɨnyaapɨse, nɨnɨ kiyohɨpɨpaapo. ");
INSERT INTO agm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nɨnɨ isɨhiya 5,000 kaiwɨhiyai nandapa bɨretɨhandɨ 5 kiyahandɨ naumbwɨtɨ nunyohuraapɨ sangi wɨndɨ gɨmaasunyainjo e owo? Nawɨpɨpa isɨhiya nanɨwɨ ahotimbɨpa ikihɨ napitaiwɨhihɨ nepɨ kɨpopo?” undatɨ nunjenataise. Aihɨ amɨ kiya koai saundawaatopo. “Ikihɨ 12 kiyawaahihɨ nyahɨ asawa newaatɨ kɨpohaayo,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Saundauhɨ amɨ Jisaasiho jɨhaatɨ kiyai saundataase. “Isɨhiya 4,000 kaiwɨhiyai kaatɨha bɨretɨhandɨ 7 kaindɨhandɨ naumbwɨtɨ nunyonɨhɨ nanɨwɨ gaatihɨ nawɨpɨpa ahotimbɨpa sahɨ asɨwɨ nepɨ ikihɨ napitaiwɨhihɨ nepɨ kɨpopo?” undatɨ nunjenataise. Aihɨ amɨ kiya koai saundawaatopo. “Ikihɨ 7 kiyahiha asawa newa kɨpohaayo,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Saundauhɨ amɨ Jisaasiho kiyai saundataase. “O amɨ sangi sangɨ gisunyaatatɨ amɨ sangɨ nasesɨpainjo?” undataase. ");
INSERT INTO agm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Aihɨ Jisaasihounɨ komɨ otɨpɨpatɨhiyaunɨ napɨwɨ aunahɨpatɨ Betɨsaitaahanda noaipawaayopo. Napɨwɨ noaipɨhauhɨ utaaho wo komɨ ndɨha niyotahoai komɨhiya numwaasi nasawaayopo. Numwaasi napɨwɨ Jisaasiho komɨ ndɨhaatɨhɨ ikwɨrɨ ahɨwisatɨ nusorɨhaitandɨ gɨwusoepɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aihɨ Jisaasiho utaaho ndɨha niyotisɨhoai ikwɨra iwisi aunahɨpatamɨ ipaahaapɨ noaipapɨ mangɨrainɨ akɨrepepɨ notɨ bitondaise. Notɨ bitondaatɨ Jisaasiho utaahomɨ ndɨha niyotisɨhotɨ maahoaipatɨ maahoaipurɨwatɨ ikwɨrɨ ahɨwisatɨ saundataase. “Kɨnyɨ wanɨ wapai nga usonapaino?” undataase. ");
INSERT INTO agm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aihɨ ko ndɨha niyotisɨho naingaatɨ jatɨ Jisaasihoai saundataase. “Ye, nɨnɨ isɨhiyai iwinjataayo. Iwinjataahandɨ kandɨ kiya ipatɨ nesɨwesɨwa daayataahatamataiwɨ daayauhɨ nɨnɨ iwinjataayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aihɨ Jisaasiho jɨhaatɨ komɨ ikwɨrɨ uta ndɨ niyotisɨhomɨ ndɨhaatɨ ahɨwisataise. Aihɨ ko komɨ ndɨha waatɨ nusorɨhaatatɨ gaatihɨ nahataapai nga biyatɨ mmonataise. ");
INSERT INTO agm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisaasiho koai saundataase. “Kɨnyɨ aunahɨpataahapɨ wɨndɨ namumbwɨ kɨnyɨ kinyɨ aŋɨpɨpɨhapɨ tɨtɨhɨ numwe,” undatɨ netɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisaasihounɨ amɨ komɨ otɨpɨpatɨhiyaunɨ aunahɨpatɨ gwɨharaahonya aunahɨpatɨ awaipatɨ taunɨhandɨ Sisariya Piripaihanda ahetiwaiwaaraahapɨ daimɨ nowaayopo. Saiwɨ kiya taawɨ daimɨ nowaawɨ Jisaasiho kiya komɨ otɨpɨpatɨhiyai sata nunjenataise. “Nisapɨ isɨhiya diyaamahoe tawaatopo?” undatɨ kiyai nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aihɨ komɨ otɨpɨpatɨhiya wihoaaŋɨha koai saundawaatopo. “Kinyapɨ isɨhiya usa Jonɨho Isɨhiyai Baawusisɨhoe tawaatopo. Aiwɨ amɨ usa Eraijaahopɨ japɨhɨ nasatete tawaatopo. Aiwɨ amɨ usa satawaatopo. Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya pɨropetɨhiyaamɨ wore tawaatopo,” undɨwɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Saundauhɨ Jisaasiho kiyai sata nunjenataise. “O amɨ sahɨ nisapɨ diyaamahoe tɨwɨ gwɨnyapenawaayopo?” undatɨ nunjenataise. Aihɨ Pitaaho koai saundataase. “Kɨnyɨ Kɨraisihoŋe,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aihɨ Jisaasiho kiyai saundataase. “Sahɨ nisapɨ isɨhiyai Mesaiyaahoe undɨwɨ wɨndɨ kamundɨwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aihɨ Jisaasiho namasatɨ komɨ otɨpɨpatɨhiyai sata kataunjataise. “Autaahaatɨhomɨ Isɨhiyaamɨ Saahonɨnɨ Awaisɨhonɨnɨ Jɨhonɨhi ambɨpatɨ yaasɨhandɨ awaindɨhandɨ nanɨmɨtaapo. Aiwɨ Judaahiyaamɨ aunɨhiya gwɨnyaahiya jɨhiyaunɨ amɨ Pɨrisihiyaamɨ awaisawɨhiya jɨhiyaunɨ amɨ wɨnɨhapɨpa katɨwunjohiyɨhiya nɨngisɨ ahosɨnɨmaitaapo. Aiwɨ nisapɨ poundonɨhɨ sohonɨhi nɨwisaihɨ napwɨto. Napotatɨ asisɨha mairɨmanya saniyonɨhɨ nɨnɨ asohonɨnimandɨ japɨhɨ anɨmwaahɨpatombɨ nepaito,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Koai nusoaipaitandɨhapaapɨ Jisaasiho komɨ otɨpɨpatɨhiyai tɨtɨhɨ ausaatɨ kaundataase. Aihɨ Pitaaho Jisaasihoai nawɨsatɨ numwaasi notɨ yandɨhɨ bitotama koai nuwisapuwatɨ saundataase. “Awaisɨhoŋe, kɨnyɨ satɨpɨ wɨndɨ kamaatɨme. Owetane,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amɨ Jisaasiho nepemaitatɨ komɨ otɨpɨpatɨhiyai iwinjataise. Winjatata Pitahoai sɨretɨ ko katirɨhɨretɨ sata kamaatɨtandɨ kaundataase. Iyatɨ koai Jisaasiho pɨwɨha watɨpɨha sata kaundataase. “Bwaasɨrɨhɨraŋe, kɨnyɨ nɨngisɨ nanɨmasi nawɨsapitɨpɨ kɨraŋɨnɨhɨ numbwɨmape. Kɨnyɨ Autaahaatɨho maaritatɨ gwɨnyaasɨpɨpaapɨ wɨndɨ gɨmunyaahise. Kɨnyɨ nehɨ isɨhiya maaritɨwɨ gwɨnyaahohɨrɨhɨretɨ gwɨnyaapaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Saundatosatɨ isɨhiya wɨrɨsandɨhiyaisatɨ komɨ otɨpɨpatɨhiyai gaatatɨ numwaatɨ netɨ naasaimbɨpɨhɨ ahoyataise. Ahoyatosatɨ kiyai saundataase. “Amɨ isɨhiya nɨngisɨ nanipinjɨtaatɨwaahɨ kiya sawanaamɨ maaritohɨwaiwai ahosumapɨ kaiwaanɨhɨ namamapɨse. Kiya nɨngi nanipinjɨtaatɨwɨ kiya sawana nga itatatamaŋɨnɨwɨ bimɨtaatɨwɨhandɨ kandɨnɨhɨ namamapɨse. Namamapɨ ipɨ tɨtɨ atawɨhatɨ nepɨ isɨwɨ nanipinjawɨse. ");
INSERT INTO agm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Amɨ utaaho wo sawaho wanɨ biyatɨ nga bimɨtandɨhandapaahɨhɨ andɨtatɨ napamataataahɨ ko ipotɨhura konɨhɨ nɨngisatɨ maasɨ bimɨtandɨhandɨ nihɨratɨ namaitaise. O amɨ utaaho wo nisapimatonɨhunɨ amɨ nisɨ pɨwɨha gaaha wanɨhaapimatonɨhɨ ko sawaho biyatɨ nga bimɨtandɨhandɨ nihɨratɨ namatɨ amɨ napotaataahɨ ko ipotɨhura nga nɨngisatɨ konɨhɨ jinjapɨhɨ asohoematatɨ bimɨtandɨhandɨ naitaise. ");
INSERT INTO agm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Iyataatɨ amɨ utaaho wo maapɨ yapɨpatambɨhaiwa nahatewa kohesayanatɨ netaatɨ kandaahɨ ko ipotɨhura asɨtimatatɨ konɨhɨ jinjapɨhɨ bimɨtandɨhandɨ nihɨrataataahɨ amɨ akɨtɨndɨ napindɨ nunyatɨ ko asɨtimatatɨ bimɨtandɨhandɨ naitaise? Apɨpaahɨ owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Siyatɨ ko asohoematatɨ bimɨtandɨhandɨ nihɨratɨ owetanɨhɨ ko nawɨho nga nunya komɨ maarɨho asɨtimatatɨ bimɨtandɨhandɨ wɨndɨ japɨhɨ namaitaise. Apɨpaahɨ owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Isɨhiya wanɨ kɨmura bimohiyɨmiya maipɨhandɨ apɨpaahɨ tisaitatɨ amɨ apɨpaahɨ maipɨhura bindawaayopo. Isɨ amɨ isɨhiya nisapɨ mawonaahɨ amɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Awaisɨhonɨnɨ Jɨhonɨnɨ nisɨ Apɨhomɨ watɨpɨhandɨ nausainjɨtɨhandaatɨhɨ yamɨhapataatɨhapɨ Autaahaatɨhomɨ enjerɨhiya otɨpɨpatɨhiyaisatɨ nasataahura kiyaapɨ nɨngisɨ manyonɨhɨ kiyai ahosumwaito,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisaasiho kiyai sata kaundatosatɨ amɨ wa saundataase. “Nɨnɨ sangisɨ akɨtɨnɨhɨ sandɨ kasatataato. Isɨhiya kɨmiya wanɨ kɨmbɨhɨ bitohohiyɨmiya usa sangɨ napwisaihɨ Autaahaatɨho isɨhiyai iwinja bimindɨhandɨ watɨpɨhandisa noaipahonɨhɨ mmondaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Asisɨha aimɨ 6 kiyatɨ sanaihɨhura Jisaasiho Pitaahoaisunɨ Jemɨsihoaisunɨ Jonɨhoaisunɨ numwaasi sisɨho utaarɨhoaasɨnɨ nasaamanataise. Aihɨ kasɨnɨ sisɨhoaasɨnɨ nehɨ sawanaahɨhɨ bitotawaayopo. Aihɨ kingwaasamɨ ndɨhetɨ ketɨ Jisaasihomɨ ambɨpatɨ wipetahatɨ noaipataise. ");
INSERT INTO agm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Iyatɨ amɨ komɨ utɨ apotɨhɨrɨ noaipatɨ nehɨ kɨhoepɨ taanahɨtɨndaise. Iyatɨ utaaho wo maapɨ yapɨpatambɨho wapaara bausanatɨ bausonɨhɨ siyatɨ wɨndɨ kɨhoepɨmetɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Aihɨ kingwaasɨ jawa Eraijaayɨ Mosesiya kiyaamɨ ndɨhetɨ noaipapɨ Jisaasihoaisamɨ maasɨ taamɨ pɨwaatinjɨhɨ otɨpɨpatɨhingwaasɨ winjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Aihɨ Pitaaho Jisaasihoai saundataase. “Katɨpɨnyasingɨhoŋe, nyahɨ gaanɨhɨ kɨmbɨhɨ bindɨhaayonɨ aŋɨhaiwa gohaparɨhaiwa nausarisaatɨ maurɨmandɨ aŋɨmatɨtaano. Waaŋɨ kinyapɨtanɨhɨ, waaŋɨ Mosesihopɨtanɨhɨ amɨ waaŋɨ Eraijaahopɨtanɨhɨ nyahɨ aŋɨmatɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pitaahounɨ Jemɨsiyɨ Joniyaunɨ apɨpaahɨ aungwohandɨ waatɨ yayawaawɨ amɨ pɨwɨha wa Jisaasihoai kaundɨtɨha owetihɨ namatɨ sandɨ Pitaaho kandaase. ");
INSERT INTO agm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Aihɨ tɨwipatɨ wɨtɨ nasatɨ kingwaasi netɨ napapɨhatɨ namaasamataise. Aihɨ katɨ tɨwipataatɨhapɨ pɨwɨha wa Autaahaatɨho Jisaasihopɨ katihɨ sataha noaipataise. “Kɨmo Nisɨ Maasɨhɨho Akohotihɨ Nɨnɨ Koai Maarɨho nunyatɨ wɨwitɨhosɨ ko pɨwɨha kasatonɨha baiwɨ atɨwiwɨse,” taha noaipataise. ");
INSERT INTO agm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aihɨ kingwaasɨ pɨwɨha sa atiwosawɨ ketɨ ketɨ nepemainanɨwɨ jawaahandɨ kandɨ isɨhiya usaisɨ maawinjahopo, nehɨ Jisaasiho sawahohɨhɨ bitosɨhɨ iwinjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sandɨ siyatɨ noaipasɨhɨ mmonɨwɨ atiwɨmapɨ japɨhɨ sisɨho koaasɨnɨ namasi noaatɨpawaawɨ Jisaasiho kingwaasi saundataase. “Sahɨ sisɨmoaasɨnɨ kɨmandɨ noaipasɨhɨ mmonɨhohɨtɨmandapɨ isɨhiyai saimainje undɨwɨ apɨpaahɨ wɨndɨ kamundɨwɨse. Kamundɨwɨ bimambɨwɨ Nɨnɨ Autaahaatɨhomɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ Awaisɨhonɨnɨ napomatatɨ japɨhɨ nepasanɨhura sandapɨ isɨhiyai sahɨ ausaapɨ kaundɨtaatɨwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aihɨ kingwaasɨ komɨ otɨpɨpatɨhingwaasɨ Jisaasiho kaundisɨha atiwɨ nepɨ kaundirɨhɨretɨ japepihɨrawaayopo. Saiwɨ kiyawaahandɨ kandɨ Jisaasiho, “Nɨnɨ japɨhɨ anɨmwaahɨpatombɨ nepaito,” undisɨhaapɨ wɨndɨ namausesɨpainjɨhɨ kaamɨ tanyaaha ko napindapɨnyatindɨho? Nɨwɨ kanawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aihɨ kingwaasɨ Jisaasihoai satɨwɨ nunjenawaayopo. “Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiya Eraijaahopɨ ko jɨhɨ napɨtaise tɨwɨ napindapɨ katopo?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aihɨ Jisaasiho wihoaaŋɨha kiyai sata kaundataase. “Ye, mandɨhɨ akɨte. Kiya akɨtɨ tɨtɨhɨ katawaatopo. Eraijaaho kahapaamapɨpa netɨ japɨhɨ tɨtɨhemaitandɨ ko jɨhɨ napɨtaise. Iyataahandɨ kandɨ Autaahaatɨhomɨ Isɨhiyaamɨ Saaho Jɨho Awaisɨho yaawɨhandɨ awaindɨhandɨ pɨhɨtatɨ naitaise. Iyatɨ amɨ isɨhiya koai nehɨ wapaamataiwɨ, ‘mmopɨ nɨwɨsapɨ nemapɨ ahosumwapɨ pohipɨwitaapo,’ tatɨ Autaahaatɨhomɨ pɨwɨhaatɨhɨ napaapɨ jɨpatɨpindise? ");
INSERT INTO agm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nɨnɨ sangi akɨtɨnɨhɨ sandɨ kasatataato. Eraijaahohɨ aimɨ napise. Aimɨ napihɨ amɨ isɨhiya koai kawitaatɨwɨ maaritohɨpɨpa kɨretɨ aimɨ kawisopo amɨ Autaahaatɨhomɨ pɨwɨha katatɨ jɨpatɨpindirɨhɨretɨ japepihɨrɨwo,” undatɨ Jonɨho isɨhiyai baawusisɨhopɨ gwɨnyaataatɨ sa pɨwɨha kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aihɨ Jisaasiho Pitaaho Nemɨsiho amɨ Jonɨho Jisaasihomɨ otɨpɨpatɨhiya usenda japɨhɨ napɨwɨ nɨwipaawaayopo. Napɨwɨ iwinjawa isɨhiya apɨpaahɨ kiyai otaatemapɨ bitotawa amɨ wɨnɨhapɨpa katɨwunjohiyɨhiya pɨwɨhaara pwɨsɨpataahamataiwɨ tunnɨwɨ kanɨhaunɨ iwinjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aihɨ Jisaasiho aimɨ nasa noaipasɨhɨ isɨhiya wɨrɨsandɨhiya winjaposawɨ waatɨ yaiwɨpwitawaayopo. Waatɨ yaiwɨpwitɨwɨmapɨ ketɨ dosi ŋuhɨti detɨ Jisaasihoaapɨhɨ nuwɨ, “Aimɨ soŋɨ nasapaino?” undɨwɨ pɨwaundawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Aihɨ Jisaasiho komɨ otɨpɨpatɨhiyai sata nunjenataise. “Sahɨ kɨmiya isɨmiyaisawɨ pwɨsɨpataahamataiwɨ pɨwɨhaara napaapɨ tunnɨhopo?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aihɨ isɨhiya wɨrɨsandɨhiyaamɨ otɨhatɨhapɨ utaaho wo dotatɨ Jisaasihoai saundataase. “Katɨpunjingɨhoŋe, nɨnɨ nisɨ maasɨhɨhoai gisenda numwaasi nasataayo. Itɨpɨho maipɨho komɨhetɨ bindata timbɨpa nunyatɨ komɨ pɨwɨha nematɨ maahomwaaŋɨ netɨ nɨwisapusɨhɨ amɨ ko pɨwɨha biyatɨ wɨndɨ pɨwaamaatiho. ");
INSERT INTO agm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Iyataatɨ kɨmo nisɨ metɨmoai itɨpɨho maipɨho nahatewetɨ siyatɨ isɨwatataatɨ koai netɨ waatɨ maahutatɨ yapɨpatetɨ netɨ tusaataise. Sawihɨ nisɨ metɨmo komɨ maahomwaaŋɨ mipatetɨ sisipa maahoairɨhɨrɨ nasatɨ noaamatɨ amɨ mangɨrɨ netɨ sawaho ikwɨnatɨ ikɨtɨhɨtisataise. Iyatɨ amɨ komɨ ambɨpatɨ tɨhɨrotɨpɨtatɨ yahamipɨndaise. Aihɨ wanɨ nɨnɨ koai kinyɨ otɨpɨpatɨmiyaapɨhɨ kiya koai tɨtɨhɨwiwɨtondɨ numwaasi nasataayo. Numwaasi kiyaapɨhɨ nasonɨhandɨ kandɨ kiya metɨmomɨhetɨ itɨpɨho maipɨho bimisɨhoai wɨndɨ nga nemaamahopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aihɨ Jisaasiho pɨwɨha sa atisatosatɨ isɨhiya wɨrɨsandɨhiyaisunɨ komɨ otɨpɨpatɨhiyaisunɨ saundataase. “Ese, sahɨ isɨmiyaatɨ nisapɨ wɨndɨ gɨmaanunyaahopo. Nɨnɨ sangisatɨ napitiyahaiwaara maasɨ bindataatɨ kaindɨsasɨtande? Napitaindɨhaiwaara bindata samɨ naaŋiwaiwa netɨ awɨsɨtɨmapɨ notoaatɨtande? So metɨhoai nɨngisaapɨhɨ numwaasi napɨwisono!” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aihɨ kiya metoai numwaasi Jisaasihoaapɨhɨ nasawaayopo. Aihɨ itɨpɨho maipɨho Jisaasihoai usonataatɨ yayatɨ ketɨ kuraanɨhɨ metoai netɨ yapɨpatetɨ maahuta wonamaatɨhɨ tusaataise. Aihɨ metɨho nehaatatɨ tɨwaapananatɨ ahonda sisipa maahoairɨhɨrɨ kiyataise. ");
INSERT INTO agm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aihɨ Jisaasiho metomɨ sapɨhoai sata nunjenataise. “Kinyɨ metɨmo napitiyahaiwaara kɨmiyatɨ kiyataise?” undatɨ nunjenataise. Aihɨ metomɨ sapɨho Jisaasihoai wihoaaŋɨha sata kaundataase. “Metɨho sangɨhohuraape. ");
INSERT INTO agm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Iyataatɨ amɨ wiwetɨ itɨpɨho maipɨho nisɨ metɨmoai sohoai tiwamaitotatɨ sisɨhaapɨhɨ netɨ tɨhoaatɨ amɨ osetetɨ netɨ tɨmandaatɨ kiyatoandaise. Isɨ amɨ kɨnyɨ ganaahɨ metɨmoai wapa kawimbɨ yaindaanyangisɨ kinyɨ maarɨho asɨpɨnyime,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Aihɨ Jisaasiho metɨhomɨ sapɨhoai saundataase. “Kɨnyɨ nɨngi sandapaase. ‘Kɨnyɨ gaatanaaho, ndapaase.’ Ye, nɨnɨ nge. Kɨnyɨ nisapɨ gɨnunyaapaapaahɨ amɨ kɨnyɨ nisapɨ gɨnunyaahingɨtɨhanda nahataapa taatɨ nanɨhiyatɨ kɨnyɨ gɨnunyaahingɨrɨhɨrɨ kɨretɨ noaipaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aihɨ ketɨ kuraanɨhɨ metomɨ sapɨho waatɨ kaahaata saundataase. “Jisaasihoŋe, kinyapɨ kɨmo metɨmoetɨ itɨpɨho maipɨho bimisɨho nga nemaitaise ndɨ nɨnɨ gɨhunyaataayo. Saindɨ gɨhunyaataahandɨ kandɨ nisɨ kinyapɨ gɨhunyaahohɨtɨhandɨ wonjɨ nenoaahɨtonɨ kɨnyɨ nepɨ andɨtɨnipe kinyapɨ nɨnɨ gɨhunyaahohɨtɨhandɨ noaipatɨ watɨpɨtɨtando,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Aihɨ Jisaasiho jata isɨhiya taahɨtɨhandɨ kapɨhɨ nihɨti nasauhɨ itɨpɨho maipɨhoai pɨwɨha watɨpɨha saundataase. “Kɨnyɨ itɨpɨ maipɨhoŋɨ isɨhiyaamɨ atihɨrɨ nepɨ nɨwisapuhɨnɨhɨ pɨwɨha atɨhomiwɨ amɨ maahomwaaŋɨ nepɨ nɨwisapuhɨnɨhɨ pɨwaamaatohɨhoŋe, kɨmo metɨmomɨhetapɨ noaipasi koŋɨnɨhɨ numwe. Kɨnyɨ japɨhɨ nambɨ komɨhetɨ namɨndaape. Koŋɨnɨhɨ numbwɨmape,” undatɨ itɨhundatɨ tahamanatɨ nemataise. ");
INSERT INTO agm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aihɨ itɨpɨho maipɨho waatɨ kaahaatatɨ noaipasi notataahetɨ metɨhoai netɨ waatɨ kɨsɨhɨsisa kwaanɨhoaaniya yotamapɨ noaipasi notaise. Siyatɨ itɨpɨho maipɨho metɨhoai netɨ yotindɨhandapɨ metɨho kwaapanɨmaasatɨ napomataahomatiyatɨ yapɨpatetɨ ahondaise. Aihɨ isɨhiya taahiyɨhiya mmonawaawɨ metɨho aimɨ napomataise tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Iyauhɨ amɨ Jisaasiho metɨhomɨ ikwɨrɨ iwiwatɨ tɨtɨhɨwisɨhɨ ko nepatɨ dotɨ tɨtɨhɨ bitondaise. ");
INSERT INTO agm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Siyatɨ Jisaasiho kiyamapɨ aŋaaŋɨ nandaasɨhɨ komɨ otɨpɨpatɨhiya nehɨ sawanaahɨhɨ Jisaasihoaisawɨ bindawa koai saundɨwɨ nunjenawaayopo. “Nyahɨ napindapɨ itɨpɨho maipɨho soai nga wɨndɨ newaamaamaho?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aihɨ Jisaasiho kiyai wihoaaŋɨha saundataase. “Itɨpɨho maipɨho setahoaisaahɨ nehɨ gaapɨpataahɨhɨ nga nemaitaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Aihɨ Jisaasihounɨ komɨ otɨpɨpatɨhiyaunɨ kapɨhɨ aunahɨpa namasi Garirihandaahɨra kandɨ Garirihandamɨ otɨhapɨhɨ daimɨ nowaayopo. Aiwɨ Jisaasiho isɨhiyaapɨ sawahopɨ aimɨ yamo napise nnawa napɨwɨ usondaatɨwɨhandapɨ wɨndɨ maarɨmitise. ");
INSERT INTO agm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Amɨ sandɨ apaapɨmaahe, komɨ otɨpɨpatɨhiyai taatɨ kataunjataate. Iyatɨ amɨ ko komɨ otɨpɨpatɨhiyai saundataase. “Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ Awaisɨhonɨngi isɨhiya tiworisaamɨ ikwɨraatɨhɨnɨmasaihɨ amɨ kiya nɨngi sohonɨhi nɨwɨtaapo. Nɨwisaihɨ napomatatɨ anɨmwaahɨpatombɨ asisɨha mairɨma saniyonɨhɨ japɨhɨ asohonɨnimandɨ nepaito,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Isɨhiya yaasɨhandɨ naninyawɨ nusaihɨ napomatatɨ asisɨha mairɨma saniyonɨhɨ japɨhɨ anɨmwaahɨpatombɨ nepaito undisɨmaapɨ komɨ otɨpɨpatɨhiyai wɨndɨ gɨmaawunyaatatɨ namausesɨpainje. Siyatɨ namausesɨpainjɨhandɨ kandɨ kiya Jisaasihoai nunjendaatɨwɨhandapɨ yayawaawɨ nesɨpapɨ kanyate undɨwɨ koai wɨndɨ namunjenɨhopo. ");
INSERT INTO agm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Aihɨ Jisaasihounɨ komɨ otɨpɨpatɨhiyaunɨ aimɨ Kapaniyaamɨhanda noaipapɨ aŋaaŋɨ nandaapɨ bindawaawɨ Jisaasiho komɨ otɨpɨpatɨhiyai sata nunjenataise. “Daihɨra nyahɨ taawa nasɨhaawɨ sahɨ akɨtɨndɨ napindapɨ pɨwɨha wihɨwihoaaŋɨ kanɨmɨ nasopo?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Aihɨ kiya wihoaaŋɨha sapaapɨ katɨhaato undɨwɨ wɨndɨ kamundopo. Amɨ wihoaaŋɨha kamundohɨtɨmandɨ amɨ kiya daihɨra wihɨwihoaaŋɨ sanɨwɨ, “nyamɨmatɨhapɨ diyaamaho awaisɨhore?” nɨwɨ kanɨwawɨhandɨtihɨ namapɨ kiya yatɨhitawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisaasiho yatɨhɨ bindata komɨ otɨpɨpatɨhiya 12 kaiwɨhiyaasɨ kiyai gaatatɨ detɨ komɨhinɨ ahoyatosatɨ ko kiyai saundataase. “Samɨ wo noaipatɨ jɨhoematɨtandaahɨ so isɨhiya nahatiyaamɨ nehɨ ipotɨhoematatɨ amɨ isɨhiya nahatiyaamɨ yatɨhɨ otɨtɨhɨ nehɨ otɨpɨpatɨhoematatɨ otɨpɨpatɨ kiyane,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sata kaundatosatɨ Jisaasiho metɨhonjɨ wonji numwaatɨ kiyaamɨ ndɨhetɨ otɨhapɨhɨ ahɨwihɨ bitondaise. Bitosɨhɨ konji komɨ ikwɨraatɨhɨ numwaatɨ isɨwatataatɨ kiyai saundataase. ");
INSERT INTO agm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Utaaho wo metɨhonjɨ kɨmonjamatiyahonjɨ amɨ nisapimatonɨhɨ wonjɨ metɨhonji numwaatɨ iwɨtatamanataataahɨ so nɨngi nanɨmaataise. Iyatɨ amɨ nɨngisɨ wo nanɨmaatɨ nɨtatamaso so amɨ nɨngisɨ nanɨmaataamaise amɨ nɨngisɨ natanoaasisɨhoai numwaataise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Aihɨ Jonɨho Jisaasihoai saundataase. “Katɨpɨnyasingɨhoŋe, utaaho wo namaanyipinjaho kinyɨ ambɨpataahɨ itɨpɨho maipɨhoai utaaho womɨhetapɨ taatɨ tahamana nemasɨhɨ nyahɨ usonɨhaawɨ kɨnyɨ saimbɨ kamaime undaatɨ itɨhunda nimbɨpuwɨhaayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Amɨ Jisaasiho koai saundataase. “Sahɨ napaapɨ nɨwimbɨpuwawaawe nehɨ iwinjasawɨse kiyatɨ kaito. Amɨ utaaho wo nisɨ ambɨpata watɨpɨhaiwa wiwa kaisɨho so nisapɨ ketɨ maipɨha wɨndɨ kamaatɨtaiso,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","“Isɨhiya usa nyangi nyaipɨndɨwɨ nepɨmaanyamahohiyɨhiya siya amɨ nyamɨ naisɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nɨnɨ sangisɨ apɨpaahɨ akɨtɨnɨhɨ sandɨ kasatataato, utaaho wo sangi jasonataatɨ kɨmiya Kɨraisihomɨhiyaaso tatɨ nehɨ waapohoaisangi nasamisɨho soai amɨ nɨnɨ wihoaaŋɨhandɨ gaahandɨ nawɨhomataindɨ numwisanɨhɨ ko naitaise. ");
INSERT INTO agm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Amɨ isɨhiya nisapɨ wanɨ namasawɨ taawɨ gɨnunyaahohiyɨhiya kiya manyinyaamataiwɨhiyai utaaho wo maipɨhandɨ sangɨ kiyaunjonɨhɨ amɨ koai nepɨ jɨhɨ nawɨha aungwohandɨ apɨpaahɨ naaŋɨhandɨ komɨ naahutarɨhɨraapɨhɨ wɨrapɨ nahemaposawɨ durɨhɨraatɨhɨ nepɨ tɨmandaasaihɨ nawatisatɨ napotaataahɨ ngaatɨtaise. Autaahaatɨho koai yaawɨhandɨ wɨndɨ namumwɨtando. ");
INSERT INTO agm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Amɨ kinyɨ ikwɨrɨ maipɨhandɨ kɨnyɨ kaitaapɨhandaatɨhɨ angisi niyonaahɨ gaasɨ ketɨ kuraanɨhɨ kɨrisɨ tisatɨmape. Ikwɨrɨ nehɨ naasairɨsapɨ asohoŋimatɨtaapɨhandɨ nga naitaapo. Amɨ wiwa ikwɨrɨ maindɨmurisapɨhoŋɨ opaimbɨ sisɨha kaanɨhɨ namaayotatɨ tɨhatoaatisɨhaapɨhɨ numbwɨ tɨhoaatɨtaino. ");
INSERT INTO agm_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Amɨ sapɨhɨ kiya maatɨmaatɨhiyaamɨ pindɨpɨho noaamatɨ kiyaisɨnɨhɨ nisatoaapatɨ nanɨmɨ notoaatɨtaise. Iyatɨ amɨ sisɨha wɨndɨ namaayotatɨ kaanɨhɨ tɨhatɨ kiyai tɨhɨmɨ notoaatɨtaise.) ");
INSERT INTO agm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Iyataatɨ amɨ kinyɨ auhɨrɨ maipɨhandɨ kaitaapɨhɨra nangɨmaasi niyonɨhɨ kɨnyɨ maipɨhandɨ kiyapaapaahɨ amɨ kɨrɨ tisatɨmape. Amɨ kɨnyɨ saimbɨ ambɨpatɨ wihoaaŋɨhatɨ tisatɨpɨ nehɨ wihoaaŋɨhatisahoŋɨ asɨtimatɨtaapɨhandɨ nepɨ nga bimɨtaapo amɨ wiwa ambɨpatɨ nahatepɨsapɨhoŋɨ sisɨhaapɨhɨ nutaino. ");
INSERT INTO agm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Amɨ kinyɨ ndɨha maipɨhandɨ kaitaapɨhɨra nangɨmaasi niyonɨhɨ kɨnyɨ maipɨhandɨ kiyapaapaahɨ amɨ gaasɨ kinyɨ ndɨha wa namwaapɨ yotɨme. Ndɨha nehɨ naasaisapɨhoŋi Autaahaatɨho gisɨ biyatɨ ginjaatɨ bimɨtando amɨ wiwa ndɨha maiwɨsapɨ opaimbɨhongi nepɨ sisɨhaapɨhɨ yangotɨtaawo. ");
INSERT INTO agm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Iyataatɨ sapɨhɨ sisɨhaapɨhɨ pindɨpɨho isɨhiyai pindɨpoaamatɨ nainjɨho wɨndɨ namaapotɨ amɨ sisɨha isɨhiyai tɨhatoaatisɨha wɨndɨ namaayotatɨ kaanɨhɨ tɨhatoaatɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Isɨhiya nahatiya sorɨho sapɨpa nandapaatɨhɨ ahiyauhɨ amɨ nandapa nga jɨpiyataise. Isɨ sɨrɨ kɨretɨ sisɨha isɨhiyaamɨ omaŋɨtɨtɨhɨ maipɨhaiwa ahotiwaiwa tɨhamahonɨhɨ kiyaamɨ omaŋɨtɨtɨhɨ tɨtɨhɨtatɨ popɨtɨtɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Iyataatɨ sorɨho sapɨpa sapa gaahape. Gaahapandaahandɨ kandɨ sapɨpaamɨ jɨpaindɨhandɨ nupwɨhoaatatɨ owendaataahɨ sahɨ japɨhɨ jɨpaindɨhandɨ napitaiwɨ nepɨ ahaitaapo. Isɨ amɨ sahɨ sapɨpaamɨ jɨpaindɨhandɨ samɨhetɨ netɨ tisaitonɨhɨ amɨ sahɨ ususaatɨ bɨpi napaisaatɨ bimaawɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Aihɨ Jisaasiho sapɨhɨ namasi yapɨpatɨ Judiyaahanda notaise. Notɨ yapɨpatɨ Judiyaahanda waapɨhaatɨ Jorɨtaanɨhaatɨ nahaitatɨ kaanɨhɨ notaise. Aihɨ isɨhiya taahiyɨhiya wɨrɨsandɨhandɨ koai usonɨwosawɨ napɨwɨ ahoyanɨhauhɨ Jisaasiho komɨhatɨ kiyatɨ namasatɨ Autaahaatɨhomɨ pɨwɨha ausaatɨ kiyai kataunjataise. ");
INSERT INTO agm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aihɨ Parisihiya usa napɨwɨ Jisaasihoai pɨwɨha wa nehɨ jaiwaiwɨha ko napitɨtɨha kanyatise tɨwɨ iwinjatawa namasawɨ saundɨwɨ nunjenawaayopo. “Nyamɨ wɨnɨhapɨpa napondaase? Utaaho wo komɨ apwaataati nemaitandɨ sandɨ tɨtɨho e tɨtɨhɨmaaho?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Aihɨ Jisaasiho kiyai wihoaaŋɨha saundataase. “Mosesiho wɨnɨhapɨpa napitɨtɨhapa nasanyataise,” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aihɨ kiya wihoaaŋɨha saundawaatopo. “Mosesiho satise ‘Utaaho apwaataati namataataahɨ kaati aimɨ namataayo tatɨ utɨpɨho jɨpatɨpiyatɨ nunyatɨ nematɨ natausaasane,’ tatɨ katise,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aihɨ Jisaasiho komɨha kiyai saundataase. “Sahɨ maatɨmaatiwɨ wɨretɨtɨwɨ Autaahaatɨhomɨ pɨwɨha katasɨsimbɨpa atɨhomiwɨ daahɨ nisaputɨwɨ watɨpɨtauhɨ Mosesiho sapa wɨnɨhapɨpa katatɨ jɨpatɨpiya ahiyataise. ");
INSERT INTO agm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amɨ jɨhɨ wuwanɨhura Autaahaatɨho kahapaamapɨpa kiyatɨ ahaisura, ‘wohoaisunɨ amɨ apopaatisunɨ kiyatɨ ahiyataise,’” tatɨ pɨwɨha katise. ");
INSERT INTO agm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Isɨ amɨ woho saniyɨ sapiyaisɨ namasi notɨ apwaataatisatɨ tɨmaamaitɨtande. ");
INSERT INTO agm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Saimɨ tɨmaamaitamaamɨ kasanyurɨ noaipapɨ ambɨpatɨ yandɨhɨ yatɨwɨtamaamaise. Owe. Kasanyurɨ noaipapɨ ambɨpatɨ nehɨ naasaipatisahasanyure.’ ");
INSERT INTO agm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iyataatɨ kasanyuri Autaahaatɨho netɨ maasɨ tɨmaamahɨwataise. Isɨ utaaho wo netɨ kasanyuri tɨmaawipɨtapaane,” undatɨ Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jisaasiho kiyai sata kaunda namɨhaasɨhɨ ipotɨhɨ aŋɨpɨpɨhapɨ japɨhɨ nowaayopo. Nuwɨ bindawa komɨ otɨpɨpatɨhiya Jisaasihoai pɨwɨha isɨhiya namaatɨnohiyɨhiya tipɨtapaatotɨhandapɨ katisɨhaapɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aihɨ Jisaasiho kiyai saundataase. “Utaaho komɨ apwaataati namatosatɨ amɨ waati netɨ wɨrataataahɨ so komɨ apwaataatɨ jɨhaati netɨ maipɨhandɨ kawɨsataise. Iyatɨ amɨ kasanyuramɨ namaatinjɨtɨhandɨ netɨ nopɨsasataise. ");
INSERT INTO agm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Iyataatɨ amɨ apopaatɨ waatɨ warɨhoai namasi notɨ woai namaatataataahɨ kasanyuramɨ namaatinjɨtɨhandɨ netɨ nopɨsasatɨ maipɨhandɨ kiyataise,” undatɨ komɨ otɨpɨpatɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Isɨhiya usa metɨhonyai numwaasi nasawaayopo konyai Jisaasiho saundatɨ, “Sangisɨ Autaahaatɨho gaahandɨ kasisane,” undatɨ komɨ ikwɨrɨ ahɨwisatɨ gaahandɨ numwɨtotɨwo. Aihɨ Jisaasihomɨ otɨpɨpatɨhiya kiyai itɨhundɨwɨ nɨwisapuwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Aihɨ Jisaasiho isɨhiyai komɨ otɨpɨpatɨhiya itɨhundɨwɨ nɨwisapuhotɨhandɨ mmonata kandapɨ ko wɨndɨ maarɨmitatɨ apowihɨ ko kiyai saundataase. “Sahɨ metɨhonyai nepɨ namaawisapupɨse. Nehɨ iwinjasawɨse, kiya nɨngisenda kaiwɨ napɨto. Amɨ isɨhiya kɨmonyaamataiwɨhiyai Autaahaatɨho nga iwinjatɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nɨnɨ sangisɨ akɨtɨnɨhɨ sandɨ kasatataato, metɨhonya wapa nehɨhapa nunyauhɨhapa nanɨhaiwɨ nehohɨpatamataiwɨ isɨhiya Autaahaatɨho kiyai iwinjatɨtandɨ metɨhonyaamataiwɨ kopɨ wɨndɨ gɨmaawunyaahohiyɨhiyai ko wɨndɨ maawinjatɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sata Jisaasiho kiyai kaundatosatɨ metɨhonyai numwaatɨ komɨ ikwɨra namaahatata nahatonyai kiyaamɨ mɨtɨhoaatɨhɨ ikwɨrɨ ahɨwisatɨ urɨpatisatɨ saundataase. “Autaahaatɨho sangisɨ gaahandɨ kasisane,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisaasiho sapɨhɨ namasatɨ taatɨ namasisɨ naihɨ utaaho wo ŋuhɨti nasatɨ Komɨ utatototɨ tɨmahiyatɨ komɨ atotɨpatɨ atotɨpɨwesatɨ bindata sata nunjenataise. “Katɨpunjingɨhoŋɨ gaahoŋe, nɨnɨ napitiyataatɨnɨhɨ gaahandɨ asɨtimatɨtandɨhandɨ netɨ nasisoaarɨ bimɨtande?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Siyatɨ ko nunjesɨhɨ Jisaasiho koai wihoaaŋɨha sata kaundataase. “Nɨngi kɨnyɨ napaapɨ gaahoŋe ndɨpɨ kandise? Nehɨ Autaahaatɨhohɨhɨ gaahoso. ");
INSERT INTO agm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kɨnyɨ wɨnɨhapɨpaamɨ pɨwɨhaapɨ aimɨ gwɨnyaapɨhoŋe. Wɨnɨhapɨpa sandaase. ‘Sahɨ isɨhiya usaisɨ wɨndɨ siyɨhiyai timaamapɨse. Sahɨ namaatɨwɨhiyaatɨ usɨhiya asɨhiya usa samɨ sɨwaasisa amɨ samɨ sɨwoyaametahiyaisawɨ ambɨpatɨ wɨndɨ tɨmaamaamaitɨwɨse. Sahɨ isɨhiya usaamɨhapa ikomaanɨwɨse. Isɨhiya pɨwɨha atiwɨ nepɨ tipɨtapaapɨ mmonɨhohiyɨhiyaapɨhɨ sahɨ pɨwɨha usaapɨ jaipɨtɨwɨha kamaatɨwɨse. Sahɨ usaisɨ jaipundɨwɨ kiyaamapa nawɨho amɨ wapa wapaisangi aipɨ namausepɨse. Sahɨ samɨ sɨniya japiyaamɨ pɨwɨha atɨwiwɨ kiyai nepɨ autaahɨ isɨwatɨwɨse,’ tatɨ wɨnɨhapɨpa ahondaise,” undatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aihɨ ko Jisaasihoai saundataase. “Katɨpɨnyasingɨhonye, nɨnɨ metɨhonɨnɨhuraapɨ sapa wɨnɨhapɨpa nahataapa japepihɨrɨmɨ napɨtɨ wanɨ kɨmurandaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Aihɨ Jisaasiho koai tɨtɨhɨ iwinjatataatɨ maarɨho nunyatɨ maarɨho wɨwiwatɨ koai saundataase. “Kɨnyɨ wɨnɨhapɨpa nga japepihɨrapaahandɨ kandɨ nehɨ naasaindɨhɨ wɨndapaahɨhɨ nenoaahɨtapaise. Isɨ wanɨ numbwɨ kinyɨ ikɨpɨpa kahapaamapɨpa nahataapa nepɨ isɨhiya usaisɨ nunyapɨ nawɨho nepe. Nunyapɨ nawɨho nepɨ isɨhiya ikɨpɨpa apɨpaahɨ owehatɨmai nawɨho ko nunye. Kɨnyɨ saimbɨ kiyapaapaahɨ kinyapɨhaiwa apɨpaahɨ gaahaiwa yamɨhapataatɨhɨ ahisotɨtaise. Numbwɨ saimbɨ kaimbɨmapɨ nambɨ nɨngi nanipinje,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aihɨ ko Jisaasiho pɨwɨha kaundisɨha atisataatɨ namatɨ mandɨropatatɨ wɨndɨ maarɨmitatɨ maarɨho naaŋawisaho notaise, amɨ ko ikɨpɨpa taahɨpɨpaisahondaato. ");
INSERT INTO agm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Siyatɨ ko aimɨ naihɨ Jisaasiho komɨ otɨpɨpatɨhiyai gaamatɨ winjatataatɨ kiyai saundataase. “Isɨhiya ikɨpɨpa asaketahiya Autaahaatɨho iwinjatɨtandɨhandaatɨhɨ napɨwɨ nandaitaatɨwɨ apɨpaahɨ naaŋamaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aihɨ Jisaasiho pɨwɨha sata kaundihɨ kiya komɨ otɨpɨpatɨhiya atisawaawɨ waatɨ aungwohandɨ yaiwɨmapɨ gwɨnyapenawaayopo. Saiwɨ yaiwɨpwitauhɨ amɨ Jisaasiho kiyai jɨhaatɨ saundataase. “Nisɨ metɨhonyaate, utaaho wo Autaahaatɨho iwinjatindɨhandaatɨhɨ nandaitandaisɨhoai amɨ koai Autaahaatɨho iwinjatɨtandɨ apɨpaahɨ kimbimatatɨ naaŋamataise. ");
INSERT INTO agm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sandɨ utaaho wo ikɨpɨpa asaketahoai Autaahaatɨho iwinjaatɨ bimɨtandɨ apɨpaahɨ watɨpɨtatɨ naaŋamatɨ nɨwipɨndaise. O amɨ Kamerɨhandɨhɨ jaatɨhɨramɨ daundirɨhɨra wɨndɨ namitanatɨ wɨndɨ napasɨpasinatɨ kamaayatɨ nga nanɨhiyatɨ napaisaatɨ nandaasi nutaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Aihɨ ko Jisaasiho sata kiyai kaundihɨ, kiya komɨ pɨwɨha atisawaawɨ maarɨho owetihɨ yaiwɨ waatɨ gwɨnyaawaayopo. Saiwɨ waatɨ gwɨnyaawaawɨ kiya sawana sanawaatopo. “O siyonaahɨ, utaaho nɨnapitiyahoai Autaahaatɨho japɨhɨ numwaatɨ asɨtimatɨtandɨhandɨ numwɨtaise?” nɨwɨ nasenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Aihɨ Jisaasiho komɨ otɨpɨpatɨhiyai tɨtɨhɨ iwinjatata kiyaamɨ nasenɨhohɨhaapɨ wihoaaŋɨha saundataase. “Sandɨ apɨpaahɨ naaŋɨhandisɨ isɨhiya kiyaamɨ maaritɨwɨ andɨtitotɨhanda namwaipaitaise, owetɨtaise. O Autaahaatɨhohɨ ngaatɨtaise. Isɨ Autaahaatɨhohɨ komɨ maaritatɨ gwɨnyaasɨrɨhɨretɨ katonɨhɨ nahatewa nga noaipaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aihɨ amɨ Pitaaho pɨwɨha wa Jisaasihoai saundataase. “Nyangi nyasome! Nyahɨ nyamɨ kahapaamapɨpa isɨwasohɨpɨpa namasisɨ gi nangipinjai nasahaayono,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Aihɨ Jisaasiho komɨha pɨwɨha kiyai saundataase “Nɨnɨ akɨtɨnɨhɨ sangi sandɨ kasatataato. Isɨhiya usa nisapimatatɨ amɨ nisɨ pɨwɨha isɨhiya usaisɨ ausaapɨ kaundɨtaatɨwɨhandapimatonɨhɨ kiyaamɨ aŋaaŋɨ saingɨho saahoai sanasɨhiyai saniya sapiyai mwaaya maatiyai osaataatɨ namasi naisaihaahɨ, amɨ Autaahaatɨho nanɨpimatɨ waatɨ ambɨpatɨ owehaiwa wihoaaŋɨhaiwa pɨhɨtatɨ numwɨtaise. Siyatɨ wanɨ kɨmaapɨ yapɨmbataapɨhɨ waatɨ aŋaaŋɨ saingosaahoya sanasɨhiya saniya mwaaya maatiya osaataatɨ waatɨ naitaise. Iyatɨ amɨ isɨhiya koai naaŋɨhaiwa numwɨtaapo. Isɨ siyatɨ kaisɨho amɨ ipotɨhura gaahandɨ asɨyaimatɨwɨ jinjapɨhɨ jinjapɨhɨ bimɨtaatɨwɨhandɨ naitaise. ");
INSERT INTO agm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Isɨ isɨhiya taahiyɨhiya wanɨ kɨmura noaipapɨ jɨhimatohiyɨhiya ipotɨhura kiya noaipapɨ ipotɨhiyaimatɨtaapo. Iyonɨhɨ amɨ isɨhiya wanɨ kɨmura noaipapɨ ipotɨhiyaimatohiyɨhiya ipotɨhura kiya noaipapɨ jɨhiyaimatɨtaapo,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Aihɨ Jisaasihotihɨ komɨ otɨpɨpatɨhiyaatihɨ daihɨra taawɨ daimɨ niyawaayopo, amɨ kiya aunahɨpa Jerusaremɨhandaahapɨ niyawaawo. Aihɨ Jisaasiho komɨ otɨpɨpatɨhiyai ipotema ko kiyaamɨ jɨhɨ daimɨ niyataise. Iyataatɨ amɨ komɨ otɨpɨpatɨhiyai yawihɨ yaiwɨ niyawaayopo. Aihɨ amɨ isɨhiya usa ipotɨ nɨwipinjai niyohiyɨhiyaisangi waatɨ yayawaayopo. Aihɨ Jisaasiho komɨ otɨpɨpatɨhiya 12 kaiwɨ ikwɨmaindɨmwɨtihɨ auhɨramɨ yahurɨtahiyaisaahɨhɨ yandɨhɨ nawisaiwa numwaatɨ koai wapa Jerusaremɨhanda nusoaipahonɨhɨ amɨ isɨhiya komɨ ambɨpatetɨ yaawɨhaiwa nunyawɨ kawitaatɨwɨhaiwaapɨ nɨngi sanitaapo undatɨ saundataase. ");
INSERT INTO agm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Sahɨ nisɨ pɨwɨma atɨniwɨse. Nyahɨ wanɨ taawa Jerusaremɨhandaahapɨ niyahaayo. Isɨ kapɨhɨ Jerusaremɨhanda nɨnɨ Autaahaatɨhomɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ Awaisɨhonɨnɨhi nipɨ nanɨmaapɨ pɨrisihiya isɨhiya isɨhiyaapɨ Autaahaatɨhoai nandapa tɨhɨwɨ dɨpumanɨhohiyɨhiyaamɨ mɨtɨhiyaamunɨ amɨ wɨnɨhapɨpa Katɨwunjohiyɨhiyaamɨ ikwɨraatɨhɨnɨmasaihɨ nɨnɨ napwɨtandɨhandapɨ kiya pɨwɨha nepɨ nisɨhetɨ yanutaapɨ, ‘Kɨnyɨ wɨnɨhapɨpa nemapainɨ napope,’ ndɨwɨ pɨwɨha wɨsasɨtaapo. Saiwɨ pɨwɨha wɨsasawɨ isɨhiya Judaahiyaamɨ dawaapɨpɨhɨ bimohiyɨhiyaamɨ ikwɨraatɨhɨnɨmaitaapo. ");
INSERT INTO agm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Saiwɨ kiya nɨngi nepɨ kiyaamɨhetɨnɨmasaihɨ amɨ kiya tiworisa nɨngi sisɨpɨhɨndɨwɨ maahoaipɨnupwɨ amɨ irɨhɨra maahwɨtɨwɨ nɨndipapɨ amɨ sohonɨngi nɨwisaihɨ nɨnɨ napwɨto. Napomatatɨ ipotɨ asisɨha mairɨma saniyonɨhura asohonɨnimandɨ japɨhɨ nepaito,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aihɨ Jepetihomɨ mwaahurɨ Jemɨsiyɨ Joniya namɨ detɨ Jisaasihoai saundamaase. “Katɨpɨnyasingɨhonye, kɨnyɨ yɨhoaanyangi wapa kanyitaapɨhandapɨ gisɨ nangɨsendɨhaawiyo,” undamaase. ");
INSERT INTO agm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Aihɨ Jisaasihomɨha wihoaaŋɨha kuri saundataase. “Nɨnɨ sɨhoaasangi napindɨ kasitande?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aihɨ kuramɨha wihoaaŋɨha gwɨnyaasɨha Jisaasihoai saundamaase. “Ipotɨhura kɨnyɨ kinyɨ gaahaiwa sisɨhaamatiyatɨ otiwa kaumbwaatɨ isɨhiyai nɨwusainjɨtɨhandaatɨhɨ kinyɨ ganɨho gaahoaasɨnɨ ambɨpatɨ wandɨha awaisɨha nepɨ isɨhiyai iwinjatapaahura kɨnyɨ yɨhoaanyangi kanyatisamɨhɨ kinyatiyaha ambɨpatɨ amɨ wandɨha awaipatɨ neha wonɨnɨ kinyɨ ikwɨrɨ gaatɨhɨraihoaaŋɨtanɨhɨ amɨ wonɨnɨ kinyɨ ikwɨrɨ konaamohihoaaŋɨ gisaha isɨhiyai iwinjaaha bimɨtɨhaawɨto,” undamaase. ");
INSERT INTO agm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aihɨ Jisaasihomɨha wihoaaŋɨha kuri saundataase. “Sahuraahɨ sa pɨwɨma nɨngisɨ nanɨsepɨ kandisaapɨ wɨndɨ baimɨ gɨmunyaapɨ monɨmɨhuraahe. Owetise. Nɨnɨ yaasɨhandɨ waapoho sawinjɨho ipɨho yahohomatiyahandɨ nandandiyohɨtɨhandɨ sahuraahɨ nga nɨngisamɨ maasɨ maingwanaanɨnɨ newaatɨ nandaano? Iyataatɨ isɨhiya waapɨhaatetɨ nandaahauhɨ waapɨhaatɨ nurɨmaasasɨpatamatiyatɨ nɨngi yaasɨhandɨ awaindɨhandɨ siyatɨ nanɨmaasaitaise. Isɨ siyatɨ yaasɨhandɨ nanɨmaasahonɨhɨ sɨhoaahɨ kandɨ nisɨ maarɨho ambɨpatɨ nahandɨ yaasindɨhandaatɨhɨ maasɨ maingwanaanɨnɨ nandaasaihɨ maingwanaanangi ahoyatɨ nanyamaasaitaiso?” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aihɨ kurɨ saundamaase. “Ye, yɨhoaanyangisangi kɨnyɨ naaŋɨhandɨ kinyɨ ambɨpatɨ amɨ maarɨho nahatoŋɨ yaasahandɨ naitaapaingɨwɨmaiwaamaahɨ amɨ kiyaha naito,” undamaase. Aihɨ Jisaasiho komɨha wihoaaŋɨha kuri saundataase. “Akɨtɨnɨhɨ sɨhoaahɨ nga waapoho nandandiyohɨho nanɨmɨ amɨ yaasatɨ naaŋɨhandɨ nɨngi waapɨhaatamatiyatɨ nanɨmaasaitandaindɨmandɨ sɨhoaasangisangi nga nasamaasaitaise. ");
INSERT INTO agm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nasamaasahonɨhandɨ kandɨ nɨnɨ sɨhoaasangisɨ woŋɨ nisɨ ikwɨrɨ gaatɨhɨraihoaaŋɨtanɨhɨ amɨ woŋɨ konaamohihoaaŋɨtanɨhɨ nɨngisapɨ woŋɨ otɨpɨpatɨ satɨ kaimbɨ amɨ woŋɨ satɨ kaime satɨtandɨhandɨ sandɨ nisɨhandɨmaahe. Owetise. Sandɨhɨ Autaahaatɨhomɨhande. Autaahaatɨhomɨhandisɨ isɨhiya satɨ otɨpɨpatɨ amɨ aunahɨpa naitaatɨwe tatɨ netɨ tɨmanatɨ namɨhanatɨ kiyaapɨ gwɨnyaasawɨhiyai numwɨtaise. Nunyatɨ ahɨwitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aihɨ amɨ otɨpɨpatɨhiya sasaahoya ikwɨmaindɨmwɨ 10 kaiwɨhiya kurɨ Jisaasihoai saundɨmɨ nunjesɨhaapɨ atisawaawɨ kiyai Jemɨsiyɨ Joniyaapɨ apousataise. ");
INSERT INTO agm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Aihɨ Jisaasiho komɨ otɨpɨpatɨhiya nahatiyai numwaatɨ detematosatɨ ko pɨwɨha sata kaundataase. “Sahɨ kɨmandɨ aimɨ mmopɨ gwɨnyaapɨhiyaate. Isɨhiya usa Judaahiyaanamɨ dawaataatapɨhiyaamɨ mɨtɨhiya awaisawɨhiya isɨhiyaisɨ iwinjaawɨ bindawaawɨ nyahɨ awaisawɨhiyaaniso tɨwɨ maaritɨwɨmapɨ wandɨha ambɨpatɨ awaipatɨ nunjawɨ kiyaamɨ isɨhiyai nepɨ urɨpatiwɨ otɨpɨpatɨ aungwohaiwa kimbimatahaiwa waatɨ nunyawaayopo. Aiwɨ amɨ kiyaamɨ awaisawɨhiya Kiŋɨhiyaisangi kiyaamɨ watɨpɨhandɨ wandɨhaaraahɨ isɨhiyai nepɨ yatɨhɨ otɨtɨhemapɨ saundɨwɨ, ‘Sahɨ nyamɨ yatɨhɨ pɨnuwɨ nyamɨ pɨwɨha baiwɨ atɨnyiwɨse,’ undɨwɨ maaritɨwɨ apɨpaahɨ watɨpɨtɨwɨmapɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Isɨ siyahaiwa saiwa gaahaiwaametisɨ samɨ otɨhatɨhɨ saiwa apɨpaahɨ wɨndɨ namoaipane. Apɨpaahɨ owetane. Isɨ samɨ woŋɨ noaipapɨ usaamɨ jɨhimatɨpɨ awaisɨhoŋimatɨtaapaahɨ kɨnyɨ noaipapɨ nahatiyaamɨ nehɨ otɨpɨpatɨhoŋimate. ");
INSERT INTO agm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Iyataatɨ amɨ samɨ wo noaipa jɨho awaisɨhoematɨtandaahɨ ko noaipatɨ sahɨ nahatiyaatamɨ nehɨ otɨpɨpatɨho nehɨhoematane. ");
INSERT INTO agm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sandɨ apaapɨmaato. Amɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ bwandɨpɨhonɨnɨ nasohɨtɨmandɨ otɨpɨpatɨ nɨngisɨ nɨtatamanatɨ andɨtɨniwɨtandɨhatɨ isɨhiya kaiwɨ nɨtatamanisaihɨ nga bimɨtandɨ nɨnɨ nasataamaayo. Owetise. Isɨhiya taahiyɨhiyai nɨnɨ iwɨtatamanɨtɨ amɨ Autaahaatɨho kiyai nunyatɨ numwaitandɨ nisɨ ambɨpatɨ nawɨhomataindɨ koai nunyandandɨ napɨtɨhonɨne. Nɨnɨ saindɨ nunyainjanɨhɨ Autaahaatɨho nisɨ ambɨpatɨ nunyatɨ isɨhiya taahiyɨhiyai numwaitando,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kiya naiwɨ aunahɨpa Jerikohanda noaipawaayopo. Noaipapɨ Jisaasihotihɨ sapɨhɨ namasi taatɨ naihɨ komɨ otɨpɨpatɨhiyaunɨ amɨ isɨhiya taahɨtɨhandɨ kiyai nɨwipinjai niyohiyɨhiyaunɨ katɨ aunahɨpitɨ namasisɨ Jisaasihoaisawɨ taawɨ aimɨ niyawaayopo. Aihɨ utaaho wo komɨ ndɨha niyotaho Batimiyaasiho, Timiyaasihomɨ mwaaho isɨhiya daihɨra nuwɨ napɨwɨyohɨpɨpɨhɨ bindataise. Komɨ ndɨha siyatɨ niyotahosɨ isɨhiya daihɨra nuwɨ napɨwɨyauhɨhiyai nawɨho kahapaamapɨpaapɨ itundatɨ daihɨra mangɨrainɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Isɨ ko daihɨra mangɨrainɨ bindataatɨ isɨhiya satɨwɨ, “Nasaretɨhandaahapɨ Jisaasiho yamo taatɨ nasataise,” tɨwɨ katauhɨ atisataise. Atisataatɨ ko waatɨ kaahaata sandaase. “Jisaasihoŋe, Daawitɨhomɨ mwaahoŋɨ Satɨhoŋe, kɨnyɨ nisapɨ maarɨho tɨhɨtane,” tatɨ kaahandaase. ");
INSERT INTO agm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Aihɨ isɨhiya taahiyɨhiya koai itɨhundɨwɨ, “Kinyɨ kaahaapa bɨpi namɨhaape,” undɨwɨ nɨwisapuwawaayopo. Saiwɨ kiya koai namɨhaape undauhɨhand kandɨ ko kiyaamɨha atɨhomaawisa waatɨ asakata kaahaata, “Daawitɨhomɨ Mwaahoŋɨ Satɨhoŋe, kɨnyɨ nisapɨ maarɨho tɨhɨtane,” tatɨ kaahandaase. ");
INSERT INTO agm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Aihɨ Jisaasiho komɨ gapɨpa atisataatɨ namatɨ kapɨhɨ bitondaise. Bitondaatɨ saundataase. “Napɨta sopɨ gaatɨwɨse,” undataase. Aihɨ kiya so ndɨha niyotisoai gaatɨwɨ saundawaatopo. “Kɨnyɨ maaritɨpɨ dosisɨ name Jisaasiho kinyapɨ ko nasane ndaaso,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aihɨ ko atisataatɨ komɨ apotɨhɨrɨ tiwatɨhaatɨ nipaatirɨhɨrɨ nausohaatɨ yotamapɨ dosisɨ Jisaasihoaapɨhɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aihɨ Jisaasiho koai saunda nunjenataise. “Nɨnɨ gisɨ napindɨ kahitandɨ gaatise,’ undatɨ nunjenataise. Aihɨ komɨha wihoaaŋɨha saundataase. “Katɨpɨnyasingɨhonye, nisɨ ndɨha nanorɨhaatonɨhɨ japɨhɨ nga baindɨ jaitandɨto,’ undataase. ");
INSERT INTO agm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aihɨ Jisaasiho komɨha wihoaaŋɨha saundataase. “Kɨnyɨ nisapɨ ko nisɨ ndɨha netɨ nga nanorɨhaitaise tɨpɨ andɨtitɨpɨ gɨnunyaahingɨtɨhandaahɨ kinyɨ ndɨha nangorɨhaatonɨhɨ numwe,” undataase. Aihɨ Jisaasihomɨ pɨwɨhetɨ ketɨ kuraanɨhɨ komɨ ndɨha biyatɨ nusorɨhaatihɨ biyatɨ jatɨ Jisaasihoai nɨwipinjai daihɨra notaise. ");
INSERT INTO agm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Aihɨ kiya naiwɨ detɨ Jerusaremɨhanda noaipaitaahetihɨ aunahɨpɨhaurɨ Betɨpaakihandamunɨ Betaanihandamunɨ sisɨho Oripɨhoaasɨnɨ niyawaayopo. Saiwɨ taawɨ niyawaawɨ Jisaasiho komɨ otɨpɨpatɨhurɨ yahuri jɨhɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Natausaasataatɨ kuri pɨwɨha saundataase. “Kɨmihɨnɨ kɨmatɨ aunahɨpɨmatɨ jahohɨmata numwɨse. Numwɨ tɨtɨhɨ mmonama dongihandamɨ mwaaho sɨpɨpɨhoho isɨhiya wɨndɨ awɨtɨmatɨwɨ dahomaiwɨho wɨraposisaihɨ wɨrandɨtaise. Isɨ ko nesɨpapɨ nesi namɨ kɨmbɨhɨ nɨngi nanɨmɨtaatɨme. ");
INSERT INTO agm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","O amɨ isɨhiya usa sɨhoaasangi sasatɨwɨ, ‘sahuraahɨ dongihoai napitaitaatɨmɨ taamɨ nesɨpase?’ satisaihaahɨ sahuraahɨ kiyai saundɨmise. ‘Awaisɨho komɨ otɨpɨpatɨ wɨtɨ ahotihɨ katɨ kaitandɨ kanyatihɨsɨ katɨ kiyatɨ owetanɨhɨ japɨhɨ ketɨ kuraanɨhɨ numwaasisamaitaise,’ undɨmise undatɨ,” natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Siyatɨ kuri Jisaasiho kaundatɨ natausaasihɨ numwɨ mmonama dongihandamɨ mwaaho aimɨ akururaaho sɨpɨpɨhoho aŋɨhandamɨ maasometetɨ daihɨraamɨ nehɨhinɨ wɨraposauhɨ wɨrandihɨ mmonamaise. Mmonɨmosamɨ taamɨ kandɨ dongihandamɨ mwaaho numwaasi nutotɨmɨ nesɨpamaise. ");
INSERT INTO agm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Saimɨ taamɨ nesɨpasɨhɨ isɨhiya kapɨhɨ bitohoyɨhiya kuri saundawaatopo. “Sahuraahɨ napaapɨ taamɨ dongihandamɨ mwaaho nesɨpase?” undɨwɨ nunjenawaapo. ");
INSERT INTO agm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aihɨ kurɨ Jisaasiho nasɨsesaihaahɨ saundɨmɨ kaundɨmɨse undatatɨ kaundisɨha ka kaundamaase. Aihɨ kiya kuri, “Gaasɨ gohɨ numwaasi numwɨse,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Aihɨ kurɨ dongihoai numwaasi Jisaasihoaapɨhɨ noaipamaise. Noaipapɨ kuramɨ apotɨhɨrɨ tiwatɨhaatɨhɨ niyosɨrɨhɨrɨ nausohaapɨ dongihandamɨ dawaarɨhɨretɨ ahaihɨ Jisaasiho kasɨnɨ nasaamana bindataise. ");
INSERT INTO agm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aihɨ amɨ isɨhiya taahiyɨhiya apotɨhɨrɨ kiyaamɨ tiwatɨhaatɨhɨ niyohohɨpɨpaisangi nausohaapɨ daihɨra Jisaasiho nutandɨhɨra gaamapɨ nusapaapɨ gwaumwɨ nowaayopo. Aihɨ amɨ usa osaataatɨ nuwɨ ipatɨ iwɨwɨrɨhomɨ isaaha nimanɨwɨ nesipɨwɨ daihɨra gaamapɨ gwaapowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aihɨ isɨhiya jɨhunɨ ipotunɨ Jisaasihoai otɨhapemapɨ maaritɨwɨ nowaawɨ waapɨhɨtɨwɨ satawaatopo. “Nyahɨ Autaahaatɨhopɨ maaritɨhaayo. Kɨmo Awaisɨho Autaahaatɨhomɨ ambɨpataahɨ nasahosɨ Autaahaatɨho koaisɨ gaahatɨ kawɨsatɨ gaahandɨ nunyane. Osaana. ");
INSERT INTO agm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kɨmandɨ noaipasɨtɨmandɨ nyamɨ asɨho Daawitɨho isɨhiyai iwinjaatɨ bimindɨhandamatiyahandɨ noaipaitandaisɨ gaahandɨ noaipaitandɨhandɨ Autaahaatɨho koai nunyane. Nyahɨ Autaahaatɨhopɨ waatɨ maaritɨhaayo. Iyaatɨ Autaahaatɨho yamɨhapataatɨhɨ bimisɨhoai mepɨ autaahewaumɨhaayo,” tɨwɨ konyahɨtawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Siyatɨ saiwa noaipasɨhɨ Jisaasiho niyatɨ aunahɨpa Jerusaremɨhanda nandaatɨ niyatɨ Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ nandaatɨ nahataapa katɨhɨ ahotimbɨpai jatɨ mmonataise. Mmonatɨ kiyamapɨ ipɨho aimɨ notɨ tipatetɨ namaatipasɨhɨ katɨhɨ namasi ipaahaapɨ noaipatɨ komɨ otɨpɨpatɨhiyaisatɨ maasɨ aunahɨpa Betaanihandaahapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Saiwɨ nuwɨ aunahɨpa Betaanihanda nanopawɨ bowihɨ nepasi japɨhɨ kapɨhɨ Betaanihanda namasi niyawaayopo. Niyawaawɨ Jisaasihoai jaumanataise. ");
INSERT INTO agm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aihɨ Jisaasiho ipatɨ wɨtɨ pɨhoaipɨhomatiyahatamɨ yandɨpɨho namingohatɨ onɨhɨ wonjɨ yanɨnaatɨhɨhɨ mwininjatɨ ahetihɨ jataise. Jataatɨ wiwa yandɨpɨho ningotɨ ahotɨtaiso tatɨ detapɨ mmondandɨ niyataise. Niyatɨ detapɨ yandɨpɨho ningotɨ ahotɨtaiso ta mmonata yandɨpɨho ningoaitandɨhura sangɨndaatɨ nehɨ yananaatɨhɨ nupwaitatɨ mwinatɨ ahetihɨ mmonataise. ");
INSERT INTO agm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Aihɨ katɨ ipiti Jisaasiho saundataase, “Isɨhiya kinyɨ yandɨpɨho jɨhaatɨ wɨndɨ nandɨwɨ namaahɨndaapo, owetɨtaise,” undatɨ kaundihɨ komɨ otɨpɨpatɨhiya pɨwɨha sa atiwɨ newaayopo. ");
INSERT INTO agm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Aihɨ kiya naiwɨ Jerusaremɨhanda noaipawaayopo. Noaipapɨ Jisaasiho Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ nandaataise. Nandaatɨ isɨhiya katɨhɨ taawɨ kahapaamapɨpa nunyawɨ nawɨho nepɨ amɨ nawɨho yapɨpatɨ wɨtɨwɨtaahapɨho nunyawɨ Judaahiyaamɨhoetemapɨ nepɨ kiyohiyɨhiyaamɨ ganɨho netɨ nepuhotaise. Iyatɨ amɨ isɨhiya nawɨho nunyawɨ koho dɨpisɨho gaarehandɨ Autaahaatɨhoai numwɨtaatɨwɨ nehohɨwaiwaamɨ ganɨho netɨ nepuhotaise. Iyatɨ amɨ kiyaisɨ netɨ tahamanausoaasataise. ");
INSERT INTO agm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Netɨ nepuhotɨ katɨhɨ Aŋɨ Awaindɨhandaatɨhɨ usaaŋaipatainɨ amɨ gotɨtɨpɨhɨrotɨ isɨhiya saiwa japɨhɨ isɨsi katɨhɨ nandaapɨ nuwɨ napɨwɨmaitaatɨwɨ netɨ nɨwimbɨpuwataise. ");
INSERT INTO agm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iyatɨ amɨ ko isɨhiyai kataunjatɨ saundataase. “Autaahaatɨhomɨ pɨwɨha jɨpatɨpindisɨhaatɨhapɨ Autaahaatɨho sandaase. ‘Nisɨ aŋaaŋɨ saaŋɨ isɨhiya yapɨhɨ nahandaahapɨhiya nahatiya napɨwɨ gaapundɨtaatɨwɨhaane,’ tatɨ jɨpatɨpindise. Satatɨ jɨpatɨpindihɨhandɨ kandɨ sahɨ isɨhiyaamɨ nawɨho wihoaaŋɨho tɨtɨhɨ kamwaaŋɨ namunyawɨ wihoaaŋɨho wo ikonɨwɨ nusaitaatɨwɨ sandɨ sahɨ kiyawaayopo. Siyawaawɨ nisɨ aŋaaŋɨ ikohiya ikopa kaitaatɨwɨ noaatɨtaatɨwɨhaaŋemawaayopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aihɨ pɨrisihiya isɨhiyaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ Jisaasihomɨ pɨwɨha sata kaundisɨhaapɨ atiwɨ newaayopo. Atiwɨ newaawɨ Jisaasiho sohoai tiwɨtaatɨwɨhɨra daihɨraapɨ daawaayopo. Iyataatɨ amɨ kiya kopɨ yayawaayopo. Sandɨ kopɨ yayotɨmandɨ apaapɨmaahe, amɨ isɨhiya nahatiya Jisaasihomɨ pɨwɨha atisawaawɨ kiyaamɨ maarɨho windosɨhunɨ amɨ Jisaasihopɨ maaritauhe. ");
INSERT INTO agm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aihɨ aimɨ ipɨho naihɨ asɨhananaataatɨhɨ Jisaasihounɨ komɨ otɨpɨpatɨhiyaunɨ aunahɨpatɨ Jerusaremɨhandi namasi nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nanopawɨ bowihɨ kohokoaisawɨ nepasi daihɨra niyawaawɨ ipatɨ wɨtɨ pɨhoaipɨhomatiyahatɨ awaipɨtamasɨhɨ mmonawaapo. Satɨ ipitɨ isaaha isɨtɨtɨ saatɨtɨho tamitatɨ damipatɨ tambatɨhɨrɨ nahataapa osamatɨ apɨpaahɨ napotɨ awaipɨtamataise. ");
INSERT INTO agm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Siyatɨ awaipɨtamasɨhɨ Pitaaho mmonataatɨ gwɨnyapenataise. Gwɨnyapenataatɨ batɨ ipiti kaundindɨhandapɨ namatɨ Jisaasihoai ko saundataase. “Katɨpɨnyasingɨhonye, jase, kɨmatɨ ipɨmatisɨ kɨnyɨ batɨ itɨhundingɨpatɨ wanɨ aimɨ awaipɨtatɨ napomataiso,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Aihɨ Jisaasihomɨha wihoaaŋɨha kiyai saundataase. “Sahɨ baiwɨ Autaahaatɨhopɨ gɨwunyaapɨse. ");
INSERT INTO agm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Isɨhiya usa baiwɨ Autaahaatɨhopɨ gɨwunyaahohiyɨhiya kɨmɨrɨ sɨhoaarɨmɨrɨ tipɨmati, ‘kɨnyɨ niwautɨpesi durɨhɨraatɨhɨ tɨmandaate,’ undɨwɨ nga kaundɨtaapo. Kaundisaihɨ amɨ kɨretɨ tɨtɨhɨ kiya noaipaitaise. Saiwɨ kaundɨtaatɨwɨhiya maarɨho yiyahwɨ gwɨnyaapɨhiyaamaahe, owetise. Nehɨ maarɨho naasohɨhɨ gɨwunyaapɨ nyahɨ katisaihɨ tɨtɨhɨ akɨpɨpa noaipaitaise tɨwɨ gwɨnyapenawaawɨ katɨtaapo. Isɨ nɨnɨ sangi akɨtɨnɨhɨ sandɨ kasatataato, sahɨ wapaapɨ gwɨnyapenawaawɨ katisaihaahɨ tɨtɨhɨ akɨpɨpa samɨ katohɨmumwaaŋɨ kamwaaŋɨ japepihɨra tɨtɨhɨ kapa noaipaitaise. ");
INSERT INTO agm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Isɨ sahɨ Autaahaatɨhopɨ gaapundɨwɨ wapa naitaatɨwɨ koai nunjenawaawɨ nyamɨ kaundohɨpɨpa akɨtɨnɨhɨ kapa tɨtɨhɨ naito tɨwɨ gwɨnyaawaawaahɨ samɨ katohɨpɨpa kapa tɨtɨhɨ naitaapo satɨtɨ nɨnɨ sangi akɨtɨnɨhɨ kasatataato. ");
INSERT INTO agm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Isɨ sahɨ gaapundɨtaatɨwɨ dowaahetɨ utaaho wo sangi maipɨhandɨ wɨndɨ kasindɨhandapɨ kopɨ gwɨnyapenawaawaahɨ namapɨ komɨ maipɨhaiwa sangɨ gaapundɨwiwatawa jɨhɨ nepumapɨse. Saiwɨ kaisaihaahɨ amɨ samɨ japɨho yamɨhapataatɨhɨ bimisɨho samɨ maipɨhaiwaisangi nesamaitaise. ");
INSERT INTO agm_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(O amɨ utaaho wo sangi maipɨhaiwa kasiwaiwa nepɨmumwawaawaahɨ amɨ samɨ japɨho yamɨhapataatɨhɨ bimisɨho samɨ maipɨhaiwa wɨndɨ nesamaamaitaise owetɨtaise,” undatɨ Jisaasiho kiyai kaundataase.) ");
INSERT INTO agm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Aihɨ kiya japɨhɨ napɨwɨ Jerusaremɨhanda noaipawaayopo. Noaipapɨ Jisaasiho Aŋɨ Awaindɨhandaatɨhɨ nandaatɨ taatɨ daayataise. Aihɨ pɨrisihiya awaisawɨhiya Autaahaatɨhoai nandapa tɨhɨwɨ dɨpumanɨhohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ amɨ usa gwɨnyaahiyaunɨ Jisaasihoaapɨhɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Napɨwɨ Jisaasihoai satɨwɨ kiya nunjenawaapo. “Kɨnyɨ isɨhiyai Aŋɨ Awaindɨhandaatɨhɨ saiwa kamaiwɨse undɨpɨ nɨwisapupɨ kaingɨtɨmandɨ watɨpɨhandɨ diyaamɨhandaahe? Aimbɨ amɨ gisɨ saimbɨ kaimehɨta ndɨ kahɨtihɨ kɨnyɨ kiyapaise?” undɨwɨ nunjenawaapo. ");
INSERT INTO agm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aihɨ amɨ Jisaasihomɨha wihoaaŋɨha kiyai saundataase. “O amɨ nɨnɨ pɨwɨha wa nehɨ naasaahɨhɨ nasɨsendaano, sahɨ wihoaaŋɨha baiwɨ nepɨ kandisaihaahɨ amɨ nɨnɨ kaiwa kaiwa kiyohɨwɨmaiwaapɨ watɨpɨhandɨ sandaahe satɨtɨ sangi kasatɨtando. Isɨ nɨnɨ sandɨ nasɨsendaano. ");
INSERT INTO agm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jonɨho isɨhiyai pɨwɨha ausaatɨ kaundatɨ amɨ waapohora baawusindɨndɨ Autaahaatɨhomɨ watɨpɨhandaaho e yapɨpatambɨ isɨhiyaamɨ gwɨnyaahotɨhandɨ watɨpɨhandaaho wanɨ sahɨ kandɨwɨse?” undatɨ kiyai nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sata Jisaasiho nunjesɨhɨ kiya sawana sanawaatopo. “Nyahɨ napitɨtɨtɨhaawe? ‘Nyahɨ Autaahaatɨhomɨ watɨpɨhandaahe,’ undisaihaahɨ pɨwɨha Jisaasiho wihoaaŋɨha sanyatɨtaise. ‘Amɨ Autaahaatɨhomɨ watɨpɨhandaahɨnaahɨ sahɨ Jonɨhopɨ napindapɨ gɨmaawunyaahopo?’ nyatɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","O amɨ nyahɨ, ‘isɨhiyaamɨ gwɨnyaahotɨhandɨ yapɨpatambɨ watɨpɨhandaahe,’ undisaihaahɨ amɨ isɨhiya Jonɨhopɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨhoe tɨwɨ gɨwunyaapɨhiyaasɨ kiyaisɨ nyapɨ apowɨtaiso,” nnawaatopo. (Amɨ kiya sanɨwɨ kanɨhotɨmandɨ sandɨ kiya isɨhiyaapɨ yayawaawɨ kanawaatopo.) ");
INSERT INTO agm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aihɨ kiya yayawaawɨ namapɨ Jisaasihoai saundawaatopo. “Nyahɨ saiwaapɨ wɨndɨ mmonaahiyaane,” undawaatopo. Aihɨ Jisaasihomɨha amɨ kiyai saundataase “O siyonaahɨ amɨ nisangisɨ watɨpɨhandɨ sandɨ so nanɨmihɨhanda saindɨ kiyataayo satɨtɨ wɨndɨ kamaasatɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Aihɨ Jisaasiho pɨwɨha namɨhanaha Judaahiyaamɨ awaisawɨhiyaapɨ kiyai sata kaundataase. “Utaaho wo wɨrɨhɨrɨ wainɨhandɨ niyaamatɨ naporɨhɨrɨ nisatɨ nisɨhoaapotosatɨ amɨ waapoho wainɨhandɨ namwaitandɨhandɨ kiyataise. Kiyatosa amɨ aŋaaŋɨ waaŋɨ isɨhiya wainɨhandɨ ikondaatɨwɨhiyaapɨ tamangɨpɨpɨhapɨ jaawɨ bitoaitaatɨwɨhaaŋɨ autaahɨ nɨwaataatɨ aŋɨmatataise. Siyatɨ kiya owetihɨ isɨhiya usaisɨ saunda nunyataise. ‘Sahɨ nisɨ osaataatɨ wainɨhandɨ kɨmandɨ ninjaawɨ bitosawɨse. Ninjaawɨ bitotawaawɨ wainɨhandɨ ningohonɨhura sapɨhandɨ nanawaawɨ amɨ nɨwahonisapɨhandɨ nanɨmɨtaatɨwo. Aiwɨ amɨ wɨndɨ nunyawɨ isɨhiyai nawɨho naitaatɨwe,’ undatɨ kiyaamɨ ikwɨraatɨhɨmataise. Siyatɨ nunyamapɨ konɨhɨ kaanɨhɨ wapɨhapɨ nomataise. ");
INSERT INTO agm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nomatɨ ketinjatɨ wainɨhandɨ aimɨ ningotɨ akuraihɨhura komɨ otɨpɨpatɨho woai saundataase. ‘Kɨnyɨ numbwɨ nisɨ wainɨhandɨ ninjaawɨ bitohohiyɨhiyaapɨhɨ noaipasamɨhɨ kiya wainɨhandɨ wɨndɨ nahɨmisaihɨ nanenapɨta numwe,’ undatɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Siyatɨ natausaasihɨ ko naihɨhandɨ kandɨ kiya wainɨhandɨ jasohiyɨhiya komɨ otɨpɨpatɨhoai isɨwatawa tɨmambɨwɨ ahiyawɨ nehɨ taanahɨhoai japɨhɨ nepɨ natɨwusaasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aihɨ amɨ wainɨhandamɨ satɨho komɨ wainɨhandɨ jaawɨ bimohiyɨhiyaapɨhɨ jɨhaatɨ komɨ otɨpɨpatɨho woai natausaasataise. Aihɨ amɨ koai isɨwatawa mɨtɨhaatɨhɨ tɨmbɨpɨ jɨtɨpɨtahandɨ tipɨ mawahandɨ nunyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aihɨ wainɨhandamɨ satɨho amɨ komɨ otɨpɨpatɨho woai jɨhaatɨ natausaasataise. Natausaasihɨ ko notɨ kiyai iwinjasɨhɨ kiya koai sohoai tiwawaayopo. Aihɨ wainɨhandamɨ satɨho amɨ komɨ otɨpɨpatɨhiya taahiyɨhiyai natausaasataise. Natausaasihɨ kiya nuwɨ kiyai iwinjahauhɨ jɨhiyai kawisohɨpatɨ katɨ kawiwɨ usai gotɨ tipusoaasawɨ amɨ usai sɨyɨhiyai tiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Aihɨ amɨ komɨ mwaaho nehɨ naasohɨhɨ maarɨho biyatɨ wɨwiwahoai ipotɨ natausaasɨtandɨ bindataise. Aihɨ ipotaataatɨnɨhɨ sawahomɨ mwaahoai wainɨhandɨ jaawɨ bimohiyɨhiyaapɨhɨ netɨ natausaasataise. Natausaasataatɨ sapɨho sandaase. ‘Nisɨ maasɨhɨhomɨ pɨwɨha kiya baiwɨ atɨwitaapo,’ ndaase. ");
INSERT INTO agm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Satatɨ natausaasihɨ ko notɨ noaipasɨhɨ wainɨhandɨ jaawɨ bimohiyɨhiya taatɨ naihɨ koai iwinjaposawɨ kiya sanawaatopo. ‘Kɨmo utaamo wainɨhandɨ kɨmandamɨ satɨhomɨ tɨtɨhɨ mwaaho akohoe. Isɨ koai sohoai tiwɨtɨhaawɨ napɨwɨse. Tiwisaihɨ ko naponɨhɨ ko wainɨhandɨ osaataatɨ naitotahandɨ namawa nyahɨ kandɨ nesaihɨ nyamimatɨtando,’ nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Satɨwɨ kanawaawɨ namapɨ komɨ mwaahoai isɨwatawa sohoai tipɨ osaataatamɨ nehɨhaatɨ yotawaapo. ");
INSERT INTO agm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Isɨ wainɨhandamɨ satɨho kiyaisɨ napitɨwitaise. Osaataatamɨ satɨho nasatɨ kiyaisɨ siyɨhiyai tiwamaitaise. Tiwamatɨ komɨ wainɨhandɨ osaataatɨ usai nemwɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Pɨwɨha kɨma sata jɨpatɨpindisɨha sahɨ wɨndɨ awɨmɨtɨwɨhiyaato: ‘Aŋaaŋɨ aŋɨmatohiyɨhiya yasɨha kɨmaapɨ ponyase tɨwɨ namahotɨha wanɨ noaipatɨ mɨhotɨrisatɨ aŋaaŋapɨ yasɨha aundetɨho anaahɨhaimatataise. ");
INSERT INTO agm_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Awaisɨho sawaho sandɨ siyatɨ kaihɨ nyahɨ mmonɨhaawɨ apɨpaahɨ gaatihɨ maaritɨhaayo,’ tatɨ jɨpatɨpindise,” undatɨ kiyaisɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sata Jisaasiho kiyai kaundihɨ Judaahiyaamɨ awaisawɨhiya komɨ pɨwɨha atɨwisawaawɨ ko nyapɨ pɨwɨha sa namɨhanaha kandaase tɨwɨ Jisaasihoai isɨwɨtotɨwɨ gwɨnyaahohiyɨhiya namapɨ isɨhiyaapɨ yayawaawɨ koai namasi nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Saiwɨmapɨ nuwawɨ bowihɨ isɨhiya Parisihiyaamɨ usaisunɨ amɨ Erotɨhomɨhiyaamɨ usaisunɨ ko napitɨnyatise tɨwɨ bɨpi iwinjatawa nunjendaatɨwɨ Jisaasihoaapɨhɨ natɨwusaasawaayopo. Aiwɨ amɨ pɨwɨha wa wipɨta asɨretɨ kaundonaahɨ asɨretɨ satɨpɨhoŋe undɨwɨ pɨwɨha komɨhetɨ nutotɨwo. ");
INSERT INTO agm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aihɨ kiya nuwɨ Jisaasihoaapɨhɨ noaipapɨ koai saundawaatopo. “Katɨpɨnyasingɨhonye, nyahɨ gwɨnyaahaayo kɨnyɨ utaahoŋɨ ainahɨhoŋɨ pɨwɨha tɨtɨhɨ gaahaahɨhɨ katɨpɨhoŋɨtinɨho. Aimbɨ amɨ kɨnyɨ isɨhiyaamɨ gwɨnyaahohɨwaiwaapunɨ kɨnyapɨ itɨhɨtohɨwaiwaapunɨ wɨndɨ yamaimbɨ andɨtitɨpɨ bitotapa Autaahaatɨhomɨ pɨwɨha naasɨka Akɨtɨhaahɨhɨ katɨpɨnyasapɨhoŋe, isɨhiya awaisawɨhiyaisunɨ gwɨharaahiyaisuno. Isɨ wanɨ nyangi kanyate. Nyahɨ awaisɨho Sisaaho Romɨhanda nahataapɨpɨhɨ jatisɨhoai nawɨho gamanɨhomɨ otɨpɨpatɨ kaitandɨho nunyahaawaahɨ sandɨ Judaahiyaamɨ wɨnɨhapɨpa newa nopɨsasɨhaayono e owetiso? Isɨ Sisaahoai nawɨho nunyaano e namunyaano?” undɨwɨ kiya nunjenawaapo. ");
INSERT INTO agm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aihɨ Jisaasiho kiyaamɨ jaiwaiwɨ iwinjatawa nunjenɨhotɨhandɨ usonataise. Usonataatɨ kiyai wihoaaŋɨha saundataase. “Sahɨ napaapɨ napɨwɨ nɨngi ninjatawa jaiwaiwɨ taawɨ nanɨsehopo? Nawɨho taanauhɨho wo isɨsi nasawaawaahɨ naninyawewɨse nɨnɨ mmondaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Undihɨ kiya nawɨho wo nunyauhɨ ko netɨ mmonatosatɨ amɨ kiyai saundatɨ nunjenataise. “Kɨmatɨ sɨwipɨmatunɨ ambɨmbatunɨ diyaamɨhate?” undataase. Aihɨ kiya saundawaatopo. “O awaisɨho Sisaahomɨhate,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“O siyonaahɨ wapa awaisɨho Sisaahomɨhapanaahɨ amɨ koai tɨtɨhɨ komɨhapa nunyawɨse. O amɨ wapa Autaahaatɨhomɨhapanaahɨ amɨ tɨtɨhɨ kapa Autaahaatɨhoai nunyawɨse,” undataase. Undatɨ Jisaasiho pɨwɨha kaundihɨ kaapɨ kiya namapɨ yaiwɨmapɨ maaroamapɨ pɨhɨtɨwɨ gwɨnyaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Judaahiyaamɨ usa isɨhiya Satiyusihiya Jisaasihoaapɨhɨ napɨwɨ noaipawaayopo. Isiya siya Satiyusisiya satɨwɨhiyaare. Isɨhiya napohiyɨhiya japɨhɨ wɨndɨ namepaitaapo tɨwɨ gwɨnyaapɨ katɨwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Isɨ kiya Jisaasihoai saundɨwɨ nunjenawaapo. “Katɨpɨnyasingɨhonye, Mosesiho nyapɨ wɨnɨhapɨpa kɨmba sata jɨpatɨpiya ahiyataise. ‘Utaaho sɨhɨmwaaha manyinya oweho nehɨ bimainja apwaataati namasi naponaahɨ sotisomɨ tɨtɨhɨ saingɨho osɨnɨhaati netɨ wɨrane. Iyonɨhɨ manyinya koaapɨhapɨ noaipahohiyɨhiya komɨ aunahɨpa naitaatɨwɨmaahe. Owe. Sotisɨhomɨ aunahɨpa naitaatɨwe,’ tatɨ ahiyataise. ");
INSERT INTO agm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Isɨ isɨhiya sapɨho naasomɨ mwaaya taahiyɨhiya 7 kaiwɨhiya noaipawaayopo. Aihɨ jɨho bwandɨpɨho apopaati netɨ wɨrataise. Ko netɨ wɨratɨ bimainjatɨ maaha oweho napotaise. ");
INSERT INTO agm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aihɨ amɨ komɨ saingɨho komɨhinɨ noaipasɨho saahomɨ osɨnɨhaati netɨ wɨrataise. Wɨratɨ bimainja amɨ koaisangi naasɨkatɨ kiyatɨ maaha oweho napotaise. Aihɨ amɨ kapɨhoaisangi katɨ kiyatɨ netɨ wɨratɨ bimainja maaha oweho napotaise. ");
INSERT INTO agm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Saiwɨ nahatiya kaimɨ nuwɨ ipotaataatɨho 7 hoaisangi naasɨkatɨ kiyatɨ maaha oweho napotaise. Aihɨ ipotɨnɨhɨ kaatɨ apopaatɨ napotaise. ");
INSERT INTO agm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Isɨ saatɨ apopaati saaho saingɨho nahatiya 7 kaiwɨhiya nepɨ wɨrapɨhaatisɨ asisɨha isɨhiya japɨhɨ nepapɨ asɨtimatɨtaatɨwɨha noaipahonɨhura saatɨ apopaatɨ noaipatɨ diyaamahomɨ apwaataatimatɨtaise?” undɨwɨ Jisaasihoai nunjenawaapo. ");
INSERT INTO agm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aihɨ Jisaasihomɨha wihoaaŋɨha kiyaisɨ saundataase. “Sahɨ monɨwɨ gɨmunyaapɨhiyaato? Sahɨ Autaahaatɨhomɨ pɨwɨhaatɨhɨ jɨpatɨpindimbɨpaapunɨ amɨ Autaahaatɨhomɨ watɨpɨhandapunɨ sahɨ apɨpaahɨ wɨndɨ monɨwɨ amɨ wɨndɨ gɨmaasunyaatahiyaato? Amɨ sahɨ Autaahaatɨhomɨ pɨwɨha jɨpatɨpindiwaiwaapunɨ amɨ Autaahaatɨhomɨ watɨpɨhandapunɨ wɨndɨ monɨwɨhiyaatɨsɨ sahɨ saiwa nahɨriwɨ katawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Isɨhiya japɨhɨ nepawaahura wanamataiwɨ wɨndɨ namaamaatɨndaapo. Owetɨtaise. Nehɨ Autaahaatɨhomɨ otɨpɨpatɨhiya yamɨhapataatɨhɨ bimohiyɨhiya enjerɨhiyaamataiwɨ bimɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Isɨhiya napohiyɨhiya japɨhɨ nepaitaatɨwɨhandapɨ Autaahaatɨho pɨwɨha katisɨha sahɨ aimɨ akɨtɨnɨhɨ awɨtɨwɨhiyaate. Mosesiho pɨwɨha ipatɨ mwinɨhatɨ sisɨha sawɨha tɨhindɨndapɨ jɨpatɨpiya ahaisɨha sahɨ wɨndɨ awɨmɨtowo? Sandɨ ipɨhosɨ aŋɨnetahonjɨ maipɨhonjaatɨhapɨ sisɨha tɨhisɨhaapɨto. Sa pɨwɨhaatɨhɨ Autaahaatɨho Mosesihoai saundise. ‘Nɨnɨ Abɨraahamɨho Aisaakɨho Jekopɨhomɨ Autaahaatɨhonɨne,’ undise. ");
INSERT INTO agm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Autaahaatɨho so isɨhiya Autaahaatɨhopɨ gɨmaawunyaapɨhiya napohiyɨhiyaamɨ Autaahaatɨhomaahe. Owetise. Autaahaatɨho so isɨhiya sangɨ napopɨ asɨyɨhiya bimohiyɨhiyaunɨ amɨ isɨhiya aimɨ napohiyɨhiya kopɨ gɨwunyaahotɨhandaahɨ kiyaanɨhɨ asɨyaimatɨwɨ koaisawɨ bimohiyɨhiyaamɨ Autaahaatɨhore. Isɨ sahɨ nahariwɨhiyaatisɨ pɨwɨha sa apɨpaahɨ naharɨtɨwɨha katawaatopo,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Utaaho wo Judaahiyaamɨ wɨnɨhapɨpa kataunjisɨho nasataise. Nasatɨ atisata kiya Satiyusihiya nunjenɨhohɨwaiwa Jisaasiho nga wihoaaŋɨha biyatɨ ausaatɨ nusesɨpatɨ kaundihɨ ko wɨnɨhapɨpa kataunjisɨho atisataise. Siyatɨ biyatɨ gaaha kaundihɨyataatɨ namatɨ komɨha Jisaasihoai sata nunjenataise. “Wɨnɨhapɨpa mahɨwapaanɨhɨ apɨpaahɨ awaimbɨpa jɨhapaare?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Aihɨ Jisaasiho komɨha wihoaaŋɨha koai saundataase. “Wɨnɨhapɨpa apɨpaahɨ awaimbɨpa wapaisɨ nusatipɨhaahapa kɨmbaare: ‘Sahɨ Isɨraherɨhiyaate atiwɨse. Nyamɨ Awaisɨho Autaahaatɨho nehɨ naasohɨhɨ ko Awaisɨhore. ");
INSERT INTO agm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Isɨ kɨnyɨ kinyɨ maarɨho kinyɨ amɨtɨha gwɨnyaahingɨtɨhandɨ kinyɨ andɨtitingɨtɨhandɨ kinyɨ watɨpɨhandɨ kinyɨ gwɨsɨha saiwa nahatewa Autaahaatɨho naasomɨhetɨ niyonɨhɨ kinyɨ Awaisɨho Autaahaatɨhoaisaahɨhɨ maarɨho napaitɨpɨ nunye.’ ");
INSERT INTO agm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aihɨ amɨ wɨnɨhapɨpa wapa awaimbɨpa kapɨhapa kɨmbaare. ‘Kɨnyɨ kɨwahoŋɨ maarɨho namɨnɨpɨ kinyɨ ambɨpatisɨ maarɨho nunyapɨ baimbɨ napaitɨpɨ itatamanɨhingɨpatamataimbɨ kinyɨ naisohoai maarɨho nunyapɨ amɨ komɨ ambɨpatapɨhapa nunyapɨ iwɨtatamanɨme.’ Iyataatɨ wɨnɨhapɨpa wapa awaimbɨpa kɨmaurisɨ nusatipɨhaatɨ awaimbɨpaatɨtandɨhapa apɨpaahɨ owetise,” undatɨ Jisaasiho koai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aihɨ ko wɨnɨhapɨpa kataunjisɨho Jisaasihoai saundataase. “Katɨpɨnyasingɨhonye, kɨnyɨ tɨtɨhɨ pɨwɨha apɨpaahɨ akɨtɨnɨhɨ akaaha katapaase, Autaahaatɨho Awaisɨho nehɨ naasohɨhɨ bindataise. O wo autaahaatɨho owetise. ");
INSERT INTO agm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Isɨ nyahɨ biyaatɨ napaita nyamɨ maarɨho nyamɨ gwɨnyaahotɨhandɨ nyamɨ andɨtitotɨhandɨ watɨpɨhandɨ nyamɨ omaŋɨtɨtɨhɨ saiwa nahatewa akɨtɨnɨhɨ komɨhetɨ niyonɨhɨ koaisaahɨhɨ maarɨho numwɨtɨhaawo. Iyaatɨ amɨ nyahɨ yawanaanɨ nyamɨ ambɨpatisɨ maarɨho nunyaatɨ biyaatɨ napaitaatɨ itatamanɨhopatamatiyaatɨ amɨ naisɨhiya amɨ isɨhiya usaisangi maarɨho nunyaatɨ iwɨtatamanɨtɨhaawe. Isɨ wɨnɨhapɨmaurɨ kɨmaurɨ nyahɨ atisaatɨ biyaatɨ japepihɨrotɨhandɨ nyahɨ gaarehandɨ nandapa kohasɨpɨho tɨhaatɨ Autaahaatɨhoai dɨpumanɨhohɨwaiwa nahatewaisɨ nusatipɨhaataise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sata ko wɨnɨhapɨpa kataunjisɨho katihɨ Jisaasiho atisata ko biyatɨ tɨtɨhɨ akaaha katihiyataatɨ Jisaasiho koai saundataase. “Kɨnyɨ Autaahaatɨho isɨhiyai iwinjaatɨ bimindɨhandaatɨhɨ nandaitaapɨ aimɨ detɨtapaise,” undataase. Undatɨ kaundihɨhura isɨhiya nahatiya yayawaawɨ andɨtitɨwɨ pɨwɨha wiwa Jisaasihoai jɨhaatɨ namunjenɨhopo owetise. ");
INSERT INTO agm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisaasiho Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ nandaatɨ katɨhɨ gotɨtɨpɨhɨrotɨ usaaŋaipatainɨ bitonda pɨwɨha ausaatɨ kataunjataatɨ isɨhiyai saundatɨ nunjenataise. “Isɨhiya wɨnɨhapɨpa katɨwunjohiyɨhiya Kɨraisihopɨ Daawitɨhomɨ mwaahoe tɨwɨ napaapɨ katopo? ");
INSERT INTO agm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Autaahaatɨhomɨ Itɨpɨho netɨ Daawitɨhoai gɨwunyaasɨhɨ amɨ Daawitɨhohɨ sawaho satise: ‘Awaisɨho Autaahaatɨho nisɨ Awaisɨhoai saundise, “Kɨnyɨ nisɨ ikwɨrɨ gaahɨraihoaaŋɨ bime. Bimaamɨ numbwɨ nɨnɨ kinyɨ tiworisaisɨ netɨ kinyɨ asɨmwaatɨtɨhemasanɨhɨ kɨnyɨ kiyai nepɨ ipɨhatisamɨhuraatɨtando,” undatɨ Autaahaatɨho Awaisɨho nisɨ Awaisɨhoai kaundise,’ tatɨ kandaase. ");
INSERT INTO agm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daawitɨhohɨ sawaho koaisɨ nisɨ Awaisɨhoŋe undatɨ ambɨhundataase. Isɨ Kɨraisiho naasɨkura napitiyatɨ Daawitɨhomɨ awaisɨhotatɨ mwaahotɨtaise?” undataase. Undihɨ isɨhiya taahiyɨhiya komɨ pɨwɨha saapɨ asakaiwɨ maaritɨwɨ atɨwisawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisaasiho isɨhiyai pɨwɨha kataunjataatɨ satatɨ kaundataase. “Isɨhiya wɨnɨhapɨpa katɨwunjohiyɨhiyaamɨ kiyohɨwaiwaapɨ sahɨ baiwɨ jaawo. Kiya saiwɨhiye. Isɨhiya nyapɨ awaisawɨhiye nyatɨto tɨwɨ apotɨhɨrɨ gaahapa utaarɨhapa niyosi daitaapo. Aiwɨ amɨ kiya isɨhiya ahoyanɨwɨ nuwɨ napɨwaiwɨ kahapaamapɨpa nunyawɨ nehohɨpɨpɨhɨ isɨhiya nyangi nyainjapɨ ipɨhɨrete nyatɨto tɨwɨ apɨpaahɨ maaritɨwɨmapɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aiwɨ amɨ aŋaaŋɨ gwɨharaahaaŋɨ isɨhiya ahoyanɨwɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundohɨpɨpɨhɨ (sinekokɨhandaatɨhɨ) mɨtaahoaahapaahaiwɨ isɨhiyaamɨ ndɨhetɨ awaisawɨhiyaaniso tɨwɨ bimaawɨhiyaare. Aiwɨ wapa usɨpɨpaapɨ ahoyanɨwɨ nandapa awaimbɨpa tɨhauhɨhapɨhɨ noaipawaahura awaisawɨhiyaanɨsɨ nyangisɨ awaisawɨhiyaisawɨ nepɨ ahɨnyisawosawɨ nandapa nyangi maasɨ jɨhɨ nanyamɨto tɨwɨ gwɨnyaapɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aiwɨ amɨ kiya asɨhiya osɨnɨhiyai jaiwundɨwɨ kiyaamɨ aŋɨtɨtɨhɨ wapa ahusotimbɨpa ikowɨnɨwɨ nusepɨhiyaare. Aiwɨ amɨ kiya kiyaamɨ ikopa maipɨhaiwaamɨ tiwatɨhaatapɨ isɨhiya kiyaapɨ gaahiya ainahiyɨhiye tɨto tɨwɨ Autaahaatɨhopɨ gaapɨpa utaarɨhaiwa aipɨ pɨhɨtɨwɨ gaapundɨwɨhiye. Isɨ kiya saiwɨ kiyohɨwaiwaapɨ ipotɨhura Autaahaatɨho kiyai naaŋatɨ yaawɨhandɨ usai nusatipɨhaahandɨ apɨpaahɨ awaindɨhandɨ numwɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Aihɨ Jisaasiho niyatɨ Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ nandaataise. Nandaatɨ bokisihandɨ nawɨho gaarehandapɨho wihohɨtɨhandamɨhinɨ detɨ bindataise. Bindata iwinjatihɨ isɨhiya taahiyɨhiya nawɨho ikɨpɨpa asaketahiya kandɨ nawɨho wihohɨtɨhandopɨ nawɨho wiwawaayopo. Nawɨho asaketahiya amɨ waatɨ awaisɨho taahɨho kandopɨ wiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Aihɨ apopaatɨ waatɨ warɨho aimɨ napomasɨhɨ osɨhaamaatɨ kahapaamapɨpa nawɨho taahɨpɨpa owehaatɨ nasataise. Nasatɨ nawɨho nehɨ jisɨhasurɨ yasurɨ kandopɨ iwiwataise. ");
INSERT INTO agm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Aihɨ Jisaasiho kaatɨ osɨhaamaati iwinjatosatɨ komɨ otɨpɨpatɨhiyai gaata numwaatɨ detematosatɨ kiyai sata kaundataase. “Nɨnɨ akɨtɨnɨhɨ sangi sandɨ kasatɨtaato Kɨmaatɨ osɨnɨmaatɨ warɨho owemaatɨ kaatamɨ nawɨho tɨmasɨho isɨhiya nahatiya kɨmiyaamɨ nawɨho awaisɨho kɨmandɨ Aŋɨ Awaindɨmandamɨ nawɨho wihohɨtɨhandopɨ wihohɨhoai nusatipɨhaatɨ apɨpaahɨ awaisɨho iwiwataise. ");
INSERT INTO agm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iyataatɨ kɨmiya isɨhiya nahatiya nawɨho asaketahiyaasɨ nahato nga kiyatɨ ahusotihɨ nehɨ yandɨhɨ isoho tɨmawaayopo. O kɨmaatɨ osɨnɨmaatɨ nawɨho apɨpaahɨ nenoaahɨta owetihɨhaatɨ kaatɨ kaatamɨ nawɨho kora nandapa nunyatɨ netɨ nandandɨho nahato konɨhɨ tɨmataise. Isɨ kaatɨ nandapaapɨ nunyatɨ netɨ nandandɨho apɨpaahɨ owendaise,” undatɨ Jisaasiho komɨ otɨpɨpatɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisaasiho Aŋɨ Awaindɨhandi namasi notaise. Namasi ko taatɨ naihɨ komɨ otɨpɨpatɨho wo Jisaasihoai saundataase. “Katɨpɨnyasingɨhonye, aŋaaŋɨ kɨmaiwa apɨpaahɨ gaahaiwa sanahɨwaiwe. Iyatɨ amɨ nawɨha kɨmaiwa apɨpaahɨ aungwohaiwaaraahɨ aŋɨmatɨwɨhapanyaare,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aihɨ Jisaasihomɨha wihoaaŋɨha koai saundataase. “Kɨnyɨ kɨmaiwa anɨmaiwai usonapaapɨno? O saiwa ipotɨhura nawaamaiwa tiwatɨ nyepinatɨ ahotiwɨmaiwa siyatɨ wɨndɨ ahɨmotɨtaise. Owetɨtaise. Isɨhiya nepɨ natipɨ nopɨsasɨwɨ nepɨ nepuhwɨtaapo. Nepuhwisaihɨ nahomanɨndɨwa mɨhaapɨ yatɨhɨ yapɨpatetɨ tɨmɨhaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisaasiho niyatɨ nasaamanatɨ Aŋɨ Awaindɨhandɨ wihɨnɨ ahetihɨ Sisɨho Oripɨhoaasɨnɨ bindataise. Aihɨ komɨ otɨpɨpatɨhiya nehɨ wingwaasɨhɨhɨ koaapɨhɨ nasawaayopo. Kingwaasamɨ ambɨpatɨ Pitaahotihɨ Jemɨsihotihɨ Jonɨhotihɨ Endɨruhotihɨ siya nehɨ sawanaahɨhɨ napɨwɨ Jisaasihoai satɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kɨnyɨ Aŋɨ Awaindɨhandɨ netɨ nopɨsasɨndaise tɨpɨ kanyatingɨtɨhandɨ maahɨwura noaipaitaise? Iyataatɨ jɨhɨ sɨwipatɨ wapa napitiyahapa noaipahonɨhɨ sandɨ kɨnyɨ katindɨhandɨ aimɨ koaipaitande taatɨ nyahɨ gwɨnyaitɨhaawe?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Saundauhɨ Jisaasiho namasatɨ kiyai wihoaaŋɨha sata kaundatase. “Sahɨ baiwɨ jaawo. Isɨhiya usa sangisɨ jaipɨsatɨtaawo. ");
INSERT INTO agm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Isɨhiya taahiyɨhiya napɨwɨ nisɨ ambɨpatɨ ambɨhɨtɨwɨ nɨnɨ Mesaiyaahonɨnɨ kɨmɨkonɨne satɨwɨ isɨhiyaatɨ taahiyɨhiyaatangi jaipɨsatisaihɨ amɨ sahɨ wiwa kiyaamɨ jaipɨpa atɨwiwɨ kiyaapɨ gɨwunyaitaawɨ jaawo. ");
INSERT INTO agm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Iyataatɨ pwɨsɨpatɨ aungwohaiwa detunɨ kaanɨhunɨ noaipahonɨhɨ pɨwɨha sahɨ atisawaawɨ kaiwaapɨ yaiwɨ amɨ samɨ maarɨho owemaasetane. Amɨ Saiwaahɨ tɨtɨhɨ noaipahonɨhɨ sahɨ asisɨha aimɨ detɨtihe tɨtaawɨ saiwaahɨ kiyatɨ jɨhɨ noaipaitaise. Jɨhɨ noaipataahandɨ kandɨ asisɨha ipotɨha sangɨtɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Isɨhiya yapɨpatɨ wɨtaahapɨhiya dosisɨ amɨ isɨhiya usa yapɨpatɨ wɨtaahapɨhiyaisawɨ tundaapo. Aisaihɨ amɨ awaisɨho kiŋɨho womɨhiya dosisɨ awaisɨho kiŋɨho yapɨpatɨ wɨtaahapɨhomɨhiyaisawɨ tundaapo. Iyonɨhɨ amɨ ipɨpatɨpatɨ nahataapɨpɨhɨ ipɨpatɨpindaise. Iyonɨhɨ amɨ wapɨhɨ wapɨhɨ jarɨho noaipahonɨhɨ isɨhiya nandapa nandaatɨwɨhapa owetɨtaise. Saiwa apopaatɨ maaha namwɨtandɨ tɨmendaatɨ jɨhɨ wuwanɨ namasatɨ kɨhurakɨhura gotɨ yausamɨ notɨ aimɨ detɨtihɨ suraanɨhɨ kaatamɨ ambɨpatɨ aungwohandɨ yaawindɨhandamatiyatɨ jɨhapɨhapa namasatɨ noaipataise. ");
INSERT INTO agm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Isɨ amɨ sangisangi baiwɨ jaawo. Sangi isɨhiya jaipɨ nepɨ wɨsairapɨ nasamaasi nuwɨ pɨwɨha pɨwaatɨtaatɨwɨhapɨhɨsamaitaapo. Aiwɨ amɨ aŋɨ gwɨharaahaiwa ahoyanɨwɨ amɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundohɨwaiwa sinekokɨhaiwaapɨhɨ tɨsawɨtaapo. Aiwɨ kiya sahɨ nisapɨ gɨnunyaahotɨhandapɨ nisapɨsatɨwɨ sangisɨ nasamaasi nuwɨ awaisawɨhiyaamɨ ndɨhetɨ ahɨsitaapo. Ndɨhetɨ ahɨsisaihɨ sahɨ nisɨ pɨwɨha ausaapɨ kaundɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nisɨ pɨwɨha gaaha wanɨha akaaha yapɨpatɨ aunahɨpatɨ nahatewaara gaamapɨ nuwɨ isɨhiyai kiya baiwɨ atitaatɨwɨ ausaapɨ kaundisaihɨhura asisɨha ipotɨhaanɨhɨ sura noaipaitando. ");
INSERT INTO agm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Iyataatɨ sangisɨ jaipɨ nepɨ wɨsairapɨ nasamaasi pɨwɨha pɨwaatɨtaatɨwɨhapɨhɨ naisaihɨ sahɨ pɨwɨha napitɨtaatɨ kaundɨtɨhaawe tɨwɨ yaiwɨ pɨhɨtɨwɨ waatɨ gɨmunyaapɨse. Owe. Autaahaatɨho ketɨ kuraanɨhɨ sahɨ pɨwɨha katɨtaatɨwɨha nasamɨtaise. Nasamɨtaisɨ sahɨ baiwɨ pɨwɨha ausaapɨse. Iyataatɨ sa pɨwa sahɨ nehɨ sawanaatɨ wɨndɨ amusaitaapo. Owetɨtaise. Autaahaatɨhomɨ Itɨpɨho samɨhetapɨ pɨwɨha sahɨ katɨtaatɨwɨha ausaitaise. ");
INSERT INTO agm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Usa saingo saahoyai numwaapɨ isɨhiya usai numwisaihɨ kiya tiwɨtaapo. Iyonɨhɨ amɨ sapɨho komɨ mwaahoai naasɨkatɨ kiyatɨ isɨhiyaamɨ ikwɨraatɨhɨmahonɨhɨ kiya koai tiwɨtaapo. Iyonɨhɨ amɨ mwaaya matiya dopawɨ maatɨmaatiwɨ saniya sapiyai isɨhiyaamɨ ikwɨraatɨhɨmasaihɨ kiya tiwɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Iyataatɨ isɨhiya sapɨ apɨpaahɨ apowɨtaise. Sandɨ nisapɨ kiyaisɨ poundonɨhɨ kiya sangisɨ pohipɨsitaapo. Isɨ utaaho wo saiwa siya noaipahonɨhandɨ kandɨ andɨtita kaiwaisɨ ipɨhatisamatɨ asisɨha ipotɨhaapɨ jaatɨ bimisɨhoai Autaahaatɨho numwatɨ asɨtimatɨtandɨhandɨ numwɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Sahɨ utaaho woai iwinjaitaapo ko Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ nehɨ Autaahaatɨhopaahɨhɨ gaarehandɨ tɨhohɨtɨhandɨ arɨtaahandɨ ahetimbɨpɨhɨ apɨpaahɨ maipɨhapa kapɨhɨ ahɨmotɨhapɨhɨ gonɨhiyatɨ wanɨhandɨ ko nesi nandaatɨ maipɨyausoaasa netɨ nopɨsasonɨho. Iyonɨhɨ isɨhiya ese tɨwɨ yaiwɨ kiyaamɨ ambɨpatɨ mwɨtunɨwɨ usondaapo. (Utaaho pɨwɨha kɨma awɨndaaho biyatɨ gwɨnyaane). Isɨ sura isɨhiya Judiyaahanda bimohiyɨhiya kiyaamɨ Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ utaaho apɨpaahɨ maipɨhandɨ yawimatahandɨ kiyonɨhɨ kɨma asisɨha ipotɨhe tɨwɨ mmonɨwɨmapɨ yanɨhɨmapɨ sisɨhoaasɨnapɨ naiwɨse. ");
INSERT INTO agm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iyataatɨ isɨhiya sura kiyaamɨ aŋɨtaupwataatɨhɨ masapɨpɨhɨ bimambɨwɨhiya aŋɨtɨtɨhɨ kiyaamɨhapa isɨsi nutaatɨwɨhapa naitaatɨwɨhandapɨ wɨndɨ gɨmunyaitaapo. Aiwɨ kiyaamapa naitaatɨwɨ aŋɨtɨtɨhɨ wɨndɨ namɨndaapɨ yanɨhɨmaitaapo. ");
INSERT INTO agm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Iyonɨhɨ amɨ isɨhiya osaataatɨ bitombɨwɨhiya japɨhɨ nepemaitɨwɨ nuwɨ kiyaamɨhapa utɨ apotɨhɨrɨ kiyaamɨ aŋɨpɨpɨhɨ naitaatɨwɨ wɨndɨ namuwɨse yanɨhɨmapɨse. ");
INSERT INTO agm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aisaihɨ sura asɨhiya maaha sangɨhaisahiyaunɨ amɨ maahaapɨ gwɨsɨhiyaunɨ ketɨ sura yanɨhɨmapɨ namaisaihɨ yaawɨhandɨ naitauhɨ, “Ese”, nɨngi kiyaapɨ maarɨho tɨndataise. ");
INSERT INTO agm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Saiwa siyatɨ wipatɨ wipɨwatɨ boaahonɨhura sangisaapɨhɨ namwaipaitandɨ sahɨ Autaahaatɨhopɨ baiwɨ gaapundɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Amɨ sandɨ apaapɨmaato sura naaŋɨhandɨ apɨpaahɨ awaindɨhandɨ noaipaitaihɨto. Jɨhura Autaahaatɨho kahapaamapɨpa kiyatɨ ahaisuraapɨ nasatɨ wanɨ kɨmura siyahaiwa wɨndɨ namwaipase. Iyataatɨ amɨ ipotɨsangi wɨndɨ siyahaiwa naaŋɨhaiwa apɨpaahɨ awaiwaiwa wɨndɨ namwaipaitaise. ");
INSERT INTO agm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Isɨ Awaisɨho Autaahaatɨho asisɨha sa naaŋɨhaiwa apɨpaahɨ awaiwaiwa noaipaitandɨ netɨ nuhɨmaitandɨ aimɨ gwɨnyaase. O amɨ ko wɨndɨ siyatɨ asisɨha sa netɨ nuhɨmaamahonaahɨ isɨhiya wɨndɨ nga bɨmimaawɨ nahandɨ kiyaanɨhɨ owetɨtauhe. Saitɨhatɨ katɨ amɨ Autaahaatɨho isɨhiya komɨhiyaimatɨtaatɨwɨ aimɨ namɨhanatɨ ahɨwisawɨhiyaapimatonɨhɨ gwɨnyaataatɨ kiyai netɨ iwɨtatamanɨtandɨ namatɨ asisɨha netɨ nuhɨmaitaise. ");
INSERT INTO agm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Isɨ sura isɨhiya usa napɨwɨ nisapɨ satɨwɨ, ‘Kɨraisiho komɨ isɨhiyai japɨhɨ numwaitandɨ Autaahaatɨho namɨhainjɨho kɨmbɨhɨ kɨmosɨ jase amɨ yaihapɨhɨ yaihosɨ jase amɨ mɨhapɨhɨ mɨhosɨ jase,’ satisaihɨ amɨ sahɨ kiyaamɨ pɨwɨha atiwɨ wɨndɨ gɨmaawunyaapɨse. ");
INSERT INTO agm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Iyonɨhɨ amɨ isɨhiya usa taahiyɨhiya napɨwɨ sangi jaiwɨsatɨwɨ sasatɨtaapo. ‘Nɨnɨ kɨmonɨnɨ Kɨraisihonɨnɨ Autaahaatɨho komɨ isɨhiyai japɨhɨ numwaitandɨ nanɨmɨhainjɨhonɨne,’ satɨtaapo. Aiwɨ amɨ usa taahiyɨhiya nehɨ nɨnaasohɨ wura wura napɨwɨ satɨwɨ, ‘Nɨnɨ Autaahaatɨhomɨ pɨwɨha atindɨ netɨ kopɨ awusaahohɨhonɨne,’ satɨwɨ jaipɨsatɨtaapo. Aiwɨ amɨ kiya watɨpɨhaiwa kɨhaiwa kɨhaiwa kahatamatɨpetahaiwa kaitaapo. Satɨwɨ saiwa kiyawaahandɨ kandɨ Autaahaatɨho isɨhiya komɨhiyaimatɨtaatɨwɨ namɨhanatɨ ahɨwisawɨhiyai maawɨ jaipundɨwɨ numwaitaatɨwaitaapo. ");
INSERT INTO agm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Siyahaiwa noaipaitaihɨ amɨ kaiwa sangɨ noaipasɨhɨ nɨnɨ pɨwɨha jɨhɨ tɨmanɨtɨ aimɨ kasatataatonɨ sahɨ baiwɨ jaawo. ");
INSERT INTO agm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Saiwa siyatɨ naaŋɨhaiwa noaipatɨ owetanɨhura sura. ‘Ipɨho noaipatɨ asahatɨtaise. Iyonɨhɨ amɨ waatɨhoaisangi wɨndɨ namusaatɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Iyonɨhɨ amɨ kaumbwaatɨ yamɨhapataatɨhapɨ tɨmɨhaitaise. Iyonɨhɨ amɨ yamɨhapataatɨhɨ watɨpɨhaiwa ahotiwaiwa ahoainatɨ nasɨhaahaarɨndaise.’ ");
INSERT INTO agm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Iyonɨhɨ sura Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ nisɨ watɨpɨhandisa amɨ nisɨ yundanyaahaisatɨ watɨpɨhonɨnɨ tɨwipataatɨhɨ napisanɨhɨ isɨhiya ninjaitaapo. ");
INSERT INTO agm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Saindɨ sura nɨnɨ nisɨ enjerɨhiya otɨpɨpatɨhiya yamɨhapataatɨhapɨhiyai nandusaasɨto. Nandusoaasisanɨhɨ kiya nuwɨ nisɨ isɨhiya nisɨhiyaimatɨtaatɨwɨ namɨhanohiyɨhiyai nahataapɨpɨhɨ yapɨpatamunɨ amɨ yamɨhapataatɨhapunɨ mangɨrainɨ numwaapɨ nepɨ ahonitaapo. ");
INSERT INTO agm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Awaatɨpɨho kaindɨhandapɨ aimɨ mmowɨ nepɨ gwɨnyaapɨhiyaate. Awaatɨpɨho kupwɨratɨ tɨwɨhandɨwihɨ sahɨ mmonawaawɨ kɨmura yatɨhɨrɨ yatitandɨhuraare tɨwɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sahɨ saiwɨ aimɨ mmowɨhiyaatisɨ naaŋɨhaiwa siyahaiwa noaipahonɨhɨ mmonawaawɨ sahɨ nisapɨ satɨwɨ, ‘Ko napɨtandɨhura aimɨ detɨndaate,’ tɨwɨ gwɨnyaapɨse. ");
INSERT INTO agm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nɨnɨ akɨtɨnɨhɨ sangi sandɨ kasatataato. Isɨhiya kɨmuraahiya sangɨ napopɨ bimisaihɨ saiwa naaŋɨmaiwa nɨnɨ katohɨwɨmaiwa noaipaitaise. ");
INSERT INTO agm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yamɨhapatunɨ amɨ yapɨpatunɨ notɨ owetɨtaise. O nisɨ pɨwɨhaahɨ wɨndɨ owemetɨtaise. Owemetatɨ, Kaahɨ kaanɨhɨ ahotɨmɨ nutaise. ");
INSERT INTO agm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Iyataahandɨ kandɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ napɨtandɨhuraapɨ utaaho wo asisɨha sete amɨ ipɨhomɨ ndɨhaamɨ sɨwipatɨ suraare tatɨ wɨndɨ gɨmunyaatɨ wɨndɨ mose. Owe. Autaahaatɨhomɨ enjerɨhiya itɨpɨhiya otɨpɨpatɨhiya yamɨhapataatɨhapɨhiyɨhiyaisangi wɨndɨ mohopo. Owe. Aihɨ amɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨsangi wɨndɨ moho. Owe. Nehɨ Apɨho Autaahaatɨho sawahohɨhɨ asisɨha amɨ ipɨhomɨ ndɨhaamɨ sɨwipatɨ setɨ suraare tatɨ mmonatɨ gwɨnyaatɨ isɨwatɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Isɨ sahɨ baiwɨ jaawo. Sahɨ baiwɨ tɨmanɨnɨwɨ jatɨwɨse amɨ sahɨ asisɨha akaaha tɨtɨhɨ ahura noaipaitaise tɨwɨ wɨndɨ mopɨhiyaatiso. ");
INSERT INTO agm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sandɨ siyahande. Utaaho wo komɨ aŋɨpɨpɨhɨ namasi kaanɨhɨ wapɨhapɨ daitandɨ nutandɨ komɨ otɨpɨpatɨhiyai nisɨhapa kɨmba baiwɨ ninjaawɨ bimaawɨse undindɨhandamatiyahande. Iyatɨ komɨ otɨpɨpatɨ otɨpɨpatɨhiya kɨho kɨho jatɨtandɨhatɨ yiyandɨhɨ nunyataise. Iyatɨ maasomwaaŋɨ jatɨtandɨhoai, ‘Kɨnyɨ baimbɨ namopɨ koŋɨnɨhɨ jatɨme,’ undindɨhandamatiyahande. ");
INSERT INTO agm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Isɨ siyahandisɨ sahɨ baiwɨ jatɨwɨse, aŋaaŋamɨ satɨho napɨtandɨhandapɨ sahɨ wɨndɨ monɨwɨhiyaatiso. Iyatɨ komɨ napɨtandɨhura asisɨha taatɨ napandosuraatɨtaindɨho amɨ apatɨhɨ apwɨtetetɨtɨtaindɨho amɨ asisɨha wa taatɨ bowataatɨ sangɨ saasɨnɨhonɨhɨtɨtaindɨho amɨ ipɨho taatɨ yahutaahonɨhɨtɨtaindɨho. ");
INSERT INTO agm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Sahɨ nasisoaarɨ kiyaatɨnɨhɨ tɨmetɨwɨse. Amɨ wiwa ko ketɨ kuraanɨhɨ nasatɨ sahɨ nanɨhaiwɨ nanopotisaihɨ jasondaiso. ");
INSERT INTO agm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pɨwɨha kɨma nɨnɨ sangi tɨmetɨwɨse satɨtɨ kasatohɨma naasɨka isɨhiya nahatiyai sahɨ jaawɨ tɨmetɨwɨse undataato,” undatɨ Jisaasiho komɨ otɨpɨpatɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Asisɨha yatairɨ ahondaise amɨ Asisɨha awaisɨha Pasopaahandunɨ amɨ kimbapɨho nandapa bɨretɨhandɨ nipitandɨhandɨ yisɨhandɨ owehandɨ nandaatɨwɨha noaipaitando. Sandɨ jɨhura asisɨha wetɨ Autaahaatɨhomɨ enjerɨho otɨpɨpatɨho yamɨhapataatɨhɨ bimisɨho jɨtɨpatɨ aŋaaŋamɨ maasomwaaŋɨ jaahohɨpatɨ mmonataatɨ Isɨraherɨhiyaamɨ manyinya bwandɨpɨhiya jɨhiyai tɨmaawatɨ nehɨ nusatipasɨtɨhandapɨ gwɨnyaapɨ mmonɨwɨhaare. Sa asisa noaipasɨhura kiya nandapa bɨretɨhandɨ nipitandɨhandɨ yisɨhandɨ owehaunɨ maasapɨho sipɨsipɨhandunɨ nanawaayopo. Aiwɨhaasɨ ka asisɨha noaipaitandɨ nehɨ asisɨha yatairɨ ahotihɨ pɨrisihiya awaisawɨhiyaunɨ amɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ ahoyanɨwɨ pɨwɨha kanawaayopo. Aiwɨ kiya Jisaasihoai daihɨra wɨraapɨ nanɨhundɨwɨ jaiwaiwɨhɨretapɨ isɨwatawaawɨ sohoai tiwɨtaatɨwɨ kanawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Aiwɨ amɨ kiya sanawaatopo: “Nyahɨ asisɨha awaisɨha Pasopaahandetɨ sandɨ isɨhiyaamɨ ndɨhetɨ wɨndɨ kamaitɨhaawo, amɨ kiya wiwa maatɨmaatiwɨ pwɨsɨpatɨ noaipaitaiso. Isɨ gaasɨ namɨhaitɨhaawo,” nɨwɨ kanawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisaasiho aunahɨpa Betanihanda niyatɨ utaaho wo jɨhɨ asaaha pisapɨpa neho komɨ ambɨpatɨ Saimonɨhomɨ aŋɨpɨpɨhɨ nandaatɨ bindataise. Bindata ganɨhoaasɨnɨ taatɨ nandapa nainjɨhɨ apopaatɨ waatɨ onɨha wa atɨpatɨ apɨpaahɨ waamainjotahatɨ windaha nesi nasataise. Atɨpatɨ satɨ nawɨho awaindɨhandisahate. Onɨha atɨpatɨ windisɨha nupwɨ napuwɨtɨhandɨ owehaasɨ namatɨ nehɨ awɨha napuhohininapɨ maipɨhinjaapɨhapɨ tɨwɨtatosatɨ Jisaasihomɨ mɨtɨhaatɨhɨ nɨwisataise. ");
INSERT INTO agm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aihɨ kapɨhɨ isɨhiya usa bimohiyɨhiya kaatɨ siya nɨwihɨ kiya mmonawaawɨ mɨmaipaiwɨ gwɨnyapenawaayopo. Kiya saiwɨ mɨmaipaiwɨ gwɨnyapenɨwɨ satɨwɨ kanawaatopo. “Ese kɨmaatɨ apomaatɨ atɨpatɨ kɨmatɨ apɨpaahɨ nga waamainjotatɨ gaamatɨ napaapɨ nyahowatɨ nuhoaase? ");
INSERT INTO agm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","O satɨ atɨpitɨ isɨhiya usai nawɨhopɨ nunyaatɨ nawɨho ikihɨ murɨmo nga naito. Newaatɨ isɨhiya ikɨpɨpa owehiyai nga numwɨto,” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sanɨhauhɨ Jisaasiho kiyai saundataase. “Sahɨ kɨmaatɨ apomaati munyaipundɨwɨ itɨhɨmundɨwɨ bɨpi namɨhaapɨse. Sahɨ saiwa napaapundopo. Kaatɨ maipɨhatɨ kiyataamaise. Owe. Nɨngi apɨpaahɨ gaahatɨ kanisataise. ");
INSERT INTO agm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nahatewetɨ isɨhiya ikɨpɨpa owehiya sangisawɨ maasɨ nasisoaarɨ bimɨtaapo. Isɨ sahɨ kiyai wura wura iwɨtatamanɨtaapo. O amɨ nɨnɨhɨ sangisatɨ maasɨ nahatewetɨ wɨndɨ bɨmimɨto. ");
INSERT INTO agm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Apopaatɨ kɨmaatɨ wapa nga kaatɨ kaitandɨhapa aimɨ kiyataise. Kɨmaatɨ atɨpatɨ waamainjotɨhatɨ nisɨ ambɨpatetɨ nanuhoaasɨtɨmandɨ nɨnɨ anɨmwaahɨpatopɨ yamwaatɨtandɨhandapɨ nisɨ ambɨpatɨ netɨ apɨpaahɨ nɨmanatɨ kanisataise. ");
INSERT INTO agm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nɨnɨ sangi akɨtɨnɨhɨ kasatataato. Yapɨhɨ nahatewaara isɨhiya Autaahaatɨhomɨ pɨwɨha gaaha wanɨha ausaawaawɨ kɨmaatɨ apomaatamɨ kɨmandɨ gaamandɨ kaindɨmandapɨ pɨwɨhaatɨhɨ ahoyawɨ ausaapɨ katɨtaapo. Ausaapɨ katisaihɨ isɨhiya kaatapɨ gɨwunyapendaapo,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aihɨ sura Jisaasihomɨ otɨpɨpatɨhiya ikwɨmaindɨmwɨtihɨ auhɨramɨ yahurɨtisawɨhiya aposerɨhiyaamɨ wo komɨ ambɨpatɨ Judaasiho aunahɨpa Kariyotɨhandaahapɨho tiworisai nusepaatɨ mwɨtɨpɨwitandɨ notaise. Notɨ pɨrisihiya mɨtɨhiya jɨhiya (isɨhiya isɨhiyaapɨ nandapa kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai dɨpumanɨwɨ nunyohiyɨhiyaamɨ) awaisawɨhiyai Jisaasihoai kiyaamɨ ikwɨraatɨhɨmahonɨhɨ kiya tiwɨtaatɨwɨ mwɨtɨpɨwisatɨ nusepaataise. Nusepaatɨ, “Nɨnɨ koai saindɨ samɨ ikwɨraatɨhɨmatɨ nasamɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Satatɨ ko mwɨtɨpɨwisatɨ kaundihɨ kiya pɨrisihiya atisawaawɨ gaaso tɨwɨ waatɨ maaritawaapo. Aiwɨ kiya Judaasihoai nawɨho wo numwɨtaatɨwɨ watɨpɨtɨwɨ katawaatopo. Aihɨ Judaasiho Jisaasihoai kiyaamɨ ikwɨraatɨhɨmaitandɨhɨra daihɨraapunɨ asisɨha tɨtɨhɨ gaahetɨ numwɨtandɨhaapunɨ gwɨnyaatɨ jatata tɨmanataise. ");
INSERT INTO agm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nandapa bɨretɨhandɨ nipitandɨhandɨ owehapa sipɨsipɨho tipɨ tɨhɨwɨ gaarehandɨ Autaahaatɨhoai nunyawɨ komɨ gwɨtɨtɨhoaisawɨ nandaatɨwɨhaiwaamɨ asisɨha jɨhapɨha noaipataise. Iyataatɨ asisɨha sa awaisɨha kimbapɨho Pasopaahandamɨ jɨha noaipataise. Aihɨ kura asisɨha ketɨ Jisaasihomɨ otɨpɨpatɨhiya Jisaasihoai satɨwɨ nunjenawaapo. “Pasopaahandapɨ Sipɨsipɨhomɨ gwɨtɨtɨho nandapa bɨretɨhandɨ nandaapɨhapa nyahɨ newa maahapɨhɨ tɨhaatɨ tɨngɨmanɨtɨhaawɨ gwɨnyaapaise,” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aihɨ Jisaasiho komɨ otɨpɨpatɨhurɨ yahuri kapa Pasopaahandapɨ sipɨsipɨho tipɨ gwɨtɨtɨho bɨretɨhandɨ nandapa nandaatɨwɨhapa nepɨ tɨhɨmɨ tɨmanɨtaatɨmɨ pɨwɨha sata kaundatɨ natausaasataise. Iyatɨ ko kuri saundataase, “Sahuraahɨ aunahɨpata awaipatɨ sitihanda numwɨse. Numwɨ noaipasaihɨ utaaho wo onɨhaara waapoho niwatesiho daihɨra taatɨ niyonɨhɨ sɨhoaahɨ koaisamɨ nutandaise. Nutanɨwɨ ko nasɨtipa jɨhɨ niyonɨhɨ amɨ sahuraahɨ koai nɨwipinjai ipotɨ numwɨse. ");
INSERT INTO agm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ko notɨ aŋɨhandɨ wɨndaatɨhɨ nandaitaise. Ko aŋɨndɨ nandaasɨtɨndamɨ satɨhoai satɨmɨ nunjepɨ kaundɨmɨse. ‘Nyangi katanyasisɨho sanyatihe. Asisɨha kɨma awaisɨmetɨ nɨnɨ nisɨ otɨpɨpatɨhiyaisatɨ nandapa bɨretɨhandɨ sipɨsipɨhomɨ gwɨtɨtɨho Pasopaahandapɨ nandapa Autaahaatɨho Isɨraherɨhiyai Nehɨ Iwinjasɨhɨ Nga Bimohɨtɨhandapɨ Gwɨnyaawaatɨ nandandɨhapɨhɨ aŋɨpɨpɨhɨ maahɨpɨpɨhe? Nyatihe,’ undɨmise. ");
INSERT INTO agm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Satɨmɨ kaundisaihɨ ko aŋɨhandamɨ satɨho autaahɨ wɨrɨ awairɨhɨrotɨ kahapaamapɨpa ganɨho gwɨtɨho aimɨ tɨmanɨnda ahotahɨrotɨ netɨ nasisɨtaise. Nasisonɨhɨ kɨrotɨ nyahɨ Pasopaahandapɨ nandapa nandɨhaahapa nepɨ nyamanɨmɨse,” undatɨ kuri natausaasataise. ");
INSERT INTO agm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aihɨ kurɨ komɨ otɨpɨpatɨhurɨ atimɨ nomaise. Numwɨ aunahɨpatɨ awaipatɨ Jerusaremɨhanda noaipapɨ Jisaasiho kaundimumwaaŋɨ kamwaaŋɨ kaiwa tɨtɨhɨ noaipasɨhɨ mmonɨmɨ kiyamaise. Aimɨ asisɨha Pasopaahandetɨ nandapa Jisaasihoaisawɨ kiya nandaatɨwɨhapa nepɨ tɨmanamaise. ");
INSERT INTO agm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aihɨ asahataahura aimɨ napwɨhihɨ asɨhananaataatɨhɨ Jisaasiho komɨ otɨpɨpatɨhiya 12 kaiwɨhiyaisatɨ niyatɨ sapɨhɨ aŋɨpɨpɨhɨ nandaataise. ");
INSERT INTO agm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aihɨ kiya ganɨhomɨhinɨ nausanɨwɨ yaataatɨ bindawaawɨ nandapa taawɨ nanawaawɨ Jisaasiho komɨ otɨpɨpatɨhiyai saundataase. “Nɨnɨ akɨtɨnɨhɨ sangisɨ sandɨ kasatataato. Sahɨ kɨmiyaatamɨ otɨhatɨhapɨ wo nisɨ tiworɨhoŋimatɨpɨ nɨngisɨ isɨhiya nɨwɨtaatɨwɨhiya tiworisaamɨ ikwɨraatɨhɨnɨmaitaise. Wanɨ kɨmbɨhɨ ganɨmoaasɨnɨ nandapa maasɨ nɨngisatɨ maasɨ supwɨhandɨ waapohoaatɨhɨ bɨretɨhandɨ tɨmandaatɨ nainjɨmopɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Aihɨ komɨ otɨpɨpatɨhiya pɨwɨha sa atisawaawɨ maarɨho naaŋawisataise. Naaŋawihɨ namasawɨ nɨnaasohɨ saundɨwɨ, “Akɨtɨnɨhɨ nɨnɨ nisapɨno,” undɨwɨ Jisaasihoai nunjenawaapo. ");
INSERT INTO agm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aihɨ Jisaasihomɨha kiyai saundataase. “Usaapɨmaato owe. Sahɨ kɨmiyaatɨ 12 kaiwɨmiyaatamɨ woŋɨ nɨngisapɨ maasɨ nandapa bɨretɨhandɨ waapoho supwɨhandɨ disihandaatɨhɨ nimandisɨhoaatɨhɨ tɨmandaatɨ nainjɨmopɨto. ");
INSERT INTO agm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ye, kɨmandɨ nɨngi nanoaipaitandaindɨmandɨhɨ akɨtɨ tɨtɨhe. Autaahaatɨho komɨ pɨwɨhaatɨhapɨ nisapɨ napwɨtaise tatɨ katimumwaaŋɨ kamwaaŋɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ japepihɨrɨtɨ napwɨto. Iyataahandɨ kandɨ kɨmo utamo isɨhiya nɨwɨtaatɨwɨhiyaamɨ ikwɨraatɨhɨnɨmaitandaisɨmoai yaawatɨ apɨpaahɨ awaindɨhandɨ Autaahaatɨho numwɨtaise. Isɨ amɨ koaisɨ sanaatɨ namaamotaataahɨ ngaatɨtaihe. Koai sanaatɨ napaapɨ namotaihɨhotindɨho?” undatɨ kiyaisɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Saiwɨ kiya taawɨ nandapa nanɨwɨ bindawaawɨ Jisaasiho nandapa bɨretɨhandɨ wɨndɨ netaise. Netɨ isɨwatataatɨ Autaahaatɨhoai, “kɨnyɨ gaahoŋe gaare,” undatɨ gaapundataise. Gaapundatɨ naumbotɨ komɨ otɨpɨpatɨhiyai nunyataise. Nunyataatɨ saundataase. “Kɨmatɨ nisɨ ambɨpatisɨ sahɨ nepɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Iyatosatɨ amɨ wipatɨ kapɨhopɨ waapoho wainɨhandɨ netɨ gaapundatɨ Autaahaatɨhoai “kɨnyɨ gaahoŋe gaare,” undatosatɨ komɨ otɨpɨpatɨhiyai numwihɨ nepɨ nahatiya kapɨhombɨ nanawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kiya aimɨ nanɨhauhɨ Jisaasiho kiyai saundataase. “Kɨmandɨ wainɨmandɨ kapɨmopɨ windindɨmandɨ nisɨ jɨtɨpate. Nɨnɨ nisɨ jɨtɨpatɨ katɨ nuhoaataayo. Nuhaahonɨhɨ Autaahaatɨho katɨ netɨ komɨ isɨhiyaisatɨ kataahɨ pɨwɨha katatɨ wɨsasataise. Iyatɨ ka pɨwɨha wɨsasatɨ ahaisɨha wanɨ kɨmura netɨ watɨpɨmatɨ akaahe tatɨ nisɨ jɨtɨpatɨ nuhaamaitandiyohɨpataahɨ (Autaahaatɨho) komɨ isɨhiyai netɨ sawɨhoaisatɨ tɨmaamahɨwataise. Isɨ kɨmatɨ nisɨ jɨtɨmatɨ nuhaamaitandiyohɨmataahɨ isɨhiya tɨtaahiyɨhiyai (kiyaamɨ maipɨhaiwa nemwatɨ) iwɨtatamanɨtaise. ");
INSERT INTO agm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nɨnɨ akɨtɨnɨhɨ sangi sandɨ kasatataato. Wɨrɨhɨrɨ wainɨhandamɨ waapomo kɨmo nɨnɨ japɨhɨ wɨndɨ namandɨ bimaamɨ nundɨ Apɨhounɨ nɨnunɨ isɨhiyai iwinjaaha bindɨhaahuraahɨ wainɨhandɨ asɨtɨhandɨ yandɨpɨhomɨ waapoho asoho nando,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sata kaunda owetihɨ aunɨhɨhɨrɨ wɨrɨ katɨwɨmapaahɨ Jerusaremɨhanda namasi Sisɨho Oripɨhoaasɨnapɨ niyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Naiwɨ noaipapɨ Sisɨho Oripɨhoaasɨnɨ Jisaasiho komɨ otɨpɨpatɨhiyai saundataase. “Sahɨ nahatiyaatɨ nɨngi nanɨmasi yanɨhɨmaitaapo amɨ sandapɨ Autaahaatɨhomɨ pɨwɨhaatɨhɨsangi satatɨ jɨpatɨpindiso: ‘Sipɨsipɨhandi jaatɨ bitosɨhoai nɨnɨ tiwisanɨhɨ sipɨsipɨhandɨ yanɨhɨmatɨ kɨhɨra kɨhɨra nandairaitaise,’ tatɨ aimɨ jɨpatɨpindiso ");
INSERT INTO agm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Isɨ nɨnɨ napotatɨ japɨhɨ nepasi nɨnɨ jɨhɨ taatɨ Garirihandaahapɨ naito,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Aihɨ Pitaaho Jisaasihoai saundataase. “Nisaahoyaahɨ gi nangɨmasi yanɨhɨmaisaihɨhandɨ kandɨ nɨnɨhɨ gi nangɨmasi yamaanɨhɨmaito. Owetɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aihɨ Jisaasiho koai saundataase. “Nɨnɨ akɨtɨnɨhɨ gisɨ sandɨ kahɨtataato, kɨnyɨ atɨnime. Wanɨ kɨmura apɨmatɨhɨ otɨpwɨsɨpaatɨ sapɨho yataira sangɨ gaatonɨhɨ kɨnyɨ nisapɨ satɨpɨ, ‘Nɨnɨ koai wɨndɨ mausotɨ gɨmunyaatɨhonɨne,’ tɨpɨ mairɨmaara isɨhiyai kaundɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sata kaundihɨhandɨ kandɨ Pitaaho mwɨtetatɨ watɨpɨtatɨ saundataase. “Nɨnɨ gisatɨ maasɨ napwɨtandɨ kinyapɨ wɨndɨ mausotɨhonɨne mundɨto. Apɨpaahɨ akɨtɨnɨhɨ owetɨtaise,” undataase. Aihɨ amɨ otɨpɨpatɨhiya nahatiyaisangi nehɨ naasɨka katawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aihɨ kiya nuwɨ wapɨhɨ kapɨhamɨ ambɨpatɨ Getɨsemanihanda noaipawaayopo. Noaipapɨ Jisaasiho komɨ otɨpɨpatɨhiyai saundataase. “Sahɨ kɨmbɨhɨ bimaawɨse, nɨnɨ yambɨhɨ nundɨ gaapundɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Undatɨ nehɨ Pitaahoaisunɨ Jemɨsihoaisunɨ Jonɨhoaisunɨ singwaasisaahɨhɨ numwaasi naihɨ nowaayopo. Aihɨ komɨ ambɨpatɨ nahato naaŋawisatɨ maipɨwimataho notaise. ");
INSERT INTO agm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aihɨ kingwaasi saundataase, “Nɨnɨ nisɨ maarɨho ambɨpatɨ apɨpaahɨ awaindɨhandɨ naaŋanisatɨ yaasatɨ daahɨ nɨpatisatɨ mɨmaipɨnimainjɨhiyo. Sanimainjɨhɨ amɨ nɨngi apɨpaahɨ napwɨtaahɨnyihiyo. Isɨ sahɨ kɨmbɨhɨ bindawa baiwɨ jatɨwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Saundamapɨ notɨ onɨhɨ masɨwonjaapɨhɨ yapɨpatetɨ tɨmahiyatɨ ahondaatɨ gaapundataase. Iyatɨ siyatɨ gaapundataase sa asisɨha maipɨha ko yaawɨhandɨ naitandɨma amɨ gaatanaahɨ ka koai nehɨ nusatipatɨ sanutando. ");
INSERT INTO agm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iyatɨ ko Autaahaatɨhopɨ satatɨ gaapundataase. “Apa, nisɨ Apo. Apore nahatewa kɨnyɨ nga kaitaise. Isɨ Apore, nɨngisɨ yaasamaiwa kɨmaiwa waapoho ipɨho yahotɨ ikonatɨ maipɨho nanɨhohɨpatamataindɨ nɨnɨ naitandiyohɨwɨmaiwa nepɨnɨmapehɨtataato. Amɨ nehɨ kinyɨ maaritɨpɨ gwɨnyahingɨrɨhɨretɨ japepihɨre. Nɨnɨ maaritɨtɨ gwɨnyaahohɨrɨhɨretɨ kɨnyɨ wɨndɨ minjapepihɨrɨme. Owetane,” undatɨ Sapɨhoai kaundatɨ gaapundataase. ");
INSERT INTO agm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Siyatɨ gaapundamapɨ Jisaasiho nasatɨ mmonata komɨ otɨpɨpatɨhingwaasɨ nanoposauhɨ Pitaahoai saundataase. “Saimonɨhoŋe, nɨngisapɨ wonjɨ maipɨhonjɨ minjatɨpɨ napaapɨ nanɨhaimbɨ nanopotise? ");
INSERT INTO agm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sangi nasisendandɨhaiwa sangisaapɨhɨ namwaipaitandɨ sahɨ baiwɨ jatawa andɨtitɨwɨ gaapundɨwɨse. Maarɨhohɨ Autaahaatɨhomɨ gwɨnyaasɨrɨhɨretɨ kaitandɨ maaritihɨhandɨ kandɨ ambɨpatɨhɨ saiwa kaitandɨ wɨndɨ andɨtɨminje,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Saundamapɨ japɨhɨ notɨ gaapɨpatɨ jɨhɨ notɨ gaapundipatɨ katɨ jɨhara gaapundataase. ");
INSERT INTO agm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Gaapundamapɨ komɨ otɨpɨpatɨhiyenda japɨhɨ nasataise. Nasatɨ usonata kiyai naapɨpa apɨpaahɨ tiwamasɨhɨ nanomɨhauhɨ ahowimasɨhɨ nepapɨ pɨwɨha kaundɨtɨha owetihɨ kiya Jisaasihoai wihoaaŋɨha wɨndɨ kamundopo. ");
INSERT INTO agm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aihɨ Jisaasiho jɨhara niyatɨ mairɨ manda gaapundataase. Gaapundamapɨ japɨhɨ nasatɨ komɨ otɨpɨpatɨhingwaasi saundataase. “Saingwaasaatɨ daahɨ ikɨnɨwɨ nanopotawaayopo. Naapɨpa nga nanopɨ nepawaawaahɨ nutɨhaawɨ dopise. Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨhi isɨhiya maipɨhiyaamɨ ikwɨraatɨhɨnɨmaitaatɨwɨhura wanɨ kɨmuraare. ");
INSERT INTO agm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Isɨ saingwaasaatɨ dopise nutɨhaawo. Iwinjasawɨse utaaho nisɨ tiworɨho nɨngi nanɨmaatɨ isɨhiyaamɨ ikwɨraatɨhɨnɨmaitandɨho aimɨ kɨmo koaipataiso,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisaasiho satatɨ taatɨ kaundihɨ Jisaasihomɨ otɨpɨpatɨhiya ikwɨmaindɨmwɨtihɨ auhɨramɨ yahurɨtisawɨhiyaamɨ wo komɨ ambɨpatɨ Judaasiho ketɨ kuraanɨhɨ noaipataise. Ko Judaasihoaisawɨ isɨhiya taahɨtɨhandɨ pwɨsɨpɨ yaipa irɨhɨrɨ gupwatɨ namatanaatɨ bainatɨhɨrɨ isɨndihɨ nasawaayopo. Siya saiwa isɨpɨ nasohiyɨmiya pɨrisihiya awaisawɨhiya isɨhiyaamɨ maipɨhaiwaapɨ Autaahaatɨhoai nandapa maahoaipatɨ kohasɨpɨho tɨhɨwɨ dɨpumanɨhohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ amɨ gwɨnyaahiya usaunɨ siyai nepɨ natɨwusaasauhɨ napɨwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iyataatɨ utaaho Jisaasihoai netɨ isɨhiyaamɨ ikwɨraatɨhɨmaitandɨho pɨwɨha wa sata isɨhiyai kaundamapɨhore. “Nɨnɨ nundɨ utaaho woai naahipauma gerundisanaahɨ so Jisaasihosɨ ko naahipauma gerundohoai tɨtɨhɨ isɨpɨse. Isɨpɨ baiwɨ iwinjaawɨtopɨ numwaasi nutaatɨwe,” undatɨ kaundamapɨhore. ");
INSERT INTO agm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Isɨ ko ketɨ noaipatɨ detɨ Jisaasihoaapɨhɨ tɨtɨhɨ notɨ saundataase. “Katɨpɨnyasingɨhonye,” undatɨ naahipauma gerundataase. ");
INSERT INTO agm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aihɨ kiya sotihɨso tɨwɨ Jisaasihoai ikwɨra isɨpɨ wɨrawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aihɨ kapɨhɨ otɨhatɨhapɨ koai nɨwipinjohiyɨhiya bitohohiyɨhiyaamɨ wo komɨ namatɨnaatɨ bainatɨhɨrɨ napatatɨ pɨrisiho isɨhiyaamɨ maipɨhaiwaapɨ Autaahaatɨhoai nandapa kohasɨpɨho tɨhɨwɨ dɨpumanɨhohiyɨhiyaamɨ mɨtɨhomɨ otɨpɨpatɨhoai amɨtetetɨ mɨtɨhoaatɨhɨ tiwɨto tatɨ tɨmasɨhɨ ko nawisainjɨhɨ komɨ atihɨrɨ oturamasɨhɨ mɨhaapɨ yapɨpatetɨ tɨmahiyataise. ");
INSERT INTO agm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Aihɨ Jisaasiho kiyai sata kaundatase. “Sahɨ nɨngi nipɨ nanɨmaita nasohiyɨmiyaatɨ pwɨsɨpɨ yaipa irɨhɨrɨ gupwatɨ namatanaatɨ bainatɨhɨrɨ isɨpɨ nasohɨtɨmandɨ utaaho wo maatɨmaatisa tunnatɨ ikopaisahoai nimbɨpupwɨ isɨwɨtaatɨwɨhandamataiwɨ sahɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nɨnɨ asisɨha nahatewetɨ Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ samɨ ndɨhetɨ bindata pɨwɨha kandɨsasonɨhɨ sahɨ wɨndɨ kura nɨngisɨ maanipɨhiyaatiso. Iyataahandɨ kandɨ Autaahaatɨhomɨ pɨwɨha jɨpatɨpindirɨhɨrɨ kɨretɨ tɨtɨhɨ noaipaitandɨ gaasɨ sɨkiyatɨ noaipane,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Aihɨ Jisaasihomɨ otɨpɨpatɨhiya nahatiya koai namapɨ usesi kɨhɨra kɨhɨra yanɨhɨmapɨ nandɨwirawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Aihɨ utaaho wo waimwaaho apotɨhɨrɨ nehɨ naasairɨhɨ kɨhoepɨhɨrɨ niyoho Jisaasihoai nɨwipinjai maasɨ sura niyataise. Nɨwipinjai naihɨ isɨhiya koai pɨnuwɨ namaŋɨndɨwɨ isɨwawaapo. ");
INSERT INTO agm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Saiwɨ ko waimwaasoai pɨwuwɨ isɨwauhɨhandɨ kandɨ komɨ apotɨhɨrɨ naasairɨhɨ niyosɨrɨhɨrɨ nesɨpandɨwihɨ kɨrɨ kiyai nesɨpaunyamɨ somaahɨho yanɨhɨmataise. ");
INSERT INTO agm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Saiwɨ isɨpɨ Jisaasihoai numwaasi pɨrisiho wo isɨhiyaamɨ maipɨhaiwaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ mɨtɨho awaisɨhomɨ aŋɨpɨpɨhɨ numwaasi nowaayopo. Numwaasi niyauhɨ pɨrisihiya isɨhiyaamɨ maipɨhaiwaapɨ Autaahaatɨhoai nandapa tɨhɨwɨ dɨpumanɨhohiyɨhiyaunɨ amɨ isɨhiya usa gwɨnyaahiyaunɨ amɨ isɨhiya usa wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ siya nahatiya kapɨhɨ ahoyanɨwɨ bimauhɨhapɨhɨ Jisaasihoai numwaasi nuwɨ noaipawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Aihɨ Jisaasihoai numwaasi niyauhɨ sura Pitaaho Jisaasihomɨ ipotɨ koai yandɨhɨ kaanɨhɨ notaise. Notɨ pɨrisiho isɨhiya isɨhiyaamɨ maipɨhaiwaapɨ maahoaipatɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ mɨtɨhomɨ matambɨpotɨ nandaataise. Nandaatɨ masapɨpɨhɨ tingaatɨhaisahiyai bumasɨhɨ sisɨha tɨhoaahauhɨ kiyaisatɨ maasɨ bindata sisɨhainɨ tɨhwindataise. ");
INSERT INTO agm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Aihɨ isɨhiya isɨhiyaamɨ maipɨhaiwaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaunɨ amɨ usa Judaahiyaamɨ awaisawɨhiya nahatiyaunɨ isɨhiya usaapɨ gaatawaayopo kiya napɨwɨ Jisaasihopɨ, “Ko siyahoe satahoe,” tɨtaatɨwo. Sandɨ Jisaasiho wɨndɨ maipɨhandɨ kiyonɨhɨ atiwɨ newaawaahɨ koai sohoai tiwɨtaatɨwe. Saiwɨ kiyawaahandɨ kandɨ kaunjorɨhiya nahatiya ko maipɨhandɨ kaindɨhandɨ wɨndɨ mohopo. Owetise. ");
INSERT INTO agm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Isɨhiya taahiyɨhiya napɨwɨ pɨwɨha kɨha kɨha yiyandɨhɨ nesuwɨ katauhɨ kiyaamɨ pɨwɨha wa noaipatɨ tɨtɨhɨ wɨndɨ akaahaamimainje. Owetise. ");
INSERT INTO agm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aihɨ amɨ isɨhiya usa bitotawa pɨwɨha wa jaipɨtɨha nepɨ Jisaasihoai yawutaapɨ satɨwɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Jisaasimo kɨmo satahore. ‘Autaahaatɨhomɨ Aŋɨ Awaindɨhandɨ isɨhiya ikwɨra aŋɨmatotɨhandɨ nupwɨsasɨtɨma japɨhɨ asisɨha mairɨmanya saniyonɨhɨ ipotɨ aŋɨmatɨto. Isɨhiyaamɨ aŋɨmatohɨmumwaaŋɨ wɨndɨ aŋɨmaamatɨto. Owe. Nehɨ kandi wamwaaŋɨ noaipa aŋɨmatɨndɨtaise,’ tahoe,” taawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Amɨ pɨwɨha saiwaisangi isɨhiya siya katowiwa noaipatɨ wɨndɨ akɨtɨ akaahaamimainje. Owetise. ");
INSERT INTO agm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aihɨ pɨrisiho awaisɨho Kaiyapaasiho isɨhiyaamɨ maipɨhaiwaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ mɨtɨho awaisawɨhiya kaunjorɨhiya nahatiyaamɨ ndɨhetɨ dotɨ bitonda Jisaasihoai sata nunjenataise. “Isɨmiya kɨmiya kinyapɨ pɨwɨma kɨmaiwa kahɨtohɨwɨmaiwaapɨ kɨnyɨ wihoaaŋɨha kamundɨtaahɨmaasihaino? Kɨnyɨ kiya pɨwɨha kinyɨhetemapɨ katohɨwɨmaiwaapɨ wihoaaŋɨhapa kaundɨtaapɨhapa owetiso?” undatɨ ko Jisaasihoai nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Siyatɨ ko nunjesɨhandɨ kandɨ Jisaasihohɨ pɨwɨha wihoaaŋɨha koai kamunda nehɨ apɨhɨmaata bitondaise. Aihɨ awaisɨho mɨtɨho pɨrisiho jɨhaatɨ Jisaasihoai sata nunjenataise. “Kɨnyɨ Kɨraisihoŋɨ Autaahaatɨho nyahɨ apɨpaahɨ gaahoe taatɨ mepɨ autaahewaumwahohɨhomɨ Mwaahoŋo e woŋo?” unda nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aihɨ Jisaasiho komɨha koai saundataase. “Ye, kɨmɨkonɨne. Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ Autaahaatɨho nahatewaamɨ Awaisɨho Watɨpɨhomɨ ikwɨrɨ gaatɨhɨraihoaaŋɨ bindataatɨ autaahɨ mɨhotɨ yamɨhapataatɨhapɨ tɨwipatisatɨ taatɨ napisanɨhɨ sahɨ nɨngi ninjaitaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Sata Jisaasiho kaundihɨ ko pɨrisiho isɨhiyaamɨ maipɨhaiwaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ mɨtɨho sa pɨwa atisataatɨ apowihɨ komɨ apotɨhɨrɨ nipaatirɨhɨrɨ napwɨramatosatɨ sandaase. “Isɨhiya kɨmopɨ, ‘ko siya siya kiyahoe katahoe,’ tɨwɨ katɨtaatɨwɨhiya usaapɨ jɨhaatɨ gamaatɨtɨhaawo. Owe. ");
INSERT INTO agm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sahɨ sawanaatɨ aimɨ Autaahaatɨhopɨ komɨ sisɨpɨtindɨhandɨ atiwɨ newaapo. Amɨ ko komɨ pɨwɨhaara nɨnɨ Autaahaatɨhonɨne ndaasɨ sahɨ napitaiwɨ gwɨnyapenawaayopo?” undataase. Aihɨ kiya satawaatopo. “So maipɨhandɨ kandaasɨ napone,” tɨwɨ katawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aihɨ isɨhiya usa sapɨhɨ bitohohiyɨhiya namasawɨ maahoaipurɨpwɨ amɨ apotɨhɨrɨ nepɨ ndɨmaahomwaaŋɨ namaasaposawɨ kiya saundawaatopo. “Autaahaatɨhomɨ pɨwɨha atindɨ netɨ ausaatɨhonɨne tɨpɨhoŋisɨ wanɨ aho aho nɨngi nɨwataise tɨpɨ kanyate,” undɨwɨ nanipɨ maahɨpɨwaihɨrawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Isɨhiyaamɨ maipɨhaiwaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ pɨrisihiyaamɨ awaisɨho mɨtɨho pɨrisihomɨ aŋaaŋamɨ masapɨpɨhɨ yatɨhɨ Pitaaho bindataise. Bimihɨ ko pɨrisiho awaisɨho mɨtɨhomɨ otɨpɨpatɨhaatɨ waatɨ nasataise. ");
INSERT INTO agm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nasatɨ Pitaahoai usonata ko taatɨ sisɨhainɨ tɨhwimihɨ kaatɨ biyatɨ koai mwɨtɨpisa iwinjatataise. Iwinjatataatɨ Pitaahoai saundataase. “Kɨnyo, gimaawɨ yapɨpatɨ Garirihandaahapɨhoŋisɨ amɨ aunahɨpatɨ Nasaretɨhandaahapɨhoai nuwipinjohiyɨhiyaamɨ woŋe,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aihɨ ko Pitaaho kaati owe undatɨ sata kaundataase. “Nɨnɨ utaaho soaisatɨ wɨndɨ dahomaindɨhonɨne. Kɨnyɨ pɨwɨma kɨma kandingɨmaapɨ wɨndɨ gɨmaanunyaatatɨ amɨ wɨndɨ nɨngi namaanesɨpainje,” undataase. Saundamapɨ ko Pitaaho matambɨpaamɨ onepataapɨhɨ naihɨhura koho otɨpwɨsɨpaatɨ sapɨho waatɨ gandaase. ");
INSERT INTO agm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aihɨ apopaatɨ kaatɨ jɨhara Pitaahoai usonataatɨ kapɨhɨ isɨhiya bitohohiyɨhiyai sata kaundataase. “Kɨmo utaamo isɨhiya Jisaasihomɨhiyaamɨhore,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Sata kaundihɨhandɨ kandɨ Pitaaho owetatɨ satatɨ kaundataase “Nɨnɨ Jisaasihoaisatɨ maasɨ wɨndɨ apɨpaahɨ dahomaindɨhonɨne,” undataase. Aihɨ otɨhɨtihɨ kapɨhɨ isɨhiya bitohoyɨhiya Pitaahoai japɨhɨ saundawaatopo. “Akɨte, kɨnyɨ Jisaasihomɨhiyaamɨhoŋe. Kɨnyɨ tɨtɨhɨ Garirihandaahapɨhoŋe,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aihɨ Pitaaho watɨpɨta andɨtita sata kaundataase. “Utaaho so nɨnɨ wɨndɨ mausotɨhopɨ sahɨ katawaatopo. Isɨ nɨnɨ tɨtɨhɨ apɨpaahɨ akɨtɨnɨhɨ kandaatonɨ nɨnɨ jaipɨndɨ katisanaahɨ Autaahaatɨho nisɨ jaipɨndɨ katotɨhandapɨ yaasatɨ naaŋɨhandɨ naninyane,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sata taatɨ kaundihɨ ketɨ kuraanɨhɨ otɨpwɨsɨpaatɨ kasɨnɨhaatɨ gandaase. Aihɨ Pitaaho Jisaasihomɨ pɨwɨha jɨhɨ sata kaundisɨhaapɨ gwɨnyaataise. “Otɨpwɨsɨpaatɨ yataira sangɨ gaatonɨhɨ kɨnyɨ mairɨmaara nisapɨ koai wɨndɨ mausotɨhonɨne undɨtaise,” undatɨ Jisaasiho jɨhɨ kaundisɨhaapɨ gwɨnyapenataatɨ namatɨ waatɨ gotaise. ");
INSERT INTO agm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Aihɨ isɨhiya pɨrisihiya isɨhiyaamɨ maipɨhaiwaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ awaisawɨhiyaatihɨ amɨ isɨhiya usa wɨnɨhapɨpa katɨwunjohiyɨhiyaatihɨ amɨ isɨhiya usa gwɨnyaahiyaatihɨ amɨ isɨhiya usa awaisawɨhiya nahatiyaatihɨ asisɨhaatɨhɨ kohokoaisawɨ kapɨhɨ ahoyanawaayopo. Ahoyanɨwɨ Jisaasihopɨ pɨwɨha wa katɨwɨ wɨsasawaayopo. Aiwɨ Jisaasihoai kiya wɨrɨhɨrɨ wɨrɨ watɨpɨhɨrɨ ipipatamatiyahɨra wɨsasɨwɨ numwaasi nuwɨ awaisɨho gapɨnaaho Pairotɨhoaapɨhɨmawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Aihɨ Pairotɨho Jisaasihoai sata nunjenataise. “Kɨnyɨ Judaahiyai winjaapɨ bimingɨhoŋɨ awaisɨhoŋɨ kiŋɨhoŋo?” unda nunjenataise. Aihɨ Jisaasihomɨha wihoaaŋɨha koai saundataase. “Ye, saahɨ kɨnyɨ kɨwaahoŋɨ katapaase,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Aihɨ pɨrisihiya isɨhiya isɨhiyaamɨ maipɨhaiwaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ awaisawɨhiya pɨwɨha kɨha kɨha Jisaasihopɨ satahoe, siyahoe tɨwɨ awaisɨho Pairotɨhoai kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Satɨwɨ Pairotɨhoai kaundauhɨ Pairotɨho amɨ jɨhara Jisaasihoai saunda nunjenataise. “Isɨmiya kɨmiya kɨnyɨ atinɨhɨ pɨwɨha taahɨwaiwa kɨhaiwa kɨhaiwa kinyapɨ katawaatowɨ kɨnyɨ kaapɨ wihoaaŋɨha nyangi napaapɨ kamaanyatise?” undataase. ");
INSERT INTO agm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aihɨ Jisaasiho wihoaaŋɨha kiyai wɨndɨ kamundihɨ awaisɨho Pairotɨho kandapɨ waatɨ pɨhɨtatɨ gwɨnyapenataise. ");
INSERT INTO agm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kɨnaungwɨha nahatewetɨ asisɨha sa awaisɨha Pasopaahandɨ noaipasɨhura isɨhiya tɨtɨhɨ kiyaisunyaapɨ utaaho wopɨ ambɨhɨtɨwɨ utaaho soai nupusoaase tɨwɨ Gapɨnaaho Pairotɨhoai kaundauhaahɨ kiyaamɨ ambɨhɨtɨwɨ katotɨhoai tɨtɨhɨ nuwausoaasahore. ");
INSERT INTO agm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Isɨ sura utaaho wo komɨ ambɨpatɨ Barapaasiho napwɨtatɨ bindataise. So Barapaasiso Romɨhandaahapɨhiyaamɨ gamanɨho Judaahiyai iwinjaatɨ bimɨtandɨhandapɨ poundihɨ isɨhiya Judaahiya usaisɨ maatɨmaatiwɨ isɨhiya usa dopɨ tiwauhɨ tunnawaawɨ kiyaamɨ usaisɨ ko tiwihɨ napwauhɨ kandapɨ koai nepɨ napuhauhɨhore. ");
INSERT INTO agm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Aihɨ isɨhiya taahiyɨhiya wɨrɨsandɨhandɨ napɨwɨ Pairotɨhoai namasawɨ nunjenawaayopo. “Kɨnyɨ asisɨha awaisɨha kɨmiyaha noaipasɨhura napwɨtohiyɨhiyai nupusoaasapɨhoŋisɨ wanɨ amɨ katɨ kaimbɨ nupusoaase,” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aihɨ awaisɨho Pairotɨho kiyai sata nunjenataise. “Judaahiyaamɨ awaisɨhoai bɨpi nehɨ nuta nɨnɨ nandusaasano?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sandɨ sata kaundindɨmandɨ siyatɨ usona gwɨnyaataate. Isɨhiya pɨrisihiya isɨhiyaamɨ maipɨhaiwaapɨ nandapa maahoaipatɨ tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ awaisawɨhiya nyangi isɨhiya nahatiya namaanyipinjawɨ Jisaasihoai nɨwipinjowo tɨwɨ Jisaasihopɨ apowihɨ, “Nyahɨ gamanɨhomɨ awaisawɨhiyaanamɨhetɨmawaayowo,” tatɨ gwɨnyaataate. ");
INSERT INTO agm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kiyataahandɨ kandɨ pɨrisihiyaamɨ awaisawɨhiya mɨtɨhiya aimɨ jɨhɨ tɨmanɨwɨ isɨhiyai saundɨwɨ nusepaawaayopo. “Jisaasihopɨ wihoaaŋɨho Barapaasihoai nupusoaase undɨwɨse,” undɨwɨ awaisawɨhiya nusepaipapɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aihɨ Pairotɨho japɨhɨ kiyai saundataase. “Kɨmo utaamopɨ Judaahiyaamɨ awaisɨho kiyai iwinja bimisɨhoe tohɨmoai nɨnɨ napitɨwitande?” undataase. ");
INSERT INTO agm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aihɨ kiya japɨhɨ waapɨhɨtɨwɨ satawaatopo. “Ipɨ tɨtɨhɨ atawɨhatetɨ tipɨ nimaape,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aihɨ Pairotɨho kiyai saundataase. “Napaape? Ko wɨndɨ maipɨhandɨ kaiho nɨwipɨhandɨtowo?” undataase. Aihɨ kiya komɨha nemapɨ jɨhaatɨ waapɨhɨtɨwɨ kaahaatɨwɨ satawaatopo. “Jisaasihoai ipɨ tɨtɨhɨ atawɨhatetɨ tipɨ nimaape,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aihɨ Pairotɨho kiyaamɨ pɨwɨha napaisaatɨ bɨpi atɨwisatɨ isɨhiya wɨrɨsandɨhandɨ maaritorɨhɨretɨ Barapaasihoai nuwausoaasihɨ ko kiyenda naihɨ amɨ Pairotɨho katihɨ Jisaasihoai ainjɨhariwɨ yupawaayopo. Aiwɨ ipɨ tɨtɨhɨ atawɨhatetɨ tipɨ tipɨmandaitaatɨwɨ Pairotɨho netɨ Romɨhiyaamɨ pwɨsɨpɨ yaipa kaiwɨ tunnɨwɨ yahwɨnohiyɨhiyaamɨ ikwɨraatɨhɨmataise. Aihɨ kiya koai tipɨ tipɨmandaitaatɨwɨ numwaasi nowaayopo. ");
INSERT INTO agm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aihɨ Jisaasihoai Romɨhiyaamɨ pwɨsɨpɨ yaipa kaiwɨ tunnɨwɨ yahwɨnohiyɨhiya numwaasi utaaho wo awaisɨho gapɨnaaho Pairotɨhomɨ matambɨpotɨ niyawaayopo. Naiwɨ amɨ sasaahoya usa nahatiyai gaatɨwɨ numwaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gaatɨwɨ numwaahauhɨ akoyanɨwosawɨ apotɨhɨrɨ wɨrɨ nyanyipɨhɨrɨ awaisawɨhiya kiŋɨhiya niyohohɨrɨhɨrɨ nɨwisowaayopo. Aiwɨ amɨ wɨrɨhɨrɨ wɨrɨ mwɨtoaipatɨ kaarɨha nangisawɨ ningopɨ tingaatɨha kaiwɨ Jisaasihomɨ mɨtɨhoaatɨhɨ nɨwipaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Saiwɨ nɨwipaaposawɨ kiya namasawɨ isɨhiya kiŋɨhiya awaisawɨhiyai kawisohɨpatamataiwɨ sisɨpɨhundɨwɨ kaiwunjawɨ saundawaatopo. “Judaahiyaamɨ kiŋɨho awaisɨhoŋɨ iwinjaapɨ bimingɨhonye, ipɨhɨrete,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Saundɨwɨ Romɨhiyaamɨ pwɨsɨpɨ yaipa kiyohiyɨhiya taahɨwaiwaara Jisaasihoai mɨtɨhoaatɨhɨ irɨhɨra tiwawaayopo. Aiwɨ koai maahoaipurɨpwɨ kiyaamɨ ipɨhomataiwɨ iwiwɨ amɨ isɨhiya awaisawɨhiyai ambɨpatɨ awaipatɨ nunyawɨ atotɨpɨwesohɨrɨhɨretɨ kaiwɨ koai ambɨpatɨ awaipatɨ nunyawaahandamataiwɨ atotɨpɨwesawunjawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Saiwɨ sisɨpɨhundɨmbɨwɨ gaatihɨ apotɨhɨrɨ nyanyipɨhɨrɨ nɨwisohohɨrɨhɨrɨ nesɨpamapɨ komɨhɨrɨ japɨhɨ nepɨ nɨwisowaayopo. Nɨwisopɨ Pairotɨhomɨ masaataatɨ namasi Jerusaremɨhandamɨ matambɨpaamɨ ipaahaapɨ noaipapɨ tipɨ nimaitaatɨwɨhapɨhapɨ numwaasi niyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Utaaho wo aunahɨpatɨ Sairinihandaahapɨho komɨ ambɨpatɨ Saimonɨho Arekɨsandaayɨ Rupaasiyaamɨ sapɨho nehɨhaatɨ daaya bitonjatɨ aunahɨpa Jerusaremɨhandaahapɨ taatɨ naihɨhoaisawɨ daihɨra otɨhapɨhɨ nutanawaayopo. Aiwɨ koai nɨwimbɨpupwɨ, “kɨnyɨ Jisaasihomɨ ipɨ tɨtɨhɨ atawɨhatɨ nepɨ tɨpwɨte,” undɨwɨ andɨtitɨwɨmapɨ nepɨ tɨpwɨtɨwusosawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aiwɨ Jisaasihoai numwaasi Gorɨkotaahandaahapɨ niyawaayopo. Sandɨ Gorɨkota tɨwɨ ambɨhɨtohɨtɨmandamɨ tanyaaha siyate. Mɨtɨhomɨ andɨtatamatetimbɨpɨho tɨwɨ katawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Aiwɨ kiya wainɨhandisawɨ marasinɨho wo komɨ ambɨpatɨ mɨrɨhoaisawɨ ahoyawɨ naumbwaihɨrɨwɨ Jisaasihoai komɨ ambɨpatɨ awaindɨhandɨ nɨwɨnatɨ yaahomaawɨtandɨho nunyauhɨhandɨ kandɨ kohɨ pohipiyatɨ netɨ wɨndɨ namainje. ");
INSERT INTO agm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aihɨ kiya Jisaasihoai ipɨ tɨtɨhɨ atawɨhatetɨ tipɨ nimaawaayopo. Saiwosawɨ Jisaasihomɨ apotɨhɨrapɨ ndɨ nese tɨwɨ jatawa wapa ipɨpa isɨwɨ jɨhimatɨwɨ nusatipɨhaahohiyɨhiya Jisaasihomɨ apotɨhɨrɨ kɨhonjɨ kɨhonjɨ newaayopo. ");
INSERT INTO agm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sura asisɨhaatɨhɨ ipɨho aimɨ nasa saasihɨ 9 kirokɨhura Jisaasihoai tipɨ nimaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aiwɨ Jisaasihomɨ mɨtɨhomɨhinɨ autaahɨ pɨwɨha kaundɨwɨ tiwohɨha satɨwɨ jɨpatɨpaiwɨ ahiyawaayopo. “Kɨmo utaamo Judaahiyai iwinjaatɨ bimisɨho awaisɨhore,” tɨwɨ jɨpatɨpaiwɨ ahiyawaapo. ");
INSERT INTO agm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Aiwɨ amɨ utaahurɨ wurɨ ikopaisahurɨ Jisaasihomɨ ikwɨrɨ gaatɨhɨraihoaaŋɨ wotihɨ amɨ ikwɨrɨ konaamohɨraihoaaŋɨ wotihɨ tipɨ nimaawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Aihɨ Autaahaatɨhomɨ pɨwɨhaatɨhɨ jɨpatɨpindisɨhaamɨ pɨwɨha akaaha noaipataise. Pɨwɨha sa sataha jɨpatɨpindise. “Isɨhiya maipɨhaiwaisahiyaisatɨ maasɨ utaaho maipɨhomataiwɨ isɨhiya usonawaayopo,” tatɨ jɨpatɨpindise. ");
INSERT INTO agm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aihɨ isɨhiya nuwɨ napɨwaiwɨ mɨtɨho nepemaihɨrɨwɨ bitotawa Jisaasihoai sisɨpɨhundɨwɨ saundawaatopo. “Ese. Kɨmoŋe, Autaahaatɨhomɨ Aŋɨ Awaindɨhandɨ nɨnɨ nupwɨsasɨtɨ japɨhɨ ketɨ asisɨha mairɨmetɨ aŋɨmatɨtɨ owemaito tɨpɨhoŋe. ");
INSERT INTO agm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Isɨ wanɨ kɨmura kɨnyɨ kinyɨ ambɨpatisɨ andɨtɨwipe. Aimbɨ ipɨ tɨtɨhɨ atawɨhati namasi japɨhɨ noaatɨpape,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aihɨ amɨ isɨhiya pɨrisihiya isɨhiyaamɨ maipɨhaiwaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai nunyohiyɨhiyaunɨ amɨ isɨhiya usa wɨnɨhapɨpa katɨwunjohiyɨhiyaisangi katɨ nepɨ Jisaasihoai sisɨpɨhundawaatopo. Aiwɨ kiya sawana sanawaatopo. “Kɨmo utaamo isɨhiyai tɨtɨhɨwiwatɨ andɨtɨwiwahosɨ amɨ komɨ ambɨpati napaapɨ tɨtɨhemaama andɨtɨmaawise? ");
INSERT INTO agm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Amɨ kɨmo akɨtɨ tɨtɨhɨ Kɨraisiho Isɨraherɨhiyai iwinjaatɨ bimisɨhondaataahɨ ipɨ tɨtɨhɨ atawɨhati namasi noaatɨpane. Noaatɨpahonɨhɨ nyahɨ winjɨhaawɨ kopɨ nyahɨ gɨwunyaitaano,” nnawaatopo. Aihɨ amɨ kapɨhɨ utaahurɨ yahurɨ ikonɨmɨhuri Jisaasihoaisawɨ maasɨ tipɨ nimaahohururisangi Jisaasihoai mɨmaipaimɨ itɨhundamaase. ");
INSERT INTO agm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Aihɨ ipɨho aimɨ saniya otɨhasɨnɨ 12 kirokɨhandɨtihɨ nahataapɨpɨhɨ asahatindɨhandɨ namaasatɨ asahatamataise. Asahatɨmɨ notɨ ipɨho aimɨ notɨ yaataatisura 3 kirokɨhuraatihɨ japɨhɨ taatɨ saasɨnataise. ");
INSERT INTO agm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Iyatɨ taatɨ kura saasɨna bowihɨ Jisaasiho waatɨ kaahaata sandaase. “Eroi, Eroi Rama Sapakɨtani?” ndaase. Sandɨ sata katindɨmandɨ sandaase. “Nisɨ Autaahaatɨhoŋe, Nisɨ Autaahaatɨhoŋe, kɨnyɨ nɨngisɨ napaapɨ nanɨmahise?” ndaase. ");
INSERT INTO agm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aihɨ isɨhiya kapɨhɨ detɨ bitohohiyɨhiya sa pɨwa atisawaawɨ sanawaatopo. “Atiwɨse! Kɨmo utaamo Eraijaahopɨ gandaaso!” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aihɨ utaaho wo nihɨti notɨ wainɨhandɨ ikonahandaatɨhɨ sɨponjɨhandɨ wɨndɨ dɨhaamatiyahandaahɨ tɨmandaatɨ boyatɨ netɨ asatɨpatamɨ otasaahaasɨnɨ mwɨtiwatɨ isɨsi niyataise. Niyatɨ detɨ bitonda kandɨ Jisaasiho nandota nunyataatɨ kiyai saundataase. “Nyahɨ nehɨ jatɨtɨhaawo Eraijaaho ambɨhɨtisɨho noaatɨpatɨ japɨhɨ napɨhausoaasonɨhɨ yapɨpatetɨ tɨmɨhaiso e owetisotaato!” undataase. ");
INSERT INTO agm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aihɨ Jisaasiho waapɨhɨta gaatamapɨ konɨhɨ napomataise. ");
INSERT INTO agm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Siyatɨ Jisaasiho napwihɨ ketɨ kuraanɨhɨ apotɨhɨrɨ wɨrɨ awairɨhɨrɨ mwipɨhɨrɨ watɨpɨhɨrɨ Aŋɨ Awaindɨhandaatɨhɨ Autaahaatɨho nasatɨ komɨ ndɨmaahomwaaŋɨ ahiyatɨ bimɨtandɨrotɨ netɨ nimbɨpuwatɨ nahoesandirɨhɨrɨ mɨhaatapɨ mɨhaapɨ kɨrɨnɨhɨ otutaatɨ napwɨrɨnataise. ");
INSERT INTO agm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aihɨ siyatɨ Jisaasiho napwihɨ utaaho wo tiworisa tunnɨwɨ yahwɨnohiyɨhiyaamɨ awaisɨho Jisaasihomɨ detɨ utatototɨ bitonjahosɨ komɨ ndɨhetɨ napwihɨ usonataatɨ ko sandaase. “Kɨmo utaamo tɨtɨhɨ akɨtɨnɨhɨ Autaahaatɨhomɨ Mwaaho akohore!” ndaase. ");
INSERT INTO agm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aihɨ amɨ asɨhiya usaisangi onɨhɨ wonjɨ bitotawa Jisaasihoai winjatawaayopo. Kiyaamɨ otɨhatɨhapɨ waatɨ aunahɨpa Makɨtaraahandaahapɨhaatɨ Mariyaahaate. Aihɨ amɨ waatɨ Mariyaahaatɨ waate. Kaatɨ Jemɨsiho ipotɨhomunɨ Josisihomunɨ sanaate. Aihɨ amɨ waatɨ Saaromihaate. ");
INSERT INTO agm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Siya asiya jɨhɨ Jisaasiho otɨpɨpatɨ kiya Garirihanda daihɨ kiya kaiwusepaapɨ maasɨ nɨwipinjawɨ daayohiyɨhiyaatihɨ amɨ usa Jerusaremɨhandaahapɨ Jisaasihoaisawɨ maasɨ niyohiyɨhiyai maawɨ kapɨhɨ bitotawa iwinjatawaapo. ");
INSERT INTO agm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Aihɨ utaaho wo komɨ ambɨpatɨ Josepɨho aunahɨpatɨ Arɨmatiyaahandaahapɨho sapɨhɨ bindataise. So utaaso kaunjorɨho awaisɨho wandɨhaisahore. Iyataatɨ amɨ koaisangi Autaahaatɨho komɨ isɨhiyai iwinjaatɨ bimɨtandɨhandapɨ jaatɨ bindataahore. Isɨ ko mmona gwɨnyapenata bosonɨhɨ kiya Judaahiyaamɨ asisɨha ikɨndaatɨwɨha Sapaatɨhandɨtɨtaihɨ otɨpɨpatɨ wapa wɨndɨ kamaitɨhaawɨ wanɨ kɨmura kahapaamapɨpa tɨmanɨndaatɨwɨhuraatihɨ gwɨnyapenata ipɨho aimɨ namaatipaitandaihɨ namatɨ ko yamaayatɨ awaisɨho Pairotɨhoaapɨhɨ notaise. Notɨ noaipatɨ awaisɨho Pairotɨhoai Jisaasihomɨ ambɨpatɨ ipɨ tɨtɨhɨ atawɨhatetapɨ napɨhaatɨ naitandɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Aihɨ ko awaisɨho Jisaasihopɨ aimɨ ketɨ napwihɨndindɨho tatɨ waatɨ gwɨnyapeninja tiworisa tunnɨwɨ yahwɨnohiyɨhiyaamɨ awaisɨhoai gaata numwaataise. Gaata numwaatɨ koai saundatɨ, “Jisaasiho aimɨ napwiso e sangɨ napwiso?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aihɨ awaisɨho Pairotɨho nunjesɨhɨ, aimɨ napwise undihɨ Josepɨhoai saundataase. “Gaasɨ, kɨnyɨ Jisaasihomɨ ambɨpatɨ napɨhaapesi numwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sata ko aye undihɨ Josepɨho apotɨhɨrɨ wɨrɨ kɨhoepɨhɨrɨ nawɨho nunya nesiya Jisaasihoai napɨhaatɨ kɨraapɨhɨ ahiya napapɨhataise. Napapɨhatɨ isɨsi niyatɨ nawɨha wa isɨhiya soaariwɨ akohaahaiwɨhotɨ ahiyataise. Ahiyatosatɨ nawɨha taapwɨnɨha naaŋɨha awaisɨha netɨ nepehaasa maahomwaaŋɨ anɨtisatɨ awaahatɨ napuwataise. ");
INSERT INTO agm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Siyatɨ Josepɨho Jisaasihoai ahiyatɨ anɨtisatɨ napusɨhɨ aunahɨpa Makɨtaraahandaahapɨ Maariyaahaatɨtihɨ amɨ Mariyaahaatɨ waatɨ Josesihomɨ sanaatɨtihɨ iwinjatɨmbɨmɨ amɨ Jisaasihoai ahaimbɨpɨhɨ mmonɨmapɨ nomaise. ");
INSERT INTO agm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Judaahiyaamɨ asisɨha Sapaatɨhandɨ aimɨ owetihɨ asahataahura asɨhiya aunahɨpa Makɨtaraahandaahapɨ Mariyaahaatɨtihɨ amɨ Saromihaatɨtihɨ amɨ Mariyaahaatɨ waatɨ Jemɨsihomɨ sanaatɨtihɨ sinya nuwɨ atɨpatɨ wɨtɨ biya waamainjotɨhatɨ Jisaasihomɨ ambɨpatetɨ nesaiwɨ nurɨhapɨ winjaitaatɨwɨ nawɨho nunyawɨ newaayopo. ");
INSERT INTO agm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Saiwɨ atɨpatɨ waamainjotahatɨ nunyawɨ nepɨ tɨmanɨwɨ nanopawɨ bowihɨ asisɨha jɨhetɨ, Sandehura asisɨhaatɨhɨ kohokoaisawɨ ipɨho aimɨ yahutaasɨhɨ katɨ atɨpatɨ isɨsi Jisaasihomɨ ambɨpatetɨ jaitaatɨwɨ koai ahiyohɨpɨpɨhɨ nawɨhaamɨ anɨmwaahɨpataapɨhapɨ niyawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Niyawaawɨ daihɨra otɨhapɨhɨ sawinya sanawaatopo. “Ese! Jisaasihoai ahiyotɨhandamɨ maasomwaaŋɨ mipatetɨ nawɨha aungwohanda nepehaasawɨ anɨtiwɨ napuhowɨ ndɨ netɨ nepehaasa nuwatɨnyosɨtande,” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sanɨwosawɨ naingaapɨ jawa wa nawɨhandɨ wɨndɨ maasomwaaŋɨ mipatetɨ namaapundihɨ utaaho wo netɨ nepehaasa nemasɨhɨ nehɨ maasomwaaŋɨ nundihɨ jawaayopo. Iyataatɨ sa nawa apɨpaahɨ awaisɨha naaŋɨhaare. ");
INSERT INTO agm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Siyatɨ maasomwaaŋɨ nundihɨ kiya nandaapɨ mɨhatɨhɨ jawa utaaho wo waimwaaho apotɨhɨrɨ nehɨ amɨnaihɨrɨ kɨhoepɨhɨrɨ utaarɨhɨrɨ nipaataho ikwɨrɨ gaatɨhɨraihoaaŋɨ bimihɨ iwinjawaayopo. Iwinjaposawɨ waatɨ yaiwɨpwitawaayopo. ");
INSERT INTO agm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yaiwɨmahauhɨ ko kiyai saundataase. “Sahɨ wɨndɨ waatɨ yamaiwɨse owe. Sahɨ Nasaretɨhandaahapɨ Jisaasihopɨ daapɨ nasauhɨ nɨnɨ aimɨ jasoho ipɨ tɨtɨhɨ atawɨhatetɨ nimaapɨ tipɨmandaahohɨhopo. Isɨ ko wɨndɨ kɨmbɨhɨ ahɨmotise owe. Aimɨ japɨhɨ nepasi naise. Koai ahiyohɨpɨpɨhɨ kɨmbɨhisɨ sahɨ sawanaatɨ mmowɨse. ");
INSERT INTO agm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Isɨ sahɨ nuwɨ komɨ otɨpɨpatɨhiyai kaundɨwɨse. Aiwɨ amɨ Pitaahoai maawɨ kaundɨwɨse. Kaundawaawɨ saundɨwɨse. “Jisaasiho aimɨ jɨhɨ satindɨhande, ‘Nɨnɨ napotatɨ japɨhɨ nepasi Garirihandaahapɨ nɨnɨ jɨhɨ taatɨ naito,’ undindɨhandisɨ aimɨ nepasi ko jɨhɨ Garirihandaahapɨ naisɨ kiya koai kapɨhɨ iwinjaita ipotɨ naita kaundɨwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aihɨ kiya asiya noaipasi kapɨhɨ namasi yanɨhɨmapɨ nowaayopo. Nowaawɨ kiya kiyaamɨ maarɨho owesoetihɨ yaiwɨ itipɨ nowaayopo. Nowaawɨ isɨhiya usai wɨndɨ kamundopo, owe. Sandɨ kamundotɨmandɨ apaapɨmaahe. Kiya aungwohandɨ yaiwɨmawaawe. ");
INSERT INTO agm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Saraarehɨramɨ asisɨha jɨhetɨ (Sandehura) Jisaasiho asisɨhaatɨhɨ apɨ kohokoaisa japɨhɨ nepataise. Siyatɨ ko aimɨ nepasɨhura ipotɨ Mariyaahaatɨ aunahɨpa Makɨtaraahandaahapɨhaataapɨhɨ jɨhɨ noaipataise. Saatɨ itapaatɨ jɨhura Jisaasiho itɨpɨho maipɨhapa ikwɨrɨ naasairɨtihɨ wihɨnɨramɨ yahurɨtahapai nemwasaamaate. ");
INSERT INTO agm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Isɨhiya Jisaasihoai nɨwipinjawɨ koaisawɨ maasɨ daayohiyɨhiya Jisaasihopɨ maarɨho tundihɨ taawɨ gwɨwɨ bimauhɨ kaatɨ Jisaasihoai usosɨtɨhandapɨ notɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kiyaisɨ Jisaasiho japɨhɨ asohoematatɨ nepasɨtɨhandapunɨ amɨ kaatɨ sawɨhaamɨ koai usosɨtɨhandapunɨ kiyai kaundihɨ kiya kaatamɨ pɨwɨha atisawaahandɨ kandɨ kaatamɨ pɨwɨhaapɨ akɨte tɨwɨ wɨndɨ baiwɨ atiwɨ nepɨ gɨmunyaahopo, owe. ");
INSERT INTO agm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kaihɨ otɨpɨpatɨhurɨ yahurɨ aunahɨpa namasi taamɨ daihɨra naihɨ Jisaasiho noaipatɨ wɨndɨ jɨhamatɨmetatɨ nehɨ koai wipetaho kuri iwinjataise. ");
INSERT INTO agm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Aihɨ kurɨ japɨhɨ nepemaitɨmɨ numwɨ otɨpɨpatɨhiya amɨ usai, “Yɨhoaaŋɨ Jisaasihoai iwinjaho,” undɨmɨ kaundihɨhandɨ kandɨ kiya kuramɨ pɨwɨha kaundisɨhaapɨ wɨndɨ akaahe akɨte tɨwɨ atɨwiwɨ gɨmaawunyaahopo. Owetise. ");
INSERT INTO agm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aihɨ ipotɨnɨhɨ Jisaasiho sawaho komɨ otɨpɨpatɨhiya ikwɨmaindɨmwɨtihɨ auhɨramɨ naasohɨtahiya 11 kaiwɨhiya bindawa taawɨ nandapa nanɨhauhɨ noaipatɨ nunjaanatɨ iwinjataise. Noaipatɨ iwinjatɨ itɨhundataase. Sandɨ itɨhundindɨmandɨ apaapɨmaahe, isɨhiya usɨhiya asɨhiya ko aimɨ nepasɨhɨ usonɨhohiyɨhiya Jisaasihopɨ aimɨ japɨhɨ nepase undɨwɨ kaundauhɨhandɨ kandɨ kiya daahɨ kiyaamɨ maarɨho nimbɨputɨwɨ wɨndɨ kopɨ akɨte tɨwɨ gɨmunyaahauhɨ kandapɨ itɨhundataase. ");
INSERT INTO agm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iyatɨ kiyai pɨwɨha sata kaundataase. “Sahɨ yapɨpatɨ nahatewaara gaamapɨ nuwɨ isɨhiya nahatiyai nisɨ Pɨwɨha Gaaha Wanɨha anusaapɨ kaundɨwɨse. ");
INSERT INTO agm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pɨwɨha Gaaha Wanɨha kandɨ kiyohɨwaiwaapɨ ausaasaihɨ utaaho itapaatɨ wo waatɨ atisatɨ pɨwɨha kaapunɨ nisapunɨ gɨnunyaasɨho gɨnunyaasaamaati waapohora baawusisaihɨ Autaahaatɨho soai saati japɨhɨ numwaitaise. O utaaho itapaatɨ wo waatɨ nisapunɨ amɨ nisɨ pɨwɨhaapunɨ nepɨ nimbɨpwɨtɨwɨ wɨndɨ gɨmaanunyaasɨho gɨmaanunyaasaamaatɨ ipotɨhura kɨnyɨ maipɨhoŋe, maipɨhaaŋe undatɨ komɨhetɨ kaatamɨhetɨ Autaahaatɨho pɨwɨha netɨ yawutoaatɨ yaawɨhandɨ nunyatɨ nemaitaise. ");
INSERT INTO agm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Autaahaatɨho isɨhiya nisapɨ baiwɨ gɨnunyaahohiyɨhiyaisatɨtonɨhɨ kiya nisɨ ambɨpataahɨ watɨpɨhaiwa kaitaapo. Nisɨ ambɨpataahɨ Bwaasɨrɨhɨramɨ itɨpɨho maipɨhapa isɨhiyaamɨhetɨ omaŋɨtɨtɨhɨ bimiwaiwai nepumaitaapo. Aiwɨ amɨ pɨwɨha wa kiya wɨndɨ pɨwaamaatɨwɨha wanɨha wanɨhandɨ Autaahaatɨhomɨ Itɨpɨho Gaaho netɨ kiyai gɨwunyaahonɨhɨ kiya pɨwaatɨtaapo. ");
INSERT INTO agm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aiwɨ amɨ akwɨranɨho tataapwɨnɨhoai iwisaihɨ ko wɨndɨ ikomaawɨtaise. Aiwɨ amɨ onaapɨpa wapa nanawaawɨ kiya wɨndɨ kapa onaapɨpaapɨ namwaapwɨtaapo. Aiwɨ amɨ kiya timbɨpaisahiyai ikwɨrɨ kiyaamɨhetɨ ahɨwisaihɨ kiyaamɨ timbɨpa ketɨ owesuetɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Awaisɨho Jisaasiho pɨwɨha saiwa kaunda owetihɨ Autaahaatɨho koai yamɨhapataatɨhapɨ numwaasi naihɨ niyatɨ yamɨhapataatɨhɨ Autaahaatɨhomɨ ikwɨrɨ gaatɨhɨraihoaaŋɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aihɨ komɨ otɨpɨpatɨhiya yapɨhɨ nahatewaara nuwɨ gaamapɨ Autaahaatɨhomɨ pɨwɨha gaaha wanɨha Jisaasihopɨtaha awusoaawaayopo. Siyauhɨ Awaisɨho kiyai andɨtɨwiwa kiyaisatɨtihɨ kiya watɨpɨhaiwa kaiwa kaiwa kiyauhɨ isɨhiya mmonawaawɨ Autaahaatɨhomɨ pɨwɨha akɨtɨha akaahaare tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Awaisɨhoŋɨ Tiyopiraasihoŋe jɨhura isɨhiya taahiyɨhiya kiyaamɨ ikwɨraahɨ kahapaamapɨpa Autaahaatɨho kaihɨ nyamɨ otɨhapɨhɨ ndɨhetɨ noaipasɨwaiwaapɨ jɨpatɨpiyawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Saiwɨ kiya jɨpatɨpiyohɨtɨmandɨ jɨhɨ wuwanɨnɨhɨ saiwa namasatɨ noaipasɨhɨ isɨhiya usa mmonɨwɨ nepɨ isɨwatawa kiya Autaahaatɨhomɨ pɨwɨhaamɨ otɨpɨpatɨhiyaimatɨwɨ bindawaawɨ pɨwɨha baiwɨ nyangi katɨwɨnyasauhɨ atisaatɨ nehotɨha ka tɨtɨhɨ jɨpatɨpiyawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aihɨ amɨ nisangi saiwa wuwanɨ namasatɨ noaipasɨwaiwaapɨ nunjenɨtɨ baindɨ atindɨ netaayo. Tɨtɨhɨ atindɨ netɨ tɨtɨhɨ kamwaaŋɨ wuwanɨhura noaipasɨmumwaaŋɨ jɨpatɨpaindɨ kinyapɨ nusoaasataayo. ");
INSERT INTO agm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Isɨ pɨwɨha isɨhiya aimɨ katɨwɨhisohɨha sa tɨtɨhɨ akɨtɨnɨhɨ akaaha katɨwɨsawaayopo. Isɨ kɨnyɨ tɨtɨhɨ akaahetɨpɨ gwɨnyaitaapɨ nɨnɨ kinyapɨ jɨpatɨpiyataayo. ");
INSERT INTO agm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yapɨpatɨ Judiyaahandi Erotɨho noaipatɨ awaisɨhoematatɨ jaatɨ bimihɨhura utaaho wo komɨ ambɨpatɨ Jekaraiyaaho bindataise. Jekaraiyaaho so isɨhiyaapɨ nandapa maahoaipatɨ tɨhatɨ Autaahaatɨhoai dɨpumanatɨ bindataahore. Iyataatɨ so Jekaraiyaaho isɨhiyaapɨ nandapa maahoaipatɨ tɨhɨwɨ dɨpumanɨhohiyɨhiya Abaijaahomɨhiyaamɨ namoyaatahore. Iyataatɨ komɨ apwaataatamɨ ambɨpatɨ Erisapetɨhaate. Saatɨ Erisapetɨhaatisangi amɨ naasɨkiyatɨ Aronɨhomɨhetapɨ noaipahaate. ");
INSERT INTO agm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kasanyurɨ Autaahaatɨhomɨ wɨnɨhapɨpa amɨ pɨwɨha nahataapa baimɨ akɨtɨnɨhɨ napaitɨmɨ atimɨ amɨ japepihɨrɨmɨ Autaahaatɨhomɨ ndɨhetɨ tɨtɨhɨ saasanotatɨ ainahɨsasanyurɨ bindamaahasanyure. ");
INSERT INTO agm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Iyataatɨ kasanyurɨ maaha owehasanyure. Sandɨ apaapɨmaahe amɨ Erisapetɨhaatɨ maaha wɨndɨ namaamotɨ nehɨ yatɨtɨpɨhaatɨ bisotihe. Saimɨ maaha owehasanyurɨ bimaamɨ numwɨ aimɨ aungwoyɨ aungwaasɨyaatamaise. ");
INSERT INTO agm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jekaraiyaahounɨ komɨhiyaunɨ Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ otɨpɨpatɨ kaitaatɨwɨha asisɨha kiyaapɨha noaipasɨhɨ kiyawaayopo. Aihɨ amɨ ko Jekaraiyaahoaisangi asisɨha waara Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ nandaatɨ Autaahaatɨhomɨ ndɨhetɨ otɨpɨpatɨ kiyataise. ");
INSERT INTO agm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ isɨhiyaamɨ maipɨhaiwaapɨ nandapa maahoaipatɨ kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai waamaindumapɨ dɨpumanɨhohɨpatɨ otɨpɨpatɨ kaitandɨ isɨhiya otɨpɨpatɨ satɨ saimbɨ kɨnyɨ kaime undɨwɨ Jekaraiyaahoai ahɨwisawaayopo. Amɨ ko katɨhɨ Autaahaatɨhomɨ ndɨhetɨ tausotɨpatɨ apɨpaahɨ gaahandɨ waamainjotɨhatɨ dɨpumanatɨ tɨhɨtandɨ nandaataise. ");
INSERT INTO agm_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aihɨ sura isɨhiya tɨtaahɨtɨhandɨ ipaahaapɨ Autaahaatɨhomɨ ambɨpatɨ mepɨ autaahepumapɨ gaapundohɨpɨpɨhɨ taawɨ ahoyanɨwɨ gaapundawaayopo. Aihɨ sura kura mɨhaaŋɨ Aŋɨ Awaindɨhandaatɨhɨ Jekaraiyaaho amɨ taatɨ tausotɨpatɨ Autaahaatɨhoai dɨpumanɨtandɨ tɨhihɨhuraare. ");
INSERT INTO agm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aihɨ mɨhatɨhɨ aŋɨtɨtɨhɨ Awaisɨho Autaahaatɨhomɨ otɨpɨpatɨho yamɨhapataatɨhapɨhoai Jekaraiyaaho usonataise ko tausotɨpatɨ nga waamainjotɨhatɨ Autaahaatɨhoai dɨpumanɨhohɨtɨhandɨ ganɨho arɨtaahandamɨ ikwɨrɨ gaatɨhɨraihoaaŋɨ bitosɨhɨ. ");
INSERT INTO agm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Siyatɨ Autaahaatɨhomɨ otɨpɨpatɨhoai Jekaraiyaaho usonatosatɨ apɨpaahɨ aungwohandɨ yayapwitatɨ itiwatɨ maarɨho apɨpaahɨ owesoendaise. ");
INSERT INTO agm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Siyatɨ yaihɨhandɨ kandɨ Autaahaatɨhomɨ otɨpɨpatɨho yamɨhapataatɨhɨ bimisɨho Jekaraiyaahoai saundataase. “Jekaraiyaahoŋe, kɨnyɨ wɨndɨ yamaime Autaahaatɨho kinyɨ gaapundingɨtɨhandɨ aimɨ atɨhise. Isɨ kinyɨ kɨwaamaatɨ Erisapetɨhaatɨ maaha woho wo namwɨtaise. Namwonɨhɨ kɨnyɨ ambɨpatɨ Jonɨhoe undɨpɨ ambɨhundɨtaape. ");
INSERT INTO agm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ko noaipahonɨhɨ kinyɨ maarɨho biyatɨ wɨhitonɨhɨ kɨnyɨ kopɨ apɨpaahɨ waatɨ maaritɨtaise. Iyonɨhɨ amɨ isɨhiya taahiyɨhiya ko noaipahonɨhɨ kandapɨ waatɨ aungwohandɨ maaritɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Saiwɨ kiya maaritɨtaapo ko Autaahaatɨhomɨ ndɨhetɨ awaisɨho watɨpɨho noaipahonɨho. Iyatɨ ko waapoho wainɨhandɨ amɨ waapoho wapa watɨpɨhapa apɨpaahɨ masɨhonjisangi wɨndɨ namaanane. Ko sangɨ noaipatɨ sanaatamɨ gwɨsɨhaatɨhɨ kɨpwɨndisuraapɨ Autaahaatɨhomɨ Itɨpɨho Gaaho komɨhetɨ tisaitɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iyataatɨ so utaaho (Jonɨho) Isɨraherɨhiya taahiyɨhiyaamɨ maarɨho netɨ nusepemaihaahonɨhɨ kiya nepemaitɨwɨ kiyaamɨ Autaahaatɨho Awaisɨhoenda japɨhɨ napɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iyatɨ amɨ ko Awaisɨhomɨ jɨhɨ nutaise. Iyataatɨ ko komɨ watɨpɨhandɨ pɨwɨha ausaahonɨhɨ isɨhiya nepemaitɨtaatɨwɨhandɨ Eraijaahomatiyahandɨ naitaise. Nesi sapiyaamɨ maarɨho netɨ nusepemaihaatɨ napaisaatumwahonɨhɨ nepemaitɨwɨ kiyaamɨ manyinyaisawɨ maasɨ maarɨho naasohɨtanɨhɨ tɨmaamaitɨtaapo. Iyatɨ amɨ isɨhiya taahiyɨhiya pɨwɨha nemapɨ maatɨmaatisohiyɨhiyaamɨ maarɨho netɨ nusepemaihaahonɨhɨ isɨhiya tɨtɨhɨ gaahiya amɨtɨha gaaha gwɨnyaahohiyɨhiyaamataiwɨ gɨwunyaitaatɨwɨhandɨ tɨtɨhɨ gaahandɨ naitaapo. Iyataatɨ amɨ Awaisɨho napɨtandɨhandapɨ jɨhɨ netɨ tɨmanatɨ isɨhiyai sahɨ tɨmetɨwɨse Awaisɨho napɨtandɨ aimɨ detiso undonɨhɨ amɨ kiya Awaisɨho napɨtandɨhandapɨ tɨmetɨtaapo,” undatɨ Autaahaatɨhomɨ otɨpɨpatɨho yamɨhapataatɨhɨ bimisɨho Jekaraiyaahoai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jekaraiyaaho Autaahaatɨhomɨ otɨpɨpatɨhoai satatɨ nunjenataise. “Kɨnyɨ pɨwɨma kɨma kandingɨmaapɨ nɨnɨ akɨtɨnɨhɨ akaahe ndɨ napitaindɨ gwɨnyaitande? Amɨ nɨnɨ aimɨ aungwɨhonɨnɨtihɨ amɨ nisɨ apopaatisangi aimɨ aungwaamaatiso,” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aihɨ Autaahaatɨhomɨ otɨpɨpatɨho pɨwɨha wihoaaŋɨha sata koai kaundataase. “Nɨnɨ Gapɨriyerɨhonɨne. Autaahaatɨhomɨ ndɨmaahomwaaŋɨmasɨpɨpɨhɨ komɨ ndɨhetɨ bitohohɨhonɨne. Ko Autaahaatɨho nɨngi natanoaasihɨ nasataayo gi pɨwaahɨtɨtɨ amɨ pɨwɨha gaaha kɨma kahɨtɨtando. ");
INSERT INTO agm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Isɨ kɨnyɨ atime. Nisɨ pɨwɨha nesipɨtɨ kahɨtohɨhaapɨ akaahe tɨpɨ gɨmunyaahingɨtɨhandapɨ kinyɨ maahomwaaŋɨ nisaputonɨhɨ kɨnyɨ wɨndɨ pɨwaamaatɨpɨ nehɨ pɨwaamaatisohoŋimatɨpɨ nehɨ bimaamɨ numbwɨ nisɨ pɨwɨha kɨma kahɨtohɨmaamɨ akɨpɨpa akɨtɨnɨhɨ ausaimanɨnatɨ noaipahonɨhura pɨwaatɨtaape. Amɨ nisɨ pɨwɨha kɨma kahɨtohɨma tɨtɨhɨ asisɨha Autaahaatɨho namɨhanatɨ ahaisɨhetɨ akɨtɨnɨhɨ noaipaitaise,” undatɨ Autaahaatɨhomɨ otɨpɨpatɨho Jekaraiyaahoai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aihɨ ko siyatɨ utaarɨ mɨhatɨhɨ bimihɨ isɨhiya Jekaraiyaahopɨ jaawɨ bindawaawɨ saiwɨ pɨhɨtɨwɨ gwɨnyaawaayopo. Napindɨ noaipasɨhɨ Aŋɨ Awaindɨhandaatɨhɨ utaarɨhandɨ ko ketamase tɨwɨ pɨhɨtɨwɨ waatɨ gwɨnyaawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aihɨ ko ipaahaapɨ noaipatɨ isɨhiyai wɨndɨ pɨwaamundise. Owe. Ko nehɨ komɨ ikwɨraahɨ sɨwipatɨ kiyaunjataise. Aihɨ isɨhiya sandɨ mmonawaawɨ kiya saiwɨ gwɨnyaawaayopo. Kɨmo utaamo Aŋɨ Awaindɨhandaatɨhɨ wɨndɨ wipetahandɨ noaipasɨhɨ mmonataato tɨwɨ waatɨ yaiwɨmapɨ usonɨwɨ gwɨnyaawaayopo. Amɨ ko pɨwaatɨtandɨhandɨ aimɨ owetihɨhandisɨ nehɨ komɨ ikwɨraahɨ konɨhɨ sɨwipatɨ kiyaunjiho. ");
INSERT INTO agm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aihɨ Jekaraiyaaho komɨ otɨpɨpatɨ kaitandɨhura kiyatɨ aimɨ owemapɨ komɨ aunahɨpataahapɨ japɨhɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aihɨ sandɨ saimainjɨhɨ ipotɨ komɨ apwaataatɨ Erisapetɨhaatɨ maahaapɨ gwɨsɨndaise. Gwɨsɨtatɨ noaatatɨ aŋɨpɨpɨhɨ bimihɨ waatɨho ikwɨrɨ naasairɨhɨ 5 kiyatɨ sanausotaise. ");
INSERT INTO agm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Aihɨ kaatɨ Erisapetɨhaatɨ sandaase. “Wanɨ ipotɨnɨhɨ aungwaataatɨ Autaahaatɨho nɨngi apɨpaahɨ gaahatɨ kɨmatɨ kanisataise. Isɨhiyaamɨ ndɨhetɨ maaha owehaanɨnɨ yatɨtɨpɨhaanɨnɨ kendaatɨ amɨ nisapɨ isɨhiya satɨwɨ Autaahaatɨhoai kaatapɨ apowihetaise tauhɨ amɨ nɨngi manyindɨhandɨ owetɨtando,” ndaase. ");
INSERT INTO agm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Erisapetɨhaatɨ maahaapɨ gwɨsɨtatɨ bimihɨ waatɨho ikwɨrɨ naasairɨtihɨ wɨramɨ isundɨpɨho naasohɨ 6 kiyatɨ nusoaipataise. Nusoaipasɨhɨ waatɨho soetɨ Autaahaatɨho komɨ otɨpɨpatɨho Gapɨriyerɨhoai aunahɨpatɨ awaipatɨ gwɨharaahonjɨ konjamɨ ambɨpatɨ Nasaretɨhandaahapɨ natausaasihɨ notaise. Iyataatɨ Nasaretɨhandɨ yapɨpatɨ amɨ disɨtɨrikɨhandɨ Garirihanda ahendaise. ");
INSERT INTO agm_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ko Autaahaatɨhomɨ otɨpɨpatɨho apopaatɨ waatɨ apwaimaamaatɨ weŋɨhaatɨ kaatamɨ ambɨpatɨ Mariyaahaataapɨhɨ notaise. Saatɨ apopaatɨ utaaho wo komɨ ambɨpatɨ Josepɨhopɨ ambɨhɨtɨwɨ pɨwaatɨwosauhɨhaate. So Josepɨho isɨhiya Daawitɨhomɨhiyaamɨhetapɨ noaipahore. ");
INSERT INTO agm_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Autaahaatɨhomɨ otɨpɨpatɨho Gapɨriyerɨho notɨ kaatɨ apopaatɨ apwaimaamaataapɨhɨ noaipatɨ kaati saundataase. “Apopaanye, gaahuraare. Kinyɨ omaŋɨtɨtɨhɨ yatɨhɨ napaisaatɨ gɨpatisanane. Awaisɨho gi gaahandɨ aimɨ kahisatɨ nahinyataise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aihɨ amɨ Mariyaahaatɨ sa pɨwa atisataatɨ kaatɨ naharimatataise. Naharimainjɨhɨ kaatɨ siyatɨ gwɨnyapenataise sa pɨwɨha napitɨtɨha atiso tatɨ gwɨnyaataise. ");
INSERT INTO agm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kaatɨ siyatɨ gwɨnyaasɨhandɨ kandɨ Autaahaatɨhomɨ otɨpɨpatɨho kaati saundataase. “Mariyaahaaŋe, kɨnyɨ wɨndɨ waatɨ yamaime. Autaahaatɨho gi maarɨho wɨhiwatɨ amɨ gaahandɨ kahisataise. ");
INSERT INTO agm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Isɨ kɨnyɨ atime. Kɨnyɨ maahaapɨ gwɨsɨtɨpɨ woho wo namwɨtaise. Naumbwɨ komɨ ambɨpatɨ Jisaasihoe tɨpɨ ambɨhunde. ");
INSERT INTO agm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Koaisɨ Autaahaatɨho netɨ Awaisɨhoemwaitaise. Iyatɨ kopɨ Autaahaatɨho nisɨ maasɨhɨhoe tɨtaise. Komɨ satɨho awaisɨho Daawitɨhomɨ aunahɨpa koaisɨ Autaahaatɨho nemwɨtaise. Iyatɨ amɨ Awaisɨho Autaahaatɨho ahɨwisonɨhɨ ko komɨ satɨho Daawitɨho jɨhura awaisɨhoematatɨ Isɨraherɨhiyai winjatipatamatiyatɨ Isɨraherɨhiyai iwinjatɨtandɨ noaipatɨ awaisɨhoematɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iyatɨ amɨ Jisaasiho Jekopɨhomɨ isɨhiyai konɨhɨ apɨpaaho awaisɨhoematatɨ iwinjatɨtaise. Iyatɨ ko awaisɨhoematatɨ komɨ isɨhiyai winjatindɨhandɨ wɨndɨ owemetɨtaise,” undatɨ Autaahaatɨhomɨ otɨpɨpatɨho Mariyaahaati kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aihɨ Mariyaahaatɨ kaatamɨha wihoaaŋɨha Autaahaatɨhomɨ otɨpɨpatɨhoai sata nunjenataise. “Nɨnɨ sangɨ namaatɨtɨ apwaimaamaanɨnɨ weŋɨhaanɨnisɨ sandɨ kɨnyɨ kandingɨtɨmandɨ nɨnapitiyatɨ noaipaitaihɨhandapɨndise?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aihɨ Autaahaatɨhomɨ otɨpɨpatɨho komɨha wihoaaŋɨha kaati saundataase. “Itɨpɨho Gaaho kɨnyɨhetɨ napɨtaise. Amɨ Autaahaatɨho Nahatewai Ipɨhatisama Autaahɨ Nɨwaataatɨ Bimisɨhomɨ watɨpɨhandɨ gisɨ nangɨmaasaitaise. Nangɨmaasahonɨhɨ sonjɨ metonjɨ Autaahaatɨhomatetahoai kɨnyɨ ipotɨhura namwɨtaise. Namwisamɨhɨ kopɨ Autaahaatɨho satatɨ nisɨ Maasɨhɨhoe tatɨ ambɨhɨtɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Isɨ kɨnyɨ atime. Kinyɨ naisaamaatɨ Erisapetɨhaatɨ aimɨ apɨpaahɨ aungwaamaatɨndaahandɨ kandɨ kaatamɨ gwɨsɨhaatɨhɨ maaha woho wo kɨpwɨndataise. Jɨhura isɨhiya kaatapɨ maaha wɨndɨ namaamotɨ yatɨtɨpɨhaate tɨwɨ katohaamaatɨ kaatɨ aimɨ gwɨsɨndaise. Gwɨsɨtatɨ kaatɨ bimihɨ kaati waatɨho ikwɨrɨ naasairɨtihɨ wɨramɨ naasohɨtaho 6 kiyatɨ aimɨ sanausotaise. ");
INSERT INTO agm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Autaahaatɨho wapa kamaitandɨhapa owetise,” undatɨ Autaahaatɨhomɨ otɨpɨpatɨho kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aihɨ Mariyaahaatɨ koai saundataase. “Nɨnɨ Awaisɨhomɨ otɨpɨpatɨhaanɨne. Isɨ kɨnyɨ kandingɨmumwaaŋɨ kamwaaŋɨ gaasɨ kiyatɨ nɨngisɨ sandɨ nanoaipane,” ndaase. Sata katihɨ Autaahaatɨhomɨ otɨpɨpatɨho kaati numasi niyataise. ");
INSERT INTO agm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Aihɨ sura asisɨha yahonya sanaihɨ ketɨ kuraanɨhɨ Mariyaahaatɨ dosisɨ tarɨwiyatɨ aunahɨpatɨ wɨtɨ tipatɨ sisɨho sɨhoaarɨhɨretɨ ahetihɨhataahapɨ notaise. Notɨ yapɨpatɨ disɨtɨrikɨhandɨ Judiyaahandamɨ aunahɨpatɨ wɨta noaipataise. ");
INSERT INTO agm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Notɨ noaipatɨ Jekaraiyaahomɨ aŋaaŋɨ nandaatɨ Erisapetɨhaati ipɨhɨrete gaahure undataase ");
INSERT INTO agm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Aihɨ Erisapetɨhaatɨ Mariyaahaatamɨ ipɨhɨrete gaahure undindɨhandɨ atihɨhura metɨhonjɨ Erisapetɨhaatamɨ gwɨsɨhaatɨhɨ kɨpwɨndisonyonjɨ naapwananatɨ ahoyataise. Aihɨ amɨ kaatɨ Erisapetɨhaatamɨhetɨ Autaahaatɨhomɨ Itɨpɨho Gaaho nasatɨ waatɨ tɨwɨsaitataise. ");
INSERT INTO agm_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tɨwisainjɨhɨ Erisapetɨhaatɨ pɨwɨha waapɨhɨta sata kandaase. Autaahaatɨho asɨhiya nahatiyaisɨ gaahandɨ kawindɨhandi nusatipɨhaatɨ apɨpaahɨ awaindɨhandɨ gaahandɨ gi kahisatɨ nahinyahaaŋe. Iyataatɨ metɨhonjɨ kinyɨ gwɨsɨhaatɨhɨ kɨpwɨndisonyonjisangi Autaahaatɨhomɨ gaahandisahonje. ");
INSERT INTO agm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nɨnɨ itapaanɨnɨ isɨhiya wɨndɨ gaahandɨ kamaanitɨhaanɨnɨndaahandɨ kandɨ kɨnyɨ nisɨ Awaisɨhomɨ sanaaŋɨ nɨngisaapɨhɨ nasapaise. ");
INSERT INTO agm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Atime. Nɨnɨ kinyɨ ipɨhɨrete gaahure dingɨtɨhandɨ atisonɨhura metɨhonjɨ nisɨ gwɨsɨhaatɨhɨ kɨpwɨndisonyonjɨ maaritatɨ naupwaatataise. ");
INSERT INTO agm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kɨnyɨ satɨpɨ Awaisɨho nɨngisɨ kanitandɨ katimbɨpa kapa kanitaise tɨpɨ kopɨ aimɨ gɨwunyaapɨhaaŋisɨ waatɨ maarite ipotɨhura Awaisɨho katimumwaaŋɨ kamwaaŋɨ kiyonɨhɨ akɨpɨpa noaipaitaiso undatɨ Erisapetɨhaatɨ Mariyaahaati kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aihɨ Mariyaahaatɨ sata kandaase. “Nisɨ Maarɨho dɨtɨhɨrɨ nahandisatɨ Awaisɨhoai mepɨ autaahemwataayo. ");
INSERT INTO agm_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Aindɨ amɨ nɨnɨ nisɨ omaŋɨtɨtɨhɨ nahandisatɨ Autaahaatɨho nɨngi japɨhɨ nanɨmaatɨ nɨtatamanatɨ ninjatisɨhopɨ waatɨ maaritataayo. ");
INSERT INTO agm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Amɨ sandɨ apaapɨmaato nɨnɨ komɨ otɨpɨpatɨhaanɨnɨ awaisaamaanɨnɨtihɨhandamatiyatɨ ko nisapɨ gɨnunyaasɨhɨto. Isɨ wanunɨ ipotunɨ isɨhiya nahatiya nisapɨ ‘ise saati Autaahaatɨho gaahandɨ maaritɨtandɨhandɨ kawisa nunyataise,’ tɨwɨ nisapɨ katɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sandɨ apaapɨmaato Autaahaatɨho watɨpɨhaiwa nahatewaisaho apɨpaahɨ awaindɨhandɨ siyatɨ kanindɨmandapɨto. Isɨ Autaahaatɨho apɨpaahɨ akɨtɨ akɨtɨnɨhɨ ainahɨho gaahore. ");
INSERT INTO agm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iyataatɨ isɨhiya kopɨ yaiwɨ komɨ asɨmwaatɨtɨhɨ pɨnuwɨ amɨ koai autaahɨ nepɨ isɨwatohiyɨhiyai nasisoaarɨ kiyaapɨ maarɨho asɨpiyatɨ gaahatɨ kawɨsahore. Isɨ isɨhiya ipotɨ ipotɨ namoyaatɨwɨ noaipahohiyɨhiya kopɨ yaiwɨ komɨhinɨ detɨ nasohiyɨhiyai ko maarɨho asɨpɨwisatɨ komɨ gaahandɨ konɨhɨ kawɨsatɨ nunjamɨ notoaatɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ko komɨ watɨpɨhandɨ awaindɨhanda isɨhiya kiyaamɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhapɨ genanɨwɨ naimaatohiyɨhiyai kupwɨra mɨhopɨ mɨhinɨmahore. ");
INSERT INTO agm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Iyatɨ awaisawɨhiya isɨhiya watɨpɨhiyaimatɨwɨ iwinjatohiyɨhiyai nematɨ yatɨhiwatɨ nehɨhatɨmematɨ amɨ nehɨhatɨmai netɨ autaahemwahore. ");
INSERT INTO agm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iyatɨ amɨ ko isɨhiya jaumwasawɨhiyai kahapaamapɨpa waatɨ tisaahɨwatɨ nunyahore. Iyatɨ amɨ ko isɨhiya kahapaamapɨpa gaahaiwa asaketahiyai nehɨ taanahiyɨhiyai netɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Komɨ pɨwɨha jɨhura nyamɨ asoyai kaundisɨhaapɨ gwɨnyapenataatɨ komɨ otɨpɨpatɨhiya Isɨraherɨhiyai iwɨtatamanatɨ andɨtɨwiwɨtandɨ nasataise. Siyatɨ ko jɨhura nyamɨ asoyai kaundipatamatiyato. Nɨnɨ Abɨraahamɨhoaisunɨ amɨ komɨhiya ipotɨ ipotɨ noaipahohiyɨhiyaisunɨ konɨnɨhɨ nasisoaarɨ gaahatɨ kawito tipatamatiyato,” tatɨ Mariyaahaatɨ aunɨhɨhɨrɨ katatɨ kandaase. ");
INSERT INTO agm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Siyatɨ Mariyaahaatɨ Erisapetɨhaatisatɨ maasɨ waatɨhonya murɨmingwaasɨ bisotinjatɨ japɨhɨ kaatamɨ aunahɨpataahapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Erisapetɨhaatɨ metɨhonjɨ namwɨtandɨha asisɨha noaipasɨhɨ kaatɨ maaha woho namotaise. ");
INSERT INTO agm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aihɨ isɨhiya kapɨhɨ kapɨhɨ kaatamɨhinɨ detɨ bimohiyɨhiyaunɨ amɨ kaatamɨ jɨtɨpatetapɨ namoyaatohiyɨhiyaunɨ Autaahaatɨho apɨpaahɨ gaahatɨ kaati kawɨsataise tauhɨ atisawaayopo. Atisawaawɨ kaatisawɨ maasɨ waatɨ awaindɨhandɨ maaritawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Aihɨ asisɨha ikwɨwihɨtɨrɨtihɨ wihɨnɨhɨramɨ mairɨma (8 kiyatɨ) sanaihɨhura metɨhonjamɨ ambɨpatɨ ahoaapɨ namandipaitaatɨwɨ ahoyanawaayopo. Ahoyanawaawɨ ambɨpatɨ sapɨhomɨhatɨ nepawɨ Jekaraiyaahotane tɨwɨ nusoaasɨtaatɨwiyawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Saiwɨ sapɨhomɨhatɨ nusoaasɨtotɨwɨhiyauhɨhandɨ kandɨ metɨhonjamɨ sanaatɨ saundataase. “Owe. Metɨhonjamɨ ambɨpatɨ Jonɨhotane,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aihɨ kiya kaati saundawaatopo. “Ambɨpatɨ satɨ nusoaasɨtɨhatɨ kandɨ kinyɨhiya usa ambɨpatɨ satɨ ambɨhonahiya owetihɨto,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aihɨ kiya metɨhonjamɨ sapɨhoai ambɨpatɨ maahɨwɨtɨ nusoaasɨtaapɨ gwɨnyaapaise undɨwɨ pɨwaamaatisohosɨ nehɨ ikwɨra sɨwipatɨ kaiwunjawɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aihɨ ko kiyai jɨpatɨpaitandɨhapa wapa nepɨninyawɨse undihɨ amɨ kiya koai wapa jɨpatɨpaitandɨhapa nepunyauhɨ amɨ ko metɨhonjamɨ ambɨpatɨ Jonɨhore tatɨ jɨpatɨpiyataise. Aihɨ kiya ese tɨwɨ waatɨ yaiwɨmawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aihɨ sura ketɨ kuraanɨhɨ komɨ maahomwaaŋɨ japɨhɨ nɨwusaatatɨ gaatihɨ pɨwaatatɨ Autaahaatɨhopɨ maaritatɨ komɨ ambɨpatɨ mepɨ autaahemwataise. ");
INSERT INTO agm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aihɨ naisɨhiya kapɨhɨ detɨ bimohiyɨhiyai waatɨ yawimatataise. Aiwɨ amɨ satɨ yapɨpatɨ Judiyaahandamɨ sɨhoaarɨhɨrɨ tipatetɨ gaamapɨ saiwa Jekaraiyaahoai nusoaipasɨwɨmaiwaapɨ pɨwɨha kanɨmɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aihɨ isɨhiya nahatiya pɨwɨha saiwa Jonɨho noaipasɨrɨhɨretapɨha waatɨ pɨhɨtɨwɨ gwɨnyapenawaawɨ kiya satɨwɨ nasenawaayopo. Metɨmonjɨ kɨmonjɨ ipotɨhura noaipatɨ napitetahotɨtaindɨho? Tawaatopo. Sandɨ apaapɨmaatopo. Autaahaatɨhomɨ watɨpɨhandɨ koaisatɨtihe. ");
INSERT INTO agm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jonɨhomɨ sapɨho Jekaraiyaahomɨhetɨ Autaahaatɨhomɨ Itɨpɨho Gaaho waatɨ tɨwisaitataatɨ koai netɨ gɨwunyaasɨhɨ Jekaraiyaaho sata kandaase. ");
INSERT INTO agm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Isɨraherɨhiyaamɨ Awaisɨho Autaahaatɨhomɨ ambɨpatɨ maarita nuwimaawa mepɨ autaahemwaitɨhaawo aimɨ nasataiso. Iyatɨ amɨ komɨ isɨhiyai maipɨhandaatɨhapɨ japɨhɨ aimɨ numwaataiso. ");
INSERT INTO agm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nyangi Japɨhɨ Nanyamaitandɨho apɨpaahɨ watɨpɨhoai Autaahaatɨho namɨhana ahɨwihɨ Autaahaatɨhomɨ otɨpɨpatɨho Daawitɨhomɨ isɨhiyaamɨhetapɨ ko noaipataise. ");
INSERT INTO agm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ nehɨ kaahɨhɨ ausaahohiyɨhiyaamɨhetapɨ jɨhɨ aimehura Autaahaatɨho pɨwɨha watɨpɨtatɨ nyangi japɨhɨ nanyamaitandɨ katisɨhaare. Isɨhiya nyamɨ tiworisaamunɨ amɨ nyangi mandɨtinyaipɨ nyapɨ apowisawɨhiyaamɨ ikwɨraatɨhapɨ nanyamaitandɨ pɨwɨha katisɨhaare. ");
INSERT INTO agm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Autaahaatɨho nyamɨ asoya asisai maarɨho asɨpɨwitandɨ jɨhura pɨwɨha kandaase. Iyatɨ amɨ ko pɨwɨha apɨpaahɨ watɨpɨtatɨ sawahomɨ ambɨpatɨ ambɨhɨtatɨ wɨsasatɨ ahaisɨhaapɨ gwɨnyapenataato. Ko Pɨwɨha aimɨ jɨhɨ wɨsasisɨhaapɨ gwɨnyapenataatɨ namatɨ maarɨho asɨpinyisataise. ");
INSERT INTO agm_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Iyatɨ amɨ Autaahaatɨho jɨhura nyamɨ asɨho Abɨraahamɨhoai nyangi nyatatamanɨtandɨ apɨpaahɨ watɨpɨtatɨ pɨwɨha wɨsasatɨ sata kaundisɨhaare. ");
INSERT INTO agm_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Nɨnɨ kinyɨ gaasoya gaasisai kiyaamɨ tiworisaamɨ ikwɨraatɨhapɨ japɨhɨ numwaito. Numwaasanɨhɨ kiya kiyaamɨ tiworisaapɨ wɨndɨ yamaiwɨ nisɨ otɨpɨpatɨ kanitaapo,’ tatɨ katisɨha wanɨ akaahemataise. ");
INSERT INTO agm_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Amɨ nyahɨ isɨhiyaanɨnɨ asɨyɨhiyaanɨnɨ bindɨhaawɨ Autaahaatɨhomɨ otɨpɨpatɨ komɨ gwɨnyaatɨ maaritipatɨ tɨtɨhɨ maarɨho naasohɨtanɨhɨ kawisaatɨ amɨ ndɨhetɨ gaahiyaanɨnɨ ainahiyɨhiyaanɨnɨ kiyaanɨnɨhɨ nehɨ komɨhiyaanimataatɨ komɨ otɨpɨpatɨ kawitɨhaawe. ");
INSERT INTO agm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Amɨ kɨnyɨ nisɨ metɨhonjaŋe isɨhiya kinyapɨ ipotɨhura Autaahaatɨho Nahatewai Ipɨhatisa Daahema Autaahɨ Bimisɨhomɨ pɨwɨha atisa netɨ ausaasɨhoe tɨwɨ ambɨhɨtɨtaapo. Iyataatɨ sandɨ apaapɨmaato kɨnyɨ Awaisɨhomɨ jɨhɨ taapɨ nopaapɨ Awaisɨhopɨ daihɨra daawupɨ isɨhiyaamɨ maarɨho amɨ omaŋɨtɨtɨhɨ tɨtɨhepumapɨ turɨmanɨtaapɨhoŋɨtihɨto. ");
INSERT INTO agm_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Aimbɨ amɨ nepɨ turɨmanɨpɨ komɨ isɨhiyai katɨpunjɨtaape. Katɨpunjisamɨhɨ kiya Autaahaatɨhopɨ ko nyamɨ maipɨhaiwa nenyama japɨhɨ nanyamaitande tɨwɨ gɨwunyaitaatɨwo. ");
INSERT INTO agm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Amɨ nyamɨ Autaahaatɨho nyangi komɨ maarɨho nanyinyatɨ asɨpinyisahore. Isɨ ko asisɨha bowatɨ ipɨho nausainjɨtɨhandamatiyatɨ nyamɨhetɨ bonyawatɨ nanyusaatatɨ nyangi japɨhɨ nanyamaitandɨ yamɨhapataatɨhɨraapɨ napɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nasonɨhɨ isɨhiya asɨhatindɨhandaatɨhɨ napwɨtaatɨwɨhandapɨ yaiwɨ yutɨhɨramataiwɨ namaasatɨwɨ bimohiyɨhiyai Autaahaatɨho iwɨtatamanɨtaise. Iwɨtatamanatɨ amɨ nyangi nyamɨ maarɨho wɨnyaitonɨhɨ biyaatɨ gaahiyaanɨnɨ napaisaatɨ bimɨtɨhaahɨra daihɨra nanyisatɨ nanyamaasi nutaise,” tatɨ Jekaraiyaaho kandaase. ");
INSERT INTO agm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aihɨ amɨ so meto (Jonɨho) ipotɨhura komɨ maarɨhoaisatunɨ amɨ ambɨpatisatunɨ ahoya gwɨnyanataise. Aihɨ amɨ komɨ maarɨhoaisangi noaipatɨ watɨpɨndaise. Iyatɨ ko isɨhiya owehapɨhɨ kendaise. Ketinjatɨ ipotɨhura isɨhiya Isɨraherɨhiyaamɨ ndɨhetɨ auta noaipatɨ pɨwɨha ausaatɨ kiya Isɨraherɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aihɨ sura (Jonɨho noaipatɨ taatɨ gwɨnyainjɨhɨ amɨ Erotɨho Judiyaahandɨ jatihɨ) utaaho wo awaisɨho komɨ ambɨpatɨ Sisa Okaasɨtaasiho pɨwɨha wa isɨhiya nahatiyaapɨ nusoaasataise. Sa pɨwɨha Romɨhandaahapɨ awaisɨho isɨhiyaapɨ nusaasisa isɨhiya nahatiya gamanɨho Romɨhandaahapɨho jatimbɨpɨhapɨhiya nahatiyaapɨ nusaasataise amɨ kiyaamɨ ambɨpatɨ kusiwɨ awɨtɨwɨ nepɨ utɨpɨhoaatɨhɨ jɨpatɨpaitaatɨwɨ. Iyataatɨ Romɨhiyaamɨ Gamanɨhomɨ awaisɨho Sisa Okasɨtaasiho katihɨ sandɨ jɨhandɨ isɨhiya nahatiyaamɨ ambɨpatɨ awɨtɨwɨ jɨpatɨpiyawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Gamanɨho jɨhura isɨhiyaamɨ ambɨpatɨ wɨndɨ namehandɨ kɨmandɨ nehɨ namasatɨ jɨhapɨhandɨ isɨhiya nahatiyaamɨ ambɨpatɨ netaise. Iyataatɨ sura Kwiriniyaasiho (Sisa Okaasɨtaasihomɨ yatɨhɨ otɨtɨhɨ) yapɨpatɨ pɨropinjɨhandɨ Siriyaahanda jaatɨ bimihɨhuraare. ");
INSERT INTO agm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aihɨ sandɨ jɨhapɨhandɨ Romɨhandaahapɨ gamanɨho isɨhiya nahatiyaamɨ ambɨpatɨ naitandɨ isɨhiya nahatiya nehɨ kiyai kiyai yɨyandɨhɨ kiyaamɨ yapɨpata ambɨpatɨ utɨpɨhoaatɨhɨ ahaitaatɨwɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aihɨ amɨ Josepɨho so awaisɨho Daawitɨhomɨ isɨhiyaamɨ jɨtɨpatetapɨ namwiyaatohiyɨhiyaamɨhetapɨ noaipahore. Isɨ ko Josepɨho yapɨpatɨ Garirihandamɨ aunahɨpatɨ Nasaretɨhanda namasi yapɨpatɨ Judiyaahanda Daawitɨhomɨ aunahɨpatɨ Betɨrehemɨhandaahapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Notaatɨ ko Josepɨho komɨ apwaataatimatɨtandɨhaatɨ Mariyaahaati numwaasi maasɨ gamanɨho kasanyuramɨ ambɨpatɨ utɨpɨhoaatɨhɨ ahɨwitandɨ nomaise. Iyataatɨ sura Mariyaahaatɨ maaha namwɨtandɨ aimɨ detɨtihɨhuraare. ");
INSERT INTO agm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Saimɨ numwɨ noaipapɨ satɨ aunahɨpita bimihɨ Mariyaahaatɨ maha namwɨtandɨhura asisɨha noaipataise. ");
INSERT INTO agm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aihɨ kaatɨ kaatamɨ mwaaho bwandɨpɨho woho namotaise. Namotɨ apotɨhɨrɨ masɨmasɨhonyaapɨhɨ napapatɨ kopuho kauho nandapa nainjɨhotɨ nausosatosataise amɨ aŋɨhaiwa isɨhiya nawɨho nunyawɨ nanoaitaatɨwɨhaiwa isɨhiyaapɨ tisaitatɨ owetiho. ");
INSERT INTO agm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Iyataatɨ satɨ aunahɨpita nehɨhaatɨ mangɨrainɨ isɨhiya usa sipɨsipɨhandɨ yamanɨwɨ jaawɨ apatindɨtɨhɨ bitotawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Saiwɨ apatindɨtɨhɨ jaawɨ bitohauhɨ Awaisɨhomɨ otɨpɨpatɨho yamɨhapataatɨhɨ bimisɨho kiyaapɨhɨ nasatɨ noaipataise. Aihɨ Awaisɨhomɨ nausainjɨtɨhandɨ yundanyɨha watɨpɨhandɨ waatɨ kiyai nɨwunjainjɨhɨ kiya waatɨ yayawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yayauhɨhandɨ kandɨ Autaahaatɨhomɨ otɨpɨpatɨho yamɨhapataatɨhɨ bimisɨho kiyai saundataase, “Sahɨ wɨndɨ yamaiwise. Sahɨ atiwɨse. Nɨnɨ sapɨ pɨwɨha wanɨha gaaha isɨsi nasataayo. Sa pɨwɨha wanɨha gaasa isɨhiya nahatiyai maaritɨtaatɨwɨhandɨ nunyonɨhɨ kiya asakaiwɨ waatɨ aungwohandɨ maaritɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Wanɨ asisɨma kɨmetɨ Daawitɨhomɨ aunahɨpata apopaatɨ waatɨ metɨhonjɨ wonjɨ namotaise. Sonjɨ metonjɨ sangi Japɨhɨ Nasamaitandɨ Autaahaatɨho Namɨhainjɨho Awaisɨhore. ");
INSERT INTO agm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sahɨ nuwɨse. Nuwɨ mmonawa metonji apotɨhɨraapɨhɨ napapahawɨ kauho nandapa nainjɨho kopuhotɨ nausosawosisaihɨ sahɨ usonawaawaahɨ amɨ so kore,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aihɨ Autaahaatɨhomɨ otɨpɨpatɨho yamɨhapataatɨhɨ bimisɨho kiyai sata kaundatɨ namɨhaasɨhɨ ketɨ kuraanɨhɨ yamɨhapataatɨhapɨ Autaahaatɨhomɨ otɨpɨpatɨhiya usa taahɨtɨhandɨ yamɨhapataatɨhapɨ tɨmahiyawɨ ko otɨpɨpatɨho jɨhɨ nasatɨ bitosɨhoaisawɨ maasɨ bitotawa Autaahaatɨhoai satɨwɨ mepɨ autaahepumwawaapo. ");
INSERT INTO agm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Autaahɨ ko bimimbɨpɨhɨ yamɨhapataatɨhiyaanɨ Autaahaatɨhoai mepɨ autaahemwawa nɨwimaitɨhaawo. Isɨhiya yapɨpatambɨhiya Autaahaatɨho kiyaapɨ maaritisawɨhiya kiyaamɨ omaŋɨtɨtɨhɨ yatɨhɨwitonɨhɨ kiya nga bimɨto,” tɨwɨ Autaahaatɨhomɨ yamɨhapataatɨhapɨ otɨpɨpatɨhiya katawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Satɨwɨ katɨwɨmapɨ Autaahaatɨhomɨ otɨpɨpatɨhiya sipɨsipɨhandɨ jaawɨ bitohohiyɨhiyai namasi autaahɨ yamɨhapataatɨhapɨ japɨhɨ naiwɨmawaayopo. Saiwɨ aimɨ niyauhɨhura sipɨsipɨhandɨ jaawɨ bitohohiyɨhiya sawana sanawaatopo. “Betɨrehemɨhanda sandɨ noaipasɨhɨ Awaisɨho aimɨ ausaatɨ kanyatataasɨ nyahɨ sandɨ mmondɨhaawɨ ketɨ tarɨwiyaatɨ nutɨho,” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kiya sanɨwɨ kanɨwɨmapɨ ketɨ kuraanɨhɨ dosisɨ nowaayopo. Nuwɨ Mariyaahaatisunɨ Josepɨhoaisunɨ usonawaayopo. Aiwɨ amɨ metɨhonjisangi kauho amɨ sipɨsipɨho nandapa nainjɨho kopuhotɨ nanototihɨ usonawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kiya nuwɨ aimɨ usonɨwosawɨ sonjɨ metonjapɨ Autaahaatɨhomɨ otɨpɨpatɨho pɨwɨha kaundisɨha ka ausaapɨ isɨhiya sapɨhɨ Betɨrehemɨhanda bimohiyɨhiyai kaundɨwɨ gaamawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kaundauhɨ isɨhiya nahatiya sipɨsipɨho jaawɨ bitohohiyɨhiyaamɨ saiwa pɨwaiwa atisawaawɨ pɨwɨha sa napitɨtahaare tɨwɨ waatɨ pɨhɨtɨwɨ gwɨnyapenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Aihɨ amɨ Mariyaahaatɨhɨ saiwa pɨwaiwa nahatewa atisa netɨ amɨtetetɨ biyatɨ gwɨnyaatɨ amɨ omaŋɨtɨtɨhɨ anɨtisa kɨpotɨ gwɨnyaapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aihɨ sipɨsipɨho yamanɨwɨ jaawɨ bitohohiyɨhiya japɨhɨ nowaayopo. Japɨhɨ nowaawɨ Autaahaatɨhomɨ otɨpɨpatɨho kaundimumwaaŋɨ kamwaaŋɨ tɨtɨhɨ noaipasɨhɨ kiyaamɨ ndɨhaara mmonɨwɨ atiwɨ nehohɨtɨhandapɨ Autaahaatɨhopɨ maaritɨwɨ aunɨhɨtɨwɨ komɨ ambɨpatɨ mepɨ autaahepumawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mariyaahaatɨ Jisaasihoai namotɨ bimihɨ asisɨha ikwɨrɨ naasairɨtihɨ wɨramɨ mairɨma 8 kiyatɨ aimɨ sanawihɨ metɨhonjamɨ ambɨpatɨ namandipapɨ ahoaamawaayopo. Ambɨpatɨ namandipapɨ amɨ ambɨpatɨ Jisaasihoe tɨwɨ ambɨhundawaayopo. Satɨ ambitɨ jɨhɨ Jisaasihopɨ sangɨ Mariyaahaatɨ gwɨsɨtihɨhura Autaahaatɨhomɨ otɨpɨpatɨho Jisaasihotane tatɨ aimɨ ambɨhɨtipate. ");
INSERT INTO agm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maaha asɨhiya namowaahura saiwɨ saiwɨ kaiwise tatɨ Mosesiho wɨnɨhapɨpa katatɨ ahaihɨ ahotirɨhɨretɨ japepihɨratɨ Mariyaahaatɨ kiyatɨ bimainjatɨ aimɨ owetihɨ kaatɨ Mariyaahaatunɨ Josepɨhounɨ metɨhonji numwaasi Jerusaremɨhanda Autaahaatɨhoai numwɨtaatɨmɨ nomaise. ");
INSERT INTO agm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Iyataatɨ satɨ saiwɨ kaitaatɨwɨ Awaisɨho Autaahaatɨhomɨ wɨnɨhapɨpaatɨhɨ satatɨ ahondaise, “Maaha wohonya bwandɨpɨhonya namohonyonya nahatonya Awaisɨhoai nunyawɨse,” tatɨ jɨpatɨpindipatamataimɨ kiyamaise. ");
INSERT INTO agm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Iyataatɨ amɨ Awaisɨhomɨ wɨnɨhapɨpa wapaisangi satatɨ ahondaise maaha naumbwɨ bimambɨpɨ Autaahaatɨhoai gaare undɨtaapɨ koho dɨpɨhurɨ yahurisangi amɨ koho dɨpisɨho gwɨtɨpɨho sangɨho yahurisangi nesaimbɨ Autaahaatɨhoai gaahoŋe gaare undɨpɨ nunye tatɨ ahondaise. Siyatɨ ahotahandisɨ Josepɨyɨ Mariyaaya kɨretɨ japepihɨrɨmɨ kapa tɨtɨhɨ isɨsi kaitaatɨmɨ kasanyurɨ Jerusaremɨhanda numwɨ kiyamaise. Amɨ kasanyurɨ noaipapɨ Autaahaatɨhomɨ ndɨhetɨ popɨtɨhasanyurɨtɨtaatɨmɨ sandɨ kiyamaise. ");
INSERT INTO agm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Iyataatɨ sura utaaho wo komɨ ambɨpatɨ Simiyonɨho sapɨhɨ Jerusaremɨhanda bindataise. So utaaso tɨtɨhɨ gaaho amɨ Autaahaatɨhomɨ wɨnɨhapɨpa biyatɨ japepihɨratɨ nehɨ Autaahaatɨhopaahɨhɨ gaapundatɨ bindataahore. Iyatɨ amɨ utaaho Isɨraherɨhiyai kiyaamɨ tiworisaamɨ ikwɨraatɨhapɨ japɨhɨ numwaatɨ amɨ kiyaamɨ maarɨho omaŋɨtɨtɨhɨ netɨ yatɨhɨwiwatɨ japɨhɨ numwaitandɨhoai Autaahaatɨho netɨ natausaasɨtandɨhuraapɨ koai usondandɨ konɨhɨ jaatɨ bisotinjahore. Iyatɨ ko Autaahaatɨhomɨ Itɨpɨho Gaaho koaisatɨ maasɨtahore. ");
INSERT INTO agm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","So utaasoai Autaahaatɨhomɨ Itɨpɨho Gaaho sata kaunda gɨwunyaasɨhore kɨnyɨ ketɨ wɨndɨ namaapwɨtaise. Namaapopɨ bindapaapɨ Isɨhiyai Japɨhɨ Numwaitandɨ Autaahaatɨho Ahɨwisɨho Kɨraisihoai usonɨmapɨhura napwɨtaise undatɨ gɨwunyaasɨhɨ gwɨnyaatɨ jatinjahore. ");
INSERT INTO agm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aihɨ koaisɨ Autaahaatɨhomɨ Itɨpɨho Gaaho Aŋɨ Awaindɨhandaatɨhapɨ naime undatɨ gɨwunyaasɨhɨ ko dosisɨ Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhapɨ niyataise. Aihɨ metɨhonjɨ Jisaasihoai saniyɨ sapiya wɨnɨhapɨpa katatɨ ahotirɨhɨrɨ kɨretɨ japepihɨrɨmɨ metonjapɨ kapa kaitotɨmɨ taamɨ metɨhonji numwaasi nandaamaise. ");
INSERT INTO agm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Numwaasi nandaasɨhɨ Simiyonɨho konjɨ metonji numwaatɨ komɨ ikwɨraatɨhɨ netɨ isɨwatataatɨ konjapɨ Autaahaatɨhoai gaahoŋe undatɨ ambɨpatɨ mepɨ autaahemwatɨ sata kandaase. ");
INSERT INTO agm_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Awaisɨhoŋe, wanɨ kɨnyɨ nɨnɨ kinyɨ otɨpɨpatɨhonɨnɨ nehɨ nanɨhaindɨ kaindɨ bɨpi napaisaatɨ napwɨtaanɨ amɨ nehɨ nanɨhaimbɨ ninjase. Amɨ kɨnyɨ jɨhura nɨngi sandapaase, ‘Kɨnyɨ namaapopɨ bimambɨpɨ Isɨhiyai Japɨhɨ Numwaitandɨho noaipahonɨhɨ usonɨmapɨ napwɨtaise,’ dingɨha wanɨ tɨtɨhɨ akaaha noaipasɨhɨ nɨnɨ nisɨ ndɨhaara koai usonataatɨ nisɨ maarɨho wɨnitatɨ yatɨhɨ nɨpatisanataise. ");
INSERT INTO agm_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Noaipasɨhɨ nɨnɨ nɨwahonisɨ ndɨhaara utaaho isɨhiyai japɨhɨ numwaitandɨ kɨnyɨ namɨhanɨpɨ tɨmanɨhingɨhoai wanɨ kɨmura usonataayo amɨ isɨhiya nahandamɨ ndɨhetɨ kiya mmondaatɨwɨ koai nepɨ ausaimaninɨho. ");
INSERT INTO agm_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iyataatɨ Kɨmonjɨ metɨmonjɨ sisɨha jɨpwɨtɨhɨramatiyahore isɨhiya nahandɨ Judaahiyaamɨ dawaataatɨ bimohiyɨhiyai nɨwusaatɨtando. Nɨwusaatonɨhɨ kiya nepemaitɨwɨ kopɨ gɨwunyaasaihɨ kɨnyɨ kiyai japɨhɨ numwaitaapo. Numwaasamɨhɨ kiya kɨnyɨ kinyɨ isɨhiya Isɨraherɨhiyaisapɨ kiyaamɨhatɨhɨ bindapaapɨ kiyai taapɨ numwaahingɨtɨmandaahɨ kinyapimatonɨhɨ Isɨraherɨhiyaapɨ maaritɨwɨ kiyaamɨ ambɨpatɨ awaindepumaitaatɨwo,” tatɨ Simiyonɨho kandaase. ");
INSERT INTO agm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sonjɨ metonjapɨ Simiyonɨho pɨwɨha sata katihɨ metonjamɨ saniyɨ sapiya kaapɨ kanjanyuramɨ omaŋɨtɨtɨhɨ bɨpi waatɨ pɨhɨtɨmɨ gwɨnyaamaise. ");
INSERT INTO agm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Iyatɨ amɨ Simiyonɨho metonjamɨ saniyɨ sapiyai Autaahaatɨhomɨ gaahandɨ nunyatɨ Autaahaatɨho sausasaatangi gaahandɨ kasisatɨ jainjatɨtaise undatɨ amɨ Mariyaahaatɨ metonjamɨ sanaati Simiyonɨho saundataase. “Kɨnyɨ Atime! Kɨmonjɨ metɨmonji Autaahaatɨho ahɨwisataise. Amɨ komɨ dahopaara Isɨraherɨhiya isɨhiya taahɨtɨhandɨ Autaahaatɨhoai ahosumwapɨ tɨmɨhaitaapo. Aisaihɨ amɨ Isɨraherɨhiya kanaahɨtɨ wɨretɨhandɨ isɨhiya taahɨhandɨ japɨhɨ nepemaitɨwɨ kiyaamɨ Autaahaatɨhoenda japɨhɨ napɨtaapo. Amɨ sandɨ siyatɨ sɨretɨ noaipaitandɨ Autaahaatɨho kɨmonjɨ metɨmonji sɨwipatamatiyatɨ ahɨwisataise. Iyataatɨ kɨmonjɨ metɨmonjɨ Autaahaatɨho maaritatɨ gwɨnyaasɨpɨpa nunjatɨ kiyonɨhɨ amɨ isɨhiya taahiyɨhiya kopɨ pɨwɨha maipɨhapa katɨwɨ amɨ kiya koai mandɨtɨwitaapo. ");
INSERT INTO agm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Sawisaihɨ sandaahɨ isɨhiya kiyaamɨ amɨtɨhetɨ maipɨhapa mɨmaipaiwɨ gwɨnyaapɨ amɨ kiyaamɨ maarɨho omaŋɨtɨtɨhɨ maipɨhapa kɨpwɨndimbɨpa auta noaipahonɨhɨ isɨhiya usa wapa noaasandimbɨpa mmondaatɨwo. Iyonɨhɨ saiwa gi kinyɨ maarɨhoaatɨhɨ netɨ namatanaatɨ timbiyatɨ tɨmwipɨhanaatɨ mwɨtɨhanaatamatiyatɨ nangɨmandipatɨ yaasɨhandɨ mɨhɨwɨtaise,” undatɨ Mariyaahaati Simiyonɨho kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Sapɨhɨ apopaatɨ waatɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaahaatɨ kaatamɨ ambɨpatɨ Anaahaatɨ bindataise. Amɨ Anaahaatɨ saatɨ Panuerɨhomɨ maataate. Amɨ Panuerɨho so Aserɨhomɨhetapɨ namoyaatohiyɨhiyaamɨ noaipahore. Iyataatɨ saatɨ Anaahaatɨ aimɨ apɨpaahɨ aungwaamaate. Jɨhura apwaimaamaatɨhura namaatatɨ warɨhoaisatɨ bimihɨ kɨnaungwɨha ikwɨrɨ naasairɨtihɨ wɨramɨ isundɨpɨho yahurɨ 7 kiyatɨ sanausohaate. Sanawihɨ kaatamɨ warɨho napotaise. ");
INSERT INTO agm_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Napwihɨ nehɨ osɨnɨhaatɨ kendaise. Ketihɨ kaatamɨ kɨnaukwɨha pɨhɨtatɨ tenɨhaiwa ikwɨrɨ naasairɨtihɨ wɨramɨ maurɨmandɨtihɨ kaatɨ maurɨmaurɨ 84 kiyatɨ aimɨ sanawihɨhaate. Saatɨ Anaasaatɨ Autaahaatɨhomɨ Aŋɨ Awaindɨhandɨ wɨndɨ namaamase. Owe. Asisɨha wiwetɨ nandapa waapoho namaana onaayatɨ nehɨ bindataatɨ Autaahaatɨhopɨ apatɨhɨ amɨ otapɨhaatɨ ahoyatɨ gaapundahaate. ");
INSERT INTO agm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aihɨ sɨkura kaatisangi detɨ nasatɨ Autaahaatɨhoai metonjapɨ gaahoŋe gaare undataase. Iyatɨ amɨ kaatɨ sonjɨ metonjapɨ pɨwɨha ausaatɨ isɨhiya Autaahaatɨho Jerusaremɨhandaahiyai japɨhɨ numwaitandɨ jatohiyɨhiya nahatiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Saiwɨ wɨnɨhapɨpa Awaisɨhomɨ katatɨ ahotimumwaaŋɨ japepihɨrɨwɨ kaiwɨ owemamapɨ japɨhɨ kusasɨ kusasamɨ aunahɨpa Nasaretɨhandɨ yapɨpatɨ Garirihanda ahetipataahapɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aihɨ satɨ aunahɨpita konjɨ metɨhonjɨ gwɨnyanatɨ awaisɨhotatɨ amɨ utaaho watɨpɨhondaise. Iyatɨ ko amɨtɨha gwɨnyaasɨtɨhandɨ gaahandɨ pɨhɨtatɨ awaindɨ gwɨnyaataise. Aihɨ amɨ Autaahaatɨho kopɨ maaritatɨ koai andɨtɨwiwataise. ");
INSERT INTO agm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Judaahiya nahatiya kiyohɨrɨhɨretɨ kaimɨ Jisaasihomɨ saniyɨ sapiya kɨnaukwɨha nahatewetɨ Judaahiyaamɨ asisɨha awaisɨha kimbapɨho Pasopaahandetɨ Jerusaremɨhanda numwɨhasanyure. Saimbɨ Asisɨha Pasopaahandɨ mmondaatɨmɨ numwɨhasanyure. ");
INSERT INTO agm_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iyataatɨ sura Jisaasihomɨ kɨnaukwɨha aimɨ awaisɨhaata ikwɨmaindɨmwɨtihɨ auhɨramɨ yahurɨtahaiwa 12 Kiyatɨ sanawihɨhura kimbapɨho Pasopaahandamɨ asisɨha awaisɨha noaipasɨhɨ kɨnaungwɨha nahatewetɨ kiyohɨpatamataiwɨ Jerusaremɨhandaahapɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nuwɨ Jerusaremɨhanda kimbapɨho Pasopaahandɨ mmonɨwɨ asisɨha nahatewa aimɨ sanotɨ owetihɨ japɨhɨ niyauhɨ metɨho Jisaasihohɨ Jerusaremɨhanda bindataise. Bimihɨ komɨ saniyɨ sapiyaahɨ Jisaasihopɨ Jerusaremɨhanda binye tɨmɨ wɨndɨ gɨmunyaase. Owe. ");
INSERT INTO agm_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nehɨ kapurɨ saimɨ gwɨnyaamaise Jisaasiho isɨhiya usaisatɨ maasɨ notaiso tɨmɨ gwɨnyaamaise. Saimɨ gwɨnyaamaamɨ namapɨ naihɨ asisɨha naasaahɨ sanausotaise. Aihɨ kapurɨ Jisaasiho metɨhopo tɨmɨ tɨtɨhɨ kapuramɨhiyaapɨhunɨ amɨ naisɨhiya usaapɨhunɨ nunjenɨmɨ pɨhɨtɨmɨ daamaise. ");
INSERT INTO agm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pɨhɨtɨmɨ dambɨmɨ woai wɨndɨ mausose. Owetise. Aihɨ kapurɨ kopɨ daitaatɨmɨ japɨhɨ Jerusaremɨhanda nomaise. ");
INSERT INTO agm_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Aihɨ kapurɨ asisɨha mairɨmanyetɨ dambɨmɨhura Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ bimihɨ usonamaise. Ko Aŋɨ Awaindɨhandaatɨhɨ isɨhiya katɨwunjohiyɨhiyaamɨ otɨhatɨhɨ bindataatɨ kiyaamɨ pɨwɨha atɨwisatɨ netɨ amɨ pɨwɨha komɨhaiwa kiyai taatɨ nunjesɨhɨ kapurɨ usonamaise. ");
INSERT INTO agm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aihɨ isɨhiya komɨ pɨwɨha atɨwisohiyɨhiya komɨ amɨtɨha nga gwɨnyaasɨtɨhandapunɨ amɨ komɨ pɨwɨha nga wihoaaŋɨha kataunjisɨhaapunɨ waatɨ yaiwɨmapɨ waatɨ gwɨnyaawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aihɨ kapurɨ saniyɨ sapiya koaisɨ iwinjamaamɨ waatɨ yaimɨmamaise. Yaimɨmaposamɨ metɨhoai sanaatɨ saundataase. “Maasɨho yaimburaaŋɨ kinyapɨ pɨhɨtaha gwɨnyaaha daahaayonɨ kɨmbɨhɨ sandɨ napaapɨ bindapaise? Nɨnunɨ kinyɨ gapɨhounɨ maarɨho naaŋanyisa maarɨho oweta yutɨpɨtihɨ kinyapɨ pɨhɨtaha daahaayono,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aihɨ metɨho Jisaasiho komɨha wihoaaŋɨha kapuri sata kaundataase. “Saimburaahɨ nisapɨ napaapɨ daamaise? Nɨnɨ nisɨ Apɨhomɨ aŋɨpɨpɨhɨ bimɨtandɨhandapɨ saimburaasangɨ wɨndɨ gɨmaasunyainjo?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sata ko kaundihɨ kapurɨ komɨ sata kaundisɨmaamɨ tanyaahaapɨ wɨndɨ omaŋɨtɨtɨhɨ namausesɨpatatɨ gɨmaawunyainje. ");
INSERT INTO agm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Aihɨ ko japɨhɨ kapurisatɨ maasɨ naihɨ nuwɨ aunahɨpatɨ Nasaretɨhanda noaipawaayopo. Noaipapɨ kapɨhɨ bindawaawɨ komɨ saniyɨ sapiyaamɨ pɨwɨha nahatewetɨ biya atɨwisatɨ kiyataise. Aihɨ komɨ sanaatɨ saiwa pɨwaiwa netɨ kaatamɨ amɨtetetɨ omaŋɨtɨtɨhɨ ahiyatɨ kaatɨnɨhɨ gwɨnyaatɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Aihɨ Jisaasiho gwɨnyanatɨ awaisɨhondaise. Iyatɨ amɨ komɨ amɨtɨha gwɨnyaasɨtɨhandɨ noaipatɨ gaahandɨndaise. Aihɨ Autaahaatɨhounɨ amɨ isɨhiyaunɨ koai maarɨho nunyawɨ wɨwipɨ kopɨ maaritawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa Taiperiyaasiho (Caesar Augustus) noaipatɨ awaisɨho jɨhoematatɨ Romɨhanda bindataatɨ isɨhiyai iwinjaatɨ bimihɨ kɨnaungwɨha ikwɨmaindɨmwɨtihɨ auhɨramɨ wihɨnɨrɨtahaiwa 15 kiyatɨ aimɨ sanausotaise. Aihɨ amɨ Pondiyaasɨ Pairotɨho awaisɨhoematatɨ yapɨpatɨ Judiyaahandɨ jaatɨ bindataise. Aihɨ amɨ sura Erotɨho (Herod) noaipatɨ awaisɨhoematatɨ yapɨpatɨ Garirihandɨ jaatɨ bindataise. Aihɨ amɨ Erotɨhomɨ saingɨho Piripɨho noaipatɨ awaisɨhoematatɨ yapɨhaurɨ Ituriyaahandunɨ amɨ Tɨraikonaitisɨhandunɨ jaatɨ bindataise. Aihɨ amɨ Raiseniyaasiho noaipatɨ awaisɨhoematatɨ yapɨpatɨ Abirinihandɨ jaatɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aihɨ amɨ sura Anaasiyɨ Kaiyapaasiya noaipapɨ otɨpɨpatɨ pɨrisihiya isɨhiyaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohɨpatamɨ mɨtɨhurɨ awaisururɨ jɨhurimatamaise. Aihɨ sura Jekaraiyaahomɨ mwaaho Jonɨho isɨhiya owetatɨ amɨ iwɨwɨrɨho wɨndɨ pɨhɨtatɨ namaawatɨ owehapɨhɨ bimihɨ Autaahaatɨho komɨ pɨwɨha koai nunyataise. ");
INSERT INTO agm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aihɨ Jonɨho pɨwɨha ka nesi waapɨhaatɨ Jorɨtanɨhaatainɨ aunahɨpɨhaiwa nahatewaara gaamatɨ pɨwɨha ausaatɨ sata kaundataase. Sahɨ samɨ maipɨhaiwa ainjotiwaiwa kiyohɨwaiwa namasi nepemaitɨwɨ waapoho nepɨse. Sahɨ saisaihɨ samɨ maipɨhaiwa Autaahaatɨho nesamaito undatɨ sapɨhɨ pɨwɨha ausaatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jonɨho sandɨ siyatɨ kaindɨmandaahɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho pɨropetɨ Aisaiyaaho satatɨ komɨ utɨpɨhoaatɨhɨ ahaisɨha akematɨ ausaimanatɨ noaipataise. Ka pɨwa Aisaiyaaho satatɨ kandaase. “Isɨhiya owehapɨhapɨ utaaho womɨ gapɨpa satahapa noaipataise. Awaisɨhomɨ daihɨra napɨtandɨhɨra nepɨ tɨmanɨwɨse. Tɨtɨhepumapɨ sanahɨwaiwɨse Awaisɨho kɨra napɨtando. ");
INSERT INTO agm_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gwaahorɨhɨrɨ timbwaapasɨpɨpa yapɨpatɨ japɨhɨ nepɨ wipɨ naasaataatɨmapɨ amɨ sisɨho sɨhoaarɨhɨrɨ dotɨ tiwanyapetimbɨpa otipapɨ yatɨhipɨ ipɨhaapɨ naasaataatɨmapɨse. Aiwɨ daihɨra nangisana nesɨwesɨmanatɨ daundiwaiwa nepɨ tɨtɨhɨmapɨ nopɨmapɨ daupwɨse. Aiwɨ daihɨra nawɨha damipatɨ ahotimbɨpa natipɨ otɨndɨwɨ nemapɨ daihɨra isuriwɨ etapɨhandɨ ahiyamapɨse sanahɨwetɨto. ");
INSERT INTO agm_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aisaihɨ isɨhiya nahatiya Autaahaatɨho isɨhiyai japɨhɨ numwaitandɨ ko otɨpɨpatɨ kaindɨhandɨ mmondaatɨwo,” tatɨ Aisaiyaaho katisɨhaare. ");
INSERT INTO agm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Isɨhiya taahɨtɨhandɨ Jonɨho nyangi waapohora baanyusɨto tɨwɨ koaapɨhɨ nasawaayopo. Saiwɨ nasauhɨ Jonɨho kiyai saundataase. “Sahɨ akwɨranɨho maipɨhomɨ mwaayaate. Samɨ maipɨhaiwa kiyohɨwaiwaapɨ Autaahaatɨhoai apowindɨhandaahɨ wihoaaŋɨhandɨ yaasɨhandɨ waatɨ nasamɨtandɨhandapɨ ndɨ kasatihɨ yanɨhɨmapɨ nasopo? ");
INSERT INTO agm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sahɨ samɨ maipɨhaiwa ainjotahaiwai aimɨ namasi japɨhɨ nepemaitɨhaayo undɨwɨ nunjɨtaatɨwɨ tɨtɨhɨ gaahaiwaahɨhɨ kaiwɨse. Iyawaawɨ sahɨ nehɨ sawanaatɨ samanɨwɨse Abɨraahamɨho nyamɨ apɨhore maatɨwɨse. O amɨ apaapɨmaatonɨ sandapɨ nɨnɨ kasatɨtaano. Autaahaatɨho kɨmaiwa nawɨmaiwaisɨ nga kaundonɨhɨ kɨmaiwa nawɨmaiwa noaipatɨ Abɨraahamɨhomɨ manyinyaimatɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ipatamɨ tanyaahainɨ mwɨsɨha aimɨ ahondaise. Ipatɨ nahatepɨ yandɨpɨho wɨndɨ biyatɨ namingosɨpati tisatɨwɨ sisɨhaapɨhɨ tɨhoaitaapo,” tatɨ Jonɨho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sata Jonɨho kaundihɨ isɨhiya nahatiya komɨ pɨwɨha atɨwisohiyɨhiya Koai saundɨwɨ nunjenawaayopo. “O siyonaahɨ amɨ nyahɨ nyamɨ maipɨhaiwaapɨ napitaitɨhaawe,” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Saundɨwɨ nunjenɨhauhɨ ko kiyai sata wihoaaŋɨha kaundataase. “Utaahoŋɨ woŋɨ apotɨhɨrɨ nipaatɨtaapɨhɨrɨ yatɨmwɨnaahɨ wɨrɨ utaaho wo owehoai nunye. Iyataatɨ amɨ woŋɨ nandapa asaketahoŋɨtapaapaahɨ naasɨkatɨ kaimbɨ wo nandapa owehoai nunyapɨ nanɨme,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aihɨ amɨ isɨhiya usa nawɨho taakɨsihandɨ nehohiyɨhiya waapoho naitaatɨwɨ nasohiyɨhiya Jonɨhoai satɨwɨ nunjenawaapo. Amɨ nyahɨho? Nyahɨ napitaitɨhaawe?” undɨwɨ koai nunjenawaapo. ");
INSERT INTO agm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Saundɨwɨ nunjenɨhauhɨ ko komɨha wihoaaŋɨha kiyai saundataase. “Gamanɨho nawɨho taakisihandɨ samwaaŋɨ isɨhiyaamɨ nepɨse tatɨ katimumwaaŋɨ kamwaaŋɨ tɨtɨhɨ nawɨho isɨhiyaamɨ sahɨ nepɨse. O ko nawɨhomɨ tiwatɨhaatɨ sangisunyaapɨ wo nehɨho apɨpaahɨ wɨndɨ namepɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aihɨ amɨ isɨhiya usa pwɨsɨpɨ yaipa kiyohiyɨhiya Jonɨhoai satɨwɨ nunjenawaapo. “O amɨ nyahɨho? Nyahɨ napitaitɨhaawe?” undɨwɨ nunjenawaapo. Saundɨwɨ nunjenɨhauhɨ ko komɨha wihoaaŋɨha kiyai saundataase. “Isɨhiyai nopɨsasɨwɨ tɨmapɨse. Aiwɨ pɨwɨha nehɨha jaiwɨtɨha pɨwaamaatɨwɨse isɨhiyaamɨ nawɨho jaiwaiwɨ nusaitaatɨwo. Nawɨho tɨtɨhɨ sahɨ otɨpɨpatɨ kiyohɨpatapɨho jaawɨ nepɨse. Nepɨ satɨwɨ nyangi nyatatamanɨtandɨ nawɨho kɨmɨko gaare tɨwɨ gwɨnyaapɨ nepɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Saundihɨ isɨhiya kiyaamɨ maarɨho ambɨpatɨ waatɨ uwɨndosɨhɨ nahatiya waatɨ kiyaamɨ maarɨhoaatɨhapɨ saiwɨ gwɨnyaawaayopo. “Jonɨho kɨmo Kɨraisiho Autaahaatɨho komɨ isɨhiyai japɨhɨ numwaitandɨ namɨhainjɨhotindɨho,” tɨwɨ gwɨnyaawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Saiwɨ gwɨnyaahauhɨ Jonɨho kiyai wihoaaŋɨha saundataase. “Nɨnɨ nehɨ waapohoraahɨ sangi baasusataayo. Utaaho wo apɨpaahɨ Awaisɨho nɨngi nanɨtipɨhaaho ipotɨ napɨtaise. Iyataatɨ nɨnɨ komɨ otɨpɨpatɨhonɨnɨndaahandɨ kandɨ otɨpɨpatɨhiyaamɨ kiyohɨwaiwa kaindɨ nambɨtɨtɨ komɨ asuipatamɨ wɨrɨhɨrɨ nesɨpatɨ nausohaumwaamaito. Isɨ amɨ ko sangi Itɨpɨho Gaahoraahunɨ amɨ Sisɨhaaraahunɨ baasusɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ko komɨ ikwɨraahɨ saaworɨhɨrɨ isɨwahore kɨraahɨ konɨho witɨhandamɨ yutɨhɨrɨ pasaaha tɨwɨhaatɨ nemaitando. Tɨwɨhaatɨ yutɨhɨrɨ pasaaha nemata konɨho witɨhandɨ akɨtɨhandɨ kandamɨ aŋɨhandɨ gwɨnyaatɨ aŋɨmatindɨhandaatɨhɨ ahiyataatɨ yutɨhɨrɨ pasaaha netɨ sisɨha namaayota kaanɨhɨ nasisoaarɨ tɨhisɨhaapɨhɨ tɨhoaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jonɨho pɨwɨha pɨhɨtahaiwa kiyai kiyaamɨ maarɨho omaŋɨtɨtɨhɨ yaurɨwɨhaiwa kiyai kaundataase. Siyatɨ kaundatɨ pɨwɨha gaaha wanɨha isɨhiyai ausaatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Siyatɨ kiyai kaundataatɨ amɨ Jonɨho Erotɨho awaisɨho kiyai winjaatɨ bimisɨhoai ko maipɨhandɨ wɨndɨ kiyatɨ komɨ saingɨhoai maipɨhandɨ kawɨsatɨ komɨ apwaataatɨ Erotiyaasihaati ikona numwaasɨhɨ kandapɨ itɨhundataase. Iyatɨ amɨ maipɨhaiwa wiwaimaawɨ kaihɨ kaiwaapimaawɨ ahoyatɨ itɨhundataase. ");
INSERT INTO agm_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aihɨ Erotɨho kaiwa maipɨhaiwa taahɨwaiwa kaiwaiwaamɨ tiwatɨhaatɨ bihɨwainjatɨ maipɨhandɨ wɨndɨ kiyatɨ Jonɨhoai nepɨ wɨrapɨ napuwɨtaatɨwɨ komɨ tingaatɨhaisahiyai kaundihɨ kiya Jonɨhoai nepɨ wɨrapɨ numwaasi nuwɨ isɨhiya naputohɨpɨpɨhɨ napuwawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Aihɨ Jonɨho isɨhiyai waapohora baawusihɨ waapoho nepɨ bimauhɨ amɨ Jisaasihoaisangi kapɨhɨ naihɨ Jonɨho waapohora baawusataise. Jonɨho aimɨ baawusatɨ owetihɨ ko Jisaasiho nehɨhaatɨ notatɨ bitondaatɨ Autaahaatɨhoai taatɨ pɨwaundatɨ gaapundataase. Ko taatɨ gaapundihɨ yamɨhapatɨ tɨwɨtawamataise. ");
INSERT INTO agm_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aihɨ Autaahaatɨhomɨ Itɨpɨho Gaaho yamɨhapataatɨhɨraapɨ noaatɨpataise. Siyatɨ Autaahaatɨhomɨ Itɨpɨho Gaaho yamɨhapataatɨhɨraapɨ tɨtɨhɨ koho komɨ ambɨpatɨ dɨpɨhomatiyaho noaatɨpatɨ Jisaasihomɨhasɨnɨ komɨ mɨtɨhoaatɨhɨ nasataise. Aihɨ amɨ yamɨhapataatɨhapɨ pɨwɨha gapɨpa satahapa noaipataise. “Kɨnyɨ Nisɨ Maasɨhɨhoŋɨ akohoŋɨtinɨhɨ Nɨnɨ gi nisɨ maarɨho apɨpaahɨ aungwohandɨ nahinyatɨ amɨ nisɨ maarɨho gi wɨhitɨhoŋe,” tatɨ pɨwɨha yamɨhapataatɨhapɨ noaipataise. ");
INSERT INTO agm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisaasihomɨ kɨnaungwɨha ikwauhɨmaindɨmwɨtihɨ amɨ kaatɨ ikwɨmaindɨmwɨtihɨ 30 kiyatɨ sanawihɨhura ko komɨ otɨpɨpatɨ namasatɨ kiyataise. Aihɨ isɨhiya Jisaasihopɨ Josepɨhomɨ mwaahoe tɨwɨ usonɨwɨ gwɨnyaawaayopo. Josepɨho so Eraihomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eraiho so Mataatɨhomɨ mwaahore. Aihɨ Mataatɨho so Ripaihomɨ mwaahore. Aihɨ Ripaiho so Merɨkaihomɨ mwaahore. Aihɨ Merɨkaiho so Janaihomɨ mwaahore. Aihɨ Janaiho so Josepɨhomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Aihɨ Josepɨho so Matataiyaasihomɨ mwaahore. Aihɨ Matataiyaasiho so Amosihomɨ mwaahore. Aihɨ Amosiho so Nahumɨhomɨ mwaahore. Aihɨ Nahumɨho so Esɨraihomɨ mwaahore. Aihɨ Esɨraiho so Nakaihomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Aihɨ Nakaiho so Maahaatɨhomɨ mwaahore. Aihɨ Maahaatɨho so Matataiyaasihomɨ mwaahore. Aihɨ Matataiyaasiho so Semenɨhomɨ mwaahore. Aihɨ Semenɨho so Josekɨhomɨ mwaahore. Aihɨ Josekɨho so Jotaahomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Aihɨ Jotaaho so Joananɨhomɨ mwaahore. Aihɨ Joananɨho so Resaahomɨ mwaahore. Aihɨ Resaaho so Serupaperɨhomɨ mwaahore. Aihɨ Serupaperɨho so Siyaarɨtiyerɨhomɨ mwaahore. Aihɨ Siyaarɨtiyerɨho so Neraihomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Aihɨ Neraiho so Merɨkaihomɨ mwaahore. Aihɨ Merɨkaiho so Adaihomɨ mwaahore. Aihɨ Adaiho so Kosamɨhomɨ mwaahore. Aihɨ Kosamɨho so Erɨmatamɨhomɨ mwaahore. Aihɨ Erɨmataamɨho so Erɨhomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Aihɨ Erɨho so Josuwaahomɨ mwaahore. Aihɨ Josuwaaho so Eriyeserɨhomɨ mwaahore. Aihɨ Eriyeserɨho so Jorimɨhomɨ mwaahore. Aihɨ Jorimɨho so Mataatɨhomɨ mwaahore. Aihɨ Mataatɨho so Ripaihomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Aihɨ Ripaiho so Simiyonɨhomɨ mwaahore. Aihɨ Simiyonɨho so Judaahomɨ mwaahore. Aihɨ Judaaho so Josepɨhomɨ mwaahore. Aihɨ Josepɨho so Jonamɨhomɨ mwaahore. Aihɨ Jonamɨho so Eraiyakimɨhomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Aihɨ Eraiyakimɨho so Meriyaahomɨ mwaahore. Aihɨ Meriyaaho so Menaahomɨ mwaahore. Aihɨ Menaaho so Matataahomɨ mwaahore. Aihɨ Matataaho so Natanɨhomɨ mwaahore. Aihɨ Natanɨho so Daawitɨhomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Aihɨ Daawitɨho so Jesihomɨ mwaahore. Aihɨ Jesiho so Obetɨhomɨ mwaahore. Aihɨ Obetɨho so Sarɨmonɨhomɨ mwaahore. Aihɨ Sarɨmonɨho so Naasonɨhomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aihɨ Naasonɨho so Aminataapɨhomɨ mwaahore. Aihɨ Aminataapɨho so Atɨminɨhomɨ mwaahore. Aihɨ Atɨminɨho so Arɨnaihomɨ mwaahore. Aihɨ Arɨnaiho so Esɨronɨhomɨ mwaahore. Esɨronɨho so Peresihomɨ mwaahore. Aihɨ Peresiho so Judaahomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Aihɨ Judaaho so Jekopɨhomɨ mwaahore. Aihɨ Jekopɨho so Aisaakɨhomɨ mwaahore. Aihɨ Aisaakɨho so Abɨraahamɨhomɨ mwaahore. Aihɨ Abɨraahamɨho so Teraahomɨ mwaahore. Aihɨ Teraaho so Nahorɨhomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Aihɨ Nahorɨho so Serukɨhomɨ mwaahore. Aihɨ Serukɨho so Reyuhomɨ mwaahore. Aihɨ Reyuho so Perekɨhomɨ mwaahore. Aihɨ Perekɨho so Eberɨhomɨ mwaahore. Aihɨ Eberɨho so Seraahomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Aihɨ Seraaho so Kenanɨhomɨ mwaahore. Aihɨ Kenanɨho so Arɨpakɨsaatɨhomɨ mwaahore. Aihɨ Arɨpakɨsaatɨho so Siyemɨhomɨ mwaahore. Aihɨ Siyemɨho so Nuwaahomɨ mwaahore. Aihɨ Nuwaaho so Ramekɨhomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ramekɨho so Metuseraahomɨ mwaahore. Aihɨ Metuseraaho so Enokɨhomɨ mwaahore. Aihɨ Enokɨho so Jaretɨhomɨ mwaahore. Aihɨ Jaretɨho so Mahararerɨhomɨ mwaahore. Aihɨ Mahararerɨho so Kenanɨhomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Aihɨ Kenanɨho so Enosihomɨ mwaahore. Aihɨ Enosiho so Setɨhomɨ mwaahore. Aihɨ Setɨho so Adaamɨhomɨ mwaahore. Aihɨ Adaamɨho so Autaahaatɨhomɨ mwaahore. ");
INSERT INTO agm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisaasihomɨhetɨ Itɨpɨho Gaaho pɨhɨtatɨ tɨwisaitataise. Aihɨ Jisaasiho waapɨhaatɨ Jorɨtanɨhaatɨ namasi japɨhɨ naihɨ Itɨpɨho Gaaho wapa gaahapa iwɨwɨrɨho namaawa isɨhiya owehapɨhɨ numwaasi notaise. ");
INSERT INTO agm_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Siyatɨ notɨ Jisaasiho isɨhiya owehapɨhɨ bimihɨ waatɨho naasohɨtihɨ amɨ asisɨha ikwɨmaindɨmwɨ 10 kiyatɨ nusoaipataise. Siyatɨ Jisaasiho asisɨha utaarɨhandetɨ bimihɨ Bwaasɨrɨhɨrɨ Autaahaatɨhomɨ pɨwɨha nemwaitando tatɨ nunjenataise. Aihɨ sura asisa saiwetɨ Jisaasiho nandapa wɨndɨ namainjɨhɨ jaumanataise. ");
INSERT INTO agm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aihɨ Bwaasɨrɨhɨrɨ Jisaasihoai saundatɨ nunjenataise. “Kɨnyɨ Autaahaatɨhomɨ mwaahoŋɨtapaapaahɨ kɨma nawɨma noaipatɨ nandapa bɨretɨhandimatɨtandɨ kaunde,” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aihɨ Jisaasiho komɨha wihoaaŋɨha saundataase. “Autaahaatɨhomɨ pɨwɨha sandaase. ‘Nandapa bɨretɨhandaahɨhɨ utaahoai ko asohoematatɨ bimɨtandɨhandɨ wɨndɨ namumwɨtaise,’ tise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aihɨ Bwaasɨrɨhɨrɨ koai numwaasi niyatɨ ketɨ kuraanɨhɨ isɨhiya jaawɨ bimohɨwaiwa yapɨhaiwa nahatewa maapɨ yapɨpatambɨhaiwa nunjataise. ");
INSERT INTO agm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nunjatɨ koai saundataase. “Saiwa isɨhiyaamɨ yapɨhaiwa nahatewa amɨ kiyaamɨ kahapaamapɨpa yundanya gaahaiwa nahatewa kɨnyɨ awaisɨhoŋimatɨpɨ jatɨtaapɨ gi nahɨmɨto. Nahataapa gisɨ nahɨmisanɨhɨ kapa kɨnyɨ jatapaapɨ kapetapɨ ambɨpatɨ awaipatɨ autaahɨ naitaise. Iyataatɨ saiwa yapɨmaiwaunɨ amɨ kahapaamapɨpa gaahaiwa nahataapa noaipatɨ aimɨ nisɨhapaare. Isɨ nɨnɨ utaaho woai kapa numwɨtandɨ gwɨnyaatɨ maaritataahoai numwɨto. ");
INSERT INTO agm_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Isɨ kɨnyɨ nisapɨ atotɨpɨwesapɨ nisapɨ gaapɨnundisamaahɨ saiwa nahatewa noaipatɨ kinyɨhaiwaatɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Saundihɨhandɨ kandɨ Jisaasiho komɨha wihoaaŋɨha koai saundataase. “Amɨ Autaahaatɨhomɨ pɨwɨha sataha jɨpatɨpindise. ‘Kɨnyɨ kinyɨ Autaahaatɨho Awaisɨhomɨ otɨtɨhɨ yatɨhɨ pɨnumbwɨ nehɨ koaisaahɨhɨ atɨwime. Atɨwimbɨ nehɨ ko naasomɨ otɨpɨpatɨ nehɨ komɨhatɨhɨhɨ kawime,’ tatɨ pɨwɨha jɨpatɨpindise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aihɨ Bwaasɨrɨhɨrɨ Jisaasihoai numwaasi Jerusaremɨhanda niyatɨ Autaahaatɨhomɨ Aŋɨ Awaindɨhandaasɨnɨ autaahɨ nɨwaataatɨ mɨhasɨnɨ ahɨwisataise. Ahɨwisatosatɨ koai saundataase. “Amɨ akɨtɨnɨhɨ kɨnyɨ Autaahaatɨhomɨ mwaahoŋɨtapaapaahɨ kɨmasɨnapɨ mɨhaapɨ naapwaate. ");
INSERT INTO agm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Amɨ Autaahaatɨhomɨ pɨwɨha wa sata jɨpatɨpindiso. ‘Korɨ komɨ enjerɨhiya otɨpɨpatɨhiya yamɨhapataatɨhɨ bimohiyɨhiyai kaundonɨhɨ kiya baiwɨ gisɨ ginjatɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aiwɨ kiya kiyaamɨ ikwɨraahɨ gisɨ giwasaihɨ nawɨhaara kɨnyɨ kinyɨ ikwauhɨrɨ asundusoaapɨ mɨmaahɨwɨtaise,’ tatɨ jɨpatɨpindiso,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Aihɨ amɨ Jisaasiho komɨha wihoaaŋɨha pɨwɨha Bwaasɨrɨhɨri satatɨ kaundataase. “Amɨ pɨwɨha wa Autaahaatɨhomɨ utɨpɨhoaatɨhɨ sataha jɨpatɨpindataise. ‘Kɨnyɨ kinyɨ Awaisɨho Autaahaatɨhoai napɨtaise tɨpɨ namunjenɨme’ tatɨ jɨpatɨpindataise” undataase. ");
INSERT INTO agm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Siyatɨ Bwaasɨrɨhɨrɨ kɨhɨra kɨhɨraapɨ Jisaasihoai nunjenatɨ owematɨ namɨhaataise. Iyatɨ sɨhɨ waaraahapo tatɨ Jisaasihoai numwɨhaataise. ");
INSERT INTO agm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Aihɨ Jisaasiho Autaahaatɨhomɨ Itɨpɨhomɨ watɨpɨhandisaho Garirihandaahapɨ japɨhɨ notaise. Japɨhɨ naihɨ isɨhiya kapɨhɨ bimohiyɨhiya Jisaasiho aimɨ yamo japɨhɨ napɨse nnɨwɨ pɨwɨha nesi kihoaaŋɨ gaamapɨ kanɨwɨ atisawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jisaasiho kiyaamɨ aŋɨ gwɨharaahaiwaatɨhɨ notɨ nandaatɨ pɨwɨha kataunjataise. Aihɨ isɨhiya nahatiya koai mepɨ autaahepumapɨ kopɨ waatɨ maaritawaapo. ");
INSERT INTO agm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Aihɨ Jisaasiho Nasaretɨhanda notaise. Satɨ aunahɨpitɨ Jisaasiho sangɨho jɨhura bindataatɨ kataahapɨ gwɨnyainjɨpate. Isɨ kata asisɨha Saraarehura Sapaatɨhandɨ Judaahiya ikɨnawaasohɨhetɨ Jisaasiho komɨ kaipatɨ kiyatɨ Judaahiyaamɨ aŋaaŋɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundɨtaatɨwɨ ahoyanawaasohɨpɨpɨhɨ nandaataise. Nandaatɨ Autaahaatɨhomɨ pɨwɨha awɨtɨtandɨ isɨhiyai mandusosatɨ dotɨ bitondaise. ");
INSERT INTO agm_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dotɨ bitosɨhɨ pɨropetɨ Aisaiyaaho Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨhomɨ utɨpɨho koai nepunyawaayopo. Nepunyauhɨ ko netɨ utɨpɨhandɨ kandɨ napapopɨwɨhandisɨ nesɨpatɨ nupwiyaatɨ pɨwɨha sataha jɨpatɨpindisɨha mmonatɨ awɨndaise. ");
INSERT INTO agm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Awaisɨho Autaahaatɨhomɨ Itɨpɨho Gaahoai natausaasihɨ nasatɨ nisɨhetɨndaise. Aihɨ amɨ sandapɨ Autaahaatɨho nɨngi nanɨmahanataise. Isɨhiya wapa owehiya taanahiyɨhiyai Pɨwɨha Gaaha Wanɨha ausaatɨ kaundɨtando. Ko Awaisɨho nɨngi natanoaasihɨ nasataayo isɨhiyai saundɨtandɨ sangi isɨhiya usa nepɨ wɨsirapɨ nasapuhohiyɨhiyaatɨ samɨ naputohɨtɨhandaatɨhapɨ noaipapɨse. Sahɨ ndɨha niyotatɨ asahatisawɨhiyaatɨ jahɨra samɨ ndɨha norɨhaapɨ jasawise. Ko nɨngi natanoaasihɨ nasataayo amɨ isɨhiya usai isɨhiya usa tipɨ nepɨ gwaapwɨwɨ mɨmaipɨwisauhɨ pɨwɨha owehiya bimohiyɨhiyai samɨ maarɨho ambɨpatɨ yaasatɨ naaŋasindɨhandɨ nesamataayo undɨtande. ");
INSERT INTO agm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aindɨ Awaisɨho komɨ isɨhiyai japɨhɨ numwaatɨ gaahandɨ kawitandɨhuraapɨ aimɨ asisɨha kɨma noaipataise undɨtandɨ nɨngi ko natanoaasataise,” tatɨ jɨpatɨpindisɨha mmonatɨ awɨndaise. ");
INSERT INTO agm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Siyatɨ Jisaasiho pɨwɨha awɨtatɨ owetihɨ japɨhɨ mmatɨ napapotɨmanatɨ utɨpɨhandɨ jatisɨhoai nunyatosatɨ isɨhiyai kataunjɨtandɨ bindataise. Bimihɨ isɨhiya nahatiya aŋɨhandɨ gwɨharaahandɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundohɨtɨhandaatɨhɨ ahoyanohɨtɨtɨhɨ bimohiyɨhiya kiyaamɨ ndɨha nehɨ Jisaasihomɨhetɨ mwɨtɨpisawɨ iwinjatawaapo. ");
INSERT INTO agm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Saiwɨ kiyaamɨ ndɨha nahata komɨhetɨ ahotihɨ iwinjatauhɨ ko namasatɨ kiyai pɨwɨha sata kaundataase. “Autaahaatɨhomɨ pɨwɨha satatɨ jɨpatɨpindisɨha nɨnɨ awɨtonɨhɨ amɨ sahɨ atisauhɨ wanɨ kɨmura ka noaipatɨ tɨtɨhɨ akɨtɨnɨhɨ akaahaimatataise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Aihɨ kiya kopɨ satɨwɨ “Ese ko utaaho gaahore. Ko pɨwɨha gaaha kandaase,” tɨwɨ kopɨ kiya maaritawaayopo. Aiwɨ pɨwɨha gaaha ko katihɨ amɨ kiya atisohɨhaapɨ kiya waatɨ pɨhɨtɨwɨ gwɨnyaawaayopo. Gwɨnyapenɨwɨ kiya kopɨ satawaatopo. “Utaaho kɨmo nɨnapitiyahoe nyahɨ Josepɨhomɨ mwaahoe taatiyono koai woro?” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Satɨwɨ katauhɨ Jisaasiho komɨha kiyai saundataase. “Amɨ apɨpaahɨ akɨtɨnɨhɨ sahɨ nɨngi isɨhiya usa pɨwɨha satɨwɨ katohɨha nepɨ kandɨtaapo. ‘Dokɨtaahoŋe, kinyɨ timbɨpa kɨnyɨ kɨwahoŋɨ nepɨ tɨtɨhemate.’ Aimbɨ aunahɨpa Kapaniyaamɨhanda kɨnyɨ watɨpɨhaiwa wiwa kainɨhɨ kaiwaapɨ nyahɨ aimɨ atisonɨ kapɨhɨ kaingɨpɨpa naasɨkapa kɨmbɨhɨ kɨnyɨ kinyɨ aunahɨpɨmataahisangi kaime ndɨtaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Saundatosatɨ pɨwɨha wa jɨhaatɨ bihɨwatɨ saundataase. “Nɨnɨ sangi akɨtɨnɨhɨ pɨwɨha kɨma kasatataato. Utaaho wo Autaahaatɨhomɨ pɨwɨha atisa netɨ ausaasɨho tɨtɨhɨ komɨ aunahɨpata pɨwɨha komɨhiyai kaunda kiyonɨhɨ komɨ pɨwɨha atɨhomaawitaapo. Atɨhomaawiwɨ kiya koai maarɨho namunyawɨ wɨndɨ maaritɨwɨ namumwaapɨ koai pohipɨwitaapo. ");
INSERT INTO agm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nɨnɨ apɨpaahɨ pɨwɨha akaaha kɨma sangi kasatataato. Sahɨ atiwɨse. Jɨhɨ Eraijaaho bimisura Isɨraherɨhanda asɨhiya osɨnɨhiya taahiyɨhiya bindawaayopo. Aihɨ sura wipatɨ wɨndɨ wimaawatɨ yatɨhɨrɨ ahotɨmɨ naihɨ kɨnaungwɨha mairɨmaatihɨ waatɨho ikwɨrɨ naasairɨtihɨ wɨramɨ naasohɨtahaiwa kɨnaungwɨha 3 kiyatɨ amɨ waatɨho 6 kiyatɨ sanotaise. Aihɨ jarɨho aungwohandɨ nahataapɨpɨhɨ noaipataise. ");
INSERT INTO agm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Siyatɨ jarɨho noaipasɨhandɨ kandɨ Autaahaatɨho Eraijaahoai Isɨraherɨhanda osɨnɨhiyaamɨ waataapɨhɨ kaati wapa nausetɨtanɨhapaapɨ iwɨtatamanɨtandɨ natausaasataamaise. Owetise. Nehɨ yapɨpatɨ wɨtɨ Saitonɨhanda aunahɨpa wɨtɨ Sarepatɨhanda apopaatɨ waatɨ osɨnɨhaatɨ bimihɨhaatenda kaati iwɨtatamanɨtandɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Iyataatɨ amɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho Erisaaho bimisuraisangi isɨhiya pɨhɨtahiya kiyaamɨ ambɨpatetɨ timbɨpa asaahaisahiya Isɨraherɨhanda bindawaayopo. Iyataatɨ kiya timbɨpa asaahaisahiyaamɨ otɨhatɨhapɨ utaaho wo nehɨ naasoaisangi Erisaaho wɨndɨ tɨtɨhemwaamase. Owetise. Nehɨ utaaho koai wo yapɨpatɨ Siriyaahandaahapɨho Namaanɨhomɨ timbɨpa asaaha tɨtɨhemwase,” tatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aihɨ isɨhiya nahatiya Judaahiyaamɨ aŋaaŋɨ gwɨharaahaaŋɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundɨtaatɨwɨ ahoyanohɨpɨpɨhɨ bimohiyɨhiya sa pɨwɨha atisawaawɨ apɨpaahɨ apousataise. ");
INSERT INTO agm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Apowihɨ kiya dopawɨ Jisaasihoai nepɨ aisi tiwɨtaatɨwɨ kiyaamɨ aunahɨpatamɨ nehɨhaatɨ mangɨrainapɨ noaipasi nowaayopo. Iyataatɨ kiyaamɨ aunahɨpitɨ satɨ sisɨho woaasɨnɨ ahendaise. Isɨ Jisaasihoai aisi nepatɨhopɨ nesuwɨ nepandɨtaatɨwɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Saiwɨ aisi niyauhɨhandɨ kandɨ isɨhiya wɨrɨsandɨhandamɨ otɨhatɨhɨ daimɨ koai isɨhiya wɨndɨ maawiwasauhɨ kiyai numwasi konɨhɨ nomataise. ");
INSERT INTO agm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Saiwɨ kiya kawɨsauhɨ Jisaasiho aunahɨpa taunɨhandɨ Kapaniyaamɨhandaahapɨ noaatɨpataise. Satɨ aunahɨpitɨ taunɨhandɨ Garirihandamɨ aunahɨpatɨ taunɨhande. Isɨ kata asisɨha Judaahiya ikɨnohɨha Saraarehura Sapaatɨhandetɨ Jisaasiho isɨhiyai pɨwɨha kataunjataise. ");
INSERT INTO agm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aihɨ komɨ pɨwɨha kiya atisawaawɨ kaapɨ “ese” tɨwɨ waatɨ yaiwɨmawaapo. Kiya siyohɨtɨmandɨ amɨ pɨwɨha apɨpaahɨ watɨpɨha watɨpɨhandisɨha kiyai kataunjihɨ atisawaawe. ");
INSERT INTO agm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Iyataatɨ sandɨ aŋɨ gwɨharandɨ Judaahiya Autaahaatɨhopɨ gwɨnyaapɨ gaapundɨtaatɨwɨ ahoyanohɨtɨhandaatɨhɨ utaaho wo itɨpɨho maipɨhoaisaho bindataise. Bindataatɨ ko waatɨ kaahaata sandaase. ");
INSERT INTO agm_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ese Nasaretɨhandaahapɨ Jisaasihoŋe, kɨnyɨ nyangi nepɨ napitɨnyitaapɨ napise? Kɨnyɨ nyangi nepɨ nanyopɨsasɨtaapɨ napɨno? Kɨnyɨ akɨtɨnɨhɨ tɨtɨhɨ Autaahaatɨhomɨhoŋɨtihɨ nɨnɨ gisonɨtɨ gwɨnyaataayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Saundihɨ Jisaasiho ko itɨpɨ maipoai itɨhundatɨ saundataase. “Kɨnyɨ ŋuŋaatɨpɨ pɨwaamaatɨpɨ bɨpi kɨmo utaamoai namasisɨ noaipape,” undataase. Saundihɨ so itɨpɨ maipo utaasoai netɨ yapɨpatetɨ isɨhiyaamɨ ndɨhetɨ yotamapɨ koai namasi notaatɨ koai wɨndɨ nusopɨsasatɨ tɨmaawise. ");
INSERT INTO agm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Aihɨ isɨhiya nahatiya sandɨ mmonawaawɨ yaiwɨ itiwawaayopo. Itipɨ kiya sawana sanawaatopo. “Pɨwɨha sa napitiyaha kandaatindɨho? Komɨ pɨwɨha katisɨha apɨpaahɨ watɨpɨhandɨ wɨndisahe amɨ ko watɨpɨhandɨ wɨndisahosɨ pɨwɨha katihɨ itɨpɨho maipɨhapa komɨ pɨwɨha atɨwisatɨ noaipasi notaise,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Satɨwɨ Jisaasiho sandɨ siyatɨ kaindɨmandapɨ kapɨhɨ kihoaaŋɨ nahataapɨpɨhɨ pɨwɨha nesi gaamapɨ kanɨmɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisaasiho Judaahiyaamɨ aŋɨ gwɨharaahonjɨ namasi Saimonɨ Pitaahomɨ aŋɨpɨpɨhapɨ notaise. Naihɨ Saimonɨhomɨ sanohaamaatɨ yaawatɨ sisɨha tɨhwɨtɨhɨrɨ aungwohandɨ nusoaipasɨhɨ nanotondaise. Nanototihɨ koai kaatapɨ kaatamɨ timbɨpa nemwaito tɨwɨ nunjenɨwɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kaundauhɨ Jisaasiho niyatɨ kaatamɨ nanototimbɨpɨhɨ detɨ bitonda timbɨpa sisɨha tɨhwɨtɨhɨri itɨhundataase. Itɨhundihɨ kaatamɨ timbɨpa ketɨ kuraanɨhɨ nurɨmɨhaatɨ owetihɨ nepatɨ gaahaatɨ bindata kiyaapɨ nandapa netɨ tɨhatɨ turɨmanataise. ");
INSERT INTO agm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Judaahiyaamɨ asisɨha ikɨnohɨha Saraarehura Sapaatɨhandɨ ipɨho taatɨ aimɨ nipatisura owendaise. Aihɨ isɨhiya usa kiyaamɨ naisɨhiya timbɨpa kahatamatɨpetahapaisahiyai kiya numwaasi Jisaasihoaapɨhɨ nasawaayopo. Aihɨ Jisaasiho komɨ ikwɨrɨ kiya timbɨpaahiyai nɨnaasiyaamɨhasɨnɨ ahɨwisatɨ kiyaamɨ timbɨpa nemwasɨhɨ gaawimatataise. ");
INSERT INTO agm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iyatɨ ko kiya isɨhiyaamɨhetɨ itɨpɨho maipɨhapa bimimbɨpa nahataapai nemwasɨhɨ kapa kiyai namasi notaise. Iyataatɨ sapa itɨpɨho maipɨhapa yayatɨ sata kandaase. “Kɨnyɨ Autaahaatɨhomɨ Mwaahoŋe,” tatɨ yayatɨ kandaase. Aihɨ Jisaasiho itɨpɨho maipɨhapai siyatɨ kiya katɨto tatɨ nehɨ maawinjatɨ itɨhundataase. Iyataatɨ itɨpɨho maipɨhapaahɨ Jisaasihopɨ komɨ Isɨhiyai Japɨhɨ Numwaitandɨ Autaahaatɨho Ahɨwisɨho Kɨraisihoe tatɨ gwɨnyaahapaaso. ");
INSERT INTO agm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aihɨ asisɨhaatɨhɨ koho koaisatɨ satɨ aunahɨpita namasi isɨhiya owehapɨhɨ aupwɨpɨhapɨ notaise. Aihɨ isɨhiya kopɨ daapɨ nuwɨ koai winjawaayopo. Iwinjaposawɨ ko nyangi nanyamasi wɨndɨ namuto tɨwɨ nɨwisapuwɨtotɨwiyawaapo. ");
INSERT INTO agm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Saiwɨ nɨwisapuhauhɨhandɨ kandɨ ko Jisaasiho kiyai saundataase. “Autaahaatɨho isɨhiyai iwinjaatɨ bimindɨhandapɨha pɨwɨha gaaha wanɨha aunahɨpatɨ wiwaarahimaawɨ daindɨ ausaatɨ kaitaano amɨ sɨkatɨ otɨpɨpatɨ kaitandɨ nɨngi Autaahaatɨho natanoaasihɨ napɨtɨhonɨniso,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aihɨ yapɨpatɨ Judiyaahandamɨ aŋɨ gwɨharaahaiwa Judaahiya Autaahaatɨhopɨ gwɨnyaapɨ gaapundɨtaatɨwɨ ahoyanohɨwaiwaatɨhɨ nahatewaapɨhɨ nandaatɨ pɨwɨha kɨhapɨhɨ kɨhapɨhɨ Jisaasiho ausaatɨ isɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Asisɨha waara Jisaasiho durɨhɨrɨ Genesaaretɨhandamɨ aripataatɨhɨ bitosɨhɨ isɨhiya wɨrɨsandɨhandɨ Autaahaatɨhomɨ pɨwɨha atitaatɨwɨ koai nepɨ uwɨhipɨ detɨ detɨ niyawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aihɨ kopuhurɨ yahurɨ gwɨharaahurɨ sɨrɨ duriramɨ mangɨrainɨ aripataatɨhɨ ahotihɨ Jisaas jatɨ mmonataise. Surɨ kopusuramɨ satoya araiho nohoyɨhiyɨhiya kapɨhɨ ahiyawosawɨ ikɨhaiwa bausawɨ taawɨ tɨwɨhaapɨ nemahauhɨ. ");
INSERT INTO agm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Surɨ kopusuramɨ wotɨ Jisaasiho nasaamanatɨ bindataise. So kopuso Jisaasiho nasaamanatɨ bimiso Saimonɨhomɨhore. Aihɨ Saimonɨho koai Jisaasiho kaundihɨ Saimonɨho kopuho netɨ durɨhɨraatɨhɨ masɨhonjɨ onɨhiwatosataise. Aihɨ Jisaasiho durɨhɨraatɨhɨ kopuhotɨ bindata isɨhiya wɨrisandɨhandi pɨwɨha kataunjataise. ");
INSERT INTO agm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jisaasiho kiyai pɨwɨha kataunja aimɨ owetihɨ Saimonɨhoai saundataase. “Kinyɨ kopuho kɨmo nesi numbwɨ durɨhɨrɨ tongɨtimbɨpɨhɨ ndɨhoaapɨhɨ ahiyaposapɨ ikɨhaiwa araiho kɨpwɨndandɨhaiwa tɨmape araiho ikɨhaiwopɨ kɨpwɨnɨhonɨhɨ noaitaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sata kaundihɨ amɨ Saimonɨhomɨha wihoaaŋɨha sata Jisaasihoai kaundataase. “Awaisɨhoŋe, wanɨ apatɨhɨ nyahɨ araiho wo noaitotaatɨ ikɨhaiwa nehɨhandɨ tɨmawa kaimɨ niyonɨhɨ nehɨhandɨ bonyawataise. Isɨ kɨnyɨ katapanɨ gaasɨ nɨnɨ ikihɨ durɨhɨraatɨhɨ tɨmaitaano,” undataase ");
INSERT INTO agm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Saiwɨ kiya ikɨhaiwa durɨhɨraatɨhɨ tɨmɨhauhɨ araiho pɨhɨtatɨ taahɨho ikihopɨ sanotɨ kɨpwɨnatɨ tisaitataatɨ ikihɨ norɨpaitaahiyataise. ");
INSERT INTO agm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Saihɨ namapɨ kiya sasaahoya kopuho wotɨ bimohiyɨhiyai andɨtinyaipɨ nyamapa nyaiwɨta napɨwɨse undɨwɨ tiwɨmawaayopo. Aihɨ kiya napɨwɨ araiho niyaapɨ kopuho maiwotɨ ahiyawaayopo. Ahiyauhɨ kopuhurɨ maisahurɨ araihopɨ naaŋata daahɨ nesi nawatitaahiyataise. ");
INSERT INTO agm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aihɨ Saimonɨ Pitaaho sandɨ mmonataatɨ Jisaasihomɨ utatototɨ auhɨraapɨhɨ tɨmahiya bindata Jisaasihoai saundataase. “Awaisɨhoŋe, nɨnɨ apɨpaahɨ maipɨhaiwaisahonɨnisɨ nanɨmɨhamapɨ numwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kɨmandɨ Sata Pitaaho kaundindɨmandɨ apaapɨmaahe, amɨ Jisaasihomɨ pɨwɨhetɨ araiho saiwa pɨhɨtɨwɨ kiya nowaawɨ kandapɨ komɨ maarɨho owesoetihɨse. Kaihɨ amɨ kapɨhɨ bitohohiyɨhiya komɨhiyaisangi naasɨkatɨ kiyatɨ maarɨho owesoendaise. ");
INSERT INTO agm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kaihɨ amɨ Sepetihomɨ mwaahurɨ Jemɨsiyɨ Joniya Saimonɨhomɨ naisururisɨ amɨ kurisangi sandɨ mmonama kuramɨ maarɨho owesoendaise. Aihɨ Jisaasiho Saimonɨhoai saundataase. “Sandapɨ kɨnyɨ yaimbɨ kinyɨ maarɨho owemaasetane. Owe. Wanɨ kɨmuraapɨ kɨnyɨ namasapɨ isɨhiya nɨngisenda napɨtaatɨwɨ taawɨ nasohiyɨhiyai saimbɨ numwaitaapɨhoŋe,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kaihɨ kiya kiyaamɨ kopuhaurɨ nesi naiwɨ durɨhɨramɨ mangɨrainɨ aripataatɨhɨ ahiyawaayopo. Aiwɨ kiyaamɨhapa kahapaamapɨpa nahataapa namɨhamapɨ koai nɨwipinjawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Asisɨha waara Jisaasiho aunahɨpatɨ taunɨhandɨ wɨtaahɨ bindataise. Bimihɨ utaaho wo komɨ ambɨpatɨ nahatepɨ asaaha pisapɨpaahɨtaho satɨ aunahɨpatɨ taunɨnda bindataise. Isɨ ko asaaha pisapɨpaisaho Jisaasihoai usonatosatɨ Jisaasihomɨ utatototɨ komɨ ndɨmaahomwaagɨ yapɨpatetɨmatɨ tɨmahiya atotɨpɨwesatɨ bindataatɨ Jisaasihoai sata nunjenataise. “Awaisɨhoŋe, kɨnyɨ nisɨ asaaha pisapɨmba tɨwɨhaapɨ nepɨnɨmaitaapɨ ganaahɨ nepɨnɨmape, noaipatɨ gaahonɨnɨtɨtaano?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aihɨ Jisaasiho komɨ ikwɨrɨ mbatɨ ambɨpatetɨ numwɨhatatɨ koai saundataase. “Ye nɨnɨ nge. Isɨ kɨnyɨ gaahoŋimate,” undataase. Sata kaundihɨ ketɨ kuraanɨhɨ komɨ asaaha pisapɨpa owendaise. ");
INSERT INTO agm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aihɨ koaisɨ Jisaasiho sata kaundataase. “Kɨnyɨ isɨhiya usaisɨ kɨmandɨ nɨnɨ gisɨ kahisotɨmandapɨ apɨpaahɨ wɨndɨ kamundɨmape. Owe. Kɨnyɨ nehɨ tɨtɨhɨ numbwɨ isɨhiyaamɨ maipɨhaiwaapɨ nandapa tɨhatɨ Autaahaatɨhoai dɨpumasɨho pɨrisihoaapɨhɨ ko gi gisonda noaipapɨ nunje. Aimbɨ Mosesiho pɨwɨha wɨnɨhapɨpa katatɨ ahairɨhɨretɨ japepihɨrɨpɨ kinyɨ asaaha pisapɨpa owetindɨhandapɨ nandapa wapa nepɨ Autaahaatɨhoai nandapa tɨhatɨ dɨpumasɨhoai nunye ko kinyapɨ nandapa tɨhonɨhɨ Autaahaatɨhoai dɨpumanɨtando. Saimbɨ kaisamɨhɨ isɨhiya gisonawa komɨ asaaha pisapɨpa aimɨ owesoendaise tɨwɨ gi gisonɨwɨ gwɨnyaitaatɨwo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sata Jisaasiho kaundihɨhandɨ kandɨ pɨwɨha komɨ kaiwaiwaapɨha isɨhiya nahatiya kanɨwɨ gaamatawaayopo. Aiwɨ isɨhiya atisawaawɨ isɨhiya taahɨhandɨ Jisaasihomɨ pɨwɨha atitaatɨwunɨ amɨ kiyaamɨ timbɨpa asaaha nemwaitandunɨ koaapɨhɨ pɨhɨtɨwɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Saiwɨ isɨhiya koaapɨhɨ pɨhɨtɨwɨ nasauhɨhandɨ kandɨ Jisaasiho pɨhɨtahaiwetɨ notɨ isɨhiya oweta watɨminahapɨhɨ Autaahaatɨhopɨ gaapundatoaandaise. ");
INSERT INTO agm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Asisɨha waara Jisaasiho isɨhiyai kataunjataise. Aihɨ sura isɨhiya usa Parisihiyaatihɨ amɨ Isɨhiya usa Judaahiyaamɨ wɨnɨhapɨpa Katɨwunjohiyɨhiyaatihɨ sapɨhɨ bindawaayopo. Isiya siya yapɨpatɨ Garirihandamɨ aunahɨpatɨ taunɨhaiwa nahatewaaraahapunɨ amɨ Judiyaahandaahapunɨ amɨ Jerusaremɨhandaahapunɨ napɨwɨhiyaare. Iyataatɨ Awaisɨho Autaahaatɨho Jisaasihoai isɨhiyaamɨ timbɨpa nemwaitandɨ watɨpɨhandɨ nunyataise. ");
INSERT INTO agm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aihɨ isɨhiya usa utaaho wo ikwauhɨrɨ bɨwatetɨ namɨhatahoai gwɨtɨhotɨ ahiyawɨ isɨsi mɨhatɨhɨ aŋɨtɨtɨhɨ nandaapɨ Jisaasihomɨ ndɨhetɨ ahaitotɨwɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Saiwɨ nesi mɨhatɨhɨ nandaito tɨwɨ mmonawa isɨhiya aŋɨtɨtɨhɨ ditɨwɨmawaawɨ daihɨra nandaitɨhɨra apɨpaahɨ owetihɨ namapɨ kiya utaahoai isɨsi aŋaaŋamɨ aŋɨtaupataasɨnɨ nasaamanawaayopo. Nasaamanɨwɨ aŋɨtaupatɨ nawɨtaposawɨ utaahoai wɨrɨhɨretɨ wɨrapɨ isɨhiya ahoyanɨhohiyɨhiyaamɨ otɨhaatɨ Jisaasiho mandosatɨ bitosɨpɨpɨhɨ mɨhatɨhɨ aŋɨtɨtɨhɨ nusoaasawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Isɨhiya utaahoai isɨsi nasohiyɨhiya utaaho kɨmoai Jisaasiho nga tɨtɨhemwaitaise tɨwɨ gwɨnyaahohɨtɨhandɨ Jisaasiho usonataise. Usonataatɨ ko ikwauhɨrɨ bɨwatetɨ namɨhatisɨhoai saundataase. “Naisohoŋe, kinyɨ maipɨhaiwa aimɨ nɨnɨ nehɨmataayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Saundatɨ Jisaasiho koai kaundihɨ isɨhiya Parisihiyaunɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ atisawaawɨ kiyaamɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhapɨ saiwɨ gwɨnyaawaapo. “Utaamo kɨmo Autaahaatɨhomɨ aunahɨpatɨ netɨ Autaahaatɨhoematatɨ amɨ Autaahaatɨhopɨ ko sisɨpɨhɨndaasɨ amɨ ko napitetatɨ diyaamahondaatɨse? Amɨ utaaho wo isɨhiyaamɨ maipɨhaiwa nga nemwaitandɨho owe nehɨ Autaahaatɨho sawaho naasohɨhɨ isɨhiyaamɨ maipɨhaiwa nga nemwahore,” tɨwɨ gwɨnyaawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kiyaamɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhapɨ saiwɨ gwɨnyaahohɨwaiwa Jisaasiho usonataatɨ kiyai sata nunjenataise. “Samɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhapɨ saiwa napaapɨ saiwɨ gwɨnyaahopo? ");
INSERT INTO agm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kɨmairɨ Pɨwaamairamɨ maahaanɨhɨ usaayahaare? Nɨnɨ satɨtandɨhaaro? Kinyɨ maipɨhaiwa nehɨmataayo totɨmaaro e kɨnyɨ nepasi numwe undɨtandɨhaaro? O amɨ nɨnɨ utaamo kɨmoai kɨnyɨ dosi numwe undɨtandɨ naaŋataatɨ amɨ nɨnɨ koai saundɨtɨ nɨnɨ kinyɨ maipɨhaiwa nehɨmataayo undɨtandɨ usaayataise. ");
INSERT INTO agm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Iyataatɨ amɨ sahɨ nisapɨ satɨwɨ Isɨhiyaamɨ Awaisɨho Saaho Jɨho isɨhiya yapɨpatambɨhiyaamɨ maipɨhaiwa nemwaitandɨ watɨpɨhandisahoe tɨwɨ sahɨ mmonɨwɨ gwɨnyaitaatɨwɨ ninjatɨwɨse,” undataase. Saundatosatɨ utaaho ikwauhɨrɨ bɨwatetɨ namɨhatisɨhoai saundataase. “Nɨnɨ gi kahɨtataatonɨ kɨnyɨ nepapɨ kinyɨ yutɨhɨrɨ gwaumbwɨ nanopotingɨrɨhɨrɨ nawopɨ isɨsi kinyɨ aŋɨpɨpɨhapɨ numwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sata kaundihɨ ketɨ kuraanɨhɨ ko isɨhiya nahatiyaamɨ ndɨhetɨ tɨtɨhɨ dotɨ komɨhapa gwaapotɨ nanototimbɨpa netɨ isɨsi Autaahaatɨhopɨ maaritatɨ Koai mepɨ autaahemwatɨ nuwimaapɨ komɨ aŋɨpɨpɨhapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aihɨ isɨhiya nahatiya sandɨ mmonawaawɨ kiyaamɨ maarɨho owesoetihɨ Autaahaatɨhomɨ ambɨpatɨ mepɨ autaahepumawaayopo. Siyatɨ kiyaamɨ maarɨho owesoetihɨ kiya satawaatopo. Kɨmandɨ wanɨhandɨ wɨndɨ siyahandɨ jɨhɨ namoaipasɨhɨ mmonaahiyaanɨnisɨ nehɨ wanɨ kɨmandɨ wanɨhandɨ noaipasɨhɨ mmonahaayo tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sandɨ aimɨ owetihɨ Jisaasiho notɨ mmonata utaaho wo Romɨhanda Gamanɨhomɨ otɨpɨpatɨ kaitandɨho nawɨho taakisihandɨ nesɨho aŋɨhandɨ nawɨho nehotɨhandaatɨhɨ bimihɨ usonataise, komɨ ambɨpatɨ Ripaiho. Usonataatɨ koai Jisaasiho saundataase. “Kɨnyɨ nɨngi nanipinje,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aihɨ ko Ripaiho komɨhapa nahataapa ahotihɨ namɨhaamapɨ dosi Jisaasihoai nuwipinjataise. ");
INSERT INTO agm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kaihɨ Ripaiho komɨ aŋɨpɨpɨhɨ Jisaasihopɨ nandapa aungwohandɨ tahataise. Siyatɨ ko nandapa tɨhihɨ isɨhiya taahiyɨhiya Ripaihomataiwɨ nawɨho taakisihandɨ nehohiyɨhiyaatihɨ amɨ isɨhiya usaimaawɨ kurisawɨ bindawa nandapa maasɨ nanawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Saiwɨ nanahauhɨhandɨ kandɨ Parisihiyaunɨ amɨ isɨhiya usa Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiya Jisaasihomɨ otɨpɨpatɨhiyai saundawaatopo. “Sahɨ isɨhiya maipɨhiyaisawɨ nandapa waapoho maasɨ napaapɨ nanɨhopo?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Saundauhɨ Jisaasiho kiyaamɨ katohɨhaapɨ wihoaaŋɨha kiyai saundataase. “Isɨhiya timbɨpa owehiya ainahiyɨhiya dokɨtaahoaapɨhɨ nowaamaayopo. Owetise. Nehɨ isɨhiya timbɨpaisahiyaahɨhɨ dokɨtaahoaapɨhɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Isɨhiya maipɨhaiwa owehiya ainahiyɨhiya japɨhɨ nepemaitɨtaatɨwɨ nɨnɨ gandɨ numwaitandɨ napɨtɨhonɨnɨmaahe. Owe. Isɨhiya apɨpaahɨ maipɨhaiwa kaiwɨ maipɨhaiwaisahiyai kiyaamɨ maipɨhaiwa namasi japɨhɨ nepemaitɨtaatɨwɨ nɨnɨ gandɨ numwaitandɨ napɨtɨhonɨne,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aihɨ kiya Jisaasihoai satɨwɨ kaundawaayopo. “Isɨhiya Jonɨhomɨ otɨpɨpatɨhiya taahɨwaiwetɨ nandapa waapoho namaanɨwɨ onaiwɨ bindawa Autaahaatɨhopɨ gaapundawaayopo. Aihɨ amɨ Parisihiyaamɨ otɨpɨpatɨhiyaisangi naasɨkatɨ kaiwɨ nandapa onaiwɨ Autaahaatɨhopɨ gaapundawaayopo. Kiya saiwɨ kiyauhɨhandɨ kandɨ kinyɨ otɨpɨpatɨmiya katɨ kamaiwɨ nandapa waapoho kiyaanɨhɨ nanɨmɨ nowaayopo,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Saundauhɨ Jisaasiho komɨha wihoaaŋɨha kiyai sata kaundataase. “Namaatɨtandɨ tɨmetisɨho wometɨtandɨ jɨhɨ komɨ naisɨhiyaisatɨ maasɨ bimonɨhɨ sahɨ komɨ naisɨhiyai nga saundɨwɨ, ‘sahɨ nandapa waapoho namaanɨwɨ onaiwɨse,’ undɨtaawo? O amɨ sandɨhɨ owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Iyataatɨ so namaatɨtandɨ tɨmetisɨhoai komɨhiyaamɨhatɨhapɨ nepɨ yandɨhemaitaapo. Saiwɨ nepɨ yandɨhemasaihɨ sura asisiwetɨ komɨ naisɨhiya nandapa waapoho namaanɨwɨ onaitaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iyatɨ Jisaasiho amɨ pɨwɨha wa kɨma sɨwipatɨ namɨhanaha sata kiyai kaundataase. “Utaaho wo yutɨhɨrɨ asɨrɨhɨramɨ wonjɨ maipɨhonjɨ namandipatɨ netɨ nesotɨ yutɨhɨrɨ jahɨrɨhɨrɨ napwɨrinjonyosaapɨhɨ ahiyatɨ namahɨwatɨ wɨndɨ ngɨmundaise. O amɨ utaaho wo siyatɨ kiyataataahɨ yutɨhɨrɨ asɨrɨhɨrɨ netɨ nopɨsasɨtaise. Iyataatɨ amɨ asɨrɨhɨramɨ masɨhonjɨ namandipatɨ nesonyonjɨ sonjɨ yutɨhɨrɨ jahɨrɨhɨrisatɨ gwɨnataataahɨ wɨndɨ nasɨkameta wipetɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Iyataatɨ amɨ waapoho wainɨhandɨ asɨtɨhandɨ utaaho wo netɨ wipatɨ jahɨpatɨ aimɨ pusatɨ namasaatahatopɨ nuhaatɨ wɨmiwɨtaise. O amɨ utaaho wo siyatɨ kiyataataahɨ wipatɨ pusatɨ namisaatahatisɨ namasaatimbɨpɨhapɨ kɨpwɨratɨ yapɨpatetɨ nuhoaandɨwa sanutaise. Iyonɨhɨ amɨ wipatisangi nosasɨnatɨ namasaatatɨ owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Waapoho wainɨhandɨ asɨtɨhandɨ wipatɨ asɨpatɨ gaahata nuhoaapɨ wiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Utaaho wo waapoho wainɨhandɨ jahɨtɨhandɨ nanataataahɨ wainɨhandɨ asɨtɨhandɨ wɨndɨ namandaise. Iyatɨ ko satɨtaise. Waapoho wainɨhandɨ jahɨtɨhandɨ gaahande tɨtaise,” undatɨ Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Judaahiyaamɨ asisɨha ikɨnohɨha Sapaatɨhandɨ wɨndetɨ Jisaasiho konɨho witɨhandamɨ osaataatɨhɨra daimɨ notaise. Naihɨ komɨ otɨpɨpatɨhiya ko kaiwaiwa mmonɨwɨ nepɨ kaiwɨ nɨwipinjohiyɨhiya konɨho witɨhandɨ ikwɨra nasɨpapɨ yutɨhɨrɨ pasaaha ikwɨra ikɨsipɨ tɨwɨhaapɨ akonyonya nanawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aiwɨ kiya nanahauhɨ isɨhiya Parisihiya usa kiyai iwinjawaawɨ saundawaatopo. “Sahɨ asisɨha Sapaatɨhandetɨ kamaayohɨpɨpa kaiwɨ napaapɨ saiwɨ kiyopo?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Saundauhɨ Jisaasiho wihoaaŋɨha kiyai sata kaundataase. “Jɨhura Daawitɨhounɨ amɨ komɨhiyaunɨ jaumasɨhɨ kiyohɨtɨhandapɨ sahɨ ka pɨwɨha wɨndɨ awɨmɨtɨwɨhiyaato? ");
INSERT INTO agm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daawitɨho Autaahaatɨhomɨ Aŋɨhandaatɨhɨ nandaatɨ nandapa bɨretɨhandɨ Autaahaatɨhomɨ ndɨhetɨ ahotisɨha netaise. Sapa nandapa bɨretɨhandɨ pɨrisihiya isɨhiyaamɨ maipɨhaiwaapɨ nandapa kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaahɨhɨ nandaatɨwɨhape tatɨ wɨnɨhapɨpa ahotihɨhandɨ kandɨ Daawitɨho netɨ nanatɨ amɨ komɨhiyai wapa numwihɨ nanawaayopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iyatɨ amɨ Jisaasiho pɨwɨha wa saundataase. “Nɨnɨ Isɨhiyaamɨ Awaisɨhonɨnɨ Saahonɨnɨ Jɨhonɨnɨ Sapaatɨhandamɨ awaisɨhonɨnisɨ kandisɨ nɨnɨ jatataatɨ kandetɨ wapa gaahapa isɨhiya kaitaatɨwɨhapa nɨnɨ gwɨnyaatɨ katisanɨhɨ kapa kaitaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Aihɨ amɨ Sapaatɨhandɨ wɨndetɨ Jisaasiho niyatɨ aŋɨ gwɨharaahandɨ Judaahiya Autaahaatɨhopɨ gwɨnyaapɨ gaapundɨtaatɨwɨ ahoyanohɨpɨpɨhɨ nandaatɨ isɨhiyai pɨwɨha kataunjataise. Aihɨ sura sapɨhɨ utaaho wo komɨ ikwɨrɨ bɨwatetɨ namɨhataho bindataise. ");
INSERT INTO agm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aihɨ isɨhiya Parisihiyaunɨ amɨ isɨhiya usa Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ Jisaasihoai kɨnyɨ maipɨhandɨ kiyapaise undɨwɨ komɨhetɨ pɨwɨha nutandɨhandapɨ koai iwinjatawaayopo. Iwinjatawa so utaaso ikwɨrɨ bɨwatetɨ namɨhatisoai Sapaatɨhandetɨ netɨ tɨtɨhemwaso tɨwɨ komɨhetɨ ndɨha ahiyawɨ iwinjatawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kiya saiwɨ gwɨnyaapɨ iwinjasauhɨhandɨ kandɨ Jisaasihohɨ kiyaamɨ saiwɨ gwɨnyaapɨ iwinjatohɨtɨhandɨ usonatɨ netaise. Usonatosatɨ ikwɨrɨ bɨwatetɨ namɨhatisɨhoai Jisaasiho saundataase. “Kɨnyɨ dopɨ isɨhiyaamɨ ndɨhetɨ sapɨhɨ bitose,” undataase. Saundihɨ ko tɨtɨhɨ dotɨ kapɨhɨ bitondaise. ");
INSERT INTO agm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Bitosɨhɨ amɨ kiyai Jisaasiho saundataase. “Nɨnɨ sangi sandɨ nasɨsendaano. Sapaatɨhandetapɨ wɨnɨhapɨpa ahotimbɨpa napondaase? Nyahɨ Sapaatɨhandetɨ gaahaiwa isɨhiyai iwɨtatamanaatɨ kaitɨhaawo e isɨhiyai newa nusopɨsasaatɨ mɨmaipɨwitɨhaawɨ nyamɨ wɨnɨhapɨpa kandaaso? Isɨhiya baiwɨ bimɨtaatɨwɨhandapɨ nyahɨ iwɨtatamanɨtɨhaawo e newa kiyai nusopɨsasɨtɨhaawo?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Saundatosatɨ isɨhiya nahatiyai naingaatɨ iwinjatataatɨ ko ikwɨrɨ bɨwatesɨhoai saundataase. “Kinyɨ ikwɨrɨ mbape,” undataase. Undihɨ ko komɨ ikwɨrɨ mbasɨhɨ ketɨ kuraanɨhɨ noaipatɨ gaahɨrɨ sawanyɨnjapɨhɨrɨndaise. ");
INSERT INTO agm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Siyatɨ Jisaasiho kaindɨmandapɨ kiyai apɨpaahɨ apousamasɨhɨ kiya nyahɨ Jisaasihoai napitɨwitɨhaawe tɨwɨ Jisaasihoai kiya wapa kawitaatɨwɨhapaapɨ sawana kanawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aihɨ sura asisɨha waara apatɨhɨ sɨhoaarɨhɨretɨ Jisaasiho kapɨhɨ gaapundɨtandɨ nasaamanataise. Nasaamanatɨ kapɨhɨ Autaahaatɨhoai pɨwaundatɨ konɨhɨ gaapundɨmɨ naihɨ notɨ bourɨwataise. ");
INSERT INTO agm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bourɨwihɨ komɨ otɨpɨpatɨhiya nahatiyai gaatatɨ numwaatɨ koaisawɨ maasɨ nasisoaarɨ daiwɨ bimɨtaatɨwɨhiya awɨtahiya ikwɨmaindɨmwɨtihɨ auhɨramɨ yahurɨtahiyai namɨhanatɨ numwaataise. Iyatɨ kiyai ambɨpatɨ wɨtɨ sata nusoaasataise. Nɨnɨ sangi nisɨ watɨpɨhandisatɨ nandɨsɨsoaasisanɨhɨ sahɨ nisɨ pɨwɨha anusoaitaatɨwɨhiyaate undatɨ ambɨpatɨ aposerɨhiyaate undatɨ nusoaasatɨ ambɨhundataase. ");
INSERT INTO agm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jisaasiho namɨhanatɨ numwaatɨ aposerɨhiyaate undisawɨhiya kɨmiyaare: Wo Saimonɨhore. Komɨ ambɨpatɨ wɨtɨ Jisaasiho nusoaasipatɨ Pitaahore. Aihɨ amɨ Saimonɨhomɨ saingɨho Andɨruhotihɨ Jemɨsihotihɨ Jonɨhotihɨ Piripɨhotihɨ Batoromiyuhotihɨ ");
INSERT INTO agm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyuhotihɨ Tomaasihotihɨ Jemɨsiho Arɨpiyaasihomɨ mwaahotihɨ Saimonɨho komɨ ambɨpatɨ wɨtɨ Serotɨhoe tɨwɨ ambɨhundɨwɨhosɨ kotihɨ amɨ ");
INSERT INTO agm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judaasiho Jemɨsihomɨ mwaahotihɨ amɨ Judaasiho aunahɨpatɨ Keriyotɨhandaahapɨho Jisaasihoai tiwɨtaatɨwɨhiya tiworisaamɨ ikwɨraatɨhɨmasɨhotihɨ siyaare. ");
INSERT INTO agm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Aihɨ Jisaasiho tipatɨ sɨhoaarɨhɨretɨ namasi kiya Aposerɨhiyaisatɨ maasɨ noaatɨpatɨ yatɨhɨ gaahapɨhɨ sahananaata komɨ otɨpɨpatɨhiya tɨtaahɨtɨhandisatɨ maasɨ bitondaise. Aihɨ amɨ sapɨhɨ taahɨtɨhandɨ bitotawaayopo. Iyataatɨ siya isiya aunahɨpa nahataapɨpɨhapɨ napɨwɨhiyaare. Iyataatɨ kiya yapɨpatɨ Judiyaahandamɨ nahataapɨpɨhapɨhiyaunɨ amɨ taunɨhandɨ awaindɨhandɨ Jerusaremɨhandaahapɨhiyaunɨ amɨ aunahɨpa taunɨhaurɨ detɨ durɨhɨrainɨ ahetiwaurɨ Taiyaahandunɨ Saitonɨhandaapɨhiyaunɨ napɨwɨ sapɨhɨ bindawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Siya kaanɨhapɨ nasohiyɨya Jisaasihomɨ pɨwɨha atɨwitaatɨwunɨ amɨ kiyaamɨ timbɨpa nemwaitandɨ napɨwɨhiyaare. Kiyaamɨ usaamɨhetɨ itɨpɨho maipɨhapa bindata netɨ ambɨpatɨ nusopɨsasimbɨpa nemwatɨ tɨtɨhemwataise. ");
INSERT INTO agm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aihɨ amɨ isɨhiya nahatiya Jisaasihoai uwipɨ numwɨhatɨtaatɨwiyawaayopo. Sandɨ apaapɨmaahe isɨhiya usa koai uwipɨ numwɨhatohiyɨhiyaamɨ timbɨpa komɨ watɨpɨhandɨ awaindɨhandɨ komɨhetapɨ noaipasi sanotɨ nemwasɨhɨ biyatɨ gaawimatihe. ");
INSERT INTO agm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisaasiho komɨ otɨpɨpatɨhiyai naingaatɨ iwinjatataatɨ pɨwɨha sata kandaase. “Sahɨ isɨhiyaatɨ kahapaamapɨpa owehiyaatɨ satɨwɨ nyahɨ kahapaamapɨpa gaatahiyaane tɨwɨ pɨhɨtɨwɨ maaritɨwɨse. Amɨ sangi Autaahaatɨho komɨ isɨhiyaisatɨ ahoyatɨ aimɨ sangi jainjatataiso. ");
INSERT INTO agm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Sahɨ wanɨ jasamasɨhɨ jarisohiyɨhiyaatɨ waatɨ maaritɨwɨse amɨ ipotɨhura Autaahaatɨho sangi nandapa pɨhɨtatɨ tisaahɨwatɨ nasanyonɨhɨ tisaipɨ nga nepɨ nanɨwɨ gwɨsɨmwɨtaawo. “Aiwɨ amɨ sahɨ wanɨ taawɨ ngohiyɨhiyaatɨ waatɨ maaritɨwɨse amɨ ipotɨhura sangi Autaahaatɨho maaritɨtaatɨwɨhandɨ nasanyonɨhɨ samɨ maarɨhoaatɨhapɨ maaritɨwɨ sisɨtaawo. ");
INSERT INTO agm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nɨnɨ Isɨhiyaamɨ Awaisɨhonɨnɨ Saahonɨnɨ Jɨhonɨhi sahɨ nanipinjawɨ nisɨ otɨpɨpatɨ kaniwɨ nisɨhiyaatimatisaihɨ nisapɨsatɨwɨ isɨhiya ipotɨhura sangi jasonawaawɨ mandɨtisaipɨ mɨmaipɨsiwɨ amɨ pohipɨsiwɨ maahoaipupwɨsamapɨ amɨ pɨwɨha maipɨhaiwa kasatɨwɨ samɨ ambɨpatɨ nausohaapɨ ahoaapɨ asɨretɨ ambɨhɨsatisaihɨ amɨ gaasɨ sahɨ maaritɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Isɨhiya saiwa saiwɨ sangi kasisaihɨhandɨ kandɨ sahɨ gaasɨ waatɨ maaritɨwɨ naupwananɨwɨse kandapɨ wihoaaŋɨhandɨ apɨpaahɨ awaindɨhandɨ sangi yamahapataatɨhɨ Autaahaatɨho ipotɨhura nasamɨtandɨ taatetɨ tisamanataiso. Amɨ jɨhuraisangi kiyaamɨ satoya sapiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaapɨ katohiyɨhiyai naasɨkatɨ kawiwɨhiyaaso. ");
INSERT INTO agm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Amɨ sahɨ nawɨho kahapaamapɨpa asaketahiyaatɨ jaawo samɨ maarɨho biyatɨ wisaitahapa aimɨ nepɨ isɨwatawaayowo. Iyataatɨ amɨ nehɨ sapa kapaanɨhɨ sahɨ wanɨ newaayowo. ");
INSERT INTO agm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Sahɨ isɨhiyaatɨ wanɨ nandapa waatɨ nanɨwɨ gwɨsɨmohiyɨhiyaate, sahɨ jaawo ipotɨhura pɨhɨtatɨ jasamanɨtaiso. “Sahɨ isɨhiyaatɨ wanɨ sisɨwɨ maaritohiyɨhiyaate sahɨ jaawo amɨ ipotɨhura sahɨ gwɨwɨ kwɨtipatɨ tisamɨhaitaiso. ");
INSERT INTO agm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Sahɨ isɨhiya usa sapɨ maarɨsaitɨwɨ mepɨ autaahepɨsamahohiyɨhiyaate sahɨ jaawo. Jɨhuraisangi isɨhiya pɨwɨha jaiwɨtaha ausaahohiyɨhiya siyaamɨ satoya sapiya kiyaapɨ maaritɨwɨ kiyai nepɨ mepɨ autaahepumapɨhiyaaso,” daase. ");
INSERT INTO agm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Saiwa satatɨ Jisaasiho katatɨ owetihɨ kiyai saundataase. “Amɨ sahɨ nisɨ pɨwɨha atɨnisohiyɨhiyaatangi sandɨ kasatataato. Sahɨ samɨ tiworisai maarɨho nunyawɨse. Aiwɨ isɨhiya sangi mandɨtɨsisohiyɨhiyai gaahatɨ kawiwɨse. ");
INSERT INTO agm_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aiwɨ isɨhiya sangi samɨ maarɨho nasosasɨnahaiwa pɨwɨha kasatɨwɨ amɨ sapɨ satɨwɨ kiyai wapa maipɨhapa nusoaipatɨ netɨ nusopɨsasane tohiyɨhiyai wihoaaŋɨ gaahatɨ kawiwɨse. Aiwɨ amɨ isɨhiya sangi mɨmaipɨsisohiyɨhiyaapɨ kiyai Autaahaatɨho maarɨho asɨpɨwisatɨ gaahandɨ kawita sahɨ kiyaapɨ gaapɨwundɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Amɨ utaaho wo kinyɨ pahaapɨpatɨ wɨtɨ tɨngɨwihonaahɨ amɨ wihoaaŋɨhatimaawɨ tɨngɨwihɨwɨta nepemaitɨpɨ koai nunye. Iyatɨ amɨ utaaho wo kinyɨ apotɨhɨrɨ tiwatɨhaatɨhɨrɨ mbɨpaapɨ nipaatingɨrɨhɨrɨ nehonaahɨ gaasɨ amɨ apotɨhɨrɨ nyepepɨ nipaatingɨrɨhɨri maawɨ owe mundɨpɨ nehɨ nanɨhaimbɨ nunye. ");
INSERT INTO agm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Isɨhiya nahatiya sangi wapaapɨ nanyinyawɨse satɨwɨ nasɨsenohiyɨhiyai kapa nasɨsenohɨpɨpa sahɨ nunyawɨse. Aiwɨ amɨ isɨhiya usa samapa wapa nasesaihaahɨ kiyai kapa japɨhɨ nanyinyawɨse undɨwɨ mwɨtetɨwɨ wɨndɨ kamundɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sahɨ satɨwɨ isɨhiya usa nyangi gaahatɨ kanyitotɨwɨ gwɨnyaawaawaahɨ satɨ sahɨ gwɨnyaahohɨpatamataiwɨ isɨhiya usai gaahatɨ sahɨ kawiwɨse. ");
INSERT INTO agm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Iyataatɨ amɨ sahɨ isɨhiya sangi maarɨho nasanyohiyɨhiyaisaahɨhɨ japepinjawɨ maarɨho kiyai wihoaaŋɨ nunyawaawaahɨ amɨ kandapɨ wihoaaŋɨhandɨ napindɨ naitaatɨwe, amɨ isɨhiya maipɨhaiwaisahiyaisangi naasɨkatɨ kaiwɨ maarɨho nunyohiyɨhiyaisaahɨhɨ maarɨho wihoaaŋɨ nunyawɨhiyaaso. ");
INSERT INTO agm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Amɨ sahɨ isɨhiya sangi gaahatɨ kasisohiyɨhiyaisaahɨhɨ wihoaaŋɨ gaahatɨ kawisawaawaahɨ kandapɨ wihoaaŋɨhandɨ napindɨ sahɨ naitaatɨwe amɨ isɨhiya maipɨhandisawɨhiyaisangi naasɨkatɨ kaiwɨ wihɨwihoaaŋɨ gaahatɨ kainɨwɨhiyaaso ");
INSERT INTO agm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Amɨ sahɨ isɨhiyai samapa kahapaamapɨpa wapa nunyawaawɨ kiyaamapa wihoaaŋɨ tɨtɨhɨ kamwaaŋɨ nunyohɨmumwaaŋɨ nanyamɨto tɨwɨ nunyawaawaahɨ kandapɨ wihoaaŋɨhandɨ gaahandɨ napindɨ sahɨ naitaatɨwe, amɨ isɨhiya maipɨhaiwaisawɨhiya kahapaamapɨpa wapa kiyaamɨ naisɨhiya maipɨhaiwaisawɨhiyai nunyawaawɨ kiyaamapa wihoaaŋɨ kamwaaŋɨ nanyamɨtaawo tɨwɨ gwɨnyaapɨ nunyawɨhiyaaso. Sahɨ saiwɨ sandɨ kamaiwɨse. Owe. ");
INSERT INTO agm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amɨ sahɨhɨ samɨ tiworisai maarɨho nunyawɨ amɨ gaahatɨ kiyai sahɨ kawiwɨse. Aiwɨ amɨ sahɨ wapa samapa isɨhiya usai nunyawaahaapaapɨ kiyaamapa wihoaaŋɨhapa nanyamɨtaawo tɨwɨ gɨmunyaapɨse nehɨ kapaanɨhɨ nunyawɨ namapɨse. Sapa saiwɨ sahɨ kiyohɨpɨpaapɨ wihoaaŋɨhandɨ awaindɨhandɨ nepɨ kahapaamapɨpa nahataapai netɨ daahematɨ Autaahɨ Nuwaataatɨ Bimisɨhomɨ mwaayatimatɨtaatɨwo. Iyataatɨ kohɨ isɨhiya koai wɨndɨ kɨnyɨ gaahoŋe gaare mundɨwɨhiyaisunɨ amɨ isɨhiya maatɨmaatiwɨhiyaisunɨ gaahatɨ kawisahoso. ");
INSERT INTO agm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sahɨ isɨhiyaapɨ samɨ maarɨho tisatane, samɨ Japɨho isɨhiyaapɨ komɨ maarɨho tundipatamatiyato,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jisaasiho pɨwɨha wa isɨhiyai sata kataunjataise. “Sahɨ isɨhiya usaamɨ kiyohɨwaiwa ketɨ nepɨ tipɨtapaapɨ usonɨwɨ kiyai ‘sahɨ maipɨhiyaate,’ mundɨwɨse amɨ Autaahaatɨho wɨndɨ sangi netɨ tipɨtapa jasonatɨ, ‘sahɨ maipɨhiyaate,’ maasatɨtando. Aiwɨ amɨ sahɨ isɨhiya usaisɨ saundɨwɨ, ‘sahɨ maipɨhiyaatisɨ samɨ maipɨhaiwaapɨ pɨwɨha nepɨse,’ undɨwɨ kiyaamɨhetɨ pɨwɨha nepɨ yamaawutaapɨse. Amɨ sangisɨ Autaahaatɨho wɨndɨ sasatatɨ, ‘sahɨ maipɨhiyaatisɨ samɨ maipɨhandapɨ pɨwɨha nepɨse,’ satatɨ pɨwɨha samɨhetɨ netɨ wɨndɨ yamaasutaito. ");
INSERT INTO agm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Sahɨ isɨhiyai wapa kahapaamapɨpa nunyawɨse amɨ Autaahaatɨho sangi nasamɨtaiso. Amɨ sahɨ iparimatɨwɨ isɨhiyai wapa pɨhɨtɨwɨ taahɨpɨpa nunyawaawaahɨ amɨ Autaahaatɨho apɨpaahɨ gaaho iparɨhosɨ wapa kahapaamapɨpa sangi pɨhɨtatɨ taahɨpɨpa waatɨ asakiyatɨ amɨ tisaahɨwa tiwatɨ nyepiyatɨ tirandɨwatɨ amɨ kapa ahaitɨhapɨhɨ owetatɨ nawangitatɨ nehɨhaatɨ tɨmahiyahaiwa sangi nasamɨtaise. Iyatɨ Sahɨ isɨhiya usaisɨ wapa ikɨpɨpa nunyohɨmumwaaŋɨ kamwaaŋɨ Autaahaatɨho sangi japɨhɨ kapa pɨhɨtatɨ nasamɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sata kaundatosatɨ amɨ pɨwɨha wa sɨwipatɨ namɨhanaha sata Jisaasiho kiyai kaundataase. “Utaaho wo komɨ ndɨha niyotaho amɨ utaaho wo ndɨha niyotahoai daihɨra mɨre undatɨ namunjɨtaise. Owetɨtaise. Amɨ maisahurɨ ndɨha niyotahurɨsɨ maisahurɨ tɨmaamainji anɨmwaahɨpatopɨ witɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Metɨho wo taatɨ sɨkurɨhandaatɨhɨ kahapaamapɨpa kaiwunjauhɨ mmonatɨ nesɨho koai kataunjisɨhoai nusatipɨhaatɨ noaipatɨ isɨhiyaamɨ ndɨhetɨ awaisɨhondaamaise. Owetise. Koai kiyaunjisɨho kiyaunjihɨ ko metɨho bɨpi bindata atisatɨ mmonatɨ netɨ kaimɨ nunjatɨhura ko noaipatɨ komɨ kiyaunjisɨhomatetaho noaipataise. ");
INSERT INTO agm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kɨnyɨ utaaho wo kinyɨ naisohomɨ ndɨhotɨ ikwaatɨpɨho apɨpaahɨ turɨkaarehonjɨ ahusotisonyonjapɨ kɨnyɨ napaapɨ baimbɨ taapɨ waatɨ gwɨnyaapɨ usonɨhise kɨnyɨ kɨwahonyɨ ndɨhotɨ ikwaatɨpɨho aungwohandɨ ipatamatiyahandɨ ahɨsotindɨhandapɨ baimbɨ gwɨnyaapɨ monɨpiwatapaapo? ");
INSERT INTO agm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kinyɨ ndɨhotɨ ikwaatɨpɨho apɨpaahɨ aungwohandɨ ipatamatiyahandɨ ahɨngisotindɨhandɨ monɨpiwatapa wo kinyɨ naisohomɨ ndɨhotɨ ikwaatɨpɨho turɨkaarehonjɨ ahotisonyonjapɨ koai saundɨpɨ, ‘naisohonye, kinyɨ ndɨhotɨ ikwaatɨpɨhonjɨ yaihonjɨ ahɨngisotisɨ nehɨmaitaano,’ undɨpɨ napitaimbɨ kaundɨtaise? Sandɨ kɨnyɨ satɨpɨ nɨnɨ nisɨ ndɨhotɨ ikwaatɨpɨho ahɨmotahoniso tɨpɨ jaipɨtɨpe. Ikwaatɨpɨho apɨpaahɨ aungwohandɨ ipatamatiyahandɨ kinyɨ ndɨhotɨ ahɨsotindɨhandɨ kɨnyɨ kɨwahoŋɨ jatɨnɨpɨ jɨhɨ nemaposapɨ auhaatapɨ kinyɨ ndɨha baimbɨ japaapɨ sura kinyɨ naisohomɨ ndɨhotɨ ikwaatɨpɨho turɨkaarehonjɨ ahusotisonyonjɨ mmonɨpɨ nepumaitaapo,” ndaase. ");
INSERT INTO agm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Satatosatɨ Jisaasiho wa jɨhaatɨ sandaase. “Ipatɨ gaahatɨ yandɨpɨho maipɨho wɨndɨ namingoaitaise. Iyonɨhɨ amɨ ipatɨ maipɨhatɨ yandɨpɨho gaaho wɨndɨ namingoaitaise. Wɨndɨ siyatɨmaahe, owetise. ");
INSERT INTO agm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ipatɨ nahatepɨ yandɨpɨho ningosɨhura isɨhiya japɨ mmonawaawɨ ‘ipatɨ satɨ gaahate amɨ ipatɨ satɨ maipɨhate,’ tɨwɨ japɨ mmonawaayopo. Iyataatɨ ipatɨ pɨhoaipɨhomɨ yandɨpɨho anɨpɨho kaarɨhetapɨ nandawaamaayopo. Owetise. Aiwɨ amɨ wainɨhandisangi kaarɨha mwɨtoaipatetɨ ningotɨ ahotihɨ nandawaamaayopo. Owetise. ");
INSERT INTO agm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Utaaho gaahomɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhɨ amɨtɨhetɨ nehɨ gaahaiwaahɨhɨ gwɨnyaatɨ tɨwɨsaitataise. Tɨwɨsaitihɨ nehɨ tɨtɨhɨ gaahaiwaahɨhɨ gwɨnyaatɨ kiyataise. O amɨ utaaho maipɨhomɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhɨ amɨtɨhetɨ nehɨ maipɨhaiwaahɨhɨ gwɨnyaatɨ tɨwɨsaitataise. Tɨwɨsaitihɨ nehɨ maipɨhaiwaahɨhɨ gwɨnyaatɨ kiyataise. Nɨnɨ sandɨ apaapɨmaato amɨ amɨtɨhetɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhɨ saiwa wapa isɨhiya gwɨnyaapɨ kɨpwɨndimbɨpa kiyaamɨ maahomwaaŋɨ nausaapɨ katauhɨ ausaimanɨnatɨ auta noaipataise,” ndaase. ");
INSERT INTO agm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Satatosatɨ amɨ bapiyatɨ Jisaasiho sandaase: “Sahɨ nisɨ pɨwɨha sangi kasatohɨha japepihɨrɨwɨ kamaayawaahandɨ nɨngi sahɨ napaapɨ Awaisɨhoŋe, Awaisɨhoŋe ndɨwɨ ambɨhɨndopo? ");
INSERT INTO agm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Utaaho wo nɨngisaapɨhɨ nasatɨ nisɨ pɨwɨha atisatɨ nisɨ kaundohɨrɨhɨretɨ kaisɨhopɨ nɨnɨ sɨwipatɨ wɨtɨ namɨhandɨ nasisatɨ sandɨ kasatɨtaano sangi biyatɨ nasesɨpata gisunyaatɨtando. ");
INSERT INTO agm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","So utaaho kɨmomatiyahore: Ko aŋaaŋɨ aŋɨmatɨtandɨhura yapɨpatɨ watɨpɨhatɨ nawɨhaisɨhatetɨ anɨmwaahɨpatɨ baahɨ mɨhaapɨ yamwaataise. Yamwaatosatɨ yasɨha wiwatosatɨ simenɨhandɨ sanyoaayatɨ wiwatɨ yasɨha tɨpɨhaatɨ mɨhondaise. Mɨhotatosatɨ aŋaaŋɨ akaaŋaaŋɨ kasɨnapɨ watɨpɨhaaŋɨ ahominahaaŋɨ anɨtisatɨ aŋɨmatataise. Aihɨ wipatɨ itɨ nambɨtɨhɨrɨ noaipatɨ wipɨwatɨ itɨ nambɨtɨrisatɨ usepatɨ usepuwataatɨ aŋaaŋɨ netɨ ikɨpindatɨ kwɨtɨwihɨhandɨ kandɨ wɨndɨ namaayase. Sandɨ ketɨ namaayasɨtɨmandɨ amɨ utaaho itatamanatɨ biyatɨ gwɨnyaatɨ anɨtisatɨ watɨpɨhaaŋɨ aŋɨmatihe. ");
INSERT INTO agm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Iyataatɨ utaaho wo nisɨ pɨwɨha atisataaho ko nisɨ katohɨrɨhɨretɨ japepihɨratɨ kamaisɨho so utaaho aŋaaŋɨ mɨmaipiyatɨ aŋɨmatisɨhomatiyahore. Utaaho aŋaaŋamɨ yasɨha mmonainjatɨ yapɨpatɨ watɨpɨhatetɨ baahɨ anɨmwaahɨpatɨ yamwaatɨ mɨhotatɨ aŋɨmaamatatɨ yapɨpatɨ napaipatetɨ yaataatɨ mɨhotatɨ aŋɨmatihɨ wipatɨ itɨ nambɨtɨrisatɨ wipɨwataatɨ usepatɨ usepuwataatɨ aŋaaŋi netɨ kwɨtɨwatɨ ikɨpɨndihɨ ketɨ kuraanɨhɨ niyatesi tɨmahiyatɨ kaaŋɨnɨhɨ nosasɨnamasɨpatamatiyahore,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisaasiho pɨwɨha saiwa aimɨ kaundihɨ kiya aimɨ atiwɨ owetihɨ ko niyatɨ aunahɨpatɨ taunɨhandɨ Kaparɨniyaamɨhanda nandaataise. ");
INSERT INTO agm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Satɨ aunahɨpitɨ taunɨhanda utaaho wo Romɨhiyaamɨho isɨhiya tunnɨwɨ yahwɨnohiyɨhiya 100 kaiwɨhiyai jɨhimatatɨ iwinjatisɨho bindataise. Iyataatɨ ko otɨpɨpatɨho woaisahore. Aihɨ so komɨ otɨpɨpatɨhoai uta awaisɨho maarɨho apɨpaahɨ aungwohandɨ nunyamahore. Nunyamahosɨ amɨ ko timbɨpa netɨ timbiyatɨ detɨ aimɨ napwɨtandɨhandɨ ketihɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Siyatɨ bimihɨ ko tunnɨwɨ yahwɨnohiyɨhiyaamɨ awaiso isɨhiya satɨwɨ Jisaasiho yamo Kapaniyaamɨhanda napise tauhɨ atisataise. Atisataatɨ namatɨ Judaahiyaamɨ gwɨnyaahiya mɨtɨhiyai ko netɨ natausaasataise kiya nuwɨ kaundisaihɨ Jisaasiho nasatɨ komɨ otɨpɨpatɨhomɨ timbɨpa nemwaitando. ");
INSERT INTO agm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aihɨ kiya nuwɨ Jisaasihoai pɨhɨtɨwɨ waatɨ satɨwɨ nunjenawaayopo. “Kɨmo utaaho gaahosɨ kɨnyɨ komɨ pɨwɨha atɨwimbɨ andɨtɨwipe. Iyatɨ ko nyahɨ Judaahiyaanangi maarɨho nanyɨnyahore. ");
INSERT INTO agm_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Iyatɨ amɨ ko aŋɨ gwɨharaahonya Autaahaatɨhopɨ gwɨnyaawaatɨ gaapundɨtɨhaawɨ ahoyanohonya nyapɨ anɨnyamatahore,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Saundɨwɨ kaundauhɨ Jisaasiho namatɨ kiyaisatɨ maasɨ notaise. Notɨ ko uta awaisomɨ aŋɨpɨpɨhɨ Jisaasiho noaipaitaahetihɨ ko tunnɨwɨ yahwɨnohiyɨhiyaamɨ awaisɨho mɨtɨho Jisaasihopɨ komɨ naisɨhiyai sata kaunda natausaasataise. “Awaisɨhoŋe, pohɨrimbɨ nisɨ aŋɨpɨpɨhɨ nambɨ namɨndaape. Nɨnɨ utaahonɨnɨ gaahonɨnɨmaahe amɨ kɨnyɨ nisɨ aŋɨtɨtɨhɨ nambɨ nandaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Iyataatɨ amɨ nɨnɨ gwɨnyaataatɨ nɨnɨ awaisɨhonɨnɨ gaahonɨnɨmaahe kɨnyɨ nɨngisaapɨhɨ detɨ napɨtaapo. Isɨ kɨnyɨ sapɨhapɨ nehɨ pɨwɨha katisamɨhɨ nisɨ otɨpɨpatɨhomɨ timbɨpa owetɨtando. ");
INSERT INTO agm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iyataatɨ amɨ nɨngisangi isɨhiya usa nɨngi ninjatohiyɨhiya watɨpɨhandɨ naninyawɨ ahɨnisauhɨ amɨ nɨnɨ tunnɨwɨ yahwɨnohiyɨhiyai winjaatɨ bindataayo. Aindɨ amɨ utaaho woai ‘kɨnyɨ numwe undonaahɨ amɨ ko atɨnisatɨ notaise. Aindɨ amɨ utaaho woai kɨnyɨ namme undonaahɨ amɨ ko atɨnisatɨ nasataise. Aindɨ amɨ nisɨ otɨpɨpatɨhoai otɨpɨpatɨ satɨ kɨnyɨ kaime undonaahɨ amɨ ko nisɨha atɨnisatɨ kiyataise,’” undataase. ");
INSERT INTO agm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sata Kaundihɨ Jisaasiho atisataatɨ koai ise ta usonataise. Ise ta usonatosatɨ nepemaitatɨ koai isɨhiya nuwipinjai wɨrisandiwɨ taahiyɨhiya niyohiyɨhiyai saundataase. “Utaaho wo siyatɨ awaindɨhandɨ gɨwunyaasɨtɨhandisaho Isɨraherɨhiyaamɨ woai mausoho ndɨ nɨnɨ sangi kasatataato,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aihɨ isɨhiya ko natausaasisawɨhiya japɨhɨ nuwɨ aŋɨpɨpɨhɨ noaipapɨ mmonawa komɨ otɨpɨpatɨhomɨ timbɨpa aimɨ owetihɨ tɨtɨhɨ nepatɨ gaaho ainahɨho bimihɨ usonawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Sandɨ kiyatɨ owetihɨ amɨ wɨndɨ otɨhɨmetihɨ ketɨ aunahɨpatɨ wɨtɨ katamɨ ambɨpatɨ Nainɨhandaahapɨ Jisaasiho niyataise. Naihɨ amɨ komɨ otɨpɨpatɨhiyaunɨ amɨ isɨhiya usa wɨrisandɨhandɨ maasɨ koai nuwipinjai satɨ aunahɨpitaahapɨ niyawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jisaasiho niyatɨ aimɨ aunahɨpatamɨ matambɨpaamɨ onepataapɨhɨ noaipasɨhɨ utaaho waimwaaho wo napwihɨhoai aimɨ isɨsi yamwaitaatɨwɨ noaipawaayopo. So meto itapaatɨ osɨnɨhaatamɨ mwaaho nehɨ naasohisɨ amɨ kɨmɨko napohore. Aihɨ amɨ satɨ aunahɨpitaahapɨhiya isɨhiya taahɨtɨhandɨ kaatisawɨ maasɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aihɨ kaati Awaisɨho usonataatɨ kaatapɨ maarɨho tundihɨ namatɨ kaati Jisaasiho saundataase. “Kɨnyɨ wɨndɨ gomaatɨme,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Saundatosatɨ Jisaasiho niyatɨ gwɨtɨho waimwaaho soho ahotisɨho isɨwatɨ numwɨhatihɨ isɨhiya sohoai isɨsi niyohiyɨhiya namuwɨ kapɨhɨ namapɨ bitotawaayopo. Bitohauhɨ Jisaasiho koai saundataase. “Uta waimwaamoŋe, nɨnɨ gi japɨhɨ nepape hɨtataatonɨ kɨnyɨ nepape,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Saundihɨ utaaho aimɨ napomasɨho japɨhɨ nepatɨ tɨtɨhɨ bindata pɨwandaase. Aihɨ Jisaasiho koai numwaatɨ sanaati nusoaasataise. ");
INSERT INTO agm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aihɨ isɨhiya nahandɨ sandɨ mmonawaawɨ apɨpaahɨ awaindɨhandɨ yaiwɨ ese tɨwɨ gwɨnyaapɨ Autaahaatɨhoai mepɨ autaahepumawaayopo. Aiwɨ amɨ kiya satawaatopo. “Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaatɨ kanyatɨtandɨho awaisɨho kɨmo nyamɨ otɨhapɨhɨ noaipataise,” tawaatopo. Aiwɨ amɨ kiya satawaatopo. “Autaahaatɨho komɨ isɨhiyai andɨtɨwiwɨtandɨ aimɨ nasataise,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sandɨ siyatɨ Jisaasiho kaindɨmandapɨ isɨhiya pɨwɨha nesi yapɨpatɨ Judiyaahanda nahataapɨpɨhunɨ amɨ wapɨhunɨ nesi kanɨwɨ gaamawaayopo. Aiwɨ amɨ yapɨpatɨ kapɨhɨ detɨ ahetiwaiwaaraahimaawɨ kanɨwɨ gaamawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jonɨhomɨ otɨpɨpatɨhiya Jisaasiho isɨhiyaamɨ timbɨpa nemwatɨ amɨ napwauhɨhiyai ahowimasɨwɨmaiwaapɨ atiwɨmapɨ nuwɨ kaiwaapɨ Jonɨhoai kaundauhɨ ko atisataise. Atisatosatɨ komɨ otɨpɨpatɨhurɨ yahuri gaatatɨ numwaataise. ");
INSERT INTO agm_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Gaata Numwaatɨ Awaisɨhoai pɨwɨha satɨmɨha nunjenɨmɨ kaundɨtaatɨmɨ kuri sata kaundatɨ natausaasataise. “Utaaho wo napɨtaise tɨwɨ katohɨhoŋo e nyahɨ wopɨ jatɨtɨhaawo?” undɨmɨ nunjenɨmɨse undataase. ");
INSERT INTO agm_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Satatɨ kuri natausaasihɨ kurɨ numwɨ Jisaasihoaapɨhɨ noaipamaise. Noaipapɨ Jisaasihoai kurɨ saundamaase. “Jonɨho isɨhiyai baawusisɨho yahuraanyangi natanyoaasihɨ gisenda nasahaayo pɨwɨha Jonɨho satatɨ nanyamisɨha gi nangɨsendɨhaawo. Utaaho wo napɨtaise tohɨhoŋɨ nambɨhoŋo e utaaho wopɨ nyahɨ jatɨtɨhaawo? Hɨtɨha gi nangɨsendɨhaawɨ natanyoaasataise,” undamaase. Saundɨmɨ Jonɨho kuri kaundatɨ Jisaasihopɨ nusoaasisɨha ka kurɨ Jisaasihoai kaundamaase. ");
INSERT INTO agm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kurɨ numwɨ Jisaasihoapɨhɨ noaipasura kura amɨ Jisaasiho taatɨ isɨhiya timbɨpa kahatamatɨpetahapaisahiyai tɨtɨhɨwiwataise. Iyatɨ isɨhiya kiyaamɨhetɨ itɨpɨho maipɨhapa bimimbɨpai nemwatɨ amɨ isɨhiya ndɨha niyotahiyai netɨ japɨhɨ ndɨha nusorɨhaasɨhɨ kiya jawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iyauhɨ kurɨ Jonɨhomɨ pɨwɨha nesi naisururi Jisaasiho wihoaaŋɨha kuri sata kaunda natausaasataise. “Sahuraahɨ japɨhɨ Jonɨhoenda numwɨ sahuraahɨ sahuraasamɨ ndɨhaara mmonɨmɨ atimɨ nesɨpɨpaapɨ Jonɨhoai satɨmɨ kaundɨmɨse. Ndɨha niyotahiya japɨhɨ nga jawaayopo. Auhɨrɨ bɨwatetɨ namɨhatahiya nga itɨpapɨ daayawaayopo. Isɨhiya kiyaamɨ asaaha pisapɨpa owetihɨ ambɨpatɨ gaahatɨ nusoaipataise. Isɨhiya kiyaamɨ atihɨrɨ nɨwisaputihɨ pɨwɨha atɨhomisohiyɨhiya pɨwɨha baiwɨ atisawaayopo. Aihɨ amɨ isɨhiya napohiyɨhiya japɨhɨ nepawaayopo. Isɨhiya nopɨsasɨnɨwɨ mɨmaipetahatɨma bimohɨtɨmatɨma Autaahaatɨhomɨ pɨwɨha wanɨha gaaha atisawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iyataatɨ isɨhiya nisapɨ ko Kɨraisihotindɨho tɨwɨ namitanɨwɨ amɨ kiya nisapɨ gɨnunyaahohɨtɨhandɨ wɨndɨ namosasɨnɨhonɨhɨ andɨtitɨwɨ gɨnunyaahohiyɨhiya maaritɨtaapo nyatataase,” undɨmɨ kaundɨmɨse undatɨ kuri kaunda natausaasataise. ");
INSERT INTO agm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jonɨhomɨ pɨwɨha isɨsi naisururɨ aimɨ japɨhɨ naihɨ Jisaasiho Jonɨhopɨ pɨwɨha isɨhiya taahiyɨhiyai sata kaundataase. “Jɨhura isɨhiya owehapɨhɨ sahɨ niyohɨtɨndɨ napindɨ mmondaatɨwɨ niyopo. Mbɨpaara awaatɨpatɨ nesi kihɨkihoaaŋemasɨhɨ mmonta niyowo? Owetise. ");
INSERT INTO agm_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Owetise amɨ sahɨ akɨtɨndɨ napindɨ mmonta niyopo? Utaaho wo utɨ apotɨhɨrɨ gaahapa niyotɨ yundanyainatɨ bitosɨhɨ koai usonda niyowo? Owetise. Isɨhiya saiwɨ gaahapa niyopɨ yundanyainɨwɨhiya siyaahɨ isɨhiya awaisawɨhiyaimatɨwɨ yapɨpati amɨ isɨhiyai osamapɨ jatohiyɨhiyaamɨ aŋɨpɨpɨhɨ bindawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Isɨ amɨ sahɨ napindɨ mmonta niyopo? Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨhoai usonda niyowo? Ye akɨte. Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨhoai usonda niyopo. So Jonɨho isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyai nusatipɨhaaho awaisɨhore. ");
INSERT INTO agm_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","So utaamopɨ Autaahaatɨhomɨ pɨwɨhaatɨhɨ satatɨ ahotisɨhore. ‘Utaaho woaisɨ nisɨ pɨwɨha nunyatɨ nandusaasɨto. Nandusoaasisanɨhɨ ko kinyɨ jɨhɨ notɨ daihɨra kinyapɨ netɨ tɨtɨhehɨmaitaise,’ tatɨ kopɨ ahotisɨhore. ");
INSERT INTO agm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Maapɨ yapɨpataapɨhɨ isɨhiya namɨwiyaahohɨhiyaamɨ namoyaatohiyɨhiyaamɨ wo Jonɨhoai nusatipɨhaaho awaisɨho wo namoaipase. Owetise. Sandɨ Sendaahandɨ kandɨ amɨ utaaho Autaahaatɨho isɨhiyai iwinjatindɨhandaatɨhɨ nehɨ yatɨhɨ ambɨpatɨ oweho usaisɨ wɨndɨ namusatipɨhaatɨ amɨ apɨpaahɨ wɨndɨ awaisɨhometisɨho Jonɨhoai awaindɨhandɨ nusatipɨhaatɨ awaisɨhore,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Isɨhiya nahatiya nehɨhiya amɨ isɨhiya gamanɨhomɨ otɨpɨpatɨ kaitaatɨwo nawɨho taakisihandɨ nehohiyɨhiyai maawɨ Jisaasihomɨ sa pɨwɨha atisawaawɨ kiya satawaatopo. “Autaahaatɨhomɨ kaindɨhandɨ apɨpaahɨ akɨtɨ tɨtɨhe,” tawaatopo kiyai Jonɨho waapohora baawusahiyaaso. ");
INSERT INTO agm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Iyataahandɨ kandɨ isɨhiya Parisihiyaunɨ amɨ isɨhiya usa Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ siya Jonɨho waapohora wɨndɨ bahomaawusahiyaasɨ kiya Autaahaatɨhomɨ daihɨra gaahɨra nunjirɨhɨra nepɨ dawaatemapɨ ahosumwawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Aihɨ Jisaasiho sata kandaase. “Isɨhiya wanɨ kɨmura bimohiyɨmiyaapɨ napindapɨ sɨwipatɨ namɨhandɨ katɨtande? Kiya napitetahiyaatindɨho? ");
INSERT INTO agm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Manyinya aunahɨpata masapɨpɨhɨ bindawa metɨhonya sasaahohonyai gaatɨwɨ satɨwɨ kaundohɨpatamataiwɨhiye. ‘Sahɨ waipoaapɨ nawesɨndaatɨwɨ nyahɨ apwɨtɨhɨrɨ ipohonɨhɨ sahɨ wɨndɨ waipoaapɨ namaawesɨnɨhopo. Sahɨ gwɨtaatɨwɨ nyahɨ awirɨtonɨhandɨ sahɨ wɨndɨ gomaatopo,’ undohɨpatamataiwɨhiye. ");
INSERT INTO agm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jonɨho isɨhiyai baawusisɨho nasatɨ nandapa bɨretɨhandɨ amɨ waapoho wainɨhandunɨ wɨndɨ namainjɨhɨ sahɨ kopɨ satawaatopo. ‘Itɨpɨho maipɨho komɨhetɨ bimihe,’ tɨwɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aihɨ amɨ wanɨ Isɨhiyaamɨ Awaisɨhonɨnɨ Saahonɨnɨ Jɨhonɨnɨ napɨtɨ waapoho nandapa nanɨhonɨhɨ amɨ sahɨ nisapɨ satawaatopo. ‘Kɨmoai iwinjasawɨse kɨmo nandapa pɨhɨtatɨ nanataise. Iyatɨ amɨ waapoho wainɨhandɨ pɨhɨtatɨ nanataise. Ko gwɨsɨ tauhoe. Iyatɨ ko isɨhiya nawɨho taakisihandɨ gamanɨhomɨ otɨpɨpatɨ kaitandɨho nehohiyɨhiyaamunɨ amɨ isɨhiya maipɨhaiwaisahiyaamunɨ naisohoe,” tɨwɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Iyataatɨ amɨ isɨhiya Autaahaatɨhomɨ gwɨnyaasɨtɨhandɨ mmonɨwɨ nehohiyɨhiya Autaahaatɨhomɨ gwɨnyaasɨtɨhandapɨ akɨte tɨwɨ nanyisawaayopo,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Utaaho wo isɨhiya Parisihiyaamɨho Parisiho Jisaasihoai nandapa nisɨ aŋɨpɨpɨhɨ maasɨ nandahaawɨ namme unda gaatihɨ Jisaasiho niyatɨ Parisihomɨ aŋaaŋɨ nandaatɨ nandapa nandandɨ nausanatɨ ganɨhomɨhinɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Satɨ aunahɨpita itapaatɨ waatɨ maipɨhaiwa nasisoaarɨ kiyahaatɨ bindataise. Isɨ kaatɨ Jisaasihopɨ atisataatɨ Jisaasiho Parisihomɨ aŋɨpɨpɨhɨ nandapa koaisa taatɨ nanataise tauhɨ atisataise. Atisataatɨ kaatɨ atɨpatɨ wipatɨ wɨtɨ apɨpaahɨ gaahatɨ waamainjotahatɨ netɨ isɨsi niyataise. ");
INSERT INTO agm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Niyatɨ Jisaasihomɨ dawaapɨpɨhɨ detɨ komɨ auhɨrainɨ bitonda gotaise. Gwihɨ kaatamɨ kwɨtipatɨ nandɨndɨwatɨ Jisaasihomɨ auhɨretɨ atasɨhaatɨhɨ nurɨhatataise. Nurɨhatihɨ kaatamɨ misisɨhaara kwɨtipatɨ auhɨrepɨ nurɨhatipatɨ nurɨhisatɨ nuwipiyaipataise. Iyatɨ komɨ auhɨrisɨ gerundataise. Gerundatɨ atɨpatɨ wipatɨ isɨsi naipatɨ nuhaatɨ auhɨretɨ iwinjaataise. ");
INSERT INTO agm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kaatɨ siyatɨ kaihɨ utaaho Parisiho Jisaasihoai nandapaapɨ gaata numwaasɨho sandɨ mmonataatɨ ko siyatɨ gwɨnyaataise. Kɨmo Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨhondaataahɨ itapɨmaatɨ kɨmaatɨ koai iwiwatɨ numwɨhatisaamɨmaatamɨ maipɨhaiwa kaiwaiwa usonatɨ itapa kɨmaatɨ maipɨhaiwaisahaatɨ setahaate tatɨ usonatɨ gɨmunyaase tatɨ ko komɨ maarɨhoaatɨhɨ gwɨnyaataise. ");
INSERT INTO agm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Aihɨ ko siyatɨ gwɨnyaasɨtɨhandapɨ Jisaasiho wihoaaŋɨha saundataase. “Saimonɨhoŋe, nɨnɨ nɨngi pɨwɨha wa kɨma kahɨtɨtandiyonɨ atime,” undataase. Saundatɨ nunjesɨhɨ amɨ Saimonɨho Jisaasihoai komɨha saundataase. “Ye Katɨpunjingɨhoŋe, nɨnɨ atitaanɨ gaasɨ katɨme,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aihɨ amɨ Jisaasiho koai saundataase. “Utaahurɨ wurɨ utaaho womɨ nawɨho nehɨ (dinauhandɨ kaimɨ) nemaise ipotɨ japɨhɨ nahɨmɨtaano undɨmo. Aimɨ wo 500 kina kiyatɨ nesɨhɨ amɨ wo yatɨhɨ 50 kina kiyatɨ netaise. ");
INSERT INTO agm_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Saimɨ kurɨ nawɨho komɨ nusesɨho japɨhɨ ketɨ wɨndɨ namumwɨtaihɨ ko namatɨ nawɨhomɨ satɨho kandɨ (dinauhandɨ) nawɨho nesɨtɨhandɨ nemwatɨ nanɨpimatataise. Isɨ suramɨ maahɨwo koai maarɨho nunyamataise?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saundatɨ nunjesɨhɨ amɨ Saimonɨho komɨha wihoaaŋɨha Jisaasihoai sata kaundataase. “Nawɨho (dinauhandɨ) aungwohandɨ nesɨtɨhandɨ nawɨhomɨ satɨho nemwatɨ nanɨpimatonɨhɨ nawɨho nesɨho nawɨhomɨ satɨhoai maarɨho waatɨ numwɨtaise ndɨ gwɨnyaataayo,” undataase. Saundihɨ Jisaasiho koai saundataase. “Kɨnyɨ tɨtɨhɨ gwɨnyapenɨpɨ katapaase,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Saundatosatɨ Jisaasiho kaatɨ apopaatamɨhihoaaŋɨ nepemaitatɨ mandosatɨ bindataatɨ Saimonɨhoai saundataase. “Kɨnyɨ kɨmaatɨ apomaatamɨ kaindɨmandɨ mmonapaino? Nɨnɨ kinyɨ aŋɨtɨmatɨhɨ napɨtɨ nandaahonɨhɨ kɨnyɨ waapoho wo namaanɨmise nisɨ auhɨrɨ atasɨha bausamaitando. Kɨnyɨ saimbɨ kamaaninɨhandɨ kandɨ kɨmaatɨ apomaatɨ kaatamɨ kwɨtipataahɨ nisɨ auhɨrɨ atasɨha bausanɨmatɨ amɨ kaatamɨ misisɨhaaraahɨ auhɨrɨ nanipiyaipataise. ");
INSERT INTO agm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Amɨ kɨnyɨhɨ nɨngi wɨndɨ gerɨmandise. O amɨ kɨmaatɨ apomaatɨhɨ wuwanɨ napɨtɨ kɨnyɨ aŋɨmaaŋɨ nandaahohuraapɨ namasatɨ nisɨ auhɨrɨ wɨndɨ namaamɨhaatɨ kaatɨnɨhɨ gerɨndɨmɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kɨnyɨ nɨngi wɨndɨ atɨpatɨ oripɨhatɨ noaapɨ nisɨ mɨtɨhoaatɨhɨ maaninjaahise. O amɨ kɨmaatɨhɨ atɨpatɨ gaahatɨ apɨpaahɨ awaindɨhandɨ waamainjotahatɨ noaatɨ nisɨ auhɨrepɨ ninjaataise. ");
INSERT INTO agm_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Isɨ nɨnɨ sandɨ gi kahɨtataato. Kɨmaatɨ apomaatɨ nɨngi maarɨho apɨpaahɨ awaindɨhandɨ aungwohandɨ nanɨmindɨmandɨ amɨ kaatɨ maipɨhaiwa taahɨwaiwa kaiwaiwa nahatewa Autaahaatɨho aimɨ nemwasɨhe. Isɨhiya usa maipɨhaiwa nehɨ yahonyaahɨhɨ kiyauhɨ konya Autaahaatɨho nemwasawɨhiya siya amɨ nehɨ apɨpaahɨ maipehonjɨ gotɨ nɨngi kiyaamɨ maarɨho naninyawaayopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jisaasiho koai sata kaundatosatɨ amɨ apopaati saundataase. “Kinyɨ maipɨhaiwa nahatewa aimɨ nɨnɨ nehɨmataayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sata Jisaasiho kaati kaundihɨ kapɨhɨ isɨhiya nandapa taawɨ ganɨhoaasɨnɨ nanɨhohiyɨhiya sawana sanawaatopo. “Utaamo kɨmo napitetahondaatɨ maipɨhaiwa nemwataatise?” tɨwɨ kanawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aihɨ Jisaasiho kaatɨ apopaati saundataase. “Kɨnyɨ nisapɨ gɨnunyaahingɨtɨhandaahɨ Autaahaatɨho gi kinyɨ maipɨhaiwaatɨhapɨ aimɨ japɨhɨ nangɨmaataise. Isɨ kinyɨ maarɨho yatɨhɨngitatɨ napaisaatɨtatɨ wɨngitonɨhɨ numwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Saiwa aimɨ kiyatɨ owetihɨ kapɨhɨ wura Jisaasiho aunahɨpɨhaiwa taunɨhandɨ awaiwaiwaaraahunɨ amɨ aunahɨpɨhaiwa gwɨharaahaiwaaraahunɨ daayataise. Daayatɨ Autaahaatɨho isɨhiyai iwinjatɨmɨ naiwaiwaapɨha pɨwɨha gaaha wanɨha ausaatɨ isɨhiyai kaundataase. Aihɨ amɨ komɨ otɨpɨpatɨhiya ko kaiwaiwa mmonɨwɨ nepɨ kaiwɨ nɨwipinjohiyɨhiya ikwɨ maindɨmwɨtihɨ auhɨramɨ yahurɨtahiyaasɨ (12 kaiwɨhiya) kiyaahɨ maasɨ daayawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Aihɨ amɨ asɨhiya usa jɨhura Jisaasiho itɨpɨho maipɨhaiwa nemwatɨ amɨ timbɨpa nemwatɨ tɨtɨhemwasawɨhiyai maawɨ koaisawɨ daayawaayopo. Siya asiyaamɨ waatɨ aunahɨpatɨ Makɨtaraahandaahapɨhaatɨ Mariyaahaate. Saatɨ Mariyaasaatɨ jɨhura Jisaasiho kaatamɨhetɨ itɨpɨho maipɨhapa taahɨpɨpa ikwɨrɨ naasairɨtihɨ wɨramɨ yahurɨtahaiwa bimihɨ nemwasaamaate. ");
INSERT INTO agm_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Aihɨ amɨ waatɨ Joaanaahaate. Saatɨ Joaanaasaatɨ utaaho wo komɨ ambɨpatɨ Kusaahomɨ apwaataate. So Kusaaso awaisɨho Erotɨhomɨ kahapaamapɨpa aŋaaŋɨ awaisɨhoematatɨ iwinjatisɨhore. Aihɨ amɨ waatɨ Susanaahaate. Aihɨ amɨ asɨhiya usai maawɨ nowaayopo. Asɨmiya kɨmiya Jisaasihoaisunɨ komɨ otɨpɨpatɨhiyaisunɨ kahapaamapɨpa kiyaamɨhapa andɨtɨwipɨ (nawɨho amɨ nandapa amɨ aŋaaŋɨ) kiyai nunyawɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Asisɨha waara isɨhiya pɨhɨtahandɨ aunahɨpatɨ taunɨhandɨ kɨhandɨ katɨ kataahapɨhiya Jisaasihoaapɨhɨ nasawaayopo. Napɨwɨ isɨhiya wɨrisandɨhandɨ ahoyanɨwɨmɨhauhɨ nandapaamɨ isapɨpa kwɨtaahopɨ Jisaasiho namɨhanatɨ pɨwɨha sata kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Utaaho wo komɨ nandapaamɨ kwɨtaaho nesi notɨ komɨ osaataatɨ kupwɨratɨ mɨhopɨ mɨhinɨ tɨwɨhaataise. Tɨwɨhaasɨhɨ kwɨtaaho wapa tɨtɨhɨ daihɨra tɨmahaihɨ isɨhiya ikisipɨ itɨpapɨ daayawaayopo. Aihɨ amɨ koho netɨ kapa nanataise. ");
INSERT INTO agm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aihɨ amɨ nandapaamɨ kwɨtaaho wo yapɨpatɨ apɨpaahɨ nawɨhaisahataapɨhɨ tɨmahiyataise. Iyatɨ kapɨhapɨ ketɨ nutatɨ nawatatɨho ko amɨ japɨhɨ awaipɨndaise gaahapɨhɨ waasitahapɨhɨmendato. ");
INSERT INTO agm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aihɨ amɨ nandapaamɨ kwɨtaaho wo kaarɨha mwɨtoaipatamɨ otɨhapɨhɨ tɨmahiyataise. Tɨmahiyatɨ kaarɨha mwɨtoaipatɨ netɨ namaasatɨ ipɨhatihɨ gɨpɨpwitatɨ ahendaise. ");
INSERT INTO agm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aihɨ amɨ nandapaamɨ kwɨtaaho wo yapɨpatɨ gaahatɨ waasitahata tɨmahiyataise. Tɨmahiyatɨ biyatɨ nawatɨ saniya nandapa akɨpɨpa kwɨtaaya pɨhɨtatɨ kɨsɨtɨpepatɨ kwɨtaaho nɨnaasohɨ yamahohɨho 100 100 kiyatɨ ahondaise,” undatɨ kiyai Jisaasiho kaundataase. Sata kaundatɨ owemataatɨ ko kiyai saundataase. “Sahɨ atitaatɨwɨ atihɨrisahiyaatisɨ baiwɨ nisɨ pɨwɨha sa kasatohɨma atiwɨ nepɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisaasihomɨ otɨpɨpatɨhiya Jisaasihoai pɨwɨha namɨhanɨpɨ katingɨhaamɨ tanyaaha napitiyaha katise undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nunjenɨhauhɨ Jisaasiho kiyai sata kaundataase. Autaahaatɨho isɨhiyai iwinjatindɨhandapɨ isɨhiyai gɨwunyaatɨtandɨhandɨ noaasandindɨhandapɨha pɨwɨha aimɨ sangi ausaimanatɨ nasɨsise. Iyataahandɨ kandɨ isɨhiya usa nahatiyaisaahɨ nehɨ pɨwɨha namɨhandɨhaahɨ kaundonɨhɨ atisawaayopo. Iyataatɨ sandapɨ pɨwɨha wa sata jɨpatɨpindise. “Isɨhiya pɨhɨtɨwɨ jawaatawaahandɨ kandɨ akɨtɨhandɨ wɨndɨ kiya monɨhopo. Kiya pɨhɨtɨwɨ kiyaamɨ atihɨrɨ mwɨtɨpɨsawɨ atisawaatawaahandɨ kandɨ pɨwɨhaamɨ tanyaahaapɨ kiyai wɨndɨ namusesɨpatatɨ gɨmaawunyaatɨtaise,” tatɨ jɨpatɨpindise undataase. ");
INSERT INTO agm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Saundatosatɨ Jisaasiho komɨ otɨpɨpatɨhiyai kiya nunjenohɨhaapɨ saundataase. “Pɨwɨha sangi namɨhandɨ kasatohɨhaamɨ tanyaaha siyate. Nandapa kwɨtaaho so Autaahaatɨhomɨ pɨwɨhaare. ");
INSERT INTO agm_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Iyatɨ nandapaamɨ kwɨtaaho daihɨra tɨmahaiso so isɨhiya Autaahaatɨhomɨ pɨwɨha atisohiyɨhiyaare. Atisohiyɨhiyaatawaahandɨ kandɨ kiya Autaahaatɨhopɨ wɨndɨ gɨmaawunyaasaihɨ amɨ Autaahaatɨho kiyai wɨndɨ japɨhɨ namumwaitandɨ Bwaasɨrɨhɨrɨ pɨwɨha kiya atisohɨha kiyaamɨ maarɨhoaatɨhapɨ nasatɨ nemasawɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nandapaamɨ kwɨtaaho yapɨpatɨ nawɨhaisahataapɨhɨ tɨmahaindɨmandɨ isɨhiya Autaahaatɨhomɨ pɨwɨha wuwanɨhura ketɨ maaritɨwɨ nepɨ nehɨ masɨhonjɨ gwɨnyaahohiyɨhiyaare. Saiwɨ Maaritɨwɨ nehohiyɨhiyandaahandɨ kandɨ amɨ ka pɨwɨha mɨhatɨhɨ kiyaamɨ maarɨhoaatɨhɨ anɨtisatɨ kɨmaurɨmwɨndihɨ nehɨ gohɨ masɨhonjɨ gɨwunyaawaayopo. Iyauhɨ amɨ kahapaamapɨpa kiyai nunjendandɨhaiwa kiyaapɨhɨ noaipatɨ nunjesɨhɨ kiya kaiwaapɨ tɨmahiyotɨhandape. ");
INSERT INTO agm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aihɨ amɨ nandapaamɨ kwɨtaaho wo kaarɨha mwɨtoaipatamɨ otɨhapɨhɨ tambɨpɨhɨ tɨmahaimbɨpa sapa isɨhiya Autaahaatɨhomɨ pɨwɨha atisawaahandɨ kandɨ kahapaamapɨpa nawɨho utɨ apotɨhɨrɨ kapaisaahɨhɨ maarɨho nunyawɨmapɨ amɨ kiyaamɨ omaŋɨtɨtɨhɨ nehɨ kapaapaahɨhɨ gwɨnyaahohɨwaiwa tisaitata Autaahaatɨhomɨ pɨwɨha sawanamɨhetɨ ahotisɨhai nepɨ namaasapɨ ipatisauhɨ pɨwɨha atisohɨhaamɨ nandapa akɨpɨpa wɨndɨ usɨtiyatɨ namoaipasɨtɨhandape. ");
INSERT INTO agm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nandapaamɨ kwɨtaaho yapɨpatɨ gaahata tɨmahaimbɨpa sapa isɨhiya Autaahaatɨhomɨ pɨwɨha baiwɨ atiwɨ nepɨ anɨtiwɨ kiyaamɨ maarɨho omaŋɨtɨtɨhɨ ahiyawɨ watɨpɨtɨwɨ tɨtɨhɨ maarɨho gaaho gwɨnyaahauhɨ pɨwɨha kiya atisotɨhaamɨ nandapa akɨpɨpa kiyaamɨhetapɨ ausaimanatɨ noaipasɨtɨhandape,” undatɨ Jisaasiho komɨ otɨpɨpatɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jisaasiho pɨwɨha wa kiyai saundataase. “Utaaho wo norɨhɨrɨ raamɨhandɨ sisɨha tɨpotɨ yutɨhɨraatɨhunɨ amɨ ganɨhomɨ otɨtɨhunɨ noaasatɨ wɨndɨ ahɨmaitaise. Nehɨ tɨpotɨ autaahiwatɨ ahaitaise. Iyonɨhɨ isɨhiya aŋɨtɨtɨhɨ napɨwɨ nandaahohiyɨhiya sisɨha ka nausaatonɨhɨ japɨ nga mmomɨ nandaitaatɨwo. ");
INSERT INTO agm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sandɨ katotɨmandɨ apaapɨmaato. Amɨ kahapaamapɨpa noaasandimbɨpa nahataapa auta ipotɨhura noaipaitaise ndaato. Kahapaamapɨpa isɨhiya mmapɨ noaasawɨ ahiyohɨpɨpa ipotɨhura auta noaipahonɨhɨ isɨhiya mmondaapo. ");
INSERT INTO agm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Sahɨ pɨwɨha atiwɨ naitaatɨwɨhɨretapɨ baiwɨ gwɨnyaapɨ jatɨnɨwise. Amɨ utaaho wo wapaisahoai Autaahaatɨho jahaatɨ waatɨ numwɨtaise. Iyatɨ amɨ utaaho wo wapa nehɨ yahonyaisahonɨniso tatɨ gwɨnyaataataahɨ sɨkonya ko gwɨnyaasonyonya Autaahaatɨho komɨhetapɨ kapaanɨhɨ nemaitaise,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Aihɨ Jisaasihomɨ sanaatunɨ amɨ komɨ saingoya sanaapwɨsaunɨ koai iwinjaitaatɨwɨ nasawaayopo. Napɨwɨ detɨ Jisaasihomɨhinɨ naitotɨwɨ mmonawa isɨhiya taahɨtɨhandɨ tisaitata daihɨra naitɨhɨra owendaise. ");
INSERT INTO agm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aihɨ kusasapɨ isɨhiya usa Jisaasihoai saundawaatopo. “Kinyɨ kɨnaatunɨ amɨ kinyɨ kunyɨhoya kɨnaapwɨsaunɨ gi ginjaitaatɨwɨ kɨmusasɨ napɨwɨhusasɨ ipaahaapɨ bitotawaayopo,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Saundauhɨ Jisaasiho komɨha pɨwɨha wihoaaŋɨha kiyai sata kaundataase. “Isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ japepihɨrohiyɨhiya siya nisɨ niya nisɨ nɨhoaarɨsa naapwɨrise,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Asisɨha waara Jisaasiho komɨ otɨpɨpatɨhiyai saundataase. “Durɨhɨramɨ mɨhihɨnapɨ nutɨhaawo,” undihɨ kiya kopuhotɨ yamwaapɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Taawɨ nowaawɨ Jisaasiho naawihɨ nanotondaise. Aihɨ itɨ nambɨtɨhɨrɨ durɨhɨraatɨhɨ nasataise. Nasataatɨ durɨhɨrɨ waatɨ dotɨ gwɨnyana tiwayaataise. Waatɨ durɨhɨrɨ dotɨ tiwayaataatɨ nausɨha kopuhotɨ witatɨ tisaitatɨ aimɨ kiyai netɨ nawatisonɨhɨ amɨ kiya waapoho nanɨwɨ nawatiwɨ owetɨtaatɨwɨhandɨ kendaise. ");
INSERT INTO agm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aihɨ kiya nuwɨ Jisaasihoai ahowimapɨ saundawaatopo. “Awaisɨhoŋɨ Nyainjatingɨhonye, nyahɨ waapoho nanaatɨ aimɨ nyangi durɨhɨrɨ netɨ nanyawatisonɨhɨ aimɨ owetɨtɨhaawiyo,” undawaatopo. Saundauhɨ ko nepatɨ itɨ nambɨtɨhɨrisunɨ durɨhɨrɨ awaindɨhandɨ dotɨ gwɨnyanatɨ tiwaayaasɨtɨhandisunɨ itɨhundihɨ amɨ itɨ nambɨtɨhɨrɨ dɨhɨwatɨ amɨ durɨhɨrɨ ndo gwɨnyana tiwayaasɨtɨhandɨ yatɨhitatɨ durɨhɨrɨ wɨndɨ ahomaayatɨ bɨpi nimandataise. ");
INSERT INTO agm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Saihɨ ko kiyai saundataase. “Sahɨ nisapɨ gɨnunyaahotɨhandɨ maahapɨhɨ naihɨtopo?” undataase. Aihɨ kiya yaiwɨ kiyaamɨ maarɨho owesoetihɨ sawana sanawaatopo. “Utaamo kɨmo diyaamahoe, itɨ nambɨtɨhɨrisunɨ amɨ durɨhɨrisunɨ itɨhundihɨ koai atɨwisatɨ bɨpi yatɨhitataiso?” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aihɨ kiya kopuhotɨ kiyaanɨhɨ nuwɨ aunahɨpatɨ Geraasaahandɨ ahetimbɨpɨhɨ noaipawaayopo. Satɨ aunahɨpatɨ taunɨhandɨ durɨhɨrɨ Garirihandamɨ wihɨnɨ ahendaise. ");
INSERT INTO agm_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisaasiho kopuhotɨ namasi taatɨ noaatɨpasɨhɨ utaaho wo itɨpɨho maipɨhapa anɨtisatɨ mmatɨ isɨwatihɨho satɨ aunahɨpitaahapɨho nasatɨ Jisaasihoaisamɨ nutanamaise. So utaaso utaarɨhandetɨ utɨ apotɨhɨrɨ namaayotɨ somaahɨho aŋɨpɨpɨhɨ wɨndɨ biyatɨ bimimotɨ nehɨhaatɨ nahatewetɨ itapɨpa ahiyohɨpɨpɨhɨ jomaahɨtɨtɨhɨ nasisoaarɨ nanotɨ bisotinjahore. ");
INSERT INTO agm_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Isɨ ko Jisaasihoaisamɨ nutanɨmɨ usonatosatɨ waatɨ kaahaatamapɨ Jisaasihomɨ detɨ utatotɨ tɨmahiyatɨ ahondaatɨ waapɨhɨtatɨ kaahaata Jisaasihoai sata kaundataase. “Autaahaatɨho Nahatewai Daahema Autaahɨ Nɨwaataatɨ Bimisɨhomɨ Mwaahoŋe kɨnyɨ nɨngi napitɨnitaape? Nɨngi yaasahandɨ namaanɨmɨtaapɨ andɨtindɨ owe hɨtɨtɨ kahɨtataato,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Sandɨ Jisaasiho aimɨ itɨpɨho maipɨhapai kɨmo utaamoai namasi noaipasi numwe undatɨ kaundihɨ kandapɨ kandaase. Itɨpɨho maipɨhapa nasisoaarɨ soai anɨtisatɨ isɨwatatɨ bimohosɨ isɨhiya nahatewetɨ isɨwatɨwunɨ amɨ ipipatɨ watɨpɨhataahunɨ anɨtiwɨ ikwɨrɨ wɨsasauhɨhandɨ kandɨ kapa tinjaatɨ nasɨpatɨ ahiyamɨ nohore. Iyataatɨ itɨpɨho maipɨhapa sapa netɨ koai isɨsi isɨhiya owehapɨhɨ watɨminahapɨhɨ notoandaise. ");
INSERT INTO agm_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aihɨ koai Jisaasiho “kinyɨ ambɨpatɨ napimahoŋe,” undatɨ nunjenataise. Nunjesɨhɨ ko saundataase. “Nisɨ ambɨpatɨ taahɨhonɨne,” undataase. Sandɨ itɨpɨho maipɨho taahɨho so utaasometɨ nandaatɨ bimohosɨ tɨtɨhɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Itɨpɨho maipɨhapa Jisaasihoai pɨwɨha apɨpaahɨ andɨtitɨwɨ watɨpɨtɨwɨha satɨwɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kapɨhɨ detɨ sisɨhomɨhinɨ maasapɨho taahɨho woyɨha taatɨ nanatɨ kapɨhɨ bitosɨhɨ itɨpɨho maipɨhapa maasapɨho soetepɨnyamape undɨwɨ Jisaasihoai pɨwɨha watɨpɨtɨwɨ andɨtitɨwɨha kaundawaatopo. Iyauhɨ Jisaasiho gaasɨ so maasapɨmoetɨ nuwɨ nandaapɨse unda natausaasataise. ");
INSERT INTO agm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aihɨ itɨpɨho maipɨhapa so utaasomɨhetapɨ noaipasi nuwɨ maasapɨho nahatoetɨ nandaawaayopo. Nandaahauhɨ maasapɨho nahato naupwasi durɨhɨraatɨhɨ naisɨho konɨhɨ witatɨ nahato waapoho nanatɨ napotaise. ");
INSERT INTO agm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aihɨ maasapɨho yamanɨwɨ jaawɨ bitohohiyɨhiya sandɨ siyatɨ noaipasɨhɨ mmonɨmapɨ yanɨhɨmawaayopo. Yanɨhɨmapɨ nuwɨ aunahɨpatɨ taunɨhandaatunɨ amɨ kahapɨhɨ kahapɨhunɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kaundauhɨ isɨhiya atiwɨmapɨ mmondaatɨwɨ niyawaayopo. Naiwɨ Jisaasihoaapɨhɨ noaipapɨ mmonawa itɨpɨho maipɨhapa noaipasi naisɨho utaaho utɨ apotɨhɨrɨ niyotɨ komɨ naharɨho owetihɨ nanɨhiyatɨ komɨ amɨtɨha biyatɨ nga gɨwunyainjɨhɨ Jisaasihomɨ auhɨraapɨhɨ bimihɨ kiya usonawaayopo. Usonawaawɨ ko siyatɨ bimihɨ waatɨ kiya yaiwɨmawaayopo ");
INSERT INTO agm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jisaasiho naharɨhomɨhetapɨ itɨpɨho maipɨhapa nemwasɨhɨ isɨhiya usonɨwɨ nehohiyɨhiya kiyai siyatɨ kaihɨ komɨ naharɨho owesoendaise undɨwɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Aihɨ isɨhiya nahatiya aunahɨpatɨ taunɨhandɨ Gerasaahandaahapɨhiya sandɨ mmonawaawɨ apɨpaahɨ yausamasɨhɨ namapɨ Jisaasihoai kɨmbɨhɨ nyangi nanyamasi ketɨhoŋɨ numwe undauhɨ Jisaasiho kapɨhɨ namasi nutandɨ kopuhotɨ yamwaataise. ");
INSERT INTO agm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aihɨ utaaho itɨpɨho maipɨhapa noaipasi naisɨho Jisaasihoai pɨwɨha andɨtitaha sata kaundataase. “Nɨnɨ gisatɨ maasɨ nutaano,” undataase. Aihɨ Jisaasiho koai sata kaunda natausaasataise. ");
INSERT INTO agm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kɨnyɨ kinyɨ aunahɨpataahapɨ japɨhɨ numwe. Numbwɨ Autaahaatɨho gaahatɨ kahindɨhandapɨ isɨhiyai pɨwɨha ausaapɨ kaunde,” undatɨ natausaasataise. Aihɨ ko utaaho notɨ isɨhiya nahatiyai aunahɨpatɨ sataahɨ gaamatɨ Jisaasiho koai kawindɨhandapɨ ausaatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Isɨhiya wɨrɨsandɨhandɨ Jisaasihopɨ jatɨmbɨwɨhiyaasɨ Jisaasiho japɨhɨ napihɨ kiya maaritɨwɨ numwaawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aihɨ utaaho wo komɨ ambɨpatɨ Jairaasiho Judaahiyaamɨ aŋɨ gwɨharaahandɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundɨtaatɨwɨ ahoyanohɨtɨhandɨ awaisɨho mɨtɨhoematatɨ jatisɨho nasatɨ Jisaasihoaapɨhɨ noaipataise. Nasatɨ Jisaasihomɨ utatototɨ auhɨraapɨhɨ tɨmahiyatɨ ahondaatɨ nisɨ aŋɨpɨpɨhapɨ namme undatɨ watɨpɨtatɨ andɨtitamataise. ");
INSERT INTO agm_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","So utaaso sata kaundindɨmandɨ apaapɨmaahe amɨ komɨ metɨhonjɨ nehɨ naasonyɨhɨtahondaatɨse. Sonjɨ metonjɨ aponyonjɨ konjamɨ kɨnaungwɨha ikwɨ maindɨmwɨtihɨ auhɨramɨ yatairɨ 12 kiyatɨ aimɨ sanausohonje. Isɨ konjɨ metonjɨ aimɨ napwɨtandɨ detɨtihe. Aihɨ Jisaasiho taatɨ naihɨ isɨhiya wɨrɨsandiwɨ komɨhinɨ nowaawɨ nepɨ iwɨhiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aihɨ amɨ itapaatɨ waatɨ kɨnaukwɨha ikwɨ maindɨmwɨtihɨ auhɨramɨ yatairɨtahaiwetɨ (12 kiyatɨ) nasisoaarɨ jɨtɨpatɨ jɨtɨmainjɨhaatɨ bindataise. Iyataatɨ saatɨ itapaatisɨ utaaho wo kaatamɨ jɨtɨmasɨtɨhandɨ nemwaitandɨho wo owetise. ");
INSERT INTO agm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aihɨ saatɨ apopaatɨ Jisaasihomɨ dawaataatɨ ipɨpɨhɨ nasatɨ Jisaasihomɨ apotɨhɨrɨ nipaatirɨhɨramɨ otasaahaasɨnɨ isɨwataise. Siyatɨ kaatɨ isɨwihɨ kaatamɨ nasisoaarɨ jɨtɨmatoaatindɨhandɨ ketɨ kuraanɨhɨ dɨhɨwatɨ owesoendaise. ");
INSERT INTO agm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aihɨ Jisaasiho sandaase. “Nɨngi ikwɨraahɨ ndɨ nanɨmahatise?” tatɨ nasenataise. Aihɨ isɨhiya nahatiya nyahɨhɨ owesɨ nde undauhɨ Pitaaho Jisaasihoai saundataase. “Nyainjatingɨhonye, isɨhiya gɨhipɨ kɨnyɨhinɨ detɨ detɨ nasawaayopo. Isɨ amɨ kɨnyɨ napindapɨ nasehise?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Saundihɨhandɨ kandɨ Jisaasiho sandaase. “Isɨhiya usa nɨngi nanɨmɨhatauhɨ nisɨ watɨpɨhandɨ nisɨhetɨ ahotindɨhandɨ wɨndɨ aimɨ naihɨto,” ndaase. ");
INSERT INTO agm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aihɨ kaatɨ apopaatɨ nisapiso tatɨ gwɨnyaataatɨ kopɨ noaatɨtandɨhandɨ owetihɨ namatɨ itɨhɨraapɨhɨ notɨ Jisaasihomɨ auhɨraapɨhɨ tɨmahiyataise. Iyatɨ kaatɨ isɨhiya nahatiyaamɨ ndɨhetɨ tanyaaha saapɨ saindɨ Jisaasihoai iwitɨ numwɨhatataayo unda sata kaundataase. “Nɨnɨ Jisaasihoai iwitɨ numwɨhatonɨhɨ nisɨ timbɨpa ketɨ kuraanɨhɨ owenendaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aihɨ kaati Jisaasiho sata kaundataase. “Nisɨ maasɨhaamo kɨnyɨ nisapɨ koai numwɨhatisanɨhɨ nisɨ timbɨpa nenɨmaitaise tɨpɨ gɨnunyaapɨ nihingɨtɨhandaahɨ kinyɨ timbɨpa owesendaise. Isɨ kinyɨ maarɨho wɨhitatɨ yatɨhɨngitatɨ napaisaatɨtonɨhɨ numwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisaasiho taatɨ sata pɨwaatihɨ isɨhiya usa awaisɨho mɨtɨho aŋɨ gwɨharaahonya isɨhiya Autaahaatɨhopɨ gwɨnyaapɨ gaapundɨtaatɨwɨ ahoyanohɨpɨpɨhɨ jatisɨho Jairaasihomɨ aŋɨpɨpɨhapɨhiya napɨwɨ saundawaatopo. “Kinyɨ kimaamaatɨ aimɨ napwisɨ katanyasisɨho nehɨhandɨ napɨtaisɨ kaunde,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Saundauhɨ Jisaasiho atisatosatɨ ko awaisɨho mɨtɨhoai saundataase. “Kɨnyɨ wɨndɨ yamaime. Nisapɨ ko tɨtɨhɨwiwɨtaise tɨpɨ gɨnunyaape kinyɨ kimaamaatɨ japɨhɨ nepaitaiso,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Saundamapɨ Jisaasiho notɨ Jairaasihomɨ aŋɨpɨpɨhɨ noaipatɨ nahatiyai aŋaaŋɨ namandaapɨse undatɨ nehɨ Pitaahotihɨ Jonɨhotihɨ Jemɨsihotihɨ metɨhonjamɨ saniya sapiyaatihɨ siyaisaahɨhɨ Jisaasiho numwaasi maasɨ aŋɨtɨtɨhɨ nandaataise. ");
INSERT INTO agm_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Isɨhiya nahatiya sonjɨ metonjapɨ yiyi tɨwɨ gowaayopo. Gwauhɨ Jisaasiho kiyai saundataase, “kɨmonjɨ metɨmonjɨ aimɨ napomataamaisɨ sahɨ wɨndɨ yiyi tɨwɨ gomaatɨwɨse nehɨ nanotondaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sata Kaundihɨ kiya sunjawaayopo aimɨ napomasɨhonjapɨnyatiso tɨwɨ. ");
INSERT INTO agm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Saiwɨ sisauhɨhandɨ kandɨ Jisaasiho sonjɨ aponyonjamɨ ikwɨrɨ iwiwatata sandaase. “Nisɨ metɨhonjaŋe japɨhɨ nepape,” ndaase. ");
INSERT INTO agm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Satihɨ ketɨ kuraanɨhɨ konjamɨ maarɨho japɨhɨ nasatɨ witihɨ tɨtɨhɨ nepataise. Aihɨ kiyai saundataase. “Kɨmonjɨ metɨmonji nandapa wapa nepɨ nunyawɨse nando,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aihɨ sonjɨ metonjamɨ saniyɨ sapiya sandɨ mmonamaamɨ yaihɨ kapuri Jisaasiho saundataase. “Kɨmandɨ wanɨ nɨnɨ kiyonɨhɨ noaipasɨhɨ mmosɨtɨmandapɨ isɨhiya usai apɨpaahɨ kamundɨmise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisaasiho komɨ otɨpɨpatɨhiya ikwɨ maindɨmwɨtihɨ auhɨramɨ yahurɨtahiyai gaatatɨ numwaatɨ ahoya kiyai pɨwɨha kaundatɨ isɨhiyaamɨhetapɨ itɨpɨho maipɨhapa nemwamapɨ amɨ timbɨpaisahiyai tɨtɨhɨwiwɨtaatɨwɨ watɨpɨhandɨ kiyai nunyataise. ");
INSERT INTO agm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Iyatɨ kiyai natausaasataise kiya nuwɨ Autaahaatɨho isɨhiyai winjaatɨ bimaamɨ naindɨhandapɨha pɨwɨha ausaapɨ kaundɨwɨ amɨ isɨhiyaamɨ timbɨpa nepumaitaatɨwo. ");
INSERT INTO agm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iyatɨ Jisaasiho kiyai sata kaundataase. “Sahɨ nowaawɨ kahapaamapɨpa wɨndɨ mipɨse. Gɨrɨhɨrɨ ikihɨ nandapa bɨretɨhandɨ nawɨho apotɨhɨrɨ niyoaitɨhɨrɨ isɨrɨhɨrɨ sapa wɨndɨ mipɨse. Owetane. ");
INSERT INTO agm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Aiwɨ sahɨ aŋɨhandɨ wɨndaapɨhɨ nuwɨ nandaawaawaahɨ kapɨhɨ nuwɨ nandaahohɨpɨpɨhɨ bimaamɨ nuwɨ kapɨhɨ aunahɨpatɨ namasi nowaawɨ kaaŋɨ aŋaaŋɨ bimohaaŋaaŋɨ namasi nuwɨse. ");
INSERT INTO agm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sahɨ naisaihɨ isɨhiya wɨndɨ maaritɨwɨ namaasamaasaihaahɨ satɨ aunahɨpitɨ sangi isɨhiya namaasamaahohɨpitaahɨ namasi nuwɨse. Namasi nowaawɨ samɨ atasɨhaatɨhɨ ikwaatɨpɨho namaasandisɨho tɨwɨhamapɨ nuwɨse kiya sangi namaasamaahohɨtɨhandapɨ gɨwunyaatɨtando,” undatɨ kiyai natausaasataise. ");
INSERT INTO agm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Saunda ko natausaasihɨ kiya aunahɨpatɨ kahatɨ kahataahɨmapɨ nahataapɨpɨhɨ nuwɨ pɨwɨha gaaha wanɨha ausaapɨ kaundɨwɨ isɨhiyaamɨ timbɨpa nepumapɨ tɨtɨhɨwiwawaapo. ");
INSERT INTO agm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Awaisɨho Erotɨho yapɨpatɨ Garirihandɨ jaatɨ bimisɨho Jisaasiho kaiwaiwaapɨ atisataise. Iyatɨ amɨ ko pɨwɨha wa satɨwɨ katauhɨ atisataise, “Jonɨho aimɨ napwisɨho japɨhɨ nepataise,” tɨwɨ katauhɨ atisataatɨ waatɨ pɨhɨtatɨ gwɨnyaataise. Ko siyatɨ pɨhɨtatɨ gwɨnyaataahandɨ kandɨ tɨtɨhɨ wɨndɨ gɨmunyaase. ");
INSERT INTO agm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aihɨ amɨ usa satawaatopo, “Eraijaaho aimɨ noaipataise,” tawaatopo. Aihɨ amɨ usa satawaatopo. “Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya jɨhɨ aimehuraahiyaamɨ wo wanɨ japɨhɨ noaipataise,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Aihɨ Erotɨho sata kandaase, “Jonɨhoai aimɨ naahutarɨhɨrɨ nisatɨtɨ titɨ yamwaahonɨhɨ aimɨ owetisɨ so diyaamahopɨ katauhɨ nɨnɨ atiso?” ndaase. Iyatɨ ko Erotɨho Jisaasihoai usondandɨ gwɨnyaataise. ");
INSERT INTO agm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aihɨ kiya Jisaasiho otɨpɨpatɨ nunya natausaasisawɨhiya japɨhɨ napɨwɨ noaipapɨ kiya otɨpɨpatɨ kaiwɨ daayotɨhandapɨ pɨwɨha siya siya otɨpɨpatɨ kiyahaayo undɨwɨ kaundawaatopo. Kaundauhɨ isɨhiya usa owetihɨ nehɨ tɨtɨhɨ ikwɨ maindɨmwɨtihɨ auhɨramɨ yahurɨtahiyaisaahɨhɨ Jisaasiho numwaasi nehɨ sawanaahɨhɨ aunahɨpatɨ wɨtɨ katamɨ ambɨpatɨ Betɨsaitaahandaahapɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Niyauhɨ isɨhiya wɨrisandɨhandɨ Jisaasihopɨ sapɨhɨ sihoaaŋɨ naise tauhɨ atisawaawɨ ipotɨ nowaayopo. Niyauhɨ Jisaasiho kiyaapɨ maaritatɨ numwaatɨ Autaahaatɨho isɨhiyai iwinjaatɨ bimaamɨ naindɨhandapɨha pɨwɨha ausaatɨ kaundatɨ amɨ isɨhiya timbɨpaisahiyaamɨ timbɨpa nemwataise. ");
INSERT INTO agm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Aihɨ asahataahura ipɨho aimɨ naihɨ otɨpɨpatɨhiya ikwɨ maindɨwɨtihɨ auhɨramɨ yahurɨtahiya napɨwɨ koai saundawaatopo. “Nandapa kaanɨhɨ ahotatɨ amɨ kɨmbɨhɨ isɨhiya owehapɨhisɨ kɨnyɨ kɨmiya isɨmiya taahɨtɨmandi natɨpusoaase kiya nuwɨ aunahɨpata detɨ nandapa nepɨ nanɨwɨ nanoaitaatɨwo,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Saundauhɨ amɨ ko kiyai wihoaaŋɨha sata kaundataase. “Kɨmiya nandaatɨwɨhapa sahɨ sawanaatɨ nunyawɨse,” undataase. Aihɨ kiya koai wihoaaŋɨha saundawaatopo. “Nyahɨ bɨretɨhandɨ nehɨ ikwɨ naasairɨtihɨ amɨ araiho yahurɨtihɨ ahondaise. Isɨ nyahɨ nowaatɨ isɨmiya kɨmiya nahatiyaapɨ nandapa nawɨho nunya naitɨhaawɨnyatino?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Sapɨhɨ isɨhiya bimohiyɨhiya pɨhɨtɨwɨ 5,000 kaiwɨhiyaare. Aihɨ Jisaasiho komɨ otɨpɨpatɨhiyai saundataase. “Isɨhiya tipɨtapaatɨwɨ kɨhonjɨ kɨhonjaapɨhɨ 50, 50 kaiwɨ bimai nutaatɨwɨ kaundɨwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Saundihɨ kiya otɨpɨpatɨhiya saiwɨ saiwɨ kɨhonjɨ kɨhonjaapɨhɨ bimaawɨse undauhɨ kiya kaiwɨ bimai nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iyauhɨ Jisaasiho bɨretɨhonya ikwɨ naasairɨtahonyaunɨ amɨ araihurɨ yahurunɨ netɨ isɨwatata autaahɨ yamɨhapataatɨhɨ jatata Autaahaatɨhoai gaahoŋe gaare undatosatɨ naumbotɨ komɨ otɨpɨpatɨhiyai nunyataise kiya nesi isɨhiyai nunyawɨ gaamaitaatɨwo. ");
INSERT INTO agm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nunyawɨ gaamahauhɨ kiya nga pɨhɨtɨwɨ nanɨwɨ gaatihɨ ahotimbɨpa naumbwinjɨpɨpa Jisaasihomɨ otɨpɨpatɨhiya asɨwɨ nepɨ ikɨhaiwa ikwɨ maindɨmwɨtihɨ auhɨramɨ yahurɨtahaiwaara kɨpɨwɨ tisaipɨ ahiyawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Waara Jisaasiho nehɨ sawahohɨ taatɨ gaapundihɨ amɨ komɨ otɨpɨpatɨhiya kapɨhɨ maasɨ bindawaayopo. Bimauhɨ kiyai sata nunjenataise. “Nisapɨ isɨhiya diyaamahoe tawaatopo?” undatɨ kiyai nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nunjesɨhɨ kiya koai wihoaaŋɨha saundawaatopo. “Isɨhiya usa kinyapɨ Jonɨho Isɨhiyai Baawusisɨhoe tawaatopo. Iyauhɨ amɨ usa kinyapɨ Eraijaahoe tawaatopo. Iyauhɨ amɨ usa kinyapɨ Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya jɨhɨ aimehuraahiyaamɨ wo japɨhɨ nepahore tawaatopo,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Saundauhɨ amɨ ko kiyai saundataase. “O amɨ sahɨ kɨmiyaatɨ nisapɨ diyaamahoe tawaatopo?” undatɨ nunjenataise. Nunjesɨhɨ Pitaaho wihoaaŋɨha sata kaundataase. “Kɨnyɨ Isɨhiyai Japɨhɨ Numwaitaapɨ Autaahaatɨho Ahɨngisɨhoŋɨ Kɨraisihoŋe,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pitaaho Jisaasihoai Kɨnyɨ Kɨraisihoŋe undindɨmandapɨ isɨhiyai ausaapɨ wɨndɨ apɨpaahɨ kamundɨmapɨse undatɨ Jisaasiho komɨ otɨpɨpatɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kaundatɨ amɨ kiyai ko saundataase. “Isɨhiyaamɨ Awaisɨhonɨnɨ Saahonɨnɨ Jɨhonɨnɨ ambɨpatɨ yaasahandɨ pɨhɨndɨ naito. Isɨhiya mɨtɨhiya gwɨnyaahiyaunɨ amɨ isɨhiya isɨhiyaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai waamaitumapɨ dɨpumanɨhohiyɨhiyaamɨ awaisawɨhiya jɨhiya mɨtɨhiyaunɨ amɨ isɨhiya Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ nɨngi ahosɨnɨmaitaapo. Ahosɨnɨmapɨ nɨngi nɨwisaihɨ napwɨto. Nɨwisaihɨ napomatatɨ asisɨha mairɨma saniyonɨhɨ japɨhɨ nɨnɨ asohonimandɨ nepaito,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Saundatosatɨ amɨ komɨ otɨpɨpatɨhiya nahatiyaisunɨ amɨ isɨhiya usaisunɨ sata kaundataase. “Isɨhiya usa nisɨ otɨpɨpatɨ kaniwɨ amɨ nɨngi nanipinjɨtaatɨwaahɨ sawanaapɨ nanɨpimatɨwɨ ipɨ tɨtɨhɨ atawɨhatɨ nɨnɨ katetɨ napwɨtandɨhatɨ tɨpwɨtohɨpatamataiwɨ kiya yaawɨhaiwa nepɨ napwɨtaatɨwɨhatɨ asisɨha nahatewetɨ nepɨ tɨpwɨtɨwɨ nanipinjawɨse. ");
INSERT INTO agm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nɨnɨ sandɨ apaapɨmaato amɨ isɨhiya usa kiyaamɨ kɨmaapɨ bimɨtaatɨwɨhandapimatonɨhɨ kandapɨ gwɨnyaawaawɨ kandɨ anɨtiwɨ isɨwatawaawaahɨ amɨ sandɨ kandapɨ kiya ipotɨhura asɨyaimatɨwɨ Autaahaatɨhoaisawɨ jinjapɨhɨ bimɨtaatɨwɨhandɨ wɨndɨ namepɨ nihɨrɨtaapo. O amɨ isɨhiya usa nisapimatonɨhɨ kiyaamɨhapa namapɨ nanɨpimatɨwɨ nisɨ otɨpɨpatɨhɨ kaniwɨ nɨngi nanipinjawaawaahɨ amɨ kiya ipotɨhura asɨyaimatɨwɨ Autaahaatɨhoaisawɨ jinjapɨhɨ bimɨtaatɨwɨhandɨ naitaapo. ");
INSERT INTO agm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Amɨ utaaho wo maapɨ yapɨpatambɨhapa pɨhɨtatɨ netɨ ahoyatɨ isɨwatataataahɨ sawaho netɨ nopɨsasɨnatɨ owematataise. Isɨ amɨ kahapaamapɨpa ko isɨwatimbɨpa napitiyatɨ koai andɨtɨwiwɨtaise? Amɨ kaiwaahɨ koai wɨndɨ andɨtɨmaawiwɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","O amɨ utaaho wo nisapunɨ nisɨ pɨwɨhaapunɨ mawataataahɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ Awaisɨhonɨnimandɨ nisɨ awaindɨ nausaatatɨ saasanotindɨhandɨ yundanyɨha otiwa kambwaatɨ watɨpɨhandisatunɨ amɨ nisɨ Apɨho Autaahaatɨhomɨ nausaatatɨ saasanotindɨhandɨ watɨpɨhandɨ yundanyɨhaisatunɨ amɨ Apɨho Autaahaatɨhomɨ otɨpɨpatɨhiya yamɨhapataatɨhɨ bimohiyɨhiyaamɨ nausaatatɨ saasanotindɨhandɨ watɨpɨhandɨ yundanyɨha otiwa kambwaahaiwaisatunɨ nasataahura utaaso sopɨ nɨngi manyɨtaise. Manyonɨhɨ amɨ nɨnɨ kopɨ satɨto, ‘soai nɨnɨ wɨndɨ mausotɨhoe. Amɨ ko nisɨ otɨpɨpatɨhomaahe,’ tɨto. ");
INSERT INTO agm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nɨnɨ akɨtɨnɨhɨ sangi sandɨ kasatataato. Sahɨ isɨhiyaatɨ wanɨ kɨmbɨhɨ bitohohiyɨmiyaatɨ usaatɨ sangɨ napopɨ bindawaawɨ Autaahaatɨho isɨhiyai iwinjaatɨ bimindɨhandɨ asisɨha ipotɨhetɨ noaipahonɨhɨ mmondaapo,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisaasiho kiyai pɨwɨha satatɨ kaundatosatɨ bimihɨ asisɨha ikwɨ naasairɨtihɨ winɨnɨhɨramɨ mairɨma aimɨ sanaihɨ Pitaahoaisunɨ Jonɨhoaisunɨ Jemɨsihoaisunɨ kingwaasi numwaasi gaapundɨtandɨ sisɨhoaasɨnapɨ niyataise. ");
INSERT INTO agm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Niyatɨ kasɨnɨ sisɨhoaasɨnɨ gaapundatɨ bimihɨ komɨ ndɨmaahomwaaŋɨ noaipatɨ awaindɨ nausaatamataise. Iyataatɨ amɨ komɨ apotɨhɨrɨ noaipatɨ apɨpaahɨ kɨhoepɨtatɨ kɨnapɨpaamatiyatɨ nausaatamataise. ");
INSERT INTO agm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aihɨ nehɨ ketɨ kuraanɨhɨ utaahurɨ wurɨ noaipapɨ koaisamɨ maasɨ taamɨ pɨwaatamaise. Surɨ utaasurɨ Mosesiyɨ Eraijaayaare. ");
INSERT INTO agm_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kurɨ yamɨhapataatɨhapɨ yundanyɨha otiwa kambwaatɨ nausaatɨhapaisamɨ namɨ bitotama Jisaasihoaisamɨ pɨwanamaase ko Autaahaatɨho maaritatɨ gwɨnyaasɨpɨpa netɨ akɨpɨpematɨ Jerusaremɨhanda napotɨ kiyamapɨ yamɨhapataatɨhapɨ yapɨpataapɨhɨ namasi naitandɨhandapɨ pɨwanɨwɨ kaundamaase. ");
INSERT INTO agm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitaahoaisunɨ komɨ sasaahohurisunɨ apɨpaahɨ naawamasɨhɨ kingwaasɨ nanopotawaayopo. Nanopotɨmbɨwɨ nepapɨ jawa Yundanyɨha Jisaasihomɨhetapunɨ amɨ utaahurɨ Jisaasihoaisamɨ bitosururamɨhetapunɨ apɨpaahɨ nausaatamasɨhɨ jawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kurɨ taamɨ Jisaasihoai numwasi naihɨ Pitaaho Jisaasihoai saundataase. “Katɨpinyasingɨhonye, nyahɨ kɨmbɨhɨ gaanɨhɨ bindɨhaanyonɨ gaasɨ aŋaaŋɨ gohɨhaaŋɨ kinyapɨ waanɨtanɨhɨ Mosesihopɨ waanɨtanɨhɨ Eraijaahopɨ waanɨtanɨhɨ anɨsamatɨtaano,” undataase. Pitaaho sandɨ mmonataatɨ ko pɨwɨha katɨtandɨha owetihɨ sa pɨwɨha kandaase. ");
INSERT INTO agm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pɨwɨha sa Pitaaho taatɨ satatɨ katihɨ tɨwipatɨ nasatetɨ kingwaasi bopɨhataise. Bopɨhihɨ kingwaasi tɨwipatɨ numwaasasɨhɨ yaiwɨmawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yaiwɨmɨhauhɨ katɨhɨ tɨwipataatɨhapɨ pɨwɨha wa sataha noaipataise. “Kɨmo Nisɨ Maasɨhɨho Nɨnɨ Namɨhandɨ Ahɨwisohɨhosɨ ko pɨwɨha katonɨha sahɨ atɨwiwɨse,” taha noaipataise. ");
INSERT INTO agm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pɨwɨha sataha noaipatɨ owetihɨ jawa Jisaasiho nehɨ sawahohɨ bitosɨhɨ iwinjawaapoyo. Sandɨ siyatɨ noaipasɨhɨ mmonɨhotɨhandapɨ otɨpɨpatɨhingwaasɨ sura siyahandɨ noaipasɨhɨ mmonɨhaayo tɨwɨ ausaapɨ wɨndɨ usai kamundopo. Owetise. ");
INSERT INTO agm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Saiwɨ bimambɨwɨ bowihɨ sisɨhoaasɨnɨ namasi noaatɨpapɨ nasauhɨ isɨhiya wɨrisandɨhandisawɨ mɨhaapɨ sisɨhomɨ auhɨraapɨhɨ nutanawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nutanɨwɨ utaaho wo isɨhiya wɨrisandɨhandamɨ otɨhatɨhapɨ waatɨ kaahaata sandaase. “Katɨpinyasingɨhonye, nɨnɨ metɨho nehɨ naasohɨtahonɨnisɨ koai kɨnyɨ usondaapɨ nɨnɨ watɨpɨndɨ nangɨsenataayo. ");
INSERT INTO agm_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Asisɨha taahɨwaiwetɨ itɨpɨho maipɨho nisɨ metɨhomɨhetɨ nandaatɨ isɨwatata netɨ nusopɨsasihɨ ko yayatɨ itiwatɨ waatɨ kaahandaase. Iyatɨ itɨpɨho ko metɨhoai netɨ kɨsɨhɨsɨwisatɨ pimbapowisatɨ netɨ yotihɨ maahomwaaŋapɨ sisipa maahoairɨhɨrɨ kiyataise. So itɨpɨho maipɨho nisɨ metɨhoai wɨndɨ namumwaase. Owe. Nehɨ konɨhɨ bindata nisɨ metɨhoai nanusopɨsasataise. ");
INSERT INTO agm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Saihɨ nɨnɨ kinyɨ otɨpɨpatɨhiyai itɨpɨho maipɨho soai nemaitaatɨwɨ watɨpɨndɨ kaundonɨhɨ kiya wɨndɨ nepumaamahopo, owetise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Saundatɨ kaundihɨ Jisaasiho kiyai saundataase. “Sahɨ wanɨ kɨmuraamiyaatɨ nisapɨ wɨndɨ andɨtitɨwɨ watɨpɨtɨwɨ ko nyangi nga nyatatamanɨtaiso tɨwɨ gɨmaanunyaapɨ amɨ samɨ maarɨho amɨtɨha gwɨnyaahohɨtɨhandɨ apɨpaahɨ maipe. Nɨnɨ napitaindɨhaiwaara sangisatɨ maasɨ bindata samɨ naaŋiwaiwa nesamaitande? Kinyɨ kimwaahoai numwaasi kɨmbɨhɨ namme,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Numwaasi namme undihɨ ko metɨhoai sapɨho numwaasi taatɨ Jisaasihoaapɨhɨ naihɨ itɨpɨho maipɨho metɨhoai netɨ kɨsɨhɨsisatɨ waatɨ wonamaatɨhɨ yapɨpatetɨ netɨ yotamataise. Saihɨ Jisaasiho itɨpɨho maipɨhoai itɨhundatɨ nematɨ so metoai netɨ tɨtɨhɨwiwatɨ sapɨhoai japɨhɨ netɨ nusoaasataise. ");
INSERT INTO agm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Saihɨ isɨhiya sandɨ Autaahaatɨhomɨ watɨpɨhandɨ siyatɨ noaipasɨhɨ mmonawa yaiwɨ aatɨmawaayopo. Aihɨ kiya isɨhiya nahatiya Jisaasiho kaindɨhandapɨ taawɨ pɨhɨtɨwɨ aatɨwɨmapɨ gwɨnyaahauhɨ Jisaasiho komɨ otɨpɨpatɨhiyai saundataase. ");
INSERT INTO agm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kɨma pɨwɨma nɨnɨ sangi kasatɨtandiyohɨma sahɨ baiwɨ atiwɨ nepɨ gwɨnyaapɨse. Nɨnɨ Isɨhiyaamɨ Awaisɨhonɨnɨ Saahonɨnɨ Jɨhonɨhi isɨhiya nepɨ awaisawɨhiyaamɨ ikwɨraatɨnɨmaitaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Satatɨ kaundihɨhandɨ kandɨ kiya komɨ pɨwɨha sata kaundisɨhaapɨ wɨndɨ biyatɨ gɨmaawunyaata namusesɨpainjɨhɨ wɨndɨ gɨmunyaahopo. Owetise. Iyataatɨ amɨ sa pɨwaamɨ tanyaaha wɨndɨ amusaimanatɨ noaasandihɨhaasɨ kiyai wɨndɨ gɨmaawunyainje. Amɨ Kiya yayawaawɨ pɨwɨha kaapɨ wɨndɨ baiwɨ namunjenɨhopo. Owetise. ");
INSERT INTO agm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisaasihomɨ otɨpɨpatɨhiya sawana nyamɨ awaisɨho jɨhimatisɨho diyaamahoe tɨwɨ kanawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Satɨwɨ kanɨhaunɨ namatɨ kandapɨ Jisaasiho kiyai usonatosatɨ metɨhonjɨ wonji numwaatɨ komɨhinɨ detɨ ahɨwihɨ bitondaise. ");
INSERT INTO agm_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Bitosɨhɨ kiyai ko sɨwipatɨ namɨhanatɨ saundataase. “Metɨhonjɨ kɨmonji wowaatɨ numwaatɨ nisapimatonɨhɨ konjɨ Jisaasihomɨhonjiso tatɨ andɨtɨwiwatɨ iwɨtatamanataataahɨ sandɨ nɨngi ko kaatɨ nanɨmaatɨ nɨtatamanataise. Iyatɨ amɨ nɨngisaahɨhɨ nanɨmaatɨ nɨtatamanataamaise. Owetise. Amɨ Apɨho Autaahaatɨho nɨngi natanoaasihɨ nasohɨhoaimaawɨ numwaatɨ iwɨtatamanataise. Isɨ samɨ otɨhatapɨ wo noaipatɨ isɨhiyaamɨ ndɨhetɨ ambɨpatɨ awaipatɨ oweho nehɨhotisɨho so noaipatɨ samɨ otɨhatɨhɨ awaisɨho jɨhoematɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Aihɨ Jonɨho Jisaasihoai saundataase. “Nyainjatingɨhonye utaaho wo kinyɨ ambɨpataahɨ itɨpɨho maipɨhapa isɨhiyaamɨhetɨ bimimbɨpai nemwasɨhɨ usonɨhaawɨ ko nyangisahometihɨ owe saimbɨ kɨnyɨ kamaime undaatɨ nɨwisapuwɨhaayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Saundihɨ Jisaasiho koai saundataase. “Sahɨ napaapɨ koai nɨwisapuwawaawe. Utaaho wo sangi ahosɨsamatɨ namaasisapuso so samɨ naisohore,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisaasihoai Autaahaatɨho yamɨhapataatɨhapɨ numwaasi naitandɨhura aimɨ detɨndaise. Detɨtihɨ amɨ ko komɨ maarɨho naasohɨtihɨ watɨpɨtatɨ Jerusaremɨhandaahapɨ nutandɨ maarɨho nusoaasatɨ gwɨnyaataise. ");
INSERT INTO agm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Siyatɨ watɨpɨtatɨ gwɨnyaatɨ ko isɨhiya usai pɨwɨha kaundatɨ natausaasihɨ kiya jɨhɨ nowaayopo. Nuwɨ isɨhiya usa Samariyaahiyaamɨ aunahɨpatɨ wɨta noaipawaayopo. Noaipapɨ Jisaasiho nanoaitandɨhapɨhɨ kahapaamapɨpa tɨtɨhemaitotɨwɨyawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Saiwɨ kaitotɨwɨyauhɨhandɨ kandɨ satɨ aunahɨpitaahapɨhiya isɨhiya Jisaasihoai kiyaamɨ aŋɨpɨpɨhɨ aunahɨpata maaritɨwɨ numwaitaatɨwɨhandapɨ poundataise. Sandɨ kiya Jisaasihopɨ Jerusaremɨhandaahapɨ notaahoso tɨwɨ gwɨnyaawaawe. ");
INSERT INTO agm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Siyauhɨ namapɨ Jisaasihomɨ otɨpɨpatɨhurɨ Joniyɨ Jemɨsiya sandɨ mmonamaamɨ Jisaasihoai kurɨ saundɨmɨ nunjenamaise. “Awaisɨhoŋe, kɨmiya saiwɨ nyangi kanyɨsotɨmandapɨ nyahɨ yamɨhapataatɨhapɨ sisɨha nasane tisaihɨ nasatɨ isɨmiya kɨmiyai tɨhatɨ owemaitandɨ gaaro?” undɨmɨ nunjenamaise. ");
INSERT INTO agm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Saimɨ kurɨ nunjesɨhandɨ kandɨ Jisaasiho kuri nepemaitatɨ satɨmɨ sahuraahɨ napaapɨ katise undatɨ itɨhundataase. ");
INSERT INTO agm_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Itɨhundihɨ kapɨhɨ namasi aunahɨpata wɨtaahapɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Saiwɨ kiya taawɨ daihɨra nowaawɨ utaaho wo koai saundataase. “Kɨnyɨ naingɨpɨpɨhɨ nahataapɨpɨhɨ amɨ nɨnɨ nangipinjai napɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Saundihɨ koai Jisaasiho wihoaaŋɨha saundataase. “Suhɨrɨ ainjɨhɨrɨhɨrunɨ kohounɨ akosɨha aŋaaŋɨ itɨha ahetahapaare. Iyataahandɨ kandɨ Nɨnɨ Isɨhiyaamɨ Awaisɨhonɨnɨ Saahonɨnɨ Jɨhonɨnɨ nisɨ mɨtɨho ahiyatɨ nanoaitandɨhaaŋɨ aŋaaŋɨ apɨpaahaaŋɨ owehonɨne,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Saundatɨ ko Jisaasiho woai saundataase. “Kɨnyɨ nɨngi nanipinje,” undataase. Saundihɨhandɨ kandɨ ko saundataase. “Nɨnɨ nundɨ nisɨ apɨhoai jɨhɨ yamwaamapɨhura napɨtaanɨ kɨnyɨ gaare dɨtaino?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Aihɨ Jisaasiho komɨha wihoaaŋɨha koai saundataase. “Napohiyɨhiya sawana kiyaamɨ ambɨpatɨ nepɨ yamwaatɨwɨse. O amɨ kɨnyɨhɨ numbwɨ Autaahaatɨho isɨhiyai iwinjaatɨ bimindɨhandapɨha pɨwɨha ausaapɨ isɨhiyai kaunde,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Saundihɨ amɨ wo Jisaasihoai saundataase. “Awaisɨhoŋe, nɨnɨ gi nangipinjai napɨtandiyo. Saindɨ gwɨnyaataahandɨ kandɨ nɨnɨ jɨhɨ nundɨ nisɨhiyai ikwɨrɨ ahowindɨ kaindɨmapɨ napɨtaanɨ gaare dɨtaino?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Saundihɨ Jisaasiho komɨha wihoaaŋɨha koai saundataase. “Utaaho mandosihihoaaŋɨ jaatɨ tɨtɨhɨ notaahandɨ kandɨ japɨhɨ nepemaitatɨ dawaataatɨ jatɨ kiyataatɨ Autaahaatɨho isɨhiyai iwinjaatɨ bimindɨhandamɨ otɨpɨpatɨ wɨndɨ biyatɨ kamaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Saiwa siyatɨ aimɨ owetihɨ Awaisɨho isɨhiya usa taahiyɨhiya 72 kaiwɨhiyai aunahɨpa nahatewaara natiwɨ daimɨ nutaatɨwɨ namɨhanataise. Namɨhanatɨ komɨ jɨhɨ yahwɨ yahwɨ aunahɨpatɨ kahatɨ kahataahapɨ sawaho ipotɨ nutandɨ tɨmetiwaiwaaraahapɨ netɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Natausaasataatɨ Jisaasiho kiyai satatɨ kaundataase. “Osaataatɨ nandapa akuraayatɨ asakendaise. Siyatɨ nandapa asakendaahandɨ kandɨ nandapa kapa kupɨwɨ ahoaiwɨ naasaimbɨpɨmaitaatɨwɨhiya isɨhiya wɨndɨ taahiyɨyaamaahe, owe, nehɨ naasiyaahɨhe. Isɨ sahɨ osaataatamɨ satɨhopɨ gaapundɨwɨse ko osaataatamɨ satɨho isɨhiya taahiyɨhiya kapa nandapa kɨpɨwɨ nepɨ naasaimbɨpɨhɨmapɨ ahoaitaatɨwɨhiyai sawaho natausaasɨtando. ");
INSERT INTO agm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sahɨ nuwɨse Sipɨsipɨhandɨ mwaahomataiwɨhiyaatangi suhɨrɨ ainjɨhɨrɨhɨramɨ otɨhapɨhɨ nɨnɨ nandɨsisoaasataayono. ");
INSERT INTO agm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sahɨ nawɨhomɨ ikihɨ nawɨhoaisahɨhunɨ amɨ nandapaapɨ ikihunɨ amɨ asuipatunɨ wɨndɨ mipɨ nehɨ taanahiyaatɨ nuwɨse. Aiwɨ nowaawɨ isɨhiya daihɨra nutanawaahiyai ipɨhɨrete undɨwɨ pɨwaamundɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Aiwɨ sahɨ nuwɨ aŋɨhandɨ wɨndaatɨhɨ nandaawaawaahɨ sandɨ aŋɨndɨ nandaahotɨndaatɨhɨ isɨhiya bimohiyɨhiyai sangɨ pɨwaundɨwiwatawa jɨhɨ saundɨwɨse. ‘Sahɨ kɨmandɨ aŋɨmandaatɨhɨ bimohiyɨhiyaate, sangi Autaahaatɨho gaahandɨ kasisatɨ amɨ samɨ maarɨho ambɨpatɨ netɨ japatisa yatɨhɨsiwatɨ napaisaatisamane,’ undɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Saundisaihɨ amɨ sandɨ aŋɨndaapɨhɨ utaaho wo komɨ maarɨho ambɨpatɨ biyatɨ yatɨhɨwitatɨ napaisaatɨtaho bindataataahɨ samɨ pɨwɨha kiyai kaundohɨha komɨhetɨ niyonɨhɨ komɨ maarɨho ambɨpatɨ biyatɨ yatɨhɨwitatɨ napaisaatumatɨtaise. O amɨ utaaho siyaho wo sapɨhɨ bɨmindataataahɨ amɨ samɨ pɨwɨha satɨwɨ samɨ maarɨho ambɨpatɨ biyatɨ yatɨhɨsitatɨ napaisaatɨtane undɨwɨ kaundohɨha nepemaitatɨ japɨhɨ nasatɨ sahɨ sawanaatamɨhetɨtɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Saundɨwɨmapɨ nandaapɨ sahɨ aŋɨhandɨ bimotɨhandɨ kandɨ naasaindaapɨhɨ bimaawɨse. Bindawaawɨ nandapa waapoho kapɨhɨ aŋɨndaatɨhɨ sahɨ bimohɨpɨpɨhɨ bimohiyɨhiya nasamisaihɨ nanɨwɨse. Amɨ sapa nandapa samɨ otɨpɨpatɨ kaiwɨ daayotɨhandapɨ nasanyawaayowo. Amɨ utaaho otɨpɨpatɨ wɨtɨ kaisɨho nawɨho nesɨtɨhandiso. Aiwɨ aŋɨhandɨ kɨhandɨ kɨhandaapɨhɨmapɨ namuwɨse. ");
INSERT INTO agm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Amɨ sahɨ nuwɨ aunahɨpatɨ taunɨhandɨ wɨnda noaipasaihɨ isɨhiya sandɨ taunɨndaahapɨhiya sapɨ maaritɨwɨ nasamaapɨ nasamaasi kiyaamɨ aŋɨpɨpɨhɨ nuwɨ nandapa nasanyohɨpɨpa nepɨ nanɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aiwɨ amɨ sahɨ satɨ aunahɨpatɨ taunɨndaahapɨhiya isɨhiya timbɨpaisahiyai kiyaamɨ timbɨpa nepumapɨ tɨtɨhɨwipɨse. Aiwɨ kiyai saundɨwɨse. Autaahaatɨho isɨhiyai iwinjaatɨ bimaamɨ naindɨhandɨ wanɨ aimɨ detɨ samɨhinɨ nasatɨ ahondaise undɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","O amɨ sahɨ aunahɨpatɨ taunɨhandɨ wɨnda nuwɨ noaipasaihɨ isɨhiya sandɨ taunɨndaahapɨhiya sapɨ wɨndɨ maarɨmitɨwɨ nasamaasi kiyaamɨ aŋɨpɨpɨhapɨ namaisaihaahɨ sahɨ nuwɨ sandɨ taunɨndamɨ daihɨra bitotawa satɨwɨ katɨwɨse. Kɨmandɨ taunɨmandaahapɨ yapɨpatɨ ikwaatɨpɨho nyamɨ auhɨramɨ atasɨhaatɨhɨ nanyamɨhatisɨho nyahɨ namawa ko ikwaatɨpɨho tɨwɨhaawa japɨhɨ sawanaatamɨhetɨmahaayo. ");
INSERT INTO agm_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Iyahaahandɨ kandɨ sahɨ baiwɨ atiwɨse. Autaahaatɨho isɨhiyai winjaatɨ bimaamɨ naindɨhandɨ aimɨ nasatɨ detɨ ahondaise undɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Amɨ nɨnɨ sangi akɨtɨnɨhɨ sandɨ kasatataato. Isɨhiyai Autaahaatɨho netɨ tipɨtapaatɨ usondandɨ ko asisɨha namɨhainjɨhetɨ sandɨ taunɨndaahapɨhiyai yaawɨhandɨ apɨpaahɨ awaindɨhandɨ numwɨtaise jɨhura isɨhiya Sotomɨhandaahiyai numwindɨhandɨ nusatipɨhaatɨ apɨpaahɨ awaindɨhandɨ nunyonɨhɨ kiya naitaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Iyatɨ Jisaasiho sandaase. “Ese apɨpaahɨ sahɨ isɨhiyaatɨ Korasinɨhandaahunɨ Betɨsaitaahandaahunɨ bimohiyɨhiyaate, nɨnɨ kɨmbɨhɨ samɨ aunahɨpɨmatɨ taunɨmanda watɨpɨhaiwa kiyohɨwɨmaiwaamatiyatɨ utaaho wo Taiyaahandaahunɨ Saitonɨhandaahunɨ watɨpɨhaiwa kiyonaahɨ isɨhiya saurɨ taunauraahaapɨhiya ketɨ kuraanɨhɨ apotɨhɨrɨ maarɨho asɨpaiwɨ gwɨtaatɨwɨhɨrɨ niyopɨ detɨ sisɨhainɨ bindawa waatɨpatɨ nopiyanɨwɨ gwɨwɨ nepemaitɨtauhe. ");
INSERT INTO agm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Autaahaatɨho isɨhiyai netɨ tipɨtapaataahura isɨhiya Taiyaahandaahiyaunɨ Saitonɨhandaahiyaunɨ yaawɨhandɨ gotɨ nesaihɨ amɨ sahɨhɨ kiyai nusatipɨhaapɨ apɨpaahɨ waatɨ awaindɨhandɨ naitaapo. ");
INSERT INTO agm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iyataatɨ amɨ sahɨ Kapaniyaamɨhandaahiyaate, sangisaahɨ isɨhiya nepɨ taunɨhandɨ apɨpaahɨ kandi awaindɨhande tɨwɨ autaahɨ yamɨhapataatɨhepɨsamaamaitaapo. Owetɨtaise. Sangi Autaahaatɨho netɨ daahɨ mɨmaipɨsisatɨ nasopɨsasamaitaise,” ndaase. ");
INSERT INTO agm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Satatosatɨ Jisaasiho komɨ otɨpɨpatɨhiya natausaasɨtandɨhiyai saundataase. “Utaaho wo samɨ pɨwɨha atɨsisɨho so nisɨ pɨwɨhaisangi atɨnisataise. O amɨ utaaho wo samɨ pɨwɨha wɨndɨ atɨhomaasisatɨ sapɨ ponje tatɨ ahosɨsamasɨho so mɨkandɨ amɨ nisapimaawɨ poundihɨ ahosɨnɨmaitaise. Utaaho nisapɨ poundihɨ ahosɨnɨmaso so amɨ mɨkandɨ nɨngi natanoaasihɨ nasohɨhopɨ poundihɨ koai ahosumwataise,” undatɨ kiyai natausaasataise. ");
INSERT INTO agm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Isɨhiya usa taahiyɨhiya 72 kaiwɨhiyai Jisaasiho otɨpɨpatɨ nunyatɨ natausaasihɨ niyohiyɨhiya apɨpaahɨ awaindɨhandɨ maaritɨmɨ japɨhɨ nasawaayopo. Kiya napɨwɨ satawaatopo. “Awaisɨhonye, nyahɨ kinyɨ ambɨpatɨ ambɨhɨtonɨhɨ itɨpɨho maipɨhapaisangi nyamɨ pɨwɨha bɨpi atɨnyisataise,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Saundauhɨ Jisaasiho kiyai wihoaaŋɨha sata kaundataase. “Nɨnɨ Bwaasɨrɨhɨrisɨ iwinjahonɨhɨ amɨ kɨrɨ yamɨhapataatɨhapɨ kɨnapɨpaamatiyatɨ kɨnapaahinɨmɨ tɨmɨhaise. ");
INSERT INTO agm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sahɨ atiwɨse. Nɨnɨ sangi aimɨ apɨpaahɨ watɨpɨhandɨ nasanyataayo akwɨranɨho amɨ akosɨho sapai itɨpapɨ kapaamɨ autaahɨ daisaihɨ kapa sangi wɨndɨ ikomaasawɨtando. Aiwɨ amɨ sahɨ samɨ tiworɨho yapɨpatambɨhomɨ watɨpɨhaiwa nahatewai ipɨhatiwɨmaitaatɨwɨ watɨpɨhandɨ aimɨ nasanyataayo. Sahɨ saisaihɨ sangi wapa netɨ ipɨhatisamaamaitaise. ");
INSERT INTO agm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amɨ sandɨ itɨpɨho maipɨhapa samɨ pɨwɨha atɨsindɨndapɨ itɨpɨho maipɨhapa nyamɨ pɨwɨha atɨnyisataiso tɨwɨ sahɨ maarɨmitɨwɨse. Nehɨ sahɨ satɨwɨ nyamɨ ambɨpatɨ yamɨhapataatɨhɨ Autaahaatɨho aimɨ jɨpatɨpinyisatɨ ahɨnyihɨhiyaaniso tɨwɨ maaritɨwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aihɨ ketɨ suraanɨhɨ Autaahaatɨhomɨ Itɨpɨho Gaaho Jisaasihoai maaritɨtandɨhandɨ numwihɨ ko Jisaasiho sata kandaase. “Apore, yapɨpatamunɨ yamɨhapatamunɨ Awaisɨhoŋe. Gi nɨnɨ kɨnyɨ gaahoŋe gaare hɨtɨtɨ mepɨ autaahehɨmataayo. Amɨ kɨnyɨ isɨhiya amɨtɨha awaindɨhandisawɨhiyaapunɨ amɨ isɨhiya isɨhiya usai katɨwunjauhɨ mmonɨwɨ nehohiyɨhiyaapunɨ anɨtimbɨ nepɨ saiwa noaasapaapɨ amɨ kaiwa wanɨ Kɨnyɨ isɨhiya kiyaamɨ amɨtɨha maarɨho manyinyaamataiwɨhiya masɨhonya gwɨnyaahohiyɨhiyai nepɨ nunjinɨho. Ye akɨte Apore. Kɨnyɨ gwɨnyaapɨ maaritingɨrɨhɨretɨ sɨkɨrete. Isɨ kɨnyɨ kɨretɨ kiyapaise,” ndaase. ");
INSERT INTO agm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Satatosatɨ amɨ sandaase. “Kahapaamapɨpa nahataapa Apɨho nɨngi naninyataise. Iyataatɨ nɨnɨ komɨ mwaahonisapɨ utaaho wo mmonatɨ netɨ gɨmaawunyainje. Amɨ nehɨ nisɨ Apɨhohɨhɨ nɨnɨ komɨ mwaahonisapɨ mmonatɨ gɨwunyaatahore. Iyataatɨ amɨ nisɨ Apɨhopɨ isɨhiya wɨndɨ mmonɨwɨ gɨmaawunyainje. Nehɨ nɨnɨ komɨ mwaahonɨnɨhɨ Apɨhopɨ mmonɨtɨ gɨnunyaatahonɨne. Isɨ amɨ isɨhiya usai nɨnɨ komɨ mwaahonɨnɨ nisɨ gwɨnyaatɨ maaritotɨhandaahɨ nisɨ Apɨho siyatɨ setahore undɨtɨ kometirɨhɨretapɨ netɨ kiyai nunjisanɨhiyaisaahɨhɨ nisɨ Apɨhopɨ kiyai gɨwunyaatatɨ nusesɨpatonɨhɨ mmondaapo,” ndaase. ");
INSERT INTO agm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sandɨ satatosatɨ amɨ sapɨhɨ komɨ otɨpɨpatɨhiyaimaawɨ bimauhisɨ kiya nehɨ sawanaahɨ yatɨhɨ bindawa Jisaasiho nepemaitatɨ kiyai saundataase. “Sahɨ kɨmaiwa mmonɨhohɨwɨmaiwaapɨ amɨ nyahɨ gaanɨhɨ kɨmaiwa mmonɨhaayo tɨwɨ maaritɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Amɨ nɨnɨ sangi sandɨ kasatataato. Sahɨ wanɨ kɨmaiwa noaipasɨhɨ taawɨ mmonɨhohɨwɨmaiwa mmondotɨwɨ awaisawɨhiya yapɨpatɨ isɨhiyai winjaawɨ bimohiyɨhiyaunɨ amɨ isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaunɨ jɨhura maaritawaahandɨ kandɨ kiya wɨndɨ mohopo. Aiwɨ amɨ kiya pɨwɨha kɨma sahɨ wanɨ taawɨ atisohɨma kiya atitaatɨwɨ maaritawaahandɨ kandɨ kiya wɨndɨ atɨhomisopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wura utaaho wo Judaahiyaamɨ wɨnɨhapɨpa kataunjisɨho Jisaasihoenda ko pɨwɨha napitiyaha kandise tatɨ jaiwiya pɨwɨha wa nunjendandɨ nasataise. Ko nasatɨ Jisaasihoai sata nunjenataise. “Katɨpɨnyasingɨhonye, nɨnɨ nɨnapitiyataatɨnɨhɨ asohonimatɨtandɨhandɨ netɨ nasisoaarɨ bimɨtande?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nunjesɨhɨ Jisaasiho koai saundataase. “Pɨwɨha wɨnɨhapɨpaatɨhɨ napitɨtaha jɨpatɨpindihɨ kɨnyɨ awɨtɨpɨ mmonapaise? Aimbɨ amɨ ka pɨwɨha napitɨtaha ahotihɨ awɨtɨpɨ mmonapaise?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Saundihɨ ko wɨnɨhapɨpa kataunjisɨho wihoaaŋɨha sata kaundataase. “Kɨnyɨ Autaahaatɨhoai kinyɨ omaŋɨtɨtɨhɨ kandɨnɨhɨ amɨ kinyɨ maarɨho nahato konɨhɨ amɨ kinyɨ andɨtatɨ andɨtitingɨtɨhandɨ watɨpɨhandɨ kandɨhɨ amɨ kinyɨ gwɨnyaahingɨtɨhandɨ kandɨnɨhɨ saiwa nahatewa komɨhetɨ niyonɨhɨ kinyɨ Awaisɨho Autaahaatɨhoai maarɨho nunye. Aimbɨ amɨ kɨnyɨ isɨhiya kinyɨhiya aunahɨpatɨ yapɨpatɨ naasaipitɨ kataahapɨhiyai maarɨho nunye amɨ kɨnyɨ kɨwahoŋɨ kinyɨ maarɨho kinyɨ ambɨpati nunyapɨ itatamanɨhingɨpatamataimbo tatɨ jɨpatɨpindise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Saundihɨ Jisaasiho koai saundataase. “Kɨnyɨ tɨtɨhɨ akaaha nga katapaase. Isɨ kɨnyɨ wanɨ katingɨpatamataimbɨ tɨtɨhɨ kiyapaapaahɨ asohoŋimatɨpɨ nasisoaarɨ bimɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sata kaundihɨhandɨ kandɨ ko wɨnɨhapɨpa kataunjisɨho sawaho Jisaasihoai nunjesɨtɨhandapɨ siyatɨ gwɨnyaataise. Wiwa nisapɨ Jisaasiho satatɨ ko nɨngi nanisesɨtɨhandamɨ wihoaaŋɨhandɨ gwɨnyaahondaahandɨ kandɨ amɨ ko nɨngi napindapɨ nanisese tɨtaiso taunyaatɨ Jisaasihoai saundatɨ nunjenataise. “Amɨ kɨnyɨ sandɨpɨ kɨnyɨ kɨwahonyɨ isɨhiya naisɨhiyai maarɨho nunye dingɨyɨhiya diyaapise?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Saundatɨ nunjesɨhɨ Jisaasiho komɨha wihoaaŋɨha koai sata kaundataase. “Utaaho wo Jerusaremɨhanda namasi Jerikohandaahapɨ daihɨra taatɨ notaise. Naihɨ isɨhiya maatɨmaatiwɨ ikohiya nutanɨwɨ koai isɨpɨ komɨ utɨ apotɨhɨrɨ nausohaapɨ nusepɨ somaahomwapɨ koai pɨhɨtɨwɨ tipɨ daihɨra ahiyamapɨ niyauhɨ ko asisɨwiratihɨ kwaapanɨmaasatɨ ahondaise. ");
INSERT INTO agm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Aihɨ amɨ utaaho wo pɨrisiho Autaahaatɨhoai nandapa tɨhatɨ dɨpumasɨho daihɨra kɨra notaise. Notɨ mmonata utaaho daihɨra ahotihɨ usonamapɨ wɨndɨ koai namumatɨtandɨ kɨsetɨ daihɨramɨ wihɨnɨhɨraapɨ nusatipatɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aihɨ amɨ utaaho wo isɨhiya Autaahaatɨhomɨ Aŋɨ Awaindɨhandamɨ otɨpɨpatɨ ipaahambɨhapa kiyohiyɨhiya Ripaihiyaamɨho daihɨra kɨra nasaho mmonata utaaho daihɨra ahotihɨ mmonamapɨ naasɨkatɨ kiyatɨ kisetɨ daihɨraamɨ wihɨnɨhɨraapɨ nusatipatɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Saimɨ utaahurɨ surɨ usonamaahandɨ kandɨ nehɨ iwinjapɨ mmonɨmapɨ naihɨ amɨ utaaho nehɨ koai wo isɨhiya Samariyaahiyaamɨho daihɨra kɨra nasataaho nasatɨ ko ahotimbɨpɨhɨ noaipataise. Nasatɨ noaipatɨ mmonata utaaho mɨmaipiyatɨ ahotihɨ kopɨ maarɨho waatɨ asɨpɨwisataise. ");
INSERT INTO agm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Asɨpɨwisatɨ komɨhinɨ detɨ notɨ komɨ asaahaatɨhɨ atɨpatɨ werɨhandɨ amɨ wainɨhandɨ nuhaatɨ iwinjaatɨ nurɨmaasatɨ asaaha urɨmataise. Iyatɨ ko koai naimaatɨ komɨ dongihoaasɨnɨ ahiyatɨ isɨsi notɨ aŋɨhandɨ wɨndɨ nawɨho nunyawɨ nanohotɨhandaapɨhɨ ahɨwisatosatɨ winjaatɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Aihɨ asisɨha kasɨnɨhetɨ nawɨho taanauhɨho siriwaahonyurɨ nawɨhomɨ ikihombɨ niyaatɨ aŋɨhandɨ sandɨ jaatɨ bimisɨhoai nunyatɨ saundataase. ‘Kɨmo utaamopɨ nawɨho wapa kinyɨhapa owemapɨ tɨmapaapaahɨ nɨnɨ kɨmihoaaŋɨ japɨhɨ napɨtɨhura nawɨho kopɨ owemapɨ tɨmahingɨhopɨ wihoaaŋɨ nahɨmɨtaanɨ kɨmoai kɨnyɨ iwinjaapɨ bime,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Isɨ amɨ isɨmiya kɨmingwaasamɨ maahɨwo utaaho maatɨmaatiwɨ ikohiya tipɨ nusopɨsasohɨhopɨ awaindɨhandɨ maarɨho nunyatɨ asɨpiyatɨ iwɨtatamanataise?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Saundatɨ nunjesɨhɨ ko Judaahiyaamɨ wɨnɨhapɨpa kataunjisɨho wihoaaŋɨha sata kaundataase. “Utaaho kopɨ maarɨho asɨpɨwisatɨ iwɨtatamasɨhore,” undataase. Saundihɨ Jisaasiho koai saundataase. “O amɨ kɨnyɨ numbwɨ sɨkatɨ kaimbɨ isɨhiya usaisɨ iwɨtatamanɨpɨ bime,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Saimɨ Jisaasiho komɨ otɨpɨpatɨhiyaimaawɨ daimɨ Jerusaremɨhandaahapɨ taawɨ nowaayopo. Taawɨ nowaawɨ Jisaasiho aunahɨpatɨ wɨta notɨ nandaatɨ noaipataise. Noaipasɨhɨ satɨ aunahɨpita apopaatɨ waatɨ kaatamɨ ambɨpatɨ Mataahaatɨ bindataise. Bindataatɨ kaatɨ Jisaasihoai kaatamɨ aŋɨpɨpɨhɨ numwaasi notɨ aŋaaŋɨ nunyatɨ nandapa tɨhatɨ yainjaraawisataise. ");
INSERT INTO agm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mataahaatɨ saatɨ kaatamɨ sanaapwɨhaatisahaate. Kaatamɨ ambɨpatɨ Mariyaahaate. Aihɨ kaatɨ Mariyaahaatɨ Jisaasihomɨhinɨ detɨ nasatɨ bindataatɨ Jisaasihomɨ pɨwɨha atɨwisataise. ");
INSERT INTO agm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Saihɨ amɨ Mataahaatɨhɨ nandapaapaahɨ nonasaya nandapa tɨhatɨ tɨmanataise. Siyatɨ kainjatɨ notɨ Jisaasihoai saundataase. “Awaisɨhoŋe, nɨnɨ nɨwɨhaanɨnɨ nundɨ napɨtaindɨ nandapa tɨhɨtɨ tɨmanataayo. Isɨ kɨnyɨ nɨngi nisonapaino? Naapwɨraati natɨpusoaase kaatɨ andɨtɨnihonɨhɨ maimburaaŋɨ nandapa maasɨ tɨhaha tɨmanɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Saundihɨ amɨ Awaisɨho komɨha wihoaaŋɨha kaati sata kaundataase. “Mataahaaŋe, kɨnyɨ wapa pɨhɨtatɨ taahɨpɨpaapɨ gwɨnyapenapaise. ");
INSERT INTO agm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Siyapaahandɨ kandɨ kɨnyɨ nehɨ wɨndɨ naasaindapaahɨ nenoaahɨtapaise. Iyataatɨ sandɨ kɨnyɨ nenoaahɨtingɨtɨndɨ Mariyaahaatɨ kandɨ gaahandɨ naitandaise. Sandɨ kaatɨ nesɨtɨndɨ isɨhiya usa kaatamɨhetapɨ wɨndɨ nemaamaitaapo. Owetɨtaise,” undatɨ Mataahaati Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Asisɨha waara Jisaasiho wapɨhɨ taatɨ gaapundataise. Gaapundatɨ namɨhaasɨhɨ komɨ otɨpɨpatɨhiyaamɨ wo koai saundataase. Awaisɨhoŋe nyahɨ gaapundɨtɨhaahandapɨ satɨwɨ gaapundɨwɨse tɨpɨ katɨpɨnyase Jonɨho komɨ otɨpɨpatɨhiyai kataunjipatamataimbo undataase. ");
INSERT INTO agm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aihɨ Jisaasiho kiyai saundataase. “Sahɨ gaapundawaawɨ satɨwɨ gaapundɨwɨse. ‘Apore kinyɨ ambɨpatɨ nehɨ naasaipatɨhɨ nyahɨ newa awaindewaamaitaano. Kɨnyɨ nyangi nyainjaapɨ bimaamɨ numwe. ");
INSERT INTO agm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Asisɨha nahatewetɨ asisɨ nɨnaasetapɨhapa nandapa nanyinyamɨ numwe ");
INSERT INTO agm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Isɨhiya nyangi maipɨhaiwa kanyisauhɨ nyahɨ kiyaamɨ maipɨhaiwa nyangi kanyisohɨwaiwa newaumahohɨpatamataimbɨ nyamɨ maipɨhaiwa nepɨnyamape. Aimbɨ nyangi wapa nanyisendandɨhandaatɨhɨ nanyamaasi namumwe’ tɨwɨ gaapundɨwɨse” undataase. ");
INSERT INTO agm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iyatɨ amɨ ko kiyai saundataase. “Samɨ woŋɨ kinyɨ naisoho bimonɨhɨ apɨpaahɨ apwɨtetetɨ numbwɨ kinyɨ naisohoai saundɨtaise. ‘Naisohoŋe nandapa bɨretɨhandɨ mairɨma naninye. Amɨ japɨhɨ bosonɨhɨ nisɨhandɨ nahɨmɨtaano. ");
INSERT INTO agm_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nisɨ naisoho wo daihɨra napinjaho wanɨ konɨhɨ nisɨ aŋɨpɨpɨhɨ noaipasɨhɨ nandapa koai numwɨtandɨhapa owetihɨtono’ undɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Saundisamɨhɨ kinyɨ naisoho mɨhatɨhɨ aŋɨtɨtɨhɨ nanototisɨho gi sahɨtɨtaise. ‘Kɨnyɨ nɨngi naapɨnuraapɨ namame. Maasomwaaŋɨ aimɨ anɨtindɨ napwɨtɨtɨ nisɨ metɨhonyaisatɨ maasɨ nanotondaayono. Isɨ nɨnɨ nepatɨ nandapa wapa namaahɨmɨto,’ hɨtɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nɨnɨ sangi sandɨ kasatataato. Utaaho aŋɨtɨtɨhɨ nanomasɨho nisɨ naisohoso tatɨ gwɨnyaataatɨ nepatɨ nandapa neunyataamaise. Owe. Nandapa katohɨpɨpa naninye undatɨ jinjɨhaatema konɨhɨ kaundonɨhɨ poundonɨhɨ kandapɨ bɨpi nepatɨ katimbɨpa pɨhɨtatɨ nemwɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Isɨ nɨnɨ sangi sandɨ kasatataato. Sahɨ wapa nausetɨtonɨhapaapɨ Autaahaatɨhoai nunjenɨwɨse amɨ ko kapa nasamɨtaiso. Sahɨ Autaahaatɨho wapa nasamɨtandɨhapaapɨ koaapɨhɨ daapɨse daahohɨpɨpa ko nasanyonɨhɨ sahɨ naitaawo. Sahɨ Autaahaatɨhomɨ maasomwaaŋɨ tipɨ kwɨtapɨse amɨ Autaahaatɨho atɨsisatɨ maasomwaaŋɨ sapɨ nasuwɨtaiso. ");
INSERT INTO agm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Amɨ isɨhiya nahatiya wapaapɨ nunjenohiyɨhiyai kapa koai nunjenɨhohɨpɨpa Autaahaatɨho kiyai nunyahore. Iyatɨ amɨ utaaho wo wapaapɨ Autaahaatɨhoaapɨhɨ daasɨhoai amɨ ko daasɨpɨpa kapa koai Autaahaatɨho netɨ nunjahore. Iyatɨ amɨ utaaho Autaahaatɨhomɨ maasomwaaŋɨ tiwatɨ kwɨtɨwataataahɨ amɨ kopɨ Autaahaatɨho maasomwaaŋɨ ko nandaitandɨ nɨwuwahore. ");
INSERT INTO agm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Samɨ wonyɨ kimwaaho sapɨhongi apore araihopɨnyisɨ nandaanɨ naninye hɨtonɨhɨ sapɨhoŋɨ araiho namunyapɨ akwɨranɨho maipɨhapa numwɨtaino? ");
INSERT INTO agm_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Iyataatɨ amɨ metɨhonjɨ kohomɨ mwaaho kwaatanipatapɨ sapɨhongi naninye hɨtonɨhɨ kɨnyɨ sapɨhoŋɨ namapɨ naapɨho maipɨhapa akosɨho nepumwɨtaino? Owe. Kɨnyɨ sapɨhoŋɨ wɨndɨ saimbɨ kamaitaise. ");
INSERT INTO agm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Amɨ sahɨ isɨhiyaatɨ maipɨhiyaatisɨ samɨ metɨhonyai nandapa maahoaipatɨ tɨtɨhɨ gaahapaahɨhɨ samɨ metɨhonyai nunyawɨhiyaate. Isɨ amɨ sɨkiyatisɨ sahɨ baiwɨ gwɨnyaapɨse. O amɨ samɨ Japɨho yamɨhapataatɨhɨ bimisɨhohɨ isɨhiya usa Itɨpɨho Gaaho nyangi nanyɨnye undɨwɨ nunjenɨhohiyɨhiyai Itɨpɨho Gaaho ko kiyai nunyahore,” undatɨ Jisaasiho otɨpɨpatɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Itɨpɨho maipɨho maahomwaaŋɨ dɨhɨwatɨ pɨwaamaatahoai Jisaasiho nemataise. Siyatɨ Jisaasiho utaahomɨhetapɨ itɨpɨho maipɨho nemwasɨhɨ aimɨ utaahomɨhetapɨ noaipasi naihɨ ko utaaho pɨwaamaatisoho namasatɨ pɨwandaase. Aihɨ kandapɨ isɨhiya wɨrɨsandɨhandɨ mmonawa yaiwɨmapɨ aatɨmawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Saihɨhandɨ kandɨ usa satawaatopo. “Itɨpɨho maipɨhapaamɨ awaisɨho Biyerɨsepurɨhomɨ watɨpɨhandaahɨ itɨpɨho maipɨhapa nemataise,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Satauhɨ amɨ isɨhiya usa Jisaasihoai saundawaatopo. “Kɨnyɨ nyangi nepɨ nanyisapɨ yamɨhapataatɨhapɨ watɨpɨhandɨ wɨndɨ kaime. Kaisamɨhɨ nyahɨ mmonɨhaawɨ Autaahaatɨho koaisatɨndaise taatɨ nyahɨ gwɨnyaitaano,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Saiwɨ kaundauhɨhandɨ kandɨ kohɨ kiyaamɨ jaiwaiwɨ gwɨnyaapɨ kaundohɨtɨhandɨ usonataatɨ kiyai saundataase. “Isɨhiya yapɨpatɨ naasɨkataahapɨhiya tipɨtapaatɨwɨ tunawaawaahɨ kiya nosasɨndaapo. Iyataatɨ amɨ nususasɨ tipɨtapaatɨwɨ tunawaawaahɨ kususamɨ bimohɨtɨhandɨ notɨ nosasɨndaise. ");
INSERT INTO agm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Iyataatɨ amɨ Bwaasɨrɨhɨrɨ tipɨtapaatatɨ tunataataahɨ napitiyatɨ andɨtitatɨ kahapaamapɨpa jaatɨ bimɨtaise, sahɨ nisapɨ ko Berɨsepurɨhomɨ watɨpɨhandaahɨ itɨpɨho maipɨhapa nemataise tohɨtɨmando. ");
INSERT INTO agm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nɨnɨ wanɨ Biyerɨsepurɨhomɨ watɨpɨhanda itɨpɨho maipɨhapa nemwasanaahɨ amɨ samɨhiya diyaamɨ watɨpɨhanda itɨpɨho maipɨhapa nemwahopo? Sahɨ satɨwɨ katohɨtɨmandapɨ sahɨ sawanaatamɨ isɨhiya sahɨ jaipɨtɨwɨ naharɨtɨwɨtopo satɨwɨ kasatɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amɨ nɨnɨ Autaahaatɨhomɨ watɨpɨhandaahɨ itɨpɨho maipɨhapa nemataayo, amɨ sandɨhɨ Autaahaatɨho aimɨ nasatɨ namasatɨ sangi jainjaatɨ bindataise tatɨ netɨ nasisataise. ");
INSERT INTO agm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Utaaho wo komɨhapa pwɨsɨpɨ yaipatɨ isɨwatɨ nainaamanɨnatɨ biyatɨ komɨ aŋɨpɨpɨhɨ komɨhapaatɨhɨ jatataataahɨ komɨhapa kahapaamapɨpa namosasɨnatɨ biyatɨ ahusotɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Iyataatɨ amɨ utaaho wo apɨpaahɨ watɨpɨho nasatɨ koaisamɨ tunamaamɨ koai tiwamatɨ pwɨsɨpɨ yaipatɨ andɨtɨwiwɨtandɨ isɨwatimbɨpa naitaise. Netɨ tipɨtapaatɨ nahataapa isɨhiya usai nemwɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Utaaho nisɨ naisohoemaamatatɨ amɨ nɨngisatɨ maasɨ tɨmaamaamaitisɨho so nisɨ tiworɨhore. Amɨ utaaho wo nɨngisatɨ maasɨ nisɨ isɨhiyai sipɨsipɨhonyaamatiyatɨ netɨ ahomaisɨho so amɨ nisɨ isɨhiyai netɨ kihɨkihoaaŋematɨ torɨwatɨ tahamanausoaasataise,” ndaase. ");
INSERT INTO agm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Amɨ sa satatosatɨ wa sandaase. “Itɨpɨho maipɨho utaahomɨhetapɨ noaipasi nehɨhaatɨ awasɨhapɨhɨ notɨ daayatɨ wapɨhɨ ko ikɨndandɨhapɨhapɨ daataise. Nehɨhaatɨ awasɨhapɨhɨ isɨhiya owehapɨhɨ ko ikɨnatɨ biyatɨ bimɨtandɨhapɨhapɨ mmonatɨ dainjatɨ owetihɨ wapɨhɨ monataatɨ sandaase. “Nɨnɨ aŋɨpɨpɨhɨ jɨhɨ bimambɨtɨ noaipasi nasohɨpɨpɨhapɨ japɨhɨ naitaano,” tɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Naitaano tamapɨ nasatɨ aŋɨhandɨ jɨhɨ bimainjatɨ naindɨhandɨ mmonata isɨhiya sanahɨwaiwɨ naihoaapɨ itatamanɨmɨhauhɨ mmonataise. ");
INSERT INTO agm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mmonamapɨ naisɨhohɨ notɨ itɨpɨho maipɨhapa ikwɨ naasairɨtihɨ wɨramɨ yahurɨtahapa 7 kiyatɨ apɨpaahɨ maipɨhapai ko notɨ numwaasɨhoai nusatipɨhaahapai numwaasi napihɨ napɨwɨ nandaapɨ utaahomɨhetɨ bindawaayopo. Bimauhɨ ko jɨhɨ gotɨ mɨmaipiyatɨ bimainjahosɨ wanɨ ipotɨhandɨ daahɨ apɨpaahɨ mɨmaipiyausoaasanatɨ bindataise,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisaasiho taatɨ sata kaundihɨ isɨhiyaamɨ otɨhatɨhapɨ apopaatɨ waatɨ waapɨhɨtatɨ pɨwɨha sata kandaase. “Itapaatɨ kɨnaatɨ gi nangɨmotɨ amwɨtɨhɨnyatɨ gɨtatamasaamaatɨ saati amɨ akɨtɨnɨhɨ Autaahaatɨho gaahandɨ kawɨsataise. Isɨ amɨ kaatɨ waatɨ maaritane,” tatɨ kandaase. ");
INSERT INTO agm_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sata Kaatɨ katihɨ Jisaasiho kaati wihoaaŋɨha sata kaundataase. “Owetise. Isɨhiya Autaahaatɨhomɨ pɨwɨha baiwɨ atiwɨ nepɨ amɨ baiwɨ japepihɨrohiyɨhiya siyaahɨhɨ asakaiwɨ maaritɨwɨse, amɨ akɨtɨnɨhɨ Autaahaatɨho kiyai gaahandɨ kawɨsataiso,” tatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Isɨhiya taahɨtɨhandɨ taapɨwɨ koaapɨhɨ ahoyanɨhauhɨ Jisaasiho kiyai saundataase. “Wanɨ kɨmura namoyaatɨwɨ bimohiyɨhiya apɨpaahɨ maatɨmaatiwɨ maipɨhiyaare. Kiya sɨwipatɨ watɨpɨhandisɨhatɨ mmondaatɨwɨ nasenawaayopo. Sɨwipatɨ watɨpɨhatɨ mmondaatɨwɨ nasenɨhauhɨhandɨ kandɨ nɨnɨ kiyai sɨwipatɨ watɨpɨhatɨ wɨndɨ kaindɨ namunjɨto owe nehɨ jɨhura Jonaaho kaindɨhandapaahɨhɨ kaundɨtaano kiya gwɨnyaitaatɨwo. ");
INSERT INTO agm_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sandɨ apaapɨmaato amɨ jɨhura Jonaaho kaindɨhandɨ isɨhiya Niniwehandaahiyai nunjataise. Aihɨ amɨ wanɨ kɨmura namoyaatɨwɨ bimohiyɨhiyaatangi nasisataise. ");
INSERT INTO agm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ipɨhomɨ bopihihoaaŋɨ mɨhombɨhaatɨ waatɨ apopaatɨ yapɨpatɨ isɨhiya kahapaamapɨpa jaatɨ bimisaamaatɨ wanɨ kɨmura namoyaatɨwɨ bimohiyɨhiyaisatɨ asisɨha Autaahaatɨho netɨ isɨhiyai tipɨtapaatɨ usondandɨhetɨ doaitaise. Asisɨha ketɨ isɨhiyai kaatɨ kiyaamɨ maipɨhaiwa netɨ ausaimanatɨ nunjɨtaise. Sandɨ napaape, jɨhura kaatɨ mɨhopɨ yapɨpatamɨ otasaahaapɨhapɨhaatɨ Soromonɨhomɨ gwɨnyaasɨtɨhandɨ mmona komɨ pɨwɨha atitandɨ nasataise. Aihɨ amɨ wanɨ kɨmura Soromonɨhoai apɨpaahɨ nusatipɨhaatɨ awaindɨhandɨ gwɨnyaaho kɨmbɨhɨ noaipatɨ kɨmo bindataise. ");
INSERT INTO agm_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Asisɨha Autaahaatɨho isɨhiyai netɨ tipɨtapaitandɨhetɨ isɨhiya Niniwehandaahapɨhiyaunɨ amɨ wanɨ kɨmura taawɨ namoyaatohiyɨhiyaatunɨ japɨhɨ nepapɨ Niniwehandaahiya sangi saiwɨ saiwɨ maipɨhaiwa kaiwɨhiyaate satɨtaapo o amɨ kiyaahɨ Jonaaho pɨwɨha ausaasɨhɨ atiwɨ nepɨ aimɨ kiyaamɨ maipɨhaiwa namasi nepemaitɨwɨhiyaaso. Amɨ wanɨhɨ Jonaahoai nusatipɨhaahandɨ apɨpaahɨ awaindɨhandɨ gwɨnyaaho wanɨ kɨmbɨhɨ kɨmo bindataise. ");
INSERT INTO agm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Isɨhiya sisɨha tɨpopɨ aŋaaŋamɨ otɨtɨhunɨ amɨ yutɨhɨraatɨhunɨ noaasawɨ ahiyawaamaayopo. Owetise. Sisɨha tɨpopɨ autaahɨ nimaatarɨhɨretɨ nimaaposawaayopo isɨhiya aŋɨtɨtɨhɨ napɨwɨ nandaahohiyɨhiya sisɨha ka nausaatonɨhɨ japɨ nandaitaatɨwo. ");
INSERT INTO agm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kinyɨ ndɨha ambɨpatamɨ sisɨhaare. Kinyɨ ndɨha maiwɨ namaayotatɨ maipɨmendaataahɨ amɨ kinyɨ ambɨpatɨ nahatepɨsangi sisɨha gaamatɨ nausaatɨtaise. Iyataahandɨ kandɨ kinyɨ ndɨha maiwɨ niyotamataataahɨ amɨ kinyɨ ambɨpatɨ nahatepɨ katɨnɨhɨ gaamatɨ asahatamaitaise. ");
INSERT INTO agm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sisɨha samɨhetɨ nausaatatɨ ahotisɨha niyotatɨ asɨhatindɨhandɨ nasamaasaitaisɨ sahɨ baiwɨ jatɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kinyɨ ambɨpatɨ wihoaaŋɨhatɨ asɨhɨmetatɨ nahatepɨ gaamatɨ nausaatamataataahɨ sisɨha kinyɨhetɨ nangusaatipatamatiyatɨ kinyɨ ambɨpatɨ nahatepɨ gaamatɨ nausaatamaitaise,” undatɨ kiyai Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisaasiho pɨwɨha satatɨ kaundatɨ aimɨ owetihɨ utaaho isɨhiya Parisihiyaamɨ wo Jisaasihoai nisɨ aŋɨpɨpɨhɨ nandapa maasɨ nandɨhaawɨ namme undataase. Namme undihɨ Jisaasiho notɨ nandaatɨ nandapa nandandɨ ganɨhoaasɨnɨ nausanatɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bindataatɨ Jisaasiho ikwɨrɨ wɨndɨ bahomusatɨ nehɨ nandapa netɨ nainjɨhɨ ko Parisiho Jisaasihoai nandapaapɨ gaata numwaasɨho sandɨ ko ikwɨrɨ jɨhɨ bausatosatɨ namainjo tatɨ waatɨ aatama iwinjatataise. ");
INSERT INTO agm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aihɨ Awaisɨho koai saundataase. “Sahɨ Parisihiyaatɨ wipatɨ kaapɨhomunɨ nyaihandɨ pɨretɨhomunɨ tiwatɨhetɨ tɨwɨhaapɨ itatamanɨwɨ bausawɨhiyaate. Bausawaahandɨ kandɨ utatopopɨhɨ sahɨ maipɨhaiwa kaitaatɨwɨ pɨhɨtɨwɨ mɨmaipaiwɨ gwɨnyaahohɨwaiwa maipɨhaiwa pɨhɨtatɨ tɨsisaitahiyaate. ");
INSERT INTO agm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sahɨ apɨpaahɨ nahariwɨhiyaatɨ maipɨhiyaate. Utaaho kapa kiyatɨ Ahaisɨho tiwatɨhetɨ kiyataatɨ utatopopimaawɨ kiyatɨ ahɨmaiho? ");
INSERT INTO agm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Iyataatɨ kahapaamapɨpa wipatɨ kapɨho amɨ nyaihandɨ pɨretɨhoaatɨhɨ mɨhatɨhɨ ahotimbɨpa isɨhiya nenoaahɨtohiyɨhiyai iwɨtatamanɨtandɨ nunye. Saiwɨ kiyawaawaahɨ sahɨ noaipapɨ Autaahaatɨhomɨ ndɨhetɨ tɨtɨhɨ popɨtɨhiyaatɨ gaahiyaatimatɨtaapo. Aisaihɨ amɨ nahataapa gaatatɨ amɨ tɨtɨhɨtɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Sahɨ Parisihiyaatɨ jaawo! Sahɨ Autaahaatɨhomɨ katimumwaaŋɨ kamaiwɨ asɨretɨ asɨpatunɨ ainjotisɨhounɨ akonanaatunɨ amɨ wapa nandapa biyatɨ waamainjotɨtandɨhapa kɨpɨwɨ tenɨ tenɨ kaiwɨ tipɨtapaapɨ nehɨ nɨnaasaimbaahɨhɨ nunyawɨhiyaatiso. Saiwɨ kiyawaawɨ tɨtɨhɨ gaahaiwa kaitaatɨwɨhaiwaunɨ Autaahaatɨhoai maarɨho numwɨtaatɨwɨhandunɨ isɨhiyaapɨ maarɨho asɨpaitaatɨwɨhandunɨ namapɨ sehɨmwaapɨhiyaatiso. Sahɨ wapaisangi nanɨpimatɨwɨ namihɨrɨwɨ saiwa nahatewa kiyawaawaahɨ sandɨhɨ amɨ gaatɨtaihe. ");
INSERT INTO agm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Sahɨ Parisihiyaatɨ jaawo. Sandɨ nɨnɨ apaapɨmaasato amɨ anɨhaiwa gwɨharaahaiwa Autaahaatɨhopɨ gwɨnyaapɨ gaapundɨtaatɨwɨ amɨ ahoyanohɨwaiwaatɨhɨ mɨhotɨ mɨtoaahoaahɨ isɨhiya jainjapɨ bimɨtaatɨwɨ apɨpaahɨ maaritɨmapɨhiyaatiso. Aiwɨ amɨ isɨhiya taahiyɨhiya ahoyanɨhohɨpɨpɨhɨ nowaahura isɨhiya nyangi ketɨ ipɨhɨrete nyatɨto tɨwɨ apɨpaahɨ maaritɨwɨhiyaatiso. ");
INSERT INTO agm_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Iyataatɨ Sahɨ Parisihiyaate jaawo! Sahɨ anɨmwaahɨpatɨ ahɨmetise tɨwɨ kataasɨnɨ itɨpapɨ nuwɨ napɨwɨyawaawɨ isɨhiya noaipapɨ Autaahaatɨhomɨ ndɨhetɨ maipɨhiyaatohiyɨhiyaamataiwɨhiyaatisɨ jaawo,” undatɨ kiya Parisihiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sata kaundihɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaamɨ wo Jisaasihoai saundataase. “Katɨpɨnyasingɨhonye, kɨnyɨ pɨwaamaiwa kɨmaiwa satɨpɨ katapaapɨ kɨnyɨ nyapɨ pɨwɨha maipɨha katapaase,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Aihɨ Jisaasiho koai wihoaaŋɨha sata kaundataase. “Sahɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaate jaawo! Autaahaatɨho sangi yaasɨhandɨ nasamɨtaise amɨ isɨhiya wɨnɨhapɨpa japepihɨrɨtaatɨwɨ usaimanɨwɨ daihɨra dahomaawuhowo. Dahomaawupwɨ daahɨ sahɨ naaŋɨhaiwa isɨhiyai nunyawaayowo. Nunyauhɨ kiyai naaŋawisataise. ");
INSERT INTO agm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Samɨ jaasoya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya pɨropetɨhiyai tiwauhɨ napohiyɨhiyaamɨ anɨmwaahɨpatɨ nehɨ gwɨnyaitaatɨwɨhatɨ sahɨ taawɨ yaurɨmwaawaayowɨ amɨ jaawo! ");
INSERT INTO agm_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Samɨ jaasoyaamɨ kiyohɨtɨhandapɨ sahɨ gaare tɨwɨ gwɨnyaapɨ isɨhiyai nunjawaayopo. Aiwɨ samɨ jaasoya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyai tiwauhɨ napohiyɨhiyaamɨ anɨmwaahɨpatɨ sahɨ yaurɨmwaahohiyɨhiyaate. Saiwɨ sahɨ isɨhiyai nepɨ nunjawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Sahɨ saiwɨ kaitauhɨ Autaahaatɨho tɨtɨhɨ gaahandɨ gwɨnyaasɨtɨhandaahɨ ko satise. “Nɨnɨ kiyaapɨhɨ nisɨ pɨwɨha atiwɨ nepɨ ausaitaatɨwɨhiyaisunɨ amɨ otɨpɨpatɨhiya aposerɨhiyaisunɨ nandusaasɨto. Nandusoaasisanɨhɨ kiyaamɨ usai siyɨhiyai timapɨ amɨ usai kiyaamɨ ambɨpatɨ yaawɨhaiwa numwɨtaapo,” tatɨ aimɨ katise. ");
INSERT INTO agm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Isɨhiya wanɨ kɨmura namoyaatɨwɨ bimohiyɨhiya wuwanɨhura Autaahaatɨho yapɨpatunɨ yamɨhapatunɨ ahaisuraapɨ namasawɨ tɨtɨhɨ Autaahaatɨhomɨhiya isɨhiyai timapɨ napɨwɨ wanɨ kɨmuraatindɨhandapɨ wihoaaŋɨhandɨ yaawɨhandɨ wanɨ kɨmura namoyaatɨwɨ bimohiyɨhiyaatangi Autaahaatɨho nasanyonɨhɨ sahɨ naitaapo. ");
INSERT INTO agm_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Jɨhura Aberɨhoai namasawɨ tipɨ napɨwɨ amɨ Jekaraiyaahoai Autaahaatɨhomɨ anɨhandamunɨ nawɨha tiwatɨ nyepaiwɨ ahiyohɨtɨhandɨ arɨtaahandamunɨ mataapɨpɨhɨ tiwauhɨ napwisɨhoaapɨhɨndaise. Isɨ kandapɨ wihoaaŋɨhandɨ yaawɨhandɨ isɨhiyai Autaahaatɨho numwɨtandɨhandɨ wanɨ kɨmura sahɨ namoyaatohiyɨhiyaatamɨhetimaawɨ ahoyatɨ ahɨsisondaise. ");
INSERT INTO agm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Wɨnɨhapɨpa katɨwunjohiyɨhiyaate sahɨ jaawo! Isɨhiya gwɨnyaitaatɨwɨhandɨ naitaatɨwɨhɨraamɨ kihɨrɨ nupwɨ nandaahohɨrɨhɨrɨ sahɨ aimɨ nemapɨhiyaatiso. Nemaposawɨ amɨ sahɨ sawanaatɨsangi wɨndɨ nuposamɨ namandaahopo. Aiwɨ amɨ isɨhiyaisangi nandaitotɨwiyauhɨ sahɨ nɨwisapupwɨhiyaatiso,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisaasiho sata kaundamapɨ kapɨhɨ aŋɨpɨpɨhɨ aimɨ namasi naihɨ Parisihiyaunɨ amɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ pɨwɨha Jisaasihopɨ kanawaayopo ko pɨwɨha wa Mosesihomɨ wɨnɨhapɨpai netɨ nopɨsasatunɨ amɨ Autaahaatɨhoai netɨ nopɨsasatɨ kopɨ sisɨpɨtɨha kanyaso tɨwɨ jaiwaiwɨ iwinjatawaawɨ kopɨ itɨhɨtɨwɨ wapa pɨhɨtɨwɨhaiwa katɨwɨ koai nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Saiwɨ kiya baiwɨ Jisaasihoai komɨ maahomwaaŋɨ jatawaayopo. Ko wa kaundonaahɨ sa pɨwɨha tɨtɨhɨmetaha katapaase undɨwɨ komɨhetɨ pɨwɨma nuto tɨwɨ ahoyanawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Isɨhiya taahɨtɨhandɨ ambɨpatɨ owehandɨ wɨrɨsandɨhandɨ Jisaasihoaapɨhɨ itɨpunɨwɨ ipwɨsaatɨwɨ ahoyanawaayopo. Saiwɨ taawɨ ahoyanɨhauhɨ sura Jisaasiho komɨ otɨpɨpatɨhiyai jɨhɨ sata kaundataase. “Isɨhiya Parisihiyaamɨhetapɨ waatɨ nipɨsatɨ noaipasɨtɨhandapɨ sahɨ jaawo. Sandɨ nɨnɨ kasatohɨtɨmandɨ Parisihiya nyahɨ awaisawɨhiyaanɨnɨ gaahiyaaniso tɨwɨ nawɨhaiwɨ isɨhiyaamɨ ndɨhetɨ genanɨwɨ jaipaiwɨhaiwa kiyohɨwaiwaapɨto. ");
INSERT INTO agm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Isɨhiya wapa noaasawɨ kaiwɨ amɨ pɨwɨha noaasawɨ bɨpi pɨwanɨhohɨha Autaahaatɨho isɨhiyai auta netɨ nunjatɨ kaundonɨhɨ nahatiya mmonɨwɨ atitaapo. Sandɨ asisɨha ipotɨhetɨ Autaahaatɨho kiyonɨhɨ siyatɨ noaipaitaise. ");
INSERT INTO agm_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Isɨ siyatɨsɨ kɨnyɨ wapa apatɨhɨ katingɨpɨpaunɨ amɨ wapa nehɨ nɨwipɨhɨrotɨ bɨpi usaamɨ atihɨropɨ katɨpɨ wɨwihingɨpɨpaunɨ auta isɨhiya ahoyanopɨpɨhɨ katisaihɨ nahatiya atitaapo. ");
INSERT INTO agm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nisɨ naisɨhiyaate, nɨnɨ sangi kɨmandɨ kasatataato. Isɨhiya nehɨ samɨ ambɨpatisaahɨhɨ timawaawɨ amɨ ipotɨ wapa samɨ maarɨhoaisɨ wɨndɨ kamaawitaatɨwɨhiyaapɨ sahɨ wɨndɨ apɨpaahɨ yamaiwɨse. Owe. ");
INSERT INTO agm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sahɨ nehɨ naasopaahɨhɨ yaitaatɨwɨ nɨnɨ kɨmandɨ kasatataato. Utaaho watɨpɨhaiwaisaho samɨ ambɨpati tiwatosatɨ amɨ ipotɨ samɨ maarɨhoai netɨ apɨpaahɨ maipɨhapɨmaitandɨhopaahɨhɨ akɨtɨnɨhɨ sahɨ kopɨ yaiwɨse. ");
INSERT INTO agm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Sahɨ aimɨ mmonɨwɨ gwɨnyaapɨhiyaate. Isɨhiya kohonya ikwɨ naasairɨtahonya nawɨho asɨhisɨho 2 toyaaho nunyawɨ nehauho. O amɨ Autaahaatɨhohɨ koho mataapɨhapa siyahapaapisɨ wɨndɨ nanɨpɨmimatahoe. Owetise. Kapaapɨ gwɨnyaatɨ jata isɨwatahore. ");
INSERT INTO agm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ko kinyɨ mɨtɨhoaatɨhɨ misisɨha nahata aimɨ awɨta mmonahore. Sahɨhɨ isɨhiyaatisɨ koho so mataapɨhapai nusatipɨhaapɨhiyaatisɨ wapa nanyoaipaitaiso tɨwɨ wɨndɨ yamaiwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nɨnɨ sangi kɨmandɨ kasatataato. Utaaho wo nisapɨ satatɨ nɨnɨ Isɨhiyaamɨ Awaisɨho Saaho Jɨhomɨhonɨne tiso sopɨ Autaahaatɨho isɨhiyai tipɨtapaatɨ usonɨhonɨhura Autaahaatɨhomɨ otɨpɨpatɨhiya yamɨhapataatɨhapɨhiyaamɨ ndɨhetɨ ko nisɨhore ndɨ Autaahaatɨhoai kaundɨto. ");
INSERT INTO agm_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Iyataatɨ amɨ utaaho wo isɨhiyaamɨ ndɨhetɨ nisapɨ satatɨ nɨnɨ Isɨhiyaamɨ Awaisɨho Saaho Jɨhomɨhonɨnɨmaahe tatɨ nɨngi ahosɨnɨmataataahɨ amɨ nisangi koai Autaahaatɨhomɨ otɨpɨpatɨhiya yamɨhapataatɨhapɨhiyaamɨ ndɨhetɨ ahosumwaito. ");
INSERT INTO agm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Utaaho wo Isɨhiyaamɨ Awaisɨhonɨnɨ Saahonɨnɨ Jɨhonisapɨ wapa maipɨhapa katiwaiwa Autaahaatɨho nga nemwaitaise. O amɨ utaaho wo Itɨpɨho Gaahopɨ wapa maipɨhapa katiwaiwa saiwaahɨ Autaahaatɨho wanunɨ amɨ ipotɨ isɨhiyai tipɨtapaatɨ usonataahura wɨndɨ nemwaamahonɨhɨ kaiwaanɨhɨ ahotɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Sangi tipɨtapaapɨ jasondaatɨwɨ isɨhiya aŋɨhaiwa ahoyanɨwɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundohɨwaiwa gwɨharaahaiwaapɨhunɨ amɨ isɨhiya awaisawɨhiya gamanɨhiyaapɨhunɨ nasamaasi naisaihɨ sahɨ samaatɨwɨse, nyahɨ pɨwɨha wihoaaŋɨha kiyai maahɨwa kaundɨtɨhaawe tɨwɨ gɨmunyaapɨse. ");
INSERT INTO agm_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Amɨ sandɨ apaapɨmaato, amɨ sangi saiwɨ kasisaihɨ ketɨ suraanɨhɨ Itɨpɨho Gaaho pɨwɨha isɨhiyai sahɨ wihoaaŋɨha kaundɨtaatɨwɨha netɨ gisunyaitaihɨsato,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Isɨhiya kapɨhɨ ahoyanɨwɨ bimohiyɨhiyaamɨ otɨhatɨhapɨ wo sata Jisaasihoai kaundataase. “Katɨpɨnyasingɨhonye, nisɨ taasɨhoai kaunde ko apɨhomɨ kahapaamapɨpa ikɨpɨpa tipɨtapaatɨ nɨngi wihoaaŋɨhapa naninyatɨ ko wihoaaŋɨhapa naitando,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aihɨ Jisaasiho koai wihoaaŋɨha saundataase. “Utaahoŋe, nɨngi sandapɨ kɨnyɨ saimbɨ kaitaape ndatɨ ndɨ ahɨnihe sɨhoaasangi kahapaamapɨpa japɨhomɨhapa wihɨwihoaaŋɨ tipɨtapaatɨ nasamɨtando?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Undatosatɨ isɨhiya nahatiyai saundataase. “Sahɨ jaawo! Kahapaamapɨpa pɨhɨndɨ ahoaindɨ noaipatɨ kahapaamapɨpaisahonɨnimatɨtando tɨpɨ waatɨ gɨmunyaape. Utaaho komɨ asohoematatɨ nasisoaarɨ konɨhɨ ko bimɨtandɨhandɨ kahapaamapɨpa netɨ ahoyatoaatimbɨpetapɨ wɨndɨ namaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Undatɨ kaundatosatɨ amɨ pɨwɨha wa sɨwipatɨ nepemaahɨwatɨ sata kaundataase. “Utaaho wo kahapaamapɨpa asaketaho komɨ yapɨpatɨ osaataatɨ nandapa pɨhɨtatɨ nimaatatɨ akuraitaise. Akuraayonɨhɨ ko kahapaamapɨpa asaketisɨho siyatɨ sawaho gwɨnyaitaise. ");
INSERT INTO agm_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nisɨ osaataatɨ nandapa akuraayataisɨ nɨnɨ napɨtaito nisɨ nandapa kɨpwɨtɨ ahaitandɨhaaŋɨ aŋaaŋɨ oweso tatɨ gwɨnyaataise. ");
INSERT INTO agm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Siyatɨ gwɨnyaatosatɨ sandaase. ‘Nisɨ nandapaunɨ amɨ ikɨpɨpaunɨ ahiyohɨwaiwa aŋɨhaiwa gwɨharaahaiwaasɨ namatɨ nupwɨsasɨtɨ waitɨ aungwohaiwa awaiwaiwa aŋɨmatɨtaano. Aŋɨmatɨtosatɨ nandapa kɨpwɨtɨ kapaunɨ amɨ nisɨhapa ikɨpɨpaunɨ kaiwaatɨhɨ ahɨnotɨtando. ");
INSERT INTO agm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ahɨnotanɨhɨ nɨnɨ saindɨ gwɨnyaitande. Ikɨpɨpa nandapa kɨnaungwɨha taahɨwaiwetɨ nga ahɨnotanɨhɨ asakaindɨ maaritɨtɨ tahaapaindɨ ikɨndɨ nandɨ usaimanɨndɨ bimɨtando,’ tatɨ gwɨnyaataise. ");
INSERT INTO agm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kohɨ siyatɨ gwɨnyaasɨhandɨ kandɨ Autaahaatɨho koai saundataase. ‘Kɨnyɨ apɨpaahɨ naharɨhoŋe. Wanɨ kɨmura apɨmatɨhɨ napomasamɨhɨ kinyɨhapa nepɨ irɨhapɨwipɨ ahaingɨpɨpa ndɨ naitaise?’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Isɨ sɨkiyate, isɨhiya kahapaamapɨpa nepɨ irɨhapɨwipɨ ahiyawaawɨ Autaahaatɨhomɨhaiwaapɨ apɨpaahɨ nenoaahɨtɨmawaayopo,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aihɨ Jisaasiho komɨ otɨpɨpatɨhiyai sata kaundataase. “Amɨ sandapɨ nɨnɨ sangi kasatataato. Sahɨ itatamanɨnɨwɨ usaimanɨwɨ bimɨtaatɨwɨhandapɨ waatɨ pɨhɨtɨwɨ satɨwɨ gɨmunyaapɨse. Nyahɨ nandapa nandɨhaahapa owesɨ napa nandɨhaawe? Nyahɨ nyamɨ ambɨpatisɨ namaasaitɨhaahapa owesɨ napa niyowaatɨ namaasatɨtɨhaawe? Tɨwɨ waatɨ gɨmunyaapɨse. ");
INSERT INTO agm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Isɨhiya baiwɨ usaimanɨnɨwɨ bimɨtaatɨwɨhandɨ nandapaisɨ apɨpaahɨ nusatipɨhaahande. Aihɨ amɨ ambɨpatisangi yutɨhɨrɨ apotɨhɨri apɨpaahɨ nusatipɨhaataise. ");
INSERT INTO agm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sahɨ kohopɨ gwɨnyapenɨwɨse. Koho so otɨpɨpatɨ kiyatɨ amɨ nandapa niyaamatɨ kɨpohomaahe. Iyatɨ koho so nandapa kɨpotɨ ahoaitandɨhaaŋɨ aŋaaŋɨ owehore. Siyatɨ koho nandapa owehotihɨ Autaahaatɨho sawaho nunyataise. O amɨ sahɨ isɨhiyaatɨhɨ koho soaisɨ apɨpaahɨ nusatipɨhaapɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Saiwaapɨ samɨ wo pɨhɨtatɨ gwɨnyaataatɨ komɨ bimɨtandɨhandɨ masɨhonjɨ netɨ utaarɨmaitaiso? ");
INSERT INTO agm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sahɨ saiwɨ masɨwonjɨ samɨ bimɨtaatɨwɨhandɨ nepɨ onehɨmiwawaawaahɨ kahapaamapɨpa wapa awaimbɨpaametɨhapaapɨ napaapɨ sahɨ taawɨ pɨhɨtɨwɨ gwɨnyaahopo? ");
INSERT INTO agm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tandɨpɨho nawatɨ saniyatɨ ahetindɨhandapɨ gwɨnyaapɨse. Tandɨpɨho otɨpɨpatɨ kiyatɨ utɨ apotɨhɨrɨ nasatɨ niyotaamaise. Nɨnɨ sangi sandɨ kasatataato. Jɨhura Soromonɨho utɨ apotɨhɨrɨ sanahɨpɨpa otiwa kambwaahapa gaahapa utɨ apotinatɨ yundanyainjɨpɨpa so tandɨpɨhomɨ kwɨtaahomatiyahapa sanahɨpɨpa gaahapa otiwa kambwaahapa niyotɨ nipaata yundanyainataamaise. ");
INSERT INTO agm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kɨtarɨhɨrɨ woyɨha wanɨ nga ahetinjatɨ bosonaahɨ isɨhiya tisatɨwɨ sisɨhaapɨhɨ tɨhoaitaatɨwɨhapaisɨsɨ Autaahaatɨho utɨ apotɨwisataise. Sahɨ Autaahaatɨhopɨ apɨpaahɨ maipɨhonjɨ gɨwunyaapɨhiyaate, Autaahaatɨho utɨ apotɨsitaise. ");
INSERT INTO agm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Isɨ amɨ sahɨ gwɨnyapenawaawɨ nandapa maahapa nandɨhaawe, waapoho maaho nandɨhaawe, tɨwɨ pɨhɨtɨwɨ kapaapɨ wɨndɨ gɨmunyaapɨse. ");
INSERT INTO agm_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sandɨ katotɨmandɨ isɨhiya maipɨhiya Autaahaatɨhopɨ wɨndɨ gɨmaawunyaatahiya kɨmaapɨ yapɨmbatambɨhiya saiwa nahatewa pɨhɨtɨwɨ nehɨ kaiwaapaahɨhɨ gwɨnyaapɨhiyaare. Amɨ sahɨhɨ samɨ japɨho Autaahaatɨho sahɨ nenoaahɨtohɨpɨpaapɨ jasonatɨ aimɨ gwɨnyaahosɨ kapa tɨtɨhɨ nasamɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Isɨ Autaahaatɨho sangi jainjaatɨ bimindɨhandapɨ jɨhɨ pɨhɨtɨwɨ baiwɨ daapɨse. Daasaihɨ sahɨ nenoaahɨtihɨ saiwa maahapɨhapɨ naito tɨwɨ gwɨnyaahohɨwaiwaahɨ aimɨ ko mmonatɨ gwɨnyapese. Isɨ Autaahaatɨho sangi nahatewa nasamɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sipɨsipɨhandɨ yahonyaamataiwɨ isɨ yahonyaate, sahɨ wɨndɨ yamaiwɨse. Kahapaamapɨpai Autaahaatɨho osamatɨ jaatɨ bindataatɨ komɨ Jaatɨ Bimiwaiwaamɨ wiwa sahɨ awaisawɨhiyaatimatɨwɨ kahapaamapɨpa koaisawɨ maasɨ jaawɨ bimɨtaatɨwɨ samɨ Japɨho aimɨ gwɨnyaasɨ nasamɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sahɨ kahapaamapɨpa isɨwasohɨpɨpa isɨhiya usai nunyawɨ nawɨho nepɨse. Nawɨho kahapaamapɨpa nunyawɨ nehotɨho isɨhiya kahapaamapɨpaapɨ nenoaahɨtohiyɨhiyai andɨtɨwipɨ nunyawɨse. Nawɨhomɨ ikihɨ wɨndɨ napwɨrɨnatɨ namosasɨndandɨhihɨ baiwɨ daapɨ nepɨse. Sahɨ baiwɨ mmonɨwinjawɨ wapa nehɨ tɨtɨhɨ gaahapaahɨhɨ yamɨhapataatɨhɨ nepɨ ahoaiwɨse. Aiwɨ kɨnyɨ woŋɨ Yamɨhapataatɨhɨ kahapaamapɨpa gaahapaahɨhɨ nepɨ ahoaingɨpɨpa wɨndɨ nihɨrɨnatɨ nosasɨnatɨ owemetɨtaise. Iyataatɨ amɨ ikohiyaisangi kapɨhɨ kinyɨ gaahapa ahɨngisotimbɨpɨhɨ detɨ wɨndɨ namaitaapo. Iyonɨhɨ amɨ naapɨho kapaisangi wɨndɨ netɨ ipwɨratɨ namopɨsasɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Samɨ kahapaamapɨpa gaahapa ahisisotimbɨpɨpɨhɨ amɨ sapɨhɨ kapɨhɨ samɨ maarɨhoaisangi ahɨsisotɨtaise,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Sahɨ apotɨhɨrɨ nuhɨrɨhɨrɨ niyopɨ yamepatɨ apotɨhɨrɨ ipɨhatiwɨ mmatɨwɨ wɨsasɨnɨwɨse. Aiwɨ samɨ sisɨha norɨhɨrɨ ramɨhandɨ tɨpopɨ tɨmetɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Otɨpɨpatɨhiya kiyaamɨ awaisɨho namaatonɨhɨ nandapa tɨhohɨpɨpaatɨhɨ bimainja namasi japɨhɨ napɨtandɨhandapɨ jaawɨ bimohɨpatamataiwo. Komɨ otɨpɨpatɨhiya awaisɨho napɨtaiso tɨwɨ jaawɨ kiyaanɨhɨ bimaambɨwɨ kiyaamɨ awaisɨho nasatɨ maasomwaaŋɨ nanupwɨse tatɨ maasomwaaŋɨ tiwatɨ kwɨtɨwonɨhɨ kiya atisawaawɨ ketɨ kuraanɨhɨ nihɨtɨwɨ nɨwuwɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Komɨ otɨpɨpatɨhiya nanɨhaiwɨ wɨndɨ namopotɨwɨ kiyaanɨhɨ baiwɨ jaawɨ binyaihɨ kiyaamɨ awaisɨho nasatɨ usosawɨhiya siya awaindɨhandɨ maaritɨtaapo. Nɨnɨ akɨtɨnɨhɨ sangi sandɨ kasatataato. Ko sawaho apotɨhɨrɨ nuhɨmatɨ niyotɨ yamepatɨ wɨsasanatosatɨ komɨ otɨpɨpatɨhiyai ganɨhomɨhinɨ ahɨwisatosatɨ sawaho nandapa numwɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Iyataatɨ amɨ kiyaamɨ awaisɨho apatɨhɨ apwɨtetetisangi amɨ otɨpwɨsɨpaatɨ gaatisuraisangi nasatɨ usonata komɨ otɨpɨpatɨhiya wɨndɨ namopɨ tɨmetisaihɨ usosawiya siya waatɨ maaritɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Isɨ amɨ nɨnɨ sangi pɨwɨha kɨma sandɨ kasatataatonɨ sahɨ baiwɨ atiwɨse. Aŋaaŋamɨ satɨho utaaho ikopaisaho sura napɨtaise tatɨ mmonatɨ gwɨnyaataataahɨ anɨtinatɨ tɨmanɨnatɨ jaatɨ bimonɨhɨ ikopaisaho wɨndɨ nasatɨ komɨ aŋaaŋɨ nurɨwatatɨ komɨhapa iwɨrɨmaawitaise. ");
INSERT INTO agm_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Isɨ sɨkiyatisɨ namaapɨtaise tɨwɨ nanɨhaiwɨ binyaihɨhura Isɨhiyaamɨ Awaisɨhonɨnɨ Saahonɨnɨ Jɨhonɨnɨ napɨto. Isɨ amɨ sahɨ baiwɨ tɨmanɨnɨwɨ jaawɨ bimaawɨse,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sata kaundihɨ Pitaaho Jisaasihoai saundataase. “Awasisɨhoŋe, pɨwɨma kɨma sɨwipatɨ namɨhanɨpɨ katingɨma tɨtɨhɨ nyapɨ katapaino e isɨhiya nahatiyaapɨ osamapɨ katapaino?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sata ko nunjesɨhɨ Awaisɨho Pitaahoai wihoaaŋɨha sata kaundataase. “Utaaho komɨ amɨtɨha gaahaisaho diyaamahonɨhɨ otɨpɨpatɨ biyatɨ kaitaise komɨ awaisɨho saundatɨ nisɨ otɨpɨpatɨhiya siyai iwinjaapɨ bindapa nawɨho nandapapɨho tɨtɨhɨ kura nunye undatɨ ahɨwisonɨho? ");
INSERT INTO agm_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Otɨpɨpatɨho otɨpɨpatɨ biyatɨ napaitatɨ kiyatɨ bimonɨhɨ komɨ awaisɨho japɨhɨ nasatɨ mmonata nisɨ otɨpɨpatɨho otɨpɨpatɨ nga kanisataise tatɨ usosɨho so apɨpaahɨ waatɨ awaindɨhandɨ maaritɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nɨnɨ akɨtɨnɨhɨ sangi kasatataato. Utaaho siyahoai komɨ awaisɨho nisɨhapa nahataapa kahapaamapɨpa awaisɨhoŋimatɨpɨ ninjaapɨ bime undatɨ ahɨwitaise. ");
INSERT INTO agm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","O amɨ so otɨpɨpato komɨ awaisɨho ahɨwisɨho komɨ maarɨhoaatɨhapɨ siyatɨ gwɨnyaatɨ nisɨ awaisɨho wɨndɨ ketɨ namaasatɨ konɨhɨ utaarɨhandɨ ketamaitaise tatɨ gwɨnyaataise. Siyatɨ namatɨ otɨpɨpatɨhiya ko winjaatɨ bimisawɨhiya usɨhiyaisunɨ amɨ asɨhiyaisunɨ ahoyatɨ tiwatɨ mɨmaipɨwisatɨ amɨ nandapa nipinjatɨ gwɨsɨha taupɨmatɨ nanatɨ amɨ waapoho pɨhɨtatɨ nanatɨ naharisatɨ nanɨhiyatɨ bimɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Siyatɨ awaisɨho namaapɨtaiso tatɨ nanɨhiyatɨ bimonɨhɨ komɨ awaisɨho asisɨha wetɨ wura akohɨ napɨtaise. Nasatɨ ko koai tiwatɨ otipatɨ iwinjɨwatɨ isɨhiya kiyaamɨ awaisɨhiyaamɨ pɨwɨha atɨhomiwɨ nemahohiyɨhiyai yaawɨhandɨ nunyohɨtɨhandɨ nunyonɨhɨ kandɨ ko netɨ kiyaisatɨ bimɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Awaisɨhomɨ otɨpɨpatɨho komɨ awaisɨho gwɨnyaatɨ maaritirɨhɨretɨ aimɨ mmonatɨ gwɨnyaaho amɨ ko sawaho netɨ wɨndɨ tɨmaamaŋɨnatɨ amɨ komɨ awaisɨho gwɨnyaatɨ maaritimbɨpa wɨndɨ kamaisoai apɨpaahɨ waatɨ komɨ ambɨpatɨ maipiyatɨ yaawɨhandɨ komɨ awaisɨho taahɨwaiwaara yupwoaitaise. ");
INSERT INTO agm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","O amɨ otɨpɨpatɨho komɨ awaisɨho gwɨnyaatɨ maaritirɨhɨretɨ wɨndɨ mmonatɨ gɨmunyaaho amɨ wapa komɨ awaisɨho wɨndɨ gɨmunyaatɨ amɨ maarɨmitimbɨpa nanɨhiyatɨ kaisɨho soai awaisɨho waatɨ taahɨwaiwetɨ wɨndɨ yamupwoaitaise. Utaaho woai wapa Autaahaatɨho taahɨpɨpa numwisɨho so amɨ Autaahaatɨhoai japɨhɨ taahɨpɨpa numwɨtandɨ Autaahaatɨho gwɨnyaataise. Iyatɨ amɨ utaaho woai Autaahaatɨho pɨhɨtatɨ apɨpaahɨ taahɨpɨpa numwisɨho so amɨ Autaahaatɨhoai japɨhɨ apɨpaahɨ pɨhɨtatɨ waatɨ taahɨpɨpa numwɨtandɨ Autaahaatɨho maaritatɨ gwɨnyaataise,” undatɨ Jisaasiho komɨ otɨpɨpatɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisaasiho sata kaundatosatɨ amɨ pɨwɨha wa kiyai saundataase. “Kɨmaapɨ yapɨpataapɨhɨ sisɨha tɨhoaatɨ tɨpotɨ yapɨpatetɨ tɨhɨtandɨ ahaitandɨ napɨtɨhonɨne. Sisɨha tɨhoaatɨ tɨpohotɨha ketɨ tahatɨ tɨhwɨtisatɨ ketɨ netɨ yapɨpati tɨhomaatato ndɨ nisɨ mandɨha yaasataise. ");
INSERT INTO agm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Iyataahandɨ kandɨ isɨhiya waapoho newaawɨ mɨhatɨhɨ nawatiwɨ nandaahohɨpatamataindɨ nɨnɨ nandaatɨ nisɨ maarɨho ambɨpatɨ yaasɨhandɨ naitandɨhaiwa yɨhaiwa taatɨ nasataise. Taatɨ napihɨ nɨnɨ kaiwa ketɨ tarɨwaindɨ netɨ owemaitando ndɨ nisɨ ambɨpatɨ maarɨho netɨ nanopɨsasɨnatɨ naninjɨhandataise. Amɨ kaiwa nɨnɨ sangɨ netaato. ");
INSERT INTO agm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sahɨ wiwa nisapɨ satɨwɨ ko isɨhiyaanɨnɨ itɨhɨnnaatɨ tunaatɨ tipɨtapaata bimohɨtɨhandɨ netɨ owematɨ yatɨhɨ napaisaatenyamaitandɨ nasahoe tɨwɨ gwɨnyaitaawɨ owetise. Nɨnɨ sangi netɨ yatɨhesamatɨ japatindɨ napaisaatisamaitandɨ napɨtɨhonɨnɨmaahe. Owetise. Sahɨ isɨhiyaatangi netɨ tipɨtapaatɨ yɨyandɨhesamaitandɨ napɨtɨhonɨne. ");
INSERT INTO agm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Wanapɨ namasatɨ siyahaiwa noaipaitaise. Isɨhiya ikwɨ naasairɨtahiya nususasɨ aŋaaŋɨ naasaindaapɨhɨ bindawaahiya itɨhɨnnɨwɨ nepɨ yɨyandɨhematɨwɨ tipɨtapaatɨtaapo. Tipɨtapaatɨwɨ wurɨ wihoaaŋɨtanɨhɨ amɨ murɨmo wihoaaŋɨtanɨhɨ itɨhɨnnɨwɨ tundaapo. ");
INSERT INTO agm_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Saiwɨ tipɨtapaatɨwɨ sapɨho mwaahoai itɨhunda tiwonɨhɨ amɨ mwaaho sapɨhoai itɨhunda tiwɨtaise. Iyonɨhɨ amɨ sanaatɨ maataati itɨhunda tiwonɨhɨ amɨ maataatɨ sanaati itɨhunda tiwonɨhɨ amɨ mwaahomɨ apwaataati saihaatɨ itɨhunda tiwonɨhɨ amɨ mwaahomɨ apwaataatɨ saihaati itɨhunda tiwɨtaise,” undatɨ kiyai Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Isɨhiya wɨrɨsandɨhiyai Jisaasiho pɨwɨha wa satahaimaawɨ kaundataase. “Tɨwipatɨ ipɨho nipatihihoaangɨ ahiyatɨ tɨwipatɨ asɨhatihɨ sahɨ jawaawɨ ketɨ sahɨ wipatɨ wipɨwɨtande tɨwɨhiyaate. Satɨwɨ mmonɨwɨ gwɨnyaahauhɨ amɨ wipatɨ tɨtɨhɨ wipɨwataise. ");
INSERT INTO agm_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Iyataatɨ amɨ mbɨpa waatɨ mbwaasɨhɨ japɨ mmonawaawɨ ipɨho ipɨtatɨ yatitande tɨwɨ gwɨnyaawaayopo. Aihɨ amɨ ipɨho ipɨtatɨ yatisataise. ");
INSERT INTO agm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Saiwa siyatɨ yapɨpataapunɨ yamɨhapataatunɨ noaipasɨhɨ sahɨ mmonɨwɨ gwɨnyaawaahandɨ kandɨ sahɨ wanɨ kɨmura taatɨ noaipasɨwɨmaiwaapɨ wɨndɨ mmonɨwɨ gɨmunyaahowɨ sahɨ jaipɨpaisawɨhiyaate,” undatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sahɨ sawanaatɨ mmonɨwɨ gwɨnyaapɨ sandɨ tɨtɨhɨ gaahandɨ kaitɨhaawo maatɨwɨ napaape? ");
INSERT INTO agm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Utaaho wo pɨwɨha netɨ kɨnyɨhetɨ yangutaatɨ pɨwɨha atisatɨ tipɨtapa mmondandɨhoaapɨhɨ nangɨpuwɨtandɨ nangɨmaasi niyonɨhɨ taamɨ daihɨra nomaamɨ pɨwɨha kaundɨpɨ tɨtɨhemapɨ owemapɨse. Saimbɨ kiyapaapaahɨ ko gi wɨndɨ nangɨmaasi notɨ pɨwɨha ususaamɨ atisatɨ netɨ tipɨtapaatɨ mmosɨhoaapɨhɨmaahɨmaitaise. Iyonɨhɨ amɨ ko nangɨmaatɨ tingaatahaisahiyaamɨ ikwɨraatɨhɨmahonɨhɨ amɨ kiya nangɨmaapawɨ napwɨtɨwɨ bimohɨpɨpɨhɨmaahɨmaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nɨnɨ sangi sandɨ kasatataato. Sahɨ napwɨtohɨpɨpɨhɨ wɨndɨ namasi namuwɨ bimaamɨ nuwɨ nawɨho ipotɨho owemapɨho nunyamapaahɨ noaipasi nehɨhaatɨ nutaatɨwe,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aihɨ sura isɨhiya usa Jisaasihoai pɨwɨha wa isɨhiya Garirihandaahapɨhiyaapɨ kaundawaatopo. “Isɨhiya siya maasapɨho sipɨsipɨho taawɨ tipɨ jɨtɨpatɨ namopɨ Autaahaatɨhomɨ ndɨhetɨ ahiyauhɨ amɨ awaisɨho Pairotɨho komɨ tunnɨwɨ yahwɨnohiyɨhiyai kaundihɨ isɨhiya usai tipɨ kiyaamɨ jɨtɨpatɨ maasapɨho sipɨsipɨhomɨ jɨtɨpataatɨhɨ tipɨ naupwɨ ahiyawaayopo,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Saundauhɨ Jisaasihomɨha wihoaaŋɨha kiyai sata kaundataase. “Garirihandaahapɨhiya siya napohiyɨmiyaapɨ sahɨ gwɨnyaawaawɨ kiya maipɨhandɨ apɨpaahɨ awaindɨhandɨ isɨhiya nahatiya Garirihandaahapɨhiyai nusatipɨhaapɨhandɨ kiyauhɨ kandapɨ kiyai tiwawaayopo tɨwɨ gwɨnyaawaayowo? Apɨpaahɨ owetise. ");
INSERT INTO agm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nɨnɨ sangi tɨtɨhɨ akɨtɨnɨhɨ kasatataato amɨ sahɨ samɨ maipɨhaiwa kiyohɨwaiwa namasi japɨhɨ wɨndɨ akɨtɨ namepemaitawaawaahɨ sahɨ nahatiyaatɨ kiyaamataiwɨ napwɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aiwɨ isɨhiya 18 kaiwɨhiyai Siroaamɨhanda aŋaaŋɨ utaarɨhandɨ niyatesi itaatisatɨ tiwihɨ napohiyɨhiyaapɨ kiya maipɨhandɨ apɨpaahɨ awaindɨhandɨ isɨhiya Jerusaremɨhanda bimohiyɨhiya nahatiyai nusatipɨhaapɨ kaiwɨhiyaatawa kandapɨ napowaayopo tɨwɨ sahɨ gwɨnyaawaayowo? ");
INSERT INTO agm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Apɨpaahɨ owetise. Amɨ nɨnɨ tɨtɨhɨ akɨtɨnɨhɨ sangi kasatataato. Amɨ sahɨ samɨ maipɨhaiwa namapɨ japɨhɨ wɨndɨ namepemaitawaawaahɨ amɨ sahɨ nahatiyaatɨ kiyaamataiwɨ napwɨtaapo,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Siyatɨ kaundatosatɨ amɨ Jisaasiho pɨwɨha wa sɨwipatɨ namɨhana sata kiyai kaundataase. “Utaaho wo ipatɨ pikɨhandɨ (katamɨ yandɨho nyamɨ pɨhoaipɨhomatiyahatɨ) wainɨhandamɨ osaataatɨ yamataise. Yamatosatatɨ yandɨpɨho ningoaitaiso tatɨ mmondandɨ notaise. Notɨ mmonata yandɨpɨho wɨndɨ namingotaise. ");
INSERT INTO agm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Namingosɨhɨ namatɨ osaataatɨ jaatosɨhoai saundataase. ‘Kɨnaungwɨha maurɨmairetɨ yandɨpɨho ningotɨ ahotɨtaiso ndɨ nɨnɨ napɨtɨ mmonɨhonɨhɨ amɨ yandɨpɨho wɨndɨ namingose. Isɨ amɨ kɨnyɨ kati tisatɨmape katɨ yapɨpatamɨ atɨpatɨ nehɨhandɨ netɨ owematɨ ahetɨtaiso,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Saundihɨ amɨ osaataatɨ jaatosɨho koai saundataase. ‘Awaisɨhoŋe, kɨnaungwɨha kɨma naasaapɨ kiyatɨ ahetɨta namɨhaape. Kiyatɨ ahetanɨhɨ nɨnɨ katamɨ tambɨpɨhɨ yapɨpatɨ netɨ ikɨsɨmwɨtɨ ahiyatɨ amɨ maasapɨho kauhomɨ ahopaisatɨ ahoyatɨ katamɨ tambɨpɨhɨ ahaitaano. ");
INSERT INTO agm_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Saindɨ kaisanɨhɨ kɨnaungwɨha bousonɨhetɨ yandɨpɨho akoho biyatɨ ningotɨ ahotiso ndo. O amɨ yandɨpɨho namingohonaahɨ gaasɨ kɨnyɨ tisatɨpɨ nemaitaapo,’ undataase,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Asisɨha wa Judaahiya ikɨnohɨha Saararehura Sapaatɨhandetɨ Jisaasiho Judaahiyaamɨ aŋɨhaiwa gwɨharaahaiwa ahoyanɨwɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundohɨwaiwaamɨ wɨndaatɨhɨ pɨwɨha ausaatɨ isɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aihɨ kapɨhɨ apopaatɨ waatɨ bindataise. Saatɨ apopaatɨ itɨpɨho maipɨho kaatamɨ dawaaho netɨ daahɨ kɨsɨmwotɨ ikosisatɨ mmatɨ bimihɨ kɨnaungwɨha 18 kiyahaiwetɨ timbiyatɨ mɨmaipiyatɨ ketinjahaate. Aihɨ kaatɨ wɨndɨ tɨtɨhɨ dotɨ bɨmitohaate. ");
INSERT INTO agm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aihɨ Jisaasiho kaati iwinjatosatɨ gaatatɨ numwaatɨ kaatɨ koenda napihɨ saundataase. “Apopaaŋe, kinyɨ timbɨpa aimɨ nɨnɨ nehɨmataayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nehɨmataayo undatɨ Jisaasiho komɨ ikwɨhatɨmurɨ kaatamɨhetɨ ahɨwihɨ ketɨ kuraanɨhɨ kaatamɨ dawaaho tɨtɨhɨwitatɨ gaatihɨ kaatɨ tɨtɨhɨ mbatatɨ Autaahaatɨhopɨ maaritatɨ Autaahaatɨhoai mepɨ autaahemwataise. ");
INSERT INTO agm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aihɨ utaaho aŋɨhandɨ gwɨharaahandɨ isɨhiya ahoyanɨwɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundɨtaatɨwɨhandɨ jatisɨho sandɨ mmonataatɨ apɨpaahɨ apousamataise. Sandɨ apowindɨmandɨ asisɨha Judaahiya ikɨndaatɨwɨhetɨ kaati tɨtɨhemwaso tatɨ gwɨnyaataate. Apowihɨ ko kiyai saundataase. “Asisɨha otɨpɨpatɨ kaitaatɨwɨha ikwɨrɨ naasairɨtihɨ wɨramɨ naasohɨtahaare. Isɨ asisɨha saiwetɨ napɨwɨse samɨ timbɨpa ko nesamaitando. O amɨ asisɨha kɨma ikɨndɨhaaha Sapaatɨhandetɨ sahɨ samɨ timbɨpa nesamaitandɨ namaapɨwɨse, owetane,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Saihɨ Awaisɨho komɨha wihoaaŋɨha ko aŋɨhandɨ jatisɨho mɨtɨhoai saundataase. “Sahɨ satɨwɨ asisɨha Autaahaatɨhomɨhetɨ nyahɨ siyaatɨ kamaayaahiyaane tɨwɨ jaiwɨtɨwɨhiyaate. Sangisangi asisɨha Autaahaatɨhomɨha Sapaatɨhandetɨ maasapɨho kauho okɨsɨhandɨ amɨ dongiho wɨraposohɨpɨpɨhɨ nuwɨ nesɨpapesi waapoho nandandɨhapɨhapɨ numwaasi nuwɨ nunyawɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Amɨ kɨmaatɨ Abɨraahamɨhomɨ maatɨmaati Bwaasɨrɨhɨrɨ netɨ anɨtisatɨ mmatɨ kɨnaungwɨha 18 kiyahaiwetɨ isɨwatataise. Isɨ amɨ asisɨha Autaahaatɨhomɨhetɨ Bwaasɨrɨhɨrɨ kaatɨ netɨ mmatɨ anɨtisatɨ isɨwatirɨhɨri nemahonɨhɨ kaatɨ noaipatɨ gaatindɨmandɨ tɨtɨhɨmetahandɨ nɨnɨ kiyataayono? Nɨnɨ kɨmandɨ asisɨha Sapaatɨhandetɨ kamaitando e kaitando?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ko pɨwɨha wihoaaŋɨha kaundisɨha atisawaawɨ kopɨ itɨhɨtohiyɨhiyai mawihɨ kiya mapɨpaapiyawaayopo. Iyauhɨ amɨ isɨhiya nahatiyaahɨ ko saiwa nahatewa apɨpaahɨ gaahaiwa kaiwaiwaapɨ maaritawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iyatɨ amɨ Jisaasiho kiyai pɨwɨha sata nunjenataise. “Autaahaatɨho isɨhiyai iwinjaatɨ bimaamɨ naindɨhandapɨ setahande ndɨ napaapɨ namɨhandɨ katɨtande? Napaapɨ sɨwipatɨ namɨhandɨ katɨtande? ");
INSERT INTO agm_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sandɨ ipatɨ nyainyarɨhɨramatiyahatamɨ kwɨtaahomatiyahande. Utaaho kwɨtaaho ko netɨ komɨ osaataatɨ nesotɨ yamataise. Yamasɨhɨ katɨ ipatɨ nyainyarɨhɨramatiyahatɨ nawatɨ awaipatɨ saniyatɨ ahetihɨ koho nasatɨ katamɨ isɨtɨtɨ saatɨtɨhoetɨ itɨha itaayatɨ bindataise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Saundatosatɨ amɨ japɨhɨ wa saundataase. “Autaahaatɨho isɨhiyai winjaatɨ bimaamɨ naindɨhandapɨ nɨnɨ napindapɨ namɨhandɨ katɨtande? ");
INSERT INTO agm_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Sandɨ siyahande. Apopaatɨ waatɨ waatɨpatɨ parawaaho netɨ nipitandɨhandɨ yisɨhandisatɨ ahoyatɨ naumbwaihɨratɨ sanyoaihɨ waatɨ awaindɨ nipindɨhandamatiyahande,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Siyatɨ kaundamapɨ Jisaasiho Jerusaremɨhandaahapɨ taatɨ notaaho kapɨhɨ otɨhapɨhɨ aunahɨpɨhaiwa awaiwaiwaaraahunɨ amɨ gwɨharaahaiwaaraahunɨ notɨ pɨwɨha ausaatɨ kataunjataise. ");
INSERT INTO agm_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aihɨ utaaho wo sata Jisaasihoai nunjenataise. “Awaisɨhoŋe, Autaahaatɨho isɨhiya nehɨ yahonyaisaahɨhɨ numwaitaindɨho?” undataase. Saundihɨ Jisaasiho koai wihoaaŋɨha sata kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Maasomɨhinjɨ maipɨhinjaatɨhɨ sahɨ andɨtitɨwɨ andɨta napamapɨ nandaapɨse. Nɨnɨ sandɨ kasatataato. Isɨhiya taahiyɨhiya maasomɨhinjaatɨhɨ nandaitaatɨwɨ andɨta napamawaahandɨ kandɨ wɨndɨ namandaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aŋaaŋamɨ satɨho dotɨ aŋaaŋamɨ maasomwaaŋɨ netɨ napuwɨtaise. Napuhonɨhɨ sahɨ napɨwɨ ipaahaapɨ bitotawa maasomwaaŋɨ kwɨtapɨ ‘Awaisɨhoŋe, maasomwaaŋɨ nyapɨ nanyupwe,’ tɨtaapo. Sahɨ satisaihɨ ko sangi sasatɨtaise. ‘Nɨnɨ sangi wɨndɨ maasisotɨhiyaatisɨ sahɨ maahapɨhapɨ napɨwɨhiyaate?’ satɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sasatonɨhɨ sahɨ koai saundɨtaapo. ‘Nyahɨ gisaatɨ maasɨ nandapa waapoho nanɨhohiyɨhiyaane. Iyaatɨ amɨ kɨnyɨ nyamɨ daihɨra bitotapa pɨwɨha ausaapɨ katɨpɨnyɨsapɨ kanyatingɨhiyɨhiyaane,’ undɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Sahɨ saundisaihɨhandɨ kandɨ amɨ ko sangi jɨhaatɨ sata kasatɨtaise. ‘Nɨnɨ sangi wɨndɨ maasisotɨhiyaatisɨ sahɨ maahapɨhapɨhiyaate? Sahɨ maipɨhaiwa pɨhɨtɨwɨ nasisoaarɨ kaimbɨwɨhiyaatisɨ sahɨ nahatiyaatɨ nawɨsawitɨwɨ ahawɨse,’ satɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Sasatonɨhɨ sangi nehɨhaapɨ ipaahaapepɨsamasaihɨ kaapɨ bitotawa Abɨraahamɨho, Aisaakɨho amɨ Jekopɨho siyaisunɨ amɨ isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya pɨropetɨhiyaisunɨ Autaahaatɨho winjaatɨ bimonɨhɨ sahɨ kiyai iwinjaitaapo. Iwinjapɨ sahɨ nehɨhaatɨ ipaahaapɨ bitotawa maipaiwɨ gwɨwɨ samɨ mangɨrɨ ikwɨnɨwɨ gitɨwɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Isɨhiya ipɨho noaipasihihoaaŋapɨhiyaunɨ amɨ ipɨho namaatipasihihoaaŋapɨhiyaunɨ amɨ ipɨhomɨ bopimbɨpɨhɨ wihɨwihoaaŋapɨhiyaunɨ Autaahaatɨho iwinjatindɨhandaatɨhɨ nandapa nandaatɨwɨ napɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Saisaihɨ amɨ isɨhiya usa wanɨ noaipapɨ jɨhimatohiyɨhiya ipotimainjaihɨ amɨ isɨhiya wanɨ noaipapɨ ipotimatohiyɨhiya jɨhimatɨtaapo,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aihɨ tɨtɨhɨ suraanɨhɨ Parisihiya usa napɨwɨ Jisaasihoai saundawaatopo. “Kɨnyɨ kɨmbɨhɨ namasi wapɨhapɨ numwe amɨ Erotɨho gi tɨhɨwɨtandiso,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Saundauhɨ ko wihoaaŋɨha kiyai sata kaundataase. “Sahɨ nuwɨ sɨrɨ sɨhwɨ ainjɨhɨrɨhɨrɨ maipiri saundɨwɨse. ‘Atime! Nɨnɨ wanunɨ amɨ bousonɨhunɨ isɨhiyaamɨhetɨ itɨpɨho maipɨhapa ahotimbɨpa nemwatɨ amɨ timbɨpa timbiyohiyɨhiyai tɨtɨhɨwiwɨto. Aindɨ amɨ asisɨha notɨ mairɨmaatisɨhetɨ nisɨ otɨpɨpatɨ kaindɨ owemaito. ");
INSERT INTO agm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aindɨ wanunɨ amɨ bousonɨhunɨ amɨ bousonɨhamɨ bousonɨhunɨ daihɨra daimɨ nutaano, amɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨhoai nehɨhaatɨ wapɨhɨ wapɨhɨ tiwɨtaatɨwɨ sandɨ tɨtɨhɨmaahe. Koai nehɨ Jerusaremɨhandaahɨhɨ tiwisaihɨ kapɨhɨ ko napwɨtande,’ undɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusaremɨhanda bimohiyɨhiyaate, sahɨ isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyai tipɨ yamwaapɨhiyaate. Aiwɨ amɨ sahɨ isɨhiya Autaahaatɨho pɨwɨha nunyatɨ sapɨ natausaasihɨhiyai nawɨhaara nepɨ yahwɨ tipɨhiyaate. Nɨnɨ pɨhɨndɨhaiwetɨ sangi netɨ nasamaatɨ nisɨ ikwɨraatɨhɨ otɨpwɨsɨpaatɨ mwaahoai netɨ ditatotemasɨpatamataindɨ netɨ ahositondiyonɨhandɨ kandɨ sahɨ nisenda namaapɨwɨ nisapɨ pohipaiwɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Atiwɨse! Sahɨ sangi kaiwɨ bimɨtaatɨwɨ Autaahaatɨho aimɨ nasamase. Nɨnɨ sangi tɨtɨhɨ kasatataato. Sahɨ nɨngi wɨndɨ maanisonɨwɨ bimaamɨ nuwɨ sahɨ sawanaatɨ satɨwɨ, ‘Kɨmo Awaisɨhomɨ ambɨpataahɨ komɨ aunahɨpa netɨ napisɨhoai Autaahaatɨho gaahatɨ kawisane,’ tisaihɨhuraatɨtaise,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Asisɨha wa Sapaatɨhandɨ Saararehura Jisaasiho Parisihiyaamɨ mɨtɨhomɨ aŋɨpɨpɨhɨ notɨ nandapa nanataise. Nainjɨhɨ utaaho wo komɨ ambɨpatɨ nahatɨ nipisaho bindataise. Aihɨ isɨhiya kapɨhɨ bimohiyɨhiya koai Jisaasiho tɨtɨhemwaso tɨwɨ Jisaasihomɨhetɨ ndɨha ahiyawɨ iwinjatawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aihɨ ko utaaso ikwauhɨrɨ nahatɨ nipiso kapɨhɨ Jisaasihomɨhinɨ detɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aihɨ Jisaasiho koai usonataatɨ kiya wɨnɨhapɨpa katɨwunjohiyɨhiyaisunɨ amɨ Parisihiyaisunɨ sata nunjenataise “Autaahaatɨhomɨ asisɨha nyahɨ ikɨndɨhaaha Sapaatɨhandetɨ isɨhiyai tɨtɨhɨwiwɨtɨhaawɨ tɨtɨhɨ gaaro e owetiso?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aihɨ kiya wihoaaŋɨha wɨndɨ kamundɨwɨ apɨhɨmundawaayopo. Kiya saiwɨ apɨhɨmundauhɨ Jisaasiho koai numwaatɨ komɨ timbɨpa nemwatɨ natausaasihɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Natausaasihɨ ko naihɨ kiyai sata nunjenataise. “Amɨ samɨ woŋɨ komɨ mwaahoaisangi amɨ maasapɨho kauhoaisangi Autaahaatɨhomɨ asisɨha ikɨndɨhaaha Sapaatɨhandetɨ anɨmwaahɨpata witamahonɨhɨ amɨ gaasɨ kiyatɨ witatotane tatɨ ko wɨndɨ notɨ anɨmwaahɨpatombɨ japɨhɨ namumwaitaiso?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Sata ko kiyai nunjenatɨ kaundihɨ kiya kaamɨ wihoaaŋɨha wɨndɨ kamundopo. ");
INSERT INTO agm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Isɨhiya nandapa nandaatɨwɨ nandaahohiyɨhiya usa mɨtaahoaahɨ mmonɨwinjawɨ gaahasɨnɨ bimaamɨ niyauhɨ kiyai Jisaasiho usonataatɨ kandapɨ pɨwɨha kɨma namɨhanaha sata kaundatataase. ");
INSERT INTO agm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Namaatɨnɨhauhɨ nandapa tɨhohɨpɨpaapɨ isɨhiya gaatisaihɨ numbwɨ isɨhiyaamɨ ndɨhetɨ mɨtaahoaahɨ mbɨmime. Wiwa utaaho wo awaisɨho gi nangɨtipɨhaaho kɨnyapɨ gaatauhɨ napingɨpatamataiwɨ kopɨ gaasaihɨ napɨtaiso. ");
INSERT INTO agm_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nasonɨhɨ utaaho nandapa nasamɨtandɨ maisɨhoaasapɨ gaatisɨho nasatɨ gi sahɨtɨtaise. ‘Kɨhoe kɨmbɨhɨ kɨnyɨ bimingɨpɨmbɨhɨ kɨmo bimɨta kɨnyɨ nɨwupwaape,’ hɨtonɨhɨ kɨnyɨ apɨpaahɨ aungwohandɨ masaamaitaise. Masamahonɨhɨ namapɨ numbwɨ mɨhopɨ usopopɨ bimɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Isɨ isɨhiya kɨnyapɨ namme tɨwɨ gaatisaihɨ nopaapaahɨ usopopɨ numbwɨ bime. Binyamɨhɨ nandapa nahɨmɨtandɨ gaatisɨho gisonatosatɨ sahɨtɨtaise. ‘Kɨhoe kɨmbɨhɨ mɨtaahoaahɨ bimɨta namme,’ hɨtɨtaise. Sahɨtonɨhɨ naimbɨ binyamɨhɨ isɨhiya kisaahoya nandapa maasɨ nandaatɨwɨ niyohiyɨhyai kinyapɨ ko gaahoe tɨwɨ gisosaihɨ bimɨtaape. ");
INSERT INTO agm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sandɨ katohɨtɨmandɨ apaapɨmaato. Utaaho wo mamaawonɨhɨ awaisɨhoniso tatɨ sawaho naimaatɨnataataahɨ Autaahaatɨho netɨ koai yatɨhihonɨhɨ yatɨhitɨtaise. O utaaho mawonɨhɨ ipɨhatisanataataahɨ koai Autaahaatɨho netɨ awaisɨhoemwaitaise,” undatɨ Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Utaaho nandapa nanda napɨwɨse tatɨ Parisiho gaatisɨhoai Jisaasiho sata kaundataase. “Kɨnyɨ isɨhiya nandapa nandaatɨwɨ gaatapaahura isɨhiya tɨtɨhɨ kinyɨhiya aunahɨpa naasɨkata bimohiyɨhiya kahapaamapɨpa asaketahiyai gaatɨpɨ namumwaape. Sandɨ kahɨtohɨtɨmandɨ apaapɨmaahɨto siya isiya kinyɨhapa nandapa numwingɨpɨpaapɨ amɨ kiyaamɨhapa kiyahapa wihoaaŋɨ nahɨmɨtaatɨwɨ gaatɨwɨ nahɨmaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kɨnyɨ nandapa tɨhapaahura isɨhiya maipɨhatɨma kahapaamapɨpa owehatɨma ambɨpatɨ maipɨhatɨma auhɨrɨ maipɨtahatɨma ndɨha niyotahatɨmai gaatɨpɨ numwaape. ");
INSERT INTO agm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Satɨma kɨnyɨ nandapa numwingɨpɨpaapɨ wihoaaŋɨhapa wɨndɨ namaahɨmɨtaapo. Saiwɨ namaahɨnyaihɨ kɨnyɨ waatɨ maaritɨtaape. Isɨhiya Autaahaatɨhopɨ gɨwunyaahohiyɨhiya ainahiyɨhiya anɨmwaahɨpatombɨ japɨhɨ nepasaihɨhura Autaahaatɨho gi kandapɨ wihoaaŋɨhapa nahɨmɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kapɨhɨ isɨhiya bindawa nandapa maasɨ nanɨhohiyɨhiyaamɨ wo koaisamɨ bindamaaho sa pɨwa atɨwisataatɨ Jisaasihoai ko sata kaundataase. “Autaahaatɨho isɨhiyai iwinjaatɨ bimaamɨ naindɨhandaatɨhɨ nandaatɨ nandapa nainjɨho so waatɨ maaritane,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aihɨ Jisaasiho komɨha wihoaaŋɨha sata kaundataase. “Utaaho wo nandapa awaimbɨpa taatɨ tɨmanataatɨ isɨhiya taahiyɨhiya komɨ nandapa aimɨ tɨmetanɨhɨ napɨtaatɨwɨ pɨwɨha nusoaasɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nahataapa nandapa tɨmetanɨhɨ asisɨha nandapa nandaatɨwɨhuraatanɨhɨ isɨhiya aimɨ gaatisawɨhiyaapɨ komɨ otɨpɨpatɨhoai natausaasɨtaise, ko notɨ kiyai nandapa nahataapa aimɨ tɨmetisɨ nandaatɨwɨ napɨwɨse undɨtando. ");
INSERT INTO agm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Iyonɨhɨ kiya nahatiya komɨ gaatisawɨhiya naasɨka katɨwɨ wɨndɨ namaapɨto undawaatopo. Aiwɨ amɨ jɨho sata kaundataase. ‘Osaataatɨ waatɨ wanɨ nawɨho nunya nehonɨ wanɨ mmondandɨ nutandiyo amwihoŋe, wɨndɨ namaapɨto,’ undataise. ");
INSERT INTO agm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Iyonɨhɨ amɨ kapɨho sata kaundɨtaise. ‘Nɨnɨ wanɨ maasapɨho kauho ikwɨmaindɨmwɨtaho otɨpɨpatapɨho wanɨ nawɨho nunya numwaahonɨ wanɨ nundɨ namɨhandɨ mmondandiyonɨ amwihoŋe wɨndɨ namaapɨto,’ undɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Iyonɨhɨ amɨ kapɨho sata kaundɨtaise. ‘Nɨnɨ wanɨ apopaati netɨ wɨrahonɨ wɨndɨ namaapɨto,’ undɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Satɨwɨ nahatiya kaundauhɨ otɨpɨpatɨho namasi notɨ komɨ awaisɨhoai satɨwɨ satɨwɨ owe namaapɨto tauhɨ namasi japɨhɨ nasataayo undataase. Saundihɨ aŋaaŋamɨ satɨho sa atisatosatɨ apowihɨ komɨ otɨpɨpatɨhoai saundataase. ‘Wanɨ ketɨ kɨnyɨ nihɨti numbɨwɨ aunahɨpatamɨ daihɨra awairɨhɨraatɨhunɨ gwɨharaahasɨnyaatɨhunɨ daapɨ isɨhiya maipɨhatɨma kahapaamapɨpa owehatɨmaisunɨ ambɨpatɨ maipɨtahatɨmaisunɨ auhɨrɨ maipɨtahatɨmaisunɨ amɨ ndɨha niyotahatɨmaisunɨ numwaasi napisamɨhɨ nisɨ aŋɨtɨtɨhɨ nandaita numwe,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sata kaundihɨ ko otɨpɨpatɨho awaisɨhomɨ kaundisɨha kiyatɨ owetihɨ awaisɨhoai saundataase. ‘Awaisɨhoŋe kɨnyɨ kandingɨmumwaaŋɨ kamwaaŋɨ japepihɨrɨtɨ aimɨ kiyonɨhandɨ kandɨ aŋaaŋɨ isɨhiya wɨndɨ tɨmisainje. Owetise,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Saundihɨ awaisɨho komɨ otɨpɨpatɨhoai jɨhaatɨ saundataase. ‘Kɨnyɨ japɨhɨ numbwɨ daihɨra awairɨhɨraunɨ amɨ osaataatapɨhɨraamɨ naaporɨhɨrainunɨ isɨhiyaapɨ daapɨ usonapaahiyai tarɨwundɨpɨ numwaasi napɨta numwe amɨ nisɨ aŋaaŋɨ apɨpaahɨ nga tisaitɨto. ");
INSERT INTO agm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nɨnɨ sangi kɨmandɨ kasatataato. Isɨhiya nandapa nandaatɨwɨ gaatohiyɨhiya siya nisɨ nandapa apɨpaahɨ akɨtɨnɨhɨ masehonyaisangi wɨndɨ nepɨ namandaapo. Owetɨtaise,’ undataase,” tatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wura isɨhiya taahɨtɨhandɨ wɨrɨsandiwɨ Jisaasihoai nuwipinjai niyauhɨ Jisaasiho nepemaitatɨ kiyai sata kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Utaaho wo nɨngi nanipinja nisɨ otɨpɨpatɨhoematɨtandɨ nisenda nasataahandɨ kandɨ komɨ saniyɨ sapiyaisunɨ amɨ saingo saahoyaisunɨ sanasɨhiyaisunɨ amɨ komɨ apwaataatisunɨ amɨ metɨhonyaisunɨ amɨ sawaho biyatɨ itatamanɨnatɨ bimɨtandɨhandisunɨ komɨ maarɨho wɨndɨ namunyamatɨ kiyaisunɨ amɨ sawahoaisunɨ pohipiyamatɨ nehɨ nɨngisaahɨhɨ komɨ maarɨho apɨpaahɨ awaindɨhandɨ wɨndɨ namaaninyataataahɨ amɨ ko noaipatɨ nisɨ otɨpatɨhoemaamatɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Iyatɨ ko komɨ ipɨ tɨtɨhɨ atawɨhatɨ netɨ wɨndɨ tɨmɨpwɨtatɨ amɨ nɨngi namaanipinjataataahɨ amɨ ko nisɨ otɨpɨpatɨ wɨndɨ mmonatɨ netɨ kiyatɨ nɨngi ko wɨndɨ namaanimbinjɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Iyataatɨ sahɨ usaatɨ aŋaaŋɨ waaŋɨ utaarɨhaaŋɨ mɨhaatɨ nuwatɨhandɨ aŋɨmatɨtaatɨwɨ gwɨnyaawaawɨ jɨhɨ bindawa nawɨho napitiyahora nga aŋɨmata owemaito tɨwɨ jɨhɨ gwɨnyaapɨ mmonɨwɨ tɨtɨhemaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","O sahɨ saiwɨ jɨhɨ wɨndɨ kamaiwɨ nehɨ topɨtaata yapɨpatetɨ sɨmenɨhandɨ namasawɨ kaisaihɨ nawɨho owetanɨhɨ namɨhaitaapo. Namɨhaasaihɨ isɨhiya nahatiya usa mmonawa sisɨpɨhɨsatɨwɨ sasatɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Ise isɨmiya kɨmiya aŋaaŋɨ aŋɨmatɨtaatɨwɨ aŋɨmatohiyaasɨ ketɨ owemaamapo,’ satɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Iyataatɨ amɨ awaisɨho wo yapɨpatisunɨ isɨhiyaisunɨ jaatɨ bimisɨho amɨ awaisɨho wo yapɨpatisunɨ isɨhiyaisunɨ ja bimisɨhoaisa tundandaahɨ amɨ bindata jɨhɨ biyatɨ gwɨnyaatɨ kaitaise. Ko komɨ pwɨsɨpɨ yaipa kaiwɨ tunnɨwɨ yahwɨnohiyɨhiya 10 tausenɨ kaiwɨhiyaatɨtaise. Iyonɨhɨ amɨ womɨhiya pwɨsɨpɨ yaipa kaiwɨ tunnɨwɨ yahwɨnohiyɨhiya 20 tausenɨ kaiwɨhiyaisatɨ napɨtaise. Iyonɨhɨ awaisɨho 10 tausenɨ kaiwɨhiyaisaho nɨnɨ awaisɨho tunnɨwɨ yahwɨnohiyɨhiya 20 tausenɨ kiyahiyaisoai nɨnɨ nga nɨnɨhematɨtɨ titɨ yahwɨtɨ ipatitondɨho tatɨ jɨhɨ bindata mmonatɨ gwɨnyaitaise. ");
INSERT INTO agm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Siyatɨ mmonatɨ gwɨnyaataatɨ komɨhiyaisatɨ ko nga wɨndɨ awaisɨho 20 tausenɨ kiyahiyaisahoai tiwatɨ maapatitaahetanaahɨ komɨ tiworɨho kaanɨhɨ bitohonɨhura yɨhoaaŋɨ wɨndɨ tɨmunɨha namɨhaitɨhaawo undatɨ isɨhiya usai natausaasonɨhɨ kiya nuwɨ wɨndɨ tɨmundaatɨwɨ kaundɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Isɨ amɨ sɨkɨretɨ samɨ wo komɨhapa nahataapai namaamataataahɨ ko noaipatɨ wɨndɨ nisɨ otɨpɨpatɨhoemaamatɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jisaasiho pɨwɨha wa sata kaundataase. Sapɨpaahɨ amɨ gaahape. Iyataahandɨ kandɨ kapaamɨ jɨpaindɨhandɨ owetonaahɨ nyahɨ napitaisaihɨ sapɨpaamɨ jɨpaindɨhandɨ japɨhɨ jɨpaitaise? ");
INSERT INTO agm_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sapɨpa siyatɨ jɨpaindɨhandɨ owehapa nyahɨ nandapaamɨ osaataatɨ yapɨpatisa ahoyaatɨ wɨndɨ ahɨmaito. Iyaatɨ amɨ maasapɨho kauhomɨ ahopaisaatɨ newa nambwaihɨraatɨ osaataatɨ wɨndɨ ahɨmaito. Nyahɨ kapa nehɨ yotaahiyaanɨne. Sahɨ pɨwɨha baiwɨ mwɨtɨpisawɨ atitaatɨwɨ atihɨrɨsahiyaatisɨ baiwɨ atiwɨse,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wura isɨhiya isɨhiyaamɨ nawɨho gamanɨho otɨpɨpatɨ kaitandɨho nehohiyɨhiyaatihɨ amɨ isɨhiya maipɨhaiwa kaiwɨhiyaatihɨ komɨ pɨwɨha atitaatɨwɨ Jisaasihoaapɨhɨ detɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Saiwɨ nasauhɨ Parisihiyaunɨ amɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ Jisaasihopɨ itɨhɨtɨwɨ satawaatopo. “Kɨmo utaamo isɨhiya apɨpaahɨ maipɨhaiwaisahiyai naisomwatɨ nandapa kiyaisatɨ maasɨ nanataise,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Satɨwɨ katauhɨ kandapɨ Jisaasiho pɨwɨha kɨma namɨhanaha sata kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Samɨ wo maasapɨho sipɨsipɨho 100 kiyaho yamanatɨ urɨpitohotɨtaise. Yamanatɨ urɨpitohonɨhɨ nehɨ naasohɨhɨ nihɨrɨndaise. Nihɨrɨnɨhonɨhɨ sipɨsipɨho 99 kiyaho woyɨha nanatɨ wapɨhɨ bitohonɨhɨ naasohɨ nihɨrinjɨhopɨ notɨ pɨhɨtatɨ daitaise. Daapɨ daapɨ notɨ mmonatɨ numwaitaise. ");
INSERT INTO agm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Siyatɨ daatɨ mmonatɨ numwaatɨ netɨ komɨ ikotɨhaasɨnɨ tɨpwinji maaritɨmɨ aunahɨpataahapɨ japɨhɨ numwaasi napɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Numwaasi nasatɨ komɨ aŋɨpɨpɨhɨ noaipatɨ komɨhiyaapunɨ amɨ isɨhiya usa aunahɨpatɨ naasaipitaahapɨhiyaapunɨ gaatonɨhɨ kiya napɨwɨ ahoyandaapo. Napɨwɨ ahoyainjaihɨ ko kiyai saundɨtaise. ‘Nisɨ maasapɨho sipɨsipɨho wo naasohɨ nihɨrɨnatɨ aimɨ owetihɨho nɨnɨ pɨhɨndɨ dambɨtɨ aimɨ japɨhɨ numwaataayonɨ kandapɨ sahɨ nɨngisawɨ maasɨ maaritɨwɨse,’ undɨtaise,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iyatɨ Jisaasiho kiyai saundataase. “Nɨnɨ sangi tɨtɨhɨ kasatataato, sɨkɨretɨ utaaho wo maipɨho maipɨhaiwa kiyaho komɨ maipɨhaiwa namasi japɨhɨ nepemaitihɨhopɨ yamɨhapataatɨhɨ maaritawaayopo. Iyataatɨ amɨ akɨte isɨhiya 99 kaiwɨhiya aimɨ tɨtɨhɨ gaahiyaatawa wɨndɨ japɨhɨ namepemaitɨtaatɨwɨhiyaapaahɨ amɨ maaritawaayopo. Siyawaahandɨ kandɨ utaaho itapa wo waatɨ maipɨhaiwaisahiya kiyaamɨ maipɨhaiwai namasi japɨhɨ nepemaitohiyɨhiya siyaapɨ yamɨhapataatɨhapɨhiya apɨpaahɨ waatɨ aungwohandɨ maaritawaayopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Amɨ Jisaasiho pɨwɨha wa namɨhanaha satatɨ kandaase. “Amɨ apopaatɨ waatɨ nawɨho soaarindisɨho ikwɨmaindɨmwɨtaho 10 kina kiyatɨ isɨwatonɨhɨ otɨhatɨhapɨ nehɨ naasohɨ nihɨrɨnɨhonɨhɨ kaatɨ napitaitaise? Amɨ kaatɨ norɨhɨrɨ netɨ tɨpotɨ aŋɨtɨtɨhɨ gwaasɨha nawotɨ tɨwɨhaatɨ naihoaatɨ biyatɨ mwɨtɨpisatɨ pɨhɨtatɨ daitaise. Daapɨ nunjatɨ nawɨho soaarindisɨho japɨhɨ netosatɨ sandɨhɨ mɨndaatɨ namɨhaitaise. ");
INSERT INTO agm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Siyatɨ kaatɨ mmonatɨ japɨhɨ aimɨ netosatɨ kaatamɨ naisɨhiyaisunɨ amɨ isɨhiya kaatamɨhinɨ detɨ aunahɨpatɨ naasaipitɨ kata bimohiyɨhiyaisunɨ gaatatɨ numwaatɨ napɨwɨ ahoyainjaihɨ kiyai kaatɨ saundɨtaise. ‘Naisɨhiyaate, sahɨ nɨngisawɨ maasɨ maaritɨwɨse. Amɨ nisɨ nawɨho soaarindisɨho nehɨ naasohɨhɨ nihɨrinjɨho ko amɨ nɨnɨ wanɨ daatɨ aimɨ japɨhɨ netaayono,’ undɨtaise,” undatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iyatosatɨ Jisaasiho sandaase. “Nɨnɨ sangi tɨtɨhɨ kasatataato. Sɨkaiwɨ Autaahaatɨhomɨ otɨpɨpatɨhiya yamɨhapataatɨhapɨhiya utaaho wo maipɨho maipɨhaiwa kiyaho komɨ maipɨhaiwaatɨhapɨ japɨhɨ nepemaitihɨhopɨ asakaiwɨ waatɨ aungwohandɨ maaritawaayopo,” undatɨ kiyai Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Amɨ Jisaasiho pɨwɨha wa jɨhaatɨ namɨhanaha konɨhɨ kiyai kaundataase. “Utaaho wo mwaahurɨ yahurisaho bindataise. ");
INSERT INTO agm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Aihɨ kurɨ komɨ mwaahuramɨ ipotɨho sapɨhoai saundataase. ‘Apore, kahapaamapɨpa nahataapa taasɨhoaisɨha yɨhoaanyangi tipɨtapaapɨ nanyamɨtaapɨ isɨwatingɨpɨpaapɨ nɨnɨ gwɨnyaataayo. Saindɨ gwɨnyaataayonɨ wihoaaŋɨhapa tipɨtapaapɨ nisapɨhapa wanɨ kɨmura nɨngi naninye,’ undataase. Aihɨ amɨ kuramɨ sapɨho komɨhapa nahataapa wihɨwihoaagɨ mwaahurapɨ tipɨtapaatɨ kuri nunyataise. ");
INSERT INTO agm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Siyatɨ sapɨho kopɨhapa tipɨtapa numwihɨ wɨndɨ otɨhɨmetihɨ ketɨ komɨhapa nahataapa netɨ ahoyatɨ isɨhiyai nawɨhopɨ nunyatɨ nawɨho netaise. Iyatɨ ko ipotɨho nawɨho netɨ isɨsi komɨ aunahɨpatɨ bimipata namasi yapɨpatɨ wɨta kaanɨhɨ notɨ bindataise. Notɨ kapɨhɨ bindata nosasɨnatɨ mɨmaipiyatɨ nawɨho nopɨsasatɨ iwɨrisatɨ tɨmataise. ");
INSERT INTO agm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Siyatɨ komɨ isɨwatimbɨpa nosasatɨ iwɨrisatɨ tɨmatɨ owetihɨhura satɨ yapita jarɨho aungwohandɨ noaipasɨhɨ ko nandandɨhapa owendaise. ");
INSERT INTO agm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aihɨ ko utaaho wo satɨ yapitaahapɨhomɨ otɨpɨpatɨ kawitandɨ notaise. Notɨ iwinjasɨhɨ ko komɨ maasapɨho yaurɨmana iwinjaatɨ bimɨtandɨ netɨ natausaasihɨ notɨ maasapɨho yaurɨmanataise. ");
INSERT INTO agm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Notɨ yaurɨmanatɨ bindataatɨ koai jaumasɨhɨ maasapɨho dipamasɨpɨpa atɨpɨpatɨ taupwɨrɨhɨramɨ pasaaha netɨ nandandɨ gwɨnyaataise. Siyatɨ jaumasɨhɨhandɨ kandɨ isɨhiya usa koaisɨ nandapa wapa namunyopo. ");
INSERT INTO agm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ko siyatɨ mɨmaipiyatɨ bimainjatɨ ipotɨnɨhɨ biyatɨ gwɨnyapenataatɨ sawaho sanataase. ‘Isɨhiya apɨhomɨ otɨpɨpatɨ kawitaatɨwɨ apɨho numwaasawɨhiyaahɨ nandapa nyahounjɨhɨ nanɨwɨ bimauhɨhandɨ nɨnɨ kɨmbɨhɨ aungwohandɨ jarindɨ napwɨtandiyo. ");
INSERT INTO agm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Isɨ nɨnɨ kɨmbɨhɨ namasisɨ dosi nisɨ apɨhoenda naitaano. Naindɨ apɨhoai saundɨtando. ‘Apore, Autaahaatɨhoaisunɨ amɨ gisunɨ pohɨtahandɨ maipɨhandɨ nɨnɨ kiyataayo. ");
INSERT INTO agm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kɨnyɨ nɨngisɨ nisɨ maasɨho ndɨpɨ ambɨhɨmandɨme. Kinyɨ otɨpɨpɨpatɨ kahitaatɨwɨ numwaahingɨyɨhiyaamataindɨhonɨnimatisanɨhɨ kɨnyɨ nisapɨ nisɨ otɨpɨpatɨhoe tɨpɨ nisondaape undɨtaano,’ tatɨ sawaaho kanataase. ");
INSERT INTO agm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Siyatɨ gwɨnyaatɨ kanamapɨ dosisaahɨ sapɨhoenda niyataise. “Siyatɨ aŋɨpɨpɨhɨ sangɨ noaipatɨ daihɨra kaanɨhɨ taatɨ napihɨ sapɨho koai iwinjataatɨ sapɨho kopɨ maarɨho tundamataise. Tundihɨ sapɨho naupwasi mwaahomɨhinɨ detɨ notɨ mwaahoai namaahatata gerundataase. ");
INSERT INTO agm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Siyatɨ gerundihɨ mwaaho sapɨhoai saundataase. ‘Apore, nɨnɨ maipɨhaiwa Autaahaatɨhoai poundatɨ amɨ gisɨ pohɨtahaiwa kiyataayo. Isɨ kɨnyɨ nɨngisɨ maasɨho ndɨpɨ ambɨhɨmandɨtaape,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Sata mwaaho kaundihɨhandɨ kandɨ sapɨhohɨ komɨ otɨpɨpatɨhiyai saundataase. Nisɨ otɨpɨpatɨhiyaate, ketɨ apotɨhɨrɨ utaarɨhɨrɨ apɨpaahɨ gaahɨrɨ tiwatɨhaatɨ niyohotɨhɨrɨ nuwɨ nesipɨwɨ nɨwipaapɨse. Aiwɨ amɨ utɨhɨrɨ gaahɨrɨ nesipɨwɨ komɨ isundɨpɨhoetɨ nɨwiwɨse. Aiwɨ amɨ atasɨhaapɨhɨ asuipatɨ nesipɨwɨ nɨwipaapɨse. ");
INSERT INTO agm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aiwɨ amɨ maasapɨho kauho ambɨpatisaho gaaho nuwɨ nepɨse. Nepɨ tɨhɨwise ko nanaatɨ maaritɨtɨhaawo. ");
INSERT INTO agm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sandɨ katotɨmandɨ apaapɨmaato. Kɨmo nisɨ maasɨhɨmo aimɨ napomatatɨho wanɨ japɨhɨ asohoemainjɨhɨto. Iyatɨ amɨ ko aimɨ nihɨrɨnatɨ owetatatɨho ko wanɨ japɨhɨ usonataatɨto,’ undɨtaise. Saundonɨhɨ nandapa maasapɨho tipɨ tɨhɨwɨ nanɨwɨ komɨ mwaahopɨ maaritɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Komɨ mwaaho jɨho sura osaataatɨ otɨpɨpatɨ kiyataise. Kiyamapɨ japɨhɨ aŋɨpɨpɨhapɨ nasataise. Nasatɨ aŋaaŋamɨ detɨtihɨ atisataatɨ aŋɨpɨpɨhapɨ apwɨtɨhɨrɨ ipopɨ aunɨhɨhɨrɨ katɨwɨ waipatɨ ahiyawɨ maaritotɨhandɨ ŋuŋaaha atisataise. ");
INSERT INTO agm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Atisataatɨ otɨpɨpatɨho woai gaata numwaatɨ sata nunjenataise. Kɨmandɨ apwɨtɨmɨrɨ ŋuŋaamandɨ napaape?” undatɨ nunjendaise. ");
INSERT INTO agm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nunjenɨhonɨhɨ otɨpɨpatɨho wihoaaŋɨha koai saundɨtaise. ‘Kinyɨ kunyɨhɨho aimɨ japɨhɨ nasatɨ noaipasɨhɨ gapɨho maasapɨho kauho mwaaho gaaho ambɨpatisaho tiwatɨ tɨhataise. Iyatɨ ko wɨndɨ namopɨsasɨnatɨ gaaho napihe,’ undɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Saundonɨhɨ komɨ mwaaho jɨho sa pɨwa atisataatɨ apɨpaahɨ apousamahonɨhɨ ko wɨndɨ aŋɨtɨtɨhɨ niyatɨ namɨndaitaise. Owe. Iyonɨhɨ komɨ sapɨho noaipasi nasatɨ komɨ mwaaho jɨhoai bɨpi pɨwɨha napaisaatunda aŋaaŋɨ nandaape undɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Undonɨhɨ ko wihoaaŋɨha sapɨhoai saundɨtaise. “Kɨnyɨ mmopɨ gwɨnyaape, nɨnɨ kɨmbɨhɨ kɨnaungwɨha taahɨwaiwetɨ kinyɨ otɨpɨpatɨhiyaamataindɨ otɨpɨpatɨ kahisataayo. Saindɨ nɨnɨ kiyataatɨ kinyɨ pɨwɨha kandingɨwaiwa nemaahɨmatɨ baindɨ atɨhisataayo. Saindɨ nɨnɨ kiyohɨtɨhandapɨ nɨngisɨ napindɨ naninyapaise? Nisɨ naisɨhiyaisatɨ nandɨ maaritɨtandɨ maasapɨho memetɨrɨsangi wɨndɨ nepɨmaanɨmise. ");
INSERT INTO agm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Saimbɨ nɨngi kamaanimbɨ kinyɨ kimwaaho kɨmo kinyɨ kahapaamapɨpa ikɨpɨpa numwingɨpɨpa nesotɨ isɨhiya taahiyɨhiyaamɨ apwaatiyaapɨ nosasatɨ tɨmatɨ kainjatɨ japɨhɨ napihɨ kopɨ kɨnyɨ maasapɨho kauho mwaaho ambɨpatisaho tipɨ tɨhapaise,’ undɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Undonɨhɨ amɨ sapɨho koai wihoaaŋɨha sata kaundɨtaise. ‘Nisɨ maasɨho, kɨnyɨ asisɨ nahatewetɨ kɨmbɨhɨ nɨngisapɨ nasisoaarɨ bindapaise. Iyataatɨ amɨ kahapaamapɨpa nɨnɨ isɨwasohɨpɨpa nahataapa kinyɨhapaare. ");
INSERT INTO agm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Iyataahandɨ kandɨ wanɨ nyahɨ maaritɨtɨhaawo. Sandɨ apaapɨmaato, kinyɨ kunyɨhɨho aimɨ napomatatɨho japɨhɨ asohoemainjɨhɨto. Iyatɨ amɨ ko aimɨ nihɨrɨnatɨ owetatatɨho wanɨ japɨhɨ usonɨhaawɨhɨto,’ undɨtaise,” undatɨ Jisaasiho pɨwɨha namɨhanaha kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisaasiho pɨwɨha kɨma namɨhanaha komɨ otɨpɨpatɨhiyai sata kaundataase. “Utaaho wo kahapaamapɨpa asaketaho woai ahɨwihɨ komɨhapa nahataapa awaisoematatɨ iwinja bimoho bindataise. Aihɨ so kahapaamapɨpa asaketisoai usa pɨwɨha saundawaatopo. ‘Kinyɨ otɨpɨpatɨ kahapaamapɨpa ginjaatɨ bimɨtandɨ awaisɨho ahɨwingɨho kinyɨ otɨpɨpatɨho kinyɨ nawɨho kahapaamapɨpa nahopisasataise,’ tɨwɨha pɨwɨha kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Saundauhɨ namatɨ ko komɨ otɨpɨpatɨ iwinjatisɨhoai gaata numwaatɨ sata nunjenataise. ‘Kɨma pɨwɨha kinyapɨ satɨwɨha kandauhɨ atisataayonɨ kɨnyɨ sandɨ tɨtɨhɨ akɨtɨnɨhɨ kainɨhandapɨndowo? Kɨnyɨ nisɨ otɨpɨpatɨhoŋimatɨpɨ nisɨ otɨpɨpatɨ ninjaapɨ wɨndɨ bɨmimɨtainɨ nehɨmasanɨhɨ namapɨ kɨnyɨ numbwɨ bindapa kahapaamapɨpa kinyɨ ikwɨraatɨhɨ ahiyohɨpɨpaapɨ otɨpɨpatɨ saindɨ saindɨ kaindɨ saindɨ ginjatataayo tɨpɨ nahataapaapɨ baimbɨ jɨpatɨpaime,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Aihɨ komɨ otɨpɨpatɨho sawaho sata gwɨnyapenataise. ‘Nisɨ awaisɨho komɨ otɨpɨpatɨ kawisohɨpataatɨhapɨ nenɨmaitandise. Isɨ nɨnɨ napitaitande? Nɨnɨ wɨndɨ andɨtindɨ nandapa yapasatɨ namayaamaito. Isɨhiyai nandapaapɨ itundɨtɨ netɨ nandandɨ sandɨ manyɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nisɨ awaisɨho komɨ otɨpɨpatɨ iwinjaatɨ bimohɨpataatɨhapɨ nenɨmahonɨhura isɨhiya nanɨmaapɨ nandapa nanɨmɨtaatɨwɨhandapɨhɨra daihɨraapɨ saindɨ saitaano ndɨ gwɨnyaitaano,’ tatɨ gwɨnyaataise. ");
INSERT INTO agm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ko siyatɨ gwɨnyaataatɨ namatɨ isɨhiya komɨ awaisɨhomɨhapa nandapa nehɨ nepɨ nɨwɨnɨhohiyɨhiyaapɨ gaatihɨ kiyaamɨ nehɨ nɨnaasohɨhɨ niyatɨ iwinjataise. Jɨhɨ niyatɨ iwinjasɨhoai sata nunjenataise. ‘Kɨnyɨ nisɨ awaisɨhomɨhapa napitaimbɨhapa nehɨ nepɨ nanɨhise?’ undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Aihɨ ko wihoaaŋɨha sata kaundataase. ‘Atɨpatɨ onɨha awaisɨha 100 kiyahaiwa nehɨ netɨ nanataayo,’ undataase. Aihɨ awaisɨhomɨ otɨpɨpatɨho koai saundataase. ‘Kɨnyɨ nandapa nehɨ nepɨ nanɨhingɨpɨpaamɨ utɨpɨho kɨmosɨ koaatɨhɨ 50 kiyate tɨpɨ bindapa ketɨ jɨpatɨpaime,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Aihɨ amɨ kasɨnɨ wo niyatɨ iwinjasɨhɨ awaisɨhomɨ otɨpɨpatɨho koai saundataase. ‘Kɨnyɨ nisɨ awaisɨhomɨ nandapa napitiyahapa nehɨ nepɨ nanapaise?’ undataase. Aihɨ amɨ komɨha wihoaaŋɨha sata kaundataase. ‘Nandapa konɨho witɨhandɨ ikihɨ 100 kiyahapa nanataayo,’ undataase. Aihɨ amɨ ko koai saundataase. ‘Kɨnyɨ nandapa nehɨ nepɨ nanɨhingɨpɨpaapɨ utɨpɨho kɨmosɨ koaatɨhɨ 80 kiyate tɨpɨ bindapa ketɨ jɨpatɨpaime,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Aihɨ awaisɨho otɨpɨpatɨho mɨmaipiyatɨ kaisopɨ maarita koai nɨwimaataise, ko biyatɨ gwɨnyaasɨtɨhanda siyatɨ kaihɨ mmonatɨ gwɨnyaataato. Isɨ isɨhiya kɨmaapɨ yapɨpatambɨhiya otɨpɨpatɨ amɨ wapa nawɨhaiwɨ kiyohɨtɨhanda Autaahaatɨhomɨ isɨhiyai daahepumapɨ nusatipɨhaahopo. ");
INSERT INTO agm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Nɨnɨ sandɨ kasatataato. Kɨmaapɨ yapɨmbatambɨ nawɨho maipɨhora sahɨ isɨhiyai naisomwapɨse. Saisaihɨ sahɨ nawɨho isɨwatohɨho notɨ owetanɨhura kiya sangi maaritɨwɨ nasamaasi naiwɨ aunahɨpatɨ sahɨ jinjapɨhɨ jinjapɨhɨ apɨpaahiyaatɨ bimɨtaatɨwɨhataahesaiwɨsamaito. ");
INSERT INTO agm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Amɨ utaaho wo wapa maipɨhonya biyatɨ itatamanatɨ nga jatataataahɨ amɨ so awaimbɨpaisangi biyatɨ itatamanatɨ nga jatɨtaise. O amɨ utaaho wo wapa maipɨhonya biyatɨ itatamanatɨ napaitatɨ minjatatɨ netɨ nopɨsasatɨ iwɨrisataataahɨ amɨ sɨkɨretɨ wapa awaimbɨpaisangi netɨ nopɨsasatɨ iwɨritaise. ");
INSERT INTO agm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Isɨ sahɨ kɨmaapɨ yapɨpatambɨhapa nawɨho baiwɨ itatamanɨwɨ minjatisaihaahɨ akɨpɨpa sahɨ jatɨtaatɨwɨ ndɨ nasamɨtaise? ");
INSERT INTO agm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aiwɨ amɨ sahɨ usaamɨhapa kahapaamapɨpa wɨndɨ baiwɨ itatamanɨwɨ minjatisaihaahɨ sawanaatapɨhapa sangi ndɨ nasamɨtaise? ");
INSERT INTO agm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Utaahurɨ awaisururamɨ otɨpɨpatɨ utaaho wo nehɨ naasohɨ otɨpɨpatɨ maisahuramɨhatɨ wɨndɨ kamaawitaise. Wopɨ pohipiyatɨ wopɨ maaritɨtaise. Woaisɨ nɨwipinjata woaisɨ ahosumwaitaise. Sahɨ Autaahaatɨhomunɨ amɨ nawɨhomunɨ osamapɨ otɨpɨpatɨhiyaatimaamatɨtaapo,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jisaasiho saiwa siyatɨ kaundihɨ isɨhiya Parisihiya saiwa atisawaawɨ nawɨhoai maarɨho waatɨ nunyawɨhiyaasɨ yaiho napaapɨ sata katise tɨwɨ Jisaasihopɨ sisawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kiya kopɨ saiwɨ sisauhɨhandɨ kandɨ ko kiyai sata kaundaase. “Sahɨ isɨ kɨmiyaatɨ isɨhiya sapɨ gaahiye tɨtotɨwɨ kiyaamɨ ndɨhetɨ jaiwaiwɨ gaahaiwa kaiwɨhiyaate. Saiwɨ sahɨ kiyauhɨ Autaahaatɨho aimɨ samɨ omaŋɨtɨtɨhɨ maarɨhoaatɨhɨ jasose. Kahapaamapɨpa wapai isɨhiya maarɨho nunyawɨ mepɨ autaahemwahohɨpɨpa sapa Autaahaatɨhomɨ ndɨhetɨ awaimbɨpaamaahe, nehɨhapaimatataise. ");
INSERT INTO agm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Autaahaatɨhomɨ wɨnɨhapɨpa Mosesiho ahaimbɨpaunɨ Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaamɨ pɨwɨhaunɨ ahotɨmɨ nasatɨ Jonɨho Isɨhiyai Baawusisɨhoaapɨhɨndaise. Aihɨ amɨ suraapɨ Autaahaatɨho isɨhiyai iwinjaatɨ bimaamɨ naindɨhandapɨha pɨwɨha namasatɨ noaipataise. Aihɨ isɨhiya Autaahaatɨho iwinjaatɨ bimɨtandɨhatɨhɨ andɨtitɨwɨ nandaawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yamɨhapatunɨ yapɨpatunɨ owendaahandɨ kandɨ wɨnɨhapɨpa apɨpaahɨ maipɨhonjisangi wɨndɨ owemetɨtaise. Owe, kapaanɨhɨ ahotɨmɨ nutaise,” unda Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jisaasiho amɨ kiyai pɨwɨha wa sata kaundataase. “Isɨhiya usa apwaatiyai jɨhɨ nepɨ wɨrapawɨ amɨ kiyai namaposawɨ asɨyɨhiyai jɨhaatɨ nepɨ wɨrahotɨhandɨ sandɨ kiyaamɨ namaatɨnohɨtɨhandɨ nepɨ nosasawaayopo. Iyataatɨ amɨ itapaatɨ waatɨ jɨhura warɨho namahonɨhaatɨ nehɨ bimonɨhɨ utaaho wo netɨ kaati wɨrataataahɨ so utaaso namaatɨnohɨtɨhandamɨ wɨnɨhapɨpa netɨ nosasataise,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisaasiho amɨ pɨwɨha wa namɨhanaha kiyai sata kaundataase. “Utaaho wo nawɨho kahapaamapɨpa asaketaho utɨ apotɨhɨrɨ watɨpɨhapa apɨpaahɨ sanahɨwetatɨ gaahapaahɨhɨ niyotɨ nipaatatɨ amɨ nandapa apɨpaahɨ gaahapa jɨpiyahapaahɨhɨ asisɨ nahatewetɨ nanatɨ bisondaise. ");
INSERT INTO agm_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aihɨ amɨ utaaho wo nawɨho kahapaamapɨpa apɨpaahɨ oweho asaaha komɨ ambɨpatetɨ gaamatɨ asaataho Rasarusiho nawɨho kahapaamapɨpa asaketahomɨ detɨ maasometetɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Bindataatɨ kahapaamapɨpa nawɨho asaketaho nandapa nanataatɨ pwɨsatisɨha dipamasɨpɨpaunɨ amɨ naumbwinjɨpɨpa ganɨhoaasɨnapɨ tɨmahiyatɨ yatɨhɨ ahotimbɨpa netɨ nandandɨ gwɨnyaataise amɨ suhɨrɨ komɨ asaahaiwaatɨhɨ nuwitihɨhando. ");
INSERT INTO agm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Siyatɨ ko kahapaamapɨpa oweho bimainjatɨ napomasɨhɨ Autaahaatɨhomɨ enjerɨhiya otɨpɨpatɨhiya yamɨhapataatɨhɨ bimohiyɨhiya napɨwɨ koai numwaasi naiwɨ yamɨhapataatɨhɨ Abɨraahamɨhomɨhinɨ detɨ ahɨwisauhɨ bindataise. Aihɨ amɨ utaaho nawɨho kahapaamapɨpa asaketahoaisangi napomasɨhɨ yamwaawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aihɨ ko notɨ aunahɨpa maipɨhata naaŋɨhandɨ nepɨ bimohɨpɨpɨhɨ ambɨpatɨ apɨpaahɨ awaindɨhandɨ yaawɨhandɨ netɨ bindataise. Bindata naingaatɨ jata Abɨraahamɨho kaanɨhɨ Rasarusihoai komɨhinɨ detɨ ahɨwisatosatɨ bimihɨ iwinjataise. ");
INSERT INTO agm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iwinjatosatɨ ko sata kandaase. ‘Apore, Abɨraahamɨhoŋe kɨnyɨ nisapɨ maarɨho asɨpaime. Asɨpaimbɨ Rasarusihoai nepɨ natɨpusoaase ko notɨ komɨ ikwɨrɨ osetetɨ boyatesi nasatɨ nisɨ omasɨhaisɨ wonjɨ bɨnɨmahɨwɨto nɨnɨ kɨmbɨhɨ sisɨhaapɨhɨ ambɨpa yaasɨhandɨ netɨ nehosisono,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Sata ko kaundihɨhandɨ kandɨ amɨ Abɨraahamɨhomɨha wihoaaŋɨha koai saundataase. ‘Nisɨ maasɨho kɨnyɨ sangɨ napopɨ bindapaapɨ nawɨho kahapaamapɨpa gaahapa pɨhɨtɨpɨ isɨpɨ bimingɨtɨhandapɨ gwɨnyapeme. Kɨmo Rasarusimo jɨhura mɨmaipiyatɨ ketinjahore. Aihɨ amɨ wanɨ kɨnyɨ yaasahandɨ nepɨ nehosinɨhɨ amɨ ko komɨ maarɨho biya wɨwinjɨhɨ maaritatɨ wanɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Iyataatɨ amɨ nyamunɨ kinyunɨ mataapɨpɨhɨ kɨmandɨ gwaahorɨhɨrɨ apɨpaahɨ baahɨ timbwaapwandɨhandɨ ahendaise. Isɨ isɨhiya kɨmbɨhɨ kɨmihoaaŋapɨhiya kɨmɨrɨ gwaahorɨmɨri wɨndɨ nehɨmwaapɨ sangisenda wɨndɨ namaapɨtaapo. Iyonɨhɨ amɨ sihoaaŋapɨhiya isɨhiya kɨmɨrɨ gwaahorɨmɨri nehɨmwaapɨ kɨmihoaaŋapɨ wɨndɨ namaapɨtaapo, apɨpaahɨ owetɨtaise,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Aihɨ amɨ ko nawɨho kahapaamapɨpa asaketaho saundataase. “Apore, Abɨraahamɨhoŋe, siyonaaraahɨ namapɨ kɨmo Rasarusimoai nepɨ japɨhɨ natɨpusoaase, ko japɨhɨ nisɨ apɨhomɨ aunahɨpataahapɨ nuto. ");
INSERT INTO agm_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Sandɨ apaapɨmaato nisɨ nɨhoaarɨsa ikwɨ wihɨtɨrɨtahiya aŋɨpɨpɨhɨ bimowɨ Rasarusihoai natɨpusoaasisamɨhɨ ko notɨ kiyai ausaatɨ kaundonɨhɨ kiya atiwɨ gwɨnyaapɨ bimambɨwɨ kɨmbɨhɨ ambɨpa yaasimbɨmbɨhapɨ wɨndɨ nisataiwɨ namaapɨtaatɨwo,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aihɨ Abɨraahamɨhomɨha wihoaaŋɨha koai saundataase. ‘Autaahaatɨhomɨ pɨwɨha Mosesihounɨ amɨ isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaunɨ pɨwɨha atiwɨ jɨpatɨpaiwɨ ahiyohɨwaiwa yaihaiwa ahondaise, mmonɨwɨ atiwɨ naitaapo,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Undihɨ ko nawɨho kahapaamapɨpa asaketisɨho saundataase. ‘Owe, apore Abɨraahamɨhoŋe, utaaho wo napomatatɨho japɨhɨ nepasi notɨ kaundonaahɨ kiya atiwɨ kiyaamɨ maipɨhaiwa kiyohɨwaiwa namasi japɨhɨ nepemaitɨtaapo,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Sata ko kaundihɨhandɨ Abɨraahamɨho komɨha wihoaaŋɨha koai saundataase. ‘Pɨwɨha Mosesiho ahaisɨhaunɨ amɨ isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya pɨwɨha katɨwɨ jɨpatɨpaiwɨ ahiyohɨhaunɨ wɨndɨ baiwɨ atɨhomisawaawaahɨ amɨ naasɨkatɨ kaiwɨ isɨhiya napopɨ nepasi nuwɨ kaundisaihɨha wɨndɨ baiwɨ atɨhomaawitaapo,’ undatɨ Abɨraahamɨho koai kaundataase,” tatɨ Jisaasiho komɨ otɨpɨpatɨhiyai pɨwɨha namɨhanaha kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisaasiho komɨ otɨpɨpatɨhiyai sata kaundataase. “Kahapaamapɨpa kaiwetapɨ isɨhiya maipɨhaiwa kaitaatɨwɨhaiwaahɨ amɨ noaipaitaise. Iyataahandɨ kandɨ amɨ utaaho isɨhiyai maipɨhaiwa kaitaatɨwɨhaiwa nunjiso soai apɨpaahɨ yaawɨhandɨ awaindɨhandɨ nusoaipahonɨhɨ naito. ");
INSERT INTO agm_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Isɨhiya kɨmiya nisapɨ gɨnunyaahohiyɨhiyaamɨ wo komɨ kaindɨhandɨ mmonataatɨ maipɨhandɨ kiyonaahɨ utaaho maipɨhaiwa kaitaatɨwɨ nunjatɨ kaisɨhomɨ naahindɨhoaapɨhɨ nawɨha awaisɨha naaŋɨha wɨrɨhɨra wɨrapɨ durɨhɨraatɨhɨ nesuwɨ wipɨse. ");
INSERT INTO agm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Isɨ amɨ sangisangi siyahaiwa wiwa kaitaawɨ amɨ baiwɨ jaawo. Amɨ kinyɨ utaaho kinyɨ naisɨho wo gi maipɨhandɨ kahisonaahɨ kɨnyɨ koai saundɨpɨ sandɨ maipɨhandɨ kamaime undɨpɨ itɨhunde. Saimbɨ itɨhundisamɨhɨ ko japɨhɨ nepemaitonaahɨ komɨ maipɨhandɨ kɨnyɨ nepumape. ");
INSERT INTO agm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Iyataatɨ amɨ ko gi asisɨha naasetɨhɨ ikwɨ wihɨtɨrɨtanɨhɨ wihɨnɨramɨ yahurɨ 7 kiyahaiwetɨ maipɨhandɨ kahisatosatɨ amɨ 7 kiyahaiwetɨ japɨhɨ nasatɨ sahɨtatɨ nɨnɨ maarɨho asɨpaindɨ nepemaitataayo hɨtonaahɨ kɨnyɨ komɨ maipɨhandɨ nepumape. ");
INSERT INTO agm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aihɨ amɨ komɨ otɨpɨpatɨhiya Awaisɨhoai saundawaatopo. “Nyahɨ Autaahaatɨhopɨ gɨwunyaahohɨtɨhandɨ nepɨ kɨnyɨ andɨtɨnyaipɨ watɨpɨnyamapɨ amɨ waatɨ awaindepɨnyamape,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aihɨ amɨ Awaisɨho komɨha wihoaaŋɨha kiyai saundataase. “Samɨ gɨwunyaahohɨtɨhandɨ apɨpaahɨ maipɨhonjɨ ipatɨ katamɨ ambɨpatɨ masɨtetɨhandamɨ yandɨpɨhomatiyahamwaaŋɨ gɨwunyaawaawɨ kɨmatɨ ipɨmatisɨ saundɨwɨ, ‘kinyɨ ipɨmataŋɨ kinyɨ tambatɨhɨrɨ damipatisapɨ nawotɨpɨ numbwɨ durɨhɨraatɨhɨ yapwɨtɨnde,’ undɨwɨ kaundisaihɨ samɨ pɨwɨha atɨsisatɨ kɨretɨ kaitaise. ");
INSERT INTO agm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Iyataatɨ amɨ samɨ woŋɨ kinyɨ otɨpɨpatɨho osaataatɨ nandapaapɨ yapɨpatɨ yangɨpasatɨ amɨ kinyɨ maasapɨho sipɨsipɨho ginjaatɨ otɨpɨpatɨ kahisatɨ bitonjatɨ aimɨ asahataahuraatanɨhɨ aŋɨpɨpɨhapɨ nasonɨhɨ komɨ awaisɨhoŋɨ koai saundɨtaino? ‘Kɨnyɨ ketɨ apaipɨ nambɨ kɨmbɨhɨ ganɨhomɨhinɨ bindapa nandapa nanɨme undɨtaino? ");
INSERT INTO agm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Owetɨtaise. Nehɨ saundɨtaise. ‘Kɨnyɨ nandapa tɨhɨpɨ tɨmane. Aimbɨ apotɨhɨrɨ niyopɨ nandapa noaapɨ numwɨtaatɨwɨhɨrɨ niyopɨ nandapa noaapɨ nesɨmbo. Nesɨmbɨnɨmisamɨhɨ nɨnɨ jɨhɨ waapoho nandapa nandɨ owetanɨhɨ amɨ kinyapɨhapa ipotɨ nandaapo,” undɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Otɨpɨpatɨho awaisɨhomɨ pɨwɨha atɨwisatɨ komɨ kaundimumwaaŋɨ kiyatɨ owemahonɨhɨ awaisɨho otɨpɨpatɨ kɨnyɨ nga kiyapainɨ gaahoŋe undɨtaiso. Owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iyataatɨ amɨ sangisangi sɨkiyatɨ sɨkɨrete. Amɨ Autaahaatɨho sangi wapa kaiwɨse satimbɨpa nahataapa kasatiwaiwa kaiwɨ kasatipatamataiwɨ owemaposawɨ amɨ sahɨ satɨwɨse. ‘Nyahɨ otɨpɨpatɨhiyaanɨnɨ gaahiyaanɨnɨmaahe. Sandɨ nyahɨ kiyohɨtɨmandɨhɨ tɨtɨhɨ nyamɨ otɨpɨpatɨ nehɨ kiyahaayo,’ tɨtaapo,” undatɨ Jisaasiho komɨ otɨpɨpatɨhiya aposerɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisaasiho Jerusaremɨhandaahapɨ taatɨ notaise. Notaatɨ Samariyaahandamunɨ Garirihandamunɨ yatetetɨhɨra notaise. ");
INSERT INTO agm_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Notɨ ko aunahɨpatɨ wɨta taatɨ noaipasɨhɨ isɨhiya usa asaaha pisapɨpaisahiya ikwɨmaindɨmwɨ napɨwɨ koaisawɨ nutanawaayopo. Nutanɨwɨ kiya onɨhɨ wonjɨ bitotawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Saiwɨ bitotawa kiya satɨwɨ, “nyangi nyainjatingɨhoŋɨ Jisaasihoŋe, kinyɨ maarɨho nyapɨ tɨhɨtane,” tɨwɨ kaahaatawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Satauhɨ Jisaasiho kiyai usonataatɨ amɨ kiyai saundataase. “Sahɨ nuwɨ pɨrisihiya isɨhiyaapɨ Autaahaatɨhoai pɨwaundɨwɨ nandapa tɨhɨwɨ koai waamaindumapɨ dɨpumanɨhohiyɨhiyai nunjanɨwɨse,” undataase. Saundihɨ kiya taawɨ daihɨra niyauhɨ kiyaamɨ asaaha pisapɨpa ketɨ kuraanɨhɨ owesoendaise. ");
INSERT INTO agm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aihɨ kiyaamɨ nehɨ naasohɨ mmotɨnataatɨ komɨ asaaha pisapɨpa owetihɨ japɨhɨ nasatɨ ko waatɨ kaahaatatɨ maaritatɨ Autaahaatɨhomɨ ambɨpatɨ mepɨ autaahemwataise. ");
INSERT INTO agm_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Iyatɨ ko detɨ Jisaasihomɨ utatototɨ atotɨpɨwesatɨ ndɨmaahomwaaŋɨ yapɨpatetɨmatɨ tɨmahiyatɨ ahondaatɨ koai gaahoŋe gaare undataase. ");
INSERT INTO agm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Aihɨ Jisaasiho sandaase. “Isɨhiya ikwɨmaindɨmwɨtahiyai nɨnɨ kiyaamɨ asaaha pisapɨpa nemwahonɨ kiya ikwɨ naasairɨtihɨ wɨramɨ murɨmurɨtahiya (9 kaiwɨhiya) maahɨtihe? ");
INSERT INTO agm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kɨmo utaamo Judaahomaahe, owe. Nehɨ koai wapɨhapɨhohɨhɨ sawaho Autaahaatɨhoai kɨnyɨ gaahoŋe gaare undɨtandɨ japɨhɨ nasataiso?” daase. ");
INSERT INTO agm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Satatosatɨ koai Jisaasiho saundataase. “Kɨnyɨ nisapɨ ko nisɨ asaaha pisapɨpa nga nenɨmaitaise tɨpɨ gɨnunyaahingɨtɨhanda kinyɨ asaaha pisapɨpa owesendaisɨ dosi numwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Isɨhiya Parisihiyaamɨ usa Jisaasihoai satɨwɨ pɨwɨha nunjenawaayopo. “Autaahaatɨho isɨhiyai iwinjaatɨ bimindɨhandɨ maahɨwura noaipaitaise?” undɨwɨ nunjenawaayopo. Aihɨ komɨha wihoaaŋɨha kiyai saundataase. “Autaahaatɨho isɨhiyai iwinjaatɨ bimindɨhandɨ wɨtɨ suwipatisa noaipahonɨhɨ isɨhiya satɨwɨ ‘sande’ tɨwɨ kiyaamɨ ndɨhaara wɨndɨ mondaapo. ");
INSERT INTO agm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aiwɨ kiya wɨndɨ samaatɨtaapo, ‘kɨmbɨhɨ kɨmande mɨhihoaaŋɨ mɨhande,’ tɨwɨ wɨndɨ kamaatɨtaapo. Autaahaatɨho isɨhiyai iwinjaatɨ bimindɨhandɨ aimɨ samɨ otɨhapɨhɨ amɨ samɨhetɨ ahondaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iyatɨ amɨ Jisaasiho komɨ otɨpɨpatɨhiyai sata kaundataase. “Sahɨ ipotɨ wura noaipahonɨhɨ gwɨnyaitaatɨwɨhandɨ nepɨ gwɨnyaawaawɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonisɨ asisɨha napɨtandɨhaiwaamɨ wa noaipahonɨhɨ mmondaatɨwɨ maaritawaahandɨ kandɨ sahɨ wɨndɨ mondaapo. ");
INSERT INTO agm_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Iyataatɨ sura isɨhiya sangisɨ sasatɨtaapo. ‘Isɨhiyaamɨ Saaho Jɨho mɨhapɨhɨ mɨhore, kɨmbɨhɨ kɨmore,’ tɨwɨ kasatisaihɨ sahɨ kiyaamɨ pɨwɨha wɨndɨ atɨhomaawiwɨ amɨ kapɨhɨ ŋuhɨti namuwɨse. ");
INSERT INTO agm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sahɨ kɨnapɨpaapɨ aimɨ mmonɨwɨ gwɨnyaapɨhiyaate. Kɨnapɨpa kɨnapinataatɨ yamɨhapataatɨhɨ nahataapɨhɨ nausainjɨhɨ mmonɨwɨhiyaate. Isɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ nisɨ asisɨhetɨ sɨkɨretɨ sɨkaindɨ kɨnapaahinɨmɨ napisanɨhɨ amɨ isɨhiya nahatiya ninjaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Iyataahandɨ kandɨ isɨhiya wanɨ kɨmuraahiya nisapɨ apɨpaahɨ pohipaiwɨ ahosɨnɨmasaihɨ nɨnɨ yaasɨhandɨ jɨhɨ naito. ");
INSERT INTO agm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Jɨhɨ Nuwaahomɨhura isɨhiya kiyohɨpatamataiwɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ napɨtandaisanɨhura isɨhiya naasɨkatɨ kaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jɨhɨ sura kiya nandapa amɨ waapoho nanɨwɨ amɨ usɨhiya asɨhiyai nepɨ wɨrapɨ namaatɨnɨwɨ kiyaanɨhɨ kaimɨ nuwɨ Nuwaaho sipɨhandotɨ nandaasurandaise. Aihɨ amɨ wipatɨ wipɨwatɨ itɨnambɨtinatɨ durɨhɨrɨ aungwohandɨ nimaanatɨ dotɨ isɨhiya kiyaisɨnɨhɨ netɨ nawatisatɨ tiwatɨ owemase. ");
INSERT INTO agm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Iyataatɨ amɨ Rotɨho bimisuraisangi naasɨkatɨ saiwɨ kiyawaayopo. Kiya nandapa waapoho nanɨwɨ amɨ usai kahapaamapɨpa nunyawɨ nawɨho nepɨ amɨ nandapa niyamapɨ aŋaaŋɨ aŋɨmatɨwɨ saiwa kaiwɨ nehɨ nanɨhaiwɨ wapa namaanyoaipaitaiso tɨwɨ bindawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Saiwɨ kiya bimauhɨ Rotɨho aunahɨpatɨ Sotomɨhandi namasi asisɨha naisɨha ketɨ sisɨha watɨpɨha yamɨhapataatɨhapɨ wipatɨ wipɨwipatamatiyatɨ tɨmahiyatɨ isɨhiya nahandi tɨhatɨ owemase. ");
INSERT INTO agm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Isɨ amɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ asisɨha napisanɨhuraisangi sɨkiyatɨ noaipaitaise. ");
INSERT INTO agm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Asisɨha setɨ utaaho wo komɨ ikɨpɨpa aŋɨtɨtɨhɨ ahusotanɨhɨ aŋɨtaupwataatɨ bimisɨho komɨ ikɨpɨpa naitandɨ noaatɨpatɨ aŋɨtɨtɨhɨ wɨndɨ namɨndaane. Amɨ sɨrɨ kɨretɨ utaaho wo komɨ osaataatɨ bitosɨho aŋɨpɨpɨhapɨ japɨhɨ wɨndɨ namone. ");
INSERT INTO agm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sahɨ Rotɨhomɨ apwaataati nusoaipasɨtɨhandapɨ gwɨnyaapɨse. ");
INSERT INTO agm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Utaaho wo komɨ itatamaŋɨnatɨ bimɨtandɨhandapaahɨhɨ gwɨnyaataatɨ kandi anɨtisatɨ isɨwatataataahɨ amɨ kandɨ ko isɨwatindɨhandɨ owetɨtaise. O amɨ utaaho wo nisapimatonɨhɨ ko itatamaŋɨnatɨ bimɨtandɨhandɨ namataataahɨ kandɨ namasɨtɨhandɨ owemetatɨ biyatɨ kandɨ ahusotɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nɨnɨ sangi kɨmandɨ kasatataato. Sura Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ napisanɨhura utaahurɨ detɨ tɨmaamaitɨmɨ nanopotisaihɨ Autaahaatɨho woai numwaataatɨ woaisɨ namɨhaitaise. ");
INSERT INTO agm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Amɨ apopɨpurɨ wapurɨ kaatɨha bɨretɨhandɨ tɨhɨtaatɨmɨ taamɨ waatɨpatɨ pɨraawaaho sanyoaimɨ namasisaihɨ Autaahaatɨho waati autaahɨ numwaata waati namɨhaitaise. ");
INSERT INTO agm_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Iyataatɨ amɨ utaahurɨ wurɨ osaataatɨ bitosaihɨ Autaahaatɨho woai numwaataatɨ amɨ woai namɨhaitaise,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sata ko kaundihɨ komɨ otɨpɨpatɨhiya atisawaawɨ kiya satɨwɨ koai nunjenawaayopo. “Awaisɨhoŋe, saiwa satɨpɨ katingɨwɨmaiwa maahɨwapɨhɨ noaipaitaise?” undɨwɨ nunjenawaayopo. Iyauhɨ Jisaasiho kiyai wihoaaŋɨha sata kaundataase. “Itapɨpa ahotimbɨpɨhɨ jurɨho nasatɨ ahoyanataise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisaasiho komɨ otɨpɨpatɨhiya wɨndɨ pohimaiwɨ gaapɨpatɨ namaamɨhaapɨ nasisoaarɨ kiyaanɨhɨ gaapundɨtaatɨwɨhandapɨ nunjaha namɨhana pɨwɨha satatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Aunahɨpa wɨta utaaho wo pɨwɨha atisatɨ netɨ mmonatɨ tipɨtapaaho bindataise. So utaaso Autaahaatɨhopɨ wɨndɨ yamaayahore. Iyatɨ amɨ isɨhiyaapɨ wɨndɨ maarɨmitatɨ pohipiyaumwahore. ");
INSERT INTO agm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aihɨ amɨ satɨ aunahɨpitɨ naasaipita itapaatɨ waatɨ osɨnɨhaatɨ bindataise. Saatɨ nahatewetɨ notɨ awaisɨho pɨwɨha atisatɨ netɨ mmonatɨ tipɨtapaasɨhoai saundatoaandaahaate. Nisɨ tiworisa nepɨ nɨngisɨ nanopɨsasɨtaatɨwiyowɨ kɨnyɨ nɨngisɨ andɨtɨnipɨ nisɨ pɨwɨha tɨtɨhepɨnɨmape undatoaandaise. ");
INSERT INTO agm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Iyataatɨ so utaaso pɨwɨha atisatɨ netɨ mmonatɨ tipɨtapaasɨho so jɨhɨ pɨhɨtatɨ kaundiwaiwetɨ atisatɨ wɨndɨ ketɨ tɨtɨhemwaamahore. Siyahosɨ ipotɨnɨhɨ ko komɨ omaŋɨtɨtɨhapɨ siyatɨ gwɨnyaataise. ‘Nɨnɨ Autaahaatɨhopɨ wɨndɨ yamaindɨ amɨ isɨhiyaapɨ wɨndɨ maarɨmitɨtɨhonɨniso. ");
INSERT INTO agm_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Iyataatɨ kɨmaatɨ apopɨ osɨnɨmaatɨ nɨngisɨ kaatɨnɨhɨ pohɨrɨndɨmɨ naisɨ namatɨ nɨnɨ kaatamɨ pɨwɨha andɨtɨwitɨ tɨtɨhemwaitaano. Nɨnɨ tɨtɨhemwaamasanɨhɨ kaatɨnɨhɨ japɨhɨ japɨhɨ nasatɨ nɨngi pohɨrɨndɨmɨ notoaasonɨhɨ nɨngisɨ apɨpaahɨ pondɨtaiso,’ nnatɨ sawaho kanataase,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iyatosatɨ Awaisɨho kiyaisɨ amɨ sata kaundataase. “Pɨwɨha sa awaisɨho pɨwɨha atisatɨ mmonatɨ netɨ tipɨtapaasɨho maipɨhopɨha sahɨ aimɨ atisawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Isɨhiya Autaahaatɨho nisɨhiyaimatɨto tatɨ aimɨ ahɨwisawɨhiya nasisoaarɨ apatɨhunɨ otapɨhaatunɨ Autaahaatɨhoai nyatatamanɨpɨ andɨtɨnyaipe undɨwɨ kaundɨmɨ naisaihɨ Autaahaatɨho kiyai atɨhomaawisatɨ andɨtɨmaawiwɨtaiso? Amɨ ko sahapo tatɨ atɨwisataahandɨ kandɨ jaatɨ bimaamɨ nutaiso? Owe, ko wɨndɨ siyatɨ kamaitaise. ");
INSERT INTO agm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Isɨ nɨnɨ sandɨ sangisɨ kasatataato. Ko ketɨ kiyaisɨ atɨwisatɨ andɨtɨwiwɨtaise. Iyataahandɨ kandɨ Isɨhiyaamɨ Saaho Jɨho kɨmaapɨ yapɨpatambɨ japɨhɨ nasataahura isɨhiya kɨmaapɨ yapɨpatambɨhiya taawɨ kiya sura gɨwunyaasaihɨ nasatɨ usondaindɨho?” undatɨ kiyaisɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Isɨhiya usa tɨtɨhɨ sawanaapɨ nyahɨ tɨtɨhɨ gaahiyaanɨnɨ ainahiyɨhiyaane, o isɨhiya usaahɨ apɨpaahɨ maipɨhiyaare tɨwɨ gwɨnyaahohiyɨhiyaapɨ pɨwɨha namɨhanaha Jisaasiho sata kandaase. ");
INSERT INTO agm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Utaahurɨ wurɨ gaapundɨtaatɨmɨ Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandaatɨhapɨ nomaise. Kuramɨ wo Parisihore. Aihɨ amɨ wo nawɨho taakɨsihandɨ nesɨhore. ");
INSERT INTO agm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Aihɨ Parisiho notɨ bitonda ko sawahopɨ sata gaapundataase. ‘Autaahaatɨhoŋe, nɨnɨ usaamatɨmaindɨhonɨnɨtihɨ gisɨ gaare hɨtataato. Isɨhiya usaahɨ isɨhiya usaamɨhapai maarɨho nunyawɨ ikowɨnɨwɨ nusepɨ amɨ maipɨhaiwa tɨtɨmetahaiwa kaiwɨ amɨ kiyaamɨ warisai apwaatiyai namasi namaatɨnɨhohɨwaiwa nepɨ japɨhɨ nopɨsasɨnawaayopo. Iyataahandɨ kandɨ nɨnɨ saindɨhonɨnɨmaahe. Aindɨ amɨ nɨnɨ kɨmo utaamo nawɨho taakisihandɨ nesɨhomataindɨhonɨnɨmaahe. ");
INSERT INTO agm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aindɨ amɨ Saararehɨrɨ nahataaramɨ asisɨha yatairetɨ nandapa waapoho onaindɨ bindataatɨ gaapundɨtɨhonɨne. Aindɨ amɨ nawɨho kahapaamapɨpa nɨnɨ nehohɨpɨpa tɨtɨhɨ kamwaaŋɨ nanɨmɨtaatɨwe tingɨmumwaaŋɨ kamwaaŋɨ kinyɨ otɨpɨpatɨ kaitandɨhapa nahinyatɨhonɨne,’ tatɨ gaapundataase. ");
INSERT INTO agm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Aihɨ amɨ nawɨho taakɨsihandɨ nesɨho mɨtɨho naingaatɨ yamɨhapataatɨhɨ wɨndɨ minjatɨ komɨ mɨtɨho kɨwopopɨ wiwatɨ amɨ goaitatɨ bitonda sata gaapundataase. ‘Autaahaatɨhoŋe nɨnɨ apɨpaahɨ maipɨhaiwaisahonɨnisɨ kɨnyɨ nisapɨ maarɨho tɨhɨtane,’ tatɨ gaapundataase. ");
INSERT INTO agm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Nɨnɨ sangisɨ sandɨ kasatataato. Utaaho nawɨho taakɨsihandɨ nesɨhoai Autaahaatɨho kɨnyɨ utaahoŋɨ ainahɨhoŋɨ gaahoŋɨ tɨtɨhoŋe undataase. Saundihɨ ko komɨ aŋɨpɨpɨhapɨ japɨhɨ notaise. O woaisaahɨ wɨndɨ ainahɨhoŋɨ tɨtɨhoŋe mundise, owe. Utaaho wo sawaho gaahoniso tatɨ naimaatisɨhoai Autaahaatɨho netɨ koai ipɨhatitaise. O amɨ utaaho wo maipɨhoniso tatɨ ipatisanɨhonaahɨ koaisɨ Autaahaatɨho netɨ autaahemwatɨ kopɨ maaritɨtaise,” tatɨ Jisaasiho kiyaisɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Isɨhiya usa kiyaamɨ metɨhonyai Jisaasiho komɨ ikwɨrɨ konyaamɨ mɨtɨhoaatɨhɨ ahɨwitotɨwɨ numwaasi koaapɨhɨ nasawaayopo. Saiwɨ kiya metɨhonyai numwaasi nasauhɨ komɨ otɨpɨpatɨhiya kiyai itɨhundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Itɨhundauhɨhandɨ kandɨ Jisaasiho ‘metɨhonya nɨngisenda napɨwise,’ undatɨ konyai numwaataatɨ sandaase. “Sandɨ katohɨtɨmandɨ apaapɨmaato. Autaahaatɨho isɨhiyai iwinjaatɨ bimaamɨ naindɨhandɨ setahiyaamatiyahiyaapɨhande. ");
INSERT INTO agm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nɨnɨ akɨtɨnɨhɨ sandɨ kasatataato. Utaaho wo metɨhonyaamatiyahamwaaŋɨ kiyatɨ Autaahaatɨho isɨhiyai iwinjaatɨ bimaamɨ naindɨhandɨ maaritatɨ nametaataahɨ kandaatɨhɨ wɨndɨ namɨndaitaise. Apɨpaahɨ owetɨtaise,” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Awaisɨho mɨtɨho wo Jisaasihoai sata nunjenataise. “Katɨpɨnyasingɨhoŋɨ gaahoŋe, nɨnɨ nɨnapitiyataatɨnɨhɨ asohonimandɨ nasisoaarɨ konɨnɨhɨ bimɨtandɨhandɨ naitande?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Aihɨ amɨ Jisaasiho wihoaaŋɨha koai saundataase. “Nɨngisɨ napaapɨ gaahoŋe dise? Isɨhiya gaahiya apɨpaahɨ owe. Autaahaatɨho naasohɨ sawaho gaahore. ");
INSERT INTO agm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wɨnɨhapɨpa satatɨ ahotimbɨpa kɨnyɨ aimɨ mmonɨpɨ gwɨnyaapɨhoŋe. Kɨnyɨ kinyɨ namaatɨnɨhingɨtɨhandɨ nepɨ namopɨsasɨpɨ womɨhaatisapɨ namope. Kɨnyɨ isɨhiyai wɨndɨ timaamape. Kɨnyɨ wɨndɨ ikomaanɨme. Kɨnyɨ isɨhiya usaapɨ siyawaayopo tɨpɨ jaipɨtɨpɨha kamaatɨme. Kɨnyɨ kinyɨ kɨniyɨ gapiyaamɨ pɨwɨha baimbɨ atɨwimbɨ kapuramɨ kahatisaihɨhapa napaitɨpɨ kaime tatɨ wɨnɨhapɨpa ahondaise japepɨhɨrɨtaatɨwo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aihɨ amɨ utaaso wihoaaŋɨha sata kaundataase. “Nɨnɨ sangɨ metɨhonjanɨhuraapɨ saiwa wɨnɨhapɨmaiwa atindɨ netɨ japepihɨrɨtɨ bimaamɨ napɨtɨ wanɨ kɨmurandaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Aihɨ Jisaasiho komɨ pɨwɨha sa atisataatɨ amɨ komɨha saundataase. “Ye kɨnyɨ nga kiyapaahandɨ kandɨ wɨndɨ saimbɨ kaitaapɨhandɨ nehɨ naasaindɨhɨ yahandisɨ kandɨ kɨnyɨ wɨndɨ kamaise. Isɨ kɨnyɨ numbwɨ kinyɨhapa kahapaamapɨpa ikɨpɨpa isɨwatingɨpɨpa nahataapa isɨhiyai nunyapɨ nawɨho nepe. Ikɨpɨpaapɨ nawɨho nehingɨho isɨhiya nawɨho kahapaamapɨpa owehiyai tipɨtapaapɨ nunye. Kɨnyɨ saimbɨ kiyapaapaahɨ gaahaiwa yamɨhapataatɨhapɨhaiwa pɨhɨtɨpɨ naitaise. Isɨ kɨnyɨ nambɨ nɨngi nanipinje,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Undihɨ ko sa pɨwa atisataatɨ komɨ maarɨho ambɨpatɨ naaŋawisataise amɨ ko nawɨho kahapaamapɨpa asaketahoso. ");
INSERT INTO agm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisaasiho koaisɨ usonataatɨ koaisɨ apɨpaahɨ naaŋawisaho bitosɨhɨ ko sandaase. “Isɨhiya nawɨho kahapaamapɨpa asaketahiya Autaahaatɨho isɨhiyai iwinjaatɨ bimaamɨ naindɨhandaatɨhɨ nandaitaatɨwɨhandɨ apɨpaahɨ owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Iyataatɨ maasapɨho kamerɨhandɨ jaatɨhɨramɨ mupwɨrinyinjaatɨhɨ nga nandaahonɨhandɨ kandɨ utaaho nawɨho kahapaamapɨpa asaketaho Autaahaatɨho isɨhiyai iwinjaatɨ bimaamɨ naindɨhandaatɨhɨ nandaitandɨhandɨ apɨpaahɨ owetɨtaise,” tatɨ kandaase. ");
INSERT INTO agm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aihɨ isɨhiya kapɨhɨ bitohoyɨhiya sa pɨwa atiwosawɨ satawaatopo. “O siyonaahɨ isɨhiya diya nɨnapitaiwɨhiya asɨyaimatɨwɨ kiyaanɨhɨ nasisoaarɨ bimɨtaapo?” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aihɨ Jisaasiho saundataase. “Kɨmandɨ katohɨtɨmandɨ utaaho wo kamaitaise, owe. Autaahaatɨho sawahohɨ kiyonɨhɨ nga noaipaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Aihɨ amɨ Pitaahomɨha Jisaasihoai saundataase. “Atime! Nyahɨ nyamɨ aunahɨpɨhaiwaunɨ amɨ nyamɨhaiwa kahapaamapɨhaiwa namawaamapɨ gisɨ nangipinjahaayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Aihɨ amɨ Jisaasihomɨha wihoaaŋɨha kiyaisɨ saundataase. “Nɨnɨ sangi akɨtɨnɨhɨ sandɨ kasatataato. Isɨhiya nahatiya Autaahaatɨho isɨhiyai iwinjaatɨ bimindɨhandapimatonɨhɨ amɨ kiya kandaatɨhɨ nandaitaatɨwɨ gwɨnyaawaawɨ namapɨ kiyaamɨ anɨhaiwaisunɨ apwaatiyaisunɨ saingosaahoyaisunɨ sanɨsapiyaisunɨ mwaaya maatiyaisunɨ namawaawaahɨ kandapɨ wanɨ kɨmura kiya yapɨpataapɨhɨ bimohurɨmura wihoaaŋɨhapa kahapaamapɨpa taahɨpɨpa kiya jɨhɨ isɨwatohɨpɨpai nusatipɨhaahapa Autaahaatɨho numwɨtaise. Nunyatatɨ amɨ jɨhaatɨ ipotɨhura asisɨha ipotɨha noaipahonɨhura kiya asɨyaimatɨwɨ nasisoaarɨ bimɨtaatɨwɨhandɨ nunyonɨhɨ naitaapo,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisaasiho komɨ otɨpɨpatɨhiya ikwɨmaindɨmwɨtihɨ yahurɨtahiyaisaahɨhɨ numwaasi yandɨhɨ bitotawa kiyai sata kaundataase. “Sahɨ atiwɨse! Nyahɨ wanɨ taawaatɨ Jerusaremɨhandaahapɨ niyahaayo. Isɨhiyaamɨ Saahonɨnɨ Jɨhonisapɨ Jɨsihura isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya pɨwɨha katɨwɨ jɨpatɨpaiwɨ ahiyohɨhaamɨ akɨpɨpa ausaimanɨnatɨ noaipaitando. ");
INSERT INTO agm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kiya koai nepɨ isɨhiya Judaahiyaamɨ dawaataatapɨhiyaamɨ ikwɨraatɨhɨmaitaapo. Kiyaamɨ ikwɨraatɨhɨmasaihɨ kiya koai sisɨpundɨwɨ mɨmaipɨwiwɨ maahoaipupwɨmaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Aiwɨ amɨ kiya koai mwɨtɨpatisahapaara mupwɨ tiwisaihɨ napwɨtaise. Saiwɨ tiwisaihɨ napotatɨhandɨ kandɨ asisɨha mairɨma saniyonɨhɨ amɨ japɨhɨ nepaitaise.” ");
INSERT INTO agm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sata ko kaundihɨ komɨ otɨpɨpatɨhiya atisawaahandɨ kandɨ kaamɨ tanyaaha noaasandihɨ amɨ kiya kaapɨ baiwɨ gɨmunyaapɨ namusesɨpainje. Owetise. ");
INSERT INTO agm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisaasihotihɨ komɨ otɨpɨpatɨhiyaatihɨ aimɨ aunahɨpatɨ Jerikohanda noaipaitaahetihɨhura utaaho wo ndɨha niyotaho daihɨraamɨ mangɨrainɨ bindataatɨ wapa wapaapɨ itunda nunjenatɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aihɨ ko ndɨha niyotisɨhoai isɨhiya nusatipapɨrauhɨ kɨrɨngɨrɨngapa atisataatɨ napindɨ noaipasɨhɨ nanɨtipapɨrauhɨ atiso ndaase. ");
INSERT INTO agm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aihɨ kiya koai saundawaatopo. “Nasaretɨhandaahapɨ Jisaasiho kɨmo taatɨ napihe,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aihɨ ko ndɨ niyotisɨho waatɨ kaahaata sandaase. “Jisaasihoŋɨ Daawitɨhomɨ Mwaahoŋe, kɨnyɨ nisapɨ maarɨho tɨhɨtane” tatɨ kaahandaase. ");
INSERT INTO agm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aihɨ isɨhiya jɨhɨ taawɨ nasohiyɨhiya koai kɨnyɨ satɨpɨ kamaatɨme namɨhaape undɨwɨ itɨhundawaatopo. Satɨwɨ itɨhundauhɨhandɨ kandɨ kohɨ waatɨ waatɨ kaahaata sandaase. “Daawitɨhomɨ Mwaahoŋe, kɨnyɨ nisapɨ maarɨho tɨhɨtane,” tatɨ kaahandaase. ");
INSERT INTO agm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aihɨ Jisaasiho jaatɨ bitonda so gaatisoai numwaasi nɨngisaapɨhɨ kɨmbɨhɨ napɨwɨse undataase. Aihɨ ko Jisaasihoaapɨhɨ detɨ naihɨ Jisaasiho koai saundatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nɨnɨ gisɨ napitɨhitandɨ nisapɨ kɨnyɨ gaatise,” undatɨ nunjenataise. Aihɨ amɨ komɨha saundataase. “Awaisɨhoŋe, nɨnɨ nisɨ ndɨha nanorɨhaatonɨhɨ nga baindɨ jaitandɨto?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aihɨ Jisaasiho koai saundataase. “Kinyɨ ndɨha nangorɨhaatonɨhɨ baimbɨ jase, kɨnyɨ nisapɨ satɨpɨ ko nga nisɨ ndɨha netɨ nanorɨhaitaise, tɨpɨ gɨnunyaahingɨtɨhanda kinyɨ ndɨha nangorɨhaatataise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aihɨ ketɨ kuraanɨhɨ komɨ ndɨha nusorɨhaatihɨ nga japɨhɨ biyatɨ jataise. Ko biyatɨ jatɨ Jisaasihoai nɨwipinjai notaatɨ pɨhɨtatɨ maaritatɨ Autaahaatɨhoai gaahoŋe gaare undatɨ komɨ ambɨpatɨ mepɨ autaahemwataise. Aihɨ amɨ isɨhiya sandɨ siyatɨ noaipasɨhɨ mmonawaawɨ amɨ kiyaisangi Autaahaatɨhoai gaahoŋe gaare undɨwɨ komɨ ambɨpatɨ mepɨ autaahepumawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisaasiho notɨ aunahɨpatɨ Jerikohanda noaipatɨ katɨ aunahɨpitaatɨhɨ taatɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Naihɨ sapɨhɨ aunahɨpita utaaho wo bindataise komɨ ambɨpatɨ Sakiyaasiho. So utaaso isɨhiya nawɨho takisihandɨ nehohiyɨhiyaamɨ jɨhimainjɨhoe. Iyataatɨ amɨ so nawɨho asaketahore. ");
INSERT INTO agm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Isɨ ko Jisaasiho napitetahoe tatɨ iwinjaito tataihɨ isɨhiya wɨrɨsandiwɨ nasawa nisapuhauhɨ Jisaasiho sore tatɨ wɨndɨ biyatɨ mausose. Iyataatɨ ko apɨpaahɨ masɨhonjɨ nuhonyonjɨndaatɨ isɨhiyaamɨhatɨhapɨ mbatatɨ wɨndɨ mausose. ");
INSERT INTO agm_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aihɨ ko Jisaasihopɨ daihɨra kɨmɨra napɨtaiso tatɨ gwɨnyaataatɨ ko jɨhɨ naupwasi niyatɨ ipatɨ wɨtetɨ katetapɨ daahepiwatɨ Jisaasihoai ko iwinjaito tatɨ yamwaataise. ");
INSERT INTO agm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Aihɨ Jisaasiho niyatɨ Sakiyaasiho bitosɨpɨpɨhɨ noaipatɨ autaahɨ naingaatɨ koai iwinjataatɨ koai sata kaundataase. “Sakiyaasihoŋe, kɨnyɨ ketɨnɨhɨ ipɨmatetapɨ noaatɨpape, wanɨ nɨnɨ kinyɨ aŋɨpɨpɨhɨ maasɨ gisatɨ bimɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aihɨ Sakiyaasiho ketɨ ipitetapɨ noaatɨpatɨ aungwohandɨ waatɨ maaritatɨ Jisaasihoai numwaasi komɨ aŋɨpɨpɨhapɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Aihɨ isɨhiya taahiyɨhiya sandɨ mmonawaawɨ kiya satɨwɨ itɨhɨtawaatopo. “Utaaho maipɨhaiwaisahomɨ aŋɨpɨpɨhɨ ko notɨ bindataise,” tɨwɨ itɨhɨtɨwɨ katawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakiyaasihomɨ aŋɨpɨpɨhɨ bindawaawɨ Sakiyaasiho dotatɨ Awaisɨhoai saundataase. “Awaisɨhoŋe, kɨnyɨ atime. Nisɨhapa kahapaamapɨpa nahataapa otɨhapɨhapɨ otɨwaitɨ wihoaaŋɨhapa isɨhiya kahapaamapɨpa apɨpaahɨ owehatɨmai numwɨto. Aindɨ amɨ womɨhapa wapa jaiwundɨtɨ isɨpɨpa nusetaataahɨ namatɨ kapaapɨ jinjɨhaatematɨ waatɨ maurɨtanɨhɨ amɨ maurɨtahaiwaara numwɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Aihɨ Jisaasiho komɨha koai saundataase. “Kɨmbɨhɨ aŋɨpɨmbɨhapɨ isɨhiyai Autaahaatɨho japɨhɨ aimɨ numwaataise. Iyataatɨ kɨmo utaamoaisangi amɨ Abɨraahamɨhomɨ mwaahoe amɨ Autaahaatɨho Abɨraahamɨhoaisatɨ pɨwɨha wɨsasisɨhaaraaho. ");
INSERT INTO agm_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Iyataatɨ amɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ isɨhiya nihɨrɨnɨwɨ owetohiyɨhiyai daatɨ mmonɨtɨ japɨhɨ numwaitandɨ napɨtɨhonɨne,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ko satatɨ kaundihɨ kiya taawɨ sa pɨwɨha atisauhɨ amɨ pɨwɨha waisangi namɨhanaha kaundataase. Sa pɨwɨha kaundindɨmandɨ apaapɨmundise ko aimɨ detɨ Jerusaremɨhanda nasataate. Iyataatɨ amɨ komɨ pɨwɨha kaundihɨ atɨwisohiyɨhiya saiwɨ gwɨnyaawaayopo. Autaahaatɨho Isɨhiyai Winjaatɨ bimaamɨ naindɨhandɨ wanɨ kɨmura ketɨ ausaimanɨnatɨ noaipatɨ ahotɨtande tɨwɨ gwɨnyaahauho. ");
INSERT INTO agm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aihɨ ko pɨwɨha namɨhanaha kiyaisɨ sata kaundataase. “Utaaho wo awaisɨho isɨhiyaamɨ ndɨhetɨ baiwɨ usopɨ amɨ ambɨpatɨ ahotaho aunahɨpatɨ wɨtɨ kaanɨhɨ ahetihɨhataahapɨ notaise. Notɨ noaipasɨhɨ kapɨhɨ isɨhiya koai kɨnyɨ awaisɨhoŋɨ isɨhiyai iwinjatɨtaapɨhoŋimate undɨwɨ ahɨwisaihɨ japɨhɨ napɨtandɨho notaise. ");
INSERT INTO agm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ko siyatɨ nutandɨ tɨmendaatɨ komɨ otɨpɨpatɨhiya ikwɨmaindɨmwɨtahiyai gaatatɨ numwaatɨ nawɨho maasapɨ mɨtɨho nahatiyai naasɨ kamwaaŋɨ nunyataise. Nunyataatɨ kiyai saundataase, ‘kɨmo nawɨmo nɨnɨ sangi nasanyohɨmo nesi nuwɨ kora otɨpɨpatɨ kaiwɨ namoyaapɨ nuwɨ nɨnɨ japɨhɨ napisanɨhuraatɨtande,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Saundihɨhandɨ kandɨ komɨ isɨhiya kopɨ pohipaiwɨ mandɨtɨpɨwisawaayopo. Kiya saiwɨ kopɨ mandɨtɨpaiwɨ ko aimɨ naihɨhura komɨ ipotɨ isɨhiya usai natɨwusaasauhɨ koai wɨrainji nuwɨ satawaatopo. ‘Kɨmo utaamo awaisɨhoematatɨ nyangi nyainjaatɨ bimɨtandɨ ponyase,’ tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ko sawahomɨ isɨhiya satauhɨhandɨ kandɨ isɨhiya usaapɨhɨ ko notɨ bimimbɨpɨhiya koai kɨnyɨ awaisɨhoŋimate undɨwɨ namɨhanawaayopo. Koai saiwɨ namɨhanauhɨ ko awaisɨhoematatɨ japɨhɨ komɨ aunahɨpataahapɨ nasataise. Siyatɨ nasatɨ noaipatɨ isɨhiyai saundataase. ‘Isɨhiya jɨhura nawɨho nesisuwɨ kora otɨpɨpatɨ kaiwɨse undɨtɨ nawɨho nunyohiyɨhiyaapɨ gaatɨwɨse kiya nawɨho otɨpɨpatɨ kaiwɨ namoyaahotɨho nɨnaasomɨho nesi napisaihɨ nɨnɨ mmondaano,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Saundihɨ kiya atiwɨmapɨ jɨhɨ wo nasatɨ awaisɨhoai saundataase. ‘Awaisɨhoŋe, kɨnyɨ maasapɨhomɨ mɨtɨho nehɨ naasohɨ nanɨminɨhɨ kora otɨpɨpatɨ kaindɨ maasapɨhomɨ mɨtɨhaiwa ikwɨmaindɨmwɨtahaiwa namoyaataayo,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Saundihɨ Awaisɨho isɨhiyai iwinjatisɨho koai saundataase. ‘Kɨnyɨ otɨpɨpatɨ nga baimbɨ napaitɨpɨ kiyapaise. Kɨnyɨ otɨpɨpatɨhoŋɨ gaahoŋe. Otɨpɨpatɨ maipɨhonjɨ nahinyonɨhɨ nepɨ katɨ iwɨrɨmimbɨ nga baimbɨ itatamanɨpɨ kiyapaise. Isɨ nɨnɨ gi wanɨ aunahɨpatɨ awaiwaiwa ikwɨmaindɨmwɨtahaiwa jatɨtaapɨ watɨpɨhandɨ nahinyatɨ ahɨngitaano,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Aihɨ amɨ utaaho kapɨho nasatɨ awaisɨhoai saundataase. ‘Awaisɨhoŋe kɨnyɨ nɨngisɨ nawɨho maasapɨhomɨ mɨtɨho nehɨ naasohɨ nanɨminɨhɨ koraahɨ nɨnɨ nesi otɨpɨpatɨ kaindɨ maasapɨhomɨ mɨtɨho ikwɨrɨ naasairɨtaho kaindɨ namoyaataayo’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Saundihɨ awaisɨho isɨhiyai iwinjatisɨho koai saundataase. “Kɨnyɨ aunahɨpɨhaiwa ikwɨrɨ naasairɨtahaiwa jatɨtaapɨ ahɨngitaano,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Aihɨ amɨ otɨpɨpatɨho kapɨhɨ ipotɨho nasatɨ awaisɨhoai saundataase. ‘Awaisɨhoŋe, kɨnyɨ nawɨho maasapɨhomɨ mɨtɨho nehɨ naasohɨ nanɨmingɨho kɨmo anɨtindɨ jaatipata witɨ ahiyatatɨ otɨpɨpatɨ kora kamaindɨ kɨmore. ");
INSERT INTO agm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nɨnɨ siyohɨtɨmandɨ apaapɨmaahe, kɨnyɨ utaahoŋɨ apɨpaahɨ watɨpɨhoŋɨ waapɨhɨtɨpɨhoŋɨtihɨ nɨnɨ gisonataate. Isɨhiya wapa ahiyauhɨhapa nepɨ amɨ isɨhiya usa nandapa niyamɨhauhɨhapa kɨnyɨ kumbwɨhoŋɨtihɨ amɨ sandapɨ nɨnɨ kinyapɨ yayataate,’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Saundihɨ amɨ komɨ awaisɨho koai saundataase. ‘Kɨnyɨ otɨpɨpatɨhoŋɨ apɨpaahɨ gaahoŋɨmaahe, apɨpaahɨ maipɨhoŋe. Kɨnyɨ pɨwɨha kɨma satɨpɨ katingɨmaapɨ nɨnɨ pɨwɨhetehɨmaitandiyo. Kɨnyɨ nisapɨ apɨpaahɨ watɨpɨhoe tɨpɨ amɨ isɨhiya wapa ahiyauhɨhapa netɨ amɨ nandapa usa yamɨhauhɨhapa ko kɨpohore tɨpɨ siyatɨtihɨ gwɨnyaapaino? ");
INSERT INTO agm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Japɨhɨ nasataahura nisɨ nawɨho namwisɨhoaisatɨ ahoyatɨ naitaanɨ namwɨtandɨhapɨhɨ ahɨmaanisapɨ napaape?’ undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Saundatosatɨ kapɨhɨ isɨhiya bitohohiyɨhiyai saundataase. “Kɨmo nawɨho maasapɨ mɨtɨho isɨwatisɨho nepawɨ utaaho nawɨho maasapɨ mɨtɨho ikwɨmaindɨmwɨtahaiwa isɨwatisɨhoai nunyawɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Sundihɨ kiya koai saundawaatopo. “Awaisɨhoŋe, ko aimɨ nawɨho maasapɨ mɨtɨho ikwɨmaindɨmwɨtahaiwa isɨwatataisɨ kohɨtiho?’ undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Saundauhɨ amɨ komɨha kiyai saundataase. ‘Nɨnɨ sangi sandɨ kasatataato. Isɨhiya wapa taahɨpɨpa isɨwatohiyɨhiyai amɨ nɨnɨ wapa jɨhaatɨ waatɨ numwɨto. O amɨ isɨhiya usa wapa nehɨ naasonyaahɨ isɨwatohiyɨhiya amɨ kiyaamɨhetapɨ sonya naasonyaahɨ isɨwatohonya nɨnɨ nemaito. ");
INSERT INTO agm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Iyataatɨ isɨhiya siya nisɨ tiworisa nisapɨ ko awaisɨhoematatɨ nyangisɨ nyainjaatɨ bɨmimone tɨwɨ katohiyɨhiyai sahɨ numwaasipɨwɨ kɨmbɨhɨ nisɨ ndɨhetɨ timapɨse,’ undataase” undatɨ Jisaasiho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisaasiho pɨwɨha sata kaundamapɨ ko jɨhɨ isɨhiya nahatiyai ipotemapɨ Jerusaremɨhandaahapɨ niyataise. ");
INSERT INTO agm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Niyatɨ aunahɨpɨhaurɨ Betɨpaagihandamunɨ Betaanihandamunɨ detɨ sɨhoaarɨhɨrɨ sisɨho ipatɨ oripɨhaiwa ahetimbɨpɨhɨ noaipataise. Noaipatɨ kapɨhapɨ komɨ otɨpɨpatɨhuri jɨhɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Natausaasataatɨ kuri saundataase. Sahuraahɨ kɨmatɨ aunahɨmata numwɨ nandaapɨ mmonama maasapɨho dongiho sɨpɨpɨhoho wo wɨrɨhɨra satoya wɨraposisaihɨ wɨrandɨtaise. So maasapɨho dongiho isɨhiya sangɨ koaasɨnɨ daiwɨhore. Isɨ koaisɨ sahuraahɨ nesɨpapɨ isɨsi kɨmbɨhapɨ napɨta numwɨse. ");
INSERT INTO agm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Saimɨ taamɨ nesɨpasaihɨ isɨhiya usa sahuraahɨ napaapɨ taamɨ soai nesɨpase satisaihaahɨ sahuraahɨ kiyai saundɨmise. ‘Awaisɨho koaasɨnɨ wonjɨ gohɨ daitandɨtihe,’ undɨmise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Saundatɨ kuri natausaasihɨ kurɨ niyamaise. Naimɨ Jisaasiho kaundimumwaaŋɨ tɨtɨhɨ kamwaaŋɨ noaipasɨhɨ mmonɨ kiyamaise. ");
INSERT INTO agm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kurɨ naimɨ maasapɨho sɨpɨpɨhoho dongihoai taamɨ wɨrɨhɨrɨ nesɨpasɨhɨ dongihomɨ satoya kuri saundawaatopo. “Sahuraahɨ kɨmo maasapɨho sɨpɨpɨhoho dongimo napaapɨ taamɨ nesɨpase?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Saundɨwɨ nunjenɨhauhɨ kurɨ kiyai saundamaase. “Awaisɨho koaasɨnɨ wonjɨ gohɨ daitandɨ katihe,” undamaase. ");
INSERT INTO agm_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kurɨ saimɨ dongiho nesɨpapɨ isɨsi Jisaasihoaapɨhɨ numwɨ noaipamaise. Aimɨ kurɨ kuramɨ apotɨhɨrɨ tiwatɨhaatɨhɨrɨ nausohaapɨ dongihomɨ dawaarɨhɨretɨ ahiyamaise. Aimɨ kurɨ Jisaasihoai dongihoaasɨnɨ nepɨwihɨ koaasɨnɨ ko bindataise. ");
INSERT INTO agm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Siyatɨ Jisaasiho dongihoaasɨnɨ taatɨ naihɨ isɨhiya kiyaamɨ apotɨhɨrɨ tiwatɨhaatɨhɨ niyohohɨpɨpa nausohaapɨ daihɨra ko nutandɨhɨra nusapaapɨ gwaumwɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aihɨ Jisaasiho notɨ aimɨ sɨhoaarɨhɨretɨ sisɨhoaasɨnɨ ipatɨ oripɨhaiwa ahetimbɨpɨhapɨ daihɨra ururaatɨhapɨtihɨ isɨhiya Jisaasihoai nɨwipinjai niyohiyɨhiya kapɨhapɨ namasawɨ maaritawaayopo. Aiwɨ amɨ kiya Jisaasihomɨhetapɨ watɨpɨhaiwa Autaahaatɨho kaihɨ noaipasɨwaiwaapɨ gwɨnyapenawaawɨ Autaahaatɨhoai mepɨ autaahepumapɨ waapɨhɨtɨwɨ satɨwɨ katawaatopo: ");
INSERT INTO agm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Awaisɨho natausaasihɨ watɨpɨhaiwaisatɨ Awaisɨho isɨhiyai winjatisɨho napisɨmo kɨmoai Awaisɨho gaahatɨ koai kawɨsatɨ koaisatɨtane. Isɨ ko Autaahaatɨho Nahatewai Daahema Autaahɨ Nɨwaataatɨ Bimisɨhoai nyahɨ mepɨ autaahemwaitɨhaawo. Autaahaatɨho maarɨho winyaitahaiwa kaihɨ amɨ nyamɨ maarɨho biyatɨ winyaitindɨhandapo,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Satɨwɨ katauhɨ isɨhiya usa Parisihiya kiyaamɨ otɨhatɨhɨ bitotawaahiya Jisaasihoai kiya saundawaatopo. “Katɨpɨnyasingɨhonye, kɨmiya gi nangipinjai nasohiyɨmiya satɨwɨ wɨndɨ kamaatɨwɨse undɨpɨ itɨhunde,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Saundauhɨ Jisaasiho komɨha wihoaaŋɨha kiyai saundataase. “Nɨnɨ sangi tɨtɨhɨ sandɨ kasatataato. Kɨmiya isɨmiya satɨwɨ kamaatɨwɨ apɨmaatisaihaahɨ amɨ kɨmaiwa nawɨmaiwa waapɨhɨtatɨ Autaahaatɨhoai netɨ mepɨ autaahemwaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisaasiho niyatɨ detɨ Jerusaremɨhandamɨhinɨ noaipataise. Noaipatɨ katɨ aunahɨpiti iwinjatata katapɨ ngotaise. ");
INSERT INTO agm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ngotɨ katapɨ sandaase. “Wanɨ asisɨma kɨmetɨ gisɨ wɨndɨ netɨ gɨtatamanɨhonɨhɨ kɨnyɨ baimbɨ bimɨtaapɨhandapɨ gwɨnyaapaapaahɨ ngaatɨtaise. Iyataahandɨ kandɨ amɨ sandɨ kinyapɨ noaasandihɨ kɨnyɨ wɨndɨ monapaise. ");
INSERT INTO agm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Isɨ asisɨha yaha wa taatɨ nasataisɨ ketɨ kinyɨ tiworisa gisɨ nepɨ nɨwipepɨhɨmapɨ nangisapumaitaapo. Aisaihɨ isɨhiyaatɨ amɨ wapaisangi aunahɨpatamɨ ipaahaapɨ noaipapɨ nuwɨ napɨwɨmaitaapo. Amɨ samɨ tiworisa sangi kɨhɨra kɨhɨraapɨ tisapɨ yasapɨ nasisapumasaiho. ");
INSERT INTO agm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Saiwɨ kiya gisɨ nepɨ nangupwɨsasɨwɨ apɨpaahɨ iwɨrɨhitaapo aunahɨpɨmatanyɨ matambɨpaarangisunɨ isɨhiyaatangisuno. Nawɨha tiwatɨ nyepaiwɨ mbipɨ ahiyohɨha kakaamɨhasɨnɨ wɨndɨ ahɨmotɨtaise. Sandɨ apaapɨmaato amɨ Autaahaatɨho gisɨ japɨhɨ nangɨmaitandɨ napisuraapɨ kɨnyɨ wɨndɨ mmonɨpɨ gɨmunyaahingɨtɨhandaahɨ saiwa gi nangoaipaitaise,” tatɨ katatɨ ngotaise. ");
INSERT INTO agm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisaasiho Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandaatɨhɨ nandaatɨ mmonata isɨhiya kahapaamapɨpa nunyawɨ taawɨ nawɨho nepɨ amɨ nawɨho yapɨpatɨ wɨtaahapɨho Judaahiyaamɨhoetemapɨ nunyawɨ nehauhɨ Jisaasiho kiyai usonataise. ");
INSERT INTO agm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Iyatɨ kiyai saundataase. “Autaahaatɨhomɨ pɨwɨha sandaase. ‘Nisɨ aŋaaŋɨ saaŋɨ gaapundɨtaatɨwɨhaaŋe,’ tatɨ ahotihɨhandɨ kandɨ sahɨ ikohiya noaatɨtaatɨwɨhapɨhamaitaiwɨ kiyawaayopo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Asisɨ nahatewetɨ Jisaasiho Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandaatɨhɨ nandaatɨ Autaahaatɨhomɨ pɨwɨha isɨhiyai kataunjataise. Siyatɨ kaihɨ amɨ isɨhiya usa Autaahaatɨhoai nandapa kohasɨpɨho tɨhɨwɨ dɨpumanɨhohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ amɨ isɨhiyai iwinjatohiyɨhiya usa mɨtɨhiyaunɨ Jisaasihoai tiwɨtaatɨwɨhɨra daihɨraapɨ taawɨ daapɨ mmonawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Siyawaahandɨ kandɨ isɨhiya nahatiya andɨtitɨwɨ watɨpɨtɨwɨ komɨ pɨwɨha atɨwisauhɨ namapɨ mɨtɨhiya Jisaasihoai tiwɨtaatɨwɨhɨra daihɨra wɨndɨ mmonɨwɨ namehopo. ");
INSERT INTO agm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Asisɨha waara Jisaasiho Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandaatɨhɨ nandaatɨ Autaahaatɨhomɨ pɨwɨha gaaha wanɨha taatɨ isɨhiyai ausaatɨ kataunjihɨ isɨhiya usa isɨhiyaamɨ maipɨhaiwaapɨ nandapa kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ isɨhiya usa Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ amɨ isɨhiya usa gwɨnyaahiyaunɨ koai saundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Kɨnyɨ saiwa saimbɨ kaingɨwɨmaiwa saimbɨ saimbɨ kaimehɨta gi ndɨ kahɨtatɨ watɨpɨhandɨ nahɨmihɨ kiyapaise wanɨ nyangi kanyate?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Saundɨwɨ nunjenɨhauhɨ amɨ Jisaasiho komɨha wihoaaŋɨha kiyai sata kaundataase. “Nɨnɨ amɨ sangisɨ sandɨ nasɨsendaano. ");
INSERT INTO agm_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jonɨho isɨhiyai baawusindɨndɨ sandɨ watɨpɨhandɨ Autaahaatɨhomɨhandaaho e isɨhiyaamɨ watɨpɨhandaaho wanɨ nɨngi sahɨ kandɨwɨse?” undatɨ kiyai ko nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nunjesɨhɨ amɨ kiya sawana sanawaatopo. “Nyahɨ wihoaaŋɨha napitɨtaaha kaundɨtɨhaawe?” tɨwɨ kanɨwɨ nasenawaayopo. “Nyahɨ sandapɨ Autaahaatɨhomɨhandaahe undisaihaahɨ o Autaahaatɨhomɨhandaahɨnaahɨ Jonɨhomɨ pɨwɨhaapɨ sahɨ napaapɨ gɨmunyapepo? Nyatɨtaiso. ");
INSERT INTO agm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Iyatɨ amɨ nyahɨ saundisaihaahɨ isɨhiyaamɨhandaahe undisaihaahɨ amɨ isɨhiya kɨmiya nawɨhaara nepɨ yainyawɨtaapo amɨ kiya Jonɨhopɨ Autaahaatɨhomɨ pɨwɨha atisa netɨ ausaasɨhoe tɨwɨ aimɨ gwɨnyaapɨhiyaaso,” nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sanawaawɨ namapɨ kiya wihoaaŋɨha koai saundawaatopo. “Sandɨ watɨpɨhandɨ maahapɨhapɨ nehandɨtindɨho nyahɨ wɨndɨ monɨhono,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Saundauhɨ amɨ komɨha wihoaaŋɨha kiyai saundataase. “O amɨ sahɨ nisɨ nasɨsehotɨhaapɨ wihoaaŋɨha wɨndɨ kamandowɨ amɨ nisangi watɨpɨhandɨ siyahandaahe satɨtɨ sangi nɨnɨ wɨndɨ kamaasatɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisaasiho isɨhiyai aimɨ sata kaundatosatɨ amɨ kɨma pɨwɨha wa namɨhanaha kiyai sata kaundataase. “Utaaho wo wainɨhandɨ osaataatɨ kiyatɨ niyaamataise. Niyaamatɨ isɨhiya usai nisɨ osaataatɨ kɨmaatɨ ninjatawaawɨ wainɨhandɨ nandɨwɨ nanɨwɨ ninjatɨwɨse undatɨ kiyai netɨ ahɨwisamapɨ kaanɨhɨ aunahɨpa wɨtaahapɨ notɨ kata utaarɨhandɨ kendaise. ");
INSERT INTO agm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ketinja nandapa yandɨpɨho wainɨhandɨ akuraahaihɨ kɨpwɨtaatɨwɨhura wainɨhandamɨ satɨho komɨ otɨpɨpatɨho woai netɨ natausaasihɨ komɨ otɨpɨpatɨhiya wainɨhandɨ jatohiyɨhiyaapɨhɨ notaise nandapa wainɨhandɨ wapa kopɨhapa kɨpɨwɨ numwɨtaatɨwɨ. Natausaasihɨ ko notɨ wainɨhandɨ jatohiyɨhiyai iwinjasɨhɨ wainɨhandɨ kɨpɨwɨmunyawɨ koai nehɨ tipɨ wapa miwaho nehɨ taanahɨhoai japɨhɨ natɨwusaasauhɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Aihɨ wainɨhandamɨ satɨho amɨ jɨhaatɨ otɨpɨpatɨho woai natausaasataise. Natausaasihɨ ko notɨ wainɨhandɨ jatohiyɨhiyai iwinjasɨhɨ kiya koai amɨ jɨhoai kawisohɨpatamataiwɨ tipɨ mawɨtandɨhaiwa nunyawɨ japɨhɨ natɨwusaasauhɨ taanahɨho notaise. ");
INSERT INTO agm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aihɨ osaataatamɨ satɨho amɨ jɨhaatɨ bapiyatɨ komɨ otɨpɨpatɨho woai natausaasataise. Aihɨ amɨ koai wainɨhandɨ jatohiyɨhiya ambɨpatɨ tipusohaapɨ maipaiwɨ tipɨ nepɨ osaataatamɨ nehɨhaatɨ yotawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Siyauhɨ namatɨ osaataatamɨ satɨho sanataase. ‘Nɨnɨ napitaitande? Nɨnɨ nisɨ maarɨho apɨpaahɨ awaindɨhandɨ wɨwihotɨho nisɨ maasɨhɨhoai nandusoaasɨtaano ko nisɨ maasɨhɨhomɨ pɨwɨha kiya atɨwitaawo?’ ndaase. ");
INSERT INTO agm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Satatɨ ko komɨ mwaahoai natausaasihɨ naihɨhandɨ kandɨ osaataatɨ wainɨhandɨ jatohiyɨhiya taatɨ napihɨ koai iwinjawaawɨ kiya sawana sanawaatopo. ‘Kɨmo utaamo wainɨhandɨ osaataatɨ kɨmaatamɨ satɨhomɨ tɨtɨhɨ mwaahoe. Mwaahosɨ sapɨhomɨ wainɨhandɨ naitaise. Isɨ koai sohoai tiwaamaitɨho. Tiwisaihɨ ko naponɨhɨ ko naitotahandɨ nyahɨ newaatɨ nyamɨhandimatɨto,’ nnawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Sanɨwosawɨ koai numwaasi osaataatamɨ nehɨhaatɨ mangɨrainɨ nuwɨ sohoai tiwauhɨ napotaise. “Saiwɨ tiwauhɨ napotaise. Isɨ osaataatɨ saatamɨ satɨho siyaisɨ napitɨwitaise?” undatɨ kiyai Jisaasiho nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nunjenatosatɨ sawaho wihoaaŋɨha satatɨ kiyai kaundataase. “Osaataatamɨ satɨhoai apousonɨhɨ nasatɨ siya otɨpɨpatiyai tiwatɨ nematosatɨ osaataatɨ saatɨ netɨ otɨpɨpatɨhiya asɨyɨhiyai numwaatɨ kiyaamɨ ikwɨraatɨhɨmaitaise,” undatɨ Jisaasiho kiyai kaundataase. Aihɨ isɨhiya kapɨhɨ komɨ pɨwɨha atisawaawɨ kiya satawaatopo. “Siyatɨ wɨndɨ namoaipaitaise owetɨtaise,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aihɨ Jisaasiho kiyai iwinjatata sata nasenataise. “Kɨma pɨwɨma Autaahaatɨhomɨ utɨpɨhoaatɨhɨ ahotindɨmandɨ napaapɨ satatɨ jɨpatɨpindise? ‘Aŋaaŋɨ aŋɨmatohiyɨhiya ipatɨ yasɨhaapɨ kɨma yasɨma anaahɨha gaahaamaahe tɨwɨ nepɨ yotohɨha wanɨ ka noaipatɨ mɨhotɨrisatɨ watɨpɨtatɨ aŋaaŋamɨ yasɨha anaahɨha awaisɨhaimatataise,’ tatɨ jɨpatɨpindisɨmaaro. ");
INSERT INTO agm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Isɨhiya sɨrɨ mɨhotɨriraasɨnɨ tɨmahiyohiyɨhiyai kɨrɨ mɨhotɨrɨhɨra ambɨpatɨ tipusohaatɨ tiwonɨhɨ mwɨtisɨhaahɨtɨtaise. Iyataatɨ amɨ mɨhotɨrɨhɨrɨ sɨrɨ isɨhiyaamɨhetɨ tɨmahiyataataahɨ amɨ isɨhiyai netɨ jasatɨ tiwɨtaise,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisaasiho sata kaundihɨ kiya Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ amɨ pɨrisihiya isɨhiyaamɨ maipɨhaiwaapɨ nandapa kohasɨpɨho tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ mɨtɨhiyaunɨ atisawaawɨ sa pɨwɨha tɨtɨhɨ kiyaapɨ nepemaahɨwɨha kaundihɨ mmonɨwɨ gwɨnyaawaawɨ ketɨ suraanɨhɨ koai isɨwɨtotɨwɨ gwɨnyaawaahandɨ kandɨ isɨhiyaapɨ yayawaawɨ namɨhaawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Aihɨ kiya awaisawɨhiya Jisaasiho kiyai pɨwɨha wa wipɨtaha kaundonaahɨ koai numwaasi nuwɨ awaisɨho gapɨnaahoaapɨhɨ kɨmo pɨwɨha satahore undɨwɨ pɨwɨha komɨhetɨ yawutaito tɨwɨ gwɨnyaapɨ bɨpi Jisaasihoai iwinjatawaayopo. Saiwɨ iwinjatawaawɨ kiya awaisawɨhiya nyahɨ gaahiyaanɨnɨ ainahiyɨhiyaaniso tɨwɨ gwɨnyaapɨ genanɨwɨ isɨhiya usai nawɨho nunyawɨ saundɨwɨ sahɨ nuwɨ pɨwɨha satɨha satɨwɨ koai kaundɨwɨse undɨwɨ koaapɨhɨ natɨwusaasawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aihɨ kiya nuwɨ koai saundawaatopo. “Katɨpɨnyasingɨhonye, kɨnyɨ nyangi katɨpɨnyasingɨwaiwa tɨtɨhɨ akɨtɨhaiwa katɨpɨnyasapaise. Iyataatɨ amɨ isɨhiya usa awaisawɨhiyaimatɨwɨ bimohiyɨhiyaapɨ kɨnyɨ wɨndɨ yamaimbɨhoŋɨtinɨhɨ nyahɨ aimɨ mmona gwɨnyaahaayo. Aimbɨ kɨnyɨ Autaahaatɨho isɨhiya yapɨpatambɨhiya nisɨ maaritohɨrɨhɨretɨ saiwɨ kaiwɨ bimaawɨse tatɨ katirɨhɨrɨ kɨretɨ kɨnyɨ tɨtɨhɨ katɨpunjapɨhoŋe. ");
INSERT INTO agm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Isɨ kɨnyɨ napitaimbɨ gwɨnyapenapaise? Nyahɨ gamanɨho Sisaahoai nawɨho takisihandɨ nunyaano e namunyaano? Undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Saiwɨ kiya kiyaamɨ omaŋɨtɨtɨhapɨ iwinjatawa jaipundɨwɨ kaundohɨwaiwa aimɨ usonatosatɨ kiyai sata kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nawɨho wo nɨngisɨ nanisawewise,” undihɨ amɨ kiya nawɨho wo nunjauhɨ mmonatosatɨ ko kiyai sata kaundataase. “Nawɨmoaatɨhɨ kɨmatɨ sɨwipɨmatunɨ amɨ ambɨpatunɨ diyaamɨhatɨ ahotise?” undatɨ nunjenataise. Nunjesɨhɨ kiya koai saundawaatopo. “Awaisɨho Sisaahomɨhate,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Saundauhɨ Jisaasiho kiyai sata kaundataase. “O siyonaahɨ wapa Sisaahomɨhapanaahɨ amɨ koai tɨtɨhɨ nunyawɨse o amɨ wapa Autaahaatɨhomɨhapanaahɨ amɨ tɨtɨhɨ koai komɨhapa nunyawɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ko sata kaundihiyawa kiya wihoaaŋɨha isɨhiyaamɨ ndɨhetɨ kaundɨtɨha owetihɨ isɨwɨtotɨwɨhandɨ kandɨ komɨ pɨwɨhaapɨ yaiwɨmapɨ gwɨnyapenawaawɨ owetise. ");
INSERT INTO agm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Isɨhiya usa Satiyusihiyaamɨ usa Jisaasihoaapɨhɨ nasawaayopo. Siya Satiyusisiya napohiyɨhiyaapɨ wɨndɨ japɨhɨ namepaitaapo tɨwɨ gwɨnyaapɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Isɨ kiya Jisaasihoai pɨwɨha satɨwɨha kaundawaatopo. “Katɨpɨnyasingɨhonye, nyapɨ wɨnɨhapɨpa Mosesiho sata jɨpatɨpiyatɨ ahiyataise. ‘Utaaho wo apopaati netɨ wɨratɨ bimainjatɨ maaha oweho naponaahɨ kaatɨ osɨnaati sotisɨhomɨ saingɨho netɨ wɨrane komɨhetapɨ metɨho wo noaipatɨ saaho sotisɨhomɨ aunahɨpatɨ nanɨpimatɨ naito,’ tatɨ wɨnɨhapɨpa ahondaise. ");
INSERT INTO agm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Isɨ isɨhiya usɨhiya usa sapɨho naasomɨhiya ikwɨrɨ naasairɨtihɨ wɨramɨ isundɨpɨhurɨ yahurɨtahiya noaipawaayopo. Aihɨ kiyaamɨ saaho jɨho apopaati netɨ wɨratɨ bimainjatɨ maaha wa namomaayaho nehɨ napomataise. ");
INSERT INTO agm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aihɨ amɨ saatɨ saahomɨ apwaata osɨnɨhaati saingɨho netɨ wɨrataise. ");
INSERT INTO agm_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aihɨ amɨ ko napwihɨ amɨ saingɨho kapɨho netɨ osɨnɨhaati wɨrataise. Wɨratɨ bimainjatɨ amɨ koaisangi napwihɨ amɨ saingɨho kapɨho netɨ wɨrataise. Kaatɨ osɨnɨhaatɨ saingoya kɨho kɨhomɨhetɨmatɨmɨ notɨ ipotɨhoai nɨwipaatɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nɨwipaasɨhɨ ipotɨho netɨ wɨratɨ bimainjatɨ amɨ koaisangi napwihɨ kaatɨ ipotaataatɨnɨhɨ napotaise. ");
INSERT INTO agm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Saatɨ apopaatisɨ ikwɨrɨ naasairɨtihɨ wɨramɨ isundɨpɨhurɨ yahurɨtahiya nahatiya nepɨ wɨrapɨhaatisɨ ipotɨhura isɨhiya napohiyɨhiya japɨhɨ nepasaihɨhura saatɨ apopaatɨ tɨtɨhɨ diyaamɨ apwaataatimatɨtaise?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Satɨwɨ kiya koai nunjenɨhauhɨ amɨ komɨha wihoaaŋɨha kiyai sata kaundataase. “Usɨhiya amɨ asɨhiya wanɨ kɨmuraahiya namaatɨnawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Iyataahandɨ kandɨ usɨhiya amɨ asɨhiya ipotɨhura anɨmwaahɨpatombɨ japɨhɨ nepapɨ asɨyaimatɨwɨ bindawaahura usɨhiya asɨhiya wɨndɨ namaamaatɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kiya Autaahaatɨhomɨ enjerɨhiya otɨpɨpatɨhiya yamɨhapataatɨhɨ bimohiyɨhiyaamataiwɨhiyaasɨ wɨndɨ namaapopɨ nasisoaarɨ bimɨtaapo. Kiya anɨmwaahɨpatombɨ japɨhɨ nepapɨhiya Autaahaatɨhomɨ manyinyaare. ");
INSERT INTO agm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Napohiyɨhiya japɨhɨ nepaitaatɨwɨhandapɨ Mosesiho biyatɨ nanyesɨpataha pɨwɨha kanyatataase. Sa pɨwa ipɨhonjɨ maipɨhonjɨ wurisandɨhaisahonjɨ tɨhatɨ tɨhwɨtisataahandɨ kandɨ tɨhomaatisonyonjaatɨhapɨ pɨwɨha noaipasɨha Awaisɨhopɨ (Autaahaatɨhopɨ) sata kandaase. ‘Awaisɨho Abɨraahamɨhomɨ Aisaakɨhomɨ amɨ Jekopɨhomɨ Autaahaatɨhore tise. ");
INSERT INTO agm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Isɨ Autaahaatɨho so isɨhiya napopɨ owetohiyɨhiyaamɨ Autaahaatɨhomaahe, owe, isɨhiya asɨyaimatɨwɨ bimohiyɨhiyaamɨ Autaahaatɨhore. Sandɨ apaapɨmaahe amɨ Autaahaatɨhomɨ ndɨhetɨ kiya asɨyaimatɨwɨ bindawaayopo,” undatɨ kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ko kiyai sata kaundihɨ amɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaamɨ usa saundawaatopo. “Katɨpɨnyasingɨhonye, kɨnyɨ nga tɨtɨhɨ kanyatapaase,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Saundɨwɨ kiya yayawaawɨ jɨhaatɨ wɨndɨ namunjenɨhopo. Owetise. ");
INSERT INTO agm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Aihɨ Jisaasiho kiyai sata pɨwɨha kaundataase. “Kɨraisihopɨ so awaisɨho Daawitɨhomɨ satɨhoe tɨwɨ napaapɨ katopo? ");
INSERT INTO agm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pɨwɨha Aunɨhɨhɨraatɨhɨ ahotisɨhaatɨhapɨ Daawitɨho sawaho sata kandaase: ‘Awaisɨho nisɨ Awaisɨhoai saundataase. “Kɨnyɨ nisɨ ikwɨrɨ gaatɨhɨraihoaaŋɨ kɨmbɨhɨ bime. ");
INSERT INTO agm_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Bimaamɨ numbwɨ ipotɨhura kinyɨ tiworisai netɨ kinyɨ asɨmoaatɨtɨhɨmasanɨhɨ kɨnyɨ kiyai nepɨ itɨpɨwotisamɨhuraatɨtando,” undataase tise.’ ");
INSERT INTO agm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daawitɨhohɨ kopɨ nisɨ Awaisɨho tatɨ ambɨhɨndaase. Isɨ Kɨraisiho so napitiyatɨ Daawitɨhomɨ satɨhotɨtaise?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Isɨhiya nahandɨ atɨwinjaawɨ bimauhɨ Jisaasiho komɨ otɨpɨpatɨhiyai sata kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaapɨ sahɨ baiwɨ jaawo. Kiya apotɨhɨrɨ utaarɨhapa niyopɨ daimɨ nutaatɨwɨ maaritɨwɨmapɨhiyaaso. Aiwɨ amɨ kiya isɨhiya taahiyɨhiya ahoyanɨhohɨpɨpɨhɨ nowaahura isɨhiya awaisawɨhiyaate ipɨhɨrete nyatɨtotɨwɨ maaritɨwɨhiye. Aiwɨ amɨ kiya Autaahaatɨhomɨ aŋɨhaiwa gwɨharaahaiwaatɨhɨ isɨhiyaamɨ ndɨhetɨ mɨtaahoaahɨ bimɨtaatɨwɨ maaritɨwɨhiyaare. Aiwɨ amɨ kiya ganɨho apɨpaahɨ gaahoaasɨnɨ nandapa anaahɨpɨpa awaimbɨpa tɨhohɨpɨpɨhɨ bimɨtaatɨwɨ maaritɨwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Aiwɨ amɨ kiya asɨhiya osɨnɨhiyaamɨ aŋaaŋɨ jaipundɨwɨ nusepɨhiyaare. Aiwɨ kiya gaapundɨhaayo tɨwɨ jaiwɨtɨwɨ gaapɨpatɨ utaarɨhaiwa aipɨhiyaare. Kiya saiwɨ kiyohɨwaiwaapɨ Autaahaatɨho kiyai apɨpaahɨ yaawatɨ naaŋɨhandɨ awaindɨhandɨ ipotɨhura numwɨtaise,” undatɨ Kiyai Jisaasiho kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisaasiho Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandaatɨhɨ bitonda winjasɨhɨ isɨhiya Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandamɨ bokisihandɨ onɨhopɨ nawɨho kahapaamapɨpa asaketahiya nawɨho gaarehandapɨho wiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wihauhɨ amɨ apopaatɨ waatɨ nawɨho kahapaamapɨpa apɨpaahɨ owehaatɨ nawɨho taanauhɨho tuhɨnɨpɨhurɨ nehɨ yahurɨ nesotɨ wisɨhɨ Jisaasiho kaati iwinjataise. ");
INSERT INTO agm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iwinjatosatɨ Jisaasiho kiyai saundataase. “Nɨnɨ sangisɨ akɨtɨnɨhɨ kasatataato. Kɨmaatɨ apopɨ osɨnɨmaatɨ isɨhiya nahatiya nawɨho gaarehandapɨho tɨmahotɨhoai nusatipɨhaatɨ tɨmataise. ");
INSERT INTO agm_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kɨmiya isɨmiya nawɨho kahapaamapɨpa asaketahiyaasɨ nawɨho isoho nesipɨwɨ Autaahaatɨhoai nunyawaayopo. O amɨ kɨmaatɨ apopɨ osɨnɨmaatɨhɨ nawɨho owehaatɨ nandapa netɨ nanatɨ bimɨtandɨho nawɨho owetihɨhandɨ kandɨ konɨhɨ Autaahaatɨhoai nunyataise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jisaasihomɨ otɨpɨpatɨhiyaamɨ usa Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandapɨ satawaatopo. “Kɨma nawɨha gaaha otiwa kambwaahaunɨ amɨ Autaahaatɨhoai gaarehandɨ wapa nunyohɨpɨpaaraahimaawɨ aŋɨmatɨwɨhaaŋɨsɨ sanahɨwendaise,” tawaatopo. Satauhɨ amɨ Jisaasiho kiyai saundataase. ");
INSERT INTO agm_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kɨmaiwai wanɨ sahɨ usonɨhohɨwɨmaiwa siyatɨ tiwatɨ nyepinatɨ biyatɨ wɨndɨ ahɨmotɨtaise. Asisɨha waara isɨhiya nepɨ tumbwɨwɨ nepuhɨwɨ nopɨsasɨtaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Aihɨ amɨ kiya Jisaasihoai satɨwɨ nunjenawaayopo. “Katɨpɨnyasingɨhonye, saiwa kanyatingɨwɨmaiwa maahɨwura noaipaitaise? Nɨnapitiyahandɨ jɨhɨ noaipahonɨhɨ nyahɨ mmondo? Mmonaatɨ komɨ kanyatindɨhandɨ aimɨ koaipaitande taatɨ mmona gwɨnyaitaano?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aihɨ Jisaasiho komɨha wihoaaŋɨha kiyai sata kaundataase. “Isɨhiya usa sangisɨ jaiwɨsatɨtaawɨ sahɨ baiwɨ jaawɨhiyaato. Isɨhiya usa napɨwɨ nisɨ ambɨpatɨ ambɨhɨtɨwɨ ‘Nɨnɨ Kɨraisihonɨne,’ satɨtaapo. Aiwɨ amɨ kiya sasatɨtaapo. ‘Asisɨha aimɨ ipotɨha koaipataise,’ satisaihɨ sahɨ kiyaamɨ pɨwɨha napaitɨwɨ atɨhomaawiwɨ amɨ kiyaamɨhinɨ detɨ namuwɨse. ");
INSERT INTO agm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pwɨsɨpatɨ siyahatɨ aungwohandɨ noaipataise tɨwɨ katisaihɨ sahɨ atisawaawɨ waatɨ kandapɨ yaiwɨ itɨmipɨse. Saiwaahɨ jɨhɨ kiyatɨ noaipataahandɨ kandɨ asisɨha ipotɨha akaaha sura wɨndɨ ketɨ namoaipaitaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jisaasiho wɨndɨ namaamɨhaatɨ konɨhɨ kiyai amɨ sata kaundataase. “Isɨhiya yapɨpatɨ wɨtaahapɨhiya dosi nuwɨ yapɨpatɨ wɨtaahapɨhiyaisawɨ tundaapo. Iyonɨhɨ amɨ awaisɨho wo iwinjaatɨ bimisawɨhiya dosi nuwɨ awaisɨho wo iwinjaatɨ bimisawɨhiyaisawɨ tundaapo. ");
INSERT INTO agm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Iyonɨhɨ amɨ ipɨpatɨpatɨ aungwohaiwa waatɨ ipɨpatɨpindaise. Iyatɨ amɨ jarɨho aungwohaiwa noaipatɨ amɨ timbɨpa saiwa nahataapɨpɨhɨ noaipaitaise. Iyatɨ yamɨhapataatɨhɨ wapa watɨpɨhapa motɨnɨhapa noaipataatɨ sangisɨ yasimatɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Saiwa siyatɨ sangɨ noaipahonɨhura isɨhiya sangisɨ jaipɨ ambɨpatɨ yaasɨhaiwa nasamɨtaapo. Aiwɨ kiya Judaahiyaamɨ anɨhaiwa gwɨharaahaiwaatɨhɨ nasamaasi nuwɨ pɨwɨha samɨhetɨ nepɨ yasutaapɨ nasapupwɨ amɨ gamanɨhomɨ awaisawɨhiyaapɨhɨ nasamaasi nuwɨ kiyaamɨ ndɨhetɨ ahɨsitaapo. Saiwa nisapɨsatɨwɨ amɨ sahɨ nisɨ otɨpɨpatɨhiyaatisɨ amɨ sahɨ nisɨ otɨpɨpatɨ wɨndɨ kamaanitaatɨwɨ nasisapupwɨ kasitaapo. ");
INSERT INTO agm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Isɨhiya saiwa kasisohɨtɨndɨ sandɨ nisɨ pɨwɨha ausaapɨ kanundɨtaatɨwɨ kiyawaayowɨ gaasɨ nisɨ pɨwɨha anusaapɨse. ");
INSERT INTO agm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aiwɨ sahɨ pɨwɨha napitɨtaaha kiyai wihoaaŋɨha kaundɨtɨhaawe tɨwɨ jɨhɨ waatɨ gɨmunyaapɨse. ");
INSERT INTO agm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nɨnɨ nɨwahonɨnɨ pɨwɨha sahɨ kiyai kaundɨtaatɨwɨha samɨ amɨtetetɨ ketɨ ahɨsisatɨ netɨ gɨsunyaasanɨhɨ sahɨ gwɨnyaitaapo. Nisɨ pɨwɨha sangisɨ nasanyotɨha sahɨ kiyaisɨ kaundisaihɨ kiya samɨ tiworisa pɨwɨha ka wɨndɨ ipɨhatiwɨ nemaamaitaapo. Owetɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Samɨ sɨnɨnjapiyaunɨ amɨ samɨ sunyɨhoya jaatisa nasamaasi nuwɨ samɨ tiworisamɨ ikwɨraatɨhɨsamaitaapo. Aiwɨ samɨ usaatangi tisausaihɨ napwɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nisapɨsatɨwɨ sangisɨ isɨhiya taahiyɨhiya pohipɨsiwɨ ahosɨsamaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Iyataahandɨ kandɨ sahɨ wɨndɨ namopɨsasɨnɨwɨ nga baiwɨ bimɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Isɨ sahɨ baiwɨ andɨtitɨwɨ bimaawɨse asɨyɨhiyaatimatɨwɨ nasisoaarɨ bimɨtaatɨwɨhandɨ sahɨ naitaatɨwo,” undatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Aunahɨpatɨ Awaipatɨ Jerusaremɨhandi isɨhiya pwɨsɨpɨ yaipatɨ kaiwɨ timbiyohiyɨhiya otaatemapɨ bitopɨ nesɨwesɨpɨ bitɨwɨmasaihɨ sahɨ kiyai usonawaawɨ aunahɨpa Jerusaremɨhandi nepɨ nopɨsasisaihɨ katɨ aimɨ nosasɨndande tɨwɨ gwɨnyaapɨse. ");
INSERT INTO agm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sandɨ siyatɨ noaipahonɨhɨ sahɨ yapɨpatɨ Judiyaahanda bimohiyɨhiyaatɨ yanɨhɨmapɨ sɨhoaarɨhɨrɨ tipatetɨ naitaatɨwe. Amɨ saisaihɨ sahɨ aunahɨpa Jerusaremɨhanda bimohiyɨhiyaatɨ yanɨhɨmapɨ namasi naitaatɨwe. Saisaihɨ amɨ isɨhiya usa aunahɨpatamɨ nehɨhaatɨ ipaahaapɨ bimohiyɨhiyaisangi aunahɨpatɨ kataatɨhɨ wɨndɨ namɨndaitaatɨwe. ");
INSERT INTO agm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sandɨ apaapɨmaahe. Isɨhiya Autaahaatɨhoai ahosumwapɨ maipɨhaiwa kiyohɨtɨhandapɨ wihoaaŋɨhandɨ naaŋɨhandɨ numwɨtande. Siyatɨ kiyonɨhɨ Autaahaatɨhomɨ pɨwɨha utɨpɨhoaatɨhɨ jɨhura katɨwɨ ahiyotɨha akaaha ausaimanɨnatɨ noaipaitande. ");
INSERT INTO agm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ese sura naaŋɨhandɨ noaipasura asɨhiya maahaapɨ gwɨsɨtohiyɨhiyaunɨ amɨ awatetetɨ amwɨtɨhɨrɨ nanatɨ nanototisawɨhiyaunɨ apɨpaahɨ awaindɨhandɨ naaŋɨhandɨ naitaapo kɨmatɨ yapɨmbataaho. Autaahaatɨhoai apowindɨhandɨ isɨhiya siya natiyaamɨhetɨ noaipaitaise. ");
INSERT INTO agm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Namatanaatɨ kosasaihɨra tiworisa isɨhiya taahiyɨhiyai timaitaapo. Aiwɨ amɨ kiya isɨhiya usai napuwɨtaatɨwɨ yapɨpatɨ usaamɨhatɨ kahatɨ kahataahapɨ numwaasi nutaapo. Aiwɨ kiya isɨhiya Judaahiyaamɨ dawaataatapɨhiya aunahɨpatɨ awaipatɨ Jerusaremɨhandɨ nepɨ jaawɨ bimaamɨ nuwɨ Autaahaatɨho sura namɨhaitaapo tatɨ katimumwaaŋɨ notɨ kuraatanɨhɨ namɨhaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Iyonɨhɨ amɨ ipɨhoetɨ amɨ waatɨhoetɨ amɨ kaumbwaatetɨ wiwa sɨwipatɨ kahatamatɨpetahaiwa isɨhiya wiwa monɨwɨhaiwa noaipaitaise. Iyatɨ amɨ durɨhɨrɨ waatɨ pɨhɨtatɨ tiwayaatɨ notɨ nasayata nausɨha pɨhɨtatɨ autaahɨ mɨhotɨ sanainjatɨ niyatesi tɨmɨhiyataatɨ gaatonɨhɨ amɨ isɨhiya yapɨ nahanda nahataapɨpɨhiyaamɨ maarɨho omaaŋɨtɨtɨhɨ amɨ amɨtɨha netɨ nusopɨsasɨnɨhonɨhɨ kiya waatɨ awaindɨhandɨ yaitaapo. Aiwɨ kiyaamɨ maarɨho nɨnaawiratatɨ owesoetɨtaise. ");
INSERT INTO agm_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yapɨpatambɨhiya isɨhiya yapɨhɨ nahanda saiwa siyatɨ noaipaitandaiwaiwaapɨ gwɨnyaawaawɨ apɨpaahɨ yaiwɨmapɨ amɨ kiyaamɨ ndɨha wonɨwonɨwinatɨ asisɨwiraitaise amɨ kahapaamapɨpa yamɨhapataatɨhɨ watɨpɨhaiwa ahotiwaiwa nonasaya ahoyonɨho. ");
INSERT INTO agm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Saiwa siyatɨ noaipahonɨhɨ nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ nisɨ yundanyɨha amɨ apɨpaahɨ watɨpɨhandisatɨ tɨwipatisatɨ napɨto. Napisanɨhɨ isɨhiya nɨngi ninjaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Saiwa siyatɨ namasatɨ taatɨ noaipahonɨhɨ sahɨ naingaapɨ jasawɨse sangisɨ japɨhɨ Autaahaatɨho nasamaitandɨhura aimɨ nasatɨ utatototɨndaiso,” undatɨ Jisaasiho komɨ otɨpɨpatɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Siyatɨ kaundatosatɨ amɨ Jisaasiho pɨwɨha wa kɨma namɨhanaha kiyai sata kaundataase. “Ipatɨ pikɨhandunɨ amɨ ipatɨ nahatewa wiwaunɨ kairɨhɨretapɨ sahɨ baiwɨ mmonɨwɨ gwɨnyaapɨse. ");
INSERT INTO agm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ipatɨ pikɨhandamɨ yananaatɨ taatɨ japɨhɨ mwinatɨ nusapaasɨhaahɨ aimɨ yatitandɨ detɨtihe tɨwɨ gwɨnyaapɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Isɨ sɨkiyate. Naaŋɨhaiwa siyatɨ noaipahonɨhɨ mmonawaawaahɨ Autaahaatɨho nyangi nyainjaatɨ bimɨtandɨhandɨ aimɨ nasatɨ utatototɨtihe tɨwɨ gwɨnyaapɨse. ");
INSERT INTO agm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nɨnɨ akɨtɨnɨhɨ sangi kasatataato. Isɨhiya nahatiya wanɨ kɨmuraahiya sangɨ napopɨ binyaihɨ saiwa katohɨwɨmaiwa noaipahonɨhɨ mmondaapo. ");
INSERT INTO agm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yamɨhapatunɨ yapɨpatunɨ notɨ owendaahandɨ kandɨ nisɨ pɨwɨha wɨndɨ siyatɨ owemetatɨ kaanɨhɨ ahotɨmɨ nutaise. ");
INSERT INTO agm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Isɨ sahɨ baiwɨ jaawo. Wiwa sahɨ waapoho nasisoaarɨ nanɨwɨ naharitaawo. Aiwɨ amɨ kahapaamapɨpa ambɨpatapɨhapaapaahɨhɨ maarɨho nusoaasamaitaawo. Ambɨpatamɨhaiwaapɨ gwɨnyaapɨ kaiwaapaahiyawaawɨ Awaisɨhopɨ wɨndɨ namaapɨtaiso tɨwɨ nehɨ nanɨhaiwɨ binyaihɨ ketɨ kuraanɨhɨ kɨnapaahinatɨ noaipaitaiso. ");
INSERT INTO agm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Asisɨha sa ketɨ yapɨhɨ nahanda gaamatɨ isɨhiyaapɨhɨ noaipaitaise. ");
INSERT INTO agm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nahatewetɨ nasisoaarɨ jaawɨ bindawa Autaahaatɨhopɨ namaamɨhaapɨ gaapundɨwɨse saiwa noaipaitandaiwɨmaiwa ipɨhatiwɨmaitaatɨwo. Aiwɨ amɨ sahɨ nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonisɨ ndɨhetɨ wɨndɨ yamaiwɨ noaipapɨ bitoaitaatɨwo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Asisɨha nahatewetɨ Jisaasiho Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandaatɨhɨ nandaatɨ isɨhiyai pɨwɨha kataunjataise. Kataunjihɨ napwɨhihɨ niyatɨ sisɨho ipatɨ oripɨhatɨ ahetisɨhoaasɨnɨ nanotaise. ");
INSERT INTO agm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aihɨ isɨhiya nahatiya nahatewetɨ komɨ pɨwɨha atɨwitaatɨwɨ asisɨhaatɨhɨ ketɨ Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandaatɨhapɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Judaahiyaamɨ asisɨha nandapa bɨretɨhandɨ nipitandɨhandɨ ahɨmaayawɨhandɨ nehɨhandɨ nandaatɨwɨha aimɨ nasatɨ detɨndaise. Sa asisaamɨ ambɨpatɨ Pasopaahande. ");
INSERT INTO agm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aihɨ pɨrisihiya isɨhiyaamɨ maipɨhaiwaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ mɨtɨhiyaunɨ amɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ sanawaayopo. Isɨhiya Jisaasihopɨ gaahore tɨwɨ maaritɨwɨhiyaasɨ nyahɨ Jisaasihoai kiyaamɨ ndɨhetɨ tiwisaihɨ amɨ wiwa kiya itɨhɨnyatɨtaawo nnɨwɨ yayawaawɨ namapɨ Jisaasiho sohoai noaatɨwɨ tiwɨtaatɨwɨ pɨwɨha kanawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aihɨ Bwaasɨrɨhɨrɨ Judaasɨ Isɨkariyotɨhoai saimbɨ saimbɨ kaime undatɨ netɨ gɨwunyaataise. So Judaasiso otɨpɨpatɨhiya ikwɨmaindɨmwɨtihɨ auhɨramɨ yahurɨtahiya 12 kaiwɨhiyaamɨ wore. ");
INSERT INTO agm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Isɨ ko notɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ mɨtɨhiyaisunɨ amɨ Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandɨ jasohiyɨhiyaamɨ awaisawɨhiyaisunɨ winjatɨ nɨnɨ saindɨ saindɨ nasepaatɨ wɨrasitaano undatɨ kiyaisatɨ pɨwanataase. ");
INSERT INTO agm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aihɨ kiya komɨ pɨwɨhaapɨ gaaha kanyatataaso tɨwɨ maaritɨwɨ tɨhaapaiwɨ nawɨho siyaho samwaaŋɨ akɨtɨnɨhɨ nahɨmɨtaano undɨwɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aihɨ Judaasiho kiya kaundohɨhaapɨ gaaso tatɨ gwɨnyaatɨ amɨ isɨhiya wɨndɨ atɨhomiwɨ mosaihɨ Jisaasihoai tiworisai wɨrawitandɨhɨraapɨ gwɨnyapenatɨ daataise. ");
INSERT INTO agm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nandapa bɨretɨhandɨ nipitandɨhandɨ ahɨmotatɨ nehɨhandɨ nandaatɨwɨha asisɨha aimɨ noaipasɨhura asisɨha setɨ sipɨsipɨhaiwa tiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aihɨ Pitaayɨ Joniyai Jisaasiho pɨwɨha sataha kaundatɨ natausaasataise. “Sahuraahɨ numwɨ nandapa bɨretɨhandɨ nipitandɨhandɨ ahɨmotatɨ nehɨhandɨ nandɨhaahandɨ Pasopaahandapɨ nandɨhaahapa nepɨ nyamanɨta numwise,” undatɨ natausaasataise. ");
INSERT INTO agm_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Aihɨ amɨ kurɨ Jisaasihoai saundɨmɨ nunjenamaise. “Yuhuraangɨ maahɨwapɨhɨ noha nandapa neha tɨmanɨtɨhaawe?” undɨmɨ nunjenamaise. ");
INSERT INTO agm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aihɨ amɨ ko komɨha wihoaaŋɨha sata kaundataase. “Sahuraahɨ numwɨ aunahɨpata nandaapɨ utaaho wo waapoho onɨhaara niwatɨ tɨpwɨnji taatɨ nasonɨhɨ iwinjaitaise. Iwinjasaihɨ ko niyonɨhɨ koai nɨwipinjai komɨ ipotɨ numwise. Numwɨ ko aŋɨhandɨ wɨndaatɨhɨ nandaahonaahɨ amɨ kandaatɨhɨ maasɨ sɨhoaasangisangi nandaapɨse. ");
INSERT INTO agm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nandaapɨ aŋaaŋamɨ satɨhoai saundɨmɨse. ‘Nyangisɨ katanyisisɨho asisɨha Pasopaahandetɨ bindata nandapa nisɨ otɨpɨpatɨhiyaisatɨ maasɨ nandandɨhaaŋɨ aŋaaŋɨ maahaaŋe?’ hɨtataase undɨmɨse. ");
INSERT INTO agm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Undisaihɨ ko aŋaaŋɨ waaŋɨ autaahɨ tiwatɨhaasɨnɨhandɨ ganɨhounɨ gwɨtɨho bimɨtɨhaahandunɨ nahataapa ahotahɨrotɨ netɨ nasisɨtaise. Nasisonɨhɨ kapɨhɨ nandapa kapa kapa nepɨ nyamanɨmise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Saundihɨ kurɨ naisururɨ numwɨ Jisaasiho kaundimumwaaŋɨ kamwaaŋɨ tɨtɨhɨ noaipasɨhɨ mmonɨmɨ kahapaamapɨpa asisɨha Pasopaahandapɨ nandaatɨwɨhapa nepɨ tɨmanamaise. ");
INSERT INTO agm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ipɨho aimɨ notɨ namaatipatɨ asɨhataahuraatihɨ isɨhiya ahoyanɨwɨ bindawa asisɨha Pasopaahandapɨ nandapa nandaatɨwɨhuraatihɨ Jisaasiho niyatɨ ganɨhomɨhinɨ bimihɨ amɨ komɨ otɨpɨpatɨhiyaisangi naiwɨ maasɨ ganɨhomɨhinɨ bindawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aihɨ ko Jisaasiho komɨ otɨpɨpatɨhiyai sata kaundataase. “Asisɨha kɨma Pasopaahandamɨ nandapa nɨnɨ sangisatɨ maasɨ nandandɨ apɨpaahɨ awaindɨhandɨ maaritataayo. Saindɨ nɨnɨ sangisatɨ nandɨmapɨhonɨnɨ yaasɨhandɨ netɨ napwɨtando. ");
INSERT INTO agm_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aindɨ amɨ nɨnɨ sandɨ kasatataato. Pasopaahandamɨ nandapa ipotɨ ipotɨhaiwa nɨnɨ wɨndɨ jɨhaatɨ namando. Namandɨ nehɨ bimaamɨ nundɨ Autaahaatɨho kɨmandɨ Pasopaahandamɨhaiwa netɨ akɨwaiwematɨ isɨhiyai numwaatɨ iwinjaatɨ bimonɨhuraatɨtando,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Saundatosatɨ Jisaasiho kapɨho waapoho wainɨhandɨ windaho netɨ isɨwatataatɨ Autaahaatɨhoai saundatɨ, “Kɨnyɨ iparɨhoŋɨ gaahoŋe gaare,” undatɨ gaapundatosatɨ kiyai saundatɨ nunyataise. “Sahɨ sawanaatɨ kɨhonjɨ kɨhonjɨ nepɨ nanɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nɨnɨ sandɨ kasatataato. Wanɨ kɨmo waapomo wainɨmandɨ nandosatɨ ipotɨ jɨhaatɨ wɨndɨ namando. Namandɨ nehɨ bimaamɨ nundɨ Autaahaatɨho komɨ isɨhiyai numwaatɨ ahoyatɨ iwinjaatɨ bimonɨhura sura japɨhɨ nando,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Saundatosatɨ amɨ nandapa bɨretɨhandɨ wonjɨ netɨ isɨwatataatɨ Autaahaatɨhoai saundatɨ, “Kɨnyɨ gaahoŋe gaare,” undatɨ gaapundatosatɨ naumbotɨ “kɨhonjɨ kɨhonjɨ nepɨ nanɨwɨse” undatɨ nunyataatɨ pɨwɨha saundataase. “Kɨmatɨ nisɨ ambɨpatɨ samɨ maipɨhaiwa nesama jatatamanɨtandɨ nasɨpainjɨpate. Sahɨ kɨmaiwɨ nahatewetɨ kaiwɨ nanawaawɨ nisapɨ gɨnunyaitaatɨwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aihɨ saiwɨ kiya aimɨ nanɨwosawɨ amɨ naasɨkatɨ kiyatɨ kaapɨho waapoho wainɨhandɨ windaho nandaatɨwɨ netɨ nunyataatɨ kiyai saundataase. “Kɨmandɨ kaapɨ wainɨmandɨ nisɨ jɨtɨpatɨ sangi jatatamanatɨ andɨtɨsaiwɨtandɨ sanaindɨhandaahɨ Autaahaatɨhounɨ amɨ komɨ isɨhiyaunɨ maasɨ tɨmaamaitɨtaatɨwɨhandapɨ pɨwɨha wanɨha wɨsasotɨhande. ");
INSERT INTO agm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Iyataatɨ nɨngisɨ isɨhiya tiworisaamɨ ikwɨraatɨhɨ wɨratɨnitandɨho kɨmo wanɨ ganɨhomɨhinɨ nɨngisatɨ maasɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Autaahaatɨho nisapɨ ko siyatɨ siyatɨ kaitaise tatɨ gwɨnyaatɨ katirɨhɨrɨ kɨretɨ nɨnɨ isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ napwɨto. Iyataahandɨ kandɨ amɨ utaaho so nɨngisɨ isɨhiyaamɨ ikwɨraatɨhɨ wɨratɨnisɨhopɨ maarɨho waatɨ tɨndataise ko ambɨpatɨ yaawɨhandɨ naitaiho,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aihɨ kiya otɨpɨpatɨhiya nyamɨ diyaamaho sandɨ kaitandɨ gwɨnyaatɨ bimihise tɨwɨ sawana nasenɨnawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aihɨ amɨ Jisaasihomɨ otɨpɨpatɨhiya sawana sanawaatopo. “Nyamɨ otɨhatɨhapɨ awaisɨho nyamɨ jɨhimainjɨho diyaamahore?” tɨwɨ pɨwɨha wihɨwihoaaŋɨ kanawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aihɨ amɨ ko kiyaisɨ wihoaaŋɨha sata kaundataase. “Autaahaatɨho akohopɨ wɨndɨ gɨmunyaapɨ nanɨpimatɨwɨhiyai Isɨraherɨhiyaamɨ dawaataatapɨhiyaamɨ awaisawɨhiya kiŋɨhiya ambɨpatɨ awaipatɨ nepɨ kiyaamɨ isɨhiyai winjaawɨ bindawaayopo. Aiwɨ amɨ kiya isɨhiyai iwinjaawɨ bimohiyɨhiya satɨwɨ ambɨpatɨ nusoaasanawaayopo. ‘Nyahɨ isɨhiyaisɨ biyaatɨ naisumwaatɨ iwɨtatamanaatɨ iwinjaawa bindɨhaayo,’ tɨwɨ ambɨpatɨ nusoaasanɨwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Iyataahandɨ kandɨ sahɨ siyaamataiwɨ kamaiwɨse. Owetane. Samɨ otɨhatɨhapɨ wo noaipatɨ awaisɨho jɨhoematɨtandaahɨ amɨ ko ipotɨhoematane. Iyataatɨ amɨ samɨ mɨtɨho samɨ otɨpɨpatɨhoematane. ");
INSERT INTO agm_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Utaaho maahɨwo awaisɨhoematɨtaise? Utaaho nandapa nandandɨ bimisɨhoro e nandapa tɨhatɨ noaatɨ numwisihoro? Nandapa nandandɨ ganɨhomɨhinɨ bimisɨmo kɨmɨ kore. Iyataatɨ amɨ nɨnɨ samɨ otɨhatɨhɨ samɨ otɨpɨpatɨhonɨnɨ sangisɨ jatatamanɨtandɨhonɨne. ");
INSERT INTO agm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nɨngisaapɨhɨ nanɨsenɨhaiwa noaipasɨhandɨ kandɨ sahɨ wɨndɨ nɨngisɨ nanɨmasisɨ namaayopo. Owetise. ");
INSERT INTO agm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nɨnɨ isɨhiyai iwinjaatɨ bimɨtandɨ Apɨho Autaahaatɨho watɨpɨhandɨ nanɨmipatamataindɨ amɨ nɨnɨ sangisɨ watɨpɨhandɨ nasinyataayo isɨhiyai iwinjaawɨ jɨhimatɨwɨ bimɨtaatɨwo. ");
INSERT INTO agm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nɨnɨ isɨhiyai iwinjaatɨ bimohɨtɨhandaatɨhɨ sahɨ nandaapɨ nɨngisawɨ nandapa waapoho maasɨ ganɨhoaasɨnɨ nandaapo. Aindɨ amɨ nɨnɨ sangisɨ ahɨsisanɨhɨ sahɨ isɨhiya ikwɨmaindɨmwɨtihɨ auhɨramɨ yahurɨtahiyaamɨ namoyaatohiyɨhiya Isɨraherɨhiyai amɨ awaisawɨhiyaatɨ mɨtɨhiyaatimatɨwɨ iwinjaawɨ bimɨtaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisaasiho Saimonɨhoai saundataase. “Saimonɨhoŋe, Saimonɨhoŋe, kɨnyɨ baimbɨ atime. Bwaasɨrɨhɨrisɨ Autaahaatɨho kaimbɨ nunjeme undihɨ kɨrɨ sangisɨ netɨ konɨho witɨhandɨ pasaaha nemaitaatɨwɨ kihɨkihoaaŋemahohɨpatamatiyatɨ netɨ sangisɨ kihɨkihoaaŋesamatɨ nasopɨsasɨtandɨ aimɨ kandaase. ");
INSERT INTO agm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Satatɨ Katihɨhandɨ kandɨ nɨnɨ Autaahaatɨhoai aimɨ nunjenataayo kɨnyɨ nisapɨ gɨnunyaahingɨtɨhandɨ wɨndɨ nihɨrɨpɨ owemetɨtando. Kɨnyɨ maipɨhandɨ kaingɨtɨhandɨ namasisɨ nepemaitɨpɨ japɨhɨ nɨngisenda nasapaahura kɨmiya otɨpɨpatɨmiyai pɨwɨha iwɨtatamanɨpɨ andɨtɨwipɨha nunyapɨ kaundɨtaape,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Satatɨ kaundihɨhandɨ kandɨ amɨ Pitaaho komɨha wihoaaŋɨha satatɨ kaundataase. “Awaisɨhoŋe, nɨnɨ gisatɨ maasɨ napwɨtɨtunɨ amɨ napwɨtandɨhandapɨ aimɨ tɨmendaayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Aihɨ amɨ Jisaasiho koaisɨ saundataase. “Pitaahonye, nɨnɨ akɨtɨnɨhɨ gisɨ sandɨ kahɨtataato. Wanɨ apɨmatɨhɨ otɨpwɨsɨpaatɨ sangɨ gaatonɨhɨ kɨnyɨ nisapɨ satɨpɨ so Jisaasihoai nɨnɨ wɨndɨ mausotɨ kopɨ wɨndɨ atɨhomindɨhopɨtopo undɨpɨ mairɨmanyaara watɨpɨtɨpɨ kaundɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Aihɨ Jisaasiho kiyai saundataase. “Jɨhura nɨnɨ sangisɨ nandɨsɨsoaasohura nawɨho ikihɨ namatanaatɨ itɨpatɨ sapa wɨndɨ mipɨ nehɨ taanahiyɨhiyaatɨ nuwɨse satɨtɨ nandɨsɨsoaasataayo. Aihɨ amɨ sura sahɨ wapaapɨ nenoaahɨtawaayowo e owetiso?” undatɨ nunjenataise. Aihɨ kiya wihoaaŋɨha koai saundawaatopo. “Nyahɨ sura wapaapɨ wɨndɨ nenoaahɨmeto. Owetise,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aihɨ amɨ komɨha kiyai saundataase. “Jɨhura nɨnɨ sangisɨ sandɨ kasatonɨ amɨ wanɨhɨ utaaho wo ikihɨ amɨ nawɨho sapaisahondaataahɨ kapa isɨwatɨ none. Iyataatɨ amɨ utaaho wo namatanaatɨ owehondaataahɨ komɨ apotɨhɨrɨ tiwatɨhaatɨhɨrɨ nausohaatɨ isɨhiyai nunyatɨ nawɨho netɨ kora namatanaatɨ nunyatɨ nene. ");
INSERT INTO agm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nɨnɨ sandɨ sangisɨ kasatohɨtɨmandɨ apaapɨmaato. Amɨ Autaahaatɨhomɨ pɨwɨha satatɨ jɨpatɨpindataise. ‘Kounɨ isɨhiya ikopaisahiya maipɨhiyaisawɨ ahoyawɨ tɨmaamahɨwawaayopo,’ tatɨ jɨpatɨpindise. Satindɨmandɨ tɨtɨhɨ nisapɨ kandaasɨ nisɨhetɨ kiyatɨ noaipaitaise. Autaahaatɨhomɨ pɨwɨhaatɨhapɨ nisapɨ katatɨ ahotindɨhandɨ wanɨ tɨtɨhɨ akɨpɨpa ausaimanɨnatɨ koaipaitandaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aihɨ kiya koai saundawaatopo. “Awaisɨhoŋe, nyahɨ namatanaatɨ yatɨmwɨ isɨwatɨhaayonɨ nyainjase,” undawaatopo. Aihɨ ko kiyai saundataase. “Gaasɨ sɨkatɨmurɨ isɨwatɨwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisaasiho nasisoaarɨ notɨ gaapundatoaatimbɨpɨhɨ Sisɨho Oripɨhoaasɨnapɨ aunahɨpatɨ awaipatɨ Jerusaremɨhanda namasi noaipasi naihɨ amɨ komɨ otɨpɨpatɨhiyaisangi maasɨ koai nɨwipinjai nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aihɨ ko notɨ kapɨhɨ aimɨ noaipatosatɨ komɨ otɨpɨpatɨhiyai saundataase. “Samɨhetɨ nasisendandɨhaiwa nasonɨhɨ sahɨ kaiwaapɨ wɨndɨ tɨmaamɨhaitaatɨwɨhandapɨ baiwɨ gaapundɨwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Saundatɨ kiyaisɨ kapɨhɨmapɨ onɨhɨ wonjɨ notɨ atotɨpɨwesatɨ bindataatɨ satatɨ Autaahaatɨhopɨ gaapundataase. ");
INSERT INTO agm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Apore, yaasatɨ naaŋɨhandɨ kɨmandɨ awaindɨhandɨ nehohɨtɨmandɨ kɨnyɨ nepɨnɨmaitaapɨ gwɨnyaapaapaahɨ nepɨnɨmape. Iyataahandɨ kandɨ nisɨ gwɨnyaatɨ maaritohɨrɨhɨretɨ wɨndɨ kamaime. Owetane. Kɨnyɨ kɨwahoŋɨ gwɨnyaapɨ tɨmanɨnɨpɨ kinyɨ maaritingɨrɨhɨretɨ kaime,” undatɨ gaapundataase. ");
INSERT INTO agm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aihɨ Autaahaatɨhomɨ otɨpɨpatɨho yamɨhapataatɨhɨ bimisɨho koenda nasatɨ koai netɨ andɨtɨwiwataise. ");
INSERT INTO agm_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisaasihoai apɨpaahɨ awaindɨhandɨ yaawatɨ naaŋawisamasɨhɨ waatɨ andɨtitatɨ gaapundɨmɨ naihɨ dɨpɨpatɨ jɨtɨpatamatiyatɨ utaahomɨhetapɨ nurɨwoaatɨ nawetatɨ yapɨpatetɨ bɨtorɨwataise. ");
INSERT INTO agm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ko siyatɨ gaapundamapɨ dosisɨ notɨ komɨ otɨpɨpatɨhiyai usonata kiyaamɨ maarɨho ambɨpatɨ apɨpaahɨ naaŋawisamasɨhɨ nanomawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nanomɨhauhɨ kiyai ko satatɨ kaundataase. “Sahɨ napaapɨ nanɨhaiwɨ nanoposopo? Sahɨ nepapɨ Autaahaatɨhopɨ gaapundɨwɨse naaŋɨhaiwa wiwa sangisaapɨhɨ nasoaipaitaiso,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisaasiho satatɨ taatɨ kaundihɨ isɨhiya taahɨtɨhandɨ wɨrɨsandɨhandɨ nasawaayopo. Judaasiho tɨwɨ ambɨhɨtohɨho so otɨpɨpatɨhiya ikwɨmaindɨmwɨtihɨ auhɨramɨ yahurɨtisawɨhiyaamɨ wore. Isɨ ko isɨhiya siyaamɨ jɨhɨ ko Jisaasihomɨhinɨ detɨ koai gerundɨtandɨ nasataise. ");
INSERT INTO agm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aihɨ Jisaasiho koai saundataase. “Judaasihoŋe, kɨnyɨ gerɨndingɨtɨmandɨ kandaahɨ nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ Awaisɨhonɨngi nepɨ tiworisaamɨ ikwɨraatɨhɨnɨmaitaapo?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aihɨ Jisaasihomɨ otɨpɨpatɨhiya kapɨhɨ Jisaasihoaisawɨ maasɨ bitohohiyɨhiya mmonɨwɨ gwɨnyaawa sandɨ aimɨ koaipaitandaihɨ kiya satɨwɨ nunjenawaayopo. “Awaisɨhoŋe, nyahɨ nyamɨ namatanaata isɨmiya kɨmiyaisɨ tiwɨtaanɨ kɨnyɨ gaare nyatɨtaino?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aihɨ kiyaamɨ otɨhatɨhapɨ wo namatanaata nandapa tɨhɨwɨ Autaahaatɨho dɨpumanɨhohiyɨhiyaamɨ mɨtɨhomɨ otɨpɨpatɨhomɨ atihɨrɨ ikwɨrɨ gaatɨhɨraihoaaŋɨhɨrɨ oturamasɨhɨ yapɨpatetɨ tɨmahiyataise. ");
INSERT INTO agm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aihɨ Jisaasiho sandɨ mmonata koai saundataase. “Satɨ jɨhaatɨ wɨndɨ kamaimbɨ bɨpi namɨhaape,” undataase. Saundatosatɨ ko atihɨraasɨnɨ uwisɨhɨ atihɨrɨ japɨhɨ ketɨ kuraanɨhɨ yaumbwimanɨnatɨ bitatɨ gandaise. ");
INSERT INTO agm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Saundatosatɨ amɨ Jisaasiho koai isɨwɨta nasohiyɨhiya pɨrisihiya nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨhohiyɨhiyaamɨ mɨtɨhiyaisunɨ amɨ Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandɨ jatohiyɨhiyaamɨ awaisawɨhiyaisunɨ amɨ mɨtɨhiyaisunɨ ko saundataase. “Utaaho wo maatɨmaatisa tɨpɨpa kiyahoai tipɨ isɨwɨtaatɨwɨ nasohɨpatamataiwɨ namatana pwɨsɨpatɨ nisapɨ isɨpɨ nasawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Asisɨ nahatewetɨ nɨnɨ nasisoaarɨ Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandaatɨhɨ sangisatɨ bimonɨhɨ sura sahɨ nɨngisɨ wɨndɨ maanihopo. Asɨhatindɨhandamɨ watɨpɨhandɨ noaipataatɨ nɨngisɨ nanɨtipɨhaasɨ wanɨ sapɨhuraasɨ saiwɨ kaitaatɨwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sata kaundatɨ namɨhaasɨhɨ kiya Jisaasihoai isɨpɨ numwaasi pɨrisiho nandapa tɨhɨwɨ dɨpumanɨhohiyɨhiyaamɨ mɨtɨhomɨ anɨtɨtɨhapɨ niyawaayopo. Aihɨ amɨ Pitaaho kiyai nɨwipinjai kiyaamɨ ipotɨ niyatɨ onɨhɨ wonjɨ bitondaise. ");
INSERT INTO agm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Aihɨ amɨ isɨhiya sandɨ aŋɨndamɨ matambɨpotɨ sisɨha tɨhoaapɨ tɨhwimauhɨ amɨ Pitaahoaisangi kiyaisatɨ maasɨ kapɨhɨ sisɨhainɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aihɨ apopaatɨ waatɨ otɨpɨpatɨhaatɨ ko sisɨhainɨ bimihɨ koai tɨtɨhɨ iwinjatataatɨ saundataase. “Kɨmo utaamo Jisaasihoaisatɨ maasɨ bisotinjahore,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aihɨ Pitaaho Jisaasihopɨ baahɨ noaasatɨ kaati saundataase. “Apopaanye, utaaso soai nɨnɨ wɨndɨ mausotɨhopɨ kandapaase,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aihɨ amɨ otɨhɨ wonjɨ bimihɨ utaaho wo nasatɨ Pitaahoai usonataatɨ koai saundataase. “Gisangi Jisaasihoaisawɨ maasɨ daayohiyɨhiyaamɨhoŋe,” undataase. Aihɨ Pitaaho koai wihoaaŋɨha saundataase. “Utaahoŋe, nɨnɨ kiyaisahonɨnɨmaahe apɨpaahɨ owetise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aihɨ amɨ otɨhɨ utaarɨ wonjɨ bimaambɨwɨ (wanɨ auwa kiyatɨ sanaihɨ) amɨ utaaho wo nasatɨ sandaase. “Kɨmo utaamo akɨtɨnɨhɨ koaisatɨ maasɨ naihɨ usonɨhonɨhoe. Iyataatɨ amɨ ko Garirihandandaahapɨhotihɨto,” tatɨ apɨpaahɨ andɨtitamatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Saundihɨhandɨ kandɨ amɨ Pitaaho saundataase. “Utaahoŋe, kinyɨ pɨwɨha kɨma katingɨmaapɨ gɨmaanunyaatatɨ wɨndɨ monɨtɨhonɨngi kandapaase,” undatɨ taatɨ kaundihɨ otɨpwɨsɨpaatɨ ketɨnɨhɨ gandaase. ");
INSERT INTO agm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Aihɨ Awaisɨho nepemaitatɨ Pitaahoai iwinjataise. Aihɨ Pitaaho pɨwɨha Awaisɨho jɨhɨ satatɨ kaundisɨhaapɨ gwɨnyaataise. “Wanɨ apɨmatɨhɨ otɨpwɨsɨpaatɨ sangɨ gaatonɨhɨ kɨnyɨ nisapɨ satɨpɨ soai nɨnɨ wɨndɨ mausotɨ gɨmunyaatɨhonɨne tɨpɨ mairɨmaara katɨtaise,” undatɨ kaundisɨhaapo. ");
INSERT INTO agm_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Siyatɨ gwɨnyapenataatɨ Pitaaho matambɨpaamɨ mɨhapaahɨ nehɨhaatɨ noaipasi notɨ waatɨ pɨhɨtatɨ maipiyatɨ gotaise. ");
INSERT INTO agm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Isɨhiya Jisaasihoai isɨpɨ numwaasi tiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Aiwɨ amɨ kiya Jisaasihomɨ ndɨhotɨ yutɨhɨra namaasapɨ wɨsasawosawɨ satɨwɨ nunjenawaayopo. “Aho aho nɨngi nɨwataise tɨpɨ ambɨpatɨ ambɨhɨtɨpɨ katɨme,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aiwɨ amɨ kiya pɨhɨtɨwɨ Jisaasihometisetetapɨ mɨmaipɨtɨwɨ katɨwɨ nausopɨ ahoaapɨ kɨhaiwa kɨhaiwa kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aihɨ bowihɨ asisɨhaatɨhɨ Judaahiyaamɨ mɨtɨhiyaunɨ amɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ ahoyanɨwɨ bimauhɨ Jisaasihoai numwaasi kiyaamɨ ndɨhetɨ nowaayopo. Numwaasi nuwɨ kiyaapɨhɨ pɨwɨha satɨwɨha kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Kɨnyɨ nyangisɨ nɨnɨ Kɨraisihonɨne owe nɨnɨ Kɨraisihonɨnɨmaahe tɨpɨ tɨtɨhɨ kanyate,” undawaatopo. Aihɨ amɨ komɨha kiyai saundataase. “Nɨnɨ sangisɨ Sanahaahonɨne satɨtɨ kasatisanaahɨ sahɨ nisapɨ akɨtɨ kore tɨwɨ wɨndɨ baiwɨ gɨmaanunyaitaapo. ");
INSERT INTO agm_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nɨnɨ amɨ pɨwɨha wiwa sangisɨ nasɨsesanɨhaiwa wihoaaŋɨha wɨndɨ baiwɨ kamandɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Iyataahandɨ kandɨ amɨ wanɨ kɨmuraapɨ namasatɨ Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ Autaahaatɨho Nahatewa Watɨpɨhaiwaisahomɨ ikwɨrɨ gaatɨhɨraihoaaŋɨ bimɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aihɨ amɨ kiya nahatiya koai saundawaatopo. “Amɨ kɨnyɨ Autaahaatɨhomɨ Mwaahoŋo e nehɨ gi woŋo?” undawaatopo. Aihɨ amɨ komɨha kiyai saundataase. “Sahɨ sawanaatɨ aimɨ tɨtɨhɨ katawaatopo. Nɨnɨ kɨmɨkonɨne,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aihɨ kiya sawana sanawaatopo. “Nyahɨ napaapɨ jɨhaatɨ pɨwɨha atɨwitɨhaawe? Aimɨ sawaho komɨ maahomwaaŋapɨ pɨwɨha kɨma ka katihɨ aimɨ atisaatɨ nehaayono,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aihɨ kiya satɨwɨmapaahɨ isɨhiya nahandɨ dopɨ Jisaasihoai numwaasi Pairotɨhomɨ ndɨhetapɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Numwaasi nuwɨ kiya kopɨ siya siyahoe tɨwɨ satawaatopo. “Nyahɨ nyamɨ yapɨpata kiyohɨwaiwa kamaayatɨ koai wɨretɨ asɨretɨ kiyahore. Iyatɨ amɨ ko nawɨho takisihandɨ awaisɨhoai namunyawɨse nyatihɨ nyahɨ usonɨhaayo. Iyatɨ amɨ ko sanyatahore. ‘Nɨnɨ Kɨraisihonɨnɨ Awaisɨhonɨnɨ Isɨhiyaisunɨ kahapaamapɨpaisunɨ netɨ jaatɨ bimɨtandɨhonɨne’ nyatahore,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aihɨ awaisɨho Pairotɨho satatɨ koai nunjenataise. “Judaahiyaamɨ awaisɨhoŋɨ kiŋɨhoŋo?” undatɨ nunjenataise. Aihɨ komɨha wihoaaŋɨha satatɨ kaundataase. “Ye, kɨnyɨ tɨtɨhɨ sɨka katapaase,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aihɨ Pairotɨho pɨrisihiya awaisawɨhiyaisunɨ amɨ isɨhiya nahatiyaisunɨ satatɨ kaundataase. “Kɨmo utaamo gaaho maipɨhapa wapa kamaayahotihɨ nɨnɨ usonataayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aihɨ kiya waapɨhɨtɨwɨ andɨtitɨwɨ satawaatopo. “Kɨmo utaamo komɨ pɨwɨha katisɨhaara isɨhiyaamɨ maarɨho omaŋɨtɨtɨhɨ netɨ nusopɨsasɨnataise. Sandɨ yapɨpatɨ Judiyaahandamɨ nahataapɨpɨhɨ noaipataise. Sandɨ ko yapɨpatɨ Garirihandaahapɨ namasatɨ kaimɨ nasatɨ wanɨ kɨmbɨhɨndaise,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pairotɨho pɨwɨha atisataatɨ kiyai saundatɨ nunjenataise. “Kɨmo utaamo akɨtɨnɨhɨ Garirihandaahapɨhoro?” undatɨ kiyaisɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aihɨ kiya saundawaatopo. “Jisaasiho kɨmo yapɨpatɨ awaisɨho Erotɨho jaatɨ bimipataahapɨhore” undawaatopo. Saundauhɨ ko atisataatɨ namatɨ Erotɨhoaapɨhapɨ Jisaasihoai netɨ natausaasataise. Iyataatɨ sura Erotɨho Jerusaremɨhanda kapɨhɨ bimihɨhuraare. ");
INSERT INTO agm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aihɨ Erotɨho Jisaasihoai usonataatɨ apɨpaahɨ awaindɨhandɨ maaritataise. Sandɨ apaapɨmaahe. Jisaasiho otɨpɨpatɨ kaiwaiwaapɨ isɨhiya kaundauhɨ atisahosɨ koai usondando tatɨ utaarɨhandetɨ gwɨnyaatɨ bimainjahondaate. Iyatɨ amɨ ko Jisaasiho watɨpɨhandɨ wɨndɨ kiyonɨhɨ usondando tatɨ bimainjahore. ");
INSERT INTO agm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aihɨ Erotɨho pɨwɨha pɨhɨtahaiwa Jisaasihoai nunjesɨhɨ ko pɨwɨha wa wihoaaŋɨha wɨndɨ kamundise. Owetise. ");
INSERT INTO agm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aihɨ pɨrisihiya awaisawɨhiyaunɨ amɨ Judaahiyaamɨ wɨnɨhapɨpa katɨwunjohiyɨhiyaunɨ kapɨhɨ maasɨ bitohohiyɨhiya pɨwɨha wɨndɨ namaamɨhaapɨ waapɨhɨtɨwɨ pɨwɨha asakatɨwɨ Jisaasihopɨ ko siyahoe siyahoe tɨwɨ andɨtitɨwɨ watɨpɨtɨwɨ katawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Aihɨ Erotɨhounɨ komɨ tingaatɨhaisahiyaunɨ Jisaasihoai mɨmaipaiwɨ mɨhambemapɨ baiwɨ usonɨwɨ nɨwisapɨ sisehaiwunjawɨ amɨ sisɨpundɨwɨ amɨ apotɨhɨrɨ wɨrɨ apɨpaahɨ gaahɨrɨ nepɨ nɨwisopɨ japɨhɨ Pairotɨhoenda natɨwusaasawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erotiyɨ Pairotiya jɨhɨ itɨhɨnnɨmɨ yiyandɨhɨ bimambɨmɨhurisɨ wanɨ suraanɨhɨ kuramɨ itɨhɨtinjɨtɨhandɨ namapɨ itɨhɨmanɨmɨ japɨhɨ baimɨ napaisaatɨ pɨwanamaise. ");
INSERT INTO agm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pairotɨho pɨrisihiya awaisawɨhiyaisunɨ amɨ mɨtɨhiya usaisunɨ amɨ isɨhiyaapunɨ gaatihɨ kiya napɨwɨ ahoyanawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Napɨwɨ ahoyanɨhauhɨ kiyaisɨ Pairotɨho satatɨ kaundataase. “Sahɨ utaamo kɨmopɨ isɨhiyaamɨ kiyohɨrɨhɨretɨ kamaayatɨ koai asɨrɨ wɨretɨ kiyataatɨ isɨhiyai netɨ nusopɨsasihe tɨwɨ nɨngisaapɨhɨ numwaasi nasohɨmoai samɨ katohɨmaapɨ koai baindɨ samɨ ndɨhetɨ nunjenɨtɨ mmonataayo. Isɨ sahɨ atiwɨse. Sahɨ kɨmopɨ siyahoe satahoe tohɨmaapɨ nunjenɨtɨ mmonɨhonɨhɨ ko wɨndɨ wapa maipɨhapa kamaayaho utaaho gaahore. ");
INSERT INTO agm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aihɨ amɨ Pairotɨhoaisangi naasɨkatɨ kiyatɨ mmosɨhɨ utaaho kɨmo wɨndɨ maipɨhapa kamaayahotihɨ japɨhɨ nyapɨ natausaasataise. Isɨ atiwɨse. Utaamo kɨmoai nyahɨ sohoai tiwɨtɨhaawɨ ko wɨndɨ maipɨhapa wapa kamaayaho utaaho gaahore. ");
INSERT INTO agm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Isɨ nɨnɨ nehɨ gotɨ titɨ japɨhɨ saimbɨ kamaime undɨtɨ nandusoaasɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Iyataatɨ Judaahiya saiwɨ kaiwɨhiye. Pasopaahandamɨ asisɨha awaisɨha nahatewetɨ utaaho napwɨtohɨpɨhɨ napwɨtatɨ bimihɨhoai Pairotɨho nehɨ nuwausoaasahore. ");
INSERT INTO agm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Isɨhiya nahandɨ maahomwaaŋɨ naasaataatɨmapɨ waatɨ kaahaatɨwɨ satawaatopo. “Kɨmoai tiwisaihɨ naponɨhɨ utaaho Barapaasihoai nyamɨ pɨwɨha atiwɨ japɨhɨ nupusoaasisaihɨ nyangisenda noaipasi nasane,” tɨwɨ kaahaatawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barapaasiho so aunahɨpatɨ Jerusaremɨhanda komɨhapa nuwa nesi notɨ katɨ aunahɨpita gamanɨhoaisatɨ tunataatɨ isɨhiya usa satɨ pwɨsɨpitaahɨ napowaayopo. Aihɨ kandapɨ koai napuhauhɨ napwɨtatɨ bimainjahore. ");
INSERT INTO agm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Aihɨ Pairotɨho jɨhaatɨ kiyai saundataase. “Jisaasihoai nɨnɨ nehɨ nandusoaasɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Aihɨ kiya nahatiya maahomwaaŋɨ naasaataatɨmapɨ waapɨhɨtɨwɨ saundawaatopo. “Owe, ipɨ tɨtɨhɨ atawɨhatetɨ nepɨ nimaapɨse. Ipɨ tɨtɨhɨ atawɨhatetɨ nepɨ nimaapɨse,” tawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aihɨ amɨ Pairotɨho kasɨnɨhandɨ jɨhaatɨ kiyai satatɨ kaundataase. “Napaape? Kɨmo utaamo maipɨhandɨ wɨndɨ kamaihɨ nɨnɨ wɨndɨ mohono. O amɨ maipɨhandɨ wɨndɨ kiyonaahɨ nyahɨ nga sohoai tiwɨtɨhatɨ katɨ owetise. Isɨ nɨnɨ nehɨ pwɨsɨpata gotɨ titɨ japɨhɨ nandusoaasɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Satatɨ ko kaundihɨhandɨ kandɨ kiya komɨ pɨwɨha nemapɨ waatɨ kaahaatɨwɨ watɨpɨtɨwɨ satawaatopo. “Kɨnyɨ Jisaasihoai nepɨ ipɨ tɨtɨhɨ atawɨhatetɨ nimaape,” tawaatopo. Satɨwɨ katawaawɨ komɨ pɨwɨhai timawaayopo. Timapɨ kiyaamɨha akaaha noaipataise. ");
INSERT INTO agm_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aihɨ Pairotɨho mmonata komɨ pɨwɨhai timɨhauhɨ namatɨ kiyaamɨha atɨwisataise. ");
INSERT INTO agm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Atɨwisatɨ utaaho pwɨsɨpatɨ nuwa nesi notɨ gamanɨhoaisatɨ tunataatɨ isɨhiyai tiwihɨ napwauhɨ kandapɨ napwinjɨhopɨ nupusoaase undɨwɨ kaundotɨhoai netɨ nuwausoaasata Jisaasihoai netɨ tingaatɨhaisahiyaamɨ ikwɨraatɨhɨmataise kiya saimbɨ saimbɨ kaime undohɨmumwaaŋɨ kamwaaŋɨ kiyato. ");
INSERT INTO agm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tingaatɨhaisahiya Jisaasihoai ipɨ tɨtɨhɨ atawɨhatetɨ tipɨ nimaitaatɨwɨhapɨhapɨ taawɨ numwaasi niyawaayopo. Niyawaawɨ utaaho wo komɨ ambɨpatɨ Saimonɨho aunahɨpatɨ Sairinihandaahapɨho Jerusaremɨhandaahapɨ taatɨ napihɨhoaisawɨ nutanawaayopo. Nutanɨwɨ tingaatɨhaisahiya koai isɨpɨ kɨmatɨ ipɨ tɨtɨhɨ atawɨhatɨ nepɨ tɨpwɨte undɨwɨ tɨpwɨtɨwusosauhɨ amɨ ko katɨ netɨ tɨpwinji Jisaasihomɨ ipotɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Aihɨ isɨhiya taahiyɨhiya Jisaasihoai iwinjapepinjamɨ komɨ ipotɨ nowaayopo. Aihɨ amɨ kiyaamɨ usa asɨhiyai maawɨ Jisaasihopɨ yiyitɨwɨ ngɨmwɨ ipotɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Aihɨ Jisaasiho nepemaitatɨ kiyai saundataase. “Sahɨ Jerusaremosɨhiyaate, nisapɨ sahɨ wɨndɨ gomaatɨwɨse. Sahɨ sawanaatapunɨ amɨ samɨ simwaaya simaasiyaapunɨ ngwɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sandɨ katotɨmandɨ apaapɨmaato. Amɨ asisɨha wa noaipahonɨhɨ isɨhiya satɨtaapo. ‘Asɨhiya yatɨtɨpɨhiya maaha wɨndɨ namwaamwɨwɨhiya amɨ amwɨtɨhɨrɨ owehiya maahai wɨndɨ amwɨtɨwɨmunyawɨhiya siya waatɨ maaritɨwɨse,’ tɨwɨ katɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aiwɨ amɨ sura kiya satɨtaapo. ‘Sisɨhoŋe, nipepatɨpɨ nyangi nyataatime. Amɨ tipataŋɨ sɨhoaarɨhɨraŋɨ niwautɨpɨ nanyamaasape,’ tɨtaapo. ");
INSERT INTO agm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sandɨ apaapɨmaato. Amɨ nɨnɨ ainahɨhonɨnɨ gaahonɨnɨ ipatɨ asɨpatamatiyahonɨngisɨ sandɨ saiwɨ kanisawaayopo. Iyataatɨ amɨ isɨhiya maipɨhaiwaisahiya ipatɨ awaipɨtahatamataiwɨhiyaasɨ kiya yaawatɨ naaŋɨhandɨ apɨpaahɨ awaindɨhandɨ naitaapo,” tatɨ Jisaasiho kandaase. ");
INSERT INTO agm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aiwɨ amɨ kiya tingaatɨhaisahiya utaahurɨ wurɨ maipɨhaiwaisahurɨ ikopaisahuri Jisaasihoasawɨ maasɨ ahoyawɨ tipɨ ipɨ tɨtɨhɨ atawɨhatetɨ nimaitaatɨwɨ numwaasi nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kiya Jisaasihoai numwaasi naiwɨ sisɨho wo Isɨhiyaamɨ Mɨtɨhomɨ Andɨtatamatetɨhapɨhe tɨwɨ ambɨhɨtɨwɨhoaasɨnɨ noaipapɨ kapɨhɨ Jisaasihoai ipɨ tɨtɨhɨ atawɨhatetɨ nepɨ nimaawaayopo. Aihɨ amɨ utaahurɨ maipɨhuramɨ wo Jisaasihomɨ ikwɨrɨ gaatɨhɨraihoaaŋɨtihɨ amɨ wo komɨ ikwɨrɨ konaamohɨraihoaaŋɨtihɨ nimaawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iyauhɨ Jisaasiho sandaase. “Isɨhiya kɨmiya nɨngi kanisohɨtɨmandapɨ wɨndɨ gɨmaawunyaatatɨ namausesɨpainjɨhɨ kiyawaayopo. Apore, kɨnyɨ kiyaamɨ maipɨhaiwa nepumape,” tatɨ kandaase. Aihɨ kiya Jisaasihomɨ apotɨhɨrɨ dɨndiya naitaapo tɨwɨ tingaatɨhaisahiyaamɨ ambɨpatɨ ambɨhɨtɨwɨ wapa ipɨpa isawaayopo kiya nɨnaasiyaamɨhetapɨ wapa wipimata noaipasawɨhiya kiya Jisaasihomɨ apotɨhɨrɨ tipɨtapaapɨ naitaatɨwo. Aiwɨ komɨ apotɨhɨrɨ sɨrɨ tipɨtapaapɨ newaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Isɨhiya kapɨhɨ bitotawa iwinjasauhɨ amɨ Judaahiyaamɨ awaisawɨhiya Jisaasihoai sisɨpɨhundɨwɨ satɨwɨ kaundawaatopo. “Kɨnyɨ isɨhiya usaisɨ iwɨtatamanɨpɨ andɨtɨwipɨ kiyaamɨ ambɨpatɨ nepɨ yaumbwimanɨpɨhoŋisɨ amɨ wanɨ kɨnyɨ kɨwahoŋɨ kinyɨ ambɨpatisɨ nepɨ yaumbwimanɨpɨ japɨhɨ noaatɨpape kɨnyɨ Isɨhiyai Maipɨhaiwaatɨhapɨ Japɨhɨ Numwaitaapɨ Autaahaatɨho Nangɨmahanatɨ Ahɨngisɨhoŋɨ Mesaiyaahoŋɨtapaapaaho?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aihɨ amɨ tingaatɨhaisahiyaisangi Jisaasihoai sisɨpundɨmɨ detɨ naiwɨ waapoho wainɨhandɨ ikonahandɨ nandotɨwɨ nunyawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nunyawaawɨ saundawaatopo. “Kɨnyɨ akɨtɨnɨhɨ Judaahiyaamɨ Awaisɨhoŋɨ kiŋɨhoŋɨtapaapaahɨ kinyɨ ambɨpatisɨ nepɨ yaumbwimanɨpɨ noaatɨpape,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jisaasihomɨ mɨtɨhomɨ autaahɨ pɨwɨha wa satɨwɨha jɨpatɨpaiwɨ wɨsasawosawaayopo. “Kɨmo Utaamo Judaahiyaamɨ Awaisɨho Kiŋɨhore tɨwɨha jɨpatɨpaiwɨ wɨsasawosawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Utaahurɨ maipɨhaiwaisahurɨ Jisaasihoaisawɨ ahoyawɨ maasɨ ipɨ tɨtɨhɨ atawɨhatetɨ nimaahohururamɨ wo Jisaasihoai saundatɨ itɨhundatɨ sisɨpundataase. “Kɨnyɨ akɨtɨnɨhɨ Kɨraisihoŋɨtapaapaahɨ kɨnyɨ kɨwahoŋɨ nepɨ yaumbwimanɨpɨ amɨ yahuraanyangimaawɨ nepɨ yaumbwinyimane,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aihɨ amɨ sasaaho wihoaaŋɨ nimandisɨho sa pɨwa atisataatɨ satatɨ itɨhundataase. “Kɨmo utaamo yaawɨhandɨ nesɨpatamataimbɨ yaasahandɨ nepaise. Isɨ kɨnyɨ Autaahaatɨhopɨ wɨndɨ yamaasiso? ");
INSERT INTO agm_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yahuraaŋɨ maipɨhaiwa kiyonɨhɨ kandapɨ kiya tɨtɨhɨ gaahatɨ kanyiwɨ nyapɨ nanyimaawaayopo. O amɨ utaamo kɨmohɨ utaaho apɨpaahɨ gaaho ainahɨho yaawɨhandɨ nehɨhandɨ netaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Iyatɨ amɨ ko Jisaasihoai saundataase. “Kɨnyɨ kinyɨ aunahɨpata noaipapaahura nisapɨ gɨnunyaape,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aihɨ Jisaasiho komɨha wihoaaŋɨha koai satatɨ kaundataase. “Nɨnɨ gisɨ akɨtɨnɨhɨ sandɨ kahɨtataato. Wanɨ kɨmura kuraanɨhɨ kɨnyɨ nisɨ aunahɨpatɨ gaahata yamɨhapataatɨhɨ nɨngisapɨ maasɨ bimɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Otapɨhaatɨ ipɨho saniyatɨ otɨhasɨnɨtihɨ ipɨho napomataise. Napomasɨhɨ suraapɨ namasatɨ yapɨpatɨ katamɨ nahataapɨpɨhɨ asahatamataise. Asahatɨmɨ notɨ ipɨho ikwɨtaawotɨ yaataatisura japɨhɨ bowataise. ");
INSERT INTO agm_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Aihɨ sura Autaahaatɨhomɨ aŋɨhandɨ Awaindɨhandamɨ rumɨhandɨ Autaahaatɨho Sawahohɨ jatirɨhɨrotɨ apotɨhɨrɨ wɨrɨ yatɨpiyapɨ napuhotɨhɨrɨ mɨhaatapɨ kɨrɨnɨhɨ mɨhaapɨ nutaatɨ yiyandɨhɨ wihɨwihoaaŋɨ ahiyataise. ");
INSERT INTO agm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Aihɨ Jisaasiho waapɨhɨtatɨ satatɨ kandaase. “Apore, nisɨ maarɨho kinyɨ ikwɨraatɨhɨmataayo,’ tatɨ katamapaahɨ konɨhɨ aimɨ napomataise. ");
INSERT INTO agm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sandɨ siyatɨ noaipasɨhɨ tingaatɨhaisahiyaamɨ mɨtɨho mmonataatɨ Autaahaatɨhoai mepɨ autaahemwatɨ satatɨ kandaase. “Kɨmo utaamo apɨpaahɨ akɨtɨnɨhɨ gaaho ainahɨhore,” ndaase. ");
INSERT INTO agm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jisaasihoai kawisotɨmandɨ mmondaatɨwɨ niyohiyɨhiya kandɨ mmonɨwɨ kaiwɨmapɨ japɨhɨ nowaawɨ ise tɨwɨ maarɨho asɨpaimɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Aihɨ amɨ Jisaasihomɨhiyaunɨ amɨ asɨhiya Garirihandaahapɨhiya Jisaasihomɨ ipotɨ napɨwɨhiya Jisaasihoai nimaahohɨpɨpɨhɨ onɨhɨ wonjɨ bitotawa saiwa siyatɨ noaipasɨhɨ mmonawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Utaaho komɨ ambɨpatɨ Josepɨho aunahɨpatɨ Arɨmatiyaahandaahapɨho bindataise. Satɨ aunahɨpa Arɨmatiyaasɨndɨ yapɨpatɨ Judiyaahandamɨ aunahɨpate. Iyataatɨ so utaaso gaahotihɨ isɨhiya kopɨ maaritɨwɨhore. Iyatɨ amɨ ko Autaahaatɨho isɨhiyai iwinjaatɨ bimaamɨ naindɨhandɨ auta noaipaitaise tatɨ jaatɨ bindataahore. Iyatɨ amɨ ko komɨ sasaahoya kaunjorɨhiya gwɨnyaahohɨwaiwaapunɨ amɨ kiyohɨwaiwaapunɨ wɨndɨ gaare maatahore. ");
INSERT INTO agm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Isɨ ko notɨ awaisɨho Pairotɨhoai Jisaasihomɨ ambɨpatɨ napɨhaatɨ naitaano undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Siyatɨ nunjesɨhɨ aaye undihɨ ko Jisaasihomɨ ambɨpatɨ netɨ napɨhaatɨ apotɨhɨrɨ gaahɨrɨ kɨhoepɨhɨraatɨhɨ napapɨhatɨ mmatɨ isɨsi notɨ nawɨha tiputatɨ soaarisatɨ kiyahataatɨhɨ nesisotɨ ahiyataise. Iyataatɨ satɨ tiputatɨ soaarisatɨ kaipitaatɨhɨ itapɨpa wɨndɨ ahɨmaayandahatɨ asɨpate. ");
INSERT INTO agm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sa asisɨha Pɨraindehuraare. Iyataatɨ Judaahiyaamɨ Sapaatɨhandapɨ kahapaamapɨpaunɨ amɨ isɨhiya sawanaunɨ nepɨ tɨmanɨndaatɨwɨhuraatihe. ");
INSERT INTO agm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Asɨhiya Garirihandaahapɨ dosi Jisaasihoaisawɨ maasɨ nasohiyɨhiya Josepɨhoai nɨwipinjai nowaayopo. Nɨwipinjai nuwɨ Josepɨho Jisaasihoai ahaimbɨpɨhɨ mmonawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mmonɨwɨ kaiwɨmapɨ japɨhɨ kiyaamɨ aŋɨpɨpɨhapɨ nowaayopo. Nuwɨ atɨpatɨ tausotɨpatɨ satɨpatɨ biyatɨ waamainjotɨhapa nepɨ tɨmanawaayopo nesaiwɨ Jisaasihomɨ ambɨpatetɨ jaitaatɨwo. Saiwɨ kapa nepɨ tɨmanɨwɨ kiyawaahandɨ kandɨ asisɨha Sapaatɨhandetɨtihiyawaawɨ namapɨ wɨnɨhapɨpa katirɨhɨretɨ japepihɨrɨwɨ ikɨnɨwɨ bindawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Saraarehɨramɨ asisɨha jɨha Sandehura asisɨhaatɨhɨ sangɨ saasinjɨhɨ kohokoaisawɨ nepasi asɨhiya nawɨhaatɨhɨ isɨhiya otiputɨwɨ akohaahaiwɨ anɨmwaahɨpatɨ kaiwɨhataatɨhɨ Jisaasihoai ahiyohɨpɨpɨhapɨ niyawaayopo. Siya asɨhiya satɨpatunɨ atɨpatunɨ wapa biyatɨ waamainjotɨhapa gaahapa nepɨ tɨmanɨwɨ isɨwasohɨpɨpa isɨsi niyawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Naiwɨ jawa Jisaasihoai ahiyohɨpatamɨ maasomwaaŋɨ nawɨha awaisɨha naaŋɨha nepɨ nepehaasawɨ anɨtiwɨ dɨhɨwɨ napuhotɨha sawɨ nundɨwatɨ owetihɨ mmonawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Setihɨ kiya nandaapɨ mɨhatɨhɨ mmonawaahandɨ kandɨ Jisaasihomɨ ambɨpatɨ katɨhɨ wɨndɨ ahɨmotise. Owetise. ");
INSERT INTO agm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mmonawaawɨ Jisaasihomɨ ambɨpatɨ wɨtɨmetihɨ sandɨ napitimatataise tɨwɨ taawɨ pɨhɨtɨwɨ gwɨnyaapɨ maaroamapɨ bitotawaayopo. Aihɨ amɨ ketɨnɨhɨ utaahurɨ wurɨ kuramɨhapa utɨ apotɨhɨrɨ kɨhoepɨtatɨ nausaatahurɨ ketɨ kiyaamɨhinɨ detɨ noaipapɨ bitotamaise. ");
INSERT INTO agm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aihɨ kiya asɨhiya waatɨ awaindɨhandɨ yaiwɨ kiyaamɨ mɨtɨho kɨwopopɨ witɨwɨ yapɨpatetɨ japɨ bitotawaayopo. Bitohauhɨ kurɨ kiyai saundamaase. “Isɨhiya napohiyɨhiyaamɨhatɨhapɨ utaaho japɨhɨ asohoematatɨ nepasɨmopɨ sahɨ napaapɨ taawɨ daapɨ mmohopo? ");
INSERT INTO agm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","So kɨmbɨhɨ wɨndɨ ahɨmotise. Owetise. Kohɨ aimɨ japɨhɨ asohoematatɨ nepase. Ko Garirihanda sangisatɨ maasɨ bindataatɨ sangisɨ aimɨ satatɨ kasatisɨhaapɨ sahɨ gwɨnyaawaayowo? ");
INSERT INTO agm_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Isɨhiyaamɨ Saaho Jɨhoai nepɨ isɨhiya maipɨhiyaamɨ ikwɨraatɨhɨmasaihɨ kiya nepɨ koaisɨ tipɨ ipɨ tɨtɨhɨ atawɨhatetɨ nimaitaapo. Nimaasaihɨ napotatɨ asisɨha mairɨmanya saniyonɨhɨ japɨhɨ nepaitaise,’ tatɨ sangisɨ aimɨ kasatisɨhaare,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Saundihɨ kiya asɨhiya Jisaasiho jɨhɨ satatɨ kaundiwaiwaapɨ e akɨte tɨwɨ gwɨnyapenawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aihɨ asɨhiya kapɨhɨ Jisaasihoai ahiyohɨpɨpɨhɨ namasisɨ japɨhɨ nuwɨ katɨhɨ Jisaasihoai ahiyohɨpataatɨhɨ kaimatatɨ noaipasɨwaiwaapɨ otɨpɨpatɨhiya ikwɨmaindɨmwɨtihɨ auhɨramɨ naasohɨtahiyaisunɨ amɨ isɨhiya nahatiyaisunɨ osamapɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Asɨhiya siya Mariyaahaatɨ aunahɨpatɨ Makɨtaraahandaahapɨhaatɨtihɨ Joaanaahaatɨtihɨ amɨ Mariyaahaatɨ waatɨ Jemɨsihomɨ sanaatɨtihɨ amɨ asɨhiya usai maawɨ nuwɨ saimatatɨ noaipasɨhɨ mmonɨhohɨwaiwaapɨ otɨpɨpatɨhiyai ausaapɨ kaundawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Satɨwɨ kaundauhɨhandɨ kandɨ otɨpɨpatɨhiya asɨhiya etɨtaatɨtɨwɨ jaipɨtawaatopo tɨwɨ gwɨnyaawaawɨ kiyaamɨ pɨwɨhaapɨ akɨtɨ kanyatawaatopo tɨwɨ wɨndɨ gɨmunyaahopo. ");
INSERT INTO agm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Siyauhɨhandɨ kandɨ Pitaahohɨhɨ dosisɨ ŋuhɨti Jisaasiho ahiyohɨpɨpɨhɨ niyataise. Ŋuhɨti niyatɨ mɨhatɨhɨ nambɨtatɨ atahɨwatɨ jataise. Siyatɨ Pitaaho mmonamapɨ notaatɨ sandɨ napitimatataise tatɨ maarɨho owesoetihɨ pɨhɨtatɨ gwɨnyapenataise. ");
INSERT INTO agm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Asisɨha sa ka naasɨketɨ Jisaasihoai nɨwipinjawɨ maasɨ daayohiyɨhiyaamɨ wurɨ aunahɨpatɨ wɨtɨ gwɨharaahatɨ katamɨ ambɨpatɨ Emeyaasihandaahapɨ taamɨ nomaise. Satɨ aunahɨpitɨ detɨ Jerusaremɨhanda ahendaise. ");
INSERT INTO agm_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Aihɨ kurɨ kataahapɨ taamɨ nomaamɨ kahapaamapɨpa nahataapa noaipasɨpɨpaapɨ sawahurɨ taamɨ kanɨmɨ nomaise. ");
INSERT INTO agm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kurɨ kaiwaapɨ taamɨ wihɨwihoaaŋɨ pɨwanɨmɨ naihɨ Jisaasiho sawaho nasatɨ kuramɨhinɨ noaipatɨ kurisatɨ maasɨ taatɨ notaise. ");
INSERT INTO agm_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Naihɨ amɨ kuramɨ ndɨhotɨ wapa netɨ tumwaasasɨhɨ kurɨhɨ Jisaasihopɨ kore tɨmɨ wɨndɨ mmonɨmɨ mausose. ");
INSERT INTO agm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aihɨ ko kurisɨ satatɨ kaundataase. “Sahuraahɨ daahɨmɨra taamɨ nomaamɨ napindapɨ taamɨ kanɨmɨ naise?” undatɨ kuri nunjenataise. Nunjesɨhɨ amɨ kurɨ kuramɨ ndɨmaahomwaaŋɨ asahatatɨ naaŋawisahurɨ bɨpi bitotamaise. ");
INSERT INTO agm_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Aihɨ kuramɨ wo komɨ ambɨpatɨ Kɨriyopaasiho satatɨ nunjenataise. “Kɨnyɨ wapɨhapɨhoŋɨ wanɨ Jerusaremɨhandaahapɨ nambɨhoŋɨtapaapɨ wanɨ batamɨ batɨhaaraahunɨ wanunɨ noaipasɨwɨmaiwaapɨ monɨpɨ gɨmunyaapɨhoŋɨtapaapɨno?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aihɨ ko saundataase. “Sandɨ akɨtɨndɨ napindɨ noaipasɨhandapɨse?” undataase. Aihɨ kuramɨha wihoaaŋɨha saundɨmɨ kaundamaase. “Nasaretɨhandaahapɨ Jisaasihomɨhetɨ saiwa siyatɨ nusoaipasɨhaiwaapɨto. So utaaso Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho pɨropetɨhopɨto. Iyataatɨ amɨ ko isɨhiyaamɨ ndɨhetunɨ amɨ Autaahaatɨhomɨ ndɨhetunɨ otɨpɨpatɨ watɨpɨhaiwa kiyatɨ amɨ pɨwɨha watɨpɨhaiwa ausaatɨ katahopɨto. ");
INSERT INTO agm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Aihɨ nyamɨ mɨtɨhiyaunɨ amɨ pɨrisihiya awaisawɨhiyaunɨ koai numwaapɨ gamanɨhomɨ ikwɨraatɨhɨmɨhauhɨ amɨ ko tipɨse undihɨ ipɨ tɨtɨhɨ atawɨhatetɨ nepɨ nimaapɨ sohoai tiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Iyataatɨ amɨ sopɨ Isɨraherɨhiyai maipɨhandaatɨhapɨ japɨhɨ numwaitandɨhoe taatɨ nyahɨ gwɨnyaahaayo. “Iyataatɨ amɨ pɨwɨha waisangi siyatɨ noaipatɨ namɨhaasɨhɨ asisɨha aimɨ yatairɨ sanotaise. ");
INSERT INTO agm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Iyataatɨ amɨ pɨwɨha waisangi siyate. Amɨ wanɨ asisɨmaatɨhɨ kohokoaisawɨ nyamɨ asɨhiya usa nuwɨ koai ahiyohɨpɨpɨhɨ mmonɨwɨmapɨ napɨwɨ nyangi kanyatauhɨ nyahɨ yayawaamɨhaayo. ");
INSERT INTO agm_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kiya nuwɨ mmonawa komɨ ambɨpatɨ wɨtɨ ahɨmotihɨ napɨwɨ sanyatawaatopo. “Nyahɨ Autaahaatɨhomɨ otɨpɨpatɨhiya yamɨhapataatɨhapɨhiyai usohonɨhɨ kiya sanyatawaatopo. ‘Kohɨ aimɨ asohoematatɨ japɨhɨ nepase,’ nyatawaatopo,” nyatɨwɨ kanyatawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aihɨ amɨ nyamɨ usa kapɨhɨ koai ahiyopɨpɨhɨ nuwɨ mmonawa tɨtɨhɨ asɨhiya katohɨmumwaaŋɨ kamwaaŋɨ mmonawaahandɨ kandɨ utaaho akohoai woai mausohopo,” undamaase. ");
INSERT INTO agm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aihɨ Jisaasiho komɨha kuri saundataase. “Sahuraahɨ wɨndɨ mmonɨmɨ apɨpaahɨ gɨmunyaapɨhuraahe. Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiya pɨwɨha katɨwɨ ahiyohɨhaapɨ sahuraahɨ tɨtɨhɨ akaahe tɨmɨ wɨndɨ baimɨ gɨmunyaase nehɨ nanɨhaimɨhuraahe. ");
INSERT INTO agm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kɨraisiho yaawɨhaiwa netɨ napotatɨ japɨhɨ nepatɨ ambɨpatɨ awaipatɨ nehonɨhɨ isɨhiya koai nepɨ Autaahaatɨhoaisawɨ ahoyawɨ mepɨ autaahepumaitaapo tatɨ pɨwɨha ahotisɨhaapɨ sahuraahɨ wɨndɨ gɨmunyaapɨhuraaho?” undataase. ");
INSERT INTO agm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Saundatosatɨ amɨ Mosesihomɨ pɨwɨhaapɨhapɨ namasatɨ kaundatɨ amɨ isɨhiya Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaamɨhaatɨhapunɨ ahoyatɨ ausaatɨ kurisɨ kaundataase. Autaahaatɨhomɨ pɨwɨhaatɨhɨ sawahopɨ saitaise tatɨ ahotiwaiwa nahatewa ausaatɨ tanyaaha kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Saiwɨ naiwɨ aunahɨpatɨ gwɨnyaapɨ niyohɨpata noaipaitaahetihɨ Jisaasiho kuri namasi nutandiyataise. ");
INSERT INTO agm_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nutandaihɨ kurɨ owe, “Namumwe ipɨho aimɨ namaatipasɨhɨ napwɨhataiso,” undihɨ namatɨ ko aŋaaŋɨ nandaatɨ maasɨ kurisatɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aihɨ ko nandapa nandandɨ kurisatɨ bindataise. Bindata nandapa bɨretɨhandɨ netɨ Autaahaatɨhoai, “Kɨnyɨ gaahoŋe gaare,” undatɨ naumbotɨ kurisɨ nunyataise. ");
INSERT INTO agm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Siyatɨ kurisɨ bɨretɨhandɨ nandapa naumbotɨ numwihɨ sura kuramɨ ndɨha nusorɨhaatihɨ Jisaasihoe tɨmɨ usonamaise. Aihɨ kohɨ kurisɨ namasisɨ kapɨhɨ ketɨ aimɨ wometihɨ mmomɨ japɨ namamaise. ");
INSERT INTO agm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aihɨ kurɨ sawahurɨ sanamaase. “Yahuraaŋɨ daihɨra taaha nasonɨhɨ ko Autaahaatɨhomɨ pɨwɨhaatɨhɨ ahotatɨ jɨpatɨpindiwaiwaapɨ tanyaaha nahata ausaatɨ biyatɨ nanyesɨpatɨ kanyatihɨ atisɨhaawɨ sura yahuraanyamɨ maarɨho waatɨ nyandotaise,” nnamaase. ");
INSERT INTO agm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aihɨ kurɨ sanɨmapɨ kuraanɨhɨ dosisaahɨ japɨhɨ Jerusaremɨhandaahapɨ nomaise. Numwɨ otɨpɨpatɨhiya ikwɨmaindɨmwɨtihɨ auhɨramɨ naasohɨtahiyaunɨ amɨ kiyaamɨ naisɨhiyaunɨ ahoyanɨwɨ maasɨ bimauhɨ winjamaise. ");
INSERT INTO agm_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aihɨ amɨ kiya kuri saundawaatopo. “Awaisɨho apɨpaahɨ akɨtɨnɨhɨ asohoematatɨ japɨhɨ nepase. Saimonɨho koai aimɨ usose,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aihɨ amɨ kurisangi kuraapɨhɨ daihɨra noaipasɨtɨhandapunɨ amɨ koai usosɨtɨhandapunɨ ausaapɨ nahataapa kiyaisɨ kaundamaase. Aimɨ amɨ kurɨ kiyai saundamaase. “Nandapa bɨretɨhandɨ ko naumbotɨ nanyamihɨ sura kore taha usonɨhaayo,” undamaase. ");
INSERT INTO agm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kurɨ kiyaisawɨ pɨwɨha taawɨ kanɨhauhɨ Jisaasiho sawaho kiyaamɨ otɨhapɨhɨ akohɨ noaipatɨ bitondaise. Bitonda kiyai saundataase. “Sahɨ samɨ maarɨho ambɨpatɨ wisaitatɨ napaisaatɨtane,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Aihɨ kiya kopɨ yaahohoai usonɨhaayo tɨwɨ waatɨ yaiwɨ itiwawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aihɨ amɨ ko kiyai saundataase. “Sahɨ sandɨ saiwɨ napaapɨ yaiwɨpwitopo? Aiwɨ amɨ samɨ maarɨho omaŋɨtɨtɨhapɨ napaapɨ mɨmaipaiwɨ kɨhaiwa kɨhaiwa gwɨnyaahopo? ");
INSERT INTO agm_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nɨnɨ kɨmɨkonɨnisɨ baiwɨ nisonɨwɨse. Nisɨ ikwɨrɨ auhɨrɨ nisonɨwɨ amɨ samɨ ikwɨraahɨ nipɨse. Yaahoya itɨpɨho maipɨhapa ambɨpatɨ andɨtatɨ nisatiyatɨ ahɨtahiyaamaahe. Owetise,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Saundatɨ kiyai komɨ ikwɨrɨ auhɨrɨ nunjataise. ");
INSERT INTO agm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Aihɨ kiya kopɨ waatɨ maaritawaahandɨ kandɨ kore tɨwɨ wɨndɨ baiwɨ gɨmunyaapɨ naharisauhɨ kiyaisɨ ko kɨmɨkonɨnɨ Jisaasihonɨne undatɨ nunjɨtandɨ kiyaisɨ saundataase. “Nandapa wapa ahiyawɨhiyaatɨtawaawaahɨ nepɨninyawɨse nandaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aihɨ kiya araiho tɨhɨwɨho posoho wihoaaŋɨho nunyawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nunyauhɨ ko netɨ kiyaamɨ ndɨhetɨ nainjɨhɨ kiya winjawaayopo. ");
INSERT INTO agm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iyatɨ ko kiyaisɨ saundataase. “Nɨnɨ jɨhura sangɨ napotɨ maasɨ sangisatɨ bimohura sandɨ kasato. Jɨhura nahataapa nisapɨ Mosesihomɨ pɨwɨhaatɨhunɨ amɨ Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaamɨ pɨwɨhaatɨhunɨ amɨ aunɨhɨhɨramɨ utɨpɨhoaatɨhunɨ katɨwɨ ahiyohɨwaiwa akɨwaiwematɨ katohɨmumwaaŋɨ kamwaaŋɨ noaipaitaise satɨtɨ kasato,” undataase. ");
INSERT INTO agm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Saundatɨ pɨwɨha jɨhura kopɨtatɨ ahotisɨhaapɨ kiyaisɨ biyatɨ uwinjapwaatɨ nusesɨpatɨ kaundihɨ kiyaisɨ Autaahaatɨhomɨ pɨwɨha katatɨ ahotisɨhaapɨ nusesɨpatataise. ");
INSERT INTO agm_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Iyatɨ amɨ kiyaisɨ statatɨ kaundataase. “Pɨwɨha sataha ahondaise. Kɨraisiho yaawahandɨ netɨ napotatɨ asisɨha mairɨmanya saniyonɨhɨ japɨhɨ asohoematatɨ nepaitaise. ");
INSERT INTO agm_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iyonɨhɨ komɨ ambɨpataahɨ pɨwɨha isɨhiya nahatiyai ausaapɨ kaundɨtaatɨwe. Kaundisaihɨ kiya atisawaawɨ kiyaamɨ maipɨhaiwa namasisɨ japɨhɨ nepemaitɨwɨ Autaahaatɨhoenda napisaihɨ Autaahaatɨho kiyaamɨ maipɨhaiwa nemwaitando. Isɨ satɨ Otɨpɨpatɨ sahɨ namasawɨ Jerusaremɨhandaahapɨ kaitaatɨwe. ");
INSERT INTO agm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nɨnɨ kiyonɨhɨ sahɨ mmonɨhohɨwɨmaiwa nahatewaapɨ ausaapɨ kaundɨwɨse. ");
INSERT INTO agm_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Atiwɨse. Apɨho sangisɨ nasamɨtandɨ jɨhura katatɨ ahaimbɨpa wanɨ nɨnɨ nɨwahonɨnɨ sangisɨ nasamɨto. Sahɨ wapɨhapɨ wɨndɨ namuwɨse. Owe. Kɨmbɨhɨ kɨmatɨ aunahɨmata bindawa jatɨwɨse. Jatɨmɨ nuwɨ yamɨhapataatɨhapɨ watɨpɨhandɨ nasatɨ samɨhetɨtanɨhɨ sura nutaatɨwo,” undatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ko katɨ aunahɨpatɨ awaipatɨ namɨhaamapɨ komɨ otɨpɨpatɨhiyai numwaasi notɨ Betaanihanda noaipatɨ Autaahaatɨho kiyaisɨ iwɨtatamanɨtandɨhandapɨ Autaahaatɨhopɨ gaapundataase. ");
INSERT INTO agm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Siyatɨ ko kiyaapɨ taatɨ gaapundatɨ Autaahaatɨhoai nunjenataahetɨ kiyaisɨ namasisaahɨ Autaahaatɨho numwaasi naihɨ yamɨhapataatɨhapɨ niyataise. ");
INSERT INTO agm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aihɨ kiya kopɨ gaapundɨwɨmapaahɨ apɨpaahɨ aungwohandɨ maaritɨmɨ japɨhɨ Jerusaremɨhandaahapɨ nowaayopo. ");
INSERT INTO agm_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Aihɨ kiya nasisoaarɨ Jerusaremɨhanda Autaahaatɨhomɨ aŋɨhandɨ awaindɨhandaatɨhɨ bindawa Autaahaatɨhopɨ waatɨ maaritɨwɨ mepɨ autaahepumawaayopo. ");
INSERT INTO agm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jɨhɨ aimehuraanɨhɨ kahapaamapɨpa sangɨ noaipasɨhura Pɨwɨha wa ahondaise. Iyataatɨ sa pɨwa Autaahaatɨhoaisatɨ maasɨ ahondaise. Iyataatɨ sa pɨwaisangi Autaahaatɨhore. ");
INSERT INTO agm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Iyataatɨ kɨmɨka Pɨwɨma Autaahaatɨhoaisatɨ maasɨ aimehura ahondaise. ");
INSERT INTO agm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iyataatɨ sa Pɨwaisɨ Autaahaatɨho netɨ isɨsi ketapɨ kaaraahɨ amɨ kaisatɨ maasɨ kahapaamapɨpa nahataapa Autaahaatɨho kiyatɨ ahiyataise. Iyataatɨ kahapaamapɨpa nahataapa Autaahaatɨho kiyatɨ ahaimbɨpa nehɨ Autaahaatɨho sawahohɨhɨ kiyataamaise. Owetise. Autaahaatɨho sa Pɨwai netɨ isɨsi kaisatɨ maasɨ kahapaamapɨpa nahataapa kiyatɨ ahiyataise. ");
INSERT INTO agm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iyataatɨ sa Pɨwa isɨhiya asɨyɨhiyaimatɨwɨ bimɨtaatɨwɨhandamɨ tanyaahaasɨ isɨhiya asɨtimatɨtaatɨwɨhandɨ pɨwa ketɨ ahondaise. Iyataatɨ sa Pɨwa isɨhiya asɨtimatɨtaatɨwɨhandisɨhaapɨhɨ amɨ nausainjɨtɨhandɨ ahondaise. Iyataatɨ sa Pɨwa Utaahoe. Isɨ amɨ ko nausainjɨtɨhandamatiyatɨ Autaahaatɨho siyatɨ setahoe tatɨ netɨ isɨhiyaisɨ gɨwunyaatɨ netɨ nunjatɨ gɨwunyaitandɨhoe. ");
INSERT INTO agm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Siyatɨ isɨhiya Autaahaatɨhopɨ wɨndɨ biyatɨ namusesɨpatatɨ gɨmaawunyaatahiyai netɨ biyatɨ gɨwunyaatɨ nusesɨpahonɨhɨ kopɨ mmondaatɨwɨ ko nausainjɨtɨhandamatiyatɨ nasataise. Siyatɨ nasatɨ nɨwusainjɨhandɨ kandɨ isɨhiya kopɨ wɨndɨ gɨmunyaapɨ monɨhopo. Siyauhɨhandɨ komɨ nausainjɨtɨhandɨ wɨndɨ namaayotatɨ kandɨnɨhɨ wapɨhɨ asɨhatimbɨpɨhɨ taatɨ nausaatataise. ");
INSERT INTO agm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Aihɨ utaaho wo komɨ ambɨpatɨ Jonɨhoai Autaahaatɨho komɨ pɨwɨha nunya nusoaasihɨ nasataise. ");
INSERT INTO agm_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iyatɨ nausainjɨtɨhandisaho nasatɨ isɨhiyai nusesɨpatɨ gɨwunyaitandɨhopɨha pɨwɨha ausaatɨ isɨhiyai kaundataase. Amɨ isɨhiya nahatiya pɨwɨha ka atisawaawɨ kopɨ baiwɨ gɨwunyaitaatɨwo. ");
INSERT INTO agm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iyataatɨ Jonɨho so isɨhiyai netɨ biyatɨ nunjatɨ gɨwunyaatɨ nusesɨpaitandɨ nausainjɨtɨhandisahomaahe. Owetise. Nausainjɨtɨhandisaho ipotɨ nasatɨ isɨhiyai netɨ biyatɨ nunjatɨ gɨwunyaatɨ nusesɨpaitandɨhopɨha pɨwɨha nehɨ jɨhɨ ausaitandɨ noaipahore. ");
INSERT INTO agm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iyataatɨ ko nausainjɨho akɨtɨ akohore. Akɨtɨ akohosɨ isɨhiya nahatiyai nga nɨwusainjɨhore. Iyataatɨ wanɨ ko yaho detɨ yapɨpataapɨhɨ taatɨ nasataise Autaahaatɨhopunɨ amɨ Autaahaatɨhomɨhaiwaapunɨ netɨ isɨhiya nahatiyai nunjatɨ gɨwunyaatɨ nusesɨpaitando. ");
INSERT INTO agm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iyataatɨ sa Pɨwa maapɨ yapɨpataapɨhɨ isɨhiyaamɨ otɨhatɨhɨ ahondaise. Iyataatɨ yapɨpatunɨ kahapaamapɨpaunɨ isɨhiyaunɨ saiwa Autaahaatɨho sa Pɨwaaraahɨ amɨ kaisatɨ maasɨ kiyatɨ ahiyataise. Saihɨhandɨ kandɨ isɨhiya komɨ kiyatɨ ahaisawɨhiya wɨndɨ mmonɨwɨ usɨtɨmaiwɨ amɨ wɨndɨ kopɨ baiwɨ gɨmaawunyaahopo. Owetise. ");
INSERT INTO agm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Iyataatɨ so komɨhatɨ yapɨpata tɨtɨhɨ komɨhiyenda napihɨhandɨ kandɨ komɨhiya koai wɨndɨ baiwɨ namumwaapɨ ahosumwawaayopo. ");
INSERT INTO agm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amɨ siyauhɨhandɨ kandɨ isɨhiya usa wowaatɨ koaisɨ wɨndɨ ahosumwaamapɨ kopɨ kiya satɨwɨ nyangi Japɨhɨ Nanyamaitandɨ Autaahaatɨho Ahɨwisɨhore tɨwɨ gɨwunyaapɨ koai numwaahohiyɨhiyai ko kaundihɨ kiya noaipapɨ tɨtɨhɨ Autaahaatɨhomɨ manyinyaimatawaayopo. Aiwɨ kiya mwaaya maatiyaimatawaayopo. ");
INSERT INTO agm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Iyataatɨ isɨhiya noaipapɨ Autaahaatɨhomɨ manyinyaimatohiyɨhiya saniya sapiyaamɨ ambɨpatɨ tɨmaamaipɨ maapɨ isɨhiya kiyohɨrɨhɨretɨ kaiwɨ nanohohɨtɨhandaahɨmaahe. Iyataatɨ isɨhiya sawanaamɨ watɨpɨhandɨ gwɨnyaahohɨtɨhandaahɨmaahe. Iyataatɨ amɨ nehɨ isɨhiyaamɨ gwɨnyaapɨ maaritohɨtɨhandaahɨmaahe. Owetise. Autaahaatɨho sawahomɨ watɨpɨhandaahɨ kiyaamɨ omaŋɨtɨtɨhɨ netɨ gɨwunyaatɨ nusepemaisɨhɨ kiya noaipapɨ komɨ mwaaya maatiya manyinyaimatawaayopo. ");
INSERT INTO agm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Iyataatɨ sa Pɨwɨha isɨhiyai netɨ Autaahaatɨhopɨ siyatɨ setahore tatɨ nunjɨtandɨ akɨtɨ akɨtɨnɨhɨ nehɨ utaahoematatɨ nasataise. Nasatɨ nyamɨhatɨhɨ bindataise. Bindataatɨ isɨhiyaanangi maarɨho apɨpaahɨ aungwohandɨ nanyinyatɨ gaahandɨ kanyisatɨ watɨpɨhaiwa kiyataise. Iyataatɨ ko sawahomɨhetapɨ Autaahaatɨhopɨ ko siyatɨ setahore tatɨ isɨhiyai netɨ nunjataise. Siyatɨ ko netɨ nanyɨsihɨ kometirɨhɨretapɨ komɨ gaahaiwa yundanyɨha otiwa kaumbwaatɨ awaindɨhandɨ nausainjɨtɨhandɨ nyahɨ mmonɨhaayo. ");
INSERT INTO agm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Aihɨ Jonɨho pɨwɨha ausaataatɨ Utaaso sopɨ satatɨ kandaase. “Utaaho sopɨ nɨnɨ jɨhura sandɨ kasatohɨhore. Utaaho nisɨ ipotɨ napisɨho so nɨngi nanɨtipɨhaatɨ apɨpaahɨ awaisɨhore. Nɨngi nanɨtipɨhaatɨ awaisɨhore tohɨtɨmandɨ apaapɨmaato nɨnɨ sangɨ noaipahonɨhura ko jɨhɨ aimehura bimainjahotihɨ kandapɨ kandaato,” tatɨ Jonɨho Jisaasihopɨ kandaase. ");
INSERT INTO agm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iyataatɨ Autaahaatɨho isɨhiyaapɨ kiya gaahapa wapa kamaiwɨ nehɨhandɨ koaisunyaatɨ apɨpaahɨ akɨtɨ akɨtɨnɨhɨ aungwohandɨ nasɨsoaarɨ maarɨho asɨpaindɨhandɨ Jisaasihoai nahandɨ kandɨnɨhɨ tisaahɨwatɨ numwihɨ komɨhetɨ tisaitatɨ ahondaise. Aihɨ nyangisɨ Jisaasiho apɨpaahɨ akɨtɨ akɨtɨnɨhɨ aungwohandɨ maarɨho asɨpinyisatɨ nanyinyataatɨ komɨ gaahaiwa pɨhɨtatɨ jinjɨhaatɨ tiwatɨ nyepiyatɨ nyangi nanyinyataise. ");
INSERT INTO agm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Iyataatɨ Autaahaatɨho komɨ wɨnɨhapɨpa Mosesihomɨhetapɨ Judaahiyaanangi nanyinyataise. Nanyamihɨ andɨtitaatɨ wɨndɨ nyahɨ minjapepihɨrɨhaayo. Aihɨ Jisasɨ Kɨraisihomɨhetapɨ Autaahaatɨho maarɨho nanyinyataise. Iyatɨ amɨ Jisaasihomɨhetapɨ nɨnɨ kɨmetahonɨne tatɨ Autaahaatɨho netɨ nyangi nanyisataise. ");
INSERT INTO agm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Iyataatɨ utaaho wo Autaahaatɨhoai apɨpaahɨ maipɨhonjisangi wɨndɨ mausose. Owetise. Autaahaatɨhomɨ Mwaaho Jisaasiho Autaahaatɨhoaisatɨ maasɨ bimainjatɨ napisɨhohɨhɨ amɨ sawaho Autaahaatɨhosɨ Autaahaatɨhopɨ ko siyatɨ setahoe tatɨ ausaatɨ nyangi kanyatatɨ nanyisataise. ");
INSERT INTO agm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Aihɨ Judaahiyaamɨ awaisawɨhiya pɨrisihiya isɨhiyaapɨ nandapa tɨhɨwɨ Autaahaatɨhoai dɨpumanɨwɨ nunyohiyɨhiyaisunɨ amɨ isɨhiya usa Ripaihiya Autaahaatɨhomɨ Aŋɨ Awaindɨhandaatɨhɨ otɨpɨpatɨ nehɨhatɨ kiyohiyɨhiyaisunɨ natɨwusaasauhɨ aunahɨpatɨ Jerusaremɨhanda namasi nasawaayopo. Napɨwɨ Jonɨhoai saundɨwɨ, “kɨnyɨ diyaamahoŋe?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Saundɨwɨ nunjenɨhauhɨ Jonɨho wɨndɨ kiyai apɨhɨmundataamaase. Owetise. Tɨtɨhɨ biyatɨ ausaatɨ kiyai saundataase. “Isɨhiyaisɨ Japɨhɨ Numwaitandɨ Autaahaatɨho Ahɨwisohonɨnɨmaahe. Owetise,” Undataase. ");
INSERT INTO agm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aihɨ kiya koai kaundawaatopo. “O kiyonaahɨ kɨnyɨ diyaamahoŋe? Kɨnyɨ Eraijaahopɨ napɨtaise tohɨhoŋo?” undɨwɨ nunjenawaayopo. Nunjenɨhauhɨ Jonɨho kiyai saundataase. “Nɨnɨ Eraijaahonɨnɨmaahe. Owetise,” undataase. Saundihɨ amɨ kiyaamɨha wa jɨhaatɨ satɨwɨ koai nunjenawaayopo. “Pɨwɨha atisatɨ netɨ awaisɨhopɨ ausaitandɨho napɨtaise tauhɨ jaawaatɨ bindɨhaayonɨ kɨnyɨ koŋo?” undawaatopo. Saundauhɨ Jonɨho wihoaaŋɨha kiyai saundataase. “Nɨnɨ konɨnɨmaahe. Owetise,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Saundihɨ kiya jɨhaatɨ Jonɨhoai satɨwɨ kaundawaatopo “Isɨhiya kinyapɨ nyangi natɨwinyoaasauhɨ nasawaahiyaanɨne. Isɨ nyahɨ kiyai kaundɨtɨhaaha kanyate. Kɨnyɨ kɨwahonyapɨ sɨsaindɨhonɨne tɨpɨ kanyate. Kanyatisamɨhɨ japɨhɨ nowaatɨ isɨhiya nyangi natɨwɨnyoaasohiyɨhiyai kɨnyɨ kanyatisamɨha kaundɨtaano,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Aihɨ Jonɨho kiyai saundataase “Jɨhura Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho Aisaiyaaho satatɨ katisɨhonɨne: ‘Yapɨpatɨ isɨhiya iwɨwɨrɨho owehata utaaho wo bindataatɨ sandaase. Awaisɨho wanɨ napɨtandaisɨ sahɨ nepemaitɨwɨ samɨ maipɨhaiwa namapɨ samɨ maarɨho omaŋɨtɨtɨhɨ nepɨ tɨmaŋɨnɨwɨse,’ tatɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaasɨho Aisaiyaaho katisɨhonɨne,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Iyataatɨ Isɨhiya Jonɨhoai nunjenohiyɨhiya siya Parisihiya natɨwusaasauhɨ napɨwɨhiyaare. ");
INSERT INTO agm_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Parisihiya natɨwusaasauhɨ napɨwɨhiyaasɨ kiya Jonɨhoai saundawaapo. “Kɨnyɨ Kɨraisihoŋɨmaahe. Iyataatɨ amɨ kɨnyɨ Eraijaahoŋɨmaahe. Iyataatɨ amɨ kɨnyɨ Autaahaatɨhomɨ pɨwɨha atimbɨ nepɨ ausaitaapɨhoŋɨmaahe. Isɨ gisɨ ndɨ kahɨtihɨ isɨhiyaisɨ waapohora baawusapaise?” undɨwɨ nunjenawaayopo. ");
INSERT INTO agm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Saundɨwɨ nunjenɨhauhɨ Jonɨho wihoaaŋɨha kiyai saundataase. “Utaaho wo yaho samɨ otɨhatɨhɨ bitondaise. Ko nisɨ ipotɨ otɨpɨpatɨ namasatɨ apɨpaahɨ awaipatɨ nɨnɨ kiyohɨpati nusatipɨhaahatɨ kaitaise. Iyataatɨ sopɨ isɨhiyaisɨ japɨhɨ numwaitandɨ Autaahaatɨho Awaisɨhoe tɨwɨ sahɨ wɨndɨ mmonɨwɨ gɨmunyaahopo. Iyataatɨ utaaho so nɨngi nanɨtipɨhaaho awaisɨhore. Iyataatɨ nɨnɨ awaisɨhonɨnɨndaahandɨ kandɨ nehɨhonɨne. Nehɨhonɨnisɨ otɨpɨpatɨhiya awaisawɨhiya kiyaamɨ awaisawɨhiya kiyai nusatipɨhaapɨ apɨpaahɨ awaisawɨhiyaamɨ otɨpɨpatɨ kiyohɨwaiwa kaindɨ komɨ asuipatamɨ wɨrɨhɨrɨ nausohaumwaamaito. Isɨ ko awaisɨho nisɨ ipotɨ otɨpɨpatɨ namasatɨ kaitaise. Aihɨ nɨnɨ ko otɨpɨpatɨ kaitandɨhandapɨ jɨhɨ turɨmanɨtɨ isɨhiyai waapohora baawusataayo,” tatɨ Jonɨho kiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iyataatɨ aunahɨpatɨ Betanihanda waapɨhaatɨ Jorɨtanɨhaatamɨ wihɨnɨ detɨ opaininɨ Jonɨho isɨhiyai baawusihɨ saiwa noaipataise. ");
INSERT INTO agm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Aihɨ bowihɨ Jisaasiho napihɨ Jonɨho koai iwinjatosatɨ sandaase. “Utaaho kɨmoaisɨ iwinjapɨse. Utaaho so Autaahaatɨhomɨ Sipɨsipɨhandɨ Mwaahomatiyahore. Iyataatɨ ko isɨhiya nahatiya yapɨpatambɨhiyaamɨ maipɨhaiwa nemwaitandɨ napwɨtandɨhore. ");
INSERT INTO agm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iyataatɨ utaaso sopɨ nɨnɨ jɨhura sandɨ kasatohɨhore. Utaaho wo nɨngi nanɨtipɨhaaho apɨpaahɨ awaisɨhore. Isɨ ko otɨpɨpatɨ nisɨ ipotɨ namasatɨ kaitaise. Iyataatɨ nɨngi nanɨtipɨhaatɨ awaisɨhore tohɨtɨmandɨ apaapɨmaato nɨnɨ sangɨ noaipahonɨhura ko jɨhɨ aimehura bimainjahore ndɨ kasatohɨho kɨmɨ kopɨsato. ");
INSERT INTO agm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Iyataatɨ nɨnɨ nɨwahonɨnɨsangi kopɨ kore ndɨ tɨtɨhɨ wɨndɨ baindɨ mmonɨtɨ gɨmunyaataahandɨ kandɨ isɨhiyaisɨ waapohora baawusataayo. Iyataatɨ sandɨ nɨnɨ isɨhiyaisɨ baawusohɨtɨmandɨ Isɨraherɨhiyai kopɨ nunjɨtandɨ nɨnɨ baawusataayo,” ndaase. ");
INSERT INTO agm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Aihɨ amɨ Jonɨho sandaase. “Nisangi Kɨraisihopɨ Isɨhiyai Japɨhɨ Numwaitandɨ Autaahaatɨho Ahɨwisɨhoe ndɨ wɨndɨ monɨtɨhonɨne. Monɨtɨhonɨnɨtihɨhandɨ kandɨ nehɨ waapohora isɨhiyaisɨ baawusɨtandɨ Autaahaatɨho netɨ natanoaasataise. Iyataatɨ Autaahaatɨho nɨngi natanoaasihɨ nasohɨho nɨngi sata kandataase. ‘Itɨpɨho utaaho womɨhasɨnɨ nasatɨ bimonɨhɨ kɨnyɨ iwinjaitaise. Isɨ utaaso so komɨhasɨnɨ Itɨpɨho bimiso isɨhiyai Itɨpɨho waatɨ tisaahɨwatɨ numwɨtandɨhore’ ndatɨ Autaahaatɨho nɨngi kandataase. ");
INSERT INTO agm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aihɨ nɨnɨ saindɨ iwinjatɨ mmonataatɨ Jisaasihopɨ Autaahaatɨhomɨ Mwaahore ndɨ ausaatɨ nɨnɨ sangi kasatataato,” tatɨ Jonɨho kandaase. ");
INSERT INTO agm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Bowihɨ Jonɨho komɨ otɨpɨpatɨhurɨ nehɨ yahurisatɨ bitondaise. ");
INSERT INTO agm_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bitosɨhɨ Jisaasiho taatɨ napihɨ Jonɨho iwinjataise. Iwinjatosatɨ komɨ otɨpɨpatɨhuri saundataase “Kɨmoai sɨhoaahɨ iwinjapɨse. Autaahaatɨhomɨ Sipɨsipɨhandɨ Mwaahomatiyahore,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jonɨho komɨ otɨpɨpatɨhuri saundihɨ kurɨ atimɨmapɨ Jisaasihoai nuwipinjai nomaise. ");
INSERT INTO agm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nuwipinjai naihɨ Jisaasiho nepemaitatɨ usonata kurɨ taamɨ nuwipinjai naihɨ sata nunjenataise. “Sahuraahɨ napindape?” undatɨ nunjenataise. Aihɨ kurɨ wihoaaŋɨha saundamaase. “Rabaihoŋe, (Katɨpunjingɨhoŋe) kɨnyɨ maahɨwapɨhɨ bindapaahoŋe?” undɨmɨ nunjenamaise. Iyataatɨ pɨwɨha sa Rabaihoŋe undisɨmaamɨ tanyaaha pɨwɨha Ipɨruha amɨ Aramaikɨhaara Katɨpunjingɨhoŋe undamaase. ");
INSERT INTO agm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aihɨ ko Jisaasiho kuri saundataase “Sahuraahɨ namɨ nisɨ bimohɨpɨpɨhɨ mmonɨmise,” undataase. Aihɨ kurɨ numwɨ ko bimimbɨpɨhɨ mmonamaise. Iyataatɨ sura ipɨho aimɨ yaataatiwatɨ 4 kirokɨhura asɨhataahuraatihɨsɨ namapɨ kapɨhɨ koaisamɨ maasɨ bindamaise. ");
INSERT INTO agm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jonɨho Jisaasihopɨ pɨwɨha katihɨ atɨwimɨmapɨ Jisaasihoai nuwipinjai maasɨ naisururamɨ wo Saimonɨ Pitaahomɨ saingɨho Andɨruhoe. ");
INSERT INTO agm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Aihɨ Andɨruho ketɨ notɨ komɨ saaho Saimonɨhoai saundataase: “Isɨhiyai Japɨhɨ Numwaitandɨ Autaahaatɨho Ahɨwisɨho Kɨraisihoai nyahɨ aimɨ usonɨhaayo,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aimɨ usonɨhaayo undatɨ Andɨruho komɨ saahoai numwaasi niyatɨ Jisaasihoaapɨhɨ noaipataise. Noaipasɨhɨ Jisaasiho koai usonataatɨ saundataase “Kɨnyɨ Saimonɨhoŋe, Jonɨhomɨ mwaahoŋɨ. Isɨ kinyɨ ambɨpatɨ wanɨ Sipaasihoŋɨtɨtaape,” undataase. Iyataatɨ Sipaasitotɨmandɨ Pita tawaatopo. Pita totɨmandɨ Nawɨhaaraŋe tawaatopo. ");
INSERT INTO agm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Aihɨ bowihɨ Jisaasiho yapɨpatɨ Garirihandaahapɨ naitandɨ taatɨ tɨmanɨnataatɨ Piripɨhoai iwinjataise. Iwinjatɨ koai saundataase, “Kɨnyɨ nambɨ nɨngi nanipinje,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Iyataatɨ Piripɨho so aunahɨpatɨ Betesaitaahandaahapɨhore. Iyataatɨ amɨ Betesaitaahandɨ sandɨ Pitaayɨ Andɨruyaamɨ aunahɨpatɨ bimipate. ");
INSERT INTO agm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Aihɨ Piripɨho niyatɨ Natanairɨhoai usonataatɨ saundataase. “Utaaho wopɨ napɨtaise tɨwɨ jɨhura Mosesihounɨ amɨ Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaunɨ katɨwɨ jɨpatɨpaiwɨ ahiyohɨhoai aimɨ nyahɨ usonɨhaayo. Iyataatɨ ko Josepɨhomɨ mwaaho Nasaretɨhandaahapɨhore. Iyataatɨ komɨ ambɨpatɨ Jisaasihoe,” undaataase. ");
INSERT INTO agm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aihɨ Natanairɨhomɨha Piripɨhoai saundataase. “O amɨ Nasaretɨhandaahapɨ wɨndɨ gaahandɨ noaipaitaihɨno?” undataase. Saundihɨ Piripɨho Natanairɨhoai saundataase “Gi ipɨpɨhɨ mmondaapɨ namme,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Aihɨ kurɨ numwɨ noaipasɨhɨ Jisaasiho Natanairɨhoai usonata sandaase. “Kɨmo utaamo Autaahaatɨhopɨ biyatɨ gɨwunyaasɨtɨhandaahɨ tɨtɨhɨ Isɨraherɨhore. Iyataatɨ ko jaiwɨtɨtandɨhandɨ owehore,” daase. ");
INSERT INTO agm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Aihɨ Natanairɨho Jisaasihoai saundataase. “Kɨnyɨ nisɨ omaŋɨtɨtɨhɨ napitaimbɨ nisonapaapɨse?” undataase. Aihɨ Jisaasiho komɨha wihoaaŋɨha Natanairɨhoai saundataase. “Jɨhɨ Piripɨho sangɨ notɨ pɨwɨha kahɨtihɨhura kɨnyɨ kaanɨhɨ ipatamɨ tambɨpɨhɨ biminɨhɨ nɨnɨ gisonɨho,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Undihɨ Natanairɨho Jisaasihoai saundataase. “Katɨpunjingɨhonye, kɨnyɨ akɨtɨnɨhɨ tɨtɨhɨ katapaase. Kɨnyɨ Autaahaatɨhomɨ Mwaahoŋɨ Isɨraherɨhiyaanamɨ Awaisɨhoŋe, nyangi nyainjaapɨ bimingɨhoŋo,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Aihɨ Jisaasiho wihoaaŋɨha Natanairɨhoai saundataase. “Nɨnɨ gisɨ ipatamɨ tambɨpɨhɨ kaanɨhɨ biminɨhɨ gisonɨho tohɨtɨmandapɨ kɨnyɨ nisapɨ Autaahaatɨhomɨ Mwaahoe tɨpɨ gɨnunyaapaino? O amɨ ipotɨhura sandi nusatipɨhaahaiwa awaiwaiwa kaisanɨhɨ noaipahonɨhɨ mmondaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sa koai saundatosatɨ kiyai wa saundataase. “Nɨnɨ akɨtɨnɨhɨ sangi kɨmandɨ kasatataato, ipotɨhura yamɨhapatɨ tɨwɨtawamahonɨhɨ Autaahaatɨhomɨ enjerɨhiya otɨpɨpatɨhiya yamɨhapataatɨhapɨhiya Nɨnɨ Isɨhiyaamɨ Saahonɨnɨ Jɨhonɨnɨ Awaisɨhonisaapɨhɨ noaatɨpapɨ amɨ nasaamasaihɨ sahɨ usondaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Aihɨ asisɨha aimɨ yatairɨ sanaihɨ kasɨnɨhetɨ Jisaasihounɨ komɨ otɨpɨpatɨhiyaanunɨ yapɨpatɨ Pɨropinjɨhandɨ Garirihanda noaipahaayo. Aihɨ asisɨha setɨ yapɨpatɨ Pɨropinjɨhandɨ Garirihandamɨ aunahɨpatɨ Kenaahanda utaaho wo apopaatɨ netɨ wɨraitandɨ nandapa netɨ tɨmanataise. Aihɨ Jisaasihomɨ sanaatɨ kura niyatɨ kapɨhɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Aihɨ utaaho netɨ apopaati wɨraitandura Jisaasihounɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnunɨ utaaho apopaatɨ netɨ wɨrahonɨhɨ iwinjaitɨhaawɨ gaatauhɨ niyahaayo. ");
INSERT INTO agm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Aihɨ waapoho wainɨhandɨ isɨhiyai nunyawɨ owetihɨ Jisaasihomɨ sanaatɨ Jisaasihoai saundataase. “Waapoho wainɨhandɨ kandɨnɨhɨ nunyauhɨ wɨndɨ ahɨmotatɨ kandɨnɨhɨ owendaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Saundihɨ Jisaasiho sanaati saundataase, “Apopaanye, nɨngi saime saime dɨtaapɨ kɨnyɨhandɨmaahe. Nisɨhande. Apɨho Autaahaatɨho kandonɨhɨ nɨnɨ noaipatɨ Awaisɨhonɨnimatɨtandɨhura sange,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aihɨ Jisaasihomɨ sanaatɨ isɨhiya otɨpɨpatɨhiya kapɨhapɨhiyai saundataase. “Nisɨ maasɨhɨho Jisaasiho sangi wapaapɨ saiwɨ sapa kaiwɨse satonaaraahɨ sahɨ atiwɨ kaiwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aihɨ kapɨhɨ onaahaiwa nawɨhaara kaiwɨhaiwa ikwɨwihɨtɨrɨtihɨ wihɨnɨhɨramɨ naasohɨtɨhaiwa ahondaise. Iyataatɨ saiwa onaiwa Judaahiyaanamɨ wɨnɨhapɨpetɨ japepihɨrɨwɨ ikwauhɨrunɨ kahapaamapɨpaunɨ bausanɨwɨ bausɨtaatɨwɨhaiwe. Iyataatɨ saiwa onaiwa waapoho waatɨ pɨhɨtatɨ windɨtandɨhaiwa apɨpaahɨ aungwohaiwaare. ");
INSERT INTO agm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Aihɨ saiwa onaiwopɨ waapoho nipɨ nepɨ tisaipɨ nuhaitaatɨwɨ otɨpɨpatɨhiya kapɨhapɨhiyai Jisaasiho kaundataase. Kaundihɨ kiya waapoho nipɨ nepɨ nuhaahauhɨ kaiwa onaahaiwa nahatewa tisaitataise. ");
INSERT INTO agm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Aihɨ Jisaasiho otɨpɨpatɨhiya waapoho nipɨ nepɨ nuhaahohiyɨhiyai saundataase. “Nɨnɨ kasatonɨhɨ waapoho nipɨ nepɨ nuhaahauhɨ tisaitisɨmomɨ nuhaapɨ wanɨ isɨsi naiwɨ utaaho nandapa tɨhauhɨ jaatɨ bimisɨhoai nunyawɨse,” undataase. Aihɨ kiya komɨ pɨwɨha atiwɨ nuhaapɨ isɨsi naiwɨ awaisɨho koai nunyawaayopo. ");
INSERT INTO agm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nunyauhɨ ko nandapa tɨhohɨtɨhandɨ jaatɨ bimisɨho waapoho so noaipatɨ tɨtɨhɨ wainɨhandimatisɨho netɨ nanatɨ mmonataise. Iyataatɨ ko waapoho wainɨhandɨ sandapɨ maahapɨhapɨ nesi napɨwɨhoe tatɨ wɨndɨ gɨmunyaase. O amɨ otɨpɨpatɨhiya Jisaasiho kaundihɨ waapoho nipɨ nepɨ nuhaahohiyɨhiyaahɨ sandapɨ gwɨnyaapɨhiyaare. Aihɨ nandapa tɨhohɨtɨhandɨ jaatɨ bimisɨho netɨ nanatɨ mmonata waapoho wainɨhandɨ apɨpaahɨ gaahandɨtihɨ namatɨ apopaatɨ netɨ wɨraitandɨhoai gaatatɨ numwaataise. ");
INSERT INTO agm_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Gaatatɨ numwaatɨ saundataase. “Usɨpɨpaapɨhura wainɨhandɨ waapoho gaaho biyatɨ jɨpaisɨho jɨhɨ isɨhiyai nunyauhɨ kiya waatɨ nanɨhauhɨ ipotɨ waapoho wainɨhandɨ gotɨ wonjɨ jɨpiyahandɨ nunyawaayopo isɨhiya nanawaawɨ waapoho kɨmo jɨpiyahoe jɨmaayahoe maatɨwɨ kiyaamɨ amɨtɨha aimɨ naharimainjɨhandisɨ nehɨ nanɨhaiwɨ nandaatɨwo. Siyatisɨ kɨnyɨ kɨretɨ saimbɨ kamaimbɨ gaaho waapoho ipɨhatimbosapapɨ wanɨ kɨmura kɨnyɨ gaahatɨ kaimbɨ otɨpɨpatɨhiyai nunyapusoaasapaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iyataatɨ sandɨ watɨpɨhandɨ Jisaasiho kaihɨ noaipasɨtɨmandɨ yapɨpatɨ Pɨropinjɨhandɨ Garirihandamɨ aunahɨpatɨ taunɨhandɨ Kenaahanda wuwanɨnɨhɨ watɨpɨhandɨ jɨhapɨhandɨ namasatɨ kiyataise. Iyataatɨ sandɨ Autaahaatɨhomɨ watɨpɨhandɨ kiyatɨ satatɨ, “Nɨnɨ Autaahaatɨhonɨne,” tatɨ kiyai nunjataise. Siyatɨ kaihɨ komɨ otɨpɨpatɨhiyaanɨnɨ sandɨ komɨ wandɨha watɨpɨhandɨ mmonɨhaawɨ, “Autaahaatɨhomɨ Mwaaho Akohore,” taatɨ kopɨ nyahɨ gɨwunyaahaayo. ");
INSERT INTO agm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Utaaho apopaati netɨ wɨrasɨhɨ nandapa tɨhohɨtɨhandɨ aimɨ owetihɨ Jisaasihounɨ komɨ sanaatunɨ komɨ saingoyaunɨ komɨ otɨpɨpatɨhiyaanunɨ kapɨhɨ namasi aunahɨpa Kapaniyaamɨhandaahapɨ nohaayo. Nowaatɨ asisɨha wanya bindɨhaayo. ");
INSERT INTO agm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Bimainjaatɨ Judaahiyaanamɨ kimbapɨho Pasopaahandɨ asisɨha awaisɨha noaipaitandɨhura aimɨ detɨtihɨ Jisaasihounɨ nyahɨ komɨ otɨtpɨpatɨhiyaanɨnunɨ kapɨhɨ namasi Jerusaremɨhandaahapɨ niyahaayo. Iyataatɨ asisɨha sa jɨhura Isɨraherɨhiyaamɨ aŋaaŋamɨ maasomwaaŋɨ jɨtɨpatɨ jandihɨ mmonataatɨ Autaahaatɨho namatɨ Isɨraherɨhiyaamɨ manyinyai tɨmaawatɨ Isipɨhiyaamɨ manyinya jɨhɨ bwandɨpɨhiyai tiwɨtandɨ notaatɨ nehɨ nusatipatɨ naindɨhandapɨ gwɨnyaapɨ namɨhanɨwɨ mmonɨhohɨhaare. ");
INSERT INTO agm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aihɨ Jisaasihounɨ nyahɨ komɨ otɨpɨpatɨhiyaanunɨ maasɨ Autaahaatɨhomɨ aŋɨ awaindɨhandaatɨhapɨ niyahaayo. Niyaatɨ Jisaasiho mmonata mɨhatɨhɨ isɨhiya bindawa taawɨ sipɨsipɨho kauho amɨ koho nunyawɨ nawɨho nehohiyɨhiyaisunɨ amɨ isɨhiya usa nawɨho Judaahiyaamɨ (Aŋɨ Awaindɨhandamɨ) nawɨhoetemapɨ nunyawɨ nehohiyɨhiyaisunɨ usonataise. ");
INSERT INTO agm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Usonatosatɨ wɨrɨhɨrɨ taahɨwaiwa netɨ tɨmaamahɨwatɨ pɨpɨtɨpiyatɨ isɨwatata kɨraahɨ isɨhiya nahatiyaisunɨ amɨ kohasɨpɨ sipɨsipɨhandisunɨ amɨ kauho sapai tahamanatɨ mɨhaapɨ nehɨhaatɨmataise. Iyatɨ isɨhiya nawɨho Judaahiyaamɨ nunyawɨ nehohiyɨhiyaamɨ ganɨho netɨ nepuhotɨ kiyaamɨ nawɨho netɨ kɨpwɨratɨ mɨhopɨ mɨhinɨ yondaise. ");
INSERT INTO agm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Iyatɨ isɨhiya koho nunyawɨ nehohiyɨhiyai saundataase. “Sahɨ koho kɨmo nesi nehɨhaatɨ nuwɨse. Nisɨ Apɨhomɨ aŋaaŋɨ kahapaamapɨpa nunyawɨ naitaatɨwɨhaaŋamataiwɨ sahɨ kamaiwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iyataatɨ pɨwɨha wa jɨhura satɨwɨ jɨpatɨpaiwɨ ahiyawaayopo: “Nɨnɨ kinyɨ aŋaaŋɨ nopɨsasinjaaŋaaŋɨ netɨ japɨhɨ itatamanɨtɨ baindɨ tɨtɨhemaitandɨhandapɨ maarɨho nanɨtɨmasɨtɨhandɨ isɨhiya nɨngi yaasɨhandɨ naninyawaayopo,” tatɨ ahotisɨhaapɨ amɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ gwɨnyapenahaayo. ");
INSERT INTO agm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Aihɨ Judaahiyaamɨ awaisawɨhiya sandɨ Jisaasiho kaindɨhandɨ mmonawaawɨ koai waapɨhundɨwɨ saundawaatopo. “Kinyapɨ ko isɨhiyai aŋɨ awaindɨhandaahapɨ tahamanatɨ nehɨhaatemaitandɨho Autaahaatɨho ahɨwihɨ kiyataisɨ awaisɨhoe taatɨ gwɨnyaitaanɨ sɨwipatɨ watɨpɨhatɨ wɨtɨ wanɨ kɨmɨkura kɨnyɨ kaimono?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Aihɨ Jisaasiho komɨha wihoaagɨha kiyai saundataase. “Kɨmandɨ aŋɨ awaindɨmandɨ sahɨ nepɨ nopɨsasisaihaahɨ nɨnɨ netɨ asisɨha mairɨ metɨ japɨhɨ aŋɨmatɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aihɨ Judaahiyaamɨ awaisawɨhiya Jisaasihoai saundawaatopo. “Nyamɨ asoya kɨmandɨ aŋɨ awaindɨmandɨ aŋɨmatawaasauhɨ kɨnaungwɨha pɨhɨtatɨ 46 kiyatɨ sanausohaaŋɨsɨ kɨnyɨ ketɨ asisɨha mairɨ metɨ nga aŋɨmatɨtaano tapanno?” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisaasiho sandɨ aŋɨ awaindɨmandapɨ kaundindɨmandɨ tɨtɨhɨ aŋɨ awaindɨhandapɨ kaundataamaase. Owetise. Komɨ ambɨpatapɨ nepemaahɨwatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Aihɨ ipotɨhura Jisaasiho napwihɨ asisɨha mairɨ ma sanaihɨ Autaahaatɨho japɨhɨ ahowimatɨ numwaasɨhɨ nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ ko pɨwɨha katisɨhaapɨ akɨte taatɨ gwɨnyaawa mmonɨhaayo. Iyaatɨ amɨ komɨ otɨpɨpatɨhiyaanɨnɨ Jisaasihopɨ saitaise saitaise tɨwɨ jɨhura jɨpatɨpaiwɨ ahiyohɨwaiwaunɨ Jisaasiho sawaho pɨwɨha sa katihɨ atisohɨhaunɨ tɨtɨhɨ akɨtɨhandɨ noaipasɨhɨ nyahɨ mmonahaawɨ tɨtɨhɨ akɨte taatɨ gwɨnyaahaayo. ");
INSERT INTO agm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Aihɨ asisɨha Judaahiyaanamɨ awaisɨha jɨhura Autaahaatɨho Isipɨhiyaamɨ manyinyai tiwɨtandɨ notaatɨ Isɨraherɨhiyai nehɨ Nusatipa Naindɨhandapɨ namɨhanɨwɨ mmonɨhohɨhetɨ Jisaasiho Jerusaremɨhanda bindataise. Bindataatɨ Autaahaatɨhomɨ watɨpɨhandaahɨ watɨpɨhaiwa kaihɨ isɨhiya mmonawaayopo. Mmonawaawɨ Jisaasiho watɨpɨhandɨ kaindɨhandapɨ kopɨ gɨwunyaawaayopo. ");
INSERT INTO agm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Aihɨ kiyai Jisaasiho usonataatɨ nisapɨ akɨtɨnɨhɨ gɨnunyaawaamaayopo tatɨ usonataise. Sandɨ apaapɨmaahe amɨ kiyaamɨ omaŋɨtɨtɨhɨ aimɨ usonataate. Iyataatɨ sandapɨ ko kiyai nehɨ wɨndɨ maawinjase kiya koai nepɨ awaisɨhoemaitaatɨwo. ");
INSERT INTO agm_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Iyataatɨ isɨhiya usa Jisaasihoai isɨhiyaapɨ siya saiwɨ saiwɨ kiyaamɨ omaŋɨtɨtɨhɨ gwɨnyaapɨhiye undɨwɨ kaundɨtaatɨwɨhiya owetise. Nehɨ sawaho isɨhiyaamɨ gwɨnyaahohɨtɨhandɨ aimɨ ketɨ mmonahore. ");
INSERT INTO agm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Utaaho wo komɨ ambɨpatɨ Nikodimaasiho bindataise. Iyataatɨ so utaaso Judaahiyaamɨ awaisɨhore. Iyataatɨ amɨ ko Parisihore. ");
INSERT INTO agm_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Isɨ ko waara apatɨhɨ Jisaasihoaapɨhɨ notɨ noaipataise. Noaipatɨ Jisaasihoai saundataase. “Katɨpunjingɨhonye, Autaahaatɨho gi natasoaasihɨ kɨnyɨ isɨhiyai katɨpunjɨtaapɨhoŋimatɨpɨ nasapaise. Aihɨ nyahɨ sandapɨ aimɨ gwɨnyaahaayo. Iyataatɨ Autaahaatɨho utaaho woaisɨ watɨpɨhandɨ nunyatɨ koaisɨ andɨtɨmaawihonaahɨ wanɨ kɨnyɨ watɨpɨmaiwa kaingɨwɨmaiwaamatiyahaiwa ko wɨndɨ kamaitaise” undataase. ");
INSERT INTO agm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Saundatɨ kaundihɨ Jisaasiho wihoaaŋɨha koai saundataase. “Nɨnɨ apɨpaahɨ akɨtɨnɨhɨ gi sandɨ kahɨtataato, utaaho wo akɨtɨnɨhɨ japɨhɨ nepemaitatɨ wanɨhoemaamatataataahɨ Autaahaatɨho koai wɨndɨ winjaatɨ bɨmimɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Saundatɨ kaundihɨ Nikodimaasiho komɨha jɨhaatɨ Jisaasihoai saundataase. “Utaaho aimɨ gwɨnyanatɨ awaisɨhotaho napitiyatɨ japɨhɨ noaipatɨ sangɨho wanɨhoematɨtaise? Iyataatɨ utaaho aimɨ gwɨnyana awaisɨhotaho ko japɨhɨ sanaatamɨ gwɨsɨhaatɨhɨ notɨ kɨpwɨnɨhonɨhɨ sanaatɨ japɨhɨ koai wɨndɨ namotɨmaawitaise. Owetɨtaise,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Aihɨ Jisaasiho komɨha koai saundataase. “Nɨnɨ apɨpaahɨ akɨtɨnɨhɨ sandɨ gi kahɨtataato. Utaaho wo waapohoraahunɨ amɨ Itɨpɨhoraahunɨ noaipatɨ asoho wanɨhoemaamatataataahɨ Autaahaatɨho komɨ isɨhiyai winjaatɨ bimindɨtɨhɨ ko wɨndɨ monatɨ katɨhɨ namandaitaise hɨtɨtɨ nɨnɨ gi kahɨtataato. ");
INSERT INTO agm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Iyataatɨ tɨtɨhɨ isɨhiyai isɨhiya namuwaisaihɨ amɨ kiya tɨtɨhɨ saniya sapiya namwiyohiyɨhiya siya noaipapɨ tɨtɨhɨ isɨhiyaamɨ ambɨpatɨ maapɨ yapɨpatambɨhatɨ newaayopo. Iyataatɨ Autaahaatɨhomɨ Itɨpɨho netɨ namoyaatɨ amɨ nusepemaisawɨhiya siya tɨtɨhɨ Autaahaatɨhomɨ manyinya isɨhiyaimatawaayopo. ");
INSERT INTO agm_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Isɨ nɨnɨ gi sandɨ kahɨtataato, Autaahaatɨhomɨ Itɨpɨhoraahɨ sangi namotisisonɨhɨ noaipapɨ tɨtɨhɨ Autaahaatɨhomɨ isɨhiyaatimatɨwɨ komɨhɨretɨ japepihɨrɨwɨse hɨtɨtɨ kahɨtohɨtɨmandapɨ yaimbɨmapɨ pɨhɨtɨpɨ wɨndɨ gɨmunyapenɨme. ");
INSERT INTO agm_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Iyataatɨ mbɨpa kapaamɨ maaritirɨhɨretɨ japepihɨratɨ wɨrawɨra kihɨkihoaaŋɨ mbwaapɨ notaise. Iyataatɨ itɨpɨho mbɨpaamɨ uhapa atisapaahandɨ kandɨ mbɨpa sapa maahɨwihoaaŋapɨ nasahapa maahɨtɨtɨpiyatɨ notaise tɨpɨ kɨnyɨ wɨndɨ monɨpɨhoŋe. O amɨ isɨhiya nahatiya Autaahaatɨhomɨ Itɨpɨhoraahɨ namotaisawɨhiya sɨkɨretɨ saiwɨhiya noaipaitaapo,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Aihɨ Nikodimaasiho komɨha wihoaaŋɨha Jisaasihoai sata nunjenataise. “Autaahaatɨhomɨ Itɨpɨhoraahɨ namotiyonɨhɨ kiya noaipapɨ Autaahaatɨhomɨ isɨhiyaimatɨwɨ komɨhɨretɨ japepihɨrɨtaapo tingɨtɨmandɨ nɨnapitiyatɨ noaipaitaihɨhandapɨse?” undatɨ nunjenataise. ");
INSERT INTO agm_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Aihɨ Jisaasiho komɨha wihoaaŋɨha koai saundataase. “Kɨnyɨ Isɨraherɨhiyai katɨpunjingɨhoŋɨ awaisɨhoŋɨsɨ nisɨ pɨwɨha kɨma gi kahɨtohɨmaapɨ gi wɨndɨ gɨmaahunyaatatɨ wɨndɨ namaahesɨpainjɨhɨnno? ");
INSERT INTO agm_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nɨnɨ gi akɨtɨnɨhɨ kahɨtataato. Nyahɨ mmonaatɨ newaatɨ atisohɨwaiwaapɨ pɨwɨha ausaawaatɨ sangi kasatonɨhandɨ kandɨ sahɨ wɨndɨ atɨhomiwɨ nyamɨ pɨwɨha kasatohɨha sahɨ nepɨ dawaataatemapɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iyataatɨ sapɨ kiyai biyatɨ nga gɨwunyaatatɨ nusesɨpatɨtondɨ kahapaamapɨpa maapɨ yapɨpataapɨhɨ ahetatɨ noaipasɨpɨpaapɨ nepemaitɨ nɨnɨ sangi kasatonɨhandɨ kandɨ sahɨ wɨndɨ gɨmunyaahopo. Owetise. O amɨ yamɨhapataatɨhapɨhaiwa Autaahaatɨho kaiwaiwaapɨ kasatisanaahɨ sahɨ nga wɨndɨ monɨwɨ gɨmunyaitaapo. ");
INSERT INTO agm_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Iyataatɨ isɨhiya usa mambɨhiya yamɨhapataatɨhapɨ naiwɨ Autaahaatɨho kaiwaiwa wɨndɨ mmonɨwɨ nesi japɨhɨ namaasopo. Nehɨ nɨnɨ Isɨhiya Nahatiyaamɨ Saahonɨnɨ Jɨhonɨnɨ Awaisɨhonɨnɨ jɨhura yamɨhapataatɨhɨ bimambɨtɨ nasohɨhonɨnɨ naasonɨnɨhɨ Autaahaatɨho kaiwaiwa mmonɨtɨ gwɨnyaatɨhonɨne. ");
INSERT INTO agm_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Iyataatɨ jɨhura yapɨpatɨ isɨhiya iwɨwɨrɨho owehata Mosesiho akwɨranɨhomɨ sɨwipatɨ kiyatɨ autaahɨ ipatetɨ nimaataise isɨhiya akwɨranɨhomɨ sɨwipatɨ mmonawaawɨ kiyaamɨ timbɨpa owetanɨhɨ kiya wɨndɨ namaapopɨ asɨyɨhiya bimɨtaatɨwo. Isɨ amɨ Isɨhiya Nahatiyaamɨ Saahonɨnɨ Jɨhonɨnɨ Awaisɨhonɨhisangi naasɨkatɨ kaiwɨ isɨhiya nanɨmaapɨ ipɨ tɨtɨhɨ atawɨhatetɨ nanimaapɨ nɨwɨtaapo. ");
INSERT INTO agm_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nanimaasaihɨ nɨnɨ ipɨ tɨtɨhɨ atawɨhatetɨ nimaatohɨtɨhandapɨ isɨhiya gɨnunyapenawaawɨ nyangi ko japɨhɨ nanyamaitandɨ napotaise tɨwɨ nisapɨ gɨnunyaahohiyɨhiya wɨndɨ namaapopɨ kiyaanɨhɨ jinjapɨhɨ jinjapɨhɨ bimɨtaapo. ");
INSERT INTO agm_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Iyataatɨ Autaahaatɨho isɨhiya yapɨpatambɨhiya nahatiyai maarɨho apɨpaahɨ aungwohandɨ nunyataise. Siyatɨ maarɨho aungwohandɨ nunyataatɨ nɨnɨ komɨ Mwaahonɨnɨ nehɨ naasonɨhi kiyaapɨhɨ natanoaasataise. Natanoaasindɨmandɨ apaapɨmaahe amɨ utaaho itapa wo waatɨ nisapɨ gɨnunyaahohiyɨhiya wɨndɨ namaapopɨ kiya asɨyaimatɨwɨ jinjapɨhɨ jinjapɨhɨ kiyaanɨhɨ bimɨtaatɨwe. ");
INSERT INTO agm_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Iyataatɨ Autaahaatɨho nɨnɨ komɨ Mwaahonɨhi natanoaasihɨ kɨmaapɨ yapɨpataapɨhɨ nasohɨtɨmandɨ isɨhiyai netɨ pɨwɨha kiyaamɨhetɨ yawutaatɨ sahɨ maipɨhaiwaisawɨhiyaatisɨ samɨ maipɨhaiwaapɨ pɨwɨha naitaapo undɨtandɨmaahe. Owetise. Isɨhiyai nɨnɨ kiyaamɨ maipɨhaiwaatɨhapɨ japɨhɨ numwaitandɨ nɨngi Autaahaatɨho natanoaasihɨ nasataayo. ");
INSERT INTO agm_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Isɨ isɨhiya usa nisapɨ nyamɨ maipɨhaiwa kiyohɨwaiwa nenyamatɨ japɨhɨ nanyamaitandɨhoe tɨwɨ gɨnunyaasaihaahɨ Autaahaatɨho kiyaapɨ satatɨ ‘Kiyaamɨ maipɨhaiwaapɨ pɨwɨha awaisɨha wɨndɨ namaitaapo,’ tatɨ katɨtaise. O amɨ isɨhiya usa nisapɨ wɨndɨ gɨmaanunyaasaihɨhiyai kiyaamɨhetɨ pɨwɨha awaisɨha netɨ yawutaatɨ saundɨtɨ, ‘Sahɨ maipɨhiyaatisɨ samɨ maipɨhaiwaapɨ pɨwɨha nepise,’ undɨtɨ kiyaamɨhetɨ yawutaito tatɨ Autaahaatɨho aimɨ katise. Pɨwɨha netɨ kiyaamɨhetɨ yawutaito tatɨ Autaahaatɨho katindɨmandɨ apaapɨmaase isɨhiya nisapɨ satɨwɨ, ‘Ko Autaahaatɨhomɨ Mwaaho naasohɨhɨ nyamɨ maipɨhaiwa nenyamatɨ japɨhɨ nanyamaitandɨhoe,’ tɨwɨ nisapɨ gɨmaanunyaahohiyɨhiyai Autaahaatɨho pɨwɨha awaisɨha netɨ kiyaamɨhetɨ yawutaitandɨhandapɨto. ");
INSERT INTO agm_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iyataatɨ isɨhiya nisapɨ gɨmaanunyaahohiyɨhiyai Autaahaatɨho saundatɨ, ‘Sahɨ maipɨhaiwaisawɨhiyaatisɨ samɨ maipɨhaiwaapɨ pɨwɨha awaisɨha nepise,’ undɨtandɨhandamɨ tanyaaha siyate. Nɨnɨ nausainjɨhonɨnisɨ nisɨ kiyohɨwaiwa nausaatatɨ sisɨhaamatiyatɨ isɨhiyai nɨwusaatataise. Aihɨ isɨhiya apɨpaahɨ maipɨhaiwaisawɨhiyaasɨ nisɨ kiyohɨwaiwaapɨ maarɨho naninyawɨ gɨmaanunyaapɨ daahɨ kiyaanɨhɨ maipɨhaiwaisaahɨhɨ maarɨho nunyawɨ kiyohɨtɨhandaahɨ Autaahaatɨho kiyaamɨhetɨ pɨwɨha netɨ yawutaatɨ sahɨ samɨ maipɨhaiwaapɨ pɨwɨha awaisɨha nepise undɨtaise. ");
INSERT INTO agm_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iyataatɨ isɨhiya maipɨhaiwai maarɨho nunyawɨ kiyohiyɨhiya sisɨhaamatiyatɨ nausaatahaiwa nɨnɨ kiyohɨwaiwaapɨ poundonɨhɨ kiya kaiwai ahosumwapɨ ipɨhatiwɨmaitaapo. Iyataatɨ isɨhiya maipɨhaiwaisawɨhiya amɨ saiwɨ gwɨnyaitaapo sisɨhaamatiya nausaatindɨhandetɨ nyahɨ naisaihɨ nyamɨ maipɨhaiwa kiyohɨwaiwa auta noaipaitaiso tɨwɨ gwɨnyapenawaawɨ sisɨhaamatiya nausaatindɨhandetapɨ kiya wɨndɨ namaapɨtaapo. ");
INSERT INTO agm_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Iyataatɨ isɨhiya akɨtɨnɨhɨ tɨtɨhɨ gaahaiwa kiyohiyɨhiya siya sisɨhaamatiya nausaatindɨhandetapɨ nanɨhaiwɨ napɨtaapo. Iyonɨhɨ isɨhiya kiyaamɨ kiyohɨwaiwa usonawaawɨ Autaahaatɨhomɨ watɨpɨhandaahɨ kiyawaayopo tɨwɨ gwɨnyaitaapo,” tatɨ Jisaasiho Nikodimaasihoai pɨwɨha saiwa kaundataase. ");
INSERT INTO agm_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Aihɨ Jisaasihounɨ komɨ otɨpɨpatɨhiyaanunɨ Jerusaremɨhanda bimainjaatɨ kapɨhɨ namasisɨ Judiyaahandamɨ yapɨpatɨ wihoaaŋɨhataahapɨ nohaayo. Nowaatɨ kapɨhɨ bindɨhaawɨ isɨhiyai waapohora baawusɨhaayo. ");
INSERT INTO agm_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aihɨ Jonɨhoaisangi sura aunahɨpa Ainonɨhanda Sarimɨhandamɨ detɨ isɨhiyai baawusataise. Iyataatɨ sapɨhɨ waapɨhaatɨ asaketɨhapɨhisɨ amɨ kapɨhɨ waapoho asaketimbɨpɨhɨ isɨhiya namandariwɨ koenda nasauhɨ kiyai kapɨhɨ baawusataise. ");
INSERT INTO agm_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Iyataatɨ Jonɨho isɨhiyai baawusisura sura sangɨ napwɨtatɨ nehɨ bindataahuraare. ");
INSERT INTO agm_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Aihɨ sura utaaho wotihɨ Jonɨhomɨ otɨpɨpatɨhiyaatihɨ satɨwɨ itɨhɨnnawaatopo. “Jonɨho isɨhiyai baawusindɨhandɨ yatɨhɨtihɨ amɨ Jisaasiho isɨhiyai baawusindɨhandɨ autaahɨ apɨpaahɨ awaindɨhande,” tɨwɨ itɨhɨnnawaatopo. ");
INSERT INTO agm_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Itɨhɨnnawaawɨ namapɨ Jonɨhomɨ otɨpɨpatɨhiya nuwɨ Jonɨhoai saundawaatopo. “Katɨpunjingɨhonye, jɨhura utaaho wo waapɨhaatɨ Jorɨtanɨhaatainɨ gisatɨ maasɨ bimihɨ kɨnyɨ kopɨ sɨsiyahoe tɨpɨ kanyatingɨho wanɨ taatɨ isɨhiyai baawusataise. Aihɨ isɨhiya taahiyɨhiya koaapɨhɨ niyohɨtɨmandɨ tɨtɨhɨmaahe,” undawaatopo. ");
INSERT INTO agm_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Saundauhɨ Jonɨho komɨ otɨpɨpatɨhiyai wihoaaŋɨha sata kaundataase. “Isɨhiyaarɨ kiyaamɨ gwɨnyaahohɨtɨhandɨ watɨpɨhandaahɨ saiwɨhaiwa wɨndɨ kamaitaapo. Owetɨtaise. Autaahaatɨho yamɨhapataatɨhɨ bimisɨho watɨpɨhandɨ nunyatɨ gɨwunyaahonaahɨ saiwɨhaiwa kaitaapo. Iyataatɨ Autaahaatɨho Jisaasihoai watɨpɨhandɨ nunyatɨ kaundihɨ isɨhiya koaapɨhɨ nga tɨtɨhɨ nowaayowɨ sahɨ kopɨ napaapɨ itɨhɨtopo? ");
INSERT INTO agm_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Iyataatɨ jɨhura pɨwɨha sandɨ sangi kasatonɨhɨ sahɨ aimɨ gwɨnyaapɨhiyaate. Isɨhiyai Japɨhɨ Numwaitandɨ Autaahaatɨho Ahɨwisɨhonɨnɨmaahe. Owetise. Ko ipotɨ napɨtaihɨ Autaahaatɨho nɨngi jɨhɨ natanoaasihɨ pɨwɨha kati jɨhɨ napɨtɨhonɨne satɨtɨ sangi aimɨ kasatonɨhɨ sahɨ aimɨ gwɨnyaapɨhiyaate. ");
INSERT INTO agm_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Isɨ pɨwɨha wa namɨhandɨ sandɨ kasatɨtaano, utaaho wo apopaati netɨ wɨrataataahɨ saatɨ apopaatɨ tɨtɨhɨ komɨhaatimatɨtande. Iyataatɨ apopaati netɨ wanɨ wɨrasɨho pɨwɨha gaaha katonɨhɨ komɨ naisoho kahapaamapɨpa netɨ turɨmasɨho kapɨhɨ detɨ bitondaatɨ atisata apɨpaahɨ aungwohandɨ asakiyatɨ maaritataise. Iyataatɨ pɨwɨha namɨhandɨ katohɨmaamɨ tanyaaha siyate. Isɨhiya taahiyɨhiya pɨhɨtɨwɨ Jisaasihoenda niyohiyɨhiya siya noaipapɨ tɨtɨhɨ Jisaasihomɨhiyaimatɨtaatɨwɨ nowaayopo. Aihɨ nɨnɨ komɨ otɨpɨpatɨ kaitandɨhatɨ netɨ jɨhɨ turɨmanɨhohɨhonɨnɨ sandɨ mmonataatɨ apɨpaahɨ aungwohandɨ maaritataayo. ");
INSERT INTO agm_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Isɨ ko nanɨtipɨhaatɨ noaipatɨ utaaho apɨpaahɨ awaisɨhotɨtaise. Iyonɨhɨ nɨnɨ noaipatɨ komɨ yatɨhɨ otɨtɨhɨ bimɨto,” undatɨ Jonɨho komɨ otɨpɨpatɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Iyataatɨ autaahɨ yamɨhapataatɨhapɨ napisɨho so isɨhiya nahatiyai nusatipɨhaatɨ apɨpaahɨ awaisɨhore. O amɨ isɨhiya kɨmaapɨ yapɨpatambɨ noaipahohiyɨhiya siya yapɨpatambɨhaiwaapaahɨhɨ mmonɨwɨ nusesɨpatatɨ gɨwunyaatahiyaare. Isɨ kiya tɨtɨhɨ kɨmaapɨ yatɨhɨ yapɨpatambɨhaiwaapaahɨhɨ yapɨpatambɨhiya mmonɨwɨ katohɨrɨhɨretɨ pɨwɨha ausaapɨ katɨtaapo. O amɨ autaahɨ yamɨhapataatɨhapɨ napisɨho so isɨhiya nahatiyai nusatipɨha apɨpaahɨ autaahɨ awaisɨhore. ");
INSERT INTO agm_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Siyatɨ apɨpaahɨ awaisɨhosɨ ko aimɨ mmonatɨ gwɨnyaasɨwaiwaapɨ pɨwɨha ausaatɨ isɨhiyai kaundɨtaise. Pɨwɨha ausaatɨ kaundonɨhandɨ kandɨ isɨhiya komɨ pɨwɨha wɨndɨ atɨhomaawitaapo. Isɨhiya pɨhɨtɨwɨhiyaamɨ otɨhatɨhapɨ nehɨ naasohɨ naasaamɨhɨ nga komɨ pɨwɨha atisawaayopo. ");
INSERT INTO agm_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Iyataatɨ utaaho Autaahaatɨho natausaasihɨ napisɨho soai Autaahaatɨho komɨ Itɨpɨho pɨhɨtatɨ waatɨ tisaitatɨ tirandɨwaho numwihɨhosɨ ko Autaahaatɨhomɨ pɨwɨha nga ausaitaise. Isɨ isɨhiya komɨ pɨwɨha katisɨha atiwɨ nepɨ isɨwatawaawɨ japepihɨrohiyɨhiya Jisaasihopɨ satɨwɨ, ‘Ko pɨwɨha akɨtɨha kandaase,’ tɨwɨ gɨwunyaawaawaahɨ amɨ kɨmɨkaiwɨ Autaahaatɨhopɨsangi, ‘Pɨwɨha akɨtɨha katahoe,’ tɨwɨ mɨkaiwɨ gɨwunyaitaapo. ");
INSERT INTO agm_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Iyataatɨ Sapɨho komɨ Mwaahoai maarɨho aungwohandɨ nunyataatɨ namatɨ nahatewa watɨpɨhaiwa komɨ ikwɨraatɨhɨmataise. Aihɨ nahataapa ko jatataise. ");
INSERT INTO agm_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Isɨ utaaho Autaahaatɨhomɨ Mwaahopɨ gɨwunyaataataahɨ so asɨtimatɨtandɨhandɨ aimɨ netaise. O amɨ utaaho wo Autaahaatɨhomɨ Mwaahomɨ pɨwɨha atɨhomisatɨ ahosumwatataahɨ so komɨ astɨtimatɨtandɨhandɨ wɨndɨ namaitaise. Owetɨtaise. Autaahaatɨho pɨwɨha netɨ komɨhetɨ yawutaitandɨhapɨhɨ aimɨ netɨ sawaho tɨmanɨnatɨ bindataise. Iyatɨ Autaahaatɨho isɨhiya maipɨhiyaapɨ apowindɨhandaatɨhɨ kandɨ ko naitandɨhapɨhɨ aimɨ bindataise,” undatɨ Jonɨho komɨ otɨpɨpatɨhiyai kaundataase. ");
INSERT INTO agm_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Aihɨ suraanɨhɨ isɨhiya Parisihiya Jisaasihopɨ pɨwɨha satɨwɨha atisawaayopo. Isɨhiya taahiyɨhiya Jisaasihopɨ gɨwunyaahauhɨ Jisaasiho kiyai numwaatɨ Jonɨho isɨhiyai baawusisawɨhiyai nusatipɨhaatɨ apɨpaahɨ taahiyɨhiyai waapohora baawusataise tɨwɨha atisawaayopo. ");
INSERT INTO agm_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Iyataatɨ sura Jisaasiho sawahomɨ ikwɨraahɨ isɨhiyai baawusataamaise. Owetise. Komɨ otɨpɨpatɨhiyaanangisaahɨhɨ nahatewetɨ kanyatihɨ isɨhiyai nyahɨ baawusɨhaayo. ");
INSERT INTO agm_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Aihɨ Jisaasiho komɨ otɨpɨpatɨ kaindɨhandapɨ isɨhiya Parisihiya aimɨ atisopo tauhɨ atisataise. Atisataatɨ Parisihiyai nisapɨ apowɨtaiso tatɨ gwɨnyapenataatɨ namatɨ kapɨhɨ Judiyaahanda namasi yapɨpatɨ Garirihandaahapɨ naihɨ nyahɨ maasɨ nohaayo. ");
INSERT INTO agm_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Iyataatɨ Jisaasiho daihɨra Samariyaahandaahɨra daundirɨhɨraapɨ maaritataatɨ kɨra naihɨ nohaayo. ");
INSERT INTO agm_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aihɨ kɨra naihɨ nowaatɨ yapɨpatɨ Samariyaahandamɨ aunahɨpatɨ taunɨhandɨ Saikaahanda noaipahaayo. Iyaatɨ sapɨhɨ jɨhura Jekopɨho komɨ mwaaho Josepɨhoai yapɨpatɨ numwipatɨ kapɨhɨ Saikaahanda detɨ ahendaise. ");
INSERT INTO agm_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iyataatɨ jɨhura Jekopɨho anɨmwaahɨpatɨ waapoho niwɨtaatɨwɨ yamwaasɨpatɨ kapɨhɨ aunahɨpa Saikaahandamɨhinɨ ahendaise. Aihɨ Jisaasiho daihɨra utaarɨhandaatɨhɨ daindɨhandapɨ nurɨpotɨndɨwihɨ namatɨ otapɨhaatɨ ipɨho otɨhasɨnɨtihɨhura waapohomɨ anɨmwaahɨpatainɨ detɨ bindataise. ");
INSERT INTO agm_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Iyataatɨ Jisaasiho apopaatisatɨ pɨwaatinjura nyahɨ komɨ otɨpɨpatɨhiyaanɨnɨ nawɨho nunya nandapa naitɨhaawɨ nahatiyaanɨnɨ aimɨ nowaamahonɨhuraare. Aihɨ siyatɨ Jisaasiho waapohomɨhinɨ bimihɨ apopaatɨ waatɨ Samariyaahaatɨ waapoho niwɨto tatɨ onɨha isɨsi nasataise. Aihɨ Jisaasiho kaati saundataase. “Waapoho wo nandaanɨ naninye,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Saundihɨ kaatɨ apopaatɨ kaatamɨha wihoaaŋɨha Jisaasihoai saundataase. “Kɨnyɨ Judaahoŋɨtihɨ amɨ nɨnɨ Samariyaahaanɨnisɨ nɨngi kɨnyɨ waapoho wo naninye tɨpɨ napaapɨ sandɨ kandapaase?” undataase. Iyataatɨ apopaatɨ Jisaasihoai kɨnyɨ Judaahaaŋɨtihɨ amɨ nɨnɨ Samariyaahaanɨne undindɨmandɨ apaapɨmunje amɨ Judaahiya Samariyaahiyaisawɨ maasɨ nandapa namaanɨwɨ amɨ wɨndɨ pɨwaamanɨwɨ kiyaisɨ nehɨ yiyandɨhɨ bindawaahuraatihɨ kandapɨ kaatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kaatɨ apopaatɨ Jisaasihoai sata kaundihɨ Jisaasiho komɨha wihoaagɨha kaati saundataase. “Autaahaatɨhomɨ gaahandɨ gi nehɨ nahɨmɨtandɨhandapunɨ amɨ wanɨ nɨnɨ gi taatɨ pɨwaahɨtohɨmonisapunɨ gwɨnyaapaapaahɨ kɨnyɨ satɨpɨ nɨngi waapoho naninye disamɨhɨ waapoho asɨtimatɨpɨ jinjapɨhɨ jinjapɨhɨ bimɨtaapɨho ko wɨndɨ namaapatatɨ konɨhɨ noaasɨho gi nɨnɨ nahɨmɨto,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Saundihɨ apopaatɨ Jisaasihoai kaatamɨha saundataase. “Awaisɨhoŋe, waapoho kɨmo onɨhɨ mɨhopɨ anɨmwaahɨpatopɨ nimandataise. Iyataatɨ kɨnyɨ onɨhaunɨ wɨrɨhɨrunɨ apɨpaahɨ owehoŋisɨ waapoho so asɨtimatɨwɨ bimɨtaatɨwɨho kɨnyɨ napitaimbɨ nipɨnɨmɨtaapɨse? ");
INSERT INTO agm_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iyataatɨ jɨhura nyamɨ asɨho Jekopɨhounɨ komɨ mwaayaunɨ komɨ sipɨsipɨhandunɨ waapoho kɨmo ko nanawaayopo. Nanɨwɨ bimambɨwɨ nyamɨ asɨho Jekopɨho waapoho kɨmo nyangi nanyamihɨhore. Isɨ kɨnyɨ nyamɨ asɨho Jekopɨho waapoho kɨmo nanyamisɨhoai kɨnyɨ nusatipɨhaapɨ awaisɨhoŋɨtapaapɨ waapoho wo gaaho nanyamɨtaapɨnno? Owetɨtaise,” undatɨ apopaatɨ Jisaasihoai kaundataase. ");
INSERT INTO agm_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Saundihɨ Jisaasiho komɨha pɨwɨha wihoaaŋɨha kaati sata kaundataase. “Isɨhiya nahatiya waapoho kɨmo nanɨhohiyɨhiya waapohopɨ jinjapɨhɨ nawɨtaise. ");
INSERT INTO agm_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","O amɨ waapoho isɨhiyai nɨnɨ numwɨtandiyohɨmomɨ utaaho wo netɨ nanataataahɨ koai sɨhɨ ipotɨsangi wɨndɨ waapohopɨ pɨhɨtatɨ wɨndɨ namausɨtaise. Owetɨtaise. Nisɨ waapoho isɨhiyai numwɨtandiyohɨho numwisanɨhɨ isɨhiyaamɨ omaŋɨtɨtɨhɨ notɨ anɨmwaahɨpatopɨ waapoho jinjapɨhɨ noaatɨ konɨhɨ nimandipatamatiyatɨ konɨhɨ noaatɨ tisaitatɨ tirandɨwa nimandɨtaise. Iyonɨhɨ amɨ isɨhiyaamɨ omaŋɨtɨtɨhapɨsangi sɨkiyatɨ waapoho pɨhɨtatɨ jinjapɨhɨ konɨhɨ noaatɨ nimandataatɨ isɨhiyai asɨtimatɨwɨ bimɨtaatɨwɨhandɨ numwɨtaise,” undatɨ Jisaasiho kaati kaundataase. ");
INSERT INTO agm_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aihɨ apopaatɨ kaatɨ Jisaasihomɨ pɨwɨha kaundisɨhaapɨ wɨndɨ apɨpaahɨ namausesɨpainjɨhɨ kaatɨ wɨretɨ tɨtɨhɨ waapohopɨ gwɨnyapenataatɨ Jisaasihoai sata kaundataase. “Awaisɨhoŋe, waapoho so katingɨho nɨngi naninye. Nanɨmisamɨhɨ nɨnɨ nanataatɨ waapohopɨ nahatewetɨ wɨndɨ nɨngi namainyonɨhɨ niwɨtandɨ kɨmandɨ daahɨ utaarɨmandaatɨhɨ wɨndɨ namaapɨtaano,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aihɨ Jisaasiho pɨwɨha komɨha kaatɨ apopaati sata kaundataase. “Kɨnyɨ japɨhɨ numbwɨ kinyɨ kɨwɨhoai numwaasi jahɨra kɨmbɨhɨ napɨtaapɨ numwe,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Saundihɨ apopaatɨ kaatamɨha wihoaaŋɨha Jisaasihoai saundataase. “Nɨnɨ nɨwɨho owehaanɨne,” undataase. Saundatɨ kaundihɨ Jisaasiho komɨha kaati saundataase. “Kɨnyɨ nɨwɨho owehaanɨne tingɨtɨmandɨhɨ tɨtɨhɨ akɨtɨnɨhɨ katapaase. ");
INSERT INTO agm_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Iyataatɨ jɨhura isɨhiya ikwɨrɨ naasairɨtahiyai namaatɨpapɨ japɨhɨ usesi noaipapɨhaaŋe. Aihɨ wanɨ kɨnyɨ utaaho yahoaisapɨ maasɨ bimingo so tɨtɨhɨ kinyɨ kɨwɨhomaahe. Aihɨ kɨnyɨ nɨwoya owehaanɨne tingɨha tɨtɨhɨ akɨtɨnɨhɨ katapaase,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aihɨ kaatɨ apopaatɨ Jisaasihoai saundataase. “Kɨnyɨ nɨngi wɨndɨ maanisonɨhinɨhɨ kiyohɨwaiwaapɨ kɨnyɨ ausaapɨ katinɨhɨ nɨnɨ kinyapɨ Autaahaatɨhomɨ pɨwɨha atisatɨ netɨ ausaitandɨhoe ndɨ gwɨnyaataayo. ");
INSERT INTO agm_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Iyataatɨ nyamɨ asoya kɨmbɨhɨ Samariyaahandaahapɨhiya sisɨho kɨmo detɨ ahetisɨmoaasɨnɨ ahoyanɨwɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundawaayopo. Saiwɨ ahoyanɨwɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundauhɨhandɨ kandɨ sahɨ Judaahiyaatɨ apɨpaahɨ watɨpɨtɨwɨmapɨ andɨtitɨwɨ satɨwɨhiyaate. ‘Ahoyanɨwɨ Autaahaatɨhopɨ gwɨnyaapɨ gaapundɨtaatɨwɨhapɨhɨ nehɨ Jerusaremɨhandaahɨhe,’ tɨwɨ katɨwɨhiyaate,” undatɨ Jisaasihoai kaatɨ kaundataase. ");
INSERT INTO agm_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aihɨ Jisaasiho komɨha kaati saundataase. “Apopaanye, nɨnɨ pɨwɨha apɨpaahɨ akɨtɨnɨhɨ sandɨ gi kahɨtataato sɨhɨ Apɨho Autaahaatɨhopɨ isɨhiya gwɨnyaapɨ gaapundɨtaatɨwɨ kɨmo sisɨmoaasɨnapaahɨhɨ wɨndɨ gwɨnyaasi namaapɨtaapo. Aiwɨ amɨ Apɨho Autaahaatɨhopɨ gaapundɨtaatɨwɨ Jerusaremɨhandaahapaahɨhɨ wɨndɨ gwɨnyaasi namaitaapo. Owetɨtaise. Nehɨ kiyaamɨ omaŋɨtɨtɨhapɨ Autaahaatɨho sawahopaahɨhɨ gɨwunyaapɨ koai pɨwaundɨwɨ gaapundɨwɨ nepɨ mepɨ autaahepumwaitaapo. ");
INSERT INTO agm_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Iyataatɨ sahɨ Samariyaahiyaatɨ Autaahaatɨhomɨ pɨwɨha atiwɨ nepɨ ausaahohiyɨhiyaamɨ pɨwɨhaunɨ amɨ pɨwɨha aunɨhɨhɨraatɨhɨ ahotiwaiwaunɨ wɨndɨ minjapepihɨropo. Siyawaawɨ sahɨ gwɨnyaapɨ samɨ gaapundohɨhopɨ sahɨ wɨndɨ mmonɨwɨ namaasesɨpatatɨ gɨmaasunyaatahiyaate. O amɨ nyahɨ Judaahiyaanɨnɨhɨ nyamɨ gaapundohɨhopɨ nga ginunyainjɨhɨ mmonɨhaawɨ nyangi nanyesɨpatahiyaanɨne. Iyataatɨ amɨ nyahɨ gaapundohɨhopɨ mmonaatɨ gɨnyunyaatahiyaanɨne tohɨtɨmandɨ apaapɨmaato amɨ nyahɨ Autaahaatɨhomɨ pɨwɨha jɨha nahata biyaatɨ nga isɨwataatɨ amɨ japepihɨrɨhaayo. Iyonɨhɨ Isɨhiyai Autaahaatɨho japɨhɨ numwaitandɨhandɨ nyahɨ Judaahiyaanamɨhetapɨ noaipataise. Aihɨ Autaahaatɨho utaaho isɨhiyai japɨhɨ numwaitandɨhoai netɨ natausaasihɨ maapɨ yapɨpataapɨhɨ nasatɨ nyahɨ Judaahiyaamɨhetapɨ ko noaipataise. ");
INSERT INTO agm_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Iyataatɨ asisɨha yaha taatɨ nasataise. Iyataatɨ amɨ asisa sa wanɨ kɨmuraare isɨhiya Autaahaatɨho akohopɨ akɨtɨnɨhɨ gwɨnyaapɨ gaapundɨwɨ pɨwaundɨwɨ koai nɨwimaapɨ mepɨ autaahemwahohiyɨhiya Autaahaatɨhomɨ Itɨpɨho kiyai netɨ nunjatɨ nusepemaahɨwa gɨwunyaasɨrɨhɨretɨ koai pɨwaundɨwɨ komɨ ambɨpatɨ nɨwimaapɨ mepɨ autaahepumwapɨ gaapundɨtaatɨwo. Isɨhiya sawitaatɨwɨhiyaapɨ Autaahaatɨho maaritatɨ amɨ taatɨ daataise. ");
INSERT INTO agm_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Iyataatɨ Autaahaatɨho nehɨ utaahomaahe. Owetise. Amɨ Autaahaatɨho Itɨpɨhore. Amɨ Autaahaatɨho Itɨpɨhosɨ isɨhiya kopɨ gwɨnyaapɨ pɨwaundɨwɨ koai nɨwimaapɨ mepɨ autaahepumwapɨ gaapundohiyɨhiya Autaahaatɨhomɨ Itɨpɨho netɨ gɨwunyaatɨ nunjirɨhɨretunɨ amɨ kiya Autaahaatɨho apɨpaahɨ akɨtɨ akɨtɨnɨhɨ akohoso tɨwɨ tɨtɨhɨ akɨtɨnɨhɨ gɨwunyaahorɨhɨretɨ japepihɨrɨwɨ koai mepɨ autaahepumapɨ pɨwaundɨwɨ amɨ gaapundɨtaatɨwe,” undatɨ Jisaasiho apopaati kaundataase. ");
INSERT INTO agm_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aihɨ kaatɨ apopaatɨ Jisaasihoai kaatamɨha saundataase. “Kɨraisiho Isɨhiyai Japɨhɨ Numwaitandɨ Autaahaatɨho Ahɨwisɨho napɨtaise. Nasataahura nahataapa Autaahaatɨhopɨ akohoe tatɨ akɨtɨhaiwa netɨ nanyisatɨ kanyatɨtaise. Kanyatonɨhɨ nyangi biyatɨ nanyesɨpatɨtaise ndɨ gwɨnyaatɨhaanɨne,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Aihɨ Jisaasihomɨha kaati saundataase. “Isɨhiyai Japɨhɨ Numwaitandɨ Autaahaatɨho Namɨhanatɨ Ahɨwisɨhonɨnɨ kɨmɨkonɨnɨ gi wanɨ taatɨ pɨwɨha kahɨtataato,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Siyatɨ Jisaasiho taatɨ apopaati pɨwaundihɨ komɨ otɨpɨpatɨhiyaanɨnɨ nandapa naitɨhaawɨ taunɨhanda niyohiyɨhiyaanɨnɨ japɨhɨ nasawa noaipahaayo. Nasawa noaipa Jisaasiho apopaatisa maasɨ taatɨ pɨwaatindɨhandapɨ pɨhɨtaatɨ gwɨnyaahaayo. Otɨpɨpatɨhiyaanɨnɨ pɨhɨtaatɨ gwɨnyaahohɨtɨmandɨ Judaahiyaanamɨ wɨnɨhapɨpa siyɨhapa ahiyauhe, asɨhiyaisaahɨhɨ Autaahaatɨhomɨhaiwaapɨ nyahɨ wɨndɨ katawaamunjɨtaano tɨwɨ ahiyawɨhandɨtihɨ kandapɨ nyahɨ pɨhɨtaatɨ gwɨnyapenɨhaayo. Siyaatɨ pɨwɨha gwɨnyaahaahandɨ kandɨ Jisaasihoai, “Kɨnyɨ pɨwɨha maahɨwa taapɨ kaundapaise,” undaatɨ nyahɨ wɨndɨ koai namunjenɨho owetise. Iyaatɨ amɨ apopaati “Kɨnyɨ napindape?” undaatɨ nyahɨ wɨndɨ namunjenɨho. Owetise. ");
INSERT INTO agm_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aihɨ apopaatɨ kaatɨ kaatamɨ onɨha waapoho niwɨtandɨ isɨsi napisɨha ahiyamapɨ japɨhɨ aunahɨpataahapɨ notaise. Notɨ isɨhiya kapɨhɨ aunahɨpata bimohiyɨhiyai sata kaundataase. ");
INSERT INTO agm_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Utaaho wo jɨhura nisɨ kaindɨ daayohɨwaiwa wɨndɨ monaho wanɨ napitiyatetɨ nisonataatɨ nahatewaapɨ kandataase. Isɨ ko Isɨhiyai Japɨhɨ Numwaitandɨ Autaahaatɨho Ahɨwisɨhotindɨho? Sahɨ koai usondaatɨwɨ ketɨ napɨwɨse,” undataase. ");
INSERT INTO agm_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Satatɨ apopaatɨ notɨ isɨhiya aunahɨpata bimohiyɨhiya