﻿USE sofia;
DROP TABLE IF EXISTS sofia.agg_vpl;
CREATE TABLE agg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES agg_vpl WRITE;
INSERT INTO agg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sisas Kraisɨndɨ amoao mamɨ nüŋgurumboemo tüküyafu manɨŋgomo hoafane nda. Sapo Sisas ai Defitɨndɨ amoao ambeahɨndɨ tükümefiyua asu Defit ai Abrahamɨndɨ amoaombofi tükümefiyu ranɨ hoafane nda. ");
INSERT INTO agg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ai Aisakɨndɨ afɨndɨyuane. Asu Aisak ai Sekopɨndɨ afɨndɨyuane. Asu Sekop ai Suda ahandɨ apodoho mamɨ ranɨ babɨdɨmbo-memo ranahamundɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Asu Suda ai Peres Sarayafandɨ afɨndɨyuane. Ahafandɨ hondɨ ranai Tamarɨyoane. Asu Peres ai Hesronɨndɨ afɨndɨyuane. Asu Hesron ai Ramɨndɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Asu Ram ai Aminadapɨndɨ afɨndɨyuane. Asu Aminadap ai Nasonɨndɨ afɨndɨyuane. Asu Nason ai Sarmonɨndɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Asu Sarmon ai Boasɨndɨ afɨndɨyuane. Ahandɨ hondɨ ranai Rahapɨyoane. Asu Boas ai Obetɨndɨ afɨndɨyuane. Ahandɨ hondɨ ranai Rutɨyo. Asu Obet ai Sesindɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Asu Sesi ai sapo Defit adükarɨ bogorɨ nindoumbofi manüŋgu ranahandɨ afɨndɨyuane. Asu Defit ai Soromonɨndɨ afɨndɨyuane. Ahandɨ hondɨ ranaiyo horombo Uriandɨ nɨmorehɨ-mayo. ");
INSERT INTO agg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Asu Soromon ai Rehoboamɨndɨ afɨndɨyuane. Asu Rehoboam ai Abaisandɨ afɨndɨyuane. Asu Abaisa ai Asandɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asu Asa ai Sehosafatɨndɨ afɨndɨyuane. Asu Sehosafat ai Sehoramɨndɨ afɨndɨyuane. Asu Sehoram ai Usiandɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asu Usia ai Sotamɨndɨ afɨndɨyuane. Asu Sotam ai Ahasɨndɨ afɨndɨyuane. Asu Ahas ai Hesekiandɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Asu Hesekia ai Manasendɨ afɨndɨyuane. Asu Manase ai Emonɨndɨ afɨndɨyuane. Asu Emon ai Sosaiandɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Asu Sosaia ai Sekoniandɨ apodoho mamɨ ranahamundɨ afɨndɨyuane. Sapo ranɨ-sɨmboanɨ Babiron ami Israer nendɨ ranaheimbo Babiron hɨfɨna ahamundɨ moanɨ ratüpurɨmbohünda sowandümondürɨ mahomo. ");
INSERT INTO agg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ai Babiron hɨfɨna sowandümondürɨ houmbo Sekonia ai Searɨtierɨndɨ afɨndɨyuane. Asu Searɨtier ai Serubaberɨndɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Asu Serubaber ai Abiutɨndɨ afɨndɨyuane. Asu Abiut ai Eriakimɨndɨ afɨndɨyuane. Asu Eriakim ai Asorɨndɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asu Asor ai Sadokɨndɨ afɨndɨyuane. Asu Sadok ai Akimɨndɨ afɨndɨyuane. Asu Akim ai Eriutɨndɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Asu Eriut ai Ereasarɨndɨ afɨndɨyuane. Asu Ereasar ai Matanɨndɨ afɨndɨyuane. Asu Matan ai Sekopɨndɨ afɨndɨyuane. ");
INSERT INTO agg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Asu Sekop ai Sosepɨndɨ afɨndɨyuane. Asu Sosep ranai Mariandɨ nindowenihɨ-mayu. Maria ai Sisas ranahambo wakɨmarɨmɨndo, sapo ahambo Krais sei arɨhündɨ ra. ");
INSERT INTO agg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ranɨmboane muŋguambo nindou Abraham nüŋguambe peyo haya ho hombo Defit nüŋguambe tükümefeyo ranai 14 amoao boagɨrɨyomo nɨmorɨyomo marundɨ ra tükümefeyo. Asu Defit nüŋguambe peyo haya ho hombo Babiron hɨfɨna sowandümondürɨ homondambe amboanɨ, mare yahurai 14 amoao kareandeimbambe ramɨndümbɨ boagɨrɨyomo nɨmorɨyomo marundɨ ra tükümefeyo. Asu Babiron hɨfɨna sowandümondürɨ homondambe peyo haya ho hombo Kraisɨmbo Maria wakɨrɨmɨndoambe amboanɨ mare yahurai 14 amoao kareandeimbambe ramɨndümbɨ boagɨrɨyomo nɨmorɨyomo marundɨ ra tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sisas Krais ai tükümefiyu hoafɨ ra ndahuraiane. Ahandɨ hondɨ Maria ranahambo Sosepɨmbo segodɨmbo momo kürɨhi hɨnɨŋgɨmarɨhindɨ. Maria ranai Sosepɨdɨbo nɨŋgokoateyoambeyo asu ahambo hoeirɨhindane ai furümbɨ manɨŋgo moanɨ Yifiafɨ Aboedɨndɨ ŋgɨnɨndɨnambo. ");
INSERT INTO agg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ahandɨ nindowenihɨ Sosep ranai nindou mbumundɨ hamɨndɨyu, ŋga ai Maria ranahambo nindou hɨmboahü amoanɨŋgambofembo-mayo ranɨmbo yɨboarükumbo asu ai moanɨ dɨbo ahambo randɨhe hɨnɨŋgɨndɨhea yahu haya hohoanɨmomayu. ");
INSERT INTO agg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sosep ai ranɨmbo dɨbo hohoanɨmoyu-ane asu Adükarɨndɨ sünambeahɨndɨ nendɨ ranai ahamboso yafogoadɨnambo tüküfi hoafɨyundühɨ yahuya, “Sosep, Defitɨndɨ amoao, se Maria sɨhafɨ nɨmorehɨmbofe semɨndɨmbo yɨhɨmbondamboyafɨ. Yifiafɨ Aboedɨndɨ hoafɨ süŋguane Maria ai fi masemɨndo. ");
INSERT INTO agg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nɨmorehɨ ranai nindowenihɨ nɨmorɨ nderɨmɨndɨmboe. Asu se ndürɨ Sisas ra kaboadɨworɨ nɨmboe sapo ai anɨmbo ahandɨ nindou ranaheimbo ahei moaruwai hohoanɨmo ranambeahɨndɨ aboedambondearümbui,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Muŋguambo ranɨ-moatükunɨ rahurai tükümefeyo ra, sapo Adükarɨ ai ahandɨ hoafɨ hoafɨyu randeimbɨndɨ yafambe süŋgure haya hoafɨmayu. Ai yare hoafɨyuhü yahuya, ");
INSERT INTO agg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“E, nɨmorehɨ mamɨ ai nindowenihɨ dɨbo hokoatendowohü ai fi ndemɨndɨ haya asu nindowenihɨ nɨmorɨ nderɨmɨndɨmboe. Rananɨmbo asu ahambo ndürɨ ra kaboadɨhorühɨ Emanuer mbɨsahündomboyei,” mehu ra. Ranɨ hoafɨ ranahandɨ nɨmɨndɨ hoafɨ ana God ai sɨhɨrɨ babɨdɨmbo anüŋguane. ");
INSERT INTO agg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ranɨyu asu Sosep ai yaŋgɨrɨfi haya Adükarɨndɨ sünambeahɨndɨ nendɨ hoafɨmayundo süŋgu rareandühɨ Mariambo ahandɨ nɨmorehɨmbore masemündu. ");
INSERT INTO agg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sosep ranai moai nɨmorehɨ ranɨdɨbo mamühɨ apafe rɨnandɨ, ŋga moanɨ nɨmorehɨ ranaipoanɨmbo nɨŋgo hɨmboyo asu ai nindowenihɨ nɨmorɨ maserɨmɨndo. Ranɨyu asu Sosep ai nɨmorɨ ranahambo ndürɨ Sisasani mehu. ");
INSERT INTO agg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herot ai Sudia hɨfambe bogorɨmbofi nüŋguambe ranɨ-sɨmboanɨ Maria ai Sisas ranahambo Betrehemühɨ wakɨmarɨmɨndo. Hondɨ ai Sisas ranahambo serɨmɨndɨ hayamboyo-ane ranambe nindou bogorɨ fɨfɨrundeimbɨ ranai hüfɨhamɨndɨ süfuanɨpoedɨ Serusarem ŋgoafambe tükümefundɨ. ");
INSERT INTO agg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ai düduyafundühɨ yahomoya, “Nɨmorɨ sɨmborɨ masahorɨmɨndei sapo Suda-yafe bogorɨmayu ra nüŋgufiyua? Ro hoeirɨhundanɨ ahandɨ mupui ranai hüfɨhamɨndɨ süfuanɨ tüküfe mamaroamboanefɨ asu ro ahambo hohoanɨmoyondowohü ŋgusüfo pefimbohünda masühifɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ranɨyu asu Herot Adükarɨ Bogorɨmayu ranai ranɨ hoafɨ ra hɨmborɨyu haya ŋgusüfoambe afɨndɨ hohoanɨmomarɨra asu muŋguambo nindou Serusarem ŋgoafɨhü mamarei amboanɨ ramareandürɨ. ");
INSERT INTO agg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ranɨyu asu Herot ai Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨ nindou-memo ranɨyomo asu ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ nindou-memo ranɨyomo muŋguambo ahamumbo mamühɨ gugureapurɨ mbura düdufipurühɨ yahuya, “Krais ranahambo ŋgoafɨ nahü mandahorɨmɨndeia?” yahu düdumefipuramboemo. ");
INSERT INTO agg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Asu sɨmborɨ ai ahambo yahomoya, “Betrehem ŋgoafɨhü Sudia hɨfambe. Sapo horombo God ai ahandɨ hoafɨ hoafɨyu-randeimbɨ nindou ahandɨ süŋgu hoafɨ ra ndahuraiyu yare sürü pare masɨhendɨ. Ai Bukambe yare hoafɨyuhü yahuya, ");
INSERT INTO agg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Betrehemɨhündɨ, se Sudia hɨfambe-anei anɨboadei ra awi se Sudiambo hɨfandundeimbɨ bogorɨ ŋgoafɨ ranahamundɨ daboadanɨpoedɨ hamɨndɨyeipoanɨ, ŋga wanɨ. Sɨhei ŋgoafɨ mbusümodɨdɨ anɨmbo nindou adükarɨ mamɨ ai tükündüfi haya wandɨ Israer nindou ranaheimbo hɨbadarümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ranɨyu asu Herot ai sapo nindou hüfɨhamɨndɨ süfuanɨpoedɨ ndüfosi nendɨ masɨfomo ranahamumbo dɨbo mborai yahupurɨ hürühepurɨ haya yahuya, “Nɨnɨ sɨmboanɨ hondü hamɨndɨyo mupui ra tüküfe mamaro?” yahu haya düdu düdumefipurɨ. ");
INSERT INTO agg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ranɨyu ai nindou memo ranahamumbo Betrehemɨnambo koamarɨhepurɨ ndanɨ süŋgundafundɨ yahuhaya hoafɨyupurühɨ yahuya, “Se ŋgɨfomo moanɨ ndondu nɨmorɨ ranahambo nahi ai ahambo masahorɨmɨndei ranahambo kokondurü. Ŋga asu hoeindurühɨ ana, asu se wambo ranühɨ mbɨsɨmo hoafɨndɨmondanɨ anɨmbo asu ro-amboanɨ dügɨ ahambo hohoanɨmondahandowohü ŋgusüfo pandɨhinɨmboane,” yahu koamarɨhepurɨ. ");
INSERT INTO agg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ndüfusi nendɨ-memo ranai ahandɨ hoafɨ ra hɨmborɨyomo houmbo ndamefundɨ. Ai nafɨna hɨfomondane, sapo mupui hüfɨhamɨndɨ süfuanɨ tüküfe mamaro ra asükaiyomo hoeimarundɨ. Mupui ranai ahamundɨ haŋgɨfoanɨ hɨfo nɨmorɨ nɨmarümbɨ worɨ ranɨ nɨmoamo mamaro. ");
INSERT INTO agg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ranɨyomo mupui ra hoeirundanɨ mayowa ai afɨndɨ hɨhɨfɨ-hɨhɨfɨmemo. ");
INSERT INTO agg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ranɨyomo asu ai worɨmayo ranambe kefou hɨfomo nɨmorɨ ranahambo hoeimarüwurɨ ahandɨ hondɨ Maria radɨbo. Ranɨyomo asu ai ahandɨ fikɨmɨ pütapɨyomo yirɨ yimbu pusɨru nɨmarɨmombo ahambo hohoanɨmoyomondühɨ ŋgusüfo pamarüwurɨ. Ranɨyomo ai ahamundɨ arambeahɨndɨ napo ra bokaründümo houmbo masabudo. Ranɨ-moatükunɨ ra gorɨyo, fɨsɨŋarümbɨ mbɨmbɨrayo asu sanda aboedɨyo, ŋgɨnɨndɨ napo ra masabudo. ");
INSERT INTO agg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nindou ranahamumbo God ai yafogoadɨ-namboya, “Se Herot nɨmaru nafɨ ŋgomboemo,” mehupuramboemo. Asu süŋgunambo ai ranɨnafɨ hɨnɨŋgɨru hou ŋgorü nafɨ ahamundɨ hɨfɨna mahomo. ");
INSERT INTO agg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nindou ranai ndaweyafundane ranɨ-sɨmboanɨ Adükarɨndɨ nendɨ ranai Sosepɨmbo yafogoadɨnambo tükümefiyu. Asu ai hoafɨyundühɨ yahuya, “Botɨndafo, nɨmorɨ ranani asu ahandɨ hondane ra ndowapɨndɨfɨ hawa Isip hɨfɨna feboehi ŋgei ranühɨ nɨmboeianɨ asu ro hombo hoafɨndahanɨ anɨmbo ŋgoründühɨ ŋgei. Nɨmboe Herot ai nɨmorɨ ranahambo hɨfokoefimbo kokondürɨ wakɨndirümbui,” yahu hoafɨmenduamboyu. ");
INSERT INTO agg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ranɨyu Sosep ai botɨfi nɨmorɨ ra serümündü haya ahandɨ hondɨ ranɨdɨbo mare ranɨ nɨmbokoanɨ Isip hɨfɨnambo mahei. ");
INSERT INTO agg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hɨfɨ ranühanɨmbo ai nɨmboeianɨ Herot ai yɨfɨndümbui. Adükarɨ ai ahandɨ hoafɨyu-randeimbɨ ahandɨ yafambe süŋgure haya hoafɨyuhüya, “Ro wandɨ Nɨmorɨ Isip hɨfambeahɨndɨ mborai masahando,” mehu. Hoafɨ ra moanɨ anɨhondü hondü tükündɨfemboe yaho hayamboyo ranɨ moatükunɨ ranai yare yahurai tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hüfɨhamɨndɨ süfuanɨpoedɨ ndüfosi nendɨ masɨfomo ranai ahambo ŋgorü-süŋgumarüwurɨ ra Herot ai kɨrɨhai fɨfɨre hayamboyu asu ranɨmbo ahambo ŋgɨnɨndɨ ŋgusüfoambe fondɨrɨmɨndɨ mahafo. Ranɨyu asu ai muŋguambo nindowenihɨ nɨmorɨ yimbu hɨmbanɨkoateyeimbɨ Betrehem ŋgoafɨhündɨ asu ŋgoafɨ amurɨ ranɨ ŋgoafɨ-kɨmɨ adaburo ranambeahɨndɨ hɨfokoakofoefembo hoafɨ masendɨ. Sapo nindou hüfɨhamɨndɨ süfuanɨpoedɨ ranai hoafɨmemo ranɨ-sɨmboanɨ mupui tükümefeyo hoafɨ ra fɨfɨre hayamboyu asu ai yare hoafɨmepurɨ nɨmorɨ ra hɨfokoakofoefembo. ");
INSERT INTO agg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ndanɨ-moatükunɨ tükümefeyo ra sapo Godɨndɨ hoafɨ hoafɨyu randeimbɨ nindou Seremaiandɨ yafambe süŋgure haya horombo hoafɨmareandɨ ra sɨmogodühɨ tüküfemboyo yare tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Sapo ai yare hoafɨyuhü yahuya, “Ramahündɨ ai yasɨmondɨ mamɨ hɨmborɨyei. Aranɨ hoafɨ afɨndɨ puküna asu aranɨ hoafɨ yambohai tükɨfeyowa hɨmborayei. Reser ai ahandɨ amoao mamɨ Israerɨhündɨ nɨmorɨ ranaheimbo aranɨnamborandüra asu muŋguambo nindou ranai ŋgɨrɨ ahambo dɨdɨboadondɨhindɨ ahandɨ ŋgusüfoambe farɨhefembo. Nɨmboe sapo ahandɨ nɨmorɨ ranai nɨŋgokoatemayeiambo wambo,” mehu ranɨ-süŋgumbo. ");
INSERT INTO agg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Süŋgunambo Herot ai yɨfɨyuane asu Adükarɨndɨ nendɨ ranai yafogoadambe Sosepɨmbo Isip hɨfɨhü tüküfi hoafɨyundühɨ yahuya, “Se amborɨ ndowapɨndɨfɨ hawa hɨhɨrɨndafo Israerɨnambo ŋgafɨ. Nindou sapo nɨmorɨ ranahambo hɨfokoefimbo hohoanɨmomemo ranai ana yɨfɨmemo,” mehundoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ranɨyu asu Sosep ai botɨfi nɨmorɨ ra serümündü haya hondambo kameihɨ asu ai hɨhɨrɨyahi Israer hɨfɨnambo mahüsi. ");
INSERT INTO agg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Asu Arkeraus ai ahandɨ afɨndɨ Herot ranahandɨ fondühɨ Sudia-yafe adükarɨ bogorɨmbofi manüŋgu ranɨ hoafɨ ra Sosep ai hɨmborɨyu haya ranühɨ nɨŋgombo hombo ra yɨhɨmbomayu. Ŋga asu God ai yafogoadambe Sosepɨmbo bɨdɨfɨrɨ hoafɨ masagadoamboyu asu ai Gariri hɨfɨnambo mahu. ");
INSERT INTO agg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ranɨyu asu ai hu ŋgoafɨ mamɨ ahandɨ ndürɨ Nasaret ranühɨ manüŋgu. Sapo mamɨ ranɨ-süŋgumbo anɨmbo God ai ahandɨ hoafɨyomo rundeimbɨ süŋgu hoafɨyomondühɨya, “Nindou ranahambo Nasaretɨhündɨ nindou mbɨseimboyei,” mehomo yahurai anɨhondü tüküfembohündamboyo yahurai tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ranɨ-sɨmboanɨ Son hɨmonɨ hundürüra-randeimbɨmayu tükümefiyu. Nindou ranai nɨmɨ wohɨ furɨkoatereandühɨ Sudia hɨfambe ranühɨ manüŋgu. Ai piyu haya nindou ranɨ hɨfɨhü amarei ranaheimbo Godɨndɨ hoafɨ ra bokarɨhai marandɨ. ");
INSERT INTO agg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ranɨyu asu ai yare hoafɨyuhü yahuya, “Awi, se sɨhei moaruwai hohoanɨmo ranahambo daboadanambondɨhindɨ, ŋga God ŋgɨnɨndɨ hɨfandarandɨ ra ndeara moanɨ akɨmane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sapo Son ranahamboyu God ahandɨ hoafɨ hoafɨyu randeimbɨ nindou Aisaia ranahandɨ yafambe süŋgure hoafɨyuhüya, “Nindou mamɨ ai nɨmɨ wohɨ furɨkoatereandühɨ muŋgɨyuhü yare hoafɨyuhüya, ‘Adükarɨndɨ nafɨ se dɨdɨboadondɨhindɨ. Ai hombo-memo nafɨ ra ndondondɨhi hɨnɨŋgɨndɨhindɨ,’ mehu ra,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Son ai hoearɨ ahandɨ güdemarandɨ ranana kamer nɨnɨhondɨ nɨnendɨnambo nafɨyoweimbɨhündɨyo. Asu ai nɨnɨhondɨ hoearɨhündɨ tɨtapürɨmbore güdehaya botɨfohü asu wohɨ yɨtɨhɨ nɨmambeahɨndɨ, efu hoe ranɨyu sesü marandɨ. ");
INSERT INTO agg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ranɨyei asu nindou ranai Serusarem ŋgoafɨhündɨ, muŋguambo Sudia hɨfɨ ranɨhündɨ asu muŋguambo hɨfɨ Sodan Hoe ranɨkɨmɨ adaburo ranühündambo ai Son sowana masühüsi. ");
INSERT INTO agg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ranɨyei nindou ranai ahei moaruwai hohoanɨmo süŋgumarɨhi hei ranahambo weindahɨmarɨhinda asu ai aheimbo Sodan hɨmo hundürürarü marandɨ. ");
INSERT INTO agg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ŋga Son ai hoeireapurane Farisi asu Sadyusi afɨndɨ ranai ahamboya, “Yɨhoefombo ai hɨmonɨ hundürümbɨramunɨ,” yahomo houmbo ahambo sowana mahomonda hoeimareapurɨ. Ranɨyu asu ai ahamumbo hoafɨyupurühɨ yahuya, “Awi seana amoasɨrɨndɨ nɨmor-anemo! God ai sɨhamumbo ŋgɨnɨndɨnduhɨ moaruwaimbo ndeapurɨmbui. Se nüŋgundafu mafebou? ");
INSERT INTO agg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Se moaruwai hohoanɨmo ranahambo daboadanambo-rundeimbɨhündɨ ana asu sɨhamundɨ nɨne ratüpurɨ rawarundɨ ra se moaruwai hohoanɨmo hɨnɨŋgɨfembo nafuimbendüramboane. ");
INSERT INTO agg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Se ŋgɨrɨ randu borɨndɨmondühɨya, Roana Suda anefɨ, Roana Abrahamɨndɨ amoao mamɨwambo aboedambo-ndahumboyefɨ, mbɨsɨmo. Awi ro sɨhamumbo hoafehapurɨ God aiana moanɨ nɨmoei kurayo ranamboanɨ ndemündɨ haya Abrahamɨndɨ amoao mamɨmbonde hɨnɨŋgɨndeambui! ");
INSERT INTO agg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nɨmɨ sɨrahambe pɨrɨfɨrɨhefembohünda ndeara tɨme ranai ndoramɨndɨ eŋgoro. Muŋguambo nɨmɨ ra nahanɨyo ai aboedɨ hɨsɨkoateayo ana, ranahambo tɨme ranambo hɨtɨhefe hefe haiambe pütifemboane. ");
INSERT INTO agg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Roana se moaruwai hohoanɨmo ra hɨnɨŋgɨrɨhimboanei ranɨmbo nafuimbohünda hɨmonɨ hundürarɨharü. Ŋga nindou ŋgorü ai wandɨ wagabe tüküfemboayu ranai ana sɨheimbo Yifiafɨ Aboedɨnambo asu hai ranambo hundüründarümbui. Aiana moanɨ adükarɨ hondüyuwanɨ asu ro ranɨ hoarehanahɨ. Roana awi aboedɨ ndearɨhamɨndɨyahɨpoanɨ ahandɨ su ra semɨndɨndombo. ");
INSERT INTO agg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Rananɨmbo ai fok warambe ndemündɨ haya ranambo wit hɨpɨrɨ ra futɨnde fɨndamündɨ pindendambui. Asu ai wit safɨ aboedɨ ranɨ-yaŋgɨrɨ ndemündɨ ahandɨ wit sɨhefembo worɨ-mayo ranambe dɨgembui. Ŋga asu hɨpɨrɨ moaruwai moanɨ yaŋgorombo rananɨmbo ai ndemündɨ sapo hai dɨkɨrɨfekoate moanɨ yare koadürümbo koadürümbo horoweimbɨ ranambe pütindɨfimbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mamɨ ranɨ-sɨmboanɨ Sisas ai Gariri hɨfɨ hɨnɨŋgɨre haya Sodan hɨmona mahanu. Son sowana ŋgahanɨ ai wambo ahandɨ warɨna hɨmonɨ hundürɨmbɨrandɨrɨ, mehu. ");
INSERT INTO agg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ŋga asu Son ai ahambo ŋgorü hohoanɨmonambo yare hoafɨyundowohü yahuya, “Seanɨmbo wambo hundürüyondɨrɨmbo-mayafɨ asu sɨmborɨ se wambo-sowana asɨnɨfɨ ro sɨhambo hundürüyonɨnɨmbo,” mehundoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Asu Sisas ai sɨmborɨ ahambo hoafɨyundühɨ yahuya, “I ambe, ŋga hapondanɨ ana moanɨ ro hoafayahɨ süŋgu randowandɨ. Se randowandanɨ moanɨ ranɨ süŋgu mbumundɨ hohoanɨmo muŋgu sɨhɨrɨ nafɨndɨhumɨndefomboane, ŋga ra aboedane,” mehundoamboyu. Asu Son ai hɨmborɨyu haya refembo-ane mehu. ");
INSERT INTO agg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Son ai Sisasɨmbo hɨmonɨ hundürürɨ hayamboyu ane, Sisas ai mamɨharɨ hɨmonɨndɨ tükümefiyu. Ranɨyo asu sünambe sünü ahambo bureandühɨyo asu Godɨndɨ Yifiafɨ ranai wupufo nahurai kosɨ ahandɨwamɨ pühɨmayoa hoeimareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ranɨyo asu yasɨmondɨ mamɨ ranai sünambeahɨndɨ kosowohü yare hoafɨyowohü yahoya, “Nindou ranana wandɨ nɨmorani, ŋga moanɨ ro ŋgusüfo parɨhineimbani. Ahamboane Ro wambo ŋgusüfoambe siaoweheandɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ranɨyo asu ranɨ-sɨmboanɨ Yifiafɨ Aboedɨ ranai Sisasɨmbo Satan ai sɨsɨhɨmombohünda nɨmɨ wohɨ furɨkoatereandühɨ serɨmɨndɨ maho. ");
INSERT INTO agg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","40 si ra Sisas ai sesɨkoate nüŋgu mbura asu ai wembombomayu. ");
INSERT INTO agg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Asu Satan, nindou sɨsɨnda-randeimbɨ ai ahambo-so tüküfi hoafɨyundühɨ yahuya, “Se Godɨndɨ Nɨmorayafɨ ana, nɨmoei kurayo ndanahambo hoafɨndafanɨ sesɨmbofe tükümbɨfeyowamboane,” mehundoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Asu sɨmborɨ Sisas ai hoafɨyuhü yahuya, “Godɨndɨ Bukambe yahoya, ‘Sesɨ yaŋgɨrɨ ana ai ŋgɨrɨ nindoundɨ yaŋgɨrɨ nɨŋgombo ndendɨ. Nindou ai yaŋgɨrɨ nɨŋgombo sahümündi arɨhündɨ ra muŋgu hoafɨ Godɨndɨ yafambeahündɨ süŋgu mbɨsahümündi,’ meho,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ranɨyu asu Satan ai Sisasɨmbo Godɨndɨ adükarɨ ŋgoafɨ Serusarem ranɨ-nambo serümündü hu haya hafumbo nɨmoamo hamɨndɨ Godɨndɨ Worɨ Adükarɨ bogɨmondɨ ranɨwamɨ hɨnɨŋgɨmarirɨ. ");
INSERT INTO agg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ranɨyu asu ai Sisasɨmbo hoafɨyundühɨ yahuya, “Asu se Godɨndɨ Nɨmorayafɨ ana, nɨmoamo ndanɨ-wamɨnɨndɨ hɨfɨnɨ horɨpɨndafo pɨndafɨ. Sapo Baiborambe yare hoafɨyowohü yahoya, ‘God ai sɨhambo ahandɨ sünambeahɨndɨ nendɨ ranahamumbo hoafɨnduanɨ asu ai sɨhambo ahamundɨ warɨnambo mbundɨndɨnɨnɨmboemo asu ŋgɨrɨ nɨmoei hoarehɨ kurayo ranai sɨhambo futɨndeanɨnɨ,’ meho,” mehundoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Asu Sisas ai ahambo yahuya, “Ŋga awi Baiborambe hoafɨ ranamboanɨ ai yare hoafɨyowohü yahoya, ‘Se Adükarɨ sapo sɨhafɨ God ranahambo rando hoeindorɨmboyafɨ, ŋga yowanɨ,’ meho,” mehundoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ranɨyu asükaiyu Satan ranai Sisasɨmbo serümündü hɨfɨ wafu nɨmoamo hamɨndɨ-mayo ranɨwamɨ mahafu. Ranɨyu ai ranɨwamɨ nüŋgumbo Sisasɨmbo muŋguambo nindou-yafe hɨfandarundɨ ranɨyo asu ahamundɨ muŋguambo aboedɨ adükarɨ moatükunɨ eŋgoro ranahambo nafuimefoendo. ");
INSERT INTO agg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ranɨyu asu Satan ai hoafɨyundühɨ yahuya, “Asu se yirɨ yimbu pusɨrowandühɨ wambo hohoanɨmoyafɨndɨrühɨ ŋgusüfo pararowandɨrɨ ana, asu ro sɨhambo muŋgu moatükunɨ nafuimehanɨnɨ ra ndahanɨnɨmboyahɨ,” mehundoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Asu Sisas ai ahambo hoafɨyundühɨ yahuya, “E! Satan, se andai ragu ŋgafɨ! Baiborambe hoafɨ ranai yare hoafɨyowohü yahoya, ‘Adükarɨ sapo sɨhafɨ Godɨmayu ranahambo yaŋgɨranɨmbo se hohoanɨmondafɨ ŋgusüfo pandoworühɨ asu ahandɨ ratüpurɨ yaŋgɨrɨ ratüpurɨndafɨ,’ meho,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Asu Satan ai Sisasɨmbo yare hɨnɨŋgɨmarira ndamefiyua asu Godɨndɨ nendɨ ranai kosɨmo ahambo farɨhouwurühɨ hɨfandɨmarürɨ. ");
INSERT INTO agg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sonɨmbo sowaründümo karabusambe hɨnɨŋgɨmarüwurɨ hoafɨ Sisas ai hɨmborɨyu haya Gariri hɨfɨna mahu. ");
INSERT INTO agg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Asu ai Nasaret ŋgoafɨhü hɨnɨŋgɨre haya Kaperneam ŋgoafɨ sapo Gariri kurɨhoe ranɨkɨmɨ ŋgoafɨ ranɨna mahu. Kaperneam Seburun hɨfɨ, Naptari hɨfambe eŋgoro ranühɨ manüŋgu. ");
INSERT INTO agg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","15","Sapo God ai ahandɨ hoafɨ hoafɨyu-randeimbɨ nindou Aisaiandɨ yasɨmondɨ süŋgu yare hoafɨyuhüya, “Seburun hɨfɨ, Naptari hɨfɨ, Gariri hoe nafɨ howanɨ gogu ra, Sodan hoe gogoanɨnɨ ra nindou Sudayafe ndɨfoyei Gariri hɨfane. ");
INSERT INTO agg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nindou dɨdɨyei ai nɨmbɨ nɨmaroambe anɨmboei ranai ana si adükarɨ ra hoeirɨhimboanei. Yɨfɨyorambo hɨfɨ ranambe nɨmbɨ nɨmaroanɨ nindou anɨmboei ranaheimbo ana si ranai boakɨfoareandürɨmboane,” mehu, ŋga ranɨ-sɨmoŋgorühümboyo ranɨ-moatükunɨ ra yahurai tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ranɨyu asu ranɨ-sɨmboanɨ piyu haya Sisas ai ahandɨ hoafɨ ra bokarɨhendühɨ yahuya, “Awi se sɨhei moaruwai hohoanɨmo ranahambo daboadanambondɨhindɨ, nɨmboe sapo God ŋgɨnɨndɨ hɨfandarandɨ eŋgoro ranai ndeara akɨmɨ tüküfembo yaŋgɨrane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sisas ai Gariri kurɨhoekɨmɨ huane kinɨ wowarɨyafanɨ rɨnandeimbɨ apodoho ranai manɨmbafanda hoeimareapɨrɨ. Ahafandɨ ndürɨ ra Saimon, Pitamboyu-randeimbɨ asu ahandɨ akɨdɨ Andruyu. Apodoho ranai andürɨnambo kurɨhoe ranambe kinɨ wowarɨyafandühɨ manɨmbafanɨ. ");
INSERT INTO agg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ranɨyu asu Sisas ai hoafɨyupɨrühɨ yahuya, “Se mborai wandɨ süŋgu sɨnɨfandanɨ anɨmbo asu ro sɨhafanɨmbo nindou semɨndɨmbo se kinɨ rawarɨneandɨ nou nafuindahapɨrɨmboyahɨ,” mehupɨramboyafanɨ. ");
INSERT INTO agg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Asu ai moanɨ hoafɨ nɨŋgoambe ahafandɨ andürɨ ra rarɨne sɨhene hena Sisasɨndɨ süŋgu ndamefɨneandɨ. ");
INSERT INTO agg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Asükaiyu ai sühüfi huhündamboyu ŋgorü apodoho ahafandɨ ndürɨ Sems, Son ai ahafandɨ afɨndɨ Sebedi babɨdɨ botambe nɨmarɨmombo ahamundɨ andürɨ ra dɨboadorundühɨ mamarɨmonda hoeimareapurɨ. Asu ai ahafanɨmbo mborai mehupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Asu moanɨ hoafɨ nɨŋgoambe ahafandɨ bot asu afɨndambo rarɨne hɨnɨŋgɨrɨne hena Sisasɨndɨ süŋgu ndamefɨneandɨ. ");
INSERT INTO agg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ranɨyu asu Sisas ai Gariri hɨfɨ muŋgu ranambe nüŋgu wakɨmareandɨ. Ranɨyu asu ai refihɨ Suda-yafe rotu worɨ nindou ranambe aheimbo yamundɨmareandürɨ. Asu ai refihɨ God ŋgɨnɨndɨ hɨfandarandɨ eŋgoro Aboedɨ Hoafɨ ranahambo bokarɨmarɨhendürɨ. Mamɨ ranɨ sɨmboanɨ nindou ranahei fi ranai moanɨ ranɨpoanɨmbo ranɨpoanɨmbo aŋgünɨ fi moaruwaimboareandürɨ ranahambo aboedɨmarearü. ");
INSERT INTO agg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ai ranɨ-moatükunɨ rawareandɨ ranahambo Siria hɨfɨ muŋgu ranambe nindou amarei ranai hɨmborɨmayei. Asu ranɨyei muŋguambo nindou ranai nindou dɨdɨyei ai moanɨ mamɨkarɨ aŋgünɨ moaruwai asu asübusɨ afɨndɨ mamɨkararandürɨ ranaheimbo ahambo-so fufurühümündihündürɨ mafandɨhindɨ. Bɨdɨfɨrɨ nindou moaruwai nendɨ ahei fiambe nɨmarümbɨ, wunünümboyeimbɨ asu yirɨ warɨ yɨfɨsafeimbɨ ranɨyei ai mafandɨhinda asu Sisas ai aheimbo aboedɨmarearü. ");
INSERT INTO agg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ranɨyo asu nindou afɨndɨ ranai Gariri hɨfɨhündɨ, Dekaporis ŋgoafɨhündɨ, Serusarem ŋgoafɨhündɨ, Sudia hɨfɨhündɨ asu Sodan hoe gogoanɨnɨpoedɨ ranai mamɨ muŋgu ahambo süŋgumarɨhorɨ hei. ");
INSERT INTO agg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sisas ai hoeireandürane nindou afɨndɨ ranai ahandɨ süŋgu tümareandamboyu asu ai hafu hɨfɨ wafu mamɨ ranɨwamɨ nɨmaru ane asu ahambo süŋgururü-rundeimbɨ ai ahambo sowanambo masɨfomo. ");
INSERT INTO agg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ranɨyu asu Sisas ai ahamumbo piyu haya yamundɨmareapurɨ. ");
INSERT INTO agg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ranɨyu ai ahamumbo yare hoafɨyupurühɨ yahuya, “Nindou dɨdɨyei ai rarɨhi hoafɨyeihüya, Roana Godɨndɨ aboedɨ sürühoeimbɨ hohoanɨmo ra mbonɨmborɨ humɨndefɨ-mboanefɨ, asei ana, nindou ranai hɨhɨfɨ-hɨhɨfɨmbeyei-amboane, ŋga God ŋgɨnɨndɨ hɨfandarandɨ ranɨ hoarehɨ anɨboadei. ");
INSERT INTO agg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nindou dɨdɨyei ai aranɨ aranɨyei hei ranai ana hɨhɨfɨ hɨhɨfɨmbeyei-amboane, ŋga nindou ranaheimbo ana God ai dɨdɨboado-ndearühɨ yirümondearümbui. ");
INSERT INTO agg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nindou dɨdɨyei ai hɨmboarɨ yaŋgɨrɨ hɨfandühündeimbɨ-mayei aiana hɨhɨfɨ-hɨhɨfɨmbeyei-amboane, ŋga nindou ranai ana nɨnɨ-moatükunɨ God ai aheimbo saimbo yahuhaya masɨhendɨ ra ndahümündimboyei. ");
INSERT INTO agg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nindou dɨdɨyei ai Godɨndɨ mbumundɨ hohoanɨmo ranahambo semɨndɨmbo wembohühɨ nouehindɨ asu hoe sɨmɨndɨmbo amɨndanɨŋombo nouehindɨ ana, aiana hɨhɨfɨ-hɨhɨfɨmbeyei-amboane, ŋga God ai aheimbo mbumundɨ hohoanɨmo ra dagadürümbui. ");
INSERT INTO agg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nindou dɨdɨyei ai nindou ŋgorümbo moanɨ hɨpoamboarɨhündɨ ranai ana hɨhɨfɨ-hɨhɨfɨmbeyei-amboane, ŋga God ai hɨpoambondearümbui. ");
INSERT INTO agg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nindou dɨdɨyei ai ahei ŋgusüfoambe moanɨ aboedɨ sürühoeyoweimbɨ hohoanɨmo ra amarondürɨ ana, aiana hɨhɨfɨ-hɨhɨfɨmbeyei-amboane, ŋga aiana God amaru ranahambo hoeindɨhorɨmboyei. ");
INSERT INTO agg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nindou dɨdɨyei ai moanɨ nindouyei mbusümo raranɨ moatükunɨmbo borɨfoeferambo yaŋgɨrɨ nindouayei ana, aiana hɨhɨfɨ-hɨhɨfɨmbeyei-amboane, ŋga nindou ranai ana aheimboya aiana Godɨndɨ nɨmoranei, mbɨseimboyei. ");
INSERT INTO agg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nindou dɨdɨyei ai mbumundɨ hohoanɨmo yaŋgɨrɨ süŋgurɨhindanɨ, asu ranɨmbo nindou amurɨ ai aheimbo tɨŋɨrɨfo sahündürühɨ moaruwai moaruwaimbo-arɨhindürɨ ana, asu nindou ranai ana hɨhɨfɨ-hɨhɨfɨmbeyei-amboane, ŋga God ŋgɨnɨndɨ hɨfandarandɨ sünambe ra ahei-ane. ");
INSERT INTO agg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nindou bodɨmondɨ ai sɨhamumboya, Aiana Sisasɨmbo süŋgururü rundeimb-anemo, mbɨseihümbo, sɨhamumbo moaruwai moaruwaimbo ndɨhipurühümbo, moanɨ moaruwai wosɨhoaforɨ moatükunɨ wataporɨ hoafɨndühüpuranɨ ana, asu se ranɨmbo hɨhɨfɨ-hɨhɨfɨndɨmo. ");
INSERT INTO agg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Asu se ŋgusüfoambe aboedɨ kündundühɨ afɨndɨ hɨhɨfɨ-hɨhɨfɨna nɨŋgomo sapo adükarɨ moatükunɨ takɨnɨ ra ai sünambe mbeŋgorɨpurɨ. Sapo Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ se nɨŋgomondɨ daboadanɨ manɨŋgomo ranahamumbo amboanɨ nindou ai rarɨhi yahurai moaruwaimbo marɨhipurɨ.” ");
INSERT INTO agg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Seana hɨfɨnɨndɨ nindou ranahei aparümbɨ namɨ nahurai-anemo. Ŋga asu namɨ ranai ahandɨ aparɨ ra hɨnɨŋgɨreandühɨ wanayo ana, asu namɨ ra budesowanɨ aparɨ-koatendoanɨ ŋgɨrɨ ahandɨ aparɨ ra koadürü koadüründɨfe hɨnɨŋgɨndɨfeyo, ŋga wanɨ. Ranana ranɨ moatükunɨ ranai ndeara moaruwaimayoa nindou ai ŋgɨrɨ ndahümündi ranambo ranɨmbondɨhindɨ, ŋga pifeyoanɨ nindou ai pütapɨyeihanei. ");
INSERT INTO agg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Seana muŋguambo hɨfɨnɨndɨ nindou ranahei si nahurai-anemo. Ŋgoafɨ adükarɨ hɨfɨ wafuambe anaŋgo ranai ŋgɨrɨ dɨbo naŋgo. ");
INSERT INTO agg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nindou ŋgorü ai ŋgɨrɨ ram hai ra yimunde mbundambo wambürɨ hoarehɨ ragu nindeandɨ, ŋga wanɨ. Ŋga ai moanɨ nɨmoamo moanambühɨ anɨmbo nindeandanɨ asu si ranai nindou muŋguambo ranɨ worambe amarei ranaheimbo si boakɨboadeandürɨmboe. ");
INSERT INTO agg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Moanɨ mamɨ ranɨ-süŋgumbo anɨmbo sɨhamundɨ si ranamboanɨ nindou ranahei hɨmboahü si boakɨboadeandüranɨ, asu ai nɨne aboedɨ moatükunɨ rawarundɨ ra hoeindɨhindühɨ rananɨmbo asu ai sɨhamundɨ Ape sünambe amaru ranahambo aboedani mbɨsei-amboane.” ");
INSERT INTO agg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ro masɨnɨhɨ nda sapo Godɨndɨ hoafɨ hoafɨyomo rundeimbɨ yomondɨ hoafɨ meŋgoro asu Mosesɨndɨ ahɨnümbɨ hohoanɨmo ra raguanambofembo sɨnɨmboyahɨpoanɨ, ŋga asu se randu hohoanɨmondɨmboemo, ŋga wanɨ. Ŋga roana ranɨ hoafɨmayo ranɨfihɨ sɨmoŋgorɨyɨmɨndɨmboyahɨ masɨnɨhɨ. ");
INSERT INTO agg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sɨhamumbo ndanahambo anɨhondümbo anahɨ hoafɨyahɨpurɨ, süŋgunambo sünü hɨfɨ ranai muŋguyoambe ra ahɨnümbɨ hohoanɨmo ranahandɨ sürü pamefeyo ane, asu ranahandɨ sɨsamane ranɨ-moatükunɨ ra akɨdou amboanɨ ŋgɨrɨ awarɨndɨhoayo, ŋga wanɨ. Ŋga ahɨnümbɨ hohoanɨmo moatükunɨ ra rande moanɨ yagodɨ ŋgo ŋgombo muŋguambo moatükunɨ ranai tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ranɨmboane nindou düdi ai moanɨ akɨdou amboanɨ ahɨnümbɨ hoafɨmayo ranahambo hɨmborɨkoateyuhü, asu ai nindou bodɨmondambo mare ranɨ hohoanɨmo süŋgu yamundareandürɨ ana, nindou ranɨmayu ranahandɨ ndürɨ ra moanɨ akɨdou hamɨndɨ God ŋgɨnɨndɨ hɨfandarandɨ ranambe yagodomboe. Ŋga asu nindou düdi ai ahɨnümbɨ hohoanɨmo ranahambo hɨmborɨyu ranɨ-süŋgureandühɨ, asu ai nindou bodɨmondambo mare ranɨ hohoanɨmo süŋgu yamundareandürɨ ana, nindou ranɨmayu ahandɨ ndürɨ ra God ŋgɨnɨndɨ hɨfandarandɨ ranambe adükarɨ hamɨndɨ yagodomboe. ");
INSERT INTO agg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ro sɨhamumbo nda hoafehapurɨ, sɨhamundɨ mbumundɨ hohoanɨmo ranai ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ nindou-anemo asu Farisi nindou-anemo ranahamundɨ mbumundɨ hohoanɨmo ranahambo ŋgasündɨfekoateayo ana, se ŋgɨrɨ God ŋgɨnɨndɨ hɨfandarandɨ ranɨ-hoarehɨ nɨmandɨmo, ŋga wanɨ.” ");
INSERT INTO agg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Se hɨmborɨyomombo-anemo horombo sɨhamundɨ amoao ai hoafɨ ra masowandümo. Yare hoafɨyohü yahoya, Se yowanɨ nindou hɨfokoefepoanɨ. Nindou düdi ai ŋgorümbo hɨfokoararirɨ ana, ahambo nindou yɨbobore-randeimbɨ-mayu ranahandɨ hɨmboahü semündü homboani, mehomo ra. ");
INSERT INTO agg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ŋga asu hapo ro sɨhamumbo hoafehapurɨ nda, nindou düdi ai ahandɨ wandafɨ ranahambo ŋgɨnɨndɨ hɨmboahoeyu ana, sapo yɨbobore randeimbɨ-mayu ranahandɨ hɨmboahü semündü homboani. Asu nindou düdi ai ahandɨ wandafɨ ranahambo yare hoafɨyundühɨya, Seana fɨfɨrɨfe koate-anafɨ, ehundo ana, nindou ranahambo kansɨr bogorɨ ranahamundɨ hɨmboahü semündü homboani. Asu nindou düdi ai ahandɨ wandafɨ ranahambo yare hoafɨyundühɨya, Seana hohoanɨmokoate-anafɨ, ehundo ana, nindou ranai hɨbadambo, hai ŋgoafambe homboani asu ranühɨ hai ahambo tɨkɨndɨrɨmboe. ");
INSERT INTO agg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ranɨmboane asu se nɨnɨ-moatükunɨ Godɨmbo saimbo fondɨ-mayo ranɨwamɨ sɨhefembo safɨ hawamboyafɨhünda asu sɨhafɨ wandafɨndandɨ-mayo hoafɨ sɨhambo eŋgoro ra hohoanɨmondafühɨ ana, asu se nɨnɨ-moatükunɨ Godɨmbo saimbomayafɨ fondɨkɨmɨ rando dɨgoefɨ hawa ŋgafɨ. Sapo sɨhafɨ wandafɨ-mayu ranɨdɨbo aboedɨ aboedɨndafɨne mbundɨnambo anɨmbo süŋguna ŋgafɨ sɨhafɨ sɨhefembo moatükunɨ-mayo ra Godɨmbo dabado. ");
INSERT INTO agg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Asu nindou ŋgorü ai sɨhambo papɨ-hoafɨyonɨnɨmbo mbüsü haya yɨbobore randeimbɨ nindou ahambo sowanɨmbo hombo sɨhambo ndemündünɨnanɨ ana, se nɨmai ŋgafɨ nafɨnɨ aboedɨ aboedɨndafɨneandɨ. Ŋga asu hɨbadambo sɨhambo ai papɨ-hoafɨ ranambe sɨndeanɨnɨmbui. Asu se ranambe efoandɨ ana, asu ai sɨhambo yɨbobore-randeimbɨ ranahandɨ warambendeanɨnanɨ asu ai ndemündünɨnɨ prismanɨndɨ warɨhündeanɨnanɨ asu ai sɨhambo karabusambe hɨnɨŋgɨndeanɨnɨmbui. ");
INSERT INTO agg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ro sɨhambo anɨhondümbo-anahɨ hoafehanɨnɨ. Asu se sɨhafɨ papɨ hoafɨ ranahambo kakɨ sɨhefekoateayafɨ ana, asu se ŋgɨrɨ karabus ra hɨnɨŋgɨndo hawa aboedambondafoandɨ, ŋga wanɨ. Ŋga se moanɨ rando karabus ranambe nɨmboamboyafɨ.” ");
INSERT INTO agg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Se hɨmborɨyomombo-anemo horombo yaru hoafɨyomondühɨ yahomoya, ‘Se yowanɨ nɨmorehɨ sɨsɨhɨmo asu nindowenihɨ bɨrabɨrɨpoanɨ,’ mehomo. ");
INSERT INTO agg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ŋga asu hapo ro sɨhamumbo hoafehapurɨ nda, nindou düdi ai nɨmorehɨ hoeire haya ahambo hohoaŋareandɨ ana, nindou ranai ahandɨ ŋgusüfoambe nɨmorehɨ sɨsɨhɨmoyumboani. ");
INSERT INTO agg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ranɨmboane asu sɨhafɨ hɨmboarɨ mamɨ ranai randeanɨnanɨ se moaruwai hohoanɨmondafanɨ ana, hɨmboarɨ ra hündandɨfɨ ragu pindowandɨ. Hɨmboarɨ mamɨ ranahambo yaŋgɨrɨ ragu moenda pife ranane aboedayo, ŋga asu muŋguambo fi ra haiambe ho ana, aboedɨ hamɨndɨyopoanɨ. ");
INSERT INTO agg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Asu sɨhafɨ warɨ mamɨ ranai randeanɨnanɨ se moaruwai hohoanɨmondafanɨ ana, warɨ ra kandandɨfɨ pindowandɨ. Warɨ mamɨ ranahambo yaŋgɨrɨ ragu moenda pife ranane aboedayo, ŋga asu muŋguambo fi ra haiambe ho ana, aboedɨ hamɨndɨyopoanɨ.” ");
INSERT INTO agg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Asükaiyo horombo hoafɨ ra yare hoafɨyowohü yahoya, Nindou düdi ai ahandɨ nɨmorehɨ ranahambo moei yahuhɨ hɨnɨŋgɨfembo mbüsuhɨ ana, ai nɨmorehɨ ranahambo hɨnɨŋgɨfe hoafɨ pepafihɨ sürü papɨndandühɨ anɨmboya, Ro nɨmorehɨ ndanahambo hɨnɨŋgɨfembo anahɨ, mbüsu, mehomo. ");
INSERT INTO agg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ŋga asu ro hapo sɨhamumbo hoafehapurɨ nda, nɨmorehɨ ranai nindou ŋgorü-dɨbo hokoateyowanɨ, asu ahandɨ nindowenihɨ ai moei yahuhü hɨnɨŋgɨreanda asu ai nindowenihɨ ŋgorü aserɨmɨndo ana, nindou ranai nɨmorehɨ semɨndɨ ahɨnɨ ra gogonɨmbo-foareandühani.” ");
INSERT INTO agg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Asükaiyomo se hɨmborɨyomombo-anemo, horombo sɨhamundɨ amoao ranahamumbo yare hoafɨyowohü yahoya, Se tɨkando hawa hoafɨndafühɨ nɨmoamo nda mbɨsamboyafɨ. Ŋga asu se nɨnɨ moatükunɨmbo dabarɨfihɨ nɨmoamo nda yahombo mbɨsafombo ana, se moanɨ anɨhondümbo mamanɨmbo randowadühɨ amboanɨ Adükarɨndɨ hɨmboahü yahurai dabarɨndafoandɨ, meho. ");
INSERT INTO agg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ŋga asu ro hapo sɨhamumbo hoafehapurɨ nda. Se nɨnɨmbo dabarɨfihɨ nɨmoamo nda yahopoanɨ, ŋga wanɨ. Se sünambe ranahambo dükefihɨ nɨnɨ-moatükunɨmbo ŋgɨnemɨndühɨ dabarɨfepoanɨ. Ŋga sapo sünü ranana Godɨndɨ muŋgu moatükunɨ ra hɨfandɨyo nɨmarɨmbo fondane. ");
INSERT INTO agg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Asu se nɨnɨmbo dabarɨfihɨ hɨfɨ ndanahambo dükefehümbo dabarɨfepoanɨ. Ŋga hɨfɨ ranana sapo God ai nɨmoamo ahandɨ fondɨwamɨ nɨmarümbo hɨfɨ ranɨ-fihani tɨŋarɨ türe amaru. Asu se Serusarem ŋgoafɨ ra ndürɨ dükefihɨ ranɨfihɨ dabarɨfepoanɨ. Ŋga Serusarem ranana Adükarɨ Bogorɨndɨ ŋgoafane. ");
INSERT INTO agg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Asu nɨne-hoafɨ ranahambo ŋgɨnemɨndɨmbohünda mbɨrofihɨ kife dabarɨfepoanɨ. Ŋgɨrɨ sɨhafɨhoarɨ mbɨrɨnaŋɨ mamamboanɨ ra randowadanɨ kɨfohɨndo asu nɨmbandɨndo ndandɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Se yɨnɨ ehomo ana, yɨnɨ yaŋgɨrɨ yɨnɨ mbɨsɨmo. Se wanɨ ehomo ana, wanɨ yaŋgɨrɨ wanɨ mbɨsɨmo. Ranɨ-hoafɨ ra moanɨ ndearane. Ŋga nɨne-hoafɨ ranɨfihɨ türe haya aho ranahambo se hoafemo ranana Satanɨndɨ-mayo hohoanɨmoane.” ");
INSERT INTO agg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Se hɨmborɨyomombo-anemo hoafɨ ra yare hoafɨyowohü yahoya, Nindou ŋgorü ai sɨhafɨ hɨmboarɨ nɨkondeandanɨ sɨmborɨ amboanɨ ahandɨ nɨkondowandɨ. Asu ai sɨhafɨ yahafɨ kaboadeandanɨ sɨmborɨ amboanɨ ahandɨ kaboadowandɨ, meho. ");
INSERT INTO agg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ŋga asu hapo ro sɨhamumbo hoafehapurɨ nda, nindou ai sɨhambo moaruwaimbo-ndeanɨnanɨ asu se sɨmborɨ moaruwaimbo-ndɨworɨmboyafɨ, ŋga wanɨ. Nindou ŋgorü ai sɨhafɨ koeho ra pakarɨndɨhenɨnanɨ asu ŋgorügoanɨnɨ amboanɨ ahambo hɨhɨrɨndowandɨ. ");
INSERT INTO agg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nindou düdi ai sɨhafɨ warɨ ambeimbɨ hoearɨ ra ai ndahamɨndɨ yahu haya sɨhambo papɨ hoafɨfembo randɨfiyuwanɨ ana, asu sɨhafɨ ŋgɨsɨharɨ hoearɨ ŋgorü ranamboa kameihɨ dabado. ");
INSERT INTO agg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nindou ai ahandɨ napo semɨndɨmbo, Se wandɨ napo ra ndowandɨfɨ hawa mamɨ kiromita nafɨ gebuai ra ŋgafɨ, mbüsuanɨ ana, asu se ŋgorü kiromita nafɨ gebuai ra tapandandɨfɨ hawa napo ra ndowandɨfɨ ŋgafɨ. ");
INSERT INTO agg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nindou ŋgorü ai sɨhambo nɨnɨ moatükunɨmboyu düdundüfinɨnanɨ moanɨ ahambo dabado. Asu nindou düdi ai sɨhafɨ-mayo nɨnɨ-moatükunɨmboyu semɨndɨ mburumbo saimbo mbüsüwanɨ ŋgɨrɨ ahambo daboadɨ hɨhɨndɨworɨ.” ");
INSERT INTO agg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Se hɨmborɨyomombo-anemo hoafɨ ra yare hoafɨyowohü yahoya, ‘Se sɨhafɨ ŋgunindambürɨ ranaheimbo hohoanɨmo pandowandürɨ asu sɨhafɨ hürütümbɨ nendɨ-mayei ranaheimbo moaruwai moaruwaimbo ndoandürɨ,’ meho. ");
INSERT INTO agg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ŋga asu hapo sɨhamumbo ro hoafehapurɨ nda. Nindou sɨhamundɨ hürütümbayei ranaheimbo se hohoanɨmo pandundürɨ asu nindou sɨhamumbo moaruwaimbo-arɨhindɨ ranaheimbohünda Godɨmbo dɨdɨbafɨndafundɨ. ");
INSERT INTO agg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Rananɨmbo se sapo sɨhamundɨ Ape God sünambe amaru ranahandɨ nɨmorɨ nɨŋgomboemo. Sapo ahandɨ hüfɨhamɨndɨ ra ai nindou moaruwai-anei asu aboedanei ranaheiwamɨ ai rareandanɨ boakɨfoareandühane. Asu ai hoe ra rareandanɨ nindou moaruwaiayei ranaheiwamɨ peyo asu nindou mbumundayei ranaheiwamɨ amboanɨ peyo randühane. ");
INSERT INTO agg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Asu se nindou sɨhamumbo aboedɨ hohoanɨmoyei rɨhündeimbɨmbo sɨmborɨ aheimbo aboedɨ hohoanɨmoemondürɨ ana, ranɨmbo asu God ai sɨhamumbo nɨnɨ-takɨnɨ madagapurɨyo? Nindouyei-mayo takis kakɨ sowandümo-rundeimbɨ aiamboanɨ yahurai yaru arundɨ. ");
INSERT INTO agg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Asu se sɨhamundɨ wandafɨ ranaheimbo yaŋgɨrɨ hɨhɨfaründürɨ ana, asu sɨhamundɨ hohoanɨmo ra nindou amurɨ ranaheimbo nüŋgundo ŋgasündɨmandowora? Nindou sapo Godɨmbo fɨfɨrɨfekoate-mayei ranai ranɨ hohoanɨmo se süŋguarundɨ ra aiamboanɨ süŋgurɨhindühanei. ");
INSERT INTO agg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ranɨmboane asu se moanɨ mbumundɨ hamɨndɨ hondü nɨŋgomo sapo sɨhamundɨ Ape sünambe moanɨ mbumundɨ hamɨndɨ hondü anüŋgu nou.” ");
INSERT INTO agg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Sisas yahuya, “Se hɨbadümbo! Se sɨhamundɨ aboedɨ ratüpurɨ ra nindou hɨmboahü randundanɨ asu nindou ai hoeindɨhimboyei, ŋga yowanɨ. Se ra süŋgu yaru randundanɨ ana, asu se ŋgɨrɨ aboedɨ takɨnɨ moatükunɨ sɨhamundɨ Ape sünambe amarundɨ-mayo ra ndowandümo, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ranɨmboane asu se nɨnɨ-moatükunɨyo nindou napokoateyeimbɨ ranaheimbo saimbo mbɨsafɨmbo ana, asu se nindou ŋgorümbo yɨnafoaimbohündambo, Se wambo horombondafo ŋgafanɨ anɨmbo nindou muŋguambo hoeimbɨrɨhindɨramboane, mbɨsamboyafɨ. Se nindou yafuiyambo horombo aho nou refe weindahɨ weindahɨyo hopoanɨ sapo yimbu yafambeimbɨ nindou ai rawarundɨ nou. Nindou ranai Suda-yafe rotu worambe asu nafɨ bogorɨ süŋgu yɨnafoai tütüru houmbo homo-arundɨ, ŋga se ai rarundɨ nou refepoanɨ, ŋga yowanɨ. Nindou ranai rawarundɨ ranana sapo nindou amurɨ ranai yɨhoefɨmboya, Aiana moanɨ nindou aboedɨ hamɨndanemo, mbɨseiya yahomombo-anemo rawarundɨ. Ro sɨhamumbo anɨhondümbo-anahɨ hoafayahɨ nda, nindou ranai ana takɨnɨ ahamundɨ ra ai ndeara sowandümombo-anemo. ");
INSERT INTO agg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ŋga asu se nindou napokoateyeimbɨ ranahambo farɨhefimbo hohoanɨmondafühɨ ana, dɨbo anɨmbo ahambo fandɨhaworɨ asu sɨhafɨ fikɨmɨnɨndɨ-amboanɨ nɨne-moatükunɨ se rawarowandɨ ranɨmbo ai fɨfɨrɨfekoatembeyeiamboane. ");
INSERT INTO agg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ranɨmboane asu sɨhafɨ saimbo hohoanɨmo ra dɨbo yaŋgoromboane. Rananɨmbo asu sɨhafɨ Ape sapo nɨnɨ-moatükunɨ dɨbo eŋgoro ra hoeireandeimbɨmayu ranai sɨmborɨ sɨhambo takɨnɨ masɨhendɨ-mayo ra daganɨnɨmbui.” ");
INSERT INTO agg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Se Godɨmbo dɨdɨbafɨndafundühɨ sapo yimbu yafambe hoafümbɨ nindou rawefundɨ nou randafumboemo. Ranɨ nindou ana muŋguambo nindou ai yɨhoefɨmbo hoeimbɨrɨhimuna yahomo houmbo-anemo. Suda-yafe rotu worɨ muŋguambo asu nafɨ tüküfihɨ aho ra botɨyafu weindahɨ nɨŋgomombo Godɨmbo dɨdɨbafɨmbo hohoanɨmoyomondühanemo. Ro sɨhamumbo anɨhondümbo-anahɨ hoafayahɨ, nindou ranai ana takɨnɨ ahamundɨ ra ai ndeara hɨfɨ ndanühünda sowandümombo-anemo. ");
INSERT INTO agg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ŋga asu se dɨdɨbafɨfembo mbɨsafombo ana, se worɨ safambe keboao ŋgüfɨ yipurɨ pando hawambo anɨmbo sɨhafɨ Ape moanɨ dɨbo amaru ranahambo dɨdɨbafɨndafoandɨ. Rananɨmbo asu sɨhafɨ Ape sapo nɨne-moatükunɨ dɨbo eŋgoro ra hoeireandeimbɨ-mayu ranai sɨmborɨ sɨhambo takɨnɨ daganɨnɨmbui. ");
INSERT INTO agg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Se dɨdɨbafɨndafundanɨ Godɨmbo fɨfɨrɨfe-koateyeimbɨ nindou rawarɨhindɨ nou randafundümboemo, ŋga yowanɨ. Nindou ranai Godɨmboya, Ai yɨhoefɨ hoafɨ hɨmborɨndümbui, sei hehi moanɨ afɨndɨ hoandarɨ hoafɨ hoafɨyeihɨ dɨdɨbafehindɨ. Ŋga se yahurai Godɨmbo moanɨ fɨfɨrɨfe-koate hoafɨ afɨndɨ dɨdɨbafɨndafu-mboemo, ŋga yowanɨ. ");
INSERT INTO agg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Asu se ranɨ-nindou yahuraindɨmondühɨ ahamundɨ-mayo hohoanɨmo ranɨ-süŋgundümboemo, ŋga yowanɨ. Sɨhamundɨ Ape ai nɨne-moatükunɨ semɨndɨmbo hohoanɨmoayomo ranahambo se ahambo düdufekoateyomondambe fɨfɨreamboane. ");
INSERT INTO agg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Se dɨdɨbafɨfembo mbɨsɨmombo ana, ndandu houmbo anɨmbo dɨdɨbafɨndafundɨ, ‘Yɨhoefɨ Ape sünambe amarɨfɨ, sɨhafɨ ndürɨ ranahambo moanɨ ahɨnümbɨ hamɨndɨmbeyowamboane. ");
INSERT INTO agg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Sɨhafɨ ŋgɨnɨndɨ hɨfandarandɨ ra ndühɨ mbokoso-amboane. Se hohoanɨmoayafɨ süŋgu yaŋgɨrɨ hɨfɨ ndanühɨ süŋgufemboane sapo sünambe-amboanɨ süŋguarundɨ nou. ");
INSERT INTO agg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yɨhoefɨmbo sesɨ ndanɨ sɨmboanɨ sesɨmbo sɨmogodühɨ ndawamunɨ. ");
INSERT INTO agg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Se yɨhoefɨmbo nɨne-moatükunɨ moaruwai ramarɨhundɨ ranɨmbo amboawiyei mbɨsafɨmunɨ sapo ro nindou ai moaruwai yɨhoefɨmbo rarɨhimuna aheimbo amboawiyei sefɨ arɨhundɨ nou. ");
INSERT INTO agg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Se yɨhoefɨmbo refe hoefimunɨ moatükunɨ ranambe ndowandɨfɨmunɨ ŋgamboyafɨ, ŋga se yɨhoefɨmbo moaruwai nendɨ ahandɨ warambeahɨndɨ aboedühɨ ndowandɨfɨ hɨnɨŋgɨndowamunɨ,’ mbɨsɨmo. ");
INSERT INTO agg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nindou ai sɨhamumbo moaruwaimbo-rɨhipuranɨ asu se ranaheimbo amboawi ehomondürɨ ana, asu sɨhamundɨ Ape sünambe amaru ranai-amboanɨ sɨhamundɨ moaruwai hohoanɨmo ranahambo amboawi mbüsumbui. ");
INSERT INTO agg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ŋga asu se nindou ŋgorümbo ranahambo amboawi yahokoateyomo ana, asu sɨhamundɨ Ape sünambe amaru ranai amboanɨ ŋgɨrɨ se nɨne-moatükunɨ moaruwai rarumboemo ranahambo amboawi mbüsu, ŋga wanɨ.” ");
INSERT INTO agg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Asu se nɨnɨmbo sesɨ wehɨndɨmondühɨ ana, se ŋgusümboarɨ sɨhamundɨ ra amomoŋgo-amomoŋgondɨmondühɨ wembombofi ndɨmboemo yimbu yafambeimbɨ nindou rawefundɨ nou, ŋga yowanɨ. Nindou ranai wembombofiayomo houmbo ai nindou hɨmboahü hoahoaŋgomondühanemo nindou ai ahamumboya ai ana sesɨ wehɨyomondühanemo, mbɨseiya yahomo houmbo. Ro sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ, nindou ahamumbo aboedanemo asei ana, ai ranɨhünda ahamundɨ takɨnɨ sowandümombo-anemo. ");
INSERT INTO agg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ŋga asu se sesɨ ra wehɨndafühɨ ana, sɨhafɨ ŋgusümboarɨ ra popoainda asu mbɨro sɨbada mbundambo anɨmbo ŋgafɨ. ");
INSERT INTO agg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Rananɨmbo nindou amurɨ ai ŋgɨrɨ sɨhambo fɨfɨrɨndɨhinɨnɨ se sesɨ wehayafɨ ranahambo. Ŋga sɨhafɨ Ape sapo dɨbo anüŋgu ai yaŋgɨrɨ anɨmbo fɨfɨrɨndeanɨnɨmbui. Rananɨmbo asu sɨhafɨ Ape sapo nɨne-moatükunɨ dɨbo eŋgoro ra hoeireandeimbɨ-mayu ranai sɨhambo takɨnɨ masɨhendɨ-mayo ra daganɨnɨmbui.” ");
INSERT INTO agg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Se hɨfɨ ndanühɨ nɨŋgomombo moanɨ ŋgɨnɨndɨ napo ra sɨhamumbo püpindu gafomboemo. Hɨfɨ ndanühɨ ana nɨne-moatükunɨ eŋgoro ra kɨdaboarɨ ai taparühɨ, sami ai sesɨ, asu hümbuhünɨ nendɨ ai worɨ bɨrɨhehi sahümündi raraorɨhündühanei. ");
INSERT INTO agg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ŋga asu se sɨhamundɨ ŋgɨnɨndɨ napo ra se sünambe anɨmbo püpindu gafomo. Ranühɨ ana ŋgɨrɨ kɨdaboarɨ ai tapandühɨ, sami ai dedɨ asu hümbuhünɨ nendɨ ai worɨ bɨrɨndɨhehi ndahümündi rarao ndühündɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ŋga sɨhafɨ aboedɨ napo ra püpira hafo yaŋgorowohü ranühɨ anɨmbo sɨhafɨ ŋgusüfo amboanɨ kündarɨmboe.” ");
INSERT INTO agg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Hɨmboarɨ ranana sɨhafɨ fi muŋguambo ranahandɨ ram hai nouane. Sɨhafɨ hɨmboarɨ ranai sürarɨhoayo ana, asu hohoanɨmo sɨhafɨ fiambe muŋguambo ranai si nahuraindɨmboe. ");
INSERT INTO agg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ŋga sɨhafɨ hɨmboarɨ ranai moaruwaiayo ana, asu hohoanɨmo sɨhafɨ fiambe muŋguambo ranai nɨmbɨ nɨmandɨmboe. Asu si sɨhafɨ fiambe amaro ranai nɨmbɨ nouayo ana, nɨmbɨ ra moaruwai hamɨndɨndɨmboe!” ");
INSERT INTO agg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nindou ŋgorü ai ŋgɨrɨ yimbu bogorɨ nindouyafandɨ ratüpurɨyu randeimbɨ nüŋgu. Ŋga nindou ranai ana bogorɨ ŋgorü ranahambo moaruwaimbondirühɨ asu ŋgorü bogorɨ ranahambo dɨboadondirümbui. Ai ŋgoründɨ hoafɨ yaŋgɨrɨ süŋgundeandühɨ asu ŋgoründɨ hoafɨ daboadanambo-ndeambui. Se ŋgɨrɨ God asu kakɨ mamɨ ŋgusüfoambe hohoanɨmo pandowapɨrɨ.” ");
INSERT INTO agg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ranɨmboanahɨ ro sɨhamumbo hoafehapurɨ nda, se sɨhamundɨ yaŋgɨrɨ nɨŋgombo ranahambo afɨndɨ hohoanɨmo-ndɨmboemo. Se yaru hoafɨyomondühɨya, Sɨhɨrɨ nɨnɨ-moatükunɨ madagüdifɨ? asu Sɨhɨrɨ nɨnɨmoatükunɨ mandɨmɨndefɨ? mbɨsɨmboemo. Asu sɨhamundɨ fi ranahambo ŋgɨrɨ afɨndɨ hohoanɨmo-ndɨmondühɨya, Sɨhɨrɨ nɨnɨ moatükunɨ magüdühu? mbɨsɨmboemo, ŋga wanɨ. Yaŋgɨrɨ nɨŋgombo ra ai sesɨ moatükunɨ yaŋgɨrɨyopoanɨ. Asu fi ra ai yihuru moatükunɨ yaŋgɨrɨyopoanɨ. ");
INSERT INTO agg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Asu awi se ndu nɨmoamo ahahabodei ranaheimbo hoeirundürɨ. Ndu ranai ana moai nɨnɨ-moatükunɨ hoarɨ hɨfɨ karɨhi, sesɨ yimuŋgurɨhümündi hei sesɨ worɨ ranambe gugurɨhi sɨhehi raraorɨhündɨ. Ŋga sɨhamundɨ Ape sünambe amaru ranai-ani aheimbo sesɨ sagadürühɨ hɨfandandürɨ arandɨ. Se ndu ranaheimbo ŋgasündundürɨ houmbo ndearɨ hamɨndanemo. ");
INSERT INTO agg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ŋga asu nindou sehündɨ ranai-amboanɨ ŋgɨrɨ moanɨ ahandɨ hohoanɨmo ranambo yaŋgɨrɨ ahandɨ yaŋgɨrɨ nɨŋgo ra sühɨnde ŋgu! ");
INSERT INTO agg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Asu nɨmboe se hoearɨ napo ranɨmbo afɨndɨ hohoanɨmoemoa? Awi se amɨndafurɨ ahurɨ tüküfe nɨnouayo ranahambo hoeiru. Ai ana moai tɨŋɨrɨfoyeihɨ momo yibüdühɨ rɨhündɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ŋga asu awi ro sɨhamumbo hoafehapurɨ horombo nindou adükarɨ bogorɨ Soromon amboanɨ ai yihuru napo moanɨ sɨmbafɨ hamɨndɨmayusɨ, ŋga asu ai moai hoearɨ ra ahurɨ moanɨ aboedɨ hɨmboyo haya tütükɨyo nɨnouayo yahurai yihururamündu. ");
INSERT INTO agg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wohɨ amɨndafurambe amaro haponda ra asu sümbo siambe hɨfɨtɨrɨyɨmɨndɨ haiambe pütifemboane. Moaruwai yahurai wohɨ ranamboanɨ God ai ahambo aboedɨ yihurure hɨnɨŋgareandɨ ana, asu ai sɨhamumbo amboanɨ yihurundeapurümbui. Se yihuru ranahambo afɨndɨ hohoanɨmoyomo, ŋga sɨhamundɨ anɨhondümbofe hohoanɨmo ana akɨdou ane! ");
INSERT INTO agg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ŋga asu se refe afɨndɨ hohoanɨmo-yomondühɨya, Nahanɨhünda sesɨ yɨhoefɨ ranai tükümandɨfe? Yɨhoefɨ sɨmɨndɨmbo moatükunɨ amboanɨ? Asu yɨhoefɨ hoearɨ napo amboanɨ? Ranɨ-moatükunɨ ranahambo yahurai afɨndɨ hohoanɨmoyo hoaŋgopoanɨ. ");
INSERT INTO agg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yahurai ranɨ hohoanɨmo ranana nindou Godɨmbo fɨfɨrɨfekoate-yeimbɨ-mayei rananei ai yahurai rarɨhi hohoanɨmoyei hei arɨhündɨ. Sɨhamundɨ Ape sünambe amaru ranai ranɨ-moatükunɨ se semɨndɨmbo hohoanɨmoayomo ra ai fɨfɨre türüfoare-amboani. ");
INSERT INTO agg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Asu se sapo God ahandɨ hɨfandarandane asu ahandɨ mbumundɨ hohoanɨmomayo ranane ranɨ-boatei-anɨmbo se hohoanɨmondɨmo hoaŋgomo. Rananɨmbo asu ranɨwamɨ amurɨ bɨdɨfɨrɨ moatükunɨ ranamboanɨ ai ranɨ-moatükunɨ kapeihɨ ndaiyapurümbui. ");
INSERT INTO agg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ranɨmboane asu se nɨnɨ-moatükunɨ sümbo tüküfemboayo ranahambo afɨndɨ hohoanɨmondɨmboemo. Nɨnɨ-moatükunɨ sümbo tüküfemboayo sümbo se ranahambo hohoanɨmondɨmo. Mamamɨ si ranai moanɨ ahandɨ tɨŋɨrɨfo ranɨ-sɨmboanɨ ndearane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Sisas yahuya, “Se nindou ŋgorümbo yɨbobo-ndundürɨmboemo. Hɨbadümbo, ŋga sɨhamumbo asükai hɨhɨndɨfe yɨbobo-ndeapurɨmboe. ");
INSERT INTO agg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sapo se nindou ŋgoründɨ hohoanɨmo yɨboboarundɨ ranɨ sɨmogodühɨ anɨmbo God ai-amboanɨ sɨhamundɨ hohoanɨmo yɨbobo-ndeapurümbui. Sapo se nindou ŋgorümbo yimbumarundɨ mamɨ ranɨ sɨmogodɨhü God ai sɨhamumbo yimbundeapurɨmbui. ");
INSERT INTO agg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nɨmboe asu se sɨhafɨ wandafɨ ranahandɨ hɨmboarambe düdübudɨ akɨdou apaiaro ra hoeiaroworɨ, ŋga asu nɨmoko afɨndɨ sɨhafɨ hɨmboarambe amaro ranahambo awi se moai fɨfɨrowandɨyo? ");
INSERT INTO agg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Asu se nüŋguro hawamboyafɨ sɨhafɨ wandafɨ ranahambo raro hoafɨyafühɨya, Wandafɨ, sɨhafɨ hɨmboarambe düdübudɨ ra hündɨhehea samboanahɨ, asafɨ, ŋga asu sɨhafɨ hɨmboarambe nɨmoko ra nüŋgumando-a? ");
INSERT INTO agg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Awi seana yimbu yafambeimbɨ nindou-anafɨ! Se boatei sɨhafɨ hɨmboarambe nɨmoko ra hündandɨfɨ raguanambondo hawambo anɨmbo asu sɨhafɨ wandafɨ-mayu ranahandɨ hɨmboarambeahɨndɨ düdübudɨ akɨdou ra hündɨhoefɨndo. ");
INSERT INTO agg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Se Godɨndɨ moatükunɨ ra yaforɨ moaruwaimbo dɨgoemboemo, ŋga asu ai hɨhɨrɨndahindühɨ sɨhamumbo kündarimboyei. Asu sɨhamundɨ nɨne-moatükunɨ aboedɨ-mayo ra moateiyei wagabe pindumboemo, ŋga asu ai tɨŋarɨnambo anümɨ boagɨndühɨ dɨgegimboyei.” ");
INSERT INTO agg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Se düduyafu arundɨ ana, dagapurümbui. Se kokoru arundɨ ana, hoeindumboemo. Se pɨrako pɨrako arundɨ ana, yipurɨ sɨhamumbo sübüdühepurɨmboe. Asu düdi ai pɨrako pɨrako arandɨ ana, ahambo yipurɨ sübüdühoemboe. ");
INSERT INTO agg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ŋga nindou düdi ai düdufi arandɨ ana, ndemündümbui. Asu düdi ai kokora arandɨ ana, hoeindeambui. Asu düdi ai pɨrako pɨrakora arandɨ ana, ahambo yipurɨ sübüdühoendomboe. ");
INSERT INTO agg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nindou sɨhamumbo mbüsümo ahandɨ nɨmorɨ ai mbanɨmbo sao yahumbo düduwefindo ra ahambo moanɨ nɨmoei meŋgoro ra madagadoyo? ");
INSERT INTO agg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Asu ahandɨ nɨmorɨ ranai kinɨmbo düdufindoanɨ ra ahambo amoasɨrɨ madagadoyo? ");
INSERT INTO agg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Se nindou moaruwai-anemos, ŋga se sɨhamundɨ nɨmorɨ ranaheimbo aboedɨ moatükunɨ yaŋgɨrɨ sabudürɨ arundɨ. Yahurai anɨmbo sɨhamundɨ Ape sünambe amaru ranai nindou düdi ahambo düduefiyu ana, ranahambo aboedɨ moatükunɨ dagadombui. ");
INSERT INTO agg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Muŋguambo moatükunɨ hohoanɨmo ra nindou amurɨ ai sɨhamumbo yahurai rambɨrɨhimunɨ ayahomo yahurai hamɨndɨ anɨmbo se moanɨ aheimbo randundürɨ. Ranɨ-moatükunɨ hohoanɨmo ranana Mosesɨndɨ ahɨnümbɨ hohoanɨmo asu Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ-yomondɨ yamundɨfe hoafɨmayo ranahandɨ nɨmɨndane.” ");
INSERT INTO agg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nafɨtambe akɨdou ranɨ nafanɨmbo se kebou ŋgomo. Sapo nafɨtambe adükarɨ ahandɨ nafɨ fuiriyandeimbɨ ranana moaruwaimbo ŋgoafɨnamboane aho. Ŋga nindou afɨndɨ ai nafɨ ranɨ-süŋgu hei rɨhündühanei. ");
INSERT INTO agg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ŋga yipurɨ nafɨtambe hɨhɨforeandeimbɨ ranai akɨdouyo haya asu ahandɨ nafɨ tɨŋümbane. Ŋga nafɨ ra yaŋgɨrɨ koadürümbo nɨŋgombo nafane aho, ŋga ranane asu nindou yimbu mamɨ yaŋgɨranei ai nafɨ ranahambo hoeirɨhindühɨ ranɨ-süŋgu ahei.” ");
INSERT INTO agg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Godɨndɨ hoafɨ tɨkai hoafɨyomo-rundeimbɨ nindou ranahamumbo awi se hɨbadümbo. Moanambühɨ sipsip hɨmboarɨ hoafendɨ hɨmboemo nahurai sɨhamumbo sowana asɨfomo, ŋga asu wagabe ragu ana nɨmambeahɨndɨ yaforanemo. ");
INSERT INTO agg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Se ahamundɨ ratüpurɨ ranambo ahamundɨ hohoanɨmo fɨfɨrɨndumboemo. Ŋga aŋgɨnaŋɨ tɨhoarɨ tɨhoarümbɨ wofɨ nɨmɨndɨ ranɨfihɨ hɨsɨmandɨyo? Asu hoandasüfo sosoweimbɨ werɨfoai nɨmɨndɨ ranɨfihɨ hɨsɨmandɨyo? Ra wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ŋga sapo nɨne-nɨmɨ aboedayo ranai aboedɨ nɨmɨ hɨsɨ yaŋgɨrɨ hɨsɨndɨmboe. Asu moaruwai nɨmɨmayo ranai moaruwai nɨmɨ hɨsɨ ranɨ yaŋgɨrɨ hɨsɨndomboe. ");
INSERT INTO agg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ŋga asu moaruwai nɨmɨ ranɨfihɨ ŋgɨrɨ aboedɨ nɨmɨ hɨsɨ ra hɨsɨndo. Asu aboedɨ nɨmɨ ranɨfihɨ ŋgɨrɨ moaruwai nɨmɨ hɨsɨ ranai hɨsɨndo, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Muŋguambo nɨmɨ ranai nɨmɨndɨ ranɨfihɨ moaruwai hɨsɨyowanɨ ana, ahambo hɨfɨtɨrɨyɨmɨndɨ haiambe mandɨfeyowohane. ");
INSERT INTO agg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ranɨmboane asu se Godɨndɨ hoafɨ tɨkai hoafɨyomo-rundeimbɨ ranahamumbo ahamundɨ ratüpurɨ hohoanɨmo ranambo fɨfɨrɨndüpurɨ. ");
INSERT INTO agg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Se yaru hohoanɨmo-ndɨmondühɨya, Muŋguambo nindou ai wambo hoafɨyeihɨ, Adükarɨ Adükarayei ranai God sünambe hɨfandarandɨ ranambe gagüsimboyei, mbɨsɨmboemo, ŋga wanɨ. Ŋga nindou dɨdɨyei ai moanɨ wandɨ Ape sünambe amaru ranahandɨ hohoanɨmo süŋgurɨhi arɨhündɨ ranai yaŋgɨrɨ anɨmbo God ŋgɨnɨndɨ hɨfandarandɨ ranambe keboehimboyei. ");
INSERT INTO agg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ŋga asu yɨbobofembo si ranai tüküfeyoambe anɨmbo nindou afɨndɨ ai dükandɨhindɨrɨ hoafɨndeihɨ anɨmboya, ‘Adükarɨ, Adükarɨ, sɨhafɨ ndürɨnamboyefɨ Godɨndɨ hoafɨ ra hefɨ wataporɨmbo-rɨhundühɨ bokarɨhehu marɨhundɨ. Sɨhafɨ ndürɨnamboyefɨ moaruwai nendɨ nindouyei fiambeahɨndɨ raguanambo-rɨhundühɨ hepünɨfeimbɨ moatükunɨ rarɨhu marɨhundɨ,’ mbɨseimboyei. ");
INSERT INTO agg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Rananɨmbo asu ro hoafɨndahühɨ anɨmboya, ‘Ro moai sɨheimbo fɨfɨrɨhearü. Moaruwai hohoanɨmo ratüpurɨyei rühündeimbɨ nindou-anei. Wambo sowana ndühɨ sɨnɨpoanɨ, ŋga andai ragu ŋgei!’ mbɨsamboyahɨ.” ");
INSERT INTO agg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Asu, nindou düdi ai wandɨmayo hoafɨyaheimbɨ hoafɨ ranahambo hɨmborɨyu mburambo asu ai ranɨ-süŋguareandɨ ana, nindou ranai sapo fɨfɨreandeimbɨ nindou ai ahandɨ worɨ kambohoanɨ ŋgɨnɨndɨ ranɨwamɨ worɨmboarandɨ nahurai-ani. ");
INSERT INTO agg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Asu hoe afɨndɨ ranai hoeyowohü, hohoambu afɨndɨ ranai tüküfeyowohü werɨ ranai worɨ ranahambo fandɨhendühanesɨ, ŋga asu worɨ ra kambohoanɨ fondarɨmbo-wambo moai bɨrefoai hɨfɨnɨ peyo. ");
INSERT INTO agg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Asu nindou düdi ai wandɨ-mayo hoafɨyaheimbɨ hoafɨ ranahambo hɨmborɨyu haya asu ai ranɨ-süŋgufekoateayu ana, nindou hohoanɨmokoate-ani. Sapo nindou worɨ moanɨ kambohoanɨ kaihurɨ yaŋgɨrɨ ranɨwamɨ worɨmboarandɨ nahurai-ani. ");
INSERT INTO agg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hoe afɨndɨ ranai hoeyo, hohoambu afɨndɨ ranai hohoambuyo, asu werɨ afɨndɨ ranai worɨ ranahambo fandɨhenda asu worɨ ranai bɨrefoai peyowohane ranɨ-moatükunɨ ranambo. Worɨ ra bɨrefoendɨ ranana moanɨ moaruwai hamɨndɨ hondane!” mehu. ");
INSERT INTO agg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sisas ai hoafɨ ranahambo hoafɨyu kɨkɨmaramündua, nindou afɨndɨ ranai ahandɨ yamundɨfe hoafɨ hɨmborɨyei-anɨ mayowa mahepünehindɨ. ");
INSERT INTO agg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ŋga Sisas ai moai ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ nindou yahurai tüküfi yamundeandürɨ, ŋga ai moanɨ ranɨ-poanɨmbo ŋgɨnɨndɨnamboyu aheimbo yamundɨ-mareandürɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sisas ai yamundɨfe hoafɨ ra hoafɨyu haya hɨfɨ wafu-mayo ranɨ-wamɨnɨndɨ hɨfɨna mahanua, awai nindou ranai ahandɨ süŋgu tümareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ranɨyu asu nindou mɨmanɨhoeimbɨ-mayu ranai Sisasɨmboso tüküfi Adükarani yahu hohoanɨmoyuhü yirɨ yimbu pusɨreapɨrɨ ahandɨ fikɨmɨ piyu nɨmarühɨ hoafɨyundowohü yahuya, “Adükarɨ, se refembo hohoanɨmondafühɨ ana, wambo aboedɨndowandɨrɨ,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Asu Sisas ai warɨfi hu nindou-mayu ahambo sündirühɨ hoafɨyuhü yahuya, “Yɨnɨ, ro randɨheamboyahɨsɨ. Ŋga se haponda aboedɨ tüküyafo,” mehuamboyu. Asu moanɨ mamɨharɨ ranɨ-sɨmboanɨ nindou ranai mɨmanɨhoeimbɨ-mayuhündɨ aboedɨmefiyu. ");
INSERT INTO agg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ranɨyu asu Sisas ai ahambo hoafɨyundühɨ yahuya, “E, Se ndühɨ hɨmborɨyafɨ! Ndanɨ-moatükunɨ ndanahambo se nindou amurambo hoafɨndamboyafɨ. Ŋga se moanɨ ŋgafɨ Godɨmbo sɨhai-randeimbɨ nindou-mayu ranahambo anɨmbo sɨhafɨ fi ra nafuindafɨ. Asu Godɨmbo sɨhefembo moatükunɨ Moses refemboane mehu ra randowandɨ ai hoafɨ-mayu süŋgu. Ranɨmboane sɨhafɨ fi hoearɨ aŋgünɨ ra muŋgumayo mbɨsei-amboane,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ranɨyu asu Sisas ai Kaperneam ŋgoafambe tüküfiyuwane Romɨhündɨ ami-yomondɨ bogorɨ ai ahambo ranühɨ hoeirirɨ hayambo Sisas ai mbɨfarɨhendɨrɨ yahu haya düdu düdumarürɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ai yare hoafɨyundühɨ yahuya, “Nindou Adükarɨ, wandɨ ratüpurɨyu-randeimbɨ nindou ranai aŋgünɨmbo worambe mbeŋgurɨ. Ai ahandɨ tɨŋarɨ yɨfɨyo haya asübusɨ afɨndɨ semündü haya mbeŋgurɨ,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Asu Sisas ai hoafɨyundühɨ yahuya, “Awi ro ŋga ahambo aboedɨndɨhinɨmboyahɨ,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Asu sɨmborɨ ai hoafɨyundühɨ yahuya, “Nindou adükarɨ, ŋgɨrɨ se randafoandɨ. Ro ndearɨ hamɨndɨyahɨ anɨmbo se wandɨ worambe keboao maŋgüfɨ. Ŋga se moanɨ hoafɨ yaŋgɨrɨ anɨmbo hoafɨndafanɨ amboanɨ asu wandɨ ratüpurɨyu-randeimbɨ ranai aboedɨmbiyu-wamboane. ");
INSERT INTO agg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ro-amboanɨ wambo hɨfandɨyɨndɨrɨmbo nindou ami bogorɨ adükarɨ nüŋguwanɨ anahɨ asu ami bɨdɨfɨrɨ ai wandɨ hoarehanemo anɨŋgomo. Rananahɨ asu ro nindou ndanahambo, Se hafɨ, asahando ra ai huhani, asu nindou ŋgorü ranahambo, Se sühüfɨ, asahɨ ra ai süfuhani. Asu nindou wandɨ ratüpurɨyu-randeimbɨ ranahambo, Se ranɨ-moatükunɨ raro, asahɨ ra ai moanɨ rareandühani,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Asu Sisas ai ranɨ hoafɨ ranahambo hɨmborɨyu haya, hepünüfihɨ nindou afɨndɨ ahandɨ süŋgu tümareandɨ ranaheimbo hoafɨyundürühɨ yahuya, “Ro sɨheimbo hoafehandürɨ, horombo ro moai nindou mamɨ Israer ŋgoafɨ-hündɨ ndahurai anɨhondümbo-reandeimbɨ nüŋgua hoeirɨhinɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Awi ro nda sɨheimbo hoafehandürɨ, nindou afɨndɨ bɨdɨfɨrɨ ai hüfɨhamɨndɨ süfuanɨpoedɨ asu hüfɨhamɨndɨ hanüwanɨpoedɨ ranai fandɨhi sesesɨ fondɨ manɨŋgo ranɨkɨmɨ Abraham, Aisak asu Sekop babɨdɨ God ŋgɨnɨndɨ hɨfandarandɨ ranambe nɨmandeimboyei. ");
INSERT INTO agg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ŋga asu sapo hɨfandarandɨ ranambeahɨndɨ nendɨ-mayei ranaheimbo anɨmbo nɨmbɨ nɨmarɨwanɨ ndemündündürɨ pindeiranɨ ranühɨ ai hasɨheindeihɨ ahei yahafɨ hɨtɨhümboyei,” mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ranɨyu asu Sisas ai ami-yomondɨ bogorɨ ranahambo hoafɨyundühɨ yahuya, “Se ŋgoafɨnambo ŋgafɨ, ŋga asu se nɨne-hohoanɨmo raro anɨhondümbo-arowandɨ ranɨ-süŋgu anɨmbo sɨhambo randeanɨnɨmboe,” mehundoamboyu. Asu moanɨ hoafɨ nɨŋgoambe ami-yomondɨ bogorɨndɨ ratüpurɨyu-randeimbɨ nindou ranai aboedɨmefiyu. ");
INSERT INTO agg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Refi mbura Sisas ai Pitandɨ worambe kefuai hüfuhünda Pitandɨ yamoŋgoamɨndɨ ranai fi hüfɨyohü aŋgünɨmbo fondühɨ meŋgorowa hoeimareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ranɨyu asu Sisas ai ahambo watɨŋarühɨ masündeanda aŋgünɨ ranai nɨmorehɨmbo hɨnɨŋgɨre haya makosɨfoendɨ. Ranɨyo asu ai botɨfe Sisasɨmbo sesɨ kanɨmarerɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ranɨyo asu ranɨ nɨmbambe nindou bɨdɨfɨrɨ moaruwai nendɨ ahei fiambe nɨmarɨndüreimbɨ ranaheimbo Sisas sowana fufurühümündi-hündürɨ mahüsi. Ranɨyu Sisas ai nindou ranahei fiambeahɨndɨ moaruwai nendɨ ranaheimbo hoafɨnambo yaŋgɨrɨ raguanambo-mareandüra asu nindou ranɨ aŋgünümbɨ-mayei ranai muŋguambo aboedɨmehindɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Sisas ai ranɨ-moatükunɨ ramareandɨ ra, sapo Godɨndɨ hoafɨ hoafɨyu randeimbɨ Aisaia ai yare hoafɨyuhü yahuya, “Ai ahandɨhoarɨ aŋgünɨ moaruwai sɨhefɨ ra ndemündühɨ asu sɨhefɨ ranɨ-moatükunɨ ra raguanambo-mareandɨ,” mehu ranɨ sɨmogodühɨ tüküfemboyo ramareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sisas ai hoeireandane nindou afɨndɨ ranai ahandɨ fikɨmɨ rerembo meŋgoroamboyu, asu ai ahambo süŋgururü-rundeimbɨ-memo ranahamumbo kurɨhoe Gariri ra ŋgorü hɨmboranɨ barɨhoemo nɨŋgomo yahumbo hoafɨmayupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ranɨyu asu ahɨnümbɨ hohoanɨmo yamunde-randeimbɨ-mayu ranai Sisasɨmbo-so tüküfi hoafɨyundühɨ yahuya, “Yamundo-randeimbɨ, se nahanɨnɨyo ahafɨ ra roana sɨhafɨ süŋgu hombo yaŋgɨranahɨ,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Asu ai sɨmborɨ hoafɨyundühɨ yahuya, “Koko ai ahei nɨmarɨ rambo ambe mbanɨŋgondürɨ, asu ndu ai-amboanɨ ahei apo rambo ŋgerɨ mbanɨŋgondürɨ. Ŋga Nindou Hondü ro nɨmarɨ apo rambo fondɨ-koate anahɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ranɨyu asu Sisasɨmbo süŋgurürɨ-randeimbɨ ŋgorü ahambo hoafɨyundühɨ yahuya, “Adükarɨ, awi ro hɨhɨrɨndahe, ŋga wandɨ apembo boatei hɨfɨ kandɨhinɨ heheambo anɨmbo,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Asu Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Wambo mborai se süŋgundandɨrɨ dɨdɨfɨ, ŋga nindou yɨfɨyeimbɨ aheihoarɨ yɨfɨ nɨmoko hɨfɨ kambɨreand-amboane,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ranɨyu asu Sisas ai botambe farɨfi haya mahua ahambo süŋgururü rundeimbɨ ai ahandɨ süŋgu mamɨ mahomo. ");
INSERT INTO agg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Asu ranɨyomo ai botambe nafɨ hɨfomondane nɨmai hoewerɨ ŋgɨnɨndɨ ranai tüküfihɨ kurɨhoe ranahambo yabadɨmarandɨ. Ranɨyo asu bot ai nɨmarɨmondeimbɨ ranai ndeara hɨmonɨ hanɨmbo yaŋgɨrɨmayo. Ŋga asu Sisas ai dɨbo botɨ-mayo ranambe yapombofi haya apu. ");
INSERT INTO agg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ranɨyomo ahambo süŋgururü-rundeimbɨ ranai ahambo hɨfomo yaŋgɨrüwurɨ hoafɨyomondühɨ yahomoya, “Adükarɨ, yɨhoefɨmbo farɨhawamunɨ. Sɨhɨrɨ ana ndeara yɨfombo yaŋgɨranefɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Asu sɨmborɨ ai hoafɨyupurühɨ yahuya, “Se ra nɨmboe moanɨ yahurai yɨhɨmboemo rana? Awi se akɨdou hamɨndɨ anɨhondümboru-rundeimbanemo,” yahupurɨ haya, botɨfi hoewerɨyo asu hoe ranai fɨfɨmɨyowohü hanɨ hafo marandɨ ranahambo rühɨ safɨ kɨkɨndandɨfɨ mehua asu hoafɨ nɨŋgoambe muŋguambo moatükunɨ ranai afure pɨmayo. ");
INSERT INTO agg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Muŋguambo botambe mamarɨmo ranai hepünafundühɨ yaru hoafɨyomondühɨ yahomoya, “Nindou ndahurai nda nɨnɨ nindouyu yahuraia? Asu hoewerɨ hoe hanɨ hafo marandɨ ranai moanɨ ahandɨ hoafɨ hɨmborɨyondo haya afurɨmareandɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ranɨyu Sisas ai kurɨhoe ra gogoasürünɨ Gadara hɨfambe tükümefiyu. Ranɨyafanɨ asu nindou yimbu moaruwai nendɨ ahafandɨ fiambe nɨmarɨpɨreimbɨ ranai hoŋguambeahɨndɨ tüküyafɨne sɨnɨfanɨ Sisasɨmbo-so tükümefɨneandɨ. Nindou yimbu ranai moaruwai hamɨndɨ hɨmbomefanda asu nindou amurɨ ai ahafanɨmbo moai hei ŋgasündɨhipɨrɨ rɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ranɨyafanɨ asu ai puküna heiyafandühɨ hoafɨyafandühɨ safanɨya, “Godɨndɨ Nɨmorɨ, se yɨhoehɨmbo nüŋgufemunɨmboyafɨ? Yɨhoehɨmbo tɨŋɨrɨfo semunɨmbo safomboyafɨ sapo refembo si ranai awi moai tüküfeyo, ŋga asu se yɨhoehɨmbo nüŋgufemunɨmboyafɨ?” safanɨ düdumefɨneando. ");
INSERT INTO agg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ranɨ-fikɨmɨ moatei afɨndɨ ranai sesɨ sahüsi wakɨrɨhindühɨ burɨyei. ");
INSERT INTO agg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ranɨyei asu moaruwai nendɨ nindou yimbuyafandɨ fiambe mamarei ranai Sisasɨmbo düduyahihündühɨ hoafɨyohündowohü seiya, “Se yɨhoefɨmbo nindou yimbu ranahafandɨ fiambeahɨndɨ hefoefemunɨmbo mbɨsafombo ana, moatei afɨndɨ burayei ranaheimbo sowana ahei fiambefembo koandɨhawamunɨ,” masahündoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Asu Sisas ai moaruwai nendɨ ranaheimbo yare hoafɨyundürühɨ yahuya, “Se andai hei,” mehundüramboyei. Asu ai nindou yimbumbo hɨnɨŋgɨrɨhipɨrɨ hehi moatei burɨmayei ranahei fiambemehindɨ. Ranɨyei asu moatei afɨndɨ burɨmayei ranai hɨrɨpɨnɨnɨ pɨpɨyeihanei hɨmonɨ pütapɨyei hoe karühüsihü yɨfɨsafɨmayei. ");
INSERT INTO agg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ranɨyomo asu nindou sapo moatei moaŋgui mafandundɨ ranai adükarɨ ŋgoafɨ manaŋgo ranɨnambo fefou mahomo. Nɨne-moatükunɨ nindou moaruwai nendümbɨmefanɨ ranahafanɨmbo tükümefepɨrɨ ranɨ hoafɨ ra wataporɨmbomarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ranɨyei asu muŋguambo nindou adükarɨ ŋgoafɨ ranühɨndambo-mayei ranai Sisasɨmbo hoeifimbo hei-marɨhündɨ. Asu ai hei hoeirɨhorühɨ ahei hɨfɨ ra hɨnɨŋgɨfe hefe ŋgorügoanɨnɨ hombo Sisasɨmbo andai, sei hehi hoafɨmehündo habodei. ");
INSERT INTO agg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sisas ai asükaiyu botambe farɨfi haya Gariri kurɨhoe ra barɨhoei haya ahandɨ ŋgoafɨ Kaperneamɨna mahu. ");
INSERT INTO agg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nindou bɨdɨfɨrɨ ai Sisas sowana nindou tɨŋarɨ moaruwaimbü fondɨwamɨ manaŋguwa sahorɨmɨndei mahei. Sisas ai nindou ranahei anɨhondümbofe ra hoeire haya asu nindou tɨŋarɨ moaruwaimbü-mayu ranahambo hoafɨyundühɨ yahuya, “Wandɨ nɨmorɨ, ŋgusüfoambe afurɨndo kündowandɨ. Sɨhafɨ moaruwai hohoanɨmo ranahambo amboawi sambo-anahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ranɨyomo asu ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ ranai moanɨ ahamundɨhoarɨ sɨmborɨ hoafɨyomondühɨ yahomoya, “Nindou ndanai ana Godɨmbo moaruwaimbofe hoafɨ hoafɨmayu,” yahomo dɨbo hoafɨmemo. ");
INSERT INTO agg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sisas ai fɨfɨreandɨ nɨne-moatükunɨ nindou ranai ahamundɨ hohoanɨmoambe wataporɨmboarundɨ ranɨmbo. Ranɨyu asu ai ahamumbo hoafɨyuhü yahuya, “Nɨmboe se hohoanɨmo moaruwai ra yahurai yaru ŋgusüfoambe hohoanɨmoemo rana? ");
INSERT INTO agg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ro hoafɨyahühɨ sahɨya ‘Sɨhafɨ moaruwai hohoanɨmo ranahambo amboawi,’ asahɨyo asu ‘Botɨyafo hawa hafɨ,’ asahɨyo, yimbu ra hoafɨmbo ro ŋgɨnɨndeimbanahɨ. Asu yimbu hoafɨ ra hoafɨmbo nahanɨyo hɨnɨŋgɨrouayo asu nahanɨyo tɨŋümbayo? Yɨbobo ro hoafɨndahanɨ anɨhondümbo tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ŋga Nindou Hondü hɨfɨ ndanühɨ moaruwai hohoanɨmo ranahambo amboawi yaho hoafɨ ra ŋgɨnɨndɨ hɨfandamboayu ranahambo ra anɨhondümbo nafuindamboyahɨ,” mehupurɨ. Ranɨyu asu ai nindou tɨŋarɨ moaruwaimbü-mayu ranahambo hoafɨyundühɨ yahuya, “Se botɨyafo sɨhafɨ fondɨ ra sowandɨfɨ hawa worɨnambo ŋgafɨ,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Asu nindou ranai aboedɨ botɨfi haya ahandɨ worɨna mahu. ");
INSERT INTO agg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nindou afɨndɨ ranühɨ burɨmayei ranai Sisas ramareandɨ moatükunɨ ranahambo hoeirɨhi hehi yɨhɨmbo sɨsɨrɨmehindɨ. Ranɨyei asu ai Godɨmbo adükarani sei hoafɨmehündo moanɨ yahurai hamɨndɨ ŋgɨnɨndɨ ra nindoumbo masendɨ sei hehi. ");
INSERT INTO agg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sisas ai ranɨhünda botɨfi haya nafɨnɨ huhündamboyu, nindou mamɨ ahandɨ ndürɨ Matyu takis kakɨ semündü-randeimbɨ ranai ahandɨ ratüpurɨ worambe mamaruwa hoeimarirɨ. Ranɨyu Sisas ai yahuya, “Se wambo süŋgurandɨrɨ,” mehundu-amboyu. Asu ai botɨfi haya ahandɨ süŋgu ndamefiyu. ");
INSERT INTO agg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mamɨ Sisas ai worambe nɨmarümbo sesɨ sesühɨ nɨmaru-ane, takis kakɨ sowandümo-rundeimbɨ nindou afɨndɨ ranɨyomo asu nindou moaruwai hohoanɨmoyomo-rundeimbɨ ranɨyomo ranai tükümefundɨ. Sisas ai ahambo süŋgururü-rundeimbɨ-memo ranɨ-babɨdɨmbo mamɨ sesɨ fondɨ-mayo ranɨkɨmɨ gugurɨyafu mamarɨmo. ");
INSERT INTO agg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ranɨyomo Farisi nindou ai ranɨ-moatükunɨ ranahambo hoeirunda mayoa, asu Sisasɨmbo süŋgururü-rundeimbɨ-memo ranahamumbo düduyafupurühɨ yahomoya, “Nɨmboe sɨhamundɨ yamunde-randeimbɨ ranai yahurai nindou babɨdɨmbo mamɨ nɨmarɨmombo asesu rana?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Asu Sisas ai hoafɨ ra hɨmborɨyu haya, sɨmborɨ hoafɨyupurühɨ yahuya, “Nindou aŋgünɨ-koate ana, dokta sowana moai hei rɨhündɨ, ŋga nindou aŋgüneimbanei dokta sowanambo hei arɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Awi se ŋgomo Bukambe hoafɨ ndare hoafɨmayo ranahambo türüboadundɨ. Hoafɨ ranai ndare hoafɨyowohü yahoya, ‘Hɨpoambofe hohoanɨmo ranɨmbo-anahɨ ro yifirayahɨ, ŋga sesɨ moanɨ sɨhefe hohoanɨmo ranɨmboyahɨpoanɨ,’ God ra-mehu. Ro tükümeheandɨ nda nindou aheihoarɨmbo mbumundɨ hohoanɨmoyefeimbanefɨ asei ranaheimbo mborai yahomboyahɨpoanɨ, ŋga moaruwai hohoanɨmoyeimbɨ nindou ranaheimbo mborai yahomboyahɨ tükümeheandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Asu Son hundürɨrarü-randeimbɨmbo süŋgururü-rundeimbɨ nindou ai Sisasɨmbo-so tüküyafu düdururühɨ yahomoya, “Nɨmboe Farisi nindou babɨdɨmbo ro sesɨ ra wehɨsaoayefɨ, ŋga asu sɨhambo süŋgurunɨnɨ-rundeimbɨ nindou aiana moai wehɨsaoyomo rundɨ?” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sisas ai ahamumbo yare hoafɨyupurühɨ yahuya, “Nindou mamɨ ai nɨmorehɨ sɨmborɨ ndemündü haya asu ahandɨ ŋgunindɨ sesesɨyeihɨ ranɨ-babɨdɨmbo nɨboadei-ambe ranai nindou ranahambo afɨndɨ hohoanɨmo-mandahünduyo? Awi ra ai ŋgɨrɨ randahindɨ, ŋga wanɨ. Ŋga ŋgorü nindou ranai sesɨ ranambeahɨndɨ ndowarɨndümo ŋgorünambonduranɨ ranɨ-sɨmboanɨ anɨmbo ahandɨ ŋgunindɨ-mayei ranai sesɨ wehɨsaondeimboyei. ");
INSERT INTO agg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nindou mamɨ ai-amboanɨ moai wamɨndafɨ hoearɨ ranai ambe nɨŋgowanɨ asu sɨmborɨ hoearɨ bɨdɨfɨrɨ kɨkamündɨ ambe ranahambo pare kakɨyu randɨ. Nindou ai sɨmborɨ kɨkamündɨü wamɨndafɨfihɨ parareandɨ ana, asu wamɨndafɨ hoearɨ ranai ambe afɨndɨ hamɨndɨ nɨŋgomboe. ");
INSERT INTO agg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Asu nindou ai sɨmborɨ wain hoe ra wamɨndafɨ wain hoe nɨnɨhondɨ hoearɨ hɨpɨrɨ ranambe karareandɨ ana, asu hɨpɨrɨ ranai tɨpondɨfeyowohü asu wain hoe ranai keboendühɨ hɨpɨrɨ ranai moaruwaimbo-ndɨfemboe. Ŋga sɨmborɨ wain hoe ranana sɨmborɨ hɨpɨrambe anɨmbo kefeyoanɨ amboanɨ asu yɨboboambo moanɨ aboedɨ nɨmboamboyafe,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sisas ai ranɨ hoafɨ ra hoafɨyuhü nüŋgu ane, Suda-yomondɨ bogorɨ nindou mamɨ ahambo-so sünɨ yirɨ yimbu pusɨre nɨmarümbo ahandɨ haŋgɨfoanɨ hoafɨyundühɨ yahuya, “Wandɨ nɨmorɨ ai ndeara yɨfɨyo haya mbeŋgorɨ. Ŋga asu se sɨnɨfɨ sɨhafɨ warɨ ahandɨ wamɨ nandowandanɨ anɨmbo asu ai aboedɨ yaŋgɨrɨ botɨfe mbɨnɨŋgo-wamboane,” mehundu-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ranɨyu asu Sisas ai botɨfi haya nindou ranahambo süŋgumarürɨ huamboemo asu ahambo süŋgururü-rundeimbɨ ai botɨyafu houmbo Sisas babɨdɨ mahomo. ");
INSERT INTO agg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nɨmorehɨ mamɨ ai nɨŋgo hayamboyo 12 hɨmbanɨ amoamo watɨkoafɨra marandɨ ranai sɨnɨ Sisasɨndɨ daboadanɨ nɨŋgombo ahandɨ hoearɨ bɨdɨfɨrɨ-mayo ranɨfihɨ masündeandɨ. ");
INSERT INTO agg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ai ahandɨ hohoanɨmonambo yaŋgɨrɨ yare hoafɨyowohü yahoya, “Ro moanɨ ahandɨ hoearɨ ranɨ-yaŋgɨrɨ asündɨheandɨ amboanɨ aboedɨndaheamboyahɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sisas ai hɨhɨrɨfihɨ hoeireandühɨ hoafɨyuhü yahuya, “Wandɨ nɨmorɨ, se moanɨ ŋgusüfo afurɨndo kündowandɨ. Sɨhafɨ anɨhondümbofe ranambo aboedɨreanɨnɨ-mboane,” mehundo-amboyo. Asu moanɨ mamɨ ranɨ sɨmboanɨ hamɨndɨ nɨmorehɨ ranai aboedɨmayo. ");
INSERT INTO agg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ranɨyu Sisas ai bogorɨ nindou-mayu ranahandɨ worɨna mahu. Ranühɨ ai hoeireandane nindou yɨnafoai tütüre haya meŋgoro nɨmorehɨ nɨmorɨ ai yifɨmayoambo asu nɨmorehɨ nindowenihɨ afɨndɨ ranai hoafɨ afɨndɨ afɨndɨyei wakɨmarɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ranɨyu asu ai aheimbo hoafɨyundürühɨ yahuya, “Muŋguambo nindou se ragu andai! Nɨmorɨ akɨdou ndanana moai yɨfeyo, ŋga ai moanɨ apomboane ana,” mehu-amboyei. Asu muŋguambo nindou ranai ahambo tɨkɨfɨnambo-marɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nindou afɨndɨ ranaheimbo bukürɨmafoareandüra nɨmorɨ akɨdou-mayo ranahandɨ fondanɨ kefuai hüfu warühɨ kümefindoa aboedɨ botɨmefeyo. ");
INSERT INTO agg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Sisas ai ahambo ramareandɨ hoafɨ ranai muŋgu ranɨ hɨfɨhü nindou amarei ranai hɨmborɨyei pamarɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sisas ai ranɨhünda botɨfi haya nafɨnɨ hu ane, nindou yimbu hɨmboatɨharɨ ranai ahambo süŋgumarɨnɨrɨ hafanɨ. Ai hafanɨ Sisas ranahambo puküna hoafɨyafɨnandowohü safanɨya, “Defitɨndɨ nɨmorɨ, yɨhoehɨmbo se hɨpoambondowamunɨ,” masafɨnando. ");
INSERT INTO agg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sisas ai worambe kefuai hüfu ane hɨmboatɨharɨ nindou yimbumefanɨ ai ahambo-so tükümefɨneanda, asu ai ahafanɨmbo düdureapɨrühɨ yahuya, “Se wamboya, Ai yɨhoehɨmbo aboedɨndeamunümbui safanɨ hena anɨhondümbo-rɨneandai?” mehupɨramboyafanɨ. Asu ai hoafɨyafandühɨ safanɨya, “Yɨnɨ, Adükarɨ,” masafandamboyu. ");
INSERT INTO agg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Asu Sisas ai ahafandɨ hɨmboarɨ ra sündeapɨrühɨ hoafɨyuhü yahuya, “Se sɨhafandɨ anɨhondümbofe ranɨmbohünda ranɨ-moatükunɨ ranai sɨhafanɨmbo aboedɨmbeyopɨramboane,” mehupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ranɨyo asu ahafandɨ hɨmboarɨ ranai bɨrɨmarɨhoepɨrɨ. Ranɨyu asu Sisas ai ahafanɨmbo ahɨnɨ hoafɨyupɨrühɨ yahuya, “Se ndanɨ-moatükunɨ ndanahambo nindou amurambo weindahɨ hoafɨndamboyafanɨ,” mehupɨrɨyosɨ. ");
INSERT INTO agg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ŋga asu ai ranɨhünda botɨyafɨne hena hafanɨ ranɨ hoafɨ ranahambo, muŋguambo ranɨ hɨfɨhü nindou ranaheimbo hoafühɨmarɨneanda hɨmborɨyei pamarɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ai ranɨhünda botɨyafɨne henambo nafɨ hafandane, nindou bɨdɨfɨrɨ ai nindou ahandɨ fiambe moaruwai nendɨ nɨmarɨ hayambo ranɨmbohünda hoafɨ-koateayu-randeimbɨ ranahambo Sisas sowana sahorɨmɨndei tükümehindɨ. ");
INSERT INTO agg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sisas ai nindou ranahandɨ fiambeahɨndɨ moaruwai nendɨ ra raguanambo-mareanda asu moanɨ mamɨ ranɨ-sɨmboanɨ nindou ranai hoafɨ wataporɨmayua muŋguambo nindou ranai mahepünehindɨ. Ai rarɨhi hoafɨyeihɨ seiya, “Ro moai Israer hɨfambe yahurai moatükunɨ horombo tüküfeyoanɨ hoeirɨhundɨ,” masei. ");
INSERT INTO agg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ŋga asu Farisi nindou ai yaru hoafɨyomondühɨ yahomoya, “Moaruwai nendɨ-yafe bogorani ai ahandɨ ŋgɨnɨndɨ ranambo moaruwai nendɨ ranaheimbo hemafoarearü,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sisas ai adükarɨ ŋgoafɨ asu akɨdou ŋgoafɨ ranambe ndüfosi ndüfosiyuhü hoahoaŋgu wakɨmareandɨ. Ai refihɨ muŋguambo Suda-yafe rotu worambe nindoumbo yamundɨreandürühɨ Aboedɨ Hoafɨ sapo God ŋgɨnɨndɨ hɨfandarandɨ ranahambo bokarɨhendürɨ marandɨ. Asu nindou moanɨ ranɨ-poanɨmbo ranɨ-poanɨmbo aŋgünümbɨ ranaheimbo aboedɨreandürɨ marandɨ. ");
INSERT INTO agg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Asu ai nindou afɨndɨ ranaheimbo hoeireandürühɨ ahandɨ ŋgusüfo ranai aheimbo hɨpoambo afɨndɨ hɨpoamborandürɨ marandɨ. Nɨmboe sapo ai afɨndɨ hohoanɨmoyeihɨ moanɨ fehefe nindou-koateayei sapo sipsip aheimbo hɨfandɨ-koate burɨyei wakarɨhindɨ nou ramehindɨ. ");
INSERT INTO agg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ranɨyu ai ahambo süŋgururü-rundeimbɨ-memo ranahamumbo hoafɨyuhü yahuya, “Sesɨ ra yimuŋgurɨ yɨmɨndɨmbo ranana afɨndane anɨŋgo, ŋga asu yimuŋgurɨ yɨmɨndɨ nindou ranana moanɨ yɨkoarɨfo-ane. ");
INSERT INTO agg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yimuŋgurɨ Aharambürɨ ahambo dɨdɨbafɨfeyoanɨ anɨmbo asu ai yimuŋgurɨ yɨmɨndɨmbo nindou bɨdɨfɨrɨ koandɨhenda ahandɨ yimuŋgurɨ ra yimuŋgurɨhümündi mbüsühüsi-amboane,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sisas ai ahandɨ süŋgururü-rundeimbɨ 12 ranahamumbo mborai yahupurɨ hühüreapurɨ haya mamühɨ asu ai ahamumbo moaruwai nendɨ nindou fiambeahɨndɨ raguanambofe asu muŋguambo ranɨ-poanɨmbo ranɨ-poanɨmbo aŋgünɨ ra aboedɨferambo ŋgɨnɨndɨ masagapurɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kraisɨndɨ hoafɨ sowandümo homo-rundeimbɨ-yomondɨ ndüranepurɨ nda: Saimonɨmboyu Pitamboyu-randeimbɨ, ahandɨ akɨdɨ Andru, Sems asu ahandɨ akɨdɨ Son ai Sebedindɨ nɨmoranafanɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Firip, Bartoromyu, Tomas anemo, Matyu nindou ra ai takis kakɨ semündü-randeimbani. Sems Arfiusɨndɨ nɨmorani, asu Tadiusani. ");
INSERT INTO agg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon Serot asu Sudas Iskariot nindou sapo Sisasɨmbo hürütümbɨ-yomondɨ warühɨ hɨnɨŋgɨndirümbui. Ahamundɨ ndüranepurɨ ra. ");
INSERT INTO agg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sisas ai nindou 12 ranahamumbo randafu-randafu ndundɨ yahuhaya hoafɨ sagapurɨ mbura koarɨhepurühɨ yahuya, “Se nindou ŋgorü sɨrɨhündɨyei hɨfambe-ane asu bɨdɨfɨrɨ Samariayei ŋgoafɨ ranambe-ane ra ŋgomboemo, ŋga yowanɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ŋga ranɨnɨ hɨmbo-memohündɨ asu se moanɨ hɨhɨndafu sapo farɨhehindeimbɨ sipsip nɨnɨhondɨ nou Israer nindou burɨyeianɨ anɨmbo ŋgomo. ");
INSERT INTO agg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ranɨnɨ anɨmbo se ŋgomo wataporɨmbondundühɨ anɨmboya, God ŋgɨnɨndɨ hɨfandarandɨ ranai ana ndeara akɨmane, mbɨsɨmo. ");
INSERT INTO agg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Asu se nindouyei aŋgünɨ aboedɨndundürɨ, yɨfɨyeimbɨmbo yaŋgɨrɨ aboedambo botɨndu hɨnɨŋgɨndundürɨ, mɨmanɨhoeimbɨ aheimbo aboedɨndundürɨ asu moaruwai nendɨ ranaheimbo raguanambondundürɨ. Se moanɨ masowandümo-ane, ŋga rananɨmbo se moanɨ ndoundɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Se ŋgomondühɨ sɨhamundɨ hoearambe gor, sirfa, kakɨ ra ndowandümboemo. ");
INSERT INTO agg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Se arü, hoearɨ yimbu, su, nɨmɨ-nɨmɨ, muŋguambo ranɨ-napo ra fihɨ ndowandümo ŋgomboemo, ŋga wanɨ. Nindou ratüpurɨyu-randeimbɨ ranai anɨmbo nindou ŋgorü ahambo sesɨ napo ra mbɨsagado-amboane. ");
INSERT INTO agg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Se adükarɨ ŋgoafɨhüyo asu akɨdou ŋgoafɨhüyo nahanühɨyo se tükefundɨ ra nindou mbumundɨyuweimbɨ ranahambo anɨmbo kokondurɨ. Asu se yahurai nindou hoeindurühündoanɨ se ai-babɨdɨmbo nɨŋgomo mbundu ŋgorünɨnɨ ŋgomondühɨ anɨmbo ahambo randu hɨnɨŋgɨndüwurɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Se nindouyei worambe fandafundühɨ ana, nindou ranɨ worambeahɨndɨ-mayei ranaheimbo hoafɨndɨmondühɨ anɨmboya, ‘God ai sɨheimbo aboedɨ aboedɨ-mbɨreandüramboane,’ mbɨsɨmondürɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nindou ranɨ worambeahɨndɨ ai sɨhamumbo worɨnɨndɨhipuranɨ ana, sɨhamundɨ hɨhɨfɨ hoafɨ ra randu ranaheimbo-so dɨgau houmbo ŋgomo. Ŋga asu nindou ai sɨhamumbo refe worɨnɨfepurɨ-koatendeianɨ ana, sɨhamundɨ hɨhɨfɨ hoafɨ ra hɨhɨndu ndowandümo ŋgomo. ");
INSERT INTO agg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Asu nindou bɨdɨfɨrɨ ai worambeyo adükarɨ ŋgoafɨhüyo nahi ra ai sɨhamumbo worɨnɨfepurɨ-koatendei, sɨhamundɨ hoafɨ ranahambo hɨmborɨ-koatendeianɨ ane, ranana se sɨhamundɨ tɨŋarɨ fihɨndɨ hɨfɨ hasüfɨ ra kɨkɨboadu houmbo ŋgomo ranaheimbo God ai moaruwaimbo-mbɨreandürɨ yaho refe nafuiyondürɨmbohünda. ");
INSERT INTO agg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ro sɨhamumbo anɨhondümbo-anahɨ nda hoafehapurɨ, Yɨbobofe si ra tüküfeyoambe ana, Sodom Gomora ŋgoafɨhündɨ nindou ranaheimbo tɨŋɨrɨfo afɨndɨ tükündɨfemboesɨ, ŋga nindou sɨhamumbo worɨnɨfepurɨ-koatendeianɨ, nindou ranɨ ŋgoafambe amarei ranaheimbo tɨŋɨrɨfo afɨndɨ safɨ tükündɨfemboe.” ");
INSERT INTO agg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Se hɨmborɨyomo. Sɨhamumbo ro sipsip nou nɨmambeahɨndɨ yaforɨ afɨndɨ burɨyei-ambe koararɨheheapurɨ. Ŋga se moanɨ sapo amoasɨrɨ rawefeyo nou hohoanɨmo-ndɨmondühɨ hɨbadundɨ. Asu ndu wupufo rawefeyo nou yahurai hɨmboarɨ hoafendühɨ nɨmandɨmo. ");
INSERT INTO agg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Awi se hɨbadümbo, ŋga sɨhamumbo nindou bɨdɨfɨrɨ ai mbundüpundümo mbundu kotambe papɨ-hoafɨndüpurɨmboemo asu ahamundɨ rotu worɨ ranambe ndüfurɨboadɨpurɨmboemo. ");
INSERT INTO agg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wambohündambo sɨhamumbo nindou ranai gafmanɨ-yomondɨ bogorɨ nindou asu bɨdɨfɨrɨ adükarɨ bogoranemo ranahamumbo sowana papɨ-hoafɨyopurɨmbo kündafu hündüpundümo ŋgomboemo. Asu se nindou ranaheimbo-ane asu ŋgorü nindou ŋgorü sɨrambe-ahɨndane ra Aboedɨ Hoafɨ wataporɨmbondündürɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ai sɨhamumbo papɨ-hoafɨyopurühɨ refe hoeifepurɨmbo ndowapundümo ŋgomondanɨ wanɨ asu nüŋgu-nahurai hoafɨ hoafɨndefühɨ asu nüŋgundɨhu hoafɨmandefɨ mbɨsɨmo houmbo afɨndɨ hohoanɨmo-ndɨmboemo, ŋga wanɨ. Se hoafombo-yomondɨ sɨmboanɨ anɨmbo God ai sɨhamumbo nɨne-hoafɨ hoafombo-memo ra nafuindüpurühɨ ranɨ-süŋguru hoafɨyomo mbüsüpurɨmbui. ");
INSERT INTO agg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ranɨ hoafɨ se wataporɨmboarundɨ ra sɨhamundɨ-mayo hoafɨyopoanɨ, ŋga wanɨ. Hoafɨ ranana sɨhamundɨ Ape God ranahandɨ Yifiafɨ ranai-anɨmbo sɨhamundɨ yafambe süŋgunde haya moanɨ aimbo wataporɨmbondamboe. ");
INSERT INTO agg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nindou bɨdɨfɨrɨ ai ahamundɨ apodoho ranahamumbo hɨfokoefembohünda ŋgorü nindou-yomondɨ warühɨndüpurɨmboemo. Asu afɨndɨ mamɨ ai ahamundɨ nɨmorɨ ranaheimbo amboanɨ moanɨ mamɨ ranɨ-süŋgundundürɨmboemo. Asu nɨmorɨ ai-amboanɨ ahei boagɨrɨ ranaheimbo daboadɨ hɨhɨrɨndɨhindühɨ aheimbo hɨfokoandɨ-hindürɨmboyei. ");
INSERT INTO agg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wambohündambo nindou ai sɨhamumbo yɨboarukondɨhipurɨmboyei. Ŋga asu düdi ai ranɨ-moatükunɨ tɨŋɨrɨfo ranahambo moanane yahu ŋgɨnɨndɨ kɨkɨhamündɨ hu humbo bɨdɨfɨranɨ tükefiyu aiana aboedambo-ndɨfimbui. ");
INSERT INTO agg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Sɨhamumbo ŋgorü ŋgoafɨhü moaruwai moaruwaimbo-ndɨhipuranɨ ana, ranɨ ŋgoafɨ ra hɨnɨŋgɨndu houmbo ŋgorü ŋgoafɨnɨ febou ŋgomo. Ro sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ, Se Israerɨ-yafe ŋgoafɨ muŋguambo hokoateyomondambe anɨmbo Nindou Hondü ai kudümbui. ");
INSERT INTO agg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yamundɨhindeimbɨ nindou ranai moai ahandɨ yamunde-randeimbɨ nindou ranahambo ŋgasündirɨ. Asu ratüpurɨyu-randeimbɨ nindou ranai moai ahandɨ bogorɨ nindou ranahambo ŋgasündirɨü, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ŋga yamundɨhindeimbɨ nindou ranai anɨmbo ahandɨ yamunde-randeimbɨ nindou ranɨ sɨmogodühɨ tükefiyu ana, hɨhɨfɨ-hɨhɨfɨiyu-wamboane. Asu yahurai anɨmbo nindou ŋgoründɨ ratüpurɨyu-randeimbɨ ai-amboanɨ ahandɨ bogorɨ nindou ranɨ sɨmogodühɨ tükefiyu ana, ranai hɨhɨfɨ hɨhɨfɨiyu-wamboane. Worɨ aharambürɨ-mayu ranahambo ndürɨ moaruwai dükarɨhorühɨ Bersebur asahündo ana, nindou mamɨ ranɨ worambe amarei ranaheimbo amboanɨ moanɨ moaruwai hamɨndɨ ndürɨ hondü anɨmbo dükandɨhindürɨmboyei.” ");
INSERT INTO agg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ranɨmboane asu se nindoumbo yɨhɨmbo sɨsɨrɨfepoanɨ. Nɨne-moatükunɨ hapondanambe gabudambe eŋgoro ranana asu süŋgunambo weindahɨ gabudɨwamɨ nɨmoamo yagodomboe. Nɨne-moatükunɨ muŋguambo dɨbo meŋgoro ranai weindahɨ fɨfɨnde-fɨfɨndendamboe. ");
INSERT INTO agg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nɨne-moatükunɨ ro sɨhamumbo nɨmbɨ nɨmaro-ambe hoafehapurɨ ra asu se sɨrühɨ si peyoanɨ ro hoafɨmayahɨ süŋgu kaindɨmo hoafɨndomo. Nɨne-moatükunɨ se dɨbo hɨmboreyomo ra asu se weindahɨ worɨ bogɨmondɨ wamɨ puküna bokarɨhoemo. ");
INSERT INTO agg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nindou ai fi hoearɨ ranahambo hɨfokoarundühanemosɨ, ŋga asu ŋgɨrɨ yifiafɨ hɨfokoandundɨ se ranahamumbo yɨhɨmbondɨpurɨmboemo. Ŋga Godɨmbo anɨmbo yɨhɨmbondurɨ, ŋga aianɨmbo fi hoearɨ asu yifiafɨ ranɨ kameihɨ muŋguambo Haiambe ranɨ-nambo ndemündü moaruwaimbo-ndeambuimbohünda. ");
INSERT INTO agg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ndu akɨdou yimbu ra mamɨ toeanambo yaŋgɨrane pemɨyei sahümündi arɨhündɨ. Ŋga asu sɨhamundɨ Ape ranai refembo moei ehu ana, asu ŋgɨrɨ ndu akɨdou yahurai amboanɨ hɨfɨnɨ pɨndo, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Sɨhamumbo ana, sɨhamundɨ mbɨrɨnaŋɨ amboanɨ muŋguambo mamɨ mamɨ ra tapuiyoweimbanepurɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Se Godɨndɨ hɨmboahü adükaranei, ŋga ndu afɨndɨ akɨdou ane. Ranɨmbohündambo anɨmbo se nɨnɨ-moatükunɨmbo yɨhɨmbondɨmboemo.” ");
INSERT INTO agg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nindou düdi ai wandɨ ndürɨ ranahambo nindou hɨmboahü weindahareandürɨ ana, asu sɨmborɨ nindou ranahandɨ ndürɨ wandɨ Ape sünambe amaru ranahandɨ hɨmboahü weindahɨndɨheamboyahɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ŋga asu nindou düdi ai wandɨ ndürɨ ranahambo nindou hɨmboahü weindahɨfe wataporɨmbo moei ehu ana, asu sɨmborɨ amboanɨ ranahandɨ ndürɨ ranahambo wandɨ Ape sünambe amaru ranahandɨ hɨmboahü weindahɨfembo moei mbɨsamboyahɨ.” ");
INSERT INTO agg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Se wambo randɨhi hohoanɨmondeihɨya, Ai yifiarɨ-yifiarɨ hɨfɨ ndanühɨ eŋgoro ra kɨkɨfembo makusu-ane mbɨseimboyei, ŋga wanɨ. Ro moai yifiarɨ-yifiarɨ ranahambo kɨkɨfemboyahɨpoanɨ makosahɨ, ŋga roana pisao yihɨmɨndɨ nahurai sahamɨndɨ heheamboyahɨ makosahɨ. ");
INSERT INTO agg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Rananɨmbo ro randɨheiaranɨ, Nindowenihɨ nɨmorɨ ai afɨndambo hürütündürümbui. Asu nɨmorehɨ nɨmorɨ ai ahandɨ hondambo hürütündamboe. Asu nɨmorehɨ ahandɨ ahɨboarambo hürütündamboe. ");
INSERT INTO agg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nindowenihɨmayu ahandɨ fikɨmɨnɨndɨ anɨmbo ai ahambo hürütündɨhorɨmboyei. ");
INSERT INTO agg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nindou düdi ai ahandɨ afɨndamboyu asu ahandɨ hondamboyo ahafembo afɨndɨ hohoanɨmoyupɨrühɨ asu wambo akɨdou yaŋgɨrɨ hohoanɨmoayu ana, nindou ranai ŋgɨrɨ wandɨ süŋgureandeimbɨ nindoundu. Asu nindou düdi ai ahandɨ nindowenihɨ nɨmorɨmboyu asu ahandɨ nɨmorehɨ nɨmorɨmboyo ahafembo afɨndɨ hohoanɨmoyupɨrühɨ asu wambo akɨdou yaŋgɨrɨ hohoanɨmoayu ana, nindou ranai ŋgɨrɨ wandɨ süŋgureandeimbɨ nindoundu. ");
INSERT INTO agg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nindou düdi ai ahandɨ nɨmɨ keimbɨ karɨhendeimbɨ ra semündü haya ro ahahɨ anümɨ süŋgu ho-koateayu ana, nindou ranai ŋgɨrɨ wandɨ süŋgureandeimbɨ nindoundu. ");
INSERT INTO agg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nindou düdi ai ahandɨ yaŋgɨrɨ nɨŋgo ranahambo kɨkɨharɨmündu ana, ranɨ-moatükunɨ ra ai awarɨndɨhoemboe, ŋga asu nindou düdi ai wambohündambo ahandɨ yaŋgɨrɨ nɨŋgo ranahambo hɨnɨŋgareandɨ ana, nindou ranai ahandɨ yaŋgɨrɨ nɨŋgo hondü ra ndemündümbui.” ");
INSERT INTO agg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nindou düdi sɨhamumbo aboedɨ ndɨndoareapurɨ ranai ana, wambo kameihɨ ndɨndoreandɨrühani. Asu ai wambo ndɨndoareandɨrɨ ana, Nindou sapo wambo koamarɨhendɨra makosahɨ ranahambo amboanɨ ndɨndorirühani. ");
INSERT INTO agg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nindou düdi ai Godɨndɨ hoafɨ hoafɨyu-randeimbɨ ranahambo ndɨndoarirɨ ana, sapo Godɨndɨ hoafɨ hoafɨyu-randeimbɨ-mayuambo wambo, nindou ranai Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou ranahandɨ takɨnɨ ra sɨmoŋgodɨ ai-amboanɨ ndemündümbui. Nindou düdi ai nindou mbumundɨ ranahambo ndɨndoarirɨ ana, sapo nindou mbumundɨ-mayuambo wambo, nindou ranai mbumundɨ nindou ranahandɨ takɨnɨ ra sɨmogodɨ ai-amboanɨ ndemündümbui. ");
INSERT INTO agg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ro nda sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ, nindou mamɨ ai-amboanɨ ahambo horirühɨ awi ai Sisasɨmbo süŋgurirɨ-randeimbɨ nindou-ani nda, ŋga ro ahambo hoe ŋgɨsɨharɨ fuihando ehu ana, nindou ranahandɨ takɨnɨ ra ŋgɨrɨ awandɨhoayo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sisas ai ahambo süŋgururü-rundeimbɨ 12 ranahamumbo ra-süŋgundundɨ hoafɨ ra yahu sagapurɨ haya, ranɨhünda botɨfi haya nindou ranɨ ŋgoafɨkɨmɨ amarei ranaheimbo Aboedɨ Hoafɨ bokarɨhefendürɨmbo asu yamundɨfindürɨmbo ahei ŋgoafɨna mahu. ");
INSERT INTO agg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Son hundürɨrarü-randeimbɨ ai karabusambe nüŋgumbo nɨne-moatükunɨ ratüpurɨ Krais ai ratüpurayu ranahambo hɨmborɨyu haya, asu ai ahambo süŋgururü-rundeimbɨmbo koarɨhepura ahambo sowana mahomo. ");
INSERT INTO agg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ai homo Sisasɨmbo düduyafundowohü yahomoya, “Se yɨhoefɨmbo hoafɨyafɨmunɨ. Son ai hoafɨyuhüya, ‘Awi nindou wandɨ süŋgu düdümbui,’ mehu ranɨyafɨ se ndane asu ro nindou ŋgorümbo tükündüfimbui mbɨsefɨ hoahu hɨmbomandefɨyo?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Se nɨnɨ-moatükunɨyo hɨmborayomo-ane asu hoeiarundɨ ranane ranɨ-moatükunɨ ranahambo hɨhɨrɨndafu ŋgomo Sonɨmbo hoafɨndɨmondo. ");
INSERT INTO agg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nindou hɨmboatɨharɨ ai aboedɨ hɨmboarayei, tɨŋarɨ moaruwaimbɨ ai asükaiyei aboedɨ ahahabodei, nindou nɨmanɨho fi hoearɨ-mayei ai fi aboedayei asu nindou hɨmbotühüfu güreareimbɨ-mayei ai asükaiyei hoafɨ hɨmborayei. Nindou yɨfɨyeimbɨhündɨ ai yaŋgɨrɨ botehindɨ asu nindou napo-koateyeimbɨ ranai Godɨndɨ Aboedɨ Hoafɨ ra aheimbo bokarɨhefendüra ai hɨmborayei. ");
INSERT INTO agg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nindou ai wambo yimbu hohoanɨmo-koatendühɨ ana, nindou ranai hɨhɨfɨ-hɨhɨfɨiyu-wamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sonɨndɨ süŋgururü-rundeimbɨ ranai ndamefundamboyu mamɨ ranɨ-sɨmboanɨ Sisas ai nindou afɨndɨ burɨmayei ranaheimbo Sonɨmbohünda hoafɨyundürühɨ yahuya, “Sapo se nɨmɨ wohɨ furɨ-koateyoweimbɨ hɨfɨhü Son sowana mahei ra nɨnɨ-moatükunɨmboyei tüküfeyoanɨ hoeifemboane maseia? Awi se werɨnambo boabodarɨ momoaŋgorü-marandamboyo hoeifembo maheia? ");
INSERT INTO agg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Asu se nɨnɨ-moatükunɨ hoeifemboyei ranɨnɨ mahei rana? Nindou ai moanɨ ranɨ-poanɨmbo hoearɨ yihururamündü haya manüŋgu ranɨ hoeifemboyei mahei? Nindou yahurai hoearɨ yihururündümondeimbɨ ana bogorɨ adükarɨ nindou-yomondɨ worɨ ranambe-ane nɨŋgomo arundɨ. ");
INSERT INTO agg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Se nɨnɨ-moatükunɨ ranahambo hoeifemboyei ranɨnɨ mahei rana? Godɨndɨ hoafɨ hoafɨyu-randeimbɨ ranahambo hoeifemboyei? Yɨnɨ, ro sɨheimbo hoafehandürɨ nindou se hoeimarɨhorɨ ranana Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou ranahambo ŋgasündireimbɨ adükarɨ hamɨndɨyu se ahambo hoeimarɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ŋga Son ranahamboyo Baiborambe God ai hoafɨyuhü yahuya, ‘Ro wandɨ hoafɨ semɨndɨ hombo nindou ranahambo boatei horombo sɨhafɨ nafɨ dɨboadɨfembo koandɨhehinɨmboyahɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ro sɨheimbo anɨhondümbo-anahɨ hoafehandürɨ nda, Son hundürɨrarü-randeimbɨ aiana sapo nindou muŋgu ndanɨ hɨfɨhü manɨmboadei ranaheimbo ŋgasündeandürɨ haya moanɨ adükarɨ hamɨndani. Ŋga asu nindou moanɨ akɨdou ai God ŋgɨnɨndɨ hɨfandarandɨ ranambe anɨmboei ana, ranai Sonɨmbo ŋgasündɨhorɨmboanei. ");
INSERT INTO agg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Son hundürɨrarü-randeimbɨ ai ranɨ-sɨmboanɨ ranambe piyu haya ho ho hombo hapondanambe-amboanɨ, nindou ai seiya, Sɨhɨrɨ yifiarɨ yifiarɨndefanɨ anɨmbo God ŋgɨnɨndɨ sünambe hɨfandarandɨ ra tükündɨfemboe, masei. ");
INSERT INTO agg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ho ho hombo Son ai nüŋguambeyo Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨyomo asu Mosesɨndɨ-mayo ahɨnümbɨ hohoanɨmo ranɨyo muŋguambo ranɨ-moatükunɨ tükündɨfemboe yahomo ranahambo wataporɨmbo-marundɨ. ");
INSERT INTO agg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ŋga asu se wandɨ hoafɨ ranahambo hɨmborɨmboayei ana, hɨmborɨndei. Son aiana Eraisa-ani nindou awi tükümbɨfiyuwambo-ane masei horombo. ");
INSERT INTO agg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Se hɨmboambeimbɨndeihɨ ana, awi se hoafɨ nda hɨmborɨndei. ");
INSERT INTO agg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nindou hapo ndanambe burayei ndanaheimbo ra nɨnɨ-moatükunɨ fihɨ aheimbo pandɨhe sɨmoŋgorɨndɨhe hoeimandɨheiara? Nindou ndanai ana nɨmorɨ bɨdɨfɨrɨ nahurai-anei. Nɨmorɨ akɨdɨbou maket fikɨmɨ nɨmareimbo, ahei bodɨmondambo hoafɨyeihüya. ");
INSERT INTO agg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ro sɨheimbo fufuŋɨ fufuŋayefɨ, ŋga asu se herümbo moei asei. Ro aranɨ hoafɨ herü herayefɨ, ŋga asu se aranɨmbo moei asei. ");
INSERT INTO agg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Son ai tüküfihɨ sesɨ wehɨyuhü wain hoe ranamboanɨ sɨmɨndɨ-koatemayu-amboyei, asu ahambo muŋguambo nindou ranai hoafɨyhündowohü seiya, Ahandɨ fiambe ana moaruwai nendɨ nɨmarɨndo-mboane! masahündo. ");
INSERT INTO agg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Asu Nindou Hondü ai tüküfi sesɨ ra sesü asu wain hoe ra sümündɨ raraomarandamboyei, asu muŋguambo nindou ranai hoafɨyeihɨ seiya, ‘Awi se nindou ndanahambo hoeirɨhorɨ! Nindou ndanai ana sesɨ afɨndeimbɨyu, asu wain hoe sɨmɨndɨ afɨndeimbani. Aiana takis kakɨ sowandümo-rundeimbɨ nindou-anemo asu moaruwai hohoanɨmoyomo-rundeimbɨ nindou-anemo ranahamundɨ ŋgunindani,’ masei. Ŋga asu God ai dɨboadore fɨfɨrɨre haya rareandanɨ aboedɨ moatükunɨ tükefeyo ranühündambo nindou ai ranɨ-moatükunɨ anɨhondane mbɨsei fɨfɨrɨndɨhimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sisas ai hepünɨfeimbɨ moatükunɨ afɨndɨ safɨ bɨdɨfɨrɨ adükarɨ ŋgoafɨhü ramareandɨ, ŋga ranɨ ŋgoafɨhündɨ nindou ranai ana moai ahei moaruwai hohoanɨmo ra daboadanambo-rɨhindɨ. Ranɨyu asu Sisas ai ranɨ ŋgoafɨ ranahambo watɨkoafɨmarandɨ. ");
INSERT INTO agg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ai yare aheimbo hoafɨyuhü yahuya, “Korasin se hɨpoanɨmbembou-anei! Betsaida se hɨpoanɨmbembou-anei! Sɨheimbo tɨŋɨrɨfo adükarɨ safɨ tükündɨfendürɨmboe! Nindou ŋgorü ai Tair Saidon ŋgoafambe hepünɨfeimbɨ moatükunɨ rambarea-mbonana sapo ro sɨhei ŋgoafambe ramarɨheandɨ nou, ranana asu Tair, Saidon ranai horombo hasüfɨ parɨhi sɨso sɨsoweimbɨ hoearɨ güdühi hehi nɨmarei ahei moaruwai hohoanɨmo daboadanambo-fembo nafuimbohünda. ");
INSERT INTO agg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ŋga ro sɨheimbo hoafehandürɨ nda, Godɨndɨ yɨbobofe si tüküfeyo-ambe ana, Tair, Saidon ŋgoafɨhündɨ nindou ranaheimbo tɨŋɨrɨfo afɨndɨ tükündɨfemboesɨ, ŋga sɨheimbo ana moanɨ adükarɨ hamɨndɨ tɨŋɨrɨfo anɨmbo tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Asu Kaperneam se ra. Asu sünambe botɨfe hafombo hohoanɨmoyeiyai? Ŋga seana Haiambe hɨfɨnɨ gadeimboyei. Nindou ŋgorü ai Sodom ŋgoafambe hepünɨfeimbɨ moatükunɨ rambarea-mbonana sapo ro sɨhei ŋgoafambe ramarɨheandɨ nou, Sodom ai aboedɨ yaŋgɨrɨ yare ho. ");
INSERT INTO agg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ŋga ro sɨheimbo hoafehandürɨ nda, Godɨndɨ yɨbobofe si tüküfeyo-ambe ana Sodom ŋgoafɨhündɨ nindou ranaheimbo tɨŋɨrɨfo tükündɨfemboesɨ, ŋga sɨheimbo ana moanɨ adükarɨ hamɨndɨ tɨŋɨrɨfo anɨmbo tükündɨfemboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mamɨ ranɨ-sɨmboanɨ Sisas ai yare hoafɨyuhü yahuya, “Ape, sünü hɨfɨ ranahandɨ Adükarɨ bogorɨ, ro sɨhambo hɨhɨfarɨhanɨnɨ. Sapo se sɨhafɨ hohoanɨmo ra nindou hohoanɨmo fɨfɨrɨhindeimbɨ-mayei ranahei hɨmboahü dɨbonapɨro mbura asu nɨmorɨ akɨdɨbou ranaheimbo nafuiyafɨndürɨ-mboanafɨ. ");
INSERT INTO agg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yɨnɨ Ape, seana ranɨ-moatükunɨ ra yahurai yare tükümbɨfeyo safɨ hawamboyafɨ hohoanɨmomayafɨ. ");
INSERT INTO agg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Muŋguambo moatükunɨ ra wambo wandɨ Ape ranai wandɨ warɨwamɨ manandeandɨ. Nindou düdi ŋgorü ai moai Nɨmorɨmbo fɨfɨrirɨ, ŋga moanɨ Afɨndɨ ai yaŋgɨrani fɨfɨrirɨmboayu. Asu nindou düdi ŋgorü ai moai Afɨndambo fɨfɨrirɨ, ŋga moanɨ Nɨmorɨ ai yaŋgɨrani fɨfɨrirɨmboayu. Asu nindou bɨdɨfɨrambo Nɨmorɨ ai ahandɨhoarɨ Afɨndambo nafuimbo yahumbo rananɨmbo ai-amboanɨ Afɨndambo fɨfɨrirɨmboayu. ");
INSERT INTO agg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nindou se dɨdɨyei afɨndɨ tɨŋɨrɨfoayeihɨ fiambe yɨboarukoarandürɨ habodei ranana se mborai wambo sowana ndühɨ dügüsianɨ anɨmbo ro sɨheimbo afurɨndɨhe hɨnɨŋgɨndɨheandürɨmboyahɨ. Asu wandɨ nɨmborɨ nɨmühɨ kündɨho se rodɨbo yɨbobondahoamɨnde. ");
INSERT INTO agg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Rananɨmbo asu wambo fɨfɨrɨndɨ-hindɨrɨmboyei, nɨmboe sapo roana nindoumbo hɨmboarɨ hoafendühɨ hɨnɨŋgɨrou safɨ rarɨhearühanahɨ asu wandɨhoarɨ fi hɨfɨnambo-rɨheandühanahɨ. Rananɨmbo asu se sɨhei ŋgusüfo ranahambo afurɨfe kifembo hoeindɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ŋga nɨmɨ ro sɨheimbo segodürɨmboyahɨ ranana tɨŋümbɨyopoanɨ, ŋga ro sɨheimbo semɨndɨmbo asahandürɨ ranana ai nɨmboreimbɨyopoanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ranɨ-sɨmboanɨ moanɨ nɨmarɨmbo si tüküfeyo-ane, Sisas ai wit nümbürambe mahu. Asu ahambo süŋgururü-rundeimbɨ ai ranühɨ wembomboyondühɨyo ai nümbürɨ ranambeahɨndɨ witɨ-mayo ra hüründümo masowasümo. ");
INSERT INTO agg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Asu Farisi ai ra hoeiru houmbo Sisasɨmbo hoafɨyomondühɨ yahomoya, “Awi se rando hoeindowandɨ, sɨhafɨ süŋgurunɨnɨ-rundeimbɨ ai ranɨ-moatükunɨ rarawarundɨ ra yɨhoefɨ moanɨ nɨmarɨmbo si ahɨnümbɨ hohoanɨmo ranahambo gogonɨmbo-foarundühanemo!” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya “Asu se Bukambe moai hoeirundɨyo, sapo nɨne-moatükunɨ Defit ai ahandɨ nendɨ bɨdɨfɨrɨ ra babɨdɨmbo wembomboyomondühɨ ramareandɨ rana? ");
INSERT INTO agg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sapo ai Godɨndɨ worɨ ranambe kefuai hüfu ahandɨ nendɨ bɨdɨfɨrɨ-memo ranɨ-babɨdɨmbo bret Godɨmbo hoafɨyo sɨhefeimbɨhündɨ masowasümo ra. Ranɨ-moatükunɨ ra ai sesɨmbo ahɨnümbɨyo, sapo nindou Godɨmbo sɨhou-rundeimbɨ ranɨ yaŋgɨrɨ bret ra sesɨmbo-mayo. ");
INSERT INTO agg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Asu awi se moai Mosesɨndɨ ahɨnümbɨ hohoanɨmo ra hoeirundɨyo? Sapo muŋguambo moanɨ nɨmarɨmbo si ranambe nindou sɨhou-rundeimbɨ sapo Godɨndɨ worɨ ranambeahɨ ahɨnümbɨ hohoanɨmo ra gogonɨmbofoaru marundɨ, ŋga hütiyomopoanɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Awi ro nda sɨhamumbo hoafehapurɨ. Godɨndɨ worɨ ranahambo ŋgasündeandeimbɨ nindou ndanühɨ anüɨŋgu. ");
INSERT INTO agg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Baiborambe yare hoafɨyowohü yahoya ‘Hɨpoambo hohoanɨmo ranahambo roana yifirayahɨ, ŋga asu nɨnɨhondɨ hɨfokoefe sɨhefe hohoanɨmo ranahambo ana moai yifirɨyahɨ,’ meho. Asu se ranɨ hoafɨ ra nɨnɨ nɨmɨndɨhündɨmboyo yare hoafɨmayo ranahambo fɨfɨrɨhi-mbonana, asu nindou ai nɨne-moatükunɨ hüti refe-koatemayomo se ŋgɨrɨ ranahamumbo papɨ-hoafɨndüpurɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nindou Hondü ranai ana moanɨ nɨmarɨmbo si ranahandɨ aharambürani,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sisas ai ranɨhünda botɨfi haya, Suda-yafe rotu worɨna mahu. ");
INSERT INTO agg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ranühɨ nindou mamɨ watɨŋarɨ moaruwaimbü ranai mamaru. Asu nindou bɨdɨfɨrɨ ai Sisasɨmbo papɨ-hoafɨyumbo yahomo houmbo mamarɨmo, ai ahambo düduyafundowohü yahomoya, “Moanɨ nɨmarɨmbo sihɨ nindou ai aboedɨfembo ratüpurɨ ratüpurayu ana, asu ai yɨhoefɨ ahɨnümbɨ hohoanɨmo gogonɨmbɨfoareandühɨyo wanɨyo?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Asu Sisas ai ahamumbo sɨmborɨ hoafɨyuhü yahuya, “Asu sehündɨ nindou mamɨ ai sipsip ra moaŋguirandanɨ nɨŋgo haya asu moanɨ nɨmarɨmbo sihɨ hɨfambe ambe pɨrayo ra ai nüŋgumandea? Nindou ranai si ranɨfihɨ ahandɨ sipsip ranahambo hɨfambe ambeahɨndɨ nɨmoamo hündamündɨ tükümandüfiyo wanɨyo? ");
INSERT INTO agg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nindouyei nɨŋgo ranana sipsipɨyei nɨŋgo ranahambo ŋgasünde haya adükarɨ moatükunɨ ane! Ranɨmayomboane nindou moanɨ nɨmarɨmbo sihɨ nindoumbo farɨhefembo hohoanɨmo ra waŋgeiayo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ranɨyu asu Sisas ai nindou watɨŋarɨ moaruwaimbü-mayu ranahambo hoafɨyunduwohü yahuya, “Se sɨhafɨ watɨŋarɨ ra ŋgurɨhoefɨ,” mehundu-amboyu. Ranɨyu asu nindou-mayu ranai watɨŋarɨ ahandɨ ra ŋgurɨmarɨhenda asu ŋgorü rahurai aboedɨmayo. ");
INSERT INTO agg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ranɨyomo asu Farisi nindou-memo ranai homo Sisasɨmbo hɨfokoefimbo hoafɨ fɨfɨrɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sisas ai ahambo hɨfokoefimbo hoafɨ ra hɨmborɨyu haya, ranühɨnda botɨfi haya ndamefiyu. Ranɨyei nindou afɨndɨ ranai ahambo süŋgumarɨhorɨ hei. Ranɨyu asu Sisas ai aheimbo muŋgu aŋgünɨ ra aboedɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ai hoafɨyundürühɨ yahuya, “Se nindou amurambo wandɨ ndürɨ hoafɨndei-anɨ fɨfɨrɨndɨhindɨrɨmboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ranɨ-moatükunɨ ai ramareandɨ ra sapo God ai ahandɨ hoafɨ hoafɨyu-randeimbɨ Aisaia ahandɨ yafambihɨ ai hoafɨmayu yahurai anɨhondü tükümbɨfeyo yahu hayamboyu ramareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Sapo Aisaia ai yare hoafɨyuhü yahuya, “Wandɨ ratüpurɨyu-randeimbɨ nda kafoarɨhinɨ hɨnɨŋgɨmarɨhinɨ. Asu ro ahambo ŋgusüfo parɨhinühɨ siaowehinɨ. Ro wandɨ Yifiafɨ ahandɨ fiambe hɨnɨŋgɨndɨheandomboyahɨ asu ai wandɨ mbumundɨ hohoanɨmo ranahambo muŋguambo nindou ŋgorü sɨrambeahɨndɨ ranaheimbo bokandɨhendürümbui. ");
INSERT INTO agg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nindou ranai ana ŋgɨrɨ watɨkoafɨ hoafɨnduhɨ hoafɨ pukɨ kandɨhendɨ. Ŋgɨrɨ nindou ai hɨmborɨndei ai nafɨ bogorɨ ra puküna hoafɨndu wakɨnde ndandɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ai ŋgɨrɨ wohɨ emündü bürühoai yaŋgoroweimbɨ ranahambo muŋguna bübürɨboade dɨgendɨ. Asu ai ŋgɨrɨ ram hai akɨdou nɨmbɨraŋɨ reandeimbɨ ahoro ranahambo muŋguna dɨkɨnde kosɨboadeandɨ. Ŋga aiana moanɨ ratüpurɨndühɨ ŋgu ŋgumbo moanɨ aboedɨ mbumundɨ hohoanɨmo tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Rananɨmbo asu nindou ŋgorü sɨrambeahɨndɨ muŋgu ranai ahambo yaŋgɨrɨ anɨhondümbo-ndɨhorɨ ŋgeihɨ ahambo hɨmbondeimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ranɨyei asu nindou bɨdɨfɨrɨ ai Sisasɨmbo sowana nindou mamɨ moaruwai nendɨ ahandɨ fiambe nɨmarɨndo haya hoafɨ-koate hɨmboatɨharɨ nɨmarümbɨmayu ranahambo sahorɨmɨndei mahei. Sisas ai nindou ranahambo aboedɨmarira hoafɨyu hɨmboarɨyu arandɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ranɨyei asu nindou afɨndɨ ranai nɨnɨ-moatükunɨyo Sisas ramareandɨ ranɨmbo hoeirɨhi hehi mahepünehindɨ. Ranɨyei asu ai rarɨhi hoafɨyeihɨ seiya, “Awi nindou nda Defitɨndɨ nɨmorɨmbeyu?” masei. ");
INSERT INTO agg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisi nendɨ ai ranɨ hoafɨ hɨmborɨyomo houmbo sɨmborɨ hoafɨyomondühɨ yahomoya, “Sisas ai moaruwai nendɨ raguanambore arandɨ ra sapo Bersebur moaruwai nendɨ-yafe bogorɨ ranai ŋgɨnɨndɨ sagadowan-ani ai ranahandɨ ŋgɨnɨndɨnambo ranɨ-moatükunɨ ra yare arandɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sisas ai fɨfɨreandɨ Farisi ai nɨnɨmboyo hohoanɨmoemo ranɨmbo. Ranɨyu asu ai ahamumbo hoafɨyuhü yahuya, “Ŋgorü bɨdɨfɨrɨ hɨfɨ ranai ahafehoarɨ ŋgorügoanɨnɨ, yɨbobore ŋgorügoanɨnɨ yɨbobore haya sɨmborɨ yifiarɨ, sɨmborɨ yifiarayo ana, hɨfɨ ra ŋgɨrɨ amɨtata yikürübɨnde pɨndowohü awarɨndɨhoeyo. Asu bɨdɨfɨrɨ ŋgoafɨyo mamɨ ranɨ worambeahɨndɨyo ranai ahafehoarɨ yɨbobore ŋgorügoanɨnɨ, yɨbobore ŋgorügoanɨnɨ yɨbobore haya sɨmborɨ yifiarayo ana, ŋgɨrɨ gedambo nɨŋgo. ");
INSERT INTO agg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satan ai ahandɨ nendɨ bɨdɨfɨrambo hɨhaiboadɨpuranɨ ana, ahandɨ nendɨ ranai ndeara yikürübɨreandüh-ani. Ranɨmboane ahandɨ hɨfandarandɨ ra ŋgɨnɨndɨ nɨŋgombo nüŋgunde manɨŋgo? ");
INSERT INTO agg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Se yaru hoafɨyomondühɨya Bersebur ai ŋgɨnɨndɨ sendanane ai ranahandɨ ŋgɨnɨndɨnambo moaruwai nendɨ ranaheimbo raguanamboareandürɨ mehomondɨrɨ. Refeana, asu nindou düdi sapo nindou se mamambeyafundeimbɨ-memo ranahamumbo moaruwai nendɨ raguanambofe rambo ŋgɨnɨndɨ masagapura? Ranɨmbohündambo anɨmbo asu sapo nindou se mamɨmemo ranai se hüti-anemo mbɨsɨmo houmbo sɨhamumbo papɨndüpurɨmboemo! ");
INSERT INTO agg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bersebur ranaiyopoanɨ, ŋga Godɨndɨ Yifiafɨ wambo ŋgɨnɨndɨ sendɨranɨ ranɨnambo moaruwai nendɨ ranaheimbo raguanamboarɨheandürɨ. Ranane asu God ŋgɨnɨndɨ hɨfandɨrandɨ ranai sɨhamumbo sowahɨ ndeara tüküfembo-ane ranahambo se fɨfɨndundɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Asu nüŋgunde nindou ŋgorü ai sapo ŋgɨnɨndɨ hamɨndɨ harümbɨ ahandɨ worambe bɨrɨndɨhai fandɨfi ahandɨ napo ra fufumandamünda? Nindou ranai harümbɨmayu ranahambo mbundürümündɨ yirɨ warɨ hüputüpundürümündɨ hayambo anɨmbo ai ahandɨ worambe bɨrɨndɨhai fandüfi napo ra fufundamündümbui. Ŋga moanɨ ana ŋgɨrɨndu. ");
INSERT INTO agg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nindou düdi ai wambo ŋgunindɨmbofendɨrɨ-koateayu ana, ai wandɨ hürütümbani. Nindou düdi ai rodɨbo nɨne-moatükunɨ mamühɨ gugurɨfe-koateayu ana, nindou ranai mamɨkare pütiyu wakɨreandühani. ");
INSERT INTO agg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ranɨmboane asu ro ndanɨ-moatükunɨmbo-anahɨ hoafehapurɨ. Nindou ai moaruwai hohoanɨmoayei ane asu nɨne-moatükunɨ moaruwai hoafayei-ane ranahambo God ai amboawiyei mbüsümbui. Ŋga asu nindou düdi ai Yifiafɨ Aboedɨmayo ranahambo moaruwai hoafayu ana, asu God ai ŋgɨrɨ ahambo amboawi mbüsu, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nindou düdi ai Nindou Hondümayu ranahambo nɨne-moaruwai hoafendu ana, God ai nindou ranahambo amboawi mbüsündombui. Ŋga asu nindou düdi ai Yifiafɨ Aboedɨ ranahambo nɨne-moaruwai hoafayu ana, God ai nindou ranahambo ŋgɨrɨ amboawi mbüsu hapondanane asu süŋgunambo aho ranamboanɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nɨmɨ nɨmɨndɨ ranai aboedayo ana, hɨsɨ ranai-amboanɨ aboedɨndɨmboe. Asu nɨmɨ nɨmɨndɨ ranai moaruwaiayo ana, hɨsɨ ranai-amboanɨ moaruwaindɨmboe. Nindou ai hɨsɨ ra hoeindɨhindühɨ anɨmbo nɨmɨ nɨmɨndɨ aboedɨyo, moaruwaiyo ra fɨfɨrɨndɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Awi seana nindou amoasɨrɨ moaruwai nahurai-anemo. Asu se nindou moaruwai-anemo asu nüŋgundu aboedɨ moatükunɨ ranahambo wataporɨmbo-mandundɨ? Nɨne-moatükunɨ ŋgusüfoambe tüküra pire haya anɨŋgo ranane asu yafambe ai ranahambo wataporɨmbora arandɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nindou aboedɨ ai ahandɨ ŋgusüfoambe aboedɨ hohoanɨmo afɨndɨ amarondo. Ranane asu ranɨhündambo aboedɨ ratüpurɨ hohoanɨmo ra tüküfe arandɨ. Nindou moaruwai ai ahandɨ ŋgusüfoambe moaruwai hohoanɨmo afɨndɨ amarondo. Ranane asu ranɨhündambo moaruwai ratüpurɨ hohoanɨmo ra tüküfe arandɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ro sɨhamumbo nda rarɨhe hoafehapurɨ, Godɨndɨ yɨbobofe si tüküfeyo-ambe ana, muŋguambo nindou ai nɨne-mamɨkarɨ wataporɨmayei ranahambo asükaindo hɨhɨnde Godɨndɨ hɨmboahü yɨbobondeandürɨmboe. ");
INSERT INTO agg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sɨhamundɨ hoafɨ ranɨ-süŋgumbo anɨmbo God ai türüboade yɨbobondeapurühɨ nindou moaruwai hohoanɨmomayafɨ mbüsü asu nindou mbumundɨ hohoanɨmomayafɨ mbüsündambui,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ranɨyomo ranɨ-sɨmboanɨ ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨyomo asu Farisi nindouyomo ai hoafɨyomondühɨ yahomoya, “Yamundo-randeimbɨ nindou, se hepünɨfeimbɨ moatükunɨ rarowanda hoeindɨhu sefombo-anefɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Asu ai ahamumbo sɨmborɨ hoafɨyupurühɨ yahuya, “Godɨmbo hohoanɨmo-koateyeimbɨ nindou moaruwai hamɨndɨ hapondanambe anɨmboei se wamboya, Ai hepünɨfeimbɨ moatükunɨ nafuimbiyu, yahomo houmbo-anemo. Ŋga asu ro ŋgɨrɨ ranɨ-moatükunɨ nafuindahɨ. Sapo Sona Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou-mayu ranahandɨ hepünɨfeimbɨ moatükunɨ yaŋgɨrɨ anɨmbo nafuindahanɨ se hoeindɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sona ai kinɨ adükarɨndɨ bodoambe ŋgɨmɨ si ŋgɨmɨ nɨmbɨyu haya tükümefiyu nou yahurai-anɨmbo asu Nindou Hondü ranai-amboanɨ hɨfambe ragu ŋgɨmɨ si ŋgɨmɨ nɨmbɨndümbui. ");
INSERT INTO agg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yɨbobofe si tüküfeyo-ambe ana, nindou Ninifehündɨ ai botɨndahi nɨmboeimbo nindou se hapondanambe anɨmboei sɨheimbo papɨ-hoafɨndɨhündürɨmboyei. Nɨmboe sapo nindou ranɨ ŋgoafɨhündɨ aiana horombo Sona bokarɨmarɨhendɨ wataporɨ ra hɨmboarɨyei hehi ahei moaruwai hohoanɨmo ranahambo daboadanamborɨhi hehimbohündɨ wambo. Ŋga awi ro sɨhamumbo hoafehapurɨ, nindou mamɨ Sonambo ŋgasündireimbɨ adükarɨ awi ndanüŋgu! ");
INSERT INTO agg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Yɨbobofe si tüküfeyo-ambe ana, Siba-yafe bogorɨ nɨmorehɨ ŋgorügoanɨnɨ-poedɨ ranai nindou hapondanambe anɨmboei sɨheimbo botɨndɨfe nɨŋgombo papɨ-hoafɨndandürɨmboe. Nɨmboe sapo ai adükarɨ bogorɨ Soromonɨndɨ fɨfɨrɨfeimbɨ hoafɨ ranɨ hɨmborɨmbo aŋgunɨ-poedɨ sɨfo hayambo-hündɨwambo. Ŋga awi ro sɨhamumbo hoafehapurɨ, nindou mamɨ bogorɨ Soromonɨmbo ŋgasündireimbɨ ndanüŋgu!” ");
INSERT INTO agg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Moaruwai nendɨ nindou ranahambo hɨnɨŋgareandɨ ana, asu ai hoe-koatereandɨ hɨfɨhü warɨ hefe nɨmarɨmbo kokora howohane, ŋga ai fondɨ ra moai horeandɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Asu ai rande hoafɨndowohü anɨmboya, Awi ro asükainda koadürü nɨmboahɨ ana, hɨhɨndahe ŋga, mbɨsɨmboe. Asu ai ho hoeireandane worɨ sapo horombo ranambe manɨŋgo-mayo ra nindou ai yɨhoarɨyo dɨboadore hɨnɨŋgɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Rananɨmbo asu ai ŋgo moaruwai nendɨ 7 bɨdɨfɨrɨ ranaheimbo fihɨndamündündürɨ haya ŋgei worɨ ranambe nɨmandeimboyei. Weaŋgurühɨdɨdɨ-mayo ranahambo ŋgasündɨhi hehi 7 bɨdɨfɨrɨ ranai ana moanɨ muŋguna moaruwai hamɨndanɨmbondeimboyei. Moaruwai nendɨ ranai nindou ranahandɨ fiambe nafɨndühümündi nɨmandei-anɨ anɨmbo asu nindou ranai muŋguna moaruwai hɨmbondu haya nɨmandümbui horombo rasafɨ mamaru yahurai nɨmarɨ-koate. Moaruwai hohoanɨmoyeimbɨ nindou hapondanambe anɨmboei aheimbo amboanɨ yahurai-anɨmbo tüküfendɨndürɨmboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sisas ai nindou afɨndɨ ranaheimbo wataporɨmbo-randühɨ nüŋgu-ane asu ahandɨ hondɨ akohoandɨ ranɨ babɨdɨ ahambo-so tükümehindɨ. Ai hɨfɨnɨ tüküyahi nɨmboeimbo ahambo hoafɨmbo masei. ");
INSERT INTO agg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ranɨyei asu nindou mamɨ ranambeahɨndɨ ai Sisasɨmbo hoafɨyundowohü yahuya, “Se ndühɨ hɨmboyafɨ, sɨhafɨ me ai amondɨ mamɨ babɨdɨmbo hɨfɨnɨ anɨmboei ra ai sedɨbo wataporɨmbo seimboanei,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ŋga Sisas ai sɨmborɨ hoafɨyuhü yahuya, “Dɨde wandɨ me rana? Dɨdemo wandɨ akohoandɨ rana?” mehu. ");
INSERT INTO agg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ranɨyu asu ai ahambo süŋgururü-rundeimbɨ-memo ranahamumbo warɨ nümbuirapurühɨ hoafɨyuhü yahuya, “Ndühɨ hɨmboyei, ndananemo wandɨ me, wandɨ akohoandɨyomo! ");
INSERT INTO agg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nindou düdi ai wandɨ Ape sünambe amaru ranai refembo hohoanɨmoayu ranɨ-süŋgu rawareandɨ ana, ai wandɨ rehane, wandɨ akɨdani, wandɨ meane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Moanɨ mamɨ ranɨ-sɨmboanɨ Sisas ai worɨ ra hɨnɨŋgɨre haya kurɨhoe-mayo ranɨ hɨmborɨkɨmɨ hu mamaru. ");
INSERT INTO agg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nindou afɨndɨ ahambo wakɨmarɨhorɨ ranai afɨndɨwambo fondɨ tɨre koamarandamboyu Sisas ai botambe kefuai nɨmaru ane asu nindou afɨndɨ ranai gudihɨ hoekɨmɨ burɨmayei. ");
INSERT INTO agg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ranɨyu asu ai afɨndɨ kafoefe hoafɨ ranambo aheimbo hoafɨmayu. Ranɨyu ai aheimbo yare hoafɨyuhü yahuya, “Nindou mamɨ ai mamɨmbo sesɨ ahurɨ bubumbo ahandɨ nümbürɨna mahu. ");
INSERT INTO agg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ai hu sesɨ ahurɨ ra buburandane bɨdɨfɨrɨ ai nafɨnɨ pütapɨmayoa ndu ai tüküyahi fufumarɨhüsi. ");
INSERT INTO agg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bɨdɨfɨrɨ hɨfɨ akɨdou yaŋgɨrɨ nɨŋgo-ambe nɨmoei yahafɨ safambe pütapɨyo. Hɨfɨ ranai ragu hanɨ-koate nɨŋgo-ambe. Hɨfɨ ranai ragu han-koate-wambo sesɨ ahurɨ ranai nɨmai tütükɨmayo. ");
INSERT INTO agg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Asu hüfɨhamɨndɨ ai peyowohüyo ranambo ahurɨ hapoadümbo maforo ranahambo sore-soremarandɨ. Sapo ahasɨharɨ ai ragu hɨfambe hanɨ hanɨ ra-koateyo hayambo-wambo ranɨyo asu ai muŋgu yapatɨparɨmayo. ");
INSERT INTO agg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Asu bɨdɨfɨrɨ ahurɨ ranai tɨhoarɨ-tɨhoarümbɨ wofambe pütapɨyo haya, asu tɨhoarɨ ranambo gabudandühɨ moaruwaimbo-mareanda hɨsɨ-koatemayo. ");
INSERT INTO agg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Asu ahurɨ bɨdɨfɨrɨ ai hɨfɨ aboedambe safɨ pütapɨyowohü ai aboedɨ hɨsɨmayo. Nɨmɨndɨ mamɨ ranahandambo bɨdɨfɨrɨ ai 100 hɨsɨyo, bɨdɨfɨrɨ ai 60 hɨsɨyo, asu bɨdɨfɨrɨ ai 30 hɨsɨyo marandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Sisas ai hoafɨ moendɨfembo yahumbo hoafɨyuhü yahuya, “Hɨmboambeimbɨndeihɨ ana, hɨmborɨmbeyei-amboane” mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ranɨyomo asu Sisasɨmbo süŋgururü-rundeimbɨ ai Sisas sowana sɨfomo ahambo düdururühɨ yahomoya, “Nɨmboyafɨ se nindou ranaheimbo wataporɨmborarühɨ kafoefe hoafɨmefɨndüra?” mehomondo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Asu sɨmborɨ Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “God ŋgɨnɨndɨ hɨfandarandɨ ranahandɨ hoafɨ dɨbo eŋgoro ahandɨ nɨmɨndɨ ranahambo sɨhamumboyo masayo, ŋga asu nindou ranaheimbo moai sayo. ");
INSERT INTO agg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nindou düdi ai bɨdɨfɨrɨ moatükunɨ asɨhendɨ ana, asu God ai ahambo bɨdɨfɨrɨ moatükunɨ ranɨwamɨ dagadombui. Rananɨmbo asu ai ranɨ-moatükunɨ ndearɨndümbui. Ŋga asu nindou düdi ai ranɨ-koateayu ana God ai nɨne-moatükunɨ sapo akɨdou masɨhendɨ ra muŋgu hɨhɨnde ndemündümbui. ");
INSERT INTO agg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ranɨmboane asu ro aheimbo kafoefe hoafɨnambo wataporɨmbo-marɨhandürɨ. Sapo nindou ranai hoeirɨhindühaneisɨ, ŋga asu ai ŋgɨrɨ ndondɨhi hoeindɨhindɨ. Ai hɨmborɨyeihaneisɨ, ŋga asu ai ŋgɨrɨ nɨnɨ-moatükunɨmboyo hoafayo ranahambo ndondɨhi hɨmborɨndei fɨfɨrɨndɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nindou ranaheimboyo Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou Aisaia hoafɨmayu hoafɨ ra hapoana anɨhondü tükümefeyo. Hoafɨ ranai yare hoafɨyowohü yahoya, ‘Se hoafɨ ranahambo afɨndɨmbo hɨmborɨndeimboyei, ŋga asu se ŋgɨrɨ fɨfɨrɨndɨhindɨ. Se afɨndɨmbo hɨmboapondeimboyei, ŋga ŋgɨrɨ hoeindɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sapo nindou ranai ahei hohoanɨmo ra tapɨhamɨyondürɨ, asu ai ahei hɨmboambe ra güre papɨreandürɨ asu ahei hɨmboarɨ ra tütümondeandürɨ hayambo wambo. Ŋga asu refe-koatembeyei-mbonana ahei hɨmboarɨnambo hoeirɨhi, ahei hɨmboambenambo hɨmborɨyeihɨ hohoanɨmo ra fɨfɨrɨhi mburɨhümbo asu wambo sowana sɨneihɨ ro dɨdɨboado-rɨheandüranɨ aboedɨyei,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ŋga asu moanɨ seana hɨhɨfɨ-hɨhɨfɨndɨmo. Sɨhamundɨ hɨmboarɨ ranai ana hoeireandühɨ türüfoareandühane. Asu sɨhamundɨ hɨmboambe ranai-amboanɨ nɨnɨ hoafɨyo ranahambo hɨmborɨyowohü fɨfɨreandühane. ");
INSERT INTO agg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ro sɨhamumbo anɨhondümbo-anahɨ nda hoafehapurɨ. Horombo Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ nindou afɨndɨ asu mbumundɨ nindou afɨndɨ ai nɨne-moatükunɨ se hoeiarundɨ ranahambo hoeifembo masei, ŋga asu ai moai hoeirɨhindɨ. Asu se nɨne-moatükunɨ hoafɨ hɨmborayei ranɨ hoafɨ ra hɨmborɨmbo masei, ŋga asu ai moai hɨmborɨyei.” ");
INSERT INTO agg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Se ndühɨ hɨmborɨndei. Nindou sesɨ ahurɨ bubumarandɨ kafoefe hoafɨ ranahandɨ nɨmɨndɨ ra türüboadɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nindou sapo God ŋgɨnɨndɨ hɨfandarandɨ ranahambo hɨmborɨyei hehi asu ndofe türüfoefe-koateayei nindou ranana sapo sesɨ ahurɨ nafɨnɨ pütapɨmayo nahurai-ane. Nɨne-moatükunɨ ahei ŋgusüfoambe sesɨ ahurɨ nou bubumayo ra moaruwai nendɨ-mayu Satan ranai tüküfi kosamündühani. ");
INSERT INTO agg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sapo sesɨ ahurɨ nɨmoeiwamɨ pütapɨmayo ranana nindou sapo hoafɨ hɨmborɨyu sɨmboanɨ ai nɨmai hɨhɨfɨ-hɨhɨfɨyuhü masemündu nahurai-ane. ");
INSERT INTO agg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ŋga ai ahurɨ ahasɨharɨ-koate nahurai hoafɨ ranai moai ahandɨ ŋgusüfoambe ŋgɨnɨndɨ nɨmarondowohü ai moai gedambo ŋgɨnɨndɨ nüŋgu. Ranɨmboane nindou ranai afɨndɨ hohoanɨmoyo asu papɨ hoafɨyo ranai Aboedɨ Hoafɨ ra süŋgufembo tükündɨfendoanɨ asu ai ahandɨ anɨhondümbofe hohoanɨmo ra nɨmai hɨnɨŋgɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Sesɨ ahurɨ tɨhoarɨ tɨhoarɨyoweimbɨ wofambe pütapɨmayo ranana, sapo nindou ai hoafɨ ra hɨmborɨyu haya mɨtanaramündu nahurai-ani. Hɨfɨnɨndɨ moatükunɨ ranahambo afɨndɨ hohoanɨmoyuhü asu napo afɨndɨ sɨhefembo ranahambo ŋgusüfo pareandühɨ ranɨ-moatükunɨ ranai Godɨndɨ hoafɨ ranahambo gabudɨmareandɨ, asu ahurɨ ranai ŋgɨrɨ hɨsɨndo. ");
INSERT INTO agg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ŋga asu sesɨ ahurɨ hɨfɨ aboedambe bubumayoa aboedɨ tükümefeyo ranana, sapo nindou düdi ai hoafɨ ra hɨmborɨyu haya asu ai hoafɨ ranahambo fɨfɨreandühɨ tümafoareandɨ nahurai-ane. Ranɨyo ai hɨsɨ aboedɨ hɨsɨmayo. Bɨdɨfɨrɨ ai 100 hɨsɨmayo, bɨdɨfɨrɨ ai 60 hɨsɨmayo asu bɨdɨfɨrɨ ai 30 hɨsɨmayo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sisas ai aheimbo ŋgorü kafoefe hoafɨ hoafɨyuhü yahuya, “God ŋgɨnɨndɨ hɨfandarandɨ ranana nindou ai aboedɨ sesɨ ahurɨ ahandɨ nümbürambe bubuarandɨ nahurai-ane. ");
INSERT INTO agg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mamɨmbo nɨmbokoanɨ muŋguambo nindou ai apusɨyei-ane, hürütümbɨ nindou moaruwai ranai tüküfi wohɨ ahurɨ ra nindou sapo wit ahurɨ bubumarandɨ ranambe bubura hɨnɨŋgɨre haya ndamefiyu. ");
INSERT INTO agg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wit maŋgɨrɨ ranai tütükɨyowohüyo asu hɨsɨ ranai ndeara tüküfe-tüküfe marandɨ. Ranɨyo asu ranɨ mbusümo wohɨ ahurɨ amboanɨ tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nümbürɨ aharambürɨ-mayu ranahandɨ ratüpurɨyomo-rundeimbɨ-memo ranai nindou ahambo-so tüküyafu hoafɨyomondühɨya, ‘Nindou adükarɨ, se sapo sesɨ ahurɨ ra moaruwaiyopoanɨ, ŋga aboedɨyo sɨhafɨ nümbürambe bubumarandɨsɨ. Asu dagüda wohɨ ra tüküfemboyo furayo rana?’ mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Asu nindoumayu ranai sɨmborɨ ahamumbo hoafɨyuhüya, ‘Nindou hürütümbɨ ai dɨbo tüküfi wohɨ ahurɨ ra bubumarandane furayo,’ mehu-amboemo. Asu ai sɨmborɨ ahambo düdurüwurühɨ yahomoya, ‘Ro wohɨ ra ho wohɨrɨhefembo se hohoanɨmoyafai?’ mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Asu sɨmborɨ ai ahamumbo hoafɨyuhüya, ‘Yowanɨ refepoanɨ! Se wohɨ dɨgoundühɨ wit maŋgɨrɨ ra wohɨ bɨtapɨndu fɨrɨbadɨgoumboemo, ŋga ambe. ");
INSERT INTO agg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wohɨ ranai moanɨ rande wit bɨtapɨnde mamɨ tütükɨndo ŋgombo asu sesɨ ra yimuŋgurɨyɨmɨnd-ambe fɨrɨbadhefemboane. Ra-sɨmboanɨ ro nindou yimuŋgurɨndümo-rundeimbɨ ranahamumbo wohɨ ra boatei wohɨ dɨgau mbundu hüputüpundu haiambe fufusɨndundühɨ, asu moanɨ wit safɨ ranɨ yaŋgɨrɨ gururɨndu wandɨ sesɨ sɨhefe worambe kurɨndundɨ mbɨsamboyahɨ!’ mehupurɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sisas ai ŋgorü kafoefe hoafɨ hoafɨmayundürɨ. Ai yahuya, “God ŋgɨnɨndɨ hɨfandarandɨ ranana ndahurai-ane. Nindou ai mastet hoarɨ hambomo nahurai ra semündü haya ahandɨ nümbürambe hɨfɨ karirühani. ");
INSERT INTO agg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Hoarɨ ra ai moanɨ moaruwai akɨdou tɨkaimboanisɨ, ŋga asu ai hɨfambeahɨndɨ tüküfe nɨmoamo ahafo ranana moanɨ ŋgasündeandeimbɨ moatükunɨ ane, asu muŋguambo ndu ranai tükündahi nɨmɨ düdüdü ranɨwamɨ ŋgerɨ ahei ŋgerambo-ndühümboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sisas ai kafoefe hoafɨ ŋgorü hoafɨmayu. Ai hoafɨyuhü yahuya, “God ŋgɨnɨndɨ hɨfandarandɨ ranana ndahurai-ane. Nɨmorehɨ ai bret mandɨfembo yahombo ana, ai sapo fufudɨgoyo-randeimbɨ moatükunɨ, ahandɨ ndürɨ yis, ra akɨdou yaŋgɨrɨ praua adükarɨ ranambe bubufoare haya fande yamunderandanɨ muŋguambo praua ranai nɨmoamo fufudɨgoyo hafohane.” ");
INSERT INTO agg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sisas ai kafoefe hoafɨnambo muŋguambo moatükunɨ ranahambo nindou afɨndɨ ranaheimbo hoafɨmayundürɨ. Ŋga asu ai ŋgɨrɨ nɨne-hoafɨ aheimbo hoafombo mbüsümbo ra kafoefe hoafɨnambo hoafɨ-koate hoafɨndundürɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Horombo, Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou ai hoafɨmayu ranɨ sɨmogodühɨ yahurai tüküfemboyu Sisas ai yare kafoare hoafɨmayu ra. Sapo nindou ranai yare hoafɨyuhü yahuya, ‘Ro aheimbo wataporɨmboarɨhandürɨ ana, kafoefe hoafɨnambo wataporɨndamboyahɨ. Ro muŋgu moatükunɨ dɨbo eŋgoro hɨfɨ asu muŋgu moatükunɨ nafɨ-koateyo-ambe ho hombo hapondanambe fɨfɨrɨfe-koatemayo ra aheimbo hoafɨndaharümboyahɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ranɨyu Sisas ai nindou afɨndɨ ranaheimbo ranühɨ yare hɨnɨŋgɨrearü haya worambe kefuai mahüfu. Ranɨyomo asu ahambo süŋgururü-rundeimbɨ ai ahambo-so kefoau hɨfomo hoafɨyomondowohü yahomoya, “Se yɨhoefɨmbo nümbürambe wohɨ tükümefeyo ranahandɨ kafoefe hoafɨ nɨmɨndɨ ranahambo türüfoaro hoafɨyafɨmunɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Asu Sisas ai ahamumbo sɨmborɨ hoafɨyuhü yahuya, “Nindou düdi ai sapo sesɨ ahurɨ aboedɨ nümbürambe bubumarandɨ ranana Nindou Hondü ranani. ");
INSERT INTO agg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ŋga asu nümbürɨ ana hɨfɨ ndanane. Ahurɨ aboedɨ ranana nindou sapo God ŋgɨnɨndɨ hɨfandarandɨ ranambe anɨboadei ranane. Ŋga asu wohɨ moaruwai ranana nindou sapo Satanɨndayei ranane. ");
INSERT INTO agg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ŋga asu hürütümbɨ nindou wohɨ ahurɨ bubumarandɨ ranana Satan-ani. Asu yimuŋgurɨ yɨmɨndɨmbo si ranana hɨfɨ ndanai muŋgumbo si-ane. Ŋga asu yimuŋgurɨndümo-rundeimbɨ nindou ranana Godɨndɨ sünambeahɨndɨ nendɨ rananemo. ");
INSERT INTO agg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sapo ai wohɨ ra fɨru hüputüpuru haiambe fufusarundɨ yahurai-anɨmbo hɨfɨ nda muŋguyo-ambe nindoumbo tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Rananɨmbo Nindou Hondü ranai ahandɨ sünambeahɨndɨ nendɨ koandɨhepurümbui. Asu ai muŋgu moatükunɨ nindouyei anɨhondümbofe hohoanɨmo ranahambo moaruwaimbo-reandürɨ arandɨ asu nindou bɨdɨfɨrɨ moaruwai hohoanɨmoyei arɨhündɨ rananei aheimbo God ŋgɨnɨndɨ hɨfandarandɨ-ambeahɨndɨ fufundündɨmo raguanambo-ndundürɨmboemo. ");
INSERT INTO agg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Rananɨmbo aheimbo hai hüfɨ afɨndɨ ranambe pinduwuranɨ ranühɨ ai ahei yahafɨ hɨtɨhündühɨ hasɨheindeimboyei. ");
INSERT INTO agg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Rananɨmbo asu Godɨndɨ nindou mbumundɨ-mayei ranai ahei Ape ŋgɨnɨndɨ hɨfandarandɨ ranambe hüfɨhamɨndɨ nou si boakɨboadɨhimboyei. Se hɨmboambembündeihɨ ana, hɨmborɨndei. ");
INSERT INTO agg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","God ŋgɨnɨndɨ hɨfandarandɨ ranana ndahurai-ane. Nindou ai ŋgɨnɨndɨ napo dɨbo hɨfambe samboeroa hoeireandühɨ ana, asu ai dɨbo yare gabude sɨhendüh-ani. Ranani asu ai ranɨmbo hɨhɨfɨ-hɨhɨfɨfi haya asu hu muŋgu moatükunɨ ai masɨhendɨ ra nindou ŋgorümbo fufusendühɨ ranɨhündɨ kakɨ semündü haya asu ai hɨhɨrɨfi hu ŋgɨnɨndɨ napo yaŋgoroweimbɨ hɨfɨ ra pemɨmayu.” ");
INSERT INTO agg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Asu God ŋgɨnɨndɨ hɨfandarandɨ ra ndahurai ane. Nindou ai moanɨ ŋgɨnɨndɨ moatükunɨ boagɨrɨ kakɨ nahurai ranahambo kokora randühani. ");
INSERT INTO agg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Asu ai ranɨ-moatükunɨ ra moanɨ aboedɨ hamɨndɨ hoeireandühɨ anɨmbo asu ai hu muŋgu moatükunɨ ai masɨhendɨ ra nindou ŋgorümbo fufusendühɨ ranɨhündɨ kakɨ semündü haya asu kakɨ ra pemɨmayu.” ");
INSERT INTO agg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Asu God ŋgɨnɨndɨ hɨfandarandɨ ra ndahurai-ane. Nindou bɨdɨfɨrɨ kinɨ wowarɨyomo-rundeimbɨ ai ahamundɨ andürɨ ranambo hɨmonɨ safoarundühɨ mamɨkarambo kinɨ gümarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Asu andürɨ ranai kinɨ ranambo tüküfeyo-anɨ ane ai gudianɨ hüründümo sɨhoemo houmbo kinɨ ra yɨboboarundɨ. Rananemo asu ai nɨmarɨmombo kinɨ aboedɨ aboedɨ ra wambürambe wambürɨhɨrundühɨ asu moaruwai moaruwai moanɨ yaŋgorombo ra ragu moenda pütiyefu arundɨ. ");
INSERT INTO agg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hɨfɨ nda bɨdɨfɨranɨ si ranɨ-sɨmboanɨ moanɨ yahurai hamɨndɨ anɨmbo tükündɨfemboe. Rananɨmbo asu sünambeahɨndɨ nendɨ ai nindou moaruwai hohoanɨmoyeimbɨ ranaheimbo gugundüwurü mamɨnɨndüwurümboemo aboedɨ-mayei ranambeahɨndɨ. ");
INSERT INTO agg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Rananɨmbo aheimbo hai hüfɨ afɨndɨ ranambe pinduwuranɨ ai ahei yahafɨ hɨtɨhündühɨ hasɨheindeimboyei.” ");
INSERT INTO agg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sisas ai ahamumbo düdufipurühɨ yahuya, “Se ndanɨ-moatükunɨ ranahambo fɨfɨru türüfoarundai?” mehuamboemo. Asu ai hoafɨyomondühɨ yahomoya, “Yɨnɨ, ro fɨfɨrɨhumboanefɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Asu asükaiyu ahamumbo yahuya, “Ranɨ-mboane asu muŋguambo nindou ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ-memo ai God ŋgɨnɨndɨ hɨfandarandɨ ranahambo ndoru fɨfɨrarundɨ ranai worɨ aharambürɨ nahurai anemo. Ai kefuai hüfu ahandɨ napo worɨ-mayo ranambeahɨndɨ sɨmborɨ napo asu wamɨndafɨ napo fufuaramündu nahurai anemo.” ");
INSERT INTO agg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sisas ai ranɨ kafoefe hoafɨ ra hoafɨyu moendɨre haya, ranühɨnda botɨfi haya ahandɨ ŋgoafɨna hɨhɨrɨfi mahafu. ");
INSERT INTO agg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ai hafu ahei rotu worɨ ranambe hoafɨ yamundɨ-mareandüra nindou ahandɨ hoafɨ hɨmborɨmayei ranai ranɨmbo mahepünehindɨ. Ai düduyahindühɨ seiya, “Ai dagüdamboe fɨfɨrɨfe ra yahurai masemündu-a? Asu ahandɨ hepünɨfeimbɨ moatükunɨ ranambo-ana? ");
INSERT INTO agg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nindou nda dadɨ nɨmorɨyua? Ai awi nindou worɨmbora randeimbɨndɨ nɨmorɨmbeyu? Asu awi Maria ana ahandɨ hondɨmbai? Awi Sems, Sosep, Saimon, Sudas ra ahandɨ akohoandɨmbemo? ");
INSERT INTO agg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Awi ahandɨ muŋguambo rehɨhoandɨ ranai ndanühɨ nɨmboeiai? Asu ai dagüdamboe muŋguambo ranɨ-moatükunɨ ra masemündu rana?” rarɨhi hoafɨmayei. ");
INSERT INTO agg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ranɨyei asu ai Sisas ahambo yɨboaruko-marɨhorɨ. Ranɨyu asu Sisas ai hoafɨyundürühɨ yahuya, “Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou ranahambo muŋguambo nindou ai ahambo hɨhɨfɨ-hɨhɨfɨyeihɨ nindou adükar-ani sahündo arɨhündɨ, ŋga asu ahandɨ ŋgoafɨhündɨ ai ana wanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nindou ranɨ ŋgoafɨhündɨ ai anɨhondümbofe hohoanɨmo-koatemayei-amboyu asu ai moai ranühɨ hepünɨfeimbɨ moatükunɨ afɨndɨ ahei hɨmboahü rareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ranɨ-sɨmboanɨ Gariri hɨfɨ hɨfandɨra-randeimbɨ nindou ahandɨ ndürɨ Herot ranai Sisas nɨne-moatükunɨ ratüpurɨmayu ranɨ hoafɨ hɨmborɨmayu. ");
INSERT INTO agg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ranɨyu asu ai ahandɨ hoarehɨ nindou bɨdɨfɨrɨ ratüpurɨyomo-rundeimbɨ ranahamumbo hoafɨyupurühɨ yahuya, “Ai ana sapo Son nindou hundürüra-randeimbɨmayu ranai ana yɨfɨhündɨ botɨfimboani. Ranɨmbo ani anasɨ ai ranɨ ŋgɨnɨndɨ ra semündü haya ranambo hepünɨfeimbɨ moatükunɨ rawareandɨ,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nɨmboe sapo Horombo Herot ai Sonɨmbo karabusɨfimbo hoafɨmayu. Ranɨyomo Son ahambo mburundümo hɨputüpurɨhauwurɨ mburu karabusambe hɨnɨŋgɨmarüwurɨ. Sapo Herot ai ahandɨ akɨdɨ, ahandɨ ndürɨ Firip, ahandɨ nɨmorehɨ, ahandɨ ndürɨ Herodias, ra ndahamɨndɨ mehu. ");
INSERT INTO agg_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Horombo Son ai Herotɨmbo hoafɨyundühɨ yahuya, “Herot, se nɨmorehɨ ra asowandɨfɨ ana, aboedɨyopoanɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ranɨyu asu ai Sonɨmbo hɨfokoandɨhinɨ yahu haya ramefiyu. Ŋga asu ai Sudambo yɨhɨmbomarandürɨ sapo ai Son ahamboyo Aiana Godɨndɨ hoafɨ hoafɨyu-randeimbani sei hoafɨmayei. ");
INSERT INTO agg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mamɨmbo Herotɨmbo hondɨ ai wakɨmarɨmɨndo si ranahambo hohoanɨmoyomondühɨ nindou bɨdɨfɨrɨ ai fandɨhi nɨmareimbo sesesɨmayei. Ranɨyo asu Herodiasɨndɨ nɨmorehɨ nɨmorɨ ranai ahei haŋgɨfoanɨ moporɨyo wakɨmareandɨ. Ranɨyu asu Herot ai nɨmorehɨ moporɨmayo ranɨmbo siaomefiyu. ");
INSERT INTO agg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ranɨyu asu ai hoafɨyuhü yahuya, “Ro sɨhambo nda dabareheandɨ se nɨnɨ-moatükunɨmboyafɨ wambo düduwefoandɨ ra ndahanɨnɨmboyahɨ!” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nɨmorehɨ nɨmorɨ ranai ahandɨ hondɨ hoafɨmayo süŋgu nɨŋgombo Herotɨmbo hoafɨyohü yahoya, “Moanɨ haponda hamɨndɨ ndühɨ Son hundürüra-randeimbɨmayu ranahandɨ mbɨro pretɨwamɨ nando ndawandɨ,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Asu Herot ai ranɨ hoafɨ ra hɨmborɨyu haya afɨndɨ hohoanɨmomayu. Ŋga asu sapo ai nɨmoamo ranɨfihɨ dükare dabarɨmefiyuwambo asu nindou afɨndɨ ai-babɨdɨmbo nɨmarei masahüsi ranɨmbo ai hoafɨyuhü yahuya, “Ahandɨ hohoanɨmo süŋgu-ndundɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ranɨyu asu ai nindou ahandɨ hoarehɨ ratüpurɨyomo-rundeimbɨ ranahamumbo Sonɨndɨ mbɨro kɨkɨrɨhefimbo hoafɨmepura ai homo karabus-ambe-ahɨndɨ mbɨro kɨkɨmarɨhauwurɨ. ");
INSERT INTO agg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ranɨyomo ai ahandɨ mbɨro ra pretɨ-mayo ranɨwamɨ nandu sowandümo hɨfomo nɨmorehɨ nɨmorɨ-mayo ranahambo masabudoa ahandɨ hondɨ sowana semɨndɨ maho. ");
INSERT INTO agg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ranɨyomo asu Sonɨmbo süŋgururü-rundeimbɨ ranai homo ahandɨ fi nɨmoko sowaründümo homo hɨfɨkarɨwurɨ houmbo asu ai homo Sisasɨmbo hoafɨmemondo. ");
INSERT INTO agg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sisas ai Son ramefiyu hoafɨ ra hɨmborɨyu haya, ranɨhünda botambe farɨfi haya moanɨ aimbo nindou kɨkɨfoefe-koatereandɨ hɨfɨnɨ mahu. Nindou bɨdɨfɨrɨ ai Sisas ranɨnɨ mahu hoafɨ ra hɨmborɨyei hehi asu ai ahei ŋgoafɨ hɨnɨŋgɨrɨhi hehi moanɨ hɨfɨ nafɨ süŋgumarɨhorɨ hei. ");
INSERT INTO agg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sisas ai botambeahɨndɨ kusɨfoendane asu nindou afɨndɨ ranai gudihɨ meŋgorowa hoeireandürühɨ aheimbo ŋgusüfo afɨndɨ hɨpoamborandürühɨ ahei aŋgünɨ ra aboedɨmarearü. ");
INSERT INTO agg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mamɨ ranɨ nɨmbɨ hoafombo ahambo süŋgururü-rundeimbɨ-memo ranai ahambo-so homo tüküyafu hoafɨyomondowohü yahomoya, “Ndanana nindou koate-reandühane, ŋga ndeara hüfɨhamɨndɨ hürɨmɨndühane. Ŋga se nindou ranaheimbo koarɨhawandüranɨ anɨmbo ai ŋgoafɨna nɨmai ahei sesɨ kokofoefembo ndambeyahindɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Asu Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Ai ŋgɨrɨ botɨndahi hehi sesɨ kokombo ragu ŋgei. Ŋga seanɨmbo sɨhamundɨhoarɨ sesɨ ra ai sesɨmbo dabudürɨ!” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Asu ai sɨmborɨ hoafɨyomondowohü yahomoya, “Roana hondahüfeimbɨ (5) bret anemo asu kinɨ akɨdou yimbu-anafanɨ ranɨ yaŋgɨrane sahumɨndfɨmboayefɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Asu ai ahamumbo hoafɨyupurühɨ yahuya, “Refe ana ndühɨ wambo sowana sesɨ ra sowandümo sɨfomo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ranɨyu asu ai nindou afɨndɨ ranaheimbo wohɨwamɨ nɨmandei mehua mamarei. Ranɨyu asu ai mamɨ hondahüfimbɨ bretɨ-memo ranɨyomo asu kinɨ akɨdou yimbumefanɨ ranɨyafanɨ ra semündü haya sünambe hɨmboyu hafuhɨ Godɨmbo hɨhɨfɨmarürɨ. Refi mbura ai bretɨ-mayo ra hɨfɨtɨre ahambo süŋgururü-rundeimbɨmbo masagapura asu ai nindou afɨndɨ ranaheimbo yimbumarundürɨ. ");
INSERT INTO agg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Muŋguambo nindou ai sesɨ ra sahüsimbo ndeara nafɨmarɨhümündi. Ranɨyomo asu ahambo süŋgururü-rundeimbɨ ai sesɨ moanɨ bode meŋgoro ra 12 wambürɨ tüküfimbɨ masowandümo. ");
INSERT INTO agg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nɨmorehɨ, nɨmorɨ akɨdɨbou tapuife-koate nindowenihɨ yaŋgɨrɨ sesɨ ra masowasümo ranana ai 5,000 nahurai nindouyomo masowasümo. ");
INSERT INTO agg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ranɨyu Sisas ai ahambo süŋgururü-rundeimbɨmbo botambe fandafu houmbo se-boatei Gariri kurɨhoe ranɨ goesürünɨ ŋgomo mehuamboyu asu ai nɨmorehɨ nindowenihɨmbo ahei worɨnambo koarɨhefendürɨmbo mehu. ");
INSERT INTO agg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ai aheimbo koarɨhendürɨ haya hɨfɨ wafuwamɨ ahand-amboanɨ mahafu Godɨmbo dɨdɨbafɨfendombo. Ndeara nɨmbɨ ai akɨmɨyowohüyo asu Sisas ai moanɨ ahand-amboanɨ hamɨndɨ ranühɨ manüŋgu. ");
INSERT INTO agg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Asu ranɨ-sɨmboanɨ bot ai ndeara aŋgunɨ hoe mbusümondühɨ werɨ ra haŋgɨfoanɨ sɨfohɨyo asu hoe ranai fandɨhoayohü bot ranahambo semɨndɨ pire semɨndɨ pire randühɨ maho. ");
INSERT INTO agg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ranɨyu asu Sisas ai si hoafombo ahambo süŋgururü-rundeimbɨ ranhamumbo-so hoe haŋgɨfo süŋgu pütapɨyu hüfu tükümefiyu. ");
INSERT INTO agg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Asu ai ahambo hoeirüwura hoe haŋgɨfo süŋgu pütapɨmayu hüfuwa hɨhamɨndarɨyomondühɨ yɨhɨmboyondühɨ yahomoya, “Ranɨ-moatükunɨ ranana yifiafane,” mehomo. Ranɨyomo ai yɨhɨmbombo hɨsɨheimemo. ");
INSERT INTO agg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Asu Sisas ai mamɨharɨ hoafɨ nɨŋgoambe hoafɨ karɨhoeihɨ yahuya, “Se ŋgɨnɨndɨ nɨŋgomo, roanahɨ nda, ŋga se yɨhɨmbondɨmboemo!” mehupuramboemo. ");
INSERT INTO agg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ranɨyu asu Pita ai ahambo hoafɨyundühɨ yahundoya, “Adükarɨ, anɨhondü sendafühɨ ana, wambo hoafɨyafɨndɨra ro sɨhambo sowana hoe haŋgɨfo süŋgu pütapɨnda dügɨ,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Asu Sisas ai Pitambo hoafɨyundowohü yahuya, “Se mborai sühüfɨ,” mehundo-amboyu. Ranɨyu asu ai botambeahɨndɨ tüküfi haya Sisas sowana hoe haŋgɨfo süŋgu mahüfu. ");
INSERT INTO agg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ŋga asu ai werɨ ra hoeireandanɨ mayowamboyu ŋgɨnɨndɨ hamɨndɨmayoa yɨhɨmboyuhü ndeara hɨmonɨ tɨporɨkomefiyu hanu. Ranɨyu asu ai heiyuhü hoafɨyuhü yahuya, “Adükarɨ, se wambo aboeda farɨhawandɨrɨ!” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ranɨyu asu Sisas ai nɨmai mamɨharɨ warɨfi hu kɨkɨhɨrümündühɨ hoafɨyundühɨ yahuya, “Sɨhafɨ anɨhondümbofe ra akɨdou ane. Se nɨmboe hohoanɨmo yimbumbomarowanda?” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Asu ai yɨbobo botambe kefoeneandühɨmboyo asu werɨ ai afurɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ranɨyomo asu nindou botambe mamarɨmo ranai Sisasɨmbo Adükarɨ hondani yahomo hohoanɨmoyomondühɨ yahomoya, “Awi seana moanɨ Godɨndɨ Nɨmorɨ hond-anafɨ!” mehomondo. ");
INSERT INTO agg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ai botambe kurɨhoe ra barɨhoemo hou homo Genesaret hɨfambe tükümefundɨ. ");
INSERT INTO agg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ranɨyei asu nindou ranɨ hɨfɨhündɨ ai Sisasɨmbo fɨfɨrɨmarɨhorɨ. Ranɨyei asu nindou ranɨhündambo-mayei ranai ŋgoafɨ daburɨ wakɨmareandɨ ranaheimbo Sisas tüküfimboani hoafɨ ra hoafühɨmarɨhündɨ. Ranɨyei asu nindou ranai aŋgünümboyeimbɨ ranaheimbo fufurühümündi-hündürɨ mafandɨhindɨ Sisas sowana. ");
INSERT INTO agg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ranɨyei asu nindou aŋgünümbɨyeimbɨ ai moanɨ Sisasɨndɨ hoearɨ ranahambo sündɨfimbo hoafɨmehündo habodei. Ranɨyo asu ai ranɨ hoearɨ ahandɨ ra sündɨhindühɨ ahei aŋgünɨ ra muŋguambo aboedɨmehindɨ. ");
INSERT INTO agg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ranɨyo asu Farisi nindouyomo asu ahɨnümbɨ hohoanɨmo yamundu rundeimbɨyomo ranai Serusarem ŋgoafɨhündɨ botɨyafu houmbo sɨnɨmo Sisasɨmbo-so tüküyafu hoafɨyomondühɨ yahomoya, ");
INSERT INTO agg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Asu nɨmboe sɨhafɨ süŋgurunɨnɨ-rundeimbɨ ranai horombo yɨhoefɨ amoao mamɨ ai ahamundɨ hohoanɨmo yamunde sɨhai mamaro ra süŋgufe-koateayomoa? Aiana moai ndoru koadürü refe-arandɨ süŋgu ahamundɨ warɨ ra popoairɨhoemo mburu sesɨ ra sowasümo rundɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Asu Sisas ai sɨmborɨ ahamumbo hoafɨyuhü yahuya, “Asu se nɨmboe God ai hoafɨyumbɨ hoafɨ ra ndofe süŋgufe-koate moanɨ sɨhamundɨ yamundɨfe hohoanɨmo ranɨ-süŋgu yaŋgɨrɨ süŋguaru homoa? ");
INSERT INTO agg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sapo God ai yare hoafɨyuhü yahuya, ‘Se sɨhafɨ meapembo ahɨnɨndafühɨ fandɨhawapɨrɨ ndandɨ.’ Asu ‘Nindou düdi ai ahandɨ hondafɨndambo hoafɨ moaruwai hoafɨnduanɨ ana, nindou ranahambo hɨfokoefimboane,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Ŋga asu se hoafɨyomo rundühɨ yahomoya, ‘Nindou mamɨ ai kakɨ napo moatükunɨ hondafɨndɨ ahafembo farɨhefepɨrɨmbo asɨhendɨ ana, ai ahafembo hoafɨnduhɨ anɨmboya, Ranɨ-moatükunɨ ranana ro Godɨmbo masɨheheandane ehu ana, asu ai ahandɨ hondafɨndambo ranɨnambo ŋgɨrɨ fandɨhepɨrɨ,’ yahomo arund. Ranɨ hohoanɨmo süŋgu ana, asu se Godɨndɨ hoafɨ ra mbahɨrɨhaundühɨ moanɨ sɨhamundɨ yamundɨfe hohoanɨmo ranɨ-süŋgu yaŋgɨrɨ süŋguru homondühanemo. ");
INSERT INTO agg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Awi seana nindou yimbu yafambeimbanemo! Aisaia ai anɨhondümboyu sɨhamumbo horombo hoafɨyuhü yahuya, ");
INSERT INTO agg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘God ai yahuya, “Nindou ranai wambo yafambe ranambo Adükarani aseindɨrɨ, ŋga asu ŋgusüfoambe ana moai wamboso akɨmɨyo, ŋga aŋgunanendürɨ. ");
INSERT INTO agg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ai nindou-yomondɨ ahɨnümbɨ hohoanɨmo ranahambo bokarɨhehindühɨ yaŋgɨrɨ hoafɨyeihüya, ‘Ndanana Godɨndɨ hoafane,’ masei. Ranɨnambo ai wambo ndürɨ adükarümbani, mbɨsahündɨrɨmboyei,” ’” mehu. ");
INSERT INTO agg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ranɨyu asu Sisas ai nindou afɨndɨ ranaheimbo mborai yahundürɨ haya hoafɨyundürühɨ yahuya, “Se hoafɨ ndanahambo hɨmborɨndei hehi fɨfɨrɨndɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nɨne-moatükunɨ nindou ranahandɨ yahamo ahano ranaiyopoanɨ nindou ranahambo rareranɨ ai moaruwai hohoanɨmombɨ nindouayu Godɨndɨ hɨmboahü. Ŋga nɨne-moatükunɨ ahandɨ yahamo nafɨpoedɨ tükefeyo ranane rareranɨ ai moaruwai hohoanɨmombɨ nindouayu Godɨndɨ hɨmboahü,” mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ranɨyomo asu ahambo süŋgururü-rundeimbɨ ai ahambo-so homo hoafɨyomondowohü yahomoya, “Awi se moai fɨfɨrowandɨyo, Farisi ai se ranɨ hoafɨ hoafɨmayafɨ ranɨmbo hɨmborɨyomo houmbo ahamumbo ŋgusüfoambe moaruwaiarapurɨ rana?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Asu Sisas ai sɨmborɨ hoafɨyuhü yahuya, “Muŋguambo maŋgɨrɨ wandɨ Ape sünambe amaru ai hɨfɨfe-koatemayu ranana fɨrɨbadɨ hefemboane. Farisi ai nindou yahurai anemo. ");
INSERT INTO agg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Se ahamumbo hohoanɨmoyopurɨpoanɨ. Nindou ranai ana hɨmboatɨharɨ nindou anemosɨ, ŋga hɨmboatɨharɨ bodɨmondambo nafɨ nafuimbo yahomombo-anemo. Ŋga asu hɨmboatɨharɨ ŋgorü ai hɨmboatɨharɨ ŋgorümbo nafɨ nafuiarürɨ ana, yɨbobo hoeapoarambe pɨndamboyafanɨ.” ");
INSERT INTO agg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ŋga asu Pita ai hoafɨyundühɨ yahuya, “Awi se yɨhoefɨmbo ranɨ kafoefe hoafɨ ra fɨfɨro hoafɨyafɨmunɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ranɨyu asu Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Awi se-amboanɨ ranɨ-moatükunɨ ranahambo awi fɨfɨrɨfe-koateyomoa? ");
INSERT INTO agg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Muŋgu moatükunɨ yahamo nafɨ ahano ana, asu ranɨ moatükunɨ ranai hanɨ bodoambe tüküfeyoanɨ ahandɨ fi ranambe hasɨfi tüküfihane. Se ra moai fɨfɨrundɨ-yo? ");
INSERT INTO agg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ŋga asu nɨne-moatükunɨ ŋgusüfoambeahɨndɨ hohoanɨmoyo haya yahamo nafɨ tükefeyo ranane ai nindou ranahambo rareranɨ asu ai moaruwai hohoanɨmombɨ nindouayu Godɨndɨ hɨmboahü. ");
INSERT INTO agg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nindou ranahandɨ ŋgusüfoambeahɨndɨ nɨne-moatükunɨ hohoanɨmo tükefeyo ranana, sapo nindou ŋgorümbo hɨfokoefe hohoanɨmo, nɨmorehɨ sɨsɨhɨmo, nindowenihɨ bɨrabɨreimbɨ hohoanɨmo, hümbuhünɨ hohoanɨmo, tɨkai hoafɨ, asu bodɨmondambo moaruwaimbofe hoafɨ ranane. ");
INSERT INTO agg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ranɨ-moatükunɨ ranane nindoumbo rareranɨ asu ai Godɨndɨ hɨmboahü moaruwaimboarerɨ. Ŋga asu nindou ai warɨ popoai hefe-koate asesu ana, ranɨ-moatükunɨ ranai ŋgɨrɨ nindou ahambo randeandanɨ nindou ai moaruwai hohoanɨmombɨ nüŋgu, ŋga wanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sisas ai ranühɨnda botɨfi haya Tair Saidon ŋgoafɨ anambafe hɨfɨ ranɨkɨmɨ mahüfu. ");
INSERT INTO agg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nɨmorehɨ mamɨ Kenanɨhündɨ ai ranɨ hɨfɨhü nɨmarɨ hayamboyo Sisas sowana sɨnɨ puküna hoafɨyondowohü yahoya, “Adükarɨ, Defitɨndɨ Ahuirɨ, se wambo hɨpoamborowandɨrɨ. Wandɨ nɨmorehɨ nɨmorɨndɨ fiambe moaruwai nendɨ ranai nɨmarɨndo hayamboane asu ahambo fi ra moaruwai mamɨkararandɨ,” mehondo. ");
INSERT INTO agg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ŋga asu Sisas ai nɨmorehɨ ranahambo moai hoafɨ akɨdou-amboanɨ kareandɨ. Asu ahambo süŋgururü-rundeimbɨ ai hoafɨyomondo hoaŋgomondühɨ yahomoya, “Se nɨmorehɨ ranahambo koarɨhawanda mbɨho! Ai sɨhefɨmbo süŋgu süŋguramunɨ hoaŋgohane ranɨ-moatükunɨ ranahambo hɨmboso papara hoaŋgo,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Asu Sisas ai ahamumbo sɨmborɨ hoafɨyupurühɨ yahuya, “God ai wambo Israer nindou sipsip nahurai ranaheimbo sowanamboyu yaŋgɨrɨyu farɨhefendürɨmbo koamarɨhendɨrɨ.” ");
INSERT INTO agg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ŋga asu nɨmorehɨ-mayo ranai sɨnɨ Sisasɨndɨ yirɨkɨmɨ peyo nɨmarɨ hoafɨyowohü yahoya, “Adükarɨ, awi se wambo farɨhawandɨrɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Asu Sisas ai ahambo hoafɨyuhü yahuya, “Awi nɨmorɨ akɨdɨbou-yafe-mayo sesɨ ra semɨndɨ hefe yaforɨmbo pife ana, aboedɨ hamɨndɨyopoanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Asu nɨmorehɨ ranai hoafɨyondowohü yahoya, “Adükarɨ, ranana anɨhondanesɨ. Ŋga asu yaforɨ ranai-amboanɨ sesɨ fu ra fondɨ wamɨnɨndɨ ahandɨ afɨndandɨ-mayo ra peyoanɨ sesowohane,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ranɨyu asu Sisas ai ahambo sɨmborɨ hoafɨyundühɨ yahuya, “Nɨmorehɨ, sɨhafɨ anɨhondümbofe hohoanɨmo ra adükarɨ hamɨndane. Nɨne-moatükunɨ ro sɨhambo refembo se hohoanɨmoayafɨ ranana sɨhambo randɨheanɨnɨmboyahɨ,” mehundo. Ranɨyo hoafɨ nɨŋgoambe ahandɨ nɨmorehɨ nɨmorɨ-mayo ranai aboedɨmayo. ");
INSERT INTO agg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ranɨyu asu Sisas ai ranɨhünda botɨfi haya Gariri kurɨhoe-mayo ranɨkɨmɨ mahu. Ai hu haya hɨfɨ wafu-mayo ranɨwamɨ farɨfi hafu mamaru. ");
INSERT INTO agg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ranɨyei nindou afɨndɨ hamɨndɨ ranai nindou tɨŋarɨ moaruwaimbɨ, hɨmboatɨharɨ, nɨmarɨ tɨtɨrɨnambo yaŋgɨrɨ hahabudimbɨ, hoafɨ-koate, asu bɨdɨfɨrɨ amurɨ mamɨkarambo aŋgünümbɨ ra muŋgu aheimbo sahümündihündürɨ Sisas sowana mahei. Ai hei Sisasɨndɨ yirɨkɨmɨ hɨnɨŋgɨmarɨhindüramboyu asu ai aheimbo aboedɨmarearü. ");
INSERT INTO agg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Asu nindou afɨndɨ hamɨndɨ ranai mahepünɨmehindɨ hoafɨ-koatemayei ranai wataporɨyei, nɨmarɨ yaŋgɨrɨ nɨmareimbɨ ai aboedɨyei, tɨŋarɨ moaruwaimbɨ ai hahabodei, hɨmboatɨharɨ ai hɨmboarɨyei raraomarɨhünda horɨhi hehi. Ranɨyei asu ai Israerɨyei God ranahambo Adükarani sei hoafɨmehündo. ");
INSERT INTO agg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sisas ai ahambo süŋgururü-rundeimbɨmbo mborai yahupurɨ hürühepurɨ haya hoafɨyupurühɨ yahuya, “Ro nindou ndanaheimbo hɨpoamboarɨharü sapo ai ndanühɨ ro babɨdɨ ŋgɨmɨ si nɨmareimbo asu sesɨ-koatemayei-ambo ai sesɨmbomayo ra. Ro aheimbo sesɨ segodürɨ-koate koarɨhefendürɨmbo ana moeisahɨ. Asu ai ŋgoafɨna ŋgeihünda nafɨnɨ hɨmboawurɨndeimboyei samboanahɨ,” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Asu ahambo süŋgururü-rundeimbɨ-memo ai düdururühɨ yahomoya, “Asu sɨhɨrɨ dagüda sesɨ afɨndɨ yahurai ndare nɨnɨ kɨkefoefe-koateyowohü nda ndahumɨndefɨ hohu nindou afɨndɨ ranheimbo sesɨ ra mandahundüra?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sisas ai düdureapurühɨ yahuya, “Se bret ra nüŋgunɨmbɨyo sowandümomboemoa?” mehupuramboemo. Asu ai sɨmborɨ hoafɨyomondowohü yahomoya, “Bret 7 anemo asu kinɨ akɨdɨmondou-anemo,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ranɨyu asu Sisas ai nindou afɨndɨ ranaheimbo hɨfɨnɨ nɨnouyei mehundüra asu ai mamarei. ");
INSERT INTO agg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sisas ai bret 7-yomo asu kinɨ akɨdɨbou-memo ranɨyomo ra semündü haya, Godɨmbo hɨhɨfɨrürɨ mbura, hɨfɨtɨre ahambo süŋgururü-rundeimbɨmbo masagapura asu ai nindou afɨndɨ-mayei ranaheimbo yimbumarundürɨ. ");
INSERT INTO agg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nindou ai sesɨ ra sahüsi nafɨrɨhümündihɨyei asu sesɨ wambürɨ 7 ranai bode meŋgorowa ahambo süŋgururü-rundeimbɨ ai fufumaründɨmo. ");
INSERT INTO agg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nindou ai sesɨ masahüsi ra nɨmorehɨ nɨmorɨ akɨdɨbou kameihɨ tapui-koate nindowenihɨ yaŋgɨrɨ ana 4,000 nindouyomo. ");
INSERT INTO agg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ranɨyu refi mbura Sisas ai nindou ranaheimbo koakorɨhendürɨ haya asu ai botambe farɨfi haya Magadan hɨfɨna mahüfu. ");
INSERT INTO agg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi asu Sadyusi nindou ai Sisasɨmbo refi hoeifimbo yahomo houmbo ahambo-so tükümefundɨ. Ai hepünɨfeimbɨ moatükunɨ sünambeahɨndɨ ŋgɨnɨndɨ rarowanda hoeindɨhu yahomo houmbo hoafɨmemondo. ");
INSERT INTO agg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ŋga asu Sisas ai sɨmborɨ ahamumbo hoafɨyuhü yahuya, “Hüfɨhamɨndɨ ai hürɨmɨndɨhɨ sünü hamburɨ aboedɨ kakɨrandanɨ se yaru hoafɨyomondühɨya, ‘Hapoana ŋgɨrɨ hoendo, ŋga yahɨmo aboedɨ nɨŋgomboe,’ yahomondühanemo. ");
INSERT INTO agg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Asu siambeahɨ se yaru hoafɨyomondühɨya, ‘Hapoana hoewerɨndɨmboe, ŋga hoenɨmbaŋɨyowohü asu sünü aŋüsahayo,’ yahomondühanemo. Yɨnɨ, se ana sünambe nɨne-moatükunɨ tükefeyo ranahambo ndoru hoerundühɨmboya, ‘Ranɨ-moatükunɨ ra randɨfemboe,’ yahomondühanemosɨ. Ŋga asu se ana nɨne-moatükunɨyo hapondanambe tüküfemboayo ranahambo moai ndoru fɨfɨrundɨ. ");
INSERT INTO agg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Moaruwai hamɨndɨ hondü nindou anei hapondanambe anɨboadei! Godɨmbo hohoanɨmo-koateyeimbɨ nindou ra ro hepünɨfeimbɨ moatükunɨ nafuimbo düduyahindɨrühɨyei, ŋga ro ŋgɨrɨ sɨheimbo ranɨ-moatükunɨ ra nafuindahandürɨ. Ranɨ-moatükunɨ ana ndearamboyo sɨheimbo horombo Sona ai nafuiyundürɨ masagadürɨ ranɨ yaŋgɨrɨ hoeindɨhimboyei,” mehupurɨ. Ranɨyu asu ai ahamumbo yare hɨnɨŋgɨrepurɨ haya ndamefiyu. ");
INSERT INTO agg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sisasɨmbo süŋgururü-rundeimbɨ ai Gariri kurɨhoe ra barɨhoemo gogoanɨnɨ mahomo, asu ai moai bret sowandümo, ŋga mɨtanɨmarundümo. ");
INSERT INTO agg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ranɨyu asu Sisas ai ahamumbo hoafɨyuhü yahuya, “Farisi asu Sadyusi nindou-yomondɨ fufudɨgoyo-randeimbɨ moatükunɨ yis ranahambo awi se hɨbadümbo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ranɨyomo asu ai ahamundɨhoarɨ sɨmborɨ hoafɨyomondühɨ yahomoya, “Ai ra-mehu awi sapo sɨhɨrɨ bret semɨndɨ sɨfokoate-mayefɨ ranɨmboyumunɨ yare hoafɨmemunɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sisas ai nɨne-moatükunɨ hoafɨ ai wataporɨ mboarundɨ ranahambo fɨfɨreapurɨ. Ranɨyu asu ai ahamumbo hoafɨyupurühɨ yahuya, “Se sɨhamundɨ anɨhondümbofe hohoanɨmo ra akɨdou safane! Se ra nɨmboe sɨhamundɨhoarɨ wataporɨmboarundɨ bret semɨndɨ-koateayefɨ yahomo houmbo rana? ");
INSERT INTO agg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Awi se fɨfɨrundai? Sapo ro hondahüfeimbɨ bret hɨfɨtɨrɨhe heheya 5,000 nindoumbo yimbumarɨheandɨ ra se hohoanɨmoyomondai? Asu nüŋgunümbɨ wambürɨyo se wambürɨhɨru manindunda? ");
INSERT INTO agg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Asu bret 7 ranɨyo 4,000 nindoumbo hɨfɨtɨrɨhe maseheandambo asu se wambürɨ 7 wambürɨhɨru manindundɨ ra fɨfɨrundai? ");
INSERT INTO agg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Awi se ra nɨnüŋguyafumboyomo fɨfɨrɨfe-koateayomo rana? Ro ana moai sɨhamumbo bretɨmbo wataporɨmborɨhapurɨ, ŋga wanɨ. Ro ana Farisi asu Sadyusi nindou-yomondɨ fufudɨgoyoweimbɨ moatükunɨ yis ranahamboyahɨ awi hɨbadümbo masahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ranɨyomo asu ahambo süŋgururü-rundeimbɨ-memo ranai ŋgusüfo masowandümo Sisas ai fufudɨgoyo-randeimbɨ moatükunɨ yis bretambe pefe arandɨ ranahambo se hɨbadümbo yahumboyupoanɨ, ŋga Farisi Sadyusi nindou-yomondɨ yamundɨfe hoafɨ hohoanɨmo ranahamboyu hoafɨ mayu. ");
INSERT INTO agg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨ Sisaria Firipai hɨfɨna homondühɨyomo asu ranɨ-sɨmboanɨ ai ranahamumbo düdufi hoafɨyupurühɨ yahuya, “Nindou ai Nindou Hondü ranahambo düdi sei hoafɨyeihɨyeia?” mehupuramboemo. ");
INSERT INTO agg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Asu ai sɨmborɨ hoafɨyomondühɨ yahomoya, “Bɨdɨfɨrɨ ai seiya ‘Son sapo nindou hundürarü-randeimbɨmbeyu,’ asu bɨdɨfɨrɨ ai ‘Seremaiambeyu’ asu ‘Godɨndɨ hoafɨ hoafɨyu-randeimbɨ mamɨmbeyu’ asei,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ranɨyu asu Sisas ai düdureapurühɨ yahuya, “Asu sɨhamundɨhoarɨ ro nindou dɨdɨyahɨ se nüŋguru hohoanɨmoyomondühɨyomoa?” mehupuramboemo. ");
INSERT INTO agg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Asu Saimon Pita ai sɨmborɨ ahambo hoafɨyundühɨ yahuya, “Seanafɨ Kraisayafɨ. Seana God sapo yaŋgɨrɨ koadürümbo nüŋgumbü-mayu ranahandɨ Nɨmor-anafɨ,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Asu sɨmborɨ Sisas ai hoafɨyuhü yahuya, “Saimon, Sonɨndɨ nɨmorɨ, se hɨhɨfɨ-hɨhɨfɨndafɨ! Ranɨ hoafɨ ra moai nindou hɨfɨ ndanühünda ranahandɨ-mayo tüküfenɨnɨ, ŋga moanɨ wandɨ Ape sünambe amaru ahandɨhoarɨ sɨhambo masaganɨnɨ. ");
INSERT INTO agg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ŋga sɨhambo ro hoafehanɨnɨ nda, se Pita-anafɨ. (Ndürɨ Pita ana Grik hoafɨnambo nɨmoei yɨtɨfo ane). Asu nɨmoei yɨtɨfo ranɨwamɨ anɨmbo ro wandɨ nendɨ gugurɨndɨhearümboyahɨ. Rananɨmbo asu ŋgɨrɨ yɨfɨmbo ŋgɨnɨndɨ amboanɨ wandɨ nendɨ ranaheimbo hɨfɨnambondeandɨ. ");
INSERT INTO agg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Rananɨmbo asu ro sɨhambo God ŋgɨnɨndɨ sünambe hɨfandarandɨ ranahandɨ yipurɨ ki ndahanɨnɨmboyahɨ. Nɨne-moatükunɨ hɨfɨ ndanühɨ se pararowandɨ ranana asu God ai-amboanɨ sünambe pandeambui. Asu nɨne-moatükunɨ hɨfɨ ndanühɨ se tirɨhoefɨ asɨhoefɨ ana, asu God ai-amboanɨ sünambe tindɨhai dɨgembui,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sisas ai ahambo süŋgururü-rundeimbɨmbo nindou amurambo yowanɨ Krais ani yahopoanɨ yahu haya hoafɨmepurɨ. Sisas ai ro yɨfɨnda mbundɨha botɨndaheamboyahɨ yahu haya hoafɨmayu ranɨmbo. ");
INSERT INTO agg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mamɨ ranɨ-sɨmboanɨ Sisas ai piyu haya ahambo süŋgururü-rundeimbɨmbo nafuimefoepurɨ ai Serusarem ŋgoafɨnambo mbühuwamboane. Ndanühündambo bogorɨ nindou, bogorɨ Godɨmbo sesɨ sɨhou-rundeimbɨ nindou asu ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ-yomondɨ-mayo afɨndɨ tɨŋɨrɨfo tüküfendombomayo ranahambo hoafɨmayu. Ai yare nafuiyupurɨ hoafɨyuhü yahuya, “Nindou ranai wambo hɨfokoandu ndɨrɨmboemosɨ, ŋga asu ŋgɨmɨ si süŋgunambo asükainda ro yaŋgɨrɨ botɨndaheamboyahɨ,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ranɨyu asu Pita ai ahambo ŋgorükɨmɨ serümündü hu hɨnɨŋgɨrirɨ haya ŋgɨnɨndɨ hoafɨyundühɨ yahuya, “Adükarɨ, ranɨ-moatükunɨ ra se yowanɨ sɨhambo yahurai tükündɨfenɨnɨmboe, ŋga yowanɨ,” mehunduamboyu. ");
INSERT INTO agg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Asu Sisas ai hɨhɨrɨfi nüŋgumbo Pitambo hoafɨyundühɨ yahuya, “Satan, se wambo-sowahɨndɨ andai ragu biyafo! Awi se wambo nafɨ gürarowandɨrɨ. Awi se sɨhafɨ hohoanɨmoayafɨ ranana Godɨndɨ-mayo sowandɨfɨmbo-yafɨpoanɨ, ŋga ranana hɨfɨnɨndɨ nindou-yafe-mayo masowandɨfɨ,” mehundo. Ai muŋguambo ahamumbo hoafɨyupurühɨ yahuya, “Nindou dɨdɨyei ai wandɨ süŋgu hombo hohoanɨmondeihɨ ana, asu ai ahei hohoanɨmo ra hɨfɨnambondɨhi hehi nɨmɨ keimbɨ karɨhendɨfeimbɨ fihɨ yɨfɨmbo noundahi hehi muŋguambo si aho ra wambo süŋgumbɨrɨhindɨramboane.” ");
INSERT INTO agg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ranɨyu asu Sisas ai ahambo süŋgururü-rundeimbɨ-memo ranahamumbo hoafɨyuhü yahuya, “Nindou düdi ai wandɨ süŋgu hombo hohoanɨmoayu ana, ai moanɨ ahandɨ fimbo hɨfɨnambonde haya nɨmɨ keimbɨ karɨhendeimbɨ fihɨ yɨfɨmbo nounde wambo süŋgundandɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nindou düdi ai ahandɨ fi ranahambo aboedambofembohünda ahandɨhoarɨ kɨkɨharamündu ana, asu ahandɨ fi yaŋgɨrɨ nɨŋgombo awandhoemboe. Ŋga asu nindou düdi ai wambohünda ahandɨ fi ra moanɨ yare hohoanɨmo-koate hɨnɨŋgɨreandɨ ana, asu ai süŋgunambo ahandɨ fi yaŋgɨrɨ nɨŋgombo ra gedühɨ nɨŋgomboe. ");
INSERT INTO agg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Asu nindou düdi ai hɨfɨnɨndɨ moatükunɨ muŋguambo ra semündü hɨfanda huhü asu ahandɨ fi nɨŋgo awandɨhoeihɨ ranana ahandɨ muŋgu moatükunɨ nüŋgunde nindou ranahambo mafandɨhera? I ra wanɨ! Nindou mamɨ ai nɨnɨ-moatükunɨnambo sɨsemandendɨ ahandɨ yaŋgɨrɨ nɨŋgo hohoanɨmo ra hɨhɨrɨfe semɨndɨmbohünda? ");
INSERT INTO agg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nindou Hondü ai ahandɨ Afɨndandɨ hɨmboamupuimborandeimbɨ moatükunɨ ranɨ mbusümo ahandɨ sünambeahɨndɨ nendɨ-memo ranɨ-babɨdɨmbo ndeara akɨmɨ kosɨmbo yaŋgɨrani. Ra-sɨmboanɨ asu ai kusühɨ nindou dɨdɨyei nɨne ratüpurɨ ramarɨhindɨ ranɨ sɨmogodühɨ takɨnɨ dagadürümbui. ");
INSERT INTO agg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ro sɨhamumbo anɨhondümboanahɨ hoafehapurɨ nda, nindou ndanühɨ anɨboadei nda bɨdɨfɨrɨ ai ŋgɨrɨ yɨfɨndei, ŋga nɨboadeimbo Nindou Hondü ranai bogorɨ nindoumbondüfi akusu ra hoeindɨhorɨmboyei,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Refe haya 6 si ranai howane, asu ranambe Sisas ai Pita, asu Sems Son apodoho ranahamumbo sepurümündɨ haya hɨfɨ wafu nɨmoamo hamɨndɨ-mayo ranɨwamɨ moanɨ ahamund-amboanɨ mahafomo. ");
INSERT INTO agg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Asu ai hɨmboyomondane ahamundɨ hɨmboahü Sisas ai moanɨ ranɨ-poanɨmbo fi tükümefendo. Ranɨyo asu ahandɨ ŋgusümboarɨ ranai hüfɨhamɨndɨ nahurai sɨsɨŋarambo randühɨyo asu hoearɨ magüdeandɨ ranai si nahurai kɨfohɨ hamɨndɨ tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ranɨyomo asu ahambo süŋgururü-rundeimbɨ ŋgɨmɨ-memo ranai Moses Eraisa ai Sisas babɨdɨmbo wataporɨmemonda hoeimarüpurɨ. ");
INSERT INTO agg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ranɨyu asu Pita ai ranɨmbo Sisasɨmbo hoafɨyundühɨ yahuya, “Adükarɨ, awi aboedɨ safanefɨ sɨhɨrɨ ndanühɨ sühifɨ anɨmboefɨ! Se refembo hohoanɨmoayafɨ ana, awi ro dago ŋgɨmɨ hüründɨhapurɨmboyahɨ, sɨhambo mamɨ, Mosesɨmbo mamɨ, asu Eraisambo mamɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ranɨyo asu Pita ai hoafɨyuhü nüŋgu ane kɨfohɨ sɨsɨŋarambo-randeimbɨ mburüŋgai ranai ahamumbo gabudɨmafoareapurɨ asu hoafɨ mamɨ ranai mburüŋgai-ambeahɨndɨ tüküfihɨ hoafɨyowohü yahoya, “Nindou ndanana wandɨ nɨmorɨ hondü ro ahambo ŋgusüfo parɨhineimbani. Ro ahambo siaoyamboanahɨ, ŋga ahambo hɨmborɨndɨmondo,” meho. ");
INSERT INTO agg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sisasɨmbo süŋgururü-rundeimbɨ-memo ranai ranɨ hoafɨ ra hɨmborɨyomo houmbo yɨhɨmboyomondühɨ hɨfɨnɨ hɨfambe mbɨro pütapɨmemo. ");
INSERT INTO agg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ranɨyu asu Sisas ai ahamumbo-so sünɨ sündiapurühɨ hoafɨyuhü yahuya, “Boteyafu. Se yɨhɨmbondɨmboemo,” mehupuramboemo. ");
INSERT INTO agg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ranɨyomo asu ai mbɨro faründümo hɨmboyomondane moai dɨdɨ ai ranühɨ nüŋgu, ŋga Sisas ai yaŋgɨrɨ manüŋgu. ");
INSERT INTO agg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ranɨyomo asu hɨfɨ wafu-mayo ranɨ-wamɨnɨndɨ hɨfɨna hanɨmondühɨ nafɨnɨ Sisas ai ahamumbo yowanɨ hoafɨ hoafɨyupurühɨ yahuya, “Yowanɨ se nindou amurambo hoafɨndɨmboemo sapo nɨne-moatükunɨ tükümefeyoa hoeimarundɨ ranahambo. Ŋga ranɨ-moatükunɨ ra moanɨ rande yagodɨ ŋgombo Nindou Hondü ranai yɨfɨhündɨ botɨfiyu-ambe tükümbɨfeyo-wamboane,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ranɨyomo asu ai sɨmborɨ ahambo düduyafundowohü yahomoya, “Asu nɨmboe ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ ai hoafɨyomondühɨya Godɨndɨ hoafɨ hoafɨyu-randeimbɨ Eraisa boatei tükümbɨfiyu-wamboane mehomoa?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Asu Sisas ai ahamumbo sɨmborɨ hoafɨyuhü yahuya, “Yɨnɨ, anɨhondane Eraisa ai boatei tüküfi muŋguambo moatükunɨ ra ai nafɨyɨmɨndɨ sɨhefemboani. ");
INSERT INTO agg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ŋga asu ro sɨhamumbo hoafehapurɨ, Eraisa ai ndeara tüküfimboani, ŋga asu nindou ai moai ahambo ndorɨhorɨ fɨfɨrɨhorɨ. Ŋga asu ai moanɨ ahambo ai hohoanɨmoayei ranɨ-süŋgurɨhorɨ mamɨkarɨ moatükunɨ raraoarɨhorɨ hei. Mamɨ ranɨ-süŋgumbo anɨmbo Nindou Hondü ranahambo amboanɨ randɨhorɨ moaruwaimbo-ndɨhorɨmboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ranɨyomo asu ahambo süŋgururü-rundeimbɨ ai ranɨ hoafɨ ra hɨmborɨyomo houmbo ai Son sapo hundürüra-randeimbɨ-mayu ranahamboani wataporɨmboaramunɨ mehomo. ");
INSERT INTO agg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Asu ai nindou afɨndɨ meŋgoro ranaheimbo sowana homo tüküyafundane, nindou mamɨ ai Sisasɨmbo-so tüküfi hu yirɨ yimbu pusɨreandühɨ hoafɨyundühɨ yahuya, ");
INSERT INTO agg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Adükarɨ, awi se wandɨ nɨmorɨ ranahambo hɨpoamborɨworɨ! Ai ana wunünümboyu randühɨ ranani asu ahandɨ fi moaruwai tüküfihɨ hɨmboawuwure piyu arandɨ asu ai afɨndɨmbo haiambe pɨyu asu hɨmonɨ pɨyu arandɨ. ");
INSERT INTO agg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ro sɨhafɨ süŋgurunɨnɨ-rundeimbɨ-memo ranahamumbo-so sahümɨndɨ mahahɨ, ŋga asu ai ŋgɨrɨ ahambo aboedɨndüwurɨ,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ranɨyu asu Sisas ai nüŋgumbo hoafɨyuhü yahuya, “Awi nindou se ana anɨhondümbofe hohoanɨmo-koateayei hehi hohoanɨmo ndofe kife-koate nindou-anei. Nüŋgunɨmbɨmbo ro se babɨdɨmbo manɨmboahɨ rana? Nüŋgunɨmbɨmbo ro ra awi hɨpoambomandɨheandüra? Ndühɨ se nɨmorɨ ra wambo sowana sahorɨmɨndei sühüsi,” mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ranɨyu asu Sisas ai moaruwai nendɨ nɨmorɨmayu ranahandɨ fiambe mamaro ranahambo andai ragu hafɨ mehundoa asu ai nɨmorɨndɨ fiambeahɨndɨ kosɨfoai haya ragu mahoa, asu mamɨ ranɨ-sɨmboanɨ hamɨndɨ nɨmorɨ ranai aboedɨmayu. ");
INSERT INTO agg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ranɨyomo asu Sisasɨmbo süŋgururü-rundeimbɨ ai ahambo-so ai yaŋgɨrɨ tüküyafu düduyafu hoafɨyomondowohü yahomoya, “Nɨmboe asu ro moaruwai nendɨ ranahambo raguanambofe-koatemayefa?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ai sɨmborɨ hoafɨyuhü yahuya, “Nɨmboe sapo se ranɨ-moatükunɨ refe ranahambo anɨhondümbofe akɨdou yaŋgɨrɨ-memo ranɨmbohünda se ŋgɨrɨndɨmo. Ro sɨhamumbo anɨhondümboanahɨ hoafehapurɨ nda, sɨhamundɨ anɨhondümbofe hohoanɨmo ranai akɨdou hambomo hoarɨ yahurai-ayopurɨ ana, asu se nɨŋgomombo hɨfɨ wafu ndanahambo ndühünda fɨrɨhoefɨ hawa gogu ranühɨ hafɨ nɨmarɨfɨ ehomo ana, ra ai ŋgomboe. Asu se nɨne-moatükunɨ refembo ra ŋgɨrɨ sɨhamumbo tɨŋɨndapurɨ, ŋga se moanɨ raranɨ-moatükunɨ ra randumboemo!” mehu. ");
INSERT INTO agg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Sisasɨmbo süŋgururü-rundeimbɨ ai-babɨdɨ Gariri hɨfambe gugurɨyafu mburümbo ai hoafɨyuhü yahuya, “Nindou Hondü ra ndeara nindou ranahamundɨ warühɨfembo yaŋgɨrani, ŋga ahambo hɨfokoandüwurɨmboemo. Ŋga asu ai randɨfi haya süŋgunambo ŋgɨmɨ si yagudɨ mbunda yaŋgɨrɨ botɨndüfimbui,” mehupuramboemo. Ranɨyomo asu ahambo süŋgururü-rundeimbɨ ai afɨndɨ hohoanɨmomemo. ");
INSERT INTO agg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo Kaperneam ŋgoafɨhü tüküyafundane, Godɨndɨ worɨmbohünda nindou takis kakɨ sowandümo-rundeimbɨ ai Pitambo-so tüküyafu düduwurühɨ yahomoya, “Sɨhafɨ yamunde-randeimbɨ nindou ranai Godɨndɨ worɨmbo takis kakɨ ra sɨhendai?” mehomondoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Asu Pita ai sɨmborɨ hoafɨyupurühɨ yahuya, “Yɨnɨ, ai sɨhendɨsɨ,” mehu. Asu Pita ai worambe tükümefiyua, Sisas ai ranɨ hoafɨ boatei düdufihɨ yahuya, “Saimon, se sɨhafɨ hohoanɨmo ra nüŋgu-nahuraiyo-a? Hɨfɨ ndanühündambo bogorɨ nindou ra dadɨmayoyo mamɨkarambo takis ra sowandümo arunda? Ai ra nindou mamɨ ranɨ sɨrɨmayei ranahei-mayoyo asu nindou amurɨyei-mayoyo sowandümo arundɨ?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Asu Pita ai sɨmborɨ hoafɨyundühɨ yahuya, “Nindou amurɨyei-mayo,” mehuamboyu. Ranɨyu asu Sisas ai asükaiyu hoafɨyuhü yahuya, “Refe anasɨ, nindou mamɨ ranɨ sɨrɨ ranai kakɨ ra sɨhefepoanɨsɨ, ŋga moanɨmboane. ");
INSERT INTO agg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ŋga asu sɨhɨrɨ takisɨmbo kakɨ sɨhefe-koateayefɨ ana, sɨhefɨmbo yɨboaruko-ndɨhimunɨmboyei. Ŋga se ŋgafɨ Gariri hoe ranambe batüründandanɨ kinɨ weaŋgurühɨ hürarɨhoefɨ ranahandɨ yahamo hɨmbondafanɨ kakɨ ŋgüsarɨmboe. Ranana waŋgei Godɨndɨ worɨ ranahambo kakɨ sɨhefembohünda ndearane. Rananɨmbo ndowandɨfɨ hawa ahamumbo dabapurɨ sɨhehɨ takisɨmbo sɨhefembohünda,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mamɨ ranɨ-sɨmboanɨ ahambo süŋgururü-rundeimbɨ-memo ranai Sisasɨmbo-so tüküyafu düduyafu hoafɨyomondowohü yahomoya, “Nindou düdi God ŋgɨnɨndɨ hɨfandarandɨ ranambe adükarɨ hamɨndɨ hondayua?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Ranɨyu asu Sisas ai nɨmorɨ akɨdou serümündü ahamundɨ mbusümo hɨnɨŋgɨrirɨ haya hoafɨyuhü yahuya, “Ro sɨhamumbo anɨhondümboanahɨ hoafehapurɨ nda. Se hɨhɨrɨfe nɨmorɨ akɨdou ndahurai tüküfekoateayomo ana, asu se ŋgɨrɨ God ŋgɨnɨndɨ hɨfandarandɨ ranambe keboundɨ. ");
INSERT INTO agg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nindou düdi ai moanɨ ahandɨ fi hɨfɨnamboreandühɨ nɨmorɨ akɨdou ndahuraiayu ana, nindou ranai God ŋgɨnɨndɨ hɨfandarandɨ ranambe adükarɨ hamɨndɨ hondü tükündüfimbui. ");
INSERT INTO agg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nindou düdi ai wambohünda nɨmorɨ ndahuraimbo amboanɨ hohoanɨmoayundürɨ ana, asu ai wambo amboanɨ hohoanɨmoyundɨrühani,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ŋga asu nindou düdi ai nɨmorɨ akɨdɨbou mamɨ ndahurai wambo anɨhondümboareandɨrɨ ranahambo randeandanɨ nɨmorɨ ranai moaruwai hohoanɨmo süŋguareandɨ ana, awi nindou ranahambo nɨmoei hondü ra kife mburumbo ahandɨ amɨndasümoambe foefendo hefe sɨrɨwara hohoeambe safoefimbo ra aboedane. ");
INSERT INTO agg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Hɨfɨ ndanühɨ moaruwai moatükunɨ afɨndɨ rareandanɨ nindou moaruwai hohoanɨmoyei arɨhündɨ. Anɨhondane hohoanɨmo ra tükündɨfe gedühɨ yagodomboesɨ, ŋga hɨpoanɨmboembou-anei nindou ranai rarɨhindanɨ moaruwai hohoanɨmo ra tüküfe arandɨ. ");
INSERT INTO agg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Sɨhafɨ warɨ, yirɨ ranai randeandanɨ se moaruwai hohoanɨmoayafɨ ana, kandandɨfɨ ragu pütindafoandɨ! Aboedane se warɨ mamümbɨyo asu yirɨ mamümbɨyo hefe yaŋgɨrɨ koadürümbo nɨŋgoweimbɨ semɨndɨ ra. Ŋga asu yirɨ yɨboboyopɨrɨ, warɨ yɨboboyopɨrɨ hefe sapo hai koadürümbo koadürümbo horoweimbɨ-mayo ranambe sɨhambo pifenɨnɨ ana, moaruwai-ane. ");
INSERT INTO agg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Asu sɨhafɨ hɨmboarɨ ranai randeandanɨ se moaruwai hohoanɨmoayafɨ ana, hündandɨfɨ ragu pütindafoandɨ! Se hɨmboarɨ mamümbɨyo hefe yaŋgɨrɨ koadürümbo nɨŋgombo ra aboedane. Ŋga asu hɨmboarɨ yɨboboyopɨrɨ hefe sapo haiambe sɨhambo pifenɨnɨ ana, moaruwai-ane. ");
INSERT INTO agg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Se hɨbadümbo sapo akɨdɨbou ndahurai ranheimbo ŋgɨrɨ moanane yahomondühɨ hɨnɨŋgɨndundürɨ. Ro sɨhamumbo anɨhondümboanahɨ hoafehapurɨ, ahei sünambeahɨndɨ nendɨ ranai ana muŋguambo si ra wandɨ Ape sünambe amaru ranahandɨ ŋgusümboarɨ hoeirüwurɨ rundühanemo.  ");
INSERT INTO agg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ŋga Nindou Hondü ana sapo dɨdɨyei ai awarɨhehindeimbɨ-mayei aheimbo aboedambofendürɨmboyu tükümefiyu. ");
INSERT INTO agg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Se nüŋguru hohoanɨmoyomo-ndühɨyomoa? Nindou mamɨ ai ahandɨ 100 sipsip moaŋgui fandandeimbɨhündɨ asu mamɨ ai afarɨhoayo ra nüŋgumandɨfia? Ai amurɨ 99 ranaheimbo rande hɨnɨŋgɨndeiaranɨ wafuwamɨ wohɨ dagüdi wakɨndɨhindanɨ anɨmbo asu ai ŋgorü mafarɨhoayo ranahambo kokonda wakɨndeambui. ");
INSERT INTO agg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ro sɨhamumbo hoafehapurɨ, nindou ranai sipsip mafarɨhoayo-mayo ra kokora hoeiareandɨ ana, ai ahandɨ sipsip ranahambo moanɨ afɨndɨ hamɨndɨ hɨhɨfɨ-hɨhɨfɨndümbui ŋga, asu ŋgɨrɨ amurɨ farɨhefe-koate burɨmayei ranaheimbo yahurai hɨhɨfɨ-hɨhɨfɨndu. ");
INSERT INTO agg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mare yahurai ane sɨhamundɨ Ape sünambe amaru ai-amboanɨ akɨdɨmondou ndahurai ranaheimbo hohoanɨmoayu refe farɨhefepoanɨ yahu haya.” ");
INSERT INTO agg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Asu sɨhafɨ wandafɨ ranai sɨhambo moaruwai hohoanɨmonduanɨ ana, asu se ŋgafɨ ahambo-so tükündafo sapo nɨne-moatükunɨ ai hüti sɨhambo ramareandɨ ra nafuindafɨndo. Asu ranɨ-moatükunɨ ra moanɨ dɨbo sɨhafandamboanɨ yaŋgɨrɨ anɨmbo randɨneandɨ sɨhafandɨ mbusümo. Ai sɨhafɨ hoafɨ ra hɨmborayunɨnɨ ana, asu se sɨhafɨ wandafɨ ranahambo aboedambo ŋgunindɨmboro sowarɨndɨfɨmbo-anafɨ. ");
INSERT INTO agg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ŋga asu nindou ranai sɨhafɨ hoafɨ ra hɨmborɨ-koatenduanɨ ana, asu se nindou mamɨnduanɨ, yimbundafandanɨ yahurai ndowapɨndɨfɨ hawa ŋgafɨ. Rananɨmbo asu ai sapo nɨne-moatükunɨ tükümefeyo ranahambo anɨhondane mbɨseimboyei. ");
INSERT INTO agg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Asu nindou ranai ahei hoafɨ hɨmborɨ-koatenduanɨ Kraisɨndɨ nendɨ-mayei muŋguambo fandɨhindanɨ ranaheimbo ranɨ-moatükunɨ ranahambo hoafɨndafɨndürɨ. Bɨdɨfɨranɨ nindou ranai ahei hoafɨ ra hɨmborɨ-koate hɨmbosɨhɨmo-ndɨhoayuanɨ ana, ranahambo randɨhi hohoanɨmondeihɨya nindou ranai Godɨmbo anɨhondümbofe-koate nindou asu nindou takis kakɨ semündü-randeimbɨ nahurai-ani, mbɨsei-amboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ro sɨhamumbo anɨhondümbo-anahɨ hoafayahɨ nda. Nɨne-moatükunɨ hɨfɨ ndanühɨ se kɨkɨharündümo ranana asu God ai-amboanɨ sünambe kɨkɨhɨndamündɨmbui. Asu nɨne-moatükunɨ se hɨfɨ ndanühɨ moanɨ raru hɨnɨŋgarundɨ ranana asu God ai-amboanɨ sünambe moanɨ hɨnɨŋgɨndeambui. ");
INSERT INTO agg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Awi asükai sɨhamumbo hoafehapurɨ nda. Nɨnɨ-sɨmboanɨyo nindou yimbu se hɨfɨ ndanühɨ nɨmbafanɨmbo nɨnɨ-moatükunɨmboyo se refemboane safanɨ hena ranahambo Godɨmbo dɨdɨbafefɨneandɨ ana, ranɨ-moatükunɨ ra wandɨ Ape sünambe amaru ranahandɨ warɨ süŋgu sɨhafanɨmbo tükündɨfepɨrɨmboe. ");
INSERT INTO agg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ŋga nindou yimbu-yafe, ŋgɨmɨyei ranai wandɨ ndürɨnambo mamühɨyahindanɨ ana, ro ranühɨ ahei mbusümo nɨmboambo-anahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ranɨyu asu Pita ai Sisasɨmbo-so tüküfi düdufi hoafɨyundühɨ yahuya, “Adükarɨ, asu wandɨ wandafɨ ai moaruwai hohoanɨmondupündunda ŋguwanɨ wambo ra, asu ro nüŋgunümbɨmbo ahambo amboawi mbɨsa hɨnɨŋgɨmandɨhina? 7 ambefimbɨ ramandɨhinɨyo?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Asu Sisas ai hoafɨyuhü yahuya, “Yowanɨ, 7ambe ramɨndeimbɨ asükai 7ambe ramɨndeimbɨ asükai 7ambe ramɨndeimbɨ aho ra. ");
INSERT INTO agg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ŋga God ŋgɨnɨndɨ hɨfandarandɨ ranai ndahurai-ane. Adükarɨ bogorɨ nindou mamɨ ai ahandɨ ratüpurɨyomo-rundeimbɨ nindou ranhamundɨ nɨnɨ-moatükunɨyo ahandɨ-mayo sowandümo marundɨ ra sɨmogodühɨ tümara hu. ");
INSERT INTO agg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ai hapoadümbo kakɨ nindou ahandɨ-mayo masowandümo ra dɨdɨboadoreandühɨ nɨmaru-ane, nindou mamɨ ahandɨ-mayo ten mirian (10,000,000) kakɨ semündümbɨmayu ranahambo sowaründümo tükümefundɨ. ");
INSERT INTO agg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ŋga asu nindou ranai moai kakɨ yahurai sɨhendɨ asükaiyo sɨmborɨ ahambo segodɨmbo. Ranɨmboyu asu bogorɨ nindoumayu ranai nindou ranahambo hoafɨyhüya, ‘Nindou ranahambo, ahandɨ aborüdɨ asu ahandɨ muŋgu moatükunɨ ra sahündürühɨ ranɨ fihɨndɨ kakɨ sɨmborɨ segodɨmbo mbɨsahümündi-amboane,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ranɨyu asu nindou ranai bogorɨ nindoumayu ranahandɨ fikɨmɨ yimündɨho kare pusɨre nɨmarümbo hoafɨyuhüya, ‘Se awi wambo hɨpoamborowandɨrühɨ hɨmboarɨnambo yaŋgɨrɨ hɨfandandɨrɨ. Ŋga awi ro sɨhafɨ-mayo muŋguambo moatükunɨ masahamɨndɨhɨ ra sɨhambo asükainda ndahanɨnɨmboyahɨ!’ yahu hüti-hoafɨmayundo. ");
INSERT INTO agg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ranɨyu asu bogorɨ nindoumayu ranai nindou ranahambo hɨpoamborirühɨ ahandɨ sɨmborɨ segodɨmbo-mayo ra hɨnɨŋgɨre haya asu moanɨ aboedɨ koamarɨheira mahu. ");
INSERT INTO agg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ranɨyu asu ai nafɨnɨ huhündamboyu ahandɨ ŋgorü afɨndɨ mamɨ ratüpurɨyafanɨ-rɨnandeimbɨ ai kakɨ akɨdou sɨmborɨ ahambo segodɨmbo eŋgoro ranahambo hoeimarirɨ. Ranɨyu asu ai ahambo mburümündü haya amɨndasümohü fufure waramberamündühü hoafɨyuhü yahuya, ‘Se wandɨ-mayo ŋgɨmɨ kina sɨmborɨ süŋgu ra ndawandɨrɨ!’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ranɨyu asu ahandɨ ŋgorü afɨndɨmayu ranai ahandɨ fikɨmɨ yimɨndoho kare pusɨre nɨmarɨmbo hoafɨyundühɨ yahuya, ‘Se awi wambo hɨpoamborowandɨrühɨ hɨmboarɨnambo yaŋgɨrɨ hɨfandandɨrɨ, ŋga awi ro sɨhafɨ-mayo masahamɨndɨhɨ ra sɨmborɨ hɨhɨrɨndɨhe ndahanɨnɨmboyahɨ,’ mehundo. ");
INSERT INTO agg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ŋga asu ŋgorü afɨndɨ ai ahandɨ hoafɨ hɨmborɨ-koate refembo moei mehu. Ranɨyu asu ŋgorü afɨndambo serümündü hu karabusɨmarirɨ mamɨ ahandɨ kakɨ akɨdou ra dagadowanɨ anɨmbo hɨnɨŋgɨndirümbui. ");
INSERT INTO agg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Asu ratüpurɨyomo-rundeimbɨ bɨdɨfɨrɨ ai ranɨ-moatükunɨ ramefeyo ranahambo hoeiru houmbo ai ŋgɨnɨndɨ hoafɨmemo. Ranɨyomo asu ai bogorɨ nindoumayu ranahambo-so tüküyafu nɨne-moatükunɨ tükümefeyo ranahambo wataporɨmbomarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ranɨyu asu bogorɨ nindou ai ratüpurɨyu-randeimbɨmayu ranahambo mborai yahundo hühürirɨ hoafɨyundühɨ yahuya, ‘Se ana nindou ratüpurɨyafɨ-randeimbɨ moaruwai hamɨndanafɨ. Se wambo düdumefoandɨ asu ro afɨndɨ kakɨ se wandɨ-mayo masowandɨfɨ ranahambo i amboawi saheheya moanɨ hɨnɨŋgɨmarɨheanɨnɨ. ");
INSERT INTO agg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Se sɨhafɨ mamɨ ratüpurɨyafanɨ-rɨnandeimbɨ-mayu ranahambo hɨpoamboroworühɨ amboawi safɨndosɨ sapo ro sɨhambo ramarɨheanɨnɨ süŋgumbo,’ mehundo. ");
INSERT INTO agg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ranɨyu asu bogorɨ nindoumayu ranai ahambo ŋgɨnɨndɨrürühɨ karabusambe asübusɨ semɨndɨmbo koamarɨheirɨ. Ai karabusambe nüŋgumbo-anɨmbo asu sɨmborɨ saimbo ra dagadombui,” Sisas ra-mehu. ");
INSERT INTO agg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ranɨyu Sisas ai hoafɨ moendɨreandühɨ hoafɨyuhü yahuya, “Moanɨ mamɨ yahurai safɨ wandɨ Ape sünambe amaru ranai nindou muŋguambo sɨhamumbo randeapurümbui se sɨhamundɨ ŋgusüfoambe sɨhamundɨ wandafɨ ranahambo amboawi yaho-koateayomo ana,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sisas ai ranɨ hoafɨ wataporɨmbomarandɨ ra moendɨre haya asu ai Gariri hɨfɨ ra hɨnɨŋgɨre haya Sudia hɨfɨna Sodan hoe ŋgorü goesürɨnɨ barɨhoei mahu. ");
INSERT INTO agg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ranɨ-sɨmboanɨ nindou afɨndɨ safɨ ranai ahandɨ süŋgu maheia asu aheimbo ranühɨ aboedɨmarearü. ");
INSERT INTO agg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ranɨyomo asu Farisi nindou bɨdɨfɨrɨ ai Sisasɨmbo-so tüküyafu ahambo refi hoeifimbo yahomo houmbo düdururühɨ yahomoya, “Nindou mamɨ ahandɨ hohoanɨmo yaŋgɨrɨ ahandɨ nɨmorehɨ hɨnɨŋgɨfembo ehu ana, asu sɨhefɨ ahɨnümbɨ hohoanɨmo ranahambo waŋgeimandɨyo?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Asu Sisas ai sɨmborɨ hoafɨyuhü yahuya, “Awi se moai Baiborambe hoeirundɨyo sapo hoafɨ ranai yare hoafɨyowohüya ‘Weaŋgurühɨ hondü Nafɨra-randeimbɨ ai nɨmorehɨ nindowenihɨ nafɨmarapɨrɨ,’ meho ra? ");
INSERT INTO agg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Sapo God ai yare hoafɨyuhü, ‘Ranɨmbohündambo anɨmbo nindou ahandɨ hondɨ afɨndambo hɨnɨŋgɨndeapɨrɨ haya ahandɨ nɨmorehɨ ranɨ dɨbo mamɨ tapeimbɨ nɨmbafeihɨ asu yimbu ai moanɨ mamɨ tükündafɨne nɨmboambo-yafe,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Asu ŋgɨrɨ ai yimbundafe, ŋga ai fi mamanafe. Sapo God ai mamambere hɨnɨŋgɨmareandɨ ra asu nindou ai yükürübɨfepoanɨ,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ranɨyomo asu Farisi nindou ai Sisasɨmbo düdururühɨ yahomoya, “Nɨmboe asu nindowenihɨ ranai ahandɨ nɨmorehɨ ranahambo moei-yaho hɨnɨŋgɨfe ranahambo Mosesɨndɨ ahɨnümbɨ hohoanɨmo ranambe yare hoafɨyohüya ‘Se sɨhafɨ nɨmorehɨ hɨnɨŋgarowandɨ ana, ahambo moei yahombo sürü pando dabado,’” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Asu Sisas ai asükaiyu sɨmborɨ ahamumbo hoafɨyuhü yahuya, “Se afɨndafɨndeimbanemo ranɨmboane asu Moses ai sɨhamundɨ nɨmorehɨ hɨnɨŋgɨfembo hohoanɨmo ranahambo moanɨ yare hɨmboana wamarapurɨ. Ŋga asu horombo hondü muŋgu-moatükunɨ God ai nafɨrandambe ana hohoanɨmo yahurai moai yaŋgoro. ");
INSERT INTO agg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Asu ro sɨhamumbo hoafehapurɨ nda, nindou mamɨ ai ahandɨ nɨmorehɨ ra nindowenihɨ ŋgorü-dɨbo hoanepoanɨ, ŋga ai moanɨ hoaŋgɨre haya nɨmorehɨ ranahambo moei yahu hɨnɨŋgɨre haya, asu ai nɨmorehɨ ŋgorü asemündu ana, nindou ranai nɨmorehɨ semɨndɨ hohoanɨmomayo ra moaruwaimbo-reandühani.” ");
INSERT INTO agg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Sisasɨmbo süŋgururü-rundeimbɨ ai ahambo hoafɨyomondowohü yahomoya, “Asu nindowenihɨ nɨmorehühɨfembo hohoanɨmo yahurai rawefeyo ana, asu nindowenihɨ nɨmorehühɨfe-koate ra aboedane,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Asu Sisas ai sɨmborɨ hoafɨyuhü yahuya, “Ndanɨ hoafɨ nda muŋguambo nindou ranahamumbo hoafɨyowohüyopoanɨ, ŋga nindou sapo ahamumbo God ai ranɨ ŋgɨnɨndɨ masagapurɨ ranahamumboane hoafɨ ra. ");
INSERT INTO agg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ŋga ranɨ-poanɨmbo hohoanɨmomboane nindou ai sapo nɨmorehɨ semɨndɨ-koate anɨŋgo ra. Nindou bɨdɨfɨrɨ ra nɨmboe sapo ai moanɨ yahurai nɨŋgombo boagɨrɨ ai masahüpurɨmɨndei, asu nindou bɨdɨfɨrɨ ra nɨmboe nindou ai ahamumbo moanɨ-poanɨmbo mbɨnüŋguwa seihehi tɨmoefɨ kamarɨhorɨ. Asu nindou bɨdɨfɨrɨ ai moanɨ God hɨfandarandɨ ranahambo hohoanɨmombo yaŋgɨrɨwambo ranɨmboane nɨmorehɨ semɨndɨkoateyomo arundɨ. Nindou düdi ndanɨ yamundɨfe hoafɨ ra semɨndɨmboayu ana, ai moanɨ mbɨsemündu-wamboane,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ranɨyei nindou ai Sisas sowana nɨmoakɨdɨbou ra fufurühmündi-hündürɨ tükümehindɨ, ai aheimbo ahandɨ warɨ nandearühɨ dɨdɨbafɨmbɨfindüra sei hehi. Ŋga asu ahambo süŋgururü-rundeimbɨ-memo ranai nindou ranaheimbo ŋgɨnɨndɨmarundürɨ. ");
INSERT INTO agg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ŋga asu Sisas ai hoafɨyuhü yahuya, “Nɨmoakɨdɨbou ra ndühɨ aheimbo hɨnɨŋgɨrɨhindüra wambo sowana mbɨsühüsi, ŋga ŋgɨrɨ güdüwurɨ. Ŋga God ŋgɨnɨndɨ hɨfandarandɨ ra nindou nɨmoakɨdɨbou ndahuraiyei-ane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ranɨyu ai aheiwamɨ warɨ nandeandürɨ mbura asu ndamefiyu. ");
INSERT INTO agg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nindou mamɨ ai mamɨmbo Sisasɨmbo-so tükümefiyu. Ai ahambo düdufi hoafɨyundühɨ yahuya, “Yamundo-randeimbɨ, ro yaŋgɨrɨ koadürümbo nɨŋgombo ra semɨndɨmbo mbɨsambo asu nɨnɨ aboedɨ moatükunɨ ramandɨhea?” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Asu Sisas ai ahambo hoafɨyundühɨ yahuya, “Se ra nɨmboe wambo nɨnɨ-moatükunɨ ai aboedayo ranahambo hoafɨyafühɨ düduwefoandɨr-a? Aboedɨ mamɨ-yaŋgɨrani moanɨ aboedayu. Se gedühɨ aboedɨ yaŋgɨrɨ nɨŋgombo hohoanɨmondafühɨ ana, se moanɨ sapo ahɨnümbɨ hohoanɨmomayo muŋgu ranɨmbo kɨkɨhɨsafɨndandɨfɨ,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Asu nindou-mayu ranai düdufinduhɨ yahuya, “Nɨne ahɨnümbɨ hoafɨ rana?” mehundo-amboyu. Asu Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Se nindou hɨfokoefepoanɨ, se nɨmorehɨ sɨsɨhɨmopoanɨ, se hümbuhünɨpoanɨ, se nindou ŋgorümbo tɨkefehefe papɨ hoafɨpoanɨ, ");
INSERT INTO agg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","se sɨhafɨ meapembo ndondondɨwapɨrühɨ ahafe hoafɨ hɨmborɨndafɨ, se sɨhafɨ wandafɨ mamɨmbo ŋgusüfo pandoworü sɨhafɨ fimbo ŋgusüfo pararowandɨ nou,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Asu nindou hoarɨfɨmayu ranai sɨmborɨ ahambo hoafɨyundühɨ yahuya, “Ro muŋguambo ranɨ ahɨnümbɨ hoafɨ ranahambo hɨmborɨya süŋgurɨheambo-anahɨ. Asu ŋgorü nɨnɨ-moatükunɨ ramandɨhe-a?” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Asu Sisas ai ahambo hoafɨyundühɨ yahuya, “Asu se moanɨ aboedɨ nindou hondü nɨŋgombo mbɨsafombo ana, se ŋgafɨ sɨhafɨ muŋgu-moatükunɨ masɨhoefɨ ra nindou ŋgorümbo fufundawandühɨ ranɨ-fihɨndɨ kakɨ ndowandɨfɨ mbunda, nindou moaruwai napokoate-mayei ranaheimbo kakɨ ra dabadürɨ. Rananɨmbo asu se sünambe napo afɨndeimbɨ-ndamboyafɨ. Ŋga asu se mborai wandɨ süŋgu,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ranɨyu asu nindou hoarɨfɨ-mayu ranai ranɨ hoafɨ ra hɨmborɨyu haya afɨndɨ hohoanɨmo kapeihɨ ndamefiyu sapo ahandɨ napo afɨndɨ ranɨmbo wambo. ");
INSERT INTO agg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ranɨyu asu Sisas ai ahambo süŋgururü-rundeimbɨmbo hoafɨyupurühɨ yahuya, “Ro nda sɨhamumbo anɨhondümboanahɨ hoafehapurɨ, nindou napo afɨndeimbɨ ranai God ŋgɨnɨndɨ hɨfandarandɨ ranambe kefoefembo ana, awi tɨŋümbɨ safane. ");
INSERT INTO agg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Asükai ro sɨhamumbo hoafehapurɨ nda, kemor, adükarɨ nɨnɨhondɨ hos nahurai, ranai ana hoearɨ kakɨmbo nür ambe akɨdou ranɨ nafɨ kefoefembo ana, ahambo tɨŋümb-ane, ŋga nindou napo afɨndeimbɨ ai God ŋgɨnɨndɨ hɨfandarandɨ ranambe kefoefe hɨfombo tɨŋümbɨ safane,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Asu ahambo süŋgururü-rundeimbɨ ai ranɨ hoafɨ ra hɨmborɨyomo houmbo asu ranɨmbo mahepünafundɨ. Ranɨyomo asu ai ahambo düdururühɨ yahomoya, “Asu nindou dɨdɨ ai refe ana, aboedambomandɨfi?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sisas ai ahamumbo hɨmboarɨ pareapurühɨ sɨmborɨ hoafɨyuhü yahuya, “Ndanɨ moatükunɨ ranana nindou ai refembo tɨŋümbɨ safane, ŋga God ai refembo ana, muŋgu-moatükunɨ ra tɨŋümbɨyopoanɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ranɨyu asu Pita ai hoafɨyuhü yahuya, “Awi se ndühɨ hɨmboyafɨ, ro muŋguambo moatükunɨ rarɨhu kokosɨfoarɨhu hohu sɨhafɨ süŋgufemboanefɨ, ŋga nɨnɨ takɨnɨ mandahumɨndefa?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Ro sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ nda, hɨfɨ sɨmborɨ tüküfemboayo ranɨ sihɨ Nindou Hondü ranai sürühoeyoweimbɨ nɨmarɨ fondɨ ranɨwamɨ nɨmanduanɨ, asu wambo süŋgurundɨrɨ-rundeimbɨ se-amboanɨ mamɨ nɨmarɨ fondɨ 12 ranɨwamɨ nɨmandɨmboemo 12 mamɨsɨrɨ Israerɨhündɨ ranaheimbo hɨfandɨyondürɨmbohünda. ");
INSERT INTO agg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Rananɨmbo asu nindou muŋguambo dɨdɨyei ai ahei worɨ, akohoandɨ, rehɨ mamɨ, hondafɨndɨ, nɨmorɨ, asu nümbürɨ ra wambohünda rarɨhi hɨnɨŋgarɨhindɨ ana, asu ai 100 yimbumbondɨhi ndahümündihɨ asu aheimbo yaŋgɨrɨ koadürümbo nɨŋgombo-mayo ra God ai dagadürɨmbui. ");
INSERT INTO agg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ŋga nindou afɨndɨ dɨdɨyei ai haponda adükarɨmbofemboayei ana, süŋgunambo ai akɨdoumbo-ndahimboyei, ŋga asu nindou afɨndɨ dɨdɨyei ai haponda akɨdou-mboehindɨ ana, asu ai süŋgunambo adükarɨmbo-ndahimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sisas ai hoafɨyuhü yahuya, “God ŋgɨnɨndɨ hɨfandarandɨ ranana sapo nindou mamɨ nümbürɨ aharambürɨ nahurai-ane. Ranani asu ai siambe hamɨndɨ hu nindou ahandɨ wofɨ hɨsɨ nümbürɨ ranambe ratüpurɨmbo masepurɨmündu. ");
INSERT INTO agg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nindou ranai ratüpurɨyomo-rundeimbɨ ranɨ-babɨdɨmbo mamamɨ si mamamɨ kakɨ ra ai segopurɨmbo hoafɨ mamühɨru houmbo asu ahamumbo ahandɨ nümbürɨ ranambe ratüpurɨmbo koamarɨhepurɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Asükaiyu ai hüfɨhamɨndɨ ŋgɨnɨndɨyuambe safɨ huane nindou bɨdɨfɨrɨ ai maketambe moanɨ ratüpurɨ-koate burɨmemonda hoeimareapurɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ranɨyu asu ai ahamumbo hoafɨyupurühüya, ‘Seamboanɨ ŋgomo wandɨ wofɨ hɨsɨ nümbürɨ ranambe ratüpurɨndɨmo. Ŋga ro sɨhamumbo kakɨ ndeara segopurɨmbo-mayo ranɨ-sɨmogodühɨ ndahapurɨmboyahɨ,’ mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ranɨyomo asu ai ratüpurɨmbo mahomo. Hüfɨnɨmbo asükaiyu nɨmbambe safɨ ai hu mamɨ ranɨ-süŋgumareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ndeara nɨmbambe hondü hu hoeireapuranɨ nindou bɨdɨfɨrɨ ai moanɨ ratüpurɨ-koate ranühɨ yaru manɨŋgomondamboyu. Ranɨyu asu ai ahamumbo düdureapurühü yahuya, ‘Se ra nɨmboe moanɨ ndanühɨ ratüpurɨ-koate hüfɨhamɨndɨ gebuai afɨndɨ ra manɨŋgomo rana?’ mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Asu ai ahambo hoafɨyomondühɨ yahomoya, ‘Yɨhoefɨmbo nindou ai ratüpurɨ saikoate-memo-ndamboanefɨ anɨmboefɨ,’ mehomondamboyu. Asu ai hoafɨyupurühü yahuya, ‘I refe anasɨ, se-amboanɨ ŋgomo wandɨ nümbürambe ratüpurɨndɨmo,’ mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ndeara bɨdɨfɨrana kɨnɨnɨ hoafambe nümbürɨ aharambürɨ bogorɨ-mayu ranai ahandɨ ratüpurɨyomo-rundeimbɨmbo bogorɨmbofi hɨfandapurɨ randeimbɨ-mayu ranahambo hoafɨyuhü yahuya, ‘Ratüpurɨyomo-rundeimbɨ nindou ranahamumbo mborai mbɨsafɨpurɨ hawa ahamundɨ kakɨ ra dabapurɨ. Nindou bɨdɨfɨranɨ süŋgunambo hondü ratüpurɨ masahapurɨ ranhamundɨ fihɨ pɨndafɨ hawa ŋgafɨ weaŋgurühɨ ratüpurɨmemo ranhamundɨ fihɨ tündowandɨ,’ mehundo. ");
INSERT INTO agg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ranɨyo asu nindou ndeara nɨmbambe hondü peyomo houmbo ratüpurɨmemo ranai kakɨ mamamɨru masowandümo. ");
INSERT INTO agg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ranɨyomo asu nindou weaŋgurühɨ peyomo houmbo ratüpurɨmemo ranai-amboanɨ kakɨ semɨndɨmbo tükümefundɨ. Ndanana ro afɨndɨ safɨ ndahumɨndemboyefɨ yahomo houmbo. Ŋga asu ai-amboanɨ moanɨ mamɨ yahurai kakɨ mamamɨru masowandümo. ");
INSERT INTO agg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ranɨyomo ai kakɨ ra sowandümo houmbo asu ratüpurɨ masagapurɨ nindoumayu ranahambo ‘Kakɨ ranɨmbo nɨmboe ndahurai masawamunɨ,’ yahomo houmbo ŋɨŋepomemo. ");
INSERT INTO agg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ai yahomoya, ‘Nindou süŋgunɨ se ratüpurɨ masagapura moanɨ bodɨfombo yaŋgɨrɨ ratüpurɨmemo-anemo asu se ahamumbo kakɨ ra yɨhoefɨmbo masawamunɨ nahurai masabapurɨ. Roana siambe peyefɨ hohu hüfünɨ gebuai ra ratüpurɨ tɨŋɨrɨfomayefɨ hüfɨhamɨndɨ kɨkɨrɨhundühɨ,’ mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nümbürɨ aharambürɨ ai nindou ŋgorümayu ranahambo sɨmborɨ hoafɨyundühɨ yahuya, ‘Wandafɨ, se hɨmborɨyafɨ, ro sɨhamumbo moai moaruwai dɨbo nɨnüŋgurɨheapurɨ, ŋga wanɨ. Asu sapo sɨhɨrɨ moai mamɨ si ratüpurɨmbo weaŋgurühɨ mamɨ si ratüpurɨyowohü, kakɨ mamamɨfe semɨndɨmbo hoafɨ mamɨ süŋgurɨhundɨyo? ");
INSERT INTO agg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Haponda hamɨndɨ se sɨhafɨ kakɨ ra ndowandɨfɨ hawambo ŋgoafɨnambo ŋgafɨ. Sapo ro kakɨ sɨhamumbo masahapurɨ yahurai nindou süŋgunɨ ratüpurɨmemo ranahamumbo amboanɨ segopurɨmbo saheheamboyahɨ masahapurɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Awi wandɨ kakɨ ra ro hohoanɨmomayahɨ süŋgu refembo ra wanɨmandɨyo? Ranɨ-moatükunɨ ranana ai moanɨ wandɨ moatükunɨ yaŋgɨrane. Ro sapo aboedɨ moatükunɨ ramarɨheanda asu se ranɨmbo wambo garɨbɨrowandɨrühüyafɨ?’ mehu.” ");
INSERT INTO agg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sisas ai ndeara hoafɨ moendɨfembo yahumbo hoafɨyupurühɨ yahuya, “Ŋga nindou dɨdɨyei ai haponda adükarɨmbo-femboayei ana, süŋgunambo ai akɨdoumbo-ndahimboyei, ŋga asu nindou dɨdɨyei ai haponda akɨdoumboehindɨ ana, asu ai süŋgunambo adükarɨmbo-ndahimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Sisas ai Serusaremɨnambo hafuhüyu ai ahandɨ süŋgururü-rundeimbɨ 12 memo ranahamumbo ahamundɨhoarɨ bogo hoafɨyupurühɨ yahuya, “Awi se hɨmborɨyomo. Haponda sɨhɨrɨ nda Serusarem ŋgoafɨnambo hahifühanefɨ, ŋga ranühɨ anɨmbo Nindou Hondü ranai Godɨmbo sɨhou-rundeimbɨ bogorɨ nindou asu ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ nindou ranahamundɨ warühɨndɨfimbui. Rananɨmbo asu ai ahambo yɨfɨmbo papɨhoafɨ-ndürɨmboemo. ");
INSERT INTO agg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Rananɨmbo asu ai ahambo nindou amurɨ ranahei warambe hɨnɨŋgɨndurümboemo. Rananɨmbo asu nindou amurɨ ranai ahambo nindou hɨmboahü tɨkɨfɨnambondɨhorɨ habudihü ahambo ndüfurɨ ndüfurɨboadüwurɨmboemo. Asu ahambo nɨmɨ keimbɨ karɨhendeimbɨfihɨ pandüwurɨmboemo. Ŋga asu randɨfe hayambondoanɨ süŋgunambo ŋgɨmɨ sindu mbunda asükaindu yaŋgɨrɨ botɨndɨfimbui,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ranɨyo asu Sebedindɨ nɨmorehɨ ahandɨ nɨmorɨ yimbu babɨdɨ Sisasɨmbo-so tüküfe ahandɨ haŋgɨfoanɨ peyo yirɨ kakɨre nɨmarɨmbo ai mamɨ-moatükunɨ rambɨreandɨ yaho haya düdumarerɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ranɨyu asu Sisas ai ahambo düdureandühɨ yahuya, “Nɨmorehɨ ra se nɨnɨ-moatükunɨmboyafɨ rana?” mehundo-amboyo. Asu ai ahambo sɨmborɨ hoafɨyondowohü yahoya, “Se wambo randɨheamboyahɨ mbɨsafɨndɨrɨ se bogorɨmbofeyoanɨ asu wandɨ nɨmorɨ yimbu nda sɨhafɨ warɨ-hondünɨ nɨmarɨ, sɨhafɨ kadüdanɨ nɨmarɨ rambohünda,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ranɨyu asu Sisas ai tɨŋɨrɨfo ahambo tüküfemboayo ranɨmbo nɨmorɨ yimbumbo hoafɨyupɨrühɨ yahuya, “Se-ana moai fɨfɨrɨneandɨ se nɨnɨ-mboyafanɨ düduefɨneandɨ ranɨmbo. Se ra ro tɨŋɨrɨfo semɨndɨmboyahɨ ra mandowandɨfanɨyo?” mehupɨramboyafanɨ. Asu ai sɨmborɨ ahambo hoafɨyafɨnandowohü safanɨya, “Yɨnɨ, ro randɨhoamboyehɨsɨ,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sisas ai ahafanɨmbo hoafɨyupɨrühü yahuya, “Yɨnɨ, wandɨ tɨŋɨrɨfo ndowandɨmboyafanɨsɨ. Ŋga asu ro sɨhafanɨmbo hoafɨndahapɨrɨ, düdi wandɨ warɨ-hondünɨ nɨmarɨ asu kadüdanɨ nɨmarɨ rambo ra ŋgɨrɨndahɨ, ŋga wanɨ. Fondɨ ranana wandɨ Ape ai nindoumbo dɨdɨboadoramündɨ hɨnɨŋgɨmareandane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ranɨyomo asu Sisasɨmbo süŋgururü-rundeimbɨ 10 memo ranai ranɨ hoafɨ ra hɨmborɨyomo houmbo asu ai apodoho yimbumefanɨ ahafanɨmbo ŋgɨnɨndɨmarupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ranɨyu asu Sisas ai ahamumbo mamɨ gugureapurɨ mbura hoafɨyupurühɨ yahuya, “Se awi ranahambo fɨfɨrumbo-anemo, ŋgorü sɨrambeahɨndɨ-mayei ranahei bogorɨ nindou ranai ana nindou ranaheimbo ŋgɨnɨndɨ hɨfandɨrundürühanemo. Rananemo asu ahei adükarɨ nindou ranai-amboanɨ ŋgɨnɨndɨ aheimbo hɨfandarundürɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ŋga awi ndahurai hohoanɨmo ndanana sɨhamundɨ mbusümo yaŋgorɨpoanɨ, ŋga wanɨ. Sɨhamundɨ mbusümo nindou mamɨ ai adükarɨmbofe tüküfembo hohoanɨmoayu ana, asu ranai nindou sɨhamundɨ ratüpurɨyu-randeimbɨ nindoumbofi mbünüŋgu-wamboane. ");
INSERT INTO agg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Asu nindou mamɨ ai sɨhamundɨ mbusümo ro horombonɨpoedɨ nindou-anahɨ yahu anüŋgu ana, nindou ranai sɨhamundɨ moanɨ ratüpurɨyu-randeimbɨ nindoumbofi mbünüŋgu-wamboane. ");
INSERT INTO agg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sapo rahurai ane Nindou Hondü aiana hɨfɨnambo makusu ra ahambo nindou ai farɨhefimboyupoanɨ. Ŋga ai nindou afɨndɨ ranaheimbo aboedambo-fendürɨmbo-hündamboyu yɨfɨmbo makusu,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ranɨyomo ai Seriko ŋgoafɨ hɨnɨŋgɨru hou mahomonda, asu nindou afɨndɨ safɨ ranai Sisasɨmbo süŋgumarɨhorɨ hei. ");
INSERT INTO agg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hɨmboatɨharɨ nindou yimbu ranai nafɨkɨmɨ nɨmarɨfanɨ hɨmborɨyafandane, Sisas ai mahuwamboyafanɨ, asu ai hoafɨ puküna karɨhoefɨneandühɨ hoafɨyafandühɨ safanɨya, “Defitɨndɨ ahuirɨ! Adükarɨ, se yɨhoehɨmbo hɨpoambo-rowamunɨ,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nindou afɨndɨ ranai ahafanɨmbo se moanɨ yafambe kɨkɨhandɨfanɨ sei hehi ŋgɨnɨndɨ hoafɨmehüpɨrɨ. Ŋga asu ai moanɨ puküna hamɨndɨ hoafɨ karɨhoefɨ-neandühɨ hoafɨyafandühɨ safanɨya, “Defitɨndɨ ahuirɨ! Adükarɨ, se yɨhoehɨmbo hɨpoamborowamunɨ,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ranɨyu asu Sisas ai ranühɨ ŋgɨnɨnɨmareandɨ. Asu ai ahafanɨmbo düdureapɨrühɨ yahuya, “Ro sɨhafanɨmbo nɨnɨ nünüŋgufepɨrɨmboyahɨ asu se ranɨmbo hohoanɨmoayafana?” mehupɨramboyafanɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Asu ai sɨmborɨ ahambo hoafɨyafɨ-nandowohü safanɨya, “Adükarɨ, se yɨhoehɨ hɨmboarɨ aboedɨ bɨrɨhawamunɨ semboanehɨ hohoanɨmoayehɨ,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ranɨyu asu Sisas ai ahafanɨmbo hɨpoamboreapɨrɨ haya warɨ ahafandɨ hɨmboarambe pamareapɨra moanɨ mamɨ ranɨ-sɨmboanɨ hɨmboarɨ aboedɨ bɨrɨmarɨhoayopɨra hɨmboarɨyafandühɨ, asu ai Sisasɨndɨ süŋgu mahafanɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨ Serusarem ŋgoafɨkɨmɨ akɨmɨ tɨfɨrundühɨyomo asu ai ndeara Betfage ŋgoafambe Orif Nɨmɨ Wafukɨmɨ tükümefundɨ. Ai ranühɨ tüküyafundühɨyomo Sisas ai ahandɨ süŋgunerɨ-rɨnandeimbɨ ranahafanɨmbo hoafɨ ranɨ bɨtapɨre horombo koarɨhepɨrühɨ yahuya, ");
INSERT INTO agg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Ŋgoafɨ akɨmɨ anaŋgo ranɨhünda ŋgafanɨ nɨmehünou hoeindɨneandanɨ doŋgi mamɨ ahandɨ nɨmorɨ ranɨdɨbo wofɨfihɨ kife hɨnɨŋgɨfimbɨ-mayo ra fufurɨndɨ-heneapɨrɨ mbundɨna wambo sowana ndowandɨfanɨ dügüfanɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Asu nindou ŋgorü ai ranahambo nɨnɨ hoafɨ hoafɨnduanɨ ana, asu se hoafɨndafandühɨya, ‘Adükarɨ ai ranahambo hoafɨmayu-amboanehɨ,’ mbɨsafandanɨ anɨmbo asu ai moanɨ rande hɨnɨŋgɨndeandanɨ amboanɨ ndowandɨfanɨ dügüfanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ranɨ-moatükunɨ ranana sapo horombo Godɨndɨ hoafɨ hoafɨyu randeimbɨ ai hoafɨmayu sɨmogodühɨ tüküfemboyo ramefeyo. Sapo ai yare horombo hoafɨyuhüya, ");
INSERT INTO agg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saion nindou ranaheimbo hoafɨndafɨndürühɨ anɨmboya, ‘Awi se ndühɨ hɨmbondei sɨhei adükarɨ bogorɨ nindou ranai sɨheimbo sowana asüfu! Aiana moanɨ hɨmboarɨ hoafendühɨ doŋgi ranɨwamɨ nɨmarü haya asüfu. Asu aiana doŋgi nɨmorɨ mamɨ ranɨwamani nɨmarü haya asüfu,” meho. ");
INSERT INTO agg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ranɨyafanɨ asu ahambo süŋgurɨnerɨ rɨnandeimbɨ ai hafanɨ Sisas ai hoafɨmayupɨrɨ ranɨ-süŋgu ramarɨneandɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ranɨyafanɨ asu ai doŋgi hondɨ nɨmorɨ kameihɨ ra sowapɨndɨfanɨ hüfanɨ ahafandɨ hoearɨ ra ahafewamɨ nandɨne hɨnɨŋgɨmarɨneapɨra asu Sisas ai ranɨwamɨ farɨfi mamaru. ");
INSERT INTO agg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ranɨyei nindou afɨndɨ safɨ ranai ahei warɨ hoandarɨ hoearɨ fufurühümündi nafɨnɨ korɨmarɨhinda asu bɨdɨfɨrɨ ai nɨmɨ warɨ emündɨ kameihɨ hutühümündi nafɨnɨ korɨmarɨhi hei. ");
INSERT INTO agg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nindou afɨndɨ bɨdɨfɨrɨ ranai Sisasɨndɨ haŋgɨfoanɨ kefoehi hehi hei asu bɨdɨfɨrɨ süŋgunɨmayei ranai hoafɨ puküna karɨhehindühɨ hoafɨyeihü seiya, “Defitɨndɨ ahuirɨ, ranahambo hɨhɨfɨ-hɨhɨfɨndahündo! God ai ahambo aboedɨ aboedɨ-mbɨriramboane ai Adükarɨndɨ ndürɨnambo asüfu ranahambo. Godɨndɨ ndürɨ adükarane mbɨsefomboane,” masei. ");
INSERT INTO agg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sisas ai Serusarem ŋgoafambe tükümefiyua asu ŋgoafɨ adükarɨ ranai hepünɨ kɨkɨrandühɨ nindou ranai düduyahindühɨ seiya, “Nindou düdi rana?” masei. ");
INSERT INTO agg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nindou afɨndɨ-mayei ranai hoafɨyeihɨ seiya, “Nindou ndanana Nasaretɨhündɨ Gariri hɨfɨhündɨ Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou Sisas ani,” masei. ");
INSERT INTO agg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sisas ai Godɨndɨ Worɨkɨmɨ hüfu nindou ranühɨ sesɨ napo kakɨfihɨ sɨmborɨ sɨseyei wakɨrɨhindühɨ nɨnoumayei ranaheimbo bukürümafoarearü. Ranɨyu ai kakɨ sɨsefe rambo fondɨyo asu nindou bɨdɨfɨrɨ ai wupufo nɨmarɨmombo sɨseru-rundeimbɨ nɨmarɨ fondɨ ra hɨhɨrɨmafoareapurɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ranɨyu ai hoafɨyundürühü yahuya, “Sapo Baiborambe sürü mapaiaro ra yare hoafɨyohü yahoya, ‘Wandɨ worɨ ranana dɨdɨbafɨfe worane mbɨseimboyei,’ mehu. Ŋga asu se worɨ nda nɨmboe hümbuhünɨ nindouyei dɨbonapɨfe worɨmbo-arɨhinda?” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nindou hɨmboatɨharɨ asu nindou tɨŋarɨ moaruwaimbɨ ranai Godɨndɨ worɨ ranambe tükümehinda Sisas ai aboedɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨyomo asu ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨyomo ranai hoeirundane, Sisas ai hepünɨfeimbɨ moatükunɨ ramareanda asu nɨmoakɨdɨbou ai puküna hoafɨ karɨhehindühɨ Godɨndɨ worɨ ranambe seiya, “Defitɨndɨ ahuirɨ ranahambo hɨhɨfɨ-hɨhɨfɨmboani,” maseiamboemo asu ai ranɨ-moatükunɨ ranahambo ŋgɨnɨndɨmemo. ");
INSERT INTO agg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ranɨyomo asu ai Sisasɨmbo düdururühɨ yahomoya, “Se nɨne-hoafɨ ai hoafayei ra hɨmborɨyafai?” mehomondamboyu. Asu Sisas ai sɨmborɨ ahamumbo hoafɨyuhü yahuya, “Anɨhondane, ro ra hɨmborɨyamboanahɨ. Asu se moai hoafɨ Baiborambe meŋgoro nda hoeirundɨyo? Sapo ai yare hoafɨyowohü yahoya, ‘God, Se nɨmorɨ akɨdɨbou asu akɨdɨbou hondü tɨtɨhündɨ ranahei yafambe boaroworanɨ anɨmbo asu ai Sɨhambo adükarani sei ndorɨhi hoafɨmbeyai-amboane,’ meho ra,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ranɨyu Sisas ai ahamumbo yare hɨnɨŋgɨreapurɨ haya Betani ŋgoafɨna ranühɨ apombo mahu. ");
INSERT INTO agg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Hapoadümbo siambe hondü Sisas ai adükarɨ ŋgoafɨna hɨhɨrɨfi nafɨ huhüyu asu ai wembombomayu. ");
INSERT INTO agg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ranɨyu ai huhünda nafɨkɨmɨ fik nɨmɨndɨ ranai manɨŋgowa hoeire haya ranɨ sowana mahu. Asu moai nɨmɨndɨ ranɨfihɨ fik hɨsɨ ranai kiaro, ŋga moanɨ emündɨ yaŋgɨrɨ manɨŋgowa hoeimareandɨ. Ranɨyu asu ai nɨmɨ ranahambo hoafɨyuhü yahuya, “Nɨmɨ ndanɨmbafɨ ndanɨ se ŋgɨrɨ asükaindafɨ hɨsɨndafɨ,” mehua, asu nɨmɨ ranai moanɨ mamɨharɨ hoafɨ nɨŋgoambe nɨmbɨmayo. ");
INSERT INTO agg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ranɨyomo asu ahambo süŋgururü-rundeimbɨ ranai ai ramareandɨ ranahambo hoeiru houmbo hepünafundühɨ düduyafundühɨ yahomoya, “Nüŋgumareandamboyo fik nɨmɨndɨ ranai moanɨ yahurai nɨmai hamɨndɨ nɨmbɨmayo rana?” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ranɨyu Sisas ai sɨmborɨ ahamumbo hoafɨyupurühɨ yahuya, “Ro sɨhamumbo anɨhondümboanahɨ hoafehapurɨ, asu se anɨhondümbondundühɨ moanɨ yimbu hohoanɨmo-koateayomo ana, seamboanɨ ro nɨmɨ ndanahambo ramarɨheandɨ nou randumboemosɨ. Ŋga se hɨfɨ wafu ndanahambo hoafɨndɨmondühɨya, ‘Se fɨrɨhoefɨ hawa sɨhafɨhoarɨ hanɨfɨ sɨrɨwara hɨmo peyafɨ,’ ehomo ana, ra ai randɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Asu se anɨhondümboru houmbo nɨnɨ-moatükunɨmboyo sɨhamundɨ dɨdɨbafɨfe ra hoafemo ana, asu se ranɨ-moatükunɨ ra ndowandümboemo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sisas ai Godɨndɨ worɨmayo ranambe kefuai hu tüküfi nindou bɨdɨfɨrambo hoafɨ yamundeandürühɨ manɨŋgu. Ranɨyo asu Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨ nindouyomo asu nindouyei bogorɨ nindouyomo ranai ahambo-so tüküyafu düdururühɨ yahomoya, “Nüŋgu-nahurai ŋgɨnɨndɨyo se yahurai nda sowandɨfɨ hawa ndanɨ-moatükunɨ refembo rana? Nindou düdi sɨhambo ŋgɨnɨndɨ yahurai ra masaganɨn-a?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Asu sɨmborɨ Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Ro-amboanɨ sɨhamumbo awi mamɨ düdufe düdundaheapurɨmboyahɨ. Asu se wandɨ düdufe ranahambo hoafɨ weindaharundɨ ana, sɨhamumbo nɨne-ŋgɨnɨndɨ ro sahamɨndɨ hehea ranɨ-moatükunɨ rarɨhe arɨhandɨ ranahambo hoafɨndahapurɨmboyahɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Asu dagüdamboe Son hɨmonɨ nindou hundürɨyo rambo hohoanɨmo masemündu rana? Ranɨ-moatükunɨ ra Godɨndɨ-mayo tüküfemboyo asu nindouyei-mayo tüküfemboyo?” mehupuramboemo. Ranɨyomo asu ai ahamundɨhoarɨ bogo sɨmborɨ hoafɨyomondühɨ yahomoya, “Nɨnɨ hoafɨ sɨhɨrɨ ra hoafɨmandefa? Asu sɨhɨrɨ ahambo hoafɨyahundowohüya, Godɨndɨ-mayo tükümefeyo ane asefɨ ana, asu ai sɨmborɨ sɨhefɨmbo rande hoafɨndümunühɨya, Nɨmboe refe ana, asu se Sonɨmbo anɨhondümbofe-koatememoa? mbüsü düdundüfimunɨmbui. ");
INSERT INTO agg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Asu sɨhɨrɨ rarɨhu hoafɨyefühɨ, Ranɨ-moatükunɨ ra nindou-yafe-mayo tükümefeyo ane, asefɨ ana, asu nindou ranaheimbo yɨhɨmbo-ndɨhurɨmboyefɨ, nɨmboe sapo nindou ranai Sonɨmboya, Aiana Godɨndɨ hoafɨ hoafɨyu randeimbɨ nindoumayu ani aseimbohünda,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ranɨyomo asu ai Sisasɨmbo hoafɨyomondühɨ yahomoya, “Ranɨ-moatükunɨ ra ro moai fɨfɨrɨhundɨ,” mehomondamboyu. Asu ai ahamumbo sɨmborɨ hoafɨyuhü yahuya, “Roamboanɨ ro ŋgɨrɨ sɨhamumbo hoafɨndahapurɨ dagüdamboe ro hohoanɨmo ra sahamɨndɨ hehea ranɨ-moatükunɨ rarɨhe arɨhandɨ ra,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Sisas ai yahuya, “Asu haponda se ra nüŋguru hohoanɨmoyomondühɨyomoa? Mamɨmbo nindou mamɨ ai nindowenihɨ nɨmorɨ yimburapɨrɨ henüŋgumboyu. Ai hu ahandɨ amoŋgo nɨmorɨmayu ranahambo hoafɨyundühɨ yahuya, ‘Wandɨ nɨmorɨ nda, se ŋgafɨ wofɨ hɨsɨ nümbürɨ ranambe ratüpurɨndafɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Asu nɨmorɨ ai yahuya, ‘Ro ratüpurɨmbo moei samboanahɨ,’ mehu, ŋga asu süŋgunambo hohoanɨmoyu hoeireanda mayoa ai ratüpurɨmbo mahu. ");
INSERT INTO agg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ranɨyu asu afɨndɨ ai akɨdambo sowana hu mamɨ hoafɨ yahurai yare hoafɨmayundo. Asu nɨmorɨ ai yahuya, ‘Yɨnɨ Ape, ro ŋgamboyahɨ ranɨ ratüpurɨmbo,’ mehu, ŋga asu süŋgunambo ai moai hu. ");
INSERT INTO agg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nɨmorɨ yimbu ranai nahanɨyu sapo afɨndɨ ai hoafɨmayu süŋgu hɨmborɨyu haya ramareanda?” mehuamboemo. Asu nindou ai hoafɨyomondühɨ yahomoya, “Amoŋgo nɨmorɨ ai,” mehomondamboyu. Sisas ai hoafɨyupurühɨ yahuya, “Ro sɨhamumbo haponda hoafehapurɨ nda, Nindou takis kakɨ sowandümo-rundeimbɨ asu nɨmorehɨ nindowenihɨ bɨrabɨrɨyei rɨhündeimbɨ ranai sɨhamumbo ŋgasündɨhipurɨ hehi ai boatei God ŋgɨnɨndɨ hɨfandarandɨ ranambe karefoehindɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ŋga nɨmboe Son sɨhamumbo sowahɨ tükümefiyu ra ai sɨhamumbo sapo nafɨ aboedɨ süŋgumbeyafunda yahumboyu nafuimayupurɨ. Ŋga asu se moai ahambo anɨhondümborüwurɨ. Ŋga asu nindou takis kakɨ sowandümo-rundeimbɨ-memoyomo, asu nɨmorehɨ nindowenihɨ bɨrabɨrɨyei rɨhündeimbɨ ai yaŋgɨrɨyei ahambo anɨhondümbo-marɨhorɨ. Ranɨ-moatükunɨ ra se hoerundɨsɨ, ŋga asu se moai süŋgunambo yaru nɨŋgomo hohoanɨmoyomondanɨ wanɨ asu ahambo anɨhondümborüwurɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sisas ai hoafɨyuhɨ yahuya, “Awi se ŋgorü kafoefe hoafɨ ranahambo hɨmborɨndɨmo. Mamɨmbo nindou mamɨ hɨfɨ aharambürɨ ai wofɨ hɨsɨ hɨfoare mbura ginɨrɨmayu. Asu nümbürɨ ranambe wofɨ hɨsɨ ra boboeyo-rambohünda hɨpɨrɨ nafɨmarandɨ. Asu nümbürɨ ranambe nɨmoamo hafo gɨgüdɨyo rambohünda yibadɨ ŋgerɨra hafu hɨnɨŋgɨmareandɨ. Ranɨyu asu ai muŋgu-moatükunɨ ra raraore mbura nindou kakɨ semɨndɨmbo ratüpurɨyomo-rundeimbɨ ranahamundɨ warambe hɨnɨŋgɨre haya, ŋgorü hɨfɨna aŋgunɨ mahu. ");
INSERT INTO agg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ndeara wofɨ hɨsɨ ranai süfiyoanɨ nindou ranai ratüpurɨyomo rundeimbɨ ranahamumbo nindou nümbürambe ratüpurɨmemo ranahamumbo sowana koamarɨhepura mahomo wofɨ hɨsɨ ra semɨndɨmbo. ");
INSERT INTO agg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ranɨyomo asu nindou wofɨ hɨsɨ nümbürambe ratüpurɨyomondühɨ manɨŋgomo ranai nindou ahandɨ koamarɨhepura mahomo ranahamumbo mbumarɨpundümo. Ŋgorümbo bubururɨ, ŋgorümbo hɨfokoarüwurɨ asu ŋgorümbo nɨmoeinambo-marurɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ranɨyu asükaiyu nindou ranai ahandɨ ratüpurɨyomo-rundeimbɨ bɨdɨfɨrɨ afɨndɨ safɨ koarɨhepurane, nindou nümbürambe manɨŋgomo-memo ranai ahamumbo mamɨ horombo bɨdɨfɨrambo ramarüpurɨ nou yahurai ramarüpurɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ranɨyu nindou ranai bɨdɨfɨranambo hondü ahandɨ nɨmorɨ ranahambo ahamumbo sowana koamarɨheirü. Ranɨyu ai yare hoafɨyuhü yahuya, ‘Nindou ranai awi wandɨ nɨmorɨ ranahambo ndondüwurühɨ ahandɨ hoafɨ hɨmborɨndɨmboemosɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ŋga asu ai ahandɨ nɨmorɨ ranahambo hoeirüwurühɨ ahamundɨhoarɨ yahomoya, ‘Nɨmorɨ ndanana sapo nümbürɨ aharambürɨndɨ nɨmor-ani. Awi sɨhɨrɨ ahambo haponda hɨfokoandɨhurühɨ anɨmbo asu sɨhɨrɨ ahandɨ-mayo napo ra fufundɨhumündefomboane,’ mehomo. ");
INSERT INTO agg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ranɨyomo asu ai ahambo mburündümo nümbürambeahɨndɨ hɨmboranɨ pirüwurɨ houmbo houmbo hɨfokoamarüwurɨ.” ");
INSERT INTO agg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Sisas ai yare düdufihɨ yahuya, “Asu wofɨ hɨsɨ nümbürɨ aharambürɨ ai asükaindu tükündüfihɨ ra, nindou ahandɨ nümbürɨ hɨfandɨmarundɨ ranahamumbo nüŋgumandeapura?” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Asu ai hoafɨyomondühɨ yahomoya, “Nindou moaruwai ranahamumbo nindou ranai hɨfokoa-ndeapurümbui. Rananɨmbo asu ai nindou bodɨmondambo ahandɨ nümbürɨ ra dagapuranɨ asu ai hɨfandundühɨ wofɨ hɨsɨ süfi-ambe nindou ranai nümbürɨ aharambürɨmbo bɨdɨfɨrɨ dabudomboemo,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ranɨyu asu Sisas ai ahamumbo hoafɨyuhüya, “Awi, se moai hoafɨ Baiborambe apenɨŋgo ra hoeirundɨyo? Hoafɨ ra yare hoafɨyowohüya, ‘Worɨmboru-rundeimbɨ nindou ai worɨmbombo kambohoanɨ moaruwai ra moanɨ yaru moei yahomo masɨhoemo, asu kambohoanɨ ranai moanɨ ndorɨhoeimbɨ hamɨndɨ kambohoanɨmbofe tükümefeyo. Ranɨ-moatükunɨ ra Adükarɨ ai ramareandane, ŋga ranɨ-moatükunɨ ra ro hoeirɨhunda aboedɨ hamɨndane, asefɨ,’ meho. ");
INSERT INTO agg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ranɨmboane asu sɨhamumbo hoafehapurɨ, ‘God ŋgɨnɨndɨ hɨfandarandɨ ranamboanɨ sɨhamumbo saihündɨ-mayo ra ndemündü haya asu nindou dɨdɨyei ai hɨsɨ aboedɨ hɨfandarandambe tüküfembohünda ranaheimbo dagadürɨmbui. ");
INSERT INTO agg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nindou düdi ai kambohoanɨ ranɨwamɨ pɨrayu ana, ai muŋguna hürühümbo yagudümbui. Asu kambohoanɨ ranai nindou ranahandɨ wamɨ pɨrayo ana, ranambo ndünɨnderɨmboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ranɨyomo asu Godɨmbo sesɨ sɨhou-rundeimbɨ nindou bogorɨyomo asu Farisi nindouyomo ranai Sisasɨndɨ kafoefe hoafɨ ranahamboya ‘Yɨhoefomboani yare kafoare hoafayu,’ yahomo fɨfɨrɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ranɨyomo asu ai ahambo mbuimündümbo yahomo houmbo hohoanɨmomemo. Ŋga asu ai nindou afɨndɨ ahambo wakɨrerɨ meŋgoro ranaheimbo yɨhɨmbomarundürɨ, nɨmboe sapo ai Sisasɨmboya, Ai Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindoumbofimboani masei ranɨmbo wambo. ");
INSERT INTO agg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Asu asükai Sisas ai kafoefe hoafɨnambo hoafɨyundürühɨyahuya, “God ŋgɨnɨndɨ hɨfandarandɨ ranana ndahurai-ane. Mamɨmbo adükarɨ bogorɨ nindou ai nɨmorehɨ semɨndɨ sesesɨmbo sesɨ raraore fikɨmɨ-fikɨmɨre masɨhendɨ ahandɨ nindowenihɨ nɨmorɨ ai nɨmorehɨ semɨndɨmbomayua. ");
INSERT INTO agg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ranɨyu ai nɨmarümbo ahandɨ ratüpurɨyomo-rundeimbɨ nindoumbo koamarɨhepurɨ nindou bɨdɨfɨrambo sesesɨ si ranɨfihɨ tükündafundɨ yaho hoafɨyopurɨmbo. Ŋga asu ranɨ-sɨmboanɨ nindou ranai moai tüküfembo hohoanɨmoyomo. ");
INSERT INTO agg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ranɨyu asükaiyu ai ahandɨ ratüpurɨyomo-rundeimbɨ nindou bɨdɨfɨrambo koamarɨhepurɨ. Ai yare hoafɨyuhü yahuya, ‘Wandɨ sesesɨmbo si ranai ndeara nafɨramɨndɨmboane. Burmakau anamɨndɨ asu nɨnɨhondɨ bɨdɨfɨrɨ wowondümbɨ wandɨ hɨfokoaru mandu dɨdɨboadɨru nafɨramɨndɨmboane. Ŋga se dɨfomo nɨmorehɨ semɨndɨmbo sesesɨ ra sesɨmbo,’ yahu hoafɨyu koamarɨhendɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ŋga asu nindou ranai moai ahamundɨ hoafɨ hɨmborɨyomo hou homo, ŋga wanɨ. Ŋga ai ahamundɨ hohoanɨmomemo süŋgu ahamundɨ ratüpurɨmbo bukürɨmefoundɨ. Nindou mamɨ ai ahandɨ nümbürɨnambo-ndefi, mamɨ ai ahandɨ stoa worɨnambofi raraomarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Asu bɨdɨfɨrɨ ai nindou ranahandɨ ratüpurɨyomo-rundeimbɨ ranahamumbo mburüpundümo houmbo bubuhaiyomopurühɨ hɨfokoakomarüpurɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ranɨyu asu bogorɨ nindou-mayu ranai ranɨmbo ŋgusüfoambe moaruwairɨrühɨyu ahandɨ ami ranahamumbo koamarɨhepura ai homo nindou hɨfokoaru rundeimbɨ-memo ranahamumbo hɨfokoako-foarupurühɨ ahamundɨ ŋgoafɨ ra hai kamandu kamandu marundɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ranɨyu asu ai ahandɨ ratüpurɨyomo-rundeimbɨ ranahamumbo hoafɨyuhü yahuya, ‘Wandɨ nɨmorehɨ semɨndɨmbo sesesɨ si ranai ndeara nafɨramɨndɨmboanesɨ, ŋga asu nindou fandɨfembo hoafɨmayahɨ ranai moei mehomo, ŋga ŋgɨrɨ wandɨ worambe dɨfomo. ");
INSERT INTO agg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ŋga haponda se ŋgomo muŋguambo bogorɨ nafɨ ranɨhünda muŋguambo nindou hoeindundühɨ ana, hoafɨndɨmondanɨ nindou afɨndɨ safɨ wandɨ sesesɨmbo si ranühɨ ai mbɨfandund-amboane!’ mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ranɨyomo asu ahandɨ ratüpurɨyomo-rundeimbɨ ranai muŋguambo nafɨ bogorɨ ra homondühɨ muŋguambo nindou hoeirüpurühɨ gugurɨmarundɨ. Nindou bɨdɨfɨrɨ aboedɨ, bɨdɨfɨrɨ moaruwai kapeihɨ, ranai muŋgu fandafandambo nɨmorehɨ semɨndɨ sesesɨmbo fondɨ ra nindou yaŋgɨrɨ güremareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ranɨyu bogorɨ nindou ai nindou mafandandɨ ranaheimbo hɨmboasafɨmbo huwane nindou mamɨ ranai sesesɨmbo hombo hoearɨ yihuruyɨmɨndɨ-koate mamaruwa hoeimarirɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ranɨyu asu bogorɨ nindou ai ahambo düdurirühɨ yahuya, ‘Wandafɨ, se ra nünüŋguyafoamboyafɨ sesesɨmbo sihɨ hombo hoearɨ yihuruyɨmɨndɨ-koate tükümefoandɨ ndana?’ mehundoa asu nindou ranai moanɨ hoafɨ-koate sɨrɨ yare mamaru. ");
INSERT INTO agg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ranɨyu bogorɨ nindou ai ahandɨ ratüpurɨyomo-rundeimbɨ ranahamumbo hoafɨyuhü yahuya, ‘Nindou ranahambo yirɨ warɨ hüputüpundümo houmbo weindanɨ nɨmbɨ nɨmaro-ambe pinduwurɨ. Rananɨmbo ai heindühɨ yahafɨ hɨtɨmbɨrandamboane,’ mehu.” ");
INSERT INTO agg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ndeara Sisas ai hoafɨyuhüya, “Nindou afɨndɨmboyo fandɨfembo hoafɨmayondürɨ, ŋga asu moanɨ yimbu mamɨ yaŋgɨrɨ ranaheimbo dɨbonɨmayondürɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisi nindou ai homo Sisas hoafayu ranahambo nɨnɨ düdufe hoafɨ sɨhɨrɨ hoafɨndefühɨ ranambo yirümondɨhurɨmbo yahomo fɨfɨrɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ranɨyomo ai nindou ahamumbo süŋgurɨpurɨ-rundeimbɨ asu Herotɨndɨ süŋgururü-rundeimbɨ bɨdɨfɨrɨ ranahamumbo Sisas-sowana koamarɨhoupurɨ. Ai homo Sisasɨmbo-so tüküyafu hoafɨyomondohü yahomoya, “Nindou yamundo-randeimbɨ, ro sɨhambo fɨfɨrɨhunɨnɨmboanefɨ se anɨhondümbo hondü hoafɨyafɨ arandɨ ra. Nindou ai nɨne-hohoanɨmo hohoanɨmoayei ranahambo se afɨndɨ hohoanɨmo-koate seana Godɨndɨ anɨhondü hohoanɨmo ranahambo yamundo randühanafɨ. Asu seana sɨhafɨ hɨmboahü muŋgua nindou sɨmogodühanei. ");
INSERT INTO agg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ranana asu se yɨhoefɨmbo hoafɨyafɨmunɨ. Se ra ranɨmbo nüŋguro hohoanɨmoyafühɨyafa? Romɨ-yomondɨ nindou bogorɨ Sisar ranahambo takis kakɨ saimbo ra aboedɨyo wanɨyo?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ŋga asu Sisas ai ahamundɨ nɨne-hoafɨ moaruwai fɨfɨrarundɨ ranɨmbo fɨfɨreandɨ. Ranɨyu asu ai ahamumbo hoafɨyupurühɨ yahuya, “Awi seana nindou yimbu yafambeimbanemo! Se ra nɨmboe wambo ŋgorü-süŋgufendɨrɨmbo yahomo houmboemo rana? ");
INSERT INTO agg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Naha ndühɨ wambo kakɨ hoarɨ takis-ambe sɨhefembo-mayo ra nafui-yomondɨrɨ,” mehuamboemo. Asu ai ahambo kakɨ hoarɨ ra sowandümo homo nafuimemondo. ");
INSERT INTO agg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ranɨyu asu ai ahamumbo hoafɨyuhü yahuya, “Se ra dade ŋgusümboarɨyo asu ndürɨyo kakɨ ndanɨfihɨ apaiaro rana?” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Asu ai ahambo sɨmborɨ yahomoya, “Adükarɨ bogorɨ nindou Sisar ranahandane,” mehomondamboyu. Asu Sisas ai hoafɨyupurühɨ yahuya, “I awi refeanasɨ nɨne-moatükunɨ Sisarɨndayo ahambo sɨhefemboane, asu nɨne-moatükunɨ Godɨndayo ahambo sɨhefemboanesɨ,” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ranɨyomo asu ai ranɨ hoafɨ ra hɨmborɨyomo houmbo hepünafundühɨ ahambo ranühɨ yaru hɨnɨŋgɨrüwurɨ houmbo ndamefundɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mamɨ ranɨ sihɨ Sadyusi nindou bɨdɨfɨrɨ ai Sisas sowana tükümefundɨ. Ranɨ nindou ai-ana ŋgɨrɨ nindou yɨfɨhündɨ botɨndɨfe-ndandɨ yahomo rundeimbɨ nindouyomo. ");
INSERT INTO agg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ranɨyomo asu ai Sisasɨmbo düdurüwurühɨ yahomoya, “Nindou yamundo-randeimbɨ, Moses ai yare hoafɨyuhü yahuya, ‘Nindou mamɨ ai nɨmorɨ-koate yɨfɨnduanɨ ana, asu ahandɨ akɨdɨ ai ahandɨ-mayo nɨmorehɨ kai ra ndemündɨ haya yɨfɨmayu ranahandɨ fondühɨ farɨhefembo-hünda ahandɨ nɨmorɨ ra amoŋgoandɨ nɨmorɨ-mbiyuwamboane,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Horombo yɨhoefɨ mbusümo apodoho mamɨ 7 ranai manɨŋgomo. Amoŋgo hondü ai nɨmorehɨ ra semündü haya nɨmorɨ mbuimɨndɨ-koate yɨfɨyuhüyu asu ai nɨmorehɨ ahandɨ ra ranɨkɨmɨ akɨdɨmayu ranahambo hɨnɨŋgɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ranɨkɨmɨ akɨdɨmayu amboanɨ yahurai amoŋgo hondü ai ramefiyu nou ramefiyu. Ranɨyu asu ai ranɨkɨmɨ akɨdɨ ŋgorü mbusümondɨ amboanɨ ŋgorü yahurai ramefiyu. Moanɨ mamɨ yahurai yaŋgɨrɨ homo-homombo bɨdɨfɨranɨ akɨdɨ hondü 7-mayu ranahandɨfihɨ tümareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ndeara bɨdɨfɨranambo hondü nɨmorehɨ ranai yɨfɨmayo. ");
INSERT INTO agg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ŋga asu süŋgunambo nindou yɨfɨhündɨ yaŋgɨrɨ botɨfembo si tüküfeambe ra nɨmorehɨ ranai nindou dadɨ nɨmorehɨmanda? Apodoho-mamɨ ranai sapo ahambo muŋguambo masowandümo anesɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Asu Sisas ai ahamumbo sɨmborɨ hoafɨyuhü yahuya, “Awi seana hɨhɨndɨ hohoanɨmombü nindou-anemo! Awi seana nɨmboe sapo Baiborambeahɨndɨ hoafɨyo asu Godɨndɨ ŋgɨnɨndɨyo ra fɨfɨrɨfekoate-wambo ranɨmboanemo. ");
INSERT INTO agg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nindou yɨfɨhündɨ botehindɨ ana, ai sapo sünambeahɨndɨ nendɨ sünambe amarɨmo yahurai tükündahindühɨ anɨmbo asu ai ŋgɨrɨ nɨmorehɨ nindowenihühɨ ndahindɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Asu sapo nindou ai yɨfɨhündɨ botɨfe ranɨmbo ra, awi se moai God ai Bukambe sɨheimbo hoafɨmayundürɨ ra hoeirɨhindɨyo? ");
INSERT INTO agg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Sapo ai yare hoafɨyuhü yahuya, ‘Ro-ana Abrahamɨndɨ God-anahɨ, Aisakɨndɨ God-anahɨ, asu Sekopɨndɨ God-anahɨ!’ mehu. Aiana yaŋgɨrɨ nüŋgumbɨ nindou-yafe God-ani asu ai yɨfɨhündɨ-yafe Godɨyupoanɨ,” Sisas ra mehu. ");
INSERT INTO agg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nindou afɨndɨ ranai ranɨ hoafɨ ra hɨmborɨyei hehi Sisasɨndɨ yamundɨfe hoafɨ ranɨmbo mahepünahindɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ranɨ hoafɨnambo Sisas ai Sadyusi nindou ahamundɨ hoafɨ kɨkɨmareapurɨ. Ranɨyomo asu Farisi nindou ai ranɨ hoafɨ ranahambo hɨmborɨyomo houmbo ai mamühɨ gugurɨmefundɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ranɨyu asu nindou mamɨ ahamundɨ mbusümo ahɨnümbɨ hohoanɨmo fɨfɨreandeimbɨ ranai mamɨ düdufe Sisasɨmbo randɨhinɨ hoeindɨhinɨ yahu-haya düdumarirɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ai ahambo düdurirühɨ yahuya, “Yamundo-randeimbɨ nindou, naha ahɨnümbɨ hoafɨ ranaiyo moanɨ adükarɨ hamɨndayo?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Asu Sisas ai sɨmborɨ ahambo hoafɨyundühɨ yahuya, “‘Adükarɨ sapo sɨhafɨ God ranahambo, sɨhafɨ ŋgusüfo muŋguambo, sɨhafɨ hohoanɨmo muŋguambo, yifiafɨ muŋguambo ranambo ŋgusüfo pandoworɨ.’ ");
INSERT INTO agg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ranɨ ahɨnümbɨ hohoanɨmo ranane ai weaŋgurühɨdɨdɨ asu moanɨ adükarɨ hamɨndayo. ");
INSERT INTO agg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Asu ŋgorü ahɨnümbɨ hoafɨ adükarɨ ranɨ-kɨmɨnɨndɨ ra ndahurai-ane, ‘Se ŋgunindambürɨ ranaheimbo ŋgusüfo pandowandürɨ sapo se sɨhafɨ fimbo rawarowandɨ nou.’ ");
INSERT INTO agg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosesɨndɨ muŋguambo ahɨnümbɨ hohoanɨmo aho ranane asu Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ nindou-yomondɨ yamundɨfe hohoanɨmo ranane muŋguambo ranana yimbu adükarɨ ahɨnümbɨ hoafɨ ra nɨmɨndühane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi nindou ai gugurɨyafu mamarɨmonda Sisas ai ahamumbo düdufipurühɨ yahuya, ");
INSERT INTO agg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Se ra Kraisɨmbo nüŋguru hohoanɨmoyomondühɨyomoa? Ai ra dadɨ amoao mamɨyomondambe-ahɨndɨyua?” mehuamboemo. Asu ai sɨmborɨ hoafɨyomondühɨ yahomoya, “Ai-ana Defitɨndɨ amoao-ambeahɨndani,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Asu ai ahamumbo düdureapurühɨ yahuya, “Asu nünüŋgufemboyo Yifiafɨ Aboedɨ ranai Defitɨmbo hohoanɨmo ŋgusüfoambe horɨmarera asu ai Krais ranahambo Adükar-ani mehundoa? Defit ai yare hoafɨyuhü yahuya, ");
INSERT INTO agg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Adükarɨ Ai wandɨ Adükarɨmbo yare hoafɨyuhü yahuya, “Wandɨ warɨ hondünɨ ndanühɨ ndando nɨmandɨfɨ ŋgafɨmbo asu süŋguna sɨhambo hürütümbɨ nindou sɨhafɨ yirümbo hoarehɨ hɨnɨŋgɨndɨheamboyahɨ,” ’ Defit ra-mehu. ");
INSERT INTO agg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Defit ai Krais ahambo Adükarɨ yahundo marandane. Asu nüŋgufimboyu Krais Ai Defitɨndɨ ahuirayu rana?” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Asu nindou mamɨ ai-amboanɨ moai Sisasɨndɨ düdufe hoafɨ ranɨmbo sɨmborɨ hoafɨyundo, ŋga wanɨ. Ranɨyomo asu ai rɨhünda peyomo houmbo ahambo düdufembo ahɨnɨrurühɨ asu ai moai ahambo mamɨ düdufe amboanɨ düduyafundo rundɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ranɨyu asu Sisas ai nindou afɨndɨ ahambo wakɨrerɨ meŋgoro ranaiyei asu ahambo süŋgururü-rundeimbɨ-memo ranaiyomo aheimbo wataporɨmbomarandürɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ai yare hoafɨyundürühü yahuya, “Ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ asu Farisi nindou-anemo ai sɨheimbo yamundɨfembo Mosesɨndɨ fondɨ kosɨründümo houmbo anɨŋgomo. ");
INSERT INTO agg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ranɨmbohündambo anɨmbo asu se hɨmborɨndei süŋgundhindɨ nɨnɨ-moatükunɨmboyo ai se rarɨhi yahomo houmbo hoafemondürɨ ranɨmbo. Ŋga asu se nɨne-moatükunɨ ai rawarundɨ rasüŋgu randɨhimboyei, ŋga wanɨ. Aiana hoafɨ yaŋgɨrane ai rarɨhi rarɨhi-emo, ŋga asu ai ahamundɨhoarɨ refembo ana, ŋgɨrɨ randundɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ahamundɨ ahɨnümbɨ yamundɨfe hoafɨ ra tɨŋümbɨ moatükunane. Ai-ana nindou amurɨyei daboahamɨndɨwamɨ nɨmboreimbɨ moatükunɨ ai mbɨsahümündia yahomo houmbo hüputüpuründümo nandundühanemo. Asu aiana ahamundɨhoarɨ ŋgɨrɨ akɨdou amboanɨ nɨmboreimbɨ moatükunɨ ai manandundɨ ranahambo semɨndɨmbo moai farɨhouwurɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nindou ai yɨhoefɨmbo hoeimbɨrɨhimunɨ yahomondühanemo ai nindou hɨmboahü muŋgu-moatükunɨ ra yaru arundɨ. Ai dɨdɨbafɨfe wadagɨ adükarɨ güdu mburu yihururündümo arundɨ. Asu ai ahamundɨ hoearɨ ranɨ hɨmborɨfihɨ moanɨ ranɨ-poanɨmbo yihuru yihurumarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aiana nɨmarɨfondɨ aboedühɨ nɨmarɨmboane hohoanɨmoyomo arundɨ afɨndɨ sesesɨmbo si sɨmboanane asu Suda-yafe rotu worɨ ranambe dɨrɨdühɨ nɨmarɨmbo-anemo hohoanɨmoemo. ");
INSERT INTO agg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aiana nindou ai ahamumbo nindou afɨndɨ fandɨfeambe yɨhoefɨmbo hɨhɨfɨmbɨrɨhümunɨ, yahomo asu yɨhoefɨmbo yamundu-rundeimbɨ nindou-anemo mbɨsahümunɨ mbɨrɨhündɨ, yahomombo-anemo hohoanɨmoyomo arundɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nindou ai sɨheimbo yowanɨ yamunde-randeimbɨ nindou mbɨsahɨndürɨmboyei, ŋga wanɨ. Seana moanɨ mamɨ apodoho apodoho mamɨ yaŋgɨranei, ŋga sɨhei Yamunde-randeimbɨ Nindou aiana moanɨ mamɨ ai yaŋgɨrani anüŋgu. ");
INSERT INTO agg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Asu se nindou mamɨ hɨfɨ ndanühɨnda ranahambo ahɨnɨndɨhorühɨ hoafɨndeihɨya ‘Ape’ mbɨseimboyei, nɨmboe sapo sɨhei Ape mamɨ yaŋgɨrani sünambe amaru. ");
INSERT INTO agg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Asu nindou ŋgorü sɨheimbo hoafɨndeihɨya ‘Yamundo-randeimbɨ’ mbɨseimboyei, nɨmboe sapo sɨhei yamunde-randeimbɨ Krais yaŋgɨrani. ");
INSERT INTO agg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nindou düdi ai sɨhei mbusümo nindou adükarɨ hamɨndɨ anüŋgu ana, asu ai sɨhei ratüpurɨyu-randeimbɨ nindoumbofi mbünüŋguwamboane. ");
INSERT INTO agg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nindou düdi ai ahandɨhoarɨ nindou adükaranahɨ ehu ana, ahandɨ ndürɨ hɨfɨnambo gadɨmboe. Ŋga asu nindou düdi ai ahandɨhoarɨ hɨfɨnamboareandɨ ranai ana ahandɨ ndürɨ adükarɨndɨmboe.” ");
INSERT INTO agg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ nindou-anemo asu Farisi nindou-anemo, hɨpoanɨmboembou-anemo. Awi seana yafambe yimbumbɨyomo houmbo-anemo! Seana nindouyei ŋgusümboarühɨ God ŋgɨnɨndɨ hɨfandarandɨ ranahambo yipurɨ papɨru hɨnɨŋgɨru arundɨ. Asu se sɨhamundɨhoarɨ amboanɨ moai ranambe kefoau homo-rundɨ. Asu asükai se moai nindou dɨdɨyei ai ranambe kefoefembo yifɨrayei ranaheimbo hɨnɨŋgɨwura kefoehi hüsi, ŋga nafɨ gürarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ nindou-anemo asu Farisi nindou-anemo, se hɨpoanɨmboembou anemo. Awi seana yafambe yimbumbɨyomo houmbo-anemo! Seana sapo nɨmorehɨ kai anɨmboei ranaheimbo wosɨhoaforɨ hoafɨyomo-ndündürühanemo asu se ahei worɨ kosaründɨmo. Rananemo asu se nindou ai hoembɨrɨhimuna yahomo houmbo Godɨmbo moanɨ gedühɨ dɨdɨbafɨyomondühɨ homo arundɨ. Ranɨnɨmbohündambo anɨmbo süŋgunambo sɨhamundɨ tɨŋɨrɨfo ra moaruwai hamɨndɨ tükündɨfepurɨmboe! ");
INSERT INTO agg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ nindou-anemo asu Farisi nindou-anemo se boboharɨndümo! Awi seana yafambe yimbumbɨyomo houmbo-anemo! Seana botɨwamɨ hoe haŋgɨfo-süŋgu homo arundane asu hɨfɨ-süŋgu homo arundane ra nindou mamɨ sɨhamundɨ süŋgurapurɨ randeimbɨ tükɨfe nɨŋgombo kokombohündambo-anemo. Nindou ranai sɨhamundɨ süŋgurapurɨ-randeimbɨ nindou tüküfiyuwanane asu randüwuranɨ ai haiambe nafɨ gadümbui sapo se-amboanɨ rawefundɨ nou. Ranani nindou ranai se rarundanɨ ahandɨ moaruwai hohoanɨmo sɨhamundɨ moaruwai hohoanɨmo ranahambo ŋgasündearandɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nindou hɨmboatɨharɨ nindou amurambo nafɨ nafuimbo-memo, se hɨpoanɨmboembou-anemo! Seana nindou yamundundühɨya, Nindou düdi ai nɨnɨmboyu dabarɨfihɨ Godɨndɨ worɨ ranahambo dükare ranɨfihɨ dabarefiyu ana, ra moanane. Ŋga asu nindou düdi ai gor Godɨndɨ worɨ ranambe eŋgoro ranɨfihɨ dükare dabarefiyu ana, asu ai ranɨ-moatükunɨ refembomayu ra anɨhondümbo rambɨreandamboane yahomo arundɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Seana hɨmboatɨharɨ hohoanɨmo-koate nindou-anemo! Nɨnɨ-moatükunɨyo ai moanɨ ahɨnümbɨ moatükun-ayo, gor ranaiyo asu Godɨndɨ worɨ ranɨyo? Gor ai Godɨndɨ worambe yaŋgoromboane asu Godɨndɨ moatükunɨ hondü nahurai tükefeyo. ");
INSERT INTO agg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Asu asükai seana yamundundühɨya, Nindou düdi ai sesɨ sɨhefe hasɨhonɨ ranahambo dükare ranɨfihɨ dabarefiyu ana, ra moanane. Ŋga asu nindou düdi ai sapo sesɨ sɨhefe hasɨhonɨ ranɨwamɨ sesɨ asɨhefeyo ranahambo dükare ranɨfihɨ dabarefiyu ana, asu ai ranɨ-moatükunɨ refembomayu ra anɨhondümbo rambɨreandamboane yahomo arundɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Awi seana nindou hɨmboatɨharanemo! Nɨnɨ-moatükunɨyo ai moanɨ ahɨnümbɨ moatükunayo, sesɨ asɨhefeyo ranaiyo asu sesɨ sɨhefe hasɨhonɨ ranɨyo? Sesɨ, sesɨ sɨhefe hasɨhonɨ ranɨwamɨ yaŋgoromboane asu sesɨ ra Godɨndɨ yaŋgɨrɨ tükefeyo. ");
INSERT INTO agg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ranɨmboane asu nindou düdi ai sesɨ sɨhefe hasɨhonɨ ranahambo dükare dabarefiyu ana, muŋgu moatükunɨ ranɨwamɨ eŋgoro ranahambo kameihɨ ranɨfihɨ dabarɨfihani. ");
INSERT INTO agg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Asu nindou düdi ai Godɨndɨ worɨ ranahambo dükare ranɨfihɨ dabarefiyu ana, asu God ai worɨ ranambe anüŋgu ranɨfihɨ kameihɨ dabarɨfihani. ");
INSERT INTO agg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Asu nindou düdi ai sünü ranahambo dükare ranɨfihɨ dabarefiyu ana, asu ai sapo Godɨndɨ nɨmarɨ hɨfandɨmbo fondɨ asu ai mare fondɨ ranɨwamɨ amaru ranahandɨ-ihɨ kameihü dabarɨfihani. ");
INSERT INTO agg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ nindou-anemo asu Farisi nindou-anemo, se hɨpoanɨmboembou-anemo! Awi seana yafambe yimbumbanemo! Se-ana muŋguambo akɨdɨbou sesambefembo moatükunɨ wambɨfɨ nahurai ranane se yimuŋguründümo mburu asu 10 ranahandɨ ŋgorü bɨdɨfɨrɨ ra Godɨmbo yɨboboru asɨhoemo. Ŋga asu seana adükarɨ ahɨnümbɨ hoafɨ bɨdɨfɨrɨ ranahambo ana se hɨnɨŋgɨrumbo-anemo. Sapo ranɨ-moatükunɨ hoafɨ ranana ini ra, nindou muŋguambo ranaheimbo mamɨ sɨmogodɨ hohoanɨmombo hohoanɨmo, nindou ŋgorümbo hɨpoambo hohoanɨmo, asu anɨhondümbofe hohoanɨmo ranane. Godɨmbo nɨnɨ-moatükunɨyo 10 ranahanda mamɨ bɨdɨfɨrɨ yɨbobofe sɨhefe ahɨnümbɨ hoafɨ ra se hɨnɨŋgɨndumboemo, ŋga adükarɨ moatükunɨ hohoanɨmo hoafɨmayahɨ ranamboanɨ se süŋgundu ndundɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Seana hɨmboatɨharɨyo hefe nindou ŋgorümbo nafɨ nafuimbo nindou-anemo! Seana hɨmboafɨfɨ ranahamumbo sɨmɨndɨ hoe ranambe foerɨmonda hürühoupurühanemo, ŋga asu kamer nɨnɨhondɨ adükarɨ ra kameihüru sɨrɨfoarundühanemo! ");
INSERT INTO agg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ nindou-anemo asu Farisi nindou-anemo, se hɨpoanɨmboembou-anemo! Awi seana yafambe yimbumbanemo! Se-ana sesɨ hɨpɨrɨ napo ra hɨmboranɨ moanambühɨ ranane popoaiarɨhoemo, ŋga asu wagabe ragu ana hümbuhünɨ hohoanɨmo asu moanɨ sɨhamundɨ fi ranahambo hohoanɨmo ranɨmboane foafusafu hɨnɨŋgɨrundanɨ tüküra piareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi nindou seana hɨmboatɨharɨ nindouanemo! Awi se hɨpɨrɨ ranambe ra, wagabe ragu ranɨ boatei popoaindɨhoemondanɨ anɨmbo asu hɨmboranɨ moanambühɨ ranamboanɨ kameihɨ aboedɨ hɨmbondɨmboe! ");
INSERT INTO agg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ nindou-anemo asu Farisi nindou-anemo, se hɨpoanɨmboembou-anemo! Awi seana yafambe yimbumbanemo! Se-ana yɨfambe ranahambo yihuruyo hɨnɨŋgɨfeyoanɨ anɨŋgo yahurai-anemo! Ranane sapo yɨfambe ranai moanambühɨ hɨmboranɨ ranai aboedɨ hɨmboyo haya anɨŋgo, ŋga asu ragu wagabe ranana yɨfɨ hambohamɨndɨ fɨsɨŋarümbɨ moaruwai ranai mamɨkarɨyombo foerɨmboane. Se sɨhamundɨ fiambe ragu ra moanɨ yahurai hamɨndanemo! ");
INSERT INTO agg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yahurai-anemo se-amboanɨ fi moanambühɨ nindouyei hɨmboahü mbumundɨ nindou hɨmboemo, ŋga asu sɨhamundɨ fiambe ragu ranana yafambe yimbumbɨ hohoanɨmo asu moaruwai hohoanɨmo ranambo güre pireapurɨmboane. ");
INSERT INTO agg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ nindou-anemo asu Farisi nindou-anemo, se hɨpoanɨmboembou-anemo! Awi se-ana yafambe yimbumbanemo! Se-ana Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ ranahamundɨ yɨfambe nafɨru arundɨ. Asu nindou aboedɨ mbumundɨ manɨmboei-mayei ahei yɨfambe-wamɨ se yihururu hɨnɨŋgɨru arundɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Asu rananemo se yaru hoafɨyomondühɨya, ‘Ro horombo sɨhefɨ amoao mamɨ manɨŋgomo ranambe mbanɨmboefɨ-mbonana ŋgɨrɨ ro Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ nindou ranahamumbo hɨfokoefembo farɨhehupurɨ.’ ");
INSERT INTO agg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Asu se ranɨ hoafɨ yaru hoafemo ranana asu se maru sapo nindou dɨdemo Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨmbo hɨfokoamarüpurɨ ranahamumbo nahurai-anemo weindahɨ nafuiayomo. ");
INSERT INTO agg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Refe ana, awi koe se nɨne-moatükunɨ sɨhamundɨ amoao mamɨ ai ramarundɨ ranɨfih randu ŋgomo nafɨndundümo! ");
INSERT INTO agg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Awi seana amoasɨranemo! Seana moaruwai amoasɨrɨndɨ nɨmorɨ hondanemo! God ai sɨhamumbo papɨfe hoafɨnduanɨ se haiambe gadɨmboemo. Nüŋgundu se ranahambo mafebou-a? ");
INSERT INTO agg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ranɨmboane asu se hɨmborɨndɨmo nda. Ro sɨhamumbo sowana Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ nindou, fɨfɨrundeimbɨ nindou asu yamundu-rundeimbɨ nindou ranahamumbo koandɨheheapurɨmboyahɨ. Rananɨmbo asu se bɨdɨfɨrɨ hɨfokoandupurɨmboemo, bɨdɨfɨrambo nɨmɨfihɨ hɨfokoefembohünda pandupurɨmboemo, bɨdɨfɨrambo Godɨndɨ worambe bubundüpurɨmboemo. Asu bɨdɨfɨrambo ŋgorü ŋgoafɨhündɨ heboadüpurɨ houmbo wandüpurɨ ŋgomo ŋgorü ŋgoafɨhü tükündafundɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ranɨmboane asu nindou mbumundɨ hɨfɨ ndanühɨ manɨmboei ranaheimbo hɨfokoamarundüra yɨfɨmayei, ranɨ muŋgu moatükunɨ ranahambo se hütiyomo. Sɨhamundɨ hüti süŋguyo sapo nindou ai mbumundɨ hohoanɨmo süŋgurɨhindeimbɨ Eberɨndɨ sɨrambeahɨndɨ peyo haya ho hombo Sekaraia sapo Berekiandɨ nɨmorɨmayu ranahandɨfihɨ tümareandɨ ranahambo hɨfokoamarüwurɨ. Se Godɨndɨ worɨ asu sesɨ sɨhefembo fondɨ mbusümo ranambeyo hɨfokoamarüwurɨ. Ranɨmbohündambo anɨmbo sɨhamundɨ-wamɨ tɨŋɨrɨfo ranai naŋgopurɨmboe. ");
INSERT INTO agg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ro sɨhamumbo anɨhondümboanahɨ hoafehapurɨ nda. Nindou hɨfokoaru marundɨ ranahambohünda tɨŋɨrɨfo afɨndanɨmbo God ai nindou haponda anɨmboei aheiwamɨ nandeandürümbui.” ");
INSERT INTO agg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Serusaremɨhündɨ, Serusaremɨhündɨ, se Godɨndɨ hoafɨ hoafɨyomo rundeimbɨ nindou ranahamumbo hɨfokoarɨhipurühɨ asu se Godɨndɨ hoafɨ semɨndɨ hombo nindou sɨheimbo sowana koamarɨhepurɨ ranahamumbo hɨfokoefepurɨmbo safombo nɨmoeinambo-rɨhüpurɨ marɨhündɨ! Ro sɨhafɨ mbusümo nindou anɨmboei ranaheimbo wagɨdemɨndɨndürühɨ warɨ gabudɨfoefendürɨmbo afɨndɨ hohoanɨmomayahɨ kakaroko hondɨ ai ahandɨ weihoandɨ mbanendɨ hoareharamɨndɨndürɨ nou. Ŋga asu se wambo moai refembo raro-safɨndɨrɨ, ŋga moei masafɨ. ");
INSERT INTO agg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Asu se hɨmborɨndei. God ai Ahandɨ worɨ sɨhei mbusümo hɨnɨŋgɨmareandɨ asu moanɨ fondarɨmboe. ");
INSERT INTO agg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ro nda sɨheimbo hoafehandürɨ, hapondanambe ana se ŋgɨrɨ asükai wambo hoeindɨhindɨrɨ, ŋga ŋgo ŋgombo süŋgunambo anɨmbo se randɨhi hoafɨndeihɨya, ‘God, Se nindou ai Adükarɨndɨ ndürɨna tükefiyu ranahambo aboedɨ aboedɨndɨworɨ,’ mbɨseimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sisas ai Godɨndɨ worɨ ranambeahɨndɨ tüküfi haya huwane asu ahambo süŋgururü-rundeimbɨ ai ahambo sowana mahomo Godɨndɨ worɨ worɨmbomarundɨ ra nafuiyondowohü hoafɨyondombohünda. ");
INSERT INTO agg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ranɨyu asu Sisas ai ahamumbo hoafɨyuhü yahuya, “Yɨnɨ, ro anɨhondümbo-anahɨ nda hoafehapurɨ. Se haponda muŋguambo moatükunɨ ra hoeirundai? Ŋgɨrɨ nɨmoei nda süŋgunambo ana rande atüboakɨ-atüboakɨndo gafuwanɨ hoeindundɨ, ŋga muŋguambo nɨmoei ra hɨfɨnɨ pindɨhimboyei,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Sisas ai Orif Nɨmɨ Hɨfɨ Wafuambe nɨmaru ane asu ahambo süŋgururü-rundeimbɨ ai yaŋgɨrɨ hafomo ahambo-so tükümefundɨ. Ranɨyomo asu ai düduyafu hoafɨyomondühɨ yahomoya, “Se yɨhoefɨmbo hoafɨyafɨmunɨ nüŋgu-sɨmboanɨ ranɨ-moatükunɨ ra tükümandɨfe? Asu nɨnɨ-moatükunɨ boatei tükündɨfeyoanɨ hoeimandɨhu sapo se kosɨmboayafɨ ranane asu ndeara bɨdɨfɨranambo si tüküfemboayo ranane ranahambo fɨfɨrɨndɨhumboyefɨ?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ranɨyu asu Sisas ai sɨmborɨ hoafɨyuhü yahuya, “Awi se hɨbadümbo nindou ai sɨhamumbo wosɨhoaforɨ hoafɨndeimboyei. ");
INSERT INTO agg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ŋga nindou afɨndɨ ai tükündafu wandɨ ndürɨ dükandu hoafɨndɨmondühɨ anɨmboya, ‘Ro nda Krais-anahɨ!’ mbɨsɨmondühɨ anɨmbo ai nindou afɨndɨ ranaheimbo wosɨhoaforɨ hoafɨndɨmondanɨ ai anɨhondümbondɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Se yifiarɨ hoafɨ asu yifiarɨ yafui hoafɨ hɨmborɨndɨmboemo. Ŋga asu se ranɨ-moatükunɨ ranahambo hɨbadümbo, ŋga hepünündafumboemo ranɨmbo. Ranɨ-moatükunɨ ra tükündɨfemboesɨ, ŋga asu ranɨ-moatükunɨ tükefeyo ranahambo ndeara bɨdɨfɨranambo si ane yahopoanɨ, ŋga awi wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hɨfɨ hɨfɨ ranai sɨmborɨ yifiarɨndɨmboe. Asu adükarɨ bogorɨ nindou mamɨ ahandɨ nendɨ ranai ŋgorü adükarɨ bogorɨ nindoundɨ nendɨ ranɨ-babɨdɨ sɨmborɨ-sɨmborɨndɨmboemo. Hɨfɨ bɨdɨfɨrɨ ranɨfihɨ sesɨ ai wanɨndohü asu hɨfɨhe ranai tükündɨfendamboe. ");
INSERT INTO agg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Muŋguambo moatükunɨ ra tükefeyo ranana moanɨ nɨmorehɨ ai nɨmorɨ wakemɨndɨmbo asübusɨ boatei asemɨndo yahurai boatei-ane tükefeyo. ");
INSERT INTO agg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Rananɨmbo sɨheimbo mbundüründümo tɨŋɨrɨfombɨ moatükunambe sɨndundürühɨ hɨfokoandundürɨmboemo. Rananɨmbo muŋguambo hɨfɨndɨ nindou ai wandɨ süŋguna sɨhamumbo yɨboarukondühüpurɨmboyei. ");
INSERT INTO agg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ranɨ-sɨmboanɨ nindou afɨndɨ ranai ahei anɨhondümbofe hohoanɨmo ra hɨnɨŋgɨndɨhindühɨ, asu ai ahei ŋgunindɨ ranaheimbo nindou amurɨ hürütümbɨ nindouyei warühɨndɨhindürühɨ asu aheihoarɨ amboanɨ sɨmborɨ yiboarukofirɨndeimboyei. ");
INSERT INTO agg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Rananɨmbo asu Godɨndɨ tɨkai hoafɨ hoafɨyomo-rundeimbɨ nindou afɨndɨ ranai tükündafundühɨ anɨmbo asu ai nindou afɨndɨ ranaheimbo wosɨhoaforɨ hoafɨndɨmondanɨ anɨhondümbondɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ranɨfihɨ anɨmbo asu sapo moaruwai hohoanɨmo ranai afɨndɨ tükündɨfeyohü nindou ŋgorümbo hɨpoambofeihɨ ŋgusüfo pefe hohoanɨmo ranai akɨdoundɨmboe. ");
INSERT INTO agg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ŋga asu nindou düdi ai nɨnɨ-moatükunɨ ahambo tükefeyo ranahambo moanane yahu kɨkɨhɨramündɨ anüŋgu ai ŋgu ŋgumbo bɨdɨfɨranɨ si tüküfiyuambe ranana ai aboedambondɨfimbui. ");
INSERT INTO agg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","God ŋgɨnɨndɨ hɨfandarandɨ Aboedɨ Hoafɨ ranahambo muŋguambo hɨfɨ ranühɨ nindou muŋgu ranaheimbo weindahɨ bokarɨhefendüranɨ anɨmbo asu ndeara bɨdɨfɨranɨ si ra tükündɨfemboe.” ");
INSERT INTO agg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Asu moaruwai moatükunɨ nɨŋgombo-mayo sürühoeimbɨ fondɨ ranahambo moaruwaimbondeambui ranahambo Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou ahandɨ ndürɨ Danier ai wataporɨmbomarandɨ ra se hoeindumboemo. (Nindou düdi ai ndanɨ hoafɨ ra hoeifemboayu ranai hoafɨ ranahambo ndore fɨfɨrɨmbɨreandamboane.) ");
INSERT INTO agg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ranɨ-sɨmboanɨ anɨmbo nindou dɨdɨyei ai Sudia hɨfambe anɨmboei ranai hɨfɨ wafunambo nɨmai mbɨfefoehindamboane. ");
INSERT INTO agg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ranɨ-sɨmboanɨ ana sapo nindou ahandɨ worɨkɨmɨ amaru ranai ahandɨ napo worambe kurayo ranahambo hanɨ semɨndɨmbo hɨhɨnɨŋgɨndeambui. ");
INSERT INTO agg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Asu nindou düdi ai ahandɨ nümbürambe anüŋgu ranai ŋgɨrɨ ahandɨ hoearɨ masɨhendɨ ra semɨndɨmbo hɨhɨrɨndɨfi ŋgu, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ranɨ-sɨmboanɨ nɨmorehɨ dɨdɨyei ai nɨmorɨ furümbayei-ane asu nɨmorehɨ nɨmorɨ tɨtɨ sɨmɨndeimbayei ranane ranaheimbo moaruwai hamɨndɨ tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Se Godɨmbo dɨdɨbafɨndɨmo rananɨmbo asu se ŋgɨrɨ afɨndɨ ŋgɨsɨharɨ tüküfeyoambe ane asu moanɨ nɨmarɨmbo si ranambe ane ra se ŋgɨrɨ feboundɨ! ");
INSERT INTO agg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ranɨ-sɨmboanɨ tɨŋɨrɨfo afɨndɨ tükündɨfemboe. Horombo God ai hɨfɨ sünü nafɨmarandambe peyo haya ho hombo hapondanɨ tükefeyombe ana, moai afɨndɨ tɨŋɨrɨfo ndahurai tüküfeyo. Ŋga süŋgunambo ranɨ sɨmboanɨ ana moanɨ muŋgunambo tɨŋɨrɨfo afɨndɨ hamɨndɨ moatükunɨ anɨmbo tükündɨfemboe. Asu randɨfe hayambo ra süŋgunambo ana ŋgɨrɨ asükaindo tɨŋɨrɨfo yahurai tükündɨfeyo. ");
INSERT INTO agg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ŋga asu God ai ranɨ-sɨmboanɨ ranahambo bodɨfombofe kɨkɨhɨyɨmɨndɨ-koatembembonana muŋguambo nindou ranai ŋgɨrɨ aboedamboyahindɨ. Ŋga asu God ai muŋguambo nindou sapo ranaheimbo wandanei yahu dɨbonɨmayundürɨ ranɨmbohündambo wambo anɨmbo asu hapondanɨ ana God ai ranɨ si ra awi bodɨfombonde kɨkɨhɨndamündümbui. ");
INSERT INTO agg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Rasɨmboanɨ nindou bɨdɨfɨrɨ ai sɨhamumbo hoafɨyeihüya, ‘Se ndühɨ hɨmboemo, ŋga Krais ana ini nda!’ mbɨsei-anane, asu ‘Ai ana ini gogu ra!’ mbɨsei-anane ra se nindou ranahei hoafɨ anɨhondümbo-ndundürɨmboemo. ");
INSERT INTO agg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nɨmboe sapo nindou bɨdɨfɨrɨ ai tüküyafundühɨ wosɨhoaforɨ hoafɨndɨmondühɨya, ‘Ro Krais-anahɨ,’ asu ‘Ro Godɨndɨ hoafɨ hoafɨya-rɨhandeimbɨ nindou-anahɨ,’ mbɨsɨmbo-memo. Asu ai hepünɨfeimbɨ moatükunɨ nafuindɨmondühɨ ranɨ-poanɨmbo ŋgɨnɨndɨ nafuimbo ratüpurɨ ratüpurɨndɨmboemo. Ai nindou sapo God wandanei mehu ranaheimbo amboanɨ ndahurɨmɨndefɨmbo mbɨsɨmboemo, ŋga ŋgɨrɨndɨmo. ");
INSERT INTO agg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ranɨ-moatükunɨ ranahambo ro horombonamborɨhe hoafɨmehapurane, ŋga se ranahambo hɨmborɨndɨmo. ");
INSERT INTO agg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Asu nindou ai randɨhi hoafɨndeihɨya, ‘Hoeirɨhi, Krais-mayu ranai ana nɨmɨ wohɨ furɨkoate-reandɨ hɨfühani anüŋgu,’ mbɨseianɨ asu se ranɨnɨ ŋgomboemo, ŋga wanɨ. Asu nindou ai randɨhi hoafɨndeihüya, ‘Aiana dɨbo ndanambe ndanüŋgu nda,’ mbɨseianɨ wanɨ asu se ranahambo anɨhondümbondumboemo, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ŋga Nindou Hondü ranai ana, sapo wabürüsɨ sünü muŋgu ranɨfihɨ hüfɨhamɨndɨ süfuanɨpoedɨ ŋgu hafuanɨ si boakɨboadeamboe yahurai-anɨmbo nindou hɨmboahü tükündüfimbui. ");
INSERT INTO agg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sapo nahanühɨyo nindou ai yɨfɨyo haya yɨfɨ nɨmoko ranai moanambühɨ eŋgoro ana, ranühɨ koahoeimbɨ ranai hei gugurɨhindühanei.” ");
INSERT INTO agg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ranɨ tɨŋɨrɨfombü moatükunɨ si ranai ndeara muŋgundoanɨ anɨmbo nɨmehünou, hüfɨhamɨndɨ ai nɨmbɨraŋɨnderühɨ asu amoamo ai ŋgɨrɨ sindu. Mupui ai sünambeahɨndɨ fɨrɨbadɨyɨboai pütapɨndowohü asu muŋguambo ŋgɨnɨndɨ moatükunɨ sünambe anɨŋgo ranai fɨfɨmɨndɨmboe. ");
INSERT INTO agg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ranɨ-sɨmboanɨ anɨmbo Nindou Hondü ai tüküfembo nafuimbo moatükunɨ ranai sünambe weindahɨ tükündɨfemboe. Asu hɨfɨ ndanühündambo muŋguambo sɨrɨhündɨ nindou ranai arasɨranɨndeimboyei. Asu Nindou Hondü ai sünambeahɨndɨ mburüŋgaiwamɨ nüŋgumbo ahandɨ ŋgɨnɨndɨ asu adükarɨ hɨmboamupuimbo-randeimbɨ moatükunɨ ndemündü haya ra dɨbonde kuduanɨ ranahambo hoeindɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Rananɨmbo fufuŋɨ afɨndɨ ranai hoafɨndɨmboe. Rananɨmbo asu ai ahandɨ sünambeahɨndɨ nendɨ ranhamumbo yimbuyimbu hɨfɨ ra hɨmboranɨpoedɨ nindou muŋgu God ai wandanei mehu gugurɨfendürɨmbohünda koandɨhepura ŋgomboemo.” ");
INSERT INTO agg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Asu se hoandasüfo nɨmɨndɨ türüfoarundühɨ hohoanɨmondɨmo. Ranɨ nɨmɨ ranai ahandɨ düdüdü ranɨfihɨ hoehoai tütükɨyohü emündü aforo ana, se fɨfɨrundɨ sapo ranana ndeara hoemboane. ");
INSERT INTO agg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mamɨ ranɨ-süŋgumbo anɨmbo asu se hoeindundanɨ muŋguambo ranɨ moatükunɨ ranai tükündɨfeyoanɨ hoeindundühɨ rananɨmbo se Nindou Hondü ai ŋgɨrɨ amɨtata kudu, ŋga yipurɨ kɨmani anüŋgu, ra fɨfɨrɨndumboemo. ");
INSERT INTO agg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ro sɨhamumbo anɨhondümboanahɨ hoafehapurɨ nda. Bɨdɨfɨrɨ nindou hɨfɨ ndanühɨ anɨmboei yɨfɨhai-koateayei-ambe anɨmbo ranɨ-moatükunɨ ranai tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sünü hɨfɨ ranai ana awarɨndɨhoemboe, ŋga asu wandɨ hoafɨ ranana ŋgɨrɨ awandɨhoayo, ŋga wanɨ.” ");
INSERT INTO agg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ŋga asu Nindou Hondü ai tüküfembo si ranɨnambo nindou mamai-amboanɨ moai fɨfɨreandɨ. Asu ranɨ si tüküfemboayo ra sünambeahɨndɨ nendanemo asu Nɨmorɨ aiani ra moai fɨfɨrundɨ. Ŋga moanɨ Afɨndɨ ai yaŋgɨrani ranɨ-moatükunɨ ranahambo fɨfɨreamboayu. ");
INSERT INTO agg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nindou Hondü ranai tüküfembo si ranana Noa nüŋguambe ra sɨmboanɨ nahuraindɨmboe. ");
INSERT INTO agg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sapo horombo hohoambu ai tüküfe-koateyoambe ranɨ-sɨmboanɨ ra nindou ai moanɨ sesɨ sahüsi hoe sɨmɨndei asu nɨmorehɨ nindowenihɨ anamɨndühɨyahi heimbo bɨdɨfɨranɨ hondü ranambe Noa ai botambe aboeda kamefuendɨ. ");
INSERT INTO agg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ranɨ-sɨmboanɨ ra nindou ranai ranɨ-moatükunɨ tüküfemboayo ranahambo moai fɨfɨrɨhindɨ, ŋga ai moanɨ sɨrɨ mbɨrowohɨ ratüpurɨyei hei-ane asu hohoambu ranai tüküfehü aheimbo pare gogomaramɨndɨndürɨ. Moanɨ yahurai-anɨmbo süŋguna Nindou Hondü ai tüküfiyuambe tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ranɨ-sɨmboanɨ ana nindou yimbu ai nümbürambe ratüpurɨndafandühɨ nɨmbafandanɨ anɨmbo, nindou ŋgorümbo nderümündühɨ asu ŋgorü ai moanɨ rande bodɨboadiranɨ nüŋgumbui. ");
INSERT INTO agg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nɨmorehɨ yimbu ai mbanɨ hɨrɨndafihɨ nɨmbafeanɨ anɨmbo asu ŋgorümbo ndemünduanɨ asu ŋgorü ai moanɨ rande bodɨboadeandanɨ nɨŋgomboe. ");
INSERT INTO agg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Awi se hɨbadümbo nɨŋgomo, ŋga nɨnɨ-sɨmboanɨyo sɨhamundɨ Adükarɨ ai tüküfemboayu ra se moai fɨfɨrundɨ. ");
INSERT INTO agg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Awi se randu hohoanɨmondɨmo. Worɨ aharambürɨyu haya hümbuhünɨ nindou ai nɨnɨ-sɨmboanɨyu ahandɨ worambe hümbuhünɨmbo tüküfemboayu ra fɨfɨrareandɨ ana, nindou ranai ŋgɨrɨ apu. Ŋga ai hümbuhünɨ nindou worambe tükündüfimbui mbüsü haya yaŋgɨrɨ günde nɨmandü ŋgumbui. ");
INSERT INTO agg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ranɨmbohündambo anɨmbo se-amboanɨ muŋguambo si aho ra hɨbadundühɨ nafɨndündümo nɨmandɨmo. Ŋga Nindou Hondü ranai tüküfembo ranahambo se mɨtanɨründümo houmbo hɨdɨbo-hɨdɨboyomondambeanɨmbo moanɨ ai sümbundamündü tükündüfimbui.” ");
INSERT INTO agg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Asu düdi ratüpurɨyu-randeimbɨ kaoworɨ hohoanɨmo-koate dɨdɨboadɨre-randeimbɨ fɨfɨreandeimbɨ nindouayua? Nindou ranai ana sapo ahandɨ bogorɨ nindou-mayu ranai ahamboya, ‘Se nindou ratüpurɨyomo-rundeimbɨ bɨdɨfɨrɨ-memo ranahamumbo hɨbadapurɨ,’ yahu haya kafoarirɨ hɨnɨŋgɨmarirɨ ranani sapo ai ahamumbo sesɨ segopurɨmbo sɨmboanɨ yɨbobofe segopurɨmbohünda. ");
INSERT INTO agg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nindou ranahandɨ bogorɨ nindou ai worambe tüküfi hoeiriranɨ asu nindou-mayu ranai sapo ahandɨ bogorɨ nindou ai refembo hoafɨmayu süŋgu rawareandɨ ranana nindou ranai moanɨ hɨhɨfɨ-hɨhɨfɨmbiyuwamboane! ");
INSERT INTO agg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ro nda sɨhamumbo anɨhondümboanahɨ hoafehapurɨ, bogorɨ nindou ranai nindou ranahambo ahandɨ muŋguambo moatükunɨ ranahambo hɨfandɨmbo bogorɨmbondirɨ hɨnɨŋgɨndirümbui. ");
INSERT INTO agg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ŋga asu nindou ranai, moaruwai ratüpurɨyu-randeimbɨ nindouayu ana, asu ai ahandɨ fimbo rande hoafɨnduhü anɨmboya, Wandɨ bogorɨ nindou ai ŋgɨrɨ awi nɨmai tükündüfiyu mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Rananɨmbo asu ai ahandɨ mamɨ ratüpurɨyomo-rundeimbɨ-memo ranahamumbo piyu haya bubuhaindüpurühɨ asu sesɨ dedü wakɨndeandühɨ bia ra ndümündɨ, nindou bia sɨmɨndɨmo-rundeimbɨ ranɨ-babɨdɨ hoaŋguhü rarandu wakɨndeambui. ");
INSERT INTO agg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Rananɨmbo asu mamɨ sɨmboanɨ sapo ratüpurɨyu-randeimbɨ-mayu ranai ahandɨ bogorɨ nindou ranai tüküfemboayu ra mɨtanɨramündü haya hɨdɨbo-hɨdɨboyuambe anɨmbo tükündüfimbui. ");
INSERT INTO agg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Rananɨmbo asu ahandɨ bogorɨ nindou ai ahambo kɨbodɨrɨndirɨ mbunda asu nindou wosɨhoaforɨ hoafɨyeimbɨ ranambendirɨmbui. Rananɨmbo asu ai ranambendɨfihɨ heindühɨ yahafɨ sɨsɨnderɨmboe.” ");
INSERT INTO agg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ranɨ-sɨmboanɨ ana God ŋgɨnɨndɨ sünambe hɨfandarandɨ ra ndahurai anɨmbo tükündɨfemboe. Mamɨmbo yihoarɨfamborɨ 10 ranai nindou mamɨ nɨmorehɨ semündü haya masüfuwa asu ai ahei ram hai ra fufurühümündi hehi ahambo nafɨnɨ nafoarɨfiho fihambo mahei. ");
INSERT INTO agg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hondahüyahindeimbɨ-mayei (5) ranai moanɨ hohoanɨmo-koateyei, ŋga asu ŋgorü hondahüyahindeimbɨ-mayei (5) ranai aboedɨ fɨfɨrɨhindeimbɨyei. ");
INSERT INTO agg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sapo nɨmorehɨ hohoanɨmo-koate-mayei ranai ahei ram ra sahümündi, ŋga asu moai ram hoe bɨdɨfɨrɨ fuihümündi. ");
INSERT INTO agg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ŋga asu nɨmorehɨ dɨboadɨre fɨfɨrɨhindeimbɨ-mayei ranai ahei hoe hɨpɨrɨ-mayo ranambe hoe fuihümündihɨ ahei ram dɨboadorɨhi masahümündi. ");
INSERT INTO agg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ranɨyei asu sapo nindou nɨmorehɨ semündümbɨ-mayu ranai nɨmai tüküfe-koatemayuwamboyei asu aheimbo yapombo hɨmbo-marandüramboyei moanɨ rarɨhi yapombo boarɨhehi hehi kurɨmayei. ");
INSERT INTO agg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ranɨyo hombo nɨmbɨ mbusümondühɨ nindou mamɨ ranai mɨŋgɨyowuhü yahuya, ‘Sapo nindou nɨmorehɨ semündümbɨ-mayu ana nda! Ŋga asu se ahambo sühüsi nafoarɨhorɨ fihɨrɨhorɨmɨndei!’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ranɨyei nɨmorehɨ-mayei ranai muŋgu botɨyahindühɨ ahei ram hai ra yimundɨfembo dɨdɨboadomafandɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ranɨyei asu nɨmorehɨ hohoanɨmo-koateyeimbɨ-mayei ranai nɨmorehɨ aboedɨ fɨfɨrɨhindeimbɨ-mayei ranai hoafɨyeihü seiya, ‘Awi se yɨhoefɨmbo ndühɨ sɨhei-mayo hoe bɨdɨfɨrɨ fuisehi, ŋga yɨhoefɨ ana hümaraso,’ maseiamboyei. ");
INSERT INTO agg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Asu nɨmorehɨ aboedɨ fɨfɨrɨhi-rɨhündeimbɨ ranai hoafɨyeihü seiya, ‘Yowanɨ, ŋgɨrɨ ndehundɨ. Hoe ndanana sɨheimboane asu yɨhoefɨmboane ra ŋgɨrɨ sɨmoŋgoründamɨndɨmunɨ. Ŋga awi hɨhɨrɨndahi ŋgei stoa worambeahɨndɨ se-amboanɨ sɨheipoanɨmbo pemɨndei,’ masahündüramboyei. ");
INSERT INTO agg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Asu ranɨyei hohoanɨmo-koate nɨmorehɨ-mayei ranai stoanambo hoe pemɨmbo hɨhɨrɨyahi mbahei nou ranambo amoŋgonɨmbo nindou nɨmorehɨ semündümbɨ-mayu ranai tükümefiyu. Ranɨyei asu hondahüyahindeimbɨ nɨmorehɨ nafɨrɨhümündimbü-mayei ranai nɨmorehɨ semɨndɨmbo sesesɨ fondɨ-mayo ranambe nindou-mayu ranɨ-babɨdɨ kefoehi mahüsi. Ranɨyo asu ranambe kefoefe hombo yipurɨ ra pamaiaro. ");
INSERT INTO agg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ranɨyei asu süŋgunambo hondahüyahindeimbɨ nɨmorehɨ bɨdɨfɨrɨ-mayei ranai tükümehindɨ. Ranɨyei asu ai rarɨhi puküna hoafɨyeihü seiya, ‘Adükarɨ, Adükarɨ, se yɨhoefɨmbo yipurɨ sübüdühawamunɨ dɨgifo,’ sei hoafɨmayei. ");
INSERT INTO agg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ranɨyu asu nindou ranai sɨmborɨ aheimbo hoafɨyundürühɨ yahuya, ‘Ro sɨheimbo anɨhondümboanahɨ hoafayahɨ, se ŋgɨrɨ keboehindɨ, ŋga roana moai sɨheimbo fɨfɨrɨhearü,’ mehundürɨ.” ");
INSERT INTO agg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Sisas ai ndeara hoafɨ moendɨreandühɨ yahuya, “Awi se hɨbadümbo, ŋga moai se Nindou Hondü ai tüküfembo si ane asu ranɨ sɨmboanane ra fɨfɨrundɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sisas ai asükai hoafɨyuhü yahuya, “Ranɨ si tüküfe sɨmboanɨ ranana ndahurai-ane. Mamɨ sɨmboanɨ nindou mamɨ ai ahandɨ worɨ ra hɨnɨŋgɨfe hefe ŋgorü hɨfɨna hombo mehu. Ranɨyu asu ai ahandɨ ratüpurɨyomo-rundeimbɨ ahamumbo mborai yahupurɨ mbura ahandɨ muŋguambo moatükunɨ ahamundɨ warambe hɨnɨŋgɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nindou-mayu ranai ahandɨ ratüpurɨyomo-rundeimbɨ ranahamundɨ ŋgusüfo ŋgɨnɨndɨ küru hohoanɨmoemo ranɨ sɨmogodühɨ kakɨ hoarɨ ra ahamumbo yɨbobore yimbumareapurɨ. Nindou ŋgorümbo 5,000 kakɨ hoarɨ sagado. Ŋgorümbo 2,000 kakɨ hoarɨ sagado. Asu ŋgorü-mayu ranahambo 1,000 kakɨ hoarɨ ra sagado marandɨ. Ranɨyu asu ai ahamumbo yare hɨnɨŋgɨreapurɨ haya ŋgorünamefiyu. ");
INSERT INTO agg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ratüpurɨyu-randeimbɨ nindou sapo 5,000 kakɨ hoarɨ masemündu-mayu ranai nɨmehünou kakɨ ranambo kakɨ semɨndɨ ratüpurambe sɨhai haya ratüpurɨyuhü ranɨ-fihɨndɨ 5,000 asükaiyu ranɨwamɨ masemündu. ");
INSERT INTO agg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Asu mamɨ yahurai safɨ nindou sapo 2,000 kakɨ hoarɨ masemündu-mayu ranai kakɨ ranɨ-fihɨndɨ 2,000 asükaiyu ranɨwamɨ masemündu. ");
INSERT INTO agg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ŋga asu nindou sapo 1,000 masemündu-mayu ranai ahandɨ bogorɨndɨ kakɨ ra semündü hu hɨfambe kakɨrɨhai mbura hɨfambe dɨbo samboare hɨnɨŋgɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nindou ranahamundɨ bogorɨ-mayu ranai aŋgunɨ hu gedühɨ nüŋgu nüŋgumbo asu ai ŋgoafɨna hɨhɨrɨfi hu tükümefiyu. Ranɨyu asu ai ahandɨ kakɨ nindoumbo yɨbobomareapurɨ-mayo ranahambo nindou ranɨ babɨdɨmbo hoafɨ dɨboadondɨheapurɨ yahu haya. ");
INSERT INTO agg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nindou 5,000 kakɨ masemündu-mayu ranai tüküfi ahandɨ bogorɨ nindou-mayu ranahambo 5,000 ŋgorü-mayo ra masagado. Asu ai ranahambo hoafɨyundühɨ yahuya, ‘Adükarɨ, se wambo 5,000 kakɨ masowandɨrɨ, ŋga awi se nda hoeiro. 5,000 kakɨ-mayo se masawandɨrɨ ranɨ-fihɨndɨ ro ŋgorü 5,000 kakɨ masahamɨndɨhɨ nda,’ mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Asu ahandɨ bogorɨ nindou-mayu ai hoafɨyuhü yahuya, ‘Se aboedɨ hamɨndɨ ramarowandɨ. Seana aboedɨ asu anɨhondümbo hondü ratüpurɨyafɨ-randeimbanafɨ. Seana moanɨ akɨdou moatükunɨ dɨboadɨro-randeimbanafɨ. Ŋga asu ranɨmbohündambo anɨmbo hapondanɨ ana sɨhambo ro adükarɨ moatükunɨ hɨfandɨmbo amboanɨ bogorɨmbondɨhe hɨnɨŋgɨndɨheanɨnɨmboyahɨ. Asu se mborai sühüfɨ ranahambo rodɨbo hɨhɨfɨ-hɨhɨfɨnde,’ mehundo. ");
INSERT INTO agg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ranɨyu asu nindou 2,000 kakɨ masemündu-mayu ranai-amboanɨ tüküfi ahandɨ bogorɨ nindou-mayu ranahambo hoafɨyundühɨ yahuya, ‘Adükarɨ, se wambo 2,000 kakɨ masawandɨrɨ, ŋga awi se nda hoeiro. 2,000 kakɨ-mayo se masawandɨrɨ ranɨ-fihɨndɨ ro ŋgorü 2,000 kakɨ masahamɨndɨhɨ nda,’ mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Asu ahandɨ bogorɨ nindou-mayu ai hoafɨyuhü yahuya, ‘Se aboedɨ hamɨndɨ ramarowandɨ. Seana aboedɨ asu anɨhondümbo hondü ratüpurɨyafɨ-randeimbanafɨ. Seana moanɨ akɨdou moatükunɨ dɨboadɨro-randeimbanafɨ. Ŋga asu ranɨmbohündambo anɨmbo hapondanɨ ana sɨhambo ro adükarɨ moatükunɨ hɨfandɨmbo amboanɨ bogorɨmbondɨhe hɨnɨŋgɨndɨheanɨnɨmboyahɨ. Asu se mborai sühüfɨ ranahambo rodɨbo hɨhɨfɨ-hɨhɨfɨnde,’ mehundo. ");
INSERT INTO agg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ranɨyu asu nindou 1,000 kakɨ masemündu-mayu ranai-amboanɨ tüküfi bogorɨ nindou-mayu ranahambo hoafɨyundühɨ yahuya, ‘Adükarɨ, ro sɨhambo fɨfɨrɨheanɨnɨmboanahɨ. Seana nindou awi hɨmboarɨ handinɨ-yafeimbɨ ŋgɨnɨndɨ hamɨndanafɨ. Seana nɨne-moatükunɨ se hɨfɨrowandeimbɨ-hündɨyopoanɨ nümbürambeahɨndɨ sesɨ ra yimuŋgurandɨfɨ arandɨ. Asu nindou amurɨ ai nɨnɨ-moatükunɨ maŋgɨrɨyo bubufoarhindeimbɨhündane seana sesɨ ra guguro arandɨ. ");
INSERT INTO agg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ranɨmboyahɨ asu ro sɨhambo yɨhɨmbombo sɨhafɨ kakɨ ra sahamɨndɨ ha hɨfambe kakɨrɨhɨ dɨbo masamboarɨheandɨ. Sɨhafɨ muŋguambo kakɨ ini nda, ŋga se rando hoeindowandɨ,’ mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Asu ahandɨ bogorɨ nindou-mayu ai hoafɨyuhü yahuya, ‘Awi se ana ratüpurɨyafɨ-randeimbɨ nindou moaruwai, ratüpurɨ-koate yɨboaruko yɨboaruko-yafeimbɨ nindouanafɨ. Nindou ŋgorü ai ratüpurɨyumbü ranahandɨ ro sesɨ yimuŋgurahamɨndɨ asu nindou ai nɨne ahurɨ buburandeimbɨ ranahandambohündɨ ro sesɨ ra yimuŋgurɨhamɨndɨ gugurɨhe arɨhandɨ ranahambo awi se wambo ndoro fɨfɨrɨwandɨrɨmbo-wamboyafɨ? ");
INSERT INTO agg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Asu awi refe anasɨ, se kakɨ wandɨ ra sapo kakɨ sɨhefe arandɨ worambe sɨhoefanɨ anɨmbo, asu ro tükündaheandühɨ amboanɨ kakɨ bɨdɨfɨrɨ ranɨwamɨ nandɨhe ndahamɨndɨmbohündɨsɨ. ");
INSERT INTO agg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Haponda ahandɨ warambeahɨndɨ kakɨ ra ndowandümo mbundu nindou sapo 5,000 kakümbɨ-mayu ranahambo dabudo. ");
INSERT INTO agg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ŋga ai sapo nɨne-moatükunɨ sɨmoŋgorɨ-maramündu ranɨfihɨ bɨdɨfɨrɨ pandeamboe. Ŋga asu nindou düdi ai nɨnɨ-moatükunɨyo ranahambo wanayu ana, asu ai nɨnɨ-moatükunɨyo ai akɨdou asɨhendɨ ra ahandɨ-mayo muŋgu fufuimɨndɨmboane. ");
INSERT INTO agg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ŋga yɨboaruko-yɨboarukoyumbü nindou ranahambo weindanɨ hondü nɨmbɨ nɨmaroambe pinduwurü. Rananɨmbo ai ranambe nɨmandümbo heinduhü yahafɨ sɨsɨnderɨmboe,’” mehu. ");
INSERT INTO agg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Süŋgunambo Nindou Hondü ranai bogorɨmbondüfi tükündüfihü ahandɨ sünambeahɨndɨ nendɨ ranɨ-babɨdɨmbo ana, asu ai ahandɨ muŋguambo moatükunɨ hɨfandɨmbo nɨmarɨ fondɨ ranɨwamɨ nɨmandümbui. ");
INSERT INTO agg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Rananɨmbo asu muŋguambo hɨfɨ ranɨ-hündambo nindou ranai ahandɨ haŋgɨfohü gugurɨndearümbui. Rananɨmbo asu nindou ranaheimbo sapo sipsip hɨfandɨrandeimbɨ nindou sipsip ŋgorünɨnɨ yɨbobore asu meme ŋgorünɨnɨ yɨbobore arandɨ nou rande yimbumbonde yɨbobondearümbui. ");
INSERT INTO agg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Randeandühɨ anɨmbo ai sipsip ahandɨ warɨ hondünɨ hɨnɨŋgɨndearühɨ asu meme ahandɨ warɨ kadüdanɨ hɨnɨŋgɨndearümbui. ");
INSERT INTO agg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Rananɨmbo asu Bogorɨ nindou ai nindou ahandɨ warɨ hondünɨ amarei ranaheimbo hoafɨndundürühɨ anɨmboya, ‘Se ana sɨheimbo wandɨ Ape ai aboedɨ-aboedɨmareandürane, ŋga se mborai sühüsi. Rananɨmbo asu se sühüsi God ŋgɨnɨndɨ hɨfandɨrandɨ ranahambo sapo wandɨ Ape ai sɨheimbo semɨndɨmbo horombo hɨfɨ sünü hapoadümbo sɨmborɨyoambe raraore nafɨramündü masɨhendɨ ra sahümündi. ");
INSERT INTO agg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sapo ro wembomboyahanɨ asu se wambo sesɨ masehindɨrɨ. Ro amɨndanɨŋomboyahanɨ asu se wambo hoe sɨmɨndɨmbo masehindɨrɨ. Ro nindou amurɨ tüküyaheandanɨ asu se wambo sahümündihündɨrɨ sɨhei worɨnɨmarɨhindɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ro hoearɨ-koate nɨmboahanɨ asu se wambo hoearɨnambo yihurumarɨhindɨrɨ. Ro aŋgünümboyahanɨ asu se wambo hɨfandɨmarɨhündɨrɨ. Ro karabusambe nɨmboahanɨ asu se wambo hei wakɨmafoarɨhindɨrɨ. Ro hoearɨ napo-koateyahanɨ se wambo hoearɨnambo wandɨ fi yihurumarɨhindɨrɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nindou mbumundɨ-mayei ranai ahambo sɨmborɨ hoafɨndahɨndowohü anɨmboya, ‘Adükarɨ, nüŋgu-sümboanɨyo sɨhambo hoeirɨhunɨna wembombomefa sesɨ masahunɨnɨ, asu sɨhambo hoeirɨhunɨna amɨndanɨŋombomefa hoe sɨmɨndɨmbo mafuihunɨnɨ ra? ");
INSERT INTO agg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nüŋgu-sɨmboanɨyo ro sɨhambo hoeirɨhunɨna nindou amurɨmboyafo tüküyafoanda sahumɨndefɨnɨnɨ yɨhoefɨ worɨnɨrɨhunɨnɨ, asu hoearɨ-koateyafanɨ hoearɨ yihurumarɨhunɨna? ");
INSERT INTO agg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Asu nüŋgu-sümboanɨyo ro sɨhambo hoeirɨhunɨna aŋgünümboyafɨ asu karabusambe nɨmbafɨ randanɨ ro hefɨ wakɨmafoarɨhunɨna?’ mbɨseimboyei. ");
INSERT INTO agg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Asu Bogorɨ nindou ai aheimbo sɨmborɨ hoafɨnduhü anɨmboya, ‘Ro sɨheimbo anɨhondümbo-anahɨ hoafayahandürɨ, nɨne-moatükunɨ se moanɨ ndürɨ-koateyeimbɨ nindou wandɨ ranahambo se ramarɨhindɨ ranana wambo rɨhündɨrɨ rarɨhi marɨhündɨrɨ!’ mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Rananɨmbo asu ai nindou ahandɨ warɨ kadüdanɨ anɨmboei ranaheimbo hoafɨndundürühɨ anɨmboya, ‘Se awarɨhehindeimbɨ nindou-anei. Andai se wambo hɨnɨŋgɨrɨhindɨrɨ ragu ŋgei! Seana hai moanɨ yare koadürümbo horoweimbɨ God ai dɨdɨboadore nafamündü Satan asu ahandɨ nendɨ ranahamumbo hɨnɨŋgɨmareandɨ ranambe ŋgei! ");
INSERT INTO agg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sapo ro wembomboyahanɨ ra se moai wambo sesɨ sehindɨrɨ. Ro amɨndanɨŋomboyahanɨ se moai wambo hoe sɨmɨndɨmbo sehindɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ro nindou amurɨmboyahe heheya tüküyahindanɨ se moai wambo sahümündi-hündɨrɨ sɨhei worɨnɨrɨhindɨrɨ. Ro hoearɨ-koate nɨmboahanɨ se moai wambo hoearɨnambo yihururɨhindɨrɨ. Ro aŋgünɨmboya, karabusambe nɨmboaha raraorɨhanda se moai wambo farɨhehindɨrɨ rɨhündɨ,’ mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Asu ai-amboanɨ sɨmborɨ ahambo hoafɨndahɨndowohü anɨmboya, ‘Adükarɨ, nüŋgu-sümboanɨyo ro sɨhambo hoeirɨhunɨnanɨ se wembomboyafɨ, hoeimbo amɨndanɨŋomboyafɨ, nindou amurɨmboyafo tüküyafo, hoearɨ-koate nɨmbafɨ, aŋgünümboyafɨ asu karabusambe nɨmbafanɨ ro sɨhambo farɨhefenɨnɨ-koatemayefa?’ mbɨseimboyei. ");
INSERT INTO agg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Asu Bogorɨ nindou ai aheimbo sɨmborɨ hoafɨndühɨ anɨmboya, ‘Ro sɨheimbo anɨhondümbo-anahɨ hoafehandürɨ, se sapo moanɨ ndürɨ-koateyeimbɨ nindou wandɨ ranaheimbo farɨhefendürɨmbo moei asei ranana asu se wambo amboanɨ farɨhefendɨrɨmbo moei seihane!’ mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Rananɨmbo asu nindou ndanai koadürümbo koadürümbo tɨŋɨrɨfo adükarɨ nɨŋgoweimbɨ ranambe mbɨhei-amboane, ŋga asu nindou aboedɨ mbumundɨ-mayei ranai-anɨmbo yaŋgɨrɨ koadürümbo koadürümbo nɨŋgoweimbɨ ranambe mbɨhei-amboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sisas ai ranɨ yamundɨfe hoafɨ ra moendɨreandühɨ asu ahandɨ süŋgururü-rundeimbɨmbo hoafɨyupurühɨ yahuya, ");
INSERT INTO agg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Se fɨfɨrumboanemo, ŋga awi asouŋgu God Israer aboedambomareandɨ hohoanɨmombo Si (Pasofa) tükündɨfemboe. Asu sesɨ sesɨmbo si ranambe anɨmbo Nindou Hondü ranahambo hürütümbɨ nindou-yomondɨ warɨhündɨfimbui ahambo hɨfokoefimbo-hündambo nɨmɨfihɨ tɨkondüründɨmo pandüwurɨmboemo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ranɨyomo asu Godɨmbo sɨhou-rundeimbɨ bogorɨ nindouyomo, asu Suda-yafe bogorɨ nindouyomo ranai bogorɨ hondü nindou Godɨmbo sesɨ sɨhai-randeimbɨ ahandɨ ndürɨ Kaiafas ranahandɨ adükarɨ worambe mamɨ gugurɨmefundɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ranɨyomo asu ai Sisasɨmbo dɨbo kɨkɨhɨyimündɨ hefi hɨfokoefimbo yahomo houmbo hoafɨ ra fɨfɨrɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Asu ai yaru hoafɨyomondühɨ yahomoya, “Ranɨ-moatükunɨ ra nindou afɨndɨ fandɨfe sesesambe ana refepoanɨ, ŋga asu nindou afɨndɨ ranai hoafɨ afɨndafɨndɨndeihɨ ŋgoafɨ moaruwaimbo-ndɨhimboyei,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mamɨ, Betani ŋgoafɨhü Sisas ai Saimonɨndɨ worambe mamaru. Nindou ranai horombo mɨmanɨho masɨmeiyu haya mamaru. ");
INSERT INTO agg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Sisas ai nindou ranahandɨ worambe sesühɨ nɨmaru-ane nɨmorehɨ mamɨ ranai ahambo sowana tükümefeyo. Ai nɨmoei hɨpɨrambe sanda aboedɨ fɨsɨŋarümbɨ kakɨ afɨndɨfihɨ semɨndɨ-weimbɨhündɨ ra semɨndɨ haya tükümefeyo. Ranɨyo asu Sisas ai sesɨ fondɨ-mayo ranɨkɨmɨ nɨmaruambe ai sanda ra ahandɨ mbɨro wafuambe kamareando. ");
INSERT INTO agg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ranɨyomo asu Sisasɨmbo süŋgururü-rundeimbɨ ai ranɨ-moatükunɨ ramareandɨ ranɨmbo hoeiru houmbo ŋgɨnɨndɨ hoafɨyomondühɨ düduyafundühɨ yahomoya “Nɨmboe nɨmorehɨ ndanai sanda nda yatɨkɨrɨ-yatɨkɨrɨra wakareandɨ? ");
INSERT INTO agg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Awi sanda ndanana kakɨ adükarɨfihɨ anɨmbo koarɨhefihɨ kakɨ semɨndɨ mburumbo nindou napo-koate-mayei ranaheimbo kakɨ ra saimboyosɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sisas ai fɨfɨreandɨ ahambo süŋgururü-rundeimbɨ ai nɨnɨmboe hoafɨmemo ranɨmbo ra. Ranɨyu asu ai ahamumbo hoafɨyupurühɨ yahuya, “Se ra nɨmboe nɨmorehɨ ndanahambo moaruwaimboarundɨ rana? Ai ana moanɨ sɨmbamɨndɨ hamɨndɨ moatükunɨyo wambo ramareandɨ rananasɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nindou napo-koateyeimbɨ ranai ana se babɨdɨ muŋguambo si ra nɨboadeimboyei, ŋga asu roana ŋgɨrɨ se-babɨdɨmbo muŋguambo si ra nɨmboahɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aiana sanda ranɨyo wandɨwamɨ kamareandɨ sapo wambo samboefendɨrɨmbo dɨdɨboadoreandühɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Haponda ro sɨhamumbo anɨhondümbo-anahɨ nda hoafehapurɨ, muŋguambo hɨfɨ ndanühɨ nɨnɨ ŋgoafɨhüyo Godɨndɨ hoafɨ ra wataporɨmboayo ana, nɨne-moatükunɨ ai wambo ramareandɨ ra ahandɨ hoafombohünda wataporɨmbondühɨ-ndühɨmboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Ranɨyu asu Sisasɨmbo süŋgururü-rundeimbɨ nindou mamɨ ahandɨ ndürɨ Sudas Iskariot ai Godɨmbo sɨhourundeimbɨ nindou bogorɨ-memo ranahamumbo sowana hüfu düdufipurühɨ yahuya, “Se wambo nɨnɨ-moatükunɨ mandaundɨrɨ ro Sisasɨmbo sɨhamundɨ warühɨ yirümondɨhinanɨ rana?” mehupuramboemo. Ranɨyomo asu ai ahambo kakɨ hoarɨ 30 ra tapuiyafu masabudo. ");
INSERT INTO agg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ranɨyu ranɨ-sɨmboanɨ piyu haya Sudas ai Sisasɨmbo ahamundɨ warühɨ yirümofi hohoanɨmo tümarandɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Adükarɨ si bret yis pefe-koate weaŋgurühɨ tüküfeyoambe ranɨ sɨmboanɨ Sisasɨmbo süŋgururü-rundeimbɨ ai tüküyafu ahambo düdururühɨ yahomoya, “Nahanɨnɨyo sesesɨ sesɨ ra ro sɨhambo dɨdɨboadofembo se hohoanɨmoayafa?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ranɨyu asu Sisas ai ahamumbo yare hoafɨyupurühɨ yahuya, “Ŋgoafɨ adükarɨ ranühɨ anɨmbo ŋgomo, nindou mamɨ ranahambo hoafɨndɨmondühɨ anɨmboya, ‘Nindou yamunde-randeimbɨ ai yare hoafɨyuhü-randeimbɨ ai yare hoafɨyuhü yahuya, “Wandɨ si ndeara tüküfemboane, ŋga ro wambo süŋgurundɨrɨ-rundeimbɨ babɨdɨ sɨhafɨ worambe Pasofa sesesɨndefo sefɨmboanefɨ,” ’ mbɨsɨmo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ahandɨ süŋgururü-rundeimbɨ-memo ranai moanɨ mamɨ Sisas ai hoafɨmayupurɨ süŋgu sapo sesɨ ra dɨdɨboadomarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ndeara nɨmbambe Sisas ai ahambo süŋgururü-rundeimbɨ 12-memo ranɨ-babɨdɨ sowasümondühɨ mamarɨmo. ");
INSERT INTO agg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sesambe Sisas hoafɨyuhü yahuya, “Ro sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ nda. Sehündɨ mamɨ ai wambo hürütümbɨ-yomondɨ warühɨ yirümondandɨrɨmbui,” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ahandɨ süŋgururü-rundeimbɨ ranai ranɨ hoafɨ ra hɨmborɨyomo houmbo ŋgusüfoambe afɨndɨ hohoanɨmorapurühɨ asu ahambo ŋgorü ai düdufe, ŋgorü ai düdufeyomondühɨ yahomoya, “Adükarɨ, royahɨ? royahɨ?” memo. ");
INSERT INTO agg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ranɨyu asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Nindou mamɨ wakɨrɨhu nɨmarefɨmbo bret hɨpɨrɨ mamɨ ranambe foare haya asesu ranai-anɨmbo wambo nindou hürütümbɨ-yomondɨ warühɨ yirümondandɨrɨmbui. ");
INSERT INTO agg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Baibor ai Nindou Hondü ranahambo hoafɨmayo süŋgu ai yɨfɨndümbui. Hɨpoanɨmboembou ani nindou düdi ai Nindou Hondü ahambo nindou hürütümbɨ-yomondɨ warühɨ yirümoarirɨ. Nindou ranai ana nɨmboe hondɨ ai wakɨmarɨmɨndo, ŋga ambemboyu!” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sudas sapo ai ahambo nindou hürütümbɨ-yomondɨ warühɨ yirümorireimbɨ-mayu ranai hoafɨ karɨhoeihü ahambo düdurirühɨ yahuya, “Nindou yamundo-randeimbɨ, awi se yaro hohoanɨmoyafühɨ rombayahɨ safɨmboyafɨ?” mehundo-amboyu. Asu Sisas ai ahambo hoafɨyundühɨ yahundoya, “I sapo se hoafɨmayafɨ mbɨsesɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ai mamɨ sowasümondühɨ nɨmarɨmombo Sisas ai bret bɨdɨfɨrɨ ra semündü Godɨmbo hɨhɨfɨrürɨ dɨdɨbafɨfi mbura hɨfɨtɨre haya ahambo süŋgururü-rundeimbɨ ranahamumbo sagapurühɨ yahuya, “Ndanana wandɨ fi safane, ŋga sowandümo mburu sowasümo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ranɨyu ai asükaiyu hɨpɨrɨ ra semündü haya Godɨmbo hɨhɨfɨrürɨ mbura sagapurühɨ yahuya, “Muŋguambo se hɨpɨrɨ ndanambe ndɨmɨndɨmo. ");
INSERT INTO agg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ndanana wandɨ horane, sapo Godɨndɨ hoafɨ femɨndɨ sɨhefe ŋgɨnemɨndɨmbo moatükunane. Wandɨ horɨ ra nindou afɨndɨ ahei moaruwai hohoanɨmo-ambeahɨndɨ aboedambo-fembohünda kamefoendane. ");
INSERT INTO agg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ro nda sɨhamumbo hoafehapurɨ, ro wain hoe nda ŋgɨrɨ asükainda ndɨmɨndɨhɨ, ŋga awi ŋga ŋgambo wandɨ Ape ŋgɨnɨndɨ hɨfandɨrandɨ ranambeyahɨ anɨmbo ro sɨmborɨ wain hoe ra se-babɨdɨmbo ndɨmɨndɨmboyahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ranɨyomo asu ai herü mamɨ herüyomo mburu Orif nɨmɨ wafunambo mahafomo. ");
INSERT INTO agg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ranɨyu asu Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Ndanɨ nɨmbokoanɨ ana muŋguambo se wambohündambo sɨhamundɨ anɨhondümbofe hohoanɨmo hɨnɨŋgɨndumboemo. Sapo Baibor ai yare hoafɨyowohü yahoya, ‘Ro sipsip hɨfandɨra-randeimbɨ nindou ranahambo hɨfokoandɨhinanɨ anɨmbo asu sipsip ranai buküründei wakɨndɨhimboyei,’ meho süŋgu. ");
INSERT INTO agg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ŋga asu süŋgunambo ro yaŋgɨrɨ botɨndahe heheambo ana, Gariri hɨfɨnambo sɨhamundɨ wagabe ro boatei ŋgümboyahɨ,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ranɨyu Pita ai hoafɨ karɨhoeihü Sisasɨmbo hoafɨyundühɨ yahuya, “Muŋguambo nindou sɨhambohünda ahamundɨ anɨhondümbofe hohoanɨmo hɨnɨŋgarundɨ amboanɨ asu roana ŋgɨrɨ wandɨ anɨhondümbofe hohoanɨmo hɨnɨŋgɨndɨheandɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Asu Sisas ai Pitambo hoafɨyundühɨ yahuya, “Pita, ro nda sɨhambo anɨhondümboanahɨ hoafehanɨnɨ, nɨmbokoanɨ kakaro ai hoafɨ-koateayuambe anɨmbo se rando hoafɨndafühɨ anɨmbo ŋgɨmɨmbo ‘Ro moai Sisasɨmbo fɨfɨrɨhinɨ,’ mbɨsamboyafɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ranɨyu Pita ai sɨmborɨ hoafɨyunduhɨ yahuya, “Ro sedɨbo yɨfayahɨ amboanɨ i ambe, ŋga asu ro ŋgɨrɨ randɨhe yahurai hoafɨndahɨ,” mehu. Ranɨyomo asu ahambo süŋgururü-rundeimbɨ-memo muŋgu amboanɨ maru Pita hoafɨmayu süŋgu yaru hoafɨmemo. ");
INSERT INTO agg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ranɨyu Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨ nɨmɨ nümbürɨ mamɨ Getsemanihɨ hɨfomo tüküyafundühɨ hoafɨyupurühɨ yahuya, “Awi se ndanühɨ nɨmandɨmondanɨ anɨmbo asu ro gogu ranühɨ ŋga Godɨmbo dɨdɨbafɨnda,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ai Pita Sebedindɨ nɨmorɨ yimbuyafanɨ ahamumbo sepurümündɨ haya mahu. Ranɨyu Sisas ai ranɨ-sɨmboanɨ ŋgusüfo afɨndɨ hohoanɨmoyuhü asu ahambo afɨndɨ ŋgusüfoambe moaruwaimarɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ranɨyu asu ai hoafɨyupurühɨ yahuya, “Afɨndɨ hohoanɨmo wandɨ ŋgusüfoambe amaro ranai afɨndɨ hamɨndɨ tüküfendɨrühane asu ai wambo borɨfe pefendɨrɨmbo yaŋgɨrayo. Ŋga awi se ndanühɨ nɨmandɨmombo ro-babɨdɨmbo moanɨ hɨmboarɨ yaŋgɨrɨ hɨbadundɨ,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ranɨyu asu ai akɨdou sühüfi hu ahandɨ mbɨro ra hɨfɨnɨ hɨfambe amofihü Godɨmbo dɨdɨbafɨyuhü yahuya, “Wandɨ Ape, nüŋgurɨhɨ refemboayo ana, moanɨ yahurai tɨŋɨrɨfombü hɨpɨrɨ wandɨ wamɨnɨndɨ ra sowandɨfɨ raguanamboro! Ŋga asu ranɨ-moatükunɨ refembo ra ro randɨhea sambo hohoanɨmoyahühɨ-yahɨpoanɨ, ŋga moanɨ se hohoanɨmoayafɨ süŋgu,” yahu dɨdɨbafɨmayu. ");
INSERT INTO agg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ranɨyu asu ai hɨhɨrɨfi ahambo süŋgururü-rundeimbɨ ranahamumbo hoeireapurane ai yapomboyafu houmbo mapomo. Ranɨyu asu ai Pitambo hoafɨyundühɨ yahuya, “Nindou ŋgɨmɨ ra awi se nɨmboe moanɨ bodɨfombo amboanɨ ro-babɨdɨmbo hɨmboarɨ yaŋgɨrɨ hɨfandühɨ nɨmarɨ-koatememoa? ");
INSERT INTO agg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Se moanɨ hɨbadümbo dɨdɨbafɨndɨmondühɨ nɨmandɨmo. Rananɨmbo asu nɨne-moatükunɨ sɨhamumbo moaruwai hohoanɨmo ranahambo süŋgu hühɨndeapurɨmboe. Sɨhamundɨ ŋgusüfo aiana refembo yaho, ŋga asu sɨhamundɨ fi ranane ai awi mbosɨhoasɨrayo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Asükaiyu mamɨmbo Sisas hu dɨdɨbafɨfihɨ yahuya, “Wandɨ Ape, tɨŋɨrɨfombü hɨpɨrɨ ndanai wambo gübüsɨfoefendɨrɨ-koateyowanɨ, asu ro ranɨ-moatükunɨ ra asɨmɨndɨhɨ ana, sapo se nɨnɨmboyo refembo hohoanɨmoayafɨ ranɨ-süŋgu refemboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Asükaiyu hɨhɨrɨfi hu ahambo süŋgururü-rundeimbɨmbo hoeireapurane ai moanɨ mapomo. Ai moai ahamundɨ hɨmboarɨ ra yaŋgɨrɨ bɨrɨhoai nɨŋgopurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ranɨyu asu Sisas ai asükaiyu ahamumbo yare hɨnɨŋgɨreapurɨ haya ŋgɨmɨmbo noure mamɨ weaŋgurühɨ hoafɨmayu hoafɨ yahurai hoafɨyuhü dɨdɨbafɨmayu. ");
INSERT INTO agg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Asükaiyu ai ahambo süŋgururü-rundeimbɨ ranahamumbo-so tüküfi hoafɨyupurühɨ yahuya, “Awi se moanɨ fiharu apomondühɨyomoa? Awi Nindou Hondü ranahambo moaruwai hohoanɨmo-yomondeimbɨ nindou ranahamundɨ warɨhüfembo akɨmɨ tɨfɨreamboane. ");
INSERT INTO agg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Botɨyafu houmbo mborai ŋgefo. Awi se hoeiru nindou mamɨ ndanai wambo hürütümbɨ-yomondɨ warühɨ yirümoyondɨrɨmbo ndanüŋgu,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sisas ai wataporɨmborandühɨ nüŋgu ane asu Sudas, süŋgururü rundeimbɨ 12-ambeahɨndɨ nindou mamɨ, ai tükümefiyu. Godɨmbo sɨhou-rundeimbɨ bogorɨ nindouyomo asu Suda-yafe bogorɨyomo ranai nindou afɨndɨ safɨ ranahamumbo koamarɨhoupura pisao yihɨmɨndɨ asu nɨmɨharɨ adükarɨ ra fufuründümo houmbo Sudas babɨdɨmbo tükümefundɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nindou sapo Sisasɨmbo nindou hürütümbɨ-yomondɨ warühɨ yirümofimbo-mayu ranai nindou afɨndɨ ranahamumbo dɨbo hoafɨ hoafɨyupurühɨ yahuya, “Nindou ro ahambo wakɨkɨhɨndühünanɨ anɨmbo aiani, ŋga se ahambo mbundüründümo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ranɨyu asu nɨmai Sudas ai Sisasɨmbo-so hüfu hoafɨyundühɨ yahuya, “Yamundo-randeimbɨ, karɨhasɨ,” yahuhü wakɨkɨhɨmarürɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ranɨyu asu Sisas ai sɨmborɨ ahambo hoafɨyundühɨ yahuya, “Wandafɨ, ranɨ-moatükunɨ ra se refembo asafɨ, nɨmai raro,” mehundo. Ranɨyomo asu nindou afɨndɨ ranai tüküyafu Sisasɨmbo mburündümo mburu kɨkɨhɨsafɨ-marürɨndümo. ");
INSERT INTO agg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ranɨyu asu nindou mamɨ Sisas dɨbo manüŋgu ranai sɨsɨrɨfihɨyu ahandɨ pisao hoearambeahɨndɨ hüramündɨ nüŋgumboyu bogorɨ nindou, Kaiafas, ranahandɨ ratüpurɨyu-randeimbɨ-mayu ranahandɨ hɨmbohoearɨ mafoafoareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ranɨyu Sisas ai nüŋgumbo ahambo hoafɨyundühɨ yahuya, “Pisao ra se sowandɨfɨ koadürambe sando. Nindou muŋguambo düdi ai pisao asowandümo ana, asu ai pisao ranambo yɨfɨndɨmboemo. ");
INSERT INTO agg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Asu ro wandɨ Apembo wambo farɨhefendɨrɨmbohünda mɨŋgɨndahanɨ asu ai sünambeahɨndɨ nendɨ bɨdɨfɨrɨ ami 12 ŋgasündeapureimbɨ ai koarɨhefemboayu ra awi se moai fɨfɨrowandɨyo? ");
INSERT INTO agg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ŋga asu ranɨ-süŋgumbo ana, nüŋgunde sapo Baiborambe yare hoafɨyowohüya, ‘Ranɨ-moatükunɨ ra moanɨ yahurai rambɨfeyo-wamboane,’ meho ra yahurai tükümandɨfea?” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ranɨyu asu Sisas ai nindou afɨndɨ ahambo mbuimündümbo tükümefundɨ ranahamumbo hoafɨyupurühɨ yahuya, “Awi ro hümbuhünümbɨ nindou meha ranɨmbo wambo mbuimɨndɨndɨrɨmbo se pisao asu nɨmɨharɨ ra fufuründümo houmbo sɨfomomboemo? Ro afɨndɨmbo Godɨndɨ worambe nɨmarɨmbo hoafɨ yamundɨhandürɨ habodɨ marɨhandɨ, ŋga ranɨ-sɨmboanɨ moai se wambo mburündümondɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ŋga asu ranɨ-moatükunɨ ramefeyo ra Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou ai Baiborambe randɨfemboe yahu haya sürü pamareandɨ ranɨ sɨmogodühɨyo ramefeyo,” mehu. Asu muŋgu süŋgururü-rundeimbɨ ranai Sisasɨmbo hɨnɨŋgɨrüwurɨ houmbo mafoarɨhoemo. ");
INSERT INTO agg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Godɨmbo sɨhou-rundeimbɨ bogorɨ hondü, Kaiafasɨyu ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨyomo asu bogorɨ nindouyomo ranai guguru mamühɨyafu mamarɨmo. Ranɨyomo asu nindou ranai Sisasɨmbo mburündümo houmbo nindou gugurɨyafu nɨmarɨmondühɨ worɨna sowaründümo mahomo. ");
INSERT INTO agg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita ai ahambo süŋgumarürɨ hüfu, ŋga asu ai moai ahandɨ fikɨmɨ akɨmɨ papühɨfiyu, ŋga ai Kaiafasɨndɨ worɨ ginɨrɨ-mayo ranambe kefuoai hüfu hɨfandɨ-rundeimbɨ-memo ranɨ-babɨdɨmbo mamaru. Ai nɨnɨ-moatükunɨ Sisasɨmbo tükümandɨfendo yahu haya ranɨ hɨmboasafomboyu. ");
INSERT INTO agg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Godɨmbo sɨhou-rundeimbɨ bogorɨ asu muŋguambo Suda-yafe kansɨr ai Sisasɨmbo hɨfokoefimbo-hündambo nindou ahambo tɨkefehefembo papɨ-hoafɨfimbo kokomarurü. ");
INSERT INTO agg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Nindou afɨndɨ ai tüküyafundühɨ Sisasɨmbo tɨkefehefe papɨ-hoafɨfimbosɨ, ŋga asu ai moai nɨne moaruwai hohoanɨmo ramareandɨ ra mamɨ amboanɨ ahambo hɨfokoefembo-hünda fɨfɨrɨrundɨ. Ndeara bɨdɨfɨranambo hondü nindou yimbu ai botɨyafɨne hafanɨ hoafɨyafɨnandowohü safanɨya, “Nindou ndanai yare hoafɨyuhɨ yahuya, ‘Ro Godɨndɨ worɨ nda bɨrɨboadɨhe mbundɨha asu moanɨ ŋgɨmɨ sihɨ yaŋgɨrɨ asükainda fondɨhe hɨnɨŋgɨndɨheamboyahɨ,’ mehu,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ranɨyu asu Godɨmbo sɨhou-rundeimbɨ-yomondɨ bogorɨ hondü ranai botɨfi nüŋgumbo Sisasɨmbo hoafɨyunduhü yahundoya, “Se moai nɨnɨ hoafɨ sɨmborɨ nindou sɨhambo papɨ-hoafɨmarɨnanɨnɨ ranahafanɨmbo hoafɨyopɨrɨmbo sɨhawandɨyo?” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ŋga asu Sisas ai moai nɨnɨ hoafɨ ahambo sɨmborɨ hoafɨyundo, ŋga moanɨ ai sɨsɨkoate manüŋgu. Asükaiyu bogorɨ nindou-mayu ranai ahambo hoafɨyundühɨ yahuya, “God yaŋgɨrɨ nüŋgumbü-mayu ranahandɨ ndürɨnambo ro nda sɨhambo hoafɨyahanɨnɨ, ŋga hapo se nɨmoamo nda dabarɨfimbɨ hoafɨ sɨmborɨ hoafɨndafɨ. Se Krais, Godɨndɨ Nɨmorɨndafühɨ ana, haponda hamɨndɨ yɨhoefɨmbo hoafɨndafɨmunɨ,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Asu Sisas ai ahambo sɨmborɨ hoafɨyundühɨ yahuya, “Ndeara se ranɨ hoafɨ ra hoafɨyafomboanafɨ. Ŋga ro sɨhamumbo muŋguambo hoafehapurɨ nda. Ŋgɨrɨ amɨtata Nindou Hondü ranai bogorɨmbondüfi God muŋguambo ŋgɨnɨndeimbɨ ranahandɨ warɨhondanɨ nɨmandü asu ai mburüŋgaiwamɨ sünambeahɨndɨ kuduanɨ hoeindüwurümboemo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ranɨyu asu bogorɨ nindou-mayu ranai ŋgusüfoambe hüfɨrürühɨ ahandɨ hoearɨ ra hɨreandühɨ hoafɨyuhü yahuya, “Ai Godɨmbo tɨrɨfoefe hoafɨ hoafayu. Hapondanɨ ana nindou ŋgorü ai Sisas ranahambo nɨne hoafɨ hoafombo tüküfepoanɨ, ŋga wanɨ. Se ndeara ai Godɨmbo tɨrɨfoefe hoafɨ hoafɨmayu ra hɨmborɨyomombo-anemo! ");
INSERT INTO agg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Asu se ra ahambo nüŋguru hohoanɨmoyomondühɨyomo-a?” mehupuramboemo. Asu ai sɨmborɨ hoafɨyomondühɨ yahomoya, “Ai ana sapo ai hüti ramefiyumbowambo yɨfɨyumbiyuwamboane,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Ranɨyomo asu ai ahandɨ ŋgusümboarambe ŋgurɨ tɨfɨyafundowohü bubumarürɨ. Asu nindou bɨdɨfɨrɨ ai pakarɨhourühɨ hoafɨyomondühɨ yahomoya, “Krais, se nindou düdi ai sɨhambo harayunɨnɨ ranahambo Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nahurai hoafɨndafɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ai weindanɨ ranɨ hɨfɨnɨ ginɨrambe nɨmaru-ane Godɨmbo sɨhou-rundeimbɨ bogorɨ hondündɨ ratüpurɨyo-randeimbɨ mamɨ ranai ahambo-so tüküfe hɨfo hoafɨyohü yahoya, “Se-amboanɨ Sisas Garirihündɨ ranɨ dɨbomefoandane,” mehondoamboyu. ");
INSERT INTO agg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Asu muŋguambo ahei hɨmboahü ai wanɨ yahuhüya, “Roana se wataporɨmbo arandɨ ranahambo moai fɨfɨrɨheandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ranɨyu asu ai ginɨrɨ-mayo ranɨ nafɨtambekɨmɨ mapenüŋgu. Ranɨyo asu nɨmorehɨ ŋgorü ai hoeirerühɨ nindou burɨmemo ranahamumbo hoafɨyohü yahoya, “Nindou aiyu Nasaretɨhündɨ Sisas ranɨdɨbo manüŋgu,” meho. ");
INSERT INTO agg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Asükaiyu Pita ai wanɨ yahumbo hoafɨyuhü yahuya, “Roana haponda dabareheandɨ, ro nindou ranahambo ana moai fɨfɨrɨhinɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Akɨdou hɨhɨnɨŋgɨre safoareambo nindou ranühɨ burɨmemo ranai Pitambo-so tükümefundɨ. Ai yaru hoafɨyomondühɨ yahomoya, “Se ana ai-babɨdɨhɨndɨ nindou-anafɨ. Ŋga sɨhafɨ hoafɨ hoafayafɨ ranai Garirihündanafɨ yaho weindahɨmareanɨnɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ranɨyu Pita ai dabarɨfihɨ hoafɨyuhü yahuya, “Ro tɨkai hoafɨndahanɨ God ai wambo moaruwaimbo-mbɨreandɨra-mboane! Ŋga roana nindou ranahambo moai fɨfɨrɨhinɨ,” mehu. Ranɨyo asu kakaro ranai hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Asu Pita ai ŋgusüfo pumaramündu sapo nɨne hoafɨ Sisas ai ahambo hoafɨmeindo ranahambo. Sapo ai yare hoafɨyuhü yahuya, “Kakaro ai hoafɨ-koateayuambe anɨmbo se ŋgɨmɨmbo rando wambo hoafɨndafühɨya, ‘Ro moai ahambo fɨfɨrɨhinɨ,’ mbɨsamboyafɨ,” mehundo ranɨmbo. Ranɨyu asu Pita ai ginɨrambeahɨndɨ tüküfi haya afɨndɨ hamɨndɨ aranɨ aranɨmayu. ");
INSERT INTO agg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ndeara siambe hondü Godɨmbo sɨhou-rundeimbɨ bogorɨyomo asu Suda-yafe bogorɨ nindouyomo ranai Sisasɨmbo hɨfokoefimbo hoafɨ ra fɨfɨrɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ranɨyomo asu Sisas ahambo hüputüpurɨhou sowaründümo hɨfomo Romɨ-yomondɨ Israer hɨfɨ hɨfanda-randeimbɨ bogorɨ nindou ahandɨ ndürɨ Pairatɨndɨ warühɨmarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Asu Sudas sapo Sisasɨmbo hürütürümbɨ nindou-yomondɨ warühɨmarirɨ ahambo papɨ hoafɨyu hɨfokoefimbo hoafɨ ra hɨmborɨmayu. Ranɨmboane ŋgusüfoambe afɨndɨ hohoanɨmoyuhü ai kakɨ hoarɨ 30 ra hɨhɨre semündü hu Godɨmbo sɨhou-rundeimbɨ bogorɨyomo asu bogorɨ nindouyomo ranahamumbo masagapurɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ranɨyu asu Sudas ai ahamumbo yare hoafɨyuhü yahuya, “Awi ro hütiyahɨ moaruwai hohoanɨmomayahɨ. Ro nindou ai nɨnɨ-moatükunɨyo moaruwai refekoate ranahambo nindou hürütümbɨ-yomondɨ warühɨ yirümomarɨhinɨ,” mehuamboemo. Asu ai sɨmborɨ ahambo hoafɨyomondühɨ yahomoya, “Awi ro ranahambo ra nɨmboe mambɨsefɨyo? Ranɨ-moatükunɨ ra yɨhoefɨ moatükunɨyo, ŋga sɨhafɨ moatükunɨ yaŋgɨrane ranana,” mehomondo. ");
INSERT INTO agg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ranɨyu asu Sudas ai kakɨ hoarɨ-mayo ra Godɨndɨ worɨ ranambe pire haya ndamefiyu. Ranɨyu asu ai hu wofɨfihɨ kiarü ahandɨ fi ra ahandɨhoarɨ hɨfokoamareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ranɨyomo asu Godɨmbo sɨhou-rundeimbɨ ranai kakɨ pimareandɨ ra fufuründümo houmbo hoafɨyomondühɨ yahomoya, “Kakɨ ndanana nindou hɨfokoamefiyu ranahandɨ horɨ takɨnɨ kakane. Sapo sɨhefɨ ahɨnümbɨ hohoanɨmo süŋgumbo Godɨndɨ worambeahɨndɨ kakɨ gugurɨfe sɨhefe arandɨ ranambe pefepoanɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kakɨ ranahambo wataporɨmboru homo mamɨ nɨmɨndühɨru sɨhoemo houmbo asu ai kakɨ ranambo hɨfɨ mamɨ ahandɨ ndürɨ Hɨfɨ Sospen Nafɨmbo Hɨfɨ pemayomo. Hɨfɨ ra aŋgunpoedɨ nindou yɨfɨyeianɨ hɨfɨkefendürɨmbo hɨfane. ");
INSERT INTO agg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ranɨmbohündamboane haponda hɨfɨ ranahambo rarɨhi dükarɨhindühɨya Nindou Horɨ Hɨfane, sei arɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Godɨndɨ hoafɨ hoafɨyu-randeimbɨ mamɨ, Seremaia, ai hoafɨmayu sɨmogodühɨ rahurai tükümefeyo. Ai yare horombo hoafɨreandühɨ yahuya, “Ai kakɨ hoarɨ 30 ra masowandümo sapo Israer nindou bɨdɨfɨrɨ ai horombo hoafɨmayu süŋgu ai nindou ranahambo pemɨmbohünda. ");
INSERT INTO agg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ranɨyo asu kakɨ ranambo Hɨfɨ Sospen Nafɨmbo Hɨfɨ ra pemɨmemo. Ranɨ hoafɨ ra Adükarɨ ai wambo randowandɨ mehu nou ane,” mehu. Asu moanɨ anɨhondü ranɨ yahurai safɨ tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sisas ai Romɨ-yomondɨ bogorɨ nindou, Pairat, ranahandɨ hɨmboarühɨ manüŋgu. Ranɨyu asu Pairat ai ahambo düdurirühɨ yahuya, “Se ra Suda-yomondɨ adükarɨ bogorɨ nindouyafɨ?” mehundo-amboyu. Asu Sisas ai sɨmborɨ ahambo hoafɨyundühɨ yahuya, “Se ndeara raro hoafɨyafomboanafɨsɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Godɨmbo sɨhou-rundeimbɨ bogorɨ nindouyomo asu bogorɨ nindouyomo ranai awi ahambo papɨ-hoafɨrürɨ hoaŋgomosɨ, ŋga asu Sisas ai moai nɨnɨ hoafɨ akɨdou ahandɨ yahamo tüküfendo. ");
INSERT INTO agg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ranɨyu asu Pairat ai ahambo hoafɨyundühɨ yahundoya, “Awi se moai hoafɨ ra hɨmborɨyafɨyo sɨhambo ai papɨ-hoafarunɨnɨ ranahambo rana?” mehundo. ");
INSERT INTO agg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ŋga asu Sisas ai sɨmborɨ mamɨ hoafɨ akɨdou-amboanɨ hoafombo moai hoafɨyu. Ranɨyu asu Romɨ-yomondɨ bogorɨ nindou-mayu ranai moanɨ adükarɨ hamɨndɨ hepünɨfe mahepünɨfiyu. ");
INSERT INTO agg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Muŋgu hɨmbanɨ Pasofa adükarɨ si tüküfeyoambe, muŋguambo nindou ranai nindou karabusambeahɨndɨ hɨnɨŋgɨfiyuwanɨ aboedühɨ tüküfembo hohoanɨmoyei marɨhündɨ. Ranahambo ana Romɨ-yomondɨ bogorɨ nindou ranahamboyo hoafɨyeianɨ ai nindou ranahambo aboedühɨ koarɨheirɨ marandɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ranɨ-sɨmboanɨ ana, muŋguambo nindou ai fɨfɨrɨhoreimbɨ nindou ahandɨ ndürɨ Barabas ai karabusambe manüŋgu. ");
INSERT INTO agg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Asu ranɨ-sɨmboanɨ nindou afɨndɨ ranai gugurɨyahi mamareiamboyu Pairat ai aheimbo düdureandürühɨ yahuya, “Se ra nindou daboe ro ahambo karabusambeahɨndɨ aboedühɨ koarɨhefimbo hohoanɨmoayeia? Barabasɨyu asu Sisas ranahambo Kraisani sei arɨhündɨ ranɨyu?” mehu. ");
INSERT INTO agg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ŋga Pairat Suda nindou Sisasɨmbo ŋgusüfoambe moaruwairürühɨyomo wandɨ warühɨmarurü yahu haya ai ranɨmbo ndore fɨfɨrɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pairat ai nindou hoafɨ yɨboboferambo worɨ safambe nɨmaru-ane, ahandɨ nɨmorehɨ ai hoafɨ koarɨhendühɨ yahoya, “Nindou ra nɨnɨ-moatükunɨyo ai refe-koatemayu ranahambo hoafɨ ana moai yaŋgoro, ŋga se ahambo nɨnɨ-nüŋgundorɨmboyafɨ. Hamanɨ nɨmbokoanɨ ro ahambo yafogoadɨnambo hoeirɨhinɨ hehea hɨdɨdɨmo apoyahühɨ afɨndɨ hohoanɨmomayahɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ŋga Godɨmbo sɨhou-rundeimbɨ bogorɨyomo asu bogorɨ nindou-memo ranai-yomo ai nindou afɨndɨ ranühɨ meŋgoro ranaheimboya “Se hoafɨndeianɨ anɨmbo Pairat ai Barabasɨmbo aboedühɨ koarɨheirühɨ asu Sisasɨmbo hɨfokoambɨriramboane,” yahomo houmbo aheimbo hohoanɨmombo ŋgusüfoambe botɨmarundürɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Asu Pairat ai nindou afɨndɨ ranaheimbo düdufindürühɨ yahuya, “Se nindou yimbu ra nindou daboeyei ro ahambo karabusambeahɨndɨ aboeda koarɨhefimbo hohoanɨmoayeia?” mehundüramboyei. Asu ai sɨmborɨ ahambo hoafɨyahündowohü seiya, “Barabasɨmbo,” masei. ");
INSERT INTO agg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Asu Pairat ai hoafɨyundürühɨ yahuya, “Asu refe ana, Sisasɨmbo Krais sei arɨhündɨ ranahambo ra nüŋgumandɨhina?” mehuamboyei. Sɨmborɨ muŋgu ai ahambo hoafɨyeihü seiya, “Nɨmɨfihɨ tokoemündɨ pefimboani,” masei. ");
INSERT INTO agg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Asu Pairat ai aheimbo düdufindürühɨ yahuya, “Nindou ndanai nɨne-moatükunɨ moaruwai ramareanda?” mehuamboyei. Asu ai moanɨ puküna hoafɨ nɨmoamo karɨhehindühɨ hoafɨyeihü seiya, “Nindou ranahambo nɨmɨfihɨ tokoemündɨ pefimboani,” masei. ");
INSERT INTO agg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pairat ai ndare hoeireandane hoafɨ ranahambo wataporɨmboyo hombo ra wanɨyowohü ai ro ŋgɨrɨndahɨ, ŋga yifiarɨ tükündüfihü hoafɨ afɨndɨ yagodomboe mehu. Ranɨyu asu hoe fuiyamündɨ haya nindou ranahei hɨmboahü warɨ ahandɨ ra popoaifoareandühɨ hoafɨyuhü yahuya, “Nindou ndanɨ ahandɨ yɨfɨ ra i ro hütirühünɨpoanɨ, ŋga ranɨ moatükunɨ ra sɨheihoaranei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ranɨyei asu nindou afɨndɨ muŋguambo ranai sɨmborɨ ahambo hoafɨyeihü seiya, “Ai hüti yɨfɨmboayu ranɨ-moatükunɨ ra yɨhoefane asu yɨhoefɨ nɨmorɨ ranahei ane!” masei. ");
INSERT INTO agg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ranɨyu Pairat ai Barabasɨmbo aboeda koamarɨheira aheimbo sowana mahu. Ranɨyu asu ai Sisasɨmbo daboadanɨ ndüfurɨ-ndüfurɨfoarüwurɨ mehua ahambo nɨmɨfihɨ tokoemündü pefimbohünda ami-yomondɨ warɨhümarirɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ranɨyomo asu Pairatɨndɨ ami ai Sisasɨmbo sowaründümo gafmanɨ yomondɨ worɨ ranambe mahɨfomondamboemo, asu muŋguambo ami nindou ranai Sisasɨmbo wakɨmarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ranɨyomo asu ai ahandɨ hoearɨ ra yimɨndɨbadɨ houndowohüyomo asu hamburɨ hoearɨ hoandarɨ ra magüdündo. ");
INSERT INTO agg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ranɨyomo asu ai wofɨ tɨhoarɨ-tɨhoarümbɨnambo mbɨroambe kɨkɨmafoarundɨ. Asu nɨmɨharɨ sowandümo ahandɨ warɨhondü waranɨ waramberundühɨ yimɨndɨho pusɨru nɨmarɨmondühɨ ahambo tɨkɨfɨnamborüwurühɨ hoafɨyomondowohü yahomoya, “Suda-yafe adükarɨ bogorɨ, karɨhasou-anafɨ,” mehomondo. ");
INSERT INTO agg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ranɨyomo asu ai ahambo ŋgurɨ tɨtɨfɨyomondowohü ahandɨ warambeahɨndɨ nɨmɨharɨ-mayo ra kosɨründümo ahambo mbɨhapɨrɨ kakɨmarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ai ahambo tɨkɨfɨnamborüwurɨ tɨrɨfoefe hoafɨyomondo mburumboemo asu ahandɨ fihɨndɨ hamburɨ hoearɨ hoandarɨ-mayo ra yimündündümo-ndühɨyomo asu hoearɨ ahandɨ hondü ra sowandümo güdu hɨnɨŋgɨmarundo. Ranɨyomo asu ai ahambo nɨmɨfihɨ pefi hɨfokoefimbohünda sowaründümo mahomo. ");
INSERT INTO agg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ahambo sowaründümo hou homondühɨyomo asu ai nindou mamɨ Sairinihündɨ, ahandɨ ndürɨ Saimon, ranahambo hoeimarɨhorɨ. Ranɨyomo asu ai nindou ranahambo Sisasɨndɨ nɨmɨ keimbɨ karɨhendeimbɨ-mayo ra sowandɨfɨndo yahomo houmbo hüti-hütimarurü. ");
INSERT INTO agg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ranɨyomo ai homo Gorgotahü tükümefundɨ. Gorgota ranahamboane ai mbɨhapɨrɨ nahurai hɨfɨ sei arɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ranɨ hɨfɨhüyomo ami ai Sisasɨmbo wain hoe hühütimbü moatükunɨ fandu yamundu mburu masabudo. Asu Sisas ai ranɨ-moatükunɨ ra sümündü hoeireanda mayoa asu ai moai sümündu. ");
INSERT INTO agg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ranɨyomo ai ahambo nɨmɨ keimbɨ karɨhendeimbɨfihɨ parüwurɨ hou asu ai ahandɨ-mayo hoearɨ ra ahamundɨ mbusümo sowandümo yɨboborundümo hou ranambo ŋgorü ai mbɨsemündua yahomo houmbo piraimemo. ");
INSERT INTO agg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ranɨyomo asu ai raraoyafu mburu ranühɨ nɨmarɨmo Sisas ahambo yɨfɨmbiyu yahomo houmbo homo hɨmboana wamarurü. ");
INSERT INTO agg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ahandɨ mbɨro wafusɨfohü ahambo papɨ-hoafɨ sürü papɨru mburu tɨkoründɨmo pamarundɨ ranai yare hoafɨyohü yahoya, NDANANA SISAS SUDAYAFE BOGORƗ ADÜKARƗ NINDOUANI, yahomo paru hɨnɨŋgɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ranɨyomo asu ai nindou yimbu hümbuhünɨyafanɨ-rɨnandeimbɨ ranahafanɨmbo Sisas babɨdɨ ahandɨ fikɨmɨ pamarupɨrɨ. Ŋgorü Sisasɨndɨ warɨhondü waranɨ parüwurɨ asu ŋgorü kadüdü waranɨ parüwurɨ marupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Ranɨyei nindou afɨndɨ ranai hei ŋgasündɨhorɨ hei rühündühɨ mbɨro hɨrɨhɨrɨhündühɨ ahambo tɨrɨfoarɨhorühɨ hoafɨyahündowohü sahündoya, “Sapo se Godɨndɨ worɨ ra bɨrɨfoefe mburumbo moanɨ ŋgɨmɨ sihɨ yaŋgɨrɨ fondɨfe hɨnɨŋgɨfembo mayafɨyosɨ! Se Godɨndɨ nɨmorɨyafühanasɨ, se sɨhafɨhoarɨ yaro aboedamboyafosɨ. Se ndahonɨ nɨmɨ keimbɨ karɨhendeimbɨ-fihɨndɨ hɨfɨna foarefoao peyafɨsɨ!” sei hoafɨmehündo. ");
INSERT INTO agg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nindou ai ramehindɨ ranɨ-süŋgu yahurai Godɨmbo sɨhou-rundeimbɨ bogorɨ nindou, ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ asu ranɨhündambo bogorɨ nindou ranai-amboanɨ yaru tɨkɨfɨnambo-rüwurühɨ tɨrɨfoarüwurühɨ yahomoya, ");
INSERT INTO agg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Sisas ai nindou bɨdɨfɨramboyu ai aboedamboreandürɨ marandɨ, ŋga asu ai ŋgɨrɨ ahandɨ fimbo ana aboedambondeandɨ! Awi aiana Israerɨ-yafe adükarɨ bogorɨmbeipoanɨ! Asu ai haponda nɨmɨ keimbɨ karɨhendeimbɨ ranɨ-fihɨndɨ hɨfɨnɨ akusɨfoendɨ ana, asu ro ahambo anɨhondümbo-ndɨhurɨmboyefɨ! ");
INSERT INTO agg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ai Godɨmbo anɨhondümborirühɨ Ahandɨ nɨmoranahɨ mehu. Refeanasɨ, awi sɨhɨrɨ hoeindɨhu God ai ahambo farɨhefimboayu ranahambo,” mehomondo. ");
INSERT INTO agg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Asu nindou hümbuhünɨyafanɨ-rɨnandeimbɨ Sisasɨndɨ fikɨmɨ mapaiarɨfanɨ amboanɨ ai mare moanɨ nindou bɨdɨfɨrɨ ai ramarɨhorɨ nou yahurai rarɨnerɨ tɨrɨmafoarɨnerɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Refe hayamboyo-ane hüfɨnɨmbo peyo haya hɨfɨ muŋgu ranai nɨmbɨ nɨmarɨ ho ho hombo nɨmbambe hondü hüfɨwuyuambe tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hüfɨwuyuambe safɨ sɨmogodühɨ Sisas ai puküna heiyuhü yahuya, “Eri, Eri, rema, sabaktani?” mehu. Ranɨ hoafɨ ra yare yahurai hoafɨyowohü yahoya, “Wandɨ God, wandɨ God, se nɨmboe wambo hɨnɨŋgɨro-wandɨrɨmboayafɨ?” meho. ");
INSERT INTO agg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nindou bɨdɨfɨrɨ ranühɨ manɨmboei ranai ranɨ hoafɨ ra hɨmborɨyei hehi hoafɨyeihü seiya, “Nindou ranai ana Erais-amboani dükarirɨ mɨŋgayundo,” masei. ");
INSERT INTO agg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nɨmai nindou mamɨ ahei mbusümo ranai pɨpɨyu hu worapo-worapoyoweimbɨ moatükunɨ nou semündü mbura nɨmɨharɨfihɨ pare hɨmondamündü mbura hühütimbü wain hoe ranambe foare hüramündɨ haya Sisas ai ranɨ moatükunɨ ra mbɨsümündu yahu haya segodɨmbo mehu. ");
INSERT INTO agg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ŋga asu bodɨmondɨ ai hoafɨyahündowohü seiya, “Awi, hoeindɨhu mbundɨhumbo Eraisa ai ahambo farɨhefembo tükümandɨfiyu wanɨmandɨyo,” masei. ");
INSERT INTO agg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ranɨyu asu Sisas ai asükaiyu puküna heiyuhü ahandɨ yifiafɨ hɨnɨŋgɨrirühɨ nɨmokomayu. ");
INSERT INTO agg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ranɨyo asu Godɨndɨ worɨ safambe hoearɨ yipurɨ nafɨtambehü mahetaro ranai nɨmoamo ŋgahɨ peyo haya hanɨ hɨfɨnɨ gebü türeandühɨ yimbu kɨkɨmareandɨ. Hɨfɨ ai fɨfɨmɨyowohüyo muŋguambo nɨmoei ranai gübüdümarɨhoayo. ");
INSERT INTO agg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yɨfambe ranai nafɨtambe tihoai-tihoairandühɨ asu Godɨndɨ nindou afɨndɨ horombo yɨfɨsafɨmayei ranai yaŋgɨrɨ botɨyahi-botɨyahi marɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ai yɨfambe ra hɨnɨŋgɨrɨhi hehi Sisas yaŋgɨrɨ asükaiyu botɨmefiyu ranɨ-süŋgunambo ai Sürühoeimbɨ Ŋgoafɨ adükarɨ (Serusarem) ranɨna mahei. Ranɨyo nindou afɨndɨ ranai aheimbo ranühɨ hoeimarɨhindürɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ami-yomondɨ bogorɨyu asu bɨdɨfɨrɨ amiyomo ranai ai-babɨdɨmbo nɨŋgomombo Sisasɨmbo hɨmboanawarürühɨ manɨŋgomo ranai sapo hɨfɨheyowohü asu muŋguambo moatükunɨ tükümefeyoa hoeimarundɨ ranɨmbo yɨhɨmboyomondühɨ hoafɨyomondühɨ yahomoya, “Awi aiana Godɨndɨ Nɨmorɨ hondüyu,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nɨmorehɨ afɨndɨ bɨdɨfɨrɨ Gariri hɨfɨ hɨnɨŋgɨrɨhi hehi Sisasɨmbo farɨhefimbo süŋgumarɨhorɨ masühüsi-mayei ranai burɨyei. Ai moai akɨmɨ papühüyahindɨ, ŋga moanɨ aŋgunɨ goagu safɨ nɨmboeimbo hɨmboarɨ papɨmayei. ");
INSERT INTO agg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nɨmorehɨ burɨmayei ranahei mbusümo ra ŋgorü Maria Makdarahündɨyo, ŋgorü ra Maria Sems Sosepɨyafandɨ hondɨyo asu sapo Sebedindɨ nɨmorehɨyo rarɨhi ai manɨmboei. ");
INSERT INTO agg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ndeara nɨmbambe nindou napo afɨndeimbɨ ahandɨ ndürɨ Sosep Arimateahündɨ-mayu ranai tükümefiyu. Nindou ranai-amboanɨ Sisasɨmbo süŋgurürɨ-randeimbɨ nindouyu. ");
INSERT INTO agg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ai hüfu Pairatɨndɨ hɨmboahü tüküfi nüŋgumbo Sisasɨndɨ yɨfɨnɨmoko ranahambo ndahamɨndɨ yahu haya düdumefindo. Ranɨyu asu Pairat ai Sisasɨndɨ yɨfɨ-nɨmoko ra Sosepɨmbo dabudo mehu. ");
INSERT INTO agg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sosep ai yɨfɨ-nɨmoko serümündü mbura sɨmborɨ kɨfohɨ hoearɨfihɨ parirɨ hɨmondɨmarirɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ranɨyu ai ahandɨ hoŋgu nɨmoei ŋgɨnɨndambe sɨmborɨ nafɨrɨhai hɨnɨŋgɨmareandɨ ranambe masɨherü. Ai nɨmoei yɨtɨfo afɨndɨ ra gügürɨhai nafɨtambembo güre pare mbura ndamefiyu. ");
INSERT INTO agg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ranɨ-yafe Maria Makdarɨhündɨ-mayo ranaiyo asu ŋgorü Maria-mayo ranaiyo ai hoŋgu ra haŋgɨfohü mamarɨfe. ");
INSERT INTO agg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Ŋgorü sina moanɨ nɨmarɨmbo si tüküfeyoambe Godɨmbo sɨhou-rundeimbɨ bogorɨyomo asu Farisi nindouyomo ranai Pairat babɨdɨ mamühɨyafu fandu nɨmarɨmo hoafɨyomondühɨ yahomoya, “Nindou adükarɨ, ro hohoanɨmoyefɨmboanefɨ hoafɨ mamɨ sapo nindou wosɨhoaforɨ hoafümbɨ-mayu ranai yare hoafɨyuhüya, ‘Ro ŋgɨmɨ sinda mbundɨha asu asükainda yaŋgɨrɨ botɨndaheamboyahɨ,’ mehu ra! ");
INSERT INTO agg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ranɨmbohündambo anɨmbo asu se hoafɨndafanɨ hoŋgu ra ndore ŋgɨnɨndɨ hɨfandɨyo ho ŋgɨmɨ si ranühɨ tüküfemboane. Rananɨmbo asu ahambo süŋgururü-rundeimbɨ ranai ŋgɨrɨ ahandɨ finɨmoko ra dɨbo hümbuhünɨmbo ndowandümo houmbo asu ai nindou ranaheimbo hoafɨndɨmondühɨya, ‘Ai yɨfɨhündɨ yaŋgɨrɨ botɨmefiyu,’ mbɨsɨmo. Süŋgunambo wosɨhoaforɨ hoafɨ ranai asu horombo wosɨhoaforɨ hoafɨmayu ranahambo ŋgasündeamboe,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ranɨyu asu Pairat ai ahamumbo hoafɨyupurühɨ yahuya, “Se hɨfandɨru-rundeimbɨ nindou bɨdɨfɨrɨ sowapundümo houmbo ŋgomo moanɨ hoŋgu ambe ra ŋgɨnɨndɨ hamɨndɨ papɨ papɨndu hɨnɨŋgɨndundɨ,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ranɨyo asu ai ranɨhünda botɨyafu homo hoŋgu ambe ranahambo yowanɨ yahomombo paru hɨnɨŋgɨru houmbo asu nindou bɨdɨfɨrambo hɨfandɨyo nɨmarɨmbo hɨnɨŋgɨmarupurɨ. ");
INSERT INTO agg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Moanɨ nɨmarɨmbo si ranai muŋguyo ane, asu weaŋgurühɨ sihɨ hapoadümbo siambe hondü hüfɨhamɨndɨ sɨfo-koateyuambe, Maria Makdarahündɨyo asu ŋgorü Maria ranaiyo ai hoŋgu Sisas yaŋgurümbü-mayo ra hɨmboambo mahafe. ");
INSERT INTO agg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ranɨyo moanɨ nɨmai hamɨndɨ hɨfɨhe afɨndɨ ranai tüküfihɨyo, Adükarɨndɨ nendɨ ranai sünambeahɨndɨ kusü nɨmoei afɨndɨ nafɨtambihɨ mapaiaro ra gügürɨhai sɨhai hayambo ranɨwamɨ mamaru. ");
INSERT INTO agg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ai wabürüsɨ nahuraiyowohüyo asu ahandɨ hoearɨ ranai moanɨ mburɨŋgai kɨfohɨ hamɨndɨ nahurai tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ranɨyomo asu nindou hoŋgu ambe ranahambo hɨfandu manɨŋgomo-memo ranai ahambo yɨhɨmbombo hɨhamɨndarɨyomondühɨ yɨfɨ nahurai korɨmemo. ");
INSERT INTO agg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Asu sünambeahɨndɨ nendɨ-mayu ranai nɨmorehɨ yimbumefe ahafembo hoafɨyupɨrüh yahuya, “Se awi yɨhɨmbo-ndamboyafe. Ro sɨhafembo fɨfɨrɨheapɨrɨmbo-anahɨ, sapo seana Sisas nɨmɨ keimbɨ karɨhendeimbɨfihɨ hɨfokoamefiyu ranahambo kokombo-anafe nda. ");
INSERT INTO agg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aiana moai ndühɨ yaŋguru. Aiana sapo horombo hoafɨmayu süŋgu yaŋgɨrɨ aboeda asükai botɨmefiyu. Awi naha fondɨ ai meŋguru nda hoeirɨne. ");
INSERT INTO agg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ŋga se nɨmai ŋgafe ahambo süŋgururü-rundeimbɨ nindou-memo ranahamumbo hoafɨndafɨnapurühɨya, ‘Ai yaŋgɨrɨ aboeda botɨmefiyu. Asu haponda ai Garirinambo horombofi sɨhamundɨ wagabe ahu, ŋga se ranühɨ anɨmbo ahambo hoeindurümboemo!’ mbɨsafe. Hapoana ro sɨhafembo hoafɨyahɨpɨrɨmbo-anahɨ,” mehupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ranɨyafe ai hoŋgu ra hɨnɨŋgɨrɨne hena yɨhɨmboyafesɨ, ŋga asu ai hɨhɨfɨ-hɨhɨfɨ kameihü pɨpɨna Sisasɨmbo süŋgururü-rundeimbɨmbo hoafombo mahafe. ");
INSERT INTO agg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Moanɨ nɨmai Sisas ai ahafembo-so tüküfi hoafɨyupɨrühɨ yahuya, “Karɨhapɨsɨ,” mehupɨrɨ. Ai ahambo-so tüküyafɨne yitɨŋarühɨ kɨkɨhɨrɨnandɨfe henambo ahambo Adükarani safe hena hohoanɨmomefɨnando. ");
INSERT INTO agg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Sisas ai ahafembo hoafɨyupɨrühɨ yahuya, “Se yɨhɨmbondamboyafe. Se ŋgafe wandɨ wandafɨ mamɨmbo hoafɨndafeanɨ anɨmbo asu ai Garirinambo ŋgɨfomo tükündafu ranühɨ anɨmbo ai wambo hoeindundɨrɨmboemo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nɨmorehɨ yimbumefe ranai nafɨ mbahafe nou ranambo, bɨdɨfɨrɨ hɨfandu-rundeimbɨ nindou ranai ŋgoafɨ adükarɨ-mayo ranɨna homo bogorɨ Godɨmbo sɨhou-rundeimbɨ nindou ranahamumbo muŋguambo wataporɨ nɨne-moatükunɨ ahamundɨ hɨmboahü tükümefeyo ranahambo wataporɨmbomarundɨ. ");
INSERT INTO agg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Ranɨyomo Godɨmbo sɨhou-rundeimbɨ nindou bogorɨyomo asu bogorɨ nindou-memo ranaiyomo ai mamühɨyafu houmbo hoafɨ fɨfɨrɨmarundɨ. Ai kakɨ afɨndɨ ra ami-memo ranahamumbo sabupurühɨ yahomoya, “Se randu hoafɨndɨmondühɨ anɨmboya, ‘Nɨmbokoanɨ ro yapomboyahu mboapoefɨ nou ranambo ahambo süŋgururü-rundeimbɨ ai tüküyafu hümbuhünɨmbo ahandɨ finɨmoko ra masowaründümo,’ mbɨsɨmo. ");
INSERT INTO agg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ranɨ hɨfɨ bogorɨmbofi hɨfanda-randeimbɨ ai ranɨ hoafɨ ra hɨmborɨnduanɨ asu ro ahambo bɨdɨfɨrɨ hoafɨndahundoanɨ rananɨmbo asu se ŋgɨrɨ ranɨmbo tɨŋɨrɨfo tükündɨfemboe mbɨsɨmo hou afɨndɨ hohoanɨmondɨmo,” mehomopurɨ. ");
INSERT INTO agg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ranɨmboane ami-memo ranai kakɨ masabupurɨ-mayo ra sowandümo hou asu ai ahamumbo hoafɨmemopurɨ süŋgu yaru homo hoafɨmemo. Ranane asu ranɨ hoafɨ ra Suda-yafe mbusümo hapondanambe amboanɨ yaŋgorü wakareandɨ. ");
INSERT INTO agg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sisasɨmbo süŋgururü-rundeimbɨ 11memo ranai Gariri wafunambo mahafomo sapo horombo Sisas ai ranühɨ ŋgomo mehupurɨ süŋgu. ");
INSERT INTO agg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ai homo ahambo hoeirüwurɨhüyomo asu ahambo ŋgusüfo parüwurɨ hohoanɨmomemondo. Ŋga asu bɨdɨfɨrɨ ai ahambo hohoanɨmo yimbumborurü. ");
INSERT INTO agg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sisas ai akɨmɨ ahamumbo-so sühüfi hüfu hoafɨyupurühɨ yahuya, “God ai wambo muŋguambo ŋgɨnɨndɨ sünambeahɨndɨyo asu hɨfɨnɨndɨyo ra sendɨrɨmboani. ");
INSERT INTO agg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ranɨmbohündambo anɨmbo asu se ŋgomo muŋguambo nindou ranaheimbo ai wambo süŋguyondɨrɨ-rambo nindou tüküfembohündambo randu ndundɨ. Asu se aheimbo Apendɨ ndürɨnambo, Nɨmorɨndɨ ndürɨnambo, asu Yifiafɨ Aboedɨndɨ ndürɨnambo hɨmonɨ hundüründundürɨ. ");
INSERT INTO agg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Asu ro sɨhamumbo hoafɨmehapurɨ ra muŋguambo moatükunɨ süŋgufe hombohünda yamundundürɨ. Asu ro se babɨdɨ nɨmboa ŋgambo bɨdɨfɨranɨ si tükündɨfemboe,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sisas Krais Godɨndɨ nɨmorɨmbo aboedɨ hoafane nda. ");
INSERT INTO agg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hoafɨ nda boatei tükümefeyo Godɨndɨ hoafɨ hoafɨyu randeimbɨ Aisaia ai sürü papɨmarandɨ nahurai. God ai yahuya, “Ro nindou mamɨ wandɨ hoafɨ bokarɨhefembohünda koandɨhehinanɨ ai sɨhambohünda horombondɨfi ŋgumbui. Asu ai anɨmbo sɨhambohündambo nafɨ dɨdɨboadondeambui. ");
INSERT INTO agg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nɨmɨ wohɨ furɨkoatereandühɨ, nindou mamɨndɨ yasɨmondɨ mɨŋgɨyo hoafɨyowohü yahoya, ‘Adükarɨmbohünda nafɨ nafɨndɨhehindɨ. Ahandɨ nafɨ dɨboadondɨhindɨ,’ meho,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Son nindou hundürüra randeimbɨ-mayu ranai nɨmɨ wohɨ furɨkoatereandühɨ tüküfi nɨmorehɨ nindowenihɨmbo Godɨndɨ hoafɨ bokarɨhendühɨ yahuya, “Se moaruwai hohoanɨmo hɨnɨŋgɨfe aboedɨ hohoanɨmo süŋgufembo nafuimbohünda hundüründeianɨ anɨmbo, God ai sɨhei moaruwai hohoanɨmo raguanambondeambui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ranɨyei nindou afɨndɨ Sudahündɨyei asu Serusaremɨhündɨyei ai Sonɨndɨ hoafɨ hɨmborɨmbo mahei. Ai ahei moaruwai hohoanɨmo ra weindahɨ hoafɨmayeia Son ai Sodan hɨmo hundürümarandürɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Asu Son aiana hoearɨ kamer nɨnendɨnambo nafümbɨ güde mbura tɨtapürɨnambo kɨkɨhɨrɨhaimarandɨ. Ahandɨ sesɨ ana yɨtɨhɨ asu efu hoe ranɨyo sesü-marandɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Son ai nindou ranaheimbo hoafɨ bokarɨhendühɨ ndare hoafɨyuhɨ yahuya, “Nindou ŋgorü süŋgu düdümbui ahandɨ ŋgɨnɨndɨ ra wandɨ ŋgɨnɨndɨmbo ŋgasündeamboane. Roana amofe ahandɨ sufihɨndɨ wofɨ ra fufurɨfembo nindou aboedɨ hamɨndɨyahɨpoanɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ro sɨheimbo hoenambo hundürühandürɨ arɨhandɨ, ŋga ai anɨmbo Yifiafɨ Aboedɨnambo hundürü-ndandürümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ranɨ-sɨmboanɨ Sisas ai Nasaret ŋgoafɨ Gariri hɨfɨhü hɨnɨŋgɨre haya masünuwamboyu Son ai Sodan hɨmo hundürümarürɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Asu nɨmehünou hoe hɨnɨŋgɨre haya tüküfi süfu hoeireandane sünü ai bureandühɨyo Yifiafɨ Aboedɨ ranai ahambo sowana wupufo nahurai makoso. ");
INSERT INTO agg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hoafɨ mamɨ sünambeahɨndɨ tüküfehü yahoya, “Se ana wandɨ ŋgusüfo parɨheanɨneimbɨ nɨmor-anafɨ. Asu ro sɨhamboane ŋgusüfoambe siaoeheandɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nɨmehünou Yifiafɨ Aboedɨ ai Sisasɨmbo nɨmɨ wohɨ furɨkoatereandühɨ koamarɨhera mahu. ");
INSERT INTO agg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ranühɨ 40 si manüŋgua Satan ahambo moaruwai hohoanɨmombiyuwa yahuhaya rari hoeimarirɨ. Sisas ai afoendɨ nɨnɨhondɨ babɨdɨmbo nüŋguwanɨ asu sünambeahɨndɨ nendɨ ai ahambo mafarɨhawurɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Son ai karabusɨ-mefiyua asu Sisas ai Garirihü tüküfi, Godɨndɨmayo aboedɨ hoafɨ ra bokamarɨhendɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ai aboedɨ hoafɨ ra wataporɨmborandühɨ yahuya, “God ai hoafɨmayu si ra ndeara tüküfehü asu ahandɨ ŋgɨnɨndɨ hɨfandarandɨ ra ndeara akɨmɨ tüküfemboane. Ŋga se moaruwai hohoanɨmo ra hɨnɨŋgɨndɨhi hehi aboedɨ hohoanɨmo süŋgundɨhindɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sisas ai kurɨhoe Gariri hɨmborɨkɨmɨ huhü Saimon Andru apodohombo hoeimareapɨrɨ. Ai andürɨ kurɨhoeambe mafoarɨneandɨ, ai kinɨ wowarɨyafanɨ rɨnandeimbɨ nindou wambo. ");
INSERT INTO agg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sisas ai ahafanɨmbo hoafɨyupɨrühɨ yahuya, “Se mborai wambo süŋgundɨnandɨrɨ ndɨnandɨ, rananɨmbo ro sɨhafanɨmbo nindou semɨndɨmbo yamundɨheapɨrɨmboyah,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Asu ai nɨmehünou andürɨ sɨhene hena ahandɨ süŋgu mahafanɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ai akɨdou sühüfi hu Sebedindɨ nɨmorɨ yimbu, Sems Son apodohombo botambe nɨmarɨfanɨmbo andürɨ dɨboadomarɨneanda hoeimareapɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sisas ai ahafanɨmbo hoafɨmayupɨramboyafanɨ, ahafandɨ afɨndɨ Sebedi asu mamɨ ratüpurɨyomo rundeimbɨ nindou botambe hɨnɨŋgɨrɨneapurɨ hena, Sisasɨndɨ süŋgu mahafanɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo moanɨ ŋgoafɨmbo nɨmarɨ sihɨ Kaperneam ŋgoafɨnambo mahɨfomo. Ranɨ-sɨmboanɨ ai Suda-yei rotu worambe kefuai hafu nɨmorehɨ nindowenihɨmbo Godɨndɨ hoafɨ yamundɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ranɨyei asu ai ahandɨ yamundɨfe hoafɨ ranahambo hepünɨmehindɨ. Sapo ai moai ahɨnümbɨ hohoanɨmo yamundu rundeimbɨ nahurai yamundeandɨ, ŋga nindou adükarɨ ŋgɨnɨndeimbɨ nahurai yamundɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Ranɨ-sɨmboanɨ nindou mamɨ moaruwai nendɨ nɨmarümbɨ-mayu ranai Suda-yei rotu worambe nɨmarü puküna hoafɨ karɨhoehü yahuya, “Sisas, Nasaretɨhündɨ, se yohoefɨmbo nɨnɨ nünüŋgufemunɨmboyafɨ masɨnɨfɨ? Yɨhoefombo moaruwaimbo-fimunɨmbo safɨmboyafɨ? Ro fɨfɨrɨheanɨnɨ. Se ana Godɨndɨ mbumundɨ nindou-anafɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Asu Sisas ai moaruwai nendambo ŋgɨnɨndɨ hoafɨyuhɨ yahuya, “Se hoafɨ kɨkɨrandɨfɨ hawa kosɨfoao,” mehundoamboyo. ");
INSERT INTO agg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Asu moaruwai nendɨ ranai nindou ranahambo yabadɨrɨ hɨnɨŋgɨrerɨ mbura hoafɨ moanɨ puküna karɨhoai haya nindou ranahandɨ fiambeahɨndɨ makosɨfoendɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ranɨyo asu muŋguambo nɨmorehɨ nindowenihɨ ranai hepünahindühɨ aheihoarɨ sɨmborɨ hoafɨyeihɨ seiya, “Nɨnɨ-moatükunɨyo nda yahurai tükümefeyoa? Nindou ndanai sɨmborɨ moatükunɨ bogorɨ nindou nahurai yamundɨmareandɨ. Asu ai moaruwai nendambo hoafɨmayua ahandɨ hoafɨ hɨmborɨmayei,” masei. ");
INSERT INTO agg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ranɨyo asu Sisasɨndɨ hoafɨ ranai nɨmehünou muŋguambo hɨfɨ Garirihü ra hoaŋgo wakɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo Suda-yei rotu worambeahɨndɨ tüküyafu houmbo Sems weimbo Son babɨdɨmbo Saimon weimbo Andru-yafandɨ worɨnambo mahomo. ");
INSERT INTO agg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimonɨndɨ yamoŋgoamɨndɨ ai aŋgünümbo fondɨhü mapowa asu ahandɨ aŋgünɨ ranahambo nɨmehünou Sisasɨmbo hoafɨmehündo. ");
INSERT INTO agg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ranɨyu Sisas ai hüfu ahandɨ watɨŋarühɨ kɨkɨhɨramündü botɨmareanda asu aŋgünɨ ahandɨ ranai nɨmehünou makosɨfoenda asu sesɨ sɨndɨmarandɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mamɨ ranɨ nɨmbambe hüfɨhamɨndɨ hürɨmɨndowa nindou ranai nɨmorehɨ nindowenihɨ aŋgünümbɨ asu moaruwai nendeimbɨ fufurühümündihündürɨ Sisas sowana mafandɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","34","Muŋguambo nindou ŋgoafɨhündɨ ranai hei worɨ Sisas nɨmarümbɨ ranɨ yipurɨ-kɨmɨ burɨmayeia Sisas ai afɨndɨ nɨmorehɨ nindowenihɨ muŋguambo mamɨkarambo aŋgünümbɨ aboedɨreandürɨ asu moaruwai nendɨ afɨndɨ raguanamboreandürɨ marandɨ. Asu moaruwai nendɨ ranai ahambo fɨfɨrɨhorɨ ranɨmboyu ai aheimbo yowanɨ akɨdou amboanɨ hoafɨyopoanɨ mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sisas ai siambe hondü nɨmbɨ hoaŋgɨrɨ kiaroambe botɨfi haya hu gorügoanɨnɨ nindou nɨmarɨkoateyohü Godɨmbo dɨdɨbafɨyuhü mamaru. ");
INSERT INTO agg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Asu Saimon ai ahandɨ ŋgunindɨ babɨdɨ Sisasɨmbo kokomarurɨ homo. ");
INSERT INTO agg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ai homo hoeirüwurühɨ hoafɨyomo-ndowohü yahomoya, “Muŋguambo nindou ai sɨhambo kokorɨhünɨnühanei,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Ŋgorü ŋgoafɨ akɨmɨ adaburo ranambo ŋgefo. Rananɨmbo ro aheimbo amboanɨ Godɨndɨ hoafɨ hoafɨndahandürɨ. Ranɨmboyahɨ ro nda masɨnɨhɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Asu Sisas ai muŋgu Gariri hɨfɨhü hoahoaŋgu wakɨreandühɨ, Suda-yei rotu worambe hu, Godɨndɨ hoafɨ bokarɨhendühɨ asu moaruwai nendambo hɨhaifoareandürɨ marandɨ. ");
INSERT INTO agg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nindou mamɨ mɨmanɨho masɨmeimbɨ ai hu Sisasɨndɨ yirɨkɨmɨ piyu nɨmarümbo hüti hoafɨrürühɨ yahundoya, “Se refembo yifirayafɨ ana, wandɨ mɨmanɨho masɨmei ra aboedɨndowandɨrɨ,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Asu Sisas ai ahambo hɨpoamborirühɨyu, ahandɨ warɨnambo sündirühɨ yahundoya, “Refembo samboanahɨ, ŋga se aboedɨyafo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ranɨyo masɨmei ranai nɨmehünou dɨdɨkɨrɨfoendühɨyo asükai nindou ranai aboedɨmayu. ");
INSERT INTO agg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Sisas ai nindoumayu ranahambo ŋgoafɨnambo koarɨherühɨ asükaiyu hoafɨyundowohü yahundoya, “Se yowanɨ nindou mamɨmbo amboanɨ sɨhafɨ fi ranahambo hoafɨyopoanɨ. Ŋga se ŋgafɨ Godɨmbo sɨhai-randeimbɨmbo sɨhafɨ fi ra nafuindafɨndo. Rananɨmbo Mosesɨndɨ ahɨnümbɨ hoafɨmayo süŋgu sɨhafɨ fi aboedɨ tükümefeyo ra aheimbo nafuimbohünda Godɨmbo sesɨ mbɨsɨhenda-mboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ŋga asu nindou ranai hu Sisas ai ahambo aboedɨmarirɨ ranahambo wataporɨmbo-maranda asu Sisas ramareandɨ hoafɨ ra muŋguambo ŋgoafɨ hɨhɨmborɨmayei. Ranɨmboyu Sisas ai nindou hoeindɨ-hindɨrɨ-mboyei yahuhaya moai mamɨ ŋgoafɨ amboanɨ hu. Ai nindou nɨŋgo-koateyeihɨ manüŋguyosɨ, ŋga asu nindou ranai muŋguambo hɨfɨhündɨ ahambo sowana hei marɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yahunümbɨ si ho hayamboyoane Sisas ai asükai Kaperneam ŋgoafɨnambo hɨhɨrɨfi mahu. Ranɨyo ai hu worambe amaru hoafɨ ra mahoaŋgo. ");
INSERT INTO agg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nindou afɨndɨ ranai fandambo worɨ ranai tühüforeandühɨ moai yipurɨkɨmɨ amboanɨ fondɨ akɨdou nɨŋgo. Ranɨyo Sisas ai aheimbo Godɨndɨ hoafɨ yamundeandürühɨ mamaru. ");
INSERT INTO agg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yimbu-yimbu nindou ai nindou yirɨwarɨ moaruwaimbü ra fondɨwamɨ foarüwurɨ mburu sowaründümo mahɨfomo. ");
INSERT INTO agg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nindou ranahambo Sisas sowanambo semündü hɨfombo nindou afɨndɨwambo nafɨ gümareandamboyo hafomo worɨwamɨ Sisas nüŋgu sɨmogodühɨ hɨfɨnambo tɨtɨrundeimbɨ worɨ ranambe waŋgeyaŋɨrɨhou mburumbo fondɨ kameihü masafoarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ranɨyu Sisas ai nindou ranahamundɨ anɨhondümbofe ra hoeireanda mayoa, nindou yirɨwarɨ moaruwaimbü ranahambo hoafɨyundowohü yahuya, “Nindou hoarɨfɨ, sɨhafɨ moaruwai hohoanɨmo ranana amboawi sambo-anahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Asu ahɨnümbɨ hohoanɨmo yamundu rundeimbɨ bɨdɨfɨrɨ ranühɨ mamarɨmo ranai ahamundɨhoarɨ ŋgusüfoambe raru hohoanɨmoyomondohü yahomoya, ");
INSERT INTO agg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nɨmboe nindou ndanai hoafɨ yahurai hoafayua? Ai Godɨyupoanɨ yahurai hoafayu. God mamɨ yaŋgɨrɨ anɨmbo moaruwai hohoanɨmo ra amboawi mbüsümbui,” mehomo-ndamboyu. ");
INSERT INTO agg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sisas ai nɨmehünou ahɨnümbɨ hohoanɨmo yamundu rundeimbɨ-yomondɨ hohoanɨmo ra fɨfɨreandɨ. Ranɨyu ai hoafɨyupurühɨ yahuya, “Nɨmboe se ndanɨ moatükunɨ nda raru hohoanɨmoemoa? ");
INSERT INTO agg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nɨne hoafɨyo nindou yirɨwarɨ moaruwai ndanahambo hoafɨmbo hɨnɨŋgɨrouayoa? Ro hoafɨyahühɨ sahɨya, ‘Sɨhafɨ moaruwai hohoanɨmo ranahambo amboawi,’ asahɨyo asu ‘Botɨyafo sɨhafɨ fondɨ sowandɨfɨ hawa hafɨ,’ asahɨyo. Ŋga yimbu ra hoafɨmbo ro ŋgɨnɨndeimb-anahɨ. Asu yimbu hoafɨ ra hoafɨmbo nahanɨyo hɨnɨŋgɨrouayo asu nahanɨyo tɨŋümbayo? Yɨbobo ro hoafɨndahanɨ anɨhondümbo tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ŋga ro sɨhamumbo ranɨ-moatükunɨ ra fɨfɨrɨndundɨ asahɨ, Nindou Hondü ai hɨfɨ ndanühɨ moaruwai hohoanɨmo amboawi yahombo ŋgɨnɨndeimbani,” mehu. Ranɨyo asu Sisas ai nindou yirɨwarɨ moaruwaimbü mayu ranahambo hoafɨyundowohü yahuya, ");
INSERT INTO agg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ro sɨhambo hoafayahanɨnɨ, botɨyafo sɨhafɨ fondɨ sowandɨfɨ hawa worɨnambo hafɨ,” mehundo-wamboyu. ");
INSERT INTO agg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nindou afɨndɨ meŋgoro ranahei hɨmboahü yirɨwarɨ moaruwaimbü mayu ranai nɨmehünou botɨfi ahandɨ fondɨ semündü haya mahu. Ranɨyo nindou afɨndɨ meŋgoro ranai hepünahindühɨ Godɨmbo aboedani sei hoafɨyeihɨ, “Moai horombo ro ndahurai moatükunɨ hoeirɨhundɨ,” masei. ");
INSERT INTO agg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sisas ai asükai hɨhɨrɨfi haya Gariri kurɨhoe hɨmborɨ kɨmɨ hüfuane nindou afɨndɨ meŋgoro ranai ahandɨ süŋgu tümare hoamboyu asu Godɨndɨ hoafɨ yamundɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ai huhündamboyu Rifai Arfiusɨndɨ nɨmorɨ ai ahandɨ takis kakɨ semɨndɨ worambe mamaruwa hoeimarirɨ. Ranɨyu Sisas ai hoafɨyundowohü yahuya, “Mborai wandɨ süŋgu,” mehundo-wamboyu Rifai ai botɨfi haya Sisasɨndɨ süŋgu mahu. ");
INSERT INTO agg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo Rifaindɨ worambe takis kakɨ sowandümo rundeimbɨ nindou-yomo asu moaruwai hohoanɨmoyomo rundeimbɨyomo ai-babɨdɨmbo nɨmarɨmo masowasümo. Nindou yahurai ranai muŋguambo si Sisasɨmbo süŋgururü marundɨ. ");
INSERT INTO agg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Farisihündɨ ahɨnümbɨ hohoanɨmo yamundurundeimbɨ ranai hoeirundane Sisas ai takis kakɨ sowandümo rundeimbɨ asu moaruwai hohoanɨmoyomo rundeimbɨ nindou babɨdɨmbo sesɨ masesu. Ranɨyomo ahambo süŋgururü-rundeimbɨmbo düdurüpurühɨ yahomoya, “Nɨmboe Sisas ai takis kakɨ sowandümo rundeimbɨ asu moaruwai hohoanɨmoyomo rundeimbɨ nindou babɨdɨmbo nɨmarümbo sesɨ sesü maranda?” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sisas ai ranɨ hoafɨ ra hɨmborɨyu haya ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ ranahamumbo hoafɨyupurühɨ yahuya, “Nindou aŋgünɨ-koate ana moai dokta sowanambo hei rɨhündɨ, ŋga aŋgüneimbɨ anei hei arɨhündɨ. Mamɨ yahuraiane ro makosahɨ nda mbumundɨ nindou anefɨ seimbɨ nindou ranaheimbo mborai yahombo-yahɨpoanɨ, ŋga nindou moaruwai hohoanɨmoyei rɨhündeimbɨ seirɨhündeimbɨ ranaheimbo mborai yahomboyahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sonɨmbo süŋgururü-rundeimbɨ asu Farisi-yomondɨ süŋgurundeimbɨ ai mamɨmbo sesɨ wehɨmemo. Ranɨyo asu nindou bɨdɨfɨrɨ ai homo Sisasɨmbo düdurüwurühɨ yahomoya, “Nɨmboe Sonɨmbo süŋgururü-rundeimbɨ asu Farisi-yomondɨ süŋgurundeimbɨ ai sesɨ wehɨsaoyomo arundɨ, ŋga asu sɨhafɨ süŋgurunɨnɨ rundeimbɨ ana moai sesɨ wehɨyomo rundɨ?” mehomo-ndamboyu. ");
INSERT INTO agg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Asu Sisas ai yare hoafɨyupurühɨ yahuya, “Nindou mamɨ nɨmorehɨ semɨndɨmbo sihɨ ai babɨdɨmbo nüŋguambe ra sesɨ wehɨmandeiyo? Nindou nɨmorehɨ semɨndɨmbomayu ranai ai-babɨdɨmbo nüŋguambe ana ŋgɨrɨ sesɨ wehɨndei. ");
INSERT INTO agg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ŋga süŋgunambo nindou ranahambo ndowaründümo ŋgomondanɨ ai-babɨdɨmbo nɨŋgokoate-ayuambe anɨmbo sesɨ wehɨndeimboyei. ");
INSERT INTO agg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nindou mamɨ aiamboanɨ moai hoearɨ goesürɨ sɨmborɨ semündü haya wamɨndafɨ ŋgɨsɨharɨ hoearɨ fihɨ pare kakɨyu randɨ. Rawareandɨ ana, boboe-ndandanɨ asu hoearɨ goesürɨ sɨmborɨ ranai akɨdou yaŋgɨrɨ yagodɨ mbunda ŋgɨsɨharɨ hoearɨ ra hɨrɨndeamboe. Hoearɨ goesürɨ sɨmborɨ rananai wamɨndafɨ ra hɨrɨndeandanɨ asu ambe afɨndɨ nɨŋgomboe. ");
INSERT INTO agg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Asu nindou ŋgorü ai sɨmborɨ wain hoe ra wamɨndafɨ wain hoe nɨnɨhondɨ hoearɨ hɨpɨrɨ ranambe ŋgɨrɨ kandeandɨ. Rawareandɨ ana, hɨpɨrɨ ranai borɨndɨfeihü wain hoe ranai keboemboe. Ŋga sɨmborɨ wain hoe ana hɨpɨrɨ sɨmborɨ ambe femboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mamɨ ŋgoafɨmbo nɨmarɨmbo sihɨ Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo wit nümbürɨ mbusümo mahomo. Ranɨyo ahambo süŋgururü-rundeimbɨ ai wit ahurɨ bɨdɨfɨrɨ hürɨmaründümo. ");
INSERT INTO agg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Asu Farisihündɨ ai Sisasɨmbo düdurüwurühɨ yahomoya, “Nɨmboe sɨhambo süŋgurunɨnɨ rundeimbɨ ai moanɨ nɨmarɨmbo sihɨ ahɨnümbɨ ra rawarunda?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Awi se Defit ai ahandɨ wandafɨ mamɨ babɨdɨmbo sesɨkoate wembomboyomondühɨ ramareandɨ ra hoeirundai wanɨyo? ");
INSERT INTO agg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sapo Abaiatar ai Godɨmbo sesɨ sɨhairandei-mbɨmbofi nɨmaruambe Defit ai Godɨndɨ ser worambe kefuai hüfu bret Godɨmbo masɨhoundɨ ra masesu. Bret ranana Godɨmbo sesɨ sɨhou-rundeimbɨ yaŋgɨrane sowasümo arundɨ. Ŋga Defit ai sesühɨ ahandɨ wandafɨ mamɨmbo bɨdɨfɨrɨ masagapurɨ ra moai fɨfɨrundɨyo?” ");
INSERT INTO agg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Sisas ai asükai Farisimbo hoafɨyupurühɨ yahuya, “Moanɨ nɨmarɨmbo si ranahambo fehefemboyopoanɨ God ai nindou nafɨmarandɨ. Ŋga moanɨ nɨmarɨmbo si ranai nindoumbo mbɨfarɨheirambo yahuhayamboyu nafɨmarandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Asükai ŋgorü-sɨmboanɨ Sisas ai Suda-yafe rotu worambe kefuai hüfuane nindou watɨŋarɨ moaruwaimbü ai ranühɨ mamaru. ");
INSERT INTO agg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ranɨyo nindou bɨdɨfɨrɨ ai Sisasɨmbo hɨmboarɨ safühɨmarüwurɨ moanɨ nɨmarɨmbo sihɨ nindou watɨŋarɨ moaruwaimbü ra aboedɨndira papɨhoafɨndɨhurɨ yahomo houmbo. ");
INSERT INTO agg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sisas ai nindou watɨŋarɨ moaruwaimbümayu ranahambo hoafɨyundowohü yahuya, “Botɨyafo ndühɨ sühüfanɨ muŋguambo hoeimbɨrɨhinɨnɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ranɨyu Sisas ai düdureandürühɨya, “Nɨnɨ-moatükunɨyo moanɨ nɨmarɨmbo sihɨ refembo ahɨnümbɨ ra aboedayo, aboedɨ moatükunɨ refemboyo moaruwai moatükunɨ refemboyo? Nindou hɨfokoefemboyo asu nindou aboedambofemboyo?” mehu. Ŋga ai moai sɨmborɨ ahambo akɨdou amboanɨ hoafɨyomo. ");
INSERT INTO agg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sisas ai nindou ranahamumbo hübudurapurɨ wakɨreapurane asu ahamundɨ ŋgusüfoambe ranai tapɨhamɨmayo-wamboyu hɨhɨfɨ-hɨhɨfɨ-koatemayu. Ranɨyu asu nindou watɨŋarɨ moaruwaimbü ranahambo hoafɨyundowohü yahuya, “Sɨhafɨ watɨŋarɨ ŋgurɨhao,” mehua ŋgurɨmarɨhenda aboedɨ tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ranɨyo Farisi nindoumemo ranai worɨ ra hɨnɨŋgɨru houmbo homo Herotɨndɨ nindou babɨdɨ Sisasɨmbo hɨfokoefimbo hoafɨ fɨmaründümo. ");
INSERT INTO agg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo Gariri kurɨhoenambo mahomonda asu nindou afɨndɨ ranai ahamumbo süŋgu-marɨhüpurɨ hei. ");
INSERT INTO agg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Sisas ai nindou yamunde asu aboedɨre arandɨ hoafɨ ra hɨmborɨyei hehi, nindou afɨndɨ Gariri, Sudia, Serusarem, Idomia, hɨfɨ Sodan hoekɨmɨ adaburo, Tair asu Saidon ŋgoafɨ ranɨhündɨ ranai Sisas sowana mafandɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sisas ai nindou afɨndɨ ra hoeireanda mayowamboyu ahambo süŋgurururü-rundeimbɨmbo hoafɨyupurühɨ yahuya, “Nindou afɨndane eŋgoro, ŋga se bot ŋgorü sowandümo sɨfomo, ŋga afɨndɨ afɨndɨndeihɨ wambo hoe hohoeanɨ nɨnendɨ-hündürɨmboyei,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sisas ai horombo nindou afɨndɨ aboedɨmareandürɨ ranɨmboyei aŋgünümbɨ nindou afɨndɨ ranai Sisasɨmbo sündɨfimbo sɨmborɨ nɨnendürɨmayei hei. ");
INSERT INTO agg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Asu moaruwai nendɨ ranai Sisasɨmbo hoeirɨhoranɨ mayoa ahandɨ wagabe pɨyei nɨmareimbo puküna hoafɨ karɨhehindühɨ seiya, “Seana Godɨndɨ nɨmor-anafɨ,” masei. ");
INSERT INTO agg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ŋga Sisas ai aheimbo nüŋgunahurai nindouyu yaho fɨfɨrɨfe hoafɨmbo yowanɨ mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ai hafu hɨfɨ wafuwamɨ nɨmarümbo nindou dɨdeyomo ai hohoanɨmo-yupureimbɨ ahamumbo hoafɨmayua ahambo sowana mahafomo. ");
INSERT INTO agg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Sisas ai nindou 12 sepurɨmündɨ hɨnɨŋgɨreapurɨ haya hoafɨ sowandümo homo-rundeimbɨ anemo yahu kamafoareapurɨ. Nindou ranai Sisas babɨdɨmbo nɨŋgombo ai koarɨhefepura ho Godɨndɨ hoafɨ bokarɨhefehü asu moaruwai nendɨ hɨhaifoefembo ŋgɨnɨndɨ masagapurɨ. ");
INSERT INTO agg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sisas ai nindou 12 ndanahamumbo masepurɨmündu: Saimon, asu Sisas ai ŋgorü ndürɨ Pita kamafoarirɨ. ");
INSERT INTO agg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sems, Son Sebedindɨ nɨmorɨ. Sisas ai ahafanɨmbo Boanerges anafanɨ yahu dükamareapɨrɨ. Ahandɨ nɨmɨndɨ ra nɨmoamondɨ hoafɨ nahurai nindouane. ");
INSERT INTO agg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Andru, Firip, Bartoromyu, Matyu, Tomas, Sems, Arfiusɨndɨ nɨmorɨ, Tadius, Saimon Serot sɨrambeahɨndɨyu asu Sudas Iskariot Sisasɨmbo ahandɨ hürütümbɨ-yomondɨ warɨhümarirɨ. ");
INSERT INTO agg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sisas ai worɨnambo huanɨ asükai nindou afɨndɨ ranai hei worɨ gümarɨhorɨ. Ranɨmboyu ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo sesɨ sesɨ-koatememo. ");
INSERT INTO agg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sisasɨndɨ fikɨmɨnɨndɨ ai ranɨ hoafɨ ra hɨmborɨyei hehi ahambo fihimündɨmbo mahei. Sapo ai hohoanɨmoyeihɨya, ai wunünümbo-yuhümbei sei hehi. ");
INSERT INTO agg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ŋga Serusaremɨhündɨ ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ ai hanɨmo hoafɨyomondühɨya, “Ahandɨ fiambe Bersebur mbamarü. Aiana moaruwai nendɨyei bogorɨ Bersebur ahandɨ ŋgɨnɨndɨ-namboane moaruwai nendɨ nindouyei fiambeahɨndɨ hefoare arandɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sisas ai nindou ranaheimbo hoafɨyundüra akɨmɨ maheia kafoefe hoafɨ hoafɨyundürühɨ yahuya, “Satan ai nüŋgunde Satanɨmbo hemoaboadira? ");
INSERT INTO agg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Asu mamɨ hɨfɨhündɨ ai yɨbobore haya yifiarayo ana, ranɨ hɨfɨhündɨ ranai ŋgɨrɨ aboedɨ nɨmandei. ");
INSERT INTO agg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Asu mamɨ worambeahɨndɨ ai yɨboborɨhi hehi yifiarayei ana, ai ŋgɨrɨ aboedɨ nɨmandei. ");
INSERT INTO agg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Asu Satan ai yifiarɨmbo yahuhaya ahandɨ nendɨ ranai yɨboboareandɨ ana, ŋgɨrɨ ŋgɨnɨndɨ nɨŋgo, ŋga ai ranɨwamɨ randɨhi moendɨ-ndeimboyei. ");
INSERT INTO agg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ŋgɨrɨ nindou ŋgorü ai ŋgɨnɨndɨ nindoundɨ worambe ŋgu napo hümbuhünɨndu. Sapo nindou ranai hümbuhünɨmbo hohoanɨmoayu ana, ŋgɨnɨndɨ nindou ranahambo wofɨnambo hüputüpondɨherü mbundambo anɨmbo asu ahandɨ napo muŋgu ra fufundamündümbui. ");
INSERT INTO agg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ro sɨheimbo anɨhondümbo-anahɨ hoafehandürɨ, nindou ai Godɨmbo moaruwai hoafayei ane asu moaruwai hohoanɨmoayei ane ra amboawi mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ŋga nindou ŋgorü ai Yifiafɨ Aboedɨmbo moaruwai hoafayu ana, God ai ŋgɨrɨ amboawi mbüsu, hapondanɨ-ane asu süŋgunamboane. Ŋga moaruwai hohoanɨmo ranai ahambo-so koadürümbo koadürümbo yagodɨmboe.” ");
INSERT INTO agg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sisas ai ranɨ hoafɨ hoafɨmayu ra sapo ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ ai ahamboya, ‘Moaruwai nendɨ ahandɨ fiambe nɨmarɨmboane,’ mehomo-ndamboyu ra-mehu. ");
INSERT INTO agg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ranɨ-sɨmboanɨ Sisasɨndɨ hondɨ asu akohoandɨ ai ahambo fihambo tükümehind. Ai moanambühɨ nɨmboeimbo aheimbo sowana hombo hoafɨmbo nindou mamɨ koamarɨhehorɨ. ");
INSERT INTO agg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nindou afɨndɨ ranai Sisasɨmbo wakɨrɨhorɨ nɨmareimbo hoafɨyahündowohü seiya, “Sɨhafɨ amondɨ aborüdɨ ai sɨhambo weindanɨ nɨboadei hɨfandarɨhünɨnɨ,” masei-amboyu. ");
INSERT INTO agg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Asu Sisas ai sɨmborɨ hoafɨyundürühɨ yahuya, “Dɨdɨyei wandɨ me asu akohoanda?” ");
INSERT INTO agg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nindou wakɨrɨhi mamarei ranaheimbo hübudurandürɨ wakɨrerühɨ yahuya, “Ndananei wandɨ me asu akohoand-ayei. ");
INSERT INTO agg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wandɨ me, akohoandɨ asu rehɨhoandɨ ana nindou dɨdɨyei Godɨndɨ hohoanɨmo süŋgurɨhindeimbɨ rananei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sisas ai asükai Gariri kurɨhoe kɨmɨ nindou yamundɨfe ratüpurɨ ra botɨmareandɨ. Nindou afɨndɨ ranai ahandɨ hoafɨ hɨmborɨmbo mafandeanda botambe farɨfi hoe haŋgɨfo-wamɨ mamaru. Asu nindou ranai gudianɨ hoe kɨmɨ mamarei. ");
INSERT INTO agg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Sisas ai aheimbo kafoefe hoafɨnambo yamundeandürühɨ yahuya, “Nindou mamɨ ai nümbürambe hu sesɨ ahurɨ bubumarandɨ. ");
INSERT INTO agg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ai hu sesɨ ahurɨ ra buburandane bɨdɨfɨrɨ ai nafɨnɨ pütapɨmayoa ndu ai tüküyahi masahüsi. ");
INSERT INTO agg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Bɨdɨfɨrɨ nɨmoei yahafɨ safambe hɨfɨ akɨdou yaŋgɨrɨ nɨŋgowambe pütapɨmayo. Hɨfɨ ra ragu hanɨkoate-wambo ahurɨ ranai nɨmai tütükɨmayo. ");
INSERT INTO agg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ŋga asu hüfɨhamɨndɨ ai pɨyowohüyo ahurɨ hapoadümbo maforo ra sore soremarandɨ. Sapo ahasɨharɨ ranai hɨfambe ragu hanɨkoate-wambo asu muŋgu yapataparɨmayo. ");
INSERT INTO agg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Asu bɨdɨfɨrɨ ahurɨ ranai tɨhoarɨ tɨhoarümbɨ wofɨ ranambe pütapɨmayoa gabudandühɨ hɨsɨkoatemayo. ");
INSERT INTO agg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Asu ahurɨ bɨdɨfɨrɨ ai hɨfɨ aboedambe safɨ pütapɨyowohü hɨsɨmayo. Nɨmɨndɨ mamɨ ranahandambo bɨdɨfɨrɨ ai 100 hɨsɨyo, asu bɨdɨfɨrɨ ai 60 hɨsɨyo, asu bɨdɨfɨrɨ ai 30 hɨsɨyo,” mehu ");
INSERT INTO agg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hoafɨ moendɨfembo yahumbo Sisas ai hoafɨyundürühɨ yahuya, “Nindou ai hɨmbo-ambeimbɨndühɨ ana, hoafɨ nda hɨmborɨmbiyu-wamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Süŋgunambo nindou afɨndɨ ranai bukürefoendane Sisas yaŋgɨrɨ mamaruwa ahandɨ süŋgururü-rundeimbɨ 12-yomo asu nindou ahambo süŋgurɨhorɨ-rɨhündeimbɨ ai kafoefe hoafɨ ranahambo düdumehindɨ. ");
INSERT INTO agg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Asu Sisas ai sɨmborɨ hoafɨyundürühɨ yahuya, “God ŋgɨnɨndɨ hɨfandarandɨ ranahandɨ dɨbo hoafɨ nɨmɨndɨ ra se fɨfɨrɨfembo-hünda God ai masagadürɨ, ŋga nindou weindanɨ manɨboadei ranaheimbo ana kafoefe hoafɨ yaŋgɨrɨyo hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ranɨmboane, Ai afɨndɨmbo hɨmboarɨ papɨndeimboyei, ŋga ai ŋgɨrɨ türüboadɨhi fɨfɨrɨndɨhindɨ. Ai afɨndɨ hoafɨ hɨmborɨndeimboyei, ŋga ahandɨ nɨmɨndɨ ŋgɨrɨ fɨfɨrɨndɨhindɨ. Ranɨmbo-anɨmbo ai wambo sowana asükai hɨhrɨndahi dɨdeiyanɨ God ai ahei moaruwai hohoanɨmo ra amboawi mbüsümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Awi se kafoefe hoafɨ ranahandɨ nɨmɨndɨ ra moai fɨfɨrundɨyo? Asu refeana bɨdɨfɨrɨ amurɨ kafoefe hoafɨ ra nüŋgundu fɨfɨrɨ-mandunda? ");
INSERT INTO agg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nindouyei mbusümo Godɨndɨ hoafɨ wataporɨmboayo ana, sapo nindou sesɨ ahurɨ nümbürambe buboafoareandɨ nahuraiane. ");
INSERT INTO agg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hoafɨ nafɨnɨ pɨrayo ana, sapo nindou Godɨndɨ hoafɨ hɨmborɨyeihanei, ŋga Satan ai nɨmehünou hoafɨ ra nindouyei mbusümonɨndɨ semündü raguanambo-reandühani. ");
INSERT INTO agg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bɨdɨfɨrɨ sesɨ ahurɨ nɨmoei yahafɨsafambe pütapɨmayo nahuraiane. Ai Godɨndɨ hoafɨ ra hɨmborɨyei hehi nɨmehünou semɨndɨmbo hɨhɨfɨ-hɨhɨfɨyeihɨ-anei. ");
INSERT INTO agg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ŋga ai moai hoafɨ ra ndorɨhi sahümündia ahei ŋgusüfoambe ragu ŋgɨnɨndɨ nɨmaro, ŋga ai moanɨ akɨdou yaŋgɨrɨ ŋgɨnɨndɨ nɨmboeihɨ anei. Ai Godɨndɨ hoafɨ hɨmborɨyei masahümündi ranahambo refe hoeifembo nindou ŋgorü ai tɨŋɨrɨfo sehindanɨ nɨmehünou hɨnɨŋgɨrɨhindühɨ-anei. ");
INSERT INTO agg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Bɨdɨfɨrɨ ai sesɨ ahurɨ tɨhoarɨ-tɨhoarümbɨ wohambe pütapɨmayo nahuraiane. Nindou ranai hoafɨ hɨmborɨyeihaneisɨ, ŋga ai hɨfɨndɨ moatükunɨmbo afɨndɨ hohoanɨmoyeihɨ napo afɨndɨ semɨndɨmbo ŋgusüfo parɨhindühɨ Godɨndɨ hoafɨ ranahambo gabudɨfoareanda asu ahurɨ ranai ŋgɨrɨ hɨsɨndo. ");
INSERT INTO agg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Asu sesɨ ahurɨ hɨfɨ aboedambe bubumayoa aboedɨ tükefeyo ranana sapo nindou düdi ai hoafɨ hɨmborɨyu haya fɨfɨreandühɨ tümafoareandɨ nahuraiane. Ranɨyo bɨdɨfɨrɨ ai hɨsɨ aboedɨ hɨsɨyowohü bɨdɨfɨrɨ ai 100 hɨsɨyo, bɨdɨfɨrɨ ai 60 hɨsɨyo, asu bɨdɨfɨrɨ ai 30 hɨsɨyo marandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sisas ai ahambo süŋgururü-rundeimbɨmbo hoafɨyupurühɨ yahuya, “Awi nindou ai ram hai wambürɨ asu fondɨ hoarehɨ dɨbonapɨmandɨhiyo? Wanɨ, ŋga ram ra fondɨwamɨ nɨmoamo ane nindɨhi arɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Muŋguambo moatükunɨ haponda dɨbombo eŋgoro ra süŋgunambo ana weindahɨ tükündɨfemboe. Asu nɨne-moatükunɨ gabudɨhi masɨhehindɨ ra süŋgunambo ana weindahɨ yagodomboe. ");
INSERT INTO agg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nindou ai hɨmboambeimbɨndühɨ ana, hoafɨ nda hɨmborɨmbiyu-wamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Asükai hoafɨyupurühɨ yahuya, “Hoafɨ hɨmborayomo ra se wudɨpoapondu hohoanɨmondɨmo. Se nindoumbo yimbuarɨhindürɨ ranɨ sɨmogodühɨ anɨmbo God ai sɨheimbo yimbundearühɨ asu ŋgorü bɨdɨfɨrɨ pandeambui. ");
INSERT INTO agg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nindou düdi ai bɨdɨfɨrɨ moatükuneimbayu ana, God ai asükai bɨdɨfɨrɨ dagadombui. Ŋga nindou düdi ranɨ-koateayu ana, nɨne akɨdou ahandɨ warambeahɨndɨ ra ndemündü raguanambo-ndeambui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sisas ai asükai hoafɨyuhɨ yahuya, “God ŋgɨnɨndɨ hɨfandarandɨ ranana nindou sesɨ ahurɨ nümbürambe buboafoareandɨ nahuraiane. ");
INSERT INTO agg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nindou ranani apuwanɨyo asu yaŋgɨrɨ ahandɨ ratüpurɨ ratüpurɨyuwanɨyo nɨmbokoanɨ sɨrühɨ sesɨ ahurɨ adükarɨ tükefeyo ra ai moai fɨfɨreandɨ. ");
INSERT INTO agg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hɨfɨ yaŋgɨrane sesɨ ahurɨ ra rareanda adükarɨ tüküfehü hɨsɨyo arandɨ. Ai moai fɨfɨreandɨ nüŋgureambombai weaŋgurühɨ emündɨ boatei tükündɨfe mbunda mbɨro ahurɨ tükündɨfihü anɨmbo ranambe hɨsɨ tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hɨsɨ ranai ho ŋgɨnɨndɨyowa nümbürɨ aharambürɨ ranai yimuŋgure-mɨndɨmboyo sɨmboanɨ yimuŋguramündɨ arandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sisas ai asükai hoafɨyuhɨ yahuya, “Sɨhɨrɨ God ŋgɨnɨndɨ hɨfandarandɨ ranahambo nüŋgunahuraiane mambɨsefa? Ranahambo hoafɨmbo nɨnɨ-kafoefe hoafɨnambo hoafɨmandefa? ");
INSERT INTO agg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","God ŋgɨnɨndɨ hɨfandarandɨ ranana hambomo hoarɨ nahurai akɨdou ahandɨ ndürɨ mastet hoarɨ hɨfɨ kararowandɨ nahuraiane. ");
INSERT INTO agg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ŋga hɨfefeyo ana, tɨkoanɨ nahurai tüküfe haya adükarɨ hamɨndɨ amurɨ nümbürambeahɨndɨ sesɨ ranahambo ŋgasündeandühane. Ranane afɨndɨ düdüdü papɨre haya nɨŋgowanɨ, ndu ai hei ranɨwamɨ ŋgɨsɨharühɨ ŋgeramborühɨ arɨhündɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sisas ai nɨmorehɨ nindowenihɨ afɨndɨ ranaheimbo kafoefe hoafɨ afɨndɨ wataporɨmbomarandɨ ahei hohoanɨmo ra sɨmogodühɨ. ");
INSERT INTO agg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ai ranaheimbo kafoefe hoafɨnambo yaŋgɨrɨ wataporɨmborandürɨ marandɨ. Ŋga ahambo süŋgururü-rundeimbɨ aiyaŋgɨrɨ nɨmarɨmondanɨ ana, hoafɨ ranahandɨ nɨmɨndɨ ra yamundeapurɨ-marandɨ. ");
INSERT INTO agg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mamɨ ranɨ nɨmbambe ahambo süŋgururü-rundeimbɨmbo yahuya, “Sɨhɨrɨ Gariri kurɨhoe ra ŋgorü-goanɨnɨ ŋgefomboane,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ranɨyo nɨmorehɨ nindowenihɨ afɨndɨ ra raru hɨnɨŋgɨrüwurɨ houmbo bot Sisas mamaru ranambe fareafu houmbo sowaründümo mahomo. Asu bot bɨdɨfɨrɨ amurɨ ranai amboanɨ ai-babɨdɨmbo maho. ");
INSERT INTO agg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ai hɨfomondane, Gariri kurɨhoe ranambe ŋgɨnɨndɨ hamɨndɨ werɨ ranai tükümefeyo. Ranɨyo hoe ranai hafo kaifoairandühɨ tükühefembo yaŋgɨrɨmayo. ");
INSERT INTO agg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Asu Sisas ai daboadanɨ pirowamɨ mbɨro nande haya apuane, ahambo süŋgururü-rundeimbɨ ai yaŋgɨrɨ ruwurühɨ yahomoya, “Nindou Yamundo-randeimbɨ, sɨhɨrɨ yɨfɨmbo yaŋgɨrayefɨ ranahambo awi se moai hohoanɨmoyafɨyo?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sisas ai botɨfi hoe asu werɨ ranahafembo ŋgɨnɨndɨ hoafɨyupɨrühɨ yahuya, “Rühüsafɨ kɨkɨndandɨfe,” mehua hoafɨ nɨŋgowambe kɨkamɨndühɨyo hoe asu werɨ ai afure pimareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sisas ai ahambo süŋgururü-rundeimbɨmbo hoafɨyupurühɨ yahuya, “Nɨmboe se yɨhɨmboayomoa? Awi se anɨhondümbofe-koate-wamboyomo?” mehu. ");
INSERT INTO agg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ahambo süŋgururü-rundeimbɨ ai ahamundɨhoarɨ sɨmborɨ ndüwurɨyomondühɨ yahomoya, “Nindou nda nüŋgunahurai nindouyua? Moanɨ hoe afɨndɨ-afɨndɨmayo asu werɨ ranai ahandɨ hoafɨ hɨmborɨyafehü afurɨmarɨneandɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo Gariri kurɨhoe ra botambe barɨhoemo houmbo Gerasa-yafe hɨfambe mahomo. ");
INSERT INTO agg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sisas ai bot hɨnɨŋgɨre haya kusɨfuendanɨyo, nindou mamɨ ahandɨ fiambe moaruwai nendɨ nɨmareimbɨ ai yɨfɨ sɨhehi rɨhündeimbɨ hoŋguambeahɨndɨ hu ahamboso tükümefiyu. ");
INSERT INTO agg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nindou ranai ana yɨfɨ sɨhehi rɨhündeimbɨ hoŋguambe-ani apu arandɨ. Ranane ŋgɨrɨ ahambo senɨnambo amboanɨ yirɨwarɨ hüputüpu-ndürɨndümo. ");
INSERT INTO agg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nindou ranahambo afɨndɨmbo senɨnambo yirɨwarɨ hüputüpurɨ-horɨmɨndei marɨhündɨ, ŋga sen ra gurɨhaimarandɨ. Ai ŋgɨnɨndɨ hamɨndɨ-wambo nindou ŋgorü ai-amboanɨ moai ahambo kɨkɨhɨrümündu. ");
INSERT INTO agg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nɨmbokoanɨ asu sɨrühɨ nindou ranai yɨfɨ sɨhehi rɨhündeimbɨ nɨmoei-ambe asu hɨfɨ wafu ranambe hoahoaŋgura-marandɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sisas ai hapoadümbo aŋgunɨ huambe nindou-mayu ranai hoeirirɨ haya pɨpɨyu hu ahandɨ wagabe yirɨ yimbu pusɨre mamaru. ");
INSERT INTO agg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nindou ranai puküna hoafɨ karɨhoehü yahuya, “Sisas, se-ana God Nɨmoamo Hondü ahandɨ nɨmorɨ anafɨ, se wambo nɨnɨ nünüŋgu-fendɨrɨmboyafa? Ro sɨhambo düduarɨheanɨnɨ, Se Godɨmbo dabarɨndafoandühɨ ŋgɨrɨ sɨhambo nɨnɨ-moatükunɨ randɨheandɨ mbɨsafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ramehu ra sapo Sisas ai hoafɨyuhɨya, “Moaruwai nendɨ se nindou ranahandɨ fiambeahɨndɨ kosɨfoao,” mehu ranɨmboyo. ");
INSERT INTO agg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Asu Sisas ai düdureandühɨ yahuya, “Sɨhafɨ ndürɨ nɨne?” mehuamboyu. Asu moaruwai nendɨ ranai yahoya, “Wandɨ ndürɨ ana amiane. Sapo ro ana afɨndɨ sɨrɨhünd-anefɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Moaruwai nendɨ ranai ranɨ hɨfɨhündɨ yowanɨ yɨhoefɨmbo hefoefemunɨ-poanɨ yaho haya Sisasɨmbo hüti hoafɨmarɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ranɨ fikɨmɨ hɨfɨ wafuambe moatei afɨndɨ ranai sesɨ sahüsihɨ burɨyei wakɨmarɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ranɨyo moaruwai nendɨ ranai Sisasɨmbo hüti hoafɨyeihɨ seiya, “Se yɨhoefɨmbo koandɨ-hawamuna moatei akɨmɨ nda burayei ahei fiambendahumboane,” masei. ");
INSERT INTO agg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ranɨyo Sisas ai hɨnɨŋgɨ-mareandüra rasüŋgumehindɨ. Moaruwai nendɨ ranai nindoundɨ fiambeahɨndɨ kosɨfoehi hehi moatei akɨmɨ burɨmayei ahei fiambemehindɨ. Ranɨyo 2,000 moatei ranai hɨrɨpɨnɨ pɨyei hehi gügürɨyei hanimbo kurɨhoeambe hoe karɨhüsi hehi yɨfɨsafɨ-mayei. ");
INSERT INTO agg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nindou moatei hɨfandɨmarundɨ ranai fefou houmbo homo adükarɨ ŋgoafɨyo asu akɨdou ŋgoafɨ adaburo ranɨyo ra wataporɨmbomarundɨ. Ranɨyo ranühündambo nɨmorehɨ nindowenihɨ ranai nɨne-moatükunɨyo moateimbo tükümefeyo ra hoeifembo mahei. ");
INSERT INTO agg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ai hei Sisasɨmboso tüküyahi hoeirɨhindane nindou horombo ahandɨ fiambe moaruwai nendɨ afɨndɨ nɨmareimbɨ-mayu ranahambo hoeimarɨhorɨ. Ai asükai aboedɨ hohoanɨmo fɨfɨre hohoanɨmoyuhümbo hoearɨ güde haya mamaruwa hoeirɨhorɨ hehi yɨhɨmbomarɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nɨne-moatükunɨ Sisas ramareandɨ hoeifembo mahei ranai asükai hɨhɨrɨyahi hei nindou horombo moaruwai nendɨ nɨmareimbɨ-mayu asu moatei ranahambo amboanɨ wataporɨmbo-marɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ranɨyo nɨmorehɨ nindowenihɨ ranai ranɨ hoafɨ ra hɨmborɨyei hehi Sisasɨmbo ranɨ hɨfɨhündɨ ŋgorü-goanɨnɨ hombo hüti hoafɨmarɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Asu Sisas ai botambe mafarɨfiyuwamboyo nindou horombo moaruwai nendɨ nɨmareia hefoareandeimbɨmayu ranai aidɨbo hombo hüti hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ŋga asu Sisas ai ahambo moai yɨnɨ yahundo. Ai hoafɨyundowohü yahuya, “Se sɨhafɨ worɨnambo ŋgafɨ fikɨmɨnɨndɨmbo Adükarɨ ai sɨhafɨ fimbo hɨpoambo-reanɨnühɨ ramareanɨnɨ ranahambo wataporɨmbondandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ranɨyo nindou ranai hu Dekaporis hɨfɨhü ahandɨ fimbo wataporɨmbo-maranda nɨmorehɨ nindowenihɨ afɨndɨ ranai mahepünahindɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sisas ai Gariri kurɨhoe ra botambe farɨfi haya ŋgorü goanɨnɨ huane nindou afɨndɨ ranai ahandɨ hoafɨ hɨmborɨmbo mafandeandɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ranɨyo Suda-yei rotu worɨ hɨfandɨra randeimbɨ, ahandɨ ndürɨ Sairus, ai mahu. Ai hu Sisasɨmbo hoeirirühɨ ahandɨ yirɨkɨmɨ yirɨ yimbu pusɨre mamaru. ");
INSERT INTO agg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ai Sisasɨmbo hüti hoafɨyundo hoaŋguhü yahuya, “Wandɨ nɨmorehɨ nɨmorɨ ai yɨfɨmbo yaŋgɨrane, ŋga se dɨdɨfɨ warɨ nandowandanɨ anɨmbo aboedɨmbeyo-wamboane,” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Asu Sisas ai aidɨbo mahua nɨmorehɨ nindowenihɨ afɨndɨ ranai ahandɨ süŋgu mahei. Ranɨyo ahandɨ fikɨmɨ gugureandühɨ nɨnendɨ-marɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Asu nindou gugurɨmareandɨ ranambe nɨmorehɨ mamɨ 12 hɨmbanühɨ-feimbɨmbo amoamo watɨkoafɨra-marandɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ranɨyo nɨmorehɨ ranai dokta hoeifepurɨmbo ahambo fehefembo-hünda ahandɨ kakɨ afɨndɨ saimarandɨ. Asu dokta ranai moai ahambo farɨhoemondanɨ aboedɨ tüküfeyo, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nɨmorehɨ ranai Sisasɨndɨ hoafɨ ra hɨmborɨyo haya ho nindou afɨndɨ ranahei mbusümo manɨŋgo. Ranɨyo ai Sisasɨndɨ daboadanɨ ho ahandɨ hoandarɨ hoearɨ ra sündɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ai ahandɨhoarɨ yare hohoanɨmo-yowohü yahoya, “Ro ahandɨ hoearɨ yaŋgɨrɨ amboanɨ sündarɨheandɨ ra aboedɨndamboyahɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ramare-andamboyo nɨmehünou amoamo watɨkoafɨmarandɨ-mayo ra kɨkɨramɨndühɨ asu ahandɨ fiambe aŋgünɨ ranai aboedɨmayoa fɨfɨrɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Asu Sisas ai ahandɨ fiambeahɨndɨ ŋgɨnɨndɨ makosɨfoenda fɨfɨre haya hɨhɨrɨfi düdurearühɨ yahuya, “Düdi wandɨ hoearühɨ sündɨmareanda?” mehu. ");
INSERT INTO agg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ahambo süŋgururü-rundeimbɨ ai hoafɨyomondühɨ yahomoya, “Nindou afɨndɨ eŋgoro ra hoeiarowandane asu düdi sündɨmareandɨ safɨ hawambo düduwefoanda?” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ŋga awi Sisas ai düdi ahandɨ hoearɨ fihɨ sündɨmareandɨ ra fɨfɨrɨndɨhea yahu haya kokomara hu. ");
INSERT INTO agg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nɨmorehɨ ranai ahambo ranɨ-moatükunɨ tükümefeyo ra fɨfɨre haya yɨhɨmboyohü hɨhamɨndarɨ-mayo. Ranɨyo ho Sisasɨndɨ yirɨkɨmɨ yimɨndɨhona nɨmarɨmbo muŋguambo moatükunɨ ahambo tükümefeyo ra wataporɨmbomarandɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sisas ai nɨmorehɨ ranahambo hoafɨyundowohü yahuya, “Nɨmorɨ akɨdou, se anɨhondümbo-arowandɨ ranɨmbohünda seana asükai aboedanafɨ. Sɨhafɨ aŋgünɨ aboedɨmefeyo ranɨmbohünda se ŋgusüfo afurɨndo kündo hawa ŋgafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sisas ai wataporɨmborandühɨ nüŋguambe nindou bɨdɨfɨrɨ ai Suda-yafe rotu hɨfandɨ randeimbɨndɨ worambeahɨndɨ sɨnɨmo hoafɨyomondühɨ yahomoya, “Sɨhafɨ nɨmorehɨ nɨmorɨ yɨfɨmayo. Ŋga nindou yamunde randeimbɨmbo tɨŋɨrɨfo segodopoanɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Asu Sisas ai moai ahamundɨ hoafɨ ranahambo hɨhɨmborɨyu. Ai Suda-yafe rotu hɨfandɨrandeimbɨ ranahambo yahundoya, “Yowanɨ, yɨhɨmbo-yopoanɨ, ŋga se moanɨ Godɨmbo anɨhondümbo-ndowandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sisas ai nindou ranaheimbo ai-babɨdɨmbo hombo yowanɨ yahu hɨnɨŋgɨrerü haya, Pita, Sems, Son, asu ahandɨ akɨdɨ Sems ahamumbo yaŋgɨrɨ süŋgureapurɨ haya mahu. ");
INSERT INTO agg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ai homo Suda-yafe rotu bogorɨndɨ worɨkɨmɨ tüküyafundühɨ Sisas ai hoeireandane aranɨ hoafɨ afɨndɨ afɨndɨ-mayei. ");
INSERT INTO agg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ai worambe farɨfi hafu hoafɨyundürühɨ yahuya, “Nɨmboe se aranɨ hoafɨ afɨndɨ-afɨndayeia? Nɨmorɨ ndanana yɨfɨyopoanɨ, ŋga moanɨ apomboane,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Asu nindou ranai ahambo tɨkɨfɨnambo-marɨhorɨ. Ai aheimbo ranɨ worambeahɨndɨ hɨhaifoarearü mbura, nɨmorɨ ranahandɨ hondafɨndɨyafe asu ahandɨ süŋgururü-rundeimbɨmemo aheimbo yaŋgɨrɨ semündündürɨ haya, nɨmorɨ yɨfɨ meŋgoro ranɨ worɨ safanɨ kamefoehindɨ. ");
INSERT INTO agg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ai hüfu nɨmorɨ ranahandɨ watɨŋarɨhü kɨkɨhɨramündɨ haya hoafɨyundowohü yahuya, “Tarita kumi,” mehu. Hoafɨ ranahandɨ nɨmɨndɨ ana ndahuraiane, “Nɨmorehɨ nɨmorɨ yihoarɨfɨ ro hoafehanɨnɨ, se botɨyafo,” yaho ranane. ");
INSERT INTO agg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Asu nɨmehünou nɨmorehɨ nɨmorɨ ranai botɨfe haya mahowa nindou ranai mahepünehindɨ. Nɨmorɨ ranana 12 hɨmbanɨ yoweimbɨyo. ");
INSERT INTO agg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sisas ai hoafɨyundürühɨ yahuya, “Se yowanɨ nindou mamɨmbo amboanɨ ndanɨ moatükunɨ nda hoafɨyopoanɨ. Nɨmorɨ ranahambo sesɨ sahündo anɨmbo mbɨseso,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sisas ai ranühɨ hɨnɨŋgɨre haya ahandɨ ŋgoafɨ hondünambo mahua asu ahambo süŋgururü-rundeimbɨ ai ai-babɨdɨmbo mahomo. ");
INSERT INTO agg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ranɨyo moanɨ nɨmarɨmbo sihɨ Suda-yafe rotu worambe kefuai hüfu nɨmorehɨ nindowenihɨmbo yamundɨmareandürɨ. Nindou afɨndɨ ranai hɨmborɨyei hehi hepünahindühɨ seiya, “Ndanɨ ndofe fɨfɨrɨfe nda nahünda semündümboyua? Asu hepünɨfeimbɨ moatükunɨ refembo ŋgɨnɨndɨ ra nahündambo semündümboyua? ");
INSERT INTO agg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aiana worɨmbora randeimbɨ nindou yaŋgɨr-ani. Asu ai Mariandɨ nɨmorɨ Sems, Sosep, Sudas asu Saimon ahamundɨ amoŋgo-ani. Asu ahandɨ rehɨmamɨ ai nda sɨhɨrɨ babɨdɨ anɨmboei,” sei hehi Sisasɨmbo ŋgusüfoambe yiboaruko-marɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Asu Sisas ai hoafɨyundürühɨ yahuya, “Godɨndɨ hoafɨ hoafɨyu-randeimbɨ ai muŋguambo ŋgoafɨhü ndürɨmb-ani. Ŋga ahandɨ ŋgoafɨ hondühɨ ahandɨ fikɨmɨnɨndɨ-so worambe ana ndürɨkoate-ani,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Asu Sisas ai ranühɨ moai hepünɨfeimbɨ moatükunɨ rareandɨ, ŋga yimbumamɨ aŋgünümbɨ nindou yaŋgɨrɨyo warɨ manandeanda aboedɨmehindɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ranɨyo nindou ahambo anɨhondümbofe-koatemayeia hepünɨmefiyu. Ranɨyu Sisas ai ranühɨ ŋgoafɨ adaburo ra hoahoaŋguhü Godɨndɨ hoafɨ yamundɨ-mareandürɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ai ahambo süŋgururü-rundeimbɨ 12 ahamumbo nindouyei fiambeahɨndɨ moaruwai nendɨ hefoefembo ŋgɨnɨndɨ sagapurɨ mbura yimbu-yimbure koamarɨhepurɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Sisas ai yare hoafɨyupurühɨ yahuya, “Se ŋgomondühɨ ra nɨnɨ-moatükunɨ ndowandümboemo, ŋga nɨmɨnɨmɨ yaŋgɨrɨ anɨmbo ndowandümo. Se yowanɨ bret, arü asu kakɨ ranɨ-moatükunɨ sandɨfe semɨndɨ-poanɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Se su güdundɨ, ŋga hoearɨ ana güdarundɨ ranɨ yaŋgɨrɨ anɨmbo güdu ndowandümo ŋgomo. ");
INSERT INTO agg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Asu se homo ŋgorü ŋgoafɨhü tüküyafu houmbo ŋgorü worambe ahafomo ra ranɨ worambe yaŋgɨrɨ nɨmandɨmo mbundumbo ŋgorü-goanɨnɨ asükai ŋgomo. ");
INSERT INTO agg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ŋgomondanɨ ranɨ ŋgoafɨhündɨ ranai sɨhamumbo worɨnɨfepurɨ-koatendeihɨ sɨhamundɨ hoafɨ hɨmborɨ-koatendeianɨ, se ŋgoafɨ ra hɨnɨŋgɨndundɨ. Se hombo mbɨsɨmombo ana, sɨhamundɨ tɨŋarɨhündɨ hasüfɨ ra püpürüfɨboadu houmbo ŋgomo ranaheimbo God ai moaruwaimbo-mbɨreandürɨ yaho nafuiyondürɨmbo-hünda,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ranɨyo Sisasɨmbo süŋgururü-rundeimbɨ ranai homo nɨmorehɨ nindowenihɨmbo hoafɨ bokarɨhoemondühɨ yahomoya, “Sɨhei ŋgusüfoambe moaruwai hohoanɨmo hɨnɨŋgɨndɨhindühɨ sɨmborɨ hohoanɨmo süŋgundɨhindɨ,” mehomo ");
INSERT INTO agg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Asu ai homo nindouyei fiambeahɨndɨ moaruwai nendɨ hefoaru, aŋgünümbɨ nindouyewamɨ werɨ hoe karunda aŋgünümbɨ nindou ai aboedɨ tüküyahi marɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sisas ai muŋgu-moatükunɨ ramareandɨ hoafɨ ra adükarɨ bogorɨ Herot ai hɨmborɨmayu, sapo ahambo muŋguambo nindou fɨfɨrɨhorɨ hehimbo wambo. Ranɨyo bɨdɨfɨrɨ nindou ai seiya, “Son hundüra randeimb-ani yɨfɨhündɨ botɨfi haya. Sapo ranɨmboane hepünɨfeimbɨ moatükunɨ yare arandɨ,” masei. ");
INSERT INTO agg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Asu bɨdɨfɨr nindou seiya, “Aiana Eraisa-ani,” masei. Asu bɨdɨfɨrɨ nindou seiya, “Aiana Godɨndɨ hoafɨ hoafɨyomo rundeimbɨ horombo yɨfɨmemo nahurai-ani,” masei. ");
INSERT INTO agg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot ai ranɨ hoafɨ ra hɨmborɨyu hayambo yahuya, “Ro Son hundürüra randeimbɨmbo ana horombo mbɨro kɨkɨmarɨhehinɨ. Ŋga asu haponda asükaiyu yɨfɨhündɨ botɨfimboyu?” mehu. ");
INSERT INTO agg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Horombo Herot ai ahandɨ akɨdɨ Firipɨndɨ nɨmorehɨ Herodias masemündu. Ranɨmbo Son ai Herotɨmboya, “Aboedɨ hohoanɨmoyopoanɨ sɨhafɨ akɨdandɨ nɨmorehɨ masowandɨfɨ,” yahundo-marandɨ. Ranɨmboyo Herot ai nindou bɨdɨfɨrɨ koamarɨhepura Sonɨmbo kɨkɨhɨrundümo mburumbo karabus-ambe hɨnɨŋgɨmarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias ai Sonɨmbo ŋgɨnɨndɨrɨrɨhü hɨfokoefimbo hohoanɨmomayo, ŋga ai ŋgɨrɨndo. ");
INSERT INTO agg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Sapo Herot ai Sonɨmbo yɨhɨmborürühɨ-wambo. Ai fɨfɨreandɨ Son ai Godɨndɨ hɨmboahü mbumundɨ nindou-mayua ranɨmbo Herot ai ahambo hɨfandürɨ-marandɨ. Ai Sonɨndɨ hoafɨ hɨmborɨyuhü ana, ŋgusüfoambe moaruwairɨrɨhü afɨndɨ hohoanɨmoyuhani. Ŋga asu ahandɨ hoafɨ hɨmborɨmbo hohoanɨmoyuhani. ");
INSERT INTO agg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodias ai Sonɨmbo mbɨro kɨkɨfimbo, nafɨ kokorambo hoeimareandɨ. Herot ai ahambo hondɨ ai wakɨmarɨmɨndo ranɨ sihɨ gafmanɨ-yomondɨ bogorɨ, ami-yomondɨ bogorɨ asu Gariri hɨfandu-rundeimbɨ ahamumbo sesɨ sɨndɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ai sowasümondühɨ nɨmarɨmondane, Herodiasɨndɨ nɨmorehɨ nɨmorɨ ai hafo hɨhɨfɨ-hɨhɨfɨyo wakɨmareandɨ. Ranɨyo Herot asu bɨdɨfɨrɨ boboagorɨ sesɨ sowasümondühɨ mamarɨmo ai ranahambo afɨndɨ hɨhɨfɨ-hɨhɨfɨmemo. Ranɨyo adükarɨ bogorɨ Herot ai nɨmorehɨ nɨmorɨ ranahambo düdureandühɨ yahuya, “Se nɨne-moatükunɨmboyo hohoanɨmo-ayafɨ ra ndahanɨnɨmboyahɨ, ŋga se wambo hoafɨyafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herot ai dabarɨfi hoafɨyundowohü yahuya, “Se nɨne-moatükunɨmboyo hoafayafɨ ana, ndahanɨnɨmboyahɨ. Se hɨfɨ hɨfandarɨhandɨ ranahambo kɨkɨrowandɨrɨ asafɨ ana, ranamboanɨ ro kɨkɨndɨheanɨnɨ-mboyahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nɨmorehɨ nɨmorɨ ranai hondɨ sowana hɨhɨrɨfe ho düdureandühɨ yahoya, “Nɨnɨ-moatükunɨmbo düdumandahea?” mehoamboyo. Hondɨ ai yahoya, “Son hundürüra randeimbɨndɨ mbɨrombo anɨmbo düdundafoandɨ,” mehondoamboyo. ");
INSERT INTO agg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nɨmorehɨ nɨmorɨ ranai hɨhɨrɨfe ho adükarɨ bogorɨmbo anahoya, “Hapondanɨ hamɨndɨ Son hundürüra randeimbɨndɨ mbɨro pretambe foando hawa ndawandɨrɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ai ranɨ hoafɨ ra hɨmborɨyu haya ahambo ŋgusüfoambe moaruwai-marɨrɨsɨ, ŋga sapo nindou fandu masowasümo ahamundɨ hɨmboahü nɨne-moatükunɨ se hoafayafɨ ro randɨheamboyahɨ mehu. Ranɨmboyu ai nɨmorehɨ nɨmorɨ ranahandɨ hoafɨ süŋgufembo ambe yahokoatemayu. ");
INSERT INTO agg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Ranɨyu adükarɨ bogorɨ ranai ami mamɨ koamarɨheira Sonɨndɨ mbɨro semɨndɨmbo mahüfu. Ai hüfu Sonɨmbo karabus worambe mbɨro kɨkɨrirɨ mbura ahandɨ mbɨro ra pretambe foare semündü hu nɨmorehɨ nɨmorɨ ranahambo masagado. Ranɨyo nɨmorɨ ai semɨndɨ ho hondambo masagado. ");
INSERT INTO agg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sonɨmbo süŋgururü-rundeimbɨ ai ranɨ hoafɨ hɨmborɨyomo houmbo homo karabus worambeahɨndɨ fi-nɨmoko sowandümo homo hoŋguambe masɨhawurɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sisasɨndɨ hoafɨ sowandümo homo-rundeimbɨ ai homo ai-babɨdɨmbo mamühɨyafundühɨ wataporɨmemo. Ai ratüpurɨ rarundühɨ nɨmorehɨ nindowenihɨmbo Godɨndɨ hoafɨ yamundɨmarundürɨ ranahambo. ");
INSERT INTO agg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nindou afɨndɨ ranai fande bukürefoe-marandamboyo Sisas ai ahandɨ hoafɨ sowandümo homorundeimbɨ babɨdɨmbo sesɨ sesɨ-koatememo. Ranɨmboyu hoafɨyupurühɨ yahuya, “Andai sɨhɨrɨpoanɨmbo nindou nɨmarɨ-koateandühɨ ŋgefühɨ anɨmbo akɨdou fi-handɨhu,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ranɨyomo ai yaŋgɨrɨ botambe fareafu houmbo nindou nɨmarɨ-koateandühɨ mahomo. ");
INSERT INTO agg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ŋga nɨmorehɨ nindowenihɨ afɨndɨ ranai hoeirɨhi fɨfɨrɨhipurɨ, ranɨmboyo nindou afɨndɨ ranai Sisas ahandɨ süŋgururü-rundeimbɨ babɨdɨmbo homboyomondanɨ ahei ŋgoafɨ hɨnɨŋgɨrɨhi hehi Sisasɨmbo sowana pɨpɨna hei ai-boatei tükümehindɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ranɨyo Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo botambe homo tüküyafundane, nindou afɨndɨ ranai hɨfanda meŋgoro. Ranɨyu hoeireanda mayoa sipsip hɨfandɨyo-randeimbɨ nindou hɨfandɨyo-koate nahurai fimayeia hɨpoambo-reandürühɨ afɨndɨ yamundɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Asu süŋgunambo nɨmbambe hüfɨhamɨndɨ ai hanuambe hoafɨyomondühɨ yahomoya, “Ndanühɨ ana nindou nɨmarɨ-koatereandühane ndeara hüfɨhamɨndɨ ahanu. ");
INSERT INTO agg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ranɨmbo-hündambo anɨmbo nɨmorehɨ nindowenihɨ ranaheimbo koarɨhawandüra hei ŋgoafɨ akɨmɨ adaburo ranühɨ aheihoarɨ sesɨ pemɨyei mbɨsahüsi,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ŋga asu Ai sɨmborɨ hoafɨyupurühɨ yahuya, “Se sesɨ dabudürɨ,” mehuamboemo. Ai sɨmborɨ ahambo hoafɨyomondühɨ yahomoya, “Awi se hohoanɨmoyafanɨ ro afɨndɨ handret kinanambo aheimbo bret pemɨyo saimboyo?” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sisas ai düdureapurühɨ yahuya, “Nüŋgunümbɨ bretɨyo se sɨhoemomboemoa? Homo hoeiru,” mehuamboemo. Homo hoeirunda mayoambo yahomoya, “Hondahüfeimbɨ bret asu yimbu kinɨ ranane eŋgoro,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sisas ai ahamumbo hoafɨmayua nindou ranaheimbo hoafɨmayomonda yɨbobo-yɨboboyahi hehi mamarei. ");
INSERT INTO agg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mamarei ra bɨdɨfɨrɨ 100, asu bɨdɨfɨrɨ 50, ranɨyei yɨbobo-yɨboboyahi mamarei. ");
INSERT INTO agg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sisas ai bret hondahüfeimbɨ asu kinɨ yimbu ra semündü haya sünambe hɨmboyu hafuhü Godɨmbo hɨhɨfɨrürɨ mbura, hɨfɨtɨre haya ahandɨ süŋgururü-rundeimbɨmbo masagapurɨ nindou ranaheimbo yimbufembo. Asükaiyu kinɨ akɨdou yimbu ranamboanɨ hɨfɨtɨre haya yimbumareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Muŋguambo nindou ranai sesɨ ra sahüsimbo sɨmoŋgorɨ-marɨhümündi. ");
INSERT INTO agg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ranɨyo Sisasɨmbo süŋgururü-rundeimbɨ ai bret asu kinɨ bɨdɨfɨrɨ bɨdɨfɨrɨ kurɨmayo ra 12 wambürambe wambürɨhɨru hafombo tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nindou sesɨ masahüsi ranana 5,000-yei. ");
INSERT INTO agg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sisas ai nɨmehünou ahambo süŋgururü-rundeimbɨmbo botambe farɨfe hefe Gariri kurɨhoe behefe hefe ai-boatei Betsaida ŋgoafɨnambo hombo hoafɨmayupurɨ. Ŋga aiana awi nɨmarɨ mburɨmbo nindou ra koarɨhefendürɨmboyu. ");
INSERT INTO agg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nɨmorehɨ nindowenihɨ ra koarɨheirɨ mbura asu ai Godɨmbo dɨdɨbafɨfembo hɨfɨ wafuanambo mahafu. ");
INSERT INTO agg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ranɨ nɨmbambe ahambo süŋgururü-rundeimbɨ ai botambe Gariri kurɨhoe haŋgɨfowamɨyomo, ŋga asu aiana ŋgɨndanɨyu. ");
INSERT INTO agg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sisas ai ahambo süŋgururü-rundeimbɨ hoeireapurane werambe bot ra ahamumbo kameihü nɨnendɨ-mareapura asu bot ra semɨndɨ hombo purɨna watɨharɨmarundɨ. Ranɨyo Sisas ai si hoafɨmbo safɨ ahamumbo sowana bot ra ŋgasünde haya hoe haŋgɨfowamɨ pütapɨmayu hu. ");
INSERT INTO agg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ŋga asu ai hoeirüwuranɨ hoe haŋgɨfowamɨ pütapɨmayua yifiaf-ani yahomo houmbo hasɨheimemo. ");
INSERT INTO agg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ai muŋguambo hoeirüwura mayoa yɨhɨmbo-mayomondamboyu, ai ahamumbo nɨmehünou hoafɨyupurühɨ yahuya, “Se yɨhɨmbo-ndɨmboemo, ŋga ŋgɨnɨndɨ nɨmandümo. Ndanana ro-anahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Asu ai botambe farɨfi hafu ai-babɨdɨmbo mamaruwa hoewerɨ ranai afurɨmareanda mahepünafundɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ŋga Sisas ai hondahüfeimbɨ bret hepünɨfeimbɨ moatükunɨ ramareandɨ ra moai wudɨpoaporu fɨfɨrundɨ sapo ahamundɨ hohoanɨmo ranai tapɨhamɨyohü wambo. ");
INSERT INTO agg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ranɨyomo ai botambe kurɨhoe ra barɨhoemo gudianɨ Genesaret ŋgoafɨkɨmɨ bot ra hɨmondɨndümo hɨnɨŋgɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ai botambeahɨndɨ makusɨfoendambo nindou ranai nɨmehünou fɨfɨrɨmarɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ŋgoafɨ ranɨ ŋgoafɨkɨmɨ adaburo ranühɨ hahabodeihü hoafɨmayeiya, aŋgünümbɨ nindou afɨndɨ safɨsendambe-rɨhindürɨ Sisas nüŋguhɨ sahümündindürɨ hei marɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ranɨyo muŋguambo ŋgoafɨ adaburo ranühɨ, nahi Sisas ai huanɨ aŋgünümbɨ nindou ra fufurɨhü-mündindürɨ hei fandɨhi-rühündühɨ sɨhehindürɨ marɨhündɨ. Ranɨyei ahandɨ warɨ hoandarɨ ŋgɨsɨharɨ hoearɨ ra aŋgünümbɨ nendɨ ai sündɨmbɨrɨhindɨ sei hehi hüti hoafɨmayei. Asu ahandɨ hoearɨ sündɨmarɨhindɨ ranai asükai aboedɨ tükümehindɨ. ");
INSERT INTO agg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisihündɨ bɨdɨfɨrɨ ai ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ nindou babɨdɨmbo Serusarem ŋgoafɨhündɨ sɨfomo Sisasɨmbo hoeimarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ranɨyo hoeirundanɨ Sisasɨmbo süŋgururü-rundeimbɨmemo ranai warɨ popoaikoate sesɨ sowasümondühɨ mamarɨmo. Warɨ popoaikoate sesɨ sesɨmbo ranana moaruwaiane. ");
INSERT INTO agg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Sapo Farisi asu Suda-hündɨ aiana ai boagɨrɨ süŋgumarundɨ ranɨmboane ŋgɨrɨ warɨ popoaikoate sesɨ dagüdi. ");
INSERT INTO agg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Asu sesɨ maket ambeahɨndɨ pememo amboanɨ sesɨ popoaihefekoate ana, ŋgɨrɨ dowadümo. Sapo ai boagɨrɨ refemarandɨ süŋgumbo hɨpɨrɨ napo ra popoaindɨhou mbundümbo anɨmbo mandu dowadümboemo. ");
INSERT INTO agg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ranɨyo Farisi asu ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ ai Sisasɨmbo hoafɨyomondühɨ yahomoya, “Nɨmboe sɨhambo süŋgurunɨnɨ rundeimbɨ ai boagɨrɨ ahɨnɨ ra süŋgufe-koateayomoa? Asu nɨmboe warɨ afɨsaho kapeihɨ sesɨ asowasümoa?” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ranɨyu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Godɨndɨ hoafɨ hoafɨyurandeimbɨ Aisaia ana anɨhondümbo yimbu yafambeimbɨ sɨhamumboyu hoafɨmayu. Ai ndare sürü papɨrandühɨ yahuya, ‘Nindou ndanai ana yafambe yaŋgɨrane wambo aboedani asei, ŋga ahei hohoanɨmoana aŋgunane eŋgoro. ");
INSERT INTO agg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Aiana nindouyei ahɨnümbɨ hohoanɨmo ranane yamundɨhindühɨ Godɨndɨ hoafane nda asei, ranɨmboane ai wambo hohoanɨmoayei ra moanɨpoane,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Seana Godɨndɨ ahɨnümbɨ hohoanɨmo ra hɨŋgɨrɨru houmboanemo nindouyei hohoanɨmo yaŋgɨrane süŋguarundɨ.” ");
INSERT INTO agg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ranɨyo ai hoafɨyupurühɨ yahuya, “Seana Godɨndɨ ahɨnümbɨ hohoanɨmo ranahambo ambeyaho hɨnɨŋgɨfehümbo sɨhamundɨ hohoanɨmo süŋgufembo yaŋgɨrane hohoanɨmoemo. ");
INSERT INTO agg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sapo Moses yahuya, ‘Se sɨhafɨ meapeyafe hoarehɨndafɨ,’ asu ‘Düdi ahandɨ hondamboyu afɨndamboyu moaruwai hoafayu ana, yɨfɨmbiyuwamboane,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Ŋga se ndaru hoafɨyomondühɨya, ‘Nindou ranai ahandɨ hondafɨndambo fehefe kakɨ napoeimbanisɨ, ŋga hondafɨndambo hoafɨndupɨrühɨya, “Ndanɨ kakɨ ana ro Godɨmbo saimbo masɨheheandane,” mbüsu ana, asu ŋgɨrɨ nindou ranai kakɨ ranambo ahandɨ hondafɨndambo fehefepɨrɨmbo yɨnɨ mbɨsɨmo,’ yahomo arundɨ. ");
INSERT INTO agg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ranɨmboane Godɨndɨ hoafɨ ra hɨnɨŋgɨrundühɨ asu se boagɨrɨ-yafe hoafɨ ra süŋgu-arundɨ asu se afɨndɨ moatükunɨ rahurai raru arundɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sisas ai nindou afɨndɨ ranaheimbo asükai mɨŋgɨyu hürühendürɨ haya hoafɨyundürühɨ yahuya, “Muŋguambo nindou se wandɨ hoafɨ nda hɨmborɨndei hehi fɨfɨrɨndɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nɨne-moatükunɨ moanambühündɨ nindou fiambe ahano ai-ana ŋgɨrɨ nindoumbo randeranɨ moaruwai hohoanɨmondu. Ŋga nɨne-moatükunɨyo nindouyei fiambeahɨndɨ nɨmarɨ haya moanambühɨ tükefeyo ranane rareandanɨ nindou ai moaruwai hohoanɨmoayei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sisas ai nindou ranaheimbo hɨnɨŋgɨreandürɨ haya worɨna hafuane ahambo süŋgururü-rundeimbɨ ai ranɨ kafoefe hoafɨ ranahambo düdumefundɨ. ");
INSERT INTO agg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ranɨyo Sisas ai hoafɨyupurühɨ yahuya, “Awi seana ŋgusüfokoate-wamboemo. Awi se moai fɨfɨrundɨyo, sapo nɨne-moatükunɨ moanambühündɨ nindou fiambe ahano ranɨyopoanɨ nindoumbo moaruwaimbore arandɨ. ");
INSERT INTO agg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ranana ŋgusüfoambe hohoanɨmo ranambe howohüyopoanɨ, ŋga ranana bodoambe hanɨ mburambo awaimboreandühane.” Sapo Sisas ai ramehu ra muŋguambo mamɨkarambo sesɨ ra Godɨndɨ hɨmboahü ana aboedane yahumboyu. ");
INSERT INTO agg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Asu asükaiyu Sisas ai hoafɨyuhɨ yahuya, “Nɨne-hohoanɨmo nindou ahandɨ fiambeahɨndɨ nɨmarɨhaya tükefeyo ranane nindou ranahambo Godɨndɨ hɨmboahü moaruwaimboarerɨ. ");
INSERT INTO agg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Ro hoafɨmayahɨ ranana ndanɨ-moatükunɨ nindou hohoanɨmoambe tüküfe arandɨ ndanɨmboyahɨ hoafɨmayahɨ. Muŋguambo mamɨkarambo moaruwai hohoanɨmo, hümbuhünɨ, nɨmorehɨ sɨsɨhomo asu anamɨndɨhoandɨ bɨrabɨrɨ, nindou hɨfokoefe, nɨmorehɨ anamɨndeimbɨ dɨbomboyo, hohoaŋɨ, wosɨhoaforɨ hoafɨ, bodɨmondambo ŋgɨnɨndɨ, moaruwai hoafɨ, hoafɨ hɨmborɨkoate, afɨndɨ-afɨndɨ, asu mamɨkarɨ hohoanɨmo ranɨmboyahɨ hoafɨmayahɨ. ");
INSERT INTO agg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Muŋguambo ndanɨ moatükunɨ ndanane nindou hohoanɨmo-ambeahɨndɨ tüküfeyoahü nindoumbo rareiranɨ Godɨndɨ hɨmboahü moaruwaimborerɨ arandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sisas ai ranühündambo botɨfi haya Tair ŋgoafɨkɨmɨ mahu. Nindou ai ahambo fɨfɨrɨndɨhorɨmboyei yahuhaya worambe mamaru. Ŋga ai ŋgɨrɨ dɨbo amaru ra dɨbondɨfiyu. ");
INSERT INTO agg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nɨmorehɨ mamɨ ahandɨ nɨmorehɨ nɨmorɨndɨ fi-ambe moaruwai nendɨ nɨmarɨweimbɨ ai Sisas ranühɨ amaru hoafɨ ra hɨmborɨmayo. Ranɨyo ai nɨmehünou ho Sisasɨmbo-so tüküfe ahandɨ yirɨkɨmɨ peyo mamaro. ");
INSERT INTO agg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nɨmorehɨ ranai ana ai-poanɨmbo Fonisia sɨrɨhündɨ Grik hoafeimbɨyo. Ranɨyo ai Sisasɨmbo ahandɨ nɨmorehɨ nɨmorɨndɨ fi-ambeahɨndɨ moaruwai nendɨ hefoefembohünda hütihütimarɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sisas ai nɨmoreh ranahambo kafoefe hoafɨ hoafɨyundowohü yahuya, “Sɨhɨrɨ nɨmorɨ ranaheimbo sesɨboatei ndahundürɨ mbundühumbo anɨmbo. Ŋga awi sɨhɨrɨ nɨmorɨyei-mayo sesɨ ra yaforɨmbo ndahundürümboyefɨ,” mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Asu nɨmorehɨ ranai hoafɨyowohü yahoya, “Adükarɨ, yɨnɨsɨ, ŋga yaforɨ amboanɨ sesɨfondɨ koambe nɨmboeimbo nɨmorɨyei-mayo sesɨ bɨdɨfɨrɨ-bɨdɨfɨrɨ ra sahüsihanei,” mehowamboyu. ");
INSERT INTO agg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Asu Sisas ai hoafɨyundowohü yahuya, “Se hoafɨmayafɨ ranɨmbohünda ŋgafɨ, ŋga moaruwai nendɨ ai sɨhafɨ nɨmorɨ ra hɨnɨŋgɨmareandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nɨmorehɨ ranai hɨhɨrɨfe ho worambe hɨmboyowane, ahandɨ nɨmorɨndɨ fiambeahɨndɨ moaruwai nendɨ ai kosɨfoendühɨ asu fondɨwamɨ mapo. ");
INSERT INTO agg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ranɨyo Sisas ai Tair hɨnɨŋgɨre haya hu Saidonɨhü tüküfi mbura hu Dekaporisɨhü tüküfi haya hu Gariri kurɨhoe-kɨmɨ tükümefiyu. ");
INSERT INTO agg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Sisas ai ranühɨ nɨmaruambe nindou bɨdɨfɨrɨ ai nindou mamɨ hɨmbotühɨfo asu hɨhɨndɨ hoafɨyu randeimbɨ sahorɨmɨndei mahei. Ranɨyei ai Sisasɨmbo nindou ranahandɨwamɨ warɨ mbɨnandeandɨ sei hehi hüti hoafɨmayei. ");
INSERT INTO agg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ranɨyo nindou ranahambo nindou afɨndɨ ahei mbusümo ahambo yaŋgɨrɨ serümündü mahu. Ranɨyo Sisas ai warɨbatendɨ hɨmboambe yimbufihɨ pamareanda aboedɨmayafea asu warɨ boatendɨfihɨ ŋgurɨ pare mbura nindou ranahandɨ teifühɨ pamareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sisas ai sünambe hɨmboyu hafu haŋafu afɨndɨ hüfoareandühɨ nindou ranahambo yahundoya, “Efat.” Hoafɨ ranahandɨ nɨmɨndɨ ra ndahuraiane, ‘sübüdühoefɨ’ yahoane. ");
INSERT INTO agg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ranɨyo nɨmehünou ahandɨ hɨmboambe ai aboedɨyowohü asu hoafɨ hɨhɨndɨ hoafɨyumarandɨ ra asükai aboedɨ hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Asu Sisas ai nindou ranaheimbo ranɨ-moatükunɨ hoeimarɨhindɨ ranahambo nindou ŋgorümbo yowanɨ hoafɨyopoanɨ mehu. Ai aheimbo yowanɨ mehundürɨyosɨ, ŋga asu ai ranahambo wataporɨmbomarühü hei. ");
INSERT INTO agg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ai hepünehindühɨ seiya, “Sisas ai muŋgu-moatükunɨ aboedɨ ramareandɨ. Ai rareandanɨ hɨmbo tühɨfo güreyandüreimbɨ amboanɨ ai hɨmborɨyei asu hoafɨkoateyeimbɨ ai-amboanɨ wataporɨyei marɨhündɨ,” masei. ");
INSERT INTO agg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Asu ŋgorüsɨmboanɨ nindou afɨndɨ ranai Sisasɨmbo sowahɨ mafandɨhindɨ ranɨyei sesɨkoatemayei. Ranɨyo asu Sisas ai ahandɨ süŋgururü-rundeimbɨmbo mborai yahupurɨ haya hoafɨyupurühɨ yahuya, ");
INSERT INTO agg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ro nindou ndanaheimbo hɨpoamboarɨhearü. Ai ro-babɨdɨ ŋgɨmɨ si nɨmareimbo wambo asu ai sesɨkoateanei. ");
INSERT INTO agg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ro ŋgɨrɨ wembopo ŋgoafɨnambo koandɨhehearü, ŋga ai nafɨnɨ hɨmboa wuwurɨndei hehi pɨndeimboyei. Ŋga asu bɨdɨfɨrɨ ana nafɨ aŋgunɨpoedanei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Asu Sisasɨmbo süŋgururü-rundeimbɨ ai sɨmborɨ hoafɨyomondühɨ yahomoya, “Sɨhɨrɨ ana ŋgoafɨ aŋgunanefɨ. Ŋga asu dagüdambo bret ra ndahumɨndifɨ hohumbo nindou ndanaheimbo mandahundüra?” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ranɨyu asu Sisas ai düdureapurühɨ yahuya, “Se nüŋgunümbɨ bretɨyo sowandümomboemoa?” mehuamboemo. Asu ai hoafɨyomondühɨ yahomoya, “Ro 7 bret sɨhehumboanefɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ranɨyo asu Sisas ai bret 7 ra semündü haya Godɨmbo hɨfɨfɨmarürɨ. Ranɨyo asu hɨfɨtɨre mburambo ahambo süŋgururü-rundeimbɨmbo bɨdɨfɨrɨ bɨdɨfɨrɨ ra yimbumareapurɨ. Asu ahamumbo hoafɨyupurühɨ yahuya, “Se bret ra nindou ranaheimbo yimbundundürɨ,” mehupurɨ. Ranɨyo asu ahambo süŋgururü-rundeimbɨ ai rasüŋgu-marundɨ. ");
INSERT INTO agg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Asu süŋgururü-rundeimbɨ ai kinɨ yahunümbɨ amboanɨ sowapundümo. Sisas ai kinɨ ranahambo Godɨmbo hɨhɨfɨrürɨ mburambo asu ahandɨ süŋgururü-rundeimbɨmbo hoafɨmayupurambo kinɨ ra nindou ranaheimbo yimbumarundürɨ. ");
INSERT INTO agg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Asu muŋguambo nindou ai sesɨ ra sahüsi bodomayei. Ranɨyo asu bɨdɨfɨrɨ-bɨdɨfɨrɨ sesɨmayo ra 7 wambürɨ wambürɨhɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Asu 4,000 nindouyei sesɨ ra masahüsi ranɨyo asu Sisas ai hoafɨmayundürambo bukürɨmayahindɨ. ");
INSERT INTO agg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Asu Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨ botambe farɨyafu houmbo Darmanuta hɨfɨnambo mahomo. ");
INSERT INTO agg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisi ai Sisasɨmbo sɨsɨhɨmofi hoeifimbohünda tüküyafu düdumarüwurɨ. Ranɨyo asu Sisasɨmbo düdurüwurühɨ yahomoya, “Se Godɨndɨ nɨmorayafɨ ana, se Godɨndɨmayo hepünɨfeimbɨ moatükunɨ randɨwandɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Asu Sisas ai ŋgusüfoambe moaruwairɨrɨhü raguambe yare hoafɨyuhɨ yahuya, “Nindou nda nɨmboe hepünɨfeimbɨ moatükunɨ hoeifembo düduehindɨ? Ro anɨhondümboanahɨ hoafehandürɨ, ŋgɨrɨ nafuimbo moatükunɨ yahurai hoeindɨhindɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ranɨyu asu Sisas ai Farisimbo yare hɨnɨŋgɨreapurɨ hayambo ndamefiyu. Asu botambe farɨfi haya kurɨhoe barɨhoei gogoanɨnɨ mahu. ");
INSERT INTO agg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sisasɨmbo süŋgururü-rundeimbɨ ai bret adükarɨ semɨndɨ hɨfombo mɨtanɨmarundümo. Ŋga asu mamɨ yaŋgɨrɨrurɨ botambe foarüwurɨ houmbo sowarɨndümo mahɨfomo. ");
INSERT INTO agg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Asu Sisas ai ahɨnɨ hoafɨyupurühɨ yahuya, “Se Farisi-yomondɨ asu Herotɨndɨ yis ranahambo hɨbadümbo!” mehu. ");
INSERT INTO agg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ŋga asu Sisasɨmbo süŋgururü-rundeimbɨ ai hoafɨ ranahandɨ nɨmɨndɨ ranahambo wataporɨmbomarundɨ. Ai yaru hoafɨyomondühɨ yahomoya, “Sapo ai hoafɨmayu ra bretkoateayefɨ ranahamboyu hoafɨmayu,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ranɨyu asu Sisas ai fɨfɨreandɨ nɨnɨ-moatükunɨmboemo wataporɨmbomarundɨ ranahambo. Asu Sisas ai düdureapurühɨ yahuya, “Se ra nɨmboe bretkoateayefɨ ranahambo wataporɨmboaru hoaŋgomoa? Awi seana moai hoeirundɨ asu fɨfɨrundɨ? ");
INSERT INTO agg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Awi se hɨmboarümbü-anemosɨ, ŋga moai hoeirundɨ asu se hɨmboambembü anemosɨ, ŋga moai hɨmborɨyomo. Sɨhɨrɨ horombo bretkoateyefühɨ horombo ro ramarɨhendɨ ra se fɨfɨrundai? ");
INSERT INTO agg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Horombo ro hondahüfeimbɨ bret 5,000 nindoumbo maseheandɨ ranɨ-sɨmboanɨ se nüŋgunɨmbɨ bɨdɨfɨrɨ bɨdɨfɨrɨ bret wambürɨyo wambürɨhɨmarundɨ?” Ranɨyomo asu ai hoafɨyomondühɨ yahomoya, “12 wambürɨ,” mehomondo. ");
INSERT INTO agg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Asu se fɨfɨru ro bret 7 4,000 nindoumbo maseheandɨ ra. Asu nüŋgunümbɨ bɨdɨfɨrɨ bɨdɨfɨrɨ bret wambürɨyo wambürɨhɨmarundɨ?” mehuamboyo. Asu ai hoafɨyomondühɨ yahomoya, “7 wambürɨ,” mehomondo. ");
INSERT INTO agg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Asu ai yare hoafɨyupurühɨ yahuya, “Awi se moai ra fɨfɨrundɨyo?” mehu ");
INSERT INTO agg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betsaida ŋgoafɨhü Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo hɨfomo tüküyafundane asu ahambo sowana nindou hɨmboatɨharɨ mamɨ sowarɨndümo mahɨfomo. Ranɨyei ai Sisasɨmbo fambɨheira seihehi hoafɨmayahündo. ");
INSERT INTO agg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ranɨyu Sisas ai hɨmboatɨharɨmbo warɨhü kifi hürümündɨ haya ŋgoafɨ hɨnɨŋgɨrɨne hena hafanɨ ahandɨ hɨmboarambe ŋgurɨ pamarirɨ. Ai kɨkɨhɨrümündühɨ düdufinduhɨ yahuya, “Se ŋgorü-moatükunɨ amboanɨ hoeirɨwandai wanɨyo?” mehundo. ");
INSERT INTO agg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Asu nindou ranai hɨmboapoyu wakɨrendühɨ yare hoafɨyuhɨ yahuya, “Ro nindou bɨdɨfɨrɨ hoeirɨheambo-anahɨ. Ŋga asu ro hoeirɨheandanɨ nɨmɨ fɨrɨbadɨhoai aho nahuraiane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ŋga Sisas ai asükaiyu ahandɨ hɨmboarühɨ warɨ pamareandɨ. Asu ahandɨ hɨmboarɨ ra bɨrɨmarɨhoayo. Ranɨyu asu hɨmboarɨ ahandɨ ra aboedɨyowohüyo asu muŋguambo moatükunɨ ra aboedɨ hoeimareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Asu Sisas ai worɨnambo koarɨherühɨ yahuya, “Se yowanɨ ŋgoafɨna ŋgamboyafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ŋga asu Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨ ŋgoafɨ Sisaria Firipai ŋgoafɨkɨmɨ adaburo ranühɨ mahomo. Ranɨyomo asu nafɨnambo homondühɨ ahambo süŋgururü-rundeimbɨmbo düdureapurühɨ yahuya, “Wambo dɨdai-ani mbaseia?” ");
INSERT INTO agg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Asu ai hoafɨyomondowohü yahomondoya, “Bɨdɨfɨrɨ ai hoafɨyeihɨya, ‘Aiana Son hundürürandürɨ-randeimb-ani.’ Asu bɨdɨfɨrɨ ai hoafɨyeihɨ ‘Aiana Eraisa-ani.’ Ŋga asu bɨdɨfɨrɨ ai hoafɨyeihɨ, ‘Aiana Godɨndɨ hoafɨ hoafɨyurandeimb-ani,’ masei,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Asu Sisas ai düdufipurühɨ yahuya, “Asu se wambo nüŋguru hohoanɨmoyomo ro dɨdɨyaha?” Ŋga asu Pita ai sɨmborɨ hoafɨyundühɨ yahundoya, “Seana Krais-anafɨ, nindou God ai dɨbonɨyunɨnɨ hɨnɨŋgɨmareanɨnɨ nindou aboedambo-fendürɨmbohünda,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Asu Sisas ai hoafɨyupurühɨ yahuya, “Se yowanɨ nindou ŋgorümbo hoafɨndɨmboemo ro nindou nüŋgunahuraiyahɨ ranahambo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Asu Sisas ai ahambo süŋgururü-rundeimbɨmbo yamundeapurühɨ yahuya, “Nindou Hondü aiana asübusɨ afɨndɨ ndemündümbui. Asu ahambo ana bogorɨ nindoumemo, Godɨmbo sɨhou-rundeimbɨ bogorɨmemo, ahɨnümbɨ fɨfɨrundeimbɨmemo ai ahambo yɨboarukondüwurühɨ hɨfokoandüwurɨmboemosɨ, ŋga ŋgɨmɨ sindu haya asükai botɨndɨfimbui.” ");
INSERT INTO agg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Asu Sisas ai hoafɨ ra fɨfɨrɨfoare hoafɨmayupurɨ. Ranɨyu asu Pita ai Sisasɨmbo serümündü hɨmboranɨ hu ŋgɨnɨndühɨre hoafɨmarürɨ. ");
INSERT INTO agg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Asu ranɨyu Sisas ai hɨhɨrɨfi ahambo süŋgururü-rundeimbɨmbo hoeireapurühɨ asu Pitambo ŋgɨnɨndühɨre hoafɨyundowohü yahuya, “Satan, andai se biyafo. Ŋga seana Godɨndɨ hohoanɨmo-yopoanɨ süŋguarowandɨ, ŋga nindouyafe hohoanɨmo anandɨ süŋguarowandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Asu Sisas ai nɨmorehɨ nindowenihɨ aheimbo ahandɨ süŋgururü-rundeimbɨ babɨdɨmbo mborai yahundürɨ haya hümarɨhendürɨ. Ai hoafɨyundürühɨ yahuya, “Nindou düdi ai wambo süŋgufendɨrɨmbo hohoanɨmoayu ana, ai nindou mamɨ ahandɨ nɨmɨ keimbɨ karɨhendeimbɨ semɨndɨ ho yahurai ahandɨ yifirɨ ra hɨnɨŋgɨnde haya asu wambo süŋgumbɨrandɨramboane. ");
INSERT INTO agg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nindou düdi ai ahandɨhoarɨ ahandɨ yaŋgɨrɨ ra kɨkɨharamündu ana, ahandɨ yaŋgɨrɨ ra awarɨndɨhoemboe. Asu nindou düdi ai aboedɨ hoafɨ asu wambohünda ahandɨ yaŋgɨrɨ ra hɨnɨŋgareandɨ ana, ai yaŋgɨrɨ gedühɨ nüŋgumbui. ");
INSERT INTO agg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Asu nindou düdi ai muŋgua hɨfɨ ndanɨhünda moatükunɨ ra asemündu ana, asu ahandɨ yaŋgɨrɨ nɨŋgombo ra awarɨndɨhoembui asu muŋguambo moatükunɨ ranai ŋgɨrɨ fandɨherɨ. ");
INSERT INTO agg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ŋga asu nindou ranai nɨnɨ takɨnɨ madagado yaŋgɨrɨ ra sɨmborɨ sɨsefembo-hündamboa? ");
INSERT INTO agg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Asu nɨmorehɨ nindowenihɨ hapondanambe burayei ai Godɨmbo hɨnɨŋgɨrɨhorühɨ wosɨhoaforɨ hohoanɨmoyei arɨhündɨ. Ŋga nindou düdɨyei ai wambo asu wandɨ hoafɨ ranahambo amoanɨŋg-arɨhündɨrɨ ana, asu ro wandɨ Apendɨmayo hɨmboamupui-randeimbɨ asu sürühoeimbɨ sünambeahɨndɨ nendɨ babɨdɨ kosefɨ sɨmboanɨ ro aheimbo amboanɨ amoanɨŋgɨ-ndɨhandürɨmboyahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Asu Sisas ai hoafɨyundürühɨ yahuya, “Ro sɨheimbo anɨhondümbo-anahɨ hoafehandürɨ, nindou haponda burayei ndanai yɨfɨkoateyei-ambe anɨmbo God ŋgɨnɨndɨ hɨfandarandɨ ra ŋgɨnɨndeimbɨ kodowanɨ hoeindɨhimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Asu 6 si hoane Sisas ai Pita, Sems asu Son sepurɨmündü haya hɨfɨ wafu nɨmoamo ranɨwamɨ mahafomo. Ranühɨ ai-yaŋgɨrɨ nɨŋgomombo Sisasɨmbo hoeirüwurane ahandɨ fi ranai ranɨpoanɨmbo tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ranɨyo asu Sisasɨndɨ hoearɨ ranai kɨfohɨ hamɨndɨmayo. Ŋga hɨfɨ ndanɨhündambo nindou ai ŋgɨrɨ randeandanɨ kɨfohɨ yahurai tükündefeyo. ");
INSERT INTO agg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ranɨyo Eraisa asu Moses ai ranühɨ ahamumbo-so tüküyafɨne Sisas babɨdɨ wataporɨyomondühɨ manɨŋgomo. ");
INSERT INTO agg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita ai ranɨ moatükunɨ ra hoeire haya hoafɨyuhɨ yahuya, “Yamundo-randeimbɨ, ndanühɨ anɨmboefɨ ranamboanɨ aboedanesɨ. Ŋga dago ŋgɨmɨ hüründɨhumboane, sɨhambo mamɨ, Mosesɨmbo mamɨ asu Eraisambo mamɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Asu Pita ai moai nɨnɨ-hoafɨ hoafɨmbo hohoanɨmoyu, sapo ŋgorü yimbu babɨdɨmbo ai yɨhɨmboyomondühɨ-wambo. ");
INSERT INTO agg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ranɨyo asu mburɨŋgai ai kosɨ muŋguambo gabudɨmafoareapurɨ. Asu mburɨŋgai-ambeahɨndɨ hoafɨ mamɨ ranai hoafɨyohü yahoya, “Nɨmorɨ nda wandɨ nɨmor-ani ro ŋgusüfo pararɨhinɨ, ŋga se ahandɨ hoafɨ hɨmborɨndomo,” meho. ");
INSERT INTO agg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ŋga Pita, Sems, Son ai hɨmboapomemoyosɨ, ŋga asu Sisas yaŋgɨrɨ ai-babɨdɨmbo ranühɨ manüŋgu. ");
INSERT INTO agg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Asükai hɨfɨ wafuwanɨpoedɨ hɨhɨrɨyafu hanɨmondühɨ Sisas ai ahambo süŋgururü-rundeimbɨmbo hoafɨyupurühɨ yahuya, “Se yowanɨ nɨnɨ-hoafɨ hoafɨndɨmboemo nɨne-moatükunɨ hoeimarundɨ ranahambo. Ŋga hɨbadu ŋgomombo Nindou Hondü ai yɨfɨhündɨ botɨndɨfiyuanɨ anɨmbo nɨmorehɨ nindowenihɨ ranaheimbo hoafɨndɨmo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Asu Sisas hoafɨmayu ra hohoanɨmoyomo kɨkɨhɨrundühɨyomo ahamundɨhoarɨ sɨmborɨ ndüwurɨyafundühɨ yahomoya, “Sisas hoafɨmayu yɨfɨhündɨ botɨfe ra nɨnea?” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Asu Sisasɨmbo düdurɨwurühɨ yahomoya, “Nɨmboe ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ ai hoafɨyomondühɨya, ‘Eraisa boatei anɨmbo tükündɨfimbui,’ mehomo?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Aiana anɨhondümbo anahomo raru hoafeyomo, Eraisa boatei anɨmbo tükündüfi muŋguambo moatükunɨ ra dɨboadondeambui. Ra anɨhondanesɨ, ŋga Godɨndɨ bukambe hoafɨ apenɨŋgo ranai yare hoafɨyowohü yahoya, ‘Nindou Hondü ai asübusɨ afɨndɨ ndemünduanɨ nindou afɨndɨ ai ahambo moanɨpo-ani mbɨseimboyei?’ meho. ");
INSERT INTO agg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ro sɨheimbo hoafehandürɨ, Eraisa ana tüküfimboani. Godɨndɨ bukambe hoafɨ yare meŋgoro süŋgu nindou aiana moaruwai hohoanɨmo randɨhimboyei nɨne-moatükunɨ ai refembo hohoanɨmomayei süŋgu,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sisas ai, Pita, Sems asu Son babɨdɨmbo süŋgururü-rundeimbɨ bɨdɨfɨrɨ sowanambo mahomo. Ai homo hoeirundane ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ ranai Sisasɨmbo süŋgururü-rundeimbɨ bɨdɨfɨrɨ babɨdɨmbo hoafɨnambo sɨmborɨ sɨmborɨ-memondamboyo nindou afɨndɨ ranai ahamumbo wakɨre meŋgoro. ");
INSERT INTO agg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ranɨyei asu nindou afɨndɨ ranai Sisas hoeirɨhorɨ hehimbo hepünehindühɨ ahambo hɨhɨfɨmbo pɨpɨmayei hei. ");
INSERT INTO agg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sisas ai düdufipurühɨ yahuya, “Se nɨnɨmboemo ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ babɨdɨmbo hoafɨnambo sɨmborɨ hoafɨmemoa?” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ahei mbusümo nindou mamɨ ai hoafɨyuhɨ yahuya, “Yamundo-randeimbɨ, ro wandɨ nindowenihɨ nɨmorɨ moaruwai nendɨ ai ahandɨ fiambe nɨmarɨmbo hoafɨkoateyu-marandambo sɨhambo sowanambo sahümɨndɨ asɨhühɨ. ");
INSERT INTO agg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Asu moaruwai nendɨ ranai farɨfendowohü wakɨfoareranɨ hɨfɨnɨ piyu yaŋgurɨmbo yahamonafɨ ŋgasɨho wutɨpuiarɨyuhü yahafɨ hɨheporɨyu arandɨ. Asu ro sɨhafɨ süŋguru rundeimbɨmbo moaruwai nendɨ ranahambo raguanambofembo düdumeheapurɨ, ŋga ai ŋgɨrɨndɨmo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Asu Sisas ai nindou ranaheimbo hoafɨyundürühɨ yahuya, “Se ana moai anɨhondümborɨhindɨ. Ro nüŋgunɨmbɨmboyo sebabɨdɨ manɨmboaha? Asu ro nüŋgunɨmbɨmbo sɨhei tɨŋɨrɨfo ra mandahamɨndɨha? Nɨmorɨ ra ndühɨ sahorɨmɨndei sühüsi,” mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Asu ahambo süŋgururü-rundeimbɨ ai nɨmorɨ ra sowaründümo Sisas sowana mahɨfomondamboyu moaruwai nendɨ ranai Sisas hoeirirühɨ nɨmorɨ ranahambo wakɨmafoarera hɨfɨnɨ piyu hɨhɨre amoahɨrerandühɨ yaŋgurɨmbo yahomonafɨ ŋgasɨho wutɨpuiarɨmayu. ");
INSERT INTO agg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sisas ai afɨndambo düdurirühɨ yahundoya, “Nɨmorɨ nda nüŋgunɨmbɨmboyu ndahurai ramefiyuwa?” Asu afɨndɨ ai yahuya, “Akɨdouyuambe piyu hayamboani raraoyu arandɨ. ");
INSERT INTO agg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Muŋguambo si moaruwai nendɨ ranai nɨmorɨ ranahambo haiambe asu hɨmonɨ wakɨfoarerɨ arandɨ. Se nɨnɨ-moatükunɨ refemboayafɨ ana, se hɨpoambondɨwamunühɨ fandɨhawamunɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Asu Sisas ai afɨndambo hoafɨyundühɨ yahuya, “Se nɨmboe hoafɨyafühɨya, refemboayafɨ ana, fandɨhawamunɨ masafa? Anɨhondümbo-reandeimbɨ nindoumbo ana muŋguambo moatükunɨ ra tɨŋümbüyopoanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Asu nɨmehünou afɨndɨ ai hɨhɨfɨ-hɨhɨfɨyuhü hoafɨyuhɨ yahuya, “Ro anɨhondümborɨheambo-anahɨsɨ, ŋga se koe wambo fandɨhawandɨra anɨhondümbo-ndɨheamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Asu Sisas ai hoeireandane nindou afɨndɨ ranai pɨpɨyei hei wakɨmarɨhoramboyo asu moaruwai nendɨ ranahambo hoafɨyundowohü yahuya, “Moaruwai nendɨ, se nindou ndanahambo rarɨworanɨ hɨmbotühɨfoyu asu hoafɨkoateyu arandɨ. Se nindou ndanahandɨ fiambeahɨndɨ kodɨboawandɨ, ŋga asu se asükai yowanɨ farɨfembopoanɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Asu moaruwai nendɨ ranai heiyohüyo nɨmorɨ ranahambo yabadɨranɨ hɨfɨnɨ pɨmayuwa yare sɨherɨ hayambo makosɨfoendɨ. Asu nɨmorɨ ranai yɨfɨ nahurai meŋguruwamboyei nindou afɨndɨ ranai yɨfɨyumboani masei. ");
INSERT INTO agg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ŋga asu Sisas ai nɨmorɨ ranahambo warɨhü kifi botɨrirɨ hɨnɨŋgɨmarira manüŋgu. ");
INSERT INTO agg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Asu Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨ hafomo worambe nɨmarɨmombo düduyafundühɨ yahomoya, “Nɨmboe ro moaruwai nendɨ ra raguanambofe-koatemayefa?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Godɨmbo dɨdɨbafɨfenambo anɨmbo moaruwai nendɨ ndahurai ana raguanambofe-ndürɨmboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo ranɨ ŋgoafɨ ra hɨnɨŋgɨru houmbo Gariri hɨfɨ mbusümo mahomo. Ai ramefundɨ ra nindou fɨfɨrɨndɨhimunɨmboyei yahomo houmbo dɨdɨmoamboemo ranühɨ mahomo. ");
INSERT INTO agg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sisas ai hoafɨyupurühɨ yahupurɨya, “Nindou Hondümbo ana hɨfokoefimbo-hünda nindouyei warɨhündɨhorɨmboyei. Ŋga aiana ŋgɨmɨ nɨmbɨndu hayambo asükai yɨfɨhündɨ botɨndɨfimbui,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Asu ahambo süŋgururü-rundeimbɨ ai hoafɨ ranahandɨ nɨmɨndɨ ra moai fɨfɨrundɨ, ŋga ahambo düdufimbo yɨhɨmbomarurɨ. ");
INSERT INTO agg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨ homo Kaperneam ŋgoafɨhü tüküyafu houmbo worɨnambo homo mafarɨyafundɨ. Ranɨyu asu ranühɨ nɨmarümbo hoafɨyupurühɨ yahuya, “Nɨmboe se nafɨmbo sɨmborɨ hoafɨmemo sɨnɨmoa?” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ŋga asu moai ahambo süŋgururü-rundeimbɨ ai sɨmborɨ hoafɨyomondo sapo nafɨnɨ sɨmborɨ hoafɨmemo ra nindou düdi adükarayu yahomondühɨ wambo. ");
INSERT INTO agg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sisas ai nɨmarümbo ahandɨ hoafɨ sowandümo homorundeimbɨmbo hoafɨmayupurambo mahomo. Ai hoafɨyupurühɨ yahuya, “Nindou düdi adükarɨ bogorɨ nindou tüküfemboayu ana, ai ndürɨkoatendu haya muŋguambo nindouyei moanɨ ratüpurɨyu randeimbɨ-mbɨyuwamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Sisas ai nɨmorɨ akɨdou serümündü ahamundɨ mbusümo hɨnɨŋgɨrirɨ warɨhü kɨkɨhɨrümündɨ nüŋgumbo yahuya, “Nindou düdi nɨmorɨ akɨdou ndahuraimbo wandɨ süŋguna afarɨheirü ana, ra wamboane afarɨhendɨrɨ. Ai wambo yaŋgɨrɨyopoanɨ, ŋga nindou düdi wambo koamarɨhendɨra makosahɨ ahambo kapeihani,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Son ai hoafɨyundohü yahuya, “Yamundo-randeimbɨ, ro hoeirɨhundanɨ nindou mamɨ sɨhafɨ ndürɨnambo moaruwai nendɨ hefoaremarandɨ. Ranɨyo asu ahambo yowanɨ masahundo, nɨmboe ai sɨhefɨ sɨrambeahɨndɨyupoanɨ sefahumbo,” mehu ");
INSERT INTO agg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sisas ai hoafɨyuhɨ yahuya, “Se yowanɨyahondopoanɨ. Nindou düdi ai hepünɨfeimbɨ moatükunɨ wandɨ ndürɨnambo rawareandɨ ana, ŋgɨrɨ wambo moaruwai hoafundɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nindou düdi sɨhefɨmbo moaruwaimbo-femunɨkoateayu ana, ai sɨhefɨ ŋgunindani. ");
INSERT INTO agg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ro anɨhondümbo-anahɨ hoafehapurɨ. Nindou düdi ai hoeireanɨnanɨ se Kraisɨndɨ-yafanɨ sɨhambo hoe fuiyamündɨ asaganɨnɨ nindou ranai ahandɨ takɨnɨ hondü ra süŋgunambo ndemündümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Sisas ai hoafɨyuhɨ yahuya, “Nindou nɨmorɨ akɨdou ai wambo anɨhondümboreandɨranɨ asu nindou ŋgorü ai rariranɨ moaruwai hohoanɨmo süŋguareandɨ ana, nindou ranahambo nɨmoei pefi hüputüpuimündɨ mburumbo hoe hohoe afɨndambe safoefiyuwanɨ yɨfɨmbiyuwamboane. ");
INSERT INTO agg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Sɨhafɨ watɨŋarɨ ai randeanɨnanɨ moaruwai hohoanɨmondafühɨ ana, asu kandɨhawandɨ. Ŋga warɨ ŋgorü karɨhoayowanɨ fi bɨdɨfɨrɨ yaŋgɨrɨ koadürümbo nɨŋgombo ra aboedane. Ŋga fi muŋguambo hai dɨkɨrɨfekoateyorandeimbɨ ranambe pifenɨnanɨ hanɨ ranana moaruwaiane. ");
INSERT INTO agg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Se sɨhafɨ tɨŋarɨ ai randeanɨnanɨ moaruwai hohoanɨmondafühɨ ana, kandɨhawandɨ. Ŋga tɨŋarɨ ŋgorü karɨhoayowanɨ fi bɨdɨfɨrɨ yaŋgɨrɨ koadürümbo nɨŋgombo ra aboedane. Ŋga fi muŋguambo hai dɨkɨrɨfekoateyo randeimbɨ ranambe pifinɨnanɨ hanɨ ranana moaruwaiane. ");
INSERT INTO agg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Sɨhafɨ hɨmboarɨ ai randeanɨnanɨ moaruwai hohoanɨmondafühɨ ana, hündɨhawandɨ. Ŋga hɨmboarɨ mameimbɨ yaŋgɨrɨyo hefe God ŋgɨnɨndɨ hɨfandarandɨ ranambe kefoefe ra aboedane. Ŋga hɨmboarɨ yimbuimbüyo hefe hai dɨdɨrɨfekoate koadürümbo horoweimbɨ ranambe pifenɨnanɨ hanɨ ranana moaruwaiane. ");
INSERT INTO agg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Asu hai ranambe kɨmoŋgɨmo nindoumbo asahüsihündɨrɨ ranamboanɨ ŋgɨrɨ yɨfɨsafɨndei. Asu hai ahei fi tɨkɨrarandürɨ ranamboanɨ ŋgɨrɨ dɨkɨrɨndɨfeyo. ");
INSERT INTO agg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Muŋguambo nindou ranai ahei fi aboedɨfembohünda Godɨmbo sesɨ sɨhefembo namɨ paparɨhindɨ yahurai anɨmbo hainambo tɨŋɨrɨfo ndahümündimboyei. ");
INSERT INTO agg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Namɨ ana aboedɨ moatükun-anesɨ, ŋga asu namɨ ranai ahandɨ aparɨ ra hɨnɨŋgɨreandühɨ wanayo ana, budesowanɨ aparɨkoateayo ra ahandɨ aparɨ asükai ŋgɨrɨ koadürü koadüründɨfe hɨnɨŋgɨndɨfeyo. Ŋga se namɨ aparayo nahurai aboedɨ hohoanɨmo süŋgundɨhindɨ sɨhei wandafɨ mamɨyei mbusümo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sisas ai ranɨ hɨfɨ ra hɨnɨŋgɨre haya Sudia hɨfɨna Sodan hoe ŋgorü-goesürünɨ barɨhoei mahu. Ranühɨ nindou afɨndɨ ahandɨ süŋgu tümareandamboyu asu yamundɨmareandürɨ ai yaremarandɨ süŋgu. ");
INSERT INTO agg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisi nindou bɨdɨfɨrɨ ai Sisasɨmbo-so tüküyafu houmbo asu randɨhuranɨ Sisas ai boarɨbadamündɨ ŋgorü hoafɨ hoafɨmbɨyuwambo yahomo houmbo raru hoeimarüwurɨ. Ai Sisasɨmbo düdurüwurühɨ yahomoya, “Nindou mamɨ ahandɨ nɨmorehɨ hɨnɨŋgɨfembo ehu ana, asu sɨhefɨ ahɨnümbɨ hohoanɨmo ranahambo waŋgeimandɨyo?” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Moses ai nɨne-ahɨnümbɨ hohoanɨmo masagapura?” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Farisi ai hoafɨyomondühɨ yahomoya, “Moses ai hoafɨyuhɨ yahuya, ‘Nindou ai pepa fihɨ sürü pande dagadowohü koandɨhendanɨ ndemɨndɨ haya ŋgomboe,’ mehu,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sisas ai hoafɨyupurühɨ yahuya, “Moses ai hoafɨ sɨhamumbo masɨhendɨ ra Godɨndɨ hoafɨ hɨmbosɨhɨmo-rɨhoemondeimbɨ memondamboyu hoafɨ ra masɨhendɨ. ");
INSERT INTO agg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Horombo hondü God ai muŋguambo moatükunɨ nafɨrandühɨyu nɨmorehɨ nindowenihɨ nafɨmarapɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ranɨmayo-wamboane asu nindowenihɨ ai ahandɨ hondafɨndɨ hɨnɨŋgɨndeapɨrɨ haya nɨmorehühɨndɨfimbui. ");
INSERT INTO agg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Rananɨmbo asu yimbu ai mamɨ fi tükündafɨneamboyafe. Asu nindou ra yimbuyafepoanɨ, ŋga mamanafe. ");
INSERT INTO agg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God ai nindou yimbu ra mamambemareapɨrane, ŋga nindou dɨdai ŋgɨrɨ yikürübündeapɨrɨ,” mehu ");
INSERT INTO agg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Süŋgunambo Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨ worambe nɨmarɨmomboemo nɨmorehɨ semɨndɨhünda hɨnɨŋgɨfembo hoafɨ ranahambo düdumarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sisas ai hoafɨyupurühɨ yahuya, “Nindou düdi ai ahandɨ nɨmorehɨ ra moei yahu haya hɨnɨŋgɨreandühɨ asu nɨmorehɨ ŋgorü asemündu ana, ai ahandɨ weyaŋgɨruhüdɨdɨ ranahambo moaruwaimboreandühɨ nɨmorehɨ sɨsɨhɨmoyuhani. ");
INSERT INTO agg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Asu nɨmorehɨ ai nindowenihɨ hɨnɨŋgɨrerɨ haya ŋgorü nindowenihɨ aserɨmɨndo ana, ai-amboanɨ nindowenihɨ bɨrabɨrɨyohane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nindou ai Sisas sowana nɨmoakɨdɨbou ra fufurɨhümündi tükümehindɨ ai aheimbo warɨ nandɨfendürɨmbohünda. Ŋga asu süŋgururü-rundeimbɨ ranai nindou ranaheimbo ŋgɨnɨndɨmarundürɨ. ");
INSERT INTO agg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Asu Sisas ai ra hoeireanda mayoa, ahamumbo ŋgusüfoambe nɨmbɨmayupurɨ. Asu ai hoafɨyuhɨ yahuya, “Nɨmoakɨdɨbou ra ndühɨ aheimbo hɨnɨŋgɨrundüra wambo sowana mbɨsɨhüsi. Ŋga ŋgɨrɨ bobohɨndundürɨ. Ŋga God ŋgɨnɨndɨ hɨfandarandɨ ra nɨmoakɨdɨbou ndahuraiyeiane. ");
INSERT INTO agg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ro anɨhondümbo-anahɨ hoafehandürɨ. Nindou düdi God ŋgɨnɨndɨ hɨfandarandɨ ra nɨmorɨ nahurai tüküfekoateayu ana, ai ŋgɨrɨ ranambe kebuai ŋgu,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Asu Sisas ai nɨmoakɨdoumbo warɨhü kɨkɨhɨramündündürɨ mbura aheimbo warɨ nandearühɨ God ai aboedɨ aboedɨmbɨreandüramboane mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sisas ai botɨfi hayambo hüfuane asu nindou mamɨ ranai pɨpɨyu hu ahandɨ haŋgɨfoanɨ yimɨndohonambo mamaru. Ranɨyu asu ai düdufihɨ yahuya, “Yamundo-randeimbɨ Aboedɨ, ro nɨnüŋgundɨheandühɨ yaŋgɨrɨ koadürü koadürümbo manɨmboahɨ?” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Asu Sisas ai sɨmborɨ hoafɨyundühɨ yahundoya, “Nɨmboe se wambo aboedɨ asafɨndɨra? Moai nindou dɨdɨ ai aboedɨyu, ŋga God mamɨ ai yaŋgɨrɨ ani aboedayu. ");
INSERT INTO agg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Se ahɨnümbɨ hohoanɨmo nda fɨfɨrowandɨ: Se nindou hɨfokoefepoanɨ, se nɨmorehɨ sɨsɨhɨmopoanɨ, se hümbuhünɨpoanɨ, se nindou ŋgorümbo tɨkefe hefe papɨhoafɨpoanɨ, se nindouyei kakɨ napo semɨndɨmbo tɨkai hoafɨpoanɨ. Asu se sɨhafɨ meapembo ndondondowapɨrɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Asu nindoumayu ranai hoafɨyuhɨ yahuya, “Ro akɨdouyahambe sɨnɨ haponda muŋguambo ranɨ ahɨnümbɨ hohoanɨmo ra hɨmborɨya süŋgurɨheambo-anahɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sisas ai nindou ranahambo hübudurirühɨ hɨpoamborirühɨ hoafɨyuhɨ yahuya, “Awi se mamɨ-moatükunɨ mbonɨmborandɨfɨmbo-anafɨ. Se ŋgafɨ muŋgu-moatükunɨ asɨhoefɨ ra kakɨfihɨmbo koandɨhoefühɨ ranɨfihɨndɨ kakɨ ndowandɨfɨ. Asu kakɨ ra napokoatemayei aheimbo dabadürɨ. Rananɨmbo sɨhambo takɨnɨ sünambe yagodonɨnɨmboe. Asu rananɨmbo se wambo süŋgundowandɨrɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nindou ranai hoafɨ ra hɨmborɨyu hayambo afɨndɨ hohoanɨmo kapeihɨ ndamefiyu ai napo afɨndeimbɨ-wambo. ");
INSERT INTO agg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ranɨyu asu Sisas ai ahambo süŋgururü-rundeimbɨmbo hübudureapurɨ haya hoafɨyupurühɨ yahuya, “Nindou napo afɨndeimbɨmbo ana tɨŋɨyomboane God ŋgɨnɨndɨ hɨfandarandɨ ranambe kefoefembo ana,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Asu ahambo süŋgururü-rundeimbɨ ai hoafɨ ranahambo mahepünafundɨ. Ranɨyo asükai hoafɨyupurühɨ yahuya, “Wandɨ nɨmoakɨdɨbou, God ŋgɨnɨndɨ hɨfandarandɨ ranambe kefoefembo ana tɨŋümbɨ safane. ");
INSERT INTO agg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tɨŋümbɨ safane napo afɨndeimbɨ ai God ŋgɨnɨndɨ hɨfandarandɨ ranambe kefoefembo! Ŋga Kemor ai hoearɨ kakɨmbo nir ambe ranambe karefoendɨ ana, tɨŋümbɨyopoanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Asu ranɨyomo ahambo süŋgururü-rundeimbɨ ai afɨndɨ hamɨndɨ hepünafundühɨ ahamundɨhoarɨ sɨmborɨ ndüwurɨmefundɨ. ‘Rawefeyo ana, asu dɨdai yaŋgɨrɨ aboedambomandɨfia?’ ");
INSERT INTO agg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ai ahamumbo hübudureapurühɨ yahupurɨya, “Ndanɨ moatükunɨ ana ŋgɨrɨ nindou aheihoarɨ randɨhindɨ. Ŋga God anɨmbo randeambui. God ai-anɨmbo muŋguambo moatükunɨ randeambui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Asu Pita ai Sisasɨmbo hoafɨyundühɨ yahuya, “Ro muŋguambo moatükunɨ hɨnɨŋgɨrɨhu hohu sɨhambo süŋguarɨhunɨnɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ai hoafɨyupurühɨ yahuya, “Ro sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ. Muŋguambo nindou dɨdɨyei ai ahei ŋgoafɨ, apodohomamɨ, rehɨmamɨ, hondafɨndɨ, nɨmorɨ asu nümbürɨ wambo süŋgufembo hündambo hɨnɨŋgarɨhindɨ ana, ai 100 ranɨwamɨ nandɨhi ndahümündeimboyei. Asu ai hɨfɨ ndanühɨ nɨboadeiambe ndahümündeimboyei. God ai muŋgu moatükunɨ dagadürümbui horombo ai masɨhehindɨ ra ŋgasündɨhi hehimbo ndahümündeimboyei. Ai worɨ, apodohomamɨ, rehɨmamɨ, nɨmorehɨ, boagɨrɨ nɨmorakɨdɨbou asu nümbürɨ ndahümündeimboyei. Asu aheimbo moaruwaimbo-ndɨhindürɨmboyei, ŋga ai yaŋgɨrɨ koadürümbo ndahümündeimboyei. ");
INSERT INTO agg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nindou afɨndɨ dɨdɨyei ai haponda horomboehindɨ aiana süŋgunɨndeimboyei, ŋga haponda süŋgunayei ai-anɨmbo horombondahimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sisas ai Serusaremɨnambo ahandɨ süŋgururü-rundeimbɨ babɨdɨ mahafomo. Ŋga asu Sisas ai horombofi mahafua ranɨyomo asu ahambo süŋgururü-rundeimbɨ ai afɨndɨ hohoanɨmo-memondamboyo asu nɨmorehɨ nindowenihɨ ahamundɨ süŋgu mahahüsi ranai afɨndɨ hohoanɨmomayei. Asükaiyu Sisas ai ahambo süŋgururü-rundeimbɨ sepurɨmündü haya huhɨ nɨnɨ-moatükunɨ ahambo tüküfemboayo ranahambo wataporɨmbomarapurɨ. ");
INSERT INTO agg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Sisas ai hoafɨyuhɨ yahuya, “Hɨmborɨyomo, sɨhɨrɨ ana Serusaremɨnamboanefɨ ahahifɨ, ŋga ranüh-anɨmbo Nindou Hondü ranahambo ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ asu Godɨmbo sɨhou-rundeimbɨyomondɨ warɨhündüfimbui. Rananɨmbo asu ranɨ nindou ranai Nindou Hondü ranahambo yɨfɨmbiyuwamboane mbɨsɨmboemo. Asu ranahambo Suda-yafe ndɨfoyei warɨhündɨhorɨmboyei. ");
INSERT INTO agg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nindou ranai ahambo tɨkɨfɨndahündo asu gurɨ tɨfɨndahindo ndühümboyei. Asu ahambo harɨndɨmondomboemo ndɨfurɨmbɨ moatükunɨnambo hɨfokoandüwurümboemo. Ŋga asu ŋgɨmɨ sindu hayambo-anɨmbo asu yɨfɨhündɨ asükai botɨndɨfimbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sems asu Son Sebedindɨ nɨmorɨ yimbu ai Sisasɨmbo-so tükümefɨneandɨ. Ranɨyafanɨ hoafɨyafandühɨ safanɨya, “Yamundo-randeimbɨ, ro sɨhambo yɨhoehɨmbo mamɨ-moatükunɨ randowandɨ sehoahoa düduarɨhoanɨnɨ,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sisas ai düdureapɨrühɨ yahuya, “Se wambo nɨnɨ-moatükunɨmboyafanɨ refepɨrɨmbo yifirayafana?” ");
INSERT INTO agg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ai hoafɨyafandühɨ safanɨya, “Se sɨhafɨ hɨmboamupuimbo-randeimbɨ fondɨ ranɨwamɨ nɨmarɨfɨ hɨfandarandɨ ana, ro yifirayehɨ se ndowandɨfɨmunɨ se amarɨfɨ fondɨ ranambe nɨmandefomboane. Ŋga asu rananɨmbo ŋgorü ai warɨhondünɨndu asu ŋgorü ai kadüdanɨyu mbɨrandamboane,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Sisas ai hoafɨyupɨrühɨ yahuya, “Se ana moai fɨfɨrɨneandɨ nɨne-moatükunɨ se düduefɨneandɨ ranahambo. Se asübusɨ ro semɨndɨmboayahɨ ra mandowandɨfanɨyo? Asu se ro hundürayahɨ yahurai ra hundürümandafanɨyo?” mehu ");
INSERT INTO agg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Ranana randɨhoamboyehɨ,” safanɨ hoafɨmefanɨ. Asu Sisas ai hoafɨyupɨrühɨ yahuya, “Se tɨŋɨrɨfo ra ndowandümboemo ro asahamɨndɨhɨ nou. Asu ro hundürayahɨ yahurai se-amboanɨ hundüründɨmboemo. ");
INSERT INTO agg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Awi, ro sɨhafanɨmbo ŋgɨrɨ yɨnɨ mbɨsahapɨrɨ wandɨ warɨhondanɨ asu kadüdanɨ nɨmarɨmbo ra. Ŋga bɨdɨfɨrɨ nindou anɨmbo ranɨ fondɨ ranɨwamɨ ana nɨmandeimboyei. Ranɨ fondɨ ranana aheimboyo ndɨndofe hɨnɨŋgɨmefeyo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Asu süŋguru-ndeimbɨ 10 ranai ra hɨmborɨyomo mburumbo asu Son, Sems ahafanɨmbo ŋgɨnɨndɨmarupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sisas ai ahambo süŋgururü-rundeimbɨmbo muŋguambo mborai yahupurɨ hürɨhepurɨ hayambo hoafɨyupurühɨ yahupurɨya, “Suda-yafe ndɨfo nindou mamɨ ranahambo dükarɨhorühɨya hɨfandɨrandeimbɨ asei. Se fɨfɨrɨhindɨ hɨfandɨrundeimbɨ ai ahamundɨ ŋgɨnɨndɨ ra muŋguambo nindoumbo nafuimbohünda. Asu ahei adükarɨ hamɨndɨ horomboyafu homondeimbɨ, ai ahamundɨ ŋgɨnɨndɨnambo muŋguambo nindoumbo hɨfandarundürɨ. ");
INSERT INTO agg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ŋga se ranɨ süŋgundumboemo. Ŋga nindou dɨdai adükarɨ tüküfembo ehu ana, ai moanɨ farɨhairandeimbɨ nahurai mbɨnüŋguwamboane. ");
INSERT INTO agg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nindou düdi ai adükarɨ hamɨndɨ tüküfembo hohoanɨmoayu ana, ai muŋguambo nindouyei moanɨ ratüpurɨyu randeimbɨ tükümbɨfiyuwamboane. ");
INSERT INTO agg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mamɨ yahuraiane, Nindou Hondü ai hɨfɨnambo makusu ra nindou ai ahambo farɨhefimboyopoanɨ. Ŋga ai ahandɨ yaŋgɨrɨ nɨŋgo hohoanɨmo ra nindou ranaheimbohünda hɨnɨŋgɨfehü aboedambofendürɨmboyu makusu,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo Seriko ŋgoafɨhü tükümefundɨ. Ai tüküyafu mburu nindou afɨndɨ safɨ ranɨbabɨdɨmbo heiane, Bartimeus Timeusɨndɨ nɨmorɨ hɨmboatɨharɨ kakɨ napombo moako moakoyu randeimbɨ ranai nafɨkɨmɨ mamaru. ");
INSERT INTO agg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ai Sisas Nasaretɨhündɨ akɨmɨ asünu hoafɨ ra hɨmborɨyu haya puküna hoafɨ karɨhoehü yahuya, “Sisas, Defitɨndɨ ahuirɨ, se wambo hɨpoamborowandɨrɨ,” mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Asu Nindou afɨndɨ mahei ranai nindou hɨmboatɨharɨ ranahambo afoai hoafɨ kɨkɨrandɨfɨ masahündo. Ŋga nindou ranai asükai puküna hoafɨ karɨhoehü yahuya, “Sisas, Defitɨndɨ ahuirɨ, se wambo hɨpoamborowandɨrɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sisas ai nüŋgumbo hoafɨyuhɨ yahuya, “Nindou ranahambo hoafɨyahündoanɨ ndühɨ mbüsünu,” mehuamboyu. Asu nindou afɨndɨ ranai hɨmboatɨharɨ ranahambo mborai masahündo. Ai hoafɨyahündowohü seiya, “Hɨhɨfɨ-hɨhɨfɨ kapeihü botɨyafo! Ŋga Sisas ai sɨhambo mborai mehu,” masahündo. ");
INSERT INTO agg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ranɨyo nindou hɨmboatɨharɨ ranai horɨpɨrohoei piyu haya ahandɨ ŋgɨsɨharɨ hoearɨ yare sɨhai haya Sisasɨmbo sowana mahu. ");
INSERT INTO agg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sisas ai düdurirühɨ yahuya, “Ro sɨhambo nɨnɨ-nünüŋgufenɨnɨmboyo se hohoanɨmoayafa?” mehundoamboyu. Asu hɨmboatɨharɨ ranai sɨmborɨ hoafɨyuhɨ yahuya, “Nindou Yamundo-randeimbɨ, ro asükai hɨmboarɨnda samboanahɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sisas ai hoafɨyundowohü yahuya, “Se anɨhondümboarowandɨ ranɨ süŋgumbo aboedɨyafɨmboanafɨ, ŋga hafɨ,” mehundoamboyu. Asu mamɨharɨ asükaiyu hoeireandühɨ Sisasɨmbo nafɨsüŋgu süŋgumarürɨ hu. ");
INSERT INTO agg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo Serusarem ŋgoafɨkɨmɨ akɨmɨ tɨfɨrundühɨyomo Orif hɨfɨ wafuhɨ Betefage asu Betani ŋgoafɨhü tükümefundɨ. Ai ahambo süŋgururü-rundeimbɨ yimbu koarɨhepɨrühɨ yahuya, ");
INSERT INTO agg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ŋgoafɨ gogu anaŋgo ranɨnambo ŋgafanɨ. Se ŋgoafambe tükündafɨneandühɨ doŋgi hoarɨfɨ nindou ai horombo semɨndɨ hokoate nɨmɨfihɨ wofɨnambo hɨmondɨndümo hɨnɨŋgɨndundanɨ nɨŋgowa nɨmehünou hoeindɨneamboyafanɨ. Se wofɨ fufurɨndɨhene hena ndowandɨfanɨ dügüfanɨ. ");
INSERT INTO agg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Asu nindou mamɨ ai sɨhafanɨmbo düdundüfipɨrühɨya, ‘Nɨmboe doŋgi ra sowandɨfanɨ ahüfana?’ ehu ana, asu se hoafɨndafɨnandowohü anɨmboya, ‘Adükarɨ ai ranambo ratüpurɨndu mbunda ŋgɨrɨ amɨtata koandɨhendɨ,’ mbɨsafanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ai hafanɨ hoeirɨneandane doŋgi ranai nafɨnɨ worɨ nafɨtambe kɨmɨ hɨmondɨrundümo hɨnɨŋgɨrundanɨ manɨŋgo. ");
INSERT INTO agg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ai wofɨ fufurɨheneandane, nindou akɨmɨ manɨŋgomo ranai düdurüpɨrühɨ yahomoya, “Se nɨnɨ-nünüŋgufemboyo doŋgi ra wofɨ fufurarɨheneanda?” mehomondambo-yafanɨ. ");
INSERT INTO agg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Asu Sisas ai hoafɨmayupɨrɨ süŋgu sɨmborɨ hoafɨmefɨnapurɨ. Ranɨyo nindou-memo ranai doŋgi ra semɨndɨ hombo ahafanɨmbo yɨnɨ mehomopɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ai doŋgi ra sowandɨfanɨ hüfanɨ Sisasɨmbo-so tüküyafɨne ahafandɨ hoandarɨ hoearɨ ra doŋgiwamɨ manandɨneanda ranɨwamɨ Sisas ai mamaru. ");
INSERT INTO agg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ranɨyei nindou afɨndɨ ranai ahei ŋgɨsɨharɨ hoearɨ yimündɨbadɨhümündi nafɨnɨ korɨhi hei asu bɨdɨdɨfɨrɨ ai mbeyemü nahurai hutühümündi korɨmarɨhi hei. ");
INSERT INTO agg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nindou afɨndɨ ranai puküna hoafɨ karɨhehindühɨ seiya, “Godɨmbo hɨhɨfɨ-hɨhɨfɨmboane! God ai nindou Adükarɨndɨ ndürɨnambo asünu ranahambo aboedɨ aboedɨmbɨriramboane. ");
INSERT INTO agg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Sɨhefɨ amoao Defitɨndɨ sɨrambeahɨndɨ adükarɨ bogorɨ hapondanɨ sɨhefɨmbo hɨfandɨyomunɨmboayu ranahambo God ai aboedɨ aboedɨmbɨriramboane. God nɨmoamo hondü amaru ranahambo hɨhɨfɨ-hɨhɨfɨmboane!” masei. ");
INSERT INTO agg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sisas ai Serusaremɨhü tüküfi haya hu Godɨndɨ worambe muŋgu-moatükunɨ hübudura wakɨmareandɨ. Ŋga asu ndeara nɨmbɨfembo yaŋgɨrɨmayowamboyo ai ahambo süŋgururü-rundeimbɨ 12 ranɨbabɨdɨmbo Betani ŋgoafɨnambo hɨhɨrɨyafu mahomo. ");
INSERT INTO agg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ŋgorü sinambo Betani ŋgoafɨhündɨ sɨfomondühɨyo, Sisas ai wembombomayu. ");
INSERT INTO agg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ranɨyu fik nɨmɨndɨ ranai akɨdou aŋgunɨ safɨ emündü afɨndɨ momorɨyo haya manɨŋgowa hoeimareandɨ. Ai fik hɨsɨ kiarɨhɨpo yahu haya akɨmɨ hɨmboambo mahu, ŋga ai moai hɨsɨ mamɨ amboanɨ kiarowa hoeirirɨ. Ai emündü yaŋgɨrɨyo afɨndɨ momorɨmayo, sapo ranana fik hɨsambeyopoanɨ, ŋga ranɨmbo wamboyo. ");
INSERT INTO agg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sisas ai fik nɨmɨndɨ ranahambo hoafɨyundowohü yahuya, “Se yowanɨ asükai hɨsɨyowanɨ nindou ai fik sesɨpoanɨ,” mehuamboyo. Asu ahambo süŋgururü-rundeimbɨ ai hoafɨ hoafɨmayu ra hɨmborɨmemo. ");
INSERT INTO agg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo homo Serusarem ŋgoafɨhü tüküyafu houmbo Godɨndɨ worɨna mahu. Ai hu hɨmboyuwane nindou ai ranambe napo kakɨfihɨ sɨhou sowandümo raraomaründa bukürɨmafoareapurɨ. Ai nindou kakɨ nandu houmbo sɨseru asu nindou nɨmarɨmo ndu kakɨfihɨ sɨhou-marundɨ ahamundɨ nɨmarɨfondɨ ra hɨhɨre amoahɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Asu ai nindou ranahamumbo Godɨndɨ worɨ ranɨ papambe fufuemɨndɨ horambo yowanɨ mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ranɨyu nindou ranahamumbo yamundeapurühɨ yahuya, “Godɨndɨ bukambe yare hoafɨyowohü yahoya, ‘Wandɨ worɨ ana muŋguambo hɨfɨhündɨ nindou ai ho wambo dɨdɨbafɨfe worane,’ meho. Ŋga se hümbuhünɨ nindouyei dɨbonapɨfe fondɨ nahurai rawarɨhindɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨyomo asu ahɨnümbɨ hohoanɨmo yamundu rundeimbɨyomo ai ranühɨ hoafɨ ra hɨmborɨyomo houmbo Sisasɨmbo hɨfokoefimbo nafɨ kokomarundɨ. Ai ramefundɨ ra sapo nindou ranai Sisasɨndɨ yamundɨfe hoafɨ ranɨmbo hepünahi marɨhünda ranɨmbo yɨhɨmborurühɨ. ");
INSERT INTO agg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Asu nɨmbambeahɨ Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo Serusarem hɨnɨŋgɨru houmbo mahomo. ");
INSERT INTO agg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ŋgorü-sɨmboanɨ siambeahɨ Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo homondühɨyo hoeirundanɨ fik nɨmɨndɨ ranai nɨmbɨmayo. Ai nɨmbɨyowohü emündü asu ahasɨharɨ muŋguambo yapataparɨmayo. ");
INSERT INTO agg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sisas ai fik nɨmɨndɨ ranahambo hoafɨmayundo ra Pita ai fɨfɨre haya hoafɨyundowohü yahuya, “Nindou Yamundo-randeimbɨ hoeiro, fik nɨmɨndɨ se hoafɨmayafɨndo ranana nɨmbɨyo haya anɨŋgo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Se Godɨmbo yaŋgɨrɨ anɨhondümbondundɨ. ");
INSERT INTO agg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ro sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ. Nindou mamɨ ai yimbu hohoanɨmokoateyuhü nɨmoei wafu ndanahambo sɨrɨwara-ambe karɨhoefɨ hanɨfɨ ehu ana, ai hoafɨmayu süŋgu randɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ranɨmboane ro sɨhamumbo hoafehapurɨ, se nɨnɨ-moatükunɨ semɨndɨmbo anɨhondümborundühɨ ndahumɨndemboyefɨ yahomo houmbo dɨdɨbafefundɨ ana, ranɨ-süŋgunambo anɨmbo ndowandümboemo. ");
INSERT INTO agg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Asu se botɨndafu nɨŋgomombo dɨdɨbafɨndafundühɨ nindou ŋgorü ai sɨhambo moaruwai ramareandɨ ra hohoanɨmoayafɨ ana, amboawi mbɨsafɨndo. Rananɨmbo asu God ai sɨmborɨ sɨhafɨ hohoanɨmo moaruwai ra amboawi mbüsümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo asükai Serusarem ŋgoafɨhü tükümefundɨ. Sisas ai Godɨndɨ worambe huane Godɨmbo sesɨ sɨhou-rundeimbɨ, ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ asu bogorɨ nindou ai ahambosowana mahomo. ");
INSERT INTO agg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ai Sisasɨmbo düdururühɨ yahomoya, “Se ndanɨ ŋgɨnɨndɨ ra nahanɨhündambo sowandɨfɨmboyafa? Dɨdandɨ ŋgɨnɨndɨ nda sɨhambo masaganɨnamboyafɨ ndanɨ ratüpurɨ rawarowanda?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Roamboanɨ sɨhamumbo sɨmborɨ mamɨ düdufe düdundɨheapurɨmboyahɨ. Se wambo sɨmborɨ hoafemondɨndɨrɨ ana, asu ro ndanɨ ratüpurɨ ratüpurɨmbo ŋgɨnɨndɨ düdi masendɨrɨ ra hoafɨndahapurɨmboyahɨ. ");
INSERT INTO agg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Se wambo hoafɨyomondɨndɨrɨ, Son ai nindou hundürüra-marandɨ ŋgɨnɨndɨ ra Godɨndɨ-mayoyo, asu hɨfɨ ndanühɨndambo nindou-yomondɨ-mayoyo?” mehu. ");
INSERT INTO agg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ai ahamundɨhoarɨ sɨmborɨ hoafɨyomondühɨ yahomoya, “Sɨhɨrɨ Godɨndɨ-mayoane asefɨ ana, ai sɨhefɨmboya asu nɨmboe anɨhondümbofe-koateayomoa? mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ŋga sɨhɨrɨ hoafɨyefühɨya hɨfɨnɨndɨ nindou-yafemayoane asefɨ ana, asu muŋguambo nindou ai fɨfɨrɨhindɨ Son ai Godɨndɨ hoafɨ hoafɨyu-randeimbani,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ranɨmboyo ai hoafɨyomondühɨya, “Moai fɨfɨrɨhundɨ,” mehomondamboyu. Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Roamboanɨ düdi ŋgɨnɨndɨ masendɨrɨ ra ŋgɨrɨ hoafɨndahɨpurɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sisas ai Suda-yei boboagorɨ ranahamumbo kafoefe hoafɨ hoafɨyuhɨ yahuya, “Nindou mamɨ ai wain nümbürɨ nümbürɨra mbura ginɨrɨmayu. Wainɨ hɨsɨ ra bubutükɨmbohünda hɨfɨ ambe kɨkɨra mbura nümbürɨ ra hɨfandɨmbo dago hüra hɨnɨŋgɨmareandɨ. Nümbürɨ ra ŋgorü nindou-yomondɨ warühɨ kakɨ semɨndɨ ratüpurɨmbo hɨnɨŋgɨre haya ahandɨhoarɨ aŋgunɨ hɨfɨna mahu. ");
INSERT INTO agg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wainɨ ranai hɨsɨmayowamboyo nümbürɨ aharambürɨ ranai ahandɨ ratüpurɨyu randeimbɨ koamarɨheirü. Ai ŋguwanɨ nümbürɨ ranambeahɨndɨ sesɨ bɨdɨfɨrɨ mbɨsabudowa yahu haya. ");
INSERT INTO agg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ŋga nümbürɨ hɨfandɨmarundɨ ranai ratüpurɨyu-randeimbɨ ranahambo mburündümo houmbo bubururü mburu nɨnɨ akɨdou warambefendokoate koamarɨhawurɨ. ");
INSERT INTO agg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Asu nümbürɨ aharambürɨ-mayu ranai asükai ratüpurɨyu-randeimbɨ ŋgorü koamarɨheirü. Ranɨyo ranahambo amboanɨ mbɨro burüwurɨ mburümbo moaruwai moaruwaimbomarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Asükai ŋgorü ratüpurɨyu-randeimbɨ koamarɨheirü. Ŋga ranahambo hɨfokoamarüwurɨ. Asu asükai süŋgunambo ahandɨ ratüpurɨyomo rundeimbɨ afɨndɨ koamarɨhepurɨ. Nümbürɨ hɨfandɨrundeimbɨ ranai bɨdɨfɨrɨ buburupurɨ koamarɨhoupurɨ asu bɨdɨfɨrɨ hɨfokoamarupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nindou nümbürɨ hɨfandɨmarundɨ sowana koehefembo ra nümbürɨ aharambürü ahandɨ ŋgusüfo parireimbɨ nɨmorɨ yaŋgɨrɨyu manüŋgu. Ŋga bɨdɨfɨranambo ahamumbo sowana koamarɨheirü. Afɨndɨ ai hoafɨyuhɨya wandɨ nɨmorɨndɨ hoafɨ anɨmbo hɨmborɨndɨmboemo yahu haya koarmarɨheirü. ");
INSERT INTO agg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ŋga nümbürɨ hɨfandɨmarundɨ ranai ahamundɨhoarɨ sɨmborɨ hoafɨyomondühɨ yahomoya, ‘Ndanana nümbürɨ aharambürɨndɨ nɨmor-ani. Sɨhɨrɨ ahambo hɨfokoandɨhurühɨ anɨmbo nümbürɨ ra sɨhefɨmbeyo-wamboane,’ mehomo. ");
INSERT INTO agg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ranɨyo nɨmorɨ ranahambo kɨkɨhɨründümo mburu hɨfokoarüwurɨ houmbo ahandɨ finɨmoko ra wain nümbürɨ ginɨrɨ hundünɨ pimarüwurɨ,” mehu ");
INSERT INTO agg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Asu Sisas ai düdufihɨ yahuya, “Nümbürɨ aharambürɨ ranai nɨnɨ-nüŋgumandea? Ai düdü wain nümbürɨ hɨfandɨmarundɨ ra hɨfokoandeapurühɨ wain nümbürɨ ra ŋgorü nendambo asükai dagapurümbui. ");
INSERT INTO agg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Awi seana Baiborambe hoafɨ mapenɨŋgo ra hoeimbarundɨyopoanɨ. Ai yare hoafɨyowohü yahoya, Kambohoanɨ worɨmboru-rundeimbɨ ai moaruwaiane yahomo houmbo masɨhoemo ranane asu hapondanɨ worɨ ŋgɨnemɨndɨmbo bogɨmondɨ kambohoanɨmbofemboayo. ");
INSERT INTO agg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Adükarɨ ai ahandɨhoarɨ ramareanda tükümefeyoane, ranane ro hoeirɨhundanɨ aboedɨhamɨndayo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Suda-yei boboagorɨ nindou ranai fɨfɨrundɨ ahamumboyo ranɨ kafoefe hoafɨ ra Sisas ai wataporɨmbomarandɨ. Ranɨmboyo Sisasɨmbo ranühɨ kɨkɨhimɨndɨmbo hohoanɨmomemo. Ŋga nindou afɨndɨ ranaheimbo yɨhɨmboyomondühɨyo, raru hɨnɨŋgɨrüwurɨ houmbo mahomo. ");
INSERT INTO agg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Suda-yei boboagorɨ nindou ranai Farisi nindou bɨdɨfɨrɨyomo asu Herotɨndɨ nendɨ bɨdɨfɨrɨyomo ahamumbo Sisasɨmbo sowana koamarɨhoupurɨ. Ai tɨkefe hefemboya Sisas ai moaruwai hoafɨ hoafɨmayu yahombo yahomo houmbo mahafomo. ");
INSERT INTO agg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nindou ranai homo Sisasɨmbo hoafɨyomondühɨ yahomoya, “Nindou Yamundo-randeimbɨ, ro fɨfɨrɨhumboanefɨ, seana nindoumbo yɨhɨmbokoate anɨhondümbo-anafɨ hoafɨyafɨ arandɨ. Seana nindou ndüreimbɨyei asu ndürɨkoateyei ranaheimbo moai hohoanɨmoyafɨ, ŋga God yifirayu hohoanɨmoane nindou yamundo arandɨ. Asu se nüŋguro hohoanɨmoyafa? Romɨyafe adükarɨ bogorɨ Sisarɨmbo takis kakɨ saimbo ra ahɨnümbɨyo, wanɨyo? Asu sɨhɨrɨ takis kakɨ saimbo ra ahɨnümbɨyo, wanɨyo?” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Asu Sisas ai ahamundɨ wosɨhoafɨ hoafɨ ra fɨfɨre haya hoafɨyuhɨ yahuya, “Nɨmboe se wambo refe hoeifendɨrɨmbo ehomoa? Kakɨ hoarɨ mamɨ sowaründümo sɨnɨmo anɨmbo ro hoeindɨhea!” mehu. ");
INSERT INTO agg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nindou ranai kakɨ hoarɨ sowaründümo homo masabudowamboyu düdureapurühɨ yahuya, “Ndürɨ asu sɨsamɨ nda dadea?” mehuamboemo. Asu ai hoafɨyomondühɨ yahomoya, “Sisarɨndane,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Asu Sisas ai hoafɨyupurühɨ yahuya, “Sisarɨndɨ moatükunayo ra Sisarɨmbo ndabudo. Asu Godɨndɨ moatükunayo ra Godɨmbo ndabudo,” mehuamboemo Sisasɨndɨ hoafɨ ranahambo mahepünefundɨ. ");
INSERT INTO agg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Sadyusi ai hohoanɨmo-yomondühɨya, nindou yɨfɨyeimbɨ ai ŋgɨrɨ asükai yaŋgɨrɨ botɨndahindɨ yahomo-rundeimbɨ ai homo Sisasɨmbo düduyafundühɨ yahomoya, “Nindou yamundo-randeimbɨ, Moses ai sɨhefɨmbo ndanɨ ahɨnümbɨ hohoanɨmo nda sürü papɨmarandɨ. Nindou mamɨ ai nɨmorehɨ semündü haya nɨmorɨ-koate nindowenihɨ ai yɨfayu ana, amoŋgoandɨ kai ra akɨdɨ ai mbɨsemündu-wamboane. Rananɨmbo ahandɨ amoŋgoandɨ fondambe nindou wanɨndɨmboemo-hünda nɨmorɨ kambɨrɨneandamboane. ");
INSERT INTO agg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mamɨmbo apodoho mamɨ 7 manɨŋgomo. Amoŋgo hondü ranai nɨmorehɨ ra semündü haya nɨmorɨ mbuimɨndɨkoate yɨfɨyuhɨyu asu nɨmorehɨ ahandɨ ra ranɨkɨmɨnɨndɨ akɨdɨmayu ranahambo hɨnɨŋgɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ranɨyo nɨmorehɨ ra asükai akɨdɨ ŋgorü ai semündü haya nɨmorɨ kefekoate yɨfɨmayu. Ranɨyo asükai akɨdɨ ŋgorü ranɨkɨmɨnɨndɨ ai-amboanɨ mamɨ yahurai ramefiyu. ");
INSERT INTO agg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mamɨ yahurai apodoho mamɨ 7 ranai ramefundɨ. Ranɨyo süŋgunambo nɨmorehɨ ranai amboanɨ yɨfɨmayo. ");
INSERT INTO agg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Apodoho mamɨ ranai nɨmorehɨ ra muŋguambo masowandümo. Ŋga süŋgunambo nindou ranai yɨfɨhündɨ botɨfeambe apodoho mamɨ ranai botɨndafundühɨ asu nɨmorehɨ ra dadɨ nɨmorehɨ manda?” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sisas ai hoafɨyupurühɨ yahuya, “Se moai Baiborambe hoafɨ apenɨŋgo ra fɨfɨrundɨ asu Godɨndɨ ŋgɨnɨndɨ fɨfɨrundɨ. Ranɨmboane se mamɨkarɨ hoafayomo. ");
INSERT INTO agg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nindou yɨfɨyeimbɨ ai asükai yaŋgɨrɨ botehindɨ ana, ŋgɨrɨ anamɨndühɨ-ndahi asu nɨmorehühɨ-ndafu ndühündɨ. Aiana sünambeahɨndɨ nendɨ nahurai nɨboadeimboyei. ");
INSERT INTO agg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ŋga nindou yɨfɨyeimbɨ yɨfɨhündɨ botɨfe ra awi se Mosesɨndɨ buk nɨmɨ akɨdou hai imami tükümefeyo ra se hoeimbaruyo? Hoafɨ sürü mapenɨŋgo ranambe God ai Mosesɨmbo hoafɨyuhɨ yahuya, ‘Roana Abrahamɨndɨ God-anahɨ, Aisakɨndɨ God-anahɨ, asu Sekopɨndɨ God-anahɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","God ana yɨfɨyeimbɨyei Godɨ yupoanɨ. Ŋga yaŋgɨrɨ nɨboadeimbɨyei God-ani. Sɨhei hohoanɨmo ana hɨhɨndɨ hohoanɨmoane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ahɨnümbɨ hohoanɨmo fɨfɨreandeimbɨ ai süfuane Sadyusi ai Sisas babɨdɨmbo sɨmborɨ hoafɨmemo. Ranɨyu ai hɨmborɨyuane Sisas ai ahamundɨ düdufe hoafɨ ra sɨmborɨ aboedɨ hoafɨmayupurɨ. Ranɨyu Sisasɨmbo düdurirühɨ yahuya, “Ahɨnümbɨ hohoanɨmo nahanɨyo amurɨ ranahambo ŋgasünde haya adükarɨ hamɨndayoa?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sisas ai sɨmborɨ hoafɨyundohü yahuya, “Ŋgasündeandeimbɨ ahɨnümbɨ hohoanɨmo ana ndanane: ‘Israer se wudɨpoapondɨhi hɨmborɨndei. Adükarɨ mamɨ yaŋgɨrani sɨhefɨ Godayu. ");
INSERT INTO agg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Se sɨhefɨ God Adükarɨ ranahambo ŋgusüfoambe muŋguambo, yifiafɨ muŋguambo, hohoanɨmo muŋguambo, ŋgɨnɨndɨ muŋguambo ranambo ŋgusüfo pandɨhorɨ.’ ");
INSERT INTO agg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ranɨkɨmɨnɨndɨ ahɨnümbɨ hohoanɨmoane nda: Se sɨhafɨ wandafɨ mamɨmbo ŋgusüfo pandowandürɨ sɨhafɨ fimbo rawarowandɨ nou. Moai ŋgorü ahɨnümbɨ yimbu ndanahafembo ŋgasündeandeimbɨ yaŋgoro,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ahɨnümbɨ hohoanɨmo fɨfɨreandeimbɨmayu ranai Sisasɨmbo hoafɨyundohü yahuya, “Nindou Yamundo-randeimbɨ, se hoafayafɨ ra aboedane. Anɨhondane moai ŋgorüpoanɨmbo God nüŋgu, ŋga Adükarɨ God mamɨ yaŋgɨrani anüŋgu. ");
INSERT INTO agg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ranɨmboane Godɨmbo ŋgusüfoambe muŋguambo, fɨfɨrɨfe muŋguambo, ŋgɨnɨndɨ muŋguambo ranambo ŋgusüfo pefembo asu wandafɨ mamɨmbo ŋgusüfo pefembo sɨhefɨ fimbo rawehundɨ nou randɨhumboane. Sɨhɨrɨ yimbu hohoanɨmo ra rawarɨhundɨ ana, Godɨmbo sesɨ muŋgu mandɨfe asu nɨnɨhondɨ hɨfɨkoefe mandɨfe sɨhefe ra ŋgasündeamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sisas ai hoeireandane ndore fɨfɨreandeimbɨ hoafɨ sɨmborɨ hoafɨmayuamboyu ai hoafɨyuhɨ yahuya, “Se God ŋgɨnɨndɨ hɨfandarandɨ ra akɨmɨsafɨ anɨmbafɨ.” Sisas ai yare hoafɨmayua amurɨ ranai ahambo düdufe hoafɨ hoafɨmbo yɨhɨmbomemo. ");
INSERT INTO agg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sisas ai Godɨndɨ worambe nindou yamundearühɨ düdufihɨ yahuya, “Nɨmboe ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ ai Krais, nindou ra God ai ahandɨ nendambo aboedambofembo kamafoarirɨ, ranahambo Defitɨndɨ nɨmor-ani ehomoa? ");
INSERT INTO agg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yifiafɨ Aboedɨ ai Defitɨmbo hohoanɨmo masagadowa hoafɨyuhɨ yahuya, ‘Se wandɨ warɨhondü waranɨ nɨmandɨfɨ ŋgafɨmbo sɨhafɨ hürütümbɨ ra sɨhafɨ hoarehɨ hɨnɨŋgɨndɨheapurɨ-mboyahɨ,’ mehu ");
INSERT INTO agg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Defit ai Kraisɨmbo Adükarɨ yahundo-marandɨ, asu nüŋgunde ahandɨ nɨmorɨ mandü-a?” mehu. Nindou afɨndɨ ranai yaŋgorɨmbo Sisasɨndɨ hoafɨ hɨmborɨmbo hɨhɨfɨ-hɨhɨfɨmayei. ");
INSERT INTO agg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ai yamundeandürühɨ yahuya, “Ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨmbo hɨbadɨhümbo. Aiana warɨ hoandarümbɨ hoearɨ yihuruyo hefe maketambe howanɨ nindou ai ahɨnɨyeihɨ hɨhɨfɨ-mbɨrɨhümunɨ yahomomboanemo hohoanɨmoemo. ");
INSERT INTO agg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aiana rotumbo-hünda rotu worambe asu sesesambe ra weaŋgurühɨndɨ fondɨwamɨ wagabe nɨmarɨmboanemo hohoanɨmoemo. ");
INSERT INTO agg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aiana nɨmorehɨ kaisahoabedɨ ranaheimbo wosɨhoaforɨ hoafɨyomondürühɨ ahei worɨ kosɨründümo asu tɨkaruhoumbo hoandarɨ hamɨndɨ dɨdɨbafɨyafu arundɨ. Ranɨmbo-hündambo anɨmbo papɨ hoafɨ yɨbobofeambe ahamumbo ana tɨŋɨrɨfo ra moaruwai hamɨnd-anɨmbo ndɨmboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sisas ai Godɨndɨ worɨmbo kakɨ hɨpɨrɨ fikɨmɨ nɨmaruane nɨmorehɨ nindowenihɨ ai hɨpɨrɨ ranambe hei kakɨ mafoarɨhindɨ. Nindou kakɨ afɨndeimbɨ ranai afɨndɨsafɨ hɨpɨrɨ ranambe hei mafoarɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Asu nɨmorehɨ napokoate kai ranai hamburɨ kakɨ yimbu toea sepɨrɨmɨndɨ ho hɨpɨrɨ ranambe mafoareapɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sisas ai ahambo süŋgururü-rundeimbɨmbo mborai yahupurɨ gugureapurɨ haya hoafɨyuhɨ yahuya, “Ro sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ. Nɨmorehɨ kai napokoate kakɨ Godɨndɨ worɨ hɨpɨrambe masɨhendɨ ranana napo afɨndeimbɨ masɨhehindɨ ranhambo ŋgasündeamboane. ");
INSERT INTO agg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nindou napo afɨndeimbɨ ranai ana ahei adükarɨ mbegorɨndürɨ, ŋga akɨdou mafoarɨhindɨ. Ŋga nɨmorehɨ kai napokoate ranai ana ahandɨ sesɨ pemɨmboyoweimbɨ-mayo ranɨyo muŋgu masɨhendɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sisas ai Godɨndɨ worɨ hɨnɨŋgɨre tüküfiyuane ahandɨ süŋgururü-rundeimbɨ mamɨ ai hoafɨyuhɨ yahuya, “Nindou Yamundo-randeimbɨ, worɨ aboedɨ safɨ asu nɨmoei adükarɨ ra hoeiro,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sisas ai sɨmborɨ hoafɨyuhɨ yahuya, “Se worɨ afɨndɨ ndanahambo hoeiarowandɨ. Ŋgɨrɨ nɨmoei mamɨ amboanɨ ŋgoründɨwamɨ naŋgo, ŋga hɨfɨtɨreboai pɨndɨmboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Sisas ai Orif hɨfɨ wafuambe nɨmarü hɨmboyuane, Godɨndɨ worɨ ai aŋgunɨ goagu mafondaro. Asu Pita, Sems, Son, Andru ai yaŋgɨrɨ masɨfomo. Ai sɨfomo Sisasɨmbo düdurüwurühɨ yahomoya, “Hoafɨyafɨmunɨ ranɨ-moatükunɨ ra nüŋgusümboanɨ tükümandɨfea? Asu nɨnɨ-moatükunɨ boatei tükündɨfemboe mbɨsefɨ fɨfɨrɨmandɨhua?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Asu Sisas ai hoafɨyupurühɨ yahuya, “Se hɨbadümbo, ŋga nindou mamɨ sɨhamumbo wosɨhoaforɨ hoafɨndapurümbui. ");
INSERT INTO agg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nindou afɨndɨ ranai ŋgomo wandɨ ndürɨ dükandundühɨya, ‘Ro nindou rananahɨ nda,’ mbɨsɨmo houmbo nindou afɨndɨ wosɨhoaforɨ hoafɨndundürɨmboemo. ");
INSERT INTO agg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Asu se yifiarɨndɨmondanɨ hɨmborɨndɨmondühane, asu yifiarɨ hoafɨ yaŋgɨrɨ aŋgunɨpoedɨ hɨmborɨndɨmondühane ra se yowanɨ afɨndɨ hohoanɨmondɨmboemo. Ranɨ-moatükunɨ ra tükündɨfemboesɨ, ŋga asu ranɨ-moatükunɨ tükefeyo ranahambo awi bɨdɨfɨranambo siane yahopoanɨ. ");
INSERT INTO agg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Hɨfɨ-hɨfɨ ranai sɨmborɨ yifiarɨndomboe. Asu adükarɨ bogorɨ nindouyafe nendɨ ranai sɨmborɨ sɨmborɨndɨmboemo. Hɨfɨ bɨdɨfɨrɨ ranɨfihɨ sesɨ ai wanɨndɨmboe asu hɨfɨhe ranai tükündɨfemboe. Muŋguambo moatükunɨ ranana nɨmorehɨ ai nɨmorɨ wakemɨndɨmbo yaho haya asübusɨ boatei asemɨndo nahuraiane tükefeyo. ");
INSERT INTO agg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ranɨsɨmboanɨ anɨmbo se hɨbadümbo. Ai sɨhamumbo mbundüpundümo houmbo kansɨrɨyafe hɨmboarühɨ papɨ hoafɨndüpurɨmboemo. Asu Suda-yei rotu worambe bubundüpurɨmboemo. Wambo süŋguna ahamundɨ adükarɨ bogorɨ asu hɨfandɨrundeimbɨ ahamundɨ hɨmboahü nɨŋgomboemo. Ŋga refeambe anɨmbo Aboedɨ Hoafɨ ahamumbo wataporɨmbondüpurɨ. ");
INSERT INTO agg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ŋga bɨdɨfɨranambo si ranai tüküfekoateyoambe nindou muŋguambo ranai aboedɨ hoafɨ ra hɨmborɨndei hehimbo anɨmbo. ");
INSERT INTO agg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sɨhamumbo mbundüpundümo houmbo kotambe ndowapundümo ŋgomondanɨ se yowanɨ nɨnɨ hoafɨ hoafɨmandefɨ yahoefembo yɨhɨmboyopoanɨ. Moanɨ ranɨ-sɨmboanɨ hamɨndɨ anɨmbo se hoafɨmbo ra God ai horɨndeapurümbui. Asu ŋgɨrɨ se sɨhamundɨhoarɨ wataporɨmbondundɨ, ŋga Yifiafɨ Aboedɨ ai-anɨmbo wataporɨmbondamboe. ");
INSERT INTO agg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nindou ai ahamundɨ amoŋgo mamɨ asu akohoandambo papɨ hoafɨndüpurɨ mbundumbo hɨfokoefepurɨmbo hoafɨndɨmboemo Asu afɨndɨ ai mamɨ yahurai randeambui. Asu nɨmorɨ ai ahandɨ hondɨ afɨndambo moaruwaimbondeapɨrühɨ nindoumbo hoafɨnduanɨ hɨfkoandüpɨrɨmboemo. ");
INSERT INTO agg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wambohünda muŋguambo nindou ai sɨhamumbo moaruwaimbo-ndɨhipurɨmboyei. Ŋga asu dɨdɨyei moanane sei ŋgɨnɨndɨ anɨmboei hei ana, God ai aboedambo-ndearümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Sisas ai hoafɨyuhɨ yahuya, “Se hoeindundanɨ moaruwai hamɨndɨ moatükunɨ sürühoeimbɨ fondɨwamɨ nɨŋgomboe. Nindou düdi ndanɨ hoafɨ nda ritimarandɨ ana, ai fɨfɨrɨmbɨreandamboane. Ranɨsɨmboanɨ nindou Sudia hɨfɨhü anɨmboei ai nɨmai fefoehi hehi hɨfɨ wafuanambo mbɨhahüsiamboane. ");
INSERT INTO agg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Asu nindou ai worɨwamɨnɨndɨ akusɨfoendɨ ra ai yowanɨ ahandɨ napo fufoemɨndɨmbo worɨnambo keboembui. ");
INSERT INTO agg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Asu nindou düdi nümbürambe anüŋgu ranai yowanɨ ahandɨ warɨhoandarɨ hoearɨ semɨndɨmbo ŋgumbui. ");
INSERT INTO agg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ranɨsɨmboanɨ nɨmorehɨ warandühumbanei asu nɨmorɨ kehureimbanei aiana hɨpoanɨmboembouanei. ");
INSERT INTO agg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Se Godɨmbo dɨdɨbafɨndafundanɨ anɨmbo ranɨ-moatükunɨ ranai ŋgɨsɨharɨ afɨndɨ tüküfeyoambe tüküfekoatembeyo-wamboane. ");
INSERT INTO agg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nɨmboe sapo ranɨ-sɨmboanɨ anɨmbo moaruwai hamɨndɨ tɨŋɨrɨfo tükündɨfemboe. God ai weaŋgurühɨ muŋgu-moatükunɨ nafɨrandambe moai yahurai tɨŋɨrɨfo tüküfeyo, asu süŋgunambo amboanɨ ŋgɨrɨ yahurai moatükunɨ tükündɨfeyo. ");
INSERT INTO agg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Asu Adükarɨ ai tɨŋɨrɨfo ranahambo bodɨfoahüfe kɨkemɨndɨkoate mbeimbonana muŋguambo nindou ranai ŋgɨrɨ aboedamboyahindɨ. Ŋga nindou ai wandanei yahu dɨbonɨyu hɨnɨŋgɨmareandürɨ aheimbo hohoanɨmondandürühɨ bodɨfoahünde kɨkɨndeambui. ");
INSERT INTO agg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ranɨsɨmboanɨ nindou mamɨ ai sɨheimbo hoafɨndundürühɨya, ‘Hoeirɨhi, Krais ini nda,’ mbɨseianɨyo asu ‘Hoeirɨhi, ini goagu ra,’ mbɨseianɨ se yowanɨ anɨhondümbofepoanɨ. ");
INSERT INTO agg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nindou bɨdɨfɨrɨ ai ŋgomo tɨkandu houmbo anɨmboya, ‘Ro nda Krais-anahɨ,’ asu ‘Ro Godɨndɨ hoafɨ hoafɨya rɨhandeimb-anahɨ,’ mbɨsɨmo hou hepünɨfeimbɨ moatükunɨ randumboemo. Ai rarumbo-mbembonana God ai nindou dɨbonɨyundüreimbɨ ranaheimbo tɨkai hoafɨyomondürɨ. ");
INSERT INTO agg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ranɨmboane muŋgu-moatükunɨ tükefeyo ra se hɨbadɨhümbo, ŋga muŋguambo moatükunɨ tüküfekoateyoambe ranahambo hoafayahapurɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Sisas ai hoafɨyuhɨ yahuya, “Ranɨ-moatükunɨ ranai tükündɨfe hayambondoanɨ anɨmbo, hüfɨhamɨndɨ ai nɨmbɨraŋɨ ndamɨndɨmboe asu amoamo ai ŋgɨrɨ sindu. ");
INSERT INTO agg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mupui ai sünambeahɨndɨ fɨrɨbadeboai pütapɨndowohü asu muŋguambo sünambeahɨndɨ ŋgɨnɨndɨ moatükunɨ ranai fɨfɨmɨndɨmboe. ");
INSERT INTO agg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ranɨsɨmboanɨ anɨmbo nindou ai hoeindɨhoranɨ Nindou Hondü ai mburɨŋgaiwamɨ naŋgu haya ahandɨ hɨmboamupuimbo-randeimbɨ ŋgɨnɨndɨ kapeihɨ kudümbui. ");
INSERT INTO agg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ranɨsɨmboanɨ anɨmbo ai sünambeahɨndɨ nendɨ koandɨhepuranɨ ŋgomo nindou God ai dɨbonɨyundüreimbɨ ra hɨfɨ ranahandɨ yimbuyimbu hɨmboranɨpoedɨ gugurɨnduwurümboemo. Ai hɨfɨ ranühɨ fufundündɨmo ŋgomombo sünü hɨfɨ fondeandambe ŋgomo tükündafumboemo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sisas ai asükai hoafɨyuhɨ yahuya, “Se süfurɨ nɨmɨndɨ fɨfɨrɨndundɨ. Nɨmɨ ranai emündü fofoayo ana, se fɨfɨrundɨ ra ndeara hoembo akɨmɨ tüküfembo yahomboane. ");
INSERT INTO agg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mamɨ yahuraiane, se hoeindundanɨ muŋguambo moatükunɨ tükefeyo ra se fɨfɨrɨndundɨ, Nindou Hondü ai ŋɨgɨrɨ amɨtata kudu, ŋga ndeara yipurɨ kɨmani anüŋgu. ");
INSERT INTO agg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ro sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ. Bɨdɨfɨrɨ nindou hɨfɨ ndanühɨ anɨboadei ranai yɨfɨkoateyeiambe anɨmbo ranɨ-moatükunɨ ra tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hɨfɨ asu sünü ana awarɨndɨhoemboe, ŋga wandɨ hoafɨ ana ŋgɨrɨ awarɨndɨhoayo, ŋga wanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Sisas ai asükai hoafɨyuhɨ yahuya, “Nindou mamɨ ai-amboanɨ moai ranɨ-moatükunɨ tüküfemboayo si ra fɨfɨreandɨ. Sünambeahɨndɨ nendɨ amboanɨ moai fɨfɨrundɨ asu Nɨmorɨ ai-amboanɨ moai fɨfɨreandɨ, ŋga Afɨndɨ ai-yaŋgɨrani fɨfɨreamboayu. ");
INSERT INTO agg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Se hɨbadümbo nɨŋgomo, nɨmboe sapo ranɨ-moatükunɨ tüküfembo ra se moai fɨfɨrundɨ. ");
INSERT INTO agg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ranana nindou mamɨ ai ŋgorügoanɨnɨ hombo yahu haya, ahandɨ ratüpurɨyomo rundeimbɨmbo hɨbadündɨ yahu haya ratüpurɨ yimbureapurɨ mbura nindou yipurɨ hɨfandɨra-randeimbɨmbo yipurɨ wudɨpoapondo hɨbadandɨ ehu nahuraiane. ");
INSERT INTO agg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ranɨmbo-anɨmbo se hɨbadümbo nɨmandümo, nɨnɨ sɨmboanɨ worɨ aharambürü ranai tükümandɨfi, ra se moai fɨfɨrundɨ. Ai nɨmbambe tükümandɨfiyo nɨmbɨ mbusümombomandüyo, siambeahɨmandüyo ra se moai fɨfɨrundɨ. ");
INSERT INTO agg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Asu ai nɨmehünou tükündüfi hoeindeapuranɨ asu se apomboemo. ");
INSERT INTO agg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ndanɨ hoafɨ ro sɨhamumbo hoafehapurɨ ra, muŋguambo nindoumbo kapeih-anahɨ, ŋga se hɨbadɨhümbo nɨmandei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","God ai Israerɨmbo Aboedambo-mareandüra aboedɨ manɨmboei si (Pasofa) asu bret yisɨkoate sesɨmbo si ra tüküfembo yimbu si manɨŋgo. Ranɨyo Godɨmbo sɨhou-rundeimbɨyomo asu ahɨnümbɨ hohoanɨmo yamundurundeimbɨ ai Sisasɨmbo kɨkɨhimündɨ hɨfokoefimbo hohoanɨmomemo. Ranɨyo ai hoafɨyomondühɨ yahomoya, “Sɨhɨrɨ nɨnɨ-süŋgundɨhu Sisasɨmbo wosɨhoaforɨ hoafɨ ndɨhurɨ mbunduhu kɨkɨhɨndɨhurɨmɨndefɨ hoahu hɨfokoamandɨhurɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ai hoafɨyomondühɨ yahomoya, “Sɨhɨrɨ adükarɨ sihɨ ana refepoanɨ, ŋga nindou ai ŋgɨnɨndɨndeihɨ sɨhefɨ mbusümo yifiarɨ botɨndɨhimboyei,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sisas ai Betani ŋgoafɨhü Saimon horombo mɨmanɨho masɨmeimboyoweimbɨ ahandɨ worambe mamaru. Sisas ai nindou ranahandɨ worambe sesühɨ nɨmaruane, nɨmorehɨ mamɨ ai nɨmoei hɨpɨrambe sanda aboedɨ fɨsɨŋarümbü kakɨ afɨndɨ fihɨ semɨndeimbɨ semɨndɨ haya tükümefeyo. Ranɨyo Sisas ai sesühɨ nɨmaruane ai hɨpɨrɨ ra boborehaya sanda ra ahandɨ mbɨrowamɨ kamareando. ");
INSERT INTO agg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ŋga asu nindou bɨdɨfɨrɨ mamarümo ranai ŋgɨnɨndɨyomondühɨ sɨmborɨ hoafɨyomondühɨ yahomoya, “Nɨmboe sanda ra yatɨkɨrɨ-yatɨkɨrɨ aranda? ");
INSERT INTO agg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nindou ai sanda ra kakɨnambo mbasahümündi-mbonana 300 kakɨ hoarɨnambo anɨmbo sahümündihɨ kakɨ ra nindou napokoate-yeimbɨmbo sahundürɨ,” mehomo. Ranɨmboemo ai nɨmorehɨ ranahambo ŋgɨnɨndɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ŋga Sisas ai hoafɨyupurühɨ yahuya, “Nɨmorehɨ ra ambe, ŋga nɨmboe se ahambo ŋgɨnɨndarunda? Ai aboedɨ moatükunɨyo wambo ramareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nindou napokoateyeimbɨ ana muŋguambo si sebabɨdɨmbo nɨmandeimboyei. Se nɨnɨ-sɨmboanɨyo aheimbo fehefendürɨmbo hohoanɨmoayei ra fandɨhehindürɨ. Ŋga ro ana ŋgɨrɨ muŋguambo si se-babɨdɨmbo nɨmboahɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nɨmorehɨ ndanai nɨnɨ-moatükunɨyo ai refembomayo ranɨyo ramareandɨ. Ai wandɨ fi sandanambo hundürümarandɨ ra yɨfɨndahanɨ hɨfɨkefendɨrɨmbomayo ranɨmboyo ranɨ boatei ramareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ro sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ, muŋguambo hɨfɨ aboedɨ hoafɨ ra wataporɨmbondundühɨ nɨmorehɨ ai ramareandɨ ranahambo hoafɨndɨmonda ahambo hohoanɨmondeimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ranɨsɨmboanɨ Sisasɨmbo süŋgururü-rundeimbɨ mamɨ Sudas Iskariot ai Godɨmbo sɨhou-rundeimbɨ sowana Sisasɨmbo ahamundɨ warɨhüfimbo mahu. ");
INSERT INTO agg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Godɨmbo sɨhou-rundeimbɨ ai ranɨ hoafɨ ra hɨmborɨyomo houmbo hɨhɨfɨ-hɨhɨfɨyomondühɨ Sudasɨmbo bɨdɨfɨrɨ kakɨ segodombo hoafɨmemo. Ranɨyo Sudas ai Sisasɨmbo ahamundɨ warɨhüfimbo nɨnüŋgumandɨhe yahuhayambo hohoanɨmomayu. ");
INSERT INTO agg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bret yisɨkoate sesɨmbo si ranai weaŋgurühɨ tükümefeyo. Ranɨsɨmboanɨ ra Pasofa sipsip nɨmorɨ sesɨmbohünda hɨfokoarɨhi arɨhündɨ. Asu Sisasɨmbo süŋgururü-rundeimbɨ ai düduyafundowohü yahomoya, “Se hohoanɨmoyafanɨ ro sesesɨmbo ra sɨhambo nahü ŋgefɨ dɨdɨboado-mandɨhunda?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Asu Sisas ai ahambo süŋgururü-rundeimbɨ yimbu koarɨhepɨrühɨ yahuya, “Se adükarɨ ŋgoafɨnambo ŋgafanɨ. Ranühɨ nindou mamɨ hoe hɨpɨrambe ndemündü haya nafɨnɨ düdɨ tükündüfimbui. Ahambo anɨmbo se süŋgundɨnɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Se hoeindɨneranɨ nɨnɨ-worɨnamboyu afarɨfiyu ra se worɨ aharambürɨ ranahambo düdundafɨneandühɨ anɨmboya, ‘Nindou yamunde-randeimbɨ ai düdufihɨya, ‘Worɨ nahanambe Pasofa si sesɨ ra sesesɨmandefɨ?’ mehuamboanehɨ,’ mbɨsafanɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Rananɨmbo adükarɨ nɨmoamondɨ worɨ nafɨrɨndümo hɨnɨŋgɨmarundɨ ra nafuindümbui. Ranühɨ anɨmbo se sesɨ ra sɨndɨndɨneandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Süŋgurɨnerɨ-rɨnandeimbɨ ranai hafanɨ ŋgoafɨ ranühɨ hoeirɨneandane, muŋgu-moatükunɨ ai hoafɨmayu süŋgure meŋgoro. Ranɨyo ranühɨ sesesɨmbo sesɨ ra sɨndɨmarɨneandɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ndeara nɨmbɨhoafɨ-mayoamboyo Sisas ai ahandɨ süŋgururü-rundeimbɨ 12 ranɨbabɨdɨmbo mahomo. ");
INSERT INTO agg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ai sesɨ sowasümondühɨ nɨmarɨmombo Sisas ai hoafɨyupurühɨ yahuya, “Ro sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ. Nindou mamɨ seambeahɨndɨ anɨmbo wambo hürütümbɨ nindou-yomondɨ warɨhündeandɨrɨmbui. Nindou ranai hapondanɨ ro-dɨbombo sesɨ asesu,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Süŋgururü-rundeimbɨ ranai ranɨ hoafɨ ra hɨmborɨyomo houmbo ŋgusüfoambe moaruwaimarapurɨ. Ranɨyo mamai mamaiyomondühɨ düdururühɨ yahomoya, “Awi rombayahɨpoanɨ?” ranɨranɨmemo. ");
INSERT INTO agg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sisas ai hoafɨyupurühɨ yahuya, “Nindou ranana seambeahɨndani. Ai bret semündü haya rodɨbo hɨpɨrambe afoarɨhoandɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Anɨhondane Nindou Hondü ai yɨfɨmbiyuamboane. Baiborambe hoafɨyohüya, yɨfɨndümbui, meho süŋgu. Ŋga nindou düdi Nindou Hondü hürütümbɨ nindou-yomondɨ warɨharirɨ ranai hɨpoanɨmboembouani. Mamɨharɨ hondɨ ai ahambo ana wakemündɨkoate mbeyowamboyo.” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sowasümondühɨ nɨmarümombo Sisas ai bret semündü hɨfɨtɨre Godɨmbo hɨhɨfɨrürɨ mbura ahambo süŋgururü-rundeimbɨmbo yimbumareapurɨ. Asu ai hoafɨyupurühɨ yahuya, “Se sowandümo, ŋga nda wandɨ fi safane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Asükai wain hoe kapambe semündü Godɨmbo hɨhɨfɨrürɨ mbura masagapura ai muŋguambo masɨmɨndɨmo. ");
INSERT INTO agg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Asu Sisas ai hoafɨyupurühɨ yahuya, “Nda wandɨ horane God hoafɨ fɨramündü masɨhendɨ ra ŋgɨnemɨndɨmbo. Wandɨ horɨ karefoendɨ ra muŋguambo nindoumbo fehefembo-hündamboane. ");
INSERT INTO agg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ro sɨhamumbo anɨhondümbo-anahɨ hoafehapurɨ, Ro ŋgɨrɨ asükainda wain hoe ndɨmɨndɨhɨ, ŋga moanɨ ŋga ŋgambo God ŋgɨnɨndɨ hɨfandarandɨ ranambe sɨmborɨ wain hoe ndɨmɨndɨmboyahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ranɨyo herü mamɨ herüyomondühɨ adükarɨ ŋgoafɨ ra hɨnɨŋgɨru houmbo Orif hɨfɨ wafuanambo mahafomo. ");
INSERT INTO agg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sisas ai ahambo süŋgururü-rundeimbɨmbo hoafɨyupurühɨ yahuya, “Se muŋguambo sɨhamundɨ anɨhondümbofe hɨnɨŋgɨndumboemo. Nɨmboe sapo Baiborambe yare hoafɨyowohü yahoya, ‘Ro sipsip hɨfandɨrandeimbɨ nindou hɨfokoandɨhina asu sipsip ai buküründahimboyei,’ meho. ");
INSERT INTO agg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ŋga yɨfɨhündɨ botɨndahe hehea roboakorɨ Gariri hɨfɨnambo ŋgümboyahɨ,” mehu ");
INSERT INTO agg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita ai hoafɨyundühɨ yahuya, “Muŋguambo nindou ai sɨhambo anɨhondümbofe hohoanɨmo ra hɨnɨŋgɨndumboemo. Ŋga roana ŋgɨrɨ hɨnɨŋgɨndɨheanɨnɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sisas ai hoafɨyundühɨ yahuya, “Ro sɨhambo anɨhondümboanahɨ hoafehanɨnɨ, ndanɨ nɨmbokoanɨ kakaro ai yimbumbo hoafɨkoateayuambe anɨmbo se ŋgɨmɨmbo hoafɨndafühɨya, ro moai ahambo fɨfɨrɨhinɨ mbɨsamboyafɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ŋga Pita ai hoafɨyuhɨ yahuya, “Ro ŋgɨrɨ moai fɨfɨrɨhinɨ mbɨsahɨ, ŋga sedɨbo yɨfɨndamboyahɨ,” mehuamboemo. Asu bɨdɨfɨrɨ süŋgururü-rundeimbɨ ai-amboanɨ mamɨ yahurai hoafɨmemo. ");
INSERT INTO agg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ai homo Getsemani seiarɨhündɨ ranühɨ tüküyafu ahambo süŋgururü-rundeimbɨmbo hoafɨyupurühɨ yahuya, “Se ndühɨ nɨmandümo, ŋga ro Godɨmbo dɨdɨbafɨnda samboanahɨ,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Asu ai Pita, Sems, Son ahamumbo yaŋgɨrɨ sepurɨmündü haya mahu. Ranɨyu asu Sisas ai ŋgusüfo pukɨrɨrɨhü ŋgusüfoambe moaruwai hohoanɨmomarɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ranɨyu hoafɨyupurühɨ yahuya, “Wandɨ ŋgusüfoambe pukɨrandɨrühɨ yɨfɨmbo yaŋgɨrayahɨ. Ŋga se ndühɨ ndondu nɨmandɨmo hɨbadündɨ,” mehu ");
INSERT INTO agg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ai akɨdou sühüfi hu hɨfɨnɨ amoembü amoearümbo nafɨ yagodohü ana, tɨŋɨrɨfo ra gübüsɨmbɨfoareandɨra yahu haya dɨdɨbafɨmefiyu. ");
INSERT INTO agg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ai ndare dɨdɨbafɨfihɨ yahuya, “Ape, wandɨ Ape, se yifirayafɨ ana wambo tɨŋɨrɨfoembü moatükunɨ ra raguanambo-ndowandɨ. Ŋga se yowanɨ wandɨ yifirɨ süŋgufepoanɨ, ŋga sɨhafɨ yifirɨ süŋgundowandɨ,” mehu ");
INSERT INTO agg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ai hɨhɨrɨfi hu hɨmboyuwane ahambo süŋgururü-rundeimbɨ ranai mapomondamboyu. Ai Pitambo hoafɨyundowohü yahuya, “Saimon, se apafühɨyafɨ? Asu se awi mamɨ awa amboanɨ yaŋgɨrɨ nɨmarɨmbo ra wanɨyo?” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Asu ai hoafɨyupurühɨ yahuya, “Se hɨbadu nɨŋgomombo dɨdɨbafɨndafundɨ, ŋga sɨhamumbo refe hoeifepurɨmbo tükündɨfeyoanɨ pɨndɨmboemo. Anɨhondane, ŋgusüfo ana refembo hohoanɨmoayosɨ, ŋga fiane nɨmborayo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Asükai Sisas ai hɨhɨrɨfi hüfo weaŋgurühɨ dɨdɨbafɨmefiyu nahurai dɨdɨbafɨmefiyu. ");
INSERT INTO agg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ai asükai hɨhɨrɨfi hu hɨmboyuwanɨ ahambo süŋgururü-rundeimbɨ ai yapombo hɨmbomarapura mapomo. Ranɨyo yaŋgɨrɨmareapura, asu moai nɨnɨ-hoafɨ ahambo hoafɨmbo fɨfɨrundɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sisas ai asükai ŋgɨmɨ noufimbɨ hɨhɨrɨfi sünɨ hɨmboyuwane ahambo süŋgururü-rundeimbɨ ai apusɨmemo. Ranɨyo hoafɨyupurühɨ yahuya, “Awi se fiharu apomomboemo? Ndearambo ranɨ-moatükunɨ ranai tüküfehü Nindou Hondümbo moaruwai hohoanɨmoyomondeimbɨ-yomondɨ warɨhü-rüwurɨmboanemo. ");
INSERT INTO agg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hoeiru, nindou-yomondɨ warɨhüfendɨrɨmbo nindou-mayu ranai tüküfimboani. Ŋga botɨyafu houmbo ŋgefo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sisas ai wataporɨmborandühɨ nüŋguane Sudas süŋgururü-rundeimbɨ 12 ambeahɨndɨ mamɨ ai tükümefiyu. Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨ nindouyomo asu Suda-yafe bogorɨ nindouyomo ranai nindou afɨndɨ safɨ ranahamumbo koamarɨhoupura pisao yihɨmɨndɨ asu nɨmɨharɨ fufuründümo houmbo ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ babɨdɨmbo mahomo. ");
INSERT INTO agg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nindou sapo Sisasɨmbo nindouyomond warɨhüfimbomayu ranai nindou afɨndɨ ranahamumbo dɨbo hoafɨyupurühɨ yahuya, “Nindou ro wakɨkɨhɨndɨhünanɨ anɨmbo aiani, ŋga se ahambo mbundürɨndɨmo houmbo ndondu hɨbadürɨ ŋgomo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ranɨyo Sudas ai nɨmehünou hu Sisasɨmbo hoafɨyundowohü yahuya, “Yamundo-randeimbɨ,” yahuhü wakɨkɨhɨmarürɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ranɨyo nindou ranai Sisasɨmbo warɨyomo homo mbumaründümo. ");
INSERT INTO agg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nindou akɨmɨ burɨmemo ranambeahɨndɨ mamɨ ranai ahandɨ pisao hüramündɨ haya Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨndɨ ratüpurɨyu randeimbɨmbo harɨmeindo. Ranɨyo ahandɨ ŋgorü hɨmbo hoearɨ mafoafoareando. ");
INSERT INTO agg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Asu Sisas ai hoafɨyupurühɨ yahuya, “Se pisao asu nɨmɨharɨ fufuründümo houmbo wambo kɨkɨhemɨndɨrɨmbo masɨfomo ra hümbuhünümbɨ nindoumbo kɨkɨhimɨndɨmbo nahuraianemo. ");
INSERT INTO agg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ro si mamamɨ-rɨhandühɨ sebabɨdɨmbo nɨmarɨmbo Godɨndɨ worambe nindou yamundɨhearü marɨhandɨ ra asu se moai wambo kɨkɨhɨründümondɨrɨ. Ŋga Baiborambe hoafɨmayo ra anɨhondü tükümbɨfeyoamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ranɨyo ahambo süŋgururü-rundeimbɨ ranai hɨnɨŋgɨrüwurɨ houmbo pomefoundɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Nindou hoarɨfɨ mamɨ ai kɨfohɨ hoearɨ yaŋgɨrɨ güde haya Sisasɨmbo süŋgumarürɨ hüfu. Asu ahambo kɨkɨhɨrundümondane hoearɨ yaŋgɨrɨ kɨkɨhɨmaründümonda safɨ yaŋgɨrɨ mafifoendɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sisasɨmbo mburündümo mburumbo Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨ hondündɨ worambe, Godɨmbo sɨhou-rundeimbɨ, bogorɨ nindou asu ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ gugureafu nɨmarɨmondanɨ sowaründümo mahomo. ");
INSERT INTO agg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Sowaründümo mahomondamboyo Pita ai akɨdou aŋgunɨsafɨ süŋgumarapurɨ hu. Ai hu Godɨmbo sɨhou-rundeimbɨ-yomondɨ bogorɨ hondündɨ worambe kefuai prisman babɨdɨmbo haihü mamarɨmo. ");
INSERT INTO agg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨ asu muŋguambo kansɨr ai nɨnɨ-moaruwai moatükunɨrandɨ Sisas ai ramareandɨ ra fɨfɨrɨfembo-hünda kokomarundɨ. Ahambo hɨfokoefimbo-hünda ahandɨ moaruwai hohoanɨmo fɨfɨrɨfembo-hünda kokomarundɨ, ŋga ai moai nɨnɨ-akɨdou amboanɨ moaruwai rareanda fɨfɨrundɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nindou afɨndɨ ahambo tɨkarɨhorɨ hehi papɨ hoafɨmarɨhorɨ, ŋga ahei hoafɨ ra yimbusümoane. ");
INSERT INTO agg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Nindou bɨdɨfɨrɨ ai Sisasɨmbo papɨ hoafɨmbo yahomo houmbo nɨŋgomombo hoafɨyomondühɨ yahomoya, “Ro hɨmborɨyefanɨ ai hoafɨyuhɨ yahuya, ‘Godɨndɨ worɨ nindou ahamundɨ warɨnambo worɨmbomarundɨ ra bɨrɨboadɨheamboyahɨ. Asu ro ŋgɨmɨ si yaŋgɨrɨ asükai nindou warɨna worɨmbokoateyeimbɨ worɨ ra worɨmbondɨhamboyahɨ,’ mehu,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ŋga asu ahamundɨ hoafɨ wataporɨmbomarundɨ ranai sɨmogodühɨ hoafɨkoate mamɨkarɨ wataporɨmboru wakɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨ ai kansrɨyomondɨ hɨmboahü botɨfi nüŋgumbo Sisasɨmbo düdurirühɨ yahuya, “Nɨmboe papɨ hoafarunɨnɨ ranahambo sɨmborɨ hoafɨkoateayafa?” mehundo. ");
INSERT INTO agg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ŋga Sisas ai ahamumbo moai nɨnɨ akɨdou amboanɨ hoafɨyupurɨ. Asükai sesɨ sɨhai-randeimbɨ ai düdurirühɨ yahuya, “Se God aboedani sei rɨhündeimbɨ ahandɨ nɨmorɨ Kraisɨ-yafɨ, wanɨyo?” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Asu Sisas ai hoafɨyuhɨya, “Rananahɨ. Rananɨmbo se muŋguambo hoeindɨhoranɨ Nindou Hondü ai God Ŋgɨnɨndeimbɨndɨ warɨhondü waranɨ nɨmandümbui asu sünambeahɨndɨ mburɨŋgai dɨbonde kudümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨ ranai ahandɨ fihɨndɨ hoearɨ hɨreandühɨ hoafɨyupurühɨ yahuya, “Ŋgɨrɨ nindou ŋgorü ai moaruwai ramareandɨ ranahambo hoafɨndu. ");
INSERT INTO agg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Se hɨmborɨ-yomondanɨ ai Godɨmbo tɨrɨfoefe hoafɨmayu. Se hohoanɨmoyomondanɨ sɨhɨrɨ ahambo nɨnɨ-nünüŋgu-mandɨhura?” mehuamboemo. Asu muŋguambo ai hoafɨyomondühɨ yahomya, “Ai moaruwai ramareandɨ ranɨmbohünda yɨfɨmbiyu-wamboane,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bɨdɨfɨrɨ ai ŋgurɨ tɨfɨyafundo asu hoearɨnambo hɨmboarɨ gabudɨfoaru mburumbo harɨmemondo. Ai hoafɨyomondühɨ yahomoya, “Hoafɨyafɨ düdi sɨhambo harɨmayu ra,” mehomo. Ranɨyo asu prisman ai sowaründümo houmbo harɨmemondo. ");
INSERT INTO agg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ai hoafɨ yɨbobofe worɨ ginɨrɨ mbusümondühɨ nɨmaruwane Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨndɨ ratüpurɨyo randeimbɨ yihoarɨfɨ ai tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ai hoeirerane Pita ai haihü mamaruwa hɨmboarɨ parerɨ nɨŋgombo hoafɨyohü yahoya, “Seamboanɨ Sisas Nasaretɨhündɨ dɨbombo manɨmbafane,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Asu Pita ai wanɨ yahu hoafɨyuhɨ yahuya, “Se hoafayafɨ ranana ro moai fɨfɨrɨheandɨ,” yahu haya worɨ yipurɨkɨmɨ mahu. ");
INSERT INTO agg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Asu ratüpurɨyo randeimbɨ ranai asükai hoeirerɨ haya nindou akɨmɨ manɨŋgomo ranahamumbo hoafɨyopurühɨ yahoya, “Nindou ndanai amboanɨ ai dɨborɨhɨndani,” meho. ");
INSERT INTO agg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ŋga asükaiyu Pita ai dɨdɨmoyuhü wanɨ mehu. Akɨdou hɨhɨnɨŋgɨre mbura nindou manɨŋgomo ranai Pitambo hoafɨyomondühɨ yahomoya, “Anɨhondü, seamboanɨ Garirihünd-anafɨ, ŋga se ai dɨborɨhɨnd-anafɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Asu asükai ai dabarɨfihɨ yahuya, “Se nindou wataporɨmboarɨhorɨ ranana ro moai fɨfɨrɨhinɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ai ranɨ hoafɨ ra hoafɨyu hayamboyuane, nɨmehünou kakaro ai asükai hoafɨmayu. Ranɨyo Sisas ai Pitambo hoafɨyundowohüya, “Kakaro ai yimbumbo hoafɨkoate-ayuambe anɨmbo ŋgɨmɨmbo wamboya moai fɨfɨrɨhinɨ mbɨsamboyafɨ,” mehu ra hohoanɨmoyuhɨ asu Pita ai afɨndɨ aranɨmayu. ");
INSERT INTO agg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Siambe hondü Godɨmbo sɨhou-rundeimbɨ bogorɨ, hɨfandɨrundeimbɨ nindou, ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ muŋguambo kansɨr ai hoafɨ mamamberu masɨhoundɨ. Ranɨyo asu süŋgunambo Sisasɨmbo warɨ hüputüpurundümo mburumbo Pairat sowanambo sowaründümo mahomo. ");
INSERT INTO agg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Asu Pairat ai Sisasɨmbo düdurirühɨ yahuya, “Se Suda-yei adükarɨ bogorɨyafɨ?” Asu Sisas ai sɨmborɨ hoafɨyuhɨya, “Se sɨhafɨhoarɨ hoafayafɨsɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Godɨmbo sɨhou-rundeimbɨ ai afɨndɨ papɨ hoafɨmarura asu Pairat ai asükai düdurirühɨ yahuya, “Sɨhambo afɨndɨ papɨ hoafarunɨnɨ. Asu se nɨmboe akɨdou amboanɨ sɨmborɨ hoafɨkoateayafa?” mehu. ");
INSERT INTO agg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Asükai Sisas ai akɨdou amboanɨ hoafɨ-koatemayua Pairat ai mahepünɨfiyu. ");
INSERT INTO agg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Muŋgu hɨmbanɨ Pasofa sesesɨ si tüküfeyoambe Pairat ai karabusambeahɨndɨ nindou mamɨ aboedambo hɨnɨŋgɨrirɨ-marandɨ. Nɨmorehɨ nindowenihɨ ranai aheihoarɨ ndürɨ dükarɨhoranane hɨnɨŋgɨrerü marandɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ranɨsɨmboanɨ nindou mamɨ ahandɨ ndürɨ Barabas ai nindou bɨdɨfɨrɨ sepurɨmündü haya gafman babɨdɨmbo yifiarɨyomo nindou hɨfokoamarunda karabusɨmarüpurɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nindou afɨndɨ ranai gugureandühɨyo Pairatɨmbo horombo aheimbo yaremarandɨ rasüŋgufembo düdumehindɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Asu Pairat ai düdurerühɨ yahuya, “Se hohoanɨmoyeiyanɨ sɨheimbo sowana Suda-yei adükarɨ bogorɨ ra aboedambo koandɨhehinɨmboyo?” mehu. ");
INSERT INTO agg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sapo Pairat ai ndore fɨfɨreandɨ Godɨmbo sesɨ sɨhou-rundeimbɨ ai Sisasɨmbo ŋgusüfoambe moaruwaiyomondühɨyo ahambo sowana koamarɨhawurɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ŋga Godɨmbo sɨhou-rundeimbɨ ai nindou afɨndɨ ranaheimbo hohoanɨmo botɨmarundürɨ Sisasɨmbo ana yowanɨ aboedambofipoanɨ, ŋga Barabasɨmbo anɨmbo, yahomo houmbo. ");
INSERT INTO agg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Asükai Pairat ai düdureandürühɨ yahuya, “Se hohoanɨmoyeiyanɨ, ro nɨnɨ-nünüŋgu mandɨhinɨ se Suda-yei adükarɨ bogorɨ sei arɨhündɨ ranahambo-a?” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Asu ai asükai hoafɨ karɨhehindühɨ seiya, “Nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkoemündü pefimboani,” masei. ");
INSERT INTO agg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Asu Pairat ai düdureandürühɨ yahuya, “Ŋga asu nɨne-moaruwai ramareanda?” mehuamboyei. Asu ai puküna hoafɨ karɨhehindühɨ seiya, “Nɨmɨ keimbɨ karɨhendeimbɨ-fihɨ tɨkoemündü pefimboani,” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ranɨyo nindou afɨndɨ ranai hɨhɨfɨ-hɨhɨfɨmbeyeia yahu haya aheimbo sowana Barabasɨmbo koamarɨheirü. Asu amimbo hoafɨmayua Sisasɨmbo ndüfurɨ ndüfurɨrurɨ mburumbo nɨmɨ keimbɨ karɨhendeimbɨ-fihɨ tɨkoemündɨ pefimbohünda ami-yomondɨ warɨhümarirɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ami ai Sisasɨmbo sowaründümo homo Rom gafmanɨ-yomondɨ adükarɨ worɨ, Pretoriam seimarɨhündɨ, ranambe hɨnɨŋgɨrüwurɨ houmbo ami bɨdɨfɨrambo hoafɨmemonda gugurɨmefundɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ranɨyomo hoearɨ yimɨndɨbadɨ-hounduwohüyo hamburɨ hoearɨ güdɨndo mburumbo tɨhoarɨ tɨhoarümbɨ wofɨnambo at nahurai nafɨru mbɨroambe kɨkɨmafoarundo. ");
INSERT INTO agg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ranɨyo ai Sisasɨmbo hoafɨyomondühɨya, “Suda-yafe adükarɨ bogorɨ, karɨhasɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ranɨyo ahambo nɨmɨharɨnambo mbɨrowohü harɨyomondo, ŋgurɨ tɨfɨyafundo, adükarɨmbo hohoanɨmombo rawefundɨ nou tɨkaruhou yimɨndɨhona nɨmarɨmo raraomarundɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ai ahambo tɨrɨfoefi hoafɨmbo muŋgua-moatükunɨ ra raru mburu asu hamburɨ hoearɨ gudɨmaründo ra yimɨndɨ-ründümondühɨ asükai ahandɨ hondü ra güdɨmarundo. Muŋgu-moatükunɨ raraoru mburu nɨmɨ keimbɨ karɨhendeimbɨ-fihɨ tɨkoemündɨ pefimbo sowaründümo mahomo. ");
INSERT INTO agg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sisasɨmbo sowaründümo houmbo heihüyei Sairinihündɨ nindou mamɨ, ahandɨ ndürɨ Saimon, Areksander Rufus-yafandɨ afɨndɨ ai adükarɨ ŋgoafɨnambo masüfuwa hoeimarɨhorɨ. Ranɨyo ami ai sowaründümo houmbo hoafɨmemondoa Sisasɨndɨ nɨmɨ keimbɨ karɨhendeimbɨ ra masemündu. ");
INSERT INTO agg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ranɨyo Sisasɨmbo sowaründümo homo Gorgota sei arɨhündɨ ranɨhü tükümehindɨ. Gorgota ranahandɨ nɨmɨndɨ ra mbɨrɨhapɨrɨ-ane. ");
INSERT INTO agg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ranühɨyo ami ai Sisasɨmbo wain hoeambe hühütimbü marasen fanduyamundu mburu masabudo, ŋga ai moai sümündu. ");
INSERT INTO agg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ranɨyo ami ai ahambo nɨmɨ keimbɨ karɨhendeimb-fihɨ parüwurɨ mburumbo ahandɨmayo hoearɨ-napo ra yimbuemɨndɨmbo yahomo hou satu piraimemo. ");
INSERT INTO agg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sapo Sisasɨmbo nɨmɨ keimbɨ karɨhendeimb-fihɨ pamarüwurɨ ra siambeahɨ hüfɨhamɨndɨ kehurɨ süfuambeyo. ");
INSERT INTO agg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ahambo papɨ hoafɨ sürü paru mburu ranai yare hoafɨyowohü yahoya, “SUDA-YAFE ADÜKARƗ BOGORƗ,” meho. ");
INSERT INTO agg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Asu Sisasɨndɨ fikɨmɨ nindou yimbu yifiarɨyafanɨ hümbuhünɨyafanɨ rɨnandeimbɨ ahafanɨmbo amboanɨ tɨkorüpɨndümo pamarupɨrɨ. Ŋgorü Sisasasɨndɨ kadüdanɨ parüwurɨ asu ŋgorü warɨhondanɨ parüwurɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ranɨyei nindou afɨndɨ ranai ŋgasündɨhorɨ heiheirühündühɨ mbɨro hɨrɨhɨrɨhündühɨ ahambo tɨrɨfoefe hoafɨ hoafɨyeihɨ “Sapo se safɨya ‘Godɨndɨ worɨ bɨrɨfoefe hefe ŋgɨmɨ sihɨ yaŋgɨrɨ worɨmbondɨhɨ hɨnɨŋgɨndɨheamboyahɨ,’ masafɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hapondanɨ se sɨhafɨ fimbo farɨhoefɨ. Se nɨmɨ keimbɨ karɨhendeimbɨ fihɨndɨ foarefoa hawambo kosafɨ,” masei. ");
INSERT INTO agg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Asükai mamɨ yahurai Godɨmbo sɨhou-rundeimbɨyomo asu ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ-yomo ai-amboanɨ tɨrɨfoefe hoafɨmarurɨ. Ai ahamundɨhoarɨ raru hoafɨyomondühɨ yahomoya, “Ai nindou amurambo aboedamboreandürɨ-marandɨ, ŋga asu moai ahandɨ fimbo aboedamboreandɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Krais Israerɨyei adükarɨ bogorɨ ranai nɨmɨ keimbɨ karɨhendeimbɨ ra hɨnɨŋgɨre haya mbɨkusɨfuendɨ. Rananɨmbo sɨhɨrɨ hoeindɨhurühɨ ahambo anɨhondümbo-ndɨhurɨmboane,” mehomo. Nindou yimbu Sisasɨndɨ fikɨmɨ pamarupɨrɨ ai-amboanɨ mamɨ yahurai Sisasɨmbo tɨrɨmafoarɨnerɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hüfɨnɨmbo ranɨ hɨfɨhü nɨmbɨ ranai peyo haya ho hombo hüfɨhamɨndɨ wuwurɨyuambe tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hüfɨhamɨndɨ wuwurɨyuambe Sisas ai puküna heiyuhü yahuya, “Eri, eri, rema sabaktani?” mehu. Hoafɨ ranahandɨ nɨmɨndɨ ra ndahuraiane: Wandɨ God, wandɨ God, nɨmboe se wambo hɨnɨŋgɨmarowandɨrɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nindou bɨdɨfɨrɨ akɨmɨ manɨmboei ranai hɨmborɨyei hehi hoafɨyeihɨ seiya, “Hɨmborɨyei, ai Eraisamboani mɨŋgayu,” masei. ");
INSERT INTO agg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ahei mbusümonɨndɨ nindou mamɨ ai pɨpɨyu hu poposɨ moatükunɨ nahurai semündü mbura wain hoe ranambe foare mbura nɨmɨharɨfihɨ pare hɨmondamündɨ haya masagado. Ŋga asu bodɨmondɨ ai hoafɨyeihɨ seiya, “Awi hoeindɨhu mbundɨhumbo, Eraisa ai ahambo farɨhefimbo tükümandɨfiyu, wanɨmandɨyo?” masei. ");
INSERT INTO agg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Asu Sisas ai asükai puküna heiyu mbura yɨfɨmayu. ");
INSERT INTO agg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Refihɨyu asu Godɨndɨ worambe hoearɨ kümarundɨ ranai nɨmoamo ŋgahɨ peyo haya bure hanɨmbo gebü hɨfɨnɨ türeandühɨ yimbumbore bumareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Asu ami-yomondɨ bogorɨ Sisasɨndɨ fikɨmɨ manüŋgu ranai ai yɨfɨmayu ra hoeireanda mayoa hoafɨyuhɨ yahuya, “Anɨhondane, nindou nda Godɨndɨ nɨmor-ani,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nɨmorehɨ bɨdɨfɨrɨ ai akɨdou aŋgunɨ safɨ nɨboadei hɨmboapomayei. Ahei mbusümo ra Maria Makdarahündɨyo, Maria, Sems Sosep-yafandɨ hondɨyo asu Saromeyo. ");
INSERT INTO agg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sapo Sisas ai Garirihɨ nüŋguambe nɨmorehɨ ranɨyei Sisasɨmbo süŋgurɨhorühɨ farɨhehorɨ marɨhündɨ. Asu amurɨ bɨdɨfɨrɨ nɨmorehɨ Sisas babɨdɨmbo Serusaremɨnambo mahei ai-amboanɨ ranühɨ manɨmboei. ");
INSERT INTO agg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sosep Arimateahündɨ ai kansɨrɨyu haya muŋguambo nindou ai aiana aboedani sei hehi ahɨnɨrɨhorɨ hündeimbɨyu. Ai-amboanɨ God ŋgɨnɨndɨ hɨfandarandɨ ranahambo hɨmboyu-marandɨ. Sümbo moanɨ ŋgoafɨmbo nɨmarɨmboane yaho yimuŋgurɨfeambe Sosep ai yɨhɨmbokoate hu Pairatɨndɨ hɨmboahü nüŋgumbo Sisasɨndɨ finɨmoko semündümbo düdumefiyu. ");
INSERT INTO agg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pairat ai Sisas yɨfɨmayu hoafɨ ra hɨmborɨyu haya hepünɨmefiyu. Ranɨyo ami-yomondɨ bogorɨmbo mborai mehuamboyu mahua Sisas ai yɨfɨmbaiyu wanɨyo yahu haya düdumarirɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ami-yomondɨ bogorɨ ranai hoafɨmayua hɨmborɨyu haya Pairat ai Sosepɨmboya yɨfɨ nɨmoko ra ndoarɨndɨfɨ, mehundo. ");
INSERT INTO agg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sosep ai hu kɨfohɨ hoearɨ mamɨ pemɨyu mbura Sisasɨndɨ yɨfɨnɨmoko foarümündɨ hoearambe parirɨ ŋgamondɨfoarirɨ mbura serümündɨ hu hoŋguambe masɨheirɨ. Hoŋgu ra nɨmoei nɨmarɨweimbɨndambo nindou hüti wowondɨmarundɨyo. Ranɨyo Sosep ai nɨmoei adükarɨ ŋgorü gügüra hu hoŋgu nafɨtambe ra güre pare hɨnɨŋgɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ranɨyo Maria Makdarahündɨyo asu Maria Sosepɨndɨ hondɨyo ai Sisasɨmbo masɨhawurɨ ra nɨmbafe hɨmboapomayafe. ");
INSERT INTO agg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Moanɨ ŋgoafɨmbo nɨmarɨmbo si ranai muŋguyowane, Maria Makdarahündɨyo, Maria Semsɨndɨ hondɨyo asu Sarome ai Sisasɨndɨ yɨfɨnɨmoko popoaimbo sei hehi bɨdɨfɨrɨ aboedɨ fɨsɨŋarümbü moatükunɨ pemɨmayei. ");
INSERT INTO agg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","Ranɨyo Sande siambehondü nafɨmbo hüsihü ai aheihoarɨ sɨmborɨ hoafɨyeihɨ seiya, “Dɨdai sɨhefɨmbo fandɨhemunɨ hayambo hoŋgu nafɨtambehündɨ nɨmoei ra ndemündü yɨhɨrɨmandea?” masei. ");
INSERT INTO agg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nɨmoei ranai afɨndɨ hamɨndɨyo, ŋga ai hei hɨmboyeiane nɨmoei ra yɨhɨrɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ai hoŋgu ranambe kefoehi hei hɨmboyeiane, nindou hoarɨfɨ mamɨ hoandarɨ hoearɨ kɨfohɨ güde haya warɨhondü waranɨ mamaruwa hepünɨmehindɨ. ");
INSERT INTO agg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nindou ranai hoafɨyundürühɨ yahuya, “Se yowanɨ hepünɨfepoanɨ. Ro fɨfɨrɨheambo-anahɨ, seana Sisas Nasaretɨhündɨ nɨmɨ keimbɨ karɨhendeimb-fihɨ pamarɨhorɨ ranahamboane kokoarɨhorɨ. Aiana asükai yaŋgɨrɨ botɨmefiyu! Aiana moai ndanühɨ yaŋguru. Ahambo masɨhehorɨ fondɨ ra hoeirɨhi. ");
INSERT INTO agg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ŋga se ŋgei ahambo süŋgururü-rundeimbɨ asu Pitambo amboanɨ hoafɨndei. Sisas aiana sɨhamumbo Garirinambo horombofi haya mahu. Horombo hoafɨmayu süŋgu Garirihü anɨmbo hoeindɨwurɨmboemo,” mehu. ");
INSERT INTO agg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nɨmorehɨ ranai hoŋguambeahɨndɨ tüküyahi hehi mafefoehindɨ. Ŋgusüfoambe hepünahi hɨhamɨndarɨyei hehi yɨhɨmboyeihɨwambo moai nindou mamɨmbo amboanɨ mamɨ hoafɨ amboanɨ hoafɨyei. ");
INSERT INTO agg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sisas ai Sande siambeahɨhondü botɨfi-hayamboyu Maria horombo Sisas ai moaruwai nendɨ 7 hefoareandeimbɨ ahambo-so boatei tükümefiyu. ");
INSERT INTO agg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Nindou horombo Sisas babɨdɨmbo hoahoaŋgomo marundɨ ranai afɨndɨ hohoanɨmoyomondühɨ aranɨyomondühɨ nɨmarɨmondane, Maria ai ho hoafɨyopurühɨ yahoya, “Sisas ai yaŋgɨrɨ manüŋguwa ro hoeimarɨhinɨ,” meho. Ai hoafɨ ra hɨmborɨyomosɨ, ŋga moai anɨhondümbo-rundɨ. ");
INSERT INTO agg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Asükai süŋgunambo ahambo süŋgurɨnerɨ-rɨnandeimbɨ ai nafɨsüŋgu hafandane, Sisas ai ŋgorüpoanɨmbo fiyu haya hu ahafanɨmbo-so tükümefiyu. ");
INSERT INTO agg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Asu ai hafanɨ süŋgururü-rundeimbɨ bodɨmondambo ranɨ hoafɨ ra wataporɨmbomarɨnandɨ. Ŋga ai moai ahafandɨ hoafɨ ra anɨhondümbo-rundɨ. ");
INSERT INTO agg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bɨdɨfɨranambo hondü ahambo süŋgururü-rundeimbɨ 11 ahamumbo-so sesɨ sowasümondühɨ nɨmarɨmondanɨ tükümefiyu. Ranɨyo ahambo süŋgururü-rundeimbɨ ai ŋgusüfoambe tapɨhamɨyomondühɨ nɨmorehɨ nindowenihɨ ai yaŋgɨrɨ botɨmefiyua hoeirɨhorɨ hehi hoafɨmayei ra anɨhondümbofekoate-memonda ŋgɨnɨndɨ hoafɨmayupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Asu Sisas ai hoafɨyupurühɨ yahuya, “Se muŋguambo hɨfɨ ra hoahoaŋgomondühɨ muŋguambo nindoumbo aboedɨ hoafɨ ra wataporɨmbondundürɨ. ");
INSERT INTO agg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nindou düdi ai anɨhondümbore haya hundürayu ana, God ai ahambo aboedambo-ndirümbui. Ŋga nindou düdi ai anɨhondümbofe-koateayu ana, ai Godɨndɨ nindou-yafe hoafɨ hɨmborɨyohü yɨbobofe ranambe awarɨndɨhoembui. ");
INSERT INTO agg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Anɨhondümbo-rɨhindeimbɨ ranahei warɨsüŋgu God ai hepünɨfeimbɨ moatükunɨ randeambui. Ai wandɨ ndürɨnambo moaruwai nendɨ heboadɨhi asu ranɨpoanɨmbo hoafɨnambo hoafɨndei raraondɨhümboyei. ");
INSERT INTO agg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ai amoasɨrɨ warɨnambo kɨkɨhɨndɨhümündi asu nindou ai sɨmɨndei hehi yɨfɨyei rɨhündeimbɨ moatükunɨ asɨmɨndei amboanɨ ranai ŋgɨrɨ moaruwaimbondeandürɨ. Asu ai aŋgünümbɨ nindou-yeiwamɨ warɨ nandɨhinda ai asükai aboedɨndeimboyei,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Adükarɨ Sisas ai ahambo süŋgururü-rundeimbɨmbo wataporɨmborapurɨ mbura God ai sünambe serümündɨ hafu hɨnɨŋgɨrira ahandɨ warɨhondü waranɨ mbamarü. ");
INSERT INTO agg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Asu ahambo süŋgururü-rundeimbɨ ai muŋguambo hɨfɨ hoahoaŋgomondühɨ wataporɨmbomarundɨ. Asu Adükarɨ ai ai-babɨdɨmbo nüŋgumbo ahamundɨ hoafɨ ra ŋgɨnemɨndɨmbo-hünda hepünɨfeimbɨ moatükunɨ yare-marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiofirus, karɨhasɨ se adükarɨ nindou-anafɨ. Nindou afɨndɨ ai nɨne-moatükunɨ God ai yɨhoefɨ mbusümo ramareandɨ ranahambo dɨboadofe sürü papɨmbo mehomo. ");
INSERT INTO agg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sapo nindou dɨdemo weaŋgurühɨ hondü Sisasɨndɨ ratüpurɨ ahamundɨ hɨmboarɨnambo hoeiru mburumbo aboedɨ hoafɨ wataporɨmborümunɨ marundɨ ranahamboemo ai sürü papɨru marundɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ro wandɨhoarɨ muŋguambo moatükunɨ ndorɨhoeimbɨ weaŋgurühɨ tükümefeyo ra tüfoarɨhe fɨfɨrɨmarɨheandɨ. Ranɨmboane asu, Tiofirus, sɨhambo ranɨ-moatükunɨ tüküfe-tüküfe marandɨ ranahambo dɨboadofe sürü papɨmbo ro hohoanɨmoyahanɨ mayoa aboed-ane masahɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ro randɨheandanɨ anɨmbo asu se muŋguambo moatükunɨ sɨhambo yamundɨmarɨhunɨnɨ ra tüfoarowandühɨ fɨfɨrɨmbɨrowanda sahehea. ");
INSERT INTO agg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot ai Sudia-yafe bogorɨmbofi nüŋguambe nindou mamɨ ahandɨ ndürɨ Sekaraia ai Godɨmbo sesɨ sɨheferambo nindoumbofi manüŋgu, aiana Godɨmbo sesɨ sɨhoemo-rundeimbɨ Abaisa-yomondɨ sɨrambeahɨndɨyu. Ahandɨ nɨmorehɨndɨ ndürɨ ra Erisabetɨyo ai-amboanɨ Aronɨndɨ sɨrambeahɨndɨyo. ");
INSERT INTO agg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yimbu ai Godɨndɨ hɨmboahü mbumundɨ hamɨndɨ nɨmbafembo Adükarɨndɨ hoafɨ hɨmborɨyafeihɨ süŋgurɨne marɨnandɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Erisabet ai purüsɨyo hayamboyo ranɨmbo ai Sekaraia-dɨbo nɨmorɨ kefekoate nɨmbafembo boagɨrɨmayafe. ");
INSERT INTO agg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mamɨ sɨmboanɨ Sekaraiandɨ sɨrɨhündɨ ratüpurɨmbo si tüküfeyoambe sesɨ sɨhefe ra Godɨndɨ hɨmboahü ramareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sapo Godɨmbo sesɨ sɨheferambo dɨbonɨmbo ranɨ hohoanɨmo süŋgumbo ahambo dɨbonɨmemondowa Godɨmbo sɨhefembo fondɨwamɨ fɨsɨŋarümbɨ moatükunɨ mandɨfembo Adükarɨndɨ worɨ ranambe kefuai mahüfu. ");
INSERT INTO agg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ranɨyo fɨsɨŋarümbɨ moatükunɨ-mayo ranai hai tɨkɨrandühɨ horoambe nɨmorehɨ nindowenihɨ afɨndɨ ranai weindanɨ nɨmboeimbo Godɨmbo dɨdɨbafɨyeihɨ burɨmayei. ");
INSERT INTO agg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ranɨyo asu refeyoambe Adükarɨndɨ sünambeahɨndɨ nendɨ ranai ahambo-so tüküfi fɨsɨŋarümbɨ moatükunɨ mandɨfe fondɨ warɨhondanɨ manüŋgu. ");
INSERT INTO agg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ranɨyu Sekaraia ai hoeirirɨ haya hepünɨfi yɨhɨmbo sɨsɨrɨmefiyu. ");
INSERT INTO agg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ŋga asu sünambeahɨndɨ nendɨ-mayu ranai hoafɨyundowohü yahuya, “Sekaraia, se yɨhɨmbondamboyafɨ! God ai sɨhafɨ dɨdɨbafɨfe hoafɨ hɨmborɨyumboani. Asu sɨhafɨ nɨmorehɨ Erisabet ai sɨhafɨ nɨmorɨ nderɨmɨndɨmboe. Rananɨmbo se ahambo ndürɨ Son kaboadɨworɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nɨmorɨ ranai tükündɨfiyuanɨ se afɨndɨ hamɨndɨ hɨhɨfɨ-hɨhɨfɨndamboyafɨ asu nindou amurɨ ranai-amboanɨ afɨndɨ hɨhɨfɨ-hɨhɨfɨndeimboyei. ");
INSERT INTO agg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nindou ranai ana Adükarɨndɨ hɨmboahü ndüreimbɨ hondündümbui. Aiana yowanɨ wain asu ŋgɨnɨndɨ hamɨndɨ bia ra ndümündümbui. Ahambo hondɨ ai wakemɨndɨmbo yaŋgɨrɨyoambe Yifiafɨ Aboedɨ ranai ahandɨ fiambe yadɨdündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Rananɨmbo ai Israerɨhündɨ nindou afɨndɨ ranaheimbo God ahei Adükarɨ-mayu ranahambo sowana hɨhɨndeirɨ ndemündündürɨ ŋgumbui. ");
INSERT INTO agg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Aiana Godɨndɨ hoafɨ hoafɨyu-randeimbɨ, ahandɨ ndürɨ Eraisa ramefiyu nou, yahurai ŋgɨnɨndɨ ndemündü haya Adükarɨmbohünda ai boatei horombondüfi ŋgumbui. Aiana afɨndɨ mam-anemo asu nɨmor-anemo asükai mamühɨndeapura aboedɨ-aboedɨndafu, nindou Godɨndɨ hoafɨ hɨmborɨkoate-yei-rɨhündeimbɨ aheimbo hɨhɨrɨndeiranɨ mbumundɨ hohoanɨmo süŋgundɨhi, asu anɨhondümbo-rɨhindeimbɨ Adükarɨ ai kosɨmbo-mayu ranɨmbo dɨdɨboadondearümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraia ai sünambeahɨndɨ nendɨ-mayumbo sɨmborɨ hoafɨyundühɨ yahuya, “Asu ro nüŋgundɨhe fɨfɨrɨmandɨhe ranɨ-moatükunɨ ra anɨhondayo amboanɨ? Roana ndeara boagɨrɨyamboanahɨ asu wandɨ nɨmorehɨ amboanɨ boagɨrɨyomboane,” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sünambeahɨndɨ nendɨ ai sɨmborɨ hoafɨyundühɨ yahuya, “Ro Gebrier-anahɨ nda. Roana Godɨndɨ ŋgusümboaranɨ-anahɨ nɨmboa arɨhandɨ. Aiyu wambo koamarɨhendɨra sɨhambo aboedɨ hoafɨ hoafɨmbo makosahɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Se moai wandɨ hoafɨ ra anɨhondümbo-rowandɨ ranɨmbo-hünda yafadühamɨ tapɨ nɨmbafɨ ŋgafɨmbo ranɨ-moatükunɨ ra tükündɨfemboe. Nɨnɨ-sɨmboanɨyo God ai dɨbonɨmayu ranɨ-moatükunɨ ra anɨhondümbo tükündɨfemboe,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ranɨ-moatükunɨ ranai refeyoambe nindou bɨdɨfɨrɨ ai Sekaraiambo weindanɨ nɨmboeimbo hɨmboyahündowohü hohoanɨmoyeihɨya, “Ai nɨmboe Godɨndɨ worambe gedühɨ anüŋgu?” masei. ");
INSERT INTO agg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ai weindanɨ tüküfi huhü aheimbo moai hoafɨ karearü, ŋga wanɨ. Ranɨyei asu ai rarɨhi hohoanɨmoyeihɨya awi Sekaraia ai nɨne awambo moatükunɨ ahandɨ hɨmboahümbo Godɨndɨ worɨ ranambe hoeire hayamboyu rawefiyu masei. Ai aheimbo nɨnɨ hoafɨ akɨdou hoafɨyokoate-yundürühɨyu asu ai moanɨ ahandɨ warɨnambo yaŋgɨrɨ sɨsamɨra wakɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Godɨndɨ worambe Sekaraia ai sapo nɨne-moatükunɨ refe ratüpurɨmbo-mayu ratüpurɨ ra moendɨre hayamboyu asu ai ŋgoafɨna mahu. ");
INSERT INTO agg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ranɨ-moatükunɨ ranai refe hayamboyo-ane ranambe ahandɨ nɨmorehɨ Erisabet ranai warandühumbɨyo haya asu ai moai hondahüfeimbɨ amoamo ranambe worɨ hɨnɨŋgɨre ho, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ai yare hoafɨyowohü yahoya, “Haponda ndeara bɨdɨfɨranɨ hondü Adükarɨ ai wambo hɨpoamboreandɨrɨhü ai wandɨ amoanɨŋgɨ nindou hɨmboahü meŋgoro ra raguanamboareandɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Erisabet ai 6 amoamombo nɨŋgoambe God ai sünambeahɨndɨ nendɨ ahandɨ ndürɨ Gebrier ranahambo Gariri hɨfambe ŋgoafɨ ahandɨ ndürɨ Nasaret ranɨnambo koamarɨherü. ");
INSERT INTO agg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ai mahu ra nɨmorehɨ sapo nindowenihɨ ahandɨ ndürɨ Sosepɨmbo momo kümarɨhindɨ ranahambo hoafɨ semündü hayamboyu. Sosep ranai ana adükarɨ bogorɨ Defitɨndɨ amoao-yomondɨ sɨrambeahɨndɨyu. Ŋga asu nɨmorehɨ-mayo ranahandɨ ndürɨ ana Mariayo. ");
INSERT INTO agg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Sünambeahɨndɨ nendɨ-mayu ranai nɨmorehɨ ranahambo-so tüküfi hoafɨyundühɨ yahuya, “Karɨhasɨ. Adükarɨ ai se-dɨbo nüŋgumbo sɨhambo aboedɨ-aboedɨmareanɨnɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ranɨyo asu Maria ai sünambeahɨndɨ nendandɨ-mayo hoafɨ ra hɨmborɨyo haya asu ai afɨndɨ hohoanɨmoyowohü nɨne-moatükunɨ hoafɨ yahurai ra yahohaya hoafɨmayo. ");
INSERT INTO agg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sünambeahɨndɨ nendɨ-mayu ranai ahambo hoafɨyundowohü yahuya, “Maria, se ranɨmbo yɨhɨmbondamboyafɨ, ŋga God ai sɨhambo ŋgusüfoambe aboedɨ fufurɨfoareanɨnɨmboani. ");
INSERT INTO agg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ŋga rananɨmbo se warandühumbündafɨ hawa nindowenihɨ nɨmorɨ ndowarɨndɨfɨ mbunda asu se ahandɨ ndürɨ Sisas kaboadɨworɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Aiana adükarɨ hondünduanɨ ahambo moanɨ Nɨmoamo Hamɨndɨ Hondündɨ nɨmorani mbɨseimboyei. Rananɨmbo asu Adükarɨ God ranai ahambo bogorɨmbondirɨmbui sapo ahandɨ amoao Defit ramefiyu süŋgu. ");
INSERT INTO agg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Rananɨmbo ai koadürümbo-koadürümbo Sekopɨndɨ ahuirɨ mamɨyei bogorɨmbondɨfi nüŋguhü, ahandɨ ŋgɨnɨndɨ hɨfandarandɨ ranai ŋgɨrɨ moendɨndo,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria ai sünambeahɨndɨ nendɨ-mayu ranahambo hoafɨyondowohü yahoya, “I, ranɨ-moatükunɨ ra nüŋgunde yahurai tükümandɨfea? Asu roana nindowenihɨkoate-anahɨsɨ!” mehondowamboyu. ");
INSERT INTO agg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Asu sɨmborɨ ai ahambo hoafɨyundühɨ yahuya, “Yifiafɨ Aboedɨ ranai sɨhafɨ fiambe tükündɨfenɨnɨhü anɨmbo asu Godɨndɨ ŋgɨnɨndɨ ranai sɨhambo gabudɨboadeanɨnɨmboe. Ranɨmbo-hündambo anɨmbo asu sürühoeimbɨ nɨmorɨ ranahambo Godɨndɨ Nɨmor-ani mbɨseimboyei. ");
INSERT INTO agg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Awi se hɨmborɨyafɨ, sɨhafɨ mbu Erisabet amboanɨ ŋgɨrɨ nɨmorɨ wakɨndamɨndo masei boagɨrɨmayoa, ŋga haponda warandühumbüyo haya 6 amoamo homboane. ");
INSERT INTO agg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ŋgɨrɨ God ai nɨnɨ-moatükunɨ refekoate-ndu,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Asu Maria ai sɨmborɨ hoafɨyowohü yahoya, “Ro Adükarɨndɨ ratüpurɨya-rɨhandeimb-anahɨ, ŋga se hoafɨmayafɨ süŋgu ai moanɨ rambɨreandamboane,” mehondowamboyu asu sünambeahɨndɨ nendɨ ranai ndamefiyu. ");
INSERT INTO agg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ranɨ-sɨmboanɨ Maria ai botɨfe naporamɨndɨ haya nɨmai ŋgoafɨ mamɨ Sudia hɨfɨ wafuambe anaŋgo ranɨnambo mahafo. ");
INSERT INTO agg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ranɨyo asu ai Sekaraiandɨ worambe ho haya farɨfe hafo Erisabetɨmbo hɨhɨfɨmarandɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Erisabet ai Maria hɨhɨfɨmarandɨ ra hɨmborɨyo-ambe asu mare ranambe nɨmorɨ ai ahandɨ furambe saŋgurɨmbo botɨfi piyu marandɨ. Ranɨyo asu Erisabetɨndɨ fiambe Yifiafɨ Aboedɨ ranai tüküfeyowohüyo, ai puküna hoafɨ karɨhoehü hoafɨyowohü yahoya, “God ai sɨhambo aboedɨ-aboedɨmareanɨnɨ muŋguambo nɨmorehɨmbo refendürɨkoate-mayu nou. God ai nɨmorɨ ranahambo amboanɨ aboedɨ-aboedɨrirɨmboani! ");
INSERT INTO agg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Awi adükarɨ moatükunɨ wambo tükümefeyondɨrɨ. Ŋga wandɨ Adükarɨndɨ hondɨ ai wambo hoeifendɨrɨmbo tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Awi se hɨmborɨyafɨ, asu ro sɨhafɨ-mayo hɨhɨfɨ hoafɨ ra kefoendühɨ hɨmborɨhamɨndɨhühɨyahɨ asu nɨmorɨ wandɨ furambe asaŋguru ranai hɨhɨfɨ-hɨhɨfɨyuhü hohorɨpɨ-hohorɨpɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Adükarɨndɨ hoafɨ ra se anɨhondümbo-ndowandühɨ ana, asu se hɨhɨfɨ-hɨhɨfɨndafɨ sapo ranɨ-moatükunɨ ranai anɨhondü sɨhambo tükündɨfenɨnɨmboe,” mehondo. ");
INSERT INTO agg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria ai yahoya, “Ro wandɨ ŋgusüfoambe ra Adükarɨmbo adükar-ani sa hohoanɨmoayahɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Asu wandɨ hohoanɨmoambe ranai Godɨmboya wandɨ Aboedambo-reandɨrɨ-randeimbani yaho hɨhɨfɨ-hɨhɨfayo. ");
INSERT INTO agg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Ro ahandɨ ratüpurɨya-rɨhandeimbɨya hehea moanɨndɨ nɨmorehɨyahɨ, ŋga asu ai wambo hohoanɨmoyuhü ndondomareandɨrɨ. Hapondanambe peyo haya süŋgunambo gogu aho ranambe amboanɨ nindou ai wambo hɨhɨfɨ-hɨhɨfümb-anafɨ mbɨseimboyei, nɨmboe sapo Adükarɨ Hamɨndɨ God ai wambo adükarɨ moatükunɨ ramareandɨ ranɨmbo-hünda. Ahandɨ ndürɨ ra moanɨ sürühoeimbane. ");
INSERT INTO agg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ŋga asu ahandɨ hɨpoambofe hohoanɨmo ranana nindou dɨdɨyei ahambo ahɨnarɨhorɨ ranaheimbo-so boagɨrɨ tühünɨmbo rande yagodɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ai ahandɨ warɨ ŋgɨnɨndɨ ranambo adükarɨ ratüpurɨ ratüpurɨmayu. Ai nindou afɨndɨ-afɨndɨyeimbɨ ranaheimbo ahei hohoanɨmo nɨne moaruwai amarondürɨ ranɨ kameihɨ bukürümafoareandürɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ai bogorɨ nindou-memo ahamundɨ nɨmarɨfondɨ wamɨnɨndɨ hɨfɨnɨ hemoafoareapurɨ. Ranɨyo asu nindou ndürɨkoate-memo ranahamumbo nɨmoamo sepurɨmündü botɨmareapurɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","God ai nindou wembomboyeimbɨ ranaheimbo aboedɨ moatükunɨ yimbureandürɨ asu nindou napombü-mayei ranaheimbo nɨnɨ akɨdou-amboanɨ warambefendürɨkoate koamarɨhendürɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ai ahandɨ ratüpurɨyei-rɨhündeimbɨ Israer ranaheimbo mafarɨhendürɨ ra sapo horombo hoafɨyu masɨhendɨ ranɨ süŋgumboyu hɨpoambomareandürɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ai Abraham asu ahandɨ ahuirɨ mamɨ ranaheimbo hoafɨyondürɨmbo koadürümbo-koadürümbo ra hohoanɨmoyu masɨhendɨ ranɨ süŋgumboyu ramareandɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ai ŋgɨmɨ amoamo Erisabetɨ-dɨbo nɨŋgo hɨmboyo asu ai ŋgoafɨna asükaiyo hɨhɨrɨfe maho. ");
INSERT INTO agg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Erisabet ai ahandɨ nɨmorɨ semɨndɨmbo si tükümefeyondowamboyo asu ranɨ-sɨmboanɨ ai nindowenihɨ nɨmorɨ maserɨmɨndo. ");
INSERT INTO agg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nindou bɨdɨfɨrɨ ai-babɨdɨmbo worɨ yimburɨhindeimbɨ ranɨyei asu ahandɨ wahorɨ mamɨyomo muŋguambo Adükarɨ ai nɨne aboedɨ ranɨ-poanɨmbo moatükunɨ ahambo ramareandɨ ra hɨmborɨyeihehi ai Erisabetɨmbo ŋgusüfoambe hɨhɨfɨ-hɨhɨfɨmehündo. ");
INSERT INTO agg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nɨmorɨ ranai mamɨ wikɨyu hayamboyuwane, asu ai ahandɨ fihoearɨ kefetɨrɨhefe mburɨmbo afɨndandɨ ndürɨ süŋgu Sekaraiambofi kafoefimboani sei hehi mahei. ");
INSERT INTO agg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ŋga asu ahandɨ hondɨ ai hoafɨyowohü yahoya, “Yowanɨ! Ahandɨ ndürɨ ana Son anɨmbombiyu-wamboane,” mehondürɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ranɨyei asu ai ahambo hoafɨyeihɨ seiya, “Asu seana sɨhafɨ sɨrambe moai yahurai ndürɨ ana yaŋgoro,” masahündo. ");
INSERT INTO agg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ranɨyei asu ai ahandɨ afɨndambo warɨnambo yaŋgɨrɨ hoafɨyeihɨ ndürɨ nɨnɨ nɨmorɨ ranahambo kamaboadɨhorɨ masahündo. ");
INSERT INTO agg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraia ai sürü papɨmbo moatükunɨfihɨ ndürɨ pareandühɨ yahuya, “Ahandɨ ndürɨ ana Son-ani,” mehuamboyei. Asu moanɨ nɨmboe yahurai muŋguambo ai hepünɨmehindɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Refeyowohüyo asu moanɨ ranambe hamɨndɨ Sekaraia ai asükaiyu hoafɨ ra wataporɨmbo-randühɨya Godɨmbo aboed-ani yahu hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ranɨyo asu nindou ŋgoafɨ akɨmɨ amarei ranai yɨhɨmbo sɨsɨreandürühɨyo, asu ranɨ-moatükunɨ ramefeyo ranɨ hoafɨ ranai Sudia hɨfɨ wafuambe ŋgoafɨ anaŋgo ranɨ-amboanɨ ho-ho marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Muŋguambo nindou ai ranɨ hoafɨ ranahambo hɨmborɨyei hehi hohoanɨmo kɨkɨrɨhündühɨ düduyahindühɨ seiya, “Nɨmorɨ ra nɨnɨ moatükunɨ nahurai nɨmorɨ tükümandɨfia?” masei. Ai rarɨhi fɨfɨrɨhindɨ Adükarɨndɨ ŋgɨnɨndɨ ranai ai-dɨbo anɨŋgo ho. ");
INSERT INTO agg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sonɨndɨ afɨndɨ Sekaraiandɨ fiambe Yifiafɨ Aboedɨ ranai farɨfehüyo asu ai Godɨndɨ hoafɨ ra yare hoafɨyuhɨ yahuya, ");
INSERT INTO agg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Awi sɨhɨrɨ Israerɨ-yafe God Adükarɨ ranahambo aboed-ani mbɨsefomboane. Ai ahandɨ nɨmorehɨ nindowenihɨ ranaheimbo farɨhefendürühɨ aheimbo aboedambofe-ndürɨmbohünda makusu-ani. ");
INSERT INTO agg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ahandɨ ratüpurɨyu-randeimbɨ amoao Defitɨndɨ sɨrambeahɨndɨyu ai sapo nindou ŋgɨnɨndɨ sɨhefɨmbo aboedambofe-munɨmbo-mayu ranahambo dɨbonɨmayundo. ");
INSERT INTO agg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ai ahandɨ sürühoeimbɨ hoafɨ hoafɨyomo-rundeimbɨ-yomondɨ süŋgu horombo hoafɨyu masɨhendɨ hoafɨ ra süŋgumareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ranɨ hoafɨ ra yahurai yare hoafɨyuhɨ yahuya ai nindou sɨhefɨmbo hürütümb-anei. Asu yɨboarukoarɨhimun-anei ranahei ŋgɨnɨndɨ warambeahɨndɨ aboeda hündɨhemunümbui yahu hoafɨyu masɨhendɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ai sɨhefɨ amoao mamɨmbo hɨpoambondeandürümbui. Asu ahandɨ hoafɨ hoafɨyu fɨramündü masɨhendɨ ranahambo hohoanɨmondümbui. ");
INSERT INTO agg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Sɨhefɨ amoao Abrahamɨmbo ai dabarɨfihɨ hoafɨyu masɨhendɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ai sɨhefɨ hürütümbɨyei warambeahɨndɨ aboedambo hürühefemunühɨ, asu ai sɨhefɨmbo ahandɨ ratüpurɨ yɨhɨmbo sɨsɨrɨfekoate ratüpurɨmbo ra süŋgurɨhi yahombo hoafɨyu masɨhendɨ. ");
INSERT INTO agg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Asu rananɨmbo sɨhɨrɨ yaŋgɨrɨ nɨmboefambe amboanɨ, sɨhɨrɨ moanɨ sürühehundeimbɨndefɨ mbundɨhu, aboedɨ mbumundɨ hamɨndɨ ahandɨ hɨmboahü muŋguambo si aho ra nɨmboefomboane. ");
INSERT INTO agg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Haponda, wandɨ nɨmorɨ, sɨhambo ana Nɨmoamo Hamɨndɨ Hondündɨ hoafɨ hoafɨyafɨ-randeimb-anafɨ mbɨseimboyei. Seana Adükarɨmbohünda horombondafo ŋgafühɨ ahambohünda nafɨ dɨdɨboadondowandühɨ ahandɨ nendɨ ranaheimbo ahei moaruwai hohoanɨmo ra amboawi yahohü moaruwai hohoanɨmo-ambeahɨndɨ aboedambofe-ndürɨmboani yahombohünda. ");
INSERT INTO agg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God ahandɨ hɨpoambofe hohoanɨmonambo sɨmborɨ si nahurai koaboadeanda kodɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Rananɨmbo nindou yɨfɨmbo yɨhɨmboyeihɨ nɨmbɨ nɨmaroanɨ anɨmboei aheimbo si boakɨboadeandürɨmboe. Asu rananɨmbo sɨhefɨmbo aboedɨ nɨmarɨmbo nafɨ nafuindamuna ŋgemboyefɨ,” Sekaraia ra mehu. ");
INSERT INTO agg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Süŋgunambo Son ai adükarɨyuhümbo asu Yifiafɨ Aboedɨ ranai-amboanɨ ahandɨ fiambe ŋgɨnɨndɨ tükümefeyo. Ai hu nɨmɨ wohɨ furɨkoate-reandühɨ nüŋgu humbo Israer so boatei weindahɨ tükümefiyu. ");
INSERT INTO agg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ranɨ-sɨmboanɨ Romɨ-yafe adükarɨ bogorɨ Sisar Ogastas ai muŋguambo nindou ranɨhündambo ai ndürɨ semɨndɨmbo hoafɨ ra hoafɨyu masɨhendɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kwirinius ai Siria-yafe bogorɨmbofi nüŋguambeyo muŋguambo nindou ranaheimbo ndürɨ semɨndɨmbo ra boatei tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ranɨyei asu muŋguambo nindou ranai mamamɨ ahandɨhoarɨ ahandɨ ndürɨ semɨndɨmbohünda ahandɨ ŋgoafɨ hondü ranɨnambo hei marɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ranɨyu asu Sosep ai-amboanɨ Gariri hɨfambe Nasaret ŋgoafɨhündɨ botɨfi haya adükarɨ bogorɨ Defitɨmbo sahorɨmɨndeimbɨ ŋgoafɨ Betrehem Sudia hɨfambe anaŋgo ranɨnambo mahu. Sapo ai Defitɨndɨ sɨrambeahɨnd-ani. ");
INSERT INTO agg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ranɨyo asu Maria ranahambo Sosepɨmbo semündümbo momo kümarɨhindɨ ranɨ-dɨbo ndürɨ semɨndɨmbo mahu. Ranɨyo asu Maria ranai warandühumbɨyo. ");
INSERT INTO agg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ranɨyo asu ai Betrehem ŋgoafɨhü nɨmbafeambe Maria ai ahandɨ nɨmorɨ wakemɨndɨmbo si ranai ndeara bɨdɨfɨranɨ tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ai ahandɨ amoŋgo nɨmorɨ ra wakɨrɨmɨndɨ haya nɨmorɨ-yafe hoearɨnambo hɨmonderɨ mbura burmakauyei sesɨ hɨpɨrambe mafoarerɨ. Sapo nindou aporambo worɨ ranai nindou fondɨ muŋgu sɨmoŋgorɨmayeiambo wambo. ");
INSERT INTO agg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ranɨ hɨfɨhü sipsip hɨfandɨru-rundeimbɨ ai ahamundɨ sipsip fufurundümo homo moanambühɨ hɨfandɨrundürühɨ mamɨ nɨmbɨ-memo. ");
INSERT INTO agg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Adükarɨndɨ sünambeahɨndɨ nendɨ ranai ahamumbo-so tüküfihüyu asu Adükarɨndɨ hɨmboamupui-randeimbɨ si ranai ahamumbo boakɨmafoareapurɨ. Ranɨyomo asu ai ranɨ-moatükunɨ ranahambo yɨhɨmbo sɨsɨrɨmefundɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ŋga asu sünambeahɨndɨ nendɨ ranai ahamumbo hoafɨyupurühɨ yahuya, “Se ranahambo yɨhɨmbondɨmboemo. Ro ndanɨmboahɨ nda sɨhamumbo aboedɨ hoafɨ sahamɨndɨmboanahɨ. Ranɨ-moatükunɨ hoafɨ rananɨmbo adükarɨ hɨhɨfɨ-hɨhɨfɨ ndemɨndɨ muŋguambo nindou ranaheimbo tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ndanɨ-sɨmboanɨ Defitɨndɨ ŋgoafɨ Betrehem ranɨhü nindou sapo sɨheimbo aboedambofe-ndürɨmbo-mayu ranahambo hondɨ ai wakɨmarɨmɨndo. Ai nindou God dɨbonɨmeindo Krais Adükarɨ ranani. ");
INSERT INTO agg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ŋga asu rananɨmbo se ahambo anɨhondümbo randu yahurai fɨfɨrɨndüwurɨ. Se hoeindüwuranɨ nɨmorɨ ranai hoearɨnambo hɨmondɨhefimbɨ burmakau-yei sesɨ hɨpɨrambe foerümbui,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ranɨyo asu hoafɨ nɨŋgoambe sünambeahɨndɨ ami-yomondɨ nendɨ ranai tüküyafu sapo sünambeahɨndɨ nendɨ ŋgorü-mayu ranɨ-babɨdɨmbo nɨŋgomombo Godɨmbo aboed-ani yahomo hoafɨyomondühɨ yahomoya, ");
INSERT INTO agg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God nɨmoamo hamɨndɨ hondü anüŋgu ranahambo aboed-ani mbɨseiamboane. Nɨmorehɨ nindowenihɨ hɨfɨ ndanɨhü anɨmboei ranaheimbo ŋgusüfo afurɨfimbɨ hohoanɨmo segodürɨmboane. God ai aheimbo ŋgusüfo pareandürühɨ siyaofindürühani,” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sünambeahɨndɨ nendɨ ranai ahamumbo sowahɨndɨ botɨyafu sünambe hafomondane, sipsip hɨfandɨru-rundeimbɨ nindou-memo ranai ahamundɨhoarɨ bogo hoafɨ fɨründümondühɨ yahomoya, “Awi sɨhɨrɨ Betrehem ŋgoafɨnambo ŋgefɨ sapo ranɨ-moatükunɨ tükümefeyo ra hoeindɨhu Adükarɨ ai hoafɨmemunɨ süŋgu,” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ranɨyomo asu ai nɨmai ranɨnambo homo Maria Sosepɨmbo-so tüküyafu mburu nɨmorɨ burmakauyei sesɨ hɨpɨrambe mafoeru ra hoeimarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sipsip hɨfandɨru-rundeimbɨ nindou-memo ranai ahafembo hoeirupɨrɨ mburu asu ai nɨne-hoafɨ nɨmorɨ ranahambo sünambeahɨndɨ nendɨ ai hoafɨmemo hoafɨ ra hoafɨmemopɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Muŋguambo nindou ai ranɨ hoafɨ ra hɨmborɨyei hehi hepünahi afɨndɨ hohoanɨmomayei. ");
INSERT INTO agg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ŋga asu Maria ai ranɨ hoafɨ muŋgu ra ŋgusüfoambe hohoanɨmoyo marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ranɨyomo asu sipsip hɨfandɨru-rundeimbɨ nindou ranai hɨhɨrɨyafu homondühɨ Godɨmbo adükar-ani asu ndürɨmb-ani yahomo houmbo mahomo. Ai sapo ahamumbo sünambeahɨndɨ nendɨ hoafɨmemopurɨ ranɨ süŋgumbo ranɨ-moatükunɨ ranahambo hɨmborɨyomo hoeiru houmbo wambo. ");
INSERT INTO agg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","7 Si ranai hoane ranɨ wagabe nɨmorɨ ranahambo hoearɨ kefetɨrɨhefihɨ ndürɨ Sisas kafoefimbo si ranai tükümefeyo. Sisas ra horombo hondandɨ furambe saŋgorɨkoate-yuambe ranɨ-sɨmboanɨ sünambeahɨndɨ nendɨ ai kamafoarir-ane. ");
INSERT INTO agg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mosesɨndɨ ahɨnümbɨ hohoanɨmo meŋgoro ranai hoafɨmayo süŋgu Maria Sosep ai aboedɨ tüküfe nɨmarɨmbomefe ranɨ si ai tükümefeyopɨrɨ. Ranɨ-yafe asu ai nɨmorɨ ra sowarɨndɨfe hena Adükarɨndɨ hɨmboahü hɨnɨŋgɨfimbo Serusarem ŋgoafɨna mahafe. ");
INSERT INTO agg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sapo ranɨ-moatükunɨ refembo-mayo ra Adükarɨndɨ ahɨnümbɨ hohoanɨmoambe yahurai sürü pare yaŋgorowohü yahoya, ‘Muŋguambo nindowenihɨ nɨmorɨ furɨ sɨmborɨhündɨ ranana Godɨndɨfihɨ yaŋgɨrɨ paiarɨmboane,’ meho. ");
INSERT INTO agg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Asu ai hafe yimbu wupufombefeyo asu dɨbɨ weimbefeyo ranamboanɨ Godɨmbohünda hɨfokoarɨne masɨheneandɨ sapo Adükarɨndɨ ahɨnümbɨ ra-meho süŋgumbo. ");
INSERT INTO agg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ranɨ-sɨmboanɨ nindou mamɨ ahandɨ ndürɨ Simion ranai Serusarem ŋgoafɨ ranɨhü manüŋgu. Nindou ranai ana ai aboedɨ hamɨndɨyu haya Godɨmbo yaŋgɨrɨ hohoanɨmo parireimbɨ nindouyuhü Israer nindou ranai aboedambo-mbeahindɨ yahu haya hɨmboyumbüyu manüŋgu. Yifiafɨ Aboedɨ ranai ahandɨ fiambe nɨmaroweimbɨyu. ");
INSERT INTO agg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ranɨyo asu Yifiafɨ Aboedɨ ai Simionɨmbo hoafɨ weindahɨreandowohü yahoya, “Ŋgɨrɨ se nɨmai yɨfɨndafɨ, ŋga se nɨmbafɨ-nɨmbafɨmbo Adükarɨ ai Nindou koamarɨheirɨ ra hoeindɨworɨ hawambo anɨmbo ndamboyafɨ,” meho süŋgu. ");
INSERT INTO agg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yifiafɨ Aboedɨ ai Simionɨmbo hohoanɨmo botɨmareramboyu asu ai Godɨndɨ worɨna mahüfu. Sapo ahɨnümbɨ hohoanɨmo meŋgoro ranɨ-süŋgumbo ahambo refimboyafe hondafɨndɨ ai nɨmorɨ Sisas ranahambo sowarɨndɨfe Godɨndɨ worɨ ranambe mahüfe. ");
INSERT INTO agg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ranɨyo asu Simion ai nɨmorɨ ranahambo ahandɨ warambe wakɨrümündɨ Godɨmbo hɨhɨfɨrürühɨ hoafɨyuhɨ yahundoya, ");
INSERT INTO agg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Adükarɨ sapo horombo wambo se hoafɨmayafɨ ra-süŋgumbo sɨhafɨ ratüpurɨya rɨhandeimbɨ nindou nda moanɨ rando hɨnɨŋgɨndowandɨra ro ŋgusüfo afurɨndɨhe kündɨhe hehea yɨfɨndamboane. ");
INSERT INTO agg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ro wandɨ hɨmboarɨnambo se yɨhoefombo aboedambofe-munɨmboayafɨ ra hoeirɨheamboanahɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ranɨ-moatükunɨ ra se sɨhafɨ nɨmorehɨ nindowenihɨ ranahei hɨmboahü dɨdɨboadorandɨfɨ masɨhoefane. ");
INSERT INTO agg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ranɨ-moatükunɨ ranana weindahɨfembo si-ane, ŋga sɨhafɨ hohoanɨmo süŋgu ranɨ-moatükunɨ ranai anɨmbo Suda-yafe ndɨfo mayei ranaheimbo si dagadürɨmboe. Asu nɨmorehɨ nindowenihɨ sɨhafɨ Israerɨhündɨ-mayei ranaheimbo ndürɨ adükarümbɨ nɨŋgo hohoanɨmo ra tükündɨfendürɨmboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ranɨ-yafe asu nɨmorɨndɨ hondafɨndɨ ranai nɨne-moatükunɨ hoafɨ Simion ai wataporɨmbo-marandɨ ranɨmbo hɨmborɨyafe hena hepünɨmefɨneandɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Ranɨyu asu Simion ai aheimbo aboedɨ-aboedɨreandürühɨ Maria nɨmorɨndɨ hondɨ-mayo ranahambo hoafɨyundowohü yahuya, “Nɨmorɨ ndanana God ai ahandɨhoarɨ dɨbonɨmayuani Israerɨhündɨ bɨdɨfɨrɨ ahambo anɨhondümbofekoate-ayei ranai moaruwaimbo-ndahimboyei asu anɨhondümbo-arɨhorɨ ai aboedambondahimboyei. Ai Godɨndɨ yifirɨ nafuindümbui asu nɨmorehɨ nindowenihɨ afɨndɨ ranai ahandɨ hoafɨ hɨmborɨkoate-ndeihɨ, asu ahei nɨne hohoanɨmo dɨbo ahei ŋgusüfoambe mamarondürɨ ra weindahɨndɨhimboyei. Rananɨmbo asu sɨhambo-amboa afɨndɨ hohoanɨmo ranai pisao nahurai sɨhambo ŋgusüfo ra nandeamboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ranɨhü nɨmorehɨ kai mamɨ ahandɨ ndürɨ Ana Godɨndɨ hoafɨ hoafɨyo-randeimbɨyo manɨŋgo. Ai Fanuerɨndɨ nɨmorɨyo haya asu Asandɨ sɨrambeahɨndɨ-mayo. Nɨmorehɨ ranai 7 hɨmbanɨyo nindowenihühɨmefeyo ŋga asu haponda 84 hɨmbanɨmbo boagɨrɨyomboane. Ai moai Godɨndɨ worɨ ranahambo hɨnɨŋgɨre tifoendɨ, ŋga ai moanɨ nɨmbɨ nɨmbɨsi aho ra Godɨmbo hohoanɨmoyowohɨ wembopo dɨdɨbafɨfe marandane. ");
INSERT INTO agg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Moanɨ ranɨ-sɨmboanɨ hamɨndɨ ranambe nɨmorehɨ ranai akɨmɨ tüküfe nɨŋgo Godɨmbo hɨfɨhɨmarɨrɨ. Asu ai nindou dɨdɨyei sapo Serusarem ŋgoafɨ God ai aboedambo-fembo-mayu ranahambo hɨmbomayei ranaheimbo nɨmorɨ-mayu ranahambo wataporɨmbo-randürühɨ hoafɨmendürɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sosep Maria ai sapo nɨne-moatükunɨ ratüpurɨ Adükarɨndɨ ahɨnümbɨ hohoanɨmo süŋgumbo refembo ratüpurɨmayo ra rarɨne mburɨna, asu ai ahafe ŋgoafɨ Nasaret Gariri hɨfambe anaŋgo ranɨnambo hɨhɨrɨyafɨne mahafe. ");
INSERT INTO agg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nɨmorɨ ranai adükarɨyuhü ŋgɨnɨmarɨhoayu. Ranɨyu asu ai ndore fɨfɨre haya God ai ahambo ŋgusüfoambe aboedɨ-aboedɨmarirɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Muŋguambo hɨmbanɨ ra Sisasɨndɨ hondafɨndɨ ai Serusaremɨnambo adükarɨ si ahandɨ ndürɨ Pasofa tüküfe arandɨ ranɨ hoeifembo hafe marɨnandɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Asu Sisas ai 12 hɨmbanɨmbo nüŋgu hayamboyuane, sapo ranɨ moatükunɨ si koadürü refemarandɨ süŋgumbo ai hoeifembo mahafe. ");
INSERT INTO agg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Adükarɨ si ranai hümaramɨndo-wamboyafe asu ai ŋgoafɨna hɨhɨrɨyafɨne hafe, ŋga Sisas hoarɨfɨ-mayu ranai Serusarem ŋgoafɨhü nɨmaru. Ŋga asu ahandɨ hondafɨndɨ ai nɨmarɨmbo-mayu ra moai fɨfɨrɨneandɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ai ndanananɨya nindou amurɨ bɨdɨfɨrɨ ranɨ-babɨdɨmbo mbahumbai safe hena asu ai ranɨ si peyo haya maho ra nafɨ süŋgu hafehü ŋgunindambürɨ asu mamɨsɨrɨ-mayei ranahei mbusümo kokomarɨnɨrɨ hafe. ");
INSERT INTO agg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ai ahambo hoeifikoate-yafehü asu ai hɨhɨrɨyafɨne hena Serusaremɨnambo hüfihɨ kokomarɨnɨrɨ hüfe. ");
INSERT INTO agg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yimbu si ranai howane, ŋgɨmɨ sinambo hondafɨndɨ ai Godɨndɨ worambe Suda-yomondɨ ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ babɨdɨmbo mamaruwa hoeimarɨnerɨ. Ai ranɨhü nɨmarümbo ahamundɨ hoafɨ hɨhɨmborɨyu asu düdufe hoafɨ düdufipurɨ randühɨ mamaru. ");
INSERT INTO agg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ranɨ nindou muŋguambo dɨdemo ai ahandɨ hoafɨ hɨmborɨmemo ranai ahandɨ fɨfɨrɨfeyo asu sɨmborɨ hoafɨmayu ranahambo hepünümefundɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ahandɨ hondafɨndɨ ai ahambo hoeirɨnerühɨ hepünüyafɨne mburɨna hondɨ ai hoafɨyondowohü yahoya, “Nɨmorɨ nda se nɨmboe yɨhoehɨmbo ra-süŋgumarowanda? Sɨhafɨ ape-dɨbo ro sɨhambo afɨndɨ hohoanɨmoyehühɨ kokomarɨhoanɨnɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nɨmorɨ ranai sɨmborɨ hoafɨyuhɨ yahuya, “Nɨmboe se wambo kokomarɨnandɨra? Ro wandɨ Apendɨ worambeahɨ nɨmboamboanahɨ ra se moai fɨfɨrɨneandɨyo?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ŋga yimbu ai moai nɨmorɨndɨ hoafɨ nɨmɨndɨ ra ndorɨne fɨfɨrɨneandɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ranɨyo asu Sisas ai ahandɨ hondafɨndɨ babɨdɨmbo Nasaret ŋgoafɨnambo hɨhɨrɨyahi mahei. Asu ai ahafe hoafɨ hɨmborɨyu marandɨ. Ahandɨ hondɨ Maria ai muŋgu moatükunɨ ra ŋgusüfoambe hohoanɨmoyo kɨkɨhɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sisas ai ahandɨ fi ra adükarɨyuhü asu ahandɨ fɨfɨrɨfe hohoanɨmo ranai adükarɨ tüküfihɨ God-aiyu asu nindou-ayei ahambo hoeirɨhora mayoa aboed-ani masahündo. ");
INSERT INTO agg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Sisar Taiberius ai 15 hɨmbanɨ hɨfandɨrandambe Pondius Pairat ai Sudia-yafe hɨfɨ hɨfandɨmarandɨ. Herot ai Gariri hɨfɨ hɨfandɨrandane, ahandɨ akɨdɨ Firip ai Ituria hɨfɨ asu Trakonitis hɨfɨ hɨfandɨmarandɨ. Risanias ai Abirene hɨfɨ hɨfandɨrandambeyo asu Anas weimbo Kaiafas ai Godɨmbo sesɨ sɨhene-rɨnandeimbɨ bogorɨ adükarɨmayafanɨ. Ranɨ sɨmboanɨyo Son Sekaraiandɨ nɨmorɨ ahambo-so nɨmɨ wohɨ furɨkoate-reandühɨ Godɨndɨ hoafɨ ranai tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ranɨyo Son ai Sodan hoekɨmɨ ra hoahoaŋgu wakɨreandühɨ hoafɨ bokarɨhendühɨ yahuya, “God ai sɨhei moaruwai hohoanɨmo ra gogorɨhefembohünda muŋguambo nindou sɨhei moaruwai hohoanɨmo ra hɨnɨŋgɨndɨhi hehi hundüründei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ranɨ-moatükunɨ ra Godɨndɨ hoafɨ hoafɨyu-randeimbɨ, ahandɨ ndürɨ Aisaia, ahandɨ bukambe hoafɨmayo süŋguyo tükɨmefeyo. Ai yare hoafɨyowohüya, “Nɨmɨ wohɨ furɨkoate-reandühɨ nindou mamɨ ahandɨ yasɨmondɨ ranai mɨŋgɨyo hoafɨyowohü yahoya, ‘Adükarɨndɨ nafɨ wudɨpoapondɨhindɨ, ahambohünda nafɨ dɨdɨboadondɨhindɨ.’ ");
INSERT INTO agg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Muŋguambo hoafendɨ peyo-peyo arandɨ ra hɨfɨ hɨrɨndei koaboadɨhindühɨ botɨre nɨŋgoweimbɨ ra dɨdɨboadombɨrɨhindamboane. Nafɨ ho pusɨre ho pusɨre-randeimbɨ ra dɨdɨboadorɨhinda mbumundɨmbeyo-wamboane, asu nafɨ moaruwaiayo ra wudɨpoapo-mbɨrɨhindamboane. ");
INSERT INTO agg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Rananɨmbo muŋguambo nɨmorehɨ nindowenihɨ ranai God sɨhefɨmbo aboedambofe-munɨmbohünda ratüpurɨmayu ra hoeimbɨrɨhindamboane,” meho. ");
INSERT INTO agg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nindou afɨndɨ ranai Sonɨmboya hundürümbɨramunɨ sei hehi Sodan hɨmona maheiamboyu ai aheimbo hoafɨyundürühɨ yahuya, “Se ana amoasɨrɨ moaruwai ranahandɨ nɨmor-anei. Sɨheimbo dɨdɨ ai hoafɨmayu-amboyei God ai moaruwaimbo-fendürɨmboayu ranambeahɨndɨ aboedambo-fembo hohoanɨmoayeia? ");
INSERT INTO agg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sɨhei hohoanɨmo ra hɨsɨ nahurai-ane. Se sɨhei moaruwai hohoanɨmo hɨnɨŋgɨmarɨhindɨ ra nafuimbohünda hɨsɨ aboedɨ nahurai hohoanɨmombeyei-amboane. Asu se ŋgɨrɨ sɨheihoarɨ sɨmborɨ hoafürɨndeihɨya, ‘Abraham ana yɨhoefɨ amoao-ani ranɨmboane God ai ŋgɨrɨ yɨhoefɨmbo ŋgɨnɨndɨndamunɨ,’ mbɨsei. Ŋga Abrahamɨndɨ ahuirɨ ra moanane. Haponda ro sɨheimbo hoafayahandürɨ, God ai yifirayu ana, ai nɨmoei nda Abrahamɨndɨ ahuirɨmbonde nafɨndandürɨ hɨnɨŋgɨ-ndeandürümbui. ");
INSERT INTO agg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nɨmɨ ranai aboedɨ hɨsɨkoate-ayo ana, nɨmɨ afimambe tɨme yaŋgorɨmboane, hɨtɨfoefe haiambe pifembohünda,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nɨmorehɨ nindowenihɨ ranai Son hoafɨmayu ra hɨmborɨ-yei hehi düdurɨhorühɨ seiya, “Asu ro nünüŋgu-mandɨhunda?” masei ");
INSERT INTO agg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Asu ranɨyo Son ai sɨmborɨ hoafɨyundürühɨ yahuya, “Nindou ŋgorü ai siot yimbundapɨranɨ asu ŋgorü ai moanɨnduanɨ ahandɨ-mayo fihɨndɨ ŋgorü mbɨsagadowamboane. Asu nindou ŋgorü ai sesɨ afɨndɨ asɨhendɨ amboanɨ moanɨ mamɨ mare ranɨ süŋgumbɨreand-amboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis kakɨ sowandümo-rundeimbɨ nindou bɨdɨfɨrɨ amboanɨ hundürümbohünda mahomo. Asu ai düduyafundühɨ yahomoya, “Nindou yamundo-randeimbɨ, asu ro nünüŋgu-mandɨhunda?” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Asu sɨmborɨ Son ai hoafɨyupurühɨ yahuya, “Se takis kakɨ ra gafman hoafɨmemo sɨmogodühɨ yaŋgɨrɨ ndowandümo, ŋga se ahei-mayo afɨndɨ hamɨndɨ semɨndɨpoanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Asükai ami bɨdɨfɨrɨ ranai düduyafundowohü yahomoya, “Asu ro nünüŋgu-mandɨhunda?” mehomondamboyu. Asu sɨmborɨ hoafɨyupurühɨ yahuya, “Se yowanɨ nindou bɨdɨfɨrambo moaruwaimbo-ndüwurühɨ ahei kakɨ hümbuhünɨ-yopoanɨ. Asu se yowanɨ ahei-mayo kakɨ hümbuhünɨmbohünda tɨkefehefe papɨ-hoafɨyopoanɨ. Sapo sɨhamundɨ ratüpurɨ ranɨmbo-hünda kakɨ asowandümo ra ndear-ane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nɨmorehɨ nindowenihɨ ranai ranɨ-moatükunɨ ra hoeirɨhi hehi hepünehindühɨ afɨndɨ hohoanɨmoyeihɨ seiya, “Awi Son ranana Godɨndɨ nindou ranaheimbo semɨndɨ-ndürɨmbo kafoarirɨ hɨnɨŋgɨmarirɨ sapo Krais ranɨ-mbai,” masei. ");
INSERT INTO agg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ranɨyo asu Son ai aheimbo muŋguambo hoafɨyundürühɨ yahuya, “Roana sɨheimbo hoenambo yaŋgɨr-ane hundürarɨhandürɨ, ŋga nindou ŋgorü süŋgunɨ asünu ranai ana ahandɨ ŋgɨnɨndɨ ra wandɨ ŋgɨnɨndɨ ŋgasündeamboane. Asu roana aboedɨ hamɨndɨyahɨpoanɨ ahandɨ su wofɨ hɨmondɨ-maramündu ra fufurɨhefembohünda. Ai anɨmbo hai asu Yifiafɨ Aboedɨnambo hundürü-ndandürɨmbui. ");
INSERT INTO agg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aiana nindou sɨfet semündümbo nahurai anɨmbo tükündɨfimbui. Rananɨmbo wit hɨpɨrɨ ra fɨfɨrɨndɨhembui. Asu wit safɨ wit sɨhefe worambe dɨgendühɨ hɨpɨrɨ ra hai koadürümbo koadürümbo horoweimbɨ ranambe mandeambui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nɨmorehɨ nindowenihɨ afɨndɨ ranaheimbo Son ai ahei ŋgusüfoambe ŋgorü süŋgurearü botɨrearü randühɨ aboedɨ hoafɨ ra bokamarɨhendürɨ. Asu bɨdɨfɨrɨ amurɨ hoafɨ ranamboanɨ ranɨfihɨ türe wataporɨmbo-marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ŋga Son ai ahamundɨ nindou adükarɨ bogorɨ ahandɨ ndürɨ Herot ranahambo ŋgɨnɨndɨ hoafɨmayundo. Ai ramarirɨ ra sapo Herot ai ahandɨ akɨdandɨ nɨmorehɨ ahandɨ ndürɨ Herodias semündü asu bɨdɨfɨrɨ amurɨ moaruwai hohoanɨmo ranamboa yare marandamboyo ramarirɨ. ");
INSERT INTO agg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ranɨyu Herot ai moaruwai hohoanɨmo ŋgorü hohoanɨmoyuhüyu asu ai Sonɨmbo karabusɨmarirɨ. ");
INSERT INTO agg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Muŋguambo nɨmorehɨ nindowenihɨ ai huhundürüyei hehimboyei, asu Sisas ai-amboanɨ hundürümayu. Ai refi mbura nɨmoamo hɨmboyuhü dɨdɨbafɨyuhü nüŋguane, asu sünambe bumareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ranɨyo asu Yifiafɨ Aboedɨ ranai wupufo hoearambefe haya kosɨ ahandɨwamɨ pühɨmayo. Ranɨyo asu sünambeahɨndɨ hoafɨ ranai tüküfihɨ yare hoafɨyowohü yahoya, “Seana moanɨ wandɨ nɨmorɨ hondü-anafɨ. Ro sɨhambo ŋgusüfoambe siao yaheamboanahɨ,” yaho hoafɨmayo. ");
INSERT INTO agg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sisas ai 30 hɨmbanɨmboyuhüyu ahandɨ ratüpurɨ ra piyu haya ratüpurɨmayu hu. Ranɨyei asu nindou ai awi Sosepɨndɨ nɨmor-ani sei hoafɨmayei. Ranühɨ peyo haya boagɨrɨ maho ra ndahurai-ane: Sosep ai Erindɨ nɨmorɨyuane asu Eri ai Matatɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat ai Rifaindɨ nɨmorɨyuane asu Rifai ai Merkindɨ nɨmorɨ-mayu. Merki ai Sanaindɨ nɨmorɨyuane asu Sanai ai Sosepɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Sosep ai Matatiasɨndɨ nɨmorɨyuane asu Matatias ai Amosɨndɨ nɨmorɨ-mayu. Amos ai Nahumɨndɨ nɨmorɨyuane asu Nahum ai Esrindɨ nɨmorɨ-mayu. Esri ai Nagaindɨ nɨmorɨyuane asu Nagai ai Matɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mat ai Matatiasɨndɨ nɨmorɨyuane asu Matatias ai Semenɨndɨ nɨmorɨ-mayu. Semen ai Sosekɨndɨ nɨmorɨyuane asu Sosek ai Sodandɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","28","Soda ai Soananɨndɨ nɨmorɨyuane asu Soanan ai Resandɨ nɨmorɨ-mayu. Resa ai Serubaberɨndɨ nɨmorɨyuane asu Serubaber ai Siartierɨndɨ nɨmorɨ-mayu. Siartier ai Nerindɨ nɨmorɨyuane, Neri ai Merkindɨ nɨmorɨ-mayu asu Merki ai Adindɨ nɨmorɨyuane asu Adi ai Kosamɨndɨ nɨmorɨ-mayu. Kosam ai Ermadamɨndɨ nɨmorɨyuane asu Ermadam ai Erɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ai Sosuandɨ nɨmorɨyuane asu Sosua ai Erieserɨndɨ nɨmorɨ-mayu. Erieser ai Sorimɨndɨ nɨmorɨyuane asu Sorim ai Matatɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat ai Rifaindɨ nɨmorɨyuane asu Rifai ai Simionɨndɨ nɨmorɨ-mayu. Simion ai Sudandɨ nɨmorɨyuane asu Suda ai Sosepɨndɨ nɨmorɨ-mayu. Sosep ai Sonamɨndɨ nɨmorɨyuane asu Sonam ai Eriakimɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriakim ai Mereandɨ nɨmorɨyuane asu Merea ai Menandɨ nɨmorɨ-mayu. Mena ai Matatandɨ nɨmorɨyuane asu Matata ai Natanɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natan ai Defitɨndɨ nɨmorɨyuane asu Defit ai Sesindɨ nɨmorɨ-mayu. Sesi ai Obetɨndɨ nɨmorɨyuane asu Obet ai Boasɨndɨ nɨmorɨ-mayu. Boas ai Sarmonɨndɨ nɨmorɨyuane asu Sarmon ai Nasonɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ai Aminadapɨndɨ nɨmorɨyuane asu Aminadap ai Ramɨndɨ nɨmorɨ-mayu. Ram ai Hesronɨndɨ nɨmorɨyuane asu Hesron ai Peresɨndɨ nɨmorɨ-mayu. Peres ai Sudandɨ nɨmorɨyuane asu ");
INSERT INTO agg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Suda ai Sekopɨndɨ nɨmorɨyu-mayu. Sekop ai Aisakɨndɨ nɨmorɨyuane asu Aisak ai Abrahamɨndɨ nɨmorɨ-mayu. Abraham ai Terandɨ nɨmorɨyuane Tera ai Nahorɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ai Serukɨndɨ nɨmorɨyuane asu Seruk ai Reundɨ nɨmorɨ-mayu. Reu ai Perekɨndɨ nɨmorɨyu-ane asu Perek ai Eberɨndɨ nɨmorɨ-mayu. Eber ai Sarandɨ nɨmorɨyuane asu Sara ai Kainanɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kainan ai Arpaksatɨndɨ nɨmorɨyuane asu Arpaksat ai Siemɨndɨ nɨmorɨ-mayu. Siem ai Noandɨ nɨmorɨyuane asu Noa ai Ramekɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","38","Ramek ai Metuserandɨ nɨmorɨyuane asu Metusera ai Enokɨndɨ nɨmorɨ-mayu. Enok ai Saretɨndɨ nɨmorɨyuane asu Saret ai Mahararerɨndɨ nɨmorɨ-mayu. Mahararer ai Kenanɨndɨ nɨmorɨyuane asu Kenan ai Inosɨndɨ nɨmorɨ-mayu. Inos ai Setɨndɨ nɨmorɨyuane asu Set ai Adamɨndɨ nɨmorɨyuane asu Adam ranɨyu Godɨndɨ nɨmorɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Sisas ai Sodan Hoe hɨmonɨndɨ tüküfi haya Yifiafɨ Aboedɨ ahandɨ fiambe farɨfehüyo kife hürɨmɨndɨ nindoukoate-reandɨ nafɨ maho. Ranɨyo asu ranɨhü Satan ai ahambo moaruwai hohoanɨmombiyuwa yahuhaya 40 sihɨ rari hoeimarirɨ. 40 si maho ranai muŋguyoambe Sisas ai nɨnɨ sesɨ akɨdou-amboanɨ sesɨkoate-wambo wembombomayu. ");
INSERT INTO agg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ranɨyu asu Satan ai Sisasɨmbo hoafɨyundühɨ yahuya, “Se Godɨndɨ nɨmor-ayafɨ ana, nɨmoei kurayo ndanahambo hoafɨndafanɨ bretɨmbondɨfe tükümbɨfeyo-wamboane,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Godɨndɨ Bukambe yare hoafɨyowohü yahoya, ‘Nindou ai ŋgɨrɨ bret ranɨfihɨ gedühɨ yaŋgɨrɨ nüŋgu, ŋga wanɨ,’ meho,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ranɨyu asükai Satan ai Sisasɨmbo hɨfɨ wafuambe nɨmoamo serümündü hafu muŋguambo moatükunɨ ŋgɨnɨndɨ hɨfandarandɨ eŋgoro hɨfɨ ranɨ hoarehɨ ranahambo nafuimefoendo. ");
INSERT INTO agg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ranɨyu yare hoafɨyundühɨ yahuya, “Ro sɨhambo muŋgu moatükunɨ ŋgɨnɨnd-ane asu ndürɨ adükarümbɨ moatükunɨ hɨfɨ ranɨhü eŋgoro ra ndahanɨnɨmboyahɨ. Muŋguambo moatükunɨ ranana wandɨ yaŋgɨr-ane, ŋga ranɨmbo wambo ro nindou daboe saimboayahɨ ra moanɨ wandɨ hohoanɨmonambo yaŋgɨrɨ ndeheamboyahɨ. ");
INSERT INTO agg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Se wambo yaŋgɨrɨ ŋgusüfo parowandɨrühɨ hohoanɨmoayafɨndɨrɨ ana, ro sɨhambo muŋgu moatükunɨ ra ndahanɨnɨmboyahɨ,” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Asu Sisas ai sɨmborɨ ahambo hoafɨyundühɨ yahuya, “Godɨndɨ Bukambe yare hoafɨyowohü yahoya, ‘Sɨhafɨ Adükarɨ God ranahambo yaŋgɨrɨ anɨmbo ŋgusüfo pefihümbo ahambo hohoanɨmoyondowohü ahandɨ ratüpurɨ yaŋgɨrɨ refemboane!’ meho,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ranɨyu asükaiyu Satan ai Sisasɨmbo serümündü haya Serusarem ŋgoafɨna hafu tüküfi Godɨndɨ worɨ-mayo ranɨ bogɨmondɨ wamɨ nɨmoamo hamɨndɨ ŋgahɨ hɨnɨŋgɨmarirɨ. Ranɨyu asu ai ahambo hoafɨyundühɨ yahuya, “Se Godɨndɨ Nɨmor-ayafɨ ana, ndanɨwamɨnɨndɨ sɨhafɨhoarɨ ragu horopɨndafo pɨndafɨ. ");
INSERT INTO agg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Buk Baiborambe yare hoafɨyowohü yahoya, ‘God ai ahandɨ sünambeahɨndɨ nendambo hoafɨndüpuranɨ asu ai sɨhambo aboedɨndondünɨnɨ hɨfandɨndünɨnɨmboemo. ");
INSERT INTO agg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ai sɨhambo ahamundɨ warɨ ra nandundanɨ kodafɨ ranɨwamɨ pɨndafühɨ ŋgɨrɨ sɨhafɨ tɨŋarɨ ra nɨmoeinambo kaboadeyanɨnɨ!’ meho,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ŋga asu Sisas ai sɨmborɨ ahambo hoafɨyundühɨ yahuya, “Buk Baiborambe yare hoafɨyowohü yahoya, ‘Se ŋgɨrɨ Adükarɨ sɨhafɨ God ranahambo rando hoeindɨworɨ’ meho,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan ai ahandɨ refe hoeife hohoanɨmo hoafɨ ranambo Sisasɨmbo ŋgorü-süŋgurirɨ hoeirirɨ ŋgorü-süŋgurirɨ hoeirirɨ ra mbura awi süŋgunamboane yahuhaya ranɨhü ahambo rarirɨ hɨnɨŋgɨrirɨ haya ndamefiyu. ");
INSERT INTO agg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ranɨyu asu Sisas ai Gariri hɨfambe hɨhɨrɨfi hu tüküfiyuwane Yifiafɨ Aboedɨndɨ ŋgɨnɨndɨ ranai ahandɨ fiambe mamarɨndo. Ranɨyo asu ai ranɨhü tüküfimboani hoafɨ ahambo ra muŋguambo hɨfɨ ranɨhü hɨmborɨmayei. ");
INSERT INTO agg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ranɨyu ai muŋguambo si aho ra Suda-yafe rotu worɨ ranambe aboedɨ hoafɨ yamundɨ-mareandüra asu nindou ranai ahambo aiana nindou aboed-ani masei. ");
INSERT INTO agg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ranɨyu asu Sisas ai Nasaret ŋgoafɨna ai nüŋgu adükarɨmayu ranɨhü mahu. Ranɨyu asu moanɨ nɨmarɨmbo si tüküfeyoambe sapo koadürü refe arandɨ süŋgumbo ai Suda-yafe rotu worɨ-mayo ranambe mahüfu. Ai hüfu worɨ ranambe nüŋgumbo Godɨndɨ hoafɨ bukambe hoeireandühɨ wataporɨmbo-marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ranɨyomo Godɨndɨ hoafɨ hoafɨyu-randeimbɨ Aisaia ahandɨ-mayo buk ra masabudo. Ranɨyu ai buk momondɨfimbɨ-mayo ra fufurɨhai hoeireandane hoafɨ ranambe mapenɨŋgo ranai yare hoafɨyowohü yahoya, ");
INSERT INTO agg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‘Yifiafɨ Adükarɨndɨ-mayo wandɨ fiambe amarondɨrɨ. Aboedɨ hoafɨ nindou moaruwai ranaheimbo bokarɨhefendürɨmbo hündambo ai wandɨ mbɨrowamɨ werɨ kafoareandühɨ dɨbonɨmayundɨrɨ. Ai wambo koamarɨhendɨrɨ ra ro aheimbo hoafɨ ra refe bokarɨhefehüya, Nindou karabusambe nɨmboeimbɨ ana, karabusɨ ra hɨnɨŋgɨndɨhi hehi ŋgeimboyei. Nindou dɨdɨyei ai hɨmboarɨ tɨharɨndeihɨ ana, asu ai asükai hɨmboarɨ bɨrɨndɨhehi hɨmboarɨ-ndeimboyei. Nindou moaruwai hamɨndɨ tɨŋɨrɨfoayei ai kɨkɨfe fufurɨ-hefeyoanɨ aboedambo-ndahimboyei. ");
INSERT INTO agg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Asu sapo Adükarɨ ai ahandɨ nendɨ ranaheimbo aboedɨ hohoanɨmoayundürɨ ana, ranɨ hɨmbanɨ si ra ndeara tüküfeihane yaho wataporɨmboyo wakɨfembohünda koamarɨhendɨr-anahɨ nda,’ meho. ");
INSERT INTO agg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ranɨyu asu ai nindou worɨ ra hɨfandandeimbɨ bogorɨ ranahambo bukɨ-mayo ra momonde mbura hɨhɨre sagado haya piyu mamaru. Ranɨyei asu muŋguambo nindou Suda-yafe rotu worɨ ranambe mamarei ranai moanɨ ahambo sowanambo yaŋgɨrɨ hɨmboarɨ mamɨnambo-marɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ai hoafɨyundürühɨ yahundürɨya, “Bukambe ndanɨ bɨdɨfɨrɨ hoafɨ ra haponda moanɨ anɨhondü hondü tükümefeyo ra sapo se ranahambo wataporɨmbo-mayowa hɨmborɨyeimboanei,” mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Muŋguambo nindou ai ahambo nindou aboed-ani sei hoafɨyeihɨ ahandɨ yahamo hoafɨ aboedɨ tükümefeyo ranahambo ŋgusüfo afɨndɨ hohoanɨmomayei. Ranɨyei asu ai rarɨhi hoafɨyeihɨ seiya, “Awi nindou ndanana Sosepɨndɨ nɨmor-ani, ŋga nɨmboe ai ndahurai hoafayu?” sei hoafɨmayei. ");
INSERT INTO agg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Sisas ai aheimbo hoafɨyundürühɨ yahuya, “Ro anɨhondümboanahɨ hoafayahɨ, ndanɨ hoafɨ nda se wambo randɨhi hoafɨndeihɨ anɨmboya, ‘Dokta se sɨhafɨhoarɨ aŋgünɨ ra aboedɨndowandɨ,’ mbɨsei. Rananɨmbo se wambo hohoanɨmondeihɨ anɨmboya, ‘Se sapo ro hɨmborɨyefanɨ Kaperneam ŋgoafɨhü ramarowandɨ nou asu haponda sɨhafɨ hɨfɨ hondühɨ amboanɨ yarosɨ,’ mbɨseimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sisas ai asükaiyu ranɨfihɨ türe haya hoafɨyuhɨ yahuya, “Ro anɨhondümboanahɨ hoafehandürɨ, Godɨndɨ hoafɨ hoafɨyu-randeimbɨ ai ahandɨ ŋgoafɨ hondühündɨ ranaheimbo hoafayu ana, ŋgɨrɨ ai ahandɨ hoafɨ ra hɨmborɨndei. ");
INSERT INTO agg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ro nda anɨhondümboanahɨ hoafehandürɨ, Horombo Eraisa nüŋguambe, Israer hɨfambe nɨmorehɨ bɨdɨfɨrɨ kai ra burɨmayei. Ranɨ-sɨmboanɨ ana ŋgɨmɨ hɨmbanɨyo hayambo asu 6 amoamoyo hoekoate-mayo. Ranɨyo asu hɨfɨ ranɨhü muŋguambo wembo afɨndɨ tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ramefeyoa God ai moai Eraisambo Israer ŋgoafɨhü nɨmorehɨ kai mamɨmbo-so amboanɨ koarɨheirɨ, ŋga wanɨ. Ŋga ai ahambo nɨmorehɨ kai mamɨ Saidon hɨfambe Sarefat ŋgoafɨhü manɨŋgo ranahambo sowanamboyu koamarɨherü. ");
INSERT INTO agg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ranɨ-sɨmboanɨ Godɨndɨ hoafɨ hoafɨyu-randeimbɨ Eraisa ai Israer ŋgoafɨhü nüŋguambe ana nindou afɨndɨ ranai muŋguambo masɨmeimbɨyei hehi afɨndɨ tɨŋɨrɨfo masahümündi. Ŋga Siriahündɨ nindou ahandɨ ndürɨ Neman ai yaŋgɨrɨyo aboedɨmayo, ŋga Israer nindou-yopoanɨ,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Asu nindou Suda-yafe rotu worɨ ranambe mamarei ranai ranɨ hoafɨ ra hɨmborɨyei hehi ŋgɨnɨndɨ hohoanɨmo ranai ahei ŋgusüfoambe tükümefeyondürɨ. ");
INSERT INTO agg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ranɨyei ai botɨyahindühɨ nɨmboeimbo ŋgoafambeahɨndɨ Sisasɨmbo kiaho hürɨhorɨmɨndei wafuanɨ nɨmoamo ahei ŋgoafɨ naŋgoanɨ mahahüsi. Ai ramarɨhorɨ ra ahambo ndɨrɨfanɨ semündü safoefimbo sei hehimboyei. ");
INSERT INTO agg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ŋga asu Sisas ai nindou afɨndɨ-mayei ranahei mbusümo hu haya ahandɨ nafɨ-süŋgu ndamefiyu. ");
INSERT INTO agg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ranɨyu Sisas ai Gariri hɨfambe Kaperneam ŋgoafɨ anaŋgo ranɨnambo mahu. Ai hu ranɨhü nɨmorehɨ nindowenihɨ ranaheimbo moanɨ nɨmarɨmbo si ranɨ-sɨmboanɨ aboedɨ hoafɨ yamundɨmarearü. ");
INSERT INTO agg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Muŋguambo nindou ranai ahandɨ yamundɨfe hoafɨ ra ai sapo ŋgɨnɨndeimbɨ nindou nahurai wataporɨmbo-maranda hɨmborɨyeihehi ranahambo mahepünehindɨ. ");
INSERT INTO agg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Suda-yafe rotu worɨ-mayo ranambe nindou mamɨ moaruwai nendɨ ahandɨ fiambe nɨmarɨndoweimbɨyu haya mamaru. Ranɨyu ai puküna hei karɨhoei hoafɨyuhɨ yahuya, “E! Sisas Nasaretɨhündɨ, se yɨhoefombo nüŋgufemunɨmbo safomboyafɨ nda masɨhüfa? Se ndanɨhü tükümefoandɨ nda yɨhoefombo moaruwaimbo-femunɨmbo safomboyafɨ? Ro sɨhambo nda fɨfɨrɨheanɨnɨmboanahɨ. Seana Godɨndɨ sürühoeimbɨ hoafɨ hoafɨyafɨ randeimbɨ nindou-anafɨ!” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Asu Sisas ai ŋgɨnɨndɨ hoafɨyundowohü yahuya, “Se hoafɨ kɨkɨrandɨfɨ hawa nindou ranahandɨ fiambeahɨndɨ kosɨfoao!” mehundowamboyo. Ranɨyo asu nindou-mayu ranahambo nindouyei wagabe wakɨfoarerɨ sɨherɨ haya nindou ranahambo moaruwaimbofi-koate fiambeahɨndɨ hifoai peyo haya ndamefeyo. ");
INSERT INTO agg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nindou ranai ranahambo hepünahi sɨmborɨ hoafɨyahindühɨ seiya, “Nɨne-moatükunɨ hoafɨ moanɨ yahurai rana? Moanɨ ranɨ-poanɨmbo ŋgɨnɨndɨ hamɨndɨ hoafɨnamboyo nindou ndanai moaruwai nendɨ ranahambo hoafɨ masagadowa asu ai nindou fiambeahɨndɨ akosɨfoendɨ!” masei. ");
INSERT INTO agg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ranɨyo asu Sisas ai ranɨ-moatükunɨ ramareandɨ hoafɨ ranai ranɨ hɨfɨ muŋgu ranambe tükümefeyoa hɨmborɨ-marɨhümündi. ");
INSERT INTO agg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sisas ai ranɨhü Suda-yafe rotu worɨ ra hɨnɨŋɨre haya Saimonɨndɨ worɨna mahu. Ranɨyo asu Saimonɨndɨ yamoŋgoa-mɨndɨ ranai aŋgünɨmboyowohü hüfü afɨndɨ hamɨndɨ pare haya mamarowamboyo, asu nindou ranai Sisasɨmbo nɨmorehɨ ranahambohünda wataporɨmbo-marɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ranɨyu asu Sisas ai hu ahandɨ fikɨmɨ botɨfi nüŋgumbo hüfü afɨndɨ ranahambo nɨmorehɨ ra hɨnɨŋgɨro hawa kosɨfoao yahuhaya hoafɨmayu. Ranɨyo hüfü afɨndɨ ranai ahambo hɨnɨŋgɨre haya makosɨfoenda, asu nɨmorehɨ ranai moanɨ mamɨharɨ botɨfe aheimbo sesɨ kanɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hüfɨhamɨndɨ hürɨmɨndoanɨ nɨmbambe nindou bɨdɨfɨrɨ ranai ahei ŋgunindɨ aŋgünɨ moaruwai hamɨndeimbɨ ranaheimbo sahümündihündürɨ Sisas sowana mafandɨhindɨ. Sisas ai nindou aŋgünɨmboyeimbɨ muŋguambo mamamɨ ranaheimbo aheiwamɨ warɨ nandeandürühɨ muŋguambo dɨdɨboado-mareandürɨ. ");
INSERT INTO agg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Moaruwai nendɨ ranai nindou afɨndɨ ranahei fiambeahɨndɨ kosɨfoehindühɨ hasɨheiyeihɨ seiya, “Seana Godɨndɨ Nɨmor-anafɨ!” masei. Sisas ai moaruwai nendɨ ranaheimbo hoafɨkoate yafadühamɨ tapɨmbɨyeia yahuhaya hoafɨmayundürɨ sapo ai Krais-ani sei fɨfɨrɨmarɨhorambo. ");
INSERT INTO agg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Siambe hondü Sisas ai ŋgoafɨ ra hɨnɨŋgɨre haya nindoukoate reandühɨ mahu. Ranɨyei asu nindou ranai ahambo kokomarɨhorɨ. Ai kokorɨhorɨ hoeirɨhorühɨyei ahambo ŋgumbui sei hehi kɨkɨhɨsafɨ-marɨhorɨmɨndei. ");
INSERT INTO agg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ŋga asu ai aheimbo hoafɨyundürühɨ yahuya “God ai ŋgɨnɨndɨ hɨfandarandɨ ranahambo aboedɨ hoafɨ ra bɨdɨfɨrɨ ŋgoafɨ ranɨhü amboanɨ bokarɨhefembo samboanahɨ. Sapo ro ranɨ-moatükunɨ refembo ranɨmboyu God ai wambo koamarɨhendɨrɨ nda,” mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ranɨyu asu ai muŋguambo Suda-yafe rotu worɨ ranɨ hɨfambe afeburo ranambe huhurandühɨ ranɨ hoafɨ ra bokamarɨhendɨ. ");
INSERT INTO agg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mamɨmbo Sisas ai Genesaret kurɨhoe-mayo ranɨ gudikɨmɨ nüŋguane, asu nindou afɨndɨ ranai ahandɨ fikɨmɨ Godɨndɨ hoafɨ hoafɨyowanɨ hɨmborɨmbo sɨmborɨ nɨnendürɨyeihɨ burɨmayei. ");
INSERT INTO agg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ranɨyu ai hoeireanda bot yimbu ra hürüpündɨmo gudianɨ masɨhoupɨrɨ. Nindou kinɨ batüru-rundeimbɨ ranai bot ra raru sɨhoupɨrɨ houmbo andürɨ popoairundühɨ manɨŋgomo. ");
INSERT INTO agg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ranɨyu asu Sisas ai bot yimbu meŋgorafe ra ŋgorü Saimonɨndɨ-mayo ranambe kefuai haya ahambo gudianɨpoedɨ akɨdou hoe safana nɨnendɨfembohünda hoafɨmayundo. Sisas ai bot ranambe nɨmarümbo Godɨndɨ hoafɨ yamundɨmarearü. ");
INSERT INTO agg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wataporɨmbo ra kɨkamündühɨ nüŋgumbo Saimonɨmbo hoafɨyundühɨ yahuya, “Bot ra asükai akɨdou hohoeanambo safɨ nɨnendo hafühɨ anɨmbo asu se sɨhafɨ ŋgorü afɨndɨ yimbu ranɨ-babɨdɨmbo sɨhamundɨ andürɨ ra kinɨ wakemɨndɨmbohünda foandu gadɨmo,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon ai Sisasɨmbo sɨmborɨ hoafɨyundühɨ yahuya, “Adükarɨ ro nɨmbɨ gebuai maho ra hüti-hütiyefɨmboyefane moai akɨdou-amboanɨ wakɨrɨhumɨndefɨ. Ŋga asu se rawasafɨ ana, ro andürɨ nda hɨmonɨ foandɨhe gadɨmboyahɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ai andürɨ ra foarɨne hanɨfanɨmbo kinɨ afɨndɨ safɨ andürambe pɨyeihɨ andürɨ ranai bɨremɨndɨ pɨmbo yaŋgɨrɨmayo. ");
INSERT INTO agg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ranɨyomo asu ai ahamundɨ bɨdɨfɨrɨ wandafɨ mamɨ ŋgorü botambe mamarɨmo ranahamumbo warɨkakɨmemo yɨhoefombo sɨnɨmo farɨhaumunɨ yahomombo. Ranɨyomo asu ai sɨfomo bot yimbu ra wambürühɨrupɨrɨ hafomombo bot ranai tükürɨnɨ pirɨneandühɨ hɨmonɨ tɨporɨkofembo yaŋgɨrɨmayo. ");
INSERT INTO agg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita ai ranɨ-moatükunɨ ramefeyo ra hoeire haya Sisasɨndɨ haŋgɨfoanɨ yirü yimbu pusɨre nɨmarümbo hoafɨyuhɨ yahuya, “Adükarɨ, se andai ragu ŋgafɨ, ŋga wandɨ fikɨmɨ nɨŋgopoanɨ. Ŋga roana moaruwai hohoanɨmoyaheimbɨ nindou-anahɨ!” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimon aiyu asu nindou bɨdɨfɨrɨ ai-babɨdɨmbo manɨŋgomo ranaiyomo muŋguambo kinɨ afɨndɨ yahurai wakɨmaründümo ranɨmbo hoeirunda mayoa mahepünafundɨ. ");
INSERT INTO agg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimonɨndɨ ŋgorü afɨndɨ yimbu Sems Son Sebedindɨ nɨmorɨ ai-amboanɨ marɨne mahepünafɨneandɨ. Ranɨyu Sisas ai Saimonɨmbo hoafɨyundühɨ yahuya, “Se yɨhɨmbo-ndamboyafɨ, hapondahündɨ ana sapo se kinɨ afɨndɨ andürambeahɨ pɨrɨfɨmarandɨ yahurai anɨmbo nindou-amboanɨ se ndowandɨfɨ wambo sowana dɨdɨmboyafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ranɨyomo ai bot ra gudianɨ kiafu hürüpündɨmo sɨhaupɨrɨ houmbo muŋguambo moatükunɨ ra ranɨhü raru kokosɨfoaru sɨhoemo houmbo Sisasɨndɨ süŋgumefundɨ. ");
INSERT INTO agg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Asu Sisas ai adükarɨ ŋgoafɨhü nɨmaruane, ranɨ ŋgoafɨhü nindou mamɨ mɨmanɨho masɨmeimbɨ tɨŋɨrɨfomboyuhü mamaru. Ai Sisasɨmbo hoeirirɨ haya ahandɨ fikɨmɨ yimɨndoho yimbu pusɨre hɨfɨnɨ mbɨro türe nɨmarümbo hüti hoafɨrürühɨ yahuya, “Adükarɨ, se refembo hohoanɨmondafühɨ ana, se wambo dɨdɨboado-ndowandɨra aboedɨndamboane!” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ranɨyu asu Sisas ai warɨfi sündirühɨ yahuya, “Ro refembo samboanahɨ, ŋga se aboedɨ tüküyafo,” mehundo. Ranɨyo asu nindou ranahambo masɨmei ranai mamɨharɨ hoafɨ nɨŋgoambe hɨnɨŋgɨmarerɨ. ");
INSERT INTO agg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ranɨyu asu Sisas ai nindou-mayu ranahambo hoafɨyundühɨ yahuya, “Nindou amurambo hoafɨndamboyafɨ, ŋga se moanɨ ŋgafɨ Godɨmbo sesɨ sɨhai-randeimbɨ-mayu ranahambo anɨmbo sɨhafɨ fi ra nafuindafɨ. Rananɨmbo Mosesɨndɨ hoafɨ hoafɨmayo süŋgu Godɨmbo sesɨ sɨhai-randeimbɨ ai sɨhambohünda sesɨ mbɨsɨhendamboane. Rananɨmbo asu masɨmei aboedayo ra nindou amurɨ ranai fɨfɨrɨmbɨrɨhi-ndamboane,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ŋga asu Sisas ai ranɨ-moatükunɨ yare arandɨ hoafɨ ranai afɨndɨ hamɨndɨ yaŋgorɨ wakɨmareandɨ. Ranɨyei nɨmorehɨ nindowenihɨ afɨndɨ ranai ahandɨ hoafɨ hɨmborɨmbo asu ahei fiambe aŋgünɨ ra aboedɨfembohünda ahambo sowana masɨnei. ");
INSERT INTO agg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ŋga afɨndɨmbo Sisas ai nindou kɨkefoefekoate-reandühɨ Godɨmbo dɨdɨbafɨfembo aimbo huhani. ");
INSERT INTO agg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mamɨmbo Sisas ai nɨmorehɨ nindowenihɨ ranaheimbo yamundeandürühɨ nɨmaruane, asu ranɨhü Farisi nindou-yomo Suda-yafe ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ-yomo ranai mamarɨmo. Bɨdɨfɨrɨ ai muŋguambo ŋgoafɨ Gariri hɨfambe adaburo ranambeahɨndɨ, bɨdɨfɨrɨ ai Sudiahündɨ asu bɨdɨfɨrɨ Serusarem ŋgoafɨhündɨ ranɨyomo ranɨhü mamarɨmo. Ranɨyo asu nindouyei fiambe aŋgünɨ moaruwai amarondürɨ ra aboedɨfembohünda Adükarɨndɨ ŋgɨnɨndɨ ranai Sisasɨndɨ fiambe mamaro. ");
INSERT INTO agg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nindou bɨdɨfɨrɨ ai nindou mamɨ yirɨwarɨ moaruwaimbü Sisasɨndɨ haŋgɨfoanɨ safoefimbo yahomo houmbo safɨsendɨwamɨ nandu sowaründümo mahomo. ");
INSERT INTO agg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Asu nɨmorehɨ nindowenihɨ afɨndɨ ranai gümarɨhi-ndamboemo ai ahambo semündü hɨfombo nafɨ ra hoeifekoate-yomondühɨyomo, asu ahambo worɨwamɨ sowaründümo mahafomo. Ranɨyomo ai woteimɨ fɨfahɨrɨhoemo mburu ranɨ nafɨ nindou-mayu ra safɨsendɨ-mayo ranɨ kameihɨ nindou-mayei ranahei mbusümo Sisasɨndɨ wagabe masafoarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sisas ai ahamundɨ anɨhondümbofe hohoanɨmo ranahambo ndare hoeireapuranɨ mayoa, nindou-mayu ranahambo hoafɨyundühɨ yahuya, “Wandafɨ, sɨhafɨ moaruwai hohoanɨmo ranahambo amboawi samboanahɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Suda-yafe ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ-yomo asu Farisi nindou-yomo ai ahamundɨhoarɨ sɨmborɨ hoafɨndurü-yafundühɨ yahomoya, “Nindou nda nɨnɨ nindouyu God nahurai hoafɨyuhɨ ranɨnambo ahambo tɨrafoarirɨ ndana? God yaŋgɨrɨ anɨmbo moaruwai hohoanɨmo ranahambo amboawi mbüsümbuisɨ!” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sisas ai ahamundɨ hohoanɨmo amaropurɨ ranahambo fɨfɨre haya ahamumbo hoafɨyupurühɨ yahuya, “Se ra nɨmboemo yahurai raru hohoanɨmoemo rana? ");
INSERT INTO agg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ro hoafɨyahühɨya ‘Sɨhafɨ moaruwai hohoanɨmo ranahambo amboawi’ asahɨyo asu ‘Botɨyafo hawa hafɨ’ asahɨyo, yimbu ra hoafɨmbo ro ŋgɨnɨndeimb-anahɨ. Asu yimbu hoafɨ ra hoafɨmbo nahanɨyo hɨnɨŋgɨrouayo asu nahanɨyo tɨŋümbayo? Yɨbobo ra ro hoafɨndahanɨ anɨhondümbo tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Se Nindou Hondü ro ŋgɨnɨndɨ masahamɨndɨhɨ moaruwai hohoanɨmo amboawi yaho hoafɨmbohünda ranahambo sɨhamumbo nafuimbo ro nindou nda aboedɨndɨhinɨmboyahɨ,” mehu. Ranɨyu asu ai nindou yirɨwarɨ moaruwaimbü-mayu ranahambo hoafɨyundühɨ yahuya, “Haponda ro sɨhambo hoafehanɨnɨ, botɨyafo sɨhafɨ safɨsendɨ ra sowandɨfɨ hawa ŋgoafɨnambo ŋgafɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hoafɨ nɨŋgoambe muŋguambo nindou-mayei ranahei wagabe botɨfi ahandɨ safɨsendɨ ra semündü haya Godɨmbo aboedɨ hamɨnd-ani yahuhü ŋgoafɨna mahu. ");
INSERT INTO agg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ranɨyei asu muŋguambo nindou ranai muŋguna yahurai afɨndɨ hamɨndɨ mahepünehindɨ! Ai ranɨ-moatükunɨmbo ŋgusüfo kɨbodɨrɨ-foarɨhindühɨ Godɨmbo aboed-ani seihüya, “Ranɨ-poanɨmbo moatükunɨ haponda hoeimarɨhundɨ,” masei. ");
INSERT INTO agg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ranɨ-moatükunɨ ai refe hayamboyoane ranambe Sisas ai hu hoeirirane nindou mamɨ ahandɨ ndürɨ Rifai takis kakɨ semündü-randeimbɨ ai ahandɨ ratüpurɨ worambe mamaru. Sisas ai ahambo hoafɨyundühɨ yahuya, “Se wandɨ süŋgu mborai,” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Asu Rifai ai botɨfi haya muŋguambo moatükunɨ yare kokosɨfoare haya Sisasɨndɨ süŋgu ndamefiyu. ");
INSERT INTO agg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ranɨyu asu Rifai ai ahandɨ worambe Sisasɨmbo sesɨ afɨndɨ sɨndɨmarandɨ. Ranɨyomo asu nindou takis kakɨ sowandümo-rundeimbɨ-yomo asu nindou amurɨ ranɨyomo ai sesɨ ra ai-babɨdɨmbo nɨmarɨmo masowasümo. ");
INSERT INTO agg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ranɨyomo Farisi bɨdɨfɨrɨ ranɨ rotu-ambeahɨndɨ-memo-yomo asu ahɨnümbɨ hohoanɨmo yamundu-ndeimbɨ bɨdɨfɨrɨ-yomo ranai Sisasɨndɨ süŋgururü-rundeimbɨ-memo ranahamumbo momorɨ hoafɨyomopurühɨ düdurüpurühɨ yahomoya, “Se ra nɨmboemo takis kakɨ sowandümo rundeimb-anemo asu nindou amurɨ moaruwai hohoanɨmoyomo-rundeimb-anemo ranɨ-babɨdɨmbo sesɨ sowasümo hoe sɨmɨndɨmo arunda?” mehomopurɨ. ");
INSERT INTO agg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sisas ai ahamumbo hɨhɨre hoafɨyupurühɨ yahupurɨya, “Nindou aŋgünɨkoate ana, moai dokta sowana hei rɨhündɨ, ŋga aŋgüneimb-anei hei arɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ro tükümeheandɨ nda nindou aheihoarɨmboya ro mbumundɨ nindou-anefɨ sei arɨhündɨ ranaheimbo awi se moaruwai hohoanɨmo hɨnɨŋgɨrɨhindühɨ aboedɨ hohoanɨmoyei sahehea tüküyaheambo yahɨpoanɨ, ŋga wanɨ. Ŋga ro moaruwai hohoanɨmoyeimbɨ nindou ai aboedɨ hohoanɨmo süŋgumbeyahindɨ sahehea tükümeheandane,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ranɨyei asu nindou bɨdɨfɨrɨ ai Sisasɨmbo hoafɨyeihɨ seiya, “Nindou bɨdɨfɨrɨ Sonɨmbo süŋgrurü-rundeimbɨ ana afɨndɨmbo sesɨ wehɨ nɨŋgomombo Godɨmbo yaŋgɨrɨ dɨdɨbafɨ-yomondühanemo. Asu nindou Farisi-yomondɨ hohoanɨmo süŋgurundeimbɨ-ranai-amboanɨ maru ranɨ süŋguru arundɨ, ŋga sɨhambo süŋgurunɨnɨ-rundeimbɨ aiana sesɨ sowasümo hoe sɨmɨndɨmo rundühanemo?” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Asu Sisas ai aheimbo hoafɨyundürühɨ yahundürɨya, “Asu se ra nindou mamɨ ai nɨmorehɨ semɨndɨmbo yahuanɨ ranɨ-sɨmboanɨ sesɨ afɨndɨ raraorɨhindühɨ ŋgunindɨ afandɨhindɨ ranaheimbo sesɨ wembopo ndahümündihündürɨ mamandiyo sapo nindou nɨmorehɨ semɨndɨmbo-mayu ranai ai-babɨdɨmbo nɨmanduanɨ? I, ra wanɨ. ");
INSERT INTO agg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ŋga süŋgunambo nɨmorehɨ semɨndɨmbo nindou ranahambo ndowarɨndümo gorügoanɨnɨ ŋgomondanɨ ranɨ-sɨmboanɨ anɨmbo ai sesɨ wehɨndeimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Asükaiyu Sisas ai aheimbo ŋgorü kafoefe hoafɨ hoafɨyundürühɨ yahundürɨya, “Nindou mamɨ ai-amboanɨ moai hoearɨ sɨmborɨndambo buramündɨ haya asu ŋgɨsɨharɨ hoearɨ wamɨndafɨ ambe anɨŋgo ranɨfihɨ pare haya kakɨyu randɨ, ŋga wanɨ. Ai rawareandɨ ana, hoearɨ sɨmborɨ-mayo ranai bundeandanɨ asu sɨmborɨ hoearɨ ranai ŋgɨrɨ wamɨndafɨ hoearɨ-mayo ranɨfihɨ sɨmoŋgorɨ-ndamɨndo. ");
INSERT INTO agg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Asu nindou ŋgorü ai wain boboe sɨmborɨ ra sapo wamɨndafɨ nɨnɨhondɨ hoearɨ hɨpɨrɨ wain keferandeimbɨ-mayo ranambe karareandɨ ana, sɨmborɨ wain ranai wamɨndafɨ wain hɨpɨrɨ ra borɨndeandühɨ wain ranai hɨfɨnɨ keboendühɨ wamɨndafɨ hɨpɨrɨ-mayo ra moaruwaindɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ŋga sɨmborɨ wain boboe ranana sapo sɨmborɨ nɨnɨhondɨ hoearɨ hɨpɨrɨ-mayo ranambe anɨmbo kefemboane! ");
INSERT INTO agg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nindou ai wamɨndafɨ wain ra sümündɨ hayambo ana, ai ŋgɨrɨ sɨmborɨ sɨmɨndɨmbo yifirɨndu. Ai hoafɨyuhɨya, ‘Wamɨndafɨ wain-ane aboedayo,’ mbüsümbui,” mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Moanɨ ŋgoafɨmbo nɨmarɨmbo sihɨ Sisas ai wit nümbürambe mahu. Ranɨyo asu ahambo süŋgrurü-rundeimbɨ ai wit hɨsɨ ra warɨhü hüründümo mburu warɨ düdühüru hɨpɨrɨ ra horɨmarɨhoayowa safɨ yaŋgɨrɨ masowasümo. ");
INSERT INTO agg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ranɨyomo asu Farisi nindou bɨdɨfɨrɨ ai düduyafundühɨya, “Se nɨmboe ranɨ-moatükunɨ ra rawarundɨ rana? Yɨhoefɨ ahɨnümbɨ hohoanɨmo ranai yahoya moanɨ ŋgoafɨmbo nɨmarɨmbo sihɨ ranɨ-moatükunɨ refepoanɨ meho,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Asu sɨmborɨ Sisas ai hoafɨyupurühɨ yahuya, “Awi se moai bukambe hoeirundɨyo sapo Defit ai ahandɨ nendɨ bɨdɨfɨrɨ-babɨdɨmbo wembomboyuhü ramareandɨ hoafɨ rana? ");
INSERT INTO agg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Sapo ai Godɨndɨ worambe kefuai hüfu Godɨmbo sɨhefeimbɨhündɨ bret meŋgoro ra semündü sesühɨ asu ahandɨ nendɨ bɨdɨfɨrɨ-memo ranahamumbo amboanɨ masagapurɨ. Yɨhoefɨ ahɨnümbɨ hohoanɨmo süŋgu amboanɨ nindou amurɨ ai ŋgɨrɨ refimbɨhündɨ bret ra dagüdi, ŋga moanɨ Godɨmbo sesɨ sɨhou-rundeimbɨ yaŋgɨrɨ anɨmbo bret ra dowadümboemo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Asu Sisas ai hoafɨ moendɨreandühɨ hoafɨyuhɨ yahuya, “Nindou Hondü ranai ana moanɨ ŋgoafɨmbo nɨmarɨmbo sihɨ ra ai nɨmɨndani,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ŋgorü moanɨ ŋgoafɨmbo nɨmarɨ sihɨ Sisas ai Suda-yafe rotu worambe kefuai hüfu nɨmorehɨ nindowenihɨmbo yamundɨ-mareandürɨ. Ranühɨ nindou mamɨ warɨhondü warɨ ahandɨ ranai moaŋgorɨfoarerɨ haya mamaru. ");
INSERT INTO agg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Suda-yomondɨ ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ bɨdɨfɨrɨyomo asu Farisi nindou-yomo ai nɨnɨ nafɨsüŋgundɨhurɨ Sisasɨmbo papɨ-hoafɨndɨhurɨ yahomo houmbo mamarɨmo. Ranɨyomo ai moanɨ ahambo hɨmboarɨnambo yaŋgɨrɨ hɨfandɨrürühɨ mamarɨmo Sisas ai moanɨ ŋgoafɨmbo nɨmarɨmbo si ranɨhü nindou aboedɨreandɨhüpo yahomo houmbo. ");
INSERT INTO agg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Asu Sisas ai ahamundɨ hohoanɨmo ra fɨfɨrehayambo-wambo nindou-mayu ranahambo hoafɨyundowohü yahuya, “Botɨyafo hawa ndühɨ wagabe sühüfɨ,” mehundo. Ranɨyu asu nindou-mayu ranai botɨfi hüfu wagabe manüŋgu. ");
INSERT INTO agg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ramefi-yuwamboyu Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Ro sɨhamumbo düduweheandɨ: nɨnɨ-moatükunɨmboyo sɨhefɨ ahɨnümbɨ hohoanɨmo ranai yowanɨ moanɨ nɨmarɨmbo sihɨ refepoanɨ mehoa? Farɨhefemboyo asu moaruwaimbo-femboyo? Nindou mamɨndɨ yaŋgɨrɨ nɨŋgombo ra dɨdɨboado-femboyo asu yembüfemboyo?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ai ahamumbo muŋguambo türapuranɨ mayowamboyu asu nindou-mayu ranahambo hoafɨyundowohü yahuya, “Sɨhafɨ warɨ ra ŋgurɨhoefɨ,” mehundo. Ai ranɨ-süŋgumareanda, asu ahandɨ warɨ ranai asükaiyo aboedɨmayo. ");
INSERT INTO agg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Asu nindou-memo ranai ŋgusüfoambe moaruwairapurühɨ Sisasɨmbo nüŋgundɨhurɨ yahomo houmbo ahamundɨhoarɨ wataporɨmbomarundɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mamɨ ranɨ-sɨmboanɨ Sisas ai hɨfɨ wafuana Godɨmbo dɨdɨbafɨfembo mahafu. Ai nɨmbokoanɨ Godɨmbo dɨdɨbafɨyo hombo sürüfoefembohünda. ");
INSERT INTO agg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ranɨyo asu simayoambo ai ahambo süŋgrurü-rundeimbɨ-memo ranahamumbo mborai yahupurɨ hürɨhepurɨ haya asu 12 nindou sepurɨmündühɨ ahamundɨ ndürɨ hoafɨ sowandümo homo-rundeimb-anemo yahu kamafoareapurɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimonɨmboyu Pitamboyu-randeimbɨ-mayu, asu ahandɨ akɨdɨ Andruyu, Sems, Son, Firip, Bartoromyu, ");
INSERT INTO agg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Sems Arfiusɨndɨ nɨmorɨ, asu Saimon Serotɨhündɨ ranɨyomo. ");
INSERT INTO agg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Sudas Semsɨndɨ nɨmorɨ asu Sudas Iskariot, sapo Sisasɨmbo hürütümbɨ nendɨ-yomondɨ warɨhürireimbɨ-mayu ranɨyu. ");
INSERT INTO agg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sisas ai hɨfɨ wafu wamɨnɨndɨ ahandɨ hoafɨ sowandümo homo-rundeimbɨ-memo ranɨ-babɨdɨ hanɨmo houmboemo asu nindou bɨdɨfɨrɨ afɨndɨ ahambo süŋgrurü-rundeimbɨ ranɨ-babɨdɨ ndümündühɨ manɨŋgomo. Ranɨyei nindou afɨndɨ ra Sudia hɨfɨhündɨ, Serusaremɨhündɨ, Tair asu Saidonɨ-yafe hɨfɨhü sɨrɨwara gudikɨmɨ ŋgoafɨ adaburo ranɨhündambo ai-amboanɨ ranɨhü burɨmayei. ");
INSERT INTO agg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Asu ai ranɨhü tükümehindɨ ra ahandɨ hoafɨ hɨmborɨyo asu ahei aŋgünɨ ra aboedɨmbɨreandambo sei hehimboyei. Asu dɨdɨyei moaruwai nendɨ nɨmarɨndürɨmbo tɨŋɨrɨfo sahümündeimbɨ ai-amboanɨ tükümehinda aboedɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Muŋguambo nindou ranai ahambo sindɨhorɨ marɨhündɨ ra sapo ahandɨ fiambeahɨndɨ ŋgɨnɨndɨ ranai kosɨfoendühɨ aheimbo aboedɨreirɨ marandamboyei. Ranɨyo Sisas ai muŋguambo nindou aboedɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sisas ai ahambo süŋgrurü-rundeimbɨ-memo ranahamumbo hɨmboarɨ pareapurɨ nüŋgumbo hoafɨyupurühɨ yahuya, “Se dɨdemo napokoate-ayomo seana hɨhɨfɨ-hɨhɨfɨ-mbemondamboane, ŋga haponda God ŋgɨnɨndɨ hɨfandarandɨ ra sɨhamund-ane. ");
INSERT INTO agg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Se dɨdemo haponda wembomboemo seana hɨhɨfɨ-hɨhɨfɨ-mbemondamboane, ŋga seana bodoweimbɨ nɨŋgomboemo! Se dɨdemo haponda aranɨ-aranemo seana hɨhɨfɨ-hɨhɨfɨ-mbemondamboane, ŋga seana tɨkɨfɨnambo nɨŋgomboemo! ");
INSERT INTO agg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Dɨdemo sɨhamumboya Nindou Hondümbo süŋgururü rundeimb-anemo mbɨseihɨ asu ranɨ süŋgumbo sɨhamumbo yɨboarukorɨhipurɨ, ŋgɨnɨndɨ hoafɨyahüpurɨ asu seana moaruwai-anemo sei hoafayei ana, se hɨhɨfɨ-hɨhɨfɨndɨmo. ");
INSERT INTO agg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ranɨ-moatükunɨ ra rawefeyo ana, se hohorɨpɨ-hohorɨpɨ-ndɨmondühɨ hɨhɨfɨ-hɨhɨfɨndɨmo nɨmboe sapo sɨhamundɨ takɨnɨ afɨndɨ sünambe begorɨpurɨ. Nɨmboe sapo ahei amoao mamɨ amboanɨ Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ ahamumbo ranɨ-moatükunɨ ramarɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Se dɨdɨyei haponda napo afɨndeimbayei, seana hɨpoanɨmboembou-anei! Sapo seana hapo yaŋgɨrɨ anɨmbo tɨŋɨrɨfokoate-fi handɨhi nɨmboeimboyei. ");
INSERT INTO agg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Se dɨdɨyei haponda bodoweimbayei, seana hɨpoanɨmboembou-anei! nɨmboe seana sapo wembombondeimboyei! Se dɨdɨyei haponda tɨkɨfɨ-hoafɨnambo amarei, seana hɨpoanɨmbembou anei! Nɨmboe sapo seana aranɨ-aranɨndeimboyei! ");
INSERT INTO agg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nindou ai sɨheimbo haponda aboed-anei sei hoafɨyei arɨhündɨ, seana hɨpoanɨmboembou-anei! Nɨmboe ahei amoao mamɨ amboanɨ Godɨndɨ hoafɨ tɨkai hoafɨyomo-rundeimbɨ-memo ranahamumbo amboanɨ yahurai rasei marɨhündane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Sisas ai hoafɨyuhɨ yahuya, “Se dɨdɨyei wandɨ hoafɨ hɨmborɨyei arɨhündɨ sɨheimbo ro hoafayahɨ: Nindou dɨdɨyei sɨhei hürütümbayei ranaheimbo se hɨpoambo-ndɨhindürɨ. Nindou dɨdɨyei sɨheimbo yɨboaruko-arɨhündürɨ ranaheimbo se ŋgusüfo pandɨhindürühɨ hɨpoambo-ndɨhindürɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nindou dɨdɨyei sɨheimbo hoafɨnambo moaruwaimbo-arɨhindürɨ ranaheimbo se God ai aboedɨ-aboedɨmbɨrea-ndüramboane mbɨsei. Asu nindou dɨdɨyei sɨheimbo wudɨpoapofe-ndürɨkoate-ayei ranaheimbohünda se Godɨmbo dɨdɨbafɨndei. ");
INSERT INTO agg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Asu sɨhambo nindou ŋgorü ai mamɨ koaihoanɨ harɨnduanɨ asükai ŋgorü koaiho amboanɨ hɨhɨrɨndowandanɨ ranɨfihɨ harɨmbiyuwamboane. Asu nindou ŋgorü ai sɨhafɨ ŋgɨsɨharɨ hoearɨ ndemünduanɨ ana, asükai sɨhafɨ siot ŋgorü-amboanɨ mbɨsemündu-wamboane. ");
INSERT INTO agg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nindou dɨdɨyei sɨhambo nɨnɨ-moatükunɨmbo düdundahindanɨ ranaheimbo muŋguambo dabadürɨ. Asu nindou ŋgorü ai sɨhafɨ nɨnɨ-moatükunɨ napo ndemünduanɨ asükai hɨhɨrɨfe semɨndɨmbo hoafɨpoanɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Asu se nindou bɨdɨfɨrambo ai wambo ranɨ-moatükunɨ rambɨrɨhindɨ asafɨ ra se aheimbo ranɨ-süŋgundowandɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Se nindou sɨheimbo hohoanɨmoyei-rɨhündeimbɨ ranɨ nindoumbo yaŋgɨrɨ se hohoanɨmoayei ana, ŋgɨrɨ ranɨ süŋgu sɨheimbo aboed-anei mbɨsei. Nindou moaruwai hohoanɨmoyei-rɨhündeimbɨ amboanɨ nindou dɨdɨyei aheimbo hohoanɨmoyei-rɨhündeimbɨ aheimbo yaŋgɨrɨ hohoanɨmorɨhündürɨ rɨhündühanei! ");
INSERT INTO agg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Asu se nindou sɨheimbo dɨdɨboado-rɨhindürɨ arɨhündɨ ranaheimbo yaŋgɨrɨ se dɨdɨboado-arɨhindürɨ ana, asu ŋgɨrɨ ranɨ-süŋgu aheimbo aboed-anei mbɨsei. Nindou moaruwai hohoanɨmoyei rɨhündeimbɨ amboanɨ ranɨ süŋgurühi hündühanei! ");
INSERT INTO agg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Asu se nindou dɨdɨyei ranaheimbo nɨnɨ-moatükunɨ ndahundürü mbundɨhumbo hɨhɨrɨndɨhu ndahumɨndefɨ sei hehi hohoanɨmoyeihɨ aheimbo yaŋgɨrɨ sahündürɨ arɨhündɨ ranɨmbo ŋgɨrɨ sɨheimbo aboed-anei mbɨsei. Nindou moaruwai hohoanɨmoyei-rɨhündeimbɨ amboanɨ nindou bɨdɨfɨrɨ moaruwai hohoanɨmoyei-rɨhündeimbɨ ranaheimbo sahündürɨ rɨhündühanei, ra aheimbo masehindɨ nahurai hɨhɨrɨfe semɨndɨmbohünda! ");
INSERT INTO agg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yowanɨ, ŋga se nindou dɨdɨyei sɨheimbo hürütürɨ-hündürɨ-rɨhündeimbɨmbo hɨpoambondɨhindürɨ. Asükai nɨnɨ-moatükunɨ nindoumbo sai mburɨmbo se yowanɨ bɨdɨfɨrɨ moatükunɨ hɨhɨrɨfe semɨndɨmbo hohoanɨmoyopoanɨ. Rananɨmbo se takɨnɨ afɨndɨ ndahümündi mbundɨhü asu God Nɨmoamo Hamɨndɨ ranahandɨ nɨmorɨndamboyafɨ. Nɨmboe aiana nindou dɨdɨyei hɨhɨfɨyo-rakoate asu moaruwai hohoanɨmoyei-rɨhündeimbɨ ranaheimbo aboedɨyuhani. ");
INSERT INTO agg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Se hɨpoambondo ndandɨ sɨhafɨ ape ai-amboanɨ hɨpoambore arandɨ nou.” ");
INSERT INTO agg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Se yowanɨ nindou ŋgoründɨ nɨŋgo ra türüfoefeihɨ papɨ-hoafɨpoanɨ. Asu rananɨmbo ŋgɨrɨ God ai sɨhei nɨŋgo ra türündandürühɨ papɨ-hoafɨndandürɨ. Se yowanɨ nindou ŋgoründɨ nɨŋgo ra yɨbobofeihɨ moaruwai-ane yaho hoafɨyopoan. Asu rananɨmbo ŋgɨrɨ God ai sɨhafɨ nɨŋgo ra yɨbobondeandühɨ moaruwai-ane mbüsu. Se nindou bɨdɨfɨrɨyei moaruwai hohoanɨmo ranahambo amboawi asei-anɨmbo God ai-amboanɨ sɨhei moaruwai hohoanɨmo ranahambo amboawi mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Se nindou bɨdɨfɨrambo asahündürɨ anɨmbo asu God ai sɨheimbo dagadürɨmbui. Refe süŋgu ana se afɨndɨ hamɨndɨ anɨmbo ndahümɨndeimboyei. Sapo se anɨhondümbo nindou farahehindɨ ranɨ sɨmogodühɨ anɨmbo sɨhei warambe babɨboai pɨtapɨndɨmboe. Se nɨnɨ sɨmogodühɨyo nindou bɨdɨfɨrambo farɨhehindɨ süŋgu-anɨmbo God ai sɨheimbo ranɨ sɨmogodühɨ randeandürɨmbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Asu Sisas ai ahamumbo kafoefe hoafɨ nda hoafɨmepurɨ: “Nindou mamɨ hɨmboatɨharɨ ai ŋgɨrɨ nindou ŋgorü hɨmboatɨharɨ-mayu ranahambo nderümündɨ haya nafɨ nafuindu ŋgu. Asu ai rawareandɨ ana, yɨboboambo hoe apoarambe pɨndamboyafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yamundɨfe nɨmorɨ ai ahambo yamundirɨ-randeimbɨ-mayu ahandɨ nɨmoamoyupoanɨ, ŋga muŋguambo yamundɨfe nɨmorɨ ahei yamundɨfe ratüpurɨ ra muŋgundoanɨ ana, asu aheimbo yamundu-rundeimbɨ-memo nahuraindeimboyei. ");
INSERT INTO agg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Asu se nɨmboe nindou ŋgoründɨ hɨmboarambe düdübudɨ akɨdou afoeru ranahambo yaŋgɨrɨ hɨmboapoyafühɨ asu sɨhafɨ hɨmboarambeahɨ nɨmoko bɨdɨfɨrɨ afoero ranahambo hoeifekoate-a? ");
INSERT INTO agg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nüŋgundo nindou ŋgorümbo hoafɨndafühɨya, ‘Wandafɨ, awi sɨhafɨ hɨmboarambeahɨ düdübudɨ akɨdou afoeru ra hündɨhehinɨ samboanahɨ,’ mambɨsafɨ sɨhafɨ hɨmboarambeahɨ nɨmoko bɨdɨfɨrɨ afoero ra sɨhafɨhoarɨ hoeifekoate-a? Seana yimbu yafambeimbɨ nindou-anafɨ! Weaŋgurühɨ se boatei-anɨmbo sɨhafɨ hɨmboarambe nɨmoko bɨdɨfɨrɨ afoero ra hündühoefɨ mbundambo-anɨmbo asu nindou ŋgoründɨ hɨmboarambe düdübudɨ akɨdou afoeru ra wudɨpoapondo hoeindowandühɨ hündühoefɨndo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Sisas ai hoafɨyuhɨ yahuya, “Nɨmɨ mamɨ aboedɨ hamɨndɨ ai ŋgɨrɨ hɨsɨ moaruwaimbü nɨŋgo. Asükai nɨmɨ mamɨ moaruwai ai-amboanɨ ŋgɨrɨ hɨsɨ aboedeimbɨ nɨŋgo. ");
INSERT INTO agg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Muŋguambo nɨmɨ ra ahandɨ hɨsayo ranɨ süŋgu-ane türüfoefeihɨ awi ranɨ nɨmɨ-ane eho. Se ŋgɨrɨ nɨmɨ hɨsɨ fik ra tɨhoarɨ tɨhoareimbɨ nɨmɨ-fihɨndɨ hüründandɨfɨ, asu ŋgɨrɨ yukui amurɨ nɨmɨ-fihɨndɨ hüründandɨfɨ. ");
INSERT INTO agg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nindou aboedɨ ai ahandɨ ŋgusüfoambe hohoanɨmoambeahɨ aboedɨ moatükunɨ arühayo ranane bokarɨhai arandɨ, ŋga asu nindou moaruwai ai ahandɨ ŋgusüfoambe hohoanɨmoambeahɨ moaruwai moatükunɨ arühayo ranane bokarɨhai arandɨ. Nɨmboe sapo nɨne-moatükunɨyo ŋgusüfoambe hohoanɨmo-ambeahɨ amaro ranane asu yafambe ai weindahɨ hoafɨyo arandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Sisas ai yahuya, “Asu se nɨmboe wambo ‘Adükarɨ, Adükarɨyei rɨhündühɨ asu wandɨ hoafayahɨ ra süŋgufekoate-ayeia? ");
INSERT INTO agg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nindou düdi ai wambo sowahɨ tüküfi wandɨ hoafɨ hɨmborɨyu mburambo ranɨ süŋguareandɨ anɨmbo asu ro ai nüŋgunahurai nindouayu ra sɨheimbo nafuindamboyahɨ? ");
INSERT INTO agg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Aiana sapo nindou worɨmbombo yahuhaya hɨfambe ndihɨ ragu kakɨra hanü mburambo kambohoanɨ nɨmoeiwamɨ mafemburɨfiyu nahurai-ani. Hoe ranai afɨndɨ hohoumboyohü worɨ ranahambo harɨyo randa moai fɨfɨmɨyo, nɨmboe sapo ai wudɨpoapore worɨmbora hayambowambo. ");
INSERT INTO agg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ŋga asu nindou düdi wandɨ hoafɨ hɨmborɨyu mbura ranɨ süŋgufekoate-ayu aiana sapo nindou worɨmbombo yahuhaya kambohoanɨ wudɨpoapofe feburɨfekoate-yuwanɨ asu hoe ranai hohoumboyohü worɨ ranahambo harɨyo randanɨ moanɨ mamɨharɨ bɨramɨndɨ pɨrɨmayo nahurai-ani. Asu bɨramɨndɨ pɨrɨmayo ra moanɨ afɨndɨ hamɨndɨ mamɨkarɨ pɨrɨmayo!” mehu. ");
INSERT INTO agg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sisas ai nɨmorehɨ nindowenihɨ ranɨ hoafɨ ra hoafɨyundürɨ mbura Kaperneamühɨ hu tükümefiyu. ");
INSERT INTO agg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nindou mamɨ Romɨhündɨ ami-yafe bogorɨ ranɨhü manüŋgu. Ranɨyu ahandɨ ratüpurɨyu-randeimbɨ ŋgusüfohündɨ ranai aŋgünümboyuhü yɨfɨmbo yaŋgɨrɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ami-yafe bogorɨ ai Sisas ranɨhü anüŋgu hoafɨ ra hɨmborɨyu haya ranɨyu ai Suda-yafe bogorɨ bɨdɨfɨrɨ koamarɨhepura ahambo hoafɨmbo mahɨfomo. Rananɨmbo ahandɨ ratüpurɨyu-randeimbɨ ra aboedɨmbɨrir-amboane yahu haya. ");
INSERT INTO agg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ai homo Sisas sowahɨ tüküyafu watɨharürühɨ yahomoya, “Ai nindou aboed-ani, ŋga se ahambo fandɨhaworɨ. ");
INSERT INTO agg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ŋga ai Suda yɨhoefɨmbo ŋgusüfohü pareamunɨ-randeimb-ani. Ŋga aiyu yɨhoefɨ rotu worɨ ra worɨmbomarandɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ranɨyu Sisas ai ranɨ-babɨdɨ hu worɨkɨmɨ tüküfiyuanɨ ami-yafe bogorɨ ai ahandɨ ŋgunindɨ Sisasɨmbo hoafɨmbo koamarɨ-hepura homo hoafɨyomondühɨ yahomoya, “Adükarɨ, ambe se tɨŋɨrɨfondamboyafɨ, ŋga ro nindou aboedɨyahɨ anɨmbo wandɨ worambe madügüfɨ, ŋga ro moai muŋguna wandɨ worɨna dɨdɨfɨ sahehea hohoanɨmoyahɨ. ");
INSERT INTO agg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ranɨmboanahɨ ro aboedɨ hamɨndɨ-yahanɨmbo sɨhambo sowana madɨdɨhɨ. Ŋga moanɨ se hoafɨ-yaŋgɨrɨ hoafɨndafanɨ wandɨ ratüpurɨyu-randeimbɨ ai aboedɨmbiyu-wamboane. ");
INSERT INTO agg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nɨmboe ro-amboanɨ nindou wandɨ nɨmoamo ndüreimbɨ-memo ranahamundɨ hoarehanahɨ, ŋga asu ami-anemo wandɨ hoarehemo. Ŋgorümbo hoafɨndahühɨ, ‘Se hafɨ,’ mbɨsahanɨ ai hu randühani. Asu ŋgorümbo hoafɨndahühɨ ‘Se sɨnɨfɨ,’ mbɨsahanɨ ai sünɨ randühani. Asu wandɨ ratüpurɨyu-randeimbɨmbo hoafɨndaha-ndowohümbo, ‘Ranɨ-moatükunɨ raro,’ sahanɨ, ai rareandühani,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Asu Sisas ai ranɨ hoafɨ ra hɨmborɨyu haya nindou ranahambo afɨndɨ mahepünɨfiyu. Ranɨyu hɨhɨrɨfi nɨmorehɨ nindowenihɨ afɨndɨ ranaheimbo hoafɨyundürühɨ yahuya, “Ro sɨheimbo hoafayahɨ. Ro moai anɨhondümbofe ndahurai ndühɨ hoeirɨheandɨ, Israerɨhündɨ amboanɨ, ŋga wanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ŋga sapo nindou ami-yafe bogorɨ ai koamarɨhepurɨ ranai homo worambe hoeirüwurane asu aboedɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Refe hayamboyoane, asu süŋgunambo ranambe nɨmai Sisas ai ŋgoafɨ mamɨ ahandɨ ndürɨ Nen ranɨnambo botɨfi mahafu. Ahambo süŋgururü-rundeimbɨyomo asu nɨmorehɨ nindowenihɨ afɨndɨmayei ranɨyei ai mamɨ mahahüsi. ");
INSERT INTO agg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sisas ai ndeara ŋgoafɨ ginɨrɨ nafɨtambekɨmɨ tüküfiyuane asu ŋgoafambe-ahɨndɨ aranɨhoafɨ yasɨmondɨ ranai tükümefeyo. Yɨfɨ nɨmoko ranana sapo nɨmorehɨ kai-mayo ranahandɨ nindowenihɨ nɨmorɨ moanɨ mamɨ hamɨndɨ-mayu ranaiyu. Ranɨyo asu nɨmorehɨ nindowenihɨ afɨndɨ ranɨ ŋgoafɨhündɨ ranai nɨmorehɨ ranɨ-babɨdɨmbo mamarei. ");
INSERT INTO agg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Asu Adükarɨ ai nɨmorehɨ ranahambo hoeireanda mayoa asu ahambo ŋgusüfoambe afɨndɨ hɨpoamboreandühɨ hoafɨyundühɨ yahuya, “Se yowanɨ aranɨndafɨndo-mboyafɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ranɨyu Sisas ai hu yɨfɨ safɨsendɨ-mayo ra sündɨmareanda asu nindou yɨfɨ nɨmoko masowandümo-memo ranai ŋgɨŋgɨnɨru manɨŋgomo. Ranɨyu Sisas ai hoafɨyuhɨ yahuya, “Nindou hoarɨfɨ ro sɨhambo hoafehanɨnɨ se haponda botɨyafo,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ranɨyu asu yɨfɨyumbɨ nindou-mayu ranai botɨfi nɨmarümbo wataporɨmayuamboyu asu Sisas ai nɨmorɨ ra ahandɨ hondandɨ warɨhümarirɨ. ");
INSERT INTO agg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ranɨyo asu nɨmorehɨ nindowenihɨ afɨndɨ ranai ŋgusüfo kɨkɨfoarɨhindühɨ Godɨmboya aiana aboed-ani sei hoafɨyahündowohü seiya, “Ahandɨ hoafɨ hoafɨyu-randeimbɨ adükarɨ hamɨndɨ ai yɨhoefɨ mbusümo tükümefiyu! Ai ahandɨ nendɨ ranaheimbo aboedambofe-ndürɨmbo tükümefiyu-ane!” masei. ");
INSERT INTO agg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sisas ai ranɨ-moatükunɨ rawareandɨ hoafɨ ranai muŋguambo Sudia hɨfɨ asu ranɨ hɨfɨkɨmɨ adaburo ranambe yaŋgorɨ wakɨmareanda hɨmborɨmayei. ");
INSERT INTO agg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sonɨmbo süŋgrurü-rundeimbɨ ai muŋgu moatükunɨ tükümefeyo ra ahambo wataporɨmbomarurɨ. ");
INSERT INTO agg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ranɨyu asu Son ai ahambo süŋgrurü-rundeimbɨ nindou yimbu mborai yahupɨrɨ hürühepɨrɨ haya Adükarɨmbo düdufimbohünda ahambo sowana koamarɨhepɨrɨ. Ahandɨ Adükarɨmbo düdufe hoafɨ ra yahuraiyo, ‘Nindou nda horombo ro tükündüfimbui masahɨ ranɨyafɨ, asu ŋgorü tükündɨfimbui mbɨsefɨ hohu hɨmbomandefɨyo?’ ");
INSERT INTO agg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Asu ai Sisasɨmbo-so tüküyafɨneandühɨ hoafɨyafɨnandowohü safanɨya, “Son hundürüra-randeimbɨ ai sɨhambo refe düdufenɨnɨmbo yɨhoehɨmbo koamarɨhemuna masɨnehɨ. Se nindou tükündüfimbui mehuyafɨ, asu ŋgorü tükündüfimbui mbɨsefɨ hohu hɨmbomandefɨyo,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Moanɨ ranɨ-sɨmboanɨ hamɨndɨ ranɨhü Sisas ai nɨmorehɨ nindowenihɨ afɨndɨ fi moaruwaimbü, aŋgünümbɨ, moaruwai nendɨ nɨmarümbɨ ranaheimbo aboedɨreandürɨ asu hɨmboatɨharɨ afɨndɨ ranaheimbo hɨmboarɨ bɨrɨhendüranɨ asükai hɨmboarɨyei rarao marɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sisas ai Sonɨmbo süŋgurɨnɨrɨ-rɨnandeimbɨ ranahafanɨmbo sɨmborɨ hoafɨyupɨrühɨ yahuya, “Se ŋgafanɨ Sonɨmbo hoafɨndafanɨ se nɨne-moatükunɨ hoeirɨne hɨmborɨyafanɨ marɨnandɨ ra: Ranɨ-moatükunɨ ra sapo hɨmboatɨharɨ ai asükai hɨmboarɨ bɨrɨhehi hɨmboarɨyei, tɨŋarɨ moaruwaimbɨ ai botɨyahi hei, fi moaruwaimbü, mɨmanɨho masɨmeimbɨ ai aboedɨ popoatapo-foarɨhi. Hɨmbotühüfo ai asükai hoafɨ hɨmborɨ-yei, yɨfɨyeimbɨ ai yaŋgɨrɨ botɨyahi asu aboedɨ hoafɨ ra nindou napokoate-yeimbɨ-mayei aheimbo wataporɨmboyo ramarandɨ ranahambo. ");
INSERT INTO agg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nindou dɨdɨyei wambo anɨhondümbo-arɨhindɨrɨ ai-ana hɨhɨfɨ-hɨhɨfɨmbeiyei-amboane!” mehu. ");
INSERT INTO agg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Sonɨmbo süŋgurɨne-rɨnandeimbɨ mefanɨ ranai hafandane süŋgunambo Sisas ai Sonɨmbo nɨmorehɨ nindowenihɨ-mayei ranaheimbo hoafɨyundürühɨ yahuya: “Sapo se Son sowana nɨmɨwohɨ furɨkoate-reandühɨ heihü ra se nɨnɨ-moatükunɨmboyei tüküfeyoanɨ hoeifembo sei hehi hohoanɨmomayei a? Awi se boabodarɨ emündü werɨnambo mboahurɨ-hendanɨ ra hoeifemboyei mahei? ");
INSERT INTO agg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nɨnɨ-moatükunɨ hoeifemboyei se mahei rana? Awi nindou hoearɨ moanɨ ranɨ-poanɨmbo aboedɨ hoearɨ yihuruyu haya nüŋguwanɨ hoeifemboyei mahei? Ra wanɨ. Nindou yahurai hoearɨ aboedɨ yihuru-rɨhümündeimbɨ ana, adükarɨ bogorɨndɨ worambe-ane nɨmboei arɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Se wambo ndühɨ yarɨhi hoafɨyahündɨrɨ sapo se nɨnɨ-moatükunɨ hoeifemboyei mahei ra? Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou ranahambo hoeifimboyei? Yɨnɨ ra anɨhond-ane Godɨndɨ hoafɨ hoafɨyu-randeimbanisɨ, ŋga ro nda sɨheimbo anɨhondümboanahɨ hoafayahandürɨ. Son aiana Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou ranahambo ŋgasündireimb-ani. ");
INSERT INTO agg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Son ranahamboyo Godɨndɨ Bukambe yare hoafɨyowohü yahoya, ‘Ro nindou mamɨ wandɨ hoafɨ semɨndɨ hombohünda koandɨhehinanɨ, ai boatei se hokoate-yafambe ŋgumbui sɨhafɨ nafɨ nafɨrɨhefembohünda,’ meho,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sisas ai bɨdɨfɨrɨ hoafɨ pareandühɨ hoafɨyuhɨ yahuya, “Son ana nindou moanɨ adükarɨ hamɨndɨyu haya asu ai nindou horombo manɨŋgomo ahamumbo ŋgasündeapureimb-ani. Ŋga asu nindou düdi ai sapo God ŋgɨnɨndɨ hɨfandarandɨ ranambeahɨndɨ akɨdou aiyu aiana Sonɨmbo ŋgasündirümboani,” mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Muŋguambo nindou ai Sonɨndɨ hoafɨ hɨmborɨyei hehi asu takis kakɨ sowandümo-rundeimbɨ nindou-amboanɨ muŋguambo rarɨhi hoafɨyeihɨ seiya, “Yɨnɨ, Godɨndɨ hohoanɨmo ranana anɨhondü hondü mbumundane,” masei. Ranɨyei asu süŋgunambo ai ahandɨ warɨhü hundürümayei. ");
INSERT INTO agg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ŋga Farisi nindou-yomo asu Suda-yomondɨ ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ-yomo ranai ahamundɨhoarɨ Godɨndɨ hohoanɨmo ra hɨmborɨ-yowohü süŋgufembo moei mehomo. Ranɨmboemo ai moai Sonɨndɨ warɨhü hundürüyomo. ");
INSERT INTO agg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sisas ai hoafɨyuhɨ yahuya, “Nɨmorehɨ nindowenihɨ hapodanambe anɨmboei ndanaheimbo ro nɨnɨ-moatükunɨfihɨ sɨmoŋgorɨndɨhe hoeimandɨheara? Nindou nda ai nüŋgunahurai nindouyei ndana? ");
INSERT INTO agg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nindou ndanai ana sapo nɨmorɨ akɨdɨbou ŋgoafɨhü nɨnouyeimbo nahurai-anei. Sapo ai nɨmareimbo bodɨmondɨ nɨmoakɨdɨboumbo rarɨhi hoafɨyeihɨya, ‘Ro sɨheimbo fufuŋɨnambo fufuŋɨ-mehundürɨ, ŋga asu se moai botɨyahi yirɨwarɨ moporɨyei! Ro sɨheimbo weŋgɨsahoafɨnambo marɨhundürɨ, ŋga asu se moai aranɨhoafɨrɨhündɨ ranɨ ranɨmayei!’ nahurai-anei. ");
INSERT INTO agg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Son sapo nindou hundürüra-randeimbɨ-mayu ranana tüküfi sesɨ sesü, wain hoe sɨmɨndɨ rakoate-mayua, asu se hoafɨyehüya, ‘Ahandɨ fiambe ana moaruwai nendɨ nɨmarɨmboane,’ masei! ");
INSERT INTO agg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Asu Nindou Hondü ai tüküfi sesɨ sesü, hoe sümündɨ marandambo, asu se hoafɨyeihɨya, ‘Nindou ranahambo hoeirɨhorɨ! Aiana sesɨ afɨndɨ sesü asu ŋgɨnɨndɨ wain hoe sümündɨ arandɨ. Aiana nindou takis kakɨ sowandümo-rundeimb-anemo asu nindou moaruwai wosɨhoaforɨ hohoanɨmoyomo-rundeimb-anemo ranahamundɨ ŋgunind-ani!’ masei. ");
INSERT INTO agg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ŋga asu nindou dɨdɨyei Godɨndɨ-mayo fɨfɨrɨfe ra anɨhond-ane sei sahümündimbɨ aiana ranɨ fɨfɨrɨfe ra anɨhondümbo nafuiyeihanei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi nindou ai Sisasɨmbo sesɨmbohünda ro-dɨbo dowadɨfɨ mehundo-wamboyu asu Sisas ai ahandɨ worambe hu farɨfi hafu mamaru. ");
INSERT INTO agg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ranɨ ŋgoafɨhü nɨmorehɨ mamɨ ai nindowenihɨ bɨrabɨrɨ hohoanɨmoyo-randeimbɨ manɨŋgo. Sisas ai Farisi nindoundɨ worambe sesɨ sesühɨ amaru hoafɨ ra hɨmborɨyo haya, asu ai arabasta nɨmoei kakɨ afɨndɨ fihɨ semɨndümbɨ hɨpɨrambe fɨsɨŋarümbɨ moatükunɨ hɨpɨrɨ tüküre semɨndɨ haya maho. ");
INSERT INTO agg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ranɨyo ai ho Sisasɨndɨ daboadanɨ yirɨkɨmɨ nɨŋgombo aranɨyowohü Sisasɨndɨ tɨŋarɨ ra ahandɨ aranɨhɨmboaho-mayo ranambo popoaimarandɨ. Ranɨyo asu ai Sisasɨndɨ tɨŋarɨ ra ahandɨ mbɨrɨnaŋɨ ranambo nɨŋombɨrɨhoayoa yahohaya gedühai mbura wakɨkɨhɨrapɨrühɨ fɨsɨŋarümbɨ moatükunɨ ra tɨŋarɨ yimbumefanɨ ranɨwamɨ kamafoareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Asu Farisi nindou Sisasɨmbo mborai mehundo ranai ranɨ-moatükunɨ ramareanda hoeire haya ahandɨ fimbo hoafɨyuhɨ yahuya, “Nindou nda anɨhondü Godɨndɨ hoafɨ hoafɨyu-randeimbayu ana, ai nɨne nɨmorehɨ ahambo sündarerɨ nda fɨfɨrɨndeambui. Asu moaruwai yahurai nindowenihɨ bɨrabɨrümbɨ nɨmorehɨ anɨŋgo ranahambo fɨfɨrɨndeambui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Saimon, ro sɨhambo hoafɨyonɨnɨmbo hoafɨ moai sɨheheandɨ,” mehundowamboyu. Asu Saimon ai ahambo hoafɨyundühɨ yahundoya, “Yɨnɨ, Yamundo-randeimbɨ nindou se wambo ndühɨ hoafɨyafɨndɨrɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Asu Sisas ai piyu haya hoafɨyuhɨ yahuya, “Nindou yimbu nɨmbafanɨ henamboyafanɨ ai nindou ŋgoründɨ-mayo kakɨ sɨmborɨ hɨhɨndɨho ndehoamboehɨ safanɨ hena masowandɨfanɨ. Nindou ŋgorü ai sapo kakɨ sairandeimbɨ-mayu ranahandɨ-mayo 500 kakɨ hoarɨ semündu süŋgunambo sɨmborɨ saimbohünda asu nindou ŋgorü-mayu ranai 50 kakɨ hoarɨ semündu süŋgunambo sɨmborɨ saimbohünda. ");
INSERT INTO agg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nindou yimbu ranai kakɨ masowandɨfanɨ ra sɨmborɨ hɨhɨrɨfe saimbo kakɨkoate-mefandamboyu asu nindou ranai ambe mehupɨrɨ. Nindou yimbu ra dɨdɨ ai nindou-mayu ranahambo ŋgusüfo afɨndɨ pamandira?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Asu Saimon ai sɨmborɨ ahambo hoafɨyundühɨ yahuya, “Ro rarɨhe hohoanɨmoayahɨ ana, nindou sapo ahambo kakɨ adükarɨ masagado ranai-anɨmbo afɨndɨ hamɨndɨ ŋgusüfo pandirümbui.” Ranɨyu Sisas ai yahuya, “Yɨnɨ, se anɨhondümboanafɨ hoafayafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ranɨyu asu ai nɨmorehɨ-mayo ranahambo sowana hɨhɨrɨfihɨ Saimonɨmbo hoafɨyundühɨ yahuya, “Se nɨmorehɨ ndanahambo moai hoeirowandɨyo? Ro sɨhafɨ worambe mafareheandɨ, ŋga asu se moai wambo hoe sawandɨrɨ wandɨ tɨŋarɨ popoaimbohünda. Ŋga asu nɨmorehɨ ndanaiyo wandɨ tɨŋarɨ ra ahandɨ aranɨhɨmboahonambo popoaira mbura ahandɨ mbɨrɨnaŋɨnambo gedümarandɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Seana moai wambo sowandɨfɨndɨrɨ worɨnɨrowandɨrühɨ wakɨkɨhɨrandɨrɨ, ŋga wanɨ. Ŋga nɨmorehɨ ndanai ana ro sühühambe peyo haya wandɨ tɨŋarɨ ra moai wakɨkɨhɨ hɨnɨŋgɨreandɨ, ŋga wakɨkɨhɨ hoafɨna hohombo haponda tükefeyo. ");
INSERT INTO agg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Se moai wambo mbɨroambe kefembohünda orif nɨmɨ hɨsɨ boboe dɨdɨboadɨro sɨhawandɨ, ŋga nɨmorehɨ aiyo wandɨ tɨŋarɨ ra fɨsɨŋarümbü moatükunɨ ranambo kamareandɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ranɨmboanahɨ ro sɨhambo hoafehanɨnɨ, nɨmorehɨ ndanai ahandɨ hohoanɨmo moaruwai afɨnd-ane, ŋga ranahambo God ai amboawi mehu. Nɨmboe sapo ai wambo ŋgusüfo afɨndɨ pamareandɨrɨ. Ŋga asu nindou daboe ahambo moanɨ akɨdou yaŋgɨrɨ amboawi yahoweimbɨ nindou ana ai moanɨ akɨdou yaŋgɨrɨ ŋgusüfo pareandɨrühani,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ranɨyu asu Sisas ai nɨmorehɨ-mayo ranahambo hoafɨyundowohü yahuya, “Sɨhafɨ hohoanɨmo moaruwai ranana ro amboawi samboanahɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ranɨyo asu nindou bɨdɨfɨrɨ sesɨ fondɨkɨmɨ mamarɨmo ranai ahamundɨ mbusümo hoafɨyomondühɨ yahomoya, “Nindou nda düdi moaruwai hohoanɨmo amboawi yahu aranda?” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ŋga asu Sisas ai nɨmorehɨ-mayo ranahambo hoafɨyundühɨya, “Sɨhafɨ anɨhondümbofe hohoanɨmo ranamboyo sɨhafɨ moaruwai hohoanɨmo ranambeahɨndɨ aboedambo-marɨheanɨnɨ, ŋga se ŋgusüfo afurɨndo kündo hawa ŋgafɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ranümbɨ ra kɨkefoendane, asu süŋgunambo Sisas ai adükarɨ ŋgoafɨ asu akɨdou ŋgoafɨ ranambe huhü God ŋgɨnɨndɨ hɨfandarandɨ ranahambo wataporɨmbo-marandɨ. Sisasɨmbo süŋgururü-rundeimbɨ 12 ai Sisasɨndɨ süŋgu mahomo. ");
INSERT INTO agg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Ranɨyei asu nɨmorehɨ bɨdɨfɨrɨ dɨdɨyei moaruwai nendɨ nɨmarɨndüreimbɨ asu aŋgünɨ moaruwaimbü Sisas ai aboedɨmarearü amboanɨ ahandɨ süŋgu mahei. Nɨmorehɨ-mayei ranai ana Maria Makdarahündɨ, sapo Sisas ai moaruwai nendɨ 7 ahandɨ fiambeahɨndɨ raguanambo-reandeimbɨ-mayo ranayo, Soana, Kusandɨ nɨmorehɨ, nindou ranai Herodɨndɨ worɨ hɨfanda randeimbɨ-mayu ahandɨ nɨmorehɨyo, Susana asu nɨmorehɨ bɨdɨfɨrɨ sapo ahei kakɨnambo Sisas asu ahandɨ hoafɨ sowandümo homo-rundeimbɨ farɨhehipurɨ-rɨhündeimbɨ-mayei amboanɨ ai-babɨdɨ mahei. ");
INSERT INTO agg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nindou afɨndɨ ranai ŋgorü ŋgoafɨhündɨ ŋgorü ŋgoafɨhündɨ kɨkɨrɨhefekoate Sisas sowana nümbünɨ tümarɨhinda, ndanɨ kafoefe hoafɨ hoafɨyundürühɨ yahuya, ");
INSERT INTO agg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nindou mamɨ ai sesɨ ahurɨ semündü hu bubufoareandane, asu bɨdɨfɨrɨ nafɨkɨmɨ pütapɨmayo. Nindou ai hahabodeihü pütapɨyeiane, asu ndu ai nɨmoamonɨndɨ pühɨyei masahüsi. ");
INSERT INTO agg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bɨdɨfɨrɨ ahurɨ ranai nɨmoei boatɨfowamɨ pütapɨyo mbura tüküfehündamboyo asu yapataparɨmayo hɨfɨ ranai hoe puiarɨ-koate nɨŋondɨ hamɨndɨwambo. ");
INSERT INTO agg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Asu bɨdɨfɨrɨ ai wohɨ tɨhoarɨ tɨhoarümbɨ nɨnouyoambe pütapɨyo mbura ranɨ dɨbore tüküfihɨyo asu wohɨ ranambo gabudɨ-mafoareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ŋga asu bɨdɨfɨrɨ ahurɨ ranai hɨfɨ aboedambe pütapɨyo haya tütükɨyowohüyo 100, 100-mbore hɨsɨmayo.” Sisas ai ranɨ hoafɨ ra moendɨfembo yahumbo hoafɨyuhɨ yahuya, “Nindou düdi ai hɨmboambeimbɨ-nduhü ana, hoafɨ ra hɨmborɨmbiyu-wamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","10","Ranɨyomo ahambo süŋgrurü-rundeimbɨ ai ranɨ hoafɨ ranahandɨ nɨmɨndɨ ranahambo düdumefundo-wambo hoafɨyupurühɨ yahuya, “Sɨhamumbo ana God ŋgɨnɨndɨ hɨfandarandɨ dɨbohɨndɨ hoafɨ ra masayopurane, ŋga nindou amurɨ ranaheimbo ana kafoefe hoafɨnamboane hoafayondürɨ. Rananɨmbo ai hɨmboarɨ-ndeimboyei, ŋga ŋgɨrɨ hoeindɨhindɨ asu hɨmborɨ-ndeimboyei, ŋga ŋgɨrɨ fɨfɨrɨndɨhindɨ.” ");
INSERT INTO agg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Kafoefe hoafɨ ranahandɨ nɨmɨndɨ ra ndahurai-ane. Sesɨ ahurɨ ra Godɨndɨ hoaf-ane. ");
INSERT INTO agg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sapo sesɨ ahurɨ nafɨnɨ pütapɨmboyowohü pütapɨmayo ranana nindou dɨdɨyei hoafɨ hɨmborɨyeihaneisɨ, ŋga asu Satan ai ahei ŋgusüfoambeahɨndɨ semündü pireandühani. Sapo Satan ranai aheimboya anɨhondümbo-ndɨhi hehi aboedambo-ndahimboyei yahuhaya. ");
INSERT INTO agg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sesɨ ahurɨ sapo nɨmoei boatɨfowamɨ pɨmayo ranana nindou dɨdɨyei hoafɨ ranahambo hɨmborɨyei hehi sahümündihɨ hɨhɨfɨ-hɨhɨfɨyeihaneisɨ, ŋga ahei ŋgusüfoambe hoafɨ ra moai kɨkɨmɨfoare nɨmarondürɨ. Ai hoafɨ ranahambo anɨhondümbo-rɨhindühaneisɨ, ŋga asu nɨne-moatükunɨ aheimbo refe hoeifendürɨmbo tüküfeyoambe ai peyeihanei. ");
INSERT INTO agg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sesɨ ahurɨ wohɨ tɨhoarɨ tɨhoarümbɨ mbusümo pütapɨmayo ranana, sapo nindou dɨdɨyei ai hoafɨ ra hɨmborɨyeihaneisɨ, ŋga asu afɨndɨ hohoanɨmo, kakɨ napo sɨhefe hohoanɨmo, hɨfɨ ndanɨhündambo hɨhɨfɨ-hɨhɨfɨ hohoanɨmo ranai gabudɨ-foareandüranɨ asu ai aboedɨ hɨsɨkoate-ayei nahurai-ane. ");
INSERT INTO agg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sesɨ ahurɨ hɨfɨ aboedambe pɨmayo ranana, sapo nindou dɨdɨyei ai hoafɨ ra hɨmborɨyei hehi ŋgusüfoambe kɨkɨhɨ-safɨmarɨhümündi-anei. Ai ahei hohoanɨmoambe dɨdɨboadorɨhoeimbɨ hamɨndɨ hondü nɨmarɨndürɨmboyo asu ai hɨsɨ aboedɨ tükümefendürɨ.” ");
INSERT INTO agg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nindou mamɨ ai moai ram hai ra yimunde mbura wambürɨnambo gabude, asu fondɨ hoarehɨ ninde randɨ, ŋga wanɨ. Sapo aiana yimunde mbunda ram hai nindɨferambo fondɨ-mayo ranɨwamɨ nɨmoamo anɨmbo nindeandanɨ nindou dɨdɨyei worambe keboehindühɨ hoeindɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nɨne-moatükunɨ dɨbo meŋgoro ranai ana weindahɨ moanambühɨ tükündɨfemboe. Nɨne-moatükunɨ nindou ai gabudɨhi masɨhehindɨ ranai ana weindahɨ hai sihɨ tükündɨfeyoanɨ hoeindɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Awi se hɨbadɨhümbo, hɨmbo yaŋgɨrɨ kündɨhi nɨmandei. Nindou düdi hohoanɨmo ra ndore fɨfɨrareandɨ ana, God ai adükarɨ ndagadombui. Ŋga nindou düdi ndofe fɨfɨrɨfekoate-ayu ana, nɨne akɨdou fɨfɨrɨmareandɨ amboanɨ God ai raguanambo-ndeambui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sisasɨndɨ hondɨyo asu ahandɨ akɨdɨ mamɨyomo ranai Sisasɨmbo hoeifimbo tükümehindɨ, ŋga ai nɨmorehɨ nindowenihɨ afɨndɨ ranɨ mbusümowambo moai ahandɨ fikɨmɨ papühüyahindɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ranɨyei nindou bɨdɨfɨrɨ ai Sisasɨmbo hoafɨyahündowohü sahündoya, “Sɨhafɨ me-ane asu amondɨ mam-anemo ai weindanɨ anɨmboei sɨhambo hoeifenɨnɨmbo seimbo,” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Asu Sisas ai nindou ranaheimbo muŋguambo yare hoafɨyundürühɨ yahuya, “Nindou dɨdɨyei ai Godɨndɨ hoafɨ hɨmborɨyei mburɨhü süŋguarɨhindɨ ranai-anei wandɨ me asu akohoandayomo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mamɨmbo Sisas ai ahambo süŋgrurü-rundeimbɨ babɨdɨmbo botambe fareafundühɨ hoafɨyupurühɨ yahuya, “Awi sɨhɨrɨ kurɨhoe ranɨ goesürünɨ bandɨhehu ŋgefo,” yahupurɨ haya mahomo. ");
INSERT INTO agg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ai botambe homondühɨ-yomo asu Sisas ai yapombofi meŋguru. Ranɨyo asu ŋgɨnɨndɨ hamɨndɨ hoewerɨ ranai kurɨhoe-mayo ranambe tüküfehüyo, hoe botambe tüküfehü asu ai ndeara hɨmonɨ hanɨmbo yaŋgɨrɨmemo. ");
INSERT INTO agg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ranɨyomo asu ahambo süŋgrurü-rundeimbɨ ai Sisas sowana homo yaŋgɨrɨrüwurɨ hoafɨyomo-ndowohü yahomoya, “Adükarɨ! Adükarɨ! Sɨhɨrɨ ndeara yɨfɨmbo yaŋgɨrayefɨ,” mehomondamboyu. Asu Sisas ai botɨfi hoewerɨmayo ranahambo awi-awimefiyu-wamboyo afureandühɨyo asu hoe ranai afure mafoero. ");
INSERT INTO agg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ranɨyu Sisas ai ahamumbo yare hoafɨyupurühɨ yahuya, “Asu sɨhamundɨ anɨhondümbofe ra nüŋguia?” mehupuramboemo. Asu ai hepünafu yɨhɨmbo sɨsɨreapurühɨ sɨmborɨ hoafɨyafundühɨ yahomoya, “Nindou nda düdi rana? Ai moanɨ hoewerɨ ranahambo awi-awimefiyuwa ahandɨ hoafɨ hɨmborɨyowohü afurɨmareandɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sisas ai ahambo süŋgrurü-rundeimbɨ babɨdɨmbo Gerasa-yafe hɨfɨnambo Gariri hoe gogoasürünɨ homo tükümefundɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tüküyafu mburu botambeahɨndɨ kusɨfoendane nindou mamɨ ranɨ ŋgoafɨhündɨ moaruwai nendɨ nɨmarɨndoweimbɨ ranai ahambo sowanambo mahu. Aiana horombo hondü piyu haya moai hoearɨ güdeandɨ, ŋga moanɨ yare safoeyapo manüŋgu-ane. Ai ŋgoafɨhü nɨŋgokoate yɨfɨ sɨhehi rɨhündeimbɨ hoŋguambeyu nüŋgu marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nindou ranai Sisasɨmbo hoeirirühɨ puküna heiyuhü yirɨkɨmɨ piyu nɨmarümbo hoafɨyuhɨ yahuya, “Sisas, God Nɨmoamo Hamɨndɨ Hondündɨ nɨmorɨ, se wambo nüŋgufendɨrɨmbo safomboyafa? Ro sɨhambo hüti hoafarɨhanɨnɨ se yowanɨ wambo tɨŋɨrɨfo ndawandɨrɨmboyafɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nindou ranai yare hoafɨmayu ra sapo Sisas ai moaruwai nendɨ ranahambo hoafɨmayundoa kosɨfoendühɨyo. Afɨndɨmbo moaruwai nendɨ ranai kɨkɨhɨrɨmɨndɨ nɨmaroanɨ asu muŋguambo nindou ranai hɨmboarɨ safühɨrurühɨ senɨnambo hüputüpu-rɨhawuranɨ ai ranɨ-moatükunɨ ra gurɨhai haya moaruwai nendɨ ranai fare serɨmɨndɨ haya nɨmɨ wohɨ furɨkoate-yowanɨ ho-marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sisas ai ahambo düdufihɨ yahundoya, “Ndürɨ sɨhafɨ nɨnea?” mehundowamboyu. Asu ai sɨmborɨ hoafɨyundühɨ yahuya, “Wandɨ ndürɨ ana Awai nindou-ane.” Ai yare hoafɨmayu ra sapo moaruwai nendɨ afɨndɨ ranai ahandɨ fiambe mamarei ranɨmboyu. ");
INSERT INTO agg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Moaruwai nendɨ-mayei ranai Sisasɨmbo hüti hoafɨyahündowohü seiya, “Se yɨhoefombo nɨmbɨ nɨmarümbɨ hɨfambe ranambe koandɨhawamunɨ-mboyafɨ,” masahündo. ");
INSERT INTO agg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ranɨyo asu moatei afɨndɨ ranai hɨrɨpɨnɨnɨ hɨmborɨhündühɨ burɨmayei-amboyo moaruwai nendɨ ranai Sisasɨmbo moatei ranahei fiambe koarɨhefendürɨmbo hüti-hütimarɨhora koamarɨhendürɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ranɨyei nindoundɨ fiambeahɨndɨ kosɨfoehi hehi moateiyei fiambeyahindühɨ asu moatei ranai hɨrɨpɨnɨnɨ pɨpɨnambo hanei kurɨhoeambe pɨyei hoe karɨhüsi hehi yɨfɨsafɨmayei. ");
INSERT INTO agg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nindou moatei hɨfandɨmarundɨ ranai hoeirunda mayoa, pɨpɨyomo homo ranɨ ŋgoafɨhü asu nümbürambe ratüpurɨyeihɨ burɨmayei ranaheimbo hoafɨhümarundürɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nindou ranai nɨnɨ-moatükunɨyo tükümefeyo sei hehi hoeifembo Sisasɨmbo-so tükümehindɨ. Ranɨyo tüküyahi hoeirɨhindane, nindou moaruwai nendɨ nɨmarɨ haya kosɨfoendeimbɨ-mayu ranai ahandɨ yirɨ kɨmɨ hoearɨ yihuruyu mbura hohoanɨmo aboedɨ koadürü hohoanɨmoyu arandɨ süŋgu mamaruwa hoeirɨhorühɨ yɨhɨmbo sɨsɨrɨmehindɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nindou hoeifembo mahüsi ranai Sisas nindou aboedɨ-marirɨ ra hoeirɨhi hehi nindou bɨdɨfɨrambo wataporɨmbo-marɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ranɨyei asu muŋguambo nindou Gerasa hɨfɨhündɨ ranai yɨhɨmboyeihɨ Sisasɨmbo ragu ŋgafɨ maseia asu botambe farɨfi haya ndamefiyu. ");
INSERT INTO agg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Ranɨyu asu nindou moaruwai nendɨ nɨmarɨ haya kosɨfoendeimbɨ-mayu ranai Sisasɨmbo hüti hoafɨrürühɨ yahuya, “Wambo se yɨnɨ safanɨmbo se-dɨbo dɨdɨ,” mehundo-wamboyu. Asu ai ahambo koarɨheirühɨ yahuya, “Se ŋgoafɨna ŋgafɨ nɨnɨ-moatükunɨyo God ai sɨhambo ramareanɨnɨ ra nindou bɨdɨfɨrambo wataporɨmbo-ndandɨ,” mehundo. Ranɨyu asu hu nɨne-moatükunɨ Sisas ai ahambo ramarirɨ ranahambo ranɨ ŋgoafɨhündɨ-mayei ranaheimbo wataporɨmbo-marandürɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sisas ai asükai Gariri ŋgorü-goanɨnɨ hu tükümefiyu-wamboyei nɨmorehɨ nindouwenihɨ ranai ahambo hɨhɨfɨ-hɨhɨfɨmayei, sapo hɨmbomayei hei ranɨmbowambo. ");
INSERT INTO agg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ranühɨ asu nindou mamɨ ahandɨ ndürɨ Sairus ranɨ ŋgoafɨhü rotu worɨ hɨfandɨra-randeimbɨ ai Sisasɨndɨ yirɨkɨmɨ tüküfi pɨyu nɨmarümbo wandɨ worɨna dügüfɨ yahu haya hüti-hoafɨmarürɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ai sapo ahandɨ nɨmorehɨ nɨmorɨ 12 hɨmbanɨ mamɨ yaŋgɨrɨyo haya yɨfambo-mayowamboyu ramefiyu. Sisas ai Sairusɨndɨ worɨna hüfuane, asu nindou afɨndɨ ranai aŋgoaŋgo-marɨhorɨ hei. ");
INSERT INTO agg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ahei mbusümo nɨmorehɨ mamɨ 12 hɨmbanɨmbo amoamo watɨkoafɨmboyo mara ho ranai manɨŋgo. Ai ahandɨ aŋgünɨ ra aboedɨfembohünda doktambo hoeifepurɨmbo kakɨ afɨndɨ sai marandɨ, ŋga asu nindou dɨdɨ ai-amboanɨ moai aboedɨreandɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nɨmorehɨ ranai Sisasɨndɨ daboadanɨ ho nɨŋgombo hoearɨ hɨmborɨ-mayo ranɨfihɨ masündeandamboyo asu ahandɨ horɨ ranai moanɨ ranɨ-sɨmboanɨ hamɨndɨ kɨkɨmarɨhoayo. ");
INSERT INTO agg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ranɨyu asu Sisas ai düdufihɨ yahuya, “Düdi wandɨ hoearɨ masündeanda?” mehuamboyo. Asu muŋguambo nindou ranai wanɨwanɨyeihɨ dɨdɨmomayei-amboyo asu Pita ai hoafɨyuhɨ yahuya, “Adükarɨ, nindou afɨndɨ ranai sɨhafɨ fikɨmɨ wakɨre yaŋgorɨmbo sɨmborɨ koarürɨmayei,” mehundowamboyo. ");
INSERT INTO agg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Asu Sisas ai hoafɨyuhɨ yahuya, “Nindou ŋgorü ai wambo masündeandɨra wandɨ fiambeahɨndɨ ŋgɨnɨndɨ ranai makosɨfoendɨ ranɨmboanahɨ,” mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Asu nɨmorehɨ ranai wambo fɨfɨrɨhi-ndɨrɨmboanei, ŋga ro ŋgɨrɨ dɨbo nɨmboahɨ yahohaya, hɨhamɨndarɨ kameihɨ ho Sisasɨndɨ yirɨkɨmɨ pɨyo mamaro. Ranɨyo ai muŋguambo nindouyei hɨmboahü wataporɨmbo-marandɨ nɨmboe masünderɨ asu nünüŋgureamboyo ranɨ-sɨmboanɨ hamɨndɨ aboedɨmayo ranahambo. ");
INSERT INTO agg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sisas ai nɨmorehɨ ranahambo yahundoya, “Nɨmorɨ akɨdou, sɨhafɨ anɨhondümbofe ranai sɨhambo aboedɨmareanɨnɨ, ŋga se ŋgusüfoambe afurɨndo kündo hawa ŋgafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ai wataporɨmbo-randühɨ nüŋguambe, nindou mamɨ ai hɨfandɨra-randeimbɨndɨ worambeahɨndɨ tüküfi hu hoafɨyuhɨ yahuya, “Sɨhafɨ nɨmorɨ ana yɨfɨmayo, ŋga se yamunde-randeimbɨ-mayu ranahambo tɨŋɨrɨfo dabadomboyafɨ,” mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sisas ai ranɨ hoafɨ ra hɨmborɨyu haya, Sairusɨmbo hoafɨyunduhü yahuya, “Se yɨhɨmbondamboyafɨ, ŋga anɨhondümbo-ndowandanɨ anɨmbo sɨhafɨ nɨmorɨ ra aboedɨndɨmboe,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ai nɨmorehɨ-mayo ranahandɨ afɨndandɨ worambe hu tüküfi haya moai nindou amurɨ semündündürɨ worambe kefuendɨ, ŋga Pita, Son, Sems asu nɨmorɨndɨ hondafɨndɨ aheimbo yaŋgɨrɨyo süŋgurearü haya mahüfu. ");
INSERT INTO agg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nindou afɨndɨ ranɨhü mamarei ranai nɨmorɨ ranahambo hohoanɨmoyeihɨ aranɨhoafɨ-marɨhündamboyu Sisas ai yahuya, “Ai ana yɨfɨyombo-yopoanɨ, ŋga ŋgɨrɨ aranɨhoafɨ-ndɨhünda,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nindou ranai nɨmorɨ yɨfɨmayo ra fɨfɨrɨhindɨ, ranɨmboyo Sisasɨmbo tɨkɨfɨnambo-rɨhorühɨ tɨrɨfoefe hoafɨmayahündo. ");
INSERT INTO agg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ŋga ai nɨmorɨ-mayo ranahandɨ warɨhü kɨkɨhamündü hoafɨyundowohü yahundoya, “Nɨmorɨ akɨdou, se botɨyafo,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Asu ahandɨ yifiafɨ ranai hɨhɨrɨfe ho fiambe farɨfehüyo asükai botɨmefeyo. Ranɨyo Sisas ai nɨmorɨ ranahambo sesɨ sahündo yahu haya hoafɨmayundürɨ. ");
INSERT INTO agg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Asu hondafɨndɨ ai hoeirɨneanda mayoa mahepünafɨ-neandamboyu Sisas ai ranɨ-moatükunɨ tükümefeyo ranahambo “Nindou ŋgorümbo yowanɨ hoafɨpoanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sisas ai ahambo süŋgrurü-rundeimbɨ 12 ranahamumbo mborai yahupurɨ hürühepurɨ haya moaruwai nendɨ asu muŋguambo aŋgünɨ aboedɨferambo ŋgɨnɨndɨ adükarɨ masagapurɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ranɨyu God ŋgɨnɨndɨ hɨfandarandɨ ranahambo wataporɨmboyo asu aŋgünɨ aboedɨfe-rambohünda koamarɨhepurɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ai ahamumbo yare hoafɨyupurühɨ yahuya, “Sɨhamundɨ hoahoaŋgo ranambe se yowanɨ nɨmɨnɨmɨ, arü, sesɨ, kakɨ, asu hoearɨ yimbu-ane ra ndowandümboemo. ");
INSERT INTO agg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Se nɨnɨ-worambeyo afareafundɨ ra moanɨ se ranɨ worambe yaŋgɨrɨ nɨmandɨmo mbundu botɨndafu ŋgomo. ");
INSERT INTO agg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nahi homondanɨ nindou ai sɨhamumbo worɨnɨfepurɨkoate-ndeianɨ ana, asu se ŋgoafɨ ra hɨnɨŋgɨndu houmbo ŋgomondühɨ yirɨfihɨndɨ hɨfɨ hasüfɨ ra kükiboadu houmbo ŋgomo ranaheimbo God ai moaruwaimbo-mbɨreandürɨ yaho refe nafuiyo-ndürɨmbohünda,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ranɨyomo asu ahambo süŋgururü-rundeimbɨ ai ranɨhü hɨnɨŋgɨru houmbo homo muŋguambo ŋgoafɨ ranambe Godɨndɨ hoafɨ ra wataporɨmbo-rundühɨ nindou aŋgünɨmbo-yeimbɨmbo aboedɨrundürɨ marundɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gariri-yafe adükarɨ bogorɨ Herot ai muŋguambo moatükunɨ tükümefeyo ranahambo hoafɨ ra hɨmborɨyu haya, afɨndɨ hohoanɨmomayu. Ai yare hohoanɨmomayu ra, nindou bɨdɨfɨrɨ ai rarɨhi hoafɨyeihɨ seiya, Son hundürüra-randeimbɨ ai yɨfɨhündɨ botɨmefiyu masei. ");
INSERT INTO agg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Asu bɨdɨfɨrɨ ai seiya, “Godɨndɨ hoafɨ hoafɨyu-randeimbɨ Eraisa ai yɨhoefombo-so tükümefiyu.” Asu awi bɨdɨfɨrɨ ai seiya, “Nindou mamɨ Godɨndɨ hoafɨ hoafɨyu-randeimbɨ horombo hondü manüŋgu ranai yɨfɨhündɨ botɨmefiyu-ane,” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herot ai yare hoafɨyuhɨ yahuya, “Ro sapo Sonɨndɨ mbɨro ra kɨkɨmarɨhehinɨ. Asu nindou düdi nda ai yahurai ro hoafɨ nda hɨmborɨyaha tükümefiyu. Asu ahambo hoeifimbo samboanahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kraisɨndɨ hoafɨ sowandümo homo-rundeimbɨ ai hɨhɨrɨyafu homo Sisasɨmbo-so tüküyafu muŋguambo moatükunɨ ai ramarundɨ ranahambo wataporɨmbo-marurɨ. Ranɨyu ai süŋgure sepurümündü haya Betsaida ŋgoafɨnambo ai yaŋgɨrɨ nɨmarɨmbo mahomo. ");
INSERT INTO agg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ŋga asu awai nendɨ afɨndɨ ranai Sisas nahanafɨyu mahu ranahambo türüfoarɨhi hehimbo-wambo, ai süŋgumarɨhorɨ hei. Ranɨyu asu ai aheimbo mborai-mboraifindürɨ hɨnɨŋgɨreandürɨ haya, God ŋgɨnɨndɨ hɨfandarandɨ ranahambo wataporɨmbo-marandɨ. Asu nindou dɨdɨyei aŋgünümbɨ-mayei aheimbo aboedɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hüfɨhamɨndɨ hürɨmɨndoambe, süŋgrurü-rundeimbɨ 12 ai ahambo-so tüküyafu hoafɨyomondowohü yahomoya, “Se nindou ndanaheimbo koarɨhawandüranɨ mbɨhei. Rananɨmbo asu ai hei adükarɨ ŋgoafɨhüyo asu hɨmboranɨyo ranɨhü apofondɨyo asu sesɨyo ra kokombɨrɨ-hündamboane. Ndanɨhü ana nindou nɨmarɨkoate-yohane,” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ranɨyu asu Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Seanɨmbo sesɨ ra aheimbo ndabudürü,” mehuamboemo. Asu ahambo yaru hoafɨyomondühɨ yahomoya, “Roana hondahüfeimbɨ bret-anemo asu kinɨ akɨdou yimbu-anafanɨ ranɨ yaŋgɨr-ane sɨhehumboayefɨ. Asu muŋguambo nindou ranaheimbo se homo sesɨ pemɨyomo safɨmboyafɨ hohoanɨmoayafa?” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nindowenihɨ ranɨhü mamarɨmo ra 5,000-yomo. Sisas ai ahambo süŋgrurü-rundeimbɨ ahamumbo hoafɨyupurühɨ yahuya, “Nindou ranaheimbo hoafɨndɨmondüranɨ anɨmbo ai 50, 50-ndahi mbɨmari-amboane,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ranɨyomo ahambo süŋgrurü-rundeimbɨ-memo ai hɨmborɨyomo houmbo nindou ranaheimbo ranɨ-süŋgumarundüra mamarei. ");
INSERT INTO agg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ranɨyu Sisas ai hondahüfeimbɨ bretɨyomo asu kinɨ yimbumefanɨ ra semündü haya, sünambe hɨmboyu hafuhü sesɨ ranahambo-hünda Godɨmbo hɨhɨfɨrürɨ mbura, bret kinɨ hɨfɨtɨre ahambo süŋgrurü-rundeimbɨmbo nindou-mayei ranaheimbo yimbufe-ndürɨmbohünda masagapurɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nindou ranai sesɨ ra sahüsi muŋgu parɨhindühɨyei, asu Sisasɨndɨ süŋgrurü-rundeimbɨ ai sesɨ bɨdɨfɨrɨ bɨdɨfɨrɨ korɨmayo ra 12 wambürɨ tüküru madüburafundɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mamɨmbo Sisas ai ahand-amboanɨ Godɨmbo dɨdɨbafɨyuhü nɨmaruwane, asu ahambo süŋgrurü-rundeimbɨ ai, ai-babɨdɨmbo mamarɨmo. Ranɨyu ahamumbo düdufipurühɨ yahuya, “Nindou ai wamboya ai düdi seia?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Asu sɨmborɨ ahambo hoafɨyomondühɨ yahomoya, “Bɨdɨfɨrɨ ai Son sapo nindou hundürüra-randeimbɨ-mayu-ani sei. Bɨdɨfɨrɨ ai sɨhambo seiya ai Eraisa-ani maseiamboyei, asu bɨdɨfɨrɨ ai Godɨndɨ hoafɨ hoafɨyu-randeimbɨ horombo hondü manüŋgu ranai yɨfɨhündɨ botɨmefiyu-ani masei,” mehomondo. ");
INSERT INTO agg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ranɨyu asu ai ahamumbo sɨmborɨ hoafɨyupurühɨ yahuya, “Asu se ra wambo nüŋguru hohoanɨmoyomo ro dɨdɨyaha?” mehuamboemo. Asu Pita ai ahambo sɨmborɨ hoafɨyundühɨ yahuya, “Seana Krais-anafɨ nindou God ai dɨbonɨyunɨnɨ hɨnɨŋgɨ-mareanɨnɨ nindou aboedambo-fendürɨmbohünda,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ranɨyu asu Sisas ai ranɨ hoafɨ ranahamboya, “Se nindou ŋgorümbo yowanɨ hoafɨndɨmboemo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Asükaiyu ahamumbo yare hoafɨyupurühɨ yahuya, “Nindou Hondü ai ana asübusümbɨ tɨŋɨrɨfo afɨndɨ ndemündühɨ anɨmbo ahambo bogorɨ nindou-anemo Godɨmbo sesɨ sɨhou-rundeimb-anemo asu ahɨnümbɨ hohoanɨmo yamundu rundeimb-anemo ranai yɨboaruko-ndurɨmboemo. Ai ahambo hɨfokoandüwuranɨ yɨfɨndümbuisɨ, ŋga asu ai ŋgɨmɨ sindu mbunda süŋguna yɨfɨhündɨ botɨndɨfimbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ai muŋguambo aheimbo hoafɨyundürühɨ yahuya, “Nindou dɨdɨyei ai wandɨ süŋgu hombo hohoanɨmondeihɨ ana, asu ai ahei hohoanɨmo ra hɨfɨnambo-ndɨhi hehi nɨmɨ keimbɨ karɨhendeimbɨfihɨ yɨfɨmbo noundahi hehi muŋguambo si aho ra wambo süŋgumbɨrɨhi-ndɨramboane. ");
INSERT INTO agg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nindou düdi ai ahandɨ yaŋgɨrɨ nɨŋgo hohoanɨmo ra ahandɨhoarɨ hɨfandarandɨ ana, ai awarɨ-ndɨhoemboe. Ŋga asu nindou düdi wambohünda ahandɨ yaŋgɨrɨ nɨŋgo hohoanɨmo ranahambo moanane ehu ana, ra gedühɨ nɨŋgomboe. ");
INSERT INTO agg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nindou mamɨ ai ratüpurɨ-yuhümbo muŋguambo moatükunɨ napo hɨfɨ ndanɨhündambo ra gugurareandɨ ana, asu ahandɨhoarɨ awarɨndɨhembui, ŋga nüŋgunde ahambo mafandɨhera? ");
INSERT INTO agg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nindou düdi ai, roanahɨ asu wandɨ yamundɨfe hoafɨ ranane ranahambo amoanɨŋgayu ana, asu ro-amboanɨ nindou ranahambo Ape, ro, asu sünambeahɨndɨ nendɨ babɨdɨ yɨhoefɨ ŋgɨnɨndɨ hɨmboamupuimbo-randeimbɨ kapeihü kosahambe amoanɨŋgɨ-ndɨhünɨmboyahɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ro sɨheimbo anɨhondümboanahɨ nda hoafayahandürɨ, nindou bɨdɨfɨrɨ dɨdɨyei ndanɨhü anɨboadei ranai ana yɨfɨkoate yaŋgɨrɨ nɨmboei-ambe God ŋgɨnɨndɨ hɨfandarandɨ ra hoeindɨhimboyei,” mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sisas ai ranɨ hoafɨ ra hoafɨyu haya, 8 si howane, ai Pita, Son asu Sems ahamumbo sepurɨmündü haya hɨfɨ wafunambo Godɨmbo dɨdɨbafɨfembo mahafu. ");
INSERT INTO agg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ai Godɨmbo dɨdɨbafɨyuhü nüŋguane asu ahandɨ ŋgusümboarɨ ra ranɨpoanambo fiyowohüyo asu ahandɨ hoearɨ ra kɨfohɨ hamɨndɨyowohü si nahurai tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ranɨyo asu ranɨ-sɨmboanɨ Moses, Eraisa ai Sisas-dɨbo wataporɨyafandühɨ manɨmbafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nindou yimbu ranai hɨmboamupuimbo-randeimbɨ kapeihü tüküyafɨne henamboyafanɨ asu Sisas ai Godɨndɨ ratüpurɨ moendɨfihɨ Serusarem ŋgoafɨhü yɨfɨmbo-mayu ranahambo ai-babɨdɨ wataporɨmemo. ");
INSERT INTO agg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ai ahandɨ ŋgunindɨ yimbu Son asu Sems ai ahamumbo yapombo hɨmbomarapura mapomo. Asu hɨmboarɨ bɨrɨhoemo hoeirundane, Sisasɨndɨ hɨmboamupuimbo-randeimbɨ si ranambe nindou yimbu ranai-amboanɨ yahurai ai-dɨbo manɨmbafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moses Eraisa ai ndeara hombo safanɨ henambo-yafandane, Pita ai Sisasɨmbo hoafɨyundühɨ yahuya, “Adükarɨ, aboed-ane ndanɨhü amarefɨsɨ, ŋga sɨhɨrɨ dago ŋgɨmɨ hündɨhupurɨmboane, sɨhambo ŋgorü, Mosesɨmbo ŋgorü asu Eraisambo ŋgorü.” Pita ai yare hoafɨmayu ra ai ndore fɨfɨre hayamboyupoanɨ hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ai ranɨ hoafɨ ranahambo yare hoafɨyuambe mburüŋgai ranai pɨyo gabudɨ-mafoareapura, asu ai yɨhɨmbomemo. ");
INSERT INTO agg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ranɨyo asu hoafɨ ranai mburüŋgai-ambeahɨndɨ tüküfihɨ yahoya, “Wandɨ Nɨmor-ani nda, ro ahambo dɨbonɨmayahando-ani. Se ahandɨ hoafɨ hɨmborɨndɨmo,” meho. ");
INSERT INTO agg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ranɨ hoafɨ ra ho kɨkamɨndoambe Sisas ai yaŋgɨrɨ ranɨhü manüŋgu. Pita, Son, Sems ai ranɨ-sɨmboanɨ nɨnɨ-moatükunɨ hoeimarundɨ ranahambo nindou ŋgorümbo moai nɨnɨ hoafɨ hoafɨyomo. ");
INSERT INTO agg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ŋgorü sina hɨfɨ wafu ra hɨnɨŋgɨru houmbo hanɨmondanɨ, nɨmorehɨ nindowenihɨ afɨndɨ ranai Sisasɨmbo nafɨnɨ hoeimarɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nindou mamɨ, nɨmorehɨ nindowenihɨ afɨndɨ-mayei ranambeahɨndɨ ai Sisasɨmbo puküna hoafɨ karɨhoehü yahuya, “Nindou yamundo-randeimbɨ karɨhasɨ. Se sühüfɨ nɨmorɨ wandɨ hoeirɨworɨ, ŋga wandɨ mamɨ ndearani nda. ");
INSERT INTO agg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Moaruwai nendɨ ai nɨmorɨ ranahambo kɨkɨhɨ-safɨrɨmɨndühane asu ai hepünüfi heiyu arandɨ. Moaruwai nendɨ ranai ahambo yabadɨrɨ wakɨrerɨhane asu yahamo kasiau wutüpuiarɨyu arandɨ. Ai ahandɨ fi ranahambo muŋgunambo moaruwaimbo-rerɨhane asu ahambo nɨmai hɨnɨŋgɨfi hombo sɨsamɨndarandɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ro sɨhambo süŋgurunɨnɨ-rundeimbɨ ranahamumbo hüti-hütimarɨhapurɨ moaruwai nendɨ ranahambo raguanambofembo, ŋga ai ŋgɨrɨ raguanambondundɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Asu Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Nindou nda se ana anɨhondümbofe hohoanɨmokoate-yeihanei, asu sɨhei nɨŋgo hohoanɨmo ra moai ndorɨhoayo. Nüŋgunɨmbɨmbo awi ro se-babɨdɨmbo nɨmboambo sɨhei nɨmborɨ ra mandahamɨndɨha? Nɨmorɨ sɨhafɨ ra ndühɨ sowarɨndɨfɨ sühüfɨ,” mehu ");
INSERT INTO agg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nɨmorɨ ranai süfuane moaruwai nendɨ ranai serɨmɨndɨ hɨfɨhü purapoaporerɨ sɨherɨ haya yabadɨmarɨrɨ. Ŋga asu Sisas ai moaruwai nendɨ ranahambo ŋgɨnɨndɨ hoafɨyundo haya nɨmorɨ ranahambo aboedɨrirɨ mbura ahandɨ afɨndambo hɨhɨrirɨ maserügudo. ");
INSERT INTO agg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ranɨyei asu muŋguambo nindou-mayei ranai Godɨndɨ ŋgɨnɨndɨ adükarɨ ranahambo mahepünehindɨ. Muŋguambo nindou ranai Sisas ramareandɨ ranahambo afɨndɨ hohoanɨmoyeihɨ nɨmboeiambe, ai ahambo süŋgrurü-rundeimbɨmbo hoafɨyupurühɨ yahuya, ");
INSERT INTO agg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ro nɨne-moatükunɨ sɨhamumbo haponda hoafehapurɨ ndanahambo mɨtanɨndündümboemo. Ŋgɨrɨ amɨtata Nindou Hondü ndanahambo nindouyei warɨwamɨ hɨnɨŋgɨndɨhorɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ŋga asu ahambo süŋgrurü-rundeimbɨ ai ranɨ hoafɨ ranahandɨ nɨmɨndɨ ra moai fɨfɨrundɨ. Ranɨ hoafɨ ra ahamumbo dɨbo meŋgoro wambo ai moai ndoru türüfoarundɨ. Ŋga asu ai Sisasɨmbo düdufembo ra yɨhɨmbomemo. ");
INSERT INTO agg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sisasɨmbo süŋgrurü-rundeimbɨ ai nindou düdi adükarayu yahomo houmbo sɨmborɨ hoafɨmemo. ");
INSERT INTO agg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sisas ai fɨfɨreandɨ nɨne hohoanɨmo ahamundɨ ŋgusüfoambe amaro ranɨmbo. Ranɨyu asu ai nɨmorɨ akɨdou serümündü ahandɨ ŋgɨrɨsafɨnɨ pamarirɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ranɨyu ai hoafɨyuhɨ yahuya, “Nindou düdi ai nɨmorɨ akɨdou ndanahambo wambohünda hohoanɨmoayundo ana, wambo amboanɨ hohoanɨmoyu-ndɨrühani. Nindou düdi ai wambo hohoanɨmoayundɨrɨ ana, asu nindou sapo wambo koamarɨhendɨra makosahɨ ahambo amboanɨ hohoanɨmoyu-ndohani. Nindou düdi ai sɨhamundɨ mbusümo akɨdou hamɨndayu ai-ani moanɨ adükarɨ hamɨndɨ hondayu,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ranɨyu asu Son ai sɨmborɨ hoafɨyuhɨ yahuya, “Adükarɨ, ro hoeirɨhundanɨ nindou mamɨ ai sɨhafɨ ndürɨnambo moaruwai nendɨ raguanambomareanda, ro ahambo ranɨ-moatükunɨ raguanambofembo yowanɨ masahundo. Ro ahambo ramarɨhurɨ ra nɨmboe sapo ai moai sɨhambo süŋgureanɨnɨ ro rawehundɨ nou,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Sisas ai Sonɨmbo hoafɨyundühɨ yahuya, “Se yowanɨ ahambo yowanɨ yahondopoanɨ, sapo nindou düdi ai sɨmborɨ sɨhamumbo hoafɨyopurɨkoate-ayu ranai ana nindou “sɨhamundani,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sisas ai God sowana hafombo si ranai ndeara akɨmɨ tüküfeyoambe, ai Serusarem ŋgoafɨnambo hombo hohoanɨmomayu. ");
INSERT INTO agg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ranɨyu ai muŋguambo moatükunɨ ahambo yimuŋgurɨfembo nindou bɨdɨfɨrɨ horombo koamarɨhepura homo Samaria ŋgoafɨhü tükümefundɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ŋga asu nindou ranɨ ŋgoafɨhü ranai moai Sisasɨmbo mborai sahündo ai Serusaremɨnambo mahuwambo wambo. ");
INSERT INTO agg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Sisasɨmbo süŋgururü-rundeimbɨ nindou, Sems, Son ai ranɨ ŋgoafɨhündɨ ramehindɨ ranɨmbo hoeirɨne hena hoafɨyafandühɨ safanɨya, “Adükarɨ, ro sünambeahɨndɨ hai ranahambo hoafɨndehanɨ kosɨ nindou ranaheimbo moaruwaimbofendürɨmbo ra se yifirɨndafanɨ ana, randɨhoa?” masafandamboyu. ");
INSERT INTO agg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ranɨyu asu Sisas ai ahafanɨmbo hɨhɨrɨfi ŋgɨnɨndɨ hoafɨmayupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ranɨyomo asu ai ranɨhünda ŋgorü ŋgoafɨna mahomo. ");
INSERT INTO agg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ai homondühɨyomo nafɨnɨ nindou mamɨ ai Sisasɨmbo yare hoafɨyuhɨ yahuya, “Se nɨnɨnɨyo ahafɨ ra roana moanɨ sɨhambo yaŋgɨrɨ süŋgundɨhanɨnɨ-mboyahɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Asu Sisas ai ahambo hoafɨyuhɨ yahuya, “Nɨmambeahɨndɨ yaforɨ ana ahandɨ hɨfɨ ambe ra mbanɨŋgo ai ho aporambo, asu ndu ai ŋgerümb-anei, ŋga Nindou Hondü aiana fondɨkoate-ani ai ho ahandɨ mbɨro bɨdagorɨfe aporambo ra,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nindou ŋgorü-mayu ranahambo Sisas ai hoafɨyundühɨ yahuya, “Se wambo süŋgundandɨrɨ,” mehundo. Ŋga asu ai ahambo yare hoafɨyundühɨ yahuya, “Adükarɨ, awi ro ŋga wandɨ apembo hɨfɨ-kandɨhinɨ heheambo asu süŋguna ŋgamboyahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ŋga asu Sisas ai ahambo yare hoafɨyundühɨ yahuya, “Nindou yɨfɨyeimbɨ ai aheihoarɨ yɨfɨnɨmoko ra hɨfɨ kambɨrɨhi-ndamboane, ŋga seana ŋgafɨ God ŋgɨnɨndɨ hɨfandarandɨ ranahambo anɨmbo wataporɨmbo-ndandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nindou ŋgorü ai hoafɨyuhɨ yahuya, “Adükarɨ, ro sɨhambo süŋgundɨhanɨnɨ-mboyahɨ, ŋga awi ro ŋga wandɨ fikɨmɨnɨndɨ-mayei ranaheimbo asürü ahɨnɨndɨhearü mbundɨhambo anɨmbo süŋgundɨhea-nɨnɨmboyahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sisas ai ahambo hoafɨyundühɨ yahuya, “Nindou mamɨ ai nɨmɨ hɨtandühɨ daboadanɨ kefuai hɨmboayu ana, God ŋgɨnɨndɨ hɨfandarandɨ ranahambo ŋgɨrɨ ratüpurɨndu,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Süŋgunambo Adükarɨ ai 72 nindou dɨbonɨyu mbura, ahamumbo boatei yimbu-yimbure nɨne ŋgoafɨ sapo ai hombo yahuhayambo-mayu ranɨ ŋgoafɨnɨ koamarɨhepurɨ. ");
INSERT INTO agg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ai ahamumbo yare hoafɨyupurühɨ yahuya, “Nümbürambe sesɨ afɨndɨ burayo ranai ndeara muŋgu süfi yaŋgɨrayo, ŋga asu sesɨ ranahambo yimuŋgurɨfe gugurɨfembo nindou ana afɨndɨyopoanɨ. Ranɨmbo-hündambo anɨmbo asu se nümbürɨ aharambürɨ ranahambo dɨdɨbafɨndafundanɨ anɨmbo asu ai sesɨ ra yimuŋgurɨfe gugurɨfembohünda nindou afɨndɨ safɨ koambɨrɨ-hepuramboane. ");
INSERT INTO agg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hapoana se ŋgomo, ŋga awi se hɨmborɨyomo! Ro sɨhamumbo sipsip wei nahurai yaforɨ harümbɨ nɨmboeiambe nou koararɨheheapurɨ. ");
INSERT INTO agg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Se kakɨ sandɨferambo arü akɨdouane, napo arü ane, asu su yirambe kɨkɨfoefemboane ndowandümboemo, ŋga yowanɨ. Asu se nindou nafɨnɨ hoeindundürühɨ aheimbo warɨ furüboadundürühɨ wataporɨmbo-ndürɨmboemo, ŋga yowanɨ. ");
INSERT INTO agg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Se nɨnɨ worambe-yomo afareafundɨ ra, boatei randu hoafɨndɨmondühɨ anɨmboya, ‘Nindou ndanɨ worambe amarei se ŋgusüfoambe afurɨndɨhi kündɨhindɨ,’ mbɨsɨmo. ");
INSERT INTO agg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nindou bɨdɨfɨrɨ ranɨ worambe ŋgusüfoambe afurɨfe kife hohoanɨmombo yifirɨyeimbɨ nɨmandianɨ ana, nindou aheimbo-so ŋgusüfoambe afurɨfe kifeimbɨ hohoanɨmo sɨhamundɨ-mayo ra mbeyaŋgoro-amboane. Ŋga asu wanayo ana, ranɨ hohoanɨmo sɨhamundɨ-mayo ra asükaindo sɨhamundɨ hɨhɨrɨfe mbɨhowamboane. ");
INSERT INTO agg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Se moanɨ worɨ mamɨ ranambe yaŋgɨrɨ nɨmandɨmo. Nindou ranɨ worambeahɨndɨ ai nɨnɨ-moatükunɨyo ndehüpuranɨ se ranɨ worambe yaŋgɨrɨ sesɨ dowadümo hoe ndɨmɨndɨmo ndundɨ. Ŋga se worɨnɨ worɨnɨpo-ndɨmboemo. ");
INSERT INTO agg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nɨnɨ ŋgoafɨhüyo se tüküyafundanɨ nindou ai sɨhamumbo ndahüpurümündi worɨnɨndɨhipuranɨ ana, se moanɨ nɨne-moatükunɨ ai sɨhamumbo püpimarɨhindɨ ra dowadümo. ");
INSERT INTO agg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Asu ranɨ ŋgoafɨhü aŋgünümbɨ nindou amarei ranaheimbo aboedɨndundürühɨ hoafɨndomondürühɨ anɨmboya, ‘God ai ŋgɨnɨndɨ hɨfandarandɨ ranai ndeara sɨheimboso akɨmɨ tüküfemboane,’ mbɨsɨmo. ");
INSERT INTO agg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Ŋga asu se nɨnɨ ŋgoafɨhüyo homondanɨ nindou ranai sɨhamumbo sepurɨmɨndɨ worɨnɨfekoate-ndeianɨ ana, asu ranɨ ŋgoafɨhü se ŋgomo nafɨnɨ nɨŋgomombo aheimbo hoafɨndomondürühɨ anɨmboya, ‘Sɨhei ŋgoafɨhündɨ hɨfɨ hasüfɨ yɨhoefɨ tɨŋarɨfihɨ apenɨŋgo ra sɨheimbo hütimbo-hündamboane püpürɨfafoarɨhundɨ. Ŋga awi se randɨhi fɨfɨrɨndɨhindɨ God ŋgɨnɨndɨ hɨfandarandɨ ranai ndeara akɨmɨ tüküfemboane,’ mbɨsɨmo. ");
INSERT INTO agg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ro sɨhamumbo rarɨhe hoafehapurɨ, Godɨndɨ yɨbobofembo si tüküfeyoambe ana, sɨheimbo tɨŋɨrɨfo Sodomɨhündɨ ranaheimbo tükümefeyondürɨ ra ŋgasünde haya moaruwai hamɨndɨ tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Hɨpoanɨhɨmboembou-anei Korasinɨhündɨ se! Hɨpoanɨhɨmboembou-anei Betsaidahündɨ se! Sɨheimbo moaruwai hamɨndɨ tükündɨfendürɨmboe. Asu ro hepünɨfeimbɨ moatükunɨ sɨhei ŋgoafɨhü ramarɨheandɨ rahurai Tair ŋgoafɨhü Saidon ŋgoafɨhü rambarɨhea-mbonana, nindou ranɨ ŋgoafɨhündɨ ranai horombonambo anɨmbo moaruwai hohoanɨmo hɨnɨŋgɨrɨhi hehi dɨdɨboadorɨhi nɨmarei. Rananɨmbo ai hasüfɨ yihuruyei mburɨhümbo nɨmarei sapo roana yɨhoefɨ moaruwai hohoanɨmo ranahambo hɨnɨŋgɨrɨhumboanefɨ sei hehi. ");
INSERT INTO agg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ŋga asu Godɨndɨ yɨbobofe si tüküfeyoambe ana, Tair ŋgoaf-ane Saidon ŋgoaf-ane ranaheimbo ana ŋgɨrɨ afɨndɨ hamɨndɨ tɨŋɨrɨfo tükündɨfeyo, ŋga sɨheimbo ana nɨne moanɨ afɨndɨ yahurai hamɨndɨ tɨŋɨrɨfo tükümandɨfendürɨ. ");
INSERT INTO agg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Asu Kaperneam se ra sünambe ndürɨ adükarɨ mandahümündiyo? Wanɨ yaŋgɨr-ane ana! Sɨheimbo ana hɨfɨnɨ safɨ pindeandüranɨ gadeimboyei!” mehu. ");
INSERT INTO agg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ai ahambo süŋgrurü-rundeimbɨmbo hoafɨyuhɨ yahuya, “Nindou düdi ai sɨhamundɨ hoafɨ hɨmborayu ana, wandɨ hoafɨ amboanɨ hɨmborɨyuh-ani. Asu nindou düdi ai sɨhamundɨ hoafɨ hɨmborɨyo hefe semɨndɨkoate-ayu ana, asu wandɨ hoafɨ ŋgɨrɨ hɨmbondu haya ndemündu. Asu nindou düdi ai wandɨ hoafɨ hɨmborɨyo hefe semɨndɨkoate-ayu ana ai ŋgɨrɨ Nindou düdi wambo koamarɨhendɨrɨ ahandɨ hoafɨ amboanɨ hɨmborɨndu haya ndemündu,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nindou 72-memo ranai hɨhɨfɨ-hɨhɨfɨ kameihɨ hɨhɨrɨyafu homo tüküyafu hoafɨyomondühɨ yahomoya, “Adükarɨ, sɨhafɨ ndürɨ dükarɨhunda moaruwai nendɨ ranai yɨhoefɨ hoafɨ hɨmborɨyei marɨhündɨ!” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sisas ai sɨmborɨ ahamumbo hoafɨyuhɨ yahuya, “Ro hoeirɨheandanɨ Satan ai sünambeahɨndɨ wabürüsɨ nahurai pɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Awi se hɨmborɨyomo, sapo ro sɨhamumbo amoasɨrɨyo hɨfɨtaŋɨyo ranɨwamɨ pütapɨyo hombo ŋgɨnɨndɨ masahapur-ane. Asu sɨhamundɨ hürütümbɨndɨ ŋgɨnɨndɨ ŋgasünde-andeimbɨ ŋgɨnɨndɨ masahapurɨ. Ŋga ranɨmbo-hündambo anɨmbo sɨhamumbo ŋgɨrɨ nɨnɨ-moatükunɨ moaruwaimbo-ndeapurɨ. ");
INSERT INTO agg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sapo moaruwai nendɨ sɨhamundɨ hoafɨ hɨmborɨmayei ranɨmbo se yowanɨ hɨhɨfɨ-hɨhɨfɨndɨmboemo. Ŋga sapo sɨhamundɨ ndürɨ sünambe pare masɨhepurɨ ranɨmbo-hündambo anɨmbo hɨhɨfɨ-hɨhɨfndɨmo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ranɨyo asu ranɨ-sɨmboanɨ Yifiafɨ Aboedɨndɨ hɨhɨfɨ-hɨhɨfɨ ranai Sisasɨndɨ ŋgusüfoambe tüküfehüyo, asu ai yare hoafɨyuhɨ yahuya, “Ape, sünambe-ane asu hɨfɨ ndanɨhü-ane se Adükar-anafɨ. Ro sɨhambo hɨhɨfarɨhanɨnɨ ra nɨmboe sapo nindou fɨfɨrɨhi mburɨhü dɨdɨboado-rɨhehindeimbɨ-mayei aheimbo ranɨ-moatükunɨ ra dɨbonapɨro mbura, asu nɨmorɨ akɨdɨbou nahurai-mayei aheimbo nafuimefɨndürɨ ranɨmbo-hünda. Yɨnɨ, Ape se ranɨ-moatükunɨ refembo yifirayafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sisas ai hoafɨyupurühɨ yahuya, “Wandɨ Ape ai wambo muŋguambo moatükunɨ ŋgɨnɨndɨ ra masendɨrɨ. Nindou dɨdɨ ai moai Nɨmor-ayu ndanahambo fɨfɨrirɨ, ŋga Afɨndɨ ai yaŋgɨr-ani fɨfɨrirɨmboayu. Asu nindou dɨdɨ ai moai Afɨndambo fɨfɨrirɨ. Ŋga Nɨmorɨ aiani asu nindou dɨdemo Nɨmorɨ ai ahandɨhoarɨ dɨbonɨmayupurɨ sapo Godɨmbo fɨfɨrɨfi hoafɨmbo-memo ai yaŋgɨr-anemo fɨfɨrumboemo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ranɨyu Sisas ai hɨhɨrɨfi nüŋgumbo ahambo süŋgrurü-rundeimbɨ-memo ranahamumbo-poanɨmbo yaŋgɨrɨ hoafɨyupurühɨ yahuya, “Nɨne-moatükunɨ se sɨhamundɨ hɨmboarɨnambo hoeiarundɨ ranɨ-moatükunɨ ra nindou ai-amboanɨ hoeiareandɨ ana, ai hɨhɨfɨ-hɨhɨfɨmbiyu-wamboane! ");
INSERT INTO agg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ro sɨhamumbo nda hoafehapurɨ, Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ-yomo asu bogorɨ nindou-yomo ai nɨne-moatükunɨ haponda se hoeiarundɨ ndanahambo ai hoeifembo mehomoyosɨ, ŋga ai moai hoeirundɨ. Asu ai nɨne hoafɨ se hɨmborayomo ranahambo amboanɨ hɨmborɨmbo mehomoyosɨ, ŋga asu ai moai hɨmborɨyomo,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Suda-yomondɨ ahɨnümbɨ hohoanɨmo yamunde-randeimbɨ nindou ranai Sisasɨmbo refi hoeifimbo tükümefiyu. Ai yare hoafɨyuhɨ yahuya, “Yamundo-randeimbɨ, ro nüŋgundɨheandühɨ koadürümbo yaŋgɨrɨ nɨŋgombo hohoanɨmo ra mandahamɨndɨha?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Asu Sisas ai sɨmborɨ ahambo hoafɨyuhɨ yahuya, “Asu nüŋgureamboyo Baiborambe hoafɨmayoa? Nüŋgundo se ranɨ-moatükunɨ ranahambo hoeindo fɨfɨrɨmandowanda?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Asu nindou-mayu ranai hoafɨyuhɨ yahuya, “Adükarɨ aiana sɨhei God-ani, ranɨmboanɨmbo se ahambo sɨhei yifiafɨ, ŋgɨnɨndɨ, hohoanɨmo ranambo ŋgusüfo pandɨhorɨ. Asu sɨhei wandafɨ ranaheimbo amboanɨ ŋgusüfo pandɨhindürɨ sapo se sɨhei fimbo ŋgusüfo pararɨhindɨ nou,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Asu Sisas ai sɨmborɨ hoafɨyuhɨ yahuya, “Se anɨhondümbo-anafɨ hoafayafɨ. Se randowandühɨ anɨmbo yaŋgɨrɨ nɨmboamboyafɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ŋga asu ai Sisasɨmboya ai adükarɨ fɨfɨreandeimb-ani yahuhaya ahambo düdufinduhɨ yahuya, “Nindou düdi ai wandɨ wandafayua?” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Mamɨmbo nindou mamɨ ai Serusarem ŋgoafɨhündɨ botɨfi haya Seriko ŋgoafɨna hanuwane, hümbuhünɨ nindou ai nafɨnɨ mburɨndümo houmbo hoearɨ napo ahandɨ hɨrɨfoarundowohü asu ahambo bubururɨ yɨfɨmbo yaŋgɨrɨ sɨhawurɨ-houmbo ndamefundɨ. ");
INSERT INTO agg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ranɨ-moatükunɨ ranai refeyowane Sudahündɨ Godɨmbo sesɨ sɨhai-randeimbɨ nindou ai nafɨ ranɨ-süŋgu mahanu. Ŋga asu nindou ranai hoeirira mayowamboyu hɨmborɨ nafɨ wakɨramündü tüküfi haya mahanu. ");
INSERT INTO agg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nindou mamɨ Godɨmbo sesɨ sɨhai-randeimbɨ Rifai sɨrɨhündɨ ai mahanu. Ai süŋgunɨ hanü nindou ranahambo hoeirira mayowamboyu hɨmborɨ nafɨ wakɨramündü tüküfi haya mahanu. ");
INSERT INTO agg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ranɨyo asu nindou mamɨ Samariahündɨ ai nafɨ ranɨ-süŋgu mahanu. Ai hanü nindou buburürɨ masɨhawurɨ ranahambo-so tükümefiyu. Asu ai nindou ranahambo hoeirira mayoa ahambo hɨpoambo afɨndɨ hɨpoambomarürɨ. ");
INSERT INTO agg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Samariahündɨ-mayu ranai hüfu ahandɨ fikɨmɨ tüküfi orif hɨsɨ werɨ hoeyo asu wain hɨsɨ hoeyo ra buburura horɨmayo ranɨwamɨ kare mbura hoearɨ goesürɨnambo hɨmondɨmarɨherü. Ranɨyu ai nindou ranahambo serümündɨ ahandɨ doŋgi-mayo ranɨwamɨ nandi serümündü haya, nindou fandɨhi apoei-rɨhündeimbɨ worɨna mahanu ranɨhü semündɨ ho hɨfandɨyo nɨmarɨmbohünda. ");
INSERT INTO agg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ŋgorü sina Samariahündɨ-mayu ranai kakɨ sepurɨmündɨ hu nindou tüküyahi apoei-rɨhündeimbɨ worɨ hɨfandɨra-ndeimbɨ-mayu ranahambo sagadowohü yahuya, ‘Nindou ndanahambo se dɨdɨboadondɨworɨ. Se ahambohünda kakɨ pütiayafɨ ana, ro asükainda hɨhɨndahe dügühühɨ sɨhambo hɨhɨndɨhe ndahanɨnɨmboyahɨ,’ mehundo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sisas ai asükaiyu düdufindowohü yahuya, “Se sɨhafɨ hohoanɨmonambo nindou ŋgɨmɨ ra düdi wandafɨ ranahambo ŋgusüfo paririmbayua?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ai hoafɨyuhɨ yahuya, “Nindou sapo düdi ai ahambo hanü hɨpoamborirühɨ mafarɨherü ranai-ani,” mehundowamboyu. Asu Sisas ai sɨmborɨ hoafɨyundohü yahuya, “Se ŋgafɨ moanɨ ranɨ süŋgundowandɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sisas ai ahambo süŋgrurü-rundeimbɨ babɨdɨmbo nafɨ homondühɨ ai ŋgoafɨ mamɨ Mata nɨmarümbɨ ranɨ ŋgoafɨhü tüküfiyuane asu ahambo serɨmɨndɨ worɨnɨmarerɨ. ");
INSERT INTO agg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata ai akɨdɨmbüyo hayamboyo ahandɨ ndürɨ ra Maria ai sɨfo Adükarɨndɨ yirɨkɨmɨ nɨmarɨmbo ahandɨ yamundɨfe hoafɨ wataporɨmbo-arandɨ ra hɨhɨmborɨmayo. ");
INSERT INTO agg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ŋga asu Mata ai afɨndɨ ratüpurɨ worambe eŋgoro ranahambo tɨŋambo-yowohüyo ai moai ŋgusüfoambe ndore küreandɨ. Ai ahambo-so ho hoafɨyondowohü yahoya, “Adükarɨ seana awi moai wandɨ akɨdɨ ranai hɨnɨŋgɨreandɨranɨ muŋguambo ratüpurɨ wand-amboanɨ rarawarɨhandɨ ranahambo ana hohoanɨmoyafɨyo? Se hoafɨyafɨndoanɨ anɨmbo ai sɨnɨ wambo mbɨfarɨhendɨrɨ,” mehondowamboyu. ");
INSERT INTO agg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Asu Sisas ai sɨmborɨ hoafɨyundowohü yahuya, “Mata, Mata, seana muŋguambo moatükunɨ ranahamboanafɨ afɨndɨ hohoanɨmoyafühɨ ŋgusüfoambe ndofe kifekoate-ayafɨ. ");
INSERT INTO agg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mamɨ moatükun-ane adükarɨ hamɨndayo. Maria aiana aboedɨ moatükunɨ hamɨnd-ane ai warɨfe semɨndɨmboayo. Ranɨ-moatükunɨ ranai ahandɨ warambeahɨndɨ ŋgɨrɨ hündühümündi,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mamɨmbo Sisas ai ŋgoründühɨ dɨdɨbafɨyuhü manüŋgu. Ai dɨdɨbafɨyu kɨkamünduane, asu ahambo süŋgrurü-rundeimbɨ mamɨ ranai hoafɨyundühɨ yahuya, “Adükarɨ, se yɨhoefɨmbo dɨdɨbafɨyorambo ra Son ai ahambo süŋgrurü-rundeimbɨmbo ramareapurɨ nou yamundowamunɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Asu Sisas ai hoafɨyupurühɨ yahuya, “Se ndandu dɨdɨbafɨ-ndafundühɨ anɨmboya, ‘Ape, sɨhafɨ ndürɨ ra moanɨ ahɨnümbɨ-mbeyowamboane. Sɨhafɨ ŋgɨnɨndɨ hɨfandarandɨ ra mbɨkosowamboane. ");
INSERT INTO agg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Muŋguambo si ro sesɨ semɨndɨmbo hohoanɨmoayefɨ ra se ndawamunɨ. ");
INSERT INTO agg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yɨhoefɨ moaruwai hohoanɨmo ra amboawi mbɨsafɨmunɨ, ro-amboanɨ muŋguambo nindou yɨhoefombo moaruwaimbo-rɨhimuna, amboawi asahundürɨ nou. Asu se yɨhoefɨmbo nɨnɨ-moatükunɨ refe hoeifemunɨmboayo ranambe ndowandɨfɨmunɨ ŋgamboyafɨ,’ mbɨsɨmo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ranɨyu asu Sisas ai hoafɨyupurühɨ yahuya, “Asu se sɨhafɨ ŋgunindɨ-mayu ranahandɨ worɨna nɨmbɨ mbusümondühɨ hafɨ hoafɨyafɨ-ndowohüya, ‘Wandafɨ, se wambo bret ŋgɨmɨ sawapurɨ, nɨmboe sapo wandɨ ŋgunindɨ ai nafɨmbo sünɨ tükümefɨyu, ŋga ro ai sesɨmbo sesɨ-koate-anahɨ.’ ");
INSERT INTO agg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nindou worambe amaru ranai rande sɨmborɨ hoafɨnduhüya, ‘Yipurɨ parɨheamboanahɨ, ŋga se wambo tɨŋɨrɨfo ndawandɨrɨ-mboyafɨ, ŋga ragu moeindanɨ ŋgafɨ. Roana nɨmorɨ babɨdɨmbo fondɨhü apoefɨ. Ro ŋgɨrɨ botɨndahe sɨhambo nɨnɨ-moatükunɨ amboanɨ ndahanɨnɨ,’ mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ro sɨhamumbo hoafɨyahapurɨ, worɨ aharambürɨ ranai botɨndüfi nɨnɨ-moatükunɨyo mbonɨmbo-maramündu ra worambeahɨndɨ fufundamündɨ dagadombui. Nindou ranai ahandɨ ŋgunindɨ ranahambo farɨhefimbo rareandühɨyupoanɨ, ŋga düdu-düdupo-marürambo ranɨmbo dagadombui. ");
INSERT INTO agg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ro sɨhamumbo hoafehapurɨ nda, düdundafundanɨ anɨmbo God ai sɨhamumbo dagapurümbui. Kokoarundɨ anɨmbo hoeindumboemo. Yipurɨfihɨ pɨrako-pɨrakondundanɨ anɨmbo yipurɨ ranai sɨhamumbo sübüdɨhoemboe. ");
INSERT INTO agg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Anɨhondane, muŋguambo nindou düdi-düdufi arandɨ hu-anɨmbo ai ndemündümbui. Nindou düdi ai kokoara hu-anɨmbo ai hoeindeambui. Muŋguambo nindou düdi ai yipurɨfihɨ pɨrako-pɨrakoara hu-anɨmbo ahambo yipurɨ ra sübüdɨhoemboe. ");
INSERT INTO agg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Asu sɨhafɨ nɨmorɨ ai kinɨ sao sei hehi düduehindɨ ra se harɨnendɨ madabudürɨyo? ");
INSERT INTO agg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Asu sɨhafɨ nɨmorɨ ai soŋgo sao sei hehi düduehindɨ ra asu se aheimbo hɨfɨtaŋɨ madabundürüyo? ");
INSERT INTO agg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Se moaruwai hohoanɨmoyomo-rundeimbɨ nindou-anemosɨ, ŋga asu se sɨhamundɨ nɨmorɨ ranaheimbo aboedɨ moatükunɨ sabudürɨ arundɨ. Mamɨ yahurai-ane nindou dɨdɨyei Ape sünambe amaru ahambo düduehindɨ ana, Yifiafɨ Aboedɨ dagadürümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mamɨmbo Sisas ai moaruwai nendɨ hemafoareandɨ nindoundɨ fiambe nɨmarɨmbo nindou ranai wataporɨkoate-yu maranda. Nindou ranahandɨ fiambeahɨndɨ moaruwai nendɨ ranai kosɨfoendühɨyo, asu nindou-mayu ranai wataporɨmayu. Ranɨyei nɨmorehɨ nindowenihɨ ranai mahepünahindɨ. ");
INSERT INTO agg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ŋga asu nindou bɨdɨfɨrɨ ai hoafɨyeihɨ seiya, “Sisas ai moaruwai nendɨ-yafe bogorɨ, ahandɨ ndürɨ Bersebur, ahandɨ ŋgɨnɨndɨnambo moaruwai nendɨ ra nindouyei fiambeahɨndɨ raguanambore arandɨ,” masei. ");
INSERT INTO agg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Asu nindou bɨdɨfɨrɨ ai Sisasɨmbo refe hoeifimbo seihehi hohoanɨmoyeihɨya, “Ai Godɨndɨ ratüpurɨyo rawareandɨ ra nafuimbohünda hepünɨfeimbɨ moatükunɨ rambɨrea-ndamboane,” masei. ");
INSERT INTO agg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Asu Sisas ai ahei hohoanɨmo ra fɨfɨreandürɨ haya hoafɨyundürühɨ yahuya, “Nindou dɨdɨyei ŋgoafɨ mamɨ papɨrɨhi nɨmareimbɨ ranai yimbumbore yɨbobore haya yifiarayo ana, ŋgɨrɨ aboedɨ nɨmboei. Asu nindou mamɨ ranɨ worambeahɨndɨ ranai yimbumbore yɨboborɨhi mburɨhü aheihoarɨ yifiarayei ana, ŋgɨrɨ aboedɨ nɨmboei. ");
INSERT INTO agg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Asu Satanɨndɨ nendɨ ranai yimbumbore yɨbobore haya ahafehoarɨ yifiarayo ana, asu nüŋgunde mamühɨ ŋgɨnɨndɨ manɨŋgoa? Se wambo seiya, ‘Ai ana moaruwai nendɨyei bogorɨ ahandɨ ndürɨ Berseburɨndɨ ŋgnɨndɨnamboani moaruwai nendambo hefoare arandɨ,’ masei. ");
INSERT INTO agg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Asu ro Berseburɨndɨ ŋgɨnɨndɨnambo moaruwai nendɨ ra raguanambo-mbarɨhea mbonana, asu sɨhei nendɨ ai dade ŋgɨnɨndɨnambo moaruwai nendɨ ra raguanamboru arunda? Sɨhei nendɨ ranai sɨheimbo yɨbobondundürühɨ sɨhei hoafɨ ra anɨhondüyopoanɨ mbɨsɨmo nafuindɨmboemo. ");
INSERT INTO agg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ŋga asu God ai ahandɨhoarɨ wambo ŋgɨnɨndɨ ra sendɨranɨ ranɨ ŋgɨnɨndɨnambo moaruwai nendɨ ra raguanambo-arɨheandɨ ana, awi se randɨhi fɨfɨrɨndɨhindɨ God ai ŋgɨnɨndɨ hɨfandarandɨ ra sɨheimbo-so tüküfemboane. ");
INSERT INTO agg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nindou harɨ ŋgɨnɨndɨ ai muŋguambo yifiarɨ nɨmɨnehoarɨ gugure haya ahandɨ worɨ ranahambo hɨfandarandɨ ana, ahandɨ muŋguambo moatükunɨ ranai aboedɨ yagodɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ŋga asu nindou ŋgorü harɨ ŋgɨnɨndɨ hondü ai tüküfi nindou ranɨ-dɨbo yifiarɨyafanɨmbo ahambo hɨfɨnamboarirɨ ana, nindou muŋguambo nindou fehefe yifiarɨmbo napo ra fufundamündühɨ asu ahandɨ-mayo napo muŋguambo ra nindou amurambo yɨbobondearümbui. ");
INSERT INTO agg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nindou düdi ai wandɨ ŋgunindɨyupoanɨ ehu aiana wambo yɨboaruko-reandɨrühani. Asu nindou düdi ai wambo farɨhefendɨrɨ hefe nindou ranaheimbo gugurɨfendürɨ-koate-ayu ana, ai aheimbo warɨbadandürɨ wakɨndearümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sisas ai yahuya, “Moaruwai nendɨ nindou-mayu ranahandɨ fiambeahɨndɨ makosɨfoendɨ ranai nɨne hɨfɨ nɨŋondɨ anaŋgo ranɨnambo ranɨhü warɨhefe nɨmarɨmbo kokora howohane. Ai fondɨ ra mam-amboanɨ hoeifekoate-ayo ana, ai ahandɨhoarɨ hoafɨndowohü anɨmboya, ‘Awi ro asükainda wandɨ horombodɨdɨ worɨ hɨnɨŋgɨmarɨheandɨ ranɨnambo hɨhɨrɨndahe ŋga,’ mbɨsɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Asu ai ŋgo worɨ ra hoeindeanda moanɨ aboedɨ yɨhoarɨhefe dɨdɨboado-yɨmɨndümbɨ fondarɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Rananɨmbo asu ai ŋgo moaruwai nendɨ 7 bɨdɨfɨrambo fihɨndamɨndɨndürɨ ŋgo ai mamɨ ranɨ worambe nɨmandeimboyei. Moaruwai nendɨ süŋgu tükümehindɨ ranai moaruwai hamɨndɨ-ndeimboyei. Muŋguambo ai nindou-mayu ranahandɨ fiambe gugurɨndahi nɨmandianɨ anɨmbo nindou ranai horombo mamaru nahurai nɨmarɨkoate moanɨ moaruwai hamɨndɨ hondü nɨmandümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ranɨyo asu Sisas ai ranɨ hoafɨ ra yare hoafɨyuambe nɨmorehɨ mamɨ ai nɨmorehɨ nindowenihɨ afɨndɨ meŋgoro ranɨ mbusümo botɨfe Sisasɨmbo hoafɨyowohü yahoya, “Nɨmorehɨ ndanai sɨhambo wakɨramɨndɨnɨnɨ mbura tɨtɨhümaranɨnɨ ranai ana hɨhɨfɨ-hɨhɨfɨmbeyo-wamboane,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Asu Sisas ai sɨmborɨ ahambo hoafɨyundühɨ yahuya, “Nindou dɨdɨyei ai Godɨndɨ hoafɨ hɨmborɨyei mburɨhü ranɨ-süŋguarɨhindɨ aianɨmbo hɨhɨfɨ-hɨhɨfɨmbeyei-amboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nɨmorehɨ nindowenihɨ afɨndɨ ranai türehowohü ahambo akɨmɨ kakɨmarɨhomɨndei heiamboyu aheimbo hoafɨyundürühɨ yahuya, “Nindou hapondanambe anɨmboei ndanai ana awi nindou moaruwai hamɨnd-anei. Ai ana hepünɨfeimbɨ moatükunɨ hoeifemboanei hohoanɨmoayei sapo wamboya ai anɨhondü Godɨndɨ ratüpurɨyo ratüpurayu yaho fɨfɨrɨfembohünda. Ŋga asu aiana ŋgɨrɨ nɨnɨ-moatükunɨyo tükefeyo ranahambo hoeindɨhindɨ, ŋga wanɨ. Aiana sapo nindou Godɨndɨ hoafɨ hoafɨyu-randeimbɨ ahandɨ ndürü Sonambo nɨne-moatükunɨ tükümefeyondo ranɨ-moatükunɨ yaŋgɨrɨ anɨmbo hoeindɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mare yahuraiyo Godɨndɨ hoafɨ hoafɨyu-randeimbɨ nindou Sona ai Ninife ŋgoafɨhü nindou amarei ranaheimbo yahurai-ane yaho nafuiyo-ndürɨmbohünda tükümefeyo. Mare yahurai-anɨmbo Nindou Hondü ndanai-amboanɨ tükündüfimbui God ai nindou hapondanambe amarei ranaheimbo nafuiyo-ndürɨmbohünda. ");
INSERT INTO agg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","God ai nindoumbo yɨbobofendürɨmboayu ranɨ si tüküfeyoambe anɨmbo bogorɨ adükarɨ nɨmorehɨ hɨfɨ warɨ kadüdanɨpoedɨ ai tükündɨfe nindou hapondanambe anɨmboei ranaheimbo nɨnɨ-moatükunɨ ai moaruwai ramarɨhindɨ ranɨmbo papɨ-hoafɨndandürɨmboe. Ranɨ-moatükunɨ refemboayo ra nɨmboe sapo ai adükarɨ bogorɨ Soromonɨndɨ ndofe fɨfɨrɨfe hoafɨ hɨmborɨmbo-hündambo ahandɨ hɨfɨ bɨdɨfɨranɨ aŋgunɨpoedɨ hɨnɨŋgɨre haya masɨno. Ŋga ro sɨheimbo hoafehandürɨ nindou sɨhei mbusümo anüŋgu aiana Soromonɨmbo ŋgasündirümboani. ");
INSERT INTO agg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","God ai nindoumbo yɨbobofe-mboayu ranɨ si tüküfeyoambe ana Ninife ŋgoafɨhündɨ nindou ranai botɨndahi nɨmboeimbo sɨheimbo papɨ-hoafɨndühürɨmboyei. Ai refemboayei ra nɨmboe sapo Sona ai hoafɨ wataporɨmbo-maranda hɨmborɨyei mburɨhü moaruwai hohoanɨmo ahei ra hɨnɨŋgɨmarɨhindɨ ranɨmbo-hünda. Ŋga asu ro sɨheimbo hoafehandürɨ sɨhei mbusümo nindou mamɨ anüŋgu aiana Sonambo ŋgasündirümboani,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sisas ai yare hoafɨyuhɨ yahuya, “Nindou dɨdɨ ai moai ram hai ra yimundɨhi mburɨhü wambürɨ hoarehɨ dɨbonapɨrühi rɨhündɨ, ŋga wanɨ. Aiana moanɨ sapo yimundɨhi mbundɨhümbo nɨmoamo fondɨwamɨ nindɨhindanɨ anɨmbo si ranai boakɨboadeandanɨ nindou dɨdɨyei worambe fandahindühɨ hoeindɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sɨhei hɨmboarɨ ra sɨhei hohoanɨmo ranahandɨ ram hai nahurai-anendürɨ. Asu sɨhei hɨmboarɨ ra aboedayondürɨ ana, sɨhei hohoanɨmoambe si ranai boakɨboadeandürɨmboe. Ŋga asu sɨhei hɨmboarɨ ranai moaruwaiayo ana, sɨhei hohoanɨmoambe nɨmbɨ bündearümboe. ");
INSERT INTO agg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ranɨmbohündambo anɨmbo se hɨbadɨhümbo, ŋga asu sɨhei hohoanɨmoambe si amaro ranai nɨmbɨndeamboe. ");
INSERT INTO agg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Asu muŋguambo hohoanɨmoambe sɨhei fiambe ranai si yaŋgɨrɨ boakɨfoareandühɨ gorügoanɨnɨ nɨmbɨ nɨmarɨkoate-ayondürɨ ana sɨheimbo si ranai boakɨboade-andürɨmboe ram hai si boakafoareandɨ nou,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sisas ai wataporɨmbora mbura asu Farisi nindou mamɨ ai hoafɨyundühɨ yahundoya, “Dügüfɨ dagoade-ndɨhoamboane,” mehundo. Ranɨyu asu Sisas ai hüfu farɨfi sesɨ fondɨhü mamaru. ");
INSERT INTO agg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ranɨyo asu Farisi nindou ranai Sisas warɨ popaikoate nɨmarü sesɨ ra masesuwa hepünɨmefiyu. ");
INSERT INTO agg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Adükarɨ ai hoafɨyundühɨ yahuya, “Farisi nindou seana hoe sɨmɨndɨ hɨpɨrɨ asu sesɨ foefe sesɨ hɨpɨrɨ ra moanambüh-ane ndoru popoaiarɨhoemo. Ŋga sɨhamundɨ wagabeyahɨ ana hümbuhünɨ hohoanɨmo asu muŋguambo moaruwai hohoanɨmoane amaropurɨ. ");
INSERT INTO agg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Seana hɨhɨndɨ hohoanɨmo-yomondeimb-anemo nɨmboe sapo God weindanɨ nafɨmarandɨ ai wagabe-amboanɨ nafɨmarandɨ. ");
INSERT INTO agg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nɨne hohoanɨmo aboedɨ sɨhamundɨ ŋgusüfoambe amaropurɨ ranambo nindou dɨdɨyei nɨne napo mbonɨmbo-arɨhümündi ranaheimbo fandɨhaundürɨ. Rawarundɨ anɨmbo asu sɨhamundɨ muŋguambo moatükunɨ ra aboedɨ yaŋgɨrɨndɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Farisi se hɨpoanɨmboembou-anemo! Nɨmboe sapo seana muŋguambo akɨdɨbou sesambefembo moatükunɨ wambɨfɨ nahurai ranane se yimuŋgurundümo mburu asu 10 ranahandɨ ŋgorü bɨdɨfɨrɨ ra Godɨmbo yɨboboru asɨhoemo. Ŋga seana mbumundɨ hohoanɨmo asu Godɨmbo ŋgusüfo pefembo hohoanɨmo ranahambo hɨnɨŋgɨrumboanemo. Se ranɨ hohoanɨmo ra afɨndɨ hohoanɨmo-ndɨmondühɨ asu se ŋgorü ahɨnümbɨ ra hɨnɨŋgɨfe poanɨ. ");
INSERT INTO agg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisi, se hɨpoanɨmboembou-anemo! Ŋga seana Suda-yafe rotu worɨ ranambe bogorɨmbofe nɨmarɨmboanemo hohoanɨmoemo. Asu nindou ai sɨhamumbo nindou afɨndɨ hɨmboahü hɨhɨfɨ-mbɨrɨhümuna yahomo houmboanemo. ");
INSERT INTO agg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Se hɨpoanɨmboembou-anemo! Se hoeifekoateimbɨ yɨf-ambe nahurai-anemo. Nindou yɨf-ambe ranahambo fɨfɨrɨfekoate ranɨwamɨ hei hehi asu ranɨnambo moaruwai tükümehindɨ. Yahurai-ane sɨhamundɨ moaruwai hohoanɨmo wagabe ragu amaropurɨ ranai nindou-yafe hohoanɨmo moaruwaimbo-ndeandürɨmboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nindou mamɨ ahɨnümbɨ hohoanɨmo fɨfɨreandeimbɨ ai hoafɨyuhɨ yahuya, “Yamundo-randeimbɨ, se ranɨ hoafɨ Farisimbo hoafayafɨ ranana yɨhoefombo kameihɨ moaruwaimbo-rowamunühanafɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Asu Sisas ai hoafɨyuhɨ yahuya, “Ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ, Se hɨpoanɨmboembou-anemo. Seana nindou bɨdɨfɨrɨyei daboahamɨndɨwamɨ nɨmboreimbɨ mbɨsahümündi yahomo houmbo hüputüpuründümo nandundühanemo. Asu seana ŋgɨrɨ akɨdou-amboanɨ warɨ pandundɨ nɨmboreimbɨ moatükunɨ aheiwamɨ manandundɨ ranahambo farɨhefendürɨ hefe semɨndɨmbo, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Se hɨpoanɨmboembou-anemo! Ŋga seana Godɨndɨ hoafɨ hoafɨyomo rundeimbɨ sɨhamundɨ amoao mamɨ hɨfokoa-marupurɨ ranahamundɨ yɨfambe yihururu arundɨ. ");
INSERT INTO agg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Seana nafuiyomo-ndühanemo, sapo sɨhamundɨ amoao Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨmbo hɨfokoamarüpurɨ ranahambo aboed-ane yahombo. Nɨmboe sapo ai ahamumbo hɨfokoamarüpurɨ, ŋga se ahamundɨ yɨfambe yihururu arundɨ. ");
INSERT INTO agg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Asu aboedɨ ndorɨhoayoweimbɨ hohoanɨmo Godɨndɨ-mayo ranai hoafɨyowohü yahoya, ‘Ro Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ asu hoafɨ sowandümo homo-rundeimbɨ ra koandɨhe-heapuranɨ bɨdɨfɨrɨ hɨfokoandupurɨ-mboemo, asu bɨdɨfɨrambo moaruwaimbo-ndüpurɨmboemo,’ meho ");
INSERT INTO agg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Muŋguambo nindou hapondanambe ai hütiyomo Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ hɨfɨkoamarüpurɨ. Horombo God ai hɨfɨ nda nafɨrandambe peyo haya sɨnɨmbo hapondadɨdɨ nɨmorehɨ nindowenihɨ burayei aheimbo yagodɨmboe, ŋga ranɨ süŋgumbo anɨmbo tɨŋɨrɨfo ndahümündimboyei. ");
INSERT INTO agg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ai nindou hɨfokoako-marüpurɨ Aber nüŋguwamɨ pɨyo haya sɨnɨ Sekaraia nüŋguwamɨ kɨkɨre hɨnɨŋgɨmareandɨ. Ŋga asu ranahambo Godɨmbo sesɨ sɨhefe fondɨkɨmɨ Godɨndɨ worambeyo kefoaru marundɨ. Muŋguambo moaruwai hohoanɨmo ranahandɨ hüti ra nindou hapondanambe burayei aheimbo ranɨ süŋgumbo anɨmbo tɨŋɨrɨfo ndahümündimboyei. ");
INSERT INTO agg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ, se hɨpoanɨmboembou-anemo. Ŋga seana fɨfɨrɨfe aboedɨ semɨndɨmbo-mayo ranahambo yipurɨ papɨru hɨnɨŋgɨrundühanemo. Ŋga seana sɨhamundɨhoarɨ kefoundühɨyomo-poanɨ, ŋga asu bɨdɨfɨrɨ ai kefoefe fɨfɨrɨfe semɨndɨmbo seianɨ-ane asu se nafɨ gürarundürɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sisas ai worɨ nɨmarümbɨ ra hɨnɨŋgɨre hayambo hu-ane ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨyomo asu Farisiyomo ai ahambo moaruwaimbo-rüwurühɨ düdu-düdumarurɨ. ");
INSERT INTO agg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ai ahambo refi hoeifiyuwanɨ asu aboedɨ sɨmborɨ hoafɨkoate-nduanɨ ahambo papɨ-hoafɨndɨhurɨ yahomo houmboemo ramarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nindou afɨndɨ tausen gugureandühɨyo asu sɨmborɨ tɨŋarɨ yipütapürɨmayei. Ranɨyu asu Sisas ai ahambo süŋgrurü-rundeimbɨmbo boatei hoafɨyupurühɨ yahuya, “Se Farisi-yomondɨ fufudɨgoyo-randeimbɨ moatükunɨ yis ranahambo hɨbadümbo. Ro hoafayahɨ ranana ahamundɨ yimbu yafambeimbɨ hohoanɨmo ranahambo anahɨ hoafayahɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nɨne-moatükunɨ muŋguambo hapondanambe gabudambe eŋgoro ranana asu süŋgunambo weindahɨ gabudɨwamɨ nɨmoamo yagodɨmboe. Asu nɨne-moatükunɨ muŋguambo dɨbo meŋgoro ranai weindahɨ fɨfɨnde fɨfɨndendamboe. ");
INSERT INTO agg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nɨne-moatükunɨ nɨmbɨ nɨmaroanɨ hoafɨmayei ra asu si peyowohü hɨmborɨndeimboyei. Asu nɨne-moatükunɨ se-dɨbo yipurɨ parɨhi hehi hoafɨ sɨmoasɨnambo wataporɨmbo-marɨhündɨ ra weindahɨ worɨ bogɨmondɨwamɨ nɨmboeimbo puküna hoafɨndeimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Wandafɨ mamɨ, ro sɨheimbo hoafehandürɨ, nindou fi hoearɨ yaŋgɨrɨ hɨfokoaru arundɨ ranahambo se yɨhɨmboyopoanɨ, ŋga asu ŋgɨrɨ yifiafɨ ana hɨfokoandundɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ŋga ro daboe yɨhɨmbombo ra sɨheimbo hoafɨndamboyahɨ. Godɨmbo se yɨhɨmbondei sapo ai anɨmbo hɨfokoefe mburɨmbo hai ŋgoafɨnambo koarɨhefe rambo ŋgɨnɨndeimbayu ranɨmbo-hünda. Anɨhondane, mamɨ ranahambo yaŋgɨrɨ anɨmbo yɨhɨmbondefomboane. ");
INSERT INTO agg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ndu akɨdou hondahüfeimbɨ ra yimbu toeanambo yaŋgɨr-ane pemɨyei sahümündi arɨhündɨ. Ŋga asu God ai ŋgɨrɨ mamamboanɨ mɨtanɨndamündu. ");
INSERT INTO agg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ŋga asu God ai nüŋgunümbɨ mbɨrɨnaŋɨyo sɨhafɨ mbɨroambe amaro fɨfɨreamboani. Ranɨmbo-anɨmbo se yɨhɨmbo-ndeimboyei, seana Godɨndɨ hɨmboahü ndu akɨdou ranaheimbo ŋgasündɨ-hindürɨmboanei,” mehu ");
INSERT INTO agg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sisas ai hoafɨyuhɨ yahuya, “Ro sɨhamumbo hoafehapurɨ nindou düdi nindou hɨmboahü nüŋgumbo ro Sisasɨmbo anɨhondümbo-rɨhinɨmboanahɨ ehu ana, sɨmborɨ nindou ranahandɨ ndürɨ Nindou Hondü ro Godɨndɨ sünambeahɨndɨ nendɨ-yomondɨ hɨmboahü nindou ranana wandani mbɨsamboyahɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ŋga asu nindou düdi nindou hɨmboahü nüŋgumbo wamboya moai ahambo anɨhondümbo-rɨhinɨ ehu ana, asu sɨmborɨ amboanɨ Godɨndɨ sünambeahɨndɨ nendɨ-yomondɨ hɨmboahü ai wandɨyupoanɨ mbɨsamboyahɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nindou düdi ai Nindou Hondümbo moaruwai hoafayu ana, God ai amboawi mbüsümbui. Ŋga nindou düdi ai Yifiafɨ Aboedɨ ranahambo moaruwai hoafayu ana, God ai ŋgɨrɨ amboawi mbüsu, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ai sɨhamumbo rotu worɨnambo papɨ-hoafɨ hɨmborɨyomo-rundeimbɨ asu bogorɨ nindou-yomondɨ hɨmboahü ndowapundümo ŋgomondanɨ ro nüŋgunahurai asu nɨnɨ hoafɨ hoafɨmandefɨ mbɨsɨmo houmbo ranahambo afɨndɨ hohoanɨmondɨmboemo. ");
INSERT INTO agg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mamɨ ranɨ-sɨmboanɨ anɨmbo se nɨne hoafɨ hoafɨmbo ra Yifiafɨ Aboedɨ ranai sɨhamundɨ hohoanɨmoambe horɨnde dagapurɨmboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nindou afɨndɨ gugure meŋgoro ranambeahɨndɨ mamɨ ai hu Sisasɨmbo hoafɨyuhɨ yahuya, “Nindou yamundo-randeimbɨ, se wandɨ amoŋgoambo hoafɨndafanɨ ai apendɨ-mayo napo yɨhoehɨ ra yɨbobondɨhoa-mɨndembo,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Asu Sisas ai hoafɨyundowohü yahuya, “Dɨdɨ ai hoafɨmayuwamboyo ro sɨhafandɨ papɨ-hoafɨ hɨmborɨyohü yɨbobofembo rana?” ");
INSERT INTO agg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Asükai hoafɨyundürühɨ yahuya, “Se ndondɨhi hɨbadɨhümbo, ŋga muŋguambo moatükunɨ semɨndɨmbo afɨndɨ hohoanɨmondɨmboemo. Ŋga se ŋgɨrɨ koadürü koadürümbo nɨŋgo napo ranɨfihɨ ndowandɨfɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sisas ai kafoefe hoafɨ ra wataporɨmbo-randühɨya, “Nindou napo afɨndeimbɨ mamɨ ranai hɨfɨ ranɨfihɨ nümbürɨ hɨfɨreandanɨ afɨndɨ safɨmayo. ");
INSERT INTO agg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nindou ranai aimbo nɨmarü hohoanɨmoyuhüya, ‘Ro nɨnɨ nünüŋgundɨheambo, ŋga nümbürambeahɨndɨ sesɨ ra kurɨfembo fondɨ wanayo,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ranɨyu asu hoafɨyuhɨya, ‘Awi ro nda süŋgundɨhea. Wandɨ sesɨ worɨ ra muŋgu bɨrɨboadɨhe mbundɨhambo mamɨ afɨndɨ worɨmbondɨhɨ mbundɨhambo wit asu amurɨ napo ra kundɨheamboyahɨ.’ ");
INSERT INTO agg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Rananɨmbo wandɨfimbo hoafɨndahühɨya, ‘Hapoana afɨndɨ hɨmboanɨ aho ra sesɨmbo aboedɨ napo ra waŋgei-ane. Ŋga nɨmandefɨ sesɨ ra dagudifɨ hoe ndɨmɨndefɨ raraondɨhundühɨ hɨhɨfɨ-hɨhɨfɨndefo,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ŋga asu God ai hoafɨyundühɨ yahuya, ‘Seana ŋgusüfokoate nindou-anafɨ! Hapo nɨmbɨkoanɨ anɨmbo se yɨfɨndamboyafɨ. Ŋga asu nindou dɨdɨ ai napo sɨhafɨ-mayo ndorandɨfɨ masɨhawandɨ ra mandemünda?’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yahurai anɨmbo nindou dɨdɨyei napo afɨndeimbayei aheimbo tükündɨfemboe, ŋga aiana Godɨndɨ hɨmboahü napo-koate-anei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sisas ai ahambo süŋgrurü-rundeimbɨmbo hoafɨyuhɨ yahuya, “Ro sɨhamumbo hoafehapurɨ nda, Se nɨnɨ sesɨ madagudifɨ mbɨsɨmo asu nɨnɨ hoearɨ yɨhoefɨ fi gabudɨmandɨhu mbɨsɨmo houmbo afɨndɨ hohoanɨmondɨmboemo. ");
INSERT INTO agg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yaŋgɨrɨ nɨŋgo ranane adükarɨ hamɨndayo, ŋga sesɨ ana moanane asükai fi-ane adükarɨ hamɨndayo, ŋga hoearɨ ana moanane. ");
INSERT INTO agg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Asu awi se ndu nɨmoamo ahahabodei ranaheimbo hoeirundürɨ. Ndu ranai ana moai nɨnɨ-moatükunɨ hoarɨ hɨfɨkarɨhi, sesɨ yimuŋgurɨhümündi hei worambe sɨhehi raraorɨhündɨ, ŋga aheimbo ana God ai sesɨ ra sagadürɨ arandɨ. Ŋga seana ndu ranaheimbo ŋgasündɨhi-ndürɨmboanei. ");
INSERT INTO agg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Se ranɨ-moatükunɨmbo afɨndɨ hohoanɨmoayafɨ ranai ŋgɨrɨ fandɨhenɨnanɨ akɨdou gedühɨ safɨ yaŋgɨrɨ nɨmbafɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Asu se akɨdou moatükunɨ yahurai ra ndofe hɨfandɨyokoate-ayafɨ ra asu nüŋgundo adükarɨ moatükunɨ ra hɨbadɨmandanda? ");
INSERT INTO agg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nüŋgure hayamboyo wohɨ ahurɨyei arɨhündɨ ra hoeiru, aiana moai ahei fimbohünda hoearɨ kakɨyei asu ratüpurɨyei rɨhündɨ. Ŋga ro sɨhamumbo hoafehapurɨ horombo adükarɨ bogorɨ Soromon ai napo afɨndeimbɨyu, ŋga ahandɨ yihuru aboedɨ yihurumaramündu ra wohɨ ahurɨ ranai Soromonɨndɨ yihuru ra ŋgasündeamboane. ");
INSERT INTO agg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","God ai wohɨ hapondanɨ yaŋgɨrɨ amaro ra hɨfɨhü hoearɨ yihurure hɨnɨŋgɨreandühani, ŋga asu sümbo ana haiambe pifemboane. Se akɨdou anɨhondümbofe-koate-yomondeimbɨ God ai sɨhamumbo amboa hoearɨ yihurundeapurɨmbui. ");
INSERT INTO agg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Se nɨnɨ sesɨmboyo mbɨsei asu nɨnɨ sɨmɨndɨramboyo mbɨsei hehi ranahambo afɨndɨ hohoanɨmondei ŋgeimboyei, ŋga yowanɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Godɨmbo anɨhondümbofe-koate-yeimbɨ ana muŋgu moatükunɨ ra semɨndɨmboane hohoanɨmoayei, ŋga Ape God ai fɨfɨreamboani se semɨndɨmbo afɨndɨ hohoanɨmoayei ra. ");
INSERT INTO agg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ŋga God ŋgɨnɨndɨ hɨfandarandɨ ranahambo kokondundanɨ anɨmbo ranɨ amboanɨ dagapurümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sipsip afɨndɨfurɨ ra se yowanɨ yɨhɨmbo-ndeimboyei, ŋga ndühɨ sühüsi, sɨhei Ape ai sɨheimbo amboanɨ ŋgɨnɨndɨ hɨfandarandɨ ranambe hɨfandɨyondürɨmbo yifirayu. ");
INSERT INTO agg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Se sɨhamundɨ napo ra kakɨfihɨ koandɨhou mbundu asu napo-koate-yeimbɨ ranaheimbo kakɨ ra dabudürɨ. Se kakɨ foefe hɨpɨrɨ yahurai ndowandümo nɨmai moaruwaiyo rakoate-yoweimbɨ asu rananɨmbo aboedɨ napo sünambe gugurɨndundɨ. Ŋgɨrɨ sünambe ana fandɨhoayo, ŋgɨrɨ hümbuhünɨ nindou ndahümündi asu süsɨmbümɨ ai dagüdi. ");
INSERT INTO agg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sɨhei ŋgusüfo ana sapo nahi sɨhei napo yaŋgorɨhɨ anɨmbo kündarümbui.” ");
INSERT INTO agg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Se hoearɨ yihuru-rɨhümündi amarei nou nɨne-moatükunɨ tüküfemboayo ranahambo hɨbadühündühɨ sɨhei ram ra yimundɨhinda simbeyowamboane. ");
INSERT INTO agg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Se ratüpurɨyei rɨhündeimbɨ nahuraindeihɨ asu ahei bogorɨmbo nindou ai nɨmorehɨ semɨndɨmbo si ra hu mbura asu hɨhɨrɨfi huanɨ nou hɨbadɨhorɨ. Ai süfu yipurɨ fihɨ pɨrako-pɨrakondandanɨ nɨmai yipurɨ sübüdɨhehindɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Asu ahei bogorɨ nindou ranai hu hɨmboyuwanɨ yapombofekoate yaŋgɨrɨ nɨmarei ahambo hɨfandarɨhorɨ ana, ai hɨhɨfɨ-hɨhɨfɨndei. Ro sɨheimbo anɨhondümboanahɨ hoafehandürɨ bogorɨ nindou ranai ahandɨ warɨhoandarümbɨ ŋgɨsɨharɨ hoearɨ ra yimündɨhai mbunda hoafɨndündüranɨ sesɨ fondɨkɨmɨ nɨmandeianɨ düdɨ sesɨ dagadürümbui. ");
INSERT INTO agg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ratüpurɨyei-rɨhündeimbɨ ranai nɨmbɨ mbusümomboyo asu si hoafɨmboyo hɨfandɨhümbo nɨmareianɨ ahei bogorɨ nindou ranai hu hoeiareandürɨ ana, ai hɨhɨfɨ-hɨhɨfɨndeimboyei. ");
INSERT INTO agg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Se fɨfɨndɨhindɨ sapo worɨ aharambürɨ ranai nɨnɨ-sɨmboanɨyo hümbuhünɨ nindou tüküfemboayu ra fɨfɨrareandɨ ana, tükündafu hümbuhünɨ-ndɨmboemo mbüsɨ haya günde nɨmandümbui. ");
INSERT INTO agg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ranɨmboane se-amboanɨ hɨbadɨhümbo, ŋga Nindou Hondü ranai tüküfembo ra mɨtanɨ-rɨhümündi hehi hɨdɨbo-hɨdɨboyeiambe anɨmbo kudümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita yahuya, “Adükarɨ hoafayafɨ nda yɨhoefɨmbo yaŋgɨrɨyafɨ asu muŋguambo nindoumboyafɨ?,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sɨmborɨ Adükarɨ ai hoafɨyuhɨ yahuya, “Nindou düdi ai aboedɨ ndore anɨhondümbo fɨfɨreandeimbɨyu haya aboedɨ ratüpurɨyu randeimbeyua? Nindou ranahambo ahandɨ bogorɨ nindou-mayu ranai anɨhondümbo-rirɨ hayambo wambo worambe sesɨnapo eŋgoro ra hɨfandɨyohü ratüpurɨyomo rundeimbɨ nindou ai sesɨ semɨndɨ sɨmboanɨ segupurɨ rambohünda kaboadirɨ hɨnɨŋgɨndirümbui. ");
INSERT INTO agg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nindou ranahandɨ bogorɨ nindou ranai worambe tüküfi hoeiriranɨ ratüpurayu ana, moanɨ afɨndɨ hamɨndɨ hɨhɨfɨ-hɨhɨfɨ-mbiyuwamboane. ");
INSERT INTO agg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ro sɨhamumbo anɨhondümboanahɨ hoafehapurɨ, bogorɨ nindou ranai nindou ranahambo ahandɨ muŋguambo moatükunɨ ranahambo hɨfandɨmbo bogorɨmbondirü hɨnɨŋgɨndirümbui. ");
INSERT INTO agg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ŋga asu nindou ranai yare hohoanɨmoyuhüya, ‘Awi, wandɨ bogorɨ nindou ranai ŋgɨrɨ nɨmehünou hɨhɨrɨndüfi düdu,’ yahu haya bodɨmondɨ ratüpurɨyei rɨhündeimbɨ nɨmorehɨ nindowenihɨ ranaheimbo bubuhaiyu sesɨ sesü bia ndümündü haya hɨhɨndɨ hohoanɨmondümbui. ");
INSERT INTO agg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ŋga asu bogorɨ nindou ranahambo ahandɨ ratüpurɨyu-randeimbɨ ranai mamɨ sɨmboanɨ ŋgɨrɨ tükündɨfiyu mbüsɨ haya hɨdɨbo-hɨdɨboyuambe anɨmbo tükündüfimbui. Rananɨmbo bogorɨ nindou ranai bubundürɨ mbunda koandɨheiranɨ ŋgu nindou bɨdɨfɨrɨ hɨmborɨkoate-yei rɨhündeimbɨ babɨdɨmbo nüŋgumbui. ");
INSERT INTO agg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ratüpurɨ-yurandeimbɨ ranai ahandɨ bogorɨ nindou ai refembo yifirayu ra fɨfɨreandɨ, ŋga ai refekoate-yu, asu bogorɨ nindou ai yifirayu süŋgufekoate-ayu ana, bogorɨ nindou ranai afɨndɨmbo bubundürümbui. ");
INSERT INTO agg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ŋga asu ratüpurɨyu-randeimbɨ ranai ahandɨ bogorɨ nindou yifirayu ra fɨfɨrɨfekoate-yu haya ndofe ratüpurɨkoate-ayu ana, asu yimbumamɨmbo safɨ bubumboani. Sapo nindou dɨdɨyei afɨndɨ hamɨndɨ masahümündi ana, asu sɨmborɨ afɨndɨ hamɨndɨ mbɨsehindamboane. Asu nindou ranahei warɨhü afɨndɨ hamɨndɨ asɨhehindɨ ana, asu sɨmborɨ afɨndɨ masɨhehindɨ ra ŋgasündeandeimbɨ segodürɨmbo hohoanɨmombeye-amboane.” ");
INSERT INTO agg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ro makosahɨ nda hɨfɨ ndanɨhü hai püpifemboyahɨ makosahɨ asu hai ranai yimbeyowa sahehea yifiar-ayahɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nindou hoeambe hundürayei nou ro asübusɨ afɨndeimbɨ hundürü-ndamboyahɨ, ŋga hundürü ra awi moai hundürüyahɨ ranɨmboanahɨ ŋgusüfo sɨhayahɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Se randɨhi hohoanɨmondeihɨya, ‘Ai ana yifiarɨ yifiarɨ hɨfɨ ndanɨhü eŋgoro ra kɨkɨfembo makusu-ane,’ mbɨseimboyei, ŋga wanɨ. Ro moai yifiarɨ yifiarɨ ranahambo kɨkɨfembo kosahɨ, ŋga nindou yikürübüfe-ndürɨmboyahɨ makosahɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Hapondanɨ peyo haya aho ra nindou mamɨ ai ahandɨ fikɨmɨnɨndɨ hondahüfeimbeimbayu ana, yɨbobondahimboyei. Rananɨmbo yimbumbündafe asu ŋgorü ŋgɨmeimbɨndei hehi sɨmborɨ sɨmborɨndeimboyei. ");
INSERT INTO agg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Rananɨmbo yɨbobondahi mbundɨhü, nindowenihɨ nɨmorɨ ai afɨndambo asu afɨndɨ ai nɨmorɨmbo hürütürɨ-ndamboyafanɨ. Asu nɨmorehɨ ai ahandɨ nɨmorehɨ nɨmorɨ-dɨbo sɨmborɨ hürütürɨndafe asu yamoŋgoamɨndoho ai sɨmborɨ hürütürɨndafe rarandeimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sisas ai nindou afɨndɨ ranaheimbo hoafɨyundürühɨ yahuya, “Se hoeirɨhindanɨ hüfɨhamɨndɨ hanuwanɨpoedɨ hoenɨmbaŋɨ sɨfowanɨ hoeirɨhindühɨ hoendɨmboe seianɨ asu hoeyo arandɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Asükai se hoeirɨhindanɨ ŋgɨrɨsafɨnɨpoedɨ werɨ sɨfowanɨ yahɨmondɨmboe seianɨ asu yahɨmoyo arandɨ. ");
INSERT INTO agg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Seana yimbu yafambeyeimb-anei, sapo se fɨfɨrɨhimboanei nɨne moatükunɨ hɨfɨnɨ asu sünambe tükefeyo ra. Asu nɨmboe nɨne-moatükunɨ hapondanɨ God ai ratüpurɨmayuwa tükefeyo ra fɨfɨrɨfekoate-ayeia?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nɨmboe sɨhafɨhoarɨ yɨbobofekoate-ayafɨ nɨne-moatükunɨyo aboedayo ranahamboa? ");
INSERT INTO agg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Asu nindou ŋgorü ai sɨhambo papɨ-hoafɨyonɨnɨmbo mbüsü haya yɨbobore-randeimbɨ sowana hoafɨ hɨmborɨmbo ndemündünɨnɨ ŋguanɨ ana, se nɨmai ŋgafɨ nafɨnɨ aboedɨ-aboedɨ-ndafɨneandɨ. Asu se refekoate-ayafandɨ ana sɨhambo papɨ-hoafɨ ranɨnɨ-randeimbɨ nindou ranai hoafɨ hɨmborɨyu randeimbɨndɨ warɨhündeanɨna, prisman ai karabusambe hɨnɨŋgɨndeanɨnɨmbui. ");
INSERT INTO agg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ro anɨhondümboanahɨ sɨhambo hoafehanɨnɨ, se rando nɨmandɨfɨmbo kakɨ pemɨndafɨ mehomo sɨmogodühɨ pemayafɨ anɨmbo tükündafoamboyafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ranɨ-sɨmboanɨ nindou bɨdɨfɨrɨ ranai Sisasɨmbo rarɨhi hoafɨyeihɨya, “Nindou Garirihündɨ bɨdɨfɨrɨ ai nɨnɨhondɨ hɨfokoaru Godɨmbo sɨhoundane Pairat ai hɨfokoamareapurɨ. Ranɨyo asu ahamundɨ horɨ ra nɨnɨhondɨ horɨ Godɨmbo saimbo hɨfokoamarundɨ ranɨ bɨtapɨre mamɨkarɨmayo,” masei. ");
INSERT INTO agg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sisas ai hoafɨyuhɨ yahuya, “Ranɨ-moatükunɨ tükümefeyo ra se rarɨhi hohoanɨmoyeiyanɨ ahei moaruwai hohoanɨmo ra Garirihündɨ bɨdɨfɨrɨ ranahei moaruwai hohoanɨmo ra ŋgasündeamboyo? ");
INSERT INTO agg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wanɨ, ŋga ro anɨhondümboanahɨ hoafehandürɨ, Se sɨhei hohoanɨmo ra dɨdɨboadofe-koate-ayei ana, muŋguambo sɨheimbo amboanɨ yahurai tükündɨfendürɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Asu nüŋgurɨyei 18 nindou Siroamɨhündɨ aheimbo nɨmoei worɨ hoandarɨ pɨyowohü hɨfokoamareandürɨ rana? Se rarɨhi hohoanɨmoyeiyanɨ, Nindou worɨnambo hɨfokoamareandürɨ ranahei moaruwai hohoanɨmo ra Serusaremɨhündɨ bɨdɨfɨrɨ ahei moaruwai hohoanɨmo ra ŋgasündeamboyo? ");
INSERT INTO agg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wanɨ, ŋga ro anɨhondümboanahɨ hoafehandürɨ, se sɨhei hohoanɨmo ra dɨdɨboadofe-koate-ayei ana, muŋguambo se-amboanɨ yɨfɨndeimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sisas ai mamɨ kafoefe hoafɨ wataporɨmbo-randühɨ yahuya, “Nindou mamɨ ai ahandɨ wain nümbürambe süfurɨ nɨmɨndɨ ra hɨfɨmareandɨ. Ranɨyo süŋgunambo süfurɨ nɨmɨndɨ ra hɨsɨyohüpo yahuhaya mahu, ŋga moai hɨsɨ mamamboanɨ hoeireandɨ. ");
INSERT INTO agg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ranɨyu asu nindou ranai ahandɨ nümbürambe ratüpurɨyu-randeimbɨ ranahambo hoafɨyundühɨ yahuya, ‘Ro süfurɨ nɨmɨndɨ nda ŋgɨmɨ hɨmbanɨ sɨnɨ hɨmboyarɨhanda moai hɨsɨyorandɨ, ŋga hɨtɨboadowandɨ. Ai hɨsɨ-koate moanɨ hoaŋgɨre haya nɨŋgombo nümbürɨ hɨfɨ bɨdɨfɨrɨ gabudarandɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ŋga asu ahandɨ ratüpurɨyu-randeimbɨ ranai sɨmborɨ hoafɨyundühɨ yahuya, ‘Rɨtɨfo, awi moanɨ mamɨ hɨmbanɨ nɨŋgo hoeireandühɨ anɨmbo, ŋga hɨsɨmboyohüpo. Asu awi ro nɨmɨ ranɨ-fikɨmɨ hɨfambɨ kakɨndɨhɨ mbundɨha, asu yafɨsühumɨ afümambe püpindɨhɨ hoeindɨheamboyahɨ. ");
INSERT INTO agg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Randɨhe hoeindɨheandane ŋgorü hɨmbanɨ ra hɨsɨndoanɨ ana, aboed-ane, ŋga hɨsɨ-koate-ayo ana, hɨtɨfoefemboane,’” mehu. ");
INSERT INTO agg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sisas ai Suda-yafe moanɨ nɨmarɨmbo si ranambe ahei rotu worambe yamundɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ranɨyo ranɨhü nɨmorehɨ mamɨ, 18 hɨmbanɨ ahandɨ fiambe moaruwai nendɨ nɨmarɨmbo amoefoe semɨndɨ haya homarandɨ. Asu ahandɨ daboadɨ hamɨndɨ ra fare hayamboyo asu moai mbumundɨ botɨfe nɨŋgorandɨ. ");
INSERT INTO agg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ranɨyo Sisas ai hoeireanda mayoa mborai mehundowa mahowa hoafɨyundühɨ yahuya, “Me, hapoana aŋgünɨmbomayafɨ ra aboedɨ anafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Sisas ai ahandɨwamɨ warɨ manande-andamboyo asu nɨmehünou mbumundɨ botɨfe nɨŋgombo Godɨmbo aboed-ani yaho ŋgusüfo pamarerɨ. ");
INSERT INTO agg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ranɨyo Suda-yafe rotu worɨ hɨfandandeimbɨ bogorɨ ranai ŋgɨnɨndɨmayu Sisas ai moanɨ nɨmarɨmbo sihɨ nɨmorehɨ aboedɨmareandɨ ranɨmbo. Nindou ranai hoafɨyuhɨ yahuya, “Sapo 6 si-ane ratüpurɨmbo siayo. Ŋga sapo aboedɨfembo ana, ranɨ si anɨmbo refemboyosɨ, ŋga moanɨ nɨmarɨmbo si ana yowan-ane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Adükarɨ ai sɨmborɨ hoafɨyuhɨ yahuya, “Seana yimbu-yafambeimbɨ nindou-anemo! Asu se moai sɨhamundɨ burɨmakau asu doŋgi ra muŋguambo si asu moanɨ nɨmarɨmbo sihɨ ranamboanɨ wofɨ fufurɨhoundürɨ mburu hoe sɨmɨndɨmbo sowandümondürɨ homo rundɨyo? ");
INSERT INTO agg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nɨmorehɨ ro aboedɨmarɨheandɨ, nda ai Abrahamɨndɨ nɨmor-ane, asu ahambo Satan ai 18 hɨmbanɨ kɨkɨhɨramündɨ manüŋgu-ane. Asu ro ahambo moanɨ nɨmarɨmbo sihɨ aboedambo-fembo ra ahɨnümbɨyo.” ");
INSERT INTO agg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sisas ai yare hoafɨmayu-wamboemo asu ahandɨ hürütümbɨ-memo ranai amoanɨŋgambo-mefundɨ. Ŋga asu bɨdɨfɨrɨ afɨndɨ meŋgoro ranai aboedɨ moatükunɨ ramareandɨ ranɨmbo hɨhɨfɨ-hɨhɨfɨmayei. ");
INSERT INTO agg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sisas ai hoafɨyuhɨya, “God ŋgɨnɨndɨ hɨfandarandɨ ra nüŋgunahuraiyowa? Asu ro nüŋgundɨhe yɨbobomandɨhea? ");
INSERT INTO agg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ai rahuraiane, nindou mamɨ ai ahandɨ nümbürambe mastet hoarɨ hambomo nahurai akɨdou hɨfɨreandühani. Asu hoarɨ akɨdou ranɨhündɨ adükarɨ tɨkoanɨ nahurai nɨŋgowanɨ, ndu ai ranɨwamɨ ŋgeramborühɨ arɨhündɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Asükai Sisas ai hoafɨyuhɨ yahuya, “Ro asükainda God ŋgɨnɨndɨ hɨfandarandɨ ranahambo nɨnɨ-moatükunɨfihɨ yɨbobomandɨhea? ");
INSERT INTO agg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nɨmorehɨ ai fufudogoyo-randeimbɨ moatükunɨ yis semɨndɨ haya wambürambe fraua bubufoare mbura yis ra babɨfoareandanɨ fufudogoayo hafo nahuraiane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sisas ai Serusaremɨnambo huhüyu muŋguambo adükarɨ ŋgoafɨ asu akɨdou ŋgoafɨ aheimbo wataporɨmbo-marandürɨ hu. ");
INSERT INTO agg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Nindou ŋgorü ai Sisasɨmbo hoafɨyundühɨ yahuya, “Adükarɨ, yimbu mamɨ nindou yaŋgɨrɨ aboedambo-mandahindɨyo?” mehuamboyo. Ai sɨmborɨ hoafɨyuhɨ yahuya, “Yipurɨ nafɨtambe akɨdou ranambe kefoefembo hütihütindei, ŋga nindou afɨndɨ ai-amboanɨ hütihüti-ndeimboyei ranambe kefoefembosɨ, ŋga ŋgɨrɨndei. ");
INSERT INTO agg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Süŋgunambo worɨ aharambürɨ ai yipurɨ papareandɨ ana, se weindanɨ nɨmboeimbo yipurɨfihɨ pɨrako-pɨrako-ndɨhündühɨ anɨmboya, ‘Adükarɨ, yipurɨ sübüdühawamunɨ,’ mbɨseimboyei. Ŋga sɨmborɨ hoafɨndühɨya, ‘Ro moai sɨheimbo fɨfɨrɨheandürɨ,’ asu ‘Se nahanɨ-hündamboyei?’ mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Rananɨmbo se hoafɨndafühɨya, ‘Ro se-dɨbo sesɨ sahusifɨ hoe sɨmɨndefɨ asu yɨhoefɨ ŋgoafɨ nafɨ hohü yamundowamunɨ marandɨ’ mbɨseimboyei. ");
INSERT INTO agg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Asu ai sɨheimbo hoafɨndühɨ anɨmboya, ‘Ro moai sɨheimbo fɨfɨrɨheandürɨ, ŋga asu nahanɨ-hündamboyei? Andai ragu, ŋga seana moaruwai hohoanɨmoyei rɨhündeimbanei,’ mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Se aranɨndeihɨ asu yahafɨ hɨtɨhündühɨ nɨmboeimboyei, ŋga Abraham, Aisak, Sekop asu Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ ai God hɨfandarandɨ ranambe nɨmandeimboyei, ŋga asu sɨheimbo ana ragu moeindanɨ pindɨhirɨmboyei. ");
INSERT INTO agg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Rananɨmbo nindou afɨndɨ ai hüfɨhamɨndɨ süfuwanɨpoedɨ, hanuwanɨpoedɨ, hɨmborɨ yimbunɨpoedɨ ai God ŋgɨnɨndɨ hɨfandarandɨ ranambe sesɨ fondɨkɨmɨ tükündahi nɨmandeimboyei. ");
INSERT INTO agg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Rananɨmbo nindou dɨdɨyei haponda adükarɨmboehindɨ aiana süŋgunambo akɨdoumbo-ndahimboyei, ŋga akɨdoumboehindɨ aiana süŋgunambo adükarɨmbo-ndahimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ranɨ-sɨmboanɨ Farisi bɨdɨfɨrɨ ai sɨfomo Sisasɨmbo hoafɨyomondowohü yahomoya, “Andai ndanühündambo ragu hafɨ, ŋga Herot ai sɨhambo hɨfokoefenɨnɨmbo yahumboani!” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sisas ai hoafɨyupurühɨ yahuya, “Ŋgomo nindou sɨsɨndɨra randeimbɨ ranahambo hoafɨndɨmo, ŋga hapo sümbo ana ro moaruwai nendɨ fiambe nɨmareimbɨ raguanambo-rɨheandürɨ asu nindou aboedambo-rɨheandürühɨ anahɨ. Ŋga asu ŋgɨmɨ si anɨmbo wandɨ ratüpurɨ ra moendɨndɨ-heamboyahɨ. ");
INSERT INTO agg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Asu ro hapo, sümbo, asaŋgu ranana nafɨ ŋgamboyahɨ. Ŋga sapo Godɨndɨ hoafɨ hoafɨyurandeimbɨ ana ŋgɨrɨ amurühɨ hɨfokoandüwurɨ, ŋga Serusaremɨhü anɨmbo hɨfokoandü-wurɨmboemo. ");
INSERT INTO agg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Serusarem, Serusarem! Seana Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ sɨhambo sowana koehefepura masɨnɨmo ra nɨmoeinambo hɨfokoaroapurɨ arandɨ. Ro afɨndɨmbo sɨhafɨ nindou ranaheimbo kakaro hondɨ nɨmorɨ gugureandürɨ mbanendɨ hoareharamɨndo nou mbanendɨ hoarehɨ-fendürɨmbo samboyahɨ, ŋga moai se yifirɨyei. ");
INSERT INTO agg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Haponda sɨhafɨ worɨ ranambe nɨnɨ akɨdou-amboanɨ yaŋgorɨkoate worɨ yaŋgɨrɨ hamɨndɨndɨmboe. Ro hoafehanɨnɨ, se ŋgɨrɨ hoeindɨ-hindɨrɨ, ŋga ŋgombo se wambo randɨhi hoafɨndeihɨya, ‘God ai aboedɨ-aboedɨ-mbɨriramboane Adükarɨndɨ ndürɨnambo akusu nda,’ mbɨseimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Moanɨ nɨmarɨmbo sihɨ Sisas ai Farisi bogorɨndɨ worambe sesɨ sesɨmbo mahuwa nindou ai ahambo ndorüwurɨ hɨmboarɨ safühɨmarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ranɨhü nindou mamɨ yirɨwarɨ fiyuweimbɨ mamaru. ");
INSERT INTO agg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ranɨyo Sisas ai Farisi nindou-yomo asu ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ-yomo ahamumbo hoafɨyuhɨya, “Moanɨ nɨmarɨmbo sihɨ ra nindou aboedɨfemboyo asu yowanɨyo?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ŋga asu ai moai ahandɨ hoafɨ sɨmborɨ hoafɨyomo. Ranɨyo asu Sisas ai nindou ra serümündü aboedɨrirɨ mbura koamarɨherü. ");
INSERT INTO agg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sisas ai ahamumbo hoafɨyupurühɨya, “Sɨhamundɨ nɨmorɨyo asu burmakauyo ai moanɨ nɨmarɨ sihɨ feamoŋgoambe pɨrayo ra nɨmai hümandɨhouyo asu wanɨmandɨyo?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ranɨyomo asu moai ahambo sɨmborɨ hoafɨyomondo. ");
INSERT INTO agg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","8","Sisas ai hoeireapurane nindou sesɨ sesɨmbo hoafɨmayua tükümefundɨ ranai nɨmarɨfondɨ aboedɨ hamɨndɨwamɨ nɨmarɨmbo hohoanɨmo-memonda yare hoafɨyuhɨya, “Nindou ŋgorü ai sɨhambo nɨmorehɨ semɨndambe sesesɨmbo hoafɨnduanɨ ŋgafühɨ ra se nɨmarɨfondɨ aboedühɨ ndowandɨmboyafɨ, ŋga nindou ndorɨhoeimbɨ ahambo amboanɨ hoafɨyomondowohüpo. ");
INSERT INTO agg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nindou sɨhafanɨmbo yɨboboambo hoafɨmayupɨra mahafanɨ ranai düdü sɨhambo hoafɨndühɨya, ‘Nindou ndanahambo sɨhafɨ-mayo fondɨ ra sabado,’ mbüsümbui. Randɨfiyuwanɨ asu se amoanɨŋgɨndafɨ mbunda ŋgafɨ bɨdɨfɨranɨ fondɨwamɨ nɨmandɨmboyafɨ. ");
INSERT INTO agg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ŋga sɨhambo hoafɨndeianɨ ŋgafühɨ ra fondɨ sapo akɨdou yahurɨŋgoahurɨ safɨ-mayo ranɨwamɨ anɨmbo nɨmandɨfɨ. Rananɨmbo sɨhambo hoafɨmayunɨna mahafɨ ranai ŋgu hoeindeanɨnanɨ wanɨ hoafɨnduhüya, ‘Wandafɨ, fondɨ aboedühɨ ndanɨwamɨ sühüfɨ nɨmarɨfɨ,’ mbüsüwanɨ asu bɨdɨfɨrɨ amurɨ mafandɨhindɨ ranai sɨhambo nindou adükar-ani mbɨseihü ahɨnɨndeimboyei. ");
INSERT INTO agg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nindou dɨdɨyei ai ahei fi botarɨhindɨ ana, God ai hɨfɨnambo-ndearümbui. Asu nindou dɨdɨyei ahei fi hɨfɨnambo-arɨhindɨ ana, God ai aheimbo botɨndearümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sisasɨmbo nindou hoafɨmayundoa mahu ranahambo hoafɨyundühɨ yahuya, “Hüfɨnɨmboyo asu nɨmbambeyo sesesɨmbo ra, se yowanɨ sɨhafɨ ŋgunindɨ, fikɨmɨnɨndɨ, boagɨrɨ, sɨhafɨ napo afɨndeimbɨ wandafɨ aheimbo yaŋgɨrɨ mborai yahopoanɨ. Asu sɨmborɨ amboanɨ ŋgorüsɨmboanɨ hoafɨndeianɨ ŋgafanɨ sesɨ ndahünɨnɨmboyei. ");
INSERT INTO agg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ranamboasɨ, ŋga se sesesɨ-ndafühɨ ra napo-koate-yeimbɨ, fi moaruwaiyeimbɨ, tɨŋarɨ moaruwaiyeimbɨ asu hɨmboatɨharɨyeimbɨ aheimbo anɨmbo mborai mbɨsafɨ. ");
INSERT INTO agg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Rananɨmbo God ai sɨhambo aboedɨ-aboedɨndea-nɨnɨmbui, nɨmboe sapo aiana napo-koate-wambo asu ŋgɨrɨ sɨmborɨ nɨnɨ ndehindɨ. Ŋga aboedɨ nindou ai yɨfɨhündɨ botɨyahindɨ sɨmboanɨ God ai takɨnɨ daganɨnɨmbui.” ");
INSERT INTO agg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mamɨ sɨmboanɨ nindou mamɨ sesɨ fondɨwamɨ Sisas-dɨbo nɨmarümbo God ŋgɨnɨndɨ hɨfandarandɨ ranambe nɨmareimbo seses-ayei hoafɨ ra hɨmborɨyu haya hoafɨyundühɨ yahuya, “Nindou ranai hɨhɨfɨ-hɨhɨfɨmbeyei-amboane,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sisas ai hoafɨyundowohü yahuya, “Nindou mamɨ ai afɨndɨ sesesɨmbo hohoanɨmoyu haya nindou afɨndɨmboya ‘Mborai’ mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mamɨ muŋguambo sesɨ sɨndɨ nafɨramɨndoanɨ ahandɨ ratüpurɨyu randeimbɨmbo hoafɨyundowohü yahuya, ‘Nindou ro hoafɨmehapurɨ ranahamumbo sowana hafɨ hoafɨyafɨpurühɨ anɨmboya, ‘Mborai, muŋguambo sesɨ sɨndɨ nafɨramɨndɨmboane’ mbɨsafɨ. ");
INSERT INTO agg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ŋga asu muŋguambo nindou ranai moeimbo ŋgɨrɨ dɨdefɨ mehomo. Ŋga ŋgorü ai boatei hoafɨndühɨya, ‘Ro hɨfɨ pemɨya heheambo wamboanahɨ ŋga hoeindɨhea samboanahɨ asu ro ŋgɨrɨ dɨdɨhɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ranɨkɨmɨ ŋgorü ai hoafɨnduhüya, ‘Roana burmakau 10 ratüpurɨmbohünda pemɨya heheambo wamboanahɨ ŋga randɨhe hoeindɨhea samboanahɨ, ŋga asu ro ŋgɨrɨ dɨdɨhɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Asu bɨdɨfɨranambo nindou-mayu ranai hoafɨyuhɨ yahuya, ‘Ro ana hapondanɨ yaŋgɨrɨ nɨmorehühɨ-yahe heheambo wambo ŋgɨrɨ dɨdɨhɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ranɨyo asu ahandɨ ratüpurɨyu-randeimbɨ ai hɨhɨrɨfi hüfu ahandɨ bogorɨmbo nindou ai yɨboaruko-memo ranahambo hoafɨmayundo. Ranɨyu asu bogorɨ ai ŋgusüfoambe moaruwaiyuhü hoafɨyuhɨya, ‘Nɨmehünou asükai ŋgafɨ muŋguambo adükarɨ nafɨhü asu muŋguambo akɨdou nafɨhü, napo-koate-yeimbɨ, fi moaruwaiyeimbɨ, yitɨŋarɨ moaruwaiyeimbɨ asu hɨmboatɨharɨ ra fufondandɨfɨndürɨ dügüfɨ,’ mehu ");
INSERT INTO agg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Süŋgunambo ratüpurɨyu-randeimbɨ ai hoafɨyundowohü yahuya, ‘Bogorɨ, ro ramarɨheandɨ se hoafɨmayafɨ süŋgu, ŋga awi fondɨ anɨŋgo,’ mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ahandɨ bogorɨ ai hoafɨyundowohü yahuya, ‘Ŋgafɨ tükündafo hawa akɨdou nafɨ asu nɨmambe nafɨ ŋgafühɨ hoeindowandürühɨ ana hüti hoafɨndafanɨ mbüsühüsiamboane. Rananɨmbo wandɨ fondɨ ra sɨmoŋgorɨ-mbeyowamboane. ");
INSERT INTO agg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ro nindou weaŋgurühɨ hoafɨmehapurɨ ra ŋgɨrɨ dɨdai-amboanɨ wandɨ-mayo sesɨ ra apɨndeandɨ,’ mehu,” Sisas ramehu. ");
INSERT INTO agg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Nindou afɨndɨ ranai ahandɨ süŋgu tümareandamboyu asu aheimbo hɨhɨrɨfi hoafɨyundürühɨ yahuya, “Nindou düdi ai wambo süŋgureandɨrühɨ asu ahandɨ hondafɨndɨ, nɨmorehɨ, nɨmorɨ, akohoandɨ rehɨmamɨ aheimbo asu ahandɨhoarɨmbo amboa afɨndɨ hohoanɨmoyuhü wambo akɨdou-yaŋgɨrɨ hohoanɨmoayu ana, nindou ranai wandɨ süŋgureandeimbɨ-yupoanɨ. ");
INSERT INTO agg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nindou düdi ai wandɨ süŋgunambo ahambo tɨŋɨrɨfo afɨndɨ tükefeyo ranahambo moanane yahu ŋgɨnɨndɨ nɨŋgokoate-ayu ana, ai wandɨ süŋgureandeimbɨ-yupoanɨ. ");
INSERT INTO agg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Sapo se afɨndɨ hoandarɨ worɨmbombo hohoanɨmoayafɨ ra weaŋgurühɨ nɨmandɨfɨ hohoanɨmondafɨ nüŋgunümbɨ kakɨnambo worɨ nda moendɨmandɨhinɨ mbɨsafɨ hohoanɨmondafɨ hoeindowandühɨ anɨmbo randowandɨ. ");
INSERT INTO agg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Asu refekoate-ayafɨ ana, se kambohoanɨ yaŋgɨrɨ fondo hɨnɨŋgɨndo hawa asu moendɨfekoate-ndafanɨ bodɨmondɨ ai sɨhambo tɨrɨfoefe hoafɨ-ndahünɨnɨmboyei. ");
INSERT INTO agg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ai randɨhi hoafɨndeihɨya, ‘Nindou nda worɨmbo-marandɨyosɨ, ŋga moai moendɨreandɨ,’ mbɨseimboyei. ");
INSERT INTO agg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Adükarɨ bogorɨ nindou ŋgorü ai adükarɨ bogorɨ ŋgorü-dɨbo yifiarɨmbo hohoanɨmoayu ana, ai nɨmandü hohoanɨmondu hoeindeandühɨ anɨmbo rambüfiyuwamboane. Ai nɨmandü hohoanɨmondu hoeindeandühɨ anɨmbo 10,000 ami ra 20,000 ranahambo waŋgeimandɨyo. ");
INSERT INTO agg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Asu ŋgɨrɨnduhü ana, bogorɨ ŋgorü ai aŋgunɨyuambe anɨmbo nindou ŋgorü koandɨheiranɨ nɨmai hu hoafɨyuwanɨ asu aboedɨ-aboedɨ-mbeyafɨne-andamboane. ");
INSERT INTO agg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mamɨ rahuraiane se muŋguambo moatükunɨ ranahambo ambe yahokoate-ayafɨ ana, ŋgɨrɨ se wandɨ süŋgurowandɨrɨ-randeimbɨ tükündafoandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Namɨ ana aboed-ane, ŋga namɨ ra budesowanɨ aparɨkoate-ndoanɨ ŋgɨrɨ ahandɨ aparɨ ra koadürü koadüründɨfe hɨnɨŋgɨndɨfeyo, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Namɨ moaruwai yahurai ana ŋgɨrɨ nümbürambeahɨndɨ sesɨ ranahambo fandɨhendanɨ aboedɨ tükündɨfeyo. Asu ŋgɨrɨ hɨhamoe awai bɨtapɨndɨhu nümbürambe dɨgehundɨ, ŋga wanɨ. Ŋga nindou ai moanɨ pindɨhimboyei. Se dɨdɨyei hɨmboambeimbayei ana, ndondɨhi hɨmborɨndei. ");
INSERT INTO agg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takis kakɨ sowandümo-rundeimbɨ-yomo asu nindou ai ranahamumbo moaruwai-anemo asei ranɨyomo ai muŋguambo sɨnɨmo Sisasɨndɨ hoafɨ hɨmborɨ-memo. ");
INSERT INTO agg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ranɨyomo Farisi asu ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ ai momorɨ hoafɨyomondühɨ yahomoya, “Hoeiru, nindou ndanai moaruwai hohoanɨmoyomondeimbɨ sepurɨmündü hɨnɨŋgɨreapurɨ mbura asu nɨmarü aibabɨdɨ sesɨ sowasümo arundɨ,” mehomo ");
INSERT INTO agg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Ranɨyu Sisas ai ranɨ kafoefe hoafɨ ra hoafɨyupurühɨ yahuya, “Nindou mamɨ ai ahandɨ 100 sipsip moaŋgui fandandeimbɨ-hündɨ asu mamɨ ai afarɨhoayo ra nüŋgumandüfia? Ai amurɨ 99 ranaheimbo rande hɨnɨŋgɨndeiranɨ wafuwamɨ wohɨ dagüdi wakɨndɨhindanɨ anɨmbo asu ŋgorü mafarɨhoayo ranahambo kokonda wakɨndeambui. ");
INSERT INTO agg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Nindou ranai sipsip mafarɨhoayo-mayo ra kokora hoeiareandɨ ana nindou ranai ahandɨ sipsip ranahambo afɨndɨ hamɨndɨ hɨhɨfɨ hɨhɨfɨndühɨ warambuhɨwamɨ nande ndemündü haya ŋgoafɨna ŋgumbui. Rananɨmbo ahandɨ ŋgunindɨ asu worɨyimbu-rɨneandeimbɨ ranaheimbo hoafɨyuhɨya, ‘Se robabɨdɨ hɨhɨfɨ-hɨhɨfɨndei, ŋga ro wandɨ sipsip mafarɨhoayo ra asükai hoeirɨheamboanahɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ro hoafehandürɨ, mare yahurai-anɨmbo nindou düdi ai moaruwai hohoanɨmo hɨnɨŋgɨre haya aboedɨ hohoanɨmoayu ana, sünambe afɨndɨ hamɨndɨ hɨhɨfɨ-hɨhɨfɨ anɨmbo tükündɨfemboe. Ŋga asu nindou 99 aboedɨ hohoanɨmoyeimbɨ aheimbo ana ŋgɨrɨ yahurai hamɨndɨ hɨhɨfɨ-hɨhɨfɨ tükündɨfeyo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Nɨmorehɨ mamɨ ai 10 kakɨ ambeimbɨ sepurɨmɨndoane asu mamɨ pɨmayu. Rananɨmbo asu ram yimunde mbunda yɨhoarɨndo wakɨndeandühɨ kokonda hoeindeamboe. ");
INSERT INTO agg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ai kokora hoeireandühɨ ahandɨ ŋgunindɨ asu worɨyimbu-rɨneandeimbɨ ranaheimbo hoafɨyowohü yahoya, ‘Se robabɨdɨ hɨhɨfɨ-hɨhɨfɨndei, ŋga ro wandɨ kakɨ mafarɨhoayo ra hoeirɨheamboanahɨ,’ meho. ");
INSERT INTO agg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mare yahurai anɨmbo, nindou moaruwai hohoanɨmoyumbü ai moaruwai hohoanɨmo hɨnɨŋgɨre haya aboedɨ hohoanɨmoayu ana, Godɨndɨ sünambeahɨndɨ nendɨ ai hɨhɨfɨ-hɨhɨfɨ-ndɨmboemo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ranɨyu Sisas ai hoafɨyuhɨya, “Nindou mamɨ ai nindowenihɨ nɨmorɨ yimbumarapɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Asu akɨdɨ nɨmorɨ ai afɨndambo hoafɨyuhɨya, ‘Napo sapo wambombuimbɨ-mayo ra ndawandɨrɨ,’ mehu. Ranɨyo asu afɨndɨ ai napo ra nɨmorɨ yimbumbo yɨbobomareapɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ranɨyu asu moai amɨtata akɨdɨ ai ahandɨ napo ra sagadürɨ mbura ranɨfihɨndɨ kakɨ ra semündü mbura aŋgunɨ ŋgorü hɨfɨna mahu. Ranühɨ ahandɨ muŋguambo kakɨ mamɨkare mbirɨmafoareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ahandɨ muŋguambo kakɨ ra mbirɨfoare hayamboyuane asu ranɨ hɨfɨhü sesɨ wanɨyowohü asu nɨmorɨ ranai worambe nɨnɨ kɨkefoefekoate-yuhü wembombomayu. ");
INSERT INTO agg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ranɨyu ai hu nindou mamɨ ŋgoafɨ aharɨhündɨ ahandɨ ratüpurɨyu randeimbɨmbo-mefiyuwa asu nümbürɨna koamarɨheira moatei ginɨrɨnambo moaŋguimbo mahu. ");
INSERT INTO agg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Asu nɨmorɨ ranahambo nindou ŋgorü ai-amboanɨ moai sesɨ sagado ranɨyo wembomboyuhü nɨmɨ hɨsɨ hɨpɨrɨ moatei masahüsi ra sesɨmbo hohoanɨmomayu. ");
INSERT INTO agg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Asu süŋgunambo ndore hohoanɨmoyuwa mayowamboyu, ‘Wandɨ apendɨ ratüpurɨyomo-rundeimbɨ aiana sesɨ afɨndɨ mbasɨhoemo. Ŋga ndanɨhü anɨmboahɨ nda ro wembombo yɨfɨmbo yaŋgɨr-ayahɨ. ");
INSERT INTO agg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ambe-hoaŋgo, ŋga ndühɨ hɨnɨŋgɨndɨhe hehea ŋga apembo hoafɨndahandowohü anɨmboya, “Ape, ro sɨhambo asu Godɨmbo moaruwai hohoanɨmo-yahapɨrɨmboanahɨ. ");
INSERT INTO agg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Hapondanɨ ana ro nindou aboedɨyahɨpoanɨ, ŋga ŋgɨrɨ se wambo wandɨ nɨmorɨ mbɨsafɨndɨrɨ. Ŋga moanɨ se rando hɨnɨŋgɨndowandɨra sɨhafɨ ratüpurɨya rɨhandeimbɨ nahurai tükündaheamboane,” mbɨsamboyahɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ranɨyu asu nɨmorɨ ranai ranɨhü hɨnɨŋgɨre haya ahandɨ afɨndɨ sowana ndamefiyu. Ai aŋgunɨ ŋgahɨ sünuambe afɨndɨ ai hoeirirühɨ ahandɨ nɨmorɨ ranahambo hɨpoambomarirɨ. Ranɨyu asu afɨndɨ ai pɨpɨyu hüfu warɨ kafoarirɨ haya wakɨkɨhɨ-marürɨ. ");
INSERT INTO agg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nɨmorɨ ai hoafɨyuhɨya, ‘Ape, ro moaruwai hohoanɨmo-yamboanahɨ sɨhambo asu Godɨmbo amboanɨ. Ŋga hapondanɨ ana ro nindou aboedɨyahɨpoanɨ, ŋga ŋgɨrɨ se wambo wandɨ nɨmorɨ mbɨsafɨndɨrɨ,’ mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Asu afɨndɨ ai ahandɨ ratüpurɨyomo-rundeimbɨmbo hoafɨyuhɨ yahuya, ‘Nɨmehünou hoearɨ aboedɨ sowandümo sɨfomo yihuruwurɨ. Asu warambeahɨndɨ moatükunɨ kɨkɨfoarüwurɨ, yirɨ hoearɨ güdündo. ");
INSERT INTO agg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Asu burmakau nɨmorɨ safeimbɨ manɨŋgo ra hɨfokoandu mandu houmbo anɨmbo dagudifɨhümbo hɨhɨfɨ-hɨhɨfɨ-ndefomboane. ");
INSERT INTO agg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wandɨ nɨmorɨ nda yɨfɨmbomayuyosɨ, ŋga asu yaŋgɨrɨ haponda anüŋgu! Ai mafarɨhoayuyosɨ, ŋga haponda hoeiarɨhurɨ,’ mehu. Ranɨyo ai sesesɨ-yomondühɨ hɨhɨfɨ-hɨhɨfɨmemo. ");
INSERT INTO agg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Asu amoŋgo nɨmorɨ ai nümbürambe nüŋgu mbura worɨkɨmɨ huane gita hoafɨyowohü heirümemo ra hɨmborɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ranɨyo asu ratüpurɨyu-randeimbɨ mamɨmbo düdurirühɨ yahuya, ‘Nɨnɨmboe ndana?’ mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Asu ratüpurɨyu-randeimbɨ ai hoafɨyundowohüya, ‘Sɨhafɨ amond-ai aboedɨ tükümefiyu, ŋga ranɨmboyo ape ai burmakau nɨmorɨ mamɨ safeimbɨ hɨfokoare mande hayambo sahusifühɨ hɨhɨfɨ-hɨhɨfayefɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ranɨyo asu amoŋgo ai ŋgɨnɨndɨrürühɨ moai sesesɨ-mayei ranambo hu, ŋga wanɨ. Ranɨyo afɨndɨ ai hu sesesɨ ranambe hombo hütihüti-marürɨ. ");
INSERT INTO agg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Asu amoŋgo nɨmorɨ ai afɨndambo yare hoafɨyundowohüya, ‘Ro sɨhambo afɨndɨ hɨmbanɨ moanɨ ratüpurɨya rɨhandeimbɨ nahurai hoafɨ hɨmborɨyahühɨ farɨheheanɨnɨ marɨhandɨ. Ŋga se moai wambo wandɨ wandafɨ babɨdɨmbo hɨhɨfɨ-hɨhɨfɨyohü sesesɨmbohünda meme nɨmorɨ amboanɨ sawandɨ. ");
INSERT INTO agg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ŋga sɨhafɨ nɨmorɨ ranana, sɨhafɨ-mayo kakɨ ra nɨmorehɨ wosɨhoaforɨ hohoanɨmoyei rɨhündeimbɨyei-fihɨ moendɨre haya tükümefiyu-ane asu ahambo burmakau nɨmorɨ safeimbɨ ra hɨfokoaro mamandowando,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Asu afɨndɨ ai hoafɨyundowohü yahuya, ‘Nɨmoakɨdou, se ro-dɨbo manɨmbafanesɨ, ŋga muŋguambo moatükunɨ wandɨ-mayo ra sɨhafane. ");
INSERT INTO agg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sɨhɨrɨ hɨhɨfɨ-hɨhɨfɨ-ndefomboane nɨmboe sapo sɨhafɨ amond-ai yɨfɨmbo-mbuimbɨyusɨ, ŋga asu haponda yaŋgɨrɨ tüküfi anüŋgu. Asu ai mafarɨhoayuyosɨ, ŋga haponda hoeiarɨhurɨ,’ mehu,” Sisas mehu. ");
INSERT INTO agg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Sisas amboanɨ ahambo süŋgrurü-rundeimbɨmbo hoafɨyupurühɨ yahuya, “Nindou mamɨ ai napo afɨndeimbɨyu hayamboyu asu ahandɨ napo ra hɨfandɨmbo nindou ŋgorü serümündü hɨnɨŋgɨmarirɨ. Ranɨyomo asu nindou bɨdɨfɨrɨ ai nindou ranahambo papɨ-hoafɨrürühɨ yahomoya, ‘Bogorɨ, sɨhafɨ napo ra mbirɨmafoareandɨ,’ mehomondo. ");
INSERT INTO agg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ranɨyu asu napo afɨndeimbɨ-mayu ranai ahandɨ napo hɨfandandeimbɨ bogorɨ-mayu ranahambo mborai yahundo hürüheirü mbura düdurirühɨ yahuya, ‘Hoafɨ ra nüŋgurɨyo ro sɨhafɨ ratüpurɨ ranahambo hɨmborɨmayahɨ? Ŋga se ŋgafɨ wandɨ kakɨ ranɨnambo nɨnɨ ratüpurɨyo ramarowandɨ ra sürü papɨnda ndawandɨ, ŋga ŋgɨrɨ se wandɨ napo hɨfanda-randeimbɨndafɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ranɨyu asu ratüpurɨ hɨfanda-randeimbɨ-mayu ranai aimbo hoafɨyuhɨya, ‘Ro nüŋgumandahe wandɨ bogorɨ ai ratüpurɨ ranambeahɨndɨ raguanambo-areandɨrɨ ra? Roana hɨfɨ hɨrɨmbo ŋgɨnɨndɨyahɨpoanɨ asu aheimbo moako-moakombo amoanɨŋgɨmboanahɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ro fɨfɨrɨheamboanahɨ nɨne-moatükunɨ süŋgufeyowanɨ nindou ai wambo semɨndɨndɨrɨ worɨnɨfendɨrɨmbo ra,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ranɨyo napo hɨfandandeimbɨ-mayu ranai ahandɨ bogorɨndɨ kakɨ masowandümo ranahamumbo mborai yahupurɨ hümarɨhepurɨ. Asu weaŋgurühɨndɨdɨdɨ-mayu ranahambo düdurirühɨ yahuya, ‘Se nüŋgunümbɨyo wandɨ bogorɨndɨ-mayo kakɨ masowandɨfɨ?’ mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Asu ai sɨmborɨ hoafɨyundowohü yahuya, ‘100 adükarɨ hɨpɨrɨ werɨyo,’ mehuamboyo. Asu napo hɨfandandeimbɨ ai hoafɨyuhɨ yahuya, ‘Nɨmehünou sɨhafɨ ndürɨ paiaroweimbɨ pepa ra ndowandɨfɨ hawa 50 adükarɨ hɨpɨrɨ pandowandɨ.’ ");
INSERT INTO agg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Asükai ŋgorümbo düdurirühɨya, ‘Se ra nüŋgunümbɨyo masowandɨfɨ?’ mehundowamboyu. Asu ai sɨmborɨ hoafɨyundowohü yahuya, ‘100 bek witɨyo,’ mehuamboyo, asu hɨfandɨrandeimbɨ ai hoafɨyundowohüya, ‘Sɨhafɨ ndürɨ parundeimbɨ pepa ra sowandɨfɨ hawa 80 bek pandowandɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ranɨyo asu napo afɨndeimbɨ-mayu ranai anɨhondümbo hoafɨkoate hɨfandɨrandeimbɨ-mayu ranahambo hoafɨyuhɨ yahuya, ‘Se nɨnɨ-moatükunɨyo sɨhambo süŋgunambo tüküfemboayo ranahambo wudɨpoaporo hohoanɨmoayafɨ ra aboed-ane,’ mehu. Ŋga ro hoafehapurɨ, nindou ai hɨfɨnɨndɨ moatükunɨmbo hohoanɨmoyei arɨhündɨ ranai dɨboadorɨhoeimbɨ nahurai-anei, ŋga rananei asu nindou sürühehindeimbɨ ranaheimbo süŋgunambo nɨnɨ-moatükunɨyo tüküfemboayo hohoanɨmo ra ŋgasündarɨhindürɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ro sɨheimbo hoafehandürɨ hɨfɨ ndanɨhündambo kakɨ napo ranɨ süŋgumbo se nɨmorehɨ nindowenihɨ babɨdɨ ŋgunindɨmboehindɨ, ŋga süŋgunambo kakɨ semɨndɨmbo ra muŋguyoambe sɨheimbo ndemündündürɨ worɨnɨndeiranɨ asu se koadürümbo koadürümbo nɨmandeimboyei. ");
INSERT INTO agg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nindou düdi ai akɨdou moatükunɨ ndore hɨfandarandɨ ana, asu adükarɨ moatükunɨ amboanɨ ndonde hɨbandambui. Ŋga asu ai akɨdou moatükunɨ ndofe hɨfandɨkoate-ayu ana, asu ŋgɨrɨ adükarɨ moatükunɨ amboanɨ ndonde hɨbandandɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Asu se kakɨ napo hɨfɨ ndanɨhündambo moaruwai ra ndofe hɨfandɨkoate-ayei ana, asu se ŋgɨrɨ napo hondü ra hɨbadɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Se nindou ŋgoründɨ napo ndofe hɨfandɨkoate-ayafɨ ana, asu se ŋgɨrɨ napo sɨhei hondü ra ndondɨhi hɨbadɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nindou ŋgorü ai ŋgɨrɨ yimbu bogorɨ nindouyafandɨ ratüpurümbɨ nüŋgu. Ŋga nindou ranai ana bogorɨ ŋgorü ranahambo moaruwaimbo-ndirühɨ asu ŋgorü bogorɨ ranahambo ŋgusüfo pandirümbui. Se ŋgɨrɨ kakɨmbo ratüpurɨ asu Godɨndɨ ratüpurɨ yɨboboambo ŋgusüfo pandowapɨrɨ.” ");
INSERT INTO agg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi nindou, kakɨmbo yaŋgɨrɨ ŋgusüfo parundeimbɨ-memo, ranai ranɨ hoafɨ hɨhɨmborɨyomo houmbo asu Sisasɨmbo tɨkɨfɨnambo-marurɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ai sɨmborɨ hoafɨyupurühɨ yahuya, “Seana nindouyei hɨmboahü aboedɨ hɨmboyomondühanemo, ŋga God ana sɨhamundɨ hohoanɨmo ra fɨfɨreapurɨmbo-ani. Nɨne nindouyei hɨmboahü aboedɨ hamɨndayo ra Godɨndɨ hɨmboahü ana moaruwai hamɨndane. ");
INSERT INTO agg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mosesɨndɨ ahɨnümbɨ hohoanɨmoyo asu Godɨndɨ hoafɨ hoafɨyomo rundeimbɨ-yomondɨ hoafɨ ra wataporɨmboru sɨnɨmombo asu Son ai tüküfi nüŋguambe kaimayo. Ŋga Son nüŋguambe peyo haya asɨno ndanana God ŋgɨnɨndɨ hɨfandarandɨ aboedɨ hoafɨ ra muŋguambo ŋgoafɨ tükefeyo. Ranane asu God hɨfandarandɨ ranambe kefoefembo muŋguambo nindou ai hamɨndɨ tütüŋgarɨhehindɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Hɨfɨ sünü ranai muŋgundɨmboe, ŋga Godɨndɨ-mayo ahɨnümbɨ hohoanɨmo ranana ŋgɨrɨ akɨdou-amboanɨ awarɨndɨhoeyo.” ");
INSERT INTO agg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Nindou düdi ai ahandɨ nɨmorehɨ hɨnɨŋgɨre haya asu ŋgorü asemündu ana, ai moaruwai wosɨhoaforɨ hohoanɨmoyumbo-ani. Asu nindou düdi ai nɨmorehɨ horombo ahandɨ nindowenihɨ ai moei yahumbü asemündu ana ai-amboanɨ moaruwai wosɨhoaforɨ hohoanɨmoyumbo-ani.” ");
INSERT INTO agg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sisas ai hoafɨyuhɨ yahuya, “Nindou mamɨ ai kakɨ napo afɨndeimbɨyu haya asu ai hoearɨ aboedɨ-aboedɨ yihuruyu haya muŋguambo si sesɨ aboedɨ sesühɨ nɨmarü marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nindou mamɨ napo-koate ahandɨ ndürɨ Rasarus ai ahandɨ fi masɨmei yaŋgɨrɨyu haya napo afɨndeimbɨndɨ yipurɨ nafɨtambeihü nɨmarü marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ai napo afɨndeimbɨndɨ-mayo sesɨ fu fondɨwamɨnɨndɨ pɨndoanɨ dagadɨ yahuayamboyu ramefiyu. Ranɨyo asu yaforɨ ai hei ahandɨ masɨmei ra moŋgoarühɨ marɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Süŋgunambo Rasarus ai yɨfɨmayuamboyo asu sünambeahɨndɨ nendɨ ai sowaründümo hafomo Abrahamɨ-dɨbo hɨnɨŋgɨmarüwurɨ. Asu napo afɨndeimbɨ-amboanɨ yɨfɨmayuwa hɨfɨ kamarɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Asu yifiafɨ ŋgoafɨhü napo afɨndeimbɨ-mayu ranai asübusɨ afɨndɨ masemündu. Asu ai hɨmboyuane aŋgunɨ goagu Abraham ai Rasarus parümündü haya manɨmbafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ai hoafɨyuhɨya, ‘Abraham, wambo hɨpoambo-rowandɨrɨ! Se Rasarus koarɨhaworanɨ hoe warɨ foare hüramündɨ süfo wandɨ amɨndasümo kusɨmbɨreandɨrɨ, ŋga wambo hai hüfɨnambo muŋgunambo-arandɨrɨ,’ mehu ");
INSERT INTO agg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham ai hoafɨyuhɨ yahuya, ‘Wandɨ nɨmorɨ, se yaŋgɨrɨ nɨmbafambe aboedɨ moatükuneimbɨ-mayafɨ, ŋga asu Rasarus ai moaruwai mamaru. Ŋga asu ai haponda ndanɨhü aboedɨ mamaruwa asu se asübusɨ asowandɨfɨ. ");
INSERT INTO agg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ŋgorü-moatükunɨ ra ai hoe apoarɨ afɨndɨ mbusümondühɨ kɨkɨreamunɨmboane, ŋga ŋgɨrɨ dɨdai badɨhoei ndühɨ düfu asu ŋgɨrɨ dɨdai badɨhoei rühɨ düfu,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Asu napo afɨndeimbɨ ai hoafɨyuhɨ yahuya, ‘Ape, refe ana Rasarus koandɨhaworanɨ apendɨ worɨna mbɨhuwamboane. ");
INSERT INTO agg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ro hondahüfeimbɨ akohoandeimb-anahɨ rananɨmbo Rasarus ai hoafɨnduanɨ asübusɨ afɨndɨ semɨndɨ nafɨ kosɨkoate-mbeyomo-ndamboane,’ yahuhaya hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham ai hoafɨyuhɨya, ‘Ai ana Mosesɨndɨ-mayo ahɨnümbɨ hohoanɨmo asu Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ sürü papɨmarundɨ ra hoeindundühɨ fɨfɨrɨndumboemo.’ ");
INSERT INTO agg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Napo afɨndeimbɨ ai hoafɨyuhɨ yahuya, ‘Wanɨ, Ape Abraham! Nindou düdi yɨfɨhündɨ ahamumbo sowana ahu ana, ai ahamundɨ moaruwai hohoanɨmo ŋgorü süŋgundundühɨ asu anɨhondümbo-ndumboemo.’ ");
INSERT INTO agg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham ai hoafɨyundowohü yahuya, ‘Asu ai Mosesɨndɨ hoafɨ hɨmborɨkoate-yomo, Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ-yomondɨ hoafɨ hɨmborɨkoate-ayomo ana, asu ŋgɨrɨ nindou yɨfyeimbɨ-yei hoafɨ amboanɨ hɨmborɨndomo,’” mehu. ");
INSERT INTO agg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sisas ai ahambo süŋgrurü-rundeimbɨmbo hoafɨyupurühɨ yahuya, “Awi süŋgunambo mamɨkarambo moatükunɨ moaruwai tükündɨfemboe asu ranɨ süŋgumbo wambo nɨmorehɨ nindowenihɨ ai moaruwai hohoanɨmondeimboyei. Hɨpoanɨmboe-mbouanei nindou düdi nɨmorehɨ nindowenihɨ ranaheimbo rareandanɨ moaruwai hohoanɨmoayei. Nindou ranahambo ana moaruwai hamɨndɨ anɨmbo tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Asu ai rareandanɨ nɨmorɨ akɨdɨbou ndanai moaruwai hohoanɨmoayei ana nindou ranahambo amɨndasümoambe nɨmoei hondɨ wofɨfihɨ kife mburɨmbo hoe hohoeambeahɨ pifiyuwanɨ hanü yɨfɨmbo ra aboed-ane. ");
INSERT INTO agg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ranɨmbo-hündambo anɨmbo se hɨbadɨhümbo. “Asu sɨhafɨ wandafɨ ranai moaruwai hohoanɨmonduanɨ se ahambo hoafɨndafühɨ, sɨhafɨ moaruwai hohoanɨmo ra hɨnɨŋgɨndowandɨ mbɨsafɨndo. Asu ai ahandɨ moaruwai hohoanɨmo ra hɨnɨŋgɨndeandanɨ ana, se ahambo amboawi mbɨsafɨ. ");
INSERT INTO agg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Asu nindou ranai sɨhambo mamɨ sihɨ 7-mbo moaruwai hohoanɨmoyu mbura asükai 7-mbo hu sɨhamboya, ‘Karɨhasɨ, ro sɨhambo moaruwai hohoanɨmo-mayahanɨnɨ,’ ehu ana, ahandɨ moaruwai hohoanɨmo ra amboawi mbɨsafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ahandɨ hoafɨ sowandümo homorundeimbɨ ranai Adükarɨmbo hoafɨyomondühɨ yahomoya, “Se rarowandanɨ yɨhoefɨ anɨhondümbofe ra afɨndɨmbeyo.” ");
INSERT INTO agg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mehomondamboyu asu Adükarɨ ai sɨmborɨ hoafɨyupurühɨ yahuya, “Asu sɨhamundɨ anɨhondümbofe ranai mastet hoarɨ nahurai akɨdouayo-amboanɨ se nɨmɨ ndanahambo hoafɨndɨmondühɨ anɨmboya ‘Fɨrɨhoefɨ hawa ahasɨharɨ kameihɨ hafɨmbo hoe hohoeambe nɨmbafɨ,’ mbɨsɨmondanɨ asu nɨmɨ ranai se hoafɨmemo süŋgu randɨfemboe,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Sisas ai hoafɨyuhɨ yahuya, “Nindou mamɨ seambeahɨndɨ ai ahandɨ ratüpurɨyu-randeimbɨ ranai ŋgu nümbürambe hɨfɨ hɨrɨndu asu sipsip hɨfandɨnda mbundambo asükai worɨnambo düduwanɨ, ai hoafɨndu-ndowohüya, ‘Nɨmehɨnou sɨnɨfɨ nɨmarɨfɨmbo sesɨ sowasɨfɨ,’ mambüsɨndoyo? ");
INSERT INTO agg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wanɨ, ŋga ahambo anɨmboya, ‘Wandɨ boatei sesɨ ra dɨdɨboadondo ndao hawambo anɨmbo asu se hoearɨ güdo mbunda nɨmandɨfɨ hɨbadandɨranɨ ro boatei sesɨ dagadɨ hoe ndɨmɨndahaimbo nɨmandɨhanɨ anɨmbo asu se sɨhafɨ sesɨ ra süŋgu dowadɨfɨ,’ mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Asu bogorɨ nindou ranai ahandɨ ratüpurɨyu-randeimbɨ nindou ranahambo hɨhɨfɨmandürɨyo ahandɨ hoafɨ hɨmborɨyuhü süŋgumareandɨ ranɨmbo-hünda? Wanɨ. ");
INSERT INTO agg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ranɨmbo-hündamboane se-amboanɨ God ai hoafɨmayu ra muŋgu ratüpurayomo ana se randu hoafɨndɨmondühɨya, ‘Roana aboedɨ ratüpurɨyefɨ rɨhundeimbɨyefɨpoanɨ, ŋga ranɨ ratüpurɨ ranana yɨhoefɨmbo ratüpurɨndɨmo yahu hoafɨmayu ranɨyo ratüpurɨmayefɨ,’ mbɨsɨmo.” ");
INSERT INTO agg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sisas ai Serusarem ŋgoafɨna yare huhɨyu Sameria asu Gariri-yafe hɨfɨ yipupuiambe nafɨ mahu. ");
INSERT INTO agg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Ai hu ŋgoafɨ mamɨ ranɨhü tüküfiyuwane, nindou 10 mɨmanɨho masɨmeimbɨ ranai homo ahambo nafɨnɨ hoeimarüwurɨ. Ai aŋgunɨ nɨŋgomombo raru mɨŋgɨyomo hoafɨyomondühɨ yahomoya, “Sisas! Nindou Adükarɨ! Se yɨhoefɨmbo hɨpoambo-rowamunɨ,” mehomondo. ");
INSERT INTO agg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Asu Sisas ai ahamumbo hoeireapurühɨ hoafɨyupurühɨ yahuya, “Se ŋgomo Godɨmbo sesɨ sɨhou-rundeimbɨ ahamumbo anɨmbo sɨhamundɨ fi ra nafuindɨmondanɨ anɨmbo asu ai tümbürüpuramboane,” mehu. Ai nafɨ homondane ahamundɨ fi ranai asükai aboedɨ tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Asu nindou mamɨ ahamundɨ mbusümo ranai hoeireandanɨ ahandɨ fi ranai asükai aboedɨ-mayowamboyo, ŋgoafɨnambo hɨhɨrɨfi huhü puküna hoafɨyuhɨ Godɨmbo aboed-ani mehu. ");
INSERT INTO agg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nindou ranai hu Sisasɨndɨ yirɨkɨmɨ piyu yaŋgurümbo hɨhɨfɨmarürɨ. Nindou ranai ana Samariahündɨyu. ");
INSERT INTO agg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sisas ai nindou ranahambo hoeirirɨ haya hoafɨyuhɨ yahuya, “10 aboedɨmayafundɨ. Ŋga asu ŋgorü 9 ra nüŋguyafunda? ");
INSERT INTO agg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Asu nɨmboe nindou ŋgorü sɨrambeahɨndɨ mamɨ ndanai yaŋgɨrɨ sünɨ Godɨmbo hɨhɨfarüra?” ");
INSERT INTO agg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Asu Sisas ai nindou ranahambo hoafɨyundowohü yahuya, “Botɨyafo hawa hafɨ, ŋga sɨhafɨ anɨhondümbofe ranaiyo aboedambo-mareanɨnɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisi nindou ranai Sisasɨmbo düduyafundühɨ yahomoya, “Nüŋgusümboanɨ God ŋgɨnɨndɨ hɨfandarandɨ ra tükümandɨfea?” mehomondamboyu. Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “God ŋgɨnɨndɨ hɨfandarandɨ ranai tüküfemboayo ranɨ-moatükunɨ nafuimbohünda ŋgɨrɨ nɨnɨ-moatükunɨ tükündɨfeyoanɨ nindou ai ahei hɨmboarɨnambo hoeindɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ai ŋgɨrɨ randɨhi hoafɨndeihɨya, ‘Hoeirɨhi aiana ndanɨ,’ mbɨsei asu ‘Goagu ra’ mbɨsei. Nɨmboe, sapo Godɨndɨ ŋgɨnɨndɨ ranana sɨhei mbusümo-ane eŋgoro.” ");
INSERT INTO agg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ranɨyo asu ahambo süŋgrurü-rundeimbɨmbo hoafɨyupurühɨ yahuya, “Süŋgunambo ranɨ-moatükunɨ ranai tükündɨfemboe, rananɨmbo se Nindou Hondündɨ si ra hoeifembo afɨndɨ hohoanɨmo-ndɨmboemosɨ, ŋga se ŋgɨrɨ hoeindundɨ. ");
INSERT INTO agg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Rananɨmbo sɨhamumbo hoafɨndeihɨya, ‘Hoeiru, aiana goagu anüŋgu ra’ mbɨsei asu ‘Hoeiru, aiana ndanüŋgu,’ mbɨseimboyei, ŋga se yowanɨ anɨhondümbofeihü ho kokopoanɨ. ");
INSERT INTO agg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sapo wabürüsɨ ranai sünü ŋgorü hɨmboranɨ tüküfe haya ho ŋgorü hɨmboranɨ kararamɨndo, yahurai anɨmbo ndɨmboe Nindou Hondü ai ahandɨ tüküfembo sihɨ ra. ");
INSERT INTO agg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ŋga asübusɨ afɨndɨ boatei ndemündɨ mbundambo asu nindou ndanɨ sɨmboanɨ anɨmboei ranai ahambo daboadɨ hɨhɨrɨndɨhorɨ mbundühümbo-ndeianɨ anɨmbo ndɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Horombo Noa nüŋguambe ramefeyo yahurai anɨmbo Nindou Hondü ranai tüküfemboyuambe-amboanɨ randɨfemboe. ");
INSERT INTO agg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sapo Noa nüŋguambe nindou afɨndɨ ranai sesɨ sahüsi, hoe sɨmɨndei, nɨmorehühɨyafu, anamɨndühɨyahi raraorühɨ heimbo mamɨ bɨdɨfɨranambo sihɨ Noa ai botambe mafarɨfiyu-wamboyo hohoambu afɨndɨ ranai kosowohü nindou ra hɨfokoako-mafoareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Horombo Rot nüŋguambe ramefeyo yahurai anɨmbo ndɨmboe. Muŋguambo nindou ranai sesɨ sahüsi hoe sɨmɨndei, napo pemɨyei, kakɨ semɨndɨmbo koarɨhehi, nümbürɨ hɨfɨrɨhi, worɨmborühɨ raraomarɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ŋga Rot ai Sodom ŋgoafɨ ra hɨnɨŋgɨre haya hu sɨmboanɨ hai asu sarfa nɨmoei ranai hoe nahurai sünambeahɨndɨ pütapɨyowohü muŋguambo nɨmorehɨ nindowenihɨ hɨfokoako-mafoareandürɨ. ");
INSERT INTO agg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mamɨ yahurai anɨmbo Nindou Hondü ranai weindahɨ tüküfi sɨmboanɨ amboanɨ randɨfemboe. ");
INSERT INTO agg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ranɨ-sɨmboanɨ nindou ŋgoafɨhü amaru ranai ŋgɨrɨ kebuai ahandɨ napo worambe eŋgoro ra ndemündu. Asu mamɨ yahuraiane nindou nümbürambe anüŋgu ranai ŋgɨrɨ ahandɨ worɨnambo hɨhɨrɨndüfi ŋgu. ");
INSERT INTO agg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sapo Rotɨndɨ nɨmorehɨmbo tükümefeyo ra se hohoanɨmondɨmo. Ai hɨhɨrɨfe ŋgoafɨ hoeimareanda yɨfɨmayo. ");
INSERT INTO agg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nindou dɨdɨyei ahei yaŋgɨrɨ nɨŋgo ranahambo afɨndɨ hohoanɨmoyeihɨ kɨkɨharɨhümündi ana, awarɨndɨhoemboe. Ŋga nindou dɨdɨyei ahei yaŋgɨrɨ nɨŋgo ranahambo afɨndɨ hohoanɨmokoate-ayei ana, aboedambo-ndɨfemboe. ");
INSERT INTO agg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ro sɨhamumbo hoafehapurɨ, nindou yimbu ranai mamɨ fondɨwamɨ guguiyafanɨ apafanɨ ra God ai ŋgorümbo nderümündühɨ ŋgorü rande apofondɨwamɨ dɨgeirümbui. ");
INSERT INTO agg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Nɨmorehɨ yimbu ranai mbanɨ hɨrayafe ra God ai ŋgorümbo ndemündühɨ ŋgorü rande hɨnŋgɨdeambui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sisasɨmbo süŋgrurü-rundeimbɨ ai düdurüwurühɨ yahomoya, “Ranɨ-moatükunɨ ra nahü tükümandɨfea?” Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Yɨfɨnɨmoko yaŋgorowohü ana, koaheimb-ane hei sahüsi arɨhündɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sisas ai ahambo süŋgrurü-rundeimbɨmbo dɨdɨbafɨferambo yiboaruko-ndɨmboemo yahu haya kafoefe hoafɨ mamɨ yamundɨfe-purɨmbohünda hoafɨmayupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Sisas ai yare hoafɨyuhɨ yahuya, “Mamɨ adükarɨ ŋgoafɨhü nindou yɨbobore-randeimbɨ mamɨ ai manüŋgu. Aiana moai Godɨmbo yɨhɨmboyu asu nindoumbo afɨndɨ hohoanɨmoyu randɨ. ");
INSERT INTO agg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ranɨyo adükarɨ ŋgoafɨ ranɨhü nɨmorehɨ kai nɨŋgo haya ho nindou yɨbobore-randeimbɨmbo hüti hoafɨyondo randühɨya, ‘Wandɨ hürütümbɨ ai wambo hürütarandɨrɨ, ŋga se wambo hoafɨ yɨbobofe ra farɨhawandɨrɨ,’ meho. ");
INSERT INTO agg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Gedühɨ safɨyu nindou yɨbobore-randeimbɨ ranai nɨmorehɨ ranahambo fehefembo moei mehu. Ŋga humbo süŋgunamboyu ai ahandɨ fimbo hoafɨyuhɨya, ‘Sapo ro moai Godɨmbo yɨhɨmboya asu nindoumbo hohoanɨmoya rɨhandɨ. ");
INSERT INTO agg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ŋga nɨmboe nɨmorehɨ kai ranai muŋguambo si wambo tɨŋɨrɨfo sai arandɨmbo anɨmbo ro ahambo fandɨhehe hehea ahandɨ papɨ-hoafɨ ra hɨmborɨnda. Asu ro refekoate-ayahɨ ana wambo sowana muŋguambo si dɨdɨ ndandanɨ wambo süŋgunambo garɨbɨndea-ndɨrɨmboe,’” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Asükaiyu Adükarɨ ai hoafɨyuhɨ yahuya, “Se nindou yɨbobore-randeimbɨ moaruwai ranahandɨ hoafɨ ra hɨmborɨyomo. ");
INSERT INTO agg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nimorehɨ nindowenihɨ God ai wandanei yahundüreimbɨ ranai nɨmbɨnɨmbɨ si muŋguambo Godɨmbo aranɨ aranayei ra aheimbo fehefendürɨ-koate-mandüyo? Asu awi fehefendürɨ-koate ahei hoafɨ ra hɨhɨmborɨpo-mandüyo? Wanɨ. ");
INSERT INTO agg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ŋga ro sɨhamumbo rarɨhe hoafehapurɨ, ai ahei papɨ-hoafɨ ra nɨmehünou hɨmborɨnduhü yɨbobondeambui. Ŋga Nindou Hondü ai kudümbo nɨmorehɨ nindowenihɨ hɨfɨ ndanɨhü anɨmboei ahei anɨhondümbofe ra hoeimandeyo?’” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nindou bɨdɨfɨrɨ ai ahamundɨ fimboya aiana mbumundɨ hamɨnd-anemo, ŋga ŋgorü nindou aiana mbumundɨ-yomopoanɨ ehomo ranahambo Sisas ai kafoefe hoafɨ hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Mamɨmbo nindou yimbu ranai dɨdɨbafɨfembohünda Godɨndɨ worɨna mahafanɨ. Mamɨ ai Farisihündɨyu asu ŋgorü ai takis kakɨ semündü-randeimbɨyu. ");
INSERT INTO agg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisihündɨ ranai ahandɨpoanɨmbo nüŋgumbo ŋgusüfoambe dɨdɨbafɨfihɨya, ‘God, ro sɨhambo hɨhɨfarɨhanɨnɨ, roana moai nindou bɨdɨfɨrɨ rarɨhi arɨhündɨ süŋgurɨhe hehea dɨbokorɨya, tɨkai hoafɨya asu nɨmorehɨ sɨsɨhɨmoya rɨhandɨ. Ŋga roana nindou takis kakɨ semündü-randeimbɨ gogu ranɨ nahurai-yahɨpoanɨ. ");
INSERT INTO agg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ro mamɨ wik ranambe yimbumbo sesɨ wehɨya asu muŋguambo moatükunɨ ro asahamɨndɨhɨ ra 10 yɨboborɨhe hehea sɨhambo mamɨ bɨdɨfɨrɨ sɨhehe arɨhandɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ŋga takis kakɨ semündü-randeimbɨ-mayu ranai ahandɨpoanɨmbo akɨdou aŋgunɨ safɨ manüŋgu. Ai sünambe hɨmbo-koate mbɨro türe nüŋgumbo ahandɨ ŋgusüpoahühɨ purükɨreandühɨ yahuya, ‘God, ro moaruwai hohoanɨmoya rɨhandeimb-anahɨ, ŋga se wambo hɨpoambo-rowandɨrɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ro sɨhamumbo hoafehapurɨ, takis kakɨ semündü-randeimbɨ-mayu ranai worɨnambo ŋguwanɨ ai anɨmbo Godɨndɨ hɨmboahü mbumundɨ nindou-ndümbui, ŋga Farisi nindou ana wanɨ. Sapo mamɨ yahuraiane nindou dɨdɨyei ahei fimbo hɨfɨnambo-arɨhindɨ aheimbo God ai botɨndearümbui. Ŋga asu nindou dɨdɨyei ahei fimbo botarɨhindɨ aheimbo God ai hɨfɨnambo-ndearümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ranɨyei nindou bɨdɨfɨrɨ ranai Sisasɨmboya ai warɨ nande haya dɨdɨbafɨ-mbɨfindüra sei hehi nɨmoakɨdɨbou fufurɨhümündindürɨ tükümehind. Ŋga asu ahambo süŋgrurü-rundeimbɨ-memo ranai nindou ranaheimbo ŋgɨnɨndɨ-marundürɨ. ");
INSERT INTO agg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ŋga asu Sisas ai hoafɨyuhɨ yahuya, “Nɨmoakɨdɨbou ra aheimbo hɨnɨŋgɨndɨhindüra ndühɨ wambo sowana mbüsühüsi, ŋga ŋgɨrɨ bobohɨndundüra. Sapo God ŋgɨnɨndɨ hɨfandarandɨ ra nɨmorɨ akɨdɨbou ndahurai aheiane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sisas yahuya, “Se nda fɨfɨrɨndundɨ, nindou dɨdɨyei God ŋgɨnɨndɨ hɨfandarandɨ ra nɨmoakɨdɨbou sahümündi arɨhündɨ nahurai semɨndɨkoate-ayei ana, ŋgɨrɨ keboehindɨ, ŋga wanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Suda-yafe bogorɨ nindou ranai Sisasɨmbo düdurirühɨya, “Nindou yamundo-randeimbɨ aboedɨ, ro yaŋgɨrɨ koadürü koadürümbo nɨŋgombo ra nɨnɨ-moatükunɨ nünuŋgondɨhendühɨ mandahamɨndɨha?” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Asu Sisas ai ahambo sɨmborɨ hoafɨyundowohü yahuya, “Nɨmboe se wambo aboedɨ asafa? Moai nindou dɨdɨ ai aboedɨyu, ŋga God yaŋgɨr-ani aboedayu. ");
INSERT INTO agg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Sapo se ahɨnümbɨ hohoanɨmo ra fɨfɨrowandɨ: Se yowanɨ nɨmorehɨ sɨsɨhɨmoyo asu anamɨndɨhoandɨ bɨrabɨrɨyopoanɨ, wosɨhoaforɨ hoafɨyopoanɨ, nindou hɨfokoefepoanɨ, hümbuhünɨyopoanɨ, se yowanɨ ŋgorümbo tɨkefe-hefe papɨ-hoafɨyopoanɨ, asu se sɨhafɨ me-apembo ahɨnɨndafühɨ ahafe hoafɨ hɨmborɨndafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nindou ranai sɨmborɨ hoafɨyundowohü yahuya, “Ro nɨmorɨ akɨdouyahambe peya hehea hambo hapondanɨ ro ranɨ ahɨnümbɨ ra süŋgurɨhe arɨhandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sisas ai ranɨ hoafɨ ra hɨmborɨyu haya, sɨmborɨ hoafɨyundowohü yahuya, “Awi mamɨ moatükunɨ se randowandɨ. Sɨhafɨmayo napo ra nindou ŋgorümbo dabadürühɨ ranɨfihɨndɨ kakɨ asowandɨfɨ ra napo-koate-yeimbɨ ranaheimbo dabadürɨ. Rananɨmbo se sünambe napo afɨndeimbɨ-ndamboyafɨ. Ranɨ boatei ranɨ-süŋgundo mbundambo anɨmbo asu wandɨ süŋgu dɨdɨfɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ŋga nindou ranai Sisas hoafɨmayu ra hɨmborɨyu haya ŋgusüfoambe nɨmbɨmayu, nɨmboe sapo ai napo afɨndeimbɨ wambo. ");
INSERT INTO agg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sisas ai horiranɨ mayoa hoafɨyuhɨ yahuya, “Nindou napo afɨndeimbɨ ana God ŋgɨnɨndɨ hɨfandarandɨ ranambe kefoefembo tɨŋümbane. ");
INSERT INTO agg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nɨnɨhondɨ mamɨ ahandɨ ndürɨ kamer ranai ana hoearɨ kakɨmbo nir ambenafɨ kefoefembo tɨŋümbɨyopoanɨ, ŋga nindou napo afɨndeimbɨ ai God ŋgɨnɨndɨ hɨfandarandɨ ranambe kefoefembo ana, tɨŋümbane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nindou bɨdɨfɨrɨ ranai hoafɨ ra hɨmborɨyeihehi düdurɨhorühɨ seiya, “Asu refe ana, nindou dɨdɨ ai yaŋgɨrɨ koadürü koadürümbo manüŋgua?” ");
INSERT INTO agg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sisas ai sɨmborɨ hoafɨyuhɨya, “Nɨnɨ-moatükunɨyo nindoumbo tɨŋümbayo ra Godɨmbo ana tɨŋümbɨyopoanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Asu Pita ai hoafɨyuhɨ yahuya, “Awi! Ro yɨhoefɨ ŋgoafɨ hɨnɨŋgɨrɨhu hohu sɨhafɨ süŋgu masɨnefɨ,” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Sisas ai hoafɨyupurühɨ yahuya, “Ro sɨhamumbo anɨhondümboanahɨ hoafehapurɨ, nindou düdi God ŋgɨnɨndɨ hɨfandarandɨ ranahambohünda ahandɨ ŋgoafɨ, nɨmorehɨ, akohoandɨ, boagɨrɨ nɨmoakɨdɨbou hɨnɨŋgareandürɨ ana, hɨfɨ ndanɨhü God ai aheimbo afɨndɨ moatükunɨ dagadürümbui. Asu süŋgunambo aho ra yaŋgɨrɨ koadürü koadürümbo nɨŋgo ra ndahümündimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sisas ai süŋgrurü-rundeimbɨ 12 sepurɨmündü hɨnɨŋgɨreapurɨ haya hoafɨyupurühɨ yahuya, “Hɨmborɨyomo! Haponda sɨhɨrɨ Serusaremɨnambo anefɨ ahahifɨ. Ranɨhü anɨmbo sapo Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ nindou ai Nindou Hondü ranahambo nɨnɨ-moatükunɨyo tüküfembo horombo sürü papɨru masɨhoemo ra anɨhondü tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ai ahambo ndɨfoyei warɨhündüwurɨmboemo. Rananɨmbo ahambo tɨkɨfɨnambondɨhorɨ, türüfoefe hoafɨndei, asu ŋgurɨ tɨfɨndahi raraondɨhümboyei. ");
INSERT INTO agg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Rananɨmbo asu ahambo ndüfurɨ ndüfurɨboadüwurɨ mbundümbo hɨfokoandüwurɨ-mboemo, ŋga ŋgɨmɨ sindo haya süŋgunambo asükai botɨndüfimbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ŋga asu ahambo süŋgrurü-rundeimbɨ ai moai hoafɨ ra türüfoaru fɨfɨrundɨ. Hoafɨ ranahandɨ nɨmɨndɨ ra moai ahamundɨ hohoanɨmoambe weindahɨfeyo. Asu ai moai Sisas nɨmboe hoafɨmayu ra akɨdou-amboanɨ fɨfɨrundɨ. ");
INSERT INTO agg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sisas ai Seriko ŋgoafɨkɨmɨ huane nindou mamɨ hɨmboatɨharɨ nafɨkɨmɨ nɨmarümbo nindou heiyanɨ kakɨ napombo moako-moakoyu marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ai hɨmborɨyuwanɨ awai nendɨ afɨndɨ ranai tümareandamboyu, asu nindou ranaheimbo düdureandürühɨ yahuya, “Nindou ra nɨnɨhünda?” mehundüramboyo. ");
INSERT INTO agg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Asu nindou ranai seiya, “Sisas Nasaretɨhündɨ ranai ndanafɨ masɨnuamboanɨyefɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nindou hɨmboatɨharɨ ranai puküna hoafɨ karɨhoeihü hoafɨyuhɨ yahuya, “Sisas, Defitɨndɨ ahuirɨ, se wambo hɨpoambo-rowandɨrɨ.” ");
INSERT INTO agg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Asu nindou horomboyahi masɨnei ranai ŋgɨnɨndɨ hoafɨyahündowohü seiya, “Se hoafɨ kɨkɨrandɨfɨ,” maseiamboyu. Asu nindou ranai asükai hoafɨ puküna karɨhoeihüya, “Sisas Defitɨndɨ ahuirɨ, se wambo hɨpoambo-rowandɨrɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ranɨyo Sisas ai hu nüŋgumbo nindou hɨmboatɨharɨ ranahambo ahambo sowanambo semündühombo hoafɨmayu. Nindou ranai hu manüŋguwa Sisas ai düdurirühɨ yahuya, ");
INSERT INTO agg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ro sɨhambo nɨnɨ-moatükunɨ nünüŋgufenɨnɨmboyo se hohoanɨmoayafa?” mehundowamboyu. Asu nindou ranai yahuya, “Nindou Adükarɨ, ro wandɨ hɨmboarɨ ra asükai aboedɨmbeyowa samboanahɨ.” ");
INSERT INTO agg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sisas ai sɨmborɨ hoafɨyundowohü yahuya, “Sɨhafɨ hɨmboarɨ ra aboed-ane. Sɨhafɨ anɨhondümbofe ranɨ süŋgumboyafɨ se aboedayafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Asu mamɨharɨ ahandɨ hɨmboarɨ ranai bɨrɨmahoeyowamboyu Sisasɨndɨ süŋgu huhü Godɨmbo aboed-ani mehu. Nindou afɨndɨ ranai ranɨ-moatükunɨ ra hoeirɨhinda mayoa ai-amboanɨ Godɨmbo aboed-ani masei. ");
INSERT INTO agg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sisas ai Seriko ŋgoafɨ mbusümo nafɨ hu ŋgasünde haya mahu. ");
INSERT INTO agg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Huane asu nindou mamɨ ranɨ ŋgoafɨhü mamaru ahandɨ ndürɨ Sakius ai napo afɨndeimbɨ, takis kakɨ sowandümo-rundeimbɨ-yomondɨ bogorɨyu. ");
INSERT INTO agg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ai Sisasɨmbo nüŋgunahurai nindouyu yahuhaya hoeifimbo mehu, ŋga nɨmorehɨ nindowenihɨ afɨndɨ burɨyeimbo ahambo hoefimbo fondɨ gümarɨhinda asu Sakius ai bodɨfo wambo ranɨmbo ŋgɨrɨ ahambo hoeindirɨ. ");
INSERT INTO agg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ranɨyu asu ai horombofi pɨpɨyu hu haya nɨmɨndɨ nɨmoamo mahafu Sisasɨmbo hoeindɨhinɨ yahuhaya. Ai fɨfɨre haya Sisasɨmboya nafɨ mamɨ ranɨnafɨ anɨmbo düdü haya ŋgumbui yahuhaya. ");
INSERT INTO agg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ranɨyu Sisas ai ranɨhü tüküfi asu nɨmɨwamɨ nɨmoamo hɨmboyuhü Sakiusɨmbo hoafɨyundowohü yahuya, “Sakius, se kosɨfoao, hapoana ro sɨhafɨ worambe dɨdɨ nɨmandɨmboyahɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ranɨyu ai nɨmehünou kusɨfoendühɨ ŋgusüfoambe hɨhɨfɨ-hɨhɨfɨyuhü Sisasɨmbo ahandɨ worɨna serümündü mahu. ");
INSERT INTO agg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ŋga muŋguambo nindou ai Sisas Sakius dɨbombo mahafandɨ ra hoeirɨhi mburɨhü asu momorɨ hoafɨyeihɨ seiya, “Ai ahu ranana moaruwai hohoanɨmoyu-randeimbɨndɨ worɨnamboani,” masei. ");
INSERT INTO agg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ranɨyo Sakius ai nüŋgumbo Adükarɨmbo yare hoafɨyunduwohü yahuya, “Adükarɨ se hɨmborɨyafɨ, hapoana wandɨ-mayo muŋgu moatükunɨ ra yɨbobondɨhe mbundɨha nindou napokoate-yeimbɨmbo ŋgorü bɨdɨfɨrɨ ndehamboyahɨ, asu nindou ŋgoründɨ-mayo takis kakɨ wosɨhoafɨ hoafɨya hehea sahamɨndɨheimbɨ ana, asükai yimbuyimbumbo hɨhɨrɨndahe ŋga ndahandomboyahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ra-mehuamboyu Sisas ai hoafɨyundowohü yahuya, “Hapoana God ai nɨmorehɨ nindowenihɨ worɨ ndambeahɨndɨ aboedambo-reandürühani. Nɨmboe, nindou ranamboa ai Abrahamɨndɨ amoao-ani. ");
INSERT INTO agg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nindou Hondü makusu ranana sapo nindou awarɨhehindeimbɨ kokoyondürɨ aboedambo-fendürɨmboyu makusu,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Rarɨhi nɨmorehɨ nindowenihɨ afɨndɨ ranai hɨmborɨyeiane, asükai Sisas ai aheimbo kafoefe hoafɨ mamɨ hoafɨmayundürɨ. Nɨmboe sapo ai Serusarem fikɨmɨ akɨmɨmayuambo nindou ranai rarɨhi hohoanɨmoyeihɨya, God ŋgɨnɨndɨ hɨfandarandɨ ra nɨmehünou anɨmbo tükündɨfemboe, masei. ");
INSERT INTO agg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Asu ai yare hoafɨyuhɨ yahuya, “Mamɨmbo ana bogorɨ nindou mamɨ aŋgunɨ hɨfɨna ahambo adükarɨ bogorɨmbofi hɨnɨŋgɨfimbohünda mahu. Bogorɨmbofe mbuiyombo asükai ŋgoafɨnambo hɨhɨrɨfe hombo hohoanɨmomayu. ");
INSERT INTO agg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ŋga ai hombo yahuhaya ahandɨ ratüpurɨyomo-rundeimbɨmbo mborai yahupura mahomondamboyo gorɨnambo nafümbɨ kakɨ hoarɨ nindou mamamɨmbo yimbureapurühɨ yahuya, ‘Se kakɨ nda ndowandümo houmbo bɨdɨfɨrɨ kakɨ semɨndɨmbohündambo ratüpurɨndɨmondanɨ ro asükai tükündaheamboane,’ mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ŋga asu mamɨ ranɨ ŋgoafɨhündɨ ranai nindou ranahambo yɨboarukomarɨhorɨ. Ranɨyo ai huane nindou bɨdɨfɨrɨ koamarɨhehipura bogorɨ nindou mahüfu ŋgoafɨna hoafɨ sowandümo hɨfomo hoafɨyomondühɨ yahomoya, ‘Ro moei asefɨ nindou ranahambo bogorɨmbofembo ana,’ mehomo. ");
INSERT INTO agg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ŋga asu nindou ranai adükarɨ bogorɨmbofi mbura ŋgoafɨna hɨhɨrɨfi mahu. Ai hɨhɨrɨfi hu nɨmarümbo ahandɨ ratüpurɨyomo-rundeimbɨ ranahamumbo nɨmehünou hoafɨmayupurɨ ahambo sowana howanɨ gorɨnambo nafümbɨ kakɨ hoarɨ masagapurɨ ranɨfihɨ nüŋgunümbɨ mbasowandümo yaho düdufepurɨmbohünda. ");
INSERT INTO agg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nindou ŋgorü ai boatei horombofi sünɨ hoafɨyuhɨ yahuya, ‘Adükarɨ, ro sɨhafɨ-mayo gorɨnambo nafümbɨ kakɨ hoarɨ mamɨ ranɨnambo bɨdɨfɨrɨ kakɨ semɨndɨmbo ratüpurɨyambo kakɨ hoarɨ 10 masahamɨndɨhɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Asu bogorɨ ai yare hoafɨyundowohü yahuya, ‘Se aboedɨ ratüpurɨ ramarowandɨ ra aboedɨ hamɨndɨ hondü-ane, ranɨ-moatükunɨ akɨdou ra se dɨboadoro hɨfandɨmarandɨ. Ranɨmboanahɨ asu ro sɨhambo ŋgoafɨ 10 se hɨfandɨmbohünda hɨnɨŋgarɨheandɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Asükai ratüpurɨyu-randeimbɨ ŋgorü ai sünɨ hoafɨyuhɨ yahuya, ‘Adükarɨ, ro sɨhafɨ-mayo gorɨnambo nafümbɨ kakɨ hoarɨ masawandɨ ranɨnambo kakɨ semɨndɨmbo ratüpurɨyambo hondahüfeimbɨ kakɨ hoarɨ masahamɨndɨhɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Asu bogorɨ ai yare hoafɨyundowohü yahuya, ‘Ro sɨhambo hondahüfeimbɨ ŋgoafɨ hɨbadandɨ sa hehea hɨnɨŋgarɨheandɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Asükai ŋgorü ai sünɨ hoafɨyuhɨ yahuya, ‘Adükarɨ, gorɨnambo nafümbɨ kakɨ hoarɨ sɨhafɨ-mayo nda, ro hoearambe parɨhe hɨmondɨhe sɨheheanda meŋgoro. ");
INSERT INTO agg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nɨmboe sapo ro hoeirɨhenɨna, se ŋgɨnɨndɨyafɨ-randeimbɨ nindoumefambo. Sapo nɨnɨ-moatükunɨ nindou bɨdɨfɨrɨ ai sɨhehinda se sowandɨfɨ asu sesɨ amboanɨ bɨdɨfɨrɨ nindou ai hɨfɨrɨhinda se sowandɨfɨ arandɨ ranɨmboanahɨ ro sɨhambo yɨhɨmboayahɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ranɨyu bogorɨ ai nindou ranahambo yare hoafɨyundowohü yahuya, ‘Se nindou moaruwai ratüpurɨyafɨ randeimb-anafɨ. Sɨhafɨ ranɨ süŋgumbo anɨmbo sɨhambo hɨhɨnde papɨ-hoafɨndanɨnɨmboe. Sapo se fɨfɨrowamboanafɨ ro ŋgɨnɨndɨya rɨhandeimbɨ nindou-anahɨ, asu ro bɨdɨfɨrɨ nindou ai napo sɨhehinda sahamɨndɨ asükai sesɨ hɨfɨrɨhinda sahamɨndɨ rɨhandeimb-anahɨ. ");
INSERT INTO agg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Asu nɨmboe se kakɨ wandɨ beŋambe sɨhefekoate-mayafa? Sapo rananɨmbo ro hɨhɨrɨfe kosɨhü wandɨ kakɨ ra bɨdɨfɨrɨ ranɨfihɨndɨ kameihɨ hɨhɨrɨhe sahamɨndɨ,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ŋga bogorɨ nindou ranai nindou akɨmɨ burɨmemo ranahamumbo yare hoafɨyupurühɨ yahuya, ‘Se ahandɨ-mayo gorɨnambo nafümbɨ kakɨ hoarɨ ra sowandümo mburumbo nindou kakɨ hoarɨ 10 masemündu ahambo dabudo,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Asu ai raru hoafɨyɨmondowohü yahomoya, ‘Adükarɨ, nindou ranai ana ndeara 10 kakɨ hoareimb-ani,’ mehomo. ");
INSERT INTO agg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ŋga asu bogorɨ nindou ranai hoafɨyuhɨ yahuya, ‘Ro sɨhamumbo hoafayahɨ, nindou bɨdɨfɨrɨ napo afɨndeimbɨ aiyomo aiana asükai bɨdɨfɨrɨ napo ndowandümboemo, ŋga nindou ai napo akɨdouyeimbɨ-mayei ranahei warambeahɨndɨ ana ŋgorüfemboane. ");
INSERT INTO agg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ŋga asu wandɨ hürütümbɨ-memo, sapo wambo adükarɨ bogorɨmbofembo yowanɨ mehomo ranahamumbo ndühɨ sowapurɨndümo sɨfomo wandɨ hɨmboarühɨ hɨfokoarüpurɨ!” mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sisas ai kafoefe hoafɨ ra hoafɨyu mbura asükaiyu Serusaremɨna mahüfu. ");
INSERT INTO agg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Sisas ai Betani asu Betfage ŋgoafɨkɨmɨ tüküfi Orif Wafu sei-arɨhündɨ-kɨmɨ homondühɨyo ahambo süŋgrurü-rundeimbɨ yimbu horombo koamarɨhepɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Asu ai yare hoafɨyupɨrühɨ yahuya, “Se ŋgoafɨ gebü anaŋgo ranɨnambo ŋgafanɨ. Ranühɨ se doŋgi mamɨ hoarɨfɨ hoeindɨneanda wofɨna hɨmondɨndümo hɨnɨŋgɨndumboemo ra moai nindou dɨdɨ ai-amboanɨ horombo ranɨwamɨ nɨmaruwanɨ serɨmɨndɨ ho-randɨ. Asu wofɨ fufurɨgene mbundɨna wambo sowana ndowandɨfanɨ dügüfanɨ. ");
INSERT INTO agg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Asu nindou ŋgorü ai sɨhafanɨmbo düdundɨfihɨya, ‘Nɨmboe se doŋgi ra fufurarɨheneandɨ?’ mbüsuwanɨ asu se ahambo hoafɨndafɨnandowohüya, ‘Adükarɨ ai bɨdɨfɨrɨ moatükunɨ refembo doŋgi ranambo hoafɨmayuambo anɨhoandɨ,’ mbɨsafanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sisas ai koamarɨhepɨra hafanɨ hoeirɨneanda doŋgi hoarɨfɨ ranai ahafanɨmbo hoafɨmayupɨrɨ süŋgu ramefeyo. ");
INSERT INTO agg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ranɨ yimbu ai doŋgi ranahambo hapoadümbo wofɨ fufurɨhoefɨneanda ranɨ afɨndɨ ai ahafanɨmbo yahuya, “Nɨmboe se doŋgi ra wofɨ fufurarɨheneanda?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ŋga ai hoafɨyafandühɨ safanɨya, “Adükarɨ ai bɨdɨfɨrɨ moatükunɨ refembo doŋgi ranambo hoafɨmayuambo anɨhoandɨ,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ranɨyafanɨ asu doŋgi ra Sisasɨmbo sowana sowandɨfanɨ mahafanɨ. Asu ai ahafandɨ-mayo warɨ hoandarümbɨ ŋgɨsɨharɨ hoearɨ doŋgiwamɨ nandɨne mburɨna Sisasɨmbo ranɨwamɨ hɨnɨŋgɨmarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ai doŋgiwamɨ nɨmarü haya Serusarem ŋgoafɨkɨmɨ mahuwamboyei nindou bɨdɨfɨrɨ ahei warɨ hoandarümbɨ ŋgɨsɨharɨ hoearɨ ra nafɨnɨ ahambo hombohünda kurɨmarɨhinda ranɨwamɨ mahu. ");
INSERT INTO agg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sisas ai Serusarem ŋgoafɨnambo huhü Orif Hɨfɨ Wafu hanɨ nafɨ tüküfeambefiyuane, nindou afɨndɨ ahambo süŋgurɨhorɨ-rɨhündeimbɨ ranai hɨhɨfɨ-hɨhɨfɨmayei. Sapo ai muŋgu hepünɨfeimbɨ moatükunɨ hoeimarɨhindɨ ranɨmbo-hünda ai puküna hoafɨ karɨhehindühɨ Godɨmbo adükar-ani masei. ");
INSERT INTO agg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ai hoafɨyeihɨ seiya, “Adükarɨ bogorɨ ai Adükarɨndɨ süŋgu akusu ranahambo God ai aboedɨ-aboedɨmbɨriramboane. Sünambe muŋguambo ai aboedɨ amarei asu God nɨmoamo hamɨndɨ hondü anüŋgu ranahambo aboed-ani mbɨsei-amboane,” masei. ");
INSERT INTO agg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ŋga Farisi bɨdɨfɨrɨ nindou ranahei mbusümo burɨmemo ranai Sisasɨmbo raru hoafɨyomondühɨ yahomoya, “Yamundo-randeimbɨ, sɨhambo süŋgurɨhünɨnɨ-rɨhündeimbɨ ranaheimbo hoafɨndafanɨ anɨmbo ai ahei hoafɨ kɨboakɨmbɨrɨhümündi-amboane!” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ŋga asu Sisas ai sɨmborɨ yare hoafɨyupurühɨ yahuya, “Ro sɨhamumbo hoafayahapurɨ, nindou ranɨ hoafɨ ra hoafɨkoate-ayei ana, nɨmoei ai-amboanɨ puküna hoafɨndeimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sisas ai Serusarem ŋgoafɨkɨmɨ huhü ŋgoafɨ ra hoeireandühɨ ahambo aranɨnambomarandɨ. ");
INSERT INTO agg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ai yare hoafɨyuhɨ yahuya, “Serusarem, haponda ndanɨ sihɨ se aboedɨ nɨmarɨmbo hohoanɨmo nɨmɨndɨ ra fɨfɨrɨmbarowa-mbonana, aboedɨyo. Ŋga hapondanɨ ana awi ranɨ-moatükunɨ ra moai se hoeirowandɨ. ");
INSERT INTO agg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mamɨ sɨmboanɨ süŋgunambo ana nindou sɨhambo hürütürunɨneimbɨ ranai hɨfɨ sɨhafɨ ginɨrɨkɨmɨ wakɨndɨmondühɨ püpindu dɨfomombo sɨhambo muŋguambo gündünɨnɨmboemo. ");
INSERT INTO agg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Rananɨmbo sɨhambo moaruwaimbo-ndunɨnɨmboemo asu se-babɨdɨ amarei ranaheimbo amboa. Asu ŋgɨrɨ nɨmoei mamɨ amboanɨ nɨmoei ŋgoründɨwamɨ hɨnɨŋgɨndundɨ. Nɨmboe se moai fɨfɨrowandɨ sapo God ai sɨhambo aboedambo-fenɨnɨmbohünda makusu ra,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sisas ai Godɨndɨ worambe kefuai hüfu nindou kakɨhümbo napo sɨhoumarundɨ ra pütifoendühɨ hemafoareapurɨ. ");
INSERT INTO agg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ai yare hoafɨyɨpurɨhɨ yahuya, “Godɨndɨ Buk ai yare hoafɨyohü yahoya, ‘Wandɨ worɨ ranana dɨdɨbafɨfembo worɨ yaŋgɨrane. Ŋga se hümbuhünɨ nindou ranahei dɨbofembo fondɨmboarɨhindɨ,’ meho.” ");
INSERT INTO agg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ŋga muŋguambo si Godɨndɨ worɨ ranambe nindou yamundɨreandürɨ marandɨ. Asu Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨ, ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ, bogorɨ nindou bɨdɨfɨrɨ ai Sisasɨmbo nɨnɨ-süŋgufe hɨfokoefimbo nafɨ kokomarundɨ. ");
INSERT INTO agg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ŋga nindou afɨndɨ ranai ahandɨ hoafɨ hɨmborɨmbo afɨndɨ hohoanɨmo mayeiambo wambo moai ahambo hɨfokoefimbo nafɨ ra fɨfɨrundɨ. ");
INSERT INTO agg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mamɨ sɨmboanɨ Sisas ai Godɨndɨ worambe nɨmorehɨ nindowenihɨmbo yamundɨreandürühɨ aboedɨ hoafɨ ra bokarɨmarɨhendɨ. Ranɨyo Godɨmbo sɨhou-rundeimbɨ bogorɨ, ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ bogorɨ, asu Suda-yafe bogorɨ ai Sisas babɨdɨmbo wataporɨmbo mahafomo. ");
INSERT INTO agg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ai hoafɨyomondühɨ yahomoya, “Se hoafɨyafɨmunɨ nɨnɨ ŋgɨnɨndɨnamboyo ranɨ-moatükunɨ raro aranda? Düdi sɨhambo ranɨ ŋgɨnɨndɨ ra masaganɨna?” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Ro-amboa sɨhamumbo mamɨ moatükunɨ düdundaheanda asu se wambo hoafɨndɨmo. ");
INSERT INTO agg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Sapo Son ai nindoumbo hundürümarandürɨ ŋgɨnɨndɨ ra Godɨndɨ-mayoyo asu nindou-yafe-mayoyo?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ranɨyomo ahamundɨhoarɨ sɨmborɨ hoafɨndürɨyomondühɨ yahomoya, “Sapo sɨhɨrɨ hoafɨyefühɨya, Son hundürüra marandɨ ranana Godɨndɨ-mayoane asefɨ ana, ai rande hoafɨndühɨya, ‘Asu nɨmboe se ranahambo anɨhondümbofekoate-ayomoa,’ mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ŋga asu sɨhɨrɨ hoafɨyefühɨya, ‘Ranana nindou-yafe-mayoane,’ asefɨ ana, nindou ranai sɨhefɨmbo nɨmoeinambo-ndɨhümunɨmboyei. Nɨmboe sapo ai fɨfɨrɨhorɨ Son ai Godɨndɨ hoafɨ hoafɨyu-randeimb-ani sei anɨhondümbo-rɨhorühɨ wambo?” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ranɨyomo Sisasɨmbo raru hoafɨyomondühɨ yahomoya, “Ro moai fɨfɨrɨhundɨ Son ai ranɨ ŋgɨnɨndɨ ra nahünda semündü-hayambombai,” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ŋga Sisas ai yare hoafɨyupurühɨ yahuya, “Ro-amboa ŋgɨrɨ hoafɨndahapurɨ düdi wambo ŋgɨnɨndɨ masendɨ ratüpurɨmbohünda,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sisas ai nindou ranaheimbo kafoefe hoafɨ mamɨ hoafɨyundürühɨ yahuya, “Nindou mamɨ ai wain hɨfɨfembo nümbürɨra mbura nümbürɨ ra nindou bodɨmondɨ-yomondɨ warambe hɨnɨŋgɨmareandɨ ranɨfihɨ kakɨ semɨndɨmbo ratüpurɨmbohünda. Asu ai hu aŋgunɨ ŋgorü hɨfɨnɨ gedühɨ manüŋgu. ");
INSERT INTO agg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Asu wain ranai hɨsɨmayowamboyo nindou mamɨ koamarɨheira nümbürambe ratüpurɨmemo ranahamumbo sowana bɨdɨfɨrɨ hɨsɨ nümbürambeahɨndɨ semɨndɨmbohünda mahüfu. Ŋga asu nindou nümbürɨ ranambe ratüpurɨmemo ranai bubururü mburumbo nɨnɨ akɨdou-amboanɨ warambefekoate koamarɨhawura mahu. ");
INSERT INTO agg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Asükaiyu ŋgorü koamarɨheira ahamumbo sowana mahüfu. Ranɨyo ranahambo amboanɨ ahɨnɨkoate bubururü mburumbo nɨnɨ akɨdou-amboanɨ warambefendokoate koamarɨhawura mahu. ");
INSERT INTO agg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Asükaiyu ŋgorü koamarɨheira mahüfu. Ŋga asükaiyomo ahambo amboanɨ nümbürɨ hɨfandɨ-rundeimbɨ ranai bubururü mburumbo moanambühɨ kiafu hüründümo pimarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ranɨyu asu nümbürɨ afɨndɨ ranai hoafɨyuhɨ yahuya, ‘Haponda ro nüŋgumandɨhea? Ro wandɨ nɨmorɨ afɨndɨ hohoanɨmo-yahandoweimbɨ ra koandɨhehinɨmboyahɨ. Awi ahandɨ hoafɨ anɨmbo hɨmborɨndɨmboemo.’ ");
INSERT INTO agg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ŋga asu nümbürɨ hɨfandɨ-rundeimbɨ ranai nindou ranahandɨ nɨmorɨ masüfuwa hoeirüwurɨ houmbo sɨmborɨ hoafɨrɨyomondühɨ yahomoya, ‘Nindou ndanana nümbürɨ afɨndandɨ nɨmor-ani. Sɨhɨrɨ ahambo hɨfokoararɨhurɨ anɨmbo asu muŋgu-moatükunɨ ra sɨhefɨndɨmboe,’ mehomo. ");
INSERT INTO agg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ranɨyo nümbürɨ hɨfandɨ-rundeimbɨ ranai nümbürambeahɨndɨ sowaründümo moanewanɨ tüküyafu homo hɨfokoamarüwurɨ. Asu nümbürɨ ranɨ afɨndɨ ranai nindou ranahamumbo nɨnɨ-nünüŋgumandeapura? ");
INSERT INTO agg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ai düdɨ nümbürɨ ranambeahɨndɨ nindou ranahamumbo hɨfokoandeapurühɨ wain nümbürɨ ra nindou bɨdɨfɨrambo dagapurɨmbui,” mehu. Nindou ranai hoafɨ ra hɨmborɨyei hehimbo hoafɨyeihɨ seiya, “Awi ranɨ-moatükunɨ ra tükündɨfemboe, ŋga ambembeyo-wamboane,” masei. ");
INSERT INTO agg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ŋga Sisas ai aheimbo hɨmboarɨ pareandürühɨ nüŋgumbo düdureandürühɨ yahuya, “Nɨmboe asu Godɨndɨ bukambe sürü ra paru masɨhoemoa? ‘Nɨmoei worɨmboru-rundeimbɨ ai moaruwai-ane yahomo houmbo ambe mehomo, ŋga nɨmoei ra worɨ ranahambo ŋgɨnemɨndɨmbo weaŋgurühɨdɨdɨ bogorɨ nɨmoeiyo.’ ");
INSERT INTO agg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Muŋguambo nindou nɨmoei ranɨwamɨ pɨrayei ana, ai mbusümo kɨkɨndahimboyei, asu nɨmoei ranai nindouwamɨ pɨrayo ana, nindoumbo muŋguna mosɨhoasɨndɨheirɨmboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ranɨyo ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨyomo asu Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨyomo ai raru fɨfɨrɨmarundɨ Sisas ai kafoefe hoafɨ hoafɨmayu ra ahamumboyo. Ranɨmboemo mamɨ ranɨ-sɨmboanɨ ai botɨfe Sisasɨmbo kɨkɨhimɨndɨmbo hohoanɨmomemo, ŋga nɨmorehɨ nindowenihɨ ranaheimboya yɨhoefɨmbo nünüŋgumandɨhimunɨ yahomo houmbo yɨhɨmbomemo. ");
INSERT INTO agg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ-yomo asu Godɨmbo sesɨ sɨhou-rundeimbɨ-yomo ai Sisasɨmbo hɨfandurühɨ nindou bɨdɨfɨrɨ koamarɨhoupura tɨkaruhoumbo ahandɨ hoafɨ hɨmborɨmbo nouyafu mahɨfomo. Nindou ranai ana tɨkaru hou ŋgorü süŋgufihɨ ahandɨ hoafɨ hɨmborɨyowohü moaruwai hoafɨmayu yaho hefe gafman bogorɨndɨ warɨhü hɨnɨŋgɨfiyuwanɨ papɨ-hoafɨ-mbüruramboane, yahomomboemo. ");
INSERT INTO agg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tɨrɨfoefe hoafombo mahɨfomo ranai düduyafundühɨ yahomoya, “Nindou yamundo-randeimbɨ, fɨfɨrɨhumboanefɨ hoafɨ se hoafayaf-ane asu yamundarowand-ane ranana anɨhond-ane. Seana nindou ranai adükarɨ ndüreimbɨmbayeiyo asu ndürɨkoate-mbayeiyo ra moai hohoanɨmoyafɨ, ŋga seana anɨhondümbofe hohoanɨmo Godɨndɨ-mayo ranane yamundo arandɨ. ");
INSERT INTO agg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Se yɨhoefɨmbo hoafɨyafɨ, ro Sisarɨmbo takis kakɨ ra mandahundoyo asu wanɨmandɨyo?” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Sisas ai fɨfɨreandɨ ranana ahambo tɨkaruhoumbo wosɨhoaforɨ-rurühɨyomo asu sɨmborɨ hoafɨyuhɨ yahuya, “Wambo kakɨ mamɨ nafuiyomo. Sɨsamɨ asu ndürɨ kakɨfihɨ apenɨŋgo ra dadea?” mehuamboemo. Yahomoya, “Sisarɨnd-ane,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Asu Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Sisarɨndɨ moatükunayo ana, se Sisarɨmbo dabudo. Asu Godɨndɨ moatükunayo ana ra se Godɨmbo dabudo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ranɨyo Sisas ai nɨmorehɨ nindowenihɨ babɨdɨmbo nüŋgumbo wataporɨmbo-randambe moai wosɨhoaforɨyumbo hohoanɨmoyomo. Ranɨyomo ahamundɨ düdufe hoafɨ ranahambo sɨmborɨ hoafɨyu maranda hepünafundühɨ hoafɨ kɨkɨründümo houmbo manɨŋgomo. ");
INSERT INTO agg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusihündɨ bɨdɨfɨrɨ ai raru hohoanɨmoyomondühɨya, nindou yɨfɨhündɨ ŋgɨrɨ asükai botɨndahindɨ yahomo-rundeimbɨ ai Sisas sowana mahɨfomo. ");
INSERT INTO agg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ai Sisasɨmbo düduyafundühɨ yahomoya, “Nindou yamundo-randeimbɨ, Moses ai sɨhefɨmbo hoafɨ mamɨ sürü papɨra masɨhendɨ sapo nindou mamɨ nɨmorehɨ semündü mbura asu nɨmorɨ-koate yɨfayu ana, ahandɨ akɨdɨ ranai nɨmorehɨ ra asükai semündü haya nɨmorɨ wakɨndamɨndoanɨ nɨmorɨ ranai amoŋgoandɨ nɨmorɨ noumbiyuwamboane. ");
INSERT INTO agg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","30","Mamɨmbo apodoho mamɨ 7 manɨŋgomo. Amoŋgo hondü ai nɨmorehɨ semündü haya nɨmorɨ-koate yɨfɨyuane, asükai akɨdɨ mbusümonɨndɨ ai amoŋgoandɨ kai ra semündü haya yɨfɨyuane. ");
INSERT INTO agg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Asükai akɨdɨ ŋgorü ai-amboanɨ amoŋgoandɨ kai ra masemündu. Apodoho mamɨ 7 ranai muŋguambo nɨmorehɨ ra semɨndeimbɨ yaŋgɨrɨmemo, ŋga ai nɨmorɨ-koate yɨfɨsafɨmemo. ");
INSERT INTO agg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Asu süŋguna nɨmorehɨ ranai-amboanɨ yɨfɨmayo. ");
INSERT INTO agg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Muŋguambo apodoho mamɨ 7 ranai nɨmorehɨ ra masowandümo. Süŋgunambo nindou yɨfɨhündɨ botɨfeambe nɨmorehɨ ra dadɨ nɨmorehɨ-manda?” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ranɨyu Sisas ai ahamumbo yare hoafɨyɨpurühɨ yahuya, “Hɨfɨ ndanühane nindowenihɨ ai nɨmorehühɨyafu asu nɨmorehɨ ai anamɨndühɨyahi arɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ŋga nɨmorehɨ nindowenihɨ yɨfɨhündɨ asükai yaŋgɨrɨ botayahindɨ ana, ŋgɨrɨ nɨmorehühɨndafu asu anamɨndühɨndahi rarandɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ranɨ-sɨmboanɨ ana ai sünambeahɨndɨ nendɨ nahurai-wambo ŋgɨrɨ yɨfɨndei. Sapo God ai yɨfɨhündɨ botɨrearü hayambo wambo ai ahandɨ nɨmor-anei. ");
INSERT INTO agg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Sapo Moses amboanɨ nindou yɨfɨyeimbɨ botɨndahimboyei ranahambo ndore nafuimayu. Ai nɨmɨ akɨdou hai tɨkɨrɨmarandɨ ranahambo sürü papɨrandühɨya, ‘Adükarɨ God ranana Abraham, Aisak, Sekop ahamundani.’ ");
INSERT INTO agg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ranɨmboane asu God ranana yɨfɨyeimbɨyei Godɨyupoanɨ, ŋga yaŋgɨrɨ anɨboadeiyei God-ani. Nindou düdi ai Godayu ra koadürümbo yaŋgɨrɨ nüŋgumboani,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ bɨdɨfɨrɨ ai hoafɨyomondühɨ yahomoya, “Nindou yamundo-randeimbɨ sɨhafɨ hoafɨ ra aboed-ane,” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ranɨyomo nindou ranai asükai ŋgorü moatükunɨmbo Sisasɨmbo düdufembo yɨhɨmbomemo. ");
INSERT INTO agg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ranɨyo Sisas ai nindou ranaheimbo düdureirühɨ yahuya, “Asu nɨmboe nindou ai hoafɨyeihɨya, ‘Krais nindou God ai nindoumbo aboedambo-fembo kamafoarirɨ ra Defitɨndɨ ahuirani,’ aseia? ");
INSERT INTO agg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Sapo Defit ahandɨhoarɨ Herü Buk ranambe yare hoafɨyuhɨya, ‘Adükarɨ ai wandɨ Adükarɨmbo hoafɨyundowohü yahuya, ‘Se wandɨ warɨhondanɨ bogorɨmbondafo nɨmandɨfɨ ŋgafɨmbo ro sɨhambo hürütümbɨ ra sɨhafɨ hoarehɨ hɨnɨŋgɨ-ndɨheapurɨmboane,’ mehu. ");
INSERT INTO agg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Defit ai nindou ranahambo Adükarɨ yahu marandɨ, asu Krais ai nüŋgunde ahandɨ ahuirɨmanda?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Nindou afɨndɨ ranai hɨhɨmborɨyeiane, Sisas ai ahambo süŋgrurü-rundeimbɨmbo hoafɨyuhɨ yahuya, “Se ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨmbo hɨbadümbo. Ai hoandarɨ hoearɨ güdɨfe hefe hoahoaŋgo wakɨfeyoanɨ nindou ai ahamumbo hɨhɨfɨyopurɨ asu maketambe ahamumbo ahɨnɨyopurɨ-ramboanemo hohoanɨmoemo. Aiana Suda-yafe rotu worambe fondɨ wagabe ranɨwamɨ nɨmarɨ asu sesɨ sesambe sia semɨndɨ nindɨfe hefe wagabe nɨmarɨmboanemo hohoanɨmoemo. ");
INSERT INTO agg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ŋga aiana nɨmorehɨ kaisahoabedɨ ranaheimbo wosɨhoaforɨ-yondürühɨ ahei worɨ ahamumboru marundɨ. Asu ai aboedanemo mbɨseiya yahomo houmbo Godɨmbo dɨdɨbafɨyomondühɨ ra hoandarɨ hamɨndɨ dɨdɨbafɨyomo arundɨ. Ŋga süŋgunambo nindou ranaheimbo yɨbobofendürɨmbo sɨmboanɨ ana tɨŋɨrɨfo afɨndɨ safɨ ndowandümboemo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sisas ai nɨmarü hɨmboapoyuane, nindou napo afɨndeimbɨ ranai hei Godɨndɨ worɨ ranahandɨ hɨpɨrambe kakɨ mafoarɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ranɨyo asu nɨmorehɨ kai napo-koate ranai hamburɨ kakɨ yimbu hɨpɨrɨ ranambe mafoareanda hoeimareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sisas ai hoafɨyupurühɨ yahuya, “Ro sɨhamumbo anɨhondümboanahɨ nda hoafayahapurɨ, nɨmorehɨ kai napo-koate masɨhendɨ ranai nindou napo afɨndeimbɨ masɨhehindɨ ranahambo ŋgasünde-amboane. ");
INSERT INTO agg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nindou napo afɨndeimbɨ masɨhehindɨ ranana akɨdouyo masɨhehindɨ, ŋga ahei adükarɨ ana mbeŋgorɨndürɨ. Ŋga nɨmorehɨ kai ndanana akɨdou meŋgoro ra masɨhendɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sisasɨmbo süŋgrurü-rundeimbɨ bɨdɨfɨrɨ ranai Godɨndɨ worɨ ranahambo nɨmoei aboedɨnamboyo asu Godɨmbo saimbo moatükunɨnambo yihururu marundɨ ranahambo wataporɨmbomarundɨ. Ŋga asu Sisas ai hoafɨyuhɨ yahuya, ");
INSERT INTO agg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ro sɨhamumbo hoafayahapurɨ, ndanɨ moatükunɨ hoeiarundɨ nda mamɨ sɨmboanɨ ŋgɨrɨ nɨmoei mamamboanɨ ŋgoründɨwamɨ naŋgo, ŋga ai hɨfɨtɨreboai pütapɨndɨmboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Asu ai düduyafundühɨ yahomoya, “Nindou yamundo-randeimbɨ, ranɨ-moatükunɨ ra nüŋgu-sɨmboanɨ tükümandɨfea? Nɨnɨ boatei tükümandɨfe ranɨ-moatükunɨ tüküfemboayo ranahambo nafuimboa?” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sisas ai hoafɨyupurühɨ yahuya, “Se hɨbadümbo, ŋga nindou ai mamɨ sɨmboanɨ sɨhamumbo tɨkai hoafɨndɨmboemo. Nindou afɨndɨ ai ŋgomo wandɨ ndürɨ dükandundühɨ anɨmboya, ‘Ro rananahɨ nda,’ asu ‘Ndearambo ranɨ-moatükunɨ ra tüküfemboane,’ mbɨsɨmboemo, ŋga se yowanɨ ahamundɨ süŋgufepoanɨ. ");
INSERT INTO agg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Asu se ŋgorü hɨfɨhündɨ nindou yifiaremo hoafɨ, asu ŋogrü ŋgoafɨhündɨ yifiaremo hoafɨ ra hɨmborɨndeihɨ yɨhɨmbondeimboyei. Ŋga sapo ranɨ-moatükunɨ boatei tükündɨfemboe, ŋga bɨdɨfɨranambo si ana ŋgɨrɨ nɨmai tükündɨfeyo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ranɨyo aheimbo hoafɨyundürühɨ yahuya, “Ŋgorü hɨfɨhündɨ ai ŋgorü hɨfɨhündɨ babɨdɨmbo yifiarɨndɨmboemo asu ŋgorü adükarɨ bogorɨndɨ nendɨ ai ŋgorü adükarɨ bogorɨndɨ nendɨ babɨdɨmbo yifiarɨndɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hɨfɨhe afɨndɨ hamɨndɨ tükündɨfehü asu ŋgorügoanɨnɨ sesɨkoate-ndeihɨ wembombondei asu aŋgünɨhaindei raraondɨhümboyei. Asu sünambe ranɨ-poanɨmbo yɨhɨmboeimbɨ moatükunɨ bɨdɨfɨranambo si tüküfemboayo ra nafuimbohünda tükündɨfeyoanɨ se yɨhɨmbondeimboyei. ");
INSERT INTO agg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ŋga ranɨ-moatükunɨ ranai tüküfekoate-yoambe anɨmbo se wambo anɨhondümbo-arɨhindɨrɨ ranɨmbo-hünda nindou ai sɨheimbo kɨkɨhɨndümondürɨ houmbo moaruwaimbo-ndundürɨmboemo. Rananɨmbo rotu worambe papɨ-hoafɨndundürɨ mbundümbo karabusɨ-ndundürɨmboemo. Asu ndowandümondürɨ ŋgomo adükarɨ bogorɨ asu gafmanɨ-yomondɨ hɨmboahü papɨ-hoafɨndundürɨmboemo. ");
INSERT INTO agg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Refeambe anɨmbo sɨheimbo aboedɨ hoafɨ ra wataporɨmbo-yombo nafɨ yagodɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ranɨmboane se afɨndɨ hohoanɨmondeihɨya, ro nɨnɨ hoafɨ hoafɨmandefɨ mbɨseimboyei. ");
INSERT INTO agg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nɨmboe sapo ro wandɨhoarɨ anɨmbo sɨhei hohoanɨmoambe horɨndɨheandühɨ ndorɨhoeimbɨ fɨfɨrɨfe ndahandüranɨ se hoafayei ra nindou ŋgorü ai-amboanɨ ŋgɨrɨ gogonɨmbondɨhendühɨ moaruwaimbo-ndeandɨ. ");
INSERT INTO agg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Sɨheimbo sɨhei boagɨrɨ, amoŋgo-mamɨ, akohoandɨ, rehɨmamɨ, mamɨsɨrɨ, ŋgunindɨ rananɨmbo hürütümbɨ nindouyei warɨhündɨhindürɨmboyei. Rananɨmbo seambeahɨndɨ bɨdɨfɨrɨ ana hɨfokoandundürɨmboemo. ");
INSERT INTO agg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Muŋguambo nindou ai sɨhamumbo moaruwaimbo-ndɨhindürɨmboyei, sapo se wambo anɨhondümbo-arɨhindɨrɨ ranɨmbo-hünda. ");
INSERT INTO agg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Ŋga sɨhei mbɨrɨnaŋɨ mamɨ ra ŋgɨrɨ fɨndɨhoaiyo. Se ŋgɨnɨndɨ anɨboadei anɨmbo se yaŋgɨrɨ nɨŋgombo hondü ndahümündimboyei. Rananɨmbo sɨhamundɨ fimbo fandɨhepurɨmboe sɨhamundɨ yaŋgɨrɨ nɨŋgo ranahambo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Sisas yahuya, “Se hoeirɨhindanɨ ami ai sɨnɨmo Serusarem ŋgoafɨ ra worarɨ wakarundɨ ana, se fɨfɨrɨndɨhindɨ Serusarem ai ndeara moaruwaimbo akɨmane. ");
INSERT INTO agg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Rananɨmbo nindou dɨdɨyei Sudia ŋgoafɨhü amarei se feboehi hehi hɨfɨ wafuana gagüsi asu Serusarem ŋgoafɨhü amarei se ŋgoafɨ ra hɨnɨŋgɨndɨhi hehi ŋgorünɨ ŋgei, asu ŋgorü hɨfɨhü anɨmboei se yowanɨ Serusarem ŋgoafɨnambo hopoanɨ. ");
INSERT INTO agg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ranɨ-sɨmboanɨ anɨmbo God ai tɨŋɨrɨfo masahündürɨ ranaheimbo sɨmborɨ moaruwaimbo-ndearümbui, rananɨmbo muŋgu-moatükunɨ Bukambe hoafɨmayo ra anɨhondü tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ranɨ-sɨmboanɨ ana nɨmorehɨ warandühumbɨ asu nɨmorɨ kehureimbɨ ana hɨpoanɨhɨmboeimbou-anei. Sapo ranɨ-sɨmboanɨ anɨmbo hɨfɨ ndanɨhü nɨmborɨ afɨndɨ tükündɨfehü asu Godɨndɨ moaruwaimbofe ra nɨmorehɨ nindowenihɨ ranaheiwamɨ pɨndɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Rananɨmbo harɨ nendɨ ai dɨdɨmo nindou bɨdɨfɨrambo hɨfokoakondundürühɨ asu bɨdɨfɨrambo karabus nindoumbo-ndundürɨ muŋguambo hɨfɨna ndowandoümondürɨ ŋgomboemo. Rananɨmbo ahei ndɨfo ranai Serusarem ŋgoafɨ ra pühɨndei nɨmandi ŋgeimbo God ai aheimbo hɨfandɨmbo hoafɨmayu süŋgu tükündɨfemboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Sisas ai hoafɨyuhɨ yahuya, “Ranɨ-sɨmboanɨ ana ranɨ-poanɨmbo wosɨhoaforɨ moatükunɨ hüfɨhamɨndɨ, amoamo asu mupui ranɨfihɨ tükündɨfemboe. Asu hɨfɨnɨ sɨrɨwara ranai afɨndɨ-afɨndɨndowohü mbundo pɨndo ndandanɨ nindou ai afɨndɨ hohoanɨmondeihɨ yɨhɨmbondeimboyei. ");
INSERT INTO agg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nindou afɨndɨ ranai hɨfɨ ndanɨhü nɨnɨ-moatükunɨyo tüküfemboayo ranahambo hɨmbondeihɨ yɨhɨmbombo hɨmboarɨ wuwurɨndearümboe. Nɨmboe sapo muŋguambo ŋgɨnɨndɨ moatükunɨ sünambe ranai-amboanɨ fɨfɨmɨndɨmboembohünda. ");
INSERT INTO agg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Rananɨmbo nindou ai hoeindɨhoranɨ Nindou Hondü ranai mburɨŋgai wamɨ nɨmandü haya ahandɨ hɨmboamupuimbo-randeimbɨ ŋgɨnɨndɨ ranɨ kapeihü kudümbui. ");
INSERT INTO agg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ranɨ-moatükunɨ ranai hapoadümbo tüküfembo mbɨsɨ haya tükündɨfeyoanɨ botɨndahi nɨmboeimbo mbɨro botɨndɨhindɨ sapo God ai sɨheimbo aboedambo-fembo ra ndeara tüküfembo yaŋgɨrane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sisas ai kafoefe hoafɨ mamɨ hoafɨyupurühɨ yahuya, “Se süfurɨ nɨmɨnd-ane asu amurɨ nɨmɨ ranamboanɨ hoeindundɨ. ");
INSERT INTO agg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sapo se hoeirundanɨ nɨmɨ ranai hoaihoai sɨmborɨ bokarɨ arandɨ ana, se fɨfɨrɨndundɨ ai ndeara hoembo yahomboane. ");
INSERT INTO agg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mamɨ yahuraiane sapo se hoeindundanɨ ranɨ-moatükunɨ tükefeyo ra se fɨfɨrndundɨ God ŋgɨnɨndɨ hɨfandarandɨ ra ndeara tüküfembo yaŋgɨr-ane. ");
INSERT INTO agg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ro sɨhamumbo anɨhondümboanahɨ hoafayahapurɨ, ŋga se fɨfɨrɨndundɨ nindou hapondanɨ anɨmboei ranai yɨfɨkoate-yeiambe anɨmbo ranɨ-moatükunɨ ra tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Hɨfɨ sünü ana awarɨndɨhoemboe, ŋga wandɨ hoafɨ ana ŋgɨrɨ awarɨndɨhoeyo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Sisas ai hoafɨyupurühɨ yahuya, “Se hɨbadümbo! Se muŋguambo sesesɨndɨmo asu bia ndɨmɨndɨmo houmbo mamɨkarɨ hohoanɨmondɨmo asu findɨ moatükunɨ ranɨmbo afɨndɨ hohoanɨmondɨmo ndümboemo. Ranɨ-moatükunɨ ranai sɨhamumbo andürambe nɨnɨhondɨ pɨrayo nou yahurai anɨmbo randeapurɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Se muŋguambo si hɨbadü nɨŋgomombo Godɨmbo dɨdɨbafɨndafu ndundɨ. Tɨŋɨrɨfo tükefeyo ra ŋgɨnɨndɨ nɨŋgo hombohünda asu Nindou Hondündɨ hɨmboarühɨ tüküfembohünda ranɨmbo dɨdɨbafɨndafundɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sisas ai muŋguambo si Godɨndɨ worɨ ranambe nindou yamundeandürɨ hu asu nɨmbokoanɨ hafu Orif Hɨfɨ Wafuambe apu marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Asu nindou ranai siambe hondü Sisasɨndɨ hoafɨ hɨmborɨmbohünda Godɨndɨ worɨna hei marɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bret yisɨkoate seseɨmbo si Pasofa sei-arɨhündɨ ranai tüküfembo yaŋgɨrɨmayo. ");
INSERT INTO agg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ranɨyo Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨyomo asu ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨyomo ai nɨmorehɨ nindowenihɨmbo yɨhɨmboyomondühɨ Sisasɨmbo hɨfokoefimbo nafɨ kokomarundɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ranɨyo Sudas Iskariot Sisasɨmbo süŋgrurü-rundeimbɨndambo mamɨ ahandɨ fiambe Satan ai mafarɨfiyu. ");
INSERT INTO agg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ranɨyo Sudas ai Godɨmbo sesɨ sɨhou-rundeimbɨ asu prisman bɨdɨfɨrɨ Godɨndɨ worɨ hɨfandɨmarundɨ ahamumbo sowanambo ai nünüŋgundirɨ Sisasɨmbo ahamundɨ warɨhümandirɨ ranɨmbo fɨfɨrɨfembohünda mahu. ");
INSERT INTO agg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ranɨyomo asu nindou ranai hɨhɨfɨ-hɨhɨfɨyomondühɨ Sudasɨmbo kakɨ masabudo. ");
INSERT INTO agg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ai hohoanɨmo mamɨ-süŋguru mburumbo hɨfanda humbo nindou afɨndɨ ranai Sisas-dɨbo nɨmarɨkoate-yei-ambe ahamundɨ warɨhüfimbo yahu hayamboyu. ");
INSERT INTO agg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bret yisɨ-koate sesɨmbo si God ai Israerɨmbo aboedambo-mareandürɨ ra tüküfeyoambe anɨmbo sipsip nɨmorɨ ra hɨfokoefemboane. ");
INSERT INTO agg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sisas ai Pita weimbo Sonɨmbo hoafɨyupɨrühɨ yahuya, “Ŋgafanɨ sesɨ sɨhefɨmbo sɨndɨndɨneamunɨ adükarɨ si ranɨhü sesesɨmbohünda,” mehupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Asu sɨmborɨ düdurɨnerühɨ safanɨya, “Nahanɨhümboyafɨ yɨhoehɨmbo sesɨ ra sɨndɨfembo hoafayafɨmunɨ rana?” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Asu sɨmborɨ hoafɨyupɨrühɨ yahuya, “Ŋgoafɨ adükarɨ ranɨhü ŋgafandühɨ nindou mamɨ ai hoe hɨpɨrambe fuindamündü haya ŋguanɨ hoeindɨnerɨmboyafanɨ. Ŋga ahambo anɨmbo süŋgundɨnɨrɨ nɨnɨ worambeahɨyo karefuendɨ ra. ");
INSERT INTO agg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Rananɨmbo worɨ aharambürɨ ranahambo hoafɨndafɨnandowohüya, ‘Yamunde-randeimbɨ ai sɨhambo hoafɨyuhɨ yahuya, ‘Ro wambo süŋgurundɨrɨ-rundeimbɨ babɨdɨ worɨ nahanambe sesesɨmandefɨ God ai Israerɨmbo aboedambo-mareandürɨ si ra?’ mehuamboane,’ mbɨsafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Asu ai sɨhafanɨmbo sesɨ napo kurɨfe nɨmarɨ sesɨmbo fondɨ afɨndɨ burɨyoweimbɨ nɨmoamonɨndɨ worɨ nafuindüpürɨmbui. Se ranɨhü sesɨ napo sɨndɨndɨneandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ranɨ-yafanɨ Pita weimbo Son ai hafanɨ hoeirɨ-neandane asu muŋguambo moatükunɨ ra Sisas hoafɨmayu süŋgu tükümefeyo. Ranɨ-yafanɨ asu ranɨhü sesɨ ra sɨndɨmarɨneandɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sesɨ sesɨmbo yahomo houmbo Sisas ai ahambo süŋgrurü-rundeimbɨ babɨdɨmbo sesɨ fondühɨ mamarɨmo. ");
INSERT INTO agg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ai ahamumbo hoafɨyupurühɨ yahuya, “Ro afɨndɨ hamɨndɨ yifirayahɨ se-babɨdɨ sesesɨmbo God ai Israerɨmbo aboedambo-mareandürɨ si, ŋga asu süŋgunambo ana ro asübusɨ afɨndɨ ndahamɨndɨmboyahɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ro asükai ŋgɨrɨ sesɨ ndahurai dagadɨhɨ, ŋga ŋgombo ranɨ-moatükunɨ ra God hɨfandarandɨ ranambe tükündɨfemboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ranɨyu Sisas ai kap hoe semündü Godɨmbo hɨhɨfɨrürɨ mbura yahuya, “Kap hoe nda sowandümo houmbo sɨhamundɨhoarɨ sɨmɨndɨmo. ");
INSERT INTO agg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Asu ro wain boboe ra asükai sɨmɨndɨkoate ŋgambo God ŋgɨnɨndɨ hɨfandarandɨ ra tükündɨfemboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Asu asükaiyu bret semündü Godɨmbo hɨhɨfɨrürɨ mbura hɨfɨtɨre ahambo süŋgrurü-rundeimbɨmbo yimbureapurühɨ yahuya, “Nda wandɨ saf-ane asahapurɨ. Ŋga se wambo hohoanɨmombohünda randu ndundɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mare yahurai sesɨ sowasümo mburu Sisas ai kap semündü hayambo hoafɨyuhɨ yahuya, “Kap nda wandɨ horɨ sɨhamumbohündambo karefoendɨ rananɨmbo sɨmborɨ hoafɨ femɨndɨ asɨhefeyo ra ŋgɨnɨndamɨndɨmboe. ");
INSERT INTO agg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sɨhamundɨ mbusümo nindou mamɨ ai wambo hürütümbɨ nindou-yafe warɨhündeandɨrɨmbui. Ŋga ahandɨ watɨŋarɨ ra wandɨ dɨbore sesɨ nandɨfe fondɨwamɨ anaŋgo. ");
INSERT INTO agg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nɨne-moatükunɨ God ai Nindou Hondü ahambo refimbo hohoanɨmomayu ra yahurai tükündɨfemboe. Ŋga Nindou Hondümbo hürütümbɨ nindou-yomondɨ warüharirɨ ranai hɨpoanɨmbembou-ani,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ranɨyomo asu süŋgrurü-rundeimbɨ ai ahamundɨhoarɨ ranɨ-moatükunɨ ra dɨdɨ ramande yahomo houmbo sɨmborɨndüwurɨmemo. ");
INSERT INTO agg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sisasɨmbo süŋgrurü-rundeimbɨ ai düdi adükarayu yahomo houmbo sɨmborɨ hoafɨyomondühɨ mamarɨmo. ");
INSERT INTO agg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sisas ai hoafɨyupurühɨ yahuya, “Ndɨfoyei adükarɨ bogorɨ ai ana ndüreimbɨyomo houmboanemo asu nɨmorehɨ nindowenihɨ ra hɨfandɨrundürɨ arundɨ. Ŋga nindou ranaheimbo hɨfandɨrundürɨ arundɨ ranahamumbo aboedɨ farɨhou-rundeimb-anemo sei arɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Se yahurai randafumboemo, ŋga adükarɨ hamɨndayu sɨhamundɨ mbusümo ra ai hoarɨfɨ nindou nahurai-mbiyuwamboane. Asu horombofi hu ratüpurɨyu-randeimbɨ ai fehefembo ratüpurɨyu-randeimbɨ nahurai-mbiyuwamboane. ");
INSERT INTO agg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Düdi adükarɨ hamɨndayua? Sesesɨ fondühɨ amaruyu asu sesɨ yimbuareandɨyu? Se raru hohoanɨmoyomondühɨya sesesɨ fondühɨ amaruyu ai adükarɨ hamɨndayu. Ŋga roana sɨhamundɨ mbusümo fehefembo ratüpurɨ ratüpurɨya rɨhandeimbɨ nahurai-anahɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Se wambo tɨŋɨrɨfo tükümefeyo ra moai hɨnɨŋgɨrundɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ro sɨhamumbo hɨfandɨmbo ŋgɨnɨndɨ asahapurɨ wandɨ Ape wambo hɨfandɨmbo ŋgɨnɨndɨ masendɨrɨ nou. ");
INSERT INTO agg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Se ro ŋgɨnɨndɨ hɨfandarɨhandɨ ranambe wandɨ sesɨ fondɨwamɨ sesɨ dowadümo hoe ndɨmɨndɨmondümboemo. Asu se bogorɨndɨ nɨmarɨ fondɨwamɨ nɨmandümombo Isɨraerɨ-yafe sɨrɨ 12 ra hɨbadüboemo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon, Saimon, Satan ai sɨhafɨ anɨhondümbofe ra refe hoeifembo hoafɨyumboani sapo nɨmorehɨ mbanɨ hɨrɨyeihɨ badinɨ pirɨhindühɨ safɨ hɨnɨŋgarɨhindɨ nou. ");
INSERT INTO agg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ŋga ro Godɨmbo dɨdɨbafɨmeheandɨ sɨhafɨ anɨhondümbofe ra hɨnɨŋgɨndowamboyafɨ sahehea. Rananɨmbo se asükai hɨhɨrɨndafo wambo sowanambo dɨdɨfɨhümbo apodoho-apodohoyomondeimbɨ ranahamumbo fandɨhawapura ŋgɨnɨndɨmbeyomo-ndamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ŋga Pita ai Sisasɨmbo hoafɨyunduwohü yahuya, “Adükarɨ, ro ndearambo nafɨrɨhamɨndɨmboanahɨ se-dɨbo karabusambe hombo asu yɨfɨmbo amboanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Sisas ai hoafɨyuhɨ yahuya, “Pita, hapo nɨmbɨkoanɨ kakaro ai hoafɨkoate-yuambe anɨmbo se wamboya ŋgɨmɨmbo moai fɨfɨrɨhinɨ mbɨsafɨndɨrɨmboyafɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sisas ai ahambo süŋgrurü-rundeimbɨ ranahamumbo hoafɨyupurühɨ yahuya, “Horombo ro sɨhamumbo koarɨheheapurühɨ sahɨya, ‘Se kakɨ sandɨferambo arüyo asu napo sandɨferambo arüyo, asu su yirambe kɨkɨfoefemboane semɨndɨpoanɨ’ masahɨ ranɨ-sɨmboanɨ se bɨdɨfɨrɨ moatükunɨ mbonɨmborundümondai?” Ai hoafɨyomondühɨ yahomoya, “Wanɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ahamumbo hoafɨyupurühɨ yahuya, “Haponda nindou düdi se kakɨ sandɨferambo arü, düdi se pisao yihɨmɨndɨ hamɨndɨ ra semɨndɨkoate-ayu ana, ahandɨ ŋgɨsɨharɨ hoearɨ ra nindou ŋgorümbo sagadowohümbo asu ranɨ fihɨndɨ kakɨ ndemündü haya pemɨmbiyu-wamboane. ");
INSERT INTO agg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Godɨndɨ bukambe hoafɨyowohü yahoya, ‘Ahambo moaruwai hohoanɨmoyu-randeimbɨ nindou nahurai randɨhorɨmboyei,’ meho ranana wamboyo, ŋga ranane hapondanambe tükefeyo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ahandɨ süŋgrurü-rundeimbɨ ai hoafɨyomondühɨ yahomoya, “Adükarɨ! Hoeiro, pisao yihɨmɨndɨ hamɨndɨ yimbu nda,” mehomo. Ai hoafɨyupurühɨ yahupurɨya, “Ra ndearane,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sisas ai adükarɨ ŋgoafɨ ra hɨnɨŋgɨre hayambo Orif Wafuana mahafu sapo muŋguambo si refi marandɨ nou. Ranɨyomo asu ahambo süŋgrurü-rundeimbɨ ai ahandɨ süŋgu mahafomo. ");
INSERT INTO agg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ai hafomo nɨmarɨmboyohü tüküfihɨ hoafɨyupurühɨ yahupurɨya, “Nɨnɨ-moatükunɨ sɨhamumbo rande hoeindeapurɨmboe ranɨmbo-hünda se Godɨmbo dɨdɨbafɨndafundanɨ sɨhamumbo ŋgɨnɨndɨ mbɨsagapur-amboane,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sapo nɨmoei pifeyoanɨ ho pɨrayo ranɨ sɨmogodühɨ safɨ Sisas ai hu yirɨ yimbu pusɨre nɨmarümbo Godɨmbo dɨdɨbafɨmefiyu. ");
INSERT INTO agg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ape, se yifirayafɨ ana, wambo asübusümbɨ moatükunɨ tüküfemboayo ra raguanambo-ndowandɨ. Ŋga se nɨne yifirayafɨ ranɨ süŋgundowandɨ, ŋga ro yifirayahɨ ranɨ süŋgufepoanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ranɨyo asu sünambeahɨndɨ nendɨ ai ahambo ŋgɨnemündümbohünda tükümefiyu. ");
INSERT INTO agg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sisas ai asübusɨ afɨndɨ hamɨndɨ semɨndɨmboayu ranahambo hamɨndɨ tütüŋgɨrɨhoei hayambo Godɨmbo dɨdɨbafɨmayu hoaŋgu. Ranɨyo asu ahandɨ yikunɨmɨhoe ranai horɨ nahurai pɨmendo hoaŋgo. ");
INSERT INTO agg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sisas ai Godɨmbo dɨdɨbafɨyu moendɨre hayambo ahambo süŋgururü-rundeimbɨmbo sowana huane asu mapomo sapo afɨndɨ hohoanɨmoyomondühɨ wambo. ");
INSERT INTO agg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sisas ai hoafɨyupurühɨ yahuya, “Nɨmboe se hapoana apusayomoa? Ŋga botɨyafu Godɨmbo dɨdɨbafɨndafundɨ nɨnɨ-moatükunɨ rande hoeindeapuranɨ ŋgɨnepurɨmɨndɨmbohünda,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sisas ai wataporɨyuhü nüŋguambe awai nendɨ afɨndɨ ranai masɨfo. Sapo Sudas Sisasɨmbo süŋgrurü-rundeimbɨ ambeahɨndɨ-mayu ranai sepurɨmündü haya mahafomo. Ranɨyu asu Sudas ai Sisasɨmbo wakɨkɨhɨmbohünda ahandɨ fikɨmɨ mahu. ");
INSERT INTO agg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Asu Sisas ai hoafɨyundühɨ yahuya, “Sudas, se wakɨkɨhɨmbo asafɨ ra Nindou Hondümbo hürütümbɨ nindou-yafe warɨhüfimbo safomboyafɨ?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sisasɨmbo süŋgrurü-rundeimbɨ ai hoeirundane ahambo kɨkɨhimɨndɨmbo yaŋgɨrɨmemondamboemo hoafɨyomondühɨ yahomoya, “Adükarɨ, ro yɨhoefɨ pisao yihɨmɨndɨ safɨ ranambo hɨtɨhupɨrɨmbo?” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ranɨyo asu aihündɨ mamɨ ai pisao ndarɨhendühɨndamboyu Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨ hondündɨ ratüpurɨyu-randeimbɨmbo warɨhondü hɨmbohoearɨ mafoafoareando. ");
INSERT INTO agg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sisas ai hoafɨyuhɨ yahuya, “Yowan! Ndahurai refepoanɨ!” mehu. Ranɨyo ahandɨ hɨmbohoearɨ ra warɨ pamareanda asükai koadürü koadürümefeyo. ");
INSERT INTO agg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nindou sapo Sisasɨmbo kɨkɨhimɨndɨmbo masɨfomo ra Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨyomo, Godɨndɨ worɨ hɨfandɨru-rundeimbɨ prisman bogorɨyomo asu Suda-yafe boboagorɨ ranɨyomo. Sisas ai hoafɨyupurühɨ yahuya, “Se pisao yihɨmɨndɨ asu nɨmɨharɨ fufuründümo masɨfomo ra hümbuhünɨ nindoumbo kɨkɨhemündɨmbo nahuraiyomo. ");
INSERT INTO agg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ro sebabɨdɨmbo muŋguambo si Godɨndɨ worambe nɨmarɨ marɨhandɨ ra moai ranɨhü kɨkɨhɨründümondɨrɨ. Ŋga haponda sɨhamundɨ siane nɨmboe nɨmbɨ ai adükarɨ tüküfihɨ simbo ŋgasündeamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sisasɨmbo kɨkɨhɨründümo houmbo Godɨmbo sesɨ sɨhai-randeimbɨ bogorɨ hondü ahandɨ worɨnambo sowaründümo mahɨfomo. Ranɨyo asu Pita ai süŋgumarapurɨ hüfu. ");
INSERT INTO agg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Asu ai hai worɨ gabusümo püpiru houmbo mamarɨmondamboyu ranɨhü ai-babɨdɨmbo mamarɨmo. ");
INSERT INTO agg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nɨmorehɨ mamɨ ratüpurɨyo-randeimbɨ ai hai sihɨ hɨmboyowane Pita ai mamaruwamboyo ndorerɨ türüfoarerɨ mbura hoafɨyowohü yahoya, “Nindou ndanana sapo Sisas-dɨbo hu marandani,” meho. ");
INSERT INTO agg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pita ai hoafɨyuhɨ yahuya, “Nɨmorehɨ se hoafayafɨ ranana moai akɨdou-amboanɨ ro fɨfɨrɨhinɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Asu ranɨ waŋgabeahɨ safɨ nindou ŋgorü ai hoeirirɨ hayambo hoafɨyundühɨ yahuya, “Ŋgorü ana sapo seanafɨsɨ.” Ŋga Pita ai hoafɨyuhɨ yahuya, “Wandafɨ, roana wananahɨ ana,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ran-ahandambohündɨ gedühɨ safɨ homboyoane asükai nindou ŋgorü ai hüti hoafɨmarürɨ, “Sapo nindou ndanana Sisas-dɨborɨhɨndani nɨmboe ai-amboanɨ Garirihünd-ani.” ");
INSERT INTO agg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Asu Pita ai hoafɨyuhɨya, “Wandafɨ, roana moai fɨfɨrɨheandɨ se wataporɨmbo-arandɨ ranahambo!” mehu. Ranɨyo asu hoafɨyuambe kakaro ai hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ranɨyo asu Adükarɨ ai hɨhɨrɨfi Pitambo türümafoarirɨ. Asu Pita ai hohoanɨmomayu Adükarɨ ai hoafɨmeindo ranahambo. Hapo nɨmbokoanɨ kakaro ai hoafɨkoate-yuambe anɨmbo se ŋgɨmɨmbo wambo moai fɨfɨrɨhinɨ mbɨsafɨndɨrɨmboyafɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ranɨyu asu Pita ai weindanɨ tüküfi hu afɨndɨ hamɨndɨ aranɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nindou Sisasɨmbo hɨfandɨmarurɨ ranai tɨrɨfoefe hoafɨyomondühɨ bubumarurɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ai ahandɨ hɨmboarɨ hoearɨnambo gabudɨfoarüwurɨ houmbo hoafɨyomondowohü yahomoya, “Se Godɨndɨ hoafɨ hoafɨyafɨ-randeimbayafɨ ana, hoafɨyafɨmunɨ düdi sɨhambo harɨmayunɨnɨ rana!” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ai Sisasɨmbo moaruwai hoafɨyomondo marundɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Simayowamboyo hɨfandɨ-rundeimbɨ ai mafandundɨ. Asu Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨyomo asu ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨyomo ai-amboa ai-babɨdɨ fandu mburumbo Sisasɨmbo sowarɨndümo ahamundɨ bogorɨ hondü kot ranɨnambo mahɨfomo. ");
INSERT INTO agg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ai hoafɨyomondühɨ yahomoya, “Se Krais-ayafɨ ana, hoafɨndafɨmunɨ,” mehomo. Sisas ai hoafɨyupurühɨ yahuya, “Ro hoafehapurɨ amboanɨ ŋgɨrɨ se wambo anɨhondümbo-ndundɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Asu sɨmborɨ sɨhamumbo ro düdueheapurɨ amboanɨ ŋgɨrɨ hoafɨndɨmondɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Haponda ndanɨhü pɨyo hayambo süŋgunambo aho ranana, Nindou Hondü ai God Ŋgɨnɨndeimbɨ ahandɨ warɨhondü warɨhü nɨmandümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ai muŋguambo hoafɨyomondühɨ yahomoya, “Ranayo ana, se Godɨndɨ nɨmorɨyafɨ?” Sisas ai hoafɨyupurühɨ yahuya, “Se sɨhamundɨhoarɨ hoafayomo rasɨ, ŋga rananahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ai hoafɨyomondühɨ yahomoya, “Refe ana, nɨmboe nindou ŋgorümbo ahambo hoefimbo hoafayefa? Ŋga ndearambo sɨhefɨ hɨmboambenambo hoafɨmayuambo hɨmborɨyefɨ-mboanefɨsɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Muŋguambo ranɨ boboagorɨ-memo ranai Sisasɨmbo sowaründümo Pairat sowanambo mahɨfomo. ");
INSERT INTO agg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ai ahambo papɨ-hoafɨrɨrurühɨ yahomoya, “Nindou nda sɨhefɨ nendambo hohoanɨmo mamɨkarɨmarandüra kɨkɨhɨmarɨhurɨmɨndefɨ. Ai hoafɨyuhɨ yahuya, ‘Yowanɨ Sisarɨmbo kakɨ saimbopoanɨ,’ yahu asu ahandɨ fimboya, ‘Krais, adükarɨ bogor-anahɨ,’ mehu,” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pairat ai Sisasɨmbo düdurirühɨ yahuya, “Se ra Suda-yafe adükarɨ bogorɨyafɨ?” mehuamboyu. Sisas ai sɨmborɨ hoafɨyuhɨ yahuya, “Sɨhafɨhoarɨ hoafayafɨsɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pairat ai Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨyomo asu awai nendɨ afɨndɨ meŋgoro ranaheimbo hoafɨyuhɨ yahundürɨya, “Ro nindou nda moai nɨnɨ-moatükunɨ moaruwai rareanda hoafɨ hɨmborɨyahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ai asükaiyei puküna hoafɨyeihɨ seiya, “Sisas ai hoahoaŋgu wakɨreandühɨ nindou yamundɨreandühɨ hohoanɨmo botɨmareandürɨ. Ai Gariri hɨfɨhü piyu haya sünümbo Sudia hɨfɨhü tükümefiyu,” masei. ");
INSERT INTO agg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pairat ai hoafɨ ra hɨmborɨyu haya düdüfihɨ yahuya, “Garirihündɨyu nindou nda?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Herot ai mamɨ profens hɨfɨ ra hɨfandɨmarandɨ ranɨ hoarehɨyu Sisas ai manüŋgu. Ranɨmboyu asu Pairat ai Sisasɨmbo Herot sowana koamarɨheirambo mahu sapo Herot ai ranɨ-sɨmboanɨ Serusaremɨhü mamaru wambo. ");
INSERT INTO agg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot ai Sisas hoeiriranɨ mayowambo hɨhɨfɨ-hɨhɨfɨmayu, nɨmboe sapo ai moanɨ hoafɨ yaŋgɨrɨ hɨmborɨyu hayambo asu hoeindɨhinɨ mehu. Ai sapo yare hohoanɨmoyuhü Sisas ai hepünɨfeimbɨ moatükunɨ randeanda hoeindɨhea yahuhayambo. ");
INSERT INTO agg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herot ai Sisasɨmbo düdu-düdumarürɨ, ŋga asu moai akɨdou-amboanɨ nɨnɨ hoafɨ hoafɨyu, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨ asu ahɨnümbɨ hohoanɨmo yamundu-rundeimbɨ akɨmɨ manɨŋgomo ranai tɨkaruhoumbo Sisasɨmbo papɨ-hoafɨmarurɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herot ai ahandɨ ami babɨdɨ Sisasɨmbo tɨrɨfoefe hoafɨyomo mburumbo asu bogorɨ-yomondɨ hoearɨ aboedɨ safɨ yihuruwurɨ mburumbo asükai Pairat sowana koamarɨhawurɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Horombo ana, Pairat ai Herotɨ-dɨbo sɨmborɨ ŋgɨnɨndürɨmefanɨyosɨ, ŋga rasɨmboanɨ ai aboedɨ-aboedɨmefɨneandɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pairat ai Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨ asu Sudayei bogorɨ muŋguambo nindou amurɨ ranɨyei aheimbo gugurɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ai hoafɨyundürühɨ yahuya, “Nindou wambo sowana sahorɨmɨndei masɨnei ndanahambo hoafɨyeihɨ seiya, ‘Moaruwai hohoanɨmoyu randeimbani’ masei. Ro ahambo sɨhei hɨmboarühɨ düdumarɨhinɨ, ŋga ro moai se ahambo papɨ-hoafɨmarɨhorɨ ra nɨnɨ-moatükunɨ moaruwai rareanda hoafɨ hɨmborɨyahɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Asu Herot ai hoeiriranɨ nɨnɨ-moatükunɨ moai rareandɨ, ŋga ranɨmboyu hɨhɨrirɨ sɨhefɨmbo sowana koamarɨheirambo masünu. Ŋga asu ai nɨnɨ-moatükunɨ moaruwai rareandai anɨmbo ranɨmbo yɨfɨmanda? ");
INSERT INTO agg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ro ahambo tɨŋɨrɨfo ndahando mbundɨhambo anɨmbo asu moanɨ aboedɨ koandɨhehina ŋgumbui,” mehu ");
INSERT INTO agg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Muŋguambo nindou ranai fandɨhi puküna hoafɨyeihɨ seiya, “Nindou nda ndahorɨmɨndei ŋgei hɨfokoandɨhorɨ. Ŋga rananɨmbo Barabasɨmbo aboedambo-fimboani!” masei. ");
INSERT INTO agg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas ra ai adükarɨ ŋgoafɨhü gafman babɨdɨ yifiarɨyu nindou hɨfokoare hayambo karabusɨmefiyu-ani. ");
INSERT INTO agg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pairat ai Sisasɨmbo hɨnɨŋgɨfiyuwanɨ aboedambo homboani mehu ranɨyu asu awai nendɨ afɨndɨ ranaheimbo asükai hoafɨmeyundürɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ai asükai puküna hoafɨ karɨhehindühɨ seiya, “Nɨmɨ keimbɨ karɨhendeimbɨfihɨ pandɨwurɨ! Nɨmɨ keimbɨ karɨhendeimbɨfihɨ pandɨwurɨ,” raranɨmayei. ");
INSERT INTO agg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ai asükaiyu ŋgɨmɨmbo düdureandürühɨ yahuya, “Nɨne-moatükunɨ ramareandɨ? Ahambo hɨfokoefimbo asei ra ro hoeirɨhina moai nɨnɨ moatükunɨ akɨdou-amboanɨ rareandanɨ hoafɨ hɨmborɨyahɨ. Ŋga moanɨ akɨdou yaŋgɨrɨ tɨŋɨrɨfo ndahando mbundɨha aboedambo koandɨhehina mbɨhu,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ŋga ai moanɨ hoafɨ puküna karɨhehindühɨ hütihoafɨyeihɨ seiya, “Sisas ai yɨfɨmbiyu-wamboane, yɨfɨmbiyu-wamboane,” mayei. Ai hoafɨmayei habodei ra moanɨ Pairatɨndɨ hoafɨ ŋgasünde hayambo ahei nɨmoamo hamɨndɨmayondürɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ranɨyu asu Pairat ai Sisasɨmbo ahei hohoanɨmo süŋgumareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ranɨyu nindou mamɨ Barabas gafman babɨdɨmbo yifiarɨyu nindou hɨfokoare hayambo karabusambe mamaru ahambo aboedambo koamarɨherü. Ranɨyu asu ai Suda nɨne refembo yifirɨmayei süŋgu Sisasɨmbo ami-yomondɨ warɨhümarirɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sisasɨmbo sowaründümo homondane Saimon Sairinihündɨ ai nafɨnɨ masüfu ŋgoafɨnambo hɨfombo yahuhayambo. Ranɨyomo asu Sisasɨndɨ nɨmɨ keimbɨ karɨhendeimbɨ ra sowandɨfɨ hawa Sisasɨndɨ süŋgu hüfɨ yahomo houmbo hüti-hütimarurɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Asu awai nendɨ afɨndɨ ranai Sisasɨndɨ süŋgu hüsihɨ, nɨmorehɨ bɨdɨfɨrɨ ranambeahɨ mahüsi ranai Sisasɨmbo hohoanɨmoyeihɨ aranɨnambo sahorɨmɨndei mahüsi. ");
INSERT INTO agg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ŋga asu Sisas ai hɨhɨrɨfi hoafɨyundürühɨ yahuya, “Serusaremɨhündɨ nɨmorehɨ se yowanɨ wambo aranɨnambo-yondɨrɨpoanɨ. Ŋga sɨhei fimbo asu sɨhei nɨmoakɨdɨboumbo anɨmbo aranɨnambo-ndɨhündürɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Awi mamɨ si tükündɨfemboe ranɨ-sɨmboanɨ nindou ranai hoafɨndeihɨya, ‘Nɨmorehɨ nɨmorɨ wakemɨndɨkoate-ayei asu nɨmorɨ tɨtɨhükoate-ayei se hɨhɨfɨ-hɨhɨfɨndei. Sapo aheimbo tɨŋɨrɨfo ra ŋgɨrɨ tükündɨfeyo,’ mbɨseimboyei ");
INSERT INTO agg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ranɨ-sɨmboanɨ anɨmbo nindou ai nɨmoei wafumbo hoafɨndeihɨya, ‘Wamɨnɨ pɨyafɨmunɨ,’ mbɨsei. Asu asükai hɨfɨ wafumboya, ‘Gabudɨfoarɨwamunɨ,’ mbɨseimboyei! ");
INSERT INTO agg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hapondanɨ ro nɨmɨ yaŋgɨrɨ nahurai-anahɨ, ŋga wambo rawarɨhindɨrɨ. Ŋga süŋgunambo moaruwai tükündefeyoanɨ se nɨmɨ yaparɨ nahurai-ayei sɨheimbo nüŋgumandɨfendüra?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nindou yimbu moaruwai hohoanɨmoyafandeimbɨ amboanɨ Sisas dɨbombo sowapündümo mahɨfomo ahafanɨmbo hɨfokoefepɨrɨmbohünda. ");
INSERT INTO agg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ai hei nɨmoei wafu mbɨrɨhapɨrɨ sɨsamɨ sei arɨhündɨ ranɨhü Sisas asu hümbuhünɨyafanɨ-rɨnandeimbɨ nindou yimbu ahamumbo tɨkorüpundɨmo pamarupurɨ ra Sisas ai mbusümoyuwane asu ŋgorü ai warɨhondünɨyu asu ŋgorü ai kadüdanɨyu yafɨne pamarupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Sisas ai hoafɨyuhɨya, “Ape, amboawi mbɨsafɨ nɨmboe ai moai fɨfɨrundɨ nɨne-moatükunɨ rawarundɨ ranahambo,” mehu. Asu ami ai satu piraimemo dɨdai Sisasɨndɨ-mayo hoearɨ ra mandemündü yahomo houmbo. ");
INSERT INTO agg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nindou afɨndɨ ranai nɨboadei hɨmboanambo hɨfandɨhündɨ, ŋga boboagorɨ nindou ai Sisasɨmbo tɨrɨfoarüwurɨ hoafɨyomondühɨ yahomoya, “Nindou bɨdɨfɨrambo aboedambo-reandürɨ marandɨ. Se Godɨndɨ nɨmorɨ Krais-ayafɨ ana, yaro sɨhafɨhoarɨ aboedamboyafo,” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Asu ami amboanɨ tɨrɨfoarɨwurühɨ homo hühütimbü moatükunɨ wain hoe finiga masabudo. ");
INSERT INTO agg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ai hoafɨyomondowohü yahomondoya, “Se Suda-yafe bogorayafɨ ana, yaro sɨhafɨhoarɨ aboedamboyafosɨ!” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nɨmɨ keimbɨ karɨhendeimbɨ nɨmoamo ndaru sürü pamarundɨ: NDA SUDAYAFE ADÜKARƗ BOGORANI. ");
INSERT INTO agg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nindou hümbuhünɨyafanɨ-rɨnandeimbɨ nɨmɨ keimbɨ karɨhendeimbɨ fihɨ mapenɨmbafanɨ ŋgorü ranai Sisasɨmbo tɨrɨfoarirühɨ puküna hoafɨyuhɨ yahuya “Se ra Kraisɨyafɨ? Ranayafɨ ana, yaro sɨhafɨhoarɨ aboedamboyafosɨ asu yɨhoehɨmbo amboanɨ aboedambo-rowamunɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ŋga asu ŋgorü hümbuhünɨyu-randeimbɨ gorügoanɨnɨ mapenüŋgu ranai afoai yahu hoafɨyundowohü yahundoya, “Se Godɨmbo yɨhɨmboyafai? Ŋga se tɨŋɨrɨfo asowandɨfɨ nahuraiane ai-amboanɨ asemündu. ");
INSERT INTO agg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sɨhɨrɨ tɨŋɨrɨfo asahoamɨndehɨ ranana sapo nɨnɨ-moatükunɨ sɨhɨrɨ ramarɨhoandɨ ranɨ-süŋgumboane. Ŋga nindou ndanana moai nɨnɨ-moatükunɨ moaruwai rareandɨ.” ");
INSERT INTO agg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Asu ai hoafɨyuhɨ yahuya, “Sisas, se sɨhafɨ ŋgɨnɨndɨ hɨfandarandambe tüküyafo amarɨfɨ ana, se wambo hohoanɨmondafɨndɨrɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Sisas ai hoafɨyundowohü yahuya, “Ro anɨhondümboanahɨ haponda hoafehanɨnɨ se ro-dɨbo ŋgoafɨ aboedɨ ranɨhü nɨmandɨmboyafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sapo hüfɨhamɨndɨkoate-yowohü wambo nɨmbɨ ranai hüfünɨmbo peyo haya gabudɨfoare hombo nɨmbambe tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Refeyoambe asu hoearɨ Godɨndɨ worambe kümarundɨ ranai mbusümondühɨ yimbu bumareandɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sisas ai pukünambo hamɨndɨ hoafɨ karɨhoeihü “Ape, wandɨ yifiafɨ sɨhafɨ warɨharɨheandɨ,” yahu mburambo asu yɨfɨmayu. ");
INSERT INTO agg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Asu ami-yomondɨ bogorɨ manüŋgu ranai nɨne-moatükunɨ tükümefeyo ra hoeireanda mayoa asu Godɨmbo aboed-ani yahu hoafɨyuhɨya, “Anɨhondü-ane, nindou ndanana moai nɨnɨ-moatükunɨ moaruwai yare randɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nindou afɨndɨ wakɨre meŋgoro ranai hoeirɨhinda mayowamboyei afɨndɨ hohoanɨmoyeihɨ ahei ŋgusüfohü purükɨ-purükɨ kameihɨ ŋgoafɨna mahei. ");
INSERT INTO agg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ŋga Sisasɨndɨ fikɨmɨnɨndɨyei asu nɨmorehɨ Garirihündɨ ahambo süŋgumarɨhorɨ ranai foarɨhehi nɨboadeimbo hɨmboanambo wamarɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nindou mamɨ anɨhondümbo-reandeimbɨ aboedɨ hamɨndɨ manüŋgu ahandɨ ndürɨ Sosep, aiana Suda-yafe kansɨr ambeahɨndɨyu. Ŋga asu ai moai yifirɨyu bɨdɨfɨrɨ boboagorɨ-yomondɨ hohoanɨmo Sisasɨmbo ramarundɨ ranahambo. Aiana Suda-yafe ŋgoafɨ Arimateahündɨyu hayamboyu asu God ŋgɨnɨndɨ hɨfandarandɨ ra tüküfemboayo ranahambo hɨfanda marandɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Sosep ai Sisasɨndɨ yɨfɨnɨmoko ra dɨbonapɨfembohünda Pairatɨmbo düdufimbo mahafu. ");
INSERT INTO agg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Asu Sosep ai Sisasɨndɨ fi-nɨmoko ra nɨmɨ keimbɨ karɨhendeimbɨ fihɨndɨ foarɨmündɨ sɨherü henüŋgu kɨfohɨ hoearɨnambo parirɨ ŋgamondɨfoarirɨ mbura sowaründümo homo nɨmoei adükarɨ nɨmaroweimbɨ hoŋgu nahurai wowondɨmaru hɨfomo ranambe masɨhawurɨ. Asu hoŋgu ranambe ra moai horombo yɨfɨ sɨhoemo rundɨ. ");
INSERT INTO agg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ai ndeara sümbo Godɨmbo hohoanɨmoyowohü moanɨ ŋgoafɨmbo nɨmarɨmboane sei hehimbo muŋguambo moatükunɨ napɨrɨhindane ranɨ-moatükunɨ ra tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nɨmorehɨ Garirihündɨ Sisas babɨdɨmbo mahüsi-mayei ranai Sosep babɨdɨmbo Sisasɨndɨ yɨfɨnɨmoko sɨhefimbo hoŋguanambo mahei sapo nüŋgurüwurɨmboemo asɨhawurɨ ra hoeifimbo. ");
INSERT INTO agg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ranɨyei asu nɨmorehɨ ranai worɨna hei aboedɨ fɨsɨŋarümbü moatükunɨ mbɨmbɨrai asu marasen ndondomarɨhindɨ. Asu Mosesɨndɨ ahɨnümbɨ hohoanɨmo hoafɨmayo süŋgu moanɨ nɨmarɨmbo si ra mamarei. ");
INSERT INTO agg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mamɨ wik ranahandambo weaŋgurühɨndɨ sihɨ siambe hondü nɨmoreh ranai Sisas samboarüwuranambo aboedɨ fɨsɨŋarümbɨ mbɨmbɨrai ndorɨhi masɨhehindɨ ra sahümündi mahei. ");
INSERT INTO agg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Asu ai hei hɨmboyeiane nɨmoei hoŋgu nafɨtambeihü güru pamarundɨ ranai paiarɨkoate tifoe hɨhɨre amoahɨre meŋgoro. ");
INSERT INTO agg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ŋga ai kefoehi hüsi hɨmboyeiane, asu Adükarɨ Sisasɨndɨ yɨfɨnɨmoko ra moai yaŋgoro. ");
INSERT INTO agg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ranɨ-moatükunɨ ranahambo afɨndɨ hohoanɨmoyeihɨ nɨmboeiane, nɨmehünou nindou yimbu ranai hoearɨ si kareandeimbɨ güdɨne hena ahei fikɨmɨ tüküyafɨne manɨmbafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Asu nɨmorehɨ ranai yɨhɨmbombo hɨfɨnɨ mbɨro pɨyei hehi manɨmboei. Asu nindou yimbu ranai hoafɨyafandühɨ safanɨya, “Nɨmboe se nindou yaŋgɨrɨ nüŋguweimbɨ ranahambo yɨfɨyeimbɨyei fondɨwamɨ kokoarɨhora? ");
INSERT INTO agg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Aiana moai ndühɨ yaŋguru, ŋga botɨmefiyu. Ai Garirihü nüŋguambe sɨheimbo hoafɨmayu ranɨmbo se hohoanɨmondei. ");
INSERT INTO agg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ai yahuya, ‘Nindou Hondü ra nindou moaruwai hohoanɨmoyomo-ndeimbɨ-yomondɨ warɨhündüwurɨmboemo nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkoemündɨ pefimbohünda. Asu yimbu sindu haya ŋgɨmɨ noufimbɨ ranɨfihɨ anɨmbo botɨndɨfimbui,’ mehu,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ranɨyo asu nɨmorehɨ-mayei ranai horombo Sisas hoafɨmayu ra hohoanɨmomayei. ");
INSERT INTO agg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Asu nɨmorehɨ-mayei ranai hoŋgu ra hɨnɨŋgɨrɨhi hehi hei ahambo süŋgrurü-rundeimbɨ 11 asu muŋguambo amurɨ ranɨyei aheimbo muŋguambo moatükunɨ wataporɨmbo-marɨhündürɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Sapo hoŋguambe muŋguambo moatükunɨ tükümefeyoa hoeirɨhi hehi Kraisɨndɨ hoafɨ sowandümo homo-rundeimbɨmbo hoafɨmayei nɨmorehɨ ranana Maria Makdarahündɨyo, Soana, Maria Semsɨndɨ hondɨyo asu bɨdɨfɨrɨ amurɨ ranɨyei. ");
INSERT INTO agg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ŋga asu ahandɨ hoafɨ sowandümo homo-rundeimbɨ ai nɨmorehɨ hoafɨmayei ranahambo tɨkarɨhi hehi hoafɨ yaŋgɨrɨ anɨhündɨ yahomo houmbo moai anɨhondümborundɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ŋga asu Pita ai pɨpɨyu hu hoŋguambe amofi hɨmboyuane, hoearɨ ahambo hɨmondɨmarɨhorɨ ranɨ yaŋgɨrɨ meŋgorowa hoeimareandɨ. Ranɨyu ai hoŋgu ra hɨnɨŋgɨre haya hüfu worambe ranɨ-moatükunɨ ranahambo afɨndɨ hohoanɨmoyuhü mamaru. ");
INSERT INTO agg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nɨmorehɨ ranai hoŋguanambo hüsi sɨmboanɨ Sisasɨndɨ süŋgrurü-rundeimbɨ yimbu ranai ŋgoafɨ mamɨ Emaus Serusaremɨhündɨ hombo 11 kiromitahüfeimbɨ hoandarɨ nafɨ mahafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ai hafandühɨ muŋgu moatükunɨ tükümefeyo ranahambo wataporɨmbo-marɨnandɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ai wataporɨmbo-rɨnɨ hafandühɨ fɨfɨrɨnandane, Sisas ai ahandɨhoarɨ tüküfi haya ai-babɨdɨmbo mahu. ");
INSERT INTO agg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mamɨ moatükunɨ gabudɨmafoareapɨra ai moai ahambo Sisas-ani safanɨ türüfoarɨnerɨ fɨfɨrɨnerɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Asu ai ahafanɨmbo düdureapɨrühɨ yahuya, “Se nɨnɨ-moatükunɨmboyo wataporɨmborɨnandühɨ ahafana?” mehuamboyafanɨ. Asu ai ŋgusümboarambe sɨsai fiyafandühɨ manɨmbafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Asu ŋgorü, ahandɨ ndürɨ Kriopas, ai sɨmborɨ hoafɨyuhɨ yahuya, “Awi Serusaremɨhü ndüfosimbo tükümehindɨ ra se yaŋgɨranafɨ nɨne moatükunɨ ranɨhü tükümefeyo ra fɨfɨrɨfekoate-ayafɨ?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Asükai Sisas ai düdureapɨrühɨ yahuya, “Nɨmboe wataporɨmbo-arɨnanda?” mehuamboyafanɨ. Asu sɨmborɨ hoafɨyafandühɨ safanɨya, “Sisas Nasaretɨhündɨ ranahamboane wataporɨmbo-arɨhorɨ. Aiana Godɨndɨ hoafɨ hoafɨyu-randeimbɨyu haya God asu muŋguambo nindouyei hɨmboahü ahandɨ hoafɨ, ratüpurɨ ra ŋgɨnɨndɨ hamɨndɨyo. ");
INSERT INTO agg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yɨhoefɨ bogorɨ nindou asu Godɨmbo sesɨ sɨhou-rundeimbɨ ai gafmanɨ-yomondɨ warɨhü hɨnɨŋgɨmarüwurɨ. Ranɨyo gafman ai hɨfokoefimboani yahomo houmbo nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkoründümo pamarüwurü. ");
INSERT INTO agg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ŋga horombo ro hohoanɨmoyefühɨya, ‘Sisas ranana God ai Israerɨhündɨ ranaheimbo aboedambo-fendürɨmbo kafoarirɨ hɨnɨŋgɨrirɨmbombai,’ masefɨ. Asu hɨfokoamarüwurɨ ra yimbu si ho hayamboyoanɨ hapo ŋgɨmɨ noufimbɨ siane. ");
INSERT INTO agg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Hapo siambe hondü nɨmorehɨ bɨdɨfɨrɨ roambeahɨndɨ ai hei hoŋguambe hɨmboyeia moai ahandɨ yɨfɨnɨmoko ra ranɨhü hoeirɨhindɨ. Ranɨyo ro hepünɨmehundɨ. Ai sɨnei yɨhoefɨmbo hoafɨyeihɨ seiya, ‘Sünambeahɨndɨ nendɨ yimbu hoeirɨhupɨra ai safanɨya, ‘Sisas ana yaŋgɨrɨ mbanüŋgu,’ masafanɨ,’ masei. ");
INSERT INTO agg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Asu nindou bɨdɨfɨrɨ roambeahɨndɨ amboanɨ hɨfomo hoŋguambe muŋguambo moatükunɨ ra hoeirunda nɨmorehɨ hoafɨmayei süŋgure meŋgoro. Ŋga asu moai Sisasɨmbo ana hoeirüwurɨ,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Asu Sisas ai ahafanɨmbo hoafɨyupɨrühɨ yahuya, “Se ana ŋgusüfokoate-anemo, se moai Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ hoafɨmemo ranahambo nɨmehünou hohoanɨmoyomo. ");
INSERT INTO agg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ ai hoafɨyomondühɨ yahomoya, ‘Nindou God ai ahandɨ nendambo aboedambo-fendürɨmbo kamafoarirɨ ra asübusɨ ndemündɨ mbundambo anɨmbo asu süŋgunambo Godɨndɨ hɨmboahü ndürɨ adükarümbɨndümbui,’ mehomo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ranɨyo Sisas ai ahafanɨmbo ahandɨ fimbo Bukambe hoafɨ mapenɨŋgo ra Mosesɨndɨmayo bukɨfihɨ piyu haya Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ sürü papɨru masɨhoemo ranahambo yamundɨmareapɨrɨ hu. ");
INSERT INTO agg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ai homo Emaus ŋgoafɨkɨmɨ tükümefundɨ. Ranɨyo Sisas ai ŋgasünde haya hombonoumefiyu. ");
INSERT INTO agg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ŋga yimbu ai hüti hoafɨyafandühɨ safanɨya, “Mborai ro-babɨdɨ apoefo, ŋga ndeara hüfɨhamɨndɨ hanühɨ nɨmbɨfembo akɨmane,” masafandamboyu. Ranɨyu hafu ahafandɨ worambe aibabɨdɨ mamaru. ");
INSERT INTO agg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ai sesɨmbo yahomo houmbo nɨmarɨmombo bret semündü Godɨmbo hɨhɨfɨrürɨ mbura hɨfɨtɨre haya masagapɨrɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Rasüŋgu-mareandamboyo ai hepünafɨneandühɨ Sisas ani safanɨ fɨfɨrɨmarɨnerɨ. Ŋga asu nɨmehünou asükai awarɨmarɨhoayuwa moai hoeirɨnerɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ai ahafandɨhoarɨ sɨmborɨ hoafürɨyafandühɨ safanɨya, “Anɨhondü-ane, nafɨnɨ sɨnefühɨ sɨhehɨmbo wataporɨmbo-maramuna asu sɨhɨrɨ ŋgusüfoambe hepünɨmehoandɨ,” masafanɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Refe hayamboyoane, süŋgurɨnerɨ-rɨnandeimbɨ ranai botɨyafɨne hena Serusaremɨnambo mahafanɨ. Ranɨyo hafanɨ hoeirɨneapuranɨ ahandambo süŋgrurü-rundeimbɨ 11-memo ranai ahamundɨ ŋgunindɨ babɨdɨ gugureafu mamarɨmonda hoeimarɨneapurɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ai hoafɨyomondühɨ yahomoya, “Anɨhondü-ane, Adükarɨ ai yɨfɨhündɨ botɨmefiyu! Ai Saimon-so tükümefiyuwa hoeimarirɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ranɨyo asu süŋgrurü-rundeimbɨ yimbu ranai ahafanɨmbo-so nafɨnɨ tükümefiyu asu bret hɨfɨtɨreanda türüfoarɨnerɨ fɨfɨrɨmarɨnerɨ ranahambo wataporɨmbo-marɨnandɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ahambo süŋgrurü-rundeimbɨ ranai bɨdɨfɨrambo ranɨ-moatükunɨ ra wataporɨmbo-rundane, Sisas ahandɨhoarɨ ahamundɨ mbusümo tüküfi nüŋgumbo hoafɨyupurühɨ yahuya, “Sɨhamundɨ ŋgusüfoambe afure kümbearoamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ranɨyomo yifiafɨmbai hoeiarɨhurɨ yahomo houmbo yɨhɨmbo muŋguna moaruwaimemo. ");
INSERT INTO agg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ŋga asu Sisas ai hoafɨyupurühɨ yahuya, “Nɨmboe se ranahambo hepünefunda? Asu nɨmboe se nɨnɨ-moatükunɨyo hoeimarundɨ ranahambo awi fɨfɨrɨfekoate-ayomoa? ");
INSERT INTO agg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Se wandɨ yitɨŋarɨ watɨŋarɨ hoeiru. Ro wandɨhoar-anahɨ nda! Se sündu hoeirundɨrɨ. Sapo yifiafɨ ana ŋgɨrɨ wandɨ fi nahuraindo.” ");
INSERT INTO agg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Sisas ai hoafɨyu mbura asu ahamumbo ahandɨ fi hoearɨ ra nafuimepurɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ai afɨndɨ hɨhɨfɨ-hɨhɨfɨmemosɨ, ŋga ai awi ranahambo anɨhondümbofe-koate-afɨndɨ hohoanɨmomemo. Asu Sisas ai hoafɨyupurühɨ yahuya, “Se sesɨ bɨdɨfɨrɨ sɨhoundai?” mehu. ");
INSERT INTO agg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Asu ai kinɨ mamandundɨ ra ŋgorü bɨdɨfɨrɨ masabudowa semündü haya ahamundɨ hɨmboahü masesuwa hoeimarüwurü. ");
INSERT INTO agg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ai ahamumbo hoafɨyupurühɨ yahuya, “Se fɨfɨrundai ro horombo se-babɨdɨmbo nɨmboahambe hoafɨmayahɨ ra? Ro hoafɨyahapurühɨ sahɨya, Mosesɨndɨ ahɨnümbɨ hohoanɨmo ranambe, Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ-yomondɨ bukambe asu Herü Buk ranambe muŋgu moatükunɨ wambo tükündɨfemboe masahɨ.” ");
INSERT INTO agg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sisas ai ramehuamboemo ŋgusüfoambe fufurɨfoareapurühɨ Bukambe hoafɨmayo ra türüfoaru fɨfɨrɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Sapo Bukambe sürü papɨmarundɨ ra yare hoafɨyowohü yahoya, ‘God ai ahandɨ nendambo aboedambo-fendürɨmbo koamafoarirɨ ra asübusɨ ndemündü mbunda yɨfɨndu haya ŋgɨmɨ noufimbɨ ranambo yɨfɨhündɨ botɨndɨfimbui. ");
INSERT INTO agg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Rananɨmbo Serusaremɨhü pɨndɨmo houmbo muŋguambo hɨfɨ ahandɨ ndürɨnambo hoafɨ bokarɨndɨhoemboemo. Rananɨmbo asu moaruwai hohoanɨmo ra hɨnɨŋgɨrɨhindühɨ aboedɨ hohoanɨmo süŋgurɨhindanɨ God ai ahei moaruwai hohoanɨmo ra amboawi mbeyahuamboane,’ meho. ");
INSERT INTO agg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Asu se ndanɨ moatükunɨ tükümefeyo ndanahambo wataporɨmbondu ndündɨ. ");
INSERT INTO agg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Wandɨ Ape ai Yifiafɨ Aboedɨ koarɨhefembo hoafɨyu masɨhendɨ ra koandɨheheamboyahɨ. Ŋga awi se hokoate Serusaremɨhü nɨmandɨmombo Godɨndɨ-mayo ŋgɨnɨndɨ ra ndowandümo houmbo anɨmbo ŋgomo,” mehu. ");
INSERT INTO agg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sisas ai ahambo süŋgrurü-rundeimbɨmbo sepurümündɨ hu Betani ŋgoafɨhü kaimayu. Ranɨyo God ai ahamumbo aboedɨ-aboedɨmbɨreapura yahu haya dɨdɨbafɨmefiyu. ");
INSERT INTO agg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ai ahamumbo aboedɨ-aboedɨreapurühɨ nüŋguane God ai ahamundɨ mbusümonɨndɨ serümündü sünambe mahafu. ");
INSERT INTO agg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ai yirɨ yimbu pusɨru nɨmarɨmombo ahambo ŋgusɨfo parüwurɨ mburumbo Serusaremɨnambo hɨhɨfɨ-hɨhɨfɨ kameihɨ hɨhɨrɨyafu mahomo. ");
INSERT INTO agg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Asu ai muŋguambo si Godɨmbo aboed-ani yaho hohoanɨmombohünda ahandɨ worɨna homo marundɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Horombo hondü God ai hɨfɨ nda nafɨkoate-yuambe Hoafɨ nda meŋgoro. Hoafɨ ra ai Godɨndɨ fikɨmɨ meŋgoro asu God-ane. ");
INSERT INTO agg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Horombo hondü Hoafɨ ra Godɨndɨ fikɨmɨ meŋgoroane. ");
INSERT INTO agg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God ai Hoafɨ ranɨnambo muŋgu moatükunɨ ra nafɨmarandɨ, ŋga moai ŋgorü-moatükunɨ ŋgorü nafɨ süŋgure tüküfeyo. ");
INSERT INTO agg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hoafɨ ra yaŋgɨrɨ nɨŋgombo nɨmɨndühane asu yaŋgɨrɨ nɨŋgombo ra nindou-yafe si-ane. ");
INSERT INTO agg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Si ra nɨmbɨ ranahambo si asagado, ŋga nɨmbɨ ra ŋgɨrɨ si ranahambo gabudeandɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nindou mamɨ God ai koamarɨheira mahu. Ahandɨ ndürɨ Son-ani. ");
INSERT INTO agg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nindou ranaheimbo si ranahambo anɨhondümbo hoafombohünda mahu. Nindou muŋgu ai hoafɨ ra hɨmborɨyei hehi anɨhondümbo-mbɨrɨhinda yehuenüŋgu mahu. ");
INSERT INTO agg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Son ra si ranɨyupoanɨ, ŋga si ranahambo anɨhondümbo hoafɨyu-randeimbɨ yaŋgɨr-ani. ");
INSERT INTO agg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Si ndanana si hond-ane asu ai hɨfɨ ndanɨhü tüküfe haya asu nindou muŋguambo si boakɨfoare arandɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ŋga Hoafɨ ranai hɨfɨ ndanɨhü meŋgoro. Hoafɨ ranɨnambo God ai hɨfɨ nda nafɨmarandɨ, ŋga asu nindou hɨfɨ ndanɨhü anɨboadei ranai moai ahambo fɨfɨrɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ai ahandɨ ŋgoafɨ hondüna hu, ŋga asu nindou ahandɨ ŋgoafɨhündɨ ai moai ahambo fihɨrɨhorɨmɨndei. ");
INSERT INTO agg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ŋga dɨdɨyei ahambo anɨhondümbo-rɨhorühɨ fihɨmarɨhorambo asu ai aheimbo kamafoareandüra ai Godɨndɨ nɨmorɨ tükümehindɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Moai hɨfɨnɨndɨ moatükunɨnambo Godɨndɨ nɨmorɨmboyahi tüküyahindɨ sɨhɨrɨ boagɨrɨ ramehindɨ nou. Wanɨ, ŋga God ai ahandɨ hohoanɨmo süŋgu ahandɨ nɨmorɨmboyahi marɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hoafɨ ra nindoumbofe tüküfe mburamboyo asu sɨhefɨ mbusümo manüŋguwa ai ndürɨ adükarümbɨ ra hoeimarɨhurɨ. Ndürɨ adükarümbɨ ra Godɨndɨ nɨmorɨ mamɨ yaŋgɨrɨ ranahand-ane. Ai afɨndɨ hɨpoambore-randeimb-ani asu sɨhefɨmbo Godɨmbo afɨndɨ moatükunɨ anɨhondümbo nafuimaramunɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Son ai ahambo anɨhondümbo hoafɨmayu. Ai puküna hoafɨyundürühɨ yahuya, “Ro nindou ndanahamboyahɨ hoafɨmayahandürɨ, ‘Ro boatei tükündaheanda ai wandɨ süŋgu tükündüfimbui, ŋga aiana adükarɨ safɨ ŋgasündeandɨreimb-ani. Nɨmboe ai boateifi manüŋguwa ro tükümeheandane,’” mehu. ");
INSERT INTO agg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ahandɨ afɨndɨ hɨpoambofe ranɨ-süŋgu sɨhefɨmbo afɨndɨmbo aboedɨ-aboedɨreamunɨ arandɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosesɨndɨ warɨ süŋguyo ahɨnümbɨ hohoanɨmo tükümefeyo, ŋga hɨpoambofe hohoanɨmo asu anɨhondümbofe hohoanɨmo ra Sisas Kraisɨndɨ süŋguyo tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Moai nindou mamɨ ai-amboanɨ God hoeirirɨ, ŋga Godɨndɨ nɨmorɨ mamɨ Afɨndandɨ fikɨmɨ nüŋgumbü ai God-ani asu ai yaŋgɨrɨyu Godɨmbo hoeirirɨ haya sɨhefɨmbo nafuimaramunɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Suda bogorɨ ai Godɨmbo sɨhou-rundeimbɨ bɨdɨfɨrɨ Rifai sɨrɨhündɨ babɨdɨmbo koamarɨ-houpura Serusarem hɨnɨŋgɨru houmbo kosɨmo Son sowahɨ tüküyafu düduyafundowohü yahomoya, “Se dɨdɨyafa?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ranɨyu asu Son ai moai dɨboreandɨ, ŋga weindahɨ anɨhondümbo hoafɨyuhɨ yahuya, “Roana Nindou God koamafoarirɨ Krais ranɨyahɨpoanɨ, ŋga wanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ranɨyomo asu sɨmborɨ hoafɨyomondowohü yahomoya, “Asu se dɨdɨyafa? Asu se Eraisayafɨ?” mehomondamboyu. Asu Son ai sɨmborɨ hoafɨyupurühɨ yahuya, “Wanɨ, roana ranɨyahɨpoanɨ.” Asükaiyomo düduyafundowohü yahomoya, “Ro Godɨndɨ hoafɨ hoafɨyu-randeimbɨ hɨfandarɨhurɨ, se ranɨyafɨ?” Asükaiyu ahamumbo sɨmborɨ hoafɨyupurühɨ yahuya, “Wanɨ, roana ranɨyahɨpoanɨ,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ranɨyomo asu ahambo hoafɨyomondowohü yahomoya, “Asu se dɨdɨyafɨ nɨmora? Se yɨhoefɨmbo hoafɨyafan-anɨmbo asu ro hoafɨ ra nindou yɨhoefɨmbo koamarɨ-houmunɨ ahamumbo sowana semɨndɨ homboanefɨ. Se sɨhafɨ fimbo nüŋgumambɨsafa?” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ranɨyu asu Son ai ahamumbo sɨmborɨ hoafɨyupurühɨ yahuya, “Ro rananahɨ: Nindou mamɨ ahandɨ yasɨmondɨ nɨmɨ wohɨ furɨkoate-yowohü mɨŋgɨyohü yahoya, ‘Bogorɨndɨ nafɨ aboedɨ nafɨndɨhehindɨ,’ meho, ŋga ro rananahɨ,” mehu. Horombo hoafɨ nda Godɨndɨ hoafɨ hoafɨyu-randeimbɨ Aisaia rareamboyu yahurai bukambe hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Farisi aiyomo nindou hoafɨ sowandümo homo-rundeimbɨ ahamumbo koamarɨ-houpura makosomo. ");
INSERT INTO agg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nindou ranai Sonɨmbo hoafɨyomondowohü yahomoya, “Asu se Kraisɨyafɨpoanɨ, Eraisayafɨpoanɨ, Godɨndɨ hoafɨ hoafɨyu-randeimbɨyafɨpoanɨ, ŋga asu nɨmboeafɨ se hundürürandürɨ maranda?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ranɨyu asu sɨmborɨ Son ai hoafɨyupurühɨ yahuya, “Roana hoenambo yaŋgɨr-ane hundürɨhɨ arɨhandɨ, ŋga sɨhamundɨ mbusümo nindou mamɨ anüŋgu, ŋga asu seana moai nindou ranahambo fɨfɨrɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ro boatei weindahɨ ratüpurɨya arɨhandɨ, ŋga nindou ranai anɨmbo süŋgunambo weindahɨ rande ratüpurɨndümbui. Ŋga asu roana nindou aboedɨ hamɨndɨyahɨpoanɨ ahandɨ su wofɨ hɨmondɨmaramündu ra fufurɨhefembohünda,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hoafɨ nda Betani ŋgoafɨhü Sodan hoe gogoanɨnɨ tükümefeyoane. Asu hɨfɨ ranɨhüyo Son ai nɨmorehɨ nindowenihɨ aheimbo hundürümarandürɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ŋgorü sihɨ Son ai hɨmboyuwane Sisas ahambo sowana masünuwa hoeirirühɨ yahuya, “Godɨndɨ sipsip nɨmorɨ asüfu ra hoeirɨhorɨ. Ranahandɨ süŋgu-anɨmbo God ai nɨmorehɨ nindowenihɨ-yafe hohoanɨmo moaruwai ranahambo amboawi mbüsümbui. ");
INSERT INTO agg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nindou ranahamboyahɨ ro sɨheimbo hoafɨyahandürühɨ, ‘Nindou ai ro nɨmboahanɨ wandɨ süŋgu düdümbui. Nindou ai adükarɨ bogor-ani, ŋga roana ai nahuraiyahɨpoanɨ,’ masahandürɨ. Ŋga asu ro nɨŋgokoate-yahambe ai manüŋgu. ");
INSERT INTO agg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Asu ro moai fɨfɨrɨhinɨ, ŋga nindou ra dɨdɨmbei, ŋga asu Israerɨhündɨ ai ahambo fɨfɨrɨmbɨrɨhora sahehea sɨnɨ hundürü-marɨhandürɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Son ai yare hoafɨyundürühɨ yahuya, “Ro hoeirɨheandanɨ Yɨfiafɨ Aboedɨ wupufo nahurai sünambeahɨndɨ kosɨ ahandɨwamɨ pühɨyo mamaro. ");
INSERT INTO agg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Awi ro moai nindou ranahambo fɨfɨrɨhinɨ, ŋga God aiyu wambo hoenambo hundürümbɨrandüra yehuenüŋgu koarɨhendɨrühɨ yahuya, ‘Se hoeindowandanɨ Yifiafɨ Aboedɨ kodɨ nindou ranahandɨwamɨ nɨmandoanɨ ana, asu ai-anɨmbo aheimbo Yifiafɨ Aboedɨnambo hundüründandürɨmbui,’ mehu. ");
INSERT INTO agg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yifiafɨ Aboedɨ ahandɨwamɨ kosɨ mamaro ra hoeimarɨheandɨ asu anɨhondümboanahɨ hoafayahɨ nindou nda Godɨndɨ nɨmor-ani,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Ŋgorü si Son ai asükai ranɨhü ahambo süŋgurɨnerɨ-rɨnandeimbɨ babɨdɨmbo nüŋgumbo Sisasɨmbo hoeirirane mahuamboyu, asu Son ai hoafɨyuhɨ yahuya, ‘Se hoeirɨne. Ndanani Godɨndɨ sipsip nɨmorayu.’ ");
INSERT INTO agg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Son ai ra-mehuamboyafanɨ asu hɨmborɨyafanɨ hena ai Sisasɨndɨ süŋgu mahafanɨ. ");
INSERT INTO agg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ranɨyu asu Sisas ai hɨhɨrɨfi hoeireapɨrane ahandɨ süŋgu mahafandamboyu hoafɨyupɨrühɨ yahuya, “Se nɨnɨ kokomboyafana?” mehupɨramboyafanɨ, asu sɨmborɨ hoafɨyafɨnandowohü safanea, “Rabai, se nahiyafɨ nɨmbafɨ aranda?” (Ndürɨ ‘Rabai’ ahandɨ nɨmɨndɨ ra yamunde-randeimb-ane.) ");
INSERT INTO agg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Sisas ai hoafɨyupɨrühɨ yahuya, “Sühüfanɨ naha hoeirɨne,” mehupɨramboyafanɨ. Asu ai hüfanɨ worɨ nɨmarümbɨ ra hoeirɨne hena, asu ranɨ sihɨ ai-dɨbo mamarɨfanɨ ra ndeara nɨmbambeyo. ");
INSERT INTO agg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nindou yimbu ranai Sonɨndɨ hoafɨ hɨmborɨyafanɨ hena Sisasɨndɨ süŋgu mahafandɨ ahafandɨ ndürɨ ra ŋgorü ana Andru, Saimon Pitandɨ akɨdɨyu. ");
INSERT INTO agg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ai hu, ahandɨ amoŋgo Saimon kokorürɨ hoeirirɨ haya hoafɨyundühɨ yahuya, “Ro Mesaia hoeimarɨhurɨ,” mehu. (Ndürɨ Mesaia ra Grik hoafɨnambo Krais-ani.) ");
INSERT INTO agg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ranɨyu Andru ai Saimonɨmbo serümündɨ Sisas sowana mahüfu-amboyu, asu Sisas ai Saimonɨmbo hübudurürühɨ hoafɨyundühɨ yahuya, “Seana Sonɨndɨ nɨmorɨ Saimon-anafɨ, ŋga sɨhafɨ ndürɨ ana Sifasɨ-mbeyowamboane,” mehu. (Ndürɨ Sifas ranana nɨmoei-ane.) ");
INSERT INTO agg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ŋgorü si Sisas ai Garirinambo hafombo yahuhaya nɨmarümbo, Firipɨmbo hoeirirühɨ hoafɨyundühɨ yahuya, “Se mborai wandɨ süŋgu,” mehundo. ");
INSERT INTO agg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Firip, Betsaidahündɨ Andru, Pita-babɨdɨmbo mamɨ ŋgoafɨhünd-ani. ");
INSERT INTO agg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ranɨyu asu Firip ai Natanierɨmbo kokorürɨ hoeirirɨ haya hoafɨyundühɨ yahuya, “Horombo Moses ai ahɨnümbɨ hoafɨ sürü papɨrandühɨ nindou kudümbui mehu ra fɨfɨro. Asu Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ amboanɨ ai mamɨ yahurai sürü papɨmarundɨ ranahambo hoeimarɨhorɨ. Nindou ranana Sisas-ani Sosepɨndɨ nɨmorɨ Nasaretɨhündɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Asu Natanier ai Firipɨmbo düdufinduhü yahuya, “Asu Nasaret ŋgoafɨhü ra aboedɨ moatükunɨ tükümandɨfeyo rane?” mehuamboyu. Asu Firip ai sɨmborɨ hoafɨyundühɨ yahuya, “Naha se sühüfɨ hoeirosɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sisas ai Natanierɨmbo hoeiriranɨ mahüfu-amboyu hoafɨyuhɨ yahuya, “Nindou ndanana Israerɨhündɨ hond-ani, ŋga aiana anɨhondümbo yaŋgɨrɨ hoafɨyu-randeimbani,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ranɨyu asu Natanier ai Sisasɨmbo düdufindühɨ yahuya, “Se wambo nüŋguro fɨfɨro-wandɨrɨmboyafa?” mehundu-amboyu. Asu Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Firip wambo fɨfɨrɨfe hoafɨkoate-yuambe süfurɨ afümambe manɨmbafa hoeimarɨheanɨnɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ranɨyu asu Natanier ai Sisasɨmbo hoafɨyundühɨ yahuya, “Yamundo-randeimbɨ, seana Godɨndɨ nɨmor-anafɨ! Seana Israerɨhündɨ-yafe adükarɨ bogor-anafɨ!” mehundo-amboyu. ");
INSERT INTO agg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Asu Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Ro sɨhambo süfurɨ afümambe hoeimarɨheanɨnɨ masahɨ ranɨmboanafɨ anɨhondümbo-arowandɨrɨ? Ŋga awi süŋguna se afɨndɨ moatükunɨ ranahambo ŋgasündeandeimbɨ tükündɨfeyoanɨ hoeindowamboyafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Asükaiyu hoafɨyuhɨ yahuya, “Ro sɨhamumbo anɨhondümboanahɨ hoafayahapurɨ: Süŋgunambo ana sünü sübüdühoehü sünambeahɨndɨ nendɨ ai Nindou Hondündɨwamɨ gafomo kodomo ndundanɨ hoeindumboemo,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yimbu nɨmbɨyomo houmbo nindowenihɨ ŋgorü ai Gariri hɨfambe Kena ŋgoafɨhü nɨmorehɨ masemündu. ");
INSERT INTO agg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ranɨyo Sisasɨmbo asu ahambo süŋgururü-rundeimbɨ babɨdɨmbo ahamumbo amboanɨ nɨmorehɨ semɨndɨ sesesɨ ranambe dɨdɨmo masei. ");
INSERT INTO agg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ranɨ-sɨmboanɨ wain hoe ra muŋgu masɨmɨndeiamboyo, asu Sisasɨndɨ hondɨ ai nɨmorɨmbo hoafɨyondowohü yahoya, “Nindou ai wain hoe muŋgurɨhimboanei,” mehondowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Asu sɨmborɨ yare hoafɨyundühɨ yahuya, “Me, nɨmboe se wambo ranɨ-moatükunɨmbo hoafayafa? Ndanana sɨhei siane, ŋga awi ro ranɨmbofembo si ra yohoyopoanɨ.” ");
INSERT INTO agg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ra-mehuamboyo asu hondɨ ai worɨ aharambürɨndɨ ratüpurɨyomo-rundeimbɨ ahamumbo hoafɨyopurühɨ yahoya, “Sisas ai nɨnɨ-moatükunɨmboyo refembo hoafɨnduanɨ ra-süŋgundundɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ŋgoafɨ ranɨhü nɨmoei hɨpɨrɨ 6 afɨndɨ hoe hafo tüküfe-randeimbɨ Suda ai fi aboedɨferambo hundürüyorambohünda burɨmayo. ");
INSERT INTO agg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ranɨyu Sisas ai ratüpurɨyomo-rundeimbɨ ahamumbo hoafɨyupurühɨ yahuya, “Se hɨpɨrɨ ranambe hoe fuibɨdɨ-houndɨ,” mehuamboemo. Asu ai hɨpɨrɨ ranamboe hoe fuibɨdɨhoumbo tüküru-tüküru-marundɨ. ");
INSERT INTO agg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ranɨyu asu Sisas ai hoafɨyupurühɨ yahuya, “Se hoe ra nɨmoamonɨndɨ kaboandundüh-anɨmbo nindou sesɨ kanɨmbo ehu ahambo sowanambo ndowandümo ŋgomo,” mehua-mboyomo asu ai rasüŋgumarundɨ. ");
INSERT INTO agg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nindou sesɨ kanɨmareandɨ ai hoe ra apɨre hoeireandane, asu wain hoe apɨmayowamboyu, ai moai fɨfɨreandɨ dagüdambombai wain hoe ra. Ŋga ratüpurɨyomo-rundeimbɨ ai-yaŋgɨrɨyo hoe mafuindümo fondɨ ra fɨfɨmarundɨ. Ranɨyu asu nindou sesɨ kanɨre-randeimbɨ-mayu ranai nindou nɨmorehɨ semɨndɨmbo-mayu ranahambo mborai mehundo. ");
INSERT INTO agg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ai hoafɨyundowohü yahuya, “Ndanɨ-ndanɨ hoafühɨ ana nindou wain hoe aboedɨ boatei sɨmɨndei mburühümboanei, asu süŋgunamboane moaruwai ra sɨmɨndei arɨhündɨ. Ŋga asu seana aboedɨ safɨ ra kɨkɨhandɨfɨ nɨmarɨfɨ mburamboyafɨ hapondanɨ randɨ sowandɨfɨ masɨnɨfɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sisas ai Gariri hɨfambe Kena ŋgoafɨhü boatei hapünɨfeimbɨ moatükunɨ ramareandɨ. Ai ahandɨ adükarɨ ŋgɨnɨndɨ ra nafuimayu-wamboyo asu ahambo süŋgururü-rundeimbɨ ai ahambo anɨhondümbo-marüwurɨ. ");
INSERT INTO agg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ranɨyo asu Sisas ai ahandɨ hondɨ, akohoandɨ asu süŋgururü-rundeimbɨ babɨdɨmbo Kena ŋgoafɨ hɨnɨŋgɨrɨhi hehi Kaperneam ŋgoafɨna hei ranɨhü yahunümbɨ si manɨmboei. ");
INSERT INTO agg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","God ai Israerɨmbo Isipɨhündɨ aboedambo-mareandürɨ ranɨ adükarɨ si Pasofa warɨ ra ndeara akɨmɨ tɨfɨmareandamboyu asu Sisas ai Serusarem ŋgoafɨna mahafu. ");
INSERT INTO agg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hafu tüküfi haya Godɨndɨ worambe kefuai hu hoeireandane, nindou ai burmakau, sipsip, ndu pemɨyomonda asu kakɨ sɨseru sabupurɨ rundühɨ mamarɨmonda hoeimareapurɨ. ");
INSERT INTO agg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ranɨyu wofɨ hoandarɨ nafɨrɨhai semündü haya ranɨnambo ahamumbo burmakau, sipsip, ndu napo ra kameihɨ bukürɨ-foareapurühɨyu, asu nindou kakɨ sɨseruründühɨ mamarɨmo ahamundɨ kakɨ ra buburamündɨ pütifihɨyu fondɨ ra hɨhɨre amoahɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ranɨyu asükaiyu nindou ndu kakɨfihɨ saurundühɨ manɨŋgomo ahamumbo hoafɨyupurühɨ yahuya, “Napo ra fufuründümo houmbo moanewana ŋgorügoanɨnɨ homo. Asu se wandɨ Apendɨ worɨ ndanambe maket worɨmborɨhi hehi pemɨyei asu kakɨfihɨmbo seihü arɨhünda?” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Asu ahambo süŋgururü-rundeimbɨ ai hoafɨ Baibor-ambe mapenɨŋgo ra hohoanɨmomemo, ‘Ro sɨhafɨ worɨ aboedɨ mbɨfondarowa sahehea ranɨmboanahɨ afɨndɨ tɨŋɨrɨfoayahɨ,’ meho. ");
INSERT INTO agg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Asu Suda ai Sisasɨmbo hoafɨyomondowohü yahomoya, “Se nɨnɨ hepünɨfeimbɨ moatükunɨ ramandowandɨ yɨhoefɨmbo worɨ ranambeahɨndɨ hemoafoarowamunɨ ra ŋgɨnɨnd-ani yaho nafuimbohündamboa?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Ro sɨhamumbo hoafayahɨ, Godɨndɨ worɨ nda bɨrɨboadundanɨ asu ro asükainda ŋgɨmɨ sinambo yaŋgɨrɨ worɨmbondɨ-hamboyahɨ,” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ranɨyomo asu Suda ai hoafɨyomondühɨ yahomoya, “Nindou ai worɨ nda 46 hɨmbanɨ worɨmbomarund-ane asu se ŋgɨmɨ sihɨ yaŋgɨrɨ asükainda worɨmbondɨhɨ muŋgundɨheamboyahɨ asafɨ?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sisas ai ahandɨ fimboyu Godɨndɨ worɨ süŋgunambore kafoare hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ranɨyo Sisasɨmbo God ai hoŋguambeahɨndɨ botɨrirɨ sɨmboanɨ ahambo süŋgururü-rundeimbɨ ai horombo ahandɨ fimbo hoafɨmayu ra ŋgusüfoambe pumarɨndümo. Ranɨyo horombo Sisas hoafɨmayuyo Godɨndɨ bukambe sürü papɨmarundɨ ranɨyo ra anɨhondümbo-marundɨ. ");
INSERT INTO agg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sisas ai Suda-yafe adükarɨ si Pasofa ranahambohünda Serusarem ŋgoafɨhü mamaru. Ranɨyo nindou afɨndɨ ranai Sisas hepünɨfeimbɨ moatükunɨ ramareandɨ ra hoeirɨhi hehi anɨhondümbo-marɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ŋga asu Sisas ai nindou ranahei hohoanɨmo ra fɨfɨre hayambo-wambo moai anɨhondümbo-rearü. ");
INSERT INTO agg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Asu nindou amurɨ ai Sisasɨmbo nindouyei hohoanɨmo ranahambo nafuiyondürühɨ hoafɨyondopoanɨ, ŋga ai ahei ŋgusüfoambe hohoanɨmo ra muŋguambo fɨfɨreamboani. ");
INSERT INTO agg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nindou mamɨ Farisi-ambeahɨndɨ manüŋgu ahandɨ ndürɨ Nikodemus ai Suda-yafe bogorɨyu. ");
INSERT INTO agg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Asu mamɨ nɨmbokoanɨ Nikodemus ai Sisas sowahɨ hu tüküfi hoafɨyundühɨ yahuya, “Yamundo-randeimbɨ, Ro fɨfɨrɨ-hunɨnɨmboanefɨ, seana nindou yamundo-randeimbɨ God koamarɨhenɨn-anafɨ. Nindou ŋgorü ai-amboanɨ ŋgɨrɨ hepünɨfeimbɨ moatükunɨ se Godɨndɨ ŋgɨnɨndɨnambo rawarowandɨ ra randeandɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Asu Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Ro sɨhambo anɨhondümboanahɨ hoafehanɨnɨ: Nindou ai sɨmborɨ tüküfekoate-ayu ana, ai ŋgɨrɨ God hɨfandarandɨ ranambe ŋgu,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus ai sɨmborɨ hoafɨyundühɨ yahuya, “Asu nindou adükarɨhündɨ ra nüŋgunde hondɨ ai wakɨndɨrɨmɨndoanɨ asu nɨmorɨ akɨdou nahuarai tükümandɨfia? Asu ŋgɨrɨ nindou ai hondandɨ furambe daguduwanɨ asükai wakɨndɨrɨmɨndo,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Asükai Sisas ai Nikodemusɨmbo hoafɨyundühɨ yahuya, “Nindou ai Yifiafɨ Aboedɨnambo asu hoenambo sɨmborɨ tükümbüfiyu-wamboane. Refekoate-ayu ana, ŋgɨrɨ God hɨfandarandɨ ranambe gafu. ");
INSERT INTO agg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nindoundɨ fi ranana ahandɨ hondafɨndɨ-yafe findambo tükümefiyuani, ŋga ahandɨ yifiafɨ ranana Yifiafɨ Aboedɨndɨ ŋgɨnɨndɨnambo tükümefeyoane. ");
INSERT INTO agg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ro hoafɨyahühɨ se sɨmborɨ tükündahindɨ masahɨ hoafɨ ranambo se ŋgɨrɨ hepünafoandühɨ afɨndɨ hohoanɨmondafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Werɨ ranai ai hohoanɨmomayo süŋgu werɨyo hoarandɨ. Asu se werɨ fisɨhoasɨ ranɨ-yaŋgɨr-ane hɨmborayafɨ, ŋga nɨnɨ-nafɨ tüküfe hayamboyo asu nɨnɨ-nafɨyo aho ra moai fɨfɨrowandɨ. Asu nindou Yifiafɨ Aboedɨnambo sɨmborɨ tükehindɨ amboanɨ mamɨ yahurai-ane,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Asu Nikodemus ai Sisasɨmbo düdufindühɨ yahuya, “Asu se hoafɨmayafɨ nda nüŋgu-nahurai tükümandɨfea?” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Asu Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Seana Israerɨ-yafe yamundo-randeimb-anafɨ, ŋga asu seana awi moai fɨfɨrowandɨyo? ");
INSERT INTO agg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ro sɨhambo anɨhondümboanahɨ hoafayanɨnɨ, Ro nɨnɨ-moatükunɨyo fɨfɨrɨmarɨhundɨ ranane wataporɨmbo-rɨhu arɨhundɨ. Asu ro nɨne-moatükunɨyo hoeimarɨhundɨ ranane wataporɨmbo-arɨhundɨ. Ŋga hoafɨ ro wataporɨmbo-arɨhundɨ ranahambo se sahümündi daboadanambo-arɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ro sɨheimbo hɨfɨ ndanɨhündambo wataporɨmbo-marɨhandürɨ, ŋga asu moai se wambo anɨhondümbo-rɨhindɨrɨ. Asu ro sünambeahɨndɨ moatükunɨmbo wataporɨndahanɨ ra nüŋgundühi anɨhondümbo-ndɨhindühɨ fɨfɨrɨmandɨhia? ");
INSERT INTO agg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Moai nindou ŋgorü hɨfɨ ndanɨhündambo ana sünambe hafu, ŋga Nindou Hondü sünambeahɨndɨ makusu ai yaŋgɨrɨyu asükai mahafu. ");
INSERT INTO agg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sapo horombo Moses ai amoasɨrɨ nɨmɨ wohɨ furɨkoate-reandühɨ semündü nɨmoamo botɨmareandɨ. Asu mamɨ yahurai-anɨmbo Nindou Hondümbo amboanɨ semündü nɨmoamo botɨfiamboani. ");
INSERT INTO agg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Rananɨmbo nindou ahambo anɨhondümbo-arɨhorɨ ranai yaŋgɨrɨ koadürümbo-koadürümbo nɨŋgo ra mbɨsahümündi-amboane. ");
INSERT INTO agg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God ai nɨmorɨ mamümbɨyu hayamboyu nɨmorehɨ nindowenihɨ hɨfɨ ndanɨhü anɨboadei ranaheimbo ŋgusüfo pareandürühɨyu asu ahandɨ nɨmorɨ mamɨ ra hɨfɨna koamarɨherü. Nindou muŋgu dɨdɨyei ahambo anɨhondümbo-arɨhorɨ ai ŋgɨrɨ awandɨhehindɨ, ŋga koadürümbo-koadürümbo nɨmboeimboyei. ");
INSERT INTO agg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God ai ahandɨ nɨmorɨ hɨfɨna koamarɨherü ra ai kosɨ nindou yɨbobore-randeimbɨ nahurai hɨfɨhündɨ nindouyei hohoanɨmo yɨbobofemboyupoanɨ. Ŋga rananɨmbo muŋguambo hɨfɨhündɨ nindou ai ahandɨ süŋgu aboedambo-mbeahinda yahu hayamboyu koamarɨheira makusu. ");
INSERT INTO agg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nindou Godɨndɨ nɨmorɨmbo anɨhondümbo-areandɨ ahambo ana ŋgɨrɨ yɨbobondirühɨ papɨ-hoafɨndürɨ, ŋga nindou ahambo anɨhondümbofe-koate-ayu ranahambo-anɨmbo yɨbobondirühɨ papɨ-hoafɨndürɨmbui. ");
INSERT INTO agg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yɨbobofe ranahandɨ nɨmɨndɨ ra ndahurai-ane: Sapo si aboedɨ ra sünambeahɨndɨ makosoyosɨ, ŋga asu ai moai ranahambo yifirɨyei, ŋga ai nɨmbokoanɨ nɨmbɨ afɨndɨ pɨmayo ranambe nɨŋgomboyei yifirɨmayei. Nɨmboe sapo ai moaruwai hohoanɨmo rarɨhindühɨ wamboyei ramehindɨ. ");
INSERT INTO agg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Muŋguambo nindou dɨdɨyei si ranahambo yɨboaruko-arɨhindɨ ana, ai moaruwai hohoanɨmo yaŋgɨrɨ rarɨhindühanei. Nindou yahurai ana ŋgɨrɨ si peyoanɨ ŋgei sapo si ranai ahei moaruwai hohoanɨmo ramarɨhindɨ ra nafuindandürɨmboe sei hehimbo wambo. ");
INSERT INTO agg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ŋga nindou aboedɨ hohoanɨmo yaŋgɨrɨ semündü anüŋgu ranai-anɨmbo sihɨ tükündüfimbui. Rananɨmbo nindoundɨ ratüpurɨ ra si ranai Godɨndɨ ŋgɨnɨndɨnamboane ratüpurɨyu arandɨ mbɨsɨ nafuindɨmboe,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Asu süŋgunambo Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo randɨhünda botɨyafu houmbo Sudia hɨfɨna mahomo. Ai homo ranɨhü yahunümbɨ si nɨŋgomomboyo Sisas ai nindou hundürümarandürɨ. ");
INSERT INTO agg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ainon ŋgoafɨhü Serim ŋgoafɨkɨmɨ hoe afɨndɨ mafoafusowa asu ranɨhü Son ai-amboanɨ nɨmorehɨ nindowenihɨ hundürümarandürɨ. Ranɨ-sɨmboanɨ nɨmorehɨ nindowenihɨ afɨndɨ ranai ahambo sowana hei marɨhündamboyu ai hundürümarandürɨ. ");
INSERT INTO agg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Son ai karabusɨfekoate nüŋguambeahɨyo aheimbo hundürümarandürɨ. ");
INSERT INTO agg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ranɨyo asu Sudahündɨ mamɨ ai Sonɨndɨ süŋgururü-rundeimbɨ babɨdɨmbo Godɨndɨ hɨmboahü aboedɨ tüküfembo hundürü hohoanɨmo ranahambo hoafɨna sɨmborɨ hoafɨmemo. ");
INSERT INTO agg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Raoyafu mburu hɨfomo Sonɨmbo hoafɨyomondühɨ yahomoya, “Yamundo-randeimbɨ, se hohoanɨmoyafai nindou Sodan hoekɨmɨ ai-dɨbo nɨmbafanɨmbo se ahandɨ hoafɨ yɨhoefɨmbo hoafɨmefɨmunɨ. Ŋga ai haponda hundürümarandür-amboanei asu nindou ai sɨhefɨmbo sowana sɨfokoate ahambo sowanambo yaŋgɨrɨ hüraramɨndo,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Asu sɨmborɨ Son ai hoafɨyupurühɨ yahuya, “Nindou ai ŋgɨrɨ raranɨ-moatükunɨ moanɨ ndemündu, ŋga God ai dagadowan-anɨmbo ndemündümbui. ");
INSERT INTO agg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Horombo se hɨmborɨyomondanɨ ro sɨhamumbo hoafɨyahapurühɨ sahɨya, ‘Roana Kraisɨyahɨpoanɨ, ŋga ahandɨ nafɨ dɨdɨboado-fembohünda God ai kamafoareandɨr-anahɨ,’ masahɨ hoafɨ ra se sɨhamundɨhoarɨ hɨmborɨmemo. ");
INSERT INTO agg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Asu nindou ŋgorü ai nɨmorehɨ asemündu ana, nɨmorehɨ ra nindowenihɨ ranahand-ane. Asu nindowenihambo farɨherü-randeimbɨ ai ai-dɨbo nüŋgumbo nɨmorehɨ masemündu ahandɨ hoafɨ hɨmborɨyuhü ai hɨhɨfɨ-hɨhɨfɨmayu. Yahurai-ane asu haponda hɨhɨfɨ-hɨhɨfɨ ra wandɨ fiambe amaro. ");
INSERT INTO agg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Asu nindou ranai adükarɨ ndürɨmbɨ-mbiyowamboane, ŋga wandɨ ndürɨ akɨdou-mbeyowamboane. ");
INSERT INTO agg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nindou nɨmoamo sünambeahɨndɨ makusu aiani muŋguambo nindou ŋgasünde haya adükarɨ hamɨndayu. Ŋga asu nindou hɨfɨ ndanɨhündamboayu ranai ana hɨfɨnɨndɨ wambo ai hɨfɨ ndanɨhündambo wataporɨ ranɨ yaŋgɨrɨ semündü nüŋgumbo wataporɨyuhani. Ŋga nindou sünambeahɨndɨ makusu ranai ana muŋguambo nindou ŋgasünde haya adükarɨ hamɨnd-ani. ");
INSERT INTO agg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ranani asu ai raranɨ-moatükunɨ hoeire asu hɨmborɨyu-randeimbɨ ranahambo hoafɨyu arandɨ. Ŋga asu nindou mamɨ ai-amboanɨ moai ahandɨ hoafɨ ra anɨhondümboreandɨ. ");
INSERT INTO agg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nindou düdi ahandɨ hoafɨ ranahambo kɨkɨharamündu ana, asu God ai anɨhondümboani hoafɨyu arandɨ yahuhani. ");
INSERT INTO agg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nindou God koamarɨheira makusu ranai ana ahandɨ hoafɨ yaŋgɨr-ani hoafɨyu arandɨ. Sapo God ai moai ahambo Yifiafɨ Aboedɨ ra bɨdɨfɨrɨ-bɨdɨfɨrɨre sagado. ");
INSERT INTO agg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Afɨndɨ ai Nɨmorɨmbo afɨndɨ hamɨndɨ ŋgusüfo parirühɨ asu muŋgu moatükunɨ hɨfandɨmbo ŋgɨnɨndɨ masagado. ");
INSERT INTO agg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nindou ŋgorü ai Nɨmorɨ ahambo anɨhondümbo-arirɨ ana, asu ai aboedɨ koadürümbo-koadürümbo nüŋgumbui. Ŋga asu anɨhondümbofe-koate-ayu aiana ŋgɨrɨ yaŋgɨrɨ koadürümbo-koadürümbo nüŋgu. Asu Godɨndɨ ŋgɨnɨndɨ hohoanɨmo ra ahambo-so koadürümbo-koadürümbo yagodɨmboe.” ");
INSERT INTO agg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ranɨ-sɨmboanɨ Farisi ai yaru hɨmborɨyomondane, “Sisas-ani Sonɨmbo ŋgasündirɨ haya afɨndɨ nindou hundürandürɨ arandɨ,” masei. ");
INSERT INTO agg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ŋga moai Sisas ahandɨhoarɨ ana ŋgorümbo hundürandürɨ, ŋga ahandɨ süŋgururü-rundeimbɨ ai yaŋgɨrɨyomo ramarundɨ.) Sisasɨndɨ süŋgufembo nindou afɨndɨ hundürümayei hoafɨ Farisi ai hɨmborɨmemo ra Sisas ai fɨfɨreandɨ. ");
INSERT INTO agg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ranɨyu asu ai ranɨ hoafɨ ra hɨmborɨyu haya Sudia hɨfɨ hɨnɨŋgɨre haya Garirinambo mahu. ");
INSERT INTO agg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Garirinambo hombo nafɨ ra Sisas ai Samaria-yafe hɨfɨ mbusümo nafɨyu mahu. ");
INSERT INTO agg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ranɨyu hafu adükarɨ ŋgoafɨ Samaria-yafe hɨfambe ahandɨ ndürɨ Sikar ranɨhü tükümefiyu. Ŋgoafɨ ranɨkɨmɨyo Sekob ai ahandɨ nɨmorɨ Sosepɨmbo hɨfɨ kɨkɨre hɨnɨŋgɨmareando. ");
INSERT INTO agg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Horombo Sekob ai hoe rambohünda kakɨra pumareandɨ ra ranɨhü puiaroane, asu Sisas ai ndeara hüfɨnɨmbo nafɨ gebuai ra süfu süfumbo tɨŋambofihɨyu asu foeamoŋgo ranɨkɨmɨ mamaru. ");
INSERT INTO agg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ranɨyo asu ahambo süŋgururü-rundeimbɨ ranai boatei sesɨ pemɨmbo ŋgoafɨ ranambo mahafomo. Asu nɨmorehɨ mamɨ Samariahündɨ ranai hoe ra fuimɨndɨmbo makosowamboyu, Sisas ai hoafɨyundowohü yahuya, “Hoe ra wambo fuisao, ŋga ro sɨmɨndɨmbo samboanahɨ,” mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Asu nɨmorehɨ ranai hoafɨyondowohü yahoya, “Seana Sudahünd-anafɨ, asu ro Samariahünd-anahɨ, ŋga asu se nɨmboe wambo hoe fuisao safɨ hawa düduwefoandɨra?” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Asu Sisas ai sɨmborɨ hoafɨyundowohü yahuya, “Nɨne-moatükunɨ God ai sɨhambo saimbo mehu ranahambo fɨfɨrɨworühɨ, hoafɨmbefɨndo-mbonana, asu hoe sɨmɨndɨwanɨ yaŋgɨrɨ gedühɨ nɨŋgombo saganɨnɨ,” mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Asu nɨmorehɨ ranai hoafɨyondohü yahoya, “Adükarɨ, hoe fuigonɨnɨmbo hɨpɨrɨ wanɨ, ŋga foeamoŋgo hoe ndanana ambeambe aŋgunɨ ragu-ane. Asu hoe sɨmɨndɨwanɨ yaŋgɨrɨ gedühɨ nɨŋgombo ra naha dagüda mafuindandɨfa? ");
INSERT INTO agg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Sɨhefɨ amoao Sekob ai foeamoŋgo ra hɨnɨŋgɨ-mareamunane. Hoe ra ai ahandɨ nɨmorɨ asu burmakau, sipsip ra-babɨdɨmbo sümündɨ marandane. Ŋga asu se kosɨrɨhefe adükarɨmbofe nɨŋgombo safomboyafɨ?” meho. ");
INSERT INTO agg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Asu Sisas ai sɨmborɨ ahambo hoafɨyundowohü yahuya, “Nindou hoe nda asɨmɨndei ranai ana asükaindei nɨmai amɨndanɨŋombo-ndeimboyei. ");
INSERT INTO agg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ŋga nindou dɨdɨyei ro hoe aheimbo asahandürɨ ranai ana ŋgɨrɨ asükaindei amɨndanɨŋombonde, ŋga wanɨ. Hoe ro aheimbo saimbo saheheamboayahɨ ranana, ahei fiambe apoandɨhorɨ hoe nahurai fondɨhoai-fondɨhoaindandanɨ asu nindou ranai yaŋgɨrɨ koadürümbo-koadürümbo nɨmboeimboyei,” mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Asu nɨmorehɨ ranai düdufendowohü yahoya, “Adükarɨ, se wambo hoe ra sawandɨrɨ. Rananɨmbo ro ŋgɨrɨ asükainda süŋguna hoembo amɨndanɨŋombondahühɨ hoe nda fuimɨndɨmbo dɨdɨhɨ,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Asu Sisas ai hoafɨyundowohü yahuya, “Se ŋgüfɨ sɨhafɨ nindowenihambo hoafɨndafɨndo mbundambo-anɨmbo asükaindafɨ ndühɨ dɨdɨfɨ,” mehundowamboyo. ");
INSERT INTO agg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Asu ai hoafɨyondowohü yahoya, “Roana anamɨndeimbɨ-yahɨpoanɨ, ŋga anamɨndɨkoate-anahɨ,” mehondowamboyu. Asükaiyu Sisas ai hoafɨyundowohü yahundoya, “Se ‘Roana anamɨndɨkoate-anahɨ,’ asafɨ ra wambo anɨhondümbo-anafɨ hoafayafɨndɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ŋga se nindowenihɨ hondahüyafundeimbɨ masowapundɨfɨ, ŋga se haponda nindowenihɨ-dɨbo anɨmbafɨ ra sɨhafɨ anamɨndɨ hondüyupoanɨ. Ŋga se wambo haponda anɨhondümbo-anafɨ hoafayafɨndɨrɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nɨmorehɨ ranai hoafɨyondowohü yahoya, “Adükarɨ, seana ro hoeirɨheanɨna Godɨndɨ hoafɨ hoafɨyafɨ-randeimb-anafɨ. ");
INSERT INTO agg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yɨhoefɨ amoao mamɨ ana hɨfɨ wafu ndanɨ-wamɨyomo rotuyomo marundɨ, ŋga asu Suda se-anemo Serusarem ŋgoafɨ ranɨhü yaŋgɨrɨ rotuyomboane ehomo,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Sisas ai yahuya, “Nɨmorehɨ, se wambo anɨhondümbo-rowandɨrɨ, ŋga se ŋgɨrɨ amɨtata Apembo hɨfɨ wafu ranɨwamɨ asu Serusaremɨhü ra rotuyo ra-koate-ndei. ");
INSERT INTO agg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samariahündɨ seana Godɨmbo ndorɨhorɨ fɨfɨrɨ-horühɨyeipoanɨ ahambo rotuyei arɨhündɨ. Ŋga ro Suda ana God ranahambo ndorɨhurɨ fɨfɨrɨ-hurɨmboanefɨ. Ŋga asu sapo Godɨndɨ nendɨ aboedambofembo ratüpurɨ ra Suda yɨhoefɨmbo sowahɨ tükümefeyoane. ");
INSERT INTO agg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sapo ranɨ si tüküfembo meho ra, ndeara haponda tüküfemboane, ŋga asu nindou ai anɨhondümbo rotuyei arɨhündɨ ranai-anɨmbo Godɨmbo ŋgusüfoambe anɨhondümbo-ndɨhindühɨ Yifiafɨ Aboedɨndɨ ŋgɨnɨndɨnambo rotundeimboyei. Rananɨmbo asu Ape ai nindou yahurai ranɨmboani ahambo rotuyondombo hohoanɨmoayu. ");
INSERT INTO agg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ŋga God ana yifiafɨ-ani. Ranɨmboanɨmbo nindou ai Godɨmbo rotuyei arɨhündɨ ra ŋgusüfoambe anɨhondümbo-ndɨhorühɨ Yifiafɨ Aboedɨndɨ ŋgɨnɨndɨnambo rotumbeyei-amboane,” mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Asu nɨmorehɨ ranai sɨmborɨ hoafɨyondowohü yahoya, “Ro fɨfɨrɨhinɨmboanahɨ nindou God kamafoarirɨ ra ahandɨ ndürɨ Krais ai-anɨmbo kudümbui. Asu ai kusü sɨmboanɨ sɨhefɨmbo muŋgu moatükunɨ ranahambo hoafɨndümunɨmbui,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Asu Sisas ai sɨmborɨ hoafɨyundowohü yahuya, “Ro ai-anahɨsɨ haponda se-dɨbo wataporayahɨ nda,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sisas ai raoyahuambe ahambo süŋgururü-rundeimbɨ ai sesɨ pemɨnɨpoedɨ sümburɨndümo tükümefundɨ. Asu ai hoeirundane Sisas ai nɨmorehɨ-dɨbo wataporɨmefea hepünɨmefundɨ, ŋga nindou mamɨ ai-amboanɨ moai düdufinduhɨya, “Se nɨmboeafa?” yahundo asu “Nɨmboe se nɨmorehɨ ra-dɨbo wataporefea?” yahundo, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Ranɨyo asu nɨmorehɨ ranai hoe fuimɨndɨ hɨpɨrɨ ra ranɨhü sɨhai haya hɨfo nindou ranɨ ŋgoafɨhündɨ ranaheimbo hoafɨyondürühɨ yahoya, “Se naha sɨnei nindou geba anüŋgu ra hoeirɨhorɨ. Ai wambo ro muŋgu moatükunɨ ratüpurɨya marɨhandɨ ra muŋgu ai weindahɨ hoafɨmayundɨrɨ. Ŋga awi ai Krais anɨmbombei?” mehoamboyei. ");
INSERT INTO agg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ranɨyei asu ai ŋgoafɨ ra hɨnɨŋgɨrɨhi hehimbo Sisas sowana muŋgu mahanei. ");
INSERT INTO agg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ranɨyomo asu ahambo süŋgururü-rundeimbɨ ai Sisasɨmbo hüti-hoafɨrurühɨ yahomoya, “Yamundo-randeimbɨ, sesɨ akɨdounambo ŋgusüfo narɨworɨ hawambo-anɨmbo,” mehomondo. ");
INSERT INTO agg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ŋga asu Sisas ai hoafɨyupurühɨ yahuya, “Sesɨ ro sesɨmbo asahɨ ra seana moai fɨfɨrundɨ,” mehupuramboemo. ");
INSERT INTO agg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Asu ahamundɨhoarɨ sɨmborɨ düduyomondühɨ yahomoya, “Nindou ŋgorü ai ahambo sesɨ ra semündü sünɨ sagadomboyu?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Asu Sisas ai hoafɨyupurühɨ yahuya, “Wandɨ sesɨ ranana ndahurai-ane: God ai koamarɨhendɨra makosahane ro ahandɨ hoafɨ süŋguferambo. Wandɨ sesɨ ana ahandɨ yifɨrɨ süŋgufe asu ahandɨ ratüpurɨyora ho moendɨfembo makosahane. ");
INSERT INTO agg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Se yaru hoafɨyomondühɨya, ‘Awi nümbürambeahɨndɨ sesɨ yimuŋgu-remɨndɨmboana, yimbuyimbu amoamo-ane anɨŋgomo,’ mehomo, ŋga asu ro hoafayahɨ ra se hɨmborɨyomo, naha se ndoru nümbürɨ ra samoŋgorɨyomo hoeiru, nɨnɨmɨndɨ ana ndeara ŋgɨnɨndɨ yaŋgɨr-ane. ");
INSERT INTO agg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nindou nümbürambeahɨndɨ sesɨ yimuŋgurɨra-randeimbɨ-mayu ranai ndeara ranɨ takɨnɨ ahandɨ kakɨ semündü haya, asu ai sesɨ aboedɨ koadürümbo-koadürümbo nɨŋgombo safɨyorambo-mayo gugurareandɨ. Rananɨmbo nindou sesɨ hɨfɨre-randeimbɨ asu yimuŋgurɨra-randeimbɨ ai hɨhɨfɨ-hɨhɨfɨndamboyafanɨ. ");
INSERT INTO agg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Asu hoafɨ ndanana anɨhond-ane ‘Nindou ŋgorü ai hɨfɨreandühani, ŋga nindou ŋgorü ai yimuŋgurandühani.’ ");
INSERT INTO agg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ro sɨhamumbo sesɨ nümbürɨ ranambe homo yimuŋgurɨ mbɨrunda sahehea koamarɨheheapurɨ. Asu se moai hɨfɨrundɨ, ŋga amurɨ ai tɨŋamboyeihɨ hɨfɨmarɨhindɨ ranɨ-fihɨndɨ asarɨmbo yahomo houmbo asowandümo,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nɨmorehɨ Samariahündɨ ranai ranɨ ŋgoafɨhündɨ ranaheimbo nɨne-moatükunɨ ai ramareandɨ ranɨmbo Sisas ai hoafɨmayundo ranahambo ho wataporɨmbo-marandɨ. Ranɨyo asu muŋguambo nindou ranai Sisasɨmbo anɨhondümbo-marɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ranɨyei asu Samariahündɨ ranai hei Sisasɨmbo apombo hüti-hoafɨmehündoa ranɨhü ai-babɨdɨmbo yimbu apomayu. ");
INSERT INTO agg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ranühɨ Sisas ai wataporɨmbo-maranda asükai nindou afɨndɨ safɨ ranai hɨmborɨyei hehi anɨhondümbo-marɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Asu nɨmorehɨ ranahambo hoafɨyahündowohü seiya, “Boatei ro se wataporɨmbo-maranda anɨhondümbo-marɨhundɨ, ŋga se hoafɨmayafɨmunɨ ranɨmbo. Ŋga ro-amboanɨ yɨhoefɨhoarɨ ahandɨ hoafɨ hɨmborɨyahundo hohumboanefɨ asu anɨhondümbo-arɨhurɨ. Ŋga ranɨmboane nindou ndananɨmbo awi hɨfɨ ndanɨhü muŋguambo nindou aboedambo-ndeandürümbui asefɨ,” masei. ");
INSERT INTO agg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sisas ai ranɨhü yimbu nɨmbɨ apu mbura asu ŋgoafɨ ra hɨnɨŋgɨre haya Gariri hɨfɨna mahafu. ");
INSERT INTO agg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Asu ai ahandɨ fimbo hoafɨyuhɨ yahuya, “Godɨndɨ hoafɨ hoafɨyu-randeimbɨ aiana ahandɨ ŋgoafɨ hondühɨ moai ndürɨ yaŋgoro,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ranɨyu asu ai Gariri hɨfɨhü hafu tüküfiyuwane, ahambo hɨhɨfɨ-hɨhɨfɨmayei. Ai ramehindɨ ra moanɨyeipoanɨ, ŋga Serusarem ŋgoafɨhü Israerɨmbo God ai aboedambo-mareandürɨ Pasofa sei-arɨhündɨ ranɨ-sɨmboanɨ afɨndɨ moatükunɨ ramareanda hoeirɨhi hehimbo wamboyei tükümefiyuwa hɨhɨfɨ-hɨhɨfɨmayei. ");
INSERT INTO agg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Asu Sisas ai asükaiyu Kena ŋgoafɨna Gariri hɨfambe mahu horombo ai hoe wain hoembore pureandühɨ. Nindou mamɨ adükarɨ bogorɨndɨ ratüpurɨyu-randeimbɨ ai Kaperneam ŋgoafɨhü nüŋgu hayamboyu, asu ahandɨ nɨmorɨ ranai aŋgünümbomayu. ");
INSERT INTO agg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Asu nindou ranai, Sisas Sudia hɨfɨ hɨnɨŋgɨre haya, Garirinambo sünümboani hoafɨ ra hɨmborɨyu haya, hu tüküfi Sisasɨmbo Kaperneam ŋgoafɨnambo hombo hüti-hütirürühɨ yahuya, “Wandɨ nɨmorɨ ai aŋgünümbo yɨfɨmbo yaŋgɨr-ani, ŋga se dɨdɨfɨ aboedɨndoworɨ,” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Asu Sisas ai yahuya, “Se mamɨkarambo hepünɨfeimbɨ moatükunɨ ra hoeifekoate-yei-mbonana, ŋgɨrɨ anɨhondümbo-rɨhindɨrɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Asu sɨmborɨ Sisasɨmbo hoafɨyundowohü yahuya, “Adükarɨ, mborai se wandɨ süŋgu sühüfɨ, ŋga wandɨ nɨmorɨ ai yɨfɨmbo yaŋgɨr-ani,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Asu Sisas ai sɨmborɨ hoafɨyundowohü yahuya, “Se ŋgafɨsɨ, ŋga sɨhafɨ nɨmorɨ ana asükai yaŋgɨrɨ nüŋgumbui,” mehuamboyu. Nindou ranai Sisasɨndɨ hoafɨ ra anɨhondümbore haya mahu. ");
INSERT INTO agg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nindou ranai ŋgoafɨna mahuamboyu asu ahandɨ ratüpurɨyomo-rundeimbɨ ai nafɨnɨ hoeirüwurɨ houmbo hoafɨyomondowohü yahomoya, “Sɨhafɨ nɨmorɨ ana aboedɨ mbanüŋgu,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Asu ai düdufipurühɨ yahuya, “Nüŋgu-sɨmboanɨyo ai akɨdou aboedɨ safɨ mamarua?” mehuamboemo, asu hoafɨyomondühɨ yahomoya, “Hamanɨ nɨmbambeyo aŋgünɨ hüfɨ afɨndɨ ra hɨnɨŋgɨmareandɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ranɨyu asu afɨndɨ ai ŋgusüfo pumaramündu Sisas ai ahambo ra-sɨmboanɨ hoafɨyundowohüya, “Yɨnɨ, sɨhafɨ nɨmorɨ ana asükai yaŋgɨrɨ nüŋgumbui,” mehu ranɨmbo. Ranɨyu asu ai ahandɨ worambeahɨndɨ ranɨ-babɨdɨmbo anɨhondümbo-marɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Sisas ai Sudianɨpoedɨ Gariri hɨfɨnambo sünümbo hepünɨfeimbɨ moatükunɨ ramareandɨ ra yimbu noufeimbɨyo. ");
INSERT INTO agg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Asu ra muŋgumayoambe Suda-yafe adükarɨ si ra Serusaremɨhü tükümefeyoa, Sisas ai Serusaremɨnambo mahafu. ");
INSERT INTO agg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Serusaremɨhü nafɨtambe adükarɨ ahandɨ ndürɨ sipsip nafɨtambe ranɨkɨmɨ foeamoŋgo hoe kakɨru pumarundɨ. Foeamoŋgo ra Hibruyei hoafɨ Betsada-ane. Hoe ranɨkɨmɨ mboasɨnɨ hondahüfeimbɨ (5) mafondarei. ");
INSERT INTO agg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Asu mboasɨnɨ ranɨ hoarehɨ nindou aŋgünümbɨ afɨndɨ ranai fondɨhü kurɨyei, hɨmboatɨharɨ, yirɨ moaruwaimbɨ, asu nindou ahei tɨŋarɨ yɨfɨyoweimbɨ ranai nɨnoumayei. ");
INSERT INTO agg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mboasɨnɨ ranambe nindou mamɨ ai 38 hɨmbanɨ farasü haya aŋgünümbo yaŋguru. ");
INSERT INTO agg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Asu Sisas ai nindou ranahambo hoeirirane aŋgünümbo meŋguruamboyu, nindou ranana gedühɨ aŋgünümboyumboani yahuhaya hoafɨyundühɨ yahundoya, “Se haponda aboedɨ nɨmandɨ safomboyafɨ?” mehunduamboyu. ");
INSERT INTO agg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Asu sɨmborɨ nindou aŋgünümbɨ-mayu ranai Sisasɨmbo hoafɨyundühɨ yahundoya, “Nindou adükarɨ, hoe ranai mɨmɨnɨyowanɨ hɨmonɨ semɨndɨndɨrɨ ho hɨnɨŋgɨfendɨrɨmbo roana nindou wanɨ. Hoe ranai mɨmɨnɨyowanɨ gadɨ sahehea raoyaheandanɨ asu bɨdɨfɨrɨ ai boatei-anei horombo kosɨrɨhehi hanei rɨhündanane asu ro moanɨ nɨmarɨ arɨhandɨ,” mehundo. ");
INSERT INTO agg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Asu Sisas ai hoafɨyundühɨ yahundoya, “Botɨyafo, sɨhafɨ hoaparɨ ra sowandɨfɨ hawa hafɨ,” mehunduamboyu. ");
INSERT INTO agg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ranɨyu nindou ranai nɨmai hoafɨ nɨŋgoambe botɨfi ahandɨ hoaparɨ ra semündü haya mahu. Ranɨ si ra moanɨ ratüpurɨkoate ŋgoafɨmbo nɨmarɨmbo siyo. ");
INSERT INTO agg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ranɨyomo asu Suda ai nindou Sisas dɨboadomarira botɨmefiyu, ranahambo hoafɨyomondowohü yahomondoya, “Hapoana moanɨ ratüpurɨkoate ŋgoafɨmbo nɨmarambe-ane. Asu nɨmboe se sɨhafɨ hoaparɨ ra sowandɨfɨ hawa ahafa?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Asu sɨmborɨ hoafɨyupurühɨ yahuya, “Nindou wambo aboedɨmareandɨrɨ ranai hoafɨyundɨrühɨ yahuya, ‘Botɨyafo, sɨhafɨ hoaparɨ ra sowandɨfɨ hawa hafɨ,’ mehuamboanahɨ sahamɨndɨ ahahɨ,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ranɨyo asu sɨmborɨ ahambo düdururühɨ yahomondoya, “Düdi nɨmorɨ sɨhambo hoafɨyunɨnühɨ, ‘Sɨhafɨ hoaparɨ ra sowandɨfɨ hawa hafɨ,’ mehunɨnɨ rana?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Asu nindou aŋgünümbɨ aboedɨmefiyu ranai nɨmorehɨ nindowenihɨ afɨndɨ ambewambo Sisas ai sɨhai hümarɨmɨndo ra moai nindou ranahambo fɨfɨrirɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Asükaiyu Sisas ai nindou ranahambo Godɨndɨ worambe mamaruwa hoeirirɨ haya, hoafɨyundühɨ yahuya, “Se hɨmborɨyafɨ, se ndeara sɨhafɨ fi ra aboedɨyafɨmboanafɨ. Ŋga se asükaindafɨ moaruwai hohoanɨmondamboyafɨ. Ŋga asükaindo raranɨ-moatükunɨ ŋgɨnɨndɨ safɨ sɨhafɨfihɨ mbundamɨndoanɨ se mamɨkarɨndamboyafɨ,” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ranɨyu asu nindou-mayu ranai hu Sudambo hoafɨyupurühɨ yahuya, “Nindou wambo aboedɨmareandɨrɨ ranana Sisasɨyu,” mehupuramboyomo. ");
INSERT INTO agg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Asu ranɨyomo Suda ai Sisasɨmbo moanɨ hapoadümbo nou pɨyomo houmbo moruwaimbo-moaruwaimbo-marurɨ homo. Nɨmboe asu Sisas ai moanɨ ŋgoafɨmbo nɨmarombo sihɨ nindou ranahambo aboedɨmarirɨ yahomo houmbo. ");
INSERT INTO agg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ranɨyu asu Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Wandɨ Ape ai ratüpurɨyu humbo hapondan-amboa, ratüpurɨyuhani, ranɨmboane asu ro-amboa ratɨpurayahɨ,” mehupuramboemo. ");
INSERT INTO agg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Suda ai hoafɨ ra hɨmborɨyomo houmbo ahamundɨ ŋgusüfoambe ŋgɨnɨmboanɨmbo-mareapura Sisasɨmbo hɨfokoefimbo yahomo houmbo raraomemo. Asu moanɨ ŋgoafɨmbo nɨmarambe ratüpurɨmayu ranɨmbo yaŋgɨrɨyomopoanɨ. Ŋga ai hoafɨyupurühɨ, “God ana wandɨ Ape hondani,” mehu ranɨmboemo hoafɨ ranana Sisas ai ‘Ro God nahurai-anahɨ’ mehu yahomo houmbo kameihɨyomo ahambo hɨfokoefimbo raraomemo. ");
INSERT INTO agg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ranɨyu Sisas ai sɨmborɨ hoafɨyupurühɨ yahupurɨya, “Ro anɨhondümboanahɨ sɨhamumbo hoafayahapurɨ: Nindou nɨmorɨ ra ŋgɨrɨ raranɨ-moatükunɨ aimbo hohoanɨmondu haya ranɨmbondandɨ, ŋga wanɨ. Ai raranɨ-moatükunɨ ratüpurayu ra Afɨndɨ ai ratɨpurayu ra hoeire hayamboani, asu nɨmorɨ ai ra-süŋgure ratɨpurayu. Muŋgu raranɨ-moatükunɨ Afɨndɨ ai ranɨmborandan-ani asu nɨmorɨ ai yare ranɨmboarandɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Afɨndɨ ai ahandɨ nɨmorɨ ranahambo hohoanɨmoyuhü asu ai muŋgu ratüpurɨyumbü ra nɨmorɨmbo nafuimefuendo. Ŋga asu awi Afɨndɨ ai adükarɨ ŋgɨnɨndɨ ratüpurɨ safɨ amboanɨ nɨmorɨmbo nafuindundümbui. Haponda nafuimendu ranana akɨdouyo, ŋga se hepünɨfembohündambo süŋguna nafuiyondomboayu ranana adükarɨ ŋgɨnɨndɨ safɨndɨmboe. ");
INSERT INTO agg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Afɨndɨ ai nindou yɨfɨyeimbɨhündɨ botɨreandürɨ mbura asu yaŋgɨrɨ nɨŋgo sagadürɨ arandɨ. Ranani asu nɨmorɨ ai-amboanɨ ahandɨ hohoanɨmomayu süŋgureandühɨ nindou botɨreirɨ hɨnɨŋgɨrearü arandɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Moai Afɨndɨ aiana nindou-yafe hohoanɨmo yɨborore randɨ, ŋga wanɨ. Muŋgu ranɨ ratüpurɨ ra nɨmorɨndɨ warɨhümareandane. ");
INSERT INTO agg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ranɨmboanɨmbo asu nindou ai nɨmorɨmbo ahɨnɨndeihɨ aboedɨ hohoanɨmondeimboyei Afɨndambo rawarɨhorɨ nou. Asu nindou ai nɨmorɨmbo ahɨnɨyohü aboedɨ hohoanɨmokoate-ayei ana, asu Afɨndɨ ai nɨmorɨ koamarɨherü ranahambo amboanɨ ŋgɨrɨ ahɨnɨndeihɨ aboedɨ hohoanɨmondei. ");
INSERT INTO agg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ro sɨheimbo anɨhondümboanahɨ hoafayahɨ, nindou düdi wandɨ hoafɨ nda hɨmborɨyuhü asu wambo hɨfɨna koamarɨhendɨrɨ ranahambo anɨhondümbo-arirɨ ana, nindou ranai yaŋgɨrɨ koadürümbo-koadürümbo nüŋgumbui. Asu nindou ranai ŋgɨrɨ Godɨndɨ papɨ-hoafɨ ranambe tükündɨfiyu. Nindou ranai yɨfɨyorambo nafɨ hɨnɨŋgɨre haya yaŋgɨrɨ nɨŋgombo ra süŋgure arandɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yɨnɨ, sapo si tüküfembo-mayo ra ndeara haponda tüküfemboane. Ŋga asu rananɨmbo nindou yɨfɨmayei ranai Godɨndɨ Nɨmorɨndɨ yafambe hɨmborɨndahindühɨ asu nindou dɨdɨyei ahandɨ hoafɨ ndorɨhi hɨmborɨmayei ranai aboedɨ yaŋgɨrɨ yɨfɨkoate nɨmboeimboyei. ");
INSERT INTO agg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ranɨmboani asu Afɨndɨ ai ahandɨhoarɨ aboedɨ yaŋgɨrɨ yɨfɨkoate nɨŋgombo ra nɨmɨndɨyuhüyu, asu ranɨ-süŋgunambo noure Nɨmorɨmbo yaŋgɨrɨ yɨfɨkoate nɨŋgombo nɨmɨndɨmborirɨ hɨnɨŋgɨmarirɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ai Nindou Hond-ani, ranɨyu asu Afɨndɨ ai ahandɨ Nɨmorɨmbo nindoumbo yɨbobofendürɨrambo hohoanɨmo ra masagado. ");
INSERT INTO agg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Asu se ndanahambo hepünahindühɨ afɨndɨ hohoanɨmondeimboyei, ŋga ŋgɨrɨ amɨtata muŋguambo nindou yɨfɨyeimbɨhündɨ hoŋguambeahɨndɨ ranai ahandɨ yafambe ra hɨmborɨndei. ");
INSERT INTO agg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Asu rananɨmbo ai hoŋguambeahɨndɨ tükündahimboyei. Asu nindou ahandɨ hoafɨ aboedɨ hɨmborɨyeihɨ süŋgurɨhi arɨhündɨ ranai aboedɨ yaŋgɨrɨ yɨfɨkoate tükündahi burɨndeimboyei. Ŋga asu nindou ahandɨ hoafɨ hɨmborɨkoate-yeihɨ moaruwai hohoanɨmombo ratüpurɨ ratüpurɨyei arɨhündɨ ai-anɨmbo tükündahinda God ai aheimbo se hüti-anei mbüsümbui.” ");
INSERT INTO agg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Raranɨ-moatükunɨ ra roana ŋgɨrɨ rombondɨhe hohoanɨmonda hehea ratüpurɨndahɨ. Ro nindou aheimbo yɨboborɨhe arɨhandɨ ra God ai hoafiyuwanɨ yaŋgɨr-ane yɨboborɨhe arɨhandɨ. Wandɨ yɨbobofe ra mbumundanesɨ, ŋga ropoanɨmbo yifirɨya hehea yɨboborɨheandürühɨ-yahɨpoanɨ, ŋga Ape wambo hɨfɨna koamarɨhendɨrɨ ranai yifirɨyu haya hoafɨmayundɨr-amboyahɨ ro rarɨhe marɨhandɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Asu ro wandɨhoarɨ yaŋgɨrɨ wandɨ fimbo anɨhondümbo hoafayahɨ ana, asu nindou ai ro wandɨ fimbo hoafayahɨ ra ŋgɨrɨ anɨhondümbo-ndɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ŋga asu ŋgorü ai wambohünda anɨhondümbo hoafɨyu arandɨ ahandɨ hoafɨ ra anɨhondümboani hoafɨyu arandɨ ra ro fɨfɨrɨheandɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Se horombo Sonɨmbo sowana nindou düdufimbo koamarɨhehipura asu ai sɨheimbo anɨhondü hoafɨ hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ŋga nindou yaŋgɨrɨ wambo anɨhondümbo hoafayu ana, ahandɨ hoafɨ ranahambo ro ŋgɨrɨ hohoanɨmondahɨ, ŋga wanɨ. Ŋga God sɨheimbo aboedambo-mbɨreandüra saheheamboanahɨ Sonɨndɨ hoafɨ anɨhond-ane asahɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Son ana ram hai siayo nou yahurai siyuhüyu asu sɨhei fiambe si ranai boakɨmafoa-reiramboyei asu bodɨfohü yaŋgɨrɨ ahandɨ si ranɨmbo hɨhɨfɨ-hɨhɨfɨmbo masei. ");
INSERT INTO agg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ŋga ŋgorü-moatükunɨ sɨheimbo nafuimbohünda ra Sonɨndɨ hoafɨ ŋgasündeandeimb-ane. Raranɨ ratüpurɨ ro ratɨpurayahɨ ra wandɨ Ape ai sendɨrühɨ ‘ratüpurɨndafɨ’ mehuamboanahɨ ro rarɨhe ratɨpurayahɨ. Ranɨ ratüpurɨ ranai sɨheimbo anɨhondümbo nafuimarandürɨ ra Ape ai wambo koamarɨhendɨra makosahɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Asu Ape wambo hɨfɨna koamarɨhendɨrɨ aiyu wandɨ fimbo weindahɨ hoafɨmayu. Asu se moai horombo ahandɨ hoafɨ hɨmborɨyei asu ahambo hoeirɨhorɨ raraorɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ŋga asu se moai ahandɨ hoafɨ ra sɨhei ŋgusüfoambe nɨmarondürɨ, nɨmboe sapo Ape ai koamarɨhendɨra makosahɨ wambo anɨhondümbofe-koate-mayei ranɨmbo. ");
INSERT INTO agg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Se rarɨhi hohoanɨmoyeihɨya, “Godɨndɨ bukambe hoafɨ apenɨŋgo ranai yaŋgɨrɨ koadürümbo-koadürümbo nɨŋgombo sei hehi buk ranambe muŋguambo hoafɨ apenɨŋgo ranahambo türarɨhündɨ. Ŋga bukambeahɨndɨ hoafɨ ra wambo fɨfɨrɨfendɨrɨmbo hoaf-ane apenɨŋgo. ");
INSERT INTO agg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ŋga asu se aboedɨ yaŋgɨrɨ nɨŋgombohündambo wambo sowana moai sɨfombo hohoanɨmoyei. ");
INSERT INTO agg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nindou ai wambo seana nindou adükar-anafɨ mbɨseimboyei saheheamboanahɨ ro moei asahɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ŋga ro sɨheimbo fɨfɨrɨ-hearümboanahɨ, asu sɨhei ŋgusüfoambe Godɨndɨ ŋgusüfo pefe hohoanɨmo ra moai nɨmarondürɨ. ");
INSERT INTO agg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ro wandɨ Apembo sowahɨndɨyahɨ makosahɨ, ŋga asu se moai wandɨ hoafɨ hɨmborɨyei. Asu seana nindou ŋgorü ai aipoanɨmbo hohoanɨmoyu haya ahandɨ ŋgɨnɨndɨ ranambo huan-anei ahandɨ hoafɨ hɨmborayei. ");
INSERT INTO agg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Asu seana sɨheihoar-anei nindou hond-anafɨ nindou hond-anafayei. Ŋga God mamɨ yaŋgɨr-ani ai sɨheimbo nindou hond-anafɨ yahombo ra se moei asei. Ŋga asu se nüŋgundɨhi ahambo anɨhondümbo-mandɨhora? ");
INSERT INTO agg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ŋga asu se ŋgɨrɨ wambo randɨhi hohoanɨmondei, ‘Ai yɨhoefombo Afɨndandɨ hɨmboahü papɨ-hoafɨndamunɨ mbɨsei,’ ŋga wanɨ. Nindou sɨheimbo papɨ-hoafɨmarandürɨ ranana Mosesɨyu. Asu se nindou ranahamboyei aiana yɨhoefɨmbo fandɨhemunümbui masei. ");
INSERT INTO agg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Se Mosesɨndɨ hoafɨ anɨhondümbo-mbarɨhi-mbonana, asu se wandɨ hoafɨ amboanɨ anɨhondümbo-rɨhi. Nɨmboe sapo ai wambo hoafɨ sürü papɨmarandɨ ranɨmbo-hündambo wambo. ");
INSERT INTO agg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Asu ai sürü papɨ-randeimbɨ hoafɨ ra anɨhondümbofe-koate-ayei ana, asu nüŋgundɨhi se wandɨ hoafɨ ra anɨhondümbo-mandɨhia?” mehu. ");
INSERT INTO agg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Sisas ai raraofi mbura ranɨhünda asükaiyu Gariri kurɨhoe sei asu Taiberius sei arɨhündɨ ra barɨhei haya gogoasürünɨ mahu. ");
INSERT INTO agg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Asu nɨmorehɨ nindowenihɨ afɨndɨ ranai Sisasɨmbo hoeirɨhoranɨ hepünɨfeimbɨ moatükunɨ ratüpurɨyuhü nindou aŋgünümboyeimbɨmbo aboedɨrearü marandamboyei, asu ahandɨ süŋgu mahei. ");
INSERT INTO agg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Asu ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo hafu hɨfɨ wafu wamɨ mamaru. ");
INSERT INTO agg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","God ai Israer Isipɨhündɨ aboedambo-mareandürɨ ranɨ adükarɨ si Pasofa ra ndeara akɨmɨ tüküfembo yaŋgɨrɨyowanɨyo. ");
INSERT INTO agg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sisas ai hɨmboarɨyu wakɨreand-ane nindou afɨndɨ ranai ahambo sowana masühüsiamboyu asu Firipɨmbo hoafɨyundühɨ yahuya, “Dagüdambo sɨhɨrɨ sesɨ afɨndɨ ra pemɨndefɨ mbundɨhumbo nindou afɨndɨ asɨhüsi aheimbo mandahundüra?” mehundo. ");
INSERT INTO agg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Sisas ai yare hoafɨmayu ra Firipɨndɨ hohoanɨmo refe hoeifembo-hündamboyu, ŋga ai sesɨ aheimbo segudürɨmbo ra fɨfɨre hayamboyu.) ");
INSERT INTO agg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Asu sɨmborɨ Firip ai ahambo hoafɨyunduhü yahuya, “Nindou ranai sesɨ ra akɨdou-amboanɨ ŋgusüfonambɨrɨhorɨ mbɨsefombo ana, sɨhɨrɨ 1200 kina nahurainambo-anɨmbo sesɨ ra pemɨndefɨ koandɨhehumboyefɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Ahambo süŋgurirɨ-randeimbɨ nindou ŋgorü Andru, Saimon Pitandɨ akɨdɨ ai hoafɨyuhɨ yahuya, “Nindou mamɨ hoarɨfɨ ndanai bari bret hondahüyafundeimb-anemo asu kinɨ yimbu-anafanɨ ra sɨhaiamboani. Ŋga sesɨ ranana ŋgɨrɨ nindou afɨndɨ ra sɨmoŋgorɨndei,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Asu Sisas ai hoafɨyupurühɨ yahuya, “Nindou aheimbo sowandümondündürɨ sɨfomo hoafɨyomonda mbɨmari,” mehu. Ranühɨ wohɨ afɨndɨ ra furɨmayowamboyei ranɨwamɨ nɨnoumayei. Nindou ra 5,000-yei. ");
INSERT INTO agg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ranɨyu Sisas ai bret ra semündühaya Godɨmbo hɨhɨfɨrürɨ mbura asu nindou afɨndɨ nɨnoumayei aheimbo yimbumareandürɨ. Asükaiyu kinɨ ra ranou-ranou-mareandüramboyei asu sesɨ ra ai sesɨmbo hohoanɨmomayei sɨmogodühɨ masahüsi. ");
INSERT INTO agg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ai sesɨ ra sahüsimbo ndeara bodomayeiamboyu, Sisas ai ahandɨ süŋgururü-rundeimbɨmbo hoafɨyupurühɨ yahuya, “Ai sahüsimbü bɨdɨfɨrɨ-bɨdɨfɨrɨ kurayo ra fufuründümo, ŋga akɨdou bɨdɨfɨrɨ amboanɨyeimbɨpoanɨ,” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ranɨyomo asu ai bari bret hondahüyafundeimbɨ akɨdɨbou-mayo ranahandambo ai sahüsimbü bɨdɨfɨrɨ kurɨmayo ra fufuründümo 12 wambürɨ tütükɨru manindundɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ranɨyei asu nindou afɨndɨ nɨnou-mayei ranai Sisas hepünɨfeimbɨ moatükunɨ ramareandɨ ra hoeirɨhi hehi hoafɨyeihɨ seiya, “Yɨnɨ, anɨhond-ane, sapo nindou ndanana Godɨndɨ hoafɨ hoafɨyu-randeimbɨ hɨfɨna kosombo-mayu ranɨmbai,” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Asu nindou ranai ndeara ahambo sɨfo semündü hefimbo adükarɨ bogorɨmbofi hüti-hütifi hɨnɨŋgɨfimbo maseiamboyu Sisas ai fɨfɨre haya asükaiyu hɨfɨ wafu ranɨwamɨ nɨmarɨmbo ahand-amboanɨ mahafu. ");
INSERT INTO agg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ranɨyomo asu nɨmbambe ahambo süŋgururü-rundeimbɨ ai Gariri kurɨhoe ranɨnambo mahanɨmo. ");
INSERT INTO agg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Asu nɨmbɨmareandamboyu Sisas ai moai ahamumbo sowahɨ tüküfiyu. Ai hanɨmo botambe kefou houmbo gogoanɨnɨ barɨhou houmbo Kaperneam ŋgoafɨ naŋgowaneimbɨ mahafomo. ");
INSERT INTO agg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Raoyafundane asu werɨ afɨndɨ ranai werɨyowohüyo hoe ranai fondamɨndɨ hanɨ hafo marandɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ranɨyomo süŋgururü-rundeimbɨ ai ahamund-amboanɨ botɨ-mayo ranambe purɨnambo puru hɨfomombo 5-mbayo asu 6-mbayo kiromita sɨmogodühɨyomondühɨ asu hɨmboyomondane, Sisas ai bot ranɨkɨmɨ nɨmoamo hoe haŋgɨfo wamɨ pühɨyu mara sünüwamboemo asu ai afɨndɨ yɨhɨmbomemo. ");
INSERT INTO agg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Asu Sisas ai hoafɨyupurühɨ yahuya, “Se nɨmboe yɨhɨmboemoa, ŋga roanahɨ ndanana,” mehupuramboemo. ");
INSERT INTO agg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Asu ranɨyomo ai ahambo botambe semündü hɨnɨŋgɨfimbo yahomo houmbo ramefundamboyo asu bot ranai ai hombomemo ranɨnambo nɨmai ho tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Asükaiyei siambe nindou afɨndɨ ranai Gariri kurɨhoe gogoanɨnɨ mamarei. Ai fɨfɨrɨhindɨ hamanɨ bot mamɨ yaŋgɨrɨ ranɨhü meŋgoro asu Sisas ana moai ahambo süŋgururü-rundeimbɨ babɨdɨmbo bot ranambe hüfu, ŋga ahambo hɨnɨŋgɨrüwurɨ houmbo ai yaŋgɨrɨyomo mahɨfomo sei hehi mamarei. ");
INSERT INTO agg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Asu bot bɨdɨfɨrɨ Taibiriasɨ-yafe-mayo ranai Sisas Godɨmbo hɨhɨfɨrürɨ mbura bret sahüsihɨ sɨnei tükümehindɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Asu ai hɨmboyeiane Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo ranɨhü nɨmarɨkoate-memondamboyei asu ai bot ranambe farɨyahi hehi Kaperneam ŋgoafɨna Sisasɨmbo kokombo mahüsi. ");
INSERT INTO agg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Asu nindou afɨndɨmayei ranai Sisasɨmbo kurɨhoe gogoasürünɨ manüŋgua hoeirɨhorɨ hehi, hoafɨyahündowohü seiya, “Yamundo-randeimbɨ, se nüŋgu-sɨmboanɨ ndanɨhü sühüfɨmboyafa?” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Asu sɨmborɨ Sisas ai aheimbo hoafɨyundürühɨ yahuya, “Se nɨmboe wambo kokoarɨhündɨra? Se bret afɨndɨ sahüsimbo sɨmoŋgorɨ-marɨhümündi ranɨmboyei wambo kokomarɨhündɨrɨ sühüsi. Ŋga asu se ro hepünɨfeimbɨ moatükunɨ ramarɨheandɨ ranɨmbo fɨfɨrɨhi hoeirɨhi hehimboyeipoanɨ wambo kokomarɨhündɨrɨ sühüsi nda. ");
INSERT INTO agg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Se sesɨ sümburüyo arandɨ ranahambo hohoanɨmondeihɨ ratüpurɨ-ndeimboyei, ŋga se yaŋgɨrɨ koadürümbo-koadürümbo nɨŋgombo sesɨ ranahambo-anɨmbo hohoanɨmondeihɨ ratüpurɨndei ndühündɨ. Sesɨ ra sɨheimbo Nindou Hondü ai dagadürɨmbui, sapo God ai ranɨ ranɨmbo-hünda ahambo ŋgɨnɨndɨ masagado-ane,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Asu nindou ranai ahambo düdurɨhorühɨ seiya, “Asu ro nüŋgundɨhu ratüpurɨmandefɨ Godɨndɨ ratüpurɨ yaŋgɨrɨ ratüpurɨmbo rana?” masahündowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Asu sɨmborɨ Sisas ai hoafɨyundürühɨ yahuya, “God ai sɨheimbo ratüpurɨ ndanɨmboyu ndandɨhi ratüpurɨndei mehu: Nindou ndanahambo hɨfɨna koamarɨhehinɨ ahambo anambo anɨhondümbo-ndɨhorɨ,” mehundüramboyei. ");
INSERT INTO agg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Asu sɨmborɨ düdurohorühɨ sahündoya, “Se nɨnɨ hepünɨfeimbɨ moatükunɨ randowandanɨ hoeindɨhunɨnɨ houhumbo God koamarɨhenɨn-ane mbɨsefɨ sɨhambo anɨhondümbo-mandɨhunɨna? Asu se nɨnɨ ratüpurɨ ratüpurɨmbo safomboyafa? ");
INSERT INTO agg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sɨhefɨ amoao horombo sesɨ mana masahüsi nɨmɨ wohɨ furɨkoate-reandühɨ. Baiborambe yare hoafɨyowohü yahoya, ‘Ai sesɨ nɨmoamo sünambeahɨndɨ semündü haya sesɨmbo masagadürɨ’ meho nou,” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Asu Sisas ai hoafɨyundürühɨ yahuya, “Yɨnɨsɨ, ŋga ro sɨheimbo anɨhondümboanahɨ hoafayahɨ, Moses ai moai sɨheimbo sünambeahɨndɨ sesɨ sagadürɨ, ŋga wandɨ Ape aiyu sesɨ hondü sünambeahɨndɨ ra masagadürɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sesɨ God ai masendɨ ranana sünambeahɨndɨ kosɨ hɨfɨ ndanɨhü nindoumbo yaŋgɨrɨ nɨŋgombo segudürɨmboane,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Asu nindou-mayei ranai Sisasɨmbo hoafɨyahündowohü sahündoya, “Adükarɨ, muŋguambo si yɨhoefɨmbo sesɨ rananɨmbo ndawamunɨ ndandɨ,” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Asu Sisas ai hoafɨyundürühɨ yahuya, “Ro sesɨ yaŋgɨrɨ nɨŋgombo nɨmɨnd-anahɨ. Nindou ai wambo anɨhondümbo-reandɨrühɨ asünu ana, ŋgɨrɨ wembombondu asu amɨndanɨŋombondu ndandɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ro sɨheimbo horombo hoafɨmayahandürɨ, se wambo hoeirɨhindɨrɨ, ŋga asu moai anɨhondümbo-rɨhindɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Muŋguambo nindou wandɨ Ape ai wandɨ warɨhümareandürɨ ranai ana wambo sowana dügüsimboyei. Asu nindou düdi wambo sowanambo asüfu ranahambo ro ŋgɨrɨ yowanɨ mbɨsahɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ro sünambeahɨndɨ makosahɨ nda wandɨ hohoanɨmo süŋgufembo-yahɨpoanɨ. Ŋga ro makosahɨ nda nɨne hohoanɨmo Ape yifirayu ranɨ hohoanɨmo süŋgufemboyahɨ makosahɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ai wambo koamarɨhendɨra makosahɨ ahandɨ hohoanɨmo ra ndahurai-ane. Muŋguambo nindou Ape ai wandɨ warɨhümareandürɨ ra ŋgɨrɨ mam-amboanɨ bodɨboadɨhinɨ, ŋga bɨdɨfɨranɨ si tüküfeyoambe muŋguambo botɨndɨhea-ndürɨmboyahɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Apendɨ hohoanɨmo ai ndahurai-ane, muŋguambo nindou ranai Nɨmorɨ ranahambo hoeirɨhorühɨ ahambo anɨhondümbo-arɨhorɨ ana, asu ai yaŋgɨrɨ koadürümbo-koadürümbo nɨboadeimboyei. Asu rananɨmbo ro nindou ranahambo bɨdɨrɨfanɨ si tüküfeyoambe botɨndɨhinɨmboyahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ranɨyei asu Suda ai Sisasɨmbo ŋgɨnɨndɨrɨhorühɨ tehümarɨhorɨ ai hoafɨyuhɨya, ‘Roana yaŋgɨrɨ nɨŋgombo sesɨ nɨmɨnd-anahɨ sünambeahɨndɨ makosahɨ,’ mehu ranɨmbo. ");
INSERT INTO agg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ranɨyei asu hoafɨyahündowohü seiya, “Nindou ndanana Sisas Sosepɨndɨ nɨmor-ani. Ahandɨ hondafɨndɨ ana ro fɨfɨrɨhu-pɨrɨmboanefɨsɨ. Asu ai nɨnüŋgufi hayamboyu ro sünambeahɨndɨ makosah-anahɨ mehua?” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Asu Sisas ai hoafɨyundürühɨ yahuya, “Ŋgɨrɨ se sɨheihoarɨ tehündɨhündɨ, ŋga se hɨnɨŋgɨndɨhi hehimbo moanɨ nɨmandei. ");
INSERT INTO agg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nindou mamɨ ai-amboanɨ ŋgɨrɨ aimbo hohoanɨmondu haya wambo sowana ŋgu. Ŋga wandɨ Ape wambo koamarɨhendɨrɨ ai ahambo wambo sowana koandɨheiranɨ ŋguwanɨ asu ro ahambo hɨfɨ nda muŋguyoambe aboedɨ yaŋgɨrɨ nɨŋgombohünda botɨndɨhinɨmboyahɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Horombo Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ ai yaru bukambe sürü papɨrundühɨ yahomoya, ‘God ai nindou muŋguambo yamundeandürɨmbui,’ mehomo. Asu muŋgu ai Apendɨ hoafɨ hɨmborɨyeihɨ ahandɨ warambeahɨndɨ fɨfɨrɨfe ra asahümündi ana, ai wambo sowana dügüsimboyei. ");
INSERT INTO agg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Asu nindou mamɨ ai-amboanɨ moai Godɨmbo ahandɨ hɨmboarɨnambo hoeirirɨ, ŋga nindou Godɨndɨ-mayu makusu ranɨ yaŋgɨrɨyu Godɨmbo hoeimarirɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ro sɨhamumbo anɨhondümboanahɨ hoafayahapurɨ, nindou düdi wambo anɨhondümbo-areandɨrɨ ana, ai yaŋgɨrɨ koadürümbo-koadürümbo nüŋgumbui. ");
INSERT INTO agg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Roana yaŋgɨrɨ nɨŋgombo sesɨ ra nɨmɨnd-anahɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Horombo sɨhei amoao sesɨ ahandɨ ndürɨ mana ra nɨmɨ wohɨ furɨkoate-yowohü masahüsi, ŋga asu ai moai nɨboadei, ŋga ranɨ sesɨ ra sahüsi mburɨhümbo yɨfɨmayei. ");
INSERT INTO agg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ŋga roana sesɨ sünambeahɨndɨ makosah-ane, nindou düdi asesu aiana ŋgɨrɨ yɨfɨndu, ŋga aboedɨ nüŋgumbui. ");
INSERT INTO agg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Roana sesɨ koadürümbo nɨŋgo-randeimbɨ sünambeahɨndɨ makoso rananahɨ nda. Asu nindou ai sesɨ nda asesu ana, ai yaŋgɨrɨ koadürümbo koadürümbo nüŋgumbui. Sesɨ nda ro ndahandürɨmboyahɨ ra wandɨ fi safɨ ranane, nindou hɨfɨ ndanɨhü anɨboadei ai aboedɨ yaŋgɨrɨ koadürümbo koadürümbo mbɨnɨboadeia samboanahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ranɨmboyei asu Suda ai aheihoarɨ ŋgɨnɨndɨ yifiarɨmbo hoafɨ tɨmonɨmarɨhündɨ. Asu ai hoafɨyeihɨ seiya, “Nüŋgunde nindou ndanai ahandɨ fi safɨ ra ndenda madagudifa?” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Asu Sisas ai aheimbo hoafɨyundürühɨ yahuya, “Yɨnɨ, asu se Nindou Hondündɨ-mayo fisafɨ ra sesɨ asu ahandɨ horɨ ra sɨmɨndɨ ra-koate-ayei ana, ŋgɨrɨ sɨhei fiambe koadürümbo-koadürümbo nɨŋgombo ra nɨmandondürɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nindou ranai wandɨ safɨ asu horɨ ra sesü sümündɨ arandɨ ana, ai yaŋgɨrɨ koadürümbo-koadürümbo nüŋguwanɨ, asu ro ahambo hɨfɨ nda muŋguyowambe botɨndɨhinɨmboyahɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wandɨ safɨ nda aboedɨ sesɨ hond-ane, asu wandɨ horɨ nda aboedɨ sɨmɨndɨ hoe hond-ane. ");
INSERT INTO agg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nindou ranai wandɨ safɨ sesü asu wandɨ horɨ sümündɨ arandɨ ana, ro ai-dɨbo nɨmandɨhanɨ asu ai ro-dɨbo nɨmandümbui. ");
INSERT INTO agg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ape koadürümbo nüŋgumbü ai wambo koamarɨhendɨrambo kosɨ ahandɨ ŋgɨnɨndɨnambo anɨmboahɨ ra ai nɨmɨndüh-ani. Ranɨ süŋgunamboane asu nindou ranai wambo asesundɨrɨ aiana wandɨ-mayo yaŋgɨrɨ nɨŋgombo ra ndemündümbui. ");
INSERT INTO agg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ranɨmboane asu, sesɨ ndanana sünambeahɨndɨ makoso-ane. Ŋga sesɨ ra horombo sɨhei amoamo sahüsi hehimbo yɨfɨmayei yahuraiyopoanɨ, ŋga wanɨ. Ŋga sesɨ hapondadɨdɨ nda nindou ai asesu ana, ai aboedɨ yaŋgɨrɨ koadürümbo-koadürümbo nüŋgumboani,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Hoafɨ nda Sisas ai Kaperneam ŋgoafɨhü Sudayei rotu worambe nindou yamundeandürühɨ hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ranɨyo asu ahambo süŋgururü-rundeimbɨ afɨndɨ ranai hoafɨ ra hɨmborɨyomo houmbo hoafɨyomondühɨ yahomoya, “Hoafɨ ndanana awi afɨndɨ tüŋgümb-ane. Hoafɨ ra dɨdɨ hɨmborɨmandü rana?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Asu Sisas aimbo ŋgusüfoambe hohoanɨmoyu fɨfɨre haya hoafɨyuhɨ yahuya ndanana hoafɨ ndanahamboanemo teihümarundɨ yahu haya, hoafɨyupurühɨ yahuya, “Hoafɨ nda sɨhamundɨ anɨhondümbofe ra mamɨkarɨ-marapuramboemoa? ");
INSERT INTO agg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Asu Nindou Hondü sünambeahɨndɨ makusu ranai hoeindüranɨ asükaindu horombo nɨmaruwanambo gafuwanɨ ra se nüŋgundahumbo yahomomboemo? ");
INSERT INTO agg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yifiafɨ Aboedɨ ranane yaŋgɨrɨ nɨŋgombo sai arandɨ. Ŋga nindou-yafe ŋgɨnɨndɨ ranana moai yaŋgɨrɨ nɨŋgombo sai randɨ. Hoafɨ sɨheimbo hoafɨmayahandürɨ ranana Yifiafɨ yaŋgɨrɨ nɨŋgo sai-randeimbɨ ranahamboyahɨ hoafɨmayahɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Rananemo asu moai bɨdɨfɨrɨ se-amboanɨ hoafɨ ranahambo anɨhondümbo-rundɨ,” mehu. (Sisas ai nindou horombo ahambo anɨhondümbofe-koate-mayei ra fɨfɨreandɨ. Asu ai fɨfɨreandɨ nindou ranai-anɨmbo ahambo hürütümbɨ nindou-yomondɨ warɨhündirümbui.) ");
INSERT INTO agg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ranɨyu asu hoafɨyuhɨ yahuya, “Hoafɨ nɨmɨndɨ ndanahamboyahɨ ro sɨhamumbo hoafɨmayahapurɨ, ‘Ape ai nindou ranahambo wambo sowanambo sɨfombo yɨnɨ yahokoate-ayu ana, asu nindou ranai ŋgɨrɨ wambo sowana düfu,’” mehu. ");
INSERT INTO agg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hoafɨ ra hɨmborɨyomo mburumboemo asu ahambo süŋgururü-rundeimbɨ bɨdɨfɨrɨ ai ahandɨ süŋgu hokoate hɨnɨŋgɨrüwurɨ houmbo hɨhɨrɨyafu mahomo. ");
INSERT INTO agg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ranɨyu asu Sisas ai ahambo süŋgururü-rundeimbɨ 12 ahamumbo hoafɨyupurühɨ yahuya, “Asu se-amboanɨ wambo hɨnɨŋgɨfendɨrɨ hefe hombo yahomomboemo?” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Asu Saimon Pita ai sɨmborɨ hoafɨyuhɨ yahuya, “Adükarɨ, asu ro dabo sowana maŋgefa? Seana sapo aboedɨ yaŋgɨrɨ koadürümbo-koadürümbo nɨŋgombo hoafɨ ra sowandɨfɨ-mboanafɨsɨ. ");
INSERT INTO agg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Asu ro haponda sɨhambo anɨhondümbo-rɨhu fɨfɨrɨ-hunɨnɨmboanefɨ, seana Nindou sürühoeimbɨ Godɨndɨ-mayafɨ makosaf-anafɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Asu sɨmborɨ Sisas ai yahuya, “Nɨmboe sapo süŋguru-rundeimbɨ 12 sɨhamumbo ro kamafoarɨheapur-ane. Ŋga sɨhamundɨ mbusümo nindou mamɨ ranai ana moaruwai hohoanɨmoyumb-ani,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hoafɨ nda Sisas ai Sudas Saimon Iskariotɨndɨ nɨmorɨ ahamboyu yare hürühai hoafɨmayu. Aiana Sisasɨmbo süŋgurürɨ-randeimbɨyusɨ, ŋga asu süŋguna humboyu Sisasɨmbo hürütümbɨ-yomondɨ warɨhündirümbui. ");
INSERT INTO agg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Refehayamboyoane, Sisas ai Gariri hɨfambe hoahoaŋgu wakɨmareandɨ. Suda-yafe bogorɨ ai ahambo hɨfokoefimbo yahomo houmbo raraomemondamboyu asu ai ahei hɨfambe hombo moei mehu. ");
INSERT INTO agg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Asu Suda-yafe rotumbo si adükarɨ dagoambe nɨmarɨmbo sei arɨhündɨ ranai ndeara akɨmɨ tɨfɨmareandamboemo. ");
INSERT INTO agg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Asu Sisasɨndɨ akohoandɨ mamɨ ai ahambo hoafɨyomondowohü yahomoya, “Hɨfɨ nda hɨnɨŋgɨro hawambo Suda-yafe hɨfɨnambo hahüfüh-anɨmbo, se sɨhafɨ hepünɨfeimbɨ moatükunɨ rarowandanɨ sɨhafɨ süŋgurɨnɨnɨ-rundeimbɨ ranai hoeimbɨrundamboane. ");
INSERT INTO agg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nindou ranai muŋgu ahambo fɨfɨrɨmbɨrɨhi-ndɨramboane yahumbo ana, moai dɨbo raranɨ ratüpurɨ ratüpurɨyu randɨ, ŋga weindah-ani ahei hɨmboahü ratüpurɨyu arandɨ. Asu se hepünɨfeimbɨ moatükunɨ ratüpurayafɨ ra muŋguambo nindou hɨfɨ-hɨfɨ afɨndɨ burayei ahei hɨmboahü weindahɨ nɨmbafan-anɨmbo, asu ai sɨhambo hoeimbɨrɨ-hinɨn-amboane,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ahandɨ akɨdɨmamɨ amboanɨ ahambo anɨhondümbofe-koate-wamboemo ai yaru hoafɨmemondo. ");
INSERT INTO agg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ranɨyu asu Sisas ai hoafɨyupurühɨ yahuya, “Awi ro hafombo si ranana moai tüküfeyo. Ŋga nɨnɨ-sɨmboanɨyo se ahafomo ra waŋgei-ane. ");
INSERT INTO agg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nindou hɨfɨ ndanɨhü anɨboadei aiana ŋgɨrɨ sɨhamumbo hürütündühüpurɨ, ŋga wambo hürütarɨhündɨrɨ ro aheimbo moaruwai hohoanɨmoyei arɨhündɨ ranɨmbo weindahɨ hoafɨyahandürɨ arɨhandɨ ranɨmbo. ");
INSERT INTO agg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Seana Suda-yafe adükarɨ si Serusaremɨhü tükefeyo ranɨmbo gafomo. Ŋga roana wandɨ hafombo si ra awi tüküfekoate-mayowambo, asu ŋgɨrɨ haponda ŋgahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ai ahamumbo yare hoafɨyupurɨ mbura Garirihɨ mamaru. ");
INSERT INTO agg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ahandɨ akohoandɨ mamɨ ai adükarɨ si ra hoeifembo mahomondamboyu, asu ai-amboanɨ süŋguna mahu. Asu ai moai weindahɨ tüküfi haya hu, ŋga dɨbo ahamundɨ süŋgu mahu. ");
INSERT INTO agg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Asu Sudahündɨ nindou bogorɨ-memo ranai Sisasɨmbo adükarɨ si ranɨhü kokorurühɨ yahomoya, “Nindou ra nahü nüŋgua?” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ranɨyei nindou afɨndɨ meŋgoro ranɨ-sɨmboanɨ Sisasɨmbo-dɨbo teihümarɨhorɨ. Bɨdɨfɨrɨ ai seiya, “Aiana nindou aboed-ani,” asu bɨdɨfɨrɨ ai seiya, “Wanɨ, aiana aboedɨyupoanɨ, ŋga aheimbo wosɨhoaforɨ hoafɨyu-randeimb-ani,” masahündo. ");
INSERT INTO agg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ŋga Suda-yafe bogorɨ nindou ranahamumbo yɨhɨmborɨhüpurühɨ asu moai ahambo weindahɨ yafambe farɨhi hoafɨyei. ");
INSERT INTO agg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Adükarɨ si mbusümondühɨ Sisas ai tüküfi hafu Godɨndɨ worɨkɨmɨ nüŋgumbo nɨmorehɨ nindowenihɨ aheimbo yamundɨ-mareandürɨ. ");
INSERT INTO agg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Asu Suda ai ahandɨ hoafɨ ranahambo hepünafu afɨndɨ hohoanɨmoyomondühɨ yahomoya, “Nɨmboe nindou nda nindou ŋgorü ai yamundɨfikoate asu ai moanɨ hoafɨ nda fɨfɨrareanda?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Asu sɨmborɨ ahamumbo hoafɨyuhɨ yahuya “Ro haponda yamundarɨheandürɨ hoafɨ nda wandɨ-mayo yamundɨfe hoafɨyopoanɨ, ŋga Nindou wambo hɨfɨna koamarɨhendɨrɨ ahandɨ-mayo-ane. ");
INSERT INTO agg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Asu nindou ranai Godɨndɨ hoafɨ süŋgumbo yifirayei ana, ro hoafɨ hoafɨya arɨhandɨ nɨmɨndɨ nda fɨfɨrɨndɨhimboyei. Asu ai hoafɨ nda Godɨndɨ-mayo-mbayo asu ro wandɨ hohoanɨmonambo hohoanɨmoya hehea hoafɨyahühɨ-mbayahɨyo ra fɨfɨrɨndeambui. ");
INSERT INTO agg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nindou ai moanɨ ahandɨ hohoanɨmonambo hohoanɨmoyu haya hoafayu ranana ai adükarɨ ndürümbɨnda yahumboani. Ŋga asu nindou ŋgorü ahambo koamarɨherü ranahambo ‘ndürɨ adükarümbɨ-mbiyu’ ehu ranai ana aboedɨ mbumundɨ saf-ani, ŋga moai tɨkai hoafɨyu randɨ. ");
INSERT INTO agg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Horombo sɨhefɨ amoaombo Moses ai ahɨnümbɨ hohoanɨmo ra masagadürɨ. Ŋga asu moai se mam-amboanɨ hohoanɨmo ra süŋgurɨhindɨ. Asu nɨmboe se wambo hɨfokoefe-ndɨrɨmbo yahomo houmbo rarawemoa?” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Asu nindou afɨndɨ burɨmayei ranai seiya, “Moaruwai nendɨ sɨhafɨ fiambe mafarɨfeyowamboyafɨ ranɨ hoafɨ ra hoafayafɨ. Düdi sɨhambo hɨfokoefenɨnɨmbo yahuhaya raraomayua?” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Asu Sisas ai sɨmborɨ hoafɨyundürühɨ yahuya, “Ro ŋgoafɨmbo nɨmarɨmbo sihɨ ratüpurɨyahühɨ nindou dɨboadomarɨhina ranɨmboyei se muŋguambo mahepünehindɨ. ");
INSERT INTO agg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Horombo sɨheimbo Moses ai hoearɨ kefe tɨrɨheferambo hohoanɨmo ra nafuimarandürɨ. (Ranɨ hohoanɨmo ranana Mosesɨndɨ-mayo hohoanɨmoyopoanɨ. Ŋga ranana sɨhei amoao-yafe hohoanɨmoane.) Ranɨmboane asu seana ŋgoafɨmbo nɨmarɨmbo si ranɨfihɨ nindowenihɨ nɨmoakɨdɨbou-yomondɨ fi hoearɨ karu tɨrɨhoemo arundɨ. ");
INSERT INTO agg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Seana Mosesɨndɨ hoafɨ ranɨ yaŋgɨr-ane ranɨ-süŋgurundühɨ asu se ŋgoafɨmbo nɨmarɨmbo sihɨ nɨmoakɨdɨbou-yomondɨ hoearɨ karu tɨrɨhapurɨ arundɨ. Asu ro ŋgoafɨmbo nɨmarɨmbo sihɨ nindou aŋgünümbo-mayu ahandɨ fi dɨdɨboado-marɨhina, asu se nɨmboe wambo ŋgɨnɨndɨmarundɨra? ");
INSERT INTO agg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Asu nindou ŋgoründɨ hohoanɨmo ra se hɨmboarɨnambo yaŋgɨrɨ hoeindu houmbo yɨbobondümboemo, ŋga se mbumundɨ hohoanɨmo süŋgundundühɨ ndondu yɨbobondundɨ,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Asu nindou bɨdɨfɨrɨ Serusaremɨhündɨ ai düduyahindühɨ seiya, “Sapo nindou ndanahamboemo bogorɨ nindou ai hɨfokoefimbo yahomo houmbo raraomarüwura? ");
INSERT INTO agg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nindou ra ai weindahɨ ahamundɨ hɨmboarühɨ hoafɨmayuwambo hoeirɨhorɨ asu hɨmborɨyei arɨhündɨ, ŋga ai moai ahambo hoafɨ karüwurɨ. Awi nindou ranahambo bogorɨ nindou ai Krais-ani yahomo hohoanɨmoyomo houmbombemoyo? ");
INSERT INTO agg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nindou God ai dɨbonɨyu hɨnɨŋgɨmarirɨ Krais ra tükefiyu ana, ŋgɨrɨ nindou ai ahandɨ ŋgoafɨ ra fɨfɨrɨndɨhindɨ. Ŋga roana nindou ndanahandɨ ŋgoafɨ hondü ra fɨfɨrɨhurümboanefɨ ranɨmboyu ai Kraisɨyupoanɨ,” masei. ");
INSERT INTO agg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Asu Sisas ai Godɨndɨ worambe aheimbo yamundeandürühɨ puküna hoafɨyuhɨ yahuya, “Se wambo asu wandɨ ŋgoafɨ ro masɨhühɨ ra ndorɨhi fɨfɨrɨhindɨrɨ. Ŋga ro, wandɨpoanɨmbo hohoanɨmoya hehea kosamboyahɨpoanɨ, ŋga Ape wambo koamarɨhendɨra makosahane. Seana moai ahambo fɨfɨrɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ŋga roana ahambo sowahɨndɨ koamarɨhendɨra kosɨheheambo wambo fɨfɨrɨhinɨmboanahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ranɨyomo asu bɨdɨfɨrɨ ai ahambo kɨkɨhimündɨmbo yahomo houmbo raraomarürɨ. Ŋga asu nindou ŋgorü ai moai ahambo kɨkɨhɨrümündu sapo ahambo hɨfokoefimbo si ra awi tüküfekoate-mayowambo. ");
INSERT INTO agg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ranɨyei nɨmorehɨ nindowenihɨ afɨndɨ ranai ahambo anɨhondümbo-rɨhorühɨ hoafɨyeihɨ seiya, “Krais tükefiyu ana, ŋgɨrɨ Sisas hepünɨfeimbɨ moatükunɨ ramareandɨ nda ŋgasündirɨ. Ŋga ai Kraisɨmbeyu?” masei. ");
INSERT INTO agg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisi ai nɨmorehɨ nindowenihɨ Sisasɨmbo ranɨ wataporɨmayei ra hɨmborɨyomo houmbo Godɨmbo sesɨ sɨhou-rundeimbɨ bogorɨ-babɨdɨmbo prisman bɨdɨfɨrambo koamarɨhoupura Sisasɨmbo kɨkɨhimɨndɨmbo mahɨfomo. ");
INSERT INTO agg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Asu Sisas ai hoafɨyupurühɨ yahuya, “Awi se-babɨdɨmbo akɨdou gedühɨ safɨ nɨŋgo-nɨŋgondahe heambo-anɨmbo asu ro nindou wambo koamarɨhendɨrɨ ahambo sowana gagümboyahɨ. ");
INSERT INTO agg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Rananɨmbo se wambo kokondɨhündɨrɨmboyeisɨ, ŋga asu ŋgɨrɨ hoeindɨhindɨrɨ. Asu ro nɨmarɨmboayahɨ ranambe se ŋgɨrɨ dɨdei,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ranɨyomo Sudahündɨ bogorɨ nindou-memo ranai ahamundɨhoarɨ sɨmborɨ hoafürüyomondühɨ yahomoya, “Nindou ra ai nahanafɨ ŋguanɨ kokondɨhurɨmbo hoeifekoate-mandefa? Asu ai Grikɨ-yomondɨ ŋgoafɨ adükarɨ ranɨhü ŋgu sɨhefɨ nendɨ nɨmareihü Grikɨmbo hoafɨ yamundɨ-mandeandürɨyo? ");
INSERT INTO agg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ai yare hoafɨyuhɨ yahuya, ‘Se wambo kokondɨ-hündɨrɨmboyei, ŋga asu se ŋgɨrɨ hoeindɨhindɨrɨ,’ asu ‘Se ro nɨmarɨmboayahɨ ranambe ŋgɨrɨ ŋgei,’ mehu, ra nɨmboe yare hoafɨmayua?” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Suda-yafe amoao-yomondɨ dagoambe nɨmarɨmbo hohoanɨmombo si ranahandɨ bɨdɨfɨranɨ si ra adükarɨ hamɨnd-ane. Ranɨ sihɨ Sisas ai botɨfi puküna hoafɨyundürühɨ yahuya, “Nindou dɨdɨyei ai hoe sɨmɨndɨmbo amɨndanɨŋombondeihɨ ana, wambo sowana dɨdei ndɨmɨndei. ");
INSERT INTO agg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ai Godɨndɨ bukambe yare hoafɨyowohü yahoya, ‘Nindou ranai wambo anɨhondümbo-arɨhindɨrɨ ana, asu ahei ŋgusüfoambeahɨndɨ yaŋgɨrɨ nɨŋgombo hoe ranai afɨndɨ tükündɨfe haya ŋgomboe,’” mehu. ");
INSERT INTO agg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sisas ai yare hoafɨmayu ra hoe hondümboyupoanɨ, ŋga Yifiafɨ Aboedɨ ranahamboyu hoafɨmayu. Nindou ai ahambo anɨhondümbo-arɨhorɨ ai-anɨmbo Yifiafɨ Aboedɨ ra ndahümündimboyei. Ŋga ranɨ sɨmboanɨ ana Yifiafɨ Aboedɨ ra awi moai sahümündi Sisas ai yɨfɨyo mburümbo sünambe hafokoate wambo. ");
INSERT INTO agg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nindou afɨndɨ mafandɨhindɨ ranambe nindou bɨdɨfɨrɨ ai Sisas hoafɨmayu ra hɨmborɨyei hehi hoafɨyeihɨ seiya, “Anɨhond-ane, nindou ndanana Godɨndɨ hoafɨ hoafɨyu-randeimb-ani,” masei. ");
INSERT INTO agg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Asu bɨdɨfɨrɨ ai hoafɨyeihɨ seiya, “Aiana Krais nindou aboedambo-fembo God kafoarirɨ hɨnɨŋgɨmarir-ani,” sei, ŋga asu bɨdɨfɨrɨ ai hoafɨyeihɨ seiya, “Ai Kraisɨyupoanɨ, ŋga Krais ana ŋgɨrɨ Gariri hɨfɨnɨpoedɨ düfu! ");
INSERT INTO agg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Baiborambe yare hoafɨyowohü yahoya, ‘Krais ana adükarɨ bogorɨ Defitɨndɨ sɨrambeahɨndɨndu hayambo-anɨmbo asu ai horombo Defit nüŋguhü Betrehem ŋgoafɨhü nɨmorɨmbondüfi tükündüfimbui,’ meho,” masei. ");
INSERT INTO agg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ranɨmboyei asu nindou ranai Sisasɨmbo hohoanɨmo yimbumbo-yimbumborɨhindühɨ asu nindou ranai yimbumbore yɨbobomareandɨ. ");
INSERT INTO agg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ranɨyei asu bɨdɨfɨrɨ ai ahambo kɨkɨhimündɨmbo yahomo houmbo raraomarürɨ, ŋga asu moai kɨkɨhɨruründümo. ");
INSERT INTO agg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ranɨyomo asu prisman Sisasɨmbo kɨkɨhimündümbo koamarɨhoupurɨ ranai hɨhɨrɨyafu bogorɨ nindouyomo asu Farisi ahamumbo sowana mahomo. Asu ai düdurüpurühɨ yahomoya, “Se nɨmboe ahambo semündü sɨnɨkoate-memoa?” mehomondamboemo. ");
INSERT INTO agg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Asu prisman ai sɨmborɨ hoafɨyomopurühɨ yahomoya, “Horombo moai nindou ŋgorü ai haponda hoafɨyu arandɨ nahurai hoafɨyu, ŋga wanɨ!” mehomondamboemo. ");
INSERT INTO agg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Asu sɨmborɨ Farisi ai ahamumbo düduyafupurühɨ yahomoya, “Asu ai sɨhamumbo wosɨhoaforɨ hoafɨrapurai wanɨyo? ");
INSERT INTO agg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Farisi-anemo asu bogorɨ nindou roanefɨ hoeirumuna nindou roambeahɨndɨ mamai-amboanɨ anɨhondümbo-rirai asu wanɨyo? ");
INSERT INTO agg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nɨmorehɨ nindowenihɨ aiana moai Mosesɨndɨ ahɨnümbɨ hohoanɨmo fɨfɨrɨhindɨ, ŋga ranɨmboanei ai Godɨndɨ hɨmboahü moaruwai nɨŋgoayei! Ai yaŋgɨrɨ Sisasɨmbo anɨhondümbo-marɨhorɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Nikodemus ai Suda-yafe bogorɨyu haya horombo Sisas sowana mahu. Ranɨmboyu ai yare hoafɨyupurühɨ yahuya, “Sɨhefɨ ahɨnümbɨ hohoanɨmo ana nindoumbo moanɨ hoaŋgɨrɨfe hefe papɨ-hoafɨrɨ-hundürühɨyefɨ asu wanɨyo? Ahandɨ hoafɨ boatei wudɨpoapondɨhu hɨmborɨndefɨ mbundɨhumbo-anɨmbo asu ratüpurɨ ai rawareandɨ ra fɨfɨrɨndɨhumboyefɨ,” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Asu sɨmborɨ ahambo hoafɨyomondühɨ yahomoya, “Asu se kameihɨ amboanɨ Garirihündɨwamboyafɨ? Bukambeahɨndɨ hoafɨ ra se ndoro fɨfɨrɨndowandɨ, ŋga moai Godɨndɨ hoafɨ hoafɨyu-randeimbɨ ana Garirihündɨ süfu randɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ranɨyei asu nindou ranai ahei ŋgoafɨnambo bukürümehindɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ranɨyei asu nindou ranai ahei ŋgoafɨnambo bukürɨmehindamboyo, asu Sisas ai asükaiyu Orif Wafunambo mahafu. ");
INSERT INTO agg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hapoadümbo siambe asükaiyu Godɨndɨ worɨnambo mahu. Ai hu tüküfi nɨmaruane, asu nɨmorehɨ nindowenihɨ ranai ahambo sowana maheiamboyu yamundɨmareandürɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ahɨnümbɨ hohoanɨmo fɨfɨrundeimbɨ asu Farisi bɨdɨfɨrɨyomo ai nɨmorehɨ mamɨ hoeirundane nindowenihɨ-dɨbo serɨmɨndɨ mahoamboemo asu ai ahambo sowandümo nindou hɨmboahü mbusümo hɨnɨŋgɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ranɨyomo asu ai Sisasɨmbo hoafɨyomondühɨ yahomoya, “Yamundo-randeimbɨ, nɨmorehɨ ranai nindou ŋgorü-dɨbo meŋgorafea asu hoeimarupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesɨndɨ ahɨnümbɨ hohoanɨmo yare hoafɨmayo ranana yahurai-ane, ‘Nɨmorehɨ yahurai refewanɨ ana, nɨmoeinambo hɨfokoefe-ndürɨmboane.’ Ŋga asu se haponda nüŋgundo hoafɨmandafa?” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ai hoafɨ yaru hoafɨmemo ra moanɨ Sisasɨmbo yürümombo nahuraiyomo ranɨ-süŋgundɨhuranɨ ai nüŋgu mbüsuwanɨ papɨ-hoafɨndɨhurɨ yahomo houmbo. Ŋga Sisas ai hɨfɨnɨ yimɨndɨho yimbunambo nɨmarümbo hɨfɨfihɨ warɨmbuifɨnambo sürü-sürümarandɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nindou ranai ranɨhü nɨŋgomombo Sisasɨmbo düdu-düdupomaruramboyu asu ai botɨfi hoafɨyupurühɨ yahuya, “Nindou sɨhamundɨ mbusümo moaruwai hohoanɨmokoate-mayu ranai boatei-anɨmbo nɨmoeinambo harɨmbindo-wamboane.” ");
INSERT INTO agg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yare hoafɨyupurɨ mbura asükaiyu hɨfɨnɨ piyu yimɨndɨho yimbunambo nɨmarümbo hɨfɨfihɨ sürü-sürümarandɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nindou ranai Sisas ranɨ hoafɨ hoafɨmayu ra hɨmborɨyomo houmbo ahambo hɨnɨŋgɨrüwurɨ houmbo mamai kɨkefoefe mamai kɨkefoefeyomombo ndamefundɨ. Amoŋgohoandɨ boateiyomo ndamefundɨ. Asu Sisas yaŋgɨrɨ nüŋguane nɨmorehɨ ranai ahandɨ hɨmboahü manɨŋgo. ");
INSERT INTO agg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ranɨyu asu ai botɨfi hoafɨyundühɨ yahuya, “E, nindou nda muŋgu bukürɨmefoendɨ. Asu nindou sɨhambo papɨ-hoafɨyonɨnɨmbo ra mamamboanɨ nüŋguai?” mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Asu nɨmorehɨ ranai Sisasɨmbo hoafɨyondowohü yahoya, “Adükarɨ, moai nindou mamamboanɨ nüŋgu.” Asu Sisas ai hoafɨyuhɨ yahuya, “Ro-amboanɨ ŋgɨrɨ sɨhambo papɨ-hoafɨndɨhanɨnɨ. Se ŋgafɨ, ŋga yowanɨ asükaiyo moaruwai hohoanɨmoyopoanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Asu ŋgorü-sɨmboanɨ Sisas ai aheimbo hoafɨyundürühɨ yahuya, “Roana hɨfɨ ndanahandɨ si nɨmɨnd-anahɨ. Nindou ai wandɨ süŋgu ahu ana, ai ŋgɨrɨ nɨmbokoanɨ hoahoaŋgu wakɨndeandɨ, ŋga wanɨ. Nindou ranai koadürümbo-koadürümbo yaŋgɨrɨ nɨŋgo ranahandɨ si ra ndemündümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ranɨyomo asu Farisi ai Sisasɨmbo hoafɨyomondühɨ yahomoya, “Seana sɨhafɨ fimbo-anafɨ hoafɨ ra weindahɨ hoafɨyafɨ arandɨ. Ranɨmboane asu sɨhafɨ hoafɨ ra ŋgɨrɨ anɨhondümbo-ndɨfeyo,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Asu Sisas ai sɨmborɨ hoafɨyupurühɨ yahuya, “Yɨnɨ, anɨhond-ane rananasɨ, roana wandɨ fimbo-anahɨ weindahɨ sɨheimbo hoafɨya arɨhandɨ. Ŋga asu wandɨ hoafɨ ranana anɨhondü hoaf-ane. Asu wandɨ hoafɨ ra nɨmboe anɨhondü hoafayo? E! Hoafɨ ra yahurai-ane. Ro fɨfɨrɨheandɨ nahanɨnɨpoedɨyahɨ tükümeheandɨ asu nahanamboyo homboayahɨ ra. Ŋga asu seana moai wandɨ ŋgoafɨ hondü ana fɨfɨrundɨ. Asu ro nahanafɨyo homboayahɨ ranamboanɨ se moai fɨfɨrundɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Asu se hɨfɨnɨndɨ hohoanɨmo süŋgurundühɨ nindoumbo yɨboboru-rundeimb-anemo, ŋga roana moai nindou mamɨmbo amboanɨ yɨboborɨhe rɨhandɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ŋga asu, ro nindou daboe yɨboboarɨheandɨ ana, wandɨ yɨbobofe ra anɨhondü hondündomboe. Asu roana ro yaŋgɨrɨyahɨpoanɨ, ŋga wanɨ. Ape wambo koamarɨhendɨrɨ ai ro-dɨbo ranɨ-moatükunɨ ratüpurɨyuhani. ");
INSERT INTO agg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sɨhei ahɨnümbɨ hohoanɨmo yare meŋgoro. Nindou yimbu ai hoafɨ mamɨ ranahambo yɨbobo hoafefandɨ ana, ra anɨhond-ane. ");
INSERT INTO agg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Asu ro wandɨ fimbo anɨhondümbo hoafɨyahanane Ape wambo koamarɨhendɨrɨ ranai wambo anɨhondümbo hoafɨyu arandɨ,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Asu ai Sisasɨmbo hoafɨyahündowohü seiya, “Sɨhafɨ ape nahi anüŋgua?” maseiamboyu. Ranɨyu asu Sisas ai sɨmborɨ hoafɨyundürühɨ yahuya, “Seana moai wambo fɨfɨrɨhindɨrɨ asu wandɨ Apembo fɨfɨrɨhorɨ raraorɨhorɨ. Asu se wambo fɨfɨrɨhindɨrɨ-mbonana, wandɨ Apembo amboanɨ fɨfɨrɨhorɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Hoafɨ Sisas ai yare hoafɨmayu ra Godɨndɨ worɨkɨmɨ aheimbo yamundearühüyu hoafɨmayu, kakɨ foarɨhi-rɨhündeimbɨ hɨpɨrɨ nɨŋgo fikɨmɨ. Sisasɨmbo kɨkɨhimɨndɨmbo si ra awi tüküfekoate-mayoa asu nindou mamai-amboanɨ ŋgɨrɨ Sisasɨmbo kɨkɨhɨndürɨmündu. ");
INSERT INTO agg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Asükaiyu Sisas ai aheimbo hoafɨyundürühɨ yahuya, “Roana ndeara ndefembo samboanahɨ, ŋga asu se wambo kokondɨhündɨrɨmboyei. Ŋga asu se sɨhei moaruwai hohoanɨmo ranambo-anɨmbo ŋgei ŋgeimbo yɨfɨndeimboyei. Asu seana ŋgɨrɨ ro ahahɨ ranambe ŋgei,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ranɨyomo asu Suda-yomondɨ bogorɨ nindou ranai hoafɨyomondühɨ yahomoya, “Sisas ai yare hoafɨyuhɨya, ‘Seana ŋgɨrɨ ro ahahɨ ranambe ŋgei,’ mehu. Ai hoafɨ yare hoafɨmayu ra ahandɨhoarɨ hɨfokoefe yaŋgorombo yahumboyu?” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Asu Sisas ai hoafɨyuhɨ yahuya, “Seana hɨfɨnɨndɨ poed-anei, ŋga roana nɨmoamo sünambeahɨndɨ tükümeheand-anahɨ. Seana hɨfɨ ndanɨhünda tükümehind-ane, ŋga roana hɨfɨ ndanɨhünda tüküyaheambo-yahɨpoanɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ranɨmboanahɨ asu ro sɨheimbo hoafɨyahühɨ, seana sɨhei moaruwai hohoanɨmo ranambo-anɨmbo ŋgei-ŋgeimbo yɨfɨndeimboyei masahɨ. Asu ro dɨdeahɨ se wambo anɨhondümbofe-koate-ayei ana, se sɨhei moaruwai hohoanɨmo ranambo-anɨmbo ŋgei-ŋgeimbo yɨfɨndeimboyei,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Asu ai düduyahindühɨ seiya, “Asu se dɨdɨyafɨ nɨmora?” maseiamboyu. Asu Sisas ai aheimbo hoafɨyundürühɨ yahuya, “Ro sapo sɨheimbo horombo hoafɨmayahandürɨ ran-anahɨ nda. Ŋga se wambo moai anɨhondümbo-rɨhindɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ro sɨhei hohoanɨmo ranahambo afɨndɨ hoafɨnda samboanahɨ. Süŋgunambo sɨhei hohoanɨmo yɨbobondɨheamboyahɨ. Nindou ai wambo hɨfɨna koamarɨhendɨrɨ aiana anɨhond-anisɨ. Asu ro nɨmorehɨ nindowenihɨ aheimbo hoafayahɨ ra ro ahandɨ-mayo hoafɨ hɨmborɨya heheamboanahɨ hoafayahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Asu Sisas ai ahandɨ Afɨndambo aheimbo hoafɨmayundürɨ ranɨmbo moai fɨfɨrɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ranɨmboyu asu Sisas ai hoafɨyuhɨ yahuya, “Se Nindou Hondü ranahambo nɨmoamo sahorɨmɨndei botɨrɨhorühɨ nɨmɨ keimbɨ karɨhendeimbɨ fihɨ pararɨhorɨ ana, asu se ranɨ-sɨmboan-anɨmbo fɨfɨrɨndɨ-horɨmboyei. Rananɨmbo asu ropoanɨmbofe hohoanɨmoyo hefembo ratüpurɨkoate-ya arɨhandɨ ra se fɨfɨrɨndɨhimboyei. Ro hoafɨ hoafɨya arɨhandɨ ra Ape ai nafuiyundɨranane sɨheimbo ranɨ-süŋgurɨhe hoafayahandürɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nindou wambo hɨfɨna koamarɨhendɨrɨ ranai ŋgɨrɨ wambo hɨnɨŋgɨndeandɨrɨ, ŋga ai wandɨ fikɨmɨ nüŋgumboani, nɨne-moatükunɨ ai yifirɨyu haya hohohoanɨmoayu ra muŋguambo si ratüpurɨya arɨhandɨ,” mehu ");
INSERT INTO agg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nɨmorehɨ nindowenihɨ afɨndɨ ranai Sisasɨndɨ hoafɨ hɨmborɨ-yei hehi ahambo anɨhondümbo-marɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ranɨyu asu Sisas ai nindou Sudahündɨ ahambo anɨhondümbo-marɨhorɨ aheimbo hoafɨyundürühɨ yahuya, “Asu se ro yamundɨrɨ-hendüreimbɨ hoafɨ ranahambo hɨmborɨyeihɨ ranɨ-süŋguarɨhindɨ ana, asu se wandɨ anɨhondü süŋgurɨhindɨ-reimbɨndeimboyei. ");
INSERT INTO agg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Asu se anɨhondü hohoanɨmo ra fɨfɨrɨndɨhindanɨ asu hohoanɨmo ranai sɨheimbo aboedɨ koandɨheira ŋgeimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Asu Sisasɨmbo hoafɨyahündowohü seiya, “Roana Abrahamɨndɨ ahuir-anefɨ. Asu roana moai nindou ŋgoründɨ moanɨ hefɨ ratüpurɨyefɨ rɨhundɨ. Nɨmboeafɨ se yɨhoefɨmbo hoafɨyafɨmunühɨ hoafɨ ranai ‘sɨheimbo aboedɨ koandɨheira ŋgeimboyei,’ masafa?” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ranɨyu asu Sisas ai aheimbo hoafɨyundürühɨ yahuya, “Yɨnɨ, nindou muŋguambo moaruwai hohoanɨmoyei arɨhündɨ ranai moaruwai hohoanɨmo ranahandɨ moanɨ ratüpurɨyei-rɨhündeimb-anei. Ŋga ranɨmboyo ro ramasahɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nindou moanɨ ratüpurɨyu arandɨ ranai moai fikɨmɨnɨndɨ babɨdɨ worambe nɨmarü randɨ, ŋga wanɨ. Ŋga nindou ahandɨ nɨmorɨ ai-anɨmbo ahandɨ fikɨmɨnɨndɨ babɨdɨ worambe nɨmandümbui. ");
INSERT INTO agg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ranɨmboane asu Godɨndɨ Nɨmorɨ ranai sɨheimbo aboedɨ nɨmarɨmbohünda fandɨhendüranɨ asu se aboedɨ hamɨndɨ nɨmandeimboyei. ");
INSERT INTO agg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ro sɨheimbo fɨfɨrɨhearümboanahɨ se Abrahamɨndɨ ahuir-anei. Ŋga wandɨ hoafana moai sɨhei hohoanɨmoambe nɨmarondürɨ. Ranɨmboanei asu se wambo hɨfokoefendɨrɨmbo sei hehimbo raraoayei. ");
INSERT INTO agg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nɨnɨ-moatükunɨ ra ro wandɨ Apendɨ-mayo hoeirɨhe heheamboanahɨ sɨheimbo hoafɨyahandürɨ arɨhandɨ. Ŋga asu seana raranɨ-moatükunɨ ratüpurɨyei arɨhündɨ ra sɨhei apendɨ-mayo-ane sahümündi hehimbo ranɨ-süŋgurɨhi ratüpurɨyei arɨhündɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Asu sɨmborɨ ahambo hoafɨyahündowohü seiya, “Yɨhoefɨ ape ana Abraham-ani,” maseiamboyu. Asu Sisas ai sɨmborɨ hoafɨyundürühɨ yahuya, “Asu se Abrahamɨndɨ nɨmorɨ hondümbeyei-mbonana, asu Abrahamɨndɨ hohoanɨmo ra süŋgurɨhi. ");
INSERT INTO agg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ro sɨheimbo hoafɨ hondü Apendɨ-mayo hɨmborɨmayahɨ ranɨyo weindahɨ hoafɨmayahandürɨ. Rananei asu se wambo haponda hɨfokoefendɨrɨmbo sei hehimbo rarawarɨhündɨrɨ. Abraham ana moai yare ranɨ hohoanɨmoyu randɨ. Ŋga se yaŋgɨr-anei rarɨhi moaruwai hohoanɨmoayei. ");
INSERT INTO agg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Asu seana raranɨ-moatükunɨ ra sɨhei apemamɨ-yomondɨ hohoanɨmo yaŋgɨrɨ süŋgurɨhündühanei,” mehuamboyei. Asu Suda ai Sisasɨmbo hoafɨyahündowohü sahündoya, “Roana boagɨrɨ fɨfɨrɨfekoate nafɨ mbusümonɨndɨ nɨmorɨyefɨpoanɨ. Roana yɨhoefɨ ape mamɨ God ai yaŋgɨr-ani anüŋgu asu ro ahandɨ nɨmorɨ hond-anefɨ,” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Asu Sisas ai hoafɨyundürühɨ yahuya, “God ai anɨhondü sɨhei apembei-mbonana, asu se wambo aboedɨ hohoanɨmo-rɨhündɨrɨsɨ. Ŋga ro Godɨ-dɨbo nɨmboa heheamboyahɨ asu makosahɨ. Ro makosahɨ ra ropoanɨmbo hohoanɨmoya hehea kosamboyahɨpoanɨ, ŋga God ai wambo koamarɨ-hendɨramboyahɨ makosahɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Asu se nɨmboyei wandɨ hoafɨ ndofe fɨfɨrɨfekoate-mayeia? Asu seana ŋgɨrɨ wandɨ hoafɨ ra awi hɨmborɨndei. ");
INSERT INTO agg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sɨhei ape ana Satan-ani. Rananei asu se sɨhei apendɨ hohoanɨmo ranɨ yaŋgɨrɨ sahümündi anɨboadei. Horombo hondü aiana nindou hɨfokoare-randeimbɨyu manüŋgu. Ranɨyu asu ai moai anɨhondü hohoanɨmo süŋgure randɨ sapo anɨhondü hohoanɨmo ra ahandɨ fiambe nɨmarɨkoate-wambo. Tɨkai hoafɨ ai hoafɨyu arandɨ ra ahandɨ hoafɨ hond-ane. Aiana nindou tɨkai hoafɨyu-randeimb-ani, ŋga ranɨmboani asu tɨkai hoafɨ ranahandɨ nɨmɨndühani. ");
INSERT INTO agg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ŋga ro sɨheimbo anɨhondümbo hoaf-ane hoafayahandürɨ. Ranane asu se wandɨ hoafɨ ra anɨhondümbofe-koate-ayei. ");
INSERT INTO agg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sɨhei mbusümo nindou mamɨ ranai wandɨ hohoanɨmo-ambeahɨndɨ hohoanɨmo moaruwai weindahɨmandeyo wanɨmandɨyo? Asu ro anɨhondü hoafɨ hoafɨya arɨhandɨ ana, asu se nɨmboe wandɨ hoafɨ anɨhondümbofe-koate-mayeia? ");
INSERT INTO agg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Godɨndɨ nɨmorɨ ana Godɨndɨ hoafɨ muŋgu ra hɨmborɨyeihanei. Seana Godɨndɨ nɨmorɨyeipoanɨ. Ranɨmboanei asu se ahandɨ hoafɨ hɨmborɨkoate-yei arɨhündɨ,” mehu ");
INSERT INTO agg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Asu Suda ai Sisasɨmbo sɨmborɨ tɨrɨfoarɨhorɨ hoafɨyeihɨ seiya, “Roana sɨhambo rarɨhu hoafɨyahunɨnühanefɨ: ‘Seana Samariahünd-anafɨ asu sɨhafɨ fiambe moaruwai nendɨ mamɨ mbamarɨ,’ asefɨ. Ra anɨhondüyo?” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Asu Sisas ai aheimbo yare hoafɨyuhɨ yahuya, “Wandɨ fiambe ana moai moaruwai nendɨ nɨmaro, ŋga wanɨ. Roana wandɨ Ape ranahambo, adükar-ani sahühanahɨ, ŋga se wambo moaruwaimbo-arɨhindɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ro wandɨ fimbo ndürümbanahɨ yahomboyahɨpoanɨ. Ŋga Nindou mamɨ wambo ndürümbani yahombo hoafɨ yɨbobore-randeimbɨ mbanüŋgu. ");
INSERT INTO agg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ro sɨheimbo anɨhondümboanahɨ hoafayahɨ, nindou ŋgorü ai wandɨ hoafɨ ra süŋguareandɨ ana, ai ŋgɨrɨ yɨfɨndu, ŋga wanɨ,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Asu Suda ai hoafɨyahündowohü seiya, “Haponda ro sɨhambo anɨhondü fɨfɨrɨ-hunɨnɨmboanefɨ, sɨhafɨ fiambe moaruwai nendɨ amaronɨnɨ. Abraham yɨfɨyu asu Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ amboanɨ yɨfɨsafɨmemo. Ranane asu se hoafɨyafühɨya ‘Nindou mamɨ ai wandɨ hoafɨ ranɨ-süŋguareandɨ ana, ŋgɨrɨ yɨfɨndu,’ masafɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Se yaro hohoanɨmoyafühɨ sɨhefɨ amoao Abrahamɨmbo ŋgasündɨworɨmboyafɨ? Aiana sapo yɨfɨmayu rasɨ. Asu Godɨndɨ hoafɨ hoafɨyomo-rundeimbɨ amboanɨ ai yɨfɨmemo rasɨ. Asu se dɨdɨyafa?” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Asu Sisas ai sɨmborɨ hoafɨyundürühɨ yahuya, “Asu ro wandɨhoarɨ wandɨ fimbo ‘adükar-anahɨ’ mbasahɨ-mbonana, asu ro moan-anahɨ. Ŋga wandɨ Ape aiani wambo ‘adükar-ani,’ yahu arandɨ, ŋga se hoafɨyeihɨ ‘ai yɨhoefɨ God-ani,’ asei. ");
INSERT INTO agg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Asu seana moai ahambo fɨfɨrɨhorɨ. Ŋga roana ahambo fɨfɨrɨhinɨmboanahɨ. Asu ro hoafɨyahühɨ, ‘Roana moai fɨfɨrɨhinɨ,’ mbasahɨ-mbonana, asu ro se rawehindɨ nou tɨkai hoafɨya. Ŋga roana ahambo ndorɨhinɨ fɨfɨrɨhinɨ hehea asu ahandɨ hoafɨ ra süŋgurɨheandühanahɨ. ");
INSERT INTO agg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Horombo sɨhei amoao Abraham ai ro tüküfembo-mayahɨ ra hoeifembo hohoanɨmoyuhü hɨhɨfɨ-hɨhɨfɨmayu. Ai ra hoeire hayamboyu asu ahandɨ ŋgusüfo ndore küre mamaru,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ranɨmboyei asu Suda ai Sisasɨmbo hoafɨyeihɨ seiya, “Seana awi moai 50 hɨmbanɨyafɨpoanɨ, ŋga se Abrahamɨmbo hoeimarɨhinɨ asafɨ?” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Asu Sisas ai asükaiyu aheimbo hoafɨyuhɨ yahuya, “Yɨnɨ, ro sɨheimbo anɨhondümboanahɨ hoafehandürɨ horombo hondü Abraham ai tüküfekoate-yuambeahɨyahɨ ro boatei manɨmboahɨ,” mehuamboyei ");
INSERT INTO agg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ranɨyei asu Suda ai nɨmoei hüründümo houmbo Sisasɨmbo nɨmoeinambombo mehomo, ŋga asu ai Godɨndɨ worɨ hɨnɨŋgɨre haya dɨbo ndamefiyu. ");
INSERT INTO agg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sisas ai nafɨ-süŋgu huhündamboyu nindou hɨmboatɨharɨ hoeimarirɨ. Nindou ra hondɨ ai hɨmboatɨharɨ yahurai wakɨmarɨmɨndo. ");
INSERT INTO agg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ranɨyomo asu ahambo süŋgururü-rundeimbɨ ai hoafɨyomondowohü yahomoya, “Yamundo-randeimbɨ, dade moaruwai hohoanɨmo nindou ndanahambo ramarera asu ai hɨmboatɨharayua? Ahandɨ moaruwai hohoanɨmoyo, asu hondafɨndɨ-yafe-mayoyo?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Asu Sisas ai ahamumbo sɨmborɨ yahuya, “Nindou ndanahandɨ hɨmboatɨharɨ ra ahandɨ-mayo, asu hondafɨndɨ-yafe-mayo moaruwai hohoanɨmo ranambo rareranɨ refimboyupoanɨ. Ŋga nindou ai yare hɨmboatɨharɨ-mayu ra Godɨndɨ hepünɨfeimbɨ moatükunɨ refewanɨ hoeifembohündamboyu yare hɨmboatɨharɨ-mayu. ");
INSERT INTO agg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","God ai wambo koamarɨhendɨra makosahane, ŋga hüfɨhamɨndɨ ndare nüŋguambe sɨhɨrɨ ahandɨ ratüpurɨ ratüpurɨ-ndefomboane. Ŋga nɨmbɨ pɨrayo ana, asu ŋgɨrɨ nindou ŋgorü ai-amboanɨ ratüpurɨndu. ");
INSERT INTO agg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ro hɨfɨ ndanɨhü nɨmboahambe ana ro nɨmorehɨ nindowenihɨ-yafe si-anahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ranɨyu Sisas ai yare hoafɨyu mbura, hɨfɨfihɨ ŋgurɨ tɨfɨfi fandeamunde mbura, nindou hɨmboatɨharɨ-mayu ahandɨ hɨmboarambe pamareandɨ. ");
INSERT INTO agg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ranɨyu ahambo hoafɨyundühɨ yahuya, “Se ŋgafɨ Siroam kakɨmarɨhündɨ hoeambe sɨhafɨ hɨmboarɨ ra popoaindandɨ,” mehu. (Hoafɨ Siroam ra ‘koarɨhefeyoa ho’ hoaf-ane.) Ranɨyu asu nindou ranai hu ranɨhü ahandɨ ŋgusümboarɨ ra popoaira mbura, hɨhɨrɨfi süfumbo aboedɨ hɨmboarɨmayu. ");
INSERT INTO agg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ranɨyei asu nindou akɨmɨ worɨ yimburɨhi nɨmareimbɨ asu ahambo horombo hoeirɨhoreimbɨ, ai horombo nɨmorehɨ nindowenihɨmbo kakɨnapombo moako-moakoyu marandɨ ranɨmbo hoeirɨhorɨ hehimbo hoafɨyeihɨ seiya, “Awi sapo nindou ndanɨmbaiyu nɨmarɨ yaŋgɨrɨ nɨmarümbo aheimbo moako-moakoyu marandɨ?” masei. ");
INSERT INTO agg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bɨdɨfɨrɨ ai hoafɨyeihɨ seiya, “Yɨnɨ, nindou aiyu refi marandɨ.” Asu bɨdɨfɨrɨ ai hoafɨyeihɨ seiya, “Wanɨ. Ai nindou yahuraiyusɨ, ŋga ai-yupoanɨ, ŋga nindou ŋgorüyu,” masei. Nindou amurɨ ai ranɨ wataporɨmayeiamboyu asu ahandɨhoarɨ yahuya, “Ro-anahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Asu ai ahambo düduyahindowohü seiya, “Asu sɨhafɨ hɨmboarɨ ra nüŋgure bɨrɨhoaimboyoa?” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Asu ranai sɨmborɨ yahuya, “Nindou Sisas sei-arɨhündɨ ranai hüburukonambo wandɨ hɨmboarambe fandɨfoareandɨrühɨ yahuya, ‘Se ŋgafɨ Siroam kakɨmarɨhündɨ hoe ranambe hɨmboarɨ sɨhafɨ ra popoaindandɨ,’ mehuamboyahɨ ro ha popoairɨhanda asu wandɨ hɨmboarɨ ra aboedɨ hɨmboarɨmayahɨ,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Asu ai düdurɨhorühɨ seiya, “Nindou ra nahi amarua?” maseiamboyu. Asu nindou ranai yahuya, “Nahümbei amaru ra moai fɨfɨrɨhinɨ,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ranɨyei ai nindou hɨmboatɨharɨ-mayu Sisas aboedɨ-marirɨ ranahambo Farisimbo sowana sahorɨmɨndei mahei. ");
INSERT INTO agg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ŋgoafɨmbo nɨmarɨmbo si ranɨ-sɨmboanɨyu Sisas ai nindou ranahandɨ hɨmboarɨ aboedɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Asu Farisi ai nindou-mayu ranahambo düdururühɨ yahomoya “Sɨhafɨ hɨmboarɨ ra nüŋgure aboedɨyomboyoa?” mehomondamboyu. Asu ai hoafɨyupurühɨ yahuya, “Sisas ai hüburuko wandɨ hɨmboarambe pamareandɨramboyahɨ asu ro ha popoaimarɨhandamboyo wandɨ hɨmboarɨ ra aboedɨmayo,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ranɨmboemo asu Farisi bɨdɨfɨrɨ ai yahomoya, “Nindou ndanahambo God ai koarɨheira kusümboyupoanɨ, ŋga ai moai moanɨ ŋgoafɨmbo nɨmarɨmbo hohoanɨmo ra süŋgureandɨ,” mehomo. Asu bɨdɨfɨrɨ ai hoafɨyomondühɨ yahomoya, “Asu nindou moaruwai hohoanɨmoyumbü ai ŋgɨrɨ hepünɨfeimbɨ moatükunɨ yahurai ratüpurɨndu?” mehomo. Ranɨyomo asu bɨdɨfɨrɨ ai ŋgorü hohoanɨmoyomo asu bɨdɨfɨrɨ ai ŋgorü hohoanɨmoyomo marundɨ. ");
INSERT INTO agg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ranɨyomo asu nindou hɨmboatɨharɨ-mayu ahambo hɨhɨrɨyafu asükaiyomo hoafɨyomondowohü yahomoya, “Nindou sɨhafɨ hɨmboarɨ aboedɨmareanɨnɨ ranahambo se nüŋguro hoafɨyafɨndoa?” mehomondamboyu. Asu ai hoafɨyupurühɨ yahuya, “Aiana Godɨndɨ hoafɨ hoafɨyu-randeimb-ani,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nindou ra ai horombo hɨmboatɨharɨ-mayu-anisɨ, ŋga asu ai ranahambo anɨhondümbofembo moei mehomo. Ranɨmboemo asu nindou hɨmboatɨharɨ-mayu ahandɨ hondafɨndambo ranɨ hoafɨ ra fɨfɨrɨfembohünda mɨŋgɨyomo hümarɨhaupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Asu ai ahafembo düdurüpɨrühɨ yahomoya, “Nindou nda sɨhafe nɨmorɨyu? Asu se safeya ro hɨmboatɨharɨ yahurai wakɨmarɨ-horɨmɨndehane masafe, ŋga asu nɨmboe ai haponda aboedɨ hɨmboarayua?” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Asu ahandɨ hondafɨndɨ ai safeya, “Yɨnɨ, ro ahambo fɨfɨrɨhorɨ ai yɨhoehɨ nɨmor-ani asu ai horombo hɨmboatɨharɨ wakɨmarɨ-horɨmɨndehɨ. ");
INSERT INTO agg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ŋga haponda moai ahambo fɨfɨrɨhorɨ ai nünüŋgufimbombei ahandɨ hɨmboarɨ ra aboedɨ hɨmboarayu. Asu ro moai fɨfɨrɨhorɨ nindou ahandɨ hɨmboarɨ aboedɨmarirɨ ranahambo. Düduyafundosɨ, ai adükarɨwambo sɨhamumbo ahandɨ fimbo hoafɨndüpurɨmbui,” masafe. ");
INSERT INTO agg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Hondafɨndɨ ai Sudambo yɨhɨmborɨnapurühɨyafe ai ahamumbo rarɨne hoafɨmefe. Horombo Suda ai yaru hoafɨyomondühɨ yahomoya: “Nindou ai weindahɨ hoafɨyeihɨ, ‘Sisas ra nindou God ai ahandɨ nendambo aboedɨfembo kafoarirɨ hɨnɨŋgɨmarirɨ Krais-ani,’ seianɨ ana, asu aheimbo rotu worambeahɨndɨ hɨhaiboadundüra ŋgɨrɨ ai-babɨdɨ rotundei,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ranɨmboyafe asu hondafɨndɨ ai hoafɨyafeihü “Ahambo düduyafundosɨ, ŋga ai adükarɨwambo sɨhamumbo ahandɨ fimbo hoafɨndüpurɨmbui,” masafe. ");
INSERT INTO agg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ranɨyomo asükai nindou hɨmboatɨharɨ-mayu ranahambo mɨŋgɨmemonda masünu. Asu ahambo hoafɨyomondühɨ yahomoya, “Se Godɨmbo ndürɨ adükarümb-ani mbɨsafɨndowohü anɨhondümbo hoafɨndafɨ. Ro fɨfɨrɨhumboanefɨ nindou ndanana moaruwai hohoanɨmoyu-randeimb-ani,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Asu nindou ranai hoafɨyuhɨ yahuya, “Ro moai ahambo fɨfɨrɨhinɨ, ŋga awi ai moaruwai hohoanɨmo-yumbümbeiyo asu wanɨmbeiyo. Mamɨ moatükunɨ ro fɨfɨrɨmarɨheandɨ ana, yɨnɨ ro horombo hɨmboatɨharɨ manɨmboahɨyahɨ, ŋga hapondanana ro aboedɨ hɨmboarayahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Asu Suda ai düduyafundowohü yahomoya, “Sɨhambo nünüŋgureanɨnɨmboyua? Sɨhafɨ hɨmboarɨ ra nünüŋgure aboedɨreanɨnɨmboyua?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Asu ahamumbo hoafɨyupurühɨ yahuya, “Ro sɨhamumbo hoafɨmayahapurɨyo, ŋga asu se hoafɨ ranahambo moai hɨmborɨyomo. Asükai se hɨmborɨmbo yahomomboemo? Se-amboa ahambo süŋgururü-rundeimbɨmbo tüküfembo yahomomboemo?” mehu. ");
INSERT INTO agg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Asu Suda ai nindou ranahambo ŋgɨnɨndɨrurühɨ moaruwai hoafɨyomondowohü yahomoya, “Seana Sisasɨmbo süŋgurɨrɨ-randeimb-anafɨ. Ŋga roana Mosesɨmbo süŋgurɨhu-rɨhundeimb-anefɨ. ");
INSERT INTO agg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","God ai Mosesɨmbo hoafɨmayundo ra ro fɨfɨrɨhundɨ. Ŋga nindou rananɨmbo ai dagüdambuia? Roana moai ahambo fɨfɨrɨhurɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Asu nindou ranai ahamumbo sɨmborɨ hoafɨyupurühɨ yahuya, “Ndanana wambo ranɨ-poanɨmbo moatükun-ane! Aiyu wandɨ hɨmboarɨ aboedɨmareanda asu ro aboedɨ hɨmboarayahɨ. Ŋga nɨmboemo se hoafɨyomondühɨya, ai nahanɨnɨpoedɨyu ro moai fɨfɨrɨhurɨ ehomoa? ");
INSERT INTO agg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ro fɨfɨrɨhumboanefɨ, ŋga God ana moai moaruwai hohoanɨmoyomo-rundeimbɨyomondɨ hoafɨ ana hɨmborɨyu randɨ, ŋga wanɨ. Ŋga nindou ranai Godɨmbo hohoanɨmoyuhü asu ahandɨ hoafɨ süŋgumareandɨ ranahandɨ hoaf-ane God ai hɨmborɨyu arandɨ. ");
INSERT INTO agg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Moai horombo nindou mamɨ hondɨ ai hɨmboatɨharɨ wakɨrɨmɨndoanɨ asu nindou ŋgorü ai ahandɨ hɨmboarɨ aboedɨ-marirɨ hoafɨ ra yaŋgoro, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Asu God ai nindou nda koehefikoate-mbei-mbonana, asu ŋgɨrɨ raranɨ-moatükunɨ hɨfɨ ndanɨhü ratüpurɨyu,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Asu sɨmborɨ ahambo hoafɨyomondowohü yahomoya, “Horombo me ai sɨhambo moaruwai hohoanɨmo ranambo wakɨmaramɨndɨnɨnɨ asu se hɨmboatɨharɨmayafɨ ranɨmboanefɨ ro fɨfɨrarɨhunɨnɨ. Se nindou moaruwai hohoanɨmo-yafeimb-anafɨ. Asu se yɨhoefombo yamundɨfemunɨmbo safomboyafɨ?” Ai ahambo yaru hoafɨyomondowohüyomo rotu worambeahɨndɨ hɨhaifoarüwurɨ weindanɨ hɨnɨŋgɨmarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sisas ai ranɨmbo hɨmborɨyu haya, kokorürɨ hu hoeirirühɨ yahuya, “Se Nindou Hondü ranahambo anɨhondümbo-roworai wanɨyo?” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Asu nindou ranai sɨmborɨ hoafɨyundowohü yahuya, “Adükarɨ, Nindou Hondü ra düdia? Se wambo hoafɨyafɨ-ndɨran-anɨmbo ro ahambo anɨhondümbo-ndɨhinɨ.” ");
INSERT INTO agg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Asu Sisas ai hoafɨyundühɨ yahuya, “Se ahambo hoeimarɨworɨ. Aiani se-dɨbo wataporayu nda,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Asu nindou ranai hoafɨyuhɨ yahuya, “Adükarɨ, ro anɨhondümbo-arɨheanɨnɨ.” Ai yahu mbura Sisasɨmbo yimɨndɨho yimbu pusɨre nɨmarümbo hohoanɨmomayundo. ");
INSERT INTO agg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Asu Sisas ai yahuya, “Ro nindouyei hohoanɨmo yɨbobofemboyahɨ hɨfɨ ndanɨhü makosahɨ. Ranɨmboane asu nindou Godɨndɨ hoafɨ fɨfɨrɨfekoate-yeimbɨ ai nindou hɨmboatɨharɨ aboedehindɨ nahurai fɨfɨrɨndɨhimboyei asu Godɨndɨ hoafɨ fɨfɨrɨhundeimb-anefɨ asei ai hɨmboatɨharɨ nahurai fɨfɨrɨfekoate-ndeimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisi bɨdɨfɨrɨ ai ahandɨ fikɨmɨ nɨŋgomombo ahandɨ hoafɨ ra hɨmborɨyomo houmbo yahomoya, “Asu ro-amboa hɨmboatɨharɨyefɨ?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Asu Sisas ai hoafɨyupurühɨ yahuya, “Asu se hɨmboatɨharɨmbemo-mbonana, hohoanɨmo moaruwai ra moai sɨhamundɨ fiambe nɨmaropurɨ. Ŋga se hoafɨyomondühɨ, ‘Yɨhoefɨ hɨmboarana aboed-ane,’ yahomo arundɨ, ranɨmboane asu hohoanɨmo moaruwai ra awi sɨhamundɨ fiambe amaropurɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Sisas ai hoafɨyuhɨ yahuya, “Ro anɨhondümboanahɨ sɨhamumbo hoafayahɨ, nindou ai moai sipsipɨ-yafe ginɨrɨ yipurɨ nafɨ kefuai randɨ, ŋga amurɨ hɨmborɨ nafɨ kefuai arandɨ, nindou ranai ana hümbuhünɨkorɨ napo fufuramündü-randeimb-ani. ");
INSERT INTO agg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Asu nindou yipurɨ nafɨtambe nafɨ karefuendɨ ranai ana sipsip ahei afɨnd-ani. ");
INSERT INTO agg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nindou yipurɨ hɨfanda-randeimbɨ ai-anɨmbo nindou ahu ranahambo yipurɨ ra tindɨhembui. Rananei asu sipsip ai ahandɨ yafambe ra hɨmborɨyei arɨhündɨ. Ranani asu ai ahei ndürɨ ra dükarearü yɨsɨboasɨyuhɨ asu ai aheimbo ginɨrambeahɨndɨ semündündürɨ moanambühɨ tüküfi ahu. ");
INSERT INTO agg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Asu ai ahandɨ sipsip ra muŋgu ginɨrambeahɨndɨ semündündürɨ moanambühɨ tüküfi hayambo asu ai horombofi huanɨ ahandɨ süŋgu ahei. Sapo sipsip ranai ahandɨ yafambe hɨmborɨyeihɨ ranɨmboane ahandɨ süŋgu ahei. ");
INSERT INTO agg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aiana ŋgɨrɨ nindou amurɨndɨ süŋgu ŋgei, ŋga wanɨ. Nindou amurɨ ai huanɨ ana, ai ahambo yɨhɨmborɨhorühɨ fefoehindühanei. Ahandɨ yafambe hɨmborɨkoate-ayei ranɨmbo wambo.” ");
INSERT INTO agg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sisas ai aheimbo kafoefe hoafɨ ra yare hoafɨmayundürɨ, ŋga asu moai kafoefe hoafɨ ranahandɨ nɨmɨndɨ ra fɨfɨrɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ranɨyu Sisas ai asükaiyu hoafɨyuhɨ yahuya, “Ro sɨhamumbo anɨhondümboanahɨ hoafayahɨ. Roanahɨ sipsipɨ-yafe yipurayahɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Asu nindou ai ro süŋguyahanɨ horomboyahi ahei aiana hümbuhünɨyeihɨ raranɨ napo moanɨ fufurühümündi rɨhündühanei. Asu sipsip ai-amboanɨ moai ahei hoafɨ hɨmborɨyei rɨhündɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ro-anahɨ yipurayahɨ. Asu nindou dɨdɨyei wambo sowanambo sɨnei ginɨrɨ ranambe karefoehindɨ ana, God ai aheimbo aboedambo-ndeandürümbui. Rananɨmbo asu ai keboehi tükündahi ndühündühɨ asu ai ginɨrɨ ranambe sesɨmbo amboanɨ keboehi tükündahimboyei. ");
INSERT INTO agg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nindou hümbuhünɨyu-randeimbɨ ginɨrɨ ranambe karefuendɨ ra moanɨyupoanɨ karefuendɨ. Nindou karefuendɨ ra ai kefoefe hefe hɨfo sipsip hümbuhünɨmbo hɨfokoefindürümbo yahumboani. Ŋga roana keboeheandühɨ sipsip aboedɨ yaŋgɨrɨ dɨboadeimbɨ asu ahei fiambe aboedɨ hohoanɨmo yaŋgɨrɨ nɨŋgombo afɨndɨ mbɨmarɨndüra samboanahɨ asɨhühɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Roana sipsip hɨfandɨrɨ-handeimbɨ nindou aboedɨ saf-anahɨ. Nindou sipsip hɨfandɨra-randeimbɨ aboedɨ ranai ana aheimbo farɨhefe-ndürɨmbohünda yɨfɨndümbui. ");
INSERT INTO agg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nindou kakɨ semɨndɨmbo ratüpurɨyu arandɨ aiana sipsipɨyei afɨndɨyupoanɨ. Asu ai sipsip aheimbo hɨfandɨrarü-randeimbɨyupoanɨ. Asu aiana nɨmambeahɨndɨ yaforɨ moaruwai howanɨ hoeimareandɨ ra fiboembui. Rananɨmbo asu yaforɨ ranai sipsip ranaheimbo warɨbadarü wakɨndeandüra buküründeimboyei. ");
INSERT INTO agg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nindou ranai ana moanɨ kakɨ semɨndɨmbo yaŋgɨrɨ hohoanɨmoyuhü wambo ŋgɨrɨ sipsip ranaheimbo hɨfandɨyondürɨmbo hohoanɨmondu. ");
INSERT INTO agg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ŋga roana sipsipɨyei hɨfandɨ-hɨfandɨyondürɨrambo nindou aboedɨ saf-anahɨ. Ro ana wandɨ sipsip ranaheimbo fɨfɨrɨheandüranɨ asu ai-amboanɨ wambo fɨfɨrɨhi-ndɨrɨmboanei. ");
INSERT INTO agg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Hoafɨ ra yahurai-ane, ro wandɨ Apembo fɨfɨrɨhinanɨ asu Ape ai wambo fɨfɨrareandɨrɨ nou. Rananɨmbo asu ro sipsipɨmbo farɨhefe-ndürɨmbohünda yɨfɨndamboyahɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Asu wandɨ sipsip bɨdɨfɨrɨ mbanɨboadei ranana ndanɨ ginɨrambeahɨ moai nɨboadei. Aheimbo amboanɨ ginɨrɨ ndanambe semündündürɨ koafoefendürɨmbo samboanahɨ. Rananɨmbo asu ai ro hoafɨyaheimbɨ wandɨ yafambehündɨ ra hɨmborɨndeimboyei. Rananɨmbo sipsip ranai mamambe nɨboadeiya asu nindou aheimbo hɨfandɨyondürɨmbo ra mamɨ yaŋgɨrɨ nüŋgumbui. ");
INSERT INTO agg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ro yɨfɨyo hefe asükai botɨfemboayahɨ ranɨmboane Ape ai wambo ŋgusüfo parareandɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ŋgɨrɨ wambo nindou mamai-amboanɨ hɨfokoefendɨrɨmbo hohoanɨmondu. Ŋga ro hohoanɨmomayahɨ süŋgu wandɨ yaŋgɨrɨ nɨŋgo ra hɨfokoefe-ndɨrɨmbohünda hɨnɨŋgɨ-ndɨheamboyahɨ. Asükainda ro hohoanɨmomayahɨ süŋgu wandɨ yaŋgɨrɨ nɨŋgo ra hɨhɨndɨhe ndahamɨndɨmboyahɨ wandɨ Ape ai randafoandɨ mehu süŋgu,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Suda ai ranɨ hoafɨ ra hɨmborɨyomo houmbo asükai yimbumboru yɨbobomefundɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ranɨyomo asu bɨdɨfɨrɨ ai yahomoya, “Moaruwai nendɨ ahandɨ fiambe mamaroamboani ai yare wunünümbo-wunünümboayu. Asu se nɨmboemo ahandɨ hoafɨ ra hɨmborayomoa?” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Asu bɨdɨfɨrɨ ai yahomoya, “Hoafɨ ndanana nindou moaruwai nendɨ nɨmarümbɨndɨ hoafɨyopoanɨ. Asu moaruwai nendɨ ranai ŋgɨrɨ nindou hɨmboatɨharɨndeianɨ ahei hɨmboarɨ ra aboedɨndeandɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Serusarem ŋgoafɨhü horombo Godɨndɨ worɨ ahandhoar-ane masei ranahambo asükai hɨhɨfɨ-hɨhɨfɨmbo si tükümefeyo. Ranɨ si ra ŋgɨsɨharɨyowambeyo tüküfe marandɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ranɨyu asu Sisas ai Godɨndɨ worambe Soromonɨndɨ weindanɨ yibadɨwamɨ mahüfu. ");
INSERT INTO agg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ranɨyomo asu Suda ai sɨfomo ahambo wakɨrurü nɨŋgomombo yahomoya, “Ro yimbu hohoanɨmoayefɨ hefɨ ra asu nüŋgusümboanɨ se hoafɨmandafɨmuna? Asu se Krais-ayafana yɨhoefombo weindahɨ hoafɨyafan-anɨmbo ro hɨmborɨndefosɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Asu Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Ro sɨhamumbo hoafɨ ra hoafɨma-yahapurɨyosɨ, ŋga asu se moai wandɨ hoafɨ ranahambo anɨhondümbo-rundɨ. Muŋgu hepünɨfeimbɨ moatükunɨ wandɨ Apendɨ ŋgɨnɨndɨnambo ratüpurayahɨ ranai ro dɨdɨmbayahɨ ra nafuiyoarandɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ŋga asu seana wandɨ sipsip ranɨ dɨborɨhɨndɨ-yomopoanɨ. Ranɨmboanemo asu se wandɨ hoafɨ anɨhondümbofe-koate-yomo arundɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Asu wandɨ sipsip ranana ro hoafɨyaheimbɨ ra hɨmborɨyeihü asu ro aheimbo fɨfɨrɨheandürananei asu ai wandɨ süŋgu hei arɨhündü. ");
INSERT INTO agg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Asu ro aheimbo yaŋgɨrɨ koadürümbo-koadürümbo nɨŋgombo asahandürɨ ra ai ŋgɨrɨ yɨfɨndei. Asu ŋgɨrɨ nindou mamai-amboanɨ wandɨ warambeahɨndɨ hündamündündürɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wandɨ Ape ai sipsip wandɨ ra wambo masendür-anei. Asu ai muŋguambo moatükunɨ ranahei ŋgɨnɨndɨ ŋgasünde haya ŋgɨnɨndɨ saf-ani. Asu ŋgɨrɨ nindou mamai-amboanɨ Apendɨ warambeahɨndɨ hündamündündürɨ. ");
INSERT INTO agg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ape-ani asu roanahɨ roana mamanehɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ranɨyomo asu Suda ai nɨmoei hümaründümo Sisasɨmbo pifendombo yahomombo. ");
INSERT INTO agg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ranɨyu asu Sisas ai yahuya, “Ro sɨhamumbo Apendɨ ratüpurɨ afɨndɨ nafuimehapurɨ. Asu se nɨnɨ ratüpurɨ aboedɨ ranahambo hohoanɨmo-yomondühɨyomo wambo nɨmoeinambo hɨfokoefendɨrɨmbo yahomo houmbo rawefunda?” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Asu sɨmborɨ Suda ai ahambo hoafɨyomondowohü yahomoya, “Roana sɨhafɨ ratüpurɨ aboedɨ ramarowandɨ ranɨmboyefɨpoanɨ nɨmoeinambo hɨfokoefenɨnɨmbo asefɨ, ŋga wanɨ. Se moanɨ nindou yaŋgɨr-anafɨ asu Godɨmbo moaruwaimbofe hoafɨrɨrühɨ, ‘Roana God-anahɨ’ masafɨ ranɨmboanefɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Asükaiyu Sisas ai ahamumbo sɨmborɨ hoafɨyupurühɨ yahuya, “Hoafɨ nda sɨhamundɨ ahɨnümbɨ hohoanɨmo Bukambe ndare meŋgoro: God ai yahuya, ‘Ro sɨheimbo hoafɨmayahɨ, seana god-anei,’ meho. ");
INSERT INTO agg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nindou God ai ahandɨ hoafɨ masagadürɨ ranaheimboyo ai god-anei mehondürɨ. Asu ŋgɨrɨ Baiborambeahɨndɨ hoafɨ ranana ŋgorü-süŋgunde hoafɨndo. ");
INSERT INTO agg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ŋga Ape aiyu ahandɨhoarɨ wambo kafoareandɨrɨ mbura, asu hɨfɨna koamarɨhendɨra makosahɨ. Ranɨmboyahɨ ro hoafɨyahühɨ, ‘Roana Godɨndɨ nɨmor-anahɨ,’ masahɨ asu nɨmboe se wambo hoafɨyomo-ndɨrühɨya, ‘Nɨmboe se Godɨmbo gogonɨmbo-rɨhaworühɨ hoafayafɨ,’ mehomoa? ");
INSERT INTO agg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Asu ro Apendɨ ratüpurɨ ratüpurɨkoate-ndahanɨ ana, asu se wandɨ hoafɨ ra yowanɨ anɨhondümbo-ndümboemo. ");
INSERT INTO agg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ŋga asu ro ahandɨ ratüpurɨ ratüpurɨyahanɨ se wandɨ hoafɨ ranahambo anɨhondümbofembo moeimbo ana, asu ratüpurɨ ranɨ yaŋgɨrɨ anɨhondümbo-ndundɨ. Rananɨmbo asu se hohoanɨmo ra ndondu hohoanɨmo-ndɨmondühɨ fɨfɨndümboemo Ape ai ro-dɨbo mam-anehɨ amarehɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Asükaiyomo Suda ai hoafɨ ra hɨmborɨyomo houmbo ahambo kɨkɨhɨmündümbo yahomo houmbo ramefundɨ, ŋga asu Sisas ai aboedambo mahu. ");
INSERT INTO agg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Sisas ai asükaiyu hɨhɨrɨfi hanü Sodan hɨmo horombo Son hundürürarü randühɨ manüŋgu. ");
INSERT INTO agg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ai nüŋguane, nindou ranai ahambo sowana sühüsihü seiya, “Horombo Son ai moai hepünɨfeimbɨ moatükunɨ ratüpurɨyu. Ŋga muŋgu raranɨ-moatükunɨ hoafɨ nindou ndanahambo hoafɨmayu ranana anɨhond-ane,” masei. ");
INSERT INTO agg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ranɨyei asu nindou afɨndɨ ranɨhü ranai ahambo anɨhondümbo-marɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nindou mamɨ ahandɨ ndürɨ Rasarus Betani ŋgoafɨhündɨ ranai aŋgünɨmbo mamaru. Betani ra Maria asu Mata apodoho nɨmarɨ-feimbɨ ŋgoaf-ane. ");
INSERT INTO agg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria aiyo werɨ fɨsɨŋarümbɨ Sisasɨndɨ tɨŋarɨwamɨ kafoare mbura, asu ahandɨ mbɨrɨnaŋɨnambo gedümarɨhendɨ. Nɨmorehɨ mamɨ ranahandɨ ranihɨyu Rasarus aŋgünɨmbo Betani ŋgoafɨhü meŋguru. ");
INSERT INTO agg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ranɨyafe asu apodoho ranai Sisasɨmbo hoafɨmbo nindou koarɨhenerühɨ safeya, “Adükarɨ, nindou se ŋgusüfo pamarɨworɨ ranai aŋgünümboani,” masafeamboyu. ");
INSERT INTO agg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ranɨyu asu Sisas ai ahafe hoafɨ ra hɨmborɨyu haya hoafɨyuhɨ yahuya, “Aŋgünɨ ranana yɨfɨmbo aŋgünüyopoanɨ, ŋga wanɨ. Ranana moanɨ Godɨmbo ndürɨ adükarɨ segodɨmbo-hündamboane tükefeyo asu ranɨ-süŋgumboanɨmbo Godɨndɨ Nɨmorɨ amboanɨ ndürɨ adükarɨ ndemündümbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Sisas ai Mata apondoho asu Rasarus aheimbo ŋgusüfo pareandürɨ marandɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ŋga asu Sisas ai Rasarus aŋgünümboayu hoafɨ ra hɨmborɨyu haya, ranɨhü yimbu si mamaru. ");
INSERT INTO agg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Asükaiyu süŋguna nɨmarümbo ahambo süŋgururü-rundeimbɨmbo yahuya, “Asükai mborai, Suda-yafe hɨfɨnambo ŋgefombo,” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Asu sɨmborɨ hoafɨyomondowohü yahomoya, “Yamundo-randeimbɨ, sapo hapondanɨyomo Suda ai sɨhambo nɨmoeinambo hɨfɨkoefenɨnɨmbo yahomo houmbo raraomarünɨnɨsɨ. Asu se asükai Suda-yafe hɨfɨnambo hɨfombo safomboyafɨ?” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Asu sɨmborɨ Sisas ai ahamumbo hoafɨyupurühɨ yahuya, “Mamɨ si ra gebuai-ane anɨŋgo. Nindou ai sɨrühɨ ana ŋgɨrɨ pɨndu si ra hoeireambowambo. ");
INSERT INTO agg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ŋga asu nindou ai nɨmbokoanɨ ahu ana, piyu arandɨ si yaŋgorɨkoate wambo.” ");
INSERT INTO agg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ahamumbo yare hoafɨyupurɨ mbura asükaiyu hoafɨyupurühɨ yahuya, “Sɨhefɨ wandafɨ Rasarus ai mapuamboanahɨ awi ro ŋgü ahambo botɨndɨhinɨ samboanahɨ,” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Asu ahambo süŋgururü-rundeimbɨ ai hoafɨyomondühɨ yahomoya, “Adükarɨ, nindou ra apo yaŋgɨrɨ apu ana, asükai ahandɨ aŋgünü ra aboedɨndümbui,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sisas ai hoafɨmayupurɨ ra, Rasarus ana yɨfɨmayu yahumboyu, ŋga ahambo süŋgururü-rundeimbɨ ana moanɨ apo hondü mapu-amboani yare hoafayu mehomo. ");
INSERT INTO agg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ranɨyu asu Sisas ai ahamumbo dɨboadɨre hoafɨyupurühɨ yahuya, “Rasarus ana muŋguna yɨfɨmayu. ");
INSERT INTO agg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ranɨ-sɨmboanɨ ro moai ai-dɨbo nɨmarɨhɨ, ŋga ro ranɨmbo-hündambo hɨhɨfɨ-hɨhɨfayahɨ. Ranɨnɨmbo asu se wambo anɨhondümbo-ndundɨrɨ. Ŋga hapondanɨ sɨhɨrɨ ahambo sowana ŋgefɨmboane,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ranɨyu asu Tomas ahambo Didimas sahündo-rɨhündeimbɨ ai Sisasɨmbo süŋgururü-rundeimbɨ ahamumbo yahuya, “Wai sɨhɨrɨ andai ŋgifɨ, Sisas-babɨdɨmbo Sudiahü yɨfɨndefo,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo hɨfomo Betanihɨ tüküyafundühɨyomo Rasarus ai yɨfɨmayua hoŋguambe masɨhehorɨ ra yimbuyimbu si homboane hoafɨ ra hɨmborɨmayu. ");
INSERT INTO agg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ŋgoafɨ ana Serusaremɨhündɨ aŋgunɨyopoanɨ. Betani ŋgoafɨhündɨ botɨfe hefe Serusarem ŋgoafɨna aho ra ŋgɨmɨ kiromita-ane. ");
INSERT INTO agg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Rasarus yɨfɨmayua ranɨyei asu Sudahündɨ afɨndɨ ranai Mata Mariambo kɨkɨmɨfoefepɨrɨ nɨmaroanɨ ŋgusufo aboedɨ kürɨne mbɨmarɨfeya sei hehimbo masühüsi. ");
INSERT INTO agg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata ai Sisas masüfu hoafɨ ra hɨmborɨyo haya, ahambo nafoarɨfimbo ho, ŋga asu Maria ai worambeahɨ nɨmaro. ");
INSERT INTO agg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata ai Sisasɨmbo hoafɨyondowohü yahoya, “Adükarɨ, asu se ndanɨhü mbanɨmbafɨ-mbonana, wandɨ ranihɨ ai ŋgɨrɨ yɨfɨyu. ");
INSERT INTO agg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ŋga ro fɨfɨrɨheamboanahɨ, asu se hapondanɨ amboanɨ Godɨmbo nɨnɨmbo dɨdɨbafefoando ana, sɨhambo daganɨnɨmbui,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Asu Sisas ai ahambo hoafɨyundowohü yahuya, “Sɨhafɨ ranihɨ ana yaŋgɨrɨ aboedɨ hɨfambe-ambeahɨndɨ botɨndüfimbui,” mehundowamboyo. ");
INSERT INTO agg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Asu Mata ai ahambo asükaiyo hoafɨyowohü yahoya, “Ro ranɨmbo fɨfɨrɨheamboanahɨ, ŋga ai asükaindu süŋgunambo hɨfɨ nda muŋguyowambe yaŋgɨrɨ aboedɨ botɨndɨfimbui,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Asu Sisas ai yahuya, “Yɨfɨhündɨ yaŋgɨrɨ botɨfe nɨŋgo ra ro nɨmɨnd-anahɨ. Nindou ai wambo anɨhondümbo-reandɨrɨ haya yɨfayu ana, ai asükaindu yɨfɨhündɨ botɨndüfi nüŋgumbui. ");
INSERT INTO agg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ŋga nindou muŋgu yaŋgɨrɨ nɨmboeimbo wambo anɨhondümbo-arɨhindɨrɨ ana, ŋgɨrɨ yɨfɨndei, ŋga ai koadürümbo-koadürümbo yaŋgɨrɨ nɨboadeimboyei. Asu se hoafɨ ndanahambo anɨhondümbo-rowandai wanɨyo?” mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Asu Mata ai yahoya, “Yɨnɨ, Adükarɨ, ro sɨhambo anɨhondümbo-rɨheanɨnɨmboanahɨ seana God kafoare hɨnɨŋgɨmareanɨnɨ Krais-anafɨ. Seana Godɨndɨ nɨmorɨ horombo hɨfɨnambo nindou kudümbui mehu ran-anafɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata ai yare hoafɨyo haya, ahandɨ akɨdambo hɨfo hɨnɨŋgɨrou hɨmboambeambe hoafɨyondowohü yahoya, “Yamunde-randeimbɨ ana ndanɨhü süfumboani sɨhambo düdumefinɨnɨ,” mehoamboyo. ");
INSERT INTO agg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Asu Maria ai ranɨ hoafɨ ra hɨmborɨyo haya, nɨmehünou botɨfe haya Sisasɨmbo sowana maho. ");
INSERT INTO agg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sisas ai awi moai ŋgoafɨhü tüküfiyu, ŋga nafɨnɨ Mata ho hoeirerühɨ ranɨhü manüŋgu. ");
INSERT INTO agg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ranɨyo Maria ai nɨmai botɨfe haya pɨpɨnambo mahowamboyei asu Suda Maria-babɨdɨmbo worambe ahafembo kɨkɨmɨfoarɨhipɨrɨ mamarei ranai ahandɨ süŋgu mahei ndanana Rasarus yaŋgurühɨ ho aranɨ-hoafɨmboane aho sei hehi. ");
INSERT INTO agg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria ai ho Sisas nüŋguhü tüküfe ahambo hoeirerühɨyo ahandɨ fikɨmɨ yirɨ yimbu pusɨre yimɨndɨho yimbunambo nɨmarɨmbo hoafɨyowohü yahoya, “Adükarɨ, se ndanɨhü mbanɨmbafɨ-mbonana, wandɨ ranihɨ ai ŋgɨrɨ yɨfɨyu,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sisas ai Mariambo hoeireandane aranɨ-hoafɨmaranda, asu Suda ahandɨ süŋgu masɨnei ranai kameihɨ aranɨ-hoafɨ-marɨhündamboyu. Asu Sisas ai ahandɨ ŋgusüfoambe moaruwaimarɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Asu Sisas ai aheimbo düdufindürühɨ yahuya, “Se ahambo nahü sɨhehora?” mehuamboyei. Asu ai seiya, “Adükarɨ, naha se sühüfɨ hoeiro,” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Asu Sisas ai aranɨmayundo. ");
INSERT INTO agg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Asu Suda ai hoafɨyeihɨ seiya, “Hoeirɨhi. Sisas ana nindou ranahambo afɨndɨ hamɨndɨ ŋgusüfo parirühɨ wamboani,” masei. ");
INSERT INTO agg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ŋga bɨdɨfɨrɨ ai hoafɨyeihɨ seiya, “Sisas ai nindou hɨmboatɨharɨ aboedɨmarirɨ. Ŋga asu ai nɨmboe Rasarusɨmbo fehefiyua yaŋgɨrɨ nɨŋgombo ra wanɨmayua?” masei. ");
INSERT INTO agg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Asükaiyu Sisas ai ahandɨ ŋgusüfoambe moaruwai mahafowamboyu hu hoŋguambe tükümefiyu. Hoŋgu ra nɨmoei nɨmaroweimbɨ wowondɨmarɨhündɨyo ranɨyo nɨmoeiambe nafɨtambe ra nɨmoei ŋgorünambo gürühi pamarɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Asu Sisas ai yahuya, “Nɨmoei ambembo gürühi pamarɨhindɨ ra farɨhehi,” mehuamboyo. Asu Mata nindou yɨfɨmayu ranahandɨ rehɨ ai yahoya, “Adükarɨ, Rasarus ana yimbuyimbu si hoŋguambe yaŋgurɨmb-ani. Ŋga fɨsɨŋɨrümbei nawe,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Asu Sisas ai yahuya, “Sapo hapoasüŋgu hoafɨya-hanɨneimb-ane. Asu se wambo anɨhondümbo-arowandɨrɨ ana, se Godɨndɨ ŋgɨnɨndɨ ra hoeindowamboyafɨ,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ranɨyei asu ai nɨmoei ra mafarɨhehindamboyu, Sisas ai nɨmoamo hɨmboarɨyuhü yahuya, “Ape, ro sɨhambo hɨhɨfarɨhanɨnɨ. Se wandɨ hoafɨ hɨmborɨ-yafomboanafɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ro fɨfɨrɨheandɨ ro hoafɨya arɨhandɨ ra se afɨndɨmbo hɨmborɨ-yafɨ randühanafɨ. Ŋga nindou ndanɨhü manɨboadei-amboanahɨ ro ndarɨhe hoafayahɨ. Rananɨmbo se wambo koamarɨhawandɨra makosahɨ ra anɨhondümbo-mbɨrɨhindɨ-ramboane.” ");
INSERT INTO agg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Raweyahu haya puküna mɨŋgɨyuhü yahuya, “Rasarus, se weindana tüküyafo sɨnɨfɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ranɨyu asu Rasarus ai hoŋguambeahɨndɨ tüküfi haya masünu. Ahandɨ yitɨŋarɨ watɨŋarɨ ra hoearɨ goesürɨnambo hüputüpurühümündi hɨnɨŋgɨmarɨhindɨyo, asu ahandɨ ŋgusümboarɨ hoearɨnambo gabudɨ-mafoarɨhindɨyo ranɨ-kameihɨ tükümefiyu. Ranɨyu asu Sisas ai hoafɨyuhɨ yahuya, “Hoearɨ ra fufurɨhehindoan-anɨmbo ai mbühu,” mehundürɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ranɨyei asu Suda bɨdɨrɨrɨ ranɨhü Mariambo hoeifembo masühüsi ranai ranɨ-moatükunɨ Sisas ai ramareandɨ ranɨmbo hoeirɨhi hehi asu ahambo anɨhondümbo-marɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ŋga asu bɨdɨfɨrɨ ai Farisi sowana hei, Sisas ratüpurɨmayu ranahambo ahamumbo hoafɨmehüpurɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ranɨyomo asu nindou Godɨmbo sɨhou-rundeimbɨ bogorɨ ai Farisi bɨdɨfɨrɨ-babɨdɨmbo kansɨrɨmbo gugurüpurɨ houmbo hoafɨyomopurühɨ yahomoya, “Sɨhɨrɨ nda nüŋgumandahua? Nindou ndanani ai hepünɨfeimbɨ moatükunɨ afɨndɨ ratüpurɨyu arandɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sɨhɨrɨ ahambo moanɨ rarɨhurɨ hɨnɨŋgɨrɨhuranɨ ai hepünɨfeimbɨ moatükunɨ ratüpurɨyu randanɨ nindou afɨndɨ ai ahambo anɨhondümbo-arɨhorɨ ana, Rom bogorɨ sɨhefɨmbo hɨfandarɨmunɨ ai dɨfomo sɨhefɨmbo moaruwaimbo-ndɨmunühɨ asu sɨhefɨ Godɨndɨ worɨ ra bɨrɨboadümboemo,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ranɨyo asu ranɨ hɨmbanɨfihɨ nindou mamɨ ahandɨ ndürɨ Kaiafas ai Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨmbofi manüŋgu. Ai hoafɨyupurühɨ yahuya, “Seana moai raranɨ-moatükunɨ fɨfɨrundɨ! ");
INSERT INTO agg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Se ndoru fɨfɨrundai? Nindou mamɨ ai nindou amurɨ aheimbohünda yɨfayu ranana aboed-ane, ŋga Suda sɨhefɨmbo muŋguambo moaruwaimbofe ana, moaruwai-ane,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiafas ai yare hoafɨmayu ra ahandɨ hohoanɨmonambo yaŋgɨrɨyupoanɨ. Ŋga ranɨ hɨmbanɨfihɨ Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨmbofi nɨmarümbowambo Sisas ai aheimbohünda yɨfɨmboayu ranɨmbo horombo hoafɨreandühɨyu. ");
INSERT INTO agg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ai Sudambo farɨhefembo yaŋgɨrɨyupoanɨ yɨfayu ra, ŋga Godɨndɨ nɨmorɨ muŋgua hɨfɨhü burɨyei wakarɨhindɨ aheimbo semündündürɨ mamambefendüranɨ mamɨsɨrɨmboyahi mbɨnɨboadeia mbüsɨ hayambo-anɨmbo yɨfɨndümbui. ");
INSERT INTO agg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Asu ranɨyomo ranɨ-sɨmboanɨ pɨyomo houmbo, Suda-yomondɨ bogorɨ ai Sisasɨmbo hɨfokoefimbo yahomo houmbo hoafɨ fɨfɨrɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ranɨmboyu asu Sisas ai moai Suda-yomondɨ hɨmboahü weindahɨ tüküfiyu. Ranɨyu ai Sudia hɨfɨ ra hɨnɨŋgɨre haya, ŋgorü hɨfɨ nɨmɨ wohɨ furɨkoate-reandühɨ ŋgoafɨ ŋgorü ahandɨ ndürɨ Efraim ranɨhü hu ahambo süŋgururü-rundeimbɨ babɨdɨmbo manüŋgu. ");
INSERT INTO agg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","God ai Sudambo Isipɨhündɨ aboedɨmareandürɨ si Pasofa ra awi tüküfekoate akɨmɨ tüküfembo yaŋgɨrɨyoambe nindou ŋgorü ŋgoafɨhündɨ ŋgorü ŋgoafɨhündɨ ranai Serusarem ŋgoafɨnambo ahei fi Godɨndɨ hɨmboahü aboedɨ tüküfembohünda mafandɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ranɨyei asu ai Sisasɨmbo kokorɨhorɨ wakɨrɨhora mayoa Godɨndɨ worambe nɨmboeimbo aheihoarɨ wataporɨyeihɨ seiya, “Se nüŋgurühi hohoanɨmoayeia? Sisas ai adükarɨ si tükefeyo nda hoeifembo madüfuyo wanɨmandüyo?” masei. ");
INSERT INTO agg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nindou Godɨmbo sɨhou-rundeimbɨ bogorɨ ai Farisi-babɨdɨmbo yaru hoafɨmemo: ‘Nindou mamɨ ai Sisasɨmbo hoeiriranɨ anüŋgu ana, asu ahamumbo ranɨh-ani anüŋgu yahopuran-anɨmbo ahambo papɨ-hoafɨyumbohünda kɨkɨhɨ-mbɨrundümo-ndamboane,’ mehomo. ");
INSERT INTO agg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Adükarɨ si ra tüküfembo awi 6 si nɨŋgowane, asu Sisas ai Betani ŋgoafɨnambo mahu. Ŋgoafɨ ra Rasarusɨndɨ ŋgoaf-ane. Rasarus ranahamborürɨ Sisas ai hoŋguambeahɨndɨ yɨfɨhündɨ botɨmarirɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ranɨ ŋgoafɨhündɨ ai Sisasɨmbo sɨndɨrühündühɨ mamarei. Mata ai sesɨ kakɨreandɨ, ŋga Rasarus ai nindou Sisas-babɨdɨmbo nɨmarei masahüsi ra-babɨdɨmbo nɨmaru. ");
INSERT INTO agg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria ai werɨ fɨsɨŋarümbɨ hɨpɨrɨ mbuisamoŋgo-ramɨndeimbɨ kakɨ afɨndɨfihɨ sahümündimbɨ ra semɨndɨ haya Sisasɨndɨ tɨŋarɨ wamɨ kare mbura, asu ahandɨ mbɨrɨnaŋɨnambo gedümarɨhendɨ. Ranɨyo asu werɨ ranahandɨ fɨsɨŋarü aboedɨ ranai worambe kɨkɨhɨmayo. ");
INSERT INTO agg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ŋga asu nindou mamɨ ahambo süŋgurürɨ-randeimbɨ ahandɨ ndürɨ Sudas Iskariot ai-amboanɨ ranɨhü nɨmaru. Nindou ranai-anɨmbo Sisasɨmbo nderümündü ahandɨ hürütümbɨ ahamundɨ warɨwamɨndirümbui. Ai moai Maria ramareandɨ ranahambo hɨhɨfɨ-hɨhɨfɨyu. ");
INSERT INTO agg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Nindou ranai hoafɨyuhɨ yahuya, “Nɨmboe werɨ aboedɨ nda nindou ai sahümündihɨ asu ranɨfihɨ 300 kakɨ semɨndɨ mburɨmbo nindou napokoateimbɨ aheimbo segudürɨmbomayoa?” mehu. ");
INSERT INTO agg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ŋga nindou napo-koateimbɨ aheimbo hohoanɨmoyundürɨ haya hoafɨyumboyupoanɨ, ŋga wanɨ. Nindou ranai hümbuhünɨyu-randeimb-ani ranɨmboane asu ai yare hoafɨmayu. Aiyu kakɨ hɨpɨrɨ ahamundɨ ra hɨfandɨmarandɨ ranɨyu asu ai kakɨ foarɨhi marɨhündɨ ra bɨdɨfɨrɨ hümbuhünɨyu marandɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ranɨmboyu asu Sisas ai yahuya, “Nɨmorehɨ ranahambo se hɨnɨŋgɨndɨhindɨ. Ai wandɨ yɨfɨ si ranahambo horombonambo noure rarendühane fɨsɨŋarümbɨ moatükunɨ aboedɨ ra afandɨfoareandɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nindou napo-koateimbɨ ai-anɨmbo se-babɨdɨmbo koadürümbo-koadürümbo nɨmboeimboyei asu se aheimbo fandɨhehi-ndürɨndɨhündɨ, ŋga roana ŋgɨrɨ se-babɨdɨmbo koadürümbo-koadürümbo nɨmboahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Suda ai Sisas Betani ŋgoafɨhü anɨŋgu hoafɨ hɨmborɨyei hehimboyei, ranɨnambo mahüsi. Ai mahüsi ra Sisasɨmbo hoeifimbo yaŋgɨrɨyeipoanɨ, ŋga Sisas Rasarusɨmbo yɨfɨhündɨ hoŋguambeahɨndɨ botɨmarirɨ ranɨmbo hoeifimbo kameihɨyei mahüsi. ");
INSERT INTO agg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ranɨyu asu Godɨmbo sɨhou-rundeimbɨ bogorɨ ranai Rasarusɨmbo kameihɨ hɨfokoefimbo yahomo houmbo hoafɨ dɨdɨboado-marundɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nɨmboe sapo Suda bɨdɨfɨrɨ ai Sisas Rasarus yɨfɨhündɨ botɨmarirɨ ranahambo hohoanɨmoyeihɨ asu ahei bogorɨ-yomondɨ ratüpurɨ ra hɨnɨŋgɨrɨhi hehimbo Sisasɨmbo yaŋgɨrɨ anɨhondümbo-marɨhora ranɨmbo wambo. ");
INSERT INTO agg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nɨmohoafɨrehɨ nindowenihɨ afɨndɨ ranai adükarɨ si ra hoefembo masühüsi ranai ranɨhü nɨmareiane. Asu ŋgorü sihɨ Sisas ai Serusarem ŋgoafɨnambo asüfu hoafɨ ra hɨmborɨmayei. ");
INSERT INTO agg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ranɨyei asu ai mbe emündɨ nahurai hutei sahümündi hehi, nafɨna nafoarɨhorɨ hehü hoafɨ afɨndɨ-afɨndɨyeihɨyeihɨ seiya, “Godɨmbo hɨhɨfɨ-hɨhɨfɨndefo! Nindou Adükarɨndɨ süŋgu tükefiyu ranahambo ‘aboed-ani’ mbɨsefomboane. Israerɨ-yafe adükarɨ bogorɨmbo aboed-ani mbɨsefomboane,” masei. ");
INSERT INTO agg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Sisas ai doŋgi semündü haya ranɨwamɨ masüfu Baiborambe hoafɨmayo süŋgu. ");
INSERT INTO agg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ai yare hoafɨyowohü yahoya, “Saion ŋgoafɨ, se yɨhɨmbondamboyafɨ! Sɨhafɨ Adükarɨ bogorɨ asüfu ra hoeirɨworɨ. Aiana doŋgi nɨmorɨ ranɨ wamani nɨmarümbo asüfu,” meho. ");
INSERT INTO agg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Horombo ana ahambo süŋgururü-rundeimbɨ ai rananɨ moatükunɨ moai wudɨpoaporu fɨfɨrundɨ. Ŋga süŋguna Sisas ai sünambe hafuane, rasɨmboanɨ ai hohoanɨmomemo Baibor ahambo hoafɨmayo ra. Ranɨyomo asu nindou ai Sisasɨmbo raraorɨhorɨ marɨhündɨ ranahambo fɨfɨrɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Horombo Rasarus ai yɨfɨyu haya hoŋguambeahɨ yaŋguruane, asu Sisas ai ahambo mɨŋgɨmayua hoŋguambeahɨndɨ tükümefiyu ra nindou afɨndɨ ranai ai-dɨbo nɨboadeimbo hoeimarɨhorɨ. Asu nindou afɨndɨ ranai Rasarusɨmbo hoŋguambeahɨndɨ botɨmarirɨ hoafɨ ra sahümündi hehimbo, weindahɨ wataporɨyei wakɨmarɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nindou afɨndɨ ranai Sisas hepünɨfeimbɨ moatükunɨ ramareandɨ hoafɨ ra hɨmborɨyei hehi nafɨnɨ nafoamarɨhorɨ hei. ");
INSERT INTO agg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ranɨyomo asu Farisi ai ahamundɨhoarɨ wataporɨyomondühɨ yahomoya, “Haponda sɨhɨrɨ ra hoerɨhumboanefɨ. Nɨmorehɨ nindowenihɨ muŋgu ahandɨ hoafɨ süŋgurɨhindühɨ wambo ŋgɨrɨ nɨne hohoanɨmo sɨhɨrɨ hohoanɨmomefɨ ra aboedɨndo,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nɨmorehɨ nindowenihɨ ai Pasofa adükarɨ si ra Serusaremɨnambo Godɨmbo hohoanɨmombo masühüsi. Asu ranɨyei Grik bɨdɨfɨrɨ Suda-yafe rotu hohoanɨmo süŋgurɨhindeimbɨ ai Suda-babɨdɨmbo masühüsi. ");
INSERT INTO agg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nindou Grikɨ-mayei ranai Firip Betsaidahündɨ Gariri hɨfambeahɨndɨ ahambo sowahɨ sɨnei düduyahindowohü seiya, “Rɨtɨfo, ro Sisasɨmbo hoeindɨhurɨ sefɨmboanefɨ,” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Asu Firip ai hu Andrumbo hoafɨyundo haya, hafanɨ Sisasɨmbo hoafɨmefɨnando. ");
INSERT INTO agg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ranɨyu asu Sisas ai ahafanɨmbo hoafɨyupɨrühɨ yahuya, “Ndeara ndanɨ sɨmboanɨ ana Nindou Hondü ai ndürɨ adükarɨ ndemündümbui. ");
INSERT INTO agg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ro sɨhafanɨmbo anɨhondümboanahɨ hoafayahapɨrɨ: Wit maŋgɨrɨ ra hɨfɨnɨ pɨrɨkoate-yo haya nɨmbayo ana, asu mamɨ ranɨ yaŋgɨranɨmbo nɨŋgomboe. Ŋga asu wit maŋgɨrɨ ra hɨfɨnɨ peyo haya nɨmbayo ana, asu aboedɨ tükündɨfehü hɨsɨ aboedɨ hɨsɨndɨmboe. ");
INSERT INTO agg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Asu nindou ai ahandɨ fi ranahambo yaŋgɨrɨ afɨndɨ hohoanɨmoayu ana, awandɨhoemboe. Ŋga asu nindou ranai hɨfɨ ndanɨhü ahandɨ yaŋgɨrɨ nɨŋgo hohoanɨmo ra daboadanambo-areandɨ ana, koadürümbo-koadürümbo nüŋgumbui. ");
INSERT INTO agg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nindou mamɨ ai wandɨ ratüpurɨ asemündu ana, asu ai moanɨ wandɨ hohoanɨmo süŋgu yaŋgɨrɨ süŋgumbɨ-randamboane. Ro ŋgoafɨ anɨmboahɨ ranɨh-anɨmbo nindou wandɨ ratüpurɨyu-randeimbɨ ai ro-dɨbo nüŋgumbui. Nindou ra wandɨ ratüpurɨ ranɨ yaŋgɨrɨ semündü anüŋgu ana, asu wandɨ Ape ai ahambo ndürɨ adükarɨ dagadombui,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sisas ai yahuya, “Haponda wandɨ ŋgusüfoambe moaruwai-arandɨrɨ. Asu ro nüŋgumambɨsaha? Asu ro hoafɨndahühɨ, ‘Ape wandɨ fiambe nɨnɨ-moatükunɨyo tüküfembo yahohaya rarawayo nda sowandɨfɨ piro,’ mambɨsahɨyo? Roana ŋgɨrɨ randɨhe hoafɨndahɨ, ŋga wanɨ. Ŋga ro wambo rambɨfeyowambo saheheamboanahɨ ndanɨhü tükeheandɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","O Ape, sɨhafɨ ndürɨ ra adükarɨ-mbeyowamboane.” Sisas ai yare hoafɨmayuwamboyo asu hoafɨ mamɨ sünambeahɨndɨ ndahurai kosɨwohü yahoya, “Ro wandɨ ndürɨ ra adükarɨmbo-rɨheamboanahɨ, ŋga wandɨ ndürɨ ra randɨheandanɨ asükai adükarɨ safɨ tükündɨfemboe,” meho. ");
INSERT INTO agg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nɨmorehɨ nindowenihɨ akɨmɨ manɨboadei ranai hoafɨ ra hɨmborɨyei hehi hoafɨyeihɨ seiya, “Nɨmoamondɨhoafɨ bürügoayo,” masei. Asu bɨdɨfɨrɨ ai seiya, “Sünambeahɨndɨ nend-ani ahambo hoafeindo,” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Asu Sisas ai sɨmborɨ hoafɨyuhɨ yahuya, “Hoafɨ se hɨmborɨmayei ranana wambo farɨhefendɨrɨmbo tüküfehüyopoanɨ, ŋga wanɨ. Ranana sɨheimbo farɨhefe-ndürɨmboane tükefeyo. ");
INSERT INTO agg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Haponda God ai nindou hɨfɨ ndanɨhü anɨboadei ranaheimbo yɨbobo-ndearümbui. Rananɨmbo asu ai Satan ndanɨ hɨfɨ ndanɨhü bogorɨmbofi anüŋgu ra nderümündü pindirümbui. ");
INSERT INTO agg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Rananɨmbo ai wambo botɨndɨhindɨra, asu ro randɨheandüra nindou afɨndɨ ai wambo sowana ŋgeimboyei.” ");
INSERT INTO agg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sisas ai ranɨ hoafɨ hoafɨmayu ra, nindou ai ahambo nɨmɨ keimbɨ karɨhendeimbɨfihɨ panduwuranɨ yifɨndümbui. ");
INSERT INTO agg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ranɨmboyei nindou ai ahambo sɨmborɨ hoafɨyahündowohü seiya, “Krais ai yaŋgɨrɨ koadürümbo-koadürümbo nüŋgumbui, ahɨnümbɨ hohoanɨmo Bukambe ranɨmbo hoafɨmayoa hɨmborɨmayefɨ. Asu se nɨmboeafɨ haponda hoafɨyafühɨ, ‘Nindou Hondü ahambo nɨmoamo ndahorɨmɨndei botɨndɨhora yɨfɨndɨmbui,’ masafa? Asu Nindou Hondü ra düdia?” maseiamboyu. ");
INSERT INTO agg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Asu sɨmborɨ Sisas ai yahuya, “Si ra se-babɨdɨmbo akɨdoumbo anɨmbo nɨŋgomboe. Si yagodowanɨ nɨmbɨ tüküfekoate-yoambe-anɨmbo si ra-dɨbo ŋgei. Nindou ai si wanɨyowanɨ nɨmbokoanɨ ahu ana, ai moai nafɨ hombo ra fɨfɨreandɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Haponda si ra sɨheimbo sowahɨ manɨŋgowa hɨfandɨhümboanei, ŋga se si ranahambo anɨhondümbo-ndɨhindüh-anɨmbo, asu ahandɨ nɨmorɨndei,” mehu. Sisasɨ ranɨ hoafɨ ra rare hoafɨyu mbura asu ai ahei hɨmboarɨhü hu dɨbonapɨmefiyu. ");
INSERT INTO agg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ai hoeirɨhora hepünɨfeimbɨ moatükunɨ afɨndɨ ahei hɨmboahü ratüpurɨyu marandɨyosɨ, ŋga asu ai moai ahambo anɨhondümbo-rɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ranɨmboyo asu Godɨndɨ hoafɨ hoafɨyu-randeimbɨ Aisaiandɨ hoafɨ ra anɨhondü tükümefeyo. Ai hoafɨyuhɨ yahuya, “Adükarɨ, düdi nindou yɨhoefɨ hoafɨ ranahambo anɨhondümbo-areanda? Asu Adükarɨ ranai daboe ŋgɨnɨndɨ hohoanɨmo ra nafuiayundoa?” mehu. ");
INSERT INTO agg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Aisaia ai ŋgorü hoafɨnambo yare sürü papɨrandühɨ yahuya, “God ai ahei hɨmboarɨ ra gabudearümboani. Ranɨmboanei asu ai ŋgɨrɨ raranɨ-moatükunɨ ahei hɨmboarɨnambo ndondɨhi hoeindɨhindɨ. Ahei ŋgusüfoambe ragu God ai nɨmoei nahurai ŋgɨnɨndɨ ramareandüra tükümefeyo. Ranamboane asu ai ŋgɨrɨ ŋgusüfoambe ndondɨhi hohoanɨmondeihɨ wambo sowana hɨhɨndahi dügüsianɨ dɨboadondɨhearü, ŋga wanɨ,” mehu. Aisaia ai ra-mehu ranɨmboanei Suda ai Sisasɨmbo ŋgɨrɨ anɨhondümbo-ndɨhorɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Horombo hondü Sisas hɨfɨnɨ nɨŋgokoate-yuambe Aisaia ai ahandɨ-mayo hɨmboamupuimbo-randeimbɨ hoeire hayamboyu ahambo hoafɨ ra yare hoafɨmayundo. ");
INSERT INTO agg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nindou afɨndɨ bogorɨmboyafu mamarɨmo ai-amboa Sisasɨmbo anɨhondümbo-arüwurɨ. Ŋga Farisimbo yɨhɨmboyomondühɨ wambo ai anɨhondümbo-arüwurɨ hoafɨ ra moai weindahɨ hoafɨyomo. Ai hohoanɨmoyomondühɨ yahomoya “Weindahɨ hoafɨndefanɨ yɨhoefɨmbo rotu worambeahɨndɨ hɨhaiboadɨ-munɨmboemo,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nindou ranahamumbo nindou ai aboed-anemo mbɨseiya yahomo hohoanɨmomemo, ŋga God ai ahamumbo ‘aboed-anemo’ yahombo moai yifirɨyomo. ");
INSERT INTO agg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ranɨyu Sisas ai puküna hoafɨyuhɨ yahuya, “Nindou wambo anɨhondümbo-areandɨrɨ aiana wambo yaŋgɨrɨ anɨhondümbo-reandɨrühɨyupoanɨ. Ŋga ai Ape wambo koamarɨhendɨra makosahɨ ahambo kameihani anɨhondümbo-arirɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Asu nindou wambo hoeiareandɨrɨ ranai Ape wambo koamarɨhendɨra makosahɨ ahambo kameihani hoearirɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Roana, hɨfɨ ndanɨhü si nahurai, nindou ai wambo anɨhondümbo-rɨhindɨrühɨ nɨmbɨ nɨmaroambe nɨŋgokoate-mbeyeia saheheambo makosah-anahɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Asu nindou mamɨ ai wandɨ hoafɨ hɨmborɨyuhü, süŋgufekoate-ayu ana, ro ŋgɨrɨ ahandɨ hohoanɨmo yɨbobondɨhinɨ. Roana hɨfɨ ndanɨhü nindou aheimbo yɨbobofendürɨmbo kosamboyahɨpoanɨ, ŋga wanɨ. Roana aheimbo aboedambo-fendürɨmbo makosah-anahɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Asu nindou ai wambo daboadɨ hɨhɨreandɨrühɨ wandɨ hoafɨ semɨndɨkoate-ayu ana, ahambo ahandɨ hohoanɨmo yɨbobofe hoafɨ ra yagododomboe. Hoafɨ ro hoafɨmayahɨ rananɨmbo bɨdɨfɨranɨ si tüküfeyoambe yɨbobondeirɨmboe. ");
INSERT INTO agg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Hoafɨ nda ropoanɨmbo hohoanɨmoya hehea hoafɨyahühɨ-yahɨpoanɨ, ŋga wanɨ. Ape wambo koamarɨhendɨra makosahɨ ranai muŋgu moatükunɨ Se hoafɨndafɨndürü, mehuamboanahɨ hoafayahɨ. ");
INSERT INTO agg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ro hoafɨ ra fɨfɨrɨheamboanahɨ. Apendɨ hoafana aboedɨ yaŋgɨrɨ koadürümbo-koadürümbo nɨŋgo-randeimb-ane. Ranɨmboanahɨ Ape ai wambo hoafɨmayundɨra asu muŋgu hoafɨ nda sɨheimbo hoafayahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sudayei mamɨ adükarɨ si Pasofa sei-arɨhündɨ ranai tüküfembo yaŋgɨrɨyoambe Sisas ai hɨfɨ nda hɨnɨŋgɨfe hefe, ahandɨ Afɨndɨ sowanambo hafombo si ra tükümefeyoa fɨfɨrɨmareandɨ. Ai ahandɨ nendɨ afɨndɨ hɨfɨ ndanɨhü burayei aheimbo afɨndɨ ŋgusüfo pamareandürɨ. Ai aheimbo horombo piyu haya ŋgusüfo pareandürɨ huhumbo ndeara yɨfɨmbo yaŋgɨrɨyuhü afɨndɨ hamɨndɨ ŋgusüfo pamareandürɨ. ");
INSERT INTO agg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Sapo Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo sowasümondühɨ nɨmarɨmondane asu Satan ai Saimonɨndɨ nɨmorɨ Sudas Iskariot ahandɨ fiambe hohoanɨmo moaruwai masagadowa Sisasɨmbo ahandɨ hürütümbɨ-yafe warɨhüfimbo mehu. ");
INSERT INTO agg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sisas ai fɨfɨreandɨ Afɨndɨ ai ahambo muŋguambo moatükunɨ hɨfandɨmbo ŋgɨnɨndɨ adükarɨ masagado ra. Asu Godɨmbo sowahɨndɨ makusu ra fɨfɨreandɨ ranɨmbo ai Ahambo sowana gafumbui. ");
INSERT INTO agg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ranɨmboyu asu ai sesɨ sesambeahɨndɨ hɨnɨŋgɨre botɨfi, ŋgɨsɨharɨ hoearɨ yimündamündü mbura, tawor mamɨ semündü ahandɨ mbusümondühɨ hühüre hɨnɨŋgɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ranɨyu asu ai hoe semündü disambe kare mbura, ahambo süŋgururü-rundeimbɨmbo ahamundɨ tɨŋarɨ ra popoairapurühɨ tawor mbusümondühɨ hühümareandɨ ranambo gedümarapurɨ. ");
INSERT INTO agg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ranɨyu asu Sisas ai Saimon Pitambo sowana masünuwamboyu, asu Pita ai hepünɨfi hoafɨyundühɨ yahuya, “Adükarɨ, se wandɨ tɨŋarɨ popoaimbo safɨmboyafɨ?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Asu Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Ro haponda ratüpurayahɨ ndanana se moai fɨfɨrowandɨ. Ŋga süŋgunambo-anɨmbo ranahambo fɨfɨrɨndowamboyafɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Asu Pita ai yahuya, “Se wandana tɨŋarɨ ra popoaindamboyafɨ, ŋga yowanɨ,” mehuamboyu. Asu Sisas ai sɨmborɨ kafoare hoafɨyunduhü yahuya, “Asu ro sɨhambo popoaiyonɨnɨkoate-ayahɨ ana, asu se ŋgɨrɨ wandɨ süŋguro-randeimbɨndafoandɨ,” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Asu Saimon Pita ai sɨmborɨ yahuya, “Adükarɨ, ambe, wandɨ tɨŋarɨ yaŋgɨrɨ popoaiyondɨrɨ ana. Ŋga wandɨ watɨŋarɨ ŋgusümboarɨ ra kameihɨ amboanɨ popoaindandɨrɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Asu Sisas ai ahambo yahuya, “Nindou ai ahandɨ fi ra muŋgu hundürɨyu hayamboayu ana, asu asükaindu ŋgɨrɨ hundürümbo hohoanɨmondu. Ai tɨŋarɨ yaŋgɨrɨ amboanɨ popoaiafoareandɨ ra afɨsaho paiarɨkoate aboedɨyuhani. Se afɨsaho-koate aboedɨ anɨŋgomo, ŋga se muŋguamboemopoanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Sisas ai nindou mamɨ ahambo ahandɨ hürütümbɨ-yomondɨ warɨhüfimbo mehu ahambo fɨfɨrirɨ. Ranɨmboyu ai ahamumbo hoafɨyupurühɨ, “Seana moai muŋguambo afɨsaho-koate nɨŋgomo,” mehupurɨ.) ");
INSERT INTO agg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sisas ai ahamundɨ tɨŋarɨ popoairapurɨ mburamboyu, asu asükaiyu ahandɨ ŋgɨsɨharɨ hoearɨ ra güde haya, sesɨ yaŋgoro fondanɨ mahu. Hu nɨmarümbo ahamumbo düdufipurühɨ yahuya, “Haponda sɨhamundɨ tɨŋarɨ popoaimarɨhandɨ. Se wandɨ ratüpurɨ nda fɨfɨrundai? ");
INSERT INTO agg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Se wambo dükarundürühɨ ‘Yamundo-randeimbɨ,’ asu ‘Adükarɨ,’ yahomo arundɨ, ranana anɨhond-anesɨ, ŋga ro ran-anahɨ. ");
INSERT INTO agg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Roana sɨhamundɨ Adükarɨmboya asu Yamundɨhe-rɨhandeimb-anahɨ. Ranɨyahɨ asu ro sɨhamundɨ tɨŋarɨ popoaimarɨhapurɨ. Asu yahurai se-amboanɨ sɨhamundɨhoarɨ ŋgoründɨ hoarehɨndɨmondühɨ sɨmborɨ fehefirɨndɨmo. ");
INSERT INTO agg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ro sɨhamumbo nafuimbohünda ramarɨheandɨ nou, se nindou ŋgorümbo ranɨ-süŋgundundɨ. ");
INSERT INTO agg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ro anɨhondümboanahɨ hoafayahapurɨ: Ratüpurɨyu-randeimbɨ nindou ai ahandɨ bogorɨmbo ŋgasündirümboyupoanɨ. Asu nindou ratüpurɨmbo ahu ranai nindou ahambo koamarɨherü ahandɨ nɨmoamoyupoanɨ. ");
INSERT INTO agg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Asu se ranɨ-moatükunɨ ranahambo anɨhond-ane yahomo fɨfɨrundühɨ, ranɨ-süŋguarundɨ ana, se ranɨmbo hɨhɨfɨ-hɨhɨfɨndɨmboemo. ");
INSERT INTO agg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ro sɨhamumbo muŋguambo hoafɨyaha-purühɨyahɨpoanɨ. Ro sɨhamumbo dɨbonɨmehapurɨ fɨfɨrɨheapurɨ-mboanahɨ. Ŋga sehündɨ mamɨ wambo refendɨrɨmbo-mayu ranahandɨ hoafɨ Baiborambe hoafɨmayo ra anɨhondü tükündɨfemboe. Hoafɨ ra yare hoafɨyohü yahoya, “Nindou sesɨ mamühɨ asahoasehɨ ranai wandɨ hürütümbɨ tükündüfimbui,” meho. ");
INSERT INTO agg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Awi ndanɨ moatükunɨ ra moai haponda tüküfeyoanɨyahɨpoanɨ ranahambo hoafayahɨ. Rananɨmbo ndanɨ moatükunɨ ra süŋgunambo tükündɨfeyoanɨ, asu se wambo anɨhondümbo-ndundɨrɨ ro God ai sɨheimbo aboedambo-fembohünda koamarɨhendɨr-anahɨ. ");
INSERT INTO agg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ro anɨhondümboanahɨ sɨhamumbo hoafayahɨ: Nindou düdi ro nindou koararɨhehinɨ ranahambo aserümündu ana, ai wambo kameihɨ semündündɨrühani. Asu nindou düdi wambo asemündündɨrɨ ranai nindou wambo koamarɨhendɨrɨ ahambo amboanɨ serümündühani,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Sisas ai yare hoafɨyuwane asu ahandɨ ŋgusüfoambe moaruwai-marɨrɨ. Asu ai hoafɨyuhɨ yahuya, “Ro anɨhondümboanahɨ sɨhamumbo hoafayahapurɨ: Nindou mamɨ sɨhamundɨ mbusümo anüŋgu ai-anɨmbo wambo hürütümbɨ-yomondɨ warɨhündea-ndɨrɨmbui,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Sisas ai yare hoafɨmayuamboemo asu ai sɨmborɨ hɨmboapefirümemo. Asu ai moai fɨfɨrundɨ Sisas ai nindou dabombei yare hoafɨmayu ra. ");
INSERT INTO agg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nindou Sisasɨmbo süŋgururü-rundeimbɨ ahandɨ ŋgusüfoahündɨ ai ahandɨ fikɨmɨ mamaru. ");
INSERT INTO agg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ranɨyu asu Saimon Pita ai ahambo mbɨro kareandühɨ yahuya, “Se Sisasɨmbo düdurɨworɨ, ai nindou daboe yare hoafayu rana,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Asu ai Sisasɨmbo sowana sühüfi hüfuhü düdufinduhü yahuya, “Adükarɨ, nindou ra düdia?” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Asu Sisas ai sɨmborɨ yahuya, “Awi ro bret bɨdɨfɨrɨ sesɨ hoeambe foandɨhe hehea ndahandomboyahɨ. Ro sesɨ asahando nindou aiani,” mehu. Ranɨyu asu ai bret bɨdɨfɨrɨ ra sesɨ hoeambe foare mbura, Sudas Iskariot, Saimonɨndɨ nɨmorɨ-mayu, ahambo masagado. ");
INSERT INTO agg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sudas ai Sisasɨndɨ hürütümbɨ-yomondɨ warɨhüfimbo hohoanɨmoyuhü sesɨ ra semündü hayamboyuwane asu Satan ranai ahandɨ fiambe mafarɨfiyu. Ranɨyu asu Sisas ai ahambo yahuya, “Se ranɨ-moatükunɨ ratüpurɨmbo ana, nɨmai ratüpurɨyafɨsɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nindou sesɨ fikɨmɨ nɨnoumemo ai mamai-amboanɨ moai Sisas hoafɨmayu ranahambo fɨfɨreandɨ. ");
INSERT INTO agg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nindou bɨdɨfɨrɨ ai Sudas ahamundɨ kakɨ hɨpɨrɨ hɨfandarandɨ ai adükarɨ si sesesɨmbo hoafɨmayundowambo sesɨ pemɨmboani yahomo asu nindou kakɨkoate-mayei aheimbo saimboani yahomo raraomarundɨ. ");
INSERT INTO agg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nɨmbɨ mamarowamboyu Sudas ai bret bɨdɨfɨrɨ Sisas masagado ra semündü haya hɨfɨnambo makusɨfoendɨ. ");
INSERT INTO agg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Sudas ai hɨfɨna makusɨfoendamboyu, asu Sisas ai yahuya, “Haponda Nindou Hondü ai ndürümb-ani yahombo ra weindahɨ tükündɨfemboe. Rananɨmbo asu Nindou Hondü ai God ndürümbayu ra weindahɨndirɨmbui. ");
INSERT INTO agg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Asu Nindou Hondü ai God ndürümbayu ra weindaharirɨ ana, asu God ai ahandɨ süŋgu Nindou Hondü ndürümbayu ra nɨmehünou weindahɨndirɨmbui. ");
INSERT INTO agg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nɨmoakɨdɨbou, ro ŋgɨrɨ se-babɨdɨmbo gedühɨ nɨmboahɨ. Se wambo kokondundɨrɨ-mboemo, ŋga se ŋgɨrɨ hoeindundɨrɨ. Horombo Sudambo hoafɨmayahɨ ro homboayahɨ ŋgoafɨ ranambe se ŋgɨrɨ ŋgei. ");
INSERT INTO agg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ro sɨhamumbo sɨmborɨ hohoanɨmo asahapurɨ. Wandafɨ mamɨ, se sɨhamundɨhoarɨ sɨmborɨ ŋgusüfo pefirɨndɨmo, ro sɨhamumbo ŋgusüfo pararɨheapurɨ nou. ");
INSERT INTO agg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Asu se sɨhamundɨhoarɨ sɨmborɨ ŋgusüfo pefirɨndɨmondan-anɨmbo nindou ai sɨhamumbo amboa ‘ahambo süŋgururü-rundeimb-anemo’ mbɨseimboyei,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita ai hoafɨyunduhü yahuya, “Adükarɨ, se nahanamboyafa?” mehundowamboyu. Asu Sisas ai ahambo sɨmborɨ yahuya, “Ro nahanafɨyo ahahɨ ra-nafɨ ana se ŋgɨrɨ wandɨ süŋgu ŋgafɨ. Ŋga süŋgunambo-anɨmbo ra-nafɨ wandɨ süŋgu ŋgamboyafɨ,” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Asu Pita ai asükaiyu sɨmborɨ hoafɨyunduhü yahuya, “Asu nɨmboe ro haponda sɨhafɨ süŋgu sɨnɨkoate-ayaha. Sɨhambondünɨnɨ asu wambondündɨrɨ ndümboemo,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Asu Sisas ai ahambo sɨmborɨ hoafɨyundühɨ yahuya, “Se wamboyondɨrɨ asu sɨhamboyonɨnɨ rambo hoafayafɨsɨ, ŋga ro sɨhambo anɨhondümboanahɨ hoafayahanɨnɨ: Kakaro hoafɨkoate-yuambe-anɨmbo se ŋgɨmɨmbo hoafɨndafühɨ anɨmboya ‘Ro moai Sisasɨmbo fɨfɨrɨhinɨ,’ mbɨsamboyafɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sisas ai hoafɨyupurühɨ yahuya, “Se ŋgusüfoambe hepünafundühɨ afɨndɨ hohoanɨmo-ndɨmboemo. Ŋga se Godɨmbo-anɨmbo anɨhondümbo-ndüwurɨ. Asu se wambo amboanɨ anɨhondümbo-ndundɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wandɨ Apendɨ worɨ ana fondɨ afɨnd-ane. Ŋga roana sɨhamumbo fondɨ dɨboadɨfembo kameihɨ hahühühanahɨ. Asu ranɨ-moatükunɨ ra tɨkaimbe-mbonana, ro ŋgɨrɨ sɨhamumbo hoafɨyahapurɨ. ");
INSERT INTO agg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ro ŋga sɨhamumbo fondɨ dɨboadondɨhe hɨnɨŋgɨndɨhe heambo-anɨmbo, asükainda sɨhamumbo sepurɨmɨndɨmbo kodamboyahɨ. Asu rananɨmbo se ŋgoafɨ ro amarɨhɨ ranɨhü se-amboanɨ nɨmandɨmboemo. ");
INSERT INTO agg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ro ahahɨ nafɨ ho ra se fɨfɨrumboanemo,” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Asu Tomas ai hoafɨyundühɨ yahuya, “Adükarɨ, roana moai fɨfɨrɨhundɨ se hombo asafɨ ranana. Nüŋgundɨhu ro fɨfɨrɨmandɨhu ra-nafɨ ho rana?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Asu Sisas ai sɨmborɨ hoafɨyunduhü yahuya, “Roanahɨ nafayahɨ, anɨhondü hoafɨ, asu yaŋgɨrɨ nɨŋgombo ra nɨmɨndühayahɨ. Nindou mamai-amboanɨ ŋgɨrɨ ŋgorü nafɨndüfi Ape sowahɨ tükündɨfiyu, ŋga roanahɨ nafayahɨ. ");
INSERT INTO agg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Asu se wambo fɨfɨrarundɨrɨ ana, wandɨ Apembo amboanɨ fɨfɨrɨndü-wurɨmboemo. Ŋga hapoadümbo se hoeirüwurɨ houmbo fɨfɨrarüwurɨ,” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Asu Firip ai hoafɨyunduhü yahuya, “Adükarɨ, se yɨhoefɨmbo Ape ra nafuiyafɨmunɨ. Rananɨmbo yɨhoefɨmbo waŋgei-mbeyowamboane,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Asu Sisas ai sɨmborɨ hoafɨyunduhü yahuya, “Firip, ro se-babɨdɨmbo gedühɨ manɨmboahɨ ranane asu se wambo fɨfɨrɨfendɨrɨ-koate-ayafɨ? Düdi wambo hoeimareandɨrɨ ranai ana Apembo-amboanɨ hoeirirɨ. Asu se ŋgɨrɨ hoafɨndafühɨ, ‘yɨhoefɨmbo Ape ra nafuiyafɨmunɨ,’ mbɨsafɨ. ");
INSERT INTO agg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Seana moai anɨhondümbo-mbaropoanɨ ro Ape sowahɨ anɨmboahɨ asu Ape ai wambo sowahɨ anüŋgu ra? Hoafɨ ro masahapurɨ ra ropoanɨmbo hohoanɨmoya hehea sahapurɨmbo-yahɨpoanɨ. Ŋga Ape ro dɨbofihani ai ahandɨ ratüpurɨ ra ratüpurɨyu arandɨ. ");
INSERT INTO agg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Se hoafɨ ndanahambo anɨhondümbo-ndundɨ: Ro Ape-dɨbo-anahɨ asu Ape ai ro-dɨbo-ani. Ra wanɨndoanɨ ana, asu se ro muŋgu hepünɨfeimbɨ moatükunɨ ratüpurɨya marɨhandɨ ranahambo hohoanɨmondɨmondühɨ anɨhondümbo-ndundɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ro sɨhamumbo anɨhondümboanahɨ hoafayahapurɨ: Nindou ai wambo anɨhondümbo-areandɨrɨ ana, ai-amboanɨ hepünɨfeimbɨ moatükunɨ rande ratüpurɨndümbui. Rananɨmbo asu ai wandɨ ratüpurɨ ŋgasündeandeimbɨ ratüpurɨndümbui sapo ro Ape sowana hahühühɨ wambo. ");
INSERT INTO agg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Asu se muŋgu moatükunɨ wandɨ ndürɨ süŋguna dɨdɨbafefundɨ ana, ro randɨheamboyahɨ Ape ai wandɨ süŋgu ndürɨ adükarɨ semɨndɨmbohünda. ");
INSERT INTO agg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Asu muŋgu moatükunɨ se wandɨ ndürɨna dɨdɨbafefundɨ ana, ro randɨheamboyahɨ.” ");
INSERT INTO agg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Asu se wambo ŋgusüfo pararundɨrɨ ana, se wandɨ-mayo hohoanɨmo ra süŋgundumboemo. ");
INSERT INTO agg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Asu ro Apembo dɨdɨbafɨ-ndaheandanɨ ai sɨhamumbo ŋgorü farɨhefe-mbohünda dagapurɨmbui. Asu ai se-babɨdɨmbo koadürümbo-koadürümbo nɨŋgomboe. ");
INSERT INTO agg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Farɨhe-randeimbɨ ndanana anɨhondü hoafɨyo-randeimbɨ Yifiafɨ Aboedɨ ranane. Hɨfɨnɨndɨ nindou aiana ŋgɨrɨ Yifiafɨ Aboedɨ ndanahambo ndahümündi. Asu ai moai Yifiafɨ hoeirɨhi fɨfɨrɨhi raraorɨhündɨ, ŋga wanɨ. Ŋga se ahambo fɨfɨrundɨ asu aiana se-babɨdɨmbo sɨhamundɨ mbusümo nɨŋgomboe. ");
INSERT INTO agg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ŋgɨrɨ ro hɨnɨŋgɨ-ndɨheapuranɨ asühɨ nɨmorɨ nahurai nɨŋgomo, ŋga sɨhamumbo sowana kodamboyahɨ. ");
INSERT INTO agg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nindou hɨfɨ ndanɨhündambo ai ŋgɨrɨ amɨtata wambo hoeife-ndɨrɨkoate-ndei, ŋga seana wambo hoeindundɨrɨmboemo. Ro hɨfɨ ndanɨhü yaŋgɨrɨ nɨmboahambo wambo asu se-amboanɨ yaŋgɨrɨ nɨŋgomboemo. ");
INSERT INTO agg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ro yɨfɨhündɨ botɨndaheandanɨ ranɨ-sɨmboanɨ ro wandɨ Ape-dɨbo nɨmboahanɨ asu se ro-dɨbo nɨŋgomondanɨ asu ro se-babɨdɨmbo anɨmboahɨ ra fɨfɨrɨndumboemo. ");
INSERT INTO agg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nindou wandɨ hohoanɨmo ra süŋguareandɨ ranai ana wambo ŋgusüfo pareandɨrühani. Nindou wambo ŋgusüfo parareandɨrɨ ranahambo wandɨ Ape ai ŋgusüfo parirühani. Asu ro-amboanɨ, ahandɨ hɨmboahü weindahɨ tükündaheandühɨ, asu ahambo ŋgusüfo pandɨhinɨmboyahɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Asu Sudas, (Sudas Iskariotɨ-yupoanɨ, ŋga ŋgorü Sudas,) ai Sisasɨmbo hoafɨyundühɨ yahuya, “Adükarɨ, se nɨmboeafɨ yɨhoefɨ hɨmboahü weindahɨ tükündafoandühɨ asu nindou hɨfɨ ndanɨhü anɨboadei ahei hɨmboahü weindahɨ tüküfekoate-ayafa?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Asu Sisas ai sɨmborɨ ahambo hoafɨyundühɨ yahuya, “Nindou ranai wambo ŋgusüfo parareandɨrɨ ana, ai wandɨ hoafɨ ranɨ-süŋgundeambui. Rananɨmbo asu wandɨ Ape ai ahambo ŋgusüfo pandirümbui. Rananɨmbo asu ro Ape-dɨbo ahambo sowahɨ ŋge ai-babɨdɨ koadürümbo-koadürümbo nɨmboemboyehɨ. ");
INSERT INTO agg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nindou wambo ŋgusüfo pefendɨrɨkoateyu-randeimbɨ-mayu ranana wandɨ yamundɨfe hoafɨ moai süŋgureandɨ. Hoafɨ haponda se hɨmborayomo nda wandɨ hoafɨ yaŋgɨrɨyopoanɨ, ŋga wanɨ. Wambo Ape koarɨhendɨra makosahɨ ahandɨ-mayo-ane hoafɨ nda. ");
INSERT INTO agg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Awi ro se-babɨdɨmbo nɨmboamboanahɨ asu ro sɨhamumbo ndanɨ moatükunɨ hoafɨ nda hoafayahapurɨ. ");
INSERT INTO agg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ŋga Farɨhai-randeimbɨ ranana Yifiafɨ Aboed-ane. Asu wandɨ ndürɨ süŋgunambo-anɨmbo ahambo Ape ai koandɨhendanɨ kodɨmboe. Ai-anɨmbo sɨhamumbo muŋgu moatükunɨ ranahambo yamundeapurɨmboe. Asu ai sɨhamumbo ŋgusüfoambe horɨndeapura sɨhamumbo ro hoafɨyahapureimbɨ ra asükaindɨmo hohoanɨmondɨmboemo. ");
INSERT INTO agg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ro sɨhamumbo randɨheapuranɨ se ŋgusüfo afurɨndu kündumboemo. Ŋgusüfo afurɨfe kife hohoanɨmo wandɨ-mayo ra asahapurɨ. Ro ŋgusüfo afurɨfe kife hohoanɨmo asahapurɨ nda nindou hɨfɨ ndanɨhündambo asahüpurɨ nahurai-yopoanɨ, ŋga wanɨ. Se ŋgusüfo sɨhamundɨ ra afɨndɨ hohoanɨmo-ndɨmondühɨ yɨhɨmbondɨmboemo. ");
INSERT INTO agg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ro ranɨ hoafɨ sɨhamumbo masahapurɨ ra se fɨfɨrundɨ: ‘Roana ndearambo sɨhamumbo hɨnɨŋgɨrɨ-heapurühanahɨ, ŋga asükainda tükündaheamboyahɨ.’ Se wambo ŋgusüfo pambarundɨrɨ-mbonana, asu ro haponda Ape sowana ahahühɨ ndanɨmbo hɨhɨfɨ-hɨhɨfɨyomo. Nɨmboe sapo Ape ai adükarɨ saf-ani asu wambo ŋgasündeandɨrɨ-mboani. ");
INSERT INTO agg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yifiafɨ Aboedɨ kosowanɨ-yahɨpoanɨ hoafɨyahapurɨ. Rananɨmbo asu süŋgunambo ra tükündɨfeyoanɨ ranahambo anɨhondümbo-ndundɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Hɨfɨ ndanɨhündambo hɨfandɨ-randeimbɨ Satan ai ndeara haponda tükümefiyuwambo ro ŋgɨrɨ se-babɨdɨmbo afurɨ gedühɨ wataporɨndahɨ. Satan ai ŋgɨrɨ wambo hɨbadandɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ŋga nindou hɨfɨ ndanɨhü anɨboadei ranai ro Apembo ŋgusüfo parɨhinɨ arɨhandɨ ranɨmbo fɨfɨrɨ-mbɨrɨhindamboane. Ranɨmboane asu Ape ai hoafɨmayundɨrambo ratüpurɨya arɨhandɨ. Se botɨyafu houmbo, mborai sɨhɨrɨ ŋgefombo,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Roana wain nɨmɨndɨ hond-anahɨ. Asu wandɨ Ape ai wain nümbürɨ ranɨ aharambür-ani. ");
INSERT INTO agg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Wandɨ düdüdü ra hɨsɨkoate-yowanɨ, asu nümbürɨ aharambürɨ ranai düdüdü ra hɨfɨtɨrɨhairandühani. Düdüdü hɨsɨyo-randeimbɨ ranana Ape ai afɨndɨ hɨsɨmbeyowa yahuhaya dɨboadore-randühani. ");
INSERT INTO agg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Seana ro hoafɨ hoafɨmayahapurɨ ranambo ndeara afɨndɨ hɨsɨmbohünda hɨfɨtɨrɨhoemombo nahurai-anemo anɨŋgomo. ");
INSERT INTO agg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Asu se wandɨ hoafɨ süŋguarund-anɨmbo, se ro-dɨbo nɨŋgomboemo asu ro-amboanɨ se-babɨdɨmbo nɨmboamboyahɨ. Asu wain düdüdü ra nɨmɨndɨ ranɨfihɨ pefekoate-ayo ana, ŋgɨrɨ nɨmɨ ra hɨsɨndo ndandɨ. Ranɨmboane asu se-amboanɨ ro-dɨbo nɨŋgokoate-ayomo ana, ŋgɨrɨ hɨseimbɨ nɨmɨ nou nɨŋgomo. ");
INSERT INTO agg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ro wain bogorɨ nɨmɨnd-anahɨ, ŋga asu se wain nɨmɨndɨ ranahandambo düdüd-anemo. Nindou ranai ro-dɨbo nüŋguanɨ asu ro ai-dɨbo anɨmboahɨ ana, ai hɨsɨ afɨndɨ hɨsɨyu randühani. Ŋga se wambo hɨnɨŋgarundɨrɨ ana, asu se ŋgɨrɨ raranɨ moatükunɨ randundɨ. ");
INSERT INTO agg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Asu nindou mamɨ ai ro-dɨbo nɨŋgokoate-ayu ana, ai wain düdü rawefeyo nou kandɨhauranɨ asu yaparɨndümbui. Rananɨmbo nindou ai düdüdü ra gugundu mbundumbo, haimbo mandɨfembohünda haiambe pütindafumboemo. ");
INSERT INTO agg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Asu se ro-babɨdɨmbo nɨŋgomombo wandɨ hoafɨ süŋguarundɨ ana, se nɨnɨ-moatükunɨmboyo hohoanɨmoemo ranahambo dɨdɨbafɨndafundɨ. Rananɨmbo se nɨnɨ-moatükunɨmboyo dɨdɨbafɨmefundɨ ra sɨhamumbo sowahɨ tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Asu se nɨmɨ nou afɨndɨ hɨsɨ hɨsemo ana, se wandɨ süŋgu-rundeimbɨmbondafu nɨŋgomboemo. Rananɨmbo asu wandɨ Ape ai ndüreimbɨndümbui. ");
INSERT INTO agg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Asu ro sɨhamumbo ŋgusüfo pamarɨheapurɨ Ape ai wambo ŋgusüfo pamareandɨrɨ nou. Se koadürümbo-koadürümbo ŋgusüfo pefe hohoanɨmo wandɨ-mayo ndanɨ mbusümo nɨŋgomo. ");
INSERT INTO agg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Asu se wandɨ hoafɨ ranɨ yaŋgɨrɨ süŋguarundɨ ana, se wandɨ ŋgusüfo pefe hohoanɨmo ranɨ mbusümo nɨŋgomboemo. Ro-amboanɨ wandɨ Apendɨ hoafɨ ranɨ-süŋgurɨhe hehea, asu ahandɨ ŋgusüfo pefe hohoanɨmo ranɨ mbusümo anɨmboahɨ. ");
INSERT INTO agg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Asu se ro hɨhɨfɨ-hɨhɨfayahɨ nou hɨhɨfɨ-hɨhɨfɨmbeyomonda sahehea hoafɨ muŋgu ra hoafɨmayahapurɨ. Asu hɨhɨfɨ-hɨhɨfɨ ra sɨhamundɨ ŋgusüfoambe afɨndɨ safɨ tükümbɨfeyoa sambanahɨ. ");
INSERT INTO agg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Wandɨ hoafɨ ndanana ndahurai-ane: Ro sɨhamumbo ŋgusüfo pararɨheapurɨ nou-anɨmbo se-amboanɨ sɨhamundɨ wandafɨ mamɨmbo ŋgusüfo pandüpurɨ. ");
INSERT INTO agg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Asu nindou mamɨ ai ahandɨ ŋgunindɨ fehefembohünda yɨfayu ana, moai nindou ŋgorümbo ŋgusüfo pefe hohoanɨmo ranahambo ŋgasündeandɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Asu se ro hoafayahɨ ra süŋgurundühɨ rawarundɨ ana, se wandɨ wandafɨ mam-anemo. ");
INSERT INTO agg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Haponda ro ŋgɨrɨ sɨhamumbo wandɨ ratüpurɨyomo-rundeimbɨ mbɨsa dükandɨheapurɨ, ŋga wanɨ. Sapo ratüpurɨyu-randeimbɨ ai ana ahandɨ bogorɨndɨ hohoanɨmo ra ŋgɨrɨ fɨfɨrɨndeandɨ. Ŋga asu ro haponda sɨhamumbo ‘wandafɨ mam-anemo’ asahapurɨ. Nɨmboe ro muŋgu moatükunɨ wandɨ Apendɨ-mayo hoafɨ hɨmborɨya heheambo wamboanahɨ rawasahɨ. ");
INSERT INTO agg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Seana moai wambo ‘ai yɨhoef-ani’ yahomo dɨbonɨyomondɨrɨ, ŋga wanɨ. Ŋga sɨmborɨ sɨhamumboyahɨ ro ‘ai wand-anemo’ sa dɨbonɨya hɨnɨŋgɨ-marɨheapurɨ. Ranɨyahɨ ro sɨhamumbo ratüpurɨfihɨ tümarɨheapurɨ nɨmɨ nou hɨsɨyomondühɨ, asu mare hɨsɨ yaŋgɨrɨ mbɨnɨŋgowa sahehea. Ranɨmbo-hündambo-anɨmbo se Apembo wandɨ ndürɨnambo dɨdɨbafɨ-ndafundanɨ raranɨ-moatükunɨ se dɨdɨbafɨmefundɨ ra dagapurümbui. ");
INSERT INTO agg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hoafɨ nda ro sɨhamumbo randundɨ asahapurɨ, se sɨhamundɨhoarɨ sɨmborɨ ŋgusüfo pefendürɨndɨmo,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Asu nindou hɨfɨ ndanɨhündambo ai sɨhamumbo yɨboaruko-arɨhipurɨ ana, se fɨfɨrɨndundɨ horombo wambo boatei yɨboaruko-marɨhindɨrane. ");
INSERT INTO agg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Asu se hɨfɨ ndanɨhündambombemo-mbonana, nindou hɨfɨ ndanɨhündambo sɨhamumbo, ‘yɨhoefɨ wandafɨ mam-anemo’ mbɨseihü ŋgusüfo pandɨhipurɨmboyei. Ŋga ro sɨhamumbo hɨfɨ ndanɨhündambo fihɨmarɨhapurɨ-mɨndühane, ŋga seana hɨfɨ ndanɨhündambo-yomopoanɨ. Ŋga ranɨmboanei asu nindou hɨfɨ ndanɨhündüambo ai sɨhamumbo yɨboaruko-arɨhipurɨ. ");
INSERT INTO agg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ro sɨhamumbo hoafayahapurɨ nda ndondu hohoanɨmondɨmo: Ratüpurɨyu-randeimbɨ nindou ai ahandɨ bogorɨ ranahambo ŋgasündirümbo-yupoanɨ. Wambo moaruwaimbo-arɨhindɨrɨ nou-anɨmbo asu sɨhamumbo amboanɨ moaruwaimbo-ndɨhipurɨmboyei. Asu ai wandɨ hoafɨ süŋgumbarɨhi-mbonana, sɨhamundɨ hoafɨ amboanɨ süŋgundɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Asu aiana moai Ape wambo koarɨhendɨra makosahɨ ranahambo fɨfɨrɨhorɨ. Se ro dɨborɨhɨndɨ-memondambo wambo sɨhamumbo raranɨ moatükunɨmbo moaruwai randɨhipurɨmboyei. ");
INSERT INTO agg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Asu ro kosɨ aheimbo ranɨ hoafɨ ra hoafɨkoate-mbayahɨ-mbonana ahei moaruwai hohoanɨmo ranahambo ŋgɨrɨ hütiyei. Ŋga hapondanana ro hoafɨyahandürɨ heheambo wambo ai ŋgɨrɨ ahei moaruwai hohoanɨmo ra ŋgorü-süŋgundɨhi hoafɨndei. ");
INSERT INTO agg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nindou ranai wambo yɨboaruko-areandɨrɨ ana, asu ai wandɨ Apembo amboanɨ yɨboaruko-rirühani. ");
INSERT INTO agg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ro raranɨ ratüpurɨ nindou amurɨ ai ratüpurɨkoate-mayei ranɨyo ahei mbusümo ratüpurɨmayahɨ. Asu ro ranɨ ratüpurɨ refekoate-mbehɨ-mbonana ai ahei moaruwai hohoanɨmo ranahambo hütiyeipoanɨ. Ŋga haponda ro ratüpurɨmayahɨ ra hoeirɨhimboaneisɨ, ŋga asu Ape-dɨbo yɨhoehɨmbo yɨboaruko-marɨhimunɨ. ");
INSERT INTO agg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ahɨnümbɨ hoafɨ sürü pare masɨhendɨ ranai yare hoafɨyohü yahoya, “Wambo moanɨ hoaŋgɨrɨhi hehi yɨboaruko-marɨhindɨrɨ,” meho. Hoafɨ ra anɨhondümbo tüküfembohünda ai wambo yɨboaruko-marɨhindɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ro Farɨhai-randeimbɨ Ape sowahɨndɨ koandɨheheanda sɨhamumbo sowana kodɨmboe. Yifiafɨ ranana anɨhondü hondü hoafɨyo-randeimb-ane. Ai kodɨ wandɨ ratüpurɨ ranahambo sɨhamumbo hoafɨndɨpurɨmboe. ");
INSERT INTO agg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Horombo se ro-babɨdɨmbo manɨŋgomonda asu ro ratüpurɨ ra weaŋgurühɨ peya hehea ratüpurɨmayahɨ, asu hapondanɨ amboanɨ se anɨŋgomo. Ranɨmbo-hündambo-anɨmbo se-amboanɨ hoafɨ ra weindahɨ tükündafu hoafɨndɨmo,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Sisas ai yahuya, “Sɨhamundɨ anɨhondümbofe ra hɨnɨŋgɨndumboemo saheheamboyahɨ hoafɨ ra rarɨhe hoafɨmayahapurɨ. ");
INSERT INTO agg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sɨhamumbo ai-babɨdɨmbo rotumbo yowanɨ mbɨsɨmboemo. Süŋgunambo ranɨ-moatükunɨ ra tükündɨfeyoan-anɨmbo asu ai hoafɨndɨmondühɨ anɨmboya, ‘Sɨhɨrɨ Godɨmbo ratüpurɨndefühɨ Sisasɨmbo süŋgururü-rundeimbɨ hɨfokoa-ndɨhupurɨmboane,’ mbɨsɨmboemo. ");
INSERT INTO agg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ai moai Apembo fɨfɨrüwurɨ asu wambo fɨfɨrundɨrɨ, ŋga wanɨ. Ranɨmbo-hündambo-anɨmbo ai ranɨ hohoanɨmo ra randu ratüpurɨndɨmboemo. ");
INSERT INTO agg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ro sɨhamumbo ranɨ-moatükunɨ ra hoafɨyahapureimb-ane. Ŋga asu süŋgunambo-anɨmbo ranɨ-moatükunɨ ra tükündɨfeyoanɨ horombo ro hoafɨmayahapurɨ ranahambo hohoanɨmo-ndɨmo.” “Ro se-babɨdɨmbo nɨmboambowambo asu horombo moai sɨhamumbo hoafɨ ra hoafɨyahɨ. ");
INSERT INTO agg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ŋga roana Nindou koamarɨhendɨra makosahɨ ahambo sowana hahühühanahɨ. Ŋga moai nindou seyafundeimbɨ ranai wambo düdufihɨ, ‘Se ra nahanamboyafɨ ahafa?’ yahu. ");
INSERT INTO agg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Hapoana sɨhamumbo ro Ape sowana hafombo hoafɨ ra hoafɨmehapura asu se afɨndɨ hohoanɨmoemo. ");
INSERT INTO agg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ŋga ro sɨhamumbo anɨhondümboanahɨ hoafayahapurɨ: Sɨhamumbo ro hɨnɨŋgɨrɨheapurɨ hehea ahahühɨ ranana sɨhamumbo fehefepurɨmboane. Asu ro hafokoate-mbayahɨ-mbonana, Farɨhepurɨ-randeimbɨ ai ŋgɨrɨ sɨhamumbo sowana koso. Ŋga ro ahahüh-anɨmbo sɨhamumbo sowana koandɨheheanda kodɨmboe. ");
INSERT INTO agg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Rananɨmbo Farɨhendürɨ-randeimbɨ ai kodɨ nindou hɨfɨ ndanɨhü anɨboadei aheimbo türüboade nafuindandüra ai moaruwai hohoanɨmo, mbumundɨ hohoanɨmo, asu Godɨndɨ yɨbobofe hohoanɨmo nɨmɨndɨ ra fɨfɨndɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ai moai wambo anɨhondümbo-rɨhindɨrɨ, ŋga ranɨmboane asu ai hütiyei mbɨsɨ aheimbo nafuindandürɨmbui. ");
INSERT INTO agg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mbumundɨ hohoanɨmo nɨmɨndɨ rananɨmbo ai nafuindandürɨmbui. Ape ai wamboya, ‘mbumund-ani,’ mbusümbui asu ro ahambo sowana gagühanɨ wambo ŋgɨrɨ asükaindɨmo hoeindundɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","God ai aheimbo yɨbobofe hohoanɨmo ra rande nafuindandürɨmbui. Hɨfɨ ndanɨhünda hɨfandɨ-randeimbɨ Satanɨmbo God ai yɨboborirɨ haya hütimb-ani mehu asu aheimbo amboanɨ yɨbobondearümbui. ");
INSERT INTO agg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Hoafɨ afɨndɨ awi ro sɨheheamboanahɨ, ŋga se ŋgɨrɨ haponda muŋgu ndowandümo. ");
INSERT INTO agg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yifiafɨ hoafɨ anɨhondümbo hoafɨyo-randeimbɨ tükündɨfembo-anɨmbo sɨhamumbo hoafɨ hondü ranambo dɨdɨboado-ndeapurɨmboe. Aiana ŋgɨrɨ aipoanɨmbo hohoanɨmondo haya ratüpurɨndo, ŋga wanɨ. Ai hoafɨ hɨmborɨmayo rananɨmbo asu sɨhamumbo weindahɨ hoafɨndɨmboe. Rananɨmbo ai sɨhamumbo raranɨ-moatükunɨ süŋgunambo tüküfemboayo ranahambo hoafɨndɨpurɨmboe. ");
INSERT INTO agg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Asu ai wandɨ-mayo hoafɨ ra ndemɨndɨ hayambo-anɨmbo sɨhamumbo weindahɨ hoafɨndɨmboe. Ranɨnambo ai wandɨ ndürɨmbo adükar-ani mbɨsɨmboe. ");
INSERT INTO agg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Apendɨ moatükunɨ muŋguambo ra wand-ane. Ranɨmboanahɨ sɨhamumbo haponda hoafɨyahapurühɨya: ‘Yifiafɨ ai-anɨmbo wandɨ-mayo hoafɨ ndemɨndɨ haya sɨhamumbo weindahɨ hoafɨndɨpurɨmboe,’ asahapurɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Sisas ai yɨfɨmbo-mayu ranɨmbo hoafɨyuhɨ yahuya, “Akɨdoumbo yaŋgɨr-anɨmbo se ŋgɨrɨ wambo hoeindundɨrɨ asu süŋgunambo akɨdoumbo yaŋgɨr-anɨmbo se wambo asükaindɨmo hoeindündɨrɨmboemo,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ahambo süŋgururü-rundeimbɨ bɨdɨfɨrɨ ai ahamundɨhoarɨ ndaru wataporɨyomondühɨ yahomoya, “Nɨne hoafɨ nɨmɨndɨ ranahandamboyo ai yɨhoefɨmbo yare hoafemuna? Asu ai yare hoafyuhɨya, ‘Akɨdoumbo yaŋgɨr-anɨmbo se ŋgɨrɨ wambo hoeindundɨrɨ asu süŋgunambo akɨdoumbo yaŋgɨrɨ se wambo asükaindɨmo hoeindundɨrɨmboemo,’ mehua? Asu yahuya, ‘Sapo roana Ape sowanambo hahühühɨ wambo,’ mehu.” ");
INSERT INTO agg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Asu ai yaru düduyafundühɨ yahomoya, ‘Akɨdoumbo yaŋgɨr anɨmbo,’ ai hoafɨmayu nda nüŋgufe-nüŋguferamboyoa? Roana moai hoafɨmayu ndanahandambo nɨmɨndɨ ana fɨfɨrɨhundɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sisas ai hoeireandane ahambo düdufimbo yahomo houmbo raraomemo ra fɨfɨrɨmareapurɨ. Ranɨmboyu asu ai hoafɨyuhɨ yahuya, “Awi seana ro hoafɨmayahapurɨ ndanɨmbo nɨmɨndɨ hoafɨ ra fɨfɨrɨfembo yahomomboanemo düdu-düduyomo wakarundɨ? Ro hoafɨyahühɨ sahɨya, ‘Akɨdoumbo yaŋgɨr anɨmbo se ŋgɨrɨ wambo hoeindundɨrɨ asu süŋgunambo akɨdoumbo yaŋgɨr-anɨmbo se wambo asükaindɨmo hoeindundɨrɨmboemo,’ masahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sisas ai yɨfɨyo hefe botɨfembo-mayu ranɨmbo hoafɨyuhɨ yahuya, “Ro sɨhamumbo anɨhondümboanahɨ hoafayahapurɨ: Awi seana afɨndɨ hohoanɨmo-ndɨmondühɨ aranɨndɨmboemo. Ŋga nindou hɨfɨ ndanɨhü burayei aiana hɨhɨfɨ-hɨhɨfɨndeimboyei, ŋga seana ŋgusüfoambe afɨndɨ hohoanɨmondɨmboemo. Sɨhamundɨ ŋgusüfoambe afɨndɨ hohoanɨmo ra muŋgundowohü asu hɨhɨfɨ-hɨhɨfɨ hohoanɨmo sɨhamundɨ mbusümo tükündɨfemboe. ");
INSERT INTO agg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nɨmorehɨ ai nɨmorɨ wakemɨndɨmboayo ra ranɨ si tüküfeihɨ ŋgusüfoambe afɨndɨ hohoanɨmo kürareandɨ. Asu süŋgunambo nɨmorɨ ra wakɨramɨndɨ mburambo ana, ai asübusɨ ranɨmbo ŋgɨrɨ afɨndɨ hohoanɨmondo, ŋga wanɨ. Asu aiana nɨmorɨ wakɨmaramɨndo ranɨmbo hɨhɨfɨ-hɨhɨfɨndɨmboe. ");
INSERT INTO agg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ranɨmboanemo se haponda hohoanɨmo afɨndɨ küru amarɨmo. Ŋga asu ro asükainda sɨhamumbo hoeindɨheapuranɨ se asükaindɨmo ŋgusüfo aboedɨ kündumboemo. Asu ŋgɨrɨ nindou ŋgorü ai sɨhamundɨ ŋgusüfo aboedɨ kife nɨmarɨ hɨhɨfɨ-hɨhɨfɨ ra ndemündü pindeandɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ranɨ-si ra tüküfe sɨmboanɨ ana ŋgɨrɨ se wambo nɨnɨmbo akɨdou düdundafundɨrɨ. Ro sɨhamumbo anɨhondümboanahɨ hoafayahapurɨ: Asu se Apembo raranɨ-moatükunɨ mbɨsenda yahomo houmbo, dɨdɨbafefundɨ ana, asu ai wandɨ ndürɨ süŋgunambo sɨhamumbo ranɨ-moatükunɨ ra dagapurɨmbui. ");
INSERT INTO agg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Horombo ana moai se wandɨ ndürɨnambo dɨdɨbafɨyafu rundɨ raranɨ-moatükunɨ semɨndɨmbo yahomombo ra. Se ahambo dɨdɨbafɨndɨmondanɨ ana, ai sɨhamumbo dagapurɨmbui. Rananɨmbo asu se afɨndɨ hɨhɨfɨ-hɨhɨfɨndɨmondu-mboemo.” ");
INSERT INTO agg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ro sɨhamumbo kafoefe hoafɨyahɨ hoafɨmayahapurɨsɨ, ŋga süŋgunambo ana ŋgɨrɨ sɨhamumbo kafoefe hoafɨnambo hoafɨndahapurɨ, ŋga wanɨ. Ŋga ro sɨhamumbo Apembo hoafɨ hondü hoafɨnda-hapurɨmboyahɨ. ");
INSERT INTO agg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ranɨ-sɨmboan-anɨmbo se wandɨ ndürɨ süŋgunambo Apembo dɨdɨbafɨndafundo. Wandɨhoarɨ ana ŋgɨrɨ Apembo sɨhamumbo farɨhefe-purɨmbohünda dɨdɨbafɨndahɨ, ŋga wanɨ. Se sɨhamundɨhoarɨ ahambo dɨdɨbafɨndafumboemo. ");
INSERT INTO agg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ŋga Ape ahandɨhoar-ani sɨhamumbo ŋgusüfo parareapurɨ. Nɨmboe sapo Ape wambo koamarɨhendɨra makosahɨ ranɨmbo anɨhondümbo-rundühɨ ŋgusüfo pararundɨrɨ ranɨmbo wambo. ");
INSERT INTO agg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Horombo ro Ape-dɨbo nɨmboa mburɨhamboyahɨ, asu ahambo hɨnɨŋgɨrɨhinɨ hehea hɨfɨna makosahɨ. Ŋga asu hapondanɨ ana ro asükai hɨfɨ nda hɨnɨŋgɨfe mburɨmbo Ape sowana hafombo samboanahɨ,” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Asu ahambo süŋgururü-rundeimbɨ ai hoafɨyomondühɨ yahomoya, “Yɨnɨ, hapondanɨ ana se moai kafoefe hoafɨnambo hoafɨyafɨ, ŋga hoafɨ hond-ane hoafayafɨ. ");
INSERT INTO agg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Hapoana sɨhambo ro fɨfɨrɨhunɨnɨmboanefɨ. Yɨhoefɨ ŋgusüfoambe düdufembo hohoanɨmo ran-amboa se fɨfɨrowandɨ asu ŋgɨrɨ sɨhambo düdundahundɨ. Se muŋgu moatükunɨ fɨfɨrɨmarowandɨ. Ranɨmboanefɨ se God-dɨbo nɨmbafɨ hawa makosafɨ ranahambo anɨhondümbo-arɨhundɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ranɨyu asu Sisas ai sɨmborɨ ahamumbo hoafɨyuhɨ yahuya, “Hapoana se akɨdou anɨhondümbo-arundɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ŋga se hɨmborɨyomo! Ranɨ si ra ndearambo tüküfembo yahomboane asu sɨhamumbo bukürü-boadühipuranɨ mamɨ-mamɨ se sɨhamundɨ worɨna ŋgomboemo. Rananɨmbo asu se wambo yaŋgɨrɨ hɨnɨŋgɨndundɨra nɨmboamboyahɨ. Ŋga asu ro yaŋgɨrɨyahɨpoanɨ anɨmboahɨ, ŋga Ape ai ro-dɨbo nüŋgumbui. ");
INSERT INTO agg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Se ro-dɨbo nɨŋgomondanɨ sɨhamundɨ ŋgusüfo afure kümbearowa samboanahɨ hohoanɨmoayahɨ. Ranɨmboyahɨ ro sɨhamumbo ranɨ hoafɨ ra rarɨhe hoafɨmehapurɨ. Hɨfɨ ndanɨhü ana se afɨndɨ hohoanɨmo kündu nɨmandɨmboemo. Roana hɨfɨ ndanɨhündambo hohoanɨmo ranana hɨfɨnambo-rɨheamboanahɨ, ŋga sɨhamundɨ ŋgusüfo rananɨmbo se ŋgɨnɨndɨ kündu nɨmandɨmo,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Sisas ai ranɨ hoafɨ ra hoafɨyu mbura sünambe hɨmboyuhü hoafɨyuhɨ yahuya, “Ape, ranɨ si ra tüküfemboane. Se sɨhafɨ Nɨmorɨ ranahambo ndürɨ adükarümb-ani mbɨsafɨ nafuindafɨndüran-anɨmbo asu sɨmborɨ Nɨmorɨ ai sɨhambo adükar-ani mbüsü nafuindandürɨmbui. ");
INSERT INTO agg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ŋga nindou muŋguambo ahei bogorɨmborɨworɨ kafoarɨworɨ hɨnɨŋgɨ-marɨwor-ani. Asu muŋguambo se ahambo masabadürɨ ranaheimbo ai-anɨmbo aboedɨ yaŋgɨrɨ koadürümbo-koadürümbo nɨŋgombo hohoanɨmo dagadürɨmbui. ");
INSERT INTO agg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Asu nindou ai se mamɨ God hond-anafɨ fɨfɨrɨhinɨnɨ asu Sisas Kraisɨmbo koamarɨ-hawora makusu ranahambo fɨfɨrahorɨ ana, ai koadürümbo-koadürümbo yaŋgɨrɨ nɨboadeimboyei. ");
INSERT INTO agg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ro muŋgu ratüpurɨ se wambo ratüpurɨmbohünda masawandɨrɨ ra muŋgumarɨheandɨ ranɨnambo hɨfɨ ndanɨhü ro se nindou adükar-anafɨ sa nafuimayahɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Ape, horombo ro hɨfɨ nda tüküfekoate-yoambe se-dɨbo nɨmboahambe ro se nahurai aboedɨ hamɨndɨ manɨmboahɨ asu hapondanɨ ro sɨhambo sowahɨ dügühühɨ amboanɨ ndürɨ adükarɨ ndawandɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Se wambo nindou hɨfɨ ndanɨhündambo masawapurɨ ranahamumbo sɨhambo weindahɨ-marɨheapurɨ. Nindou ra sɨhafɨyomo, asu se wambo ndeara sawapurɨmboanafɨ. Asu ai sɨhafɨ hoafɨ yaŋgɨrɨ süŋguarundɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Asu haponda se wambo muŋgu moatükunɨ masawandɨrɨ ra ‘ahandɨ-mayo makosoane’ yahomo fɨfɨrarundɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Muŋgu hoafɨ se wambo masawandɨrɨ ra ro ahamumbo hoafɨmayahapurɨ. Asu ai hɨmborɨyomo houmboanemo ro horombo se-dɨbo nɨmboa hehea makosahɨ ranɨmbo anɨhondümbo fɨfɨrarundɨ. Asu ai se wambo koamarɨhawandɨra makosahɨ ranɨmbo anɨhondümbo-arundɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ro ahamumbo-hündamboanahɨ dɨdɨbafeheanɨnɨ. Ŋga roana nindou hɨfɨ ndanɨhü anɨboadei aheimbo farɨhefe-ndürɨmboyahɨpoanɨ dɨdɨbafeheandɨ, ŋga nindou se wambo masawapurɨ ahamumboanahɨ sɨhafɨ-memondambo wambo dɨdɨbafeheandɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Asu muŋgu moatükunɨ wandɨ-mayo ra sɨhaf-ane. Asu muŋgu moatükunɨ sɨhafɨ-mayo ra wand-ane. Asu ahamundɨ warɨ-süŋgu nindou ai rarɨhi fɨfɨrɨhindɨ ro ndürɨ adükarümb-anahɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Hapoana ro ŋgɨrɨ hɨfɨ ndanɨhü nɨmboahɨ, ŋga sɨhambo sowana asɨhühɨ. Ŋga aiana hɨfɨ ndanɨhü nɨŋgomboemo. Ape, moai ŋgorü se nahurai nüŋgu. Se nindou wambo masawapurɨ ra sɨhafɨ hohoanɨmo süŋgundowandühɨ ahamumbo hɨbadapurɨ. Rananɨmbo se ndürɨ wambo masawandɨrɨ ranɨ-süŋgunambo mbɨnɨŋgomondamboane. Rananɨmbo ai-amboanɨ mamɨ hohoanɨmo süŋgumbɨru-ndamboane sɨhɨrɨ mamɨ hohoanɨmo süŋguarɨhoandɨ nou. ");
INSERT INTO agg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ro ai-babɨdɨmbo nɨmboahambe se wambo ŋgɨnɨndɨ masowandɨrɨ ranɨnambo ahamumbo hɨfandɨmarɨhapura aboedambo anɨŋgomo. Ro ahamumbo ndorɨhe hɨfandɨmarɨhapura asu moai mam-amboanɨ farɨhoei raraorandɨ. Nindou ai farɨhefembo-mayu ranɨ yaŋgɨrɨyu mafarɨhoayu. Rananɨmbo asu Baiborambe horombo hoafɨmayo ra anɨhondü weindahɨ tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Hapoana ro sɨhambo sowana asɨhühɨ. Ro awi hɨfɨ ndanɨhü ndarɨhe hoafayahɨ. Rananɨmbo wandɨ hɨhɨfɨ-hɨhɨfɨ hohoanɨmo ra ahamundɨ fiambe afɨndɨ mbɨmarowa sahehea. ");
INSERT INTO agg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Sɨhafɨ hoafɨ ro ahamumbo masahapura asu nindou hɨfɨ ndanɨhü anɨboadei ranai ahamumbo yɨboaruko-marɨhipurɨ. Ai ramehindɨ ra nɨmboe sapo roana hɨfɨ ndanɨhündambo-yahɨpoanɨ asu ai-amboanɨ hɨfɨ ndanɨhündambo-yomopoanɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ro ahamumbo hɨfɨ ndanɨhündambo sepurɨmɨndɨ raguanambo-fepurɨmbo dɨdɨbafɨ-yaheandühɨ-yahɨpoanɨ, ŋga wanɨ. Se ahamumbo hɨfandɨrapuranɨ asu Satan ai ahamumbo moaruwai hohoanɨmo refekoate-mbiyuwa saheheamboanahɨ dɨdɨbafeheandɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ro-amboanɨ hɨfɨ ndanɨhündambo-yahɨpoanɨ maru ai-amboanɨ hɨfɨ ndanɨhünda-mbo-yomopoanɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Se ahamumbo sɨhafɨ anɨhondü hohoanɨmona sɨhafɨhoarɨ kaboadowapurɨ. Ŋga sɨhafɨ hoafɨ ranana anɨhondü hohoanɨmo nɨmɨndühane. ");
INSERT INTO agg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Horombo se wambo koamarɨhawandɨra kosa, nindou hɨfɨ ndanɨhü burayei ahei mbusümo manɨmboahɨ. Mare yahurai-anɨmbo asu ro-amboanɨ ahamumbo koamarɨheheapura homo nindouyei mbusümo anɨŋgomo. ");
INSERT INTO agg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ro ahamumbo fehefe-purɨmbohünda wandɨ fi sɨhambo maseheandɨ rananɨmbo ai anɨhondü sɨhafɨ ratüpurɨyomo-rundeimbɨ tükümbeafunda sahehea. ");
INSERT INTO agg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ŋga asu ro dɨdɨbafeheandɨ ra ranɨmbo farɨhefepurɨmbo yaŋgɨrɨyopoanɨ, ŋga wanɨ. Ŋga ro dɨdɨbafeheandɨ ra nindou ai süŋgunɨ ahamundɨ hoafɨ hɨmborɨyei hehi, asu ai wandɨ hoafɨ anɨhondümbo-ndɨhimboyei ranaheimbo kameih-anahɨ dɨdɨbafeheandɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ape se ro-dɨbo anɨmbafɨ asu ro se-dɨbo anɨmboahɨ, ŋga ai-amboanɨ yahurai-anɨmbo mamɨ hohoanɨmo süŋgundɨhi mbɨnɨboadei sahehea hohoanɨmoayahɨ. Ranɨmboanahɨ asu ai sɨhɨrɨ-babɨdɨmbo mbɨnɨboadei-amboane. Rananɨmbo asu nindou hɨfɨ ndanɨhü anɨboadei ranai se wambo koamarɨhawandɨra makosahɨ ranɨmbo anɨhondümbo-ndɨhimboyei. ");
INSERT INTO agg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ndürɨ adükarɨ wambo masawandɨrɨ yahurai ahamumbo sahapurɨmboanahɨ. Asu sɨhɨrɨ rawehoandɨ nou ai-amboanɨ mamɨ aboedɨ ranɨ hohoanɨmo yaŋgɨrɨ sowandümo mbɨnɨŋgomonda asahɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ro ai-babɨdɨmbo anɨmboahɨ, ŋga asu se ro-dɨbo anɨmbafɨ. Ranɨmboanahɨ asu ai-amboanɨ aboedɨ mamɨ ranɨ hohoanɨmo yaŋgɨrɨ hohoanɨmombemo asahɨ. Rananɨmbo nindou hɨfɨ ndanɨhündambo ai se wambo koamarɨhawandɨra makosahɨ ranɨmbo fɨfɨrɨmbɨrɨhinda asahɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ape, se wambo nindou masawapurɨ ra ro anɨmboahɨ ranɨhü mbɨnɨŋgomonda samboanahɨ hohoanɨmoayahɨ. Ai wandɨ-mayo hɨmboamupuimbo-randeimbɨ hoeimbɨrundɨ samboanahɨ. Horombo hɨfɨ nda tüküfekoate-yoambe se wambo ŋgusüfo parowandɨrühɨ hɨmboamupuimbo-randeimbɨ ra masawandɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ape, se mamɨ yaŋgɨr-anafɨ mbumundayafɨ. Nindou hɨfɨ ndanɨhündambo ana moai fɨfɨrɨhinɨnɨ, ŋga roana sɨhambo fɨfɨrɨhea-nɨnɨmboanahɨ. Ŋga nindou ndan-anemo se wambo koamarɨhawandɨra makosahɨ ranɨmbo fɨfɨrumboemo. ");
INSERT INTO agg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ro ahamumbo sɨhambo nafuimayahapurɨ. Asükainda ro nafuinda-hapurɨmboyahɨ se wambo ŋgusüfo pamarowandɨ nou ai-amboanɨ ŋgusüfo peferü-mbeyomondamboane. Asu ro-amboanɨ ai-babɨdɨmbo nɨmboamboyahɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ranɨyu asu Sisas ai dɨdɨbafɨyu kɨkamündü haya, ahambo süŋgururü-rundeimbɨ babɨdɨmbo Kidron hoe apoarɨ hanɨmo bamarɨhoemo. Orif nɨmɨ nümbürɨ mamɨ ranai gogoanɨnɨ yaŋgoroane, ai ranafɨ hanɨmo barɨhoemo houmbo nümbürambe nafɨ mahafomo. ");
INSERT INTO agg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Sudas, nindou sapo Sisasɨmbo hürütümbɨ-yomondɨ warɨhüfimbo-mayu ranai nümbürɨ ra fɨfɨreandɨ. Sisas ai ahambo süŋgururü-rundeimbɨ babɨdɨmbo nümbürɨ ranɨ fikɨmɨ homo gugurɨyafu nɨmarɨmo marundɨ, ranɨmboyu Sudas ai ranahambo fɨfɨrɨmareandɨ. ");
INSERT INTO agg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ranɨmboyu Sudas ai ami bɨdɨfɨrɨyomo asu prisman Godɨmbo sɨhou-rundeimbɨ bogorɨ ai koamarɨhoupurɨyomo, Farisi bɨdɨfɨrɨyomo sepurümündü haya, nümbürɨ yaŋgoro nafɨ mahafomo. Ai ranafɨ hɨfomondühüyomo, ram haiyo, asu hai hondü yimundu sowandümo, asu yifiarɨmbo napoyo ra raraoru sowandümo houmbo mahɨfomo. ");
INSERT INTO agg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Asu Sisas ai ahambo nɨnɨ-moatükunɨyo tüküfemboayo ra fɨfɨreandɨ. Ranɨmboyu ai ahamumbo sowahɨ akɨmɨ hüfu hoafɨyupurühɨ yahuya, “Se ra daboe kokoarura?” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Asu ai sɨmborɨ yahomoya, “Ro ana Nasaretɨhündɨ Sisasɨmbo kokomboanefɨ,” mehomondamboyu. Asu Sisas ai yahuya, “Ro Sisas-anahɨ ndasɨ,” mehuamboemo. Asu Sudas Sisasɨmbo hürütümbɨ-yomondɨ warɨhüfimbo-mayu ranai ai-babɨdɨmbo manüŋgu. ");
INSERT INTO agg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ranɨyu asu Sisas ai “Ro Sisas-anahɨ ndasɨ,” mehupuramboyo nindou ranai daboadanambo sühɨyafu-ndühündamboemo hɨfɨnɨ pütapɨmemo. ");
INSERT INTO agg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ranɨmboyu asu Sisas ai ahamumbo asükaiyu düdufipurühɨ yahupurɨya, “Se nindou dabo kokomboemoa?” mehupuramboemo. Asu ai hoafɨyomondühɨ yahomoya, “Sisas Nasaretɨhündɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Asu Sisas ai sɨmborɨ yare hoafɨyuhɨ yahuya, “Ro sɨhamumbo hoafɨyahapureimb-ane, ro Sisas-anahɨ. Se wambo kokondundɨrühɨ ana, asu wandɨ süŋgururü-rundeimbɨ hɨnɨŋgɨndupuranɨ mbɨhomondamboane.” ");
INSERT INTO agg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ai yare hoafɨmayu ra sapo ai horombo hoafɨmayu ra anɨhondü tükümbɨfeyoa yahuhayamboyu yare hoafɨmayupurɨ. Sapo ai ndare hoafɨyuhɨ, “Nindou wambo se masawapurɨ ra ro moai mam-amboanɨ hɨnɨŋgɨrɨhinɨ,” mehu. Ranɨmboyu asu ahamumbo farɨhefepurɨmbo hohoanɨmoyuhü “Wandɨ süŋgururü-rundeimbɨ hɨnɨŋgɨndüpuranɨ mbɨhomondamboane,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita ai pisao yihɨmɨndɨ semündü hayamboyu pisao ra Godɨmbo sɨhou-rundeimbɨ-yomondɨ adükarɨ bogorɨndɨ ratüpurɨyu-randeimbɨndɨ warɨhondü hɨmbohoearɨ mafoafoareandɨ. Nindou ratüpurɨyu-randeimbɨ ahandɨ ndürɨ ra Markus. ");
INSERT INTO agg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ranɨyu asu Sisas ai Saimon Pitambo hoafɨyundühɨ yahuya, “Pisao ra asükaiyafɨ koadürambe sando! Ro Ape ai wambo asübusɨ saindɨrɨmboayu ra ŋgɨrɨ hɨnɨŋgɨndɨheandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ranɨmboemo asu amiyomo, ahamundɨ bogorɨyu, asu Suda-yomondɨ prismanɨyomo ranai Sisasɨmbo mburündümo mburu hüputüpu-marɨhawurɨ. ");
INSERT INTO agg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ranɨyomo asu ai Anas sowanambo boatei sowaründümo mahomo. Anas ai Kaiafasɨndɨ yamoŋgoamɨndɨyu haya ranɨ hɨmbanɨfihɨ Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨmbofi mamaru. ");
INSERT INTO agg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafas ranɨyu nindou Sudahündɨmbo horombo yare hoafɨyupurühɨya, “Nindou mamɨ ai hɨfɨ ndanɨhü burayei aheimbo farɨhefembohünda yɨfɨmbiyu-wamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita ai Sisasɨmbo süŋgurürɨ-randeimbɨ ŋgorü-dɨbo Sisasɨmbo süŋgumarɨnɨrɨ hafanɨ. Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨ ai süŋgurürɨ-randeimbɨ ŋgorü-mayu ahambo fɨfɨrirɨ. Ranɨyu asu ai Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨndɨ ginɨrambe Sisas dɨbo kamefoeneandɨ. ");
INSERT INTO agg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Asu Saimon Pita ai weindanɨ yipurɨkɨmɨ nüŋgu. Ranɨmboyu asu Sisasɨmbo süŋgurürɨ-randeimbɨ ŋgorü Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨ ai fɨfɨrireimbɨ-mayu ranai hu, nɨmorehɨ yipurɨ hɨfanda-randeimbɨ-mayo ahambo hoafɨyundo haya Saimon Pitambo ginɨrambe serümündü kamefuendɨ. ");
INSERT INTO agg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nɨmorehɨ yipurɨ hɨfanda-randeimbɨ ai Saimon Pitambo yahoya, “Awi se-amboanɨ nindou ndanahambo süŋgurɨrɨ-randeimb-anafɨ?” mehoamboyu. Asu Pita ai yahuya, “Roana wanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nindou ratüpurɨyomo-rundeimbɨyomo asu prismanɨyomo ai hai mamɨ püpiru hɨnɨŋgɨru houmbo ŋgɨsɨharɨmboemondühɨ wakɨyomo nɨŋgomombo haihehümemo. Asu Pita amboanɨ ai-babɨdɨmbo nüŋgumbo haihehü-mayu. ");
INSERT INTO agg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ranɨ-sɨmboanɨ Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨ ai Sisasɨmbo süŋgururü-rundeimbɨ asu hoafɨ nindou yamundearü marandɨ ranɨmbo düdumefindo. ");
INSERT INTO agg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ranɨyu asu Sisas ai ahambo sɨmborɨ yahuya, “Ro nɨmbɨ-nɨmbɨsi Godɨndɨ worambe, Suda ai muŋgu fandɨhi nɨmarei rɨhündambe ranɨhüyahɨ ro aheimbo hoafɨ ra yamundɨ-marɨheandürɨ. Ŋga ro moai hoafɨ mam-amboanɨ dɨbo hoafɨyahɨ. ");
INSERT INTO agg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Se nɨmboe wambo düduefoandɨra? Nindou hoafɨ hɨmborɨmayei aheimbo-anɨmbo düduyafoandürɨsɨ. Ai ro hoafɨyaheimbɨ ra fɨfɨrɨhimboaneisɨ.” ");
INSERT INTO agg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sisas ai ra mehuamboyu, asu prisman mamɨ manüŋgu ranai Sisasɨmbo pakarümündü pürirühɨ hoafɨyuhɨ yahuya, “Ŋgɨrɨ se Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨmbo rando hoafɨndafɨ,” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Asu Sisas ai ahambo sɨmborɨ yahuya, “Ro moaruwai hoafɨndahanɨ anɨmbo se hoafɨ ra weindahɨ ndowandɨfɨ wataporɨmbo-ndandɨ. Ŋga asu ro aboedɨ hoafayahɨ ana, se nɨmboe wambo harɨmayafa?” mehu. ");
INSERT INTO agg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Asu wofɨna hüputüpumaruründümo ra fufurɨhefikoate mbanɨŋgo nou, Anas ai ahambo Godɨmbo sɨhai-randeimbɨ adükarɨ bogorɨ Kaiafas sowana koamarɨherü. ");
INSERT INTO agg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita ai haikɨmɨ haihü manüŋguamboemo. Nindou Pita-dɨbo manɨŋgomo ranai ahambo hoafɨyomondowohü yahomoya, “Awi se-amboanɨ ahambo süŋgurɨrɨ-randeimbɨmbayafɨ?” mehomondamboyu. Asu ai dɨdɨmofihɨ yahuya, “Roana wanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nindou mamɨ Godɨmbo sɨhai-randeimbɨndɨ ratüpurɨyu-randeimbɨyu haya, asu Pita hɨmbo hoearɨ mafoafoarirɨ ahandɨ mamɨsɨrɨ ranai hoafɨyuhɨ yahuya, “Awi seana Sisas-dɨbo nümbürambe mamarɨfa hoeimarɨheanɨnɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Asu Pita ai asükaiyu “Roana wanɨ,” yahuambe asu kakaro ai hoafɨmayu. ");
INSERT INTO agg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ranɨyomo asu ai hapoadümbo siyoambe Kaiafasɨndɨ worɨ hɨnɨŋgɨru houmbo, Romɨ-yafe gafman bogorɨndɨ worɨnambo Sisasɨmbo sowaründümo mahomo. Asu Suda ai moai gafman bogorɨndɨ worambe kefou hɨfomo ai adükarɨ si Pasofa ra sesɨmbo yahomombo wambo. Suda nindou ai ndɨfo-yafe worambe kefoefembo ra ahɨnümb-ane. Ŋga asu ai karefoahundɨ ana, asu ‘ŋgɨrɨ Pasofa sesɨ ra dagüdifɨ,’ yahomo houmboemo. ");
INSERT INTO agg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ranɨyomo asu ai weindanɨ nɨŋgomondane Pairat ai ahamumbo sowahɨ tüküfi hu hoafɨyuhɨ yahuya, “Se nɨmboe nindou ndanahambo papɨ-hoafɨyumbo yahomo houmboemoa?” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Asu sɨmborɨ hoafɨyomondühɨ yahomoya, “Asu nindou ndanai moaruwai hohoanɨmo süŋgufekoate-mbei-mbonana, ŋgɨrɨ ndarɨhu sɨhambo sowana sahurümɨndefɨ sɨnefɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Asu Pairat ai ahamumbo hoafɨyupurühɨ yahuya, “Se sɨhamundɨhoarɨ sowaründümo houmbo sɨhamundɨ ahɨnümbɨ süŋgu papɨ-hoafɨndürɨ,” mehuamboemo. Asu Suda ai hoafɨyomondowohü yahomoya, “Yɨhoefɨ papɨ-hoafambe ŋgɨrɨ nindou ŋgorümbo hɨfokoandɨhundɨ,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Horombo Sisas ai yahurai randɨhe yɨfɨndamboyahɨ mehu. Asu ranɨ hoafɨ ra anɨhondü tüküfembohünda Suda ai ra-süŋgumarundɨ. ");
INSERT INTO agg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ranɨmboyu asu Pairat ai gafman bogorɨndɨ worambe asükai kefue hüfu Sisasɨmbo mborai mehundowa mahüfuwa düdufinduhü yahuya, “Se Suda-yomondɨ adükarɨ bogorɨyafɨ?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Asu Sisas ai hoafɨyunduhü yahuya, “Awi sɨhafɨhoarɨ hohoanɨmoyafɨ hawamboyafɨ se yaro hoafayafɨ, asu nindou amurɨ ai wambo yaru hoafɨmemondamboyafɨ yaro hoafayafɨ?” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Asu Pairat ai sɨmborɨ hoafɨyuhɨ yahuya, “Roana Sudayahɨpoanɨ. Ŋga sɨhafɨ nendɨyomo Godɨmbo sɨhou-rundeimbɨ bogorɨ-babɨdɨmbo wambo sowana sowandümonɨnɨ masɨnɨmo. Asu se nɨnɨ nünüŋgurowamboyafa?” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Asu Sisas ai sɨmborɨ yahuya, “Ro ŋgɨnɨndɨ hɨfandarɨhandɨ ranana hɨfɨ ndanɨhündambo-yopoanɨ. Ranɨ hohoanɨmo wandɨ ra hɨfɨ ndanɨhündambombe-mbonana, asu wandɨ ratüpurɨyomo-rundeimbɨ ranai yifiarɨndɨmonda asu ŋgɨrɨ nindou ranai wambo Suda-yomondɨ warɨhündundɨrɨ. Ŋga wandɨ ŋgɨnɨndɨ hɨfandɨmbo ranana hɨfɨ ndanɨhündambo-yopoanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ranɨyu asu Pairat ai yahuya, “Refe ana, asu se adükarɨ bogorɨwamboyafɨ!” mehuamboyu. Sisas ai sɨmborɨ hoafɨyundühɨ yahuya, “Sɨhafɨhoarɨ anɨhondümboanafɨ yaro hoafɨyafühɨ, ‘Se adükarɨ bogor-anafɨ,’ asafɨ. Roana anɨhondü moatükunɨ ro hoeimarɨheandɨ ranɨmbo anɨhondümbo hoafɨmbohünda makosahɨ. Ranɨmboyahɨ Ape wambo koamarɨhendɨra makosaha me ai wambo wakɨmaramɨndɨ-ndɨrɨ. Nindou ai hohoanɨmo hondü ranɨ-süŋgurɨhindeimbɨ ana ai wandɨ yafambehündɨ hoafɨ hɨmborɨyei rɨhündühanei,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Asu Pairat ai ahambo hoafɨyundühɨ yahuya, “Anɨhondü hohoanɨmo ra nɨnea?” mehu. Ai yare hoafɨyu haya, asükai Suda sowana kusɨfoai haya mahu. Ai hoafɨyuhɨ yahuya, “Nindou ndanahambo papɨ-hoafɨmbohündambo moai nɨnɨ-moatükunɨ moaruwai nɨmaroanɨ hoeirɨheandɨ. ");
INSERT INTO agg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ŋga sɨhamundɨ boagɨrɨ hohoanɨmo ranɨ-süŋgunambo adükarɨ si Pasofa ranɨhü ro nindou mamɨ sɨhamundɨ hohoanɨmo süŋgu ahambo karabusambeahɨndɨ aboedambo koarɨhehinɨ arɨhandɨ. Se hohoanɨmoyomondanɨ ro ‘Sudayei adükarɨ bogorɨ’ nda aboedambo koandɨhehinɨmboyo?” mehuamboemo. ");
INSERT INTO agg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ranɨyomo asu ai sɨmborɨ puküna hoafɨyomondühɨ yahomoya, “Aiana wanɨ, ŋga se Barabasɨmbo-anɨmbo hɨnɨŋgɨndɨworɨ!” mehomo. Barabas ra gafman-babɨdɨmbo yifiarɨyu nindou hɨfokoare randeimb-ani. ");
INSERT INTO agg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ranɨmboyu asu Pairat ai hoafɨmayua ami ai Sisasɨmbo sowaründümo houmbo ndüfurɨ-ndüfurɨmarüwurɨ. ");
INSERT INTO agg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Asu ami ai adükarɨ bogorɨndɨ at tɨkai wofɨ tɨhoarɨ tɨhoarümbɨnambo nafɨru mburu, Sisasɨndɨ mbɨroambe kɨkɨmafoarundɨ. Ranɨyomo asu adükarɨ bogorɨndɨ hamburɨ hoearɨ güdu hɨnɨŋgɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Asu ai ahambo tüküyafu sɨsɨndɨ hoafɨyomondowohü yahomoya, “Suda-yomondɨ adükarɨ bogorɨ nindou, karɨhasɨ,” yahomondühɨyomo asu ahambo harɨmemondo. ");
INSERT INTO agg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pairat ai asükaiyu weindanɨ tüküfi hu hoafɨyundürühɨ yahuya, “Hɨmborɨyei! Ro ahambo weindanɨ sɨheimbo sowana sahümɨndɨ tükeheandɨ. Rananɨmbo se fɨfɨrɨndɨhindɨ. Ro moai papɨ-hoafɨmbo nɨnɨ-moatükunɨ fɨfɨrɨheandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ranɨyu asu Sisas ai weindanɨ tükümefiyu. Asu ahandɨ mbɨroambe at tɨhoarɨ tɨhoarümbɨ wofɨnambo nafɨmarundɨ, asu hamburɨ hoearɨ ra güdaroane ranɨ kameihɨ tükümefiyu. Ranɨyu Pairat ai hoafɨyuhɨ yahuya, “Nindou ranani nda,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ranɨyomo Godɨmbo sɨhou-rundeimbɨyomo asu prismanɨyomo ai hoeirüwurɨ houmbo puküna hoafɨyomondühɨ yahomoya, “Nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkoründümo parüwurɨ! Nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkoründümo parüwurɨ!” raramarürɨ. Pairat ai yahuya, “Sɨhamundɨhoarɨ anɨmbo nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkoründümo parüwurɨ. Ŋga ahandɨ hohoanɨmoambe ro moai nɨnɨ-moatükunɨ ŋgorü-süŋgufe hohoanɨmo nɨmaroa hoeirɨheandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Asu Suda ai sɨmborɨ hoafɨyomondühɨ yahomoya, “Roana yɨhoefɨ ahɨnümbɨ hohoanɨmo süŋgu yare hoafɨyohü yahoya, ‘Nindou ndanana ai yɨfɨmbiyu-wamboane,’ meho. Nɨmboe sapo ai yahuya, ‘Ro Godɨndɨ nɨmor-anahɨ,’ mehu,” mehomo. ");
INSERT INTO agg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ranɨmboyu asu Pairat ai ranɨ hoafɨ ra hɨmborɨyu haya yɨhɨmbo afɨndɨ yɨhɨmbomayu. ");
INSERT INTO agg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ranɨyu asu asükai gafmanɨ-yomondɨ worɨ ranambe kefuai hüfu Sisasɨmbo yahuya, “Se nɨnɨ-nɨpoedɨyafa?” mehundo. Ŋga Sisas ai moai sɨmborɨ ahambo hoafɨyundo. ");
INSERT INTO agg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ranɨyu asu Pairat ai yahundoya, “Nɨmboe se wambo hoafɨkoate-ayafɨndɨra? Roana sɨhambo moanɨ koehefenɨnɨyo asu nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkoemɨndɨnɨnɨ pefenɨnɨyo ra refembo ŋgɨnɨndɨ hɨfandɨhamboanahɨ. Awi asu ranɨ hohoanɨmo ra fɨfɨrɨfekoate-wamboyafɨ?” mehundowamboyu. ");
INSERT INTO agg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Asu Sisas ai sɨmborɨ ahambo yahuya, “God nɨmoamo amaru ranai sɨhambo ŋgɨnɨndɨ hohoanɨmo ra segonɨnɨkoate-mbei-mbonana, asu se ŋgɨnɨndɨ hohoanɨmoyowohü wambo hɨfɨnambofendɨrɨ hohoanɨmo ra ŋgɨrɨ hohoanɨmoyafɨ. Ranɨmboane asu nindou ai wambo sɨhafɨ warɨhümareandɨrɨ ranahandɨ moaruwai hohoanɨmo ana sɨhafɨ moaruwai hohoanɨmo ranahambo ŋgasünde haya adükarɨ hamɨnd-ane,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ranɨyu asu Pairat ai ranɨ hoafɨ ra hɨmborɨyu haya, Sisasɨmbo koandɨhehina mbühu yahuhaya nafɨ kokora wakɨmareandɨ. Ŋga asu Suda ai puküna hoafɨyeihɨ seiya, “Asu se ahambo koarɨhaworanɨ ahu ana, se ŋgɨrɨ Romɨ-yafe adükarɨ bogorɨ Sisarɨndɨ ŋgunindɨndafɨ. Nindou ai hoafɨyuhɨ ‘Roana adükarɨ bogoranahɨ,’ ehu ana, asu nindou ranai Sisarɨmbo yɨboaruko-rirühani,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pairat ai ranɨ hoafɨ ra hɨmborɨyu haya, Sisasɨmbo weindanɨ serümündü tükümefiyu. Ranɨyu ai hu, papɨ-hoafɨ hɨmborɨyo rambo nɨmarɨfondɨ mamɨ manɨŋgo ‘nɨmoei yibadɨ’ sei-arɨhündɨ ranɨwamɨ mamaru. (Hiburu-yafe hoafɨnambo nɨmoei yibadɨ ra Gabata-ane.) ");
INSERT INTO agg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ranɨ si ranana Suda-yafe adükarɨ si Pasofa ranɨmbo sesɨ napo fikɨmɨ-fikɨmɨfembo si-ane. Asu ndeara hüfɨnɨmboyowane, Pairat ai Sudambo hoafɨyundürühɨ yahuya, “Sɨhei adükarɨ bogorɨ ranahambo hoeirɨhorɨ,” mehuamboyei. ");
INSERT INTO agg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Asu ai puküna hoafɨyeihɨ seiya, “Koarɨhaworɨ! Koarɨhaworɨ! Nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkorɨndɨfɨ parɨworɨ,” maseiamboyu. Pairat ai Sudambo düdureandürühɨ yahuya, “Sɨhei adükarɨ bogorɨ ranahambo ro nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkuimɨndɨ pefimbo yɨnɨ seiai?” mehuamboyo. Asu Godɨmbo sɨhou-rundeimbɨ adükarɨ bogorɨmemo ranai sɨmborɨ hoafɨyomondowohü yahomoya, “Yɨhoefɨ adükarɨ bogorɨ ana moai ŋgorü nüŋgu, ŋga Sisar yaŋgɨr-ani anüŋgu,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ranɨyu asu Pairat ai Sisasɨmbo ahamundɨ warambe hɨnɨŋgɨmarirɨ, nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkuimɨndɨ pefimbohünda. Ranɨyomo asu ami ai Sisasɨmbo masowaründümo. ");
INSERT INTO agg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ranɨyu asu Sisas ai ahandɨhoarɨ nɨmɨ keimbɨ karɨhendeimbɨ ra semündü haya ŋgoafɨ ra hɨnɨŋgɨrɨhi hehimbo, wafu mamɨ mbɨrɨhapɨrɨ nahurai wafu sei-arɨhündɨ ranɨnambo mahei. (Hiburu-yafe hoafana ‘Gorgota-ane’.) ");
INSERT INTO agg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ranühɨ ai Sisasɨmbo nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkoründümo pamarüwurɨ. Asu nindou ŋgorü yimbu amboanɨ Sisas-dɨbo tɨkorɨpündɨmo pamarupɨrɨ ra ŋgorü ai gogoanɨnɨyu asu ŋgorü ai gogoanɨnɨyu, ŋga asu Sisas ai mbusümoyu. ");
INSERT INTO agg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pairat ai hoafɨ mamɨ nɨmɨ keimbɨ karɨhendeimbɨ-mayo ranɨfihɨ sürü papɨra pareandühɨ yahuya: ‘SISAS NASARETƗHÜNDƗ SUDAYAFE ADÜKARƗ BOGORƗ’ yahu pamareandɨ. ");
INSERT INTO agg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sisasɨmbo tɨkoründümo pamarüwurɨ ra ŋgoafɨ adükarɨ ranɨ fikɨmɨ safɨyo. Ranɨmboyo hoafɨ Pairat ai hoafɨmayua pamarundɨ ra nindou afɨndɨ ranai hei hoeimarɨhindɨ. Pairat ai hoafɨ sürü papɨra pamareandɨ ra, Hiburu-yafe hoafɨ, Romɨ-yafe hoafɨ, asu Grikɨ-yafe hoafɨ ranɨnamboyu sürü papɨmarandɨ. ");
INSERT INTO agg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ranɨmboemo Godɨmbo sɨhou-rundeimbɨ bogorɨ ai Pairatɨmbo hoafɨyomondowohü yahomoya, “Se nɨmboe ‘Suda-yafe adükarɨ bogorɨ’ safɨ sürü papɨra pamarɨwanda? Ŋga ndaro papɨra parowandai: ‘Nindou ranai hoafɨyuhɨya, “Ro Suda-yomondɨ adükarɨ bogoranahɨ,” mehu,’ safɨ parowandai,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Asu Pairat ai yahuya, “Hoafɨ ro sürü papɨmarɨhandɨ ra ŋgɨrɨ asükainda ŋgorü-süŋgundɨhe pandɨheandɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ami ai Sisasɨmbo nɨmɨ keimbɨ karɨhendeimbɨfihɨ tɨkoründümo parüwurɨ houmboemo, asu ahandɨ-mayo hoearɨ napo ra muŋgu fufuründümo mburümbo yimbu-yimbumboru yimbumarundɨ. Ranɨyomo ami ai napo ra mamamɨru fufumaründɨmo. Asu ai ahandɨ hoandarɨ hoearɨ kameihɨ masowandümo. Ŋga asu hoandarɨ hoearɨ ra moai ŋgorü hoearɨ ranɨfihɨ parɨhi kakɨyei, ŋga mamɨ ranɨ yaŋgɨrɨyo kakɨmayei. ");
INSERT INTO agg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ranɨmboemo asu ami ai ahamundɨhoarɨ yahomoya, “Hoearɨ ndanana sɨhɨrɨ kɨkɨfepoanɨ, ŋga yowanɨ. Ŋga hoearɨ ranɨmbo-hünda sɨhɨrɨ satu piraindefomboane, nindou ŋgorü ai semɨndɨmbohünda.” Nindou ai yaru hoafɨmemo ra sapo horombo Baiborambe yare hoafɨmayo süŋgu. Ai yare hoafɨyowohü yahoya, “Wandɨ hoearɨ napo yimbumaründümo. Asu hoearɨ wandɨ ranahambo nindou mamai semɨndɨmbohündambo satu piraimemo,” meho. Ranɨyo asu ami amboanɨ ranɨ-süŋgumarunda hoafɨmayo ra anɨhondü tükümefeyo. ");
INSERT INTO agg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Sisasɨndɨ hondɨyo, asu ahandɨ akɨdɨyo, asu Maria Koropasɨndɨ wuhɨyo, asu Maria ŋgorü Makdarahündɨyo ai Sisasɨndɨ nɨmɨ keimbɨ karɨhendeimbɨ-mayo ranɨ fikɨmɨ manɨmboei. ");
INSERT INTO agg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ahandɨ hond-aiyo asu süŋgururü-randeimbɨ Sisas ai ahambo ŋgusüfo parirɨ-randeimbɨ-dɨbo manɨmbafea hoeimareapɨrɨ. Ranɨyu ai hondambo yahuya, “Nɨmorehɨ, ndanana sɨhafɨ nɨmor-ani,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Asu ahambo süŋgurürɨ-randeimbɨ-mayu ahambo yahuya, “Ndanana sɨhafɨ me-ane,” mehuamboyu. Asu ranɨ-sɨmboanɨ ai Mariambo ahandɨ worɨnambo semündü hu ai-dɨbo manɨmbafe. ");
INSERT INTO agg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ranɨyo süŋgunambo Sisas ai ahandɨ ratüpurɨ hɨfɨ ndanɨhü ra muŋguyohane yahu fɨfɨrɨmareandɨ. Ranɨyo asu Godɨndɨ hoafɨ Baiborambe anɨhondü tükümbɨfeyoa yahuhaya ndare hoafɨyuhɨ yahuya, “Amɨndanɨŋoarandɨrɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hɨpɨrɨ mamɨ yaŋgorɨ hayamboyo ranambe hühütimbü hoe finiga ranai mapuiaro. Ranɨyo asu ai sɨrɨwara-ambeahɨndɨ hoe kɨkɨhamɨndeimbɨ semündü hayambo, finiga ambe foareanda tüküfe haya manɨŋgo. Asu ai hisop nɨmɨharɨfihɨ pare hɨmondamündɨ mbura, Sisasɨndɨ yafambehü tümareandɨ. ");
INSERT INTO agg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Sisas ai finiga ra sümündü mbura hoafɨyuhɨ yahuya, “Muŋguayo,” yahu mbura mbɨro hɨfɨnɨ piyuhü yɨfɨmayu. ");
INSERT INTO agg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ranɨ si ra Suda-yafe moanɨ ŋgoafɨmbo nɨmarɨ si ranahambo muŋgu moatükunɨ dɨboadɨfembo siyo. Si ra moanɨ adükarɨ hamɨndɨyo ranɨyo asu Suda ai ranɨ sihɨ nindou nɨmɨ keimbɨ karɨhendeimbɨfihɨ paiarɨmbo ra yowanɨ mehomo. Ranɨmboemo Pairatɨmbo nindou ranahamumbo tɨŋarɨ kehefepura nɨmai yɨfɨndɨmonda foepumɨndɨ raguanambo-fepurɨmbo hoafɨmemondo. ");
INSERT INTO agg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ranɨmboemo asu ami ai nindou yimbu Sisas-dɨbo tɨkorüpündɨmo pamarupɨrɨ ahafanɨmbo tɨŋarɨ ra kamarɨhaupɨrɨ. ");
INSERT INTO agg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ŋga asu ai Sisasɨmbo sowahɨ tüküyafu hoeirüwurane, ai muŋguna yɨfɨmayuamboemo asu ahandɨ tɨŋarɨ ra moai karɨhaundɨ. ");
INSERT INTO agg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ŋga ami mamɨ ai yaŋgɨrɨ yifiarɨnambo ŋgɨrɨsafɨnɨ wafusɨmarümündu. Ranɨyo asu nɨmai horɨ ranai hoe dɨbore haya ahandɨ fiambeahɨndɨ pɨmayo. ");
INSERT INTO agg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nindou hoeimareandɨ ranai ranahambo hoafɨyuweimb-ane. Asu ai hoafɨmayu ra anɨhondü hoaf-ane, asu ahandɨhoarɨ amboanɨ hoafɨ hond-ane yahu fɨfɨreandɨ. Ranɨmbo-hündamboane asu se-amboanɨ ranahambo anɨhondümbo-ndɨhindɨ. ");
INSERT INTO agg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ranɨ-moatükunɨ tükümefeyowamboyo, Baiborambe hoafɨ pamaiaro süŋgu yare hoafɨyowohü yahoya, ‘Ŋgɨrɨ ahandɨ hamɨndɨ ŋgorü kandundɨ,’ meho. ");
INSERT INTO agg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ŋga asu hoafɨ ŋgorü ranambe meŋgoro ra yahoya, “Asu ai-anɨmbo nindou wafusɨmarümündu ahambo hɨmboapondeimboyei,” meho. ");
INSERT INTO agg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Süŋgunambo Sosep Arimateahündɨ ai Pairatɨmbo Sisasɨndɨ yɨfɨnɨmoko ra semündümbo yahuhaya hoafɨmayundo. Sosep ai Sisasɨmbo süŋgurürɨ-randeimbɨyu, ŋga ai Sudambo yɨhɨmborapurühɨyu asu ahandɨ anɨhondümbofe hohoanɨmo ra moai weindahɨreandɨ. Pairat ai ahambo ndowarɨndɨfɨsɨ mehuamboyu, asu Sosep ai Sisasɨmbo serümündü mahu. ");
INSERT INTO agg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, horombo Sisas sowahɨ nɨmbokoanɨ mahafu, ranai amboanɨ Sosep-dɨbo mahafanɨ. Asu ai fɨsɨŋɨrümbɨ moatükunɨ sanda nɨmɨ horɨ yimbu mamamberu fanduyamundu houmbo nafɨ-rundeimbɨ ra semündü haya mahu. Nɨmɨ horɨ ranahandɨ nɨmborɨ ra 30 kirogramɨyo. ");
INSERT INTO agg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ranɨyafanɨ ai Sisasɨndɨ yɨfɨnɨmoko ra sowarɨndɨfanɨ mburɨna, Suda ai yɨfɨnɨmoko raru arundɨ süŋgu fɨsɨŋarümbɨ moatükunɨ sanda parɨne mburɨna hoearɨnambo hɨmondɨmarɨhenerɨ. ");
INSERT INTO agg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sisasɨmbo nɨmɨfihɨ tɨkoründümo parüwurühɨ nümbürɨ mamɨ ranai yaŋgoroane, asu nümbürɨ ranambe hoŋgu sɨmboramborɨ yɨfɨ sɨhefekoate manɨŋgo. ");
INSERT INTO agg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Suda ai moanɨ ŋgoafɨmbo nɨmarɨmbo si ranahambo sesɨ napo dɨboado-marɨhindamboyafanɨ. Asu hoŋgu ra akɨmɨ nɨŋgo hayamboyowane, Sisasɨndɨ yɨfɨnɨmoko ra sowandɨfanɨ hafanɨ masɨheneandɨ. ");
INSERT INTO agg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande hapoadümbo siambe nɨmbɨ hoaŋgɨrɨ kiarowane, Maria Makdarahündɨ ai hoŋgu ranɨ sowana mahɨfo. Ai hɨfo hoŋgu ranɨ fikɨmɨ tüküfe hɨmboyowane, nɨmoei adükarɨ nafɨtambeihü mapaiaro ra paiarɨkoate-mayo. ");
INSERT INTO agg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ranɨmboyo asu ai Saimon Pita asu süŋgururü-rundeimbɨ ŋgorü ahandɨ ŋgusüfoahündɨ ranahafanɨmbo sowana pɨpɨmayo ho. Ai ho, hoafɨyopɨrühɨ yahoya, “Adükarɨmbo nindou ai hoŋguambeahɨndɨ masowaründümo, nahü mbasɨhawurɨ, ŋga moai fɨfɨrɨhurɨ,” mehoamboyafanɨ. ");
INSERT INTO agg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ranɨmboyafanɨ Pita asu Sisasɨndɨ ŋgorü süŋgurürɨ-randeimbɨ-mayu ranai nɨmai hoŋgu sowana mahafanɨ. ");
INSERT INTO agg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ai yɨbobo pɨpɨna mahafanɨyo, ŋga asu ahambo süŋgurürɨ-randeimbɨ ŋgorü ranai Pitambo ŋgasündirü haya, ai boatei hu hoŋgu fikɨmɨ tükümefiyu. ");
INSERT INTO agg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Asu ai hu nɨmarümbo amuifoai hoeireandane hoearɨ Sisasɨmbo hɨmondüfihɨndɨ ra meŋgoroa hoeimareandɨ. Ŋga asu ai moai kefuai hoŋguambe hüfu. ");
INSERT INTO agg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Asu Saimon Pita ai süŋgunɨ hu tüküfi hayamboyu, ai hoŋguambe kefuai mahüfu. Ai hüfu hoeireandane hoearɨ Sisasɨmbo hɨmondɨhefimbɨhündɨ ra kurɨmayo. ");
INSERT INTO agg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Asu hoearɨ ŋgorü Sisasɨndɨ mbɨro hɨmondɨhefimbɨhündɨ ranamboanɨ meŋgorowa hoeimareandɨ. Hoearɨ ranana moai amurɨ kurɨmayo ranɨ-dɨbo yaŋgoro, ŋga wanɨ. Ranɨpoanɨmboyo nindou ŋgamondɨfe sɨhefembo nahurai kare pare haya meŋgoro. ");
INSERT INTO agg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ranɨyu asu ahambo süŋgurürɨ-randeimbɨ ŋgorü boatei hoŋgu sowana mahu, ranai asükaiyu süŋgunɨ hoŋguambe kefuai hüfu, hoearɨ yaŋgɨrɨ meŋgoro ra hoeire haya anɨhondümbo-mareandɨ. ");
INSERT INTO agg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ranɨ sɨmboanɨ ana moai ai fɨfɨrɨneandɨ Baiborambe yare hoafɨyowohüya, “Hoŋguambeahɨndɨ botɨndɨfimbui,” meho ra.) ");
INSERT INTO agg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","11","Ranɨyafanɨ asu ahambo süŋgurɨnɨrɨ-rɨnandeimbɨ ai worɨna hɨhɨrɨyafɨne mahafanɨ, ŋga Maria ai hoŋgu fikɨmɨ nɨŋgombo aranɨyohü manɨŋgo. Asu ai aranɨyowohüyo hoŋgu-mayo ranambe amoefoe hɨmbomayo. ");
INSERT INTO agg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Asu ai hɨmboyowane, sünambeahɨndɨ nendɨ yimbu kɨfohɨ hoearümbɨ Sisasɨmbo sɨhehorɨ wamɨ mamarɨfanda hoeimareapɨrɨ. Ŋgorü ai mbɨrowanɨ nɨmaru, asu ŋgorü ai yirɨmbonanɨ nɨmaru. ");
INSERT INTO agg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ai Mariambo safanɨya, “Nɨmorehɨ, se nɨmboeafɨ aranayafa?” masafandamboyo. Asu ai ahafanɨmbo hoafɨyopɨrühɨ yahoya, “Nindou ai wandɨ Adükarɨmbo sahorɨmɨndei hehimbo, nahü mbasɨhehorɨ ro moai fɨfɨrɨhinɨ, ŋga ranɨmboanahɨ,” meho. ");
INSERT INTO agg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ai raweyaho haya hɨhɨrɨfeyowane, asu Sisas ai daboadanɨ manüŋguwa hoeimarerɨ. Ŋga asu Maria ai moai Sisas-ani yaho fɨfɨrerɨ. ");
INSERT INTO agg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Sisas ai yahuya, “Nɨmorehɨ, se nɨmboe aranayafa? Se dabo kokorɨrɨhüyafa?” mehuamboyo. Asu Maria ai nümbürɨ aharambür-ani yahohaya hoafɨyondowohü yahoya, “Se Sisasɨmbo sowarɨndɨfühɨ ana, sowarɨndɨfɨ hafɨ sɨhaworühɨ nafuindafan-anɨmbo ro ahambo ndahümɨndɨ ŋgamboane,” mehoamboyu. ");
INSERT INTO agg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Asu Sisas ai yahuya, “Maria,” mehuamboyo. Asu Maria ai hɨhɨrɨfe, ahambo fɨfɨrerɨ haya Hiburu-yafe hoafɨnambo yahoya, “Rabonai,” meho. (‘Rabonai’ ra Hibru-yafe hoafɨnambo ‘Yamundo-randeimb-ane’.) ");
INSERT INTO agg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Sisas ai yahuya, “Se wambo kɨkɨhɨndandɨfɨ-ndɨrɨmboyafɨ. Awi ro moai wandɨ Ape sowana hahühɨ. Ŋga se wandɨ wandafɨ mamɨ sowana ŋgafɨ rando hoafɨndafɨpurühɨ anɨmboya, ‘Roana wandɨ Ape, sɨhamundɨ Ape asu wandɨ God, sɨhamundɨ God, ahambo sowana hahühühanahɨ,’ mbɨsafɨ,” mehuamboyo. ");
INSERT INTO agg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Asu Maria Makdarahündɨ ai ho ahambo süŋgururü-rundeimbɨmbo hoafɨyopurühɨ yahoya, “Ro Adükarɨmbo hoeimarɨhinɨ,” asu Sisas hoafɨyuweimbɨ hoafɨ ra hoafɨmepurɨ. ");
INSERT INTO agg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sisasɨmbo süŋgururü-rundeimbɨ ai Sudambo yɨhɨmbo-rupurühɨyomo worɨ ai nɨmarɨmondeimbɨ ra yipurɨ paru houmbo mamarɨmo. Ranɨyu asu Sisas ai Sande nɨmbambeahɨ tüküfi, ahamundɨ mbusümo manüŋgu. Ai yahuya, “Se ŋgusüfo afurɨndu kündundɨ,” mehupurɨ. ");
INSERT INTO agg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ai yare hoafɨyupurühɨyu asu ahandɨ watɨŋarɨ ŋgɨrɨ safɨnɨ ra ahamumbo nafuimepurɨ. Asu ahambo süŋgururü-rundeimbɨ ai ahamundɨ Adükarɨ ranahambo hoeirüwurɨ houmbo hɨhɨfɨ-hɨhɨfɨmemo. ");
INSERT INTO agg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Asu Sisas ai asükaiyu yahuya, “Se ŋgusüfo afurɨndu kündundɨ. Wambo Ape ai koamarɨhendɨra makosahɨ yahurai-anɨmbo asu ro sɨhamumbo koandɨheheapuranɨ ŋgomo,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ai raweyahuhüyu, ahamumbo sowanambo yafambenambo ahandɨ yafui ra foehepurühɨ yahuya, “Se Yifiafɨ Aboedɨ sowandümo. ");
INSERT INTO agg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Asu se ŋgorü nendɨ-yafe hohoanɨmo moaruwai ranahambo amboawi mbɨsɨmondanɨ ana, God ai amboawi mbusümbui. Ŋga asu ŋgorü nendɨ-yafe moaruwai hohoanɨmo ranahambo se amboawi yaho hoafɨkoate-ayomo ana, asu God ai ŋgɨrɨ ranahambo amboawi mbüsu,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Sisas ai ahambo süŋgururü-rundeimbɨ sowahɨ tüküfiyuwane, asu süŋgurürɨ-randeimbɨ mamɨ ai moai amurɨ ra-babɨdɨmbo nɨmaru. Nindou aiana Tomasɨyu, ŋga asu ahandɨ ndürɨ ŋgorü ra Didimus-ani. ");
INSERT INTO agg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ranɨyomo bɨdɨfɨrɨ ai ahambo hoafɨyomondowohü yahomoya, “Roana Nindou Adükarɨmbo hoeimarɨhurɨ,” mehomo. Ŋga asu Tomas ai ahamumbo hoafɨyupurühɨ yahuya, “Asu ro ahambo tɨkomaruründɨmo ambe ra hoefekoate-ya, asu ahambo wandɨ warɨnambo ambe ranambe sündɨfekoate-ya, asu yifiarɨnambo ŋgɨrɨsafɨnɨ wafusümaründümo sündɨfekoate-ayahɨ ana, ro ŋgɨrɨ ranɨmbo anɨhondümbo-ndɨheandɨ, ŋga wanɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Asükaiyo mamɨ wik ho hayamboyowane, ahambo süŋgururü-rundeimbɨ ai Tomas-babɨdɨmbo worambeahɨ mamarɨmo. Ai yipurɨ muŋgu papɨru houmbo nɨmarɨmondane, asu Sisas ai ahamundɨ mbusümo tüküfi manüŋgu. Ranɨyu ai yahuya, “Se ŋgusüfo afurɨndu kündundɨ,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ranɨyu asu Tomasɨmbo hoafɨyunduwohü yahuya, “Sɨhafɨ warɨ batendɨ naha ndanɨfihɨ sündowandüh-anɨmbo, asu se wandɨ watɨŋarɨ ra hoeiro. Asu se wandɨ ŋgɨrɨsafɨnɨ warɨ paro. Se ndanahambo yimbu hohoanɨmo-ndamboyafɨ, ŋga anɨhondümbo-ndowandɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Asu Tomas ai sɨmborɨ ahambo yahuya, “Se wandɨ Adükarɨ asu wandɨ God-anafɨ,” mehuamboyu. ");
INSERT INTO agg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Asu Sisas ai hoafɨyunduhü yahuya, “Se wambo hoeirowandɨrɨ hawambo wamboanafɨ anɨhondümbo-arowandɨrɨ. Ŋga nindou ai wambo hoeifendɨrɨkoate-yehü anɨhondümbo-arɨhindɨrɨ ana, ai hɨhɨfɨ-hɨhɨfɨ-mbeyeiamboane,” mehu. ");
INSERT INTO agg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Sisas ai God sowahɨndɨ makusu ra nafuimbohünda hepünɨfeimbɨ moatükunɨ afɨndɨ ahambo süŋgururü-rundeimbɨ-yomondɨ hɨmboahü ratüpurɨmayu ra ro moai buk ndanambe muŋgu sürü papɨrɨhandɨ. ");
INSERT INTO agg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ŋga ro ndanɨ hoafɨ nda sürü papɨrɨhamboanahɨ. Ro sürü papɨmarɨhandɨ nda Sisas ai Krais-ani asu Godɨndɨ Nɨmor-ani ranɨmbo anɨhondümbo-mbɨrɨhinda samboyahɨ sürü papɨmarɨhandɨ. Ŋga asu se ranahambo anɨhondümbo-arɨhindɨ ana, asu aboedɨ yaŋgɨrɨ nɨŋgombo hohoanɨmo ra ndahümündimboyei. ");
INSERT INTO agg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Asükaiyu süŋgunambo Sisas ai ahambo süŋgururü-rundeimbɨ sowahɨ Taiberias kurɨhoe puiarühɨ ndahurai ndare tükümefiyu. ");
INSERT INTO agg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas, ndürɨ ahandɨ ŋgorü Didimus yahomo-rundeimbɨyu, Natanier Kenɨhündɨ Gariri hɨfɨhündɨyu, Sebedindɨ nɨmorɨ yimbuyafanɨ, asu ŋgorü yimbu ahambo süŋgurɨ-neandeimbɨyafanɨ ai manɨŋgomo. ");
INSERT INTO agg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ranɨyu asu Saimon Pita ai ahandɨ horombodɨdɨ ratüpurɨ asükai semɨndɨmbo hohoanɨmoyuhü yahuya, “Ro ana andürɨnambo kinɨ wowarɨmboanahɨ,” mehuamboemo. Asu ai yahomoya, “Ro-amboanɨ se-dɨbo ŋgefo sefomboanefɨ,” mehomo. Ranɨyomo ai homo houmbo, botambe mafareafundɨ. Ŋga ranɨ nɨmbɨnambo ai moai kinɨ mam-amboanɨ hürühoundɨ, ŋga wanɨ. ");
INSERT INTO agg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hapoadümbo siambe hüfɨhamɨndɨ forɨforɨyuambe, Sisas ai hoe kɨmɨ manüŋguambo asu ahambo süŋgururü-rundeimbɨ ai Sisasɨmbeipoanɨ mehomo. ");
INSERT INTO agg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ranɨyu ai ahamumbo hoafɨyupurühɨ yahuya, “Wandafɨ mamɨ, se moai kinɨ wakɨründɨmoyoa?” mehuamboemo. Asu ai sɨmborɨ hoafɨyomondühɨ yahomoya, “Wanɨ,” mehomondamboyu. ");
INSERT INTO agg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Asu ai hoafɨyupurühɨ yahuya, “Andürɨ ra naha se warɨhondü waranɨ bot ranɨhundünɨ daboadundan-anɨmbo, se kinɨ bɨdɨfɨrɨ hoeindumboemo,” mehuamboemo. Asu ai andürɨ ra hoafɨmayu ranambe masafoarunda, kinɨ afɨndɨ ranai andirɨ ra tükümefeyoa, himɨndɨmbo sɨsamɨndɨmarundɨ. ");
INSERT INTO agg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sisas ahambo süŋgurürɨ-randeimbɨ wudɨyafandeimbɨ-mayu ranai Pitambo yahuya, “Pita, ni