﻿USE sofia;
DROP TABLE IF EXISTS sofia.agd_vpl;
CREATE TABLE agd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES agd_vpl WRITE;
INSERT INTO agd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yisas Karaisi maen Abaraamun nú Kin Devitin núi anan pintéi afoká ukhan mi ma ven anafuyan aví ino. ");
INSERT INTO agd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaraamu maen Aisakin kain baren Aisaki ano Yekopun kaúdan Yekopu ano Yudan má be afá aváeyan má kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda maen Peresin nú Seran nú afóe ifo míkan iyampon anóe maen Tamari ino. Peresi ano Esronin kain baren Esroni ano Ramun kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramu ano Aminadapin kain baren Aminadapi ano Nasonin kaúdan Nasoni ano Sarmonin kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sarmoni maen Boasin afóe ifo ve anóe maen Reapi ino. Boasi maen Obetin afóe ifo ve anóe maen Ruti ino. Obeti ano Yesin kaúdan, ");
INSERT INTO agd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","inká Yesi ano Kin Devitin kaen mino. Deviti maen Soromonin afoén bákan be anóe maen Uraiyan aná ma varé ein nanin mino. ");
INSERT INTO agd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soromoni ano Reoboamin kain baren Reoboami ano Abiyan kaúdan Abiya ano Asan kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ano Yeosafatin kain baren Yeosafati ano Yeoramin kaúdan Yeorami ano Usaiyan kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaiya ano Yotamun kain baren Yotamu ano Easin kaúdan Easi ano Esékaiyan kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esékaiya ano Manasen kain baren Manase ano Amonin kaúdan Amoni ano Yosaiyan mo khauran, ");
INSERT INTO agd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","inká Yosaiya ano Yekonaiyan má be afá kayo vá kauran mi Babironí barafá karavusi e fáken oren mino. ");
INSERT INTO agd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Karavusi e fáken moran mai oyampáké Yekonaiya ano Seatierin kaúdan Seantieri ano Serubaberin kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubaberi ano Abiudin kain baren Abiudi ano Eriakimin kaúdan Eriakimi ano Asorin kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asori ano Sadókin kain baren Sadóki ano Akimin kaúdan Akimi ano Eriutin kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriuti ano Eriasarin kain baren Eriasari ano Matanin kaúdan Matani ano Yekopun kaúdan maen, ");
INSERT INTO agd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","inká Yekopu ano Marian avafu Yosepin kaen mino. Maria anoi Tiyarafenu ano ma aní ukhein banta e sen ma ariyain banta Yisasin kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Máan tukhan Abaraamun táké Devitimpin onóben Devitin táké Babironí ma karavusi fáken o varé ein damú onóben mai ráké Tiyarafenu ano ma aní ukhein banta Yisasintá ma o khanaí ukhein mai fotini (14) afóeyan mi mai aúbaná me yákó urú ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Máan tukhan Tiyarafenu ano ma aní ukhein banta Yisasin ma ve anóe ano kaein mai máan mi ukhen mino. Be anóe Maria maen Yosepin amiran bákan ínaimpáké iman amintéin Kantá Aunan mano véin arápin iyampon báuantan baréin Yosepi iniren afová en mino. ");
INSERT INTO agd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Afová uren mai van be avafu Yosepi maen puntákein banta váken banasi avorá Marian ída ayave ameno van aúpáké bei inimpin mai ma véin iman ameno van iyaré ein ifá ono van en mino. ");
INSERT INTO agd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Máan inin béi variyan baré íkan Bafani enisori ano véi vaintá kaimpin dákó uven temí, “Devitin anin Yosepi oe, éin ma Marian iman ameno van iyain ída vá ifá ono. Para vara seyo, mai ma véin amúpin báken ma yákó ono van iyain iyampon mai Kantá Aunani ákona anon mai yaná afoká ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Béi afon iyampon mi kainten mifo Yisasin ne se vá ben aví teno. Para vara seyo, véi anon bei vanasi ume fintena aya uren evaránen aviranten mino.” ");
INSERT INTO agd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mai yanasinta ma yákó ein manon pura sen Bafan mano ma sakhanampa vanta finté uaren ma máa sikharé ein mi kanaíen mino. ");
INSERT INTO agd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mana arinta ano amúbasí uven mana afon iyampon kaúdantin maen Imanuerin ne sinten mino.” Mai víi ana maen Tiyarafenu setin má ban mino. ");
INSERT INTO agd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mai khain ma Yosepi ódaren maen orun mantaven mai ma Bafani enisori ano ma véin tiamein ánain bákuren Marian o aviren me ve anasí en mino. ");
INSERT INTO agd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Be anasí ma ukhan maen béi ída ven má manafin baranton nentá bákan baren mana afon iyampon káudan béi ano Yisasi ne sen aví ten mino. ");
INSERT INTO agd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yudiá barafin ma Eroti kiní ukhein damú Betariamú barufá Maria ano Yisasin kain bákan áau e uní páké manáa afova vanta kéká ano Yerusaremí barurá eriven ");
INSERT INTO agd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","máa sen inaemí, “Mana iyampon ma Yutan kayoi kin afoká ukhein mai intefasá ban nafino. Tetí ankan áau e uní páké onékun béin ma aníin ofu édaví ódaréi ventá monó teno van eriyá tiféuno.” ");
INSERT INTO agd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Máa sen ina íkan Erotin má minó Yerusaremí barurá ma varé ein nanin banta vá ano mai vaya iníden maen kokhon ineine en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Máan tiyákan Eroti ano vanasii monó ánon banta vá man baya ma afová ukhein banta kayo vá aran e átaru uvin betí ankan inaemí, “Mai ma Tiyarafenu ano ma aní ukhein banta inte varurasá afoká intéin ná sakhanampa vanta kayo ano sikharen nafino.” ");
INSERT INTO agd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Máa síkan betí ankan evaránen béin tiamemí, “Béi Betariamú barurái Yudiá barafá afoká inten ne,” sikharen mino. Para vara seyo, sakhanampa vanta ano máa sen Tiyarafenui vompon dókifin uvantaren mino, ");
INSERT INTO agd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Yudiá bara fintena varu Betariamu oe, Yudiá barafin ma aví bain baru kayoi oyampá éi ída va ono. Mai fara vara seyo, éin pinté mana ánon banta e afoká uven maen béi anon tenti Isareri nanin bantai yafisiní inten mino.’” ");
INSERT INTO agd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Máa sen tiamin Eroti iníden áau e uní páké ma afova vanta kéká erikhá ein aúpáké aran béi vaintá eríkan mai ofu ma afoká ein damusan betí ankampin avovéen ina uren afova varen mino. ");
INSERT INTO agd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Afová uren betí ankan tiantan Betariamú oriyákan temí, “Tiretí ankan ore vá mai iyampon nan mo kamaeya yosire ma véin ódante vá ovaráne séin me sisimesirá ten má dere oresá mo ventá monó teno.” ");
INSERT INTO agd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Máa síkan betí ankan kini vaya iníden mairá me ampen oriyan maen mai ma áau e uní páke ma onein ofu ano vetin an uanten oriyaren mai iyampon ma vain namun amontá o kharemen mino. ");
INSERT INTO agd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","O kharemíkan betí ankan mai ofu oniyáken moéken amusin en mino. ");
INSERT INTO agd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Máan turen mai afova vanta kéká ano mai namumpin un pében onákan mai iyampon mano ve anóe Marian má baréin betí ankan mun aron kan durafúden barará mátimen mai iyampontá monó tiren betíi unan máden oté uren kori vá kama auna iyain uveri vá irafin ma sádan kama aunka iyain uveri vá máden mai iyampon amusin amen mino. ");
INSERT INTO agd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Amiren bakháin Tiyarafenu ano kaimpin betí ankan tiamen ída vá evaráne Eroti vaintá orono síkan betí ankan iniren mai aa me ifá uren ena aa sáké betíi varufá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Afova vanta kayo ma orivíkan maen Bafani enisori ano kaimpin Yosepin avorá afoká uven máa semí, “E mantaveya iyampon má be anóen má avíare Isipí karan ore o varé esí ma séi siamenuna yamusá ovaráneya ereno. Mai fara vara seyo, Eroti ano mai iyampon dosiré arono van iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Máa siran Yosepi e mantaaren iyampon má be anóen má avíaren mai inuran mana Isipí oren mino. ");
INSERT INTO agd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","O van baren Eroti ma fúbíkan Bafan mano ma sakhanampa vanta oo ráké uaren tiyáken, “Isipíkena se sanin aré uno,” ma sikhá ein baya fura sen afoká en mino. ");
INSERT INTO agd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Eroti ma afová en áau e uní páke afova vanta kéká ano semi mákasen mino siren moéken aranan en mino. Máan turen afova vanta kéká ano ma siamiyan ofu ma afokáí oné tiferuna mai kan oranan orikhen mino ma sikhá ein nan bei aruvin banta kayo siantan Betariamú baru akhempá ma kákan baru vá tító baru vá ma vain pimpá oriyáken kan orana aránaópá ma vain ain iyampon kayo máa minó aruan puren mino. ");
INSERT INTO agd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Minó ma yanasinta ma afoká ein mai Tiyarafenu anon sakhanampa vanta Yeremaiyan pinté uaren máa sikharéin mino: ");
INSERT INTO agd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ifí baya Ramá barufin inékun ifisana yariyan kákan arun bariyá iné uno. Resori maen be akhafana van arunaná bariyan ará kusiantan baya ma siyain ída inen mino. Para va ino, minó iyampon mi fúan kípakhan mino.” ");
INSERT INTO agd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Eroti ma fúbin maen Bafani enisori ano kaimpin Yosepin avorá Isipí afoká uven máa sen ");
INSERT INTO agd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","béin tiamemí, “Éi e mantaveya iyampon má be anóen má aviare evaráne Isarerí barafá orono. Mai iyampon ma aruan purono van iyaré ein banta kayo inka furen mino.” ");
INSERT INTO agd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Máa síkan Yosepi esé ana e manten iyampon má be anóen má avíaren evaránen Isarerí barafá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Oriven iníkan Erotin anin Arkerausi ano ve afóeni varu varen Yudiá kayoi kiní ukheimpin Yosepi mai akhempá orin nan péden mai ma ena khaimpin Tiyarafenu ano véin tiamikhá einí en Kariri varafá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Orein mano Nasaretí barurá o varen mino. Máan ma ein manon sakhanampa vanta kayo ano ma siyáken béin nan Nasaretí banta ino sen aranten mino ma sikhá ein pura sen afoká en mino. ");
INSERT INTO agd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Maí damú Yudiá barafá banta ída van kámápin monó non péantan banta Yoni afoká uven banasi monó baya máa sen tiamemí, ");
INSERT INTO agd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Tiretí ankan ará baerano. Inaru yafisin inka ádé erikhen mino.” ");
INSERT INTO agd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sakhanampa vanta Aisaiyan oorá Tiyarafenu ano Yonin nan mi máa sikharen mino, “Banta ida van kámá bara fáké mana vanta ano oovaren máa siyan mino, ‘Bafani aa uvídeya veni aa funtáantano.’” ");
INSERT INTO agd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoni véi kameri ayo fóké uvaran au anamun uren kao au fóké amú anan uren báken panon má bonkampun anu vá niyaren mino. ");
INSERT INTO agd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yerusaremíke nanin banta vá Yudiá bara fáke nanin banta vá minó Yodaní non akhen páke nanin banta vá ano vanta ída van kámá barafá Yonini vaya ineno van ore ore en mino. ");
INSERT INTO agd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Oriven mo vetí ankani ume sian páman urákan Yoni ano Yodaní nompin monó non péanten mino. ");
INSERT INTO agd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yoni ma monó non péantiyan onákan Farasisi kayo vá Sadyusi kayo vá mairá eríkan betí ankan máa sen tiamemí, “Tiretí ankan namu osafáe akhafanan banan Tiyarafenui arananá uman mano siretimpin ereno van iyan mifo mai van iye anó tiamikhayá mai uman pinté karan orono van iya fono. ");
INSERT INTO agd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Máan tiya ompo siretí ankan ma fura seya ará baédanteya mai siretí ankani avúavá pókesá aní oro. ");
INSERT INTO agd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Téi siretí ankan tiamé umpo siretí ída vá Abaraamu nan tetin tinafu ino se vá ineno. Tiyarafenu ano kanaíen ma onámaná kayo sintin Abaraamun anavasiní inten mino. ");
INSERT INTO agd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Minó daa ma ída aran iran nain tíkaré irafin karú dano van mai yaa kayo anafin tantume fe van mino. ");
INSERT INTO agd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Téi ma siretí ankan nompó péantiyarúna mai siretin nan inka ará baéken mino siré aní iyá umpo sen toyampá ma eriyain bantai ákona ano senti ákona esantakhá téi ída kanaí é ben arantan anamun ayufirí ukhé uno. Béi anon Kantá Aunan má ira vá póké péantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Béin ayampin bakhari in danka van mino. Bei uviti namumpin bakhari iyan uviti aítan mápin kaiyáken ída kípan irafin aítan taman kaurinten mino.” ");
INSERT INTO agd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yoni ma vaya siyákan maen Yisasi Karirifá me ampiren Yoni ano véin monó non péantano van Yodení non arufá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Oríkan Yoni ano véin ayópá ono van temí, “Éi ano ma séi monó non pétintaren mifo éi fará téi varunafá eriya fono.” ");
INSERT INTO agd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Máa síkan Yisasi evaránen béin tiamemí, “Ída ifo séi ma siyarunaí ma éi esin mi Tiyarafenu ano ma erasan nan ma funtákein avúavá barano ma sikhá ein baya ano mo kanaí inten mino.” Síkan Yoni iniren beni vaya vákuren monó non péanten mino. ");
INSERT INTO agd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yisasin ma monó non péantádan non pinté ainen e ayoren avafá ma ódiyain má inaru ona yivin béi oniyain má Tiyarafenui Aunan mano mana kukhofá nun avúaváká ten béi vaípá eren mino. ");
INSERT INTO agd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eriyain má inaru fáké mana oova ano máa semí, “Mai sen tanin mino. Téi ven nan moéké tinunu ukhé te sú káká ben nan moéké timusin iyá uno.” ");
INSERT INTO agd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Máa siran Ban Anon mano Yisasin akhenóka ino van Kantá Aunan mano mai rákena yo aviren banta ída van kámá barafá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aviren mo khain báken foti (40) inuran má bayan má dunan auraren baréin arafan puren mino. ");
INSERT INTO agd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Arafan nan iyan baré íkan béin ma akhenókain banta ano enóben béin máa sen tiamemí, “Éi ma fura se Tiyarafenu Anin ma vanteya sesin ma onámaná kayo ano veretií ino.” ");
INSERT INTO agd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Máa síkan Yisasi evaránen tiamemí, “Tiyarafenui vompon dókifin máa sen baya uvanten mino, ‘Banasi ano yunantá ana ída kanaíen para van oriyan ban aunan baranten mifo Tiyarafenu oo fenté ma kuviyain baya ánain ma vákurinten mai fara van oriyan ban aunan baranten mino.’” ");
INSERT INTO agd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Máa síkan Ban Anon mano véin do aviren kantasí ukhein baru Yerusaremí oren mo kákan monó namun amonta suron mantaanten mino. ");
INSERT INTO agd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mo mantaantáden Ban Anon mano véin máa sen tiamemí, “Éi Tiyarafenu Anin ma vanteya káuse aravono. Para vara seyo, Tiyarafenui vompon dókifin máa sikhen mino: “‘Béi ano vei enisori kayo siantantin éintá dafíben betí ankan ayan do uvídantiya mairá káusesin ída mana onámaná ano arantan aru finten mino.’” ");
INSERT INTO agd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yisasi evaránen béin tiamemí, “Tiyarafenui vompon dókifin enádá máa sikhen mino, ‘Éi ída vá ei Bafan Tiyarafenun akhenóka uan onano.’” ");
INSERT INTO agd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Máa siran Ban Anon mano véin evaránen do aviren mana yan bain anu yontá mun kaúdaren ma varará ma ákona vara kayofin ma ara ara kama yanasinta vain aníen mino. ");
INSERT INTO agd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aní uren béi máa sen Yisasin tiamemí, “Éi ma aron durafúdeya matime sentá ma monó tiresí maé ma ma oniyaona yanasintá minó éin amenté uno.” ");
INSERT INTO agd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Máa síkan Yisasi evaránen béin tiamemí, “Ban Anon noe, sifó ono. Tiyarafenui vompon dóki ano máa sikhen mino, ‘Ei Bafan Tiyarafenu veyáká aránaópá bákeya ventá ana vá monó teno.’” ");
INSERT INTO agd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Máa síkan Ban Anon mano me ifá en orivin enisori kayo ano eriven ben me ayaen mino. ");
INSERT INTO agd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aruvin banta kayo ano ma Yonin pákaan karivusifin kain baya ma Yisasi iníden béi evaránen Karirifá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasaretí barurá manáa yamú o varen mairá me ifá uren Seburunin má Naftarin mái varafin ma Karirí non ankinafá bain baru Kapeniamú o varen mino. ");
INSERT INTO agd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yisasi ma mai avúavá barein mai Tiyarafenu ano ma sakhanampa vanta Aisaiyan oorá máa sikharé ein mi fura sen afoká en mino, ");
INSERT INTO agd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Seburuni vá Naftari vái varafin ma vain nanin banta vá Karirí non akhempá ma orikhein aayana vá Yodan non arufá ma vain nanin banta vá maen mai ena anan nanin bantan Kariri varafin baren mino. ");
INSERT INTO agd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mai kayo ano kákan títípafin baré íkan kákan oon inka khan onen mino. Purin mano ma sítípa uádan duntein barafin baré ein nanin bantafin inka kakhan afoká en mino.” ");
INSERT INTO agd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yisasi araíen monó baya vanasi siamemí, “Tiretí ankan ará baerano. Para vara seyo, inaru yafisin ádé anantá erinten mino.” ");
INSERT INTO agd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Maná damú Saimonin nan ma Pitan ne siyain banta vá be afá Endurun má ano noyana arin dorarí iyain bákan base karúdiyáin Yisasi Kariri non ankinafá oriyaren onen mino. ");
INSERT INTO agd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ódaren Yisasi vékanan máa sen tiamemí, “Tirékanan taréa noyana vaseí iya ompo sen má eresí banasi ma aviran aní uantano.” ");
INSERT INTO agd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Máa siyain má ana vékanan base unan me ampiren béin dakhafen oren mino. ");
INSERT INTO agd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yisasi mai ráké oriyan onákan Yemisin nú Yonin nú anavasan botifin kumanten be afóe Sebetin má base avové iyá íkan békanan má aren mino. ");
INSERT INTO agd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ariyain má anan békanan mai voti vá betíi afóen má me ampiren Yisasin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisasi Kariri varafin oriyáken betí ankani monó átaru namumpin un pében monó baya vanasi siamiyáken inká Tiyarafenui yafisin pintena kama vaya sian dákó iyan aí ma vá ein nanin banta ayofiyan au ma namu ukhá ein puntá antiyan en mino. ");
INSERT INTO agd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Máan tiyákan beni vaya ano minó Siriai varafá orera íkan minó nanin banta ano ara ara namu aí ma vákan ai san iyá ein má namu aunan ma varé ein kayo vá auvayaní ma iyá ein kayo vá ai ayan ma fukaré ein kayo vá aviren eríkan Yisasi minó evaránen ayofiyan kama uanten mino. ");
INSERT INTO agd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kariri vara fáke nanin banta vá Dekoporisíke nanin banta vá Yerusaremíke nanin banta vá Yudiá bara fáke nanin banta vá Yodení non ufáke nanin banta kayo vá ano véin bákuren noren mino. ");
INSERT INTO agd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Maná damú Yisasi onákan kokhon nanin banta átaru iyaimpin béi me onen anuí ukhein akhempá kena un kumamin bei eyo iyampon kayo ano véi vaintá eren mino. ");
INSERT INTO agd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Enóbin béi araíen betí ankan afova vaya amiyan temí, ");
INSERT INTO agd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Tiyarafenu van ma aiyain kayo vá amusin ino fara vara seyo inaru yafisin baru vetí ankan nina ino. ");
INSERT INTO agd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Arunanápin ma vain kayo ano vá amusin ino fara vara seyo Tiyarafenu ano ará kusiantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Be au ma vararasí uren bain kayo ano vá amusin ino fara vara seyo Tiyarafenu ano auyen bara vetí ankan aminten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Puntakein avúava san ma aiyantin ma arafan nan iyain kayo ano vá amusin ino fara vara seyo Tiyarafenu ano kanaí uantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ena nanin banta van ma arunan uantiyain kayo ano vá amusin ino fara vara seyo Tiyarafenu ano vei arunaná betin aní inten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ará ano ma avusese ukhein kayo ano vá amusin ino fara vara seyo vetí ankan Tiyarafenun onanten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aruve asiveimpin ma kusin avúavá pákaren bain kayo ano vá amusin ino fara vara seyo vetí ankan nan Tiyarafenu akhafana ino sen aranten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Puntákein avúava san ma uman amiyantin ná mai kayo ano amusin ino fara vara seyo inaru yafisin baru vetí ankan nina ino. ");
INSERT INTO agd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ten tínain ma sivákuriyasin ma ódaren mai van ma vanasi ano namu vaya siren namu uanten ara ara kampun bayafó ma aufin kuráden tiyanti mai vará amusin ono. ");
INSERT INTO agd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Para vara seyo, inarufá tiretíi kákan miyan ave ukhen mifo siretin ará ano kama ukhantiya vá moékeya amusin ná ono. Tiretin ma aan uantein erikhá ein sakhanampa vanta kayo aurá ma namu uantaká ein avúavái afoká inten mino.” ");
INSERT INTO agd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yisasi evaránen temí, “Tiretí ankan un ma einíi ukha ono. Uni ase ma kípavinti mai un intesá uresin ná evaránen ase inten nafino. Máan tukhein un ída veni ase vanti fase karúdaresin mai yaró onóbe enóbein manan ban mino. ");
INSERT INTO agd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mana kákan baru ma ída aúpasíin anu yontá báé iyain an deya siretí ma varai kakhan mono. ");
INSERT INTO agd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Banasi ano ída oon uruan kurafin kuferé iyan mifo sakhókái uruan kain báken mápin ma vain nanin banta kakhaanté iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Máan mana eya vá tiretí ankani oon áesin ná banasi avorá panu siyantin ná tiretíi kama avúavasá oniyáken inarufá bain Afóen avisá daní ino. ");
INSERT INTO agd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ída vá teya man baya vá sakhanampa vanta kayoi vaya vá do varanton mi sen nan eren mino se ineno. Téi ída ma vaya kayo yo maman karúdano van eré umpo yorékun mai vaya kayo ano mo kanai suron ino van mi eré uno. ");
INSERT INTO agd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Téi fura siré tiretí ankan tiamé uno ínaimpáké inaru vá bara vá kípanten mifo man baya fintena sitó bompon ná uvantá inten nafi inká tító kasá usikhá inten nafi ída aiyoran para vantin mi minó mai ma uvantá ein daná afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Máan tukhen mifo mana vanta ano ma man baya kayo finte sító máa yurafúden ena nanin banta afova amintin ma vetí ankan mai ánain bákuriyaré intin maen inaru yafisimpin títókái ven aví aminten mino. Máan tinten mifo mana vanta ano ma minó man baya ánain bákuriyan ma minó nanin banta van mai ánain bákurino van ma afova amiyaren maen mai vanta ano inaru yafisimpin kákan bí baranten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Máan tukhái séi siretí ankan tiamiyá uno. Tiretí ma ída Tiyarafenui anunu ánain ma vákuresin ma siretíi funtákein avúavá ano ma man baya ma afová ukhein banta kayo vá Farasisi kayo vái funtákein avúavá ma ída esantakhá intiya siretí ankan ída kanaíeya inaru yafisimpin oferan nono. ");
INSERT INTO agd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mosesini man baya ma anafu aráon amikhá ein mano sikhen mino, ‘Ída vá banta aruan purono. Banta ma aruan purin nain mano vá kópin ná orino sikhaya siretí ankan inka inikha ono. ");
INSERT INTO agd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Máan tukhái séi siretí ankan tiamé umpo vá mumunan afá aváen má ma aran kanti asivúdanona vanta ano kópin ná orono. Máan mana e mana vanta ano ma ve afá aváen nan ánon ída vain banta ono ma sin nain mai Kanisorii ánon banta anon kó tiantanten mifo mana vanta ano ma ena van óen banta ono sinten ira kiyan uman baren berai siyan purin barurasá orino. ");
INSERT INTO agd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Mai van mi Tiyarafenun ma íkun uan ameno van ma on karánará uádantá o mantave e afá aváe ano ma éin má asivuká inain baya ma ovare me ininte vá, ");
INSERT INTO agd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ei íkun uan amin daná mairá me khaúde vá esé ana ore mo mai vaya afá aváen má puntáde vá ovaráne me íkun uan ameno. ");
INSERT INTO agd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Éin kó tiantan banta ano ma aviren kó barufá ma kó tiantano van oriyantiya aine vá ayanafá béin má mai vaya funtarano. Ída ma aine funtaresin maen kó inin banta ayampin ma éin kaintin kó inin banta ano aruvin banta ayampin kaintin aruvin banta ano éin karavusifin aviren mo khainten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Téi fura siré éin tiamiyá uno. Éi karavusi namumpin para vákeyai mai ma éin aví tiantein kó miyan máa miyaní uan kípan nono. ");
INSERT INTO agd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Tiretí ankan pefái ída vá ena aná ba safi ena avafun ma safi vá e vare vare e nono síka inikha ono. ");
INSERT INTO agd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Máan tukhen mifo séi siretí ankan tiamé uno. Mana vanta ano ma mana nanin ódaren ma ineinefin aran nanteya mai vanta ano e aúpin inka ven má bare umeí e ono. ");
INSERT INTO agd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Máan tukhen mifo ayan kurompáke auu ano ma éin e yarifaan umefin ma kaintiya mai auu vá do vían karúdano. Mana vukhafa ma yo síkaan karúdaresin ma minó bukhafa ída karúdantin ma ira khiyan uman baren berai siyan purin barufin ma karúdantin orin manan kanaí inten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Inká éin ayan kurompá ano ma e yarifaan umefin ma kaintiya vá mai yáman ná do síkaan karúdano. Mana vukhafa ma yo síkaan karúdaresin ma minó en au ída ira kiyan uman baren berai siyan purin barufin orin manan kanaí inten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“‘Mana vanta ano ma ve aná tiantano vará béin ifá uantan bompon uvaman béin amiren ná tiantano,’ sen pefá Mosesini man baya ano sikha inikha ono. ");
INSERT INTO agd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Inikha ompo séi siretí ankan tiamiyá uno. Mana vanta ano ma ve aná ano ída ena vanta vá noré intin ma véi mai nanin ma siantanten mai vanta ano man bayan durafuren mai nanin nan ena vanta vá e vare vare en non bí aminten mino. Máan turantin pasen mana vanta ano ma véin má ábasuí inten maen ída vá ena aná bá e vare vare en nono ma sikhein man bayai yurafurinten mino. ");
INSERT INTO agd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mosesini ena man baya ma anafu aráon amikhein tiretí ankan inikha ono. ‘Pura ódino ma sire ayan befió uranteya mai vaya ída vá durafuriyákeya mai yaná puntáde vá Bafan avorá barano.’ ");
INSERT INTO agd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Máan tukhái séi siretí ankan tiamiyá umpo ída vá mana vayará ma ákona ono van inarufá ódino sireya ayan befió ono. Mai fara vara seyo, Tiyarafenui kumanin kin karái inaru van mino. ");
INSERT INTO agd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tiretí ankan ída vá mana vayará ákona ono van bara aví teno. Mai fara vara seyo, Tiyarafenui arantan kain kará ino. Tiretí ankan ída vá mana vayará ákona ono van Yerusaremí aví teno. Mai fara vara seyo, Kákan Kini varu ino. ");
INSERT INTO agd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Máan tukhen mifo éi ída vá mana vayará ákona ono van e ánon aví teno. Mai fara vara seyo, éi ída kanaíeya ánon do maman efanteni safi sókonteni safi in nono. ");
INSERT INTO agd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tiretí ankan ná eyo ana seya vá ída ino ana seya vá inompo manáa vaya ma mairá mo asotúin maen Ban Anon pintéi eriyan mino. ");
INSERT INTO agd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“‘Mana vanta ano ma auu ankaman dufúkinti vá ben auu ankaman dufúkono. Inká aveantun ankaman duvíkanti vá ben aveantun ankaman duvíkano,’ sen Mosesini man baya ano fefá tikhaya inikha ono. ");
INSERT INTO agd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Máa sikhen mifo séi siretí ankan tiamiyá uno. Mana vanta ano ma siretí ankan namu avúavasí uantantiya siretí ída vá béin evaráneya namu avúavasí uantano. Mana vanta ano ma mana ufáke ápa ankádanti vá ena ufáke ápa yo vaédesin ná ankan mino. ");
INSERT INTO agd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Inká mana vanta ano eni au anamun kó tiré barano van ma intiya vá ei ayá au anamun masá béin ameno. ");
INSERT INTO agd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mana vanta ano ma éin nan ona siya uan manáa ayáká mo simeno ma sinti vá éi enavá ayáká mo asotú ure vá aya uan mo ameno. ");
INSERT INTO agd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mana vanta ano ma éi vaonafá mana yana san inantinti mae véin amiyáke inká mana vanta ano ma mana yana san éi vaonafá ma simikharéesí anona evaráné ameno ma sin nain banta ída vá oyan ameno. ");
INSERT INTO agd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mosesini man baya ano ‘E arona avábá ureya vá’ ei namuro ída vá avábá ono sikhaya siretí ankan pefá inikha ono. ");
INSERT INTO agd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Máa sikhen mifo séi siretí ankan tiamiyá uno. Ei namuro avábá ureya vá éin aren asen ono van ma yakhafin nain kékasá Tiyarafenun amúkuan ameno. ");
INSERT INTO agd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Máan ma inte mae siretí ankan Afóe ma inarufá báken áau yan ma namu nanin banta vá kama nanin banta vá amaniná ma kiyain má inká á dákan ma funtákein nanin banta vá ída funtákein nanin banta amaniná bá ma yan eriyain akhafanaíi inono. ");
INSERT INTO agd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tiretí ankan ma avábá iyan nain kéká ana ma avábá inteya mai intéa miyan ná barante fono. Ídá takisi varan banta kayo vá dere máan té iyan nafino. ");
INSERT INTO agd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tiretí ankan ma e afá aváeyan mana ma avábá iyanteya mai éi intéa avúavasá ena avorá mo variya fono. Monó ída inin kayo vá ano yeren ídá manaí avúavasí é iyan nafino. ");
INSERT INTO agd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Para vara seyo, siretí ankan Afóe ma inarufá báken puntáken bainisá ukhe funtákein nanin banta vá bano. ");
INSERT INTO agd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tiretí ankan dafían ná ákona ure ída vá tiretíi kama avúava sinta vanasi ano onano van betin avorá aní ono. Tiretí ankan ma máan tinte mae siretí Afóe ma inarurá baípáke ná ída kanaíe miyan baran nono. ");
INSERT INTO agd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Éi ma ona ída van nanin banta ma manáa yaná ameno van ma inteya ída vá manáa kéká an deya kampun baya sire ída mai ánain dakhafin banasi ano ma amo sino van tiantan oriyan ma monó átaru namumpin nafi ayanafa safi ma ufen aseiní ono. Téi fura siré tiretin tiamiyá uno. Mai vanta kayo ano inká minó miyan baren mino. ");
INSERT INTO agd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Máan té iyan mifo éi ma ona i van nanin banta kayo ma aya inteya vá en ayan kuron mano ma variyain daná ída vá ayan ópá ano áesin afová ino. ");
INSERT INTO agd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Máan tesin maen eni ayain mano umefá bantin e Afóe ma inarufá báken aú páke ma variyain danasinta ma oné iyain mano éin miyan aminten mino. ");
INSERT INTO agd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Inká tiretí ankan ma amúkinteya ída vá au khákan banta kéká ano ma vaya siren ída mai ánain dakhafé iyain an deya vá banasi ano onano van monó átaru namumpin nafi aayanafa safi mantaveya amúkono. Téi fura siré tiretin tiamiyá uno. Mai kéká ano vetíi minó miyan inka varen mino. ");
INSERT INTO agd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Manten mifo siretí ankan ma amúkono van ma inteya vá ei karafarampin un pébe ona munkure vá aúpá bain Afóe vaípasá amúkono. Máan tesin maen aúpá bariyain danasinta ma oniyain Afóe ano éin miyan aminten mino. ");
INSERT INTO agd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Inká monó ída inin nan ma afokhampin bain kayo ano ma Tiyarafenu ano inino van muno siren ma ayáká amúké iyainí ída vá ono. ");
INSERT INTO agd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tiretí ída vá betí ankan an dano fara vara seyo siretí Afóe ano intéa yanasará inanteno van iya fo, mai véi fe afová ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Máan tukhen mifo siretí ankan ná máan amúkirisá ono. “‘Tetin Tifóe inarufá baona en aví kantasá bano. ");
INSERT INTO agd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Éini yafisin ná erino. Inarurá ma éin oo yaiyiyainí erá teti má barará éin oo yaiyono. ");
INSERT INTO agd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Má damú kena yunan éi setin timeno. ");
INSERT INTO agd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Éi setinti ume ampesirá inká tétin má dere máan manaé enai ume ampiantano. ");
INSERT INTO agd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Inká éi ida vá tétin akhenókafin tivire ore vá Ban Anon ayan pinte vá tétin do sivían ka ono.’ ");
INSERT INTO agd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Para vara seyo, ena nanin banta ano ma siretí ankan umeí uantádantí ma vetíi ume ampiantanteya mai siretí Afóe ma inarufá bain mano siretíi ume vá ampiantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Máan tukhen mifo siretí ankan ma ena nanin bantai ume ma ída ampiantesin maen tiretí Afóe ano siretíi ume vá ída ampiantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tiretí ankan ma yunan aurare amúkiyante vá ena nanin banta ano onano van ída vá au khákan banta kéká ano vaya siren ma ída mai ánain dakhafiyan ma yunan auraren arunan en noiní ono. Téi fura siré tiretí ankan tiamé uno. Mai kéká ano vetíi minó miyan inka varen mino. ");
INSERT INTO agd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Máan tukhen mifo éi ma yunan aurare amúkiyante auná tesé ure vá ánontá uveri vana ono. ");
INSERT INTO agd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Máan tesin ná minó nanin banta kayo ano ída afová intin ná e Afóe ma aúpá bain mai ano ana vá afová iyan inká minó daná ma aúpá bariyain daná ma afová iyain Afóe anon eni miyan aminten mino. ");
INSERT INTO agd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Tiretí ankan ída vá bara rákena kama yanasinta ma antan danú ano niyan ma karokharon ariyan ma inká umoyan banta ano varákuren bariyaimpin tiretíi kama ona kaiya vá bano. ");
INSERT INTO agd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ída vá máan tin nompo mai ma ída antan danú nan ma karokharon iran ma inká umoyan banta ano varákuren baré iyain mai inarufasá tiretíi kama ona vá kaono. ");
INSERT INTO agd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Para vara seyo, éini kama ona ma vain mai varurái eni ineine vá aú amafon má banten mino. ");
INSERT INTO agd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Auu ma vain mai aui on mifo éin auu ma kama ukhantin maen éin au fimpá kakhan mano víkakhen banten mino. ");
INSERT INTO agd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bíkanten mifo éin auu ma namu ukhantin mai minó éin aufimpá títípá inten mino. Mai oon ma éin aufin títípá ukhantin maen eni minó bukhafa ano moéken títípá en kumayusí inten mino. ");
INSERT INTO agd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ída mana vanta ano kanaíen kankanan ayafai yorarí inten mino. Máan ma inten maen mana ayafa oman kaumpan uantáden ena ayafa avábá uanten inká manai oo yaiyen ena oofá átakharé uantanten mino. Máan tukhanti siretí ankan ída kanaíeya Tiyarafenu vá moní bái yoran bantaí inono. ");
INSERT INTO agd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Máan tukhein nan mi séi siretí ankan tiamiyá uno. Ída vá tireti ma váke yunan má non má ma nanona van e inian moreya inká auí daná ma aurá inona van kokhon ineine ono. Aunan ma váka vaona anó dunan ma naren ban esantakhan ná inká au vukhafa ma váka vaona anó auí daná ma uren ban esantakhen nafino. ");
INSERT INTO agd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tiretí ankan ayompin ma vain nun kayo vá onano. Betí ankan ída yunan doren unafen uan mápin kaé iyan mifo siretí ankan Afóe ma inarufá bain manon betin dunan amé iyan mino. Tiretí ankan ídá mai nun kayo esantakhé unó té inikhe fono. ");
INSERT INTO agd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Máan tukhen mifo siretí ankan pinté mana ano ma kamaé bano van ma kokhon ineine inten maen mai ano kanaisá ená bei van manáa vá mo asotú inten nafino. ");
INSERT INTO agd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Máan tukhen mifo siretí ankan pará auí dana san kokhon ineine iya rafono. Tiretí ankan paravan kayo ma ampantein ná onano. Betí ankani yoran ída vákan auí daná ina ída amué iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Máan té iyan mifo séi siretí ankan tiamé uno. Pefá Kin Soromoni ano minó buí daná amu uren iyaren mifo veni auí daná kayo ano faravan kayo ma kiyain má ída manaí ukharen mino. ");
INSERT INTO agd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mai ma sare ampantaré intin inuran ma síkaren ira saran nain káta mai Tiyarafenu ano kamaen auí uanté iyain mifo sító mumunan má baona nanin banta oe, véi ídá kanaíen ná tiretin auí uantanten nafino. ");
INSERT INTO agd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Máan tukhanti nái yunan má non masá naré báké intéa vuí danasá onte rafuno se siretí ankan ída vá kokhon ineine iya vá bano. ");
INSERT INTO agd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Para vara seyo, afokhampin ma vain nanin banta kayo ano mai yanasinta van dosé iyan mifo siretí ankan Afóe ma inarufá bain mano siretin nan mai yanasintan barano van iya ono sen pefái afová ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Máan tukhen mifo esé daná Tiyarafenui yafisin má beni funtákein avúavá bá dosiresin ná mai yanasinta yere minó tiretin amino. ");
INSERT INTO agd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Máan tukhen mifo vá inurantena yana san ída vá tiretí ankan kokhon ineine ono, fara vara seyo inun damú ano veyan inurantena van ineine inten mifo mana mana yamúpin bei uman barú barú ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tiretí ankan ída vá ena nanin bantai avúavá daimono. Para vara seyo, Tiyarafenu ano siretin má deren máan manaen daiminten mino. ");
INSERT INTO agd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tiretí ankan ma ena nanin banta yaimiyá inona mai avúaváká anan Tiyarafenu ano siretin daiminten mino. Tiretí ankan inte avúavákasá ena nanin banta yaimiyá inte fo mai avúaváká anan ten Tiyarafenu ano siretin daiminten mino. ");
INSERT INTO agd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Éi fará e afá aváen auufen ma sitó daa antan bain oniyá bákeyá e auufen ma yaa khaéádan bain nan ída iniya fono. ");
INSERT INTO agd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Daa khaéádan maen auufen bantiya éi mai intesá eyá e afá aváen nan tifá tiváe oe, en auu fentena yaa antan do manantano van muno sinte fono. ");
INSERT INTO agd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Éi vaya ma sire ída mai ánain dakhafin banta ompo vá e auufen ma yaa khaéáádan bain nare vá do máde vá auu kamaeya óde vá e afá aváen auu fentena yaa antan do manantano. ");
INSERT INTO agd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Tiretí ankan ída vá Tiyarafenu ma siantádantin kantasí ukhan nain daná maman iyan kayo ameno. Amesin naren mai iyan kayo ano vaéaren tiretin untaranten mino. Tiretíi kama ukhein ankaroro kayo arantampó dasamin nafo ída vá pon kayo karúdaan ameno. ");
INSERT INTO agd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Tiretí ankan amúkimpó ma inantiya vasin maen Tiyarafenu ano aminten mino. Dosiya ma vare mae oman afoká inono. Onará ma ankamiya vasin maen ona yiantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Para vara seyo, amúkimpó ma inan ma sé iyain nanin banta ano minó daná baré iyan mino. Mana vanta ano ma mana yana san ma yosiyaren mai yaná oné iyan mino. Mana vanta ano ma onará ma ankamiyá intin maen Tiyarafenu ano véin ona yiantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Mana iyampon mano ma siretin pinte mana afóe vaonafá ma yáun nan ma inantinti mae iye anó onámaná maman aminte fono. ");
INSERT INTO agd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Inká noyana van ma inantinti mae namu osafáé e akhá aminte fono. ");
INSERT INTO agd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tiretí afóeyan mano ma namu avúavá bariyákeya ma e akhafana kama yanasinta ma amin mai afová ukheya ma amé iyaonaí anan en tiretí Afóe ma inarufá bain mano ventá ma amúkimpó inantin nain nanin banta moéken kama yanasintan aminten mino. ");
INSERT INTO agd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Máan tinten mifo ena nanin banta ano inte avúava sintá tiretin uantano vará anunu iyante fo mai avúava sinta ana vá betin uantano. Mai avúava sinta maen mai man baya vá sakhanampa vanta kayo vái ana vaya ino. ");
INSERT INTO agd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Tiretí ankan tító onafin ná umperano. Para vara seyo, o afeyoran barufá ma orikhein ona kákan mi vákan maifá ma orikhein aa kákan ban kasaen orirí ukhan mi kokhon nanin banta ano mai aa anan bákuren oriyan mino. ");
INSERT INTO agd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Máan tukhen mifo aun baran barufá ma orin ona sitói vákan mai varufá ma orin aa sitosí ukhan maen manáa nanin banta ano anan mai aa yosiren óden oriyan mino. ");
INSERT INTO agd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kampun sakhanampa vanta kayo vará tiretí ankan dafían ná ákona ono. Sipi sipi ayo unan kafina uren erinten mifo aúpin afá iyan kayo víkakhen mino. ");
INSERT INTO agd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Máan tukhein tiretí ankan betin avúavá ano ma aran imá dan nain mi ódeya afováin nompo kaná ayankun anan tákena uvaini aran kúdená inká avi kháta kayo rákena fíki aran kúden ná inten nafino. ");
INSERT INTO agd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Máan manan en mi kama yaa ana kayo ano kama aran máan imádé iyan mifo namu yaa ana kayo ano namu aran máan imádé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kama yaa ana ano ída namu aran iran maen inká namu yaa ana ano ída kama aran iran é iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ída ma kama aran iran nain daa ana kayo síkaren ira saman kaurinten mino. ");
INSERT INTO agd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Máan tukhantiya vetí ma aran imádan naintái afová eya onan nono. ");
INSERT INTO agd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Téin nan ma Bafan noe, Bafan noe, sen tariyain nanin banta kayo minó ano va inaru yafisimpin oferanten naino. Ída ifo inarufá ma vain Tifóeni vaya ánain ma yakhafin nain nanin banta kayo ano anan inaru yafisimpin oferanten mino. ");
INSERT INTO agd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tiyarafenu ano ma vanasi yaimin nain damú kokhon nanin banta ano se nan ‘Bafan noe, Bafan noe, setí ankan en avíká sakhanampaíin dorarí iyáké inká en avíká ana namu aunan do siantiyá maé inka kokhon enará ukhein danasinta maman afoká iyaré uno,’ sinten mino. ");
INSERT INTO agd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Máan ma sintí maé téi funtádé evaráné betin tiamenté uno, ‘Tiretí ankan namu avúavá baran nanin banta kayon banái séi ída siretin afová ukhé umpo sifó oro.’ ");
INSERT INTO agd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Máan tukhein nan mi senti vaya iniren ma mai ánain dakhafin nain nanin banta anon kama afova vain banta ano ma kákan onámaná daró ma má uvareiníi iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Uvantaré íkan á bá uva vá uáken anon non taven mai má avékan maen kákan onámaná daró uvantaréin pasen ída mai namun baráken mino. ");
INSERT INTO agd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Máan ten mifo senti vaya ma iniren ída mai vaya ánain ma yakhafin nain nanin banta ano mai ída afova vanta ano ma eyurá ma ve amá uvareiníi iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Uvantaré íkan á bá uva vá uáken anon non taven mai má avékan baráken eraven mino.” ");
INSERT INTO agd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yisasi ma mai vaya kayo siamiran maen minó nanin banta ano véi ma afova amiyain baya kayo van takhaen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mai fara va ino vetíi man baya ma afová ukhein banta kéká ano ma afova amiyainisa en naifo mana aví bain banta ano ma afova amiyainíi en mino. ");
INSERT INTO agd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisasi ma anuyon me ampiren aravíkan maen kokhon nanin banta ano ven ánain dakhafen araven mino. ");
INSERT INTO agd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Araviyain má mana amon dana aí bain banta ano Yisasi vaintá eren me aron kanan durafúden mátimen temí, “Bafan noe, éi ma anunu iyante séin tu sesé usintesí evaráné kama ono.” ");
INSERT INTO agd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Máa síkan Yisasi ayan dan orin mai vanta au aruviyan temí, “Evaránen en au avusese en kama ino van téi sinunu iyá uno.” Siyain má manádá amon dana aí kípan maen mai vanta au evaránen kamaen mino. ");
INSERT INTO agd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kama uantáden Yisasi véin máa sen tiamemí, “Éi ída vá ma ma en au kama uanteruna vaya mana vanta siameno. Oreya vá monó doran banta vaintá oresin ná éin avové en onano. Pefá ma Mosesini man baya ano ma sikhá einí eya vá Tiyarafenu ma íkun uan amin danasinta máde susu seya amusin amesin ná minó nanin banta ano óden inka veni aí kípakhan mino sino.” ");
INSERT INTO agd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yisasi ma Kapeniamú barufin o uniyain má mana antareti (100) aruvin banta kayoi ayafa vanta ano véi vaintá eriven béin ayaino van ínan en inaemí, ");
INSERT INTO agd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bafan noe, senti yoran banta ai ayan púkan kákan aí iyan berai siyáken bakhen manan bá uno.” ");
INSERT INTO agd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Máa síkan Yisasi véin tiamemí, “Téi oré mo ayofanté uno.” ");
INSERT INTO agd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Máa sin aruvin banta kayoi ayafa ano Yisasin evaránen tiamemí, “Bafan noe, séi ída kama vanta varuna éi ída kanaíeya sen timá orin nompo vaya ana sesin ná tenti yoran banta evaránen asefa ino. ");
INSERT INTO agd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mai séi farava máa siya rauno sesi ayafa vanta kayoi aránaópái séi vákun maen inká tenti aránaópái manáa aruvin banta kayo vái mana van ma orono ma sékun oriyá maé inká ena van ma ereno sékun maen eré iyan mino. Inká tesi yoran banta van ma ma yorarí ono ma sékun mai yorarí é iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Máa síkan Yisasi mai vaya iniren anú duren mai ma ven dakhafen noré ein nanin banta máa sen tiamemí, “Téi fura siré tiretí ankan tiamiyá uno. Téi onékun ma vantai mumunan má manaí ukhein banta Isarerii varafin ída mana van mino. ");
INSERT INTO agd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Máan tukhái séi siretí ankan tiamiyá uno, Áau e unipá bá orun perápá bá ma vain bara fintena nanin banta kayo finté kokhon mano inaru yafisimpin ere ere uven maen maifin ma omasí inaimpin Abaraamu, Aisaki, Yekopun ankan má manafin kumamen dunan nanten mino. ");
INSERT INTO agd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nanten mifo Tiyarafenu ano ma vei yafisimpin bano van ma fe iyáantákáin nain nanin banta yo siantantin títípa ukhein barufin o váken berai siyan aveantuntá inkekípiyan ifí danten mino.” ");
INSERT INTO agd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Máa siren aruvin banta kayoi ayafa vanta siamemí, “Éi ma mumunan eonaíen mai yaná afoká inten mifo orono.” Máan ma siyain áaurá anai mai yoran bantai aí daná kípen mino. ");
INSERT INTO agd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yisasi ma Pitan amápin un pében onákan maen Pitan aná anóen aí uaren aufá ira kharo iyan takhópin bakhen baren mino. ");
INSERT INTO agd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bakhen baré íkan Yisasi ven ayan bana fákiyain má mai aí daná kípavin e mantaaren beni yunan taren mino. ");
INSERT INTO agd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mai inúpá kokhon nanin banta ano namu aunan ma vain kéká aviren Yisasi vaípá ere ere íkan mai aunan kéká do siantiyan inká aí daná ma vá ein kayo minó ayofen mino. ");
INSERT INTO agd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Máan ma ein manon sakhanampa vanta Aisaiyan pinté uaren Tiyarafenu ano sikhan mino. “Béi anon tetisi ara ara sí daná kípasintáden tetin kama usintanten mino,” ma sikhá ein mi fura sen afoká en mino. ");
INSERT INTO agd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yisasi ma onákan kokhon nanin banta ano véin aúban den iyen eúkiyaimpin bei eyo iyampon kayo siamemí, “Erí non e khádé ena ufá ódó tifano.” ");
INSERT INTO agd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Máa síkan mana man baya ma afová ukhein banta ano eriven Yisasin tiamemí, “Aru soe, éi ma orinonafá téi en dakhafé nonté uno.” ");
INSERT INTO agd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Máa síkan Yisasi evaránen béin tiamemí, “Afá iyan kayoi ain bákan maen inká nun kayoi nan bákan ukhen mifo Banta Anin mano ma ánon kauren baran nain beni kanú ída van mino.” ");
INSERT INTO agd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Máa síkan maen eyo iyampon kayo finté mana ano máa sen Yisasin tiamemí, “Bafan noe, áesirá te sifóen nare mo masí urerá ono.” ");
INSERT INTO agd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Máa síkan Yisasi véin tiamemí, “Áin púkein banta kayo ano furin banta masí iyantiya éi sen dakhafono.” ");
INSERT INTO agd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Máa siren Yisasi votifin un kumanin bei eyo iyampon kayo ano yakhafen óden mino. ");
INSERT INTO agd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ódiven non aúbaná oriyain má anú deiníen kákan uva íkan non karantó uaren boti yarararí iyan mifo Yisasi fara aun bakharen mino. ");
INSERT INTO agd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bakharé íkan bei eyo iyampon kayo ano véin mo avoriyan avádóden temí, “Bafan noe, Bafan noe, non ufurirí iyá tiféumpo setin tiya ono.” ");
INSERT INTO agd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Máa síkan béi evaránen betí ankan tiamemí, “Titó mumunan má baona vanta kéka soe! Pará akhokho van iyara fono.” Máa siren béi e mantaaren uva vá non má ákonaen asiyain má púkekhaven ída kayaen mino. ");
INSERT INTO agd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Máan tiyain má betí ankan takha iyan kokhon ineine en orera iyan beraran inaemí, “Ma inté ukhein bantá bákan ná uva vá non má ano véin oo yaiyiyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yisasi Karirí non e kháden ena ufá Kadará kayoi varafin óden mino. Ódiyain má namu aunan kayo ma vain bantá kanan mano ven má e fóken mino. Maí kanan banta ano afasíen non banta masí ukhein pimpá baren nóken aran má ukhan maen banasi ano féden mai aasá ída oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Máan tiyá íkan míkanan mano avádóden oovaren temí, “Éi Tiyarafenu Anin mompo, náisá ono vará damú ída afoká ukhayá tetin namu ono van eriya fono.” ");
INSERT INTO agd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Máan ma siyákan maen manáa nentá pon kayo iyukhen báken dunan niyaren mino. ");
INSERT INTO agd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Niyan bákan namu aunan kayo ano Yisasin ínanen inaemí, “Tetí ankan ma sisintante vá áesirá mesan pon kayo aúpin ná oferá tifano.” ");
INSERT INTO agd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Máa síkan Yisasi evaránen betin tiamemí, “Tiretí ankan orono,” siyain má namu aunan kayo ano mai kanan banta me ampiren pon kayo aúpin o fébíkan mai fon kayo ano sava uaren kákan ayafin o káusiven non ufuren puren mino. ");
INSERT INTO agd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Máan tiyain má pontá ma yafíká ein banta kéká ano kákan barufá karan oren mo minó nanin banta mai ma afoká ein daná baya siamiyáken namu aunan kayo ma vá ein bantá kanampin ma afoká ein baya vá dere siamen mino. ");
INSERT INTO agd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tiamíkan iniren mai varu finté minó nanin banta ano Yisasin onano van eren mino. E oniyáken betíi vara me ampiren ena akhempá orino van ínanen tianten mino. ");
INSERT INTO agd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yisasi mana votifin un kumamen Karirí non e kháden bei varufá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Oriyain má manáa vanta kayo ano ai ayan púkein banta kúkútafin bavin daiyen eríkan Yisasi ma vetí ankani mumunan ódaren mai aí banta máa sen tiamemí, “Tanin noe, eni ume ampianté umpo vá en ará ano ákonaen ná bano.” ");
INSERT INTO agd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Máa síkan maifin manáa man baya ma afová ukhein banta kéká ma varé ein mano mai vaya iniren betiyan ten oreraemí, “Ma vanta ano Tiyarafenui varun bariyan ume ampiantiyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Máa sen iniyan Yisasi vetí ankaní ineinefin afová uren temí, “Pará tiretí ankan aúpin namu ineine maman ayuman iya rafono. ");
INSERT INTO agd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Inte vaya ma seruna anó teso sikhen nafino. ‘Eni ume ampianté uno’ ma seruna ano fino áa éi ‘e mantave orono’ ma seruna ano fino. ");
INSERT INTO agd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Máan tukhen mifo sireti sá afová ono Banta Animpin ákona vákan mi ma varará ume kayo ampiantiyan mino.” Máa siren mai ma ai ayan púkein banta van temí, “Mantaveya ei kúkúta mamare ei varufá orono.” ");
INSERT INTO agd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Máa siyain má mai vanta ano e mantaaren bei varufá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Oríkan banasi ano ódaren akhokho van uren máan ákona ma varará banta ma amé iyain nan Tiyarafenu aví daníen mino. ");
INSERT INTO agd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mairá Yisasi me ampiren oriyaren o onákan Matiun ne sin banta ano sakisi varan namumpin kumantaré íkan Yisasi véin tiamemí, “Éi ere sen tivákurono.” Síkan Matiu e mantaaren ben avákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yisasi ma Matiun amápin o khumanten dunan niyákan maen kokhon takisi varan banta kéká bá ume nanin banta kayo vá ano maifin ódiven Yisasi má bei eyo iyampon kayo vá manafin kumamen dunan nen mino. ");
INSERT INTO agd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Niyákan Farasisi kéká ano ódaren aranan iyáken beni eyo iyampon kayorá inaemí, “Pará tiretí ankani arú ano sakisi varan banta kéká bá ume vanta kayo vá manafin kumamen dunan niyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Máa siyákan Yisasi mai vaya iniren máa semí, “Aí ma ída vain nanin banta kayo ano ída ayofan banta vaípá oré iyan mifo aí ma vain nanin banta ano anan ayofan banta vaípá oré iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ma vaya ma Tiyarafenui vompon dókifin ma vain pintena vá tiretí ankan ore vá o afova varano. ‘Ena ma arunan uantan nan mi siranakhen mifo íkun ma uan amin nan ída ino.’ Téi funtákein kéká arano vara ererauno, umeí ma en noin kayon arano van mi erikhé uno.” ");
INSERT INTO agd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Maná damú Yonini eyo iyampon kayo ano Yisasi vaintá eriven béin inaemí, “Farasisi kéká bá tetí ankan má ano yunan turé iyá umpo fará eni eyo iyampon kayo ano ída yunan auriyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Máa sen ina íkan Yisasi evaránen betí ankan tiamemí, “Anasi ma iman ameno van iyantin ma mai vanta ano ma vei kéká bá para vantin maen mai vetí ankan nái vará béin arunan uantanten nafino. Maná damusí intin ma anasi iman ameno van iyain banta ma aviren orivintin maen maí damúi vetí ankan dunan auranten mino. ");
INSERT INTO agd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ída mana ano auyen davaráe ma kafáádan póké peyante au anamun ma yakakheimpin mo yamparen amué iyan mino. Para vara seyo, auyen davaráe kafáádan ma feyante au anamuntá mo yamparen amu urantin baren maen auyen davaráe ano yarifantin tampí tiaren mai au anamun kákantá eyáken orera inten mino. ");
INSERT INTO agd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ída mana vanta ano feyante memé au unampin auyen uvaini anu vanaé iyan mino. Peyantefin ma vanarantin maen paútiaren uvaini anu varará banaen eravintin mai memé au unan namu inten mino. Máan tukhan mi auyen memé au unampin ma auyen uvaini anu vanaran maen mi míkanan kamaen báé iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisasi ma Yonini eyo iyampon kayo vá baya siyákan maen mana átaru namuntá ánoní ukhein banta ano véi vaintá me aron kanan durafúden mátimen temí, “Te siraun taréa furí umpo éi ereya mo ayan ben aurá kaesin evaránen aunan baren mantano.” ");
INSERT INTO agd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Máa síkan Yisasi e mantaaren béin dakhafen oríkan bei eyo iyampon kayo vá ano yere oren mino. ");
INSERT INTO agd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Oriyákan mana nanin maen tirantan kan orun kádan (12) oranará biyon aí daná mantein baré íkan mai nanin mano ádé eriven Yisasini ayá au anamun áton aruven mino. ");
INSERT INTO agd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aruviyan mai nanin mano veyan nan temí, “Beni au anamun ma aruvékun maen tenti sí daná kípanten mino.” ");
INSERT INTO agd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Máa siren aruviyain má Yisasi yo vaéan mai nanin oniyáken temí, “Tiraun noe, eni mumunan manon eni aí kípaanten mifo en ará ano vá ákonaen bano.” Máan ma siyain má anan mai nanini viyon aí daná kípen mino. ");
INSERT INTO agd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Máan turen mairá Yisasi oren monó átaru namuntá ma ánoní ukhein banta amápin o onákan banasi ano kuní iyaren mino. ");
INSERT INTO agd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Máan tiyákan Yisasi semí, “Tiretí ankan báe entavoro. Mai arinta ída fúken paran aun bakhen mino.” Máa síkan minó ano venan inten oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mai nanin banta ma yo siantan barufá eravuvin maen Yisasi mápin un pében mai arinta ayan bana ma fakaaran orun manten mino. ");
INSERT INTO agd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mai ma Yisasi varein avúavá baya ano mai varafin minó akhempá oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yisasi ma mai varu me ampiren oríkan maen auu yufúkukhein bantá kan mano oyampá dakhafen oriyan oovararen máa semí, “Devitin Anin noe, verasan nan arunan usintano.” ");
INSERT INTO agd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Máa sen oriyákan mai ma véi vain namumpin un pébin mai ma auu yufúkukhein bantá kan mano mai namumpin béi vaintá unóbin Yisasi vékanan máa sen inaemí, “Tenan tirékan auu kama urantí onano vará mumunan iya fono,” síkan békanan evaránen béin tiamemí, “Eyo Bafan noe, berasan mumunan iyá uno.” ");
INSERT INTO agd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Máa síkan békanan auurá ayan kaúden temí, “Tiré kan ma sentá mumunan eonarái mai yaná kanaíen afoká inten mino.” ");
INSERT INTO agd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Máa siyain má míkanan evaránen auu mábíkan Yisasi ákonaen airon ananí uanten temí, “Ma ma siré kampin ma afoká ein daná ída vá áesin mana vanta ano afová ino.” ");
INSERT INTO agd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Máa siran maen maí kan banta ano oren Yisasi ma varein avúavá baya mai varafin ma minó akhempá ma vain nanin bantafin mai vaya siádan oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Maí kan banta ano ma Yisasin me ampiren oriyain má namu aunan mano oorá iyákan ída vaya siyain banta vanasi ano aviren béi vaintá eren mino. ");
INSERT INTO agd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Eríkan Yisasi ma mai namu aunan do siantádan maen mai vanta ano vaya síkan banasi ano sakha iyáken temí, “Pefá ída Isarerii varafin máan daná afoká in ontaren mino.” ");
INSERT INTO agd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Máa sen orera iyan maen Farasisi kéká ano semí, “Namu aunani ánon bantai ákonarái véi namu aunan do siantiyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Minó kákan barufimpa safi sitó barufimpa safi Yisasi oriyáken betíi monó átaru namun kayofin Tiyarafenui yafisin pintena kama vaya kayo siamiyáken ara ara aí daná kayo ayofen oren mino. ");
INSERT INTO agd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Máan ten oriyáken kokhon nanin banta kayo onákan sipisipirá dafisin banta ída vákan ma asuse en aminofin nóken ma ayain banta van dosen noiní iyákan mai van Yisasi vetí ankan nan arunan uanten mino. ");
INSERT INTO agd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Arunan uantáden bei eyo iyampon kayo siamemí, “Kokhon dunan karakhan mifo mai yunan ma yuyasin kéká tanáan ban mino. ");
INSERT INTO agd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Máan tukhen mifo vá dunan afóe vaipasá amúke inantesin ná béi kokhon doran banta siantantin bei yunan karápin oriven ná beni yunan duyáan átaru ino.” ");
INSERT INTO agd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tirantan kan orun kádan (12) eyo iyampon Yisasi araren namu aunan kayo ma yo siantan má ara ara aí daná ma ayofan ákona vá amen mino. ");
INSERT INTO agd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mai máa sirantan kan orun kádan (12) baya varen orin banta kéká aví máan mi ukhen mino. Esé araíen Saimonin nan ma Pita ne siyain má inká ben afá Enduru má inká Sebetin anin kanan Yemisin nú Yonin nú anavasan má inká ");
INSERT INTO agd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Firipin má Bataromiun má Tomasin má takisi varan banta Matiun má inká Arafiasin anin Yemisin nú Tadiusin nú bá ");
INSERT INTO agd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Serotin anan banta Saimonin má inká ínaimpá ma Yisasin avían namuro ayampin amin nain banta Yudas Iskariotin má ino. ");
INSERT INTO agd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisasi mai máa sirantan kan orun kádan (12) banta siantan oriyákan afova vaya kayo máa sen tiamemí, “Tiretí ankan ída vá ena anan banta kékápin ore vá inká Sameriá kayoi varufimpá bá ída vá orera ono. ");
INSERT INTO agd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isareri kékái sipisipi kayo ma afeyókein mai kayofin mana vá orono. ");
INSERT INTO agd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tiretí ankan ma oriyáke mae vá máan ná teno, ‘Inaru yafisin inka ádé erikhen mino.’ ");
INSERT INTO agd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tiretí ankan oreya vá aí banta mo ayofesin evaránen asefa intiya vá, púkáin nain ayanóan mantiyáke vá, amon dana aí ma fákakhan nain kama uantiya vá, banasifin ma namu aunan baréin nain do siantiya vá ono. Ma ákona ída miyan bákaya faran tiretí ankan bare ompo vá mai ída miyan bantiya fara vá banasi aya ono. ");
INSERT INTO agd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tiretí ankan ída vá kori fi siriva fi kopa moni safi vá amú anan unampin bá ureya vare orono. ");
INSERT INTO agd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tiretí ankan ma oriya mae ída vá unan bareya inká ída vá ena au anamun má arantan anamun má ayonta vá bare vá orono. Mai ma mo yorarí uantanona nanin banta ano vá éin dunan má minó daná bá amino. ");
INSERT INTO agd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Tiretí ankan ma mana kákan barufin nafi sitó barufin nafi ma orivinte mae funtákein banta van mairá dosireya mai vanta amasá bareya mai varu me ampeno. ");
INSERT INTO agd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tiretí ankan ma mai vanta amápin un pébinteya mai namumpin ma van nain nanin banta máan ná te siameno, ‘Tiretin má ará kusin banten mino.’ ");
INSERT INTO agd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Máa sesin ma mai namun pinte nanin banta ano ma amusin iyan ma siretí ankan aviranti mae vá tiretíi avu vaya áesin ná betin má bano. Banten mifo siretin ma ída amusin iyan ma avirantiya vá tiretíi ará kusiantan baya áesin ná ovaránen tiretimpin erino. ");
INSERT INTO agd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mana ano ma siretí ankan ída aviren be amápin oren ma siretíi vaya inin nan ma afonkarí intiya ma mai varu me ampinte vá arantantáke kayosá betin avorá me fúpá tian karú desin ná afová en ná Tiyarafenu ano setin uman timinten mino sino. ");
INSERT INTO agd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Téi fura siré tiretí ankan tiamiyá uno. Tiyarafenu ano ma vanasi yaimono van inikhein damú ma afoká intin Sodomu varu vá Komora varu vá ané ma afoká ukhá ein mai uman moéken esantakhein uman mi mai varu kayo finte nanin banta ané afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Máan tintéíi séi siretí ankan afá iyan ofen ma sipisipi kayo siantan oreiníi é umpo vá osafáe an de vá bempáké barará tonanempe vá oriyákeya kukhofá nun mano ma fúkekhaven noinisá ono. ");
INSERT INTO agd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Manáa vanta kéká kasá dafían ákona ono. Tiretin avían Kanisori kayorá mo kaintin kó tiantáden betíi monó átaru namun kayofin tiretin dafiyó ankaminten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Téintá ma mumunan iyaona van mai kéká ano siretin avían kamanin kayo vá kin kéká bá avorá kaintiya mairái vetin má ena anan nanin banta kayo avorá bái kama vaya sian dákó inono. ");
INSERT INTO agd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Máan tesin ma siretin avían kópin ma kaintiya inte vayá tente rafuno sireya ída vá anomé ineno. Mai áaurá anan Tiyarafenu ano mai ma sinona vaya ineine amintiya sinono. ");
INSERT INTO agd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mai fara vara seyo, siretiyantá ída vaya sin nompo siretí Afóeni Aunan manon tiretin oo ráké uaren baya sinten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Be afá aváe ano e mantaaren be afá aváen avían namuro ayampin kaintin aruan purintin maen be afóe ano e mantaaren be akhá mai avúavasí ana uantantin maen inká iyamporinta ano e mantaaren be anóe afóen namuroí uantáden arintin purino van avían namuro ayampin kainten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Téin tiví ma siretimpin banti ma séin bákuriyanona van mi minó banta kéká ano siretí ankan ará namu uantanten mifo iye anó mantaan ákona ukhen baré intin ná ma varai kípan damú afoká inten nafi Tiyarafenu ano mai nanin banta kayon evaránen aviranten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tiretí ankan ma mana varu fintena nanin banta ano ma inian namu uantanti mae ena varu fasá karan orono. Téi fura siré tiretin tiamé uno. Isarerii varafin ma vain baru kayofin ída yóan kípakhesin mi Banta Anin erinten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Sikhuru iyampon mano vei arú ída esantakhan inká doran banta ano vei ayafa ída esantakhan ukhé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sikhuru iyampon mano ma vei arú bá mun manaí intin ma inká doran banta ano ma vei ayafa vanta vá mun manaí intin maen mai anan kanaí inten mino. Má afóen nan ma namu aunani ánon banta Beseburi e ma sen ariyain mai veni kéká bá deren moéken namu ví aranten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Banta kéká ano ma siretí ankan uman ameno van ma intiya sireti ída vá akhokho van ono. Aúpá ma ana yamuan kain bain danasinta ano yákó intin inká aúpá baya kayo vanasi ano afová inten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Téi ma inuran pinté ma siamenuna vaya vá tiretí ankan kakhakhein tasá teno. Tiretí ankan átarempin ma kafaya finté ma siamin nain baya vá má amontasá un mantaveya vá oovare vanasi siameno. ");
INSERT INTO agd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Banta kéká ano ma yante vukhafa aruan purin nan ída vá tiretí ankan perano. Beti ída kanaíen aú bá aruan purinten mifo Tiyarafenu veya vará perano. Béi anon kanaíen aú bá dan bukhafa vá mai ma ira kiyan uman baren berai siyan purin barufin taman kaurinten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mana monípó tító nun kanan miyaní ino van kaé iyan mifo siretí ankan Afóe ano mai nun kayo kamaen dafisiyáken mai fintena mana ída áintin barará eravino van anunu ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Máan tukhan mi Tiyarafenu ano siretí ankan ánon do yankáan kíparen minó afova suron ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Máan tukhaya siretí ankan tító nun kayo esantakha ompo ída vá akhokho van ono. ");
INSERT INTO agd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mana vanta ano ma e manten banasi siamen ma séi veni kéká uno ma sintí maé mai sen má deren béin nan tesi kéká ino sé Tifóe ma inarufá bain tiamenté uno. ");
INSERT INTO agd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tiamenté umpo mana vanta ano ma e manten banasi siamen ma séi ída veni kéká uno ma sintí maé mai sen má deren béin nan ída sesi kéká ino sé Tifóe ma inarufá bain tiamenté uno. ");
INSERT INTO agd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ma varará aruvin kusiantan mi sen nan baren eren mino seya siretí ankan ída vá ineno. Téi vaenatin baré eré uno. ");
INSERT INTO agd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Para vara seyo, namuroíin avúavá afoká ino van mi séi eré uno. “‘Banta ano e mantaaren be afóen namuroí intin, be araun mano e mantaaren be anóen namuroí intin, be anafú ano e mantaaren anasi anafú namuroí uantantin ");
INSERT INTO agd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","inká mana vanta ano e mantaaren baéden bei kéká bá namuroi inten mino.’ ");
INSERT INTO agd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Mana vanta ano ma ve anóe afóen nan ma moéken anunuen ma sen nan ma ída moéken anunu inain mai ano ída kanaíen ten bákurinten mino. Inká mana vanta ano ma ve anin nafi ve araun nafi moéken anunuen ma sen nan ma ída moéken anunu inain mai ano ída kanaíen ten bákurinten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Máan tinten mifo iye anó ída vei yaa unkamádan mamaren ná ten tínain dakhafinten nafi mai ano ída kanaíen ten bákurinten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bei aunan ma ákonaen pákakhá inain nanin bantai aunan o afeyoranten mifo sen nan ma iniren bei aunan ma ampin nain nanin banta ano fara van oriyan ban aunan o varanten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tiretí ankan ma avíden ma avábá inain mai vanta ano séin mi sivíden kama inten mino. Téin ma siviran nain banta ano mai ma séin tisintá erikheruna Sifóen mi aviranten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Máan tinten mifo mana vanta ano ma mana sakhanampa vanta aya iran muno ma siren aviren be amápin mo kaúden dafisinten maen mai ma Tiyarafenu ano sakhanampa vanta amiyain miyan mi mai vanta ano varanten mino. Inká mana vanta ano ma mana funtákein banta aya ono van ma avían be amá mo kaúden ma yafisinten maen mai ma funtákein banta kayo ano ma varé iyain miyan mi mai vanta ano varanten mino. ");
INSERT INTO agd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Mana vanta ano sen naro siren ma senti eyo iyampon kayo finte mana aví ída vain doran banta ma kápifin iyon non dáan aminten maen mai séi fura siré tiretin tiamiyá uno. Mai vantai miyan ída afeyoranten mino.” ");
INSERT INTO agd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yisasi ma sirantan kan orun kádan (12) eyo iyampon kayo ma vaya siamiren maen mai varu me ampiren Kariri varafin ma vain baru kayo fimpá nóken banasi afova amiyan Tiyarafenui kama vaya vetin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yoni ma karavusifin baren ma Tiyarafenu ano aní ukhein banta ano ma minó dorarí iyain baya iniren bei eyo iyampon kayo van máa sen Yisasin mo ina ino van tiamemí, ");
INSERT INTO agd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Éi fura sé mai ma Tiyarafenu ano ma aní ukhá ma avé ukhá erúna vanta fono. Áa ena vanta eriyain nará tetí ankan ave ótifan nuno.” ");
INSERT INTO agd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Máa síkan Yisasi evaránen betí ankan tiamemí, “Tiretí ankan ma ma oniyáke ineona vaya vá evaráne ore mo Yonin tiameno: ");
INSERT INTO agd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Auu ma yufúkukhá ein kayo ano evaránen onákan inká arantan ma namu ukhá ein kayo ano e manten orin maen amon dana aí ma vá ein kayo au evaránen kama íkan inká átaren ma kontá ein kayo ano evaránen baya kamaen iníkan maen púká ein kayo ano evaránen e mantákan inká ona ma ída vain nanin banta ano kama vaya inin en mino. ");
INSERT INTO agd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Téin ma soniyantin ma vetíi mumunan ída eravukhan nain kayon Tiyarafenu ano moékan amusin aminten mino.” ");
INSERT INTO agd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yonini eyo iyampon kayo ma orivíkan Yisasi máa sen Yonin nan banasi siamemí, “Tiretí ankan inté ukhein bantá onano vará banta ída van kámá barafá oriyaré fono. Béi ída ákona van ura ano ma kaya einisá iyayá onano van oriyare fono. ");
INSERT INTO agd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Áa náinasá onano vará oriyare fono. Mana vanta ano kama ukhein auí danasá uren bákayá tiretí ankan onano van oniyare fono. Ída ino. Kama auí daná ma ukhein banta kayo ano kin amápin mi váé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Máan té iyan mifo mai fará tiretí ankan oriyare fono. Mana sakhanampa vanta onantasá oriyare fono. Mai fura ino. Téi siretí ankan tiamé uno, mai sakhanampa vanta ano minó sakhanampa vanta esantakhen mino. ");
INSERT INTO agd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mai vanta van mi Tiyarafenui vompon dóki ano máa sikharen mino, “Téi mana vanta siantékun éin an uanten oren eni aa mo uvisinten mino. ");
INSERT INTO agd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Téi fura siré tiretí ankan tiamé uno. Monó non péantan banta Yoni ano minó ma varará ma afoká ukhá ein banta kayo esantakhen mifo inaru yafisimpin ma sitosí ukháin nain manon Yonin esantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Monó non péantan banta Yoni ma kama vaya siyan monó non péantiyaré ein táké ma eren ma saréa varunarái ákona mumunan iyain kéká ano inaru yafisimpin ainen orono van iyákan kokhon banta ano Tiyarafenui yafisin namuroí uantiyan mino. ");
INSERT INTO agd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Para vara seyo, minó sakhanampa vanta kayoi vaya vá man baya vá ano ma afoká inten ne ma sikharé ein danasinta ano Yonintái me kanaíen mino. ");
INSERT INTO agd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tiretí ankan mai van ma mumunan iyanteya mai ma Tiyarafenui vompon dóki ano ma sakhanampa vanta Iraiyan an dakhein banta van ma erinten ne ma sikhá ein mai Yonin nan mi sikharen mino. ");
INSERT INTO agd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Átaren ma van nain kayo ano vá inino. ");
INSERT INTO agd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ma ma saréa ma vain nanin banta van nái yanákasá tiádante rafuno. Iyampon kayo ano ma átaru varurá kumanten ma ena iyampon kayo máa sen areiníi iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Tetí ankan í dano van okhakhan asékuya ompo siretí ankan ída í de ono. Arunan ná baran í déku ompo siretí ankan ída arunaná mádeya ifí de ono.’ ");
INSERT INTO agd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mai fara vara seyo, Yoni ma eriven maen dunan má uvaini non má auraren ída niyákan minó ano siyáken béimpin namu aunan ban mino siyaren mino. ");
INSERT INTO agd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Máa siyaréin ma Banta Anin eriven ma yunan má non má nákan maen minó ano sen, ‘Onano, yunan má uvaini non má béi kokhon niyáken béi tákisi varan banta kéká bá ume vanta kayo vái arona ino.’ Máa siyan mifo Tiyarafenui vaya ánain ma vákuró tifanuna van mi veti afová en pura vayan tiyaren ne sinten mino.” ");
INSERT INTO agd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Manáa varufin Yisasi kokhon enará ukhein danasinta yákó urákan mai varu fintena nanin banta ano ída ará baeriyaimpin Yisasi mai varu finte nanin banta máa sen asemí, ");
INSERT INTO agd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korasiníke nanin banta vá Betsaidake nanin banta va soe, siretí kákan uman uron mi varan nono. Mana vanta ano Taiya vá Saidoni vái varufin oriven máan avúavá daná afoká intin baren betí ankan pefái ará baéden koyan buí daná uren dun akhempá kumanten betíi ume van arunaná baran nainten mino. ");
INSERT INTO agd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Máan tukhái séi siretí ankan tiamé uno. Tiyarafenu ano ma vanasi yaimono van ma aní ukhein damú ma siretimpin afoká inain uman mano Taiya vá Saidoni varu kampin ma afoká ein uman mano esantaren tiretimpin afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tireti Kapeniamú kéka soe, Tiyarafenu ano siretin avirantí inarufá ódinte fono. Ída ino. Tiretí ankan purin nanin bantai varufin námen uron mi aravin nono. Aravin nompo mana vanta ano Sodomú barurá oriven téi ma siretin aúbaná afoká iyaruna yanasinta afoká en baréinti Sodomú baru fara van nainten mino. ");
INSERT INTO agd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Máan tukhái séi siretí ankan tiamé uno. Tiyarafenu ano ma vanasi yaimono van ma aní ukhein damú ma siretimpin afoká inain uman mano Sodomu varufin ma afoká ein uman esantaren tiretimpin afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Maí damú ana Yisasi máa semí, “Tifóe oe, éi inaru vá bara vái Bafan mi van ná ein amo sé uno. Mai fara vara seyo, kama ineine vá afova vá bain banta kayo ano onan nain nan ma aúpasí ukhareya ma iyampon arará kayo an dakhein banta kayo ma aníeona van mi susu sé uno. ");
INSERT INTO agd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pura ino. Tifóe oe, éi ei kama anunu máan dakhafeya máan te ono. Pura.” ");
INSERT INTO agd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Máa sen amúkuren banasi siamemí, “Te Sifóe ano inka minó daná ten tiyampin kaen mifo mana vanta ano ída ve Anin afová ukhan be Afóe ano anan afová ukhen mino. Inká ída mana vanta ano ve Afóen afová ukhen mifo ve Anin mano ma ve Afóen aní ono van aní ukhein nanin banta kayo vá be Anin má ano anan afová ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Uman ma variya nan ma avesara iyain kayo ano vá téi varunafá eresí avíkan ameno. ");
INSERT INTO agd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tiretí ankan ten pintena ma afova mamareya vá tenti vaya aránaopa sá bano. Mai fara vara seyo, séi sirá kusen barará orin avúavá baran bantan baruna sen pinten nan avíkan baran nono. ");
INSERT INTO agd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mai fara vara seyo, ma vaya ma siretí ankan tiamiyaruna vá inká barano van ma amiyaruna uman má ano seso sikhen mino. ");
INSERT INTO agd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mana Sabati yamú Yisasi má bei eyo iyampon kayo vá uíti yunampin oriyaré íkan bei eyo iyampon kayo arafan puríkan uíti ankáden aú puníden nen mino. ");
INSERT INTO agd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Niyákan Farasisi kéká ano ódaren Yisasin tiamemí, “Onano Sabati yamú baran nan airo ananí ukhein danái eni eyo iyampon kayo ano variyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Máa síkan Yisasi evaránen betí ankan tiamemí, “Pefá ma Deviti ma vei kéká bá arafan puríkan ma mantaré ein baya vompon pintena siretí ídá dankáke fono. ");
INSERT INTO agd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deviti ma Tiyarafenu amápin un pében ma ven avorá bereti khauren airo ananí uran ban ma monó doran banta kayo ano ana vá nano sikhá ein ma un máden bei kéká bá nein mino. ");
INSERT INTO agd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Monó doran banta kayo ano Sabati yamú ma monó namumpin doriyá ein mai are ukhein damúi vetí ankan doriyan ída uman bariyaren mifo siretí ankan ídá man bayai vompon dókifin dankáke fono. ");
INSERT INTO agd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Téi siretí ankan tiamiyá uno. Monó namun ma esantakhein daná ano mafin ban mino. ");
INSERT INTO agd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tiyarafenui vompon dóki ano ma sen ‘Ena ma arunan uantan nan mi siranakhen mifo íkun ma uan amin nan ída ino,’ ma sikhein baya kayoi ana ma siretí ankan afová ukhanteya aau ma ída vain nanin banta ída namu ví amin nono. ");
INSERT INTO agd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Para vara seyo, Sabati yamúká ma yafisin ákona Tiyarafenu ano Banta Anin mi amikhen mino.” ");
INSERT INTO agd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yisasi mairá me ampiren oren mai varui monó átaru namumpin ódikan ");
INSERT INTO agd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","maifin mana ayan davénakhein banta varé íkan Farasisi kéká ano Yisasini aau ana yosiren kó tiantano van inaemí, “Sabati yamú tetí ankan kanaisá erá aí banta ayofá tifante rafuno.” ");
INSERT INTO agd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Máa sen ina íkan Yisasi vetin tiamemí, “Tiretin pinté mana vanta ano ma mana sipisipi yesin baren ma Sabati yamú masípin o áduvinti ídá mai finte orun avían kainte fono. ");
INSERT INTO agd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Banta anon moéken sipisipi esantakhein pasé Sabati yamú kasaé aya ó tifanté uno.” ");
INSERT INTO agd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Máa siren béi mai vanta siamemí, “E ayan darurono,” síkan mai vanta ano ve ayan daruriyain má mai ayan evaránen kama uaren ena ufake ayan má manaíen mino. ");
INSERT INTO agd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Máan tíkan mai Farasisi kayo ano ódaren e khuven manápá o iyuven Yisasin ma aruan purin nain aa van dosen mino. ");
INSERT INTO agd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mai ma Farasisi kéká ano véin uman ameno van iyain baya ma Yisasi afová uren mai varu me ampiren oríkan kokhon nanin banta kayo ano véin bákuren oríkan aí ma vain nanin banta minó ayofaan tádein ");
INSERT INTO agd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","beyan nan ída ena siamino van mai nanin banta airo ananí uanten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yisasi ma mai avúavasí ein manon sakhanampa vanta Aisaiyan oo ráké uaren ma Tiyarafenu ano siádan baré ein mi kanaíen mino. ");
INSERT INTO agd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Máan mi sikhan mino, “Ma senti yoran banta séi ma aní ukheruna ino. Téi ven nan moéké tinunu iyákun ten tirápin kákan timusin édaviyan mino. Téi sesi saunan bempin kaékun puntákein avúavá baya varará nanin bantafin tiaminten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Béi ída aran má avádóden baya sen aruven inten mino. Banasifin béi ará kusin má bempáké baya sinten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Banasi ano ma ura an den iyarí ukháin nain béi ída iyanten mino. Inká oon ma yusimono van ein an ma yakháin nain nanin banta véi ída funtiminten mino. Béi yoren oriyan maen puntákein avúavá mo maman dákó inten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Minó barará nanin banta ano ventá mumunan uven béi ayaino van ave inten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Maí damú mana namu aunan mano fákakhan auu yufúkuvin ída vaya siyain banta aviren Yisasi vaintá eríkan mai vanta ano oniyan baya siyan ino van Yisasi mai vanta ayofen mino. ");
INSERT INTO agd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Máan tíkan minó nanin banta ano sakhaen orera iyáken inaemí, “Ma vanta Devitin Anin ná banten nafino.” ");
INSERT INTO agd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Máa sen oreraen mifo Farasisi kayo ano ma mai vaya iniren betí ankan máa semí, “Ma vanta ano minó namu aunan kayoi ánon bantai ákonarái namu aunan kayo yo siantiyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Máa siyákan Yisasi vetí ankani ineinefin afová uren betin tiamemí, “Mana vara ano ma aúban aií uren maná páké kábintin ena fáké kábintin uven ma aruvinten maen mai vara namu inten mino. Inká mana varu finte safi mana má pinte safi ma aúban daíden aruvinten maen mai varu fi mai ma safi ída ákonaen banten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Máan tukhantin Ban Anon mano ma e mantaaren Ban Anon ma yo siantanten maen mai veyan mi aúban daiminten mifo inté uren ná beni yafisin ákona ano fara vanten nafino. ");
INSERT INTO agd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Inká namu aunan kayoi ánon bantai ákonará ma namu aunan kayo yo siantiyákun maen mai iye anó tiretíi kéká ákona amin ná namu aunan kayo yo siantiyan nafino. Máan tukhantin tiretíi kéká anon tireti ma seona vayará aní iyan tiren nan ída funtáka ono sinten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Máan tukhen mifo séin ma Tiyarafenui Aunan mano siyaintí ma namu aunan do siantiyáku maeya mai siretí ankan afová inono, Tiyarafenui yafisin ákona fefái siretimpin e van mino. ");
INSERT INTO agd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Inká intesá uren ná mana ákona vanta amápin mana vanta ano un pében ná beni ona varanten nafino. Mai ákona vantai ona ma varano sinten maen ákona anan póké nare véin damuádaren mi ven amá pintena yanasinta minó baranten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Téin ma namuroí usintiyain nanin banta mai ída sen tirona ino. Inká téin ma ída siyaen banasi avían átaru iyain mai nanin banta anon banasi intanin orera iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Máan tukhái séi siretí ankan tiamiyá uno. Minó ume vá oyampá baya ma sinona vá Tiyarafenu ano ampiantanten mifo Kantá Aunan nan ma oyampá baya sinona mai ume Tiyarafenu ano ída kanaíen ampiantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mana nanin banta ano ma Banta Anin ma oyampá baya sinona ume Tiyarafenu ano ampiantanten mifo Kantá Aunan ma oyampá baya sinona ume saréa fi ínaimpa safi Tiyarafenu ano ída uron mi ampiantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Máan tinten mifo kama yafisirí ma inona yaa ana anon kama aran imádantin inká namu yafisirí ma inona yaa ana anon namu aran imádanten mino. Para vara seyo, inté ukhein daa aná ban nafi mai veni aran ma imádan naintái afová inono. ");
INSERT INTO agd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tiretí ankan namu osafáe akhafana ompo, inté uákeyá namu avúavá ma aúpin bain kéká ano kama vaya sen novara fono. Aúpin ma vain avúavá máan oofente kuvé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kama vanta arápin ma kokhon kama ineine kayo víkakhan ma vain manon kama avúavá baré iyan mifo inká namu vanta arápin ma kokhon namu ineine kayo víkakhan ma vain manon namu avúavá baré iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Máan tukhái siretí ankan tiamé uno. Tiyarafenu ano ma vanasi yaimin nain damúi vanasi ano ma ída funtákein baya ma siyáin nain tian dákó inten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Para vara seyo, Tiyarafenu ano eni vaya kayorá anan kama vaya siyare ono sen inká ída funtákein baya siyare ono sen daiminten mino.” ");
INSERT INTO agd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Máa sirákan manáa man baya ma afová ukhein banta kayo vá Farasisi kéká bá ano máa sen Yisasin tiamemí, “Aru soe, setí ankan ma éin nan Tiyarafenui yorarí iyan mino sen ma inino sinte mae éi mana enará ukhein daná aníesirá oná tifano.” ");
INSERT INTO agd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Máa síkan Yisasi vetí ankan evaránen tiamemí, “Taréa ma vain mai namu avúavá baran nanin banta vá Tiyarafenurá ída ákonaen monó tin nanin banta vá báken ena ena yamú betí aní dana san manan ina iyan mifo vetí ankan ída kanaíen mana aní daná onanten mino. Sakhanampa vanta Yona ma aní ukhein mai aní daná anan betí onanten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Para vara seyo, Yona ma kanú manaú bayan má inuran má ma kákan noyana arápin ma varé einíi en Banta Anin mano kanú manaú bayan má inuran má bara aúpin banten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Máan tinten mifo Tiyarafenu ano ma vanasi yaimin nain damú Ninivéke vanta kayo ano mairá e mantaven maen ma ma saréa vain nanin bantai namu avúavá tian afoká inten mino. Para vara seyo, Yona ma mo vaya sin maen minó Ninivéke nanin banta ano vaya iníden ará baeren mifo siretin aúbanápin mana Yonan esantakhein daná ano e vákaya ída ará baeriya ono. ");
INSERT INTO agd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tiyarafenu ano ma vanasi yaimin nain damú mana sautíke Kuinin mano mairá e mantaven maen ma ma saréa vain nanin bantai namu avúavá tian afoká inten mino. Mai farava ino mai Kuini ano vara akhempa suron mi varen Soromonini kama afova vaya ineno van erein mifo mana Soromonin esantakhein daná ano e van mino. ");
INSERT INTO agd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Namu aunan mano ma mana vanta me ampiren ma vanta i van kámá barafá nóken bei avíkan baru van dosintin ma ída mana kama afokhan bantin maen, ");
INSERT INTO agd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","béi máa sinten mino, ‘Téi ma fefá báeruna namumpin evaráné oronté uno,’ siren o onantin maen mai namumpin ída mana yaná bantin mai namun bakhari uren auí uádantin banten mino. ");
INSERT INTO agd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Máan tukhantin maen béi evaránen oren dan manápá ifo afápá kan un kádan namu uron ukhein namu aunan o avíaren mai namumpin o vantin maen mai vanta ano fefá ma namu avúavá ma variyá ein esantaren moéken namu uró inten mino. Mai ma einí ukhein avúavá anan taréa ma vaona nanin bantafin afoká inten mino.” ");
INSERT INTO agd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yisasi ma mai nanin bantafin para vaya siyan bákan maen be anóen má afá kayo vá ano véin má baya seno van barurá e mantakhen ave ukharen mino. ");
INSERT INTO agd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ave ukhan mana vanta ano Yisasin mun tiamemí, “E anóen má e afá kayo vá ano en má baya seno van barurá e ave ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Máa síkan Yisasi evaránen mai vanta siamemí, “Iye anó te sinóe van ná inká inte kékasá ten tifá tiváeyan ban nafino.” ");
INSERT INTO agd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Máa siren bei eyo iyampon kayo aníen eúkiyan temí, “Onano. Ma se sinóen má te sifá tiváeyan mái van mino. ");
INSERT INTO agd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Para vara seyo, inarufá ma vain Tifóeni anunu ánain ma yakhafiyain mai nanin banta anon ten tifá tiváe, siyofi, sinóe van mino.” ");
INSERT INTO agd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Maí damú ana Yisasi má pinté ekhuven non akharun akhempá o khumanen mino. ");
INSERT INTO agd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kumantaré íkan kokhon nanin banta ano véi vaintá e iyiyaimpin béi e manten botifin un kumamin banasi ano eyurá manten mino. ");
INSERT INTO agd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mantakhan Yisasi kokhon baya o vaédiyan betin tiamemí, “Ineno. Mana vanta ano yunan barafin danayun mo fafaseno van oren mino. ");
INSERT INTO agd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mo fafasen oriyákan maen manáa aasá eravíkan nun kayo ano e aíden nen mino. ");
INSERT INTO agd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Inká manáa yanayun on daró eravuaren bara asamana ukhan ainen e ampamen mino. ");
INSERT INTO agd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ampamen mifo vara ída amákó ukhan amun ída kain námen aravukharéin á kan maen mai yanayun kafuren puren mino. ");
INSERT INTO agd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Inká manáa yanayun ayankun namampin eravukharen e ampamíkan ayankun naman mano úkuan dararen mino. ");
INSERT INTO agd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Inká manáa yanayun mano kama varafin eravukharen e ampamaren aran iren mino. Manáa ano mana antareti (100) iran manáa ano sikhisti (60) iran manáa ano teti (30) iran en mino. ");
INSERT INTO agd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Átaren ma van nain kayo vá inino.” ");
INSERT INTO agd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ínaimpáké bei eyo iyampon kayo ano Yisasi vaintá eriven máa sen inaemí, “Pará éi vaya ovaédiyá banasi siamiya fono.” ");
INSERT INTO agd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Máa síkan Yisasi evaránen betí ankan tiamemí, “Inaru yafisin pintenai aúpá baya ana ma afováin Tiyarafenu ano inka siretin amikhen mifo vetí ankan ída amikhen mino. ");
INSERT INTO agd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tiyarafenui vaya iniren ma kamaen dafisin nain nanin bantai Tiyarafenu ano moékan afova aminten mifo ída ma kamaen dafisin nain nanin banta fintena fefá ma mantáin nain afova vá inan do varanten mino. ");
INSERT INTO agd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ma anarái ovaédé ana vaya siyá uno: “Auu ano oniyan mifo vetí ankan ída mana yaná onanten mino. Átarempó iniyan mifo vetí ankan ída vaya iniren afová inten mino. ");
INSERT INTO agd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mai ma nanin banta ano sakhanampa vanta Aisaiyani vayan pura sen afoká iyan mino. Béi máa sikharen mino, “‘Tiretí ankan kokhon dádá baya inin nompo ída mai vayai ana afová inono. Tiretí ankan kokhon dádá onan nompo ída kanaíeya mana yaná oman afová inono. ");
INSERT INTO agd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Para vara seyo, mai nanin bantai aú ona inka munkin átaren konin maen baya ída inen amúkuven oriyan mifo auu máben onen átarempó baya inen inká áukaké afová uren aú baeren baré intí kasaé betin ayofanté eruna ren mino.’ ");
INSERT INTO agd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Máan tukhen mifo siretin auu ano ma kasaen minó daná onan ma átaren mano ma vaya iniyain nará tiretí ankan amusin ná ono. ");
INSERT INTO agd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Téi fura siré tiretí ankan tiamé uno. Pefá sakhanampa vanta kayo vá puntákein banta kayo vá ano ma ma saréa oniyaona yanasinta onano van iyaren mifo vetí ída ontaren mino. Inká ma ma saréa ma siretí ankan ma iniyaona vaya kayo ineno van ukharen mifo vetí ankan ída inikharen mino. ");
INSERT INTO agd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Banta ano ma yunan barafin ma yanayun pafasintá ma sian baereruna vayai ana vá ineno. ");
INSERT INTO agd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Banasi ano ma inaru yafisini kama vaya ma iniren ma ída mai vayai ana ma afová iyain mai yanayun ma aasá eraveiníi íkan mi Ban Anon mano eriven Tiyarafenui kama vaya ma aúká pafasirein ainen do varé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“On daró ma vain barafin ma eravein danayun kayo mai vanasi ano ma vaya iniren ma mai vaya ainen mamaren ma amusin einíi ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Máan tukhan maen ída arú kain orera uvin amun dan námen aravukharéin mi Tiyarafenui vayará ma ara ara uman ma erin maen ainen eraven ankamé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ayankun namampin ma eravein danayun kayo mai vanasi ano ma vaya iniren ma vara ráke yanasinta vá inká moni san ma in mai avúavá danasinta vá anon Tiyarafenui vaya yaramádan ída aran iré iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Máan té iyan mifo kama varafin ma eravein danayun kayo mai vanasi ano ma vaya iniren mai vayai ana ma afová iyain manon mai mana antaretí (100) aran imádan inká manáa ano sikhisti (60) aran imádan inká manáa ano teti (30) aran imádan é iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yisasi ena vaya máa sen betí ankan tian baéan amen mino. “Inaru yafisin mai máan mi ukhen mino. Mana vanta ano kama uviti ayun bei yunan barafin doren mino. ");
INSERT INTO agd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dóden e vakhan maen beni namuro ano inuran eriven namu káta ayun me mai vanta ano ma uviti yódampin pafasiren oren mino. ");
INSERT INTO agd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Orikharé íkan uviti e ampamíkan maen inká mai namu káta vá deren e ampamen mino. ");
INSERT INTO agd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ampantá íkan doran banta kayo ano eriven dunan afóen máa sen tiamemí, ‘Kákan banta oe, éi kama uviti ayun mi ei yunan barafin pafaseona ifo inté eípasá namu káta maifin pótikhen nafino.’ ");
INSERT INTO agd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Máa síkan béi vetí ankan tiamemí, ‘Mana namuro anon mai avúavasí ukhen mino.’ “Máa síkan doran banta kayo ano véin inaemí, ‘Tetí ankan nan mai namu káta kayo oman daruren manará átaru ino vará anunu iya fono.’ ");
INSERT INTO agd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Máa síkan béi vetin tiamemí, ‘Ída ino. Namu káta yariyá inonafá uviti vá dere yari nona van muno. ");
INSERT INTO agd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Míkanan ma áesin manafin pótikharé intin ma yunan duyasin damusí ma inain mai anon kama ukhen mino. Pótikharé intin ma yuyasin damusí ma intí maé mai yorarí ma inain banta kayo séi máa sé tiamenté uno, ‘Namu káta kayo nare vá ira saran átaru ure ana yamuádare vá inká uviti átaru ure vá tenti yunan kain namumpin bare mo khaono.’” ");
INSERT INTO agd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yisasi ena ovaeran baya máa sen betí ankan tiamemí, “Mastati e sin daa aran ma einíi inaru yafisin mano ukhen mino. Mana vanta ano mastati aran máden bei yunan barafin doren mino. ");
INSERT INTO agd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastati aú maen ída ena yunan aú kayo an den kákaní ukhen mifo sitó aúi vaé iyan mino. Dunan bara finté ma véi e fotiaren maen minó dunan ana esantaren dan mi ódivin nun kayo ano mai yaa ayantá e yomané iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Máa siren Yisasi evaránen ena vaya ovaéden betí ankan tiamemí, “Inaru yafisin mai yisi an mi yakhen mino. Mana nanin mano ma yisi máden kokhon paravampin kakhufaren upí uran ma ínaimpáké mai faravan mano kákantá pamiyainíi ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Minó baya ma Yisasi ano vanasi siamiyaré ein maen mai ovaédiyan manan tiamiyan mifo véi ída mana vaya funtáden tiamiyaren mino. ");
INSERT INTO agd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mai avúavasí ma ein mai fefá mana sakhanampa vanta oo ráké uaren máa sikharen mino, “Téi vaya ovaédiyá anan tiretin tiamenté uno. Pefa suron ma ma vara afoká ein táké ma eriyan baren ma ma sare vaonará ma aúpá baré ein baya máan téi senté uno,” ma sikharé ein mi fura sen afoká en mino. ");
INSERT INTO agd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mairá Yisasi vanasi me ampiren mápin orivíkan beni eyo iyampon kayo ano véi vaintá onóben temí, “Kaná éi mai namu káta ma yunampin ampantá eini ana setin tisimesí inétifante rafuno.” ");
INSERT INTO agd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Máa síkan Yisasi evaránen betí ankan tiamemí, “Kama uviti ayun ma yorein banta maen mai Banta Anin mino. ");
INSERT INTO agd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Dunan bara maen mai ma vara ino. Inká kama uviti ayun maen mai inaru yafisin pintena nanin banta ino. Namu káta maen mai Ban Anoni vanasi ino. ");
INSERT INTO agd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mai ma namu káta ayun ma fafasiyain namuro maen mai Ban Anon mino. Dunan ma yuyasin damú maen mai ma vara ma kípan nain damú ino. Inká dunan duyasin banta kayo maen mai enisori kayo ino. ");
INSERT INTO agd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Banta kayo ano ma namu káta átaru uren ma irafin taman kaureiníi ma vara ma kípan nain damú inten mino. ");
INSERT INTO agd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Banta Anin mano vei enisori kayo siantantin maen beni inaru yafisin pintena umeí ino van ma vanasi akhenóka iyá ein danasinta vá namu avúavá ma variyá ein nanin banta vá do siantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Do siantáden maen mai kéká kákan irafin karúdantin o váken kákantá berai siyan aveantuntá inkekí piyan banten mino. ");
INSERT INTO agd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Máan tiyantin maen puntákein nanin banta ano áau ma kheiníi vetí Afóeni yafisimpin inten mino. Átaren ma van nain kayo ano vá inino.” ");
INSERT INTO agd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yisasi evaránen máa semí, “Mana varafin kokhon kori aúpá baré íkan ma mana vanta ano oneiníi inaru yafisin ukhen mino. Ódaren kákan amusin uren ainen evaránen orein mano vei minó danasinta mo sarí uren moní mamaren mai vara e miyaníen mino.” ");
INSERT INTO agd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yisasi evaránen máa semí, “Ona kokhon bain banta ano ma kama ankaroro kayo van ma yosiyainíi inaru yafisin ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Dosen noren ma mana kama uron ukhein ankaroro váin ma o ódaren maen bei minó ona mo sarí uren moní mamaren mai ankaroro o miyaníen mino.” ");
INSERT INTO agd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Máa siren Yisasi ena ovaeran baya semí, “Base unan ma non akharumpin karúdan aravuvin ma ara ara noyana ma fákiyainíi inaru yafisin ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mai vase unan ma karúdaran noyana kayo víkavin maen noyana arin banta kayo ano orun darifaan akhempá kaúden ma kumanten kama noyana máa aían unan kayofin kauren namu noyana kayo karúdé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ínaimpá ma vara ma kípan nain damú máan manan inten mino. Enisori kayo ano eriven maen kama nanin bantafin ma namu nanin banta kayo ma vain do airanten mino. ");
INSERT INTO agd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Do aíden maen karúdantin kákan ira kiyaimpin o váken kákantá berai siyan aveantuntá inkekí piyan banten mino.” ");
INSERT INTO agd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Máa siren Yisasi vei eyo iyampon kayo inaemí, “Ma ma ovaeran baya kayo ma siamerunai ana inká afová e rafono,” síkan betí ankan “eyo” sen mino. ");
INSERT INTO agd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Máa síkan béi vetí ankan tiamemí, “Máan tukhan mi man baya ma afová ukhein banta kayo ano ma inaru yafisin pintena vaya ma afova amiyain kéká ano kákan namun afóen an mi yakhen ona kain karafarampin un pében maen auyen afova vá peyante afova vá ma kama ukhein baren eré iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yisasi ma mai vaya kayo ovaédiyan tiamíden maen mai varu me ampiren ");
INSERT INTO agd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","bei varu anará oren mino. Oriven betíi monó átaru namumpin ódiven araíen Tiyarafenui vaya vanasi siamiyákan beni vaya iniren takhaen oreraen temí, “Ma vanta ano ma afova vá enará ukhein daná ákona ma maman afokáin má inte fáken ná manten nafino. ");
INSERT INTO agd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Béi mana má uvaran banta anin mi vá tetí afová ukhé uno. Be anóe Marian bákan inká be afá kéká Yemisi, Yosepi, Saimoni, Yudasi siren mino. ");
INSERT INTO agd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Inká minó ben ayofin nái setin má bain mifo inte fákená béi mai ákona manten nafino siren takhaiyan kokhon ineine en mino.” ");
INSERT INTO agd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Máa siren béin ará namu uantiyan maen Yisasi vetí ankan tiamemí, “Sakhanampa vanta aví minó barufá ban mifo veni varu anará bá ben amápin má ída ven aví ban mino.” ");
INSERT INTO agd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Máa siren béintá ída mumunan iyaimpin mai varurá ída kokhon enará ukhein daná afoká en mino. ");
INSERT INTO agd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Maí damú kamanini ánon banta Eroti ano Yisasi ma yoriyain avúavá baya kayo inen mino. ");
INSERT INTO agd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Iniren bei yoran banta kayo máa sen tiamemí, “Monó non péantan banta Yonin purin pinté e mantakhan mai van mi enará ukhein ákona yaná anon béimpin doriyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Pefá Eroti ano ve afá Firipin aná Erodiasin mamaran ma Yoni ano Erotin nan ten ma éi Tiyarafenui man bayan durafure mai nanin bare ono ma sein nan mi Yonin pákaren ayan nan kuan karavusifin kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eroti ano Yonin aruan purono van ukharen mifo mai véi mana sakhanampa vanta ino sen banasi ano afová ukhan mai van mi vetí nan periyaren mino. ");
INSERT INTO agd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Máan tiyá íkan Erotin ma ve anóe khaein damú afoká íkan kákan dunan táden niyan iyukhein aúbaná Erodiasin araun mano mo yanisií íkan Eroti kákan amusin uaren ");
INSERT INTO agd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","béi e manten mai arinta máa sen iyáan ten temí, “Ódino fura sé uno éi nái yanasará inantinte fono séi fara amenté uno.” ");
INSERT INTO agd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Máa síkan be anóe Erodiasi ano véin ákona ineine amirákan mai arinta ano mo Erotin inaemí, “Monó non péantan banta Yonin ánon tíkaan mana yókifin kaúdeya vare me simeno.” ");
INSERT INTO agd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Máa síkan Kin mano mai vaya iníkan ben ará uman den mifo minó banta ma ven má kumanten dunan niyan ma mai kayo avorá ma fura ódino siren ma iyáantákaré ein nan ayave varana e siren bei aruvin banta kayo van mai arinta ano ma seiní ono sen mino. ");
INSERT INTO agd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Máa siren mana aruvin banta siantan karavusifin oren mo síkan Yonin amen tíken mino. ");
INSERT INTO agd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tíkaren mana yókifin ben ánon kauren mai arinta mo amíkan baren be anóen mo amen mino. ");
INSERT INTO agd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Máan turákan Yonini eyo iyampon kayo ano ven au e yaiyen mo masí uren Yisasin mo siamen mino. ");
INSERT INTO agd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yonin ma aruan purin baya Yisasi iníden mai varu me ampiren aúpáké botifin ódiven banta ída van kámá barafá bei eyo iyampon kayo vá ana orivin maen minó nanin banta ano mai ma Yisasi orikheípá afová en iniren betíi varu me ampiriyan barará maifá ana ore ore en mino. ");
INSERT INTO agd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yisasin ma voti ano mo kaúdan maen béi onákan kokhon nanin banta kayo iyukheimpin betin nan arunan uren betíi aí kayo ayofaanten mino. ");
INSERT INTO agd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Máan ten oriyákan inúpasí in eyo iyampon kayo ano Yisasi vaintá eriven máa sen tiamemí, “Ma vanta ída van kámá barafái vá íkan inka yuniríen mifo vanasi siantesin ádé ma vain baru kayo fimpá oriven ná betiyan dunan miyaní ino.” ");
INSERT INTO agd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Máa síkan Yisasi evaránen bei eyo iyampon kayo siamemí, “Betí ankan áesin bantiya siretí ano vá betin dunan amesin ná nano.” ");
INSERT INTO agd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Máa síkan betí ankan evaránen béin tiamemí, “Tetí ankan dan manápá bereti vá kankanan noyana vá anan dáké tiféuno.” ");
INSERT INTO agd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Máa síkan béi semí, “Mai vereti kayo vá noyana vá bare mará me simeno.” ");
INSERT INTO agd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Máa siren banasi van káta yaró kumaneno síkan kumamin béi mai yan manápá bereti vá noyaná kanan má mamaren inarufá kakháben Tiyarafenu susu siantáden kisiren bei eyo iyampon kayo amíkan máden banasi amen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Banasi ano mai vereti kayo vá noyana kayo vá nákan amú kuriyaimpin bei eyo iyampon kayo ano antan o éke e éke uren tiyan míkan mifo sirantan kan orun kádan (12) unan bíken mino. ");
INSERT INTO agd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Anasi iyampon ída yankafen mifo vanta máa ma yankafein mai yan manápá tauseni (5,000) anon nen mino. ");
INSERT INTO agd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mai oyampáké ana Yisasi vei eyo iyampon kayo nare síkan botifin un kumamen betí ankan non e kháden ena ufá oriyákan béi fara váken banasi siantan oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tiantan ma orera uvíkan maen béi amúkono van beyaká anufá óden un bákan inuraníen mino. ");
INSERT INTO agd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bei eyo iyampon kayo ma orein boti ano nenta suron orivin maen auu fáké kákan uva uaren non karantó en mai voti e máden dómeron en mino. ");
INSERT INTO agd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Máan ten oriyan kakhano van iyákan Yisasi vetí ankan baípá non akharun daró oren mino. ");
INSERT INTO agd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bei eyo iyampon kayo ano Yisasin onákan non daró ma orin maen ban mi eriyan mino siren akhokho van báden oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Báden orera iyain má Yisasi ainen betí ankan tiamemí, “Téi umpo siretí ankan ída vá akhokho van iyáke ará kuse vá bano.” ");
INSERT INTO agd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Máa síkan Pita evaránen béin tiamemí, “Bafan noe, éi ma vanteya mai séin tesirá non daró éi vaonafá orono.” ");
INSERT INTO agd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Máa síkan Yisasi semí, “Ereno.” Siyain má Pita voti finté erafuven Yisasin kakháaren non daró oren mino. ");
INSERT INTO agd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Oriyan onákan uva ano ákonaen non karantó eimpin akhokho van iyáken araíen nompin orun periyan oovaren temí, “Bafan noe, siya ono.” ");
INSERT INTO agd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Máa siyain má ana Yisasi ayan dan orin Pitan pákaaren máa sen tiamemí, “Tító mumunan má baona vanta oe! Pará éi ída mumunan e fono.” ");
INSERT INTO agd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Máa siren míkan ma votifin un kumaniyain má uva kípen mino. ");
INSERT INTO agd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kípiyain má mai ma votifin kumantaré ein kéká ano Yisasin aví daníen temí, “Pura uron tireya éi Tiyarafenun Anin mono.” ");
INSERT INTO agd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Máa siren Yisasin má bei eyo iyampon kayo vá non e kháden oriaren maen Kenesaretí akhempá óden mino. ");
INSERT INTO agd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ódiyain má mai akhen páke vanta kayo ano Yisasin afová en óden baya yan orera íkan minó baru fáke nanin banta ano aí kéká aviren béi vaintá eren mino. ");
INSERT INTO agd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Eriven maen Yisasin ínanen inaemí, “Áesin aí kayo ano eni au anamun áton mana aruvino,” siran beni au anamun áton ma aruvein kayo ano asefaen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mairá Yerusaremíké manáa Farasisi kéká bá man baya ma afová ukhein banta kayo vá ano Yisasi vaintá eriven máa sen béin inaemí, ");
INSERT INTO agd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Pará eni eyo iyampon kayo ano sinafu siráoni avúavá durafuren ná dunan ma nanovan ayan nare ída sesé iyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Máa síkan Yisasi vetí ankan evaránen tiamemí, “Mai fará tiretí ankan anafu aráoni avúavá ánain mana vákuriyayá Tiyarafenui man baya yurafuriya rafono. ");
INSERT INTO agd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Para vara seyo, Tiyarafenui vompon dókifin máa sikhen mino, ‘Anóe afóeni aránaopa sá ore vá betin oo vá daiyono.’ Inká ‘Be anóe afóen ma ankayantin nain mano vá purino.’ ");
INSERT INTO agd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Máa sikhen mifo inká tiretí ankan máa seya vanasi afova améiya ono, Banta ano ma ve anóe afóen ma moní ameno van inain mano kasaen Tiyarafenun amiren maen be anoifon máa sen tiaminten mino. En ma ameno seruna moní Tiyarafenun mi amé uno. ");
INSERT INTO agd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Máan ma iyain mai avúavá anon e anóe afóen oo vá daiyono sen Tiyarafenu ano ma sikhein bayan durafúdeya siretíi anafu aráoni avúavá ánain manan bákuriya ono. ");
INSERT INTO agd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tiretí ankan Tiyarafenui vaya ana sireya ída mai ánain dakhafin banta kéká ompo sakhanampa vanta Aisaiya ano siretí ankani avúava san ma siádan baré ein mai fura uron mi sikharen mino. ");
INSERT INTO agd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Ma nanin banta kayo ano oo máa fókéi sen tiví daní iyan mifo vetí ankani ará bá ineine vá ano nenta suron mi van mino. ");
INSERT INTO agd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Betí ankan dan bukhafafói séin monó tisintiyáken barará bantai ineine máa fói vanasi afova amiyan mino.’” ");
INSERT INTO agd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yisasi vanasi aran béi vaintá eríkan máa sen betin tiamemí, “Kamae inire vá ovare me ineno. ");
INSERT INTO agd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nái yaná anó banta oofen ódiaren ná aúpin aravé iyan nafi mai ano ída véin maman painíé iyan mifo nái yaná anó aú pinté édaaren ná oo fenté kuvé iyan nafi mai anon béin maman painíé iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ínaimpáké eyo iyampon kayo ano Yisasi vaintá eriven béin máa sen inaemí, “Éi afová ukhen nan ná Farasisi kéká ano ma ma vaya kayo iniren aran dosé iyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Máa síkan Yisasi evaránen tiamemí, “Inarufá bain Tifóe ano ma ída yókaré inain dunan mai veyantái minó arú bá darinten mino. ");
INSERT INTO agd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Auu yufúkukhein banta kayo ano ma auu yufúkukhein banta ma aa aníen orinten maen minó ano masípin o ádinten mino. Betí ankan auu yufúkukhein kékái váken auu yufúkukhein kayo aa aní ono van mifo vetin mo ampeno. ");
INSERT INTO agd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Máa síkan Pita semí, “Mai ma ovaeran baya ma seona vaya ana setin tisimesí ineno. ");
INSERT INTO agd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yisasi evaránen betin inaemí, “Ma ma ovaéádan baya ana siretin má dere ídá afová iya vae. ");
INSERT INTO agd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Minó daná oofen ma naáden nan arápin aravuaren mi masípin esanten oré iyan mifo siretí ankan ídá mai yaná afová ukhe fono. ");
INSERT INTO agd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Máan tukhen mifo vanta oo fenté ma kuvé iyain mai anon aú bá ineine vá pinté édiyan pasen mi vanta maman painí é iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Banta aú pinte namu ineine kayo vá banta aruan purin má ena ana safi avafun nafi ma varen non avúavá bá pamúku avúavá bá umoyan avúavá bá kópin ma kampun tin má inká ena nanin banta ma namu vaya sen asiyain mái khuvé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Minó mai avúava sinta anon Tiyarafenu avorá banta maman painí é iyan mifo ayan ída seséin ma yunan pákaren niyain mai ano va vanta fainí é iyan naino. Ída ino.” ");
INSERT INTO agd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yisasi mai varu me ampiren Taiya vá Saidoni vái varafá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Oríkan mana Kenaníi anan pinte nanin maifá bain baré íkan béi Yisasi vaintá eriven oovararen temí, “Bafan, Devitin Anin noe, se siraun namu aunan mano fákakhan kákan berai siyan bá umpo sen nan arunan usintano.” ");
INSERT INTO agd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Máa síkan Yisasi ída evaránen mana vaya siyaimpin bei eyo iyampon kayo ano véi vaintá eriven béin ákonaen tiamemí, “Ma nanin mano ínanen oovaren eriyan ban mifo siantan orino.” ");
INSERT INTO agd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Máa síkan béi evaránen mai nanin tiamemí, “Isareri kékái sipisipi kayo ma afeyokein nan manan Tiyarafenu ano séin tisintá erikhé uno.” ");
INSERT INTO agd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Máa siyain má mai nanin mano Yisasini ádé eriven me aron kanan durafúden barafin mátimen temí, “Bafan noe, éi sen tiya ono.” ");
INSERT INTO agd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Máa síkan Yisasi véin evaránen tiamemí, “Iyampon kayoi yunan ma máden betíi iyan kayo ma karúdaan amin mai ída funtáken mino.” ");
INSERT INTO agd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Máa síkan mai nanin mano semí, “Bafan noe, éi fura siya ompo iyan kayo ano vetí afóeni sakhó aránaópá ma yunan antan eravein kasaen né iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yisasi mai vaya iniren evaránen tiamemí, “Anasi oe, éi ákona mumunan mái vaona éi ma afoká ino van ma iyaona mai yaná afoká inten mino.” Máan ma siyain áaurá anan mai nanin araun e asefaen mino. ");
INSERT INTO agd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Máa siren Yisasi mai varu me ampiren Kariri non akhempá oriyan baren mana anu avapá un kumanen mino. ");
INSERT INTO agd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Un kumantan kokhon nanin banta ano véi vaípá eriyáken ai ayan púká ein nafi auu yufúkukhá ein nafi ai ayan ma namu ukhá ein nafi ída ma vaya siyá ein nafi inká ena aí daná ma vá ein kayo vá minó aviren mo ven arantampin aseren orera uran mai kéká ayofen mino. ");
INSERT INTO agd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ayofiyan maen minó nanin banta ano onákan ída ma vaya siyá ein kayo ano vaya síkan ai ayan ma namu ukharé ein kayo evaránen puntarákan arantan ma namu ukharé ein mano e manten oríkan auu ma yufúkukharé ein kayo evaránen onákan iyaimpin banasi ano sakharen kokhon ineine en orera iyáken Isareri kékái Ayarafenun aví daníen mino. ");
INSERT INTO agd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Daní iyákan Yisasi vei eyo iyampon kayo aran eríkan máa sen tiamemí, “Ma nanin banta maen dunan ída nan kanú manaú damúi sen má baká betin nan tirunan iyá umpo arafan bantí ma siantan oriyaren ayanafá auu entave entave intin eraven ankaminten mino.” ");
INSERT INTO agd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Máa síkan eyo iyampon kayo ano véin tiamemí, “Ma vanta ída van kámá barafá ifo inte fáken ná minó ano kanaíen ma naren bereti kayo máderá máan nanin banta amenté tiferafuno.” ");
INSERT INTO agd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Máa síkan Yisasi evaránen betí ankan inaémi, “Nái máa veretí tiretí ankan dáke fono.” Máa sen ina íkan betí ankan temí, “Dan manápá ifo afápá kan un kádan bereti vá manáa sitó noyana kayo vái van mino.” ");
INSERT INTO agd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Máa síkan Yisasi mai nanin banta van barará kumaneno síkan kumanen mino. ");
INSERT INTO agd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kumamíkan béi mai yan manápá ifo afápá kan un kádan bereti vá noyana kayo vá máden Tiyarafenu susu siantáden kisiren bei eyo iyampon kayo amíkan máden banasi amen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Amíkan minó nanin banta ano nákan amú kuriyaimpin eyo iyampon kayo ano antan o éke e éken uan dan manápá ifo afápá kan un kádan unan báen mino. ");
INSERT INTO agd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mai yunan ma nein mai kamí kamí tauseni (4,000) vanta ifo anasi iyampon ída yankafen mino. ");
INSERT INTO agd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Narákan Yisasi mai nanin banta siantan orivin maen botifin un kumamen Makhadaníi akhempá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farasisi kayo vá Sadyusi kéká bá ano Yisasi vaintá eriven béin akhenóka uan onano van inaru fáke mana aní daná aní intí onano van béin inaen mino. ");
INSERT INTO agd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ina íkan Yisasi evaránen betí ankan máa sen tiamemí, “Inupasí íkan ma ayontá ma nararé íka maeyan inuran afe inten mino séiya ono. ");
INSERT INTO agd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Inká ákurá ma onen nan ma sókon konan ma yampa maeya saréa uva intin á danten minon téiya ono. Ayontá ma afoká ein avúavá tiretí ankan ódeyan daíde afová éiya ompo saréa ma afoká iyain danasinta siretí ída yaimiya ono. ");
INSERT INTO agd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Taréa ma vain mai namu avúavá baran nanin banta vá Tiyarafenurá ída ákonaen monó tin nanin bantan báken ena ena aní daná aní intí onano van manan iyan ban mifo vetí ankan ída kanaíen mana aní daná onanten mino. Aní daná ma mana vetí onan nain mai sakhanampa vanta Yonani aní daná ana ino,” siren Yisasi vetin me ampiren oren mino. ");
INSERT INTO agd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yisasi vei eyo iyampon kayo vá non akharun ekháden ena ufá oriyákan beni eyo iyampon kayo ano á úden ída vereti varen mino. ");
INSERT INTO agd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Oriven Yisasi máa sen betí ankan tiamemí, “Farasisi kayo vá Sadyusi kéká bái yisi vará dafían ná ákona ono.” ");
INSERT INTO agd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Máa síkan beni eyo iyampon kayo ano vetiyan máa sen oreraemí, “Tetí ankan ma ída vereti varé erikheruna van mi véi mai vaya sen mino.” ");
INSERT INTO agd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Betí ankan ma siyain baya Yisasi afová uren máa sen betin tiamemí, “Titó mumunan bain kéka soe, fará tiretí ma vereti ída manteona van baya siya rafono. ");
INSERT INTO agd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tiretí ankan ídá afová ukhe fono. Dan manápá tauseni (5,000) vanta ano ma yan manápá bereti nara maeya antan dunan nái máa unan ná bíke fono. ");
INSERT INTO agd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Inká dan manápá ifo afápá kan un kádan bereti ma kamí kamí tauseni (4,000) vanta ano ma nara maeya antan dunan nái máa unan ná bike fono. ");
INSERT INTO agd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Téi ída vereti van tiamiyá umpo fará tiretí ída afová iya rafono. Farasisi kayo vá Sadyusi kéká bái yisirá dafían ákona ono van mi séi siamiyá uno.” ");
INSERT INTO agd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Máa síkan betí ankan iniren afová uren temí, “Béi ída veretifin ma kain yisi van tiyan mifo mai Farasisi kayo vá Sadyusi kéká bái kampun afova ma amiyain bayará dafíben bano van mi siyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yisasi ma Sisariá Piripai kayoi varafin ma oriven maen máa sen bei eyo iyampon kayorá inaemí, “Banta Anin nan banasi ano iye inó ten iniyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Máa síkan betí ankan temí, “Manáa ano éi nan monó non péantan banta Yoni ino sin maen ena kéká ano Iraiya ino siyákan inká manáa ano sakhanampa vanta Yeremaiya fi áa mana ena sakhanampa vantafin banten mino siyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Máa síkan Yisasi vetí ankan inaemí, “Mai siretí ankan te nan iye inó té iniya rafono.” ");
INSERT INTO agd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Máa síkan Saimon Pita evaránen temí, “Tiyarafenu ano ma aní ukhein bantan éi váke ayun para van oriyan ma vain Tiyarafenu Anin mono.” ");
INSERT INTO agd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Máa síkan Yisasi evaránen béin tiamemí, “Yonin anin Saimoni oe, éi amusin ná ono éin ída mana varará banta ano ma vaya aníen mifo inarurá ma sen Tifóe vain manon aní uanten mino. ");
INSERT INTO agd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Aní uantákái séi máa sé éin tiamé uno. Éi Pitan ban ná mai onámaná darói sesi vanasi ma mumunan iyain kéká o éke e éke uré átaru uan kaúdékun mai ma furin nanin banta ma o iyiyain barui ákona ano ída kanaíen mai kéká esantaren maman bararasí inten mino. ");
INSERT INTO agd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Inaru yafisin pintena ki kayo séi minó éin amenté umpo éi nái yanasá ma varará pákaan ákona intefo mai inarurá bá pákaan ákona inten mino. Pákaan ákona inten mifo éi ma ma varará ampinona yanasintan mai inarurá bá ampiantanten mino.” ");
INSERT INTO agd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Máa siren Yisasi veyan nan Tiyarafenu ano ma aní ukhein banta ino sen ena nanin banta ída siamino van bei eyo iyampon kayo airo ananí uanten mino. ");
INSERT INTO agd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mai ráké ma Yisasi e manten Yerusaremí orintin ma ven aurá afoká inain daná máa vei eyo iyampon kayo siamen mino. Ánon banta kéká bá monó ánon banta kayo vá man baya ma afová ukhein banta kayo vá ayampin ma orintin béin pákaren namu arirí uren kamanini aruvin banta kéká ayampin kaintin aruan púdantin ma kanú manaú damusí intin maen evaránen aunan baren e mantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita mai vaya iniren Yisasin aviren akhempá moren béin ákonaen asemí, “Bafan noe, Tiyarafenu ano ída vá áintin ma yaná ano en aurá afoká ino.” ");
INSERT INTO agd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Máa síkan Yisasi yo vaéaren Pitan nan temí, “Ban Anon noe, soyampá entavono. Éi senti aan iyariya ono. Éi ída Tiyarafenui ineine ánain dakhafiya ompo varará bantai ineine ánain mi yakhafiya ono.” ");
INSERT INTO agd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Máa siren Yisasi vei eyo iyampon kayo máa sen tiamemí, “Mana vanta ano ma sen tínain bákurono ma sinten ná bei anunu ampintin barará erafuvintin ná bei yaa unkamádan mamaren ná ten tínain bákurino. ");
INSERT INTO agd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mai fara vara seyo, mana vanta ano ma vei aunan pákaan ákona ukharé intin maen mai veni aunan o afeyoranten mifo mana vanta ano ma se nan iniren ma vei aunan ampiádákaren maen mai ano vei aunan evaránen baranten mino. ");
INSERT INTO agd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mana vanta ano ma minó ma vara ráke yanasinta ana ma variyá intin ma veni aunan ma o afeyorantin maen intesá uren ná mai minó danasinta ano véin aya inten nafino. Intéa yaná pókesá banta ano evaránen bei aunan miyaní inten nafino. ");
INSERT INTO agd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Para vara seyo, Banta Anin mano ma ve Afóeni kákan kakhan má bei enisori kayo vá ma erin nain maí damúi vanasi ano ma variyá inona avúaváká ten mi yaíden mana mana miyan aminten mino. ");
INSERT INTO agd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Téi fura siré tiretí ankan tiamé uno. Ma ma saréa ma mantakheona kéká pinté ída manáa ano fúkesin mi Banta Anin mano kin an daven erinti onan nono.” ");
INSERT INTO agd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dan manápá ifo afápá mana un kádan damú orivíkan Yisasi ano Pitan má Yemisin nú Yonin nú anavasan má avíaren mana ayá anurá un baren mino. ");
INSERT INTO agd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Un baren betí ankan onákan Yisasin au ano enará iyain má ben auná ano áau ma kheiní íkan beni auí daná ano efanten uron en mino. ");
INSERT INTO agd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Máan tiyain má Mosesin nú Iraiya nú ano mairá afoká uven Yisasin má baya siyákan betí onen mino. ");
INSERT INTO agd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ódaren Pita máa sen Yisasin tiamemí, “Bafan noe, setí ankan ma mará banuna mai kama ukhen mifo éi iniresirá iyon baran namun kanú manaú téi uvarano. Mana en nina vantin mana Mosesin nina vantin inká ena Iraiyan nina vantin ino.” ");
INSERT INTO agd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita ma fara vaya siyákan maen mana fanu sikhein konan mano vetí ankan úkuan daran má darákan mai konan pinté mana vaya ano máa semí, “Ma sen Tanin mino. Téi ve nan moeké tinunu iyá uno. Téi venan timusin iyá uno. Ben avaya vá ineno!” ");
INSERT INTO agd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mai vaya ma vetí ankan iníden akhokho van iyan barará baven auná bara finíen mino. ");
INSERT INTO agd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Máan tiyákan Yisasi vetíi ádé eriven au aruviyáken temí, “Tiretí ankan ída vá akhokho van eya orun mantano.” ");
INSERT INTO agd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Máa síkan betí ankan orun mantaven onákan Yisasi má ída mana ano van beya ana varen mino. ");
INSERT INTO agd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Betí ankan ma anuyon me ampiren eriyákan maen Yisasi ákonaen betín tiamemí, “Ma yaná ma siretí ankan oneona mai ída vá mana nanin banta siamikhesin ná Banta Anin ma van oriyan ma fúaren purin pinté e mantavinti vá tiameno.” ");
INSERT INTO agd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Máa síkan eyo iyampon kayo ano véin inaemí, “Paraé tiren ná man baya ma afová ukhein banta kayo ano Iraiyan nare vá erivintin ná ino sé iyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Máa sen ina íkan béi evaránen temí, “Mai fura vaya ino. Iraiya eriven minó daná evaránen puntáádanten mino. ");
INSERT INTO agd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Puntáádanten mifo séi siretin tiamé uno. Iraiya fefái erikhan minó nanin banta ano ída véin afová en pasen betíi anunu ánain dakhafen béin aurá ara ara namu avúavasíen mino. Máan avúavá anan Banta Anin aurá inten mino.” ");
INSERT INTO agd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yisasi ma máa siyákan maen betí ankan afová en monó non péantan banta Yoni van mi siyan mantino sen inen mino. ");
INSERT INTO agd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Betí ankan ma vanasi vaintá erákan maen mana vanta ano Yisasi vaintá me aron kanan durafúden mátimen temí, ");
INSERT INTO agd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Bafan noe, éi sen tanin nan arunan uantano. Béi auvayaní uaren kokhon damú irafin kákiyan non ádiyan iyá uno. ");
INSERT INTO agd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ei eyo iyampon kayo vaípá avían morékun maen betí ankan ída kanaíen béin ayofaríen mino.” ");
INSERT INTO agd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Máa síkan Yisasi evaránen tiamemí, “Tiretí ankan ída mumunan ukheona nanin bantan banan mi siretíi ineine vá avúavá bá ída funtáken mino. Nái máa yamusá téi siretin má para vante rafuno. Nái máa yádasá téi siretíi uman evaráné bariyá bante rafuno. Mai iyampon avire séi varunará ereno.” ");
INSERT INTO agd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Máa síkan mai iyampon avían meran Yisasi mai namu aunan ákonaen asiyain má me ampiren orivíkan beni aí kípen mino. ");
INSERT INTO agd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Máan turákan ínaimpáké beni eyo iyampon kayo ano ana aúpáké béi vaintá eriven inaemí, “Pará tetí ankan ída kanaíé namu aunan do siantiya rafuno.” ");
INSERT INTO agd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Máa síkan béi evaránen betí ankan tiamemí, “Tiretíi mumunan tító máan bákayai ída kanaí iya ono. Téi fura siré tiretin tiamiyá uno. Para vara seyo, siretíi mumunan mano ma mastati yaa aran aú an den ma sító suron ma vantiya mai siretí kanaíeya ma anuyon nan ma mesapá e afáne orono ma sesin maen orinten mino. Máan tiyasin maen mana yaná ano siretimpin ída kanaíen uman danten mino. ");
INSERT INTO agd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Betí ankan ma Karirí barafá o átaru uvin maen Yisasi máa sen betin tiamemí, “Banta Anin avían namuro kayo ayampin aminten mino. ");
INSERT INTO agd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Amirantin ma véin arintin púkaren maen kanú manaú damusí ma intin e mantanten mino,” síkan eyo iyampon kayo ano mai vaya iniren arunan en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ínaimpáké Yisasin má bei eyo iyampon kayo vá ano Kapeniamú barurá onóbíkan monó namun ma ayain moní ma varan banta kéká ano eren me Pitan máa sen inaemí, “Tiretíi arú ano kákan monó namun ma ayain moní amé iyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Máa sen ina íkan Pita evaránen temí, “Eyo amé iyan mino.” Máa siren ma Pita mápin un pében ída vaya sikhan maen Yisasin nare véin inaemí, “Saimoni oe, éi inte é teyá iniya fono. Ma vara ráke kin kayo ano ara ara sákisi iyen pinten ná baré iyan nafino. Betíi kéká pinten ná baré iyan nafi áa ena kéká pinten ná baré iyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Máa sen ina íkan Pita evaránen temí, “Ena kéká pinten nan baré iyan mino,” síkan Yisasi véin tiamemí, “Máan tukhan mi vetíi kéká ano ída vetíi sakisi amé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Máan té iyan mifo vetin aran amétifa nampo araveya vá morun non akharumpin úku karúdareya esé ma arinona noyana oo yavódeya vá mai oofentena ma onanona monisá bareya kákan monó namun ma ayain ná erasantina mun ameno,” síkan mai ma seiní uren bare mun amen mino. ");
INSERT INTO agd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Maí damú eyo iyampon kayo ano Yisasi vaintá eriven máa sen inaemí, “Inaru yafisimpin iyé kákaní inten nafino.” ");
INSERT INTO agd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Máa síkan Yisasi mana arará iyampon aran eríkan betin aúbaná avían manten mino. ");
INSERT INTO agd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Avían mantaren máa semí, “Téi fura siré tiretin tiamiyá uno. Tiretí ma ída evaráne arará iyampon kayo an ma yanteya mai ída kanaíeya inaru yafisimpin orin nono. ");
INSERT INTO agd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Máan tukhantin mi iye anó beyan maman bararasí uren ná ma iyampon arará an ma yiyaré inain manon inaru yafisimpin kákaní inten mino. ");
INSERT INTO agd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Inká iyé ten nan iniren ná mana máan tukhein iyampon arará aya inten nafi mai sen mi siya inten mino. ");
INSERT INTO agd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Máan tinten mifo ma iyampon arará kayo finté mana ano ma sentá mumunan ukharé intin ma mana vanta ano ma vetin maman umefin kaintin ma eraven ankantaré intin ínaimpá mai vanta moékan uman baran nafo véin amempin ná kákan konkamú onámaná kureya vá un nompin karúdan námen aravuven ná non ufuren purino. ");
INSERT INTO agd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Intéa vanta anó ena kayo e yarifaan umefin kain ná eraven ankamiyan nafi mai kayo ano kákan uman uron mi varanten mino. Mai namu avúavá afoká inten mifo iyen banta fintesá mai yaná afoká inten nafi mai anon kákan uman uron baranten mino. ");
INSERT INTO agd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Éin ayan arantan mano ma e yarifaan umefin ma kaintiya vá mai yo síkareya karúdan ná orino. Mana ayan má mana arantan má ana ma varéintiya mai ída furin ayun ma van oriyan ban aunan baran nono. Míkanan ayan má arantan má ma vantiya ma umeí ukharé inte mae mai ída kípan irafin mi karúdanti orin nono. ");
INSERT INTO agd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Éin auu ano ma e yarifaan umefin ma kaintiya vá mai auu yo vían karúdan ná orino. Mana auu ana ma varéintiya mai ída furin ayun ma van oriyan ban aunan baran nono. Míkanan auu ma vantiya ma umeí ukharé inte mae mai ma íra khiyan ma uman baren berai siyan purin barufin mi karúdanti aravin nono. ");
INSERT INTO agd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Ma arará kayo fintena siretí ankan oman tító danasí inampo yafían ná ákona ono. Inaru fáké betíi enisori kayo ano ena ena inarufá ma vain Tifóen avorái váé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Tiretí ankan inte esá té iniya rafono. Mana vanta ano ma mana antareti sipisipi yakaré intin mai fintena ma mana afeyóbintin maen mai van ídá dosinten nafino. Ídá nainti naini (99) me khaintin anurá bantin ná mai mana sipisipi ma afeyókein nan dosinten nafino. ");
INSERT INTO agd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Dosiren ma avíaren mai mana sipisipi van ma amusin inain manon nainti naini (99) sipisipi ma ída afeyoran para vain nan ma amusin inain esantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Máan manan en tiretí Afóe ma inarufá bain mano ma arará kayo fintena ída mana afeyorano van inikhen mino. ");
INSERT INTO agd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mumunan ayofi afá aváe ano ma en nina yaná ma auí uran tiya vá éi vempákesá béin o avíde vá beni namu avúava san tiamíde aúpasá tirékan puntarano. Puntaresin ma eni vaya ma véi ininti mae vá mai éi ei mumunan afá aváen mi evaráne avire ono. ");
INSERT INTO agd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aviran nompo véi ma eni vaya idá ininti mae vá “mana vanta fi kan banta fi avíareya oresin ná kan mano fi kanú manaú ano fi vá mai vaya mo iníden puntarano.” ");
INSERT INTO agd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Máan tesi ma véi ída vetíi vaya ma inintiya vá mumunan nanin banta siamesin ná mai vaya iniren puntarano. Puntarantin ma ída inintiya vá mai véin maman ída mumunan bain banta kayo vá takisi varan banta kéká bá an dakhen mino vá tire onano. ");
INSERT INTO agd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Téi fura siré tiretí ankan tiamé uno. Inte yanasá ma varará pákaan ákona intefo mai inarurá bá pákaan ákona inten mifo éi ma ma varará ampinona yanasintan mai inarurá bá ampiantanten mino.” ");
INSERT INTO agd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Téi evaráné tiretin tiamé uno. Ma varará ma kan mano ma mana yaná barano van ma ará manafiní ureya ma amúkesin maen te Sifóe ma inarufá bain mano siré kanan aminten mino. ");
INSERT INTO agd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Para vara seyo, kan nafi kanú manaú ano fi ma sen tivíká ma átaru intí maé mai séi vetin aúban banté uno.” ");
INSERT INTO agd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mairá Pita eriven Yisasin máa sen inaemí, “Bafan noe, sifá tiváe ano ma auí usintádantí maé mai nái máa yádasá béin tirá amente rafuno. Dan manápá ifo afápá kan un kádan dádasa fino.” ");
INSERT INTO agd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Máa síkan Yisasi evaránen béin tiamemí, “Téi ída seveni yáda se sé éin tiamikhé uno seventi taims seveni (70 x 7) yáda sen tikhé uno. ");
INSERT INTO agd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Máan tukhein nan mi mana kin pintena ma vei yoran banta kéká ano ma manáa moní mantáin ma evaránen barano van ma funtaré iyainíi inaru yafisin ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tiyan míkan mirioni moní ma mantaré ein banta nare funtarano van béi vaintá aviren eren mino. ");
INSERT INTO agd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Meran mai vanta ano ída kanaíen mai moní evaránen amiyaimpin kin mano vei yoran banta siamemí, ‘Ma vanta vá be aná akhá bá bei minó danasinta vá sarí uresin miyaní uaranti vá tesi moní máa ovaráne simeno.’ ");
INSERT INTO agd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Mai yoran banta ano ma mai vaya iniren kin arantampin mo aron kan durafúden mátimen ínanen inaemí, ‘Éi se nan arunan usintádeya sive ukhesirá éin pinte ma mantáeruna moní máa evaráné anona ameno.’ ");
INSERT INTO agd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Máa síkan mai kin mano vei yoran banta van arunan uantáden ifáin oren mino. ");
INSERT INTO agd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ifá uantádan mai yoran banta ano e khuven barufá aravuven onákan bei mana yoran banta eríkan ben amen bana oo fákaan ákona uaren máa sen tiamemí, ‘Éi ma sen pinte mantaré eona moní máa anona aine simeno.’ ");
INSERT INTO agd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Máa síkan bei mana yoran banta ano mai vaya iniren aron kan durafúden mátimen ínanen inaemí, ‘Éi se nan arunan usintádeya sive ukhesirá éin pinte ma mantáeruna moní máa evaráné anona ameno.’ ");
INSERT INTO agd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Máa síkan maen mai vanta ano ída inin na vei mana yoran banta aviren mo karavusifin kaurantin báken bei moní evaránen anona amino van karavusifin mo khaen mino. ");
INSERT INTO agd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Minó bei mana yoran banta kéká ano véi ma varein avúavá ódaren kákantá ará namu uren mai vaya kin mo siamen mino. ");
INSERT INTO agd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Mo siamíkan kin mano mai yoran banta aran eríkan máa sen béin tiamemí, ‘Éi namu yoran banta ono. Éi ínane séi vaípá inaen ná maéi éi ma mantaré eona moní máa mo ifá uanté uno. ");
INSERT INTO agd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Téi ma en nan tirunan uanterunaí eya éi fará ei mana yoran banta van ída arunan uante fono.’ ");
INSERT INTO agd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Máa siren kin mano aran má tíkan karavusirá ma yafisin banta kéká ano mai yoran banta e fáken mo khaintin báken béin pinte ma mantaré ein moní máa anona evaránen amino van en mino. ");
INSERT INTO agd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Tiretí ankan ma mununan afá aváeyan má ayó má bái ume ma ída fura seya aúkáké ampiantiyaré esin maen te Sifóe ma inarufá bain mano mai avúavasí anan tiretin uantanten mino.” ");
INSERT INTO agd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yisasi ma mai vaya kayo sian kíparen Karirí bara me ampiren e manten Yodení non e kháden Yudiá barafá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Oríkan kokhon nanin banta ano ven bákuren orin maifin ma aí bá ein kéká ayofen mino. ");
INSERT INTO agd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ayofiyákan Farasisi kéká ano Yisasi vaintá eriven béin mákáan onano van betí ankan máa sen ben inaemí, “Éi inte esá té iniya fono. Man baya ano kanaé tikhan ná banta ano vei anunurá be aná tiantanten nafino.” ");
INSERT INTO agd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Máa síkan Yisasi evaránen betin tiamemí, “Tiyarafenu ano esé araíintá ma vanta vá anasi vá ma uvantá ein tiretí ankan ídá bompon dókifin dankádé afová ukhe fono. ");
INSERT INTO agd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘Mai van mi vanta ano ve anóe afóen me ampiren be aná bá o súpá en mana vukhafaí é iyan mino.’ ");
INSERT INTO agd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Máan tukhein nan mi míkánan ída kanaí ukhen mifo mana vukhafaíi ukhen mino. Mai van mi Tiyarafenu ano ma vékan maman túpá uran nain banta ano ída yurafurinten mino.” ");
INSERT INTO agd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Máa síkan Farasisi kéká ano véin evaránen inaemí, “Pará Mosesini man baya ano sen ná banta ano vá bompon uvaman e aná amídeya vá tiantano sikhen nafino.” ");
INSERT INTO agd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Máa síkan Yisasi evaránen betí ankan tiamemí, “Tireti aú avétan in kékái vanan mi Mosesi kana ino sikhaya anasi siantiyare ompo esé araíintá ída mai avúavá baren mino. ");
INSERT INTO agd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Téi siretí ankan tiamiyá uno. Mana vanta aná ano ma ída ena vanta yarifen non nain ma véin tiantáden ma ena nanin baranten maen mai vanta ano ena ana safi avafun nafi ma vare non avúavái varen mino.” ");
INSERT INTO agd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Máa síkan eyo iyampon kayo ano mai vaya iniren Yisasin tiamemí, “Tiyarafenu ma esé araíintá ma sikhá ein baya ánain dakhafin ma uman dakhantin maen mai vanasi ano ída vá ábusuí ino.” ");
INSERT INTO agd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yisasi evaránen betí ankan máa sen tiamemí, “Ída minó ano ma vaya kanaíen ininten mifo Tiyarafenu ano ma manáa nanin banta ákona amikhein mai kayo ano anan mai vaya ánain dakhafinten mino. ");
INSERT INTO agd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Para vara seyo, manáa iyampon avankan namu ukhein kaé iyan mino. Inká manáa vanta ano avankan do visiyan maen inká manáa ano inaru yafisin pintena yorarí ono van anasi varan airo ananí uren báé iyan mino. Máan tukhen mifo vanta ano ma ma vaya kanaíen ma inin nain mano vá mai ánain dakhafino.” ");
INSERT INTO agd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Máa sirákan Yisasi ayan ánontá kaúden amúkuantano van banasi ano arará iyampon arinta aviren eríkan maen eyo iyampon kayo ano vetí ankan ákonaen asen mino. ");
INSERT INTO agd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Asiyaimpin Yisasi máa semí, “Tiretí ankan áesin ná arará iyampon arinta se vaípá erino. Tiretí ída vá betin ayópá ono inaru yafisin mai arará iyampon arinta kayo an ma yákein nanin banta ina ino.” ");
INSERT INTO agd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Máa siren iyampon arinta ánontá ma véi ayan kaúden avu uantáden maen mai varu me ampiren oren mino. ");
INSERT INTO agd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Oríkan mana vanta ano Yisasi vaintá eriven temí, “Aru soe, séi inte avúavasá kama urerá ayun ma fara van oriyan ban aunan barante rafuno.” ");
INSERT INTO agd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Máa síkan Yisasi evaránen béin tiamemí, “Pará kama avúava sinta van téin ina iya fono. Tiyarafenu veyáká anan kama ukhen mifo éi ma ayun para van oriyan ban aunan ma varano sinte vá Tiyarafenui man baya kayo ánain ná dakhafono.” ");
INSERT INTO agd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Máa síkan mai vanta ano Yisasin inaemí, “Inte man baya kayo vará éi siya fono.” Síkan Yisasi evaránen béin tiamemí, “Máan ma sikhein man baya kayo van mi siyá uno. ‘Tiretí ankan ída vá ena nanin banta aruan purono.’ ‘E ábasu ano ída vá ena ana safi avafun nafi vare nono.’ ‘Tiretí ída vá umoyan barano.’ ‘Tiretí ída vá kampun tireya ena nanin banta kó tiantano.’ ");
INSERT INTO agd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘Tiretí ankan anóe afóeni aránaopa sá oreya vetin oo vá daiyono.’ Inká ‘eyan nan ma anunu iyaonaíe vá ena van anunu ono.’” ");
INSERT INTO agd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Máa síkan mai fumara ano semí, “Téi minó mai man baya kayo ánain dakhafiyá umpo mai ena inte man baya ánain ná dakhafonte rafuno.” ");
INSERT INTO agd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Máa síkan Yisasi evaránen béin tiamemí, “Éi ma funtákeiní uron ma ono vará minó ei ona mo sarí ure vá ona ma ída van nanin banta vá mai moní ameno. Éi ma máan tinteya enina inarurá kokhon kama yana suron banten mifo éi ere sen bákurono.” ");
INSERT INTO agd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Máa síkan mai fumara ano kokhon ona yákaren pasen mai vaya iniren anomé inivaen ifá en oren mino. ");
INSERT INTO agd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Orivíkan Yisasi vei eyo iyampon kayo máa sen tiamemí, “Téi fura siré tiretin tiamé uno. Kokhon ona ma vain banta kayo ano ma inaru yafisimpin ma orin mai uman dakhen mino. ");
INSERT INTO agd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Téi enádá bá evaráné tiretin tiamenté uno. Kameri ano ma ufi aimpin ma ódin mai uman dakhen mifo kokhon ona ma yákein kéká ano ma Tiyarafenui yafisin barufin ma ódin mai moéken uman mi yakhen mino.” ");
INSERT INTO agd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Máa síkan eyo iyampon kayo ano mai vaya iniren anúden oreraen temí, “Máan ma ukhantin maen mai iye ná Tiyarafenu ano kanaíen aviranten nafino.” ");
INSERT INTO agd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Máa síkan Yisasi vetin auufen kakháben temí, “Minó banta ano ída kanaí inten mifo Tiyarafenu ano veyáká anan kanaíen minó danasí inten mino.” ");
INSERT INTO agd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Máa síkan Pita evaránen temí, “Ineno minó daná teti me ampiré éin bákuriyá umpo mai setí ankan ena nái yanasá bará tifante rafuno.” ");
INSERT INTO agd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Máa síkan Yisasi evaránen betin tiamemí, “Téi fura siré tiamiyá uno. Ínaimpá ma minó daná ma auyení uvintin maen Banta Anin mano ma kákan bí mamaren bei kin karáká ma kumanin nain damúi sen tínain ma vákure nóinona vanta kéká ano sirantan kan orun kádan (12) kama ukhein kini karáká kumameya sirantan kan orun kádan (12) Isareri anantá dafisin nono. ");
INSERT INTO agd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Inte kéká anó ten tivi san iniren ná be ama safi afá aváen nafi ayofin nafi ve anóe afóen nafi inká be akhafana fi yunan ana fi ma me ampikharéin nain kéká anon ena antareti yádá bá (100) máden inká ayun ma fara van oriyan ban aunan má baranten mino. ");
INSERT INTO agd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Baranten mifo saréa ma esé an ma vain kayo ano ínainí intin maen anona ínain ma vain kéká ano un aní inten mino. ");
INSERT INTO agd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Para vara seyo, inaru yafisin mai máan mi ukhen mino. Mana vanta ano vei uvaini yuna anafin dorano van banta kayo avirano van pe ákurá e manten oren mino. ");
INSERT INTO agd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mai vanta kayo van maná damúke na miyan amenté uno síkan kana ino sin betin tiantan uvaini yunampin dorantá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Nain kiroki inafá mai kákan banta ano oriyaren o onákan banasi ma átaruiyain barurá manáa vanta kéká ano fara mantakhen baren mino. ");
INSERT INTO agd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mantakharé íkan béi máa sen betin tiamemí, “Tiretí ankan má dere oreya senti uvaini yunan anafin mo yoriyaréesí maé puntádé miyan amenté uno. ");
INSERT INTO agd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Máa sin mai kéká orivíkan mai kákan banta ano vayan bero vá inúpá kanú manaú áaurá bá evaránen máan mana en mino. ");
INSERT INTO agd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Inúpáké dan manápá áaurá béi oriyaren o onákan manáa vanta kayo fara mantakhen baré íkan béi máa sen betí ankan inaemí, ‘Náisá ukhayá ma áau ayá ayá pasavi mantakhé ba rafono.’ ");
INSERT INTO agd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Máa síkan betí ankan evaránen béin tiamemí, ‘Mana vanta ano ída setin doran timikhái vá tiféuno.’ “Máa síkan mai kákan banta ano vetin tiamemí, ‘Tiretin má dere oreya senti uvaini yunan anafin mo yorano.’ ");
INSERT INTO agd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Máa siran doriyaréin ma inúpasí íkan maen mai uvaini yunan anan afóe ano vei yorantá ma ayafaí ukhein banta máa sen tiamemí, ‘Taréa ínaimpáké ma me yorein kéká nare vá araí eya miyan ame ore ore vá esé ma me yorein kéká tasore ínaimpasá mo ameno.’ ");
INSERT INTO agd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Inúpáké dan manápá áaurá ma me yorein kéká ano nare eriven maná damúkáke miyan puntáden mana yanka mádú mádú en mino. ");
INSERT INTO agd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mamaran pe ákurá ma me araíen dorein banta kéká ano eriven tetí ankan kokhon moní i varanté uno siren iyaren mifo vetin má dere funtáden manaí ukhein miyan manan baren mino. ");
INSERT INTO agd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mai moní ma máden ódaren maen dunan afóen máa sen koúanten mino, ");
INSERT INTO agd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Tare ínaimpa suron ma erein banta kéká ano mana áaurá me yódayai setin má manaí miyan amiya ompo seti fe ákura suron mi me ákonaé doriyákun kákan á tikhakhen mino.’ ");
INSERT INTO agd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Máa síkan dunan ana afóe ano mai vaya iniren mai yoran banta kéká pintena mana vanta evaránen tiamemí, ‘Tirona oe, séi ída namu iyá uno. Esé dorano van ma iyan ná ma maná damúkáke miyan nan ina éku mae ídá kana ino sikhare fono. ");
INSERT INTO agd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ei miyan mamareya orono. Tesi sinunurái ínaimpá ma erein banta kayo vá manaí miyan amiyá uno. ");
INSERT INTO agd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mai sesina yaná ifo ídá tesi sinunurá tesi moní daimonte rafuno. Téi ma ma vanta kayo kama avúavá uantiyaruna vará éi ará namu uantiya fono.’ ");
INSERT INTO agd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Máan tukhanti mi ínain ma vain kéká ano esé un aní intin maen esé ma aní ukhein kayo ano ínainí inten mino. ");
INSERT INTO agd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yisasi ma Yerusaremí ódiyáken maen tiyan míkan mifo sirantan kan orun kádan (12) bei eyo iyampon máa aviren mo áupá kaúden betí ankan máa sen tiamemí, ");
INSERT INTO agd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","“Taréa setí ankan ma Yerusaremí ódé tifékun maen manáa kéká ano Banta Anin avían monó ánon banta kéká bá man baya ma afová ukhein banta kayo vá ayampin ma amintin maen béin aruan purino van monó namuntá ma yafíkein kéká ano ena anan banta kéká ayampin aminten mino. Máan turantin béin máká maáká uren intiren dafiyopó ankáden daa unkamádantá arintin púkaren kanú manaú damusí ma intin evaránen e mantanten mino.” ");
INSERT INTO agd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ínaimpáké Sebetin anin kanan Yemisin nú Yonin nú anóe ano vékan má Yisasi vaintá eriven me aron kan durafúden mátimiyan be anin kan nan Yisasi arunan uren ayaino van inaen mino. ");
INSERT INTO agd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Máa síkan Yisasi véin inaemí, “Éi nái nasará iya fono.” Síkan mai nanin mano Yisasin tiamemí, “Ei yafisimpin kaná áesin ten tanin kanan mano en ayan kurompá mana ano kumanintin ná ayan ópá mana ano kumanintin inten nafino.” ");
INSERT INTO agd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Máa síkan Yisasi mai vaya iniren evaránen tiamemí, “Tiretí ankan ma séin ina iyaona yaná ída afová ukha ono. Téi ma varanuna uman kanaisá é tiretí ankan má barante rafono.” Máa síkan béin evaránen tiamemí, “Berasan kanaí é baranté uno.” ");
INSERT INTO agd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Máa síkan Yisasi vékanan tiamemí, “Pura ino. Tiré kanan ten ma varanuna uman baran nompo iye anó ten tiyan kurompá kumanintin ná tiyan ópá kumanintin ná inten nafi mai ída sen tina yaná bain iyáantanté uno. Mai kará ma vain mai ma Sifóe ano ma aní ukhein kéká inan puntáádan ban mino.” ");
INSERT INTO agd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Be anavasan mano ma Yisasin inaein baya van tiyan míkan eyo iyampon kayo ano iniren békan anan uanten mino. ");
INSERT INTO agd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Máan tiyákan Yisasi vetin arákan be vaintá erivin máa semí, “Tiretí ankan afová ukha ono. Ena anan nanin banta kayoi kin kéká bá kákan banta kayo vá ano vei kékáká ída kama yafisirí iyáken maen betíi vaya ánain bákurino van duvun en arirí é iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Máan té iyan mifo siretimpin ída vá mai avúavá bano. Tiretin pinté iye anó kákan bantaí ono van inten nafi mai ano vá tiretíi yoran bantaí intin ná ");
INSERT INTO agd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","inká iye anó esesí ono van inten nafi mai ano vá tiretíi ída miyan ban doran bantaisá ino. ");
INSERT INTO agd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Máan manan en mi Banta Anin ma erikhein mai vanta ano ven ayain dorarí ino vara erikhen naifo véi ano vetin ayaen bei aunan betin amiré kokhon nanin banta evaráné miyaní ono van mino.” ");
INSERT INTO agd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yisasin má bei eyo iyampon kayo vá ma Yerikó baru me ampiren oriyain má kokhon nanin banta ano Yisasin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Oriyákan kankanan auu yufúkukhein bantá kanan mano aa akhempá kumantaren iníkan Yisasin nan eriyan mino siyaimpin avádóden oovararen temí, “Bafan noe, Devitin Anin mompo verasan nan arunan usintano!” ");
INSERT INTO agd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Máa sen oovarákan banasi ano iniren míkan nan baya fákano síkan mifo míkanan mano moéken avádóden oovararen temí, “Bafan noe, Devitin Anin mompo verasan nan arunan usintano!” ");
INSERT INTO agd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Máa síkan Yisasi mairá o mantaven míkan nan araaren inaemí, “Téi náisá tiré kanan uantano vará iya fono.” ");
INSERT INTO agd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Máa síkan míkanan mano evaránen béin tiamemí, “Bafan noe, verasan tuu marano van muno.” ");
INSERT INTO agd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Máa síkan Yisasi vékan nan arunan uren auu aruviyain má manádá auu kama uvin auu máben oniyáken Yisasin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yisasin má bei eyo iyampon kayo vá oriyaren Yerusaremí áde Orifí anurá Betfasí barurá o unen mino. O unaven Yisasi vei eyo iyampon kanan tianten ");
INSERT INTO agd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","temí, “Tiré kanan mesan barurá oresin ma mana donkin ma ayan nan kurantin arará bá ma van nain ná ayan nan utúde vá míkanan avire se varunarasá ereno. ");
INSERT INTO agd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eresin ma mana ano ma manáa vaya ma sinti vá tiré kanan máa ná teno, ‘Míkani yoran Bafampin ban mino’ ma sesin maen ainen mi siantanti avire erin nono.” ");
INSERT INTO agd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Máan ma ein manon pefá ma sakhanampa vanta oo ráké uaren ma máa sikhá ein mi kanaíen mino. ");
INSERT INTO agd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saioní nanin banta siameno. ‘Onano. Tiretí ankani kin mi eriyan mino. Béi mana donkin ané kumamen aví ída van banta an daven eriyan mino. Béi maen mana ané ída kumantá ein donkin amaniná kumamen eriyan mino.’” ");
INSERT INTO agd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Eyo iyampon kanan mano oren mai ma Yisasi siameiní mo en mino. ");
INSERT INTO agd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Máan turen mai donkin kan aviren meran betíi ayá au anamun daváden arará donkin ané kaúdan Yisasi mai yaró kumanen mino. ");
INSERT INTO agd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kumamen oriyákan kokhon nanin banta ano au anamun daváden aasá uvisen orin inká manáa ano yaa ayan tíkariyan uvisen orin en mino. ");
INSERT INTO agd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Máan tiyákan kokhon nanin banta ano Yisasin aufá orin oyampá erin iyáken máa sen oovaremí, “Devitin Anin avisá daní ino!” “Bafan avíká ma eriyain banta vá avu uantano!” “Dan uron ma vain Tiyarafenu avisá daní ono!” ");
INSERT INTO agd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yisasi ma Yerusaremí barufin ódiyain má banasi ano anúden oreraen máa sen inaemí, “Ma vanta iye fino.” ");
INSERT INTO agd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Máa sen ina íkan mai ma oriyaré ein nanin banta ano semí, “Kariri varafá ma vain baru Nasaretíke sakhanampa vanta Yisasi ino.” ");
INSERT INTO agd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yisasi monó dafufin un pében ona ma sarí iyá ein banta kayo sianten mino. Moní ma arun miyan ma nun kayo yáken sarí iyaré ein takhó bá kará kayo vá béi vanaan karúdan oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Banaan karúdiyáken máa sen betin tiamemí, “Tiyarafenui vompon dóki ano máa sikhen mino, ‘Banta ano séin tima san amúkin namun nen tinten’ mifo siretí maman ‘umoyan banta kéká amasíi’ iya rono. ");
INSERT INTO agd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Máan turen Yisasi kákan monó namumpin bákan auu yufúkukhein kéká bá arantan ma namu ukhein kayo vá ano véi vaintá eríkan kama uanten mino. ");
INSERT INTO agd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Máan tiyákan monó ánon banta kéká bá man baya ma afová ukhein banta kayo vá ano mai ma véi enará ukhein danasinta ma variyain oniyákan mai monó dafu finté iyamporinta kayo ano máa sen oovariyamí, “Devitin Anin avisá daní ino!” Máa síkan betí ankan ará namuen mino. ");
INSERT INTO agd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ará namu iyáken Yisasin inaemí, “Ma iyamporinta ma siyain baya inká iniya nan nafino.” Síkan Yisasi evaránen betin tiamemí, “Eyo séi iniyá umpo ‘minó arará iyamporinta anon éin aví daní é iyan ne’ ma sikhein baya siretí ankan ídá Tiyarafenui vompon dóki fintena yankáke rafono.” ");
INSERT INTO agd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Máa siren béi Yerusaremí bá betin má me ampiren mai inuran Betaní barurá o varen mino. ");
INSERT INTO agd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pe ákura suron Yisasi e mantaaren Yerusaremí evaránen oriyá íkan arafan puren mino. ");
INSERT INTO agd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Arafan puríkan béi onan mana fiki yaa ana aa akhempá baré íkan ádé oriven mai anafin onákan ída mana aran iren mifo anaa ana variyan baré íkan béi mai fiki yaa ana van temí, “Éi ída vá enádá bá aran irano!” Máa siyain má mai yaa ainen kafuren mino. ");
INSERT INTO agd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kafuriyain má eyo iyampon kayo ano ódaren takhaen oreraen temí, “Inte uáken ná ma fiki anaa ainen kafuren nafino.” ");
INSERT INTO agd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Máa sen ina íkan Yisasi evaránen betin tiamemí, “Téi fura siré tiretí ankan tiamiyá uno. Tireti ma ída kan ineine in ma fura seya mumunan uron ma inteya ma fiki yará ma eruna avúavá ana ída varan nompo ma anuyon nan ma e afáne un nompin orono ma sesin maen kasaen tiretí ma sinonaí inten mino. ");
INSERT INTO agd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tiretí ankan ma mumunan iya amúkinte mae mai ma varano van amúkin nona yaná baran nono. ");
INSERT INTO agd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yisasi ma monó namuni yafufin un pében monó baya siamiyákan maen monó ánon banta kéká bá Isareri kayoi ánon banta kayo vá ano Yisasi vaintá eriven máa sen béin inaemí, “Éi inte ákona fosá mai yanasinta variyákeya inká iye anó éin mai yorarí ono siren ná mai ákona amikhen nafino.” ");
INSERT INTO agd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Máa sen ina íkan Yisasi evaránen betin tiamemí, “Tiretin má dere mana inain ina urékuya ma funtáde sisimiresí maéi mai ma yorarí ino van ma simikhein ákona ana siamenté uno. ");
INSERT INTO agd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Banasi ma monó non péantan mai ákona Yoni inte fákená mantaren nafino. Mai ákona maen Tiyarafenu fintesá erikharen nafi áa varará banta fintesá erikharen nafino.” Máa síkan betíyan ten inen emí, “Mai setí ma ‘Tiyarafenu finté erikhen mino’ ma sékun maen mai véi máa sen tetin ina inten mino, ‘Mai fará Yonini vayará ída mumunan iya fono.’ ");
INSERT INTO agd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Máa sinten mifo mai setí ma ‘varará banta fintéi erikhen mino’ ma sékun maen mai Yoni mana sakhanampa vantan bákan minó ano afová ukhein mifo seti vanasi vará perá tifano.” ");
INSERT INTO agd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Máa siren betí ankan evaránen Yisasin tiamemí, “Tetí ankan ída afová ukhé tiféuno.” Síkan Yisasi vetin tiamemí, “Mai séin má dere iye anó ákona simikhará doriya rafu mai siretin ída siamenté uno.” ");
INSERT INTO agd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Máa siren “tireti inte inin ná iniya rafono” sen inaemí, “Mana vanta ano ain iyampon kanan dákaren esékena iyampon mo máa sen tiamemí, ‘Tanin noe, saréa uvaini yunampin ná mo yorano.’ ");
INSERT INTO agd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Máa síkan mai iyampon mano semí, ‘Tifon kiyá uno,’ siren ineine uvákon den ínaimpáké oren mino. ");
INSERT INTO agd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Máa siran be afóe ano ena iyampon baintá onóben mai ma sein baya ana mo síkan mai iyampon mano ‘eyo oronté uno’ siren ída oren mino. ");
INSERT INTO agd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Mai iyampon kanan pinté iye anó be afóen oo yaiyen nafino.” Síkan betí ankan temí, “Eséke ano ino.” Máa síkan Yisasi vetin tiamemí, “Téi fura siré tiretin tiamiyá uno. Takisi varan banta kayo vá pamúku nanin arinta vá ano naren tiretin esanten Tiyarafenui yafisimpin oferanten mino. ");
INSERT INTO agd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mai fara vara seyo, Yoni siretimpin afoká uven puntákein avúavá tiretin aní iya siretí ída ventá mumunan e ompo takisi varan banta kayo vá pamúku nanin arinta vá ano anan bentá mumunan en mino. Tiretí ankan mai ódare ompo ída ará baédeya ventá mumunan e ono. ");
INSERT INTO agd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ena ovaeran baya ifo vá tiretí ankan ná ineno. Mana vanta ano uvaini yunan dóden dafuí uren maen uvaini afu kúduren ma yasáden anu kasin nain masí maifin uáden inká dunan anará ma yafisin nain mana yan bain namun uvamá daren nentá bain barufá orono van iyáken manáa vanta kéká ano yafíantano van mai yunan anan me vetin ayampin kaen mino.” ");
INSERT INTO agd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","O varé íkan uvaini aran kúdin damusí íkan maifin ma yoriyain banta kayo vaípákena uvaini aran ma kúduádan o varano van bei yoran banta kéká tiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Oríkan maen mai yunampin ma yoriyaré ein banta kayo ano mai yoran banta kéká dakhádan orera iyákan mana fákaren ankamen ena aruan puren inká ena onámaná ankamádan puren mino. ");
INSERT INTO agd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Máan turan mai yunan ana afóe ano evaránen pe ma siantan orikhá ein esantaren kokhon doran banta siantan oríkan maen mai yunampin ma yoriyaré ein kayo ano mai ma fefá ma ukharé ein avúavá ana mai yoran banta kayo amaniná kaen mino. ");
INSERT INTO agd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Máan mana iyaimpin ‘te sanin avayan ininten mino’ siren dunan afóe ano ínaimpáké be anin tiantan mai kéká baípá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Oríkan maen mai yunampin ma yoran banta kayo ano ve anin ódaren betiyan máa sen oreraemí, ‘Ma vanta anon minó be afóen nina yanasinta varanten mifo erí tifé béin aruan púdé benina yanasinta vará tifano.’ ");
INSERT INTO agd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Máa siren betí ankan béin pákaren mai yunan dafu fintena yarifen akhempá morúden aruan puren mino. ");
INSERT INTO agd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Máan ten mifo siretí ankan inte esá té iniya rafono. Ínaimpá mai uvaini yunan afóe ma eriven maen mai yunampin ma yoriyá ein banta kayo amaniná inte yaná avúavasá kainten nafino.” ");
INSERT INTO agd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Máa síkan betí ankan béin tiamemí, “Mai ma namu avúavá barein banta kayo me aruan púden maen uvaini aran ma kúdin damú ma erintin ma kúduren bariyan ma véi siran nain máa uvaini aran ma kanaíen béin ameren kéká ayampin mi mai yunan ana kainten mino.” ");
INSERT INTO agd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Máa síkan Yisasi vetin tiamemí, “Tiretí ankan ídá Tiyarafenui vompon dókifin ma ma vaya vain mai yankáke fono. Mai vaya máan mi sikhen mino, “‘Má uvaran banta kayo ano ma yo maman karúdein onámaná ano maman má dádaimpin mana ákona onámanasí ukhen mino. Mai Bafan mánon máan turan mai anon tetin tivorá kama ukhen mino.’” ");
INSERT INTO agd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Máan tukhái séi siretin tiamiyá uno. Tiyarafenu ano siretí ankan ayan pintena vei yafisin baru e yafiaren maen maifin ma kamaen aran iran nain nanin bantan aminten mino. ");
INSERT INTO agd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Banta ano ma mai onámaná daró ma erave ankaminona ano kisikhasi inono. Inká mai onámaná ano ma mana vanta amaniná ma eravinten ankaman tafin tafin uádanten mino.” ");
INSERT INTO agd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yisasi ma yunan anará namu yafisirí in banta kayorá ma sian baerein baya van monó ánon banta kéká bá Farasisi kayo vá ano setin nan mi siyan mino sen afovaen mino. ");
INSERT INTO agd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Afová uren betí ankan Yisasin pákano van en mifo vanasi ano Yisasi nan sakhanampa vanta ino sen iniyákan mai van betí ankan banasi van péden ifá en mino. ");
INSERT INTO agd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yisasi ena vaya máa sen tian baéan betin amemí, ");
INSERT INTO agd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Inaru yafisin máan mi ukhen mino. Mana kin mano ma ve anin anasi iman ameno van iyákan ma kákan dunan tariyainíi ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tarano van ma iyáken maen mai ma fefá arakhá ein kéká ano mai omáká eriven dunan nano van bei yoran banta kéká tiantan mo siamíkan ifá en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Máa siyaimpin béi evaránen manáa kokhon doran banta siantan oriyákan tiamemí, ‘Mai ma fefá arakheruna kayo vá tiameno. Téi afon kao kayo vá kákan aino víkakhein tafúna kayo vá inka aruré tamádé umpo eriven ná ma anasií in omáká ma samáderuna yunan ná nano sen mino vá te siameno.’ ");
INSERT INTO agd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Doran banta kéká ano mo máa sen tiamíkan maen mai kayo ano ída inen mino. Mana ano me ifá en bei yunampá oríkan inká ena ano me ifá en bei moní dorantá orin en mino. ");
INSERT INTO agd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Máan tíkan manáa ano mai kini yoran banta kéká pákaren namu arirí uren aruan puren mino. ");
INSERT INTO agd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Aruan púdeimpin kin mano aran karen bei aruvin banta kéká tiantan mai ma vei yoran banta kéká arein banta kayo mo aruan minó kíparen betíi varu saman kauren mino. ");
INSERT INTO agd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Taman kaúdan kin mano vei yoran banta kayo máa sen tiamemí, ‘Anasií in dunan inka samádan ban mifo mai sarampin erino van ma areruna kéká ano inian kaumpan uren pasen ída eren ");
INSERT INTO agd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","mifo siretí ankan oriveya aayana fáke ma onanona nanin banta avire eresin ná anasií in dunan me nano.’ ");
INSERT INTO agd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Máa síkan doran banta kayo ano ayanafá orera uven kama nanin banta vá namu nanin banta vá iyanuan meran mai namun e víkaven mai yunan nen mino. ");
INSERT INTO agd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Niyákan kin mano vanasi ma e iyukhein onano van mai namun un pében onákan mana vanta ano anasií in damú ma uren oriyain buí daná ída ukharen mino. ");
INSERT INTO agd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ída ukharé íkan kin mano véin inaemí, ‘Tirona oe, náisá iyá éi ída anasií in damú ma iyain buí daná ureyá e va fono.’ Máa síkan mai vanta ano ída vaya sen mino. ");
INSERT INTO agd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ída vaya siyaimpin kin mano máa sen doran banta kayo siamemí, ‘Tiretí ankan béin ayan arantantá damureya karúdan títípafin o váken ifí diyan aveantuntá inkekípiyan bano.’ ");
INSERT INTO agd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Para vara seyo, kokhon nanin bantan Tiyarafenu ano arakhen mifo manáan aní ukhein mino. ");
INSERT INTO agd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Máa siyaimpin Yisasin mákádantin manáa ída funtákein baya sirantí beni vayará kó tiantano van Farasisi kayo ano o átaru uven baya sen inen en mino. ");
INSERT INTO agd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Betí ankan betíi eyo iyampon kayo vá manáa Erotini anan banta kéká bá tiantan Yisasi vaípá oriven mo máa semí, “Aru soe, setí ankan afová ukhékuya éi fura vaya ana sin banta ono. Éi fura sikhein baya fóké anan Tiyarafenui avúavá baya sian banasi amé iya ono. Aví bain banta fi ída aví bain banta fi éi minó manaí ukhein baya anan ída feran tiamé iya ono. ");
INSERT INTO agd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Máan té iya ompo ei ineine setin tisimeno. Sisan ma sakisi amin mai kama ukhen nafino áa ída fino.” ");
INSERT INTO agd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Máa síkan Yisasi vetí ankani ineinefin pe afová ukhen temí, “Tireti vaya ana siren ída mai vaya ánain dakhafin banta kéká ompo fará tiretí ten mákáan oniya rafono. ");
INSERT INTO agd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisi ma amé iyaona mai moní mana aníí onano.” Síkan betí ankan mana moní baren béin me amen mino. ");
INSERT INTO agd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Amirákan Yisasi vetí ankan máa sen inaemí, “Ma iyen aman má iyen aví basá ban nafino.” ");
INSERT INTO agd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Máa síkan betí ankan evaránen temí, “Sisan nina ino.” Síkan béi vetin tiamemí, “Sisan nina yanasá Sisan ame vá inká Tiyarafenu ina yanasá Tiyarafenun ná ameno.” ");
INSERT INTO agd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Máa síkan betí ankan mai vaya iniren kokhon ineine uvákon béin me ampiren oren mino. ");
INSERT INTO agd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Maí damú ana Sadyusi kéká ano Yisasi vaintá eren mino. Mai kéká ano furin banta van ída evaránen e mantanten ne siyain bákan máa sen betí Yisasin inaemí, ");
INSERT INTO agd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Aru soe, Mosesi máa sen tetin tisimikhen mino. Mana vanta ano ma anasi mantaren ída iyampon kainton ma fúbintin maen ná ben afá aváe ano vá mai nanin máden ná mai vanta avíkasá iyampon kauantantin ná ben aví ída vá kípano. ");
INSERT INTO agd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Máa sikhan mi fefá tetimpin dan manápá ifo afápá kan un kádan anavádano varen esékena ano anasi mantaren ída iyampon kain na fúbin be afá ano mai nanin baren mino. ");
INSERT INTO agd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mantaren mai ven ánain tena vanta ano ída iyampon kainton púbíkan mai rákena vanta ano mai nanin mana mantaren púbin e máan ten oriyan minó dan manápá ifo afápá kan un kádan anavádano anon mai mana nanin manan mantaren mino. ");
INSERT INTO agd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mantaren minó banta ano fúbíkan ínaimpáké mai nanin dere furen mino. ");
INSERT INTO agd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Máan tukharen mifo ínaimpá ma furin banta ma evaránen e mantan nain damú mai nanin mano yan manápá ifo afápá kan un kádan anavádano mantaren mifo mai véi iyen anasá banten nafino.” ");
INSERT INTO agd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Máa síkan Yisasi evaránen betin tiamemí, “Tiretí ankan Tiyarafenui vompon dókifin ma vain baya vá beni ákona vá ída afová ukheyan baya asuse iya rono. ");
INSERT INTO agd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Purin banta kéká ma evaránen e mantan nain damú mai nanin banta kéká ano ída ábasuí inten mifo inaruráke enisori kayo an manan den orera inten mino. ");
INSERT INTO agd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Máan tinten mifo furin bantai e mantan nan ma siyaona vayará téi siretin inaintó uno. Tiyarafenu ano ma siretin nan máa sikhein baya ídá dankáke rafono. ");
INSERT INTO agd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Téi Abaraamun má Aisakin má Yekopun mái Ayarafenu uno.’ Béi ída furin nanin bantai Ayarafenu ifo ayun ma fara vain nanin bantai Ayarafenu ino.” ");
INSERT INTO agd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Máa síkan banasi ano veni vaya iniren takhaen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yisasi ma mai vaya sein nan Sadyusi kéká ano ída vaya siyaimpin Farasisi kayo ano mai vaya iniren betiyan o átaru en mino. ");
INSERT INTO agd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Betí aúbaná mana man baya ma afová ukhein banta varen Yisasin akhenóka uan onen máa semí, ");
INSERT INTO agd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Aru soe, intéa man baya anó minó man baya esantaren ná esesí ukhen nafino.” ");
INSERT INTO agd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Máa síkan Yisasi evaránen temí, “‘Ei Bafan Tiyarafenun ná e aú amafon má ei ineinefó basá anunu ono.’ ");
INSERT INTO agd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ma esé ma araíen kákani suron ukhein man baya ino. ");
INSERT INTO agd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mairá ben oyampá ma ven má manaí ukhein man baya máan mí ukhen mino. ‘Eyan nan ma anunu iyaonaíe vá ena van anunu ono.’ ");
INSERT INTO agd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ma man bayá kanan manon mai minó man baya vá sakhanampa vanta kayoi vaya vái ana uron mi van mino.” ");
INSERT INTO agd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farasisi kayo ma átaru ukhen baré íkan maen Yisasi vetin inaemí, ");
INSERT INTO agd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Tiyarafenu ano ma aní ukhein banta van tiretí inte esá teyá iniya rafono. Mai véi iyen anin nafino.” Máa síkan betí ankan evaránen temí, “Devitin anin mino.” ");
INSERT INTO agd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Máa síkan Yisasi vetin inaemí, “Mai intesá ukhan ná Kantá Aunan mano ineine Devitin amin ná mai vanta van Bafan ne sen nafino. Deviti máa sikhen mino, ");
INSERT INTO agd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Bafan mano senti Bafan máa sen tiamemí, “Éi sen tiyan kurompá kumantesirá eni namuro maman en aránaópá kaúdéku vá ono.’” ");
INSERT INTO agd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mai vanta van ma Deviti Bafan ne sikhan tiya mai siretíi intesá eyá ben nan Devitin Anin ne sinte fono.” ");
INSERT INTO agd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Máa sirákan mana ano ída anona evaránen Yisasini vaya siamin nainí eimpin péden mai ráké betí ankan ída mana yana san béin inaen mino. ");
INSERT INTO agd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Máa sen inauren mairá Yisasi vei eyo iyampon kayo vá banasi vá tiamen temí, ");
INSERT INTO agd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Man baya ma afová ukhein banta kéká bá Farasisi kayo vá anon Mosesi ma iyá einíen mi man baya vaéan tiretin amiyan mino. ");
INSERT INTO agd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Máan tukhanti vá minó baya ma veti siamin nain inire vá mai ánain ná dakhafono. Dakhafin nompo vetí ankan ma variyain avúavá ída vá barano. Kokhon baya veti siren ída mai vaya kayo ánain dakhafé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Betí ankan mana uman dakhein bayafó banasi siamin mai uman baren oriyan mifo vetí ída mana yáman máafó mai kayo e aya é iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Banasi ano onano van mi minó daná betí ankan baré iyan mino. Kákan amúkin ana ayafentá damuren inká anan kayo vetíi ayá au anamun átontá damiyan é iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kákan omá dunan ma sariyan ma átaruimpin betí ankan esé an kará ana variyáken inká monó átaru namun kayofin ina esé avorú karáká anan kumanin kayo ino. ");
INSERT INTO agd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Minó daná ma kain miyaní in barurá banasi ano vayan mino siyantin inká aru soe sen arano van mi vetí ankan anunu iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Máan tiyan mifo siretin nan banasi ano ída vá aru soe sino. Para vara seyo, siretíi Kákan manan bákayan tireti minó ano mana nanin banta an mi yakha rono. ");
INSERT INTO agd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma varará ída vá mana vanta van tiretí ankan mano sifóe oe seno. Mana Afóe anan beyaká inarufá ban mino. ");
INSERT INTO agd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Minó ano ída vá éin nan aru soe sino. Para vara seyo, Tiyarafenu ano ma aní ukhein banta anan tiretíi arú ban mino. ");
INSERT INTO agd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tiretí ankani ánon banta ano vá tiretíi yoran bantai sá ino. ");
INSERT INTO agd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mai fara vara seyo, ve aví ma yaní inain banta aví barará eravintin maen inká be aví ma vararasí inain banta ano kákan bí baranten mino.” ");
INSERT INTO agd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Yisasi evaránen máa semí, “Tiretí Farasisi kayo vá man baya ma afová ukheona vanta kéká ba soe, vaya ma sireya ída mai ánain dakhafé iya ono! Inaru yafisini ona munkiya vákeya siretiyantá ída maifin oferiya ono. Banasi ano ma maifin oferano van ma iya mae vetin ida áen nan oferiyain mai siretí kákan uman uron mi varan nono. ");
INSERT INTO agd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Man baya ma afová ukheona vanta kayo vá Farasisi kéká ba soe, kákan uman uron mi varan nono! Tireti vaya ma sire ída mai ánain dakhafé iya ono. Tiretí ankan ma varará bá un nompin má ma noreya ma mana vanta o avían tiretimpin kauren nan ma siretin an davi mae véin maman aron ída van ma ira kiyan uman baren berai siyan purin baru finte vanta an daádiya ono. Tiretí ankan manon béin avíáde nan mi véi moéken tiretin esantaren namu avúavá bariyan mino. ");
INSERT INTO agd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Tiretí ankan auu yufúkukhein kéká anon banta aa aní uantano van iyaona sireti kákan uman uron mi varan nono. Tiretí ankan máa sé iya ono. ‘Banta ano ma Tiyarafenu amáká ma o siaren asíká ayan befió uren ma fura ódino siren té iyain mai sitó daná ifo Tiyarafenu amápin ma vain korirá ma o siaren ma asíká ayan befió ma uranten ná mai ma véi siran nainisá ino.’ ");
INSERT INTO agd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tiretí ankan auu yufúkukha óen banta kéka soe! Inte yaná anó kákan daná ban nafino. Kori anó kákaní ukhen nafi áa kákan monó namun manó kori maman kantasí ukhen nafino. Tiretí ankan afová ukha ono kákan monó namun mai anon kákaní ukhan mai Tiyarafenu inan ban mino. ");
INSERT INTO agd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tiretí ankan máa sé iya ono. Mana ano ma íkun uan amin onámaná ma karánará ukheintá ma o siaren asíká ayan befió é iyain mai sitó daná ifo íkun uan amino van ma amiyain danasintará ma o siaren asíká ayan befió uranten ná mai ma véi siran nainisá ino. ");
INSERT INTO agd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tiretí ankan auu yufúkukhein banta kéka soe! Inte yaná anó kákan daná ban nafino. Íkun ma uan amin danasinta anó kákaní ukhen nafi áa íkun ma uan amin onámaná ma karánará ukhein manó mai ma íkun uan amin danasinta maman kantasí ukhen nafino. Tiretí ankan afová ukha ono yunan ma íkun uan amin kará daró ma vain mai anon kákaní ukhan mai Tiyarafenu ina ino. ");
INSERT INTO agd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Máan tukhan mi mana ano ma íkun uan amin onámaná ma karánará ukheintá ma o siaren asíká ayan befió é iyan, mai anon íkun ma uan amin kará bá mai yaró ma íkun uan amin danasinta ma vaintái vei vaya sian ákonaé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Máan té iyan mifo mana ano ma Tiyarafenu amáká ma o siaren ma asíká ayan befió é iyain mai anon Tiyarafenu vá ben amáká bái vei vaya sian ákonaé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mana ano ma inaru van o siaren ma asíká ayan befió é iyan mai anon Tiyarafenui kumanin karái vákan mairá béi kumantan mi vei vaya sian ákonaé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Máan tiyan mifo siretí ankan man baya ma afová ukheona vanta kayo vá Farasisi kéká bá ano vaya ma sireya ída mai ánain dakhafin kékái vaona kákan uman uron mi varan nono. Tiretí ankan dunan ana fintena yanasinta siyan míkan pintan daídeya mana masiman Tiyarafenun améiya ompo man bayafin ma moéken kákaní ukhein man baya máan tiretí ampikha ono. Mai ma funtákein avúavá baya máa mai máan mi ukhen mino. Puntákein avúavá póké ma vanta yaimiyain má arunan in má inká Tiyarafenu vá ma súpá ukhen ban má ino. Ma máa man baya anon moéken kákaní ukhen mifo mai máa ánain ná dakhafiyáke ída vá ena man baya kayo vá dere ampeno. ");
INSERT INTO agd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tiretí ankan auu yufúkukhein kékái vákeya sitó danasinta yo aían karúdiya ompo kamerin nankuriya rono. ");
INSERT INTO agd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Máan tiyan mifo siretí ankan man baya ma afová ukheona vanta kayo vá Farasisi kéká bá ano vaya ma sireya ída mai ánain dakhafin kékái vaona kákan uman uron mi varan nono. Tiretíi fereti vá kápi vá dantena ana seséin kéká ompo ena ina yaná ma aran nan avúavá bá eyan nan mana ma in avúavá bá ano anan mai aúpin bíkakhen mino. ");
INSERT INTO agd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Auu yufúkukhein Farasisi kéka soe! Pereti vá kápi vá aú pinte nare vá tesé uresin ná ínaimpákesá dantena me avusese ino. ");
INSERT INTO agd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Máan tukhen mifo siretí ankan man baya ma afová ukheona vanta kayo vá Farasisi kéká bá ano vaya ma sireya ída mai ánain dakhafin kékái vaona kákan uman uron mi varan nono. Banta masíká ma efanten peni fédan ma kama ukhan oniyainíi ukha rofo masípin ma vanta ayampa kayo vá púta yanasinta vá ma vainíi siretí ukha rono. ");
INSERT INTO agd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tiretí ankan má máan mi ukhe va ono. Banta ano siretin dan bukhafarái ódaren tiretin nan puntákein banta kéká ino sen iniyan mifo aúpin kampun avúavá bá man baya yurafurin avúavá bá bíkakhein kéká ono. ");
INSERT INTO agd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yisasi evaránen máa semí, “Tiretí ankan man baya ma afová ukheona vanta kayo vá Farasisi kéká bá ano vaya ma sireya ída mai ánain dakhafin kékái vaona kákan uman uron mi varan nono. Tiretí ankan mano sakhanampa vanta kayoi masí uantádeya inká puntákein kékái masíká kama auí uan kain banta kayo ono. ");
INSERT INTO agd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Máan tiya váke siretí ankan máa séiya ono, ‘Pefá tinafu siráo ma vá ein damú tetin má baré ída kanaíé betin ayaé sakhanampa vanta kayo aruan puronté erunaren mino.’ ");
INSERT INTO agd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Máan ma siyaona anon sakhanampa vanta kéká ma aruan púkaré ein mai vanta kayo anavasin mi vá uno seya siretiyan aní iya ono. ");
INSERT INTO agd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Oriveya anafu aráo ano ma namu avúavá araí urein ná mo maman kípano! ");
INSERT INTO agd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Tiretí ankan namu osafáe akhafana ono! Tiyarafenu ano ma siretin ma kó tiantáden ma ira kiyan uman baren berai siyan purin baru ma iyáantákein mai intesá eyá akhakhante rafono. ");
INSERT INTO agd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Máan tukhen mifo vá tiretí ankan ineno. Téi sakhanampa vanta kéká bá kama ineine vain banta kayo vá man baya ma afová ukhein banta kayo vá tiantékun tireti vaípá erinten mifo siretí ankan manáa yaa unkamádantá aruan puriya manáa siretíi monó átaru namun kayofin avíáde yafiyó ankamiya mae manáa kéká baru vaintá e yakháan more mere esin orera inten mino. ");
INSERT INTO agd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Máan tukhein nan mi mai ma funtákein banta kéká ma Eborin táké araí ure ma are eriya ma Barakian anin Sekaraiyan ma Tiyarafenu amá bá íkun uan amin takhó aúbaná bá ma aruan pureona kékái nare miyan tiretí ankan amaninái erinten mino. ");
INSERT INTO agd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Téi fura siré tiretin tiamiyá uno. Mai namu avúavái miyan maen tare ma vaona nanin bantafin mi afoká inten mino.” ");
INSERT INTO agd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yisasi evaránen temí, “Yerusaremi oe, Yersaremi oe, éi sakhanampa vanta kayo aruan puriya ono. Máan tiyákeya Tiyarafenu ano ma siretimpin tiantan erein banta kéká aruan purono van onámaná ankamiya ompo séi kokhon dádái anasi kokore ano ma ve ayan aránaópá be akhafana avían kaeiníi iyáku ompo siretí ankan ída ine ono. ");
INSERT INTO agd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ída inen nan Tiyarafenu ano eni kákan monó namun oyan amiran dúken mino. ");
INSERT INTO agd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Máan tukhái séi siretin tiamiyá uno. Enádá bá tiretí ída sen tonan bare maeya maná damusí intiya ‘Bafan avíká ma eriyain banta vá avábá uantano’ sin nono. ");
INSERT INTO agd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yisasi ma kákan monó baru me ampiren oriyákan maen bei eyo iyampon kayo ano ve vaintá eriven kákan monó namun kayo aní ono van en mino. ");
INSERT INTO agd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Máan tíkan béi vetin inaen temí, “Tiretí ankan ma kama namun kayó oniya rafono. Téi fura siré tiretin tiamé uno. Namuro ano me varákuren maen minó onámaná ída áintin ben ané ben ané ukhen banten mifo varakuádantin eraven asuse inten mino.” ");
INSERT INTO agd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yisasi ma Orifí anu yontá kumantá íkan beni eyo iyampon kayo máa ano oriven béin inaemí, “Éi setin tisimeno. Inte yamusá mai yaná afoká inten nafino. Inte yaná ma afoká intirá tetí ankan onesá éin nan inka erintéin ma vara kípanten mino sente rafuno.” ");
INSERT INTO agd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Máa síkan Yisasi evaránen betin tiamemí, “Banta ano siretin mákasin nafo yafían ná ákona ono. ");
INSERT INTO agd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Para vara seyo, kokhon nanin banta ano eriven ten tiví tiaren máa sinten mino. Tiyarafenu ano ma aní ukharé ein bantan téi eré uno siren maen kokhon nanin banta máka sinten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tiretí ankan inesin aruvin baya vá aruvono van ma siyan nain baya vá mai van tiretí ída vá anú duman duman ono. Mai yanasinta erivintin maen ínaimpákéi ma vara ma kípan damú afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mana anan banta kéká ano e mantaaren ena anan banta vá aruvintin mana kini kéká ano e mantaaren ena kini kéká bá aruvintin manáa akhempá kákan anan afoká intin maen ma vara kaya intin inten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Máan tinten mifo mai yanasinta ma afoká inain mano mai anasi ano ma araíen inamun nan ineiníi inten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Máan ma intin maen ten naro siren tiretin ará namu uantáden avían namuro ayampin kaintin tiretin aruan purinten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Maí damú tentá ma mumunan ukháin nain nanin banta kéká ano vetíi mumunan ampintin erafuvintin beraran anan maran uaren ben avían namuro ayampin kain maran intin ");
INSERT INTO agd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","inká kampun sakhanampa vanta kayo afoká uven maen banasi máka siantanten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Namu avúavá ano kákaní intin maen kokhon nanin banta ano ena ma ará amin avúavá an pinten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","An pinten mifo ákonaen ban ma oriyan baréin nain mai nanin bantan ínaimpá ma ma vara kípan nain damú Tiyarafenu ano evaránen aviranten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tiyarafenui yafisin pintena vaya ma varará minó akhempá betí ano siamen orera intin ma minó nanin banta ano inirantin inaimpáke suron mi vara kípan damú erinten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pefá ma sakhanampa vanta Danierin oorá ma sikharé einíen Tiyarafenui kantasí ukhein kákan monó namumpin mana namu yana suron afoká uven minó daná máden asuse intiya siretí ankan onan nompo ma vaya ma yankafin nain mano vá mai vayai ana afová ino. ");
INSERT INTO agd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Máa ma intin maí damusá Yudiá barafá ma vain nanin banta ano anufá ana vá karan orino. ");
INSERT INTO agd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Orintin maen ná be amá daró ma un baréin nain mano ída vá mana yaná be amá pintena eravuven barano van inino. ");
INSERT INTO agd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Máan ma intin maen dunan anafá ma o varé inain mano ída vá evaránen be amá pintena vei ayá au anamun o varano. ");
INSERT INTO agd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Amú bá nanin kéká bá iyampon ma nan kuviyan bain nanin kayo vá ano maí damú ma erintin maen kákan uman mi varanten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Á den iyon in damu safi Sabati yamu safi mai yaná afóka inafo amúkesin ná pasavi yamusá afoká inti vá karan orono. ");
INSERT INTO agd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Para vara seyo, ma vara ma araíen uvarein táké ma eren tare ma e vaona aúban ída máan uman afoká ukharé ein uman mi maí damú afoká inten mifo ída máan uman ínaimpá afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tiyarafenu ano ma ída máan uman kayoi yamú ma maman asíkaí intin maen minó nanin bantan afeyoranten mifo véi ma fe iyákein nanin banta van ma ininten maen maí damú maman asíkaí inten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Maí damú ma mana vanta ano ma siretin tiamen ma onano, Tiyarafenu ano ma aní ukharé ein banta masi mafá ban mino áa mesapá ban mino ma sintiya ída vá betíi vayará mumunan ono. ");
INSERT INTO agd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Para vara seyo, manáa kampun sakhanampa vanta ano eriven maen máa sinten mino, ‘Tiyarafenu ano ma aní ukharé ein téi mai vantan báké mana sakhanampa vantan bá uno.’ Máa siren maen ara ara aní danasinta vá kákan enará ukhein danasinta vá afoká inten mino. Afoká uren kokhon nanin banta aviren mo asuse iyáken Tiyarafenu ano ma veyan iyákein nanin banta vá dere kasaen kufa uádanten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ineno. Mai yanasinta afoká intéíi séi siretin pe o útúbé tiamiyá uno. ");
INSERT INTO agd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Tiamé umpo manáa ano ma siretí ankan tiamen ma Tiyarafenu ano ma aní ukhein banta mesapá banta ída van kámápá ban mino ma sintiya ída vá maifá orono. Ma namumpin aúpá ban ne ma sintiya siretí ída vá betíi vayará mumunan ono. ");
INSERT INTO agd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tiretí ankan afová ukha ono. Áau e uní páké ma afayuí uaren ma áau orun perápá ma aravé iyain máa uran mi Banta Anin ma erin nain damú intin mi minó nanin banta ano onanten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Purin banta kayo au ma asenten bain mai varurái sumpan kayo ano o átarué iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mai kákan uman kayo ma kípan nain damú anan ‘áau ano sítipa intin biyon ída ena vá kantin ayon táké minó ofu kayo kararen eravintin minó ákona yaná ma inarurá báin nain mano kayamana inten mino.’” ");
INSERT INTO agd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Maí damú Banta Anini aní daná ma ayontá afoká intin mi varará nanin banta ano ifí diyáken onantin mi Banta Anin mano inaru fáké konan daró bei ákona vá kákan kakhan má erinten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Eriyáken maen bei enisori kayo sintin ufen kákaníen asiyáken ma vara minó akhempá oriven beyan ma iyákaré ein nanin banta avían átaru inten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Tiretí ankan anna rasá afova varano. Anna amú ma eyavénan maeyan afeen aá kanten mino séiya ono. ");
INSERT INTO agd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Máan ten ma minó daná afoká inti oniya mae vá mai Banta Anin inka ádé anantá ereno van onará mantakhen mino vá te afová ono. ");
INSERT INTO agd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Téi fura siré tiretin tiamiyá uno. Ma ma saréa vaona nanin banta ano ída fúkesin mi mai yanasinta afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Inaru vá bara vá kípanten mifo senti vaya ída uron mi kípanten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ída mana nanin banta ano maí damú bá áau vá afová ukhan inaru ráké enisori kéká bá ano ída afováin be Anin mano yere ída afová ukhen mifo ve Afóe veyáká anan afová ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mai ma Noani yamú aniana iyáin ma afoká einí ukhein avúavá anan Banta Anin ma ereno van iyantin maen afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ída ma á den non takhan banasi ano yunan táden non má niyáken anasi variyan inká arinta uviran maran en oriyain pintéi Noa votifin un peren mino. ");
INSERT INTO agd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mai yaná ma afoká inain betí ankan ída afová ukharéin mi kákan á den non taaren banasi ufúan kípen mino. Máan tukhein avúavá anan Banta Anin ma erin nain damú afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kankan banta ano ma yunampin baré intin Tiyarafenu ano mana avíaren mana ifá inten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kankan nanin mano ma vereti uvaran uviti yasamiyaré intin maen Tiyarafenu ano mana avíaren mana ifá inten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Máan tinten mifo siretíi Bafan ma erin nain damú ída afová ukha ompo yafíke vá bano! ");
INSERT INTO agd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tiretí ankan mai vá afová ono. Umoyan banta ano ma inuran má barákin nain áau ma má afoé ano ma afová uren máká ma yafían ákona uvintin maen umoyan banta ano ída kanaíen mai namun barákuren ódinten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Máan tukhen mifo siretí ankan ná utare vá bano. Mai fara vara seyo, siretí ma ída erinten mino se ininona yamúi Banta Anin mano erinten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Inte yoran banta anó kama ineine vákan kama yorarí iyan maen ná bei ayafa ano véin maman doran banta kayorá dafisiní uran báken ná dunan daíden amin áauí ma íkan ná mai yoran banta kéká daiman amé iyan nafino. ");
INSERT INTO agd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mai yoran ma kamaen doriyan baré intin ma vei ayafa ano ma ovaránen e onan nain doran banta ano vá kákan amusin ino. ");
INSERT INTO agd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Téi fura siré tiretí ankan tiamiyá uno. Ayafa ano mai yoran bantan maman kaintin benina yanasintará dafisinten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dafisinten mifo namu yoran banta ano maen beyan nan máa sinten mino, ‘Sesi ayafa vanta ano ayákái o van ída ainen ovaránen erinten mino’ siren maen ");
INSERT INTO agd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","50","arona yoran banta kéká ankamiyáken ma inká non naren óen iyain banta kayo vá oriven ma yunan nen non nen iyáken ma vei ayafa van ída erinten mino ma sen inin nain damúi erinten mino. ");
INSERT INTO agd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Eriven maen mai yoran banta sika sika uren tiantantin baya siren ma ída mai ánain dakhafin banta kéká bá báken ifí diyan aveantuntá inkekí piyan berai siyan banten mino. ");
INSERT INTO agd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Maí damú inaru yafisin mano siyan míkan arintai vaya an mi yanten mino. Mana vanta anasi iman amintéin béi eriyákan maen mai arinta kayo ano yaamu on uruaren mai ma anasií ono van iyain arinta amápin o ave inton oren mino. ");
INSERT INTO agd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Oren mifo yan manápá arintafin ída afova vákan inká dan manápá arintafin afova varen mino. ");
INSERT INTO agd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mai ma ída afova vain arinta máa ano karasin ída varanton daamu ana varen oren mino. ");
INSERT INTO agd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mai ma afova vain arinta máa ano yaamu variyan botorefin karasin banaaren oren mino. ");
INSERT INTO agd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Oríkan mai ma anasi iman ameno van iyain banta ano ída ainen eriyaimpin mai arinta kayo auu nan aiíkan auun baren oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Aun bakharen betí ankan iníkan inuran aúbaná mana vanta ano oovaren temí, ‘Anasi ma iman amin banta inka eren mifo varufá erafúbe avirano.’ ");
INSERT INTO agd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Máa siyain má minó arinta ano orun mantaven daamu avové en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Máan tiyákan afova ma ída vain arinta kéká ano afova ma vain arinta kayo máa sen tiamemí, ‘Tetinti yaamu yusimirí iyá umpo manáa karasin timeno.’ ");
INSERT INTO agd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Máa síkan mai ma afova vain arinta kéká ano evaránen betin tiamemí, ‘Ída ino. Ma karasin mano minó tetimpin ída kanaí inten mifo siretí ankan orive vá mai ma karasin kaiyain pimpá dosiriya miyaní ono.’ ");
INSERT INTO agd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Máa síkan mai ma afova ída vain arinta kéká ano karasin barano van orivíkan anasi ma iman amin nain banta ano eren mino. Eríkan mai ma útakhá ein arinta máa ano mai vanta vá anasií ono van ma yunan tamádan baré ein namumpin un pébin ona munken mino. ");
INSERT INTO agd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Munkurákan ínaimpáké ena arinta kéká ano enóben temí, ‘Kákan banta oe, kákan banta oe, setin ona yisintano!’ ");
INSERT INTO agd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Máa síkan betin evaránen tiamemí, ‘Téi fura siré tiretin tiamiyá uno. Tiretin ída afová ukhé uno.’ ");
INSERT INTO agd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Máan tukhein mifo vá Bafani erin damú bá áau vá tiretí ída afová ukha ompo yafían ná ákona ono. ");
INSERT INTO agd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Máa siren Yisasi evaránen temí, “Mana vanta ano ayá barufá orono van iyáken ma vei yoran banta kayo átaru uren ma veina yanasinta vetin amintin dafisino van ma einíi inaru yafisin mano ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mana mana yoran bantai avúavá bá ákona vá béi iniyáken moní daíden mana vanta yan manápá tauseni (5,000) moní amen inká ena vanta kan tauseni (2,000) moní amen ena vanta mana tauseni (1,000) moní amen uren béi me onen ena varufá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Máan turen béi orivíkan mai ma yan manápá tauseni (5,000) moní ma mantaré ein banta ano ainen mai monípó dóáken ena yan manápá tauseni (5,000) veni aman moní o yóáden mino. ");
INSERT INTO agd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Máan tíkan inká kan tauseni (2,000) moní ma mantaré ein banta vá ano mai monípó dóáken ena kan tauseni (2,000) aman moní o yóádan en mino. ");
INSERT INTO agd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Máan ten mifo mana tauseni (1,000) moní ma mantaré ein banta ano ve ayafai moní baren mo varafin úden aúpá masíen mino. ");
INSERT INTO agd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Mai yoran banta kékái ayafa vanta ano ayáká o varen ínaimpáké ovaránen eriven mai ma moní amikharé ein nan puntarano van aran eren mino. ");
INSERT INTO agd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Eriven dan manápá tauseni (5,000) moní ma mantaré ein banta ano ma ena yan manápá tauseni (5,000) moní bá ma yóan kova urákaré ein baren meren máa semí, ‘Kákan banta oe, onano. Éi yan manápá tauseni (5,000) moní ma simeonafó téi yódé ena yan manápá tauseni (5,000) vá maman kovaé uno.’ ");
INSERT INTO agd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Máa síkan beni ayafa vanta ano véin evaránen tiamemí, ‘Éi kama yoran bantan bákeya mai moníká kama e yafíbeya yoreóna kokhon danáká tékuya yafisin nompo eriveya sen má manafin amusin ono!’ ");
INSERT INTO agd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Máa siran kan tauseni (2,000) moní ma mantaré ein banta vá ano yere eriven mai ma ena kan tauseni (2,000) moní bá ma yóan kova urakaré ein baren meren máa semí, ‘Ayafa vanta oe, onano. Éi kan tauseni (2,000) moní ma simeonafó téi yódé ena kan tauseni (2,000) vá maman kovaé uno.’ ");
INSERT INTO agd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Máa síkan beni ayafa vanta ano véin evaránen tiamemí, ‘Éi kama yoran bantan bákeya mai moníká kama e yafíbeya yoreóna kokhon danáká tékuya yafisin nompo eriveya sen má manafin amusin ono.’ ");
INSERT INTO agd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Máa siran mana tauseni (1,000) moní ma mantaré ein banta vá ano eriven temí, ‘Ayafa vanta oe, éi ákona vantan bákeya éi ma ída yókaré eona yunan unafiyákeya inká éi ma ída ayun pafasikharé eona yunan duyasiyaona vantan baná téi afová ukhéi ");
INSERT INTO agd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","e nan pédé eni mana tauseni (1,000) moní barafin mo aúpá masí urakaré umpo ma ei moní ifo onano!’ ");
INSERT INTO agd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Máa síkan kákan banta ano evaránen béin tiamemí, ‘Éi avesara yoran banta ompo séi ma ída yokaréeruna yunan ma unafiyáké inká téi ma ída ayun pafasikharéeruna yunan ma yuyasiyáeruna mai máan in banta inó éi siya fono. ");
INSERT INTO agd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Máan tiyaruna ifo éi fará tenti moní ída moní ma kain namumpin kaenan baré irá ovaráné ma ereruna yamú tesi moní bá aman moní bá bare rafuno. ");
INSERT INTO agd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Mai vará mana tauseni (1,000) moní ma mantá ein banta vaípáke vá dafian mai ma siyan míkan tauseni (10,000) moní ma yákein banta vá ameno. ");
INSERT INTO agd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Para vara seyo, kokhon danasinta ma yantin baréin nain nanin bantan móeken aminten mino. Inká ída ma yakáin nain kéká ina mai sanáa ma yaká intin mai vá deren minó baranten mino.’ ");
INSERT INTO agd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Máa siren temí, ‘Mai namu yoran banta karú desin ná barufá títípa ukheimpin orun báken ná ifí diyan aveantuntá inkekí piyan bano.’ ");
INSERT INTO agd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Banta Anin ma erin nain damú bei kakhan má kantasí ukhein kin karáká kumamen enisori kayo vá erinten mino. ");
INSERT INTO agd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kumamen erintin maen enisori kayo ano minó nanin banta o éke e éke uan béi vaintá me átaru urantin sipisipirá dafisin banta ano ma sipisipi yo aíáden memé do aíáden iyainíi en kampintan daiminten mino. ");
INSERT INTO agd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Daíden sipisipi kayo ve ayan kurompá kaen inká memé kayo ve ayan ópá kaen inten mino. ");
INSERT INTO agd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Máan turantin maen kin mano ayan kurompá ma vain nanin banta máa sen tiamintemí, ‘Tifóe ano siretin nan amusin uren avábá ein mai ma vara ma araí ein tákéi inaru yafisimpin tiretin ninan utaan kaúantan baré ein mifo erive vá barano. ");
INSERT INTO agd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Para vara seyo, séi sirafan bákeya yunan timikhare ono. Téi non nan ékuya non timikhare ono. Téi enafá banta erékuya e amápin e sivían kae ono. ");
INSERT INTO agd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Téi suí dana san ékuya simikhare ono. Téin tíiyá bákuya sentá dafíkare ono. Inká téi karavusifin bákuya o sontare ono.’ ");
INSERT INTO agd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Máa sintin maen puntákein nanin banta ano evaránen béin máa sen tiamintemí, ‘Bafan noe, inte yamusá éi arafan nan ená dunan amiré non nan ená non amé é tife rafuno. ");
INSERT INTO agd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Inte yamusá éi enafá bantá erenará aviré teti simá ore rafuno. Inte yamusá éi auí dana san enará amikharé tiferafuno. ");
INSERT INTO agd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Inte yamusá éin aí iya vayá inká karavusifin bayá ukhenasá tetí ankan o oné tiferafuno.’ ");
INSERT INTO agd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Máa sintin maen kin mano evaránen betin tiamintemí, ‘Téi fura sé tiretin tiamiyá uno. Mai ma sen tifá tiváeyan ída aví bain kéká ká ma mai yanasinta variyaréeron mai sentái variyare ono.’ ");
INSERT INTO agd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Máan ma siren ayan ópá ma varéin nain kéka san kin mano máa sintemí, ‘Afeyoran nanin banta siretí ankan tifó uveya Ban Anon má bei enisori kéká bá ina ma ída kípan ira ma utaádan baré ein maifin ná orono. ");
INSERT INTO agd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Para vara seyo, séi sirafan bákeya yunan ída simikhare ono. Téi non nan ékuya non ída simikhare ono. Téi enafá banta erékuya e amápin ída e sivían kae ono. ");
INSERT INTO agd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Téi suí dana san ékuya ída simikhare ono. Téin tíiyá bákuya sentá ída yafíkare ono. Inká téi karavusifin bákuya ída o sontare ono.’ ");
INSERT INTO agd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Máan ma sintin maen betí ankan béin evaránen ina intemí, ‘Bafan noe, inte yamusá éi arafan nan eyá non nan eyá enafá bantá ereyá auí dana san eyá aí iya vayá inká karavusifin bayá ukhenará tetí ankan ída aya é tiferafuno.’ ");
INSERT INTO agd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Máan ma sintin maen béi evaránen máa sen betin tiamintemí, ‘Téi fura sé tiretin tiamiyá uno. Mai ma sen tifá tiváeyan ída aví bain kéká ká ma ída mai yanasinta variyaré eona mai sentái ída variyare ono.’ ");
INSERT INTO agd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Máa sirantin maen mai nanin banta ano ma namu miyan o varan nain mai ída kípan para van oriyan ma van nain aí danái varanten mifo funtákein nanin banta ano ída kípan para van oriyan ban aunan baranten mino. ");
INSERT INTO agd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yisasi ma mai vaya kayo sian kíparen maen bei eyo iyampon kayo máa sen tiamemí, ");
INSERT INTO agd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tiretí ankan afová ukha ono. Avo Uantan Damú ma afoká inain mai kan damú ana ein mi vetí ankan Banta Anin avían namuro ayampin kaintin béin daa unkamádantá arinten mino.” ");
INSERT INTO agd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Máan ma siyákan maen monó ánon banta kéká bá banasii ánon banta kéká bá ano mana monó ánon banta kékái ánon banta Kaiafasin amá átaru ukhen ");
INSERT INTO agd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yisasin ma kampun tiren pákaren aruan purin nain aa van aúpáké ten inen iyaren mino. ");
INSERT INTO agd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Máan tiyáken beti semí, “Banasi ano ódaren aruvin dákó inafo Avo Uantan Damú teti ída vá ma yanasí ó tifano.” ");
INSERT INTO agd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betaní amon dana aí bain banta Saimonin amá Yisasi varé íkan ");
INSERT INTO agd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mana nanin mano kama auna iyain uveri kákan miyantá bain mamaren mai namun un pében Yisasi yunan nan takhó akhempá kumanten dunan niyaré íkan auna uveri ánompin mun banaen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Máan tíkan eyo iyampon kayo ano ódaren ará namuen oreraen temí, “Pará béi auna uveri savifá afe iyan nafino. ");
INSERT INTO agd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ma kama aunka ma iyain uveri anan ma sarí uré moní mádé ona ma ída vain kéká ma ameren mino.” ");
INSERT INTO agd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Betí ma siyain baya Yisasi afová uren máa sen tiamemí, “Tiretí ankan pará ma nanin kakhirun ariyá ba rafono. Béi kama avúavasíi usintiyan mino. ");
INSERT INTO agd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ena ena yamúi ona ída van kéká tiretin má banten mifo séi ída siretin má ena ena vanté uno. ");
INSERT INTO agd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Anasi ano ma auna uveri ma sen turá bana iyain mai senti masípin orin mi úta sintiyan mino. ");
INSERT INTO agd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Téi fura siré tiretin tiamiyá uno. Ínaimpá ma kama vaya ma varen minó bara akhempá ma orera intin ma nanin ma varein avúava san tiren ininten mino.” ");
INSERT INTO agd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Maí damú tiyan míkan mifo sirantan kan orun kádan (12) eyo iyampon kayo fintena mana Yudas Iskariotin ne sin banta ano monó ánon banta kayo vaípá onóben ");
INSERT INTO agd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","betin máa sen mo inaemí, “Téi ma Yisasin avían amirékuya mae séin nái yanasá timinte rafono.” Máa síkan teti (30) siriva moní dankáan ben amen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Amirákan betí ayampin ma Yisasin avían amin nain aa van Yudasi araíen dosen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yisi Ída Van Bereti Ma Nan Omá Damú kayoi esé araí in damú eyo iyampon kayo ano Yisasi vaintá eriven máa sen inaemí, “Intefasá mo funtáádesá tetí Avo Uantan Dunan mo nanté tiferafuno.” ");
INSERT INTO agd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Máa síkan Yisasi evaránen betin tiamemí, “Tireti kákan Yerusaremí barufin orive mana vanta ma onante máa se vá mai vanta siameno, ‘Tesi yamú inka ádé iyái sesi eyo iyampon kayo vá en amápin mo Avo Uantan Dunan naran muno sen arú ano semantino’ vá teno. ");
INSERT INTO agd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Máa siran mai ma Yisasi siameiníen beni eyo iyampon kayo ano mo Avo Uantan dunan puntááden mino. ");
INSERT INTO agd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Máan turan inúpákesí iyain má tiyan míkan mifo sirantan kan orun kádan (12) eyo iyampon kayo vá dunan nan takhoká Yisasi kumamen dunan niyáken temí, “Téi fura siré tiretin tiamiyá uno. Tiretin pinté mana ano sesi namuro ayampin téin tivían kain nono.” ");
INSERT INTO agd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Máa síkan minó eyo iyampon kayo ano mai vaya iníden arunan en orera iyáken mana mana ano máa sen Yisasin inaemí, “Bafan noe, ída sen ne sin nono.” ");
INSERT INTO agd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Máa sen orera iyákan béi evaránen temí, “Ma ma sen má ma ayan kain ma yunan dókifin araviyain mai anon téin namuro ayampin tivían kainten mino. ");
INSERT INTO agd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tiyarafenu ano vompon dókifin tikharé einíen Banta Anin mano furinten mifo Banta Anin ma namuro ayampin ma avían amin nain banta ano kákan uman uron mi varanten mino. Be anóe ano véin ída kaen baré intin mai kama inté ein mino.” ");
INSERT INTO agd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mai ma namuro ayampin ma Yisasin kain nain banta Yudasi ano máa sen béin inaemí, “Aru soe, séin nará tiya fono.” Síkan Yisasi véin tiamemí, “Eyantái se ono.” ");
INSERT INTO agd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Betí ankan ma niyákan Yisasi mana vereti orun máden Tiyarafenu susu siantáden kisiren eyo iyampon kayo amiyan temí, “Ma séin tu ifo siretí ankan máde nano.” ");
INSERT INTO agd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Niyákan mana uvaini kápi orun máden Tiyarafenu susu siantáden temí, “Tiretí ankan minó ano ma finte vá nano. ");
INSERT INTO agd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Para vara seyo, senti nare ma vanain nain manon minó nanin bantai ume arúantáden tiretin má ma manafin kasen ban maman ákona inten mino. ");
INSERT INTO agd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Téi siretin tiamiyá uno. Marákéi séi ída uvaini anu nan oriyaré maéi Sifóeni yafisimpin mi siretin má manafin auyen uvaini anu nanté uno.” ");
INSERT INTO agd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Máa siran betí ankan mana monó ií daren kákan baru me ampiren Orifí anufá oren mino. ");
INSERT INTO agd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Oriven Yisasi vei eyo iyampon kayo máa sen tiamemí, “Tare inuran manan minó daná ten turá afoká intiya ma oniyasin mi siretíi mumunan eravinten mino. Mai van Tiyarafenui vompon dókifin máa sikhen mino: “‘Téi sipisipirá dafisin banta arurékun sipisipi kéká meren asuse en karan orera inten mino.’ ");
INSERT INTO agd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Máan tinten mifo séi evaráné e mantaaré tiretin an uanté Karirifá oronté uno.” ");
INSERT INTO agd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Máa síkan Pita evaránen béin tiamemí, “Éin aurá ma mai yaná afoká intin ma vetíi mumunan eravintin ma éin me ampiren karan orera intí maé téi ída uron mi éin me ampenté uno.” ");
INSERT INTO agd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Máa síkan Yisasi evaránen béin tiamemí, “Téi fura siré éin tiamiyá uno. Tare inuran manan kokore ída asikhantiya kanú manaú dádá ten nan ída afová ukhé uno sin nono.” ");
INSERT INTO agd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Máa síkan Pita véin tiamemí, “Ída ino. Téi en má purono van pasé ída éin afová ukhé uno, sé ída uron mi senté uno,” síkan minó eyo iyampon kayo ano máan baya ana sen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yisasin má bei eyo iyampon kayo vá mana Ketsemani se siyain dunan anafin oriven maen betin tiamemí, “Tiretí ankan mará kumante sirá téi mesápá orivé mo simúkono.” ");
INSERT INTO agd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Máa siren Pita má Sebetin anin kanan má avíaren oriyáken be au kasiyan avádúan onákan ará uman den ben aufá ída kamaen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Máan tiyáken betin tiamemí, “Téin tirá ma uman diyain mano ádé anantá téin tiruan purirí iyá umpo siretí ankan mará ten má ba vá dafiseno.” ");
INSERT INTO agd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Máa siren béi manáa nentá oriven barará o mátimen auná bara finí uren máa sen amúkemí, “Téin Tifóe oe, éi kanaí ma ukhantiya mai kápi sen pintena yo varano van mi séi iyá umpo éi ída vá tenti sinunu yakhafono. Ei anunu ana vá dakhafono.” ");
INSERT INTO agd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Máa sen amúkuren Yisasi evaránen kanú manaú eyo iyampon baintá oriven onan auun bakharé íkan Pitan inaemí, “Ídá mana áau rá ten má dafíke onante rafono. ");
INSERT INTO agd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Akhenókain tiretimpin afoká intiya erave ankamin nampo siretí ankan dafíke vá amúkiya vano. Aú ano mai yana san asese ukhan mifo yan bukhafafin ída ákona van mino.” ");
INSERT INTO agd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Máa siren béi evaránen oriven máa sen amúkemí, “Tifóe oe, mai kápi ma ída yo vararí intí maé téi nanté umpo mai ei anunu ánain ná bákurono.” ");
INSERT INTO agd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Máa sen amúkuren ovaránen bei eyo iyampon kayo vaintá eriven onákan betin auunan ai eimpin auun bakharen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bakhan béi evaránen kanú manaú dádasí en oriven mo mai ma amúkein amúkirí anaen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Amúkuren béi evaránen eyo iyampon kayo vaintá oriven máa sen betin tiamemí, “Tiretí ankan aun ná bakhé bayá avíkiyá ba rafono. Onano. Ume vanta kayo ayampin ma Banta Anin ma kain nain áauí inka en mino. ");
INSERT INTO agd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mantá oró tifano. Namuro ayampin ma séin tivían kain nain banta masi inka eriyan mino.” ");
INSERT INTO agd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisasi mai vaya fara siyákan tiyan míkan mifo sirantan kan orun kádan (12) eyo iyampon kayo finte Yudasin ne sin banta eren mino. Monó ánon banta kéká bá banasii ánon banta kayo vá ano siantan kokhon banta ano sópe vá karápuna vá bariyan uaren béin má eren mino. ");
INSERT INTO agd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudasi ano ma Yisasin aní intin pákan nain nan pefá máa sen tiamikharen mino, “Téi ma mo amónanuna vanta mai Yisasi ifo vá mai vanta vá pákano.” ");
INSERT INTO agd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Máa sirákaren béi manádá ainen Yisasi vaintá oriven temí, “Aru soe, inuran mino.” Siyan béin amónen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Dafayoriyain má Yisasi máa sen béin tiamemí, “Tirona oe, éi ma varano van ereona yaná aine varano.” Máa siyain má minó banta ano Yisasi vaintá oriven bein páken mino. ");
INSERT INTO agd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pákiyain má mana vanta ano Yisasin má baren tópe orun danúaren mana monó ánon banta kékái ánon bantai yoran banta átaren tíkaan kurúdan barará eraven mino. ");
INSERT INTO agd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Eravíkan Yisasi máa sen béin tiamemí, “Ei sópe evaráneya veni anamumpin kuferano. Tópefó ma aruvin banta kéká tópe anon arintin purinten mino. ");
INSERT INTO agd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Téin nan ída kanaíen Tifóe vaípá ina intin kokhon tauseni enisori kayo siantantin eriven téin tiya inten minó té tiretí iniya rafono. ");
INSERT INTO agd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Téi ma máan tékun maen Tiyarafenui vompon dókifin ma séin turá afoká ino van ma siká ein baya ano ída kanaíen afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mai áaurá ana Yisasi mai vanta kéká máa sen tiamemí, “Téi mana aau vantá bákuyá tiretí ankan téin pákano van tópe vá karápuna vá mamareyá ere rafono. Ena ena yamú ma séi monó dafufin báké banasi monó baya siamiyákeya fará mai rákena séin ída fáke rafono. ");
INSERT INTO agd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sakhanampa vanta ano ma vompon uvamádan baré ein mai kanái ino van mi mai yanasinta afoká en mino,” Yisasi ma máa sirákan maen minó eyo iyampon kayo ano Yisasin me ampiren karan oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yisasi ma fákein banta kayo ano véin aviren monó ánon banta kékái ánon banta Kaiafasin amápin mo khaen mino. Mai namumpin man baya ma afová ukhein banta kayo vá banasii ánon banta kéká bá ano átaru ukharen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Átaru ukhan Pita ano Yisasin bákuren oren mifo ída áde orinton nen táké en oriaren monó ánon banta kékái ánon bantai yafufin ódiven inte yanasá Yisasin aurá afoká inten nafi mai onano van dafisin banta kéká bá un kumanen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Monó ánon banta kayo vá Kanisori kéká bá ano Yisasini mana aau yosiré mai anará béin aruan purono van kampun baya sin banta kéka san dosen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Dosiyákan kokhon banta kayo ano eriven kampun baya kayofó ben aufin kurádiyan ten mifo ída mana aau kanaíen tian afoká uren mairá béin aruan purin nainíen mino. Máan tiyákan ínaimpáké kan banta ano eriven ");
INSERT INTO agd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","máa semí, “Ma vanta ano Tiyarafenui kákan monó namun nan ‘téi kasaé barákuré kanú manaú damú ana evaráné uvaranté uno,’ sikharen mino.” ");
INSERT INTO agd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Máa síkan monó ánon banta kékái ánon banta ano e mantaven Yisasin máa sen inaemí, “Ma ma éin aufin kuráden tiyain baya kayo van éi náiesá tinte fono. Éi ídá mana vaya anona evaráne sinte fono.” ");
INSERT INTO agd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Máa síkan Yisasi ída mana vaya seimpin monó ánon banta kékái ánon banta ano véin tiamemí, “Para ma ayun ban oriyan bain Tiyarafenu avíkasá éi fura seya setin tisimeno. Éi Tiyarafenu ano ma aní ukhein bantá bákeyá Ben Anin ná ba fono.” ");
INSERT INTO agd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Máa síkan Yisasi evaránen betin tiamemí, “Mai inka eyantái se ompo séi siretin tiamiyá uno. Ínaimpáké Banta Anin mano Minó Ákona Vain Tiyarafenui ayan kurompá kumamen inaru fáke konan daró erintiya onan nono.” ");
INSERT INTO agd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Máa siyain má monó ánon banta kékái ánon banta ano anú diyan bei au anamun bararó iyáken temí, “Béi Tiyarafenui varun bariyan mino. Tiretin má inikhen nan mi véi Tiyarafenui varun barein beyantái aau varanten mifo nái vará tetí ankan enádá bá manáa vanta arékun ná béini aau me sian amá inten nafino. ");
INSERT INTO agd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ída ino! Tiretí ankan inte esá té iniya rafono.” Máa síkan betí ankan oovaren temí, “Béimpin aau van mifo vá arin purino!” ");
INSERT INTO agd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Máa siren Yisasin aufen akhare siyan ayan daná ankamen mino. Inká ena kéká ano ápa ankamiyáken temí, ");
INSERT INTO agd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Éi seya Tiyarafenu ano aní ukhein banta uno séiya ompo inte vanta kayo anó éin ankamiyan nafi mai kayo aví éi sakhanampaí eya setin tisimeno.” ");
INSERT INTO agd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Máan tiyákan mai yafufin Pita kumantaré in mana yoran arinta ano veni áde eriven máa semí, “Kariri fáke vanta Yisasin má éi nore ono.” ");
INSERT INTO agd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Máa síkan Pita minó banta avorá temí, “Ída ino. Mai ma éi siyaona vaya séi ída afová ukhé uno.” ");
INSERT INTO agd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Máa siren ínaimpáké béi yafu onará oríkan ena yoran arinta ano ven ódaren mairá ma varé ein nanin banta máa sen tiamemí, “Ma vanta maen Nasaretíke Yisasin má baré ein banta ino.” ");
INSERT INTO agd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Máa síkan Pita evaránen asiká ayan befio uren temí, “Pura ódino! Téi ída mai vanta afová ukhé uno!” ");
INSERT INTO agd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Máa siren manáa vákan mairá ádé ma mantakharé ein banta kayo ano Pita vaintá eriven máa sen tiamemí, “Pura seya éi mai kéká pintena vantan banan en amen avaya ano éin inka maman dákó en mino.” ");
INSERT INTO agd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Máa síkan Pita ákonaen tiyáken, “Téi ída mai vanta afova ukhé umpo séi ma ída fura sékun maen ná Tiyarafenu ano séin uman timino,” ma siyain má ana kókore asen mino. ");
INSERT INTO agd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kókore ma asiyain má Yisasi ma sikhá ein baya Pita ovaren me inen mino, “Kokore ma ída asikhantiya éi kanú manaú dádái sen nan ída afová ukhé uno sin nono.” Pita mai vaya ovaren me iniren barufá aravuven kákan ifíden mino. ");
INSERT INTO agd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Do khakhiyain má pe ákura suron monó ánon banta kéká bá banasii ánon banta kayo vá ano Yisasin ma aruan purin nain baya sian damuáden mino. ");
INSERT INTO agd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Máan turan ínaimpáké ben ayantá damuren aviren kamanini ayafa vanta Pairotin ayampin mo khaen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Namuro ayampin ma Yisasin amein banta Yudasi ano onákan kó tiantáden Yisasin aruan purono van iyaimpin béi arunan iyáken kokhon ineine uvákon mai ma monó ánon banta kéká bá banasii ánon banta kayo vá ano ma teti (30) siriva moní ma amikharé ein evaránen baren betin mo ameno van oren mino. ");
INSERT INTO agd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mo amiyáken temí, “Ída mana aau vain bantan téi umeíéi siretin ayampin kaé uno.” Síkan betí evaránen béin tiamemí, “Mai éin nina yaná ifo ída setin tina yaná ino.” ");
INSERT INTO agd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Máa siyaimpin Yudasi mai siriva moní baren kákan monó namumpin mo karúdaren beyantá mo anan aren mino. ");
INSERT INTO agd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Monó ánon banta kayo ano mai siriva moní mamaren temí, “Ma moní mai vanta aruan purintáke miyan mifo setí ankan ída vá monó namunpintena moní bá manafiní erá man baya yurafuró tifano.” ");
INSERT INTO agd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Máa siren betí ankan baya sian damuaren bara kave ma uvaran banta kayo fintena mana vara miyaní uren mai vara maman enafáke vanta kayoi vanta masí in baraíen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Máan turákan mai van mi mai vara aví den Nare Eravukhein Bara e sikhan mi saréa yere fara máa sen aví tiyan mino. ");
INSERT INTO agd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Máan ma ein manon pefá ma sakhanampa vanta Yeremaiyan oorá ma Tiyarafenu ano siádan baré ein mi fura sen afoká en mino. Béi máan mi sikharen mino: “Isareri kéká ano mai vanta teti (30) siriva monípói miyaní onté uno siren ma yan baré ein moníi vetí ankan baren oren mi ");
INSERT INTO agd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bafan mano ma sisimikhá einíen mi mai monípóké bara kave uvaran banta kayoi vara o miyaníen mino.” ");
INSERT INTO agd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Máan tiyákan kamanini ayafa vanta Pairotin avorá Yisasi o mantavin béin inaemí, “Éi Yutan kayoi kin na fono.” Síkan Yisasi evaránen tiamemí, “Eyo. Mai inka eyantá te ono.” ");
INSERT INTO agd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Máa síkan monó ánon banta kéká bá banasii ánon banta kayo vá ano kokhon bayafó Yisasin aufin kuráden ten mifo véi ída mana vaya anona evaránen ten mino. ");
INSERT INTO agd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ída mana vaya siyaimpin Pairoti ano evaránen béin inaemí, “Ara ara vaya kayofó ma éin aufin kuráden ma vetí ankan tiyain mai éi ídá iniya fono.” ");
INSERT INTO agd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Máa síkan Yisasi ída mana vaya anona evaránen Pairotin tiamiyaimpin béi kákantá anomé inen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ena ena oranará Avo Uantan Dunan ma Nan Damú ma erin maen banasi ano ma aví tein karavusin kamanini ayafa vanta ano útúantan oré iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Maí damú mana kákan aau vanta Barabasin ne sin karavusifin bákan banasi ano afová ukharen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Máan tukharé íkan banasi o átaru uvin Pairoti ano inaemí, “Iyen ná útúantékun ná tireti vaípá orino vará iya rafono. Barabasin nafi áa Tiyarafenu ano ma aní ukhein banta Yisasin nafino.” ");
INSERT INTO agd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mai fara va Pairoti ano máa sen inaen naino. Béi afová ukhan monó ánon banta kéká auuyaniyáken Yisasin ará namu uantiyan kópin aviren erikhan mino. ");
INSERT INTO agd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Máa siren ma véi ma kó inin karáká kumantan maen be aná ano mana vaya máa siádan eremí, “Éi ída vá mai ma aau ída vain banta aurá mana avúavasí ono. Téi sare inuran mana kain ódákékun tirá uman diyá ineine iyá bá uno.” ");
INSERT INTO agd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Máa sirákan maen Barabasin ifáesin erinti vá Yisasin aruan purono vá teya Pairotin tiameno siren monó ánon banta kéká bá banasii ánon banta kayo vá ano vanasi arápiníen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Máa siyákan kamanini ayafa vanta ano vetin inaemí, “Tiretí ankani anunu ano má kan banta finte inte vantá útúantékun ná orinten nafino.” Máa síkan minó nanin banta ano oovararen temí, “Barabasi ná útúantano!” ");
INSERT INTO agd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Máa síkan Pairoti ano vetin inaemí, “Mai Tiyarafenu ano ma aní ukhein banta Yisasin intesá ino vará iniya rafono.” Máan ma siyain má minó ano oovararen temí, “Daa unkamádantá béin arono!” ");
INSERT INTO agd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Máa síkan Pairoti ano vetin inaemí, “Para vae. Béi nái auisá ukhen nafino.” Máa siyan mifo vetí ankan avádóden oovararen temí, “Daa unkamádantá béin arono!” ");
INSERT INTO agd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Avádóden oovariyáken Pairotin avaya ída iniríen banasi ano aruvin ádé eimpin béi manáa non dáden betin avorá be ayan tesé uren temí, “Ma vantai nare ano ída sen tiyantá banten mifo mai siretin nina yaná ino.” ");
INSERT INTO agd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Máa síkan minó nanin banta ano evaránen oovararen tiamemí, “Béini nare ano áesin ná tetin tina yanasá baren ná tetin tikhafanafin ná bano.” ");
INSERT INTO agd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Máan turen Pairoti ano Barabasin útúantan betí baípá oríkan inká aruvin banta kayo van tíkan Yisasin anan dafiyópó ankádan daa unkamádantá arino van betin ayampin amen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Amíkan kamanini ayafa vantai aruvin banta kéká ano kamanin amápin Yisasin aviren múden minó ano ven maman aúban kaúden iyen eúken mino. ");
INSERT INTO agd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iyuven beni au anamun do yaváden mana nararé au anamun maman uanten mino. ");
INSERT INTO agd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Uantáden betí ankan mana ayankun anan máden anouren damuan kini kamamó ma einí uren ben ánontá afu uanten mino. Afu uantáden mana ayonta maman ayan kurompá pákaantáden aron kanan durafúden mátimiyan máa sen ben máká maáká iyan temí, “Yutan kayoi ákona kin noe, en aví daní iyá tiféuno!” ");
INSERT INTO agd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Máan turen ben aufen akhare siren mai ma véin ayampin pákaantan baré ein ayonta máden ben ánontá kokhon dádá ankamen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Betí ankan minó ano véin máká maáká uren mai ma nararé au anamun ma uantákaré ein do yaváden beni au anamun evaránen uantáden daa unkamádantá aruan purono van aviren oren mino. ");
INSERT INTO agd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Aviren oriyaren Sairiní baru rákeSaimonin ne sin banta ano aasá eriyá íkan aruvin banta kéká ano ódaren béin duvun íkan Yisasini yaa unkamádan ayaen baren oren mino. ");
INSERT INTO agd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Baren Korkota e ma siyain barurá o unen mino. (Mai ví ma yákein mai Ánon Dampai Varu inon tikhen mino). ");
INSERT INTO agd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mairá moren betí ankan aí barasin uvarano van uvaini non máden mana íta yaná bá opé uren Yisasin amíkan béi naan óden mai non ifá en mino. ");
INSERT INTO agd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aruvin banta kéká ano Yisasin daa unkamádantá antópó aruren maen beni au anamun barano van mairá kati sen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Máan turen mairá kumanten bentá dafíken baren mino. ");
INSERT INTO agd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Béin ma kó tiantein baya máa ven ánontá bompon uvaman kain baren mino. Mai vaya máa sen uvantaren mino: “MA YUTAN KAYOI KIN YISASI INO.” ");
INSERT INTO agd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yisasini ádé umoyan bantá kanan arukharen mino. Mana anon ayan kurompá ma vain daa unkamádantá aren inká ena anon ayan ópá ma vain daa unkamádantá aren ukharen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Máan turákan banasi ano ma onóbe enóbe iyáken béin ayanavan baya siyáken maen ánon karú darú iyan ");
INSERT INTO agd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","temí, “Éi eyantá eyan aya ono. Éi kákan monó namun barákureya kanú manaú damú ana evaráne uvaran banta ono. Éi fura seya Tiyarafenu Anin ma vanteya mai yaa unkamádan táké me ampire varará erano.” ");
INSERT INTO agd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Monó ánon banta kéká bá man baya ma afová ukhein banta kayo vá banasii ánon banta kéká bá ano yere máan mana sen ayanavan baya semí, ");
INSERT INTO agd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Béi ena kayo anan aya iyaren mifo véi ída kanaíen beyan aya iyan mino. Béi Isarerii kin ma vanten maen áesin daa unkamádan me ampiren erantí maéi setí ankan bentá mumunan ó tifantéuno. ");
INSERT INTO agd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Béi Tiyarafenurá mumunan iyáken mi sen téi Tiyarafenu Anin muno siyaren mifo Tiyarafenu ano ma ven nan ma anunu ukhanten maen áesin mai saréa véin kanaíen aya ino. ");
INSERT INTO agd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mai ma umoyan bantá kan ma yaa unkamádantá ben má aruran baré ein kanan mano yere vá béin ayanavan baya ana sen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Bayan aúbanasí íkan ma vara minó dun maren títipa ukhen ban áau eraven kanú manaú áauíen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kanú manaú áauí irí iyákan Yisasi avádóden ovaraaren máa semí, “Eri, Eri rema sabaktani?” Mai vayai ana máan mi ukhen mino. “Tenti Tiyarafenu oe, senti Tiyarafenu oe, éi fará téin oyan timiya fono. ");
INSERT INTO agd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Manáa vanta ma mairá ádé mantakhá ein kéká ano mai vaya iniren temí, “Ma vanta ano Iraiyan mi ariyan mantino.” ");
INSERT INTO agd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Máa siren mana ano savaen oren mómofen ma einí ukhein daná o máden uvainifin kain maifin pébin mana yankará damuren Yisasi nano van kain óden mino. ");
INSERT INTO agd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kain ma ódiyákan manáa ano semí, “Iraiya ano véin me aya inain pimpá ifo áúke ódaré ono.” ");
INSERT INTO agd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yisasi enádá avádóden oovariyain má beni aunan kípan puren mino. ");
INSERT INTO agd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mai áaurá ana kákan monó namumpin ma kuran baré ein davaráe ano yanté kafasen barápá morúden maman kaníen mino. Máan tíkan bara khaya iyain má kákan onámaná kayo ma varé ein kauren oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Máan tiyain má banta masí kayo khayosen oriaren duvavin Tiyarafenui kantasí ukhein nanin bantai ma fefá púkaré ein kéká ano e manten mino. ");
INSERT INTO agd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ínaimpáké Yisasi ma evaránen e mantavíkan maen betí ankan masí me ampiren kantasí ukhein baru Yerusaremí afoká íkan kokhon mano vetin onen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aruvin banta kayoi ayafa vanta vá aruvin banta kéká bá ano Yisasintá dafíkaren onákan bara khayain minó danasí iyaimpin moéken kákantá akhokho van uren beti máa semí, “Ma vanta fura sen Tiyarafenu Anin mi varen mino.” ");
INSERT INTO agd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kokhon nanin kayo ano ma Yisasin aya ono van ma Kariri fáké béin bákuren erikharé ein nanin kayo ano manáa nentá mantakhen oniyan baren mino. ");
INSERT INTO agd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maifin ma mantakharé ein nanin kéká mai kákan baru Makdaráke Marian má Yemisin nú Yosepin nú anóe Maria má inká Sebeti anin kanan anóen mái varen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Inupasí iyákan Aramatiá baru rákena moní banta Yosepin ne sin mano eren mino. Béin má mai mana Yisasini eyo iyampon mi varen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Baren mi Yisasin au amintí barano van béi oren mo Pairotintá ina íkan Pairoti ano aruvin banta kayo van Yisasin au Yosepin ameno sen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosepi ano Yisasin au máden avusese en efanten ukhein davaráe fóké úke en mino. ");
INSERT INTO agd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Mai masí Yosepi ano manáa vanta kéká tíkan ompin boraádan baré íkan mai aimpin mo khauren mana kákan onámaná baébaé uan ain oyirá iyáden oren mino. ");
INSERT INTO agd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Makdaráke Marian má ena Maria má ano mai masí ádé kumanten oniyan baren mino. ");
INSERT INTO agd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sabati rákena yaná ma Útavin Damú orivíkan ená damú monó ánon banta kéká bá Farasisi kayo vá ano Pairotin o onen mino. ");
INSERT INTO agd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","O ódaren betí ankan máa sen ben tiamemí, “Kákan banta oe, mai kampun banta ano ma fara váken maen kanú manaú damú ma orivintí téi evaráné e mantanté uno ma sikharé ein baya van mi seti ovaré me ineine iyá tiféuno. ");
INSERT INTO agd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Máa sikhan mifo éi sesin ná masí oyirá ákonaen áta urantin ná kanú manaú damú orino. Ída ma máan tesin maen beni eyo iyampon kayo ano ven au e umoyan uaren béi inka evaránen purin pinté e manten mino sintin mai kampun baya ano fefá ma véi sikharé ein kampun baya esantaren mo kákaní inten mino.” ");
INSERT INTO agd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Máa síkan Pairoti ano evaránen betin tiamemí, “Tiretí ankan aruvin banta kéká tesin ná mai masíká dafisino. Tiretí oreya vá mai masíká ma ákona ono ma se iniyaona yanasisá mo ono.” ");
INSERT INTO agd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Máa sirákan betí ankan oren mo mai masí oyirá ákonaen áta uren aruvin banta kayo síkan mai masíká dafisen mino. ");
INSERT INTO agd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabati yamú kípavin esé araí in damú ákura suron áau eunono van iyákan Makdaráke nanin Marian má ena Marian má masíká onano van oren mino. ");
INSERT INTO agd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Oriyain má manádá kákantá bara khayá íkan Bafani enisori ano inaru me ampiren eraven masí oyi rákena onámaná do vaébaé uan kaúden mai yaró kumantaren mino. ");
INSERT INTO agd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kumantan mai enisori aufáke afayu ma fanu seiní iyákan inká beni auí daná ano efanten uron en mino. ");
INSERT INTO agd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Máan tíkan betí ankan oniyan avinantan nan iyain má mai ákona ano minó aruvin banta kéká do ankaman karúdan barará baren orera uven purin banta kayo an den mino. ");
INSERT INTO agd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Máan tukhan enisori ano maí kan nanin tiamemí, “Tiré kanan ída vá akhokho van ono. Mai ma yaa unkamádantá ma arein banta Yisasin nan doseno van mi eriyan ná téi afová ukhé uno. ");
INSERT INTO agd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Béi ída mafin ban mino. Pefá ma véi sikaré einíen béi inka e mantakhen mifo véi ma vakharé ein takhópin eriveya onano. ");
INSERT INTO agd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","“dare aine evaráne ore vá beni eyo iyampon kayo vá mo máa se siameno, ‘Béi inka furin pinté evaránen e mantakhein tiretin an uanten Karirifá o vantiya mai fákena o onan noná’ mai vaya siretin tiamintói eré uno.” ");
INSERT INTO agd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Máa síkan míkan nanin mano akhoko van uren ainen masí me ampiren beni eyo iyampon kayo siameno van amusin iyan tavaen oren mino. ");
INSERT INTO agd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Oriyá íkan Yisasi ainen manádá aasá afoká uven temí, “Ákurá ino.” Máa síkan míkan beni ádé oriven ben arantan bana fákaren míkan mano ventá monó tiyan aví daníen mino. ");
INSERT INTO agd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Monó tirákan Yisasi vékan máa sen tiamemí, “Tiré kanan ída vá akhokho van iyáke ore vá te sifá tiváeyan mo siamesin Karirifá oriven maifá kena vá ten tonano. ");
INSERT INTO agd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Míkan nanin mano ma oriyaintena aruvin banta kéká ma masíká dafíkaré ein pinté manáa ano kákan barufin ódiven mai ma afoká ein baya máa monó ánon banta kéká tiamen mino. ");
INSERT INTO agd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tiamíkan monó ánon banta kéká bá banasii ánon banta kayo vá ano mai aruvin banta kéká kokhon moní amiren ");
INSERT INTO agd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","temí, “Mana ano ma siretin inainti maeya máan ná teno, ‘Setí ankan inuran tuun baverunaren beni eyo iyampon kayo ano ven au e umoyan baren oren mino.’ ");
INSERT INTO agd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kamanini ayafa vanta ano ma mai vaya inintí maé tetí ankan mai vaya ven má puntádékuya sireti ída aau varan nono.” ");
INSERT INTO agd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aruvin banta kéká ano mai moní mamaren kákan banta kayoi vaya ánain dakhafen mino. Máan tíkan mai vaya ano minó Yutan kayofin orera uvin mai vaya sen eriyaré íkan taréa yere fara mai vaya sé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tiyan míkan mifo sirantan mana orun kádan (11) eyo iyampon kayo ano Karirifá oren Yisasi ma veti nan mai anurasá orono ma sikharé ein anurá o unen mino. ");
INSERT INTO agd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","O unaven ma vetí ankan Yisasin oniyáken bentá monó tiyan aví daníen mifo manáa ano kan ineine iyaren mino. ");
INSERT INTO agd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Máan tiyákan Yisasi veti vaintá eriven tiamemí, “Inaru ráke yaná bá bara ráke yaná bá dafisino van Tiyarafenu ano minó ákona séin inka simen mino. ");
INSERT INTO agd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Máan tukhein nará tiretí ankan oriveya vá minó nanin banta maman tenti eyo iyamponí ureya vá be Afóen má be Anin má beni Kantá Aunan má avíkasá betin monó non péantano. ");
INSERT INTO agd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Péantáde vá tiretin ma ameruna vaya kayo vá betin afova amiresin ná mai ánain bákurino. Téi fura sé tiretí ankan má ena ena yamú bá oriyá bákun mi yamú mo akhení inten mino.” ");
INSERT INTO agd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yisas Karaisi Tiyarafenu Anini kama vaya araí in máan mi ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sakhanampa vanta Aisaiyani vompon dókifin Tiyarafenu ano máa sen uvantaren mino, “Ineno! Téi vaya varen orin banta siantékun éin an uanten oren eni aa mo uvisinten mino!” ");
INSERT INTO agd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Kámá barafá mana vanta ano oovaren máa siyan mino, ‘Bafani aa uvíde vá beni aa funtarano.’” ");
INSERT INTO agd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aisaiya máa sikáin monó non péantan banta Yoni ano kámá barafá afoká uven temí, “Ará baéde non baresin ná Tiyarafenu ano siretíi ume ampiantano.” ");
INSERT INTO agd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Máa síkan Yerusaremí baru fáké bá Yudiá bara fáke nanin banta kayo vá ano Yoni vaintá eriven betíi ume sian páman urákan béi Yodení nompin monó non péanten mino. ");
INSERT INTO agd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Béi kameri ayo fóké uvaran au anamun uren kao au fóké amú anan uren báken panon má bonkampun anu vá niyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Niyáken béi máan mi siyaremí, “Ten toyampá ma eriyaini ákona ano senti ákona moéken esantakhen mino. Téi ída funtákeruna ída kanaí é matimé beni arantan anamun anan útufonté uno. ");
INSERT INTO agd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Téi non pokéi féantiyá umpo véi Kantá Aunan pokéi féantanten mino. ");
INSERT INTO agd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Maí damú Yisasi Kariri varafá Nasaretí baru fáké eríkan Yoni ano Yodení nompin béin monó non péanten mino. ");
INSERT INTO agd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Péantádan Yisasi non pinté e ayoren édiyan onákan inaru ona yivin kukhofá avúaváká ten Kantá Aunan mano véin ánontá eren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Erákan inaru fáké mana oova ano máa semí, “Éi sen tanin uron mono. Éin nan moeké tinunu ukheruna iyampon mi van ná timusin iyá uno.” ");
INSERT INTO agd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Máa siyain má Kantá Aunan mano Yisasin ainen tiantan banta ída van kámá barafá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Maifá foti (40) yamú o vákan Ban Anon mano Yisasi eraven ankan mino van akhenóka uan onen mino. Béi kámá barafá afá uraran kayo vá ana vákan enisori kayo ano ventá dafíkaren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Eroti ma Yonin karavusifin pákaan kaúdan maen ínaimpáké Yisasi Karirí barafá Tiyarafenui kama vaya siamen oren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Oriyáken temí, “Damú inka afoká íkan Tiyarafenui Yafisin inka ádé e van mino. Ará baéde vá Kama Vayará mumunan ono.” ");
INSERT INTO agd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Maná damú Yisasi Kariri non akhempá oriyaren onákan Saimonin má be afá Endurun má noyana van baseí iyaren mino. Mai fara va ino. Betí ankan noyana arin kékái váken baseí iyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Máan tiyaré íkan Yisasi vetin araren temí, “Ten má eresí aní ékuya noyana ma vaseí iyaonaí ureya vanasi avirano.” ");
INSERT INTO agd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Máa síkan békanan manádá base kayo me ampiyan béin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yisasi ma non akhempá manáa oriyan onákan Sebetin anin kanan Yemisin nú Yonin nú botifin base kayo yókiyan baren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dókiyaré íkan békan nan ariyain má betí afóe Sebetin má doran banta kayo vá me ampiren Yisasin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Betí ankan Kapeniamú barurá o varé íkan Sabati yamú ma afoká íkan maen Yutan nanin bantai monó átaru namumpin Yisasi ódiven monó baya siamen mino. ");
INSERT INTO agd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tiamíkan banasi ano iniren takhaen orera iyan temí, “Beni vaya ano Yutan kayoi man baya ma afová uhein banta kéká ano ma vaya seinisa iyan naino. Ída ino. Pura sikhein ákona vá ma vain banta ano ma seiníi iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Máa siyákan namu aunan ma vain banta ano mai monó átaru namumpin baren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Mai vanta ano vádiyan temi, “Nasaretíke vanta Yisasi oe, éi setin namu ono vará ere fono. Tetí ankan éin afová ukhékuya éi Tiyarafenui Mana Kantasí ukhaona uron mono!” ");
INSERT INTO agd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Máa síkan Yisasi mai namu aunan nan arankaan táden temí, “E avaya fákare véin pinté entavono!” ");
INSERT INTO agd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Máa siyain má namu aunan mano mai vanta máden dómeron uren me ampiren bádiyan oren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Máan tiyain má mai ma iyukhen oniyaré ein nanin banta ano sakha iyáken betiyan inain maran en temí, “Ma naísá iyan nafino. Ma auyen afovan bákan mai ákona fókéi namu aunan kayo yo siantiyan mai kéká ano véin oo yaiyiyan mino!” ");
INSERT INTO agd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Máan turákan Yisasi ma varein avúavá baya ano ainen Kariri varafá oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yisasi ma mai monó átaru namun me ampiren Saimonin nú Enduru nú amapin orin maen Yemisin nú Yonin nú bá béin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Oríkan betí ankan temí, “Saimonin aná anóen aí iyáken aufá ira kharo iyan bakhen mino” sen Yisasin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Máa síkan mai nanin ma vakhein ádé ódiven ayan bana fákaaren avían mantiyain má manádá aí kípavin mai nanin mano vetíi yunan taren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mai inúpá áau ma orun periyain má kokhon aí nanin banta vá namu aunan mano ma fákakhein kéká bá ina Yisasi vaintá aviren ere ere en mino. ");
INSERT INTO agd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Máan tiyákan Kapeniamú baru ráke nanin banta ano o vúten Yisasi ma varan nain avúavá onano van onará e átaru en mino. ");
INSERT INTO agd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Máan tuvin ara ara aí ma váein kayo ayofiyáken namu aunan ma fákakhá ein kéká pinte ina yo sianten mino. Máan ten mifo namu aunan kayo ano Yisasi iyé ban nafi mai véin afová ukhan pasen ída áíkan manáa vaya sen mino. ");
INSERT INTO agd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ená damú ída kakhakhan Yisasi fe ákura suron e mantaaren amúkono van banta i van kámá barafá beyaká oren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Orivíkan ínaimpáké Saimonin má manáa kéká bá Yisasin doseno van oren mino. ");
INSERT INTO agd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Oren ma o oman afoká uren maen temí, “Éin nan minó ano yosiyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Máa síkan Yisasi evaránen betin tiamemí, “Monó baya siameno van mi erikhé umpo erítifé ena varu kayo fimpá orivé maifá ina mo siameno.” ");
INSERT INTO agd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Máa siren Kapeniamú me ampíren Karirí barafá ma vain baru kayo fimpá oriven Yutan nanin bantai monó átaru namun kayofin monó baya siamiyáken kokhon nanin banta fintena yere namu aunan kayo yo sianten mino. ");
INSERT INTO agd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maná damú amon dana aí bain banta ano véin ayofano van Yisasin arantampin me aron kan durafúden temí, “Éi ma anunu iyanteya senti sí daná tiyofasintan nono.” ");
INSERT INTO agd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Máa síkan Yisasi arunan máden ayan dan orin au aruviyan temí, “Eyo, ayofé umpo aí daná kípano.” ");
INSERT INTO agd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Máa siyain má anan mai amon dana aí manádá kípen mino. ");
INSERT INTO agd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kípavin Yisasi mai vanta siantan oriyan ákona vaya siamemí, ");
INSERT INTO agd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ída vá ena nanin banta ma vaya siamiyáke funtáde ore vá monó doran banta aufasá mo aní ono. Máan ture fefá ma Mosesi sikhan amon dana aí ma vá ein kéká ano ma variyá ein avúavasí eya vá manáa yanasinta vare mo ákonte esin ná banasi ano mai ma aí kípein ná onano.” ");
INSERT INTO agd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Máa síkan mifo mai vanta ano oriven banasi avorá Yisasi ma véin aí ayofein baya mo siamin iniren minó nanin banta ano Yisasi vaintá eren mino. Máan tiyaimpin Yisasi ma minó baru kayo fimpá orono sikhá ein me ifá uren banta ída vain akhempá o vákan minó akhen páke nanin banta ano kasaen be vaintá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Manáa yamú ma orivíkan Yisasi evaránen Kapeniamú barurá o van mai vaya ano ainen mai varufin oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Orera íkan banasi ano o vúten mai ma váein namun e víkaaren onará ina ída afokhan bákan Yisasi monó baya siamen mino. ");
INSERT INTO agd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tiamiyákan kamí kamí banta ano ayan arantan púká ein banta kúkútafin kaúden aviren eren mino. ");
INSERT INTO agd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eríkan banasi ano víkakhan ída kanaíen Yisasi vaintá aviren orin nainí iyaimpin má nantá ódiven amompin kápóden anan póké kúkútará damuren mai aí banta Yisasi vaintá kain araven mino. ");
INSERT INTO agd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aravíkan Yisasi ma mai máa vantai mumunan ódaren maen mai ma ayan arantan púká ein banta siamemí, “Te sanin noe, eni ume ampianten mino.” ");
INSERT INTO agd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Máan tiyan maen maifin manáa man baya ma afová ukhein banta kéká ina kumantaren máan ineine en oreraen mí, ");
INSERT INTO agd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ma vanta ano fará máa siyan nafino. Béi Tiyarafenui oyampá baya siyan mino! Mana vanta ano ída kanaíen ume ampiantanten mifo Tiyarafenu veyafin mi mai ákona van mino!” ");
INSERT INTO agd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Máan ineine en orera iyákan Yisasi afová uren betin tiamemí, “Ma avúavá ma variyaruna van tiretí ankan pará Tiyarafenui oyampá baya siyan mino sé iniyara fono. ");
INSERT INTO agd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ayan arantan púká ein banta van inte vaya ma seruna anó teso sikhen nafino. Eni ume ampianté uno ma seruna ano fi áa orun mantave ei kúkúta mamare orono ma seruna ano fino.” ");
INSERT INTO agd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mai avúavá ma variyaruna anon Banta Animpin ma varará ákona vákan ume ampiantiyan mino sé aní iyá uno.” Máa siren Yisasi mai ma ai ayan púká ein banta van temí, ");
INSERT INTO agd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Aí daná kípen mifo mantave ei yuvasí mamare varufá orono.” ");
INSERT INTO agd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Máan ma siyain má mai vanta ano orun mantaaren duvasí mamaren mai ma oniyaré ein nanin banta yo éka náka iyáken oren mino. Mai ma iyukhá ein nanin banta ano mai avúavá ma oniyáken, “Máan avúavá tetí ankan pefá ída ontaré eruna yanái afoká en mino!” siyáken Tiyarafenu aví daníen mino. ");
INSERT INTO agd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Máan turen Yisasi evaránen non akhempá oríkan banasi ano ve vaintá o iyuvin monó baya siamen mino. ");
INSERT INTO agd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tiamíden oriyaren ma Arafiusin anin Rivain onákan takisi varan namumpin kumantaréin maen béin ariyan temí, “Tesi eyo iyamponí in nompo ereno.” Síkan béi e mantaaren Yisasin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mai inúpá Rivai ano Yisasin má bei eyo iyampon kayo vá arákan be amápin mo yunan niyan maifin takisi varan banta kéká bá ume nanin banta vá inan baren mino. Máan avúavá bá bain nanin banta vá dere anon Yisasi ma oreipá bákuren noren mino. ");
INSERT INTO agd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mai kéká bá ma Yisasi yunan niyákan man baya afová ukhein Farasi khayo ano Yisasini eyo iyampon kayo ina iyan temí, “Para Yisasi sakisi varan banta kayo vá ume nanin banta vá manafin dunan niyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mai ma ina iyain baya ma Yisasi iniyáken betin tiamemí, “Aí ma vain nanin banta ano anan ayofan banta vaípá oré iyan mifo ída ma aí bain nanin banta ano ída ayofan banta vaípá oré iyan mino. Puntákein nanin banta arano vara erikhe raumpo ume nanin banta arano van mi eriké uno.” ");
INSERT INTO agd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yonini eyo iyampon kayo vá Farasisi kayo vá ano yunan auraren bákan maná damú manáa nanin banta ano Yisasi vaintá eriven béin inaemí, “Yonini eyo iyampon kayo vá Farasisi kayo vá ano yunan auraren ban mifo fará ei eyo iyampon kayo ano ída yunan auriyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Máa sen ina íkan Yisasi evaránen betin tiamemí, “Mana vanta ma anasi iman ameno van iyan maen mai omápin ma arakhá ein kéká ano yunan auré iyan nafino. Anasi iman amin banta vá ma váken ída kanaíen duna auranten mino. ");
INSERT INTO agd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Maná damusí intin anasi iman amin banta ma aviren orivintin maen dunan auranten mino.” ");
INSERT INTO agd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Máa siren temí, “Mana vanta ano ída auyen davaráe kafádan póké peyante yavaráe ma yákakheimpin mo yamparen amu é iyan mino. Auyen davaráe fóké ma yamparen amu urantin o fáke e fáke uaren kákantái yáken orera inten mino.” ");
INSERT INTO agd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Inká auyen uvaini anu kháan peyante memé aufin ída khaé iyan mino. Peyante memé aufin ma auyen uvaini anu khaintin maen paútiaren eravin nain nan mino. Auyen uvaini anu káan auyen memé aufin mi khaé iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mana Sabati yamú ma Yisasi má bei eyo iyampon kayo vá arokhú dunampin oriyan maen bei eyo iyampon kayo ano arokhú ankanen oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Máan tiyákan Farasisi kayo ano ódaren Yisasin tiamemí, “Sabati yamú ma arokhú ankaniyain mai ída vá doran barano sikhein damúi vakan man bayan durafuriyan mino. Mai ída ma máan toren mino.” ");
INSERT INTO agd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Máa síkan Yisasi evaránen betin tiamemí, “Deviti má bei kéká bá arafan puríkan ma mantá ein avúavá tiretí ankan bompon dóki finte ídá dankádé afová ukhe fono. ");
INSERT INTO agd_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiata ma monó ánon doran pákakhein damú béi Tiyarafenui mápin un pében monó ánon doran pákakhein kéká ano ana kantasí ukhein bereti niyain un máden niyáken bei kéká amin nakhen mino. Máan ma ein mai man baya yeren durafunten mino.” ");
INSERT INTO agd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Máa siren betin tiamemí, “Banasi aya ino van mi Sabati uvádan ban mifo vanasi ano Sabati aya ono vara uvamádan ban naino. Ída ino. ");
INSERT INTO agd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mai van mi Banta Anin mano Sabatii Bafan ban mino.” ");
INSERT INTO agd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ená damú Yisasi evaránen Yutan nanin bantai monó átaru namumpin ódíkan aiayan púkein banta ano maifin baren mino. ");
INSERT INTO agd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Maí damú Sabati varé íkan Yisasin nan manáa avúavá mádantí béin aufin pákaan kaono van ben ma namuroí uantiyain kéká ano sen inen uaren béintá dafían ákona ukharen mino. ");
INSERT INTO agd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Máan tukhan Yisasi mai ma aiayan púkein banta siamemí, “Minó avorá mará e mantano.” ");
INSERT INTO agd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Máa siren Yisasi vetin inaemí, “Sabati yamú ma kama avúavá mamantan manó kama ukhen nafi áa namu avúavá ma mamantan manó kama ukhen nafino. Má damú banta aruan puró tifante rafuno áa ayaó tifante rafuno.” Máa síkan betí ankan baya ída sen mino. ");
INSERT INTO agd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Máan tiyaimpin Yisasi onen eúkiyáken betin ará ákona ukhan aran daná máden mai ma aiayan púkein banta van temí, “Ayan antúkano” síkan ayan antúkiyain má evaránen ayan kamaen mino. ");
INSERT INTO agd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Máan tiyain má Farasisi kayo ano ainen e manten oren Erotini kéká bá mo Yisasin ma aruan purin nain aa van ten inen en mino. ");
INSERT INTO agd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yisasin má bei eyo iyampon kayo vá ano Karirí non akhempá oríkan kokhon nanin banta ano véin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yisasi ma variyain dana san ma vanasi ano inen Yudiáke safi Yerusaremíke safi inká Idumiáke safi Yodení non ufáke safi inká Taiya vá Saidoní akhen páke nanin banta ano fi mai ma variyain avúavá onano van ere ere en mino. ");
INSERT INTO agd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Máan tiyan kokhon nanin banta ano eyu akhempá bíkiyákan boti varen erino van Yisasi vei eyo iyampon kayo siamen mino. ");
INSERT INTO agd_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Maí damú kokhon nanin bantan ayofen mino. Máan ma iyain avúava san aí nanin banta ano Yisasin au aruvono van béi vaintá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Máan tiyákan namu aunan ma varé ein kayo ano Yisasin ma oniyáken béin anafin o ankamiyan bá diyáken, “Éi Tiyarafenu Anin mono” sen mino. ");
INSERT INTO agd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Máa ma síkan béi iyé ban nafi ída sian páman ino van Yisasi vetí ankan kákan airo ananí uanten mino. ");
INSERT INTO agd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ínaimpáké Yisasi anurá ódiven bei kékasí ma inain banta kayo arákan béi vaintá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Onóbin tiyan míkan mifo sirantan kan orun kádan (12) banta avíden béi má nóken monó baya varen orino van aposeri kéká ino sen aren mino. ");
INSERT INTO agd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Araren namu aunan ma yo siantan ákona vetin amen mino. ");
INSERT INTO agd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ma sirantan kan orun kádan (12) banta ma avirein kékái aví ino. (Ínaimpáké Pita ne sen ma arein banta) Saimoni ino. ");
INSERT INTO agd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebetin anin Yemisin nú be afá Yoni nu san Boanekesi ne sen mino. Mai víi ana maen aafa ma kankaré tiyain anin kanan nen tikhen mino. ");
INSERT INTO agd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Inká Enduru ne sen, Firipi ne sen, Batoromu ne sen, Matiu ne sen, Tomasi ne sen, Arafiusin anin Yemisi ne sen, inká Tadiasi ne sen, mana Seroti anan banta van Saimoni ne sen, ");
INSERT INTO agd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","inká (ínaimpáké ma namuro ayampin avían amin nain banta van) Yudas Iskariotin ne sen en mino. ");
INSERT INTO agd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ínaimpáké ma Yisasi evaránen béi ma varé ein namumpin ma oríkan kokhon nanin banta ano evaránen o átaru iyákan béi má bei eyo iyampon kayo vá ano ma yunan nan afokhan ída varen mino. ");
INSERT INTO agd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Máan tiyain baya ma Yisasini kéká ano iniren “béin nan óen mi iyan mino” siren aviré barufá orono van eren mino. ");
INSERT INTO agd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Eríkan Yutan kayoi man baya ma afová ukhein kéká ma Yerusaremíké erein kayo ano semí, “Beseburin ne sin namu aunani ánon banta anon béimpin báken mi namu aunan ma yo siantan ákona amiyan mi namu aunan do siantiyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Máa síkan Yisasi iniren betin aran eríkan baya o vaéden tiamemí, “Ban Anon mano kanaisá ená Ban Anon do siantanten nafino. ");
INSERT INTO agd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mana vantai yafisimpin ma yaíden aruvinten maen ída kanaíen ákona ukhen banten mino. ");
INSERT INTO agd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Inká mana namun pinté ma yaíden beraran aruvinten maen ída kanaíen ákona ukhen banten mino. ");
INSERT INTO agd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Inká Ban Anon mano ma veraran daiminten maen mai inté en ná mantaan ákona ukhen banten nafino. Ída ino. Máan ma inten ída ayáká banten mifo ainen mo kípanten mino.” ");
INSERT INTO agd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Máa siren ena vaya sian baéan amen temí, “Mana vanta ano ída kanaíen ákona vanta amá pintena ódiven beni ona umoyan baranten mino. Béin nare ma anan póké damuan kaúden manan beni minó ona umoyan baranten mino.” ");
INSERT INTO agd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Máan tukhái siretin pura vayan tiamenté uno. Minó ume khayo vá Tiyarafenu ma oyampá baya sin ume khayo vá Tiyarafenu ano kasaen ampiantanten mifo, ");
INSERT INTO agd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kantá Aunan ma oyampá baya sin ume ana ída kanaíen ampiantanten mino. Mai ume ano fara van oriyan banten mino.” ");
INSERT INTO agd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yutan kayoi man baya afova mantein kéká ano ma Yisasi nan “namu aunan mái va ono” ma sein nan mi mai vaya sen mino. ");
INSERT INTO agd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Máa siyákan Yisasin anóen má be afá kayo vá ano véi ma vain namun baintá eren mino. Barurá e iyuven Yisasin mun tiamintin barufá erantí béin má baya seno van baya yan óden mino. ");
INSERT INTO agd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kokhon nanin banta ano Yisasin maman aúban den iyukháin manáa vanta ano véin tiamemí, “E anóen má e afá kayo vá ano onano van barurá e iyukhen éin nan ina iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Máa síkan Yisasi evaránen inaemí, “Iyé ten tinóe vákan iye néné ten tifá tiváeyan ban nafino.” ");
INSERT INTO agd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Máa siren mai ma iyukhá ein nanin banta onen eúkiyáken temí, “Ma ma iyukhein nanin banta mai se sinóen má te sifá tiváeyan mái van mino. ");
INSERT INTO agd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Intéa nanin banta anó Tiyarafenui oo yaiyiyan nafi mai kéká pura sen te sintun mi van mino.” ");
INSERT INTO agd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yisasi evaránen Kariri non akhempá oriven monó baya siyákan kokhon nanin banta ano eyu akhempá o átaru en mino. Átaru iyaimpin botifin un kumamen manáa e afánen o váken monó baya siamiyan mino. ");
INSERT INTO agd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Máan tiyáken maen minó baya vaédiyáken banasi siamiyain pintena mana o vaeran baya máa semí, ");
INSERT INTO agd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ineno, Mana vanta ano yanayun mo fafa seno van oren mino. ");
INSERT INTO agd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Danayun ma mamaren oriyákan manáa ayun mano aa akhempá eravíkan nun kayo ano mai ma eravein aíen nen mino. ");
INSERT INTO agd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Manáa ayun mano manáa vara on daró baré íkan mai yaró eravukharen ainen orun ampamen mino. ");
INSERT INTO agd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ampantaré in ma áau édaviyain ma kákan á kan maen mai ma ampamein ayun mano ída kokhon bara varéin pasen ainen kafuren mino. ");
INSERT INTO agd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Inká manáa ayun ma ayankun namampin eravukhá ein mano ma e ampamen édavin ayankun naman mano úkuaren mákáká uádan ída aran iren mino. ");
INSERT INTO agd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Manáa ayun mano kama varafin eravukharen mai ano ampamaren kokhon aran iren mino. Manáa ano teti (30) irákan inká manáa ano sikisti (60) iran inká manáa ano mana antareti (100) vá manáa moéken imádan en mino.” ");
INSERT INTO agd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Máa siren Yisasi semí, “Átaren ma van nain kayo áesin ná ma vaya iniren afová ino.” ");
INSERT INTO agd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ínaimpáké banasi ma orivíkan Yisasin má bei eyo iyampon tiyan míkan mifo sirantan kan orun kádan (12) má manáa nanin banta kayo vá ana váken máa sen Yisasin inaemí, “Éi ma vaéde siya ona vaya kayoi ana mai intesá ukhen nafino.” ");
INSERT INTO agd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Máa síkan betin evaránen tiamemí, “Tiyarafenui yafisimpin ma aúpá baya vain mi siretin aní iyá umpo vanasi ano ma ída sentá mumunan iyain kayo ano ída kanaíen tian baeran bayai ana afová inten mino. ");
INSERT INTO agd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mai van mi Tiyarafenui vompon dóki ano máa sikharen mino. “Téi ma variyarúna avúavá betí ankan onanten mifo ída veni ana afová inten mino. Tenti vaya vetí ankan ininten mifo ída kanaíen beni ana afová inten mino. Máan tiyáken ume finté ída ovaránantin betíi ume ifá uantante mino.” ");
INSERT INTO agd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Máa siren Yisasi semí, “Mai vaeran baya ma siretí ankan ída afová inteya mai minó baya ma vaédiyá tiamenunai ana inté ureyá afová inte rafono.” ");
INSERT INTO agd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Máa siren betin tiamemí, “Mai yanayun ma fafasein banta ano Tiyarafenui vayan pafa siyan mino. ");
INSERT INTO agd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Asá ma manáa yanayun eravein mai Tiyarafenui vaya ma vanasi ano iniran ma Ban Anon mano ainen eriven betin aúkáke yo varé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Inká manáa yanayun ma on daró eravein mai vanasi ano ma ainen Tiyarafenui vaya iniren amusin é iyain mino. ");
INSERT INTO agd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Máan té iyan mifo vetíi arú ano ída námen aravukhan mi ída ayáká báé iyan mino. Máan tukhan mi Tiyarafenui vaya ma siyaintá ma uman nafi aufi ma erin maen ainen eraven ankamé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Manáa yanayun ma ayankun namampin eravein mai Tiyarafenui vaya ma iniyain mino. ");
INSERT INTO agd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Iniren ma vara ráke yana san ma in ineine ma erin maen Tiyarafenui vaya me ampiren ainen oré iyan mino. Moní ona van in nafi inká bara ráke yaná kokhon barano van in avúavá anon Tiyarafenui vaya me yaramádan ída aran iré iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Inká kama varafin ma eravein danayun kayoi mai vanasi ano ma Tiyarafenui vaya iniren ma aran iré iyain kékái aní ukhen mino. Manáa ano teti (30) irákan inká manáa ano sikisti (60) iran inká manáa ano mana antareti (100) vá manáa moéken imádan é iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yisasi vetí ankan tiamemí, “Mana vanta ano ma yaamu antúduren kurafin ná kuferé iyan nafino. Áa sakhó aránaó pasá kaé iyan nafino. Ída ino. Takhókái kaé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Minó daná ma aúpá ma váin nain mai ínaimpáké dákó inten mino. Mana vanta ano ma mana yaná dará dantin báin nain mai yaná ínaimpá afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Átaren ma vantin ineno van inain mano áesin ná inino.” ");
INSERT INTO agd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Máa siren betin tiamemí, “Sireti ma vaya inire mai vayai ana kama e vá afová ono. Tiretí ankan ma ena nanin banta siamamesin maen Tiyarafenu ano máan avúaváká anan tiretin má amiren ena vá moéken aminten mino. ");
INSERT INTO agd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Manáa vantá ano inireya yoran baresin maen Tiyarafenu ano moéken afova aminten mino. Inká manáa vanta ano ma iniren doran ída varantin maen Tiyarafenu ano véin pintena mai ma mantáin nain afova yo varanten mino. ");
INSERT INTO agd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yisasi evaránen temí, “Tiyarafenui yafisimpin máan mi ukhen mino. Mana vanta ano yunan barafin danayun mo fafasen mino. ");
INSERT INTO agd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pafa siren e váken inuran má bayan má intesá en ná ban nafi ída afová íkan mai yanayun mano veyantá e ampamen mino. ");
INSERT INTO agd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mana ano ída ayaíkan barai ákonará anan mai yanayun mano e ampamen mino. E ampamaren araíen amun ana ódiaren aran imádákaren mi ínaimpáké afukhé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Afu khakharé íkan ínaimpáké dunan duyasin damusí ma in maen mai vanta ano sope fóké mai yunan duyasé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yisasi evaránen temí, “Téi inté uresá Tiyarafenui Yafisin pintena vaya siamente rafuno. Mai vaya inte yaná kasá tian baerante rafuno. ");
INSERT INTO agd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mana Yudia nanin bantai varafá ma mastati e sin daa ma vain mai aran aú an mi yakhen mino. Mai aran aú ano ída ena yaa aran aú an dakhen mifo véi sító aúi van mino. ");
INSERT INTO agd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Máan tukhan mi mana vanta ano ma mai aú dódan baren e ampamen kákaní uaren nun kayo ano ma kasaen o yomaniríen ayan dan orera uven konesí é iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Máan baya khayo fókéi vanasi ano ma kasaen afová oren avúaváká Yisasi ano vaya vaédiyan mana siamiyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Banasifin ma váken mana vaya ída funtáden tiamiyaren mifo minó baya vaédiyan manan tiamiyaren mino. Ínaimpáké bei eyo iyampon kayo vá ana ma váken mi mai vayai ana sian amá uan amiyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Maí damú áau eraven inúpasí íkan Yisasi vetin tiamemí, “Eritifé non e khádé ena ufá oró tifano.” ");
INSERT INTO agd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Máa síkan betí ankan mai nanin banta me ampiren Yisasi ma kumantá ein bótifin un kumamen oríkan manáa voti kayo ano vetin dakhafen oren mino. ");
INSERT INTO agd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Oriyaré íkan kákan uva uaren non karantó en botifin avanen ódiaren mai votifin non mano víkaríen mino. ");
INSERT INTO agd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Máan tiyákan Yisasi mai voti oyampáke kanuká ánon kaúden bakharen mino. Bakharé íkan betí ankan beín avoren temí, “Aruso oe! Ádé anantá tetí ankan non ufuró tifanté umpo éi ídá mai van iniya fono.” ");
INSERT INTO agd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Máa síkan Yisasi e mantaaren uva asiyáken non nan temí, “Kípantiya! Púkekhano!” Máa siyain má uva kípan non mano evaránen púkekhen mino. ");
INSERT INTO agd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Máan turen Yisasi vei eyo iyampon kayo siamemí, “Pará tiretí ankan akhokho van iya fono. Tiretí ankampin mumunan ídá ban nafino.” ");
INSERT INTO agd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Máa síkan betí ankan kákantá akhokho van uren betiyan ten oreraen temí, “Ma vanta véi iyé bákan ná uva vá non má ano véin avaya iniyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yisasi má bei eyo iyampon kayo vá ano Kariri non e kháden Kerasá barafá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yisasi ma voti finté eraviyain má mana namu aunan mano fákakhan óen iyain banta ano vanta ma masí ukheí páké béin onano van eren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mai vanta ano vanta ma masí uran bain pimpá baren nókan mana vanta ano véin ída kanaíen ayanan kuvirí ukhan inká seni anan póké dere ída kanaíen kuviyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Seni anan póke safi ankati fo safi kokhon damú ayan arantantá damuran mai anan antáden tító tító iyákan ída kanaíen mana vanta ano véin pákaan kaiyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Máan tiyáken mai vanta ano inuran má bayan má banta ma masí ukhein pimpa safi inká anuyon kayo fimpa safi nóken bá diyan maen eraven onámaná kayorá be au kaviyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Máan tiyaren mai vanta ano manáa nen táké Yisasin óden maen tavaen oren béin aufá mo aron kanan durafúden mátimen mino. ");
INSERT INTO agd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Mátimen avádóen oovararen temí, “Yisasi oe, Éi Yan Bain Tiyarafenu Anin mompo séin náisá usintano vará eriya fono. Téin ma ída namu inteya mai Tiyarafenu avíká purase sisimeno van muno.” ");
INSERT INTO agd_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mai fara va máa sen naino. Yisasi ma siyáken, “Namu aunan mompo mai vanta finté eravono,” ma sein nan mino. ");
INSERT INTO agd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Máa síkan Yisasi mai vanta inaemí, “Éin aví iye fino.” Síkan béi semí, “Te siví kokhoná uno. Mai fara vara seyo, setí ankan kokhon kékái vá tiféuno.” ");
INSERT INTO agd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Máa siren mai namu aunan kayo ída siantantin mai varu me ampiré nentá orono van ákonaen Yisasi vaípá ínanen inaen mino. ");
INSERT INTO agd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Máa siyákan mai ádé tító anurá kokhon pon kayo iyukhen dunan niyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Máan tiyákan mai namu aunan kayo ano Yisasi vaípá ínanen tiamemí, “Éi sétin tisintesí mesan pon kayo aúpin oferá tifano van muno.” ");
INSERT INTO agd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Máa síkan Yisasi kana ino siyain má mai namu aunan kayo ano mai vanta me ampiren oren pon kayo aúpin oferen mino. O fébíkan kan tauseni (2,000) fon kayo ano savaen mana kákan ayafin aravuaren non akharumpin orun áduven ufuren puren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Máan tíkan pontá ma yafisiyaré ein banta kayo ano karan oriyáken kákan baru kayofin má mai akhempá ma vain baru kayofin má mai ma afoká ein baya e siamen oriyákan betiyantá onano van ore ore en mino. ");
INSERT INTO agd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Minó nanin banta ano Yisasi vaintá oriven onákan mai ma namu aunan ma fákakhá ein banta ano yavaráe íden kamaen kumantan o óden akhokho van en mino. ");
INSERT INTO agd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Máan tíkan ma o onein kayo ano mai ma namu aunan pákakhá ein banta vá pon kayo vá amaniná ma afoká ein avúavá baya vanasi me siamen mino. ");
INSERT INTO agd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Máa síkan banasi ano iniren Yisasin nan mai vara me ampiren enafá orino van ákonaen baya sen mino. ");
INSERT INTO agd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Máa síkan Yisasi ma evaránen botifin ódin maen mai ma fefá namu aunan mano fákakhá ein banta ano véin má orono van ínanen inaen mino. ");
INSERT INTO agd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Máa síkan maen Yisasi mai vanta siamemí, “Bafan mano ma arunkaren éin kama uantein nan barufá ore ei kéká mo siameno.” ");
INSERT INTO agd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Máa síkan mai vanta ano oren mai ma véin aya ein baya Dekaporisí barafá mo sian afokáin minó nanin banta ano kokhon ineine iyáken takhaen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Máan turen Yisasi evaránen botifin Karirí non e kháden ena ufa oriven non akhempá o vákan kokhon nanin banta e átaru en mino. ");
INSERT INTO agd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Átaru ukhan mana monó namuntá ma ánoní ukhein banta Yairasin ne sin mano eren mino. Béi Yisasin onen ben arantampin e matimen mino. ");
INSERT INTO agd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Matimen Yisasin ákonaen inaemí. “Te siraun arará purono van iyá umpo éi kaná ereya véintá mo ayan kaúde ayofesin ná evaránen asefa inten nafino.” ");
INSERT INTO agd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Máa síkan Yisasi véin avákuren oriyákan kokhon nanin banta ano mákáká uven oren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tiyan míkan mifo sirantan kan orun kádan (12) oranará biyon aí daná baren oriyan baré ein nanin má maifin baren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mai nanin mano kokhon damú ayofan banta kayo vaípá bei moní mo miyaní uan kíparan mai aí daná ano moéken aí ana iyan ída kípaanten mino. ");
INSERT INTO agd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mai nanin mano Yisasini vaya ma siamin iníden maen banasi mákáká ukheimpin oriaren ben oyampáké beni ayá au anamun aruven mino. ");
INSERT INTO agd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mai farava máanten naino. “Téi ma siyan máa ma veni au anamuntá kaonté evaráne kama onté uno,” sen iniren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Máa sen iníden ma aruviyain má manádá ainen beni nare vo íkan béi aváduan onákan mai aí daná kípen mino. ");
INSERT INTO agd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Máan tíkan Yisasi afová in manáa vei ákona oríkan do vaéaren máa sen inaemí, “Iyé tenti su anamun aruven nafino.” ");
INSERT INTO agd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Máa síkan bei eyo iyampon kayo ano máa sen béin tiamemí, “Éi oniya fono. Kokhon nanin banta anon éin mákáká ukhen mifo éi fará, ‘Iyé tén tu anamun tiruviyan nafino,’ siya fono.” ");
INSERT INTO agd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Máa siyákan maen Yisasi vei au anamun ma aruvein onano van onen eúken mino. ");
INSERT INTO agd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Máan tíkan mai nanin mano ve aurá ma afoká ein dana san pé den avinantan má Yisasi vaintá aron kánan mo yurafúden matimen be aurá ma afoká ein dana san tiamen mino. ");
INSERT INTO agd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tian míkan Yisasi véin evaránen tiamemí, “Tiraun noe, Éini mumunan manon eni aí kípaanten mifo ará kusin masá orono.” ");
INSERT INTO agd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yisasi ma fara vaya siyákan maen monó átaru namuntá ma ánoní ukhein banta Yairasin amá pinté manáa vanta kayo ano eren me véin máa sen tiamemí, “Éin araun inka furen mifo ída vá enádá arú uman ameno.” ");
INSERT INTO agd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Máa siyákan mai vaya Yisasi ída avové en inin nan monó átaru namuntá ma anoní ukhein banta máa sen tiamemí, “Éi ída vá akhokho van iyáke mumunan mana vá ono.” ");
INSERT INTO agd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Máa siren béi minó nanin banta ayópá uren Pitan má Yemisin má be afá aváe Yonin má mai máa ano anan Yisasin má oren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Monó átaru namuntá ma ánoní ukhein banta Yairasin amá barurá ma vetí ankan orivin maen Yisasi onákan kokhon nanin banta ano sisuvo siyáken kákantá ifí diyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Máan tiyákan Yisasi maifin un pében betin máa sen tiamemí, “Para siretí ankan ifí diyákeyá kákantá tisuvo siya rafono. Ma arinta arará ída fúken béi faran auun bakhen mino.” ");
INSERT INTO agd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Máa síkan minó nanin banta ano véin nan intíkan béi mai nanin banta yo siantan barufá arafuvíkan mai arinta anóe afóen má bei eyo iyampon kanú manaú bá avíaren mai arinta ma kain bain karafarampin un peren mino. ");
INSERT INTO agd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Um pében mai arinta ayan bana fakáaren máa semí, “Tarita kumi,” Mai vayai ana máan mi sikhen mino. “Titó arinta oe, séi éin tiamé umpo éi e mantano.” ");
INSERT INTO agd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Máa siyain má mai arinta arará ano manádá ainen e mantaaren oren mino. (Mai arintai orana sirantan kan orun kádan (12) mi varen mino.) Oríkan mai namumpin ma varé ein nanin banta ano ódaren kákantá anúden oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Máan tíkan mai ma afoká in onein dana san ena nanin banta ída siamino van Yisasi ákonaen betin tiamíden mai arinta arará ana yunan amino van tiamen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisasi mai varu me ampiren bei eyo iyampon kayo vá bei varu anará Nasaretí oren mino. ");
INSERT INTO agd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","O varen Sabati yamú Yisasi monó átaru namumpin ódiven Tiyarafenui vaya vanasi siamiyákan iniren kokhon mano anúden oreraen temí, “Ai! Inte fákená ma vanta ano mai ákona vá afova vá mamáken ná ma avúavá danasinta afoká iyan nafino. ");
INSERT INTO agd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pura sen béi mana má uvaran bantan ban mino. Béi Marian anin mi váken Yemisi, Yosepi, Yudasi, Saimoni siren mai kékái afá aváe ino. Béin ayómái setin má mafin ban mino,” siren béin namu inin mananten mino. ");
INSERT INTO agd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Máan tiyákan Yisasi vetin tiamemí, “Sakhanampa vanta avíena varufá ban mifo vei varu anará bá minó bei mana nare vá be amápin má ída véin aví báé iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Betíi mumunan ída ákona ukhan pasen mi Yisasi mai varurá ída manáa avúavasí ina aí ma vain kéká aurá anan ayan kaúden ayofiyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Máan tiyan ma vanasi ano ída mumunan iyain nan Yisasi kokhon ineine en mino. Máan turen Yisasi mai akhempá ma varé ein baru kayo fimpá oriven monó baya e siamen oren mino. ");
INSERT INTO agd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Máan tiyáken baya varen orino van tiyan míkan mifo sirantan kan orun kádan (12) eyo iyampon kayo araren namu aunan ma yo siantan ákona amíden kaní uriyan tiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tian tiyáken maen Yisasi vetin máa sen tiamemí, “Ída vá mana yaná bare vá ayonta ana vá pákare orono. Ída vá dunan nafi unan nafi inká moni safi ída vá maman unampin bádo ono. ");
INSERT INTO agd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tiretí ankan arantan anamun máa vá ure orin nompo ída vá ena au anamun má mamare orono. ");
INSERT INTO agd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tiretí ankan ma mana varurá orinte mae mana namumpin mana vá bareya ínaimpáké mai varu me ampeno. ");
INSERT INTO agd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mana varurá oresin ma ída avían má naumpin kaen ma inká tiretíi vaya ma ída ininti mae mai varu vá me ampire vetíi namu vara ma arantantá dampakháin nain ná me fúpá tian karú dano. Mai anon betíi namu avúavá aní intin betiyantá afová inten mino.” ");
INSERT INTO agd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Máa sirákan banasi ano ará baerano van eyo iyampon kayo ano oriyan monó baya e siamen oren mino. ");
INSERT INTO agd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Oriyáken betí ankan namu aunan kayo yo siantiyáken aí ma vain nanin banta aufá uveri féantan mai kayo ano asefaen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yisasi ma variyain avúavá baya ano minó akhempá orera íkan banasi ano ma mai vaya ana sen orera iyan maen Kin Eroti inen mino. Manáa kéká ano siyáken, “Monó Non Péantan Banta Yoni anon purin pinté evaránen e mantakhan mi enará ukhein ákona ano véimpin doriyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Máa síkan manáa ano sen, “béi Iraisa ino,” sin inká ena kéká ano sen, “pefá ma vá ein sakhanampa vanta kayo an dakhen mai véi mana sakhanampa vantan ban mino.” ");
INSERT INTO agd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Máa síkan Eroti mai vaya kayo iniren temí, “Pefá ma séi anuran tíkeruna vanta Yoni anon purin pinté evaránen e mantakhanten mino.” ");
INSERT INTO agd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mai farava máa sen naino. Eroti ano ve aná Erodiasin amusin ameno van bei aruvin banta kéká tíkan Yonin pákaan karavusifin kain baren mino. Be afá aváe Firipin aná Erodiasin ma véi mantaré ein mai van mi Yonin karavusií ukharen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Erotin nan ma Yoni ano sen, “Éi e afá aváen aná ma yafeona mai ída kama ukha ono,” ma sein nan mino. ");
INSERT INTO agd_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Máa ma sikhein nan Erodiasi ano Yonini aran naná máden béin aruan purono van iyaren mifo véimpin ída mai ákona varen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Máan tiyákan maen Yoni funtáken kantasí ukhein banta vákan Eroti ano véi ma siyain baya kayo van kokhon ineine iyáken béin aya ono van inikharen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erodiasi ma Yonin arin nain aa van dosiyaré íkan Erotin ma ve anóe ano khaein damú e afoká en mino. Maí damú Eroti kákan dunan tariyáken béi kamanimpin ma ánoní ukhein banta kayo vá aruvin banta kayoi ánon banta vá Kariri fáké ánon banta kéká bá aran e átaru en mino. ");
INSERT INTO agd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","E átaru ukhan Erodiasin araun mano mai ma iyukheimpin eriven danisiíen mino. Danisií íkan Erotin má mai ma yunan niyaré ein kéká bá ano kákan amusin en mino. Máan tíkan Kin Eroti ano mai arinta van temí, “Éi ma sinona mai yaná téi fara amenté uno.” ");
INSERT INTO agd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Máa siren Eroti asíká ayan befiyó uren béin tiamemí, “Éi ma sinona yaná téi fara amenté uno. Tesi yafisin nan ma aúban daíde simeno ma sesí mai fara máan tonté uno.” ");
INSERT INTO agd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Máa síkan mai arinta ano oren be anóentá mo inaemí, “Náinasá inantékun ná Kin mano siminten nafino.” Máa síkan be anóe ano evaránen béin tiamemí, “Monó non péantan banta Yonin ánon nará inan teno.” ");
INSERT INTO agd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Máa síkan mai arinta ano ainen evaránen Kin baípá o nóben temí, “Monó non péantan banta Yonin ánon mana yókifin kaúde simeno van muno.” ");
INSERT INTO agd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Máa siyain má Kin mano kákantá ará uman den mifo véi má ma váken dunan niyá ein kayo avorá ma asíká ayan befiyó uren tikhá ein nan iniren ída mai arinta avaya yo yurafuren mino. ");
INSERT INTO agd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mai van Yonin ánon mo síkaren baren erino van esé ana mana aruvin banta siantan oren karavusi finte Yonin ánon mo síken mino. ");
INSERT INTO agd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tikaren maen Yonin ánon maman dókifin kaúden mai arinta me amíkan baren be anóen mo amen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yonin ma arin baya vei eyo iyampon kayo ano iniren béin au e varen mo masíen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yisasi ma vei eyo iyampon kayo siantan dorantá orikhá ein mai ovaránen e átarú uven betí ma yoriyá ein má banasi ma siamiyá ein baya kayo vá béin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kokhon nanin banta ano eriven oriven iyákan Yisasi má bei aposeri kayo vá ída yunan narí eimpin Yisasi máa sen betin tiamemí, “Erítifé banta ma ída van naipá o váké tivíká tifano.” ");
INSERT INTO agd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Máa siren betí ankan mana voti mamaren banta ma ida vain afokhantá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Oríkan kokhon nanin banta ano veti ma oriyain afová uren minó kákan baru ráke nanin banta ano non akhempá tavaen mai ma orin naintá betin nare o varen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","O varé íkan Yisasi non akhempá oriven mai nanin banta oniyáken sipisipi kayo ano ma ída vetintá dafisin banta vákan iyukhen bainí ukharé íkan kákantá arunan uanten mino. Mai van kokhon danasinta vetin afova amen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Afova ma amiyan áau eraven inúpasí íkan maen bei eyo iyampon kayo Yisasi vaintá eriven temí, “Banta i van akhempái e varé étifékun mi áau eraven mino. ");
INSERT INTO agd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Éi vanasi siantesin oriven ná ádé ma van nain baru khayo finte vetíi yunan miyaní ino.” ");
INSERT INTO agd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Máa síkan Yisasi evaránen betin tiamemí, “Tireti yantasá betin dunan ameno.” Máa síkan betí ankan evaránen béin tiamemí, “Kankan antareti moní kasá bereti o miyaníé betin me amenté tife rafuno.” ");
INSERT INTO agd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Máa síkan Yisasi vetin tiamemí, “Tiretí ankan nái máa veretí denan ban nafino oriveya onano.” Máa síkan betí ankan o oman afová uren me siamemí, “Dan manápá bereti vá kankanan noyana vái van mino.” ");
INSERT INTO agd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Máa síkan minó nanin banta sintin kata yaró manafin kumádú ino van betin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tiamíkan manafin mana antareti (100) ano kumaniyan inká enafin fifti (50) ano kumaniyan en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Máan tuvíkan Yisasi mai yan manápá bereti vá kankanan noyana vá pákaaren inarufá kakháben mai yunan nan Tiyarafenun tusu sianten mino. Máan turen mai vereti kayo vá noyaná kanan má máden kisikisi uren bei eyo iyampon kayorá dákan mai nanin banta amen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Amíkan minó ano kanaíen nen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Narákan mai yunan antan tiyan míkan mifo sirantan kan orun kádan (12) unan bíken mino. ");
INSERT INTO agd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mai yunan ma naran banta máa ma yankafein mai yan manápá tauseni (5,000) ino. ");
INSERT INTO agd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Narákan Yisasi ma vanasi siantan orera iyan maen bei eyo iyampon kayo van betin nare ainen botifin káusiven non e kháden Betsaidá akhempá orino van tiamen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Máan turen mai oyampáké béi amúkono van anufá óden mino. ");
INSERT INTO agd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Inupasi íkan mai voti ano non aúbaná bákan Yisasi veyáká non akhempá para varen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Báken béi onákan uva ano voti e avékaan more mere iyákan betí ankan ákonaen non intaniyaren mino. Máan tiyákan ma kúkarosíen kakhano van in maen Yisasi non daró oriaren betin esantano van en mino. ");
INSERT INTO agd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Máan tíkan bei eyo iyampon kayo ano véin onan non daró oríkan betí ankan béin nan ban mi eriyan mino sen iniren báden oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Minó ano véin ódaren kákantá akhokho van iyaimpin Yisasi ainen betin máa sen tiamemí, “Téi umpo ída vá tiretí ankan periya vano.” ");
INSERT INTO agd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Máa siren béi votifin un bákan uva kípavin minó ano sakha iyáken kokhon ineine en mino. ");
INSERT INTO agd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yisasi ma vereti kisian ameini avúavái ana vetí ankan ída afová ukharen mino. Mai fara va ino. Betin aú ano ákona ukhan ída mumunan ban mino. ");
INSERT INTO agd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Betí ankan ma non e kháden Kenesaretí akhempá ódiven maen boti anan kuan kaen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Máan turen ma vetí ankan boti finté eraviyain má banasi ano ainen Yisasin afová en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Afová uren banasi ano mai akhempá oriviyan aí kéká ma varé ein aviren Yisasi vaintá duvasiká mo khaen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mai akhempá tító baru kayo vá kákan baru kayo vá inká akhempá ma vain baru kayo fimpá bá ma Yisasi orin maen banasi ma átaru iyain barurá aí nanin banta ayofano van béi vaintá aviren oriyaren mino. Aí nanin banta ano Yisasin nan áintí beni ayá au anamun áton aruvono van ínan en ina iyaren mino. Aí nanin banta ano ma inaúden aruvin maen mai kékái aí kípaantiyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farasisi kayo vá manáa Yerusaremi fáké man baya ma afová ukhein banta kayo vá Yisasi vaintá e átaru ");
INSERT INTO agd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","uven onákan manáa Yisasini eyo iyampon kayo ano Yutan nanin bantai avúavá durafuren ída ayan nare sesé inton dunan pákaren nen mino. ");
INSERT INTO agd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Minó Farasisi kayo vá Yutan kayo vá be anafu aráoni avúavá dakhafen ayan ma ída kamaen tesé ukhen maen ída yunan pákaren né iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Betí ankan ma máketifá noren ma ovaránen eriven ma ída non péken maen mai yunan ída né iyan mino. Kokhon avúavá daná ma vetíi anafu aráopintena ma mantein mai ánain mi yakafen betíi kápi, kura, yóki, takhó tesé é iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Máan tiyain mi vakan Farasisi kayo vá man baya ma afová ukhein banta kayo vá Yisasin inaen temí, “Éini eyo iyampon kayo ano ma ída ve anafu aráoni avúavá dakhafen ayan ída sesé iyain mai intesá ukhen nafino.” ");
INSERT INTO agd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Máa síkan Yisasi vetí ankan evaránen tiamemí, “Tiretí ankan kampun banta kayon banan mi fura sen tiretin nan mi sakhanampa vanta Aisaiya ano máa siren bompon uvamádan baren mino. “‘Ma vanta kayo ano oo máafói séin tiví daní iyan mifo vetí ankan ará ano nenta suron ban mino. ");
INSERT INTO agd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Betí ankan bantai man baya ma siamiyain mai van mi ‘Tiyarafenui vaya ino’ sé iyan mino. Máan tiyáken betí ankan téinta faran monó máan tiyan mino.’ ");
INSERT INTO agd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tiretí ankan Tiyarafenui man baya me ifá ureya vantai avúavá máa anan ákona e fákare va ono.” ");
INSERT INTO agd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mairá Yisasi vetin máa sen tiamemí, “Tiretí anafu aráoni avúavá ánain dakhafono van mi kama aafáke Tiyarafenui man baya yo ékiya ono. ");
INSERT INTO agd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Para vara seyo, Mosesi sikhen mino, ‘Éi e anóe afóeni vaya ánain ná dakhafono.’ Inká ena vá tiyáken, ‘Mana vanta ano ma ve anóe afóen nan ma namu vaya sin nain ná arintin purino.’ ");
INSERT INTO agd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Purinten mifo siretí máa sé iya ono, ‘Mana vanta ano ma ve anóe afóen ayain moní dákaren békanan tiamé iyan mino, “Téi ma moní Tiyarafenu ameno van derúna ino.” ’ ");
INSERT INTO agd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mai máan ma inten béi ída vá be anóe afóen kama ino. ");
INSERT INTO agd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tiretí ankan ma anafu aráon pintena vareona mai avúavá ánain dakhafiyákeya Tiyarafenui vaya ma kantifin karú dareya siretí ma avúavá daná kokhon mano variya ono.” ");
INSERT INTO agd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Máa siren evaránen Yisasi vanasi aran erin tiamemí, “Tiretí ankan téinti vaya inere vá afová ono. ");
INSERT INTO agd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mana yaná ma mafá baren banta aúpin ma aravin mai ano ída vanta fainí é iyan mifo vanta aupinté má édan mai yaná kayo ano anan banta fainí é iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Átaren ma van nain banta ano vá ineno.” ");
INSERT INTO agd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Béi ma mai nanin banta me ampiren má naumpin orivíkan bei eyo iyampon kayo mai vaya ma sian baé ádeini anavan béintá inaen mino. ");
INSERT INTO agd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ina íkan béi vetin tiamemí, “Tiretí bá dere ídá inikhe fono. Minó daná ma mafá bare ma vanta aúpin aravin mai ano ída vanta faini é iyan mino. Ída ino! ");
INSERT INTO agd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mai yaná ano ída vanta amafompin oré iyan mino. Mai yaná ano arápin araven arái íkan ara masípin mo karákan aravé iyan mino.” Ma vaya fókéi Yisasi minó dunanan avusese ukhen ne sen mino. ");
INSERT INTO agd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mairá béi máa semí, “Mana yaná ma vanta aúpin varen ma édiyain manon banta maman painí é iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Minó daná ma ineine finté afoká é iyain mai yana sinta ino. Minó namu ineine in avúavá, pamúkuí in, umoyan in, banta aruan purin, ");
INSERT INTO agd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ábasu yurafurin, ena ina yana san kampun tin, ara ara namu avúavasí in, baya atákaré en kampuntin avúavá bá Tiyarafenu ará namu uanten béin oyampá baya sin avúavá bá baya átakharé uren be au kákaní in avúavá bá óen in avúavá bá ");
INSERT INTO agd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","minó mai namu avúava sinta anon banta aúpin baren ma éden maen mai anon maman banta fainí é iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yisasi mai varu me ampiren Taiyá barafá e manten oren mino. Oriven béi mana namumpin un pében ída mana vanta ano afová ino van en mifo véi ída kanaíen aúpá baren mino. ");
INSERT INTO agd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mana nanin mano véi ma o vain baya iniren be araun namu aunan mano fákakhan baré in mai nanin mano Yisasin arantampin mo aron kanan durafú den matimen mino. ");
INSERT INTO agd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Siriá barafin Fonisiá kaein Kiriki váken béi Yisasin nan be araun aufin ma namu aunan bain do siantano van tiamen mino. ");
INSERT INTO agd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yisasi evaránen béin tiamemí, “Tetí iyampon nare vá dunan amékun ná kanaí en nano. Ída vá iyamponi yunan tetí maman iyan oofen karú dá tifano.” ");
INSERT INTO agd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Máa síkan mai nanin mano evaránen béin tiamemí, “Bafan noe! Pura siya ompo sakhó aránaópá bain iyan kayo ano iyamponi yunan antan ma eravein mi né iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Máa síkan Yisasi evaránen béin tiamemí, “Éi ma máa seona rá namu aunan mano inka e araun aú pinté me ampiren oren mifo éi evaráne orono.” ");
INSERT INTO agd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Máa síkan mai nanin mano evaránen be amápin o onákan namu aunan mano ve akhá me ampiren orivíkan béi sakhópin bakhen baren mino. ");
INSERT INTO agd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mai ráké Yisasi e mantaaren Taiyai vara me ampiren Saidonii vara aúbana oriaren Kariri non akhempá orun nóben Dekaporisi varafá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Oríkan manáa ano mana átaren kontan ída kamaen baya siyain banta avían Yisasi vaintá meren, “Béin nan ayan kaú antano,” sen mino. ");
INSERT INTO agd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Máa síkan Yisasi mai vanta avíaren minó nanin banta me ampiren manáa nentá békan mana oriven mai vanta átarempin Yisasi ayantá akhare siren mai vanta amafintá kaen mino. ");
INSERT INTO agd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Máan turen Yisasi inarufá kakháben avádóden aunan mamaren mai vantavan Aramaiki vaya finté temí, “Efata.” Mai máan ma semí, “Divono.” ");
INSERT INTO agd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Máa siyain má mai vanta amafintá ma yampakhen uman diyá ein daná orivin átaren inen baya kamaen ten mino. ");
INSERT INTO agd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Máan turen Yisasi vetí ankan airo ananí uantá den ída vá ma avúavá baya ena nanin banta siamero. Máa siren béi ákonaen airo ananí urákan betí ankan mai avúavá moéken tian afoká en mino. ");
INSERT INTO agd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Máan tíkan minó ano anúden oreraen temí, “Átaren ma kontaré ein mano kamaen iníkan inká baya ma ída siyaré ein mano vaya síkan Yisasi ma minó avúavá barein mano kamaen mino.” ");
INSERT INTO agd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Máan ten nókan maná damú kokhon nanin banta ano Yisasi vaintá átaru ukhan betíi yunan ída vaimpin bei eyo iyampon kayo arákan erin tiamemí, ");
INSERT INTO agd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kanú manaú damúi ma nanin banta sen má bákan betíi yunan minó kípavíkan dunan ída van tirun kiyan mino. ");
INSERT INTO agd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Manáa ano ayá aa sáké erikhein betí ankan ma arafan tiantékun betíi varufá oriyaren ayanafá auu entave entave intin aasá o ankaminten mino. ");
INSERT INTO agd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Máa síkan bei eyo iyampon kayo ano máa sen béin tiamemí, “Ma vanta ída van kámá barafá ifo setí kanaisá erá bereti máderá ma nanin banta amenté tiferafuno.” ");
INSERT INTO agd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Máa síkan Yisasi vetí ankan inaemí, “Tiretí nái máa vereti yáke fono.” Síkan betí ankan temí, “Dan manápá ifo afápá kan un ká dan mino.” ");
INSERT INTO agd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Síkan mairá béi minó nanin banta van barará kumaneno síkan barará kumamin dan manápá ifo afápá kan un kádan bereti máden Tiyarafenun tusu siantáden kisiren bei eyo iyampon kayorá dákan banasi amen mino. ");
INSERT INTO agd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bei eyo iyampon kayo ano manáa sító noyana kayo kain baré íkan Yisasi mai máden Tiyarafenun tusu siantáden bei eyo iyampon kayorá dákan betí ankan máden banasi amen mino. ");
INSERT INTO agd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Amíkan minó nanin banta ano kanaíen naran antan o éke e éke uren daa manápá ifo afápá kan un kádan unan bíken mino. ");
INSERT INTO agd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kamí kamí tauseni (4,000) vanta anon mai yunan narákan Yisasi vetí ankan tiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Orivíkan béi votifin bei eyo iyampon kayo vá un kumamen Daramanuta varafá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Maná damú Farasisi kayo ano Yisasin akhenóka uan onono van béi vaintá mana inaru fákena avúavasí í oná tifano sen inaen mino. ");
INSERT INTO agd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Máa síkan Yisasi veyan avádúan onan uman diyaimpin temí, “Teréa ma vain nanin banta ano nái vará téin nan mana avúavá aní ino van tiyan nafino. Téi fura siré tiretin tiamé uno. Tiretí ankampin téi mana avúavá daná ída aní onté uno.” ");
INSERT INTO agd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Máa siren béi votifin un kumamen non e kháden ena ufá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Eyo iyampon kayo ano áúden ída vereti varanton oriyákan mana vereti ana votifin baren mino. ");
INSERT INTO agd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yisasi vetí ankan amaan temí, “Tiretí ankan Farasisi kayoi yisi vá Erotini yisi vasará antan ono.” ");
INSERT INTO agd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Máa síkan betí ankan Yisasini vaya ída afová ukhen betiyan ten orera emí, “Tetí ankan ída vereti yákékun mai van mi véi sen mino.” ");
INSERT INTO agd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Máa siyákan Yisasi afová uren betin inaemí, “Nái vará tiretí ankan bereti ída yáké uno sé orera iya rafono. Tiretí ankan ída afova vá e ine ukhen nan mi siretin ará ano uman diyan mino. ");
INSERT INTO agd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tiretí ankan auu vákaya ompo ída oniya ono. Tiretí ankan átaren bákaya ompo ída vaya iniya ono. ");
INSERT INTO agd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Téi ma yan manápá bereti ma yan manápá tauseni (5,000) nanin bantafin kisirékun ma mai vereti antan ma fara vá ein nái máa unan ná bá de fono. Á unten nafino.” Síkan betí ankan temí, “Tiyan míkan mifo sirantan kan orun ká dan mino (12).” ");
INSERT INTO agd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Máa síkan Yisasi vetí ankan inaen temí, “Ená damú ma séi yan manápá ifo afápá kan un kádan bereti ma kamí kamí tauseni (4,000) bantafin ma kisiré amékun ma minó ano narákan mai antan bereti nái máa unan ná tiretí ankan bíkhe fono.” Máa síkan betí ankan temí, “Dan manápá ifo afápá kan un kádan mino.” ");
INSERT INTO agd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Síkan béi vetin tiamemí, “Mai siretí ankan ídá afová ukhe rafono.” ");
INSERT INTO agd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yisasi vei eyo iyampon kayo vá Betsaidá oríkan manáa nanin banta ano mana auu yufúkukhein banta avían Yisasi vaintá me khaúden béin nan mai vanta aurá ayan kaono sen mino. ");
INSERT INTO agd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Síkan Yisasi mai auu yufúkukhein banta ayan pákaaren mai varu me ampiren aviren oren morun baru akhempá kaúden mai vanta auufen akhare siren be ayan mai vanta aurá kaúden inaen temí, “Éi kaná manáa yanasinta oniya fono.” ");
INSERT INTO agd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Máa síkan mai vanta ano yan auu mááken onen temí, “Eyo, téi vanasi oniyá umpo vetí ankan daa ana kayo ma kayamanaen noiní iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Máa síkan Yisasi evaránen mai vanta auufen ayan kaúan tádan auu kama uvin mai vanta ano kákantá auu mariyáken minó daná kamaen onen mino. ");
INSERT INTO agd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Máan turen mai vanta Yisasi siantan be amápá oriyákan temí, “Ída vá mai varufin umperano.” ");
INSERT INTO agd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mai ráké Yisasi vei eyo iyampon kayo vá e manten Sisaria Firipaí barufimpá oriyákan ayanafá Yisasi vei eyo iyampon kayorá inaemí, “Minó nanin banta ano séin nan iye inó tiyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Máa síkan betí ankan evaránen bein tiamemí, “Manáa nanin banta ano éin nan monó non péantan banta Yoni ino síkan inká ena kéká ano sakhanampa vanta Iraiya ino síkan ena kayo ano mana feyan sakhanampa vanta ino siyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Máa síkan Yisasi inaemí, “Tiretí iye inó téin nan tiya rafono.” Síkan Pita evaránen tiamemí, “Éi Karaisi Tiyarafenu ano ma fefá ma sen minó nanin banta evaráne aviranono ma sikaré ein banta ono.” ");
INSERT INTO agd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Máa sirákan Yisasi vei eyo iyampon kayo airo ananí uanten ten mino. Pura ifo séi Karaisi umpo ída vá mai vaya ena nanin banta siameno. ");
INSERT INTO agd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Máa siren mairá betí ankan afova amen temí, “Banta Anin mano kákan aí barantin minó ánon banta kayo vá monó ánon banta kéká bá man baya ma afová ukhein banta kayo vá béin oyan amiren béin aruan purinten mino. Aruan púdantin kanú manaú damú orivintin béi evaránen e mantanten mino.” ");
INSERT INTO agd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Máa siren Yisasi mai vaya ana afoká amá uan betí ankan amirákan Pita ano véin do aviren akhempá mo khaúden araíen asen temí, “Mai ma siyaona vaya ída vá teno.” ");
INSERT INTO agd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Máa siyákan Yisasi yovaéan bei eyo iyampon kayo oniyáken Pitan asen temí, “Ban Anon noe. Téin toyampá entavono. Éi ída Tiyarafenui ineine ánain dakhafiya ono. Ída ino. Éi vantai ineine ánain mi yakafiya ono.” ");
INSERT INTO agd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mairá Yisasi minó nanin banta vá bei eyo iyampon kayo vá arákan béi vaintá eríkan betí ankan tiamemí, “Mana vanta ano ma séin tínain ma vákurono van beyan maman bararasí urená bei yaa unkamádan mamaren ná téin tínain bákurino. ");
INSERT INTO agd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Para vara seyo, mana vanta ano ma vei aunantá ma yafisintin maen mai veni aunan o afeyoranten mifo vanta ano ma séi má tenti kama vaya va san ma iniren bei aunan ampirákaren mai ano evaránen bei aunan baranten mino. ");
INSERT INTO agd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mana vanta ano ma minó ma vara ráke yanasinta ma mamarantin beni aunan ma aiyóbintin minó daná ano intesá ená béin ayainten nafino. ");
INSERT INTO agd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mai nái yaná pókesá banta ano evaránen bei aunan miyaní inten nafino. ");
INSERT INTO agd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Taréa ma ume vá nanin banta ma vaimpin ma mana vanta ano ma séin má tenti vaya vasa ma ayave iyá intin maen Banta Anin mano ma ve afóeni kakhan má kantá enisori kayo vá ma ayompin erin nain damú mai vanta van be yeren ayave uantanten mino. ");
INSERT INTO agd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yisasi vetí ankan máa sen tiamemí, “Téi fura siré tiretin tiamiyá uno. Ma ma mantakhein pinté manáa ano ída fúkantin mi Tiyarafenui yafasin mano vei ákona vá erintin mi vetí ankan onanten mino.” ");
INSERT INTO agd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Dan manápá ifo afápá mana un kádan damú orivíkan Yisasi ano Pitan má Yemisin má Yonin má avíaren mana ayá anurá betí ankan mana un báken Yisasi vetí avorá be au ayúden ena vukafaíen mino. ");
INSERT INTO agd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Béini auí daná ano oon ma kheiní íkan efanten uron en mino. Ma vara ráké mana ano efanten davaráe sesé urantin ída kanaíen maman máan efanten inten mino. ");
INSERT INTO agd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Máan tiyain má Iraiyan nú Mosesin nú betí ankan baintá afoká uven Yisasin má baya siyákan betí onen mino. ");
INSERT INTO agd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Máan tíkan Pita ódaren Yisasin tiamemí, “Aru soe, setí ankan ma sító namun kanú manaú en nina vá Mosesi nina vá Iraiya nina vá ma uvará tifanuna mai kama ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita kákantá akhokho van iyáken béi ma sin nain baya ída afová ukhan inká Yemisin nú Yonin nú bá dere kákantá akhokho van iyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mairá máan tiyain má konan mano eriaren betí ankan me úkuá darákan mai konan pinté mana oova ano máa semí, “Ma séin tanin uron mino. Béin nan téin moéken tiraniyan mino. Béin avaya vá inero.” ");
INSERT INTO agd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Máa siyain má manádá betí ankan onen eúkin ída ena vanta vákan Yisasi veyáká ana vetin má baren mino. ");
INSERT INTO agd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Betí ankan mai anu me ampiren eriyákan Yisasi vetin airo ananí uanten temí, “Ma yanasinta ma oneona mai siretí ída vá ena vanta sian mikhesin ná Banta Anin ma masí pinté orun mantavinti vá tiameno.” ");
INSERT INTO agd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Máa sirákan betí ankan mai vaya fákaan ákona uren betiyan mana sen oreraen mino, “Mai ma masí me ampiré e mantanté uno ma sikhein mai nái yana sará ten nafino.” ");
INSERT INTO agd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Betí ankan Yisasin inaemí, “Pará man baya ma afová ukhein banta kayo ano sen ná peyan sakhanampa vanta Iraiya nare vá erino siyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Máa síkan Yisasi evaránen betin tiamemí, “Eyo mai fura ino. Iraiya ovaránen eriven minó daná maman puntaranten mifo feyan sakhanampa vanta kayo ano máa sikhen mino, ‘Banta Anin mano uman baren berai sintin béin oyan aminten mino’ sen pará tikhan nafino. ");
INSERT INTO agd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Máa sikhan mifo séi seretin tiamé uno. Iraiya inka fe erikhen mino. Bompon mano ma sikhá einíen betíi anunu kípen ara ara avúavá ben amaniná kaen mino. ");
INSERT INTO agd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Máa siren betí ankan araven eyo iyampon kayo ma varé eintá o uníkan kokhon nanin banta vetin má iyukhan man baya ma afová ukhein banta kayo ano vaya fóké betin má aruvein an diyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Máan tiyan baren mai nanin banta ano onákan Yisasi orin minó ano anúden orera uren tavaen mo véin kamaen mino. ");
INSERT INTO agd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Máan turan mairá béi vetin inaemí, “Tiretí ankan nái vará baya fóké man baya ma afová ukhein banta kayo vá aruvein an diya rafono. ");
INSERT INTO agd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Máa síkan mai nanin banta aúbanáké mana vanta ano evaránen Yisasin máa sen tiamemí, “Aru soe, séin tanin namu aunan mano véimpin bákan orá iyákái éi vaípá béin aviré eré uno. ");
INSERT INTO agd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kokhon damú mai namu aunan mano ákonaen béin pákaren barará maman asédan bavin oo fenté efanten akhare avanen eravin maen aveantuntá inkékípiyákan béin au ano kafifi sé iyan mino. Máan tiyákái éini eyo iyampon kayo van mai namu aunan do siantano sékun betí ankan ída kanaíen mino.” ");
INSERT INTO agd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Máa síkan iniren Yisasi evaránen banasi siamemí, “Ída mumunan bain nanin banta oe! Nái máa yádasá téi siretin má para vante rafuno. Nái máa yádasá téi siretíi uman barante rafuno. Tiretí ankan mai iyampon avire séi ma varunará ereno.” ");
INSERT INTO agd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Máa síkan betí ankan mai iyampon aviren Yisasi vaintá eriyain má mai namu aunan mano Yisasin onen mai iyampon ainen ankaman karúdan barará baven baé baé íkan efanten akhare oo fenté avanen mino. ");
INSERT INTO agd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Máan tiyain má Yisasi ve afóenta inaemí, “Nái máa yádasá béi máan tiyan nafino.” Síkan be afóe semí, “Béi ma araráká ma vá ein táké ino. ");
INSERT INTO agd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kokhon damú mai namu aunan mano véin aruan purono van irafin nafi nompin nafi yauman karú diyan mifo éi kaná tétin nan arunan ureyá tiya inte fono.” ");
INSERT INTO agd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Máa síkan Yisasi véin tiamemí, “Éi ma mumunan inteya éi kanaíeya minó daná baran nono.” ");
INSERT INTO agd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Máa siyain má mai iyampon afóe ano evaránen temí, “Téi mumunan ukhé umpo senti mumunan tiyaesin mo ákona ino.” ");
INSERT INTO agd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Máan tiyákan banasi savaen e átaruin Yisasi ódaren mai namu aunan béi asen temí, “Éi átaren konen oo uman dan aunan noe. Téi éin tianté umpo mai iyampon ampireya entavuveya enádá bá ída vá béimpin oferano.” ");
INSERT INTO agd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Máa siyain má mai namu aunan mano avádóden bádiyan mai iyampon máden antú antú iyáken béin me ampiren orivíkan mai iyampon purein an davin minó ano óden temí, “Béi inka furen mino.” ");
INSERT INTO agd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Máa siyain má Yisasi mai iyampon ayan bana fákaren orun ayanoran béi e manten mino. ");
INSERT INTO agd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mantavíkan Yisasi ínaimpáké mánaumpin oríkan bei eyo iyampon kayo ana váken béin inaemí, “Mai náisá ukhará tetí ankan ída kanaí erá mai namu aunan do sianté tiferafuno.” ");
INSERT INTO agd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Máa síkan Yisasi evaránen betí ankan tiamemí, “Tireti ma Tiyarafenu vaípá ma kokhon dádá amúkinte maen máan namu aunan kanaíe yo siantan nompo ena aa ída van mino.” ");
INSERT INTO agd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mairá betí ankan mai varu me ampiren Kariri vara aúban oriyáken mana ano ída afová ino van Yisasi inen mino. ");
INSERT INTO agd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Para va ino. Bei eyo iyampon kayo vei furin afova ameno van mino. Béi semí, “Banta kayo ayampin Banta Anin amintin béin aruan purinten mino. Aruan púdantin ma kanú manaú damú orivintin béi evaránen e mantanten mino.” ");
INSERT INTO agd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Máa síkan betí ankan ída mai vaya afová ukhen béin inain nan peren mino. ");
INSERT INTO agd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mairá betí ankan Kapeniamú oren mino. Oriven béi ma mápin báken betin inaemí, “Ayanafá tiretí ankan nái vará asive asive iya rafono.” ");
INSERT INTO agd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Máa síkan bei eyo iyampon kayo ano iyé minóti kákan ban nafino siren ayanafá asiven eriyaren béin ída siamen mino. ");
INSERT INTO agd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Maira Yisasi kumamen tiyan míkan mifo sirantan kan orun kádan (12) eyo iyampon aran eríkan betí ankan tiamemí, “Mana vanta ano ma kákaní ono van minó banta ánaimpá báken ná minói eyo vá bariyan bano.” ");
INSERT INTO agd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Máa siren Yisasi mana arara iyampon avían betin aúbanapin mantaan táden béin ayan bana fákaren o yafayóden betí ankan tiamemí, ");
INSERT INTO agd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Iye anó téin nan inireyá mana máan tukhein iyampon arará aya inten nafi mai ano séin mi siya inten mino. Inká iye anó téin tiya inten nafi mai ída séin tiya inten mifo Tifóe ma séin tisintá erikheruna mai véin mi aya inten mino.” ");
INSERT INTO agd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoni véin tiamen temí, “Aru soe, setí ankan onékun mana vanta ano éin avíkánamu aunan do siantiyaren mifo véi ída setí ankan ma manápá noin bantan bakái véin airo ananí uanté uno.” ");
INSERT INTO agd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Máa síkan Yisasi véin tiamemí, “Tiretí ankan ída vá béin airo anani uantano. Mana vanta ano ma séin tivíká ma mana avúavá daná ma uvariyaren mai vanta ano ída ainen téin nan namu vaya sinten mino. ");
INSERT INTO agd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Setin ma ída namuroí iyain banta mai setin tirona ino. ");
INSERT INTO agd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Téi fura siré tiretin tiamé uno mana ano ma siretin nan Yisasini kéká ino siren ma non dáan amin nain mano fura siren bei miyan baranten mino. ");
INSERT INTO agd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Banta ano ma mana auyen monó kéká ma séintá mumunan ukharé intin ma vetí ankan pinte ma e avíá dantin ma umefin orintin mae vá mai vanta amempin ná kákan onámaná kurená un nompin karúdantin námen aravino. ");
INSERT INTO agd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Éin ayan mano ma umefin ma avían kaintiya mai ayan ná tikareya karú dano. Mana ayan mana ma éin baréinti kanaíe éi ída kípan aunan baran nono. Mai kama inten mifo éin ma kankanan ayan ma áesin báken mana ayan mano umeí iyá intin mae ída kípan íra ma kiyan ma uman baren berai siyan purin barufin mi orin nono. ");
INSERT INTO agd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Éin arantan mano ma umefin ma avían kaintiya mai arantan ná tíkareya karú dano. Mana arantan mana ma éin baréintiya ída kípan aunan kanaíeya varan nono. Mai kama intenmifo éin ma kankanan arantan ma áesin báken mana arantan mano ma umeí iyá inti mae ída kípan ira ma kiyan ma uman baren berai siyan purin barufinmi orin nono. ");
INSERT INTO agd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Éin auu ano ma umefin ma avían kaintiya mai auu víaná karúdan orino. Mana auu ana ma éin baréinti Tiyarafenui yafisimpin oferan nono. Mai kama inten mifo éi ma kankanan auu ma áesin báken mana auu ano ma umeí iyá inti mae ída kípan ira ma kiyan ma uman baren berai siyan purin barufin mi orin nono. ");
INSERT INTO agd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mai varufin tító bintókéna kayo ma vetí ankan aufin bain mai ída furintin ira ída yusiminten mino. ");
INSERT INTO agd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tiyarafenu ano minó nanin banta kama ino van ara ara uman betin ané ma kaiyain mano irará ma iyó uren antereiní iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Un kama yaná ifo veni ase ma kípavintiya siretí ankan náisá uresin ná evaránen ase inten nafino. Éi un ande vá afá aváen má manafin kamaeya vano. ");
INSERT INTO agd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yisasi mai varu me ampiren Yudia varafá oriaren Yodan non e kháden ena ufá oríkan kokhon nanin banta ovaránen béi vaintá e átaru íkan béi ma iyain avúavasíen Tiyarafenui vaya vetí ankan tiamen mino. ");
INSERT INTO agd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tiamiyákan Farasisi kayo ano véi vaintá eriven béin akhenókaen temí, “Tetinti man baya ano kanaisá intin ná mana vanta ano ve aná ifá uantanten nafino.” ");
INSERT INTO agd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Máa síkan Yisasi evaránen betí ankan tiamemí, “Tiretí ankan Mosesi ano intéa man bayá amikhan nafino.” ");
INSERT INTO agd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Máa síkan betí ankan temí, “Banta ano ve ábasu ma yurafurin bompon uvamá daren ná be aná ifá uantanon Mosesi sikharen mino.” ");
INSERT INTO agd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Máa síkan Yisasi evaránen betí ankan tiamemí, “Tiretí ankan átakharé en nan mi Mosesi ma man baya siretin uvaman amikhan mino. ");
INSERT INTO agd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","PefáTiyarafenu ma araíen minó daná ma uvarein damú “béi vanta vá anasi vá uvaren mino.” ");
INSERT INTO agd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Máan tukhan mi vanta ano ve anóe afóen ampiren be aná bá manafin kasukhen mino. ");
INSERT INTO agd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Mai vanta vá anasi vá ano mana vukhafaí ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Máan tukhan ma Tiyarafenu ano veyantái vanta vá anasi vá maman kasuantákein mai vanta ano ída yaimin nono.” ");
INSERT INTO agd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Máa siran betí ankan ínaimpáké má naumpin oriven Yisasintá bei eyo iyampon kayo ano mai vaya van evaránen inaen mino. ");
INSERT INTO agd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Inaíkan béi vetí ankan tiamemí, “Mana vanta ano ma ve aná ifá uren ma ena nanin ma o varanten mai vanta ano mai nanin má pamúkuíi inten mino. ");
INSERT INTO agd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Inká mana nanin mano ma ve avafun ifá uren ma ena vanta ma o varanten mai nanin mano mai vanta vá pamúkuíi inten mino.” ");
INSERT INTO agd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Manáa ano Yisasin nan ayan ánontá kaú antanovare siren arará iyampon arinta aviren eríkan beni eyo iyampon kayo ano vetí ankan asen mino. ");
INSERT INTO agd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Asíkan Yisasi vetí ankan onan aran kiyaimpin temí, “Tiretí ankan áesin arará iyampon arinta séi varunafá erino. Tiyarafenui Yafisin mai kayo ma einí ukhein nanin banta ina ino. ");
INSERT INTO agd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Téi fura siré tiretí ankan tiamiyá uno mana nanin banta ano ma ída arará iyampon arinta anden ma Tiyarafenui Yafisin ída varanteya maifin ída kanaíeya oferan nono.” ");
INSERT INTO agd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Máa siren mai iyamporinta yafayó diyan ayan ánontá kaúden avu amen mino. ");
INSERT INTO agd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mairá Yisasi e manten oríkan mana vanta ano savaen me aron durafúden matimen temí, “Kama aru soe, séi inté ma erá ídakípan aunan barante rafuno.” ");
INSERT INTO agd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Máa síkan Yisasi véin tiamemí, “Pará éi séin nan kama e siya fono. Tiyarafenu veyáká anan kama ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Man baya éi afová ukha ono. ‘Ída vá banta aruan purono.’ ‘Ída vá ábasu namu ono.’ ‘Ída vá umoyan daná barano.’ ‘Ída vá ena vanta kampun kó tiantano.’ ‘Ída vá kampun tire ena ína yaná barano.’ ‘E anoifon aránaó pasá bano.’” ");
INSERT INTO agd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Máa síkan mai vanta ano Yisasin tiamemí, “Aru soe, séi ma iyampon táké eré tare ma e varúna mai man baya kayo máa minó bákuriyá uno. ");
INSERT INTO agd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Máa síkan Yisasi véin ódaren arunaná máden béin tiamemí, “Éi mana yaná o útúka ompo ei ona minó mo sarí ure vá ona ma ída van nanin banta mai moní ameno. Amiráka mae mai ínaimpáké inaru fáke kama yaná baran nompo eriveya séin tivákurono.” ");
INSERT INTO agd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Máa síkan mai vanta ano kokhon ona kaúdákaréin ará ano uman diyaimpin me ampiren oren mino. ");
INSERT INTO agd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Orivíkan Yisasi vei eyo iyampon kayo onen eúkiyan temí, “Ona ma kokhon kain ma vain banta ano Tiyarafenui yafisimpin ída kanaíen oferanten mino. ");
INSERT INTO agd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Máa síkan bei eyo iyampon kayo mai vaya van anúden orera íkan Yisasi evaránen betí ankan tiamemí, “Tikhafana oe, banta ano ma Tiyarafenui yafisimpin ma oferan mai ákona yoran mino. ");
INSERT INTO agd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kameri ano ma ufi aimpin ódin mai uman dakhen mifo kokhon ona ma yákein kéká ano ma Tiyarafenui yafisin barufin ma ódin mai moéken uman mi yakhen mino. ");
INSERT INTO agd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Máa síkan beni eyo iyampon kayo anú duren betiyan ten orera emí, “Máan ma ukhantin maen mai iye ná Tiyarafenu ano kanaíen aviranten nafino.” ");
INSERT INTO agd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Máa síkan Yisasi vetí ankan kakháben temí, “Minó danápin banta ano ída kanaí inten mifo Tiyarafenu veyáká anan kanaí inten mino.” ");
INSERT INTO agd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Máa síkan Pita ano Yisasin mana vaya siamemí, “Ineno setí ankan minó daná me ifá uréi éin dakhafiyá uno.” ");
INSERT INTO agd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Máa síkan Yisasi semí, “Téi fura siré tiretin tiamé uno. Manáa vanta kayo ano ma sen má tenti kama vaya va san ma iniren afá aváen má ayofin má anóe afóen má iyampon má dunan ana vá ma me ampikharen maen ");
INSERT INTO agd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","betí ankan ena mana antaretivá (100) baranten mino. Betí ankan ma varará para vantin Tiyarafenu ano vetí ankan ma fefa mantá ein danasinta esantaren kokhon daná aminten mino. Betí ankan kokhon má bá afá aváen má ayofin má anóe afóen má iyampon má dunan ana vá barantin maen manáa vanta kayo ano vetin namu avúavá uantanten mino. Máan uantiyaré intin ínaimpá ma yamú afoká intin ída kípan para oriyan ban aunan baranten mino. ");
INSERT INTO agd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Baranten mifo aní maen oriyain nanin banta kayo ano ínainí intin ínainí maen oriyain nanin banta kayo ano anona aní inten mino. ");
INSERT INTO agd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Máa siren ínaimpáké betí ankan e manten Yarusaremí ódono van aayana oren mino. Yisasin nare an oríkan beni eyo iyampon kayo ano kokhon ineine iyákan betí ankan ma avákuren noré ein nanin banta ano akhokho van en mino. Máan tíkan Yisasi sirantan kan orun kádan (12) eyo iyampon kayo ádun avían kaúden be ané ma afoká inain baya enádá evaránen tiamen mino. ");
INSERT INTO agd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Yerusaremí ódé tifékun maen mana vanta ano Banta Anin maman monó ánon banta kayo vá man baya ma afová ukhein banta kayo vá ayampin kaintin béin aruan purono van betí ankan kó tiantanten mino. Béin ída Yutan banta anampin aminten mifo ena anan bantafin mi aminten mino. ");
INSERT INTO agd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Amintin maen betí ankan mano véin ayanavan baya sen akhare sen dafiyó ankamen uren béin aruan purinten mino. Aruan púdantin kanú manaú damú orivintin maen béi evaránen e mantanten mino.” ");
INSERT INTO agd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Máa sirákan Sebetin anin kanan Yemisin nú Yonin nú ano véi vaintá eriven temí, “Aru soe, berasan mana yana san ina urékuya éimai yanasí berasan usintano van muno.” ");
INSERT INTO agd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Máa síkan béi evaránen békanan tiamemí, “Tiré kanan téi nái yanasisá uantano vará iya fono.” ");
INSERT INTO agd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Máa síkan béin tiamemí, “Ínaimpáké ma éi ma kákan Kiní uvesí berasan pintena mana ano éin ayan kurompá kumanintin mana ano ayan ópá kumanintí ono van muno.” ");
INSERT INTO agd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Máa síkan Yisasi evaránen békanan tiamemí, “Tiré kanan ma séi ma inaiyaona mai yaná ída siré kanan afová ukhe ono. Téi ma saréa ma nanuna kápifin tiré kanan kanaí neyá inká téi ma feranuna non pereyá inte rafono.” ");
INSERT INTO agd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Máa síkan békanan béin tiamemí, “Berasan kanaí onte uno.” Síkan Yisasi vékanan tiamemí, “Pura ino saréa ma séi ma nanuna kápifin tiré kanan má maifin nan nono. Téi ma feranuna non tiré kanan má peran nono. ");
INSERT INTO agd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Máan tin nompo séin tiyan kurompá kumanintin tiyan ópá kumanintin ma in mai ída sen tina yaná ino. Tiyarafenu veyantái mai kumanin manáa vanta kayo aminten béi fefái vetin nina funtáadan ban mino.” ");
INSERT INTO agd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Máa síkan tiyan míkan eyo iyampon kayo ano iniren Yemisin nú Yonin nú anan uanten mino. ");
INSERT INTO agd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Anan uantákan Yisasi vetí ankan arákan béi vaintá eríkan betin tiamemí, “Tiretí ankan afová ukha ono ánon banta kayo ma ída Tiyarafenurá ma mumunan iyain nanin banta kayorá ma yafisé iyain mai vetí ankani ákona vákan mi yafisé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dafisiyan mifo siretí ankampin ída vá ma avúavá bano. Tiretí pinté ma kákaní ma ono van béi vá tiretíi yoran banta vá bano. ");
INSERT INTO agd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mana ano ma siretíi ánon bantaí ma ono van béi vá minói miyan ída van doran banta vá bano. ");
INSERT INTO agd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mai fara vara seyo, Banta Anin ma erikhein mai véin ayaen dóantano vará erikhen naino. Ída ino. Béi vanasi ayaen doren be aunan amintin mai ano kokhon nanin banta miyaní uren avirano van mino.” ");
INSERT INTO agd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Betí ankan Yerikó barurá oren mino. Béi Yerikó me ampiren oríkan bei eyo iyampon kayo vá kokhon nanin banta kayo vá béi oriyákan Timeasin anin Batimeasin auu yufúkukhan aa akhempá kumanten banasi vaípá moni san inantiyaren mino. ");
INSERT INTO agd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Inantiyaren iníkan Nasaretíké Yisasi eriyan mino síkan béi avádóden oovaren temí, “Devitin anin Yisasi oe, séin nan éi arunan usintano.” ");
INSERT INTO agd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Máa síkan kokhoná banta ano véin asen temí, “Ei vaya fákano.” Máa síkan mai vanta ano moéken avádóden enádá oovaren temí, “Devitin anin noe, séin nan éi arunan usintano.” ");
INSERT INTO agd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Máa síkan mairá Yisasi o mantaven temí, “Béin aresin erino.” Síkan betí ankan mai auu yufúkukhein banta araren béin tiamemí, “Éin ará ano vá ákona ino. Éin ariyan mifo e mantano.” ");
INSERT INTO agd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Máa síkan béi vei au anamun me karúdaren e manten Yisasi vaintá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Oríkan Yisasi véin tiamemí, “Éin náisá téi uantano vará inikhe fono.” Máa síkan mai auu yufúkukhein banta ano véin tiamemí, “Aru soe, séi evaráné onarami iyá uno.” ");
INSERT INTO agd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Máa síkan Yisasi véin tiamemí, “Éini mumunan mano éin evaránen kama uanten mifo orono.” Máa siyain má manádá ano ainen béin auu kama uvin oniyáken Yisasin bákuren ayanafá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Máan turen Yisasi má bei eyo iyampon kayo vá ano Yerusaremí áde suron oriven Orifí Anuyon ádé ma Betfakhé baru vá Betaní baru vá baintá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Oriven mai ráké Yisasi vei eyo iyampon kayo fintena kankanan tianten temí, “Tiré kanan ma mesan barufá oriveya onesin maen mana ano ída ané kumantan nain donkin ayanan kurantin banten mino. Mai vá ayanan utú deya séi varunará bare ereno. ");
INSERT INTO agd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Eresin ma mana ano ma siré kanan inaen ma ‘fará máan tiya fono’ ma sintiya vá béin ná tiameno, ‘Bafani yoran bákan mi véi sisintá e aviriyarúna veni yoran ma kípantin ainen ovaránen tiantantin erinten mino.’” ");
INSERT INTO agd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Máa síkan beni eyo iyampon kanan mai varufin oriven onákan aa akhempá mana namun onará ayanan kuran baré íkan míkanan mai donkin ayanan mo útufen mino. ");
INSERT INTO agd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Útufíkan manáa vanta mairá áde mantakharen békanan inaemí, “Tiré kanan náisá intoyá mai arará donkini ayanan útufiya fono.” ");
INSERT INTO agd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Máa sen ina íkan Yisasi ma vékanan tiamein baya máa mai kayo siamíkan “Kana ifo avirano” síkan mai donkin békanan aviren oren mino. ");
INSERT INTO agd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Oren mo Yisasi vaintá mai donkin kaúden békanani au anamun davá den mai donkin ané uvídan Yisasi mairá kumanen mino. ");
INSERT INTO agd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kumamen oríkan kokhon nanin banta ano vetíi au anamun davá diyan aasá uvisin manáa ano yaa ayan iyaren uvisíen mino. ");
INSERT INTO agd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Máan tiyákan manáa nanin banta ano auufá orin manáa ano oyampá orin iyáken oovararen temí, “Bafani avisá daní ono!” “Bafani avíká ma eriyain avisá daní otifano!” ");
INSERT INTO agd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Ma ma eriyain tétin tinafu Devitini yafisin an dakhein mifo avábasá ino.” “Tiyarafenui avisá moéke yani suron ono!” ");
INSERT INTO agd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Máa siyákan Yisasi Yerusaremí o unaven monó namumpin un pében minó daná onen eúkiyan áau eraven inúpasí íkan bei sirantan kan orun kádan (12) eyo iyampon máa vá Betaní oren mino. ");
INSERT INTO agd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ená damú Betaní me ampiren eriyá íkan Yisasin arafan puren mino. ");
INSERT INTO agd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Arafan puriyan eriyaren béi onákan manáa nentá mana ananoni ukhein fiki anaa ampantan béi mai anafin aranan doseno van oren mino. Mai fiki ano ma aran iran damusí ída ukhan ananon dakhaní ana ukhan mai yaa anafin oriven onákan ída mana aran baren mino. ");
INSERT INTO agd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Máan tukheimpin Yisasi mai fiki yaa van temí, “Éini aran mana ano ída vá evaránen nano.” Máa síkan bei eyo iyampon kayo mai vaya inen mino. ");
INSERT INTO agd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Betí ankan Yerusaremi oriven Yisasi kákan monó namumpin ódiven maifin ma sarí iyan ma miyaní iyá ein kéká bá inká moní arumiyan ma nun kayo sarí urákan ma miyaní iyá ein takhó bá kumanin má banaan karú diyáken do sianten mino. ");
INSERT INTO agd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Banaan karú daren betí ankan ma minó daná baren kákan monó namumpin ma non airo ananí uanten mino. ");
INSERT INTO agd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Uantáden betí ankan tiamemí, “Tiyarafenui vompon dóki ano ída máa sikhen nafino, ‘Téin timá ma vain mai minó nanin banta ano vá amúkin namun mino vá teno.’ Máan ná tin nompo ‘siretí ankan mano mai namun maman umoyan banta kayoi aúpá baruíi e ono.’” ");
INSERT INTO agd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Máa siyákan monó ánon banta kayo vá man baya ma afová ukhein banta kayo vá ano mai vaya iniren béin ma arin nain avan araíen dosen mino. Dosiyan mifo minó nanin banta ano véini vaya van kákantá anúden orera iyan mai van béin nan betí ankan peren mino. ");
INSERT INTO agd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mairá inúpasí íkan Yisasin má bei eyo iyampon kayo vá Yerusaremí me ampiren oren mino. ");
INSERT INTO agd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ená damú pe ákurá betí ankan oriyaren onákan mai fiki yaa ana anaa vá arú bá minó ira khakhan onen mino. ");
INSERT INTO agd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ódaren Pita mai van ovaren inen temí, “Aru soe, inuran ma ma fiki yaa van ma namu ono ma seona mai inka irakhen mifo onano.” ");
INSERT INTO agd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Máa síkan Yisasi evaránen tiamemí, “Tiyarafenu rasá mumunan ono. ");
INSERT INTO agd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Téi fura sé uno. Éi kanaíeya ma anuyon nan teya ‘anuyon noe, e ankábore un nonafin oferano ma’ sesin maen mai ano fara éi ma sinonaí inten mifo éi ma ída kankanan ineine vanti ma mumunan ma ukhesin mi Tiyarafenu ano mai yanasí uantanten mino. ");
INSERT INTO agd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tiretí ankan ma mana yaná baranton iyáke ma amúkiya mumunan e ma fura mai yaná tetí baranté uno ma sesin mai ma siretí ankan ma varano van muno ma sinona yaná ano afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Inten mifo siretí ankan ma mana vanta ano ma namu uantáká inti mae amúkiya mai vantai ume vá ifá uantano. Ifá ma uantesin maen mai siretí afóe ma inarufá bain mano siretíi ume ifá uantanten mino. ");
INSERT INTO agd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Enádá Yisasin má bei eyo iyampon kayo vá Yerusaremí oriven béi kákan monó namumpin nókan monó ánon banta kayo vá man baya ma afová ukhein banta kayo vá ánon banta kayo vá ano véi vaintá eren mino. ");
INSERT INTO agd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Eriven betí ankan béin inaemí, “Éimpin intéa ákoná bayá éi máan tiya fono. Iye ano éin mai ákona amiren ná éin nan mai yorarí ono sikhen nafino.” ");
INSERT INTO agd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Máa síkan Yisasi evaránen betí ankan tiamemí, “Téi mana yana san tiretí ankan ina onté uno. Inaéku ma ovaráne mai vaya ma séin tisimídesíi mai séi ma manté doriyarúna ákona siretin tiamenté uno. ");
INSERT INTO agd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tiyarafenu anó Yonin monó non péantan doran amen nafino áa vanta ano mai yoran amen nafino. Tiretí ovaráne vaya séin tisimeno.” ");
INSERT INTO agd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Máa síkan betiyan ten orera emí, “Teti ma sé Tiyarafenun anon mai yoran Yoni amikhan mino ma sékun mai siretí ankan, ‘Pará ída mairá mumunan iya rafono,’” sinten mino. ");
INSERT INTO agd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Máa sinten mifo setí ma sé, ‘Banta anon mai yoran amikhen mino,’ ma sékun mai ano ída kanaí inten mino.” Yoni sakhanampa vanta uron mino sen minó nanin banta ano inikhan mai van mi vetí ankan peren mino. ");
INSERT INTO agd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Máa siren betí ankan evaránen Yisasin tiamemí, “Tetí ankan ída afová ukhé tiféuno.” Máa síkan Yisasi vetí ankan tiamemí, “Téininte ákoná bará doriya rafuno. Mai siretin ída siamenté uno.” ");
INSERT INTO agd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yisasi araíen baya vaédiyan betin tiamemí, “Mana vanta ano uvaini yunan dóden dafuí uran baré íkan mai vanta ano uvaini ma yasamin nain masí uáden inká dafisin banta amá uvamá den uran baren mino. Baré íkan manáa vanta kayo ano maifin dorarí uré moní barano van íkan mai vanta kayo ayampin me ampiren béi enafá ayáká oren mino. ");
INSERT INTO agd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Orikharéin ínaimpáké uvaini aran kúdin damusí íkan béi mana vei yoran banta siantan mai ma uvaini yunampin doriyá ein banta kayo vaípá oren mino. Mai vanta kayo ano manáa uvaini aran mai yunan pintena véin amino van tiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Oríkan betí ankan mai yoran banta fákaren namu arirí uren ída mana yaná amin para siantan oren mino. ");
INSERT INTO agd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Oriyaimpin mai vanta ano evaránen ena yoran banta siantan oríkan betí ankan mai vanta ánon ankáden béin máden namu uren ayave amen mino. ");
INSERT INTO agd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Máan tiyaimpin béi mana vei yoran banta siantan oríkan betí ankan mai vanta aruan puren mino. Aruan puriyaimpin béi kokhoná bei yoran banta kayo siantan oríkan betí ankan manáa ankamiyan manáa aruan puriyan en mino. ");
INSERT INTO agd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Máan turákan béi ma anunu ukheinmai ve anin mana ana en mino. Mai iyampon típá kípan uron béi siantan mai ma yunampin ma yoriyain banta kayo vaípá oríkan béi semí, “Téin tikhái vayan ininten mino.” ");
INSERT INTO agd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mai yunampin ma yoriyá ein banta kayo ano vetiyan ten orera emí, “Ma vanta anon minó be afóen nina yaná baranten mifo erítifé béin aruan purono. Aruan púdé maé tetí ankan mai yunan dafu varátifano.” ");
INSERT INTO agd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Máa siren betí ankan mai iyampon pákaren aruan púden béin au yaiyó uan mai yunan dafu akhempá mo kharúden mino. ");
INSERT INTO agd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Karúden mifo mai yunan dafu afóe ano intesá inten nafino. Béi eriven maen mai yunan dafufin ma yoriyá ein banta kayo me aruan púden mai yunan dafu e maman ena vanta kayon aminten mino. ");
INSERT INTO agd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tiyarafenui vompon dóki ano ma máa sikhein mai siretí ankan ídá dankáke rafono. “‘Má uvaran banta kayo ano ma yo maman karúdein onámaná ano maman má dádaimpin mana ákona onámanasí ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mai Bafan mánon máan turan mai anon tetin tivorá kama ukhen mino.’” ");
INSERT INTO agd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yisasi ma sian baeriyain baya mai vetí ankan nan tiyákan afová uren béin pákano van uvaen banasi van péden me ifá en oren mino. ");
INSERT INTO agd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ínaimpáké Yisasin mákasino van betí ankan manáa Farasisi kayo vá Erotini vanta kayo vá tiantan Yisasi vaípá eren mino. ");
INSERT INTO agd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Eriven betí ankan béin tiamemí, “Aru soe, setí ankan afová ukhé uno éi fura vaya ana sin banta ono. Éi ída mana vanta van kokhon ineine in banta ono. Minó banta ano manaí ana ukhayai éi Tiyarafenui fura sikhein baya afova amé iya ompo setin tisimeno. Sisan ma takisi amin mai funtákein ná tetí amé tifante rafuno áa ída fino.” ");
INSERT INTO agd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Máa síkan Yisasi vetí ankani kampun afová ukhen betin tiamemí, “Tiretí ankan pará téin akhenóka iya rafono. Mana aran moní bareya eresí onano.” ");
INSERT INTO agd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Máa síkan betí ankan mana moní aran maman bein me amíkan betin inaemí, “Ma moníká iyen aunasá baná inká iyen avisá mairá uvanten nafino.” Máa síkan betí ankan evaránen temí, “Kin Sisan mino.” ");
INSERT INTO agd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Síkan Yisasi vetí ankan evaránen tiamemí, “Sisan nina yaná Sisan ame vá inká Tiyarafenu ina yaná Tiyarafenu vá ameno.” Síkan betí ankan kákantá anúden mino. ");
INSERT INTO agd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadyusi kéká ano furin nanin banta van ída e mantanten ne siyain bákan betí ankan Yisasi vaintá eriven béin inaen mino. ");
INSERT INTO agd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Aru soe, mana vaya Mosesi ano setí ankan nan máa siren bompon uvanten mino. ‘Mana vanta ano ma iyampon ída kainton ma fúbintin ben aná ma fara váintin maen ná béin afá aváe ano vá mai nanin baré mamákená be afá aváen ayaená iyampon kaúantano.’ ");
INSERT INTO agd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Dan manápá ifo afápá kan un kádan anavádano varé íkan mai finté esé banta ano nare mana nanin mamákaren ída mana iyampon kainton mai vanta furen mino. ");
INSERT INTO agd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Púbíkan béin ánaintena vanta ano mai nanin mantaren ída iyampon kaina mai vanta furen mino. ");
INSERT INTO agd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mai nanin minó dan manápá ifo afápá kan un kádan anavádano mádiyan ída iyampon kaina yo fúdú uvíkan mai nanin inaimpáké puren mino. ");
INSERT INTO agd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Máan tukhen mifo ínaimpáké ma furin banta ma evaránen e mantan nain damú mai nanin iyen anasá banten nafino. Mai éi afová ukha ono mai nanin manan minó dan manápá ifo afápá kan un kádan banta ano mantaren mifo éi sétin tisiminte fono. ");
INSERT INTO agd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Máa síkan Yisasi evaránen betí ankan tiamemí, “Tirarafenui vaya vá ákona vá tiretí ankan ídá afová ukheyá baya namu iya rafono. ");
INSERT INTO agd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Purin nanin banta ma masí pinté ma evaránen e mantan nain damú ída vanasi ano ábasuí inten mifo vetí ankan enisori kayo ma inarufá bain an mi yen banten mino. ");
INSERT INTO agd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Banten mifo furin nanin banta ma evaránen e mantan nain baya ma Moseni vompon dókifin ma sító daa anan ma ira kiyan ma Tiyarafenu ano ma Mosen tiamen ma, ‘Téi Abaraamuni Ayarafenu uno. Téi Aisakini Ayarafenu uno. Téi Yekopuni Ayarafenu uno,’ ma sein mai siretí ankan ídá dankáke rafono. ");
INSERT INTO agd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Purin nanin bantai Ayarafenu vaino. Ída ino. Para ma vain nanin bantai Ayarafenun bákaya siretí ankan tavi aaimpin mi oriya rono.” ");
INSERT INTO agd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Máa siyákan mana man tinbanta ano eriven iníkan betí ankan baya fóké aruviyákan béi inin Yisasi kama vaya fóké evaránen betí ankan tiamiyákan iniren béi Yisasin inaemí, “Intéa man baya anó minó man baya esantaren ná esesí ukhen nafino.” ");
INSERT INTO agd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Máa síkan Yisasi evaránen béin tiamemí, “Esésí ma ukhein mai ma man baya ino: ‘Tiretí ankan Isareri nanin banta oe, setisi Bafan Tiyarafenuveyáká anan Bafan ban mino. ");
INSERT INTO agd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ban mifo vá ei Bafan Tiyarafenu vá ei aú amafon má ei ineine vá ei ákona vasá minó o éke e éke ureya vá anunu ono.’ ");
INSERT INTO agd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mai man baya ánai ma vain man baya mai ma man baya ino. ‘Eyan nan ma anunu iyaonaíe vá ena van anunu ono.’ Ída ena kákan man baya váken mai ano má kanan man baya esantakhen mino.” ");
INSERT INTO agd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Máa síkan mai man baya ma afová ukhein banta ano máa sen Yisasin tiamemí, “Aru soe, éini vaya kamaen mino. Pura ino. Tiyarafenu veyákái Bafan ban mino. ");
INSERT INTO agd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ban mifo seti vá minó tú timafon má minó ineine vá minó ákona vá pókesá béin nan tiran ná tifano. Tetí ankan ma seyan nan ma iyarúna máan ná esá enavan tiran ná tifano. Tetí ankan ma maí kanan man baya ánain ma vákurékun maen mai avúavá anon ira ma sáden minó akonte iyain má ara ara akonte vá esantakhen mino.” ");
INSERT INTO agd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Máa síkan Yisasi inin mai vanta ano ma evaránen tein baya van mai mana kama afova vain banta ano ma seiní íkan Yisasi evaránen béin tiamemí, “Éi ída Tiyarafenui yafisimpin nentá ba ono.” Máa síkan minó nanin banta kayo ano akhokho van uren Yisasin ída enádá bá mana vaya inaen mino. ");
INSERT INTO agd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yisasi átaru namumpin báken banasi vaya siamiyaren béi semí, “Intesá ukhan ná man baya ma afová ukhein banta kayo ano Karaisi nan Devitin akhá ino siyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mai van Kantá Aunan mano Devitin ineine amíkan Deviti veyantá máa semí, “‘Bafan mano senti Bafan ne máa sen tiamen mino, “Éi sen tiyan kurompá kumaneno. Ínaimpáké eni namuro kayo séi maman éin aránaópá kaonté uno.” ’ ");
INSERT INTO agd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deviti veyantá béin nan Bafan ne sikhen mifo véi intesá urená bei anin bavae.” Máa síkan beni vaya kokhon nanin banta ano amusin iyan inen mino. ");
INSERT INTO agd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iniyákan Yisasi vanasi afova amen temí, “Tiretí ankan man baya ma afová ukhein banta kayo vará dafiseno. Betí ankan kama ukhein ayá au anamun ma uren orin má átaru varu ráke ma vanasi ano ódaren bayan mino ma sin ma san aranakhen mino. ");
INSERT INTO agd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Betí ankan monó átaru namun kayofin banasi avorá ma kumamen inká kákan dunan nan damú ma esé karáká ana ma kumanin nan mi aranakhen mino. ");
INSERT INTO agd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Betí ankan baré nanin kayo kampun tiriyan betíi ona umoyan iyáken au khákan en ayáká amúké iyan mifo mai kéká anon Tiyarafenui kópin kákan uman baranten mino. ");
INSERT INTO agd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Maná damú kákan monó namumpin Yisasi moní kain anan ádé kumanten oniyákan banasi ano susu sin moní mai anampin kuferiyákan kokhon moní ma yákein kayo ano kokhon ná moní kuferiyan mino. ");
INSERT INTO agd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Máan ten kuferiyákan mana ve avafu fúkein baré nanin ída kokhon ona vain mano eren me kankanan tító moní kanan mana ten toeya ma (10t) eini ukhein kuferen mino. ");
INSERT INTO agd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kuferiyákan Yisasi vei eyo iyampon kayo aran eríkan betí ankan tiamemí, “Téi fura siré tiretin tiamé uno. Ma ma ona ída van ma ve avafu fúkein baré nanin mano kákan moní kuferen mino. Béi ma átaru namumpin bain anampin ma kuferein moní ano minó nanin banta esanten mino. ");
INSERT INTO agd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Esanten mifo ona ma yákein nanin banta ano kokhoná dáken mai finténa manáan anafin kufé dan araviyan mifo ma nanin mano ona ída van o útúken mi yunan ma nan nain moní ída antan á inton minói kuferen mino.” ");
INSERT INTO agd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yisasi kákan monó namun me ampiren eriyákan mana vei eyo iyampon mano véin tiamemí, “Aru soe, onano ma monó namun kákan onámaná kayo vá kama yanasinta vá pókéi uvádan ban mino.” ");
INSERT INTO agd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Máa síkan Yisasi evaránen béin máa sen tiamemí, “Éi ma kákan má oniyaona mai finténa ída mana onámaná áintin benané benané ukhen banten mino. Ída ino. Minó onámaná barákuan karúdantin barará erafuvintin ída mana onámaná benané benané ukhen banten mino.” ");
INSERT INTO agd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ínaimpáké kákan monó namun e omaren Orifí Anurá Yisasi kumantan Pitan má Yemisin má Yonin má Endurun má betí ana váken betí ankan Yisasin inaemí, ");
INSERT INTO agd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tetin tisimeno, inte yamusá mai yanasinta afoká inten nafino. Intéa aní daná naré afoká intí tetí óde afová erá mai yanasinta inka afoká in ádé en mino sente rafuno.” ");
INSERT INTO agd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Máa síkan Yisasi vetí ankan tiamemí, “Manáa nanin banta ano siretí ankan maka sinten mifo yafían ná ákona ono. ");
INSERT INTO agd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kokhon banta ano eriven téin tiví taraaren tinten mino séi Tiyarafenu Anin banasi avirantá ma siantan erikhá ein banta uno siren betí ankan mano kokhon nanin banta máka sinten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ínaimpáké tiretí ankan ma aruvin baya vá aruvono van ma siyan nain baya vá ma ininteya ída vá tiretí ankan anú duman duman ono. Mai yanasinta afoká uvintin mi kípan damútasoren mí erinten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mana anan banta ano e manten ena anan banta vá aruvintin inká mana kini kéká ano e manten ena kini kéká bá aruvintin inka manáa akhempá bara kaya intin kákan arafan purinten mino. Mai yanasinta maen anasi ano ma iyampon kaono van inamunan iniyan ai san aureiníi inten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Máan mi inten mifo siretí ankan dafían ná ákona ono. Betí ankan mano vetíi ánon banta kayorá tiretin kó tiantanten mino. Kó tiantáden betíi monó átaru namun kayofin tiretin ankaminten mino. Ankáden betí ankan téin tiví maman bararasí ono van iniyáken kamanin banta kayo vá kin kayo vá avorá mantaan táden duvun intiya séinti vaya vetí ankan tiamin nono. ");
INSERT INTO agd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ínaimpá mai yanasinta afoká inten mifo kama vaya nare vá minó nanin banta siameno. ");
INSERT INTO agd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Máan tinten mifo veti ankan ma siretí ankan pákaren ma kópin mo khaintiya sireti ída vá akhokho van eya inte vayá tente rafuno sireya ineine ono. Mai áaurá ma eni ineinefin ma erin nain mai Tiyarafenu anon amen mifo mai vaya vá teno. ");
INSERT INTO agd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Máan intin be afá aváe ano e mantaren be afá aváen aruan purino van namuro vanta kayo ayampin aminten mino. Amintin be afóe ano e mantaren be akhá aruan purino van namuro vanta kayo ayampin aminten mino. Amintin be akhafana ano e mantaren be anóe afóe aruan purinten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Minó banta ano siretin namu uantanten mifo mai farava ino séin tiví tiretimpin bantin mino. Máan tinten mifo éi iye anó ákona iyá inte fono mai kípan damú éin Tiyarafenu ano evaránen aviranten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Baru ma namu inain mai namu yana suron mi erintiya siretí ankan onan ono. Béin nan ída vano ma sikhá ein mai varurái mantakhen banten mifo ma vaya ma yankafin nain mano kama vá en inino. Máan ma inain damú minó nanin banta ma Yudiá ma vain mano vá anu yonpimpasá karan orino. ");
INSERT INTO agd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Máan ma intin maen má daró ma váin nain banta ano ída vá erafuven má naumpin un pében be amá pinte yanasinta varano. ");
INSERT INTO agd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Máan ma intin dunampá ma orikháin nain mano ída vá evaránen bei au anamun ovarano. ");
INSERT INTO agd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Máan ma intin maí damú amúbá nanin kayo vá arará iyampon ma nan kuviyain nanin kayo va san mi sirunken mino. ");
INSERT INTO agd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Amúkesiná mai avúava sinta iyon ma in damú ída vá afoká ino. ");
INSERT INTO agd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Maí damú kákan uman mi vanten mifo esé ma Tiyarafenu ano ma araíen inaru vara ma uvarein táké ma eren tare ma varúnará ída máan ukhein uman pefá afoká ukharen mino. Ínaimpá ída máan uman banten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bafan mano ma máan damú ída ma maman asíkaí intin maen minó nanin bantan afeyoranten mifo veyan ma fe iyákein nanin banta van ma iniyáken maen maí damú maman asíkaí inten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Máan ma intin maí damú manáa vanta ano siretí ankan tiaminten mino, “Onano masí na Tiyarafenu ano ma aní ukhein banta van mino. Áa mesápá ban mifo onano.” Máan ma sintiya siretí ankan ída vá mai van mumunan ono. ");
INSERT INTO agd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Manáa vanta kayo ano eriven kampun ten máa sinten mino, “Téi Tiyarafenu Anin banasi avirano van ma siantan erikhein banta uno. Téi mana sakhanampa vanta uno,” siren ara ara avúavá daná afoká en ara ara yoran baranten mino. Máan tinten mifo veti ankan ma kanaí inten Tiyarafenu ano ma veyan iyádan bain nanin banta kéká kanaíen kufa uádanten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Máan tukhen mifo siretí dafíaná ákona ono. Téi minó dana san inka siretin tiamé uno. ");
INSERT INTO agd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Máa siren Yisasi enádá betí ankan tiamemí, “Mai minó uman ma kípavintin “‘áau ano ída e unintin biyon mano enádá ída kanten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Máan tintin inaruráké ofu kayo kararen eravintin inarurá ma ákona yanasinta vain mano kayamana inten mino.’ ");
INSERT INTO agd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Máan ma sin nain maí damú betí ankan onantin mi Banta Anin mano kakhan má ákona vá mamaren ayompin erinten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Eriven maen maí damú bei enisori kayo siantantin oriven beyan ma iyákaré ein nanin banta avían átaru inten mino. Béi mino inaru vá bara vá ma o útúkein akhen páke yeren aviranten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ena aní daná ba san Yisasi afova siamemí, “Fiki yaa ana ano sétin afova simé iyan mino. Daa ayan mano ma amun amun in ma auyen amun basen oriyan maen mai inka á kanten mino siya ono. ");
INSERT INTO agd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Máan manan ukhen mino ínaimpá ma siretí ankan onesin ma mai yanasinta afoká inti vá mai inka erikhen onará mantakhen mino vá te afová ono. ");
INSERT INTO agd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Téi fura siré tiretin tiamé uno. Ma ma saréa ma vain mai nanin banta ída fúkantin mi minó mai yanasinta afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Máan tintin maen inaru vá bara vá kípanten mifo séinti vaya ída aiyoranten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ída mana nanin banta ano mai yamú bá mai áau vá afová ukhen mino. Inarurá bain enisori kéká bá Tiyarafenu Anin má ano yere ída afová ukhen mifo ve Afóe veyáká anan mai yaná afová ukhen mino. ");
INSERT INTO agd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Máan tukhen mifo siretí ankan utá are yafíke vá bano. Tiretí ankan ída afová ukha ono inte áau rasá mai afoká inten nafino. ");
INSERT INTO agd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mai máan mi ukhen mino. Mana vanta ano ma ve amá me ampiren enafá orono van maen bei yoran banta kayorái veina yaná daíden amé iyan mino. Máan turen maen mi onará ma yafisin banta van kama vá eya yafiseno sé iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Máan tukhen mifo siretí ankan dafian ná ákona ono. Tiretí ankan ída afová ukha ono intéa yamusá mai má afóe erinten nafino. Béi inúpákesá erinten nafi áa inuran aúbanasá erinten nafi áa kokore asin pintesá erinten nafi áa ákura sá erinten nafino mai siretí ída afová ukha ono. ");
INSERT INTO agd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tiretí ankan aunká bakharé esin béi ainen eren e onanten mino. ");
INSERT INTO agd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ma ma séi ma siretin tiamerúna mai vaya anan minó tiamé uno, ‘Tiretí dafíke vá bano.’” ");
INSERT INTO agd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yisi Ída Van Bereti Ma Nan Omá Damú ma afokáin mai kan damú ana ukhan monó ánon banta kayo vá man baya ma afová ukhein banta kayo vá temí, “Intesá urerá tetí Yisasin kampun tirerá pákaré béin aruan puró tifante rafuno.” ");
INSERT INTO agd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Máa siren betí ankan temí, “Mai kantá damú ída vá tetí ankan máan tono mai vanasi ano e manten aruvin afoká inten mino.” ");
INSERT INTO agd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Máan tiyákan Yisasi Betaní barufá oren amon daná aí bain banta Saimonin amá karáká o kumamin mana nanin mano kákan esantakhein moníká bain aunka uveri anan mamaren eriven mai aunka uveri anan me yuvaren Yisasin ánontá banaen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bana íkan maifin manáa vanta kayo varen aran naná máden betiyan ten oreraen temí, “Pará ma aunka uveri fasavifá afe iyan nafino. ");
INSERT INTO agd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tetí ankan ma kanú manaú antareti (300) moníká sarí uré ma mai moní mádé ma ona ída van nanin banta ameren mino. Máa siren betí ankan mai nanin asen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Asíkan Yisasi vetí ankan asen temí, “Tiretí ankan mai nanin áduantaro. Nái vará tiretí ankan béin uman amiyara fono. Béi ano séin kama avúavái usintiyan mino. ");
INSERT INTO agd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ona ída van nanin banta kayo ano ena ena siretin má bantiya aya ono ma sinte aya in nompo séi ída siretin má ena ena vanté uno. ");
INSERT INTO agd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Anasi ano ma variyain mai yaná inka véi máantin kípen mino. Téin tufá ma véi aunka uveri ma vanaein mai séi ma masípin oronunan úta sinten mino. ");
INSERT INTO agd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Téi fura siré tiretin tiamé uno. Minó bara akhempá ma monó baya ma siamin nain maifimpá deren ma nanin mano ma varein avúavá dana san tiren béin nan ininten mino.” ");
INSERT INTO agd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Maí damú tiyan míkan mifo sirantan kan orun kádan (12) eyo iyampon kayo finte mana Yudas Iskariotin ne sin mano monó ánon banta kayo ayampin Yisasin ameno van oren mino. ");
INSERT INTO agd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Oren mo síkan betí ankan mai iniren amusin uren béin ma moní miyaní inain iyá antádan Yudasi ma vetí ankan ayampin ma Yisasin amin nain áau vá aa va san araíen dosen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yisi Ída Van Bereti Ma Nan Omá Damú esé damú afoká en mino. Maí damú betí ankan Avo Uantan dunaní ma in sipisipi ararái aré iyan mino. Yisasini eyo iyampon kayo ano véin tiamemí, “Intefasá tetí ankan mo avové uré kuyá éi Avo Uantan dunan nante fono.” ");
INSERT INTO agd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Máa síkan eyo iyampon kanan tianta Yerusaremí oriyákan máa sen tiamemí, “Tiré kanan Yerusaremí barufin oresin ma mana vanta ano ma kákan non kave mamaren ma fókanti mai vanta ánain ná bákurono.” ");
INSERT INTO agd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bákure oresin béi ma mana namumpin un perantiya mai namun afóen máa seya vá tiameno, ‘Arú ano semantino senti karafaran intesin ná bain tesi eyo iyampon kayo vá Avo Uantan dunan nante rafuno.’ ");
INSERT INTO agd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tesin maen béi siré kanan mana yan bain kákan karafaran aní inten mino. Maifin dunan ma nan takhó bá kumanin kará bá pe funtáken mino. Mai karafarampin ná tiré kanan tétisi yunan puntá ádano.” ");
INSERT INTO agd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Máa síkan eyo iyampon kanan mai varufin oriven onákan mai ma Yisasi ma vékanan tiameiníen mino. Máan tíkan békanan Avo Uantan dunan ma mo nan nain puntáan kaen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Inupáké Yisasi má bei eyo iyampon tirantan kan orun kádan má (12) eren mino. ");
INSERT INTO agd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mairá betí ankan takhóká kumanten dunan niyákan Yisasi semí, “Téi fura siré tiretin tiamé uno. Tiretin aúbaná pinté mana vanta ano senti namuro kayo ayampin téin aminten mino. Ma ma séin má manafin dunan niyain mano ino.” ");
INSERT INTO agd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Máa síkan bei eyo iyampon kayoi ará uman dákan mana mana ano vetí ankan Yisasin araíen inaemí, “Téi funo áa iye fino.” ");
INSERT INTO agd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mairá Yisasi vetí ankan tiamemí, “Mai siretí tirantan kan orun kádan (12) kayo aúbaná pintena mana vanta ano ino. Mai vanta ano vereti fákaren dókifin ma séin má manamani kain araviyain mai ano ino. ");
INSERT INTO agd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mai fura ino vompon mano fefá béin nan tikharé einíen mi Banta Anin purinten mino. Purinten mifo namuro kayo ayampin ma Banta Anin ma amin nain mai vanta van mi kákantá tirun ken mino. Mai séin ma namuro ayampin kain nain banta namu ukhen mifo moéken kama ukhen mino véin ída kaen na ino.” ");
INSERT INTO agd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mairá betí ankan dunan niyákan Yisasi mana vereti máden Tiyarafenu susu siantáden kisiren betí ankan amen temí, “Máde nano. Ma séin tu ino.” ");
INSERT INTO agd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mairá béi uvaini kápi máden Tiyarafenu susu siantáden betí ankan amemí. Amíkan minó ano mai nen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Narákan béi vetí ankan tiamemí, “Ma senti nare ano siretin ákona uranti kokhon nanin banta ano Tiyarafenu vá ará manafiní ureya vano van téi vanaé uno. ");
INSERT INTO agd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Téi fura siré tiretin tiamé uno. Téi ída enádá bá uvaini aran anu nanté umpo maí damusí ma intí Tiyarafenui yafisimpin auyen uvaini anun nanté uno. ");
INSERT INTO agd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Máa sirákan betí ankan mana monó í daren Orifí Anufá oren mino. ");
INSERT INTO agd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mairá Yisasi vetí ankan tiamemí, “Monó bompon mano máa sikhen mino, ‘Téi sipisipirá dafisin banta aruréken minó sipisipi karan orera inten mino.’ Máa sikhein tiretíi mumunan minó asuse en namu inten mino. ");
INSERT INTO agd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Téi ma evaráné e mantaré ten naren tiretin an uanté Karirifá oronté uno.” ");
INSERT INTO agd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Máa síkan Pita véin tiamemí, “Minó kayoi mumunan asuse en namu inten mifo senti mumunan ída asuse en namu inten mino.” ");
INSERT INTO agd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Máa síkan Yisasi véin tiamemí, “Téi fura siré éin tiamé uno. Taréa inuran kokore ída kankanan dádá asikhan tiya éi séin nan kanú manaú dádá ída afová ukhé uno sin nono.” ");
INSERT INTO agd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Máa síkan Pita enádá ákonaen temí, “Ída ino. Téi éin má manafin puronté uno. Téi éin nan ída afová ukhé uno ída senté uno. Ída uron mino!” Máa síkan minó eyo iyampon kayo ano veyan máa sirú en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mairá betí ankan oren mana yunan anafin o unen mino. Mai vara aví Ketsemani ino. Mairá oriven Yisasi vei eyo iyampon kayo siamemí, “Téi simúkono van mumpo siretí ankan marasá kumante vá bano.” ");
INSERT INTO agd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Máa siren Pita, Yemisi, Yoni siren aviran oriyáken aváduan onákan ará uman dan au ira khen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Máan tiyaimpin béi vetí ankan tiamemí, “Téin tirá ano kákantá uman dein téi inka furonté uno. Tiretí ankan mará bákeya vá dafían ákona ono.” ");
INSERT INTO agd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Máa siren béi manáa e afánen oriven barará o vaven amúken mino. Béini anunu ano mai vei furin ma eriyain kanaisá ená béin akhakhanten nafino siren inen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iniren béi semí, “O tifóe oe. Éi kana minó danasí in nompo séin pintena ma kápi yovarano van mi iyá umpo mai éi ída vá tenti sinunu ánain dakhafono. Éi ei anunu vá dakhafono.” ");
INSERT INTO agd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Máa siren béi oren o onákan bei eyo iyampon kayo auun bakharé íkan béi Pitan tiamemí, “Saimoni éi auunábakhe fono. Éi ída ena mana áau vá dafisinte fono. ");
INSERT INTO agd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tiretí ankan dafíkeya amúkono. Tiretí ankan ma akhenókain daná erinten mino. Para vara seyo, aú ano anunu ukhan mifo yan bukhafa ano avesara iyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Máa siren béi evaránen mo enádá mai ma esé amúkein amúkirí anaen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Amúkuren béi ovaránen bei eyo iyampon kayo e onákan betí ankan au ano kákantá uman dákanaunká bakharen mino. Béin ma evaránen tiamin nain baya vetí ankan ída afová ukharen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yisasi ovaránen kanú manaú dádasí en eriven betí ankan tiamemí, “Tiretí ankan pará auun bakhe vákeyá avíkiyá ba fono. Mai kana ifo senti áauí inka en mino. Onano Banta Anin inka ume vanta kayo ayampin amen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tiretí ankan mantavesí oró tifano. Téin ma vetí ankan ayampin ma amin nain banta inka eren mifo onano.” ");
INSERT INTO agd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yisasi mai vaya fara siyákan tiyan míkan mifo sirantan kan orun kádan pintena (12) mana Yudasi eren mino. Kokhon banta kayo ano vaenati variyan dan bariyan uaren béin má eren mino. Monó ánon banta kayo vá man baya ma afová ukhein banta kayo vá ánon banta kayo vá ano vetí ankan tiantan eren mino. ");
INSERT INTO agd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mai Yisasin ma vetí ankan ayampin ma amin nain banta ano mana aní inain baya vetí ankan tiamikharen mino, “Téi ma mo amónanuna vanta mai Yisasi ifo vá pákareya vá ákona e yafíbeya avire orono.” ");
INSERT INTO agd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Máa sikharen Yudasi e unen eriaren ainen Yisasi vaintá oriven temí, “Aru soe!” siyáken béin amónen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Máan tiyain má betí ankan ayan dan orin Yisasin páken mino. ");
INSERT INTO agd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pákiyain má mai ma véin má ma mantakhá ein kéká pinté mana vanta ano vaenati orun danúaren mana monó ánon bantai yoran banta átaren ankáboren kaven mino. ");
INSERT INTO agd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kavíkan Yisasi vetí ankan tiamemí, “Tiretí ankan téin pákano vará baenati vá dan má mamareyá mana umoyan banta ma fákano van einí e fono.” ");
INSERT INTO agd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ena ena yamú ma séi siretí ankan má monó namun kumanté afova amiyákeya siretí ída séin páke ompo vompon pintena vaya ano vá pura sen afoká ino.” ");
INSERT INTO agd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Máan tiyain ma minó beni eyo iyampon kayo véin me ampiren karan oreraen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Karan orera iyain má mana fumara ano efanten davaráe minó aurá ukhuren Yisasin avákuren oriyá íkan betí ankan béin páken mino. ");
INSERT INTO agd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pákaádaran béi efanten davaráe me yavaman kaúden au urontá karan oren mino. ");
INSERT INTO agd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mairá betí ankan Yisasin aviren monó ánonbanta kékái ánon banta vaintá oríkan minó monó ánon banta kayo váánon banta kayo vá man baya ma afová ukhein banta kayo vá e átaru en mino. ");
INSERT INTO agd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ano Yisasin bákuren oriyan mifo véi nentá o útúbiyan onen oren mino. Béi mai monó ánon bantai ánon bantai yafufin ódiven piripo kayo vá báken ira kaniyan baren mino. ");
INSERT INTO agd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bákan minó monó ánon banta kayo vá minó Kanisori kayo vá ano manáa vanta kayo arákan eriven Yisasi ma variyá ein avúavá ana me sirú en mino. Betí ankan béini aau ma vantí mairá béin aruan purono siren dosíkan beni aau ída mana varen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kokhon banta ano kampun baya fóké béin aufin kuráden ten mifo mai vaya kayo ano ída manaíen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ída manaí eimpin manáa vanta ano e mantaaren kampun baya fóké Yisasin aufin kuráden temí, ");
INSERT INTO agd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tetí ankan inékun béi máa sen mino, ‘Banta ano ma ayampó uvantein monó namun téi varákurékanú manaú damú ananmai monó namun uvaranté umpo mai namun banta ano ayampóké ída uvaranten mino.’” ");
INSERT INTO agd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Máa sen mifo mai kayo ma sein baya vá ano mo asusein ída kanaíen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mairá monó ánonbantai ánon banta ano aúban mantaven Yisasin inaemí, “Éi ída mana vaya ovaráne sintó iya fono. Betí ankan ma éin aufin kurariyain baya mai intesá ukhen nafino.” ");
INSERT INTO agd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Máa síkan Yisasi ve avaya fákaren kofakhen ída mana vaya evaránen ten mino. Evaránen monó ánon banta kékái ánon banta ano véin inaemí, “Éi avábá in Tiyarafenu Anin Karaisi fono.” ");
INSERT INTO agd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Máa síkan Yisasi semí, “Mai séi umpo siretí ankan onesin maen Banta Anin mano minó ákona vain Tiyarafenui ayan kurompá kumamen béi inaru fáke konantá erinten mino.” ");
INSERT INTO agd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Máa síkan monó ánonbanta kékái ánon banta ano aran kiyaimpin bei au anamun bararó uren temí, “Tetí ankan ída vá manáa vanta kayo vá arékun beni vaya me sino van ó tifano. ");
INSERT INTO agd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tiretí ankan inka inen nan béi Tiyarafenu oyampá baya sen mifo siretí inté esá teya iniya rafono.” Máa síkan minó ano vaya manafin máa sen Yisasin nan temí, “Béimpin aau van mifo véi vá purino.” ");
INSERT INTO agd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mairá manáa vanta ano araíen béin aufen akhare siyákan betí ankan béin aunáká davaráe yamuan iyádenankamiyan temí, “Éi sakhanampa vanta omposaréa aví teno iye ano éin ankamiyan nafino.” Máan tiyákan piripo kayo ano véin avíden ankamen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Máan tiyákan bararasí ukheintá dafufin Pita varé in monóánon banta kékái ánon bantai yoran arinta ano eren mino. ");
INSERT INTO agd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Eriven mai arinta ano onan Pita ira kaniyaré íkan mai yoran arinta ano véin purefure en ódaren temí, “Éi mai Nasaretíke Yisasin má bare ono.” ");
INSERT INTO agd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Máa síkan Pita ída ino sen mino. “Téi véin ída afová ukherúna vayan éi siya ono.” Máa siren béi e manten barufá ona akhempá aravin mana kokore asen mino. ");
INSERT INTO agd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Máan turan mai yoran arinta ano véin ódaren mairá ádé ma mantakhá ein banta kayo siamemí, “Ma vanta ma vain mai véi mai kayoi kéká ino.” ");
INSERT INTO agd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Máa síkan béi evaránen temí, “Ída ino.” Máa siren bákan manáa ádé ma mantakhá ein banta kayo ano ínaimpáké evaránen Pitan nan temí, “Pura ino éi mai kayoi vanta Kariri fáké ono.” ");
INSERT INTO agd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Máa síkan mairá Pita ákona uron en máa semí, “Pura ódino séi maisiretin ma siyaona vanta ída uron mi afová ukhé uno.” ");
INSERT INTO agd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Máa siyain ma kokore ainen asian kani iyain má PitaYisasi ano ma véin tiamein baya ovaren inemí, “Kokore ída kankanan dádá asíkantiya éi kanú manaú dádá téin nan ída afová ukhé uno sin nono.” Mai vaya iniren Pita ifí den mino. ");
INSERT INTO agd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pe ákura suron monó ánon banta kéká bá ánon banta kayo vá man baya ma afová ukhein banta kayo vá minó kanisoro kayo vá manafin baya siaren Yisasin ayantá damuren aviren mo Pairotin amen mino. ");
INSERT INTO agd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Amíkan Pairoti ano véin inaemí, “Éi Yutan kayoi kin na fono.” Síkan Yisasi evaránen béin tiamemí, “Éi mai inka se ono.” ");
INSERT INTO agd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Máa síkan monó ánon banta kéká ano véin aufin kokhon baya fóké kuráden ten mino. ");
INSERT INTO agd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tiyákan Pairoti ano véin evaránen enádá inaen temí, “Éi ídá anona evaráne mana vaya sinte fono. Onano vetí ankan nái máa vaya fókesá éin aufin kurariyan nafino.” ");
INSERT INTO agd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Síkan Yisasi ídaevaránen anona vaya siyaimpin Pairoti ano anú duren kokhon ineine en mino. ");
INSERT INTO agd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ena ena orana Avo Uantan damú ma erin kamani ano mana vanta karavusi fintena útuanté iyan mino. Mai minó nanin banta ano ma útuantano ma sein mai vantan útuanté iyan mino. ");
INSERT INTO agd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Máan tiyain bákan mana Barabasin ne sin banta karavusifin baren mino. Béi manáa vanta kayo vá kaminin má aruvin duváden manáa vanta aruan púdan mai vanbetí ankan má karavusíi uran baren mino. ");
INSERT INTO agd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mairá banasi ano oriven Pairotin nan pefá ma iyaonaí ono siren oovaren mino. ");
INSERT INTO agd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Oovarákan Pairoti ano evaránen betíi vaya anona siamemí, “Tiretí ankani anunu ano Yutan kayoi kin na ifá ékun orino van iya rafono.” ");
INSERT INTO agd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mai véi afova ukhan monóánon banta kéká ano Yisasin inian namu unantáden kópin aviren mo kain baren mino. ");
INSERT INTO agd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bákan mai monóánon banta kéká ano vanasi arápin antaran betí ankan Pairoti vaípá oovaren temí, “Barabisin ifá uantan erino Yisasi ída ino,” sen mino. ");
INSERT INTO agd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Máa síkan Pairoti ano enádá evaránen mai nanin bantará inaemí, “Mai siretí ankan ma Yutan kayoi kin mino ma siyaona mai vanta séi náisá béin onte rafuno.” ");
INSERT INTO agd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Síkan betí ankan evaránen oovararen temí, “Béin daa unkamádantá arono.” ");
INSERT INTO agd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Síkan Pairoti ano evaránen enádá betin tiamemí, “Paravae nái auisá béi ukhavae.” Máa síkan minó nanin banta ano moéken avádóden oovararen temí, “Béin daa unkamádantá arono.” ");
INSERT INTO agd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Máa síkan Pairoti ano vanasi arápin amusin amen Barabasin ifá uantan betí baípá oríkan béi Yisasin aruvin banta kayo ayampin kaíkan anan dafiyópóké nare ankáden daa unkamádantá béin arino van amin aviren oren mino. ");
INSERT INTO agd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mairá aruvin banta kayo ano Yisasi aviren kamanini yafufin má naun ódiyáken minó aruvin banta kayo arakan oren mino. ");
INSERT INTO agd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Oriven betí ankan kini narare au anamun Yisasi untáden ayankun anan póké mana kini kamamo uváden béin ánontá afú uanten mino. ");
INSERT INTO agd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Máan tuantáden betí ankan e mantaven taró uanten máká maáká iyan temí, “Yutan kayoi ákona kin noe, en aví daní iyá tiféuno!” ");
INSERT INTO agd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Máa siren betí ankan mana ura yafiyópóké béin ánon ankáden aufen akhare siren aron durafúden matimen béin kampun amusin uanten mino. ");
INSERT INTO agd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Máan turen aruvin banta kayo ano véin ayanavan baya siren intiren mai kini narare au anamun do yaváden beni au anamun evaránen uantáden béin daa unkamádantá arono van aviren oren mino. ");
INSERT INTO agd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Oríkan Yisasi ída ákona íkan mana Sairini varu fáke vanta Saimoni Arekisanda nú Dufasin nú afóe ano kákan barufá Yerusaremi orono van aasá eríkan aruvin banta kayo ano ákonaen duvun íkan béi Yisasini yaa unkamádan ayaen baren oren mino. ");
INSERT INTO agd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mairá betí ankan Yisasin aviren mana Korikhota e sin anurá mo khaen mino. Mai Korikhota e ma siyain beni ana máan mi sikhen mino. “Ánon Dampa Anuen” tikhen mino. ");
INSERT INTO agd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mairá avían mo Yisasin kauren betí ankan uvaini vá aí ma kusiantan non má opé uren amíkanmaen béi ifá en mino. ");
INSERT INTO agd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ifá íkan betí ankan béin daa unkamádantá antópóké aruren beni auí daná daváden betiyan maman kaúden mai auí danáká kati siren ayá nampa ma fákein mano mana yaná mádú en mino. ");
INSERT INTO agd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Dan manápá ifo afápá kamí kamí un kádan áaurá Yisasin daa unkamádantá aren mino. ");
INSERT INTO agd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mai véin ánontá ben ma kó tiantein baya máa siren uvaremí, “Yutan Kayoi Kin Mino.” ");
INSERT INTO agd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Máan turen betí ankan umoyan banta kanan má daa unkamádantá aren mino. Mana véin ayan kurompá aren mana ayan ópá aren en mino. ");
INSERT INTO agd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Banasi ano onóbe enóbe iyáken béin ayanavan baya sen máa semí, “Odo! Éi monó namun barákureya kanú manaú damú ana uvaran banta ono. ");
INSERT INTO agd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Máan tin banta ompo éi eyan ayaeya yaa unkamádantáké erano.” ");
INSERT INTO agd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Máa siyákan monó ánon banta kéká bá man baya ma afová ukhein banta kayo vá ano yere oyampá baya sen betiyan máa semí, “Béi ena nanin banta ana ayaiyan mifo veyan ída kanaíen béi ayainten mino. ");
INSERT INTO agd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mai Karaisi Isareri kayoi kin mano véi kanaíen daa unkamádan me ampiren erantí tetí ankan ódé béintá mumunan otifanté uno.” Máa siyákan mai ma yaa unkamádantá béin má manará ma arukhein bantá kanan má ano yere ven nan oyampá baya sen mino. ");
INSERT INTO agd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Bayan áau siya yavanin dun maren titipá ukhan áau inúpá kanú manausí emí. ");
INSERT INTO agd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Áau sitipá ukhen kanú manausí íkan Yisasi avádóden oovaren máa semí, “Eri, Eri rama sabáktani” Mai máan mi sikhemí, “Tenti Tiyarafenu oe! Tenti Tiyarafenu oe! Éi fará téin me oyan time fono.” ");
INSERT INTO agd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Máa síkan manáa vanta kayo mairá ádé mantakharen betí ankan mai iniren temí, “Ineno! Béi feyan sakhanampa vanta Iraiyan mi ariyan mino.” ");
INSERT INTO agd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Siyáken mana vanta ano savaen mómofen ma einí ukhein daná máden uvaini vá íta non má ma úpí urampin daren ura yankará damuren Yisasi nano van amiren mai vanta ano semí, “Ave ukhesí oná tifano Iraiya ano véin e aví ádantin ná eranten nafino áa ída fino.” ");
INSERT INTO agd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Máa siyain má Yisasi avádóden bádiyan puren mino. ");
INSERT INTO agd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Puriyain má kákan monó namumpin makákan davaráe kuran ma varé ein mai veyantá danté kafasen barará morúdan maman kankananíen mino. ");
INSERT INTO agd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aruvin bantai ánon ayafa ano mairá Yisasini ádé mantakharen béini furin ódaren béi semí, “Pura uron ma vanta Tiyarafenu Anin mino.” ");
INSERT INTO agd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Máa siyákan manáa nanin kayo nentá mantakhen oniyan baren mino. Mai vetin pintena mana Makdaráke Mariaí inká ena mai Yemisin nú Yosepin nú anóe Maria má ena Saromii. ");
INSERT INTO agd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mai fefá ma Yisasin ma Karirifá ma vákan maen mai nanin kayo ano avákuren nóken béin aya iyaren mino. Mai véin má ma Yerusaremí orein nanin kayo yere mairábaren mino. ");
INSERT INTO agd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Inuran Sabati yamú bantéin mai útain damú inúpasíen mino. ");
INSERT INTO agd_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Inúpasí íkan Arimatiaké Yosepi ano eren mino. Béi mai mana kama aví bain kanisoro ifo véin má deren Tiyarafenui Yafisin ave ukharen mino. Mairá Yosepi orein ída feranto Pairotin avorá o mantaven Yisasin au varen mo masí ino van béintá inaen mino. ");
INSERT INTO agd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ina íkan Pairoti ano kokhon ineine uren temí, “Béi inká púken nafino.” Máa siren aruvin bantai ánon ayafa aran eríkan béintá inaemí, “Yisasi inká púken nafino áa ída fino.” ");
INSERT INTO agd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mairá béi máa siren aruvin bantai ánon ayafai vaya iniren Yosepin nan kana ifo véin au varano sen mino. ");
INSERT INTO agd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Máa síkan Yosepi efanten davaráe o miyaní uren béin un maman barará aséden mai efanten davaráefin ukhuren béin mo on aimpin kaúden ain oyirá kákan onámanáo vaé baé uan ataen mino. ");
INSERT INTO agd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kaiyákan Makdaráke Maria nú Yosesin anóe Maria nú intefasá béin kaiyan nafi siren o váken onen mino. ");
INSERT INTO agd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabati yamú kípavíkan Makdaráke Maria má Yemisin anóe Maria má Saromin má kama aunka iyain uveri kayo vetí ankan Yisasin aufá mo féantano van miyaníen mino. ");
INSERT INTO agd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Esé araí in damú pe ákura suron asaréa áau e unin betí ankan masíká oren mino. ");
INSERT INTO agd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Oriyáken betiyan ten orera emí, “Iye anó masí oyi rákena onámaná do setin eka sintanten nafino.” ");
INSERT INTO agd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Máa siren onákan mai onámaná ída masí oyirá baren mino. Mai kákan onámaná ifo mana vanta ano fefá do avékakharen mino. ");
INSERT INTO agd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mai masí aimpin betí ankan ódiven onákan mana fumara ano ayan kurompáayá efanten au anamunuren kumantaré íkan betí ankan ódaren akhokho van en mino. ");
INSERT INTO agd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Akhokho van íkan béi vetí ankan tiamemí, “Tiretí ankan ída vá akhokho van ono. Nasaretíke Yisasin onano van ere ompo véin ma yaa unkamádantá ma antópó arukhá ein mai inka véi fe e mantakhen mifo onano véin ma kain báeimpin ída van mino. ");
INSERT INTO agd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tiretí ankan ore vá beni eyo iyampon kayo vá Pita má mo siameno, ‘Béi ma fefá tiretin tiamikhá einíen tiretin an uanten Karirifá orikhen mifo mai fákena vá tiretí ankan béin o onano.’” ");
INSERT INTO agd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Máa síkan mai nanin kayo masí ain pinté e khuven eravuaren anú duman duman en karan oriyáken péden ída mana vanta vá baya sen mino. ");
INSERT INTO agd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Esé araí in damú pe ákura suron Yisasi e mantáaren Makdaráke Marian avorá naren o afoká en mino. Yisasi mai nanin au fintena yan manápá ifo afápá kan un kádan namu aunan kayo yo siantein mino. ");
INSERT INTO agd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria orein minó Yisasi má ma nóein banta kayo mo siamemí. Mai minó banta kayo ano ará umandan ifí diyan baren mino. ");
INSERT INTO agd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Baré íkan Maria vetí ankan tiamemí, “Yisasi ída furin para vá téi oné uno.” Síkan betí ankan mai vaya iniren ída mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ínaimpáké bei eyo iyampon kanan mano mana aayana oriyaréin Yisasi enará uven békanan baintá o afoká en mino. ");
INSERT INTO agd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","O afoká íkan ódaren békanan manáa eyo iyampon kayo mo siamíkan betí ankan ída vékanani vaya vá mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ínaimpáké tiyan míkan mifo sirantan mana orun kádan (11) eyo iyampon máa ano kumanten duna niyaréin Yisasi vetí ankan baintá afoká uven betí ankampin mamumunan ída vákan ma véi ma e mantein ma onein nanin banta ano ma siamin ma vetí ankan ará uman daren ída mumunan iyain nan béi vetin asen mino. ");
INSERT INTO agd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Máa siren béi vetí ankan tiamemí, “Tiretí ankan ore vá barará minó akhempasá kama vaya mo vanasi siameno. ");
INSERT INTO agd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Banta ano ma mumunan uven ma non baran nain mai Tiyarafenu ano evaránen avirantin ben ninaí inten mino. Máan tinten mifo vanta ano ma ída mumunan inain mai ano kópin afeyoranten mino. ");
INSERT INTO agd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tiyarafenu ano mumunan ma inain banta kayo ayantá máan avúavá daná afoká inten mino. Téin tivíká betí ankan namu aunan do siantiyáken auyen baya sinten mino. ");
INSERT INTO agd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Betí ankan ayampó osafáe fákarantin ída untaranten mino. Betí ankan beyantá uvá naren ída furinten mino. Betí ankan banta aurá ma ayan kaintin mai aí bantan ano e asefa inten mino.” ");
INSERT INTO agd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bafan Yisasi ano vetí ankan baya siamirákan Tiyarafenu ano aviran inarufá óden Tiyarafenui ayan kurompá un kumanten mino. ");
INSERT INTO agd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Minó eyo iyampon kayo ano minó akhempá oreraen beni kama vaya mo siamen mino. Bafan mano vetí ankan má manafin doriyáken betíi vayafin ákona amíkan manáa avúavasí ma íkan mai afoká iyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kákan banta Tiofirasi oe. Pefá kokhon banta kayo ano Yisasi ma setin aúbaná afoká uádakaré ein daná baya van uvaman one one iyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mai yaná avúavá ma afokáin ma ontaré ein banta kayo mai Tiyarafenui yoran banta kayon bákan esé anará ma afokáin ma onein daná bayan uvaman tetin timen mino. ");
INSERT INTO agd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Máan tukhein nan mi séi yere ayá damú ina uré mai vaya ana kamaé afová uréi ma funtákein bompon uvaman amé uno. ");
INSERT INTO agd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Pefá ma siamikharé ein baya mai fura vaya ino seya yankáde afová ono van mi ma vompon uvaman amé uno. ");
INSERT INTO agd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Eroti ma Yudia kayoi kini ukhá ein damú Abiya ma monó ánon bantaí ukhan maen mana monó doran banta Sekaraiyan ne sin banta vákan ben aná Erisabeti Eronini kéká pintenan baren mino. ");
INSERT INTO agd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Békanan Tiyarafenu avorá puntáken minó man baya ánain dakhafiyáken Bafan oo yaiyen puntáden Tiyarafenu avorá baren mino. ");
INSERT INTO agd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Békanan ayokhuvini ukharen mifo Erisabeti a naniní ukhan míkanan ída iyampon kaúkaren mino. ");
INSERT INTO agd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Maná damú Sekaraiyani monó ánon banta kéká ano monó namumpin mo yorarí iyákan Sekaraiya má maifin Tiyarafenu avorá doriyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Maí damú monó doran banta kayo ano yanka iya iya uren asíka vá ayá danka kayo vá ma yanufin nain banta anon mun monó namumpin Tiyarafenu íkun uan aminten mino sirákan Sekaraiya ano ayá danka yanú dan béin tiantan monó namumpin óden mino. ");
INSERT INTO agd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Íkun uantan áauí iyákan kokhon nanin banta ano monó barurá átaru ukhen amúkiyan mino. ");
INSERT INTO agd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Amúkiyákan Sekaraiya vaintá mana Bafani enisori ano mai ma kama aunka íkun uantan takhó ádé afoká uven ayan kurompá mantakhan mino. ");
INSERT INTO agd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mantakharéin Sekaraiya mai enisori ma onen anú diyan akhokho van en mino. ");
INSERT INTO agd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Akhokho van íkan mai enisori ano Sekaraiyan máa sen tiamemí, “Ída vá akhokho van ono. Tiyarafenu ano eni amúkin inka inen mino. En aná Erisabeti afon iyampon kainten mifo ven avisá Yoni ne se vá aví dano.” ");
INSERT INTO agd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mai iyampon ma afoká inain damú éin ará ano kama intiya amusin esin maen kokhon nanin banta ano yere moéken amusin intin maen ");
INSERT INTO agd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","béi Bafan auufen kákan bí baranten mino. Be anóen amúpin ma vantin Kantá Áunan mano ven aúpin bíkanten mifo véi ída vá uvaini vá óen non má nano. ");
INSERT INTO agd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Béi anon kokhon Isareri nanin banta ará maman baéden evaránen betí ankani Bafan Tiyarafenu vaípá aviren orinten mino. ");
INSERT INTO agd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Béi Iraiyani ákona vá avúavá bá mamaren Bafan an uanten oriven maen mo ve akhafana vá be afóeyan má ará maman manafiní uantanten mino. Máan tuantáden maen man baya ma átakharéin kékái ineine maman puntáden kama ineine ma vain kayo an daantanten mino. Béi vanasi maman arakhoku urantin Bafani erin nan ave inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Síkan Sekaraiya evaránen máa sen enisori siamemí, “Téi intesá uré mainá afoká inten mino siré éini vaya afová onte rafuno. Te síbasu afova nanin bantan bá uno.” ");
INSERT INTO agd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Máa síkan mairá enisori ano máa sen tiamemí, “Téi Kebrieri uno. Téi Tiyarafenu auufen manté iyarunan bákan mi Tiyarafenu anon tisintá ma kama vaya éin tiameno van eré uno. ");
INSERT INTO agd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ineno. Tenti vaya ma éi ída mumunan eonafá éin oo uman dantiya éi ída vaya sin basin mi mai yaná afoká inten mino. Beni yamusí ma intin mi senti vaya ano yákó inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Minó nanin banta ano Sekaraiya monó namumpin ayáká bákan ave ukhen bavakon kokhon ineine en mino. ");
INSERT INTO agd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ínaimpáké monó namun pinté Sekaraiya ekhuven barufá eraven béi ída vaya semí. Máan tíkan betí ankan afová en ten mino. “Mai monó namumpin ben avorá ena yaná afoká ukhan ayampó ana avavé navé iyáken oo uman dan ída vaya siyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ínaimpáké Sekaraiyani yoran kípan be amá barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Orikharé íkan ínaimpáké be aná Erisabeti amú basí en mino. Amú basí uven dan manápá biyontá umeraren baren Erisabeti sian páman en mino, ");
INSERT INTO agd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Bafan mano séin avábá usinten mino. Mai avábá ano vanasi avorá ten tiyave yo arútinten mino.” ");
INSERT INTO agd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Erisabetin dan manápá ifo afápá mana un kádan biyon esantavin Tiyarafenu ano enisori Kebrierin tiantan Kariri varafá Nasaretí barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Oren mana Kin Devitini anan pintena vanta Yosepin ne sin banta amikharé ein arinta Marian ne sin ída mana vanta vá bakharé ein arinta vaípá enisori ano oren mino. ");
INSERT INTO agd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mairá Kebrieri véi vaintá onó ben máa semí, “Anasi oe, bayan mino. Bafan mano éin má ban mino. Tiyarafenu ano éin moékentá avu uren éin kama uanten mino.” ");
INSERT INTO agd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Síkan Maria mai vaya iniren anú duren mai nái vayá ten nafino siren kokhon ineine en mino. ");
INSERT INTO agd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Máan tíkan mairá enisori ano máa sen Marian tiamemí, “Maria oe, ída vá éi akhokho van ono. Tiyarafenui anunu ano éi má ban mino. ");
INSERT INTO agd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ineno. Éi amúbasí ukhareya mana afon iyampon kain nono. Kaúde vá mai iyampon avisá Yisasi ne vá teno. ");
INSERT INTO agd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Béi ayafa vanta vantin béi nan Moéken Dan Bain Tiyarafenu Anin mino siyantin Bafan Tiyarafenu ano véin maman be anafu Devitin an den kiní uantanten mino. ");
INSERT INTO agd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kiní uantádantin béi Isareri kékái kin bantin maen beni yafisin doran mano fara van oriyan ban ída kípanten mino.” ");
INSERT INTO agd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Máa síkan Maria evaránen enisori inaemí, “Intesá uren ná mai ná afoká intéi vae séi ída vanta manté uno.” ");
INSERT INTO agd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Máa síkan enisori ano evaránen béin tiamemí, “Kantá Aunan mano éimpin erivintin Moéken Dan Bain Tiyarafenui ákona ano éi má banten mino. Máan tukhantin mai iyampon ma ínaimpá kainona ano kantasí ukhein bantan bantin ben nan Tiyarafenu Anin ne sinten mino. ");
INSERT INTO agd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Afová ukha ono ei kéká pintena nanin Erisabetin nan ma a nanin báken iyampon ída kainten mino siyan mifo mai saréa véi afovaí uvein pimpá amú basí ukharéin dan manápá ifo afápá mana un kádan biyon orikhein afon iyampon mi kainten mino. ");
INSERT INTO agd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Para vara seyo, minó danápin Tiyarafenu ano kanaí inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Máa síkan Maria evaránen temí, “Téi fura sé Bafani yoran nanin muno. Éi ma sisimeona mai veni anunu ifo vá maina sá dákó ino,” síkan enisori ano Marian me ampiren oren mino. ");
INSERT INTO agd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Manáa yamú orivin Maria e manten Yudiá barafá anu yompin bain barufin oriven ");
INSERT INTO agd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sekaraiyan amápin ódiven Erisabetin nan mo vayan ne sen mino. ");
INSERT INTO agd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Erisabetin nan ma vayan mino ma sein baya ma Erisabeti iniyain má ana ven amúpin ma vain iyampon mano káusen ódiven eraven iyain má Kantá Aunan mano véin aúpin bíken mino. ");
INSERT INTO agd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Máan tíkan béi avádóden oovaren temí, “Tiyarafenu ano éin kama uanten mi ena nanin kayo ano ma variyain mai avu moéken esantakhein avun éin amen mino. Máan tukhein mi en amúpin ma vain mai iyampon má ano yere Tiyarafenui avu varen mino. ");
INSERT INTO agd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Téi iyé bákun ná tenti Bafan anóe ano se varunafá eriyan nafino. ");
INSERT INTO agd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Para vara seyo, éi ma sen nan bayan mino sená ma iniyaruna vá anan ten timúpin ma vain iyampon mano amusin iyáken káusen ódiven eraven en mino. ");
INSERT INTO agd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mai ná Bafan mano afoká inten mino siyáke mumunan e ompo mai vará éi amusin nono.” ");
INSERT INTO agd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Máa síkan Maria máa sen ídemí, “Ten tirá ano Bafan aví daní iyan ");
INSERT INTO agd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ten taunan mano moéken Ten Tiyain Tiyarafenu van amusin iyákái ");
INSERT INTO agd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","séi veni yoran nanin mi váké paen danái vaken mifo véi sen nan iniren mi séin kamaen tarisari ein mi saréa fi ínaimpáke safi vanasi ano sen nan Tiyarafenu ano kákan amusin amikhein nanin mino sinten mino. ");
INSERT INTO agd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tiyarafenu Minó Ákona Vain mano kákan danasintan ten turá afoká uren ten tiyaen mifo béin avisá kantasí ino. ");
INSERT INTO agd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Beni aránaópá ma orein nanin banta ma avábá uanté iyain mano sare ma vain nanin banta vá ínaimpáké ma afoká inain nanin bantafin má dere máan mana en oriyan bantin ");
INSERT INTO agd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","béin ayan mano kákan dorarí ukhantin beyan nan ma kákan muno siren be aví ma yaní iyá inain mai nanin banta yo siantantin orera iyantin ");
INSERT INTO agd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ákona kin kéká maman bara finí uren aví ma ída vain banta kayo maman daníen mino. ");
INSERT INTO agd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nanante vanante ma iyá ein kayo véi kokhon kama yaná póké kanaí uanten kama yaná ma kokhon kain baré ein kéká do siantan para oríkan ");
INSERT INTO agd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Abaraamun má be ana akhá bá ma avábá onté uno síkhá ein baya van béi ovaren me iniyáken bei Isareri nanin banta ayaen mino.” ");
INSERT INTO agd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Máa sen ídaren béi Erisabetin má kanú manaú biyontá baren me afaen bei varufá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Erisabetini iyampon kain damú afoká íkan béi afon iyampon kaen mino. ");
INSERT INTO agd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kaúdákan mana varu ráke nanin banta vá bei kékábá ano Tiyarafenu ma Erisabetin avábá uantein nan iniyáken béin má minó ano amusin en mino. ");
INSERT INTO agd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Amusin urákan dan manápá ifo afápá kanú manaú un kádan damú orivíkan mai iyampon au khaviyan be afóen avavaníden Sekaraiya ne seno van aviran eríkan ");
INSERT INTO agd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","be anóe ano, “Ída ino. Ben aví Yoni ne vá teno,” semí. ");
INSERT INTO agd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Máa síkan minó ano véin tiamemí, “Ída Yonin bí tetimpin bain mino.” ");
INSERT INTO agd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Máa siren betí ankan ayampó ana avavé nave iyáken be afóentá mai iyampon avi san inaen mino. ");
INSERT INTO agd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Inaíkan béi vetí ankan nan mana vompon ma uvaran dóki vare ereno síkan baren meran mairá bompon máa sen uvaremí, “Ma iyampon aví Yoni ino,” sirákan betí ankan anú duren kokhon ineine en mino. ");
INSERT INTO agd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Máan tiyain má Sekaraiya oo saferen baya siyan Tiyarafenu aví daníen mino. ");
INSERT INTO agd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Máan tiyain má beni varu ráke kayo ano mai yaná ma afoká ein ódaren akhokho van uren e siádan Yudiá barafin anufá ma vain barufimpá oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bafani ákona ano véin má bákan minó nanin banta ano mai vaya iníden anúden orera iyan temí, “Mai iyampon ínaimpá interená inten nafino.” ");
INSERT INTO agd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mai iyampon afóe Sekaraiyan aúpin Kantá Aunan mano vikavíkan sakhanampa vaya máa sen mino: ");
INSERT INTO agd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Bafan avisá daní ó tifano. Béi Isareri nanin bantai Ayarafenu ino. Béi ma varará eraven barará nanin banta kama uren ume fintena evaránen avíken mino. ");
INSERT INTO agd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tetin evaránen tivirano van bei yoran banta Devitini kéká pintena béi mana ákona vanta maman dákó uáden mino. ");
INSERT INTO agd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pefá ma vei kantasí ukhein sakhanampa vanta kayo oorá ma sikhá einíi en mino. ");
INSERT INTO agd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Béi ma siyáken namuro ayan pintena vá tetin ma ará namu usintiyain kéká ayan pintena vá ma evaráné tivirano van ma sikhá ein mi yákó en mino. ");
INSERT INTO agd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tetin tináuyan arunan uren aya ukharen mino. Pefá ma manafin kasukhen ban kantasí ukhein baya ma veyantá tikharé ein mai van béi ovaren me inen mino. ");
INSERT INTO agd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tetin tinafu Abaraamun avorá ma ayan befiyó uren ódino fura sé uno ma véi sikharé ein danái saréa setimpin afoká en mino. ");
INSERT INTO agd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ma mai ma véi iyáantan baré ein mino. Béi ano namuro ayan pintena setin tivían ádun kaintí báké ída feran beni yorarí ó tifanté uno. ");
INSERT INTO agd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ena ena yamú béin avorá teti kantasí é puntáké ana vá bá tifano. ");
INSERT INTO agd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mai van mi se sanin noe, ínaimpá éi nan Moéken Dan Bain Tiyarafenui sakhanampa vanta ino siyantiya éi ano Bafani an uante oreya aa uvisin nono. ");
INSERT INTO agd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Bei vanasi evaránen aviran nain afova amiresin betí ankani ume arúantanten mino. ");
INSERT INTO agd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Para vara seyo, Tiyarafenu ano vei sarisarifói máan tinten mino. Mai maen Yisasi ano kakhan an den Tiyarafenu vaípáké teti vaípá eranten mino. ");
INSERT INTO agd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Minó nanin banta ma anukheimpin báken ma umefin purein an dakhein mai on mano kakhaantantin ará kusin aintá oró tifanté uno.” ");
INSERT INTO agd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ínaimpá mai iyampon e anoní íkan Kantá Aunan mano véin aúpin bikhavíkan kámá barafá o van damú afoká íkan e unen Isareri nanin bantafin dákó eren mino. ");
INSERT INTO agd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sisa Okastasi ano ma Romu kamanini ánon bantaí ma ukhein pimpá Romu kamanin mano ma yafíkein barafin ma vain nanin banta minó avisá bompompin uvarano siren ákona vaya siádan oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mai yaná afoká ein mai Kuiriniasi ma Sirian barafin kamaniní ukharé ein damúi esé araíen afoká en mino. ");
INSERT INTO agd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Máa siyaimpin kamani ano aví barano van minó nanin banta ano evaránen betíi varu anará oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Orera iyákan Devitini kéká pintena vantan Yosepi maen Kariri varafá Nasaretí barurá baren e manten Devitini varu anará Yudiá barafá Betariamú oriyáken ");
INSERT INTO agd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ben ma varano van tiantan ma váein arinta Maria amúbá baré íkan kamani ano aví barano van avíaren oren mino. ");
INSERT INTO agd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Békanan o varéin Maria inamun nan iniyaimpin ");
INSERT INTO agd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","miyaní ma uren baran namun bíkakhen ída afokhan baimpin me khoen kao amápin óden mun esékena afon iyampon kauren davaráe yo úkuren kaoi yunan nan dókifin kaen mino. ");
INSERT INTO agd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mai inuran maen mai varu akhempá manáa sipisipirá dafisin banta kéká ano sipisipirá dafíkaré íkan ");
INSERT INTO agd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bafani enisori ano veti vaintá eriyain má Bafani kakhan mano vetin eúkuádan akhokho van en mino. ");
INSERT INTO agd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Akhokho van iyain má enisori ano vetí ankan máa sen tiamemí, “Tiretí ankan ída vá akhokho van ono. Téi kama vaya varé tiretin tiameno van mi eré umpo mai kama vaya ma minó nanin banta ano ma ininten moéken amusin inten mino. ");
INSERT INTO agd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tare inuran manan Devitini varufin mana nanin mano afon iyampon kaein mai iyampon manon tiretin ayainten mino. Béi Bafan mi vákan Tiyarafenu ano ven nan mi minó nanin banta evaránen avirante ne sikharen mino. ");
INSERT INTO agd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Máan tukhantiya ma yanákái véin o ódeya afováin nono. O onesin maen davaráe yo úkuren kaoi yunan nan dókifin asédantin banten mino.” ");
INSERT INTO agd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Máan ma siyain má manádá ainen inaru fáké iyankaforen enisori kéká bá ano mai enisori vaintá afoká uven Tiyarafenu aví daníen máa semí, ");
INSERT INTO agd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dan uró bain Tiyarafenu avisá daní ono. Be ma aní ukhein nanin banta ano vá ará kusin masá barará bano.” ");
INSERT INTO agd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Máan turen mai enisori kéká ano ma inarufá evaránen ódivíkan maen sipisipirá ma yafisin banta kéká ano vetiyan ten oreraemí, “Eritifé ma ma Bafan mano ma setin tisimein baya ánain dakhafé mai yaná ma Betariamú barufin ma afoká ukhein o onátifano,” siren ");
INSERT INTO agd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","betí ankan ainen oriven Yosepin nú Maria nú mo yosiádaren onákan mai iyampon kaoi yunan nan dókifin asédan bakharen mino. ");
INSERT INTO agd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bakharé íkan betí ankan mai iyampon oniyáken enisori ano ma vetin tiamikhá ein baya sian páman íkan ");
INSERT INTO agd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","mai vaya ma inein kéká ano kokhon ineine iyan maen ");
INSERT INTO agd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria mai vaya kayo inian be aúpin kaúden iniyan baren mino. ");
INSERT INTO agd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Máan turen sipisipirá dafisin banta kéká ano evaránen oriyáken mai ma enisori ano siamin iniren ma onein dana san Tiyarafenu aví daní iyáken amusin uanten mino. ");
INSERT INTO agd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dan manápá ifo afápa kanú manaú un kádan damú orivíkan mai iyampon au khaiyáken pefá ma ve anóen arápin ída afoká ukhan ma enisori ano ve anóen tiamikhá einíen Yisasin bí amen mino. ");
INSERT INTO agd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mosesini man baya ano ma sikhá ein damú afoká íkan Yosepin nú Maria nú ano Bafan avorá avusesein doran dóan kípiyan mai iyampon Bafan mo ameno van békanan Yerusaremí barufá aviren oren mino. ");
INSERT INTO agd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mai ma orein mai man baya ano máa sikhan mino, “Mana nanin mano ma esékena ain iyampon ma kaúden maen ná mai iyampon Bafan aníen ná eni kéká pinte ino siren ná mai iyampon mo amino.” ");
INSERT INTO agd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Amiyan kankanan kukhofá nun nafi kukhun nafi varen mo íkun uan ameno van Yerusaremí monó namumpin oren mino. ");
INSERT INTO agd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Maí damú mana Simionin ne sin banta Yerusaremí báken mumunampin béi funtákan Kantá Aunan mano ven aúpin bíkakhan Isareri nanin banta ma ará kusiantáden ma evaránen aviran nain banta onano van ave ukharen mino. ");
INSERT INTO agd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kantá Aunan mano véin pefá tiamemí, “Éi ída furin para vasin mi Bafani vanasi ma evaránen aviran nain banta yákó intiya onan nono.” ");
INSERT INTO agd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bafani man baya ano ma sikheiníen Yosepin nú Maria nú ano Yisasin aviren monó namumpin ódiyákan Kantá Aunan mano Simionin aviren maifin múdan ");
INSERT INTO agd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","mai iyampon un daumaren Tiyarafenu aví daní iyáken máa semí, ");
INSERT INTO agd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bafan noe, fefá éi ma siáden nan baré einí eya ei yoran banta saréa áesin ná ará kusin masá orino. ");
INSERT INTO agd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Banasi ma ayaino van ma aní ukhá eona mai inka se suu fóké oné uno. ");
INSERT INTO agd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mai minó nanin banta ano onano van utaan kaúkare ono. ");
INSERT INTO agd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mai véi mana on mi vain ena anan nanin banta kakhaan táden maen Eni Isareri kéká kákan bí aminten mino.” ");
INSERT INTO agd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Máa síkan mai iyampon nan ma Simioni sein baya van be anóe afóe ano anú diyan kokhon ineine iyákan ");
INSERT INTO agd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioni vetin avu uantáden mai iyampon anóe Marian máa sen tiamemí, “Tiyarafenu ano ma iyampon nan mi siyan béi anon kokhon Isareri nanin bantai eraven ankamin má ena kokhon Isareri nanin bantai e mantan mái mana aní banta vantin banasi ano véin oyampá baya sinten mino. ");
INSERT INTO agd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Máa siyantin béi ano vanasii aúpá ineine maman dákó intin éin dere vaenati ano arápin kéká inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Asani anan pinte Fanuerin araun mana sakhanampa nanin Ana varen afovaí ukharen mino. Béi ve avafun má dan manápá ifo afápá kan un kádan oranará baré íkan ");
INSERT INTO agd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","be avafu fúbin eiti fo (84) oranará baré báken ena ena inuran má bayan má ída monó namun baru me ampiyan maen manáa yamú dunan auraren Tiyarafenurá amúkiyáken beni yoran pákaren baren mino. ");
INSERT INTO agd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Maí damú ana véi má dere vetíi ádé eriven Tiyarafenu susu siantiyan Yerusaremí nanin banta ma Tiyarafenu ano evaráné aviranté uno sikhan ma afoká intí onano van ma iyá ein nanin banta kayofin mai iyamponi vaya sian dákóen mino. ");
INSERT INTO agd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bafani man baya ano ma sikharé einíen Yosepin nú Maria nú ano mai yoran dóan kíparen bei varufá Karirí barafin Nasaretí oren mino. ");
INSERT INTO agd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","O vákan mai iyampon ákona vá e anoní iyákan Tiyarafenui avábá ano ve má bákan kama ineine ano véimpin bíken mino. ");
INSERT INTO agd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Minó oranafin ma Avo Uantan Dunan Nan Damú ma erin maen be anóe afóe Yerusaremí oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tiyan míkan mifo sirantan kan orun kádan (12) oranaí Yisasi ukharen betin anóe afóen má anafu aráoni avúavá ánain dakhafen Avo Uantan Dunan Nan Damú oren mino. ");
INSERT INTO agd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Orikhá íkan Avo Uantan Dunan ma Nan Damú kípavíkan Yisasi ma Yerusaremí bain ída afová en onanton be anóe afóe evaránen barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Oriyáken be anóe afóe ma inein mano Yisasin nan be arona kayo vái oriyan mino ana siren ída ve nan dosin mana vayan orivíkan ínaimpá be nan mo yose me yose iyan mana varuráké ma orikharé einta safi arona kayora safi me inae inae en mino. ");
INSERT INTO agd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Békanan dosivaen ída onarí iyaimpin evaránen Yerusaremí mo yoseno van oren mino. ");
INSERT INTO agd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Békanan dosiyan kanú manaú damú orivíkan béi monó namuni yafufin arú kayo aúbaná kumanten betí ankan ma sein baya iniyáken manáa vaya evaránen betimpin inauren iniyan baré íkan o onen mino. ");
INSERT INTO agd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Beni vaya ma inein banta kéká ano veni afova vá inain baya vá ma evaránen tiyain ma san anúden oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Békanan ma Yisasin o onen kákantá anú diyáken be anóe máa sen béin tiamemí, “Tanin noe, éi fará ma avúavá afóe rasan usintenará berasan tirá ano uman diyasá éin nan dosiyare rafuno.” ");
INSERT INTO agd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Máa síkan béi evaránen békanan tiamemí, “Pará te nan dosé no vae séi se sifóen amái vanté umpo ídá tiré kanan afová ukhe fono.” ");
INSERT INTO agd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Máa síkan mai ma véi siyain baya ana ída vékanan afová en mino. ");
INSERT INTO agd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Máan turen ben avíaren betí evaránen Nasaretí oren o váken be anóe afóe ma sein baya máa iniren oo yaiyiyákan inká Yisasi ma sein baya máa ve anóe ano maman aúká kaúden pákaan ákonaen mino. ");
INSERT INTO agd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Máan tiyáken Yisasi e anoní íkan beni afova ano mo kákaní íkan Tiyarafenu vá minó barará nanin banta vá ano moéken béin nan anunuen mino. ");
INSERT INTO agd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa Taiberiasi ano ma Romú barafá ma kiní ukhan tiyan míkan mifo sirantan dan manápá orun kádan (15) oranaí ma iyákan inká Pontiasi Pairoti ano Yudiá barafá kamaniní ukhein damú anan Eroti Antipasi ano Karirí barafá kamaniní ukhan ben afá Firipi ano Ituriá bá Tarakonitisí bara vái yafisiní in mi inká Risaniasi ano Abiriní barafá dafíkan ");
INSERT INTO agd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ma ukhein damú anan Aanasin nú Kaiafasin nú ano monó ánon banta kékái ánon bantá kaní ukhan maen Sekaraiyan anin Yoni ano vanta ída van kámá barafá bákan Tiyarafenui vaya ano véimpin eren mino. ");
INSERT INTO agd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Erivíkan béi Yodení non akhempá ma vain baru kayo fimpá oriven banasi siamemí, “Ará baédesin Tiyarafenu ano siretí ankani ume ampiantá dantiya vá non barano.” ");
INSERT INTO agd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sakhanampa vanta Aisaiya ano máa sen bompon uvantaremí, “Kámá bara fáké mana vanta ano oovaren máa sinten mino, ‘Bafani aa uvídeya funtarano. ");
INSERT INTO agd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Masisí ma ukheimpin bara kaesin édavintiya anuyon kayo úan avaí eya aa ma koren ukhein maman puntareya namu ma ukheimpin kama uresin ná ");
INSERT INTO agd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tiyarafenu ano ma evaránen minó nanin banta ma aviran dorarí ma inain mai minó anon onanten mino.’” ");
INSERT INTO agd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Máa siyákan kokhon nanin banta ano Yoni vaintá monó non péantano van eríkan betí ankan máa sen tiamemí, “Eeeee, tiretí ankan namu osafáe akhafana ompo iye anó tiretin afova amikhayá Tiyarafenui aran naná ma siretin amaniná ereno van iyain nan karan orono van iya rafono. ");
INSERT INTO agd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tiretí ankan ma fura seya ará baédante vá beni aran ná iran nompo siretí ída vá ‘teti Abaraamun akhafana uno’ seno. Téi siretí ankan tiamé uno. Tiyarafenu ano kanaíen ma onámaná kayo sintin Abaraamun akhafanaí inten mifo ");
INSERT INTO agd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ída ma kamaen aran iran nain daa ana sikaren ira sarano van Tiyarafenu ano fefá tasume anafin kain ban mino.” ");
INSERT INTO agd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Máa síkan banasi ano Yonini vaya iniren máa sen béin inaemí, “Mai setí náisá onte rafuno.” ");
INSERT INTO agd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Máa síkan Yoni evaránen betí ankan tiamemí, “Kankanan au anamun ma yákanona ano ída ma yákan nain ná mana au anamun amesin ná dunan ma yákanona vá dere ano máan mana vá ono.” ");
INSERT INTO agd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takisi varan banta kéká ano yere non barano van erikharen betí máa sen inaemí, “Aru soe, setí intesá ótifante rafuno.” ");
INSERT INTO agd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Máa síkan Yoni evaránen betin tiamemí, “Tiretí ankan ma takisi variyákeya vá kamani ano ma sin nain mai máa ana vá bareya ída vá mairá manáa mo asotú ono.” ");
INSERT INTO agd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Máa síkan manáa aruvin banta kéká bá ano yere Yonin inaemí, “Tetí ankan náisá ótifante rafuno.” Síkan Yoni vetin tiamemí, “Tiretí ankan ída vá banasi namu uante vetíi moní máká tire umoyan bareya ída vá betí ankan kampun kó tiantáde moní bare vá kamani ano ma miyan amin nain mai máa moní ana vá amusin iya varano. ");
INSERT INTO agd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Máa síkan banasi ano Yonin oniyáken betí ankan kokhon ineine uren be nan mai ma Tiyarafenu ano ma varará nanin banta evaránen aviranten mino ma sikharé ein mai vanta ino sen inen mino. ");
INSERT INTO agd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Máan ineine iyákan Yoni evaránen betí ankan máa sen tiamemí, “Téi non máa fói siretin péantiyá umpo sen toyampá ma eriyaini ákona ano senti ákona moéken esantakhá téi ída funtákeruna ída kanaí é matimé beni arantan anumun anan útufonté umpo véi Kantá Aunan má irafó bái siretin monó non péantanten mino. ");
INSERT INTO agd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kákan poki ma ayampin pákakhein banta an daven béi ereno van iyain ma eriven maen bei uviti namun pintena aitan má asuí ma ukhein ma yo ínáan karúdaren uviti o éke e éke uren bei uviti namumpin kauren aítan má asuí ma ukhein má ída yusimin irafin taman kaurinten mino.” ");
INSERT INTO agd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yoni ano kokhon baya kayofó banasi ará mantano van Tiyarafenui kama vaya siamiyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Eroti ma kamaniní ukhen maen be aváen aná Erodiasin ma yafein má ena kokhon aauí ma ukhá ein masan Yoni ano vanasifin páman uren asirákan iniren ");
INSERT INTO agd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Eroti moéken ena vá namu avúavasíen Yonin pákaan karavusifin kaen mino. ");
INSERT INTO agd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kokhon nanin banta ma non bariyákan Yisasin má dere non mamaren amúkiyain má inaru ona yivíkan ");
INSERT INTO agd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kantá Aunan mano kukhofá nun an daven ámaren Yisasin ánontá e yomaniyain má inaru fáké máa sen oovaren temí, “Éi sen tanin uron mono. Téi éin nan moéké tinunu ukhé éi nan timusin iyá uno.” ");
INSERT INTO agd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yisasi ma teti (30) oranaí ma uven bei monó doran araí íkan banasi ano ma inein mano véi nan Yosepin anin mino sen iniyákan Yosepi mai véi Erin anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eri maen Matatin anin bákan Matati maen Rivain anin bákan Rivai maen Merikin anin bákan Meriki maen Yanain anin bákan Yanai maen Yosepin anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosepi maen Matatiasin anin bákan Matatiasi maen Amosin anin bákan Amosi maen Naumin anin bákan Naumi maen Esirin anin bákan Esiri maen Nakhain anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakhai maen Matin anin bákan Mati maen Matatiasin anin bákan Matatiasi maen Semenin anin bákan Semeni maen Yosekin anin bákan Yoseki maen Yodan anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda maen Yoananin anin bákan Yoanani maen Resan anin bákan Resa maen Serubaberin anin bákan Serubaberi maen Siaritierin anin bákan Siaritieri maen Nerin anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri maen Merikin anin bákan Meriki maen Adin anin bákan Adi maen Kosamun anin bákan Kosamu maen Erimadamun anin bákan Erimadamu maen Erin anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri maen Yosuan anin bákan Yosua maen Eriesan anin bákan Eriesa maen Yorimin anin bákan Yorimi maen Matatin anin bákan Matati maen Rivain anin bákan maen ");
INSERT INTO agd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Rivai maen Simionin anin bákan Simioni maen Yudan anin bákan Yuda maen Yosepin anin bákan Yosepi maen Yonamin anin bákan Yonami maen Eriakimin anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriakimi maen Mereanin anin bákan Mereani maen Menan anin bákan Mena maen Matatan anin bákan Matata maen Netanin anin bákan Netani maen Devitin anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deviti maen Yesin anin bákan Yesi maen Obetin anin bákan Obeti maen Boasin anin bákan Boasi maen Saromonin anin bákan Saromoni maen Nasonin anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoni maen Aminadapin anin bákan Aminadapi maen Ramun anin bákan Ramu maen Arinin anin bákan Arini maen Esaronin anin bákan Esaroni maen Peresin anin bákan Peresi maen Yudan anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda maen Yekopun anin bákan Yekopu maen Aisakin anin bákan Aisaki maen Abaraamun anin bákan Abaraamu maen Teran anin bákan Tera maen Nahon anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nao maen Serukun anin bákan Seruku maen Reun anin bákan Reu maen Perekin anin bákan Pereki maen Eberin anin bákan Eberi maen Seranin anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Serani maen Kainanin anin bákan Kainani maen Apaksatin anin bákan Apaksati maen Siemin anin bákan Siemi maen Noan anin bákan Noa maen Ramekin anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Rameki maen Metuseran anin bákan Metusera maen Inokin anin bákan Inoki maen Yaretin anin bákan Yareti maen Maararerin anin bákan Maarareri maen Kenanin anin mino. ");
INSERT INTO agd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenani maen Enosin anin bákan Enosi maen Setin anin bákan Seti maen Adamun anin bákan Adamu maen Tiyarafenu anin mino. ");
INSERT INTO agd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yisasi Yodení non me ampiren oríkan Kantá Aunan mano véin aúpin bíkaaren aviren kámá barafá oríkan ");
INSERT INTO agd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yisasi foti (40) yamú dunan ída nanton arafan bákan Ban Anon mano véin akhenóka uan onen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ban Anon mano máa sen béin tiamemí, “Éi fura se Tiyarafenu Anin ma vanteya ma onámaná tesin ná beretií ino.” ");
INSERT INTO agd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Máa síkan Yisasi véin evaránen tiamemí, “Tiyarafenui vompon dóki ano máa sikhen mino, ‘Banasi ano veretirá ana ída fara ayun ban ákona varé iyan mino.’” ");
INSERT INTO agd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Máa síkan Ban Anon mano Yisasin do aviren dan bain anurá mun kaúden minó ákona vara kayo ma ma varará bain aníen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aní iyáken Ban Anon mano véin máa sen tiamemí, “Ma vara kayo éin amiré éin ákona amé kuyá dafisiyáke kákan bí baran nono. Minó danasinta sen tinan bain téi ma sinunu onunan amenté uno. ");
INSERT INTO agd_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Amenté umpo aron durafúde matimeya ma sentá monó tiresí maé mai yanasinta minó éin amenté uno.” ");
INSERT INTO agd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Máa síkan Yisasi evaránen béin tiamemí, “Tiyarafenui vompon dóki ano máa sikhen mino, ‘Ei Bafan Tiyarafenurá ana vá monó tiante vá beya aránaópá ana vá bano.’” ");
INSERT INTO agd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Máa síkan Ban Anon mano Yisasin do aviren Yerusaremí monó namun amontá mun kaúden béin máa sen tiamemí, “Éi fura se Tiyarafenu Anin ma vanteya ma má amon táké káuseya aravono. ");
INSERT INTO agd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mai fara vara seyo, Tiyarafenui vompon dóki ano máa sikhen mino, “‘Béi vei enisori kéká tiantantin éintá dafían ákona inten mino.’ ");
INSERT INTO agd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ákonaen entá dafíben ayan dóki uvídantiya mai yaró aravesin onámaná ano ída arantampin un peranten mino.’” ");
INSERT INTO agd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Máa síkan Yisasi evaránen béin tiamemí, “Tiyarafenui vompon dóki ano máa sikhen mino, ‘Éi ída vá ei Bafan Tiyarafenu akhenóka ono.’” ");
INSERT INTO agd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ban Anon mano ma Yisasin akhenóka uan kíparen me ifá en orein ená damusan o ave en mino. ");
INSERT INTO agd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kantá Aunani ákonará Yisasi evaránen Karirí barafá oríkan mai varafin ma vain nanin banta ano véi ma o vain baya iniren afová en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Béi monó átaru namu kayofin ódiven monó baya siamiyákan banasi ano iniren ben aví daníen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Béi ma araraká baren e anoní ukhaein mai Nasaretí barufá orikharen bei avúavá baren Sabati yamú monó átaru namumpin ódiven monó bompon dankafono van orun mantavíkan ");
INSERT INTO agd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","sakhanampa vanta Aisaiyani vompon dóki varen mo amíkan béi kaváden máa ma sikhein baya yankafen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Minó daná ma ída vain kéká Bafan mano vei kama vaya siamino van téin aní uran Beni Kantá Aunan mano sen má ban mino. Karavusifin ma vain nanin banta siamékun karavusi útufiyantin auu ma yufúkukhein auu kama iyantin ena kéká ano ma vetí ankan maman bararasí uren ma uman amiyain má kípantin ino van mi téin tisintá eré uno. ");
INSERT INTO agd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bafan mano ma vei vanasi kama inain damú inka afoká en mino sen tian dákó ino van mi véi sen tisintá eré uno.” ");
INSERT INTO agd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Máa siren Yisasi vompon dóki evaránen dádaren mai vompon dókirá ma yafisin banta amiren kumamíkan minó nanin banta ano yovariyáden béin mana urú onen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Oniyákan béi máa sen betí ankan tiamemí, “Tiyarafenui vompon dóki ano ma sikhá ein bayan tiretin átaren mano inka inin mai yaná taréa afóken mino.” ");
INSERT INTO agd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Máa síkan betí ankan Yisasin aví daní iyáken mai ma kama vaya kayo ma ven oo fenté eriyain nan kokhon ineine en orera iyáken betí máa semí, “Ma vanta Yosepin anin mi vá tetí afová ukhé umpo intesá uren ná ma kama vaya kayo siyan nafino.” ");
INSERT INTO agd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Máa síkan Yisasi máa sen tiamemí, “Minó nanin banta ano ma siyain baya ma mádeya mae sireti se nan, ‘Ayofan banta oe, éi eyantá e au kama ono’ seya sisimiyákeya ‘éi ma Kapeniamú ma vareona avúavá ma setí inikheruna mai ei varu anará barano van muno.’” ");
INSERT INTO agd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Máa siren béi evaránen betí tiamemí, “Téi fura uron mi siré tirétin tiamé umpo mana sakhanampa vantai varu rákena nanin banta ano ída ven avaya iné iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Téi fura siré tiretí ankan tiamé uno fefá Iraiyani yamú be avafun ná púbíkan kokhon baré nanin kéká bákan inarurá á pákaran kanú manaú orana ifo yan manápá ifo afápá mana un kádan biyontá ída á dákan kákan anan afoká íkan minó barufá arafanan en orera iyákan ");
INSERT INTO agd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tiyarafenu ano Iraiyan ída Isarerí baré kéká baípá tiantan oren mifo véin Serefatí barufá Saidonii varafin mana ve avafu fefá púkein baré nanin baípái siantan oren mino. ");
INSERT INTO agd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Máan tukharéin inká ena sakhanampa vanta Iraisa ma varé ein damú ana amon dana aí bain kéká Isarerifin kokhon bíkakhá ein pintena mana vanta au ída evaránen kamaen mifo Siriá banta Namanin beyaká anan aya íkan amon dana aí kípen mino.” ");
INSERT INTO agd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Máa síkan monó átaru namumpin ma varé ein nanin banta kayo ano mai vaya iniren moéken aran nan en mino. ");
INSERT INTO agd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aran nan uaren mai varu anu yontá baré íkan Yisasin do siantan mai varu finté ekhuven aravíkan béin ayafin avékaan karúdano van do yarifen oren mino. ");
INSERT INTO agd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Darifen oriyain má Yisasi mai nanin banta aúbaná oriaren mai aya oyi ráke me ampiren oren mino. ");
INSERT INTO agd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Karirí barafá Kapeniamú barurá béi orun baren Sabati yamú monó baya araíen banasi siamen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tiamiyákan béi ma siyain monó baya ano ákona vá eriyákan minó nanin banta ano iníkan aví bain banta ano ma siyainí iyaimpin minó ano anúden oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Maí damú mana namu aunan mano fákakhein banta ano mai monó átaru namumpin un baren avádóden bádiyan máa semí, ");
INSERT INTO agd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Nasaretíke Yisasi oe, éi ída vá tétin namu ono! Tetí éin afová ukhé uno. Éi Tiyarafenui mana kanta suron mono.” ");
INSERT INTO agd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Máa síkan Yisasi mai namu aunan máa sen asemí, “E avaya fakareya mai vanta aú pinté entavono,” síkan namu aunan mano mai nanin banta avorá mai vanta maman barará aséden béin me ampiren oriven ída uman amen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Máan tíkan minó nanin banta ano anú duren betiyan ten oreraemí, “Aii! Ma nái vayá tiyan nafino. Ákona uron ukhein bayafó béi síkan namu aunan kayo ano ven oo yaiyen oriyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Máan turákan mai ma Yisasi varein avúavá baya ano ainen minó mai varafin oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yisasi mai monó átaru namun me ampiren Saimonin amápin oríkan Saimonin aná anóen aufá irakharo uaren aí uádan bakharéin béin ayaino van betí ankan Yisasin inaen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ina íkan Yisasi ádé o mantaven aí ano mai nanin me ampiren orino van ákonaen baya síkan aí orivin mai nanin mano manádá orun mantaven betíi yunan taren mino. ");
INSERT INTO agd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Áau ma yo úbefen eravíkan banasi ano ara ara aí ma vain kéká Yisasi vaintá aviren ere ere íkan béi mana mana aurá ayan kaúantádan betí ankan evaránen kamaen mino. ");
INSERT INTO agd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Máan turen Yisasi namu aunan kayo yo siantan kokhon nanin banta ma me ampiren oriyáken máa sen oovaren mí, “Éi Tiyarafenu Anin mono.” Máa síkan béi vetin asiren baya ída sino van airo ananí uanten mifo mai fara va ino varará nanin banta ma evaránen avirano van ma Tiyarafenu ano aní ukharé ein mai vantan béi vákan betí afová ukhan mino. ");
INSERT INTO agd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pe ákura suron Yisasi mai varu me ampiren mana vanta ída van akhempá oren mino. Orivíkan banasi ano ven nan dosen oren o ódaren betin ída véi me ampiren orino siren ayópá ono van en mino. ");
INSERT INTO agd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ayopá ono van íkan béi máa sen betin tiamemí, “Téi ena varufimpá basá orivé Tiyarafenui yafisin pintena kama vaya minó nanin bantafin tiamino van mi véi sen tisintá erikhé uno.” ");
INSERT INTO agd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Máa siren Yudiá barafá ma minó barurá bain monó átaru namun kayo fimpá oriven monó baya vanasi siamen mino. ");
INSERT INTO agd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Maná damú Yisasi Kenesaretí non akhempá mantakharé íkan kokhon nanin banta ano véi vaintá ere ere uven Tiyarafenui vaya siamintin ineno van béin maman aúban kaúden iyen eúken mino. ");
INSERT INTO agd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iyen eúkukhan Yisasi mo onákan kankanan noyana arin boti non akhempá bákan mai voti kanampin ma noyana ariyain banta kéká ano vase sesé iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Máan tiyákan Yisasi mana Saimonini votifin ódiven béin tiamin mai voti avékan manáa nompin orivin mai votifin kumanten monó baya vanasi siamen mino. ");
INSERT INTO agd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Monó baya sian kíparen ínaimpáké béi Saimonin máa sen tiamemí, “Ma voti vareya mesan non aúbaná oriveya vase karúdesin nompin aravintiya noyana fákano.” ");
INSERT INTO agd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Máa síkan Saimoni evaránen temí, “Bafan noe, inuran tákéi o vase karúdé erékun me kakhá ída mana vá noyana fáké umpo en oo yaiyé base karúdanté uno.” ");
INSERT INTO agd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Máa siren base karúdarákan noyana ano mai vase víkaaren dákaríen mino. ");
INSERT INTO agd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Base víkaaren dákarí iyaimpin ena votifin ma varé ein kéká arákan erin mai votifin má noyana yaiman kaúdan mikánan boti víkaaren nompin orun peraríen mino. ");
INSERT INTO agd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita ma mai yaná oniyáken maen Yisasin arantampin mo aron kanan durafúden mátimen temí, “Bafan noe, séi ume vanta umpo sen ampireya orono.” ");
INSERT INTO agd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Máa siren béin má be arona vanta kayo vá ano mai noyana kayo oniyáken moékentá anúden orera íkan ");
INSERT INTO agd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebetin anin kan Saimoni arona Yemisin nú Yonin nú bá anú diyákan Yisasi máa sen Saimonin tiamemí, “Ída vá akhokho van ono. Tare ráké araí eya éi vanasi avían timin nono.” ");
INSERT INTO agd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Máa siran betí ankan mai voti vá mai yanasinta vá baren non akhempá me khaúden Yisasin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mana varurá amon dana aí bain banta varen Yisasin onen barará amupáké baven berai semí, “Bafan noe, éi ma anunu iyanteya séin tu kama usintano.” ");
INSERT INTO agd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Máa síkan Yisasi ayan dan orin béin au aruviyan máa sen tiamemí, “Téi sinunu iyá umpo éi kama ono,” síkan mai vantai amon dana aí ma varé ein manádá kípen mino. ");
INSERT INTO agd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mai vanta ma Yisasi ayofaren maen ákonaen tiamemí, “Ma avúavá ma en aurá afoká ein mai ída vá mana vanta siameno. Mosesi ma sikhá einí eya vá monó doran banta avorá e au mo aní iyákeya vá e aí ma kípein nan Tiyarafenu íkun uan amesin ná minó nanin banta ano eni aí kípen mino sen afová ino. ");
INSERT INTO agd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Máa síkan mifo Yisasi ma yoriyain avúavá baya van e siádan minó barufá ainen orera íkan kokhon nanin banta ano veni vaya iniyantin betí ankani aí kípaantano van ere ere en mino. ");
INSERT INTO agd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Máan tiyákan kokhon damú Yisasi vanasi me ampiren banta ídavan afokhampá amúkono van beyaká oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Maná damú Yisasi monó baya siamiyákan Karirí bara fáke safi Yudiá bara fáke safi inká Yerusaremí baru fáke safi Farasisi kayo vá man baya ma afova ukhein banta kéká bá kumantákan Bafani ákona ano Yisasimpin bíkavíkan aí nanin banta ayofen mino. ");
INSERT INTO agd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yisasi ayofiyan mápin bákan mana ayan arantan púkein banta kúkútafin kaúden manáa vanta kayo ano veni ádé ka ono siren daiyó en eren mino. ");
INSERT INTO agd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mai kúkúta yaiyó en eríkan banasi víkaaren ída afokhaní ukhan me khoen mai kúkúta yaiyen má daró ódiven má amon káponaren mai kúkútará anan damuren kain Yisasi vaintá araven mino. ");
INSERT INTO agd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Máan tíkan Yisasi vetí ankani mumunan ódaren máa semí, “Tirona oe, eni ume inka ampianté uno.” ");
INSERT INTO agd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Máa síkan man baya afová ukhein kéká bá Farasisi kayo vá ano vetiyan ten oreraemí, “Ma vanta ano Tiyarafenui varun bariyan mifo véi iye fino. Ída mana vanta ano kanaíen ume ampiantanten mifo Tiyarafenu veyafin mi mai ákona van mino.” ");
INSERT INTO agd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Máa siyákan Yisasi vetí ankani ineine fe afová iyáken máa sen tiamemí, “Nái vará tiretí mai ineine iyara fono. ");
INSERT INTO agd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Arantan ayan ma fúkein banta van ma mantaveya ei kúkúta mamare orono’ ma senuna fi áa ‘eni ume ampianté uno’ ma senuna mai anó teso sikhen nafino. ");
INSERT INTO agd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Banta Anin mano ma varará ume ifá uantan ákona manten mino sireya siretí ankan afová ono van mi séi inikhé uno.” Máa siren Yisasi máa sen ayan arantan púkein banta siamemí, “Éi e mantaveya ei kúkúta mamare e amápá orono.” ");
INSERT INTO agd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Máan ma siyain má ana mai nanin banta avorá mai ma ayan arantan púkaré ein banta ano orun mantaven bei yuvasí mamaren Tiyarafenu aví daní iyáken be amápá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Minó nanin banta ano Tiyarafenui ákona ódaren anúden orera iyáken temí, “Taréa ena yanái oné tiféuno,” siren ben aví daníen mino. ");
INSERT INTO agd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Máan turen Yisasi oriyaren o onákan takisi varan namumpin takisi varan banta Rivain ne sin mano kumantaré íkan béin ódaren máa sen tiamemí, “Ere sen bákurono.” ");
INSERT INTO agd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Máa síkan Rivai minó daná mairá me ampiren béin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Orono van iyáken Rivai ano Yisasin nina kákan dunan tamá daran takisi varan kéká bá ena nanin banta kayo vá ano maifin e átaru uven békanan má dunan nen mino. ");
INSERT INTO agd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Niyákan man baya ma afová ukhein banta kéká bá Farasisi kayo vá ano kóiyáken beni eyo iyampon kayo inaemí, “Tiretí ankan pará takisi varan banta kéká bá ume nanin banta kayo vá manafin dunan niyara fono.” ");
INSERT INTO agd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Máa síkan Yisasi evaránen betin tiamemí, “Aí ma vain nanin banta ano anan ayofan banta vaípá oré iyan mifo aí ma ída vain nanin banta ano ída oré iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Máan tukhái funtákein nanin banta aran novara séi ererauno ume nanin banta arékun ará baerano van mi séi erikhé uno.” ");
INSERT INTO agd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Máa síkan betí ankan máa sen Yisasin tiamemí, “Kokhon damú Yonini eyo iyampon kayo vá Farasisi kayoi eyo iyampon kéká bá ano yere yunan auraren amúké iyan mifo eni eyo iyampon kayo ano fará ída yunan auranton ná niyan nafino.” ");
INSERT INTO agd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Máa síkan Yisasi evaránen betin tiamemí, “Kanaisá ená anasi ma iman amin nain banta ma vei kéká bá para vantin maen beni kéká ano yunan auranten nafino. Ída ino. ");
INSERT INTO agd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Anasi ma iman amin nain banta ma aviren orivintin maen maí damúi veni kéká ano yunan auranten mino.” ");
INSERT INTO agd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Máa siren béi ena vaya máa sen tian baé amemí, “Peyante au anamun ma yákavintin mana vanta ano ída auyen davaráe vararó ureya mairá mo yampare amuin nono. Máa ma esin maen ída kanaíen o yampaan ákona uven míkanan ída manaí inten mifo mai au anamun kákantá anan e yáken orera inten mino. ");
INSERT INTO agd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Máan tukhantin mi mana vanta ano ída feyante memé au unampin auyen uvaini anu vanainten mino. Auyen uvaini anu ma feyante memé au unampin ma vanaresin maen mai uvaini anu ano feyante memé au unan dákaaren banaen eravintin mai unan má dere namu inten mino. ");
INSERT INTO agd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Máan tin nain nan mi auyen uvaini anu auyen memé au unampin mi vanai nono. ");
INSERT INTO agd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Máan tukhein nan mi feyante uvaini anu ma naren maen ída auyen uvaini anu né iyan mifo mai fara vara seyo feyante uvaini anu ano moéken kama ukhen ne sé iyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mana Sabati yamú Yisasi uviti yunampin nókan bei eyo iyampon kayo ano uviti araní uren ayantá kasekhasu faren aitan do fútian karúdaren niyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Niyákan manáa Farasisi kayo ano ódaren betí ankan máa sen tiamemí, “Sabati yamú ma vanta ano ma mai avúavá baran are ukhein mifo fará tiretí ankan bariya fono.” ");
INSERT INTO agd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Máa síkan Yisasi evaránen betí ankan tiamemí, “Devitin má bei kéká bá ma arafan nan uaren ma mantaré ein daná tiretí ankan ídá dankádeyá afová ukhera fono. ");
INSERT INTO agd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tiyarafenu amá ma Deviti un pében ma monó doran banta kéká ano ana vá nano ma siren Tiyarafenu avorá kain baré ein bereti ma véi un máden bei kéká bá ma nein mai vaya sireti ída afová ukhe fono.” ");
INSERT INTO agd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Máa siren Yisasi evaránen betí ankan tiamemí, “Banta Anin béi Sabatii Bafan mino.” ");
INSERT INTO agd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ena Sabati yamú Yisasi monó átaru namumpin un pében baya sian banasi amiyákan maifin mana vanta ayan kurompákena fúkein banta vá baren mino. ");
INSERT INTO agd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yisasi monó baya siamiyákan man baya ma afová ukhein banta kéká bá Farasisi kayo vá ano maifin báken Sabati yamú aí nanin banta ayofantí ódé béin avían kópin ka ono siren aa van dosiyáken béintá dafíkaren mino. ");
INSERT INTO agd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Dosiyákan Yisasi vetí ankani ineinefin afová iyáken mai ma ayan púkein banta van máa sen tiamemí, “Éi vanasi avorá orun mantano,” síkan mai vanta ano orun manten mino. ");
INSERT INTO agd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mantavíkan Yisasi vetí ankan tiamemí, “Tiretíi inaé umpo kasaerá Sabati yamú banasi kama uantante rafu áa namú uantante rafuno. Banasi aruan puronte rafu áa ayaékun ná para vanten nafino.” ");
INSERT INTO agd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Máa siren Yisasi minó nanin banta onen eúkiyáken mai vanta máa sen tiamemí, “E ayan antúkano,” síkan mai vanta ano máan tíkan evaránen béin ayan kamaen mino. ");
INSERT INTO agd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Máan tíkan man baya ma afová ukhein banta kayo vá Farasisi kéká bá ano kákantá Yisasi nan aranan iyáken betiyan ten orera emí ma vanta setí ankan náisá ótifante rafuno. ");
INSERT INTO agd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Maí damú Yisasi amúkono van mana anurá ódiven mai inuran Tiyarafenurá béi amúken oriyan bákan mo kakhen mino. ");
INSERT INTO agd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kakhan áau édavíkan bei eyo iyampon kayo aran erin tiyan míkan mifo sirantan kan orun kádan (12) banta aní uren betí ankan aposeri ví amen mino. ");
INSERT INTO agd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mana Saimoni varé íkan be nan Pitane sen mino. Máa siren Saimonin afá Enduru ne sen Yemisi ne sen Yoni ne sen Firipi ne sen Batoromiu ne sen ");
INSERT INTO agd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu ne sen Tomasi ne sen Yemisi Arifiusin anin ne sen mana Serotí anan banta Saimoni ne sen ");
INSERT INTO agd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yemisin anin Yudasi ne sen inká ínaimpáké ma véin ma namuroí iyain banta kayo ayampin ma avían amin nain banta Yudas Iskarioti ne sen en mino. ");
INSERT INTO agd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Máan turen Yisasin má bei eyo iyampon kayo vá amempá aravuaren kama ukhein avará ena kokhon bei eyo iyampon kayo vá Yudiá ankina fáke nanin banta vá Yerusaremí bá un non akhempá ma vain barú kan Taiyá bá Saidoni vá ano varéin orun manten mino. ");
INSERT INTO agd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Béini vaya iniyantin betí ankani aí ayofaantano van mi erikharéin mi namu aunan mano ma váken ariyá ein nanin banta Yisasi ayofen mino. ");
INSERT INTO agd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Máan tiyákan minó nanin banta ano onan béin pinté enará ukhein ákona eriyáken aí nanin banta ayofiyaimpin minó ano ayan dan oríkan ben au aruvono van en mino. ");
INSERT INTO agd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Máan tiyákan Yisasi vei eyo iyampon kayo oniyáken máa semí, “Tiretí minó daná ma ída vain kayo ano amusin na ono. Tiyarafenui yafisin tiretin nina ino. ");
INSERT INTO agd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Taréa ma arafan nan iyaona kayo ano vá amusin ná ono. Ínaimpáké naresin amú kurinten mino. Taréa ma ifídiya vaona kayo ano vá amusin ono. Ínaimpáké intin ono. ");
INSERT INTO agd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Banasi ano siretin onantiya ma Banta Anin ma yakhafiyasin maen betí ankan pura sen tiretin ará namu uantiyáken namu vaya siyan éin avi san namu ukhen mino siren do ékanten mino. Máan tintin ma mai yanasinta ma afoká intiya vá tiretí ankan ná amusin ono. ");
INSERT INTO agd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Betí ankan ma máan avúavá ma siretin uantantiya vá tiretí amusin iya vá ará kama uron ono. Para vara seyo, inarufá kákan miyan tiretin ave ukhen mino. Pefá betí ankan anafu aráo ano máan avúavá anan sakhanampa kéká uantákaren mino. ");
INSERT INTO agd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Máan tukharen mifo siretí moní nanin banta kéká ano vá dafiseno. Tiretí ará ma kamain daná máa fefái manta ono. ");
INSERT INTO agd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Taréa ma yunan naren nan ma amúkunta vaona kéká ano vá dafiseno. Ínaimpá arafan nan inono. Taréa ma intiya vaona kéká ano vá dafiseno. Ínaimpá auufenté ánu eravinten mino. ");
INSERT INTO agd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Minó nanin banta ano ma siretí ankan aví ma yaní iyantiya vá tiretí dafiseno. Pefá betí anafu aráo ano kampun sakhanampa kéká manaí ukhein avúavá anan bariyaren mino.” ");
INSERT INTO agd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Máa siren Yisasi semí, “Téinti vaya ma iniyaona nanin banta kayo ano vá tiretíi namuro vará ananu iyákeya siretí ankan ma ará namu uantiyain banta kayo vá kama ono. ");
INSERT INTO agd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kama iyákeya vá manáa kéká ano ma siretin nan ma Tiyarafenu ano vá namu uantano ma sintiya vá tiretí ankan Tiyarafenun amúkuan amesin ná betin avu ino. Tiretí ankan Tiyarafenurá amúkesin ná tiretin ma namu uantan nain kékasá avábá ino. ");
INSERT INTO agd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Máan tiyantin ma manáa kéká ano ma maná páke ápa ankamintiya mae vá tefáke yere vá do véan bétí baípasí ono. Manáa kéká ano ma yante afuin ma yafintiya áesin ná námente afuin má dere o varano. ");
INSERT INTO agd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Manáa yana san ma vanasi ano éi vaípá ma inantintiya éi kasae vá ameno. Mana ano ma éin nina yaná ma mantaré intiya éi ída vá evaránen amino van ákona eya inanteno. ");
INSERT INTO agd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Máan tiyákeya vá ena nanin banta ano siretin intéa avúavasá uantano vará ukhanten nafi mai avúavá ana vá betin má uantano. ");
INSERT INTO agd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Tiretí ankan ma anunu iyain kéká ana ma anunu inteya iye anó tireti nan inen ná kama nanin banta ino sinten nafino. Umeí ma iyain kéká ano yeren betin nan ma anunu iyain kéká anunu é iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tiretí ankan ma kama avúavá uantiyain kayo ana ma kama avúavá uantan teya iye anó tiretin nan inen ná kama nanin banta ino sinten nafino. Umeí ma iyain kéká bá ano yere manaí ukhein avúavá anan baré iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Betí ankan manoi kanaíen anona ovaráne siminten mino ma sireya amiyaona mai iye anó tiretin nan inen ná kama nanin banta ino sinten nafino. Ume vanta kayo vá ano yeren umeí ma iyain kéká kasaen timinten mino sen afová iyáken amé iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Máan té iyan mifo siretíi namuro vá anunu iyákeya vetin ná kama avúavá uanteyavá tiretin ma ída kanaíen anona evaránen ameren ukhein kayo vá ameno. Béin ma ída susu siantiyain kéká bá namu kéká bá deren béi kama é iyan mifo siretí máan tiyare vá kákantá moékakhein miyan ínaimpá mamareya vá Dan Bain Tiyarafenu akhasí puraseya ono. ");
INSERT INTO agd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tiretí ankan Afóe ano ma vetin nan ma arunan uantiyainí eya vá tiretin má dere vá betin nan arunan uantano. ");
INSERT INTO agd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Tiyarafenu ano yere máa mana en tiretíi avúavá bá daiminafo siretí ankan ída vá enai avúavá daídeya vá namu vanta kayo ino siyákeya vetíi ume vá áuantesin ná Tiyarafenu ano siretíi ume áuantano. ");
INSERT INTO agd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tiretí ankan ma ena nanin banta amesin maen Tiyarafenu ano siretin má aminten mino. Béi ma avarí inain mai víkaren morun avékaren kaiyantin bíkaaren avanen eraviyantin mi siretin aminten mifo sireti ma avarí iyá inona mai avúaváká anan temi siretin aminten mino.” ");
INSERT INTO agd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yisasi máa siren betí ankan mana vaya sian baéan amemí, “Kanaisá ená auu yufúkukhein banta ano ena auu yufúkukhein aviren orinten nafino. Ída ifo míkanan mano masípin mana o ádinten mino. ");
INSERT INTO agd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Afova ma variyain kayo ano ída vei arú esantakhé iyan mifo véi ma kamaen afova ma mamaren mi vei arú bá mun manaí é iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Máan té iyan mifo éi fará e afá aváen auufen ma sító kanti vain nan mana oniyákeyá e auufen ma kákan daa khaeádan ma vain nan ída iniya fono. ");
INSERT INTO agd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Máan tukhen mifo éi fara e afá aváen auufentena sító kanti yo varano van iyákeyá e auufen ma yaa khaéádan mano ma iyákein ídá oniya fono. Éi kampun baya sire ída mai ánain dakhafin nanin banta ono. Esé e auufen ma yaa khaéádan ma vain nare yo kanire vá kama e oniyáke vá e afá aváen auufentena sító kanti khasae vá do varano.” ");
INSERT INTO agd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Máa siren Yisasi evaránen temí, “Kama yaa ano ída namu aran irákan inká namu yaa ano ída kama aran iran é iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Banasi ano yaa aran naren ódaren kama ukhen nafi namú ukhen nafi siren oman afová é iyan mino. Banasi ano ída ayankun anan kayo rákena fiki aran kúden inká ayankuníen namu ukhein daa kayo rákena ída uvaini aran kúden é iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kama vanta aúpin kokhon kama ineine víkakhan béi kama avúavá baré iyan mifo namu vanta ano ven aúpin namu ineine víkakhan béi namu avúavá baré iyan mino. Máan ineine ma aúpin ma víkakhein mi oo ano sian dákó é iyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Máa siren Yisasi evaránen temí, “Tiretí ankan pará Bafan noe, Bafan noe, se nan tiyákeyá te ma siamiyaruna vaya ánanin ídá bákuriya rafono. ");
INSERT INTO agd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Máan tiya ompo mana ano ma se varunafá eriven ma senti vaya iniren mai ánain ma vákurin nain nanin bantai avúavái siretin tiamenté uno. ");
INSERT INTO agd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mai máan mi ukhen mino. Mana vanta ano ma má uvarano van ma mana kákan onámaná daró masí ufen námen araven morun kaúden ma simenti upí uren maifin kain araven ontá orun ákona uvin ma má uvá dakaréin ma anon non taaren mai má avékan maen mai vanta ano ákona namun uvantaréin ída varáké iyainíi ukhen mino. ");
INSERT INTO agd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Máan tukhen mifo senti vaya ma iniren ma ída mai ánain bákuriyain nanin banta mai véi mana vanta ano ma ída simentifó ákona inton para varará ana ma uvareiníi ukharéin ma ínaimpáké non taven ma mai má avékan ma ainen barákuaren namu ma einíi ukhen mino. ");
INSERT INTO agd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yisasi monó baya ma vanasi siamían kíparen Kapeniamú barufin óden mino. ");
INSERT INTO agd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ódíkan mai varufin mana antareti (100) aruvin banta kayoi ayafa vanta ano mana vei miyan ída van doran banta van béi anunu iyaré ein banta kákan aí íkan ádé anantá purono van en mino. ");
INSERT INTO agd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Purono van iyákan aruvin banta kayoi ayafa vanta ano Yisasin nan evan ne sin baya iniren bei miyan ída varan doran banta eman ayofano van Yutan kayoi ánon banta kéká tiantan Béin oman tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tiantákan betí Yisasi vaintá oriven ákonaen Béin tiamemí, “Aruvin banta kayoi ayafa vanta mai kama vanta ifo éi kanaíeya véin ayain nono. ");
INSERT INTO agd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tetí Yudiá kéka san béi anunu iyáken tetinti monó átaru namun beyantá uvantintein banta ino.” ");
INSERT INTO agd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Máa síkan Yisasi vetí ankan má mai má ádé oríkan aruvin banta kayoi ayafa vanta ano vei aronará baya siádan Yisasin me siamemí, “Bafan noe, séi ída kama vantan baruna éi ída kanaíeya séin timápin édan nono. ");
INSERT INTO agd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Máan tukhái séi ída kama vantan báké teyantá ída kanaíé éin o onanté umpo vaya máa vá éi se siná tenti miyan ída van doran bantai aí kípano. ");
INSERT INTO agd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Téi farava máa siya rauno. Tentá manáa vanta kéká ano yafiká betíi aránaópá téi váken maen manáa aruvin banta kayo ano senti aránaópá báká mana van ma orono sékun maen oriká ena van ma ereno sékun maen eré iyan mino. Tesi miyan ída van doran banta van ma ma yorarí ono sékun maen mai yoran baré iyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Máa síkan Yisasi mai vaya van anú duren ben ma yakhafen noré ein nanin banta yovéaren máa sen tiamemí, “Isareri kékápin ma vantai mumunan ma einí ukhein banta ída mana van mino.” ");
INSERT INTO agd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Máa sirákan aruvin banta kayoi ayafa ano ma siantan orikhá ein banta kayo ano evaránen oren mápin o onákan mai miyan ída van doran bantai aí kípakhan mino. ");
INSERT INTO agd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ínaimpáké Yisasi Naini se sin kákan barufá oríkan bei eyo iyampon kayo vá kokhon nanin banta vá ano véin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Oriaren mai varui yafu ona ádé o mantaven onákan mana varé nanin mano mana iyampon uró ana kain baren mai iyampon púkaré íkan beni kúkúta manáa vanta kayo ano yaiyóen erákan be anóen má kokhon nanin banta ano vákuren eren mino. ");
INSERT INTO agd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Erákan Bafan mano mai nanin ódaren moéken arunan uren máa sen béin tiamemí, “Ída vá ifídano.” ");
INSERT INTO agd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Máa siren béi mai ma fúkein banta ma yaiyen oriyá ein ádé o mantaven kúkútará ayan kaíkan mai ma yaiyen eriyá ein kayo ano o mantavíkan Yisasi semí, “Pumara oe, séi éin nan tiyá umpo orun mantano.” ");
INSERT INTO agd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Máa síkan mai ma fúká ein pumara ano orun mantaan kumamen araíen baya síkan Yisasi evaránen be anóen amen mino. ");
INSERT INTO agd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Amirákan minó nanin banta ano Tiyarafenui kákan ákona ódaren akhokho van uaren Tiyarafenu aví daní iyáken temí, “Mana sakhanampa vanta inka setí aúbaná afoká ukhan Tiyarafenu ano vei vanasi aya ono van inka e van mino.” ");
INSERT INTO agd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Máa siren banasi ano mai ma Yisasi varein avúavá baya e siádan Yudiá barafin ma vain baru kayo fimpá bá ádé barafá ina vá mai vaya ano oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Orera íkan Yonini eyo iyampon kayo ano Yisasi ma variyain dana san béin mo siamen mino. ");
INSERT INTO agd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tiamirákan Yoni vei eyo iyampon kanan araren Bafan baípá tiantiyan temí, “Tiyarafenu ano ma siantantin erino van ma sikhá ein éi mai vanta fono áa ená tetí ankan ave ótifante rafuno,” sen inaino van tianten mino. ");
INSERT INTO agd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tiantákan míkanan mano Yisasi vaintá oriven temí, “Éi nan mo inaino siren monó non péantan banta Yoni ano verasan tisintá eré umpo mai ma Tiyarafenu ano siantantin erino van ma siádan baré ein banta fono áa ená ave ótifante rafuno.” ");
INSERT INTO agd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Maí damú Yisasi ara ara aí daná ma varé ein nanin banta ayofiyáken namu aunan mano ma fákakharéin kayo fintena yo siantan namu aunan oriyákan auu ma yufúkukharé ein kéká evaránen auu kama uantan onan en mino. ");
INSERT INTO agd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Máan iyákan Yisasi evaránen Yonini eyo iyampon kanan tiamemí, “Taréa siré kanan nái yanasá oniyá iniyá iya fono mai vá Yonin mo siameno. Auu ma yufúkukhá ein kayo ano evaránen onákan arantan ma namu ukhá ein kéká ano oríkan aufá ma amon dana aí ma varé ein evaránen kama íkan átaren ma kontaré ein kayo ano vaya iníkan pefá ma fúká ein kéká ano orun mantan maen ona ma ída vain kayo ano kama vaya iniyan en mino. ");
INSERT INTO agd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Máan tukhein nan mi vanasi ano ma senti yoran ódaren ma mairá ída eraven ankamin nain kayo ano vá amusin ino. Mai kéká anon avu varanten mino.” ");
INSERT INTO agd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yonini vaya ma varen erikhá ein bantá kanan orivíkan Yisasi Yonin nan banasi máa sen tiamemí, “Tiretí ankan ma vanta ída van kámá barafá ma oriyaré eona mai nái yanasá onano vará oriyare fono. Uva ano mana ópen ná kayaiyayá onano vará oriyare fono. Ída ino. ");
INSERT INTO agd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tiretí ankan náiyasá onano vará oriyare fono. Mana vanta ano kama auí danasá uren bayá onano van oriyare fono. Ída ino. Kama auí daná ma ukhein banta kéká ano kin amápin mi váé iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Máan té iyan mifo siretí ankan nai yanasá onano vará oriyare fono. Tiretí ankan mana sakhanampa vantan onano van mi oriyare ono. Oriyá enái séi siretin tiamé uno. Minó sakhanampa vanta kayo véi ano esantakhen mino. ");
INSERT INTO agd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mai vanta van mi Tiyarafenui vompon dóki ano máa sikharen mino, ‘Ineno. Séi mana vanta siantékun tenti vaya varen éin anuanten eni aa mo uvíantanten mino.’ ");
INSERT INTO agd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Téi siretí ankan tiamé uno ma vara rákena minó banta Yoni ano esantakhen mifo Tiyarafenu ano ma yafíkein barufin ma sitosí ukhen bain banta anon Yonin esantakhen mino.” ");
INSERT INTO agd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Máa síkan betí ankan mai vaya iniren Yonin ayantá ma non mantaré ein nan ovaren me iniyáken takisi varan kéká bá banasi vá ano semí Tiyarafenui avúavá puntáken mino. ");
INSERT INTO agd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Máan tukhan mifo Farasisi kayo vá man baya ma afová ukhein banta kéká bá ano Tiyarafenui kama ineine oyan amen Yoni ma monó non péantiyain ída mantaren mino. ");
INSERT INTO agd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Máa siren Yisasi evaránen temí, “Taréa ma vain nanin bantai avúavá inte yanákasá tiádante rafuno. Betí inté ukhein nanin bantá ban nafino. ");
INSERT INTO agd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Betí ankan maen arará iyampon kayo ano ma varu aúbaná kumanten ma ena iyampon kayo van ma oovariyáken, “Tiretí ankan nan danisí ono van mi setí ankan okhakhan asiyákuya siretí ída amusin danisí e ono. Ída amusin e ídiyaonafin mi setí ifisana yékuya siretí ída ifídiyan ná uno.” ");
INSERT INTO agd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Máa siren Yisasi evaránen temí, “monó non péantan banta Yoni ano vereti vá uvaini vá ída niyákaya siretí ankan teya véimpin namu aunan mano van mino siyare ono. ");
INSERT INTO agd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Máa siyaré e nan mi Banta Anin mano saréa eriven uvaini vá dunan má niyákaya siretí ankan teya onano sakisi varan banta kayo vá ume vanta kéká bái aronan báken mi kokhon ná dunan má uvaini vá niyáken óen iyan mino siya ono. ");
INSERT INTO agd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tiretí ankan máa siya ompo Tiyarafenui afova ma mantein nanin banta ano vetíi afova ano fura yanasí ukhan mi setin aní iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mana Farasisi vanta ano véin má mo yunan nano van Yisasin arákan mai vanta amápin béi yunan nano van o kumanen mino. ");
INSERT INTO agd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","O vákan mana namu avúavá baren noin nanin mano mai varurá bain bákan Yisasi nan Farasisi vanta amápin dunan niyan mino síkan mai nanin mano mana on botorefin kama auna iyain uveri mamaren eren mino. ");
INSERT INTO agd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Eriaren Yisasin ayompá arantan ma vain ádé o mantaven ifí diyan baren mino. Ifí diyákan auufenté ánu kararen Yisasin arantantá arafúbíkan mai nanin mano ve ánon do fóké arúanten mino. Arúan tiyáken kokhon dádá Yisasin arantan amónaren kama auna ma iyain uveri anan máden béin arantantá péanten mino. ");
INSERT INTO agd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Máan tiyákan Yisasin ma arákan erein Farasisi vanta ano mai nanin ma variyain danasinta ódaren béi máa sen inemí, “Ma vanta fura sen sakhanampa vanta ma varen ma nanin mano ma ventá ayan kaiyain afová iyáken béini avúavá bá dere afová inainten mino. Ma nanin béi ume yaná baren noin nanin mino.” ");
INSERT INTO agd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mai Farasisi vantai ineine Yisasi afová iyáken máa sen béin tiamemí, “Saimoni oe, séimpin mana vaya váká éin tiamintó uno.” Máa síkan Saimoni máa semí, “Aru soe, ei vaya seno.” ");
INSERT INTO agd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Máa síkan Yisasi semí, “Kankanan banta ano mana vanta vaípákena moní inantiren mantaren anona evaránen ameno van baren mino. Mana vanta ano yan manápá tauseni (5000) moní barákan ena vanta ano yan manápá antareti (500) moní máa ana varen mino. ");
INSERT INTO agd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mamákaren míkanan banta ano ída kanaíen anona mai moní evaránen amirí ukheimpin mai vanta ano míkanan ma mantaré ein ifá uanten mifo éi ma iniyaona vekanan pinté intéa vanta anó béin nan moékentá anunu inten nafino.” ");
INSERT INTO agd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Máa síkan Saimoni evaránen temí, “Mai ma yan manápá tauseni (5000) ma mantaré ein banta ma ifá uantein mano ino,” síkan Yisasi véin tiamemí, “Mai eni ineine ano mo funtaren mino.” ");
INSERT INTO agd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Máa siren Yisasi yo vaében mai nanin oniyáken Saimonin tiamemí, “Éi ma nanin oniya fono. En amápin erékuya éi ída sirantan teséin non time nan mi ma nanin manoi ve ánufói sirantan tesé usintáden be ánon dofókéi yo arútinten mino. ");
INSERT INTO agd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","En amápin ma yun bákuya éi ída simó nen nan mi ma nanin mano anan mai ma éderuna ráké ten tirantampin timónen eriyan ban mino. ");
INSERT INTO agd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Éi ída uveri fétinten nan mi ma nanin manon auna uveri varen me sirantantá banaren pétinten mino. ");
INSERT INTO agd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Máan tukhái séi en tiamé uno. Ma nanin ná teti ódesá afová ó tifano véi sen nan moéken anunu iyákan mi Tiyarafenu ano veni kokhon ume arúanten mino. Arúanten mifo sító ume ma variyá inain bantai ume ma arúantá dantin mai vanta ano sító máarái anunu inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Máa siren Yisasi mai nanin máa sen tiamemí, “Eni ume kayo inka séi arúanté uno.” ");
INSERT INTO agd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Máa síkan dunan nan takhoká ma ve má kumantá ein banta kayo ano vetiyan ten orera emí, “Ma vanta véi iye uraná báken ná ume yere arúantiyan nafino.” ");
INSERT INTO agd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Máa siyákan Yisasi mai nanin tiamemí, “Eni mumunan mano síkaya Tiyarafenu vá taréa kama e va ompo éi ará kusin masá orono.” ");
INSERT INTO agd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ínaimpáké Yisasi kákan baru kayo fimpá bá tító baru kayo fimpá bá nóken Tiyarafenui yafisin baru fintena kama vaya kayo vanasi siamen oriyákan tiyan míkan mifo sirantan kan orun kádan (12) beni eyo iyampon kayo vá ano véin bákuren noren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Bákuren nókan pefá ma Yisasi ano ma manáa nanin kéká pintena ma namu aunan kayo ma yo siantiyan ma aí kípaantiyan ukharé ein nanin kayo ano véin má oriyaren mino. Oriyákan mai kayo fintena mana Mákdara kena Marian ne sin nanin ma yan manápá ifo afápá kan un kádan namu aunan ma véin pintena yo siantákaré ein nanin má dere maifin oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Oriyákan maifin Erotin amáká ma yafisin banta Kusan aná Yoanan má Susanan má inká ena nanin kayo vá ano vákuren oren mino. Mai nanin kayo ano vetí ina yaná póké Yisasin má bei eyo iyampon kayo vá aya iyákan doraríen noren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kokhon nanin banta ano minó baru fáké Yisasi vaintá e átaru uvin mana vaya véi sian baéan betí ankan amen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mana vanta ano vei yunan barafin danayun pafaseno van oren mino. Mo fafasiyákan manáa yanayun mano aasá eravíkan banasi ano arantampó me yasamiyan nun kayo ano e aídiyan nan en mino. ");
INSERT INTO agd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Manáa yanayun mano ompin eravukharen orun ampamaren barai anu ída vákan mai kayo ano ainen kafuren puren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Manáa yanayun mano ayankun namampin eravukharen orun ampamin ayankun naman mano úkuaren daramáden mino. ");
INSERT INTO agd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Máan tiyákan manáa yanayun mano kama varafin eravukharen e ampamaren kokhon ná antareti (100) aran iren mino.” Yisasi máa siren béi oovaren temí, “Áesin ná átaren ma van nain nanin banta ano vá ma vaya inino.” ");
INSERT INTO agd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Máa síkan beni eyo iyampon kayo ano véi ma ovaeran baya sikheini ana siamino van béin inaen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Inaíkan béi máa sen temí, “Tiyarafenu ano inka aní ukha vei yafisin baru fintena aúpá baya fefá afová ukha ompo ‘ena nanin banta kayo ano ovaeran baya inídaren onano van kokhon dádá onanten mifo vetí ankan ída mana yaná onanten mino. Kokhon dádá iniren mai ana vetí ankan ída afová inten mino.’” ");
INSERT INTO agd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Máa siren Yisasi evaránen temi, “Mai vaeran bayai ana máan mi ukhen mino. Danayun mai Tiyarafenui vaya ino. ");
INSERT INTO agd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mai vaya iniren ma vetí ankan mumunan intin Tiyarafenu ano aviran nae siren ma Ban Anon mano ínaimpáké eriven betin aú pintena mai vaya ma yovariyain mai nanin banta anoi yanayun ma aasá eravé iyain an mi yakhen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mai vaya ma iniyáken amusin iyan ma variyain kéká ano on daró ma eravukharéin ma arú ída yan araviyainíi ukhen mino. Betí ankan manáa afokhantá anan mumunan iyaréin ma akhenókain damusí ma íkan betí eraven ankamen Tiyarafenu me ampiren oré iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ayankun namampin ma eravein danayuni ana maen mai vaya iniren ma orein kékái vampin uman má minó daná baran má bara rákena amusin má ano mai kéká pákaan ákona uran ída kama aran iré iyain mino. ");
INSERT INTO agd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Máan té iyan mifo kama varafin ma fafasein danayun an ma yakein kéká ará ano kamaen puntákein kéká anon ákonaen báken mi aran iriyan báé iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Máa siren Yisasi ena ovaeran baya vanasi siamemí, “Mana ano ída kanaíen oon uruan takhó aránaópá kaen maen kurafin kuferen é iyan mifo sakhó darói vákan maen mi vanasi ano fanu ma siyain ódaren ódé iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aupá ma vain danasinta ano ínaimpáké afoká iyantin maen banasi ano ma yarariyá inain danasinta ano ínaimpáké afokasí intin minó nanin banta ano mai yanasinta afová inten mino. ");
INSERT INTO agd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Máan tukhein nan mi siretí ankan dafían ákona uveya vá kamaeya vaya ineno. Manáa nanin banta ano ma manáa afova yákantin Tiyarafenu ano manáa vá aminten mifo intéa nanin banta anó mana afova ída yáken ná mai afova van béi inen ná inká yáké uno siren ma vaya ída inin nain mai kéká ina Tiyarafenu ano minó do varanten mino.” ");
INSERT INTO agd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Maí damú ana Yisasin anóen má be afá kayo vá ano véin onano van eríkan kokhon nanin banta ano víkavin ída afokhaní ukhan beti ída kanaíen beni ádé oriríen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Máan tiyákan manáa ano Véin tiamemí, “E anóen má e afá kayo vá éin onano van barurá e ave ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Máa síkan Yisasi evaránen betin tiamemí, “Tiyarafenui vaya ma iniren dakhafiyain nanin banta mai séin tinóen má tifá tiváen má ino.” ");
INSERT INTO agd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Maná damú Yisasi vei eyo iyampon kayo siamemí, “Eritifé ma non ekhádé mesan ufá oró tifano,” siren betí ankan botifin un kumanen oren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Oriyákan Yisasi mai votifin auun bakharen mino. Bavíkan mairá kákan uva uaren békon unen non karantó en mai votifin un bíkaaren ádé anantá banairí íkan betí umampin oriríen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Máan tíkan betí ankan Yisasin mo avoriyan temí, “Bafan noe, Bafan noe, setí ankan ádé anantá non ufurirí iyá uno,” síkan béi orun mantaven mai uva vá kákan non ma karantó iyain má kípano van ákonaen asíkan mai uva vá kákan non ma karantó iyá ein má kípaaren ída evaránen kayaen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kípavíkan béi máa sen betin inaemí, “Tiretíi mumunan intesá ukhen nafino.” Máa síkan mai kéká ano akhokho van iyáken beraran ten oreraemí, “Ma vanta iyé báken ná uva vá non má tiamíkan ná béin oo yaiyiya nafino.” ");
INSERT INTO agd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Máan turen Yisasin má bei eyo iyampon kayo vá Karirí non ankinafá bain Kerasá barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Oriven mai voti finté ma káusen non akhempá ma araviyain má ana mana namu aunana pákakhein banta ayá damú avápa váken ída mápin barana vanta masí ukhein pimpá ana varen noré ein má o fóken mino. ");
INSERT INTO agd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","O fókavíkan mai vanta ano Yisasin oniyan avádóden bádiyan ben arantan ádé o vaven oovararen máa semí, “Yisasi oe, éi yan bain Tiyarafenu Anin mompo éi náisá téin into fono. Téin ída vá namu usintano van mi éin tiamiyá uno.” ");
INSERT INTO agd_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Béi farava vádenaino mai vanta namu aunan mano me ampiren orino van Yisasi fefá tiamíkhan mino. Kokhon dádá mai vanta ayan arantantá seni ananpoké damuan ákona uren ma kaúdan maen béi mai seni anan bempáké antádan maen namu aunan kayo ano véin do avíádan kámá barufá oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Máan tiyaréin Yisasi véin máa sen inaemí, “E aví iye fino,” síkan pefái mai vanta aúpin kokhon namu aunan kayo varé íkan mai vanta ano máa semí, “Ten tiví kokhon ná aruvin banta kayo ino.” ");
INSERT INTO agd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Máa síkan namu aunan kayo ano váden berai siyan Yisasin tiamemí, “Éi ída vá tetí ankan aron ída van masípin tisintano.” ");
INSERT INTO agd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Máa siyan mo onákan ayo fákena fon kayo iyukhen dunan niyaré íkan mai namu aunan kayo ano verai siyan ákonaen Yisasin inaemí, “Éi áesirá mesan pon kayo aúpin oferá tifano,” síkan béi “kana ino” siren ifáin oren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","“Kana ino” síkan namu aunan kayo ano mai vanta me ampiren pon kayo aúpin ofébíkan mai fon kayo ano ayampaíen tava uaren ayafin araven nompin orun áduven ufuren puren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Máan tíkan mai fon kayorá ma yafíkaré ein kéká ano mai yaná ma afoká ein ódaren betí ankan karan oriaren mai vaya e siádan ádé ma vain kákan barufin má akhempá ma vain baru kayo fimpá bá dere oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mai vaya orera íkan banasi ano iniren mai ma afoká ukhein daná onano siren minó nanin banta ano evúten oriyaren o onákan mai ma namu aunan kayo ano ma me ampiren orein bantai ineine kama uvíkan auí daná uren Yisasin arantan ádá kumantan betí ankan akhokho van en mino. ");
INSERT INTO agd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Akhokho van iyákan mai yaná ma afokáin ontaré ein kéká ano eriven intesá ená mai vanta aú pinté namu aunan mano me ampiren orivin ná kamaen nafi mai vaya vanasi siamin inen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tiamíkan Karasá baru rákena nanin banta ano Yisasi ma ákona yorarí ukhein nan betí ankan akhokho van uren betin me ampiren orino van ákonaen tiyaimpin Yisasi votifin káusen ódiven evaránen oren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tiantan Yisasi me onen oriyákan mai ma namu aunan ma fákakharé ein banta ano ven má orono siren iyaní íkan béin evaránen tiantiyan máa semi, ");
INSERT INTO agd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Éi evaráne ei varufá oriveya vá mai ma Tiyarafenu ano ma éin ayaen kama uantein baya vá tesin banasi inino,” síkan mai vanta ano vei varufin oriven eúkiyáken Yisasi ano ma véin ayaen kama uantein baya e siamen oren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yisasi non ekháden ena ufá oríkan banasi ano véi ma oriyain ave ukharen ben onen amusin en mino. ");
INSERT INTO agd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Amusin iyákan mana monó átaru namuntá dafíkein ánon banta Yairasin ne sin mano mairá eriven Yisasin arantampin aron kanan mo yurafúden ben má orino van béin ákonaen inaen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Parava véin inaen naino véi mana arinta anan dan baren tiyan míkan mifo sirantan kan orun kádan (12) oranaí ukharen aí baren ádé anantá purono van iyan mino. Máa sen ina íkan Yisasi ven má orin kokhon nanin banta ano véin dakhafen mákáka suron uven oren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Oriyákan maifin mana nanin tiyan míkan mifo sirantan kan orun kádan (12) oranará ena ena yamú biyon aí daná bariyákan mana vanta ano ída kanaíen béin ayofiyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Máan tiyaré íkan mai nanin mano Yisasin ayompá oriven ayan dan orin beni ayá au anamun áton aruvíkan manádá beni nare kípen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Máan tíkan Yisasi máa sen inaemí, “Iye anó téin tiruviya fono,” síkan minó nanin banta ano “ída ino” sen orera íkan Pita semí, “Bafan noe, kokhon ná nanin banta anon éin amáden manten eúkukhen mi avékiyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Máa síkan Yisasi semí, “Mana ano séin tiruvin mi senti ákona ano sen me ampiren oriyái afová iyá uno.” ");
INSERT INTO agd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Máa síkan mai nanin mano iníkan avinantan den ída umerarí eimpin Yisasin arantampin mo aron kan durafúden mátimen minó nanin banta avorá pará ben aruvin ná bei aí ainen kípen nafi mai yaná tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Máa síkan Yisasi semí, “Tiraun noe, éini mumunan manon éin ayofen mifo ará kusin masá orono.” ");
INSERT INTO agd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Máa siren Yisasi fara vaya siyan bákan monó átaru namuni ánon banta Yairasin amá pinté mana vanta ano eren me véin tiamemí, “E araun inka furen mifo éi ída vá enádá bá arú banta uman ameno.” ");
INSERT INTO agd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Máa síkan Yisasi mai vaya iniren mai ánon banta evaránen tiamemí, “Éi ída vá akhokho van eya vá mumunan mana vá ono e araun asefa inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Máa siren Yisasi mai ánon banta amápin ódiyáken Pitan má Yonin má Yemisin má mai arinta anóe afóen má ana avíaren banasi ída áíkan maifin béin má óden mino. ");
INSERT INTO agd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ódíkan pefá ma mápin baré ein nanin banta ano mai arinta van arunaná baren ifí diyan baréin Yisasi vetin máa sen tiamemí, “Béi ída fúken paran auun bakhen mifo sireti ída vá ifí daro.” ");
INSERT INTO agd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Máa síkan betí ankan mai arinta ma fúkein afová ukhen béin nan inten mino. ");
INSERT INTO agd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Intiyákan Yisasi mai arinta ayan pákaaren máa semí, “Tiraun noe, orun mantano.” ");
INSERT INTO agd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Máa síkan mai arinta aunan mano ovaránen béimpin eríkan ainen orun mantavin mai arinta yunan amino van Yisasi vetin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tiamirákan mai arinta anóen má afóen má ano anú duren akhokho van íkan Yisasi vékanan ákonaen tiamemí, “Tiré kanan ída vá ma yaná ma afoká ein ena nanin banta siameno.” ");
INSERT INTO agd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yisasi vei eyo iyampon kayo sirantan kan orun kádan (12) ma aran eríkan maen namu aunan ma yo siantan má aí nanin banta ma ayofan ákona vá mai kéká amiyáken ");
INSERT INTO agd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tiyarafenui yafisin baru fintena vaya siamiyáken uren aí nanin banta ayofano van tiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tiantan oriyákan Yisasi vetin máa sen tiamemí, “Tireti ankan ída vá unan má bereti vá moní bá ayonta vá bare vá inka ída vá kankanan afuin barano. ");
INSERT INTO agd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mana varurá ma siretí ankan oriveya mana namumpin ma ódinte vá mai namun mana vá bareya mai namuntesá mai varu me ampire orono. ");
INSERT INTO agd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mana varu rákena nanin banta ano ma siretin ída e avían be amápin kainti vá mai varu ma me ampire oriya vá arantantáke kayó me fúpá tian karúdesin ná banasi afová ená teti namu é uno sino.” ");
INSERT INTO agd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Máa sirákan eyo iyampon kayo ano varufimpá orera uven kama vaya siamiyáken minó akhen pákena aí nanin banta ayofen mino. ");
INSERT INTO agd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Máan tiyákan manáa vanta kayo ano siyáken, “Yoni evaránen masí pinté orun mantakhen mino,” siyákan Eroti kamanini ánon banta ano Yisasi ma variyain danasinta van iniren kokhon ineine iyákan ");
INSERT INTO agd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","manáa kéká ano sen pefá ma vá ein mai sakhanampa vanta kéká pintena mana anon orun mantakhen mino síkan manaá kéká ano sen Iraiyan afoká ukhen mino síkan en mino. ");
INSERT INTO agd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Máa síkan Eroti máa semí, “Téi fefái Yonin amen tíkakhé umpo ma vanta iye uron ná bákan ná banasi ano véi ma ena yaná dorarí iyain baya siyará iniya rafuno.” Máa siren Yisasin onano van en mino. ");
INSERT INTO agd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Beni eyo iyampon kayo ano ovaránen eriven betí ankan ma yoren noré ein baya kayo Yisasin tiamiran betin mana yo avíaren ena nanin banta kéká me ampiren Betsaida se sin kákan barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Orivíkan kokhon nanin banta ano Yisasi ma orein afová uren béin bákuren orikan amusin iyáken Tiyarafenui yafisin pintena vaya siamin iniyákan aí ma varé ein kayo ayofen mino. ");
INSERT INTO agd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Inúpasi íkan tiyan míkan mifo sirantan kan orun kádan (12) beni eyo iyampon kayo ano véi vaintá eriven béin máa sen tiamemí, “Ma ma setí baruna akhempá ída mana nanin banta van mifo éi kaná betin tiantesin ná kákan baru kayo fimpá bá tító baru kayo fimpá bá oriven ná betíi yunan má baran ma san dosino.” ");
INSERT INTO agd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Máa síkan Yisasi evaránen betí ankan tiamemí, “Tiretí ano vá mai nanin banta yunan ameno,” síkan betí ankan temí, “Dan manápá bereti vá kankan noyana vá anan dékun ban mifo ena vá dunan o miyaní é ma nanin banta me amente rafuno.” ");
INSERT INTO agd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dan manápá tauseni (5000) fumara vanta vákan Yisasi vei eyo iyampon kayo máa sen tiamemí, “Mai nanin banta siamesin fifti (50) ano me kumádu kumádu ino.” ");
INSERT INTO agd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Máa síkan eyo iyampon kayo ano mai ma seiní íkan minó nanin banta ano kumanen mino. ");
INSERT INTO agd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kumamíkan Yisasi mai yan manápá bereti vá kankanan noyana vá máden inarufá kakháben Tiyarafenurá tusu siren mai vereti vá noyana vá kisikisi uren dákan bei eyo iyampon kayo ano masiman en mino. ");
INSERT INTO agd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Masiman íkan minó nanin banta ano kanaíen narákan antan dunan ma fara varé ein eyo iyampon kayo ano manafin o éke e éke uan átaru uren tiyan míkan mifo sirantan kan orun kádan (12) basiketi unan kayo víken mino. ");
INSERT INTO agd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Maná damú Yisasi veyáká amúkiyan bákan bei eyo iyampon kayo ano véin má baré íkan béi máa sen betin inaemí, “Téin nan iye inó banasi ano siyan nafino.” ");
INSERT INTO agd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Máa síkan betí ankan evaránen béin tiamemí, “Manáa kéká ano éin nan monó non péantan banta Yoni ino síkan inká manáa kayo ano Iraiya ino síkan inká manáa ano fara sen pefá ma sakhanampa vanta kayo varé ein pinté mana ano orun mantakhen ne siyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Máa síkan betí ankan béi máa sen inaemí, “Tiretí ankan téin nan mai iye inó tiya rafono.” Síkan Pita evaránen béin tiamemí, “Tiyarafenu ano ma sian damuádiyáken ma sesi vanasi evaráné avirano van tiantékun orintene ma sikharé ein mai vantan éi va ono.” ");
INSERT INTO agd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Máa síkan Yisasi vei eyo iyampon kayo van ída vá ena nanin banta siameno siren ákonaen areuanten mino. ");
INSERT INTO agd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Máa siren béi semí, “Banta Anin mano kokhon uman barantin maen ánon banta kayo vá monó ánon banta kéká bá man baya ma afová ukhein banta kéká bá ano véin oyan amiren aruan púdantin maen kanú manaú damusí intin béi evaránen orun mantanten mino.” ");
INSERT INTO agd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Máa siren minó eyo iyampon kayo véi máa sen tiamemí, “Mana nanin banta ano ma séin bákurono van anunu iyanten bei anunu maman bararasí uren ná ena ena yamú bei marípo yaa mamaren ná téin bákurino. ");
INSERT INTO agd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mana nanin banta ano ma ve aunan pákaan ákona intin béini aunan mano o afeyoranten mifo mana nanin banta ano ma séi nan iniren ma ve aunan ampin nain kayoi aunan mano fara kamaen banten mino. ");
INSERT INTO agd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Banten mifo mana nanin banta ano ma ma vararakena yanasinta variyáken ma veyan namuen afeyókantin mai yanasinta ano intesá uren ná béin ayainten nafino. ");
INSERT INTO agd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mana nanin banta ano ma senti vaya vá téin ma san ma ayave van iyaré esin ma Banta Anin mano ma vei kákan kakhan má be Afóeni kakhan má kantasí ukhein enisori kayoi kakhan má ma ínaimpáké erinten maen mai nanin banta van dere véi ayave van uantanten mino. ");
INSERT INTO agd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Téi fura urá tiré tiretí ankan tiamiyá uno. Mará ma saréa mantakheona kéká pinté manáa ano ída fúken mi Tiyarafenui yafisin baru onanten mino.” ");
INSERT INTO agd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yisasi mai vaya kayo siran dan manápá ifo afápá kanú manaú un kádan damú esantavíkan Pitan má Yonin má Yemisin má avíaren amúkono van mana anurá óden mino. ");
INSERT INTO agd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ódiven amúkiyan baré íkan béin auná enarasí íkan béini ona ano maman efaní iyan moéken panu sen afayu an den mino. ");
INSERT INTO agd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Máan tíkan kankanan banta Mosesin nú Iraiya nú dákó iyain má békanan au fáké moéken panu siyákan Yisasin ma Yerusaremí arintin púaren ma ma vara me ampiren orinaí pákena vaya siyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Máa siyákan Pitan má ena eyo iyampon kanan má auunan aí iyaimpin betí ankan aunká bakharen orun mantaaren Yisasini kakhan má kankanan banta vá ano ma mantakhein onen mino. ");
INSERT INTO agd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Oniyákan ma míkanan banta ano Yisasin ma me ampiren oriyákan maen Pita ano máa sen Yisasin tiamemí, “Bafan noe, setí ankan ma mará baruna mai kama ukhen mino. Tetí kanaíé kanú manaú iyon baran namun uvádékun mana éin nina vantin mana Mosesin nina vantin mana Iraiyan nina vantin ino.” Pita mai vaya sen mifo veyan náiesá tiya rafuno sen ída afová ukharen mino. ");
INSERT INTO agd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita mai vaya fara siyan bákan mana konan mano vetí ankan me ukuan dararan akhokho van en mino. ");
INSERT INTO agd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Akhokho van iyákan mai konan pinte mana oovaren máa semí, “Ma se sanin pefá aní ukheruna ifo véini vaya vá ineno.” ");
INSERT INTO agd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mai vaya ma sian kíparákan Yisasi veyáká ana mairá mantakhan betí ankan óden maí damú ma afokáin onein danasinta veti maí damú ana ída ena nanin banta siamen mino. ");
INSERT INTO agd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ená damú Yisasin má Pitan má Yemisin má Yoni má ano mai anuyon me ampiren araviyain má kokhon nanin banta ano vetin má efóken mino. ");
INSERT INTO agd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mai aúbanáké mana vanta ano oovaren máa semí, “Aru soe, éi kana eriveyá te sanin onante fono. Mai mana iyampon manan téi yékun baren mino. ");
INSERT INTO agd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kokhon damú mana namu aunan mano véin aúpin ódivin maen béi namu vá dákan maen mai ano véin máden antu antu íkan efanten akhare ano ven oo fenté eriyákan maen mai namu aunan mano véin au máden namu uren ída ainen me ampiren orin nainí é iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Máan tiyáká téi ákonaé berai sé eni eyo iyampon kayo van mai namu aunan do siantano van tiamiyákun mifo vetí ankan ída kanaíen tiantan nainí iyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Máa síkan Yisasi semí, “Tiretí ída mumunan in nanin banta kayo ompo siretíi ineine vá avúavá bá ída funtáken mifo nái máa yamusá téi siretin má bákerá tiretíi uman bariyá bante rafuno.” Máa siren mai vanta van “E anin avire mará ereno,” sen tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Máa síkan mai iyampon mano ma Yisasini ádé eríkan maen mai namu aunan mano véin karúdan barará aravúbin béin máden antu antu iyain má Yisasi mai namu aunan asíkan mai iyampon mano evaránen kama uvíkan be afóen amen mino. ");
INSERT INTO agd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Máan túkan minó nanin banta ano Tiyarafenui kákan ákona ódaren akhokho van iyáken Yisasi ma variyain dana san kokhon ineine iyákan Yisasi vei eyo iyampon kayo van máa sen tiamemí, ");
INSERT INTO agd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kamaeya vá átaren kaúde ma vaya ineno. Banta Anin maen mana ano namuro kéká ayampin avían aminten mino.” ");
INSERT INTO agd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Eyo iyampon kayo ano mai vayai ana ída afová en mino. Mai vayai ana ano vetimpin aúpá bákan ída afová iyáken mi mai vaya inain nan betí ankan akhokho van uren ída véin inaen mino. ");
INSERT INTO agd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Maná damú eyo iyampon kayo ano veraran iye anó o esesí inten nafino siren asive asive iyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Máa siyákan Yisasi vetí ankani ineine afová iyáken mana arará iyampon aviren bei ádé me mantaantáden eyo iyampon kayo máa sen tiamemí, “Iye anó téin nan inireyá mana máan tukhein iyampon arará aya inten nafi mai ano séin mi siya inten mino. Inká iye anó téin tiya inten nafi mai ída séin tiya inten mifo Tifóe ma séin tisintá erikheruna mai véin mi aya inten mino. Para vara seyo, siretí ankampin ma aví ída vain nanin banta anon o esesí inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Máa síkan Yisasini vaya Yoni iniren béin evaránen tiamemí, “Bafan noe, setí ankan onékun mana vanta ano éin avíká namu aunan tiantiyáken éin ída vákuren nói setí ankan mano véin are uantano van é uno.” ");
INSERT INTO agd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Máa síkan Yisasi véin máa sen tiamemí, “Tiretí ankan ída vá béin airo ananí uantano. Tiretin ma ída namuroí iyain kéká ano mai siretin arona ino.” ");
INSERT INTO agd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tiyarafenu ano ma Yisasin evaránen avirantin inarufá ódin nain ádé iyákan Yisasi Yerusaremí orono van ákona inin bariyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","53","Béi manáa vanta kéká tiantan minó ben nina yána utaono van mana Sameriá bain barurá oríkan mai varu rákena nanin banta kayo ano afová íyáken béi Yerusaremí orono van mino siren betí amápin ída Yisasin e avian kaen mino. ");
INSERT INTO agd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Máan tíkan beni eyo iyampon kanan Yemisin nú Yonin nú ano mai ma Sameriá nanin banta ano ma variyain avúavá baya iniren béin máa sen inaemí, “Bafan noe, éi anunu iyan nona vará tetí ankan inarufákena ira arékun ná morun betin ken kaurinten nafino.” ");
INSERT INTO agd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Máa síkan Yisasi yo vaéaren míkanan asiren ");
INSERT INTO agd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","betí ankan ena varufá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Oriyaré íkan aasákena mana vanta ano Yisasin máa sen tiamemí, “Éi ma orinona akhempá téin má bákuré nonté uno.” ");
INSERT INTO agd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Máa síkan Yisasi evaránen béin tiamemí, “Afá iyan kayo ina vara ain ban maen nun kayo ina nan báé iyan mifo Banta Anin mano ma avíken baran kanú ída van mino.” ");
INSERT INTO agd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Máa siren Yisasi ena vanta van temí, “Éi ereya séin dakha fono,” síkan mai vanta ano semí, “Bafan noe, éi áesisá te sifóen nare mo masí uresá ono.” ");
INSERT INTO agd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Máa síkan Yisasi véin máa sen tiamemí, “Áesin purin nanin banta ano vetiyan ná púkein kéká masí iyantiya éi oriveya Tiyarafenui yafisin baru fintena vaya sian dákó ono.” ");
INSERT INTO agd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Máa síkan ena vanta ano Yisasin máa sen tiamemí, “Bafan noe, séi en bákurono van ukhé umpo éi kaná áesirá tesi kéká mo susu siantádesá ono.” ");
INSERT INTO agd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Máa síkan Yisasi evaráne véin tiamemí, “Sitia fákaráken ma ena ena yovaébiyan oyampá ma onan nain kéká ano ída kanaíen Tiyarafenui yafisin baru fintena yorarí inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ínaimpáké Bafan mano seventi-tu (72) vanta avíden beyan ma orono van ukhein barufá tiantan béin anuanten kankanan orirú en mino. ");
INSERT INTO agd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Oriyákan mai kéká máa sen tiamemí, “Dunan anafin kokhon ná dunan afukhakhan mai yunan ma yuyasin banta kayo ída kokhon ban mifo siretí ankan mai yunan ana afóentasá amúkesin ná béi kanaíen doran banta kéká tiantan tiná mai yunan anafin oriven ná duyasino. ");
INSERT INTO agd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tiretí ankan orin nompo vá ineno. Téi siretí ankan afá iyan aúbaná ma sipisipi arará kayo ma siantan oreiníi é uno. ");
INSERT INTO agd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tiretí ankan ída vá moní kain unan má ona khain unan má arantan anamun má bare vá oriyáke mae ída vá aasá ma esantanona nanin banta van bayan mino inúpá ino seno. ");
INSERT INTO agd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Oriyare ma mana namumpin ma oferante vá esé araí in baya vá máa seno, ‘Áesin Tiyarafenu ano vá tire antun ná ará kusin amino.’ ");
INSERT INTO agd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mai namumpin ma mana ará kusin má bain banta ma vantin maen Tiyarafenui ará kusin mano mai vanta vá bei kéká bápin banten mifo máan banta ma ída vantin maen Tiyarafenui ará kusin mai vanta vá bei kéká bápin ída vanten mino. ");
INSERT INTO agd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tiretí ankan mai namumpin mana vá bákeya mai finté ma amin nain dunan má non má ana vá nano. Para vara seyo, yoriyá ein banta ano miyan baré iyan mifo siretí ankan ída vá ena namumpin e fere khuve ono. ");
INSERT INTO agd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Máan tin nompo siretí ankan ma mana kákan barurá ma oresin ma kama iyáken aviren má naumpin ma mo kaúden ma amin nain dunan ná parav á nano. ");
INSERT INTO agd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tiretí ankan mai varu rákena aí nanin banta kayo ayofiyáke vá Tiyarafenui yafisin baru inka siretí ankani ádé erikhein mino seya vá betí tiameno. ");
INSERT INTO agd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tiretí ankan ma mana varufin oresin ma mai varuráké kéká ano ma ída e avían mápin ma kaintiya siretí ankan mai varui aasá o mantaveya vá máa seno, ");
INSERT INTO agd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Tiretí ankani varu rákena kayó ano setí ankan tirantantá dampakhein ma yo fúpá tian karúdanuna anon tiretí ankan aní iyáken mai avúavá ma vareona ano umei e ono’ se vá betin tiamiyákeya vá ‘Tiyarafenui yafisin baru inka ádé erikhen mifo siretí ankan kama e vá ineno,’ seya vá betí ankan tiameno. ");
INSERT INTO agd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Téi siretí ankan tiamiyá uno. Banasi ma yaimin damú ma Tiyarafenu ano aní ukheintá ma afoká intin mai varu rákena nanin bantai uman mano Sodomú baru rákena nanin bantai uman esantanten mino. ");
INSERT INTO agd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Máa semí, “Korasiníke nanin banta oe, sirun uron mi ke ono. Betsaidáke nanin banta oe, sirun uron mi ke ompo mana vanta ano ma Taiyá bá Saidoní bái varufin ma oriven máan avúavá daná ma mo afoká intin maen betí ankan kanaíen ará baéden arunaná auí daná uren amon ánompin kakhufaren kumanten betíi ume van arunan inté ein mino. ");
INSERT INTO agd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Banté ein mifo Tiyarafenu ano ma vanasi yaiminton ma aní ukhein damú ma yákó intin tiretin amaniná ma afoká inain uman mano Taiya sú Saidoni úpin ma afoká ukhá ein uman moéken esantanten mino. ");
INSERT INTO agd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Máan tinten mifo éi Kapeneamú baru oe, éin iye ano avían dan ayontá kainten nafino. Ída mana ano aviranten mifo pefá ma fúkein nanin bantai varufin manan aravin nono.” ");
INSERT INTO agd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Máa siren Yisasi mai seventi-tu (72) vanta siamemí, “Tiretí ankani vaya ma iniyain nanin banta ano séinti vayan iniyan mifo inká tiretí ma oyan amiyain nanin banta ano mai séin mi oyan timiyan mino. Téin ma oyan timiyain nanin banta ano séin ma sisintá ererunan oyan amiyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ínaimpáké seventi-tu (72) vanta ma siantan orikhá ein kéká ano ovaránen amusin iyan eriven me siamemí, “Bafan noe, setí ankan ma éin aví arékun maen namu aunan kayo ano setinti vaya ánain bákuren mino.” ");
INSERT INTO agd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Máa síkan Yisasi vetí ankan evaránen tiamemí, “Téi onékun Ban Anon mano inaru me ampiren afayuí ma einíen eraven mino. ");
INSERT INTO agd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ineno. Téi siretí ankan inka ákona amikheruna sireti kanaíeya osafáe kayo vá banta untaran danasinta vá dasádeya siretí ankan kanaíeya siretíi namuro minó ákona esantaresin béi ída kanaíen tiretíi minó daná namu inten mino. ");
INSERT INTO agd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Máan tinten mifo siretí ankan ída vá amusin iyáke seya namu aunan mano setin too yaiyiyan mino seno. Inarufá ma Tiyarafenu ano ma vei vompon dókifin ma siretin aví uvantein nará amusin ono. ");
INSERT INTO agd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Maí damú Kantá Aunan mano Yisasin arápin amusin amíkan béi máa semí, “Tifóe oe, éi ma vara vá inaru vái Bafan bákeya éi ma kama afova vain kéká ma ma yaná aúmanantádeya ma arará iyampon kayo an dakhein kéká ma aní eona van tusu sé uno. Tifóe oe, éi fura sireya e anunun dakhádeya éi máan te ono. ");
INSERT INTO agd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Te Sifóe ano minó danái sen tiyampin kaúken mino. Mana ano ída ve Anin afová ukhen mifo ve Afóe ano anan afová ukhan mi inká mana ano ída ve Afóen afová ukhen mifo ve Anin mano ma aní ukhein kéká bá be Anin má ano anan béin afova ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Máa siren Yisasi yo vében bei eyo iyampon kayo oniyáken temí, “Tiretí ankan ma oniyaona yanasinta ma onan nain kéká ano vá amusin ino. ");
INSERT INTO agd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Pefá kokhon ná sakhanampa vanta kayo vá kokhon ná kin kayo vá ano siretí ma saréa oniyaona yana onano van anunu iyaren mifo ída onen mino. Inká tiretí ma iniyaona vaya ineno van anunu iyaren mifo ída inen mino.” ");
INSERT INTO agd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mana man baya ma afová ukhein banta ano Yisasin akhenóka uan onano van orun mantaven béin máa sen inaemí, “Aru soe, séi intesá uresá para van oriyan ban aunan barante rafuno.” ");
INSERT INTO agd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Máa síkan Yisasi evaránen béin inaemí, “Man bayafin intéa vayá bákayá dankaféiya fono.” ");
INSERT INTO agd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Síkan man baya ma afova ukhein banta ano evaránen temí, “Tiretí ankani aú amafon má ákona vá ineine vá pokesá pura uró tire vá Bafan Tiyarafenu van anunu iyáke vá eyan nan ma anunu iyaonaíe vá ena van anunu ono.” ");
INSERT INTO agd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Máa síkan Yisasi véin tiamemí, “Mai ma seona mai fura se ompo vá mai ma seonai ureya vá para van aunan barano.” ");
INSERT INTO agd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Máa síkan man baya ma afová ukhein banta ano veyan nan puntákein banta ino sino van Yisasin máa sen inaemí, “Man baya ano iyen nará tiretíi arona kayo e sikhen nafino.” ");
INSERT INTO agd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Máa síkan Yisasi evaránen béin tiamemí, “Mana vanta ano Yerusaremí me ampiren Yerikó barufá araviyaré íkan umoyan banta kayo ano aasá dafíkaren béin pákaren namu arirí uren beni ona varen karan orivíkan béi aasá bakhen ádé anantá purono van iyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Maí damú ana mana monó doran banta ano mai aasá dakhafen araviyaren onákan mai vanta ano aasá bakhen bákan akhempá o úkuaren esanten oren mino. ");
INSERT INTO agd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Orivíkan mana Rivai vanta ano máan mana en mairá oriaren mai vanta e onen akhempá o úkuaren esanten oren mino. ");
INSERT INTO agd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Orivíkan mana Sameriá banta ano mai aintá ana araviyaren mai vanta ma vaintá oriven onen moéken arunan uanten mino. ");
INSERT INTO agd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mai vanta van arunan uren béin ádé oriven ben ma arurampin uveri féantiyan uvaini vanaan tiyan uren mai namon damuanten mino. Damuantáden bei donkin daró dauman ka íkan kumamin do aviren aasá ma miyaní uren bariyain namumpin mo kaúden kamaen dafisen mino. ");
INSERT INTO agd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Dafisen bakharen ená damú mai má afóen kankanan siriva moní amiyáken máa sen tiamemí, “Ma vanta vá éi kama e vá dafiseno. Dafisiyáke ma manáa ei moní ma ventá kíparákaréesí ma séi ovaráné erenté maé éin mai máa moní evaráné amenté uno.” ");
INSERT INTO agd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Máa siren Yisasi ano man baya ma afova ukhein banta inaen temí, “Éi ma iniyaona mai máa kanú manaú banta kayo finté intéa vanta anó umoyan banta kayo ano ma aruádan baré ein banta van anunu ukharen nafino.” ");
INSERT INTO agd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Máa síkan mai vanta ano semí, “Mai ma véin nan arunan uren aya ein banta ino,” síkan Yisasi véin tiamemí, “Éi orive vá máa avúavasá barano.” ");
INSERT INTO agd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Máa siren Yisasi má bei eyo iyampon kayo vá oriyaren mana varurá onóbíkan mai varu ráke mana Matan ne sin nanin mano Yisasin aviren be amápin oren mino. ");
INSERT INTO agd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mo orákan mana Matan aun Marian ne sin nanin baren béi Yisasin arantan ádé o kumanten béini vaya iniyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Baya iniyákan Mata veyáká dunan taran tasusasu iyáken kokhon ineine uvaen Yisasi vaintá oriven béin inaemí, “Bafan noe, se sun mano séin me ampiráká teyan dunan tariyá umpo mai van ídá ovaré iniya fono. Béin tiamesin ná téin me siya ino.” ");
INSERT INTO agd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Máa síkan Bafan mano evaránen béin tiamemí, “Mata. Mata oe, éi kokhon dana san ineine iya ompo ");
INSERT INTO agd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","mana yana san mana vá ineno. Maria kama yanái varano van anunu iyain téi ída kanaíé béin ma varano van iyain daná béin areuantanté uno.” ");
INSERT INTO agd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Maná damú Yisasi mana akhempá amúkiyan baren kíparan mana vei eyo iyampon mano máa sen béin tiamemí, “Bafan noe, fefá ma Yoni ano ma vei eyo iyampon kayo ma amúkin afova ma amikharé einí eya éi setin afova simeno.” ");
INSERT INTO agd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Máa síkan Yisasi evaránen betí ankan máa sen tiamemí, “Tiretí ankan ma amúkinte vá máan ná teno, ‘Tifóe oe, en avisá kantasí intin ná éini inaru yafisin ná erino. ");
INSERT INTO agd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mana mana yamúkáke yunan ná timeno. ");
INSERT INTO agd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Éi setinti ume vá ampisintano. Para vara seyo, ena kayo ano ma sétin umeí usintáká ein ampiantéiyá tiféuno. Éi ída vá áesí tirá mantan akhenókafin oferá tifano.’” ");
INSERT INTO agd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Máa siren betí ankan evaránen tiamemí, “Tiretin aúbanáké mana ano ma vei arona varé intin ma mai vanta vaípá inuran aúban oriven ‘kanú manaú bereti anamun timikaréesí anona evaráné ameno’ sinten mino. ");
INSERT INTO agd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Para vara seyo, mana sirona ano ayá káké eriyan baren te simá e vaká béin ma amenuna yunan ída vá uno.’ ");
INSERT INTO agd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Máa sin maen mápin ma vain banta ano evaránen tiamemí, ‘Ten má te sikhafana vá bakhékun ona fefái munkukhein téi ída kanaíe e mantavé éin mana yaná amenté umpo ída vá téin uman timeno.’ ");
INSERT INTO agd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Téi siretí ankan tiamé uno, béi ve arona ifo má afóe ano ída kanaíen orun mantaven bereti aminté ein mifo véi ma ínanen onará ankamiyan bain nan mi má afóe ano orun mantaven minó béi ma inantiyaré ein daná máa aminten mino. ");
INSERT INTO agd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Máan tukhein nan mi siretí ankan tiamé uno. Inantesin maen Tiyarafenu ano kanaíen aminten mino. Dosiyaré esin maen Tiyarafenu ano kanaíen aní intiya ona nono. Onará ma ankamiyaré esin Tiyarafenu ano kanaíen ona yiantanten mino. ");
INSERT INTO agd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Para vara seyo, iye anó inantéiya nafi mai anon baré iyan mino. Iye anó dosé iyan nafi mai ano oman dákó é iyan mino. Onará ma ankamein dianté iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Tiretí iyampon afóe yan ma vaonafá ma e anin mano mana noyana van ma inan tintiya éi kaná mana osafáe aminte fono. ");
INSERT INTO agd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Áa éi vaípá ma kokore amú timeno ma sinti mae iyavan ná dauman aminte fono. ");
INSERT INTO agd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tireti namu vanta kéká báke ompo sireti akhafana ma kama yaná amin ma afová ukhante mae mai Kantá Aunan nan ma inantinona kékái inaru fáké Afóe ano moéken aminten mino.” ");
INSERT INTO agd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mana vantafin namu aunan báken béin oorá iyádan ída vaya sin baré ein Yisasi ano mai namu aunan do siantan orivin mai vanta ano vaya siyákan banasi ano anúden oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Máan tiyákan manáa kéká ano semí, “Béi namu aunani ánon banta Beseburini ákonarái namu aunan do siantiyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Máa síkan manáa vanta ano inaru fáke aní daná aní ino van Yisasin akhenókaen mino. ");
INSERT INTO agd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Máa siyákan Yisasi vetíi ineine fefá afová iyáken máa sen tiamemí, “Mana vantai yafisin aúpin ma aúban daiminten maen mai avúavá ano kákan uman maman dákó intin inka mana namunté ma aúban daimintin maen mai namun mákúken eravinten mino. ");
INSERT INTO agd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Máan tinten mifo Ban Anon mano ma veyan daimintin maen inté ená beni yafisin ákonaen mantanten nafino. Para vara séi máa siya rauno. Tiretí ankan mano siyáke Beseburini ákonarái namu aunan do siantiyan minon tiyan ná uno. ");
INSERT INTO agd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tare ma namu aunani ánon banta avíká ma séi namu aunan do siantiyáku mae mai siretíi ánain ma yakhafin nain kayo ano iyen avíkasá namu aunan kayo yo siantanten nafino. Mai kayo ano vá tiretíi avúavá daimino. ");
INSERT INTO agd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Máan tinten mifo Tiyarafenui ákonafó ma namu aunan do siantiyáku maen Tiyarafenui yafisin ákona ano inka sirétimpin erikhen mino. ");
INSERT INTO agd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mana ákona vanta ano ma aruvin danasinta utaaren ma ve amáká dafíkantin maen ben nina yanasinta kamaen banten mino. ");
INSERT INTO agd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Banten mifo mana veni ákona esantakhan nain banta ano ma eriven mai vanta vá aruvúden ma véin aruren maen mi veni aruvin danasinta vá ona vá máden béi ma anunu iyain kékái yaiman aminten mino. ");
INSERT INTO agd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Éi iye anó téin má ída vante fono mai éi senti namuro ono. Inka éi iye anó téin ída siyaé banasi avían átaru inte fono mai éi anon banasi intan ne sin orera inten mino. ");
INSERT INTO agd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Mana vanta ma namu aunan mano me ampiren kámá barafá oren maen bei avíkan baru van dosen orin ma avíkan baru ma ída van máa sé iyan mino, ‘Evaráné mai ma me ampiré ereruna namun oronté uno.’ ");
INSERT INTO agd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Máa siren o onákan mai namun bakhari uren puntaádan baren mino. ");
INSERT INTO agd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Bantin ma ódaren maen béi evaránen oren dan manápá ifo afápá kan un kádan namu aunan kayo vetíi namu avúavá ano veni namu avúavá esantakhein kayo o avían morantin mai namumpin o vanten mino. Pefá mai vanta ano namu ukharen mifo saréa véi moéken namu uron inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mai vaya Yisasi siyákan banasi aúbanáké mana nanin mano oovaren temí, “Éin ma kaúden nan amein nanin mano vá amusin ino.” ");
INSERT INTO agd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Máa síkan béi evaránen temí, “Tiyarafenui vaya ma iniren oo yaiyen bákuriyain kéká ano vá amusin ino.” ");
INSERT INTO agd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Máa siyákan banasi e átaru en kokhoní iyain má Yisasi máa sen betin tiamemí, “Tare má damú ma vain nanin banta mai namu nanin banta ino. Enará ukhein avúavá aní intí onano van ina inten mifo vetí ankan ída kanaíen mana aní daná onanten mino. Mana sakhanampa vanta Yonani aní daná anan betí onanten mino. ");
INSERT INTO agd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Máan tukhein nan mi Yona maen Ninivé nanin bantai aní danasí ukháintin pasen Banta Anin mano yere sare ma vain nanin bantai aní danasí inten mino. ");
INSERT INTO agd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Saotíkena Kuini ano vanasii yaimin damú ma yákó intin maen e mantaven má damú ma vain nanin bantai avúavá daíden uman aminten mino. Para vara seyo, mai kuini maen bara akhen páké Soromonini kama afova vaya ineno siren eriven inein mifo saréa Soromonin esantakhein mano e van mino. ");
INSERT INTO agd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninivé nanin banta ano orun mantaven maen má damú kena nanin bantai avúavá daíden uman aminten mino. Para vara seyo, Yona ano ma monó baya vetí ankan tiamin maen mai kéká ano ará baeren mifo saréa mana Yonan esantakhein mi eren mino. ");
INSERT INTO agd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ída mana vanta ano yaamu uruan aúpa safi kavefin nafi kaé iyan mifo yan takhókái kain báken panu sen kakhiyan mi maifin ma ódiyain kayo ano kamaen oné iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Éin auu ma vain mai eni aufin ma kakhantan on mi van mifo en auu ma kama ukhan maen minó bukhafafin panu sikha vá ompo auu ma namu intin maen mai minó bukhafan títípa inten mino. ");
INSERT INTO agd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Máan tinten mifo éin aúpin ma vain kakhan mano sítípa inafo vá dafían ná ákona ono. ");
INSERT INTO agd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Máan tukhein nan mi eni minó bukhafa ma fanu sikhantin ma mana akhempá ída sítípa ukhantin maen mai fanu ano en aufá daamu ma kheiní inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yisasi ma vaya sian kíparan maen mana Farasisi vanta ano véin má mo yunan nano van ina íkan mai vanta amápin óden dunan kaúden nan takhóká un kumanen mino. ");
INSERT INTO agd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Un kumamen Yisasi ída ayan tesé inton dunan niyákan mai Farasisi ano kokhon ineine en mino. ");
INSERT INTO agd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kokhon ineine iyákan Bafan mano máa sen tiamemí, “Tiretí Farasisi kayo ano kápi vá disi vá dante anan teséiya ompo siretin aúpin ída avarí avúavá bá namu avúavá bái vikakhen mino. ");
INSERT INTO agd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tiretí óen kéka soe! Ídá mai ma yan bukhafa uvarein mano aú bukhafa vá uvanten nafino. ");
INSERT INTO agd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Máan tukhen mifo mai ma disifin bain danasá ona i van nanin banta amesin ná tiretíi minó danasinta avusese ukhen bano. ");
INSERT INTO agd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Tiretí Farasisi kayo ano vá dafiseno. Tiretí ankan tiyan míkampintan ma yaídeya Tiyarafenun mana masin man ma yunan ana fintena sító daná ma safofin ase amin dana kayo amiya ompo ída véin anunu iyáke namu avúavá anan bariya ompo kama avúavá banasi uantiya vá Tiyarafenu van anunu ono. ");
INSERT INTO agd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tiretí Farasisi kayo ano vá dafíseno. Tiretí esé an bain kará mádé monó átaru namun kayofin kumaneno van anunú iyákeya átaru varurá banasi ano kama uren amo sino van manan éiya ono. ");
INSERT INTO agd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Tiretí ankan dafíke vá bano. Para vara seyo, furin banta kayo ma aúpá barafin masí uran bákan banasi ano ída onanton ma mai yaró onóbe enóbe iyan ma Tiyarafenu avorá painí ein an mi yakharono.” ");
INSERT INTO agd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mana man baya ma afová ukhein banta ano mai vaya iníden Yisasin evaránen tiamemí, “Aru soe, éi ma mai vaya seona mai sétin má inan tinkayan te ono.” ");
INSERT INTO agd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Máa síkan Yisasi evaránen tiamemí, “Tiretí man baya ma afová ukheona vanta kéká basá dafiseno. Tiretí ankan ma afova amiyaona ano vanasi amaniná kákan uman amenan bariya ompo ída mana yáman kaureya ayaiya ono. ");
INSERT INTO agd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Tiretí ankan dafiseno. Tiretin anafu yan mano sakhanampa vanta kéká arin púkaréiyai mai masí kayoi siretí úádiya ono. ");
INSERT INTO agd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pefá ma siretin anafu aráo ano ma varein danái sare siretin avúavá ano aní iyan mifo mai kéká ano sakhanampa vanta kayo aruan púdákái siretí ano mai kayoi masíi kama iya va ono. ");
INSERT INTO agd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mai van mi Tiyarafenu ano vei inimpin tiyáken, ‘Téi sakhanampa vanta kayo vá baya varen orin banta kéká bá tiantékun betí baípá orintin maen manáa kéká aruan puriyáken inká manáa kéká para uman aminten mino.’ ");
INSERT INTO agd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mai anarái ma vara ma araíen uvarein táké ma furen eriyan baré ein sakhanampa vanta kayoi nare miyan ná tare ma vaona nanin banta ano vá barano. ");
INSERT INTO agd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Eborin táké araí uren eriyan maen íkun uan amin takhó bá monó namun aúbaná ma Sekaraiyan eman aruan purein mai kékái nare miyan tare ma vaona nanin banta amaninái afoká intéíi séi siretin tiamiyá uno. ");
INSERT INTO agd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Tireti man baya ma afová ukheona vanta kéká ano yafíke vá bano. Mai aasá ma ódiyain kayoi aa iyariya vákeya veti ma kamaen afová uren ódono van iyain do maman karúdiya va ompo siretiyantá ída mai aasá ódikha ono.” ");
INSERT INTO agd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Máa siren Yisasi mairá me ampiren oriyákan Farasisi kayo vá man baya ma afová ukhein kéká bá ano véin nan aran nan uren ara ara yana san ina iyan Yisasin máká dantin béi intéa vayá tintirá béin pákante rafuno siren dafían ákonaen mino. ");
INSERT INTO agd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Máan tiyákan kokhon tauseni nanin banta e átaru en baru víkaaren makaká uven arantan dasamin maran en mino. Máan tiyákan Yisasi vei eyo iyampon kayo nare máa sen tiamemí, “Tiretí ankan Farasisi kayoi yisi vará dafían ná ákona ono. Beti ma kampun tiren ma mai vaya ánain ma ída yakhafiyain nan mi siyá uno. ");
INSERT INTO agd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Máan tukhantin inte yanasá aúpá dará dantin baré inten nafi mai Tiyarafenu ano maman dákó intin maen inká minó aúpá baya vanasi ano kanaíen afova inten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Máan tukhen mifo minó baya ma siretí ankan dunteimpin ma siyaré esin maen mai vaya minó nanin banta ano karái ininten mino. Minó baya ma siretí ankan ma aúpá mápin ma kafaya sikharé esin maen mai vaya má amon táké oovaren banasi siaminten mino.” ");
INSERT INTO agd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Máa siren Yisasi evaránen tiamemí, “Te sirona kéka soe, séi siretin tiamé uno. Tiretí ída vá dan bukhafa máa ma aruan puré iyain kéka san perano. Ínaimpáké beti ída evaránen kanaíen mana yanasí inten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Máan tukhen mifo iyen nará perante fono mai séi siretin tiamenté uno. Tiyarafenu vará tiretí ankan perano. Tiyarafenu ano ma vanta aruan púden maen béimpin ákona vákan uman baren berai siyan purin barufin karúdanti aravin nompo vá Tiyarafenu van mana vá perano. ");
INSERT INTO agd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tuenti toya máafó ma yan manápá nun arará máa ma miyaní é iyain tiretí afová ukha ono. Mai nun arará kayo fintena Tiyarafenu ano ída mana áuné iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Máan tukhan mi Tiyarafenu ano siretin ánon do minó dan káan kíparen tiretí ankan minó afova suron ukhen mino. Máan tukhen mifo siretí ankan manon kokhon nun arará kayo esantare kákaní ukha ono. ");
INSERT INTO agd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Máa siren Yisasi evaránen temí, “Téi siretí ankan tiamé uno. Mana nanin banta ano ma sen nan beni kékápin bá uno ma sintin maen mai Banta Anin má ano yeren Tiyarafenui enisori kayo avorá bá tiamen ma véi senti kékápin bain nanin banta ino sinten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Máa sinten mifo mana vanta ano ma se nan beni kéká pinte vanta séi ída vá uno ma sintí maé ten má deren Tiyarafenui enisori kéká avorá béi nan ída sentina ino senté uno. ");
INSERT INTO agd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Inká banasi ano ma Banta Anin nan ma oyampá baya sinteya mai ume Tiyarafenu ano ampiantanten mifo Kantá Aunan ma oyampá baya sinteya mai ume Tiyarafenu ano ída kanaíen ampiantanten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Máan tinten mifo vetí ankan ma siretin aviren monó átaru namun kayofin ná orinten nafi áa kamanin kayo vá aví bain banta kéká bá avora safi ma aviren orintiya inte vayá anona evaráné tente rafuno. Máa sireya ída vá perano. ");
INSERT INTO agd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Maí áaurá anan Kantá Aunan manon mai ma vetin evaráne siaminona vaya siretí ankan afova aminten mino.” ");
INSERT INTO agd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Máa siyákan mai nanin banta áubanáké mana vanta ano máa sen Yisasin tiamemí, “Aru soe, se siváen tiamesin ná berasan tifóe ma furiyáken me kaútintein danasinta aúban daíden ná timino.” ");
INSERT INTO agd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Máa síkan Yisasi evaránen mai vanta máa inaemí, “Iye ano séi nan tire anavasani ona van daíde vá masiman uan ameno siren ná mai yoran timikhen nafino.” ");
INSERT INTO agd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Máa siren béi vanasi siamemí, “Tiretí ankan kokhon daná kaúdakeya ena vá moéke varano van inampo mai minó eina yanasintará ída kanaíeya aunan bara nompo yafíaná ákona ono.” ");
INSERT INTO agd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Máa siren béi ena vaya vetin tian baéan amemí, “Mana moní bantai yunan anafin kokhon ná dunan aran intaren mino. ");
INSERT INTO agd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Máan tukhan mai vanta ano veyan ovaren me ineine emí, ‘Tesi yunan ma kaonuna namun ída kanaí ukhen mifo séi intesá onte rafuno.’ ");
INSERT INTO agd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Máa sen iniren mai vanta ano semí, ‘Téi máan tonté uno. Tesi yunan kain namun kayo minó barákuré evaráné kákan má kayo uvádé maifin tesi uviti aran má minó kama yanasinta vá átaru uan kaonté uno.’ ");
INSERT INTO agd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Máan ma uré maé teyan nan máan mi senté uno. Téi kokhon oranará ma van kama yanasinta inka kaeruna sivikiyá báké kákan dunan má non má niyáké timusin iyá banté uno.’ ");
INSERT INTO agd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Máa síkan maen Tiyarafenu ano véin tiamemí, ‘Éi óen banta oe. Sare inuran mana vá purono. Éi ma fúbesin maen iye anó éi ma o éke e éke uan átaru uádeona yanasinta varanten nafino.’ ");
INSERT INTO agd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Máa siren Yisasi semí, “Kokhon danasinta ma o éke e éke uan átaru iyan bain kékápin mi ma yaná afoká inten mifo Tiyarafenu avorá betí ankan ída ona vain kéká an mi yakhen mino.” ");
INSERT INTO agd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Máa siren Yisasi vei eyo iyampon kayo máa sen tiamemí, “Máan tukhen nái séi siretin tiamé uno. Tiretíi van nan ída vá kokhon ineine ureya máa seno, ‘Tetí ankan náinasá nante rafuno.’ Inká tiretí ankan ída vá tiretí au van kokhon ineine ureya vá máa seno, ‘Tetí nái suí danasá uré bá tifante rafuno.’ ");
INSERT INTO agd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ayun ma fara van aunan mano yunan esantakhan maen inká au ano auí daná esantakhen mino. ");
INSERT INTO agd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tiretí ankan kame kayo vá onano. Betíi yunan ma yóden duyáden ma má uváden kain ída van mifo Tiyarafenu anon betin dunan amé iyan mino. Tireti vanasi ano Tiyarafenu avorá nun kayo esantakha ono. ");
INSERT INTO agd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Máan tukhen mifo ayáká bantó uno sire ma kokhon ineine iya vanteya mae kanaíená mai inin mano eni van asotú uantante nafino. Ída uron mino. ");
INSERT INTO agd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Máan tukhanti siretí ankan ma ída kanaíeya sító daná ma varanteya faraé tireyá ena kokhon danasinta van ineine iyá ba fono. ");
INSERT INTO agd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Paravan ma ampantein ná kamaeya vá onano. Betíi yavaráe ída uvaré iyan mifo séi sirétin tiamé uno. Kin Soromonini kama auí daná ano mana faravan má ída manaí ukhen mino. ");
INSERT INTO agd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Titó mumunan bain nanin banta oe! Afova sá ono. Taréa varé intin inuran tíkaren ira saran nain káta ma Tiyarafenu ano auí uantiyantiya mai káta kayo esantaren mi siretin auí daná aminten mifo ");
INSERT INTO agd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","siretí ankan ída vá nái yunan ná nante rafu nái non ná nante rafu sireya kokhon ineine iya vá bano. ");
INSERT INTO agd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ída ma mumunan in nanin banta ano kokhon ineine iyáken mai yansinta van dosé iyan mifo siretíi Afóe ano inaru fákei mai yanasinta van mi iyaono sen pefái afová ukhen mino. ");
INSERT INTO agd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Máan tukhen mifo veni yafisin baru van ma yosesin maen minó dana san ma iyaona aminten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Máan tinten mifo sanáa sipisipi ma vaona ano ída vá perano. Tiretí Afóe ma inarufá bain mano amusin iyáken inaru yafisin tiretin ameno van tikhen mino. ");
INSERT INTO agd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Áesin ná ena kayo ano en nina yanasinta miyaní uaranti vá mai moní ona ma ída van bain kékasá ameno. Máan ma inteya moní ma kain unan ída ainen dáke iyain mi siretiyantá uvaran nono. Ída manáa yaná afeyorantin umoyan banta ano ída varantin minó daná ída antan danú nan baru inarufasá tiretí ina yanasinta ka ono. ");
INSERT INTO agd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Máan tukhen mifo siretíi kama yanasinta ma kaesin ban nain barufin mi siretíi kákan inin banten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Máa siren Yisasi evaránen temí, “Tiretí ankan Tiyarafenui yoraríin ona ureya siretíi oon áesin para kiyan bantiya utaare vá bano. ");
INSERT INTO agd_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kákan banta ano ma anasií in omápin orikhan ma ereno van iyákan ma vei yoran banta kéká ano ma véi ma onará me ankamintí ainé ona yiantano van ave einisá tiretí ankan ono. ");
INSERT INTO agd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ída auun baranton ma auu sapé ukharé intin ma kákan banta ano ma eren ma e onan nain doran banta kéká ano vá amusin ino. Kákan banta ano veyantái yunan kuvin ona uren betin tintin dunan nan takhóká kumanintin maen dunan kuan aminten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Máan tinten mifo yo kakhano siren ma araí in kókore ma asiyain áaurá ma kákan mano eriyaren e onantin ma yoran banta kayo ano ma ída auun baran para varé inten amusin ná ino. ");
INSERT INTO agd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Máan tukhein nará tiretí ankan ma yanasá afová ono. Umoyan banta ano ma erin nain áau ma má afóe ano afová uren maen ída ifá intin mai umoyan banta ano ven amá me varákuren un peranten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Banta Anin nan ída erinten mino se siretí ankan ininona yamúi véi erinten mifo sireti utaare vá bano.” ");
INSERT INTO agd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Máa síkan Pita evaránen Yisasi inaemí, “Bafan noe, setin maná mai vaeran baya sisimiya fono áa minó basa fino.” ");
INSERT INTO agd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Máa sen ina íkan Bafan mano evaránen tiamemí, “Intéa yafisin banta anó kama ineine vákan ná bei yoran kamaen doriyaré inten nafino. Ayafa ano máan dafisin bantan tíkan bei yoran banta kayorá dafisiyáken dunan amin áauí ma íkan maen dunan masiman uan doran banta kayo amé iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Máan dorarí ma iyáin nain doran banta ma vei ayafa ano eren ma eman onan nain mano vá amusin ino. ");
INSERT INTO agd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Téi fura siré tiretí ankan tiamé uno. Ayafa vanta ano mai vantan tintin minó ben nina yanáká dafisinten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Máan tinten mifo mai yoran banta ano ma ve aúpin ovaren ineine iyáken ma sesi ayafa ída ainen erinten mino siren ma araíen be arona yoran nanin banta ma ankamiyáken dunan niyan non nen óen inten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Máan tiyaré intin ma maná damú mai yoran banta ano ída afová en útakharé inain áaurá ma vei ayafa vanta erinten maen mai yoran banta me aruren tíka síka uren ída ma mumunan in nanin banta vá mana varufin kainten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Inká mana yoran banta ano vei ayafa vantai anunu afová ukhen ma ída veni anunu ánain bákuriyáken ma ída utaaren baré intin maen mai yoran banta kokhon dádá ankaminten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Máan tinten mifo mana yoran banta ano ma ída vei ayafa vantai avúavá afová ukhen ma yafiyó ankamoren avúavá ukharé intin maen mai ayafa vanta ano manáa yádái ankaminten mino. Tiyarafenu ano ma kákan avu amikharé inain nanin banta vaípákena evaránen ena kéká ayain nan onanten mino. Tiyarafenu ano ma kákan ákona amikharé inain nanin banta vaípákena moéken ma yókaré inain ákona van evaránen ina inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Máa siren Yisasi evaránen temí, “Téi ma varará ira iniseno van mi ereruna mai ira ano ainen kano van mumpo ída kiyan mino. ");
INSERT INTO agd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Téi ma uman baré barafin aravonuna non peranté uno. Mai non téi ída fékékun tirá ano uman uron diyá uno. ");
INSERT INTO agd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Téi ma erikheruna van ma vara rákena minó aruvin kípaantano van mi erikhen minó teyá tiretí ankan iniya rafono. Ída ino. Téi siretí ankan tiamé uno. Banasi aúban daimono van mi séi erikhé uno. ");
INSERT INTO agd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Taréa ráké ma orin nain mai yan manápá antun mano ma mana namumpin baren maen mai antun mano yaíden kankanan mano manápá okhábintin kanú manaú ano enafá ekhábintin uven namuroí uantan maran inten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Máan ma intin maen be afóe ano ve anin namuroí uantantin be anin mano ve afóen namuroí uantantin inká be anóe ano ve araun namuroí uantantin be araun mano ve anóen namuroí uantantin anasi anafú ano ve anafú namuroí uantantin be anafú ano anasi anafú namuroí uantanten mino.” ");
INSERT INTO agd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Máa siren Yisasi kokhon nanin banta máa sen tiamemí, “Áau orun perápá ma konan édavíka mae ainen á danten mino sen nan maen á dé iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Inká tiretí ankan onen nan ma sautíké ákona uva ma eríka maeya kákan á kanten mino ma sen nan maen kákantá á ké iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tireti kampun baya sire ída mai ánain dakhafin nanin banta ono. Minan ayontá bá barará bá ma afoká iyain danasintai ana yaíden afová éiya ompo nái vará taréa ma afoká iyain danasinta ana ma yaimin avúavá tireti ída afová ukhera fono. ");
INSERT INTO agd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Pará puntákein avúavá tiretiyan ída yaídeya afova variya fono. ");
INSERT INTO agd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mana vanta ano ma éin kó tiantano van ma oriyanti vá ben má aayanafasá aine vaya sire siná ará kusintin ná ará manafiní inaifo éi ma ída máan tesin maen éin aviren mo kó banta ayampin kaintin kó banta ano firipo ayampin kaintin piripo ano avían mo karavusi namumpin kainten mino. ");
INSERT INTO agd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Téi fura siré éin tiamé uno, éi ída karavusi namun pinte aineya erin nompo éin ma miyan aví tiantákaré inain miyan ma sipá karúdaan kípa nona yamúi erin nono.” ");
INSERT INTO agd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yisasi vei vaya sian kíparan Karirifá ma manáa vanta kayo ano Tiyarafenu íkun uan amiyáin ma Pairoti ano ma vei aruvin banta kéká tiantan ma Kariri vanta kéká ma mo arein mai kayoi nare vá Tiyarafenu ma íkun uan amin tafúnai nare vá ma manafin ópé ein baya mai kéká pinté evaránen Yisasin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Máa síkan Yisasi evaránen betí ankan tiamemí, “Mai Karirí nanin banta kayo ano ma mai uman barein nan tiretí ankan ma iniyaona vetí ano ena Karirí nanin banta esantaren moéken umeíin kéká inó tiya rafono. ");
INSERT INTO agd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ída uron mino. Tiretí ankan ma ída ará baeranteya sirétin má deren mai uman bare furin nono. ");
INSERT INTO agd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siroamí ma ayá ayá namun baré ein mano ma varákuáken eitini (18) vanta yararan ma furein nan ma siretí iniyaona anó Yerusaremí ma vain nanin banta ano ma namu avúavá bariyain esantaren ná bariyaren nafino. ");
INSERT INTO agd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ída uron mino. Tiretí ankan ma ída ará baeranteya siretin má deren mai uman bare furin nono.” ");
INSERT INTO agd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Máa siren béi mana ovaeran baya siamemí, “Mana vanta ano vei uvaini yunan barafin mana fiki yaa ana yódan baré íkan mai vanta ano aran intein onano van oriyan baren o onákan ída mana aran intaren mino. ");
INSERT INTO agd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Máan tukheimpin mai yunan anará ma yafíkein doran banta véi máa sen tiamemí, ‘Kanú manaú oranarái ma fiki yaa ana séi o oné erékun béi fasavifái váken bara anu variyan ban ída mana aran iriyan mifo síkaan karúdano.’ ");
INSERT INTO agd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Máa síkan mai yoran banta ano véin evaránen tiamemí, ‘Kákan banta oe, mana oanará bá áesin para vantí mai anafin kanan ariyá kao ara kaúan onano. ");
INSERT INTO agd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Máan tékun ma ena oranafin ma aran iranten mai kama inten mifo ída ma aran iranti mae síkaan karúdan nono.’” ");
INSERT INTO agd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mana Sabati yamú Yisasi mana monó átaru namumpin banasi monó baya siamiyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tiamiyákan eitini (18) oranará mana namu aunan mano fákaan ákona uran bain nanin má dere maifin baren mino. Bákan mai namu aunan mano véin ayorun punkantan ída kanaíen béi funtáden mantiyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Máan tiyá íkan Yisasi véin óden aran eríkan máa sen tiamemí, “Éini aí inka séi kípaanté uno.” ");
INSERT INTO agd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Máa siren be ayan kain orin mai nanin ayorun aruviyain má ainen puntáben orun mantaaren Tiyarafenu aví daníen mino. ");
INSERT INTO agd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Máan tíkan monó átaru namuntá ma ánoní ukhein banta ano Yisasi ma Sabati yamú ayofiyain nan aranan uren máa sen banasi siamemí, “Dan manápá ifo afápá mana un kádan damúi yoran damú ban mifo maí damú kayofin ná eresin ayofana ifo ída vá Sabati yamú ereno.” ");
INSERT INTO agd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Máa síkan Bafan mano evaránen béin tiamemí, “Tireti kampun baya sire ída mai ánain dakhafin nanin banta ono. Tiretíi vaya vá avúavá bá ano ída manaí ukhen mino. Sabati yamú tiréti ídá kao vá donkin mái má ona yiantádeyá non nano van anan utúantádeyá avire oréiya rafono. ");
INSERT INTO agd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ma nanin maen Abaraamun araun mi Ban Anon mano eitini (18) oranará pákaádan baren mifo mai ma véin pákaádan baré ein daná ma yo varantó iyaruna mai ídá Sabati yamú barante rafuno.” ");
INSERT INTO agd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Máa síkan beni namuro kayo ano ayavevan en mifo vanasi ano mai ma kama yanasinta ma véi varein nan amusin en mino. ");
INSERT INTO agd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Máa siren Yisasi evaránen inaemí, “Tiyarafenui yafisin baru ano intéa yaná aná dakhen nafino. Intéa yanákasá tian baerante rafuno. ");
INSERT INTO agd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mai ano mana Mastati yaa aran ma ein an dakhan mi mana vanta ano varen bei yunan barafin mo yódákaréin mai ano e ampamaren kákan daaí uvíkan ayompin ma noin nun kayo ano mai yaa ayan kayorá mo nan uvaren mino.” ");
INSERT INTO agd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Máa siren Yisasi evaránen inaemí, “Téi intéa yanákasá Tiyarafenui yafisin baru sian baéádante rafuno. ");
INSERT INTO agd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mai ano yisi ma ein an dakhan mi mana nanin mano ma máden kokhon paravá bá manafin opé uren ma upí uran maen mai ano mai faravápin oreraen pameiníi ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Máa siren Yisasi Yerusaremí aayana oriyáken mai akhempá ma sító baru vá kákan baru kayo vá ma vain pimpá e monó baya siamen oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","E siamen oriyákan manáa kéká ano véin máa sen inaemí, “Bafan noe, manáa nanin banta aná Tiyarafenu ano evaránen aviranten nafino.” Máa síkan béi evaránen betin tiamemí, ");
INSERT INTO agd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ayampa máareya vá tító onafin ódono. Kokhon mano ódono van iyái séi sirétin tiamiyá umpo vetí ída kanaíen ódinten mino. ");
INSERT INTO agd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Maná damusí ma intin má afóe ano e mantaaren má ona ma munkurantiya siretí ankan barufá e mantaveya verai siyáke onará ankamesin maen béi evaránen tiretin máa sen tiaminten mino, ‘Tiréti inte fákesá eriya vae. Mai séi ída siretin afová ukhé uno.’ ");
INSERT INTO agd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Máa ma sintiya siretí ankan evaráne véin máa se siamin nono, ‘Tetí ankan éin má manafin dunan má non má niyákuya setisi aasá éi oriveya monó baya sisimiya ono.’ ");
INSERT INTO agd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Máa sesin maen béi evaránen tinten mino, ‘Tiretí inte fákena kékasá ere vae. Mai séi ída afová ukhé umpo siretí namu avúavá baran kéká ompo minó ano sifó ono.’ ");
INSERT INTO agd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Máa ma siren tirétin tiantantiya mai ma uman baren berai sin barufin orun bákeya Tiyarafenui yafisin barufin onesin maen Abaraamun má Aisakin má Yekopun má minó sakhanampa vanta kayo vá ma maifin bantiya siretí ankan kákan ífí diyákeya aveantuntá inkekípa nono. ");
INSERT INTO agd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Máan ma iyasin maen ma varai áau e uní pákena vá áau orun perá pákena vá saotíke vá notíke nanin banta ano ere ere uven maen Tiyarafenui yafisin barufin ma vain omápin e varu varen kumamen mai yunan nanten mino. ");
INSERT INTO agd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Máan tukhein nan mi saréa ma ínainí ukhein kéká ano un aní intin maen aní ma ukháin nain kéká ano evaránen ínainí inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Maí damú ana manáa Farasisi kéká ano Yisasi vaintá eriven béin máa sen tiamemí, “Eroti ano éin arono van iyan mifo éi ma varu me ampireya ena akhempá orono.” ");
INSERT INTO agd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Máa síkan Yisasi evaránen betin tiamemí, “Tiretí ankan oreya mai afá iyan mo máa sevá tiameno, ‘Taréa vá inuran má téi namu aunan kayo yo siantiyáké maé aí nanin banta kéká ayofanté umpo kanú manaú damusí ma intíi sesi yoran kípanté uno.’ ");
INSERT INTO agd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Máan tontéi saréa vá inuran má ídamú bá téi fara oronté uno. Mai fara vara seyo, sakhanampa vanta ano ída Yerusaremí ankinafá o furinte mifo véi Yerusaremí anan purinten mino. ");
INSERT INTO agd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusaremi oe, Yerusaremi oe, éi ano sakhanampa vanta kayo arureya Tiyarafenu ano ma éi vaípá tiantein banta kéká onámaná ankádeya iyan ná náimáa yádasá téi enan tirun nan urerá en akhafana o éke e éke uan anasi kókore ano ma ve ayampin deiní iyáku ompo siretí ída anunu iya ono. ");
INSERT INTO agd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Onano. Tiretí ankani varu saréa ída yafisé toyan amirékun namu ukhen para vanten mino. Téin ída evaráne son nan bareya máa sin nono, ‘Bafan avíká ma eriyain banta vá Tiyarafenu ano avu ino.’” ");
INSERT INTO agd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mana Sabati yamú Yisasi ano mana Farasisi kayoi ánon banta amá mo yunan niyákan betí ankan mano véintá dafían ákonaen mino. ");
INSERT INTO agd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Máan tiyákan mana au famin aí bain banta ano maifin béin ádé baren mino. ");
INSERT INTO agd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Bákan Yisasi máa sen Farasisi kéká bá man baya ma afová ukhein kayo vá inaemí, “Sabati yamú kaná aí nanin banta ayofanten nafino áa ída fino.” ");
INSERT INTO agd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Máa síkan betí ankan púkekhaven ída mana vaya siamiyaimpin Yisasi mai vanta au fákaren beni aí kípaantáden tiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Orivíkan béi máa sen betí ankan inaemí, “Tiretí ankan pinté mana ano ma mana ain iyampon nafi burumákao fi ma yaká esin Sabati yamú ma non bain masípin ma áduvintiya éi ída aineya orun darifaádan akhempá édanten nafino.” ");
INSERT INTO agd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Máa sen ina íkan betí ankan ída mana vaya sen mino. ");
INSERT INTO agd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Máan tiyákan mai omápin ma erikharé ein kayo onákan dunan nan takhói an karáká ana kumaniyaimpin béi máa sen betin ma vaya ovaéden tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mana vanta ano ma anasi iran omápin ma éin arantiya ma orinte ída vá esé karáká o khumaneno. Éin esantakhein banta vá deren arakhanten mino. ");
INSERT INTO agd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Máan tukhá esin maen tirekánan ma arein banta ano ma ínaimpáké erintin ei kará ma vanta ameno sintiya éi kákan ayave van iyáke ínaintena karáká o khumanin nono. ");
INSERT INTO agd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Máan tinafo vá omáká ma aranti orikhe mae oyampá ma vain karakasá o khumantá esin ná mai omá afóe ano ma onanten maen ‘tirona oe, manteya an bain karáká un kumaneno’ sinti ma un kuman esin maifin ma varé inain kéká ano ma onanti vá kákan bí barano. ");
INSERT INTO agd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Baran nompo ve aví ma maman daní inain kéká Tiyarafenu ano maman bararasí inte mifo ve aví ma maman bararasí in nain kéká Tiyarafenun ano kákan bí aminten mino.” ");
INSERT INTO agd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Máa siren dunan me nano van ma ven arein banta máa sen tiamemí, “Éi ma mana omasí iyákeya éi ída vá e arona fi e afá aváe fi e anóe afóeni kéka safi e ádé ma moní nanin banta vain nafi arano. Éi ma arakharé esin maen éin e araan betí ankani omápin kaúden anona evaránen dunan aminten mino. ");
INSERT INTO agd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Máan tinten mifo éi ma kákan omasí ma inte vá minó daná ma ída van nanin banta vá au ma namu ukhein kayo vá arantan ma namu ukhein kayo vá auu yufúkukhein kayo vá ana vá arakháesin ");
INSERT INTO agd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ma éin ída evaránen amintiya vá éi amusin ná ono ínaimpá ma funtákein nanin banta ma orun mantan nain damúi Tiyarafenu ano éin evaránen amusin aminten mino.” ");
INSERT INTO agd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Máa síkan mai ma véin má dunan niyaré ein kayo finté mana vanta ano mai vaya iniren máa sen Yisasin tiamemí, “Tiyarafenui yafisin barufin ma omasí inaimpin ma o khumamen dunan nan nain nanin banta ano vá amusin ino.” ");
INSERT INTO agd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Máa síkan Yisasi evaránen béin tiamemí, “Mana vanta ano kákan dunan taranton iyáken mai omápin kokhon nanin bantan aren mino. ");
INSERT INTO agd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Arakharen mai ma kákan dunan taran damusíin pefá ma arakhá ein nanin banta van inka minó dunan taman úbefaráken ariyan ne sen tiamino van mai vanta ano vei yoran banta siantan oren mino. ");
INSERT INTO agd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Oríkan minó nanin banta ano ída ino ana sen orera en mino. Máa siyákan mana vanta ano máa sen tiamemí, ‘Téi saréa anan mana yunan ana miyaní uádákéi mai o onantó umpo sirun noe, séi ída oronté uno.’ ");
INSERT INTO agd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Síkan inká ena ano máa semí, ‘Téi saréan tiyan míkan doran burumákao kéká miyaní uakéi mai kéká mo yóan onano van oriyá umpo sirun noe, séi ída oronté uno.’ ");
INSERT INTO agd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Síkan inká ena vá ano máa sen tiamemí, ‘Taréa uron mi anasi iman timikhein téi ída oronté uno.’ ");
INSERT INTO agd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Máa síkan mai yoran banta ano evaránen bei kákan banta vaintá oriven mai ma vetí ankan téin baya kayo véin tiamíkan kákan aranan uren bei yoran banta máa sen duvun emí, ‘Éi aineya kákan barui kákan aasá bá tító aasá bá oriveya minó daná ma ída vain nanin banta vá arantan ma namu ukhein kéká bá auu ma yufúkukhein kayo vá au ma namu ukhein kéká bá avire vá ereno.’ ");
INSERT INTO agd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Máa síkan mai yoran banta ano mai ma seiní uren béi evaránen bei kákan banta vaintá oriven béin máa sen tiamemí, ‘Kákan banta oe, mai ma éi seonaí urékun má naumpin manáa afokhan para van mino.’ ");
INSERT INTO agd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Síkan kákan banta ano evaránen bei yoran banta siamemí, ‘Ten timápin bíkano van mi séi sununuiyá umpo éi kákan baru me ampireya minó kákan aa kayo vá dunan anafimpá bá oriveya éi ma onanona nanin banta siamesin ten timápin erino. ");
INSERT INTO agd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Téi siretí ankan tiamiyá uno. Mai ma séi fefá ayusikhá eruna kayo finté mana nanin banta ano ída kanaíen tenti omá pinte yunan me nanten mino.’” ");
INSERT INTO agd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kokhon nanin banta ano Yisasin má oriyá íkan béi yovaéaren betin máa sen tiamemí, ");
INSERT INTO agd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Téi vaípá ma ereno van inona ano ma e anóe afóen má e aná akhafana vá e afá aváen má ayofin má ei vampin má ma namuroí iyanona ano ída kanaíeya senti eyo iyamponí in nono. ");
INSERT INTO agd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Inká ei yaa unkamádan ma ída mamareya ma séin tínain ma vákurin nona ano ída kanaíeya senti eyo iyamponí in nono. ");
INSERT INTO agd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Tiretí ankan pinté mana ano ma kákan ayá namun ma uvarano van inten maen ná esé béi ídá kumanten ná bei moní kaná bain ná mai namun uvaman kípanté rafuno siren ná daíden afová inten nafino. ");
INSERT INTO agd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mai fara vara seyo mai vanta ano ma ída mai yanasinta átaruin ma varu avantaren simeni upí uren kaen orera uren ma namádan daféden ma mai namun ída uvaman kípan me ifá urantin maen ena nanin banta ano ma oniyáken ída kama ineine vain banta ino siren oyampá baya sen ");
INSERT INTO agd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","máa sintemí, ‘Mai vanta ano má uvarano siren uvaman araí uren ída mai namun uvaman kípen mino.’ ");
INSERT INTO agd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Inká mana kin mano ma ena kin má mo aruvono siren maen ídá béi kumanten ná bei siyan míkan tauseni (10,000) aruvin banta ano kanaisá ená tuenti tauseni (20,000) aruvin banta ma namuro kin mano ma iyanen eriyain má aruvinten nafino siren ná daiminten nafino. ");
INSERT INTO agd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Daíden inintin ma ída kanaí ukhantin maen namuro kin ma nentá eriyantin mi vei yoran banta siantantin oren mi namuro kin mo ará kusin baya sen inainten mino. ");
INSERT INTO agd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Máan mana en mi mana ano ma ída ve ina yanasinta ma me ifá inten maen mai ano ída kanaíen tenti eyo iyamponí inten mino. ");
INSERT INTO agd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Un maen kama yana ifo veni ase ma kípavinti mae intesá uresin ná evaránen ase inten nafino. ");
INSERT INTO agd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mai un maen ída varafin mo kama inti inká ída kanaíeya vurumákao ara vá upí ure varafin kain nompo savifái maman karúdan nono. “Átaren ma van nain kayo ano vá ineno.” ");
INSERT INTO agd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takisi varan banta kayo vá ume nanin banta kéká bá ano Yisasini vaya ineno van béin ádé eiyen mino. ");
INSERT INTO agd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Máan tíkan Farasisi kayo vá man baya ma afova ukhein kéká bá ano mai van aranan uren máa semí, “Ma vanta ano ume nanin banta kayo anan aronaí iyáken betí ankan má anan dunan niyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Máa siyaimpin Yisasi ma vaya ovaéden tiamemí, ");
INSERT INTO agd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tiretí ankan pinté mana ano ma mana antareti (100) sipisipi kaúdakaré intin ma mai finté mana afeyóbintin maen ídá nainti naini (99) sipisipi me kaúden ná mai ma mana sipisipi afeyókein nan e yosen oriyan baren ná o onanten nafino. ");
INSERT INTO agd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","O óden maen béi kákan amusin iyáken mai sipisipi yauman be afuntá kaúden ");
INSERT INTO agd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","aviren barufá ma moren maen be arona kayo vá be amá ádé ma vain nanin banta kéká bá e araan manafin átaru uren maen betin máa sen tiaminten mino. ‘Mana sipisipi ma se sina afeyoká ein inka yosé umpo sen má eriveya amusin ítifero.’ ");
INSERT INTO agd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Téi fura siré tiretí ankan tiamiyá uno. Ma ma einí anan en mi nainti naini (99) funtákein nanin banta ano ída ará baeran nan ininten mifo ume nanin banta finté mana ano ma ará baerantin maen inarufá kákan amusin uron mi inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Mana nanin mano ma siyan míkan aintain moní kaintin baré intin ma mai fintena mana aintain ma afeyóbintin maen béi ídá daamu antúduren avové en bakhari uren ná dosiren mai aintain baranten nafino. ");
INSERT INTO agd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Béi yosiyan baren ma mai aintain moní dosiaren maen be arona kayo vá be amá ádé ma vain nanin banta kéká bá e araan manafin átaru uren maen betin máa sen tiaminten mino. ‘Tesi mana aintain moní ma afeyókaré ein inka yosé umpo sen má amusin ono.’ ");
INSERT INTO agd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Téi fura siré tiretí ankan tiamiyá uno. Ume nanin banta finté mana ano ma ará baerantin maen Tiyarafenui enisori kayo ano máan manan en mi kákan amusin inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Máa siren Yisasi evaránen temí, “Mana vanta ano kankanan ain iyampon kain baren mino. ");
INSERT INTO agd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kain baren ínainte iyampon mano ve afóen máa sen tiamemí, ‘Tifóe oe, minó daná ma séin masiman uantimeno van ma iyá eona yanasinta saréa ana séin timeno van muno,’ síkan be afóe ano vei minó daná míkanampin daimen mino. ");
INSERT INTO agd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Máan turan ínainte iyampon mano ída ayáká banton minó beina yanasinta mamaren mana nentá bain barafá o váken bei minó moní pa savi yanáká afe en mino. ");
INSERT INTO agd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kíparákan mai varafin kákan anan afoká íkan béimpin ída mana yaná baren mino. ");
INSERT INTO agd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ída vaimpin mai vara fintena vantafin mo yorano van ina íkan mai vanta ano vei fon kayorá dafisino van pon dafufin tiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","O vákan mana nanin banta ano ída véin mana yunan amiyaimpin arafan nan uaren pon kayo ano ma niyain basá aítan máden nano van iyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Máan tiyáken béi ovaren me ineine iyan máa semí, ‘Te sifóeni yoran banta kayo ano kokhon dunan ban niyákái séi mará kákan tirafan nan iyá bá uno.’ ");
INSERT INTO agd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Máan tiyá baruna saréa séi e manté te sifóe vaípá evaráné orivé maé béin máa sé tiamenté uno, ‘Tifóe oe, Tiyarafenu vá éin má umeí uanté uno.’ ");
INSERT INTO agd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Taréa séi ída kama ukhé umpo éi ída vá e anin ne seya séin tariyáke vá téin maman ná ei mana yoran banta aná dano.’ ");
INSERT INTO agd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Máa siren béi e manten be afóe vaípá oren mino. “Béi ma nentá eriyákan ma ve afóe ano véin oniyáken kákan arunan uren tavaen o yafayóden amónen mino. ");
INSERT INTO agd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Máan tíkan be anin mano véin máa sen tiamemí, ‘Tifóe oe, Tiyarafenu vá éin má umeí uanté uno. Taréa séi ída kama ukhé umpo éi ída vá e anin ne seya séin tarano.’ ");
INSERT INTO agd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Máa síkan be afóe ano vei yoran banta kayo araren máa sen tiamemí, ‘Tenti moéken kama ukhein ayá tu anamun aine o vare me uantiyákeya ayampin rini afu uante vá arantampin arantan anamun uante ono. ");
INSERT INTO agd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Uantáde mae inókein burumákao o vare me aruresí tádé niyáké timusin ó tifano. ");
INSERT INTO agd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mai fara vara seyo, se sanin mano furein an dakharen mi evaránen ma manteiníen mino. Béi afeyókaréí evaráné dosé tiféuno.’ Máa siren betí ankan araíen amusin en mino. ");
INSERT INTO agd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Máan tiyákan esékena iyampon mano yunan anafá doren noren má ádé eriven musikí avaya vá danisí ma iyain má inen mino. ");
INSERT INTO agd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Iniren mana yoran banta araren máa sen béin inaemí, ‘Mai náisá iyan natino.’ ");
INSERT INTO agd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Síkan mai yoran banta ano evaránen béin tiamemí, ‘E afá erikhan mi véi ma ovaránen ma kamaen erein nan mi e afóe ano mana inókein burumákao arurákan mi amusin iyan mantino.’ ");
INSERT INTO agd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Máa síkan esékena iyampon mano aranan uren maifin ída ódíkan be afóe ano ekhuven barufá eravuven ará kusin baya véin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Máa síkan béi evaránen be afóen tiamemí, ‘Onano. Ayá oranará téi eni yorarí para oé eriyá báké éi ma seona vaya kayo ída mana átakharé iyákuya mae éi ída mana memé arará timen ná te sirona kayo vá timusin iyaré uno.’ ");
INSERT INTO agd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Máan tiyareyá ma ma éin nina yanasinta ma aasá non nanin arintará ma mo asuse ein iyampon ma ovaránen mápin ereintái éi amusineya inókein burumákao are ono.’ ");
INSERT INTO agd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Máa síkan be afóe ano semí, ‘Tanin noe, minó damú éi sen má anan baonan ban mi minó daná ma sentina vain mai éin ninaíi ukhen mino. ");
INSERT INTO agd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Máan tukhen mifo saréa erisá tetí ankan timusin ékun ná tétin tirá ano kama ino. Mai fara vara seyo, e afá ano furein an dakharen mi evaránen ma manteiníen mino. Béi afeyokaréíi evaráné dosé tiféuno.’” ");
INSERT INTO agd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yisasi vei eyo iyampon kayo máa sen tiamemí, “Mana moní banta ano ve ina yanasintará dafisino van mana ayafa yan baré íkan manáa vanta kayo ano moní banta vaípá oriven mo máa sen tiamemí, ‘En nina yanáká má ayafaí ukhein banta ano en nina yanasinta máden tavifá asuse iyan mino.’ ");
INSERT INTO agd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Máa sen tiamirákan moní banta ano ve ina yanáká ma ayafaí ukhein banta aran eríkan máa sen inaemí, ‘Éi naísá iyanan ná ena kayo ano me sisimí iniya rafuno. Evaráne orive vá ten tina yanasinta ma fákakhe ona mai máa vompompin uvádeya vá bare me simeno. Éi ída evaráne sen tina yanasintará ayafaí inono.’ ");
INSERT INTO agd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Máa síkan mai ayafa vanta ano veyan nan máa semí, ‘Téi intesá onte rafuno. Tesi kákan banta ano yoran pintena séin do sisintiyan mino. Téimpin bara ápomin ákona ída van inká ena vaípá ma minó daná inantin nan tiyave iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Máan tiyá umpo sesi yoran ma kípanuna yamú ma vanasi ano ma séin e sivían betí amápin kain nain aafákena inka afová é uno.’ ");
INSERT INTO agd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Máa sen iniren mairá mana mana vanta ano ma vei kákan banta vaípá ma anona evaránen amin daná ma mantaré ein kéká arákan béi vaintá erivin mairá mana vanta nare ayafa vanta ano inaemí, ‘Éi nái máa yanasá tenti kákan banta vaípákena evaráne ameno siré manta fono.’ ");
INSERT INTO agd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Máa sen ina íkan mai vanta ano semí, ‘Uveri khave mana antareti (100) máa ino,’ síkan mairá mai ayafa ano siamemí, ‘Mai ma amiyáken ma amikhá ein bompon bare aine e khuman me mai vompompin fifti (50) khave máa ino sire uvarano.’ ");
INSERT INTO agd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ínaimpáké ena vanta inaemí, ‘Éi nái máa mantare fono,’ síkan ‘mana antareti (100) máan uviti unan mantaré uno,’ síkan mairá mai ayafa ano siamemí, ‘Mai uviti unan amiyáken ma amikhá ein bompon bare eriveya eiti (80) unan máa ino se uvarano.’ ");
INSERT INTO agd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Máan turan mai moní banta ano namu ayafa ano ma varein avúava san iniren amo sen mino. Para va ino véi kama ineine ma vain banta an mi yaran mino. Ma vara ráke avúavá ma yakhafiyain nanin banta ano ara ara aa fákéi vetíi yoran bariyan pasen mi kakhantá ma vain nanin banta esantakhen mino. ");
INSERT INTO agd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Máan tukhein nan mi sirétin tiamé uno. Ma varará ma yakeona yanasinta fosá ena nanin banta amiya mai kéká avían tiretí aronaí uraká esin ná mai yanasinta ma mo kípan nain damú amusin iyan ná Tiyarafenu ano siretin e avían ayun ma fara van oriyan ban barufin kaino. ");
INSERT INTO agd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Mana nanin banta ano ma sító danáká kamaen dafisinten maen mai véi kanaién kákan danáká bá dere yafisinten mino. Inká mana nanin banta ano ma sító danáká ma ída funtákein avúavá ma inten maen mai véi kákan danáká bá ída funtákein avúavá inten mino. ");
INSERT INTO agd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Máan tinten mifo siréti ma vara rákena namu moní ma ída kanaíe yafisinte mae mai iye anó pura yana suron amintiyá tiréti yafisinte fono. ");
INSERT INTO agd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mai van mi siréti ma ída kama e ma ena ina yanáká ma yafisinte mae mai iye anó tiretin nina yana se siren ná amintiya yafisinte fono. ");
INSERT INTO agd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mana yoran banta ano ída kanaíen kankanan dafisini aránaópá banten mino. Máan ma inten maen mana van anunu uren ena ará namu uanten maen inká mana avaya inen maen ena avaya oyan aminten mino. Éi ída kanaíe Tiyarafenu vá moní bái aránaópá ban nono.” ");
INSERT INTO agd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Máa síkan Farasisi kéká moni san ukhein kayon baren Yisasi ma sein baya iniren béin auná mun uanten mino. ");
INSERT INTO agd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Auná mun uantiyákan béi máa sen betin tiamemí, “Tiretí ankan nan ena vanta kayo ano funtákein avúavá ana varan banta kéká ino sen inino van in kayo ono. Máan tin kéká ompo Tiyarafenu ano siretí ankan aúpin má ineinefin má aúpá ma vain danasinta fe afová ukhen mino. Banasi ano ma kama uron ukhein daná ino ma sen iné iyain mai yaná ano Tiyarafenu avorá namu uron ukhen mino. ");
INSERT INTO agd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Man baya vá sakhanampa vanta kayoi vaya vá ano eriyan baren monó non péantan banta Yonini yamúi me kanaí uvíkan mai rákéi Tiyarafenui yafisin pintena kama vaya sian dákó iyákan kokhon mano maifin umperano van ákona iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Inaru vá bara vá tesosen o afeyoranten mifo Tiyarafenui man baya maen tító máa ída afeyoranten mino. ");
INSERT INTO agd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yisasi ena vaya máa sen tiamemí, “Mana vanta ano ma ve aná me ifá en ma ena nanin ma o varanten maen mai vanta ano famúku avúavái inten mino. Inká mana vanta ano ma ifá uantan nanin ma o varanten maen mai vanta vá ano famúku avúavái inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Máa siren Yisasi ena vaya máa sen tiamemí, “Pefá mana moní banta váken mai vanta ano kama uron ukhein nararé au anamun uren báken mai vanta ano kama yunan mana minó damú niyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Máan tiyákan mai moní banta amá onará mana ona ída van namon mana en paerí ukhein banta Rasarusin ne sin aviren mo asemádan báken ");
INSERT INTO agd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","mai moní bantai yunan nan takhokáké ma yunan antan karúdan ona ádé ma eravein nano van iyákan iyan kayo ano yere veni namon me arúniyan mino. ");
INSERT INTO agd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Máan tiyaren maná damú ona i van banta fúbíkan enisori kayo ano e aviren Abaraamun má mo kain bákan inká moní banta vá dere fúbin mo masíen mino. ");
INSERT INTO agd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Masí uran mai moní banta ano furin nanin bantai varufin aí bá beraifin má báken dan mun onan Abaraamu nenta suron bákan Rasarusi véin má baren mino. ");
INSERT INTO agd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bákan mai moní banta ano máa sen oovaremí, ‘Tifóe Abaraamu oe, éi sen nan arunan ureya Rasarusin tiantesin ná mana ayamú máa non daaren tima fintá me kaú dantin iyon usintano. Para vara seyo, kákan irafin mi vákun tufá ira siriyá uno.’ ");
INSERT INTO agd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Máa síkan Abaraamu evaránen béin tiamemí, ‘Tanin noe, ovare vá me ineno. Éi ma fa vákeya éi kama yanasinta variyan nan maen Rasarusi namu yanasinta mantaren mifo saréa ma varufin béi kamaen kusen bákaya inká éi aí bá beraifin má ba ono. ");
INSERT INTO agd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ba ompo ena yaná mai siretin má tetin má aúbaná mana kákan on ban mino. Máan tukhein nan mi ma ufá ma vain kéká ano mai ma vaona ufá orono van inten mifo vetí ída kanaíen orintin maen inká mai u fáké ída kanaíen ma ufá é dantin inten mino.’ ");
INSERT INTO agd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Máa síkan moní banta ano evaránen béin tiamemí, ‘Tifóe oe, máan ma ukhantiya éi kanaisá eyá Rasarusin tiantesin ná te sifóen amápin oriven ná ");
INSERT INTO agd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","béi ano se sifá tiváe ma yan manápá bain mo ákonaen tiamintin ná betíi avúavá maman puntáden ná ma ma sí bá beraifin má baruna varufin ída vá erino.’ ");
INSERT INTO agd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Máa síkan Abaraamu evaránen béin tiamemí, ‘Mosesin má sakhanampa vanta kayoi vaya vá betimpin ban mifo áesin ná mai ma sikhein baya vá inino.’ ");
INSERT INTO agd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Máa síkan mai moní banta ano máa semí, ‘Tifóe Abaraamu oe, mai ída kanaí inten mifo mana furin banta ano ma masí pinté e manten oren ma vetin mo siamintin ma iniren mai anan betí ará baeranten mino.’ ");
INSERT INTO agd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Máa síkan Abaraamu véin tiamemí, ‘Mosesin má sakhanampa vanta kayoi vaya vá ma ída ininti mae mai ifasá ono. Púkein banta ano yere ma masí pinté e manten betin ma mo siamintin maen mai vaya vá dere ída ininten mino.’” ");
INSERT INTO agd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yisasi vei eyo iyampon kayo máa sen tiamemí, “Ara ara yaná afoká intin banasi ano mai yanáká eraven ankamen umeí inten mifo mai yanasinta ma maman dákó inain nanin banta van mi sirunken mino. ");
INSERT INTO agd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Máan tiyaré intin mai vanta ano ma mamá dan nain danáká iyampon arará kayo finté mana ano umeí ukharé intin ínaimpáké béi moékan uman baran nafo véin amempin kákan konkamú onámaná ma kureya karúdesin un nompin aravintin maen mai ano anan kanaí inten mino. ");
INSERT INTO agd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Máan tinten mifo siretí aurasá dafiseno. Tirétin afá aváeyan mano ma umeí inti vá béin ákona e siamesin ná bei avúavá maman puntarano. Bei avúavá ma maman puntáden ma ará baeranti vá beni ume ampiantano.” ");
INSERT INTO agd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Béi ma yan manápá ifo afápá kan un kádan dádá ma mana vayában ma umeí uantáden ma inká dan manápá ifo afápá kan un kádan dádá ma véi ovaránen me sirun noe sé uno ma sinti vá beni ume ampiantano.” ");
INSERT INTO agd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Máa síkan baya varen orin banta kayo ano Bafan máa sen tiamemí, “Éi sétisi mumunan asotú usintesin mo kákaní ino.” ");
INSERT INTO agd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Máa síkan Bafan mano evaránen betin máa sen tiamemí, “Tiretíi mumunan mano ma mastati aran an den ma sító mumunan ma vanti mae kasae mana yaa ana van tiyáke arúbá e yare un nompin o ampan mono ma sesin maen eni vaya ininten mino.” ");
INSERT INTO agd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Máa siren Yisasi ena vaya máa sen tiamemí, “Tiretí ankan pinté mana ano ma ei yoran banta siantesin ma mo vará ápomiyá inten nafi sipisipira sá dafisiyaren ná erinten nafi mai kanaisá eyá ‘aine e khumame yunan nano’ sinte fono. ");
INSERT INTO agd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ída ino. Kákan banta ano vei yoran banta van máan mi sintemí, ‘Tenti yunan tamádareya ei kama auí daná ure vá dunan puntádesí ten nare naréku vá éi ínaimpasá nanon,’ tinten mino. ");
INSERT INTO agd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kákan banta ano kaná bei yoran banta ano ma véin oo yaiyein nan tusu siantanten nafino. Ída uron mino. ");
INSERT INTO agd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Máan tukhein nan mi síretí ankan ma Tiyarafenu ano amin nain doran ma oo yaiye yódanteya máan ná teno, ‘Téi ída kama yoran bantan bákéi sen ma simikhein doran mi yoré uno,’ vá teno. ");
INSERT INTO agd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yisasi Yerusaremí orono siren oriyaren Sameriá bara vá Karirí bara vái aifin oren mino. ");
INSERT INTO agd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Oriyaren mana varurá ma oriyain má tiyan míkan banta maen amon dana aí pákakhein kéká ano mai aasá Yisasin má e fóke náke uven nentá e mantaven ");
INSERT INTO agd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","avádóden oovaren temí, “Kákan banta Yisasi oe, setin nan arunan usintano.” ");
INSERT INTO agd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Máa síkan Yisasi vetí ankan oniyáken máa sen tiamemí, “Tiretí ore vá monó doran banta kékasá tireti au mo aní ono,” síkan betí ankan oriyákan mai amon dana aí ma varé ein kípen mino. ");
INSERT INTO agd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Betí ankan pinté mana vanta ano onákan be au kama iyaimpin béi ovaránen Yisasi vaípá eriyáken oovararen Tiyarafenu aví daníen mino. ");
INSERT INTO agd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mai vanta ano Yisasi vaintá onóben mo aron durafúden ben arantampin mátimen tusu sianten mino. Mai veí Sameriá banta ino. ");
INSERT INTO agd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tusu siantiyákan mai vanta Yisasi oniyan temí, “Tiyan míkan bantan ayofé uno seruna ifo yan manápá ifo afápá kamí kamí un kádan banta ano intesá uvi fono. ");
INSERT INTO agd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ídá ena vanta vá erin ná ma ena anan banta ano veyáká aná me Tiyarafenu aví daníen ná tusu siantiyan nafino.” ");
INSERT INTO agd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Máa siren Yisasi mai vanta siamemí, “Mante orono. Eni mumunan mano éin ayofen mino.” ");
INSERT INTO agd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Maná damú Farasisi kéká ano Yisasin máa sen inaemí, “Inte yamusá Tiyarafenui yafisin erinten nafino.” Síkan Yisasi evaránen betin tiamemí, “Tiyarafenui yafisin ma erin nain ída mana aní daná ma afoká einí intin banasi ano auu fóké onanten mino. ");
INSERT INTO agd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Máan tukhantin ída mana nanin banta ano siyáken ‘onano masi mafá bane’ áa ‘mesápá bane’ sinten mino. Para vara seyo, Tiyarafenui yafisin ákona fefái siretimpin ban mino.” ");
INSERT INTO agd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Máa siren Yisasi vei eyo iyampon kayo siamemí, “Ínaimpá ma yamú afoká inti mae Banta Anin onano van in nompo ída onan nono. ");
INSERT INTO agd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ída onan nompo vanta kéká ano siamiyan ma ‘orive onano mesápá bane’ áa ‘erive onano masi mafá bane’ sinten mifo ída vá mai vaya ánain dakháan more mere ono. ");
INSERT INTO agd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Afayuí ma iyain minó ayompin mo fanuse me fanuse iyain bantin mi Banta Anin ma erin nain mai afayu an mi yantin minó nanin banta anon onanten mino. ");
INSERT INTO agd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Onanten mifo véi kokhon uman nare varen aí o yosintin maen maí damú ma varéin nain nanin banta ano ven oyan aminten mino. ");
INSERT INTO agd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Noani yamú ma afoká ukhá ein avúavá an dakhein avúavá anan Banta Anin ma erin nain damú afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noani yamú maen banasi ano omasí iyáken dunan ben amin ben amin iyáken anasi varampin nafi vanta varampin tasu sasu en oriyákan Noa votifin umperiyain má kákan á den non taaren minó daná dararan ufuren puren mino. ");
INSERT INTO agd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Rotini yamú banasi ano máan avúavasí anan en omasí iyáken dunan ben amin ben amin iyáken minó daná miyaní in maran iyan dunan doriyan má uvaren dararen iyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Máan tiyákan mi Roti ma Sodomú baru me ampen oriyain má anan inaru fáké ira vá ira khiyain onámaná bá ano á ma ereiníen minó danasinta irakhen kauren mino. ");
INSERT INTO agd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Máan tukhein mi vantin Banta Anin ma erin nain damú mai avúavá anan afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Maí damú ma mana vanta ano ve amá daró ma un baren maen bei kama yanasinta ma má naumpin baré intin ída vá eravuven barano van ino. Máan mana ená mana vanta ano ma yunan anafá ovaré inten maen ída vá evaránen mana yaná barano van mápin orino. ");
INSERT INTO agd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rotin aná amaniná ma afoká ukhá ein danasará ovare me ineno. ");
INSERT INTO agd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Be aunan ma fákan nain nanin bantai aunan mano o afeyoranten mifo ve aunan ma ampian kain nain nanin bantai aunan para vanten mino. ");
INSERT INTO agd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Téi siretí ankan tiamé uno. Banta Anin mano ma erin nain inuran kankanan mano ma mana sakhópin bakharé intin maen Tiyarafenu ano mana aviáren mana ifá inten mino. ");
INSERT INTO agd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Máan mana en mi kankanan nanin mano ma uviti yasamiyaré intin maen Tiyarafenu ano mana nanin aviáren mana me ifá inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Máa síkan bei eyo iyampon kayo ano mai vaya iniren máa sen Yisasin inaemí, “Bafan noe, mai yanasinta intefasá afoká inten nafino.” Síkan béi evaránen betin tiamemí, “Purin danasinta au ma asenteintái sumpan kayo ano ákané iyan mino. Máan ma inti afováisá ono Tiyarafenui yaimin damú afoká inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Máa siren Yisasi vei eyo iyampon kayo van ída avesaraen ena ena amúkino van ovaeran baya fóké betin aní iyan tiamemí, ");
INSERT INTO agd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Mana varurá mana vaya yaimin banta váken béi ída Tiyarafenu van peren inká banasi oman kaumpan iyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Máan tiyákan mai varufin mana varé nanin báken ena ena yamú mai nanin mano mai ma vaya yaimin banta vaípá oren mo yuvunen máa siyamí, ‘Tesi namuro ano séin uman timeno van iyá umpo éi siyae mai uman puntátintano.’ ");
INSERT INTO agd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Máa siyákan inian aniana iyaren mifo ínaimpáké beyan ovaren me inen temí, ‘Téi ída Tiyarafenu van periyáké banasi oman kaumpan iyá umpo ");
INSERT INTO agd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ma varé nanin mano ma me yuvunen oren ein nan mi véini uman aya urékun maen béi ma eren oren iyain mai ída sivesara simino van muno.’” ");
INSERT INTO agd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Máa siren mairá Bafan mano semí, “Namu yaimin banta ano inte vayá tikhen nafi mai vá tiretí ineno. ");
INSERT INTO agd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tiyarafenu ano ma veyan iyákein nanin banta ano ma ena ena inuran má bayan má ma ifí den oriyan bantin maen betin ída ayain ná oyan amiyan maná banten nafino. ");
INSERT INTO agd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Téi siretin tiamé uno. Béi ainen betin ayainten mifo Banta Anin ma erinten maen mumunan nanin banta ma varará bantin ná e onanten nafino.” ");
INSERT INTO agd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Manáa ano ma vetiyan nan tetí puntáké uno siren ma ena kéka san ída funtáken ne ma siyain nan Yisasi ma vaya ovaéden tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kankánan banta ano amúkono van monó namumpin oren mino. Mana maen Farasisi vanta ifo ena takisi varan banta ino. ");
INSERT INTO agd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farasisi vanta ano o mantaven beyan nan máa sen amúkemí, ‘Tiyarafenu oe, séi ída manáa vanta an dé maé umoyan iyá namu avúavasí iyá inká ena vanta aná baré nó maé inká téi ída ma ma sakisi varan banta ma e vain an dakheruna van mi éin tusu siantiyá uno. ");
INSERT INTO agd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mana uvikifin kan bayan mi séi yunan turiyáké maé téi ma varé iyaruna yanasinta minó tiyan míkan pintan daídé mana masiman éin amé iyá uno.’ ");
INSERT INTO agd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Máa siyákan takisi varan banta ano nentá e mantaven inarufá ída mun auu máan onan mátimen be akorá ankamiyáken máa semí, ‘Tiyarafenu oe, séi ume vanta umpo arunará usintano.’ ");
INSERT INTO agd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Máa siren Yisasi semí, “Téi siretí ankan tiamé uno. Mai ma sakisi varan banta ma ve amápin orein mai véi Tiyarafenu avorá puntákein bantan oren mifo Farasisi vanta ída ino. Máan tukhantin betiyan ma maman daní inain kéká Tiyarafenu ano vetin aví maman bara finí inten mifo vetiyan ma vara finí inain kéká Tiyarafenu ano vetin aví maman daní inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yisasi avu amino van banasi ano véi vaintá iyampon arará kayo aviren ore ore íkan beni eyo iyampon kayo ano óden mai nanin banta ákonaen asen mino. ");
INSERT INTO agd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Asiyaimpin Yisasi mai iyampon kayo arákan be vaintá erivin máa semí, “Arará iyampon kayoi aa ída vá iyáante áesin ná téi varunafá erino. Para vara seyo, ma kéká an ma yákein nanin bantai nan Tiyarafenui yafisin baru van mino. ");
INSERT INTO agd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Téi fura uron mi sé tiretí ankan tiamé uno. Mana nanin banta ano ma ída ma iyampon arará kayo an den ma Tiyarafenui yafisin baru varanten maen mai kéká ano ída kanaíen mai varufin ódinten mino.” ");
INSERT INTO agd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mana ánon banta ano Yisasin máa sen inaemí, “Kama aru soe, séi intesá urerá para ma ayun ban oriyan ban aunan barante rafuno.” ");
INSERT INTO agd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Máa síkan Yisasi evaránen béin tiamemí, “Pará te nan kama ukha ono siya fono. Ída mana ano kama ukhen mifo Tiyarafenu veya anan kama ukhen mino. ");
INSERT INTO agd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Éi man baya kayo afová ukha ono. ‘Ída vá ena ana safi ena avafun nafi vare nono.’ ‘Ída vá ena aruan purono.’ ‘Ída vá umoyan ono.’ ‘Tiretí ankan ída vá ena nanin banta kampun tire kó tiantano.’ ‘Tiretí anóe afóen aránaó bákeya vá betin oo yaiyono.’” ");
INSERT INTO agd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Máa síkan mai ánon banta ano semí, “Téi sirará iyampon tákéi mai man baya kayo minó dakhaké uno.” ");
INSERT INTO agd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Máa síkan Yisasi mai vaya iniren mai ánon banta siamemí, “Mana yana san éi fara o afasí ukha ono. E ina yanasinta minó sarí ureya minó daná ma i vain nanin banta ameno. Máan ma inte éi inarufá kama yanasinta khaesin banten mino. Máan ture éi ere sen tínain bákurono.” ");
INSERT INTO agd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Máa síkan mai ánon banta ano kokhon daná dákaren pasin mai vaya iníkan ará uman den mino. ");
INSERT INTO agd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Uman den iniyaimpin Yisasi véin oniyáken máa semí, “Moní bá kokhon ona vá ma yan bain kéká ano ma Tiyarafenui yafisin aúpin ma orin uman dakhen mino. ");
INSERT INTO agd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Pura ino, kameri ano ma ufi aimpin ma ódin mai uman dakhen mifo kokhon ona ma yákein kéká ano ma Tiyarafenui yafisin barufin ma ódin mai moéken uman mi yakhen mino.” ");
INSERT INTO agd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Máa síkan mai vaya ma inein kéká ano semí, “Máan ma ukhantin maen mai iye ná Tiyarafenu ano kanaíen aviranten nafino.” ");
INSERT INTO agd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Máa sen ina íkan Yisasi semí, “Banta ano ma ída kanaíen bararen daná Tiyarafenu ano kanaíen baranten mino.” ");
INSERT INTO agd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Máa síkan Pita véin tiamemí, “Éin ánain bákurono van pefái setisi minó danasinta me ampikhé uno.” ");
INSERT INTO agd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Máa síkan Yisasi máa sen betin tiamemí, “Téi fura siré tiretí ankan tiamiyá uno. Tiyarafenui yafisin baru van ma iniren ma vei varu vá be aná akhafana vá be afá aváe má be anoifon má ma me ampiren ma orin nain kéká ano ma ma varará báken ma yantin ban nain danasinta esantaren moékakhein danasintan Tiyarafenu ano aminten mifo ínaimpá ma yamú afoká intin maen ayun ma fara van oriyan ban aunan baranten mino.” ");
INSERT INTO agd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Máa siren Yisasi vei sirantan kan orun kádan (12) eyo iyampon kayo aviren mo kaúden máa sen tiamemí, “Pefá ma sakhanampa vanta kayo ano ma Banta Anin amaniná afoká inain dana san ma vompon uvamádan ma varé ein taréa Yerusaremí orétifékun maen pura sen afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Afoká ma intin maen banta kayo ano véin pákaan ena anan nanin banta kéká amintin mai kéká ano véin máká maáká en oyampá baya siyan dafiyó ankáden auufen akhare siren aruan purinten mino. ");
INSERT INTO agd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Púkaren maen kanú manaú damusí intin béi evaránen orun mantanten mino.” ");
INSERT INTO agd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Máa síkan bei eyo iyampon kayo ano mai vayai ana ída uron afová en mino. Mai vaya ana ano aúpá bákan inte vará béi siyan nafi mai vetí ída afová en mino. ");
INSERT INTO agd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yisasi ma Yerikó barurá e unen oriyan maen mana auu yufúkukhein banta ano aa akhempá kumanten banasi vaípá moni san inantiyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Máan tiyaren iníkan banasi ano mai aasá tisuvo sen entaviyaimpin náisá iyan nafino sen inaen mino. ");
INSERT INTO agd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ina íkan mai ma oriyá ein kéká ano véin tiamemí, “Nasaretí banta Yisasin entaviyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Máa síkan mai vanta ano mai vaya iniyáken oovaren temí, “Devitin anin Yisasi oe, éi se nan arunan usintano.” ");
INSERT INTO agd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Máa síkan an ma oriyá ein nanin banta ano mai vanta asiyan temí, “E avaya fákano,” síkan béi moékentá oovaren temí, “Devitin anin noe, séin nan arunan usintano.” ");
INSERT INTO agd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Máa síkan Yisasi o mantaven temí, “Mai vanta avire mará ereno”, síkan aviren ádé meran Yisasi véin inaemí, ");
INSERT INTO agd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Éi sen nan náisá uantano vará iniya fono,” síkan mai vanta ano evaránen temí, “Bafan noe, séi suu mábé onano van muno.” ");
INSERT INTO agd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Síkan Yisasi véin tiamemí, “Eni mumunan manon éin ayofein auu maran nono.” ");
INSERT INTO agd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Máa siyain má ana mai vanta auu kama uvíkan Yisasin ánain bákuren oriyan Tiyarafenu aví daní iyákan minó nanin banta ano mai ódaren betin má dere Tiyarafenu aví daníen mino. ");
INSERT INTO agd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yisasi Yerikó barufin ódiaren mai varu aúbaná orikhein aa yakhafen oren mino. ");
INSERT INTO agd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Oriyákan mai varufin mana Sakiasin ne sin banta váken béi sakisi varan banta kayoi ánon banta van maen béi kokhon moní kain baren mino. ");
INSERT INTO agd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Báken Yisasi inté ukhein bantá ban nafino siren béi onanton en mifo véi asíka vanta váken kokhon nanin bantafin ída kanaíen béin onan nainíen mino. ");
INSERT INTO agd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Máan tiyaimpin mai ma Yisasi oriyain aasá béi afová iyáken ainen tavaen orein mano mana fiki yaa ana aa akhempá baré íkan béin onano van maifin óden mino. ");
INSERT INTO agd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Un baré íkan Yisasi mai yaa anafin o mantaven mun oniyáken béin máa sen tiamemí, “Sakiasi oe, éi aine erano saréa anan en amápin téi o vanté uno.” ");
INSERT INTO agd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Máa síkan béi ainen mai yaa ana finté eraven kákan amusin iyáken Yisasin e aviren be amápin oren mino. ");
INSERT INTO agd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Oriyákan kokhon nanin banta ano ódaren betí anan iyan temí, “Béi ume vanta amápin mi oriyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","O vákan Sakiasi e mantaven Bafan máa sen tiamemí, “Bafan noe, minó daná ma se sina vain taréan aúban daídé maé ída ma minó daná bain nanin banta kayo amiyáké maé inká intéa nanin banta íná mana yaná kampun tirerá mantaré onte rafu. Mai séi evaráné kamí kamí dádá mairá kaúdé amídú onté uno.” ");
INSERT INTO agd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Máa síkan Yisasi véin tiamemí, “Taréa anan Tiyarafenu ano ma e antun aviren mino. Mai fara vara seyo, ma vanta vá dere Abaraamun anin mino. ");
INSERT INTO agd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mai ma afeyóká ein nanin banta kayo yosiré evaráné avirano van mi Banta Anin mano erakhen mino.” ");
INSERT INTO agd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Máa siyákan banasi ano ovaren me inen maen béi Yerusaremí ádéi oriyain taréa anan Tiyarafenui yafisin baru afoká inten mino sen iniyákan Yisasi mana ovaeran baya siamen mino. ");
INSERT INTO agd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Béi máa semí, “Mana kin anin mano ena varafá orintin béin maman kiní urantí ovaráné erivé bei kékáká dafiseno van oren mino. ");
INSERT INTO agd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Oriyáken bei siyan míkan doran banta aran eríkan mana tausen kina, mana tausen kina (K1,000) uariyan minó máa amiren béi máa sen betin tiamemí, ‘Ma moní póké para yore oriya vasirá téi ovaráné ereno.’ ");
INSERT INTO agd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Máa siren orivíkan bei mana varu rákena kayo ano véin inian namu uantáden ‘béi ída sétinti kiní ino van muno’ sen mo siamino siren manáa vanta kéká tiantan mai ma orikhein barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Máa síkan betíi vaya ída inin mai vanta maman kiní urákan béi ovaránen bei varurá eriven bei yoran banta kayo ma fefá moní amikharé ein kayo van nái máa aman monisá dóáden nafi siren béi onano van betin aren mino. ");
INSERT INTO agd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Máa siren arákan mana vanta ano nare esé eren me máa semí, ‘Kákan banta oe, séi ano eni mana tausen kina fóké tiyan míkan tausen kinan aman moní dóan kaékun ban mino.’ ");
INSERT INTO agd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Máa síkan bei kin mano evaránen béin tiamemí, ‘Éi senti kama yoran bantan bai kama yorarí eono. Éi ma sító danáká ma kama yafisirí eonafá taréa séi ano éin maman kákaní urékuya siyan míkan kákan baru máará dafisin nono.’ ");
INSERT INTO agd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Máa sirákan ena yoran banta ano mairá eriven temí, ‘Kákan banta oe, eni tausen kina fóké téi yan manápá tausen kinan aman moní dóan kaékun ban mino.’ ");
INSERT INTO agd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Máa síkan kin mano evaránen béin tiamemí, ‘Éi yan manápá kákan barurasá dafiseno.’ ");
INSERT INTO agd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Máa sirákan ena yoran banta ano mairá eriven temí, ‘Kákan banta oe, masina eni mana tausen kina moní davaráefin úkuré kaékun baré íká baré eré uno. ");
INSERT INTO agd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Para vara seyo, séi ma en oniyaruna éi sinko vanta vákeya inká ena vanta ano ma kain baré ein daná éi kasae variyákeya ena vanta ano ma yoká ein dunan éi kasae unafé iya ono. Máan ma iyaona van mi séi en nan peré uno.’ ");
INSERT INTO agd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Máa síkan kin mano evaránen béin tiamemí, ‘Éi namu yoran banta uron mono. En avayarái éin daimonté uno. Éi afová ukhen ná téi sinko vanta váké téi kasaé ena vanta ina yaná bariyá inká ena ano ma yoká ein dunan kasaé o unafiyaré uno. ");
INSERT INTO agd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kasaé o unafiyaruna ifo faraé tireyá tenti moní ída moní ma kain namumpin kaen nan baré irá téi ma ovaráné erivé mai moní ano ma yóádein aman má mai moní bá evare rafuno.’ ");
INSERT INTO agd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Máa siren mai ma ádé mantakhá ein kayo van temí, ‘Béin pintena mai moní dafireya mai ma siyan míkan tausen kina ma kain bain banta ameno.’ ");
INSERT INTO agd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Máa síkan betí ankan evaránen béin tiamemí, ‘Kákan banta oe, béi fefá tiyan míkan tausen kina manten mino.’ ");
INSERT INTO agd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Máa síkan béi evaránen betin tiamemí, ‘Téi siretí ankan tiamé uno. Kokhon danasinta ma yantin baréin nain nanin bantan móeken aminten mino. Inká ída ma yakáin nain kéká ina mai sanáa ma yaká intin mai vá deren minó baranten mino. ");
INSERT INTO agd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Máan tinten mifo mai ma senti namuro kayo ano ma séi nan ída vá betí ankani kiní ino van ma sein kéká avireya mará me kaúde sen tivorá arono.’” ");
INSERT INTO agd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisasi mai ovaeran baya siamíden mai oyampáké Yerusaremí ma ódikhen aintá ben nare óden mino. ");
INSERT INTO agd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ódiyaren Betfasí baru vá Betaní baru vá ádé bain anu Orifi se sin dontá ódiven bei eyo iyampon kanan tiantiyan temí, ");
INSERT INTO agd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Tiré kanan mesan barurá oriveya mai varufin un pébe onesin ma mana ano ída amaniná kumantein donkin ma anan kuádantin banti mai vá útufe ereno. ");
INSERT INTO agd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Máan tesin ma mana ano ma siré kanan ina iyan ma fara mai anan útufiya fono ma sintiya vá Bafan mano veni yoran ban tí uno vá te véin evaráne siameno.” ");
INSERT INTO agd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Máa síkan mai ma siantan orein bantá kan mano o onan mai ma Yisasi siameiní ukharen mino. ");
INSERT INTO agd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Máan tukharéin míkanan mai donkin anan útufiyaréin mai donkin afóe ano míkanan máa sen inaemí, “Tiré kanan pará mai donkin anan útufiya rafono.” ");
INSERT INTO agd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Máa síkan míkanan mano evaránen betin tiamemí, “Bafan mano veni yoran bami sisintá uno.” ");
INSERT INTO agd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Máa siren mai donkin baren Yisasi vaintá mo kaúden betíi au anamun póké mai donkin amaniná uvíden Yisasin ayain mai yaró un kumanen mino. ");
INSERT INTO agd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Béi mai donkin ané un kumamen oriyákan banasi ano ayá au anamun kayo yavádiyan aasá uvisen oren mino. ");
INSERT INTO agd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Orifi se sin Anu ma me ampiren araviyain aa ádé béi erivíkan ben ma vákuren noin nanin banta ano véi ma enará ukhein danasinta ma afoká iyan ma oniyará ein nan avádóden oovararen Tiyarafenu aví daní iyáken amusin en mino. ");
INSERT INTO agd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Máan tiyáken beti oovaren temí, “Bafan avíká ma erikhein kin ná Tiyarafenu ano avábá ino. Tiyarafenu ano seti vanasi ará kusin timen mifo véin avisá daní ó tifano.” ");
INSERT INTO agd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Máa siyákan manáa Farasisi kayo ano mai nanin bantafin baren betí ankan Yisasin máa sen tiamemí, “Aru soe, ei eyo iyampon kayo asesin ída máan baya kayo sino.” ");
INSERT INTO agd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Máa síkan Yisasi evaránen betí ankan máa sen tiamemí, “Téi siretin tiamiyá uno. Ma nanin banta ano ma ve oo fákaren ma ída vaya sintin maen ma onámaná kayo ano kasaen oovararen Tiyarafenu aví daní inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Máa siren béi Yerusaremí ádé oriven mai varu oniyáken ifí daanten mino. ");
INSERT INTO agd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ifí daren temí, “Yerusaremi oe, saréa ma éin ará kusin daná ma varen me amin afová ono van téi inikhé umpo éi mai yaná afová e varé esin Tiyarafenu ano éin ará kusin amin nainten mifo mai yaná ano saréa siretin avorá aúpasí ukhein ída onan nono. ");
INSERT INTO agd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ineno. Maná damú afoká intin maen eni namuro kayo ano eni yafu akhempá bara khaen eúkuren maen minó ankinafa yafisinten mino. ");
INSERT INTO agd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Máan turen maen éin ankaman barakuádanti varafin eravesin éin má e akhafana vá maifin ma váin nain dere vá aruren namu uantanten mino. Máan turantin maen mana onámaná ano ída ena onámaná daró banten mino. Mai farava máan tinten na ino. Tiyarafenu ano ma éin aya ono van ma éi vaípá erein damú éi ída kamaeya afová ukharé esin mino.” ");
INSERT INTO agd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Máa siren Yisasi monó namun dafufin ódiven maifin ma sarí iyá ein danasinta kayo yo maman karúdiyan tiantan barufá araven mino. ");
INSERT INTO agd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Máan turen betin tiamemí, “Tiyarafenui vompon dóki ano máan mi sikhemí, ‘Tenti má maen mai amúkin namun’ ne sikhein mifo siretí ano maman ‘umoyan banta kayoi má an diya ono.’ ");
INSERT INTO agd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Máan turen béi ena ena yamú monó namumpin oriven maen monó baya sian banasi amiyákan monó ánon banta kéká bá man baya ma afová ukhein banta kéká bá banasirá ma ánoní ukhein banta kayo vá ano Yisasin ma aruan purin aa van dosiyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Máan tiyákan banasi ano ákonaen béini vaya iniyan pasen béin ma arin aa vetí ankan ída kanaíen dosen mino. ");
INSERT INTO agd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Maná damú Yisasi monó namun dafufin kama vaya sian banasi amiyákan monó ánon banta kéká bá man baya ma afová ukhein banta kéká bá banasii ánon banta kayo vá ano véi vaintá eren mino. ");
INSERT INTO agd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Eriven betí ankan máa sen béin tiamemí, “Éi setin tisimeno. Nái ákonarasá mai yanasí iya fono. Iye anó mai ákona éin amikha fono.” ");
INSERT INTO agd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Máa síkan béi evaránen betí ankan tiamemí, “Téin má deren tiretin ina onté umpo anona vá téin tisimeno. ");
INSERT INTO agd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yoni ma vanasi monó non péantiyaré ein mai Tiyarafenui ákonarasá péantiyan nafi áa varará bantai ákonara safino.” ");
INSERT INTO agd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Máa síkan betiyan ten orera emí, “Inaru fáke na ino ma sé tifékun maen mai fará ída mairá mumunan iya rafono sinten mino. ");
INSERT INTO agd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Inká barará banta ina ino ma sé tifékun maen banasi ano Yonin nan sakhanampa vanta ino sen mumunan ukheintá tetin onámaná tinkaminten mino.” ");
INSERT INTO agd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Máa sen iniren betí ankan béin tiamemí, “Mai ma Yoni mantaré ein ákona mai setí ída afová ukhé tiféuno.” ");
INSERT INTO agd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Máa síkan Yisasi evaránen betin tiamemí, “Iye anó ákona séin timikhará ma yorarí iya rafu, mai séin má dere ída siretin tiamenté uno.” ");
INSERT INTO agd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yisasi mana vaya máa sen banasi sian baéan amemí, “Mana vanta ano uvaini yunan ana yóádákaren dunan ma yoran banta kayo van mairá dafíken dóden manáa uvaini aran betíi miyan do variyan dunan afóen nina khaono siren ena varufá ayáká bano van oren mino. ");
INSERT INTO agd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ovaren uvaini aran ma kúdin damusí íkan maifin ma yafíkein kayo ano manáa kúduan amino van béi iniren mana vei yoran banta siantan mai yafisin banta kayo vaípá onóbíkan mai kayo ano mai yoran banta ankáden tiantan ída mana yaná baran na fara evaránen oren mino. ");
INSERT INTO agd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Oríkan mai yunan ana afóe ano ena yoran banta siantákan betí baípá orin mai kéká ano mai vanta vá dere namu ankamirí uren evaránen tiantan para oren mino. ");
INSERT INTO agd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Oriyaimpin béi kanú manaú dádasí en ena yoran banta vá tiantan oríkan mai kéká ano mai yoran banta namu arirí uren darifen dunan akhempá mo kharúden mino. ");
INSERT INTO agd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Máan tiyaimpin mai uvaini yunan ana afóe ano semí, ‘Taréa séi intesá onte rafuno. Téi se sanin nan ma sinunu iyaruna fumara ma siantékun orintin maen mi vetí ankan kanaíen béin avaya ininten mino.’ ");
INSERT INTO agd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Máá siren mai fumara siantan oríkan mai yafisin kéká ano mai fumara oniyan temí, ‘Béi anon be afóeni minó daná baranten mifo eresí béin arékun púbintirá ma yunan ana setiyan bará tifano.’ ");
INSERT INTO agd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","“Máa siren mai yunan ana fintena mai fumara yo yarifen akhempá morúden aruan puren mifo mai yunan ana afóe ano mai yafisin kéká náisá inten nafino. ");
INSERT INTO agd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Béi mai yafisin kéká me aruan púden maen mai yunan ana yafían ena kékái aminten mino.” Máa síkan banasi ano ena kéká ma amein baya iniren temí, “Béi ída vá máan tino.” ");
INSERT INTO agd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Máa síkan Yisasi vetin auufen kakháben inaemí, “Tiyarafenui vompon dókifin ma ma vaya uvamádan baini ana ano naíesá tikhen nafino. “‘Má uvaran banta kayo ano ma yo maman karúdein onámaná ano maman má dádaimpin mana ákona onámanasí ukhen mino.’” ");
INSERT INTO agd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Máan tukhen mifo minó nanin banta ano ma mai onámaná daró ma eraven ankaminten maen morun ta finen tító tító inten mino. Inká mai onámaná ano ma mana nanin banta ané ma eravinten maen béin dasantan panten mino.” ");
INSERT INTO agd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Máa siyákan man baya ma afová ukhein kéká bá monó ánon banta kéká bá ano mai ma ovaeran baya ma véi siyain ovaren me inin betin oyampá baya siyaimpin maí damú ana véin pákano van uvaen banasi van péden ifá en mino. ");
INSERT INTO agd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Man baya ma afová ukhein kéká bá monó ánon banta kayoi ánon banta kéká bá ano Yisasintá dafían ákona uven manáa afurin banta kayo siantákan mai vanta kayo ano fura sen Yisasini vaya iniyan mino sino van kampuníen nóken Yisasi ma manáa vaya me avá dantí mai vayará béin pákaan ánon kamanin ayampin kaono siráken afuriyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mai ma afurin kéká ano máa sen béin inaemí, “Aru soe, setí afová ukhé uno. Éi funtákein baya anan banasi siamiyákeya aví bain má ída ma aví bain kayo vá o éke e éke ureya manaí ukhein baya anan tiamiyáke mae fura vayafó anan Tiyarafenui avúavá tian dákó éiya ono. ");
INSERT INTO agd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Máan téiya ompo éi ma iniyaona setí kanaisá erá moní Sisan takisi amente rafuno áa ída fino.” ");
INSERT INTO agd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Máa síkan betí ankan ma máká tiyain béi afová iyáken betin máa sen tiamemí, ");
INSERT INTO agd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mana moní aní irá onano. Iyen aman manon má aví basá mai moníká ban nafino,” síkan ");
INSERT INTO agd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","betí ankan evaránen temí, “Sisan mino,” síkan béi vetin tiamemí, “Sisan nina yanasintá Sisan ná ame vá inká Tiyarafenu ina yanasá Tiyarafenun ná ameno.” ");
INSERT INTO agd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Máa síkan betí ankan anú duren mai ma véi vanasifin tein bayará ída kanaíen ben pákarí iyaimpin ída vaya sen mino. ");
INSERT INTO agd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusi kayo finté manáa ano sen ma furiyain nanin banta ano ída evaránen orun mantanten ne ma siyain kayo ano Yisasin inaono van béi vaintá eren mino. ");
INSERT INTO agd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Eriven mai kéká ano máa sen béin tiamemí, “Aru soe, Mosesi ano seti sina máa sen bompon dókifin uvantaren mino, ‘Mana vanta ano ma anasi mamákaren ma ída iyampon kain na ma mai vanta ano fúbintin ná be afá aváeyan pinté mana ano vá baré mamáken ná mai nanintá mai ma furein nina iyampon kaúantano. ");
INSERT INTO agd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pefá dan manápá ifo afápá kan un kádan anavádano ano varen esékena vanta ano anasi mamaren ída iyampon kain na fara furen mino. ");
INSERT INTO agd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Fúbin mai rákena ano mai varé mamaren máan mana en mino. ");
INSERT INTO agd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Máan turan kanú manaú banta ano yere mai varé mamaren osaní uvíkan mai máa yan manápá ifo afápá kan un kádan anavádano ano mai varé nanintá ída mana iyampon kain na máa mana en oriyan minó máa ano o furen mino. ");
INSERT INTO agd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Fúbíkan mai nanin má dere o furen mino. ");
INSERT INTO agd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","O furen mifo mai nanin maen dan manápá ifo afápá kan un kádan anavádano anon mantaren mifo ínaimpá ma furin nanin banta ma orun mantan nain damú béi iyen aná suron ná banten nafino.” ");
INSERT INTO agd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Máa síkan Yisasi evaránen betin tiamemí, “Ma vararái vanasi ano ma ábasuíin ban mino. ");
INSERT INTO agd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Máan tukhen mifo funtákein nanin banta ma furiyain nan Tiyarafenu ano evaránen orun mantanten ne ma sikhein kayofin ábasuíin ída vanten mino. ");
INSERT INTO agd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mai farava ino. Tiyarafenu ano furin pintena vetin orun avían mantarantin maen béin akhafanaí uven ída furinton enisori an daven para vanten mino. ");
INSERT INTO agd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mai ma sító daa ana ira khiyákan ma Mosesi ano Bafan araaren ma Éi Abaraamun má Aisakin má Yekopun mái Ayarafenu ono ma sikhein mano furin nanin bantai e mantan mi Mosesi ano setin aní ukhen mino. ");
INSERT INTO agd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Aní ukhen mifo Tiyarafenu maen ída furin nanin bantai Ayarafenu ifo véi maen ayun ma fa vain nanin bantai Ayarafenun bantin mi ven avorá minó nanin banta ano ayun para vanten mino.” ");
INSERT INTO agd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Man baya ma afová ukhein kayo finté manáa kéká ano mai ma Yisasi sein baya iniren béin máa sen tiamemí, “Aru soe, Éi kama vayan te ono.” ");
INSERT INTO agd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Máa siran banasi ano evaránen béin mana vaya inain nan peren mino. ");
INSERT INTO agd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Máan tiyákan Yisasi máa sen banasi inaemí, “Tiyarafenu ano ma vei vanasi evaránen avirano van ma aní ukhá ein banta van banasi ano faraé tiren ná Devitin anin mino siyan nafino. ");
INSERT INTO agd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Deviti veyantái Í Bompon dókifin tian páman en mi, “‘Bafan mano senti Bafan tiamiyáken, “Ten tiyan kurompá kumantesirá ");
INSERT INTO agd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","eni namuro kayo maman en aránaópá kaékun ná eni arantan kain karasisá ino.” ’ ");
INSERT INTO agd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tiretí onano. Deviti veyantái venan Bafan ne sen arakhan mifo mai vanta ano inté uákená ben aniní inten nafino.” ");
INSERT INTO agd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Máa siyan minó nanin banta ano Yisasini vaya iniyákan béi vei eyo iyampon kayo máa sen tiamemí, ");
INSERT INTO agd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Man baya ma afová ukhein banta kayo vará dafiseno. Betí ankan ayá au anamun uren nono van anunu iyáken maen banasii átaru varurá nontin banasi ano kama yamú ino sen amé amé ino van anunu iyáken maen monó átaru namun kayofin má omá dunan ma saran naimpin má betí ankan esé an bain karáká kumaneno van mi anunu é iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Betí ankan baré nanin kayo mákáden maen mai nanin kayo amá pintena yanasinta umoyan bariyáken maen kampun ten ayáká amúké iyan mifo uman ma yaimin damú ma afoká intin mai kéká anon moéken uman baranten mino.” ");
INSERT INTO agd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yisasi oniyan bákan moní nanin banta ano susu moní monó namumpin ma moní kain bokhise ma vaimpin kaiyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kaiyákan mana ve avafu fúkan ona ída vain baré nanin mano kankanan toeya varen mai vokhisefin me kaiyákan béi onen mino. ");
INSERT INTO agd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ódaren máa semí, “Téi fura uron mi siré tiretí ankan tiamiyá uno. Minó ona vain nanin banta ano ma kaein moní esantaren mi ma ona ída van baré nanin mano khaen mino. ");
INSERT INTO agd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Minó nanin banta ano kokhon ná moní dákaré ein pintena manáa moníi yaimen me khaen mifo ma nanin mano ída kanaí ukhen mi veyan ma yunan máden nano van ma fákakharé ein moní minó máai me khaen mino.” ");
INSERT INTO agd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yisasini manáa eyo iyampon kayo ano monó namun ma uvantein ódaren betí mai van máa semí, “Kama on kayo vá kama yanasinta vái Tiyarafenu amíkhan mi kamaen aní uran ban mino,” síkan Yisasi vetin tiamemí, ");
INSERT INTO agd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Taréa ma oniyaona yanasinta ano ínaimpá maná damú afoká intin maen namuro kéká ano minó daná barákuan karúdantin barará ana eravintin maen mana onámaná ída áintin ena onámaná daró banten mino.” ");
INSERT INTO agd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Máa síkan betí ankan Yisasin inaemí, “Aru soe, inte yamusá mai yaná kayo afoká inten nafino. Inte yaná ma afoká intirá tetí afová erá mai yanasinta inka ádé anantá afoká inten mino sé tifante rafuno.” ");
INSERT INTO agd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Máa síkan Yisasi evaránen betí ankan tiamemí, “Tiretin me kampun tinten mifo yafían ná ákona ono. Mai fara vara seyo, kokhon nanin banta ano eriven maen téin tiví diyan máa sinten mino, ‘Téi ma mai vantan bákun damú inka ádé’ e ne sinten mifo siretí ída vá betin bákurono. ");
INSERT INTO agd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ínaimpáké ma inesin ma kákan aruvin afoká intin ma mana vara ano e manten ena vara vá aruvintin inká mana vara finté ma verara aúban daíden aruvinti maeya siretí ankan ída vá akhokho van ono. Mai yanasinta naren afoká inten mifo ma vara ma kípan damú ída ainen erinten mino.” ");
INSERT INTO agd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Máa siren Yisasi evaránen betí ankan tiamemí, “Manáa vara kayo finte kéká ano e manten ena vara kayo finte kéká bá aruvintin maen inká manáa kini yafisin pintena kéká ano e manten ena kini yafisinpintena kéká bá aruvintin inten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Máan tintin maen ma vara kákantá kaya intin manáa akhempá kákan anan má kákan aí danasinta vá afoká iyantin inká minan ayontá aní daná bá akhokho yanasinta vá afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Mai yanasinta ma ída afoká ukhantin maen tiretí ankan pákaren namu arirí inten mino. Betí ano siretin monó átaru namun kayofin kaúden maen baya yaíden aviren mo karavusifin kaiyan maen tiretin aviren kin kayo avorá bá kamanin kayo avórá bá orinten mifo mai fara va ino. Tireti senti eyo iyampon kayon basin pasen mi máan tinten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Máan ma inain manon tiretí ankani aaí intiyan betin monó baya siamin nono. ");
INSERT INTO agd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Máan tin nompo sireti ída vá betin ma evaráne siaminona vaya van kokhon ineine ono. ");
INSERT INTO agd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mai fara vara seyo, seyantái siretin puntákein baya vá kama afova vá amiyákun maen tiretíi namuro kayo ano ída kanaíen téi ma amenuna vaya átakharé uren do varanten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tiretí ankan anóe afóen má afá aváeyan má tiretíi kéká bá arona kayo vá ano yeren tiretin namuro ayampin amintin arintiya siretin pinté manáa ano furin nono. ");
INSERT INTO agd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Téin naro siren banasi ano siretin ará namu uantanten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Máan tuantanten mifo siretin ánon do finté ída mana ayo farusen eravinten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Máan tinten mifo siretí ankan mantaan ákona ukhareya vá ayun ma fara van oriyan ban aunan barano.” ");
INSERT INTO agd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Máa siren Yisasi evaránen tiamemí, “Tiretí ankan onesin ma aruvin banta kayo ano ma Yerusaremí baru ma iyaren eúkintiya mairasá tiretí afová eya vá inka ádé anantá ma varu namu inten mino vá teno. ");
INSERT INTO agd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Maí damú ma afoká intin ná Yudiá ma vain nanin banta ano vá anufá karan ódintin ná Yerusaremí ma vain kéká ano mai varu me ampiren ena akhempá karan orintin ná Yerusaremí ankinafá ma vain kayo ano ída vá mai varufin ódino. ");
INSERT INTO agd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mai fara vara seyo umeí ma iyá ein kéká ma uman amin damusí ma intin maen Tiyarafenui vompon dókifin ma uvamádan baré ein baya kayo ano fura sen afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ma varará kákan uman afoká intin Tiyarafenui aranan ná ano mai nanin bantafin afoká inten mifo amúbá nanin kayo vá arará iyampon kayo ma nan kuviyá inain nanin kéká bá ano kákan uman baranten mino.” ");
INSERT INTO agd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Uman baranten mifo namuro kayo ano me Yerusaremí kéká aruren maen aviren ena vara kayofá mo karavusií inten mino. Máan turantin ena anan banta anon Yerusaremí me aruren ayanavan en oriyantin baren maen Tiyarafenu ano ma vetintá dafisino sikhá inain ma mo akheníin damú ma afoká intin mairái mo kanaí inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Máa siren Yisasi evaránen betin tiamemí, “Maí damú ara ara aní daná ano áaura safi viyonta safi ofu kayora safi afoká inten mino. Máan tintin maen ma varará minó nanin banta ano un non ma karantó en e man paútin nain avaya ma iniren betí kokhon ineine iyáken berai siya akhokho van inten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Máan tiyáken maen ma varará ma afoká ono van ma iyain danasinta van banasi avinantan dantin auu entave entave inten mino. Mai farava ino inaru rákena kákan danasinta ano kayamana inten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Máan tintin maí damú banasi ano onantin Banta Anin mano konan daró bei kákan ákona vá panu vá erinten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mai yanasinta ma araíen afoká inti vá tiretí ankan orun mantaan ákona uve vá anuran duvaserano. Mai fara vara seyo, Tiyarafenu ano ma siretin evaránén aviran damúi ádesí inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Máa siren Yisasi evaránen ena ovaeran baya vetin tiamemí, “Tiretí ankan fiki yaa ana vá ena yaa ana kayo vasá onano. ");
INSERT INTO agd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tiretí ankan onen nan ma auyen anaa varen orera íka maeyan tiretí afová eya áken afe inten mino séiya ono. ");
INSERT INTO agd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Máa séiya ompo máa mana eya vá tiretí onesin ma mai yanasinta afoká intiya Tiyarafenui yafisin baru inka ádé eriyan mino vá teno. ");
INSERT INTO agd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Téi fura siré tiretin tiamiyá uno. Má damú kena nanin banta ano ída fúkesin mi ma yanasinta afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Máan tintin maen ma vara vá inaru vá kípanten mifo séinti vaya ída kanaíen kípanten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Máan tinten mifo siretí ankan dafían ná ákona ono. Ena ena yamú óen non nareya óeniya vákeya namu avúavá bá tiretí ma vaona van ma ineine iyasin maen mai avúavá anon tiretin maman bararasí intin Bafani erin mano oyivampin ma areiníen manádái afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Para vara seyo, oyivan mano ma safúna fáké iyain an den ma vara rákena nanin bantafin maí damú afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Minó damú tiretí ankan dafíaná ákona ukhevaya vá ena ena Tiyarafenu vaípá amúkiya vasin na ákona amino. Máan tiyare vá mai yanasinta ma afoká inain damú esantareya vá Banta Anin avorá o mantano.” ");
INSERT INTO agd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Máa siren ena ena yamú Yisasi monó namun dafufin banasi mo monó baya siamiren maen inúpasí ma íkan Orifi se sin anufá un bariyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Máan tiyákan maen minó nanin banta ano véini monó baya ineno van ena ena ákurá orun mantaaren monó namun dafufin eriyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yisi Ída Van Bereti Ma Nan Omá Damu san ma Avo Uantan Damu se ma siyain maí damú afokáin ádé en mino. ");
INSERT INTO agd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Maí damú afoká ono van iyákan monó ánon banta kéká bá man baya ma afová ukhein kéká bá ano vanasi van periyáken betí ma Yisasin aruan purin nain aa van dosen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dosiyákan tiyan míkan mifo sirantan kan orun kádan (12) eyo iyampon kayo finte Yudasi ne sen ma inká ena ví Isikarioti ne ma sikhein banta aúpin Ban Anon mano un peren mino. ");
INSERT INTO agd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Un pébíkan béi oren mo monó ánon banta kéká bá monó namuntá ma yafisin kéká bá ayampin ma Yisasin avían amin nain aa van bayaíen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bayaí urákan betí ankan amusin uren béin nan moní amenté uno sen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Máa síkan Yudasi kana ino siren banasi ma ída véin má ma átaru inain damú Yisasin avían betin ayampin kaono van ave iyan aa van dosiyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yisi Ma Ída Veretifin Kain Damú afoká íkan betí ankan sipisipi arará aruren niyáken Tiyarafenu ano ma Isareri nanin banta Avo Uantan ma kamaen baré ein nan ovaren me inintéin mi ");
INSERT INTO agd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pitan nú Yonin nú Yisasi siantan oriyákan máa sen tiamemí, “Tiré kanan ore vá Avo Uantan Damú kena yunan ná teti sina mo funtáán kaono.” ");
INSERT INTO agd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Máa síkan békanan béin inaemí, “Interasá mai yanasinta mo funtáádante rafuno.” ");
INSERT INTO agd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Máa sen ina íkan béi evaránen tiamemí, “Tiré kanan kákan Yerusaremí barufin ódesin ma mana vanta ano ma kákan non kura vá ma efókantiya mai vanta yakhafe vá be ma ódin nain namumpin ná ódono. ");
INSERT INTO agd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mai namun ma ódivinte vá má afóen ná máa se siameno, ‘Arú ano éin nan intesin ná mana karafaran bain ná tesi eyo iyampon kayo vá Tiyarafenu ano ma Isareri nanin banta ma Avo Uantein dunan maifin nante rafuno,’ sen inaen mantino vá teno. ");
INSERT INTO agd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Máa se ináesin maen béi mana kákan karafaran ma yan bain aní inti maen maifin ná dunan nan takhó bá kumanin kará bá banten mifo maifin ná dunan puntádeya saman ka ono.” ");
INSERT INTO agd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Máa síkan békanan oriyan o onákan mai ma Yisasin ano seiní ukhan mai yanasinta ódaren Avo Uantan dunan mo sáden puntáan kaen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Dunan nan áauí íkan Yisasin má bei eyo iyampon kayo vá ano yunan kaúden nan takhóká kumanen eúken mino. ");
INSERT INTO agd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mai sakhóká kumanen eúkuvíkan betí ankan tiamemí, “Ínaimpá téi uman baranté umpo Tiyarafenu ano ma Isareri nanin banta ma Avo Uantein dunan nare ma siretin má ma nan nan téi moéké tinunuiyá uno. ");
INSERT INTO agd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Téi siretí ankan tiamé uno. Téi ída evaráné Tiyarafenu Ano Ma Avo Uantein dunan nakhékun mi mai ma siran baré ein daná pura sen Tiyarafenui yafisimpin afoká inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Máa siren uvaini non bain kápi máden Tiyarafenu susu siantáden betí ankan tiamemí, “Minó ano mai fintena masiman ure vá nano. ");
INSERT INTO agd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Para vara seyo, saréa fi ínaimpáke safi séi ída evaráné uvaini non nakhékun mi Tiyarafenui yafisin afoká inten mino. ");
INSERT INTO agd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Máan turen mana vereti orun máden Tiyarafenu susu siantáden temí, “Ma se sui siretí ankan ayaino van amé umpo vá máan mana iyákeya vá te nan inisintano,” siren kisiariyan amen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Amin narákan uvaini non kápi orun mamaren mai ma ein avúavasí ana en máa semí, “Tiretin aya ino siré ma sesi nare vanaeruna mai ma uvaini kápi anon tiretin má ma kasen ban auyen avúavá aní inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Máa siren betí ankan tiamemí, “Téin ma sivían namuro ayampin ma kaono van inikhein banta vái ma yunan nan takhóká ten má manafin ban mino. ");
INSERT INTO agd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tiyarafenu ano ma fefá tikhá einíen Banta Anin mano furinten mifo véin ma avían namuro ayampin kain nain banta vará arunan uantano.” ");
INSERT INTO agd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Máa síkan eyo iyampon kayo ano mai vaya iníden betiyan inain maran en orera iyan temi, “Iye anó mai avúavasí inté iná tino.” ");
INSERT INTO agd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Máa siran beni eyo iyampon kayo ano vetin aúbaná pinté iye anó kákani o inten nafi siren beraran araíen asive asive en mino. ");
INSERT INTO agd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Máa sen orera iyákan Yisasi vetin tiamemí, “Ma varará ma ena anan nanin bantai kin kéká bá aví bain banta kayo vá ano ákonaen banasirá dafisiyáken betin asen aren iyáken maen betiyan nan banasi ayain kayo uno sé iyan mino. ");
INSERT INTO agd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Máan tukhen mifo siretí ankan ída vá máan tiyáke vá tiretimpin ma kákaní ukhein banta ano vá iyampon arará an dantin ná inká tiretí ánoní ma ukhein banta ano vá tiretíi yoran banta an ná dano. ");
INSERT INTO agd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Máan tukhen mifo iye anó kákaní ukhen nafino. Mai ma kumanten dunan niyain banta ano fi áa mai ma yunan kuan amiyain banta ano fino. Mai ma kumanten ma yunan niyain banta anon kákaní ukhen mifo séi siretí aúbaná doran banta an dakhéi siretin aya iyá uno. ");
INSERT INTO agd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Akhenókain danasinta ma sempin afoká iya mae siretí ankan ten má bare ono. ");
INSERT INTO agd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bare ompo se sifóe ma inaru yafisin téin timeiní ananéi siretin inaru yafisin amé uno. ");
INSERT INTO agd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Máan tukhantiya mai yafisimpin tiretí ankan tesi yunan nan takhóká kumame yunan má non má niyáke Kini kará kayorá kumameya sirantan kan orun kádan (12) Isareri anantá dafíkeya vetin daimin nono.” ");
INSERT INTO agd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Máa siren Yisasi semí, “Saimoni oe, Saimoni oe, ineno. Uviti yasáden ma antan má asu vá ma yo aireiní en tiretíi mumunan akhenóka uan onano van Ban Anon mano ina ukhen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Máa sikhen mifo Saimoni oe, éin ayaintin eni mumunan ída eravino van téi fefái simúkukhé umpo éi ma sirun noe sire ma ovaráne erinte vá e afá aváen ná ákona uantano.” ");
INSERT INTO agd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Máa síkan Pita evaránen tiamemí, “Bafan noe, éin má karavusifin oré inká en má puré ono van útakhé uno.” ");
INSERT INTO agd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Máa síkan Yisasi semí, “Pita oe, sare inuran manan kókore ída asikhantiya kanú manáu dádá téi nan ída afová ukhé uno sin nono.” ");
INSERT INTO agd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Máa siren Yisasi vei eyo iyampon kayo inaemí, “Tiretin nan ma sesi yorarí ono van ma siantéku oriyákeya moní unan má arantan anamun má ona váin unan má ída mamareya ore ono. Ore ompo maí damú tiretí ankan manáa yana san o afasíe fono áa ída fino.” Sikan, “Ída ino,” sen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ída ino ma síkan maen Yisasi vetí ankan tiamemí, “Mai saréa vá moní unan nafi ona váin unan nafi ma van nain banta ano varesin ná baenati ma ída van nain banta ano vá ei iyon au anamun ná mo sarí ure vá mai monípó mana vaenati miyaní ono. ");
INSERT INTO agd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Para vara seyo, Tiyarafenui vompompin máa sikhan mino, ‘Banasi ano véin oman mana namu vanta an daren maen béin e yankáan ume nanin banta vá kainten mino’ ma sikhá ein mai ano séin timaniná dákó intéíi siretin tiamé uno. Tiyarafenui vompon dókifin ma sen nan tiádan baré ein baya ano inka yákó irí iyan mino.” ");
INSERT INTO agd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Máa síkan bei eyo iyampon kayo ano semí, “Bafan noe, setí ankan kankanan baenati yékun ban mifo onano.” Síkan Yisasi evaránen betin tiamemí, “Mai khanai ino.” ");
INSERT INTO agd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yisasi ma ena ena varé iyain avúavasíen kákan baru me ampiren Orifí anufá oríkan bei eyo iyampon kayo ano vákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Orifi anuyontá ma o unaven betí ankan máa sen tiamemí, “Ákonae amúkiyare vá akhenókafin ída erave ankamono.” ");
INSERT INTO agd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Máa siren Yisasi vetí ankan me ampiren manáa e afánen nentá oriven aron mo yurafúden máa sen amúkemí, ");
INSERT INTO agd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tifóe oe, éi ma ananu iyante vá téin pintena ma uman do varan nompo mai ída vá téinti sinunu yakhafiyáke vá ei anunu ana vá dakhafono.” ");
INSERT INTO agd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Máa síkan inaru fáké mana enisori ano véi vaintá eriven ákona amen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yisasi ma ovaren me aváduan onan maen aufá uman dákan béi moéken ákonaen amúkiyan béin au fáké imúkan mano nare ma kapí kapí einíen barará eraven mino. ");
INSERT INTO agd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Béi amúkuan kíparen e manten evaránen bei eyo iyampon kayo vaípá oren o onákan betíi arunaná ano auunan ai íkan auun baren orera ukharen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Betí ankan auun bakharé íkan béi mo avoriyan temí, “Akhenókain mano siretí ankampin dákó intiya erave ankamin nampo ída auun bariya váke orun mantave amúkono.” ");
INSERT INTO agd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yisasi fara vaya siyan maen kokhon nanin banta kéká ano eren mino. Eríkan maifin tiyan míkan mifo sirantan kan orun kádan (12) beni eyo iyampon kayo fintena mana Yudasin ne sin banta ano aní uanten eriaren Yisasin me amónano van beni ádé eren mino. ");
INSERT INTO agd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Eríkan Yisasi véin máa sen inaemí, “Yudasi oe, éi amónan avúavá pókesá Banta Anin avían namuro ayampin kaono vara fono.” ");
INSERT INTO agd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Máan tiyain má Yisasin má ma varé ein eyo iyampon kayo ano onákan mai yaná afoká iyaimpin betí ankan máa sen Yisasin inaemí, “Bafan noe, éi eyo sinona vará ma kéká tetisi vaenati fóké aronte rafuno.” ");
INSERT INTO agd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Máa siyákan mai finté mana ano vaenati máden monó ánon banta kékái ánon bantai yoran banta ayan kuron pákena átaren do síkaan karúdan barará eraven mino. ");
INSERT INTO agd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Máan tíkan Yisasi onen temí, “Mai avúavá ifá ano,” siyáken mai vanta átarentá ayan kaíkan evaránen kamaen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Máan turen monó ánon banta kéká bá inká monó namuntá ma yafisin kékái ánon banta vá banasii ánon banta kayo vá ma véin pákano van erein kéká máa sen tiamemí, “Mana umoyan bantá pákano vará tiretí ankan baenati vá dan má útaaré ere fono. ");
INSERT INTO agd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ena ena yamú ma séi siretí ankan má monó dafufin bákuya ída siretí ayan tentá kain na varéen nan mi sítípai ákona ano esantan inka siretíi yamusíen mino.” ");
INSERT INTO agd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Máa siran betí ankan Yisasin do fáken monó ánon banta kékái ánon banta amápin oriyákan Pita má dere vetin oyampá dakhafen manáa nentá oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Oren manáa vanta kayo ano mai namun ma vain dafu aúban ira sáden kumanen eúkukhan Pitan má maifin baren mino. ");
INSERT INTO agd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Bákan mana yoran arinta ano Pitan onan irará kumantan ben ádé eriven purefure en ódaren temí, “Ma vanta vá deren Yisasin má baren mino.” ");
INSERT INTO agd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Máa síkan Pita umeren temí, “Anasi oe, séi ída uron mi véin afová ukhé uno.” ");
INSERT INTO agd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Máa siren manáa vákan ena vanta vá ano yere óden temí, “Éin má dere veni kéká pintena vanta ono.” Síkan Pita umeren temí, “Ída ino. Téi ída veni eyo iyampon bá uno.” ");
INSERT INTO agd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Máa siran mana áau orivíkan ena vanta ano ákonaen temí, “Ma Kariri fáke vantan báken béin má deren ben má baréíkái fura siyá uno.” ");
INSERT INTO agd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Máa síkan Pita evaránen temí, “Banta oe, mai ma éi siyaona vaya séi ída uron mi afová ukhé uno.” Máa siyain má anan kókore asen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Asíkan Bafan mano yo vaéan Pitan oniyain má mai ma Bafan mano ma véin tiamen ma “Sare inuran kókore ma ída asikhantiya éi kanú manaú dádá téin nan ída afová ukhé uno sin nono.” Ma sen Pitan tiamikharé ein baya ovaren me inen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Iniyáken béi varufá araven morun kákan ifí den mino. ");
INSERT INTO agd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Máan tiyákan Yisasintá ma yafíká ein banta kayo ano véin máká maákáin baya siyáken ankamen mino. ");
INSERT INTO agd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Máan tiyáken béin auurá davaráe anan póké damuren ankamiyáken máa sen inaemí, “Éi sakhanampaí eya aví dano iye anó ankamiyan nafino.” ");
INSERT INTO agd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Máan tiyáken kokhon ída funtákein baya fóké béin asiren ankayanten mino. ");
INSERT INTO agd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Do khakhen ákurasí íkan man baya ma afová ukhein banta kéká bá monó ánon banta kéká bá ano manafin e átaru uaren Yisasin do aviren betíi uman ma yaimin banta kayo vaintá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Aviren moren betí ankan temí, “Éi mai ma Tiyarafenu ano ma vei vanasi evaránen avirano van ma aní ukhá ein banta ma éi vanteya setin tisimeno.” Síkan Yisasi evaránen temí, “Tiretí ankan ma siamékuya siretí ída mumunan inoná uno. ");
INSERT INTO agd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Inká téi ma manáa vaya ma siretí ankan baonafá ma ina ékuya siretí ída ovaráne sisiminona van muno. ");
INSERT INTO agd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Máan tukhantin taréa ráké ma orin nain Banta Anin mano Tiyarafenu ma kákan ákona vaini ayan kurompái kuman inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Máa síkan minó banta kayo ano inaemí, “Mai éi Tiyarafenu Anin na fono.” Síkan béi evaránen temí, “Mai inka siretiyantá ten nan pura se ono.” ");
INSERT INTO agd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Máa síkan betí ankan temí, “Inka veyantá be oo fóké mai vaya sí inétiferuna ída ena vanta sékun beni avúavá eman tian páman inten mino.” ");
INSERT INTO agd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Máa siren minó banasii ánon banta kayo ano e manten Yisasin do aviren Pairoti vaípá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mo khauren araíen ben daimiyáken máa semí, “Tetí ankan onékun ma vanta ano setisi vanta anasii avúavá máden asuse uren maen kamanin ma takisi amin dere are usintiyáken inká beyanan Tiyarafenu ano ma vei vanasi evaráné avirano van ma aní ukharé ein kin muno siyaren mino.” ");
INSERT INTO agd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Máa síkan Pairoti ano Yisasin inaemí, “Éi Yutan kayoi kin na fono.” Síkan Yisasi evaránen béin tiamemí, “Eyo mai inka eyantá te ono.” ");
INSERT INTO agd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Máa síkan Pairoti ano monó ánon banta kéká bá banasi vá máa sen tiamemí, “Ma vanta finte séi ída mana aau yosé uno.” ");
INSERT INTO agd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Máa síkan betí ákonaen temí, “Béi Karirí araí uren Yudiá ankinafá eúkiyáken banasi ará mantein monó baya o sen eriyan baren mi mará eren mino.” ");
INSERT INTO agd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Máa síkan Pairoti ano mai vaya iniren betí ankan inaemí, “Ma Kariri fákena vantá fino.” ");
INSERT INTO agd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Máa sen ina íkan betí ankan eyo siyaimpin maí damú Eroti yere Yerusaremí e varé íkan Pairoti ano afová en béi ma yafíkein bara akhen pákena vantan Yisasi van mino siren béi vaípá tiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Oriyain má Eroti ma Yisasin oniyan maen pefá beni vaya ana iniyáken béi onano van iyaren pasen béi manáa aní danasí intí onano van anunu iyáken kákantá amusin en mino. ");
INSERT INTO agd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Amusin iyáken béi ano Yisasin kokhon danasinta van inaiyaren mifo véi ída evaránen mana vaya véin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Máan tiyaimpin monó ánon banta kéká bá man baya ma afová ukhein kéká bá ano ádé e mantaven Yisasin ákonaen daimen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Daídan Erotin má bei aruvin banta kéká bá ano Yisasin máká maáká uren kini ayá au anamun uantáden evaránen tiantákan Pairoti vaípá oren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Oriyákan Eroti ano fefá Pairotin namuroí uantiyaren maen maí damú ana míkanan evaránen aronaíen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Máan turen mairá Pairoti ano monó ánon banta kéká bá banasii ánon banta kayo vá banasi vá arákan e átaru en mino. ");
INSERT INTO agd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","E átaru uvíkan betin máa sen tiamemí, “Tiretí ma vanta avireya se vaintá mere véi ano vanasii avúavá máden asuse iyaren mino sen ná maé tiretin avorá mai ma siyaona yanasinta van ina uré ída mana uman dosé uno. ");
INSERT INTO agd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Máan tékun Eroti má deren máan mana en mi siretí ankan onano van ma vanta ovaránen tiantan tetí barunafá erikhein mi séi ída kanaíé béi nan purino senté uno. ");
INSERT INTO agd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Máan tukhein nan mi véin dafiyó anan ankádé tiantékun orinten mino. ");
INSERT INTO agd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Máa síkan minó nanin banta ano mana mani oovararen temí, “Barabasin utúantesin tetimpin eriyantiya mai vanta aruan purono.” ");
INSERT INTO agd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasi maen kamanin ma aruvin araí uren banta arin púbíkan mai van béin pákaan karavusifin kain baren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pairoti ano Yisasin utúantantin orino van enádá bá betin inaen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ina iyákan betí ankan para oovariyan báken temí, “Arono, véin daa unkamádantá arono.” ");
INSERT INTO agd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Máa sen oovariyaimpin Pairoti ano kanú manaú dádasí en betin tiamemí, “Para vae. Téi ída ma vanta fintena mana uman dosikheruna ída kanaíé béin nan purinten mino senté umpo véi nái yaná auisá ukha vae,” siren béi semí, “Máan tukhein nan mi véin dafiyó ana ankádé tiantékun orinten mino.” ");
INSERT INTO agd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Máa síkan Pairoti ano Yisasin daa unkamádantá arino van betí moékentá ákonaen oovariyan béini vaya yararen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Máa siyaimpin Pairoti ano vetí ankani vaya ánain dakhafen Yisasi nan purino sen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Máa siren betí ankani anunu yakhafen Yisasin betin ayampin amiyáken mai ma kamanin má aruvin araí uren ma vanta aruan púdan ma fakaan karavusií uran baré ein banta utúantan oren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Máan turan aruvin banta kéká ano Yisasin do aviren oriyaré íkan mana Saimonin ne sin Sairiní baru fáke vanta ano Yerusaremí ódono siren eriyaréin mai vanta fákaren duvun íkan Yisasini yaa unkamádan mamaren ben ánain bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Oriyákan kokhon nanin banta ano Yisasin bákuriyan manáa nanin kayo ano ifisana yariyan béi nan e ifí den oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Máan ten oriyá íkan Yisasi yo vaében betí ankan tiamemí, “Yerusaremí nanin kéka soe, se nan ída ifí diyákeya sirétiyan má tiretí akhafana va san mana vá ífí dano. ");
INSERT INTO agd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Para vara seyo, ínaimpá damú afoká inti mae siretí máa sin nono, ‘Aa nanin kayo ma arápin ída iyampon báin ma inká ída ma iyampon nan kuven ma ukhein kéká ano vá amusin ino.’ ");
INSERT INTO agd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Máa siren maen ‘Kákan anuyon kayo van betí máa sinten mino, “Un kaure setin dararano,” inká tító anuyon kayo van “tetin maman aúpasí ono.” ’ ");
INSERT INTO agd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Máa sinten mifo vanasi ano ma auyen daa ma irafin karúdantin maen ída kamaen kanten mifo kakhein daa ma irafin karúdantin maen ainen mi kanten mino. Máan mana en mi séi funtákeruna vanta ma namu avúavá usintiyaré esin maen Tiyarafenu ano namu nanin banta moékakhein uman mi aminten mino.” ");
INSERT INTO agd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aruvin banta kayo ano ena aau vantá kan Yisasin má arintin purino van aviren oren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aviren Ánon Dampa e siyain dontá o unaven Yisasin aúban kaúden aau vantá kanan pintena mana Yisasini ayan kurompá kaen maen ayan ópá ena vanta khaen uren aren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Máan turen aruvin banta kayo ano Yisasini ona varé oreraono van kati siyákan Yisasi máa semí, “Tifóe oe, vetí ankan ída afová ukhen mi mai yaná bariyan mifo vetíi ume vá ampiantano.” ");
INSERT INTO agd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Máa siyákan banasi ano mairá mantakhen oniyan maen ánon banta kéká ano Yisasin así mun uantiyan temí, “Ena nanin banta kayo anan ayaen noren mifo Tiyarafenu ano ma vei vanasi evaránen avirano van ma aní ukhá ein banta ma vanten maen áesin beyantá kanaíen beyan aya ino.” ");
INSERT INTO agd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Máa siyákan aruvin banta kayo ano yere eriven béin nan tiren intiyáken íta uvaini amiyan ");
INSERT INTO agd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","temí, “Éi fura se ma Yutan kayoi kin ma vanteya eyantá eyan aya ono.” ");
INSERT INTO agd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Máa siren béin ánontá, “MA YUTAN KAYOI KIN MINO” sikhein bompon uvaman kaen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Máan turan aau vantá kan ma arukhá ein pinté mana ano Yisasin máa sen oyampá baya semí, “Éi Tiyarafenu ano ma aní ukhá ein banta ma vanteya eyan aya uare verasan má dere siya ono.” ");
INSERT INTO agd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Máa síkan ena vanta ano mai vaya iniren mai vanta asiyan temí, “Ma vanta ma variyainí ukhein uman manan e má dere variya ompo éi ídá Tiyarafenu van periya fono. ");
INSERT INTO agd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Erasan ma variyá eruna avúavákái ma uman bariyá umpo ma vanta ano ída mana aauí ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Máa siren béi semí, “Yisasi oe, éi ma ei yafisin aúpin ma orinona yamusá téi nan inisintano.” ");
INSERT INTO agd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Máa síkan Yisasi evaránen béin tiamemí, “Téi fura siré éin tiamiyá uno. Taréa anan téin má inarufá ban nono.” ");
INSERT INTO agd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Bayan aúbaní iyain má títípa ano ma vara yaranten bákan kanaú manaú áauí iyain má do kakhen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Máan tiyan maen áaui fanu kípiyain má anan kákan monó namumpin ma kákan davaráe khuran baré ein mano veyantá áubáná kanáaren maman kankananíen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Máan tíkan Yisasi avádóden oovaren temí, “Tifóe oe, se saunan éin ayan arumpin kaé uno,” siyan puren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Máan tíkan aruvin banta kayoi yafisin banta ano mai yaná ódaren Tiyarafenu aví maman daní iyáken temí, “Pura uron ten ma vanta ída aau van puntákein banta ino.” ");
INSERT INTO agd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Máa siyákan mai ma ariyain ma onano van e iyukharé ein nanin banta ano mai yanasinta ódaren arunaná pinté evaránen betíi varufá oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Máan tiyákan Yisasin arona kayo vá béin ma yakhafen Karirí me ampiren erikhá ein nanin kayo vá ano manáa nentá e mantakhen mai yanasinta ma afoká iyain oniyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Banasii ánon banta kéká pintena mana Yosepin ne sin kamaen puntákein banta varen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Béi maen Arimatiá se sin Yudiá barafin bain baru ráke vanta váken béi Tiyarafenui yafisin baru van ave ukhen pasen ena ánon banta kayo ano ma Yisasin arono van tiyain baya van ída ará manafiní ukharen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Máan tukharen mai vanta ano Yisasin au ifá intí barano van Pairoti vaípá mo inaen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ina íkan kana ino síkan mai vanta ano Yisasin au un mamádan barará eravíkan efanten davaráe fóké uke uke uren ompin mana masí boraádan bákan maifin ída mana vanta khaúkaré ein masípin baren mo khaen mino. ");
INSERT INTO agd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sabati ráke yanasinta utaren arakhókuin damú baré íkan ádé anantá Sabati araí ono van en mino. ");
INSERT INTO agd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Máan tiyákan Karirí má me ampiren ma Yisasin bákuren erein nanin kayo ano Yisasin au ma masípin kain nain onano van Yosepin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ódaren mai nanin kayo ano evaránen betí amápin oriven manáa aunka uveri vá pauran kayo vá utaádaren man baya ano ma sikheiníen Sabati yamú avíken mino. ");
INSERT INTO agd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Santé pe ákura suron anasi kayo ano mai ma kama aunka iyain uveri ma utaádan baré ein mamaren masíká oren mino. ");
INSERT INTO agd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Betí ankan oren o onákan masí oyirá ma iyádan baré ein onámaná ano e vaébaé en orikharen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Máan tukheimpin betí ankan maifin ódiven onákan Yisasin au ída varen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ída vákan betí ankan mairá mantakhen mai van kokhon ineine iyan baré íkan kankánan banta ano vetin ádé e mantavíkan míkani auí daná kaké moéken afayu ma fanu seiníen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Máan tíkan mai nanin kayo ano akhokho van iyáken anuran bara finí íkan mai kanan banta ano máa semí, “Tiretí ankan pará purin banta kayoi varu finté ma evaránen aunan mamaren ma e mantakhein banta van me yosiya rafono. ");
INSERT INTO agd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Béi fefái aunan mamaren e mantakhen mafin ída van mifo véi ma Karirifá báken ma siretin tiamiyaré ein baya vá ovare me ineno, ");
INSERT INTO agd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Banta Anin ume vanta kayo ayampin amintin ná mai kéká ano véin daa unkamádantá arintin púkaren kanú manaú damusí ma intin ná béi evaránen aunan mamaren e mantano,’ sen béi siretin tiamikharen mino.” ");
INSERT INTO agd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Máa síkan mai ma véi sikharé ein baya vetí ankan ovaren me inen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ovaren me iniren betí ankan masí me ampiren evaránen orein mano mo siyan míkan mifo sirantan mana orun kádan (11) eyo iyampon kayo vá ena nanin banta kéká bá mai ma afoká ein danasinta van tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Makdaráke nanin Maria má Yoana má inká Yemisin anóe Maria má ena nanin kayo vá anon masíká orikharen mi mai ma afoká ein danasinta van eyo iyampon kayo me siamen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Máa síkan eyo iyampon kayo ano vetin nan kampun bayan tiyan mino siren betíi vayará ída mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Máa síkan Pita e manten tavaen masíká orein maifin o mátimen onákan davaráe kayo ana vaimpin béi evaránen mápin oriyáken mai náisá ukhen nafi siren kokhon ineine en mino. ");
INSERT INTO agd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Anasi kayo ma masíká orein damú anan kankanan eyo iyampon mano Yerusaremíké tiyan míkan mifo sirantan mana orun kádan (11) kiromitará ma vain baru Emeasí oren mino. ");
INSERT INTO agd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Oriyáken mai ma afoká ukhein danasinta van e sen oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Míkanan mano mai yanasinta van kokhon baya sen oriyákan Yisasi vékanani ádé afoká uven békan má oren mino. ");
INSERT INTO agd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Oriyákan manáa yaná ano vékanan auurá iyábíkan Yisasi ino sen ída oman afová en mino. ");
INSERT INTO agd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ída afová íkan béi míkanan máa sen inaemí, “Tiré kanan nái vayá té oriya fono.” Síkan míkanan o mantavin békanan auná ano arunaná bá ma vainíen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Máa sen ina íkan míkanan pinté Kireopasin ne sin banta ano evaránen béin inaemí, “Éi enafákesá erikheyá Yerusaremí barufin ma saréá afoká ukhein danasinta ída afová ukhe fono.” ");
INSERT INTO agd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Máa síkan Yisasi vékanan evaránen inaemí, “Nái yanasinta fino,” síkan békanan evaránen béin tiamemí, “Nasaretíke Yisasin ne sin banta mai véi sakhanampa vanta váken Tiyarafenu avorá bá banasi avorá bá ma vaya seipá ákonaen baya siyáken doriyaré ein banta amaniná ma mai yanasinta afoká ukhein nan mi siyá uno. ");
INSERT INTO agd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tetisi monó ánon banta kéká bá banasii ánon banta kayo vá ano véin kamanin ayampin kaíkan kamanin mano véin nan arintin purino síkan daa unkamádantá béin aren mino. ");
INSERT INTO agd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tetí ankan béin nan mumunan iyáké Tiyarafenu ano ma Isareri nanin banta evaráné avirano van ma aní ukharé ein banta ino siyá ékun mi véin arin púbíkan kanú manaú damusí ma iyain má mai ná dákó en mino. ");
INSERT INTO agd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Taréa fe ákura suron tetisi kéká pinté manáa nanin kayo ano masíká o onákan ");
INSERT INTO agd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","béin au ída vaimpin ovaránen tetí ankan tinú deruna vaya me sisimiyáken enisori kayo onékun mai kayo ano Yisasi nan evaránen aun mamaren e mantakhen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Máa síkan tetí ankan pinté manáa vanta kéká ano masíká oriven mai ma anasi kéká ano ma sein danasinta onen mifo véin ída onen mino.” ");
INSERT INTO agd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Máa síkan Yisasi vékanan tiamemí, “Tirékanani ineine ída vákai sakhanampa vanta kayo ano ma minó baya sikharé ein nan ída aine mumunan iya ono. ");
INSERT INTO agd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mai ma Tiyarafenu ano ma vei vanasi evaránen avirano van ma aní ukharé ein banta ano vá uman nare mamaren ná ínaimpákesá Tiyarafenui kakhampin un perano ma sikharé ein tiré kanan ídá afová ukhe fono.” ");
INSERT INTO agd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Máa siren Mosesi ma uvamádan baya ráké nare araí uren minó sakhanampa vanta kayo vá ano ma Tiyarafenui vompon dókifin ma veyan nan tiádan baré ein baya kayo míkanan tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Máa sen oriyaren betí kanú manaú ma vano van inikharé ein Emeasi varu ádé ma oríkan maen Yisasi manáa vá orono van en mino. ");
INSERT INTO agd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Orono van íkan békanan mano véin ákonaen ayópá iyáken temí, “Ádé anantá áau orun peranton iyain duninten mifo verasan má bano.” Síkan béi míkan má bano van mápin oren mino. ");
INSERT INTO agd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ínaimpáké betí ankan dunan nano van íkan Yisasi míkan má dunan nan takhoká kumamen bereti máden Tiyarafenun tusu siantáden békanan kisian amen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Máan tiyain má békanan auu sapé tíkan béin afová en oniyain má manádá afeyóbíkan ída onen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ída oniyáken míkanan ben inain maran iyan temí, “Erasan ma aayanafá eriyákun ma Tiyarafenui vompon pintena ana vaya ma sisimiyákan maen erasan tirá mantiyaren mino. ");
INSERT INTO agd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Máa siren míkanan ainen e manten Yerusaremí oren o onákan tiyan míkan mifo sirantan mana orun kádan (11) eyo iyampon kayo vá manáa kéká bá iyukhen baren mino. ");
INSERT INTO agd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Iyukharen máa sen békanan tiamemí, “Bafan mano evaránen e mantakharen pura sen Saimonin avorá dákosí ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Máa síkan inká békanan mano aayanafá ma afoká ein danasinta vá inká bereti ma kiseintá ma oman pámanein má betin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Betí ankan mai ma afoká ukhein baya van para siyan baré íkan Yisasi veyantá mai aúbaná e mantaven máa semí, “Ará kusin masá bano.” ");
INSERT INTO agd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Máa síkan betí ankan ma inein mano mana van mi oniyá uno siren anú diyáken akhokho van en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Máan tíkan Yisasi vetí ankan máa sen tiamemí, “Pará tiretí ankan anú diyákeyá kokhon ineine iya rafono. ");
INSERT INTO agd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Téin bá umpo siyan tirantan oniyákeya su siruvúan onano. Téin tu ma oniyaonaíen ban kayo aurá ída amasi vá ayampa vá banten mino.” ");
INSERT INTO agd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Máa siren be ayan arantan betin aníen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ani urákan betí ankan amusin mana iyáken ída mumunan inton kokhon ineine iyaimpin betin inaemí, “Tiretí ída manáa yunan mafin denan ban nafino.” ");
INSERT INTO agd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Máa síkan iyó uádan noyana manáa maman amíkan ");
INSERT INTO agd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","betí ankan avorá béi mai noyana máden niyákan onen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Oniyákan béi máa sen tiamemí, “Téi ma siretin má ma fara váké Mosesini man baya vá sakhanampa vanta kayoi vaya vá í bompon má ano ma séin pákena sikharé ein mai minó daná ano vá pura sen afoká ino sé pefái mai yanasinta van tiamikharé uno.” ");
INSERT INTO agd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Máa siren béi Tiyarafenui vompon dóki fintena vaya ana vetí ankan kamaen inino van afova amen mino. ");
INSERT INTO agd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Béi máa sen betí ankan tiamemí, “Tiyarafenui vompon dókifin máan mi siádan baren mino, Tiyarafenu ano ma vei vanasi evaránen avirano van ma aní ukhá ein banta ano vá uman baren púaren ná kanú manaú damusí ma intin ná evaránen masí pinté e mantano. ");
INSERT INTO agd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Béin avisá minó nanin bantafin tiamintin ná ará baerantin Tiyarafenu ano vá betíi ume ampiantano. Mai yoran Yerusaremisá araí ino. ");
INSERT INTO agd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Máa sikharé ein paseya siretí anon ma ma afokái ma oneona yanasinta vá ena nanin banta mo siameno. ");
INSERT INTO agd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tiretí ankan ma fefá te Sifóe ano ma Kantá Aunan ma iyáantákaré ein mai séi siantékun tireti vaípá eranten mifo ma kákan barurá ana vá bare vá ínaimpákesá mai Tiyarafenui ákona vá baran nono.” ");
INSERT INTO agd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yisasi vetí ankan avían Betaní moren ayan daní uren avu uanten mino. ");
INSERT INTO agd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Avu uantiyákan Tiyarafenu ano véin aviran betin me ampiren inarufá óden mino. ");
INSERT INTO agd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ódivíkan betí ankan aron durafúden bentá monó tiantáden amusin iyáken Yerusaremí evaránen óden mino. ");
INSERT INTO agd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","O váken ena ena vetí ankan monó namumpin Tiyarafenu aví daní iyan baren mino. ");
INSERT INTO agd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Esé araíen minó daná ída afoká ukhan Baya varen mino. Baya ano Tiyarafenu vá báken mai Vaya ano Tiyarafenun baren mino. ");
INSERT INTO agd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Esé araíintá Baya ano Tiyarafenu vá baren mino. ");
INSERT INTO agd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tiyarafenu ano véin pinté anan minó daná uvamádan afoká ukhen mifo mana yaná ano veyan táké ída afoká ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ayun ma fara van oriyan ban aunan béimpin bákan mai aunan manon minó nanin banta oon uruanten mino. ");
INSERT INTO agd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mai oon mano sítípafin kiyan bákan maen títípa ano ída véin iyákaren mino. ");
INSERT INTO agd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tiyarafenu ano monó non péantan banta Yonin tiantan eren mino. ");
INSERT INTO agd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mai ma erein béi ano mai ooni vaya sian amá urantin minó nanin banta ano veni vaya iniren mumunan ino van mino. ");
INSERT INTO agd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mai ooni vaya máa sian amá ono van mi Yoni eren mifo véi ída mai oon mino. ");
INSERT INTO agd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mai ma fura sikhein oon mano ma vanasi kakhaantiyain manon ma varará eriyan mino. ");
INSERT INTO agd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tiyarafenu ano véin pinté uaren bara uvantaré íkan béi ma varará e van mifo vanasi ano ída véin oman afová en mino. ");
INSERT INTO agd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Béi vei vara anará erin mifo vei kéká ano ída véin aviren mino. ");
INSERT INTO agd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ída aviren mifo véintá ma mumunan ein nanin bantan maman Tiyarafenu akhafanaíen mino. ");
INSERT INTO agd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Betí ankan be anóe afóeni narera safi aui anunura safi vantai anunura safi ída Tiyarafenu akhasí ukhen mino. Tiyarafenu ano veyantái vetin maman be akhasí ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Baya ano vantaí uven ma varará tetin aúbaná baren mino. Tetí ankan inka veni kakhani ákona oné tiféuno. Mai mana iyampon ma ve Afóe ano siantan ma ereini kakhan bákan inká beni sarisari vá puntákein avúavá bá béimpin bíkakhen mino. ");
INSERT INTO agd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Mai van mi Yoni máa sen oovaren banasi siamemí, “Ten toyampá ma eriyain banta mai séi ída vákun béi fe vá ein bantan bákan beni ákona ano séin esantakhá ma vanta van mi séi fefá tiretin tiamikharé uno. ");
INSERT INTO agd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mai vantafin tarisari ano moéken bíkakhái setí ankan ena ena yamú beni avábá bariyá tiféuno. ");
INSERT INTO agd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Para vara seyo, Mosesin pinté uaren mi Tiyarafenu ano setí ankan man baya simen mifo sarisari vá puntákein avúavá bá mai Tiyarafenu ano ma aní ukhein banta Yisasin pinte nan baré tiféuno. ");
INSERT INTO agd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ída mana vanta ano Tiyarafenun onten mifo ve Anin mano anan be Afóen ádé báken mai véi Tiyarafenun ban mi ve Afóeni vaya setin tisimen mino. ");
INSERT INTO agd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yutan nanin bantai anon banta kayo ano monó doran banta kayo vá Rivai kayo vá tiantákan Yerusaremí me ampiren Yonin mo máa sen inaemí, “Éi Tiyarafenu ano ma aní ukhein banta fono.” ");
INSERT INTO agd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Máa síkan Yoni mai vaya ída umeren mifo amáká máa sen tiádemí, “Tiyarafenu ano ma aní ukhein banta va uno.” ");
INSERT INTO agd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ída ino síkan betí ankan béin inaemí, “Mai éi sakhanampa vanta Iraiya fono,” síkan “Béi va uno” siyaimpin evaránen inaemí, “Mai éi sakhanampa vanta fono” síkan “Ída ino” sen mino. ");
INSERT INTO agd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Máa siyaimpin evaránen béin inaemí, “Mai éi eyan nan iye unó tiya fono. Setin tisimesirá evaráné mai ma sisintá erikheruna kayo mo siameno.” ");
INSERT INTO agd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Síkan Yoni vetí ankan tiamemí, “Pefá ma sakhanampa vanta Aisaiyan oorá ma sen kámá bara fáké ma oovaren, ‘Bafani aa funtarano’ ma sikhá ein mai séi uno.” ");
INSERT INTO agd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Máa siyaimpin mai ma Farasisi kéká ano ma siantan erikhá ein kéká ano Yonin máa sen ");
INSERT INTO agd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","inaemí, “Mai éi ma ída Tiyarafenu ano ma aní ukhein banta fo Iraiya fo áa sakhanampa vanta fo ma vanteya mai fará banasi monó non péantiya fono.” ");
INSERT INTO agd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Máa siyaimpin Yoni evaránen betí ankan tiamemí, “Téi nompói féantiyá umpo sirétin aúbanápin mai mana vanta váka ída afová ukha ono. ");
INSERT INTO agd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Téi ída funtákeruna ída kanaíé mai ma sen toyampá eriyain bantai arantan anamun anan útufonté uno.” ");
INSERT INTO agd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yodení non ufá mana sító baru Betaní Yoni monó non péantiyákan mi mai yaná afoká en mino. ");
INSERT INTO agd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ená damú Yisasi ma Yoni vaintá eríkan ma onen máa semí, “Onano. Mai Tiyarafenui sipisipi arará ino. Ma vara ráke nanin bantai ume ma arúantan mino. ");
INSERT INTO agd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ten toyampá ma eriyain banta mai séi ída vákun béi fe vá ein bantan bákan beni ákona ano séin esantakhe ne ma séku inikhá eona mai ma vanta van mi sikharé uno. ");
INSERT INTO agd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Téi ven ída afová é amino ukhéi Tiyarafenu ano ma aní ukhein banta ino sen Isareri nanin banta ano afová ino van mi monó non máan péantiyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Máa siren Yoni sian dákóen mí, “Téi onékun inaru fáké kukhofá nun avúaváká ten Kantá Aunan mano ven ánontá eren mino. ");
INSERT INTO agd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","‘Eren mifo séi seyantá bein ída afová ukhékun mi Tiyarafenu ano séin tisintá me vanasi nompó péantiyá uno. Pefá Tiyarafenu ano séin máa sen tisimikharen mino. Onesin ma mana vanta ánontá ma Kantá Aunan ma eran nain mai vanta anon Kantá Aunan póké banasi non peántanten mino.’ ");
INSERT INTO agd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Máa sikhareí téi ódaréi Yisasin nan Tiyarafenu Anin mino sé tian amá é uno.” ");
INSERT INTO agd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Máa sirákaren ená damú Yoni evaránen bei eyo iyampon kanan má mairá o mantakharen mino. ");
INSERT INTO agd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mantakharen onan Yisasi entavíkan Yoni semí, “Onano. Mai Tiyarafenui sipisipi arará ino.” ");
INSERT INTO agd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Máa síkan mai eyo iyampon kanan mano iniren Yisasin avákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Avákuren oríkan Yisasi yovaéan onen békanan máa sen inaemí, “Nái vará dosiyan tafono” síkan. Békanan evaránen inaen temí, “Aru soe, inte namuná éi vaonafino.” ");
INSERT INTO agd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Máa síkan Yisasi evaránen békanan tiamemí, “Tiré kanan eriveya onano,” siren kamí kamí áauí iyákan aviren be ma vain namumpin o vákan e varen dunin baren mino. ");
INSERT INTO agd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kankanan banta ano ma Yonin avaya ma iniyá ein pinté Saimon Pitan afá aváen Enduru anon Yisasin avákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","O varen ma Yisasin me ampiren maen Enduru ma esé daná barein mai ve afá aváe Saimonin dosiren máa sen tiamemí, “Tetí ankan inka Mesian oné uno.” (Mesia ne ma siyain mai máan mi sikhen mino. Tiyarafenu ano ma aní ukhein banta ino.) ");
INSERT INTO agd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Máa sen tiamiren Enduru ano Saimonin aviren Yisasi vaintá oríkan Yisasi véin ódaren temí, “Yonin anin Saimoni oe, éi nan ínaimpá Sifasin ne sinten mino. Mai avíi ana Kiriki vaya finté Pitan nen tikhen mino. ");
INSERT INTO agd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ená damú Yisasi Karirifá orono van iyaren Firipin onen tiamemí, “Éi ere sen tivákurono.” ");
INSERT INTO agd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Endurun nú Pitan núi varu ana Betsaidái vákan Firipin má dere mai varu ráke vanta ino. ");
INSERT INTO agd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Firipi ano Natanierin o omáken tiamemí, “Mosesini man bayafin má sakhanampa vanta kayoi vompompin má ma sikhá ein mai vanta Yosepin anin Nasaretíké Yisasin baréíi setí ankan inka oné tiféuno.” ");
INSERT INTO agd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Máa síkan Natanieri evaránen béin inaemi, “Nasaretíké kaná mana kama yaná afoká inten nafino.” Síkan Firipi evaránen béin tiamemí, “Erikhe vá onano.” ");
INSERT INTO agd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Máa siran Yisasi vaintá Natanieri eríkan ódaren temí, “Onano, ma vantafin ída mana kampun baya vá avúavá bá bákan béi Isareri vanta uron mino.” ");
INSERT INTO agd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Máa síkan Natanieri evaránen Yisasin inaemi, “Éi intesá ureyá téin afová ukhare vae,” síkan Yisasi evaránen béin tiamemí, “Firipi ma ída éin arakhaya fiki yaa anafin baná téi éin ontaré uno.” ");
INSERT INTO agd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Máa síkan Natanieri evaránen béin tiamemí, “Aru soe, éi Tiyarafenu Anin Isareri kayoi kin mono.” ");
INSERT INTO agd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Máa síkan Yisasi evaránen béin tiamemí, “Téi fiki yaa ana ráke éin oné uno ma seruna mairasá éi mumunan iya fono. Ínaimpáké mai esantakhein kákan danasintan onan nono.” ");
INSERT INTO agd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Máa siren béin tiamemí, “Téi fura siré tiretí ankan tiamiyá uno. Ínaimpáké tiretí onesin maen inaru ona yivintin Tiyarafenui enisori kayo ano Banta Anintá ódiven eraven inten mino.” ");
INSERT INTO agd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kan damú orivíkan Kariri varafin Kaná barurá anasi iran omá bákan maifin Yisasin anóen aran o varen mino. ");
INSERT INTO agd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yisasin má bei eyo iyampon kayo vá dere arákan mai omápin o varen mino. ");
INSERT INTO agd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","O varé íkan uvaini kípavin be anóe ano Yisasin tiamemí, “Uvaini inka kípakhan mino.” ");
INSERT INTO agd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Máa síkan Yisasi evaráne vein tiamemí, “Tinóe oe, pará téin e saraan maifin kaiya vae. Ída senti yamú erikhá uno.” ");
INSERT INTO agd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Máa síkan be anóe ano yoran banta kayo siamemí, “Béi ma siamin nain baya ánain ná dakhafe vá mai yaná barano.” ");
INSERT INTO agd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yutan kayo ma vetíi monópin ma variyain avúaváká ma non peré iyain bara kave máa yan manápá ifo afápá mana un kádan bákan mai mana mana kavefin mana antareti (100) ritan non báiyan mino. ");
INSERT INTO agd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yisasi yoran banta kayo siamemí, “Kave kayofin non dáan bíkano,” síkan betí ankan non dáan mai kave kayo vikaan kaen mino. ");
INSERT INTO agd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Bíkarákan Yisasi mai yoran banta kayo siamemí, “Mai fintena manáa non dafeya omá afóen mo ameno.” Síkan betí ankan dafen mo amen mino. ");
INSERT INTO agd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Amíkan mai ma omaká dafíkáien banta ano mai uvaini máden naan onákan ase iyaimpin mai uvaini inte fáken nafi véi ída avofá ukharen mifo mai ma non dáan me amein kayo ano anan afová ukharen mino. Máan tukhan mai omá afóe ano anasi ma iman amin nain banta araren ");
INSERT INTO agd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","béin máa sen tiamemí, “Kama ase ma iyain uvaini naren masiman uran ma minó banta kayo ano ma naran amu aruvin maen mi ínaimpákéi ída ase uvaini amiyain mi éi kama uvaini fara kaúdákareya saréan bare ere ono.” ");
INSERT INTO agd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Máan mi en Kariri varafin Kaná barurá Yisasi araíen enará ukhein daná ma afoká ein mai vei kakhan má ákona vá aní uran mai van mi vei eyo iyampon kayo ano ódaren béintá mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Máan turan mai oyampáké Yisasi ve anóen má be afá kéká bá bei eyo iyampon kayo vá Kaná baru me ampiren Kapeniamú barurá manáa yamú orun baren mino. ");
INSERT INTO agd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Baré íkan Yutan nanin bantai Avo Uantan Damú ádé iyaimpin Yisasi Yerusaremí oren mino. ");
INSERT INTO agd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Oriven onákan monó dafufin kao vá sipisipi vá kukhofá nun kayo vá sarí iyákan inká moní ma arumin kayo ano karáká kumaniyan kumantan mino. ");
INSERT INTO agd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Máan tiyákan Yisasi mana ákona anan máden unen unaren mai anan dafiyó póké mai ma monó dafufin ma yan baré ein kao vá sipisipi kayo vá ankamen intaniyáken moní ma arumiyá ein kayo vá dere vanaan karúdaren minó tiantan barufá araven mino. ");
INSERT INTO agd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Araviyain má dovaéaren kukhofá nun kayo ma yáken sarí iyá ein banta kayo siamemí, “Mai yanasinta mamare orono. Ída vá Tifóen amá minó daná kaúdiyan ma miyan baran namuní ono.” ");
INSERT INTO agd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Máan tiyan ma mai avúavá bei eyo iyampon kayo ano oniyáken Tiyarafenui vompon dókifin ma máa sikharé ein baya ovaren me inen mino. “En ama san tiran nakhan mai ano súpin ira ma kheiní iyan mino.” ");
INSERT INTO agd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yisasi máan tiyain má Yutan kayoi ánon banta kéká ano mai avúavá ódaren béin máa sen inaemí, “Tiyarafenu fintena ma éi mai avúavasí in ákona ma mantanteya mae mai éi mana enará ukhein aní daná aní í óderá mai fura yaná ino seno.” ");
INSERT INTO agd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Máa síkan Yisasi evaránen betí ankan tiamemí, “Tiréti ankan ma kákan monó namun ma varákuresí maé téi kanú manaú damú anan evaráné uvaman kípanté uno.” ");
INSERT INTO agd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Máa síkan Yutan kayo ano evaránen temí, “Foti sikhisi (46) oranarái ma kákan monó namun uvantein mifo éi kanú manaú damú aná uvaman kípantó tiya vae.” ");
INSERT INTO agd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Máa sen mifo mai Yisasi ve au van mi kákan monó namuntá o siáden mino. ");
INSERT INTO agd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Béi ma masí pinté e mantavin maen mi veni eyo iyampon kayo ano mai ma sikhá ein baya afová uren mi Tiyarafenui vaya ma vompon dókifin uvamádan baré ein má Yisasini vaya vá ovaren inen mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Avo Uantan Damú ma Yisasi Yerusaremí báken ma kokhon enará ukhein danasinta ma aníin onein nan minó nanin banta ano véintá ana mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Máan tiyan Yisasi minó nanin bantai ineine afová ukhen pasen betí ankan ída kamú máan amen mino. ");
INSERT INTO agd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mai véi ída afova van o afasí ukhantin pasen mana vanta ano ída véin tiaminten mino. Para vara seyo, minó nanin bantai avúavá bá ineine vá béi fefá afová ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mana Farasisi vanta Nikodimasi maen Yutan kayoi ánon bantan baren mino. ");
INSERT INTO agd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Baren mana inúpá duntein pinté Yisasi má baya seno van eriven béi semí, “Aru soe, setí ankan minó ano éin afová ukhékun Tiyarafenu ano setí ankan afova simeno van tiantaya erikha ompo mana vantafin ma Tiyarafenu ma ída vantin maen éi ma enará ukhein danasinta ma uvariyaonaíen ída uvaranten mino. ");
INSERT INTO agd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Máa síkan Yisasi evaránen béin tian amá uan amemí, “Téi fura uron tiré éin tiamiyá uno. Banasi ano ma ída evaránen auyení inain mano ída kanaíen Tiyarafenui yafisin baru onanten mino.” ");
INSERT INTO agd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Máa síkan Nikodimasi evaránen béin inaemí, “Intesá uren ná anon bantaí ma uvin nain mano evaránen auyení intéi vae. Be anóen arápin ná evaránen un pébintin ná enádá kainten nafino.” ");
INSERT INTO agd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Máa síkan Yisasi evaránen béin tiamemí, “Pura uron tiré éin tiamiyá uno. Banta ano ma non nú Aunan núká ma ída auyení inain mano ída kanaíen Tiyarafenui yafisin barufin oferanten mino. ");
INSERT INTO agd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Au ano ma afoká é iyain daná mai au ina ifo Kantá Aunan mano ma afoká é iyain mai yaná Kantá Aunan nina ino. ");
INSERT INTO agd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Evaráneya auyení ono ma séi siyaruna vayará éi ída vá anú duman duman ono. ");
INSERT INTO agd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Uva ano vei anunurái minó pimpá orera iyákaya avaya anan iniyákeya inte fákesá eriaren intefasá oriyan nafi mai ída afová éiya ono. Kantá Aunantá ma auyení iyain kayo ano máan manan ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Máa síkan Nikodimasi véin evaránen inaemí, “Mai ma siyaona yaná intesá en ná afoká intéi vae.” ");
INSERT INTO agd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Máa síkan Yisasi evaránen béin tiamemí, “Éi Isareri kayoi arú banta ompo intesá ukhayá ma yaná ída afová iya vae. ");
INSERT INTO agd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Téti ankan ódaré afová ukheruna yana san mi fura siré tiretin tiamiyákeyai siréti ankan mai vayará ída mumunan iya ono. ");
INSERT INTO agd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Téi ma vara rákena yana san mi siyákeya siretí ída mumunan iya ompo inaru rákena yana san ma sékuya intesá ureyá mairá mumunan inte fono. ");
INSERT INTO agd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ída mana vanta ano inarufá ódikhen mifo Banta Anin mano veyákái inaru fáké erakhein béi anan evaránen ódinten mino. ");
INSERT INTO agd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pefá ma vanta ída van kámá barafin ma Mosesi ano ma osafáe aman manon uváden daa amankampin ma intáneiníen Banta Anin maman daní urantin ma ");
INSERT INTO agd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","véintá mumunan inain nanin banta ano ída kípan para van oriyan ban aunan baranten mino. ");
INSERT INTO agd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Para vara seyo, Tiyarafenu ano auuanon tákena mana ain iyampon uró dákaren barará nanin banta van moéken anunu uaren mai iyampon betí ankan amen mifo véintá ma mumunan inain nanin banta ano ída o afeyoran para van oriyan ban aunan baranten mino. ");
INSERT INTO agd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Banasi yaimin novara Tiyarafenu ano ve Anin tiantan barará eren na ino. Béi ma vara rákena nanin banta aya uren evaránen avirano van mino. ");
INSERT INTO agd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tiyarafenui auuanon tákena mana iyampon uró ma vaintá ma ída mumunan iyain nanin banta kéká pefái yaimáan afeyorampin ban mifo mai mana iyampontá ma mumunan iyain kayo ano ída afeyoranten mino. ");
INSERT INTO agd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mai ma yaimin naini ana máan mi ukhen mino. Kakhan ma varará erakhen mifo vanasi ano namu avúavá anan bariyan kakhan nan ída aran niyan mino. ");
INSERT INTO agd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Namu avúavá ma variyain kéká ano mai kakhani namuron báken betíi avúavá maman dákó inain nan péden ída kakhantá erinten mifo ");
INSERT INTO agd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","funtákein avúavá ma variyain kéká anon kakhantá erintin Tiyarafenui ákonarái yoriyan mino sen onanten mino.” ");
INSERT INTO agd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Máa siren mai oyampáké Yisasin má bei eyo iyampon kayo vá ano Yerusaremí me ampiren Yudiá barafá o váken banasi monó non péantiyaren mino. ");
INSERT INTO agd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Máan tiyákan monó non péantan banta Yoni ano Aenoní barurá Sarimí ádé bákan mairá kokhon non eraviyákan banasi ano monó non perano van eríkan Yoni vetí ankan monó non péantiyaren mino. ");
INSERT INTO agd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mai Yonin ma ída karavusifin pákaan kaúdakan mi máan tiyaren mino. ");
INSERT INTO agd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Máan tiyain damú ana Yonini eyo iyampon kayo vá mana Yutan banta vá ano Tiyarafenu avorá ma avusesein avúava san araíen asive asive en mino. ");
INSERT INTO agd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Máan turen Yonini eyo iyampon kayo ano véin me siamemí, “Aru soe, Yodani non ufákena ma éi ódare ma mai vanta van Tiyarafenu ano aní ukhein banta ino ma seona vanta anon monó non péantiyan maifá anan banasi oriyáken tetí ankan barunafá ída eriyan mino.” ");
INSERT INTO agd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Máa síkan Yoni evaránen betí ankan tiamemí, “Inarufá ma vain Tiyarafenu ano mana mana vanta yoran amídú ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tiyarafenu ano ma aní ukhein banta vaumpo séi veni aa uvisen erin banta unon tékuyan inikha ono. ");
INSERT INTO agd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mana vanta ano ma anasi mádan mai nanin mano ven anasíi iyan mifo véin má ma avunté iyá ein mano ma anasi varan baya iniren amusin iyainíien téin túpin timusin bíken mino. ");
INSERT INTO agd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Béin aví dani suron intiná ten tiví bararasá eravino. ");
INSERT INTO agd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Béi inaru fákéi erikhen pasen minó esantakhen mino. Téi ma vara ráke vantan báké ma varai avúavá anan afová ukhé umpo véi inaru fákéi erikhen mino. ");
INSERT INTO agd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Máan tukhan mi véi iniren ódein dana san mi siamiyan mifo ída mana vanta ano mai vaya fákaan ákona uren mairá mumunan iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Inte nanin banta anó mai vaya fákaan ákona uren ná mairá mumunan iyan nafi mai anon Tiyarafenu van pura vaya siya ne sé iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tiyarafenu anon mai vanta siantan erikhen beni vayan tiyan mino. Para vara seyo, Tiyarafenui Aunan mano véimpin bíkakhan mino. ");
INSERT INTO agd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Be Afóe ano ve Anin nan anunu uren minó danáká ma yafisin ákona véin ayampin amen mino. ");
INSERT INTO agd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Be Anintá ma mumunan inain nanin banta ano ída kípan ayun para van oriyan ban aunan baranten mifo ve Anini vaya ánain ma ída vákurin nain nanin banta ano ída kanaíen aunan barantin Tiyarafenui aran daná ano vetin má banten mino.” ");
INSERT INTO agd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yisasi ma vanasi monó non péantiyan ma veni eyo iyampon kayo mo kokhoníen ma Yonini eyo iyampon kayo eantiyain baya Farasisi kayo ano inen mino. ");
INSERT INTO agd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Mai maen Yisasi va monó non péantiyaren naifo vei eyo iyampon kayo anon péantiyaren mino.) ");
INSERT INTO agd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mai ma Farasisi kayo ano afová ein baya Yisasi iniren Yudiá bara me ampiren Kariri varafá evaránen oren mino. ");
INSERT INTO agd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sameriá bara aúbaná ma orikhein aa vá béi yakhafen orino. ");
INSERT INTO agd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Máan tukhan béi oriyaren mana Sameriái varu Sikha se sikhein barurá Yekopu ma ve anin Yosepin amikhá ein bara ádé oren mino. ");
INSERT INTO agd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Oríkan bayan áaui en ayá aintá ma eriyá ein mano Yisasin ayampa yíkan Yekopuni non masí mairá baré in mai masí avafá o khumanen mino. ");
INSERT INTO agd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","O khumantan bei eyo iyampon kayo minó ano evúten dunan miyaní ono van kákan barufin orivíkan beyaká ana varéin mana Sameriá nanin mano non dafono van erin Yisasi véi nan temí, “Non dáan timí nano.” ");
INSERT INTO agd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Máa síkan mai Sameriá nanin mano anú duren temí, “Ída Yutan kayo vá Sameriá kayo vá manafiní ukhein mifo éi Yutan bantan ban ná téi Sameriá nanin mi vá umpo éi fará non nan inantiya fono.” Mai fara va máa sen naino. Yutan kéká bá Sameriá kéká bá ída manafiníen dunan má non má nakhein mi van mino. ");
INSERT INTO agd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Máa síkan Yisasi evaránen mai nanin tiamemí, “Tiyarafenu ano ma ameno van iyain amusin má inká téi iyé bará éi vaípá non nan inantiya rafu mai éi afová e vareya séi vaípá inantesí mai ma fara van oriyan ban non amenunaren mino.” ");
INSERT INTO agd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Máa síkan mai nanin mano semí, “Kákan banta oe, ma non masí námen mi vákayai éi ída non dafin kura vá anan má mantena sefo inte fákená mai ma fara van oriyan ban non dafinte vae. ");
INSERT INTO agd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Erasan tinafu Yekopu ano ma ve anin kayo vá kao vá sipisipi kayo vá ma niyá ein mai non masí ma setin timikhá ein mai vanta éi esantakhe vae.” ");
INSERT INTO agd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Máa síkan Yisasi evaránen béin tiamemí, “Banasi ano ma ma masí pintena non ma narantin evaránen non nan aiinten mino. ");
INSERT INTO agd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Aiinten mifo séi ma amenuna non mano non nan ma aiin kípaantáden banasi aúpin non akharun mamen ída ma kípan para van oriyan ban aunan aminten mino.” ");
INSERT INTO agd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Máa síkan mai nanin mano semí, “Kákan banta oe, mai non pintena manáa simikhesin ná enádá ída non nan tiintisá ma masí pintena ída ovaráné e yafono.” ");
INSERT INTO agd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Máa síkan Yisasi mai nanin tiamemí, “Oreya e avafun o avíare ereno.” ");
INSERT INTO agd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Máa síkan mai nanin mano semí, “Te sivafu ída vain muno.” Sikan Yisasi semí, “Éi fura se ono e avafu ída vain mino. ");
INSERT INTO agd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ída vain mompo fefá éi yan manápá bantan mantareya saréa ma ven má baona vanta mai ída en avafun baya fura siya ono.” ");
INSERT INTO agd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Máa síkan mai nanin mano semí, “Kákan banta oe, éi mana sakhanampa vanta ono. ");
INSERT INTO agd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Téin tisimeno. Para é tiren ná minó Yutan kayo ano Yerusaremíi mana monó tin baru van mino siren o átaru iná inká tetí tinafu siráo ano mará Kerisiní anurá ana monó tiyan nafino.” ");
INSERT INTO agd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Máa síkan Yisasi mai nanin evaránen tiamemí, “Téinti vayarasá mumunan ono. Damú inka eriyain ída ayáká ban mara safi áa Yerusaremi safi Sifóentá minó ano monó tinten mino. ");
INSERT INTO agd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Máan tin nompo sireti Sameriá kayo ano ma monó tiyaona mai yaná ída afová ukha ompo seti Yutan kéká ano ana ma monó tiyaruna mai yaná minói afova ukhé tifékun mi Tiyarafenu ano sétin aní uren banasi evaránen aviran doran timikhen mino. ");
INSERT INTO agd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Timikhen mifo yamú eriyákan mafin inka fe e van mino. Kantá Aunani ákonará ma fura sikhein avúaváká ma Sifóentá monó tin nain mai nanin banta van mi Sifóe ano veyantá monó tino van anunu ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tiyarafenu maen Aunan mi van mifo vá béintá ma monó tin nain kéká ano Kantá Aunani ákona vá pura avúavá bá pókesá benta monó tino.” ");
INSERT INTO agd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Máa síkan mai nanin mano semí, “Téi afová ukhékun Tiyarafenu ano ma aní ukhein banta ma eriven maen mi véi anon kanaíen minó daná tian amá intí iné tifanté uno.” ");
INSERT INTO agd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Máa síkan Yisasi evaránen mai nanin tiamemí, “Mai ma siyaona vantan ma séi váankuno.” ");
INSERT INTO agd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yisasi ma Sameriá nanin má baya siyá íkan ma vei eyo iyampon kayo ano ovaránen e oniyáken maen betí ankan anú duren mana ano véin nan pará mai nanin má baya siyayá náí bariya fono sen ída inaen mino. ");
INSERT INTO agd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mai nanin mano vei non kave me non masí avafá kaúden evaránen kákan barufin oriven minó nanin banta siamemí, ");
INSERT INTO agd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mana vanta ano séin ma fefá bariyáeruna avúavá máa sisimiyan mifo mai maen Tiyarafenu ano ma aní ukhá ein bantá ban nafi eriveya onano.” ");
INSERT INTO agd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Máa siyain má minó nanin banta ano mai varu me ampiren Yisasin onano van ere ere en mino. ");
INSERT INTO agd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Eriyain má Yisasi nan dunan nano van bei eyo iyampon kayo ano yuvun en mino. ");
INSERT INTO agd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Máa síkan evaránen temí, “Ída ino. Tenti yunan ma vain tiretí ankan ída afová ukha ono.” ");
INSERT INTO agd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Máa síkan beni eyo iyampon kayo ano veraran máa sen oreraemí, “Iye anó dunan baren ná me amikhan ná tino.” ");
INSERT INTO agd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Máa siyaimpin Yisasi evaránen betí ankan tiamemí, “Tenti yunan ma vain mai Tiyarafenui anunu ánain ma vákuren beni yorarí uan ma kípan mino. ");
INSERT INTO agd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tiretí ankan ídá teyá ‘kamí kamí biyon ma orivitíi yunan duyasenté uno’ séiya fono. Tiretí ankan ná minó pimpá one eúkono yunan inka karaaren duyasirí ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Dunan ma yuyasin banta kayo ano kama miyan mi variyan mino. Mai yunan ma yuyasiyaini aran mi mai vanasi ma aviren ída kípan para van oriyan ban aunampin ma mo kaiyain mino. Máan tukhein nan mi yunan ma yoran banta vá dunan ma yuyasin banta vá ano amusin inten mino. ");
INSERT INTO agd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Máan tukhan mi mai vaya fura sikhantin mana vanta ano ma yunan dódákaré intin maen ena vanta anon mai yunan duyasinten mino. ");
INSERT INTO agd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Máan tukhein nan mi siretí ankan ída yunan dore nan ena kayo ano ákona yorari uren dóádein dunampin mi siretin nan duyaseno van mi siantiyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Para va mai varu ráke Sameriá kéká ano Yisasintá mumunan en naino. Mai nanin mano ma fefá bariyá ein danasinta ma evaránen tiamein baya ma mai nanin mano vanasi siamin iniren mino. ");
INSERT INTO agd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mumunan uren betí ankan mano véin o oniyáken maen ayópá íkan mai varurá kan damú báken ");
INSERT INTO agd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","kama vaya siyákan kokhon mano veni vaya iníden mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mumunan iyáken betí ankan mai nanin tiamemí, “Éin avaya inídesa seti mumunan erauno. Taréa setiyantái véini vaya inídéi mumunan iyá uno. Béi fura sen barará nanin banta ma aya uren evaránen aviran nain banta ino. ");
INSERT INTO agd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sameriá nanin banta vá bákan kan damú orivin maen Yisasi e manten Karirifá oren mino. ");
INSERT INTO agd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Afovasá ono. Pefá Yisasi veyan nan máa sikhan mino. “Ena varafimpái sakhanampa vanta aví bain mifo vei vara anará ída véin aví ban mino.” ");
INSERT INTO agd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Oríkan Karirí nanin banta ano ódaren amusin iyan béin e aviren mino. Mai fara va ino Avo Uantan Damú béi ano Yerusaremí kákan monó dafufin enará ukhein danasí iyákan betí ankan ontaren mino. ");
INSERT INTO agd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kariri varafin mana Yisasi oriyaren béi ma fefá non maman uvainií ukhá ein Kaná barurá oríkan mana kamanini ayafa vanta anin aí iyan Kapeniamú barurá baren mino. ");
INSERT INTO agd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Baren iníkan Yisasin nan Yudiá me ampiren Karirifá e van ne siyaimpin mai vanta ano Kaná barufá oren Yisasin o yosiren béin má Kapeniamú oren mai ma ve anin aí iyan ma furono van iyain mo ayofano van ákonaen ínaen mino. ");
INSERT INTO agd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Máa síkan Yisasi evaráne véin tiamemí, “Enará ukhein daná bá aní danasinta vá ana afoká intiyá ódé mumunan ono van iya rafono. Ídá para mumunan inte rafono.” ");
INSERT INTO agd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Máa síkan kaminini ayafa vanta ano ákonaen inaen temí, “Bafan noe, se sanin purin nafo aine ereno.” ");
INSERT INTO agd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Máa síkan Yisasi evaránen béin tiamemí, “E anin e asefa inten mifo evaráne ei varufá orono,” síkan mai vanta ano Yisasini vayará mumunan iyáken bei varufá oren mino. ");
INSERT INTO agd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mai ayafa vanta ano ída Kapeniamú orikhen para ayanafá oriyákan manáa vei yoran banta kayo ano vaya varen ayanafá e fóken tiamemí, “E anin inka asefaen mino.” ");
INSERT INTO agd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Máa síkan béi vetí ankan inaemí, “Nái áau rasá te sanin e asefaen nafino.” Síkan betí ankan evaránen béin tiamemi, “Inuran inúpá mana áauí in mi veni aí kípen mino.” ");
INSERT INTO agd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Máa síkan mairá be afóe ano mai ma Yisasi sen ma e anin e asefa inten mino ma sein áau ovare me iniren ben má bei kéká bá ano Yisasintá mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yisasi ma Yudiáké eriaren ma Karirifá e varen ma ma yaná barein mai anon kan dádasí en mi enará ukhein daná afoká en mino. ");
INSERT INTO agd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ínaimpáké Yutan kayoi kákan monó tin damú afoká íkan Yisasi evaránen Yerusaremí óden mino. ");
INSERT INTO agd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mai kákan dafu ona aví Sipisipii Ona e sikhein akhentá Yerusaremí kákan barufin mana non akharun bákan mai non akharun aví Iburu vaya finté Betesda e sikhan mai akhempá dan manápá dusesí uádan baren mino. ");
INSERT INTO agd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Baré íkan mai yusé kayofin kokhon aí nanin banta vá auu yufúkukhein kayo vá arantan namu ukhein kayo vá ai ayan púkein kayo vá baren mino. ");
INSERT INTO agd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bákan maifin mana vanta teti-eiti (38) oranará aí bain banta ano vakharen mino. ");
INSERT INTO agd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mai vanta ayáká aí mantaréin Yisasi afová en ódaren béin inaemí, “Éin au evaránen kama ino vará iya fono.” ");
INSERT INTO agd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Máa síkan mai aí banta ano evaránen béin tiamemí, “Kákan banta oe, non ma karantó intin ma sivían ten nare ma nompin kain banta ída vákan ena kayo ano anan ainen ten esantaaren nompin araviyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Máa síkan Yisasi véin tiamemí, “Mantaveya ei yuvasí mamare orono.” ");
INSERT INTO agd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Máa siyain má mai vanta au ainen manádá kama íkan bei yuvasí dádaaren oren mifo mai Sabati yamúi mai avúavasíen mino. ");
INSERT INTO agd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Máan tíkan Yutan kayo ano ódaren mai vanta máa sen tiamemí, “Sabati yamú doran nan airo ananí ukhein mifo éi fará ei yuvasí mamareyá no fono.” ");
INSERT INTO agd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Máa síkan béi evaránen betin tiamemí, “Mai ma sen tu ma kama usintein banta anon ‘Ei yuvasí mamareya orono’ sen tisimikhá uno.” ");
INSERT INTO agd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Máa síkan betí ankan mano véin ákonaen inaemí, “Intéa vanta anó éin tiamen ná ei yuvasí mamareya orono sen nafino.” ");
INSERT INTO agd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Máa siyákan kokhon nanin bantafin Yisasi ofébin mai ma au kama uantein banta ano aminoen mino. ");
INSERT INTO agd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Amino ukharéin maen ínaimpáké Yisasi kákan monó namumpin ódiven onákan mai vanta varéin máa sen béin tiamemí, “Éi moéke kákan uman baran nampo vá au ma kama uveintá ída vá enádá umeí ono.” ");
INSERT INTO agd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Máa sirákan mai vanta ano Yutan kayoi ánon banta kéka san dosen oren mo vetin tiamemí, “Ten tu ma kama usintein banta mai Yisasi ino.” ");
INSERT INTO agd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sabati yamú anan Yisasi ano vanasi ayofiyaimpin mi Yutan kayo ano mai van béin namuroí uanten mino. ");
INSERT INTO agd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Máan uantiyákan Yisasi evaránen betin tiamemí, “Te Sifóe ano fara yoren oriyan báken taréa yeren doriyan mifo mai fará téi ifá onte rafuno.” ");
INSERT INTO agd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sabatirá ma yoran are ukharé ein Yisasi yurafuriyáken ma inká Tiyarafenu van te Sifóe uron mino ma sein nan Yutan kayo ano iníkan Tiyarafenu vá un manaí in baya siyaimpin mai van ben aruan purin aa van dosen mino. ");
INSERT INTO agd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Máan tiyákan Yisasi afová iyáken betí ankan evaránen tiamemí, “Pura siré tiretí ankan tiamé uno. Be Anin mano ída kanaíen beyantá mana avúavasí inten mifo ve Afóe ano ma varan nain mai avúavá máa anan be Anin mano varanten mino. ");
INSERT INTO agd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Para vara seyo, be Afóe ano ve Anin moéken anunu iyáken mi ve ma variyain avúavá máan be Anin aní intin baranten mino. Máan intin ma ma ayofein banta esantaren moéken kákaní ukhein danasinta varantiya mai avúava san anúde orera inono. ");
INSERT INTO agd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Para vara seyo, fúká ein kéká ma ve Afóe ano orun avían mantiyainí anan en mi ve Anin mano ve ma anunu inain kéká kasaen aunan aminten mino. ");
INSERT INTO agd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Máan tukhan banta ma yaimin doran maen ída ve Afóe ano yaimé iyan mifo ve Anin mi mai yoran amikhen mino. ");
INSERT INTO agd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Máan tukhein nará be Afóen aví ma yaní iyaonaí e vá be Anin avisá daní ono. Banta ano ma ve Anin aví ma ída yaní inteya mai ven ma siantan erikhein Afóen avíi ída yaní e ono. ");
INSERT INTO agd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Téi fura siré tiretí ankan tiamé uno. Mana vanta ano ma sen tivaya inire ma séin ma sisintá erikheruna Tiyarafenurá ma mumunan inona ano ída kípan ayun para van oriyan ban aunan baran nono. Betíi ume ma yaimin ída vanten mifo veti fefái furin dafu finté ekháden para van oriyan ban aunani yafufin erikhen mino. ");
INSERT INTO agd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Téi fura siré tiretí ankan tiamiyá uno. Damú ma afoká ono van iyá ein taréa inka afoká íkan pefá ma fúkaré ein nanin banta ano mai Tiyarafenu Anin avaya iniyantin inká mai vaya ma inin nain kéká ano fara ayun banten mino. ");
INSERT INTO agd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Para vara seyo, ve Afoé ma veyampin aunan amin ákona vainíien be Anin má ákona amin be Anin má dere veyampin aunan ma amin ákona van mino. ");
INSERT INTO agd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Inká béi Vanta Anin mi vákan banasii avúavá ma yaimin ákona amikhen mino. ");
INSERT INTO agd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Máan tukhanti siretí ankan ída vá ma vaya van anú dureya kokhon ineine ono. Inka yamú ádé irí iyain púkein nanin banta ano Tiyarafenu Anini vaya iníden maen ");
INSERT INTO agd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","masí pinté evaránen e mantaven maen kama avúavá ma variyaré ein kéká ano ída kípan para ayun ban oriyan ban aunan barantin inká namu avúavá ma variyá inain kéká ma kó tiantan naimpin oferanten mino. ");
INSERT INTO agd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Máan tinten mifo séi mana yaná tesi ineine finté ída varanté umpo se Sifóen pintena ma vareruna vayan dakhafé banasii avúavá daiméiyá uno. Téi ída sesi sinunu yakhafin na séin ma sisintá erikheruna Sifóeni anunun dakhafiyái séi ma yaimiyaruna ano funtáken mino. ");
INSERT INTO agd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Téi ma sesi sivútivá bá doran ma san ma seyantá tian amá iyákun maen banasi ano mai vaya van beyantái siyan mino siren ída ininten mino. ");
INSERT INTO agd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Máa sen ininten mifo ena ano ma senti sivútivá bá doran ma san ma siyantiya mai furan tiyan mino. ");
INSERT INTO agd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tiretí ankan Yonini vaya o iniren me siamino van manáa vanta kayo sianten nan orikhan mifo véi fura sikhein baya van mi sian amá ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yonini avúavá baya ma siretin tiamiyaruna mai Tiyarafenu ano siretí ankan evaránen avirano van mumpo senti kama sivútivá bá doran baya vá ma sian amá inain mai ída varará banta kayoi yoran mino. ");
INSERT INTO agd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Mana oon ma uruádeiníi Yoni uven tiretin kakhaantayai sító máará amusin erono. ");
INSERT INTO agd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Máan te ompo Yoni ma yoriyáken tenti vaya sian afoká iyá ein mai séi veni yoran esantakhein dorarí iyáké kokhon enará ukhein aní danasinta variyá umpo mai minó doran Tifóe ano séin timikhen mino. Minó doran ma séi ma variyaruna ano vanasi avorá tian amá en Tifóe anon téin tisintá erikhé uno. ");
INSERT INTO agd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Erikhékun mi Sifóe ano veyantái sen nan tian amá ukhen mifo siretí ankan ída ven avaya ineya ayafen one ukha ono. ");
INSERT INTO agd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Máan tukhesin pasen tiretí ankan aúpin ída veni vaya vanten mino. Mai fara va ino. Béin ma siantan erikhein bantai vayará ída mumunan iya nan mino. ");
INSERT INTO agd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tiretí ankan Tiyarafenui vompon dókifin dankáde mai vaya yaíde afová e nan mai ano ída kípan ayun para van oriyan ban aunan timinten mino siya ompo mai Tiyarafenui vompon dóki ano séin nan mi siádan baré íkaya ");
INSERT INTO agd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","siretí ankan téi vaípá ída eriveya ída kípan ayun para van oriyan ban aunan bariya ono. ");
INSERT INTO agd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Téi ma ma vaya kayo ma siyaruna mai vanasi fintena kákan bí baranova rauno. Ída ino. ");
INSERT INTO agd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Máan tukhein mifo séi siretí ankan afová ukhé uno. Tiretí ankan aúkáké ída Tiyarafenu van anunu ukha ono. ");
INSERT INTO agd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Téi Sifóen avíkái erikhé kuyai siretí ankan ída séinti vaya variya ompo mana vanta ano ma ve avíká ma erintiya mae siretí ankan manádái mai vantai vaya aine varan nono. ");
INSERT INTO agd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tiretiyan mi kákan bí baran maran iyáke Tiyarafenu ano ma amiyain bí ída variya ompo intesá ureyá mumunan inte rafono. ");
INSERT INTO agd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Tiretí ankan ída vá ten nan Tifóen avorá daiminten mino se vá ineno. Tiretí ankan ma Mosesin nan tiya inten mino ma se inikhá eona mai vanta anon tiretí ankan daiminten mino. ");
INSERT INTO agd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosesini vayará pura sen mumunan e vareya mai senti vayará deren mumunan inonaren mino. Mai fara vara seyo, béi ma uvantaré ein bompompin mai sen nan mi sikhan mino. ");
INSERT INTO agd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Máa sikhan mifo mai ma véi uvanteré ein bayará ma ída mumunan inteya mai siretí ankan intesá ureyá tenti vayará mumunan inte fono.” ");
INSERT INTO agd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Máa siran manáa yamú orivíkan Yisasi Kariri non ma ena ví Taibiriasi e siyain e kháden oren mino. ");
INSERT INTO agd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Oríkan kokhon nanin banta ano véin e vákuren oren mino. Mai fara va ino véi ma aí nanin banta ayofantá ma enará ukhein daná ma variyan ma ontaré ein nan mino. ");
INSERT INTO agd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Bákuren oriyákan Yisasin má bei eyo iyampon kayo vá ano mana anuyontá un kumanen mino. ");
INSERT INTO agd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Yutan kayoi Avo Uantan Damú ádé eriyákan mino.) ");
INSERT INTO agd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Un kumantaren onákan kokhon nanin banta ano véi nan dosen amen édiyaimpin dovaéaren Firipin inaemí, “Tetí ankan ma ma nanin banta amékun nan nain dunan inte fákená miyaní ótifante rafuno.” ");
INSERT INTO agd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Béi ma mai vaya ma sein mai veyan ma varan nain daná pé afová ukhen Firipin mi mai vayafó akhenóka uan onen mino. ");
INSERT INTO agd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Máa síkan Firipi evaránen béin tiamemí, “Tetí ankan ma kan tauseni monipó ma yunan miyaní urékun maen ma nanin bantafin ída kanaíen kova inten mino.” ");
INSERT INTO agd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Máa síkan mana vei eyo iyampon Saimon Pitan afá aváe Enduru ano evaránen Yisasin tiamemí, ");
INSERT INTO agd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Masína mana iyampon mano yan manápá bereti vá kan noyana vá kain ban mifo ma nanin bantafin mai ano intesá uren ná kanaí inten nafino.” ");
INSERT INTO agd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Máa síkan Yisasi vetí ankan tiamemí, “Minó nanin banta siamesin kuman ino,” síkan mairá kokhon kata varé íkan mai yaró kumanen oreraen mino. Maifin ma varé ein banta máa mai yan manápá tauseni (5,000) ino. ");
INSERT INTO agd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kumamíkan Yisasi vereti kayo orun máden Tiyarafenu susu siantáden kisian banasi amíden ínaimpáké noyana kánan máden máan mana uren amíkan minó nanin banta ano nákan amú kuren míno. ");
INSERT INTO agd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Amú kuriyaimpin Yisasi vei eyo iyampon kayo siamemí, “Mai yunan antan tavifá eraven afein nafo aían átaru ono.” ");
INSERT INTO agd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Máa síkan mai ma yan manápá bereti finke ma kisian banasi amin narákan ma amú kurin ifá ein antan kayo o éke e éke uren tiyan mikan mifo sirantan kan orun kádan (12) unan bíken mino. ");
INSERT INTO agd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Máan tíkan mai ma enará ukhein daná ma aní ein minó nanin banta ano ódaren temí, “Pura uron ten mai ma Tiyarafenu ano siantantin ma ma varará erano van ma sikhá ein mai sakhanampa vanta ino. ");
INSERT INTO agd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Máa siren banasi ano Yisasin duvun intin kiní ino van iyain baya véi iniren afová iyáken mairá me ampiren beyaká anufá óden mino. ");
INSERT INTO agd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ódivíkan mai inúpá bei eyo iyampon kayo ano non akhempá orun béin ave ukharen mino. ");
INSERT INTO agd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ave ukhan Yisasi ída ovaránen eríkan duniyaimpin non e kháden Kapeniamú orono van betí ankan botifin un kumanen mino. ");
INSERT INTO agd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kumanen oriyaréin kákan uva uaren non karantó en mino. ");
INSERT INTO agd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mai non aúbaná oriven onákan Yisasi non daró boti kakháaren oriyaimpin betí ankan akhokho van en mino. ");
INSERT INTO agd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Akhokho van iyain má Yisasi oovaren temí, “Téin eriyá umpo ída vá akhokho van ono.” ");
INSERT INTO agd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Máa síkan betí ankan amusin iyáken béin botifin avían kaúdan mai voti ano manádá ainen mai ma oriyá ein barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ena ákurá banasi ano Yisasin onano van mai non avaruni ena ufá o átaru en mino. Mai fara va ino. Ben má bei eyo iyampon kayo vá ano manápá erikharen mi véin me afa uren eyo iyampon kayo ano ana votifin un kumamen oríkan ontaren mino. ");
INSERT INTO agd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","O átaru iyákan mai ma Bafan mano ma susu siren bereti ma vanasi amin neintá manáa Taibiriasí kena voti kayo eren mino. ");
INSERT INTO agd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mairá o átaru uven onákan Yisasin má bei eyo iyampon kayo vá ída vaimpin minó nanin banta ano mai voti kayofin kumamiyan non akharun e kháden Kapeniamú mo Yisasin nan doseno van oren mino. ");
INSERT INTO agd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Banasi non e kháden ena ufá oriven Yisasin oniyáken mo véin inaemí, “Aru soe, inte áau rasá éi mafá ere fono.” ");
INSERT INTO agd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Máa síkan Yisasi evaránen betin tiamemí, “Téi fura uron tiré tiretí ankan tiamiyá uno. Téi ma enará ukhein daná ma aní iyaruna van ída iniya ompo siretí ankan inuran ma vereti amékuya ma nen nan amú kurein mai máa van mi se nan dosiya ono. ");
INSERT INTO agd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Máan tiya ompo siretí ankan ída vá ainen pútaen ma namuin dunan barano van ono. Banta Anin mano ma fara van oriyan ban aunan ma amin nain ná tiretí ankan ayampa ure vá doseno. Para vara seyo, Tifóe Tiyarafenu ano mai van mi véin tiantan erikhen mino.” ");
INSERT INTO agd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Máa síkan béin evaránen inaemí, “Tetí ankan inté ma ontesá kanaí é Tiyarafenui yorarí onté tife rafuno.” ");
INSERT INTO agd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Máa síkan Yisasi evaránen betin tiamemí, “Tiyarafenu ano ma siretin amin nain doran mai máan mi ukhen mino. Béi ma siantan ma erikhein bantarasá mumunan ono.” ");
INSERT INTO agd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Máa síkan betí ankan mai vaya iniren evaránen béin inaemí, “Mai éi intéa enará ukhein aní daná ma aníesirá tetí ankan ódaresá éintá mumunan ótifante rafuno. ");
INSERT INTO agd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Para vara seyo, Tiyarafenui vompon dókifin máa sikhen mino. ‘Tinafu siráo ma kámá barafá nókan maen Mosesi ano inaru fáke manna e sin bereti amíkan nen mino.’ ");
INSERT INTO agd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Máa síkan Yisasi vetí ankan tiamemí, “Téi fura siré tiretí ankan tiamé uno. Mosesi ano va mai inaru fáke vereti amikhan naifo, se Sifóe anon amikharen mi inká taréa inaru fáke fura vereti amiyan mino. ");
INSERT INTO agd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Para vara seyo, mai Tiyarafenui fura vereti uron manon inaru fáké erakhen barará nanin banta aunan amiyan mino.” ");
INSERT INTO agd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Máa síkan betí ankan temí, “Kákan banta oe, ena ena yamú mai vereti vá tetin timeno.” ");
INSERT INTO agd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Máa síkan Yisasi vetí ankan evaránen tiamemí, “Téi aunan amin bereti umpo séi varunafá ma erin nain mano ída arafanan inten mino. Tentá ma mumunan inain mano ída enádá non nan ainten mino. ");
INSERT INTO agd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tiretí ankan téin tonte ompo ída mumunan iyanái siamiyá uno. ");
INSERT INTO agd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tiamiyá umpo Sifóe ma simikhein kéká ano ma se vaípá erintí maé téi ída uron mi vetí ankan evaráné tiantanté uno. ");
INSERT INTO agd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Para vara seyo, séi sesi sinunu ánain dakhafo novara inaru me ampiré erakhe raumpo mai ma sisintá erakheruna Sifóeni anunu ánain dakhafono van mi erakhé uno. ");
INSERT INTO agd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Erakhé umpo mai ma séin tisintá erakheruna Sifóeni anunu máan mi ukhen mino. Ma vara ma kípan nain damú mai ma séin timikhein nanin banta finté mana ano ída afeyoranten mifo minó kékái avorékun e mantanten mino. ");
INSERT INTO agd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Para vara seyo, te Sifóeni anunu máan mi ukhen mino. Be anin ma ódaren bentá ma mumunan ukháin nain nanin banta ano ínaimpá kípan damú téi avorékun orun mantaven maen ída kípan para van oriyan ban aunan barano van mino.” ");
INSERT INTO agd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yisasi ma veyan nan téi inaru rákena vereti uno ma sein nan Yutan nanin banta ano iniren kakhí kakhá ten oreraen mino. ");
INSERT INTO agd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Máan tiyáken betí ankan temí, “Ma vanta anóe afóen tetí ankan afová ukhékun béi Yosepin anin Yisasin ban mifo mai fará ten ná ‘téi inaru fáké erakhé uno’ siyan nafino.” ");
INSERT INTO agd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Máa síkan Yisasi evaránen tiamemí, “Tiretí ankan ída vá kakhirun tiriya vano. ");
INSERT INTO agd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Para vara seyo, vanasi ano ída kanaíen te vaípá erinten mifo séin ma sisintá erikheruna Sifóe ano ma o avíádantin ma se vaípá erekharé intí maé ínaimpá kípan damú purin pintena evaráné avoran e mantanten mino. ");
INSERT INTO agd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sakhanampa vanta kayoi vompon dókifin ma vain baya ano máa sikhen mino. ‘Minó nanin bantan Tiyarafenu ano afova aminten mino.’ Tifóeni vaya ma iniren afová urein kayo anon te vaípá eré iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ída mana ano Sifóen onten mifo Tiyarafenu vá ma varen erakhein banta ano anan Tifóen onten mino. ");
INSERT INTO agd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Téi fura siré tiretí ankan tiamiyá uno. Téintá ma mumunan iyain kayo ano fefái ída kípan aunan manten mino. ");
INSERT INTO agd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Téi ída kípan ayun ma fara van oriyan ban aunan ma amiyain bereti uno. ");
INSERT INTO agd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Pefá tiretí ankan anafuyan mano kámá barafá manna e sin bereti nakharen mifo minó ano furein mino. ");
INSERT INTO agd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Purein mifo inaruráké ma erakhein bereti ma vanasi ano nanten maen beti ída furinten mino. ");
INSERT INTO agd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mai ma aunan bain bereti ma inaru fáké erein mai séi umpo mana vanta ano ma mai vereti nanten maen ayun ma fara van oriyan ban aunan baranten mino. Mai vereti ma amenuna mai varará nanin banta ano ída kípan aunan barano van tesi simasin amenté uno.” ");
INSERT INTO agd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Máa síkan Yutan kayo ano veraran asive asive iyáken temi, “Ma vanta ano intesá urená be amasi simintí nantékun ná tino.” ");
INSERT INTO agd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Máa siyákan Yisasi vetí ankan tiamemí, “Téi fura uron tiré tiretí ankan tiamiyá uno. Banta Anini amasi vá nare vá ma ída nanteya mai siretí ankampin ayun ma fara van aunan ída vanten mino. ");
INSERT INTO agd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ída vanten mifo séin timasi vá nare vá ma nan nain kayo ano ída kípan ayun ma fara van aunan mantaré intí maé ínaimpá kípan damú betin avorékun e mantanten mino. ");
INSERT INTO agd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mai fara vara seyo, sen timasi maen mai fura sikhein dunan mi vákan inká tenti nare maen mai fura sikhein non mi vákan ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tenti simasi vá nare vá ma niyain kayo ano séimpin baká téi vetí ankampin bá uno. ");
INSERT INTO agd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ayun ma fara vain Tifóe ano séin tisintá erikhékun mi veni ákonarái sen taunan para van mifo mana ano ma máan mana en ten ma nanten maen tenti ákonará ayun ma fara van aunan baranten mino. ");
INSERT INTO agd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Téi mai inaru fáké ma erein pura vereti umpo fefá ma anafu aráo ano ma manna e sin bereti naren baren maen ínaimpáké puren mino. Purein mifo ma ma siyaruna vereti ano mai vá ída manaí ukhein ma ma nan nain mano ayun ma fara van oriyan ban aunan baranten mino.” ");
INSERT INTO agd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Béi ma ma vaya kayo sein mai Kapeniamú barurá monó átaru namumpin mi vanasi monó baya siamen mino. ");
INSERT INTO agd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Máa siyákan bei eyo iyampon kayo vá ano yere mai ma siyain baya iniren máa semí, “Amino eruna vayan tiyan mifo iye anó kanaíen ná ininten nafino.” ");
INSERT INTO agd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mai ma vei eyo iyampon kayo ano ma vaya kokhon iyain Yisasi afová iyáken betí ankan tiamemí, “Ma vaya anó tiretí ankani mumunan asuse iya nafino. ");
INSERT INTO agd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tiretí ankan ma oniyasin ma Vanta Anin mano ma evaránen inarufá ódintiya mai inte esá té ininte fono. ");
INSERT INTO agd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kantá Aunan manon ída kípan ayun ma fara van aunan banasi amé iyan mifo vantai ákona ano setí ankan ída uron mi siya iyan mino. Ma vaya ma siretí ankan ma siamiyaruna mai aunan mi váken béi ayun ma fara van oriyan ban mino. ");
INSERT INTO agd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ban mifo siretin pinté manáa ano séintá ída mumunan iya ono.” (Mai fara va máa sen naino. Iye anó béintá ída mumunan iyan ná inká iye anó béin namuro ayampin aminten nafi mai véi esé araí in táké afová ukharen mino.) ");
INSERT INTO agd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Máa siren enádá evaránen temí, “Tifóe ano ma ída ákona amin nain mano ída kanaíen te vaípá erinten mino. Mai ana van mi séi ma vaya siretin tiamé uno.” ");
INSERT INTO agd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yisasi ma mai vaya siran maen ben ma yakhafen noré ein kayo finté kokhon mano véin me ifá en tipá oren noren mino. ");
INSERT INTO agd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Máan tíkan Yisasi vei sirantan kan orun kádan (12) eyo iyampon kayorá inaemí, “Tiretí ankan masá téin me ifáeyá orinte fono.” ");
INSERT INTO agd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Máa síkan Saimon Pita evaránen temí, “Bafan noe, éini vayafin mi ayun ma fara van oriyan ban aunan ban mifo setí ankan iye vaipasá oronte rafuno. ");
INSERT INTO agd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Éi Tiyarafenui mana kantasí ukheona vantan ban ná tetí ankan afová ukhé mumunan iyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Máa síkan Yisasi evaránen betí ankan tiamemí, “Tiyan míkan mifo sirantan kan orun kádan (12) eyo iyampon mi séi avíké umpo mai aúbaná mana Ban Anon ban mino.” ");
INSERT INTO agd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iskariotíke vanta Saimonin anin Yudasi nan mi véi máa sen mino. Tiyan mikan mifo sirantan kan orun kádan (12) eyo iyampon pintena mai vanta anon Yisasin namuro ayampin amintin aruan purinten mino. ");
INSERT INTO agd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Máan turen mai oyampáké Yisasi Kariri varafin mana váken minó barufimpá noren mino. Yutan kayo ano véin aruan purono van iyákan mai van béi ída evaránen Yudiá barafá orono van ukharen mino. ");
INSERT INTO agd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ída orono van ukhan maen Yutan kayoi Iyon Baran Namun Kayo ma Uváden Monó Tin Omá ádé en mino. ");
INSERT INTO agd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ádé iyákan be afá kéká ano véin duvun uren tiamemí, “Ei varu me ampireya Yudiá barafá oriveya enará ukhein danasinta aníesin ná ei eyo iyampon kayo ano onano. ");
INSERT INTO agd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Minó nanin bantafin ma mana vanta ano ma vei yoran aní ono van maen ída aúpá doré iyain mifo éi minó nanin banta avorá oriveyá ei yoran aníesin ná onano.” ");
INSERT INTO agd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mai fara va máa sen naino. Be afá kéká ano yeren bentá ída mumunan iyáken mi sen mino. ");
INSERT INTO agd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Máa síkan Yisasi evaránen betin tiamemí, “Tenti yamú ída afoká ukhen mifo siretí ma orono van inona yamú kasae orin nono. ");
INSERT INTO agd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Minó nanin banta ano ída kanaíen tiretí ankan namuroi uantanten mifo vetíi namu avúavái sian páman iyákun mai van mi séin namuroí usintiyan mino. ");
INSERT INTO agd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mai omasí ma iyaipasá tiretí ankan orono. Para vara seyo, senti yamú ída afoká ukhein téi ída oronté uno.” ");
INSERT INTO agd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Máa sen tiamiren Yisasi Karirifá karemen mino. ");
INSERT INTO agd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Karentan maen be afá kéká ano mai omápá orivíkan ínaimpáké Yisasi aúpáké uaren maifá oren aúpá o varen mino. ");
INSERT INTO agd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","O vákan Yutan kayoi ánon banta kéká ano mai omápin benan dosi vaen banasirá inaemí, “Mai vanta intefasá ban nafino.” ");
INSERT INTO agd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Máa síkan banasi ano kafaya sen orera iyákan manáa ano semí, “Béi kama vanta ino” siyákan inká ena kéká ano semí, “Ída ino. Béi vanasi kampun tiantan banta ino.” ");
INSERT INTO agd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Máa siyaren mifo vetí ankan Yutan kayoi ánon banta kéka san péden ída afoká tinton aúpá anan tiyaren mino. ");
INSERT INTO agd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mai omasí e en oriyan ma mo aúban nasí iyan maen Yisasi monó dafufin ódiven monó baya araíen banasi siamen mino. ");
INSERT INTO agd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tiamiyákan Yutan kayoi ánon banta kéká ano veni vaya iniren anú duren takhaen orera iyan temí, “Ma vanta ano ída afova ma varampin orikharen mifo inté uren ná béi ma afova manten nafino.” ");
INSERT INTO agd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Máa siyákan Yisasi evaránen betí ankan tiamemí, “Ma vaya ma siretin ma séi siamiyaruna mai sesi vaya vaino. Ída ino. Tiyarafenu ano ma séin tisintá erikheruna mai veni vayan téi siamiyá uno. ");
INSERT INTO agd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tiamiyá umpo mana ano ma Tiyarefenui vaya ánain ma yakhafono van ma iyanten mai anon kanaíen téi ma siyaruna vayai ana afová inten mino. Mai vaya senti ineine fintesá eriyan nafi áa Tiyarafenu fintesá eriyan nafi mai véin kanaíen afová inten mino. ");
INSERT INTO agd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mana vanta ano ve aví daní ino van mi vei ineine finte vaya sé iyan mifo ena vanta ano ma siantan erikhein banta mai fura vantan báken mai ma véin tiantan erikhein banta avíi yaní é iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ídá Mosesi ano siretí ankan man baya amikharen nafino. Tiretí ankan pinté mana ano ída mai man baya ánain dakhafiya ompo fará téin tiruan purono van iya rafono.” ");
INSERT INTO agd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Máa síkan banasi ano evaránen béin tiamemi, “Éi óen mi iya ompo iye anó éin aruan purono van iya vae.” ");
INSERT INTO agd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Máa síkan Yisasi evaránen betin tiamemí, “Téi Sabati yamú ma vanta ayofan dorarí ma erúna van mi siretí ankan anúde orera iya ono. ");
INSERT INTO agd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesi ano au khavin avúavá amikhaya Sabati yamú deren iyampon au khaviya ompo mai avúavá ída véi araí ukhen mifo anafu aráon pintéi erikhen mino. ");
INSERT INTO agd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Máan tukhein nan mi siretí ankan Mosesini man baya ánain dakhafeya ain iyampon au Sabatirá kaviya ompo séi ma Sabatirá ma vanta ayoferuna van pará tireti séin nan aranan ná bariya rafono. ");
INSERT INTO agd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tiretí ankan puntákein avúavá posá minó daimin nompo ída vá auu máa fóké ódeya yaimono.” ");
INSERT INTO agd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusaremíké manáa nanin banta ano máa sen oreraen mí, “Ma mai ma aruan purono van iyain banta fino. ");
INSERT INTO agd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Béi minó avorá baya siyan mi setisi ánon banta kéká ano véin nan ída mana vaya siyan mifo Tiyarafenu ano ma aní ukhein banta inó ten afová iyanten nafino. ");
INSERT INTO agd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tetí ankan beni varu afová ukhé tifé umpo Tiyarafenu ano ma aní ukhein banta ma erin nain mai mana ano ída veni varu afová inten mino.” ");
INSERT INTO agd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yisasi ma monó dafufin banasi monó baya siamiyáken maen avádóden oovaraaren temí, “Tiretí ankan téin má tesi varu vá afová ukha ompo séi ída sesi sinunurá erikhé uno. Ben avúavá purasen puntákein manon téin tisintá erikhékuyan tiretí ída véin afová ukha ono. ");
INSERT INTO agd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Téi ven má baréi véin afová ukhékun téin tisintá erikhé uno.” ");
INSERT INTO agd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Máa síkan ánon banta kéká ano mai vaya iníden béin pákano van en mifo véi ma uman baran nain damú ída erikhan mana ano ven au ída aruven mino. ");
INSERT INTO agd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Máan tiyákan kokhon nanin banta ano ventá mumunan iyáken temí, “Tiyarafenu ano ma aní ukhein banta ma erinten maen ma vanta ano ma variyain avúavá danasinta esantaren ná enará ukhein avúavasá baranten nafino.” ");
INSERT INTO agd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Banasi ano Yisasi ma variyain avúavá dana san kafaya sen orera iyákan Farasisi kéká bá monó ánon banta kayo vá ano iniren Yisasin pákano van monó dafurá ma yafisin banta kéká tianten mino. ");
INSERT INTO agd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Siantiyákan Yisasi vetin tiamemí, “Téi ída ayáká tiretí ankan má banté umpo séin ma sisintá erikheruna Sifóe vaípá evaráné oronté uno. ");
INSERT INTO agd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Orivékun mae siretí ankan te nan dosin nompo ída sonan nono. Inká téi ma o vanuna varufá ída kanaíe orin nono.” ");
INSERT INTO agd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Máa síkan Yutan kayoi ánon banta kéká ano vetiyan ten oreraemí, “Béi intefasá orivintirá tetí ída ven onanté tifékun ná tiyan ná tino. Ena anan bantai varafá ma manáa setinti kéká ma o vaípasá béi o van ná monó baya siaminton ná tiyan nafino. ");
INSERT INTO agd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Téin nan tiretí ankan dosin nompo ída kanaíeya sonan nono sen ma inká tiretí ída kanaíeya se ma o vanuna varurá erin nono ma sikhein mai veni ana intesá ukhen nafino. ");
INSERT INTO agd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mai ma átaru en monó ten oriyaréin mo akheníen kípan kákan damú Yisasi orun mantaven avádóden oovararen temí, “Non nan ma aiiyain kayo áesin ná téi varunafasá eriven nano. ");
INSERT INTO agd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Sentá ma mumunan inain mano se varunafá eriven ná mai non nano. Mai fara vara seyo, Tiyarafenui vompon dóki ano máa sikhen mino. ‘Béin aú pinté ayun ma fara van non kayo oriyan banten mino.’ ");
INSERT INTO agd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Maí damú Yisasi ída fúaren kákan bí mantan inká ída Kantá Aunan eran ukhan mi mai ma ventá mumunan inain kayo ano ma ínaimpá Kantá Aunan baran nain nan mi siyaren mino. ");
INSERT INTO agd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Máa síkan mai vaya iniren manáa nanin banta ano semí, “Pura siren ma sakhanampa vanta uron mino.” ");
INSERT INTO agd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Máa síkan manáa nanin banta ano semí, “Tiyarafenu ano ma aní ukhein banta ino.” Síkan inká ena kéká ano semí, “Inté uáken ná Tiyarafenu ano ma aní ukhein banta ano Kariri fáké erinten nafino.” ");
INSERT INTO agd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Para vara seyo, Tiyarafenui vompompin máa sikharen mino. ‘Tiyarafenu ano ma aní ukhein banta ano Kin Devitini anan pintéi véi ma fefá bá ein baru Betariamúi afoká inten mino.’ ");
INSERT INTO agd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Máa siyáken banasi ano Yisasi nan kokhon ineine uren kampintan daimen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Máan tiyáken manáa ano véin bákúdé pákano van en mifo ída mana ano ven au aruven mino. ");
INSERT INTO agd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ída fákarí iyaimpin monó dafurá ma yafisin banta kéká ano ovaránen monó ánon banta kéká bá Farasisi kayo vá baípá eríkan betin inaemí, “Tiretí ankan pará béin ída fákaré aviré ere rafono. ");
INSERT INTO agd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Máa síkan monó dafurá ma yafisin banta kéká ano evaránen temí, “Ma vanta ano ma vaya siyainíen pefá mana vanta ano ída sikharen mino.” ");
INSERT INTO agd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Máa síkan Farasisi kéká ano vetin nan tiren intemí, “Tiretí ankan mái véi mákáden aviren oriyanten mino. ");
INSERT INTO agd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tetí monó ánon banta kayo vá Farasisi kéká bá pinté béintá mumunan iyá tife rafuno. ");
INSERT INTO agd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ída ifo man baya ma ída afová ukhein nanin banta anon béintá mumunan iyain Tiyarafenui aran daná ano vetin má ban mino.” ");
INSERT INTO agd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Betí ankan pinté Nikodimasi ano Yisasin pe o ontaren betin inaemí, ");
INSERT INTO agd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Tetinti man baya ano vanta fasavi avían kópin kaonó tikhen nafi áa veni vaya ana nare inian puntádeya vá onó tikhen nafino.” ");
INSERT INTO agd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Máa síkan betí ankan evaránen béin tiamemí, “Éin má dere Kariri fáke vanta fono. Tiyarafenui vompon dókifin kama e yankádeya vá afová ono. Ída mana sakhanampa vanta Karirifá afoká uaren eré iyan mino.” ");
INSERT INTO agd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mai vaya ma kípiyain má minó ano meren be amápá oreraen mino. ");
INSERT INTO agd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Orera uvíkan Yisasi Orifí Anufá óden mino. ");
INSERT INTO agd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ódikharen pe ákura suron béi evaránen kákan monó dafufin oríkan banasi e átaru uvin béi kumanten monó baya siamen mino. ");
INSERT INTO agd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tiamiyákan mana vanta aná ano ena vanta kéká bá moré íkan man baya ma afová ukhein banta kayo vá Farasisi kéká bá ano mai nanin aviren banasi avorá me khaúden ");
INSERT INTO agd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yisasin tiamemí, “Aru soe, ma nanin mano ena vanta vá noré íkan minó ano onten mifo ");
INSERT INTO agd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesini man baya ano ma setin tisimikhein mai onámaná kayo fosá ankaman purono sikhen mifo éi inte esá teyá iniya fono.” ");
INSERT INTO agd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Betí ankan ma máa sein mai véi mana vaya sintí iniré mai vayará ben avían kópin kaono van ben máka sin maen Yisasi un baren mátimen ayampóké kayóká bompon uvaren mino. ");
INSERT INTO agd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Uvariyákan betí ankan kokhon dádá inaiyan baimpin Yisasi orun mantaven betin tiamemí, “Tiretí ankan aúbaná pinté mana ume ma ída van nain banta ano nare vá onámaná ankamono.” ");
INSERT INTO agd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Máa siren evaránen mátimen kayóká bompon uvaren mino. ");
INSERT INTO agd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Uvariyákan mai kayo ano mai vaya iniren maen anon banta ráké nare araí uren oriyan minó orian kípavin Yisasi veyáká para kumantan mai nanin mano ana ve vaintá mantakharen mino. ");
INSERT INTO agd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mantakhan Yisasi orun mantaven mai nanin tiamemí, “Anasi oe, mai ma éin kó tiantiyá ein kéká intefasá oren ná ída mana ano éin uman amiyan nafino.” ");
INSERT INTO agd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Máa síkan mai nanin mano semí, “Kákan banta oe, mana ano ída van mino.” Síkan Yisasi semí, “Téin má dere éin ída kó tiantanté umpo orive ída vá evaráne umeí ono.” ");
INSERT INTO agd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Máa siren Yisasi evaránen banasi siamemí, “Téi ma varai oon mumpo séin tínain ma vákurin nain banta ano ída kípan aunan mamaren títípafin ída nonten mino.” ");
INSERT INTO agd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Máa síkan Farasisi kayo ano mai vaya iníden Yisasin evaránen tiamemí, “Éi ei yoran avúava san manan tiyan nan mi vanasi ano eni vayará ída mumunan iyan mino.” ");
INSERT INTO agd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Máa síkan Yisasi evaránen betí ankan tiamemí, “Mai fura ino. Téi sesi sivútivá baya anan tiyá umpo mai vayará minó ano vá mumunan ino. Mai fara vara seyo, séi inte fákesá erikherá inká intefasá oronte rafu mai séi afová ukhé umpo siretí ankan ída uron mi mayin afová ukha rono. ");
INSERT INTO agd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Máan tukheyai ma vara ráke avúavá pói séin daimiya ompo séi ída mai avúavápó mana vanta yaimiyá uno. ");
INSERT INTO agd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Máan tiyá umpo yaimono sé baré banasii avúavá puntádéi yaimon nunaren mino. Para vara seyo, seyaká ana ída vá umpo mai ma sen tisintá erikheruna Sifóen mái súpá ukhé uno. ");
INSERT INTO agd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Erasanti man baya ano máa sikhen mino. Kankanan bantai vaya ano ma manaí intiya mai furan tinten mino. ");
INSERT INTO agd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Máan tukhein nan mi séi seyantá tesi yoran avúavá baya siyákun mi inká ten ma sisintá erikheruna Sifóe ano yere senti yoran avúavá baya anan tiyan mino.” ");
INSERT INTO agd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Máa síkan betí ankan inaemí, “Intesiná e afóe va vae.” Síkan Yisasi evaránen betin tiamemí, “Téin ma afová ukhanteya mai Sifóen má deren afová inompo séin ma ída afová ukhanteya mai Sifóen má deren ída afová inono.” ");
INSERT INTO agd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kákan monó dafufin ma moní kaiyaintái Yisasi váken mi mai monó baya siyan mifo mana ano ída véin páken mino. Mai fara va ino. Beni yamú ída erikhan mino. ");
INSERT INTO agd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Máa siren Yisasi evaránen ena vaya semí, “Téi orivékuya siretí ankan ten nan dosivaeya siretíi umefin purin nono. Mai ma séi oronunafá tiretí ankan ída kanaíeya orin nono.” ");
INSERT INTO agd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Máa síkan Yutan kayo ano mai vaya iniren betiyan ten oreraemí, “Téi ma oronuna varufá tiretí ankan ída kanaíe orin nono ma siyain mai veyantasá beyan aruan purono vará tino.” ");
INSERT INTO agd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Máa sen orera iyákan Yisasi semí, “Tiretí bara ráke ompo séi yante uno. Tireti ma vara finte ompo séi ída ma vara finté uno. ");
INSERT INTO agd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Máan tukhái siretíi umefin purin nona van mi siamiyá uno. Para vara seyo, séi iyé bará teyan nan tiretin tiamiya rafu mairá ma ída mumunan inteya mai siretíi ume avúavápin puraseya furin nono.” ");
INSERT INTO agd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Máa síkan betí ankan béin inaemi, “Mai éi iye fono.” Síkan Yisasi evaránen temí, “Mai ma séi nan iyé ba fono ma siyaona mai vayan o siamé eriyá bá uno. ");
INSERT INTO agd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tiamiyá umpo siretíi avúavá ma yaimin baya kayo kokhon mi sempin ban mifo mai ifá iyá uno. Téin ma sisintá erikheruna vantai avúavá puntákái véin pintena ma inireruna mai vaya kayoi varará nanin banta siamiyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Be Afóen nan mi Yisasi siyákan betí ankan amino ukharen mino. ");
INSERT INTO agd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Amino ukheimpin Yisasi semí, “Banta Anin ma yaa unkamádantá ma yaní inona yamúi séi iyé bará téi uno siya rafu mai afová inono. Tesi sinunurá ída mana yanasí iyá umpo se Sifóe ma sisimein danasíi iyá uno. ");
INSERT INTO agd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Téin ma sisintá erikheruna ano sen má báken téin ída ifáí teyaká bá uno. Para vara seyo, séi ma ena ena yamú bariyaruna mai anon béin amusin amiyan mino.” ");
INSERT INTO agd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Máa siyákan mai vaya iniren kokhon nanin banta ano ventá mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Béintá ma mumunan ein Yutan kéká máa sen tiamemí, “Tenti vaya ma ákona uan pákanona ano fura uron teya senti eyo iyamponíi inono. ");
INSERT INTO agd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Máan ma uveyan pura sikhein baya afová esin mi ma ma fura sikhein baya ano siretí ankan kampun bayai karavusi fintena utúantanten mino.” ");
INSERT INTO agd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Máa síkan betí ankan evaránen béin tiamemí, “Tetí Abaraamun anavasin mi váké pefá araí in táké eriyá ída mana vantai miyan ída van doran bantaí ukhé tifé umpo éi fará pura sikhein baya ano kampun bayai karavusi fintena setin utúantanten mino siya fono.” ");
INSERT INTO agd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Máa síkan Yisasi evaránen temí, “Téi fura siré tiretí ankan tiamiyá uno. Umeí ma iyain kéká ano mai umei miyan ída van doran bantaíi ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Miyan i van doran banta aví ída ven antumpin ban mifo ve anin avíi ve antumpin para van oriyan bá éiyan mino. ");
INSERT INTO agd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Máan tukhein mi ve Anin mano ma siretin nan mai utúanté uno ma sintiya mai siretí ankan pura uron tire kusen ban nono. ");
INSERT INTO agd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tiretí ankan Abaraamun anavasin mi vaná téi afová ukhé umpo siretí ankampin ída senti vaya vákayai séin tiruan purono van iya rono. ");
INSERT INTO agd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Téi se Sifóen má ma váké ontaréeruna yaná máan tiretin tiamiyá umpo siretí ankan afóen pintena ma vareona afova ánain máan dakhafiya ono.” ");
INSERT INTO agd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Máa síkan Yutan kayo ano evaránen béin tiamemí, “Abaraamu setin tifóe ino.” Síkan Yisasi evaránen temí, “Tiretí ankan pura se Abaraamun akhafana ma varé inte mae mai véi ma variyá ein avúavái varan nono. ");
INSERT INTO agd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Máan tukhein nan mi Tiyarafenu ano ma fura vaya sisimein ma siretin tiamiyaruna van mi séin tirono van iya ompo Abaraamu ída máan tin nain ten mino. ");
INSERT INTO agd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Máan tiyákeyan tiretí afóeyani avúavái variya ono.” Síkan betí ankan béin tiamemí, “Tetí ankan ída aasá iyampon bá uno. Tiyarafenu veyáká anan tetin Tifóe uron ban mino.” ");
INSERT INTO agd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Máa síkan Yisasi vetí ankan tiamemí, “Tiyarafenu ma siretin Afóe ma varéintiya mai séin tivábá inonaren mino. Para vara seyo, Tiyarafenu vaípákéi séi eréi mará e vá uno. Téi ída sesi sinunurá erikhé umpo Tiyarafenu anon tisintá erikhé uno. ");
INSERT INTO agd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Máan tukhé umpo senti vaya ma ída iniyaona mai anon tiretí ankan ída kama e afová iya ono. ");
INSERT INTO agd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tiretí ankan Ban Anon akhafanan bákeyai siretí afóeni anunu ánain mi vákuriya ompo esé araíintá béi vanta aruan purin bantan báken béi ída fura sikhein avúavá ánain bákuriyan mino. Mai fara va ino. Pura sikhein avúavá ída vempin ban mifo kampun bantan báken kampun baya afóe uron mino. ");
INSERT INTO agd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Máan tukhein nan mi séi fura sikhein bayan tiyamiyákeyan tiretí ankan ída mumunan iya ono. ");
INSERT INTO agd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tiretí ankan onesí ma séi ma umeí iyákuya mai senti namu yaná maman dákó inompo séi ma fura sikhein baya ma siyákuya mai fará ída mumunan iya rafono. ");
INSERT INTO agd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tiyarafenu akhafana ano minó beni vaya kamaen iniyan mifo siretí ankan ída ven akhafanan bákeyai veni vaya ída iniya ono.” ");
INSERT INTO agd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Máa síkan Yutan kayo ano evaránen bein tiamemí, “Éin nan ma Sameriá bantan ban nan en aúpin namu aunan ban mino ma siyáé tiferuna mai furá tiyá tifé rafuno.” ");
INSERT INTO agd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Máa síkan Yisasi evaránen betí ankan tiamemí, “Téimpin ída mana namu aunan ban mifo séi se Sifóen avíi yaní iyákuyan tiretí ankan ten tiví bararasí iya ono. ");
INSERT INTO agd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Téi se sivisa yaní ono van iya rauno. Ída ino. Tiyarafenu anon ten tiví daní iyáken béi anan daimin banta van mino. ");
INSERT INTO agd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Máan tukhein nan mi fura siré tiretí ankan tiamiyá uno. Tenti vaya ánain ma yakhafin nain nanin banta ano ída uron mi furinten mino.” ");
INSERT INTO agd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Máa síkan Yutan kayo ano semí, “Éimpin namu aunan mi varé íká taréan afová é tiféuno. Abaraamun má sakhanampa vanta kayo vá púkein mi vákayan éi siyákeyan tenti vaya ánain ma yakhafinona vanta ano ída uron mi furin nono siya ono. ");
INSERT INTO agd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Éi iye unó tiya fono. Erasan tiyavéno Abaraamu má sakhanampa vanta kayo vá ma fúkein mai kéká esantakheyá tiya fono.” ");
INSERT INTO agd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Máa síkan Yisasi evaránen temí, “Téi ma se siví daní ékun maen mai sen tiví paen danasíi inten mifo siretí ankan ma seya setisi Tiyarafenu ino ma siyaona anon ten tiví daní iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Máan tiyan mifo siretí ankan béin ída afová ukha ompo séi anan afová ukhé uno. Béin ída afová ukhé uno ma senté mai siretin an dé kákan kampun mi senté paséi séi ven afová ukhéi veni vaya ánain bákuriyá uno. ");
INSERT INTO agd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bakuriyá umpo siretin afóe Abaraamu maen tenti yamú onano van amusin iyan ineine iyaren ódaren amusin en mino.” ");
INSERT INTO agd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Máa síkan Yutan kayo ano semí, “Éi ída fifti (50) oranaí ukha ompo éi Abaraamun ontare vae.” ");
INSERT INTO agd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Máa síkan Yisasi evaránen temí, “Téi fura siré tiretí ankan tiamiyá uno. Abaraamu ída afoká ukhá téi fefái varé uno.” ");
INSERT INTO agd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Máa siyain má betí ankan onámaná kayo máden ankamono van íkan Yisasi aupáké kákan monó namun me ampiren oren mino. ");
INSERT INTO agd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Be anóen amúpimpá auu yufúkukhan kain baré ein banta Yisasi oriyaren onen mino. ");
INSERT INTO agd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Oniyákan bei eyo iyampon kayo ano véin inaemí, “Aru soe, ma vanta ma inamumpá auu yufúkukhein ma kaein mai veni ume ano fi áa ve anóe afóeni ume ano fino.” ");
INSERT INTO agd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Máa síkan Yisasi evaránen tiamemí, “Mai vanta vá be anóe afóen má ída umeíen mifo Tiyarafenui ákona afoká intin onano van mi véin auu yufúkukhein inamumpá kaen mino. ");
INSERT INTO agd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Taréa ma kakhakhein tasá mai ma séin tisintá erikherunai yorarísá ó tifano. Para vara seyo, yunintin maen ída mana vanta ano yoranten mino. ");
INSERT INTO agd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Téi ma ma varará ma varúna mai séi ma vara kakhaantan oon muno.” ");
INSERT INTO agd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Máa siren Yisasi varará akhare siren mai vara fákaren áposí uren mai vanta auufen dampaanten mino. ");
INSERT INTO agd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Dampaantáden mai vanta siamemí, “Oreya vá Siroamú non masípin ná mo non perano. (Siroamu e ma sikhein mai siantan oren nen tikhen mino.) Máa siren tiantan mai auu yufúkukhein banta ano mo non péden erin auu kama íkan kasaen minó daná onen mino. ");
INSERT INTO agd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Oniyákan béini ádé ma varé ein kéká bá inká béi ma fefá banasi vaípá moní inantiyan ma ontaré ein kayo vá ano vetiyan inaen oreraen temí, “Ma fefá ma kumanten banasi vaípá moní inantiyaré ein banta fino.” ");
INSERT INTO agd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Máa siyákan manáa ano sen “mai vanta ino” síkan inká ena kéká ano semí, “Ída ino. Ena véiren banta ino” sin iyaimpin mai vanta ano semí, “Téi mai vanta uno.” ");
INSERT INTO agd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Máa síkan betí ankan béin inaemí, “Intesá uren nan ná auu kamaen nafino.” ");
INSERT INTO agd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Máa síkan béi evaránen temí, “Yisasin ne ma siyain banta anon ápó pákaren tuufen damparen tisinten, ‘Siroamú non masípin mo non pereya ápó tesé ono’ síkái mo fédékun mi sen tuu kama íkái minó daná oniyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Máa síkan betí ankan béin inaemí, “Mai vanta intefasá ban nafino. Síkan “téi ída afová ukhé uno,” sen mino. ");
INSERT INTO agd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Máa siyaimpin mai kéká ano mai ma auu yufúkukharé ein banta yo aviren Farasisi kayo vaintá oren mino. ");
INSERT INTO agd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sabati yamúi Yisasi mai vanta auu kama uanten mino. ");
INSERT INTO agd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Moran Farasisi kayo vá dere ano mai vanta auu ma kama ein nan ina íkan betin tiamemí, “Béin ten tuufen ápó damparái nompin mo sesé uré kamaé oné uno.” ");
INSERT INTO agd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Máa síkan manáa Farasisi kayo ano semí, “Tetí ankan afová ukhé uno. Tiyarafenu ano ma vanta ída siantan erakhen mino. Para vara seyo, véi Sabati yamú durafuren doriyan mino.” Síkan manáa ano semí, “Intesá urená ume vanta ano máan ten ná enará ukhein danasinta aní intéi vae.” Siren beraran aúban daimen mino. ");
INSERT INTO agd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Máan tiyáken mai ma auu yufúkukhá ein banta vetí ankan mano evaránen inaemí, “Mai ma éin ma auu kama uantein banta van iye inó teyá éi iniya fono.” Síkan mai vanta ano evaránen betin tiamemí, “Mai véi mana sakhanampa vanta inon té téi iniyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Máa síkan Yutan kayoi ánon banta kéká ano mai ma fefá auu yufúkukharéin ma saréa auu kama ukhein banta van ída mumunan iyáken mai vanta anóe afóen aren mino. ");
INSERT INTO agd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Arákan míkanan erin maen betí ankan máa sen inaemí, “Ma siré kanan anin nafino. Auu yufúkukhein ná inamumpá kaeona fino. Mai máan ma ukhantin intesá urená béi saréa auu kamaen oniyan nafino.” ");
INSERT INTO agd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Máa síkan be anóe afóe ano evaránen betin tiamemí, “Ma verasan tanin inamumpá auu yufúkukhá kaerunan bá afová ukhé uno. ");
INSERT INTO agd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Máan tukhen mifo intesá uren ná auu kamain ná iye anó auu avové uanten nafi mai verasan ída afová ukhé uno. Béi anon mifo inaesin ná beyantá tinti vá inero.” ");
INSERT INTO agd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Para va vékan máa sen naino. Pefá Yutan kayoi ánon banta kéká ano siyáken Yisasin nan ma Tiyarafenu ano aní ukhein banta ino ma sin nain nanin banta monó átaru namun pintena yo siantanté uno sikhan mai van mi féden máa sen mino. ");
INSERT INTO agd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mai ana vami ve anóe afóe ano siyáken, “Béi anoní ukhein mifo véintá ina ono,” sen mino. ");
INSERT INTO agd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Máa siyaimpin mai ma auu yufúkukhá ein banta evaránen araren tiamemí, “Tiyarafenu avíká pura vá teno. Para vara seyo, Yisasi ume vantan báká teti afová ukhé uno.” ");
INSERT INTO agd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Máa síkan mai vanta ano evaránen betin tiamemí, “Béi ume vanta fi áa ída fi mai séi ída afová ukhé umpo fefá ma séin tuu yufúkukharen ma saréa kama ukhein mai anan afová ukhé uno.” ");
INSERT INTO agd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Máa síkan betí ankan evaránen béin inaemí, “Béi ano éin náisá en nafino. Intesá urená éin auu kama uanten nafino.” ");
INSERT INTO agd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Máa síkan béi evaránen betí ankan tiamemí, “Téi inka siretí ankan tiamikhé umpo fará tiretí ída inintoyá kokhon dádá inaiyá ba rafono. Tiretí ankan masá beni eyo iyamponí onova rafono.” ");
INSERT INTO agd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Máa síkan mai Farasisi kayo ano véin asen temí, “Éi veni eyo iyampon mompo setí ankan Mosesini eyo iyampon kayo uno. ");
INSERT INTO agd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tetí ankan afová ukhékun Tiyarafenu anon Mosesin baya siamiyaren mifo mai vanta inte fákesá erikhen nafi mai setí ankan ída afová ukhé uno.” ");
INSERT INTO agd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Máa síkan mai ma auu yufúkukhá ein banta ano evaránen betin tiamemí, “Mai ma séin tuu kama usintá ma suu mareruna vanta van tiretí ankan ena vayan teya setí béin ída afová ukhé uno inte fákesá béi erikhen nafino siya ono. ");
INSERT INTO agd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tetí ankan minó ano afová ukhé tiféuno. Ume nanin bantai vaya Tiyarafenu ano ída iné iyan mifo mana vanta ano ma véin avaya iníden ma veni anunu yakhafen ma véinta ana ma monó tin nain bantai vayan ineno van ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pefá araí in táké ma eren tare ma varunará ída mana inamumpá ma auu yufúkukhan kaein mai mana vanta ano evaránen auu kama uanten ne síká inikhé uno. ");
INSERT INTO agd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tiyarafenu ano ma ída mai vanta siantantin ma erikhanten maen béi ída kanaíen mana yanasí inten mino.” ");
INSERT INTO agd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Máa síkan betí ankan evaránen béin tiamemí, “Éi ume vái inamumpáké afoká ukha ompo éi fará tetí ankan afova simeno van iya fono.” Siren monó átaru namun pintena véin do yarifaan barufá karúdan araven mino. ");
INSERT INTO agd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mai vanta ma yarifaan karúdein baya Yisasi iniren béin nan dosiren máa sen tiamemí, “Éi Vanta Anintá mumunan iya fo áa ída fino.” ");
INSERT INTO agd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Máa síkan mai vanta ano evaránen temí, “Kákan banta oe, Vanta Anin iye fino. Mai éi sisimirá bentá mumunan ono.” ");
INSERT INTO agd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Máa síkan Yisasi evaránen béin tiamemí, “Ma ma saréa éin má baya siyain mai vantan bákaya éi inka oniya ono.” ");
INSERT INTO agd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Máa síkan mai vanta ano semí, “Bafan noe, séi entá mumunan iyá uno,” siren aron kan durafúden mátimen Yisasintá monó ten mino. ");
INSERT INTO agd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Máan tiyákan Yisasi semí, “Téi vanta anasii avúavá daimono van mi ma varará erakheruna auu ma yufúkukhein kéká ano auu marantin auu ma kama ukhein nanin banta kayo auu yufúkinten mino.” ");
INSERT INTO agd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Máa síkan manáa Farasisi kéká mairá baren mai vaya iniren béin inaemí, “Tetí ankan masá tuu yufúkukhayá éi siya vae.” ");
INSERT INTO agd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Máa síkan Yisasi evaránen betin tiamemí, “Auu ma fura sen dufúkukhantin mi siretí ankani ume ída vanten mifo sireti ma seya suu fara vá oniyá uno ma sinteya mai siretíi ume fara vanten mino. ");
INSERT INTO agd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yisasi máa siren temí, “Téi fura siré tiretí ankan tiamiyá uno. Mana vanta ano ma sipisipii yafu ona ráké ma ída ódinton ma savi finté dafurá káusiven ma ódin nain mai umoyan bantan báken mi enina yaná barano van ódinten mino. ");
INSERT INTO agd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ódinten mifo ona ráké ma ódin nain banta mai vei sipisipirá ma yafisin banta ino. ");
INSERT INTO agd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Máan tukhantin mi onará ma yafisin banta ano ma sipisipirá dafisin banta ma ona yiantádantin minó sipisipi ano véin amen avaya afová ukantin mana mana sipisipi aví ararú intin ekhuven eranten mino. ");
INSERT INTO agd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Dorun ma iyuvintin maen béi an oriyantin minó sipisipi ano vein amen avaya afová ukhen ánain dakhafen orinten mino. ");
INSERT INTO agd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Orinten mifo ena vanta ano ma arantin maen mai vanta amen avaya ída afová ukhen pasen sipisipi kayo ano meren karan orera inten mino.” ");
INSERT INTO agd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisasi mai vaya sian baéan betí ankan amiyan mifo veti ída véi ma siyain baya ana afová en mino. ");
INSERT INTO agd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Máan tiyaimpin Yisasi evaránen betí ankan tiamemi, “Téi fura siré tiretí ankan tiamiyá uno. Téi sipisipi kayoi yafu ona uno. ");
INSERT INTO agd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Esé ma erein banta kayo maen mai ena ina yaná umoyan in banta kékái eríkan mi mai sipisipi kayo ano vetíi vaya ída inen mino. ");
INSERT INTO agd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Máan tukhái séi ona umpo mana vanta ano ma sempin ma eriaren umperan nain bantan Tiyarafenu ano evaránen avídantin kasaen ódiven eraven iyáken kama yunan nanten mino. ");
INSERT INTO agd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Umoyan banta ma erein maen mai vetin aruré asuse iyáké umoyan barano van mi eren mifo séi ma erikheruna mai vetí ankan aunan barantin betimpin bíkano van mi eré uno. ");
INSERT INTO agd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Téi sipisipirá kamaen dafisin banta uno. Kama yafisin banta anon bei sipisipi vare siren bei aunan ampiádé iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Máan tiyan mifo mana vanta ano ma ída sipisipi afóe ma váken maen béi ída kamaen dafisin moníká ana ma yoriyaren onantin ma afá iyan erintin maen béi sipisipi kayo me karúden karan orivintin afá iyan mano sipisipi kayo vákúden arintin karan oreraen asuse inten mino. ");
INSERT INTO agd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Para vara seyo, mai vanta ano miyan baran máarái yoriyaren pasen sipisipirá ída yafisin meren karan orinten mino. ");
INSERT INTO agd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Téi sipisipirá kama yafisiríin bantan báké minó tesi sipisipi kayo afová ukhékun betí ankan má téin afová ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tifóe ano ma séin afová íká ma séi ano véin afová ukheruna van mi mai sipisipi kayo aya ono van te saunan ampiádiyá uno. ");
INSERT INTO agd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tenti sipisipi kayo vá ano ena yafufin bain mai kayo vá o avían mana yafufin kaurékun ten timen avaya afová uven mana kékasí uvintin mana yafisin manan banten mino. ");
INSERT INTO agd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Téi ma se saunan ampiádaré ma evaráné baranuna mai van mi se Sifóe ano se nan anunu iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ída mana vanta ano kanaíen tenti saunan do varanten mifo séi sesi sinunu fintéi se saunan ampenté umpo sempin ákona vantíi saunan ma ampiré maé evaráné barantékun mi mai ákona Sifóe ano séin timikhen mino. ");
INSERT INTO agd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yisasi ma mai vaya kayo siyain má Yutan kayo ano iniren beraran aúban daimen mino. ");
INSERT INTO agd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Daimen orera iyáken kokhon banta ano semi, “Béimpin namu aunan mi vákan béi óen iyan mifo siretí ankan pará á kasédeyá beni vaya iniya rafono.” ");
INSERT INTO agd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Máa síkan ena kéká ano semí, “Ma ída namu aunan ma vain bantai vaya ifo kanaisá en ná namu aunan mano auu ma yufúkukháin nain evaránen kama uantanten nafino.” ");
INSERT INTO agd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Maí damú iyonin aúbaná bákan kákan monó tin damú Yerusaremí afoká en mino. ");
INSERT INTO agd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Máan tukhan maí damú Yisasi maen monó dafufin Soromonini Yuséká noren mino. ");
INSERT INTO agd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Noré íkan Yuta kayoi ánon banta kéká ano véin maman aúban den iyen eúkuven inaemí, “Éi iye uron ná baná tetí ankan éi nan amino iyá tife rafuno. Tiyarafenu ano ma aní ukharé ein banta ma vanteya setin kamaeya sisimeno.” ");
INSERT INTO agd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Máa síkan Yisasi evaránen betí ankan tiamemí, “Téi fefái siretin tiamikhé umpo siretí ída mumunan iya ono. Minó doran ma Sifóen avíká ma yoriyaruna mai anon tiretin aní iyan mifo ");
INSERT INTO agd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","siretí ankan ída senti sipisipi kéká pinte nan bákeya ída mumunan iya ono. ");
INSERT INTO agd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Máan tiya ompo senti sipisipi kayo ano sen timen avaya afová ukhá téi vetí ankan afová ukhékun mi sen tínain dakhafé iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Téi ena ena ma ayun para van oriyan ban aunan amirékun ída afeyoran para vantin maen mana vanta ano ída kanaíen tiyan pintena vetin do varanten mino. ");
INSERT INTO agd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mai fara vara seyo, se Sifóe anon mai kéká téin timikhan béimpin kákan ákona vákan minó esantakhein mana vanta ano ída kanaíen ben ayan pintena yo varanten mino. ");
INSERT INTO agd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Para vara seyo, Tifóe rasan manan bá uno.” ");
INSERT INTO agd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Máa síkan Yutan kayoi ánon banta kayo ano véin aruan purono van evaránen onámaná kayo varen mino. ");
INSERT INTO agd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Máan tiyaimpin Yisasi vetí ankan tiamemí, “Tifóe vaípáken nan kákan aní daná kayo siretin aní iyá umpo mai kayo fintena inte yaná ma variyarúna vará tiretí ankan onámaná tinkamono van iya rafono.” ");
INSERT INTO agd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Máa síkan Yutan kayo ano evaránen béin tiamemí, “Tetí ankan eni kama yoran nara iniré éin onámaná ankamono van iya rauno. Ída ino. Éi varará banta ano ma Tiyarafenui varu variyaona ano véin oyampá bayan tiyan ná mai van mi éin onámaná ankamono van iyá tiféuno.” ");
INSERT INTO agd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Máa síkan Yisasi evaránen betí ankan tiamemí, “Tiretí ankani man bayafin Tiyarafenu ano vetin nan ayarafenu kayo an mi yakhaonó tikhen nafino. ");
INSERT INTO agd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Pefá ma Tiyarafenu ano ma vanta kayo van ma ayarafenu ino ma sikharé intin barará banta kayo ano Tiyarafenui vompon dóki fintena vaya ída kanaíen durafurinten mino. ");
INSERT INTO agd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Máan tukhen mifo Tifóe ano séin iyátintáden mi ma varará tisinta erakhé uno. Erakhéi séi ma Tiyarafenu Anin muno ma siyákuya fará tiretí ankan teyá éi Tiyarafenui varú barano vará iya vae siya rafono. ");
INSERT INTO agd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Téi ma Sifóeni yorarí ma ída iyákuya mai siretí ankan ída vá tenti vayará mumunan ono. ");
INSERT INTO agd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Téi veni yoraríi iyá umpo siretí ankan ma ída senti vayará mumunan inteya mai séi ma minó doran ma yoriyaruna rasá mumunan ono. Máan ma inteyan tiretí ankan kanaíeya afová inono. Tifóe sempin bá téi Sifóempin bá uno.” ");
INSERT INTO agd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Máa síkan betí ankan béin enádá pákano van íkan béi vetin me ampiren oren mino. ");
INSERT INTO agd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Máan tíkan Yisasi evaránen Yodení non ekháden Yoni ma fefá banasi monó non péantiyaré ein baru ádé o varen mino. ");
INSERT INTO agd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","O vákan kokhon nanin banta ano véi vaintá eriven temí, “Pura ino Yoni vei vaya ákona ino van ída mana avúavá aníen mifo minó baya ma ma vanta van tiyaré ein mai furan tiyaren mino.” ");
INSERT INTO agd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Máa siren mai varu ráké kokhon nanin banta ano véinta mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mana Rasarusin ne sin banta vá be ayofi kanan Maria nú Mata nú bá Betaní barurá baréin Rasarusin aí en mino. ");
INSERT INTO agd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mai ma ínaimpáké ma kama auna iyain uverifó ma Yisasin arantantá banaren ma ve ánon do fóké ma yo arumin nain nanin mi Maria varéin be aváe Rasarusin aí iyan baren mino. ");
INSERT INTO agd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Baré íkan míkan anananosan mano Yisasi vaípá baya yan oríkan temí, “Bafan noe, mai ma éi moéke anunu iyaona vanta aí iyan ban mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mai vaya ma Yisasi iniyáken béi semí, “Mai aí ma vain mai fura sen purin aisa van naino. Tiyarafenu ano vei ákona vanasi aní intin mai finté uaren be anin mano kákan bí barano van mi mai aí pákakhen mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yisasi ano Rasarusin má be ayofi kanan Matan nú Marian nú ba san mi moéken anunu ukharen mino. ");
INSERT INTO agd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Máan tukharé íkan béi ma Rasarusini aí baya ma iniren maen mai ma véi varé ein barurá kan damú bá evaránen baren mino. ");
INSERT INTO agd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Baré íkan kan damú orivin bei eyo iyampon kayo siamemí, “Erí Yutan barafá evaráné oró tifano.” ");
INSERT INTO agd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Máa síkan bei eyo iyampon kayo ano véin tiamemí, “Aru soe, sare uron mi Yutan kayo ano éin onámaná ankamono van ein mifo mai varufasá éi evaráne orono van iya fono.” ");
INSERT INTO agd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Máa síkan Yisasi evaránen betí ankan tiamemi, “Tiyan míkan mifo sirantan kan orun kádan (12) auará ídá kakhaken báé iyan nafino. Mana vanta ano ma kará ma nóken ída eyúpóen ankaminten mino. Mai fara va ino, ma varai kakhan oniyan pasen mino. ");
INSERT INTO agd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Máan tiyaren ma yúdufumpin orinten maen béi eyúpóen ankaminten mino. Mai fara vara seyo, véin ma kakhantan oon ída van mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Máa siren Yisasi vetí ankan tiamemí, “Tetisi sirona Rasarusi maen aun mi vakhein mai finte mo avoranté uno.” ");
INSERT INTO agd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Máa síkan bei eyo iyampon kayo ano mai vaya iniren béin evaránen tiamemí, “Bafan noe, véi ma auun bakhá inten evaránen e mantanten mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Rasarusini furí pákena van mi Yisasi siyákan bei eyo iyampon kayo ano yo inian aun mi vakhan man tino sen mino. ");
INSERT INTO agd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Máan tiyaimpin betí ankan pámanen tiamemí, “Rasarusi fúkái ");
INSERT INTO agd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","siretí ankan mumunan ono van mi iniré béin má mairá ída o varé umpo erí béin o onatifano.” ");
INSERT INTO agd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Máa síkan Tomasi nan ma Didimasin ne siyain mano ena eyo iyampon kayo siamemí, “Erí tetí ankan má oré béin má manafin o furó tifano.” ");
INSERT INTO agd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yisasi ma Betaní barurá oriven iníkan maen Rasarusin nan pe fúbin masí uran kamí kamí damú orikhen ne sen tiamen mino. ");
INSERT INTO agd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaní baru ráké ma Yerusaremí barurá ma oriyain mai kankanan maerin bákan ");
INSERT INTO agd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yutan kayo ano Mata nú Maria nú ayofi ma fúkan bain nan ará kusiantano van e varen mino. ");
INSERT INTO agd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata iníkan maen Yisasi nan eriyan ne síkan béin o onanono van oren mifo Maria maen ifá en mápin baren mino. ");
INSERT INTO agd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata ma Yisasin o oniyáken temí, “Bafan noe, éi mará baréesin te siyofi ída furin nainten mino. ");
INSERT INTO agd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Máan tukhen mifo saréa yere ma éi mana yana san Tiyarafenu vaípá ma inantesin maen éin amintéí téi afová ukhé uno.” ");
INSERT INTO agd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Máa síkan Yisasi véin tiamemí, “E ayofi evaránen e mantanten mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Máa síkan Mata véin evaránen tiamemí, “Ínaimpá ma ma vara kípan nain damú ma minó nanin banta ano ma e mantiyantin maen béi e mantantéí mai séi afová ukhé uno.” ");
INSERT INTO agd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Máa síkan Yisasi véin tiamemí, “Evaránen ma e mantan má aunan ma varan má téi umpo sentá ma mumunan uven púkaréin nain mano mai finté evaránen aunan baranten mino. ");
INSERT INTO agd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Baranten mifo iye anó para váken téintá mumunan inten nafi mai ano ída uron mi furinte mino. Mairá éi mumunan iya fono.” ");
INSERT INTO agd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Máa síkan Mata evaránen béin tiamemí, “Eyo Bafan noe, éi Tiyarafenu Anin báke mai ma ma varafin erinten ne ma sen béi aní ukhá ein bantan baná téi mumunan iyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata ma máa siren maen evaránen oren be aunana Marian mo araan aúpá kaúden tiamemí, “Arú ano e váken éin nan ina iyan mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Máa sein baya ma Maria inen maen ainen e manten Yisasi vaípá oren mino. ");
INSERT INTO agd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yisasi ída mai varufin ódikhen mai ma Mata má o fóken baya seintá para varen mino. ");
INSERT INTO agd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria ma ainen e manten barufá aravíkan mai ma véin ará kusiantano van mápin baré ein Yutan kayo ano ma onen maen masíkái mo arunaná barano van mi oriyan mino siren betí ankan béin bákuren oren mino. ");
INSERT INTO agd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Oríkan Maria ma Yisasin o oniyáken béin arantampin o mátimen temí, “Bafan noe, éi mará bano se varé esin te siyofi ída furin nainten mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Máa siren Maria ifí dákan mai ma véin má orikhá ein Yutan kayo ano yere ifí diyaimpin Yisasi onan béin aúpin ákuna ano víken mino. ");
INSERT INTO agd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Máan tiyáken béi inaemí, “Intefasá béin masí uren nan ban nafino.” Síkan “Bafan noe, erive onano,” sen béin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Máa síkan Yisasi ifí den mino. ");
INSERT INTO agd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ifí dan maen Yutan kayo ano semí, “Onano. Aúkákéi véin nan anunu ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Máa siyákan manáa ano semí, “Béi auu yufúkukhá ein kayo kama uantan oniyain mifo ma vanta ma ayaintin ída furoren mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yisasin arápin evaránen arunaná édaviyaimpin masíká oren mino. Mai masí maen ompin boraádan baré íkan maifin masí uren oyirá onámaná iyádan baren mino. ");
INSERT INTO agd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Baré íkan Yisasi semí, “Masí oyi ráke onámaná do varano,” síkan maen mai ma fúkein banta ayofi Mata semí, “Bafan noe, kamí kamí damú orikhein aunka inten mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Máa síkan Yisasi semí, “Téi ídá éin tiamerá mumunan ma inteya Tiyarafenui kakhan ákona onan nono sikha rafuno. ");
INSERT INTO agd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Máa síkan betí ankan masí oyi ráke onámaná do mádan maen Yisasi inarufá kakháben máa semí, “Tifóe oe, éi ma senti simúkin iniyaona van mi susu sé uno. ");
INSERT INTO agd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Éi ena ena yamú tenti simúkin iniyaonan bái afová ukhé umpo ma ma iyukhein nanin banta ano éin nan mi séin tiantan erikhen mino sen afová iyáken mumunan ino van mi siyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Máa siren Yisasi avádóden oovararen temí, “Rasarusi oe, e khuve erano.” ");
INSERT INTO agd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Máa sen Rasarusin ariyain má davaráe fóké minó bukhafa úkukhein mano e khuáden barufá erákan Yisasi mai nanin banta siamemí, “Davaráe yo utúantá desin orino.” ");
INSERT INTO agd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Máan tíkan ódaren mai ma Maria má o van arunaná bariyá ein Yutan kayo ano Yisasintá mumunan en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mumunan iyákan mai finté manáa ano oren mai ma Yisasi varein avúava san mo Farasisi kéká tiamen mino. ");
INSERT INTO agd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tiamíkan monó ánon banta kéká bá Farasisi kayo vá ano Kanisori kéká aran e átaru uvin betin inaemí, “Ma ma enará ukhein aní danasinta ma uvaren dararen iyain banta amaniná naisá otifante rafuno. ");
INSERT INTO agd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tetí ankan ma véin á ékun mai avúavasí ma iyantin minó nanin banta ano véintá mumunan intin maen Romui kamanin mano eriven tetinti kákan monó namun má bara vá máden namu uren asuse inten mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Máa síkan mai aúbanté Kaiafasin ne sin banta mai oranafin monó ánon banta kékái ánon bantai ukharen e manten temí, “Mai ma siyaona vaya siretí ankan ídá afová ukha ono. ");
INSERT INTO agd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ída afová ukha ompo minó nanin banta ano o afeyoran nafo mana vanta ano ma vetin nan o furintin mai anan kama inten mino.” ");
INSERT INTO agd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mai vaya ma Kaiafasi sein mai ída vei ineine finté ten mifo mai oranafin monó ánon banta kékái ánon bantaíi véi ukhen banasi aya ono van ma Yisasi furin nain nan mi sakhanampa vayan Yutan barafin ma vain nanin banta kayofin tiáden mino. ");
INSERT INTO agd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mai varafin ma vain nanin banta máa vara siáden naino. Mai ma minó barafá ma Tiyarafenu akhafana ma vain o avían átaru urantin mana kékasí ma inain mai va san mi siáden mino. ");
INSERT INTO agd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Máan tukhan béin ma arintin purin nain aa van maí damúké araíen dosen mino. ");
INSERT INTO agd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dosiyákan mai van Yutan kayo avorá non nan Yisasi me ifá en Ifraimí baru ádé kámá barafá bei eyo iyampon kayo vá o varen mino. ");
INSERT INTO agd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","O vákan Tiyarafenu ano ma Isareri kéká Avo Uantein Damú ádé iyákan minó pimpáké banasi ano Tiyarafenu avorá avusese ono van Yerusaremí barurá ana óden mino. ");
INSERT INTO agd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Un báken betí ankan Yisasin nan dosian more mere uvaen monó barurá o átaru uven beraran inaemí, “Tiretí ankan náié té iniya rafono. Béi ma omápin erinten nafino.” ");
INSERT INTO agd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Máa siren dosiyan maen monó anon banta kéká bá Farasisi kayo vá ano vanasi siamemí, “Yisasi ma onan nona ano vá me sisimirá o fáká tifano.” ");
INSERT INTO agd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Avo Uantan Damú ma afokáin nain mai yan manápá ifo afápá mana un kádan damú ana ukhan mai ma fúkaréin masí pinte avoran e mantein banta Rasarusini varurá Betaní Yisasi o unen mino. ");
INSERT INTO agd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Onóbin Yisasin nan amusin uren ma samádan dunan Mata kuviyákan mai ma Yisasi má ma yunan nan takhó ma mamáden kumanen eúkukhein kayo aúbaná Rasarusin má dere kumantaren mino. ");
INSERT INTO agd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kumantan Maria ano mana kama aunka iyain uveri anan aúbanáké ukhein baren me Yisasin arantantá banaren tesé uantáden be ánon do fóké arumiyákan mai namumpin kama aunka ano víken mino. ");
INSERT INTO agd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Máan tiyaimpin mai ma ínaimpáké Yisasin avían namuro ayampin amin nain banta Yudas Iskariotin ne sin mano mai van ída amusin iyáken temí, ");
INSERT INTO agd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kákan moníká bain uveri anan mifo ídá áenasá baré mo sarí uresá mai monípó ona ma i vain kéká ame runo.” ");
INSERT INTO agd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Béi ma máa sein mai ona i van nanin banta aya onovara sen naino. Béi umoyan bantan báken moní unantá dafisiyan maifinte variyain bákan mi máa sen mino. ");
INSERT INTO agd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Máa síkan Yisasi evaránen béin tiamemí, “Ma nanin áesin máan tino. Téi ma masípin oronuna maí damúken pétintiyan mino. ");
INSERT INTO agd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ona ma i van nanin banta anon tiretin má ena ena vanti van nompo séi ída siretin má ena ena vanté uno.” ");
INSERT INTO agd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yutan nanin banta ano iníkan ma Yisasin nan Betaní barurá e van ne sin maen béin má inká mai ma fúkáin ma avían mantakhein banta Rasarusin má onano van oren mino. ");
INSERT INTO agd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Máan tiyákan monó ánon banta kayo ano Rasarusin dere aruan purono van en mino. ");
INSERT INTO agd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Mai fara va ino. Yisasi ano ma Rasarusin orun avían mantakhein nan Yutan kayo ano monó ánon banta kéká me ampiriyan Yisasintá mo mumunan iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ená damú Yisasin nan Yerusaremí ereno van ayanafá eriyan ne sin baya ano mai ma Avo Uantan Damú monó teno van Yerusaremí barurá o iyiyá ein nanin bantafin orera íkan inen mino. ");
INSERT INTO agd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Iniren minó nanin banta ano kefo anaí uaren béin aayana fáke o avirano van oriyan oovararen temi, “Béin avisá daní ino! Bafan avíká ma eriyain banta vá avábá uantano! Isarerii kin avisá daní ono!” ");
INSERT INTO agd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tiyarafenui vompon dóki ano ma sikharé einíen mana ano ída ané kumantaré ein donkin arará Yisasi yosiren mai amaniná kumamen eren mino: ");
INSERT INTO agd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saioní nanin banta oe, onano mana ano ída ané kumantaré ein donkin arará amaniná tiretíi kin mano kumamen eriyan mifo ída vá akhokho van ono.” ");
INSERT INTO agd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Beni eyo iyampon kayo ano amino ukharen mifo Tiyarafenu ano ma Yisasin purin pinte orun avían mantaren kákan bí amiran maen ínaimpákéi vetí ankan afová iyáken bompon dóki ano Yisasin nan mi sikharen mino sen mai avúavá ma afoká ein nan ovaren me inen mino. ");
INSERT INTO agd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Máan tiyákan Rasarusi fúbin masí ukháin ma Yisasi ano aran e manten eran ma ontaré ein nanin banta ano ena nanin banta mo siamin mai vaya ano oreraen mino. ");
INSERT INTO agd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mai ma enará ukhein daná ma aní ein baya ma inikhá ein nanin banta anon béin aayana fáke o avirano van oren mino. ");
INSERT INTO agd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Máan tiyaimpin Farasisi kayo ano veraran ten oreraemí, “Onano minó nanin banta ano ma véin bákuren oriyain mano setisi aaí ída iyan mino.” ");
INSERT INTO agd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Avo Uantan Damú ma vanasi ano Yerusaremí monó teno van ódiyan maen Kiriki kayo vá maifin o varen mino. ");
INSERT INTO agd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","O varen mai kéká ano oren Karirí akhempá ma vain baru Betsaidáke vanta Firipi vaintá oriven inaemí, “Kákan banta oe, Yisasin onátifano van muno.” ");
INSERT INTO agd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Máa síkan Firipi ano Enduru mo siamíden míkanan mano Yisasin mo siamen mino. ");
INSERT INTO agd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tiamíkan Yisasi evaránen békanan tiamemí, “Banta Anin ma kákan bí baran nain maí damú inka afoká en mino. ");
INSERT INTO agd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Téi fura siré tiretí ankan tiamiyá uno. Mana uviti ayun ma varafin ída aravinten maen ída e ampaminten mifo varafin ma orun peran nain manon e ampamaren kokhon aran imádanten mino. ");
INSERT INTO agd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Máan tukhen mifo mana vanta ano ma vei aunan pákaan ákona iyáintin maen mai o afeyoranten mifo mana vanta ano ma ma varará bei aunan ma ampiyáintin maen beni aunan pákarantin ayun para van oriyan banten mino. ");
INSERT INTO agd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mana ano ma senti yorarí ono van téin tínain ná bákurino. Para vara seyo, senti yoran banta ano se ma vanunarái vanten mino. Te Sifóe ano mai ma senti yorarí iyáin nain bantan kákan bí aminten mino.” ");
INSERT INTO agd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Máa siren Yisasi semí, “Taréa sen tirá ano uman diyá umpo náiesá ten nuno. Tifóe oe, ma uman pinte siya onó tente rafuno. Ída ifo mai ma eriyain uman barano van mi erikharé uno. ");
INSERT INTO agd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tifóe oe, e avisá maman kákaní ono” siyain má inaru fáké mana vaya eriyáken temí, “Te siví inka maman kákaní uráké evaráné maman kákaní onté uno.” ");
INSERT INTO agd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Máa síkan mairá ma iyukhá ein nanin banta ano siyáken aafan kankaré tiyan mino síkan manáa ano enisori anon béin má baya siyan mantino sen mino. ");
INSERT INTO agd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Máa síkan Yisasi semí, “Mai ma ineona vaya mai séin tiyain baya vaino. Ída ino. Tiretin ma ayain baya ino. ");
INSERT INTO agd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Barará nanin bantai avúavá ma yaimin damú inka afoká ein ma varará ma yafíká ein ánon banta Tiyarafenu ano vákúdantin orinten mino. ");
INSERT INTO agd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Máan tinten mifo ma vara ráke ma séin maman daní urantí maé minó nanin banta o avíádékun téi varunará erinten mino.” ");
INSERT INTO agd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yisasi ma mai vaya sein mai veyan ma furin nain avúavá páken nan tiamen mino. ");
INSERT INTO agd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tiamíkan banasi ano semí, “Man bayafin inétifékun Tiyarafenu ano ma aní ukhein banta ano fara van oriyan banten ne sikhen mifo inté uáké Banta Anin maman daní inte ne siya fono. Banta Anin mai iyé ban nafino.” ");
INSERT INTO agd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Máa síkan Yisasi vetí ankan tiamemí, “Tiretí ankan ma kakhaantan oon mano sító máarái vantin dunin mano siretin maman barará danten mifo vá tiretimpin ma oon báken kakhaan tiyaintasá nono. Títípafin ma oriyain banta ano mai ma véi oriyaípá ída afová ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mai oon ma siretin má bain nan ma ákona mumunan inte mae mai oon akhafanaíi inono.” Yisasi ma mai vaya kayo vanasi siamíden maen me onen aúpá oren mino. ");
INSERT INTO agd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yisasi ma enará ukhein danasinta ma vanasi avorá aníiyan maen betí ankan ída véintá mumunan iyaren mino. ");
INSERT INTO agd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Máan ma ein manon sakhanampa vanta Aisaiya ma siádan baré ein bayan mo kanaíen mino: “Bafan noe, iye anó tetinti vayará mumunan iyan ná inká intéa kékápin ná Bafan mano vei ayain ákona aní inten nafino.” ");
INSERT INTO agd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Para va vanasi ano ída mumunan en naino. Aisaiya ma ena vompompin máa sikhein anará ino: ");
INSERT INTO agd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tiyarafenu ano vetí ankan auu yufúkuádaren aráká iyádan mai van ída kanaíen oniyáken aúkáké inen ará baerái ída ayofé uno.” ");
INSERT INTO agd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Para va máa sikhan naino. Aisaiya ano Yisasini kakhan ákona ódaren mai van mi siádan baren mino. ");
INSERT INTO agd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Máan tiyákan maí damú ana kokhon Yutan kayoi ánon banta kéká ano Yisasintá mumunan ukharen mifo Farasisi kayo ano monó átaru namun pinte yo siantan nain nan mi féden betíi mumunan ída sian páman en mino. ");
INSERT INTO agd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Para va ino, Tiyarafenu ano ma vetin aví daní in nan ída fura anunu ukharen mifo vanasi ano ma vetin aví daní in nan mi moéken anunu ukharen mino. ");
INSERT INTO agd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Máan tiyákan Yisasi avádóden oovararen temí, “Mana vanta ano ma sentá mumunan iyain mai séintá ana va mumunan iyan naino. Mai ma séin tisintá erikheruna mai Tiyarafenurá deren mumunan iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Máan tiyáken ma séin tonanten maen mai ma séin tisintá erikheruna Tiyarafenu vái oniyan mino. ");
INSERT INTO agd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Téintá ma mumunan in nain nanin banta ano ída yúdufumpin bano van mi séi ma varará oon an davé erikhé uno. ");
INSERT INTO agd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mana vanta ano ma senti vaya iniren ída kamaen dafisin nain nan ída véin daimonté uno. Para vara seyo, vanasi yaimon novara erikhe rauno. Ída ino. Betin aya uré evaráné avirano van mi erikhé uno. ");
INSERT INTO agd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Erikhé umpo senti vaya ma iniren átakharé iyain kéká ma yaimin nain banta mai van mino. Mai ma vetin tiamiyaruna vaya anon ma vara ma akhení inain damú betin uman aminten mino. ");
INSERT INTO agd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Para vara seyo, ída sesi ineine finté tiamiyá umpo se Sifóe ano ma sisintáden ma máan ná teno ma sen tisimikharé ein bayan tiamiyá uno. ");
INSERT INTO agd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Téi afová ukhékun mi véi ma sisimikhein baya ano ayun para van oriyan ban aai aní ukhen mino. Máan tukhái mai vaya vá teno ma siren Tifóe ano ma sisimikhá ein bayan tiamiyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tiyarafenu ano ma Isareri nanin banta Avo Uantan Damú ádé iyákan Yisasi veyan ma ma vara me ampiren ma ve Afóe vaípá orin nain damu inká afoká en mino sen béi afová en mino. Bei vanasi ma ma varará bain nan anunun iyaren mi véi ma furin nain manon mai anunu maman dákó inten mino. ");
INSERT INTO agd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Inúpáké betí ankan kumanten dunan niyákan mai ma Yisasin avían namuro ayampin kaintin ma arin nain banta Saimonin anin Yudas Iskariotin aúpin Ban Ano mano fében ineine amen mino. ");
INSERT INTO agd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yisasi afová ukhan be Afóe ano minó daná ben ayampin mana amikhan béi Tiyarafenu vaípáké erikhein mai véi evaránen Tiyarafenu vaípá orinten pasen ");
INSERT INTO agd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","dunan nan takhókáké orun mantaaren bei ayá au anamun do yavaman kaúden tauri maman avisafin damen mino. ");
INSERT INTO agd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Damuren mana yókifin non banaan kaúden bei eyo iyampon kayo arantan tesé uriyan mai ma avisafin damukhá ein taurifó arúantádú en mino. ");
INSERT INTO agd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Máan ten oriyaren Pita vaintá oríkan béi semí, “Bafan noe, pará éi sen tirantan tesé into fono.” ");
INSERT INTO agd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Máa síkan Yisasi evaránen béin tiamemí, “Taréa ma séi variyaruna yaná éi ída afová ukha ompo ínaimpái afová inono.” ");
INSERT INTO agd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Máa síkan Pita véin tiamemí, “Téin tirantan ída vá tesé ono,” síkan Yisasi evaránen béin tiamemí, “Éin arantan ma ída sesé ékuya mae éi ída kanaíeya senti eyo iyampon ban nono.” ");
INSERT INTO agd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Máa síkan Pita evaránen temí, “Máan ma inte mae ída vá tirantan máa ana sesé iyáke siyan má tínon má dere vá tesé ono.” ");
INSERT INTO agd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Máa síkan Yisasi véin tiamemí, “Non ma fékein banta ano avusese ukhen mai van ída enádá non peré iyan mifo arantan máan tesé é iyan mino. Tiretí ankan inka avusese ukha ompo ída minó ano avusese ukha ono.” ");
INSERT INTO agd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Para va máa sen naino. Namuro ayampin ma véin avían kain nain banta Yisasi fe afová ukhen mai van mi minó ano ída avusese ukha ono sen mino. ");
INSERT INTO agd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yisasi vetí ankan arantan ma sesé uan kíparen bei ayá au anamun maman uren takhoká kumamen máa sen betin inaemí, “Ma ma séi vareruna yanái ana siretí ankan afová ukhe fono. ");
INSERT INTO agd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tiretí ankan ma Aru soe Bafan noe ma se séin tariyaona mai furan tiya ono. Para vara seyo, séi siretí ankani Arú bá Bafan mái vá uno. ");
INSERT INTO agd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Téi Bafan má Arú bá ma váké arantan tesé uanterunaí e vá ena nanin banta vasá arantan teséin maran ono. ");
INSERT INTO agd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Téi ma avúavái siretí ankan aní é umpo ma ma sirétintá ma aníeruna mai avúavá ana vá dakhafono. ");
INSERT INTO agd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Téi fura siré tiretí ankan tiamiyá uno. Doran banta ano ída vei ayafa esantakhan inká baya ma varen orin banta ano ven ma siantein banta ída esantakhen mino. ");
INSERT INTO agd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ma ma séi ma siameruna vayai ana inka siretí ankan afová e ompo mai vaya ánain ná kama e vákuriya sin ná maen mi avábá banti van nono. ");
INSERT INTO agd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Téi ma avían tesinaí ukheruna mai minó kayo vara siya rauno. Tiyarafenui vompon dókifin ma máa sikhá ein mai fura sen afoká inten mino. ‘Téin má ma mana yókifin dunan niyain banta anon ten tínon dasamono van arantan daní iyan mino.’ ");
INSERT INTO agd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Mai yaná ída afoká ukhái saréa siretí ankan tiamiyaruna ínaimpá ma afoká intiya séin nan mai ma Tiyarafenu ano ma aní ukhá ein banta ino seya afová ure mumunan inono. ");
INSERT INTO agd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Téi fura siré tiretí ankan tiamiyá uno. Tenti vaya ma varen orin nain banta ma kama inteya mai sen má deren kama inono. Téin ma kama inteya mai sen ma sisintá erikheruna Sifóen má deren kama inono.” ");
INSERT INTO agd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Máa sirákan Yisasin ará ano uman deimpin mairá béi semí, “Téi fura siré tiretí ankan tiamiyá uno. Tiretí ankan pinté mana ano sentin namuro ayampin tivían kain nono.” ");
INSERT INTO agd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Máa síkan bei eyo iyampon kayo ano iye nará tiyan nafi siren beraran onan maran uren amino en mino. ");
INSERT INTO agd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Amino en orera iyákan mana Yisasi ma anunu ukhein mai eyo iyampon mano veni ádé kumantaren mino. ");
INSERT INTO agd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kumantaré íkan Pita ano ánon póké tiamemí, “Iye anó máan tinté iná tiyan nafi mai véin ina ure ineno.” ");
INSERT INTO agd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Máa síkan mai eyo iyampon mano Yisasin ádé e afánen o súpá uven inaemí, “Bafan noe, éi iyen nará tiya fono.” ");
INSERT INTO agd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Máa sen ina íkan Yisasi evaránen tiamemí, “Dunan anufin ma vereti yaré orun maman amenuna mai vanta ino,” siyáken bereti máden dunan anu yókifin daaren Saimonin anin Yudas Iskariotin amen mino. ");
INSERT INTO agd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Amikan Yudasi ma mai vereti naran maen Ban Anon mano véin aúpin un periyain má Yisasi véin tiamemi, “Éi ma varano van ineine iyaona yaná aine varano.” ");
INSERT INTO agd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yisasi ma mai vaya Yudasin tiamiyákan mai yunan nan takhó akhempá ma kumanen eúkukharé ein kéká ano mai vaya ana ída afová en mino. ");
INSERT INTO agd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasi vetí ankani moníká dafisin bantan bákan manáa ano ma inein mano véin nan mai ma Avo Uantan Damú ma nan nain dunan ná baranten nafi áa ona ma ída van kayo amino vará Yisasi véin tiamiyan nafi sen beti inikharen mino. ");
INSERT INTO agd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Máa siyain má Yudasi ma mai vaya iniren ainen e manten dunteimpin barufá araven mino. ");
INSERT INTO agd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasi ma e manten barufá aravuvin maen Yisasi semí, “Taréa Vanta Anin mano kákan bí barantin maen Tiyarafenu ano Vanta Anintá kákan bí baranten mino. ");
INSERT INTO agd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Máan ten ma Tiyarafenu ano kákan bí ma mamaren maen Banta Anin ainen kákan bí aminten mino. ");
INSERT INTO agd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tikhafana oe, séi sító máarái siretin má barééku mae sireti sen nan dosin nompo Yutan kayo ma siameruna mai vaya anan tiretí ankan tiamiyá uno. Téi ma oronuna varufá tiretí ankan ída kanaíeya orin nono. ");
INSERT INTO agd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Máan tukhein nan mi saréa auyen man bayan tiretin amiyá uno. Téi ma siretin nan ma sinunu iyarunaí ana eya vá ena van anunu ono. ");
INSERT INTO agd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ben nan anunuin maran ma esin ma minó nanin banta ano afová uren maen mi siretí ankan nan tenti eyo iyampon kayo ino sinten mino.” ");
INSERT INTO agd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Máa síkan Saimon Pita ano Yisasin inaemí, “Bafan noe, éi intefasá orinte vae.” Síkan Yisasi evaránen béin tiamemí, “Téi ma oriyaruna varufá éi saréa ída kanaíeya sivákurin nompo ínaimpákéi orin nono.” ");
INSERT INTO agd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Máa síkan Pita evaránen béin inaemí, “Bafan noe, séi en nan purono van mi útakhé umpo náisá ukhantirá taréa séi ída éin avákurontéku vae.” ");
INSERT INTO agd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Máa síkan Yisasi evaránen temí, “Éi kanaisáeyá téin nan purinté tiya vae. Téi fura siré éin tiamiyá uno. Inuran kúkarópasí iyantin ma kokore ída asíkantiya éi kanú manaú dádá téin nan ída afová ukhé uno sin nono.” ");
INSERT INTO agd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Tiretí ankan ída vá kokhon ineine ureya ará uman diya vá bano. Tiyarafenurá ma mumunan ukhan te vá mai sentá bá dere vá mumunan ono. ");
INSERT INTO agd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tifóen amápin kokhon karafaran bákái siretí ankani varu mo funtáantano van mi séi oronté umpo ída máan tukharé intí téi ma vaya siretin tiamen nunaren mino. ");
INSERT INTO agd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Téi ma siretí ankani varu ma mo funtáádaré maé ovaráné eré tiretin e avirékuya sen má oreya séi ma varuna varurá tireti má o van nono. ");
INSERT INTO agd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","O van nompo séi ma orono van iyaruna mai varufá ma orikhein mai aa inka sireti afová ukha ono.” ");
INSERT INTO agd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Máa síkan Tomasi véin inaemí, “Bafan noe, setí ankan ída afová ukhé umpo éi intefasá oriya vae. Intesá urerá tetí ankan mai aa afová onte rafuno.” ");
INSERT INTO agd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Máa síkan Yisasi evaránen béin tiamemí, “Téi anan aa váké pura vayai ana váké inká ayun ma fara van oriyan ban aunan mi vá uno. Mana vanta ano ída kanaíeya ena aa sáké oriareya Sifóe vaípá orin nompo séin pinté uaren anan orin nono. ");
INSERT INTO agd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tiretí ankan ma séin pura se afová ukharé inteya mai Sifóen má kanaíeya afová inonaren mino. Taréan araí eya Sifóen afová e véin one ono.” ");
INSERT INTO agd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Máa síkan Firipi semí, “Bafan noe, e Afóen aní esí ma onékun mai anan kanaí inten mino.” ");
INSERT INTO agd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Máa síkan Yisasi véin tiamemí, “Firipi oe, ayá damúi séi siretí ankan má bákeya ompo éi ídá téin afová ukhe fono. Banasi ano ma séin toniyain mai Sifóen mi oniyan mifo éi fará e Afóen aní ono siya fono. ");
INSERT INTO agd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Téi Sifóempin bákun inká Tifóe ano séimpin ban ukhen mifo éi ídá mumunan iya fono. Tesi ineine fintesa séi siretí ankan baya siamiya rauno. Ída ino. Sifóe ma sempin bain manon téin pinté uaren mi vei yorarí é iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tifóe ma sempin bá ma séi véimpin ma varuna mairasá mumunan inompo ída ma mumunan inteya mai ma minó doran ma séi variyáku oniyaona mairasá mumunan ono. ");
INSERT INTO agd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Téi fura siré tiretí ankan tiamiyá uno. Téintá ma mumunan inain mano sen ma yoriyáeruna yoran manáa esantaren doranten mino. Para vara seyo, séi se Sifóe vaípái oronté uno. ");
INSERT INTO agd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tiretí ankan ma minó dana san ma sen tivíká inantesí maé mai yanasí kasaé uantanté uno. Para vara seyo, ve Anin mano ma mai yorarí inaintá be Afóe ano kákan bí baranten mino. ");
INSERT INTO agd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tiretí ankan ma minó dana san ma sen tivíká ma inaesí téi mai yanasí kasaé uantanté uno. ");
INSERT INTO agd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Tiretí ankan ma sen nan anunu inteya vá minó tenti vaya ánain ná kamaeya vákurono. ");
INSERT INTO agd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Bákuriya sirá Tifóen tékun ná ena siretin Ayain amintin ná mai ano siretí ankan má ena ena van oriyan bano. ");
INSERT INTO agd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mai Ayain maen pura vaya ana ma sin Aunan mino. Barará nanin banta ano ída kanaíen béin baren onen afová en inten mino. Mai fara vara seyo, siretí ankan má béi vákaya ven afová ukheona siretimpin mi vanten mino. ");
INSERT INTO agd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Téi ída me ifáékuya aso iyampon an dan nompo siretí ankan baonafá téi erenté uno. ");
INSERT INTO agd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Titó anantá barará nanin banta ano séin ída enádá tonanten mifo siretí ankan manan ten tonan nono. Téi saunan para vantí bákeya siretí ankan má aunan para vantiya van nono. ");
INSERT INTO agd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Téin ma furin pinte ma sivorantí e mantékuya maí damúi afová inono. Téi Sifóempin bákuya siretí ankan tempin baná téi siretimpin bá uno. ");
INSERT INTO agd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tenti man baya ma mana ano ma iniren kamaen mai ánain dakhafin nain mai ano sen nan mi anunu iyan mino. Mana ano ma sen nan anunu intin te Sifóe ano venan anunu intí ten má dere véi nan tinunu uré teyan aní onté uno.” ");
INSERT INTO agd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Máa síkan Yudasi ano Yisasin máa sen inaemí, “Bafan noe, éi intesá eyá tetí ankan mana eyan aní ureyá barará nanin banta ída kanaí e aní inte fono.” (Yudas Iskarioti ena ifo ena eyo iyampon ma manaí ukhein bí dakhein manon inaen mino.) ");
INSERT INTO agd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Máa síkan Yisasi evaránen béin tiamemí, “Banta ano ma séin nan anunu uren tenti vaya ánain ma kamaen dakhafintin maen Tifóe ano mai vanta van anunu inten mino. Máan tintí berasan mai vanta vá o vá ena ena fara vá oriyá banté uno. ");
INSERT INTO agd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Téin nan ma ída anunu iyain banta anon tenti vaya ánain ída kamaen dakhafiyan mino. Tenti vaya ma iniyaona mai séin ma sisintá erikheruna Sifóeni vaya ino. ");
INSERT INTO agd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Téi ma saréa siretí ankan má para varunarái ma yanasinta siamiyá uno. ");
INSERT INTO agd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tiamiyá umpo siretí ankan ma ákonaen ayain nain mai Kantá Aunan mino. Téin tivíkái Sifóe ano véin tiantantin eriven tiretin minó daná afova amiren ineine orun mantaantantiyai minó baya ma séi siretí ankan tiamiyáeruna van ovare me ineine inono. ");
INSERT INTO agd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Téi siretí ankan me afa uré orono van mi ará kusin tiretin ameruna mai anon tiretin má banten mino. Barará nanin banta ano ma amiyainí ukhein ará kusin na séi ame raumpo siretí ankan ída vá ará uman dare akhokho van ono. ");
INSERT INTO agd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tiretí ankan me ampiré orikharé maé ovaráné erenté uno sé pefái siamékuya inikha ompo séin nan ma fura se anunu iyanteya mai siretí amusin ná ono. Para vara seyo, mai ma séin esantakhein Tifóe vaípái oronté uno. ");
INSERT INTO agd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mai yanasinta ída afoká ukhái saréa o útúbé tiamiyaruna ínaimpá ma afoká intiyan mumunan inono. ");
INSERT INTO agd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Téi ída siretí ankan má ayáká baya senté uno. Mai fara vara seyo, ma varará ma yafíkein ánon banta ano eriyan mino. Béimpin ída mana ákona vain téin ída mana avúavasí me usintanten mino. ");
INSERT INTO agd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Máan tinten mifo Sifóe ano ma sisimein danasintan téi variyákéi se Sifóen nan ma moéké tinunu iyaruna mai varará nanin banta ano afová ino van muno. Inka ifo erí oró tifano.” ");
INSERT INTO agd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Téi fura sikhein uvaini anan mumpo se Sifóe uvaini yunan ana afóe ino. ");
INSERT INTO agd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tenti siyan kayo ano ma ída aran iré iyain mai Sifóe ano yo iyákuan karúdaren aran ma iriyain ayan kayon kamaen ayaní uran kokhon aran iré iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Téi ma siamiyaruna vaya ano inka siretin áténa yuren ariké iyákurayan kama ukha ono. ");
INSERT INTO agd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tiretí ankan tempin asotú esirá inká téi siretimpin ná asotú ono. Para vara seyo, uvaini ayan mano ma anon kaufin ma ída o auntanten maen mai ano ída kaníen aran iranten mino. Tiretí ankan ma ída sentá e asotú inteya máan mana eya ída aran iran nono. ");
INSERT INTO agd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Téi uvaini anan mi vákuya siretí ankan uvaini ayan mompo sentá ma súpá intí ma séi ventá túpá onuna anon kokhon aran iranten mifo siretí ankan ma sen ampinteya ída kanaíen mana yanasí inono. ");
INSERT INTO agd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Máan tinten mifo mana vanta ano ma ída sentá ma asotú ukharé intin maen daa ayan ma avaneiní uádantin asa khavintin átaru uren irafin karúdantin ken kaurinten mino. ");
INSERT INTO agd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ken kaurinten mifo siretí ankan ma sempin asotú esin ma senti vaya ano ma siretimpin banti mae siretí ma anunu inona yaná ma inantesin mai siretin aminten mino. ");
INSERT INTO agd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tenti eyo iyampon kayo anon pura se kokhon aran imádesin mairái Sifóe ano kákan bí baranten mino. ");
INSERT INTO agd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Tifóe ano ma séin nan anunu iyainíi é téi siretin nan tinunu iyá umpo ena ena vá tiretí ankan tenti sinunu aúpin ná bano. ");
INSERT INTO agd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tiretí ankan ma senti vaya ánain ma kama e yakhafinteya mai senti avábá aúpin mi van nono. Téi ma Sifóeni vaya ánain ma kamaé bakúdé ma veni avábá aúpin barunaíi inono. ");
INSERT INTO agd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Para va ma vaya siretin tiamiya rauno. Tenti simusin mano siretí ankampin bantin mai amusin mano víkaaren avanino van muno. ");
INSERT INTO agd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tenti man baya máan mi ukhen mino. Téi ma siretí ankan nan tinunu iyarunaí e vá ben nan anunuin maran ná ono. ");
INSERT INTO agd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mana ano ma vei arona kayo van ma anunu uaren betí ankan aya ono van ma vei aunan ma ampian kaé iyain mai avúavá anon ena van ma anunuin avúavá esantakhen mino. ");
INSERT INTO agd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Téi ma siretí ankan tiamerunaí ma inteya mai sen tironan ban nono. ");
INSERT INTO agd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Para vara seyo, yoran nanin banta ano vei ayafa vanta ano ma variyain daná ída afová ukhé iyan mino. Téi Sifóen pintena ma vareruna vaya inka siretí ankan tiamiráké mai van mi siretí ankan nan téi ída yoran nanin banta e senté umpo se sirona en tenté uno. ");
INSERT INTO agd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tiretí ankan ída séin aní ure sivíáden ná bá umpo sireti oreya mo yoresin ayáká ma fara van aran kokhon imádano van mi aní uré tiretin doran amikhé uno. Máan tiyáke ma sen tivíká Tifóe vaípá inantinona yanasinta mai véi kasaen aminten mino. ");
INSERT INTO agd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ben avábá in maran ono van mi siretin tiamiyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Máa siren Yisasi evaránen temí, “Barará nanin banta ano ma siretí ankan ma namuroí uantantiya mai van tireti ída vá amino ono. Mai fefá betí ankan téin namuroí ukhá einíi inten mino. ");
INSERT INTO agd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tiretí ankan ma ma vara ráke vanta kayo an ma yakhesin maen banasi ano setisi kéká ino siren tiretin nan anunu inten mifo siretí ankan ída ma vara ráke vantan ba ono. Téi ma siretin aní uré ma o avíádéku vaona van mi varará nanin banta ano namuroí uantanten mino. ");
INSERT INTO agd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Téi ma siretí ankan tiamikháeruna mai vaya vá ovare me ineno. ‘Doran banta ano vei ayafa vanta ída esantakhein mino.’ Betí ankan ma séin namu usintákaren maen máan manan en tiretin má dere namu uantanten mino. Máan tinten mifo senti vaya ánain ma yakhákaren maen mai siretíi vaya ánain deren dakhafinten mino. ");
INSERT INTO agd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Téi ma sisintá erikheruna Tiyarafenun barará nanin banta ano ída afová ukhen mi séin nare siren tiretin namuroí uantanten mino. ");
INSERT INTO agd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Téi ma ída erivé baya siamékun maen betí ankan ída umei miyan baranté ein mifo saréa vetí ankani ume ma aúmanin aa ída van mino. ");
INSERT INTO agd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Téin ma namuroí iyain nanin banta ano mai Sifóen mái namuroí uantiyan mino. ");
INSERT INTO agd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Máan tiyan mifo vetin aúbaná ma váké mana vanta ano yoká ein doran ma ída yoriyákun maen umei miyan ída vetí baranten mino. Taréa enará ukhein danasintan téi aní iyákun betí ankan oniyáken mifo se Sifóe má téi má deren para namuroí usintiyan ban mino. ");
INSERT INTO agd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mai avúavá ma vetí ankan bariyain manon mai ma vetíi man bayafin ma máa sikhá ein mi kanaíen mino. ‘Ída ana vaintá paran namuroí usintiyan mino.’ ");
INSERT INTO agd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Tiretí ankan ma Ákona Uantan Aunan Tifóen má bain téi siantékun tireti vaonafá erinten mino. Pura vaya sin Aunan mi Sifóen má bain eriven maen tenti sivútivá bá doran má me sian amá inten mino. ");
INSERT INTO agd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Máan tinten mifo siretí ankan masá tenti vaya vá tivútivá basá tian amá ono. Mai fara vara seyo, siretí ankan manon araí in táké ten má báke minó daná afová ukha ono.” ");
INSERT INTO agd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Tiretí ankan ída mumunan ampeno van téi inikhéi siretin ma vaya siamiyá uno. ");
INSERT INTO agd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Para vara seyo, yamú eriyain monó átaru namun pinte siretin do siantiyáken Tiyarafenui kama yorarí iyá uno siren tiretin aruan purinten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mai fara va ino, vetí ankan Tifóen má ten má ída afová ukhen mi mai avúavá baranten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Máan tintéíi séi siretin má ayáká bantéi ma vaya fefá ída siamikharé umpo ínaimpá ma vanta kayo ano ma mai avúavá ma siretin amaniná kaintiya ma vaya ovare me ineno van mi siamiyá uno. ");
INSERT INTO agd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Téin ma sisintá erikháeruna Sifóe vaípái saréa oronté umpo intefasá oriya fono se ída mana ano ina iyan ná uno. ");
INSERT INTO agd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Téi ma ma vaya siamiyaruna anon tiretin aúpin arunaná édavuaren ákuna víkiyan mino. ");
INSERT INTO agd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Uman diyan mifo séi furan tiré tiretí ankan tiamiyá uno. Téi siretí ankan aya ono van mi siretin me ampiré oronté uno. Téi ma ída orékun maen mai siretí ankan ma Ákona Uantan Aunan mano ída kanaíen tiretimpin erinten mifo séi ma orontéi mai véin tiantékun tireti vaípá erinten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Béi ma eriven maen barará nanin bantai ume vá Tiyarafenui funtákein avúavá bá inká banasii avúavá ma yaimin nain má maman banasii ineinefin kaintin ovaren me iniren afová inten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Banasi ano ma ída séintá mumunan iyain mai vetíi ume véi anon maman afoká intin onanten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Béi anon puntákein avúavá maman afoká intin onanten mino. Para vara seyo, séi se Sifóe vaípá ma orivékuya siretí ankan ída evaráne séin tonan nono. ");
INSERT INTO agd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Béi anon Tiyarafenu ma vanasi yaimin nain avúavá maman afoká inten mino. Para vara seyo, ma vara ma yafíkein ánon banta ma yaimin inka afoká ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Téi kokhon baya siretí ankan tiameno van iyá umpo sireti ída kanaíeya saréa inin nono. ");
INSERT INTO agd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Inin nompo Fura sikhein Aunan ma eriven maen tiretí ankani ineine maman puntarantiya minó baya ma fura sin afová inono. Béi ída vei ineine finté baya sinten mifo mai ma iniran nain baya máan tiamiyáken inká ínaimpá ma afoká ono van iyain danasintan tian amá inten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Béi ma sen pinte varan nain baya ma siretin timamin nain manon tenti kakhan maman dákó inten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Minó Tifóen nína yaná ma vain mai sen tinan bái mai van mi senti vaya véi mamaren tiretin tiaminten mino siyá uno. ");
INSERT INTO agd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yisasi evaránen temí, “Ádé anantá téin ída sonan nompo ínaimpáké evaráne sító máarái sonan nono.” ");
INSERT INTO agd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Máa síkan beni eyo iyampon kayo finté manáa ano veraran ten oreraemí, “‘Ádé anantái séin ída sonan nompo ínaimpáké evaráne sító máarái sonan nono’ sen ma inká ‘te Sifóe vaípá oronté uno’ ma siyain mai veni ana intesá ukhen nafino.” ");
INSERT INTO agd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Máa siren betí ankan temí, “‘Titó máara’ se ma siyain bayai ana mai seti ída kanaí é afová iyá tiféuno.” ");
INSERT INTO agd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Máa siren betí ankan Yisasin inaono van iyákan béi fe afová uren betin tiamemí, “Téi ma sé, ‘Ádé anantá tiretí ankan ída sonan nompo ínaimpáké evaráne sító máarái séin tonan nono’ ma sikheruna vará inain maran iya rafono. ");
INSERT INTO agd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Téi fura siré tiretí ankan tiamiyá uno. Barará nanin banta ano kákan amusin inten mifo siretí ankan kákan ifí diyákeya moéke arunaná baran nono. Máan ma iyantin tiretí ankan ará ano uman danten mifo ínaimpáké mai ano vaéaren kama amusiníi inten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Anasi ano ma iyampon kain damú ma afoká íkan kákan aí pinté ma iyampon kaúden maen mai aí dana san ída iné iyan mifo auyen iyampon ma afoká uádein nan mi amusin é iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Máan mi ukhantiya saréa siretí ankan ará uman dan nompo séi evaráné tiretí ankan onékun maen tiretin ará ano amusin inten mino. Mana vanta ano ída kanaíen mai amusin do varanten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Maí damú tiretí ankan ída mana yana san téi vaípá inantin nono. Téi fura siré tiretí ankan tiamé umpo séin tivíká ma mana yana san ma Sifóe vaípá inantesin maen béi kasaen aminten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pefá tiretí ankan mana yaná barano van ten tivíka ída inan tikhare ompo saréa ma araíe inantire varesin maen mai amusin mano siretin aúpin kanaíen bíkanten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Te Sifóeni vaya kayo ma vaédiyá tiamiyaruna yamú ma afoká intí téi ída ena vá baya vaédiyá tiamenté umpo funtádéi siamenté uno. ");
INSERT INTO agd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Maí damú ten tivíkái Sifóe vaípá amúkin nono. Tiretini oo vare Tifóe vaípá timúkono vara siya rauno. Ída ino. ");
INSERT INTO agd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Para vara seyo, séi nan Tiyarafenu vaípákéi erikha ono sireya siretí ankan mano séin tivábá ureya mumunan ukhen nan mai van mi Sifóe ano veyantá tiretin nan anunu iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Téi se Sifóe vaípákéi ma varará erikharéi saréa ma vara me ampiré Tifóe vaípá evaráné oronté uno.” ");
INSERT INTO agd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Máa síkan beni eyo iyampon kayo ano semí, “Taréa éi ída vaya vaéde siya ompo funtádeyai siya ono. ");
INSERT INTO agd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Minó daná afová ukhen ná tetí ankan ma inikheruna mai mana vanta ano ída éin inaono van inten mino. Máan tukhái éin nan Tiyarafenu vaípákéi erikha ono siré mumunan iyá tiféuno.” ");
INSERT INTO agd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Máa síkan Yisasi evaránen tiamemí, “Taréa inká mumunan iya rafono. ");
INSERT INTO agd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Máan tiya ompo yamú ano eriyaren inka e afoká ukhein tiretí ankan mere asuse eya siretíi varufá orera uve seyáká anan meran nompo mai ída seyáká ana vanté uno. Mai fara vara seyo, se Sifóe ano sen má banten mino. ");
INSERT INTO agd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tiretí ankan téin má túpá uan ákona uvesin tiretin ará ano kusino van mi séi inikhéi ma vaya siretin tiamiyá uno. Ma varará ma vasin maen minó uman mano siretimpin afoká inten mifo ará kusin masá bano. Para vara seyo, séi ma varai ákona inka esantakhé uno.” ");
INSERT INTO agd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yisasi ma mai vaya kayo siamíden maen béi inarufá kakháben máa sen amúkemí, “Tifóe oe, yamú inka afoká en mifo vá e Anin kákan bí amesin ná inká e Anin mano éin evaránen kákan bí amino. ");
INSERT INTO agd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mai fara vara seyo, éi anon minó nanin bantará ma yafisin ákona véin amikha ono. Mai ma véin avían amikheona nanin banta véi anon kanaíen ayun ma fara van oriyan ban aunan aminten mino. ");
INSERT INTO agd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ayun ma fara van oriyan ban aunan mai máan mi ukhen mino. Mai aunan ma varan nain kayo anon éin nan manan pura sikhein Tiyarafenun ban mino sen afová en mi inká Tiyarafenu ano ma aní ukhein banta Yisasin nan éi anon tianten nan erikhen ne sinten mino. ");
INSERT INTO agd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Éi ma sen timeona mai yoran inka yóan kípéi varará nanin bantafin éini kákan bí bá ákona vá aní é uno. ");
INSERT INTO agd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tifóe oe, fefá ma ma vara ída afoká ukhá ma kákan bí bá ma váeruna mai kákan bí taréa simiresíen má bano van mi ukhé uno. ");
INSERT INTO agd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Barará banta kéká ma éi sen timikhá eona mai kayo éin aví inka siamikhé uno. Betí ankan eni vanta kékái varéiyai séin inka simikhe nan mi vetí ankan eni vaya kamaen dakhafiyan mino. ");
INSERT INTO agd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Minó daná ma séin timikheona mai en pinté anan erikhan mi vetí inka afová en mino. ");
INSERT INTO agd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Para vara seyo, mai ma sisimeona vaya máa vetin tiamékun inka afová en mino. E vaípákéi séin nan erikhen mino sen afová iyáken inká en nan mi sen tiantan erikhen mino sen mumunan iyan mino. ");
INSERT INTO agd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Barará nanin banta aya onovara séi simúkiya raumpo éi ma sen timikheona mai eni kékái vá mai kayo van mi simúkiyá uno. ");
INSERT INTO agd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","“Tenti vanasi ma vain mai eni nan bákan inká eni vanasi ma vain mai senti nan ban mino. Máan tukharé iyan minó mai nanin banta éi ovaráne sen timen nan mai anon téin kákan bí timen mino. ");
INSERT INTO agd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Téi ma vara me ampiré éi vaonafá orivé ída vanté umpo vetí ankan mi ma varará banten mino. Kantasí ukheona Sifóe oe, mai ma séin timikheona ákona fókesá betin dafiseno. Máan tesin ná erasan ma mana varunaí e ná betí ankan mana vá bano. ");
INSERT INTO agd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Téi ma ma kéká bá báké maé éi ma sen timikheona ákona fóké betin dafíkékun bare mino. Minó ano ída afeyoranten mifo eni vompon dóki ano ma sikharé einíi en mana vanta ano anan o afeyoranten mino. ");
INSERT INTO agd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Máan tintéíi séi ma vetin má para váké maé kokhon bayan tiamiyaréi saréa éi vaonafá ma oriyákun maen mi senti simusin mano vetin aúpin bíkanten mino. ");
INSERT INTO agd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Eni vaya máa inka vetin tiamikhékun mi ma vara ráke nanin banta ano vetin namuroí uantiyan mino. Para vara seyo, sen an den betí ankan ída ma vara ráke vanta kékái van mino. ");
INSERT INTO agd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma vara rákena vetí ankan do aviran novara inaiya raumpo vetintá dafíbesin Ban Anon mano ída vetin namu ino van mi simúkiyá uno. ");
INSERT INTO agd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Téi ída ma vara ráke vákun betin má dere sen an den ída ma vara ráke ino. ");
INSERT INTO agd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Minó ei fura sikhein baya kayo fóké betí ankan afova amesin ná betin aúpin dorantin maman kantasí uven eni kékasí ino van muno. ");
INSERT INTO agd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Éi ma sen tisinten ná ma varafin ererunaíi é ma kéká tiantékun ma varafin orinten mino. ");
INSERT INTO agd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Para vara seyo, vetin nan ma sesi minó bukhafa éin amerunaíi en betíi minó bukhafa fura sen éin aminten mino. ");
INSERT INTO agd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Tenti eyo iyampon kayo ana aya ono vara simúke rauno vetí ankani vaya ma iniren téintá ma mumunan inain mai kéká bá aya ono van mi simúké uno. ");
INSERT INTO agd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Téi ma simúkeruna mai minó nanin banta ano ará manafiní uren manafin bano van muno. Éi Sifóe sempin baná ma séi empin barunaíen betí ankan erasampin bantin éin nan mi se nan tiantan erikhen mino siren barará nanin banta ano mumunan inten mino. ");
INSERT INTO agd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Éi ma kakhan má ákona vá ma séin timikhá eona mai séi vetin ameruna erasan ma sirá manafiní uré manafin barunaíen betí ankan ará manafiní uren manafin banten mino. ");
INSERT INTO agd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Téi vetí ankan má bákuya éi sen má banái mai avúava san mi vetí ankan ará manafiní uren manafin bantin barará nanin banta ano afová en éin nan mi séin tiantan erikhan mi séin ma anunu iyainíi en mi vetin anunu iyan mino sen afová inten mino. ");
INSERT INTO agd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tifóe oe, ma ma sen timikheona nanin banta ano sen ma vanunará bano van mi inikhé uno. Ma vara ma ída afoká ukhaya ma éi sen nan anunu ure ma mai kakhan má ákona vá ma simikhá eona mai kakhan má ákona vá téin ma simikheona kéká ano onano van muno. ");
INSERT INTO agd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Puntákein Tifóe oe, minó barará nanin banta ano éin ída afová ukhen mifo séi anan éin afová ukhékun mi éi ma sen tisinten ná erikháeruna mai senti eyo iyampon kayo anon afová ukhen mino. ");
INSERT INTO agd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Éin nan betí ankampin téi inka sian afoká uádákeruna eín nan para sian amáé oriyá bákuya mai ma éi sen tivábá iyaonaí eya vetin avábá esí maé téi vetimpin banté uno.” ");
INSERT INTO agd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yisasi mai vaya siren bei eyo iyampon kayo vá Kidaroní ava e kháden ena ufá ódiaren orifí dunan anafin oferen mino. ");
INSERT INTO agd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yisasi kokhon damú bei eyo iyampon kayo vá mai yunan anafin o átaru iyain bákan béin ma namuro kayo ayampin avían amin nain banta Yudasi mairá afová ukharen mino. ");
INSERT INTO agd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Afová ukharen Yudasi ano aruvin banta kayo vá monó ánon banta kayoi yafisin kéká bá Farasisi kayoi yafisin banta kéká bá avíaran mai kayo ano aruvin danasinta vá oon má uruaran Orifí dunan anafin oren mino. ");
INSERT INTO agd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Oríkan Yisasi ve aurá ma afoká ono van iyain danasinta afová ukhen béi e afánen mai kéká ádé oriven máa sen inaemí, “Tiretí ankan iyen nará dosiya rafono.” ");
INSERT INTO agd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Máa síkan betí ankan evaránen temí, “Nasaretíke vanta Yisasin nan mi yosiyá tiféuno.” Síkan Yisasi semí, “Mai séi uno.” Máa siyákan mai ma véin aní intin ma fákan nain banta Yudasi má mairá mantakharen mino. ");
INSERT INTO agd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Betí ankan iníkan ma Yisasi sen, “Mai séi uno,” ma siyain má mai vanta kayo ano e afánen oyampáké oro senten eraven barará ankamen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Máan tiyain má Yisasi evaránen betí ankan inaemí, “Tiretí ankan iyen nará dosiya rafono.” Síkan betí ankan temí, “Nasaretíke vanta Yisasin nan muno.” ");
INSERT INTO agd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Máa síkan Yisasi evaránen temi, “Mai séin bái siretí ankan tiamikhé umpo sen nan ma yosiyanteya mai ma vanta kayo áesin ná orino.” ");
INSERT INTO agd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","“Máan ma sein manon pefá ma máa sikhá ein bayan kanaíen mino. “Mai ma séin timikháeona nanin banta finté mana ano ída afeyoranten mino.” ");
INSERT INTO agd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Máa siyain má Pita mana vaenati yákaren orun danúaren monó ánon bantai ánon banta kékái yoran banta Marákusin ne sin ayan kuron pákena átaren do síkaan karúdan barará eraven mino. ");
INSERT INTO agd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Máan tiyain má Yisasi Pitan tiamemí, “Baenati evaráneya veni anamumpin kain orino. Te Sifóe ano ma simikhein non kápi sen nan ída nan novara fono.” ");
INSERT INTO agd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Máan tiyain má aruvin banta kayo vá betí ankani ayafa vá Yutan kayoi kákan monó namuntá ma yafíkein kéká bá ano Yisasin pákaren ayantá ákona anampó damen mino. ");
INSERT INTO agd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kaiafasin anan Aanasin ne sin banta vaintá nare vetí ankan ben aviren oren mino. Mai oranafin Kaiafasi monó ánon bantai ánon bantaí ukharen ");
INSERT INTO agd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","béi Yutan kayo fefá tiamikharemí, “Minó nanin banta ayaen ma mana vanta ano ma furin nain mai kama inten mino.” ");
INSERT INTO agd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pitan má ena eyo iyampon má ano Yisasin bákuren oríkan monó ánon banta kékái ánon banta ano mai eyo iyampon afová ukhan pasen áíkan Yisasin avákuren monó anon bantai yafufin óden mino. ");
INSERT INTO agd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ódivíkan Pita onará mantakharéin mai ma monó ánon banta kékái ánon banta ano ma afová ukhein eyo iyampon mano onará ma yafisin nanin tiamíkan Pitan áin dafufin éden mino. ");
INSERT INTO agd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Édiyain má mai ma onará dafisin nanin mano Pitan máa sen inaemí, “Éin má mai vantai eyo iyampon na fono.” Síkan Pita semí, “Ída ino. Téi ída veni eyo iyampon bá uno.” ");
INSERT INTO agd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Dafisin banta kéká bá doran banta kayo vá ano iyon eimpin ira sáden mantakhen kaniyákan Pitan má maifin mantakharen mino. ");
INSERT INTO agd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mantakhan monó ánon banta kékái ánon banta ano Yisasi ma siyá ein baya kayo vá beni eyo iyampon kayo va san béin inaen mino. ");
INSERT INTO agd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ina íkan Yisasi evaránen tiamemí, “Téi afokái vanasi vaya siamiyaré uno. Monó átaru namumpin nafi kákan monó namumpin nafi ma Yutan nanin banta átaru uví téi afokái vetí ankan baya siamiyaré umpo ída aúpá tiamiyaré uno. ");
INSERT INTO agd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Pará éi inaiya fono. Téi ma vaya siamiyá eruna mai vanta kayo vá ina ono. Betí ankan mi mai vaya afová ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yisasi máa síkan mana kákan monó namuntá dafisin banta ano mairá mantakharen Yisasin aunápin ankamiyan temí, “Monó ánon banta kékái ánon banta avorá mai inté ein bayá evaráne siamiya fono.” ");
INSERT INTO agd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Máa síkan Yisasi evaránen béin tiamemí, “Téi ma namu vaya ma siyákeya mai vayai ana sian amá inompo séi ma kama vaya siyákeya éi fará ten tinkamiya fono.” ");
INSERT INTO agd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Máa sirákan mai ma Yisasin ayantá ma ákona anan damukharé ein para vákan Aanasin ne sin banta ano véin tiantan monó ánon banta kékái ánon banta Kaiafasi vaípá aviren oren mino. ");
INSERT INTO agd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Máan tiyákan Pita irará mantakhen kaniyáin manáa ano véin inaemí, “Éin má beni eyo iyampon nafono.” Síkan béi semí, “Ída ino. Téi ída veni eyo iyampon muno.” ");
INSERT INTO agd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Máa siyain má monó ánon banta kékái ánon bantai yoran banta ma Pita ano ma átaren tíkein bantai kéká pinté mana ano semí, “Éi ven má orifí dunan anafin ban ná onte rafunon té iniyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Máa síkan Pita enádá “ída ino,” siyain má ana kokore asen mino. ");
INSERT INTO agd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kaiafasi ano Yisasin inaen eriyan me kípiyákan do kakhan ákurasí iyain má aruvin banta kéká ano véin do aviren Romú kayoi ánon kamanin amá oren mino. Mai namun ódíkan béin ma namuroí uantiyain Yutan kayo ano maifin ódikharé ékun Tiyarafenu auufen painí eono siren are usintantí mai ma Avo Uantan Omasí ma inain pinte yunan ída nan nae siren maifin ída óden mino. ");
INSERT INTO agd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Máan siren barufá baré íkan Pairoti ano eraven morun betin inaemí, “Nái anarasá ma vanta kó tian tiya rafono.” ");
INSERT INTO agd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Máa síkan béin evaránen tiamemí, “Béi ída aau vanta varé intí ída véin aviré éi vaonafá eré tifanunaren mino.” ");
INSERT INTO agd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Máa síkan Pairoti ano vetin tiamemí, “Béin avire mo siretíi man bayafó puntarano.” Síkan Yutan kayo ano evaránen temí, “Teti mano ma vanta aruan purin nan airo ananí ukhein mi vá uno. ");
INSERT INTO agd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Máan ma sein manon Yisasi ma veyan purin nain avúava san ma fefá tikharé ein mi fura sen afoká en mino. ");
INSERT INTO agd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Máa síkan Pairoti ano evaránen kamanin amápin ódiven Yisasin aran ódikan máa sen inaemí, “Éi Yutan kayoi Kin nafono.” ");
INSERT INTO agd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Máa síkan Yisasi evaránen béin inaemí, “Éi ei ineine fosá mai vaya siya fo áa ena vanta kayo anó tiamikhayá tiya fono.” ");
INSERT INTO agd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Máa síkan Pairoti ano evaránen béin tiamemí, “Téi Yutan bantá báku vae. Ei kéká bá betíi monó ánon banta kayo vá anon éin avían téi varunará mera va ompo éi nái aaú manten nan nafino.” ");
INSERT INTO agd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Máa síkan Yisasi evaránen béin tiamemí, “Tenti yafisin ída ma vara rákena van mino. Tenti yafisin ma vara rákena varé intin tenti yoran banta kayo ano kanaíen aruvintin ída mana vanta ano kanaíen Yutan kayo ayampin téin aminté ein mifo senti yafisin mai ena vara fákenan ban mino.” ");
INSERT INTO agd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Máa síkan Pairoti ano véin inaemí, “Mai fura ifo éi mana Kin ná ba vae.” Síkan Yisasi evaránen tiamemí, “Téin nan ma Kin ne seona mai éi furan te ono. Pura sikhein baya sian banasi amin doraríin anarái sinóe ano séin kaen mino. Pura sikhein baya ma iniren mai ánain dakhafin nanin banta anon tenti vaya iné iyan mino.” ");
INSERT INTO agd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Máa síkan Pairoti ano véin inaemí, “Pura sikhein baya mai nái yana safino,” siren evaránen Yutan kayo vaípá aravuven betin tiamemí, “Ma vanta ma kó tiantan aau ída van mino. ");
INSERT INTO agd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ída van mifo ena ena oranafin Avo Uantan Damú ma eri mae mana karavusi ma útúantan avúavá afová ukheya sireti ma seona mai vantan karavusi útúdékun oré iyain mifo Yutan kayoi Kin ná útúantantin orino vará iniya rafono.” ");
INSERT INTO agd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Máa síkan betí ankan evaránen oovararen temí, “Ída ino. Mai vanta ída ifo Barabasi ino.” (Barabasi mai kamanin má aruvin duváden banta aruan púká ein banta ino.) ");
INSERT INTO agd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Máa sirákan Pairoti ano síkan ayankuní ukhein dafiyó póké Yisasin ankamen mino. ");
INSERT INTO agd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ankamiyákan aruvin banta kéká ano mana ayankun anan máden mai fóké kini kamamó ma einí ukhein uváden ben ánontá afu uantáden mana nararé au anamun máden uanten en mino. ");
INSERT INTO agd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Máan tuantáden béin máká maáká iyan temí, “Yutan kayoi ákona kin noe, en aví daní iyá tiféuno!” siyáken béin auná ankamen mino. ");
INSERT INTO agd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Máan tiyákan Pairoti ano evaránen barurá aravuven máa sen banasi siamemí, “Béin pinte mana aau ída yoseruna mai van mi véin aviré tireti vaonafá erenté umpo vá afová ono.” ");
INSERT INTO agd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Máa sírákan Yisasi mai ayankun anan kamamó ma ánontá uantein má nararé au anamun ma uantein má para ukhan ekhuven barufá eravíkan Pairoti ano vanasi siamemí, “Ma mai vanta ifo onano.” ");
INSERT INTO agd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Máan ma siyain má monó ánon banta kéká bá kákan monó namuntá ma yafisiyain kayo vá ano oniyáken oovaraaren temí, “Aruan purono. Aruan purono.” Síkan Pairoti ano vetin tiamemí, “Beni mana aau ída yosé umpo siretí ankan béin e avíde vá tireti yantasá daa unkamádantá arono.” ");
INSERT INTO agd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Máa síkan Yutan kayo ano evaránen temí, “Béi ma siyáken téi Tiyarafenu Anin muno ma sikhein mano mai setisi man bayan durafuntein mai anará béi vá purino.” ");
INSERT INTO agd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Máa síkan Pairoti ano mai vaya iniren moéken akhokho van en mino. ");
INSERT INTO agd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Máan turen Yisasin evaránen aviren kamanin amápin un pében béin inaemí, “Éi inte varu fákesa fono.” Síkan Yisasi ída mana vaya evaránen ten mino. ");
INSERT INTO agd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Máan tiyaimpin Pairoti ano véin inaemí, “Ifá uantan ma orin má inká daa unkamádantá ma aruan purin ákona vá ma sempin bain éi ídá afová ukheyá ída ovaráne sen má baya siya fono.” ");
INSERT INTO agd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Máa síkan Yisasi evaránen béin tiamemí, “Dan Banta ano ma éin ída ákona amikhá inti séin ída kanaíeya maman barará kainonaren mino. Mai fara vara seyo, séin ma en ayampin kaein mai vantai ume ano eni ume esantaren kákani suron ukhen mino.” ");
INSERT INTO agd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Máa síkan Pairoti ano iniren mai ráké Yisasin ma ifá uantantin orin nain aa van dosiyákan Yutan kayo ano oovaraaren temí, “Éi mai vanta ma ifá uantesin ma orintiya mai éi ída Sisan aronan ban nono. Inká mana vanta ano ma veyan nan ma séi kin muno ma sin nain mai ano Sisan mi namuroí uantiyan mino.” ");
INSERT INTO agd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Máa síkan Pairoti ano ma mai vaya iniren maen Yisasin evaránen barufá aviren morúden baya ma yaimin kará aví Onámaná Aa e sikhein karáká kumanen mino. (Aramaiki vaya finté Kabata e siyan mino.) ");
INSERT INTO agd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tiyarafenu ano ma Isareri nanin banta Avo Uantein nan ma ovaren me inin omá kákena yunan útain damú bákan bayan aúbaní iyaimpin Pairoti ano Yutan kayo siamemí, “Tiretí ankani kin masi ifo onano.” ");
INSERT INTO agd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Máa síkan betí ankan oovararen temí, “Béin avire orono! Mo yaa unkamádantá aresin purino!” Síkan Pairoti ano vetí ankan inaemí, “Tiretíi Kin ná daa unkamádantá arin novarae.” Máa síkan monó ánon banta kéká ano evaránen temi, “Tetisi kin ída ena van mifo Sisa veyáká anan ban mino.” ");
INSERT INTO agd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Máa síkan daa unkamádantá Yisasin arino van betin amen mino. Amíkan aruvin banta kéká ano véin aviren oren mino. ");
INSERT INTO agd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yisasi vei yaa unkamádan maman afuná uren Ánon Dampa e sikhein dontá oren mino. (Aramaiki vaya finté Korikhota e sikhen mino.) ");
INSERT INTO agd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mai yontá moren Yisasin daa unkamádantá aruren inká kan banta vá tefá tefá aren en mino. ");
INSERT INTO agd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Aruran maen Pairoti ano síkan betí ankan mana vaya máa sen uváden Yisasini yaa unkamádantá ankantaaren mino, “YUTAN KAYOI KIN NASARETÍKE VANTA YISASI INO.” ");
INSERT INTO agd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pairoti ano síkan mai vaya Yutan baya finté uvaren Romú baya finté uvaren Kiriki vaya finté uvaren ukharen mino. Yisasin ma yaa unkamádantá arukhein mai Yerusaremí baru ádéi vákan Yutan kayo ano oriven mai vaya yankafiyaren mino. ");
INSERT INTO agd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Máan tiyákan Yutan kayoi monó ánon banta kéká ano máa sen Pairotin me yuvun iyáken temí, “Éi ída Yutan kayoi kin ne sire uvarano. Ma vanta ano sen téi Yutan kayoi kin muno siyaren ne sire uvarano.” ");
INSERT INTO agd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Máa síkan Pairoti ano evaránen temí, “Ída ino. Téi ma uvanteruna vaya mai inká uvanté umpo áesin ná para vano.” ");
INSERT INTO agd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Aruvin banta kayo ano Yisasin daa unkamádantá aruren beni yante vuí daná kamí kamí pintan daíden mana mádú uaran námente au anamun mana en mino. Mai au anamun mana yavaráefó anan amu uran baren mino. ");
INSERT INTO agd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Máan tukheimpin aruvin banta kéká ano semí, “Ma au anamun ída kafasé tifanté umpo kati (satu) siré tifékun esesí ma inain manon baranten mino.” Mai avúavá ma vetí ankan barein manon Tiyarafenui vompon dókifin ma máa sikhá ein mi kanaíen mino. “Betí ankan tenti suí daná daíden baranten mino. Mamaren betí ankan tenti su anamuntá kati sirákan mi esesí ma ein banta anon baren mino.” Máan ma sikhá ein mai avúavá máan aruvin banta kéká ano varen mino. ");
INSERT INTO agd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Daa unkamádan ádé ma mantakharé ein kéká mai Yisasin anóen má be aunanan má Maria Koropasin aná bá inká Makdaráke nanin Marian mái mantakharen mino. ");
INSERT INTO agd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Mantakhan Yisasi ma moéken anunu ukhein eyo iyampon má ano vetin ádé báin Yisasi ve anóen mo oniyan tiamemí, “Anasi oe, mai e anin mino.” ");
INSERT INTO agd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Máa siren mai eyo iyampon tiamemí, “Mai e anóe ino.” Máa siran maen mai eyo iyampon mano Marian aviren be amápin mo kaúdáken maí damúké araíen béintá dafisiyaren mino. ");
INSERT INTO agd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Taréa anan tenti yoran minó kípen mino sen Yisasi iniyáken Tiyarafenui vompon dókifin ma sikharé ein baya kanaí ino van béi máa semí, “Non nan tiiyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Síkan mana íta uvaini vain kave mairá ádé baré íkan betí ankan manáa mómofen ma einí ukhein daná máden ura yankará damuren mai kavefin daaren orun maman kain Yisasin oorá óden mino. ");
INSERT INTO agd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ódikan Yisasi mai uvaini naan onen temí, “Mai inka kípen mino,” siyáken anuran durafuriyan bei aunan ampin orin puren mino. ");
INSERT INTO agd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Avo Uantan Damú mai Sabatirá afoká intéin Sabati rákena yanasinta funtáádano van iyáken Yutan kayoi ánon banta kéká ano iníkan kákan damú ma furin banta kayo au ma yaa unkamádantá ban mai ída kama ukheimpin mai vanta kéká arantan iyarantin ainen púbintin daa unkamádantá kena ainen do varano van betí ankan Pairotin mo inaen mino. ");
INSERT INTO agd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ina urákan Pairoti ano kanai ino sin aruvin banta kéká ano oren Yisasin má ma yaa unkamádantá arukharé ein bantá kanan arantan mo iyen mino. ");
INSERT INTO agd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Iyaren maen betí ankan Yisasi vaintá oriven onákan bei fe fúkeimpin ída veni arantan iyen mino. ");
INSERT INTO agd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ída iyákan mana aruvin banta ano vankan póké ayorampin antariyain má nare vá non má ano manádá avanen barará eraven mino. ");
INSERT INTO agd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mana vanta ano ve auufó pura sen ontaré ein danái siretí ankan má mumunan ono van mi sian amá en mino. ");
INSERT INTO agd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mai yanasinta ma afoká ein mai Tiyarafenui vompon dókifin ma máa sikharé ein mi kanaíen mino. Mai vaya máan mi sikhan mino, “Beni mana yampa ída yurafurinten mino.” ");
INSERT INTO agd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Máa sikhan inká ena vaya vá Tiyarafenui vompon dókifin máa sikharen mino, “Bankan ma arukhá ein bantan betí ankan onanten mino.” ");
INSERT INTO agd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mai oyampáké Arematiáke vanta Yosepi ano Pairotintá mo inaúdé Yisasin au varano van oren mino. Yosepi véi Yutan kayoi ánon banta ifo mai véi mana Yisasini eyo iyampon mi váken ena ánon banta kayo van péden bei mumunan aúpasí uren baré íkan Pairoti ano kana ifo varano síkan Yisasin au o varen mino. ");
INSERT INTO agd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yosepi ano mana inuran ma Yisasin o onein banta Nikodimasin má oren mino. Oriyákan daa anu fóké uvantan kama aunka iyain uveri vá Nikodimasi mamaren oren mino. Mai auna uverii uman teti-foa (34) kiro ino. ");
INSERT INTO agd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yosepin nú Nikodimasin nú ano Yisasin au o máden Yutan kayo ano ma furin banta aurá ma variyain avuavasíen kama aunka iyain uveri vanaren kama yavaráe kayofó úken mino. ");
INSERT INTO agd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mai ma Yisasin daa unkamádantá arukharé ein ádé mana yunan ana vákan maifin auyen masí uádan bákan ída mana vanta kaúan araí ukhan mino. ");
INSERT INTO agd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Máan tukhan Yutan kayo ano Sabati rákena yanasinta útaen arakhókuin damú ban maen mai masí ádé baré ín Yisasin au yaiyen mai on aimpin mo masíen mino. ");
INSERT INTO agd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Santé pe ákura suron Makdaráke nanin Maria ano masíká onano van oriyaren o onákan masí ain oyi rákena onámaná do vaébaé uan kain baren mino. ");
INSERT INTO agd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Máan tukháin ódaren Maria ovaránen tavaen Pita nú mai ma Yisasi moéken anunu ukharé ein eyo iyampon nú baípá eren me máa sen tiamemí, “Bafani au masí pintena yo ayóken mifo mai véin intefasá kaúken nafi mai séi ída afová ukhé uno.” ");
INSERT INTO agd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Máa síkan Pitan má ena eyo iyampon má ano masí onano van tavaen oren mino. ");
INSERT INTO agd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Békanan tavaen oríkan mai ena eyo iyampon mano Pitan esanten ayampaen ben nare masíká oren mino. ");
INSERT INTO agd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Oren o kharemen aimpin onákan kama yavaráe ma Yisasin úkuantákaré ein mana vákan óden mifo véi ída masí aimpin umperen mino. ");
INSERT INTO agd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ben oyampáké Pita oren esavéden masí aimpin un pében onákan davaráe kayo ana vákan ");
INSERT INTO agd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","mairá mana ena yavaráe Yisasin ánontá ma úkuantan baré ein mai vanta ano ma yádaren ádun kaeiní ukharen mino. ");
INSERT INTO agd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Máan tukhan mai ma esé araíen ma masíká orein eyo iyampon má ano masípin un pében mai yanasinta ódaren mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tiyarafenui vompon dókifin ma Yisasin nan púaren evaránen e mantanten ne ma sikhá ein baya vetí ankan ída afová ukharen mino. ");
INSERT INTO agd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Máan turen mai eyo iyampon kanan mano evaránen barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Orivíkan masí ain oyirá Maria mantakhen ifí diyáken masí aimpin mátimen mun onen mino. ");
INSERT INTO agd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Onákan enisorí kanan mano efanten buí daná uren Yisasin au ma yan bakharé eintá mana ano ánompá kumanin ena ano arantampá kumanin ukharen mino. ");
INSERT INTO agd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kumantaren míkanan mano Marian inaemí, “Anasi oe, éi fará ifí diya fono.” Síkan béi evaránen békanan tiamemí, “Tenti Bafan ma ayóden intefasá kaúken nafi séi ída afová ukhé mai van mi ifí diyá uno.” ");
INSERT INTO agd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Máa siren dovaera senten onákan Yisasi oyampá mantakharen mifo ve nan ída Yisasi ino sen afová en mino. ");
INSERT INTO agd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Máan tiyákan Yisasi véin inaemí, “Anasi oe, éi fará ifí diyá inká iyen nará dosiya fono.” Síkan dunan anará ma yafisin banta ino sen iniren temí, “Kákan banta oe, éi ma ven au ma vare mo kaurákan nonafá tisimesirá téi o varano.” ");
INSERT INTO agd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Máa síkan mairá Yisasi semí, “Maria oe,” síkan Maria yo vaéan onen Aramaiki vaya finté, “Rabonai oe,” sen aren mino. (Mai “Rabonai” e ma siyain baya Aru sen tiyan mino.) ");
INSERT INTO agd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Máa síkan Yisasi véin tiamemí, “Téi ída Sifóe vaípá ódikhé umpo ída vá ten tu fákano. Éi oreya sen tifá tiváeyan mana mo siameno. ‘Te Sifóen má tiretí ankan Afóen má inká tenti Tiyarafenu vá tiretí ankani Ayarafenu vá baípái ódonté uno.’” ");
INSERT INTO agd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Makdaráke nanin Maria ano evaránen oren mo máa sen eyo iyampon kayo siamemí, “Téi inka Bafan oné uno.” Siren Yisasi ma ven tiamein baya máa vetí ankan tiamen mino. ");
INSERT INTO agd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Esé araí in damú áau eraven inúpasí íkan eyo iyampon kayo ano Yutan kayoi ánon banta kéka san péden má ona munkuan ákona uren iyukharé íkan Yisasi vetí aúbaná o mantaven máa sen betí ankan tiamemí, “Tiretí ankan ará ano kusen ná bano.” ");
INSERT INTO agd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Máa siren be ayan má ayoran má aníin bei eyo iyampon kayo ano onen mino. Aní uran bei eyo iyampon kayo ano ma vetíi Bafan onein nan kákan amusin en mino. ");
INSERT INTO agd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Amusin iyákan Yisasi enádá betí ankan tiamemí, “Tiretí ankan ará ano kusen ná bano. Te Sifóe ano ma sen tisintá erikhá erunaíi é téi siretí ankan tianté umpo vá oronó.” ");
INSERT INTO agd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Máa siyan be aunan pútiádan betí ankan baípá oriyan temí, “Tiretí ankan Kantá Aunan ná barano. ");
INSERT INTO agd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tiretí ankan ma ena vanta kayoi ume ma ifá uantesin maen mai ume arúantanten mifo siretí ankan ma ena vanta kayoi ume ma ída ifá uantesin mai kayoi ume fara vanten mino.” ");
INSERT INTO agd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yisasi ma vei eyo iyampon kayo vaintá ma o afoká ein inúpá Tomasin nan ma Didimasin ne sen ariyain eyo iyampon mano maifin ída varen mino. ");
INSERT INTO agd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Máan tukharéin ena eyo iyampon kayo ano véin tiamemí, “Tetí ankan inka Bafan oné uno.” Síkan Tomasi evaránen betí ankan tiamemí, “Béin ayampin ma antó arukhá ein afun má ayoran afumpin má ma séi ída seyantá tiyan kaúan onté maé mai séi ída mumunan onté uno.” ");
INSERT INTO agd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Máa siran dan manápá ifo afápá kanú manaú un kádan damú orivíkan Yisasini eyo iyampon kayo ano ona munkuan ákona uren mai namumpin bákan Tomasin má maifin baréin Yisasi vetí aúbaná mantaven máa semí, “Tiretí ankan ará ano kusen ná bano.” ");
INSERT INTO agd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Máa siren béi Tomasin tiamemí, “Éi eriveya siyan má tiyoran má tifumpin ayan kaúdeya onano. Ída vá anomé iniyákeya mumunan mana vá ono.” ");
INSERT INTO agd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Máa síkan Tomasi evaránen béin tiamemí, “Tenti Bafan Tiyarafenu uron mono.” ");
INSERT INTO agd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Máa síkan Yisasi evaránen béin tiamemí, “Éi sen tódeyan mumunan iya ompo séin ma ída sonten para ma mumunan iyain nanin banta ano vá amusin ino.” ");
INSERT INTO agd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yisasi vei eyo iyampon kayo avorá kokhon enará ukhein aní danasinta afoká ukharen mifo séi ída ma vompon dókifin minó uvaré uno. ");
INSERT INTO agd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ída uvaré umpo ma vompon ma séi uvareruna mai Yisasin nan Tiyarafenu ano ma aní ukharé ein banta ino seya inká béi Tiyarafenu Anin mino se ureya véintá mumunan ono van mi uvaré uno. Béintá ma mumunan inona ano fara van oriyan ban aunan baran nono. ");
INSERT INTO agd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ínaimpáké Yisasi Kariri non akharun akhempá bei eyo iyampon kayo vaintá enádá afokáen mino. Mai máan mi en béi afoká en mino. ");
INSERT INTO agd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pitan má Tomasin nan ma Didimasin ne siyain má Kariri varafin Kaná baru ráke vanta Natanierin má Sebetin anin kan má ena kankanan eyo iyampon má ano manafin iyukharen mino. ");
INSERT INTO agd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Íyukharéin Pita máa sen betí ankan tiamemí, “Noyana arono van oriyá uno.” Síkan betí ankan temí, “Tetin má orinton muno.” Siren minó ano mana votifin un kumamen oren mifo mai inuran betí ankan ída mana noyana aren mino. ");
INSERT INTO agd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Máan tiyákan do kakhiyain má Yisasi non akhempá e mantakhan bei eyo iyampon kayo ano véin ída oman afová en mino. ");
INSERT INTO agd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Máan tiyákan Yisasi oovararen temí, “Tirona kayo oe, ídá manáa noyana arukhe rafono.” Síkan betí ankan evaránen tiamemí, “Ída ino.” ");
INSERT INTO agd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Máa síkan betin tiamemí, “Ayan kuron pákena mai voti akhempá base karúdaresin manáa noyana ferantiya varano.” Síkan betí ankan base maman karúdan aravuvin kokhon noyana víkavin betí ankan ída kanaíen mai vase orun darifaan botifin kaoren en mino. ");
INSERT INTO agd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Máan tiyákan Yisasi ma moéken anunu ukharé ein eyo iyampon mano Pitan tiamemí, “Bafan mantino.” Síkan Pita au anamun davamádaken doriyaren iníkan “Bafan mantino” siyain má béi ainen au anamun e maman uren nompin káusiven ayan nakhosá den akhempá oren mino. ");
INSERT INTO agd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Mai ráké ma akhempá orin ída nentá baren mifo nainti (90) mita máan bákan manáa eyo iyampon kayo ano mai votifin para váken basefin ma noyana víkakhein darifen oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Betí ankan ma non akhempá oriven onan maen ira kiyákan maifin manáa noyana iyó uran bákan mai akhempá bereti kayo vá baren mino. ");
INSERT INTO agd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Bákan mairá Yisasi máa sen betí ankan tiamemí, “Taréa ma fákeona noyana kayo finte manáa vare ereno.” ");
INSERT INTO agd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Máa siyain má Saimon Pita votifin káusen ódiven base un darifen eyurá meren mino. Mai vasefin ma kákan noyana fékaré ein mai mana antareti ifo fifti-tri (153) noyan nan baren mifo ída mai vase yáken mino. ");
INSERT INTO agd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Máan turákan Yisasi vetin tiamemí, “Erive yunan nano.” Síkan eyo iyampon kayo ano afová en béi Bafan mino siren béin inain nan péden mana ano éi iyé fono sen ída inaen mino. ");
INSERT INTO agd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Máan tiyákan Yisasi mairá oriven bereti vá noyana vá maman betí ankan amen mino. ");
INSERT INTO agd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yisasi ma furin pinté e mantaven ma vei eyo iyampon kayo avorá afoká ein mai ma anon kanú manaú dádasí en mino. ");
INSERT INTO agd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Betí ankan ma yunan narákan Yisasi Pitan inaemí, “Yonin anin Saimoni oe, éi ma sen nan anunu iyaona ano ma vanta kayo ma sen nan anunu iyain mai esantakhen nafino.” Máa síkan Pita semí, “Eyo Bafan noe, éi afová ukha ono. Téi en nan tinunu ukhé uno.” Máa síkan Yisasi véin tiamemí, “Máan ma sinteya mai senti sipisipi arará kayo vá dunan amisintano.” ");
INSERT INTO agd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Máa siren Yisasi evaránen Pitan inaemí, “Yonin anin Saimoni oe, éi sen nan anunu ukhe fono.” Síkan Pita semí, “Eyo Bafan noe, éi afová ukha ono. Téi en nan tinunu ukhé uno.” Máa síkan Yisasi véin tiamemí, “Tenti sipisipi kayorasá dafítintano.” ");
INSERT INTO agd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Máa siren evaránen Yisasi kanú manaú dádasí en Pitan inaemí, “Yonin anin Saimoni oe, éi sen nan anunu ukhe fono.” Síkan kanú manaú dádasí en ma Yisasi inaiyain nan Pita anomé iniyáken temí, “Bafan noe, éi minó daná afová ukha ompo séi en nan tinunu ukhé uno.” Máa síkan Yisasi véin tiamemí, “Tenti sipisipi kayo vá dunan amisintano. ");
INSERT INTO agd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Téi fura siré éin tiamiyá uno. Éi fumara ma vákeyai eyantá amú anan damure mae eyan ma orono seonafá oriya ompo éi ma afovaí uveya ayan kanan daní uresin ena vanta anon amú anan damuantáden éi ída orono sikhanona varufá aviren orinten mino.” ");
INSERT INTO agd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Pita inte avúavá puririsá intin ná Tiyarafenu ano kákan bí baranten nafi mai véi afová ino van mi Yisasi ma vaya sen mino. Máa siren Yisasi semí, “Téin tivákurono.” ");
INSERT INTO agd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita yo vaében onákan mai ma Yisasi moéken anunu ukhein eyo iyampon mano vékanan oyampá avákuren eren mino. Dunan ma nein inuran ma Yisasin má o súpá uven ma “Bafan noe, iye anó éin namuro ayampin kaintéi vae” ma sein mai vanta ino. ");
INSERT INTO agd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ma véin ódaren Yisasin inaen temí, “Bafan noe, ma vanta vá intesá inten nafino.” ");
INSERT INTO agd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Máa síkan Yisasi evaránen béin tiamemí, “Béi fara vantí téi ovaráné ereno van inikhé umpo mai ano éin intesá intéi vae. Téin mana sivákurono.” ");
INSERT INTO agd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mai eyo iyampon ída furinten mino ma sein baya ano mumunan nanin banta vaípá oreraen mifo Yisasi véin nan ída furinte ne vaya ída sen mino. “Béi fara vantí téi ovaráné ereno van inikhé umpo mai ano éin intesá intéi vae.” Máan manan béi sikhen mino. ");
INSERT INTO agd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mai eyo iyampon mano anan mai yanasinta van tian afoká uren ma vompon uvamá den mino. Mai ma véi ma sian afoká ein baya mai setí ankan afová ukhé tifékun mai fura vaya uron mino. ");
INSERT INTO agd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yisasi ma minó avúavá bariyá ein mai kokhon ban mifo séi ma iniyaruna mana mana yanái vompon dóki uvaman kaúdú kaúdú ono sen báintin mai vompon dóki kayo ma kain afokhan ma varará ída kanaí inté ein mino. ");
INSERT INTO agd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiofirasi oe, Yisasi ma araíen doriyáken monó baya minó nanin banta siamen eriyá ein bompon pefá uvaman amikhá uno. ");
INSERT INTO agd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Doren eriyan mai ma vei yorarí ino van ma vaya varen orin kayo me Kantá Aunani ákonafó monó baya siamin doran aní uran mi Tiyarafenu ano véin aviren inarufá óden mino. ");
INSERT INTO agd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Béi uman o varen púaren masí pinté e mantavin beni vaya ma varen orin kayo ano ódarákan béin nan pura sen aun manten mino sino van betin avorá foti (40) yamúpin kokhon dádasí iyáken betí baintá afoká uviyan Tiyarafenui Yafisin pintena vaya siamen mino. ");
INSERT INTO agd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Maná damú ma Yisasi vetí ankan má duna niyáken máan mi sen tiamikharen mino, “Tiretí ankan ída vá Yerusaremí me ampire ena varufá orera iyákeya mai ma se Sifóe ano ameno van tianten mino séku ma inikhá eona yanasará ave ono. ");
INSERT INTO agd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Monó non máa fói Yoni monó non péanten mifo ída ayáká basin mi Kantá Aunampó tiretin monó non péantanten mino.” ");
INSERT INTO agd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Máa sirákan maen bei eyo iyampon kayo e átaru uven béin inaemí, “Bafan noe, saréa Isareri vara evaráne maman ákona uantádesin ná mana kin mano yafisinten nafino áa ída fino.” ");
INSERT INTO agd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Máa síkan béi evaránen betí ankan tiamemí, “Mai áau fi yamu safi ída siretí ankan nina yaná banti ída kanaíe afová in nompo Tifóe veyákái aní uren maináká dafíken mino. ");
INSERT INTO agd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Máan tukhein Kantá Aunan ma siretimpin erivinti mae ákona mamareya séin pákena vaya Yerusaremí barufin má minó Yudiá bara akhempá bá Sameriá barafá bá inká ma varai minó akhempá deren mo siamin nono.” ");
INSERT INTO agd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Máa siran betí ankan avorá Tiyarafenu ano véin aviran inarufá ódiyain má mana konan mano véin iyádan ída onen mino. ");
INSERT INTO agd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Béi ódivíkan betí ankan ayompin kakhaken baré in efanten buí daná ukhein bantá kanan mano manádá betin ádé e manten mino. ");
INSERT INTO agd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","E mantaven máa semí, “Karirí banta kayo oe, pará tiretí ankan mará mantakheya ayompin kakhaké bara fono. Mai Yisasi ma Tiyarafenu ano saréa siretin pinte aviren inarufá ódi ma oneona avúaváká ten mi véi umbaránen eranten mino.” ");
INSERT INTO agd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Máa siran mairá eyo iyampon kayo ano Orifí Anuyon ne ma siyain anu me ampiren Yerusaremí oren mino. Yerusaremíké ma Orifí Anuyontá oriyain mai mana kiromita ino. ");
INSERT INTO agd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mai varufin oriven betí ankan ma fefá baré ein namumpin ódiven dan bain karafarampin un baren mino. Maifin ma un baré ein kéká mai Pita, Yoni, Yemisi, Enduru, Firipi, Tomasi, Batoromiu, Matiu, Arfiusin anin Yemisi inká Seroti kéká pintena vanta Saimoni, inká Yemisin anin Yudasi siren mino. ");
INSERT INTO agd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mai vanta kéká bá anasi kayo vá inká Yisasin anóe Marian má be afá kayo vá e átaru uven ará manafiní uren amúkiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Maí damú kayofin ma Yisasintá mumunan iyá ein nanin banta maen mai mana antareti ifo tuenti (120) nanin bantan átaru ukhen bákan mai finte Pita e mantaven ");
INSERT INTO agd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","máa semí, “Mumunan tiyofi sifá tiváeyan noe, pefá Tiyarafenui vompompin Kantá Aunan mano Devitin oo ráké naren Yudasin nan Yisasin avían namuro ayampin kainten ne ma sikhá ein mano fura sen dákóen mino. ");
INSERT INTO agd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Pefá Yudasi setimpin báken monó doran manaíen tetin má doriyaren mino.” ");
INSERT INTO agd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Máan tukhan maen mai Yudasi ano vei namu avúavákáke miyampó mana vara o miyaní uren mai varafin beyantá ánon páké eraven ankamíkan ben amú pautivin ará kakhufen barará eraven mino. ");
INSERT INTO agd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ínaimpáké Yerusaremí barufin ma vain nanin banta ano mai vaya iniren maen mai vara van betí avaya finté Akeradama e sen mino. Mai víi ana mai nare vanakhein bara en tikhen mino. ");
INSERT INTO agd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Máa siren Pita evaránen temí, “Ma vaya van Í Bompompin máa sikhen mino, ‘Béi ma varé ein afokhan áesin para vantin ná mai afokhampin ída vá mana vanta ano vano.’ Inká mai vompompin mana ena vaya máa sikhen mino, ‘Ena vanta áesin ná beni varu varano.’ ");
INSERT INTO agd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Máan tukhein nará minó banta kéká pinte mana vanta ano ma setí ankan má nókan Yisasi ma yoren non maen ontaré ein banta vá tetí avían kaékun ná beni varu varano. ");
INSERT INTO agd_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Yoni ma araíen monó non péantiyá ein táké ma eriaren ma Tiyarafenu ano Yisasin aviran inarufá ódein ma ontaré ein banta vá avían kaesin tetin tiyaen ná Yisasi ma fúaren e mantakhá ein baya vanasi siamino. ");
INSERT INTO agd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita máa sirákan kankánan banta avían kaen mino. Mana vanta maen kanú manaú bí ariyaren mino. Mai vanta van Yosepi ne sen ariyan inká Basabasin ne sen ariyan inká Yastasin ne sen ariyan mino. Ena vanta maen Matiasin ne sin avían kaen mino. ");
INSERT INTO agd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mai vantá kanan avían kaúden máa sen amúkemí, “Bafan noe, eyaká anan minó nanin banta aúpin afová ukha ompo ma kanan pinte ma éi anunu ukhanona vanta vá tetin aní uresin ná ");
INSERT INTO agd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yudasi vei yoran me ifá uren be nan ma vano sikhá ein barufá bano van oren mifo vékanan pinté iye anó Yudasini varu varen ná eni vaya varen orin doran bantaí inten nafino aní ono.” ");
INSERT INTO agd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Máa siren ayá danka vá asíka yanka vá punkikhaan ayampin pákaran Matiasi ayá danka yanúden e aní uvíkan béin avían tiyan míkan mifo sirantan mana orun kádan (11) baya ma varen orin kayofin asotú en mino. ");
INSERT INTO agd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentíkosi yamú e uníkan mumunan iyá ein nanin banta minó mana namumpin e átaru ukharen mino. ");
INSERT INTO agd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Átaru ukháin inaru fáké manádá kákan uva ma en ereiní uaren mai ma vetí ankan bá ein namumpin e víken mino. ");
INSERT INTO agd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Máan tiyain má betí ankan onákan banta amafin ten kayo ano ira anafun ma karékará en oreiní uaren mai namumpin ma varé ein kayo ánontá mana mana en o yoman nen mino. ");
INSERT INTO agd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Máan tiyain má Kantá Aunan mano vetí ankan aúpin bíkaven aya íkan araíen ara ara vaya sen mino. ");
INSERT INTO agd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Maí damú Tiyarafenu van ma féden bentá monó tiyain Yutan kayo ano minó bara fáké ere ere en Yerusaremí e varen mino. ");
INSERT INTO agd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","E varen mai ma uariyain ma inein kayo ano akhokho van e átaru uven mai ma siyain baya van takhaen oreraen mino. Mai fara va ino Yisasini vayan be avaya finté tiyan iníden mino. ");
INSERT INTO agd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iniren Yutan kéká ano anú diyáken temí, “Ma Karirí bara fáke nanin bantan banten mino. ");
INSERT INTO agd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Máan tukhen mifo inté uáken ná mana mana si vaya finté tiyará iniyá tife rafuno. ");
INSERT INTO agd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Para vara seyo, Patiá bara fáké eriyan Midiá bara fáké eriyan Eramíké eriyan Mesopotemiaké eriyan Yudiaké eriyan Kapadosiaké eriyan Pontasíké eriyan Esiaké eriyan ");
INSERT INTO agd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frikhiaké eriyan Pamfiriaké eriyan Isipíké eriyan Sairiní baru ádé Ribiaké eriyan Romuké arona eriyan ");
INSERT INTO agd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","inká Yutan kéká bá ena kéká bá ma setinti monó tiyain kéká bá Kirití kayo vá Arebia kayo vá anon iniyá tifékun tetinti vayafó Tiyarafenu ano ma ákona yorarí ukhein baya siyan mino. ");
INSERT INTO agd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Betí ankan anú diyáken kokhon ineine iyan betiyan ten inemí, “Ma yaná ma afoká eini ana mai intesá ukhen nafino.” ");
INSERT INTO agd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Máan tiyákan manáa kayo ano vetin nan taró tiyan temí, “Auyen uvaini kokhon naráken óen iyan mino.” ");
INSERT INTO agd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Máa siyákan Pitan má ena siyan míkan mifo sirantan mana orun kádan (11) eyo iyampon kayo vá ano e mantavin Pita oovaren máa semí, “Tirona Yutan kayo vá ena vara fáké ma Yerusaremí e vaona kéká ba soe, átaren ná mafá desin erivintirá mai ma afokái oneona yanái ana siaméku vá ineno. ");
INSERT INTO agd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tiretí ankan ma iniyaona ano ma kayo van óen non mi naráken óen iyan mino ma siyaona mai ída uron mino. Tare uron mi kakhakhan dan manápá ifo afápá kami kami un kádan (9 kiroki) áauí ukha ákurái va ono. ");
INSERT INTO agd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ma yaná ma afoká iyain nan pefá sakhanampa vanta Yoeri ano siádan baren mino. ");
INSERT INTO agd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘Tiyarafenu ano siyáken ma vara ma kípano van iyantí maé tesi Kantá Aunan minó nanin banta amaniná banaékun tiretin anin kayo vá inká tiren araun kayo vá ano sakhanampa vanta an danten mino. Máan tiyantin pumara kéká auu vaédantin oniyantin ayokhuvin banta kayo ano kokhon kain onanten mino. ");
INSERT INTO agd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Maí damú ana sesi yoran nanin má bantafin má dere sesi Kantá Aunan banaá dékun orintin maen sakhanampa vaya sinten mino. ");
INSERT INTO agd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Máan tiyantí maé ara ara yaná ayompin maman dákó é maé inká barará ara ara aní danasí ékun maen ira vá nare vá kákan íkun má édavinten mino. ");
INSERT INTO agd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Máan tintin áau ano sítípa intin inká biyon mano nare an den nararé inti ma ódaresin maen ínaimpákéi Bafani erin mai kama uran en panu sikhein damúi erinten mino. ");
INSERT INTO agd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Máan tiyantin intéa kéká anó ayaino van Bafan aví aranten nafi mai kéká aya uren evaránen aviranten mino.’ ");
INSERT INTO agd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Isarerí nanin banta oe, Nasaretíke vanta Yisasini vaya senté umpo vá ineno. Tiretí afová ono van maen Tiyarafenu ano véin pinté uaren enará ukhein ákona vá aní daná bá uvaren dararen iyákaya sireyantá afová ukha ono. ");
INSERT INTO agd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tiyarafenu ano afová ukhen pefá beyantá tiádan baré ein ánain dakhafen mi mai vanta siretin ayampin kaíkan namu vanta kayo ano siretin ayaen daa unkamádantá antópó béin arin puren mino. ");
INSERT INTO agd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Aruan púden nan purini ákona ano ída kanaíen béin pákaan dan baren mino. Mai fara va ino Tiyarafenu ano fúká ein pinte véin orun avían mantaren ída áin purini aí bá beraifin baren mino. ");
INSERT INTO agd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Pefá Deviti ano véin nan máan mi sikhan mino, “‘Téi onékun Bafan mano minó damú te má túpá ukhen mino. Para vara seyo, véi sen tiyan kurompá bain mana yana san téi ída feranté uno. ");
INSERT INTO agd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mai vará ten tirápin kama intirá timusin baya seno. Máa sé umpo sen tu vá dere ano vá mai van ave ino. ");
INSERT INTO agd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Para vara seyo, éi ída áená purin nanin banta ma vaimpin báku mae inká ei kantasí ukhein banta ída áesin masípin púta inten mino. ");
INSERT INTO agd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Éi fefái aun ma varan ain aní ukha ompo áesíen má bákuya moékan timusin timeno. ");
INSERT INTO agd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mumunan tifá tiváeyan noe, setin tinau Devitini vaya sian páman uan amenté uno. Béi fúbíkan masí uran beni masí para van eriyan taréa setimpin dere mai masí para van mino. ");
INSERT INTO agd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Mai fara va ino Deviti sakhanampa vantan bákan Tiyarafenu ano pura ódino siren béin iyáantiyáken ínaimpá en ana akhá pinte mana yékun eni varu varanten mino síkan afová ukhan mino. ");
INSERT INTO agd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Máa sikhan mai ma varará nanin banta ma evaránen aviran banta ma e mantan nain Deviti ínaimpákena yaná oniyáken béin ída áintin purin nanin banta vá báken mai masípin púta inten mino sikharen mino. ");
INSERT INTO agd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mai vaya ma sikhá einíen Tiyarafenu ano mai Yisasin masí pinté orun avían mantá tetí minó kayo ódarákaréi mai vaya sian dákó iyá tiféuno. ");
INSERT INTO agd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Máan tukhan pefá ma Tiyarafenu ano Kantá Aunan amenté uno siren ma iyáantáká ein Yisasin amin mamaren inarufá óden be afóen ayan kurompá un ban mi saréa ma oniyáke ma iniyaona Kantá Aunan banaiyan mino. ");
INSERT INTO agd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Deviti ída Yisasi ma ódeiníen inarufá óden mifo véi máa sikhan mino, “‘Bafan mano senti Bafan máa sen tiamikhan mino, “Éi sen tiyan kurompá kumantesí ");
INSERT INTO agd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ma eni namuro kayo maman bararasí uré en aránaó kaúdéku vá ono.” ’ ");
INSERT INTO agd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Máan tukhen mifo Isareri nanin banta oe, minó ano vá afová ono. Yisasi ma yaa unkamádantá ma aruan pureona vanta Tiyarafenu ano véin maman Bafaní uren doran banta e sen Tiyarafenu ano ma aní ukhá ein banta ino’. ");
INSERT INTO agd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Máa síkan banasi ano Pitani mai vaya inin amafon aí iyaimpin Pitan má ena vaya varen orin banta kéká bá inaemí, “Tifá tiváeyan noe, setí náisá onté tife rafuno.” ");
INSERT INTO agd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Máa síkan Pita evaránen betí ankan tiamemí, “Tiretí ankan mana mana ano ume finté ará baédeya Yisas Karaisin avíká monó non baresin ná Tiyarafenu ano siretíi ume ampiantano. Máan ma esin mi Tiyarafenu ano Kantá Aunan aminten mino. ");
INSERT INTO agd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pefá Bafan tetisi Tiyarafenu ano siretí ankan má tiretí akhafana vá inká nentá ma vain nanin banta vá ma ínaimpá araren Kantá Aunan amin nain mi iyáantákaren mino.” ");
INSERT INTO agd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Máa siren béi ena vaya kayo vá ákonaen tiamiyan tútúpemí, “Tiyarafenun inaesin ná tare ma vain namu nanin banta kayo fintena siretin aya ino.” ");
INSERT INTO agd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pitani vaya ano mai nanin banta amafon aí iyaimpin maí damú ana kanú manaú tauseni (3,000) nanin banta ano ará baéden monó non péden mai nanin banta ano Yisasintá ma mumunan iyain kayo vá o asotú en maman kokhoníen mino. ");
INSERT INTO agd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kokhoní uven mai kayo ano vaya varen orin banta kayo ma afova amiyain baya ákonaen iniyáken betin má manafin o átaru uven monó ten dunan nen amúken iyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Máan tiyan Tiyarafenu ano vaya varen orin banta kayo finté ayan táké uaren kokhon enará ukhein ákona vá aní daná bá barákan banasi ano mai yanasinta oniyáken anú diyan akhokho van en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Máan tiyákan Yisasintá ma mumunan iyain kéká ano ará manafiní uren mana inintá báken minó daná ben amin ben amin iyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Máan tiyáken betíi vara vá kama yanasinta vá sarí uren moní máden manáa yana san ma o afasí iyain kéká aya iyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Máan tiyáken minó damú monó namun dafufin ena ena átaru iyáken maen inká mana mana namumpin o iyuve e iyuve en dunan niyáken betiyan maman bararasí uren amusimpin baren mino. ");
INSERT INTO agd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Báken ena ena yamú Tiyarafenu aví daní iyákan banasi ano vetin nan anunu iyan ena ena yamú Bafan mano ará ma vaerein nanin banta avídú íkan mai ma Yisasintá ma mumunan iyá ein nanin bantafin mo asotú en mino. ");
INSERT INTO agd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Maná damú Pita nú Yonin nú monó namumpin amúkono siren kanú manaú áauíen inúpasí iyan oren mino. ");
INSERT INTO agd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Oriyan o onákan monó átaru yafu ona van ma Avorú Ona e siyaintá mana arantan namu ukhein banta minó damú aviren mo khain báken monó dafufin ma ódein nanin banta vaípá moni san inantiyain baré íkan aviren meran baren mino. Mai vanta maen be anóen arápin mi arantan namu ukhan kaen mino. ");
INSERT INTO agd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Morákan báken ma mai vanta ano Pita nú Yonin nú onan monó namumpin umperano van ódíkan maen békanan baípá mai vanta ano moní inan ten mino. ");
INSERT INTO agd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Inan tíkan Pita nú Yonin nú ano mai vanta mo furefure oniyáken Pita semí, “Éi verasan tonano.” ");
INSERT INTO agd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Máa síkan mai vanta ano náinasá timinten nafino sen mumunan iyáken purefure en békanan onen mino. ");
INSERT INTO agd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Oniyain má Pita máa sen tiamemí, “Téi ída moní dékun ban mifo se ma yákeruna yana amenté uno. Nasaretíke Tiyarafenu ano ma aní ukhein banta Yisasin avíká éi e mantave orono.” ");
INSERT INTO agd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Máa siyáken ben ayan kurompáke yáman pákaaren orun ayan nóan mantiyain má ana mai vanta ayákon má arantan má kamaen ákonaen mino. ");
INSERT INTO agd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ákona iyain má beyantá kútin e manten orian ódaren mairá békanan bákuren monó namumpin ódiyáken káosi káosi iyan Tiyarafenu aví daníen mino. ");
INSERT INTO agd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mai vanta ano káosi káosi iyan Tiyarafenu aví daní iyain minó nanin banta ano oniyáken, ");
INSERT INTO agd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","betí ovaren me afová en mai ma monó átaru yafu ona van Avorú Ona e siyaintá ma ena ena yamú báken ma moní inantiyan baré ein banta aurái ma yaná afoká ukhen mino siren takhaiyan kokhon ineine en mino. ");
INSERT INTO agd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Banasi ano ma mai vaya iniyáken anúden orera iyan mairá tavaen e átaru uven mai vanta onákan Pita nú Yonin nú ayan pákáan ákona uren mai ma Soromonini Yuse se ma siyaintá mantakharen mino. ");
INSERT INTO agd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita máan ma iyain oniyáken banasi siamemí, “Tiretí Isareri nanin banta oe, ma yaná ma yákó iyain nan pará anú diyayá békani kama avúavá bá ákona vá anon ma vanta ayain manten oriyan mino sireyá berasan urú toniya rafono. ");
INSERT INTO agd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abaraamu má Aisakin má Yekopun má inká tetin tinafuyan mái Ayarafenu ano vei yoran banta Yisasin kákan bí amira mai vanta e avían namuro ayampin amen nan Pairoti ano véin ampiantiya ompo siretí Pairotin avorá ben oyan amire ída vá mai vanta ampiresin ná orino se ono. ");
INSERT INTO agd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Máa sireya Kantasíen Puntákein Banta oyan amire, vanta aruan purin banta van aésin teti vaípá erino siya inae ono. ");
INSERT INTO agd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","An uanten aun bain aintá ma siviren orin bantan tiretí aruan púden nan maen Tiyarafenu ano masí pintena evaránen avían mantará berasan ontaréi mai van tian dákó iyá uno. ");
INSERT INTO agd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Berasan Yisasintá mumunan iyáké ben avíkái ma vanta ayanóan mantékun ákona mamarai óde afová iya ono. Yisasin avíká ma mumunan in manon pura sen ma vanta ayofakhayan oniya rono. ");
INSERT INTO agd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Tifá tiváeyan noe, séi afová ukhékuya siretin má tiretíi yafisin banta kayo vá ano ída afová ukheyan mai ná avúavá Yisasin amaniná kae rono. ");
INSERT INTO agd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Máan te ompo fefá Tiyarafenu ano sakhanampa vanta kayo finté uaren mai vanta van mi Tiyarafenu ano ma aní ukhein banta ano uman barante ne sikhá iyan ben amaniná máante rono. ");
INSERT INTO agd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Máan tukhen mifo siretí ankan ará baéde sirun noe sireya Tiyarafenu vaípá oresin ná tiretíi ume arúantano. ");
INSERT INTO agd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Máan turantin Bafan pinté kusen ban erintin ná mai ma vanasi evaránen aviranten ne sen pefá aní ukhá ein banta Yisasin tiantantin ná enádá ovaránen erino. ");
INSERT INTO agd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Erinten mifo véi inarufá pa ave ukhantin ná Tiyarafenu ano ma vei kantasí ukhein sakhanampa vanta kayo finté uaren ma iyáan táká ein maman evaránen auyení urantin ná minó danasinta yákó ino. ");
INSERT INTO agd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pefá Mosesi siyáken, ‘Bafan Ayarafenu ano siretíi kéká pinte mana vanta avían kaintin ten an den sakhanampa vantái inten mifo siretí beni minó baya inire vá dakhafono. ");
INSERT INTO agd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Máan tukhantin mai sakhanampa vantai vaya ma ída inin nain nanin banta ano ída uron mi Tiyarafenui vanasifin banten mino.’ ");
INSERT INTO agd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Sakhanampa vanta Samuerin táké ma araí uren erikhein sakhanampa vanta kayo minó ano mana yana san mi sikháin maí damú inka yákóen mino. ");
INSERT INTO agd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sakhanampa vanta kayo ma siyá ein baya kayo vá Tiyarafenu ano ma siretin anafuyan má ma manafin kasen ban baya ma sikhá ein mai vetin anavasin mi sireti varé en nan mi siretin amaninái yákóen mino. Béi Abaraamun tiamiyáken, ‘En anavasin pinté uaren mi minó barará nanin banta ano avu varanten ne sikhan mino.’ ");
INSERT INTO agd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Máa sikharen mai van mi Tiyarafenu ano vei yoran banta avían mantaren tiretí mana manai namu avúavá pinte avu uranti ará baerano van tiantan tireti vaonafá nare eren mino.” ");
INSERT INTO agd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitan nú Yonin nú ma vanasi vaya siamiyákan mairá monó doran banta kayo vá Sadyusi kéká bá monó namuntá ma yafisiyain kayoi ánon banta vá ano mairá e unen oren mino. ");
INSERT INTO agd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Onóben iníkan Yisasin nan e mantakhein púkein kéká ano yere orun mantanten mino sen míkanan mano sian afova amiyare íkan betí ankan o inen mai van kákantá aranan en mino. ");
INSERT INTO agd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aranan uren békanan pákádaran duniyaimpin ena ákurá do kakhantí kó tiantádé puntarano van míkan aviren mo karavusi namumpin kaen mino. ");
INSERT INTO agd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Míkan ma siyain baya iniren ma Yisasintá mumunan ein banta mai yan manápá tauseni ino (5,000). ");
INSERT INTO agd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Máan tukháin ená damú Yutan kayoi yafisin kéká bá monó doran banta kayo vá inká man baya ma afová amin kayo vá ano Yerusaremí e átaru en mino. ");
INSERT INTO agd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Átaru iyákan monó ánon banta kékái ánon banta Aanasi má Kaiafasi má Yoni má Areksanda má inká ena monó ánon banta kayoi kéká bá dere maifin e varen mino. ");
INSERT INTO agd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mai kéká ano Pita nú Yonin nú aviren me vetí ankan avorá kaúden míkanan inaemí, “Intéa ákoná bákayá iyen avíkasá mai yaná bariya rafono.” ");
INSERT INTO agd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Máa sen ina iyákan maen Kantá Aunan mano Pitan aúpin bíkavin betí ankan tiamemí, “Tiretí Isareríi yafisin má monó doran banta kayo va soe, ");
INSERT INTO agd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ma ma aranta namu ukhein banta ma aya ukheruna fáke inté uákesá berasan béin ayofe rafu mai séi ma iniyarun siretí ankan tetin inaúdé afová ono van mi iya ono. ");
INSERT INTO agd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Máan tiya ompo vá minó Isareri nanin banta ano ma vaya vá afová ono. Mai ma Nasaretíke vanta Yisas Karaisin ma yaa unkamádantá aren nan púbin ma Tiyarafenu ano evaránen avían mantein banta avíkái ayofaádékun mai vantan tiretin avorá mantakhen mino. Béi maen ");
INSERT INTO agd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“‘Má uvaran banta kayo ano ma yo maman karúdein onámaná ano maman má dádaimpin mana ákona onámanasí ukhen mino.’” Mai ákona onámaná maen Yisas Karaisi ino. ");
INSERT INTO agd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Máan tukhantin ma varará banta ída ena vanta Tiyarafenu ano amikhá intin banasi evaráne aviranten e sikháintin tetin ída siyainten mifo Yisasi anan tetin barará nanin banta kama uren evaránen tiviranten mino. ");
INSERT INTO agd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mai vaya siyákan dafisin kéká ano Pita nú Yonin nú ódaren míkanan Yisasi má pefá bákan ontaren mino. Békanan ída mana sikhuru siren afova mantá eintá ída feran ákonaen baya siyákan mai van betí ankan kokhon ineine en oreraen mino. ");
INSERT INTO agd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kokhon ineine iyáken betí ankan onákan mai ma arantan namu ukháin ayofein banta ano vékanan má mantakhan mai van betí ankan ída mana vaya evaránen békanan tiamen mino. ");
INSERT INTO agd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Máan turen mairá mai Kanisori ano vékanan tiantan mai átaru namunté ekhuven barufá aravuvíkan betiyan baya sen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ten orera iyáken temí, “Ma vantá kanan mano moéken enará ukhein ákona ma aní ein mai Yerusaremí ma varé ein nanin banta ano inka afová en orera ein ída umera tifanté umpo míkan amaniná náisá otifante rafuno. ");
INSERT INTO agd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Máan tiyaren mai vaya ano minó nanin bantafin orera inafo erítifé békampin ákona é baya siamé tifékun ná ída evárénen mai víká banasi sian amino.” ");
INSERT INTO agd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Betiyan baya siren mairá békan aran mai namumpin ódíkan Yisasin aví tiriya ma vanasi afova amiyain béin aví ma sin má dere míkanan airo ananí uanten mino. ");
INSERT INTO agd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Máa síkan Pita nú Yonin nú ano vetí ankan evaránen tiamemí, “Tiyarafenu avorá tireti inte é té iniya rafono. Berasan mai Tiyarafenui vayá dakhafonu áa sireni vayá dakhafó tifante rafu maifin daídé vá afová ono. ");
INSERT INTO agd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mai van mi verasan ída kanaíé vaya mará me fákanté umpo verasan ma oniyá ma inikhá eruna yaná minói sian dákó onté uno.” ");
INSERT INTO agd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Máa síkan banasi ano ma mai yaná ódaren Tiyarafenu aví daní iyain nan mai yafisin kayo ano vetí ankan nan péden míkanan amaniná ída kanaí en mana aau kairíin pasen ída uman amin nan evaránen ákona vaya ana siamíden tiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Para vara seyo, mai ma míkan mano enará ukhein ákonafó ayofan ma arantan kamaein bantai orana mai foti (40) orana esantakhein banta ino. ");
INSERT INTO agd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita nú Yonin nú tiantádan maen mai yafisin banta kayo me ampiren békani kéká baípá oren o váken mai ma monó ánon banta kayoi ánon banta vá monó doran banta kayo vá ano ma sein baya siamen mino. ");
INSERT INTO agd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tiamin iniren mairá betí ankan ará manafiní uren Tiyarafenu amúkuan amen temí, “Bafan noe, éi vara vá non má inaru vá maifin ma minó daná baini uvaran benafo ono.” ");
INSERT INTO agd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Pefá eni Kantá Aunan mano sétin tináu Devitin mana vaya amíkan Deviti máan mi sikhan mino. “‘Intéa ana vará minó ena anan nanin banta ano móekentá aranan iyáken ná para é tiren ná mai Isareri nanin banta ano fasavifá namu avúavasí ono van baya sian damuan kaiyan nafino. ");
INSERT INTO agd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Minó bara vain bain ma vain kin kayo ano aruvin danasinta utaaren mantakhan inká dafisin kéká bá ano manafin átaru uven Bafan Tiyarafenu maman bararasí uré barará nanin banta ma evaránen aviran nan ma sikhá ein banta maman bara finí ono van iyan mino. ");
INSERT INTO agd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Pura siren Erotin nú Pontias Pairotin nú ano ena anan kéká bá Isareri nanin banta kayo vá o éken ma varufin e átaru uven ei kantasí ukhein doran banta Yisasi ma fefa éi aní ure nan baré ein maman bararasí ono van iyan mino. ");
INSERT INTO agd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Betí ankan ma varein daná mai ei ákonará pefá tiáden nan baré íkan mi eni anunu vá ineine vá ánain mi yakhafen mai yaná afoká en mino. ");
INSERT INTO agd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bafan Tiyarafenu oe, setí eni yoran banta kayo ma sikhokho simin baya kayo ma siyain ná inireya siya esirá ákona ukhé ída feran eni vaya ákonaé banasifin tian dáko ono. ");
INSERT INTO agd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","E ayan daruádesin orinti vá banasi aí kípaan tiyáke aní danasinta aní iya vá ara ara yaná ei kantasí ukhein doran banta Yisasin avíkasá uvarano.” ");
INSERT INTO agd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Máan amúkirí uan kíparan maen mai ma vetí ankan baré ein namun antu antu iyáken Kantá Aunan mano vetí ankampin bíka víkan Tiyarafenui vaya ákonaen tian dákó iyáken ída feren akhokho van en mino. ");
INSERT INTO agd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yisasintá ma mumunan ein kéká ano mana ineine vá mana ará bá báken mai kéká pinté ída mana ano ma yaká ein dana san tiyáken ma seya sina ino sen mifo minó dana ma mana mana ano ma yan baré ein danasinta mai minó avaríen oreraen mino. ");
INSERT INTO agd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Máan tiyan kákan ákonafó Aposeri kéká ano Yisasi ma fúaren orun mantakhein baya vanasi siamen orera iyákan Tiyarafenu ano mai nanin banta van anunu iyáken betí ankan moékentá avábá uanten mino. ");
INSERT INTO agd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Máan tíkan betí ankan aúbaná ída mana nanin banta ano ona varafi yunan narafi o afasí ukharen mino. Máan tukhen kokhon bara fi ma safi ma yaká ein minó sarí uriyan moní máden mai moní baren ");
INSERT INTO agd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","me aposeri kayo amíkan mai moní daíden i ma vain kéká amiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Máan tiyákan Saiprasíke mana Rivai ánon banta Yosepin ne ma siyain banta aposeri kayo ano ena ví Banabasi ne siran baren mino. Banabasin bí maen mai veni ana Ará Ákona Uantan Anin ne ma siyain baya vá manaí ukhen mino. ");
INSERT INTO agd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mai vanta ano vei vara sarí uren mai ráke moní baren Aposeri kayo mo amen mino. ");
INSERT INTO agd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mana Ananiasin ne sin banta vá be aná Safairan ne sin má baren békani manáa vara sarí uran mana vanta ano miyaníen mino. ");
INSERT INTO agd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Miyaní uran mai vara ráké moní be aná ano afovai ukhan daíden manáa veyan aúpá kaúden manáa ana varen aposeri kayo mo makáden tiamen mai máa moní i varé uno siren amen mino. ");
INSERT INTO agd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Amíkan Pita máa semí, “Ananiasi oe, fara é tire e aú ona yire nan Ban Anon mano en aúpin bíkaya Kantá Aunan mákádeya mai vara ráké ma vareóna moní manáa aúpá kae fono. ");
INSERT INTO agd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ídá afová ukhen nan ná mai vara ma ída sarí ukhen nan en nina varéin ná mai vara miyaní urá moní bare fono. Mai moní eninaí uvi ompo e anunu ánain bákureya ída amenté uno sinona van Tiyarafenu amenté uno ma sireya náiná anó éin mai inin amiyá mai avúavá bare fono. Tetin na máka sisinte va ompo Tiyarafenui máka siante ono.” ");
INSERT INTO agd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Máa síkan Ananiasi mai vaya iniyáken eraven barará ankamiyan esé ana fúbíkan banasi ano Ananiasin amaniná ma yákó ein baya iniren moéken akhokho van en mino. ");
INSERT INTO agd_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Máan tuvíkan pumara vanta kayo ano mai vanta e maman davaráefin úkuren baren mo masíen mino. ");
INSERT INTO agd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Masí uran kanú manaú áau orivíkan Ananiasin amaniná ma yákó ein daná be aná ano ída afováin mápin un peren mino. ");
INSERT INTO agd_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Unóbíkan Pita véin inaemí, “Éi sisimeno mai máa monisá tirei vara ráke vare fono,” síkan mai nanin mano siyáken, “Eyo, mai máa moní i varé uno.” ");
INSERT INTO agd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Máa síkan Pita véin tiamemí, “Pará tiré kanan baya sian damureya Bafani Kantá Aunan máka sentá fono. Onano, en avafun ma masí ein kayo onará édiyain mai kéká ano éin má daiyóen orinten mino.” ");
INSERT INTO agd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Máa siyain má anan Pitan arantampin mai nanin eraven ankamen púbíkan mairá pumara vanta dun onan mai nanin púkeimpin mairá béin daiyó en oren be avafun ma masí ukharé ein áde mo masíen mino. ");
INSERT INTO agd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Masí urákan monópin ma vain nanin banta vá ena nanin banta kayo vá ano mai vaya ma iniyáken moéken akhokho van en mino. ");
INSERT INTO agd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposeri kéká ano kokhon enará ukhein ákona vá aní danasinta vá banasi aúban uvariyákan maen Bafantá ma mumunan iyain nanin banta ano ará manafiní uren o éken Soromonini Yuséká átaruen mino. ");
INSERT INTO agd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Átaru iyan mai kéká ano féden ída vetin má e átaru iyaren mifo mai kékápin ma ída vain nanin banta anon betin aví daní iyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Máan tiyákan kokhon nanin banta ano Bafantá mumunan iyan beni kékápin me asotú asotú en maman kokhoníen mino. ");
INSERT INTO agd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Máan ma iyain anarái Pitan aman ma oriyain aa akhempá banasi ano aí nanin banta aviren mo yóki uvíden kaiyan inká manáa kúkútafin kaiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Máan tiyákan Yerusaremí baru áde ma vain barufin páké ano yere aposeri kayo e oniyáken aí nanin banta vá inká namu aunan ma fákakhein kéká bá aviren eríkan mai nanin banta ayofen mino. ");
INSERT INTO agd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Monó ánon banta kékái ánon banta vá bei kéká ma Sadyusifin bain kayo vá ano ma mai avúavá oniyáken aposeri kayo ará namu uanten mino. ");
INSERT INTO agd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Namu uantáden betí ankan e manten aposeri kayo fákaren aviren banasi ma karavusií iyain namun mo karavusiíen mino. ");
INSERT INTO agd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Máan turan mai inuran mana Bafani enisori ano minó ona yiren betí ankan aviren barufá morúden máa semí, ");
INSERT INTO agd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Tiretí ankan monó dafufin o mantave auyen aunani vaya minó tiamesin ná banasi ano inino.” ");
INSERT INTO agd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Máa síkan aposeri kayo ano mai vaya iniren pe ákurá e manten oren monó namun dafufin o váken araíen mai vaya sian afova amiyaren mino. Máan tiyákan mairá monó ánon banta kékái ánon banta vá bei kéká bá Isarerii yafisin kayoi ánon banta kéká bá aran e átaru uven mai aposeri kayo aviren betí baintá erino van karavusi namumpin baya yan oren mino. ");
INSERT INTO agd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Piripo kayo ma siantan oriyan o onákan mai karavusi namun ída aposeri kayo vaimpin evaránen oren mo mai ánon banta kayo siamemí, ");
INSERT INTO agd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Teti oriyá o onékun karavusi namunte ona fara ákonaen munkukhan onará ma yafisin banta kayo fara mantakhá ma ona ma yiré maifin ma onékun ída mana vanta maifin baren mino.” ");
INSERT INTO agd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Máa síkan kákan monó namuntá ma yafisin kayoi ánon banta vá monó ánon banta kayo vá ano ma mai vaya iniren kokhon ineine en amino iyáken máa semí, “Náina sá afoká inten nafino.” ");
INSERT INTO agd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Máa sen iniyákan mana vanta ano enóben betí ankan tiamemí, “Orive onano, mai ma karavusifin kaeona kéká masina kákan monó namun dafufin o váken banasi iyanuan kaúden mai vaya siamin iniyan mino.” ");
INSERT INTO agd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Máa síkan kákan monó namuntá ma yafisin kayoi ánon banta vá piripo kayo vá ano oren aposeri kayo o aviren eren mifo vanasi ano onámaná ankamin nain nan péden betí ankan amaniná ída mana yaná avúavasíen mino. ");
INSERT INTO agd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Dafisin banta kayoi ánon banta kéká ano aposeri kayo ina ino van piripo kayo ano vetin aviren me kaúdákan monó ánon banta kékái ánon banta ano máa sen inaemí, ");
INSERT INTO agd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Teti ma siretí ankan tiamé ída uron ná mai vanta avíká monó baya vanasi siameno siré airo ananí uanteruna ifo fará tiretí mai vaya vanasi siamiyan nan Yerusaremí ma vain nanin banta ano mai vaya inen orera iyákayá inká tetin nan mai vanta aruan pure ono sireyá tetin tu finté iya fono.” ");
INSERT INTO agd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Máa síkan Pita má ena vaya varen orin banta kayo vá ano evaránen betí ankan tiamemí, “Tetí Tiyarafenui vaya anan dakhafo sifanté umpo varará nanin bantai vaya ída yakhafó tifanté uno. ");
INSERT INTO agd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tiretí ankan manon Yisasin daa unkamádantá aruan púden nan mi setisi sináuyani Ayarafenu ano véin purin pintena evaránen avían mantakhen mino. ");
INSERT INTO agd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Béi anon tetinti aa aní uren evaránen tiviran banta vákan Tiyarafenu ano véin aviren inarufá mun bei ayan kurompá kain dan bain kin aniní ukhein tetí Isareri nanin banta siyaintí maé tirá baeré tifékun tetinti ume ampisintanten mino. ");
INSERT INTO agd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tetí ankan mai yanasinta ódákéi mai vaya sian dákó iyá tifékun inká Tiyarafenu oo ma yaiyein kékái Kantá Aunan amikhan mai aunan mano yere sian dákó iyan mino. ");
INSERT INTO agd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Máa síkan Kanisori kayo ano mai vaya iniren kákantá aran nan iyáken betin aruan purono van en mino. ");
INSERT INTO agd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Aruan purono van iyákan mai yafisin banta kayoi ánon banta kéká pinté mana Farasisi vanta véin aví Kamarierin ne sin man baya afová ukhan ma vanasi ano véin kákan bí amiyain mano orun mantaven tiamemí, “Ma kéká tiantan manáa afará barufá orun bano.” ");
INSERT INTO agd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Máa sin betin aviren barufá aravuvíkan mairá Kamarieri orun mantaven Kanisori kayo siamemí, “Isareri vanta kayo oe, mana yaná ma ma vanta kayo amaniná kaono sinte mae ovare me inireya vá mainá betí ankan amaniná kaono. ");
INSERT INTO agd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Afovaí ukharono. Ída ayá damú oriyan mino. Teudasi ano e mantaaren temí, ‘Téi vafan bákun ten tiví bain banta uno,’ síkan ádé anantá kami kami antareti (400) nanin banta ano véin dakafiyaréin maen kamani ano véin aruan púdan bentá ma mumunan iyá ein kayo me ifá en orera íkan beni yoran mo savifa afe ein mino. ");
INSERT INTO agd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ben oyampáké kamani ano ma vanasi aví baran damú Kariri fáke Yudasin ne sin banta ano e manten banasii ineine maman asuse en kamanin aré tavono van íkan béin má aruan púdan ben ma vákuren noré ein kéká ano me onen karan orera ein mino. ");
INSERT INTO agd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Máan tukhein nan mi siretí ankan tiamiyá uno. Ma varará bantai ineinerá ma yoriyaren mai yoran mo asuse inten mifo ída vá mana yaná betin amaniná kaiya ampiantesin ná orino. ");
INSERT INTO agd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tiyarafenu ano ma mai ineine yákó ukhá inti mae máan tiya véin má namuroí inampo ída vá mai yoran are ono.” ");
INSERT INTO agd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Máa síkan Kanisori kayo ano Kamarierini vaya iniren baya varen orin banta kayo aran eríkan dafiyó ankáden Yisasini vaya siamen non nan airó ananí uantáden ampiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Beti ma Yisasin avíká uman baren ayave o yosin ma Tiyarafenu ano vetin nan kama nanin banta ino ma sein nan mi vaya varen orin banta kéká ano yafisin banta kayoi ánon banta kéká me ampiren oriyáken amusin en mino. ");
INSERT INTO agd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Amusin uren Yisasi ma vanasi evaránen avíkein mai kama vaya ída me ampinton ena ena yamú kákan monó dafu kayofin má mana mana namumpin má orera uven tiamiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Maí damú eyo iyampon kayo ma mo kokhoní iyan maen mai aúbanáké Kiriki vaya ma siyain Yutan kayo ano Aramaiki vaya ma siyain Yutan kéká anan uanten máa semí, “Minó damú tiretíi varé nanin kayo anan ayaiya ompo setisi varé nanin kayo ída ayaiya ono.” ");
INSERT INTO agd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Máa siyaimpin tiyan míkan mifo sirantan kan orun kádan (12) eyo iyampon kayo ano ena eyo iyampon kayo minó iyanuan kaúden máa semí, “Dunan amin naro sire ma Tiyarafenui vaya mo siamin doran ma me ampin ída kama ukhen mino. ");
INSERT INTO agd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Máan tukhen mifo sifá tiváeyan noe, siretin aúbaná intéa anó banasi avorá kama ví bákan ná Kantá Aunan mano aúpin bíkakhaná kama afova van nafi mai finte vá dan manápá ifo afápá kan un kádan banta aviádesin ná mai yorantá betí ankan dafisino. ");
INSERT INTO agd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Dafisiyantí maé teti minó damú timúkiyáké Tiyarafenui vaya siamiyá banasi aya ó tifanté uno.” ");
INSERT INTO agd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Banasi ano mai ma aposeri kayo ano ma sein baya van amusin uren mairá ákona mumunan iyan ma Kantá Aunan mano víkakhein banta Stivenin maman kaiyan Firipi má Prokorusin má Níkanorin má Timonin má Pamenasin má Antiokí banta Nikorasin má avían kaen mino. Nikorasi ída Yutan kéká pintena vanta ifo béi ena anan bantan báken Yutan kayoi monó dakhafiyan mino. ");
INSERT INTO agd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Máan turen mai vanta kéká avían aposeri kayo vaintá me kaúdan mai yorarí ino van ayan ánontá kaúden avu uanten mino. ");
INSERT INTO agd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Máan turan Tiyarafenui vaya ano minó barufá orera íkan Yerusaremíké kokhon nanin banta kayo ano aú baéden Yisasini eyo iyampon kayoí iyákan inká kokhon monó ánon banta kayo vá dere ano Tiyarafenui vaya iniren mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tiyarafenui sarisari vá ákona vá ano Stivenimpin bíkavin banasi aúbaná enará ukhein aní danasinta uvariyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Máan tiyákan Yutan kayoi Monó Ano Ma E Anunurasá Bano ma sikhein monópin ma Sairiní baru vá Areksandriá baru vá inká Sirisia bara vá Esiá bara vápinté ma e varéein Yutan kéká ano mai vayará araíen Stivenin má asiven mino. ");
INSERT INTO agd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Máa siyan maen Kantá Aunan mano Stivenin kama afova amiyan ma siyain baya mai kéká ano ída kanaíen ankaman durafurin nainíen mino. ");
INSERT INTO agd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Máan tiyaimpin mai setí inékun Mosesin má Tiyarafenu vái ankayan tiyan mino sino van mai kéká ano aúpáké ena vanta kayo mo arápiníen mino. ");
INSERT INTO agd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mai avúavasí o senten banasi vá monó ánon banta kayo vá man baya ma afova amin kayo vá arápiní uren Stivenin o fáken Kanisori kéká baintá mo khaen mino. ");
INSERT INTO agd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mo khaúden béin aufin manáa kampun baya sino van manáa vanta kayo síkan mai kéká ano máa semí, “Minó damú inétifékun ma vanta ano Tiyarafenui kantisí ukhein baru vá beni man baya vá ankayan tiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Máan tiyáken inká Nasaretíke vanta Yisasi ano kasaen monó namun ankaman mádaren inká Mosesi ma setin timikhá ein avúavá do maman karúdanten mino siyáká iniyaré tiféuno.” ");
INSERT INTO agd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Máa siyan mai ma Kanisori namun ma varé ein kayo ano Stivenin purefure en oniyan maen ben auná ano enisori auná ma fanu seiníen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Máan turan mairá monó ánon banta kékái ánon banta ano Stivenin inaemí, “Ma ma éin nan tiyain baya kayo mai furá tiyan nafino.” ");
INSERT INTO agd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Máa síkan Stiveni evaránen temí, “Tifá tiváeyan má tifóeyan ma soe, siretí ankan ná ineno. Teti sinafu Abaraamu ma Mesopotemiá barafá ban ma Araní barufá ída orikhan maen inarufá ma minó ákona vain Tiyarafenu ano Abaraamu vaintá dákó en mino. ");
INSERT INTO agd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dakó uven Tiyarafenu ano véin tiamemí, ‘E antun má ei vara vá ampireya séi ma aní onuna varafasá orono.’ ");
INSERT INTO agd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Máa síkan Abaraamu Saridia vara me ampiren Arani varufá o varéin be afóe ma fúbíkan Tiyarafenu ano véin tiantan ma ma saréa vaóna vara e varen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Maí damú Abaraamun ída manáa vara amikhan inká ída iyampon kaúkan maen Tiyarafenu ano siyáken, ‘Ma vara ínaimpáké e má en ana akhá bá amenté uno,’ sen iyáantákan mino. ");
INSERT INTO agd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tiyarafenu ano Abaraamun máa sen tiamemí, ‘En ana akhá ano ma ena varafá o soya ma vainí ukhantin kami kamí antareti (400) oranarái vetin uman amiyantin miyan ída van dorarí inten mino. ");
INSERT INTO agd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Máan tinten mifo mai ma ída miyan ban dorarí uantiyaré inona kéká téi uman amirékun maen ínaimpáké betí mai vara me ampiren ma varará e váken téintá monó tinten mino.’ ");
INSERT INTO agd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Máa siren mairá Tiyarafenu ano Abaraamun má ma kasen báken au ma kaí pákena siamídan mairá Abaraamu ano Aisakin afóení uven béin kaúdan ma yan manápá ifo afápá kanú manaú damusí ma iyan maen béin au kharan ínaimpáké Aisaki ano Yekopun kaúdan inka Yekopu ano siyan míkan mifo sirantan kan orun kákan (12) banta setin tináuyan kaen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Kaúdan mai sináuyan mano Yosepin ará namu uantáden avían ena kékápin mo sarí uran béin miyaní uren aviren Isipi morun kain baren mifo Tiyarafenu véin má báken ");
INSERT INTO agd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","beni uman kayo aya iyaren mino. Aya iyan Yosepi ma Isipíké Kin Fero má ma vaya siyákan Tiyarafenu véin kama afova amiyan kin mano véin nan moéken anunu uren mai van mi kin mano véin maman kamaniní urákan Isipí dafíaren ben amáká dafisen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Dafikaréin ínaimpáké Isipi vá Kenani vái varafin kákan anan eríkan kákan uman baren tetin tináuyan mano arafan nan ída kanaíen dunan doseren en mino. ");
INSERT INTO agd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mai umampin ban maen Yekopu iníkan Isipí dunan ban ne siyain baya iniren tetin tináuyan tiantan ída aravin táké araíen araven mino. ");
INSERT INTO agd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Aravukharen ma evaránen kan dádasí en Isipi aravíkan mairái Yosepi veyan maman páman en be afá aváeyan tiamemí, ‘Téi Yosepi uno,’ ma siyain baya ínaimpá kin mano afová en be antun mi varéin mino sen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mai oyampáké Yosepi ma siantan be afóe Yekopun má bei kéká minó ma o aviren erein mai seventi-faipi (75) nanin banta ino. ");
INSERT INTO agd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yekopu ma Isipi orun baren ínaimpáké béi fúbin inká setin tináuyan má dere furen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Púbíkan ínaimpáké mai kéká daiyó en evaránen Sekemú barufá ma fefá Abaraamu ano manáa monípó Amorin akhafana finte miyaní ukhá ein barafin ma varé ein masípin mo masíen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Kokhon orana orivin maen Tiyarafenu ano ma fefá Abaraamun tiamen éin avu onté uno ma sikhá ein damú ádesí iyákan Isareri nanin banta ma Isipí baré ein mano mo ampan kauren kokhoníen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Máan tiyákan Yosepin ída afová ukhein banta ano Isipii kiníen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mai kin mano setisi kéká bá tináuyan má máká maáká en namu uantáden aase ma kaúdan iyampon arará kayo vá arin purino siren betin duvunin baren mo karúden mino. ");
INSERT INTO agd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Maí damú ana Mosesin ma ve anóe ano kaúden onan Tiyarafenui avorá avorú iyampon baimpin be anóe afóe ano kanú manaú biyontá mápin aúpá dafisiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Dafisiyaren béin ma avían barufá kaúdan maen kin araun mano véin aviren mo ve akhasí uran baren mino. ");
INSERT INTO agd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Báken maen Mosesi ano Isipi kayoi kama afova variyáken e anoníen baya vantaí iyan ákona yoraríen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Máan ten oriyan ma Mosesi e anoníen foti (40) oranaí ma iyáken mairá be afá aváeyan Isareri kéká o onano van en mino. ");
INSERT INTO agd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ineine uren oriyan o onákan mana Isipi vanta ano Isareri vanta aruren namu uantiyá íkan mai anonafá mai vanta mo ayaen Isipi vanta aruádan puren mino. ");
INSERT INTO agd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosesi ma inikhá ein Tiyarafenu anon tiantan tetin me siya iyan mino sen bei kéká ano ovaren me ininten mino sen mifo vetí ída afová ukharen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Máan turákaren ena ákurá Mosesi oriyan o onákan Isareri vantá kan mano aruviyaréin béi mo yódá iyáken temí, ‘Tire anavasan mompo fará tirékan aruvianta fono.’ ");
INSERT INTO agd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Máa síkan mifo mai aruvin ma araí uren ena vanta vá aruviyá ein banta ano Mosesin do ékiyáken máa semí, ‘Iye ano éin nan ánon bantaí ukheya setin daimono sikhaya fono. ");
INSERT INTO agd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Éi ma inuran ma mana Isipi vanta ma aruan pureonaí eyá téin tiruan purono vara fono.’ ");
INSERT INTO agd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Máa síkan mairá Mosesi mai vaya iniren me onen karan Midianí barafá o soya vanta an dakhen baren maifá anasi mamáken kankanan afon iyampon kaen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kaúden baréin foti (40) orana esantari íkan banta i van kámá barafá Sainaí anuyon ádé o varé íkan mana enisori ano ira khiyain daa finté uaren Mosesi vaintá dákó en mino. ");
INSERT INTO agd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mai ira ma khiyan Mosesi ódaren kokhon ineine iyáken mai ma yákó iyain daná onano van ádé oriven iníkan Bafan amen avaya ano máa semí, ");
INSERT INTO agd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Téi en afóeyan ma vain Abaraamu Aisaki Yekopuni Ayarafenu uno,’ ma síkan Mosesin akhokhofen avinantan diyaimpin ída mo onen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Máan tiyaimpin Bafan mano véin tiamemí, ‘Mai ma éi mantakhaona vara mai kantasí ukhein bara yontá ifo ei arantan anamun ná do ayufono. ");
INSERT INTO agd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Intéa uman ná tenti vanasi ma Isipí bain amaniná kaiyan nafi inka séi ódaré vetíi ifí inéi mai umanpinte utúantano siréi eré umpo varéa erikhesirá éin tiantéku evaránen Isipisá orono.’ ");
INSERT INTO agd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mai ma vetí ankan Mosesi nan tiyáken, ‘Iye anó éi nan tetintasá dafisiyáke vá daimono sirákaya fono’ siren ma veni vaya ída inen do ékein mai Tiyarafenu anon daa ana ma ira khiyain pinté béin nan ore vá betíi yafisiní ukhe mai uman pinte utúde vá avirano siren tiantein mino. ");
INSERT INTO agd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mosesi ano Isipíke yo iyanen oriyáken maen Isipi varafin má Nare Non má inká foti (40) oranará banta i van kámá barafá bái enará ukhein ákona vá aní danasinta vá uvaren dararen ukharen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Mai Mosesi anon Isarerin nanin banta máa sen tiamikharen mino. ‘Tiyarafenu ano sen ma erunaí ukhein mana sakhanampa vanta eni vanasi aúbanáke siantékun orinten mino,’ sen tiamikharen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“Béi anon banta ída van kámá barafá banasi iyukhein aúbaná tetin tifóeyan má báken Sainaí anuyompin óden enisori vá un bákan Tiyarafenui aun bain baya siamikharéin taréa setimpin e van mino. ");
INSERT INTO agd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Tiamíkan mifo setin tináuyan mano veni vaya átakharé en oyan amiren betin ma iniyá ein pura sen evaránen Isipí orono van mi inikharen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mai kéká ano Eronin tiamemí, ‘Mai ma Isipíke setin tiviren erein Mosesin amaniná nái yanasá dákó ukhen nafi seti ída afová ukhétifé umpo éi ena ayarafenu kayo uvádesin ná tetin tufá oriyan aa aníen tiviren orintisá orono.’ ");
INSERT INTO agd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Máa siren maí damú anan arará burumakaó aman manon uváden betiyantá ma ayampóké uvarein danáká íkun uan amiyan amusin en maináká monosí uanten mino. ");
INSERT INTO agd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Máan tiyaimpin Tiyarafenu ano vetí ankan me oyan amiran maen ayontá ma vain danasintará betí araíen monó tianten mino. Máan ma ein manon sakhanampa vanta kéká ano ma vompon uvamádan baré einíen mino. “‘Isareri nanin banta kayo oe, foti (40) oranará ma vanta ída van kámá barafá ma váke íkun uan amiyá eona yanasinta mai séin ná bare me susu sisintiyare rafono. ");
INSERT INTO agd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mai ma yavaráe fóké ma uvaran namun ma kampun ayarafenu Moreki nina ma vare nóke ma inká tiretí ayampó ma uvaran kampun ayarafenu Refanini ofun amantá ma monosí uantiyaóna mai van mi séi siretin tiantéku mae Babironí esante enai varafá o soya ma vainí ukhe van nono.’ ");
INSERT INTO agd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Tiyarafenu ano ma Mosesin tiamíden béin aníin onein mai avúaváká ten mi yavaráe fóké Tiyarafenui má uváden maifin Tiyarafenu ano vetin má manafin ban baya kaúdan mi setin tináuyan mano vanta ída van kámá barafá baren noren mino. ");
INSERT INTO agd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mai ma yavaráe fóké uvaran namun ma setin tifóeyan amin mamaren maen mai vá baren Yosua má enai vara varano siren oríkan Tiyarafenu ano vetin avorá mai kéká aren tain orivin mai namun mo khain mai varafá para van oriyan Devitini yamú mo kanaíen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tiyarafenu ano Devitin kama uantan béi amusin uaren Yekopuni Ayarafenu ma van nain namun uvarano siren béin inaúan inen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Máa sen inaen mifo Soromoni anoi véin amá uvaren mino. ");
INSERT INTO agd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Máan ten mifo vanta fóké ma uvaran namumpin Dan Bain Tiyarafenu ano ída vákan sakhanampa vanta ano sikhen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Bafan mano siyáken inarufái senti kini kumanin kará bákan bararái se sirantan kain baru van mifo siretí inté ukhein namun ná tentina uvarantó iyákeyá inká intefasá tenti sivíkan baru vanten nafino. ");
INSERT INTO agd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Téin tiyan mano mai ídá minó danasinta uvante rafuno.’ ");
INSERT INTO agd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Tiretí ankan monó baya átakharéin nanin banta ma vainí ukheya ída vaya iniyáke Tiyarafenun ída ará amiya ono. Tiretí afóeyan ma iyaré einí eya minó damú Kantá Aunan mano ma siamiyain baya átakharé iya ono. ");
INSERT INTO agd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Intéa sakhanampa vantá tiretí afóeyan mano fefá betin amaniná ídá uman amikharen nafino. Mai ma Funtákein Avúavá Baran Banta erinten ne sen tian dákó iyaré ein banta kéká inan aruan púkaré íkan mai vanta ma yákói mae saréa siretí anon avían namuro ayampin amen nan béin aruan puren mino. ");
INSERT INTO agd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tireti anan Tiyarafenui man baya enisori kayo finte vareona ifo mai ánain ída yakhafe ono.” ");
INSERT INTO agd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Máa síkan mai yafisin banta kayoi ánon banta kéká ano Stivenini vaya ma iniren maen béin nan aranan iyáken avayanan uanten mino. ");
INSERT INTO agd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Máan uantiyákan Kantá Aunan mano Stivenin aúpin bíkavin inarufá mun onan Tiyarafenui kakhan má Yisasi véin ayan kurompá mantakharen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Mantakhan béi máa semí, “Inaru ona yiví téi oniyá umpo onano. Vanta Anin mano Tiyarafenui ayan kurompá mantakhen mino.” ");
INSERT INTO agd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Máa siyain má betíi atarentá iyáden avádóden bádiyáken Stiveni vaintá tavaen oren mino. ");
INSERT INTO agd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Oren béin e yarifen kákan baru akhempá morun kaúden araíen onámanápó ankamiyáken mai ma esé araíen béin au finté ma iyá ein kéká ano vetíi ayá buí dana ayúariyan Sorin ne sin pumara arantampin kaen mino. ");
INSERT INTO agd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Stivenin ma onámanápó ankamiyan maen béi máa sen amúkemí, “Bafan Yisasi oe, séin taunan barano.” ");
INSERT INTO agd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Máa siren aron kan daféden oovariyáken temí, “Bafan noe, vetí ankani ume vá ampiantano.” Máa siren aun ma vareiníen puren mino. ");
INSERT INTO agd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sorin avorái Stivenin ma arin puriyan óden kana ino sen mino. Stivenin ma aruan purein táké araí uren mumunan nanin banta namu uanten inká monó ma siyain kayo ma Yerusaremí baré ein máden asuse iyaimpin monó nanin banta kayo me onen karan oreraen Yudiá barafa safi inka Sameriá barafa safi oriyákan aposeri kayo ano Yerusaremí pa varen mino. ");
INSERT INTO agd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tiyarafenu oo yaiyin banta kayo ano Stivenin daiyen mo masí uren kákantá kuníen mino. ");
INSERT INTO agd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Máan ten mifo Sori ano monó nanin banta máden asuse iyáken mápin peren kuven iyan banta vá anasi vá do yarifen karavusifin mo khaen mino. ");
INSERT INTO agd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Máan tiyan ma karan orera ein kéká ano mai ma karan oreípá mo monó baya siamen mino. ");
INSERT INTO agd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Máan tiyákan Sameriá akhempá mana varurá Firipi mo Tiyarafenu ano ma aní ukhein bantai vaya vanasi siamen mino. ");
INSERT INTO agd_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tiamiyákan kokhon nanin banta ano Firipin avaya iniyáken inká be ma enará ukhein avúavá ma yákó iyain oniyan maen ádé oriven kamaen inen mino. ");
INSERT INTO agd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Iniyákan Firipi ano kokhon namu aunan ma varé ein nanin banta aú pinte yo siantiyákan mai namu aunan kayo ano vádiyan orera iyan inká ai ayan ma fúkein kayofi arantan ma namu ukhein kayofi ayofiyákan banasi ano onen mino. ");
INSERT INTO agd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Máan tiyákan mai van mai varufin kákan amusin en mino. ");
INSERT INTO agd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Máan tiyan Saimonin ne sin mana uvátakhan banta mai varurá bákan Sameriá akhempá ma varé ein nanin banta ano véin nan takha iyan maen béi siyáken, “Téi kákan banta uno,” siyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Máa siyan minó ona vain má ída ona vain má ano veni vaya iniren béin amo siyan temí, “Moéken enarasí ukhein ákona e ma siyain ma vantafin ban mino.” ");
INSERT INTO agd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Máan tiyan pefái veni uvátakhan nan takhaen eriyaren mai van béin ánain mana yakhafen mino. ");
INSERT INTO agd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Máan tiyaréin ma Firipi ano Tiyarafenui kama yafisin baya vá inka Yisas Karaisin aví bá ma siamin iniyáken mai vayará mumunan uren minó nanin banta ano non baren mino. ");
INSERT INTO agd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Máan tiyan Saimoni veyan má mumunan uren monó non péden Firipin dakhafen nóken enará ukhein ákona vá aní daná bá ma uvariyarin oniyáken takhaen mino. ");
INSERT INTO agd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Máan tiyákan baya varen orin banta kayo ma Yerusaremí ma varé ein mano iníkan Sameriá barafá ma vain nanin banta ano inka Tiyarafenui vaya iniren mumunan iyané siyaimpin Pita nú Yonin nú tiantan maifá oren mino. ");
INSERT INTO agd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Békanan Sameriá ma orivin maen mai kéká ano Kantá Aunan barano van Tiyarafenu vaípá amúken mino. ");
INSERT INTO agd_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Para va ino Bafan Yisasin avíká anan monó non péden mana ano ída Kantá Aunan mantaréin mino. ");
INSERT INTO agd_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Máan turen Pita nú Yonin nú ano vetin ánontá ayan kaíkan Kantá Aunan baren mino. ");
INSERT INTO agd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Aposeri kan mano ma ayan ánontá kain Kantá Aunan bariyain Saimoni ódaren moní baren betin me amiyan temí, “Téin dere mai ákona simikhesirá tiyan ma ánontá kaonuna nanin banta ano kanaíen Kantá Aunan barano.” ");
INSERT INTO agd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Máa síkan Pita ano Saimonin tiamemí, “Ei moní bá en masá purase o aiyorano. Para vara seyo, Tiyarafenu ano ma vei sarisarifó para amiyain ákona monípó miyaní onté unon te ine ono. ");
INSERT INTO agd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tiyarafenui yorampin eni afokhan ída vanten mino. Para vara seyo, ven avorá en ará ída funtáken mino. ");
INSERT INTO agd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Máan tukhen mifo ará baéde Bafan Tiyarafenurá amúkesin ná e aúpin ma namu avúavá inin ma ineona ume vá ampiantano. ");
INSERT INTO agd_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Téi farava máa siya rauno. Éin ma oniyaruna Tiyarafenui ákona varano van moéke anunu e nan mai ano éin avíáda umei unampin báe ono.” ");
INSERT INTO agd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Máa síkan Saimoni evaránen békanan tiamemí, “Bafan baípasá amúkusintesin ná mai ma sen timaniná dákó ino seona yaná ída vá dákó ino.” ");
INSERT INTO agd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita nú Yonin nú ano ma Bafani vaya siamiyáken beni ana vaya maman dákó uren Yerusaremí evaránen oriyáken Sameriá akhempá ma vain baru kayo fimpá kama vaya e siamen oren mino. ");
INSERT INTO agd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Maí damú Bafani enisori ano Firipin máa sen tiamemí, “E mante sautí aravuve vá mai ma Yerusaremíké kámá barafá aravuaren ma Khasá oriyain aintá o muntave vá aravono.” ");
INSERT INTO agd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Máa síkan Firipi e manten mai aasá araviyaren mana Itiopiá bara fáke kákan banta vá o fóken mino. Béi maen Kandasin ne sin Itiopia kayoi kuinini moníká dafíkein doran banta váken Yerusaremí monóká erikharen bei karisifin kumamen evaránen bei varufá oriyáken mana sakhanampa vanta Aisaiyani vompon dóki finte yankafen oren mino. ");
INSERT INTO agd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mai vompon onen oriyákan Kantá Aunan mano Firipin tiamemí, “Mesan karisi vaintá oriveya mai ádé orono.” ");
INSERT INTO agd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Máa síkan Firipi savaen mai karisi ádé oriven iníkan mai vanta ano sakhanampa vanta Aisaiyani vompon dóki finte yankafiyaréin béin máa sen inaemí, “Mai ma yankafiyaona vomponi ana afová ukhe fono.” ");
INSERT INTO agd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Máa sen ina íkan mai vanta ano semí, “Ída ma mana vanta ano sisimintí intesá erá téi mai vayai ana afová onte rafuno.” Máa siren mai vanta ano Firipin aran mai karisifin ben má un kumanen mino. ");
INSERT INTO agd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mai ma kuinin ayain banta ano ma yankafiyá ein bompon mano máa mi sikhen mino, “Mana sipisipi arono van aviren oren ma inká ayo yo khaono van aviren oren íkan ma ída vádeiní en be oo fáken mino. ");
INSERT INTO agd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Béin maman bara ana kanti ana uren ída funtákein kó tiantáden ma vara ráke ven aunan do manteini ana akhá i vain pasen banasi ano ída o araren tinten mino.” ");
INSERT INTO agd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mai vompon ma yankáden mai vanta ano Firipin inaemí, “Tisimeno, mai sakhanampa vanta ano ma sikhein beyan nará tikhen nafi áa ena vanta vará tikhen nafino.” ");
INSERT INTO agd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Máa sen ina íkan mai ma yankafein baya ana Firipi araíen tian dákó iyan inká kama vaya ma Yisasin nan tikhein nan tiamen mino. ");
INSERT INTO agd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Békanan mai vaya e sen oriyan baren manáa non baintá oriven mai vanta ano siyáken, “Onano masi non eraviyan mifo fara vará téi ída monó non perante rafuno.” ");
INSERT INTO agd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Máa siren mai vanta ano síkan mai ma oriyarein karisi ma fákaran Firipi má mai vanta vá nompin aravuven Firipi ano mai vanta monó non péanten mino. ");
INSERT INTO agd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Péantáden békanan non me ampiren aifá édákan Bafani Kantá Aunan mano Firipin do aviren enafá orivin ída véin onen mifo mai vanta ano amusin en bei varufá oren mino. ");
INSERT INTO agd_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Firipi maen intesá eipáke safi Asotusí barufin o afoká uven mai ráké araíen Yisasini kama vaya minó baru kayofin e siamen oriyan baren Sisariá e unen mino. ");
INSERT INTO agd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Maí damú ana Sori ano Bafani eyo iyampon kayo aruan purono van pa sinko sen oriyáken ");
INSERT INTO agd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Damaskasí monó átaru namun kayofin mai intéa nanin banta anó Aa Ma Yakhafin Kéká banafi mai vetin páken Yerusaremí karavusifin mo kaono van Sori ano Damaskasí monó ánon banta kayoi ánon banta mo inaen mino. ");
INSERT INTO agd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ina íkan eyo sin Sori oriyan baren Damaskasí áde oriyain má inaru fáké kakhan mano manádá béin panu sen eúkuáden mino. ");
INSERT INTO agd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Máan tiyain má Sori varará eraven ankamen iníkan mana oo va ano máa sen tiamemí, “Sori oe, Sori oe, nái ana vará tein namuroí usintiya fono.” ");
INSERT INTO agd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Máa síkan Sori inaemí, “Bafan noe, éi iye fono,” síkan béi evaránen temí, “Mai ma séin namuroí iyaona mai séi Yisasi uno. ");
INSERT INTO agd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Máan tiya ompo éi mantave kákan barufin ódesin maen inte yanasá barante fo mai mana vanta anon tiaminten mino.” ");
INSERT INTO agd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Máa sin maen Sorin má ma oriyaré ein banta kéká ano vaya ída sinton mairá mantakhen mai vaya inen mifo mana vanta ída onen mino. ");
INSERT INTO agd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Máa siran Sori varará bakharen orun mantaaren auu máben onákan auu sítípa ukhen ída mana yaná onarí iyaimpin ben má ma orikhá ein kéká ano ayan noren Damaskasí barufin óden mino. ");
INSERT INTO agd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Moran maen kanú manaú damúi Sorin auu yufúkuvin báken mana yunan nafi non nafi ída niyan mino. ");
INSERT INTO agd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskasí barufin maen mana Ananiasin ne sin eyo iyampon baré íkan Bafan mano auu véden béin ariyan temí, “Ananaiasi oe,” síkan béi evaránen temí, “Boe, Bafan noe,” ");
INSERT INTO agd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","síkan Bafan mano véin tiamemí, “Sori maen taréa sentá amúkiyan ban mifo vá Puntákein Aasá oriare Yudasin amá orive Tasusíke vanta Sorin nan muno se vá ina ono. ");
INSERT INTO agd_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Béin auu vaédan Ananiasin ne sin banta ano véin ánontá ayan mo kaíkan béin auu evaránen kama iyan onen mino.” ");
INSERT INTO agd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Máa síkan Ananiasi evaránen Bafan tiamemí, “Bafan noe, Yerusaremí ma eni mumunan nanin banta vain amaniná ma mai vanta ano ída funtákein avúavasí ma iyain nan kokhon manon ten orera iyá inikhé uno. ");
INSERT INTO agd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Máan tiyáken monó ánon banta vaípákena eyo sin ákona vompon amin mamaren entá ma monó tiyain kéká minó karavusi fákano van mará erikhen mino.” ");
INSERT INTO agd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Máa síkan Bafan mano siamemí, “Ena anan kéká bá betíi kin kayo vá inká Isareri nanin banta vápin tenti monó baya varen orino van béin inka aní ukhé umpo vá orono. ");
INSERT INTO agd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Téin tínain ma vákurin naintá béi intesá ená uman baranten nafi mai véin aní onté uno.” ");
INSERT INTO agd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Máa siran Ananiasi orein mano mai namumpin ódiven Sorin ánontá mun ayan kaiyan temí, “Tifá tiváe Sori oe, mafá ereno van eriyáe nan ma ayanafá dákói ma oneona vanta, Bafan Yisasi ano éin nan evaránen auu mábé onesin Kantá Aunan mano éimpin bíkano van mi séin tisintá eré uno.” ");
INSERT INTO agd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Máa siyain má anan Sorin auufenté ataro ma yo siven eraveiní íkan evaránen auu máben oniyáken e manten monó non peren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Péden manáa yunan naren bei ákona evaránen mamaren Damaskasí ma varé ein eyo iyampon kayo vá manáa yamú baren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ákona mamaren esé ana e manten Yutan kayoi monó átaru namun kayofin oriven Yisasi Tiyarafenu Anin mino sen araíen monó baya siamen mino. ");
INSERT INTO agd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Máa síkan beni vaya ma inein nanin banta minó ano anúden orera iyan máa sen inaemí, “Mai ma Yerusaremí ma Yisasini eyo iyampon kayo aruan puriyan karavusi fakaádaren ma inká maráke kayo vá dere karavusi fáke monó ánon banta kayoi monó ánon kéká baípá orono van ma erein banta fino.” ");
INSERT INTO agd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Máa siyan Sorini monó baya ano moéken ákona íkan Damaskasí ma varé ein Yutan kayo ano Yisasin nan Tiyarafenu ano ma aní ukhein banta ino sen afová uren akhokho van ída evaránen béin má manáa vaya sen mino. ");
INSERT INTO agd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Máa sen kokhon damú oriyan maen manáa Yutan kayo ano Sorin aruan purono van aúpáké baya sian damuáden mino. ");
INSERT INTO agd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Máa siren mai Yutan kayo ano Sorin aruan purono van mai varui yafu ona kayo ma vaintá ena ena vayan má inuran má dafían ákona iyain baya Sori inen mino. ");
INSERT INTO agd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Máan tiyákan ben ma vákuren noré ein kayo ano inuran pinté Sorin do aviren mo basketifin dan kumamin mairá anan damuren kafi ain pinté dan aravuaren me onen oren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Oren ma Yerusaremí oriven Yisasini eyo iyampon kayo vá o asotú uvé dorano van íkan betí ankan béin nan ída fura sen eyo iyamponí ukhen mino sen anomé iniyáken béin nan peren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Máan tiyaimpin Banabasi ano Sorin aviren baya varen orin banta kayo vaintá moren Sori inté ená ayanafá oriyaren Bafan onaná béin baya siamídan inká béi inté ená Damaskasí barufin Yisasin aví ída feranton ná tian dákó ena fi, mai fákena vetin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tiamídan Sori vetí ankan má báken Yerusaremí ída feranton Bafan avíká kasaen nóken banasi monó baya siamiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tiamen nókan Kiriki vaya ma siyain Yutan kayo ano véi má baya fóké asive asive iyáken mai kéká ano véin aruan purin aa van dosiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Máa siyain baya ma monópin bain afá aváeyan mano iniyáken béin do aviren Sisariá morúden tiantan Tasusí oren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Orivin mumunan nanin banta ma Yudia safi Karirifa safi inká Sameriá akhempa safi ma varé ein kéká Kantá Aunan mano mumunan ákona uantan kokhon mano vetimpin o asotú íkan amusin pinté kusen báken Bafan nan péan amiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ma minó akhempá doren noren maen Ridá barurá ma mumunan nanin banta vain onano van oren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","O varen mai varu finte Ainiasin ne sin banta onákan dan manápá ifo kanú manaú oranará ai ayan púkan kúkútafin mana vakhen baren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Baréin Pita véin tiamemí, “Ainiasi oe, Tiyarafenu ano ma aní ukhein banta ano ayofen mifo mantave yuvasí dádá ono.” Máa siyain má ana Ainiasi orun manten mino. ");
INSERT INTO agd_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Máan tíkan Ridá barurá ma varé ein nanin banta vá Seroní puntákein avafin ma varé ein nanin banta vá ano mai vanta amininá ma yákó ein daná ódaren betí ará baéden Bafan baípá eren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Máan tiyákan mana mumunan nanin Tabitan ne sin nan ma Kiriki vaya finté Dokasi ne siyain nanin mano Yopá barurá báken minó damú béi kama avúavá ana variyáken ona ma i van nanin banta aya iyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Aya iyaren aí baren púbíkan non péantáden dan bain karafarampin mun asédan baren mino. ");
INSERT INTO agd_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ridá baru maen Yopá baru ádé baré íkan eyo iyampon kayo ano inin Pitan nan Ridá barurá ban ne siyaimpin kan banta siantan béi vaípá onóben temí, “Aine setí ma varuna varufá tare ana orono van muno,” siren tútúpen mino. ");
INSERT INTO agd_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Máa síkan Pita maí kan má oren onóbin do aviren dan bain karafarampin ódíkan minó baré nanin kayo ano véi vaintá e iyen eúkuven ifídiyáken Dokasi ma vetin má para váken amu uariyan amiyaré ein iyon afuin má ona vá Pitan aníen mino. ");
INSERT INTO agd_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Máan turan Pita ano minó nanin banta siantan barará karafarampin aravuvíkan aronkan durafúden amúkuren mai ma fúkein nanin baípá do vaében temí, “Tabita oe, orun mantano,” síkan mai nanin auu máben Pitan me oniyan orun mantaan kumanen mino. ");
INSERT INTO agd_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kumamin Pita ano mai nanin ayan pákaren ayain mantavíkan mairá mumunan nanin banta kayo vá baré nanin kayo vá aran édákan mai ma fúká ein nanin ayun para van aní in onen amen mino. ");
INSERT INTO agd_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mai ma yákó ein baya ano Yopá barufin orera íkan iniren kokhon nanin banta ano Bafantá mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Máan turen burumakaó aufó ma minó daná uvariyain banta Saimoni má Pita manáa yamú baren mino. ");
INSERT INTO agd_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisariá barurá mana Koniriasin ne sin banta váken Itaríke aruvin banta kéká ino ma siyain pintena mana antareti (100) aruvin banta kayorá dafisiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Dafíken báken be má minó be antun má Tiyarafenun aránaó báken bentá mumunan iyan maen Yutan kayofin ma ona i vain nanin banta aya iyáken minó damú Tiyarafenu vaípá amúkiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Máan tiyaren mana inúpáké kanaú manaú áauí iyan béi onákan Tiyarafenui enisori ano yákó ma ereiní uaren “Koniriasi oe,” sen me aren mino. ");
INSERT INTO agd_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Arákan Koniriasi akhokho van mo furefure en oniyáken “Bafan noe, nái fino,” sen béin ina íkan enisori ano evaránen tiamemí, “Éi ma amúkiyaóna vá inká ona ma i vain nanin banta ma aya iyaóna avúava san Tiyarafenu ano anunu iyáken amusin uantiyan mino. ");
INSERT INTO agd_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Máan tukhen mifo saréa ana manáa vanta kayo siantesin Yopá barurá oren Saimonin ne sin banta van ma Pitan ne sen ariyain banta mo yosiren aviren ná erino. ");
INSERT INTO agd_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mai vanta maen ena Saimonin ne sin banta ven amá un non akhempá bákan burumakaó au fóké ma manáa yaná uvaré iyain mai vanta vái véi van mino.” ");
INSERT INTO agd_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Máa siren mai ma véin tiamein enisori ma orivíkan Koniriasi vei yoran bantá kanan má mana aruvin banta veyan dere Tiyarafenu ma anunu ukhein avúavá ana ma vákuriyain banta vá aren mino. ");
INSERT INTO agd_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Aran eríkan mai ma afoká ein danasinta van tiamíden mai kanú manaú tiantan Yopá barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Oren ayanafá e vakharen ena ákurá Yopá baru ádé oríkan mo vayaní iyan maen Pita amúkono van má daró óden mino. ");
INSERT INTO agd_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pitan arafan puriyákan dunan nano van iyan para yunan taren tasu sasu ein pinté béin auu vaédan maen ");
INSERT INTO agd_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","inaru ona yivin mai finté davaráeren daná minó kamí kamí akhen pákaaren dan barará eren mino. ");
INSERT INTO agd_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Maifin ara ara osafáe kayo vá ayon pinte nun kayo vá inká ara ara safúna kayo vá bíkakharen mino. ");
INSERT INTO agd_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Máan tukhan Pita iníkan mana vaya ano siyáken, “Pita oe, mantave ma safúnan kayo arure nano,” sen béin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Máa síkan Pita evaránen tiamemí, “Éin avorá ída avusese en ída funtákein dunan báká ída nakherúnan bantí Bafan noe, ída séi nanté uno.” ");
INSERT INTO agd_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Máa síkan mai vaya ano evaránen kan dádasí en béin tiamemí, “Téi Ayarafenu ano ma maman avusese uranuna yana san i vá teya fainí ukhen mino seno.” ");
INSERT INTO agd_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mai ma sein baya ana kanú manaú dádasí en tiamíden ainen evaránen mai yavaráe varen inarufá óden mino. ");
INSERT INTO agd_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Máan turan mai ma auu vaédan onein danasinta van inté ukhen nafino sire Pita kokhon ineine iyan bákan mai ma Koniriasi siantan Sisariáké erein kanú manaú banta ano Saimonin ama san o inaen eriyan baren dafu onará e manten mino. ");
INSERT INTO agd_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","E mantaven maen oovaraáden inaemí, “Saimonin nan ma Pitan ne siyain banta ma namumpin ná báé iyan nafino.” ");
INSERT INTO agd_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Máa sen ina iyákan mai ma auu vaédan ma onein danasinta van Pita fa ineine iyan maen Kantá Aunan mano véin tiamemí, “Saimoni oe, kanú manaú banta ano en nan dosen e van mino. ");
INSERT INTO agd_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dosiyan mifo ída vá kokhon ineine iyáke vá téi anon betin tiantékun erikhen mifo aravuve vá betin masá orono.” ");
INSERT INTO agd_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Máa síkan Pita aravein mano mai vanta kanú manaú morun tiamemí, “Tiretí ankan ten nan mi yosia ompo fará ere fono.” ");
INSERT INTO agd_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Máa sen ina íkan mai máa kanú manaú banta ano evaránen temí, “Mana antareti (100) aruvin banta kayorá ma yafíkein Koniriasin ne sin banta maen Tiyarafenu van péden béin avorá puntáken bákan Yutan nanin banta kayo ano véin nan kama vanta ino siyain bákan kantasí ukhein enisori ano éin nan o aviren erinti vá éi ma siaminona vaya vá inino siren béin tiamídan tetin tisintái éin avirano van mi eré tiféuno.” ");
INSERT INTO agd_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Máa síkan Pita mai vanta kanú manaú e araádan be ma varé ein namumpin óden mino. Un bakharen ena ákurá Pita mai kayo vá oríkan Yopá baru ráké manáa monópin bain afá aváeyan mano vetin má oren mino. ");
INSERT INTO agd_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Orein ayanafá e vakharen ená damú Sisariá oriyan maen Koniriasi o varen me afová iyan máan ten betin nan erinten mino siren bei kama arona kayo vá be antun má o iyanuádaren betin má manafin átaru ukhen ave iyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Átaru ukharéin Pita ma mápin ódiyain má Koniriasi oniyáken aufá mo aron kan daféden béin monosí uanten mino. ");
INSERT INTO agd_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Máan tíkan Pita ano véin orun ayanoá diyáken, “Mantano séi éi ma eonaí é ma varará banta uno,” sen béin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Máan turen Pita mairá be má e vaya sikhan mápin ódiyan un onákan kokhon nanin banta e átaru ukharen mino. ");
INSERT INTO agd_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Átaru ukharéin Pita mai nanin banta siamemí, “Tiretí afová ukhen nan tetisi man baya ano siyáken Yutan kayo ano ena anan banta vá ída vá manafin báke ída vá betí baintá orono sikhen mifo Tiyarafenu ano siyáken ída vá mana vanta van ída funtákeona váke ída sesé ukhaona ono se vá tiameno sen téin aní uren tisimen mino. ");
INSERT INTO agd_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mai ana van mi éi ma vanta kayo sianten nan oríká ída áao sin éin oo yaiyé ereruna van mi éin inaiyá umpo nái vará téin tare fono.” ");
INSERT INTO agd_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Máa sen ina íkan Koniriasi evaránen tiamemí, “Kamí kamí damú oriyan mifo kanú manaú áauíen inúpasí iyáká te simápin timúkiyá baréékun manádá mana vanta ano vei auí daná kaké panu sivin ten tufá e manten mino. ");
INSERT INTO agd_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","E mantaven mai vanta ano máa semí, ‘Koniriasi oe, éi ma kama avúavasí eya ona ma i vain nanin banta ma aya iyaona van Tiyarafenu ano amusin uren inka eni amúkin inen mino. ");
INSERT INTO agd_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Máan tukhen mifo Saimonin nan ma Pita ne sen ariyain banta ano vurumakaó au fóké ma manáa yaná uvariyain Saimonin ne sin banta amá ma un non akhempá baimpin ban mifo manáa vanta siantan ná Yopáké o avirano.’ ");
INSERT INTO agd_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Máa sen tisimein nan mi éin ainen o avirano van banta siantékun oríka kama avúavasí eya ere ompo intéa vayá tetin tisimeno van Bafan mano siamí inikharé intefo sare ana minó ano inintó bá tifé umpo Tiyarafenu avorá tisimí inétifano.” ");
INSERT INTO agd_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Máa síkan Pita araíen betí ankan tiamemí, “Tiyarafenu ano minó ara ara nanin bantafin manaí ukhein avúavasíen aya iyái saréa inka séi fura sé afová é uno. ");
INSERT INTO agd_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Máan té iyan mifo minó kéká pinté intéa nanin banta anó ben nan péden ben aránaó báken puntákein avúavá ana variyan nafi mai nanin bantan Tiyarafenu ano aviré iyan mino. ");
INSERT INTO agd_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Máan tukha siretí afová e nan mai kayoi Bafan ma vain Yisasi Tiyarafenu ano ma aní ukhein banta finté uaren kamaen kusen ma van baya Tiyarafenu ano Isareri nanin bantafin dan erakhen mino. ");
INSERT INTO agd_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yoni ano ma monó non péantádan intéa yanasá Karirifá araí uren Yudiá barafá oreraen dákó ukhen nafi mai siretí ankan afová ukha ono. ");
INSERT INTO agd_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nasaretí kena vanta Yisasin Tiyarafenu ano intesá ená bei Kantá Aunan má ákona fóké bá aní uran intesá uren ná Ban Anoni ákona ano yaramádan baré ein nanin banta aya uren ayofen noren nafi mai Tiyarafenu véi má túpá ukhan mino. ");
INSERT INTO agd_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yutan kayoi varafá bá Yerusaremí barufin má ma variyaré ein maen mai minó danasinta setí ódarékun inká béin daa unkamádantá arin púkaréin ");
INSERT INTO agd_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kanú manaú bayan orivin Tiyarafenu ano furin pinte orun avían mantarákan banasi avorá orin onen mino. ");
INSERT INTO agd_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Máan ten mifo minó nanin banta ano va véin onen naino. Mai ma Tiyarafenu ano ma fefá aní ukhá ein kéká ma varé e tifékun ma véi fúkaren e mantaaren dunan nen non nen í ontaréi sian páman iyá tiféuno. ");
INSERT INTO agd_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tiyarafenu ano véin nan mi fa ma ayun bain má púkein nanin banta vái yaimin banta vá bano siren pefá aní uran baren mino se vá pura vaya vanasifin tian amesin ná inino siren tetin ákonaen baya sisimen mino. ");
INSERT INTO agd_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Béintá ma mumunan inain nanin banta van Tiyarafenu ano véin pinté uaren ume kayo ampiantanten mino sen minó sakhanampa vanta kayo ano ven nan pefá o utúben tian amá uran baren mino.” ");
INSERT INTO agd_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita ma Tiyarafenui vaya fara siamiyan bákan maifin ma e átaru ukhen mai vaya ma iniyá ein nanin banta amaniná Kantá Aunan mano eren mino. ");
INSERT INTO agd_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pitan má ma mumunan Yutan kayo ma orikhá ein kéká ano onan ena anan nanin bantafin dere Kantá Aunan banaan amiyaimpin betí anúden oreraen mino. ");
INSERT INTO agd_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Para va ino mai kéká ano ara ara vaya fóké Tiyarafenu aví daní iyan betí ankan iniren mino. Máan tiyaimpin Pita semí, ");
INSERT INTO agd_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Tetí ankan ma Kantá Aunan baré tiferuna avúaváká ten mi ma kéká ano Kantá Aunan baren mifo iye anó kanaíená ma nanin banta ano ma monó non peran nain aa iyarante fono.” ");
INSERT INTO agd_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Máa siren mai nanin banta van Tiyarafenu ano ma aní ukhein banta Yisasin avíkasá monó non perano siran betí ankan monó non péden mai oyampáké manáa yamú betin má bano van Pitan inaen mino. ");
INSERT INTO agd_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ena anan kéká bá ano yere Tiyarafenui vaya iniren mumunan iyan mino síkan Yutan barafá ma vaya varen orin banta kayo vá monópin ma varé ein afá aváeyan má ano inen mino. ");
INSERT INTO agd_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mai vaya iniren baintá Pita ma Yerusaremí unóbíkan au khavin avúavá ma fara fákaren bain mumuman nanin banta ano véin oyampá baya sen asiyáken ");
INSERT INTO agd_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","máa semí, “Ída au khavin banta kéká amái o fébe veti má dunan niya ono.” ");
INSERT INTO agd_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Máa síkan béi vaintá ma afoká ein danasinta van puntáden araíen tian amá en mino. ");
INSERT INTO agd_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Yopá barurá téi simúkiyá baréékun tuu vaédá onékun inaru fáké mana kákan davaráeren daná kamí kamí akhentá pákaaren te vaintá dan eren mino. ");
INSERT INTO agd_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Eriyain má maifin purefure é onékun ayuntáke safúna kayo vá afá tafúna kayo vá ara ara osafáe kayo vá inká ayompin ma noin nun kayo vá baren mino. ");
INSERT INTO agd_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Baré íkan mana vaya ano séin tisimemí, ‘Pita oe, orun mantave mai yanasinta arure vá nano.’ ");
INSERT INTO agd_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Máa siká téi evaráné tiamiyáké, ‘Bafan noe, éin avorá ída funtáken ída avusese ukhein daná baká ída nakherunan bantí téi ída nanté uno.’ ");
INSERT INTO agd_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Máa sékun inaru fáké kan dádasí en temí, ‘Ayarafenu ano ma maman avusese uran bain danasinta van ída vá painí ukhen mino seno.’ ");
INSERT INTO agd_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mai ma sein baya kanú manaú dádasí en tisimíden minó danasinta evaránen darifan inarufá óden mino. ");
INSERT INTO agd_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Máan turan maí damú ana Sisariá baru ráké mana vanta ano kanú manaú banta siantan téin tivirano van eriyan baren te ma varuna namun eren mino. ");
INSERT INTO agd_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Eríkan Kantá Aunan mano séin tisimiyáken, ‘Éi ída vá kokhon ineine iyáke vetí ankan masá orono,’ síkan dan manápá ifo afápá mana un kádan tifá tiváeyan ma monópin bain kéká ano yere se má oríká oriyá baré mai ma siantan erein banta amá ódé uno. ");
INSERT INTO agd_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ódékun béi inté ená mana enisori onan ná ben amápin dákó uven tiamiyáken, ‘Banta siantesin Saimonin nan ma Pitan ne sen ariyain banta vá Yopá baru ráke o avire ereno.’ ");
INSERT INTO agd_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","‘Béi maen manáa vaya varen éin me siamintin mai vaya finté uaren Tiyarafenu ano éin má e antun má evaránen aviranten mino.’ ");
INSERT INTO agd_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Máa sirá téi araí uré baya siyákun esé araíintá ma setimpin Kantá Aunan mano erein avúaváká ten betimpin eraven mino. ");
INSERT INTO agd_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Máan tíkan Bafan mano fefá tiyáken ma Yoni ano nompói vanasi monó non péanten mifo siretí ankan Kantá Aunan pói féantanten mino ma sikhá ein baya ovaré me iné uno. ");
INSERT INTO agd_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pefá ma Tiyarafenu ano ma aní ukhein banta Bafan Yisasintá mumunan ékun ma Tiyarafenu ano Kantá Aunan amusin timikharen mi saréa Tiyarafenu ano manaí amusin mana ena anan kéká amikhen mifo séi iyé barerá Tiyarafenui yoran are onte rafuno.” ");
INSERT INTO agd_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Máa sin ma vetí ankan mai vaya iniren mairá ída ananin baya sen mifo Tiyarafenu aví ana maman daní iyáken temí, “Ena anan banta ano ma ará baeran inan Tiyarafenu ano kanae sein pasen betin má deren para van oriyan ban aunan baranten mino.” ");
INSERT INTO agd_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stivenin ma arin púbin maen Yisasintá ma mumunan ukhá ein kéká namu arirí iyaimpin betí ankan me onen Fonisiá akhempa safi Saipurusí akhempa safi inká Antiokí barura safi karan orera iyáken Yisasini kama vaya Yutan nanin bantafin mana e siamen oren mino. ");
INSERT INTO agd_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Máan tiyákan maen betin aúbaná manáa Saipurusíke vanta kayo vá inká Sairiní baru ráke kéká bá baren Antiokí barurá oriven Kiriki nanin bantafin dere Bafan Yisasini kama vaya fákena vetin tiamen mino. ");
INSERT INTO agd_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tiamiyákan Bafani ákona ano vetí ankampin bákan pasen kokhon ena anan nanin banta ano Bafantá mumunan uren ará baeren béi vaípá eren mino. ");
INSERT INTO agd_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Máan tiyain baya ma Yerusaremí mumunan nanin banta varé ein kayo ano iniren Banabasin tiantan Antiokí oren mino. ");
INSERT INTO agd_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Oren o unaven onákan Tiyarafenu ano ma vetin kama uren tarisari uantiyaré ein ódaren béi amusin iyáken betí aúkáké pura sen Bafan má ana vano van betin ákona uanten mino. ");
INSERT INTO agd_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Béi kama vanta vákan Kantá Aunan mano véimpin bíkakhan maen béi ákona mumunan má báken kokhon nanin banta kayo aya uren Bafan baípá o aviádan eriyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Máan turen Banabasi ano Sorin nan doseno van Tasisí barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Oriyan baren béin mo ódaren o aviren Antiokí meran baren mino. Báken mai orana aúpin Banabasin nú Sorin nú ano mumunan nanin banta kayo vá manafin átaru uviyan kokhon nanin banta kayo Tiyarafenui afova vaya siamiyaren mino. Máan tiyáken eyo iyampon kayo van Karaisini kéka se sen esé araíen Antiokíi aví tein mino. ");
INSERT INTO agd_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Máan tiyain pimpá ana manáa sakhanampa vanta kayo ano Yerusaremí me ampiren Antiokí eren mino. ");
INSERT INTO agd_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Eraven mai kayo finté Akhabusin ne sin sakhanampa vanta ano orun mantaaren Kantá Aunani ákonará máa semí, “Kákan anan dákó intin Romi kamanin mano ma yafíkein bara kayofin arafan nan puren orera inten mino sikháin ma Sisa Kraudiasi ma kiní uven dafisein damú mai yaná dákó en mino. ");
INSERT INTO agd_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Máa síkan iniren Yisasini eyo iyampon kayo ano veyan ma ukheí páké en Yutan barafá ma monópin bain afá aváeyan aya ono van baya sian damuáden mino. ");
INSERT INTO agd_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mai ma sian damuádeiníen betíi amusin moní Banabasin nú Sori nuká kaúden tiantan baren Yerusaremí monó doran banta kayo mo amen mino. ");
INSERT INTO agd_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Máan tiyain pimpá ana Kin Eroti ano manáa mumunan nanin banta kayo aruren namu ono van karavusi fáken mino. ");
INSERT INTO agd_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pákaan kaúden béi ano síkan Yonin aváe Yemisin baenatifó anuran tíkan puren mino. ");
INSERT INTO agd_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Máan turen Eroti onákan Yutan kayo ano mai avúava san amusin iyaimpin Yisi Ída Van Bereti Ma Nan Omá Damú Pitan má dere fáken mino. ");
INSERT INTO agd_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pakaádaren Tiyarafenu ano ma Isareri nanin banta Avo Uantan damú ma esantavintí Pitan avían banasi avorá kaúdé daimonté uno sen iniren Eroti ano Pitan avían dumukatifin kaúden sikistini (16) aruvin banta kayo ayampiní uran kamí kamí ano yafídú iyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pitan ma yumukati namumpin kain ban maen béin Tiyarafenu ano ayaino van monó nanin banta ano ákonaen amúkiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Máan tiyákan Eroti ena ákurá béin daimintéin mai inuran kankanan seni anampó béin damuádan aruvin bantá kan aúbaná bavíkan ena aruvin banta kayo ano yumukati namun onará dafíkaren mino. ");
INSERT INTO agd_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Máan tukharéin Bafani enisori ano maifin manádá áfoká íkan dumukati namumpin panu siyain má enisori ano Pitan ayorantá ankan ankan iyáken béin avoren temí, “Aine mantano,” siyain má Pitan ayan pinte seni anan útufen eraven mino. ");
INSERT INTO agd_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Máan tiyain má enisori ano véin tiamemí, “Ei ona vá arantan anamun má ono,” síkan Pita uran maen enisori ano siamemí, “Ei ayá iyon afuin ureya séin dakhafono.” ");
INSERT INTO agd_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Máa síkan Pita mai karavusi namun me ampiren enisori yakhafen oriyáken enisori ano ma mai avúavá bariyain Pita amino ukhen tuu vaédái oniyá uno sen inikharen mino. ");
INSERT INTO agd_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Máa sen iniyáken esé ma yafíká ein má ínain ma yafíká ein banta vá esanten aravuaren kákan barufin ma oriyain onará oríkan mai ona ano veyantá e yiven oriyain má míkanan mai ona finté e yuvinen oriyan baren mana aasá o muntaven oriyan manáa ayáká orivin mai enisori ano véin me ampiren ainen oren mino. ");
INSERT INTO agd_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Orivíkan mairá Pitan auu sapé tiyain má béi semí, “Taréa inka afova suron ékun Erotin ayan pinten téin tiviren inká Yutan kayo ano ma intéa yanasá ten timaniná kaono van iyaren nafi mai uman kayo finten Bafan manon bei enisori siantan téin tiyaen mino.” ");
INSERT INTO agd_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Máa siren mai yaná ma afová iyáken Yonin nan ma Maki ne sen ariyain banta anóe Marian amápin kokhon nanin banta kayo ano átaru ukhen amúkiyaré íkan mai namun béi oren mino. ");
INSERT INTO agd_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Onóben baru fáke onará béi mo ankan ankan iyan maen iyé e van nafi siren onano van Rodan ne sin doran arinta ano araven mino. ");
INSERT INTO agd_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Araven orun iníkan Pitan amen avaya vaimpin kákan amusin iyáken ída ona yivinton evaránen mun máa semí, “Pita onará e van mino,” sen mai ma iyukhá ein nanin banta siamen mino. ");
INSERT INTO agd_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Máa síkan, “Éi óen ná iya vae” sen mai kayo ano véin tiamiyan mifo véi ákonaen tiyáken, “Téi Pitan amen avayan bá inikhere,” siyaimpin betí ankan tiyáken, “Beni enisori anon tino.” ");
INSERT INTO agd_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Máa siyákan maen Pita onará pa ankan ankan iyan baimpin betí ankan ma morun ona yiren béin oniyan anúden oreraen mino. ");
INSERT INTO agd_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Máan tiyaimpin ída vaya sino van Pita ve ayampó oorá ankan ankan iyáken inté ená Bafan mano karavusi finte útúden béin avían barufá daná eren nafi mai fáke siamíden, “Ma ma yákó ein danasá Yemisi má manáa sifá tiváeyan masá tiameno,” siren betí ankan me ampiren ena varufá oren mino. ");
INSERT INTO agd_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Máan tukharéin ena ákurá aruvin banta kayo ano Pita intefasá orikhen nafi siren akhokho van dosian more mere en mino. ");
INSERT INTO agd_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Máan tiyákan Eroti ma mai vaya iniren Pitan dosíkan ída vaimpin mai ma yafiká ein aruvin banta kayo avían kaúden avóbé en inaúden ma kékasá aresin purino sen mino. Máan turen ínaimpáké Eroti Yudiá me ampiren Sisariá manáa orun baren mino. ");
INSERT INTO agd_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Kin Eroti ano Taiyá baru ráke vá Saidoní baru ráke nanin banta vá anan maran uren betin nan móeken aranan uantiyaren mino. Máan tiyákan mai nanin banta ano véin ma yafíkein bara kayo finte yunan bariyaren pasen kin mano ma kama yoran banta ino siyain banta Barastasi má ará manafiníin baya sian damuaren Kin Erotin onano van oren mino. ");
INSERT INTO agd_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kin Erotin ma onano sikhá ein damú ma yákó íkan béi kin buí daná uren kini karáká kumamin banasi e iyuvin ákona vaya siamen mino. ");
INSERT INTO agd_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Sian míkan mai nanin banta ano oovararen temí, “Ma ma siyain baya ma varará bantai vaya vaino ayarafenui vaya ino.” ");
INSERT INTO agd_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Máa síkan Eroti ano ída Tiyarafenu aví maman daní iyaimpin Bafani enisori ano véin manádá do ankamádan eraviyain má bintokhéna kayo ano véin aú bukhafa nákan puren mino. ");
INSERT INTO agd_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Puren mifo Tiyarafenui vaya ano mo kákaníen minó barufá oreraen mino. ");
INSERT INTO agd_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasin nú Sorin nú ano vetíi monó nanin banta ayain doran dóan kíparen maen Yonin nan ma Maki ne sen ariyain banta avíaren Yerusaremí baru me ampiren evaránen Antiokí oren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokí monó namumpin manáa sakhanampa vaya sin banta kayo vákan ma inká Tiyarafenui vaya ma afova amin banta kayo van ma ukharé ein mai vetin aví maen Banabasi má Saimonin nan ma sókon banta e sen ariyain má Sairiní baru rákena vanta Rusiusin má inká Kin Erotin má ma avunté iyá ein banta Manaenin má Sorin má ino. ");
INSERT INTO agd_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Maná damú monó nanin banta kayo ano yunan auraren amúkiyan Bafantá monó tiyan baréin Kantá Aunan mano vetin máa sen tiamemí, “Tiretí ankan Banabasin nú Sorin nú aníesin ná mai ma varano van arakheruna yorarí ino.” ");
INSERT INTO agd_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Máa síkan betí ankan dunan auraren amúkuren maen mai ma siamein bantá kan ánontá ayan kaúden avu uantáden tiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Máan turan Kantá Aunan mano míkanan tiantan Serusiá barurá aravuven mai ráke sipi evaránen Saiparasí musóká oren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Oriyaren ma Saramisí barurá o unavin maen betin ayain bantan Yon Maki orikharen mi Yutan kayoi monó átaru namun kayofin Tiyarafenui vaya siamen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Saiparasí musóká békanan o váken ma minó akhempá noren maen Pafosí barurá oriyan o onákan Ba-Yisasin ne sin Yutan kayoi kampun sakhanampa vanta váken béi uvatakhan iyan ara ara aufon iyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mai vanta ano kamanini ánon banta Sekius Paurusin ne sin banta vá bákan maen kama ineine vá afova vá bain banta váken Tiyarafenui vaya ineno van Banabasin nú Sorin nú arákan oren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Oríkan mifo mai ma aufon iyáken uvatakhan iyá ein banta Ba-Yisasin aví ma Kiriki vaya finté Erimasi ne sen ariyain banta ano ma inikharé ein Kamanini ánon banta ano Yisasintá mumunan inain nan békanan namuroí uantiyan beni aa iyarano van en mino. ");
INSERT INTO agd_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Inikhan Sori nan ma Pori ne siyain bantafin maen Kantá Aunan mano víkavíkan Erimasin auufen kakháben temí, ");
INSERT INTO agd_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Éi Ban Anon akhái váke minó puntákein avúavá namuroí iyan nan éimpin ara ara mákasin má namu yaná bá bíkakhayai Bafani funtákein avúavá maman kampun bayafin kaiya ompo mai avúavá ídá ifá inte fono. ");
INSERT INTO agd_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tiyarafenui aran naná ano saréa éin auu namu uvintiya áau ída onan manáa ayáká banono,” máa siyain má anan títípa ukhein konan ten daná ano Erimasin auurá iyábíkan béi ma ayan noren oriyan aa aníin banta van mo yose me yose en mino. ");
INSERT INTO agd_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Máan tiyákan Kamanini ánon banta ano mai yaná ódaren mumunan iyákan Bafan nan ma siyain baya ano véin ará manten mino. ");
INSERT INTO agd_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pori má ben ma ayaen doren noré ein kéká bá ano Pafosí baru me ampiren sipi e varen orein mano Pamfiriá barafin bain baru Peká oríkan mairá Yon Maki vetin mo afa uren Yerusaremí evaránen oren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Orivíkan betí ankan Peká me ampiren Pisidiá barafin bain baru Antiokí o varen Sabati yamú Yutan kayoi monó átaru namumpin o kumanen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kumantan monó átaru namuni ánon banta kayo ano man baya vá sakhanampa vanta kayoi vaya vá dankáden manáa vanta siantan Pori má bei mana yoran banta kayo vá mo siamemí, “Tifá tiváeyan noe, siretimpin ma vanasi ákona uantan baya ma vantiya sesin inino.” ");
INSERT INTO agd_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Máa síkan Pori e mantaven betí ankan ída vaya sino van ayan daní uren temí, “Tiretí Isareri nanin banta vá ena anan nanin banta vá ano ma Tiyarafenu aránaópá oriyaona kayo ano vá ineno. ");
INSERT INTO agd_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isareri kayoi Ayarafenu ano setinti sinafu siráon nan be ina e sen aní ukharen betíi vara ma me ampiren Isipí o vákan maen béi ano vetin maman kokhonasí uran baréin bei kákan ákonará betí ankan Isipíke iyanen eren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Eriyáken foti (40) oranará ma kámá barafá Tiyarafenui vaya átakharé iyan ma véin uman amiyákan maen béi yo yuren betintá kamaen dafisiyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Máan tiyáken Tiyarafenu ano Kenaní barafin ma yan manápá ifo afápá kan un kádan anan nanin banta ma varé ein aren taaren betíi vara o maman bei vanasi inaí ino van amen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mai yanasinta ma yákó iyaré ein mai kamí kamí antareti ifo fifti (450) orana aúpin mino. Máan turen mai oyampáké Tiyarafenu ano mai nanin bantará ma yafisin banta kéká aní uren amíkan mai kéká ano vetintá dafisen eriyan sakhanampa vanta Samuerini yamú e khanaíen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Máan tiyain damú anan banasi ano kin nan muno siren inantiyaimpin mi Tiyarafenu ano Benisamenini anan banta finte Kisin anin Sorin aní uran foti (40) oranará kiní ukhen betintá dafíkaren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Dafíkaréin Tiyarafenu ano Sorin doékaren Devitin maman kiní uren béin nan temí, ‘Te súkákéi sinunué Yesin anin Devitin dosiré aní erunan béi anon ten too yaiyen te ma siamenuna yanasinta varanten mino.’ ");
INSERT INTO agd_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Mai vanta anavasin pintéi vanasi ma evaránen aviran banta Yisasin nan Tiyarafenu ano fefá tian damuádan baréin mai vantan Isareri nanin bantafin tiantan eren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ínaimpáké Yisasi erintéin Yoni ano minó Isareri nanin banta van ará baéde vá monó non barano siyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yoni ma vei yoran kípan akhempá béi semí, ‘Tiretí ankan ten nan iye inó tiya rafono. Téi mai vanta va uno. Ída ifo véi sen toyampá eriyain téi ída kanaí é beni arantan anamuntáke anan útufonté uno.’ ");
INSERT INTO agd_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Máan tukhen mifo sifá tiváeyan ma Abaraamun akhafana vaona vá inká tiretí ena anan nanin banta ano ma Ayarafenu van péde ven aránaó baona kéká ba soe, mai ma evaráné aviranté uno ma sikharé ein baya mai setimpin mi eren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Máan turan maen Yerusaremí nanin banta vá betíi yafisin kéká bá ano Yisasi nan banasi ída evaránen aviran banta ino siren béin ída kamaen oman afová en pasen sakhanampa vanta kayo ano ma ena ena Sabati yamú ma vanasi siamyaré ein baya ánain mi vákuren béin arino sen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Máan tiyáken ben nan purino ma siyaini aau ana yosíkan ída vaimpin Yisasin arintin purino van betí ano Pairotin ákonaen tútúpen inaen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Máan turen mai ma fefá sakhanampa vanta kayo ano ma sikhá ein avúaváká ten minó uman béin amaniná kaúden daa unkamádantáke un mamádan barará eravuvin béin daiyen on aimpin mo masíen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Masí en mifo Tiyarafenu ano evaránen purin pinte véin orun avían manten mino. ");
INSERT INTO agd_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mantaran mai ma véin má Kariri fáké Yerusaremí barurá ma onóbe enóbe iyaré ein kayo ano kokhon damú béin oniyaren taréa mai kéká anon tetisi vanasifin béin nan tian dákó uan amiyan mino. ");
INSERT INTO agd_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Máan tukhái mai ma Tiyarafenu ano setin tináuyan ma iyáan táká ein kama vayan tiretin tiamiyá tiféuno. ");
INSERT INTO agd_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Taréa ma vetin akhafana ma varunafin mi Tiyarafenu ano mai ma sian damuádan baré ein baya kanaí ino van purin pintena Yisasin orun avían mantakhan mi kan dádasí ma en uvantein Í Bompon dókifin uvamádan ban mino. Mai vaya ano siyáken, “‘Taréa séi en afóení ékuya éi sen taniní e ono,’ sikhen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tiyarafenu ano véin purin pintena orun avían mantein ída fúta inten mino sen mi ma vayan uvamádan baren mino. Tiyarafenu ano siyáken, “‘Téi ma kantasí ukhein danasinta vá pura sikhein avu vá ma fefá Kin Devitin iyáan tékun baré ein tiretí ankan amenté uno.’ ");
INSERT INTO agd_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tiyarafenui vompon dókifin ena vaya ano máa sikhen mino, “‘Ei Kantasí Ukhein Banta éi ída áesin masípin púta inten mino.’ ");
INSERT INTO agd_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Deviti ma ma varará báken Tiyarafenui oo yaiyen oriyan baren o fúbíkan be anáuyan má masí uran ben au ano mo fútaen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Máan ten mifo mai ma Tiyarafenu ano furin pinte evaránen avían mantein bantai au ída fútaen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Máan tukhein nan mi sifá tiváeyan noe, siretí ankan afovasá ono. Yisasin pinté uaren ma siretíi ume ampiantákein bayan tiamiyá uno. ");
INSERT INTO agd_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mosesini man baya ano ída kanaíen tiretíi ume arúantáden puntákein nanin banta e sen aranten mifo mai vantará ma mumunan inain nanin banta ven pinté uaren mi minó ume arúantáden puntákein nanin banta e sen aranten mino. ");
INSERT INTO agd_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Máan tukhen mifo mai ma sakhanampa vanta kayo ano ma siádan baré ein danasinta ano siretí ankampin afoká inafo vá dafían ákona ono. ");
INSERT INTO agd_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Oyampá baya sin kéka soe, sireti oniyáke anú de orera iya vá púan kípano. Para vara seyo siretí aúbaná ma séi mana yaná uvaré dararé éku siretí ída kanaí eya mumunan iyasin manáa kéká ano ma siaminti mai yere ída mumunan inono.’” ");
INSERT INTO agd_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Máa siren Porin nú Banabasin nú ma vetíi monó átaru namun me ampiren oriyan maen betí ankan tiyáken ena Sabati yamusá mai ma seóna vaya ovaráne me sesirá inétifano sen békanan tiamen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Máa siren mai namun pinté ma orera iyan maen mai ma ará baéden Yutan kayoi monó avúavá ma vákuriyain kayo vá Yutan kayo vá ano Porin nú Banabasin nú bákuren oriyákan betin má e vaya sen oriyan tútúpen temí, “Ayarafenui sarisari aúpin ákona e vá monó teno,” sen betí ankan tiamen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Orikharen ena Sabati yamú ádé anantá mai varu fintena minó nanin banta ano Bafani vaya ineno van e átaru en mino. ");
INSERT INTO agd_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Átaru iyaimpin Yutan kayo ano mai ma e átaru ukhein nanin banta ódaren Porin ará namu uantáden béi ma siyain baya van ankayan tiren oyampá baya sen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Oyampá baya siyaimpin Porin nú Banabasin nú betin nan ída feran evaránen tian amá uan amen temí, “Tiretin naren araíé Tiyarafenui vaya sian améku ída maman kákan danasí eya fara van oriyan ban aunan baran nona van ifá enái saréa yo vaéaré ena anan nanin bantafin mi sian dákó iyá uno. ");
INSERT INTO agd_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Para vara seyo, Bafan mano ákona vaya máan mi sen tetin tisimikhen mino, “‘Téi anon éin maman ena anan nanin bantai kakhaní urékuya ma varai minó ankina fákena nanin banta aya uresí betin evaráné aviranté uno.’” ");
INSERT INTO agd_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Máa síkan ena anan nanin banta kayo ano mai vaya inin betin arápin kama íkan mai kéká ano Bafani vayará amusin uren ben aví maman daní iyákan mai ma fara van oriyan ban aunan barano van ma Tiyarafenu ano aní ukhein nanin banta ano mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Máan tiyákan Bafani vaya ano minó akhempá oreraen mino. ");
INSERT INTO agd_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Máan tiyan mifo Yutan kayo ano vetíi monó tin avúavá ma yakhafiyan ma aví bain nanin kayo vá mai varu ráke ánon banta kéká bá arápiní uren minó ano araíen Porin nú Banabasin nú aruren mai varu fintena vékanan do sianten mino. ");
INSERT INTO agd_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Máan tiyan mai ma sein baya oyan amiyaimpin békanan arantantá ma varé ein kayó do fúpá tiren Antiokí me ampiren Aikoniamú barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Oríkan eyo iyampon kayo ano amusin iyákan Kantá Aunan mano vetin aúpin bíken mino. ");
INSERT INTO agd_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Porin nú Banabasin nú ano Antiokí monó átaru namun ma variyaré ein avúavá anan Aikoniamú baren mino. Békanan Yutan kayoi monó átaru namumpin ódiven Tiyarafenu kama vaya siamíkan kokhon ná Yutan kayo vá ena anan nanin banta kayo vá ano iniren mumunan en mino. ");
INSERT INTO agd_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Máan tiyákan ída ma mumunan ein Yutan kayo ano ena anan nanin banta kayo arápiní íkan mumunan ma iyain nanin banta namuroí uanten mino. ");
INSERT INTO agd_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Máan tiyaimpin Porin nú Banabasin nú ano Aikoniamú barurá ayáká báken ída feranton Bafani avábá in baya vanasi siamiyákan Bafan mano vékanan ákona amíkan enará ukhein avúavá bá aní danasinta vá banasi aní iyan maman pura yanasí en mino. ");
INSERT INTO agd_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Máan tiyaimpin mai varu ráke nanin banta kayo ano kampintan daíden manáa kayo ano Yutan kayoi kékasí íkan manáa ano aposeri kayoi kékasíin en mino. ");
INSERT INTO agd_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Máan turen ínaimpáké Yutan kayo vá ena anan nanin banta kayo vá ano Porin nú Banabasin nú onámaná ankamintin purino van betíi yafisin kayo vá baya sian damuáden mino. ");
INSERT INTO agd_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Máa sen orera iyain baya ma vékanan inen maen Rikoniá barafin ma vain kákan barú kanan Ristará bá Debé bá kan pin karan oriyáken mai akhempá ma vain nanin bantafin Tiyarafenui kama vaya me asotú en tiamen noren mino. ");
INSERT INTO agd_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ristará barurá mana vanta ve anóe ano ma kaein táké arantampin ída ákona vákan ída onóbe enóbe in kumanten mana varen mino. ");
INSERT INTO agd_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kumanten báken Pori ma vaya siyain mai vanta ano iniyákan Pori mai vanta furefure en oniyáken ma vanta ano mumunan iyain béi kanaíen kama inten mino sen inen mino. ");
INSERT INTO agd_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Máa sen iniren Pori oovararen temí, “Ei arantantá orun mantano,” síkan mai vanta ano mai vaya inen kútin orun mantaven oren mino. ");
INSERT INTO agd_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Máan tíkan kokhon nanin banta kayo ano Pori ma varein daná ódaren Rikoniá baya finté betí ankan oovararen temí, “Ayarafenu kayo ano vantai avúaváká ten tetí ankampin erakhen mino.” ");
INSERT INTO agd_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Máa siren betí ankan Banabasin nan Siusin ne sen inká Pori vaya sin banta vákan béin nan Emesin ne sen en mino. ");
INSERT INTO agd_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Máan turan maen Siusii monó namun mai varu akhempá baréin mairá ma mai monó ánon banta vá banasi vá ano manáa afon burumakaó bá manáa faravá asína uran má mamaren Banabasin nú Porin nú íkun uan ameno van mai varui yafu onará oren mino. ");
INSERT INTO agd_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Máan tiyain baya ma Banabasin nú Porin nú ma inen maen békani ona yákaren mai nanin banta kayo aúbaná tavaen oriyáken oovararen temí, ");
INSERT INTO agd_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Banta kayo oe, fará ma avúavá barano van iya rafono. Berasan tireti ma einí ukheruna vantan báké mai ma veni ana i vain avúavá ma variyaona finten tiretin avían para van oriyan ban Tiyarafenu ano ma inaru vá bara vá un non má mai aúpin ma minó danasinta vain ma uvantein banta vaípá kaono van mi kama vaya fóké tiretin tiamiyá uno. ");
INSERT INTO agd_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tiyarafenu ano fefá áíkan ara ara vara finte nanin banta ano vetíi anunu ano ma orein avúaváká baren oriyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Máan tiyan mifo véi ída manáa yaná úaviran bei avábá aníen ayon pintena á dan eriyan inká béi kama áau amíkan dunan ampan kauri niyan nan tiretin aúpin amusin bíkaan tiyan mino.” ");
INSERT INTO agd_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mai vaya fóké Banabasin nú Porin nú ano ákonaen are uantiyan mifo vanasi ano míkani vaya ída ininton iyaníen míkan íkun uan ameno van iyaren mino. ");
INSERT INTO agd_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Máan tiyákan Antiokí baru rákena manáa Yutan kayo vá Aikoniamú baru rákena vá ano Ristará barurá eriven banasi arápiní íkan betí ano Porin ará uman daantáden onámaná ankaman kaúden inka furen mino siren kákan baru finte yo yarifen baru akhempá morun karúden mino. ");
INSERT INTO agd_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Máan turan mifo Yisasintá ma mumunan iyá ein kéká ano o iyen eúkuvíkan Pori orun mantaaren evaránen kákan barufin o varen ená damú Banabasi má Debé barufá oren mino. ");
INSERT INTO agd_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Debé barufá o varen míkanan mano Tiyarafenui kama vaya mai varufin tiamíkan banasi ano Yisasintá mumunan en orera iyákan ínaimpáké békanan evaránen Ristará barufá bá Aikoniamú barufá bá Antiokí barufá bá oren mino. ");
INSERT INTO agd_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Oriven míkanan mano Yisasintá ma mumunan iyá ein nanin banta mo ákona uantiyáken temí, “Uman kayofin orivétiféi ínaimpáké Tiyarafenui Yafisin aúpin oró tifanté umpo fura sikhein mumunanta sá mantaan ákona ono,” sen e siamen oren mino. ");
INSERT INTO agd_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Máa sen oriyáken Porin nú Banabasin nú ano yunan auraren amúkiyáken Yisasintá ma mumunan iyain nanin bantará ma kanaíen dafiseren ukhein banta kayo aní uren ayan ánontá kauren amúkuanten mino. Máan turen mana mana monó namuntá dafídú uantáden betí ankan Bafan ayampin kaen mino. ");
INSERT INTO agd_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Máan turen ínaimpáké Banabasin nú Porin nú ano Pisidiá barafá oriaren Pamfiriá barafin oren mino. ");
INSERT INTO agd_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Oriven ma Pekhá barurá Tiyarafenui vaya siamíden maen ínaimpáké míkanan Atariá barufá araven mino. ");
INSERT INTO agd_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Orun baren ma míkanan monó doran kíparen maen mai ma monó nanin banta kayo ano ma vékanan tarisari urantin mai yorarí ino van ma Tiyarafenui ayampin kaein baru mai Antiokíi varéin maifá sipi varen oren mino. ");
INSERT INTO agd_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Oriyan baren míkanan mairá o unaven mai ma Tiyarafenu ano vékanan ayan táké uaren ena anan nanin bantai mumunan ona ma yiantein baya monó nanin banta mo átaru uádaren tiamen mino. ");
INSERT INTO agd_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tiamíden maen békanan Yisasintá ma mumunan iyain nanin banta kayo vá manáa ayáká baren mino. ");
INSERT INTO agd_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yudiá kena manáa vanta kayo ano Antiokí araven morun monó nanin banta kayo araíen afova amiyan temí, “Tiretí ankan ma Mosesini avúavá ída yakhafe siretí au ma ída kavesin maen Tiyarafenu ano ída kanaíen tiretí ankan evaránen aviranten mino.” ");
INSERT INTO agd_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Máan ma siyain baya van Pori nú Banabasi nú mai vanta kéká bá asiven mino. Máan tiyan monó nanin banta ano vaya sian damuaren Porin nú Banabasin nú bá inká ena mumunan banta kayo vá aní uren Yerusaremí ma vain aposeri kayo vá inká monó doran banta kayo vá mai vaya mo funtarano van Yerusaremí tiantan oren mino. ");
INSERT INTO agd_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Monó nanin banta kayo ano vetí ankan tiantan oriyáken Fonisiá bara vá Sameriá bara vá aúbanapin ma vain kéká afova amiyáken temí, “Tiyarafenu ano ena anan nanin banta kayo ará baéden aviren mino,” síkan maí kan barufin ma mumunan nanin banta vain mano mai vaya iniren amusin en mino. ");
INSERT INTO agd_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Betí ankan Yerusaremí onóbíkan mumunan nanin banta kéká bá baya varen orin banta kayo vá monó doran banta kayo vá ano amusin uren Porin nú Banabasin nú aviren mo khain Tiyarafenu ano ma vékanan ayantá ma varein danasinta vetí ankan tiamen mino. ");
INSERT INTO agd_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Máa síkan Farasisi kéká pintena manáa mumunan banta kayo ano orun mantaven temí, “Ena anan banta kayo ano ma setí ankampin ma e ferano van inti vá betin au kare Mosesini man baya siamesin ná mai ánain dakhafino.” ");
INSERT INTO agd_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Máa síkan baya varen orin banta kayo vá monó doran banta kayo vá ano mai vaya funtarano van átaru en mino. ");
INSERT INTO agd_vpl VALUES ("AC1