﻿USE sofia;
DROP TABLE IF EXISTS sofia.aey_vpl;
CREATE TABLE aey_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aey_vpl WRITE;
INSERT INTO aey_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Wele gug qocna Anut uqa sao mahaca ifanen. ");
INSERT INTO aey_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Odocob maha eu ihulahal tanac gauc nijen. Wa ben tatacan tu ahulec cilehdu nijen. Odocob Anut uqana kis eu wa tatacan jojoi cobon. ");
INSERT INTO aey_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Odocob Anut madeceb, “Camajac calagale,” eceb camajac calen. ");
INSERT INTO aey_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Anut camajac me bahic eu fimei waug ceelen. Odimei Anut camajac tuca filiganalen. ");
INSERT INTO aey_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Camajac eu Anut uqa ijan “Cahineg” qon. Tu eu ijan “Witic” qon. Odocob witic mimei cojagen. Eu deel matu. ");
INSERT INTO aey_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Odocob Anut madeceb, “Wa ohisdecca wa mahanadecca filiganalecnu qagojoc oso calagale,” eceb eu odi calen. ");
INSERT INTO aey_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Qagojoc eu Anut uqa ifanen eu wa mahanadecca wa ohisdecca filiganalen. ");
INSERT INTO aey_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Odocob Anut qagojoc eu ijan “Sao” qon. Odocob witic mimei cojagen. Eu deel lecis doc. ");
INSERT INTO aey_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Odocob Anut madeceb, “Wa sao bisalu eu cudun osahicna gabandocob cudun galalec caleiale,” eceb eu odi calen. ");
INSERT INTO aey_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Odocob Anut cudun galalec eu ijan “Maha” qon. Odocob wa cudun osahicna gabandon eu ijan “Macas” qon. Anut eu me bahic fimei waug ceelen. ");
INSERT INTO aey_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Odocob Anut madeceb, “Mahana celumca na sihul filfil me qonaca cehelo gug filfil aig qonaca caleigale,” eceb eu odi calen. ");
INSERT INTO aey_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Eunu mahana celumca na sihul filfil me qonaca cehelo gug filfil aig qonaca eu odi calein. Anut eu me bahic fimei waug ceelen. ");
INSERT INTO aey_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Odocob witic mimei cojagen. Eu deel ijed doc. ");
INSERT INTO aey_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Odocob Anut madeceb, “Cahineg witicca filiganalecnu cabi saenca deelca cabi gelca gadac mecnu fulacdoc saona caleigale. ");
INSERT INTO aey_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Fulacdoc i age maha fulacdoc utuqagannu saona tawoqagan,” eceb eu odi calen. ");
INSERT INTO aey_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Oodon Anut uqa fulacdoc benben lecis mudalen. Fulacdoc ben bahic eu cahineg cofdocnu muden. Fulacdoc nag eu witic cofdocnu muden. Uqa malaqaha mudaden. ");
INSERT INTO aey_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Anut uqa maha fulacdoc utuqagannuca cahineg witicca cofdocnuca fulacdoc tuca filiganalecnuca fulacdoc i age saona maden. Anut eu me bahic fimei waug ceelen. ");
INSERT INTO aey_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Odocob witic mimei cojagen. Eu deel wal oso doc. ");
INSERT INTO aey_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Odocob Anut madeceb, “Wana ceteteh cunug cebac nijuqagan eu fulusdoigale. Euha maha ohisnaca sao bisalunaca man fululec fululi coboigale,” eceb eu odi calen. ");
INSERT INTO aey_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Odimei Anut macasnadec dool benben ifanen. Ceteteh cunug cebac cobogina agena sihul filfil toodudu wana am ben. Man fululec sihul filfil cunug euha ifanen. Anut eu me bahic fimei waug ceelen. ");
INSERT INTO aey_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Odimei Anut eeladi maaden, “Fulusdumeig mati bahic caleigale. Macas cunug ihoc leigale. Mahana man fululec fulusdumeig mati bahic calimeig maha cunug ihoc leigale,” aden. ");
INSERT INTO aey_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Odocob witic mimei cojagen. Eu deel ebum oso doc. ");
INSERT INTO aey_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Odocob Anut madeceb, “Mahana dool gug filfil mananca cusca benca nagca caleigale,” eceb eu odi calen. ");
INSERT INTO aey_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Odimei Anut uqa mahanadec dool manan sihul filfilca dool cus sihul filfilca ceteteh mahana cobogina sihul filfilca mudaden. Anut eu me bahic fimei waug ceelen. ");
INSERT INTO aey_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Odocob Anut maden, “Ege dana cajaca mudalecnu. Ege ihocomige qumeb ege cinigwe mudalecnu. Odocob ale dool wanadecca man fululec saonadecca dool mananca maha cunugca ceteteh cunug mahana cobogina eu cofadowasin,” en. ");
INSERT INTO aey_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Odimei Anut uqadodoc ihocon qu dana cajaca ifanalen. Manahal aidca uqa ifanalen. ");
INSERT INTO aey_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Odimei Anut eelali maalen, “Mel basimesi fulusdosiale. Odimesi maha cunug ihoc limesi ilo bilesiale. Macasnadec doolca saonadec man fululecca ceteteh cunug mahana cebac cobogina eu cunugnu ale ilo bilesiale,” alen. ");
INSERT INTO aey_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Odimei uqa maalen, “Fesia! Celum aig qona gug filfilca cehelo aig qona gug filfilca ija wele alem euqa maha olana ihoc leia nijia. Cehelo eu age agena aig eu alena sab biligian. ");
INSERT INTO aey_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Qa mahanadec dool cunugca saonadec man fululec cunugca ceteteh cunug mahana cebac coboginaca eu age celum gigica cunug eu agena sab adiga,” alen. Odocob eu odi nijen. ");
INSERT INTO aey_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Odimei Anut ceteteh cunug uqa mudaden eu me bahic fimei waug ceel bahic en. Odocob witic mimei cojagen. Eu deel eben gic osahicca doc. ");
INSERT INTO aey_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Aria sao mahaca ceteteh cunug ifanen. Eu uqana cabi hedon. ");
INSERT INTO aey_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Deel eben naha gic lecisca qee ihoc lec Anut uqana ifanec cabi cunug hedon. Odimei jaen muden. ");
INSERT INTO aey_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Oodon Anut uqa ifanec cabi cunug hedumei jaen muden eunu deel eben naha gic lecisca eu eeldumei qagu fil men. ");
INSERT INTO aey_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Je i saen Anut sao mahaca ifanalennu je. Tibud Anut uqa maha saoca ifanalen saen euna ");
INSERT INTO aey_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","uqa mahana wa qee suldol. Dana cabi cehecnu ha qee mudel. Eunu gigi o celum oso mahana qee cajec nijen. ");
INSERT INTO aey_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Qa wa tut gaid mahanadec cajimei maha cunug wa utoloi. ");
INSERT INTO aey_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Odocob Tibud Anut uqa colig mahanadec umei dana oso muden. Odimei mede gigil ocna kis cebac eu fuldutocob dana cebac men. ");
INSERT INTO aey_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Aria Tibud Anut cabi oso cam tobi becna isec Iden ono cehen. Odimei dana uqa ifani mudon eu ono muden. ");
INSERT INTO aey_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Odocob Tibud Anut uqa odocob mahanadec na cunug fecnu galeca sabnu me bahic eu cajein. Cabi gemo na lecis tawesin. Oso uqa na aig jifei cebac biligian. Oso uqa aig eu jifei doc meca me qeeca ugian. ");
INSERT INTO aey_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Aria wa tut oso Idendec boloi. Eu cabi wa utoloi. Odimei eunadec wa eu batac qu wal oso don. ");
INSERT INTO aey_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Wa batac matu eu ijan Pison. Wa eu nuimei Hawila hatu eu cunug taldona. Hatu euna gol nijina. ");
INSERT INTO aey_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Hatu eunadec gol eu me bahic. Ono na oso nijina eu uqana gilic eu dedeman me bahic. Eu ijan deliam. Euna ha meen oso nijina. Eu ijan oniks. ");
INSERT INTO aey_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Wa oso, eu ijan Gion, eu nuimei Kus hatu eu cunug taldona. ");
INSERT INTO aey_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Wa oso ijan eu Taigris. Eu Asiria cam tobi becna isec nuina. Wa oso ijan eu Jufretis. ");
INSERT INTO aey_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Aria Tibud Anut uqa dana eu umei Iden cabi dunuh muden. Cabi cehigiannuca cofdugiannuca muden. ");
INSERT INTO aey_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Odocob Tibud Anut dana dahig hehewi bili je gagadic odi madon, “Hina na aig cunug cabina nijia eu cois jagale. ");
INSERT INTO aey_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Qa doc meca me qeecanu na eu aig cain jagaun. Hina eu jegaqa deel euna himec hina cal megan,” don. ");
INSERT INTO aey_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Aria odocob Tibud Anut maden, “Dana uqa cuhanuc bilec me qee. Ija uqa cesuldoc oso muditugen,” en. ");
INSERT INTO aey_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Eunu Tibud Anut maha leih cedimei dool mahanadecca man fululec saonadecca cunug mudaden. Odimei dana ijanaga aqeceb figia bili cedadi danaca ehadi len. Odocob dana uqa dool cunug osahicosahic ijanaga qon. Ijanaga qon eu age ijanaga ibuldon. ");
INSERT INTO aey_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Oodon dana uqa dool mananca man fululec saonadecca dool cusca eu cunug ijanaga aqen qa uqa cesuldocnu cinigwe oso qee fel. ");
INSERT INTO aey_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Eunu Tibud Anut odocob dana uqa us geh men. Odocob uqa cal mecwe nijen. Ninijen Tibud Anut dana qeih teful oso umei teful onna deweg ganacna haun cufa quton. ");
INSERT INTO aey_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Odocob Tibud Anut dana qeih teful euna caja oso mudimei danaca ehudi len. ");
INSERT INTO aey_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Odocob dana uqa maden, “Mele bahic. Uqa teful eu ija tefulininadec. Uqa cuhun eu ija cuhuninadec. Uqa dananadec umei mudon. Eunu ija ijan ‘Caja dugen,” en. ");
INSERT INTO aey_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Eunu dana uqa anag memegca culaleceb uqa aidegca gabandowasan. Odimesi ale dewenela osol mowasan. ");
INSERT INTO aey_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Aria dana aidegca ale bical aleqa qee majanala alel. ");
INSERT INTO aey_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Aria man sononec uqa fanindocnu du cuhadon. Uqa dool cunug wooladec Tibud Anut maden. Odocob uqa caja sisildon, “Anut ale cehelo aig cunug cabina nijia eu cain jowasin ec maalen eu melefo?” don. ");
INSERT INTO aey_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Odocob caja uqa man sononec jejeg hewi madon, “Cehelo aig osooso cabina nijeiga eu ele jecnu ihocqa ");
INSERT INTO aey_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","na gemo taweia eunu Anut uqa ale eundec aig eu cain jowasin o cain qududu fowasin. Eu odifesi ale cal mowasan ec malen,” don. ");
INSERT INTO aey_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Odocob man sononec caja madon, “Qeeo! Ale qee cal mowasin! ");
INSERT INTO aey_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ale aig eu jifesi alena cisdoc fogo docob ceteteh meca me qeecanu dowasan. Ale Anut cinigwe calowasan. Eu Anut uqa dona. Eunu uqa odi maalen,” don. ");
INSERT INTO aey_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Eunu caja uqa aig eu feceb galeca bahic ameg qon. Eu jecnu me bahic fen. Uqa doc meca me qeeca ocnu ha gale don. Eunu uqa cehelo eundec aig umei jen. Odimei gemug uqaca tawesin euha uteceb jen. ");
INSERT INTO aey_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Odocob ale amala fogo don. Odocob ale bical eu dosin. Eunu ale dan bagac gisimesi taqesin. ");
INSERT INTO aey_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Aria wesu maha daec saenna Tibud Anut uqa cabina cocobon ale hutan dosin. Odimesi ale cabina na gemo Tibud Anut amegnu jahundosin. ");
INSERT INTO aey_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Euqa Tibud Anut dana utadu madon, “Hina ai?” don. ");
INSERT INTO aey_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Odocob uqa jejeg hewi madon, “Ija hina cabina cocobogan hutain dugaqa ija bical. Eunu ija cucuiimig jahuniga,” don. ");
INSERT INTO aey_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Odocob Anut uqa sisildon, “Hina bical ec eu indec maheia? Hina cehelo aig ale cain jowasin ec mahem eundec u jagafo?” don. ");
INSERT INTO aey_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Odocob dana jejeg hewi madon, “Caja ijaca bilewannu item eu uqa cehelo eundec aig iteceb ija jiga,” don. ");
INSERT INTO aey_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Odocob Tibud Anut caja sisildon, “Eu celnu odoga?” don. Odocob caja jejeg hewi madon, “Man sononec qauteceb ija jiga,” don. ");
INSERT INTO aey_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Odocob Tibud Anut man sononec madon, “Hina eu odi odoganu dool cunug mananca cusca gemo hina himec gelihigina. Qila hina wawinna dih sononi cobogan. Hina eu odi mahana cocobi li hinana cal mec deelna calegan. ");
INSERT INTO aey_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ija odocomin hina cajaca qocobqocob owasan. Uqana sihulca hinana sihulca gaid cad biluwasan. Hibna caja uqana mel oso uqa ilom tulohdocob hina uqa jaih bisoc qu jegan,” don. ");
INSERT INTO aey_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Odimei uqa caja madon, “Ija hina mel basecnu dain hec saen eu ben bahic tubduhigen. Hina ben dain heheb mel basegan qa hina gemunnu gale hec eu odi nijigian. Euqa uqa hinana ilo biligian,” don. ");
INSERT INTO aey_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Odimei uqa dana madon, “Hina aiden jejeg dah mimeg cehelo aig ija cain jowasin ec mahem eu jaga. Hina eu odi odoganu ija maha geldugina. Hina gagadic odocca dain hecnaca u jegan. Eu odi himec oodi li cal megan. ");
INSERT INTO aey_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Husca gagalitca hinana cabina cajoqagan. Odocob hina sab bahudec u jegan. ");
INSERT INTO aey_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Hina musul heheb sab u jegan. Oodi li haun maha ibuldogan. Hina mahana mihem. Hina maha eunu haun ceseli maha ibuldogan,” don. ");
INSERT INTO aey_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Aria Adam uqa aideg eu uqa dana cajaca cunug agena anaga calen. Eunu uqa ijan Iw qon. ");
INSERT INTO aey_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Odocob Tibud Anut uqa dool ganacna lotoc mudimei Adam aidegca aleceb taqesin. ");
INSERT INTO aey_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Odocob Tibud Anut maden, “Qila dana ege oso cinigwe caleia. Ceteteh meca me qeeca dona. Euqa uqa eben mimei cebac bilec na aigha u jimei cebac bileceb catanecdain. Eunu ege cahacdoc bahic cahacdoqan,” en. ");
INSERT INTO aey_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Eunu Tibud Anut uqa dana caja Iden cabinadec ititacalen. Maha dana muden euna sab cehigiannu eunadec malen. ");
INSERT INTO aey_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ititacali hedocob cali lesin. Odimei Iden cabi cam tobi becna isec uqa han qali dana gagadic, ijan Kerub, ono maden. Odimei sigin aig ja belicanca eu hagen cunugna isec walwaldudu tawena euna muden. Eu cebac bilec catanec uqana jic cahacdoc. ");
INSERT INTO aey_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Aria Adam uqa aideg Iwca nijimesi uqa melca men. Odimei Ken basen. Odocob uqa maden, “Tibud cesulteceb ija mel momodo oso ehudiga,” en. Eunu uqa ijan Ken qon. ");
INSERT INTO aey_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Odocob uqa hibna Ken waliag Ebel basen. Odocob Ebel uqa ben mimei dool cofadec dana calen qa Ken uqa ben mimei cabi ceteteh cehec dana calen. ");
INSERT INTO aey_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Aria saen osona Ken uqa cabinadec sab leih cedi ahumei Tibud ihandon. ");
INSERT INTO aey_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ebel uqaha Tibud ihandon qa uqa sipsip nag leih hahawan basadec eundec aqi tuqadimei cuhunuga lalonoga eu cedadi ahon. Odocob Tibud uqa Ebelnuca uqana ihanecnuca waug nijen. ");
INSERT INTO aey_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Qa Kennuca uqana ihanecnuca Tibud uqa waug qee nijel. Eunu Ken uqa gemag geh bahic ben. Odocob ola gulu qon. ");
INSERT INTO aey_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Odocob Tibud uqa Ken madon, “Celnu hina gemain bena? Celnu hina olain gulu qona? ");
INSERT INTO aey_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Hina odi cuhadoummi ija wawi hinanu nijoub. Qa hina qee odi cuhadocomfi silail hinana cebecna hagawihecnu saciadoia taweia. Uqa hinanu nalunin meia taweia. Qa hina gagadic mimeg wooldoga,” don. ");
INSERT INTO aey_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Aria Ken waliag Ebel madon, “Gec beli bahu cobewa,” don. Odocob belesin. Cocobi bilesi Ken uqa cajimei waliag Ebel qagadocob cal men. ");
INSERT INTO aey_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Aria Tibud uqa Ken sisildon, “Hina walin Ebel ai?” don. Odocob uqa jejeg hewi madon, “Ija qee dugina. Ija wali cofdoc danafo?” don. ");
INSERT INTO aey_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Odocob Tibud madon, “Hina eeta odoga? Hina walin golac mahana basedoia eu dana jejeg cinigwe utai mateia ija dah miga. ");
INSERT INTO aey_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Qila ija hina gelihigina. Hina walin qagadocom cal meceb uqa golac mahana basedoia. Odimei golac maha dunuh noia eu maha cocawe mimei sugudoia. Eunu maha i hina ceteh cehecnu ihoc qee. Eunu ija hina maha inadec ititachigina. ");
INSERT INTO aey_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Saen hina maha ina sab cehegaqa hina sab me qee cajiheian. Hina jehen osoca qee. Hina odi mahamaha loldudu cobogan,” don. ");
INSERT INTO aey_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Odocob Ken uqa Tibud madon, “Ijana me qee odoc ameg eu ben bahic. Ija gahidocwe qee. ");
INSERT INTO aey_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Faga! Hina qila deel ina maha inadec ititactagana. Odocom ija hina amennu bisachi nuigen. Ija jehenca qee mahamaha loldudu cobigen. Odi cocobomin in oso guluctigiaqa qagateceb cal migen,” don. ");
INSERT INTO aey_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Qa Tibud jejeg hewi madon, “Eu odi qee. Dana oso Ken qagadocob cal migiaqa ija dana eu ameg culumen eben naha gic lecisca wadacdugen,” don. Odocob Tibud uqa Kennu gaga oso men. Eunu dana oso Ken gulucdugiaqa uqa gaga eu fimei uqa qee qagadoiaun. ");
INSERT INTO aey_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Odocob Ken uqa Tibud amegnu bisacdumei caji nuen. Odimei uqa Iden cam tobi becna isec nuimei hatu ono bilen. Hatu eu ijan “Loldudu Coboc”. ");
INSERT INTO aey_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Aria Ken aidegca nijimesi uqa melca men. Odimei Inok basen. Saen euna Ken uqa taun ben oso cecehi bilei uqa melah ijan Inok eu taun eu ijan qon. ");
INSERT INTO aey_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Aria Inok ben mimei caja oso ocob mel basen. Eu uqa ijan Irad qon. Odocob Irad uqa caja oso ocob mel basen. Eu uqa ijan Mehusel qon. Odocob Mehusel ben mimei caja oso ocob mel basen. Eu uqa ijan Metusel qon. Odocob Metusel ben mimei caja oso ocob mel basen. Eu ijan Lamek qon. ");
INSERT INTO aey_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Odocob Lamek ben mimei caja lecis cedalen. Oso ijan Eda. Oso ijan Sila. ");
INSERT INTO aey_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Odocob Eda uqa Jabal basen. Jabal uqa dana dool manan cofaadi bileig lotoc talahna himec nijegina eu agena asaga calen. ");
INSERT INTO aey_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabal uqa waliagca, eu ijan Jubal. Uqa dana sihul gita qoginaca cololo fuldoginaca eu agena asaga calen. ");
INSERT INTO aey_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Odocob Sila uqaha mel oso basen. Uqa ijan eu Tubal-ken. Tubal-ken uqa bras ainca na cabi teful aigcaca mudec dana calen. Tubal-ken uqa cebinagca, eu ijan Nama. ");
INSERT INTO aey_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Odocob Lamek aidegul maalen, “Eda Silaca ale ija jejeni dah mesia. Ale ijana caja ijana je dah mi cuhadosia. Dana oso uqa ija qiteceb golani necebfi ija qocomin cal migian. Mel oso uqa ija qitecebfi ija qocomin cal migian. ");
INSERT INTO aey_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Dana oso Ken qagadocob cal mecebfi wadacdoc ameg eu ben ugian. Qa dana oso ija qagatifei uqa wadacdoc ameg eu culumenca bahic ugian,” alen. ");
INSERT INTO aey_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Odocob Adam haun aidegca nijimesi uqa mel oso basen. Odimei uqa maden, “Ken uqa Ebel qagadocob cal men. Eunu Anut uqa mel oso haun itia. Eu Ebel hehuldocnu itia,” en. Eunu ijan Set qon. ");
INSERT INTO aey_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Odocob Set uqa caja oso ocob mel basen. Eu uqa ijan Inos qon. Saen euna dana age Tibud ijanna inondudu ihanec sanan mein. ");
INSERT INTO aey_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Je jaqoc ina Adamna sihul ijanaga nijia. Anut uqa dana ifanen saen euna uqa dana Anut cinigwe muden. ");
INSERT INTO aey_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Uqa manahalca aidca ifanalen. Ifanaalen uqa eelalimei ijanala “Dana Cajaca” aqalen. ");
INSERT INTO aey_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Saen Adam uqana cabi gel 130 eu odi bibili bilei uqa aideg mel oso basen. Mel eu uqa cinigwe uqa hahun umei cali hon. Odocob uqa ijan Set qon. ");
INSERT INTO aey_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Aria Set cali hocob Adam uqa bileceb li uqana cabi gel 800 eu odi calen. Oodon Adam aideg uqa melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Eunu Adam uqana cabi gel cunug gabandoc eu 930. Odocob uqa cal men. ");
INSERT INTO aey_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Aria Set uqa bibilen li uqana cabi gel eu 105 eu odi caleceb uqa aideg mel oso basen. Odocob ijan Enos qon. ");
INSERT INTO aey_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Odimei Set uqa bibilen li cabi gel 807 on. Oodon uqa aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Eunu Set uqana cabi gel cunug gabandoc eu 912. Odocob uqa cal men. ");
INSERT INTO aey_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Aria Enos uqa bibilen li uqana cabi gel 90 ocob uqa aideg mel oso basen. Odocob ijan Kenan qon. ");
INSERT INTO aey_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Odimei Enos bibilen li cabi gel 815 on. Oodon uqa aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Eunu Enos uqana cabi gel cunug gabandoc eu 905. Odocob uqa cal men. ");
INSERT INTO aey_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Aria Kenan uqa bibilen li uqana cabi gel 70 ocob uqa aideg mel oso basen. Odocob ijan Mahalalel qon. ");
INSERT INTO aey_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Odimei Kenan bibilen li cabi gel 840 on. Oodon uqa aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Eunu Kenan uqana cabi gel cunug gabandoc eu 910. Odocob uqa cal men. ");
INSERT INTO aey_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Aria Mahalalel uqa bibilen li uqana cabi gel 65 ocob uqa aideg mel oso basen. Odocob ijan Jared qon. ");
INSERT INTO aey_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Odimei Mahalalel bibilen li cabi gel 830 on. Oodon uqa aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Eunu Mahalalel uqana cabi gel cunug gabandoc eu 895. Odocob uqa cal men. ");
INSERT INTO aey_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Aria Jared uqa bibilen li cabi gel 162 ocob uqa aideg mel oso basen. Odocob ijan Inok qon. ");
INSERT INTO aey_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Odimei Jared bibilen li cabi gel 800 on. Oodon uqa aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Eunu Jared uqana cabi gel cunug gabandoc eu 962. Odocob uqa cal men. ");
INSERT INTO aey_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Aria Inok uqa bibilen li cabi gel 65 ocob uqa aideg mel oso basen. Odocob ijan Metusela qon. ");
INSERT INTO aey_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Odimei Inok uqa cabi gel 300 eu odi Anutca cobosin. Oodon uqa aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Eunu Inok uqana cabi gel cunug gabandoc eu 365. ");
INSERT INTO aey_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Aria Inok mahana bibili uqa Anutca cobosin. Oodon Anut uqa ehuden. Eunu uqa jajanu qelen. ");
INSERT INTO aey_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Aria Metusela uqa bibilen li cabi gel 187 ocob uqa aideg mel oso basen. Odocob ijan Lamek qon. ");
INSERT INTO aey_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Odimei Metusela bibilen li cabi gel 782 on. Oodon uqa aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Eunu Metusela uqana cabi gel cunug gabandoc eu 969. Odocob uqa cal men. ");
INSERT INTO aey_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Aria Lamek uqa bibilen li cabi gel 182 ocob uqa aideg mel oso basen. ");
INSERT INTO aey_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Odocob uqa maden, “Maha i Anut wele geuldon eunadec mel i ege cehi jecnu cabi culumenca oqonanu mel i uqa cesulgigian,” en. Eunu mel eu ijan Noa qon. ");
INSERT INTO aey_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Odimei Lamek bibilen li cabi gel 595 on. Oodon uqa aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Eunu Lamek uqana cabi gel cunug gabandoc eu 777. Odocob uqa cal men. ");
INSERT INTO aey_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Aria Noa uqana cabi gel 500 hedocob uqa melahul ijedca bilen. Age ijanaga eu Semca Hamca Jafetca. ");
INSERT INTO aey_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Aria saen euna dana sihul mahana geh bahic fulusdumeig mel aid basadein. ");
INSERT INTO aey_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Mel aid eu age galeca bahic. Eunu Anutna sao mel age dana atagail feciadecebil amaga qon. Odocob age aidagailnu agena gawecnana cedadein. ");
INSERT INTO aey_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Odocob Tibud uqa maden, “Dana cajaca age qee bilecebil cataneiaun. Eunu ijana Kis eu dana cajaca ageca qee bileceb cataneiaun. Qila ija odadecemin age cabi gel 120 himec biluqagan,” en. ");
INSERT INTO aey_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Saen euna hibnaha dana citoec mahana bilein. Aria Anutna sao mel age dana atagail gami ocobocob imeig mel basadein. Mel eu age dana citoec age hannu gelehinigaca calein. Dana eu age age dana weledec age ijanagaca. ");
INSERT INTO aey_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Aria Tibud uqa dana cajaca mahanadec agena qisol mec eu ben bahic fen. Agena cisdoc me qeeca golanaga me qeenu sililecca odi nijen. ");
INSERT INTO aey_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Uqa dana cajaca ifanadimei mahana mudennu waloc don. Uqa waug ben qon. ");
INSERT INTO aey_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Odocob Tibud uqa maden, “Ija dana sihul cunug ifanadem eu qee madigen. Mahana doolca man fululecca ceteteh cunug mahana cobogina eu qee madigen. Ija ifanademnu waloc tena,” en. ");
INSERT INTO aey_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Qa Tibud uqa Noana odoc fimei Noanu waug tawen. ");
INSERT INTO aey_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","I Noanu je. Noa uqa dana ititom. Uqa Anut amegna cahuldocca qee. Uqa Anutca cobosin. ");
INSERT INTO aey_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa uqa melahul ijedca. Age ijanaga eu Semca Hamca Jafetca. ");
INSERT INTO aey_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Qa saen euna dana cajaca cunug age Anut amegna qisol mec me qee bahicca. Age cunug han me qee cadein. ");
INSERT INTO aey_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Anut uqa dana cajaca mahana cunug bilein age qisol mein eu fen. ");
INSERT INTO aey_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Odocob Anut uqa Noa madon, “Dana cunug agena qisol mec eu maha cunug ihoc len. Eunu ija age cunug qee madigen. Mele bahic ija maha cunug fadaldugen. ");
INSERT INTO aey_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Wag ben oso wamena hinadodocnu himec jelega. Wag eu hamol mati bahicca muduga. Odimeg baial dunuhca maha gumuca joudoga. ");
INSERT INTO aey_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Hina odi jelegan. Wag eu uqana cecelac eu 133 mita. Uqana bagalan eu 22 mita. Uqana ohis tec eu 13 mita. ");
INSERT INTO aey_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Hina jo qab naca qeih naca gemo fufu cebecha qahegan. Fufu cebec uqana ohis tec eu mita naha himec. Odimeg cebec eu wag qeihna qahegan. Wag eu uqana bahim ijed dunuh bacatca mudegan. ");
INSERT INTO aey_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Faga! Ija wa sil mahana suldugen. Ceteteh cunug mahana coboginaca sao bisalunaca cunug fadaladigen. Ceteteh mahana cebac bilegina age cunug cal moqagan. ");
INSERT INTO aey_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Qa ija hinaca bal cehec je madewan. Odocob hina wag tobegan. Hinaca hina melemenelca hina aidenca hina melemenel aidagailca toboqagan. ");
INSERT INTO aey_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ceteteh cunug mahana cobogina eundec dool filfil man fululec filfil manahalca cufunecca ehadi ehi li wagna madegan. Odocob age qee cal mowain. ");
INSERT INTO aey_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Odocob hina sab gug filfil hinanuca agenuca cedi ehi li megan,” don. ");
INSERT INTO aey_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Aria Noa uqa Anut madon eu cunug toodu odon. ");
INSERT INTO aey_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Odocob Tibud uqa Noa madon, “Saen ina hina himec ija amina dana ititom. Eunu hinaca hinana talaunelca wag dunuh leiga. ");
INSERT INTO aey_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Hina dool qagoc eundec gug filfil manahal eben naha gic lecisca cufunec eben naha gic lecisca odi cedadaga. Odimeg hina dool qee qagoc eundec manahal osahic cufunec osahic odi cedadaga. ");
INSERT INTO aey_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Odocob man fululec sao bisaludecha manahal eben naha gic lecisca cufunec eben naha gic lecisca odi cedadaga. Eu age hibna haun mahana fulusdoqagan. ");
INSERT INTO aey_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Deel eben naha gic lecisca hedocob ija wa ben saonadec suldugen. Odocob wa eu cahineg 40 witic 40 odi hugian. Saen euna ija ceteteh cunug maha ina ifanadem eu fadaladigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Odocob Noa uqa Tibud madon eu cunug toodu odon. ");
INSERT INTO aey_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Aria Noa uqana cabi gel eu 600. Saen euna wa sil cajimei maha cunug ihoc len. ");
INSERT INTO aey_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Oodon Noa uqa wa sil cajigiannu uqa melahul gami uqa aidegca uqa melahul aidagail gami age wag dunuh lein. ");
INSERT INTO aey_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Dool qagocca qee qagocca manca ceteteh cunug mahana cobogina euha dunuh lein. ");
INSERT INTO aey_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Euqa manahalca cufunecca Noa gami wag dunuh lein. Age Anut Noa madon eu odi toodu lein. ");
INSERT INTO aey_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Odocob deel eben naha gic lecisca hedocob wa sil mahana cajen. ");
INSERT INTO aey_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Saen euna Noa uqana cabi gel eu 600. Wa sil cajen eu deel 17 jagel lecis docna wa ameg cehec maha dunuhdec eu uqana cebec qajawen. Odocob saonadec cebec cunug hudeceb wa ben nen. ");
INSERT INTO aey_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Odocob wa eu cahineg 40 witic 40 odi mahana nen. ");
INSERT INTO aey_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Deel euna dih Noaca uqa melahul Sem, Ham, Jafetca ageca uqa aidegca uqa melahul aidagailca age cunug wag dunuh lein. ");
INSERT INTO aey_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Dool mananca cusca eundec sihul filfil ceteteh cunug mahana cobogina eundec sihul filfil man fululecca ceteteh cunug hojonogaca sihul filfil eundec age cunug Noa gami wag dunuh lein. ");
INSERT INTO aey_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Age cunug Noa gami lein. Dool cunug cebac cobogina age lecislecis wag dunuh lein. ");
INSERT INTO aey_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Dool lein eu manahalca cufunecca odi lein. Age cunug Anut maden odi toodumeig wag dunuh lein. Odocob Anut hibilimega jic cebec menen. ");
INSERT INTO aey_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Aria mahana wa sil tubca cacaji ninijen deel 40 leceb wag u suldocob basai cobon. ");
INSERT INTO aey_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Odocob wa ben bahic cajimei mahana wa gudoc calen. Odimei wag u suldocob wa lal cobon. ");
INSERT INTO aey_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Wa mahana ben bahic ihoc timei aluh benben sao bisalu eu cunug jahuladen. ");
INSERT INTO aey_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Odimei wa 7 mita ohis aluh cunug u jebucaden. ");
INSERT INTO aey_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Odocob ceteteh cunug mahana cobogina age cal mein. Man fululec cunug dool mananca dool cusca cunug mamanig cunug mahana cobogina euca dana cunugca cal mein. ");
INSERT INTO aey_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ceteteh cunug mahana cocobi medemegana siwogina eu cunug cal mein. ");
INSERT INTO aey_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ceteteh cunug mahana cebac cobogina danaca doolca mamanigca man fululec saonadecca eu cunug Anut uqa mahanadec qee maden. Odocob Noa uqaca uqana sihulca age himec wagna bilein. ");
INSERT INTO aey_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Odocob deel 150 odi wa sil mahana caji nijen. ");
INSERT INTO aey_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Qa Anut uqa Noaca dool cusca dool mananca wagna bileinnu dahig qee celel. Eunu uqa odocob fufu oso mahana hon. Odocob wa sil seleldon. ");
INSERT INTO aey_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Odocob wa ben cehec maha dunuhnadecca saonadecca eu calena cebec eu cufa qon. Odocob wa sao ohisdec nen eu gatidon. ");
INSERT INTO aey_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Wa mahana nijen eu cebitnana seleldon. Odocob deel 150 hedocob wa toni non. ");
INSERT INTO aey_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Deel 17na jagel eben naha gic lecisca docna wag eu Ararat aluh osona toni bilen. ");
INSERT INTO aey_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Odocob wa haun cebitnana seleldodon li jagel eben nahanahaca on. Odocob jagel eu uqana deel sanan mecna aluh agena igoc camasac mein. ");
INSERT INTO aey_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Odocob deel 40 hedocob Noa fufu cebec uqa muden eu huden. ");
INSERT INTO aey_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Odimei uqa alog oso u suldocob nuen. Nuimei qa qee ceseli hol. Uqa fululi cocobon li wa mahana cunug sidon. ");
INSERT INTO aey_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Oodonqa Noa uqa cuhudid oso umei suldocob nuen. Uqa wa mahana seleldonfo qeefo eu dugiannu suldon. ");
INSERT INTO aey_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Qa wa maha cunugna nijen. Eunu cuhudid eu cudun oso hewi bibili jaen mudecnu qee fimei uqa haun wagna ceseli hon. Odocob Noa eben maha gumu leceb uqana cuhudid u wag dunuh ehi li muden. ");
INSERT INTO aey_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Odocob Noa uqa deel eben naha gic lecisca haun wa seleldugiannu sumuden. Odocob uqa cuhudid wagnadec haun u suldon. ");
INSERT INTO aey_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Wesu memen cuhudid eu ceseli uqaca hon. Uqa cona na oso, ijan oliw, eu bagac cebac u qada qu ahon. Odocob Noa uqa wa wele hidon eu don. ");
INSERT INTO aey_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Odocob Noa uqa deel eben naha gic lecisca hedocob uqa cuhudid haun suldon qa cuhudid eu uqaca qee ceseli hol. ");
INSERT INTO aey_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Saen Noa uqana cabi gel 601na jagel sanan mec eu uqana deel sanan mecna wa mahana cunug hidu qee men. Odocob Noa uqa wag ohis jahuldoc eu qosocdon. Noa meciimei maha tatacdec eu galalec ninijen fen. ");
INSERT INTO aey_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Saen deel 27na jagel lecis docna maha galal bahic en. ");
INSERT INTO aey_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Odocob Anut Noa madon, ");
INSERT INTO aey_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Wag culimeig caleiga. Hinaca hina melemenelca hina aidenca hina melemenel aidagailca caleiga. ");
INSERT INTO aey_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ceteteh cunug mahana cebac coboginaca man fululecca doolca mamanig cunug mahana coboginaca age agena sihul eu mahana geh bahic fulusdoqagannu cedadecem hina gami maha gumu caleiga. Odimeig maha cunug ihoc loqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Eunu Noa uqa maha gumu calen. Uqaca uqa melahulca uqa aidegca uqa melahul aidagailca age maha gumu calein. ");
INSERT INTO aey_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Dool cunug mamanig cunug man fululec cunug ceteteh cunug mahana cobogina eu cunug agena sihulnana qagocqagoc wag dunuhdec calein. ");
INSERT INTO aey_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Odocob Noa uqa Tibud ihandugia bili meenna ihanec cabal oso gualen. Odimei uqa dool qagoc eundecca man fululec qagoc eundecca osahicosahic cedadimei ihanec cabal euna Tibud ihandudu bili manen. ");
INSERT INTO aey_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Odocob Tibud uqa dedeman eu tinca don. Eunu uqadodoc waugna maden, “Dana age melnadec agena qisol cisdoc eu gaid odi nijina. Eunu hibna ija dananu maha haun qee geldugaun. Ceteteh cunug mahana cobogina eu qila fadaladiga odiwe haun qee fadaladigaun. ");
INSERT INTO aey_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mahana saen eu odi nijigian cehec saenca sab oc saenca duan saenca cam saenca san saenca wa saenca cahinegca witicca eu cunug qee qee meiaun,” en. ");
INSERT INTO aey_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Odocob Anut uqa Noaca uqa melahulca eelaadi bili maaden, “Age aig qumeig fulusdoigale. Odimeig maha cunug ihoc leigale. ");
INSERT INTO aey_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Dool cunug saonadec man fululec cunug wanadec dool cunug mamanig cunug mahana cobogina eu age cunug agenu cucuii teleloqagan. Ceteteh eu age cunug age ebenegana migina. ");
INSERT INTO aey_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Weleca ija celum himec jecnu adem. Qila ceteteh cunug mahana cebac cobogina euha agena sabnu adigina. ");
INSERT INTO aey_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Euqa golac eu cebac silig. Eunu age dool golacca cain jowain. ");
INSERT INTO aey_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Dana oso uqa oso qagadocob golac toni basecdocob cal mecebfi ija dana eu wadacdoc utigen. Dool oso uqa dana oso qocob cal mecebfi ija uqa wadacdu qocomin cal migian. ");
INSERT INTO aey_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ija ihoconi qumig dana ifanem. Eunu in oso dana oso qocob cal mecebfi uqadodocha dana age qocobil cal migian. ");
INSERT INTO aey_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Qa agenu eu odi age aig qumeig mati bahic caleigale. Age fulusdu mati bahic calimeig maha cunug ihoc leigale,” aden. ");
INSERT INTO aey_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Odocob Anut uqa Noaca uqa melahulca ha maaden, ");
INSERT INTO aey_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Aria feiga! Ija qila ageca agena sihul hibna cali hoqagan eucanu bal cehec je madigina. ");
INSERT INTO aey_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Euha man fululecca dool mananca dool cusca ceteteh cunug wagnadec cali hoiga euca ceteteh cunug mahana cebac cobogina eu ageca wagna bileiga eu agenu ha bal cehec je madigina. ");
INSERT INTO aey_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ija bal cehec je i edi madigina, ‘Ija ceteteh cunug mahana cebac cobogina eu wa sil haun qee fadaladigaun. Wa sil oso maha i haun qee bahic fadaldoiaun,’ igina. ");
INSERT INTO aey_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Bal cehec je i ijaca ageca ceteteh cunug mahana cebac cobogina euca gemo biligiannu migina. Bal cehec je i bileceb catanigian. Eu uqana gadac eu i hen. ");
INSERT INTO aey_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ija taenna wal cehegina. Euqa bal cehec je ija mahaca gemo biligiannu migina eu uqana gadac. ");
INSERT INTO aey_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ija taenna maha jahuldocomin wal saona caligian saen euna ");
INSERT INTO aey_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ija wa sil oso ceteteh cunug mahana cebac cobogina eu haun qee fadaladeiaun ec ageca dool cunugca maadiga eu cisdugen. ");
INSERT INTO aey_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Saen wal taenna caligian fimig ija bal cehec je ijaca ceteteh cunug mahana cebac cobogina euca gemo bileceb catanigian eunu cisdugen. ");
INSERT INTO aey_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Bal cehec je ijaca ceteteh cunug mahana cebac cobogina euca gemo biligiannu uqana gadac eu hen,” aden. ");
INSERT INTO aey_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Aria Noa uqa melahulca wagnadec cali hoin eu age ijanaga eu Sem, Ham, Jafetca. Ham uqa Kenan memeg. ");
INSERT INTO aey_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Mel ijed eu age Noa melahul. Odocob dana eu agenadec dana cajaca cunug sabijimeig fulusdocobil maha cunug ihoc len. ");
INSERT INTO aey_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Aria Noa uqa jehen cabi oc dana. Eunu uqa wain halu cabina cehimei aig cedimei wain wa muden. ");
INSERT INTO aey_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Saen osona wain wa muden eundec naha jimei dalul qon. Odocob uqa uqana lotoc tacec hulimei bical uqana lotoc talahna nijen. ");
INSERT INTO aey_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, uqa Kenan memeg, uqa memeg Noa bical ninijen fimei maha gumu cali limei waliagul lecis maalen. ");
INSERT INTO aey_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Qa Sem Jafetca ale lotoc oso umesi qatomolana huleldu hewimesi bicbic limesi memela jahuldosin. Ale memela bical nijen eunu qee felesin. Ale amala abes nuen. ");
INSERT INTO aey_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Odocob hibna Noa uqa wain jen eu dalul qoc hedocob uqa melah subig odudon eu wele don. ");
INSERT INTO aey_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Odocob uqa madon, “Hina melem, Kenan, geldugina. Uqa waliagul agena cabi dana biligian. ");
INSERT INTO aey_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Tibud Uqa Semna Anut. Eunu binan waseiale. Kenan uqa Semna cabi dana biliale. ");
INSERT INTO aey_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Anut uqa Jafetna sihul hatu ben utiale. Age Sem asagaca bileigale. Kenan uqa Jafetna cabi dana biliale,” don. ");
INSERT INTO aey_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Aria wa sil hedon eu Noa uqa cabi gel 350 odi bilen. ");
INSERT INTO aey_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Eunu Noa uqa mahana bilen eu cabi gel 950 eu hedocob uqa cal men. ");
INSERT INTO aey_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Aria Noa melahul Sem, Ham, Jafetca agena sihul je i edi. Wa sil cajen eu hedocob melamagail eu age aidagail mel haun basadein. ");
INSERT INTO aey_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafet melahul eu Gome, Megog, Madai, Jawan, Tubal, Mesek, Tirasca. ");
INSERT INTO aey_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gome melahul eu Asigenas, Rifat, Togamaca. ");
INSERT INTO aey_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Jawan melahul eu Elisa Tasisca. Dana sihul i age Kit Dodanica ageha Jawannadec. ");
INSERT INTO aey_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Sihul eunadec dana age bilisadumeig age lannaca nuinaca belein. Age bilisadumeig agena jobon medeh filfilnana hatu filfilnana je filfilnana qaguqagu belein. ");
INSERT INTO aey_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham melahul eu Kus, Isip, Put, Kenanca. ");
INSERT INTO aey_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus melahul eu Seba, Hawila, Sabta, Rama, Sabtegaca. Rama melahul eu Siba Dedanca. ");
INSERT INTO aey_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Aria Kus uqa melah oso ijan eu Nimrod. Nimrod mahana han cadecnu gelehinca calen. ");
INSERT INTO aey_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Uqa Tibud amegna dool qocnu ijanca calen. Eunu je oso odi madegina, “Nimrod cinigwe dool qoc dana ijanca Tibud amegna,” egina. ");
INSERT INTO aey_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Hahawan bahic uqa taun benben hewaden eu Sina mahana taun eu Bebel, Erek, Akadca. ");
INSERT INTO aey_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Maha eunadec uqa cajimei Asiria nuen. Odimei uqa ono Niniwa, Rehobot-ia, Kala, ");
INSERT INTO aey_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resenca cehaden. Resen eu Niniwa Kalaca gemo bilen. Kala eu taun ben bahic. ");
INSERT INTO aey_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Isip uqa dana sihul Lud, Anam, Lehab, Naftu, ");
INSERT INTO aey_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrus, Kaslu, Kaptoca asaga calen. Filistia age Kaptona sihulnadec calein. ");
INSERT INTO aey_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenan uqa melah matu eu Saidon. Kenan uqa melahul haun eu Het, ");
INSERT INTO aey_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebus, Amo, Girgas, ");
INSERT INTO aey_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwi, Aki, Sini, ");
INSERT INTO aey_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Awad, Sema, Hamatca. Agena sihul age asagail calein. Hibna Kenan uqana sihul age jobon medeh filfilnadec age bilisadumeig belein. ");
INSERT INTO aey_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Odocob Kenan agena maha gadac eu Saidondec sanan mimei nui Gasa gadac eu Gera isec euha Sodom, Gomora, Atma, Seboimca leceb Lasa gadac. ");
INSERT INTO aey_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Aria eu age Ham melahul. Age agena sihulnana agena jenana agena mahanana agena hatunana odi qaguqagu bilein. ");
INSERT INTO aey_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem ha melahulca. Uqa waliag matu eu Jafet. Hibru dana cunug age asaga eu Sem. ");
INSERT INTO aey_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem melahul eu Ilam, Asur, Apaksad, Lud, Aramca. ");
INSERT INTO aey_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram melahul eu Us, Hul, Geta, Masca. ");
INSERT INTO aey_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Sela memeg eu Apaksad. Ebe memeg eu Sela. ");
INSERT INTO aey_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebe uqa melahul lecisca. Oso ijan eu Peleg. Uqana saenna maha gadac qatani mati bahic calen. Eunu ijan odi qon. Uqa waliag ijan eu Joktan. ");
INSERT INTO aey_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan melahul eu Almodad, Seleb, Hasamawet, Jera, ");
INSERT INTO aey_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO aey_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimel, Siba, ");
INSERT INTO aey_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofia, Hawila, Jobabca. Dan eu age eu Joktan melahul. ");
INSERT INTO aey_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Maha age bilein eu Mesa sanan mimei leceb Sefa gadac. Eu hatu aluh mati bahic cam tobi becna isec. ");
INSERT INTO aey_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Aria dana eu age eu Semna sihul. Age agena sihulnana agena jenana agena mahanana agena hatunana odi qaguqagu bilein. ");
INSERT INTO aey_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aria eu age eu Noana sihul. Agena jobon medeh filfil. Age agena sihulnana agena hatunana odi qaguqagu bilein. Wa sil hedocob Noana sihulnadec dana cajaca mahana cunug bilegina eu calein. ");
INSERT INTO aey_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Aria weleca Nimrod bilen saenna mahamaha cunug agena je madec eu osol himec. Eu filfil qee. ");
INSERT INTO aey_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Dana cajaca eu age bili u cocobi bileig cam tobi becna isec belein. Bebeleig maha asou osona calein. Eu Sina agena hatu. Odimeig age ono bilein. ");
INSERT INTO aey_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Odocob age madocobmadocob imeig madein, “Gec, maha agam cedimeb jana manocomun gagadic mimei brik caligian,” ein. Age simen baial mimeig brik fagdudufagdudu nuein. ");
INSERT INTO aey_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Odocob age madein, “Gec hoiga. Ege egena taun ben oso cehecnu. Ege jo oso ohis bahic cehecnu. Uqana qab eu sao qududugian. Eufi ege qatani filigandumeb mahamaha cunug qee ihoc loqaun qa ege ijanigeca bilecnu,” ein. ");
INSERT INTO aey_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Odocob Tibud uqa dana eu age taun ben jo ohis bahic cecehegin tena eu figia bili nen. ");
INSERT INTO aey_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Odimei uqa maden, “Feiga! Dana i age age sihul osol. Age cunug je osolca. Age cabi i odoqagannu sanan mi odogina eu odoqagan. Age qila cel oso odoqagannu nalug mifeig age odocobil ihoc himec ligian. ");
INSERT INTO aey_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Age odi odowainnu ege ono numeb agena je ihulduadecnu. Eufi age agena je madec eu docobdocob qee owain,” en. ");
INSERT INTO aey_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Eunu Tibud uqa filiganadeceb age onodec bilisadumeig mahamaha cunug ihoc lein. Odimeig age taun ben eu cehec culein. ");
INSERT INTO aey_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Odocob ono Tibud uqa mahamaha cunug agena je qu ihulahalduadimei filiganadeceb age bilisadumeig mahamaha cunug ihoc lein. Eunu jobon eu ijan Bebel doin. ");
INSERT INTO aey_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Semna sihul agena je eu odi. Aria wa sil hedocob cabi gel lecis nueceb Sem uqana cabi gel eu 100 eu odi ihoc leceb uqa aideg mel oso basen. Uqa ijan Apaksad qon. ");
INSERT INTO aey_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Odimei Sem bibilen li haun cabi gel 500 bilen. Oodon Sem aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Aria Apaksad uqa bibilen li uqana cabi gel eu 35 eu odi ihoc leceb uqa aideg mel oso basen. Uqa ijan Sela qon. ");
INSERT INTO aey_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Odimei Apaksad bibilen li haun cabi gel 403 bilen. Oodon Apaksad aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Aria Sela uqa bibilen li uqana cabi gel eu 30 eu odi ihoc leceb uqa aideg mel oso basen. Uqa ijan Ebe qon. ");
INSERT INTO aey_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Odimei Sela bibilen li haun cabi gel 403 bilen. Oodon Sela aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Aria Ebe uqa bibilen li uqana cabi gel eu 34 eu odi ihoc leceb uqa aideg mel oso basen. Uqa ijan Peleg qon. ");
INSERT INTO aey_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Odimei Ebe bibilen li haun cabi gel 430 bilen. Oodon Ebe aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Aria Peleg uqa bibilen li uqana cabi gel eu 30 eu odi ihoc leceb uqa aideg mel oso basen. Uqa ijan Reu qon. ");
INSERT INTO aey_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Odimei Peleg bibilen li haun cabi gel 209 bilen. Oodon Peleg aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Aria Reu uqa bibilen li uqana cabi gel eu 32 eu odi ihoc leceb uqa aideg mel oso basen. Uqa ijan Serug qon. ");
INSERT INTO aey_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Odimei Reu bibilen li haun cabi gel 207 bilen. Oodon Reu aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Aria Serug uqa bibilen li uqana cabi gel eu 30 eu odi ihoc leceb uqa aideg mel oso basen. Uqa ijan Neho qon. ");
INSERT INTO aey_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Odimei Serug bibilen li haun cabi gel 200 bilen. Oodon Serug aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Aria Neho uqa bibilen li uqana cabi gel eu 29 eu odi ihoc leceb uqa aideg mel oso basen. Uqa ijan Tira qon. ");
INSERT INTO aey_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Odimei Neho bibilen li haun cabi gel 119 bilen. Oodon Neho aideg melahul ategulca haun basaden. ");
INSERT INTO aey_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Aria Tira uqa bibilen li uqana cabi gel eu 70 eu odi ihoc leceb uqa melahul ijedca. Ijanaga eu Ebram, Neho, Haranca. ");
INSERT INTO aey_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Aria Tirana sihul agena je eu odi. Tira uqa melahul ijedca. Eu Ebram, Neho, Haranca. Haran uqa Lot memeg. ");
INSERT INTO aey_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Aria Tira cebac bibilen Haran uqa cal men. Uqa anag basen maha euna cal men. Eu ijan Ur. ");
INSERT INTO aey_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aria Ebram Nehoca ale caja cedesin. Ebram aideg ijan eu Sarai. Neho aideg ijan eu Milka. Milka uqa Haran ateg. Iska uqaha Haran ateg. ");
INSERT INTO aey_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Odonqa Sarai uqa goud. Uqa melca qee. ");
INSERT INTO aey_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Odocob Tira uqa melah Ebramca Haran melah uqa asag Lotca Ebram aideg Saraica ehadeceb age Kaldia hatu ijan Ur eu culimeig Kenan hatuna beloqagannu belein. Belimeig li age Haran hatuna calein. Odimeig age ono bilein. ");
INSERT INTO aey_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Odocob Tira uqa Haran ono cal men. Uqana cabi gel cunug eu 205 odi. ");
INSERT INTO aey_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Aria Tibud uqa Ebram madon. “Hina memenca hinana sihulca hinana hatuca culimeg hatu ija ihachigen euna nuuga. ");
INSERT INTO aey_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Odocom ija odocomin hinana sihul eu mati bahic caloqagan. Ija eelhigen. Ija binainca mihigen. Odocob hina binainnu mati bahic age eeldoc oqagan. ");
INSERT INTO aey_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Dana hina eelhigian eu ija eeldugen. Qa in oso hina gelihigian eu ija geldugen. Hinanu himec mahamaha sihul cunug age eeldoc oqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Ebram uqa Anutna je dah men saen euna uqana cabi gel eu 75. Aria Ebram uqa Anutna je toodumei uqa aideg Saraica uqa waliag melah Lotca uqana cabi dana Haran ono cedaden euca uqana ceteteh cunug ono ceden euca cunug cedimei Haran hatunadec culimei Kenan hatuna nuen. Uqa jicna niji u nui Kenan hatuna calen. ");
INSERT INTO aey_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Odocob Ebram uqa Kenan hatuna calimei cocobi bili u nui maha oso ijan Sekem ono calimei More uqana na ben gun oso gugna calen. Aria saen euna Kenan dana age maha euna bibilegin uqa ono calen. ");
INSERT INTO aey_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Odocob Tibud uqa ono Ebram amegna camasac mimei madon, “Maha i hinana sihul adigen,” don. Odocob uqa ono Tibud camasac menna uqa Tibud ihandocnu meen cabal oso gualen. ");
INSERT INTO aey_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Odimei uqa onodec haun cajimei cam tobi becna isec aluh oso Betel cemenug nijia euna nuen. Uqa cudun euna uqa lotoc talah cehen. Betel eu cam toni nocna isec ninijen Ai eu cam tobi becna isec nijia. Uqa gemo euna Tibud ihandocnu meen cabal oso gualen. Odimei uqa Tibud ijan u bili ihandon. ");
INSERT INTO aey_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Uqa onodec haun cajimei cocobi bili nui Negew isec nuen. ");
INSERT INTO aey_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Aria saen euna maha euna cahel saen ben calen. Eunu Ebram uqa Isip biligiannu onoca nuen. ");
INSERT INTO aey_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Nuimei Ebram uqa Isip calecnu dodoldudu bili uqa aideg Sarai madon, “Faga! Hina caja jaca eu ija dugina. ");
INSERT INTO aey_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Saen Isip dana age hina mecihimeig age i uqa aideg ec cisdoqagan. Odimeig age ija qagatimeig hina oihuqagan. ");
INSERT INTO aey_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Eunu hina uqa ija cebinami ec odi maadagale. Hina eu odi maadecemfi ija culitimeig me eeltoqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Odocob Ebram Isip ono caleceb Isip dana age aideg mele uqa caja jaca bahic eu fein. ");
INSERT INTO aey_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Odocobil Fero uqana cabinu ilo dana age caja eu fimeig Fero caja eu galeca bahic madocnu lein. Eunu caja eu ehudi Ferona jona lein. ");
INSERT INTO aey_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Fero uqa Sarainu dumei uqa Ebram eeldu cuhadon. Odimei uqa sipsipca memeca bulmakauca cesel manahal cufunecca cabi dana cajaca kamelca cedadi Ebram uton. ");
INSERT INTO aey_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Oodonqa Fero uqa Sarai on eunu Tibud uqa hag me qee me qee suldon. Odocob Feroca dana caja cunug uqana jona bilegina euca age hag me qee eu hewaden. ");
INSERT INTO aey_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Odocob Fero Ebram utadocob hocob madon, “Celnu kobol i oditem? Celnu hina uqa hina aiden ec qee matelem? ");
INSERT INTO aey_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Celnu hina uqa ija cebinami ec matem? Ija uqa aideninu imig om eu celnu qee cahactelem? Aria hina aiden i hen. Umeg nuuga,” don. ");
INSERT INTO aey_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Odimei uqana dana maadeceb age Ebramca uqa aidegca uqana ceteteh cunugca odi ehadi ehi nui maha gadacna culadein. ");
INSERT INTO aey_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Aria ono Ebram uqa cehewan ben bahicca. Uqa sipsipca memeca bulmakauca golca silwaca. Odocob Ebram uqa aidegca Lotca uqana ceteteh cunugca cedimeig Isip culimeig Negew tein. ");
INSERT INTO aey_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Onodec uqa Negew culimei cocobicocobi nui Betel ono calen. Maha euna uqa hahawan lotoc talah cehennu euqa Betel Aica gemo. ");
INSERT INTO aey_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Cocobi li uqa hahawan ihanec meen cehenna ono calen. Odimei cudun euna uqa Tibud ijan u binan sulen. ");
INSERT INTO aey_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Aria Lot uqa Ebramca belesin. Uqaha sipsipca memeca bulmakauca uqana cabi danaca. ");
INSERT INTO aey_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Qa ale alena ceteteh eu mati bahic eunu maha eu ale osoben gabandu bilecnu ihoc qee. ");
INSERT INTO aey_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Eunu Ebramna dool cofadec danaca Lotna dool cofadec danaca gemo fee dadanec calen. Aria saen euna Kenan danaca Peres danaca age maha euna bilein. ");
INSERT INTO aey_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Odocob Ebram Lot madon, “Odi cain. Ele cotigcotig. Eunu ele fee dadan ecebeceb qee owaun o ijana dool cofadec danaca hinana dool cofadec danaca ageha qee fee dadanowain. ");
INSERT INTO aey_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Maha cunug eu me himec nijia fagana. Eunu cois ele filigandowan. Ansecna isec nuecemfi ija meulana isec nuigen. Qa hina meulana isec nuecemfi ija ansena isec nuigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Odocob Lot ameg suli umei Jodan maha asou leceb Soa maha eu cunug fen. Maha eu cunug wa uti cuhadoc nijen. Maha eu Tibudna cabi cinigwe eu Isip agena maha cinigwe. Saen euna Tibud uqa Sodom Gomoraca qee fadalalec ninijen. Eu ale ihoc nijesin. ");
INSERT INTO aey_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Eunu Lot uqa uqadodocnu Jodan maha asou cunug nesilen. Odocob uqa cam tobi becna isec nuen. Ale eu odi filigandosin. ");
INSERT INTO aey_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ebram uqa Kenan mahana bilen. Oodon Lot uqa jobon benben maha asou euna nijegina ono age gemo nui bilen. Odocob uqa li Sodom cemenug uqana lotoc talah cehen. ");
INSERT INTO aey_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Aria Sodom dana age qisol jaumadec. Age Tibud amegna silail dana bahic. ");
INSERT INTO aey_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Saen Lot Ebram culdi nueceb Tibud uqa Ebram madon, “Amen suli umeg cudun hina tawaganadec hagen cunugna isec meciecem nuia. ");
INSERT INTO aey_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ija hinaca hinana sihulca maha cunug fagana eu adigen. Agena gaid biligiannu adigen. ");
INSERT INTO aey_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Odocob ija odocomin hinana sihul eu bobos cinigwe fulusdugian. Eunu in oso bobos saniecnu ihocfi hinana sihulha saniecnu ihoc. ");
INSERT INTO aey_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Cajaga. Maha i ija hina ihigen eu cocobi nui cunug faga,” don. ");
INSERT INTO aey_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Eunu Ebram uqana lotoc talah wagalimei cocobi nui Mamri uqana na benben gugna calen. Ono Hebron cemenugca bilen. Odimei uqa ono ihanecnu meen cabal gualen. ");
INSERT INTO aey_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","8","Aria saen euna dana ben oso bilen uqa ijan Kedoleoma. Uqa Ilam agena king. Wele Kedoleoma uqa king ebum oso cadadimei ilo bilen. King ebum oso i age eu odi. Sodom agena king Beraca Gomora agena king Birsaca Adma agena king Sinabca Seboim agena king Semebaca Bela agena kingca. Kedoleoma uqa cabi gel 12 eu odi king ebum oso agena ilo bilen. Odocob cabi gel 13 docna king eu age Kedoleoma feedoin. Odocob cabi gel 14 docna Kedoleoma uqana danah king ijedca gami gabandoin. King ijed i age eu odi. Sina agena king Amrafelca Elasa agena king Ariokca Goim agena king Tidalca. Kedoleoma king ijedca agena han dana cedadimeig jicna bebeli bileig Refaim dana age Asterot-kanaim ono bibilegin aqadein. Odimeig age Susim dana Ham onoha aqadein. Odimeig Emim dana Kiriataim onoha aqadein. Odimeig Ho dana age Sia agena hatu aluhca jabadi ehi nui El-paran gadac ono aqadein. El-paran eu wadau naca qee cemenug nijia. Odimeig age haun ceselein. Ceseli humeig En-misbat ono calein. En-misbat eu Kades. Odimeig ono han cadimeig Amalek agena hatu eu cunug oin. Odimeig Amo age Hasason-tema ono bilein euha aqimeig hatu eu oin. Aria Sodom agena kingca Gomora agena kingca Adma agena kingca Seboim agena kingca Bela eu Soa agena kingca age wele gabandoin. Age Kedoleomaca uqana han danaca aqadecnu sacia dumeig gabandu Sidim maha asouna ono cali hoin. Sidim eu wa macasca bahic cudun. ");
INSERT INTO aey_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Age Ilam agena king wal oso i age han cadoqagannu cajein. Ilam agena king eu Ilam agena king bahic Kedoleomaca Goim agena king Tidalca Sina agena king Amrafelca Elasa agena king Ariokca. Eu king wal oso age king ebum oso gami han cadoqagannu cajein. ");
INSERT INTO aey_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Aria Sidim asou eu maha baial. Helo mati bahic euna gag bibi nijen. Odocob Sodom Gomoraca alena king hannu bubusali bilesi helo euna nosin. King ijed ale culadesin euha busalein qa age aluhna belein. ");
INSERT INTO aey_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Odocobil king wal oso age Sodom Gomoraca agena ceteteh cunugca agena sab cunugca cedimeig belein. ");
INSERT INTO aey_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ebram melah Lot uqa Sodom ono bilen uqaha ehudimeig uqana ceteteh cunug cedimeig belein. ");
INSERT INTO aey_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Aria Ebram uqa Mamri Amodec uqana na benben gugna bilen. Mamrica uqa waliagul Eskol Aneca age Ebramna danah. Odimei Ebram bibilen dana oso hannadec busali humei Hibrudec Ebram madocob don. ");
INSERT INTO aey_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Odimei uqa uqana sihul eundec u hewi nueiga ec dah mimei uqa uqana cabi dana 318 eu hannu wele iwaladec eu age uqana jobon bilein cedadeceb age tooadi beli Dan ono calein. ");
INSERT INTO aey_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Uqa witic euna uqana dana qataneceb uqa uqana cabi danaca age aqimeig jabadi ehi nui Hoba ono calein. Eu Damaskas taun hagen ono isec. ");
INSERT INTO aey_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Odimei Ebram uqa melah Lotca uqana cajaca uqana ceteteh cunugca dana cajaca king wal oso agena ceteteh cedein eu cawaladi cedimei ceselen. ");
INSERT INTO aey_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Aria Ebram uqa Kedoleoma king leih uqaca gabandoin eu hanna aqimeig ceselein. Eu hedumei ceseli limei Sawe maha asouna ono calen. Sawe eu ijan oso King Agena Maha Asou. Ono Sodom agena king Ebram gulucdon. ");
INSERT INTO aey_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ono Melkisedek Salemdec king uqaha Ebram gulucdon. Melkisedek uqa Anut Ohis Bahic uqana gemo tawec ihanec dana Ebram eeldoc je madugiannu bret wainca hewimei li gulucdon. ");
INSERT INTO aey_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Odimei uqa Ebram eeldudu madon, “Anut Ohis Bahic uqa sao mahaca ifanen eu Ebram eeldoiale. ");
INSERT INTO aey_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Anut Ohis Bahic hina cesulheceb han wooldoga eu binan suleqale,” don. ");
INSERT INTO aey_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Odocob Ebram ceteteh cunug ila meceb li am 10 calen. Odocob 10 eundec osahic eu Melkisedek uten. Odocob Sodom agena king uqa Ebram madon, “Dana cajaca ija iiteg ceteteh eu hina cedega,” don. ");
INSERT INTO aey_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Odocob Ebram Sodom agena king madon, “Anut Ohis Bahic uqa sao mahaca ifanen eu uqa amegna wele je cagu madiga. ");
INSERT INTO aey_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ija hinana ceteh oso qee ugaun. Halu wegecfo jaimiga tacec halufo qee ugaun. Hibna hina ija Ebram cehewanca mudem ec madagaun. ");
INSERT INTO aey_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ijadodocnu ija ceteh oso qee ugaun. Ijana dana sab jein eu cois agena ceteteh eu himec ugen. Qa ijana danah Ane, Eskol, Mamrica eu age age mugumuga mec eu himec cois oqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Odocob ceteteh i hedocob Tibud uqana je ola codocna Ebramca humei madon, “Ebram hina cain cucuiagaun. Ija hina cofhi cuhadumig hina wadacdoc ameg ben bahic ihigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Qa Ebram jejeg hewi madon, “O Tibud ijana Ben ija melca qee. Hina adi wadacdoc ameg ben bahic itegan? Ija cal meceminfi ija cehewani eu Eliesa Damaskasdec ugian. ");
INSERT INTO aey_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Mel oso qee itelemnu eunu cabi dana oso ijana jona bilia cehewani eu ugian,” don. ");
INSERT INTO aey_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Odocob Tibud uqa Ebram haun madon, “Cabi dana i hina cehewain qee oiaun qa hinadodoc melem uqa hina cehewain eu ugian,” don. ");
INSERT INTO aey_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Odimei Tibud uqa Ebram ehudeceb maha gumu cali lesin. Odimei madon, “Faga! Saona isec meciimeg malaqa sicanadaga. Hina sicanadecnu ihocfa hinana sihul ha malaqa nijia eu odiwe nijigian,” don. ");
INSERT INTO aey_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Odocob Ebram Tibudna jenu meleen. Eunu Tibud uqa Ebram gale docob uqa dana ititom don. ");
INSERT INTO aey_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Odimei uqa madon, “Ija Tibud. Ija maha i ihecemin hinana biligiannu Ur Kaldia agena hatunadec ehihi ahom,” don. ");
INSERT INTO aey_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Qa Ebram sisildon, “O Tibud ijana Ben maha i ijana biligian eu adi dugen?” don. ");
INSERT INTO aey_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Eunu Tibud uqa jejeg hewi madon, “Hina bulmakau osoca meme osoca sipsip manahal osoca agena cabi gel ijed doc eundec cedi ahutuga. Euha cuhudid lecisca eu odi cedi ahutuga,” don. ");
INSERT INTO aey_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Odocob Ebram uqa ceteteh eu age cedimei Anutca ahon. Odimei uqa dool eu cunug qatani lecis aali helen. Odimei uqa nahanaha eu am lecisna mealen. Qa cuhudid eu qee tuqalel. ");
INSERT INTO aey_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Odocob alog leih age nimeig cuhun joqaga bili odocobil qa Ebram jabadeceb belein. ");
INSERT INTO aey_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Odi oodon am tonen. Oodon Ebram uqa us docob cal mecwe bahic nijen. Uqa eu odi ninijen uqa ceteh ola odocna cinigwe fimei ben bahic cucuien. ");
INSERT INTO aey_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Odocob Tibud uqa Ebram odi madon, “Hina du cuhadogale. Hinana sihul eu age cele agena mahana jag biluqagan. Odimeig age cabi dana gauc biluqagan. Odocobil cele dana age me qee mamadebil li cabi gel 400 ugian. ");
INSERT INTO aey_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Qa cele dana eu age kobol eu odi odoqagan ija wadacadigen. Odocomin hina jajainel age hatu eu cuculeig ceteteh mati bahic cedi hewi beloqagan. ");
INSERT INTO aey_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Euqa hina bibili li toia mimeg hina wawin bodoecca cal mecem hel cisihuqagan. ");
INSERT INTO aey_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Hinana sihul eu maha ina mahuc qee ceseli howain. Amo sihul age maha ina bilegina kobol me qee mati bahic eu qee odi hedoc nijia. Cabi gel 400 leceb age odi hedocobil aria ija age gagadic wadacadimig maha inadec ititacadigen. Odocomin saen euna hina jajainel ene ceseli hoqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Aria cam casileceb tu gihodon. Oodon hal jaca oso calen. Oodon ceial ja belicanca osoha calen. Odimesi ale dool am lecis aali na naha mealec eu gemo cobosin. ");
INSERT INTO aey_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Witic euna himec Tibud uqa Ebram bal cehec je madumei madon, “Maha i cunug ija hinana sihul adigen. Eu uqana gadac eu Isip agena wanadec nueceb wa ben Jufretis gadac. ");
INSERT INTO aey_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Age Ken agena mahaca Kenis agena mahaca Kadmon agena mahaca ");
INSERT INTO aey_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het agena mahaca Peres agena mahaca Refaim agena mahaca ");
INSERT INTO aey_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amo agena mahaca Kenan agena mahaca Girgas agena mahaca Jebus agena mahaca eu cunug adigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Aria Ebram Kenan mahana bibilen cabi gel 10 hedocob Sarai Ebram aideg uqa Ebram mel oso qee basitol. Qa uqa Isipdec cabi caja osoca. Uqa ijan Hega. Eunu Sarai Ebram madon, “Faga! Tibud uqa ija mel cain basigaunnu wawi jic menen. Eunu hina ijana cabi cajaca lecem nijesia. Ija mel uqanadec ugenfa,” don. Odocob Ebram Saraina je don. Odocob Sarai Ebram aideg uqa Hega uqana cabi caja Isipdec ehudi ehi li uqa aideg biligiannu gemug Ebram uten. ");
INSERT INTO aey_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Odocob uqa Hegaca nijimesi Hega uqa melca men. Odocob Hega uqa melca fimei uqa culaug ocob Sarai cewudoloi. ");
INSERT INTO aey_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Odocob Sarai uqa Ebram madon, “Hega ija cewitina eu hinana cahuldoc. Ijadodoc ijana cabi caja ihem qa uqa melca mimei uqa cewitina. Ija cahuldomfo qee hina cahuldomfo? Tibud uqa tem li figian,” don. ");
INSERT INTO aey_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Odocob Ebram uqa Sarai jejeg hewi madon, “Faga! Hinana cabi caja eu hina ebenna bilia. Hina adi odudegannu gale hena eu odudoga,” don. Odocob Sarai uqa galac mecna isec cabi culumencaca uten. Odocob Hega uqa Sarai amegnadec busalen. ");
INSERT INTO aey_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Aria odocob Tibudna ensel uqa Hega wadau naca qeena wa tut cemenug bibilen gulucdon. Wa tut eu Sur nuec jicna. ");
INSERT INTO aey_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Odimei uqa madon, “Hega, Saraina cabi caja, hina anadec hoga? Odeia hina ana nuuguna?” don. Odocob uqa maden, “Ija ijana ben Sarai amegnadec busaligina,” en. ");
INSERT INTO aey_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Odocob ensel uqa madon, “Ceseli hinana benca nuuga. Odimeg uqa co toodu odoga,” don. ");
INSERT INTO aey_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Odimei uqa haun madon, “Ija hinana sihul eu odadecemin mati bahic fulusdoqagan. Eu oso sicani madecwe qee. ");
INSERT INTO aey_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Faga! Hina mel oso basegan. Tibud uqa hinana culumennu wawin qajena eu dah meia. Eunu hina uqa ijan Ismal qogan. ");
INSERT INTO aey_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Qa uqa cesel cus cinigwe cocobi biligian. Uqa dana cunug cad madigian. Odocob dana cunug age uqa cad muduqagan. Odocob uqa cotugul gami gidod biluqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Odocob Hega uqa uqadodoc waug maden, “I mele bahicfo? Anut ija gaid mecitina eu figaqa ija cebac biliga,” en. Eunu uqa Tibud ijan Anut Mecitina qon. ");
INSERT INTO aey_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Eunu wa tut hunec eu Kedes Beretca gemo nijia age “Oso Cebac Bilina Uqa Mecitina Uqana Wa Tut,” ec madegina. ");
INSERT INTO aey_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Odocob Hega mel oso basen. Odocob Ebram uqa mel eu ijan Ismal qon. ");
INSERT INTO aey_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Saen euna Ebram uqana cabi gel eu 86 odi. ");
INSERT INTO aey_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Aria saen Ebram uqana cabi gel 99na Tibud uqa Ebraham amegna calimei madon, “Ija Anut Gagadic Bahic. Ija amina ititom coboga. ");
INSERT INTO aey_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ijana bal cehec je ijaca hinaca gemo mudigen. Ija odocomin hinana sihul eu gadacca qee fulusdugian,” don. ");
INSERT INTO aey_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Odocob Ebram uqa maha cotadon. Oodon Anut madon, ");
INSERT INTO aey_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Bal cehec je eu i edi mudigina. Hina hatu mati bahic age asaga calegan. ");
INSERT INTO aey_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ija hina hatu mati bahic age asaga mihigen. Eunu hina haun ijain Ebram qee howain qa hina ijain Ebraham hoqagan. ");
INSERT INTO aey_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ija odadecemin hinana sihul mati bahic caloqagan. Leih age king caloqagan. Ija odadecemin hinana sihul hatu filfil caloqagan. ");
INSERT INTO aey_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Bal cehec je eu bileceb catanecnu mudigen. Euqa ijaca hinaca gemo biligian. Hinana sihul hibna cali hoqagan eu age gemo ha biligian. Bal cehec je eu odi. Ija hinana Anut biligen. Hinana sihul hibna cali hoqagan eu agena Anut ha biligen. ");
INSERT INTO aey_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Qila hina Kenan hatuna jag biliga. Qa hatu i cunug eu hinana biligiannu ihigen. Hinana sihul cunug hina toohi cali hoqagan, eu ha agena biligiannu, adigen. Euqa ageca bileceb catanigiannu adigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Odocob Anut haun Ebraham madon, “Aria hinanu je qa odi. Hina ijana bal cehec je eu hewec bahic hewaga. Hinana sihul hibna hina toohi cali hoqagan eu age ha hewec bahic hewoqagan. ");
INSERT INTO aey_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Bal cehec je eu hinaca hinana sihulca biligian eu odi. Hinana sihulna manahal cunug eu mel simca dana cunugca deweg gaga qoc bahic qoqagan. ");
INSERT INTO aey_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Hinana sihul hibna cali hoqagan eu manahal cunug eu mel simca dana cunugca deweg gaga qoqagan. Mel sim cunug basecebil deel eben naha gic ijedca hedocob age deweg gaga qoc bahic qoqagan. Hinana jona cabi dana cunug cali hoqagan euca hinana sihul qee hinana begabeg ageca deweg gaga qoqagan. Hina deweg gaga qogan. Euqa bal cehec je ija hinaca gemo bilia eu uqana gadac. ");
INSERT INTO aey_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Cel cabi dana hinana jona cali hugian o begabeg age deweg gaga qoc bahic qoqagan. Eunu ijana bal cehec je eu age dewenegana biligian. Eu bal cehec je bileceb catanigiannu gadac. ");
INSERT INTO aey_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Odocob manahal oso uqa deweg gaga qee qolfi uqana sihulnadec ijan qetoqagan. Uqa ijana bal cehec je eu qee toodol,” don. ");
INSERT INTO aey_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Odocob Anut uqa Ebraham madon, “Hina aiden, ijan Sarai, eu haun Sarai qee dogaun qa qila hina uqa ijan Sera dogan. ");
INSERT INTO aey_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Odocob ija uqa eeldocomin uqa mel oso basihigian. Odocob Sera uqa hatuhatu age asaga caligian. Dana eu age leih king caloqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Odocob Ebraham uqa gob cehi bilimei jogoinu olana maha cotadudu bili asalen. Odimei uqa waugna maden, “Dana ija edec ijana cabi gel 100 ija golaninadec mel oso cali hocnu ihocfo? Odocob Sera uqana cabi gel eu 90 uqa mel oso basecnu ihocfo?” en. ");
INSERT INTO aey_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Odocob Ebraham uqa Anut sisildon, “Ismal uqa ija melami eeldocomin biligian ihocfo?” don. ");
INSERT INTO aey_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Odocob Anut madon, “Ao, euqa hina aiden Sera uqa mel oso basihigian. Odocob hina uqa ijan Aisak qogan. Odocob ijana bal cehec je eu uqaca mudigen. Euqa uqana sihul hibna cali hoqagannu mudigen. Bal cehec je eu bileceb catanigiannu mudigen. ");
INSERT INTO aey_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Aria Ismalnu je madaga eu ija dah mihiga. Faga! Ija uqa eeldocomin uqana sihul mati bahic fulusdoqagan. Uqana sihul eunadec hatu ilo 12 caloqagan. Uqana sihul hatu ben oso caligian. ");
INSERT INTO aey_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Hina melem, Aisak, saen i edina cabi gel osona Sera basihigian. Euqa ijana bal cehec je eu hina melem Aisakca mudigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Saen Anut uqa Ebrahamca je madi hedumesi uqa culdimei ohis ti nuen. ");
INSERT INTO aey_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Odocob deel euna himec Ebraham uqa Anut madon eu toodu odon. Uqa melah Ismalca uqana cabi dana uqana jona cali hoin euca uqana begabeg ageca deweg gaga aqaden. Uqana tal manahal eu cunug deweg gaga aqaden. ");
INSERT INTO aey_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Aria Ebraham uqa uqana cabi gel 99na uqa deweg gaga qon. ");
INSERT INTO aey_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Uqa melah Ismal uqana cabi gel 13na uqa deweg gaga qon. ");
INSERT INTO aey_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ebraham uqa melah Ismalca ale deel euna himec deweg gaga qosin. ");
INSERT INTO aey_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Dana uqana jona cali hoinca begabeg ageca dana cunug Ebrahamca bilein age Ebraham gami deweg gaga qoin. ");
INSERT INTO aey_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Aria Tibud uqa Ebrahamca camasac men. Saen euna Ebraham uqa Mamrina na gug benbenna lotoc talah cehi bilen. Cam eu gagadic tatawen Ebraham uqa lotoc talah cebecna bilen. ");
INSERT INTO aey_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Bibilen uqa ameg suli umei dana ijed cemenug tatawegin meciaden. Saen Ebraham meciadimei uqa lotoc talah cebec culimei dana ijed gulucadecnu gudugudui len. Odimei uqa gob cehi bilimei jogoi nu maha cotadudu bili ");
INSERT INTO aey_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","maaden, “Ijana ben ija age amagana tawecemin gale adenafi agena ewel dana cain wooldu belowain. ");
INSERT INTO aey_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Age wa nag oso ahocobil jaimiga cuseigale. Odocob age na salu jaen mudeigale. ");
INSERT INTO aey_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ija sab oso saciaduadigen. Odocob age gagadic odoc umeig coboqagan. Age agena ewel danaca wele hoiga. Eunu ija loo adigennu culiteigale,” aden. Odocob age madoin, “Cois hina madaga eu odi odogale,” doin. ");
INSERT INTO aey_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Odocob Ebraham uqa mahucwe lotoc talah dunuh limei Sera madon, “Hina mahucwe plaua uqana culumen eu 14 kilo odi umeg ibuldumeg managa,” don. ");
INSERT INTO aey_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Odocob Ebraham uqa guguli bulmakau gelna len. Odimei uqa bulmakau nag oso eu uqa cuhun jecnu bodoec umei uqana cabi dana uten. Odocob cabi dana uqa bulmakau eu mahuc bahic cilecnu saciadugia bili nuen. ");
INSERT INTO aey_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Odocob uqa bulmakauna su muhuc qagocca su haunca bulmakau nag cili saciadon euca ahu miaden. Odimei age jejegin uqa gesacna na salu meciadi tawen. ");
INSERT INTO aey_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Odocob age sisildoin, “Hina aiden Sera ai?” doin. Uqa jejenega hewi maaden, “Uqa lotoc talah dunuh bilia,” aden. ");
INSERT INTO aey_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Odocob dana oso uqa Ebraham madon, “Mele bahic saen ina cabi gel oso euna ija hinaca ceseli hugen. Euqa hina aiden Sera uqa mel oso wele basigian,” don. Aria Sera uqa lotoc talah cebecna dah mimi bilen. ");
INSERT INTO aey_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Aria Ebraham Seraca ale wele toia mesin. Alena cabi gel eu mati bahic. Sera uqana jagel qoc saen eu wele hedon. ");
INSERT INTO aey_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Eunu Sera uqa uqadodoc waug dunuhna asali bili maden, “Ija wele toia mem. Gemuni ha wele toia men. Gemunica nijimeu ija wawi migenfo?” en. ");
INSERT INTO aey_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Odocob Tibud uqa Ebraham madon, “Eu adi Sera uqa asali bili ija toia bahic eu mele bahic ija mel basigenfo ec madeia? ");
INSERT INTO aey_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ceteh oso eu ija odocnu ija ihoc qeefo? Ija cabi gel osona hinaca ceseli hugen. Saen euna Sera uqa mel oso wele basigian,” don. ");
INSERT INTO aey_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Odocob Sera uqa cucuiimei maden, “Ija qee asalelem,” en. Odocob uqa madon, “Qeeo, hina asalaga,” don. ");
INSERT INTO aey_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Aria dana age beloqaga bili cajimeig age Sodom isec meciecebil non. Odocob Ebraham uqa culadeceb beloqaga bili osoben cocobi lein. ");
INSERT INTO aey_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Odocob Tibud uqa uqadodoc waug maden, “Ija ceteh oso odige bili eu Ebraham ameg jahundi odigenfo qeefo? ");
INSERT INTO aey_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Mele bahic Ebraham uqa uqana sihul hatu oso binanca caligian euha gagadic odocca. Odocob Ebraham sihul hatu cunug age eeldoc oqagan. ");
INSERT INTO aey_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ebraham melahulca uqana sihulca Anutna je toodocnu maadigian eunu Ebraham nesiludem. Euha Ebraham age ititom odocnuca me odocnuca dado madigian. Age odi odocobilfi ija Ebrahamnu je cunug madem eu odigen,” en. ");
INSERT INTO aey_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Odocob Tibud uqa maden, “Sodom Gomoraca qisol ben bahic mesina dah miga. ");
INSERT INTO aey_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Eunu ija noc bahic numig Sodom Gomoracanu madegina eu melefo qeefo figen,” en. ");
INSERT INTO aey_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Odocob dana lecis ale waldumesi Sodom isec belesin. Ale bebelesin Ebraham uqa Tibud olana tawen. ");
INSERT INTO aey_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Odocob Ebraham uqa Tibud cemenug limei madon, “Hina dana ititomca qisol mecca osoben tetec golisdocwe golisadeganfo? ");
INSERT INTO aey_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Dana ititom 50 taunna bilecebilfi hina eu cunug tetec golisdocwe golisadeganfo? Dana ititom 50 bileiga eunu taun qee fadaldogaunfo? ");
INSERT INTO aey_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Hina dana ititom qisol mec danaca gabanadi qee madegafi euqa hinana kobol qee. Eu odi odogaqa hina dana ititom qisol mecca osoben ihocihoc odadegan. Eu odi odoc hinana kobol qee! Hina mahamaha cunug agena gesilec dana. Hina tutuc gesilgec bahic gesilgaga,” don. ");
INSERT INTO aey_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Odocob Tibud uqa jejeg hewi madon, “Ija Sodom taun dunuh dana ititom 50 gulucadifig ija taun eu cunug qee fadaldugaun,” don. ");
INSERT INTO aey_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Odocob Ebraham haun madon, “Ija Tibud je madocnu gauc temduga ijaqa dana mahanadec himec. ");
INSERT INTO aey_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Dana ititom 50 qee bileleinfa. Eu 45 himec bileiga. Hina dana ititom 45nu taun qee fadaldogaunfo?” don. Odocob Tibud uqa jejeg hewi madon, “Ija dana ititom 45 gulucadifig ija eu qee fadaladigaun,” don. ");
INSERT INTO aey_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Odocob Ebraham uqa haun madon, “Dana ititom 40 bileigafa?” don. Odocob Tibud uqa jejeg hewi madon, “Dana ititom 40 bilecebilfi ija qee fadaladigaun,” don. ");
INSERT INTO aey_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Odocob Ebraham uqa madon, “O Tibud hina cain gemain beiaun. Culitecem je madiga. Dana ititom 30 bilecebilfi hina fadaladeganfo?” don. Odocob uqa madon, “Dana ititom 30 ono gulucadifig ija qee fadaladigaun,” don. ");
INSERT INTO aey_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Odocob Ebraham uqa madon, “Ija Tibud je madocnu temduga. Dana ititom 20 gulucadifeg hina fadaladeganfo?” don. Odocob uqa madon, “Dana ititom 20 gulucadifig ija taun eu qee fadaldugaun,” don. ");
INSERT INTO aey_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Odocob Ebraham uqa madon, “O Tibud hina cain gemain beiaun. Culitecem haun je madi osahic dugen. Dana ititom 10 himec gulucadifeg hina eu fadaladeganfo?” don. Odocob uqa madon, “Dana ititom 10 bilecebilfi ija qee fadaladigaun,” don. ");
INSERT INTO aey_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Odocob Tibud uqa Ebraham je madu hedodoi ha uqa Ebraham cuculdi nuen. Odocob Ebraham uqa uqana cudunna ceseli nuen. ");
INSERT INTO aey_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Aria Tibudna ensel lecis eu ale wesu Sodom ono calesin. Lot uqa taun cebecna bilen. Odocob Lot uqa mecialimei caji gulucaligia bili len. Uqa gulucalimei gob cehi mahana bilimei jogoi nu maha cotadoin. ");
INSERT INTO aey_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Odimei maalen, “Ijana ben lecis ale waldumesi alena ewel danana jona hosiale. Humesi jaimila cusesiale. Odimesi witic ene nijesiale. Odocobil ale uqadec qasil bahic cajimesi belowasan,” alen. Qa ale jejeg hewi madosin, “Qeeo, ele maha gemo cegulec cudunna us nijewan,” dosin. ");
INSERT INTO aey_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Odocobil uqa cesuscesusaleceb ale waldumesi uqana jona lesin. Odocobil Lot uqana cabi dana maadeceb age sab tinca oso saciadualein. Odimeig age bret jisca qee qagecebil jesin. ");
INSERT INTO aey_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ale us nijuwasa oodosin taundec dana age jo talildoin. Sodomdec dana toiaca mel haunca eu cunug age jo talildoin. ");
INSERT INTO aey_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Age Lot utai sisildoin, “Dana qila witic hinaca hoiga eu ai? Ehali cali hocom ege canalecnu,” doin. ");
INSERT INTO aey_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Qa Lot uqa meciadigia bili jic cebecna cali len. Oodon uqa jic cebec hibilohu isec menen. ");
INSERT INTO aey_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Odimei uqa maaden, “Ija cotiel eu odi cain. Qisol mec kobol cain odowain. ");
INSERT INTO aey_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Qa feiga. Ija ateniel lecis eu dana gami oso qee nijelesin. Culitecebil ija eu ale ehali ahocomin age agena gawecna odaloqagan. Qa dana eu ale adih oso cain odalowain. Ale ijaca loo hosia. Eunu me cofaligen,” aden. ");
INSERT INTO aey_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Qa age madoin, “Jag, hina isa quguga! Ege eeta odocomun cain magagaun. Hina isa quguga. Qeefi hina me qee odiheqan eu wooldoc ale me qee odaleqan,” doin. Age Lot gagadic bahic sundoin. Odimeig age cebec batawoqaga bili cemenug lein. ");
INSERT INTO aey_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Dana lecis dunuh bilesin euqa ebenela hocob Lot hewi didocobil jo hamol len. Odimesi ale jic cebec menesin. ");
INSERT INTO aey_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Odimesi ale fulacdocna dana toiaca mel haunca aqesin. Ale fulacdocna amaga afac quadecebil jic cebec walecnu cabi mein. ");
INSERT INTO aey_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Odimesi dana lecis ale Lot madosin, “Ele taun i fadaldowan. Eunu hinana talnadec indec oso melemfo atenfo atenel gemulailfo hinaca taun ene bilecebilfi eu cedadecem taun i culimeig beleiga. Euqa Tibud agena qisol mec eu me qee bahic dah men. Eunu Tibud uqa fadaldocnu sulleia,” dosin. ");
INSERT INTO aey_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Odocobil Lot uqa cali limei dana lecis uqa ategul cedalowasannu je nijen eu maalen, “Cajesia! Taun i culdesia! Tibud uqa taun i fadaldugian,” alen. Odonqa ale uqa udoc je maalena ec cisdosin. ");
INSERT INTO aey_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Odocobil qasil cocojagen ensel lecis ale Lot cesusdudu madosin, “Cajaga! Odimeg hina aidenca hina atenel lecisca cedadecem beleiga. Qeefi ageha fadaloqagan ele taun i fadaldowan saenna,” dosin. ");
INSERT INTO aey_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot uqa cisdoc lecisca men. Euqa Tibud uqa uqanu waug qon. Eunu dana lecis ale uqa ebenca aideg ebenca uqa ategul ebenelaca hewadi ahu cedimesi ehadi taun gesacna nui madesin. ");
INSERT INTO aey_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Odocobil ale ehadi nui taun gesacna madimesi dana eu ale oso maaden, “Mahuc busaleiga! Age cal mowainnu busaleiga! Hibilomoga isec cain meciowain. Maha asouna ha cain tawowain. Aluhna busali beleiga. Qeefi taun i fadaldodohul ageha fadaloqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Qa Lot uqa maalen, “O ijana ben lecis eu ihoc qeeo. ");
INSERT INTO aey_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ale ijanu gale alena. Eu nalug mec kobol ihactesia. Euqa ija cal migaunnu cesultesia. Qa ija aluhna busali nuecwe qee. Ja i ija oiteceb cal migen. ");
INSERT INTO aey_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Qa fesia. Taun oso i onoca qee ono busali lecnu eu nag ihoc. Ija culitecem ono busali liga. Ija ono lifig ija qee cal migaun. Eu taun nag bahic,” alen. ");
INSERT INTO aey_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Odocob uqa jejeg hewi madosin, “Cois. Je madaga eunu ha cois howona. Taun hina madaga eu qee fadalowaun. ");
INSERT INTO aey_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Aria mahuc ono busali beleiga. Age ono calecebil himec ele ceteh oso odocnu ihoc,” dosin. Lot taun eu nag ec maden eunu taun eu ijan Soa dogina. ");
INSERT INTO aey_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Aria walag dadanen Lot uqa Soa calen. ");
INSERT INTO aey_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Odocob Tibud uqa meen dain gulgulecca jaca osoben saonadec suldocob wa cinigwe Sodom Gomoraca nen. ");
INSERT INTO aey_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Tibud uqa taun eu ale eu odi fadalalen. Maha asou eu cunug fadaldon. Dana caja taun bilein euca ceteteh mahana cehec nijen euha cunug fadaldon. ");
INSERT INTO aey_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Qa Lot aideg uqa Lot hibilohu isec meciimei si meen ibuldon. Odimei na tutuc cinigwe tawen. ");
INSERT INTO aey_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Aria cojageceb Ebraham qasil bahic cajimei ceseli nui cudun uqa Tibud amegna tawen euna len. ");
INSERT INTO aey_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Odocob Ebraham uqa mecieceb Sodom Gomoraca isec non. Odimei maha cunug asouna nijen euha fen. Ja casuc ben bahic mahanadec sao ohis teten eu fen. Eu cinim manecebil casuc cajenawe eu odi fen. ");
INSERT INTO aey_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Qa Anut uqa taun lecis fadalalen saen euna uqa Ebrahamnu cisdumei Lot fadalec cudunnadec suldocob taun uqa bilen eu culimei busali nuen. ");
INSERT INTO aey_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Euqa Lot uqa Soa bilecnu cucuien. Eunu uqa ategul lecis gami Soa culdimeig aluhna timeig age meen hatin osona bilein. ");
INSERT INTO aey_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Odocob ateg matu eu milum madon, “Ele memile uqa toia. Odocob dana oso ele ocnu ene qee bilel. Ele mel oso adi basewan? ");
INSERT INTO aey_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Gec hoga. Memile wain utocohul jimei dalul qocob uqaca nijeqan. Eu odifeu ele melca mewan. Eufi egena sihul gaid biligian,” don. ");
INSERT INTO aey_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Eunu witic euna ale memela wain utecebil jeceb dalul qon. Odocob ateg matu eu leceb memegca nijesin. Odosin memeg uqa ateg leceb nijimesi culdi cajen eu qee dol. ");
INSERT INTO aey_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Odocob cojageceb ateg matu eu milum madon, “Faga. Cum witic ija meica nijuwan. Gec qila witic ha wain utocohul jimei dalul qocob hina lecem uqaca nijuwasan. Eufi egena sihul gaid biligian,” don. ");
INSERT INTO aey_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Eunu witic euna ha ale memela wain utecebil jeceb dalul qon. Odocob ateg milum eu cajimei leceb memegca nijesin. Odosin memeg uqa ateg leceb nijimesi culdi cajen eu qee dol. ");
INSERT INTO aey_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Eunu Lot uqadodoc ategul odaleceb ale melca mesin. ");
INSERT INTO aey_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Odocob ateg matu eu mel oso basen. Odimei eu ijan Moab qon. Uqa Moab sihul asaga calen. Age qila bilegina. ");
INSERT INTO aey_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Odocob ateg milum uqaha mel oso basen. Odimei eu ijan Ben-ami qon. Uqa Amon sihul asaga calen. Age qila bilegina. ");
INSERT INTO aey_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Aria Ebraham uqa Mamri culimei Negew hatuna nuen. Odimei jobon lecis gemo bilen. Oso ijan eu Kedes. Oso ijan eu Sur. Hibna uqa Gera bilen. ");
INSERT INTO aey_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Gera bibilen Ebraham uqa Seranu uqa ija cebinami ec oso madon. Eunu Gera agena king Abimelek uqa uqana cabi dana suladeceb nui Sera aideg biligiannu ehudi uqaca lein. ");
INSERT INTO aey_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Odoinqa witic osona Anut uqa bebelecna Abimelekca humei madon, “Sera uqa dana wele on. Hina uqa omnu hina cal mega biliga,” don. ");
INSERT INTO aey_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Qa Abimelek uqa Sera cemenug qee lec ninijen uqa Anut madon, “O Tibud ija qisol mec oso qee odolom. Hina ijaca ijana hatuca fadaldoganfo? ");
INSERT INTO aey_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Faga. Ebraham uqadodoc Seranu ija cebinami ec maten. Seraha Ebrahamnu uqa ija cebinami ec maten. Eunu ija odom eu cisdoc tutuc odom. Ija silail qee melem,” odi madon. ");
INSERT INTO aey_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Odocob Anut uqa bebelecna jejeg madon, “Hina odom eu cisdoc tutucna odom eu ija dugina. Eunu ija qee culihecemin caja euca lelem. Eunu ija hina cahuldogaunnu cahahahem. ");
INSERT INTO aey_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Qilaqa caja eu gemugca suldocom ceseli ligian. Dana eu uqa ijana je hahun madec dana. Eunu uqa inondocob hina qee cal magaun. Qa hina caja eu qee ceseli suldocomfi hinaca hinana dana cajaca age cunug cal moqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Cojageceb qasil bahic Abimelek uqa uqana cabi dana utaadeceb hocobil ceteh fen eu cunug saadeceb age ben bahic cucuiein. ");
INSERT INTO aey_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Odimei uqa Ebraham utadocob leceb madon, “Hina eetanu kobol eu odi odigem? Ija hina adi oso cahulhem eunu hina culumen ben i ijaca ijana dana cajaca ege gemo migem? Kobol eu odi odom eu hina qee oditoum. ");
INSERT INTO aey_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Celnu eu odi odom?” don. ");
INSERT INTO aey_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Odocob Ebraham uqa madon, “Dana jobon enedec age Anutnu qee cucuiegina. Eunu age ija aideni ocnu qagatoqagan ec odi cisdom. ");
INSERT INTO aey_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Qa Sera uqa ija cebinami eu mele bahic. Ele memile osolnadec qa ele anile eu filfil. Odocob ija uqa aideninu om. ");
INSERT INTO aey_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Saen ija meina jona bibiligin Anut uqa oditeceb mahamaha loldudu cocobi bilig Sera edi madom, ‘Hina ijanu nalunin mec eu i edi ihactoga. Anaana belewan eu hina ijanu uqa ija cebinami ec madagale,’ dom,” odi madon. ");
INSERT INTO aey_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Odocob Abimelek uqa Sera ceseli suldocob Ebrahamca len. Odimei sipsipca bulmakauca cabi dana cajaca ha cedadi ahu Ebraham uten. ");
INSERT INTO aey_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Odimei Abimelek uqa Ebraham madon, “Maha fagana eu ijana maha. Hina maha ina ana bilegannufi hinana gawecna biligale,” don. ");
INSERT INTO aey_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Odocob Abimelek uqa Sera odi madon, “Ija qaig uqana ameg eu 1000 silwa eu odi cebinem wele utiga. Eu gadac oso. Agena sihul cunug hinaca bilegina age hina silailca qee doqagan eunu gadac,” don. ");
INSERT INTO aey_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Aria Tibud uqa Sera Ebraham aidegnu caja cunug Abimelekna jona bilegina eu wawaga meniaden. Eunu Ebraham uqa Anut inondocob Abimelek uqa me men. Uqa aidegca uqana cabi cajaca eu wawaga jic hudiaden. Odocob age mel haun basecnu ihoc. ");
INSERT INTO aey_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Aria Tibud uqa Seranu maden eu dahig bilen. Eunu uqa Seranu je wele qel qeti maden eu toodu odon. ");
INSERT INTO aey_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saen Ebraham uqa toia cocobon Sera uqa waugca mimei mel oso basiton. Euqa Anut saen gadac menna mel basiton. ");
INSERT INTO aey_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Odocob mel Sera basiton eu Ebraham ijan Aisak qon. ");
INSERT INTO aey_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Deel eben naha gic lecisca hedocob Ebraham uqa melah Aisak deweg gaga quton. ");
INSERT INTO aey_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aria Sera uqa Aisak basen saen euna Ebraham uqana cabi gel eu 100 gadac. ");
INSERT INTO aey_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Odocob Sera uqa maden, “Anut uqa oditen eunu ija celeboigina. Dana cunug ija celeboigina dah moqagaqa eu ageha ija gami celeboeqan. ");
INSERT INTO aey_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","In uqa Ebraham odi madoub, ‘Sera uqa mel basimei su utigian,’ doub? Euqa uqa toia bibilen ija melah basituga,” en. ");
INSERT INTO aey_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Odocob mel eu meca mimei su jec culen. Odocob deel euna himec Ebraham uqa mel sim eunu ja qon. ");
INSERT INTO aey_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Aria deel osona Ismal Isipdec caja Hega uqa Ebraham basiton eu uqa Sera melah, Aisak, bulamdodon Sera uqa fen. ");
INSERT INTO aey_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Eunu Sera uqa Ebraham madon, “Cabi caja eu uqa melahca ititacalecem belesia. Cabi caja eu uqa melah hina cehewain ija melami Aisaknu muguh biligian eu qee cesawi oiaun,” don. ");
INSERT INTO aey_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Qa Ismal uqaha Ebraham melah. Eunu Ebraham uqa Serana je eu dumei uqa waug culumen don. ");
INSERT INTO aey_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Odocob Anut uqa Ebraham madon, “Hina hinana cabi caja uqa melahca alenu cain jaen qihiaun. Aisak uqana sihulna eu hinana sihul mele bahic. Eunu eeta Sera mahena eu toodu odoga. ");
INSERT INTO aey_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Cabi caja melah uqaha ija odocomin uqana sihul eu sihul ben oso caloqagan. Uqaha hina melem,” don. ");
INSERT INTO aey_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Odocob deel oso euna Ebraham uqa qasil bahic cajimei sabca wa leih dool ganacna tacec eu cedadimei uton. Odimei uqa mel Hega qatona mitumei suldocob nuen. Odocob uqa nuimei Biasiba wadau waca qeena lili huhu i cobon. ");
INSERT INTO aey_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Odi cocobon wa dool ganacna eu qee men. Odocob uqa mel ehi li na nag oso salafuna muden. ");
INSERT INTO aey_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Tawimei cocobi li bilen. Eu onoca qee. Uqa maden, “Ija mel cal memeb cain figaun,” en. Uqa ono bibilei co suli umei qajen. ");
INSERT INTO aey_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Odocob Anut uqa mel qaqajen dah men. Odocob Anutna ensel saonadec Hega utadudu madon, “Hega, eetanu qajagana? Cain cucuiagaun. Anut uqa mel eu odi qaqaji ninijen wele dah meia. ");
INSERT INTO aey_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Cajaga. Mel eu eben umeg cesuldocom cajeia. Ija odocomin mel eu uqana sihul eu sihul ben oso caligian,” don. ");
INSERT INTO aey_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Odocob Anut uqa ameg fogo dutocob wa tut oso fen. Odimei uqa limei wa eu dool ganacna wetimei mel uteceb jen. ");
INSERT INTO aey_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Aria Anut uqa ameg mel eu cofdodon ben men. Ben memen uqa Paran agena wadauna bilen. Odocob uqa qali dana calen. ");
INSERT INTO aey_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Odocob uqa anag Isipdec caja oso uton. ");
INSERT INTO aey_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Saen euna Abimelek uqa uqana han dana ilo, ijan Fikol, uqaca belimesi Ebraham madon, “Hinana odoc cunugna Anut hinaca bilia. ");
INSERT INTO aey_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Hina Anut amegna qel qetec je oso madaga. Ija Abimelekca uqana melca uqana sihulca qee qauadigaun ec odi madaga. Ija kobol me bahic odihem. Eunu qel qetec madaga. Ija Abimelek uqana dana cajaca ija gemo biligina euca kobol me bahic odadigen ec madaga,” don. ");
INSERT INTO aey_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Odocob Ebraham uqa madon, “Hina mataga eu ija toodu odigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Qa Abimelek uqana cabi dana age Ebraham uqana wa tut oso cawaludein. Eunu Ebraham uqa Abimelek gonagona mudon. ");
INSERT INTO aey_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Odocob Abimelek uqa madon, “Indec odeia eu ija qee dugina. Hina oso qee matelem. Ija je oso qee dolom. Qila himec eunu dugina,” don. ");
INSERT INTO aey_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Odocob Ebraham sipsipca bulmakauca cedadimei Abimelek uten. Odocob ale bal cehec je madi cagosin. ");
INSERT INTO aey_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Odimei Ebraham uqa sipsip nag cufunec eben naha gic lecisca cedadimei abes meaden. ");
INSERT INTO aey_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Odocob Abimelek uqa Ebraham sisildon, “Sipsip cufunec i age abes madaga eu eetanu odoga?” don. ");
INSERT INTO aey_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Odocob Ebraham uqa madon, “Hina sipsip nag eben naha gic lecisca cedadaga. Cedadecemfi Ebraham uqa wa tut i hunen oqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Eunu cudun eu ijan Biasiba ein. Dana lecis ale cudun euna bal cehec je madi cagosin eunu. ");
INSERT INTO aey_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Aria ale Biasiba ono bal cehec je madi cagocobil Abimelek uqa uqana han dana ilo Fikolca cajimesi Filistia agena mahana ceseli belesin. ");
INSERT INTO aey_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Eu hedocob Ebraham uqa na oso, ijan tamaris, Biasiba ono cehen. Odimei uqa Tibud Anut Bilec Catanec binan sulen. ");
INSERT INTO aey_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Aria Ebraham uqa odi odimei saen cecelac Filistia mahana bilen. ");
INSERT INTO aey_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Aria hibna saen osona Anut uqa Ebraham temdon. Uqa madon, “Ebraham!” don. Odocob Ebraham uqa jejeg hewi madon, “Ija i hen,” don. ");
INSERT INTO aey_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Odocob Anut madon, “Hina melem osahic himec, Aisak, eu hina uqanu nalug magana eu ehudecem Moraia hatuna belesia. Odimeg ono aluh oso ija ihachigenna hina mel eu ihantaga,” don. ");
INSERT INTO aey_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Odocob qasil bahic Ebraham uqa cajimei uqana cesel saciadumei ja ihanecnu ha qatani sogon. Odimei uqa uqana cabi dana haun lecisca uqa melah Aisakca ehadeceb age cudun Anut madon euna belein. ");
INSERT INTO aey_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Bebelegin deel hedocob Ebraham uqa ameg suli umei cudun Anut madon eu onoca ninijen fen. ");
INSERT INTO aey_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Odimei Ebraham uqana cabi dana haun eu maalen, “Ale ceselca ene bibilebil ija melca ele ono belewan. Ele ono cuha fimeu aleca haun ceseli howan,” alen. ");
INSERT INTO aey_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Odocob Ebraham ihanecnu ja sogonca umei melah Aisak qatona men. Odimei uqa ebenna ja cijecca jaca siginca cedali hewen. Odocob ale osoben cocobi belesin. ");
INSERT INTO aey_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ale odi cocobi bebeli bilesi Aisak uqa memeg Ebraham madon, “Mei!” don. Odocob Ebraham uqa jejeg hewi madon, “Melami, ija i hen,” don. Odocob Aisak uqa sisildon, “Faga. Ja cijec jaca i hen. Qa sipsip ihanecnu eu ai?” don. ");
INSERT INTO aey_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Odocob Ebraham jejeg hewi madon, “Melami, Anut uqadodoc sipsip ihanecnu iligian,” don. Eunu ale osoben haun cocobi belesin. ");
INSERT INTO aey_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Belimesi ale cudun Anut madon euna calesin. Ebraham ono ihanec meen cabal gualen. Odimei ja sogonca meen cabal tatacan men. Eu hedocob uqa melah Aisak jaih ebenca libimei ja tatacan muden. ");
INSERT INTO aey_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Odimei Ebraham uqa eben leceb melah qogia bili sigin on. ");
INSERT INTO aey_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Qa Anutna ensel uqa saonadec utadudu madon, “Ebraham, Ebraham!” don. Odocob Ebraham uqa jejeg hewi madon, “Ija i hen,” don. ");
INSERT INTO aey_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Odocob ensel uqa madon, “Hina eben eu mel eu oso cain qududoiaun. Hina ceteh oso cain odudogaun. Hina Anutnu cucuiagana qila ija dugina. Hina melem osahic himec eu ija ihantecnu qee cahacdolom,” don. ");
INSERT INTO aey_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Odocob Ebraham uqa falicdu meciimei hibilohu isec sipsip manahal oso uqana tub culilisna hagawen tatawen fen. Odimei uqa li sipsip eu on. Uqa umei uqa melah cudunna sipsip eu ihanen. ");
INSERT INTO aey_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Odimei Ebraham uqa cudun eu ijan “Tibud Uqa Igigian,” qon. Eunu qila saen ina odi madegina, “Tibud uqana aluhna uqa igigian,” egina. ");
INSERT INTO aey_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Odocob Anutna ensel saonadec Ebraham haun utadudu ");
INSERT INTO aey_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","madon, “Tibud uqa odi madena, ‘Ija Tibud. Ija ijanina qel qetec je oso migen. Hina melem osahic himec ija ihantecnu qee cahacdolom eunu mele bahic ija hina eelhigen. ");
INSERT INTO aey_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Odimig ija odocomin hinana sihul mati bahic fulusdoqagan. Euqa malaqa saona nijiaca lanna cesic nijiaca eu odiwe caloqagan. Odocobil hinana sihul agena cad aqadoqagan. ");
INSERT INTO aey_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Hina ijana je toodu odoga. Eunu mahamaha hatu cunug eeladigen eu odiwe hinana sihul eeldugen,’ ena,” don. ");
INSERT INTO aey_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Odocob Ebraham Aisakca ale ceseli uqana cabi dana haun bilesin euna calesin. Eunadec age cajimeig osoben Biasiba belein. Aria Ebraham uqa ono bilen. ");
INSERT INTO aey_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Aria saen osona Milka, uqa Neho aideg, mel basaden eu Ebraham dah men. ");
INSERT INTO aey_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Mel matu eu ijan Us. Uqa waliagul ijanaga eu Bus, Kemuel, ");
INSERT INTO aey_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Haso, Pildas, Jitlap, Betuelca. Kemuel uqa Aram memeg. ");
INSERT INTO aey_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel uqa Rebeka memeg. Mel eben naha gic ijedca eu age Milka uqa Neho basaditon. Neho uqa Ebraham waliag. ");
INSERT INTO aey_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Reuma uqa Nehona cabi caja oso uqaha mel basaditon. Ijanaga eu Teba, Gaham, Tahas, Makaca. ");
INSERT INTO aey_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sera uqana mahana coboc cabi gel eu 127. ");
INSERT INTO aey_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Odocob uqa Kenan mahana Hebron ono cal men. Odocob Ebraham Seranu uqa me qadac qajen. ");
INSERT INTO aey_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Odocob Ebraham uqa aideg deweg ganac nijen cudun eu culdimei dana Hetna sihul eundecca nuimei maaden, ");
INSERT INTO aey_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ija dana jag. Ija age gemo loldudu cobigina. Aideni hel cisigennu age maha oso idadecnu culiteiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Odocob age jejeg hewi madoin, ");
INSERT INTO aey_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“O egena ben dah migigale. Ege gemo hina king melah cinigwe. Eunu hinana gawecna cel meen hatin eu gale hena euna hina aiden deweg ganac hel cisigale. Egena meen hatinnu oso qee cahachoqaun,” doin. ");
INSERT INTO aey_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Eunu Ebraham uqa cajimei age amagana jogoen. ");
INSERT INTO aey_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Odocob Ebraham uqa odi maaden, “Age ija maha ene ijana caja deweg ganac hel cisecnu cois toqaganfi age Efron, Soha melah, ija coni umeig maduteiga. ");
INSERT INTO aey_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Eu odi maduteiga, ‘Ebraham uqa Makpela meen hatin fajecnu gale dona. Makpela meen hatin eu hinana cabi cemenug nijia. Uqa fajecnu coisfo? Meen hatin eu fajecnu ameg cunug ihigian. Euqa uqana qalqal biligian. Eu fajecnu eu ege amigena odigian,’ odi maduteiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Odonqa Efron uqa uqana dana age taun cebecna gabandoin bibilegin uqa age gemo bibili bilei cunug dah memegin uqa Ebraham madon, ");
INSERT INTO aey_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Ijana ben, qeeo. Dah mitiga. Ija cabi eu ihigina. Meen hatin cabi euna nijia euha ihigina. Dana caja melamagail amagana ihigina. Aiden deweg ganac euna hel cisiga,” don. ");
INSERT INTO aey_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Qa Ebraham uqa haun maha eunadec dana cajaca amagana jogoen. ");
INSERT INTO aey_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Odocob age amagana uqa Efron madon, “Hina dah mitigale. Ija cabi eu uqana ameg ihigen. Hina cabi eu ameg ocom ija aideni deweg ganac euna hel cisigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Odocob Efron uqa Ebraham jejeg hewi madon, ");
INSERT INTO aey_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“O ijana ben dah mitiga. Cabi i uqana ameg eu silwa 400 eu odiqa hina eunu cain cisdogaun. Eunu aiden euna hel cisiga,” don. ");
INSERT INTO aey_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Odocob Ebraham uqa Efronna je dah mimei uqa meen qaig 400 silwa eu odi saniimei uten. Meen qaig ameg eu Ebraham uqa wele dana cajaca Het sihuldec amagana maden. Ebraham uqa idadec doc dana cinigwe meen qaig eu sanien. ");
INSERT INTO aey_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Eunu idadec jicna bahic Ebraham uqa Efronna cabi Makpela ono, eu Mamri cemenug, faji on. Cabica meen hatinca na cunug cabi euna tawein euca uqa faji on. ");
INSERT INTO aey_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Eunu Het dana age taun cebecna cegulein bibilegin age amagana Ebraham uqa cabi faji on. ");
INSERT INTO aey_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Eu cunug hedocob Ebraham uqa aideg Sera meen hatin cabi euna nijia ono hel cisen. Cabi eu Makpela ono Mamri cemenug nijia eu Kenan hatuna nijia. ");
INSERT INTO aey_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Eunu cabi meen hatinca eu Ebraham faji on. Euqa idadec jicna Het melahul ebeneganadec qalqalnu faji on. ");
INSERT INTO aey_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Aria Ebraham uqa wele toia men. Uqa bibilen cabi gel mati bahic nuen. Ceteteh cunug uqa odon eu Tibud uqa eeldon. ");
INSERT INTO aey_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Odocob Ebraham uqa uqana cabi dana matu eu uqana cabi cunugnu ilo eu madon, ");
INSERT INTO aey_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","“Hina ebein ija tucumi gemo mimeg qel qetec je oso madaga. Anut uqa saonaca mahanaca Tibud bilina, hina uqa amegna qel qetec je madaga. Hina melaminu Kenan sihulnadec caja oso qee u togaun. ");
INSERT INTO aey_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Qa hina nuimeg caja ijana hatunadec euqa ijana sihulnadec oso u ija melami Aisak uqa aidegnu u togan,” don. ");
INSERT INTO aey_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Odocob cabi dana uqa sisildon, “Caja eu maha ina tooti hocnu culecebfi ija adi odigen? Hina melem ehudi ceseli nui maha hina homnadec euna mudigenfo?” don. ");
INSERT INTO aey_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Odocob Ebraham uqa jejeg madon, “Batut fagale! Ija melami ono cain ehudi lagaun. ");
INSERT INTO aey_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Anut uqa saonadec Tibud, uqa ija meina jonadec ehiten. Odocob ija meina joca maha ija cali hom euca culem. Odocob uqa bal cehec je matimei je hahun i maten, ‘Maha i hinana sihul adigen,’ ten. Eunu Anut uqa uqana ensel aquni suldocob jic qahihigian. Odocob hina ija melami uqana caja onodec u togan. ");
INSERT INTO aey_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Qa caja eu hina toohecnu culecebfi hina Anut amegna eu odi odigen aga eunu hina dewenna jeca qee. Qa ceteh oso ija melami ono cain ceseli ehudi lagaun,” don. ");
INSERT INTO aey_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Eunu cabi dana eu uqa eben Ebraham tucuh gemo mimei Ebrahamna je eu toodu odigen en. ");
INSERT INTO aey_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Odocob cabi dana eu uqana ben uqana kamel 10 cedadimei nuen. Uqa ceteteh me me leihha uqana ben ebennadec cedimei nuen. Uqa cajimei Neho uqana taun eu Mesopotemia hatuna nijia ono nuen. ");
INSERT INTO aey_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Uqa niji u nui wesu memen uqa Neho uqana taun gesacna wa tutna calen. Odocob uqa kamel odadeceb gob qahi bilein. Saen eu caja agena wa wetec saen. ");
INSERT INTO aey_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Odocob uqa Tibud Anut inondudu maden, “O Tibud Anut hina ijana ben Ebraham uqana Anut, ijana ben Ebraham hinana kobol me bahic ihacdoga. Cabi i odocomin tutuc caligiannu cesultaga. ");
INSERT INTO aey_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Faga. Ija wa tut gesacna tatawigin taunnadec mel aid age wa wetoqagannu hogina. ");
INSERT INTO aey_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ija caja oso madocomin, ‘Hinana halon mahana toni mimeg ija wa gab oso itiga,’ docomin uqa odi matecebfi, ‘Wa gab jejem ija hinana kamelha wa adigen,’ tecebfi mel aid eu ijana ben Aisak aidegnu camasac muditiga. Hina eu odi odocomfi hina ijana ben kobol me bahic ihacdogan ija dugen,” don. ");
INSERT INTO aey_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Uqa inondudu qee hedoc Rebeka uqa wa halon qatona bibilen cali hon. Rebeka uqa Betuel ateg. Betuel uqa Neho Milkaca ale melamala. Neho uqa Ebraham waliag. ");
INSERT INTO aey_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeka uqa caja taula olaca euqa uqa dana osoca qee nijelesin. Uqa wa tutna numei wa weti hedumei haun ceseli ben. ");
INSERT INTO aey_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Odocob Ebrahamna cabi dana uqa mahucwe bahic guguli gulucdugiannu len. Odimei uqa madon, “Hina hinana halonnadec wa nag itecem jecnu coisfo?” don. ");
INSERT INTO aey_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Odocob uqa madon, “Ijana ben gad wa gab jaga,” don. Odi madudu bilei uqa mahuc bahic wa halonca qatonadec u ehi ni ebenna hewen. Hewimei uqa uteceb wa gab jen. ");
INSERT INTO aey_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Uqa wa gab ji hedocob madon, “Ija hinana kamelha wa adecemin ihoc jecebil gadacna culigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Odocob uqa mahuc bahic wa halonna eu basecdocob dool agena wa gab jec bohna non. Odimei haun guguli ceseli nu wa tutna wa weti ehi bi haun basecdon. Uqa eu odi dih oodon kamel wa ihoc jecebil culen. ");
INSERT INTO aey_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Eu oodon Ebraham uqana cabi dana uqa jeca qee mecidudu cisdon, “Tibud uqa kobol me bahic Ebraham ihacdonafo qeefo?” en. ");
INSERT INTO aey_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Odocob kamel wa ji hedocobil dana eu uqa dahof oso eu golna mudec umei Rebeka medena men. Uqaha sai lecis eu golna mudec cedalimei Rebeka ebenna men. ");
INSERT INTO aey_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Odimei uqa sisildon, “Hina indec ateg? Hina memenna jona ege us nijecnu cudun ihocfo?” don. ");
INSERT INTO aey_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Odocob uqa jejeg hewi madon, “Ija Betuel ateg. Betuel uqa Neho Milkaca melamala. ");
INSERT INTO aey_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Egena jona dool us nijecnu gigi galalecca sabca ihoc bilia. Hina us nijecnu cudunha ihoc bilia,” don. ");
INSERT INTO aey_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Odocob dana uqa gob cehimei mahana jogoen. Odimei uqa Tibud binan susuli ");
INSERT INTO aey_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","maden, “Tibud binan wasi nuiale. Uqa ijana ben Ebraham uqana Anut. Uqa ijana ben kobol me bahic odudia. Uqa qee qaudol. Uqa ija dado mimiten hu ijana ben uqa waliagna jona caliga,” en. ");
INSERT INTO aey_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Odocob caja eu uqa guguli limei uqa anagna jona calimei uqana tal ceteteh eunu maaden. ");
INSERT INTO aey_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Odocob Rebeka uqa cebinag Leban je eu madudu bilei dahofca saica ihacdocob fen. Odocob Leban uqa guguli cali limei wa tutna nuen. Odimei uqa dana eu ono kamel gami tatawegin fimei ");
INSERT INTO aey_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","madon, “Ijaca belowa. Anut hina eelheia. Hina maha gemo odi cain tawagaun. Ija jo wele saciaduga. Hinana kamel agena cudunha wele saciaduga,” don. ");
INSERT INTO aey_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Eunu Leban uqa dana eu ehudi jona len. Odimei uqa uqana ud kamel homoganadec cedi mahana men. Odocob uqa gigi galalecca sabca kamel agena ahu aden. Odimei uqa dana euca leih uqa gami hoin euca jaimiga cusuqagannu wa ahu aden. ");
INSERT INTO aey_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Odocob sab jecnu ahu mitoin. Mitocobil uqa maaden, “Ija sab mahuc qee jigaun qa je maadigen huga eu casac maadi hedumig ija sab jigen,” aden. Odocob Leban uqa madon, “Cois, magaga,” don. ");
INSERT INTO aey_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Odocob uqa maaden, “Ija Ebrahamna cabi dana. ");
INSERT INTO aey_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Tibud uqa ijana ben Ebraham ben bahic eeldon. Eunu uqa cehewanca bahic calen. Uqa sipsip amca meme amca bulmakau amca silwaca golca cabi danaca cabi cajaca kamelca ceselca uton. ");
INSERT INTO aey_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Aria Sera ijana ben uqa aideg ijana ben mel oso basiton. Euqa toia cocobi lili basiton. Odocob ceteteh cunug Ebraham uqa melah Aisak muguh eu uton. ");
INSERT INTO aey_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Aria ijana ben oditeceb uqana je toodugennu qel qetec jena madem. Uqa maten, ‘Hina ija melaminu Kenan hatunadec caja oso cain u togaun. ");
INSERT INTO aey_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Qa nuimeg ija mei uqana jobon medeh uqana sihulnadec caja oso ija melami aideg biligiannu u ahu toga,’ ten. ");
INSERT INTO aey_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Odocob ija ijana ben sisildom, ‘Caja ija qee tootecebfi ija eeta odigen?’ dom. ");
INSERT INTO aey_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Odocob uqa jejeni hewi maten, ‘Ijana Tibud, uqa amegna ija cobigina uqa uqana ensel suldocob hina cesulheceb cabi eu ocom ihoc ligian. Odocob hina ija melami uqana caja eu ija meina jobon medehnadec euqa uqana sihul eundec oso ahu togan. ");
INSERT INTO aey_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Hina eu odi oodom ijana sihul gulucadecem age caja eu qee ihecebilfi jic eu himec qel qetec je eu qee migian,’ ten. ");
INSERT INTO aey_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Eunu ija qila wa tutna humig edi inondudu madiga, ‘O Tibud Anut, hina ijana ben Ebraham uqana Anut, cabi i odocomin tutuc caligiannu cesultaga. ");
INSERT INTO aey_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Faga. Ija wa tut gesacna tawigina. Caja taula oso wa wetigiannu hohob ija madugen, ‘Wa nag hinana halonnadec gab jigennu coisfo?’ dugen. ");
INSERT INTO aey_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Odocomin uqa edi matecebfi, ‘Cois wa gab jejem ija hinana kamelha wa adigen,’ tecebfi caja eu ijana ben Ebraham melahnu nesilia ija dugen,’ iga. ");
INSERT INTO aey_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Odimig ija wawina inondudu qee hedudugin Rebeka uqa wa halon qatona gahidumei hoia. Odimei uqa wa tutna wa wetecnu noia. Odocob ija maduga, ‘Hina wa gab itecem jecnu coisfo?’ duga. ");
INSERT INTO aey_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Odocomin uqa mahucwe bahic wa halonca qatonadec u ehi ni ebenna hehewi bili mateia, ‘Gad gab jaga. Oodom ija hinana kamelha wa adigen,’ teia. Eunu ija wa gab jijigin uqa kamel wa adeia. ");
INSERT INTO aey_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Odocob ija sisilduga, ‘Hina indec ateg?’ duga. Odocob uqa mateia, ‘Ija Betuel ateg. Betuel uqa Neho Milkaca ale melamala,’ teia. Odocob ija dahof oso medena miga. Odimig sai lecis ebenna miga. ");
INSERT INTO aey_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Odimig ija gob cehimig jogoi bilig Tibud binan susuli ijana ben Ebraham uqana Tibud Anut eeldoc je maduga. Uqa ija jic tutucna dado miteceb ijana ben uqana sihulnadec age ataga oso uqa melah aidegnu gulucduga. ");
INSERT INTO aey_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Eunu age je madiga inu, ‘Coisfo qeefo?’ teiga. Age ijana ben kobol me bahic ihacdodoig jic tutucna cesuldoqaganfo qeefo? Tutuc mateiga. Odocobilfi ija aisecnu nuigen eu dugen,” aden. ");
INSERT INTO aey_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Odocob Leban Betuelca jejeg hewi madosin, “Mele bahic Tibud uqa ene ehihi ahoia. Eunu ege jeca qee. ");
INSERT INTO aey_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka i hen. Uqa umeg nuuga. Odocom uqa hinana ben uqa melah aidegnu biligian eu Tibud uqa ihacheia eu odi culituqale,” dosin. ");
INSERT INTO aey_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Odocobil saen Ebraham uqana cabi dana je eu dah mimei uqa Tibud amegna gob cehi jogoen. ");
INSERT INTO aey_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Odimei uqa ceteteh silwaca golna mudec euca lotoc me bahicca cedimei Rebeka uten. Uqa ceteteh qaig bennadec Rebeka cebinagca anagca alen. ");
INSERT INTO aey_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Odocob uqaca dana uqaca hoin euca age sabca waca jejeig age witic eu ono us nijein. Cojageceb age qasil cajimeig dana eu maaden, “Culitecebil ija ijana benca ceseli nuigen,” aden. ");
INSERT INTO aey_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Odocob Rebeka cebinagca anagca ale madosin, “Caja eu culdecem ege gami deel 7fo 10fo odi bilimeb hinaca belowasan,” dosin. ");
INSERT INTO aey_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Qa uqa maalen, “Cain cahactecebil daleigaun. Qa qila Tibud uqa cesulteceb ijana cabi me caleia. Eunu sultecebil ijana benca nuigen,” alen. ");
INSERT INTO aey_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Odocob ale jejeg hewi madosin, “Caja eu utadumeb uqana gale docnu sisildocnu,” dosin. ");
INSERT INTO aey_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Eunu ale Rebeka utadumesi sisildosin, “Hina dana ica belowasanfo?” dosin. Odocob uqa maalen, “Ija nuigen,” alen. ");
INSERT INTO aey_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Eunu Rebeka suldocobil Ebrahamna cabi dana gami belein. Cabi caja Rebeka uqa simnadec cofdodon ben men euha uqa gami belein. ");
INSERT INTO aey_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Bebelegin age Rebeka eeldoc je madudu madein, “Ege cebinamige, hina mati bahic fulusdogale. Hinana sihul agena cad aqimei lahaadi ititacadeiale,” doin. ");
INSERT INTO aey_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Odocobil Rebeka uqa uqana cabi cajaca age cajimeig agena kamel toboin. Odimeig age dana tooadein. Eunu cabi dana uqa Rebeka umei niji u ceseli nuen. ");
INSERT INTO aey_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aria Aisak uqa “Oso Cebac Bilina Uqa Mecitina Uqana Wa Tut,” ceseli hon. Uqa wadau waca qee Kenan ono bilen. ");
INSERT INTO aey_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Wesu osona uqa cocobi bili uqa cabina nuen. Odimei uqa ameg suli umei mecien. Euqa uqa kamel hohogin meciaden. ");
INSERT INTO aey_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Odocob Rebeka uqaha ameg suli umei meciimei Aisak fen. Odimei uqa kamel ohisdec tonimei ");
INSERT INTO aey_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","cabi dana sisildon, “Eu cel dana ege gulucgigiannu cabina cocobi hona?” don. Odocob cabi dana uqa madon, “Uqa ijana ben,” don. Odocob uqa olanaga jahuldoc lotoc umei ola jahuldon. ");
INSERT INTO aey_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Odocob cabi dana uqa ceteteh cunug odon eu Aisak madon. ");
INSERT INTO aey_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Odocob Aisak uqa Rebeka uqa aideg biligiannu ehudimei uqa anagna lotoc talah dunuh muden. Uqa Rebekanu ben bahic nalug men. Wele Aisak uqa anag cal men. Eunu uqa waloc don qa qila Rebeka Aisak anagna cudun on. Eunu uqa waug ceelen. ");
INSERT INTO aey_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aria Ebraham uqa caja oso on. Uqa ijan eu Ketura. ");
INSERT INTO aey_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Odocob uqa mel i age basaditon. Simran, Joksan, Medan, Midianca Isbak, Suaca. ");
INSERT INTO aey_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan uqa Siba Dedanca memela. Dedan melahul age dana sihul i age memega calein. Asur, Letus, Leumca. ");
INSERT INTO aey_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian uqa melahul eu Efa, Efe, Hanog, Abida, Eldaca. Eu age cunug age Keturana sihul. ");
INSERT INTO aey_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Aria Ebraham uqana ceteteh cunug eu Aisak uten. ");
INSERT INTO aey_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Qa uqana cabi caja eu uqa aideg cinigwe biloloig eu age melamaga ha Ebraham uqa ceteteh leih loo aden. Odimei uqa suladeceb age Aisak culdimeig maha cam tobi becna isec belein. ");
INSERT INTO aey_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Aria Ebraham uqana cabi gel cunug gabandoc mahana bilen eu 175. ");
INSERT INTO aey_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Uqa toia men. Uqana cabi gel mati bahic. Odocob uqa kis umei cal men. Uqa asagul cal mein eu agena cudunna nuen. ");
INSERT INTO aey_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Odocob uqa melahul Aisak Ismalca ale Makpela eu Mamri cemenug meen hatinna deweg ganac hel cisesin. Makpela eu Efronna cabina nijen. Efron uqa Soha melah uqa dana sihul Hitdec. ");
INSERT INTO aey_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Cabi eu Ebraham uqa Hit dana ebeneganadec faji on. Aideg Sera hel ciseinna uqa ono hel cisein. ");
INSERT INTO aey_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ebraham cal meceb Anut uqa melah Aisak eeldon. Aisak uqa “Oso Cebac Bilina Uqa Mecitina Uqana Wa Tut,” ono bilen. ");
INSERT INTO aey_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Aria je i eu Ismalna je. Ismal uqa Hega melah. Hega Isipdec uqa Serana cabi caja uqa Ismal Ebraham basiton. ");
INSERT INTO aey_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismal melahul ijanaga i edi. Age ijanaga eu toodocobtoodocob cali hoin eu odi nijen. Nebaiot uqa Ismal melah matu. Uqa melahul leih eu Keda, Atbil, Mipsam, ");
INSERT INTO aey_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO aey_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hedat, Tema, Jetur, Napis, Kedemaca. ");
INSERT INTO aey_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Uqa melahul eu age jobon medeh 12 calein. Uqa melahul 12 age ijanaga eu jobon medeh ijanaga filfil qoin. ");
INSERT INTO aey_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Aria Ismal uqana cabi gel cunug gabandoc mahana bilen eu 137. Odocob uqa kis umei cal men. Uqa asagul cal mein agena cudunna nuen. ");
INSERT INTO aey_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Odocob uqana sihul age maha Hawiladec nueceb Sur gadac euna niji u coboloig. Sur eu Isip maha cam tobi becna isec eu Asiria jic nuecna nijen. Age maha euna isec cotigcotigca han cacadi niji u coboloig. ");
INSERT INTO aey_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Aria je i Ebraham melah Aisak uqana je. ");
INSERT INTO aey_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisak uqana cabi gel 40na uqa Rebeka on. Rebeka uqa Betuel ateg uqa Leban cebinag. Betuel uqa Aram dana uqa Mesopotemiadec. Leban uqaha Aram dana. ");
INSERT INTO aey_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aria Aisak uqa aidegnu Tibud inondon. Odocob Tibud uqa uqana inondoc eu dah mimei wadacdon. Odocob Rebeka uqa melca men. ");
INSERT INTO aey_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Oodon eu mel momodo lecis ale waugna niniji bilesi ale cadecwe mesin. Odocob Rebeka uqa maden, “Tibud uqa elena inondoc dah menfi celnu i edi oditina?” en. Eunu uqa Tibud sisildugia bili len. ");
INSERT INTO aey_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Odocob Tibud uqa madon, “Mel lecis hina wawinna bilesia. Hina basalecem ale fulusdumesi sihul lecisna qatani filigandowasan. Oso uqa gagadicca eu oso wooldugian. Odocob matu eu milumna cabi dana biligian,” don. ");
INSERT INTO aey_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Odocob uqana basec saen hocob uqa mel gahca basalen. ");
INSERT INTO aey_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mel uqa casac cali hon eu bagic cacawac. Bagic eu golca. Eu dool deweg cinigwe. Eunu age ijan Iso qoin. ");
INSERT INTO aey_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Uqa cali hocob uqa waliag toodu cali hon. Uqa cali hon eu eben oso Iso jaih bisoc hewimei cali hon. Eunu uqa ijan Jekob qoin. Aisak uqana cabi gel 60na uqa aideg mel eu basalen. ");
INSERT INTO aey_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Aria mel lecis ale ben mimesi Iso uqa dool qoc gesis dana calen. Uqa bahu dana, uqa bahu nijoloi. Jekobqa uqa malol dana, uqa jeca qee. Odocob uqa lotoc talahna himec biloloi. ");
INSERT INTO aey_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aria Aisak uqa dool cus Iso qoloi eu jecnu gale doloi. Eunu Isonu nalug moloi. Rebekaqa uqa Jekobnu nalug moloi. ");
INSERT INTO aey_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Deel osona Jekob uqa wehuc me bahic cilen. Oodon Iso uqa bahudec hon. Uqa wen geh bahic dodon hon. ");
INSERT INTO aey_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Odocob uqa Jekob madon, “Ija wenene qitina. Mahucwe macin wehuc golca eu itecem jiga,” don. Eunu age Idom doin. ");
INSERT INTO aey_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Qa Jekob uqa madon, “Hina matu. Casac ceteteh hina mugum mec eu itiga ija ihigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Odocob Iso madon, “Coiso! Ija wele cal migen odigina. Eunu matu bilec eu cel me oso oditigian,” don. ");
INSERT INTO aey_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Odocob Jekob jejeg hewi madon, “Casac ija amina hinana matu bilec eu ija itigannu qel qeti mataga,” don. Odocob Iso eu odi toodu odon. ");
INSERT INTO aey_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Odocob Jekob uqa bretca me macin wehucca Iso uteceb jen. Odimei Iso cajimei nuen. Eunu Iso uqa uqana matu bilec eu ceteh gauc cinigwe qelen. ");
INSERT INTO aey_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Aria saen osona cahel saen me qee oso calen. Eu Ebrahamna saenna calen eu odi we haun calen. Eunu Aisak uqa Abimelek Filistia agena king Gera ono bilina uqaca nuen. ");
INSERT INTO aey_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Wele Tibud uqa Aisakca camasac mimei madon, “Hina Isip cain nogaun. Maha ija mahigen euna biliga. ");
INSERT INTO aey_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Maha ina nag odi biliga. Odocom ija hinaca biligen. Odimig ija eelhigen. Hinaca hinana sihulca ija maha i cunug adigen. Bal cehec je ija wele Ebrahamca madi cagoh eu ija hinaca ha madi cagowan. ");
INSERT INTO aey_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Odimig ija hinana sihul eu odocomin age malaqa saona nijia eu odiwe caloqagan. Odimig hinana sihul eu maha i cunug adigen. Odocomin hatuhatu cunug hinana sihul jabajabna age ha eeldoc oqagan. ");
INSERT INTO aey_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ebraham uqa ijana loo jeca cunug ija madom eu ha uqa toodu odon. Eunu hina eelhigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Odocob Aisak uqa Gera ono bilen. ");
INSERT INTO aey_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Saen dana jobon eunadec age uqa aidegnu sisildocobil uqa ija cebinami ec maaden. Rebeka uqa caja jaca bahic. Eunu uqa odi cisdon, “Dana jobon inadec age Rebekanu ija qagatecebil cal migaun,” en. Eunu uqa cucuiimei eu odi maaden. ");
INSERT INTO aey_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisak uqa ono bibilen gieceb saen osona Filistia agena king Abimelek uqa fufu oc cebecna meciimei Aisak uqa Rebeka deweg losdodon fen. ");
INSERT INTO aey_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Eunu king Abimelek uqa Aisak utadocob leceb madon, “Faga. Uqa hina aiden! Eu adinu hina uqa ija cebinami ec matem?” don. Odocob Aisak uqa jejeg hewi madon, “Uqanu ija qagatecebil cal migaun imig odi mahem,” don. ");
INSERT INTO aey_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Odocob Abimelek madon, “Hina eeta odigiga? Ijana dana oso hina aidenca nijoubmiqa eu hinanu Anut ege wadacgoub,” don. ");
INSERT INTO aey_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Eunu Abimelek uqa dana cunug je gagadic maaden, “Dana oso dana ifo uqa aidegfo qudualifei mele bahic qocomun cal migian,” aden. ");
INSERT INTO aey_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aria Aisak uqa maha euna sab cehen. Odocob Tibud uqa eeldon. Eunu cabi gel euna himec uqa sab eu wal meceb on eu mati bahic on. Uqa aig osol cehen eunadec aig 100 haun on. Eu odiodi on. ");
INSERT INTO aey_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Odocob Aisak uqa cabi gaid odi oodon li uqa cehewan eu ben bahic men. ");
INSERT INTO aey_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Uqa ceteh mati bahicca. Uqa sipsip, bulmakau, cabi dana amca. Filistia danaqa age uqana cehewan fecebil gale aden. ");
INSERT INTO aey_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Eunu Filistia age wa tut hunec uqa memegna cabi dana age Ebrahamna saenna hunein eu age eu cunug maha tacitaci belein. ");
INSERT INTO aey_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Odocob Abimelek uqa Aisak madon, “Hina egena hatu culdimeg nuuga. Hina gagadicca. Hinana gagadic odoc eu egeca ihoc qee,” don. ");
INSERT INTO aey_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Odocob Aisak uqa eunadec cajimei nui Gera maha asouna ono cudun hewen. Odimei uqa ono bilen. ");
INSERT INTO aey_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Odocob wa tut uqa memeg Ebrahamna saenna hunadein eu Filistia age tacalein eu Aisak haun hunaden. Odimei wa tut eu uqa memeg Ebraham ijanaga aqaden eu haun ijanaga aqen. ");
INSERT INTO aey_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Odocob Aisakna cabi dana age maha asouna wa tut oso hunein. Odimeig age wa fifiji beben gulucdoin. ");
INSERT INTO aey_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Eu hunein qa Geradec sipsip cofadec dana age Aisakna sipsip cofadec dana age wa tutnu gonagona mimeig maadein, “Wa tut eu egena,” adein. Eunu Aisak uqa wa tut eu ijan “Gona Gona Mec” qon. ");
INSERT INTO aey_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Odocob Aisakna dool cofadec dana age wa tut oso haun hunein. Odocobil eunu ha age gonagona madein. Eunu uqa eu ijan “Cadec” qon. ");
INSERT INTO aey_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Odocob Aisak uqa cudun eu culimei ono wa tut oso hunen. Odonqa age wa tut eunu qee gonagona mudelein. Eunu uqa wa tut ijan “Jeca Qee” qon. Uqa odi maden, “Qila Tibud uqa cudun ihoc igia. Eunu ege maha ina danaca doolca cehewanigeca fulusdugian,” en. ");
INSERT INTO aey_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Odocob onodec uqa Biasiba ono ten. ");
INSERT INTO aey_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Odocob witic euna Tibud uqaca camasac men. Odimei uqa madon, “Ija hina memen Ebraham uqana Anut. Cain cucuiagaun. Ija hinaca biligina. Ija eelhimig odocomin hinana sihul fulusdugian. Euqa ijana cabi dana Ebrahamnu cisdumig odigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Eunu Aisak uqa cudun euna ihanec meen cabal oso gualen. Odimei uqa Tibud binan sulen. Odocob uqa ono uqana lotoc talah cecehen uqana cabi dana age wa tut oso hunein. ");
INSERT INTO aey_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Odon saen euna Abimelek uqaca uqana cisdoc utec dana Ahusatca uqana han dana ilo, Fikol, uqaca age Gera onodec Aisakca hoin. ");
INSERT INTO aey_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Odocobil Aisak uqa sisiladen, “Age ija me qee oditein. Odimeig agena hatunadec ititactein. Eunu age celnu ijaca hoiga?” aden. ");
INSERT INTO aey_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Odocob age jejeg madoin, “Qila ege camasac doqona. Tibud uqa hinaca bilina ege doqona. Eunu ege odi cisdom, ‘Ege gemo gabandocnu je oso cagu madecnu euqa hinaca egeca gemonu madecnu,’ om. Qel qeti madecnu eu i edi madecnu. ");
INSERT INTO aey_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Hina ege me qee qee odigigaun. Eu odiwe ege hina me qee mihecnu qee odi quduhilom. Egeqa gaid hina me eelhimeb sulhocomun wawin malolca nuem. Qila Tibud hina eelhen eu camasac doqona,” doin. ");
INSERT INTO aey_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Odocob Aisak uqa sab ben cilimei adeceb jein. ");
INSERT INTO aey_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Odocobil qasil bahic cajimeig age qel qeti madein eu agedodoc age gemo madocobmadocob imeig Aisak uqa suladeceb wawaga malolca belein. ");
INSERT INTO aey_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Aria deel euna himec Aisak uqana cabi dana age humeig wa tut oso hunein eunu madoin, “Ege wa gulucdoqa,” doin. ");
INSERT INTO aey_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Eunu uqa wa tut eu ijan “Qel Qetec” qon. Eunu taun eu ijan Biasiba eu qila saen ina ha odi madegina. Biasiba je eu gug “Qel Qeti Madec Uqana Wa Tut.” ");
INSERT INTO aey_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Odocob Iso uqana cabi gel 40na uqa caja lecis Hetdec cedalen. Caja oso eu ijan Judit, uqa Beri ateg. Caja oso eu ijan Basemat, uqa Elon ateg. ");
INSERT INTO aey_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Iso aidegul lecis ale Aisak Rebekaca wawala dain calec alolosi. ");
INSERT INTO aey_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aria saen Aisak uqa toia memen uqa ameg wa hidon. Oodon uqa tutuc meciecwe qee. Saen euna uqa melah matu Iso utadudu madon, “Melami,” don. Odocob uqa jejeg hewi madon, “Ija i hen,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Odocob Aisak madon, “Faga. Qila ija toia. Ija ijana cal mec deel eu ija qee dugina. ");
INSERT INTO aey_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Qila hina hinana qalica gamedca cedimeg bahu nui dool cus aqi ahutuga. ");
INSERT INTO aey_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Dool eu ahumeg wehuc jecnu tinca maga. Euqa ija gale tenana isec maga. Odimeg saciadu ahutecem jimig qee cal mec ninijeb ija eelhigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Saen Aisak uqa melah matu Iso madodon Rebeka uqa dah mudon. Eunu saen Iso bahu dool aqimei jobon hewi hocnu nunuen ");
INSERT INTO aey_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka uqa melah Jekob madon, “Faga. Ija hina memen uqa walin Iso edi madodon duga. ");
INSERT INTO aey_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Dool cus leih aqimeg wehuc jecnu tinca saciadu ahutuga. Odocom ija jimig qee cal mec ninijeb ija Tibud amegna eelhigen ec madodon duga. ");
INSERT INTO aey_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Aria melami je ija mahigen. Eu dah mi cuhadumeg eu odi toodu odoga. ");
INSERT INTO aey_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Meme amnana bileiga euna limeg meme nag oso jecnu me bahic lecis cedali ahutuga. Odocom ija wehuc jecnu tinca hina memen gale donana isec ija saciadugen. ");
INSERT INTO aey_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Odocomin hina memen ehi litocom uqa jimei qee cal mec ninijeb hina eelhigian,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Odocob Jekob uqa anag jejeg hewi madon, “Faga. Ija wali Iso uqa bagic cacawac. Ijaqa deweni eu bagicca qee. ");
INSERT INTO aey_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ija mei uqa ija deweni tebandugiaqa ija cahuldugina eu dugian. Ija uqa amegna qauec danawe caligen. Odocob uqa qee eelteiaun. Gelitigian,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Qa Jekob anag uqa madon, “Melami gelihec je ihecebfi eu ija ugen. Ija mahiga eu odi dih odoga. Nuimeg ceteteh ija mahiga eu cedi ahutuga,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Eunu uqa nuimei meme lecis cedalimei ahuton. Odocob uqa anag wehuc jecnu tinca uqa memeg gale donana isec saciadon. ");
INSERT INTO aey_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Odimei Rebeka uqa melah matu Isona lotoc me bahic jona bilen eu cedimei uqa melah milum Jekob taciton. ");
INSERT INTO aey_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Odimei uqa ebenca du jocosaigca eu meme ganacna jahulduton. ");
INSERT INTO aey_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Odimei uqa sab tinca bretca saciadon euha melah Jekob uten. ");
INSERT INTO aey_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Odocob Jekob uqa memegca humei madon, “Mei,” don. Odocob uqa madon, “Ija i hen. Melami hina indec?” don. ");
INSERT INTO aey_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Odocob Jekob jejeg hewi madon, “Ija Iso, hinana mel matu. Ija hina mataga eu odi odiga. Caji bilimeg dool cus ija aqiga eu jaga. Odimeg hina ija eeltecnu ihoc,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Odocob Aisak uqa melah sisildon, “O melami, eu adinu dool cus eu mahuc bahic gulucadaga?” don. Odocob Aisak jejeg hewi madon, “Tibud, hinana Anut, uqa cesultecebnu ija odi mahuc bahic odiga,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Odocob Aisak uqa Jekob madon, “O melami cemeni hocom ija dewen tebandugen. Euqa hina ija melami Iso bahicfo qeefo?” don. ");
INSERT INTO aey_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Eunu Jekob uqa memeg Aisak cemenug len. Odocob uqa deweg tebandumei maden, “Jejein eu Jekob jejeg qa eben eu Iso eben,” en. ");
INSERT INTO aey_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Odonqa Aisak uqa eu Jekob ec qee dol. Uqa eben eu bagic cacawac euqa uqa waliag Iso eben cinigwe. Eunu uqa eeldoc je utigia bili ");
INSERT INTO aey_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","uqa sisildon, “Hina ija melami Iso bahicfo?” don. Odocob uqa jejeg hewi madon, “Ese, ija Iso,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Eunu Aisak uqa madon, “Ahutuga. Dool cus hina aqaga eu jimig ija eeldoc je ihigen ihoc,” don. Odocob Jekob uqa ahutocob uqa jen. Uqa wain leihha ahutocob uqa jen. ");
INSERT INTO aey_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Odocob Aisak uqa madon, “Melami cemeni hocom ija cotahigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Eunu Jekob uqa cemenug leceb uqa cotadon. Oodi bilei uqa uqana lotoc cahug eu don. Eunu uqa eeldudu bilei maden, “Faga. Melami uqa deweg cahug eu cabi Tibud eeldon eu cahug cinigwe. ");
INSERT INTO aey_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Anut hina saonadec coi ihiale. Uqaha sab me bahic mahanadec ihiale. Macinca wainca geh bahic ihiale. ");
INSERT INTO aey_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Hatuhatu hina ewel uheheig hinanu jogoeigale. Hina cotinel agena ilo biligale. Hina aninna sihul age hinanu jogoeigale. Oso hina gelihecebfi Anut geludigian. Oso hina eelhecebfi Anut eeldugian,” en. ");
INSERT INTO aey_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisak uqa Jekob eeldoc je madu hedocob uqa Aisak olanadec nunuen saen qee giec uqa waliag Iso dool cusnu gumu tonen eu hon. ");
INSERT INTO aey_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Uqaha sab jecnu tinca saciadumei memegna hewi ahuton. Odimei uqa memeg madon, “Mei caji bilimeg dool leih ija quga eu jaga. Odimeg hina eeltec je mataga,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Odocob Aisak uqa melah Iso sisildon, “Hina indec?” don. Odocob Iso uqa jejeg hewi madon, “Ija hina melem matu, Iso,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Odocob Aisak uqa gagadic bahic qeleli maden, “Indec uqa dool qumei ija ahuteceb jiga? Ija jimig uqa eeldocomin qila bahic nunuen hina hoga. Euqa uqa eeldoc ugian ijom,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Saen Iso uqa memegna je eu dah mimei uqa geh bahic gemagna isec qaqaji memeg madon, “O mei, ija eeltaga. Ijaha eeltaga,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Odocob Aisak uqa jejeg hewi madon, “Hina walin ijaca humei uqa qauteia. Hinana eelhec je eu wele umei nuia,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Odocob Iso maden, “Uqa ijan Jekob eu ihoc bahic qoin. Jekob uqana gug eu qauec. Uqa ija qauti lecis don. Uqa ijana matu bilec eu on. Aria qila uqa ijana eeltec je eu oia,” en. Odimei uqa sisildon, “Hina ijanu eeltec je oso culuga biliafo?” don. ");
INSERT INTO aey_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Qa Aisak uqa Iso jejeg hewi madon, “Faga. Ija uqa hinana ilo mudiga. Euha uqana cotugul eu uqana cabi dana madiga. Uqanu sabnuca wainnuca ija odi eeldoc je utiga. Uqana sabca wainca geh bahic calimei saen cecelac nijigian. Aria melami hinanu ija cel je oso madigen?” don. ");
INSERT INTO aey_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Odocob Iso uqa memeg haun sisildon, “O mei, hina eeldoc je osocafo? O mei ijaha eeltaga,” don. Odi madodoi uqa qajen. ");
INSERT INTO aey_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Odocob uqa memeg jejeg hewi madon, “Faga. Coi saonadec hinanu qee neiaun. Hinana cabinadec sab me bahic qee caleiaun. ");
INSERT INTO aey_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Hinana bilec eu hina han seibulna cacadi bilegan. Hinaqa walinna cabi dana bilegan. Odeganqa hina fee dadaneesi hina uqa ilo bilecnu qajudogan,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Odocob Iso uqa Jekobnu gemag ben. Uqa memeg Aisak uqa Jekob eeldoc je uten eunu. Odocob Iso uqa cisdon, “Ija mei uqana cal mec deel eu dodoldona. Uqa cal meceb ija wali Jekob qocomin cal migian,” en. ");
INSERT INTO aey_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Aria age Iso uqana je eu Rebeka madocobil dah mimei uqa Jekob utadocob hocob madon, “Hina walin uqa qagaheceb cal megannu cisdocna aisais mimi bilei uqadodoc waug soadudu cobona. ");
INSERT INTO aey_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Eunu melami jejeni dah maga. Odimeg mahuc bahic cajimeg busali cebinami Lebanca Haran nuuga. ");
INSERT INTO aey_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Odimeg ono uqaca bilecem saen gieiale. Ono bibilem hina walin uqa gemag qee migian. ");
INSERT INTO aey_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Uqa hinanu gemag qee meceb hina odudem eunu dahig celeceb ija je suldocomin hina onodec ceseli hogan. Qeefi melamiel ale qocobqocob imesi deel osolna cal mowasindain,” don. ");
INSERT INTO aey_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Odocob Rebeka uqa Aisak madon, “Isona Hitdec caja eu alenu alal tena. Jekob uqaha Hitdec caja oso uqa aidegnu ocobfi euqa ijana bilec mahana eu ihoc qee caleiaun,” don. ");
INSERT INTO aey_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Odocob Aisak uqa Jekob utadocob hocob eeldudu je gagadic madon, “Hina Kenandec caja cain ogaun. ");
INSERT INTO aey_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Cajimeg Mesopotemia hina asin Betuel uqana guc ono nuimeg hina memen Leban uqa ategul eundec oso hinana cajanu oga. ");
INSERT INTO aey_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Anut Gagadicca Bahic hina eelheiale. Odimei uqa odocob hinana sihul eu mati bahic caligian. Hinana sihul hatuhatu mati bahic caloqagan. ");
INSERT INTO aey_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Uqa Ebraham eeldon eu odiwe hinaca hinana sihulca eeladigian. Euqa maha i Anut uqa Ebraham uton eu hina biliga eu ogan,” don. ");
INSERT INTO aey_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Odocob Aisak Jekob suldocob uqa Lebanca Mesopotemia onoca nuen. Leban uqa Betuel melah. Ale Aram dana. Leban uqa Rebeka cebinag. Rebeka uqa Jekob Isoca anala. ");
INSERT INTO aey_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Aria Iso uqa Aisak Jekob eeldudu je eu madumei caja oso ocnu suldocob Mesopotemia nuen don. Aisak uqa je odi Jekob madon, “Hina Kenandec caja oso cain ogaun,” ec madodon Iso uqa don. ");
INSERT INTO aey_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Jekob uqa memeg anagca conola toodumei Mesopotemia nuen euha Iso uqa don. ");
INSERT INTO aey_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Odocob Iso uqa memeg Aisak Kenandec caja ocnu waug qee nijel eu fen. ");
INSERT INTO aey_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Eunu uqa Ebraham melah Ismalca nuimei caja haun oso, ijan Malahat, on. Malahat uqa Nebaiot cebinag. Euqa uqa caja casac cedalen eu qee ititacalel. ");
INSERT INTO aey_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Aria Jekob uqa Biasiba culimei Haran isec nuen. ");
INSERT INTO aey_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Uqa nunuen cam casi leceb cudun osona witic meceb us nijigiannu bilen. Odocob uqa eunadec meen oso umei ilona tet qumei cosoli nijen. ");
INSERT INTO aey_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Odocob uqa us ninijei bebelen. Uqa bebelii edi fen. Wadowad oso naha eu mahana qudoc naha eu ti sao qududoc fen. Wadowad euna Anutna ensel age wadowad eu tobi toni eegin meciaden. ");
INSERT INTO aey_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Oodon eu uqa Tibud cemenug tatawen fen. Odocob uqa madon, “Ija Tibud, ija Ebraham Aisakca alena Anut. Maha hina nijiga eu ija hinaca hinana sihulca adigen. ");
INSERT INTO aey_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Hinana sihul euha age mati bahic caloqagan. Age maha bobos cinigwe caloqagan. Odimeig maha hagen cunug ihoc loqagan. Hinaca hinana sihulca agenu dana sihul cunug mahana biluqagan eu eeladec oqagan. ");
INSERT INTO aey_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Aria faga. Ana nuegan eu ija hinaca belewan. Bebeleu ija cofhigen. Euha ija maha ina ceseli ahu mihigen. Ija hina qee culihigaun. Ija hinaca bibilig li je cunug mahiga eu odigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Odocob Jekob us nijecnadec seli cajimei maden, “Mele bahic, Tibud uqa cudun ina bilia eu ija qee dolom,” en. ");
INSERT INTO aey_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Odimei uqa cucuii maden, “Cain. Cudun i cucuianca bahic. Mele bahic i Anutna jo. I sao cebec,” en. ");
INSERT INTO aey_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Eunu Jekob uqa qasil bahic cajimei meen uqa tet qu nijen eu umei dahig biligiannu gadac cehen. Odimei Anut utecnu mool meen eu tatac basecdon. ");
INSERT INTO aey_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Odocob uqa cudun eu ijan Betel qon. Weleca taun oso cemenug nijoloi eu ijan Lus. ");
INSERT INTO aey_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Odocob Jekob uqa Anut amegna je cagumei edi madon, “O Tibud, hinaca belimeu ija jicna cofteteg sab jecnuca lotoc tacecnuca itiga. ");
INSERT INTO aey_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Odimeg haun coftetem ija ceseli nui ija meina jona caligen. Hina odi odifeg hina ijana Anut bilegan. ");
INSERT INTO aey_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Meen i ija cehiga eu Anutnu cuha fecnu cudun caligian. Ceteteh cunug hina itegan eu ija am 10na ila mimig am osahic eundec ceseli ihigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Odocob Jekob haun caji nuen. Uqa nuimei cam tobi bec dana agena mahana calen. ");
INSERT INTO aey_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Uqa ono calimei wa tut oso fen. Wa tut eu cemenug sipsip am ijed wa tut eu gesacna ninijegin meciaden. Age wa tut eunadec wa adecebil joloig. Aria meen wa tut eu cufa qoc eu ben bahic. ");
INSERT INTO aey_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Saen sipsip cunug cegulecebil sipsip cofadec age meen wa tut ameg qoc eu qosocdumeig wa adecebil joloig. Odimeig meen eu haun ceseli wa tut ameg qoloig. ");
INSERT INTO aey_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Odocob Jekob uqa sisiladen, “O cotiel age anadec?” aden. Odocob age jejeg hewi madoin, “Ege Harandec,” doin. ");
INSERT INTO aey_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Odocob uqa sisiladen, “Age Neho asag Leban uqanu doginafo?” aden. Odocob age jejeg hewi madoin, “Ege uqanu doqona,” doin. ");
INSERT INTO aey_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Odocob uqa sisiladen, “Uqa me biliafo?” aden. Odocob age jejeg hewi madoin, “O uqa me bilia. Faga. Uqa ateg Resel uqana sipsip amca hogina,” doin. ");
INSERT INTO aey_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Odocob uqa maaden, “Feiga. Qila cahineg eu sipsip gelna madec saen qee. Sipsip wa adimeig ehadi nu gigi jec cudunna madeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Odocobqa age jejeg hewi madoin, “Ege eu odi mahuc odocnu qee nijel. Casac sipsip cunug hu gabandocobil meen wa tut conadec qosocdumeb wa adoqonanu,” doin. ");
INSERT INTO aey_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Uqa je maadi tatawen Resel memegna sipsip amca hoin. Uqaha sipsip cofadec caja. ");
INSERT INTO aey_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Odocob Jekob uqa Resel uqa awig Lebanna sipsip amca hocobil fimei uqa limei meen wa tut cona eu qosocdon. Odimei uqa Lebanna sipsip wa aden. ");
INSERT INTO aey_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Odocob Jekob uqa Resel cotadudu bilei qaqaji waug ceelen. ");
INSERT INTO aey_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Odimei Jekob uqa Resel madon, “Ija hina memen awig. Ija Rebeka melah,” don. Odocob Resel uqa guguli limei memeg madon. ");
INSERT INTO aey_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Odocob Leban uqa awig Jekob uqa je eu dah mimei uqa mahuc bahic gulucdugia bili guguli len. Odimei uqa cogadudu bili cotadon. Odimei ehudi jona len. Odocob Jekob uqa je cunug Leban sadon. ");
INSERT INTO aey_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Odocob Leban uqa madon, “Mele bahic hina ijanadec bahic. Hina ijana sihulnadec,” don. Odocob Jekob uqa ono Leban gami jagel osahic eu odi bilein. ");
INSERT INTO aey_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Odocob Leban uqa Jekob sisildon, “Hina ijana sihulnadec eunu hina ijanu gauc cabi ogona eu cois bahic qee. Mataga. Hina cabi ogonanu cel ameg ogannu wawin nijia?” don. ");
INSERT INTO aey_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Aria Leban uqa ategul lecisca. Matu eu ijan Lia. Milum eu ijan Resel. ");
INSERT INTO aey_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lia uqa ola fecnu me bahic qa Resel uqa olaca deweg cunug fecnu eu jaca. ");
INSERT INTO aey_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Odonqa Jekob uqa Reselnu nalug men. Eunu uqa madon, “Ija hinana cabi gel eben naha gic lecisca cabi ugen. Euqa hina aten milum Reselnu cabi ugenfi,” don. ");
INSERT INTO aey_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Odocob Leban jejeg hewi madon, “Dana oso utecnu eu me qee qa hina ihecnu eu me bahic. Ene ijaca bilewan,” don. ");
INSERT INTO aey_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Eunu Jekob uqa Lebanna cabi cabi gel eben naha gic lecisca cabi on. Odonqa uqa saen eu cecelac cinigwe qee. Eu deel matica qee cinigwe fen. Uqa Reselnu nalug men eunu. ");
INSERT INTO aey_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Aria Jekob uqa Leban madon, “Saen gadac mitem eu wele qee meia. Ijana caja itiga. Odocom ija uqaca nijewan,” don. ");
INSERT INTO aey_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Eunu Leban uqa uqana jobonnadec dana cunug cedeceb age sab ben hewein. ");
INSERT INTO aey_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","24","Aria Leban uqana cabi caja Silfa eu ehudi ehi li Liaca mudon. Odocob wesu saenna Leban uqa ateg Lia ehudi ehi li Jekob uten. Odocob Jekob uqa Liaca nijesin. ");
INSERT INTO aey_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Odonqa qasil Jekob uqa caja eu ola eu Lia fen! Odimei uqa Lebanca limei madon, “Celnu kobol i oditiga? Ija Reselnu hina hinana cabi uhem. Celnu qautuga?” don. ");
INSERT INTO aey_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Qa Leban uqa jejeg hewi madon, “Egena jobon kobol i edi. Mel aid milum eu matu wooldumei uqa casac dana qee ona. ");
INSERT INTO aey_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Hina ocobocob ec i uqana ja qoc deel eunu cuha osahic himec bilecem leceb ege Reselha ihecnu. Odocob hina uqanu haun cabi gel eben naha gic lecisca cabi ogan,” don. ");
INSERT INTO aey_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Odocob Jekob uqa je eu toodu odigian ec maden. Uqa ocobocob ec uqana ja qoc euna bibilen li cuha osahic hedon. Odocob Leban uqa ateg Resel uqa aidegnu uten. ");
INSERT INTO aey_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Euha Leban uqa uqana cabi caja Bilha ehudi ehi li Reselca mudon. ");
INSERT INTO aey_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Eunu Jekob uqa Reselca nijesin. Odonqa uqa Reselnu nalug men eu wooldoc Lianu nalug men. Odocob Jekob uqa Lebanna cabi haun cabi gel eben naha gic lecisca cabi on. ");
INSERT INTO aey_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Aria saen euna Tibud uqa Jekob Lianu qee nalug mel eu fen. Eunu uqa Liana mel jool huden. Euqa Reselna mel jool menen. Odocob uqa goud men. ");
INSERT INTO aey_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Odocob Lia uqa melca mimei mel oso basen. Uqa maden, “Tibud uqa ija wawi me qee mec eu fen. Mele bahic qila ija gemuni uqa ijanu naluni migian,” en. Eunu ijan Ruben qon. ");
INSERT INTO aey_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Odocob uqa haun melca mimei mel oso basen. Odimei uqa maden, “Ija gemuni uqa ijanu qee naluni mena Tibud uqa dah mena. Eunu uqa melami i ha itia,” en. Eunu uqa mel eu ijan Simion qon. ");
INSERT INTO aey_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Odocob uqa haun melca mimei mel oso basen. Odimei uqa maden, “Ija gemuni uqa mel ijed basitom. Eunu qila uqa ija fagtigian,” en. Eunu uqa ijan Liwai qon. ");
INSERT INTO aey_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Odocob uqa haun melca mimei mel oso basen. Odimei uqa maden, “Qila ija Tibud binan suligen,” en. Eunu uqa ijan Juda qon. Odocob uqa mel basec culen. ");
INSERT INTO aey_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Aria Resel uqa Jekob mel oso qee basitumeinu uqa caja hiagnu hel men. Odocob uqa Jekob madon, “Mel leih itiga. Qeefi ija cal migen,” don. ");
INSERT INTO aey_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Odocob Jekob uqa Reselnu gemag ben. Eunu uqa madon, “Ija Anutfo? Hina mel basecnu jic menihem,” don. ");
INSERT INTO aey_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Odocob uqa madon, “Ijana cabi caja Bilha i hen. Uqaca nijimesi ija mel basiteia. Odocob jic ina uqanadec ijaha ijana talca bileqan,” don. ");
INSERT INTO aey_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Eunu Resel uqa Jekob uqana cabi caja Bilha aideg cinigwe uten. Odocob Jekob uqaca nijesin. ");
INSERT INTO aey_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Odocob Bilha uqa melca mimei mel oso basen. ");
INSERT INTO aey_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Odocob Resel uqa maden, “Anut uqa tutuc gesilteia. Odimei uqa ija jejeni mele bahic dah mimei mel oso itia,” en. Eunu uqa mel eu ijan Dan qon. ");
INSERT INTO aey_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Odocob Reselna cabi caja Bilha uqa melca mimei mel oso Jekob haun basiton. ");
INSERT INTO aey_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Eunu Resel uqa maden, “Ija caja hica ben bahic licdoh. Odimeu ija wooldom,” en. Eunu uqa mel eu ijan Naftali qon. ");
INSERT INTO aey_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Saen Lia uqa mel basecnu culen eu dumei uqa uqana cabi caja Silpa ehudi ehi li Jekob aideg cinigwe uten. ");
INSERT INTO aey_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Odocob Liana cabi caja Silpa Jekob mel oso basiton. ");
INSERT INTO aey_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Odocob Lia uqa maden, “Eu ijanu me bahic,” en. Eunu uqa ijan Gad qon. ");
INSERT INTO aey_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Odocob Liana cabi caja Silpa Jekob mel oso haun basiton. ");
INSERT INTO aey_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Odocob Lia maden, “Ija wawi ceelena. Caja age ija ceelec toqagan,” en. Eunu uqa ijan Asa qon. ");
INSERT INTO aey_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Aria wit qetec saenna Ruben uqa cabina nuen. Odimei uqa na oso ijan mandreik eu uqana bobog ceden. Odimei eu hewadi ahumei anag Lia uten. Odocob Resel uqa Lia madon, “Hina melemna mandreik bobog eundec oso itigamo,” don. ");
INSERT INTO aey_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Qa uqa jejeg hewi madon, “Hina ija gemuni ija cawaltem eu ihoc qeefo? Eunu qila hina ija melamina mandreik bobogha cawaldocnu madaganafo?” don. Odocob Resel uqa madon, “Hina melemna mandreik bobog itecemfi Jekob uqa hinaca qila witic nijuwasan,” don. ");
INSERT INTO aey_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Eunu Jekob uqa wesu cabinadec ceseli hohob Lia uqa gulucdugia bili len. Uqa gulucdumei madon, “Ija wele ija melami uqana mandreik bobogna fajihiga. Eunu hina ijaca nijewan,” don. Eunu witic euna Jekob uqa Liaca nijesin. ");
INSERT INTO aey_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Odocob Anut uqa Liana inonec eu dah men. Eunu Lia uqa melca mimei uqa Jekob melah ebum osahic doc oso basiton. ");
INSERT INTO aey_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Odocob Lia uqa maden, “Anut uqa ija ijana cabi caja ija gemuni utemnu ameg wadac itia,” en. Eunu uqa mel eu ijan Isaka qon. ");
INSERT INTO aey_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Odocob Lia uqa haun melca mimei uqa Jekob mel eben naha gic osahicca doc oso basiton. ");
INSERT INTO aey_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Odocob Lia uqa maden, “Anut uqa ija ceteh me bahic oso itia. Ija uqa melahul eben naha gic osahicca basaditom. Eunu ija gemuni uqa ijaca gaid bilewan,” en. Eunu uqa mel eu ijan Sebjulan qon. ");
INSERT INTO aey_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Odocob hibna uqa mel aid oso basimei ijan Daina qon. ");
INSERT INTO aey_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Odocob Anut uqa Reselnu dahig bilen. Uqa Reselna inonec eu dah mimei uqa uqana mel jool huditon. ");
INSERT INTO aey_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Eunu uqa melca mimei mel oso basen. Odimei maden, “Anut uqa ija majani qu qeleia. ");
INSERT INTO aey_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Uqa mel oso haun itia,” en. Eunu mel ijan Josef qon. ");
INSERT INTO aey_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Aria Resel uqa Josef baseceb Jekob uqa Leban madon, “Sultecem nuiga. Ija ijana jobon nuigen. Ijana hatuna nuigen. ");
INSERT INTO aey_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ijana cajaca mel simca agenu cabi om eu itecem nuiga. Ija hinana cabi u cuhadom doga,” don. ");
INSERT INTO aey_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Qa Leban uqa madon, “Hina gale hecebfi ijaca bilewan. Hinanu himec Tibud uqa ija eelten. Ija jahunec je eunadec duga. ");
INSERT INTO aey_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Eunu hina cel ameg ogannu wawin nijia eu matecem ihigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Odocob Jekob uqa jejeg hewi madon, “Ija hinana cabi u cuhadomnu doga. Hinana dool am cofaadigin fulusdoin eu ha dogona. ");
INSERT INTO aey_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Saen ija qee hocna hina dool am nag bahic. Qa saen ija hocomin hinana dool eu fulusdu mati bahic doin. Hinana cel cabi oso ija om eu Anut cunug eeldon. Qilaqa ija ijana talnu cabi odi oso ugen,” don. ");
INSERT INTO aey_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Odocob Leban uqa sisildon, “Ija adi fajihigen?” don. Odocob Jekob uqa jejeg hewi madon, “Hina ceteh oso cain itigaun. Qa hina ceteh osahic i oditecemfi ija haun hinana dool cofadigen. ");
INSERT INTO aey_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Qila ija culitecem hinana sipsipca memeca cunug dewenega tolotoloca eu ija cabi om eunu ameg cedadigen. Sipsip nag dewenega casca euha oso cedadigen. ");
INSERT INTO aey_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Odocob hibna hina kobol tutuc ija odom eu dogan. Euqa hina cabi ameg item eu fimeg eunadec meme oso deweg tolotoloca qeefo sipsip nag oso casca qeefo fifeg ija hinanadec heje om ec dogan,” don. ");
INSERT INTO aey_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Odocob Leban uqa madon, “Cois eu me bahic. Hina je mataga eu odi odowan,” don. ");
INSERT INTO aey_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Odonqa deel euna himec Leban uqa meme cufunec manahalca dewenega tolotolo qoc senenec eu cunug cedaden. Odimei uqa sipsip nag cascaca ha cedaden. Odimei uqa eu cunug melahul cofadecnu ebenegana maden. ");
INSERT INTO aey_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Odocob Leban uqa jic oso nuen. Jic eu uqana cecelac eu deel ijed eu odi. Uqa Jekob culdeceb Leban uqana dool am leih eu gigi jejegin cofaden. ");
INSERT INTO aey_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Odocob Jekob uqa na sihul filfil ijed eundec batac osolosol qetaden. Na eu ijanaga eu popla, almon, plenca. Odimei uqa na eu age batac obutibit qasaladen. Odocob na caun senenec eu camasac men. ");
INSERT INTO aey_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Odimei uqa na batac eu dool wa jegina agena boh cemenug quaden. Euqa dool wa jejegin age tobadoloig. Eunu na batac eu ono quaden. ");
INSERT INTO aey_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Odocob meme age na batac cemenug tobadecebil hibna age nag basein eu tolotoloca cascaca basadein. ");
INSERT INTO aey_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Odocob Jekob uqa sipsip nagnag eu fil maden. Odimei age olanaga waldocob age Lebanna dool dewenega tolotoloca cascaca meciadein. Eunu uqa jic eu odina Lebanna dool amnadec filiganadimei uqananu ceden. ");
INSERT INTO aey_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Saen dool cufunec gagadicca age agena tobec saen caleceb uqa na batac eundec oso umei wa gab jec boh cemenug qudoloi. Age na batac eu cemenug li toboloig. ");
INSERT INTO aey_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Qa dool oso uqa gagadicca qeefi uqa na batac eu olana qee qudoloi. Eunu dool gagadicca qee eu Lebanna lein. Odocob dool gagadicca eu Jekobna lein. ");
INSERT INTO aey_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Odocob jic eu odina Jekob cehewan benca calen. Odimei uqa dool am mati bahic, cabi dana mati bahic, cabi caja mati bahic, kamel mati bahic, cesel mati bahicca men. ");
INSERT INTO aey_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Aria Jekob uqa Leban melahul je edi mamadegin don, “Jekob uqa ceteteh cunug ege memige uqana ceden. Ege memige uqana ceteteh eu ege memigedec cedimei uqa cehewanca men,” eegin don. ");
INSERT INTO aey_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Odocob eu culecnu. Wele Leban uqa Jekob me oduduloi qa saen ina uqa eu edi haun qee odudel eu uqa fen. ");
INSERT INTO aey_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Odocob Tibud uqa Jekob madon, “Ceseli maha hina memen bilinana nuuga. Hinana sihulca nueiga. Euqa ija hinaca bilewan,” don. ");
INSERT INTO aey_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Eunu Jekob uqa Resel Liaca je sulduali maalen, “Humesi ijana dool am cabina cobigina euna ale guluctesia,” alen. ");
INSERT INTO aey_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Odocob ale limesi gulucdocobil uqa maalen, “Ale memela uqa weleca ija me oditoloi qa qila eu odi qee oditina eu ija figina. Euqa ija mei uqana Anut eu ijaca bilina. ");
INSERT INTO aey_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Aria ija ale memela ijana gagadic odoc cunugcana cesuldolig ale dosina. ");
INSERT INTO aey_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Euqa ale memela eu qautimei ijana cabi ameg eu ibulabaldu 10 don. Uqa eu odi odocna ija wawi tudocnu odonqa Anut uqa Leban culdeceb ija deweni oso qee me qee mudel. ");
INSERT INTO aey_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Uqa odi matecebfi, ‘Dool cunug dewenega tolotoloca basadein dool eundec hinana cabi amegnu cedadegan,’ tecebfi dool basadein eundec himec. Uqa odi matecebfi, ‘Dool cunug dewenega gaga eu made gaga obutibit eu hinana cabi amegnu cedadegan,’ tecebfi dool basadein eundec himec. ");
INSERT INTO aey_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Eunu jic i edina Anut uqa ale memela uqana dool amnadec ija cehewanica miten. ");
INSERT INTO aey_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Aria dool agena manag hewec saenna ija saen osona bebelimig meme manahal dewenega tolotoloca dewenega made gaga obutibitca age cufunec eu manag hehewadegin eu feciadem. ");
INSERT INTO aey_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Odocob Tibudna ensel bebelecna maten, ‘Jekob,’ ten. Odocob ija madom, ‘Ija i hen,’ dom. ");
INSERT INTO aey_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Odocob uqa maten, ‘Qila amen suli umeg faga. Meme manahal cunug cufunec manag hewadegina eu dewenega tolotolocafo dewenega made gaga obutibitcafo. Leban uqa hina me qee odihen eu ija wele fem. Eunu ceteh fem eu ija odocomin calen. ");
INSERT INTO aey_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ija Anut hina Betel ono fecitem eu. Betel cudunna hina meen cehimeg mool basecdu qom. Cudun euna hina je cagu matem. Aria cajaga. Maha i culuga. Maha hina anin basihen euna ceseli nuuga,’ ten,” alen. ");
INSERT INTO aey_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Odocob Resel Liaca ale jejeg hewi madosin, “Qila ele memile uqana ceteteh oso qee owaun. ");
INSERT INTO aey_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Uqa ele cele caja cinigwe mecilena. Uqa ele fajilecna ameg on. Qa eu cunug ji hedon. ");
INSERT INTO aey_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mele bahic, ele memile uqana cehewan cunug Anut cawaldon eu eleca elena talca egenacin. Eunu hina Anut adi maheia eu odi toodu odoga,” dosin. ");
INSERT INTO aey_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","19","Eunu Jekob uqana ceteteh cunug cedadi Kenan nuecnu saciadon. Aria Leban uqa uqana sipsip baginiga jehecnu cabina len. Odocob Resel uqa memegna jo gadan tibud eu heje on. Odocob Jekob uqa aidegulca mel simca cedadimei kamel tatacanna maden. Odimei uqa uqana dool am cunug eu suladeceb aquni belein. Eunu uqa ceteteh cunug Mesopotemia ono bibilei ceden eu cedadimei busali memeg Aisakca Kenan hatuna nuen. ");
INSERT INTO aey_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Odonqa Jekob uqa Leban ija busali nuigina ec qee madol. Eunu uqa qaududu busali nuen. ");
INSERT INTO aey_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Odimei uqa uqana ceteteh cunug cedadimei caji mahuc busali nui Jufretis wa leten. Odimei uqa ameg leceb Giliad hatu aluhcana isec mecidudu nuen. ");
INSERT INTO aey_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Aria deel ijed hedocob Leban uqa Jekob busali nuen ec don. ");
INSERT INTO aey_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Odocob Leban uqa cotugul cedeceb age Jekob jabi toodoin. Age deel eben naha gic lecisca eu odi jabi toodu belein. Odimeig age Giliad hatu aluhcana ono mecidoin. ");
INSERT INTO aey_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Odocobil witic euna Anut uqa bebelecna Leban madon, “Batut faga! Jekob cain geuldoc je madogaun. Ceselecnu ha cain cesusdogaun,” don. ");
INSERT INTO aey_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Saen Leban uqa Jekob mecidocob uqa uqana lotoc talah aluh osona cehi bilen. Odocob Leban uqa cotugul gamiha Giliad hatu aluhca ono lotoc talah cehi bilein. ");
INSERT INTO aey_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Odocob Leban uqa Jekob gulucdumei madon, “Hina eu cel kobol odom? Hina qautimeg ija ateniel lecis eu han cacadi caja cawaladecwe cedali busalem. ");
INSERT INTO aey_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Hina celnu busali hom qa ija qee matelem? Hina celnu ami hewem? Hina ija matoummi ija wawi ceelecca due sisili casu qududu ceed fulduduca sulhoum. ");
INSERT INTO aey_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Eu odom qa hina culitecem ija ateniel asielca cotaadecemin houbda. Hina gad kobol bahic odom. ");
INSERT INTO aey_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ija hina qihecnu gagadic odoccaqa qila witic hina memenna Anut uqa je edi mateia, ‘Batut faga! Jekob cain geuldoc je madogaun. Ceselecnu ha cain cesusdogaun,’ teia. ");
INSERT INTO aey_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Hina memen nui fecnu holimeg busali hom eu ija dugina. Qa hina celnu ijana tibud heje cedadem?” don. ");
INSERT INTO aey_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Odocob Jekob jejeg hewi madon, “Ija cucuiem. Hina atenel lecis eu cawaltigaun imig eunu odom. ");
INSERT INTO aey_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Euqa hina humeg hina cotinel amagaca ceteteh faga. Euna ceteh oso hinana fifeg hina oga. Odocob in oso hinana tibud eu cedadifei uqa qee cebac biliaun,” don. Qa Jekob uqa Resel tibud cedaden eu qee dol. ");
INSERT INTO aey_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Odocob Leban uqa Jekobna lotoc talah dunuh len. Eunadec Liana talah dunuh len. Eunadec cabi caja lecis alena lotoc talah dunuh len. Qa uqa euna tibud eu qee gulucadel. Odocob uqa Reselna lotoc talah dunuh len. ");
INSERT INTO aey_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Aria Resel uqa jo tibud eu cedadimei kamel tatacan bilec cabal uqana jool tacen. Odimei jool euna cilehdu bilen. Odocob Leban uqa ceteh cunug lotoc talah dunuh bilein eu cijawi fen qa tibud eu oso qee gulucdol. ");
INSERT INTO aey_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Odocob Resel uqa memeg madon, “Ijana ben, cain gemain beiaun. Ija jagel qitina. Eunu ija hina cemein caji lec ihoc qee,” don. Eunu Leban uqa cijawi cuhadon qa uqa uqana gadan tibud eu qee gulucadel. ");
INSERT INTO aey_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Odocob Jekob uqa gemag beceb Leban je gagadic madudu madon, “Ija adi cahuldu odihem eu madaga duga? Ija cel silail odemnu i edi jabitigina? ");
INSERT INTO aey_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Hina qila ijana ceteteh cunug wele cijawi faga. Cel oso eu hinanacin gulucdoga? Aria ceteh eu hina cotinelca ijana talca ege amigena fecnu i hen ec magaga. Odocom age ija cahuldomfo qee hina cahuldom fo gesiluqagan. ");
INSERT INTO aey_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ija hinaca cabi gel 20 biloh. Qa hinana sipsipca memeca eu cunug age nag qee basec oso qee nijoloig. Euha hinana sipsip manahal amnadec oso ija qee jelem. ");
INSERT INTO aey_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Dool cus oso hinana sipsip oso qocobfi eu ija qee ahuholig qa ija ijanadec oso eu cesuldu iholig. Odocob dool oso witicfo qee cahinegfo heje ocobilfi hina ija ebeninadec ameg ogannu matolog. ");
INSERT INTO aey_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ija eu odi oodi bilolig. Cahineg ija cam cijitoloi. Witic ija duan toloi. Odocob ija us me qee nijolig. ");
INSERT INTO aey_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Cabi gel 20 euna ija eu odi oodi hinaca bilolou. Hina atenel lecis eunu ija cabi gel 14 cabi om. Odocob hinana dool am cofadecnu ija cabi gel eben naha gic osahicca cabi om. Odocob hina ijana cabi amegha ibulabaldu 10 dom. ");
INSERT INTO aey_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ija asi Ebrahamca Aisak meica alena Anut ijaca qee biloubmi hina ija ebeni tanac gauc sultecem nuoum. Qa Anut uqa ijana culumenca ija cabi gagadic omca eu fen. Eunu uqa qila witic hina je gagadic maheia,” don. ");
INSERT INTO aey_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Odocob Leban uqa jejeg hewi madon, “Caja lecis eu ale ija ateniel. Alena mel sim euha ijana. Dool am i age euha ijana. Ceteh cunug hina fagana eu ijana himec. Qa qila ija ateniel i aleca alena mel simca eu adi haun cedadigen? ");
INSERT INTO aey_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Eunu qila ija hinaca ele gemo bal cehec je oso madewan. Odocob ele bal cehec je mamadi meen am osolnu qelewan,” don. ");
INSERT INTO aey_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Odocob Jekob uqa meen ben tutuc sosoloig cecelacca oso umei mahana cehen. ");
INSERT INTO aey_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Odocob Leban uqa cotugul maadeceb age meen cedi ahumeig haudoin. Odimeig age meen eu cemenug sab jein. ");
INSERT INTO aey_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Odocob Leban uqa cudun eu ijan Jega-sahaduta qon. Odocob Jekob uqa cudun eu ijan Galed qon. ");
INSERT INTO aey_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Odocob Leban uqa Jekob madon, “Meen am i qila deel ina hina ijaca ele gemo bal cehec je madowa eu uqana gadac,” don. Eunu age cudun eu Galed doin. ");
INSERT INTO aey_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Odimei madon, “Saen ele filigandu cocobohul Tibud hina ijaca cofleiale,” don. Eunu cudun eu ijan osoha Mispa doin. ");
INSERT INTO aey_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Odocob Leban madon, “Hina ija ateniel eu me qee odalegaunfo qee hina caja leih haun cedadeganfo, eufi ija qee mecihigaun qa Anut mecihigian doga. ");
INSERT INTO aey_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Faga, meen am ica meen tutuc tawec ica ija hinaca ele gemo cehowa ene nijia. ");
INSERT INTO aey_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Meen am ica meen tutuc tawec ica eu cadnu gaga cudun biligian. Ija meen am i qee wooldumig hagen ono isec hina qihecnu ligaun. Eu odiwe hinaha meen am ica meen tutuc tawec ica qee wooldumeg hagen ene isec ija qitecnu hogaun. ");
INSERT INTO aey_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ebraham Nehoca alena Anut uqa ele gemo gesilligian,” don. Odocob Jekob uqa Anut uqa memeg Aisak cucuidona eu amegna Leban je maden eu cunug toodu odigen imei je cagu maden. ");
INSERT INTO aey_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Odocob Jekob uqa aluhna dool oso qumei Anut ihandon. Odimei uqa cotugul maadeceb sab jecna lecebil sab jein. Odimeig age witic euna aluhna ono us nijein. ");
INSERT INTO aey_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Odocobil qasil bahic Leban uqa cajimei uqa asagul simsimca uqa ategul lecis euca cotaaadi bilei eeldoc je aden. Odimei uqa culadimei ceseli uqana jobon nuen. ");
INSERT INTO aey_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Odocob Jekob uqaha uqana jicna nuen. Nunui bili ensel age uqa gulucdoin. ");
INSERT INTO aey_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Saen Jekob uqa meciadimei maden, “I eu Anutna cudun,” en. Eunu uqa cudun eu ijan Mahanaim qon. ");
INSERT INTO aey_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Odocob Jekob uqa dana leih sos suladeceb age uqa waliag Isoca belein. Iso uqa Sia agena mahana bilen. Sia eu Idom hatuna nijen. ");
INSERT INTO aey_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Qa casac Jekob uqa sos maaden, “Age ijana ben Iso je edi madoqagan, ‘Hinana cabi dana Jekob odi madena, ‘Ija Lebanca bilolounu qila ceseligina. ");
INSERT INTO aey_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ija bulmakau amca cesel amca sipsip amca meme amca cabi danaca cabi cajaca hoqona. Qila ija je i hina sulduhigina. Hina ijanu wawin me nijigian nu,’ ec madena,’ age je i madigina eu odi madoigale,” aden. ");
INSERT INTO aey_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Odocob Jekob uqana sos ceseli hu madoin, “Ege hina walin Isoca loqa. Odeiaqa uqa hona. Dana 400 eu odi uqaca hogina,” doin. ");
INSERT INTO aey_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Odocob Jekob geh bahic cucuii jaen qon. Eunu Jekob uqa uqana dana cajaca dool amca eu qatanadimei am lecisna maden. ");
INSERT INTO aey_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Iso uqa humei han sanan mecebfi am oso eu age busali beloqagan ec odi cisdon. ");
INSERT INTO aey_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Odocob Jekob uqa odi inondu madon, “O ija asi Ebrahamca ija mei Aisakca alena Anut, O Tibud, hina dah mitiga. Hina matem, ‘Hina ceseli hinana hatunaca hina cotinelca nuuga. Odocom ija odocna hina cehewainca calegan,’ tem. ");
INSERT INTO aey_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ija hinana cabi dana. Hina hinana kobol me bahic eu ihactem. Hina ijanu cisdom. Qa ija ihoc qee. Weleca ija gotutca himec Jodan wa i letem. Qa qila ija am lecis ica ceseli huga. ");
INSERT INTO aey_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ija wali Iso ebennadec cahahataga. Ija cucuiigina. Uqa humei han sulimei ijaca ijana tal eu qee migigian. Eunu ija cucuiigina. ");
INSERT INTO aey_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Qa hina matem, ‘Ija mele bahic odihecemin hina cehewainca megan. Odocob hinana sihul eu lannadec cesic cinigwe caloqagan. Euqa sicanecwe qee eu odi caloqagan,’ tem,” uqa eu odi inondon. ");
INSERT INTO aey_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Odimei uqa witic ono us nijen. Odocob uqa waliag Iso loo utigiannu dool leih uqana amnadec nesili cedaden. ");
INSERT INTO aey_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Dool cedaden eu i edi. Meme cufunec 200, meme manahal 20, sipsip cufunec 200, sipsip manahal 20, ");
INSERT INTO aey_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamel cufunec su ogina eundec 30 agena nagca, bulmakau cufunec 40, bulmakau manahal 10, cesel cufunec 20, cesel manahal 10. ");
INSERT INTO aey_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Odocob uqa dool eu qatanadi am naha maden. Odimei uqa dool am eu age uqana cabi dana ebenegana men. Uqa dool am gug fil eu cabi dana oso ebenna men. Odocob dool am gug fil eu cabi dana oso ebenna men. Uqa dool am gug filfil cabi dana osahicosahic ebenegana men. Odimei uqa maaden, “Age casac aquni beleiga. Age cain gabandu belowain. Oso nueceb oso toodoia qa big togoctogoc cain belowain,” aden. ");
INSERT INTO aey_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Odocob uqa cabi dana aquni nugian eu madon, “Saen ija wali Iso uqa guluchimei sisilhecebfi, ‘Hinana ben eu indec? Dool i age indecna? Odeiaqa hina ana nuuguna?’ uqa odi sisilhecebfi, ");
INSERT INTO aey_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","hina edi madegan, ‘Dool i age hinana cabi dana Jekobnacin. Euqa uqana ben Isonu loo suldoia. Odeiaqa Jekob uqadodoc hib hona,’ hina odi madegan,” don. ");
INSERT INTO aey_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Odocob cabi dana leih aquni nuen eu toodoin eu age cunug je eu odi himec madoqagannu maaden, “Age Iso gulucdodoig je cabi dana aquni nuigiannu maduga eu ageha eu odi madoiga. ");
INSERT INTO aey_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Qa je i madocnu dahanaga cain celeiaun. ‘Hinana cabi dana Jekob uqa hib toogena,’ doiga,” aden. Jekob uqa cisdon, “Ija dool lonu aquni suldugina i uqa waug me nijigian. Odocob hibna uqa gulucdocomin uqa ija me meciitigian,” ec cisdon. ");
INSERT INTO aey_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Eunu Jekob dool waliagna lonu suldon eu casac cedi hewi belein. Qa uqa witic euna cudun euna himec us nijen. ");
INSERT INTO aey_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Aria uqa witic euna dih Jekob uqa cajimei aidegul lecisca cabi caja lecisca uqana mel 11ca cedadimei suladeceb Jabok wa letein. ");
INSERT INTO aey_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Uqana tal suladeceb letecebil uqana ceteteh cunug hib cabi dana suladeceb cedi ehi lein. ");
INSERT INTO aey_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Odimei Jekob uqa cuhanuc ono bilen. Odocob dana oso hocob uqaca hewecebheweceb imesi hahagalesin li cojagen. ");
INSERT INTO aey_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Hahagali bilesi dana eu Jekob wooldocnu ihoc qee fimei uqa Jekob cataic tudocob cataic teful falicdon. ");
INSERT INTO aey_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Odocob dana eu madon, “Wele cojagena. Culitecem nuiga,” don. Qa Jekob uqa jejeg hewi madon, “Ija qee culihecemin nuugaun. Euqa eeltecemfi ija culihigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Odocob dana uqa Jekob sisildon, “Hina ijain indec?” don. Odocob uqa jejeg hewi madon, “Jekob,” don. ");
INSERT INTO aey_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Odocob uqa Jekob madon, “Hina ijain haun Jekob qee howain. Hina Anutca hagalimesi dana cunug wooladaga. Eunu age Isrel hoqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Odocob Jekob uqa sisildudu madon, “Hina ijain mataga,” don. Qa uqa madon, “Hina celnu ijaninu sisiligana?” don. Oodoi uqa ono Jekob eeldon. ");
INSERT INTO aey_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Odocob Jekob uqa maden, “Ija Anut ola figaqa ija qee cal melem,” en. Eunu Jekob cudun eu ijan Peniel qon. ");
INSERT INTO aey_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Aria qasil cam tobi beben uqa Peniel cudun eu culimei len. Euqa uqa cataicnu citogohui cobon. ");
INSERT INTO aey_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Aria dana eu uqa Jekob cataic teful eu hiliman tudon. Eunu qila saen ina Isrel dana caja age dool hiliman cataic amegnadec eu qee jegina. ");
INSERT INTO aey_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Aria odocob Jekob uqa ameg suli u meciimei Iso dana 400 uqaca hohogin feciaden. Odocob uqa uqana mel sim Liaca Reselca cabi caja lecisca age qatanadi am ijedna maden. ");
INSERT INTO aey_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Odimei uqa cabi caja lecis ale alena mel gami aquni maden. Odimei Lia uqa uqana mel gami age gemo maden. Odimei uqa Resel Josefca ale hib malen. ");
INSERT INTO aey_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Odocob uqa uqadodoc wooladimei uqa aquni nuen. Odimei uqa waliag dodoldodoi jogoi eben naha gic lecisca don. ");
INSERT INTO aey_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Oodon Iso uqa guguli humei Jekob gulucdon. Gulucdumei uqa cogadudu bili cotadon. Odocob ale qajesin. ");
INSERT INTO aey_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Odocob Iso uqa ameg suli umei cajaca mel simca meciaden. Odimei sisildon, “I indec ni hinaca hogina?” don. Jekob uqa jejeg hewi madon, “O ijana ben, Anut me bahic eeltiti mel sim i age iten,” don. ");
INSERT INTO aey_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Odocob cabi caja ale alena mel sim gami humeig Iso amegna jogoein. ");
INSERT INTO aey_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Odocob Lia uqana mel sim gami humeig Iso amegna jogoein. Odocob Resel Josefca ale humesi Iso amegna jogoesin. ");
INSERT INTO aey_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Oodogin Iso uqa sisildon, “Dool am huhu bilig gulucadiga eu cel gugnu?” don. Odocob Jekob uqa jejeg hewi madon, “Euqa ijana ben hina wawin me mudecnu faga,” don. ");
INSERT INTO aey_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Qa Iso madon, “O wali ija ceteteh geh bahicca. Ceteteh hinana eu cois hinanacin biligian,” don. ");
INSERT INTO aey_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Odocob Jekob madon, “Qee, qila hina ijanu wawin me nijecebfi ceteteh loo ihiga i ebeninadec cedega. Qila hina wawin ceelecna guluctaga. Eunu hina olain figina eu Anut ola fecwe migina. ");
INSERT INTO aey_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Anut uqa ija me eelten. Odocob ija ceteteh ihoc. Eunu ceteteh hina loo ihigina eu cedega,” don. Odimei Jekob uqa cesusdudu li uqa ceteteh loo uten eu cediton. ");
INSERT INTO aey_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Odocob Iso madon, “Cois ege belecnu. Ija aquni nunuemin age hib tooteiga,” don. ");
INSERT INTO aey_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Odocob Jekob madon, “O ijana ben, ijana mel sim age gagadicca qee hina dogona. Euha sipsip bulmakauca cufunec eu agena nagca eu ija cofadigen ec cisdugina. Age gagadic deel osahicna cobifeig age cunug cal moqagan. ");
INSERT INTO aey_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Eunu hina casac aquni nunuem ijaca ijana dool amca ijana simca ege cebitnana hib tooheqan. Ija agena jic lec eu age buluaadi toohi Sia ono guluchigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Odocob Iso madon, “Cois ija ijana dana leih hinaca culadigen,” don. Qa Jekob madon, “Odi cain odagaun. Hina me mitiga eu ihoc,” don. ");
INSERT INTO aey_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Eunu deel euna himec Iso ceseli Sia nuecnu uqa coboc sanan men. ");
INSERT INTO aey_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Qa Jekob uqa Sakot isec nuen. Ono uqa uqana jo oso cehen. Odimei uqa dool agena jo ha cehen. Eunu cudun eu ijan Sakot egina. ");
INSERT INTO aey_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Aria Jekob uqa Mesopotemiadec humei uqa Sekem taun ono culumenca qee me bahic calen. Sekem eu Kenan hatuna nijia. Uqa taun fecnu ihocna cudun oso hewimei lotoc talah cehi bilen. ");
INSERT INTO aey_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Uqa lotoc talah cehenna maha eu 100 silwana faji on. Uqa Hamo melahul ebeneganadec faji on. Hamo uqa Sekem memeg. ");
INSERT INTO aey_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ono uqa ihanec cabal gualimei ijan El qon. “El” eu Isrelna Anut uqa ijan. ");
INSERT INTO aey_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Aria saen osona Daina, Lia ateg uqa Jekob basiton eu, Kenandec caja feciadecnu nuen. ");
INSERT INTO aey_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Aria Hamo, uqa Hiwi dana, uqa maha eu agena ilo bilen. Odocob uqa melah Sekem Daina cocobon fimei uqa caluwandu ehi li hehewen nijesin. ");
INSERT INTO aey_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Uqa waug eu Dainanu cal men. Odocob uqanu nalug mimei je bodoecna isec madon. ");
INSERT INTO aey_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Odocob Sekem uqa memeg Hamo madon, “Mel aid haun i ijana cajanu u taga,” don. ");
INSERT INTO aey_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Aria Jekob uqa dana eu uqa ateg Daina me qee mudia ec don. Saen euna uqa melahul age cabina bulmakau cofaadegin je eu don. Eunu uqa je oso qee maadec bibilen age hoin. ");
INSERT INTO aey_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Odocob Sekem memeg Hamo uqa Jekob je madugia bili uqa hon. ");
INSERT INTO aey_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ale je mamadesin Jekob melahul age cabinadec ceseli hoin. Odocob age Sekem uqa Jekob ateg heweceb nijesin eu Isrel amagana majanaga hewec kobol odon eu dumeig age filicitimeig gemanaga ben. Kobol eu Isrelna sihul gemo odocnu qee nijel eu odon. ");
INSERT INTO aey_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Qa Hamo uqa Jekob madon, “Ija melami waug eu hina atennu nijia. Hina ocobocob owasannu utuga. ");
INSERT INTO aey_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Age ege gami ocobocob eqan. Age atagail ege igeiga. Odimeig ege atigeil age cedadeiga. ");
INSERT INTO aey_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Eufi age ege gemo biluqagan. Odocobil maha eu age bilecnu jeca qee. Odocob age ene idadecnuca maha ocnuca ihoc,” don. ");
INSERT INTO aey_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Odocob Sekem uqa Daina memegca cebinagulca maaden, “Age ijanu wawaga me nijecebfi cel ceteh osonu sisiltoqagaqa eu ija adigen. ");
INSERT INTO aey_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Caja fajec ameg ganic mateiga? Eeta gale adena eu ija adigen. Eu ameg ben bahicfi euha ija fajigen. Qa caja eu iteiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Aria Sekem uqa Jekob melahul age cebinamaga Daina me qee muden. Eunu age gami qauecna isec Sekem memegca je wadacdu maalein. ");
INSERT INTO aey_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Odocob age maalein, “Ege cebinamige dana oso deweg gaga qee qoc ocnu eu ihoc qee. Eu egena kobol qee. Eufi ege majanige gecna isec odocnu. ");
INSERT INTO aey_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ege jic osahicna himec hina cois hecnu. Jic eu odi. Hinana dana cunug age dewenega gaga qoqagan. Eufi age ege cinigwe caloqagan. ");
INSERT INTO aey_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Eu odi odocobilfi ege atigeil eu age adocomun age atagail eu ege iguqagan. Odocobil ege ageca bilecnu. Odimeb dana sihul osahic calecnu. ");
INSERT INTO aey_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Qa age dewenega gaga qocnu maadoqa eu qee dah migifeig euqa ege cebinamige eu umeb nuecnu,” alein. ");
INSERT INTO aey_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamo melah Sekemca je eu dah mesin eu me bahic. ");
INSERT INTO aey_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Odocob uqa Jekob ategnu waug ceelen. Eunu dana haun eu cabi eu odocnu qee daleel. Hamo uqana talna uqa dana ben, uqa binanca biloloi. ");
INSERT INTO aey_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Odocob Sekem uqa memeg Hamoca taun uqana gel cebecna humesi dana taunnadec je maadi madesin, ");
INSERT INTO aey_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Dana i age egena danah. Eunu culadecebil maha ina idadi biluqagan. Maha i eu ben bahic ihoc. Ege age atagail cedadimeb ocobocob ecnu. Odimeb ege atigeil eu age adecnu. ");
INSERT INTO aey_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Euqa age gami bilecnuca dana sihul osahic calecnuca jic osahicna himec odi odocnu cois goqagan. Jic eu odi. Dana cunug ege gemo bilegina eu dana i age cinigwe caloqagan euqa age cunug dewenega gaga qoqagan. ");
INSERT INTO aey_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Odocob agena dool cunugca ceteteh cunugca egena qee biliaunfo? Eunu ege cois adocomun age egeca bileqan,” esin. ");
INSERT INTO aey_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Eunu dana cunug taun gel cebecna lein eu age Hamo melah Sekemca alena je dah mein. Odocobil dana cunug age saen euna dewenega gaga qoin. ");
INSERT INTO aey_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Aria deel ijed hedocob saen eu age dain aden ninijegin Jekob melahul lecis, Simion Liwaica, ale Daina cebinagul, ale han cadec sigin cedimesi taun euna hosin. Taun eunadec dana qee dodogin humesi cunug aqecebil cal mein. ");
INSERT INTO aey_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ale Hamo melah Sekemca siginna aqecebil cal mesin. Odimesi Daina Sekemna jonadec ehudi belesin. ");
INSERT INTO aey_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Odocobil Jekob melahul cunug age humeig dana cal mein ninijegin taun eu dunuhna ceteteh cunug gogoqi heje cedi ehi nuein. Dana taun eunadec age Jekob melahul cebinamaga me qee mudein, eunu odi odoin. ");
INSERT INTO aey_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Odimeig age agena sipsip amca bulmakau amca cesel amca ceteteh cunug agena taun bilein euca cabina bilein euca cunug cedein. ");
INSERT INTO aey_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Age cehewanaga cunugca agena cajaca agena mel simca cunug cedimeig belein. Ceteteh cunug jona nijen euha cunug cedein. ");
INSERT INTO aey_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Odocob Jekob uqa Simion Liwaica maalen, “Ale ija deweni jeca mudesia. Ale odocobil dana Kenandec Peresdecca dana cunug maha inadec age ija agena cadwe doqagan. Ege dana matica qee. Age gabandumeig ijaca han sulecebilfi ijaca ijana talca ege qee mecnu,” alen. ");
INSERT INTO aey_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Qa ale madosin, “Uqa ele cebinamile jicnadec wal caja cinigwe odudecnu ihocfo?” dosin. ");
INSERT INTO aey_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Odocob Anut uqa Jekob madon, “Aria cajimeg Betel ono taga. Odimeg ono biliga. Ija Anut eu saen hina walin Iso cemenugnadec bubusalegan uqa hinaca camasac men. Eunu Betel ono hina ihanec meen cabal gualimeg ihantaga,” don. ");
INSERT INTO aey_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Eunu Jekob uqa uqana talca dana caja cunug uqaca bilein eu maaden, “Cele agena tibud ageca bileiga, eu cunug qeladeiga. Odimeig dewenega eeldumeig lotoc haun tacadeiga. ");
INSERT INTO aey_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Odocob hoiga. Ege Betel ono tecnu. Ono ija Anut ihanec cabal oso gualimig ihandugen. Ija anaana cocobilig saen ija culumenca bibilig Anut je madocomin uqa dah mitoloi,” aden. ");
INSERT INTO aey_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Eunu age cele agena tibud agena bilein eu cunug Jekob utein. Odocob dahof age dahinigana tacein euha utein. Odocob Jekob uqa ceteteh eu cedimei Sekem cemenug na ben gugna hel cisaden. ");
INSERT INTO aey_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Odocob age bebelegin Anut uqa odocob cucuiec ben oso dana caja taun age aliladi bileinna nen. Odocob age qee tooadelein. ");
INSERT INTO aey_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Odocob Jekob uqaca dana caja uqaca belein eu age hu Lus calein. Lus qila eu ijan eu Betel. Eu Kenan mahana. ");
INSERT INTO aey_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Odocob uqa cudun euna ihanec cabal oso gualen. Saen uqa waliag Iso cemenugnadec bubusalen Anut uqa ono uqaca camasac men. Eunu cudun eu ijan Betel qon. ");
INSERT INTO aey_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Odocob Rebekana cabi caja Debora cal men. Odocob uqa na ben gugna Betel bisalu hel cisein. Eunu cudun eu ijan Qajec Na Ben qoin. ");
INSERT INTO aey_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Aria saen Jekob Mesopotemiadec ceseleceb Anut uqaca haun camasac mimei eeldon. ");
INSERT INTO aey_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Odimei Anut uqa madon, “Hina ijain eu Jekob qa hina haun Jekob qee howain. Hina ijain eu Isrel hoqagan,” don. Eunu Anut uqa ijan Isrel qon. ");
INSERT INTO aey_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Odocob Anut uqa je oso ha edi madon, “Ija Anut Gagadic Bahic. Sihul fulusdumeg mati bahic caloqagan. Ija odihecemin hinana sihul ben oso caligian. Sihulna ilo bilec mati bahic age hinana sihulnadec caloqagan. ");
INSERT INTO aey_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Maha ija Ebraham Aisakca alem eu hina ihigen. Odocob hinana sihul hina toohec hibna cali hoqagan euha maha eu adigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Odocob Anut cudun uqa je madon eu culimei sao ohis ti nuen. ");
INSERT INTO aey_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Odocob Jekob cudun uqa Anutca je madesin euna meen cecelac oso umei tutuc cehen. Odimei uqa Anut ihandocwe wain meen eu basecdu qon. Eu hedocob uqa meen eu moolha basecdu qon. ");
INSERT INTO aey_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Odimei uqa cudun eu ijan Betel qon. ");
INSERT INTO aey_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Odocob age Betel culimeig belein. Saen age Efrat qee calec ninijen Resel uqa mel basecnu dain doc sanan men qa uqa ihoc bahic qee. ");
INSERT INTO aey_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Uqa dain ben dodon Resel uqana cesuldoc caja eu madon, “Cain cucuiagaun, Resel. Hina qila mel manahal oso basegan,” don. ");
INSERT INTO aey_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Qa uqa cal migia dodoldodon kis u bilei melah eu ijan Benoni qon. Euqa memeg uqa Benjamin don. ");
INSERT INTO aey_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Resel cal meceb uqa jic Efrat nuec eu gesacna hel cisein. Cudun eu qila Betlehem egina. ");
INSERT INTO aey_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Odocob Jekob meen oso euna uqana qalqal gadac mec cehen. Euqa qila saen inaha bilia. ");
INSERT INTO aey_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Odocob Jekob uqa cocobi nuimei Ede agena han qali jo hagen naha isec uqana lotoc talah cehen. ");
INSERT INTO aey_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Odocob Jekob uqa ono maha euna bibilen Ruben uqa limei memegna cabi caja aideg cinigwe biloloi eu Bilhaca uqaca nijesin. Odocob Jekob uqa eu don. Aria Jekob uqa melahul cunug gabandoc eu 12. ");
INSERT INTO aey_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Melahul Lianadec eu ijanaga Ruben, Simion, Liwai, Juda, Isaka, Sebjulanca. Ruben uqa Jekobna mel matu. ");
INSERT INTO aey_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Melahul Reselnadec eu ijanala Josef Benjaminca. ");
INSERT INTO aey_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Melahul Resel uqana cabi caja Bilhanadec eu ijanala Dan Naftalica. ");
INSERT INTO aey_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Melahul Lia uqana cabi caja Silpanadec eu ijanala Gad Aseca. Melahul i age Mesopotemia ono Jekob basaditoin. ");
INSERT INTO aey_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Odocob Jekob uqa memeg Aisakca Mamri ono nuen. Mamri eu Hebron cemenug. Cudun euna Ebraham Aisakca bilesin. ");
INSERT INTO aey_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aria Aisak uqana cabi gel cunug gabandoc eu 180. ");
INSERT INTO aey_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Odocob Aisak uqa dana toia bahic uqa kis umei cal men. Uqana cabi gel eu mati bahic. Odocob uqa melahul Iso Jekobca ale deweg hel cisesin. ");
INSERT INTO aey_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","I eu Isona je. Iso ijan oso eu Idom. ");
INSERT INTO aey_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","3","Iso uqa caja Kenandec cedaden. Eu ijanaga Ada, Oholibama, Basematca. Ada uqa Elon ateg, uqa Het dana. Oholibama uqa Ana ateg. Ana memeg eu Sibion, uqa Hiwi dana. Basemat uqa Ismal ateg, uqa cebinag eu Nebaiot. ");
INSERT INTO aey_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Odocob Ada uqa Iso Elifas basiton. Odocob Basemat uqa Iso Reuel basiton. ");
INSERT INTO aey_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Odocob Oholibama uqa Iso Jeus, Jalam, Koraca basaditon. Mel i age eu Iso melahul, age Kenan ono basaditoin. ");
INSERT INTO aey_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Odocob Iso uqa aidegulca uqana mel simca uqana cabi danaca dool manan amca cehewanca Kenan ono bibili ceden eu cunug cedimei waliag Jekob cemenugdec qisacdu fil aluhna Sia ono nuen. ");
INSERT INTO aey_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Alena cehewanala eu ben bahic. Alena dool am eu ben bahic. Eunu ale gabandu bilecwe qee. Maha ale osoben bilesin eu ale lecisnu ihoc qee. ");
INSERT INTO aey_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Eunu Iso uqa Sia maha aluhca ono bilen. ");
INSERT INTO aey_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iso uqa Idom sihul eundec agena memega calen. Iso uqana sihul age Sia maha aluhca ono bilein. ");
INSERT INTO aey_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Aria Iso aideg Ada uqa Iso mel osahic basiton, ijan eu Elifas. Odocob Elifas aideg oso uqa mel ebum oso basaden. Ijanaga eu Teman, Oma, Jefo, Gatam, Kenasca. Odocob Elifas aideg oso, ijan Timna, uqa mel osahic basen, ijan eu Amalek. Aria Iso aideg Basemat uqa mel osahic basen, ijan eu Reuel. Reuel aideg uqa mel wal oso basaden. Ijanaga eu Nahat, Sera, Sama, Misaca. ");
INSERT INTO aey_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Aria Iso aideg Oholibama, eu Ana ateg, eu Sibion asag, uqa Iso mel ijed basaditon. Ijanaga eu Jeus, Jalam, Koraca. ");
INSERT INTO aey_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Aria Isona sihul eu odi. Iso melah matu eu Elifas. Uqa sihul i edi agena ilo bilen. Teman, Oma, Sefo, Kenas, ");
INSERT INTO aey_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam, Amalekca. Eu age Elifas aideg Ada asagul. ");
INSERT INTO aey_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Aria Iso melah Reuel uqa sihul i edi agena ilo bilen. Nahat, Sera, Sama, Misaca. Eu age Iso aideg Basemat asagul. ");
INSERT INTO aey_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Aria Iso aideg Oholibama, Ana ateg, uqa sihul i edi agena ilo bilen. Jeus, Jalam, Koraca. ");
INSERT INTO aey_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Iso uqa sihul cunug agena ilo bilen. ");
INSERT INTO aey_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Sia dana age casac Idom bilein, age Ho sihulnadec. Sia melahul age Idom bilein eu Lotan, Sobal, Sibeon, Ana, Dison, Ese, Disanca. Sia uqa Ho sihul agena ilo bilen. ");
INSERT INTO aey_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Odocob Lotan melahul eu Hori Hemanca. Timna uqa Lotan cebinag. ");
INSERT INTO aey_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Odocob Sobal melahul eu Alwan, Manahat, Ebal, Sefo, Onamca. ");
INSERT INTO aey_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Odocob Sibeon melahul eu Aia Anaca. Ana i maha wadauna saen uqa memeg Sibionna cesel cofaadi bilei uqa wa fifiji bec dainca gulucdon. ");
INSERT INTO aey_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Odocob Ana melah eu Dison. Ana ateg eu Oholibama. ");
INSERT INTO aey_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Odocob Dison melahul eu Hemdan, Esban, Itran, Keranca. ");
INSERT INTO aey_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Odocob Ese melahul eu Bilhan, Sawan, Akanca. ");
INSERT INTO aey_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Odocob Disan melahul eu Us Aranca. ");
INSERT INTO aey_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Aria Ho sihulnadec ilo dana eu Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO aey_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Ese, Disanca. Eu age Sia mahana agena jobon medeh filfilna ilo dana bilein. ");
INSERT INTO aey_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Aria Isrel agena ilo dana qee bilec saenna Idom hatu euna ilo dana age hatu eunu ilo bilein. Age toodocobtoodocob bibilegin nuon. ");
INSERT INTO aey_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, uqa Bio melah, uqa Idom agena hatu ilo dana calen. Uqana taun eu Dinhaba. ");
INSERT INTO aey_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Aria Bela cal meceb Jobab uqa Sera melah, eu Bosradec, uqana cudun umei hatu ilo dana bilen. ");
INSERT INTO aey_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Aria Jobab cal meceb Husam, uqa Teman hatunadec, uqa uqana cudun umei hatu ilo dana bilen. ");
INSERT INTO aey_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Aria Husam cal meceb Hadad, uqa Bedad melah, uqa uqana cudun umei hatu ilo dana bilen. Bedad uqa Midian dana eu aqen, eu Moab hatuna. Hadad uqana taun eu Awit. ");
INSERT INTO aey_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Aria Hadad cal meceb Samla, uqa Masrekadec, uqa uqana cudun umei hatu ilo dana bilen. ");
INSERT INTO aey_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Aria Samla cal meceb Saol, uqa Rehobot wanadec, uqa uqana cudun umei hatu ilo dana bilen. ");
INSERT INTO aey_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Aria Saol cal meceb Bal-hanan, uqa Akbo melah, uqa uqana cudun umei hatu ilo dana bilen. ");
INSERT INTO aey_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Aria Bal-haran, uqa Akbo melah, cal meceb Hadad uqa uqana cudun umei hatu ilo dana bilen. Uqana taun ijan eu Pau. Uqa aideg ijan eu Mehetabel, eu Matred ateg. Matred eu Mesahab ateg. ");
INSERT INTO aey_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Aria Iso uqa Idom sihul cunug agena ilo bilen, uqa Idom asag. Idom agena sihul age jobon medeh filfil bilein. Ijanaga eu Timna, Alwa, Jetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsa, Magdiel, Iramca. ");
INSERT INTO aey_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Aria Jekob uqa maha memeg bilenna eu Kenan ono bilen. ");
INSERT INTO aey_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jekobna je eu odi. Aria Josef uqa mel haun uqana cabi gel 17 saen euna uqa waliagul, eu Jekob aidegul lecis Bilha Silpaca melemegail, gami dool cofadein. Qa Josef uqa waliagul kobol me qee leih odoin eu hu memeg sadon. ");
INSERT INTO aey_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Aria Jekob uqa toia bibilen Josef uqa cali hon. Eunu uqa Josefnu ben bahic nalug men. Odocob memeg uqa lotoc deweg cunug jahuldocnu gaga mati bahicca muditon. ");
INSERT INTO aey_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Odocob Josef waliagul age memega Josefnu nalug ben bahic men eu fimeig age uqanu gemanaga ben. Eunu age je me bahic madocnu eu wawaga qee nijoloi. ");
INSERT INTO aey_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Aria witic osona Josef uqa bebelen. Odocob bebelec eu uqa waliagul saadeceb age uqanu gemanaga ben bahic ben. ");
INSERT INTO aey_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Uqa maaden, “Bebelec ija bebeliga i dah meiga. ");
INSERT INTO aey_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ege wit gug cabina sog cecedoqon ijana sog eu caji tutuc taweia. Odocob agena sog eu ijana eu talildu tawimeig ijana sog amegna jogoeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Odocob waliagul age madoin, “Hina egena ilo bileganfo? Hina egena cofgec bileganfo?” doin. Eu odi maadeceb casac gemanaga ben eu wooldoc gemanaga ben. ");
INSERT INTO aey_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Odocob Josef uqa bebelec osoha bebelen eu saaden, “Dah meiga. Ija bebelec osoha bebelem eu odi, camca jagelca malaqa 11ca age ija amina jogoeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Odocob uqa bebelec eu uqa memegha sadon. Odocob memeg uqa galac mumudi madon, “Eu cel bebelec bahic? Ijaca hina aninca hina walinelca ege mele bahic hinaca humeb hina amenna jogoecnufo?” don. ");
INSERT INTO aey_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Odon waliagul age uqanu gonagona mein. Qa memeg eu je maden eu cunug uqana cisdocna men. ");
INSERT INTO aey_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Aria Josef waliagul age memegana dool am cofadoqaga bili Sekem ono belein. ");
INSERT INTO aey_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Odocob Jekob uqa Josef madon, “Hina walinel age Sekem ono dool am cofadegina. Ija sulhecemin nuegan,” don. Odocob Josef madon, “Cois, eu ihoc,” don. ");
INSERT INTO aey_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Odocob Jekob uqa madon, “Hina nuimeg walinel dool amca me bileigafo feciadegan. Odimeg ceseli hu mataga,” don. Eunu uqa Josef suldocob Hebron maha asounadec Sekem ono nuen. Nuimei Sekem calen. ");
INSERT INTO aey_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Odocob uqa ono cabina calimei wawaladi cocobon dana oso gulucdumei sisildon, “Hina celnu fecii cobogona?” don. ");
INSERT INTO aey_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Odocob uqa jejeg hewi madon, “Ija walielnu feciigina. Ana dool am cofadegina eu hina matecnu ihocfo?” don. ");
INSERT INTO aey_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Odocob dana eu madon, “Age enedec wele beleiga. Age odi mamadegin duga, ‘Gec, ege Dotan beloqa,’ eegin duga,” don. Eunu Josef uqa waliagul tooadi nuimei Dotan ono gulucaden. ");
INSERT INTO aey_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Qa uqa filec hohon fimeig age cemenega qee lec ninijen age qocobil cal migiannu je madi cagoin. ");
INSERT INTO aey_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Odocob age madocobmadocob ein, “Bebelec dana i hec hona. ");
INSERT INTO aey_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Gec hoiga, ege qagadumeb wa hel maha dunuh qelecnu. Odimeb ege madecnu, ‘Dool hanca oso qu jeia,’ ecnu. Odocob uqana bebelec eu mele caligianfo qeefo ege fecnu,” ein. ");
INSERT INTO aey_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Qa Ruben uqa je eu dah mimei uqa Josef cal mecnadec cahahadon. Odocob uqa maaden, “Ege uqa cain qocomun cal meiaun. ");
INSERT INTO aey_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ege uqa golac cain basecdoqaun. Wa hel wadauna nijia ina helocomun nugian. Qa uqa deweg oso cain tudowain,” aden. Ruben uqa je eu odi maaden eu uqa waliag cal mecnadec cahahadumei ceseli memegca ehudi ligiannu ec cisdon. ");
INSERT INTO aey_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Eunu Josef uqa waliagul cemenega leceb uqana lotoc gaga mati bahic eu hulitumeig ");
INSERT INTO aey_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ehudi li wa helna helecebil non. Aria wa hel euna waca qee, eu galalec nijen. ");
INSERT INTO aey_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Odocob age sab joqaga bili bibilegin dana Ismal sihuldec age Giliaddec agena kamel mati bahic big togoctogoc hohogin feciadein. Agena kamel euna sabca cilecebil tinca mecnu euca gilic dedemanca ceteteh eundec gahidu age Isip noin. ");
INSERT INTO aey_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Odocob Juda uqa waliagul maaden, “Ege walinige qagadumeb je jahunifeb ege eunadec cel ameg oso ocnu? ");
INSERT INTO aey_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Gec hoiga, ege uqa Ismal dana ebenegana idadocnu. Qa ege uqa deweg oso cain tudoqaun. Naha, uqa ege walinige ege golanige osol,” aden. Odocob Juda waliagul age je eu dah mimeig eu odi odocnu ein. ");
INSERT INTO aey_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Odocob Midiandec idadec dana age cemenega hohogin Josef waliagul age Josef helnadec didocobil cali ben. Odocob age Josef Ismal ebenegana mimi meen qaig silwa 20 oin. Odocobil Ismal dana Josef ehudi Isip noin. ");
INSERT INTO aey_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Saen leih leceb Ruben haun ceseli Josef figiannu wa helna len qa Josef uqa ono qee bilel. Eunu uqa uqana lotoc baladon. ");
INSERT INTO aey_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Odimei uqa waliagul ceseli nui maaden, “Mel eu ono qee bilel. Qila ija adi odigen?” aden. ");
INSERT INTO aey_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Eunu Josefna lotoc umeig meme oso qocobil cal meceb uqana golac euna age Josefna lotoc eu cumdoiga. ");
INSERT INTO aey_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Odocobil age lotoc gaga mati eu umeig memegaca ehi belein. Odimeig madoin, “Ege lotoc gulucdoqa. Faga, eu hina melem uqana lotocfo qeefo?” doin. ");
INSERT INTO aey_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Odocob eu fimei uqa maden, “O ija melami uqana lotoc. Dool cus oso uqa jeudia. Mele bahic Josef tatali calcaldoia,” en. ");
INSERT INTO aey_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Eunu Jekob uqa uqana lotoc baladon. Odimei uqa gehel lotoc u tacen. Odimei uqa melahnu deel mati bahic qada qaqaji bilen. ");
INSERT INTO aey_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Uqa qaqajen melahul ategulca age wahohogdoqagannu caji uqaca lein. Qa age wahohogdocnu eu culen. Odocob uqa maaden, “Mele bahic ijana qada qajecna himec ija melamica helna nugen,” aden. Eunu memeg uqanu qaqaji bilen. ");
INSERT INTO aey_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Oodon Midian dana age Josef Isip ono ehudi numeig Potifaca idadoin. Potifa uqa Ferona han dana agena ilo. ");
INSERT INTO aey_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Aria saen euna Juda uqa waliagul culadimei Adulam ono non. Uqa dana oso, ijan Hiraca, biluwasannu non. ");
INSERT INTO aey_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ono Juda uqa Kenandec caja oso fen. Uqa memeg ijan eu Sua. Odocob uqa caja eu ocob uqaca nijesin. ");
INSERT INTO aey_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Odocobil uqa melca mimei mel oso baseceb Juda ijan Er qon. ");
INSERT INTO aey_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Odocob uqa haun melca mimei mel oso baseceb uqa ijan Onan qon. ");
INSERT INTO aey_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Odocob uqa haun mel oso baseceb uqa ijan Sela qon. Sela uqa Kesib ono basiton. ");
INSERT INTO aey_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Odocob Juda uqa melah matu, Er, uqana caja uton. Caja uqa ijan Tema. ");
INSERT INTO aey_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Qa Er, Judana mel matu, uqa Tibud amegna eu qisol dana. Eunu Tibud uqa qagadocob uqa cal men. ");
INSERT INTO aey_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Odocob Juda uqa Onan madon, “Hina walin aidegca lecem nijesia. Kobol i eu odi. Hina walin uqa melca qee. Eunu hina walin aideg ocom mel basigian eu hina walin ijan qumeg uqana sihul calitugiannu,” don. ");
INSERT INTO aey_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Qa Onan mel cali hoqagan eu uqana qee eu uqa don. Eunu saen uqa waliag aidegca niniji olosi eu uqa uqana hinih eu gauc mahana basecdoloi. Euqa uqa waliag aideg mel cain baseiaunnu odoloi. ");
INSERT INTO aey_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Uqa kobol odon eu Tibud amegna qisol kobol bahic. Eunu Tibud uqa qagadocob uqaha cal men. ");
INSERT INTO aey_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Odocob Juda uqa cisdon, “Sela uqa Er aideg, Tema, aidegnu ocobfi uqa waliagul cal mesin eu odi cal mec dain,” en. Eunu Juda uqa Tema madon, “Hina memenca uqana jona ceseli nuuga. Ono caja wij bibilem li ija melami Sela uqa ben migian,” don. Odocob Tema uqa memegna jona biligiannu nuen. ");
INSERT INTO aey_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Saen mati bahic leceb Juda aideg, uqa Sua ateg, uqa cal men. Odocob gehel saen hedocob Juda uqa Timna ono ten. Uqa dana uqana sipsip bagic jejehegin feciadecnu ten. Odocob uqana danah Hira Adulamdec uqa Judaca tesin. ");
INSERT INTO aey_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Saen Tema uqa Juda Timna ono sipsip bagic jehecnu tena ec dumei ");
INSERT INTO aey_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","uqa caja wij agena lotoc eu hulimei caja oso ola ugia bili lotoc nag osona ola jahuldon. Odimei uqa li Enaim gel cebecna bilen. Euqa Timna jic nuecna. Aria Juda melah Sela uqa wele ben men Tema uqa don qa Sela uqa Tema qee ol. Eunu uqa odi odon. ");
INSERT INTO aey_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Odocob Juda uqa humei Tema fecidodon uqa ola jahuldon. Eunu caja eu uqa wal caja ec cisdon. ");
INSERT INTO aey_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Juda uqa caja eu uqa melah aideg ec qee dol. Eunu uqa uqaca jic gesacna limei madon, “Hoga, ijaca nijuwa,” don. Odocob uqa sisildon, “Hinaca nijifeu hina eeta itegan?” don. ");
INSERT INTO aey_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Odocob uqa jejeg hewi madon, “Ija meme nag oso ijana amnadec sulduhigen,” don. Odocob caja uqa madon, “Euqa cois. Hina qilaqa ceteh oso hina je cagu madaga meme nag oso itegan aga eu uqana gadac cinigwe itiga,” don. ");
INSERT INTO aey_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Odocob uqa sisildon, “Cel oso gadac cinigwe ihigen?” don. Odocob uqa jejeg hewi madon, “Hinana golegoleca ijain gaga mudec cetehca hinana gom hewegena euca itadegan,” don. Eunu uqa ceteteh eu utadeceb uqaca nijesin. Odocob uqa hibna melca men. ");
INSERT INTO aey_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Aria Tema uqa Juda culdi limei uqa lotoc ola jahuldon eu cagasi umei caja wij agena lotoc euna haun bala falen. ");
INSERT INTO aey_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Odocob Juda uqa limei uqana ceteteh caja uten eu cedigiannu uqana danah Hira uqa meme nagca suldon. Qa uqana danah uqa caja eu qee gulucdol. ");
INSERT INTO aey_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Odocob Judana danah eu dana ono bilegina eu sisiladen, “Wal caja uqa Enaim jic gesacna bilia eu ana bilia?” aden. Qa age madoin, “Wal caja oso ene qee bilinanu,” doin. ");
INSERT INTO aey_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Eunu uqa ceseli Judaca limei madon, “Ija uqa qee gulucdolom. Euha dana ono bilegina age mateiga, ‘Wal caja oso ono qee bilinanu,’ teiga,” don. ");
INSERT INTO aey_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Odocob Juda madon, “Ceteteh uqa ceden eu hawadoga uqa cois cedeia. Ele ceteteh eu cedecnu haun sisilocohulfi age asalloqagan. Ija meme nag fajudocnu suldugaqa hina qee gulucdolom,” don. ");
INSERT INTO aey_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Aria jagel ijed eu odi hedocob dana oso uqa Juda madon, “Hina melem aideg, Tema, uqa wal cajawe odoloi. Odocob qila uqa melca men,” don. Odocob Juda uqa maaden, “Ehudi ahoiga. Jana manecebil ja cijeceb cal meia,” aden. ");
INSERT INTO aey_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Age ehudi aahogin Tema uqa Judaca je suldudu madon, “Ceteteh i faga. Dana ija melca miten uqanacin. Gole goleca ijan gaga mudec cetehca gomca faga. Eu inna?” don. ");
INSERT INTO aey_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Odocob Juda ceteteh eu feciadimei uqana eu don. Uqa maaden, “Uqa caja ititom bahic. Uqa ija wooltec. Ija melami Sela aidegnu utoum qa qee utelem,” aden. Odocob uqa haun Temaca qee nijelesin. ");
INSERT INTO aey_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Aria Temana mel sim basec saen dodoldodon mel gahca ale waugna ninijesin tebandon. ");
INSERT INTO aey_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Odocob uqa mel babasen mel momodo oso eben men. Eunu caja cesuldoin eundec oso uqa golac haluna eben eu qagen. Odimei uqa maden, “I uqa casac cali hoia,” en. ");
INSERT INTO aey_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Qa uqa eben ceseli ocob uqa waliag cali hon. Odocob uqa maden, “Hina batawi cali hoga eu odi,” en. Eunu uqa ijan Peres qon. ");
INSERT INTO aey_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Odocob uqa waliag ebenna golac halu eu cali hocob ijan Sera qoin. ");
INSERT INTO aey_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Aria Ismal sihuldec dana age Josef ehudi Isip noin. Odocob Potifa uqa Josef Ismal dana ebeneganadec fajudi on. Potifa uqa Isipdec dana ben. Uqa Farona han dana am oso age Ferona jo cofdocnu uqa eu agena ilo. ");
INSERT INTO aey_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Odocob Tibud Josefca bilen. Eunu uqa uqana cabi eu cunug me bahic calen. Uqa uqana ben Isipdec eu uqana jona bilen. ");
INSERT INTO aey_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Odocob uqana ben Tibud uqa Josefca bilen eu fen. Uqana cabi uqa amegna calen eu me bahic himec euha fen. ");
INSERT INTO aey_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Eunu uqana ben uqa Josefnu waug nijen. Odocob uqa Josef uqana cabi dana matu mudon. Odimei uqa uqana joca uqana ceteteh cunugca cofdocnu cabi uten. ");
INSERT INTO aey_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Saen eunadec nueceb Tibud Josefnu Potifana ceteteh cunug jona bileiga euca eeldon. Josef uqa jo euna bilen. Eunu Tibud uqa ceteteh cunug jonaca cabinaca eeldon. ");
INSERT INTO aey_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Odocob Potifa uqa ceteteh cunug uqana eu Josef ebenna men. Uqa ceteteh cunug cofdocnu qee cisdol. Qa sab jecnu himec eu uqa cofdon. Aria Josef uqa ola eu fecnu galeca. Uqa dewegha fecnu galeca. ");
INSERT INTO aey_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Odocob saen leih leceb uqana ben aideg Josefnu ameg qon. Odocob uqa Josef madon, “Hocom ijaca nijewan,” don. ");
INSERT INTO aey_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Qa uqa madon, “Cain, ijana ben jo i cofdocnu miten. Uqa ceteh oso jona bilia eunu qee cisdol. Ceteteh cunug uqana eu ija cofdugennu ebenina men. ");
INSERT INTO aey_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Dana oso jona ija wooltec qee bilel. Ijana ben uqa jona ceteteh cunug cofdocnu ija iten. Qa hina uqa aideg. Hina cofhecnu qee itel. Qisol kobol i adi odigen? Odimig Anut amegna silail migennu mataganafo?” don. ");
INSERT INTO aey_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Odocob uqa deel abesabes cunug Josef uqaca nijuwasannu ninicdon qa Josef uqaca qee nijelesin. Uqa cemenug bilecnu culoloi. ");
INSERT INTO aey_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Odocob deel osona Josef uqa cabi ugia bili jo dunuh len. Odonqa saen euna ha cabi dana leih age jo dunuh ono qee cabi oloin. ");
INSERT INTO aey_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Odocob Potifa aideg uqa uqana lotoc hewi didumei madon, “Hoga, ijaca nijuwa,” don. Qa uqa lotoc ebenna culitotoi busalen. Odimei maha gumu calen. ");
INSERT INTO aey_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Uqa lotoc ebenna culitotoi busali maha gumu cali len eu fimei ");
INSERT INTO aey_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","uqa cabi dana maha gumu eu utaadi maaden, “Feiga, Hibrudec i ija gemuni jona ehudi ahon eu uqa odigeceb ege majanige geia. Uqa ene hewiteceb ijaca nijewannu hoiaqa ija euiga. ");
INSERT INTO aey_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Odocob uqa ija euecemin dah mimei uqa uqana lotoc ija cemeni cuculi busali maha gumu cali leia,” aden. ");
INSERT INTO aey_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Eunu Potifa aideg uqa Josefna lotoc eu men bibilen uqa gemug jona hon. ");
INSERT INTO aey_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Odocob uqa gemug je i madon, “Hibrudec cabi dana hina egena cabi ugiannu fajudi om eu ijaca hamol hoia. Uqa ijaca nijewannu hoia. ");
INSERT INTO aey_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Odocob ija euecemin uqa uqana lotoc ija cemeni cuculi busali maha gumu cali leia,” don. ");
INSERT INTO aey_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Odocob Josef uqana ben aideg je eu odi madocob uqa gemag eu ja cinigwe ben. ");
INSERT INTO aey_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Odocob Josef uqana ben uqana han dana maadeceb age Josef ehudimeig gihacdoc jona ehi li tacudein. Gihacdoc jo eu Ferona gihacdoc dana bilein euna age Josef tacecebil bilen. ");
INSERT INTO aey_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Qa Josef gihacdoc jona bibilen Tibud uqa Josefca bilimei uqa eeldon. Odocob dana gihacdoc jo cofdoc eu Josefnu waug me nijen. ");
INSERT INTO aey_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Eunu dana gihacdoc jo cofdoc uqa Josef gihacdoc dana cunug cofadecnu muden. Odimei cabi cunug Josef ebenna men. ");
INSERT INTO aey_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Aria Tibud uqa Josefca bilen. Odocob Josef uqa cabi cunug me bahic odon. Eunu dana gihacdoc jo cofdoc eu uqana cabi eunu uqa qee cisdol. ");
INSERT INTO aey_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Aria saen leih leceb Ferona wain gabin hewec ilo danaca uqana bret manec ilo danaca ale Fero, uqa Isip agena ilo, odudecebil gemag ben. ");
INSERT INTO aey_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","Odocob Fero uqa han dana maadeceb age cabi ilo dana i alenu uqa gemag ben eu cedalimeig gihacdoc jona malein. Gihacdoc jo eu han dana ilo uqa cofdoloi. Gihacdoc jo euna Josef uqaha bilen. ");
INSERT INTO aey_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Odocob han ilo i uqa Josef madon, “Hina cabi ilo dana i alena cabi dana bilegan,” don. Aria age euna bibilegin saen nag leceb ");
INSERT INTO aey_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ferona wain gabin hewec ilo danaca uqana bret manec ilo danaca ale witic osona bebelesin. Qa alena bebelec eu fil. Bebelec lecis alena gug eu fil. ");
INSERT INTO aey_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Qasilna Josef uqa humei ale olanala gulu qeeca bibilesin fecialen. ");
INSERT INTO aey_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Eunu uqa sisilalen, “Celnu ale olanala gulu qeeca bilesia?” alen. ");
INSERT INTO aey_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Odocob ale jejeg hewi madosin, “Ele lecisca odi bebelowa. Qa dana oso gug sildilecnu qee bilel,” dosin. Odocob Josef uqa maalen, “Gug sildec cabi eu Anutna himec. Alena bebelec satesia duga,” alen. ");
INSERT INTO aey_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Odocob wain gabin hewec ilo dana uqa uqana bebelec Josef sadu madon, “Ijana bebelecna ija wain halu olanina tatawen figa. ");
INSERT INTO aey_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Wain halu eu batac ijed. Ija uqana bobog qee cifilicdoc figa. Oodon bobog cifilicdodon figa. Odocob ija aig qumei ben mi wal memen figa. ");
INSERT INTO aey_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Odocob Ferona wain gabin eu ija ebenina bibilen ija aig eu cedimig cafdocomin Ferona gabinna noia. Odocob gabin eu uqa ebenna miga. I odi figa,” don. ");
INSERT INTO aey_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Odocob Josef madon, “Bebelec gug eu i edi. Batac ijed eu deel ijed. ");
INSERT INTO aey_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Odocob deel ijed hedocob Fero uqa hina enedec besihi oihimei hinana cabi ilo weledec eu haun ihigian. Odocob hina haun Ferona gabin uqa ebenna megan. Euqa hina wele uqa ebenna wain gabin molog eu odi odegan. ");
INSERT INTO aey_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Qa ceteh ija mahiga eu me calecebfi ijanu me cisdogale. Ijanu Fero madoga. Odocob uqa ija gihacdoc cudun inadec besitigian. ");
INSERT INTO aey_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ija qee gale tecna Hibru agena mahanadec ehiti ene ahoin. Odocob ha ija qila gihacdoc jona biliga eu ija ceteh oso qee cahuldolom. Ija gauc bahic ene ahu mitein. Eunu ijanu Fero madoga,” don. ");
INSERT INTO aey_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Oodon bret manec ilo dana uqa Josef bebelec eu uqana gug me bahic dah mimei uqa madon, “Ijaha bebeliga,” don. Odocob uqa edi sadu madon, “Ija ilomina bret galelca ijed bileiga. ");
INSERT INTO aey_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Galel tatacan bilia euna Ferona bret gug filfil manec figa. Qa man fufulec age galel ilomina bilia eunadec jejegin meciadiga. Ija odi figa,” don. ");
INSERT INTO aey_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Odocob Josef uqa madon, “Bebelec gug eu i edi. Galel ijed eu deel ijed. ");
INSERT INTO aey_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Deel ijed hedocob Fero uqa enedec besihi oihigian. Odimei uqa hina ben qetigian. Odimei nana dewen cabusihigian. Odocob man fululec age hina cuhunin joqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Aria hibna deel ijed docna eu Fero uqana basen deel. Eunu uqa sab ben uqana cabi dana iloilo eu ciliaden. Saen euna uqa uqana wain gabin hewec ilo danaca bret manec ilo danaca eu ale gihacdoc jonadec uqana cabi dana iloilo amagana besali cedalen. ");
INSERT INTO aey_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Odocob uqa wain gabin hewec ilo dana eu uqana cabi weledec euna haun ehi li muden. Eunu uqa haun wain gabin Fero ebenna miton. ");
INSERT INTO aey_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Qa uqa bret manec ilo dana eu nana deweg cabusudoin. Eu Josef maalen eu odi bahic toodu odalein. ");
INSERT INTO aey_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Odonqa wain gabin hewec ilo dana uqa Josefnu qee cisdol. Uqa dahig celen. ");
INSERT INTO aey_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Aria cabi gel lecis hedocob Fero uqa bebelen. Bebelec eu i edi. Uqa Nail wa ofna tatawen ");
INSERT INTO aey_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","bulmakau bobogolec eben naha gic lecisca Nail wa dunuhdec cali bein eu uqa feciaden. Age bohboh lec feciaden. Odocob age wa colna gigi jejegin feciaden. ");
INSERT INTO aey_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Odocob bulmakau qehemega becca meciadecnu galeca qee age Nail wa dunuhdec cali bein eu feciaden. Odimeig age wa colna bulmakau eben naha gic lecisca age casac cali bein eu cemenega tawein. ");
INSERT INTO aey_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Odocob bulmakau qehemega bec age bulmakau bobogolec eu belucadein. Odocob Fero uqa seeli cajen. ");
INSERT INTO aey_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Odocob uqa haun us nijen. Odimei haun bebeli lecis dumei uqa macin eben naha gic lecisca me bahic bobogolec age macin gug osolna hanoc tatawegin feciaden. ");
INSERT INTO aey_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Odocob haun macin eben naha gic lecisca fufu maha daincanadec welacadec eu cogain aqec age hanoc tatawegin feciaden. ");
INSERT INTO aey_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Odocob age tawimeig macin eben naha gic lecisca bobogolec eu belucaadegin feciaden. Odocob Fero uqa seeli cajimei uqa bebelen eu don. ");
INSERT INTO aey_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Qasil uqa bebelec eunu jaen qon. Eunu uqa doi mec danaca Isipdec doc danaca je sulduadeceb hocobil Fero uqana bebelec eu saaden. Euqa dana eundec oso age bebelec eu alena gugnu qee fogo dol. ");
INSERT INTO aey_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Odocob Fero uqana wain gabin hewec ilo dana uqa Fero madon, “Qila ija cahuldom eu cisdugina. ");
INSERT INTO aey_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Saen osona hina hinana cabi dananu gemain ben. Odocob uqa ija uqana bret manec ilo danaca ele han dana Fero cofdogina eu uqana ilo uqana gihacdoc jona tacilen. ");
INSERT INTO aey_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Aria witic osona ele lecisca bebelec filfil bebeloh. Odocob bebelec eu alena gugha osol qee. ");
INSERT INTO aey_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Aria Hibrudec dana haun oso uqa ege gami bilom. Uqa hinana han dana uqa cofdoc agena ilo dana eu uqana cabi dana. Odocob ele elena bebelec sadoh. Odocob uqa bebelec eu alena gug filfil eu malen. ");
INSERT INTO aey_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Uqa bebelec gug malen eu, eu odi toodu calen. Hina ija gihacdoc jonadec besiti oitimeg ijana cabi weledecna mitem. Odocob dana oso eu age be qetecebil cal men,” don. ");
INSERT INTO aey_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Odocob Fero uqa Josefnu je suldocob age mahucwe bahic Josef gihacdoc jonadec ehudi ahoin. Odocob uqa met qumei lotoc haun tacimei uqa Fero amegna hon. ");
INSERT INTO aey_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Odocob Fero uqa Josef madon, “Ija bebeliga. Qa dana oso uqa bebelec eu gug matecnu ihoc qee. Qa hina bebelec gugnu sildec ihoc ec ija dah miga,” don. ");
INSERT INTO aey_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Odocob Josef uqa madon, “O ijana ben ija ijadodoc ihoc qee. Qa Anut ija cesulteceb hina sildihecemin wawin me nijigian,” don. ");
INSERT INTO aey_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Odocob Fero uqa Josef madon, “Ijana bebelecna ija Nail wa ofna tatawigin ");
INSERT INTO aey_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","wa dunuhdec bulmakau bobogolec eben naha gic lecisca cali beiga. Odimeig age wa colna gigi jejegin feciadiga. ");
INSERT INTO aey_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Odocob haun bulmakau eben naha gic lecisca cali beiga. Eu age qehemega bec meciadecnu galeca qee. Bulmakau meciadecnu galeca qee eu Isip mahana oso eu odi qee felem. ");
INSERT INTO aey_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Odocob bulmakau qehemega bec age tawimeig bulmakau bobogolec eu belucadeiga. ");
INSERT INTO aey_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Euqa age meciadecnu galeca qee eu odi himec. Dana oso uqa meciadifei age bobogolec eu belucadeiga ec qee doiaun. Odocob ija seeli cajiga. ");
INSERT INTO aey_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Odocob ija ijana bebelecnaha macin bobogolec eben naha gic lecisca feciadiga. Macin eu gug osolna himec hahanon feciadiga. ");
INSERT INTO aey_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Odocob macin eben naha gic lecisca fufu maha daincanadec welacadec eu cogain aqec age cali hohogin feciadiga. ");
INSERT INTO aey_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Odocob age cali humeig macin eben naha gic lecisca bobogolec eu belucaadegin feciadiga. Ija bebelec i doi mec dana saadigaqa agena eundec oso uqana bebelec i gug silditecnu ihoc qee,” don. ");
INSERT INTO aey_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Odocob Josef uqa Fero madon, “Hinana bebelec lecis eu abesabes qee. Uqana gug eu osol. Anut uqa ceteh odigiannu ihacheia. ");
INSERT INTO aey_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulmakau eben naha gic lecisca bobogolec macin eben naha gic lecisca bobogolecca eu gug osol. Gug eu odi. Lu saen oso caligian. Eu ninijeb li cabi gel eben naha gic lecisca ugian. ");
INSERT INTO aey_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Odocob bulmakau qehemega bec macin cogain qocca euha gug osol. Lu saen eu hedocob cahel saen caligian. Euha ninijeb li cabi gel eben naha gic lecisca ugian. ");
INSERT INTO aey_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Je ija mahiga eu odiwe, Anut uqa ceteh odigiannu ihacheia. ");
INSERT INTO aey_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Faga, sab geh Isip maha cunugna caligiannu uqana saen hona. Eu uqa cali ninijeb li cabi gel eben naha gic lecisca ugian. ");
INSERT INTO aey_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Qa eu hedocob cahel saen toodu hugian. Eu cabi gel eben naha gic lecisca nijigian. Euqa cahel saen eu maha me qee mudugian. Eunu sab geh bahic nijigian saen eunu dahanaga celegian. ");
INSERT INTO aey_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Cahel saen caligian eu me qee bahic nijigian. Eunu maha ina sab geh bahic ninijeb saen eunu qee cisdowain. ");
INSERT INTO aey_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Aria bebelec eu bebeli lecis doga eu uqana gug eu odi. Anut uqa wele eu odi odigen imei odeia. Euqa uqa saen gohicna wele odigian. ");
INSERT INTO aey_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Aria eunu Fero, hina dana cisdoc gesilecca oso fimeg Isip maha i cofdocnu mudoum. ");
INSERT INTO aey_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Hina sab cofdoc dana Isip hatunadec gesil cedadaga. Lu saen sab cabi gel eben naha gic leciscana nijigian euna sab cofdoc dana eu age sab inadec oc saenna age sab dana ebeneganadec haudumeig ila mecebil am ebum osahic caligian. Odocob am osahic eundec age hina ihuqagan. ");
INSERT INTO aey_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Hina maadecem age sab lu saen hona eunadec cunug cedi haudumeig taun benna jona moqagan. Sab eu jona ninijeb eu Fero uqana. Eu hinana han dana cofdoqagan. ");
INSERT INTO aey_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Sab i hibna jecnu abes moqagan. Euqa cahel saen Isip hatuna calimei ninijeb li cabi gel eben naha gic lecisca ugian saen euna joqagannu abes moqagan. Isip hatu cunug cahel saenna me qee mudecdainnu eu odi odegan,” don. ");
INSERT INTO aey_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Josef je maden eu Fero uqaca uqana cabi ilo danaca age je dah mein eu me bahic. ");
INSERT INTO aey_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Odocob Fero uqa cabi ilo dana maaden, “Ege dana oso dana i cinigwe Anutna Kis uqaca bilina oso qee gulucdoqaun,” aden. ");
INSERT INTO aey_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Eunu Fero uqa Josef madon, “Anut hina ceteh inu maheia. Dana oso cisdoc silecca hina cinigwe oso qee bilel. ");
INSERT INTO aey_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Hina ijana jonu ilo bilegan. Odocob ijana dana cunug age hina con toodu odoqagan. Ija king eunu ija himec hina woolhec biligen. ");
INSERT INTO aey_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ija qila hina Isip maha cofdocnu ilo mihigina,” don. ");
INSERT INTO aey_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Odocob Fero uqa ijan gaga mudec eben gicnadec umei Josef eben gicna taciton. Odocob uqa lotoc cecelac me bahic oso umei Josef taciton. Odimei gilolo golna mudec oso umei Josef benna be awiton. ");
INSERT INTO aey_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Odocob Fero uqa uqana karis lecis doc eu uteceb euna cobon. Cocobon Fero uqana han cofdoc dana age aquni utai madein, “Isa qoiga! Isa qoiga!” adein. Eunu uqa Isip maha cunugnu ilo muden. ");
INSERT INTO aey_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Odocob Fero uqa Josef madon, “Ija Fero. Loo oso Isipdec hina qee madec ceteh oso qee odeiaun. Uqa hina sisilhimei himec odigian,” don. ");
INSERT INTO aey_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Odocob Fero uqa Josef Isipdec ijan oso qon. Uqa Safenat-panea don. Odimei uqa caja oso uton. Ijan eu Asenat. Uqa Potifera ateg. Potifera uqa ihanec dana oso Heliopolis bilen. Odocob Josef uqa Isip maha cunugna coboloi. ");
INSERT INTO aey_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Aria saen euna Josef uqana cabi gel eu 30 uqa Fero Isipdec king cabi euna muden. Odocob uqa Fero cemenugnadec culimei nui Isip maha cunugna coboloi. ");
INSERT INTO aey_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Odocob lu saen cabi gel eben naha gic lecisca euna sab geh bahic maha euna calen. ");
INSERT INTO aey_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Odocob Josef uqa sab cunug lu saen cabi gel eben naha gic lecisca eunadec cedi haudumei taun benbenna jona men. Taun cunug agena cabi talildu nijein Josef uqa cabi eundec sab cedimei uqa taun euna men. Uqa taun cunugnu eu odiodi odoloi. ");
INSERT INTO aey_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Josef uqa sab geh bahic haudon. Eunu uqa saniadeceb len ihoc qee, mati bahic. Odocobnu uqa saniec culen. ");
INSERT INTO aey_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Odocob cahel saen qee hoc ninijen Josef uqa aideg, Asenat, uqa mel lecis basaliton. ");
INSERT INTO aey_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Odocob Josef uqa melah matu eu ijan Manasa qon. Uqa maden, “Anut uqa oditeceb ija ijana culumennuca ija meinuca walielnuca dahini celeia,” en. Eunu uqa melah ijan eu odi qon. ");
INSERT INTO aey_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Odocob uqa maden, “Anut uqa ija culumenca bilec mahana mel iten,” en. Eunu melah milum eu ijan Ifrem qon. ");
INSERT INTO aey_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Aria odocob lu saen cabi gel eben naha gic lecisca Isip mahana eu cit qon. ");
INSERT INTO aey_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Odocob cahel saen cabi gel eben naha gic lecisca eu sanan men. Eu Josef je maden eu odi bahic toodu calen. Odocob cahel saen maha cunug ihoc len qa Isip hatuna eu sabca bilen. ");
INSERT INTO aey_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Saen cahel saen eu Isip maha cunug ihoc leceb dana cajaca age wen adec tebandoin. Odocobnu age Fero inoni madoin, “Sab igiga,” doin. Odocob Fero dana caja Isipdec maaden, “Josefca leiga. Uqa cel je oso maadigian eu odi toodu odeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Saen cahel eu Isip hatu cunug ihoc leceb Josef uqa sab jo jic hudimei Isipdec dana cajaca idadoqagannu suldoloi. Oodon saen euna Isip mahana cahel eu me qee bahic nijen. ");
INSERT INTO aey_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Aria cahel eu hatuhatu cunugna me qee bahic ihoc li nijen. Eunu dana hatu filfilnadec age Isip ono sab Josef ebennadec fajoqagannu holoig. ");
INSERT INTO aey_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Aria Jekob Isip ono sabca uqa don. Eunu uqa melahul maaden, “Age eetanu gauc bilegina? ");
INSERT INTO aey_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Feiga, Isip ono sabca eu ija dah miga. Age ono numeig cudun eunadec egena sab leih fajeiga. Eufi ege cebac bilecnu, ege qee cal moqaun,” aden. ");
INSERT INTO aey_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Odocob Josef waliagul 10 eu age sab Isipdec fajoqagannu ono noin. ");
INSERT INTO aey_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Qa Jekob uqa Josef waliag gug, Benjamin, waliagul gami qee suldol. Uqa cisdon, “Cal mec oso uqaca hocdain,” en. Eunu uqa Benjamin suldocnu cucuien. ");
INSERT INTO aey_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Aria cahel saen calen eu Kenan hatuha on. Eunu Jekob melahul age sab fajoqagannu nonogin age dana leih ageha sab fajoqagannu nonogin eu osoben gabandu noin. ");
INSERT INTO aey_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Aria Josef uqa hatu eu ilo bilen. Odocob uqa dana hatu cunug eunadec hocobil sab idadec cabi oloi. Odocob Josef waliagul age humeig uqa amegna jogoi nu maha cotadoin. ");
INSERT INTO aey_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Saen Josef uqa waliagul meciadimei uqa wele don qa uqa dana celedec cinigwe ihocon qumei uqa je gagadic sisiladen, “Age anadec hoiga?” aden. Odocob age jejeg hewi madoin, “Ege Kenan hatunadec sab fajecnu hoqa,” doin. ");
INSERT INTO aey_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Aria Josef uqa Isip je maaden. Je falicdoc dana oso Hibru je falicdon. Eunu Josef uqa waliagul meciaadi uqa don qa uqa waliagul age eu Josef ec qee doloin. ");
INSERT INTO aey_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Odocob Josef uqa waliagulnu bebelen eunu cisdon. Odimei maaden, “Age hannu cijawi coboc dana. Age egena hatu maha qee cofdoc nijia eu foqagannu hoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Odocob waliagul age jejeg hewi madoin, “Qeeo, egena ben. Ege hinana cabi dana. Ege sab fajeqannu hoqa. ");
INSERT INTO aey_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ege dana osahic melahul. Ege hannu cijawi coboc dana qee. Ege je mele madec dana,” doin. ");
INSERT INTO aey_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Qa uqa maaden, “Qeeo. Age egena maha qee cofdoc nijia eu foqagannu hoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Odocob age madoin, “Egena ben, ege dana osahic melahul. Ege weleca gabandoc cunug eu 12. Ege Kenan mahana biluqona. Odocob subig eu memigeca bilia qa osahic eu wele cal men,” doin. ");
INSERT INTO aey_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Odocob Josef maaden, “Ija wele maadiga eu odi himec. Age hannu cijawi coboc dana. ");
INSERT INTO aey_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ija i edi temadigen. Fero amegna je cagu madigina. Waliniga subig eu ene hugian. Qeefi age cudun i qee culimeig belowain. ");
INSERT INTO aey_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Age eundec oso suldocobil nui waliniga ehudi ahoia. Cunug age gihacdoc jona biluqagan. Odocob agena je eu melefo qeefo ege fecnu? Age cahuldufeig mele bahic, Fero amegna, age hannu cijawi coboc dana,” aden. ");
INSERT INTO aey_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Odocob uqa waliagul cunug gihacdoc jona tacadeceb deel ijed bilein. ");
INSERT INTO aey_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Aria Josef uqa deel ijed docna maaden, “Ija Anut amegna cobigina. Eunu ceteh oso odifeig age cebac biluqagan. ");
INSERT INTO aey_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Age je madec eu melefo qeefo gesilecnu waliniga oso gihacdoc jona age bileiga euna cuculdeig beleiga. Age cahel saennu agena talnu sab gahidumeig beleiga. ");
INSERT INTO aey_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Odimeig waliniga subig eu ijaca ehudi ahoiga. Odocobilfi agena je eu mele eu feqan. Odocob age qee cal mowain,” aden. Odocob Josef maaden eu age cois ege toodu odeqan ec madoin. ");
INSERT INTO aey_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Odocob age madocobmadocob i madein, “Mele bahic ceteh i egeca calena eu celnu? Ege Josef odudom eunu odigina. Ege uqana cucuiecca jaen qocca eu fecomun uqa inongigi maden, ‘Ija cahahateiga,’ een ege uqa qee dah mudecwe mom. Eunu culumen ben bahic qila egeca hoia,” ein. ");
INSERT INTO aey_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Odocob Ruben maaden, “Ija mel eu deweg cain tudowainnu maadem qa age ija qee dah mitilein. Eunu qila ege eu odomnu uqana ameg eu ocnu,” aden. ");
INSERT INTO aey_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Odonqa Josef uqa agena jena je madein eu don. Qa waliagul age eunu qee doloin. ");
INSERT INTO aey_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Odocob uqa culadi limei qajen. Qa uqa haun maadecnu gagadic mimei ceseli humei Simion ihohdumei uqana han dana maadeceb age Simion umeig age amagana eben libein. ");
INSERT INTO aey_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Odocob Josef uqa uqana cabi dana maadeceb age sab agena bekna taciadimeig agena meen qaig silwana mudec haun ceseli tahiadein. Jicna sab jecnu euha adeiga ec maaden. Odocob age eu odi odiadein. ");
INSERT INTO aey_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Odocob Josef waliagul age agena sab udca ceselna meadimeig Isip culimeig belein. ");
INSERT INTO aey_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Age cudun witic meceb nijein euna calimeig age oso uqa cesel sab utigiannu uqana bek co cufalen. Odimei uqana meen qaig silwana mudec eu bek cona bibilen fen. ");
INSERT INTO aey_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Odocob uqa waliagul utaadi maaden, “Ijana qaig eu ceseli taceiga eu bek cona bibilen figa,” aden. Odocob age dumanaga culen. Odocob age qeleli bileig madocobmadocob madein, “Anut uqa i cel kobol ege odigia?” ein. ");
INSERT INTO aey_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Aria age Kenan hatuna calimeig age memega, Jekobca, hoin. Ceteh cunug ageca calen eu sadudu madoin. ");
INSERT INTO aey_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Dana oso, uqa hatu eunadec dana ben, uqa ege je gagadic bahic magen. Odimei uqa ege hannu cijawi coboc dana gen. ");
INSERT INTO aey_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Qa ege madom, ‘Ege hannu cijawi coboc dana qee. Ege mele je madec dana. ");
INSERT INTO aey_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ege dana osol melahul. Ege waliagwaliag, cunug gabandoc eu 12. Oso eu cal men. Subig eu qila ege memigeca ono Kenan mahana bilia,’ dom. ");
INSERT INTO aey_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Odocob dana ben eu magen, ‘Age mele je madec danafo qeefo eu i edi dugen. Age waliniga oso ene ijaca culdimeig agena cahel saennu sab cedimeig agena talca nueiga. ");
INSERT INTO aey_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Qa age waliniga subig eu ehudi ijaca ahoiga. Eufi age hannu cijawi coboc dana qee. Age mele je madec dana eu ija dugen. Odocob ija age waliniga oso i ceseli adigen. Odocob age ene idadecnu hoqagan eu ihoc,’ gen,” age memega je odi sadoin. ");
INSERT INTO aey_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Aria saen age agena beknadec sab hihidi bileig age cunug agena meen qaig badom eu age abesabes agena sab bekna bibilen fein. Odocob Jekob uqa melahul gami age eu odi fimeig age filiciti cucuiein. ");
INSERT INTO aey_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Odocob age memega Jekob uqa maden, “Age ijana mel Josef cawaltein. Uqa qee bilel. Odocob Simion uqaha qee bilel. Odeiaqa qila age Benjamin cawaltoqagannu mateginafo? Age culumen i ija itegina,” aden. ");
INSERT INTO aey_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Odocob Ruben uqa memeg madudu maden, “Benjamin ija ebenina mecem ija cofdodomin belewan. Odocob haun ceseli ahu hinaca mudigen. Ija Benjamin qee ehudi ceseli hocominfi hina ija melamiel lecis eu ale qagaalaga,” don. ");
INSERT INTO aey_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Qa Jekob uqa madon, “Ija melami uqa hinaca Isip ono qee noiaun. Uqa waliag, Josef, eu wele cal men. Odonnu uqa jaih cuhanuc himec bilina. Saen uqa jicna cocobob cal mec oso uqaca hocobfi euqa colini beceb ija toia migen. Eunu ija wawi cagoc bibili helna nugen,” don. ");
INSERT INTO aey_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Aria cahel saen eu qee qee mel. Eu me qee bahic odi nijen. ");
INSERT INTO aey_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Eunu age sab Isipdec ehi bein eu ji qee mudimeig age memega maaden, “Isip haun belimeig sab leih haun fajadeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Qa Juda uqa memeg madon, “Dana eu je gagadic edi magen, ‘Age walinigaca qee hocobilfi ija amina haun qee howain,’ gen. ");
INSERT INTO aey_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Hina ege walinige eu uqaca sulgecemfi ege numeb hinana sab fajihecnu. ");
INSERT INTO aey_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Qa hina uqaca qee sulgecemfi ege qee noqaun. Dana eu uqa edi magen, ‘Age walinigaca qee hocobilfi ija amina haun qee howain,’ gen,” don. ");
INSERT INTO aey_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Odocob Jekob uqa sisiladen, “Age eetanu dana eu madoin, ‘Ege walinige oso bilia,’ ec madoinnu edi me qee bahic oditegina?” aden. ");
INSERT INTO aey_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Qa age madoin, “Dana eu uqa egena sihulnu bahic sisilgen. Uqa odi sisilgen, ‘Age memega cebac biliafo? Age waliniga osocafo?’ gen. Odocob ege uqa sisilec eu jejeg hewom. Qa uqa edi magen, ‘Age waliniga ene ehudi neiga,’ gen eu ege adi docnu?” doin. ");
INSERT INTO aey_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Odocob Juda uqa memeg, Jekob, madon, “Mel eu egeca osoben sulgaga. Odocob ege qila bahic cajimeb beleqan. Eufi ege qee cal moqaun. Ege cebac bilecnu. ");
INSERT INTO aey_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ija je cagu madigina. Ija uqa ene hina amenna qee ehudi ahufig ija ja eu gahidudu li cal migen. ");
INSERT INTO aey_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ege qee daleoummi ege wele ono numeb ceseli hu lecis doum,” don. ");
INSERT INTO aey_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Odocob Jekob maaden, “Age eu odi odoqaganfi cois eu odi odoiga. Age hatu inadec ceteteh caunca leih cedimeig agena bekna tacadeiga. Age na gilic moolca dedeman me bahicca cenal cinigwe eundec pistasio almon aigca cedadeiga. Age ceteteh i age eundec nagnag cedadimeig dana eu loo utuqagannu hewi nueiga. ");
INSERT INTO aey_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Odocob age meen qaig onodec hewadi ceselein euha cedeiga. Odimeig eu tatac meen qaig haun eu uqana ameg eu casacnadec eu cinigwe eu odi ha cedeiga. Age meen qaig casacnadec bek cona tahein eu haun ceseli adoqagan. Eu cahuldu taheinfa. ");
INSERT INTO aey_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Walinigaha ehudi beleiga. Odimeig qilaca caji ceseli dana euca beleiga. ");
INSERT INTO aey_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Anut Gagadic Bahic uqa dana eu odudocob uqa agenu waug me nijeceb age amegna tawecebil uqa waliniga euca Benjaminca besali adigia. Qa ijana doc odi ijana mel culdifig cois ija culdigen,” aden. ");
INSERT INTO aey_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Eunu uqa melahul age dana ben eu loo utuqagannu ceteteh euca meen qaig hewi ceselein euca haun hewi nuecnu cedein euca cedadimeig age Benjamin ehudecebil cajimeig Isip ono noin. Odimeig age Josef amegna tawein. ");
INSERT INTO aey_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Saen Josef uqa Benjamin ageca fimei uqa uqana sab cofdoc dana eu madon, “Dana i age ijana jona cedi hewi nuuga. Odimeg dool oso qocom cal meceb jecnu saciadoga. Dana i age qila cahineg age ija gami sab jeqan,” don. ");
INSERT INTO aey_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Odocob sab cofdoc dana eu Josef madon eu odi odon. Uqa Josef waliagul ehadimei Josefna jona ehadi nuen. ");
INSERT INTO aey_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Saen Josef waliagul age dana eu Josefna jona ehadi nunuen age ben cucuiein. Age odi cisdoin, “Saen ege ene hahawan nom euna age egena meen qaig silwana badom eu ege cunug egena bek cona tacigein. Uqa qaignu je euna um qigimeig egena cesel cedimeig ege cahacgi hewigimeig gihacdoc jona tacigimeig cabi gagadic iguqagan. Eunu ege ene ehigia ahona,” ein. ");
INSERT INTO aey_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Eunu age Josefna sab cofdoc dana euca limeig jo cebecna madoin, ");
INSERT INTO aey_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“O dana ben, saen ege hahawan ene sab fajecnu nom eu ");
INSERT INTO aey_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ceseli bebeloqon witic meceb us nijecnu jaen mudom eu ege abesabes egena bek co cufalimeb ege cunug egena qaig cunug bibilen fom. Eunu ege qila haun hewi ceseloqa. ");
INSERT INTO aey_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ege qaig leihha sab fajecnu hewi noqa. Osoqa uqa egena qaig haun ceseli egena beknana tacigen eu qee doqona,” doin. ");
INSERT INTO aey_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Odocob uqa maaden, “Cain cisdowain. Eunu jeca qee. Cain cucuiowain. Agena Anut, age memegana Anut, uqa age qaig eu agena bekna taciadenfa. Ija agena meen qaig silwana mudec eu om,” aden. Odimei uqa Simion ageca ehudi ahu muden. ");
INSERT INTO aey_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Odocob sab cofdoc dana eu uqa Josef waliagul ehadi Josefna jona len. Odimei uqa jaimiga cusecnu wa adeceb agena cesel sabha aden. ");
INSERT INTO aey_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Aria waliagul age cahineg Josefca ono sab joqagan ec doin. Eunu age Josef ceteteh loo utuqagannu saciadoin. ");
INSERT INTO aey_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Odocob cahineg Josef uqa jona hocob age ceteteh loo utuqagannu ebenegana hewimeig jo hamol lein. Odimeig age uqa amegna gob cehi bilimeig jogoi nu maha cotadoin. ");
INSERT INTO aey_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Odocob uqa sisiladen, “Age me bileigafo? Age memeganu madein eu uqa me biliafo? Uqa cebac biliafo?” aden. ");
INSERT INTO aey_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Odocob age jejeg hewi madoin, “O ben, ege memige uqa me bilia. Uqa cebac bilia,” doin. Odocob age haun uqa amegna jogoein. ");
INSERT INTO aey_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Odocob uqa waliag gug Benjamin fifi maaden, “Age waliniga subig inu ija mateinfo?” aden. Odimei uqa Benjamin madon, “Anut hinanu waug me nijiale,” don. ");
INSERT INTO aey_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Odocob Josef uqa waliagnu waug qocob qajigiannu odon. Eunu uqa mahuc bahic cali len. Odimei uqa qajigiannu cudun walen. Odimei uqa uqana cuamu dunuh euna limei ono qajen. ");
INSERT INTO aey_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Eu hedocob uqa ola cusimei cali hon. Uqa cali humei haun qajecdainnu uqadodoc gagadic mimei uqana cabi dana maaden, “Sab qoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Odocob age casac Josefna sab qoin. Odimeig age Josef waliagul agena sab qoin. Odimeig age Isipdec dana ageca sab joqagannu bilein eu agena sab qoin. Qa Isip dana age Hibru dana gami sab gabandu joqagannu qee gale adel. Eunu abes bilein. ");
INSERT INTO aey_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Aria age Josef waliagul maadecebil age sab jecnu bilein eu i edi bilein. Waliaga matu uqa casac cali hon eu uqa aquni bilen. Odocob age toodocobtoodocob cali hoin eu odi bibilegin li subig cali honna cit qon. Age eu odi bilein eu fimeig age wawaga qee fogo dol. ");
INSERT INTO aey_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Saen cabi dana age sab Josefna sab jec cabalnadec siwiadecebil Benjamin uqa sab leih wooladec on. Uqa sab on eu dana ebum osahic jec ihocwe on. Eunu age cucuiecca qee Josef gami sab jejeig wain jejeig ein. ");
INSERT INTO aey_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Aria Josef uqa uqana jo cofdoc dana madon, “Dana i agena bekna sab tacecebil am beia. Age gahidoc ihoc eu odi taceiga. Odimeig age osahicosahic agena meen qaig eu bek cona taceiga. ");
INSERT INTO aey_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Odocob mel subig uqana bekna ijana gabin silwana mudec euca uqana meen qaig sab fajecnu euca bek cona tacitoiga,” don. Odocob dana eu Josef madon eu odi odon. ");
INSERT INTO aey_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Qasil cocojagen Josef uqa suladeceb age agena ceteteh ceselna meadimeig agena jicna cocobi belein. ");
INSERT INTO aey_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Odocob age taun ben culdi onoca qee nuec ninijen Josef uqa uqana jo cofdoc dana madon, “Hina cajimeg dana eu age jabadi tooadi nuuga. Gulucadimeig sisiladaga, ‘Age celnu kobol mena odadecemin me qeena wadacdoiga? ");
INSERT INTO aey_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Celnu age ijana benna gabin silwana mudec heje oiga? Gabin i ijana ben uqa euna gab jenanu. Odi ha uqa gabin ina doi menanu. Eu kobol me qee bahic odoiga,’ adaga,” don. ");
INSERT INTO aey_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Odocob uqa jabadi tooadi nuimei gulucadi je eu odi maaden. ");
INSERT INTO aey_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Odocob age jejeg hewi madoin, “Egena ben, uqa je eu odi celnu madena? Ege dana ititom. Eu odocnu ihoc qee. ");
INSERT INTO aey_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Faga, meen qaig egena bek cona bilen eu ege Kenan mahanadec ceseli ahu hom. Ege silwafo golfo egena benna jonadec adi heje ocnu? ");
INSERT INTO aey_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ceteh eu ege oso heje ocobfi cois age dana eu qagadocobil cal migian. Odocob egeha cois gihacgoqagan,” doin. ");
INSERT INTO aey_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Eunu uqa maaden, “Je age madeiga eu odi himec ija odigen. Qa gabin eu in oso uqana bekna gulucdufig dana eu gihacdocnu mudigen. Odocob age cunug age dewenegana jeca qee,” aden. ");
INSERT INTO aey_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Odocob age mahucmahuc agena bek cesel gogodomoganadec cacu ti mahana mimeig bek co huleladein. ");
INSERT INTO aey_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Odocob uqa agena bekna cijawec sanan men. Uqa matuna bekna cijawec sanan mimei waliaga subigna bekna cit qon. Uqa cijawimei gabin eu Benjaminna bekna gulucdon. ");
INSERT INTO aey_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Odocob waliagul dumanaga culeceb age agena lotoc bahalaadein. Odimeig agena ud haun cedi cesel gogodomogana mimeig ceseli taun benna belein. ");
INSERT INTO aey_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Saen Juda uqa waliagul gami Josefna jona hoin eu uqa ono bibilen age hoin. Age uqa amegna calimeig age mahucwe bahic mahana gob cehi bilimeig ubocuboc nijein. ");
INSERT INTO aey_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Odocob Josef maaden, “Age cel kobol oditeiga? Dana ija edec ija doi mecnu ihoc ec qee doginafo?” aden. ");
INSERT INTO aey_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Eunu Juda uqa jejeg hewi madon, “Ijana ben, eeta higen? Ege cel je madecnu? Cahuldoc eu ege qee odolom. Eu adi ihachecnu? Anut uqa egena cahuldoc camasac meia. Qila hina ege gihacdocna migegan. Dana gabin uqana bekna gulucdoiga euca egeca osoben gihacdocna migegan,” don. ");
INSERT INTO aey_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Qa Josef uqa maaden, “Ija eu odi odocwe qee qa ijana gabin cel dana uqana bekna gulucdoiga eu himec uqa gihacdoc jona mudigen. Odocob age cunug cois wawaga malolca age memegaca ceseli beloqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Odocob Juda uqa Josef cemenug timei madon, “O ijana ben, hina Feroca ale ihocihoc. Ijanu cain gemain beiaun qa ija culitecem je oso mahiga. ");
INSERT INTO aey_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ijana ben, weleca hina ege sisilgem, ‘Age memegacafo? Age waliniga osocafo?’ gem. ");
INSERT INTO aey_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Odocob ege jejein hewi mahom, ‘Ege memigeca, uqa toia. Odocob ege walinige subigca uqa ege memige toia bibilen anige basiton. Subig eu uqa waliag wele cal men. Eunu uqa anag mel osahic, uqa jaih cuhanuc. Ege memige uqa uqanu cal mena,’ hom. ");
INSERT INTO aey_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Odocob hina magem, ‘Ehudi necebil ija amigul figen,’ gem. ");
INSERT INTO aey_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Odocob ege mahom, ‘Mel eu uqa memeg culdecwe qee. Uqa culdecebfi uqa memeg cal migian,’ hom. ");
INSERT INTO aey_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Qa hina magem, ‘Age waliniga subig eu uqaca qee nifeig age ija amina haun qee howain,’ gem. ");
INSERT INTO aey_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Eunu, ijana ben, ege ceseli belimeb ege memige hinana je i madom. ");
INSERT INTO aey_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Odocob ege memige uqa magen, ‘Ceseli belimeig sab leih haun fajeiga,’ gen. ");
INSERT INTO aey_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Qa ege madom, ‘Ege nocwe qee. Ege walinige subig uqacafi nocnu. Ege walinige subig uqaca qee nufeb ege dana eu amegna haun qee loqaun,’ dom. ");
INSERT INTO aey_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Odocob ege memige uqa magen, ‘Ija aideni, Resel, uqa melamiel lecis basaliten age dogina. ");
INSERT INTO aey_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Odocob oso uqa ija culitimei nuen. Odocob ija madem, ‘Mele bahic, uqa tuqi calcaldoiga,’ em. Euqa ija haun qee felem. ");
INSERT INTO aey_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Odocob age iha ija cemeninadec cocobil cal mec uqaca hocobfi age ija oditecebil wawi me qee mecca helna nugen,’ uqa odi magen. ");
INSERT INTO aey_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Eunu, ijana ben, ege haun ceseli belocomun ege memige uqa walinige subig eu qee fifei uqa cal migian. Uqana cebac bilec eu melah subig euna bilina. Eunu ege memige uqa odidocomun waug me qee mecca helna nugian. ");
INSERT INTO aey_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Odenqa ija je wele cagu ijana mei madom. Ija odi madom, ‘Melem subig eu qee ceseli ehudi ahocominfi ja eu ija dewenina bibileb li cal mec gadacna caligen,’ dom. ");
INSERT INTO aey_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Aria, ijana ben, eunu ija hinana gihacdoc jona bibilemin mel subig eu culdecem waliagul gami ceseli beleiga. ");
INSERT INTO aey_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mel eu ijaca qee belocomunfi ija meica adi ceseli nuigen? Ija eu odi odifig ija mei uqana waug me qee mec eu adi figen?” don. ");
INSERT INTO aey_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Odocob Josef qajecnu amulig bi cit qon. Odocob uqa dana amagana gagadic mecwe qeenu uqa qagai maaden, “Dana cunug age ija aminadec cali li beleiga,” aden. Eunu dana cunug age calecebil Josef uqa waliagulca himec bilimeig uqa ija age waliniga ec qasali maaden. ");
INSERT INTO aey_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Odocob Josef uqa co suli umei geh bahic qaqajen Isip dana onodec calein eu age dah mudein. Odocob Fero uqaca uqana talca ageha Josef qajeianu je eu doin. ");
INSERT INTO aey_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Aria Josef uqa waliagul maaden, “Ija Josef. Ija mei uqa cebac biliafo?” aden. Qa age filiciteeig culunuga cacu teceb jeca qee qeleli tawein. ");
INSERT INTO aey_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Odocob uqa maaden, “Ija cemeni hoiga,” aden. Age eu odi odocobil uqa maaden, “Ija age waliniga Josef age Isip dana ebenegana idadoin. ");
INSERT INTO aey_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Qa age qila eu odi odoinnu cain jaen aqeiaun. Age dana enedecca idadteinnu cain cisdowain. Anut uqa ene sulten. Anut uqa age qee hoc ninijen dana qee cal mowainnu ija aquniadi sulten. ");
INSERT INTO aey_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Cahel eu maha ina cabi gel lecis docna himec ninijen hoia. Odocob cabi gel ebum osahic eu qee hedoc nijia. Saen euna sab cehecnuca ocnuca qee nijiaun. ");
INSERT INTO aey_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Qa Anut ageca agena sihulca qee cal mowainnuca cal mecnadec cahahaadigiannuca uqa ija aquniadi sulten. ");
INSERT INTO aey_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Eunu age ene ija qee sultelein qa Anut uqa ija ene sulten. Uqa ija Ferona cisdoc dana miten. Ferona dana cunug ija cofadigina. Isip hatu cunug ija ilo biligina. ");
INSERT INTO aey_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Eunu mahuc bahic ija meica ceseli timeig madoiga, ‘Hina melem, Josef, edi madeia, ‘Anut uqa ija Isip hatu cunugnu ilo miten. Mahuc ijaca hoga. Cain daleagaun. ");
INSERT INTO aey_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Hina Gosen mahana bilegan. Euqa hina ija cemeni bilegan. Hinaca hinana mel simca hina asinelca age cunug Gosen mahana biluqagan. Agena sipsip amca meme amca bulmakau amca ceteteh cunug hinana euca age ono biluqagan. ");
INSERT INTO aey_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Age ono bilecebilfi ija cesuladigen. Cahel saen cabi gel ebum osahic eu hugian. Gad gad hinaca hinana talca age sawen bilimeig cal mowain,’ Josef eu odi madeia,’ doiga. ");
INSERT INTO aey_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Feiga, agegul amagana mecitegina. Odocob ija wali Benjaminha uqagul amegna mecitina. Ija Josef, ija himec je maadigina. ");
INSERT INTO aey_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ija ene Isip hatuna dana ben, ijanica biliga eunu madoiga. Ceteh cunug ene wele feiga eunu ha madoiga. Odocob age mahucwe ija mei ene ehudi ahoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Odocob uqa eben qelalimei waliag Benjamin colowandumei qajen. Odocob Benjamin uqaha Josef cogadudu bili qajen. ");
INSERT INTO aey_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Odocob uqa waliagul cunug cotaadimei agenu qajen. Eu cunug hedocob uqa waliagul age uqaca je madein. ");
INSERT INTO aey_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Aria Fero uqa Josef waliagul uqaca hoiga ec don saen euna uqaca uqana dana iloiloca age wawaga ceelen. ");
INSERT INTO aey_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Odocob Fero uqa Josef madon, “Hina waliniel edi maadaga, ‘Agena cesel cunug jajadumeig ceseli Kenan mahana beleiga. ");
INSERT INTO aey_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Odimeig age memegaca agena talca cedadimeig ehadi ijaca ahoiga. Odocobil ija Isip hatuna maha me bahic oso, maha cunug wooladec, oso adigen. Odocob age sab me bahic hatu eunadec joqagan,’ adaga. ");
INSERT INTO aey_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Je ha maadaga, ‘Karis leih ene Isipdec cedimeig nui ono age aidagailca agena mel simca tacadi ahoiga. Age memegaha ehudi ahoiga. ");
INSERT INTO aey_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Agena ceteteh culecnu cain cisdowain. Isip hatunadec ceteh cauncaca eu adigen,’ eu odi maadaga,” don. ");
INSERT INTO aey_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Odocob Jekob melahul age Fero maaden eu odi odoin. Josef uqa Ferona je toodumei waliagul karis leih aden. Odimei sab jicna joqagannu ha aden. ");
INSERT INTO aey_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Uqa waliagwaliag cunug lotoc haunhaun aden. Qa Benjaminnu eu uqa lotoc haunhaun ebum osahic utaden. Odimei uqa meen qaig silwana mudec eu 300 eu odi uten. ");
INSERT INTO aey_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Odocob uqa memegna ceteteh Isip hatunadec ceteteh cauncaun eu cesel 10 age gahidoin euca sab uqa memeg saen uqa jicna cocobi bilei jigiannuca eu cesel 10 age gahidoin euca suldon. ");
INSERT INTO aey_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Odimei uqa waliagul suladeceb belein. Age bebelegin uqa maaden, “Age jicna cain fee dadanowain,” aden. ");
INSERT INTO aey_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Odocob age Isipdec Kenan hatuna memega Jekobca bein. ");
INSERT INTO aey_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Odocob age Kenan bimeig memega edi madoin, “Josef qee cal mel. Uqa cebac bilia. Mele bahic uqa Isip hatu cunug eu cofdocnu uqa ilo bilia,” doin. Odocob Jekob uqa filiciten qa uqa je eunu waug qee meleel. ");
INSERT INTO aey_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Odonqa saen age Josefna je eu sadodoig karis uqa tacudi ehudi nocnu Josef suldon eu fimei uqa waug togdon. ");
INSERT INTO aey_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Odocob Jekob uqa maden, “Eu mele bahic! Ija melami Josef uqa gaid cebac bilia. Ija nui fimig cal migen,” en. ");
INSERT INTO aey_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Eunu Jekob uqa uqana cetetehca Isip nuen. Uqa Biasiba ono calimei uqa memeg Aisakna Anut eu ihandon. ");
INSERT INTO aey_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Odocob witicna Anut uqa Jekob ola codocna edi madon, “Jekob, Jekob,” don. Odocob uqa jejeg hewi madon, “Ija i hen,” don. ");
INSERT INTO aey_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Odocob Anut uqa madon, “Ija Anut, ija memenna Anut. Hina Isip nocnu cain cucuiagaun. Ija odocna ono hinana sihul eu mati bahic fulusdoqagan. ");
INSERT INTO aey_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ija hinaca Isip nowan. Odocob mele bahic ija hina haun ceseli ehihi bigen. Odocob hina Josef ebenna cal megan,” don. ");
INSERT INTO aey_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Odocob Jekob uqa Biasiba culdimei nuen. Odocob Jekob melahul age memegaca aidagailca agena mel simca karis Fero memega tacuduqagannu aden euna tacadimeig ehadi belein. ");
INSERT INTO aey_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Odocob Jekob uqa uqana sihul cunugca gami noin. Uqana dool mananca ceteteh cunug Kenan mahana ono bibili bilei cedaden eu cunug cedadeceb Isip ono belein. ");
INSERT INTO aey_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Uqa melahulca uqa asagul danaca uqa ategulca uqa asagul cajaca uqana sihul cunugca odi cedadimei ehadi uqaca Isip noin. ");
INSERT INTO aey_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Aria i eu Jekob uqa melahul ijanaga, euqa Jekob uqa gami Isip ono noin. Ruben uqa Jekob melah matu. ");
INSERT INTO aey_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben melahul eu ijanaga Hanok, Palu, Hesron, Kameca. ");
INSERT INTO aey_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simion uqa melahulca eu ijanaga Jemuel, Jamin, Ohad, Jakin, Soha, Saolca. Saol uqa Kenan cajanadec calen. ");
INSERT INTO aey_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Liwai uqa melahulca eu ijanaga Geson, Kohaf, Merarica. ");
INSERT INTO aey_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Juda uqa melahulca eu ijanaga Er, Onan, Sela, Peres, Sinaca. Aria Er Onanca ale Kenan mahana cal mesin. Odocob Peres uqa melahul eu ijanala Hesron Hamulca. ");
INSERT INTO aey_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka uqa melahulca eu ijanaga Tola, Pua, Jasub, Simronca. ");
INSERT INTO aey_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebjulan uqa melahulca eu ijanaga Seret, Elon, Jalelca. ");
INSERT INTO aey_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Lia uqa melahul i age Jekob Mesopotemia ono basaditon. Uqaha ateg oso, Daina, ono basiton. Jekobna mel mel aidca age Lia uqa anaga bilen cunug gabandoc eu 33. ");
INSERT INTO aey_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Aria Gad uqa melahulca eu ijanaga Sifion, Hagi, Suni, Esbon, Eri, Arodi, Arelica. ");
INSERT INTO aey_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ase uqa melahulca eu ijanaga Imna, Iswa, Iswi, Beria, age cebinamaga Seraca. Odocob Beria melahul lecis eu ijanala Hiba Malkielca. ");
INSERT INTO aey_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Dana i age eu Silpa melahul. Silpa uqa Liana cabi caja Leban uqa uten. Uqa melahul i age Jekob basaditon eu cunug gabandoc eu 16. ");
INSERT INTO aey_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Aria Jekob aideg Resel uqa mel lecis basaliton. Eu ijanala Josef Benjaminca. ");
INSERT INTO aey_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Odocob saen Josef uqa Isip ono bibilen aideg, Asenat, uqa mel lecis Josef basaliton. Eu ijanala Manasa Ifremca. Asenat uqa Potifera ateg. Eu Heliopolis ihanec dana. ");
INSERT INTO aey_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Aria Benjamin uqa melahulca eu ijanaga Bela, Beke, Asbel, Gera, Naman, Ehi, Ros, Mupim, Hupim, Adca. ");
INSERT INTO aey_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Eunu Jekobna mel age Resel uqa anaga bilen eu cunug gabandoc eu 14. ");
INSERT INTO aey_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Aria Dan melah eu Husim. ");
INSERT INTO aey_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali uqa melahulca eu ijanaga Jasel, Guni, Jese, Silemca. ");
INSERT INTO aey_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dana i age eu Bilha melahul. Bilha uqa Reselna cabi caja Leban uqa uten. Uqa melahul i age Jekob basaditon. Eu cunug gabandoc eu eben naha gic lecisca. ");
INSERT INTO aey_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Dana cunug Jekob uqana sihul bahic uqa gami Isip belein eu gabandoc 66. Euqa Jekob melahul aidagailca qee gabandu sicanadec. ");
INSERT INTO aey_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Josef aideg mel manahal lecis Isip ono basalen. Eunu Jekobna tal cunug gabandoc Isip noin eu 70. ");
INSERT INTO aey_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Aria Jekob uqa Juda aquni Josefca suldon. Uqa Josef madocob Gosen maha eu ana nijia eu dado mudigiannu suldon. ");
INSERT INTO aey_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Odocob age Gosen cacalegin Josef uqa uqana karis saciadumei memeg Jekob gulucdugiannu nuen. Saen Josef uqa memeg gulucdumei uqa eben limei memeg colowandudu saen cecelacca uqanu qajen. ");
INSERT INTO aey_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Odocob Jekob uqa Josef madon, “Qila ija cal mecnu ihoc. Ija ijadodoc hina cebac gaid biliga eu mecihiga,” don. ");
INSERT INTO aey_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Odocob Josef uqa waliagulca memeg uqana talca maaden, “Ija Feroca timig ija walielca ija mei uqana tal eu Kenan mahana bilegina age ijaca hoiga ec madugen. ");
INSERT INTO aey_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Age sipsip cofadec dana. Age dool cofadeginanu. Eunu age agena dool am cunugca agena ceteteh cunugca cedimeig hoiga ec madugen. ");
INSERT INTO aey_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Saen Fero uqa utaadeceb uqaca lecebil edi sisiladecebfi, ‘Age cel cabi oginanu?’ adecebfi ");
INSERT INTO aey_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","age odi jejeg hewi madoqagan, ‘Egena ben, ege dool simnadec cofaadi ben mom. Ege memigeil odoloig eu odi dih odoqona,’ doqagan. Age eu odi madocobilfi uqa age Gosen mahana biluqagan eunu cois adigian,” aden. Aria Isip dana age dool cofadec dananu qee gale adena. Eunu Josef eu odi maaden. ");
INSERT INTO aey_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Odocob Josef uqa waliagul ebum oso ehadi li Feroca calimei madon, “Ija meica ija walielca agena dool amca agena ceteh cunug euca Kenan mahanadec hoiga. Age qila Gosen bileiga,” don. ");
INSERT INTO aey_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Odocob Josef uqa waliagul ebum osahic eu nesili cedadimei Fero amegna ehadi len. ");
INSERT INTO aey_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Odocob Fero uqa Josef waliagul sisiladen, “Age cel cabi oginanu?” aden. Odocob age jejeg hewi madoin, “Egena ben, ege sipsip cofadec dana. Euqa ege memigeil odoloigwe odoqona. ");
INSERT INTO aey_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Cahel saen Kenan mahana eu me qee bahic nijia. Odocob egena dool amnu eu sabca qee. Eunu ege qila Gosen ono culigecem bileqannu sisilhoqona,” doin. ");
INSERT INTO aey_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Odocob Fero uqa Josef madon, “Hina memenca hina walinelca age hinaca hoiga. ");
INSERT INTO aey_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Eunu Isip maha eu hina ebenna bilia. Cel maha me bahic oso fimeig memen walinelca euna madaga. Gosen ono madecem biluqagan eu cois. Odocob hina walinel eundec oso uqa dool cofadecnu doc qataneccafi uqa ijana dool cofadigiannu ilo muduga,” don. ");
INSERT INTO aey_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Odocob Josef uqa memeg Jekob Fero amegna ehudi len. Odocob Jekob uqa Fero eeldoc je madon. ");
INSERT INTO aey_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Odocob Fero uqa Jekob sisildon, “Hinana cabi gel ganic?” don. ");
INSERT INTO aey_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Odocob uqa jejeg hewi madon, “Ijana cabi gel eu 130. Odocob ija maha filfilna geh bahic loldudu cobem. Qa cabi gel eu cecelac qee, eu gohic. Ijana loldudu coboc eu culumen mati bahicca. Ija memiel loldudu coboin eu cabi gel mati bahic. Eu wooldoc ijana cabi gel,” don. ");
INSERT INTO aey_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Odocob Jekob uqa Fero eeldoc je haun madon. Odimei uqa Fero amegnadec cali li nuen. ");
INSERT INTO aey_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Eunu Josef uqa memegca uqa waliagulca Isip ono madeceb bilein. Odimei uqa maha eunadec ceteteh cauncaca eu aden. Maha Fero ihacaden eu ijan Rameses. ");
INSERT INTO aey_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Odocob Josef uqa memegnuca waliagulnuca memegna talnuca mel simnuca sab ihoc siwiaden. ");
INSERT INTO aey_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Odocob cahel eu me qee bahic nijen. Eunu maha cunug sabca qee men. Odocob Isip Kenanca dana age wennu gagadicca qee mein. ");
INSERT INTO aey_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Odocob Josef uqa meen qaig sab fajecnu gulucdu haudumei Ferona jona ehi len. ");
INSERT INTO aey_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Aria dana cajaca Isipdec Kenandecca agena meen qaig qee meceb Isip dana age humeig Josef madoin, “Sab igiga. Qee igecemfi ege cal meqan. Cesulgaga. Egena meen qaig ji hedoqa,” doin. ");
INSERT INTO aey_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Odocob Josef uqa maaden, “Agena dool manan ahoiga. Agena meen qaig eu qee mecebfi ija eu wadacdocnu sab adigen,” aden. ");
INSERT INTO aey_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Eunu age agena hosca sipsipca memeca bulmakauca ceselca Josefca ahocobil uqa eu wadacdocnu sab aden. Odocob Josef uqa cabi gel euna eu odi odon. Agena dool manan cunug ahocobil uqa eu wadacdocnu sab aden. ");
INSERT INTO aey_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Odocob cabi gel eu hedocob eu cabi gel haunna uqaca hoin. Odimeig madoin, “Egena ben, ege hina amenna je mele eu jahunecwe qee. Egena qaig eu qee men. Euqa egena dool manan hina wele ihom. Ege ceteh oso hina ihecnu qee bilel. Qa ege dewenigeca egena mahaca himec bilia. ");
INSERT INTO aey_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Cain culigecem cal moqaun. Cain culecem egena maha me qee meiaun. Egeca egena mahaca fajigi oigiga. Odocob egeca egena mahaca eu Ferona bilecnu. Sab aig igecem ege eu cehimeb jiji cebac bilecnu eu odifi ege qee cal moqaun,” doin. ");
INSERT INTO aey_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Eunu Josef uqa Isip maha cunug eu Ferona fajiton. Cahel saen eu ageca me qee bahic nijen. Eunu Isipdec dana cunug age agena maha idadecnu suldoin. Eunu maha cunug eu Fero faji on. Odocob uqa muguh bilen. ");
INSERT INTO aey_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Odocob Josef uqa dana cajaca Isip maha gadac osonadec nueceb osona gadac eu age cunug fajadi on. ");
INSERT INTO aey_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Odonqa Josef uqa ihanec dana agena maha qee faji ol. Fero uqa meen qaig agenu ihoc bilecnu aden. Eunu ihanec dana age agena maha idadecnu qee suldoloin. ");
INSERT INTO aey_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Odocob Josef uqa dana cajaca maaden, “Aria feiga, qila ija ageca agena mahaca Ferona fajaditom. Eunu agena sab aig i hen. Cedimeig mahana ceheiga. ");
INSERT INTO aey_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Odocob sab wal mec saenna age sab cedimeig am ebum osahicna ila mimeig age am eundec oso Fero utuqagan. Odimeig am wal oso eu agena. Euqa agena eu aig cehecnuca sab jecnuca biligian. Aig leih cabina cehoqagan. Leih ageca agena talca joqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Odocob age madoin, “Hina cebac bileqannu cesulgagana. Hina me bahic eelgagana. Eunu ege egena ben Ferona bileqan,” doin. ");
INSERT INTO aey_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Eunu Josef uqa je sab cedimeig am ebum osahicna ila mimeig age am eundec oso age Fero utuqagannu maaden eu gagadic mudeceb loo oso Isipna calen. Loo eu qilaha gaid nijia. Euqa odi sab am eundec oso Fero uteginanu. Ihanec dana agena maha himec eu Ferona qee nijel. ");
INSERT INTO aey_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Aria Isrel dana caja age Isip ono Gosen mahana bilein. Odimeig age cehewanagaca mein. Odocob age fulusdumeig mati bahic calein. ");
INSERT INTO aey_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Odocob Jekob uqa Isip ono cabi gel 17 bilen. Odocob uqana cabi gel cunug gabandoc eu 147. ");
INSERT INTO aey_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Aria Jekob uqa cal migia bili uqana saen dodoldodon uqa melah Josef utadocob hocob madon, “Hina eben tucumi gemo mimeg je madegan eu cagu madaga, ‘Ija Isip ene cain hel cisihigaun,’ aga. ");
INSERT INTO aey_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ija cal mec saenna hina ehiti nui ija asiel nijeigana ono hel cisitiga,” don. Odocob Josef uqa jejeg hewi madon, “Hina madaga eu odi odigen,” don. ");
INSERT INTO aey_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Odocob Jekob madon, “Cois je cagu madaga,” don. Odocob Josef uqa odi odigiannu je cagu madon. Odocob Jekob uqa uqana cabalna bilimei inondocna Anut hetaga don. ");
INSERT INTO aey_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Aria ceteh i hedocob saen leih leceb age Josef madoin, “Hina memen uqa hag nijia,” doin. Eunu uqa melahul lecis Manasa Ifremca ehaleceb lein. ");
INSERT INTO aey_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Saen Jekob uqa edi madocobil, “Hina melem Josef uqa hinaca hoia,” docobil uqa gagadic mimei caji cabalna bilen. ");
INSERT INTO aey_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Odocob uqa Josef madon, “Anut Gagadic Odocca uqa Kenan mahana Lus ono ijaca calimei ono uqa eeltiti ");
INSERT INTO aey_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","je edi maten, ‘Ija odocna hina fulusdumeg mati bahic calegan. Hina sihul mati calegan. Odocob ija maha i hinana sihul hina toohi cali hoqagan eu adigen. Maha i agena gaid bileceb catanigian,’ ten. ");
INSERT INTO aey_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Aria hina melem lecis ija Isip ene hinaca qee hoc ninijen cali hosin eu ale ijana mel bilesia. Ifrem Manasaca ale ijana mel Ruben Simionca cinigwe calowasan. ");
INSERT INTO aey_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Hina melemenel haun melem lecis i ale tooali cali hocobilfi eu age ijana mel qee calowain. Hina melemenel eu age ceteteh age mugumuga mec eu Ifrem Manasacanadec cedoqagan. ");
INSERT INTO aey_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ija Reselnu odi odigina. Ija Mesopotemiadec ceceseligin Resel uqa Efrat cemenug Kenan mahana cal men. Odocob ija uqanu wawi ben me qee men. Eunu ija Efrat ono jic gesacna hel cisem,” don. Qila Efrat eu Betlehem. ");
INSERT INTO aey_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Odocob Jekob uqa Josef melahul lecis eu mecialimei uqa sisildon, “Mel i ale indec?” don. ");
INSERT INTO aey_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Odocob Josef uqa memeg jejeg hewi madon, “Eu ija melamiel lecis Anut uqa Isip ene iten,” don. Odocob Jekob uqa madon, “Ehali ijaca hocom eelaligen,” don. ");
INSERT INTO aey_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Aria Jekob uqa toia mennu ameg eu me bahic qee. Uqa mecii cuhadocwe qee. Eunu Josef uqa melahul eu memeg cemenug ehali leceb uqa cotaali cogaalen. ");
INSERT INTO aey_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Odocob Jekob uqa Josef madon, “Ija hina olain haun qee figaun em qa qila Anut odocna ija hina melemenelha meciadigina,” don. ");
INSERT INTO aey_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Odocob Josef uqa melahul eu ale uqa memegna gobnadec cedalen. Odimei uqa du qahi mahana non. ");
INSERT INTO aey_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Odocob Josef uqa melahul lecis eu cedalen. Odimei Ifrem Jekob eben ansena isec muden. Odocob Manasa Jekob eben meulana isec muden. Odimei ehali memegca cemenug len. ");
INSERT INTO aey_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Odonqa Jekob uqa eben wadacalimei eben meula eu Ifrem ilona men qa Ifrem uqa milum. Odimei uqa eben anse eu Manasa ilona men qa Manasa uqa matu. ");
INSERT INTO aey_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Odocob uqa Josef eeldudu je edi maden, “Anut ija memiel Ebraham Aisakca ale uqa amegna cobosin uqa mel i ale eelaleiale. Anut ija cofteten cocobi hu qila saen ina gadac uqa eelaleiale. ");
INSERT INTO aey_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ensel ija aisais me qeenadec besiti oiten eu uqa mel i ale eelaleiale. Odocob ija ijanica ija memiel ijanagaca eu aleca bileiale. Odocob alena sihul mati bahic fulusdosiale,” en. ");
INSERT INTO aey_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Aria Josef uqa memeg eben meula eu Ifrem ilona memen fimei uqa eu odinu waug qee nijel. Eunu uqa memeg eben eu umei waldu ehi li Manasa ilona mecnu odon. ");
INSERT INTO aey_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Odimei Josef uqa madon, “O mei eu odi qee. I eu uqa matu hina eben meula eu i ilona maga,” don. ");
INSERT INTO aey_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Qa uqa memeg cuculi bili madon, “O melami, ija dugina, ija dugina. Uqaha uqana sihul hibna sihul ben oso caloqagan. Qa uqa waliag milum eu uqana sihul age benben caloqagan. Euqa uqa matuna sihul wooldoc caloqagan,” don. ");
INSERT INTO aey_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Eunu uqa deel euna eelali maden, “Isrel age ale ijanalana eel docobdocob oqagan. Age madoqagan, ‘Anut odocna age Ifrem Manasaca cinigwe caleigale,’ oqagan,” en. Eunu Jekob uqa eeldoc je euna Ifrem Manasa aqunitu men. ");
INSERT INTO aey_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Odocob Jekob uqa Josef madon, “Ija cal mige dodoldudugin hina fecitem. Qa Anut uqa hinaca biligian. Odimei ehihi nui hina asinel agena mahana mihigian. ");
INSERT INTO aey_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sekem, maha laloca, ija Amo dana ebeneganadec, sigin qalicana cacadi cawaladem, maha eu hina walinel qee adigaun qa hina ihigina,” don. ");
INSERT INTO aey_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Odocob Jekob melahul cunug utaadeceb hocobil maaden, “Alilti tawecebil ceteh oso hibna caligian eunu maadigen. ");
INSERT INTO aey_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Jekob melahul age, cegulimeig dah meiga. Age memega Isrel dah mudeiga. ");
INSERT INTO aey_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, hina melami matu, hina ijana gagadic odoc. Saen ija dana ibuldom eu hina ijana mel matu calem. Hina ijain eu ben bahic, hina uwein eu gagadic odocca. ");
INSERT INTO aey_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Hina wa sil quhulina cinigwe. Qa hina ijana cabi caja, ija aideni cinigwe, euca nijesin. Odocob hina ija majani hewitem. Eunu hina matu cudun qee ogaun. ");
INSERT INTO aey_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simion Liwaica ale waliagwaliag. Alena han sigin eu hannu gelehinca. ");
INSERT INTO aey_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ale gemanala beceb dana leih aqecebil cal mein. Odimesi ale udocnu bulmakau jaimiga qahiqahi belesin. Eunu ija alena je jahuni madecna qee gabanaligaun. Odocob ija alena cegulecna qee biligaun. ");
INSERT INTO aey_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Alena gemanala eu gagadic bahic eunu ija geldugina. Ale olohonola eu me qee bahic eunu ija geldugina. Ija odocomin age Isrel mahana qatani bilisadoqagan. Ija odocomin age filigandumeig Isrel dana gami gabandoqagan. ");
INSERT INTO aey_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, hina walinel age hina binain suluqagan. Hinana cad benega hewegan. Hina walinel age hina amenna dunuga qahoqagan. ");
INSERT INTO aey_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","O Juda, hina laion haun cinigwe. Uqa dool qumei uqana cudunna ceselena. Uqa titiqimei nijina. Oso uqa seelecnu qee tulidona. ");
INSERT INTO aey_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Juda uqa ilo uqana gom hewigian. Odocob uqana sihul age himec gaidgaid maha ilo biluqagan. Uqa ilo bibileb dana mahamaha cunug agena bagol utecnu hoqagan. ");
INSERT INTO aey_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Uqana cesel wain gugna qagigian. Uqana cesel haun wain me bahic batacna qagigian. Uqa uqana lotoc ceteteh wain muhucna cusigian. ");
INSERT INTO aey_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Uqa ameg eu gagatucca wain muhuc cinigwe. Uqa aig eu senenec su cinigwe. ");
INSERT INTO aey_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebjulan uqa macas gesacna biligian. Uqana lanna eu macas tiliec nijigian eu wag benbennu me bahic. Uqana maha gadac eu nui Saidon gadac. ");
INSERT INTO aey_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaka uqa cesel gagadicca cinigwe. Uqa ud lecis gemo nijina. ");
INSERT INTO aey_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Qa uqa jaen mudec cudun me bahic fena. Odocob maha eu fecnu galeca fena. Eunu uqa ud gahidocnu gob qahi biligian. Age madocobil uqa cabi dana meceb cabi gagadic utuqagan. ");
INSERT INTO aey_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan uqa uqana dana cajaca gesiladigian. Euqa age Isrel jobon medeh leih cinigwe. ");
INSERT INTO aey_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan uqa man sononec jic gesacna cinigwe caligian. Euqa man sononec aqi jeceb cal meginanu. Uqa hos jaih bisoc qu jenanu. Odocob hos uqa dana qeludeceb ijag tagtag toninanu. ");
INSERT INTO aey_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Tibud, hina ija cahahategannu sumihigina. ");
INSERT INTO aey_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad uqa heje dana hejenu humeig uqaca han moqagan. Qa uqa waldumei jabadigian. ");
INSERT INTO aey_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ase uqana maha eu sab me bahic caligian. Uqa sab saciadugian eu kingna sab cinigwe. ");
INSERT INTO aey_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali uqa dia, uqana gawecna cobona, cinigwe. Uqa dia nag galecaca basadena cinigwe. ");
INSERT INTO aey_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josef uqa cesel cus cinigwe. Uqa hos cus aluh nagna tawena cinigwe. ");
INSERT INTO aey_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Uqana cad uqaca han mecnu gagadic hogina. Age olohonogana uqa qocnu qali gusegina. ");
INSERT INTO aey_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Qa Jekobna Anut Gagadic Odocca eu uqa gagadic odoc utina. Anut eu uqa Isrel agena cofadec, uqa Isrelna gagadic odoc. Eunu uqana qali eu iilalecca qee tawena. Odocob uqa uwen eu gagadicca. ");
INSERT INTO aey_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Hina memen uqana Anut eu cesulhena. Anut Gagadic Odocca uqa eelhena. Uqa edi eelhena. Wa ohisdec ihena. Wa tut maha dunuhdec ihena. Mel sim mati bahic ihena. ");
INSERT INTO aey_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Macin bobogca ihena. Aluh ihena. Aluhnadec ceteteh me bahic gaid bileceb catanigian eu ihena. Ceteteh i cunug Josef ilona biliale. Ceteteh i dana uqa waliagul qisacadi bilina eu uqa ilona biliale. ");
INSERT INTO aey_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin uqa qa cus hanca cinigwe. Qasil uqa uqana dool sabnu qon eu jena. Wesu uqa ceteteh hannadec cedena eu ila mena,” en. ");
INSERT INTO aey_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","I age eu Isrel agena jobon medeh 12. Odocob i eu eeldoc je age memega odi maaden. Uqa eeldoc je cunug agenu osahicosahic aden eu agenu ihoc filfil siwiaden. ");
INSERT INTO aey_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Odocob Jekob uqa melahul je gatiti edi maaden, “Ija asiel cal mein eu gami nuecnu saen eu dodoldona. Ija cal mecemin ija asiel gami meen hel Efron Hitdec uqana cabina nijina ono hel cisiteiga. ");
INSERT INTO aey_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Meen hel eu Makpela cabina euqa Mamri cemenug Kenan mahana nijia. Meen hel eu Ebraham uqa qalqalnu Efron Hitdec dana ebennadec cabi euca faji on. ");
INSERT INTO aey_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ono Ebraham uqa aideg Saraca hel cisalein. Ono Aisak uqa aideg Rebekaca ale hel cisalein. Ono ija Lia hel cisem. ");
INSERT INTO aey_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Cabi meen hel euca Ebraham uqa Hit dana ebeneganadec faji on. Ono ija hel cisiteiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Aria Jekob uqa je gatiti melahul maadimei uqa jaih mahanadec suli u cabalna men. Odimei uqa siw ehi bi helimei kis on. ");
INSERT INTO aey_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Odocob Josef uqa memeg tatacan tonimei qaqaji bili memeg cotadon. ");
INSERT INTO aey_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Odocob Josef uqa uqana cabi dana maadeceb age memeg deweg saen cecelac nijigiannu mool joudein. ");
INSERT INTO aey_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Odocob dana eu age Josef memeg deweg hel cisecnu saciadodogin deel 40 ihoc len. Deel 40 eu cal mecebil hel cisadecnu dewenega ganac saciadogina uqana gadac bahic. Odocob Isipdec dana age Jekobnu deel 70 qadaca bilein. ");
INSERT INTO aey_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Odocob qadaca bilec saen eu hedocob Josef uqa Ferona dana iloilo eu age maaden, “Ija coni umeig Fero maduteiga. ");
INSERT INTO aey_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Edi madoiga, ‘Saen ija mei uqa cal migia bili bibili bilei uqa oditeceb ija je cagu madem. Ija uqa meen hel uqa saciadon Kenan mahana nijia ono hel cisidugen em. Eunu culitecem ija nuimig ija mei hel cisimig haun ceseli hugen,’ doiga,” aden. ");
INSERT INTO aey_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Odocob Fero uqa wadacdoc je ceseli suldumei madon, “Hina memen odi odiheceb je cagu madem eu odi odoga. Timeg memen hel cisiga,” don. ");
INSERT INTO aey_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Eunu Josef uqa memeg hel cisigiannu ten. Odocob Ferona dana iloilo cunugca uqana jonadec dana matu cunugca Isipdec dana benben cunugca age Josef gami belein. ");
INSERT INTO aey_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Uqana talca uqa waliagulca uqa memegna talca eu cunug uqaca belein. Agena mel simca sipsipca memeca bulmakauca age himec Gosen ono bilein. ");
INSERT INTO aey_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Dana karisnaca hos guhadoin ageha uqa gami belein. Euqa dana am ben bahic belein. ");
INSERT INTO aey_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Belimeig age wit tudoc cudun, Atad eu Jodan cemenug, ono calimeig age ono haun conoga suli umeig qada ben bahic qajein. Odocob Josef uqa ono deel eben naha gic lecisca haun qada qaqaji gehel bilen. ");
INSERT INTO aey_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Aria dana cajaca Kenan mahanadec age wit tudoc cudun, Atad, ono qada qaqajegin meciadimeig age madein, “I eu Isip agena gehel ben,” ein. Eunu cudun eu Jodan cemenug eu ijan Abel-Misraim qoin. ");
INSERT INTO aey_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Eunu Jekob melahul age uqa maaden eu odi odoin. ");
INSERT INTO aey_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Age gahidu ehi belimeig Kenan mahana meen hatin Makpela cabina nijia, eu Mamri cemenug, ono hel cisein. Meen hatin euca cabica osoben Ebraham uqa qalqalnu Efron Hit dana ebennadec faji cedalen. ");
INSERT INTO aey_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Odocob Josef uqa memeg hel cisi hedumei uqa waliagulca dana cunug uqaca memeg hel cisuqagannu tein eu gami age haun ceseli Isip noin. ");
INSERT INTO aey_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Aria Josef waliagul age memega cal meceb fimeig age madein, “Adi Josef uqa egenu gaid gemag benafa. Ege me qee odudom. Eunu wadacdugianfa?” ein. ");
INSERT INTO aey_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Eunu age Josef je edi suldutumeig madoin, “Ege memige uqa qee cal mec bibili bilei ");
INSERT INTO aey_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","hina mahecnu magen. Uqa edi magen, ‘Hina walinel me qee odihein eu dahin celeiale. Hina silail eu cagasiadagale,’ gen. Eunu hina qila ege, hina memen uqana Anutna cabi dana, ege me qee odihom eu cagasigiga,” doin. Saen Josef uqa je suldoin eu dah mimi uqa qajen. ");
INSERT INTO aey_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Odocob uqa waliagul age agedodoc hu mahana bilimeig dunuga qaqahi madoin, “Ege hinana cabi dana,” doin. ");
INSERT INTO aey_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Qa Josef uqa maaden, “Cain cucuiowain. Ija Anutwe uqana cudunna qee tawigaun. ");
INSERT INTO aey_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Age me qee oditecnu odoin qa Anut uqa odocob ija me bilem. Euqa ija dana ben miten. Eunu ija dana cajaca mati bahic cal mecnadec cahahaadecnu ihoc. ");
INSERT INTO aey_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Eunu cain cucuiowain. Ija ageca agena mel simca cofadigen,” aden. Odimei uqa cesuladecnu je me me maaden. ");
INSERT INTO aey_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Odocob Josef uqa Isip ono memegna talca bilein. Uqa cebac bilen eu uqana cabi gel cunug gabandoc eu 110. ");
INSERT INTO aey_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Uqa cebac bibili bilei uqa dodigul, euqa Efraim uqana mel, agena mel, eu meciaden. Uqa melah, Manasa, uqana mel, Makia, euqa uqa dodigul euha uqa cebac bibili bilei cedadeceb age ijanaga eu uqana tal ijanagaca gabandoc tawen. ");
INSERT INTO aey_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Odocob Josef uqa waliagul maaden, “Ijana cal mec dodoldona qa Anut uqa cofadimei maha inadec ehadi nui maha uqa Ebraham, Aisak, Jekobca adigiannu je cagu maaden ono madigian,” aden. ");
INSERT INTO aey_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Odocob Josef uqa Isrel melahul maadeceb age je edi cagu madein, “Anut uqa maha inadec ehigi nuigian saen euna ege hina tefulinha osoben hewi beleqan,” ein. ");
INSERT INTO aey_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Eunu Josef uqa Isip ono cal men. Uqana cabi gel 110na cal men. Odocob age deweg saen cecelac nijigiannu mool joudimeig deweg ganac eu cudaug dunuh tacein. ");
INSERT INTO aey_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jaqec je i Jisas Krais uqana sihul ijanaganu je. Jisas uqa Dewid sihulnadec, odocob Dewid uqa Ebraham sihulnadec. ");
INSERT INTO aey_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebraham uqa Aisak memeg. Odocob Aisak uqa Jekob memeg. Odocob Jekob uqa Juda waliagulca memega. ");
INSERT INTO aey_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Odocob Juda uqa Peres Seraca memela. Ale anala eu Tema. Odocob Peres uqa Hesron memeg. Odocob Hesron uqa Ram memeg. ");
INSERT INTO aey_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Odocob Ram uqa Aminadab memeg. Odocob Aminadab uqa Nason memeg. Odocob Nason uqa Salmon memeg. ");
INSERT INTO aey_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Odocob Salmon uqa Boas memeg. Uqa anag eu Rehab. Odocob Boas uqa Obed memeg. Uqa anag eu Rut. Odocob Obed uqa Jesi memeg. ");
INSERT INTO aey_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Odocob Jesi uqa King Dewid memeg. Odocob Dewid uqa Solomon memeg. Solomon anag wele eu uqa Uria aideg. ");
INSERT INTO aey_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Odocob Solomon uqa Riaboam memeg. Odocob Riaboam uqa Abaisa memeg. Odocob Abaisa uqa Esa memeg. ");
INSERT INTO aey_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Odocob Esa uqa Jehosafat memeg. Odocob Jehosafat uqa Joram memeg. Odocob Joram uqa Usia memeg. ");
INSERT INTO aey_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Odocob Usia uqa Jotam memeg. Odocob Jotam uqa Ehas memeg. Odocob Ehas uqa Hesekias memeg. ");
INSERT INTO aey_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Odocob Hesekias uqa Manasa memeg. Odocob Manasa uqa Emos memeg. Odocob Emos uqa Josaia memeg. ");
INSERT INTO aey_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Odocob Josaia uqa Jekonaia waliagulca memega. Saen euna Isrel dana cajaca age Babilon ono belimeig gihacdoc bilein. ");
INSERT INTO aey_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Age Babilon ono gihacdoc bibileig Jekonaia uqa Sialtiel memeg. Odocob Sialtiel uqa Serababel memeg. ");
INSERT INTO aey_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Odocob Serababel uqa Abiut memeg. Odocob Abiut uqa Elaiakim memeg. Odocob Elaiakim uqa Eso memeg. ");
INSERT INTO aey_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Odocob Eso uqa Sedok memeg. Odocob Sedok uqa Ekim memeg. Odocob Ekim uqa Elaiat memeg. ");
INSERT INTO aey_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Odocob Elaiat uqa Eleasa memeg. Odocob Eleasa uqa Matan memeg. Odocob Matan uqa Jekob memeg. ");
INSERT INTO aey_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Odocob Jekob uqa Josef memeg. Odocob Josef uqa Maria gemug. Odocob Maria uqa Jisas basen, eu uqa Krais egina. ");
INSERT INTO aey_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eunu sihul cunug eu Ebrahamnadec leceb Dewid calen eu sihul 14. Odocob sihul cunug eu Dewidnadec leceb Isrel dana cajaca age Babilon ono belimeig gihacdoc bilein saenna calen eu sihul 14. Odocob sihul cunug eu Isrel age Babilon ono gihacdoc bilein saennadec leceb Krais calen euha sihul 14. ");
INSERT INTO aey_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas cali honnu je eu odi nijia. Jisas anag Maria uqa Josef col codoc bibili uqa qee ocna Kis Gun odocna waugca men. ");
INSERT INTO aey_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Uqana dana, Josef, uqa Anut amegna tutuc coboloi. Odimei uqa Maria waugca ec dumei uqa culdigen ec cisdon. Euqa uqa Marianu cewudec je uqa dewegna cain hoiaunnu naha jahuni culdigen ec cisdon. ");
INSERT INTO aey_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Odi cisdudu cocobon Tibudna ensel Josef witic us ninijen bebelecna camas mimei madon, “O Josef, hina Dewid sihulnadec, hina aiden Maria ocnu cain cucuiagaun. Faga, uqa melca eu Kis Gunnadec. ");
INSERT INTO aey_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Uqa mel baseceb uqa uqana dana cajaca agena silailnu fadalowainnu cahahaadigian, eunu hina uqa ijan Jisas qogan,” don. ");
INSERT INTO aey_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Eu Tibudna je uqa je hahun madec dana cona maden eu ihoc ligiannu ceteh eu calen. Je hahun madec dana uqa wele odi maden: ");
INSERT INTO aey_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Feiga, mel aid taula oso waugca mimei mel basigian. Odocob age mel eu ijan Emanjuel qoqagan,” en. Je eu Anutna jaqec je tawena. (Ijan Emanjuel eu uqana gug eu, “Anut egeca biluquna.”) ");
INSERT INTO aey_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Odocob Josef uqa us niji cajimei Tibudna ensel maden eu odi toodu uqana caja, Maria, ehuden. ");
INSERT INTO aey_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Euqa Josef uqa Maria mel qee basec ninijen uqaca qee niji lesin. Mel baseceb uqa ijan Jisas qon. ");
INSERT INTO aey_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria uqa Jisas Betlehem jobon ono Judia hatuna baseceb Herod uqa king bilen. Saen euna haiden agena doc silecca dana age cam tobi becnadec Jerusalem jobon cali humeig ");
INSERT INTO aey_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","dana sisiladi maadein, “Mel sim haun uqa Juda agena king cali hon eu ana bilia? Ege uqana malaqa ono cam tobi becna isec camas meceb fimeb ege amegna gob cehimeb uqanu cuha feqannu hoqa,” adein. ");
INSERT INTO aey_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Odocob King Herod je eu madecebil dah mimei geh cisdon, odocob Jerusalem dana cajaca cunugha eunu geh cisdoin. ");
INSERT INTO aey_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Odocobil Herod uqa ihanec dana benbenca loo je iwaladec danaca utaadeceb cegulecebil uqa sisiladi maaden, “Krais i Anut uqa suldocob uqa Anutna dana cajaca cahahaadecnu hugian eu cel jobon cali hugian?” aden. ");
INSERT INTO aey_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Odocob age madoin, “Uqa Betlehem jobon Judia hatuna cali hugian. Je hahun madec dana agena je odi jaqec wele nijia: ");
INSERT INTO aey_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O Betlehem, Judia hatuna, king uqa Isrel dana cajaca cofadigiannu eu Betlehem ono cali hugian. Eunu Juda jobon benben age hina qee woolhegina,’ jaqec je taweia,” doin. ");
INSERT INTO aey_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Odocobil Herod uqa doc silecca dana jahuni utaadeceb hocobil uqa malaqa cel saen cali hon eunu sisiladen. ");
INSERT INTO aey_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Age silditocobil dumei Betlehem jobon belecnu dado madimei maaden, “Ijaha nui mel eunu cuha figennu age uqanu megi cuhadoigale. Odocob age eu gulucdu fimeig hu sateigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Odocob age kingna je dumeig Betlehem jobon beloqagannu belein. Odocob malaqa wele cam tobi becna isec fein eu aquniaadi, jo mel bilen eu ohis cehi qudu tawen. ");
INSERT INTO aey_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Age malaqa fimeig age wawaga gehca ceelen. ");
INSERT INTO aey_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Odocob age jona limeig melca uqa anag Maria ha fecialimeig age mel amegna gob cehi jogoimeig uqanu cuha fein. Odimeig agena bokis qosocdumeig goldca, gilic ja manecebil dedeman meca, gilic dedeman meca umeig age toinanaga osoosoca Jisas utein. ");
INSERT INTO aey_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Odocob Anut uqa age bebelecna maadi maaden, “Herod cemenug haun ceseli cain belowain,” aden. Maadeceb dumeig age jic osona agena hatuna ceseli belein. ");
INSERT INTO aey_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Doc silecca dana age wele belecebil Tibudna ensel Josef us ninijen bebelecna camas mimei madon, “Faga, Herod uqa mel wawali li qocnu madena. Eunu hina caji mel anagca cedalimeg busali Isip hatuna nui biliga. Ija mahecemin haun ceseli ene hogan,” don. ");
INSERT INTO aey_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Odocob Josef uqa witic cajimei mel anagca cedalimei Isip hatuna nui bilein. ");
INSERT INTO aey_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Odimeig age Isip hatuna bibilegin li Herod uqa cal men. Saen euna Tibudna je hahun madec dana uqana je ihoc ligiannu ceteh eu calen. Je hahun madec dana uqa wele odi maden: “Ija melami Isip ono bibilen utadocomin Isipnadec cali hon,” en. ");
INSERT INTO aey_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod uqa doc silecca dana age ija uhultiti woolti belein imei gemag ben bahic ben. Odimei uqa han dana suladeceb age mel manahal age cabi gel lecis qee wooladec eundec cunug age Betlehem jobonca hatu cemenugca ono bilein eu aqi hedoin. Uqa doc silecca dana malaqa cel saen wasen sisiladeceb madocobil don eu toodu mel aqeceb cal mein. ");
INSERT INTO aey_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Eu odocna je hahun madec dana Jeremaia uqana je ihoc len. Uqa wele odi jaqen: ");
INSERT INTO aey_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama jobonna qajec ben bahic dah mein. Qada qajec ben bahic onodec hon. Resel uqana melnu qada qajena. Mel cal mein eunu qada qajena. Age wahohog je madocobil dah mecnu culen,” en. ");
INSERT INTO aey_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod cal meceb Isip hatu ono Tibudna ensel bebelecna Josefca camas mimei ");
INSERT INTO aey_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","madon, “Dana age madi, mel qoqan, ein age wele cal mein. Eunu cajimeg mel anagca cedalecem ceseli Isrel hatuna beleiga,” don. ");
INSERT INTO aey_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Odocob Josef cajimei mel anagca cedaleceb ceseli Isrel hatuna hoin. ");
INSERT INTO aey_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Humeig Herod melah Akeleas memeg hehuldi king bibilen eu madocobil dumei uqa Judia hatuna bilecnu cucuien. Anut uqa Josef bebelecna dado mudeceb Galili hatuna nuimeig ");
INSERT INTO aey_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nasaret jobon ono bilein. Je hahun madec dana age wele odi madein, “Age uqa Nasaretdec doqagan,” ein. Eunu je hahun madec dana agena je oso ihoc ligiannu age Nasaret jobon ono bilein. ");
INSERT INTO aey_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Saen euna Jon, wa joadec dana, cajimei Judia hatuna wadau ono cocobi me je qasali maaden. ");
INSERT INTO aey_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Uqa maaden, “Sao cul jobon eu age cemenega hona. Eunu agena silailnu tului falicdoigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ge, Jon uqa dana eu Anut uqa je hahun madec dana, Aisaia, cona eunu maden. Uqa wele odi maden: “Dana jejeg oso uqa wadauna bibili utai maadena, ‘Tibudna jic saciadoiga. Uqana jic tutuc mudeiga,’ adena,” en. ");
INSERT INTO aey_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon uqa kamel bagicna lotoc mudec tacoloi, odimei uqa wailohna dool ganacna oologam mudec taqoloi, odimei uqa sisca mehud uqana waca joloi. ");
INSERT INTO aey_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Saen euna dana cajaca age Jerusalem bileginaca, dana cajaca age Judia hatu cunugna bileginaca, dana cajaca age jobonjobon Jodan Wa cemenug bileginaca age Jonca lein. ");
INSERT INTO aey_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Limeig age agena silailnu je qasali madocobil Jon uqa Jodan Wana wa joaden. ");
INSERT INTO aey_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Odocob Jon uqa Farisi Sadjusica mati age uqa wa joadigiannu uqaca hohogin feciadimei maaden, “Age man sononec nag me qee! In madeianu age Anutna gemag bec jawe hugia odona euna busalecnu age ihoc, egina? ");
INSERT INTO aey_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Agena silailnu mele bahic culimeig tului falicdumeig Anutna je qee tefacdoginanufi me odoc oso odoiga eu ihacteiga. ");
INSERT INTO aey_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Euqa ija mele maadigina, Anut uqa meen ene nijegina eu cedimei Ebraham talacul euna madecnu ihoc. Eunu age cain cisdudu madowain, ‘Ebraham ege asige. Eunu Anutna gemag bec egeca qee hoiaun,’ owain. ");
INSERT INTO aey_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sapol na gug qetecnu wele taweia. Na cunug aig me qee qona uqa qetimei jana heligian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ija age agena silailnu wele tului falicdoinnu wana wa joadigina qa oso hib tooti hona, uqana gagadic odoc ijana gagadic odoc wooldona. Uqa dana meca bahic. Ijaqa dana meca qee. Ija uqana cabi dana me bahic ihoc qee, ija uqana jaih tacec hewecwe qee. Uqa age Kis Gunna janaca wa joadigian. ");
INSERT INTO aey_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Uqa sawolca hona. Sawol euna wit aig cunug eeldocnuca, wit aig uqana jo bisna mecnuca hona. Odimei uqa witna tetec ja qee cafulina euna manigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Saen euna Jisas Galilidec Jodan Wana len. Uqa Jon uqa wa joudigiannu Jonca limei ");
INSERT INTO aey_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","madon, “Ijaha wa joitigale,” don. Odocob Jon uqa cahacdudu madon, “Hina ija wa joitegan eu me bahic. Hina eetanu ija hina wa joihecnu matagana?” don. ");
INSERT INTO aey_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Odocob Jisas Jon jejeg hewi madon, “Anut madena eu cunug toodu odocnu eu tutuc. Eunu qila culimeg gad wa joitigale,” don. Odi madocob Jon cois imei wa jouden. ");
INSERT INTO aey_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisas wa joc umei uqa mahucwe wa ocna ti tatawen sao ohis jic cebec hudeceb uqa Anutna Kis cuhudid cinigwe ni uqaca bilen fen. ");
INSERT INTO aey_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Odocob sao ohisdec ha jejeg oso camas mi maden, “Ija melami nelugca ihen. Ija uqanu wawi ben ceelena,” en. ");
INSERT INTO aey_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Saen euna Seten uqa Jisas temdu figiannu Kis Gun uqa Jisas iwaldocob wadauna nuen. ");
INSERT INTO aey_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Uqa deel 40 cahineg witicca sab qee jec bilen. Saen hedocob wen don. ");
INSERT INTO aey_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wen dodon temgec eu uqaca limei madon, “Hina Anut Melahfi meen i maadecem sab ibuldocob jaga,” don. ");
INSERT INTO aey_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Euqa Jisas uqa Seten jejeg hewi madon, “Anutna jaqec je eu odi madena: ‘Sab jec himec dana cebac bilec qee adena qa je cunug Anut conadec cali hona eu dana cebac bilec adena,’ ena,” don. ");
INSERT INTO aey_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Odocob Seten uqa Jisas ehudimei jobon gunna ehi ti tempel qab tatacanna muden. ");
INSERT INTO aey_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mudimei madon, “Anutna jaqec je eu odi madena: ‘Anut uqana ensel maadeceb hina jaim meenna qee tudoiaunnu age hina ebenegana hewihi ehi ni mihuqagan,’ ena. Eunu hina Anut Melahfi busali tonoga,” don. ");
INSERT INTO aey_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisas Seten jejeg hewi madon, “Anutna jaqec je osoha madena: ‘Tibud, hinana Anut, eu cain temdu fagaun,’ ena,” don. ");
INSERT INTO aey_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Odocob Seten uqa haun Jisas ehudi aluh benna ehi ti muden. Mudimei mahamaha cul cunug agena tumutum cahulecca ihacdudu madon, ");
INSERT INTO aey_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Faga, hina amina gob cehi ijanu cuha fecemfi fagana eu cunug culihigen,” don. ");
INSERT INTO aey_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Odocob Jisas Seten jejeg hewi madon, “Anutna jaqec je odi madena: ‘Tibud uqa hinana Anut uqanu cuha faga, uqa himec cewel utugale!’ ena, Eunu Seten, cuculti nuuga,” don. ");
INSERT INTO aey_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Odocob Seten uqa Jisas cuculdi nueceb ensel age hu Jisas cewel utoin. ");
INSERT INTO aey_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aria, Jisas uqa age Jon hewimeig gihacdoc jona mudein ec dumei uqa Galili hatu ono nuen. ");
INSERT INTO aey_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Odimei uqa Nasaret culimei Kapaneam jobon nui bilen. Kapaneam jobon eu Galili wa gad cagocna isec nijina, eu Sebjulan sihulca Naftali sihulca agena hatu gadac nijina. ");
INSERT INTO aey_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Je hahun madec dana, Aisaia, je oso wele maden eu ihoc ligiannu odi odon. Uqa odi jaqen: ");
INSERT INTO aey_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebjulan sihulca, Naftali sihulca, alena hatu eu Galili wa gad cagocna isec nijia, Jodan Wa ono isec, Galili hatu Juda dana qee eundec agena, ");
INSERT INTO aey_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","hatu euna dana cajaca age tuna biloloig eu fulacdoc ben oso fein, dana cajaca age cal mec hatuna tuna biloloig, eu fulacdoc ben oso iletaden,” Aisaia odi jaqen. ");
INSERT INTO aey_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Saen ina Jisas uqa dana cajaca je qasali maadi sanan mimei maaden, “Sao cul jobon eu age cemenega hona. Eunu agena silailnu tului falicdoigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas uqa Galili wa gad cagocna cocobi dana oso waliagca fecialen, eu Saimon, age Pita egina, uqa waliag Andruca. Ale cimec ben wana hehelesin fen. Ge, age cul dool cedec dana. ");
INSERT INTO aey_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Odocob Jisas maalen, “Hu tootecebil ija odalecemin ale dana cajaca cedadowasan,” alen. ");
INSERT INTO aey_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Maaleceb mahuc bahic alena cimec ben cuculesi uqa toodu belesin. ");
INSERT INTO aey_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Uqa nag bahic onoca limei dana oso waliagca fil fecialen, eu Jems, uqa Sebedi melah, uqa waliag Jonca. Ale memela, Sebedica, agena wagna bibileig cimec ben tatalec eu haun wewegi bilein. Odocob Jisas utaalen. ");
INSERT INTO aey_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mahuc bahic ale wag memelaca cuculadi limesi Jisas toodu belesin. ");
INSERT INTO aey_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas uqa Galili hatu cunug cocobi nuen. Uqa Juda agena cuha jonana limei dana cajaca iwaladen. Odimei uqa sao cul jobonnu me je qasali maaden. Odimei uqa dana cajaca agena hag filfilca age dewenega laleg mein eundec filfilca me maden. ");
INSERT INTO aey_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Age uqa hutannu je saec eu Siria hatu cunugna ihoc len. Odocob age dana cajaca hag gug filfil me qee maden eundecca, dain ben aden eundecca, buga me qee hewadein eundecca, dana caja titi hudec hagca age gaid dewenega qeleceb toni mahulegina eundecca, dana tefulunuga laleg mi cal mein eundecca cedadi Jisasca ahocobil Jisas uqa me maden. ");
INSERT INTO aey_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dana cajaca am ben age Galili hatunadecca, Dekapolis hatunadecca, Jerusalemdecca, Judia hatunadecca, Jodan Wa ono isec hatunadecca age toodu belein. ");
INSERT INTO aey_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas uqa dana cajaca mati bahic uqaca hohogin feciadimei uqa aluh osona ti bibilen uqana malogom uqaca hoin. ");
INSERT INTO aey_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Odocobil uqa uqana malogom iwalaadi maaden: ");
INSERT INTO aey_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Dana age Anutnu doc dumanaga ihoc qee eunu dogina eundec saona gun cul eu agena. Eunu age eeladecca bilegina. ");
INSERT INTO aey_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Dana age qada qajegina eundec Anut age wahohogadigian. Eunu age eeladecca bilegina. ");
INSERT INTO aey_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Dana age gemanaga jocosaigca eundec mahamaha cunug eu age mugumuga oqagan. Eunu age eeladecca bilegina. ");
INSERT INTO aey_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Dana age tutuc odoc ihoc ligiannuca, agedodoc agena odoc tutuc migiannuca odogina eu odi sab wen adenaweca, wa gab adenaweca eundec Anut uqa cesuladeceb age ihoc oqagan. Eunu age eeladecca bilegina. ");
INSERT INTO aey_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Dana age cotogail walocca bibilegin feciadimeig wawaga qocob me madegina eundec age saen osona walocca bibilebil Anut feciadimei waug qocob me madigian. Eunu age eeladecca bilegina. ");
INSERT INTO aey_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Dana age wawaga cataniec eundec age Anut ola foqagan. Eunu age eeladecca bilegina. ");
INSERT INTO aey_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Dana age maul qetegina eundec age ijanaga Anut melahul oqagan. Eunu age eeladecca bilegina. ");
INSERT INTO aey_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dana age tutuc odoginanu aaqati tootooadec gahidogina eundec saona gun cul eu agena. Eunu age eeladecca bilegina,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Dana mahanadec eundec age, age ijana bilegina eunu cewadimeig aaqati tootooadimeig age agenu je me qee uhulaadi madegina saen euna age eeladecca bilegina. ");
INSERT INTO aey_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Odi bahic ha dana age je hahun madec dana wele biloloig eu aaqati tootooadoloig. Age sao jobonna ameg me bahic oqagan. Eunu age wawaga me meceb ceeli bileigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisas je haun maaden, “Age odi mahamahanu macas bilegina. Euqa macas uqana mug qah becebfi adi haun mugca migian? Macas qah bec eu ceteh osonu qee ihoc lena. Age dana lahacluhucdoqagannu helegina,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Age odi mahamahanu fulacdoc bilegina. Jobon ben aluhna cehein nijia eu jahunec nijecnu qee nijel. ");
INSERT INTO aey_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Dana age gowoc oso madacdumeig hal dunuh qee tacena qa age gowoc ohisna caqusegina. Odocobil jona bilegina eundec cunug fulacadena. ");
INSERT INTO aey_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Dana age agena me odoc eu fimeig age Memega sao jobon bilia uqa binan suluqagannu age eu odiwe agena gowoc madacdocobil eu dana fulacadeiale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","18","Jisas je haun maaden, “Ija mele maadigina, sao mahaca qee mudigian deel qee cali hoc ninijeb loo je jaqec naha nag osolha qee fadaleiaun. Loo je ninijeb li ceteh cunug ihoc ligian. Eunu age ijanu uqa Mosesna loo jeca je hahun madec dana agena iwaladec jeca bebesi qee mudigiannu hon odi cain cisdowain. Qeeo, ija loo jeca agena iwaladec jeca qee mudigennu qee holom qa ija loo jeca agena iwaladec jeca toodu bahic ihoc ligiannu hom. ");
INSERT INTO aey_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","20","Ija maadigina, agena tutuc odoc eu Farisica loo je iwaladecca agena tutuc odoc qee wooldocobfi ageha saona gun culna qee lowain. Eunu dana oso loo je nag odi besimei dana odi ha toodu odocnu iwaladena eu uqanu saona gun culna age uqa caunca qee oqagan. Osoqa loo je toodu odimei dana ha odi odocnu iwaladena eu saona gun culna ijan meca ugian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jisas je haun maaden, “Loo je age jajanagail wele oin eu age dogina eu odi madena: ‘Hina oso cain qocom cal meiaun. Oso qocob cal meceb eu uqa gesilec jona ligian,’ ena ec je nijia. ");
INSERT INTO aey_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ijaqa maadigina, oso uqa cotignu gemag bena eu gesilec jona ligian. Odocob oso uqa cotig cewudec je me qee madona eu Juda dana matu agena cegulec age dana eu gesildocnu ihoc. Odocob oso uqa cotig madona, ‘Hina dana gad,’ dona eu oloqanih jana lecnu ihoc,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Eunu hina ihanec cabalna tatawi hinana ceteh ihandoga bibili hina cotin hina dewennu je hewihewi cobona eunu dahin fogo docobfi ");
INSERT INTO aey_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","hina casac hinana ceteteh ihanec cabalna ninijeb cuculi cotinca li je tutuc mudesiale. Odimeg hu hinana ceteteh ihandogale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Dana oso hina dewennu um qocobfi hinana cad gesilec dana ben uqa ebenna mihiaunnu, odocob gesilec dana ben uqa gesilec jona cofadec dana ebenna miheceb uqa gihacdoc jona tacihiaunnu eunu hina hinana cadca gesilec jona bebelesi jicna uqaca tanawecnu wawin nijiale. ");
INSERT INTO aey_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ija mele mahigina, hina meen qaig ihoc lec qee helecemfi qee bahic besihuwain,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisas je haun maaden, “Age jajanagail wele loo je oso oin eu ageha dogina je eu odi madena: ‘Hina dana cajaca alena sisi jelalec cain wagalagaun,’ ena ec je nijia. ");
INSERT INTO aey_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ijaqa maadigina, oso dana osona caja fimei nenehegdudu hewoum ena eu uqa wele waug dunuhna cajaca wal kobol odosin,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Hina amen meula isec eu silail mecnu faninhigia odocobfi selimeg helagale. Hina dewen cunug oloqanih jana helowaindainnu hina dewen naha culimeg silail qee moum eu me. ");
INSERT INTO aey_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Hina eben meula isec eu silail mecnu faninhigia odocobfi qeti helagale. Hina dewen cunug oloqanih jana helowaindainnu hina dewen naha culimeg silail qee moum eu me,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jisas je haun maaden, “Wele age odi madoloig: ‘Oso uqa aideg culdina eu uqa sisi jelec cufalec jaqec je utigian,’ oloig ec je nijia. ");
INSERT INTO aey_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ijaqa maadigina, dana oso uqa aideg dana osoca qee leceb nijelesin euqa gauc dana caja sisi jelec cagumei caja culdina eu uqa aideg odudeceb aideg wal kobol odona. Eetanu? Uqa aideg dana oso ocob ale wal kobol odosina. Odocob dana oso uqa caja gemug culden eu ona uqaha dana caja sisi jelec cufalimei wal kobol odona,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jisas je haun maaden, “Ageha age jajanagail je oso oin eu mamadegin odi doin, ‘Hina Tibud amegna ceteh oso odigen ec je cagoc oso madecemfi hina je cagoc eu cain dahin celeiaun. Hina Tibud amegna je madem eu cisdudu toodu odogale,’ madegina ec je nijia. ");
INSERT INTO aey_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ijaqa maadigina, Tibudca ceteh osoca amegna madigina odi cain bahic owain. Odocob sao eu Anutna bilec bahim. Eunu sao amegna madigina cain owain. ");
INSERT INTO aey_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Odocob maha eu bahim Anut uqa jaih tatacan mudina. Eunu maha amegna madigina cain owain. Odocob Jerusalem eu King Ben uqana jobon. Eunu Jerusalem amegna madigina cain owain. ");
INSERT INTO aey_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hinaha hina gosin osol cas lec eu senenec ibuldocwe qee, odocob hina gosin osol senenec eu cas lec ibuldocwe qee. Eunu hina ija ilomina je tutuc madigina cain agaun. ");
INSERT INTO aey_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Age sisiladecebil eu melefi age ‘Ese’ ec dih madeigale. Qeefi, age ‘Qee’ ec dih madeigale. Age je eu je oso tubdufeig Setenna je ec madoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jisas je haun maaden, “Age je oso odi madoloig ec doin: ‘Oso uqa cotigna ameg me qee mudecebfi ageha uqa ameg me qee mudeigale. Oso uqa cotigna maih me qee mudecebfi ageha uqa maih me qee mudeigale,’ oloig ec je odi doin. ");
INSERT INTO aey_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ijaqa maadigina, qisol mec dana age, age dewenega me qee mudegina eundec age ameg me qee wadac cain adowain. Oso hina sihom oso naha qahecebfi hina naha ha ihacdogale. ");
INSERT INTO aey_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Oso hinaca cetehnu tutuac cacadesi hinana siot cawalihecebfi hinana lotoc meca ha culitogale. ");
INSERT INTO aey_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Oso uqaca nuecnu kilomita osol ihoc lecnu ninichecebfi hina kilomita leciscadoc belesiale. ");
INSERT INTO aey_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Oso ninihecebfi eu ceteh utugale. Oso cesultagale hecebfi cain hibemdogaun, cesuldogale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jisas je haun maaden, “Age je oso odi madoloig ec doin, ‘Hina hina utuqain bilec eundecnu nalunuga magale. Hinana cad sagagadagale,’ oloig ec je odi doin. ");
INSERT INTO aey_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","47","Ijaqa maadigina, age, dana age agenu nalunuga megina eundec himec nalunuga meginafi Anut cel ameg me adigian? Takis cedec dana eu ageha odi odogina. Odocob age agena danah eundec himec feele ec maadeginafi age in wooldu odogina. Haiden ageha odi odogina. Euqa Memega Anut uqa me odoc eundecca me qee odoc eundecca cam sulduadena. Uqa tutuc coboginaca tutuc qee coboginaca osobennu waha sulduadena. Eunu age Memega sao jobon bilia eu age uqa melahul bilegina eu camas moqagannu age agena cadnu nalunuga meigale. Aaqati tootooadegina eundecnu Anut waug qugiannu inondoigale. ");
INSERT INTO aey_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Age Memega sao jobon bilia eu uqa odoc me ihoc lec bilina. Eunu ageha agena odoc me ihoc lec bileigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisas je haun maaden, “Batut feigale. Age dana egena Anut cewel utoc foqagan imeig odocobilfi age Memega sao jobon bilia eu ameg me uqa qee adeiaun. Eunu age Anut cewel utoc eu ege odocomun dana age meciguqagan cain owain,” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Me hihili coboc dana age Juda agena cuha jonaca jicnaca ege binanige suluqagan imeig sawen dana loo siwiadoqa bili aquniaadi taul fuldogina. Eunu hina me hihili coboc dana eundec odi odogina cain odogaun. Ija mele maadigina, dana eundec age agena ameg oc eu wele oin. ");
INSERT INTO aey_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Euqa hina wawin qocca loo siwiadec eu jahunec biligiannu hina sawen dana eundec loo siwiadecem eben meulana isec odona eu eben ansena isec cain doiaun. Odocob Memen uqa ceteh jahunecna bilia eu fena uqa ameg me ihigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jisas je haun maaden, “Me hihili coboc dana age dana ege Anut inondocomun meciguqagan imeig Juda age cuha jonaca jicnaca tatawi Anut inondogina eunu gale ben adena. Eunu hina me hihili coboc dana Anut inondoginawe odi cain inondogaun. Ija mele maadigina, dana eundec age agena ameg oc wele oin. ");
INSERT INTO aey_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Euqa hina Memen inondoga bili hina jo hamol limeg jic cebec menimeg Memen uqa jahunecna bilia eu inondoga. Odocob Memen uqa ceteh jahunecna bilia eu fena uqa ameg me ihigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Haiden age madegina, ‘Ege egena tibud je mati bahic madocomunfi jejenige toodu odigian,’ egina. Eunu age inondudu je gauc madegina eu odi haiden odoginawe cain madowain. ");
INSERT INTO aey_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Age Memega qee madoc ninijeb uqa agena wawaga hoolecca agena togo nijigiannu madegina eu wele dona. Eunu age haiden odogina odiwe cain odowain,” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Eunu age odi inondoigale: ‘O ege Memige, hina sao jobon biligina, hina ijain gun biliale. ");
INSERT INTO aey_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Hinana cul egeca hoiale. Hina con toodu odoc sao jobon ihoc lenawe odi mahana ha ihoc leiale. ");
INSERT INTO aey_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sab jecnu ba i ihoc igigale. ");
INSERT INTO aey_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Dana age ege me qee odigeinnu ege dahinige celenwe hinaha egena me qee odadec eunu dahin celeiale, ");
INSERT INTO aey_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Hina ege temgecna cain ehi li migigaun. Euqa qisol mec kobol eu cagasigagale,’ doigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ge, age dana age me qee odadein eu agena silail dahiniga celecebfi Memega sao jobon bilia uqaha agena silail dahig celigian. ");
INSERT INTO aey_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Euqa age dana age me qee odadegina eu agena silail qee dahiniga celecebfi Memega uqa agena silailha dahig qee celeiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jisas je haun maaden, “Me hihili coboc dana eu age ege sabnu qagu biluquna eu meciguqagan imeig olanaga jugu qocca cobogina. Euqa age sabnu qagu bilecnu bibileig olanaga jugu qoc me hihili coboc dana eu odi odoginawe cain cobowain. Ija mele maadigina, dana eundec age agena ameg oc eu wele oin. ");
INSERT INTO aey_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Euqa dana hina sabnu qagu biligina eu cain fecihuwainnuqa Memen jahunecna bilia eu mecihigiannu hina sabnu qagu bilecnu bibili gosin cilihdumeg olain wasacudagale. Odocob Memen uqa ceteh jahunecna bilia eu fena uqa ameg me ihigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","21","Jisas je haun maaden, “Hina toinain haudoc nijina eunu hina wawin cisdocha nijina. Mahana cehewan eu cumucumca tontonca hewi me qee mudina, odocob heje dana ceteh euha heje ocna cawaladoqagan. Eunu age mahana cehewan meca agedodocnu haudocnu cain cabi owain. Euqa sao jobonna cehewan eu tontonca qee hewena, eu susul me qee mudecwe qee, odocob heje oc dana euha heje ocna cawaladecwe qee. Eunu age sao jobonnu age cehewanaga meca haudocnu cabi oigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jisas je haun maaden, “Dewenna fulacdoc eu hina amen. Eunu hina amen me nijinafi hina dewen cunug fulacdocca nijina. ");
INSERT INTO aey_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Euqa hina amen galuc mecebfi dewen cunug tu migian. Eunu fulacdoc eu wawinna bilia eu cafulecebfi wawin eu gagatucna bahic bilina!” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jisas je haun maaden, “Cabi dana oso uqa dana ben lecis alena cabi ocwe qee. Ge, uqa oso sagagduduqa osonu nalug migian. Qeefi, uqa osonu waug nijigian qa oso cewudigian. Odiwe ha age Anutca maha cehewanagaca agena tibud mumudi osoben cabi u calecnu qee nijel,” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jisas je haun maaden, “Eunu ija age maadigina, age mahana cebac bilecnu cain jaen aqeiaun. Eeta sab jeqan, eeta gab jeqan, cain owain. Age deweneganu ha cain jaen aqeiaun. Eeta taceqan cain owain. Agena cebac bilec eu sab jec wooldona. Dewenega eu lotoc wooldona. ");
INSERT INTO aey_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Man fululec sao bisilag cobogina eu meciadeigale. Age ceteteh qee cehegina. Ageha wal meceb ceteteh jo bisna qee tacegina. Euqa age Memega sao jobon bilia uqa moot madena. Age agena fajec eu man fululec agena fajec wooldoc bahic bilegina! ");
INSERT INTO aey_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Age info uqa uqana cebac bilecnu jaen qonana uqa uqana maha bilec saen nag cecelacca mudecnu ihoc?” aden. ");
INSERT INTO aey_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Age eetanu lotoc tacecnu jaen ben aqena? Age ceteh sal qoc wasena eu feiga. Age cabi qee ogina, agena lotocha qee mudegina. ");
INSERT INTO aey_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Euqa ija odi maadigina, Solomon uqa lotoc tumutumca bahic taci tawen eu sal qoc bahunadec tawena i oso qee wooldol. ");
INSERT INTO aey_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Euqa Anut uqa ceteh gigisac gami tacec balaca adena, ceteh eu qila tawena uqadec jana helecebil cijina. O age wawaga meleec meca qee, age dogina, Anut uqa age gigisac wooldudu tacecnu adigian. ");
INSERT INTO aey_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Haiden age ceteh eu cunugnu jaen aqena. Odocob age Memega sao jobon bilia uqa age ceteh euca qeefi age maha ina bilecwe qee eu uqa dona. Eunu age jaen aqeceb eeta sab jeqan, eeta gab jeqan, cel cetehna dewenige taceqan eu cain madowain. ");
INSERT INTO aey_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Euqa age casac age Anut mudecebil uqa agena king biliale, odocob age uqana tutuc coboc umeig toodoigale. Oodobil ceteh mahanadec eu toodu ageca hugian. ");
INSERT INTO aey_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Deel uqadec uqadodoc jaen qocca cisdugian. Eunu age deel uqadec uqana gihacadec eunu cain jaen aqeiaun. Deel abesabes gihacadec gahidocnu ihoc gulucdoigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","5","Jisas je haun maaden, “Eetanu hina cotin amegna hilican nag eu fagana qa hinadodoc amenna fan ben nijina eu qee fagana? Qeefi, hina adi cotin madogana, ‘Coti, cultecem hilican nag amenna nijia eu u helihigen,’ dogana qa hina amenna fan ben nijina? Hina me hihili coboc dana! Casac fan ben eu hina amenna fagdoc nijia eu cagati helagale. Odocob hilican nag cotin amegna nijia eu u helecnu ihoc fegan. Gesilec age osonu je madegina gesilec euna Anut uqa age gesiladigian. Age ihoc mec dana ihoc miadegina ihoc mec euna ha Anut u hewi age ihoc miadigian. Eunu Anut age gesiladimei camasac mimi cewadeiaunnu age dana osona kobol gesildumeig cain camasac mimi cewudec je madowain,” aden. ");
INSERT INTO aey_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Qa age falicdu age tataladowainnu age ceteh Anutnu gun bahic nijia eu qa cain culiadowain. Ho age gilolo eu lahacluhucdowainnu agena gilolo me eu ho amagana cain helowain,” aden. ");
INSERT INTO aey_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Jisas je haun maaden, “Cunug age cetehnu Anut sisildogina eu ceteh ogina. Odocobil oso ceteh walena eu ceteh gulucdona. Odocob oso jic cebec gohugohudona eu Anut huditugian. Eunu Age Anut cetetehnu inondocobil ceteh eu adigian, odocobil age wawali cobimeig ceteh walegina eu gulucdoqagan, jic cebec gohugohudocobil Anut hudiadigian. ");
INSERT INTO aey_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Qeefi, age gemona dana oso uqana mel uqa memeg sab itiga jiga docobfi memeg uqa sab qee utina qa meen utinafo? ");
INSERT INTO aey_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Qeefi, age gemona dana oso uqana mel uqa memeg cul dool itiga jiga docobfi memeg uqa cul dool qee utina qa man sononec utinafo? ");
INSERT INTO aey_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Feiga, age dana gug me qee qa age agena mel ceteh me adecnu dogina. Eunu age mele dogina, Memega sao jobon bilia eu uqa age sisildogina eundec ceteh me bahic adigian! ");
INSERT INTO aey_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Eunu dana filfil age agenu odadecebil gale adenawe eu odi age dana filfilnu ha odadeigale. Ge, Mosesna loo jeca je hahun madec dana agena iwaladec jeha madein agena je eu uqana caun ihen,” aden. ");
INSERT INTO aey_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jisas je haun maaden, “Fadalecna calecnu jic cebec eu bagalan, jic euha bagalan. Toodocnu eu hetec. Odocob jic cebec euna mati bahic limeig jic euna cobogina. Euqa cebac bilec catanec euna calecnu jic cebec eu sosog, odocob jic euha cacanigca. Odocob dana cajaca mati bahic jic eu gulucdumeig qee toodogina. Eunu age cebac bilec catanec euna loqaga bili jic cebec sosogna leigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jisas je haun maaden, “Age uhulec je hahun madec dana age sipsip ganac tacimeig eu age qee waadecnu odi ageca hogina. Euqa wawaga dunuhna age qa cus olohonogaca odi nijia, age me qee bahic odadoqagan. Eunu ageca hu qauadowainnu batut feigale. ");
INSERT INTO aey_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Age agena odoc aig qocnana cisadi feigale. Qam aig gagalit na mogi jecnu nijiafo? Dan aig momos na mogi jecnu nijiafo? ");
INSERT INTO aey_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eu odi cehelo gug me eu aig me qona, odocob na gug me qee uqa aig me qee qona. ");
INSERT INTO aey_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Cehelo gug me uqa aig me qee qocwe qee, odocob na gug me qee eu uqa cehelo aig me qocwe qee. ");
INSERT INTO aey_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na uqa aig me qee qona eu codocobil toneceb cedimeig jana manegina. ");
INSERT INTO aey_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eu odiwe age uhulec je hahun madec dana agena odoc aig qocna cisadi feigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Dana cajaca age ija ‘Tibud, Tibud,’ tegina eu cunug sao cul jobon dunuh qee lowain. Euqa Mei sao jobon bilia eu madena eu toodu odogina age himec loqagan. ");
INSERT INTO aey_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Deel cit qoc euna mati odi matoqagan, ‘Tibud, Tibud, ege hina ijainna je hahun madeginawe odi qee madolomfo? Ege hina ijain hewi buga me qee eundec qee ititacadolomfo? Ege hina ijainna kobolkobol qee odolomfo?’ toqagan. ");
INSERT INTO aey_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Odi matecebil ija maadigen, ‘Ija age, age ijana eu qee feciadelem. Age qisol mec kobol odogina cuculti beleiga,’ adigen,” aden. ");
INSERT INTO aey_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jisas je haun maaden, “Eunu oso, ijana je dah mimei eu toodu odona, eu dana cisdoc silecca cinigwe. Dana eu uqa uqana jo maha gagadic meencana cehen. ");
INSERT INTO aey_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Odocob wa ben neceb wa cue ha humei jona leceb gugula ha hu jo eu heweceb qa jo eu uqana nah maha gagadicna cehen tawennu jo qee cabatel. ");
INSERT INTO aey_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Osoqa uqa ijana je dah mimei eu toodu qee odona eu uqa dana gad oso odi, uqa uqana jo wa gon esicna cehen. ");
INSERT INTO aey_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Odocob wa ben neceb wa cue humei jona leceb gugula ha hu jo heweceb jo eu cabaten. Odimei jo cabati nui me qee bahic muden,” aden. ");
INSERT INTO aey_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jisas uqa Juda agena loo je iwaladec dana oso cunug maadeinwe odi qee maadel qa uqa je Tibud gagadic odocca iwalaadi maaden. Eunu uqa je eu maadi mamaden dana cajaca age wawaga cacaden bilein, uqana iwaladec je eu wawaga qon. ");
INSERT INTO aey_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas uqa aluh culimei toni nuen. Toni nunuen dana cajaca am ben bahic toodu belein. ");
INSERT INTO aey_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jisas nunuen hag dana oso deweg lepraca uqa Jisas fimei uqa limei Jisas olana gob cecehi Jisasnu cuha fefei cesusdu madon, “O Tibud, hina ija me mitiga hecebfi hina me mitecem ijana hag culteceb ija Anut amegna cataniec bilecnu ihoc,” don. ");
INSERT INTO aey_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Odocob Jisas eben huleldumei deweg qududodoi madon, “Ija me mihiga tena. Me maga!” don. Saen eunadih lepra hag eu uqa dewegna culdeceb deweg hul hon. ");
INSERT INTO aey_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Odocob Jisas cahacdu madon, “Dah maga, ceteh inu oso cain sadudu cobogaun. Euqa li nawel tawec ihanec dana eu hina dewen ihacdocom maleldugian. Odimeg Moses loo je wele maden eu toodumeg hina qila me biliga dana cajaca cunug ihacadecnu Anut ihandogale,” don. ");
INSERT INTO aey_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas uqa Kapaneam jobon dunuh lelen Rom agena han ilo dana 100 cofadec oso ono uqaca hu ninidudu madon, ");
INSERT INTO aey_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“O Tibud, ijana cabi dana ijana jona hag nijia. Uqa laleg men deweg geh dain dona,” don. ");
INSERT INTO aey_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Odocob Jisas uqa jejeg hewi madon, “Ija hinaca belimeu me mudihigen,” don. ");
INSERT INTO aey_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Euqa Rom agena han ilo dana 100 cofadec uqa madon, “O Tibud, hina ijana jo dunuh lecnu eu ija dana me bahic ihoc qee. Faga, ijaha ijadodoc han dana ilo oso bisalu biligina. Odocob ijaha han dana leih ija bisalu bilegina. Ija oso nuuga ecemin nuina. Ija oso hoga ecemin hona. Odocob ija ijana cabi bega meh dana odi odoga ecemin uqa coni toodu odona. Eunu hina je osol madecem ijana cabi dana hag medugian,” don. ");
INSERT INTO aey_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas uqa Rom agena han ilo dana 100 cofadec je eu madeceb dah mimei tumatumai toodoin eundec maaden, “Ija mele maadigina, ija waug meleec uqana bilina cinigwe Isrel gemona oso qee gulucdolom!” aden. ");
INSERT INTO aey_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Ija age maadigina, cam tobi becnadecca cam toni nocnadec ha mati hoqagan. Age Ebrahamca, Aisakca, Jekobca gami sao cul jobon ono sab jecnu biluqagan. ");
INSERT INTO aey_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Age odi bibilegin Isrel dana cajaca Anut uqa age sao cul jobon bilecnu nesili ehaden eundecqa Anut ititacadeceb jobon hahagum limeig tu gagatuccana biluqagan. Ono dana age qada qaqaji maimaga kicodudu biluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Odimei uqa Rom agena han ilo dana 100 cofadec madon, “Wawin meleec eu toodu odihiale. Hina gad nuuga,” don. Madodon euna bahic Rom agena han ilo dana 100 cofadec uqana cabi dana hag medon. ");
INSERT INTO aey_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Odocob Jisas uqa Pitana jona limei uqa Pita momoig hag deweg daincaca hulec ninijen fen. ");
INSERT INTO aey_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Odimei uqa hagca caja eu eben qududocob uqana hag culden. Odocob uqa cajimei sab jec saciadumei Jisas cewel uten. ");
INSERT INTO aey_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Odocob wesu meceb dana age cotogail mati dewenega buga me qee hewadein eundec cedadecebil Jisasca ahoin. Odocob Jisas uqa buga me qee je maadeceb dana deweneganadec cali hu belein. Odimei dana cajaca cunug age hagca me maden. ");
INSERT INTO aey_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Uqa je hahun madec dana, Aisaia, uqana jaqec je ihoc ligiannu odi odon. Jaqec je eu wele odi maden, “Uqa egena hag filfil cedi gahidu nuen,” en. ");
INSERT INTO aey_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Odocob Jisas uqa dana cajaca am ben bahic talildu tatawegin fimei uqana malogom maaden, “Ege wa gad cagoc cool ono isec beleqan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Odocob loo je iwaladec dana oso Jisasca humei madon, “Iwalgec, hina anaana nunuem ija toohigen,” don. ");
INSERT INTO aey_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Odocob Jisas jejeg hewi madon, “Qa cus agena helona nijegina, odocob man fululec agena teicna nijegina. Euqa Dana Melah uqa us nijec cudunca qee,” don. ");
INSERT INTO aey_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Odocob malogom oso uqa Jisas madon, “O Tibud, cultecem ija casac ceseli nuimig mei heel cisigen,” don. ");
INSERT INTO aey_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Odocob Jisas jejeg hewi madon, “Cal mec dana culadecem cal mec eundec agena heel ciseigale. Hinaqa ija tootaga,” don. ");
INSERT INTO aey_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas uqa wag osona tobocob uqana malogom toodu toboin. ");
INSERT INTO aey_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Age nunuegin ququlubadecwe gugula ben neceb macas me qee meceb caji qahi wag dunuh qelen. Euqa Jisas uqa us nijen. ");
INSERT INTO aey_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Odocob malogom age li Jisas tulidudu madoin, “Tibud, ege fadalecnu odoqona. Cahahagagale!” doin. ");
INSERT INTO aey_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Odocobil uqa maaden, “Oe age wawaga meleec meca qee. Eetanu cucuiegina?” aden. Odimei uqa caji gugula macasca cahacaali maaleceb manin tilien. ");
INSERT INTO aey_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dana age eu oodon fimeig tumatumai madein, “Uqa cel dana fufuca macas qahecca uqa co toodu odosina?” ein. ");
INSERT INTO aey_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Odocob age nui Gadara agena hatuna calein, eu Galili wa oc naha isec. Odocob dana lecis buga me qee hewalein eu ale qalqal hatinnadec cajimesi Jisas gulucdosin. Ale cus bahic. Eunu dana age jic euna nuecwe qee. ");
INSERT INTO aey_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Odocob ale jejenela suli u madosin, “O Anut Melah, hina ege eeta odigegan? Saen qee calel hina ege me qee odigecnu hogafo?” dosin. ");
INSERT INTO aey_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aria, ho am ben oso ono isec sab jiji coboin. ");
INSERT INTO aey_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Odocob buga me qee age Jisas ninidudu madoin, “Hina ititacgifeg ho am euna sulgecem age dewenegana leqan,” doin. ");
INSERT INTO aey_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Odocobil Jisas maaden, “Beleiga,” aden. Odocob age dana lecis cuculaleig ho dewenegana lein. Odocobil ho cunugca aluh qeihqeih guguli nu Galili wa gad cagoc dunuh gotoimeig cunugca odi wa jimeig cal mein. ");
INSERT INTO aey_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Odocobil dana ho cofadoloig eu age fimeig busali belein. Age taun ben limeig ceteh cunug calennu dana cajaca maadein. Age ceteh dana lecis buga me qee hewalein aleca calen eunu saadein. ");
INSERT INTO aey_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Odocob dana cajaca cunug age taun euna bilein eu age limeig Jisas gulucdoin. Odimeig age Jisas fimeig dana Gadara agena hatunadec cunug Jisas cuculadi nuigiannu ninidoin. ");
INSERT INTO aey_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas uqa wagna tobimei wa gad cagoc leti hagen naha isec nuen. Odimei uqa uqana jobon calen. ");
INSERT INTO aey_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Odocob dana leih age dana laleg hagca oso gabagabna ninijen Jisasca hehewi ehudi ahoin. Saen Jisas agena wawaga meleec eu ben bahic fimei dana laleg eu madon, “Melami, hinana silail cagasihiga qee meia eunu wawin toogdoiale,” don. ");
INSERT INTO aey_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Odocob loo je iwaladec dana leih age togodudu madein, “Dana eu uqa Anut cewudec je madeia,” ein. ");
INSERT INTO aey_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Euqa Jisas uqa agena cisdoc dumei maaden, “Age wawagana cisdoc qisol je eetanu madegina? ");
INSERT INTO aey_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Cel je madec cacanigca qee ija madigen? Ija madigen, ‘Hinana silail cagasihiga qee meia,’ ecfo, qee ‘Cajimeg coboga,’ ec madigenfo? ");
INSERT INTO aey_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Euqa Dana Melah mahana silail cagasiadecnu gagadic odoc ebenna nijia eu doqagannu ihacadigen,” aden. Odimei uqa dana laleg hagca madon, “Cajimeg hinana gabagab eu qahimeg hewi hinana jobon nuuga,” don. ");
INSERT INTO aey_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Odocob dana eu cajimei uqana jobon nuen. ");
INSERT INTO aey_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Odocob dana ono cegulein age odi oodon fimeig cucuiein. Odimeig Anut uqa gagadic odoc eundec dana aden eu binan sulein. ");
INSERT INTO aey_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas uqa jobon eu culimei uqa cali li dana oso, ijan Matju, uqa takis cedec jona bibilen fen. Fimei madon, “Tootaga,” don. Odocob uqa cajimei Jisas toodu nuen. ");
INSERT INTO aey_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Odocob hibna Jisas uqa jo euna sab jejei bilen. Bibilen takis cedec danaca, silail danaca mati hocobil age Jisas uqana malogomca gami sab jein. ");
INSERT INTO aey_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Odocob Farisi age Jisas odi oodon fimeig Jisasna malogom maadein, “Eetanu agena iwaladec uqa takis cedecca silail danaca eundec gami sab jegina?” adein. ");
INSERT INTO aey_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Euqa Jisas uqa je eu dumei maaden, “Hagca qee age hag me madec danaca qee legina. Qeeo. Hagca himec age hag me madec danaca legina. ");
INSERT INTO aey_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ija ititom dana cajaca ‘Age agena silailnu wawaga tului falicdoigale,’ ec utai maadecnu qee holom. Euqa ija silail dana cajaca ‘Age agena silailnu wawaga tului falicdoigale,’ ec utai maadecnu hom. Eunu age je i Anutna jaqec je nijia eu uqana gugnu doc eu li oiga. Je eu odi madena: ‘Ija age gauc ihantecnu qee gale tena. Ija age dananu wawaga qocca biluqagannu gale tena,’ ena,” aden. ");
INSERT INTO aey_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Saen euna Jonna malogom age Jisasca humeig sisildoin, “Eetanu egeca Farisica ege gaid esuesu sabnu qagu biluquna qa hinana malogom eu qee sabnu qagu bilegina?” doin. ");
INSERT INTO aey_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Odocobil Jisas maaden, “Age dana caja ocobocobecna cegulein bilegina eunu age caja oc dana eu gami bibileig adi qada qajec biluqagan? Euqa saen oso hibna dana leih hu caja oc dana cawaladecebil deel euna age sabnu qagu biluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Odocob oso uqana lotoc hilah giloccanu eu eeldugia bili, uqa lotoc fan haun qee cusec tatacan qee faldona. Eu odi odoubmiqa age lotoc cusecebil fan haun eu nag meceb eu gesacna haun ceseli balahadu bendoub. Wele balahadon eu wooldu qatanoub. ");
INSERT INTO aey_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Odiha wain haun jool mecmec ganacna mudec hilahna qee o danegina. Jool mecmec ganacna mudec hilah eu wele galalec eunu odoubmiqa wain eu jool ganacna mudec qatanoub, wain basecdu cusdoub, odocob jool ganacna mudecha qatani cusdoub. Qeeo, age wain haun jool ganacna mudec haunna o danecebil euna lecisca odi me nijuwasan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas uqa odi maaaden Juda agena ilo dana oso uqa humei Jisas amegna gob cecehi uqanu cuha fimei madon, “Ija ateni qila cal meia. Euqa humeg eben dewegna mudecem uqa cebac biligian,” don. ");
INSERT INTO aey_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Odocob Jisas cajeceb uqa uqana malogomca age ilo dana eu toodu belein. ");
INSERT INTO aey_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Jisas cocobi lelen caja oso ono cabi gel 12-pela golac nenen odi hewi coboloi eu uqa dana cajaca cegulec gemo limei Jisas hibilohu isec ben. Uqadodoc maden, “Ija uqana lotoc dih qududocominfi ija hag metigian,” en. Odimei Jisasna lotoc bibig qududon. ");
INSERT INTO aey_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Odocob Jisas waldumei caja eu fimei madon, “Ateni, hinana wawin meleec eu me mihia eunu wawin toogdoiale,” don. Mahuc bahic caja eu hag medon. ");
INSERT INTO aey_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Odocob Jisas uqa Juda agena ilo dana uqana jona calimei uqa dana cololo fuldodogin dana cajaca age dahoc fafalegin eu fimei ");
INSERT INTO aey_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","maaden, “Mel aid i qee cal mel. Uqa us himec nijina! Isa qoiga!” aden. Odocob age asaldoin. ");
INSERT INTO aey_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Euqa age dana cajaca ititacadecebil maha gemo lecebil Jisas uqa jo dunuh len. Odimei uqa mel aid eben u heweceb caji bilen. ");
INSERT INTO aey_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Odocob Jisas odonnu je hatu naha isec eu cunug ihoc leceb dana cajaca doin. ");
INSERT INTO aey_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas uqa cudun eu culimei nunuen dana lecis amala galuc mec ale Jisas toodu utadudu madosin, “O Dewid Melah, elenu walol heiale,” dosin. ");
INSERT INTO aey_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisas uqa jona leceb dana lecis amala galuc mec ale uqaca lecebil sisilali maalen, “Ale ija odi odalecnu ihoc wawala meleenafo?” alen. Odocob madosin, “Ese Tibud, ele eunu wawile meleena,” dosin. ");
INSERT INTO aey_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Odocobil Jisas ebenna amala qududumei maalen, “Wawala meleecna odaleia,” alen. ");
INSERT INTO aey_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Odi maaleceb ale amala fogo docob ceteh fesin. Odocob Jisas uqa cahacali maalen, “Batut fesiale, dana oso ija odaliga eu cain sadocobil doiaun,” alen. ");
INSERT INTO aey_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Euqa dana lecis ale hatuhatu cunug cocobi Jisas odalen je eu dana cunug saadecebil doin. ");
INSERT INTO aey_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Dana lecis nunuesin age dana oso ehudi Jisasca hoin. Dana eu buga me qee hewen uqa co cufa qon. ");
INSERT INTO aey_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisas uqa buga me qee eu ititacdocob dana eu cuculdi nueceb dana eu je maden. Dana cajaca age eu fimeig tumatumaimeig madein, “Uqa odona odoc odiwe dana wele Isrel gemona oso qee odocob folom,” ein. ");
INSERT INTO aey_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Euqa Farisi age madein, “Uqa buga me qee agena ben uqana gagadic odocna buga me qee ititacadena,” ein. ");
INSERT INTO aey_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas uqa jobon nagnag benbenca cocobi Juda agena cuha jona limei dana cajaca iwaladen. Uqa sao cul jobonnu me je qasali maadimei agena hag filfil aqecca dewenega laleg mein eundecca eu me maden. ");
INSERT INTO aey_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Uqa dana cajaca meciaden. Age jaen aqecca eu oso cesuladecca qee bilein. Age sipsip cofadecca qee cobogina odiwe bilein. Eunu agenu waug qon. ");
INSERT INTO aey_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Odimei uqana malogom maaden, “Cabina ceteh mati bahic cedi haudocnu wal men nijia, euqa cabi dana mati ceteteh cedi jo bisna mecnuca qee bilegina. ");
INSERT INTO aey_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eunu sab cedi haudocnu gug uqa cabi dana suladeceb sab haudocnu inondoigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Odimei Jisas uqa uqana malogom 12-pela utaadeceb uqaca hocobil uqa buga me qee dana deweneganadec ititacadecnuca, dana hag filfil aqecca dewenega laleg mein eundecca cunug me madecnuca cabi eu ebenegana men. ");
INSERT INTO aey_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Uqana aposel 12-pela age ijanaga eu odi. Casac eu Saimon, ageha Pita egina, odocob uqa waliag eu Andru. Oso eu Jems, uqa Sebedi melah, odocob uqa waliag eu Jon. ");
INSERT INTO aey_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Odocob Filipca, Batolomjuca, Tomasca. Odocob Matju, uqa takis cedec dana. Odocob Jems, uqa Alfias melah, odocob Tadias. ");
INSERT INTO aey_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Odocob Saimon, uqa Selot agena am oso, age Juda dana eu Rom dana Judia hatunadec ititacadecnu egina. Odocob Judas Iskariot, uqa hibna Jisasnu balijimei uqana cad ebenegana muden. ");
INSERT INTO aey_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas uqa dana 12-pela eu suladi maaden, “Juda dana qee eundec agena hatuna cain lowain. Sameria agena jobon oso cain lowain. ");
INSERT INTO aey_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Qee. Age Isrel sihuldec sipsipwe dad mi cobogina eundecca leigale. ");
INSERT INTO aey_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Age eu cocobi me je qasali maadeiga, ‘Sao cul jobon cemenega hona,’ adeiga. ");
INSERT INTO aey_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hag nijegina eu me madeiga. Cal mein eundec tuliadeiga. Lepra hewadec eu eeladeiga. Buga me qee dana deweneganadec ititacadeiga. Age eu odocnu gagadic odoc i qee fajelein, age gauc loo adem. Eunu ageha gauc loo adeigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Age gold qaigca, silwa qaigca, kopa qaigca agena oologamna u tacecnu cain walowain. ");
INSERT INTO aey_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Dana cabi ona eu uqana cabinu sab jec wadac gulucdocnu ihoc bilina. Eunu jic cobocnu ceteh oso cain hewowain. Age badom cain hewi cobowain. Lotoc lecisca cain hewi belowain, osol himec taceiga. Jaimaga tacec eu cain tacowain. Jic coboc kom ha cain hewi cobowain,” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Age jobon osoosona limeig age dana oso hutan meca bilinafo eunu sisiladi feigale. Odocob oso hutan me bilecebfi age uqana jona bibileig li jobon eu culimeig beleiga. ");
INSERT INTO aey_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Age jo euna leleig dana cajaca age jo euna bilec eu maadoqagan, ‘Anut eeladeiale,’ adoqagan. ");
INSERT INTO aey_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aria, jo euna bilec eundec dana mefi eu agena eeladec je dewenega fagdugian. Euqa jo euna bilec eundec eeladec je eu ocnu ihoc qeefi agena eeladec eu ceseli ageca hugian. ");
INSERT INTO aey_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Odocob dana oso age oiadecnu agena je ha dah mecnu culecebilfi age jo eufo, jobon eufo cuculadi beloqaga bili comis jaimagana fagdon eu qoidu heleiga. ");
INSERT INTO aey_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ija mele maadigina, Gesiladec Deel Benna jobon eu ameg me qee bahic ugian. Dana cajaca Sodom Gomora bilein eu ageha Gesiladec Deel Benna ameg me qee oqagan. Euqa jobon eu agena je hibemdogina jobon eu agena ameg me qee eu Sodom Gomora agena ameg me qee wooldugian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jisas je haun maaden, “Feiga, ija age suladigina odi sipsip age qa cus gemo leginawe suladigina. Eunu age man sononec doc silecca odi cisdudu coboginawe coboigale. Euqa age cuhudid qauecca qee odi coboigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Age dananu dah qut coboigale. Age gesiladecnu cegulec amegna ehi li madimeig agena cuha jona ha qisaadoqagan. ");
INSERT INTO aey_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ageha ija cilehtecnu cisdumeig gabman ilo kingca amagana ehi li madecebil tawoqagan. Odimeig age ijana me je gabman ilo kingca Juda dana qee eundecca maadoqagan. Saen euna age dana amagana wawaga meleec age eu doqagan eunu qasali madoqagan. ");
INSERT INTO aey_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Age age gesiladecnu cegulec amegna madecebil saen euna Anut je adeceb je eu tutuc madoqagan. Eunu age casac cel je cel je madigen eu cain saciadowain. ");
INSERT INTO aey_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ge, agedodoc je qee madowain. Memegana Kis eu age uqa co tawecebil je madigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Saen euna dana waliagwaliagnu balijimeig age walinigail aqecebil cal moqagannu gesilec jona madoqagan. Memegail ageha agena melnu balijuqagan. Mel age memegail anagailnu cajimeig age aqoqagannu gesilec jona madoqagan. ");
INSERT INTO aey_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Odocob ija ijani hewegina eunu dana cajaca cunug age agenu gemanaga beceb sagagadoqagan. Euqa dana cajaca cunug age ceteh eu cunug wooldudu cit qoc gadacna calegina eu Anut uqa age cahahaadigian. ");
INSERT INTO aey_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ija mele maadigina, age jobon oso cuculi busali osona li bilec odi oodi Isrel agena jobon cunug qee li hedoc ninijeb Dana Melah ceseli hugian. Eunu dana age jobon oso aqati tootooadecebil busali jobon osona beli bileiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Malogom uqana iwaldoc wooldoc qee nijel. Odocob cabi danaha uqana dana ben qee wooldona. ");
INSERT INTO aey_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Malogom uqa uqana iwaldoc cinigwe bilina eu ihoc. Cabi danaha uqa uqana dana ben cinigwe bilina eu ihoc. Age jo gug jajabi Bielsebul doin eunu ege doqona, uqana jo eundec ha odi jajabadi je me qee bahic maadoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jisas je haun maaden, “Ceteh cunug jahuldoc nijina eu isi camasac migian. Odocob ceteh cunug jahunec nijina eu isi cunug doqagan. Eunu age dananu cain cucuiuwain. ");
INSERT INTO aey_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ija tuna jahuni je maadigina eu cahinegna dana amagana madeigale. Ija age jahna maadecemin dah megina eu jo ohisna tatawi dana cajaca cunug qasali maadeigale. ");
INSERT INTO aey_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dana age dewenega cal mecnu qoc fegina qa dolonoga cal mecnu qoc eu qee fegina eundecnu cain cucuiuwain. Qeeo. Age Anutnu dih cucuiuqagan. Uqa dewenega dolonogaca eu oloqanih jana fadaligiannu ihoc nijina,” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Feiga, man fululec nag eundec lecis toea osolna idadogina. Man fululec eu age oso age Memega qee madec mahana qee tonena. ");
INSERT INTO aey_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Age gosiniga ilomogana nijia euqa cunug Anut wele sanijen bilia. ");
INSERT INTO aey_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Eunu cain cucuiuwain. Agena fajec eu man fululec nag mati agena fajec wooldoc nijia,” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jisas je haun maaden, “Eunu oso uqa dana amagana tatawi ijanu madi madena, ‘Ija Jisas uqana malogom,’ ena eu uqanu ijaha Mei sao jobon bilia amegna madigen, ‘Eu ijana,’ igen. ");
INSERT INTO aey_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Osoqa uqa dana amagana tatawi ijanu qee sasac qu madena, ‘Ija Jisas uqana malogom qee,’ ena eu uqanu ijaha Mei sao jobon bilina amegna madigen, ‘Dana i ijana qee,’ igen!” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jisas je haun maaden, “Age wawagana cain madowain, Jisas uqa mahana malol bilec igecnu hon owain. Ija malol bilec mahana ahu mecnu qee holom. Ija han cadec ehi nem. ");
INSERT INTO aey_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ge, ija dana cajaca qatanadecemin ‘mel oso memegna cad ibuldugian, odocob mel aid uqa anagna cad ibuldugian, odocob huhighuhigca ale cad biluwasan’ eunu hom. ");
INSERT INTO aey_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","‘Odocob dana uqana jona bilegina eundec age wawaga filfilca uqana cadca biluqagan,’” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Oso uqa memeg anagcanu ija wooltiti nalunula menafi eu ijana bilecnu ihocca qee. Oso uqa melahnuca ategnuca ija wooltiti nalug menafi eu ijana bilecnu ihocca qee. ");
INSERT INTO aey_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Oso uqana na babalec gahidu ija tooti cobocnu culinafi eu uqa ijana bilecnu ihocca qee. ");
INSERT INTO aey_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Oso uqa uqana cebac bilec hewigia odona eu uqa uqana cebac bilec felacudigian. Oso uqa ijana bilina eunu uqana cebac bilec felacudecebfi eu uqana cebac bilec ugian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jisas je haun maaden, “Dana oso uqa age ehadi uqaca bilecnu cudun culiadena eu uqa bilec cudun ija culitena. Oso uqa ija bilec cudun culitena eu Anut sulten eu bilec cudun culitona. ");
INSERT INTO aey_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Oso uqa je hahun madec dana oso uqa je hahun madec dana bilina eunu bilec cudun culitocobfi eu uqa je hahun madec dana ameg me oc eu ugian. Oso uqa dana ititom oso uqa dana ititom bilina eunu bilec cudun culitocobfi eu uqa dana ititom ameg me oc ha ugian. ");
INSERT INTO aey_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Oso uqa mel sim eundec oso uqa ijana malogom bilina eunu wa daec oso dih wetidocob jecebfi ija mele maadigina, uqa ameg me oc eu culecwe qee,” aden. ");
INSERT INTO aey_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas uqa malogom 12-pela je eu cunug maadi hedumei uqa caji nunui uqa jobonjobon dana cajaca iwalaadi Anutna me je maaden. ");
INSERT INTO aey_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wa Joadec Jon uqa gihacdoc jona bilen. Odimei uqa Krais odonnu je dah mimei uqana malogom suladeceb Jisasca lein. Uqa uqana malogom maaden, ");
INSERT INTO aey_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Age Jisasca limeig sisildoiga, ‘Hina i himec hocnu Anut sulhenfo, qee ege osonu amige meqanfo?’ doiga,” aden. Odimei suladeceb lein. ");
INSERT INTO aey_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Lecebil Jisas uqa Jonna sos jejenega hewi maaden, “Ceseli belimeig ceteh feginaca je dah meginaca Jon madoiga. ");
INSERT INTO aey_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Dana amaga galuc mec haun feciegina. Dana laleg mec haun cobogina. Dana lepraca dewenega cataniecca calena. Dana dahiniga cufa qoc haun je dah megina. Dana cal mec haun cebac megina. Oso uqa sawen dana me je qasali maadeceb age dah megina. ");
INSERT INTO aey_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","In oso uqa ijanu waug meleec qee felacudel eu Anut uqa eeldugian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Odocob Jon uqana malogom age ceseli belecebil Jisas uqa dana cegulec ben eu Jonnu maaden, “Age Jon wadauna uqaca belein saen euna eeta foqagannu belein? Age balac fufu heweceb gulaeeb foqagannu beleinfo? ");
INSERT INTO aey_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Age eetanu belein? Dana lotoc me bahicca taqen foqagannu beleinfo? Feiga, dana age lotoc me bahic tacegina age kingna jona bilegina. ");
INSERT INTO aey_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mateiga, age eetanu belein? Age Anutna je hahun madec dana oso foqagannu beleinfo? Ija mele maadigina, uqa je hahun madec dana qa uqa je hahun madec dana cunug wooladena. ");
INSERT INTO aey_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon uqanu Anutna jaqec je oso odi madena: ‘Anut madena, “Feiga, ijana sos suldocomin aqunihi nuigian. Uqa hinana jic saciadugian,” ena,’ Anutna jaqec je odi madena. ");
INSERT INTO aey_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ija mele maadigina, Wa Joadec Jon uqa dana mahana cunug wooladena. Euqa dana oso uqa nag bahic sao cul jobon bilina eu uqa Jon wooldona,” aden. ");
INSERT INTO aey_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Wa Joadec Jon me je qasali madec saennadec leceb qila dana hihibanagaca age sao cul jobon ocnu gagadic megina. Odimeig dana hihibanagaca age euna sundocobdocob limeig gagadic megina. ");
INSERT INTO aey_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ge, Mosesna loo jeca je hahun madec dana agena jeca bibili hu Jon uqana saenna Anutna je himec mamadi bilen. ");
INSERT INTO aey_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Age je eu ocnu gale adecebfi dah meiga. Anutna jaqec je madi, je hahun madec dana Ilaija uqa hugian, ena. Je eu Jonnu maden. ");
INSERT INTO aey_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Oso uqa dahigca je eu dah meiale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Euqa dana cajaca qila bilegina eu age adec? Age eetanu ihocihoc madigen? Age i ediwe. Age mel simsim maha gemona ududu bibileig cotogail utai maadegina: ");
INSERT INTO aey_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ege agenu cololo fuldoqonaqa age qee due dueelein. Ege cal mec due siluqunaqa age qada qee qajelein,’ adegina. ");
INSERT INTO aey_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ge, Jon uqa sabca wainca qee jejen hol qa age madein, ‘Uqa buga me qee hewen bilia!’ ein. ");
INSERT INTO aey_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Odocob Dana Melah uqa sabca wainca jejen hon qa age madein, ‘Dana i feiga! Uqa sab muhna jec dana. Uqa wain jeceb dalul qoc dana. Uqa takis cedec danaca silail danaca agena danah bilegina,’ age odi madein. Euqa dana age Anutna doc silecca toodu odogina eu age tutuc odogina eunu dana cajaca cunug age fimeig madein, ‘Anutna doc silecca eu ititom,’ ein,” aden. ");
INSERT INTO aey_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jobon leih euna Jisas uqa kobolkobol odoc mati odon qa dana cajaca age wawaga tului qee falicdol. Eunu saen euna Jisas uqa dana cajaca eu galac madimei ulauladec je maaden. ");
INSERT INTO aey_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Uqa maaden, “O Korasin, O Betsaida, odoc kobolkobolca agena calen eu odi Taia Saidonca caloubmi wele bahic dana ono age lotoc me qee tacimeig comisna bibili agedodoc dewenegana weti heheli biloub. Age agena silail hibemdogina ihacadecnu eu odi odoub! Eunu Korasin, age walocca! Betsaida ha, age walocca! ");
INSERT INTO aey_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ijaqa maadigina, Gesiladec Deel Benna Anut uqa Korasin Betsaidaca ameg me qee wadacadigian eu Taia Saidonca ameg me qee wadacadigian eu wooldoc hugian. ");
INSERT INTO aey_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Odocob Kapaneam agenu! Age Anut uqa sao jobon ohis ehadi tigian ec cisdoginafo? Qeeo, odoc kobolkobolca ija Kapaneam ono odom eu oso uqa Sodom ono odoubmiqa Sodom qila deel ina biloub. Eunu Anut uqa heladeceb oloqanihna noqagan! ");
INSERT INTO aey_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Euqa ija maadigina, Gesiladec Deel Benna Anut uqa Kapaneam ameg me qee wadacadigian eu Sodom ameg me qee wadacadigian eu wooldoc hugian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Saen euna Jisas je odi maden, “Mei, saoca mahaca alena Tibud, hina ceteh eu dana cisdoc silecca docca eundecnu jahunem. Dana cajaca age mel sim bileginawe bilegina eundec amagana je eu camas mem. Eunu ija hina hetaga higina. ");
INSERT INTO aey_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mele, Mei, hina hinana gale hec me bahic toodu odi odom. ");
INSERT INTO aey_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mei uqa ceteteh cunug ija ebenina men. Dana oso uqa Anut Melah qee du cuhadona. Euqa Memige Anut himec Anut Melahnu du cuhadona. Dana osoha Memige Anut qee du cuhadona. Anut Melah uqa himec Memige Anutnu du cuhadona. Odocob Anut Melah eu uqana gale docna dana oso Memige Anutna gug ihacdona euha Memige Anut du cuhadugian,” en. ");
INSERT INTO aey_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Age cunug cabi gisi cagocca culumen ben gahidu cobocca age ijaca hoigale, age jaen mudec oqagan. ");
INSERT INTO aey_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Feiga, ijana sol eu jocosaigca, ijana sol mec eu hetec. Ija gemani jocosaigca, ija wawi lal qocca bahic. Eunu age ijana cisdoc umeig ijana je bisalu bileigale. Age ijaca gami sol hewi gahidumeb ija ihiconi oigale. Odi oodoig age wawagana jaen mudec gulucdoqagan,” en. ");
INSERT INTO aey_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Juda agena cuha deel osona Jisas uqana malogom gami cobimeig wit cabi osoosona gemogemo li beli coboin. Malogom age wen adeceb wit aig wal mec tawen qu u ehi li aig jein. ");
INSERT INTO aey_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Oodogin Farisi leih age eu fimeig Jisas madoin, “Faga, hinana malogom age ceteh oso egena cuha deelna egena loo je cahacgena eu odogina,” doin. ");
INSERT INTO aey_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Odocobil Jisas jejenega hewi maaden, “Age Dewid odonnu je oso qee sanijeleinfo? Saen uqaca uqana eundec age gami coboinca age wen ben adeceb ");
INSERT INTO aey_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","uqa Anutna jo dunuh limei Anutnu ihanec bred oso u jimei uqana dana adeceb jein. Eu odonqa uqaca age uqaca coboin age ihanec bred jecnu Mosesna loo je eu cahacaden. Mosesna loo je madi, bred eu nawel tawec ihanec dana himec eu jecnu cois, ena. ");
INSERT INTO aey_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Qeefi, age je osoha Mosesna loo jena nijia eu qee sanijeleinfo? Nawel tawec ihanec dana age tempelna cabi ogina eu age cuha deelna cabi oqagan ec je nijia. Age cuha deelnu loo je tefacdogina qa age Anut amegna qee cahuldogina. ");
INSERT INTO aey_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ija maadigina, ceteh eu tempel wooldona eu ene bilia. ");
INSERT INTO aey_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Euqa age je i Anutna jaqec jena nijia: ‘Ija age gauc ihantecnu qee gale tena. Ija age dananu wawaga qocca biluqagannu gale tena,’ ec je nijia eu uqana gug du cuhadoubmi age dana qee cahuldogina eu age silail dana ec qee madoub. ");
INSERT INTO aey_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ge, Dana Melah uqa Tibud, uqa cuha deel uqana ilo bilina,” aden. ");
INSERT INTO aey_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas uqa cudun eu culimei jobon osona nuimei Juda agena cuha jona len. ");
INSERT INTO aey_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Odocob dana oso uqa eben gatoc men eu ono bilen. Dana leih age Jisas dewegna je um qudecnu gale aden eunu age sisildoin, “Egena cuha deelna dana hagca me madecnu loo je eu cois ec madenafo?” doin. ");
INSERT INTO aey_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Odocob uqa jejenega hewi maaden, “Age dana oso uqana sipsip maha qahec helona dunuh toneceb cuha deel i edina sipsip eu helonadec didocobil qee cali beiaunfo? ");
INSERT INTO aey_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Euqa dana uqana fajec eu sipsip uqana fajec wooldoc bilia. Eunu ege cuha deelna me mudecnu eu cois,” aden. ");
INSERT INTO aey_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Odimei uqa dana eben gatoc men eu madon, “Hina eben heli huleldoga,” don. Odocob dana eben heli huleldocob me men. Eu uqa eben oso cinigwe calen. ");
INSERT INTO aey_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Euqa Farisi age cuculdi nuimeig Jisas qoqagannu jic wawali je togodoin. ");
INSERT INTO aey_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas uqa Farisi eeta odudecnu gale aden ec dumei cudun eu cuculi nuen. Dana cajaca mati toodocobil uqa cunug me maden. ");
INSERT INTO aey_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Odimei uqa dana cajaca age uqana gug camas mowainnu cahacaden. ");
INSERT INTO aey_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Uqa je hahun madec dana, Aisaia, uqana je ihoc ligiannu odi odon. Uqana je wele odi maden: ");
INSERT INTO aey_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Dana i ijana cabi dana. Ija uqa nesili ehudem. Ija nalug migina. Ija wawi uqanu gale ben dona. Ija ijana Kis uqa mitugen. Uqa Juda dana caja qee eundec ititom kobolnu je qasali maadigian. ");
INSERT INTO aey_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Fee dadanec je qee madeiaun, utai biah anag qee meiaun. Uqa jic cunugna co suli u mamadeb dana cajaca age dah qee mowain. ");
INSERT INTO aey_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dana cajaca age balac gagadicca qee uqa qahigiannu cinigwe eu uqa cunug qee qaheiaun. Dana cajaca age gowoc qee ileti cuhadona cinigwe uqa qee cafuladeceb qee meiaun. Uqa odocob ititom kobol mele bahic wooladi biligiannu uqa cabi u biligian. ");
INSERT INTO aey_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Juda dana caja qee eundec age uqa ijannu wawaga meleeceb uqa cahahaadigiannu sumudi biluqagan,” en. ");
INSERT INTO aey_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Age dana oso buga me qee hewen eu Jisasca ehudi ahoin. Dana eu ameg galuc men, co ha cufa qon. Jisas uqa dana eu me mudeceb je madecnuca ceteteh fecnuca ihoc len. ");
INSERT INTO aey_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Odocob dana cajaca cunug filiciti madein, “Dana i Dewid Melah qeefo?” ein. ");
INSERT INTO aey_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Euqa Farisi age dana odi mamadegin dumeig age Jisasnu madein, “Dana eu uqa Bielsebul, buga me qee agena ben, uqana gagadic odocna dih buga me qee dana deweneganadec ititacadena,” ein. ");
INSERT INTO aey_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas uqa age wawagana mamadegina dumei maaden, “Hatu osolna mam cadecebil qatanec bilecebfi age gaus danoqagan. Jobon oso mam cadecebilfi bilecwe qee. Sihul oso mam cadecebilfi euha age bilecwe qee. ");
INSERT INTO aey_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Odocob Seten uqana eundec ititacadoubmi uqana am qatanec biloub, eunu uqana cul adi biloub? ");
INSERT INTO aey_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Age ijanu madi, uqa buga me qee Bielsebulna gagadic odocna dana deweneganadec ititacadena, egina, eu melefi agena malogom euha inna gagadic odocna buga me qee dana deweneganadec ititacadegina? Eunu agena malogom agena odoc eu Farisi agena je cahuldoc eunu ihacadigian. ");
INSERT INTO aey_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ijaqa Anutna Kis cesulteceb ija Anutna gagadic odocna buga me qee dana deweneganadec ititacadiginafi Anutna cul ageca wele hoia,” aden. ");
INSERT INTO aey_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Qeefi, in oso dana gagadicca uqana jona li uqana ud cawaldecnu donafo? Oso uqa casac li dana eu eben jaihca libimei uqana ud cawaldecnu dona,” aden. ");
INSERT INTO aey_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Oso ijana danah qee eu ija cad mitina. Oso ija cesultimei dana cajaca Tibud cemenug qee hauadena eu dana cajaca bilisaadena,” aden. ");
INSERT INTO aey_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Eunu ija maadigina, silail oso cunug Anut lelandoc oso cunugca Anut uqa dana eu agena silail cagasiadigian. Euqa Kis Gun lelandoc eu dana uqana silail cagasitocnu qee nijel. ");
INSERT INTO aey_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Odocob dana oso Dana Melahnu je me qee oso madecebfi Anut uqa dana eu uqana silail cagasitugian. Euqa oso Kis Gunnu je me qee madenafi Anut uqa silail eu saen qilaca saen bilec catanecca qee cagasitoiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jisas je haun maaden, “Na eu gug mefi eu aig me qona. Euqa na eu gug me qeefi eu aig me qee qona. Dana age casac aig fimeig na gug eu mefo, me qeefo ec doqagan. ");
INSERT INTO aey_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Age man sononec uqana nag! Age me qee sihuldec! Age adi je me madoqagan? Ceteh waugna am bec nijia eu cona cali hu camas mena. ");
INSERT INTO aey_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dana me uqa waug dunuh cisdoc me am bec nijinanu eunadec cisdoc me camas mena. Dana me qee uqa waug dunuh cisdoc me qee am bec nijinanu eunadec cisdoc me qee camas mena,” aden. ");
INSERT INTO aey_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","“Ijaqa odi maadigina, hinana je madec mefi Anut uqa hinana je menu hina ititom dana ec madigian. Euqa hinana je madec me qeefi hinana je me qeenu Anut uqa hina dana me qee ec madigian. Eunu Anut uqa Gesiladec Deel Benna dana cajaca age je me qee madegina eundec age eetanu je ilag madein? ec sisiladigian. Odocob age je me qeenu ameg me qee oqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Saen euna loo je iwaladecca Farisica leih age Jisas madoin, “Iwalgec, ege hina Anutna cabi ogonana gaga eunu kobolkobol oso oodom faga gena,” doin. ");
INSERT INTO aey_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","40","Odocobil Jisas jejenega hewi maaden, “Anut hibemdoc sihul i qisol megina age gaga oso fecnu walegina. Je hahun madec dana, Jona, uqa cahineg cijedca witic cijedca dool ben macasnadec waugna nijenwe Dana Melah cahineg cijedca witic cijedca maha dunuh noc biligian. Eunu age gaga abes oso qee fowain. Age Jona uqana gaga eu himec foqagan ");
INSERT INTO aey_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Weleca Niniwa dana age Jona me je qasali maadeceb agena silailnu tului falicdoin. Ijaqa maadigina, oso eu Jona wooldoc ene bilia! Eunu Niniwa dana age isi Gesiladec Benna dana sihul qila i ene bilegina eundec gami cajimeig age dana i bilegina deweneganu geladec je madoqagan. ");
INSERT INTO aey_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Weleca Kwin sautdec uqa Solomonna cisdoc silecca je dugen imei hatu onoca bahic cocobi niniji hu je dah men. Ijaqa maadigina, oso eu Solomon wooldoc ene bilia! Eunu Kwin sautdec uqa Gesiladec Benna dana qila i ene bilegina eundec gami cajimeig uqa dana i bilegina deweneganu geladec je madigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jisas je haun maaden, “Saen buga me qee dana dewegnadec cali hona uqa jaen mudec cudun wawali hatu galalecna cobona. Euqa uqa cudun oso qee gulucdol. ");
INSERT INTO aey_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Uqa madena, ‘Ijana jo cuculi hom euna ceseli nuigen,’ ena. Uqa ceseli humei jo eu oso qee bilec, gegehinca qee, cunug eeldoc ninijen fena. ");
INSERT INTO aey_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Odimei uqa haun ceseli nuimei buga me qee 7-pela cedi ahocob uqa gami bilegina. Buga me qee 7-pela eu agena odoc me qee uqana odoc me qee eu wooldoc. Eunu dana eu uqana bilec qila euna me qee bahic mena. Uqana bilec weledec wooldona. Dana cajaca me qee qila bilegina eu ageha odi caloqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","47","Jisas uqa dana cajaca je maadi bibilen uqa anag waliagulca maha gumu tatawi ege Jisas je madoqan ein. Odocobil dana oso Jisas madon, “Hina anin walinelca ono taweiga age ege Jisas je madoqan egina,” don. ");
INSERT INTO aey_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Odocob Jisas dana eu jejeg hewi madon, “Ija au in? Ija waliel an?” don. ");
INSERT INTO aey_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","50","Uqa odi madumei ebenna uqa malogom ihohadimei maaden, “Feiga, oso uqa Mei sao jobon bilia, uqa co toodu odona eu uqa ija walica, ija cebinamica, ija auca. Eunu ija au walielca ihen!” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Deel euna dih Jisas uqana jonadec li Galili wa cagocna numei lanna bilen. ");
INSERT INTO aey_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ono bibilen dana cajaca mati bahic uqaca hu talildu cegulein. Eunu uqa wag oso tobi bibilen dana cajaca cunug age lanna tawein. ");
INSERT INTO aey_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tatawegin uqa je filfil galolo jena maadi maaden, “Dana oso uqana cabina wit aig helecnu nuen,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“Uqa aig hehelen aig osooso jic cobocna tonen. Odocob man fululec eu age humeig cedi ji hedoin. ");
INSERT INTO aey_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aig osooso maha eu meen baibaca maha meca qee euna tonen. Maha eu dunuh qee nol eunu aig eu mahuc qala qahimei nag wasen. ");
INSERT INTO aey_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Odocob cam gagadic tatawen eu cijaden. Odocob bebeig dunuh qee nol eunu qala jajawalen. ");
INSERT INTO aey_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aig osooso dud geuna tonen. Dud eu mahuc caji ben mimeig ceteh cilehdocobil mahulimei qee men. ");
INSERT INTO aey_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aig osooso eu mulu mahana tonen. Odocob qala qahimei ben mi aig qon. Aig oso qoc 100 ihoc len, osooso 60 ihoc len, osooso 30 ihoc len. ");
INSERT INTO aey_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Oso dahigca je eu dah meiale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Odocob malogom age Jisasca limeig sisildu madoin, “Hina eetanu galolo jena je maadagana?” doin. ");
INSERT INTO aey_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","12","Odocob uqa malogom maaden, “Oso uqa docca nijia eu Anut haun uteceb uqana doc meca migian. Euqa oso uqa docca qee eu Anut uqa uqana doc nag nijia eu cawaldugian. Eunu Anut culadeceb age sao cul jobonnu ceteteh jahunec docnu nijia. Euqa dana i age eu docnu qee nijel. ");
INSERT INTO aey_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Dana cajaca amagana feginaqa qee fegina, odimeig age dahinigana dah meginaqa qee dah megina, odimeig age qee fogo adena eunu ija galolo jena je maadigina. ");
INSERT INTO aey_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Agena odocna Aisaia je hahun maden eu ihoc lena. Uqana je eu wele odi maden: ‘Dana cajaca i age ilohonoga cisdocnu eu cal mec bahic. Age dahiniga cufa qoin. Odocob age amaga amusein. Eunu age dah moqagan qa qee dowain. Age foqagan qa wawaga qee fogo doiaun. Qeefami age amagana fimeig fogo adoub, age dahinigana dah mimeig doub, age wawaga fogo doub. Odocob age ijaca falicdocobil me madoum,’ en,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Euqa age amaga Anutna ceteh fegina, age dahiniga Anutna je dah megina. Eunu age eeladecca bilegina. ");
INSERT INTO aey_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ija mele maadigina, je hahun madec danaca tutuc coboc eundecca wele bilein mati age, age qila fegina eu fecnu wawaga ben hoolen euqa age ceteh eu qee felein. Dana eundec age, age qila dah megina eu dah mecnu wawaga hoolen euqa age je eu qee dah melein,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jisas je haun maaden, “Ija age wit aig helec dananu galolo je saadecemin dah meigale. ");
INSERT INTO aey_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oso uqa sao cul jobonnu je dah meceb dahig qee fogo dona dana eu uqa wit aig jicna tonenwe. Seten eu qisol mec dana bahic, uqa humei je dana waugna tonen eu cawaldona. ");
INSERT INTO aey_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Aig maha meen baibacana tonennu madiga eu odiwe dana oso uqa me je dah mimei waug ceelecca je eu mahuc ona, ");
INSERT INTO aey_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","euqa uqadodoc bebeigca qee. Uqa saen nag himec culumen gahidona. Anutna jenu aqati tootoodocca temdocca uqaca hocob mahuc waug meleec tonena. ");
INSERT INTO aey_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aig dud geuna tonennu madiga eu odiwe dana oso uqa me je dona, euqa mahana bilecnu jaen qocca, maha cehewan ocnu waug madec eu toodu odocca eu Anutna je cilehdocob aig qee qona. ");
INSERT INTO aey_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aig mulu mahana tonennu madiga eu odiwe dana oso uqa Anutna je dumei waug fogo dona. Uqa mele bahic ben mi aig qona. Dana eundec leih age aig 100 ihoc legina, odocob leih age aig 60 ihoc legina, odocob leih age aig 30 ihoc legina eu camas mena,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas uqa galolo je haun oso maaden, “Sao cul jobon eu odi. Dana oso uqana cabina wit aig me dih helen. ");
INSERT INTO aey_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Euqa dana us ninijegin uqana cad limei cabi euna wit gemo huhel me qee aig qelimei nuen. ");
INSERT INTO aey_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wit wasi hanocob huhel me qeeha camas men. ");
INSERT INTO aey_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Odocob cabi dana age li cabi gug eu madoin, ‘O Ben, hina hinana cabina aig qee nesilec qelemfo? Huhel me qee eu anadec?’ doin,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Odocobil maaden, ‘Eu cad uqa odon,’ aden. Odocob madoin, ‘Hina madecemfi ege nui huhel me qee casili sagoqa?’ doin. ");
INSERT INTO aey_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Odocobil maaden, ‘Qeeo! Huhel witca eu fecnu ihocihoc eunu age huhel cacasili li witha casiluwainnu cain odowain! ");
INSERT INTO aey_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Culecebil osoben niniji wal meia. Wal mi hedoc saen euna qetegina eundec maadigen, “Age casac huhel me qee qeti sagoiga eu manoqagannu, odimeig wit qeti sagumeig ijana jo bisna ehi ti haudoiga,” adigen,’ aden,” Jisas je odi maaden. ");
INSERT INTO aey_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas uqa galolo je haun oso maaden, “Sao cul jobon eu mastet aig cinigwe eu dana oso umei uqana cabina cehen. ");
INSERT INTO aey_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet aig eu nag bahic. Eu aig cunug wooladec. Euqa uqa wasi ben meceb uqa cabi ceteh wooladec gulgulec caji tawena. Man fululec age humeig uqana batacnana agena teic megina!” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas uqa galolo je haun oso maaden, “Sao cul jobon eu jis cinigwe caja oso umei plaua dram benna euca gabandumei ibuldocob uqadodoc iben,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas uqa je cunug eu galolo jena dih dana cajaca maaden. Uqa je oso galolo jeca qee euna qee maadel. ");
INSERT INTO aey_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Uqa je hahun madec dana oso uqana jaqec je ihoc ligiannu odi odon. Jaqec je eu wele odi maden: “Ija galolo je conina maadigen. Ija ceteh gug qoc saennadec jahuni leceb qila nijia eunu je saadigen,” en. ");
INSERT INTO aey_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas uqa dana cajaca cuculadi jona len. Odocob uqana malogom age Jisasca humeig madoin, “Hina huhel me qee cabina wasennu galolo je eu silignu sildigaga,” doin. ");
INSERT INTO aey_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Odocobil Jisas jejenega hewi maaden, “Dana aig me helena eu Dana Melah. ");
INSERT INTO aey_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Cabi eu mahamaha. Aig me eu dana cajaca age sao cul jobon bilegina. Huhel me qee eu Setenna dana cajaca. ");
INSERT INTO aey_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Cad uqa huhel aig qelen eu Seten. Wal mi hedoc saen eu mahamaha bili cit qoc saen. Dana qeti sagogina eu ensel. ");
INSERT INTO aey_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Age huhel meel u casili haudu jana maneginawe mahamaha bili cit qoc saenna odi bahic nijigian. ");
INSERT INTO aey_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Dana Melah uqa uqana ensel suladeceb ni uqana culna cunug age dana cajaca odadecebil age silail mimi coboginaca, dana cajaca cunug age qisol meginaca cedi ehi li ");
INSERT INTO aey_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ja amegna heladecebil noqagan. Euna age qada qaqaji maimaga kicodudu biluqagan. ");
INSERT INTO aey_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Odocobil dana cajaca Anut uqa dana cajaca ititom ec madena eu age Memegana culna cam odi fulacdoc biluqagan. Oso dahigca je eu dah meiale!” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jisas uqa galolo je haun oso maaden, “Sao cul jobon eu odi. Cabi osona dana oso cobimei euna maha dunuh gold meen jahuldoc oso ninijen gulucdon. Uqa eu mahana jahuldumei ceelimei li uqana ceteteh cunug cedimei meen qaignu idadumei li cabi eu faji on,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jisas uqa galolo je haun oso maaden, “Sao cul jobon eu odi. Idadoc dana oso uqa gilolo meen qaig benna fajecnu gale docob eundec wawali cobon. ");
INSERT INTO aey_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Uqa gilolo oso meen qaig ben bahic wooldoc gulucdumei uqa uqana ceteteh cunug idadumei meen qaig eu umei li gilolo me bahic eu faji on,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisas uqa galolo je haun oso maaden, “Sao cul jobon eu cimec ben cinigwe age eu cul dool dewenega filfil cedoqagannu macasna helegina. ");
INSERT INTO aey_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cimec ben eu dool ihoc lecebil dana cecelimeig lanna megina. Odimeig age bibili dool me galelna tacegina qa me qee eundec helegina. ");
INSERT INTO aey_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Odiwe mahamaha bili cit qoc saenna odi odoqagan. Anutna ensel age belimeig dana cajaca qisol mec eu dana cajaca ititom gemonadec cedimeig ");
INSERT INTO aey_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","li ja amegna heladecebil noqagan. Euna age qada qaqaji maimaga kicodudu biluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisas je i cunug maadi hedumei sisiladi maaden, “Age je i dah meiga eu cunug dahiniga fogo doiafo?” aden. Odocob madoin, “Ese, ege dahinige fogo doia,” doin. ");
INSERT INTO aey_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Odocobil Jisas maaden, “Jo gug uqa jo bisnadec ceteh weledecca haunca cedi ahumei camas menawe eu odi loo jenu iwaladec oso uqa sao cul jobonnu iwaldocobil don,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas uqa galolo je eu maadi hedumei cudun eu culimei nuen. ");
INSERT INTO aey_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nuimei uqana jobon gug calen. Odimei uqa agena cuha jona limei dana je iwaladeceb je eu wawaga qon. Age tumatumai madein, “Uqa cisdoc silecca eu in iwaldocob don? Kobolkobol odona eu anadec on? ");
INSERT INTO aey_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ege doqona, uqa jo cehecnu memei uqana mel. Uqa anag ijan eu Maria. Jemsca, Josefca, Saimonca, Judasca age uqa waliagul. ");
INSERT INTO aey_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Uqa cebinagul age ene ege gemona bilegina. Dana i uqa ceteh eu cunug anadec on?” ein. ");
INSERT INTO aey_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Age uqanu wawaga me qee meceb cecewudi bilein. Euqa Jisas uqa maaden, “Je hahun madec dana oso uqana gug jobon qee euna age uqana je dumeig uqa saolal mudecnu nijia. Euqa uqana hatuna, uqana eundec age uqa cewudegina,” aden. ");
INSERT INTO aey_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ono Nasaret age wawaga meleecca qeenu ono kobolkobol meca mati qee odol. Uqa nag himec odon. ");
INSERT INTO aey_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Saen euna gabman dana ben Herod Galili hatu cunug cofdoc uqa Jisasna odocnu hutan don. ");
INSERT INTO aey_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Dumei uqana cabi dana eundec maaden, “Dana i uqa Wa Joadec Jon. Uqa cal mecnadec ceseli cajen eunu kobolkobol odocnu gagadic odocca odona,” aden. ");
INSERT INTO aey_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ge, wele Herod uqa waliag Filip aideg, Herodias, on. Odocob Jon uqa li Herod madon, “Hina walien aideg om eu tutuc qee,” don. Eunu Herod uqana han dana suladeceb age li Jon hewi libimeig gihacdoc jona mudein. ");
INSERT INTO aey_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod uqa Jon qocob cal mecnu waug nijen euqa dana cajaca age Jonnu madi, uqa je hahun madec dana, einnu uqa dana cajacanu cucuien. ");
INSERT INTO aey_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod uqa anag basen deelnu dana mati bahic cegulein. Age ceeli bibili sab jejegin Herodias ateg, eu dana osonadec, uqa hu dana amagana due duen. Oodon eu Herod gale docob ");
INSERT INTO aey_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","uqa je cagoc madon, “Anut amegna mahigina, cel cetehnu matecemfi ihigen,” don. ");
INSERT INTO aey_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Odocob anag uqa ateg madocob toodu uqa Herod madon, “Hina qila bahic Wa Joadec Jon ilo bohna mimeg ahutaga!” don. ");
INSERT INTO aey_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mel aid odi madocob Herod uqa waloc don. Euqa Anut amegna je cagoc madigina cetehnu matecem ihigen don eunuca, dana hoin bibili dah mein eunuca cisdumei ");
INSERT INTO aey_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","uqa han dana suladeceb age gihacdoc jona limeig Jon be cagoin. ");
INSERT INTO aey_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Cagumeig ahu bohna mi mel aid utecebil mel aid uqa anag ehi liton. ");
INSERT INTO aey_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Odocob Jonna malogom age humeig Jon deweg loton ehi li heel cisein. Odimeig age li je cunug Jisas sadoin. ");
INSERT INTO aey_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas uqa je eu dumei jobon eu culimei wagna tobimei wa gad cagoc leti uqa cuhanuc cudun ono isec nuen. Euqa dana cajaca jobonjobon bilegina eu age Jisas wa gad cagoc leti nuia ec dumeig age toodu jaimagana belein. ");
INSERT INTO aey_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Odimei uqa lanna tonimei dana cajaca am ben tatawegin feciaden. Uqa agenu waug qocob agena hagca me maden. ");
INSERT INTO aey_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Witicna uqana malogom uqaca humeig madoin, “Aben i filec cagocna bahic, cam wele noia tu mena. Eunu dana cajaca am i age jobonnana belimeig agedodoc sab jecnu fajoqagannu suladaga,” doin. ");
INSERT INTO aey_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Euqa Jisas malogom maaden, “Eetanu age beloqagan? Age dana cajaca sab adeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Odocob age jejeg hewi madoin, “Ege bred 5-pela cul dool lecisca himec hewoqa,” doin. ");
INSERT INTO aey_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Odocobil Jisas maaden, “Bred cul doolca cedimeig ahuteiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Odimei Jisas uqa dana cajaca maadeceb age gigina bilein. Odimei Jisas bred 5-pela cul dool lecisca cedi hewimei sao jobon tatiimei Anut hetaga doc je madon. Odimei bred fenifeni uqana malogom adeceb dana cajaca siwiadecebil jein. ");
INSERT INTO aey_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Age cunug jecebil ihoc leceb malogom age sab jecefanaga eundec galel 12-pela tacecebil am ben. ");
INSERT INTO aey_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dana sab jein eu 5,000, cajaca melca qee sanijelein. ");
INSERT INTO aey_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Odocob Jisas uqana malogom cesusadeceb age wagna tobimeig age aqunitu Galili wa gad cagoc naha isec beloqagannu belein. Bebelegin uqa dana caja amam qaqacitegin cofaden. ");
INSERT INTO aey_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Uqa dana cajaca qaciti hedocobil uqa cuhanuc Anut inondudu bilecnu aluh guhidocna ten. Witic memen uqa ono cuhanuc bilen. ");
INSERT INTO aey_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Euqa saen euna malogom age wagna bebeleig age lan onoca bahic basai coboin. Odocob fufu ben olanagana isec honnu macas ben bahic caji qahen. ");
INSERT INTO aey_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Odocob walag danigia oodon Jisas uqa wa tatacan cocobi ageca len. ");
INSERT INTO aey_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Euqa malogom age uqa macasna cocobon fimeig qeleli filiciti madein, “Dol oso cobona,” imeig cucuii euein. ");
INSERT INTO aey_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Odi odocobil Jisas mahuc maaden, “Ija ihen. Age cain cucuiuwain! Age wawaga toogdoiale!” aden. ");
INSERT INTO aey_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita je eu dumei uqa Jisas jejeg hewi madon, “Tibud, hinafi matecem ija toni wa tatacan hinaca ligen,” don. ");
INSERT INTO aey_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Odocob Jisas madon, “Cois hogale,” don. Odocob Pita uqa wagnadec tonimei wa tatacan cocobi Jisasca ligian odon. ");
INSERT INTO aey_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Uqaqa fufu ben wawasen fimei cucuiimei gotoigia odon. Odi oodi eui Jisas madon, “Tibud, cahahatagale,” don. ");
INSERT INTO aey_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Odocob Jisas uqa mahuc eben heli Pita hewimei madon, “Hina dana waug meleec nagca. Eetanu wawin lecisca meia?” don. ");
INSERT INTO aey_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ale lecis wagna tobi tecebil bibilegin fufu tilien. ");
INSERT INTO aey_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dana age wagna bibileig Jisas olana gob cecehi uqanu cuha fimeig madoin, “Hina mele Anut Melah,” doin. ");
INSERT INTO aey_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Age wa gad cagoc leti hu Genesaret hatuna hoin. ");
INSERT INTO aey_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Age wag tobocobil dana onodec age Jisas wele fein eunu doin. Odimeig age hatu cunugna je suldocobil age dana caja hagca cunug ehadimeig Jisasca ahoin. ");
INSERT INTO aey_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Odimeig agena hag me madigiannu ninidoin. Age uqana lotoc bibig himec qududocnu ninidoin. Odocob cunug age uqana lotoc qududoin eu me mein. ");
INSERT INTO aey_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Saen euna Farisica loo je iwaladec leihca Jerusalemdec Jisasca humeig sisildu madoin, ");
INSERT INTO aey_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Hinana malogom age ebenega qee wasacudec sab jegina. Eunu eetanu ege jajanigeil loo je igein eu tefacdogina?” doin. ");
INSERT INTO aey_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Odocobil Jisas jejenega hewi maaden, “Age eetanu jajanagail agena loo je saolal mumudi Anutna loo je gagadicca eu tefacdogina? ");
INSERT INTO aey_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ge, Anut je gatiti maden: ‘Hina memen aninca lalan malagale,’ en. ‘Oso memegfo, anagfo geuldecnu je madecebfi uqa cal migian,’ en. ");
INSERT INTO aey_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ageqa madegina, ‘Oso uqa memegfo, anagfo cesuldocnu meen qaig nijecebfi uqa maalena, “Ija cesulalecnu ceteh nijen eu Anut utigennu abes mem,” alena,’ egina. ");
INSERT INTO aey_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Odocob dana eu uqa memeg lalan mudecnu qee nijel. Age eu odi madecna agena loo je saolal mumudi Anutna loo je cilehdudu tefacdogina,” aden. ");
INSERT INTO aey_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Me hihili coboc age! Je hahun madec dana, Aisaia, uqa agenu je tutuc bahic wele madi maden: ");
INSERT INTO aey_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Dana cajaca i age conogana binani sulegina age wawagaqa eu qisactec bilina. ");
INSERT INTO aey_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Eu age dana agena loo je iwalaadegina eu Anutna loo je, egina. Eunu age ijanu gauc cuha fegina,’ en,” aden. ");
INSERT INTO aey_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Odimei Jisas uqa dana cajaca utaadeceb hocobil maaden, “Je i dah mimeig du cuhadoigale. ");
INSERT INTO aey_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ceteh cona lena eu dana gegehin qee mudina. Ceteh conadec cali hona eu dana gegehin mudina,” aden. ");
INSERT INTO aey_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Odocob malogom age Jisasca li madoin, “Hina Farisi je maadecem dumeig age hinana jenu gemanaga ben eu dogonafo?” doin. ");
INSERT INTO aey_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Odi madocobil Jisas jejenega hewi maaden, “Na cunug ija Mei sao jobon bilia uqa qee cehel eu age caji loqagan. ");
INSERT INTO aey_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Age dana eundec culadeigale. Farisi age amaga galuc mec, age cotogail ha amaga galuc mec iwaladi ehadi cobogina. Dana ameg galuc mec eu cotig ameg galuc mec iwaldu ehudi cobocobfi ale lecis odi helona toni aqaligian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Euqa Pita Jisas madudu madon, “Galolo je maadem eu sildigagale,” don. ");
INSERT INTO aey_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","20","Odocob Jisas maaden, “Ageha wawaga qee fogo dol eu adi? Dana waugnadec cisdoc qisol mec cali hona. Dana qocca, dana osona caja occa, wal kobol odocca, heje occa, um qoc madecca, lelanadecca eu dana waugnadec cali hona. Ceteh eu dana gegehin mudina. Euqa ebenega qee wasacudec sab jec euna dana qee gegehin mudina. Eunu ceteh cunug cona lena eu bigna nocob big ititacdocob bahu helegina eu qee feginafo? Euqa conadec cali hona eu waugnadec cali beceb eu dana gegehin mudina,” aden. ");
INSERT INTO aey_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas uqa cudun eu culimei li Taia Saidonca alena hatuna nui bilen. ");
INSERT INTO aey_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ono Kenan caja oso hatu eunadec hu Jisas utadu madon, “O Tibud, Dewid Melah, hina ijanu walol heiale. Buga me qee eu ija ateni hewen me qee odudina,” don. ");
INSERT INTO aey_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Odonqa Jisas uqa jejeg qee hewel. Uqa je oso qee madol. Odocob malogom age Jisasca li ninidudu madoin, “Caja uqa ege tootoogigi utaena. Eunu madocom cuculgi nuiale,” doin. ");
INSERT INTO aey_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Odi madocobil Jisas maaden, “Isrel sihul sipsip fadalec cobogina cesuladecnu eunu himec Anut cabi itimei sulteceb hom,” aden. ");
INSERT INTO aey_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Euqa caja uqa hu Jisas amegna gob cehi uqanu cuha fimei ninidudu madon, “O Tibud, cesultagale!” don. ");
INSERT INTO aey_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Odocob Jisas uqa caja jejeg hewi madon, “Mel agena sab cawaladi qa joqagannu helec eu cois qee,” don. ");
INSERT INTO aey_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Odocob caja madon, “Mele Tibud, euqa qa asagul sab jejen jecefan uqana cabalnadec golodocob qa age bisalu hu cedi jegina eu odi qeefo?” don. ");
INSERT INTO aey_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Caja odi madocob Jisas madon, “O caja, hina wawin meleec eu caunca bahic! Hina madagana eu odihia,” don. Odocob caja uqa ateg saen euna bahic hag medon. ");
INSERT INTO aey_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas onodec Galili wa gad cagocna isec humei uqa aluh osona timei ono bilen. ");
INSERT INTO aey_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bibilen dana cajaca mati bahic uqaca hoin. Ageha dana hagca mati bahic cedadi ahoin. Age dewenega laleg mecca, tefulunuga cogogecca, amaga galuc mecca, conoga cufa qocca, dana hag filfilca eu ehi li Jisas jaihna madecebil uqa cunug me maden. ");
INSERT INTO aey_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Dana age conoga cufa qoc bilein eu je mamadegin, tefulunuga cogogec coboin eu me madeceb bibilegin, laleg mec nijein age caji cocobogin, amaga galuc mec bilein age mecieegin feciadein. Dana cajaca age ceteh eu fimeig tumatumaein. Odimeig age Isrel agena Anut binan sulein. ");
INSERT INTO aey_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas uqana malogom utaadeceb uqaca hocobil maaden, “Dana cajaca i age qila deel cijed ija gami biluquna age sab jecnuca qee. Eunu ija agenu walol tena. Ija age sab qee adec gauc ceseli beleiga adecnu culumen tena, age jicna wenene aqeceb toni aqeiaundainnu madigina,” aden. ");
INSERT INTO aey_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Odocob malogom age Jisas jejeg hewi madoin, “Ege ene wadauna biluqa, dana cajaca mati bahic sab adecnu bred anadec oqan?” doin. ");
INSERT INTO aey_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Odocobil Jisas sisiladi maaden, “Age bred ganic nijia?” aden. Odocob madoin, “Bred 7-pela, cul dool nagnag euha osooso nijeiga,” doin. ");
INSERT INTO aey_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Odocobil uqa dana cajaca maadeceb age mahana bilein. ");
INSERT INTO aey_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bibilegin uqa bred 7-pela cedimei cul doolha cedimei Anut hetaga dumei fenifeni malogom aden. Odocob malogom age ehi li dana cajaca siwiadecebil jein. ");
INSERT INTO aey_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dana cajaca cunug jecebil biniga hon. Odocob age sab jecefanaga golodoin eu mahanadec cedimeig galel 7-pela tacecebil ihoc len. ");
INSERT INTO aey_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dana sab jein eu 4,000, cajaca melca qee sanijelein. ");
INSERT INTO aey_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Odocobil Jisas uqa dana cajaca maadeceb qacitein. Uqadodoc wagna tobimei nui Magadan agena hatuna li bilen. ");
INSERT INTO aey_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Saen euna Farisi Sadjusica age Jisasca humeig ege uqa temdu feqan imeig cesusdudu madoin, “Ege hina Anutna cabi ogonana gaga eunu kobolkobol oso oodom ihacgecem foqale,” doin. ");
INSERT INTO aey_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Odocobil Jisas jejenega hewi maaden, “Wesuna age sao mecidudu madegina, ‘Sao galawac cijina, eunu uqadec cam me tawigian,’ egina. ");
INSERT INTO aey_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Qasilna sao mecidudu madegina, ‘Sao gol teia waha guhudona, eunu jugu qocob qila wa hugian,’ egina. Sao madena eu age dogina. Euqa saen odocnu madena eunu gaga age qee dogina. ");
INSERT INTO aey_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Anut hibemdoc sihul i qisol megina age gaga oso fecnu walegina. Euqa age gaga abes oso qee fowain. Age gaga osol dih foqagan, eu je hahun madec dana, Jona, uqana gaga eu himec foqagan,” aden. Odi maadimei cuculadi nuen. ");
INSERT INTO aey_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas uqa malogom gami Galili wa gad cagoc ono isec li bilein. Deel euna malogom age beloqaga bili bred tacecnu dahiniga celen. ");
INSERT INTO aey_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ono bibilegin Jisas uqa malogom galolo je madi maaden, “Dah meiga, age Farisi Sadjusica agena bred gug qoc ibuldocnu jis eu ageca hoiaunnu batut feigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Odi maadeceb malogom age togodudu madein, “Ege bred qee cedi aholom eunu je magena,” ein. ");
INSERT INTO aey_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas uqa, age eunu togododogin dumei maaden, “O dana wawaga meleec nag, age eetanu bred qee cedi aholoin eunu togodudu madegina? ");
INSERT INTO aey_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Age qila wawaga qee fogo dolfo? Wele bred 5-pela ninijen dana 5,000 jein age deel euna jecefanaga galelna tacecebil ganic ihoc len eu qee cisdoginafo? ");
INSERT INTO aey_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Qeefi, age bred 7-pela ninijen eu dana 4,000 ihoc jecebil jecefanaga galelna tacecebil ganic ihoc len euha qee cisdoginafo? ");
INSERT INTO aey_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ija brednu qee maadelem. Eu adi wawaga qee fogo dol? Age Farisi Sadjusica agena bred gug qoc ibuldocnu jis eu ageca hoiaunnu batut feigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Odi maadeceb malogom age Jisas uqa age bred gug qoc ibuldocnu jis eu batut feigale ec qee madel euqa age Farisi Sadjusica agena iwaladec je eu batut feigale ec madeia eunu doin. ");
INSERT INTO aey_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas uqa malogom gami Sisaria Filipai agena hatuna cobimeig Jisas uqana malogom sisiladi maaden, “Mateiga, dana age Dana Melahnu in egina?” aden. ");
INSERT INTO aey_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Odocob jejeg hewi madoin, “Dana oso age madegina, uqa wa joadec dana Jon, egina. Leih madegina, uqa Ilaija, egina. Leih madegina, uqa Jeremaiafo, uqa je hahun madec dana osofo, egina,” doin. ");
INSERT INTO aey_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Uqa haun sisiladi maaden, “Ageqa, ijanu in egina?” aden. ");
INSERT INTO aey_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Odocob Saimon Pita Jisas jejeg hewi madon, “Krais eu hina. Cebac bilec Anut uqa melah eu hina,” don. ");
INSERT INTO aey_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Odi madocob Jisas madon, “O Saimon, Jon melah, hina eelhec biliga. Mahanadec dana oso je eu qee camas mihel. Eu Mei sao jobon bilia eu uqa je i camas mihia. ");
INSERT INTO aey_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eunu ija je oso mahigina eu odi. Hina Pita, ija meen big gug i tatacan ija ijana tamanec cehigen. Odocob oloqanih uqana cebec gagadicca eu ijana tamanec qee wooldoiaun. ");
INSERT INTO aey_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ija sao cul jobon ki ihigen. Ceteh cunug hina mahana jelaga qa sao jobonna ha jelec biligian. Ceteh cunug hina mahana cufalaga qa eu sao jobonna ha cufalec biligian,” don. ");
INSERT INTO aey_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Odimei Jisas uqana malogom cahacaadi maaden, “Ija Krais je eu leih cain maadi cobowain,” aden. ");
INSERT INTO aey_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Saen euna Jisas uqa uqana cal mecnu uqana malogom maadecnu sanan mimei maaden, “Dana Melah uqa Jerusalem ono teceb Juda agena matuca, ihanec dana benbenca, loo je iwaladecca, age madecebil deweg sogoec ben gahidugian. Age uqa qocobil cal migian. Uqa deel cijeddocna Anut uqa tulidocob ceseli cajigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Uqa eunu maadeceb Pita uqa Jisas ehudeceb filecna limesi Pita uqa Jisas cahacdudu madon, “O Tibud, Anut uqa ceteh eu dewenna hoiaundainnu cahacduhiale!” don. ");
INSERT INTO aey_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pita odi madocob Jisas falicdu madon, “Seten, hina Anut madena eu qee madelem. Hina dana mahanadec cisdoc toodu matagana. Hina jic cufa qutagana. Se, cuculti nuuga!” don. ");
INSERT INTO aey_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","27","Odocob Jisas uqana malogom maaden, “Feiga, Dana Melah uqa Memegna kobolkobolca uqana ensel gami hoqagan. Deel euna uqa dana abesabes age odoinnu ameg wadacadigian. Eunu dana oso mahamaha cehewan cunug oialumiqa uqana cebac bilec qee moubmi cehewan on eunu me biloubfo? Qeefi, dana uqa cebac bilec eu culecebfi cel cetehna uqana cebac bilec ceseli besi ocnu fajudigian? Oso uqa uqana cebac bilec cahahadugia odona eu uqa uqana cebac bilec felacudigian. Odocob oso uqa ijana bilina eunu uqana cebac bilec felacudecebfi eu uqana cebac bilec ugian. Eunu oso uqa ijanu madi, ija uqa jaih ceen lahacdudu toodugen, ena eu uqadodoc deweni me biligian ec cain madeiaun qa uqa uqana na babalec hewi gahidumei tooteiale. ");
INSERT INTO aey_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ija mele maadigina, leih age ene tawegina eu age qee cal mec ninijeb Dana Melah uqa uqana king culna hohob mecidoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Deel 6-pela hedocob Jisas uqa Pitaca, Jemsca uqa waliag Jonca cedadimei ehadi aluh ohis osona dana oso qee bilec euna ti cuhanuc bilein. ");
INSERT INTO aey_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ono bibilegin Jisas uqa age amagana ibuldon. Uqa ola cam odi camalen, uqana lotoc senenec bahic fulacdon. ");
INSERT INTO aey_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Odocob uqana malogom age Moses Ilaijaca ale hocobil Jisasca togododogin feciadein. ");
INSERT INTO aey_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Odi bibileig Pita uqa fimei Jisas madon, “O Tibud, ege ene odi bilecnu eu me bahic. Hina madecemfi ija ene talah jo cijed cehigen, oso hinana, oso Mosesna, odocob oso Ilaijana,” don. ");
INSERT INTO aey_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Uqa je eu madudu bibilen taen oso fulacdoc bahic ni jahuladen. Taennadec jejeg oso camas mimei maden, “Ija melami nelugca, ija uqanu gale ben tena eu ihen. Age uqa jejeg toodu odoiga,” en. ");
INSERT INTO aey_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Odocob malogom eu dah mimeig ni mahulein. Age ben bahic cucuiein. ");
INSERT INTO aey_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Euqa Jisas ageca limei hewadi maaden, “Age cain cucuiuwain. Cajeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Age caji meciimeig dana oso qee felein, Jisas himec fein. ");
INSERT INTO aey_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Age aluhnadec totoni Jisas malogom cijed je gatiti maaden, “Qila feiga eu oso cain saadowain. Dana Melah cal mecnadec qee cajec ninijeb je i oso cain doiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Odocob malogom age Jisas sisildu madoin, “Eunu eetanu loo je iwaladec age Ilaija uqa aquni hugian egina?” doin. ");
INSERT INTO aey_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Odocobil Jisas maaden, “Ilaija uqa mele hugian, humei ceteh cogogen eu cunug tutuc mudigian. ");
INSERT INTO aey_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Euqa ija maadigina, Ilaija uqa wele hon. Hocob dana age uqanu qee doloin. Agedodoc wawaga maden eu age uqa odudein. Eu odiwe ageha Dana Melah odudecebil deweg sogoec ben gahidugian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas odi saadeceb malogom age Jisas uqa wa joadec dana Jonnu mageia imeig wawaga fogo don. ");
INSERT INTO aey_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisas malogom cijedca age dana cajaca mati cemenega lecebil dana oso hu Jisas jaihna isec gob cehimei madon, ");
INSERT INTO aey_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“O Tibud, ija melami uqa titi hudec hag qona eu me qee bahic odudina. Saen matica janaca wanaca toni mahuli cosolena. Eunu hina uqanu walol heiale. ");
INSERT INTO aey_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ija ijana mel hina malogom cemenega mudecemin ageqa me mudecnu ihoc qee,” don. ");
INSERT INTO aey_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Odocob Jisas uqa jejeg hewi madon, “O dana cajaca qila bilegina, age wawaga meleecca qee, age cisdoc cogogecca! Saen ganic ija ageca haun biligen? Saen ganic ija camuhulaadi cobigen? Mel eu cemeni ehudi ahoigale,” don. ");
INSERT INTO aey_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Odi odocobil Jisas uqa buga me qee eu cahacdudu madocob uqa mel eu cuculdi nueceb mel qila i medocob bilen. ");
INSERT INTO aey_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Odocob malogom age Jisasca jahuni humeig sisildu madoin, “Ege eetanu buga me qee eu ititacdocnu ihoc qee lel?” doin. ");
INSERT INTO aey_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Odocobil maaden, “Agena wawaga meleec eu nag eunu ihoc qee lel. Ge, ija mele maadigina, age wawaga meleec eu nag bahic, eu mastet aig cinigwe tawecebfi age aluh i madoubmiqa, ‘Hina cajimeg onoca nuuga,’ doubmiqa odocob uqa conoga toodu odoub. Ceteh odoc oso odocwe qee eu qee nijiaun. Odoc cunug ihoc ligian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Age odi ono Galili hatuna bilimeig Jisas maaden, “Dana Melah eu dana ebenegana mudecebil ");
INSERT INTO aey_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","age uqa qocobil cal migian. Odocob deel cijeddocna Anut uqa tulidocob ceseli cajigian,” aden. Uqa odi maadeceb wawaga me qee men. ");
INSERT INTO aey_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Age haun ceselimeig Kapaneam jobon hoin. Bibilegin tempel cabinu takis helecebil cedein dana eundec osooso Pitaca limeig sisildu madoin, “Agena iwaladec uqa tempel cabinu takis qee helenafo?” doin. ");
INSERT INTO aey_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita uqa maaden, “Ese, uqaha takis helena,” aden. Hibna Pita uqana jona bibilen Jisas uqa Pita sisildu madon, “Saimon, hina eeta madagana? King mahanadec age in takis helecebil ogina? Age agena mel helecebil oginafo, qee dana maha fildec helecebil oginafo?” don. ");
INSERT INTO aey_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Odocob Pita madon, “King mahanadec age dana maha fildec takis helecebil ogina, igina,” don. Odocob Jisas madon, “Odi mele, eunu kingna mel age takis helecnu je qee nijel. ");
INSERT INTO aey_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ageqa elenu gemanaga beiaunnu hina Galili wa cagoc lanna limeg cawil wana helagale. Hina odi odocom dool oso cawilna umeg didu ogale. Umeg uqa biahna meen qaig oso eu ninijeb cacawi umeg meen qaig eu tempel cabinu hinanuca ijannuca helagale,” don. ");
INSERT INTO aey_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Saen euna malogom age Jisasca limeig sisildu madoin, “Sao cul jobon euna in oso cunug wooladi ben bilina?” doin. ");
INSERT INTO aey_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Odocobil Jisas uqa mel sim oso utadocob uqaca hocob uqa ehudi malogom gemona mudimei ");
INSERT INTO aey_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","maaden, “Ija mele maadigina, age tului qee falicdu mel i cinigwe ha qee ibuldufeig age sao cul jobon ono qee lowain. ");
INSERT INTO aey_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Oso uqadodoc jogoimei ija cotiel agena ben ec qee madigiaqa mel eu cinigwe eu cotugul cunug wooladi sao cul jobonna ben bilina,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Oso uqa mel sim eundec oso ija ijanina ehudimei eu eeldona eu uqa ija oitimei eeltena,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jisas odi maadi maaden, “Euqa oso uqa mel sim i eundec oso uqa ijanu waug meleena eu odudeceb silail migiaqa eu meen culumenca bena qagi macas ameg nijia euna age helecebil wa jimei cal moubmi eu me odoub,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Faninadec mahana nijina, odocob faninadec eu gaid dana cajaca ageca hona, eu cunug qee mudecnu qee nijel. Euqa dana cajaca age maha ina bilegina age leih faninadecebil silail megina eu age walocca! ");
INSERT INTO aey_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Odocob hina eben lecisca jaim lecisca ja cijeceb catanecna helihecebil euna bilecnu eu me qee bahic. Euqa hina ebenca qee jaimca qee cebac bilec catanec ogaqa eu me. Eunu hina ebenfo, jaimfo silail mecnu mana tawecebfi hina qeti helagale. ");
INSERT INTO aey_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Odocob hina amen lecisca oloqanih jana helihecebil euna bilecnu eu me qee bahic. Euqa hina amenca qee euqa cebac bilec catanec ogaqa eu me. Eunu hina amen faninheceb silail mifeg amen seli helagale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Ija maadigina, sim agena ensel age gaid Mei sao jobon bilia uqa ola mecidogina. Eunu batut feigale, age mel sim i age oso cain cewudowain,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jisas je haun maaden, “Age je i maadigennu adi cisdogina? Dana oso uqana sipsip 100 cobogina eundec osol jahunen. Odocob dana eu dumei uqa 99 eu aluhna cuculadi jahunen eu wawali qee cobonafo? ");
INSERT INTO aey_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Uqa eu gulucdufei, ija mele maadigina, uqa 99 aluhna me bilegina eu cunug woolaadi osol cahahadu on eunu waug ceelena. ");
INSERT INTO aey_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eu odi Mei sao jobon bilia uqaha mel sim oso fadaleiaunnu qee gale dona,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jisas je haun maaden, “Hina cotin dewenna silail mecebfi hina uqaca limeg hina uqaca himec mecidodecna madogale. Madogona eu cotin dah mecebfi hina cotin haun ceseli ogona. ");
INSERT INTO aey_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Euqa uqa hinana je dah mecnu culecebfi ‘je eu tutuc mudec dana lecisfo, cijedfo amagana cabi ocnu’ hina dana osolfo, lecisfo cedalecem age osoben li cotin madoigale. ");
INSERT INTO aey_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hina cotin dana eu agena je dah mecnu culecebfi hina je eu tamanec amegna camasac magale. Cotin uqa tamanecna je toodu odoc culecebfi hina uqa Juda dana qee eundecfo, takis cedec eundecfo hibemadeginawe hibemdogale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ija mele maadigina, age ceteh mahana jelegina eu sao jobon jelec biligian. Ceteh age mahana cufalegina eu sao jobonha cufalec biligian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","“Je osoha maadigina, lecisfo cijedfo ija ijaninu ceguli bilegina euna ija age gemona biligen. Eunu age eundec lecis mahana ceteh osonu Mei madocnu wawala osol meceb inondocobilfi ceteh eu Mei sao jobon bilina eu adigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita uqa Jisas cemenug limei sisildu madon, “O Tibud, coti uqa ija silail mecna culini gaid tudocob cagasitoc sanijec ganic ihoc leceb cagasitugen? Cagasitoc 7-pela ihoc lec eu ihocfo?” don. ");
INSERT INTO aey_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisas uqa Pita jejeg hewi madon, “Ija mahigina, 7-pela ihoc lec eu ihoc qee, euqa hina cotin 70doc sanijec 7-pela ihoc leceb cagasitoga,” don. ");
INSERT INTO aey_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Odi madumei maaden, “Sao cul jobon eu odi king oso uqa uqana cabi dana agena cub oc tutuc mudecnu utaaden. ");
INSERT INTO aey_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eu age hocobil age gemona cabi dana oso camas men eu uqa kingna 10 milion kina wele on. Uqana cub oc eu ben bahic. ");
INSERT INTO aey_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","King uqa ameg itiga don qeenu king maaden, ‘Age uqaca uqa aidegca uqana melca uqana ceteteh cunugca idadumeig meen qaig iteiga,’ aden. ");
INSERT INTO aey_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Odocob cabi dana eu uqa je eu king madeceb dumei uqa king amegna gob cecehi kingnu cuha fimei ninidudu madon, ‘O ijana Ben, hina susumitem ija isi meen qaig ameg cunug ihigen,’ don. ");
INSERT INTO aey_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Odi odocob king uqa dana inu walol docob besitumei uqana cub oc cunug cagasiton,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Euqa cabi dana eu nuimei uqa cabi hijag oso gulucdon. Eu uqa wele 100 kina uten. Uqa eu gulucdumei be doodool hewimei madon, ‘Meen qaig ihem eu qila ameg itiga,’ don,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Odi odudeceb cabi hijag eu uqa amegna gob cehimei ninidudu madon, ‘Sumitigale. Ija meen qaig ameg cunug isi ihigen,’ don. ");
INSERT INTO aey_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Odocob uqa eu cuculi gihacdoc jona tacen meen qaig ameg itecem besihigen don,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Uqa odi odocob uqa cabi hijagul je eu cunug dumeig wawaga me qee meceb age li king je eu cunug sadoin. ");
INSERT INTO aey_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","King je eu dumei uqa dana i utadocob hocob madon, ‘Hina cabi dana me qee bahic. Hinana cub oc ben bahic ninijen ninitecemnu cagasihem. ");
INSERT INTO aey_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Hina cabi cotin niniheceb hina eetanu uqanu qee walol hel ija hinanu walol ten odi?’ don. ");
INSERT INTO aey_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Odimei gemag madudu deweg tudocnu gihacdoc jo cofdoc culiaden, meen qaig ameg cunug iteceb besitoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Eunu age cotogail agena cahuldoc qee cagasi bahic adecebilfi Mei sao jobon bilia eu uqaha king uqa cabi dana me qee odudenwe odadigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas uqa je eu madi hedumei Galili hatu culimei Judia hatu Jodan Wa ono isec nui bilen. ");
INSERT INTO aey_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dana cajaca mati bahic toodu cobocobil uqa ono agena hagnu me maden. ");
INSERT INTO aey_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Odocob Farisi age ege Jisas temdu feqan imeig uqa sisildu madoin, “Magaga, dana oso uqa aideg deweg je oso nijeceb uqa culdecnu egena loo je cois ec madenafo?” doin. ");
INSERT INTO aey_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Odocobil Jisas maaden, “Ifanec gug eu ‘Anut uqa dana cajaca ifani malimei maden’ eunu Anutna jaqec jena qee sanijeleinfo? ");
INSERT INTO aey_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Anut uqa odi maden: ‘Gug inu dana uqa memeg anagca culalimei aidegca gabanalecebil biluwasan. Odocob lecis ale deweg osol biluwasan,’ en. ");
INSERT INTO aey_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Eunu ale lecis qee biluwasinqa ale deweg osol bilesina. Eunu Anut gabandon eu dana oso cain cagoiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Odocob age Jisas jejeg hewi madoin, “Moses uqa eetanu loo je odi igen, agena caja cagoc je jaqec utimeig culdecebil nuigian, gen?” doin. ");
INSERT INTO aey_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Odi madocobil maaden, “Age wawaga tool ibuldon eunu Moses uqa caja culdecnu jic besiaden. Gug qocna odoc odi qee nijel. ");
INSERT INTO aey_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ija maadigina, dana oso uqa aideg dana osoca qee leceb nijelesin euqa gauc dana caja sisi jelec wagalimei aideg culdi caja haun oso ona eu wal kobol odona,” aden. ");
INSERT INTO aey_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jisas odi maadeceb malogom age Jisas madoin, “Dana cajaca bilecnu je odi tawecebfi eu caja ocnu cois qee,” doin. ");
INSERT INTO aey_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","12","Odocobil Jisas maaden, “Dana osooso age caja ocnu duman utec qee nijel age odi anagail basadein. Leih dana baminiga seladecebil age caja ocnu qee nijel. Leih age sao cul jobonnu cabi ocnu himec cisdumeig agedodoc dewenega cilehdumeig caja qee ogina. Oso uqa je eu ocnu ihocfi ugian. Eunu je eu dana cunug ocwe qee. Oso je eu ocnu duman utec nijia eunu dahig fogo dugian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dana cajaca leih age Jisas uqa agena mel sim ebenna hewadi agenu inondugiannu mel sim Jisasca ehadi ahoin. Ahocobil malogom age ehadi ahoin eundec gagalaadi cahacadein. ");
INSERT INTO aey_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Odocobil Jisas eu fimei maaden, “Mel simwe eundecnu sao cul jobon muden nijiado. Eunu cain cahacadowain. Culadecebil mel sim age ijaca hoigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Uqa odi maadimei eben mel ilomogana mimei eeladimei cuculadi nuen. ");
INSERT INTO aey_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Dana haun oso uqa Jisasca hu sisildu madon, “O Iwalgec, cebac bilec catanec eu ocnu eeta me odoc oso odigen?” don. ");
INSERT INTO aey_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Odocob Jisas jejeg hewi madon, “Hina me odocnu eetanu sisiltagana? Anut uqa himec me. Hina cebac bilecna lecnu madifeg Anutna loo je toodu odogale,” don. ");
INSERT INTO aey_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Odocob dana haun madon, “Cel loo jenu cisdudu matagana?” don. Odocob Jisas madon: “Hina oso cain qagadogaun. Hina dana cajaca dewenela osol mec cain cagualegaun. Hina oso uqana ceteteh cain heje cedagaun. Hina oso uqanu uhulec je cain madagaun. Hina oso cain um qudugaun. ");
INSERT INTO aey_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Hina memen aninca lalan malagale. Odocob hina hinanel nalunin maganawe odi hina utuqain bilec eundecnu nalug magale,” don. ");
INSERT INTO aey_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Odocob dana haun eu uqa Jisas madon, “Loo je eu cunug ija toodu odi hedom. Ceteh odocnu ija qee odolom eu oso nijiafo?” don. ");
INSERT INTO aey_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Odocob Jisas uqa jejeg hewi madon, “Hina dana tutuc bahic calegannu gale hecemfi hina nuimeg hina cehewain cunug idadumeg meen qaig eunadec umeg dana sawen eundec siwiadagale. Odi odimeg hina sao jobon ono cehewainca bilegan. Odimeg hu ija tootagale,” don. ");
INSERT INTO aey_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Odocob dana haun eu uqana ceteh cehewan mati bahic nijen eunu Jisasna je eu dumei uqa waug culumen dodon Jisas cuculdi nuen. ");
INSERT INTO aey_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Odocob Jisas uqa malogom maaden, “Ija mele maadigina, dana cehewanagaca age sao cul jobon dunuh loqagannu eu cacanigca bahic! ");
INSERT INTO aey_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ija haun maadigina, kamel uqa lotoc gisec cese gigilona isec li nuecnu cacanigca, euqa dana cehewanca eu Anutna cul dunuh lecnu cacanigca eu wooldoc bahic,” aden. ");
INSERT INTO aey_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Malogom age je eu dumeig age tumatumai madein, “Mele odi nijecebfi innini Anut uqa cahahaadigian?” ein. ");
INSERT INTO aey_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Odi madecebil Jisas meciaadi maaden, “Dana age odi odocnu qee nijel. Euqa Anut ceteh cunug odocnu dona,” aden. ");
INSERT INTO aey_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Odocob Pita uqa Jisas jejeg hewi madon, “Faga, ege ceteteh cunug culimeb hina toohi coboqona. Ege isi eeta oso oqan?” don. ");
INSERT INTO aey_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Odocob Jisas maaden, “Ija mele maadigina, maha haun ibuldocna Dana Melah uqana king bilec bahim kobolkobolcana bibileb ageha king bilec bahim 12-pelana bibili Isrel sihul 12-pela gesiladoqagan. ");
INSERT INTO aey_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Age abesabes oso uqa jofo, waliagulfo, cebinagulfo, memegfo, anagfo, uqana melfo, cabifo ija ijaninu culiadecebfi uqa ceteh culden eu 100doc wooldoc ameg ben bahic ugian. Odocob uqa cebac bileceb catanec muguh ugian. ");
INSERT INTO aey_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Euqa mati qila hib bahic taweiga eundec age isi aquni tawoqagan. Odocob mati qila aquni taweiga eundec age isi hib bahic tawoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas je haun maaden, “Sao cul jobon odiwe bilia. Jo gug uqa deel osona qasil cabi dana age uqana wain cabina cabi ocnu fajadigiannu waladi nuen. ");
INSERT INTO aey_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Uqa dana gulucadimei kina osolnu qila cabi ocnu sisiladeceb cois ecebil uqa uqana wain cabina cabi oqagannu suladen. ");
INSERT INTO aey_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Uqa 9 kilokna haun ceseli cobimei dana gauc idadec cudunna tatawegin feciadimei ");
INSERT INTO aey_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","maaden, ‘Ageha ijana wain cabina belimeig cabi oigale, ija agena cabi oc ameg ihoc adigen,’ aden. Odocob age cabi ocnu belimeig cabi oin. ");
INSERT INTO aey_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Uqa cam gemo cehi tatawen haun cocobi li cabi dana haun ceden. Odimei cam waldocob 3 kiloknaca cocobi li odi ha odon,” aden. ");
INSERT INTO aey_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Odimei uqa 5 kilokna cocobi li dana leihha gulucadimei maaden, ‘Age eetanu cahineg cunug ene gauc taweiga cabi oso qee oloin?’ aden. ");
INSERT INTO aey_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Odocob age madoin, ‘Oso cabi ocnu qee hu magel,’ doin. Odocobil uqa maaden, ‘Ageha ijana wain cabina belimeig cabi oigale,’ aden,” aden. ");
INSERT INTO aey_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Wesu meceb wain cabi gug eu uqa uqana cabi cofdoc dana madon, ‘Hina cabi dana utaadecem hocobil cabi oc ameg adagale. Hib hoiga euna sanan mimeg aadi aadi li qasil hoiga euna ihoc lec adagale,’ don. ");
INSERT INTO aey_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Uqa utaadeceb hocobil cam waldoc 5 kilokna cabina lein eundec kina osol aden. ");
INSERT INTO aey_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Odocob qasil cabina casac lein eundec age wawagana madein, ‘Uqa ege meca igigian,’ ein. Euqa ageha kina osol aden. Cabi cofdoc uqa kina osol adeceb ");
INSERT INTO aey_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","age wain cabi gugnu gonagona mimi madoin, ");
INSERT INTO aey_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Dana hib hoiga eu aua osol himec cabi oiga. Ege qasil sanan mimeb cam qiqigen cabi oqa. Hina hib hoigaca egeca ihocihoc igiga eu cois qee,’ doin,” aden. ");
INSERT INTO aey_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Euqa wain cabi gug uqa dana eundec oso madon, ‘Ijana danah, ija hina qee wahelem. Faga, ija hina qasil kina osolnu cabi oganfo, ec sisilhecemin cois qee telemfo? ");
INSERT INTO aey_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hinana meen qaig oga eu gad hewi nuuga. Ijadodoc ijana gale tecnu ija hib hoiga eundec hina ihiga odi ihocihoc adiga. ");
INSERT INTO aey_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ija ijana ceteteh wawi madec toodu siwecnu qee nijelfo? Ija nelinica odigina hina eunu gumunitagana eu coisfo?’ don,” aden. ");
INSERT INTO aey_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Eu odi milum hib hoin eundec matu ibuldoqagan, matu aquni hoin eundec milum ibuldoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas uqa Jerusalem ono ti cocoboi uqa uqana malogom abes utaadeceb hocobil maaden, ");
INSERT INTO aey_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Feiga, ege Jerusalem toqona. Ono age Dana Melah ihanec dana benben ebeneganaca loo je iwaladec ebeneganaha muduqagan. Age uqa cal migiannu geldumeig ");
INSERT INTO aey_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Juda dana qee eundec ebenegana muduqagan. Odocobil age uqa lelandumeig qisadu na babalecna tuitu qumeig caqusecebil caculimei cal migian. Odocob deel cijeddocna Anut uqa tulidocob ceseli cajigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Saen euna Sebedi melahul lecis ale anala uqa Jisasca humei uqa amegna gob cehi uqanu cuha fimei je madugiannu bilen. ");
INSERT INTO aey_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Odocob Jisas uqa sisildu madon, “Eetanu matecnu odogona?” don. Odocob caja madon, “Hinana cul camas meceb ija melamiel lecis oso hina eben meulana isec, oso eben ansena isec bilec meca eu alegannu je hahun itigale,” don. ");
INSERT INTO aey_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Odocob Jisas caja jejeg hewi maalen, “Ale cetehnu ninitesina eu uqana caun qee dosina! Wa gab ija jigen eu aleha jecnu ihocfo?” alen. Odocob madosin, “Ese, ele jecnu ihoc,” dosin. ");
INSERT INTO aey_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Odocobil Jisas maalen, “Mele, wa gab ija jigen eu aleha jowasan. Euqa bilec cudun ebeni meulana isecca ebeni ansena isecca alecnu eu ijana cabi qee. Eu Mei uqa bilec eu ocnu wele maden eu ale bahic owasan,” alen. ");
INSERT INTO aey_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Malogom 10-pela age je eu dumeig age dana lecis eu alenu wawaga me qee men. ");
INSERT INTO aey_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Odocob Jisas uqa malogom utaadeceb hocobil maaden, “Juda dana qee eundec agena king age agena dana gagadic madegina, odocob mahana dana ben age dana cilehadegina eunu age dogina. ");
INSERT INTO aey_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Euqa age gemona odi cain nijiaun. Age gemona oso ija ben biligen ifei uqa cotugul cunug cewel uadeiale. ");
INSERT INTO aey_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Odocob oso uqa ija matu biligen ifei eu agena begabeg meh cabi dana ibuldoiale. ");
INSERT INTO aey_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ge, Dana Melah ha dana age ija cewel utuqagan imei qee toni nel. Qeeo. Dana Melah uqa dana cajaca cewel uadecnu toni nen. Uqa ijana cebac bilec eu dana cajaca mati besiadec fajadecnu culigen imei eunu toni nen,” aden. ");
INSERT INTO aey_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas uqana malogomca age Jeriko taun cuculeig dana cajaca mati bahic tooadecebil coboin. ");
INSERT INTO aey_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Cocobogin dana amala galuc mec lecis ale jic gesacna bilesin. Dana lecis eu ale Jisas hona ec mamadegin dah mimesi ale utai madesin, “O Dewid Melah, elenu walol heiale!” esin. ");
INSERT INTO aey_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dana cajaca age gagalaaali maalein, “Cain utaowasin. Culesiale,” alein. Euqa ale feeadi conola suli u utai madesin, “O Tibud, Dewid Melah, elenu walol heiale,” esin. ");
INSERT INTO aey_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas tului tawimei dana utaali maalen, “Ija ale eeta odaligennu matesina?” alen. ");
INSERT INTO aey_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Odocob dana amala galuc mec ale Jisas madosin, “O Tibud, ele amile meciecnu odiligale,” dosin. ");
INSERT INTO aey_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Odocobil Jisas alenu waug qocob amala qududocob mahuc amala fogo docob ale ceteh cunug fesin. Odimesi ale Jisas toodocobil belein. ");
INSERT INTO aey_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisas uqana malogomca age Jerusalem dodoldodogin Betfasi jobon Oliw Aluhna isec calimeig uqa malogom lecis sulaali ");
INSERT INTO aey_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","maalen, “Jobon amigena nijia euna lesia. Ale dunuh lelesi cesel anag uqana goman manahalca qagalec tatawecebil eu gulucdowasan. Ale eu cufalalimesi ehali ahutesiale. ");
INSERT INTO aey_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Dana oso uqa ale eetanu cesel cufalalesina alecebfi ale madowasan, ‘Tibud cesel eu ocnu eu cabi osoca madena,’ dowasan. Odocobil dana eu cesel culaligian,” alen. ");
INSERT INTO aey_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Je hahun madec dana uqana je oso ihoc ligiannu odi odon. Je hahun madec dana uqa wele odi maden: ");
INSERT INTO aey_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Age Saion dana cajaca odi maadeigale, ‘Feiga, agena king ageca hona. Uqa dana jogoi cobonawe cesel uqa guhadocob hona. Cesel uqana nag goman guhadocob hona,’ adeigale,” en. ");
INSERT INTO aey_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Malogom ale limesi Jisas maalen odi odosin. ");
INSERT INTO aey_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ale cesel anag uqana gomanca ahocobil malogom agena lotoc cesel gogodohna duecebil cesel uqa Jisas guhadocob belein. ");
INSERT INTO aey_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dana cajaca mati age aquni belein eu agena lotoc jicna duein. Leih age celus qetimeig jicna duein. ");
INSERT INTO aey_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dana cajaca age aqunitutu hib toodudu age due sisili madein: “Hosana! Ege Dewid Melah binan suluquna! Tibud ijanna egeca hona eu uqa eeldoc biliale. Anut Ohis Bahic uqa binan wasi nuiale,” ein. ");
INSERT INTO aey_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas uqa Jerusalem leceb dana cajaca age Jerusalem bilein eu age tumatumai madein, “Dana i uqa in?” ein. ");
INSERT INTO aey_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Odocobil dana cajaca toodu coboin eu age madein, “Uqa Jisas, uqa je hahun madec dana Nasaret jobondec, Galili hatuna,” ein. ");
INSERT INTO aey_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas uqa tempel dunuh limei uqa ono dana ceteh fajeinca ceteh suldoinca eundec feciadimei cunug ititacadeceb maha gemo calein. Odimei dana age meen qaig maha filfilca meen qaig tempelca wadacwuducdoin eundec agena cabal sunduadeceb agena meen qaig golodon. Uqa cuhudid fajec agena cabalha sundocob golodocob ");
INSERT INTO aey_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","maaden, “Anutna je jaqecna je oso nijia eu Anut odi madena: ‘Ijana jo eu Anut inondocnu jo oqagan,’ ena. Ageqa agena odocna age falicdocobil heje dana agena jahunec cudun ibuldon!” aden. ");
INSERT INTO aey_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Odocob dana amaga galuc mecca laleg mecca tempelna Jisas cemenug hocobil uqa me maden. ");
INSERT INTO aey_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Euqa ihanec dana benbenca loo je iwaladecca age Jisas kobolkobol oodon fimeig mel sim ha tempelna Jisas binan susuli Hosana! Ege Dewid Melah binan suluquna! ec due sisilegin dah mimeig gemanaga jawe beceb ");
INSERT INTO aey_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jisas madoin, “Mel sim madegina eu hina dah maganafo?” doin. Odocobil Jisas jejenega hewi maaden, “Mele, dah migina. Age jaqec je Anutna je i qee sanijeleinfo? ‘Hina mel sim momodoca iwaladi cuhadom. Age conoganadec binan sulec je hinanu wasena,’ en,” aden. ");
INSERT INTO aey_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Odi maadimei uqa age tatawegin culadimei uqaha Jerusalem cuculi Betani jobon ono nui nijaug nijen. ");
INSERT INTO aey_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jisas uqa qasil ceseli haun Jerusalem hugia hohon wen don. ");
INSERT INTO aey_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Odocob uqa na dan oso filec tatawen fen. Odimei uqa ono gug cemenug limei me aigcafo fecnu len. Euqa na dan me aigca qee, eu bagac himec tatawen fen. Odimei uqa na dan madon, “Hinana aig oso haun qee qogaun!” don. Odocob na dan mahuc galalen. ");
INSERT INTO aey_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Malogom age eu fimeig age tumatumai madein, “Na dan eu adi mahucwe galaleia?” ein. ");
INSERT INTO aey_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Odocobil Jisas maaden, “Ija mele maadigina, age wawaga meleec nijialumi wawaga lecisca qeemi age na dan eu oodom feiga eu himec qee odoubqa age aluh i hina caji macasna noga doubmi eu conoga toodu odoub. ");
INSERT INTO aey_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Age wawaga meleeccafi ceteh cunugnu inondufeig eu age oqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas uqa haun tempel dunuh limei dana iwaladi tatawen ihanec dana benbenca Juda agena matuca age Jisasca hu sisildu madoin, “In ijanna hina eu odogona? In cabi eu ocnu mahen odogona?” doin. ");
INSERT INTO aey_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Odocobil Jisas jejenega hewi maaden, “Ija age casac je oso sisiladigen. Age eu jejeni hewi matecebilfi ija hibna ha in cabi iteceb ugina, in ijanna ceteh odigina eu camas mecemin doqagan. ");
INSERT INTO aey_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Eu odi, Jonna wa joadec eu anadec? Eu sao jobondecfo, qee dananadecfo? Mateiga duga,” aden. Odocob age fee dadani togodudu madein, “Ege madoqaqa wa joadec eu sao jobondec doqaqa uqa ege eetanu uqanu wawaga mele qee el? gigian. ");
INSERT INTO aey_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ege madoqaqa wa joadec eu dananadec doqaqa eu dana age adi odiguqagannu cucuiuquna. Ge, dana cajaca cunug age Jonnu uqa je hahun madec dana egina,” ein. ");
INSERT INTO aey_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Eu togodu hedumeig age Jisas madoin, “Jonna wa joadec eu anadec ege qee doqona,” doin. Odocobil Jisas maaden, “Eunu ija ageha in cabi iteceb ugina, in ijanna ceteh i odigina eu qee maadigaun,” aden. ");
INSERT INTO aey_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas uqa ihanec dana benbenca Juda agena matuca je haun maaden, “Age je inu eeta cisdogina? Dana oso uqana mel lecis bilesin. Memeg uqa mel matuca limei madon, ‘Melami, hina qila wain cabina limeg cabi ogale,’ don. ");
INSERT INTO aey_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Odocob mel eu memeg madon, ‘Culadiga,’ don. Hibna uqa memeg feedonnu eu ija cois qee odolom imei waug me qee meceb uqa wain cabina limei cabi on. ");
INSERT INTO aey_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Odocob dana eu uqa mel milumca limei uqa matu madonwe odi ha madon. Odocob mel eu memeg madon, ‘Ben, ija wain cabina nuigen,’ don. Odimei wain cabina qee nuel, cabi culen,” aden. ");
INSERT INTO aey_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Jisas odi maadimei sisiladi maaden, “Mel lecis i in memeg maden eu toodu odon?” aden. Odocob madoin, “Mel matu,” doin. Odocobil Jisas maaden, “Jon uqa ageca hu age jic tutuc cobocnu ihacaden, odocob age uqana jenu wawaga mele qee el. Euqa takis cedec danaca caja silailca eundec age uqana jenu wawaga meleen. Age ceteh eu fein qa age hibna eunu tului qee falicdoloin, age Jonnu wawaga mele qee el. Eunu ija mele maadigina, takis cedec danaca caja silailnu ijanagaca eundec age aquniaadi Anutna culna legina,” aden. ");
INSERT INTO aey_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas uqa ihanec dana benbenca Juda agena matuca je haun maaden, “Age galolo je oso dah meigale. Jo gug oso uqa wain cabi cehimei alildu meen gel tacimei wain aig afdocnu kunum cisimei wain cabi cofdoc biluqagannu bahim jo ben fala ohis tobi eit fec ihoc eu odi cehen. Odimei uqana wain cabi dana leih cabi oqagannu ebenegana mimei uqa hatu osona nuen. ");
INSERT INTO aey_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wain aig wal meceb cedec saen cali hocob wain cabi gug uqa cabi dana sulaadi maaden, ‘Age belimeig wain cabi oc eundec maadecebil age wain aig eu adecebil cedi ahuteigale,’ aden. ");
INSERT INTO aey_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Odocob dana age wain cabi cofdoin eu age cabi dana hewadimeig oso deweg tudoin, oso qocobil cal men, oso meenna qoin. ");
INSERT INTO aey_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Odocobil wain cabi gug uqa haun ceseli cabi dana matica suladen. Age wele odadeinwe odi odadein,” aden. ");
INSERT INTO aey_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Cit qocna wain cabi gug uqa melah suldon. Ge, uqa maden, ‘Ija melaminu cumunuqagan,’ en. ");
INSERT INTO aey_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Euqa wain cabi oc age wain gug uqa melah fimeig togodu madein, ‘I cabi gug huqaneh, uqa isi wain cabi ugian. Cois uqa muguh eu ege oqannu ege cajimeb qocomun cal mecnu!’ ein. ");
INSERT INTO aey_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Odimeig age mel eu hewi sundudu cabi gel hibilohu heludimeig qocobil cal men. ");
INSERT INTO aey_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Wain cabi gug humei uqa wain cabi cofdoc dana eeta odadigian?” aden. ");
INSERT INTO aey_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Odocob dana age Jisas jejeg hewi madoin, “Uqa dana me qee eu me qee bahic aqeceb cal mecebil uqana wain cabi dana filfil cofdocnu adigian. Age uqa wain aig wal meceb utuqagan,” doin. ");
INSERT INTO aey_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Odocobil Jisas maaden, “Jaqec je oso Anutna jaqec jena nijia eu qee sanijeleinfo? Je eu odi madena: ‘Meen oso meen gel cehec memei dana culein eu qila meen jo big gug jo hehdocnu calen. Eu Tibud uqadodoc odi odon. Ceteh eu foqona eu kobolkobolca,’ ena,” aden. ");
INSERT INTO aey_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Jisas odi maadimei maaden, “Eunu ija maadigina. Anut uqa uqana cul age cawaladimei dana sihul fil adigian. Age Anutna cul uqana aig qoc eu Anut utuqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ihanec dana benbenca Farisica age Jisasna galolo je eu dah mimeig age uqa je i agenu madena eunu wawaga fogo don. ");
INSERT INTO aey_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Odocob age uqa heweqan ein euqa dana cajaca age Jisasnu madi, uqa je hahun madec dana, ein eunu age dana cajacanu cucuiein. ");
INSERT INTO aey_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas uqa haun ceseli galolo je oso maaden, ");
INSERT INTO aey_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Sao cul jobon eu odiwe nijia. King oso uqa melah caja ocobocobec deelnu uqana dana cunugnu ja qon. ");
INSERT INTO aey_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Uqa dana wele ja qocna hoqagannu je sulduaden eu qila hoqagannu uqana cabi dana suladeceb li maadecebil ageqa hocnu culein. ");
INSERT INTO aey_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Odocobil king uqa wele hoqagannu maaden eundecnu cabi dana leih haun suladeceb belimeig age li kingna je odi maadein, ‘Feiga, ijana sab ameg cilec eu wele ciluqa taweia. Ijana bulmakau dool laloca cunugha aqoqa nijeiga, ceteteh cunugha saciadoc nijia. Ija melami caja ocnu sab jecna hoigale,’ adein,” aden. ");
INSERT INTO aey_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“King uqana dana eundec age je eu qee docwe mimeig oso uqana cabina nuen, oso idadocnu nuen. ");
INSERT INTO aey_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Leih age kingna cabi dana hewadimeig walocca madimeig aqecebil cal mein. ");
INSERT INTO aey_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Age odi odocobil king uqa gemag beceb uqana han dana suladeceb age limeig dana ebenega golca eu cunug aqimeig agena jobon ben mani hedoin,” aden. ");
INSERT INTO aey_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Odocobil king uqana cabi dana maaden, ‘Ijana sab eu cunug saciadoc nijiaqa dana ene hocnu maadem eu age hu jecnu culein. Agenel ceteh me ocnu ijana sab jec cewudein. ");
INSERT INTO aey_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eunu age belimeig jicjic cocobi dana gulucadimeig eu cunug hu ija melami caja oc deelnu sab jecnu maadeigale,’ aden. ");
INSERT INTO aey_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Odocob cabi dana age beladimeig gulucadein eundec cunug dana meca me qeeha ehadi ahoin. Odi odoinnu melah caja ocnu jona bilec cudun eu cunug ihoc li hedon,” aden. ");
INSERT INTO aey_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Odocobil king uqa dana hu bilein eu cunug meciadigiannu limei uqa dana oso fen. Dana eu uqa king melah caja ocnu cegulec lotoc qee tacec bilen. ");
INSERT INTO aey_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","King uqa eu fimei uqa dana eu madon, ‘Danah, hina adi ija melami caja ocnu cegulec lotoc qee tacec ene hu biligina?’ don. Odocob dana eu hawai bilen. ");
INSERT INTO aey_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Odocob king uqa sab siwiadec dana maaden, ‘Dana eu jaih ebenca libimeig hewi jobon hahagum ehi li tu gagatuccana heleiga nuia. Ono age qada qaqaji maimaga kicodudu biluqagan,’ aden,” aden. ");
INSERT INTO aey_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Dah meiga, Anut uqa mati utaadena euqa uqa matica qee uqana cul dunuh hoqagannu nesili cedena,” aden. ");
INSERT INTO aey_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisi age ege Jisas conadec uqa hagaldocnu je oso oqan imeig togodoin. ");
INSERT INTO aey_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Age agena malogomca Herodna sihulca je adecebil age li Jisas madoin, “Iwalgec, ege hinanu doqona, hina mele je madagana, hina Anutna jic mele iwaladagana, dana binanagaca eundecnu qee cucuiagana. Ge, hina dana saolal madec bilegina eundecnu qee jogoagana. ");
INSERT INTO aey_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Eunu ege Sisanu takis helecnu eu tutucfo, qee tutuc qeefo? eu adi cisdogona, magaga doqa,” doin. ");
INSERT INTO aey_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Euqa Jisas uqa agena cisdoc me qee ec dumei maaden, “Age me hihili coboc, eetanu temtegina? ");
INSERT INTO aey_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis helec meen qaig ihacteiga figa,” aden. Odocob age takis helec meen qaig oso ihacdoin. ");
INSERT INTO aey_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Odocobil sisiladi maaden, “Meen qaig ina in hahun eu gaga qoc taweia? In ijanha jaqec taweia?” aden. ");
INSERT INTO aey_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Odocob age madoin, “Eu Sisa uqana,” doin. Odocobil maaden, “Eunu age Sisana ceteteh eu Sisa uteiga. Anut toinan eu Anut uteiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Age je eu maadeceb dumeig tumatumaein. Odimeig age Jisas cuculdi belein. ");
INSERT INTO aey_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Deel euna Sadjusi age Jisasca hoin. Sadjusi age cal mein eundec ceseli qee cajowain egina. ");
INSERT INTO aey_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Age Jisas je oso sisildu madoin, “Iwalgec, Moses uqa loo je oso igen eu odi magen, ‘Dana oso caja umei mel qee basec cal mecebfi eu uqa waliag biah umei uqana sihul jahunecdainnu uqana mel basowasan,’ gen. ");
INSERT INTO aey_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aria, ege gemona waliagul 7-pela biloloig. Matu uqa caja on uqa ale melca qee cal meceb uqa biah waliag oso on. ");
INSERT INTO aey_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Uqaha mel qee basec cal meceb uqa biah waliag oso on. Odi dih oodi waliagul 7-pela cunug ihoc lein. Dana 7-pela cal mi hedocobil ");
INSERT INTO aey_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","hibna caja euha cal men. ");
INSERT INTO aey_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eu fagale, cal mecnadec ceseli cajecebil caja eu dana 7-pela eundec inna caja biligian? Mahana bilen uqa 7-pela cunug biliaden,” doin. ");
INSERT INTO aey_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Odocobil Jisas jejenega hewi maaden, “Age Anutna jaqec je nijia eu qee dogina, age Anutna gagadic odocha qee dogina. Eunu age dadanecca bilegina! ");
INSERT INTO aey_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ge, cal mecnadec ceseli cajoqagan saen euna eu age dana caja ocobocob qee owain. Euqa age ensel sao jobon bileginawe odi biluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Eu cal mecnadec ceseli cajecnu je oso nijia. Age jaqec je Anut maadena eu qee sanijeleinfo? Je eu odi Anut maden: ");
INSERT INTO aey_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ija Ebrahamna Anut, ija Aisakna Anut, ija Jekobna Anut,’ en. Anut uqa cal mein eundec agena Anut qee, uqa cebac bilegina agena Anut,” aden. ");
INSERT INTO aey_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dana cajaca age Jisasna je eu dah mimeig tumatumaein. ");
INSERT INTO aey_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Euqa Farisi age Jisas uqa Sadjusi conoga cufa quaden je eu dumeig age cegulein. ");
INSERT INTO aey_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Age gemodec loo je iwaladec oso cajimei ija Jisas temdu figen imei sisildu madon, ");
INSERT INTO aey_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Iwalgec, loo je gagadic caunca bahic Mosesna loo je oso cunug wooladec eu cel loo je nijia?” don. ");
INSERT INTO aey_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Odocob Jisas madon, “Loo je madena: ‘Tibud, hinana Anutnu wawin cunugca, doloin cunugca, cisdoc cunugca euna nalug magale,’ ena. ");
INSERT INTO aey_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Eu loo je gagadic matu, eu caunca bahic. ");
INSERT INTO aey_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Loo je gagadic oso nijia eu loo je matu uqana toodoc, eu odi madena: ‘Hina hinanel nalunin maganawe odi hina utuqain bilec eundecnu nalug magale,’ ena. ");
INSERT INTO aey_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Loo je gagadic lecis i ale loo je cunug agena caunca je hahun madec agena jeca eu agena gug nijia,” don. ");
INSERT INTO aey_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi age odi togodudu bibilegin Jisas uqa je oso sisiladi maaden, ");
INSERT INTO aey_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Age Anutna Krais eunu adi cisdogina? Uqa in melah?” aden. Odocob age madoin, “Eu Dewid Melah,” doin. ");
INSERT INTO aey_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Odocobil Jisas maaden, “Dewid uqa Kis Gun dado mudeceb uqa Kraisnu madi, ijana Tibud, en eu adinu? Ge, uqa maden: ");
INSERT INTO aey_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Anut Tibud uqa ijana Tibud odi madon, “Ijaca hu ebeni meulana isec bibilem ija odocomin hinana cad cunug hu ninijebil hina jaimna lahacadegan,” don,’ en. ");
INSERT INTO aey_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Eu feiga, Dewid uqa Kraisnu madi, uqa ijana Tibud, en, eunu adi uqa Dewid Melah bilina?” aden. ");
INSERT INTO aey_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Farisi gemona oso Jisas jejeg hewi madecnu ihoc qee nijel. Ageha deel euna dih sanan mimeig haun cetehnu sisildocnu hihibanaga qee tel. ");
INSERT INTO aey_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Odocob Jisas uqa dana cajaca uqana malogomca Farisinu je odi maaden, ");
INSERT INTO aey_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Loo je iwaladecca Farisica age Mosesna cabi cudun wele oin. Eunu Moses loo je iwaladenwe age odi loo je iwaladegina. ");
INSERT INTO aey_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Eunu age odocnu je maadegina eu cunug toodu odoigale. Euqa agena odoc toodu cain odowain. Ge, age dana cajaca je maadegina euqa age madeginawe agedodoc qee toodu odogina. ");
INSERT INTO aey_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Age ceteh culumen bahic sogimeig dana gahidoqagannu qatomogana megina. Euqa sogec eu agedodoc nag bahic hewi fecnu culegina. ");
INSERT INTO aey_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Age ceteh odogina eu cunug egena odoc eu dana foqagan imeig odogina. Ge, agena sai euna Anutna je jaqein age ilomoga domonnaca ebeneganaca taqegina eu bagalan mudegina. Agena lotoc sucunna gos cecelacca mudegina. ");
INSERT INTO aey_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Age sab ben jecnu age dana ijanagaca agena bilecna bilecnu gawegina. Agena cuha jona cuha cegulecnu cofadec agena bilecna bilecnu gawegina. ");
INSERT INTO aey_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Dana age fajec cegulec cudunna age lalan mamadi tabacunadecebil gale adena. Dana age Farisi maadi madegina, ‘Meca,’ adecebil gale adena,” aden. ");
INSERT INTO aey_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ageqa dana ege ‘Meca,’ goqagan ec cain owain. Agena Iwaladec osol bilina, ageha cotigcotig bilegina. ");
INSERT INTO aey_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Age Memega osol bilina, eu uqa sao jobon bilina. Eunu age dana oso mahana bilina ‘Memige,’ cain dowain. ");
INSERT INTO aey_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Agena Ben osol bilina, eu Anutna Krais. Eunu dana age, age ‘Ben,’ geiga ec euha cain owain. ");
INSERT INTO aey_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Oso age gemona ben bilina eu uqa age cunug cewel uadec biligian. ");
INSERT INTO aey_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Oso uqa culai ijanel lalan mumudi bilina euqa Anut uqa dana eu cilehdugian. Oso uqadodoc jogoi waug lal qocca bilina eu Anut uqa dana eu culaug u lalan mumudeb biligian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Jisas je haun maaden, “O loo je iwaladecca Farisica, age dana cajaca sao cul jobon lecnu jic cebec meniadegina. Euqa agedodoc lecnu culegina, odimeig leih sao cul jobon lecnu wawaga nijia euqa age cahacadegina. Eunu age me hihili coboc dana! Age walocca!” aden. ");
INSERT INTO aey_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“O loo je iwaladecca Farisica, age dana osol Juda kobolnu falicdugia iwaldocnu mahana jic cecelacca cobogina wagna ha cobogina. Dana eu Juda kobol ocob age uqa oloqanih jana bilec dana bahic mudegina. Uqa oloqanih jana bilecnu age wooladena. Eunu age me hihili coboc dana! Age walocca!” aden. ");
INSERT INTO aey_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Age dado madec qa amaga galuc mecca, age walocca! Age odi madegina, ‘Dana oso uqa tempelna mele ohis ena eu ceteh gauc. Euqa dana oso uqa tempelna gold bibilenna madena eu uqa mele ohis ena, cois uqa maden odi odigian,’ egina. ");
INSERT INTO aey_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Age gad amaga galuc mec, cel ceteh eu Anut amegna matu? Age madegina, gold eu matufo, qee tempel eu matufo? Age dogina, gold eu tempelna bilina eunu tempel eu gold odudeceb gold eu Anutnu qagu bilina. Eunu tempel eu gold wooldona. ");
INSERT INTO aey_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Odocob age je madegina, ‘Dana oso uqa ihanec cabal ijanna mele ohis ena eu ceteh gauc. Euqa uqa ihanec ceteh cabalna bibilen euna mele ohis ena, cois uqa maden odi odigian,’ egina. ");
INSERT INTO aey_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Age amaga galuc mec, cel ceteh eu Anut amegna matu? Age madegina, ihanec ceteh cabalna bilina eu matufo, qee ihanec cabal eu matufo? Age dogina, ihanec ceteh eu ihanec cabalna bilina eunu ihanec cabal eu ihanec ceteh odudeceb ihanec ceteh eu Anutnu qagu bilina. Eunu ihanec cabal eu ihanec ceteh wooldona. ");
INSERT INTO aey_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Eunu dana uqa ihanec cabalna mele ohis ena eu uqa ihanec cabalnaca ihanec ceteh cunug cabalna bilina eunaca mele ohis ena. ");
INSERT INTO aey_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Odocob dana uqa tempelna mele ohis ena eu uqa tempelnaca Anut uqa tempelna bilina eunaca mele ohis ena. ");
INSERT INTO aey_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Odocob dana uqa sao jobonna mele ohis ena eu uqa Anutna cabal bilecnaca Anut uqa uqana cabal bilecna bilina eunaca mele ohis ena,” aden. ");
INSERT INTO aey_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","24","“O loo je iwaladec Farisica, age agena ceelum filfil cabinadec am 10-pela qatanadimeig am osol eu Anut utegina. Age Anutna loo je ceteh nagnu geh cisdogina euqa Anutna loo je ceteh caunca eunu qee cisdogina. Age dana gesiladecnu kobol tutucca, waug qocca, wawaga meleecca eunu qee cisdogina. Age ceteh caunca ceteh nagca osoben odoubqa age qee odoloin. Age dado madec qa amaga galuc mecca! Age agena sabna galalec nag cedi helegina euqa kamel belucdocobil nona. Eunu age me hihili coboc dana! Age walocca!” aden. ");
INSERT INTO aey_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“O loo je iwaladec Farisica, age agena gabinca bohca hibo eu gaid wasacudegina euqa age wawaga dunuhna heje oc kobolca ija didih ecca nijia. Eunu age me hihili coboc dana! Age walocca! ");
INSERT INTO aey_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hina Farisi, amen galuc mecca. Casac hina gabinca bohca waug dunuh wasacudagale. Odocom hibo nijia euha soidoc migian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","“O loo je iwaladec Farisica, age odi qalqalna meen hatin uqana gelgel age camasac waia senenecna baial joidein cinigwe. Qalqal meen hatin eu gelgel camasac fecnu galeca qa dunuhna cal mec dana tob tefulunuga ceteh gegehinca nijia. Eu odiwe ageha dana amagana meciadec eu tutuc odoc fegina qa wawaga dunuhna eu qauecca loo je tefacdocca nijia. Eunu age me hihili coboc dana! Age walocca!” aden. ");
INSERT INTO aey_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","31","“O loo je iwaladec Farisica, age je hahun madec dana agena qalqal meen hatin cehegina, age dana cajaca ititom agena amegu bala me bahic megina. Age odi oodoig madegina, ‘Jajanigeil bilein saen euna ege biloummiqa ege jajanigeil odoin eu ege qee odoum, ege je hahun madec dana aqocomun qee cal moub,’ egina. Eu madecnana age ege dana ebenega je hahun madec dana agena golanagaca eundec agena mel biluquna ec eu camasac megina. Eunu age me hihili coboc dana! Age walocca! ");
INSERT INTO aey_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Eunu jajanagail age silail gumna o danecebil gemona tawen eu age o danecebil am bena. ");
INSERT INTO aey_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Age man sononec me qee, age man sononec nag! Anut gesiladeceb eu adi oloqanih jana nuecnu cagasoqagan?” aden. ");
INSERT INTO aey_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","35","“Eunu feiga. Dana cajaca ititom cunug mahana bilein eu age golanaga basecdocob age dewenegana hugian. Age wele dana cajaca ititom aqecebil cal mein eu Ebelna golac basecdoc sanijec euna sanan mimei ehi lili Sekaraiana golac basecdoc ihoc len. Sekaraia, uqa Berekaia melah, age tempel hamol gunna ihanec cabalca gemona qocobil cal men. Wadacdoc eu cunug ititom sihul i dewenegana hugiannu ija je hahun madec danaca, Anutnu doc silecca danaca, Anutna je iwaladecca suladecemin ageca loqagan. Eundec age leih aqecebil cal moqagan. Leih na babalecna tuitu aqimeig caqusadecebil caculimeig cal moqagan. Leih age agena cuha jonana qisaadimeig aqati tootooadoqagan. Jobon osona bibilebil ititacadecebil busali jobon osona li bibilebil tooadi li ititacadoqagan. ");
INSERT INTO aey_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ija mele maadigina, aqecebil cal mein eu uqana ameg me qee oc cunug dana caja qila bilegina i dewenegana hugian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas je haun maden, “O Jerusalem, Jerusalem, Anut uqa uqana je hahun madec dana ageca suladeceb lein. Euqa age meenna aqecebil cal mein. Ija saen mati bahic mala anag uqana nag hojonna jahuladigen imei utaadenawe agena dana cajaca gabanadimig ahutecnu gale tena, euqa age ijaca hocnu culein. ");
INSERT INTO aey_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","39","Ija maadigina, age ija qila haun qee mecituwain leceb age madoqagan: ‘Dana eu uqa Tibud ijanna hona Anut uqa eeldoiale,’ odi madimeig mecituqagan,” en. Eunu Anut uqa agena jobon culdina, odocob agena jo moti heleceb tawigian, dana euna qee biluwain. ");
INSERT INTO aey_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas uqa tempel culimei nunuen uqana malogom uqaca humeig age tempel uqa galeca kobolkobolca cehein taweia eu ihacdocnu odoin. ");
INSERT INTO aey_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Euqa uqa maaden, “Qila age eu cunug fegina. Ija mele maadigina, meen gel ulugedocob meen oso meen oso tatacanna cilehdoc qee biliaun. Cunug wagalecebil mahana tonoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas uqa hibna Oliw Aluhna bibilen uqana malogom cuhanuc uqaca limeig sisildu madoin, “Aadeb eu odi odigian? ec magaga doqa. Cel gaga odocob fimeb hinana ceseli hoc saen cali hona doqan? Adi odocob fimeb mahamaha bilec saen hedugia odona ec doqan?” doin. ");
INSERT INTO aey_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Odocob Jisas jejenega hewi maaden, “Matica age ija ijanina mamadi hoqagan, ‘Ija Krais, ija dana Anut uqana dana caja cahahaadecnu wele nesili ehuden,’ oqagan. Eu age dana cajaca mati faninadi jic ceja qocna loqagannu dado madoqagan. Eunu oso hu faninadi dado madeceb agena jic ceja qocna lowainnu batut feigale. ");
INSERT INTO aey_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Age han cadegina ec eunuca han hugian ec eunuca je hutan doqagan. Batut feigale. Ceteh eu cunug odigian. Eunu cain filicituwain. Euqa qee migian ec madecnu qee nijel. Eu cit qoc qee. ");
INSERT INTO aey_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ge, dana hatuhatu age cajimeig cilehdocobcilehdocoboqagan. Odocobil dana sihulsihul age cajimeig cilehdocobcilehdocoboqagan. Sabnu cahel bilec saen ha hugian, mim ha maha filfilna nigian. ");
INSERT INTO aey_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Eu odoc cunugqa caja mel basecnu dain donawe odi himec sanan migian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Odi odocob age dewenega tudocnu dana ebenegana madecebil eu age aqecebil cal moqagan. Mahamaha cunug agenu age ija ijani hewegina eunu age agenu gemanaga beceb sagagadoqagan. ");
INSERT INTO aey_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Odi odocobil mati age ijanu wawaga meleec eundec wawaga lecisca meceb age ob meceb ob meceb i cobimeig sagagdocobsagagdocobi biluqagan. ");
INSERT INTO aey_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Uhulec je hahun madec dana matica ha camas mimeig age dana cajaca mati faninadi jic ceja qocna loqagannu dado madoqagan. ");
INSERT INTO aey_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Saen euna Anutna loo je toodu tutuc madec tonigian. Dana age loo je cilehdudu casisic odadec fulusdocob nalug mec eu dana mati wawagana daigian. ");
INSERT INTO aey_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Euqa oso uqa waug gagadic mumudi hib cit qoc gadacna caligian eundec Anut cahahaadigian. ");
INSERT INTO aey_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anutna culnu me je eu mahamaha cunug qasali maadecebil ihoc lili ninijeb dana cajaca cunug dodobil hib cit qoc deel cali hugian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jisas je haun maaden, “Age ‘ihulahal mec ceteh bebesacca’ tempel gunna tataweb foqagan, je hahun madec dana, Daniel, eunu je wele maden eu camas meceb eunu batut feigale,” aden. Dana uqa je i sanijina eu uqa je uqana gug doiale. ");
INSERT INTO aey_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Saen euna age ceteh eu fimeig dana cajaca age Judia hatuna bilegina age busali aluhnana toboqagan. ");
INSERT INTO aey_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Oso jo ohis tatacan bilecnu cudunna bilina uqa tonimei uqana edud cedi jo dunuh lecnu cain cisdoiaun. ");
INSERT INTO aey_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Oso cabina bilina eu uqa uqana lotoc cecelac cedecnu jobon cain hoiaun. ");
INSERT INTO aey_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Saen euna caja waugca coboc, caja mel sim su adegina eundec walocca bahic biluqagan! ");
INSERT INTO aey_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Busalec deel eu duan saenca cuha deelca cali hoiaunnu Anut inondoigale. ");
INSERT INTO aey_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ge, saen euna culumen ben bahic hugian. Gug qoc saen maha ifanennadec hocob qila wele culumen eu odi oso qee calel. Hibna ha culumen eu odi oso haun qee caleiaun. ");
INSERT INTO aey_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Anut saen i gohic qee mudoubmi dana cajaca cunug age fadaloub. Euqa dana cajaca Anut nesili ceden bilegina agenu saen eu gohic migian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","“Saen euna uhulec Kraisca uhulec je hahun madec danaca mati cali humeig age ihocfi dana cajaca Anut nesili ceden bilegina euha faninadi jic ceja qocna lecnu dado madoqagan imeig gaga filfilca kobolkobol benbenca odoqagan. Eunu oso maadecebfi, ‘Feiga, Krais ihen!’ qee, ‘Krais ono bilia!’ adecebfi wawaga cain meleeiaun. ");
INSERT INTO aey_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Feiga, ceteh qee hoc ninijen ija ceteh eu hugiannu wele maadiga. ");
INSERT INTO aey_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","Amel faleec cam tobi becna sao ohis camas mimei iletec cam toni nocna ihoc lenawe Dana Melah uqa cali hocnu saen odi camas migian. Eunu age maadecebilfi, ‘Krais wadauna bilia,’ adecebilfi age ono cain nui fowain, odocob ‘Krais hamol bilia,’ adecebilfi age wawaga cain meleeiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Dana cal mec deweg ganac huluec oso ninijen man fululec benben cababac cinigwe age euna ceguluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jisas je haun maaden, “Feiga, saen euna culumen ben eu hedocob ‘cam tu meceb jagel qee fulacdoiaun. Odocob malaqa age saonadec casili tonoqagan, odocob saona gagadic odoc eu caji leceb hocob qeleloqagan,’” aden. ");
INSERT INTO aey_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Odocob Dana Melah uqana camas mec gaga saona camas migian. Odocob dana sihunugail cunug mahana bilegina age qada qaqaji biluqagan. Age Dana Melah gagadic odocca kobolkobol benca sao taenna neneb foqagan. ");
INSERT INTO aey_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Uqa uqana ensel taul ben fuldocca suladeceb age belimeig uqana nesili cedec bilegina eu cunug cedoqagan. Age cam tobi becnadec cedadi ehadi li cam toni nocnadec ha ehadi ahu gabandoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jisas je haun maaden, “Age na dan uqana odocnu cisdoigale. Uqa haun majocob age wa hoc saen qila sanan mena egina. ");
INSERT INTO aey_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Odiwe ha age ceteh eu cunug oodob fimeig Dana Melah hugiannu taun gel jic cebecna taweia eigale. ");
INSERT INTO aey_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ija mele maadigina, sihul i qila bilegina ceteh qee cali hoc ninijeb qee qee meiaun. ");
INSERT INTO aey_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Saoca mahaca qee migian euqa ijana je qee qee meiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jisas je haun maaden, “Ceteh eu cali hugiannu deelca auaca oso qee dona. Ensel sao jobon ono ha qee dogina. Dana Melahha qee dona. Memige Anut himec dona. ");
INSERT INTO aey_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noa bilen saenna dana cajaca bileinwe Dana Melahna hoc saenna odi ha biluqagan. ");
INSERT INTO aey_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Wa sil ben qee cajec age sab ji wain ji bibilegin dana caja ocobocobi bibilegin leceb Noa wag benna tobec deelna odi odoin, ageqa qee doloin. ");
INSERT INTO aey_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Odocob wa sil ben cajimei dana cajaca cunug fadaladen. Eu odiwe dana cajaca ageha odi oodobil Dana Melah uqana deelna hugian. ");
INSERT INTO aey_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Odocob saen euna dana lecis cabina biluwasan. Oso ehudi beloqagan, oso eu tacewudoqagan. ");
INSERT INTO aey_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Caja lecis ale wit meenna ibuldudu biluwasan. Oso ehudi beloqagan, oso tacewudoqagan. ");
INSERT INTO aey_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Age agena Tibud aadeb hugian eu age qee dogina. Eunu amaga cebac bileigale! ");
INSERT INTO aey_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Euqa ceteh i doiga. Dana jo gug uqa heje dana aadeb hu ijana ceteteh heje ugian eu doialumi uqa us qee nijoub, cebac bibili cagucagdoub. Odimei uqa heje dana culdocob uqana jo qeih qatanimei dunuh qee loub. ");
INSERT INTO aey_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Age Dana Melah uqa qila hugian qee ec saen euna mele hugian. Eunu age saciadoc susumudi bileigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jisas je haun maaden, “Cel cabi dana uqa doc meca uqana cabi cofdu cuhadona? Eu oso uqa uqana meca uqana jo cofdoc muden. Uqa cabi dana cunug cofadigian. Agena sab saennana adigian. ");
INSERT INTO aey_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Cabi dana eu saen uqana meca jobon ceseli humei odi oodob fecidumei uqa ben bahic ceeligian! ");
INSERT INTO aey_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ija mele maadigina, uqana meca uqana ceteh cunug cofdugiannu ebenna migian. ");
INSERT INTO aey_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Euqa cabi dana me qee eu uqadodoc madimei, ‘Ijana meca uqana hocnu deel cecelac nijia,’ imei ");
INSERT INTO aey_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","cabi dana hijagul eu uqa aqecnu sanan mimei dana eu cedeceb osoben sab jiji wain jiji dalul aqeceb cocobil ");
INSERT INTO aey_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","meca eu hibna deel osona hugian. Eu saen cabi dana uqa hugiannu qee cisdoc saen euna hugian ec qee doc ninijeb hugian. ");
INSERT INTO aey_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Uqana meca eu odi fimei qeti susul faligiannu ihoc bahic. Odimei cudun dana Anutnu wawaga qee meleec bileginana cabi dana me qee euna mudigian. Ono age qada qaqaji maimaga kicodudu biluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisas je haun maaden, “Saen euna sao cul jobon eu odiwe mel aid taula 10-pela bilein agena dodo. Dana oso caja haun ocobocobec uqa hugiannu bilen. Mel aid taula eu age agena gowoc cedi li age jicna gulucdumeig ehudi ahoqagannu lein. ");
INSERT INTO aey_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mel aid taula 5-pela age dalawan mec, 5-pela age docca. ");
INSERT INTO aey_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mel aid taula dalawan mec eu age agena gowoc cedi ahoin qa age mool leih cedimeig qee holoin. ");
INSERT INTO aey_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Euqa mel aid taula docca age mool agena gumna o danimeig gowocca hewadi ahoin. ");
INSERT INTO aey_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Dana eu caja haun ocobocobec eu uqa mahuc qee hol. Odocob mel aid taula eu age amaga culumen teceb us nijein,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Odocob tu gemo dana oso odi utaeceb doin, ‘Dana eu uqa caja haun ocobocobec eu hona. Age hoiga, ege beli jicna gulucdumeb ehudi ahoqagan,’ en. ");
INSERT INTO aey_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mel aid taula eu age cunug cajimeig agena gowoc saciadoin. ");
INSERT INTO aey_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mel aid taula dalawan mec eu age mel aid docca eu odi maadein, ‘Egena gowoc cafuligia odona. Agena mool naha cesawigeiga,’ adein. ");
INSERT INTO aey_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Odocob mel aid taula docca eu jejenega hewi odi maadein, ‘Qeeo, ege mool eu egenuca agenuca ihoc qee. Eunu age cois stuana belimeig agedodoc agena fajeiga,’ adein. ");
INSERT INTO aey_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Odocob mel aid taula dalawan mec 5-pela age mool fajecnu wele bebelegin dana caja haun ocobocobec eu hon. Odocob mel aid taula leih saciadu bilein age uqaca jo dunuh ocobocobec sab ben lecebil dana age jic cebec menein,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Hibna mel aid taula leih age humeig madoin, ‘Tibud, Tibud, hu ege jic cebec hudigaga,’ doin. ");
INSERT INTO aey_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Euqa uqa jejenega hewi maaden, ‘Ija mele maadigina, ija agenu qee dugina,’ aden,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Odimei Jisas je oso tubdu maaden, “Age qee dodobil cel deelna cel auana agena Tibud uqa hugian. Eunu amaga cebac bileigale!” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jisas je haun maaden, “Sao cul jobon eu odiwe nijia. Dana cehewanca oso uqa hatu oso nuigia bili uqana cabi dana utaadeceb hocobil uqana meen qaig age ebenegana men. ");
INSERT INTO aey_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Uqa cabi dana dumanaganu cisdumei age dumanaga nijen eu odi toodu uqana meen qaig siwiaden. Oso uqa kina 5,000 uten, odimei oso uqa kina 2,000 uten, odimei oso uqa kina 1,000 uten. Uqa odi odimei nuen. ");
INSERT INTO aey_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nueceb dana uqa kina 5,000 on eu mahuc limei idadoc cabi megameg meceb kina 5,000 haun oso umei Ben uqana meen qaig euca gabandon. ");
INSERT INTO aey_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Eu odiha dana kina 2,000 on eu uqa cabi ocna kina 2,000 haun ocob kina 4,000 men. ");
INSERT INTO aey_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Euqa dana kina 1,000 on eu uqa nuimei maha heel hunimei uqana Benna meen qaig jahunen,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Saen meca gieceb dana ben uqa humei uqana cabi dana meen qaig aden eu agena cabi oc eunu togodoin. ");
INSERT INTO aey_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Odi odimeig dana kina 5,000 on eu uqa humei dana ben madon, ‘Ben fagale, hina kina 5,000 item. Ija cabi ocna kina 5,000 haun oso om ihen,’ don. ");
INSERT INTO aey_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Odocob uqana Ben madon, ‘Cois, hina cabi dana megameg mec me bahic! Ija nag ebenna mem eu hina cofdu cuhadumeg cabi megameg mem. Ija mati bahic ebenna mihigen. Ceeli bilec hinana Ben uqa saciadon eu ocnu ijana jona lagale,’ don,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Odocob dana kina 2,000 on euha humei uqana Ben madon, ‘Ben fagale, hina kina 2,000 item. Ija cabi ocna kina 2,000 haun oso om ihen,’ don. ");
INSERT INTO aey_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Odocob uqana Ben madon, ‘Cois, hina cabi dana megameg mec me bahic. Ija nag ebenna mem eu hina cofdu cuhadumeg cabi megameg mem. Ija mati bahic ebenna mihigen. Ceeli bilec hinana Ben uqa saciadon eu ocnu ijana jona lagale,’ don,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Odocob dana kina 1,000 on eu uqa humei uqana Ben madon, ‘Ben, ija hinanu hina dana gagadic, hina cehelo qee cehec euna limeg aig comogona, cabina hina sab qee cehelem euna li cedi cili jagana eu ija dom. ");
INSERT INTO aey_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ija hina cucuihimig li hinana meen qaig mahana jahunem. Faga, hinana meen qaig ihen. Haun ogale,’ don,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Odocob uqana Ben madon, ‘Hina cabi dana me qee, hina cabi ol! Ija cehelo qee cehelem euna limig aig comigina, ija cabi qee cehelem euna limig casili cili jigina eu hina dom. ");
INSERT INTO aey_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Eu melefi eunu hina ijana meen qaig eu qaig mec jona moum eu nag odi meca moubmi qila humig ijanaca nag haun sabijecca oum,’ don. ");
INSERT INTO aey_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Uqa maaden, ‘Uqana kina 1,000 cawaldumeig uqana kina 10,000 nijen uteigale,’ aden. ");
INSERT INTO aey_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Uqa maden, ‘Ge, oso uqana ceteteh nijia eu utecebil mati bahic uqana biligian. Euqa oso uqa cetehca qee bilina eu Anut uqa uqana nag nijia eu cawaldugian. ");
INSERT INTO aey_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Cabi dana caunca qee eu helecebil jobon hahagum nui tu gagatuccana biligian. Ono age qada qaqaji maimaga kicodudu biluqagan,’ en,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jisas je haun maaden, “Dana Melah uqa isi kobolkobolca uqana ensel cunugca gami toni nimeig uqa uqana king bilec cabal kobolkobolca euna biligian. ");
INSERT INTO aey_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dana cajaca mahamahadec age cunug hu ceguli uqa amegna tawoqagan. Sipsip cofadec uqa sipsip mecmec amnadec qagu madenawe uqaha cunug odi qagu madigian. ");
INSERT INTO aey_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Odimei uqa sipsip eundec eben meulana isec madigian. Euqa uqa mecmec eundec eben ansena isec madigian. ");
INSERT INTO aey_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","King uqa odi odadimei dana cajaca ititom age eben meulana isec tawegina eundec maadigian, ‘Age ija wen teten bibiligin sab itein. Ija wa gab teten bibiligin wa itein. Ija jag bibiligin ehiti bilec cudun itein. Ija bical bibiligin age lotoc taqitein. Ija hagca bibiligin age hu soatein. Ija gihacdoc jona bibiligin age hu mecitein. Eunu Mei eeladen age hoiga, Anut uqa maha gug men saen euna uqana cul agenu saciadon eu mugumuga men qila nijia eu oiga,’ adigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Uqa odi maadeceb dana cajaca ititom age madoqagan, ‘O Tibud, ganih wen hehen mecihimeb sab ihom? Ganih wa gab hehen mecihimeb wa ihom? ");
INSERT INTO aey_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ganih jag bibilegen mecihimeb ehihom? Ganih bical bibilegen mecihimeb lotoc taqihom? ");
INSERT INTO aey_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ganih hagca bibilegenca gihacdoc jona bibilegenca li mecihom?’ doqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Odi madocobil king jejenega hewi maadigian, ‘Ija mele maadigina, age ija cotiel i age ijanagaca qee odadein eu odi age ijaha oditein,’ adigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","43","“Odi maadimei dana cajaca age eben ansena isec tawegina eundec odi maadigian, ‘Age ija wen teten bibiligin sab qee itelein. Ija wa gab teten bibiligin wa qee itelein. Ija jag bibiligin qee ehitelein. Ija bical bibiligin lotoc qee taqitelein. Ija hagca bibiliginca gihacdoc jona bibiliginca qee hu mecitelein. Eunu Anut geladen age cuculti ja cijeceb catanena euna nui bileiga. Eu Setennuca uqana enselnuca saciadon nijia,’ adigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Odi maadeceb madoqagan, ‘O Tibud, ganih wenca, wa gabca, jag bibilegenca, bical bibilegenca, hagca bibilegenca, gihacdoc jona bibilegenca mecihimeb qee cewel uholom?’ doqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Odi madocobil jejenega hewi maadigian, ‘Ija mele maadigina, age cotiel i age ijanagaca qee eundec qee odadelein eu odi ijaha qee oditelein,’ adigian. ");
INSERT INTO aey_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Odi maadeceb dana cajaca eundec age dain adeceb catanec euna nui gaid biluqagan. Euqa dana cajaca ititom eu age cebac bilec catanec euna li gaid biluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas uqa je eu cunug maadi hedumei uqana malogom maaden, ");
INSERT INTO aey_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Eledec Pasowa Sab Jec Ben Deel hugian eu age dogina. Deel euna age Dana Melah Juda dana qee eundec ebenegana mudecebil age uqa na babalecna tuitu qumeig caqusecebil caculimei cal migian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Saen euna ihanec dana benbenca Juda agena matuca age ihanec dana agena ilo, ijan Kaiafas, uqana jona cegulimeig ");
INSERT INTO aey_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","age Jisasnu qaqahani jahuni hewi qocnu jic oso wali feqan imeig togodoin. ");
INSERT INTO aey_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Euqa age madein, “Dana caji uqanu mimi ege cilehgowainnu Pasowa Sab Jec Ben cegulecna cain odoqaun,” ein. ");
INSERT INTO aey_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas uqa Betani jobon ono Saimonna jona bilen. Saimon eu uqa wele deweg lepra hag heweceb coboloi. ");
INSERT INTO aey_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Age ono sab jiji bibilegin caja oso meen gum eu mool dedeman me bahic fajecnu qaig ben bahic nijen eu ahumei mool eu Jisas ilona basecdon. ");
INSERT INTO aey_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Euqa Jisasna malogom age eu fimeig qee gale adel, eunu gemanaga beceb madein, “Mool eu meen qaig ben bahicna idadoubmi meen qaig eu dana sawen bilec eundec siwiadoub eu me. Eunu eu meen qaig cusdoc eetanu odona?” ein. ");
INSERT INTO aey_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas uqa malogom agena je dumei maaden, “Uqa me bahic oditia. Age eetanu caja eunu je madegina? ");
INSERT INTO aey_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ge, age gemona dana sawen bilec eundec gaid biluqagan. Ijaqa gaid age gami qee biluqaun. ");
INSERT INTO aey_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mool ilomina basecdoia euna uqa ija deweni heelna cisecnu saciadoia. ");
INSERT INTO aey_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ija mele maadigina, dana age me je maha cunug anaana qasali maadi cobimeig age caja eu oditia eu uqanu cisdoqagannu saadoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Odocob malogom 12-pela eu gemodec oso, uqa ijan Judas Iskariot, uqa ihanec dana benben cemenegana limei maaden, ");
INSERT INTO aey_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Ija Jisas age ebenegana mudecemin eeta oso ituqagan?” aden. Odocob age uqa meen qaig silwana mudec 30 utein. ");
INSERT INTO aey_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Odocobil saen euna bahic Judas uqa Jisas dewegnu ob mimei age ebenegana mudigiannu jic oso walen. ");
INSERT INTO aey_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Odocob Pasowa ja qoc bred jisca qee jecnu uqana deel gun cali hon. Jisas uqana malogom uqaca humeig sisildudu madoin, “Ege ana hinaca Pasowa sab jeqannu saciadocnu gale hena?” doin. ");
INSERT INTO aey_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Odocob uqa jejenega hewi maaden, “Age taun benna limeig dana eu je madoiga, ‘Iwalgec maheia, “Ijana saen cali hoia. Ija ijana malogom gami Pasowa ja qoc hinana jona jeqan,” heia,’ doiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Odocob malogom belimeig Jisas jejeg toodu odoin. Age Pasowa ja qoc saciadoin. ");
INSERT INTO aey_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Odocobil witic meceb Jisas uqana malogom 12-pela gami sab jec cabalna bilein. ");
INSERT INTO aey_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sab jiji bibileig Jisas maaden, “Ija mele maadigina, age oso ija cad ebenegana mitigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Odocob age je eu dumeig waloc adeceb abesabes sisildudu madoin, “Tibud, hina ija ec madaganafo?” doin. ");
INSERT INTO aey_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Odocobil jejenega hewi maaden, “Oso uqa eben ija gami sab wehuc bohna tanoqa eu uqa ija cad ebenegana mitigian. ");
INSERT INTO aey_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Dana Melah uqa wele Anutna jaqec je jaqen odi toodugian eunu je eu toodugian qa dana uqa ija cad ebenegana mitigian eu walocca biliale! Dana eu anag qee basoubmi eu me bahic nijoub,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Odocob Judas, uqa Jisas cad ebenegana muden, eu Jisas madon, “Meca, hina ija ec madaganafo?” don. Odocob Jisas madon, “Hina madaga odi,” don. ");
INSERT INTO aey_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Age sab jejeig Jisas bred oso umei Anut hetaga dumei feni malogom siwiadimei maaden, “Eu ija deweni. U jeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Odimei uqa wain gabin umei Anut hetaga dumei malogom adimei maaden, “Wain gabin i ija golani eu Anutna bal cehec je haun. Ija Anut uqa dana cajaca mati agena silail cagasiadigiannu golani basecdugen. Age cunug wain eu jeiga. ");
INSERT INTO aey_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ija mele maadigina, ija wain qee jec li hibna ija age gami Meina culna haun jeqan,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Odocob age binan sulec due silimeig age taun ben cuculi Oliw Aluhna belein. ");
INSERT INTO aey_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Odocob Jisas uqa malogom maaden, “Anutna jaqec je oso nijia eu ihen: ‘Ija sipsip cofadec dana qocomin sipsip cunug bilisadu beloqagan’ ec nijia. Eunu witic ina ceteh ijaca caleceb age cunug ijanu wawaga meleec tonigian. ");
INSERT INTO aey_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Euqa hibna Anut uqa tuliteceb ija ceseli cajimig aquniadi Galili ono nuigen,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Odocob Pita madon, “Leih cunug age ceteh hinaca caleceb fimeig hinanu wawaga meleec tonigianfo ija qee dugina, ijaqa qee bahic qee hinanu wawi meleec toneiaun,” don. ");
INSERT INTO aey_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Odocob Jisas uqa Pita jejeg hewi madon, “Ija mele mahigina, witic ina mala manahal qee qoc ninijeb hina madegan, ‘Uqanu qee dugina,’ i cijeddogan,” don. ");
INSERT INTO aey_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Odocob Pita madon, “Ija hinaca cal mewan eu nijecebfi ija hinanu qee qee sasac qugaun,” don. Odocob malogom cunugha je odi madein. ");
INSERT INTO aey_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas uqana malogomca cocobi li cudun oso, Getsemani egina, euna calimeig maaden, “Age ene bibilebil ija eu usec limig Anut inondudu biligen,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Odimei uqa Pitaca Sebedi melahul lecisca ehadeceb limeig Jisas waug me qee meceb duman culeceb ");
INSERT INTO aey_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","malogom maaden, “Dumani culia, cal mecnu odi oditina. Age ene cebac bibili ija gami mecioqale,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Odi maadimei uqa nag odi qisacadi nuimei uqa ni mahuli ola maha mecidu nijimei Memeg inondon, “Mei, gabin i ija wooltecnu jic nijecebfi odocom woolti nuiale. Ija madigina eu qee odigaunqa hina madagana eu toodu odigen,” don. ");
INSERT INTO aey_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Odimei uqa malogomca limei age us ninijegin feciadimei Pita madon, “Age eundec oso ijaca aua osol cebac bilecnu uen qee nijelfo? ");
INSERT INTO aey_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cebac bibili inondoigale, age temadecna lowainnu. Wawaga odigen ena euqa dewenega gagadic odocca qee,” don. ");
INSERT INTO aey_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Odi madumei uqa lecisdu ceseli li Memeg inondon, “Mei, gabin i woolti nuecnu jic qee nijecebfi ija jigen, eu hina madagana eu ihoc ligian,” don. ");
INSERT INTO aey_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Odimei caji haun ceseli malogom cemenega limei age us ninijegin feciaden. Ge, age amaga mumugcanu eu mecii bilecwe qee. ");
INSERT INTO aey_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Uqa cuculadi haun ceseli li Memeg wele madon odi cijeddu inondon. ");
INSERT INTO aey_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Uqa malogomca ceseli humei maaden, “Age gaid jaen mumudi bileig us nijeigafo? Feiga, saen wele hoia! Age qila Dana Melah silail dana ebenegana muduqagan. ");
INSERT INTO aey_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Cajecebil beloqa. Feiga, dana ija deweninu balijigian eu wele hona,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Uqana malogom maaaden Judas, malogom 12-pela eundec oso, uqa hon. Uqa gami dana mati bahic age han siginca han galabca hewi hoin. Ihanec dana benbenca Juda agena matuca age suladecebil hoin. ");
INSERT INTO aey_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aria, dana uqa Jisas uqana cad ebenegana mudigiannu maden eu uqa wele han dananu gaga oso mecnu maaden, “Dana ija cotdugen eu uqa heweiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Odocob Judas uqa mahuc Jisasca limei madon, “O Meca, feele!” don. Odimei uqa Jisas cotdon. ");
INSERT INTO aey_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Odocob Jisas madon, “Ijana danah, hina eeta odocnu hoga eu mahuc odoga,” don. Odocob han dana age humeig Jisas eben gagadic hewein. ");
INSERT INTO aey_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Odocobil dana oso Jisasca gami tawein eu eben nocob han sigin umei ihanec dana ilona cabi dana qelimei dahig cagon. ");
INSERT INTO aey_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Odocob Jisas uqa madon, “Hinana han sigin uqana cudunna haun tacaga. Ge, cunug age han siginna cadegina eundec han siginna aqecebil cal moqagan. ");
INSERT INTO aey_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ija ija Mei ninidocomin uqa mahuc ensel han am 12-pela wooldoc suladeceb humeig cesultecnu ihoc nijia eu qee dogonafo? ");
INSERT INTO aey_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Euqa ija odi odocominfi jaqec je eu Anutna jaqec jena nijia eu ceteh i ihoc ligiannu ec maden eu adi ihoc ligian?” don. ");
INSERT INTO aey_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Saen euna Jisas dana am ben maaden, “Eetanu age han siginca han galabca heje oc dana cinigwe ija hewituqagannu hoiga? Ija deel cunugnana tempelna dana cajaca iwalaadi bilolig. Odocob age ija hewitecnu oso qee odoloin. ");
INSERT INTO aey_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Euqa Anutna je hahun madec dana agena jaqec je ihoc ligiannu ceteh i cunug calen,” aden. Odi maadeceb uqana malogom cunug qisacdu busali belein. ");
INSERT INTO aey_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Odocob dana age Jisas hewein eu age ehudi ihanec dana agena ilo, Kaiafasna gunna mudein. Ono Juda agena loo je iwaladecca matuca cegulein. ");
INSERT INTO aey_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Euqa Pita Jisas tabag hehewi toodu ihanec dana ilo uqana jo gel dunuh len. Uqa gel dunuh limei tempel cofdoc dana gami bilein. Uqa Jisas cel ceteh odudecebil figiannu cisdon. ");
INSERT INTO aey_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aria, ihanec dana benbenca, Juda dana ben cunug age ceguleinca age Jisas dewegnu ob mec je amagana fec dahinigana doc eundec je walein. Oso camas meceb eu toodu geldocomun cal migian ein. ");
INSERT INTO aey_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Odocobil dana mati bahic dewegnu ob mecnu cajimeig odi oodon fom, odi mamaden dom, uhulii madein. Euqa age ob mec je oso qee gulucdoloin. Age odi odocobil dana lecis cajimesi ");
INSERT INTO aey_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","madesin, “Dana eu maden, ‘Ija Anutna tempel wagalimig deel cijedna haun cehecnu ihoc,’ en,” esin. ");
INSERT INTO aey_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Odocobil ihanec dana agena ilo tawimei Jisas madon, “Dana lecis i hina dewennu cel je balijesina? Hina jejenela je oso qee hewi madaganafo?” don. ");
INSERT INTO aey_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Euqa Jisas uqa jejeg qee hewel. Odocob ihanec dana ilo uqa Jisas sisildu madon, “Ija Anut cebac bilecca ijanna mahigina, hina Anutna Kraisfo? Hina Anut Melahfo? ec Anut amegna madaga doqa,” don. ");
INSERT INTO aey_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Odocob Jisas madon, “Hina madagana odi himec. Ijaqa maadigina, hibna age Dana Melah uqa Anut gagadic odocca eben meulana isec bibileb sao taenna hohob foqagan,” don. ");
INSERT INTO aey_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Odocob ihanec dana ilo uqana lotoc hewi balahadumei maaden, “Uqa Anut lelandoia. Ege eetanu dewegnu je oso waleqan? Uqa Anut lelandoia eu age cunug dah meiga. ");
INSERT INTO aey_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Age eeta madegina?” aden. Odocob age madein, “Uqa cal migiannu deweg je nijia,” ein. ");
INSERT INTO aey_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Age odi madecebil leih age Jisas ola cin qumeig deweg tudoin. Leih siho qaqahi ");
INSERT INTO aey_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","madoin, “Hina Anutna Krais. Eunu je hahun magaga! In dewen tudoia magaga doqa?” doin. ");
INSERT INTO aey_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Age Jisas geldodogin Pita uqa maha gumu bilen. Bibilen cabi mel aid oso cemenug humei madon, “Hinaha Jisas Galilidecca bilein,” don. ");
INSERT INTO aey_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Odocob Pita cunug amagana qee sasac qu mel aid madon, “Hina madagana eu ija dadanigina,” don. ");
INSERT INTO aey_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Uqa gesacna jo gel jic cebecna isec leceb cabi mel aid oso ono mecidumei uqa ono tawein eundec maaden, “Dana i uqaha Jisas Nasaretdecca bilein,” aden. ");
INSERT INTO aey_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pitaqa haun je cagocna qee sasac qu madon, “Anut amegna madigina ija dana eu qee dugina,” don. ");
INSERT INTO aey_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Saen nag gieceb ono tawein eundec age hu Pita madoin, “Mele bahic hinaha eundec oso. Hinana jejen eu hina Galilidec camas mihina,” doin. ");
INSERT INTO aey_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Odocob agena kobolna uqa mele bahic mamadi maaden, “Ija dana eu qee dugina,” aden. Madeceb mala manahal qon. ");
INSERT INTO aey_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Odocob Pita Jisas wele madon, “Mala manahal qee qoc ninijeb hina ijana biligina eu qee sasac qu cijeddogan,” don eunu dahig fogo docob jo eu cuculi nui ben bahic qajen. ");
INSERT INTO aey_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Walag daneceb ihanec dana benbenca Juda agena matuca cunug gabandumeig age Jisas qocobil cal migiannu je togodoin. ");
INSERT INTO aey_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Togodu hedumeig age Jisas eben libimeig ehudi limeig Rom gabman dana matu, Pailat, ebenna mudein. ");
INSERT INTO aey_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas uqa Jisas dewegnu ob men eu uqa age Jisas qoqagannu geldocobil dumei uqa Jisasnu ob mennu deweg cijeceb waug tucien. Uqa meen qaig silwana mudec 30 ahu ihanec dana benbenca Juda agena matuca eundec ceseli adimei ");
INSERT INTO aey_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","maaden, “Ija silail migan. Ija dana deweg jeca qee uqanu ob migan,” aden. Odocob age uqa jejeg hewi madoin, “Eu egena je qee. Eu hinana,” doin. ");
INSERT INTO aey_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Odocobil Judas uqa tempelna meen qaig silwana mudec 30 eu heleceb nocob tempel cuculi nuimei uqa be qagi caculimei cal men. ");
INSERT INTO aey_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Euqa ihanec dana benben age meen qaig silwana mudec 30 eu cedimeig togodudu madein, “Meen qaig silwana mudec 30 eu golacca, eu dana qonnu fajec eunu ege tempel cabinu meen qaig gabandocnu eu cois qee,” ein. ");
INSERT INTO aey_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Age togodu wawaga osol meceb nuimeig meen qaig silwana mudec 30 euna hal qagec dana uqana maha fajein. Maha eu dana ono jag bibili cal mein age heel cisadecnu qalqal biligiannu eu fajein. ");
INSERT INTO aey_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eunu maha eu ijan Golac Maha qoin. Eu qila ageha odi madegina. ");
INSERT INTO aey_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Eu odocna, je hahun madec dana Jeremaia, je maden eu ihoc len. Jaqec je eu wele odi madena: “Age meen qaig silwana mudec 30 oin. Eu Isrel dana caja age dana eu fajudecnu ameg odi gadac mein. ");
INSERT INTO aey_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Meen qaig euna age hal qagec dana uqana maha oso fajein. Tibud maten odi odoin,” ena. ");
INSERT INTO aey_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas uqa gabman dana matu amegna tatawen gabman dana matu sisildu madon, “Juda agena king eu hinafo?” don. Odocob Jisas jejeg hewi madon, “Hina madagana eu odi himec,” don. ");
INSERT INTO aey_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Euqa ihanec dana benbenca Juda agena matuca age dewegnu je um qu mamadegin jejenega qee hewel. ");
INSERT INTO aey_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Odocob Pailat uqa Jisas madon, “Age dewennu je mati madegina eu qee dah melemfo?” don. ");
INSERT INTO aey_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Euqa Jisas jejeg qee hewel. Uqa dewegnu je madec osol dihnu ha je qee wadacdu madel. Eunu gabman dana matu eu geh cisdon. ");
INSERT INTO aey_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pailat uqa Juda agena Pasowa Sab Jec Benna gaid gihacdoc dana oso Juda dana age ceguli togodudu ijan madecebil uqa besituadoloi. ");
INSERT INTO aey_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Saen euna dana oso gihacdoc jona bilen eu uqa me qee odocnu binanca eu ijan Barabas. ");
INSERT INTO aey_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Pailat uqa Juda dana ben age Jisasnu macumac mimi uqa ebenna mudein eu don. Eunu Juda dana age ceguli bibilegin Pailat sisiladi maaden, “Qila in besituadigennu madegina, Barabasfo, qee Jisasfo age uqanu Krais egina?” aden. ");
INSERT INTO aey_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat uqa odi gesiladec cabalna bibilen uqa aideg je odi suldocob hu madoin, “Ija witic i bebelecna uqa ola codigannu culumen ben tena. Eunu hina dana ititom i ceteh oso cain odudugaun,” doin. ");
INSERT INTO aey_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ihanec dana benbenca Juda agena matuca age Juda dana cajaca wawaga hunecebil age Pailat Barabas besitugagale, Jisas na babalecna qogale doqagannu jajahiladi hedoin. ");
INSERT INTO aey_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Odocobil gabman dana matu haun hu maaden, “Dana lecis bilesina eu in besituadigen?” aden. Odocob age madoin, “Barabas,” doin. ");
INSERT INTO aey_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat sisiladen, “Ija Jisas age uqanu Krais egina eu eeta odudigen?” aden. Odocob age madoin, “Na babalecna tuitu qoga!” doin. ");
INSERT INTO aey_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Odocobil uqa maaden, “Eetanu? Uqa cel qisol mec odon?” aden. Euqa age haun utai madoin, “Na babalecna tuitu qoga!” doin. ");
INSERT INTO aey_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat uqa ija cilehadecwe qee age hihibanaga teceb figina imei uqa boh oso umei wa o danimei uqa age amagana eben cucusi maaden, “Ija dana i deweg jeca qee eu uqa golac ebenina qee fagdoiaun. Eu agena himec,” aden. ");
INSERT INTO aey_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Odocob dana cajaca cunug age jejeg hewi madoin, “Uqa golac ege dewenigena ege begawigeil dewenegana ha gad hoiale,” doin. ");
INSERT INTO aey_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Odocob Pailat uqa Barabas besiaden. Odimei uqa han dana maadeceb age Jisas ehudimeig qisadoin. Qisadu hedocobil uqa Jisas na babalecna tuitu qumeig caqusecebil caculimei cal mecnu han dana ebenegana muden. ");
INSERT INTO aey_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gabman dana matu uqana han dana age Jisas ehudimeig jo gabman dana ben bilia euna lein. Age gabman dana ben uqana cudunna mudein. Odimeig age han dana am cunug utaadecebil humeig osoben cegulein. ");
INSERT INTO aey_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Age lotoc hulitumeig lotoc golca oso eu king agena bala cinigwe tacitoin. ");
INSERT INTO aey_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Odimeig age halu dud lalic qumeig king katakat mudimeig gulodutoin. Odimeig age sih oso ebenna mimeig amegna gob cehimeig lelandudu madoin, “O Juda agena king, feele!” doin. ");
INSERT INTO aey_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Odimeig age cin qudimeig sih u ilo qisadoin. ");
INSERT INTO aey_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Age lelandu hedumeig lotoc golca hulitumeig uqana lotoc haun tacitoin. Odimeig age ehudi li na babalecna tuitu qocnu belein. ");
INSERT INTO aey_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Age cali hohoig han dana age Sairinidec dana oso fein, uqa ijan Saimon. Age madocobil Jisasna na babalec gahidon. ");
INSERT INTO aey_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Belimeig age cudun, ijan “Golgota,” ono calein. Golgota ijan gug eu “Ilo gatic cudun.” ");
INSERT INTO aey_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Age wain ceteh gulihinca gabandoc eu jecnu Jisas utein. Euqa uqa ji fimei eu culen. ");
INSERT INTO aey_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Age Jisas na babalecna tuitu qumeig caqusecebil caculeceb uqana lotoc agedodoc satu udodoig siwi cedein. ");
INSERT INTO aey_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Odimeig age bilimeig ono mecidudu cofdoin. ");
INSERT INTO aey_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Age dewegnu je ob mein uqa ilo ohisna jaqi qoin, “Dana i Jisas, uqa Juda agena King,” ec jaqein. ");
INSERT INTO aey_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Age Jisas cemenug heje oc dana lecis na babalecna tuitu aqalimeig caqusalecebil caculesin. Oso eben meulana isec caculen, oso eben ansena isec caculen. ");
INSERT INTO aey_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Odocob dana cajaca age hu li i bileig age lelandudu ilomoga culidudu ");
INSERT INTO aey_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","madein, “Hina tempel wagalimig deel cijed hedocob haun cehigen em, hinadodoc cahahadoga! Hina Anut Melahfi na babalecnadec toni naga,” ein. ");
INSERT INTO aey_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ihanec dana benbenca, loo je iwaladecca, Juda agena matuca ageha lelandudu madein, ");
INSERT INTO aey_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Uqa leih cahahaaden euqa uqadodoc cahahadocnu ihoc qee. Uqa Isrel agena King. Eunu uqa qila na babalecnadec toni neiale. Uqa odi odocobfi ege uqanu wawige meleigian. ");
INSERT INTO aey_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Uqa Anutnu waug meleena. Uqa maden, ‘Ija Anut Melah,’ en. Eunu Anut uqanu gale docobfi Anut qila besitoiale,” ein. ");
INSERT INTO aey_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Odocob heje dana ale uqa gami na babalecna tuitu aqalein eu aleha odi lelandosin. ");
INSERT INTO aey_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Odocob cam gemo ceheceb cam tu qocob hatu cunug gagatuc menen, ninijen li 3 kilok wesu. ");
INSERT INTO aey_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Odocob 3 kilok odi Jisas co suli u utai maden, “Eli, Eli, lama sabaktani?” en. Je uqana gug eu odi: “Ijana Anut, ijana Anut, eetanu qisactaga?” en. ");
INSERT INTO aey_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dana leih age ono talildu tawein je eu dah mimeig madein, “Dana eu uqa Ilaija utadona,” ein. ");
INSERT INTO aey_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Age oso mahuc guguli gege oso umei wain gulihinca tanumei balac oso euna gihacdumei suladu ehi li jecnu cona men. ");
INSERT INTO aey_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Euqa leih madein, “Sumuduga. Culecem ege uqa Ilaija humei cahahadugianfo, qeefo ec feqan,” ein. ");
INSERT INTO aey_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Odocobil Jisas haun co suli u utaimei kis umei cal men. ");
INSERT INTO aey_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Odocob lotoc ben tempel hamol gunna caqusec tawoloi eu ohisdec baladu ni mahana cali lecisdon. Odocob mim neceb meen ulugedon. ");
INSERT INTO aey_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Qalqal meen hatin eu hudeceb Anutna dana cajaca mati bahic wele cal mein qila i age cajein. ");
INSERT INTO aey_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Age qalqal culimeig hibna Jisas ceseli cajeceb age Anutna jobon gun dunuh lein. Dana mati bahic age meciadein. ");
INSERT INTO aey_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Odocob Rom agena han ilo dana 100 cofadecca age uqaca tatawi Jisas cofdoin eu age mim neceb ceteh caleceb eu fimeig cumuni madein, “Mele bahic, dana i uqa Anut Melah!” ein. ");
INSERT INTO aey_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Caja matiha onoca tatawi fein. Age Jisas cesuldudu Galilidec toodu cocobi hoin. ");
INSERT INTO aey_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Age gemodec eu Maria Makdaladecca, Maria uqa Jems Josefca analaca, Sebedi melahul lecis analaca. ");
INSERT INTO aey_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cam toni nonon dana cehewanca oso, ijan Josef, uqa Juda agena jobon nag Arimatiadec, uqa hon. Uqa Jisasna malogom oso. ");
INSERT INTO aey_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Uqa Pailat amegna limei Jisas deweg ganac ugiannu sisildon. Odocob uqa maadeceb age Jisas deweg utein. ");
INSERT INTO aey_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Odocob Josef uqa Jisas deweg ganac umei lotoc senenec soidoc jeulden. ");
INSERT INTO aey_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Odimei uqa uqana meen hatin aluh qeih hunein euna mudein. Heel eu dana oso qee mudec Jisas casac mudein. Uqa meen koldoc ben oso olocdocob eu hatin jic cebec cufa qon. Odimei nuen. ");
INSERT INTO aey_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdaladecca Maria osoca ale hatin amegna onoca bilesin. ");
INSERT INTO aey_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Deel ceteh saciadoc hedocob deel osona ihanec dana benbenca Farisica age li Pailat fein. ");
INSERT INTO aey_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Age odi madoin, “Dana Ben, ege je oso odi cisdoqona, uhulec dana i saen uqa cebac bilec je oso maden. Uqa odi maden, ‘Hibna deel cijed hedocob ceseli cajigen,’ en. ");
INSERT INTO aey_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Eunu hina gad madecem age cois limeig deel cijed ihoc ligiannu qalqal hatin eu cufa qu cuhadoqagan. Qee dodomun uqana malogom age humeig deweg ganac heje u belimeig age dana cajaca uhulec je odi maadowain, ‘Uqa cal mecnadec ceseli cajeian,’ adowain. Eu agena uhulec je haun eu, eu uhulec je wele maden eu wooldocdain,” doin. ");
INSERT INTO aey_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Odocobil Pailat odi maaden, “Age han dana cedi hewi belimeig maadecebil qalqal hatin eu cofdu tawoqagan. Age belimeig ceteh cunug age odocnu madegina eu qalqal hatin eu gagadic cufa qoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Odocob age beli qalqal hatin cufa qu cuhadoin. Age gun mudecnu sisi mec oso meen heel cufa qocna tawen eu tatacan mein. Odimeig age han dana qalqal hatin cofdocnu madein. ");
INSERT INTO aey_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Juda agena cuha deel hedocob cuhana deel osoldocna walag danigia oodon Maria Makdaladecca Maria osoca ale qalqal hatin fecnu belesin. ");
INSERT INTO aey_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Odocob mim ben nen. Ge, Tibudna ensel oso sao jobondec nimei hu meen ben hatin jic cebec cufa qon eu olocdumei meen tatacan bilen. ");
INSERT INTO aey_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Uqa ola eu amel faleecnu cinigwe. Uqana lotoc eu senenec bahic. ");
INSERT INTO aey_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Odocob han dana age qalqal hatin cofdoin eu age uqanu cucuii qeqeli dana cal mec cinigwe ibuldoin. ");
INSERT INTO aey_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Euqa ensel uqa caja maalen, “Jisas age na babalecna tuitu qocobil cal men eu walesina eu dugina. Eunu cain cucuiuwasin. ");
INSERT INTO aey_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Uqa madenwe uqa odi ceseli cajeia. Uqa ene qee bilel. Humesi cudun nijen eu fowasan. ");
INSERT INTO aey_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Fimesi mahuc ceseli limesi ale uqana malogom Jisas cal mecnadec ceseli cajeia ec maadesia. Uqa aquniadi nui Galili hatuna caligian. Ono age fecidoqagan. Fesia, eu ija maaliga,” alen. ");
INSERT INTO aey_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eunu ale cucuii ben bahic ceeli qalqal hatin mahuc cuculesi uqana malogom saadowasannu guguli belesin. ");
INSERT INTO aey_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Odocobil Jisas uqa jicna gulucalimei maalen, “Feele,” alen. Ale uqa cemenug hu uqa jaih hewimesi gob cehi uqanu cuha fesin. ");
INSERT INTO aey_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Odocobil Jisas maalen, “Cain cucuiuwasin. Ija cotiel age Galili hatuna beleiga ec maadesia. Age ono fecituqagan,” alen. ");
INSERT INTO aey_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Caja ale ensel maalenwe bebelesin Jisasna qalqal hatin cofdu bilein han dana eundec leih age Jerusalem humeig ihanec dana benben je cunug saadein. ");
INSERT INTO aey_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Age Juda agena matu cunug utaadecebil age cegulimeig je eunu togodoin. Age wawaga osol meceb age han dana meen qaig mati adimeig maadein, ");
INSERT INTO aey_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Age dana cajaca cocobi maadeiga, ‘Ege us ninijuqun uqana malogom age humeig Jisas deweg ganac heje umeig ehi belein,’ je eu maadeiga. ");
INSERT INTO aey_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Je eu gabman dana matu dufei uqa age me qee odadeiaunnu co cufa qoqan,” adein. ");
INSERT INTO aey_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Odocobil han dana age meen qaig umeig ihanec dana benben age maadein odi maadi coboin. Je eu Juda dana ha gaid mamadi li qilaha mamadi cobogina. ");
INSERT INTO aey_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Malogom 11-pela age cocobi Galili belein. Age aluh Jisas age wele euna loqagannu maaden euna lein. ");
INSERT INTO aey_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Odocob euna Jisas fein. Age amegna gob cehimeig uqanu cuha fein. Euqa leih age cisdoc lecisca. ");
INSERT INTO aey_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas uqa cemenega humei odi maaden, “Anut uqa ceteh cunug agena ilo miten. Uqa ceteteh cunug mahanaca sao jobonnaca cofadecnu gagadic odocha iten. ");
INSERT INTO aey_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Eunu age mahamaha cunug beladimeig dana cajaca ijana malogom madeiga. Age Memige Anut ijanna, uqa Melah ijanna, Kis Gun ijanna wa joadeiga. ");
INSERT INTO aey_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Age je ija maadolig eu cunug age adem cunug iwaladecebil toodu odoqagannu maadeiga. Dogina, ija dudu age gami deel cunugna biluquna qila ina leceb mahamaha bilec saen deel euna qee migian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","I Jisas Krais uqana me je sanan mec, uqa Anut Melah. ");
INSERT INTO aey_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anutna je hahun madec dana, Aisaia uqa je jaqen eu odi calen: “Feiga, ija ijana sos suldocomin aqunihi nuigian. Uqa hinana jic saciadugian. ");
INSERT INTO aey_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Dana jejeg oso wadauna bibili utai maadena, ‘Tibudna jic saciadoiga. Uqana jic tutuc mudeiga,’ adena,” en. ");
INSERT INTO aey_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Odocob Wa Joadec Jon uqa wadauna camasac men. Uqa dana cajaca je qasali maaden, “Agena silailnu tului falicdumeig wa joadec oiga. Odi odocobilfi Anut uqa agena silail cagasiadigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dana cajaca Judia hatuna bileginaca, dana cajaca Jerusalem bileginaca age cunug Jonca lein. Limeig age agena silailnu je qasali madocobil Jon uqa Jodan Wana wa joaden. ");
INSERT INTO aey_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon uqa kamel bagicna lotoc mudec tacoloi, odimei uqa wailohna dool ganacna oologam mudec taqoloi, odimei uqa sisca mehud uqana waca joloi. ");
INSERT INTO aey_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Uqa dana cajaca je qasali maaden, “Dana oso uqa hib tooti hugian, uqana gagadic odoc ijana gagadic odoc wooldona. Uqa dana meca bahic. Ijaqa dana meca qee. Ija uqana cabi dana me bahic ihoc qee, ija jogoimig uqana jaih tacec halu cufalitocwe qee. ");
INSERT INTO aey_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ija age wana wa joadigina qa uqa age Kis Gunna wa joadigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Saen euna Jisas Nasaretdec Galili hatuna hocob Jon Jodan Wana wa jouden. ");
INSERT INTO aey_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Odocob Jisas wanadec cali beceb mahucwe sao ohis jic cebec hudeceb Kis cuhudid cinigwe uqaca nenen tebandu fen. ");
INSERT INTO aey_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Odocob jejeg oso sao ohisdec camas mi madon, “Hina ija melami nalunin migina. Ija hinanu wawi ben ceelena,” don. ");
INSERT INTO aey_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Saen euna bahic Kis uqa Jisas u suldocob wadauna nuen. ");
INSERT INTO aey_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Uqa wadauna deel 40 cunug Seten temdodon bilen. Uqaha dool cusca ono bilen. Uqa odi bibilen ensel age cewel utoin. ");
INSERT INTO aey_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Aria, age Jon hu hewimeig gihacdoc jona mudi hedocobil Jisas Galili hatuna limei cocobi Anutna me je qasali mamadi maaden. ");
INSERT INTO aey_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Uqa maaden, “Saen Anutna cul cali hoia nijia. Anutna cul eu age cemenega hona. Agena silailnu tului falicdumeig me jenu wawaga meleeiale,” aden. ");
INSERT INTO aey_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Saen Jisas Galili wa gad cagocna cocobi dana oso waliagca fecialen, eu Saimon uqa waliag Andruca. Ale cimec ben wana hehelesin fen. Ge, ale cul dool cedec dana. ");
INSERT INTO aey_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Odocob Jisas maalen, “Hu tootecebil ija odalecemin ale dana cajaca cedadec dana calowasan,” alen. ");
INSERT INTO aey_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Odocob mahuc bahic ale cimec ben cuculesi uqa toodu belesin. ");
INSERT INTO aey_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Uqa nag bahic onoca limei dana oso waliagca haun fecialen, eu Jems uqa Sebedi melah, uqa waliag Jonca. Ale alena wagna bibilesi cimec ben tatalec eu haun wewegi bilesin. ");
INSERT INTO aey_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisas mahucwe utaalen. Odocob ale memela Sebedi uqana cabi danaca wagna bibilegin cuculadi limesi Jisas toodu belesin. ");
INSERT INTO aey_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Age Kapaneam jobon hoin. Odocobil mahucwe Juda agena cuha deelna Jisas uqa Juda agena cuha jo dunuh limei je maadi iwaladen. ");
INSERT INTO aey_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Uqa agena loo je iwaladec dana oso cunug maadeinwe odi qee maadel qa uqa dana oso, Anutna gagadic odocca madenawe, odi iwalaadi maaden. Eunu uqa je eu maadi mamaden dana cajaca age wawaga cacaden bilein, uqana iwaladec je eu wawaga qon. ");
INSERT INTO aey_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ono deel euna bahic dana oso uqa buga me qeeca bilen, buga eu gegehinca uqana jo ibuldon. ");
INSERT INTO aey_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Uqa utai Jisas madon, “O Jisas Nasaretdec, hina eetanu odigigana? Hina fadalgecnu hogafo? Ija hina cel dananu dugina. Hina dana gun eu Anut suldocob nen,” don. ");
INSERT INTO aey_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Euqa Jisas buga me qee eu cahacdudu madon, “Je culuga. Dana cuculdi qisacdoga,” don. ");
INSERT INTO aey_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Odocob buga me qee gegehinca eu dana odudeceb uqa titi hudeceb qelelen. Odocob geh bahic euimei dana eu cuculdi qisacdon. ");
INSERT INTO aey_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Odocob dana cajaca cunug tumatumaimeig agedodoc madocobmadocobi sisilein, “Eu eeta? Dana i je haun iwalgena! Uqa Anutna gagadic odocca buga me qee gegehinca eundec dih maadeceb age co toodu odogina,” ein. ");
INSERT INTO aey_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Odocob Jisas hutan hatuhatu mahucwe ihoc len, Galili hatuna alildu bilein euha cunug doin. ");
INSERT INTO aey_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas mahucwe Juda agena cuha jo eu culdimei cocobi Saimon Andruca alena jona len. Uqa gami Saimon Andruca, Jems Jonca age jo dunuh lein. ");
INSERT INTO aey_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ono Saimon momoig uqa hag deweg daincaca hulen cabalna nijen. Odocob Jisas ono li caleceb mahucwe uqa caja hag nijennu madoin. ");
INSERT INTO aey_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Odocobil Jisas caja cemenug limei eben hewi cesuldocob cajen. Odocob hag deweg dainca hulen eu culdeceb caji sab saciadumei cewel uaden. ");
INSERT INTO aey_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Odocob wesu men cam toneceb age hag aqecca buga me qee hewadecca eundec cedadi Jisasca ahoin. ");
INSERT INTO aey_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Odocob dana cajaca age jobon ben euna bilein age cunug Jisas bilen jo eu amegna cegulimeig bilein. ");
INSERT INTO aey_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jisas uqa hag gug filfil nijein mati bahic me maden. Uqa buga me qee dana deweneganadec hewadein mati bahic ititacadeceb dana cuculadi belein. Buga me qee age Jisasna gug doin eunu uqa eundec cahacadeceb je qee madelein. ");
INSERT INTO aey_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Qasil bahic walag qee danec tu ninijen Jisas caji jo culimei cudun tiliec bahicna, dana oso qee bilec, euna nuimei ono uqa Anut inondudu bilen. ");
INSERT INTO aey_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Odocob Saimon uqaca bilein eundecca Jisas wawali toodoin. ");
INSERT INTO aey_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Uqa gulucdumeig madoin, “Dana cunug wawalhi cobogina,” doin. ");
INSERT INTO aey_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Odocobil Jisas maaden, “Ija me je qasali maadigennu caji lem. Eunu ija jobon cunug alilgi bilegina eundec dana cajaca me je qasali maadigennu ege jobonjobon coboqale,” aden. ");
INSERT INTO aey_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Odimei Jisas uqa Galili hatuna jobonjobon cocobi Juda agena cuha jonana me je qasali mamadi maadimei buga me qee eundec uqa dana deweneganadec ititacadeceb dana cuculadi belein. ");
INSERT INTO aey_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Saen euna dana oso deweg lepra hagca Jisasca humei uqa amegna gob cecehi Jisasnu cuha fefei ninidudu madon, “Hina ija me mitiga hecebfi ija me mitecem ijana hag culteceb ija Anut amegna cataniec bilecnu ihoc,” don. ");
INSERT INTO aey_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Odocob Jisas dana eunu walol docob eben huleldumei deweg qududodoi madon, “Ija me mihiga tena. Me maga!” don. ");
INSERT INTO aey_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Saen eunadih lepra hag eu uqa dewegna culdeceb deweg hul hon. ");
INSERT INTO aey_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Odocob Jisas uqa dana eu gagadic madon, “Dah maga, ceteh inu oso cain bahic sadudu cobogaun. Euqa li dewen nawel tawec ihanec dana eu hina dewen ihacdocom maleldugian. Odimeg Moses loo je wele maden eu toodumeg hina qila Anut amegna cataniec biliga dana cajaca cunug ihacadecnu Anut ihandogale,” don. Madu hedumei mahuc suldocob nuen. ");
INSERT INTO aey_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Dana euqa uqa nunui feei je eu cunug saadi cobon, hatuhatu cunug je eu doin. Odonnu Jisas uqa camasac jobon osona lecwe qee. Uqa jobon hahagum maha danaca qee euna biloloi. Euqa dana cajaca age hatu nahanaha cunugdec uqa cemenug hoin. ");
INSERT INTO aey_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Deel leih hedocob Jisas ceseli Kapaneam jobon hu jona bibilen uqa hutan camas meceb dumeig ");
INSERT INTO aey_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","dana cajaca mati bahic hu cegulein. Jo cunug ihoc leceb cudun oso bilecnu ihoc qee. Jo cebecna ha ihoc len bibilegin Jisas me je qasali maaden. ");
INSERT INTO aey_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Odi bibilegin dana 4-pela age dana laleg hagca oso gabagabna ninijen hehewi ehudi ahoin. ");
INSERT INTO aey_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dana cajaca age gitim bahic bibilegin age Jisas amegna ehi li mudecnu jicca qeenu age jo ohis tobein. Tobimeig Jisas tawenna jo qab iwesdumeig gabagab dana nijen eu halu bagimeig Jisas tawen uqa amegna gulucuhdogin nen. ");
INSERT INTO aey_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Odocobil Jisas age wawaga meleen fimei dana jaih ebenca laleg mec madon, “Melami, hinana silail cagasihiga qee meia,” don. ");
INSERT INTO aey_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ono Juda agena loo je iwaladec eundec osooso dana gemona bilein. Age Jisasna je uqa dana laleg mec eu madodon dumeig filiciti wawagana madein, ");
INSERT INTO aey_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Dana i adi je odi madena? Uqa Anut cewudec je madena! In silail cagasiadecnu ihoc? Eu Anut himec uqa ihoc,” ein. ");
INSERT INTO aey_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Age odi wawagana mamadegin Jisas mahucwe agena cisdoc eu waugna dumei maaden, “Age wawagana eetanu je i madegina? ");
INSERT INTO aey_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Cel je madecnu cacanigca qee? Ija dana laleg hagca i madugen, ‘Hinana silail cagasihiga qee meia,’ dugenfo, qee ‘Cajimeg hinana gabagab u hewimeg jic coboga,’ dugenfo? ");
INSERT INTO aey_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Euqa Dana Melah mahana silail cagasiadecnu gagadic odoc ebenna nijia eu doqagannu ihacadigen,” aden. Odimei uqa dana laleg hagca madon, ");
INSERT INTO aey_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ija hina mahigina, cajimeg hinana gabagab umeg gahidu jobon nuuga,” don. ");
INSERT INTO aey_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Odocob uqa cajimei mahucwe age amagana uqana gabagab u hewi nuen. Dana cajaca ono age odi oodon fimeig age cunug tumatumaimeig Anut binan susuli madein, “Ege wele oso odi qee oodon folom,” ein. ");
INSERT INTO aey_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas haun ceseli Galili wa cagoc lanna nu bibilen dana cajaca mati bahic uqaca hocobil je maadi iwaladen. ");
INSERT INTO aey_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Odimei uqa jic cobi nunui uqa Alfias melah, Liwai, takis cedec jona bibilen fen. Fimei madon, “Tootaga,” don. Odocob Liwai uqa cajimei Jisas toodu nuen. ");
INSERT INTO aey_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Odocob hibna Jisas uqa Liwaina jona sab jejei bilen. Bibilen takis cedec danaca, silail danaca, mati ageha Jisas uqana malogomca gami sab jejegin bilein. Ge, dana mati bahic Jisas toodoin. ");
INSERT INTO aey_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Odocob loo je iwaladec age Farisi sihul eundec age Jisas uqa silail danaca takis cedecca gami sab jejegin fimeig age uqana malogom maadein, “Uqa eetanu takis cedecca silail danaca eundec gami sab jegina?” adein. ");
INSERT INTO aey_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Odocobil Jisas je eu dumei maaden, “Hagca qee age hag me madec danaca qee legina. Qeeo. Hagca himec age hag me madec danaca legina. Ija ititom dana cajaca ‘Age agena silailnu wawaga tului falicdoigale,’ ec utai maadecnu qee holom. Euqa ija silail dana cajaca ‘Age agena silailnu wawaga tului falicdoigale,’ ec utai maadecnu hom,” aden. ");
INSERT INTO aey_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Saen oso hibna Wa Joadec Jon uqana malogomca Farisi agena eundecca age Juda agena kobol toodu sabnu qagu bilein. Odocobil dana leih humeig Jisas sisildoin, “Eetanu Wa Joadec Jonna malogomca Farisi agena malogomca gaid esuesu sabnu qagu bilegina qa hinana malogom eu qee sabnu qagu bilegina?” doin. ");
INSERT INTO aey_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Odocobil Jisas jejenega hewi maaden, “Age dana caja ocobocobecna cegulein bilegina eunu age caja oc dana eu gami bibileig adi sabnu qagu biluqagan? Qeeo, caja oc dana eu age gami bibileig cain sabnu qagu biluwain. ");
INSERT INTO aey_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Euqa saen oso hibna dana leih hu caja oc dana cawaladecebil deel euna age sabnu qagu biluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Oso uqana lotoc hilah giloccanu eu eeldugia bili, uqa lotoc fan haun qee cusec tatacan qee gisena. Eu odi odoubmiqa age lotoc cusecebil fan haun eu nag meceb eu gesacna haun ceseli balahadu bendoub. Wele balahadon eu wooldu qatanoub. ");
INSERT INTO aey_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Odiha oso uqa wain haun jool mecmec ganacna mudec hilahna qee o danena. Jool mecmec ganacna mudec eu galalec eunu odoubmiqa wain haun eu jool ganacna mudec hilah qatanoub, wain basecdu cusdoub, odocob jool ganacna mudecha qatani cusdoub. Qeeo, age wain haun jool mecmec ganacna mudec haunna o danegina,” aden. ");
INSERT INTO aey_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Juda agena cuha deel osona Jisas uqana malogom gami cocobi wit cabi osoosona gemogemo li beli coboin. Bebeli cocobi uqana malogom age wit aig wal mec tawen qu u ehi lein. ");
INSERT INTO aey_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Oodogin Farisi leih age Jisas madoin, “Faga, hinana malogom eetanu ceteh oso egena cuha deelna loo je cahacgena eu odogina?” doin. ");
INSERT INTO aey_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Odocobil Jisas jejenega hewi maaden, “Age Dewid odonnu je oso qee sanijeleinfo? Uqaca uqana eundec age gami coboinca age wele sabca qee bilimeig wen adeceb ");
INSERT INTO aey_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","uqa Abaiata ihanec dana ilo bibilen saen euna Anutna jona limei Anutnu ihanec bred oso u jen. Bred eu dana gauc jecnu Mosesna loo je cahacaden. Nawel tawec ihanec dana age himec jecnu cois ena. Dewidha dana age uqaca coboin bred eu adeceb osoben jein,” aden. ");
INSERT INTO aey_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisas odi maadimei maaden, “Anut uqa cuha deel saolal mudigia bili dana eunu qee ifani madel qa Anut uqa dana me biluqagannu cuha deel muden. ");
INSERT INTO aey_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Eunu Dana Melah uqa Tibud, uqaha cuha deel uqana ilo bilina,” aden. ");
INSERT INTO aey_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisas haun Juda agena cuha jo dunuh len. Ono dana oso uqa eben gatoc men bilen. ");
INSERT INTO aey_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dana leih ono bilein eu age Jisas uqa cuha deelna dana eben gatoc men me mudigianfo eunu cofdudu mecidoin. Uqa odi odocobfi ege dewegnu je um qoqan ec cisdoin. ");
INSERT INTO aey_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Odocobil Jisas dana eben gatoc men eu madon, “Ene hogale,” don. ");
INSERT INTO aey_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Odimei dana sisiladi maaden, “Cuha deelna ege dana me odadecnu loo je cois ec madenafo, qee ege dana waadecnu cois ec madenafo? Cuha deelna ege dana cahahaadecnu loo je cois ec madenafo, qee ege dana aqocomun cal mecnu cois ec madenafo?” aden. Uqa odi maadeceb age conoga culec bilein. ");
INSERT INTO aey_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Odimei Jisas uqa talilaadi meciadimei gemag ben. Age wawaga tool ibuldon eunu waug me qee men. Odimei dana eu madon, “Hina eben heli huleldoga,” don. Odocob uqa eben heli huleldocob me men. ");
INSERT INTO aey_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Odocob Farisi age cuculdi nuimeig Herodna dana eundecca mahuc cegulecebil age Jisas qoqagannu jic wawali je togodoin. ");
INSERT INTO aey_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas uqana malogom gami Galili wa gad cagocna ceseli belein. Dana cajaca am ben bahic Galili hatunadec tooadi belein. Leihha age Judia hatunadec, ");
INSERT INTO aey_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","leih Jerusalemdec, leih Idumia hatunadec, leih Jodan Wa ono isecdecca, leih Taia Saidonca alildu bilein eunadecca, dana cajaca mati bahic age Jisas uqa odi odona ec dumeignu uqaca hoin. ");
INSERT INTO aey_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Dana cajaca mati bahicnu age Jisas gihacguhucdowainnu uqa uqana malogom maadeceb uqa wag osona tobigiannu gaid saciadu mudecebil tawen. ");
INSERT INTO aey_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ge, uqa mati bahic me maden. Eunu dana caja hagca eundec age Jisas deweg hewi feqan imeig uqa cemenug bahic lecnu gihacdodi gagadic bahic mein. ");
INSERT INTO aey_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Buga me qee age dana cajaca deweneganadec cali hu bebeli Jisas fecebil dana cajaca age amegna toni mahulimeig utai madein, “Hina Anut Melah!” ein. ");
INSERT INTO aey_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Euqa Jisas uqa buga me qee age uqana gug camas mowainnu cahacaden. ");
INSERT INTO aey_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Odocob Jisas aluh guhidocna ti bilen. Odimei dana age uqaca biluqagannu gale don eundec utaadeceb uqa cemenug hoin. ");
INSERT INTO aey_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Uqa dana 12-pela age uqaca biluqagannuca age suladeceb Anutna me je qasali maadecnuca nesili ehaden. Dana eu uqa aposel ijan qon. ");
INSERT INTO aey_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Uqa age buga me qee dana deweneganadec ititacadecnu cabi eu ebenegana men. ");
INSERT INTO aey_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aposel 12-pela ijanaga eu odi. Eu Saimon, Jisas uqa ijan oso Pita ijan qon. ");
INSERT INTO aey_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Eu Jems Sebedi melah waliag Jonca, Jisas uqa ijanala oso Boanesis ijanala qon. Ijanala gug eu qeli qocna mel. ");
INSERT INTO aey_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Eu Andruca, Filipca, Batolomjuca, Matjuca, Tomasca, Jems uqa Alfias melahca, Tadiasca, Saimon uqa Selot agena amdecca, ");
INSERT INTO aey_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskariotca. Judas Iskariot uqa hibna Jisasnu balijimei uqana cad ebenegana muden. ");
INSERT INTO aey_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Odocob Jisas jobon nuen. Dana cajaca mati bahic age haun cegulecebil Jisas uqana malogomca sab jecnu saenca qee. ");
INSERT INTO aey_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Odocob Jisas uqana eundec age uqa sab qee jec cabi onanu dah mimeig madein, “Uqa gad qoia,” ein. Eunu age uqa ehudoqagannu belein. ");
INSERT INTO aey_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Odocobil loo je iwaladec dana age Jerusalemdec nein eu age Jisasnu madein, “Bielsebul, buga me qee agena ben, uqa dana eu hewudena. Uqa Bielsebul uqana gagadic odocna buga me qee dana deweneganadec ititacadena,” ein. ");
INSERT INTO aey_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Odocobil Jisas dana eu utaadeceb uqaca hocobil galolo je maaden, “Seten uqana eundec adi ititacdugian? ");
INSERT INTO aey_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Hatu osona mam cadecebilfi cul eu gagadic tawecnu ihoc qee. ");
INSERT INTO aey_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sihul osona mam cadecebilfi sihul eu gagadic tawecnu ihoc qee. ");
INSERT INTO aey_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Odocob Seten uqana eundec age mam cadecebil qatanec bilecebfi uqa gagadic tawecnu ihoc qee. Euqa uqa toni qocob qee migian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Oso uqa dana gagadicca uqana jona li uqana ud cawaldocwe qee, uqaqa casac li dana eu eben jaihca libimei uqana ud cawaldecnu ihoc,” aden. ");
INSERT INTO aey_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ija mele maadigina, silail oso cunug dana megina eu Anut uqa dana agena silail cagasiadigian. Dana age Anutnu lelan madegina euha Anut uqa dana agena silail cagasiadigian. ");
INSERT INTO aey_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Euqa Kis Gunnu lelan madec eu dana silail cagasitocnu qee nijel. Oso Kis Gunnu je me qee madenafi silail eu saen qila inaca leceb saen bilec catanecnaca silail cagasec qee gulucdoiaun. Euqa uqana silail deweg fagdocob catanigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ge, age Jisasnu madein, “Uqa buga me qeeca,” ein. Eunu uqa odi maden. ");
INSERT INTO aey_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jisas uqa dana cajaca je maadi bibilen uqa anagca waliagulca gami calein. Age jo maha gumu tataweig je suldocobil dunuh len. Uqa ageca hugiannu utadoin. ");
INSERT INTO aey_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dana cajaca amemeg Jisas taldoin bibilegin madoin, “Faga, hina anin walinelca gami maha gumu taweiga. Age hina ageca legannu madegina,” doin. ");
INSERT INTO aey_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Odocobil Jisas jejenega hewi maaden, “Ija au in? Ija waliel an?” aden. ");
INSERT INTO aey_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Odimei uqa dana cajaca age alildu bilegina eu uqa talilaadi meciadimei maaden, “Feiga! Ija au walielca ihen! ");
INSERT INTO aey_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Oso uqa Anut co toodu odona eu uqa ija walica, ija cebinamica, ija auca,” aden. ");
INSERT INTO aey_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas haun Galili wa gad cagocna dana cajaca je iwaladi maaden. Dana cajaca age mati bahic uqaca humeig talildu cegulein. Eunu uqa wag oso tobi wag macas tatacan ninijen uqa euna bilen. Bibilen dana cajaca cunug age wa cagoc lanna tawein. ");
INSERT INTO aey_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tatawegin uqa je mati galolo jena iwaladi maaden. Uqa iwaladec je oso maaden, ");
INSERT INTO aey_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Dah meiga! Dana oso uqana cabina wit aig helecnu nuen. ");
INSERT INTO aey_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Uqa aig hehelen aig osooso jic cobocna tonen. Odocob man fululec age humeig cedi ji hedoin. ");
INSERT INTO aey_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aig osooso maha eu meen baibaca maha meca qee euna tonen. Maha eu dunuh qee nol eunu aig eu mahuc qala qahimei nag wasen. ");
INSERT INTO aey_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Odocob cam gagadic taweceb eu cijaden. Odocob bebeig dunuh qee nol eunu qala jajawalen. ");
INSERT INTO aey_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aig osooso dud geuna tonen. Dud eu mahuc caji ben mimei ceteh cilehdocobil mahulimei aig qee qol. ");
INSERT INTO aey_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aig osooso eu mulu mahana tonen. Odocob qala qahimei ben mi aig qon. Aig oso qoc 30 ihoc len, osooso 60 ihoc len, osooso 100 ihoc len,” ");
INSERT INTO aey_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","odi maadimei maaden, “Oso dah mecnu dahigca je eu dah meiale,” aden. ");
INSERT INTO aey_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Odocob dana cajaca mati bahic age buudu beladi hedocobil Jisas uqa cuhanuc bilen saen euna dana age Jisas gami coboinca uqana malogomca age uqana galolo je sildiadecnu sisildoin. ");
INSERT INTO aey_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Odocobil uqa maaden, “Anut culadeceb age Anutna culnu ceteteh jahunec docnu nijia. Euqa dana cajaca age Anutna cul dunuh qee bilec age hahagum bilegina eu age galolo jena je cunug dah megina. ");
INSERT INTO aey_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Eunu ‘age tului falicdocobil Anut agena silail cagasiadeiaunnu age amagana mele feginaqa qee fogo adena, odimeig age dahinigana mele dah meginaqa qee dogina,’ en,” aden. ");
INSERT INTO aey_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Odimei Jisas maaden, “Age galolo je ina gugnu qee fogo adenafo? Qeefi, age galolo je osooso cunug adi fogo adigian? ");
INSERT INTO aey_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aig helecnu dana eu uqa Anutna je aig helena. ");
INSERT INTO aey_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aig eu jicna tonena eu odiwe dana age Anutna je dah mecebil Seten mahuc humei je dana waugna tonen eu cedadi len. ");
INSERT INTO aey_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aig eu maha meen baibacana tonena eu odiwe dana age Anutna je dah mimeig wawaga ceelecca je eu mahuc ogina. ");
INSERT INTO aey_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Euqa agedodoc bebeigca qee. Age saen nag himec culumen gahidogina. Odocob Anutna jenu aqati tootooadecca temadecca ageca hocob mahuc wawaga meleec tonena. ");
INSERT INTO aey_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aig eu dud geuna tonena eu odiwe dana age Anutna je dah mecebil ");
INSERT INTO aey_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","euqa maha bilecnu jaen aqecca, maha cehewan ocnuca, ceteh filfil ocnuca waug madec eu wawagana humei Anutna je cilehdocob aig qee qogina. ");
INSERT INTO aey_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Euqa aig mulu mahana tonena eu odiwe dana age Anutna je dah mimeig u hewi daugdu aig qogina. Eundec leih age aig qoc 30 ihoc legina, leih age aig qoc 60 ihoc legina, leih age aig qoc 100 ihoc legina,” aden. ");
INSERT INTO aey_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","22","Jisas je tubdu uqana malogom maaden, “Cel ceteh jahunecna nijia eu hibna camasac moqagan. Odocob cel ceteh dana age jahuldoin nijia eu hibna dana cunug foqagan. Eunu oso gowoc umei jo dunuh limei hal dunuh qee tacena, odimei uqa cabal bisalu qee jahunina. Euqa uqa gowoc ohisna caqusena. ");
INSERT INTO aey_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dana oso dah mecnu dahigcafi je i dah meiale!” aden. ");
INSERT INTO aey_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Uqa je haun maaden, “Oso uqa docca nijia eu Anut uqa haun utigian. Euqa oso uqa docca qee eu Anut uqa uqana doc nag nijia eu cawaldugian. Eunu cel je dah megina eunu batut cisdoigale! Age dana cajaca gesili ganic dogina, gesiladec eu odi himec Anut ameg age wadacadigian. Odocob Anut uqa ceteh haun adigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas je haun maaden, “Anutna cul eu odiwe dana oso aig uqana cabina helena. ");
INSERT INTO aey_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Uqa witic us nijina. Cahineg eu cajimei cabi ona. Odocob saen cunug qala qahi bibi bili cajena. Euqa uqa adi qala qahi cajena eu qee dona. ");
INSERT INTO aey_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Maha uqadodoc qala qahi bibi bili suldocob ben mi wasena. Casac bagac wasena, odocob bobog qona. Odocob bobog eu li aig ibuldona. Odocob euna aig qona. ");
INSERT INTO aey_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aig wal meceb aig cedi haudocnu saen wele calennu dana eu uqa mahuc qetena,” aden. ");
INSERT INTO aey_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas je haun maaden, “Ege Anutna cul eu cel ceteh cinigwe eqan? Cel galolo jena uqana gugnu sildeqan? ");
INSERT INTO aey_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anutna cul eu mastet aig cinigwe. Aig eu dana mahana cehena saen euna eu nag bahic, eu mahana aig cunug wooladena. ");
INSERT INTO aey_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Euqa dana ceheceb aig eu wasi ben mimei eu gulgulec caji tawena, eu cehelo cunug wooladena. Eu batac meca helena. Eunu man fululec limeig agena teic salafu euna mudegina,” aden. ");
INSERT INTO aey_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas uqa dana cajaca Anutna je maaden saen euna uqa galolo jena mati maaden. Dana cajaca age dah mimeig ocnu ihoc eundec doin. ");
INSERT INTO aey_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Uqa galolo jena himec maaden. Euqa uqa uqana malogom gami cuhanuc bilec saenna uqa je cunug sildiaden. ");
INSERT INTO aey_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Deel euna dih wesu meceb Jisas uqana malogom maaden, “Gec, hoiga. Wa gad cagoc leti naha isec loqale,” aden. ");
INSERT INTO aey_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Odocob age dana cajaca am eu culadein. Odimeig Jisasna malogom wag tobein. Jisas uqa wele dunuh bibilen age odidih ehudi belein. Wag leihha age gami belein. ");
INSERT INTO aey_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Odocob gugula ben caleceb fufu gagadic bahic fulududu macas qahi wag dunuh nuaden. Wag eu wa cali bigia odon. ");
INSERT INTO aey_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisasqa uqa wag bigna ilo hetahet men us ninijen uqana malogom tulidumeig madoin, “Iwalgec, hina ege nag odi fadalecnu ec qee cisdolomfo?” doin. ");
INSERT INTO aey_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisas cajimei fufu cahacdu madon. Odimei macas madon, “Malol biliga! Tiliaga!” don. Odocob fufu qee meceb macas tiliec bahic nijen. ");
INSERT INTO aey_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Odocob Jisas uqana malogom maaden, “Age eetanu cucuiegina? Age wawaga meleecca qeefo?” aden. ");
INSERT INTO aey_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Odocob age cumun bahic ein. Odimeig age madocobmadocobeeig madein, “I cel dana? Uqa fufuca macas qahecca uqa co toodu odosina!” ein. ");
INSERT INTO aey_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Age Galili wa gad cagoc leti ono isec belimeig Gerasa agena hatuna calein. ");
INSERT INTO aey_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jisas uqa wagnadec toni limei nunuen dana oso qalqal hatinnadec cali humei Jisas gulucdon. Dana eu uqa buga me qeeca. ");
INSERT INTO aey_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Dana eu uqa qalqal hatinna biloloi. Dana age saen mati hankapnaca sennaca qagoloig, euqa uqa sen didu cagumei hankap fuhudoloi. Uqa gagadic bahic, dana oso uqa cahacdocwe qee. Eunu oso uqa dana eu hewi qagecwe qee. Senna ha qagecwe qee. ");
INSERT INTO aey_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Uqa saensaen cahineg witicca qalqal hatinna bibili aluhha cocobi eui uqadodoc deweg meenna ququoloi. ");
INSERT INTO aey_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Uqa Jisas onoca hohon fimei guguli humei Jisas jaihna gob cehimei uqanu cuha fen. ");
INSERT INTO aey_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Odocob Jisas uqa buga me qee madon, “Buga me qee, hina dana eu culdimeg qisacdoga!” don. Eunu dana eu uqa co suli u eui Jisas madon, “Jisas Anut Ohis Bahic Melah, hina ija eeta oditegan? Ija Anut amegna mahigina, cain me qee mitigaun!” don. ");
INSERT INTO aey_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Odimei Jisas sisildon, “Hina ijain in?” don. Odocob dana eu jejeg hewi madon, “Ija ijani ‘Mati.’ Ge, ege mati bahic biluquna,” don. ");
INSERT INTO aey_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Odocob dana eu uqa Jisas ege hatu enedec cain ititacgagaun ec ninidudu madon. ");
INSERT INTO aey_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aria, aluh qeihna onoca qee ho am ben oso sab jiji coboin. ");
INSERT INTO aey_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Odocob buga me qee age Jisas ninidudu madoin, “Ho eu ageca sulgecem ege ho dewenega dunuh leqan,” doin. ");
INSERT INTO aey_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Odocobil Jisas uqa cois odoiga aden. Maadeceb age dana culdimeig ho dewenegana lein. Odocobil ho eu 2,000 sanijec odi age cunug gad aqeceb age busali aluh qeihqeih guguli nu Galili wa gad cagoc dunuh gotoimeig cunugca odi wa cedi ji cal mein. ");
INSERT INTO aey_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Odocobil dana ho cofadoloig age eu fimeig busali limeig taunca, jobonca, cabinaca cunug saaadi coboin. Odocobil dana cajaca cunug je eu dah mimeig age eu feqan imeig belein. ");
INSERT INTO aey_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Age Jisasca humeig dana wele buga me qee mati agena jo bilen eu uqa qila lotoc tacecca dana cisdoc meca bibilen fimeig cucuiein. ");
INSERT INTO aey_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dana leih age Jisas dana buga me qeeca odudenha, ho odadenha amagana fein eundec je cunug saadein. ");
INSERT INTO aey_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Saaadegin dana cajaca eu age Jisas hina egena hatu i cuculi nuuga ec ninidudu madoin. ");
INSERT INTO aey_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisas uqa wagna totobon dana wele buga me qeeca eu uqa Jisas ninidudu madon, “Cultecem hinaca belowa!” don. ");
INSERT INTO aey_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Odocob Jisas uqa cahacdudu madon, “Odi cain. Hina hinana gunna nuimeg hinana eundec Tibud odihen, uqa hinanu waug qocob me mihen eu saadaga,” don. ");
INSERT INTO aey_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Odocob dana eu uqa hatu eu jobon 10-pela bilein euna cunug cocobi Jisas kobolkobol ben bahic uqa oduden eu cunug saadi cobon. Odocob dana cajaca age je eu dumeig tumatumaein. ");
INSERT INTO aey_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas uqa ceseli Galili wa gad cagoc haun leti wa naha isec cali hocobil dana cajaca mati bahic uqa lan qee culec bibilen uqa cemenug limeig talildoin. ");
INSERT INTO aey_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Age bibilegin Juda agena cuha jo ilo oso, ijan Jairas, humei uqa Jisas fimei uqa jaihna toni mahulimei ");
INSERT INTO aey_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ninidudu madon, “Ija ateni hag ben on, cal migia nijia. Uqa medumei cebac biligiannu hina ijaca belimeu eben dewegna magale,” don. ");
INSERT INTO aey_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Madocob Jisas uqaca belesin. Belecebil dana cajaca mati bahic caji Jisas toodu belein. Age Jisas alildudu gesacgesac belein. ");
INSERT INTO aey_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Odi bebelegin caja oso uqa hag golac necca bibilen cabi gel 12-pela ihoc len. ");
INSERT INTO aey_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Uqa gaid dana age uqana hag me mudituqaga bili ageca loloi, age cabi oin eu ihoc qee lel. Caja eu uqana meen qaig cunug hagnu ameg adecna cusdon. Euqa dana eu age qee me mudelein. Uqa hag gaid odi nijen, cehnana deweg me qee bahic men. ");
INSERT INTO aey_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Uqa Jisasnu je dah mennu uqa dana cajaca mati gemo cocobi Jisas hibilohuna isec humei uqana lotoc hewi fen. ");
INSERT INTO aey_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ge, uqadodoc maden, “Ija uqana lotoc dih qududocominfi ija hag metigian,” en. ");
INSERT INTO aey_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Uqa odi lotoc hewi feceb mahuc golac noloi gatidocob hag medon eu dewegna tebandon. ");
INSERT INTO aey_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Odocob Jisas uqa gagadic odoc oso deweg cuculdi nueceb tebandumei mahuc falicdumei dana cajaca sisilaadi maaden, “In ijana lotoc qududoia?” aden. ");
INSERT INTO aey_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Odocob uqana malogom age Jisas madoin, “Dana cajaca kitim bahic hina talilheiga taweiga hina cemeincemein legina ec fagana. Hinaqa in qudutia? ec sisilgagana,” doin. ");
INSERT INTO aey_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Odocobil Jisas uqa in odi odeia eunu ameg cijawi cobocob fen. ");
INSERT INTO aey_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ameg cijawen cocobon caja eu uqa deweg me men eu dumei uqa deweg qelelen cucuii hon. Odimei uqa Jisas jaihna toni mahulimei je cunug mele ija odiga ec sadon. ");
INSERT INTO aey_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Odocob Jisas uqa caja madon, “Ateni, hina wawin meleec eu me mihia. Hina malol bilecca nuuga. Dewen mehec cobogale,” don. ");
INSERT INTO aey_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas uqa caja je i madodon Juda agena cuha jo ilona gundec leih humeig madoin, “Hina aten cal meia. Hina eetanu iwalgec eu mulug cabi haun utugina?” doin. ");
INSERT INTO aey_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Odocob Jisas uqa age je odi madodogin qee dah mecwe memei Juda agena cuha jo ilo madon, “Cain cucuiagaun. Hina dih wawin meleeiale,” don. ");
INSERT INTO aey_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Odimei Jisas uqa dana cajaca uqa toodocnu cahacadimei Pitaca, Jemsca, Jems waliag Jonca, eudih cedadeceb uqaca belein. ");
INSERT INTO aey_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Age cuha jo ilo uqana jona calimeig ono dana cajaca mati cegulein age dahoc fafali qada ben qaqajegin feciaden. ");
INSERT INTO aey_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Odimei uqa hamol limei maaden, “Eetanu dahoc fafali qada ben qajegina? Mel aid uqa qee cal mel. Uqa us nijia!” aden. ");
INSERT INTO aey_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Odi maadeceb age asaldoin. Odocob Jisas uqa dana cajaca cunug ititacadeceb cali hocobil uqa mel aid memeg anagca malogom cijed uqaca hoin euca dih cedadeceb hamol mel aid nijen euna lein. ");
INSERT INTO aey_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Odocobil Jisas uqa mel aid eben hewi madon, “Talita kumi,” don. Je euna gug eu odi, “Mel aid, ija mahigina, cajaga,” don. ");
INSERT INTO aey_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Madocob mel aid uqa mahuc cajimei cobon. Ge, mel aid eu uqa cabi gel 12-pela odi coboc ihoc len. Odocob age cunug tumatumaimeig hahabanaga culeceb bilein. ");
INSERT INTO aey_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisas uqa cahacaden, uqa odonnu je eu cain saadi cobowainnu je gagadic maadimei maaden, “Mel aid sab uteiga jeia,” aden. ");
INSERT INTO aey_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas cudun eu culimei uqana jobon gug nuen. Uqana malogom toodu belein. ");
INSERT INTO aey_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Juda agena cuha deelna uqa Juda agena cuha jona limei iwaladen. Dana cajaca mati uqana je dah mimeig tumatumai madein, “Dana i uqana je cunug i anadec on? Uqana doc silecca in uten? Uqa ebenna adi kobolkobol ben odona? ");
INSERT INTO aey_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ege doqona, uqa jo cehec memei mec. Uqa Maria melah. Jemsca, Josefca, Saimonca, Judasca age uqa waliagul. Uqa cebinagul age ene age gemona bilegina,” ein. Age uqanu wawaga me qee meceb cecewudi bilein. ");
INSERT INTO aey_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Odocobil Jisas uqa maaden, “Je hahun madec dana oso uqana gug jobon qee euna age uqana je dumeig uqa saolal mudecnu nijia. Euqa uqana hatunaca, uqana gug jobonnaca uqana eundec age uqa cewudegina,” aden. ");
INSERT INTO aey_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ono Nasaret jobon uqa kobolkobol meca qee odol. Euqa uqa eben leih hagca dewenega hewadeceb meaden. ");
INSERT INTO aey_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Odimei uqa age wawaga meleecca qeenu tumatumaen. Jisas jobonnana nunui dana cajaca iwalaadi cobon. ");
INSERT INTO aey_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Odimei Jisas uqana malogom 12-pela utaadeceb hocobil uqa buga me qee dana deweneganadec ititacadecnu cabi eu ebenegana men. Odimei uqa lecislecis suladeceb belein. ");
INSERT INTO aey_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Odimei je gagadic maaden, “Age jic cobocnu ceteh oso cain hewowain. Euqa agena jic coboc komca himec coboiga. Sabca qee, badomca qee, oologamna meen qaigca qee eu odi jic coboiga. ");
INSERT INTO aey_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Age jaimaga tacimeig qa lotoc lecis cain tacowain. Osol himec taceiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Uqa maaadi maaden, “Age jo casac dunuh loqagan jo osol euna himec bibileig li jobon eu culimeig beleiga. ");
INSERT INTO aey_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Odocob jobon oso age oiadecnu agena je ha dah mecnu culecebilfi age cuculadi beloqaga bili comis jaimagana fagdon eu qoidu heleiga. Age eu fimeig age Anut amegna me qee odoin eu doqagannu odi odoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eunu age belimeig dana cajaca agena silailnu tului falicdoqagannu je qasali maadein. ");
INSERT INTO aey_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Odimeig age buga me qee mati dana deweneganadec ititacadimeig mool dana caja hagca mati joiadecebil me madein. ");
INSERT INTO aey_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Saen euna Jisas uqana odocnu je eu hatu cunugna ihoc len. Eunu King Herod uqa Jisasna odocnu hutan don. Leih age madein, “Wa Joadec Jon uqa cal mecnadec ceseli cajen! Eunu gagadic odoc i uqa dunuh cabi ona,” ein. ");
INSERT INTO aey_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Euqa leih age madein, “Uqa Ilaija,” ein. Leih madein, “Uqa Anutna je hahun madec dana eu odiwe je hahun madec dana weledec,” ein. ");
INSERT INTO aey_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Euqa Herod je eu dah mimei maden, “Jon ija be cagom qa uqa haun ceseli cajen!” en. ");
INSERT INTO aey_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ge, wele Herod uqa waliag Filip aideg, Herodias, on. Odocob Jon uqa li Herod madon, “Hina walin aideg om eu tutuc qee,” don. Eunu Herod uqana han dana suladeceb age li Jon hewi libimeig gihacdoc jona mudein. ");
INSERT INTO aey_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Odocob Herodias uqa Jon ameg me qeena wadacdugiannu cisdon. Qocob cal migiannu en qa uqa ihoc qee. ");
INSERT INTO aey_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ge, Herod uqa Jon dana me bahic, uqa dana ititom eunu don. Eunu Herod uqa Jonnu cucuien. Odimei uqa Jon me cofdon. Herod uqa Jon je madeceb dah men saen euna uqa geh cisdumei waug culumen doloi qa uqa Jonna je dah mudecnu gaid gale doloi. ");
INSERT INTO aey_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hibna Herodias Jon qocob cal mecnu jic gulucdon. Herod uqa anag basen deel cali hon. Odocob Herod uqana cabi dana benbenca, uqana han dana agena iloiloca, Galili agena aqunec danaca agenu ja qon. ");
INSERT INTO aey_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Odocob Herodias ateg dunuh limei due duen. Odocob Herod uqa uqana danahca mel aid eunu gale aden. Eunu Herod uqa mel aid eu madon, “Hina cel ocnu gale hena eunu sisiltaga, odocob ija ihigen,” don. ");
INSERT INTO aey_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Odimei je hahun utimei madon, “Hina cel ceteh sisiltecemfi eu ihigen. Ijana cul naha ihoc lec euna gadac odi ihigen!” don. ");
INSERT INTO aey_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Odocob mel aid eu cali li anag sisildon, “Ija cel ceteh ocnu sisildugen?” don. Anag jejeg hewi madon, “Wa Joadec Jon ilo u itiga ec madoga,” don. ");
INSERT INTO aey_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Odocob mel aid eu mahucwe ceseli kingca limei madon, “Ija hina qila bahic Wa Joadec Jon ilo bohna mimeg ahutaga tena!” don. ");
INSERT INTO aey_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mel aid odi madocob king uqa geh bahic waloc don qa uqana je cagocnuca, uqana danah amagana odonnuca uqa je mel aid madon eu hawadocnu qee gale dol. ");
INSERT INTO aey_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Odimei uqa mahuc uqana cofdoc han dana oso madu suldocob Wa Joadec Jon ilo uu ahugiannu nuen. Odocob uqana cofdoc nui gihacdoc jona Wa Joadec Jon be cagon. ");
INSERT INTO aey_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Odimei uqa bohna mimei ehi limei mel aid uten. Odocob mel aid uqa ehi li anag uten. ");
INSERT INTO aey_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Odocob Jonna malogom age je eu dah mimeig age hu Jon deweg loton u ehi li meen hatin qalqal osona mudein. ");
INSERT INTO aey_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Odocob aposel ceseli Jisasca humeig ceteteh cunug odoinnuca iwaladeinnuca sadoin. ");
INSERT INTO aey_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Euqa dana cajaca mati bahic lili huhueegin Jisas uqana malogomca sab jecnu saenca qee. Eunu Jisas malogom maaden, “Hoiga, ege cuhanuc belimeb cudun leihna age nag odi jaen muduqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Odocob age cuhanuc wag umeig cudun tiliecna belein. ");
INSERT INTO aey_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Aria, dana cajaca mati bahic bebelegin meciadimeig age ail eu wele doin i age guguli taun cunug wooldodoig age casac maha toodu cocobi cudun euna Jisas uqana malogomca medemega cagu calein. ");
INSERT INTO aey_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Odocobil Jisas lanna tonimei dana cajaca am ben tatawegin fen. Odocob uqa age sipsip cofadecca qee cobogina odiwe bilein eunu agenu waug qon. Odimei uqa ceteteh mati bahic iwaladecnu sanan men. ");
INSERT INTO aey_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Saen wele hedodon uqana malogom uqaca humeig madoin, “Cudun i filec cagocna bahic, odocob saen wele hedoia. ");
INSERT INTO aey_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dana cajaca i age hatu alildoc belimeig jobon osonana agena sab jecnu fajoqagannu suladaga,” doin. ");
INSERT INTO aey_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Euqa Jisas malogom maaden, “Age sab jec adeiga,” aden. Odocob age jejeg hewi madoin, “Hina ege nui kina 200na bred fajimeb adocomun joqagannu madaganafo?” doin. ");
INSERT INTO aey_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Odocobil Jisas maaden, “Age bred ganicca? Li feiga,” aden. Odocob age li fimeig madoin, “Bred 5-pela, cul dool lecisca himec bilia,” doin. ");
INSERT INTO aey_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Odocobil Jisas uqa dana cajaca age am qatanimeig gigisac mena bileiga ec maaden. ");
INSERT INTO aey_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Odocob dana cajaca am qatanimeig bilein. Age am sanijec 100ca 50ca odi bilein. ");
INSERT INTO aey_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Odocob Jisas bred 5-pela cul dool lecisca u hewimei sao jobon tatiimei Anut hetaga doc je madumei bred fenifeni malogom adeceb age dana cajaca siwiadein. Odimei uqa cul dool lecisha feni calcaldumei dana cajaca siwiadeceb cunug ihoc len. ");
INSERT INTO aey_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Odocob age cunug jecebil li ihoc len. ");
INSERT INTO aey_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Odocobil malogom age bred cul doolca jecefanaga eundec galel 12-pela tacecebil am ben. ");
INSERT INTO aey_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bred jein eundec age cunug eu dana 5,000. ");
INSERT INTO aey_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mahuc bahic Jisas uqana malogom cesusadeceb age wagna tobimeig age aqunitu Galili wa gad cagoc naha isecnu Betsaida jobon belein. Bebelegin uqa dana cajaca qaqacitegin cofaden. ");
INSERT INTO aey_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Uqa dana cajaca culadi hedocob uqa Anut inondudu bilecnu aluh guhidocna ten. ");
INSERT INTO aey_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wele tu hohon wag eu wa gad cagocna len. Jisas uqa cuhanuc mahana bilen. ");
INSERT INTO aey_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Odimei fufu ben malogom olanagana isec fuludonnu uqa age wag culum hewecnu abuldodogin meciaden. Odimei walag danigia oodon Jisas uqa wa tatacan cocobi ageca len. Uqa age wooladigia odon. ");
INSERT INTO aey_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Euqa age uqa macasna cocobon fimeig dol oso cobona imeig euein. ");
INSERT INTO aey_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ge, age cunug fecidumeig age qeleli filicitein. Euqa Jisas mahuc maaden, “Cain cucuiuwain! Ija ihen. Age wawaga toogdoiale!” aden. ");
INSERT INTO aey_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Odimei uqa wagna ageca tobi ten. Odocob fufu tilien. Uqana malogom tumatumaein. ");
INSERT INTO aey_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ge, age Jisas uqa dana cajaca bred siwiaden uqana gug qee fogo adel. Euqa age wawaga tool ibuldon. ");
INSERT INTO aey_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Age wa gad cagoc leti hu Genesaret hatuna hoin. Ono age wag lanna qagein. ");
INSERT INTO aey_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Age wag tobocobil dana cajaca age Jisas wele fein ec mahuc doin. ");
INSERT INTO aey_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Odimeig age hatu cunugna guguli belimeig dana caja hagca agena gabagabna ninijegin hewadi li Jisas ana bilia ec doin euna uqaca ahoin. ");
INSERT INTO aey_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jisas anaana cocobon, eu jobon nagfo, jobon benfo, cudun gaucfo, age idadec cudunna dana caja hagca cedi hewi madecebil nijoloig. Odimeig agena hag me madigiannu ninidoloig. Age uqana lotoc himec qududocnu ninidoloig. Odocob cunug age uqana lotoc qududoin eu me moloig. ");
INSERT INTO aey_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Saen euna Farisica loo je iwaladec leihca Jerusalemdec humeig Jisasca cegulein. ");
INSERT INTO aey_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Farisica Juda dana cunugca age jajanagail agena kobol toodu ebenega casac cusimeig sab jeginanu. Age ebenega qee cusec sab qee jeginanu. Odimeig age idadec cudunna limeig ceseli hu saen euna age ebenega qee cusifeig qee jegina. Juda age kobol geh bahic ha toodu odoginanu. Eu odi age gabin cusegina, hal cusegina, boh bronsna mudec cusegina. Odocob Farisica loo je iwaladecca age Jisas uqana malogom leih age ebenega gegehin wa qee cusec sab jejegin fein. ");
INSERT INTO aey_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Odimeig age Jisas sisildoin, “Eetanu hinana malogom kobol ege jajanigeil iwalgein eu qee toodu odogina qa ebenega gegehinca sab jegina?” doin. ");
INSERT INTO aey_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Odocob Jisas jejenega hewi maaden, “Je hahun madec dana, Aisaia, uqa age me hihili coboc dananu mele bahic madi maden. Uqana je odi jaqen: ‘Dana cajaca i age conogana binani sulegina age wawagaqa eu qisactec bilina. ");
INSERT INTO aey_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Eu age dana agena loo je iwaladegina eu Anutna loo je, egina. Eunu age ijanu gauc cuha fegina,’ en. ");
INSERT INTO aey_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Anut uqa age odi odoiga ec gagadic maaden eu qisacdu bilimeig dana iwaladec gagadic hewegina,” aden. ");
INSERT INTO aey_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","13","Jisas je haun maaden, “Moses maden: ‘Hina anin memenca lalan malagale,’ en Odocob Mosesha maden: ‘Oso memegfo, anagfo geuldecnu je madecebfi uqa cal migian,’ en. Ageqa madegina, ‘Dana oso uqa anag memegca cesulalecnu cetehcafi euqa uqa maalena, “Ceteh i ija alecnu ihoc eu, ‘Koban,’ ija Anut utigennu wele qagu abes mem,” alena dana eu uqa anag memegca nag oso cesulalecnu cain odoiaun,’ egina. Eunu age kobol jajanagail oin eu odi toodu odoginana Anutna je cilehdogina. Agena kobolha dana leih haun iwaladegina. Age odoc eundec matiha odi odogina. Odimeig age dana agena iwaladec eu toodu odoqagannu age Anut je gagadic maaden eu culegina eu me bahic ec cisdogina!” aden. ");
INSERT INTO aey_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Odimei Jisas uqa dana cajaca utaadeceb hocobil maaden, “Ija dah miteiga. Cunugca du cuhadoigale. ");
INSERT INTO aey_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ceteh oso dana hibilohu bilina eu dana dunuh limei gegehin qee mudina. Euqa ceteteh dana waug dunuhnadec cali hona eu dana gegehin mudina. Dana oso dahigcafi je i dah meiale!” aden. ");
INSERT INTO aey_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Odimei uqa dana cajaca culadi jo hamol leceb uqana malogom age uqana galolo jenu sisildoin. ");
INSERT INTO aey_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Odocobil Jisas maaden, “Ageha wawaga qee fogo donafo? Ceteh cunug dana hibilohudec dana dunuh limei eu uqa cul dunuh qee lena qa uqa waug big anag dunuh limei dana bahu nuecna cali hona. Eunu ceteh eu dana gegehin qee mudina eu qee feginafo?” aden. Eunu je euna Jisas uqa Anut amegna sab cunug jecnu soidoc nijia ec maden. ");
INSERT INTO aey_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Odimei je haun maaden, “Ceteh dana dunuhdec cali hona eu dana gegehin mudina. ");
INSERT INTO aey_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ge, dana waug dunuhnadec ceteh gegehinca cali hona eu odi, cisdoc me qeeca, wal kobol odocca, heje occa, dana qocca, dana osona caja occa, ");
INSERT INTO aey_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ameg qocob ceteh occa, qisol mecca, uhulec jeca, wal kobol majagca qee odocca, um qoc madecca, deboi cobocca, osona ceteh feceb gale docca, gad odocca eu cali hona. ");
INSERT INTO aey_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Odoc me qee eu cunug dana wawaga dunuhdec cali hona, odocob age dana gegehin mudadegina,” aden. ");
INSERT INTO aey_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Odocob Jisas cali humei hatu eu culimei Taia Saidonca alena hatuna nui bilen. Odimei uqa jo oso dunuh hamol li bilen. Dana uqa ono bilia eu cain dowainnu gale don qa uqa jahuni bilecwe qee. ");
INSERT INTO aey_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Euqa mahuc caja oso uqa ateg buga me qeeca uqa Jisas bilennu dumei uqa Jisasca humei jaihna toni mahulen. ");
INSERT INTO aey_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Caja eu Juda qee, uqa anag Finisia hatu ono basen. Siria age Finisia cofdoin. Odimei uqa Jisas buga me qee ateg deweg bilen eu ititacdocnu ninidon. ");
INSERT INTO aey_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Odocob Jisas madon, “Mel agena sab cedi qa heliadec eu kobol me qee. Eunu ege mel casac sab adoqona,” don. ");
INSERT INTO aey_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Odocob caja jejeg hewi madon, “Mele Tibud, euqa mel sab jejegin jecefanaga golodocob qa age cabal bisalu bilegina eu hu cedicedi jegina eu odi qeefo?” don. ");
INSERT INTO aey_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Odocob Jisas caja madon, “Hina je me bahic wadacdutaga. Eunu gad ceseli nuugale. Buga me qee hina aten culdi qisacdoia eu fegan!” don. ");
INSERT INTO aey_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Odocob caja jobon ceselimei uqa ateg cabalna us ninijen fen, buga me qee wele cuculdi qisacdon. ");
INSERT INTO aey_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas uqa Taia agena hatu culimei uqa Saidon taun isec hu jobon 10-pela agena hatuha gemona cocobi Galili wa gad cagocna ceseli hon. ");
INSERT INTO aey_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ono hon bibilen age dana oso ehudi uqaca hoin. Dana eu uqa dahig coca cufa qoc, je madecwe qee. Age Jisasca humeig ninidudu madoin, “Hina eben uqa dewegna magale,” doin. ");
INSERT INTO aey_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Odocob Jisas uqa dana eu ehudi filecna ehi li muden. Jisas dana euca dih bibilesi uqa eben gic dana dahigna mimei ebenha sahalic qumei dana beilah qududon. ");
INSERT INTO aey_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Odimei uqa tatiimei hooli maden, “Effata,” en. Je eu uqana gug eu “Fogo heia,” en. ");
INSERT INTO aey_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jisas odi madeceb dana eu dahig fogo don. Uqa beilah qagecwe bilen eu filihicdocob uqa je tutuc maden. ");
INSERT INTO aey_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisas uqa oduden eu dana oso sadowainnu cahacaden. Jisas je eu saadecnu gagadic bahic cahacaden, euqa age feei dana cunug doqagannu saadi coboin. ");
INSERT INTO aey_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Odocobil dana cajaca age je eu dah mimeig ben bahic tumatumai madein, “Uqa ceteteh cunug me odoin. Ge, dahiniga cufa qoc coboin eu uqa odocob dah megina! Conoga cufa qoc eu uqa odocob je madegina!” ein. ");
INSERT INTO aey_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Saen euna dana cajaca mati bahic haun hu cegulein. Age sab jecca qeenu Jisas uqana malogom utaadeceb uqaca hocobil maaden, ");
INSERT INTO aey_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Dana cajaca i age qila deel cijed ija gami biluquna age sab jecnuca qee. Eunu ija agenu walol tena. ");
INSERT INTO aey_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ija age sab qee adec gauc agena jobon suladecemin belifeig jicna wennu lehanaga culigian. Ge, leih age jic cecelac bahic hoigan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Odocob uqana malogom jejeg hewi sisildoin, “Wadau edi ene oso dana i age sab adi adeceb joqagan?” doin. ");
INSERT INTO aey_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Odocobil Jisas sisiladi maaden, “Age bred ganic heweiga?” aden. Odocob madoin, “Bred 7-pela nijeiga,” doin. ");
INSERT INTO aey_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Odocob uqa dana cajaca am maadeceb mahana bilein. Odimei bred 7-pela cedimei Anut hetaga dumei fenifeni malogom dana cajaca siwiadecnu aden. Odocob malogom age ehi li dana cajaca siwiadein. ");
INSERT INTO aey_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Age cul dool nag leihha hewein. Jisas Anut hetaga dumei uqana malogom maadeceb euha dana cajaca siwiadein. ");
INSERT INTO aey_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dana cajaca cunug jecebil biniga hon. Odimeig malogom age jecefanaga golodon eu mahanadec cedimeig galel 7-pela tacecebil am ben. ");
INSERT INTO aey_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Dana cajaca cunug sab jein eu sanijec 4,000 odi. ");
INSERT INTO aey_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Odocobil Jisas uqa dana cajaca maadeceb qacitein. Odocobil uqa uqana malogom gami mahuc wagna tobimeig nui Dalmanuta agena hatuna li bilein. ");
INSERT INTO aey_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Saen euna Farisi leih age Jisasca hocobil uqaca fee dadanein. Age Jisasna cabi eu Anutnadecfo, qeefo feqan imeig temdocnu age uqa kobolkobol oso odocob gaga eu feqan ec madoin. ");
INSERT INTO aey_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Odocobil Jisas deweg dologca cisdoc cunug culumen dodon hooli maden, “Eetanu dana sihul qila bilegina age gaga oso fecnu walegina? Ija mele maadigina, dana cajaca i qila bilegina age gaga oso qee fowain!” aden. ");
INSERT INTO aey_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Odi maadimei cuculadi wagna tobi ten. Odimei haun wagna ceseli wa gad cagoc naha isec li bilen. ");
INSERT INTO aey_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Malogom age beloqaga bili bred tacecnu dahiniga celen. Odimeig bred osol himec hewein eu wagna nijen. ");
INSERT INTO aey_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisas doqagannu je maaden, “Dah meiga, age Farisica Herodca agena bred gug qoc ibuldocnu jisnu ageca hoiaunnu batut feigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Odi maadeceb malogom age togodudu madein, “Ege bredca qeenu mageia,” ein. ");
INSERT INTO aey_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas uqa age eunu togododogin dumei maaden, “Age eetanu bred qee hewelein eunu togodudu madegina? Age qila qee doginafo? Age wawaga qee fogo dolfo? Age wawaga tool ibuldonfo? ");
INSERT INTO aey_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Age amagacaqa qee feginafo? Age dahinigacaqa qee dah meginafo? Odocob age qee cisdoloinfo? ");
INSERT INTO aey_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ija bred 5-pela fenimig dana 5,000 siwiadem saen euna age jecefanaga eundec galel ganic tacecebil am ben?” aden. Odocob jejeg hewi madoin, “Ege 12-pela tacom,” doin. ");
INSERT INTO aey_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Odocobil Jisas haun sisiladen, “Ija bred 7-pela fenimig dana 4,000 siwiadem saen euna age jecefanaga eundec galel ganic tacecebil am ben?” aden. Odocob jejeg hewi madoin, “Ege 7-pela tacom,” doin. ");
INSERT INTO aey_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Odocobil maaden, “Age qila qee fogo adelfo?” aden. ");
INSERT INTO aey_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Age Betsaida jobon ono calein. Odocobil dana cajaca leih age dana oso ameg galuc mec eu ehudi Jisasca humeig eu eben hewi figiannu ninidoin. ");
INSERT INTO aey_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Odocobil Jisas dana eu eben hewi ehudi jobon hacna limesi sahalic u amegna mimei uqa eben ilona mimei sisildu madon, “Hina ceteh oso faganafo?” don. ");
INSERT INTO aey_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Odocob dana eu camalimei madon, “Ija dana cocobogin feciadigina qa age na cinigwe feciaadigin cobogina,” don. ");
INSERT INTO aey_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Odocob Jisas uqa dana eu haun ceseli eben amegna men. Odocob dana eu gagadic bahic mecieen ameg me fogo don. Ceteh cunug eu uqa cataniec fen. ");
INSERT INTO aey_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Odocob Jisas uqa dana eu uqana gun nuigiannu suldudu madon, “Hina jobon ina cain lagaun,” don. ");
INSERT INTO aey_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas uqana malogomca cocobi li Sisaria Filipai ono jobon osona belein. Jic cocoboig uqa malogom sisiladen, “Mateiga, dana age ijanu in egina?” aden. ");
INSERT INTO aey_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Odocob age jejeg hewi madoin, “Leih age Wa Joadec Jon eu hina ec madegina. Leih age Ilaija eu hina ec madegina. Leih age je hahun madec dana oso eu hina ec madegina,” doin. ");
INSERT INTO aey_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Uqa haun sisiladi maaden, “Ageqa, ijanu in egina?” aden. Odocob Pita jejeg hewi madon, “Krais eu hina,” don. ");
INSERT INTO aey_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Odocob Jisas uqana malogom cahacaadi maaden, “Age ijanu leih cain maadi cobowain,” aden. ");
INSERT INTO aey_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Saen euna Jisas uqa uqana cal mecnu uqana malogom maadecnu sanan mimei maaden, “Dana Melah uqa deweg sogoec ben gahidugian. Juda agena matuca, ihanec dana benbenca, loo je iwaladecca age Dana Melah hibemdumeig uqa qocobil cal migian. Odimei uqa deel cijed hedocob haun ceseli cajigian,” maaden. ");
INSERT INTO aey_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas uqa je eu camas maadeceb Pita uqa Jisas ehudeceb gesacna limesi uqa Jisas cahacdudu madocnu sanan men. ");
INSERT INTO aey_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Euqa Jisas falicdu uqana malogom feciadimei Pita cahacdudu madon, “Se, Seten, hina Anut madena eu odi qee madelem. Hina dana mahanadec cisdoc toodu matagana. Eunu cuculti nuuga!” don. ");
INSERT INTO aey_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","38","Odimei uqa dana cajaca uqana malogomca utaadeceb uqaca hocobil maaden, “Dana oso uqa ijanu ijana jenuca silail dana cajaca qila bilegina eu age Anut hibemdoin eu amagana majag docobfi saen Dana Melah uqa Memegna kobolkobolnaca ensel gunca humei uqa dana eunu majag dugian. Odocob dana oso mahamaha cehewan cunug oialumiqa uqana cebac bilec qee moubmi cehewan on eunu me biloubfo? Dana uqa uqana cebac bilec eu culecebfi cel cetehna uqana cebac bilec ceseli besi ocnu fajudigian? Eunu oso uqa uqana cebac bilec cahahadugia odona eu uqa uqana cebac bilec felacudigian. Odocob oso uqa ijana bilina eunuca me je qasali maadena eunuca uqana cebac bilec felacudecebfi eu uqa uqana cebac bilec cahahadugian. Eunu oso uqa ijanu madi, ija uqa jaih ceen lahacdudu toodugen, ena eu uqadodoc deweni me biligian ec cain madeiaun qa uqa uqana na babalec hewi gahidumei tooteiale,” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Odocob Jisas maaden, “Ija mele maadigina, leih age ene tawegina eu age qee cal mec ninijeb Anutna cul gagadic odocca hohob mecidoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Deel 6-pela hedocob Jisas uqa Pitaca, Jemsca, Jonca cedadimei ehadi aluh ohis osona dana oso qee bilec euna ti cuhanuc bilein. Ono bibilegin Jisas uqa age amagana ibuldon. ");
INSERT INTO aey_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Uqana lotoc senenec bahic faleen, uqana senenec eu dana mahanadec age lotoc cuseginawe qee. ");
INSERT INTO aey_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Odocob uqana malogom age Moses Ilaijaca ale hocobil Jisasca je togododogin feciadein. ");
INSERT INTO aey_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Odi bibileig Pita uqa fimei Jisas madon, “O Meca, ege ene odi bilecnu eu me bahic. Ege ene talah jo cijed ceheqan, oso hinana, oso Mosesna, odocob oso Ilaijana,” don. ");
INSERT INTO aey_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ge, uqa malogomca age geh bahic cucuiein eunu uqa cel je madena eu qee dol. ");
INSERT INTO aey_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Uqa je eu madudu bibilen taen oso ni jahuladen. Odocob taennadec jejeg oso camas mimei maden, “Ija melami nelugca ihen. Age uqa jejeg toodu odoiga,” en. ");
INSERT INTO aey_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Odocob mahuc age talildu meciimeig oso ageca tatawen qee felein, euqa Jisas himec age cemenega tatawen fein. ");
INSERT INTO aey_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Age aluhnadec totoni Jisas malogom cijed je gatiti maaden, “Dana Melah cal mecnadec qee cajec ninijeb je i oso cain doiaunnu qila feiga eu oso cain saadowain,” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Age uqa co toodoin qa age gemona agedodoc ceteh eunu togodudu madein, “Cal mecnadec ceseli cajec eu eeta?” ein. ");
INSERT INTO aey_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Odimeig age Jisas sisildoin, “Eetanu loo je iwaladec age Ilaija uqa aquni hugian egina?” doin. ");
INSERT INTO aey_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Odocobil Jisas jejenega hewi maaden, “Ilaija uqa mele aquni hugian, humei ceteh cogogen eu cunug tutuc mudigian. Euqa eetanu Anutna je age Dana Melahnu jaqein, uqa deweg sogoec mati bahic gahidocob dana cajaca cunug age cewudoqagan ec odi jaqein? ");
INSERT INTO aey_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Euqa ija maadigina, Ilaija uqa wele hon. Hocob dana agedodoc wawaga maden eu age uqa odudein. Eu oduduqagan ec wele uqanu jaqeinwe odi odudein,” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisas malogom cijedca age malogom leih gami gabandumeig age dana cajaca mati bahic ceguli talilaadegin fein. Ono loo je iwaladec age malogom gami jena file dadaneegin fein. ");
INSERT INTO aey_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Odocobil dana cajaca age Jisas caleceb fimeig age geh bahic filicitein. Odimeig mahuc age uqaca guguli limeig feele dudu madoin. ");
INSERT INTO aey_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Odocobil Jisas uqa sisiladen, “Age, age gami eeta togodoiga?” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Odocob dana oso dana cajaca amnadec Jisas madon, “Iwalgec, ija melami uqa buga me qeeca, uqa je madecwe qee. Eunu ija ehudi hinaca ahuga. ");
INSERT INTO aey_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Buga me qee hu hewena saen euna qu ihu qocob mahana tonimei sahalic magmagdodoi maig kicodudu deweg kieceb gagadic mena. Ija hinana malogom ititacdoqagannu maadigaqa age ititacdocnu odoiga ihoc qee,” don. ");
INSERT INTO aey_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Odocob Jisas uqa je eu dah mimei maaden, “O dana cajaca qila bilegina, age wawaga meleecca qee! Saen ganic ija ageca haun biligen? Saen ganic ija camuhulaadi cobigen? Mel eu cemeni ehudi ahoigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Odocob age mel eu Jisas amegna ehudi ahoin. Odocobil buga me qee eu Jisas fimei mahuc mel eu qu ihu qocob mahana tonimei coliwcoliwi niniji sahalic magmagdon. ");
INSERT INTO aey_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Odocob Jisas mel memeg sisildon, “Cel saen bahic hag eu mel dewegna sanan men?” don. Odocob memeg madon, “Mel nagna bahic saen euna sanan muden. ");
INSERT INTO aey_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Saen mati mel eu deweg tudugiannu odudeceb jana lena, odimei wana nuina. Euqa hina ceteh oso odocnu ihocfi hina egenu wawin qocob cesulgagale,” don. ");
INSERT INTO aey_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Odocob Jisas madon, “Eetanu hina mataga, ‘Hina odocnu ihocfi,’ taga? Oso waug meleeccafi eeta cunug uqa odocnu ihoc,” don. ");
INSERT INTO aey_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Odocob mahuc memeg utai bilei madon, “Ija wawi meleenaqa ijana wawi meleec eu gohic. Eunu ijana wawi meleec cesuldogale,” don. ");
INSERT INTO aey_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Odocob Jisas uqa dana cajaca mati bahic hu gabandu alilaadegin fimei uqa buga gegehinca cahacdudu madon, “Hina buga con dahinca cufa qoc, ija je gagadic mahigina, hina melnadec cali hu nuuga. Hina mel deweg dunuh eu haun cain lagaun,” don. ");
INSERT INTO aey_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Odocob buga me qee qajimei mel eu hewi qu me qee mudi ihu qocob tonimei mahana ninijen cali hu nuen. Mel eu cal mec cinigwe nijen. Odocob dana cajaca cunug madein, “Mel cal meia,” ein. ");
INSERT INTO aey_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Euqa Jisas mel eu eben umei cesuldocob caji tawen. ");
INSERT INTO aey_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Odocob Jisas uqana malogomca age jo oso dunuh limeig uqana malogom jahuni sisildoin, “Eetanu ege buga me qee eu ititacdocwe qee?” doin. ");
INSERT INTO aey_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Odocobil Jisas jejenega hewi maaden, “Inondocna himec buga me qee eundec ititacdocob cali hu nuina, ceteh osona ihoc qee,” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Odocob Jisas uqana malogom gami jobon eu culdi Galili hatu gemogemo coboin. Uqa uqana malogom iwalaadi bilei maaden, “Dana Melah eu dana ebenegana mudecebil age uqa qocobil cal migian. Cal mimei uqa deel cijed hedocob haun ceseli cajigian,” aden. Eunu uqa dana age ono bilina ec docnu culen. ");
INSERT INTO aey_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Euqa age je eu uqana gugnu wawaga qee fogo dol. Odimeig age je gugnu sildiadecnu sisildocnu cucuiein. ");
INSERT INTO aey_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Age Kapaneam jobon ono calimeig jo oso dunuh li bibileig Jisas uqa uqana malogom sisiladen, “Age cel je jicna togododogin duga?” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Euqa age jicna agedodoc gemona in oso cunug wooladi ben bilinanu togodoin. Eunu age je madecnu culein. ");
INSERT INTO aey_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Odocobil Jisas uqa bilimei uqana malogom 12-pela utaadimei maaden, “Oso uqa matu bilecnu waug nijinafi uqadodoc hib bahic mudigian. Odimei uqa cunugnu cewel dana migian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Odimei uqa mel sim oso u uqa age gemona mudeceb tatawen uqa eben u colowandumei maaden, ");
INSERT INTO aey_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Oso uqa mel sim eundec oso ija ijanina ehudimei eu eeldona eu uqa ija oitimei eeltena. Odocob oso uqa oitimei eeltena eu uqa ija dih qee oitinaqa ija sulten euha ehudimei eeldona,” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Odocob Jon uqa Jisas madon, “Iwalgec, ege dana oso hina ijainna buga me qee eundec dana deweneganadec ititacaaden fom. Uqa egena amnadec qee bilel. Eunu ege uqa cahacdom,” don. ");
INSERT INTO aey_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","41","Euqa Jisas maaden, “Oso uqa ijanina kobolkobol odimei uqa saen nag gieceb ijanu je me qee madecnu ihoc qee. Oso uqa ege qee me qee migina eu egenu tawena. Ija mele maadigina, oso age Kraisna eundecnu cesuladimei wa gab oso adena eu uqa hibna ameg me bahic ugian. Eunu age cain cahacdowain,” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisas odi maadi maaden, “Oso uqa mel sim i eundec oso uqa ijanu waug meleena eu odudeceb silail migiaqa eu meen ben culumenca bena qagi macas ameg nijia euna age heloubmi eu me odoub. ");
INSERT INTO aey_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Odocob hina eben lecisca oloqanih jana ja cijeceb catanena euna helihecebil bilecnu eu me qee bahic. Euqa hina eben osolca qee cebac bilec catanec ogaqa eu me. Eunu hina eben silail mecnu mana tawecebfi hina eben qeti helagale. ");
INSERT INTO aey_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Odocob hina jaim lecisca oloqanih jana helihecebil bilecnu eu me qee bahic. Euqa hina jaim osolca qee cebac bilec catanec ogaqa eu me. Eunu hina jaim silail mecnu mana tawecebfi hina jaim qeti helagale. ");
INSERT INTO aey_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Odocob hina amen lecisca oloqanih jana helihecebil bilecnu eu me qee bahic. Euqa hina amen osolca himec Anutna cul lagaqa eu me. Eunu hina amen faninheceb silail mifeg amen seli helagale. ");
INSERT INTO aey_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Cudun euna ‘gumac dewenega gaid qu jegina, odocob ja dewenega gaid cijina,’ en,” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ge, age ceteh Anutnu ihanegina euna macas mecebil Anut amegna cataniec nijina eu odiwe ja euha Anut uqa dana dewenega cunugna migian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Macas eu me bahic qa uqana tin tebandoc eu qee mecebfi age adi uqana tin tebandoc weledec eu haun muduqagan? Age dool cuhunugana macas mecebil gaid me bilina eu odiwe age agedodoc wawagana macas mecebil cotogailca malol bileigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas uqa cudun eu culdimei Judia hatuna nuen. Odimei Jodan Wa letimei len. Ono dana cajaca mati bahic uqaca haun hoin. Odocob uqa gaid odonwe odi iwaladen. ");
INSERT INTO aey_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Odocob Farisi leih age ege Jisas temdu feqan imeig uqa sisildu madoin, “Magaga, dana oso uqa aideg culdecnu egena loo je cois ec madenafo?” doin. ");
INSERT INTO aey_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Odocobil Jisas jejenega hewi maaden, “Cel loo je Moses uqa age gagadic maaden?” aden. ");
INSERT INTO aey_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Odocob age odi madoin, “Moses uqa dana oso ocobocobec cagocnu je oso jaqimei aideg utimei suldocob nuigian eu cois ec magen,” doin. ");
INSERT INTO aey_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Euqa Jisas maaden, “Age wawaga tool ibuldon eunu Moses uqa agenu loo je i jaqimei aden. ");
INSERT INTO aey_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Euqa ifanec gug qocna Anutna je odi madena: ‘Anut uqa dana cajaca ifani malimei maden,’ ena. ");
INSERT INTO aey_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Anutna je euha madena: ‘Gug inu dana uqa memeg anagca culalimei aidegca gabanalecebil biluwasan. ");
INSERT INTO aey_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Odocob lecis ale deweg osol biluwasan,’ ena. Eunu ale lecis qee biluwasinqa ale deweg osol bilesina. ");
INSERT INTO aey_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Eunu Anut gabandon eu dana oso cain cagoiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Odocob age jona ceselimeig uqana malogom age dana caja ocobocobec cagocnu je eunu haun sisildoin. ");
INSERT INTO aey_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Odocobil Jisas maaden, “Dana oso uqa aideg culdi caja haun oso ona eu dana caja sisi jelec wagalimei uqa aideg wal kobol odudina. ");
INSERT INTO aey_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Odocob caja eu uqa dana culdimei li dana haun oso ocobfi uqaha dana caja sisi jelec wagalimei wal kobol odona,” aden. ");
INSERT INTO aey_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Dana cajaca leih age mel sim Jisas eben age ilomogana migiannu uqaca ehadi ahoin. Ahocobil malogom age ehadi ahoin eunu gagalaadi cahacadein. ");
INSERT INTO aey_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Euqa Jisas uqa eu fimei uqana malogom galac maden, “Mel sim eundecnu Anutna cul muden nijiado. Eunu cain cahacadowain. Culadecebil mel sim age ijaca hoigale. ");
INSERT INTO aey_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ija mele maadigina, oso uqa mel sim Anutna cul ona eu odiwe qee ona eu Anutna culna qee leiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Odimei uqa mel sim calawanadimei eben ilomogana mimei eeladen. ");
INSERT INTO aey_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Odocob Jisas uqana jic nuigia oodon dana oso uqaca guguli hu jaihna gob cehimei sisildon, “O Iwalgec Me, ija eeta odimig cebac bilec catanec eu mugumi ugen?” don. ");
INSERT INTO aey_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Odocob Jisas madon, “Eetanu ija me taga? Dana cunug me qee. Anut himec uqa me bilina. ");
INSERT INTO aey_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Hina Mosesna loo jena eu dogona: ‘Oso cain qagadogaun. Dana cajaca dewenela osol mec cain cagualegaun. Oso uqana ceteteh cain heje cedagaun. Oso uqanu uhulec je cain madagaun. Oso uqana ceteteh cain qaudu cedagaun. Hina anin memenca lalan malagale,’ ena,” don. ");
INSERT INTO aey_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Odocob dana eu uqa Jisas madon, “Iwalgec, ija simnadec cocobi Mosesna loo je eu cunug toodu odom,” don. ");
INSERT INTO aey_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Odocob Jisas uqa mecidumei uqanu nalug meceb madon, “Hinana odoc ihoc ligiannu odoc oso qee odolom eu odogale. Hina nuimeg hina cehewain cunug idadumeg meen qaig eunadec umeg dana sawen eundec siwiadagale. Odi odimeg hina sao jobon ono cehewainca bilegan. Odimeg hu ija tootagale,” don. ");
INSERT INTO aey_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Odocob dana eu uqana ceteh cehewanca mati bahic nijen eunu je eu dumei uqa waug me qee meceb waug culumen dodon Jisas cuculdi nuen. ");
INSERT INTO aey_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Odocob Jisas uqa qaalimei uqana malogom meciadimei maaden, “Dana cehewanagaca eundec age Anutna cul dunuh loqagannu eu cacanigca bahic!” aden. ");
INSERT INTO aey_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Odocob uqana malogom je eu dumeig filicitein. Euqa Jisas uqa je haun maaden, “Ijana mel, Anutna cul dunuh lecnu eu cacanigca bahic! ");
INSERT INTO aey_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel lotoc gisec cese gigilona isec li nuecnu eu cacanigca, euqa dana cehewanca eu Anutna cul dunuh lecnu cacanigca eu wooldoc bahic,” aden. ");
INSERT INTO aey_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Odocob uqana malogom age geh bahic filicitein. Odimeig madoin, “Mele odi nijecebfi oso cahahadocnu eu adi?” doin. ");
INSERT INTO aey_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Odocobil Jisas uqana malogom meciadimei maaden, “Dana age odi odocnu qee nijel euqa Anut uqa ceteh cunug odocnu ihoc. Eunu Anut ihoc odigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Odocob Pita eunu mamadi Jisas madon, “Faga, ege ceteteh cunug culimeb hina toohi coboqona,” don. ");
INSERT INTO aey_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Odocob Jisas maaden, “Ija mele maadigina, oso ijanuca me jenuca uqa jobonfo, waliagulfo, cebinagulfo, anag memegcafo, talaculfo, mahamahafo culina ");
INSERT INTO aey_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","eu uqa maha ina bibili wooldoc ameg ben bahic ugian. Uqa maha ina jobonjobonca, waliagulca, cebinagulca, anagulca, talaculca, mahamahaca haun cedadigian. Odocob uqa maha ina jabi tootoodocha gulucdugian. Odocob uqa saen hibna hugian euna cebac bileceb catanec ugian. ");
INSERT INTO aey_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Euqa mati qila hib bahic taweiga eundec age isi aquni tawoqagan. Odocob mati qila aquni taweiga eundec age isi hib bahic tawoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Age Jerusalem jicna tetegin Jisas aquniadi cobon. Cocoboig uqana malogom age filicitein. Dana hib tooadein eu age cucuiein. Odocobil Jisas uqa haun malogom 12-pela ehadi gesacna limeig eeta uqaca caligian eunu maaden, ");
INSERT INTO aey_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Feiga, ege Jerusalem toqona. Ono age Dana Melah ihanec dana benbenca loo je iwaladecca ebenegana muduqagan. Age uqa cal migiannu geldumeig Juda dana qee eundec ebenegana muduqagan. ");
INSERT INTO aey_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Odocobil age uqa lelandumeig cin qudimeig qisadoqagan. Odimeig age uqa qocobil cal migian. Odocob deel cijed hedocob haun ceseli cajigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Odocob Jems Jonca, Sebedi melahul lecis, ale Jisasca humesi madosin, “Iwalgec, ele ceteh osonu sisilhecnu gale lena. Odocob hina ceteh eu odilecnu gale lena,” dosin. ");
INSERT INTO aey_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Odocobil Jisas sisilali maalen, “Ija eeta odalecnu madesina?” alen. ");
INSERT INTO aey_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Odocob jejeg hewi madosin, “Hina kobolkobolca bilegan saen euna ele oso eben meulana isec, oso eben ansena isec bilec ilegannu je hahun iligale,” dosin. ");
INSERT INTO aey_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Euqa Jisas maalen, “Ale ceteh eunu ninitesina eu caun qee dosina. Wa gab ija jigen eu aleha jecnu ihocfo? Wa joitec ija ugen eu aleha ocnu ihocfo?” alen. ");
INSERT INTO aey_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Odocob ale madosin, “Ese, ele jecnu ihoc,” dosin. Odocobil Jisas maalen, “Wa gab ija jigen eu aleha jowasan. Wa joitec ija ugen eu aleha owasan. ");
INSERT INTO aey_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Euqa bilec cudun ebeni meulana isecca ebeni ansena isecca adecnu eu ijana cabi qee. Eu Anut uqa bilec eu ocnu wele maden eu ale bahic owasan,” alen. ");
INSERT INTO aey_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Odocob malogom 10-pela age je eu dumeig Jems Joncanu wawaga me qee men. ");
INSERT INTO aey_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Odocobil Jisas uqa utaadeceb uqaca hocobil maaden, “Juda dana qee eundec agena ilo egina eu age agena dana gagadic madegina, odocob mahana dana ben age dana cilehadegina eunu age dogina. ");
INSERT INTO aey_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Euqa age gemona odi cain nijiaun. Age gemona oso ija ben biligen ifei uqa cotugul cunug cewel uadeiale. ");
INSERT INTO aey_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Odocob age gemona oso uqa ija matu biligen ifei eu uqa cunug agena begabeg meh cabi dana ibuldoiale. ");
INSERT INTO aey_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ge, Dana Melah ha dana age ija cewel utuqagan imei qee toni nel. Qeeo. Dana Melah uqa dana cajaca cewel uadecnu toni nen. Uqa ijana cebac bilec eu dana cajaca mati besiadec fajadecnu culigen imei eunu toni nen,” aden. ");
INSERT INTO aey_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Age Jeriko taun ono calein. Jisasca uqana malogomca gami dana cajaca mati bahic Jeriko taun cuculdi cocobogin ameg galuc mec dana oso uqa jic gesacna bilen. Uqa ijan Batimias uqa Timias melah, uqa gaid sabnu cesuldoqagannu niniadoloig. ");
INSERT INTO aey_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Dana eu uqa Jisas Nasaretdec hona ec mamadegin dah mimei uqa utai maden, “O Jisas, Dewid Melah, ijanu walol heiale,” en. ");
INSERT INTO aey_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dana cajaca mati age gagaldudu madoin, “Cain utaagaun. Culugale,” doin. Euqa uqa feeaadi co suli u haun utai madon, “Jisas, Dewid Melah, ijanu walol heiale!” don. ");
INSERT INTO aey_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisas tului tawimei dana cajaca maaden, “Utadocobil hoiale,” aden. Odocob age dana ameg galuc mec eu utadu madoin, “Uqa hina utahena. Hina wawin toogdoiale. Cajaga,” doin. ");
INSERT INTO aey_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Odocobil dana eu uqana lotoc ben cagasi helimei busaci caji Jisasca len. ");
INSERT INTO aey_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Odocob Jisas madon, “Ija hina eeta odihigennu matagana?” don. Odocob dana ameg galuc mec eu Jisas madon, “O Meca, ija ceteh fecnu madigina,” don. ");
INSERT INTO aey_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Odocob Jisas madon, “Hina wawin meleec eu me mihia! Gad nuugale,” don. Odocob dana eu mahuc ameg fogo docob uqa ceteteh cunug fen. Odimei uqa Jisas toodocob belein. ");
INSERT INTO aey_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisas uqana malogomca age Jerusalem dodoldodogin Betfasi Betanica jobon ale Oliw Aluhna isec calimei uqana malogom lecis sulaali ");
INSERT INTO aey_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","maalen, “Jobon amigena nijia euna lesia. Ale dunuh lelesi cesel goman manahal oso qagec tataweb eu mahuc gulucdowasan. Cesel eu dana oso tatacan qee bilel. Ale eu cufalimesi ehudi ahosiale. ");
INSERT INTO aey_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dana oso sisilalecebfi, ‘Eetanu odi odosina?’ alecebfi ale madowasan, ‘Tibud cesel eu ocnu eu cabi osoca madena. Uqa mahuc ene ceseli suldugian,’ dowasan,” alen. ");
INSERT INTO aey_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Odocob uqa je odi maaleceb ale belimesi ono cesel goman manahal oso jicna jo cebecna qagec tatawen fesin. Cesel eu cucufalesin ");
INSERT INTO aey_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","dana leih ono gauc tawein eu age maalein, “Ale eeta odosina? Eetanu cesel goman manahal eu cufalesina?” alein. ");
INSERT INTO aey_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Odocobil ale Jisas maalen odi maadesin. Odocob dana eu age culalecebil cesel eu hewi belesin. ");
INSERT INTO aey_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Belimesi cesel eu Jisasca ahosin. Odimesi alena lotoc cesel eu gogodohna duitocobil Jisas uqa ohis tobi bilen. ");
INSERT INTO aey_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dana cajaca mati bahic age agena lotoc jicna duein. Leih age celus cabina qetimeig jicna duein. ");
INSERT INTO aey_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dana cajaca age aqunitutu ha toodudu cocobi age conoga suli u madein: “Hosana! Tibud ijanna hona eu uqa eeldoc biliale! ");
INSERT INTO aey_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ege memige Dewidna cul hona eu eeldoc biliale! Hosana! Anut ohis bilina uqa binan wasi nuiale!” ein. ");
INSERT INTO aey_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas uqa Jerusalem dunuh len. Ono tempel dunuh len. Ono uqa ceteteh cunug talilaadi meciadi cobon qa uqa hib len. Eunu uqa haun ceseli Betani jobon ono uqana malogom 12-pela gami belein. ");
INSERT INTO aey_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cojageceb age Betani jobondec ceceselegin Jisas uqa wen don. ");
INSERT INTO aey_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Uqa na dan bagacca onoca tatawen fen. Odimei uqa ono gug cemenug limei aig oso mogi u jige en. Euqa na dan me aigca qee, eu bagac himec tatawen fen. Ge, eu uqana aig qoc saen qee. ");
INSERT INTO aey_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Odimei uqa na dan madon, “Oso hinana aig haun qee jeiaun!” don. Odocob uqana malogom age je eu doin. ");
INSERT INTO aey_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Age Jerusalem ono calimeig Jisas uqa tempel dunuh len. Ono uqa dana ceteh fajeinca ceteh suldoinca eundec ititacadeceb maha gemo calein. Odimei meen qaig hatu filfil agena wadacwuducein eundec agena cabal sundocob agena meen qaig golodon. Uqa cuhudid suldoc agena cabalha sundocob golodon. ");
INSERT INTO aey_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Odimei agena ceteh cunug cedeceb tempel gemogemo hewi lecnu cahacaden. ");
INSERT INTO aey_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Odimei uqa dana ono iwalaadi maaden, “Anutna jaqec je i qee sanijeleinfo? ‘Ijana jo eu dana cajaca age hatuhatu cunug bilegina eu agenu Anut inondocnu jo oqagan,’ ena. Ageqa agena odocna age falicdocobil heje dana agena jahunec cudun ibuldon!” aden. ");
INSERT INTO aey_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Odocob ihanec dana benbenca loo je iwaladec age je eu dumeig uqa qagadoqagannu jic wali coboin. Ge, dana cajaca cunug uqana iwaladecnu filicitein eunu age cucuidoin. ");
INSERT INTO aey_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wesu memen Jisas uqana malogom gami age Jerusalem culi belein. ");
INSERT INTO aey_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Malogom age qasil jicna bebeleig na dan eu bagacnadec nu gugna calen cunug galalen eu fein. ");
INSERT INTO aey_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Odocob Pita uqa Jisas na dan madonnu cisdumei Jisas madon, “Meca, faga! Na dan hina geuldegan eu galaleian,” don. ");
INSERT INTO aey_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Odocob Jisas uqa malogom maaden, “Age Anutnu wawaga meleeiale. ");
INSERT INTO aey_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ija mele maadigina, oso waug meleec nijialumi waug lecisca qeefi uqa aluh i hina caji macasna tonoga doubmi eu co toodu odoub. Oso uqa eeta madena eu caligian eunu waug meleecebfi eu co toodu caligian. ");
INSERT INTO aey_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Eunu ija maadigina, age cetehnu inondufeig age ceteh eu oqagannu wawaga meleecebfi ceteh eu oqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","“Odocob Memega sao jobon bilia uqa agena silail dahig celigiannu age inondudu tataweig saen euna dana oso uqa hina silail mihen eunu cisdufeig uqana silailnu eu dahiniga celeiale,” aden. ");
INSERT INTO aey_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisas uqana malogomca age Jerusalem ceseli lein. Odimeig Jisas uqa tempel dunuh cocobon ihanec dana benbenca, loo je iwaladecca, Juda agena matuca age uqaca humeig ");
INSERT INTO aey_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","sisildu madoin, “In ijanna hina ceteh eu odogona? In cabi eu ocnu maheceb odogona?” doin. ");
INSERT INTO aey_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Odocobil Jisas jejenega hewi maaden, “Ija casac je oso sisiladigen. Age eu jejeni hewi matecebil ija hibna ha in cabi i iteceb in ijanna ceteh i odigina eu camas mecemin doqagan. ");
INSERT INTO aey_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Eu odi, Jonna wa joadec eu sao jobondecfo, qee dananadecfo? Mateiga duga,” aden. ");
INSERT INTO aey_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Odocob age fee dadani togodudu madein, “Ege madoqaqa wa joadec eu sao jobondec doqaqa uqa ege eetanu uqanu wawaga mele qee el? gigian. ");
INSERT INTO aey_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ege madoqaqa wa joadec eu dananadec doqaqa euha ihoc qee,” ein. Ge, dana cajaca cunug age Jonnu uqa je hahun madec dana mele bahic ein. Eunu age dana cajacanu cucuiein. ");
INSERT INTO aey_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Eu togodu hedumeig age Jisas madoin, “Jonna wa joadec eu anadec ege qee doqona,” doin. Odocobil Jisas maaden, “Eunu ija ageha in cabi i iteceb ugina, in ijanna ceteh i odigina eu qee maadigaun,” aden. ");
INSERT INTO aey_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Odimei Jisas uqa galolo jena sanan mimei maaden, “Dana oso uqa wain cabi cehimei alildu gel faldumei wain aig afdocnu kunum cisimei wain cabi cofdoc biluqagannu jo ben ohis tobi eit fec ihoc eu odi cehen. Odimei uqana wain cabi dana leih cabi oqagannu ebenegana mimei uqa hatu osona nuen. ");
INSERT INTO aey_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wain aig wal meceb cedec saen cali hocob wain cabi gug uqa cabi dana oso suldudu madon, ‘Hina nuimeg wain cabi oc eundec maadecem age wain aig leih eu ihecebil cedi ahutagale,’ don. ");
INSERT INTO aey_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Odocob dana age wain cabi cofdoin eu age cabi dana hewimeig deweg tudumeig wain aig ameg oso qee utec suldocobil ceselen. ");
INSERT INTO aey_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Odocob wain cabi gug uqa haun uqana cabi dana oso suldocob nuen. Odocob wain cabi cofdoin eu ageha cabi dana eu ilo qumeig me qee mudein. ");
INSERT INTO aey_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Odocobil wain cabi gug uqa cabi dana oso suldocob nuen. Odocob age uqa qocobil cal men. Odocobil wain cabi gug uqa haun ceseli cabi dana matica suladen. Euqa ageha cabi dana cunug odi odadein. Age leih dewenega tudoin, age leih aqecebil cal mein. ");
INSERT INTO aey_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wain cabi gug uqa dana suldocnu osol bilen, uqa melah nalug men. Cit qocna uqa melah sulduaden. Ge, uqa maden, ‘Ija melaminu cumundoqagan,’ en. ");
INSERT INTO aey_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Euqa wain cabi cofdoc age togodu madein, ‘I cabi gug huqaneh, uqa isi wain cabi ugian. Cois uqa muguh eu ege oqannu ege cajimeb qocomun cal mecnu!’ ein. ");
INSERT INTO aey_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Odimeig age mel eu hewi sundudu qocobil cal meceb wain cabi dunuhdec heludecebil maha gemo calen,” aden. ");
INSERT INTO aey_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Wain cabi gug uqa wain cabi cofdoc dana eeta odadigian? Uqa humei wain cabi cofdoc fadaladeceb cal moqagan. Odimei wain cabi eu dana filfil adigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Jaqec je oso Anutna je jaqec tawena eu qee sanijeleinfo? Je eu odi madena: ‘Meen oso meen gel cehec memei dana age culein eu qila meen jo big gug jo hehdocnu calen. ");
INSERT INTO aey_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Eu Tibud uqadodoc odi odon. Ceteh eu foqona eu kobolkobolca,’ ena,” aden. ");
INSERT INTO aey_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Odocob loo je iwaladecca, ihanec dana benbenca age Jisasna galolo je eu dah mimeig age uqa je eu agenu maden eunu wawaga fogo don. Eunu age uqa heweqan ein euqa age dana cajacanu cucuiein. Odimeig age Jisas cuculdi belein. ");
INSERT INTO aey_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ihanec dana benbenca, loo je iwaladecca, Juda agena matuca age Farisi leihca Herodna sihul leihca Jisas suladitocobil lein. Age ege Jisas cona je oso cahuldu madeceb uqa dewegnu geuldec je oso oqan imeig lein. ");
INSERT INTO aey_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Age uqaca humeig madoin, “Iwalgec, ege hinanu doqona, hina mele je madagana, hina dana binanagaca eundecnu qee cucuiagana. Ge, hina dana saolal madec bilegina eundecnu qee jogoagana qa hina Anutna jic tutuc iwaladagana. Ege Sisanu takis helecnu eu tutucfo, qee tutuc qeefo? ");
INSERT INTO aey_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ege Rom agena takis heleqanfo, qee eu qee heloqaunfo?” doin. Euqa Jisas uqa age me hihili qaudoin eu dumei maaden, “Age eetanu temtegina? Meen qaig oso ahutecebil ija figen,” aden. ");
INSERT INTO aey_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Odocob age meen qaig oso ahu utein. Odocobil uqa sisiladi maaden, “Meen qaig ina in hahun eu gaga qoc taweia? In ijanha jaqec taweia?” aden. Odocob age madoin, “Eu Sisa uqana,” doin. ");
INSERT INTO aey_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Odocobil Jisas maaden, “Age Sisana ceteteh eu Sisa uteiga. Anut toinan eu Anut uteiga,” aden. Odocob age je eu maadeceb dumeig tumatumaein. ");
INSERT INTO aey_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadjusi age Jisasca hoin. Sadjusi age cal mein eundec ceseli qee cajowain egina. Age Jisas je oso sisildu madoin, ");
INSERT INTO aey_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Iwalgec, Moses uqa loo je jaqec oso igen eu odi madena, ‘Dana oso uqa waliag cal mimei aideg culdigian qa melca qeefi dana eu uqa waliag cal men euna mel basituwasannu aideg eu ugian,’ ena. ");
INSERT INTO aey_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Saen osona waliagul 7-pela biloloig. Matu eu caja on. Odimei uqa aideg mel qee basec cal men. ");
INSERT INTO aey_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Odocob waliag lecisdoc uqa caja eu on. Uqaha aideg mel qee basec cal men. Odocob waliag cijeddoc uqaha odi odon. ");
INSERT INTO aey_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Waliagul 7-pela cunug odi odimeig caja eu mel qee basec cunug cal mein. Hibna caja euha cal men. ");
INSERT INTO aey_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aria, waliagul 7-pela cunug uqa age osolosol agena caja bilen. Eunu ceseli cajec saenna caja eu in aideg biligian?” doin. ");
INSERT INTO aey_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Odocobil Jisas maaden, “Age Anutna jaqec je nijia eu qee dogina, age Anutna gagadic odocha qee dogina. Eunu age dadanec bilegina. ");
INSERT INTO aey_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ge, age cal mecnadec ceseli cajoqagan saenna eu age dana caja ocobocob qee owain. Euqa age ensel sao jobon bileginawe odi biluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Cal mecnadec ceseli cajec eunu je oso nijia. Age Mosesna jaqec jena Moses uqa na nag ja cijennu jaqen eu qee sanijeleinfo? Jaqec je cudun euna Anut uqa Moses madon: ‘Ija Ebrahamna Anut, ija Aisakna Anut, ija Jekobna Anut,’ don. ");
INSERT INTO aey_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Anut uqa cal mein agena Anut qee. Euqa uqa cebac bilegina agena Anut. Age dadanec bahic,” aden. ");
INSERT INTO aey_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Loo je iwaladec dana oso uqa Sadjusi age Jisas je maaden eunu fee dadaneegin dah men. Odimei uqa Jisas wadacdoc je me bahic maaden eu fimei uqa limei Jisas sisildon, “Loo je meca bahic Mosesna loo je oso cunug wooldoc cel loo je nijia?” don. ");
INSERT INTO aey_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Odocob Jisas jejeg hewi madon, “Loo je caunca bahic eu odi madena: ‘O Isrel dah meigale, Tibud uqa egena Anut, Tibud uqa osol bilina. ");
INSERT INTO aey_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Odocob hina Tibud, hinana Anutnu wawin cunugca, doloin cunugca, hinana cisdoc cunugca, hinana gagadic cunugca euna nalug magale,’ ena. ");
INSERT INTO aey_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Uqana toodoc eu odi madena: ‘Hina hinanel nalunin maganawe odi hina utuqain bilec eundecnu nalug magale,’ ena. Loo je oso loo je lecis i woolalec qee nijel,” don. ");
INSERT INTO aey_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Odocob loo je iwaladec uqa Jisas madon, “Iwalgec, hinana je eu tutuc bahic! Hina mele madaga, ‘Tibud uqa osol bilina, Tibud oso qee bilina,’ aga. ");
INSERT INTO aey_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Odocob ege Anutnu wawige cunugca, egena doc cunugca, egena gagadic cunugca euna nalug moqonafi eu me bahic. Ege egedodocnu nalunige moqonawe odi utuqanige bilegina agenu nalunuga moqonafi euha me bahic. Ege loo je lecis i toodu odocomunfi kobol eu ihanec cunug age jana maneginaca ihanec filfil cunugca wooladena,” don. ");
INSERT INTO aey_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Odocob Jisas uqa loo je iwaladec eu je cisdoc silecca maden eu fimei madon, “Hina Anutna cul cemenug biliga,” don. Odocob dana cunug ono bilein age Jisas je oso haun sisildocnu culein. ");
INSERT INTO aey_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas uqa tempel dunuh dana cajaca iwalaadi bilei je oso sisiladen, “Loo je iwaladec dana age adi madegina, ‘Krais eu Dewid Melah,’ egina? ");
INSERT INTO aey_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kis Gun uqa Dewid dado mudeceb uqadodoc maden: ‘Anut Tibud uqa ijana Tibud odi maden, “Ijaca hu ebeni meulana isec bibilem ija odocomin hinana cad cunug hu ninijebil hina jaimna lahacadegan,” en,’ Dewid odi maden. ");
INSERT INTO aey_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dewid uqadodoc Kraisnu madi, uqa ijana Tibud, en, eunu adi uqa Dewid Melah bilina?” aden. Dana cajaca mati bahic cegulein eu age Jisasna je docnu geh bahic gale aden. ");
INSERT INTO aey_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Odocob Jisas uqa je iwalaadi bilei maaden, “Age loo je iwaladec dananu batut feigale. Loo je iwaladec age lotoc cecelac tacimeig cocobi nuecnu gale adena. Age ceteteh idadec cudunna age binanaga sulecnu gale adena. ");
INSERT INTO aey_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Age cuha jona cabal me cudunna bilecnu gale adena. Odimeig age sab ben jec saenna bilec binanca euna bilecnu gale adena. ");
INSERT INTO aey_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Age caja wij agena jo heje cedegina. Odimeig age dana me bahic meciadecnu saen cecelac bahic inondogina. Dana eundec age agena cahuldocnu ameg me qee bahic oqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas uqa meen qaig helecnu tempel bokis cemenug bilen. Odimei uqa dana cajaca humeig meen qaig bokisna hehelegin fen. Dana caja cehewanagaca mati age meen qaig ben helein. ");
INSERT INTO aey_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Odocob caja wij sawen oso humei uqa meen qaig nag lecis helen eu toea osol ihoc. ");
INSERT INTO aey_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Odocob Jisas uqana malogom utaadeceb cemenug cegulecebil maaden, “Ija mele maadigina, caja wij sawen i uqa meen qaig nag heleia eu dana cajaca age tempel bokisna meen qaig ben bahic heleiga cunug wooladena. ");
INSERT INTO aey_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ge, dana cajaca eundec age cehewanaga bennadec meen qaig heleiga qa caja wij i uqa sawen bahic, uqa uqana meen qaig cunug heleia. Uqa uqana ceteh cebac bilecnu oso qee culel,” aden. ");
INSERT INTO aey_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Odocob Jisas uqa tempelnadec cali hohon uqana malogom oso madon, “Iwalgec, faga! Meen joca me bahic taweiga!” don. ");
INSERT INTO aey_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Odocob Jisas madon, “Hina jo ben i faganafo? Meen gel ulugedocob meen oso meen oso tatacanna cilehdoc qee biliaun. Cunug wagalecebil mahana tonoqagan,” don. ");
INSERT INTO aey_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas uqa Oliw Aluh ohis bibilei tempel onoca fen. Bibilen Pitaca, Jemsca, Jonca, Andruca cuhanuc uqaca limeig jahuni sisildoin, ");
INSERT INTO aey_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Aadeb eu odi odigian ec magaga doqa. Cel gaga odocob fimeb ceteh i camasac caligiannu saen doqan?” doin. ");
INSERT INTO aey_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Odocob Jisas jejenega hewi maaden, “Oso hu faninadi dado madeceb agena jic ceja qocna lowainnu batut feigale. ");
INSERT INTO aey_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Matica age ija ijanina mamadi hoqagan, ‘Ija uqa,’ oqagan. Eu age dana cajaca mati faninadi jic ceja qocna loqagannu dado madoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Age han cadegina ec eunuca han hugian ec eunuca je hutan doqagan saen euna cain filicituwain. Ceteh eu cunug odigian. Euqa qee migian ec madecnu qee nijel. Eu cit qoc qee. ");
INSERT INTO aey_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ge, dana hatuhatu age cajimeig cilehdocobcilehdocoboqagan. Odocobil dana sihulsihul age cajimeig cilehdocobcilehdocoboqagan. Mim maha filfilna nigian, sabnu cahel bilec saenha hugian. Eu caligianqa caja mel basecnu dain donawe eu odi himec sanan migian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Euqa dana age ehadi limeig agena cegulec amegna madoqagan. Eunu age agedodocnu cofdoigale. Age Juda agena cuha jona dewenega tudoqagan. Age ija ijaninu ijana me je qasali maadecnu hatu cofdocca kingca ehadi li amagana madoqagan. ");
INSERT INTO aey_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Odocob Anutna me je eu casac hatuhatu cunug qasali maadecebil dana cajaca cunug doqagan. ");
INSERT INTO aey_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Dana age ehadimeig gesiladecnu cegulec amegna madoqagan saen euna age cel je cel je madigen eu casac cain jaen aqeiaun. Euqa age saen euna Kis Gun je adeceb je eu tutuc madoqagan. Ge, agedodoc je qee madowain, Kis Gun eu age uqa co tawecebil je madigian. ");
INSERT INTO aey_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Saen euna dana age walinigailnu balijecebil aqecebil cal moqagan. Dana agena melnu balijecebil aqecebil cal moqagan. Mel age memegail anagailcanu cajimeig aqoqagannu gesilec jona madoqagan. ");
INSERT INTO aey_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Odocob age ija ijani hewegina eunu dana cajaca cunug age agenu gemanaga beceb sagagadoqagan. Euqa oso uqa waug gagadic mumudi hib cit qoc gadacna caligian eundec Anut uqa cahahaadigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jisas je haun maaden, “Age ‘ihulahal mec ceteh bebesacca’ uqana cudun qee euna mudecebil tataweb eu camas meceb euna batut feigale,” aden. Dana uqa je i sanijina eu uqa je uqana gug doiale. “Saen euna dana cajaca age Judia hatuna bilegina age busali aluhnana toboqagan. ");
INSERT INTO aey_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Oso jo ohis qab tatacan bilina cain toneiaun. Uqa uqana ud cedi nuecnu jona cain leiaun. ");
INSERT INTO aey_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Oso cabina bilina eu uqa uqana lotoc ben cedecnu jobon ceseli cain hoiaun. ");
INSERT INTO aey_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Saen euna caja waugca coboc, caja mel sim su adegina eundec walocca bahic biluqagan! ");
INSERT INTO aey_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Busalec deel eu duan saenna cali hoiaunnu Anut inondoigale. ");
INSERT INTO aey_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ge, saen euna culumen ben bahic caligian. Saen maha haun ifanennadec hocob qila wele culumen eu odi oso qee calel. Hibna culumen eu odi oso haun qee caleiaun. ");
INSERT INTO aey_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tibud saen i gohic qee mudoubmi dana oso cahahadoc qee gulucdoub. Euqa dana cajaca Tibud nesili ceden bilegina agenu saen eu gohic mudigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Saen euna oso maadecebfi, ‘Feiga, Anutna Krais eu ihen!’ qee, ‘Feiga, Anutna Krais ono bilia!’ adecebfi je eunu wawaga cain meleeiaun. ");
INSERT INTO aey_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Uhulec Kraisca uhulec je hahun madec danaca mati cali humeig age dana cajaca Anut nesili cedaden bilegina euha faninadoqagan imeig kobolkobol odoc filfilca gaga ben matica odoqagan. ");
INSERT INTO aey_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Euqa age batut feigale! Ceteh qee hoc ninijen ija ceteh eu hugiannu wele maadem,” aden. ");
INSERT INTO aey_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jisas je haun maaden, “Feiga, saen euna culumen ben eu hedocob ‘cam tu meceb jagel qee fulacdoiaun. ");
INSERT INTO aey_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Odocob malaqa age saonadec casili tonoqagan, odocob gagadic odoc age saona bilegina caji leceb hocob qeleloqagan,’ en. ");
INSERT INTO aey_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Odocob Dana Melah uqana camas mec gaga saona camas migian. Age Dana Melah gagadic odoc gehca kobolkobolca taenna neneb foqagan. ");
INSERT INTO aey_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Uqa ensel suladeceb age belimeig uqana nesili cedadec bilegina eu mahamaha cunugnadec cedoqagan. Age maha cunugnadec cedadi ehadi li sao jobon cunugnadec ha ehadi ahu gabanadoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jisas je haun maaden, “Age na dan uqana odocnu cisdoigale. Uqa haun majocob age qila wa hugian odona egina. ");
INSERT INTO aey_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Odiwe ha age ceteh eu oodob fimeig Dana Melah ceseli hocnu deel cemenug nijia ec doqagan, uqa taun gel jic cebecna taweia doqagan. ");
INSERT INTO aey_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ija mele maadigina, sihul i qila bilegina ceteh qee cali hoc ninijeb qee qee meiaun. ");
INSERT INTO aey_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Saoca mahaca qee migian euqa ijana je qee qee meiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jisas je haun maaden, “Ceteh eu cali hugiannu deelca auaca oso qee dona. Ensel sao jobon bilegina ha qee dogina. Dana Melahha qee dona. Memige Anut uqa himec dona,” aden. ");
INSERT INTO aey_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Dana Melah ceseli hocnu deel age qee dogina. Eunu batut feiga, age mecii cuhadoigale. ");
INSERT INTO aey_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dana Melah ceseli hoc deel eu odiwe nijia. Dana cehewanca oso uqa hatu oso nuigia bili uqana cabi dana utaadeceb hocobil uqana ceteteh age ebenegana men. Uqa cabi dana dumanaga nesili fimei age dumanaga nijen eu odi toodu uqana ceteteh siwiaden. Odimei uqa jic cebec cofdoc dana madon, ‘Hina ija hugennu gaid meciagale,’ don. ");
INSERT INTO aey_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Eunu amaga cebac bileigale! Ge, age jo gug aadeb hugian eu age qee dogina. Uqa wesufo, tu gemofo, qasil bahicfo, cahinegfo hugian eu age qee dogina. ");
INSERT INTO aey_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Age ququlubadi hufei us ninijebil cain gulucadeiaun. ");
INSERT INTO aey_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ija je i age maadigina eu ija dana cajaca cunugnu maadigina, age gaid mecieigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pasowa Sab Jec Benca, Bred Jisca Qee Sab Jecca deel lecis hedocob caligia ninijen ihanec dana benbenca loo je iwaladecca age Jisas jahuni hewi qocnu jic oso wali feqan i togodoin. ");
INSERT INTO aey_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Euqa age madein, “Dana cajaca caji uqanu mimi ege cilehgowainnu Pasowa sab jecna cain odoqaun,” ein. ");
INSERT INTO aey_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas uqa Betani jobon ono Saimonna jona bilen. Saimon eu uqa wele deweg lepra heweceb coboloi. Jisas uqa ono sab jiji bibilen caja oso meen gum eu mool dedeman me bahic fajecnu qaig ben bahic nijen eu ahumei meen gum fuhudumei mool eu Jisas ilona basecdon. ");
INSERT INTO aey_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Euqa dana leih ono tawein eu qee gale adeceb togodudu madein, “Uqa eetanu mool dedeman me bahic eu cusdoia? ");
INSERT INTO aey_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ge, mool eu meen qaig silwana mudec 300nu idadoubmi meen qaig eu dana sawen bahic eundec siwiadoubmi eu me,” ein. Odimeig age caja galac mudein. ");
INSERT INTO aey_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Euqa Jisas maaden, “Age culdeiga! Age eetanu caja eu culumen doc utegina? Uqa ceteh me bahic oditia. ");
INSERT INTO aey_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ge, age gemona dana sawen bilec eundec gaid biluqagan. Odocob age cel saen gale adecna cesuladoqagan. Ijaqa gaid age gami qee biluqaun. ");
INSERT INTO aey_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ceteh i uqa odocnu nijecebnu odeia. Uqa mool ilomina basecdoia euna ija qee cal mec deweni heelna mudecnu joidia. ");
INSERT INTO aey_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ija mele maadigina, me je anaana maha cunug qasali maadi cobimeig age caja eu oditia eu uqanu cisdoqagannu saadoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Saen euna Judas Iskariot, uqa Jisasna malogom oso, uqa ihanec dana benben cemenegana limei Jisas age ebenegana mudigiannu maaden. ");
INSERT INTO aey_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Age je eu dumeig wawaga ceeleceb age meen qaig utuqagannu je hahun madoin. Odocobil Judas uqa Jisas dewegnu ob mimei age ebenegana mudigiannu jic walen. ");
INSERT INTO aey_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Odocob Pasowa sab jec bred jisca qee jecnu uqana deel gun cali hon. Deel euna Juda dana age sipsip nag Pasowana ihandoloig. Uqana malogom Jisas madoin, “Ege ana limeb hina Pasowa sab jegannu saciadocnu gale hena?” doin. ");
INSERT INTO aey_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Odocobil uqana malogom lecis sulali maalen, “Ale taun benna lecebil dana oso uqa halon waca gahidu humei gulucaligian. Ale uqa toodu lesi ");
INSERT INTO aey_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","uqa cel jona leceb toodosia. Odimesi jo gug eu madosia, ‘Iwalgec maheia, “Jo hamol ija ijana malogom gami Pasowa ja qoc sab jecnu eu ai?” heia,’ dosia. ");
INSERT INTO aey_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Odocob uqa hamol ben ohis eu sab jec cabalca bilec cabal ceteh cunugca ihacaligian. Ale ege Pasowa ja qoc sab jecnu euna saciadosia,” alen. ");
INSERT INTO aey_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Odocob malogom lecis ale leih culadimesi taun benna belesin. Odimesi ono ale Jisas maalen odi bahic gulucdosin. Euna ale Pasowa ja qoc sab jecnu saciadosin. ");
INSERT INTO aey_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Odocobil witic meceb Jisas uqana malogom 12-pela gami hoin. ");
INSERT INTO aey_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sab jiji cabalna bibileig Jisas maaden, “Ija mele maadigina, age oso uqa ija gami sab joqona eu ijana cad ebenegana mitigian,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Odocob age je eu dumeig uqana malogom waloc adeceb abesabes sisildudu madoin, “Hina ija ec madaganafo?” doin. ");
INSERT INTO aey_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Odocobil Jisas maaden, “Eu ijana malogom 12-pela oso uqa ijaca gami bred bohna wehuc tanoqona eu odigian. ");
INSERT INTO aey_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ge, Dana Melah uqa wele Anut je jaqen odi toodugian eunu jic eu toodugian qa dana uqa ijana cad ebenegana mitigian eu walocca biliale! Dana eu anag qee basoubmi eu me bahic nijoub,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Age sab jejeig Jisas bred oso umei Anut hetaga dumei feni malogom siwiadimei maaden, “Eu ija deweni. Oiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Odimei uqa wain gabin umei Anut hetaga dumei malogom adeceb age cunug gabin euna gab jein. ");
INSERT INTO aey_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Odocobil Jisas maaden, “Wain gabin i ija golani eu Anutna bal cehec je haun. Ija dana cajaca mati cesuladigennu golani basecdugina. ");
INSERT INTO aey_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ija mele maadigina, ija wain aig qee jec li hibna ija age gami Anutna culna haun jeqan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Odocob age binan sulec due silimeig age taun ben cuculi Oliw Aluhna belein. ");
INSERT INTO aey_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Odocob Jisas uqa malogom maaden, “Age cunug ijanu wawaga meleec tonigian. Ge, Anutna jaqec je oso nijia eu ihen: ‘Ija sipsip cofadec dana qocomin sipsip cunug bilisadu beloqagan,’ ec nijia. ");
INSERT INTO aey_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Euqa hibna Anut uqa tuliteceb ija ceseli cajimig aquniadi Galili ono nuigen,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Odocob Pita madon, “Leih cunug age wawaga meleec tonigianfa, ijaqa qee bahic qee wawi meleec toneiaun!” don. ");
INSERT INTO aey_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Odocob Jisas uqa Pita jejeg hewi madon, “Ija mele mahigina, witic ina mala manahal qee qu lecisdoc ninijeb hina madegan, ‘Uqanu qee dugina,’ i cijeddogan,” don. ");
INSERT INTO aey_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Odocob Pita je gagadic madon, “Ija hinaca cal mewannu nijecebfi ija hinanu qee bahic qee sasac qugaun,” don. Odocob malogom cunugha je odi madein. ");
INSERT INTO aey_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Age cocobi li cudun oso, Getsemani egina, euna calimeig Jisas uqana malogom maaden, “Age ene bibilebil Anut inondudu biligen,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Odimei uqa Pitaca, Jemsca, Jonca ehadeceb limeig Jisas waug me qee meceb duman culeceb ");
INSERT INTO aey_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","maaden, “Dumani culia, cal mecnu odi oditina. Age ene cebac bibili mecieigale,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Odi maadimei uqa nag odi qisacadi nu mahulimei inondon. Uqa jic osocafi temdoc ben uqaca hona eu wooldocnu gale don. ");
INSERT INTO aey_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Uqa Anut inondon, “Aba Mei, hina ceteh cunug odocnu ihoc. Gabin i ija cagasitagale. Euqa ija gale tecna cain odogaun, hina gale hecna toodu odoga,” don. ");
INSERT INTO aey_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Odimei uqa malogomca limei age us ninijegin feciadimei Pita madon, “Saimon, hina us nijigafo? Hina aua osol cebac bibili meciecnu uein qee nijelfo? ");
INSERT INTO aey_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Age temadecna lowainnu cebac bibili inondoigale. Wawaga odigen ena eu mele euqa dewenega gagadic odocca qee,” don. ");
INSERT INTO aey_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Odi madumei ceseli li Memeg inondon. Uqa je wele maden eu haun inondon. ");
INSERT INTO aey_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Odimei caji haun ceseli malogom cemenega limei age us ninijegin feciaden. Ge, age amaga mumugcanu eu mecii bilecwe qee. Age cel je madocnu qee cisdoloin. ");
INSERT INTO aey_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Uqa saen cijedna ceseli humei maaden, “Age gaid jaen mumudi bibileig us nijeigafo? Eu ihoc, saen wele hoia! Feiga, age qila Dana Melah silail dana ebenegana moqagan. ");
INSERT INTO aey_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Cajecebil beloqa. Feiga, dana ija deweninu balijigian eu wele hona,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Uqana malogom maaaden Judas, malogom 12-pela eundec oso, uqa hon. Uqa gami dana mati bahic age han siginca han galabca hewi hoin. Ihanec dana benbenca Juda agena matuca age suladecebil hoin. ");
INSERT INTO aey_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aria, dana uqa Jisas uqana cad ebenegana mudigiannu maden eu uqa wele han dana foqagannu gaga oso mecnu odi maaden, “Dana ija cotdugen eu uqa hewimeig me cofdudu ehudi beleiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Odocob dana eu humei uqa mahuc Jisasca limei madon, “O Meca!” don. Odimei uqa Jisas cotdon. ");
INSERT INTO aey_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Odocob han dana age Jisas eben gagadic hewein. ");
INSERT INTO aey_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Euqa dana oso Jisasca gami tawein eu eben nocob han sigin umei ihanec dana ilona cabi dana qelimei dahig cagon. ");
INSERT INTO aey_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Odocob Jisas maaden, “Eetanu age han siginca han galabca heje oc dana cinigwe ija hewituqagannu hoiga? ");
INSERT INTO aey_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ija deel cunugnana ageca tempelna bibileb iwaladolig. Odocob age ija hewitecnu oso qee odoloin. Euqa Anutna jaqec je ihoc ligiannu ceteh i cunug calen,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Odocob uqana eundec cunug qisacdumeig busalein. ");
INSERT INTO aey_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Dana haun oso lotoc nag himec taqen uqa Jisas toodon. Age uqa hewoqaga bili odoin. ");
INSERT INTO aey_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Euqa uqa bical bubusali bilei lotoc eu culen. ");
INSERT INTO aey_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Odocob age Jisas ehudi ihanec dana agena ilo amegna mudein. Ono ihanec dana benbenca, Juda agena matuca, loo je iwaladecca age cunug cegulein. ");
INSERT INTO aey_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita uqa tabag hehewi tooaden. Tooadimei uqa ihanec dana ilo uqana jona len. Uqa jo gel dunuh limei jo cofdoc dana gami deweg ja walac dodon bilen. ");
INSERT INTO aey_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Aria, ihanec dana benbenca, Juda dana ben cunug ceguleinca age Jisas dewegnu ob mec je amagana fec dahinigana doc eundec je walein. Oso camas meceb eu toodu geldocomun cal migian ein. Euqa age oso qee gulucdoloin. ");
INSERT INTO aey_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ge, dana mati bahic dewegnu ob mecnu cajimeig odi oodon fom, odi mamaden dom uhulii madein euqa agena je cunug ihocihoc qee camas mel. ");
INSERT INTO aey_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Odocobil dana leih caji tawimeig Jisasnu ob mecnu je odi uhuli madein, ");
INSERT INTO aey_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ege uqa, ‘Ija tempel i dana ebenegana cehein eu wagalimig deel cijedna tempel oso ebenegana qee cehec eu cehigen,’ eceb dom,” ein. ");
INSERT INTO aey_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Age odi madeinqa ageha agena je ihocihoc qee camas mel. ");
INSERT INTO aey_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Odocobil ihanec dana ilo cegulec gemona tawimei Jisas sisildon, “Dana i age cel je hina dewennu madegina? Hina jejenega hewi je oso madecwe qeefo?” don. ");
INSERT INTO aey_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Euqa Jisas uqa jejeg qee hewel, je oso qee madel. Odocob ihanec dana ilo uqa Jisas haun sisildudu madon, “Krais eu hinafo? Hina Anut Binanca eu uqa Melahfo?” don. ");
INSERT INTO aey_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Odocob Jisas madon, “Eu ija bahic! Age Dana Melah Anut gagadic odocca eben meulana isec bibileb sao taenna ha hohob foqagan,” don. ");
INSERT INTO aey_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Odocob ihanec dana ilo uqana lotoc ben hewi balahadumei maaden, “Ege eetanu dana age dana inu je madoqagannu oso waloqona? ");
INSERT INTO aey_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Uqa Anutnu je me qee madeia. Eu age cunug dah meiga. Age eeta madegina?” aden. Odocob age cunug uqa cal migiannu deweg je nijia ec madein. ");
INSERT INTO aey_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Age odi madecebil leih age Jisas cin qoin. Leih age ameg jahuldumeig ola tududu madoin, “Je hahun magaga doqa!” doin. Odocobil ihanec dana ben uqana jona cofdoc dana age Jisas siho qaqahi ehudi lein. ");
INSERT INTO aey_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Age Jisas geldodogin Pita uqa jo gel dunuh bilen. Bibilen ihanec dana ilona cabi mel aid oso cemenug humei ");
INSERT INTO aey_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita uqa deweg ja walac dodon mecidumei madon, “Hinaha Jisas Nasaretdecca bilein,” don. ");
INSERT INTO aey_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Euqa Pita uqa qee sasac qu mel aid madon, “Hina madagana eu ija dadanigina, hina eetanu madagana eu qee dugina,” don. Madumei gesacna jic cebecna isec len. ");
INSERT INTO aey_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Odocob cabi mel aid ono mecidumei uqa haun mamadi ono tawein eundec maaden, “Dana i uqa age eundec oso,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pitaqa haun qee sasac qon. Saen nag gieceb ono tawein eundec age hu Pita haun madoin, “Mele bahic hinaha eundec oso. Ge, hina Galilidec,” doin. ");
INSERT INTO aey_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Odocob agena kobolna uqa mele bahic mamadi maaden, “Age dana inu madegina eu qee dugina,” aden. ");
INSERT INTO aey_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Madeceb mala manahal saen lecisdocna qon. Odocob Pita Jisas wele madon, “Mala manahal qee qu lecisdoc ninijeb hina ijana biligina eu qee sasac qu cijeddogan,” don eunu dahig fogo docob waug cagocob qajen. ");
INSERT INTO aey_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Walag daneceb ihanec dana benbenca, Juda agena matuca, loo je iwaladecca age gabandumeig je togodoin. Togodu hedumeig age Jisas eben libimeig ehudi limeig Pailat, Rom gabman dana matu, ebenna mudein. ");
INSERT INTO aey_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Odocobil Pailat uqa Jisas sisildon, “Juda agena king eu hinafo?” don. Odocob Jisas jejeg hewi madon, “Hina madagana odi himec,” don. ");
INSERT INTO aey_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Odocob ihanec dana benben age dewegnu je geh um qu madein. ");
INSERT INTO aey_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Odocobil Pailat haun sisildon, “Faga, age dewennu je geh um qu madegina. Hina jejenega qee hewagaunfo?” don. ");
INSERT INTO aey_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Euqa Jisas jejeg qee hewel. Eunu Pailat geh cisdon. ");
INSERT INTO aey_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pailat uqa Juda agena Sab Jec Deel Ben ina gaid gihacdoc dana oso Juda dana age agedodoc dana eu besitugaga ecebil eu besituadoloi. ");
INSERT INTO aey_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Saen euna age dana Rom gabmanca cadein eu gihacdoc jona madecebil bilein. Dana eundec oso, ijan Barabas, gihacdoc jona bilen uqa Rom gabmanca cadein saen euna dana qocob cal men. ");
INSERT INTO aey_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Juda dana cajaca age ceguli bibileig Pailat uqana kobol gaid Juda dana odadoloi eu toodu odigiannu sisildudu madoin. ");
INSERT INTO aey_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Odocobil Pailat sisiladen, “Ija Juda agena king besi uadecnu wawaga nijiafo?” aden. ");
INSERT INTO aey_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ge, Pailat uqa ihanec dana benben age Jisasnu macumac mimi uqa ebenna mudein eu don. ");
INSERT INTO aey_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Euqa ihanec dana benben age dana cajaca ceguli bilein eu sigaladecebil age Pailat Jisas besi uadecnu qee madein. Age Barabas besitugagale ec madein. ");
INSERT INTO aey_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Odocobil Pailat haun sisiladi maaden, “Ija dana age Juda agena king egina eu eeta odudigen?” aden. ");
INSERT INTO aey_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Odocob age haun utai madoin, “Na babalecna tuitu qoga!” doin. ");
INSERT INTO aey_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Odocobil Pailat maaden, “Eetanu? Uqa cel qisol mec odon?” aden. ");
INSERT INTO aey_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Eunu Pailat uqa dana cajaca wawaga me nijigia bili imei Barabas besiaden. Odimei uqa han dana maadeceb age Jisas ehudimeig qisadoin. Qisadu hedocobil uqa Jisas na babalecna tuitu qumeig caqusecebil caculimei cal mecnu han dana ebenegana muden. ");
INSERT INTO aey_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Han dana age Jisas ehudimeig jo gabman dana ben bilia euna lein. Age Rom gabman dana ben uqana cudun mudein. Odimeig age han dana am cunug utaadecebil humeig osobenca cegulein. ");
INSERT INTO aey_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Age lotoc golca oso tacitoin. Odimeig age halu dud lalic qumeig king katakat mudimeig gulodutoin. ");
INSERT INTO aey_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Odimeig age binan susuli lelandudu madoin, “O Juda agena king, feele!” doin. ");
INSERT INTO aey_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Odimeig age sih u ilo qagimeig cin qumeig amegna gob cehi uqanu cuha fein. ");
INSERT INTO aey_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Age lelandu hedumeig lotoc golca hulitumeig uqana lotoc haun tacitoin. Odimeig age ehudi li na babalecna tuitu qocnu cali li belein. ");
INSERT INTO aey_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Age bebeleig han dana age Saimon Sairinidec uqa bahudec taun ben dunuh hohon madocobil Jisasna na babalec gahidon. Saimon Sairinidec uqa Aleksanda Rufasca memela. ");
INSERT INTO aey_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Belimeig age cudun Golgota ein euna Jisas ehudi ehi tein. Golgota ijan gug eu “Ilo gatic cudun.” ");
INSERT INTO aey_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Age wain ceteh gulihinca gabandoc eu jecnu utein. Euqa uqa qee jel. ");
INSERT INTO aey_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Age Jisas na babalecna tuitu qumeig caqusecebil caculeceb uqana lotoc agedodoc siwiadein. Age uqana lotoc inni siwi cedecnu satu udoin. ");
INSERT INTO aey_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eu 9 kilok qasil age uqa na babalecna tuitu qoin. ");
INSERT INTO aey_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Age dewegnu je madein eu jaqi qoin, “Uqa Juda agena King.” ");
INSERT INTO aey_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Age Jisas cemenug heje oc dana lecis na babalecna tuitu aqalimeig caqusalecebil caculesin. Oso eben meulana isec tuitu qoin, oso eben ansena isec tuitu qoin. ");
INSERT INTO aey_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Odocob dana cajaca age hu li i bileig age lelandudu ilomoga culidudu je ilag madoin, “Se, hina tempel wagalimig deel cijedna haun cehigen em, ");
INSERT INTO aey_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","hinadodoc cahahadumeg na babalecnadec toni naga!” doin. ");
INSERT INTO aey_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ihanec dana benbenca, loo je iwaladecca ageha lelandudu madein, “Uqa leih cahahaaden euqa uqadodoc cahahadocnu ihoc qee. ");
INSERT INTO aey_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Uqa Kraisfi, uqa Isrel egena kingfi uqa qila na babalecnadec toni neiale. Euna ege fimeb wawige meleigian,” ein. Odocob dana ale uqaca gami na babalecna tuitu aqalein eu aleha lelandosin. ");
INSERT INTO aey_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Odocob cam gemo ceheceb cam tu qocob hatu cunug gagatuc menen, ninijen li 3 kilok wesu. ");
INSERT INTO aey_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Odocob 3 kilok odi Jisas co suli u utai maden, “Eloi, Eloi, lama sabaktani?” en. Je uqana gug eu odi: “Ijana Anut, ijana Anut, eetanu qisactaga?” en. ");
INSERT INTO aey_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dana leih age ono talildu tawein je eu dah mimeig madein, “Feiga, dana eu uqa Ilaija utadona,” ein. ");
INSERT INTO aey_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Age oso guguli gege oso umei wain gulihinca tanumei balac oso euna gihacdumei sulecebil li cona mimei maden, “Sumudeiga. Culgeceb ege Ilaija uqa humei na babalecnadec casili toni mudigianfo, qeefo ec feqan,” en. ");
INSERT INTO aey_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Odocob Jisas gehca utai kis umei cal men. ");
INSERT INTO aey_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Odocob lotoc ben tempelna hamol gunna caqusec tawoloi eu ohisdec baladu ni mahana lecisdon. ");
INSERT INTO aey_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Odocob Rom agena han dana 100 cofadec Jisas olana tawen uqa Jisas kis umei cal men eu odi fimei maden, “Mele bahic, dana i uqa Anut Melah!” en. ");
INSERT INTO aey_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Caja leihha onoca tatawi fein. Age gemodec eu Maria Makdaladecca, Maria uqa Jems jomog Josefca analaca, Salomica. ");
INSERT INTO aey_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Age Jisas Galili hatuna cobon saenna cesuldudu toodu coboin. Caja mati age Jisas gami Jerusalem bein eu ageha ono tawein. ");
INSERT INTO aey_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Cam toni nonon Josef Arimatiadec hon. Uqa Juda agena cegulec eundec oso, uqana coboc hutan me. Uqaha uqadodoc Anutna culnu waliwali fen. Uqadec Juda agena cuha deel caligian. Odocob qila eu deel age ceteh sab jec bennu saciadoloig. Eunu uqa waug gagadic mudimei Pailat amegna limei Jisas deweg ganac ugiannu sisildon. ");
INSERT INTO aey_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Odocob Pailat uqa Jisas wele cal meiafo, qeefo ec cisdon. Odimei uqa Rom agena han dana 100 cofadec utadocob hocob uqa Jisas cal meiafo, qeefo? ec sisildon. ");
INSERT INTO aey_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Rom agena han dana 100 cofadec uqa Jisas cal meia ec Pailat madocob uqa age Josef Jisas deweg utecnu maaden. ");
INSERT INTO aey_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Odocob Josef uqa deweg jeuldecnu lotoc senenec oso fajen. Odimei uqa Jisas deweg heweceb toneceb lotocna jeulden. Odimei uqa Jisas deweg qalqal hatin aluh qeihna hunein euna muden. Uqa meen koldoc oso olocdocob eu hatin biah cufa qon. ");
INSERT INTO aey_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Makdaladecca Maria Josef anagca ale Jisas deweg ana mudein eu fesin. ");
INSERT INTO aey_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pasowa Sab Jec cuha deel hedocob Maria Makdaladecca, Maria Jems anagca, Salomica age Jisas dewegna mool dedeman meme joudoqaga bili belein. ");
INSERT INTO aey_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Cuha deelna qasil wele bahic age walag dadanen qalqal hatinna belein. ");
INSERT INTO aey_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Age jicna bebeli bileig madein, “In uqa meen hatin biah cufa qoc eu olocdugeceb gesacna ligian?” ein. ");
INSERT INTO aey_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ge, meen eu ben bahic. Odocob age amaga teceb meen wele olocdogin gesacna len fein. ");
INSERT INTO aey_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Odimeig age qalqal hatin dunuh lein. Ono dana haun oso eben meulana isec lotoc senenec tacen bibilen fein. Odimeig age filiciti cucuiein. ");
INSERT INTO aey_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Uqa maaden, “Cain filiciti cucuiuwain. Age Jisas Nasaretdec na babalecna qocobil cal men eu walegina. Uqa ene qee bilel. Uqa wele ceseli cajeia! Feiga, cudun ina uqa mudecebil nijen. ");
INSERT INTO aey_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ageqa belimeig uqana malogom Pitaca maadeiga, ‘Jisas Galili ono aquniadi nuina. Uqa odi maadenwe age ono uqa foqagan,’ adeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Odocob age qeleeli dadaneinnu age qalqal hatinnadec cali humeig busali belein. Odimeig age cucuieinnu oso je qee madoloin. Grik jaqec je hilah leihna age but i 16.9-20 eu qee nijel.  ");
INSERT INTO aey_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Cuha deelna qasil bahic Jisas ceseli cajimei uqa casac Maria Makdaladecca camas men. Jisas uqa wele buga me qee 7-pela Maria Makdalanadec ititacadeceb belein. ");
INSERT INTO aey_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria uqa dana caja age Jisasca coboin eu ageca limei age qada qaqaji bibilegin je saaden. ");
INSERT INTO aey_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria uqa ija Jisas figa uqa cebac bilia adeceb doin qa age uqana jenu wawaga qee meleel. ");
INSERT INTO aey_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Eu hedocob Jisasna malogom lecis ale jic bahu euna bebelesin uqa deweg fecnu fil odi aleca camas men. ");
INSERT INTO aey_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Odocob ale ceselimesi malogom leih maadesin qa age alena jenu wawaga qee meleel. ");
INSERT INTO aey_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Eu cunug hedocob Jisas uqana malogom 11-pela age sab jejegin uqa ageca camas men. Odimei age dana cajaca uqa ceseli cajeceb fimeig maadecebil age agena jenu wawaga qee meleelnu uqa age wawaga qee meleeceb wawaga tool ibuldonnu galac maden. ");
INSERT INTO aey_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Odimei uqa maaden, “Age mahamaha cunugna beladimeig dana cajaca cunug Anut ifanen eu me je qasali maadeiga. ");
INSERT INTO aey_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Oso me je eunu waug meleeceb wa joudec ocobfi Anut cahahadugian. Euqa oso me je eunu waug qee meleecebfi Anut uqa geuldigian. ");
INSERT INTO aey_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Dana cajaca wawaga meleigian saen euna kobolkobol odoc i edi caligian. Age ijanina buga me qee dana deweneganadec ititacadecebil beloqagan. Age beilamaga je haun filfil madoqagan. ");
INSERT INTO aey_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Age man sononec me qee u hewoqagan. Age wa me qee oso jifeig age qee cal mowain. Age ebenega hag dana cajaca dewenegana mecebil age me moqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Odocob Jisas Tibud uqana malogom gami je madi hedocobil Anut uqa Jisas ehudeceb sao ohis timei uqa Anut eben meulana isec bilen. ");
INSERT INTO aey_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Odocob uqana malogom age beladi maha cunugnana me je qasali maadein. Age me je qasali maaadegin Tibud uqa ageca cabi ooig kobolkobol odoc eu agena me je madec gabalna calen euna agena je eu mele eunu ihacaden. Mele. Grik jaqec je hilah leihna age but 16.9-20 eu qee nijel euqa je fil oso nijia eu odi:  (9) Caja eu age limeig Pitaca dana age uqaca bileinca je cunug maaden eu mahuc saadein. (10) Eu hedocob Jisas uqadodoc malogom suladeceb age maha cam tobi becna isec, cam toni nocna isec belimeig me je qasali maadein. Me je eu gun, eu Anut uqana dana cajaca cahahaadecnu je, eu qee qee meiaun, eu gaid biligian. ");
INSERT INTO aey_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","O Mei Tiofilas, je age sahecebil dom eu mele eunu jaqihigennu me bahic cisdom. Dana mati age ceteh i ege gemo calennu je jaqecnu odoin. Eu odiwe dana age Anutna jenu cabi dana ceteh i sanan mecnadec amagana fefegin hon ageha ceteh eunu je qasali maadein je eu suldugein. Eunu ijaha hahawannadec lili qila hon ceteh i cunugnu sisilimig gug domnu je tutuc himec jaqihigina. ");
INSERT INTO aey_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Odocob saen Herod uqa Judia hatu agena king bibilen nawel tawec ihanec dana oso, ijan Sekaraia, bilen. Sekaraia uqa Abaisa amnadec, eu ihanec dana agena am oso. Uqa aideg ijan eu Ilisabet. Uqa Eron ihanec dana sihulnadec. ");
INSERT INTO aey_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ale Anut amegna ititom bilesin. Ale Tibudna loo jeca, uqana jeca eu cunug toodu bibilesi cobosin. Eunu Tibud alenu jeca qee. ");
INSERT INTO aey_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Euqa Ilisabet uqa goud. Uqa Sekaraiaca ale toia bahic. Eunu ale melca qee bilesin. ");
INSERT INTO aey_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Saen osona Sekaraia uqa uqana ihanec dana am age tempelna Anut amegna cabi oogin ");
INSERT INTO aey_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","agena cabi siwec saenna Sekaraia uqa Tibudna tempel gun hamol limei ja dedemanca hudecnu cabi eunu age satu udocna gesilimeig uqa utein. Odocob uqa uqana cabi muguh mec eu umei tempel dunuh len. ");
INSERT INTO aey_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Odocob uqa ja dedemanca huhuden dana mati bahic age maha gumu inondudu tawein. ");
INSERT INTO aey_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Saen euna Tibudna ensel uqaca hon. Uqa ihanec cabal ja dedemanca nijen eu meulana isec tawen. ");
INSERT INTO aey_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Odocob Sekaraia uqa eu fimei filiciti ben bahic cucuien. ");
INSERT INTO aey_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Odocob ensel uqa madon, “Sekaraia, Anut hinana inondoc dah men. Eunu cain cucuiagaun. Hina aiden, Ilisabet, uqa mel oso basihigian. Odocob hina mel ijan Jon qogan. ");
INSERT INTO aey_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Odocob hina ceelii celeboegan. Hina aiden mel eu baseceb dana mati bahic ceeloqagan. ");
INSERT INTO aey_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ge, uqa hibna dana binanca Tibud amegna cobigian. Uqa wainca ceuca qee jeiaun. Saen uqa anag waugna bibileb uqa Kis Gun cacawac mec biligian. ");
INSERT INTO aey_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Odocob uqa Isrel dana cajaca maadeceb age tului falicdumeig Tibud, agena Anut, uqaca ceseli hoqagan. ");
INSERT INTO aey_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Odocob uqa memegail melemegailca gabanadigiannuca, feeec dana maadeceb age tului falicdumeig dana ititom agena cisdoc toodoqagannuca, Anutna dana cajaca Tibudnu qagu madeceb amaga mimi biluqagannuca uqa Ilaijana dumanca, uqana gagadic odocca umei Tibud aqunitu cobigian,” don. ");
INSERT INTO aey_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Odocob Sekaraia uqa ensel sisildon, “Ija dana toia. Ija aideniha toia. Eunu hinana je eu melefo ija adi dugen?” don. ");
INSERT INTO aey_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Odocob ensel jejeg hewi madon, “Ija Gebriel, ija Anut cemenug tawigina. Anut ija sulteceb hina je me i mahigennu huga. ");
INSERT INTO aey_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Faga, ijana je eu uqana saenna bahic fegan. Euqa hina je eunu wawin qee meleelnu hina con je madec eu qee migian. Hina con odi himec bibileb li saen ijana je hahun mahiga eu caligian,” don. ");
INSERT INTO aey_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Odocob dana cajaca age Sekaraia susumudi bileig age eetanu saen cecelac tempel gun hamol bilia? ec cisdoin. ");
INSERT INTO aey_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Odocob uqa dunuhdec calimei je madecnu co ihoc men len ihoc qee lel. Eunu age uqa tempel dunuhna codoc oso fen ec doin. Odocob uqa qee je madec ebenna dih dado maden. ");
INSERT INTO aey_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Odocob uqa tempelna cabi qee meceb uqa uqana jona ceseli nuen. ");
INSERT INTO aey_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Odocob saen leih nueceb Ilisabet uqa waugca men. Eunu jagel 5-pela jona dih bilen. Uqa maden, ");
INSERT INTO aey_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Qila saen ina Tibud cesulteia. Anut ija majani dana cajaca amagana bilen eu qu qeleia,” en. ");
INSERT INTO aey_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Odocob jagel 6-pelana Ilisabet waugca bibilen Anut uqa ensel Gebriel Galili hatu ono suldocob jobon oso, ijan Nasaret, ono nuen. ");
INSERT INTO aey_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Uqa mel aid taula oso, uqa dana oso, ijan Josef, ugiannu bilen eu uqaca je hewi nuen. Josef uqa King Dewidna sihuldec. Mel aid taula eu ijan Maria. ");
INSERT INTO aey_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Odocob ensel uqaca humei madon, “Feeleo, hina Anut amegna me bahic biligina! Tibud hinaca bilina,” don. ");
INSERT INTO aey_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Euqa Maria uqa ensel odi madocob uqa waug ben bahic culumen don. Odocob uqana je eu cel gugnu? ec cisdon. ");
INSERT INTO aey_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Odocob ensel madon, “Maria, hina Anut amegna me bilec wele oga. Eunu cain cucuiagaun. ");
INSERT INTO aey_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Faga, hina wawinca cobimeg mel oso basegan. Odimeg mel eu ijan Jisas qogan. ");
INSERT INTO aey_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Uqa hibna dana binanca biligian. Odocob age Anut Ohis Bahic Melah doqagan. Anut Tibud odudeceb uqa king caligian. Uqa asag Dewid king bilen eu odi biligian. ");
INSERT INTO aey_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Odocob uqa Jekobna sihul agena king bileceb catanigian. Uqana cul qee qee meiaun,” don. ");
INSERT INTO aey_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Odocob Maria ensel madon, “Ija dana oso qee olom. Eunu ceteh eu adi caligian?” don. ");
INSERT INTO aey_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Odocob ensel jejeg hewi madon, “Kis Gun hinaca humei u tacihigian. Odocob Anut Ohis Bahic uqana gagadic odoc jahulhigian. Eunu mel hina basigian eu age gun oqagan, age Anut Melah oqagan,” don. ");
INSERT INTO aey_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Faga, hina cotin Ilisabetnu cisdoga. Uqa toia bahic. Uqa mel basecwe qee egina qa qila uqa jagel 6-pelana mel waugna bilia. ");
INSERT INTO aey_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ge, ceteh oso Anut uqa odocnu ihoc qee oso qee nijel,” don. ");
INSERT INTO aey_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Odocob Maria madon, “Faga, ija Tibudna cabi caja. Hina ija odi mataga eu ijaca caleiale,” don. Odocob ensel uqa cuculdi nuen. ");
INSERT INTO aey_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Saen eu odina Maria uqa taun oso aluhna nijen eu Judia hatuna ono mahucwe nuen. ");
INSERT INTO aey_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Uqa nuimei Sekaraiana jona limei Ilisabet alalagdon. ");
INSERT INTO aey_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Saen Maria uqa Ilisabet alalagdodon waugna mel sim uqa bicolen. Odocob Anut uqa Ilisabet Kis Gun cacawac meceb ");
INSERT INTO aey_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","uqa jejeg gagadicca utai madon, “Hinana eeldoc eu caja cunug agena eeldoc wooladec. Mel sim basegan eu Anut uqaha eeldugian. ");
INSERT INTO aey_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ija adec ijana Tibud uqa anag ija mecitigiannu ijaca hoia? ");
INSERT INTO aey_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ge faga, saen ija dahini hinana alalagtec ec docob mel wawina bicolimei alegeeia. ");
INSERT INTO aey_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tibudna je ensel mahen eu odi caligiannu hina wawin meleen. Eunu hina ceelhec biligina,” don. ");
INSERT INTO aey_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Odocob Maria maden: “Ija wawi Tibud binan sulina. ");
INSERT INTO aey_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Anut ijana Cahahatec. Eunu ija doloni ceelena. ");
INSERT INTO aey_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ge, ija Tibudna cabi caja himec. Euqa uqa ijanu dahig bilia. Gec faga, qila hibnaca dana cajaca cunug age ijanu mati eeladec oin toqagan. ");
INSERT INTO aey_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Anut Gagadicca uqa ceteh ben bahic ijanu odeia. Uqa ijan eu gun. ");
INSERT INTO aey_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dana cajaca wele bileinca, qila bileginaca cunug age Anutnu cumunegina eu Anut uqa agenu waug qona. ");
INSERT INTO aey_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Uqa uen gagadicca huleldumei dana feeec hewadi bilisaadeceb buadein. Agena cisdoc qee men. ");
INSERT INTO aey_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Uqa king benben ilo cudunnadec hewadeceb mahana nein. Odimei dana age mahana bilein eu suli u binanagaca maden. ");
INSERT INTO aey_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Uqa dana wenca eundec ceteh me aden. Odimei dana cehewanagaca age ceteh me oso qee adimei suladeceb cetehca qee belein. ");
INSERT INTO aey_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Uqa weleca Ebrahamca, uqana sihul eundecca je hahun maaden eunu cisdon. Uqa agenu waug qocnu dahig bileceb catanigian ec maaden. Eunu uqa Isrel dana age Anutna cabi ogina cesuladen,” en. ");
INSERT INTO aey_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Odocob Maria uqa jagel cijed odi Ilisabetca bilimesi uqa uqana jobon ceseli nuen. ");
INSERT INTO aey_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Odocob Ilisabet uqana mel basecnu saen caleceb uqa mel oso basen. ");
INSERT INTO aey_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Odocob utuqanelca, uqana sihulca age Tibud uqa me bahic uqanu waug qon eu dumeig age uqaca ceelein. ");
INSERT INTO aey_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Odocob deel 8-peladoc caleceb age mel eu deweg cagu qocnu age hoin. Odimeig age ijan Sekaraia eu memeg jomog qoqaga bili odoin. ");
INSERT INTO aey_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Euqa anag maaden, “Cain! Uqa ijan Jon qoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Odocob age madoin, “Hinana sihulna eundec oso ijan edecca qee,” doin. ");
INSERT INTO aey_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Odimeig age mel memeg ebenegana dado mumudeig cel ijan qoum? ec sisildoin. ");
INSERT INTO aey_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Odocob Sekaraia uqa jamel oso jaqecnu maadeceb age utecebil uqa jaqiaden, “Uqa ijan eu Jon,” jaqen. Odocob age cunug tumatumaein. ");
INSERT INTO aey_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Odocob saen euna dih Sekaraia uqa co je madec eu fihilicdon. Odocob uqa Anut binan sulen. ");
INSERT INTO aey_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Odocob dana cajaca cunug age cemenug bilegina dumeig cucuiein. Odimeig age ceteh odi calennu je eu Judia hatuna dana cajaca cunug age doin. ");
INSERT INTO aey_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Dana cajaca cunug age je eu dumeig age je eunu cocobi cisdoin, “Mel sim eu hibna adi biligian?” doin. Ge, Tibudna gagadic odoc uqaca bilen eunu doin. ");
INSERT INTO aey_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Odocob Anut odudeceb Jon memeg Sekaraia uqa Kis Gun cacawac meceb uqa je hahun madec odi maden: ");
INSERT INTO aey_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ege cunug Anut binan suluqale, uqa Isrel egena Tibud. Uqa uqana dana cajaca cahahagecnu egeca hoia. ");
INSERT INTO aey_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Uqa uqana cabi dana Dewidna sihuldec odocob Cahahagec Dana gagadic oso calen. ");
INSERT INTO aey_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Weleca Anutna je hahun gun dana Anutna je eu conogana odi madein, ");
INSERT INTO aey_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Anut uqa egena cad eunadec cahahagigian. Dana cunug age egenu gemanaga beceb sagaggegina age ebeneganadec cahahagigian. ");
INSERT INTO aey_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Eetanu odi odigian? Ege asigeil agenu waug qugian. Odimei je cagoc Ebraham madon eu uqana gun bal cehec je uqa dahig biligian,’ ein. ");
INSERT INTO aey_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Eunu Anut magen, ‘Ija agena cad eunadec cahahaadigen. Age cucuiecca qee ijana cabi dana biluqagan. ");
INSERT INTO aey_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Eunu agena deel cunug cebac bilec age ititomca gunca ija amina coboqagan,’ gen. ");
INSERT INTO aey_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","‘Melami, hina age Anut Ohisdec uqana je hahun madec dana hoqagan. Hina Tibud uqana jic saciadocnu aqunitogan. ");
INSERT INTO aey_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Hina Anutna dana cajaca age docnu maadegan, “Anut agena silailnu uqa qee wadacadeiaun. Eunu uqa cahahaadigian,” adegan. ");
INSERT INTO aey_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Egena Anut uqa malolca. Uqa egenu waug qona. Eunu uqa fulacdoc sao ohisdec suldocob egeca hugian. ");
INSERT INTO aey_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Odimei dana age cal mec ihoc tuna bilegina age sao ohisdec fulacdoc fulacadigian. Fulacdoc eu malol jic cobocnu ege dado migigian,’ en,” en. ");
INSERT INTO aey_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Odocob mel eu deweg dologca osoben ben men. Uqa wadauna bibilen leceb uqana saenna Isrel dana cajaca amagana camasac men. ");
INSERT INTO aey_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Saen euna Sisa Ogastas, uqa Rom hatu cofdoc dana, uqa dana age maha cunugna bilein age ijanaga jaqoqagannu loo je oso men. ");
INSERT INTO aey_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Loo je eu hahawan calen saen euna Kwirinias uqa Siria agena hatu ilo bilen. ");
INSERT INTO aey_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Eunu dana cunug age agena jobon gugna beli age ijanaga jaqein. ");
INSERT INTO aey_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Odocob Josef uqa Dewid sihulnadec. Dewidna sihul agena jobon gug eu Betlehem. Anag uqa Dewid ono basen. Eunu Josef uqa Nasaret jobon Galili hatudec culdimei Betlehem jobon ono Judia hatuna nuen. ");
INSERT INTO aey_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Uqa Mariaca osoben ijanala jaqecnu belesin. Maria uqa Josef ugiannu col codoin qa uqa waugca cobon. ");
INSERT INTO aey_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Odocob ale Betlehem jobon bibilesin mel basecnu saen calen. ");
INSERT INTO aey_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Odimei Maria mel matu basimei lotocna jeludimei ono nijec jo cudunca qeenu uqa bulmakau agena bohna mudeceb nijen. ");
INSERT INTO aey_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Odocob hatu euna sipsip cofadec dana age witic sipsip cofaadi bileig cabina bilein. ");
INSERT INTO aey_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Odi bibilegin Tibudna ensel dana age gemo caleceb age Tibudna kobolkobol iletadeceb ben bahic cucuiein. ");
INSERT INTO aey_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Euqa ensel maaden, “Cain cucuiuwain! Ge feiga, ija age me je ahuadiga eu dana cajaca mahamaha cunug dumeig celebooqagan. ");
INSERT INTO aey_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Qila deel ina Dewidna taun ono caja oso mel baseia. Uqa agena Cahahaadec. Uqa Krais Tibud. ");
INSERT INTO aey_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Age fecnu gadac oso eu odi nijigian. Age mel momo oso lotocna jelec uqa bulmakau agena bohna ninijeb foqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Odocob mahuc bahic sao ohisna ensel age Anutna han dana gagadic mati bahic ensel euca cali humeig age Anut binan susuli madein: ");
INSERT INTO aey_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Sao ohis bahic Anut uqa kobolkobolca biliale. Mahana dana age Anut uqa nalunuga mena eu malol bileigale,” ein. ");
INSERT INTO aey_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Odocob ensel age culadi sao jobon haun tecebil sipsip cofadec dana age togodudu madein, “Ge, ceteh caleia Tibud mageia eu fecnu Betlehem jobon ono beleqale,” ein. ");
INSERT INTO aey_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Odimeig age mahuc belimeig Maria Josefca gulucalimeig mel momodo eu bulmakau agena bohna ninijen fein. ");
INSERT INTO aey_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Fecidodoig ensel mel inu maaden je eu Maria Josefca saalein. ");
INSERT INTO aey_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Odocob dana cajaca cunug age sipsip cofadec dana agena je doin eunu age tumatumaiein. ");
INSERT INTO aey_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Euqa Maria uqa ceteh inu dahig bilen. Uqa ceteh i waugna mimei cisdoloi. ");
INSERT INTO aey_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Odocob ceteh eu age ensel uqa sipsip cofadec dana maaden odi gulucdoin. Eunu age Anutnu celeboeeig Anut binan susuli bileig ceseli belein. ");
INSERT INTO aey_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Odocob deel 8-pela hedocob age Jisas deweg cagu qumeig ijan Jisas qoin. Eu Maria waugca qee mec ijan eu ensel uqa madon. ");
INSERT INTO aey_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Odocob Maria Jisasca soialecnu saen caleceb Josef Mariaca ale Mosesna loo je toodumesi ale Jisas ehudi tempelna Tibud amegna mudecnu Jerusalem ono belesin. ");
INSERT INTO aey_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tibudna loo je jaqec eu odi nijia: “Mel manahal matu cunug basegina eu age Tibudnu gun egina,” en. ");
INSERT INTO aey_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tibudna loo je jaqec oso ha nijia: “Age cuhudid lecisfo, man fululec fil oso lecisfo Tibudnu ihaneiga,” en. Euha ale toodu odosin. ");
INSERT INTO aey_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aria, dana oso Jerusalem ono biloloi. Uqa ijan Simion. Uqa dana ititom. Uqa Anut binan sulec dana. Uqa Anut uqa Isrel hulunuga cehigian saen susumudi bilei bilen. Odocob Kis Gun uqaca bilen. ");
INSERT INTO aey_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Odi bibilen Kis Gun madon, “Hina qee cal mec bibili li Tibudna Krais eu fegan,” docob don. ");
INSERT INTO aey_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Odocob Kis Gun dado mudeceb tempel dunuh len. Odocob saen mel anag memegca ale loo je jaqein eu odi toodu odocnu mel eu tempelna ehudi lelesin ");
INSERT INTO aey_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion uqa mel eu umei ebenna hehewi Anut hetaga don. Uqa maden: ");
INSERT INTO aey_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","“O Ben, ija amigulna hinana cahahagec figa. Cahahagec eu dana cunug age amagana saciadom. Hinana jic coboc Juda dana qee eundec ihacadigiannu eu fulacdoc. Eu hinana dana cajaca, Isrel, age binanaga benca madigian. Hinana je matem eu aig cali hoia. Eunu ija, hinana cabi dana, cultecem wawi malolca cal migale,” en. ");
INSERT INTO aey_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Odocob mel anag memegca ale Jisasnu je eu Simion maden eunu tumatumaesin. ");
INSERT INTO aey_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Odocob Simion uqa eeladimei Maria, Jisas anag, madon, “Faga, Anut uqa Isrel dana cajaca mati bahic fadaladigiannuca, dana cajaca mati bahic cahahaadigiannuca mel eunu Anut nesili ehuden. Odocob mati agena cisdoc jahunec eu camas moqagannu mel i Anutna gadac caligian. Dana mati bahic uqanu je me qee madoqagan. Odocob hinanuha, sigin aigca oso hina culin qu wogoldugianwe waloc higian,” don. ");
INSERT INTO aey_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Odocob saen euna je hahun madec caja oso bilen. Uqa ijan Ana. Uqa Fanjuel ateg. Fanjuel uqa Asa sihulnadec. Ana uqa caja toia bahic. Weleca uqa cabi gel 7-pela danaca bilen. ");
INSERT INTO aey_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Odimei uqa cabi gel 84 odi danaca qee bilen. Uqa tempel qee culdoloi. Uqa witic cahinegca Anutnu inondudu cud biloloi. Eu odina uqa Anut cewel utoloi. ");
INSERT INTO aey_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Saen euna dih uqaha ono tempelna calen. Uqa ono calimei Anut hetaga ec je madon. Odimei uqa dana cunug age Anut cahahaadigiannu susumudi Jerusalem ono bilein mel eunu maaden. ");
INSERT INTO aey_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Odocob Josef Mariaca ale Tibudna loo je toodoc cabi hedocobil ale Jisasca alena jobon Nasaret ceseli Galili hatu ono belein. ");
INSERT INTO aey_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Odocob hibna mel eu ben mi gagadic men. Uqa Anutna doc am bec biloloi. Uqa Anut amegna me bahic biloloi. ");
INSERT INTO aey_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Odocob cabi gel cunugna Jisas anag memegca ale Juda agena ja qoc fecnu, ijan eu Pasowa, Jerusalem ono gaid belolosi. ");
INSERT INTO aey_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Saen Jisas uqana ben mec gadac cabi gel 12-pela caleceb memeg anagca alena kobol toodumesi Jisas ehudi ja qoc ben fecnu belesin. ");
INSERT INTO aey_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Odocob ja qoc ben saen hedocob ale haun jobon ceceselesin qa Jisas uqa Jerusalem ono bilen. Odimesi memeg anagca uqa ono bilen eu ale qee dolosin. ");
INSERT INTO aey_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ale Jisas uqa cotugul danahca leih gami belegina ec cisdosin. Eunu ale odi cocobi bebelesi deel eu leceb uqanu mecii bilesi cotugul danahca sisiladi belesin qa qee felesin. ");
INSERT INTO aey_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Odocob ale uqa qee gulucdolosin. Eunu ale haun Jerusalem ceseli uqa wawali cocobi belesin. ");
INSERT INTO aey_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Odocob deel cijedna uqa tempel dunuh bibilen gulucdosin. Uqa Juda agena iwaladec dana je mamadegin dah madi sisilaadi bibilen fesin. ");
INSERT INTO aey_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Cunug age uqana je wadacdoc dumeig eu docca bahic ein. Eunu filicitein. ");
INSERT INTO aey_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Memeg anagca ale odi fimesi filicitesin. Odocob anag uqa sisildon, “Melami, hina ele eetanu odi odiliga? Faga, ija memenca ele hinanu wawile culumen leceb hina megihi cobowa,” don. ");
INSERT INTO aey_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Odocob uqa jejenela hewi maalen, “Ale eetanu ija megiti cobosia? Ale ija Meina jona bilecnu nijia eu qee dolfo?” alen. ");
INSERT INTO aey_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Euqa memeg anagca ale uqana jenu wawala qee fogo dol. ");
INSERT INTO aey_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Odocob haun ale gami Nasaret jobon ceseli belein. Ono uqa gaid ale conola toodoloi. Odocob anag uqa ceteh i waugna mimei cisdoloi. ");
INSERT INTO aey_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Oodon Jisas uqa ben men. Uqana docha ben men. Uqa Anut amegnaca dana amaganaca me bahic biloloi. ");
INSERT INTO aey_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Saen euna cabi gel 15docna Taibirias Sisa uqa Rom agena cofdoc dana bilen. Saen euna ha Pontias Pailat uqa gabman dana Judia hatu agena ilo bilen. Odocob Herod uqa Galili hatu agena ilo bilen. Odocob uqa waliag, Filip, uqa Ituraia Trakonaitisca hatu alena ilo bilen. Odocob Laisenias uqa Abilini hatu nag agena ilo bilen. ");
INSERT INTO aey_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Odocob Anas Kaiafasca ale ihanec dana agena ilo bilesin. Saen euna Jon, Sekaraia melah, uqa wadauna bibilen Anut uqana je uten. ");
INSERT INTO aey_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Odocob Jon uqa cajimei Jodan wana isec hatu eu cunugca uqa cobimei maaden, “Agena silailnu tului falicdumeig wa joadec oiga. Odi odocobilfi Anut uqa agena silail cagasiadigian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Eu odi weleca je hahun madec dana Aisaia uqana bukna jaqen Jon uqa odi toodu odon: “Dana jejeg oso uqa wadauna bibili utai maadena, ‘Tibudna jic saciadoiga. Uqana jic tutuc mudeiga. ");
INSERT INTO aey_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Asou cunug age wa wewel tahaloqagan. Aluh benbenca aluh nagnagca eu cunug qetecebil ni tutuc migian. Jic gongin eu cunug sosolaig muduqagan. Odocob jic toni tobi eu jocosaig muduqagan. ");
INSERT INTO aey_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Odocob dana cajaca cunug age Anutna cahahaadec eu foqagan!’ adena,” en. ");
INSERT INTO aey_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Odocob dana am mati bahic age Jon wa joadigiannu uqaca hoin. Odocob uqa maaden, “Age man sononec nag me qee! In Anutna gemag bec jawe hugia odona euna age busaleiga ec maadeia? ");
INSERT INTO aey_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Agena silailnu mele bahic culimeig tului falicdumeig Anutna je qee tefacdoginanufi me odoc oso odoiga eu ihacteiga. Euqa ija mele maadigina, Anut uqa meen ene nijegina cedimei Ebraham talacul euna madecnu ihoc. Eunu age cain sanan mimi madowain, ‘Ebraham ege asige. Eunu Anutna gemag bec egeca qee hoiaun,’ owain. ");
INSERT INTO aey_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sapol na gug qetecnu wele taweia. Na cunug aig me qee qona age qetimeig jana heloqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Odocob dana cajaca am age sisildoin, “Eunu ege eeta odeqan?” doin. ");
INSERT INTO aey_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Odocob uqa jejenega hewi maaden, “In oso uqa lotoc lecisca uqa dana oso eundecca qee lotoc oso utigian. Odocob in oso sabca bilina uqa dana sabca qee eundec uqana sab cesawiadaga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Odocob takis cedec dana leih ageha wa joadecnu hoin. Odimeig age sisildoin, “Iwalgec, ege eeta odeqan?” doin. ");
INSERT INTO aey_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Odocob uqa jejenega hewi maaden, “Age um gauc cain cedowain. Age Rom agena loo je gadacna himec cedeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Odocob han dana ageha sisildoin, “Egenu eu adi? Ege eeta odeqan?” doin. Odocob uqa jejenega hewi maaden, “Age cain uhuli um aaqi meen qaig cawaladowain. Agena cabi ameg ogina eu ihoc ec cisdoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Odocob dana cajaca age saen euna Anutna Krais eu hugia agena cisdoc bibilen Jonnu geh bahic cisdoin. Odocob age Jonnu wawagana madein “Anutna Krais eu uqafa?” ein. ");
INSERT INTO aey_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Odocob Jon uqa cunug je maaden, “Ija age wana wa joadigina qa oso hib tooti hona, uqana gagadic odoc ijana gagadic odoc wooldona. Uqa dana ben meca bahic. Ijaqa uqana jaih tacec halu cufalitocnu dana me bahic ihoc qee. Uqa age Kis Gunnaca janaca wa joadigian. ");
INSERT INTO aey_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Uqa sawolca hona. Sawol euna wit aig cunug eeldocnuca, wit aig uqana jo bisna mecnuca hona. Euqa uqa witna tetec ja qee cafulina euna manigian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Odocob jic mati bahicna Jon uqa dana cajaca me jena wawaga huhuni maaden. ");
INSERT INTO aey_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Euqa saen euna Herod gabman ilo uqa waliag aideg, Herodias, on. Odocob Jon uqa Herod galac mudi madon, “Hina walin aideg om. Hina cahuldom,” don. Uqa ceteteh me qee mati bahic odon eunu Jon uqaha galac mudi madon. ");
INSERT INTO aey_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Odocob eu toodocob uqa me qee odoc ben oso haun odon. Uqa Jon gihacdoc jona tacen. ");
INSERT INTO aey_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Odocob Jon uqa dana cajaca cunug wa joadi hedumei uqa Jisasha wa jouden. Saen euna Jisas Anut inondodon sao ohis jic cebec huden. ");
INSERT INTO aey_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Odocob Kis Gun cuhudid fecwe nimei Jisasca bilen. Odocob jejeg oso sao ohisdec camas mi madon, “Hina ija melami nalunin migina. Ija hinanu wawi ben ceelena,” don. ");
INSERT INTO aey_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Odocob Jisas uqana cabi sanan men saen euna uqana cabi gel gadac eu 30 odi. Dana age odi cisdoin uqa eu Josef melah. Josef uqa Hilai melah. ");
INSERT INTO aey_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilai uqa Matat melah. Matat uqa Liwai melah. Liwai uqa Melkai melah. Melkai uqa Janai melah. Janai uqa Josef melah. ");
INSERT INTO aey_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josef uqa Matataias melah. Matataias uqa Emos melah. Emos uqa Neam melah. Neam uqa Eslai melah. Eslai uqa Nagai melah. ");
INSERT INTO aey_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai uqa Meat melah. Meat uqa Matataias melah. Matataias uqa Semen melah. Semen uqa Josek melah. Josek uqa Joda melah. ");
INSERT INTO aey_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda uqa Joanan melah. Joanan uqa Resa melah. Resa uqa Serababel melah. Serababel uqa Sialtiel melah. Sialtiel uqa Nerai melah. ");
INSERT INTO aey_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai uqa Melkai melah. Melkai uqa Edai melah. Edai uqa Kosam melah. Kosam uqa Elmadam melah. Elmadam uqa Er melah. ");
INSERT INTO aey_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er uqa Josua melah. Josua uqa Eliesa melah. Eliesa uqa Jorim melah. Jorim uqa Matat melah. Matat uqa Liwai melah. ");
INSERT INTO aey_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai uqa Simion melah. Simion uqa Juda melah. Juda uqa Josef melah. Josef uqa Jonam melah. Jonam uqa Elaiakim melah. ");
INSERT INTO aey_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiakim uqa Melia melah. Melia uqa Mena melah. Mena uqa Matata melah. Matata uqa Netan melah. Netan uqa Dewid melah. ");
INSERT INTO aey_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dewid uqa Jesi melah. Jesi uqa Obed melah. Obed uqa Boas melah. Boas uqa Salmon melah. Salmon uqa Nason melah. ");
INSERT INTO aey_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason uqa Aminadab melah. Aminadab uqa Atmin melah. Atmin uqa Anai melah. Anai uqa Hesron melah. Hesron uqa Peres melah. Peres uqa Juda melah. ");
INSERT INTO aey_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda uqa Jekob melah. Jekob uqa Aisak melah. Aisak uqa Ebraham melah. Ebraham uqa Tira melah. Tira uqa Neho melah. ");
INSERT INTO aey_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neho uqa Serak melah. Serak uqa Reu melah. Reu uqa Peleg melah. Peleg uqa Ebe melah. Ebe uqa Sela melah. ");
INSERT INTO aey_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela uqa Kenan melah. Kenan uqa Apaksat melah. Apaksat uqa Siem melah. Siem uqa Noa melah. Noa uqa Lamek melah. ");
INSERT INTO aey_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek uqa Metusala melah. Metusala uqa Inok melah. Inok uqa Jaret melah. Jaret uqa Mahalalel melah. Mahalalel uqa Kenan melah. ");
INSERT INTO aey_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan uqa Inos melah. Inos uqa Set melah. Set uqa Adam melah. Adam uqa Anut melah. ");
INSERT INTO aey_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Odocob Jisas Kis Gun cacawac men uqa Jodan Wadec ceseli hon. Odocob Kis Gun iwaldocob wadauna nuen. ");
INSERT INTO aey_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ono deel 40 odi bibilen leceb Seten temdon. Saen eu cunug uqa ceteh oso qee jel. Eunu deel 40 hedocob uqa wen don. ");
INSERT INTO aey_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Odocob Seten uqa Jisas madon, “Hina Anut Melahfi meen i madocom sab ibuldocob jaga,” don. ");
INSERT INTO aey_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Odocob Jisas jejeg hewi madon, “Anutna jaqec je eu odi madena: ‘Sab jec himec dana cebac bilec qee adena,’ ena,” don. ");
INSERT INTO aey_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Odocob Seten uqa Jisas ehudeceb aluhna timesi uqa Jisas mahamaha cul cunug mahuc bahic ihacdon. ");
INSERT INTO aey_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Odimei Seten madon, “Maha cul eu ija mugumi. Hina amina gob cehimeg ijanu cuha fecemfi ijana gagadic odoc cunugca agena tumutum cahulecca ihigen. Dana oso gawifig ija uqa utigen. Age cehewanaga eu cunug hina ihecnu ihoc,” don. ");
INSERT INTO aey_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Odocob Jisas jejeg hewi madon, “Anutna jaqec je odi madena: ‘Tibud uqa hinana Anut uqanu cuha faga, uqa himec cewel utugale!’ ena,” don. ");
INSERT INTO aey_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Odocob Seten uqa Jisas ehudeceb Jerusalem ono belesin. Odimesi tempel qabna timesi mudeceb tawimesi madon, “Anutna jaqec je eu odi madena: ‘Anut uqana ensel maadeceb hina jaim meenna qee tudoiaunnu age hina ebenegana hewihi ehi ni mihuqagan,’ ena. Eunu hina Anut Melahfi ene bitacimeg tonoga,” don. ");
INSERT INTO aey_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Odocob Jisas jejeg hewi madon, “Anutna jaqec je odi madena: ‘Tibud, hinana Anut, eu cain temdu fagaun,’ ena,” don. ");
INSERT INTO aey_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Odocob Seten uqa Jisas jic filfilna temdu hedumei cuculdi haun saen me osona temdugiannu nuen. ");
INSERT INTO aey_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Odocob Jisas uqa Kis Gunna gagadic odoc uqaca bibilen Galili hatu ono ceseli nuen. Odocob uqanu je eu hatu alildogina eu cunugna ihoc len. ");
INSERT INTO aey_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Odi cocobi Juda agena cuha jonana iwaladen. Oodon age cunug uqa binan sulein. ");
INSERT INTO aey_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Odocob Jisas uqa Nasaret jobon calimei uqa ben menna ono nuen. Odocob Juda agena cuha deelna agena cuha jona len. Uqa gaid loloiwe eu odi len. Odocob Anutna jaqec je oso sanijecnu tawen. ");
INSERT INTO aey_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Caji tatawen oso uqa je hahun madec dana Aisaiana buk ebenna men. Odocob buk eu qosocdumei je oso walimei sanijimei maaden: ");
INSERT INTO aey_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tibud sawen dana cajaca me je qasali maadecnu mool joiten. Eunu Tibudna Kis eu ijaca bilia. Uqa dana cajaca gihacdocna bilegina eu age gihacdocnadec besiadecnu je maadigennu sulten. Uqa dana amaga galuc mec bilegina haun mecioqagannu je maadigennu sulten. Ija aaqati tootooadec dana cajaca cahahaadigennu sulten. ");
INSERT INTO aey_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Odimig ija qila saen ina Tibud uqana dana cajaca cahahaadecnu hoia ec maadigennu sulten,” aden. ");
INSERT INTO aey_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Odocob Jisas uqa buk eu menimei cesuldoc dana eu ceseli utimei toni bilen. Oodon dana cunug cuha jona bilein age amaga cunug Jisas himec mecidoin. ");
INSERT INTO aey_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Odocob uqa maaden, “Anutna jaqec je i age dah memegin ija sanijiga eu qila mele ihoc caleia,” aden. ");
INSERT INTO aey_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Odocob age uqanu je me bahic madimeig uqana je me bahic dodoig ben bahic odi tumatumaein. Odimeig age madein, “Uqa Josef melah qeefo?” ein. ");
INSERT INTO aey_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Odocob uqa maaden, “Mele, age doc me je i matoqagan, ‘Hag me madec dana hinadodoc dewen eeldoga,’ toqagan. Odocob ageha odi ija matoqagan, ‘Ceteteh hina Kapaneam ono odom egina ene hinana jobon gugna ha odoga,’ toqagan. ");
INSERT INTO aey_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ija mele maadigina, je hahun madec dana oso uqana jobon gugna age gaid qee dah mudegina. ");
INSERT INTO aey_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dah meigale, weleca, Ilaijana saenna, cabi gel cijedca jagel 6-pela leceb wa qee hoc sabnu cahel ben hatu cunug ihoc li nijoloi. Saen euna caja wij mati bahic age Isrel hatuna biloloig eu mele. ");
INSERT INTO aey_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Euqa Anut uqa Ilaija caja wij eundec ageca oso qee suldocob lel. Euqa caja wij oso uqa Sarefat jobon Saidon taun ono biloloi uqadih suldocob nuen. ");
INSERT INTO aey_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Odocob weleca, je hahun madec dana Ilaisana saenna, dana lepraca mati bahic age Isrel hatuna biloloig qa Ilaisa uqa eundec oso qee me mudel. Euqa Neman, uqa Siria hatunadec dana, uqadih me muden,” aden. ");
INSERT INTO aey_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Odocob dana cunug cuha jona bilein age je eu dumeig gemanaga ben. ");
INSERT INTO aey_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Odimeig age cajimeig Jisas taun dunuhdec didodoig ehudi age aluh gesacna taun cehein euna isec ehi tein. Aluh igocna timeig age u helecebil agafecna toni qugian ein. ");
INSERT INTO aey_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Euqa dana cajaca age gemogemo cocobi wooladi uqana jic nuen. ");
INSERT INTO aey_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Odocob Jisas uqa jobon oso, ijan Kapaneam, ono Galili hatuna nuen. Ono uqa Juda agena cuha deelna dana iwaladoloi. ");
INSERT INTO aey_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Uqa je Anutna gagadic odocca iwalaadi maaden. Eunu age uqana iwaladec jenu tumatumaein. ");
INSERT INTO aey_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Odocob Juda agena cuha jo eu dunuh dana oso buga me qeeca bilen, buga eu gegehinca uqana jo ibuldon. Uqa jejeg benna utai Jisas madon, ");
INSERT INTO aey_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Se Jisas Nasaretdec, hina eetanu odigegan? Hina fadalgecnu hogafo? Ija hina cel dananu dugina. Hina dana gun eu Anut suldocob nen,” don. ");
INSERT INTO aey_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Euqa Jisas buga me qee eu cahacdudu madon, “Je culuga. Dana cuculdi qisacdoga!” don. Odocob buga me qee eu dana eu amagana u qeleceb mahana tonen. Odi ninijen dana eu cuculdi qisacdon. Uqa dana eu me qee oso qee odol. ");
INSERT INTO aey_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Odocob age cunug eu fimeig ben bahic tumatumaein. Odimeig age madocobmadocobi sisilein, “Eu cel je bahic madeia? Ge, uqa dana benwe Anutna gagadic odocca buga me qee maadeceb cali hu belegina!” ein. ");
INSERT INTO aey_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Odocob Jisasna cabinu je eu hatu alildu bilein cunug ihoc len. ");
INSERT INTO aey_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Odocob Jisas uqa Juda agena cuha jo culdimei Saimonna jona len. Ono len eu Saimon momoig hag deweg daincaca hulec ninijennu Jisas madoin. Age uqa cesuldocnu ninidoin. ");
INSERT INTO aey_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Odocob Jisas uqa hagca caja ninijen uqa limei cabal qeihna tawimei hag eu cahacdu madon, “Hag, qila culduga,” don. Odocob hag deweg dainca hulen eu culdeceb cajimei sab jec saciadumei cewel uaden. ");
INSERT INTO aey_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Odocob cam totonen dana cajaca cunug age cotogail hag gug filfilca cedadecebil Jisasca ahoin. Odocob uqa eben dewenegana meceb age cunug me mamadien. ");
INSERT INTO aey_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Buga me qee ha age dana cajaca leih deweneganadec cali hu bebeli Jisas fecebil dana cajaca age amegna toni mahulimeig utai madein, “Hina Anut Melah!” ein. Euqa age uqa Anutna Krais eu doinnu Jisas uqa age eu madecnu cahacaden. ");
INSERT INTO aey_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Odocob qasil cojageceb Jisas jo eu cuculdi cudun tiliec bahicna, dana oso qee bilec, euna nuen. Odocob dana cajaca age waludein. Waludodoi age gulucdumeig uqa qee culadeiaunnu cahacdoiga odoin. ");
INSERT INTO aey_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Euqa uqa maaden, “Ija Anutna culnu me je jobon ben filfil maadigen. Ge, Anut uqa cabi inu sulten,” aden. ");
INSERT INTO aey_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Odimei uqa Juda agena cuha jonana Judia hatuna me je qasali maadi cobon. ");
INSERT INTO aey_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Saen osona Jisas uqa Genesaret wa coolna tatawen dana cajaca am age Anutna je uqa maadeceb dah mecnu age uqa alildodoig bein. ");
INSERT INTO aey_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tatawei uqa wag lecis age dialecebil hosin lanna tatawesin fecialen. Euqa dool cedec dana age culalimeig cimec cucuseig bilein. ");
INSERT INTO aey_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Odocob Jisas wag osona tobi ti bilen. Wag eu Saimonna. Odimei Saimon cesusdocob uqa nag sundocob wana leceb Jisas wag euna bilimei dana am iwaladi je maaden. ");
INSERT INTO aey_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Saen uqa je saadi hedumei uqa Saimon madon, “Haun wag sundocom wa amegna leceb hina cabi cotinelca age cimec heladecebil wana nocobil dool leih cedoqagan,” don. ");
INSERT INTO aey_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Odocob Saimon jejeg hewi madon, “O Ben, ege witic cunug cabi oqan qa dool oso qee cedolom! Euqa hina madaganu ege cimec heladeqan,” don. ");
INSERT INTO aey_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Odocob age cimec heladecebil wa dunuh nocobil age dool geh bahic cedein. Odimeig cimec tataloqagan odoin ");
INSERT INTO aey_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","age cabi cotogail wag osona bilein age dunugana himec hocnu maadecebil hu cesuladecebil dool cedein. Age cotogailca wag lecisna dool geh bahic tacecebil am ben. Wag lecis adih wa dunuh gotooub. ");
INSERT INTO aey_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saen Saimon Pita ceteh eu fimei gob cehi Jisas olana bilen. Odimei Jisas madon, “O Tibud, ija silail dana! Cuculti nuuga,” don. ");
INSERT INTO aey_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ge, uqa cabi cotugulca dool odi geh bahic cedimeig age ben bahic tumatumaein. ");
INSERT INTO aey_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon cabi cotugul Jems Jonca, ale Sebedi melahul, aleha fimesi tumatumaesin. Odocob Jisas uqa Saimon madon, “Cain cucuiagaun. Qila leceb hibna hina dana odi cedadogan,” don. ");
INSERT INTO aey_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Odocob age wag diaadegin lanna tecebil age ceteteh cunug culadimeig Jisas toodoin. ");
INSERT INTO aey_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Saen osona Jisas taun osona bilen. Ono dana oso lepra dewegna ihoc lec uqa hon. Uqa Jisas fimei uqa toni mahuli ninijei Jisas cesusdu madon, “O Tibud, hina ija me mitiga hecebfi hina me mitecem ijana hag culteceb ija Anut amegna cataniec bilecnu ihoc,” don. ");
INSERT INTO aey_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Odocob Jisas eben huleldumei deweg qududodoi madon, “Ija me mihiga tena. Me maga!” don. Saen eunadih lepra hag eu uqa dewegna culden. ");
INSERT INTO aey_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Odocob Jisas cahacdu madon, “Dah maga, ceteh inu oso cain sadudu cobogaun. Euqa li nawel tawec ihanec dana eu hina dewen ihacdocom maleldugian. Odimeg Moses loo je wele maden eu toodumeg hina qila Anut amegna cataniec biliga dana cajaca cunug ihacadecnu Anut ihandogale,” don. ");
INSERT INTO aey_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Euqa Jisas kobolkobol odon eunu je eu hatuhatu cunug ihoc len. Odocob dana cajaca mati bahic gabandumeig uqana je doqagannuca, uqa agena hag me madigiannuca uqaca hoin. ");
INSERT INTO aey_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Euqa uqa cuhanuc wadauna li ono Anut inondudu biloloi. ");
INSERT INTO aey_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Deel osona Jisas uqa iwalaaden Farisi dana leihca loo je iwaladec dana leihca age jobon filfil Galili hatu ono Judia hatudec hu bilein. Leih Jerusalemdec hoin euha bilein. Odocob hag dana me madecnu Tibudna gagadic odoc Jisasca bilen. ");
INSERT INTO aey_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Odocob dana leih age dana laleg hagca gabagabna ninijen Jisasca hehewi ehudi ahoin. Age hag dana jo hamolna ehudi limeig Jisas cemenugna mudecnu temdoin ihoc qee. ");
INSERT INTO aey_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Euqa dana kitim bahicnu jic oso jo hamolna hewi lecnu qee felein. Qeenu age ehudi lanna jo ohis tobimeig jo ohis jo batawimeig hehewegin gabagabna ninijen haluna qagimeig culecebil cebitnana toni nunu dana am gemo Jisas tatawen uqa olana toni nijen. ");
INSERT INTO aey_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Saen Jisas agena wawaga meleec eu ben bahic fimei laleg dana eu madon, “Dana, hinana silail cagasihiga qee meia,” don. ");
INSERT INTO aey_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Odocob loo je iwaladec danaca, Farisica age togodudu madein, “Dana i uqa in? Uqa Anut cewudec je madena. In silail cagasiadecnu ihoc? Eu Anut uqadih ihoc,” ein. ");
INSERT INTO aey_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Odocob Jisas uqa agena cisdoc dumei maaden, “Age wawagana eetanu je i madegina? ");
INSERT INTO aey_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Cel je madec cacanigca qee ija madigen? Ija madigen, ‘Hinana silail cagasihiga qee meia,’ ecfo, qee ‘Cajimeg coboga,’ ec madigenfo? ");
INSERT INTO aey_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Euqa Dana Melah mahana silail cagasiadecnu gagadic odoc ebenna nijia eu doqagannu ihacadigen,” aden. Odimei uqa dana laleg men madon, “Ija mahigina, cajimeg hinana gabagab eu qahimeg hewi hinana jobon nuuga,” don. ");
INSERT INTO aey_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Odocob mahucwe age amagana dana eu cajimei uqana nijec gabagab qahimei Anut binan susuli jobon nuen. ");
INSERT INTO aey_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Odocob dana ono cegulein age ben bahic odi tumatumaimeig cucuiein. Odimeig Anut binan susuli madein, “Ceteh fil bahic oso qila foqa,” ein. ");
INSERT INTO aey_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Odocob ceteh i hedocob Jisas uqa cali li takis cedec dana oso, ijan Liwai, uqa takis cedec jona bibilen fen. Fimei madon, “Tootaga,” don. ");
INSERT INTO aey_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Odocob Liwai cajimei uqana ceteteh cunug cuculi Jisas toodu nuen. ");
INSERT INTO aey_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Odocob Liwai uqa sab ben uqana jona Jisasnu saciadon. Odocob dana mati bahic sab jecnu bilec bahimna cegulecebil age Jisas gami sab jein. Leih eu takis cedec dana. Leih eu dana fil. ");
INSERT INTO aey_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Odocob Farisica agena loo je iwaladecca age gonagona mimi Jisasna malogom maadein, “Eetanu age takis cedec dana silail danaca gami sab wainca jegina?” adein. ");
INSERT INTO aey_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Odocob Jisas jejenega hehewi maaden, “Hagca qee age hag me madec danaca qee legina. Qeeo. Hagca himec age hag me madec danaca legina. ");
INSERT INTO aey_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ija ititom dana cajaca utai maadecnu ‘Age agena silailnu wawaga tului falicdoigale,’ adecnu qee holom. Euqa ija silail dana cajaca utai maadecnu ‘Age agena silailnu wawaga tului falicdoigale,’ adecnu hom,” aden. ");
INSERT INTO aey_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Odocob dana leih age Jisas madoin, “Jonna malogom age gaid esuesu sabnu qagu bileginanu, odocob age inondoginanu. Farisi agena malogom ageha odi odogina. Euqa hinana malogom age sab wainca jegina,” doin. ");
INSERT INTO aey_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Odocob Jisas maaden, “Age dana caja ocobocobecna cegulein bilegina eunu age caja oc dana eu gami bibileig adi maadoqagan, ‘Age sabnu qagu bileiga,’ adoqagan? ");
INSERT INTO aey_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Euqa saen oso hibna dana leih hu caja oc dana cawaludadecebil deel euna age sabnu qagu biluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Odocob Jisas uqa galolo je oso ha maaden, “Oso uqana lotoc hilah giloccanu lotoc haun eu qee baladu cufa qona. Eu odifei uqana lotoc haun eu baladugian. Euha lotoc haun cufa qoc fan eu lotoc hilahwe qee. Eu fecnu galeca qee. ");
INSERT INTO aey_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Eu odiha oso uqa wain haun jool mecmec ganacna mudec hilahna qee o danena. Jool mecmec ganacna mudec eu galalec eunu odoubmiqa wain haun eu jool ganacna mudec hilah qatanoub, wain basecdu cusdoub, odocob jool ganacna mudecha qatani cusdoub. ");
INSERT INTO aey_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Qeeo, age wain haun jool mecmec ganacna mudec haunna dih o danegina. ");
INSERT INTO aey_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Odocob oso uqa casac wain hilah jena qa hibna wain haun qee jena. Ge, dana eu madigian, ‘Wain hilah uqa wain haun wooldoc,’ igian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Juda agena cuha deel osona Jisas uqana malogomca age wit cabi osoosona gemogemo li beli coboin. Bebeli cocobi malogom age wit aig qu u ehi limeig ebenegana nunusimeig ganac waceceb aig eu jijiein. ");
INSERT INTO aey_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Oodogin Farisi leih age maadein, “Eetanu age ceteh oso egena cuha deelna egena loo je cahacgena eu odogina?” adein. ");
INSERT INTO aey_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Odocob Jisas jejenega hewi maaden, “Age Dewid odonnu je oso qee sanijeleinfo? Saen uqaca uqana eundec age gami coboinca age wen ben adeceb ");
INSERT INTO aey_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","uqa Anutna jo dunuh limei Anutnu ihanec bred oso u jen. Eu odonqa egena loo je bred eu nawel tawec ihanec dana himec eu jecnu cois ena. Dewidha dana age uqaca coboin bred eu adeceb osoben jein,” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Odimei Jisas cit qoc je maaden, “Dana Melah uqa Tibud, uqa cuha deel uqana ilo bilina,” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Juda agena cuha deel osona Jisas Juda agena cuha jona len. Ono me jenu dana iwaladen. Odocob dana oso uqa eben meulana isec gatoc men eu bilen. ");
INSERT INTO aey_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Odocob loo je iwaladec dana leihca Farisi dana leihca ageha bilein. Age Jisas dewegnu um qu madecnu, “Uqa cahuldona,” madecnu uqa cuha deelna hag dana oso me mudeceb fecnu imeig cofdudu mecidoin. ");
INSERT INTO aey_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Euqa Jisas uqa agena cisdoc wele dumei dana eben gatoc men eu madon, “Cajimeg ene ija cemeni hogale,” don. Odocob dana gatoc men eu cajimei Jisas olana li tawen. ");
INSERT INTO aey_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Odocob Jisas maaden, “Ija sisiladigina, cuha deelna ege dana me odadecnu loo je cois ec madenafo, qee ege dana waadecnu cois ec madenafo? Cuha deelna ege dana cahahaadecnu loo je cois ec madenafo, qee ege dana fadaladecnu cois ec madenafo?” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Odimei Jisas dana cunug talilaadi meciadimei dana eben gatoc men eu madon, “Hina eben heli huleldoga,” don. Odocob dana eu toodu odocob eben me men. ");
INSERT INTO aey_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Euqa Farisi dana age gemanaga ben bahic ben. Odimeig age togodu madein, “Ege Jisasnu cel oso odeqan?” ein. ");
INSERT INTO aey_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Saen euna Jisas Anut inondugiannu aluh ohisna ten. Odimei tu osol cunug ono Anut inondudu bilen. ");
INSERT INTO aey_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Odocob cojageceb uqana malogom utaadeceb hoin. Odimei uqana malogom eundecnadec 12-pela nesili ehaden. Eu age aposel ijan qon. ");
INSERT INTO aey_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Aposel eu age ijanaga eu odi. Eu Saimon, Jisas uqa Pita ijan qon, uqa waliag Andruca. Eu Jems Jonca, Filipca, Batolomjuca, ");
INSERT INTO aey_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matjuca, Tomasca, Jems, uqa Alfias melah, uqaca, Saimon, uqa Selot egina, uqaca, ");
INSERT INTO aey_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, uqa Jems melah, uqaca, Judas Iskariotca. Judas Iskariot uqa hibna balijec dana ibuldocob Jisas uqana cad ebenegana muden. ");
INSERT INTO aey_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Odocob Jisas uqana malogom gami aluhnadec ceseli maha tutucna necebil malogom mati bahic dana cajaca mati bahicca gulucadein. Leih age Judia hatunadec, leih Jerusalemdec, leih Taia Saidonca lanna isecdecca age humeig Jisas uqana je dah mecnuca, uqa agena hag me madecnuca cegulein. ");
INSERT INTO aey_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Odocobil leih age buga me qee gegehinca hewadein eundec Jisas uqa me madein. ");
INSERT INTO aey_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Anutna gagadic odoc Jisasnadec limei dana age me mamaden fein. Eunu dana cajaca cunug qududocnu odoin. ");
INSERT INTO aey_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Odocob Jisas uqana malogom meciaadi bilei maaden: “Age sawen dana, Anutna cul eu agena. Eunu age eeladecca bilegina. ");
INSERT INTO aey_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Age qila wen adena, hibna age am boqagan. Eunu age eeladecca bilegina. Age qila qada qajegina, hibna age asaloqagan. Eunu age eeladecca bilegina. ");
INSERT INTO aey_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Age Dana Melah toodoqagannu dana age fimeig age agenu gemanaga beceb sagagadoqagan, age ititacadoqagan, odocob age cewadoqagan. Age agenu dana me qee ec madoqagan. Saen euna age eeladecca biluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ceteteh eu ageca hocobfi saen euna ceeleigale. Ge feiga, age ameg ben bahic sao jobonna oqagan. Eunu celeboi dueigale. Ge, dana eu age asagail wele je hahun madec dana kobol me qee eu odi odadoloig. ");
INSERT INTO aey_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Euqa age dana qila cehewanagaca age hulunuga cehecnu wele oiga. Eunu walocca bilegina! ");
INSERT INTO aey_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Age qila sabnu am becca hibna age wen adigian. Eunu walocca bilegina! Age qila asalegina hibna age qada qajoqagan. Eunu walocca bilegina! ");
INSERT INTO aey_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Dana eu age asagail wele age je hahun madec dana age je cahuldoloig agenu ha je me bahic odi madoloig. Eunu age agenu dana je me bahic madegina eu walocca bilegina!” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jisas je haun maaden, “Ijaqa dana dah mitegina eu maadigina. Agena cadnu nalunuga meigale. Age agenu gemanaga beceb sagagadegina eu age me odadeigale. ");
INSERT INTO aey_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Dana age geladegina age eeladeigale. Dana age je ilag maadegina age agenu Anut inondoigale. ");
INSERT INTO aey_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Oso sihom oso naha qahecebfi sihom hina naha ha ihacdogale. Dana oso hinana lotoc ben ocobfi culitocobil hinana lotoc nagha oiale. ");
INSERT INTO aey_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Oso ninihecebfi eu ceteh utugale. Oso hinana ceteteh heje ocobfi haun cain ceseli ocnu madogaun. ");
INSERT INTO aey_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Dana filfil age agenu odadecebil gale adenawe eu odi age dana filfilnu ha odadeigale,” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Silail dana age agenu nalunuga megina eundecnu nalunuga megina. Eunu ageha dana age agenu nalunuga megina eundecnu himec nalunuga mecebilfi age cel ameg me oso oqagan? ");
INSERT INTO aey_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Silail dana age agenu me odegina eundecnu himec me odogina. Eunu ageha dana age agenu me odegina eundecnu himec me odocobilfi age cel ameg me oso oqagan? ");
INSERT INTO aey_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Silail dana age dana age ceteteh ceseli iguqagan imeig ceteteh adegina. Eunu ageha dana age ceteteh ceseli iguqagan imeig eundec himec ceteteh adecebilfi age cel ameg me oso oqagan? ");
INSERT INTO aey_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Qeeo, age agena cadnu nalunuga meiga. Age agena cad me odadeiga. Ceteteh adimeig age haun ceseli ocnu cain cisdowain. Age odi odocobilfi Anut uqa ameg me ben adigian. Dana age hegaga ec qee madegina euca qisol mec dana euca Anut uqa agenu me odona. Eunu age odi odocobilfi Anut Ben Ohis uqa age uqa melahul madigian. ");
INSERT INTO aey_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Age Memega uqa dana cunugnu waug qona. Eunu ageha cunugnu wawaga qoiale,” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jisas je haun maaden, “Age dana osona kobol gesildumeig cain camasac mimi cewudec je madowain. Age odi odocobilfi Anut uqaha agena kobol gesildumeig qee camasac mimi cewudec je madeiaun. Age dana oso uqa me qee ec cain madowain. Age odi odocobilfi Anut uqaha age me qee ec qee madeiaun. Dana oso age me qee odadecebfi me qee odoc eunu dahiniga celeiale. Age odi odocobilfi Anut uqaha agena me qee odadec eunu dahig celigian. ");
INSERT INTO aey_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Age dana oso ceteteh uteigale. Age odi odocobilfi Anut uqaha age ceteteh adigian. Uqa ceteteh basecdocob ebenegana numei am bigian. Anut uqa ceteteh cunug hewecnu ihoc adigian. Ge, age ihoc mec ceteteh dana ihoc adegina ihoc mec euna ha Anut uqa ceteteh age ihoc ceseli adigian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Odocob Jisas uqa galolo je oso maaden, “Ameg galuc mec dana oso uqa ameg galuc mec dana oso dado mudecnu ihocfo? Qee, uqa ihoc qee. Uqa odocobfi ale lecis odi heelna toni aqaligian. ");
INSERT INTO aey_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Malogom oso uqana iwaldoc eu wooldocnu ihoc qee. Saen uqa uqana iwaldocob du hedumei eu uqana iwaldocca ihocihoc,” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Eetanu hina cotin amegna hilican nag eu fagana qa hinadodoc amenna fan ben nijina eu qee fagana? ");
INSERT INTO aey_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Qeefi, hina cotin adi madogana, ‘Coti, culitecem hilican nag amenna nijia eu u helihigen,’ dogana qa hina amenna fan ben nijina eu qee fagana? Hina me hihili coboc dana! Casac fan ben eu hina amenna fagdoc nijia eu cagati helagale. Odocob hilican nag cotin amegna nijia eu u helecnu ihoc fegan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jisas je haun maaden, “Ge, cehelo gug me eu aig me qee eundec qee qona, odocob na gug me qee eu aig me eundec qee qona. ");
INSERT INTO aey_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Na cunug age agena aig qogina euna doqona. Ge, age dan aig oso na dudcanadec qee ogina, odocob age halu wain aig oso halu gonagonnadec qee ogina. ");
INSERT INTO aey_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dana me oso uqana kobol me waugna nijina eunadec me odona. Dana me qee oso uqana kobol me qee waugna nijina eunadec me qee odona. Ge, kobol am bec waugna nijinawe eu odi co toodu madena,” aden. ");
INSERT INTO aey_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jisas je haun maaden, “Age eetanu ija ‘Tibud, Tibud,’ teginaqa age ijana je eu qee toodu odogina? ");
INSERT INTO aey_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Oso uqa ijaca humei ijana je dah mimei eu toodu odona, eu uqa dana i edi ihacadigen. ");
INSERT INTO aey_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Uqa dana jo oso cehen cinigwe. Dana i uqa maha dunuh bahic hunimei meen casac tatac men. Jo eu meenna gagadic cehen. Eunu saen wa cue ben nen eu jo qumei wa qee qeleceb tonel. ");
INSERT INTO aey_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Euqa oso uqa ijana je dah mimei qee toodona eu uqa dana oso uqa jo maha gauc meenca qee euna cehen cinigwe. Saen wa cue ben neceb eu jo qumei hewi wiliwilidocob jo eu cabaten. Odimei jo cabati nui me qee bahic muden,” aden. ");
INSERT INTO aey_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Saen Jisas je eu cunug dana cajaca maadi hedumei uqa haun Kapaneam jobon ono nuen. ");
INSERT INTO aey_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ono Rom agena han 100 cofadec dana oso uqana cabi dana eu uqa hag ben bahic on, cal mecnu cemenug hon. Rom agena han 100 cofadec dana uqa cabi dana eunu nalug moloi. ");
INSERT INTO aey_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Saen han 100 cofadec dana Jisas hon eu dumei uqa Juda agena matu leih suladimei maaden, “Age Jisasca nuimeig ninidudu madoiga, ‘Hina egeca limeb Rom agena han 100 cofadec dana uqana cabi dana me mudeganfo?’ doiga,” aden. Odimei suladeceb belein. ");
INSERT INTO aey_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Belimeig age Jisasca humeig je eu madumeig cesusdudu haun madoin, “O Meca, dana eu me bahic. Uqa ege Juda dana cajaca eundecnu gale dona. Odimei uqadodoc egena cuha jo oso cehigen. Eunu hina cesuldoumda,” doin. ");
INSERT INTO aey_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Odocob Jisas osoben age gami belein. Jo cemenug cacalegin han 100 cofadec dana uqana danah leih suladeceb age Jisas madoin, “O Tibud, egena danah mahena, ‘Cain cabi culumen ogaun. Hina ijana jo dunuh hocnu ija dana me bahic ihoc qee. ");
INSERT INTO aey_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Euha ija hinaca lecnu dana me bahic ihoc qee. Odi cain. Hina dih je madecemfi ijana cabi dana medugian. ");
INSERT INTO aey_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ge faga, ijaha ijadodoc han dana ilo oso bisalu biligina, age ija odi mitein. Odocob ijaha han dana leih ija bisalu bilegina. Ija oso nuuga ecemin nuina. Ija oso hoga ecemin hona. Odocob ija ijana cabi bega meh dana odi odoga ecemin uqa coni toodu odona,’ hena,” doin. ");
INSERT INTO aey_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Odocob Jisas je eu dumei dana eunu filiciten. Uqa falicdumei dana cajaca am uqa toodoin eu maaden, “Ija maadigina, ija waug meleec uqana bilina cinigwe Isrel gemona oso qee gulucdolom!” aden. ");
INSERT INTO aey_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Odocob suladec dana sos age Rom agena han 100 cofadec dana uqana jona ceseli limeig age cabi bega meh dana eu medon bibilen fein. ");
INSERT INTO aey_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Deel oso hedocob Jisas jobon oso, ijan Nen, ono nuen. Uqana malogomca dana caja mati bahicca age Jisas gami belein. ");
INSERT INTO aey_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Belimeig jobon eu cebecna cacalen dana age dana cal mec oso gahidoin hohogin gulucadein. Dana cal men eu caja wij uqana mel osol dih. Dana cajaca mati bahic jobon eunadec ha osoben caja euca toodu hoin. ");
INSERT INTO aey_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Saen Tibud uqa caja wij fimei uqa waug qocob madon, “Cain qajagaun,” don. ");
INSERT INTO aey_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Odimei Jisas li dana cal mec uqana gabagab qududon. Oodon dana gabagab gahidoin eu tilii tawein. Odocob Jisas dana cal mec eu madon, “Dana, ija mahigina, haun cajaga!” don. ");
INSERT INTO aey_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Odocob dana cal mec eu caji bilimei je maden. Odocob Jisas dana cebac men eu umei anag uten. ");
INSERT INTO aey_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dana cajaca ono cunug age odi fimeig cucuiein. Odimeig age Anut binan susuli madein, “Je hahun madec dana ben ege gemo caleia,” mamadi madein, “Anut ege uqana dana cajaca cesulgigiannu hoia,” ein. ");
INSERT INTO aey_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Odocob Jisasna odocnu je eu Judia hatu cunugca, hatu alildoc cunugca leceb dana cunug doin. ");
INSERT INTO aey_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Odocob Wa Joadec Jon uqana malogom ceteh i cunugnu madoin. Odocob malogom lecis utaaleceb cemenug lecebil ");
INSERT INTO aey_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tibudca sulalimei maalen, “Ale Jisasca limesi sisildosia, ‘Hina i himec hocnu Anut sulhenfo, qee ege osonu amige meqanfo?’ dosia,” alen. Odimei sulaleceb lesin. ");
INSERT INTO aey_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Limesi ale Jisas madosin, “Wa Joadec Jon sulleceb hina sisilhecnu howa, ‘Hina i himec hocnu Anut sulhenfo, qee ege osonu amige meqanfo?’ hecnu howa,” dosin. ");
INSERT INTO aey_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Oodosin saen euna bahic Jisas uqa dana cajaca mati dewenega me qeeca, dana cajaca mati hagca, dana cajaca mati buga me qeeca me maden. Dana cajaca mati amaga galuc mec uqa haun fecioqagannu maden. ");
INSERT INTO aey_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Odimei uqa Jon uqana sos jejenela hewi maalen, “Ceseli belimesi ceteh fesiaca, je dah mesiaca Jon madosia. Dana amaga galuc mec haun feciegina. Dana laleg mec haun cobogina. Dana lepraca dewenega cataniecca calena. Dana dahiniga cit qoc haun je dah megina. Oso dana cal mec tuliadeceb haun cebac megina. Oso uqa sawen dana me je qasali maadeceb age dah megina. ");
INSERT INTO aey_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","In oso uqa ijanu waug meleec qee felacudel eu Anut uqa eeldugian,” alen. ");
INSERT INTO aey_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Odocob Jon uqana sos ale ceseli belecebil Jisas uqa dana cajaca cegulec ben eu Jonnu maaden, “Age Jon wadauna uqaca belein saen euna eeta foqagannu belein? Age balac fufu heweceb gulaeeb foqagannu beleinfo? ");
INSERT INTO aey_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Qeefi, age eeta foqagannu belein? Dana lotoc me bahicca taqen foqagannu beleinfo? Feiga, dana age lotoc tumutum tacegina age bilec me bahic bilegina, age kingna jona bilegina. ");
INSERT INTO aey_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mateiga, age eeta foqagannu belein? Age Anutna je hahun madec dana oso foqagannu beleinfo? Ija mele maadigina, uqa je hahun madec dana qa uqa je hahun madec dana cunug wooladena. ");
INSERT INTO aey_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jon uqanu Anutna jaqec je oso odi madena: ‘Anut madena, “Feiga, ijana sos suldocomin aqunihi nuigian. Uqa hinana jic saciadugian,” ena,’ Anutna jaqec je odi madena. ");
INSERT INTO aey_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ija maadigina, Wa Joadec Jon uqa dana mahana cunug wooladena. Euqa dana oso uqa nag bahic Anutna culna bilina eu uqa Jon wooldona,” aden. ");
INSERT INTO aey_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Oodon dana cunugca, takis cedec dana ageca, Jon uqa wele wa joaden eu age Jisasna je dumeig age madein, “Ao, Anutna kobol eu ititom,” ein. ");
INSERT INTO aey_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Euqa Farisica loo je iwaladec dana ageca age Jon wa joadecnu culein. Eunu age jic me coboqagannu Anut ihacaden eu hibemdoin. ");
INSERT INTO aey_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Odocob Jisas haun maaden, “Dana qila bilegina eu age adec? Age eetanu ihocihoc madigen? ");
INSERT INTO aey_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Age i ediwe. Age mel simsim idadec cudunna ududu bibileig cotogail utai madecebmadecebegina: ‘Ege agenu cololo fuldoqonaqa age qee due dueelein. Ege cal mec due siluqunaqa age qada qee qajelein,’ adegina. ");
INSERT INTO aey_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ge, Wa Joadec Jon uqa sabca wainca qee jejen hol qa age madein, ‘Uqa buga me qee hewen bilia!’ ein. ");
INSERT INTO aey_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Odocob Dana Melah uqa sabca wainca jejen hon qa age madein, ‘Dana i feiga! Uqa sab muhna jec dana. Uqa wain jeceb dalul qoc dana. Uqa takis cedec danaca, silail danaca agena danah bilina,’ ein. ");
INSERT INTO aey_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Euqa dana age Anutna doc silecca toodu odogina eu age tutuc odogina eunu dana cajaca cunug age fimeig madein, ‘Anutna doc silecca eu ititom,’ ein,” aden. ");
INSERT INTO aey_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Odocob Farisi dana oso uqa wesu hocob Jisasca sab jowasannu cesusdon. Jisas uqana jona limei sab jigiannu bilen. ");
INSERT INTO aey_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ono caja oso taun euna bilen. Uqa silail caja. Odocob uqa Jisas Farisi dana eu uqana jona sab jena ec don. Eunu uqa gum mool dedeman me bahicca cali bec ehi len. ");
INSERT INTO aey_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Odimei Jisas sab jiji ninijen uqa Jisas hibiloh tawimei uqa qaqajen amulig Jisas jaihna toocooi qon. Odimei Jisas jaih uqa gosicna cacumei jaih cotdudumei mool dedeman me bahic basecdocob non. ");
INSERT INTO aey_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Odocob Farisi uqa Jisas madocob len eu fimei uqa waugna maden, “Caja eu silail caja. Eunu dana i mele bahic je hahun madec danami cel caja qududona eu doub!” en. ");
INSERT INTO aey_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Odocob Jisas je madimei madon, “Saimon, ija je oso mahigen,” don. Uqa madon, “Cois Iwaltec, mataga dugen,” don. ");
INSERT INTO aey_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Odocob Jisas sanan mi madon, “Dana lecis ale cubca bilesin. Wele ale cub dana osona meen qaig cedesin. Dana oso uqa 500 kina ceden. Oso uqa 50 kina ceden. ");
INSERT INTO aey_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Odocob ale lecisca alena cub odi wadacdocwe qee. Eunu cub dana eu uqa alena meen qaig wadacdocnu culen. In uqanu nalug bahic migian?” don. ");
INSERT INTO aey_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Odocob Saimon jejeg hewi madon, “Ija cisdugina, cub dana uqa meen qaig ben bahic wadacdocwe qee uqa culen uqa uqanu nalug bahic migian,” don. Odocob Jisas madon, “Hinana cisdoc eu tutuc,” don. ");
INSERT INTO aey_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Odimei caja euca waldumei Saimon madon, “Hina caja i fagafo? Ija hinana jona hocomin hina ija jaimi wasacitecnu wa oso qee itelem qa uqa amuligna ija jaimi wasacitia. Odimei gosicna cacoia. ");
INSERT INTO aey_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Hina ija cotteteg qee ehitelem qa uqa ija huganadec jaimi cotdodoi qee culel. ");
INSERT INTO aey_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Hina ija ilomi moolna qee joidelem qa uqa mool dedeman me bahicna ija jaimi joidia. ");
INSERT INTO aey_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Eunu ija mahigina, caja i uqa Anutnu nalug bahic menanu uqana silail eu mati bahic qa Anut uqana silail cagasitoia. Euqa oso uqana silail nag Anut cagasiton eu uqa Anutnu nalug mec eu nag,” don. ");
INSERT INTO aey_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Odimei Jisas caja eu madon, “Hinana silail ija cagasihigina,” don. ");
INSERT INTO aey_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Odocob dana age sab jec cabalna bilein eu age madocobmadocobein, “I cel dana uqa silail cagasiadena?” ein. ");
INSERT INTO aey_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Euqa Jisas caja eu madon, “Hina wawin meleec eu me cahahaheia. Hina wawin malolca nuugale,” don. ");
INSERT INTO aey_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Saen osooso hedocob Jisas taun nagca, jobon nagca Anutna culnu me je maadi cobon. Malogom 12-pela age gami belein. ");
INSERT INTO aey_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Oodogin caja leih buga me qeeca, hagca eundec me maden euha tooadecebil belein. Caja eu age Maria, Magdaladec, uqanadec buga me qee 7-pela dewegnadec ititacaden, uqaca, ");
INSERT INTO aey_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, uqa Susa aideg, uqa Herodna jona dana cofdoc, uqaca, Susanaca, caja mati agedodoc agena ceteteh euna Jisas uqana malogomca cesuladein, ageha Jisas gami belein. ");
INSERT INTO aey_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Odocob dana cajaca jobon cunugnadec odi huhuein. Jobon alildoc toodocobtoodocob hoin. Odocob saen dana cajaca geh bahic cegulecebil Jisas galolo je maaden. ");
INSERT INTO aey_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Uqa maaden, “Dana oso uqana cabina uqana wit aig helecnu nuen. Uqa aig hehelen aig osooso jic cobocna tonen. Odocob dana age aig eu lahacdocobil man fululec age humeig cedi ji hedoin. ");
INSERT INTO aey_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aig osooso maha meen baibaca euna tonen. Odocob maha ganac euna waca qeenu qala bimei galalen. ");
INSERT INTO aey_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aig osooso dud geuna tonen. Aig ceteh dudca gami ben memegin ceteh dudca cilehdocobil aig qee men. ");
INSERT INTO aey_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aig osooso mulu mahana tonen. Odocob leih qala qahimei ben mi aig qon. Gug osolna aig oso qoc 100 ihoc len,” aden. Odi maadimei Jisas utai maaden, “Oso dah mecnu dahigca je eu dah meiale,” aden. ");
INSERT INTO aey_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Odocob Jisasna malogom uqa galolo je maaden eu gugnu sisildoin. ");
INSERT INTO aey_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Odocobil uqa maaden, “Anut culadeceb age Anutna culnu ceteteh jahunec docnu eu nijia. Euqa dana cajaca leih age amagana foqaganqa qee fowain, odocob age dahinigana dah moqaganqa qee fogo adeiaun. Eunu age galolo jena je cunug dah megina,” aden. ");
INSERT INTO aey_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jisas je haun maaden, “Galolo je i uqana gug eu odi. Aig eu Anutna me je. ");
INSERT INTO aey_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aig eu jicna tonena eu odiwe dana age Anutna je dah mecebil Seten humei age wawaga meleeceb Anut cahahaadecdainnu uqa je dana waugna tonen eu cedadi len. ");
INSERT INTO aey_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aig eu maha meen baibacana tonen eu odiwe dana age Anutna je dah mimeig wawaga ceelecca je eu ogina. Euqa age aig bebeig qee mel. Age saen nag odi himec wawaga meleeceb temadec saen hocob toni aqena. ");
INSERT INTO aey_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aig dud geuna tonennu madiga eu odiwe dana age je dah megina, euqa age mahana bibileig mahana bilecnu jaen aqecca, maha cehewan ocnuca, amaga qocnu cetehca eu wawagana humei Anutna je cilehdocob agena aig qee wal megina. ");
INSERT INTO aey_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aig mulu mahana tonennu madiga eu odiwe dana age Anutna je dah mimeig u hewi daugdu wawaga tutuc mecana mimeig gagadic tatawi aig qogina,” aden. ");
INSERT INTO aey_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jisas je haun maaden, “Oso gowoc madacdumei hal dunuh qee tacena, odocob cabal bisalu qee mena. Euqa uqa gowoc ohisna caqusena. Eunu dana cunug age hamol hogina eu age gowoc camas foqagan. ");
INSERT INTO aey_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ge, cel ceteh oso jahunecna nijia eu hibna camasna ahu moqagan. Odocob cel ceteh dana age jahuldoin nijia eu hibna dana cunug fimeig doqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ge, oso uqa docca nijia eu Anut uqa haun utigian. Euqa oso uqa docca qee eu uqa ija docca cisdona eudihha Anut uqa cawaldugian. Eunu age adi dah megina eunu batut cisdoigale,” aden. ");
INSERT INTO aey_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Odocob Jisas anag waliagulca age Jisas fecnu hoin qa dana cajaca geh bahic talildoin. Eunu age uqaca lecnu ihoc qee. ");
INSERT INTO aey_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Odocob dana oso Jisas madon, “Hina anin walinelca hoiga. Age mecihuqagannu maha gumu taweiga,” don. ");
INSERT INTO aey_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Odocob Jisas dana cunug maadi maden, “Eu age Anutna je dah mimeig toodu odogina eundec eu ija au walielca,” aden. ");
INSERT INTO aey_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Odocob deel osona Jisas uqana malogomca wag tobimeig bibili bileig maaden, “Gec, hoiga. Wa gad cagoc leti naha isec loqale,” aden. Eunu age wagna naha isecnu leti belein. ");
INSERT INTO aey_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Age wa gad cagoc gemo lelegin Jisas us nijen. Odocob gugula ben wa gad cagocna neceb fufu gagadic bahic fulududu macas qahi wag dunuh nuaden. Wag eu wa cali bigia odon. Eu ehi li fadalec jicna maden. ");
INSERT INTO aey_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Odocob malogom Jisasca limeig tulidudu madoin, “Ben, Ben! Ege fadalecnu odoqona!” doin. Odocob Jisas cajimei fufu gagadic wa hilidoc gagadic qaqahen cahacaadi je maadeceb qee mimeig tiliec bahic nijen. ");
INSERT INTO aey_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Odimei malogom maaden, “Agena wawaga meleec eu ai?” aden. Euqa age dumanaga culeceb cucuiein. Odocob age tumatumai madocobmadocobeeig madein, “I cel dana? Uqa fufuca wa qahecca euha maaleceb uqa co toodu odosina!” ein. ");
INSERT INTO aey_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Odocob age wagna nui Gerasa agena hatuna calein. Eu Galili wa gad cagoc naha isec. ");
INSERT INTO aey_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Odocob Jisas wagnadec mahana toneceb dana oso taun bennadec buga me qee age hewudein uqa Jisas gulucdon. Uqa bical saen cecelac bahic coboloi. Odocob uqa jobon qee biloloi qa uqa qalqal hatinna niji u coboloi. ");
INSERT INTO aey_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Saen geh bahic buga me qee eu uqa gagadic hewoloi. Euqa Gegesa dana age uqa cofdu cuhadocnu eben jaihca senna qagecebil nijoloi qa uqa sen cagocob buga me qee eu cisdoc ihulahaldutumei odudeceb wadauna nuoloi. Eunu Jisas uqa buga me qee uqa dana dewegnadec nuuga ec madon. Odocob saen uqa Jisas fimei gagadic euimei uqa olana toni mahuli nijimei jejeg u suli u madon, “Jisas, Anut Ohis Bahic Melah! Hina ija cel oditegan? Ija ninihigina, ija deweni cain dain tec itigaun!” don. ");
INSERT INTO aey_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Odocob Jisas sisildon, “Hina ijain in?” don. Odocob buga me qee mati bahic uqa dewegna lein eunu uqa jejeg hewi madon, “Ija ijani ‘Mati,’” don. ");
INSERT INTO aey_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Odocob buga me qee Jisas ititacadeceb maha heel ben eu dunuh bahic non gugca qee euna cain belowainnu ninidoin. ");
INSERT INTO aey_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aria, aluh qeihna onoca qee ho am ben oso sab jiji coboin. Odocob buga me qee culadeceb ho dewenegana loqagannu Jisas ninidoin. Odocob Jisas cois aden. ");
INSERT INTO aey_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Odocob dana eu cuculdeig ho dewenegana lein. Odocobil ho cunugca aluh qeihqeih guguli nu Galili wa gad cagoc dunuh gotoimeig cunugca odi wa jimeig cal mein. ");
INSERT INTO aey_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Odocobil dana ho cofadoloig eu age eu caleceb fimeig busali limeig taunca, jobonca, cabinaca dana cajaca maaadi coboin. ");
INSERT INTO aey_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Odocobil dana cajaca cunug je eu dah mimeig age eu feqan imeig belein. Age Jisasca humeig dana dewegnadec buga me qee ititacdon eu Jisas jaihna bibilen fein. Uqa lotoc tacecca, dana cisdoc meca bibilen fimeig cucuiein. ");
INSERT INTO aey_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dana age amagana fein eundec dana uqa buga me qee hewudein eu Jisas adi dewegnadec buga me qee ititacadeceb dana qila me men bilen eunu dana cajaca hoin saadein. ");
INSERT INTO aey_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Odocob dana cajaca Gegesa agena mahanadec cunug age cucui bahic ein eunu Jisas cuculadi nuigiannu ninidoin. Eunu Jisas wag tobocob cuculadi ceseli belein. ");
INSERT INTO aey_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dana buga me qeeca Jisas ititacduton eu Jisas ninidudu madon, “Cultecem hinaca belowa!” don. Euqa Jisas madudu madon, ");
INSERT INTO aey_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Hina hinana gunna nuimeg Anut me mihianu saadaga,” dodoi suldocob nuen. Dana eu taun ben cunug ono Jisas me mudennu cunug maaadi nuen. ");
INSERT INTO aey_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Saen Jisas wa gad cagoc naha isecnu leceb dana am age uqa sumudi bilein. Eunu wawaga ceelecca ehudein. ");
INSERT INTO aey_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Oodogin Juda agena cuha jo ilo oso, ijan Jairas, humei uqa ateg osol bahic uqana cabi gel 12-pela eu uqa cal migia odonnu uqa Jisas jaihna toni mahulimei uqana jona belowasannu ninidon. Jisas uqaca cocobi lelesin dana cajaca geh bahic age Jisas alildudu gesacgesac belein. ");
INSERT INTO aey_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jisas cocobi lelen caja oso ono cabi gel 12-pela golac nenen odi hewi coboloi euqa dana oso qee me mudel ");
INSERT INTO aey_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","eu uqa dana cajaca cegulec gemo limei Jisas hibilohu isec ben. Odimei Jisasna lotoc bibig qududon. Odocob uqa golac noloi eu gatidon. ");
INSERT INTO aey_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Odocob Jisas sisilaadi maaden, “Info qudutia?” en. Cunug ija qee ija qee ein. Odocob Pita madon, “O Ben, dana cajaca kitim bahic hina talilheiga taweiga hina cemeincemein legina,” don. ");
INSERT INTO aey_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Euqa Jisas maden, “Ija gagadic odoc oso deweg cuculdi nueceb tebanduga eunu oso ija qudutia,” en. ");
INSERT INTO aey_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Caja eu uqa ceteh odon camasac meia eu dumei uqa deweg qeleli Jisasca timei jaihna toni mahulimei nijen. Odimei dana cajaca cunug amagana uqa eetanu Jisas qududoia, odocob uqa mahuc bahic hag medoia eu saaden. ");
INSERT INTO aey_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Odocob Jisas madon, “Ateni, hina wawin meleec eu me mihia. Wawin malolca nuugale,” don. ");
INSERT INTO aey_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas uqa caja je i madodon dana oso Juda agena cuha jo ilona jonadec humei Jairas madon, “Hina aten cal meia. Iwalgec mulug cabi haun cain utugaun,” don. ");
INSERT INTO aey_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Euqa Jisas dah mimei Jairas madon, “Cain cucuiagaun. Hina dih wawin meleeiale. Odocob aten haun me migian,” don. ");
INSERT INTO aey_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Odocob Jisas uqa Jairasna jona limei osoca qee culdeceb uqa Pita Jon Jemsca himec, odocob mel aid eu memeg anagca gami hamol lein. ");
INSERT INTO aey_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dana cajaca cunug ono cegulein eu age mel aid eunu qada qaqajeig sogoi bilein. Jisas maaden, “Mel aid i qee cal mel. Uqa us nijia! Cain qajowain,” aden. ");
INSERT INTO aey_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Odocob age mel aid cal meia eu doinnu age asaldoin. ");
INSERT INTO aey_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Euqa Jisas eben u hewimei utai madudu madon, “Mel aid, cajaga!” don. ");
INSERT INTO aey_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Uqana cebac bilec kis ceseleceb mahuc bahic cajen. Odocob Jisas sab oso utecebil jigiannu maaden. ");
INSERT INTO aey_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mel aid eu memeg anagca tumatumaesin euqa Jisas ceteh odi calen eunu oso cain madowasinnu cahacalen. ");
INSERT INTO aey_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Odimei Jisas uqana malogom 12-pela utaadeceb uqaca hocobil uqa buga me qee dana deweneganadec ititacadecnuca, dana hag filfil aqecca me madecnuca gagadic odoc adimei cabi eu ebenegana men. ");
INSERT INTO aey_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Odimei uqa age dana cajaca cunug Anutna culnu je qasali maadoqagannuca, hag me mudiadoqagannuca suladeceb belein. ");
INSERT INTO aey_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Uqa maaden, “Jic cobocnu ceteh oso cain hewowain. Jic coboc komca qee, badomca qee, sabca qee, meen qaigca qee eu odi jic coboiga. Lotoc lecisca cain hewi belowain. Osol himec taceiga. ");
INSERT INTO aey_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Age jo casac dunuh loqagan jo osol euna himec bibileig li jobon eu culimeig beleiga. ");
INSERT INTO aey_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Odocob jobon oso age oiadecnu culecebilfi age cuculadi beloqaga bili comis jaimagana fagdon eu qoidu heleiga. Age eu fimeig age Anut amegna me qee odoin eu doqagannu odi odoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Odocob malogom 12-pela bebeleig jobonjobon Anutna me je mamadeig hag eundec me mamadi jobon cunugna coboin. ");
INSERT INTO aey_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Odocob Herod Galili hatu cunug cofdoc ceteh calen eu cunug uqa dah men. Leih mamadiein, “Wa Joadec Jon uqa cal mecnadec haun ceseli cajen!” ein. Eunu uqa eu dadanec ben bahic dadanen. ");
INSERT INTO aey_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Leih age madein, “Ilaija camasac men,” ein. Oodogin leih madein, “Je hahun madec dana oso weleca bilen uqa haun ceseli cajen,” ein. ");
INSERT INTO aey_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod maden, “Ija Jon be cagom qa i cel dana ija uqanu je i dah migina?” en. Odocob uqa Jisas figiannu temduduoloi. ");
INSERT INTO aey_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Odocob aposel ceseli Jisasca humeig ceteteh cunug odoinnu sadoin. Odocob uqa ehadeceb uqa gami age cuhanuc jobon nag ijan Betsaida ono belein. ");
INSERT INTO aey_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Dana cajaca geh bahic age Jisas uqa Betsaida jobon bilen eu dah memeig toodoin. Uqa meme mamadi Anutna culnu je maaden. Odimei hagca eundec me maden. ");
INSERT INTO aey_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Odocob cam wele nonon malogom 12-pela age Jisasca humeig madoin, “Ege aben filec cagocna bahic biluquna. Eunu dana cajaca am i age hatu alildoc belimeig age jobonnana sab cehec cudunnanaca limeig sabca us nijec cudun wali foqagannu suladaga,” doin. ");
INSERT INTO aey_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Euqa Jisas maaden, “Age sab jec adeiga,” aden. Odocob age jejeg hewi madoin, “Ege bred 5-pelaca, cul dool lecisca himec hewoqa. Sab oso haunca qee. Qeefi, ege dana cajaca am ben i agena sab li fajecnu magaganafo?” doin. ");
INSERT INTO aey_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ge, dana eu age 5,000 odi bilein. Odocob Jisas uqana malogom maaden, “Dana cajaca i age sanijec am 50 50 odi madecebil bileiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Odocob malogom eu odi odimeig cunug maadecebil bilein. ");
INSERT INTO aey_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Odocob Jisas bred 5-pela cul dool lecisca cedi hewimei sao jobon tatiimei Anut hetaga doc je madon. Odimei sab eu fenifeni uqana malogom adeceb dana cajaca siwiadecebil jein. ");
INSERT INTO aey_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Age cunug jecebil ihoc leceb malogom age sab jecefanaga eundec galel 12-pela tacecebil am ben. ");
INSERT INTO aey_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Saen osona Jisas uqa himec Anut inondudu bibilen malogom age gami bilein. Odocob uqa sisiladen, “Dana cajaca eu age ijanu in egina?” aden. ");
INSERT INTO aey_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Odocob age jejeg hewi madoin, “Leih age Wa Joadec Jon eu hina ec madegina. Leih age Ilaija eu hina ec madegina. Oodogin leih age je hahun madec dana oso weleca bilen uqa haun cebac meia eu hina ec madegina,” doin. ");
INSERT INTO aey_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Odocob uqa sisiladen, “Ageqa, ijanu in egina?” aden. Odocob Pita jejeg hewi madon, “Hina Anutna Krais,” don. ");
INSERT INTO aey_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Odimei Jisas uqa Anutna Kraisnu oso cain bahic madowainnu je gagadic bahic cahacaden. ");
INSERT INTO aey_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Odimei je maadi maaden, “Dana Melah uqa deweg sogoec ben gahidugian. Juda agena matuca, ihanec dana benbenca, loo je iwaladecca age Dana Melah hibemdumeig uqa qocobil cal migian. Odocob Anut tulidocob deel cijeddocna haun ceseli cajigian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","26","Odocob cunugca maaden, “Dana oso uqa ijanu ijana jenuca majag docobfi saen Dana Melah uqa uqana kobolkobolnaca, Memige Anutca ensel gunca, agena kobolkobolnaca humei uqa dana eunu majag dugian. Odocob dana oso mahamaha cehewan cunug oialumiqa uqana cebac bilec culdimei fadaloubmi cehewan on eunu me biloubfo? Qeeo! Oso uqa uqana cebac bilec cahahadugia odona eu uqa uqana cebac bilec felacudigian. Odocob oso uqa ijana bilina eunu uqana cebac bilec felacudecebfi eu uqa uqana cebac bilec cahahadugian. Eunu oso uqa ijanu madi, ija uqa jaih ceen lahacdudu toodugen, ena eu uqadodoc deweni me biligian ec cain madeiaun qa uqa deeldeelna uqana na babalec hewi gahidumei tooteiale. ");
INSERT INTO aey_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ijaqa mele maadigina, leih age ene tawegina eu age qee cal mec ninijeb Anutna cul cali hohob mecidoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Odocob Jisas je eu odi maaden eu deel 8-pela hedocob uqa Pitaca, Jonca, Jemsca cedadimei ehadi Anut inondugiannu aluh gaticna ti bilein. ");
INSERT INTO aey_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Uqa Anut inondudu bibilen ola fil ibuldon. Uqa lotoc senenec fililaec odi calen. ");
INSERT INTO aey_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Odocob uqana malogom age dana lecis uqaca je togododogin feciadein. Dana lecis eu ale Moses Ilaijaca. ");
INSERT INTO aey_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ale sao jobondec kobolkobolca camasac mesin. Odocobil Jisas isi Jerusalem ono cal mimei Anutna odoc toodu eu cunug ihoc ligiannu uqaca je togodudu madein. ");
INSERT INTO aey_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Oodogin Pita uqa malogom lecis euca age amaga us adein euqa age camalimeig Jisasna kobolkobolca dana lecis uqaca tawein euca feciadein. ");
INSERT INTO aey_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dana lecis eu ale Jisas cuculdesin Pita madon, “O Ben, ege ene odi bilecnu eu me bahic. Ege talah cijed ceheqan, oso hinana, oso Mosesna, odocob oso Ilaijana,” don. Pita uqa qee dudu je maden. ");
INSERT INTO aey_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Uqa je mamaden taen oso nimei jahuladen. Odocob taen jahuladeceb malogom cucuiein. ");
INSERT INTO aey_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Odocob jejeg taennadec cali humei maaden, “Ija melami eu ihen, uqa ija nesili ehudem. Age uqa jejeg toodu odoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Saen jejeg qee meceb ono Jisas cuhanuc tawen. Odocob malogom ceteh cunug calen eu fimeig tiliein. Odocob saen euna age itah oso ceteh caleceb feinnu qee madoloin. ");
INSERT INTO aey_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Deel eu culdimeig deel osona age aluh gaticnadec ceseli noin. Odocob dana cajaca am benca hu Jisas gulucdoin. ");
INSERT INTO aey_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Odocob dana oso dana cajaca eunadec utai madon, “Iwalgec, ija ninihigina, ija melami nui fagale. Ija melami osol bahic! ");
INSERT INTO aey_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Faga, buga me qee hu heweceb eueceb eu sahalic magmagdodon eu qu ihu qocob mahana tonena. Uqa deweg dain doc uteei mahuc culdecwe qee! ");
INSERT INTO aey_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ija hinana malogom ititacdoqagannu niniadigaqa age ititacdocnu odocwe qee,” don. ");
INSERT INTO aey_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Odocob Jisas jejeg hewi maaden, “O dana cajaca qila bilegina, age wawaga meleecca qee, age cisdoc cogogecca! Saen ganic ija ageca haun biligen? Saen ganic ija camuhulaadi cobigen?” aden. Odimei dana eu madon, “Hina melem ehudi ahoga,” don. ");
INSERT INTO aey_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mel eu cocobi hohon buga me qee qu ihu qocob toni mahulimei jaimagana nijen. Odocob Jisas buga gegehinca eu cahacdu madocob culdon. Odimei mel me mudimei memeg ceseli uten. ");
INSERT INTO aey_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Odocob dana cajaca cunug Anutna gagadic odoc fimeig tumatumaein. Dana cajaca age Jisas ceteteh cunug odon eu fefeig geh cisdodoig togodudu bibilegin Jisas uqana malogom maaden, ");
INSERT INTO aey_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ija je qila maadigen eu cain dahiniga celeiaun. Dana Melah eu dana ebenegana muduqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Euqa je eu uqanu gug age wawaga fogo docdainnu age docnu jahunec nijen. Odocob age uqa je eunu sisildocnu cucuiein. ");
INSERT INTO aey_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Odocob fee dadanec malogom gemona cali hon. Eu age in uqa cunug wooladi ben bilina eunu fee dadanein. ");
INSERT INTO aey_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Oodogin Jisas agena cisdoc dumei uqa mel sim oso umei uqa qeihna isec mudimei ");
INSERT INTO aey_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","maaden, “Oso uqa age gemo nag bilina eu age cunug wooladimei ben bilina. Eunu oso uqa mel i ija ijanina ehudimei eeldona uqa ija oitimei eeltena. Odocob oso uqa ija oitimei eeltena eu uqa ija sulten euha ehudimei eeldona,” aden. ");
INSERT INTO aey_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Odocob Jon jejeg hewi madon, “O Ben, ege dana oso hina ijainna buga me qee eundec dana deweneganadec ititacaaden fom. Uqa egena amnadec qee. Eunu ege uqa cahacdom,” don. ");
INSERT INTO aey_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Odocob Jisas uqa Jon malogom gami maaden, “Oso uqa age qee me qee madena eu agenu tawena. Eunu age cain cahacdowain,” aden. ");
INSERT INTO aey_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisas uqa sao ohis tecnu deel wele dodoldodon uqa Jerusalem nuigiannu cisdoc osol taweceb nuen. ");
INSERT INTO aey_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Odocob uqa dana sos suladeceb aqunitu belein. Age belimeig uqanu Sameria jobon ono ceteteh cunug saciadoqagannu lein. ");
INSERT INTO aey_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Euqa uqa Jerusalem himec nuigiannu cisdoc osol tawen. Eunu dana onodec age qee ehudelein. ");
INSERT INTO aey_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Saen malogom lecis Jems Jonca eu odi fimesi madosin, “Tibud, ele sao jobondec ja utadocohul nii cijadigiannu wawin nijiafo?” dosin. ");
INSERT INTO aey_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Odocobil Jisas falicdumei cahacalen. ");
INSERT INTO aey_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Odocob age jobon osona lein. ");
INSERT INTO aey_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Odocob age jic cocobi bebelegin dana oso Jisas madon, “Hina anaana nunuem ija toohigen,” don. ");
INSERT INTO aey_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Odocob Jisas madon, “Qa cus age helona nijegina, odocob man fululec agena teicna nijegina. Euqa Dana Melah uqa us nijec cudunca qee,” don. ");
INSERT INTO aey_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Odocob uqa dana oso madon, “Tootaga,” don. Euqa dana eu madon, “O Tibud, cultecem ija casac ceseli nuimig mei heel cisigen,” don. ");
INSERT INTO aey_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Odocob Jisas jejeg hewi madon, “Cal mec dana culadecem cal mec eundec agena heel ciseigale. Hinaqa nuimeg Anutna culnu je qasali maadaga,” don. ");
INSERT INTO aey_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Odocob dana oso madon, “O Tibud, ija hina toohigenqa casac cultecem ija cotiel odio adecemin,” don. ");
INSERT INTO aey_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Odocob Jisas madon, “Oso uqa culumna hehewi nunui bilei hibiloh isec gaidgaid meciena uqa Anutna culna lecnu cabi ocwe qee,” don. ");
INSERT INTO aey_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Eu hedocob Tibud uqa dana 72 haun nesili ehadimei lecislecis suladeceb taun jobon abesabes cunug uqa uqadodoc euna ligia bili uqa aqunitu belein. ");
INSERT INTO aey_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Uqa maaden, “Cabina ceteh mati bahic cedi haudocnu wal men nijia, euqa cabi dana mati ceteteh cedi jo bisna mecnuca qee bilegina. Eunu sab cedi haudocnu gug uqa cabi dana suladeceb sab haudocnu inondoigale. ");
INSERT INTO aey_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Feiga, ija age suladigina odi sipsip age qa cus gemo leginawe suladigina. Agena jic beleiga. ");
INSERT INTO aey_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Age badomca, meen qaig tacecca, jaimaga tacecca cain u hewi belowain. Dana oso jicna gulucdufeig cain jejeg hewowain. ");
INSERT INTO aey_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Odocob age jo osona hamol limeig casac madeiga, ‘Malol bilec jo ina biliale,’ eiga. ");
INSERT INTO aey_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dana uqa malol bilec je ocnu ihoc jo euna bilecebfi agena malol bilec feele ec je dana deweg fagdugian. Qeefi, malol bilec feele ec je eu haun ceseli ageca hugian. ");
INSERT INTO aey_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cabi dana uqa cabi ameg qaig ugian eunu jo osonadec osona cain leti lowain. Jo osol euna dih bileiga, sab jecnuca wa gab jecnuca cesuladegina eu himec jeiga. ");
INSERT INTO aey_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Cel saen age jobon nag osona lecebil ehadifeig cel sab jec age olanaga moqagan eu jeiga. ");
INSERT INTO aey_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jobon nag euna hag me madeiga. Odimeig dana cajaca ono maadeiga, ‘Anutna cul age cemenega hoia,’ adeiga. ");
INSERT INTO aey_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Euqa age jobon nagna lecebil qee ehadecebilfi jobon nag euna maha gemona limeig maadeiga, ");
INSERT INTO aey_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Comis agena jobon nag ina ege jaimigena fagdona eu ege qoidu helocomun ageca lena. Euqa age i doiga! Anutna cul age cemenega hoia!’ adeiga. ");
INSERT INTO aey_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ija maadigina, dana cajaca Sodom bilein eu age Gesiladec Deel Benna ameg me qee oqagan. Euqa jobon eu agena je hibemdogina eu agena ameg me qee eu Sodom agena ameg me qee wooldugian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jisas je haun maaden, “O Korasin Betsaidaca, odoc kobolkobolca agena calen odi Taia Saidonca hatu caloubmi wele bahic dana cajaca ono age agena silail hibemdogina ihacadecnu lotoc me qee tacimeig bibili comis agedodoc dewenegana weti heheli biloub. Eunu Korasin age walocca! Betsaidaha age walocca! ");
INSERT INTO aey_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Euqa Gesiladec Deel Benna Anut uqa Korasin Betsaidaca ameg me qee wadacadigian eu Taia Saidonca ameg me qee wadacadigian eu wooldoc hugian. ");
INSERT INTO aey_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Odocob Kapaneam agenu! Age Anut uqa sao jobon ohis ehadi tigian ec cisdoginafo? Qeeo, Anut uqa heladeceb oloqanihna noqagan!” aden. ");
INSERT INTO aey_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Odocob Jisas uqana malogom maaden, “Oso uqa age dah madena uqa ija dah mitina. Oso uqa age dah madecnu culina uqa ijanu ha culina. Odocob oso uqa ijanu culina uqa oso ija sultennu ha culina,” aden. Uqa dana 72 suladeceb belein. ");
INSERT INTO aey_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Odocob dana 72 cunugca wawaga ceelecca ceseli hoin. Eu age madoin, “Tibud, buga me qee eu ege hina ijainna ititacadocomun egena je toodoin!” doin. ");
INSERT INTO aey_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Odocob Jisas jejenega hewi maaden, “Ija Seten amel faleecwe sao jobondec totonen figa. ");
INSERT INTO aey_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Feiga, ija ijana gagadic odoc adem. Eunu age man sononecca lacbaiaca lalan ihoc cobogina. Odocob cad uqana gagadic odoc cunug age wooldocnu ihoc cobogina. Odocob ceteh oso dewenega qee tudoiaun. ");
INSERT INTO aey_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Eu odiqa buga me qee agena je toodoginanu cain ceelowain. Euqa age ijanaga sao jobon jaqec taweianu cois ceeleigale,” aden. ");
INSERT INTO aey_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Saen euna dih Kis Gun odudeceb Jisas uqa waug ceelimei je odi maden, “Mei, saoca mahaca alena Tibud, hina ceteh eu dana cisdoc silecca docca eundecnu jahunem. Dana cajaca age mel sim bileginawe bilegina eundec amagana je eu camas mem. Mele, Mei, hina hinana gale hec me bahic toodu odi odom. Eunu ija hina hetaga higina,” en. ");
INSERT INTO aey_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Mei uqa ceteteh cunug ija ebenina men. Dana oso uqa Anut Melah uqana gug qee du cuhadona. Euqa Memige Anut himec uqa Anut Melah uqana gug du cuhadona. Dana oso uqa Memige Anut uqana gug qee du cuhadona. Euqa Anut Melah himec uqa Memige Anut uqana gug du cuhadona. Odocob Anut Melah eu uqana gale docna dana oso Memige Anutna gug ihacdona euha Memige Anutna gug du cuhadugian,” en. ");
INSERT INTO aey_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Odimei Jisas waldumei uqana malogom himec je jahuni maaden, “Ija maadigina, je hahun madec danaca kingca wele bilein mati age ceteh age qila fegina eu fecnu wawaga ben hoolen euqa age ceteh eu qee felein. Dana eundec age je age qila dah megina eu dah mecnu wawaga hoolen euqa age je eu qee dah melein. Eunu age amaga Anutna ceteh fena eunu age eeladecca bilegina,” aden. ");
INSERT INTO aey_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Odocob loo je iwaladec dana oso tawimei Jisas bolobna mudigiannu temdu sisildon, “Iwalgec, ija cebac bilec catanec eu mugumi ugennu eeta odigen?” don. ");
INSERT INTO aey_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Odocob Jisas jejeg hewi madon, “Mosesna loo je jaqec adi madena? Hina jaqec je eu uqana sildec adi eu madaga?” don. ");
INSERT INTO aey_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Odocob dana eu jejeg hewi madon, “Loo je odi madena: ‘Tibud, hinana Anutnu wawin cunugca, doloin cunugca, hinana gagadic odoc cunugca, hinana cisdoc cunugca euna nalug magale,’ ena. ‘Odocob hina hinanel nalunin maganawe odi hina utuqain bilec eundecnu nalug magale,’ ena,” don. ");
INSERT INTO aey_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Odocob Jisas jejeg hewi madon, “Hinana jejeni hewec eu ihoc. Hina odi odimeg cebac bilec ogan,” don. ");
INSERT INTO aey_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Euqa loo je iwaladec ija ijana sisildoc je eu tutuc ihacadigen ec cisdudu Jisas sisildon, “Ija utuqani eu in?” don. ");
INSERT INTO aey_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Odocob Jisas jejeg hewi madon, “Dana oso uqa saen osona Jerusalemdec Jeriko ono nonon heje dana jic sahu qoin. Lotoc cagasi baladoin. Deweg nana ququein geh bahic odi qocobil cul himec mamaden nijen. ");
INSERT INTO aey_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Oodogin saen euna dih nawel tawec ihanec dana oso uqa jic eu toodu non. Odimei uqa dana eu ninijen fimei jic gesac naha isecnu hawadudu wooldon. ");
INSERT INTO aey_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Odocob jic euna himec Liwai dana uqaha hon. Odimei dana eu ninijen fimei jic gesac naha isecnu hawadudu wooldon. ");
INSERT INTO aey_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Euqa Sameria dana oso jic eu toodu ni dana eu fen. Odocob uqa dana eu feceb waug qon. ");
INSERT INTO aey_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Odimei dana eu nijenna limei mool wainca deweg qu me qee mudeinna jouditon. Odimei jeliton. Odimei uqa uqana ceselna mudimei jaen mudec jona ehudi len. Ono uqa cofdon. ");
INSERT INTO aey_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Odocob deel osona uqa qaig silwana mudec lecis umei jo eu cofdoc dana uten. Uqa cofdoc dana madon, ‘Cofdodom. Odocob ija haun isec ceseli humig cofdogannu qaignu ameg fajihigen,’ don,” don. ");
INSERT INTO aey_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Odimei Jisas loo je iwaladec dana eu sisildon, “Hinana cisdocna dana cijed eu age in oso dana eu heje dana qoin eu uqa utuqan?” don. ");
INSERT INTO aey_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Odocob dana eu jejeg hewi madon, “Dana uqa waug qocob cesuldon eu,” don. Odocob Jisas madon, “Hina nuimeg eu odi odoga,” don. ");
INSERT INTO aey_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Odocob Jisas uqana malogom gami jic cocobi bebelegin jobon osona caja oso, ijan Mata, Jisas uqana jona ligiannu madon. ");
INSERT INTO aey_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Uqa caja waliag, ijan Maria, uqa Tibud jaihna bilimei iwaladec je dah memei bilen. ");
INSERT INTO aey_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Odocob Mata uqa cabi cunug uqa dih odiodi oodon uqana cisdoc filfil nuen. Eunu uqa humei madon, “Tibud, ija wali uqa ija cuhanuc cabi uginanu cultia ec cisdogonafo? Madocom hu cesulteia!” don. ");
INSERT INTO aey_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Odocob Tibud uqa jejeg hewi madon, “Mata, Mata! Hina ceteteh geh bahicnu cisdoc eunu wawin me qee mena ");
INSERT INTO aey_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","qa ceteh osol himec eunu cisdoum. Maria uqa ceteh me bahic nesilia. Odocob oso eunu uqanadec ocnu qee nijel,” don. ");
INSERT INTO aey_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Saen osona Jisas uqa cudun osona Anut inondudu bilen. Uqa inondu hedocob malogom oso madon, “O Tibud, Jon uqana malogom inondocnu iwaladen odi ege iwalgaga,” don. ");
INSERT INTO aey_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jisas maaden, “Age inondodoig odi madeiga: ‘O ege Memige, hina ijain gun biliale. Hinana cul egeca hoiale. ");
INSERT INTO aey_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Egena sab jecnu deel abesabesnu igigale. ");
INSERT INTO aey_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ege dana age ege silail migeginanu dahinige celena. Eunu hina egena silailnu dahin celeiale. Hina ege temgecna cain ehi li migigaun,’ eiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Odimei Jisas uqana malogom maaden, “Agenadec oso limei tu gemo bahic uqana danah sisildugianfi, ‘O danah, ijana danah oso qila bahic jobon onocadec hu ijana jona caleia. Odocob ija uqa sab oso utecnuca qee! Eunu hina bred cijed itecem hibna ceseli ihigenfo?’ dugianfi, ");
INSERT INTO aey_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","odocob uqana danah hamoldec je ceseli madugianfi, ‘Cain dodo mitigaun! Jic cebec wele meniga. Odocob ijana mel ijaca wele cabalna nijuqa. Ija cajimig ceteh oso ihecwe qee,’ dugianfi, ");
INSERT INTO aey_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","eunu cel oso? Ija maadigina, uqa uqana danahnu qee cajimei bred utiaunfiqa majagca qee sisildoiaunnu uqa cajimei cetehnu sisildoia eu cunug utigian. ");
INSERT INTO aey_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Odocob ija maadigina, cunug age cetehnu Anut sisildogina eu ceteh ogina. Odocobil oso ceteh walena eu ceteh gulucdona. Odocob oso jic cebec gohugohudona eu Anut huditugian. Eunu age Anut cetetehnu inondocobil ceteh eu adigian, odocobil age wawali cobimeig ceteh walegina eu gulucdoqagan, jic cebec gohugohudocobil Anut hudiadigian. ");
INSERT INTO aey_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Age gemona dana oso uqana mel uqa memeg cul dool itiga jiga docobfi memeg uqa cul dool qee utina qa man sononec utinafo? ");
INSERT INTO aey_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Age gemona dana oso uqana mel uqa memeg mala waqanu itiga jiga docobfi memeg uqa mala waqa qee utina qa lacbaia utinafo? ");
INSERT INTO aey_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Feiga, age dana gug me qee qa age agena mel ceteh me adecnu dogina. Eunu age mele dogina, Memega sao jobon bilia eu uqa age Kis Gunnu sisildogina eundec Kis Gun adigian!” aden. ");
INSERT INTO aey_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aria, dana oso buga me qee hewen bilen, uqa co cufa qon. Odocob Jisas uqa buga me qee dana dewegnadec ititacdon. Saen buga me qee eu qisacdocob dana eu je maden. Odocob dana cajaca eu odi fecebil wawaga tumatumaein. ");
INSERT INTO aey_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Euqa dana leih madein, “Uqa Bielsebul, buga me qee agena ben, uqana gagadic odocna buga me qee dana deweneganadec ititacadena,” ein. ");
INSERT INTO aey_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Leih uqa temdu feqan imeig age uqa Anutna cabi onana gaga eunu hina kobolkobol oso oodom faga gena ec sisildoin. ");
INSERT INTO aey_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Euqa Jisas agena cisdoc fimei maaden, “Hatu osona mam cadecebil qatanec bilecebfi age gaus danoqagan. Odocob sihulsihul cunug age mam cacadi qocobqocobimeig toni aqigian. ");
INSERT INTO aey_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Age ijanu madi, uqa buga me qee Bielsebulna gagadic odocna dana deweneganadec ititacadena, egina. Eunu Setenna cul age mam cacadi qocobqocobimeig am qatanec filfil bileginafi uqana cul eu adi biluqagan? ");
INSERT INTO aey_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ija buga me qee Bielsebulna gagadic odocna dana deweneganadec ititacadigina eu melefi agena malogom euha inna gagadic odocna buga me qee dana deweneganadec ititacadegina? Eunu agena malogom agena odoc eu Farisi agena je cahuldoc eunu ihacadigian. ");
INSERT INTO aey_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ijaqa Anutna gagadic odocna buga me qee dana deweneganadec ititacadiginafi Anutna cul ageca wele hoia,” aden. ");
INSERT INTO aey_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Dana gagadic uqana han qalicca cunug saciadu uqana jo cofdudu tawena saen euna uqana ceteteh cunug tutuc bilina. ");
INSERT INTO aey_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Euqa dana gagadic bahic uqana wooldoc humei uqaca cacadi han wooldona saen euna wooldoc dana uqa dana gagadic uqana han qalic jo gug eu hannu hewen hewi ehi nuina, odocob uqa dana gagadic uqana ceteteh heje ceden euha hewi ehi nuimei siwi adena,” aden. ");
INSERT INTO aey_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Oso uqa ijana danah qee eu uqa ija cad mitina. Oso ija cesultimei dana cajaca Tibud cemenug qee hauadena eu dana cajaca bilisaadena,” aden. ");
INSERT INTO aey_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jisas je haun maaden, “Saen buga me qee dana dewegnadec cali hona uqa jaen mudec cudun wawali hatu galalecna cobona. Uqa cudun oso qee fifei eu madena, ‘Ijana jo cuculi hom euna ceseli nuigen,’ ena. ");
INSERT INTO aey_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Uqa ceseli humei jo gegehinca qee, cunug eeldoc ninijen fena. ");
INSERT INTO aey_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Odimei uqa haun ceseli nuimei buga me qee 7-pela cedi ahocob uqa gami bilegina. Buga me qee 7-pela eu agena odoc me qee uqana odoc me qee wooldoc. Eunu dana eu uqana bilec qila euna me qee bahic mena. Uqana bilec weledec wooldona,” aden. ");
INSERT INTO aey_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Saen Jisas eu odi madi hedocob caja oso dana am eunadec co helimei Jisas madon, “Caja hina basihimei su ihen uqa waug ceelceelena!” don. ");
INSERT INTO aey_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Euqa Jisas jejeg hewi madon, “Eu odi qee. Dana Anutna je dah mimeig toodu odogina eu age ceelceelegina!” don. ");
INSERT INTO aey_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dana cajaca am age Jisas talildodogin maaden, “Dana sihul i qila bilegina age qisol megina. Age gaga oso fecnu walegina. Euqa age gaga oso qee fowain. Age gaga osol dih foqagan, eu je hahun madec dana, Jona, uqana gaga eu himec foqagan. ");
INSERT INTO aey_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ge, wele Jona uqa Niniwa dana agenu gaga calen. Eunu eu odiwe Dana Melah uqa dana sihul qila bilegina agenu gaga caligian. ");
INSERT INTO aey_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Weleca Kwin sautdec uqa Solomonna cisdoc silecca je dugen imei hatu onoca bahic cocobi niniji hu je dah men. Ijaqa maadigina, oso eu Solomon wooldoc ene bilia! Eunu Kwin sautdec uqa Gesiladec Benna dana qila i ene bilegina eundec gami cajimeig uqa dana i bilegina deweneganu geladec je madigian. ");
INSERT INTO aey_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Weleca Niniwa dana age Jona me je qasali maadeceb agena silailnu tului falicdoin. Ijaqa maadigina, oso eu Jona wooldoc ene bilia! Eunu Niniwa dana age isi Gesiladec Benna dana sihul qila i ene bilegina eundec gami cajimeig age dana i bilegina deweneganu geladec je madoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jisas je haun maaden, “Oso gowoc madacdumei jo bisalu qee mena, odocob hal dunuh qee tacena. Euqa uqa gowoc ohisna caqusena. Eunu dana cunug age hamol hogina eu age gowoc camas foqagan. ");
INSERT INTO aey_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Dewenna fulacdoc eu hina amen. Hina amen me nijinafi hina dewen cunug fulacdocca nijina. Euqa hina amen galuc mecebfi dewen tu mena. ");
INSERT INTO aey_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Eunu fulacdoc hina dewenna nijina eu cafuleceb wawin tuca meiaunnu hina batut cofdogale. ");
INSERT INTO aey_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hina dewen eu cunug fulacdoc leceb gagatucna qee bilecebfi euna uqana fulacdoc cunug ihoc ligian. Gowoc uqana fulacdoc cudun cunug ihoc lenawe fulacdoc eu hina dewen cunug odi fulacdona,” aden. ");
INSERT INTO aey_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Saen Jisas je maadi hedocob Farisi oso uqaca sab jowasannu cesusdon. Eunu uqa hamol limei sab jigiannu bilen. ");
INSERT INTO aey_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Saen Jisas eben qee wasacudec sab jejen fimei Farisi uqa tumatumaen. ");
INSERT INTO aey_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Eunu Tibud uqa madon, “Farisi age gabinca bohca hibo eu gaid wasacudegina euqa age wawaga dunuhna heje oc kobolca, qisol mec kobolca nijia. ");
INSERT INTO aey_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Age gad! Anut uqa dewenega muden uqa wawagaha qee mudelfo? ");
INSERT INTO aey_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Euqa cel ceteh oso agena gabin bohca dunuh bilia eu sawen adeiga. Odocob agena dewenega ganacca wawagaca cunug eu soidoc biligian,” don. ");
INSERT INTO aey_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“O Farisi age agena ceelum filfil cabinadec am 10-pela qatanadimeig am osol eu Anut utegina. Euqa age tutuc odoc dana qee odadegina, odocobha age dana cajaca Anutnu nalug mecna qee nalunuga megina. Loo je i age toodu odoub qa sab Anut utecnu loo je ha qee dahiniga caloub. Eunu age walocca!” don. ");
INSERT INTO aey_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“O Farisi age dana ben agena bilec cudun Juda agena cuha jona gale ben adena. Odocob ceteteh fajec cudunna age binanaga sulecnu gale ben adena. Eunu age walocca! ");
INSERT INTO aey_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Age qalqal dana qee feginawe, odocob dana qee docdoc lalan cobogina. Eunu age walocca!” don. ");
INSERT INTO aey_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Odocob loo je iwaladec dana oso madon, “Iwalgec, hina je odi madagana eu egenu ha je me qee madagana!” don. ");
INSERT INTO aey_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Odocob Jisas jejeg hewi madon, “O loo je iwaladec dana age ceteh culumenca dana gogodomogana megina eu gahidocwe qee qa agedodoc bahic ebenega gic osol hululecdumeig ceteh culumenca eu gahidocnu qee cesuladegina. Eunu ageha walocca! ");
INSERT INTO aey_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Age Anutna je hahun madec dana age agena sihul weledec dewenega tudocobil cal mein age agena qalqal meen hatin cehegina. Eunu age walocca! ");
INSERT INTO aey_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Agena sihul weledec age je hahun madec dana aqecebil cal mein, odocob age je hahun madec dana agena qalqal meen hatin cehegina. Eunu agedodoc kobol eu odoginana age qasali madegina, ‘Egena sihul weledec odoin eu cois,’ egina. ");
INSERT INTO aey_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Je gug eunu Anutna doc maden, ‘Ija je hahun madec dana sos cabi danaca suladigen. Odocob eu age leih aqecebil cal moqagan. Odimeig leih aqati tootooadoqagan,’ en. ");
INSERT INTO aey_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Eunu sao mahaca ifanen saennadec li qila saenna je hahun madec dana cunug age aqecebil cal meinnu Anut dana qila bilegina wadacadigian. ");
INSERT INTO aey_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ebelna golac basecdoc sanijec euna sanan mimei ehi lili Sekaraiana golac basecdoc ihoc len. Sekaraia uqa age tempel hamol gunna ihanec cabalca gemona qocobil cal men. Ija mele maadigina, aqecebil cal mein eu uqana ameg me qee oc cunug dana caja qila bilegina i dewenegana hugian,” don. ");
INSERT INTO aey_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“O loo je iwaladec dana age Anutna culnu doc ocnu jo jic cebec hudecnu ki hehewi hoin. Agedodoc age qee dunuh lelein. Odocob age leih dunuh loqaga odogina eu ageha cahacadegina! Eunu age walocca!” aden. ");
INSERT INTO aey_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Saen Jisas cudun eu culden nunuen loo je iwaladec dana Farisica qesaldoin. Odimeig ceteteh geh bahicnu sisildoin. ");
INSERT INTO aey_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Je oso cahuldu madeceb euna hewoqaga bili temdoin. ");
INSERT INTO aey_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dana cajaca am mati bahic hu cegulen. Eunu age jaimaga lahacdocobdocobein. Jisas uqana malogom casac maaden, “Age Farisi agena bred gug qoc ibuldocnu jisnu ageca hoiaunnu batut feigale. Farisi agena jis eu agena uhulec je. Age madegina, ‘Kobol i toodoiga,’ egina qa agedodoc qee toodogina eunu ija maadigina. ");
INSERT INTO aey_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ceteh cunug jahuldoc nijina eu isi camasac migian. Odocob ceteh cunug jahunec nijina eu isi cunug doqagan. ");
INSERT INTO aey_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Cel je tuna madein eu cahinegna dah moqagan. Odocob cel je age hamol tuna jahnana maadecebil dah mein eu age jo ohisna tatawi utai maadecebil dana cajaca cunug doqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jisas je haun maaden, “Ijana danah, ija maadigina, leih dana dewenega qocobil cal megina, odocob hibna ceteh me qee oso odocwe qee eundecnu cain cucuiuwain. ");
INSERT INTO aey_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Euqa ija age in cucuidoqagan eu ulauladigen. Anut cucuidoiga. Uqa aqeceb cal mecnu ihoc. Cal mecebil uqa hibna oloqanih jana heladecnu gagadic odocca nijia. Mele bahic maadigina, uqa cucuidoiga!” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Man fufulec nag eundec 5-pela eu toea lecisna idadogina. Eu agena osolosolnu Anut qee dahig celena. ");
INSERT INTO aey_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Age gosiniga ilomogana nijia euqa cunug Anut wele sanijen bilia. Eunu cain cucuiuwain. Agena fajec eu man fululec nag mati agena fajec wooldoc nijia,” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jisas je haun maaden, “Ija maadigina, oso uqa dana amagana tatawi ijanu madi madena, ‘Ija Jisas uqana malogom,’ ena eu uqanu Dana Melah Anutna ensel amagana madigian, ‘Eu ijana,’ igian. ");
INSERT INTO aey_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Osoqa uqa dana amagana tatawi ijanu qee sasac qu madena, ‘Ija Jisas uqana malogom qee,’ ena eu uqanu Dana Melahha Anutna ensel amagana madigian, ‘Dana i ijana qee,’ igian!” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Oso uqa Dana Melahnu je me qee madena eu Anut uqa dana eu uqana silail cagasitugian. Euqa oso uqa Kis Gunnu lelan madenafi Anut uqa dana eu uqana silail qee cagasitoiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","“Saen age ehadi lecebil Juda agena cuha jonafo, hatu kingnafo, loo je cofdoc dananafo ono gesiladoqagannu amagana madecebil Kis Gun saen euna dih je adi madoqagannu iwaladigian. Eunu age casac cel je cel je jejenega hewi maadigen cain jaen aqeiaun, o je adi madoqagannu cain cisdowain,” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Odocob dana oso am dunuh eunadec madon, “Iwalgec, ija wali madocom ceteteh memile cuculi cal men eu cesawi cedewan,” don. ");
INSERT INTO aey_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Odocob Jisas jejeg hewi madon, “Coti, in ale gesilalecnu cabi iten? In ceteteh cesawialecnu cabi iten?” don. ");
INSERT INTO aey_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Odimei uqa cunug odi gabanadi maaden, “Age batut feiga! Dana osoqa uqa cehewan ben bahiccafi uqa cebac bilec bahic eu uqana ceteteh cunugna qee bilina. Eunu ceteteh mati bahic cedecnu cain cisdowain,” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Odimei Jisas galolo je i maaden, “Dana cehewanca uqana maha sab masuaden. ");
INSERT INTO aey_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Odocob uqadodoc cisdon, ‘Ijana sab meadecnu cudunca qee. Ija adi odigen?’ cisdon. ");
INSERT INTO aey_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Odimei uqa maden, ‘Ija odi odigen. Ijana sab tacec jo eu wagaladimig nag meca cehadigen. Euna ijana sab ijana ceteteh cunugca migen. ");
INSERT INTO aey_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Odimig ijadodocnu madigen, “Ijana jaen qitec qila hedoia! Ijana ceteteh meme cunug cabi gel matinuca. Cebac bilec maha ina ilag bahic cain odigaun. Sab jejemin wain jejemin celeboii biliga!” igen,’ en. ");
INSERT INTO aey_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Euqa Anut madon, ‘Hina dana gad! Witic ina dih cebac bilec maha inadec culegan. Odocob hina cehewain wele saciadom eu in cedigian?’ don,” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Odimei Jisas je eu tubdu maaden, “Eu odiwe dana cehewanaga agedodocnu haudogina qa Anut amegna eu age cehewanagaca qee,” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Odimei Jisas uqana malogom maaden, “Eunu ija age maadigina, age mahana cebac bilecnu cain jaen aqeiaun. Eeta sab jeqan cain owain. Age deweneganu ha cain jaen aqeiaun. Eeta taceqan cain owain. ");
INSERT INTO aey_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ge, agena cebac bilec eu sab jec wooldona. Odocob dewenega lotocha wooldona. ");
INSERT INTO aey_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Calog meciadeigale. Age ceteteh qee cehegina. Ageha sab wal meceb qee jajadogina. Age jo bisca qee, age sab haudoc johaca qee. Euqa Anut uqa moot madena! Age agena fajec eu man fululec agena fajec wooldoc bahic bilegina! ");
INSERT INTO aey_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Age info uqa uqana cebac bilecnu jaen qonana uqa uqana maha bilec saen nag cecelacca mudecnu ihoc? ");
INSERT INTO aey_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hina ceteh nag eu odi odocwe qeefi eetanu ceteh leihnu ha jaen aqena? ");
INSERT INTO aey_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Age ceteh sal qoc wasena eu feiga. Age qee cabi ogina, agena lotocha qee mudegina. Euqa ija maadigina, Solomon uqa lotoc tumutumca bahic taci tawen eu sal qoc bahunadec tawena i oso qee wooldol. ");
INSERT INTO aey_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Euqa Anut uqa ceteh gigisac gami tacec balaca adena, ceteh eu qila tawena uqadec jana helecebil cijina. O age wawaga meleec meca qee, age dogina, Anut uqa age gigisac wooldudu tacecnu adigian. ");
INSERT INTO aey_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Eunu age eeta sab jeqan, eeta gab jeqan eu cain cisdowain. Age cain jaen aqeiaun. ");
INSERT INTO aey_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ge, dana cajaca age mahamaha cunugna bilegina age ceteh eundecnu gaid jaen aqena. Odocob age Memega uqa age ceteh euca qeefi age maha ina bilecwe qee eu uqa dona. ");
INSERT INTO aey_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Euqa age Anut mudecebil uqa agena king biliale. Oodobil ceteh mahanadec eu toodu ageca hugian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jisas je haun maaden, “Dana am tootec nag bahic, age Memega uqa cul adecnu gale dona. Eunu cain cucuiuwain. ");
INSERT INTO aey_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","34","Age toinanaga haudoc nijina eunu age wawaga cisdocha nijina. Eunu agena ceteteh cunug suldumeig meen qaig eu dana sawen eundec adeigale. Agedodoc agena meen qaig tacec badom qee qee mena eundec oiga. Odimeig age cehewanagaca sao jobonna biluqagannu saciadoiga. Ono cehewanaga eu qee qee meiaun. Ono heje dana oso euna lecwe qee. Susul ha me qee mudecwe qee,” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jisas je haun maaden, “Cel ceteh oso ququlubadecdainnu saciadudu bileiga. Agena lotoc taqi cuhadocca gowoc tuldumeig bileiga. ");
INSERT INTO aey_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Cabi dana agena dana meca ocobocobec deelna sab jecnadec ceseli hohob sumudi biloubwe. Age odi biluqaganfi saen uqa humei jic cebec gohugohudocob age uqana jic cebec mahuc bahic huditoqagan. ");
INSERT INTO aey_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Cabi dana age agena dana meca uqana ceselec saenna odi saciadu bibilebil uqa age meciadecebfi age bahic eu ceelecca biluqagan! Ija mele maadigina, uqana lotoc taqec halu taqimei maadeceb cabalna bilecebil sab adigian. ");
INSERT INTO aey_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Uqa tu gemofo, nag isicafo ceseli humei eu age saciadocca sumudi bilecebil meciadifei agena ceelec ben bahic nijigian! ");
INSERT INTO aey_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Euqa ceteh i doiga. Dana jo gug uqa heje dana aadeb hu ijana ceteteh heje ugian eu doialumi uqa us qee nijoub. Odimei uqa heje dana culdocob uqana jo qeih qatanimei dunuh qee loub. ");
INSERT INTO aey_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ageha saciadoc susumudi bileigale. Ge, Dana Melah uqa qila hugian qee ec saen euna mele hugian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Odocob Pita madon, “O Tibud, hina i galolo je magaganafo, qee dana cunugnu odi maadaganafo?” don. ");
INSERT INTO aey_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Odocob Tibud jejeg hewi madon, “Cel cabi dana uqa doc meca uqana cabi cofdu cuhadona? Eu oso uqa uqana meca uqana jo cofdoc mudigian. Uqa cabi dana cunug cofadigian. Agena sab saennana adigian. ");
INSERT INTO aey_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Cabi dana eu saen uqana meca jobon ceseli humei odi oodob fecidocob uqa ben bahic ceeligian! ");
INSERT INTO aey_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ija mele maadigina, uqana meca uqa uqana ceteh cunug cofdugiannu ebenna migian. ");
INSERT INTO aey_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Euqa cabi dana eu uqadodoc madifei, ‘Ijana meca uqana hocnu deel cecelac nijia,’ ifei cabi dana cajaca hijagul eu uqa aqecnu sanan mimei sab jiji wain jiji dalul aqeceb cocobil ");
INSERT INTO aey_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","meca eu hibna deel osona hugian. Eu saen cabi dana uqa hugian eu qee dodocob saen euna hugian ec qee doc ninijeb hugian. Uqana meca eu odi fifei qeti susul falecnu ihoc bahic. Odimei cudun dana Anutnu wawaga qee meleec bileginana cabi dana euna mudigian,” don. ");
INSERT INTO aey_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Cabi dana uqana meca cel cabi ocnu uten eu uqa dona eu qee saciadumei uqana meca madon odi qee odel uqa eu geh bahic qisadugian. ");
INSERT INTO aey_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Euqa cabi dana uqa uqana meca cel cabi ocnu uten eu qee dona qa uqa qisadocnu cahuldoc oso odocobfi uqa nag odi dih qisadugian. Dana oso Anut uqa ceteh geh utina Anut uqa madugian, ‘Ceteh gehca ceseli itiga,’ dugian. Dana oso ceteh geh bahic utegina age uqa madoqagan, ‘Ceteh gehca ceseli igiga,’ doqagan,” don. ");
INSERT INTO aey_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisas je haun maaden, “Ija mahana ja hudecemin ciji olic danigiannu hom. Ija wawi madec nijina odi mahuc bahic wele hudia! ");
INSERT INTO aey_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ija dain tec ben oso umig cal migen. Eu wa joitec oso ugen cinigwe. Ija jaen qiqiteb saen hedugian! ");
INSERT INTO aey_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Age ija mahana malol bilec igecnu hom ec cisdoginafo? Cain odi cisdowain. Ija malol bilec mahana ahu mecu qee holom qa ija maadigina, age am osol bilec eu filfil qatanadigennu hom. ");
INSERT INTO aey_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Qila odi sanan mena. Sihul osolna age 5-pela filigandoqagan. Cijed age lecis gami cadoqagan. Lecis ale cijed gami cadowasan. ");
INSERT INTO aey_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Age qatanadec biluqagan. Memegail age melemegail gami cadoqagan, odocob melemegail age memegail gami cadoqagan. Anagail age atagail gami cadoqagan, odocob atagail age anagail gami cadoqagan. Momogail age atagail gami cadoqagan, odocob atagail age momogail gami cadoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Odocob Jisas dana cajaca am je oso ha maaden, “Saen age taen cam tonec isec beben fefeig mahuc bahic madegina, ‘Wa hugian,’ egina. Odocob mele bahic wa hona. ");
INSERT INTO aey_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Odocob saen fufu sautdec qaheceb age madegina, ‘Cudun dain cahuligian,’ egina. Odocob eu mele bahic odi odona. ");
INSERT INTO aey_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Age me hihili coboc dana! Age maha saoca uqana odoc fimeig eu cel gugnu eu dogina. Euqa saen qila biluqa eu eetanu age gug qee dogina?” aden. ");
INSERT INTO aey_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jisas je haun maaden, “Age agedodoc eetanu ceteh ititom odocnu eu qee gesilegina? ");
INSERT INTO aey_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dana oso hina dewennu um qocobfi hinana cad gesilec dana euna ehihi nunueb uqa gesilec dana amegna mihiaunnu, odocob gesilec dana uqa gesilec jona cofadec dana ebenna miheceb cofadec uqa gihacdoc jona mihiaunnu eunu hina gesilec jona nunuesi dana euca je eu tutuc mudesiale. ");
INSERT INTO aey_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ija mahigina, hina ameg qaig ihoc lec qee helecemfi qee bahic besihuwain,” aden. ");
INSERT INTO aey_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Saen euna dana ono bilein age Galili dana age dool ihandodogin Pailat uqa uqana han dana maadeceb aqecebil age cal mein. Age golanaga ihandoc dool golacca ihuldosin eunu Jisas madoin. ");
INSERT INTO aey_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Odocob Jisas jejenega hewi maaden, “Galili dana eu odina cal meinnu agena cisdoc eu Galili dana eu age agena silail eu Galili dana cunug wooladec eginafo? ");
INSERT INTO aey_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Qee bahic! Ijaqa maadigina, age agena silailnu qee tului falicdufeig age cunug ageha odiwe fadaloqagan. ");
INSERT INTO aey_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Qeefi, dana 18 cunugca Siloam jo cecelac ohisdec toni cilehadeceb cal mein eu adi? Age cisdogina, eu agena silail Jerusalem dana cunug wooladec eginafo? ");
INSERT INTO aey_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Qee bahic! Ijaqa maadigina, agena silailnu qee tului falicdufeig age cunug ageha odiwe fadaloqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Odocob Jisas galolo je i maaden, “Dana oso uqana wain cabina na dan cehen. Odocob hibna uqa dan eu limei aig cedecnu fen qa osol oso qee fel. ");
INSERT INTO aey_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eunu uqana cabi dana madon, ‘Faga, cabi gel cijed cunugca ija ene humig dan euna dan aig cedigennu waladem qa oso qee felem. Eetanu odi tatawi maha gauc ji hedona? Codoga nuia!’ don. ");
INSERT INTO aey_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Euqa cabi dana jejeg hewi madon, ‘O Meca, culuga taweia. Cabi gel osol himec ija maha huni taldumig bulmakau uqana bujec gugna tacecemin cali bigian. ");
INSERT INTO aey_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Odocob dan eu aig gisecebfi cabi gel oso euna eu me bahic. Qeefi, cois codogan,’ don,” aden. ");
INSERT INTO aey_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Juda agena cuha deel osona Jisas uqa Juda agena cuha jona iwalaadien ");
INSERT INTO aey_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","caja oso ono bilen. Buga me qee hagca eu hewuden. Uqa gaid odudeceb cabi gel 18 hag euca cobon. Uqa hoh qahen eu haun tutuc mecwe qee. ");
INSERT INTO aey_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Odocob Jisas caja eu fimei utadocob hocob madon, “Caja, hinana hag ija besihigina!” don. ");
INSERT INTO aey_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Odimei uqa eben deweg qududocob mahuc bahic uqa hoh eu tutuc meceb Anut binan ben sulen. ");
INSERT INTO aey_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Odocob cuha jo eu uqana cabi dana ilo cuha deelna Jisas hag me mudeceb gemag bennu uqa madimei dana am maaden, “Egena cabi oc deel eu 6-pela. Eunu deel euna hocobil agena hag me madena eu cois. Euqa cuha deelna cain!” aden. ");
INSERT INTO aey_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Odocob Tibud uqa jejeg hewi madon, “Age me hihili coboc dana! Age eundec oso uqana bulmakaufo, ceselfo cufaldumei sab jecnu boh cudunnadec cuha deelna iwaldudu ehi nueceb wa qee jenafo? ");
INSERT INTO aey_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Qila caja i Ebrahamna sihulnadec oso uqa Setenna buga me qee uqaca cabi gel 18 jelec bilen. Uqa Setenna buga me qeenadec cuha deelna uqana jelec qee cufaldugaunfo?” don. ");
INSERT INTO aey_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Odocob uqa jejenega heweceb uqana cad eundec age odadeceb cunugca agedodoc majanaga aden. Oodon dana cajaca age cunug Jisas ceteteh gagadic odocca cunug odonnu wawaga ceelen bilein. ");
INSERT INTO aey_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Odocob Jisas maaden, “Anutna cul eu adec? Cel ceteh eu ale caca ec madigen? ");
INSERT INTO aey_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Eu mastet aig cinigwe eu dana oso umei uqana cabina cehen. Mastet eu wasi ben mimei na ben ibuldon. Odocob man fululec age humeig batacnana agena teic mein,” aden. ");
INSERT INTO aey_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Odocob Jisas haun maaden, “Cel ceteh eu Anutna cul euca caca ec madigen? ");
INSERT INTO aey_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Eu jis cinigwe caja oso umei plaua dram benna euca gabandumei ibuldocob uqadodoc cunug iben,” aden. ");
INSERT INTO aey_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Odocob Jisas taun nagnana jobonnana iwalaadi nui Jerusalem caligiannu nuen. ");
INSERT INTO aey_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Odocob dana oso sisildon, “O Tibud, dana Anut cahahaadigian eu osooso himecfo?” don. Odocob Jisas jejeg hewi maaden, ");
INSERT INTO aey_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ija maadigina, dana cajaca geh bahic jic cebec sosogna lecnu temdoqagan qa ihoc qee lowain. Eunu age jic cebec sosogna lecnu gagadic meigale. ");
INSERT INTO aey_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Dana jo gug eu cajimei jic cebec menigian. Odimeig maha gemo tataweig jic cebec gohugohududu madoqagan, ‘O Tibud, hu ege jic cebec hudigaga!’ oqagan. Odocob uqa jejenega hewi maadigian, ‘Ija age anadec eu qee dugina,’ adigian. ");
INSERT INTO aey_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Odocob age jejeg hewi madoqagan, ‘Ege hinaca osoben sabca wa gabca jom. Hina egena jobon ono iwalgem!’ oqagan. ");
INSERT INTO aey_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Odocob uqa haun maadigian, ‘Ija age anadec eu qee dugina! Age silail dana! Ija cuculti qisacteiga!’ adigian. ");
INSERT INTO aey_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ono age Ebraham, Aisak, Jekobca age je hahun madec dana age cunugca Anutna culna bibilebil meciadoqagan. Meciaadebil Anut age ititacadeceb beloqagan saen euna age qada qajec benca maimaga kicodudu biluqagan. ");
INSERT INTO aey_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dana age cam tobi becnadecca, cam toni nocnadecca, notdecca, sautdecca, hatuhatu cunugnadec humeig Anutna culna sab jecnu cabalna biluqagan. ");
INSERT INTO aey_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Odocob feiga, leih qila hib bahic taweiga eundec age isi aquni tawoqagan. Odocob leih qila aquni taweiga eundec age isi hib bahic tawoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Saen euna dih Farisi leih Jisasca limeig madoin, “Herod qagahigia madeia. Eunu hina enedec isa qoga. Cudun osona nuuga,” doin. ");
INSERT INTO aey_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Odocob Jisas jejenega hewi maaden, “Nui faninadec dana eu madoiga, ‘Ija qila uqadecca buga me qee dana deweneganadec ititacaadig dana caja hagca me madigen. Odocob deel cijeddocna ijana cabi oc qee migian,’ doiga. ");
INSERT INTO aey_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Euqa je hahun madec dana eu cudun ilagnana qee aqowain, eu Jerusalem ono himec aqecebil cal megina eu odi nijia. Eunu qila uqadec eledecca eu ijana jic coboc eu cobigen,” aden. ");
INSERT INTO aey_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem, Jerusalem, Anut uqa uqana je hahun madec dana ageca suladeceb lein. Euqa age meenna aqecebil cal mein. Ija saen mati bahic agena dana cajaca gabanadimig ahutecnu gale tena eu odiwe mala anag uqana nag hojonna jahuladigen imei utaadena, euqa age ijaca hocnu culein. ");
INSERT INTO aey_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Feiga, Anut uqa agena jobon culdina. Ija maadigina, age ija qila haun qee mecituwain leceb madoqagan: ‘Dana eu uqa Tibud ijanna hona Anut uqa eeldoiale,’ odi madimeig mecituqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Juda agena cuha deel osona Jisas Farisi agena iwaladecna jona wesu sab jigiannu len. Odocob dana ono bilein age Jisas cofcofdoin. ");
INSERT INTO aey_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Odocob dana oso jaih ebenca gomahin taec ono bilen. ");
INSERT INTO aey_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Odocob Jisas loo je iwaladec dana Farisica sisiladen, “Egena loo je cuha deelna dana hagca me madecnu cois ec nijiafo, qeefo?” aden. ");
INSERT INTO aey_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Odocob age jejeg oso qee hewelein. Jisas dana eu ehudimei hag qee muditumei suldocob nuen. ");
INSERT INTO aey_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Odimei uqa maaden, “Age dana oso uqa melahfo, uqana bulmakaufo eu wa helona dunuh toneceb cuha deel i edina mahuc bahic helonadec didocobil qee cali beiaunfo?” aden. ");
INSERT INTO aey_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Odocob age sisilec uqana eu jejeg wadacdocnu ihoc qee. ");
INSERT INTO aey_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Odocob Jisas uqa dana age maadeceb hoin leih agena gawecna bilec cudun binanca nesili cecedegin meciaden eunu uqa galolo je i maaden, ");
INSERT INTO aey_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","11","“Oso uqa culai ijanel lalan mumudi bilina euqa Anut uqa dana eu cilehdugian. Oso uqadodoc jogoi waug lal qocca bilina eu Anut uqa dana eu culaug u lalan mumudeb biligian. Eunu saen oso ocobocobec deelna sab cicileig maheceb lifeg dana oso uqa ijanca ben hina woolhec uqa ha saen euna madocob leiaundainnu, odocob alena jec sab cofdoc ale lecisca odi howasannu maalen humei maheiaun, ‘Cudun i culitocom hu bilia,’ heiaunnu, odocob hina majain heheb cudun mahana bahic euna bilegaunnu hina cudun binanca euna cain biligaun. Eu odinu hina je sulduhecebilfi limeg cudun mahana bahic umeg biliga. Eunu dana uqa maheceb hom eu limei mahigian, ‘Ijana danah, cudun binanca ina tobi biliga!’ higian. Eu odina hina ijain dana cunug amagana me bahic ogan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Odocob Jisas uqa Farisi dana madocob hon eu madon, “Saen hina cahineg sabfo, wesu sab benfo jejeg hinana danah cain cedi ahogaun. Hina walinelfo, hinana sihul eundecfo, hina mudubainel bilegina cehewanagacafo ha cain cedi ahogaun. Eu age haun je sulduhecebil jecnu legan jic eu odina hina cel odadecem eu wadacdoc ameg ogan. ");
INSERT INTO aey_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Eu odi cain. Saen hina sab ben cicileg dana sawenca, jaimaga cogogecca, laleg mecca, odocob amaga galuc mecca cedi ahoga. ");
INSERT INTO aey_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Eu age hina ameg wadacduhecwe qee. Eunu hina eelhec ogan. Odocob saen dana ititom cal mecnadec ceseli cacajebil hina Anut ameg ihigian,” don. ");
INSERT INTO aey_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Odocob dana oso sab jec cudunna Jisasca bibilesin je eu dah mimei Jisas madon, “Dana Anutna culna sab jec cudunna biluqagan age ceeli biluqagan!” don. ");
INSERT INTO aey_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Odocob Jisas madon, “Dana ben oso uqa sab ben ciligia bili dana geh bahic hoqagannu je suldu maaden. ");
INSERT INTO aey_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sab ben cilec deelna uqana cabi dana eu uqa ehadigia bili suldocob nui maaden, ‘Sab jec cunug saciadoc taweia. Hoigale!’ aden. ");
INSERT INTO aey_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Euqa age cunug lecnu culimeig cagasec je madoin. Oso uqa cabi dana eu ninidudu madon, ‘Ija cabi ben oso fajiga eu nuimig figen. Ija lecwe qee,’ don. ");
INSERT INTO aey_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Oso ninidudu madon, ‘Ija bulmakau 10-pela cabi cesultecnu fajadiga eu ija nuimig temadigen. Ija lecwe qee,’ don. ");
INSERT INTO aey_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Oso ha madon, ‘Ija cum bahic caja ugan. Ija lecwe qee,’ don. ");
INSERT INTO aey_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Odocob cabi dana eu ceseli nuimei uqana meca je cunug sadon. Odocob uqana meca je eu odi dah mimei gemag ben bahic ben. Odocob uqa cabi dana madon, ‘Mahuc bahic nuimeg jic anagnanaca, jic nagnanaca, taun bennaca age dana sawenca, jaimaga cogogecca, laleg mecca, amaga galuc mecca ehadi cedi ahoga,’ don. ");
INSERT INTO aey_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Uqa nueceb nag odi susumuden cabi dana ceseli humei madon, ‘O Meca, hinana je eu cunug tooduga euqa dana haunnu cudun nijia,’ don. ");
INSERT INTO aey_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","24","Eunu meca uqana cabi dana madon, ‘Ija maadigina, dana cunug ija hoqagannu maadem age ijana sab nag qee qududu fowain! Eunu ijana jo ihoc ligiannu jic benna, jic sosogna, bahuna nuimeg dana cajaca hoqagannu cesusadoga,’ don,” don. ");
INSERT INTO aey_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Dana cajaca am matica age Jisas gami belein. Odocob uqa waldumei maaden, ");
INSERT INTO aey_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","32","“Age oso uqa jo ben cecelac odocob ohis bahic cehigiannu cisdonafi uqa casac bilimei ceteteh qaigna fajadigiannu qaig hahun odi bahic ec temdu fena. Eu odi eu uqa jo eu qee mudigiannu meen qaig ihocfo? eu cisdu figian. Gadgad uqa eu odica qeefi uqa jo ben ohis bahic eu sanan mimei hibna qee mudec ihoc qee. Odocob leih age eu fimeig uqa lelandowaindain. ‘Dana i jo cehec sanan men qa qee mudecwe qee!’ odi madoqagan. Qeefi, king oso uqana han dana 10,000ca king osoca cadowasa lifei ge king eu uqa han dana 20,000ca uqaca hoqagan eu uqa casac bilimei uqa cadigiannu gagadic odoc ihocfo? ec cisdugian. Uqa ihoc qeefi uqana dana sos suladeceb belimeig king oso eu ceguldumeig saen uqa jic onoca bibileb malol bilecnu cahacdoc je madoqagan. Eunu oso uqa ija tootecnu ijaca honafiqa uqa anag memegca, uqa aideg, melahul, waliagul, cebinagulca, odocob uqadodoc cebac bilec euca qee sagagadena eu uqa ijana malogom bilecwe qee. Odocob oso uqanagul na babalec gahidu ija tooti cobocnu culinafi eu uqa ijana malogom bilecwe qee,” aden. ");
INSERT INTO aey_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Odimei Jisas cit qu maaden, “Jic eu odi nijia eunu age cunug agena ceteteh cunug qee hibemdufeig age ijana malogom bilecwe qee,” aden. ");
INSERT INTO aey_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jisas je haun maaden, “Macas eu me bahic qa uqana tin tebandoc eu qee mecebfi age adi uqana tin tebandoc weledec eu haun muduqagan? ");
INSERT INTO aey_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Eu mahaca, dool bujec euca gabandumeig cabina mecnu ihoc qee. Eu helecebil nuina. Oso dahigca uqa je i dah meiale,” aden. ");
INSERT INTO aey_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Saen osona takis cedec dana silail danaca Jisas dah muduqaga bili geh bahic cegulimeig Jisas talildoin. ");
INSERT INTO aey_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Odocob Farisica loo je iwaladec danaca age galac mumudi madein, “Dana i silail dana maadeceb hocobil uqa gami ha sab jegina!” ein. ");
INSERT INTO aey_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Eunu Jisas uqa galolo je i maaden, ");
INSERT INTO aey_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Age dana oso uqana sipsip 100 cobogina eundec osol jahunigian uqa adi odigian? Uqa sipsip 99 eu maha wadauna culadeceb tatawebil jahunen eu waligian. Uqa wawali li gulucdugian. ");
INSERT INTO aey_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Uqa gulucdumei uqa ceelec ben bahiccanu qatona migian. ");
INSERT INTO aey_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Odimei gahidu jobon ehi nuigian. Odimei uqa uqana danahdanahca, uqa utuqanel bilegina euca age maadeceb cegulecebil maadigian, ‘Ijana sipsip jahunen ija gulucduga celebo bahic igina. Eunu ege celeboii sab nag odi cilecnu!’ adigian. ");
INSERT INTO aey_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ija maadigina, eu odiwe, sao jobonna ono silail dana osol uqa silailnu tului falicdona eunu age celebooqagan. Odocob agena celeboec eu 99 age ititom ihoc age silailnadec haun falicdocnu qee nijelnu celeboec wooldugian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jisas je haun maaden, “Odi ha caja oso uqa meen qaig silwana mudec 10-pela hewena qa osol jahunifei uqa adi odigian? Uqa gowoc madacdumei bahim cabal sigeldumei odocob meciii cuhadudu cudun cunugna meciii fifi li gulucdugian. ");
INSERT INTO aey_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Saen uqa gulucdumei uqana danahdanahca, uqa utuqanel bilegina euca maadeceb cegulecebil maadigian, ‘Ija meen qaig jahunen haun gulucduga ceeligina. Eunu ceelii sab nag odi cilecnu!’ adigian. ");
INSERT INTO aey_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ija maadigina, eu odiwe Anutna ensel age silail dana osol uqana silailnu tului falicdonanu agena gemona ceelec ben calena,” aden. ");
INSERT INTO aey_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas mamadi maaden, “Dana oso biloloi. Uqa melahul lecisca. ");
INSERT INTO aey_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Milum uqa cajimei memeg madon, ‘O Mei, qila hina cehewain naha cesawitaga ijana itiga,’ don. Eunu dana eu cehewan melahul lecisca odi cesawialen. ");
INSERT INTO aey_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hibna deel leih hedocob melah milum eu uqa cehewan naha suldodoi meen qaig umei jobon cuculi nuen. Odocob uqa hatu onoca bahic nuen. Ono uqa wal kobol mati odon. Euna uqa meen qaig uqana bilec me qeena cunug qee muden. ");
INSERT INTO aey_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Uqana meen qaig cunug qee muden. Oodon hatu eu sabnu cahel ben qoc sanan men. Odocob uqa cetetehca qee bahic bilen. ");
INSERT INTO aey_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Eunu uqa li hatu eunadec dana osona cabi on. Suldocob nui uqana ho cofadoloi. ");
INSERT INTO aey_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Uqa ho agena sab macin ganac eu jigiannu waug ben bahic nijoloi qa sab jecnu oso qee utoloi. ");
INSERT INTO aey_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Odocob hibna uqa cahuldoc odon ec fogo docob maden, ‘Ija meina cabi dana agena sab ji hedocwe qee. Odocob ene ija wennu cal migen odigina! ");
INSERT INTO aey_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ija caji nuimig mei madugen, “O Mei, ija Anut hinaca amalana silail mem. ");
INSERT INTO aey_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ija hina melem eu odi bilecwe qee. Eunu cois hinana cabi dana odi cabi ugen,” dugen,’ en. ");
INSERT INTO aey_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Eunu uqa cajimei memegca ceseli nuen,” aden. “Odocob uqa onoca hohon memeg fen. Fimei uqa waug qocob ceelen. Odimei uqa gudugudui nui melah colowandumei cotdon. ");
INSERT INTO aey_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Odocob melah madon, ‘O Mei, ija hina amennaca, Anut amegnaca silail mem. Ija hina melem eu odi bilecnu ihoc qee,’ don. ");
INSERT INTO aey_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","Euqa memeg uqana cabi dana utaadeceb hoin. Odi maaden, ‘Ija melami i cal menwe qa qila haun cebac bilia. Uqa jahunen qa qila haun gulucdoqa! Eunu mahuc bahic, lotoc me bahic oso u ahumeig tacitoiga. Sai ebenna mimeig jaih tacec u ahu tacitoiga. Odimeig bulmakau nag lalo cacawacca taweia eu ahewi ahumeig qagadoiga. Odocob ege feele ec sab cili jimeb celebooqale!’ aden. Eunu age sab ben bahic cicileig celeboecnu sanan mein,” aden. ");
INSERT INTO aey_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Saen euna age odi oodogin melah matu uqa cabina bilen. Odimei uqa cabinadec ceceseli jic sahu jo cemenug huhu ududu duduegin dah men. ");
INSERT INTO aey_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Odimei uqa cabi dana oso utadocob hocob sisildon, ‘Eu cel odogina?’ don. ");
INSERT INTO aey_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Odocob cabi dana jejeg hewi madon, ‘Hina walin haun jobon ceseli hoia. Odocob hina memen uqa melah me bahic uqaca hu caleia eunu bulmakau nag lalo cacawacca taweia eu qagadoia,’ don. ");
INSERT INTO aey_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Odocob waliag matu eu gemag gagadic beceb jo hamol lecnu qee gale dol. Eunu memeg jonadec humei melah dunuh ligiannu ninidon. ");
INSERT INTO aey_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Euqa uqa memeg madon, ‘Faga, cabi gel i cunugca ija hinanu cabi uu begabeg meh cinigwe hom. Odocob ija hinana je qee felaculdolig. Hina cel oso item? Mecmec osoha cilecnu qee itecem sab ijana danah gami celeboelem! ");
INSERT INTO aey_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Euqa hina melem i hinana meen qaig cunug wal caja fajadecna cusdon. Odocob saen uqa ceseli hocob hina bulmakau nag lalo cacawacca eu qagadumeg cilitoga!’ don. ");
INSERT INTO aey_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Odocob memeg jejeg hewi madon, ‘Melami, hina saen cunug ijaca biluwuna. Odocob ceteteh cunug ijana eu hinana. ");
INSERT INTO aey_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Euqa hina walin eu cal menwe qa qila uqa cebac bilia. Uqa jahunen qa qila uqa haun gulucduga. Eunu ege sab cilimeb celebooqona eu tutuc,’ don,” aden. ");
INSERT INTO aey_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Odocob Jisas uqana malogom maaden, “Dana cehewanca uqa cehewan cofdocnu dana osoca. Odocob age dana cehewanca madoin, ‘Hinana cofdoc dana uqa hina cehewain cusdona,’ doin. ");
INSERT INTO aey_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Odocob uqa utadocob leceb madon, ‘Eu cel je ija hinanu dah miga? Hina ija cehewani cofdoc dana haun qee biligaun. Eunu hina ija cehewani adi cofdogona eu jaqimeg itiga,’ don. ");
INSERT INTO aey_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Odocob cabi dana eu uqadodocnu maden, ‘Ijana meca ijana cabinadec qee mitigian. Ija eeta odigen? Ija maha hunecnu cabi ocnu gagadic odocca qee. Odocob ija dana ceteh iteiga ec niniadecnu majanica. ");
INSERT INTO aey_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ija eeta odigen eu qila dugina! Ija ijadodocnu danah madigen. Eunu ijana meca ijana cabinadec qee mitigian saen euna ija ijana danah age agena jobonna ehiti loqagan,’ en. ");
INSERT INTO aey_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Eunu uqa dana cunug dana cehewanca euna ceteteh suldogina uqanu wadacdutocnu bilegina eu age maadeceb cegulein. Odocob uqa dana oso sisildon, ‘Hina ganic bahic ijana meca wadacdoc utugan?’ don. ");
INSERT INTO aey_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Odocob uqa jejeg hewi madon, ‘Mool dram 100 gadac,’ don. Odocob cehewan cofdoc dana eu uqa madon, ‘Hinana meen qaig hahun ihec. Bilimeg mahuc 50 jaqaga,’ don. ");
INSERT INTO aey_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Odocob uqa haun oso sisildon, ‘Odocob hina ganic wadacdoc utugan?’ don. Odocob uqa jejeg hewi madon, ‘Wit bek 100 gadac,’ don. Odocob cabi cofdoc dana madon, ‘Hinana meen qaig hahun ihec. Euna 80 jaqaga,’ don. ");
INSERT INTO aey_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Dana maha inadec age agedodocnu cabi ocobocobecnu du cuhadogina qa dana fulacdocnadec age agedodocnu cabi maha inadec odocnu qee du cuhadogina. Hibna dana cehewanca uqa uqana cabi dana odi odonnu don. Eunu uqa binan sulen,” aden. ");
INSERT INTO aey_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Odimei Jisas madimei maaden, “Odocob ija maadigina, agedodocnu maha ina cehewan me qee euna danah meiga. Eunu cehewan hewecnu saen eu qee meceb age ehadecebil age bileceb catanec jobon euna loqagan. ");
INSERT INTO aey_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Oso uqa cehewan nagnag cofdu cuhadona uqa cehewan benben ha cofdu cuhadugian. Odocob oso uqa cehewan nagnag uhuli cofdona uqa cehewan benben ha uhuli cofdugian. ");
INSERT INTO aey_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Age maha ina cehewanaga me qee eu qee cofdu cuhadufeig age cehewanaga mele bahic eu adi cofdoqagan? ");
INSERT INTO aey_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Odocob age oso cehewan qee cofdu cuhadocobilfi in uqa age cehewanaga eu adigian?” aden. ");
INSERT INTO aey_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Cabi dana oso uqa dana ben lecis alena cabi ocwe qee. Ge, uqa oso sagagduduqa osonu nalug migian. Qeefi, uqa osonu waug nijigian qa oso cewudigian. Odiwe ha age Anutca maha cehewanca alena tibud mumudi osoben cabi u calecnu qee nijel,” aden. ");
INSERT INTO aey_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Odocob Farisi age meen qaig gale ben aden eu age Jisasna je eu cunug dah mein. Odocob age Jisasnu udoc je madein. ");
INSERT INTO aey_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Odocob Jisas maaden, “Dana ceteh binanca ec cisdogina qa Anut uqa fena eu ceteh bebesacca. Eunu agedodoc age dana amagana meciadegina eu age ititom ec egina qa Anut age wawagana cisdogina eu uqa dona,” aden. ");
INSERT INTO aey_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mosesna loo jeca, je hahun madec dana agena jaqec jeca bibili hu Wa Joadec Jon uqana saenna Anutna je himec bilen. Eunadec sanan men eu Anutna culnu me je sildiadecnu cali hon. Odocob dana cajaca cunug age euna sundu lecnu odogina. ");
INSERT INTO aey_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sao mahaca eu qee mecnu ihoc nijina, euqa loo je jaqec je nag bahic eu oso qee mecnu ihoc qee nijina,” aden. ");
INSERT INTO aey_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jisas je haun maaden, “Dana oso uqa aideg culdi caja haun oso ona eu dana caja sisi jelec wagalimei uqa aideg wal kobol odudina. Odocob dana oso uqa caja oso gemug culden ona uqaha dana caja sisi jelec wagalimei wal kobol odona,” aden. ");
INSERT INTO aey_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisas je haun maaden, “Dana oso uqa cehewan gehca biloloi. Uqa lotoc meen qaig benbennadec himec tacoloi. Lotoc eu golca sosologca. Odocob uqa deel cunug uqana bilec eu me bahic. Sab me bahic joloi. ");
INSERT INTO aey_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Saen euna sawen dana oso, uqa ijan Lasaras, ha biloloi. Uqa isoh deweg ganacna cunug ihoc len. Uqana sawen danah age ehudi dana cehewanca euna gel cebecna ahocobil biloloi. ");
INSERT INTO aey_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sab susul dana cehewanca eu jiji culeceb jec cabalna tonoloi eu jigiannu ehudi ehitocnu cisdoloi. Odocob qa ageha humeig isoh beluhdoloig. ");
INSERT INTO aey_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Odocob hibna sawen dana eu cal meceb ensel gahidu ehi li Ebraham cemenugna mudein. Odocob dana cehewanca euha cal meceb heel cisein. ");
INSERT INTO aey_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Uqa deweg dain tebandudu oloqanihna bilen. Odocob uqa mecieceb ti Ebraham onoca bibilen fen eu Lasaras cemenugna bibilen. ");
INSERT INTO aey_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Eunu uqa utai madon, ‘O Mei, Ebraham! Ija ja ben inu gisi cagugina! Ijanu waloc heceb Lasaras suldocom ni wa eben mamogna tanumei beilami qududocob daeia,’ don. ");
INSERT INTO aey_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Euqa Ebraham madon, ‘Melami, cisdoga, hinana cebac bilec saenna hina ceteteh meme cunug cedem. Odocob Lasaras ceteteh me qee ceden qa qila uqa ene ceelii bilia. Oodon hina ono gisi cacagu biliga. ");
INSERT INTO aey_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Odocob leih age enedec ono hinaca egeca leti loqaganfi ihoc qee o leih age onodec ene leti hoqaganfi ageha ihoc qee, eunu maha heel dunuh bagalanca bahic gemo nijia,’ don. ");
INSERT INTO aey_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Odocob dana cehewanca madon, ‘O Mei, ono ija waliel 5-pela bileiga. Lasaras culdecem uqa nuimei ulauladec je ija odom eunu maadigian. Eunu ija ninihigina, ageha cudun dewenega dain tebandocna ene cain howainnu Lasaras suldocom ija meina jona leiale,’ don. ");
INSERT INTO aey_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Odocob Ebraham madon, ‘Hina walinel age Mosesna loo jeca, je hahun madec dana agena jaqec jeca ulauladec jenu eu bilia. Hina walinel culadecem age eu dah moqagan,’ don. ");
INSERT INTO aey_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Odocob dana cehewanca jejeg hewi madon, ‘O Mei Ebraham, eu himec ihoc qee! Euqa oso uqa cal mecnadec ceseli cajimei eu ageca lifei wawaga meleigian. Odocob agena silailnu tului falicdoqagan,’ don. ");
INSERT INTO aey_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Euqa Ebraham madon, ‘Age Mosesna loo jeca, je hahun madec dana agena jaqec jeca maadecebilfi wawaga qee meleel. Eunu dana oso cal mecnadec ceseli cajimei li maadecebfi ha wawaga qee meleeiaun,’ don,” aden. ");
INSERT INTO aey_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Odocob Jisas uqa uqana malogom maaden, “Ceteteh dana odadecebil silail megina eu gaid hogina qa dana eu uqa odadeceb age silail meginanu uqa walocca biligian! ");
INSERT INTO aey_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Uqa mel sim i eundec oso odudeceb silail migiaqa eu meen culumenca bena qagi macas ameg nijia euna age helecebil wa jimei cal moubmi eu me odoub. ");
INSERT INTO aey_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Agedodocnu cofdoiga!” aden. “Hina cotin silail mecebfi cahacdu madoga. Odocob uqana silailnu tului falicdocobfi uqana odoc eunu dahin celeia. ");
INSERT INTO aey_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Uqa hinanu silail mi 7-peladumei deel osolna odocob eu saen cunug odi odona hinaca humei mahifei, ‘Ija ijana silailnu tului falicduga,’ hifei hinaha eunu cunug dahin celeia,” aden. ");
INSERT INTO aey_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Odocob aposel age Tibud madoin, “Ege cesulgecem egena wawige meleec meca mi dugian,” doin. ");
INSERT INTO aey_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Odocob Tibud uqa jejenega hewi maaden, “Age wawaga meleec uqana meca eu aig mastet cinigwefi na sikamoa i madoubmiqa, ‘Hinadodoc cacalimeg bebeig cunugca nui macasna limeg cehaga!’ doubmiqa odocob uqa conoga toodu odoub,” aden. ");
INSERT INTO aey_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jisas je haun maaden, “Age oso uqana cabi dana madocob uqa maha ulam onafo, qee madocob sipsip cofadena eu saen uqa cabi cudunnadec ceseli hocob age madoginafo? ‘Mahuc li sab jaga,’ doginafo? ");
INSERT INTO aey_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Qee bahic! Euqa age madogina, ‘Ija wesu sab jec saciadutaga. Odimeg sab cewel ocnu lotoc tacimeg sab qaditecem ija sab wa gabca ji hedocomin hina jegan,’ dogina. ");
INSERT INTO aey_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Cabi dana uqa je toodu cabi onanu hetaga doc madoginafo? Qeeo! Qee madogina. ");
INSERT INTO aey_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ageha eu odi himec. Saen age ceteh odoqagannu maadecebil je toodu odimeig madeiga, ‘Ege cabi dana ameg me ocnu ihoc qee nijel. Ege egena cabi mugumige mec himec odom,’ eiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Odocob Jisas uqana jic qaqahi Jerusalem nunui uqa Sameria hatuca, Galili hatuca gemogemo nuen. ");
INSERT INTO aey_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Odi nuimei uqa jobon gemo lili cobocob dana 10-pela lepra hagca gulucdoin. Age nag onoca tawein. ");
INSERT INTO aey_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tataweig utai madoin, “O Jisas, Ben! Egenu walol heia!” doin. ");
INSERT INTO aey_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Odocob Jisas meciadimei maaden, “Nuimeig nawel tawec ihanec dana age dewenega eu ihacadecebil meciadeiga,” aden. Odocob jic sahu bebelegin agena hag cunug qee men. ");
INSERT INTO aey_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Odocob age oso uqana hag me mudeceb fimei utai Anut binan susulei ceseli hon. ");
INSERT INTO aey_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Humei uqadodoc Jisas jaihna toni mahulimei hetaga don. Dana eu uqa Sameriadec. ");
INSERT INTO aey_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Odocob Jisas maden, “Dana 10-pela agena hagnadec me meiga. Dana 9-pela eu age ana? ");
INSERT INTO aey_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Eu eetanu cele dana i uqadih Anut hetaga dugia ceseli hoia?” en. ");
INSERT INTO aey_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Odocob Jisas dana eu madon, “Cajimeg nuuga. Hinana wawin meleec eu hag me mudihia,” don. ");
INSERT INTO aey_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Odocob Farisi leih age Jisas Anutna cul cel saen hugian ec sisildoin. Odocob Jisas uqa jejenega hewi maaden, “Anutna cul edi hohob qee fowain. ");
INSERT INTO aey_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Oso madigian, ‘Feiga, ihec hona!’ igianfo, qee oso madigian, ‘Euhec hona!’ igian eu ihoc qee. Gec feiga, Anutna cul eu age gemo bilia,” aden. ");
INSERT INTO aey_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Odimei uqana malogom maaden, “Saen hugian eu saen age Dana Melah uqa mahana cobocna deel oso fecnu hooloqagan qa age deel eu qee fowain. ");
INSERT INTO aey_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","24","Leih ha maadoqagan, ‘Feiga, euhec hona!’ adoqagan. Odocob leih maadoqagan, ‘Feiga, ihec hona!’ adoqagan. Euqa amel faleimei sao nahadec naha fulacdu ehi tenawe Dana Melah uqana deelna odi camas migian. Eunu age cain tooadi cobowain. ");
INSERT INTO aey_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Euqa casac Dana Melah uqa deweg dain doc ben bahic ugian. Odocob dana cajaca qila bilegina eu age uqa hibemdoqagan. ");
INSERT INTO aey_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noa bilen saenna dana cajaca bileinwe Dana Melah uqana saenna odi ha biluqagan. ");
INSERT INTO aey_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Saen euna dana cajaca age sab ji wain ji bibilegin dana caja ocobocobi bibilegin leceb Noa wag benna tobec deelna odi odoin, odocob wa sil cajimei cunug fadaladen. ");
INSERT INTO aey_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Eu odiweha Lotna saenna age bileinwe age odi biluqagan. Lotna saenna dana cajaca age sab wainca jiji bibileig ceteteh fafajeig suldodoig sab ceceheig jo ceceheig bilein. ");
INSERT INTO aey_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Euqa deel Lot Sodom culaden euna ja meen jan dainca sao jobondec nimei dana cajaca cunug fadaladen. ");
INSERT INTO aey_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Eu odiwe Dana Melahna camas mec deelna eu odi caligian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Deel euna dana oso uqa jo tatacan tataweb uqana ceteteh jo dunuh ninijeb uqa toni numei uqana ceteteh cain cedeiaun. Eu odiha dana oso cabina cocobob saen euna uqa haun jona cain ceseleiaun. ");
INSERT INTO aey_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Age Lot aidegnu cisdoiga. ");
INSERT INTO aey_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Oso uqa uqana cebac bilec sosogon ona eu uqa uqana cebac bilec felacudigian. Oso uqa uqana cebac bilec felacudecebfi eu uqana cebac bilec hewigian. ");
INSERT INTO aey_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ija maadigina, witic euna dana lecis ale cabal osolna us nijuwasan. Oso ehudi beloqagan, oso eu tacewudoqagan. ");
INSERT INTO aey_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Caja lecis ale wit meenna ibuldudu biluwasan. Oso ehudi beloqagan, oso tacewudoqagan,” aden. Dana lecis ale cabina sab cehowasan. Oso ehudi beloqagan, oso tacewudoqagan. ");
INSERT INTO aey_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Odocob malogom sisildoin, “Tibud, ceteh i ana caligian?” doin. Odocob Jisas galolo je i jejenega hewi maaden, “Dana cal mec deweg ganac huluec oso ninijen man fululec benben cababac cinigwe age euna ceguluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Odimei Jisas galolo je i gaid saen cunugna inondoqagannuca, cain dumanaga culiaunnuca iwaladecnu maaden, ");
INSERT INTO aey_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Je gesilec dana oso uqa taun ben osona biloloi. Uqa Anut qee cucuidoloi. Uqa dana cunug mahanadecha cewadoloi. ");
INSERT INTO aey_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Odocob caja wij oso uqaha taun eunadih biloloi. Uqa je gesilec dana euca uqa gaid huhuoloi. Uqa gaid inondudu madoloi, ‘Ijana cadnu gesillec saenna cesultaga!’ doloi. ");
INSERT INTO aey_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Saen cecelac bahic je gesilec dana uqa cesuldocnu qee cisdoloi qa hibna uqadodoc maden, ‘Ija Anut qee cucuidugina. Dana cunugha cewadigina ");
INSERT INTO aey_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","qa caja wij i culumen cunug itina eunu ija cesuldugen. Qeefi, uqa odi dih oodob deweni cunug alal doiaundain!’ en,” aden. ");
INSERT INTO aey_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Odocob Tibud uqa je tubdu maaden, “Je gesilec dana me qee je maden eu dah meiga. ");
INSERT INTO aey_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eunu Anut uqana dana cajaca nesili cedaden eu agena culumennu cesuladigiannu witic cahinegca qajudegina eu mahuc bahic cesuladena ec age mele dogina. Uqa qee daleeiaun. ");
INSERT INTO aey_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ija maadigina, uqa agena culumennu cesuladigian. Odocob uqa mahuc bahic cesuladigian qa Dana Melah uqa camas mec saenna mahana nimei wawaga meleec gulucdugianfa?” aden. ");
INSERT INTO aey_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Odocob Jisas galolo je osoha dana age ija dana ititom bahic ec cisdodoig agedodoc binanaga susuleig dana cunug cewadegina eundec maaden, ");
INSERT INTO aey_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Dana lecis tempelna inondowasannu tesin. Oso uqa Farisi dana. Oso uqa takis cedec dana. ");
INSERT INTO aey_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Odocob Farisi uqa cuhanuc tatawi inondudu maden, ‘Dana cunug odogina ija odi qee odigina eunu Anut ija hetaga higina. Age cunug culunuga qanfo, ititom qeefo, age dana oso uqa aideg oginafo eu odi. Ija takis cedec dana i bilina cinigwe qee eunu hetaga higina. ");
INSERT INTO aey_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ija cuha cunugna deel lecis cud biligina. Odocob ija meen qaig cunug ugina eu am 10-pela qatanimig osol hinana cabinu migina,’ don. ");
INSERT INTO aey_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Euqa takis cedec dana eu onoca tawimei sao jobon ha ola suli u tatiecwe qee qa uqa muguhna eben foidudu madon, ‘O Anut, ija silail dana! Ijanu walol heia,’ don,” aden. ");
INSERT INTO aey_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Odocob Jisas maaden, “Ija maadigina, oso uqa culai ijanel lalan mumudi bilina euqa Anut uqa dana eu cilehdugian. Oso uqadodoc jogoi waug lal qocca bilina eu Anut uqa dana eu culaug u lalan mumudeb biligian. Eunu takis cedec dana iqa uqa mele bahic Anut amegna ititom bibilen jona nuen, oso eu qee,” aden. ");
INSERT INTO aey_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Odocob dana caja leih age Jisas uqa eben agena mel sim ilomogana migiannu uqaca ehi lein. Euqa malogom meciadimeig age gagalaadi cahacadein. ");
INSERT INTO aey_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Euqa Jisas mel sim utaadeceb uqaca lein. Odocob maaden, “Mel sim eundecnu Anutna cul muden nijiado. Eunu cain cahacadowain. Culadecebil mel sim age ijaca hoigale. ");
INSERT INTO aey_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ija mele maadigina, oso uqa mel sim Anutna cul ona eu odiwe qee ona eu Anutna culna qee leiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Odocob Juda dana agena ilo oso uqa Jisas sisildon, “O Iwalgec Me, cebac bilec catanec eu mugumi ocnu ija eeta odigen?” don. ");
INSERT INTO aey_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Odocob Jisas madon, “Eetanu ija me taga? Dana cunug me qee. Anut himec uqa me bilina. ");
INSERT INTO aey_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Hina Mosesna loo jena eu dogona: ‘Dana dana cajaca dewenela osol mec cain cagualegaun. Oso cain qagadogaun. Oso uqana ceteteh cain heje cedagaun. Oso uqanu uhulec je cain madagaun. Hina anin memenca lalan malagale,’ ena,” don. ");
INSERT INTO aey_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Odocob dana eu uqa Jisas madon, “Ija simnadec cocobi Mosesna loo je eu cunug toodu odom,” don. ");
INSERT INTO aey_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Saen Jisas eu dah mimei dana eu madon, “Hinana odoc ihoc ligiannu odoc oso qee odolom eu odogale. Hina nuimeg hina cehewain cunug idadumeg meen qaig eunadec umeg dana sawen eundec siwiadagale. Odi odimeg hina sao jobon ono cehewainca bilegan. Odimeg hu ija tootagale,” don. ");
INSERT INTO aey_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Euqa dana eu cehewanca bahic eunu uqa je eu dumei waug me qee bahic men. ");
INSERT INTO aey_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","25","Odocob Jisas dana eu waug me qee meceb fimei maden, “Kamel lotoc gisec cese gigilona isec li nuecnu cacanigca, euqa dana cehewanca eu Anutna cul dunuh lecnu cacanigca eu wooldoc bahic. Eunu dana cehewanagaca eundec age Anutna cul dunuh loqagannu eu cacanigca bahic!” aden. ");
INSERT INTO aey_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Odocob dana dah mudein eundec sisildoin, “Mele odi nijecebfi oso cahahadocnu eu adi?” doin. ");
INSERT INTO aey_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Odocob Jisas jejenega hewi maaden, “Dana age odi odocnu qee nijel. Eu Anut ihoc odigian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Odocob Pita madon, “Faga, ege egena jobon culdimeb hina toohi coboqona,” don. ");
INSERT INTO aey_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Odocob Jisas maaden, “Ija mele maadigina, oso uqa Anutna culnu jobonfo, aidegfo, waliagulfo, memeg anagfo, talaculfo culina ");
INSERT INTO aey_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","uqa maha ina bibili ceteteh mecaca ugian. Odocob uqa saen hibna hugian euna cebac bileceb catanec ha ugian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","33","Odocob Jisas uqana malogom 12-pela gesacna cedi ehi limei maaden, “Feiga, ege Jerusalem toqona. Age ono Dana Melah Juda dana qee eundec ebenegana muduqagan. Odocobil age uqa lelandumeig je me qee madumeig cin qudoqagan. Odimeig age uqa qisadumeig qocobil cal migian qa deel cijeddocna haun ceseli cajigian. Eunu Jerusalem ono je hahun madec dana age Dana Melahnu je jaqein eu cunug ihoc ligian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Euqa malogom ceteh eunu agena cisdoc qee fogo dol. Je gug eu cunug eu jahunec bilen. Odocob age Jisas je maden eunu qee doloin. ");
INSERT INTO aey_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Odocob Jisas uqa Jeriko taun dodoldodon ameg galuc mec dana oso uqa sabnu cesuldoqagannu niniaadi bilei jic gesacna bilen. ");
INSERT INTO aey_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Uqa dana cajaca mati bahic wooldodogin dah mimei sisiladen, “I cel?” aden. ");
INSERT INTO aey_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Odocob age madoin, “Jisas Nasaretdec woolhi nuina,” doin. ");
INSERT INTO aey_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Odocob uqa utai madon, “Jisas, Dewid Melah, ijanu walol heiale!” don. ");
INSERT INTO aey_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Odocob dana cajaca aquni tawein eu age gagaladudu madoin, “Cain utaagaun. Culugale,” doin. Euqa uqa feeaadi co suli u haun utai madon, “O Dewid Melah, ijanu walol heia!” don. ");
INSERT INTO aey_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jisas tului tawimei dana ameg galuc mec eu uqa cemenug ehi loqagannu gagadic maaden. Dana ameg galuc mec eu uqa cemenug hocob Jisas sisildon, ");
INSERT INTO aey_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ija hina eeta odihigennu cisdogona?” don. Odocob uqa jejeg hewi madon, “O Tibud, ija ceteh fecnu madigina,” don. ");
INSERT INTO aey_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Odocob Jisas madon, “Hina wawin meleec eu me mihia. Meciaga!” don. ");
INSERT INTO aey_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Odocob dana eu mahuc bahic ameg fogo docob uqa ceteteh cunug fen. Odimei Anut hetaga dudu Jisas toodon. Dana cajaca eu fimeig age cunug Anut binan sulein. ");
INSERT INTO aey_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Odocob Jisas Jeriko taun limei gemogemo nuen. ");
INSERT INTO aey_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ono takis cedec dana agena ilo biloloi. Uqa ijan Sakias. Uqa cehewanca. ");
INSERT INTO aey_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Uqa Jisas cel dana adec eu figia oodon qa uqa dana gohic. Eunu dana amha ceguleinnu Jisas fecwe qee. ");
INSERT INTO aey_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Eunu uqa aquni guguli nuimei na sikamoa oso Jisas eusec ligian ec dumei figiannu tobon. ");
INSERT INTO aey_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Odocob Jisas cudun euna limei mecieceb na ohis teceb Sakias fimei madon, “Sakias ija qila hina naguc nijigen. Eunu mahuc tonoga,” don. ");
INSERT INTO aey_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Odocob Sakias mahucwe tonimei waug ceelecca Jisas ehuden. ");
INSERT INTO aey_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Odocob cunug fein eundec age gonagona mimeig madein, “Dana i silail danana jona nijoug nijecnu leia!” ein. ");
INSERT INTO aey_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Odocob Sakias caji tawimei Tibud madon, “O Tibud, dah maga! Ija cehewani gemo cesawimig naha sawen adigen. Odocob ija oso uhuldomfi eu odi meen qaig eu sanijec 4-peladoc wadacdugen,” don. ");
INSERT INTO aey_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Odocob Jisas madon, “Dana Melah uqa fadaladigiannu bilein eundec waladi cahahaadecnu nen. Eunu dana iha uqa Ebrahamna sihulnadecnu qila Anut uqa dana cajaca age jo ina bilegina eu cahahaadeia,” don. ");
INSERT INTO aey_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dana eu dah memegin Jisas uqa Jerusalem wele cemenug mumuden age Anutna cul nag odi camas migian ec cisdoinnu uqa tubdu galolo je maaden. ");
INSERT INTO aey_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Eunu uqa maaden, “Dana oso uqa ijan benca uqa hatu onoca uqa king caligiannuca, uqa hibna uqana hatu king bilecnu ceseligiannuca nuen. ");
INSERT INTO aey_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Uqa culadi nuigia bili uqana cabi dana 10-pela cunugca utaadeceb cegulecebil uqa kina 20 20 cunug filfil aden. Odimei maaden, ‘Age meen qaig ina idadeebil leceb ija isi ceseli humig figen,’ aden. ");
INSERT INTO aey_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Odonqa dana age uqana hatunadec age dana ijan bencanu gemanaga beceb sagagdoin. Eunu age sos dana uqa eu agena king bilecnu culadoqa ec madoqaga bili suladecebil hib toodoin,” aden. ");
INSERT INTO aey_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Odocob dana ijan benca king mudecebil ceselen. Odocob uqana cabi dana meen qaig aden eu age meen qaig eunadec agena idadecna meen qaig haun ganic calen eu dugiannu je gagadic maadeceb uqa amegna osolosol lein. ");
INSERT INTO aey_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Odocob dana aqunecna tawen eu limei madon, ‘Meca fagale, hina kina 20 item ija meen qaig euna idadecemin kina 200 haun mudem,’ don. ");
INSERT INTO aey_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Odocob uqa madon, ‘Hina cabi dana me bahic! Hina cabi oc nag me cofdoga eunu taun ben 10-pela cunugca cofdoc dana mihigen,’ don. ");
INSERT INTO aey_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Odocob cabi dana lecisdoc len eu madon, ‘Meca fagale, hina kina 20 item ija meen qaig euna idadecemin kina 100 haun mudem,’ don. ");
INSERT INTO aey_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Odocob eu uqa madon, ‘Hina taun ben 5-pela cunugca cofdogan,’ don. ");
INSERT INTO aey_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Odocob cabi dana oso eu limei madon, ‘Meca, kina 20 item ihec. Hina dana gemainca bahic eunu ija hinanu cucuiem. Hina ceteh ocnu qee cabi ogona eu ogona. Odimeg ceteh hina qee cehagana eu jagana. Eunu hinana meen qaig eu musul cacoc lotoc nagna ija jahunem,’ don. ");
INSERT INTO aey_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Odocob uqa madon, ‘Hina cabi dana me qee! Hinana je euna gesilihigen. Ija dana gemanica, ija ceteh ocnu qee cabi ugina eu ugina odocob ceteh ija qee cehigina eu jigina ec dogona. ");
INSERT INTO aey_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Eunu eetanu ijana meen qaig eu qaig mec jona qee melem? Odocob ija ceseli humig meen qaig nag haun sabijeceb ceseli cedoum,’ don. ");
INSERT INTO aey_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Odimei uqa leih ono tawein eu age maaden, ‘Uqana kina 20 cawaldumeig uqana kina 200 nijen uteigale,’ aden. ");
INSERT INTO aey_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Odocob eu age madoin, ‘Meca, uqa kina 200 wele oia!’ doin. ");
INSERT INTO aey_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Odocob uqa jejenega hewi maaden, ‘Ija maadigina, cunug age cetehca bilegina eu Anut uqa ceteh haun adigian. Euqa oso uqa cetehca qee bilina eu Anut uqa uqana nag nijia eu cawaldugian. ");
INSERT INTO aey_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Odocob qila ijana cad i agenu age ija agena king bilec culadein eu ene cedi ahumeig ija olanina qagaadeiga!’ aden,” aden. ");
INSERT INTO aey_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas odi maadimei cuculadi uqa aquni Jerusalem ono ten. ");
INSERT INTO aey_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tetei uqa Betfasi Betanica jobon dodolaalei Oliw Aluhna ono malogom lecis sulaleceb aqunimesi ");
INSERT INTO aey_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","maalen, “Jobon amigena nijia euna lesia. Ale dunuh lelesi cesel goman manahal oso qagec tataweb gulucdowasan. Cesel eu dana oso tatacan qee bilel. Ale eu cufalimesi ehudi ene ahosiale. ");
INSERT INTO aey_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Dana oso sisilalecebfi, ‘Eetanu cufalesina?’ alecebfi madowasan, ‘Tibud cesel eu ocnu eu cabi osoca madena,’ dowasan,” alen. Odimei sulaleceb belesin. ");
INSERT INTO aey_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Eu ale jic toodu belimesi ceteh cunug Jisas maalen odi gulucdosin. ");
INSERT INTO aey_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ale cesel goman manahal eu cucufalesin uqana cofdoc hu sisilalein, “Eetanu cesel goman manahal eu cufalesina?” alein. ");
INSERT INTO aey_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Odocob ale jejenega hewi maadesin, “Tibud uqa cesel eu ocnu eu cabi osoca madena,” adesin. ");
INSERT INTO aey_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Odimesi cesel goman manahal eu Jisas ehi litosin. Odocob alena lotoc dool gogodohna mimesi Jisas cesuldodosin tobi gogodohna bilen. ");
INSERT INTO aey_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Uqa cesel goman manahal gogodohna bibili nunuen eu age agena lotoc duitotogin eu lalagan nuen. ");
INSERT INTO aey_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Odimei uqa Jerusalem cemenug lelen jic Oliw Aluh gololecna ono uqana malogom mati bahic Anut kobolkobol odoc odocob amagana feinnu celeboeeig binan susuli ooig jejenega suli uutai madein: ");
INSERT INTO aey_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“King uqa Tibud ijanna hona Anut eeldoiale! Sao jobonna malol biliale! Anut ohis bilina uqa kobolkobolca biliale!” ein. ");
INSERT INTO aey_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Oodogin Farisi leih am ben dunuh eunadec Jisas madoin, “Iwalgec, hinana malogom cahacadecem tilieiga!” doin. ");
INSERT INTO aey_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Odocob Jisas jejenega hewi maaden, “Ija maadigina, eu age tiliecebilfi meen agedodoc sanan mi utaoqagan!” aden. ");
INSERT INTO aey_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Odocob uqa Jerusalem cudun ben eu cemenug bahic mudimei ameg mudeceb leceb fimei uqanu qajen. ");
INSERT INTO aey_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","44","Odimei maden, “Hina qila himec cel odimeg malol biligina ec doummi eu me bahic! Euqa hina Anut cahahahigiannu hon saen eunu qee dolom. Eunu qila hina jic malol fecwe qee. Odocob saen caleceb hinana cad maha huhuni talilhuqagan. Odimeig age hinana gelna maha am ben goimdumeig jic muduqagan. Odocob qeih cunugnana ququlubaadi loqagan. Eu age hinana dana gel dunuh bilegina hinaca fadalaadi mahana qeladoqagan. Meen oso ha uqana bilec cudunna qee culdowain,” en. ");
INSERT INTO aey_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Odocob Jisas tempel dunuh limei dana ono ceteteh suldudu bilein eu sanan mi ititacaadi ");
INSERT INTO aey_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","maaden, “Anutna je jaqecna je oso nijia eu Anut odi madena: ‘Ijana jo eu Anut inondocnu jo tawigian’ ena. Ageqa agena odocna age falicdocobil heje dana agena jahunec cudun ibuldon!” aden. ");
INSERT INTO aey_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Odocob Jisas tempelna deel cunugna iwaladoloi. Ihanec dana benbenca, loo je iwaladec dana ageca, dana caja agena benbenca age qagadoqagannu jic wali coboin. ");
INSERT INTO aey_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Euqa dana cajaca cunug age uqa dah mudoloig eu je osol bahic ha wooldocnu culoloig. Eunu age adi bahic odocnu ec jic qee felein. ");
INSERT INTO aey_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Odocob deel osona saen Jisas uqa tempelna iwalaadi me je maaaden ihanec dana benbenca, loo je iwaladecca, Juda agena matuca age uqaca humeig ");
INSERT INTO aey_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","sisildoin, “Magaga, in ijanna hina eu odogona? In cabi eu ocnu maheceb odogona?” doin. ");
INSERT INTO aey_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Odocob Jisas jejenega hewi maaden, “Ija age casac je oso sisiladigen. Mateiga, ");
INSERT INTO aey_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jonna wa joadec eu sao jobondecfo, qee danadecfo?” aden. ");
INSERT INTO aey_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Odocob age agedodoc togodudu madein, “Ege madoqaqa wa joadec eu sao jobondec doqaqa uqa ege eetanu uqanu wawaga mele qee el? gigian. ");
INSERT INTO aey_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ege madoqaqa wa joadec eu dananadec doqaqa eu dana cajaca eu age cunug Jonnu uqa je hahun madec dana ec wawaga ben bahic meleena. Eunu age meen qeli qigecebil cal meqan,” ein. ");
INSERT INTO aey_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Eunu age jejeg hewi madoin, “Jonna wa joadec eu anadec ege qee doqona,” doin. ");
INSERT INTO aey_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Odocob Jisas maaden, “Eunu ija ageha in ijanna ceteh i odigina eu qee maadigaun,” aden. ");
INSERT INTO aey_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Odimei Jisas galolo je i dana cajaca maaden, “Dana oso wain cabi cehen. Dana leih age uqana wain cabi cofdocnu ebenegana meceb meen qaig mumudegin uqa jobon cuculi nui saen cecelacca bahic bilen. ");
INSERT INTO aey_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wain aig wal meceb cedec saen cali hocob wain cabi gug uqa cabi dana oso suldudu madon, ‘Hina nuimeg wain cabi oc eundec maadecem age wain aig leih eu ihecebil cedi ahutagale,’ don. Euqa dana age wain cabi cofdoin eu age cabi dana qumeig wain aig ameg oso qee utec suldocobil ceselen. ");
INSERT INTO aey_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Odocob wain cabi gug uqa haun cabi dana oso suldocob nuen. Euqa wain cabi cofdoin age cabi dana euha qumeig me qee mudimeig suldocobil gauc ceselen. ");
INSERT INTO aey_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Odocob wain cabi gug uqa cabi dana cijeddoc eu suldocob nuen qa dana eu age uqaha qetudein. Odimeig wain cabinadec heludecebil calen. ");
INSERT INTO aey_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Odocob wain cabi gug maden, ‘Adi odigen? Ija melami nelugca i suldocomin nuigian. Acahna age uqa cumundoqagan,’ en. ");
INSERT INTO aey_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Euqa saen dana eu age uqa lelen fimeig madocobmadocobein, ‘I cabi gug huqaneh, uqa isi wain cabi ugian. Cois, uqa muguh eu ege oqannu ege cajimeb qocomun cal mecnu!’ ein. ");
INSERT INTO aey_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eunu age wain cabinadec heludecebil cacalen qagadoin,” aden. Odimei Jisas sisiladen, “Wain cabi gug uqa wain cabi cofdoc dana eu eeta odadigian? ");
INSERT INTO aey_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Uqa humei dana eu age fadaladeceb cal moqagan. Odimei wain cabi eu dana filfil adigian,” aden. Saen dana eu odi dah mimeig madein, “Eu odi calecwe qee!” ein. ");
INSERT INTO aey_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Odocob Jisas meciadimei sisiladen, “Eu odi calecwe qeefi cel oso eu Anutna jaqec je i gug bahic sildina? ‘Meen oso meen gel cehec memei dana culein eu qila meen jo big gug jo hehdocnu calen.’ ");
INSERT INTO aey_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Dana cunug meen euna toni qoin eu age qetadi susul faladigian. Odocob meen eu oso toni cilehdocobfi comis ibuldugian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Odocob loo je iwaladecca, ihanec dana benbenca age Jisas uqa galolo je i agenu maden ec doin. Eunu age saen euna himec Jisas hewoqaga odoin qa eu age dana cajaca cucuiadeinnu qee hewudelein. ");
INSERT INTO aey_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eunu loo je iwaladec dana, ihanec dana benbenca age saen euna Jisas mecidudu cofdoin. Eu age cijawi coboc dana leih age dana meme cinigwe suladecebil belein. Odimeig Jisas agena sisilecna uhuldumeig aisais hewoqagannu cabi adein. Odocob age ihoc uqa ehudi li gesilec jona mudimeig hatu cofdoc dana ebenna moqagannu cisdoin. ");
INSERT INTO aey_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Odocob uhulec dana i age Jisas sisildoin, “Iwalgec, hina iwalgigi madagana eu mele, ege doqona. Hina dana ijan meca ec qee cisdogona qa hina Anutna kobol eunu je mele himec dana cajaca iwaladegana euha doqona. ");
INSERT INTO aey_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ege Sisanu takis helecnu eu tutucfo, qee tutuc qeefo?” doin. ");
INSERT INTO aey_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Euqa Jisas agena uhulec je eu fimei maaden, ");
INSERT INTO aey_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Meen qaig oso eu ihacteiga. In hahun eu gaga qoc taweia? In ijanha jaqec taweia?” aden. Odocob age jejeg hewi madoin, “Eu Sisa uqana,” doin. ");
INSERT INTO aey_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eunu Jisas maaden, “Eunu age Sisana ceteteh eu Sisa uteiga. Anut toinan eu Anut uteiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Odocob age je oso cahuldu madeceb euna ono dana cajaca amagana aisais hewi ocwe qee. Euqa age je eu maadeceb dumeig tumatumaimeig uqa jejeg hewecwe qee. Eunu age tiliec bahic bilein. ");
INSERT INTO aey_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Odocob Sadjusi dana leih Jisasca hoin. Sadjusi age cal mein eundec ceseli qee cajowain egina. Age Jisas je oso sisildu madoin, ");
INSERT INTO aey_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Iwalgec, Moses uqa loo je gadac i jaqigen, ‘Dana oso uqa waliag cal mimei aideg culdigian qa melca qeefi dana eu uqa waliag cal men euna mel basituwasannu aideg eu ugian,’ odi jaqigen. ");
INSERT INTO aey_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Saen osona waliagul 7-pela biloloig. Matu eu caja on. Odocob waliag eu aideg mel qee basec uqa cal men. ");
INSERT INTO aey_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Odocob waliag lecisdoc uqa caja eu on. Uqaha aideg mel qee basec cal men. ");
INSERT INTO aey_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Odocob waliag cijeddoc eu waliagul 7-pela cunugca eu odi odoin. Caja euca mel oso qee basec cal mein. ");
INSERT INTO aey_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hibna bahic caja eu cal men. ");
INSERT INTO aey_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Odocob waliagwaliag 7-pela cunug uqa age osolosol agena caja bilen. Eunu cal mec ceseli cajec saenna uqa in aideg biligian?” doin. ");
INSERT INTO aey_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Odocob Jisas jejenega hewi maaden, “Dana cajaca cebac bilec maha ina ocobocobegina. ");
INSERT INTO aey_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Euqa dana cajaca cal mecnadec ceseli cajimeig cebac bilec cul hibnanu Anut gesiladec bilia euna biluqagan eu age Anut talacul biluqagan, age ensel ihocihoc tawoqagan. Odocob age cal mecnadec ceseli cajoqagan. Age cal mecwe qee. Eunu age ocobocob qee owain. ");
INSERT INTO aey_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Odocob Mosesna je jaqec cal mecnadec haun ceseli cajoqagan eunu camasac bahic ihacadena. Na nag ja cijec uqana je euna jaqec taweia eu Moses uqa Tibudnu odi jaqen: ‘Uqa Ebrahamna Anut, uqa Aisakna Anut, odocob uqa Jekobna Anut,’ en. ");
INSERT INTO aey_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Eunu dana cunug age uqa amegna cebac bileginanu Tibud uqa cebac bilegina agena Anut, uqa cal mec agena qee,” aden. ");
INSERT INTO aey_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Odocob loo je iwaladec dana leih madoin, “Iwalgec, hinana je jejenega hewec eu me bahic!” doin. ");
INSERT INTO aey_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Odocob je oso haun sisildocnu cucuiein. ");
INSERT INTO aey_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Odocob Jisas sisiladen, “Age adi madegina, ‘Krais eu uqa Dewid Melah,’ egina? ");
INSERT INTO aey_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ge, Dewid uqadodoc buk Samna jaqen: ‘Anut Tibud uqa ijana Tibud odi madon, “Ijaca hu ebeni meulana isec bibilem ");
INSERT INTO aey_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ija odocomin hinana cad cunug hu ninijebil hina jaimna lahacadegan,” don,’ en. ");
INSERT INTO aey_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Eu feiga, Dewid uqa Kraisnu madi, uqa ijana Tibud, en, eunu adi uqa Dewid Melah bilina?” aden. ");
INSERT INTO aey_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dana cajaca cunug dah mumudegin Jisas uqana malogom maaden, ");
INSERT INTO aey_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Age loo je iwaladec dananu cofdoiga. Loo je iwaladec age lotoc cecelac tacimeig cocobi nuecnu gale adena. Age ceteteh idadec cudunna age binanaga sulecnu gale adena. Age cuha jona cabal me cudunna bilecnu gale adena. Odimeig age sab ben jec saenna bilec binanca euna bilecnu gale adena. ");
INSERT INTO aey_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eu age caja wij agena jo heje cedegina. Odimeig age dana me bahic meciadecnu saen cecelac bahic inondogina! Dana eundec age agena cahuldocnu ameg ben bahic oqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Odocob Jisas qaalimei uqa cehewanagaca age meen qaig helecnu tempel bokis meen qaig memegin meciaden. ");
INSERT INTO aey_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Odimei uqa caja wij sawen osoha meen qaig nag lecis memen fen. ");
INSERT INTO aey_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Odocob uqa maaden, “Dana caja cehewanagaca age cehewanaga bennadec meen qaig heleiga qa caja wij i uqa sawen bahic, uqa uqana ceteh cebac bilecnu meen qaig cunug heleia. Eunu ija mele maadigina, caja wij sawen i uqa meen qaig nag heleia eu cehewanagaca age tempel bokisna meen qaig ben bahic heleiga cunug wooladena,” aden. ");
INSERT INTO aey_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Odocob dana leih age tempel uqana meen soidocca fecnu me bahic, odocob bagol gagaca mudein euha fecnu me bahic eunu mamadegin Jisas maaden, ");
INSERT INTO aey_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ceteteh i cunug fegina eu saen caleceb meen gel ulugedocob meen oso meen oso tatacanna cilehdoc qee biliaun. Cunug wagalecebil mahana tonoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Odocob eu age sisildoin, “Iwalgec, aadeb eu odi caligian? Odocob cel gaga casac camas meceb saen wele dodoldona eu ege docnu ihoc?” doin. ");
INSERT INTO aey_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Odocob Jisas maaden, “Matica age ija ijanina mamadi hoqagan, ‘Ija uqa,’ oqagan. Odocob ageha madoqagan, ‘Saen wele hoia,’ oqagan. Euqa cain tooadowain. Eunu oso hu faninadi dado madeceb agena jic ceja qocna lowainnu batut feigale. ");
INSERT INTO aey_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Han ben saen falicfuluc eu casac caloqagan. Euqa cit qoc eu mahuc qee toodu hoiaun. Eunu age ceteh eu hona ec dah moqagan saen euna cain cucuiuwain,” aden. ");
INSERT INTO aey_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Odocob uqa odi maaden, “Dana hatuhatu age cajimeig cilehdocobcilehdocoboqagan. Odocobil dana sihulsihul age cajimeig cilehdocobcilehdocoboqagan. ");
INSERT INTO aey_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mim benben mahana nigian. Sabnu cahel bilec saen maha filfilna cali hugian. Odocob hag gug filfil mahamaha ihoc ligian. Sao jobondec ono gaga meca caca ceteh filfil cacaleb foqagan eunu ben bahic cucuiuqagan. ");
INSERT INTO aey_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Euqa ceteh eu cunug qee calec ninijeb age hewadimeig me qee madoqagan. Age Juda agena cuha jo dunuh um aqimeig gihacdoc jona madoqagan. Age ija ijaninu kingca, hatu cofdocca ehadi li amagana madoqagan. ");
INSERT INTO aey_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Saen eu age ijana me je qasali maadecnu saen. ");
INSERT INTO aey_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Ijadodoc je adi madoqagan eu conogana migen. Odocob doc meca je madoqagan eu agena cad eundec age je mele qee madegina ec madecwe qee, age jejenega hewi maadecwe qee. Eunu age amagana agedodoc cesuladec je adi madoqagannu cain casac saciadowain. ");
INSERT INTO aey_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Age memegailca, anagailca, walinigailca, agena sihul eundec agena danahca eu age agena cad ebenegana madoqagan. Eu age agenadec leih dewenega tudocobil age cal moqagan. ");
INSERT INTO aey_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Age ija ijani hewegina eunu dana cajaca cunug age agenu gemanaga beceb sagagadoqagan. ");
INSERT INTO aey_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Euqa age dewenega cunug Anut uqa cahahadugian. Gosiniga osol himecha age ilomoganadec qee fadaleiaun. ");
INSERT INTO aey_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Age wawaga gagadic tawoqaganna agena cebac bilec catanec oqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","22","Jisas je haun maaden, “Saen euna eu ‘Fileec Ameg Oc Saen,’ je cunug Anutna jaqec jena taweia eu aig ihoc ligian. Eunu saen age han dana am Jerusalem alildocobil fifeig age taun ben eu nag odi fadaldoqagan ec ihoc cisdoqagan. Eunu leih Judia hatuna bilegina age busali aluhnana toboigale. Leih Jerusalem dunuh bilegina age taun ben eu culdoigale. Odocob leih cabina cobogina age taun benna cain ceseli belowain. ");
INSERT INTO aey_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Saen euna caja waugca coboc, caja mel su adegina eundec age walocca bahic biluqagan! Ge, saen euna culumen ben bahic mahana caligian. Odocob Anut olohon dana cajaca i age oqagan. ");
INSERT INTO aey_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Leih age han siginna cal moqagan. Odocob leih gihacdoc dana cinigwe hatu cunugna ehadi beloqagan. Odocob Juda dana qee eundec age jaimagana Jerusalem lahacdoqagan odi tatawebil li agena saen ihoc ligian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jisas je haun maaden, “Gaga filfil camna, jagelna, malaqana caligian. Odocob hatunana dana caja cunug jaen ben aqigian. Odocob macas silca qaqahi udududoc eunu cucuiuqagan. ");
INSERT INTO aey_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Saona gagadic odoc eu caji leceb hocob qeleloqagan. Eunu dana cajaca age cucuieeig maha ina ceteh caligiannu geh cisdoqagan. Odocob amaga ha waldugian. ");
INSERT INTO aey_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Eu odi cali hedocob Dana Melah uqa gagadic odoc kobolkobolca bahic uqa taen osona neneb foqagan. ");
INSERT INTO aey_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aria, ceteteh eu odi sanan mi cacaleb saen euna Anut age cahahaadecnu saen dodoldonanu age caji tawimeig ilomoga suleiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Odimei uqa galolo je oso maaden. Uqa maaden, “Age na dannu cisdoiga. Na cunugnu ha cisdoiga. ");
INSERT INTO aey_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Saen age cilonca fegina eu cam saen me bahic caligian dodoldona ec dogina. ");
INSERT INTO aey_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Eu odi himec age ceteteh eu odi cacaleb fifeig age Anutna cul wele dodoldona eu doqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ija mele maadigina, sihul i qila bilegina qee cal mi hedoc ninijeb ceteteh eu cunug caligian. ");
INSERT INTO aey_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sao mahaca qee migian euqa ijana je qee qee meiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jisas je haun maaden, “Euqa ceteteh maha inadecnu cain cisdowain. Cain ja ben qowain. Cain dalul aqeiaun. Maha ina cebac bilecnu cain jaen aqeiaun. Agedodocnu cofdoiga. Qeefi, Gesilec Deel Ben eu mahuc ageca bolob cinigwe hugian. ");
INSERT INTO aey_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Deel eu dana cajaca maha cunugna bilegina ageca caligian. ");
INSERT INTO aey_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Saen cunugna saciadoc bileiga. Odocob gaidgaid Anut gagadic odoc adigiannu sisildoiga. Eu odina age ceteh cunug ageca caligian eu ihoc wooldoqagan. Odocob age Dana Melah olana tawoqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Odocob deel cunugna Jisas dana cajaca tempelna iwaladoloi. Wesuna uqa nui Oliw Aluhna ono us nijoloi. ");
INSERT INTO aey_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Odocob dana cajaca cunug qasil wele cajimeig tempelna ono uqana je dah moqagannu uqaca loloig. ");
INSERT INTO aey_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Odocob Bred Jisca Qee Sab Jec deel gun, age Pasowa ein, eu dodoldon. ");
INSERT INTO aey_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Odocob ihanec dana benbenca loo je iwaladec danaca age dana cajacanu cucuiein. Eunu age Jisas qagadocnu jic oso walein. ");
INSERT INTO aey_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Odocob saen euna Seten uqa Judas, age Iskariot doloig, uqa waug dunuh len. Judas uqa malogom 12-pela agenadec oso. ");
INSERT INTO aey_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Odimei uqa ihanec dana benbenca, tempel cofdoc han danaca ageca len. Odimei uqa Jisas cel jicna age ebenegana migiannu age gami togodoin. ");
INSERT INTO aey_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Age eu dumeig wawaga ceeleceb age je gabandumeig meen qaig utecnu je cagoin. ");
INSERT INTO aey_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas meen qaig fimei eu agena jenu cois en. Odocobil Judas uqa dana cajaca qee cegulec saenna Jisas dewegnu ob mimei age ebenegana mudigiannu jic walen. ");
INSERT INTO aey_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Odocob Bred Jisca Qee Sab Jec deel gun cali hon. Deel euna Juda dana age sipsip nag Pasowa ja qocna joqagannu qagadoloig. ");
INSERT INTO aey_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Eu odinu Jisas uqa Pita Jonca odi maali sulalen, “Ale belimesi egena Pasowa ja qoc ege jecnu saciadosia.” ");
INSERT INTO aey_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Odocob ale jejeg hewi madosin, “Ele ana saciadocnu gale hena?” dosin. ");
INSERT INTO aey_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Odocob uqa jejenela hewi maalen, “Fesia, ale taun benna limesi dana oso halon waca gahidu humei jicna gulucaligian. Ale uqa toodu lesi jo uqa hamol ligian euna toodu lesia. ");
INSERT INTO aey_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Odimesi ale dana jo eu gug madosia, ‘Iwalgec maheia, “Jo hamol ija ijana malogom gami Pasowa ja qoc sab jecnu eu ai?” heia,’ dosia. ");
INSERT INTO aey_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Odocob hamol ben bahic ohis eu sab jec cabalca, bilec cabal ceteh cunugca ihacaligian. Ale Pasowa ja qoc sab jecnu euna saciadosia,” alen. ");
INSERT INTO aey_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Odocob ale belesin. Odimesi ale Jisas maalen odi bahic gulucdosin. Euna ale Pasowa ja qoc sab jecnu saciadosin. ");
INSERT INTO aey_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Odocob saen eu caleceb Jisas sab jec cabalna bilen. Odocob aposel ha lecebil uqa gami bilein. ");
INSERT INTO aey_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","16","Odimei uqa maaden, “Ija maadigina, ija haun Pasowa ja qoc qee jec li hibna Anutna culna aig qoc saenna ihoc ligian. Eunu ija casac Pasowa ja qoc i age gami jimeb isi ija deweni dain tec gahidugen eunu hooligina,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Odimei uqa gabin oso on. Anut hetaga doc je madumei maaden, “Ija maadigina, ija wain aignadec haun qee jec li Anutna cul ihoc ligian. Eunu age eu umeig age agedodoc cesawi jeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","20","Odimei bred oso umei Anut hetaga dumei uqana malogom aadi maaden, “I ija deweni ganac eu ija agenu Anut utigina. Age ijanu cisdoqagannu odi odogina,” aden. Hibna eu ji hedumeig uqa wain gabin euha eu odi himec odimei maaden, “Wain gabin i eu Anutna bal cehec je haun eu ija golanina gabandocob agenu basecdugian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Odimei Jisas maaden, “Euqa feiga! Dana ija cad ebenegana mitigia odona eu uqa ijaca jec cabal ina biluwa. ");
INSERT INTO aey_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mele bahic, Dana Melah uqa wele Anut jic maden odi toodugian eunu jic eu toodugian qa dana cad ebenegana mudigian uqa walocca biligian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Uqa odi maadeceb agedodoc sisildocobsisildocobimeig madein, “In uqa kobol odi odigian?” ein. ");
INSERT INTO aey_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Odocob malogom age gemona in uqa ben biligian eunu fee dadanein. ");
INSERT INTO aey_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Odocob Jisas maaden, “King maha ina bilegina age agena dana cajaca gagadic odoc ilo bilegina. Odocob age agena ilo dananu egena cesulgec egina. ");
INSERT INTO aey_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Euqa age odi cain odowain. Cain bahic. Dana age gemona ben bilina uqa dana milum bahic cinigwe biliale. Odocob agena ilo dana uqa cewel uadec odi cinigwe biliale. ");
INSERT INTO aey_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","In uqa ben, acahna dana sab jecnu bilina uqafo, qee dana sab qumei ahutona uqafo? Eu dana sab jecnu bilina uqa himec. Euqa ija age gemona agena cewel uadec biliga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Wele age ijaca biloloig temtec ceteh holoi eu qee culti qisactoloig. ");
INSERT INTO aey_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Odocob ija Mei cul osonu ilo miten. Eu odiwe age ijana culna ijana sab jec cabalna bibileig sab jejeig wa gab jejeig biluqagannu, odimeig bilec cabal ben kobolkobolcana bilimeig Isrel sihul 12-pela gesiladoqagannu ija ageha cul osonu ilo madigina,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Odocob Tibud uqa Pita madon, “Saimon, Saimon! Dah maga! Seten uqa wit cabi oc dana wit me ganacca filiganalecnu fohidonawe odi age temadigiannu cois ec Anutna je wele oia. ");
INSERT INTO aey_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Euqa hinana wawin meleec qee toneiaunnu ija hinanu wele inonduga. Odocob saen ijaca falicdumeg hina cabi hijinel gagadic odoc adaga,” don. ");
INSERT INTO aey_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Odocob Pita jejeg hewi madon, “O Tibud, ija hinaca cal mecnuca, gihacdoc jona nuecnuca cois wele saciadoc biliga!” don. ");
INSERT INTO aey_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Odocob Jisas uqa Pita madon, “Pita, ija mahigina, witic ina mala manahal qee qoc ninijeb hina qee sasac ququ madegan, ‘Uqanu qee dugina,’ i cijeddogan,” don. ");
INSERT INTO aey_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Odimei Jisas uqana malogom sisiladen, “Saen age meen qaig tacecca, badomca, jaimaga tacecca qee suladem eu nuimeig cetehca qee coboinfo?” aden. Odocob age jejeg hewi madoin, “Ceteh osol osoca qee eu qee cobolom,” doin. ");
INSERT INTO aey_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Odocob Jisas maaden, “Euqa qila in oso uqa meen qaig taceccafo, badomcafo eufi cois ahewigian. Odocob oso uqa han siginca qeefi uqana lotoc ben suldumei oso fajigian. ");
INSERT INTO aey_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Eunu ija edi maadigina. Anutna jaqec je oso edi maden: ‘Age uqa loo je wooldoc dana osoben bibilegin meciadein,’ eu mele bahic ijaca hona. Ge, ijanu Anutna jaqec je tawena eu mele bahic ihoc lena,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Odocob malogom age madoin, “O Tibud faga, han sigin lecis ihec,” doin. Odocob uqa maaden, “Eu ihoc!” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Odimei Jisas uqana kobol toodumei uqa cudun eu cuculdi Oliw Aluhna ten. Uqa gaid odoloi odi odocob uqana malogom hib toodocobil tein. ");
INSERT INTO aey_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Cudun euna ti calimeig uqa maaden, “Temadecna qee lowainnu inondoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Odimei uqa cuculadi dana oso meen qeleceb nui tonena eu odi timei gob cehimei Anut inondon. ");
INSERT INTO aey_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Odocob uqa madon, “O Mei, hina gabin i cawalitecnu cisdoc nijecebfi cawalitiga. Euqa ijana cisdoc cain toodogaun, hinana cisdoc toodoga,” don.  ");
INSERT INTO aey_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Odocob ensel oso sao jobondec gagadic odoc utigiannu nen. ");
INSERT INTO aey_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Odocob Jisas deweg culumen doc tebandumei gagadic bahic Anut inondon. Odimei musul golac gagadic cinigwe mahana toocooi tonen. ");
INSERT INTO aey_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Uqa inondu hedumei caji uqana malogom ageca ceseli non. Odimei wawaga culumen adecna us ninijegin meciaden. ");
INSERT INTO aey_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Uqa maaden, “Age eetanu us nijegina? Cajimeig temadecna qee lowainnu inondoiga,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Uqana malogom je maaaden dana am ben bahic tein. Dana aquneceb tein uqa ijan Judas uqa malogom 12-pela eundec oso. Uqa Jisas cotdugiannu cemenug ten. ");
INSERT INTO aey_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Euqa Jisas madon, “Judas, hina cotecna Dana Melah uqana cad amagana camasac mudugunafo?” don. ");
INSERT INTO aey_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Saen malogom Jisasca tawein eu age ceteh caligia oodon fimeig sisildoin, “Tibud, egena han siginna cois cadecnufo?” doin. ");
INSERT INTO aey_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Odocob malogom oso uqana han siginna ihanec dana ilona cabi dana qelimei dahig meulana isec caguton. ");
INSERT INTO aey_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Euqa Jisas maadimei, “Eu odi cain! Kobol eu culeiga!” adimei uqa qududocob dahig me muden. ");
INSERT INTO aey_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Odimei Jisas uqa ihanec dana benbenca, tempel cofdoc han danaca, Juda agena matuca age uqa hewoqaga lein eu maaden, “Eetanu age han siginca han galabca heje oc dana cinigwe hewoqagannu hoiga? ");
INSERT INTO aey_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ija ageca tempelna gaidgaid bilolob. Odocob age saen euna ija hewitecnu oso qee odoloin. Euqa qila eu agena gagadic odoc saen. Eu tu uqana gagadic odoc gagadic bahic mena,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Eu age Jisas hewimeig ihanec dana agena ilona jona ehi lein. Odocob Pita Jisas tabag hehewi tooaden. ");
INSERT INTO aey_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jo eu gel dunuh ja hudein. Odocob Pita leceb leih ja cudun bilein gami bilein. ");
INSERT INTO aey_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Odocob cabi mel aid oso ono ja cudun bibilen fimei deei maden, “Dana i ha uqaca bilein!” en. ");
INSERT INTO aey_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Euqa Pita uqa qee sasac qu madon, “Caja, ija uqanu qee dugina!” don. ");
INSERT INTO aey_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Odocob saen nag gieceb dana oso fecidumei madon, “Hina agenadec oso!” don. Euqa Pita jejeg hewi madon, “Dana, ija qee iel!” don. ");
INSERT INTO aey_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Odocob aua osol odi hedocob dana oso gagadic bahic maden, “Dana i uqaha Galilidec. Eunu mele bahic, uqaca bilesin,” en. ");
INSERT INTO aey_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Euqa Pita jejeg hewi madon, “Dana, hina eetanu madagana eu ija qee dugina!” don. Saen uqa je mamaden bahic mala manahal qon. ");
INSERT INTO aey_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Odocob Tibud qaalimei Pita fen. Odocob Pita Tibud je madonnu cisdon, “Mala manahal qee qoc ninijeb hina qee sasac ququ ijanu qee dogona ec madi cijeddogan,” don. ");
INSERT INTO aey_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Odocob Pita jo eu cuculi cali limei ben bahic qajen. ");
INSERT INTO aey_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Odocob dana Jisas cofdu tawein eu age cih je madodoig ququein. ");
INSERT INTO aey_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ameg qagimeig sisildoin, “Je hahun magaga doqa! Info qihia?” doin. ");
INSERT INTO aey_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Odimeig je qesaldoc geh bahic madoin. ");
INSERT INTO aey_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Walag daneceb Juda agena matuca, ihanec dana benbenca, dana loo je iwaladecca cegulein. Odocob Jisas eu agena gesilecnu tamanec euna ehudi ehi lein. ");
INSERT INTO aey_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Age madoin, “Hina Anutna Krais eu melefi magaga,” doin. Odocob uqa jejenega hewi maaden, “Ija maadeceminfi ijana jenu wawaga qee meleeiaun. ");
INSERT INTO aey_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Odocob ija je oso sisiladeceminfi age jejeni qee hewowain. ");
INSERT INTO aey_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Euqa qila nueceb hibna ha Dana Melah Anut gagadic odocca bahic eben meulana isec biligian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Eu age cunug madoin, “Hina mele bahic Anut Melah?” doin. Odocob uqa jejenega hewi maaden, “Age madegina eu odi,” aden. ");
INSERT INTO aey_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Odocob eu age madein, “Ege je dana i maden qasali magecnu dana leih qee cedoqaun. Egedodoc bahic uqa cona madeceb dah moqa!” ein. ");
INSERT INTO aey_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Odocob cunug odi cajimeig Jisas uqa Pailatca ehudi ehi lein. ");
INSERT INTO aey_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Odimeig age Pailat amegna um qudec je geh bahic madein, “Dana i egena dana cajaca cunug kobol me qee iwalaaden hewoqa. Uqa takis Sisa cain helowain ec maaden. Odocob uqadodoc madena, ‘Ija Krais, ija king biligen,’ ena,” ein. ");
INSERT INTO aey_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Odocob Pailat uqa sisildon, “Juda agena king eu hinafo?” don. Odocob Jisas jejeg hewi madon, “Hina madagana eu odi himec,” don. ");
INSERT INTO aey_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Odocob Pailat ihanec dana benbenca dana cajaca gelgel amagana maaden, “Ija dana i dewegna cahuldoc oso qee felem,” aden. ");
INSERT INTO aey_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Euqa eu age gagadic mimeig madein, “Dana eu uqa dana cajaca je maadeceb olohonoga ben. Judia hatu cunugna eu odi odon. Uqa Galili hatu ono sanan mimei hu ene calen,” ein. ");
INSERT INTO aey_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Odocob Pailat eu odi dah mimei oso sisildon, “Dana i uqa Galilidecfo?” don. ");
INSERT INTO aey_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Saen Pailat uqa Jisas eu Herod maha cul cofdonanadec ec dumei uqa Herodca suldon. Saen euna Herod uqaha Jerusalem ono ilo bibili bilen. ");
INSERT INTO aey_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod uqa Jisas hutan dah men. Odimei saen cecelac bahic figiannu cisdudu bilen. Uqa Jisas kobolkobol odoc oso odocob figiannu cisdon. Eunu uqa Jisas fimei waug ceelen. ");
INSERT INTO aey_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Eunu Herod sisilec geh bahic Jisas sisildon qa Jisas uqa jejeg qee hewel. ");
INSERT INTO aey_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Odocob ihanec dana benbenca, loo je iwaladec danaca cemenugca timeig uqanu um qudec je madein. ");
INSERT INTO aey_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Odocob Herod uqana han danaca age Jisas cih je madodoig ququein. Lotoc gaga me bahic king taqeginawe u taqitumeig suldocobil Pailatca ceselen. ");
INSERT INTO aey_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herod Pailatca ale wele cad bilolosi. Euqa deel euna dih danah mesin. ");
INSERT INTO aey_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Odocob Pailat uqa ihanec dana benbenca, iwaladec danaca, dana cajaca maadeceb cegulein. ");
INSERT INTO aey_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Odimei maaden, “Age dana i ija amina ehudi ahumeig uqa dana cajaca age Rom agena ilo qee tooadecnu iwaladi cahuldona eiga. Qila ene age amagana ija uqa sisilduga qa age uqana cahuldoc um qu madeiga eu mele bahic oso qee felem. ");
INSERT INTO aey_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodha uqana cahuldoc oso qee fel. Eunu uqa egeca haun suldocob ceseleia. Dana i uqana cahuldocca qee, gauc cal mecnu ihoc qee. ");
INSERT INTO aey_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Eunu ijana han dana oso uqa geh bahic qisadocob ija culdecemin nuigian,” aden. Odocob kobol oso bilen. Pasowa sab jec saen cunugna Pailat gihacdoc dana osol gihacdoc jonadec besitoloi. ");
INSERT INTO aey_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Odocob dana cajaca am cunug age utaii madein, “Qagadoga! Barabas gihacdocnadec besitoga!” ein. ");
INSERT INTO aey_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Odocob Barabas uqa taun benna ono han tulidumei dana qagadocob gihacdoc jona mudein. ");
INSERT INTO aey_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Euqa Pailat Jisas suldocob nuigiannu odon. Odinu uqa dana cajaca am age haun utaadi maaden. ");
INSERT INTO aey_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Euqa age haun ceseli utai madoin, “Na babalecna tuitu qoga! Na babalecna tuitu qoga!” doin. ");
INSERT INTO aey_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Odocob Pailat maadi cijeddon, “Eetanu? Uqa cel qisol mec odon? Ija uqa cal mecnu ihoc dewegna cahuldoc oso qee felem! Ija gehca bahic qisadumig culdecemin nuigian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Euqa eu age jejenega ohisna Jisas na babalecna tuitu qocnu utaii madein. Odocob cit qocna bahic agena utaec aig qon. ");
INSERT INTO aey_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Eunu Pailat eu agena je toodu Jisas na babalecna tuitu qocnu cois en. ");
INSERT INTO aey_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Odimei eu age dana gihacdocnadec besecnu madein eu besiton. Uqa dana han tulidumei taun benna ono dana oso qagadon. Uqa odimei agena je toodumei Jisas deweg na babalecna tuitu qoqagannu ebenegana men. ");
INSERT INTO aey_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Odocob Jisas ehudi belein. Saen eu age bebeli bileig jicna dana oso, ijan Saimon Sairinidec, taun benna ono nunuen ceguldoin. Odimeig cahacdodoig na babalec qatona mitocobil gahidu Jisas toodon. ");
INSERT INTO aey_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Odocob dana cajaca am ben bahic Jisas Saimonca tooalein. Dana cajaca am eunadec caja leih age Jisasnu qaqajeig due walocca sisili toodoin. ");
INSERT INTO aey_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Odocob Jisas waldumei maaden, “Jerusalem caja, age ijanu cain qajowain qa agedodocnu agena melnu cois qajeiga. ");
INSERT INTO aey_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Deel hona euna dana madoqagan, ‘Caja melca qee, mel qee basegina eu age, odocob mel qee su adegina eu age ceeli bileigale!’ oqagan. ");
INSERT INTO aey_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Saen euna dana age aluh madoqagan, ‘Toni cilehgaga!’ oqagan. Odimeig aluh gatic madoqagan, ‘Jahulgaga!’ oqagan. ");
INSERT INTO aey_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ge, age saen na cebac tatawen ceteh i edi odoginafi na galaleeb saenna age adi odoqagan?” aden. ");
INSERT INTO aey_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Loo je wooldoc dana lecis ha cedali ehi tein eu Jisasca osoben aqoqagannu cedali ehi tein. ");
INSERT INTO aey_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Odimeig age cudun, ijan “Ilo Gatic,” ono ti calimeig Jisas dana lecis loo je wooldoc eu aleca na babalec cijedna tuitu aqimeig caqusadecebil caculein. Oso Jisas eben meulana isec na babalecna tuitu qoin, odocob oso eben ansena isec na babalecna tuitu qoin. ");
INSERT INTO aey_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisas maden, “O Mei, age eeta odogina eu qee dogina. Eunu agena silail cagasiadaga,” en. Odimeig uqana lotoc agedodoc satu udodoig siwi cedein. ");
INSERT INTO aey_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Odimei dana cajaca ono tawein mecieegin Juda dana agena ilo eu age Jisasnu lelanec je mamadiein, “Uqa leih cahahaaden. Uqa Anutna Kraisfi uqa uqadodoc cahahadoia!” ein. ");
INSERT INTO aey_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Odimeig han dana ha uqanu lelanec je mamadeig uqa cemenug cocobi timeig wain gad qugiannu uutiein. ");
INSERT INTO aey_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Odimeig maduduein, “Hina Juda agena kingfi hinadodoc cahahadoga!” ein. ");
INSERT INTO aey_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Odocob je i uqa ilona jaqi qoin, “Dana i Juda agena king.” ");
INSERT INTO aey_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Odocob loo je wooldoc dana lecis na babalecna tuitu aqalein oso uqa Jisas lelandudu madon, “Hina Anutna Kraisfi hinadodoc cahahadumeg eleha cahahalaga!” don. ");
INSERT INTO aey_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Euqa dana oso eu odi dah mimei cahacdudu madon, “Hinana nun qoc eu odiwe ijana nun qoc. Ele dain ben leccaca oqona. Eunu hina Anut qee cucuidogonafo? ");
INSERT INTO aey_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Elena cahuldoc ameg owona eu cois qa uqa cahuldoc osoca qee,” don. ");
INSERT INTO aey_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Odimei uqa Jisas madon, “Jisas, saen hina king calimeg ijanu cisdogale!” don. ");
INSERT INTO aey_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Odocob Jisas madon, “Ija mele mahigina, qila hina ijaca paradaisna bilewan,” don. ");
INSERT INTO aey_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Odocob cam gemo ceheceb cam tu qocob hatu cunug gagatuc menen, ninijen li 3 kilok wesu. ");
INSERT INTO aey_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Odocob cam tu lelen jajahulen lotoc ben tempelna hamol gunna caqusec tawoloi eu baladu lecisdon. ");
INSERT INTO aey_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Odocob Jisas jejeg suli u utaii madon, “O Mei! Ija doloni hina ebenna migina!” don. Uqa eu odi dih madimei kis umei cal men. ");
INSERT INTO aey_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Han 100 cofadec dana eu odi odocob fimei Anut binan sulen. Odimei maden, “Mele bahic, dana i uqa dana ititom bahic!” en. ");
INSERT INTO aey_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Odocob dana cajaca ceteh calen eu foqaga cegulein eu age odi fimeig qada qaqajeig mugumuga fohifohidodoig ceselein. ");
INSERT INTO aey_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Cunug osolosol Jisasnu doloig eu ageca, caja Galilidec Jisas toodu hoin eu ageca nag onoca qisacdu tataweig ceteh i calen eu fein. ");
INSERT INTO aey_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Aria, dana oso, ijan Josef, bilen. Uqa Juda agena jobon nag Arimatiadec. Uqa dana ititom. Uqa Anutna cul hoc saen susumudi bilen. Uqaha Juda agena gesilec tamanec qa uqa agena Jisas qagadocnu je madec odocca eunu cois qee el. ");
INSERT INTO aey_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Uqa Pailat amegna limei Jisas deweg ganac ugiannu sisildon. ");
INSERT INTO aey_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Odimei Jisas deweg ganac na babalecnadec hewen toneceb lotoc senenec jeuldeceb ehi nui hatin aluh qeih hunein euna mudein. Heel eu dana oso qee mudec Jisas casac mudein. ");
INSERT INTO aey_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Deel eu saciadoc deel odocob Juda agena cuha deel gun sanan migia oodon. ");
INSERT INTO aey_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Odocob caja Jisas Galilidec toodoin eu age Josef toodocobil nuimeig Jisas deweg ganac hatinna adi mudein eu fein. ");
INSERT INTO aey_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Odimeig age jobon ceseli belimeig mool dedeman meme Jisas deweg ganac joudoqaga bili saciadoin. Juda agena cuha deel gunna age jaen mudecnu loo je cagoc gagadic madena odi odoin. ");
INSERT INTO aey_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Cuhana qasil wele bahic caja eu age mool dedeman meme saciadoin eu cedi heheweig heel Jisas deweg ganac mudein ono belein. ");
INSERT INTO aey_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Beli calimeig meen heel cebec cufa qoc eu olocdu fil mec ninijen fein. ");
INSERT INTO aey_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Euna age dunuh lein qa Jisas Tibud deweg ganac qee felein. ");
INSERT INTO aey_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Age dadanii tatawegin dana lecis lotoc senenec seeecca bahic wele cemenega tawesin. ");
INSERT INTO aey_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Odocob cucuiecca caja eu age jogoii maha mecidoin. Oodogin dana eu ale maadesin, “Age eetanu cal mec agena cudunna dana cebac bilia eu megegina? ");
INSERT INTO aey_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Uqa ene qee nijel. Uqa wele ceseli cajeia. Galili hatu ono bibili maadennu cisdoiga. ");
INSERT INTO aey_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Dana Melah uqa dana silailca ebenegana mecebil na babalecna tuitu qocobil cal migian. Odocob deel cijeddocna haun ceseli cajigian,’ aden,” adesin. ");
INSERT INTO aey_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Odocob caja eu age uqana jenu wawaga fogo don. ");
INSERT INTO aey_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hatin onodec haun ceselimeig malogom 11-pela eu ageca lein. Odocob ceteh amagana fein eu dana cajaca cunug ha maadein. ");
INSERT INTO aey_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Caja age eu Maria Magdaladecca, Joana odocob Maria, Jems anag, eu age caja leihca ceteh eunu malogom maadein. ");
INSERT INTO aey_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","12","Euqa malogom caja age gad je madegina ec cisdoin. Odimeig agena jenu wawaga qee meleel. Euqa Pita cajimei guguli Jisas deweg ganac mudein heelna nuen. Uqa jogoimei ceteh oso qee fel qa Jisas deweg ganac jelein lotoc eu himec fen. Odimei uqa adi odon ec waug cacaden ceselen. ");
INSERT INTO aey_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Deel euna himec eu ale togca odi Emeas jobon belesin, uqana cecelac Jerusalemdec eu 11-pela kilomita eu odi. ");
INSERT INTO aey_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Odocob ale ceteh cunug calen eunu togodudu belesin. ");
INSERT INTO aey_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Saen ale je mamadesi togodudu bebelesin Jisas uqadodoc cemenela leceb osoben cocobi belein. ");
INSERT INTO aey_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ale fesin qa uqa Jisas ec qee fogo alel. ");
INSERT INTO aey_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Odocob Jisas maalen, “Ale eetanu je togodudu belesina?” alen. Eu ale olanala gulucqecca tului tawesin. ");
INSERT INTO aey_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Odimesi oso uqa ijan Kliopas sisildon, “Acahna, hina cele dana eundec osoldih uqa ono Jerusalem ceteteh cali hon qila deel leih hedoia eu qee dolfo?” don. ");
INSERT INTO aey_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Odocob Jisas sisilalen, “Cel ceteteh?” alen. Odocob eu ale jejeg hewi madosin, “Ceteteh Jisas Nasaretdecnu calen eu. Dana eu uqa je hahun madec dana. Odocob uqa Anutca dana cajaca amagana cabi gagadic uu je gagadic mamadi cobon. ");
INSERT INTO aey_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Egena ihanec dana benbenca, cofgec danaca cal migiannu madecebil na babalecna tuitu qoin. ");
INSERT INTO aey_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Euqa wele bahic egena wawige madec eu odi tawen eu uqa himec Isrel dana cajaca cahahagigian ec cisdom. Odocob je oso ha eu ceteh calen eunadec hocob qila eu deel cijed hedoian. ");
INSERT INTO aey_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Eu himec qee. Caja leih egena amnadec ququlubgeeigan. Eu age cocojagen heelna noigan. ");
INSERT INTO aey_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Euqa uqa deweg ganac qee felein. Eu age ceseli bimeig ensel lecis amagana camasac mimesi maadesian eu uqa haun ceseli cajeia ec madeigan. ");
INSERT INTO aey_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Egena amnadec leih heelna limeig caja madeigan odi bahic gulucdoigan qa uqa qee felein,” dosin. ");
INSERT INTO aey_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Odocob Jisas maalen, “Ale gad! Je hahun madec dana agena jenu wawala meleecnu culumenca! ");
INSERT INTO aey_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Anutna Krais uqa dain ben doc i edi uu li uqana kobolkobol ugian ec qee dosinafo?” alen. ");
INSERT INTO aey_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Odimei Jisas uqanu Anutna jaqec je cunugna madenanu sildialen, uqa Mosesna loo jena sanan mimei je hahun madec dana agena jaqec je cunug odi maalen. ");
INSERT INTO aey_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Eu age wele jobon cacali dana lecis eu ale lowasannu lesin eu dodoldoin. Odocobil Jisas uqa jobon eu cuculdi soeceb nuigiannu odon. ");
INSERT INTO aey_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Euqa eu ale cahacdudu madosin, “Cam wele nonon tu hona. Hoga, eleca ene nijuqa,” dosin. Eunu uqa leceb eu ale gami nijein. ");
INSERT INTO aey_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Uqa eu aleca sab jec cabalna bilimeig bred umei eeldoc je maden. Odimei uqa bred fenadimei alen. ");
INSERT INTO aey_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Amala fogo docob Jisas fesin qa eu ale amalana jausen. ");
INSERT INTO aey_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Odocob eu aledodoc togodudu madesin, “Saen jic cuhul je malili Anutna jaqec je sildilelen ele wawile ceeleia!” esin. ");
INSERT INTO aey_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Odimesi eu ale mahuc bahic cajimesi Jerusalem ceseli belesin. Ono ale malogom 11-pela leih gami cegulein bibilegin cali lesin. ");
INSERT INTO aey_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Cali ono lecebil odi maalein, “Tibud eu mele bahic haun ceseli cajeia! Uqa Saimon amegna camasac meia!” alein. ");
INSERT INTO aey_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Odocob dana lecis eu ale jic cuhul cocobosin aleca calennu saadesin. Odocob Tibud bred fenialeceb amala fogo docob fesinnu ha sildiadesin. ");
INSERT INTO aey_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Saen eu ale eu odi maaadi tatawesin mahuc bahic Tibud age gemo li tawimei maaden, “Malol ageca biliale,” aden. ");
INSERT INTO aey_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Euqa age cucuiecca qeleleeig eu dol oso foqona ec cisdoin. ");
INSERT INTO aey_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Euqa uqa maaden, “Age eetanu geh cisdogina? Age eetanu wawaga dadanec ben bahic? ");
INSERT INTO aey_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ija jaimi ebenica feiga. Odocob fimeig dol age culunugaca tefulunugaca qee. Eunu ija bahic wawaga meleeiale. Euqa ija odica eu feiga. Hewitimeig tebandoiga. Odimeig doqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","41","Uqa odi mamadi jaih ebenca ihacaden. Euha age wawaga qee meleel eu age ceelecca dadanecca tawein eunu uqa sisiladen, “Age ene sab jecnu osocafo?” aden. ");
INSERT INTO aey_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Age cul dool jana golin oc utein. ");
INSERT INTO aey_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Eu umei uqa amagana jen. ");
INSERT INTO aey_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Odimei maaden, “Ceteteh inu bahic saen ija ageca cocobi bilob maadem. Ceteh cunug ijanu Mosesna loo jena jaqeinca, je hahun madec dana agena jaqecna jaqeinca, odocob Samna jaqeinca eu mele ihoc caligian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Odimei uqa Anutna jaqec jenu wawaga fogo dugiannu cisdoc fogo duaden. ");
INSERT INTO aey_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Odimei maaden, “Anutna jaqec je edi madena, ‘Anutna Krais eu dain ben doc umei cal mecnadec deel cijeddocna haun ceseli cajigian. ");
INSERT INTO aey_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Odocob eu uqa ijanna dana cajaca agena silailnu tului falicdocobil Anut agena silail cagasiadecnu je qasali maadoqagan. Age Jerusalem ene sanan mimei mahamaha cunug ihoc ligiannu age me je qasali maadoqagan,’ ena. ");
INSERT INTO aey_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Age eu ceteteh i wele fein eunu qasali maadeiga. ");
INSERT INTO aey_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Dah meiga, ceteh oso Memige Anut suldocob ageca nigian ec je hahun maden eu ija sulduadigina. Euqa age ene taun benna sumudi bibilebil gagadic odoc ohisdec ageca nigian,” aden. ");
INSERT INTO aey_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Odimei uqa ehadi taun ben eu cuculdi Betani jobon odi nuein, odimei uqa eben suli umei eeladen. ");
INSERT INTO aey_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Uqa ono eelaaden Anut ehudeceb cuculadi sao jobon ten. ");
INSERT INTO aey_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Eu age gob cehi uqanu cuha fimeig haun Jerusalem ceelii ceseli belein. ");
INSERT INTO aey_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Odocob age saen cunugna tempelna Anut hetaga doc je madoloig. ");
INSERT INTO aey_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Wele gug qocna sao mahaca qee ifanecna je eu wele bilen. Je eu uqa Anutca bilen. Je eu Anut ijom. ");
INSERT INTO aey_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Gug qocna bahic je eu uqa Anutca bilen. ");
INSERT INTO aey_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Je euna dih Anut ceteteh cunug ifanen. Ceteh oso uqaca qee Anut ifanen eu qee bilel. ");
INSERT INTO aey_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Je eu uqa cebac bilecnu gug. Cebac bilec eu dananu fulacdoc ileten. ");
INSERT INTO aey_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Fulacdoc eu tuna fulacdona. Odocob tu eu fulacdoc cafuli qelecwe qee. ");
INSERT INTO aey_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anut uqa dana oso suldocob hon, ijan eu Jon. ");
INSERT INTO aey_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Uqa dana cajaca me je qasali maadecnu hon. Uqa fulacdocnu qasali maadeceb uqa umna fulacdoc eunu wawaga meleigiannu hon. ");
INSERT INTO aey_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dana eu uqadodoc fulacdoc qee, uqa fulacdocnu qasali maadecnu hon. ");
INSERT INTO aey_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Fulacdoc mele bahic dana cajaca cunug wawaga fulacadena eu mahana cali hugia odon. ");
INSERT INTO aey_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aria, je eu mahana bilen. Anut uqa je euna maha ifanen qa dana cajaca cunug mahana bilein age uqanu qee doloin. ");
INSERT INTO aey_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Uqa uqana gunna cali hon euqa uqana eundec age uqa qee oidelein. ");
INSERT INTO aey_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Euqa leih age uqa oidein age uqa ijannu wawaga meleen. Eunu uqa Anutna mel ibuldocnu gagadic odoc aden. ");
INSERT INTO aey_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Age Anutna mel cali hoin eu dana gale adecnafo, age dewenega gale docnafo anagail memegail golanagana qee basadelein euqa Anut uqadih odocna cali hoin. ");
INSERT INTO aey_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Je eu dana deweg ibuldumei ege gemona jo cehi bilen. Uqa Anut amegna me bilecca mele bilecca am bec. Ege uqana kobolkobol fom. Kobolkobol eu Memige Anut Melah osol uqana, Memige Anut uqa suldocob nen. ");
INSERT INTO aey_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon uqa uqanu je qasali madi utaen, “Ija qee cali hoc bibiligin uqa wele bilen. Eunu dana inu ija mamadi maadem, ‘Uqa ija hib tooti hona eu ija wooltec,’ adem,” en. ");
INSERT INTO aey_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","17","Anut uqa loo je Moses umna igen qa Anut uqa amegna me bilecca mele bilecca eu Jisas Krais umna igen. Eunu uqana Anut amegna me bilec am bec eunadec ege cunug eelgen. Eeldoc me bahic eu filfil igen. ");
INSERT INTO aey_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dana oso Anut qee fel. Anut Melah osol, eu uqaha Anut, uqa Memige Anut wowogonu bilina, uqa Anutnu mageceb dom. ");
INSERT INTO aey_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jon uqana qasali maadec eu odi. Juda agena ilo dana Jerusalemdec age dana leih ihanec danaca Liwaica suladecebil Jonca li sisildu madoin, “Hina in?” doin. ");
INSERT INTO aey_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Odocobil Jon je qee jahunadel qa uqa camasac qasali maaden, “Anutna Krais eu ija qee,” aden. ");
INSERT INTO aey_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Odocob age sisildoin, “Odiqa eeta odeia? Hina Ilaijafo?” doin. Odocobil uqa jejenega hewi maaden, “Qeeo, ija Ilaija qee,” aden. Odocob age sisildoin, “Hina je hahun madec dananu ege sumuduquna eufo?” doin. Uqaqa jejenega hewi maaden, “Eu qee,” aden. ");
INSERT INTO aey_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Odocob age haun sisildoin, “Odi qeefi hina in bahic magaga. Dana age sulgecebil hoqa eu hinadodocnu cel je magecem ege ageca ceseli li maadecnu madoqona,” doin. ");
INSERT INTO aey_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Odocobil Jon jejenega hewi maaden: “Ija jejeg oso uqa wadauna bibili utai maadena, ‘Tibudna jic tutuc mudeiga!’ adena. Eu odi weleca je hahun madec dana Aisaia uqa maden,” aden. ");
INSERT INTO aey_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Aria, dana age Jon sisildoin eu Farisi suladecebil hoin. ");
INSERT INTO aey_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Odocob age Jon sisildoin, “Hina Anutna Krais qeefi, hina Ilaijaha qeefi, hina je hahun madec dana euha qeefi eetanu dana cajaca wa joadagana?” doin. ");
INSERT INTO aey_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Odocob Jon jejenega hewi maaden, “Ija wana wa joadigina qa age gemona dana oso bilia eu age qee dogina. ");
INSERT INTO aey_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Eu uqa hib tooti hugian. Ija uqana cabi dana me bahic ihoc qee, ija uqa jaih tacec cufalitocwe qee,” aden. ");
INSERT INTO aey_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ceteteh i cunug Betani jobon Jodan wa naha ono isecna calen. Ono Jon dana cajaca wa jojoaadien. ");
INSERT INTO aey_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Deel osona Jon uqa Jisas uqaca hohon fimei maaden, “Feiga, Anutna Sipsip Nag ihen. Uqa dana cajaca cunug mahana bilegina agena silail cagasiadecnu hon. ");
INSERT INTO aey_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Dana inu ija wele maadem, ‘Ija qee cali hocna uqa bilen. Eunu dana oso ija hib tooti hona eu ija wooltec,’ adem. ");
INSERT INTO aey_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ijadodoc uqanu bahic qee dolom qa Isrel dana cajaca uqanu doqagannu ija wa jojoaadiem hom,” aden. ");
INSERT INTO aey_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Odimei Jon uqa je iha qasali maaden, “Ija Kis Gun cuhudid cinigwe sao jobonnadec ni uqaca bibilen fem. ");
INSERT INTO aey_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ijadodoc uqanu qee dolom qa Anut ija dana cajaca wana wa joadecnu sulteceb hom eu uqa maten, ‘Hina Kis Gun nimei dana osoca bibileb fimeg eu uqa Kis Gunna wa joadigian,’ ten. ");
INSERT INTO aey_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Eu oodon femnu dana i uqa Anut Melah eunu wele qasali maadem,” aden. ");
INSERT INTO aey_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Deel osona Jon uqa uqana malogom lecis gami tawein. ");
INSERT INTO aey_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tataweig uqa Jisas cocobi nunuen fimei maalen, “Fesia, Anutna Sipsip Nag ihen!” alen. ");
INSERT INTO aey_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Odocob malogom lecis eu ale odi maaleceb dosin eunu ale Jisas toodocobil belein. ");
INSERT INTO aey_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bebeleig Jisas qaalimei eu ale toododosin fecialimei sisilalen, “Eeta walesina?” alen. Odocob ale Jisas jejeg hewi madosin, “Rabai, (uqana gug eu ‘Iwaladec’) hina cel jona nijigina?” dosin. ");
INSERT INTO aey_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Odocobil maalen, “Belimeb fesiale,” alen. Odocob ale uqaca belimeig uqa bibilen fimesi eu wesu 4 kilok odinu deel eu uqaca bilein. ");
INSERT INTO aey_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Dana lecis ale Jon uqa Jisasnu maalen dah mimesi Jisas toodosin eundec oso eu Andru, uqa Saimon Pita waliag. ");
INSERT INTO aey_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Odocob uqa Jisas cuculdi limei uqa waliag Saimon gulucdumei madon, “Ege wele Mesaia gulucdoqan,” don. (“Mesaia” uqana gug eu Anutna Krais uqa Anutna dana caja cahahaadecnu wele nesili ehuden.) ");
INSERT INTO aey_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Odimei uqa ehudeceb Jisasca hosin. Odocobil Jisas uqa Pita mecidudu madon, “Hina ijain Saimon, Jon melah. Hibna age Kifas hoqagan,” don. (“Kifas” eu Aram jena. Age Grik jena falicdocobilfi eu “Pita.”) ");
INSERT INTO aey_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Deel osona Jisas Galili hatu ono nuigia bili caji nuen. Nuimei uqa Filip gulucdumei madon, “Hina ija tootaga!” don. ");
INSERT INTO aey_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip uqa Betsaidadec, eu Andru Pitaca alena jobondec. ");
INSERT INTO aey_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Odocob Filip uqa Nataniel gulucdumei madon, “Moses uqa loo jenaca je hahun madec dana ageca dana oso cali hugiannu jaqein eu ege gulucdoqan. Uqa Jisas Nasaretdec, Josef melah,” don. ");
INSERT INTO aey_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Odocob Nataniel sisildon, “Cel ceteh me oso Nasaretdec hugianfo?” don. Odocob Filip madon, “Ono limeu fegan,” don. ");
INSERT INTO aey_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Odocob Jisas uqa Nataniel uqaca hohon fimei uqanu maaden, “Feiga, eu dana Isreldec bahic, uhulec oso uqa waugna qee nijel!” aden. ");
INSERT INTO aey_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Odocob Nataniel uqa Jisas sisildu madon, “Hina adi ija dumaninu dumeg madagana?” don. Odocob Jisas jejeg hewi madon, “Filip qee li mahec ninijen hina na dan saluna bibilegen mecihem,” don. ");
INSERT INTO aey_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Odocob Nataniel uqa Jisas jejeg hewi madon, “O Meca, hina Anut Melah! Hina Isrel agena king!” don. ");
INSERT INTO aey_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Odocob Jisas madon, “Hina na dan saluna bibilegen mecihem ec mahigannu wawin meleenafo? Hina isi ceteh qila fagana eu wooldoc ceteteh caloqagan eu fegan!” don. ");
INSERT INTO aey_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Odi madumei maaden, “Ija je mele maadigina, age sao jobon hudec tataweb Anutna ensel age Dana Melahca toni tobi eebil foqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tu lecis hedocob Kena jobon Galili hatuna dana oso caja ocobocobecnu agena kobol toodu cegulimeig sab wainca jein. Jisas anag Maria uqaha ono li bilen. ");
INSERT INTO aey_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Euha Jisasca uqana malogom gami ono hoqagannu je sulduadecebil ageha hu bilein. ");
INSERT INTO aey_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bibilegin wain jecnu qee meceb Jisas anag uqa madon, “Agena wain qee meia,” don. ");
INSERT INTO aey_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Odocob Jisas uqa anag jejeg hewi madon, “Au, hina eetanu odi matagana? Ijana saen eu qee hoc nijia,” don. ");
INSERT INTO aey_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Odocob Jisas anag cabi dana maaden, “Uqa cel je maadeceb eu toodu odoigale,” aden. ");
INSERT INTO aey_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aria, ono age wa halon meenna mudec 6-pela mecebil tawoloi. Juda dana dewenega soidocnu kobol Mosesna loo je nijen eu odocnu meen halon tawoloi. Meen halon osolosol age wa 100 lita odi ilanocnu ihoc. ");
INSERT INTO aey_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Odocob Jisas cabi dana maaden, “Age meen halon eu wa o daneiga,” aden. Odocob age meen halon wa o danecebil bi am ben. ");
INSERT INTO aey_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Odimei maaden, “Qila wa naha wetimeig sab cilec cofdoc ehi li utecebil jeia,” aden. ");
INSERT INTO aey_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Age odi odocobil wa eu wain ibuldon eu uqa ji fen. Uqa wain anadec eu qee dol, cabi dana wa wetein eu ageqa doin. Odocob sab cilec cofdoc eu uqa dana caja oc eu utadocob hocob ");
INSERT INTO aey_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","madon, “Dana cunug age wain me bahic casac adecebil jegina, me eu geh ji hedocobil hibna me bahic qee eu adecebil jegina. Hinaqa me odoga, hina wain me bahic gesac mimeg qila i hewi ahoga!” don. ");
INSERT INTO aey_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Eu Jisasna kobolkobol odoc matu eu Kena jobon Galili hatu ono odon. Eu odocna uqa uqana kobolkobol ihacaden. Odocobnu uqana malogom uqanu wawaga meleen. ");
INSERT INTO aey_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Eu hedocob Jisasca, anag waliagulca, malogom gami Kapaneam jobon ni belein. Odimeig deel leih ono bilein. ");
INSERT INTO aey_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aria, Juda agena Pasowa Sab Jec Ben Deel cali hugia oodon, Jisas Jerusalem ono ten. ");
INSERT INTO aey_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jisas uqa tempel dunuhna dana age idadeegin gulucaden. Age bulmakauca, sipsipca, cuhudidca fafajegin dana ageha meen qaig wadacwuducdodogin feciaden. ");
INSERT INTO aey_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Odimei uqa halu matica cedimei luc cubusimei danaca, sipsipca, bulmakauca, tempelnadec qisaaadi ititacaden. Uqa meen qaig wadacwuducdoc dana agena cabal suli qeleceb agena qaig golodon. ");
INSERT INTO aey_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Odimei uqa cuhudid fajec dana maaden, “Meina jo idadec cudun cain muduwain! Ceteteh i cedadi ehi beleiga,” aden. ");
INSERT INTO aey_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jisas uqa odi odocob uqana malogom age Anutna jaqec jena je oso nijia cisdoin eu odi, “Hinana jonu ija deweni ninijec eu ji hedona,” en. ");
INSERT INTO aey_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jisas odi odocob Juda dana age Jisas sisildoin, “Hina odi odocnu nijiafo eu cel kobolkobol odoc ihacgecem feqan?” doin. ");
INSERT INTO aey_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Odocob Jisas jejenega hewi maaden, “Age tempel i wagalecebil tonecebfi ija deel cijedna haun cehigen,” aden. ");
INSERT INTO aey_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Odocob Juda dana age sisildoin, “Tempel i cehecnu sanan mimeig cabi oogin cabi gel 46 ihoc leceb hedumeig culein. Hina adi deel cijednadih tempel haun cehegan?” doin. ");
INSERT INTO aey_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Euqa Jisas tempelnu qee madel, eu uqa dewegnu maden. ");
INSERT INTO aey_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Eunu hibna uqa cal mecnadec ceseli cajeceb uqana malogom age Jisasna je inu dahiniga fogo docob age Anutna jaqec jenuca, Jisas je maden eunuca wawaga meleen. ");
INSERT INTO aey_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Odocob Jisas uqa Jerusalem ono Pasowa Sab Jec Ben saen bibilen dana matica age uqa kobolkobol oodon fimeig uqa ijannu wawaga meleen. ");
INSERT INTO aey_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Euqa Jisas uqa dana cunug dumanaga don. Eunu uqa dana eundecnu deweg qee nijel. ");
INSERT INTO aey_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jisas uqadodoc dana wawaga dunuhna ninijen don. Eunu uqa oso uqa hu dana agena gugnu je mateceb dugen odi madecnu qee nijel. ");
INSERT INTO aey_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ono Juda agena ilo oso ijan Nikodimas bilen. Uqa Farisi am eundec oso. ");
INSERT INTO aey_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dana eu witic osona uqa Jisasca humei madon, “O Meca, hina kobolkobol odogona eu oso odocwe qee, euqa oso Anut uqaca bilecebfi eu odocnu ihoc. Eunu hina iwalgec dana Anut sulheceb hom eu ege doqona,” don. ");
INSERT INTO aey_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Odocob Jisas uqa jejeg hewi madon, “Ija je mele mahigina, oso uqa haun qee basudecebfi uqa Anutna cul qee feiaun,” don. ");
INSERT INTO aey_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Odocob Nikodimas sisildon, “Dana ben mi hedocob eu adi haun basudigian? Uqa anag waug dunuh leceb haun basudecwe qee!” don. ");
INSERT INTO aey_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Odocob Jisas jejeg hewi madon, “Ija je mele mahigina, oso uqa wanaca kisnaca qee basudecebfi uqa Anutna cul dunuh lecwe qee. ");
INSERT INTO aey_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Oso dana cajaca gug tatawi basecebil cali hona eu dana deweg cebac ona. Oso Kis baseceb cali hona eu kis cebac ona. ");
INSERT INTO aey_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ija age cunug haun basadecnu ec mahiga eunu cain tumatumaagaun. ");
INSERT INTO aey_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fufu uqa ana isec nuigiannu gale dona eu odi nuina. Hina uqa fulufulueceb tebandogona qa anadec hona, ana nuina hina qee dogona. Dana cunug age kis basadeceb cali hogina euha odi bahic,” don. ");
INSERT INTO aey_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Odocob Nikodimas sisildon, “Ceteh i mataga eu adi cali hugian?” don. ");
INSERT INTO aey_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Odocob Jisas jejeg hewi madon, “Hina Isrel agena iwaladec osoqa, hina eu qee dogona, eu adi? ");
INSERT INTO aey_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ija je mele mahigina, ege doqona eunu maadoqona, ege fom eunu qasali maadoqona, euqa egena qasali maadec docnu culegina. ");
INSERT INTO aey_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ija ceteh mahanadecnu maadecemin wawaga mele qee el. Ija ceteh saonadecnu maadeceminfi adi wawaga meleigian? ");
INSERT INTO aey_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Oso sao jobonna qee ti calel. Dana Melah himec uqa sao jobonnadec toni nen,” don. ");
INSERT INTO aey_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","17","“Anut uqa Melah mahana dana agena silailnu gesiladigiannu suldocob qee nel qa mahana dana cahahaadeceb demico biluqagannu suldocob nen. Odocob Anut uqa dana cunug mahana bilegina nalunuga mimei cunug age uqanu wawaga meleigian eu age qee fadalowain qa age cebac bilec catanec eu oqagannu uqa melah osol himec culiaden. Eunu Moses uqa wadauna man sononec ihicon qoc suli u caqusenwe dana cunug age uqanu wawaga meleena eundec age cebac bilec catanec eu oqagannu Dana Melah age odi suli u caqusuqagan,” don. ");
INSERT INTO aey_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Oso uqa Melahnu waug meleena eu uqa gesildoc qee gulucdoiaun. Euqa oso uqa waug qee meleena uqa Anut Melah osol ijannu waug qee meleelnu eu uqa wele gesildoc oc bilina. ");
INSERT INTO aey_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","Gesiladecnu silig i edi. Fulacdoc mahana wele nen. Dana ageqa age cunug me qee odogina eu age fulacdoc sagagdogina. Odimeig age egena odoc camasac meiaun imeig fulacdocna qee hogina. Eunu agena odoc me qee nijianu fulacdoc eu cewudimeig tuna bilec gawegina. ");
INSERT INTO aey_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Osoqa uqa mele kobol odona eu fulacdocna hona. Eunu Anut cesuldocob uqa Anutna kobol toodu odona eu dana age camasac foqagan,” don. ");
INSERT INTO aey_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Saen eu hedocob Jisas uqana malogom gami Judia hatuna belimeig bilein. Ono bibili Jisas dana wa joaden. ");
INSERT INTO aey_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon uqaha Ainon jobonna wa mati bahic nijeinnu ono dana wa jojoaadi bilen. Ainon eu Salim jobon ono isec nijen. Dana cajaca uqaca liliein, uqa wa jojoaadien. ( ");
INSERT INTO aey_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Saen euna Jon gihacdoc jona qee mudec bibilen.) ");
INSERT INTO aey_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Saen euna Jonna malogom age Juda dana osoca age Juda agena kobolnu age dewenega gegehin mecdainnu wa joc oloig eunu togodudu fee dadanein. ");
INSERT INTO aey_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Odimeig age Jonca humeig madoin, “Meca, dana uqa wele, hina Jodan wa gesacna ono isec bibilegan, hinaca hon, hina uqanu je qasali magem eu uqadodoc dana wa joadena. Odocob dana cajaca cunug age uqaca legina!” doin. ");
INSERT INTO aey_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Odocob Jon jejenega hewi maaden, “Anut uqa sao jobon bilia uqa dana oso ceteh oso qee utecebfi dana eu ocwe qee. ");
INSERT INTO aey_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ija wele maadem, ija Anutna Krais qee. Anut sulteceb ija uqana aqunitoc hom eu agedodoc ijanu qasali mamadegin doin. ");
INSERT INTO aey_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Dana oso uqa caja ocob dana eu uqa caja eu gemug. Dana caja ona eu uqana danah eu tatawi caja gemug je madeceb dah mimei waug ceel bahic ena. Eunu ijaha qila ijana ceeli bilec ihoc lena. ");
INSERT INTO aey_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Uqa ijan eu meca caligian. Odocob ija ijani eu mahana tonigian,” aden. ");
INSERT INTO aey_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Dana ohisdec nen uqa dana cunug wooladec ohis bilina. Oso mahanadec hon eu mahanadec dana, uqa ceteh mahana nijia eunu je madena. Euqa oso sao jobonnadec nen uqa dana cunug wooladec ohis bilina. ");
INSERT INTO aey_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Uqa wele fifi dudu en eunu je qasali maadena euqa dana cajaca cunug age uqana qasali maadec culegina. ");
INSERT INTO aey_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Dana eu Anut suldocob nen eu uqa Anutna je madena. Ge, Anut uqana Kis eu ihoc lec utina. Eunu oso uqa ohisdec uqana qasali maadec dah mimei gagadicca hewena eu uqa je sisi mec odi madena, “Anut uqa mele bahic,” ena. ");
INSERT INTO aey_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Memige Anut uqa Melahnu nalug mena, uqana ceteteh cunug uqa ebenna muden nijia. ");
INSERT INTO aey_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Oso uqa Anut Melahnu waug meleena eu uqa cebac bilec catanec eu wele on. Oso uqa Anut Melah je madena eu toodu qee odona eu cebac bilec catanec qee feiaun qa Anutna gemag bec eu uqa deweg fagdona. ");
INSERT INTO aey_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Saen euna Farisi age Jisas uqa Jon wooldoc dana mati bahic uqana malogom ibuldogina, mati bahic wa joadena ec doin. Euqa Jisas uqadodoc dana qee wa joadel, uqana malogom agedih dana wa joadein. Odocob Tibud uqa je eu dumei Judia hatu culdimei Galili hatu ono ceseli nuen. ");
INSERT INTO aey_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Aria, uqana jic nuigiannu eu Sameria hatu gemona odi nuen. ");
INSERT INTO aey_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Uqa Sameria hatu gemona nuimei uqa taun oso hacna calen, ijan eu Sikar. Sikar isec maha oso nijen, maha eu weleca Jekob uqa melah Josef uqana bahic biligiannu uten. ");
INSERT INTO aey_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ono ha wa hunec oso nijen, eu ijan Jekobna wa hunec. Odocob Jisas uqa jic cobonnu siw muduga docob uqa wa hunecna isec bilen, saen eu cam tutuc cehec tatawen. ");
INSERT INTO aey_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jisasna malogom age sab fajoqagannu taun ono wele belein. Odocobil Sameriadec caja oso wa wetigiannu hocob Jisas madon, “Wa wetitaga jiga,” don. ");
INSERT INTO aey_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Odocob Judaca Sameriaca age sagagdocobdocob bileinnu caja eu madon, “Hina Juda dana, ija Sameriadec, adi wa wetihecnu matagana?” don. ");
INSERT INTO aey_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Odocob Jisas jejeg hewi madon, “O caja, hina bagol Anut uqa dana caja adena eu doummiqa, hinaha in maheia, ‘Wa wetitaga jiga,’ heia euha doummiqa hina uqa sisildoum, ‘Wa itiga,’ doum, uqa cebac bilec wa oso iheceb joum,” don. ");
INSERT INTO aey_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Odocob caja uqa madon, “Dana Ben, hina wa wetecnu halonca qee. Wa hunec euha dunuh bahic nijia. Hina cebac bilec wa eu anadec ogan? ");
INSERT INTO aey_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ege jajanige Jekob uqa wa hunec i igen. Uqaca, melahulca, uqana bulmakau sipsipca wa i joloig. Hina uqa wooldoc madaganafo?” don. ");
INSERT INTO aey_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Odocob Jisas jejeg hewi madon, “Cunug wa i jegina eu age haunhaun wa gab adena. ");
INSERT INTO aey_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Osoqa wa ija utecemin jigiaqa eu haun wa gab qee doiaun. Wa ija utecemin jigian eu ibuldumei uqa dunuhna cebac wa eu fifiji bibi nijigian. Wa euha cebac bilec catanec ocnu silig tawigian,” don. ");
INSERT INTO aey_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Odocob caja madon, “Dana Ben, ija haun wa gab teiaunnu, ijaha ene humig wa wetigaunnu wa eu ija itecem jiga!” don. ");
INSERT INTO aey_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Odocob Jisas uqa caja madon, “Cois, hina limeg gemun madocom ceseli hosiale,” don. ");
INSERT INTO aey_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Odocob caja jejeg hewi madon, “Ija gemunica qee,” don. Odocob Jisas madon, “Hina dana 5-pela cedadem. Qila dana osoca bilesina eu hina gemun qee, eu mele madaga. Eunu hina ija gemunica qee tagana eu tutuc madagana,” don. ");
INSERT INTO aey_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Odocob caja jejeg hewi madon, “O Dana Ben, hina je hahun madec dana eu dugina. ");
INSERT INTO aey_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ege memigeil age aluh ene tawena euna Anutnu cuha foloig, odocob age Juda dana madegina, ‘Jerusalem dih eu Anutnu cuha fecnu cudun,’ egina. Eu adi?” don. ");
INSERT INTO aey_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Odocob Jisas madon, “Caja, ijana jenu wawin meleeiale. Saen oso hona, saen euna dana age Memige Anutnu ene aluhna himec qee cuha fowain, odimeig Jerusalem ono himecha qee cuha fowain. ");
INSERT INTO aey_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Age Sameria dana cuha fec qa fegina, euqa cuha fegina eu uqana gug qee dogina. Cahahaadec silig eu Judadec cali hona. Eunu ege Juda dana ege cuha foqona, eu uqana gug doqona. ");
INSERT INTO aey_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Euqa saen oso hugian, saen euha wele hon nijia, saen ina dana mele cuha fegina age Memige Anutnu Kisnaca mele jenaca cuha foqagan. Dana eundec Memige Anutnu cuha fegina eu uqa gale dona. ");
INSERT INTO aey_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anut uqa kis. Odocob age uqanu cuha fegina eu age kisnaca, mele jenaca cuha fec bahic foqagan,” don. ");
INSERT INTO aey_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Odocob caja uqa Jisas jejeg hewi madon, “Mesaia uqa hona, age Krais dogina, eu ija dugina. Uqa humei uqa eu odocnu cunug iwalgigian,” don. ");
INSERT INTO aey_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Odocob Jisas madon, “Dana eunu madagana eu ija. Ija hina mahigina eu uqa ijom,” don. ");
INSERT INTO aey_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Odi madodon uqana malogom cali hoin. Odimeig age Jisas caja ica je mamadesin fimeig tumatumaein. Euqa age hina eeta gale hena, eetanu caja ica je madesina oso qee sisildu fel. ");
INSERT INTO aey_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Odocob caja eu uqana wa halon wa hunecna culimei ceseli taun limei ono dana maaden, ");
INSERT INTO aey_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Belimeig wa hunecna dana oso feigale, uqa ija ceteh cunug odom eu qasalteia. Uqa Anutna Kraisfa?” aden. ");
INSERT INTO aey_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Odocob dana age taun culimeig Jisasca lein. ");
INSERT INTO aey_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lelegin Jisasna malogom age Jisas cesusdudu madoin, “Meca, hina sab jagale!” doin. ");
INSERT INTO aey_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Odocob uqa maaden, “Ija sab jec osoca age eunu qee dogina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Odocob malogom agedodoc togodudu madein, “Oso hu sab uteceb jeiafo?” ein. ");
INSERT INTO aey_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Odocobil Jisas maaden, “Oso sulten uqa madena eu odocnuca, uqana cabi u hedocnuca eu ijana sab jec,” aden. ");
INSERT INTO aey_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Age jagel 4-pela hedocob cabina ceteteh wal meceb cedeqan ec qee madeginafo? Ija maadegina, age didii feiga, cabina ceteteh cedecnu wele wal migia odona! ");
INSERT INTO aey_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Oso wele ceteh cehen uqaca, oso wal men eu ceden uqaca osoben wawaga ceeleceb biluqagannu oso uqa cabinadec ceteh wal mec cedimei jo bisna mena eu cabinu ameg ona. Odimei uqa wal men eu cebac bilec catanecna ehi li mudina. ");
INSERT INTO aey_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Feiga, ene je oso ihoc lena, je eu ihen, ‘Oso cabi umei ceheceb, oso hu wal meceb cedena,’ je eu ihoc lena. ");
INSERT INTO aey_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ija age ceteh age cabi qee oloin, qee ceheleinca cabi eunadec cedoqagannu suladem. Leih age ono cabi cehein. Ageqa euna limeig agena cabi gagadic odocna cehein euna sab cedeiga,” aden. ");
INSERT INTO aey_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Caja uqa Jisasnu qasali maaden, “Uqa ija ceteh cunug ija odom eu qasalten,” aden eunu Sameria taundec dana matica age Jisasnu wawaga meleen. ");
INSERT INTO aey_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Eunu Sameriadec age Jisasca humeig ninidudu madoin, “Hina nag egeca biluqale,” doin. Odocobil Jisas uqa deel lecis ageca bilein. ");
INSERT INTO aey_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Odocob dana cajaca mati age Jisasna jenu wawaga meleen. ");
INSERT INTO aey_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Odimeig caja eu madoin, “Hina je magem eunu himec wawige meleec qee ihoc lel. Egedodoc uqana je dah mom. Uqa dana cajaca cunug mahana bilegina agena cahahaadec eu ege qila doqona,” doin. ");
INSERT INTO aey_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Jisas uqadodoc qasali maden, “Je hahun madec dana uqa uqana gug hatuna binanca qee,” en. Eunu uqa deel lecis Sameria gami bilimeig cuculadi Galili hatu ono nui cobon. ");
INSERT INTO aey_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Odocob Galili eundec ageha Jerusalem ono Pasowa Sab Jec Ben Deelna nui bilimeig kobolkobol cunug oodon fein. Eunu uqa Galili hatu ono caleceb uqa feele dumeig ageca bilecnu madoin. ");
INSERT INTO aey_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Odocob Jisas uqa haun ceseli Kena jobon Galili hatuna calen. Jobon euna wele uqa madeceb wa eu wain ibuldon. Kapaneam jobon ono kingna cabi dana oso bilen. Uqa melah hag ben umei nijen. ");
INSERT INTO aey_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Odocob uqa Jisas Judiadec Galili ene hon ec dumei melah uqa cal migia odonnu uqa Jisasca limei ninidudu madon, “Hina ijaca numeu ija melami me muditagale,” don. ");
INSERT INTO aey_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Odocob Jisas uqa jejeg hewi madon, “Age kobolkobol odocca gaga odocca qee fifeig age wawaga qee meleeiaun,” don. ");
INSERT INTO aey_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Odocob cabi dana eu Jisas madon, “O Dana Ben, nowale, melami qee cal mec ninijeb ono calowale,” don. ");
INSERT INTO aey_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Odocob Jisas madon, “Nugale, hina melem eu cebac biligian!” don. Dana eu Jisasna je waug meleeceb non. ");
INSERT INTO aey_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Uqa jobon nunu jicna uqana cabi dana bebegin gulucadeceb madoin, “Hina melem medoia cebac bilia!” doin. ");
INSERT INTO aey_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Odocobil uqa sisiladi maaden, “Cel saenna melami hag medoian?” aden. Odocob age madoin, “Eu cum wesu 1 kilokna uqana hag medoian,” doin. ");
INSERT INTO aey_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Age madecebil mel memeg uqa saen euna bahic Jisas maten “Hina melem cebac biligian,” ten ec cisdon. Odimei uqaca uqana eundec cunugca Jisasnu wawaga meleen. ");
INSERT INTO aey_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas uqa Judiadec Galili hatu ono limei odon eu kobolkobol odoc lecisdon. ");
INSERT INTO aey_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Eu hedocob Juda agena cuha fec deel gun oso cali hugia oodon Jisas uqa Jerusalem ono ten. ");
INSERT INTO aey_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Aria, Jerusalem meen gel alildocna jic cebec oso nijen, eu ijan Sipsip Jic Cebec. Euna isec wa fifiji bec gudoc nijina, eu Aram jena Betesda egina. Eu qeihna isec jo hamol 5-pela cehec tawen. ");
INSERT INTO aey_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Jo hamol euna dana caja hagca mati ono nijein. Eu age amaga galuc mecca, laleg mecca, dewenega me qee mecca nijein. Saen esuesu Tibudna ensel oso ni wa mulodon. Wa mulodocob oso cunug wooladi aquni wana toni wa jocob eu hag medoc on. Hag filfil aqen eu meaden. Eunu age cunug wana mulodoc saennu susumudi nijein. ");
INSERT INTO aey_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ono dana oso bilen eu hag umei cabi gel 38 ihoc lec gaid hag nijoloi. ");
INSERT INTO aey_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas uqa dana eu ninijen fimei uqa hag saen odi cecelacca nijina dumei sisildu madon, “Hina hag mehecnu gale henafo?” don. ");
INSERT INTO aey_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Odocob hag dana eu Jisas jejeg hewi madon, “Dana Ben, ija cesultec oso qee bilina. Wa mulodocob ija mahuc tonecwe qee. Tonecnu odocomin oso mahuc hu woolti tonimei wa jona,” don. ");
INSERT INTO aey_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Odocob Jisas madon, “Hina cajimeg hinana taeg umeg coboga,” don. ");
INSERT INTO aey_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mahuc bahic dana hag medocob caji uqana taeg umei jic cobon. Aria, deel Jisas uqa me muden eu Juda agena cuha deel. ");
INSERT INTO aey_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Euqa Juda dana age dana hag medon eu madoin, “Qila cuha deel, hina eetanu hinana taeg gahidogona? Egena loo je eu odi odocnu cain ec madena,” doin. ");
INSERT INTO aey_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Odocobil uqa maaden, “Dana uqa me mitia uqa mateceb ijana taeg umig cobigina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Odocob age sisildoin, “Dana eu hinana taeg umeg coboga heia eu in?” doin. ");
INSERT INTO aey_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dana mati bahic cudun euna beleinnu Jisas uqa filec isec nuen. Eunu dana hagca eu in uqa me muden eu qee dol. ");
INSERT INTO aey_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hibna Jisas uqa dana eu tempelna cocobon gulucdumei madon, “Faga, hina hag mehen. Ceteh me qee bahic eu wooldoc hinana hag dewenna hoiaunnu haun silail cain magaun,” don. ");
INSERT INTO aey_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Odocob dana eu nuimei Juda dana maaden, “Me miten eu Jisas,” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Odocob Juda dana age Jisas uqa Juda agena cuha deelna eu odonnu aqati toodoin. ");
INSERT INTO aey_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Odocob Jisas uqa Juda dana maaden, “Ija Mei gaid cabi oloi, qila ha cabi ona eunu ija ha cabi odi ugina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Age madein, “Cuha deelna loo je gadac tefacdon eu himec qee, uqa ha madena, ‘Anut uqa ija Mei,’ ena eunu uqadodoc uqa Anutca ele ihocihoc biluwuna ena,” ein. Odi madecebnu age Jisas qocnu geh cisdoin. ");
INSERT INTO aey_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","20","Eunu Jisas uqa Juda dana maaden, “Ija je mele maadigina, Anut Melah uqadodoc dih ceteh oso odocwe qee. Uqa Memige Anut oodon fena eu himec uqa odona. Memige Anut uqa Melahnu nalug mena. Uqa ceteteh cunug uqadodoc odona eu Melah ihacdona. Mele, age fimeig tumatumaoqagannu Memige Anut uqa ceteteh qila fegina eu ceteteh wooladec ihacdugian. Eunu Memige Anut odona eu himec Anut Melah odona. ");
INSERT INTO aey_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Memige Anut uqa cal mein eundec tuliadimei cebac bilec haun adenawe, odi Melah osooso uqadodoc cisdoc toodu cebac bilec haun adena. ");
INSERT INTO aey_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ge, Memige Anut uqa oso qee gesildona qa cunug age Memige Anut ijan saulal mudeginawe age Melah ijan ha odi saulal muduqagannu, uqa Melah gesiladigiannu cabi cunug culiton. Oso Melah saulal qee mudina eu uqa Memige, uqa Melah suldon, euha saulal qee mudina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ija je mele maadigina, oso ijana je dugiaqa, sulten eu uqana jenu waug meleigiaqa, eu uqa cebac bilec catanec wele on. Uqa gesildocna qee leiaun qa uqa cal mecnadec cebac bilecnana wele leti len,” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Ija je mele maadigina, saen hugian, saen eu wele hon bilia. Saen ina cal mein eundec age Anut Melahna jejeg dah moqagan. Dah mimeig eu age cajimeig cebac biluqagan. ");
INSERT INTO aey_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ge, Memige Anut uqadodoc cebac bilec gug bilina. Odiwe ha uqa Melah cebac bilec gug bilec culiton. ");
INSERT INTO aey_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Odocob Melah eu uqa Dana Melah eunu Memige Anut uqa Melah madon, ‘Cois, hina dana cunug gesiladecnu hina ebenna migina,’ don. ");
INSERT INTO aey_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Age inu cain tumatumaowain. Saen hugian, saen euna cunug age qalqalna nijegina uqa jejeg dah moqagan. ");
INSERT INTO aey_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Dumeig age cali hoqagan. Agena me odoc nijina eundec age cebac bilec catanec oqagan, me qee odoc nijina eundec age gesiladec me qee oqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jisas je haun maaden, “Ija ijana cisdoc toodu qee odigina qa sulten eu uqana cisdoc toodu odigina. Eunu ija cuhanuc ceteh oso odocwe qee. Memige mateceb dah migina eu toodu dana dewenega je ila mi gesiladigina. Deweneganu je eu madigina eu tutuc,” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ijanel ijana gugnu je qasali maadiginafi dana age qasali maadec inu meleecwe qee. ");
INSERT INTO aey_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Euqa oso ijana gugnu je qasali maadena. Uqa ijanu je qasali maadena eu mele je ija dugina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Agedodoc wele dana sos leih Jonca suladecebil li sisildocobil uqa ijanu je mele qasali maaden. ");
INSERT INTO aey_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Euqa ijana gugnu qasali maadec eu dana osonadec qee. Ijaqa je eu Anut age cahahaadecnu maadigina. ");
INSERT INTO aey_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon uqa gowoc, eu ileten. Age saen nag odi fulacdoc uqanadec cali hon euna celeboi cobocnu gale aden,” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Euqa ceteh oso ijana gug camasac mena eu Jon ijana gugnu je qasali maadec wooldona. Eu ijana odoc Memige Anut uqa odi hedocnu maten, odoc eu ija gaid odigina eu uqa sulten eunu camas mena. ");
INSERT INTO aey_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Memige Anut ija sulten, uqadodoc ijana gugnu qasali maaden. Age uqa jejeg qee dah melein, uqa deweg ha qee felein. ");
INSERT INTO aey_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Age uqa suldocob hon eu maadeceb wawaga qee meleel. Eunu uqana je ha wawagana qee bili cuhadona,” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Feiga, age Anutna jaqec je euna cebac bilec catanec oqan eginanu sasanijii uqana caun megegina. Euqa Anutna jaqec je eu ijana gugnu qasali madena. ");
INSERT INTO aey_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Euqa age cebac bilec catanec eu ocnu cemeni hoqagannu culegina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ija dana binani sulecnu qee madegina. ");
INSERT INTO aey_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Euqa agenu dugina, age Anutnu nalug mec eu wawagana qee nijel. ");
INSERT INTO aey_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ija Mei ijanna ageca hom, eu age ija qee oitelein. Oso uqadodoc ijanna hocobfi age eu oiduqagan. ");
INSERT INTO aey_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Age dana filfil age binanaga sulegina qa binanaga caunca osol Anutnadec ageca hocnu nijia eu ocnu wawaga qee hoolena. Euna adi wawaga meleec ihoc ligian?” aden. ");
INSERT INTO aey_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Age ija Memige Anut amegna agenu um qigen ec cain cisdowain. Oso uqa age deweneganu um qona eu Moses, uqa cesuladigian ec cisdogina. ");
INSERT INTO aey_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses uqa ijanu je jaqen nijia. Eunu age Mosesna loo jenu wawaga meleeialumi age ijana jenu ha wawaga meleoub. ");
INSERT INTO aey_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Euqa age je Moses jaqen nijia eunu wawaga qee meleecebfi age ijana jenu adi wawaga meleigian?” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Eu hedocob Jisas uqa Galili wa gad cagoc leti lan ono isec nuen. Wa gad cagoc eu ageha Taibirias egina. ");
INSERT INTO aey_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Eu dana cajaca mati bahic age Jisas dana hagcanu kobolkobol oodon feinnu uqa toodu belein. ");
INSERT INTO aey_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisas uqa ono aluh osona timei uqana malogom gami ono bilein. ");
INSERT INTO aey_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Aria, Juda agena Pasowa Sab Jec Ben Deel wele cali hugia odon. ");
INSERT INTO aey_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas uqa dana cajaca mati bahic uqaca hohogin feciadimei uqa Filip madon, “Ege bred age joqagannu ana fajeqan?” don. ");
INSERT INTO aey_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Uqa je eu Filip temdu figiannu madon. Uqadodoc odiodi odigen imei bilen. ");
INSERT INTO aey_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Odocob Filip madon, “Ege 200 kina odi bred fajiadocomunfi abesabes fan nag himec ocnu ihoc qee leiaun,” don. ");
INSERT INTO aey_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Odocob uqana malogom oso Andru, uqa Saimon Pita waliag, madon, ");
INSERT INTO aey_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mel haun oso ihen bilina, uqana bred 5-pela, cul dool lecisca nijia. Euqa nag bahic, dana matica adi ihoc ligian?” don. ");
INSERT INTO aey_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Odocob Jisas maaden, “Age dana cajaca maadecebil bileiga,” aden. Ono gigisac geh bahic nijennu dana euna bilein. Eu age dana 5,000 ihoc len. ");
INSERT INTO aey_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Bibilegin Jisas uqa bred eu umei Anut binan sulimei dana bilein eu siwiaden. Odimei cul doolha age jaga adenwe ihoc adecebil jein. ");
INSERT INTO aey_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Age cunug ihoc jecebil uqa uqana malogom maaden, “Jecefanaga culeiga nijia eu cain cusdowain. Cunug cedi gabandoigale,” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Odocob age bred 5-pela jimeig jecefanaga culein eu gabandu cedimeig galel 12-pela tacecebil ihoc len. ");
INSERT INTO aey_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Odocob dana cajaca age Jisas kobolkobol eu oodon fimeig madein, “Je hahun madec dana uqa mahana hugian ein eu uqa mele bahic ihen!” ein. ");
INSERT INTO aey_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisas uqa age hu colowandu hewimeig gagadic mumudi egena king muduqa ecebil fimei uqa cuculadi cuhanuc aluhna ti bilen. ");
INSERT INTO aey_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wesu memen Jisasna malogom Galili wa gad cagocna noin. ");
INSERT INTO aey_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Odimeig age wag tobimeig ceseli wa gad cagoc leti Kapaneam jobon ono belecnu odoin. Jisas ageca qee hoc ninijen witic men. ");
INSERT INTO aey_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Odocob fufu gagadicca hohon wa caji qahen. ");
INSERT INTO aey_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Malogom eu age wagna wa gemo 5-pela o 6-pela kilomita odi falandoig age Jisas wa tatacan cocobon wag cemenug hohon fein. Odocob age cucuiein. ");
INSERT INTO aey_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Euqa Jisas maaden, “Ija ihen. Age cain cucuiuwain,” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Odimeig age cois uqa wag tobigian ec madecebil mahuc bahic wag eu cudun ono leqan einna wele calen. ");
INSERT INTO aey_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Uqadec odi dana cajaca wa gad cagoc hagen naha isec bilein eu age wag osol himec cum odi ono tatawen fein. Age Jisas uqa wag qee tobel qa uqana malogom himec wag tobi belein eu feciadein. ");
INSERT INTO aey_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Euqa wag leih age Taibiriasdec age ono sab Tibud uqa Anut binan suleceb jein cudun euna cemenug hoin. ");
INSERT INTO aey_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Eunu dana cajaca age Jisasca uqana malogomca age ono qee meciadimeig age wag leih euna tobimeig wa gad cagoc leti Kapaneam jobon ono humeig Jisas wawali coboin. ");
INSERT INTO aey_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Dana cajaca age Jisas wa cagoc lan ono isec gulucdumeig sisildu madoin, “Meca, hina cel saenna ene hom?” doin. ");
INSERT INTO aey_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Odocob Jisas jejenega hewi maaden, “Ija je mele maadigina, age ija kobolkobol oodigin fein eunu qee walitelein qa age bred jimeig wawaga ihoc len eunu walitegina. ");
INSERT INTO aey_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Age sab qee migiannu nijia eu cain cabi owain qa age sab eu cebac bilec catanecna gaid bilina eu cabi oigale. Sab eu Dana Melah adigian. Ge, Memige Anut uqa Melahna uqana sisi mec men. Uqa Melahnu madi maden, ‘Melami ihen, uqa ijana odoc eu odona,’ en,” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Odocob age sisildu madoin, “Ege cel cabi oc oso Anut ege odocnu gale dona eu odeqan?” doin. ");
INSERT INTO aey_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Odocobil Jisas maaden, “Oso Anut suldon eu uqanu wawaga meleeiale odoc eu Anut gale dona,” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Odocob age haun sisildu madoin, “Hina cel kobolkobol oso eu odocom ege fimeb hinanu wawige meleigian? Hina cel cabi ogan? ");
INSERT INTO aey_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ege jajanigeil age wadauna manna jein. Ge, Anutna jaqec je eu odi tawena: ‘Uqa sao jobonnadec bred adeceb jein,’ ec tawena,” doin. ");
INSERT INTO aey_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","33","Odocobil Jisas maaden, “Ija je mele maadigina, Anutna bred eu Anut uqa suldocob sao jobonnadec nimei mahana bilegina eundec cebac bilec adena. Eunu Moses uqa bred sao jobonnadec qee adel. Ija Mei uqa sao jobonnadec bred mele bahic adena,” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Odocob age sisildoin, “O Tibud, gaidgaid bred eu igiga joqa,” doin. ");
INSERT INTO aey_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jisas maaden, “Ija cebac bilecnu bred. Oso ijaca hugiaqa haun wen qee doiaun. Oso ijanu waug meleeceb haun wa gab qee doiaun. ");
INSERT INTO aey_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Euqa age ija mecitein qa wawaga qee meleel ec maadem. ");
INSERT INTO aey_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Dana cajaca cunug Memige Anut itina eu ijaca hoqagan. Oso uqa ijaca hocob eu ija qee ititacdugaun. ");
INSERT INTO aey_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","40","Ija Mei uqa sulten eu uqana cisdoc eu odi. Cunug age Melah fecidumeig uqanu wawaga meleeceb eu age cebac bilec catanec eu oqagan. Odocob ija cit qoc deelna tuliadecemin caji cebac biluqagan. Uqana cisdoc euha odi. Dana cunug uqa iten eu ija oso qee culdugaun qa ija cunug cit qoc deelna tuliadecemin caji cebac biluqagan. Eunu ijana cisdoc toodu odocnu qee nelem qa uqa sulten eu uqana cisdoc toodu odocnu ija sao jobonnadec toni nem,” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Uqa ija bred sao jobonnadec toni nem ec maadeceb Juda dana age gonagona mi madein, “Eetanu uqa madena?” ein. ");
INSERT INTO aey_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Odimeig age madein, “Dana i uqa Jisas qeefo? Eu Josef melah, uqa anag memegcanu doqona. Eu adi uqa qila madena, ‘Ija sao jobonnadec toni nem,’ ena?” ein. ");
INSERT INTO aey_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","44","Odocobil Jisas jejenega hewi maaden, “Oso uqadodoc ijaca hocnu ihoc qee nijel. Memige Anut uqa ija sulten, uqa himec dana cecel qudocob ijaca hona. Qeefi, oso ijaca hocnu ihoc qee. Eunu age cain gonagona mecebmecebowain. Odocob dana eu ija cit qoc deelna tulidocomin caji cebac biligian. ");
INSERT INTO aey_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ge, je hahun madec dana age agena jaqec je odi jaqein: ‘Anut uqa cunug iwaladigian,’ ein. Age abesabes Memige Anut iwaladeceb doin eu age ijaca hogina. ");
INSERT INTO aey_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Euqa dana oso uqa Memige Anut qee fel. Oso uqa Anutnadec hon eu uqa himec Memige Anut fen. ");
INSERT INTO aey_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ija je mele maadigina, oso ijanu waug meleena eu uqa cebac bilec catanec wele on. ");
INSERT INTO aey_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ija cebac bilec catanecnu bred. ");
INSERT INTO aey_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Age jajanagail wadauna manna jein qa age cal mein. ");
INSERT INTO aey_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Euqa bred sao jobonnadec nena eu edi, oso uqa jigian eu uqa qee cal meiaun. ");
INSERT INTO aey_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ija cebac bilec bred eu sao jobonnadec nen. Oso bred i jifei uqa cebac bileceb catanigian. Bred ija adigina eu ija deweni, eu dana mahana bilegina age jimeig cebac biluqagannu bred,” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Odi maadeceb Juda dana age fee dadani madein, “Dana i adi uqa deweg eu jeqannu igigianfo?” ein. ");
INSERT INTO aey_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Odocobil Jisas maaden, “Ija je mele maadigina, age Dana Melah deweg golacca qee jifeig age cebac bilec wawagana qee bilel. ");
INSERT INTO aey_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","56","Ija deweni eu sab bahic, ija golani eu wa gab jecnu bahic. Eunu oso ija deweni golanica jena eu uqa ija dunuhna bilina. Odocob ija uqa dunuhna biligina. Oso deweni golanica jifei uqa cebac bilec catanec uqanu nijia. Odocob cit qoc deelna tulidocomin caji cebac biligian. ");
INSERT INTO aey_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Memige Anut cebac bilec gug bilina, uqa ija sulteceb ijaha uqanu cebac biligina. Eu odiwe oso uqa jeitina eu uqa ijanu cebac biligian. ");
INSERT INTO aey_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bred sao jobonnadec toni nen eu ihen. Eu age jajanagail jimeig cal mein cinigwe qee. Oso uqa bred i jigiaqa uqa cebac bileceb catanigian,” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Je eu Jisas uqa Juda agena cuha jona Kapaneam ono iwalaadi bilei maaden. ");
INSERT INTO aey_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jisasna malogom mati bahic age je eu dumeig madein, “Je eu dudca bahic. In je eu dah mecnu gale dona?” ein. ");
INSERT INTO aey_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Euqa Jisas uqa qee dah mec uqana malogom age uqana jenu gonagona memegin dumei maaden, “Se, je eunu wawaga cacaden bileginafo? ");
INSERT INTO aey_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Age Dana Melah wele biloloi euna haun ceseli teteb fifeig age adi cisdoqagan? ");
INSERT INTO aey_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kis uqa cebac bilec adena, deweg ganac uqadodoc cebac qee bilel. Je ija maadiga eu kisca cebac bilecca. ");
INSERT INTO aey_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Euqa age gemona leih bilegina age wawaga qee meleec nijia,” aden. Ge, Jisas uqadodoc hahawannadec dana wawaga qee meleec nijia, age uqa uqana cad ebenegana men eu uqa don. ");
INSERT INTO aey_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Odimei uqa haun maaden, “Gug odi nijianu ija maadem, oso uqadodoc ijaca hocnu ihoc qee nijel. Memige Anut odudeceb ijaca hocnu ihoc eu ijaca hugian,” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Je i madecebnu uqana malogom mati age Jisas culdimeig Jisas ceseli haun qee toodu coboloin. ");
INSERT INTO aey_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Odocobil Jisas uqa malogom 12-pela sisiladi maaden, “Ageha cuculti beloqaganfo?” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Odocob Saimon Pita uqa jejeg hewi madon, “O Tibud, hina cebac bilec catanecnu je magagana. Ege qila hina Anutna Gundec eunu wawige meleena, eu ege du cuhadoqona. Eunu ege inca belecnu?” don. ");
INSERT INTO aey_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Odocobil Jisas jejenega hewi maaden, “Ija age 12-pela ijana malogomnu wele nesiladi qee cedelemfo? Euqa age oso eu Setenna eundec!” aden. ");
INSERT INTO aey_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Uqa Judas eu Saimon Iskariot melahnu maden. Ge, uqa malogom 12-pela oso hibna Jisas uqana cad ebenegana men. ");
INSERT INTO aey_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Eu hedocob Juda dana age uqa qoqaga bili odoin eunu Jisas uqa Judia hatuna cobocnu culen. Odimei uqa Galili hatuna lili huhui cobon. ");
INSERT INTO aey_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Saen euna Jerusalem ono Juda agena sab jec ben deel oso uqa ijan Talah Jo Sab Jec Ben eu cali hugia odon. ");
INSERT INTO aey_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Odocob Jisas waliagulha uqanu wawaga mele qee el. Eunu age Jisas madoin, “Oso uqa ijanca bilecnu gale dona eu jahunecna qee cobona. Hina ceteteh i odogona eu dana cajaca amagana camasac odogale! Hinana malogom age hina kobolkobol oodom foqagannu hina cajimeg Judia hatuna nuuga,” doin. ");
INSERT INTO aey_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Odocob Jisas uqa jejenega hewi maaden, “Ija odocnu saen qee cali hol euqa age odocnu saen ilag nijia. ");
INSERT INTO aey_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mahanadec eundec age sagagadecnu qee nijel. Euqa ija mahanadec age agena odoc casisic nijia eu amemeg qasali maadiginanu ija sagagtegina. ");
INSERT INTO aey_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ijana saen qee ihoc lel. Ija cegulec euna qee tigaun. Euqa agedodoc gad sab jec bennu teigale,” aden. ");
INSERT INTO aey_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Uqa odi maadimei Galili hatu ono bilen. ");
INSERT INTO aey_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Euqa uqa waliagul sab jec bennu tecebil uqaha ten. Eu camasac qee cobol uqa jahuni cobon. ");
INSERT INTO aey_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Juda dana age sab jec bennana Jisas wawali cocobi madein, “Dana eu ana bilia?” ein. ");
INSERT INTO aey_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Dana cajaca mati bahic age uqanu gehgeh jahjahilein. Leih madein, “Uqa dana me bahic,” ein qa leih madein, “Qeeo, uqa dana cajaca jic cahuldocna iwaladenanu,” ein. ");
INSERT INTO aey_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Euqa age Juda dananu cucuiimeig uqanu amemeg qee mamadielein. ");
INSERT INTO aey_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sab jec ben eu naha isec qee migiannu oodon Jisas uqa tempelna timei iwaladi maaden. ");
INSERT INTO aey_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Uqa je maadeceb dumeig Juda dana age tumatumai madein, “Meca oso dana i qee iwaldol. Eunu dana i adi loo je jaqec sildiadecnu fena?” ein. ");
INSERT INTO aey_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Odi madecebil Jisas maaden, “Ija iwaladigina eu ijana je qee, sulten eu uqana je maadigina. ");
INSERT INTO aey_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Oso uqa Anut madena eu ija toodu odigen ena eu uqa ija madigina eu Anutnadecfo, qee ijanadec eu cel gugnu du cuhadugian. ");
INSERT INTO aey_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Oso uqa uqana je madena eu uqadodoc binan wasigiannu odona. Osoqa uqa suldon eu binan wasigiannu odona eu uqa je mele madena, uqa uhulec je qee madena,” aden. ");
INSERT INTO aey_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Moses age loo je aden. Euqa age eundec oso uqa loo je eu qee toodu odona. Age eetanu ijanu madi qoqan egina?” aden. ");
INSERT INTO aey_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Odocob dana am age madoin, “In hina qihecnu madena? Buga me qee oso hinaca bilia,” doin. ");
INSERT INTO aey_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Odocob Jisas jejenega hewi maaden, “Ija kobolkobol osol ene odocom age cunug eunu tumatumaegina. ");
INSERT INTO aey_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses uqa age melemegail dewenega cagu qoc kobol eu aden. (Mele, kobol eu Mosesnadec qee qa eu jajanagailnadec.) Odocob eu toodu melemegail cuha deelna dewenega cagu qoginanu. ");
INSERT INTO aey_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Age Mosesna loo je tefacdoqaun imeig mel cuhana dewenega gaga qoginafi age eetanu ijanu ija dana deweg cunug cuhana me mudem eunu gemanaga bena? ");
INSERT INTO aey_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Amagana dih fimeig odoc eu me qee ecnuca odoc eu me ecnuca cain gesiluwain. Odocna silig tutuc fimeig eu mefi cois eigale, me qee fimeig eu cois qee eigale, eu odi gesileiga,” aden. ");
INSERT INTO aey_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Odocob dana leih Jerusalemdec madein, “Dana i age qoqan egina eu uqa qeefo? ");
INSERT INTO aey_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Feiga! Uqa amemeg tatawi je maadena, oso qee cahacdona! Dana ben age uqa Anutna Krais eu mele bahic doginafo? ");
INSERT INTO aey_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Euqa dana i uqa anadec hon eu ege doqona. Anutna Krais hocob uqaqa anadec hon eu oso qee doiaun,” ein. ");
INSERT INTO aey_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Odocob Jisas tempelna iwalaadei utai maaden, “Mele, age ijanu dogina, ageha ija anadec hom ec doginafo? Euqa ijadodoc ene qee holom. Sultec uqa mele bahic bilina, uqa ija sulten eu age qee dogina. ");
INSERT INTO aey_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ija uqanadec hom, eu uqa ija sulten. Eunu ija uqa dugina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Odocob age uqa hewecnu togodoin. Euqa uqana saen qee ihoc lelnu oso uqa hewecnu qee odol. ");
INSERT INTO aey_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Euqa dana cajaca am gemogemo mati age Jisasnu wawaga meleec oin. Age madein, “Anutna Krais uqa humei uqa kobolkobol odoc dana i odon wooldu odigianfo?” ein. ");
INSERT INTO aey_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisi age dana am jahjahili Jisasnu je odi togododogin dah mein. Eunu ihanec dana benbenca, Farisi ageca age tempel cofdoc Juda dana leih Jisas hewoqagannu suladein. ");
INSERT INTO aey_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Oodogin Jisas uqa dana maaden, “Saen gohic bahic ija age gami bilimig ija sulten eu cemenug ceseli ligen. ");
INSERT INTO aey_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Odocomin age ija waltimeig qa qee guluctuwain. Ija nuigen euna age lecwe qee,” aden. ");
INSERT INTO aey_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Odocob Juda dana age togodudu madein, “Ege uqa qee gulucdoqaunnu uqa ana nuimei biligian? Uqa Juda dana age Grik agena hatuna budu belein bilegina euna nui bilimei Grik dana je iwaladigianfo? ");
INSERT INTO aey_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Uqa madena, ‘Age ija waltimeig qa qee guluctuwain. Ija nuigen euna age lecwe qee,’ ena je eu cel gug?” ein. ");
INSERT INTO aey_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sab Jec Ben Deel cit qocna sab jec ben eu uqana deel cunug wooladi saulal mudein, deel euna Jisas tawi utaadi maaden, “Oso wa gab docob uqa ijaca humei jeiale. ");
INSERT INTO aey_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Eu odi Anutna jaqec je madenawe, ‘Oso uqa waugnadec cebac bilec wa eu nigian,’ enawe oso ijanu waug meleena eu uqa odi odigian,” aden. ");
INSERT INTO aey_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas uqa je eu Kis Gunnu maden. Saen euna Jisas uqa Anut cemenug uqana kobolkobol ocnu qee tel. Eunu Kis Gun eu age Jisasnu wawaga meleec age oqagan eu Anut qee adel. ");
INSERT INTO aey_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Odocob dana age je eu dah mimeig eundec leih madein, “Dana i uqa je hahun madec dana ege sumuduquna eu mele bahic,” ein. ");
INSERT INTO aey_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Odocobil leih madein, “Uqa Anutna Krais,” ein. Euqa leih madein, “Anutna Krais uqa Galilidec hugianfo? ");
INSERT INTO aey_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Anutna jaqec je eu Anutna Krais uqa Dewid sihulnadec, Betlehem jobondec ono Dewid bilen eunadec cali hugian ec madena,” ein. ");
INSERT INTO aey_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Eunu dana cajaca age Jisasnu wawaga filigandu tawein. ");
INSERT INTO aey_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Leih age uqa hewecnu cisdoin, euqa oso uqa hewecnu qee odol. ");
INSERT INTO aey_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tempel cofdoc dana ihanec dana benbenca Farisica suladein eu age ihanec benbenca Farisica gauc ageca ceseli hoin. Odocob agena ben sisiladi maaden, “Eetanu age uqa qee hewi aholoin?” adein. ");
INSERT INTO aey_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Odocobil tempel cofdoc dana maadein, “Dana i je madena eu wele oso uqa ihoc qee madel,” adein. ");
INSERT INTO aey_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Odocob Farisi age dana eu maadein, “Uqa ageha qauadeiafo? ");
INSERT INTO aey_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Juda dana ben osoca, Farisidec dana osoca uqanu wawaga meleenfo? Qeeo! ");
INSERT INTO aey_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Dana cajaca am gauc iqa age loo je qee dogina, age Anut geladen bilegina,” adein. ");
INSERT INTO aey_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Odi madecebil Farisi dana oso, Nikodimas, uqa wele witic osona Jisasca leceb je madesin, eu uqa maaden, ");
INSERT INTO aey_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Egena loo je odi qee madel, ‘Dana oso gauc gesildoiga,’ el. Uqa madena, ‘Dana oso age um qudegina casac uqa uqana je madeceb gesileiga. Age uqa eeta odon ec sisildu feiga,’ ena,” aden. ");
INSERT INTO aey_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Odi maadeceb age madoin, “Hinaha Galilidecfo? Loo je jaqec sasaniji megagale. Odimeg je hahun madec dana Galilidec qee hoiaun eu fegan,” doin. Grik jaqec je hilah leihna age but i 7.53-8.11 eu qee nijel.  ");
INSERT INTO aey_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Odi madimeig qaciti agena gunna beladi hedoin. ");
INSERT INTO aey_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Euqa Jisas Oliw Aluhna nui bilen. ");
INSERT INTO aey_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Uqadec qasil walag dadanen uqa tempelna haun nuen. Odocob dana cajaca cunug uqaca hocobil uqa bilimei je iwaladen. ");
INSERT INTO aey_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Odocob loo je iwaladec dana Farisica age caja oso ehudi ahoin. Caja eu age uqa gemug culdimei dana oso silail mecnu fanindodon gulucdoin. Age caja eu Jisas amegna mudimeig ");
INSERT INTO aey_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","madoin, “Iwalgec, caja i uqa dana osoca silail memesin age gulucdoiga. ");
INSERT INTO aey_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Egena loo jena Moses maden caja i odeiawe odogina eundec meen qeli aqecebil cal meiga ena. Hina eeta madagana?” doin. ");
INSERT INTO aey_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Je eu uqa temdocnu madoin. Age uqa je oso Mosesna loo je tefacdocnu madeceb dewegnu um qoqan ein. Odocobil Jisas uqa du qahimei ebenna maha gaga qon. ");
INSERT INTO aey_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Age haunhaun sisildocobil uqa caji tawimei maaden, “Age oso silailca qee eu li meen hewi caja eu qocnu sanan meiale,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Maadimei uqa haun bilimei ebenna maha gaga qon. ");
INSERT INTO aey_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jisas je eu maadeceb dumeig age abesabes besibesi belein. Matu casac nueceb oso ageha toodu beladi hedoin. Jisas uqa caja ica lecis himec culalecebil bilesin. ");
INSERT INTO aey_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Odocobil Jisas caji tawimei caja sisildu madon, “Dana eu age ana? Oso hina qee gelihelfo?” don. ");
INSERT INTO aey_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Odocob caja madon, “Tibud, qeeo, oso qee gelitel,” don. Odocob Jisas madon, “Ijaha qee gelihelem. Nuimeg silail haun cain magaun,” don. ");
INSERT INTO aey_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas uqa Farisi haun je maaden, “Ija mahamahanu fulacdoc. Oso ija tooti cobona eu uqa tuna qee coboiaun qa cebac bilecnu fulacdoc uqana biligian,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Odocob Farisi age madoin, “Hina hinadodocnu je qasali madagana! Hinana qasali madec eu meleca qee,” doin. ");
INSERT INTO aey_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Odocobil Jisas jejenega hewi maaden, “Ija anadec hom, ana nuiginaca eu dugina. Ageqa ija anadec hom, ana nuiginaca eu qee dogina. Eunu ijanelnu je qasali madiginafiqa ijana qasali madecha mele tawena. ");
INSERT INTO aey_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Age mahana kobolna dana gesiladegina. Ijaqa dana oso qee gesildugina. ");
INSERT INTO aey_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Euqa ija oso uqana odoc eu mefo, qee me qeefo ec madiginafi ija cuhanuc qee je gesiligina. Euqa Memige Anut uqa sulten uqa ijaca je gesiluwuna. Eunu ija je gesilec tutuc madigina. ");
INSERT INTO aey_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Agena loo jena je oso nijia eu odi, dana lecis ale dana oso gesiladec jona tawena uqana odocnu je wawala osol qasali madecebilfi alena je qasali madesina eu meleec taweia en. ");
INSERT INTO aey_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ija ijanelnu je qasali madigina. Memige Anut uqa ija sulten uqaha ijanu je qasali madena,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Odocob age sisildoin, “Hina memen ana bilia?” doin. Odocobil Jisas maaden, “Age ijana gugnuca Meinuca qee dogina. Age ijanu doubmiqa ija Meinu ha doub,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas je eu meen qaig helecnu cudaug euna hamol tatawi tempelna iwalaadi maaden. Euqa uqana saen eu qee holnu oso qee hewi gihacdoc jona mudel. ");
INSERT INTO aey_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas uqa je haun ceseli dana maaden, “Ija li nuigen. Age ija waliti cobimeig qa age dewenega silail fagadec eunu cal moqagan. Ija nui biligen euna age belecnu ihoc qee,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Odocob Juda dana madein, “Uqa maden, ‘Ija nui biligen euna age belecnu ihoc qee,’ en. Uqa adi? Uqadodoc deweg qu cal migian imeifo eunu madena?” ein. ");
INSERT INTO aey_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Odocobil Jisas maaden, “Age mahanadec, ija ohisdec. Age maha qila bilina eunadec qa ija maha inadec qee. ");
INSERT INTO aey_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Age ija uqa eunu wawaga qee meleecebfi age dewenega silail fagadec eu odi cal moqagan. Eunu ija age dewenega silail fagadec eu odi cal moqagan ec maadiga,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Odocob age madoin, “Hina in?” doin. Odocobil Jisas jejenega hewi maaden, “Ija sanan mecnadec maadem eu haun ceseli madigina. ");
INSERT INTO aey_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ija agenu je mati bahic maadecnuca, agenu je gesiladecnuca nijia. Euqa ija sulten uqana je eu mele bahic. Ijaqa uqa mateceb dom eu dana cajaca mahana bilegina eu amagana maadigina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Juda dana age Jisas uqa Memige Anutnu maaden eunu wawaga qee fogo dol. ");
INSERT INTO aey_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Eunu Jisas haun maaden, “Age Dana Melah caqusecebil caculeceb age ija ijanu ec madigina eu wawaga camasac fogo dugian. Age ijadodoc cisdoc toodu ceteh qee odigina qa ija Memige Anut iwalten eu odi himec je madigina eunu ha wawaga fogo dugian. ");
INSERT INTO aey_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ija sulten eu ijaca biluwuna. Uqa gale dona eu ija gaid odigina eunu uqa ija cuhanuc qee cultel,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisas uqa je odi maadeceb dana mati uqanu wawaga meleen. ");
INSERT INTO aey_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Odocob Jisas uqa Juda dana age uqanu wawaga meleen eundec maaden, “Ija age je maadigina je eu toodu gaid biluqagaqa age mele ijana malogom biluqagan, ");
INSERT INTO aey_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","age mele jenu wawaga fogo dugian, odocob mele je eu besiadigian,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Odi maadeceb age madoin, “Ege Ebraham sihuldec. Ege osona begabeg meh qee bilolom. Hina eetanu magagana, ‘Age besiadec biluqagan’ agana?” doin. ");
INSERT INTO aey_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Odocobil Jisas jejenega hewi maaden, “Ija je mele maadigina, oso uqa silail mena eu uqa silailna begabeg meh cabi dana. ");
INSERT INTO aey_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Begabeg meh uqa gaid uqana benna jona qee biliaun qa benna mel uqa uqana jona gaid bilina. ");
INSERT INTO aey_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Eunu Anut Melah uqa age begabeg meh biluwainnu besiadecebfi age mele bahic besiadec biluqagan,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Ija age Ebrahamna sihuldec ec dugina euqa ijana je wawaga qee fagdona eunu age ijanu madi qoqan egina. ");
INSERT INTO aey_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mei ihacteceb fem eunu maadigina. Ageha age memega iwaladeceb doin eu age odogina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Odocob age jejeg hewi madoin, “Ebraham uqa ege memige,” doin. Odocobil Jisas maaden, “Age mele bahic Ebrahamna mel bileigalumi age Ebraham odon eu odiwe odoub. ");
INSERT INTO aey_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ija mele je eu Anut mateten dom eu maadem. Qilaqa age ijanu madi qocomun cal migian egina. Ebraham uqa odi qee odol. ");
INSERT INTO aey_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Age memega bahic odon eu ageha odogina,” aden. Odocob age madoin, “Ege sasail caja uqa melahul qee! Ege memige osol bilina eu uqa Anut himec,” doin. ");
INSERT INTO aey_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Odocobil Jisas maaden, “Ija Anutnadec hom, ene biligina. Ija ijadodoc odocna qee holom qa uqa sulteceb hom. Eunu Anut uqa mele age memega bilialumi age ija naluni moub,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","“Age eetanu ija je maadigina eunu wawaga qee fogo dona? Age je ija maadigina eu dah mecnu culegina eunu wawaga qee fogo dona. ");
INSERT INTO aey_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ageqa memega Setenna mel bilegina. Memega eu waug gale dona eundec age toodocnu gale adena. Gug qoc saennadec uqa dana aqecnu tawena. Mele je madec eu uqa waugna qee tawel. Eunu uqa mele je qee madena. Uqa uhulec je madec dana, cunug age uhulegina eu agena memega. Eunu uqa uhulec je madena eu uqadodoc duman toodu madena. ");
INSERT INTO aey_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ijaqa mele je maadigina eunu age ijana jenu wawaga qee meleena. ");
INSERT INTO aey_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Age eundec oso in ija silail mimigin meciten uqa ene hu madeia? Ija je mele maadigina, eetanu age wawaga qee meleena? ");
INSERT INTO aey_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Oso uqa Anutnadec eu uqa Anutna je dah mena. Ageqa Anutnadec qee eunu ijana je qee dah megina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Odocob Juda age Jisas madoin, “Ege hina Sameriadec dana buga me qee oso hinaca bilina ec hoqona eu mele qeefo?” doin. ");
INSERT INTO aey_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Odocobil Jisas jejenega hewi maaden, “Buga me qee ijaca qee bilina. Ija Mei binan suligina, ageqa ija cewitegina. ");
INSERT INTO aey_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ijadodocqa ija binani wasigiannu qee odigina. Oso ija binani wasigiannu odona eu uqa ija gesilitigian. ");
INSERT INTO aey_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ija je mele maadigina, oso ijana je waugna tacena eu cal mec bahic qee feiaun,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Odocob Juda madoin, “Ege qila buga me qee hinaca bilina ec mele doqona! Ebraham wele cal men, je hahun madec dana ageha wele cal mein. Hinaqa madagana, ‘Oso ijana je waugna tacena eu cal mec qee feiaun,’ agana. ");
INSERT INTO aey_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Hina ege memige Ebraham wooldoc biliginafo? Uqa cal men, je hahun madec dana ageha cal mein. Hina cel dana ec madagana?” doin. ");
INSERT INTO aey_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Odocobil Jisas jejenega hewi maaden, “Ija ijadodoc binani suliginafi ija binani gauc suligina. Eu ija Mei, uqanu age uqa egena Anut egina, eu ija binani sulina. ");
INSERT INTO aey_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Euqa age uqanu qee doloin qa ija uqa dugina. Ija uqa qee dugina ec madoummiqa age uhulec dana bileginawe ijaha odi uhulec dana biloum. Euqa ija uqa dugina, uqana je hewi toodu odigina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Age memega Ebraham uqa ijana saen cali hocob figiannu ceelen. Uqa fimei celeboen,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Odi maadeceb madoin, “Hina cabi gel 50 qee ihoc lel, hina Ebraham femfo?” doin. ");
INSERT INTO aey_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Odocobil Jisas maaden, “Ija je mele maadigina, Ebraham qee cali hoc ninijen ija bilem,” aden. ");
INSERT INTO aey_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jisas uqa odi maadeceb age meen qeli qoqan imeig meen cedein qa Jisas uqadodoc jahunimei tempel culdimei nuen. ");
INSERT INTO aey_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas uqa cocobi nunui bilei uqa dana oso uqa anag waugnadec ameg galuc men odi cocobi ben men bibilen fen. ");
INSERT INTO aey_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Uqana malogom Jisasca li sisildu madoin, “Meca, dana i uqa anag waugnadec ameg galuc mec cali hon eu in silail meceb odi odon? Uqa silail menfo, qee memegfo anagfo silail mesin eunu uqa ameg galuc mec cali hon?” doin. ");
INSERT INTO aey_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Odocobil Jisas maaden, “Dana eu anag waugnadec ameg galuc mec cali hon eu uqa silail mecebnu qee, memeg anagca alena silailnu ha qee. Anutna cabi oc uqa dewegna camas migiannu eunu ameg galuc mec cali hon. ");
INSERT INTO aey_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Cahineg nijia eunu ege sulten eu uqana cabi ege odoc bahic odoqan. Witic migian, saen euna cabi ocnu oso qee nijiaun. ");
INSERT INTO aey_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Saen ija mahana bibili ija mahamaha fulacdoc biligina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jisas odi maadimei uqa maha cin qumei sahalicna olig ibuldumei u dana amegna cucusimei ");
INSERT INTO aey_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","madon, “Hina Siloam wa cagocna limeg hina amen wasacudagale,” don. (Siloam uqana gug eu “Suldon.”) Odocob dana eu li ameg wasacudeceb ameg fogo docob ceseli hon. ");
INSERT INTO aey_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Odocob dana age dana eu muduban bilec ageca, wele uqa niniadi bibilen mecidoin euca madein, “Dana i uqa wele bibili sabnuca qaignuca ninigoloi eu qeefo?” ein. ");
INSERT INTO aey_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Leih madein, “Eu uqa,” ein qa leih madein, “Qee, eu uqa qee qa uqa fecnu eu uqa cinigwe,” ein. Odocob dana eu uqadodoc maaden, “Ija dana eu ijom,” aden. ");
INSERT INTO aey_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Odocob age sisildoin, “Amen adi fogo doia?” doin. ");
INSERT INTO aey_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Odocob uqa maaden, “Dana uqa ijan Jisas uqa olig mimei ija amina cucusimei maten, ‘Hina Siloam wa cagocna limeg hina amen wasacudagale,’ ten. Mateceb ija li ami wasacudecemin ami fogo docob qila me feciigina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Odocob age sisildoin, “Dana eu ana?” doin. Uqa maaden, “Ija qee dugina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Odocob age dana uqa wele ameg galuc mec bilen eu ehudi Farisi cemenega mudein. ");
INSERT INTO aey_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aria, Jisas olig mimei dana eu ameg me mudeceb fogo don eu Juda agena cuha deelna. ");
INSERT INTO aey_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ono Farisi ageha dana eu hina amen adi fogo doia ec sisildoin. Odocobil uqa maaden, “Uqa olig amina cucuseceb ija limig ami wasacudecemin qila me feciigina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Odocob Farisi leih madein, “Dana eu uqa cuha deel qee mudina. Eunu uqa Anutnadec qee hol,” ein. Euqa leih age madein, “Dana silail mec adi kobolkobol eu odocnu ihoc?” ein. Odimeig age am qatani lecisdoin. ");
INSERT INTO aey_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Odimeig age dana ameg galuc mec me muden eu haun sisildoin, “Uqa hina amen me mudeceb fogo doiannu hina uqanu eeta madagana, uqa in?” doin. Odocob uqa maaden, “Uqa je hahun madec dana oso,” aden. ");
INSERT INTO aey_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Juda dana age dana eu uqa wele ameg galuc mec bilen, qila ameg me feciena ec eunu wawaga qee meleel, age feeecnu odi odoin. Eunu dana eu memeg anagca utaalecebil hocobil ");
INSERT INTO aey_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","sisilali maalein, “Dana eu ale melemelafo, ale uqa anag waugnadec ameg galuc mec cali hu bilen ec madesina? Eu melefi adi qila feciena?” alein. ");
INSERT INTO aey_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Odocobil memeg anagca maadesin, “Uqa ele melemile eu dowona. Uqa ameg galuc mec cali hon euha dowona. ");
INSERT INTO aey_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Euqa uqa qila adi odocob feciena, in odudeceb ameg fogo duton eu ele qee dowona. Uqa sim qee, uqadodoc saadecnu ihoc. Age uqa sisildu feiga,” adesin. ");
INSERT INTO aey_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Juda age wele madi cagoin ec madein, “Oso Jisasnu uqa Anutna Krais ec madecebfi ege uqa cuha jonadec ititacdocomun tamanecna qee biliaun,” ein. Eunu uqa memeg anagca ale Juda dananu cucuiesinnu odi madesin. ");
INSERT INTO aey_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Eunu uqa memeg anagca maadesin, “Uqa sim qee, age uqa sisildu feiga,” adesin. ");
INSERT INTO aey_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Odocobil Juda dana age haun lecisdu dana uqa ameg galuc mec bilen eu utadocobil hocob madoin, “Ege dana eu uqa silail mec dana eu doqona. Hina Anut amenna je tutuc magecnu madagale!” doin. ");
INSERT INTO aey_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Odocobil uqa maaden, “Uqa silail mec danafo ija qee dugina. Euqa ija wele ami galuc mec bilem, qila ija me feciigina eu ija dugina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Age haun sisildu madoin, “Uqa adi odihen? Adi amen fogo duhen?” doin. ");
INSERT INTO aey_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Odocobil uqa maaden, “Ija age wele maadiga. Euqa age qee dah melein. Age eetanu haun magecem doqa tegina? Ageha uqana malogom ibuldoqaganfa?” aden. ");
INSERT INTO aey_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Odocob age cewudodoig madoin, “Hina uqana malogom, egeqa Mosesna malogom. ");
INSERT INTO aey_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anut Mosesca je madesin eu egeha doqona, euqa dana eu uqa anadec hon eu ege qee doqona!” doin. ");
INSERT INTO aey_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Odocobil uqa jejenega hewi maaden, “Eu adi bahic! Age uqa anadec hon eu ege qee doqona egina euqa uqa ija ami fogo duten! ");
INSERT INTO aey_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Anut uqa silail dana agena je qee dah mena eu ege doqona. Euqa oso uqa Anut binan susuli uqa jejeg toodudu odona eu uqa Anut je madocob dah mena. ");
INSERT INTO aey_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Anut maha ifanen euna gug qumeig cisdudu hu qila calimeig dana oso anag waugnadec ameg galuc mec cali hon eu dana oso hu ameg fogo duton cocobon oso qee dogina. ");
INSERT INTO aey_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dana eu Anutnadec qeemi uqa ceteh oso odocwe qee,” aden. ");
INSERT INTO aey_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Odi maadeceb age madoin, “Hina silail jahulheceb anin basihen. Hina ege iwalgeganfo?” dumeig cuha jonadec ititacdocobil nuen. ");
INSERT INTO aey_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Juda age dana eu cuha jonadec ititacdoinnu Jisas dah mimei uqa dana eu wawali gulucdumei sisildon, “Hina Dana Melahnu wawin meleenafo?” don. ");
INSERT INTO aey_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Odocob dana Jisas jejeg hewi madon, “O Tibud, ija uqanu wawi meleigiannu Dana Melah eu in?” don. ");
INSERT INTO aey_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Odocob Jisas madon, “Hina eu fem. Uqa je mahena eu uqa,” don. ");
INSERT INTO aey_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Odocob dana uqa Jisas madon, “O Tibud, ija wawi meleena!” don. Odimei uqa Jisas amegna gob cehimei uqanu cuha fen. ");
INSERT INTO aey_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Odocob Jisas je odi maden, “Ija dana amaga galuc mec eundec amaga fogo doc oqagannuca, dana age me fegina eu amaga cufa qugiannuca mahana nem. Eunu ija dana gesiladecnu mahana nem,” en. ");
INSERT INTO aey_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisi leih age Jisas je eu mamaden dah mimeig madoin, “Egeha amige galuc menfo?” doin. ");
INSERT INTO aey_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Odocob Jisas maaden, “Age amaga galuc mec biloubmi silail oso dewenega fagdoc qee tawoub. Ageqa ege me foqona egina eunu agena silail dewenega fagdocob cobogina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas maaden, “Ija je mele maadigina, dana oso uqa sipsip agena jona jic cebecna qee lenaqa, filna leti lena, eu uqa heje dana, uqa dana agena ceteteh heje cedena. ");
INSERT INTO aey_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Dana uqa sipsip agena jona jic cebecna lena, eu uqa sipsip cofadec dana. ");
INSERT INTO aey_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jic cebec cofdoc uqa dana i jic huditona. Sipsip age uqa jejeg dah megina. Uqa uqana sipsip ijanaga uutaadimei ehadimei aquniaadi calena. ");
INSERT INTO aey_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Uqa uqana sipsip cunug ehadi maha gumuna madimei uqa aquniaadi cobona. Odocob age uqa jejeg doginanu age uqa toodudu hogina. ");
INSERT INTO aey_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sipsip age dana filna jejeg qee dogina. Eunu age dana fil qee toodogina, euqa age uqa cuculdi busalegina,” aden. ");
INSERT INTO aey_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas uqa galolo je i odi maaden ageqa je eu silig qee doloin. ");
INSERT INTO aey_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Eunu Jisas haun maaden, “Ija je mele maadigina, ija sipsip agena jic cebec. ");
INSERT INTO aey_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ija qee hoc ninijen cunug hoin eu age heje dana, age dana agena ceteteh heje cedegina. Euqa sipsip age jejenega qee dah melein. ");
INSERT INTO aey_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ija jic cebec. Oso ijaca hu dunuhna lena eu Anut uqa cahahadugian. Odocob uqa dunuh leceb maha gumu cali hocob uqa eu odi lili huhui sab gulucdugian,” aden. ");
INSERT INTO aey_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Heje dana uqa heje ocnuca, aqecnuca, fadaladecnuca hona. Ijaqa sipsip age cebac bilec umeig agena cebac bilec ihoc lec eu gulucdoqagannu hom. ");
INSERT INTO aey_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ija sipsip cofadec me. Cofadec me uqa uqana cebac bilec uqana sipsipnu culina. ");
INSERT INTO aey_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Cabi dana qaig ocnu cabi ona, sipsip age uqa toinan qee, eu uqa qa cus hohon fimei sipsip cuculadi busalena. Odocob qa cus sipsip hewadi bilisaadena. ");
INSERT INTO aey_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Dana i u